﻿USE sofia;
DROP TABLE IF EXISTS sofia.bkw_vpl;
CREATE TABLE bkw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bkw_vpl WRITE;
INSERT INTO bkw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Beeka dhaad ɛ Yezu Klisto, dha ɛ Abalaam, dha ɛ Dhavid e: ");
INSERT INTO bkw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ye ɛ́ Abalaam ɛ nabya Izak, Izak ɛ nabya Zakɔɔb, Zakɔɔb kabya yɛ ɛ Yuda nɛ bɔn nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tin, Yuda ɛ nabya Pɛlɛɛz bɛ nɛ Zeedas. Din ɛ nyɛɛg'ɔɔ nabɛ ɛ́ Tamaad. Pɛlɛɛz kabya ɛ Eslɔm, Eslɔm kabya yɛ ɛ Alam. ");
INSERT INTO bkw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Mɔn Alam kadi ɛ́ Aminadaab, Aminadaab nakabya yɛ ɛ Naasɔn. Naasɔn kabya ɛ Salman. ");
INSERT INTO bkw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salman naazɛbya Bhoaaz bɛ nɛ myɛl Layaab. Bhoaaz bɛ nɛ ngbɛ myɛl Luth nakabya ɛ Obɛɛd. Obɛɛd nakabya ɛ Yese, ");
INSERT INTO bkw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ɛ́ nabya mɛkoozi Dhavid. Mɛkoozi Dhavid naabya Salomɔŋ, nyɛ nabya Salomɔŋ ɛ bɛ nɛ mwaa Wyiili. ");
INSERT INTO bkw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔŋ nabɛ ɛ́ sɛɛg ɛ Loboam, Loboam nakabya yɛ ɛ Abiya, Abiya kazɛbya yɛ ɛ Asaf. ");
INSERT INTO bkw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf nazɛbya ɛ́ Yozafat, Yozafat kabya yɛ ɛ́ Yolam, mɔn Yolam nabɛ ɛ́ Ozias. ");
INSERT INTO bkw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozias nadi ɛ́ sɛɛg ɛ Yotam, Yotam kabya ɛ́ Akaaz, Akaaz eezɛbya Ezekias. ");
INSERT INTO bkw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekias kabya ɛ́ Manase. Manase kabya yɛ ɛ́ Amɔn, Amɔn nakabya yɛ ɛ́ Yosias. ");
INSERT INTO bkw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosias kadi ɛ́ sɛɛg ɛ Yekonia nɛ bɔn nyɛɛg. Tin ɛ bɛ nazɛtɔ́ é ekwom pɛ kyee dik Bhabhilɔn. ");
INSERT INTO bkw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bhii bɔn Yisalaɛl natɔ́ é ekwom pɛ kyee dik Bhabhilɔn ɛ, Yekonya nakabya ɛ́ Salatyɛl, bhii tak Salatyɛl eezɛbya Zolobabɛl, ");
INSERT INTO bkw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolobabɛl kabya yɛ ɛ́ Abyuud, Abiyuud nabɛ ɛ́ sɛɛg ɛ Elyakim, Eliyakim kadi ɛ́ sɛɛg ɛ Azɔɔd; ");
INSERT INTO bkw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔd eezɛbya Sadɔk, Sadɔk kabya ɛ́ Akim, mɔn Akim kadi ɛ́ Eliyuud. ");
INSERT INTO bkw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuud kadi ɛ́ sɛɛg ɛ Eleazaad, Eleazaad kabya ɛ́ Matan. Matan eezɛbya Zakɔɔb, ");
INSERT INTO bkw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔɔb kadi ɛ́ sɛɛg ɛ Zozɛf ngom ɛ Maali. Ye ɛ́ Maali tak ɛ nabya Yezu bot di edjóo Mɛsia ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tinaak, kana kɔkɔ mɛbyel ɛ Abalaam, kɛyaka nɛ yɛ Dhavid, ye nabɛ ɛ́, ye naasa tyee ekɔkɔ e mɛbyel kam nɛ ená. Ye naabaasa tyee ekɔkɔ e mɛbyel kam nɛ ená kana ɛbyel ɛ Dhavid, kɛyaka nɛ membu mɛ bɔn Yisalaɛl natɔ́ é ekwom pɛ Bhabhilɔn ɛ. Kana membu mɛ bɔn Yisalaɛl natɔ́ é ekwom pɛ Bhabhilɔn ɛ kɛyaka nɛ ɛbyel ɛ Mɛsia, ye naasa tyee ekɔkɔ e mɛbyel kam nɛ ená. ");
INSERT INTO bkw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gwakeka ɛsuk ɛ ɛbyel ɛ Yezu Klisto. Maali nyɛɛg nabɛ ɛ́ ghɔɔd ɛ Zozɛf. Ɛsok nɛ bɛ nɛ di moma nɛ motom, ye nabɛ ɛ́, Maali eezɛbela ɛbum nɛ ghwyil ɛ Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zozɛf, mwaaz'ɛ nabɛ ɛ́ mot epiki, nyɛ nabɛ ɛ́ ààkwyɛl ɛdhusal nyɛ é mis mɛ bot. Nyɛ ɛ́ boozɛke náá, emwaaz bɛ nɛ Maali si tɔ syaab. ");
INSERT INTO bkw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dáa nyɛ nadi esiiza deenek ɛ, dhiiti fofop ɛ Ghɛŋ ngɔt eezɛtuula nyɛ tɔ dhyam, nyɛ eezɛke nɛ nɛ náá: «Zozɛf, dha ɛ Dhavid, nàbem ba étɛp ɛba Maali, etɛɛ náá, ye ɛ́ nɛ ghwyil Sisim na Dɛɛ ɛ, nyɛ bela ɛbum. ");
INSERT INTO bkw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nyɛ waabya mɔn mɔɔ motom, bi aaget nyɛ ɛ Yezu, etɛɛ náá, nyɛy ɛ́ kwaatsik bot ɛ mbyak'ɛ tɔ mesyem mɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Esesɛɛ binek djas aasael ɛ, etɛɛ náá, etɛp djas Ghɛŋ nalɛɛ tɔ nuub ɛ ngoolel-mɛkpa ɛ Zɛɛb neebela ɛsuk. Ye nabɛ ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Mɔn ɛsyes ɛ moma di ààgu botom ɔ waabela ɛbum. Bhii tak, nyɛ waabya mɔn mɔɔ motom, nyɛ aaget nyɛ ɛ́ Emanuɛl.» Ye kwyɛl ɛlɛɛ ɛ́: «Zɛɛb ɛ́ nɛ nena.» ");
INSERT INTO bkw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Dáa Zozɛf kadjem é gɔ ɛ, nyɛ zokasa ɛ́ dáa fofop ɛ Ghɛŋ nalɛɛ nyɛ ɛ, nyɛ ɛ́ boozɛbeeb myɛl Maali. ");
INSERT INTO bkw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tin, nyɛ nabɛ ɛ́ ààsɛɛga goŋ bɛ nɛ myɛl kɛkum dwoo myɛl nabya mɔn motom, Zozɛf naget Yezu ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yezu nabyel ɛ́ pɛ dɛl ɛ Bheteleɛm pɛ kyee dik Yude é ghɛŋ Elood nadi mɛkoozi ɛ. É ghɛŋ tak, ye nabɛ ɛ́, bɛtsoŋ ɛ bot naadus pɛ kyee ɛdjem ɛ dwoo, kum pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tin, bɛ moo zɛdji náá: «Mɛkoozi mɛ eYuda, mɔn di náá, nyɛ ààloo nɛ ɛbyel ɔ, nyɛ ɛ́ wo? Bis eebee kwyikwyen yɛ edus pɛ ɛdjem ɛ dwoo, bis ɛ́ bookazyɛ zɛduwal nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Dáa mɛkoozi Elood nagwak deenek ɛ, ye nabɛ ɛ́, ye naakpaa nyɛ lyem ɛbuɛpe dɔɔ nɛ bot ɛdi kɔ ghaada Yeluzalɛm ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wɔ gwaa nyɛ zɛdjóo bot ɛ nadi kɔ elo eboo bɛghaa-Zɛɛb ɔ djas, nɛ bɛghaŋ ɛ mɛkana mɛ etsi djas, nyɛ needji bɛ di Mɛsia di esiŋa nɛ ɛbyel ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɛ eezɛbɔɔza nɛ nɛ náá: «Pɛ Bheteleɛm, pɛ kyee dik Yude etɛɛ náá, ngoolel-mɛkpa ɛ Zɛɛb nakwyal ɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Wɔy Bheteleɛm, kyee dik Yude Nɛ tsɛɛtsɛ wɔ tok nɛ ghwyil ɛbyaselaa pɛ kɔ mɛl mɛ di kɔ kyee dik Yude ɛ, etɛɛ náá, kɔ lɔ'ɛ aapaawyis boo kukuma mot aadjɛɛd mbyak'am Yisalaɛl ɔ.”» ");
INSERT INTO bkw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Deenek, wɔ gwaa, mɛkoozi Elood zɛdjóo bɛtsoŋ ɛ bot binɔk tɔ syaab. Tin, bɛ eezɛlɛɛ nyɛ sum di nɛ ɛwala ɛ kwyikwyen tak nanyen tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bhii tak, nyɛ eezɛlwom bɛ pɛ Bheteleɛm. Nyɛy nɛ nɔɔ náá: «Tɔ́ka kɛsaa, da bi ɛ́ gu etɛp djas dum nɛ mɔn tak, dɔɔ nɛ zeza nɛ di nyɛ di ɔ. Bi ɛ́ bela ɔɔ, da bi ɛ́ lɛɛ mɛ, etɛɛ náá, mam pe neezyɛ, zɛduwal nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bhii bɛ nazegwak dáa mɛkoozi nalii nɛ nɔɔ ɛ, bɛ eezɛnɔɔ mɛnyel dhaa yɔɔ. Tin, kwyikwyen bɛ nadi ebee pɛ ɛdjem ɛ dwoo ɛ, moo kɛ pɛ sok bhwoob'ɔɔ pɛ ɛko, é sok bɛ nakum zeza nɛ di mɔn tak nadi ɛ́, Wɔ gwaa kwyikwyen zɛtyaa piki, é di wat, ààkabaakɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Dáa bɛ nabee kwyikwyen ɛ, bɛ nabɛ ɛ́, bɛ naamyaala ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhii tak, bɛ eezɛni tɔ ndjaa, zɛbela mɔn bɛ nɛ nyɛɛg Maali tin. Wɔ gwaa, bɛ zɛkwyit mɛboŋ si étɛp ɛduwal mɔn. Bhii tak, bɛ eezɛkɛɛ mɛkɔm mɔɔ. Bɛ eezɛpɛk nyɛ nɛ elɔɔd, nɛ bɛmɛnanas di edikaa tɔ du ɛ, zɛnɔɔ mul mɛ di djóoaa miid ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bhii tak, wɔ gwaa Zɛɛb zɛlu bɛ tɔ dhyam náá, bɛ nàdhaa pɛ daa Elood. Tin, é ɛsik ɛ lɔɔ pɛ dɛl ɛ lɔɔ, bɛ nakadhaŋ ɛ́, pɛ ze sis. ");
INSERT INTO bkw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bhis bɛtsoŋ ɛ bot binɔk natɔ́ ɛ, fofop ɛ Ghɛŋ ngɔt eezɛtuula Zozɛf tɔ dhyam. Nyɛy nɛ nɛ náá: «Wyɛla. Nɔŋa mwalɔ nɛ mɔn, da bi ɛ́ kaab, tɔ́, kɛsɔwa pɛ Eziptɛ. Kɛdi penek, kɛkum dwoo mɛ aake náá, wɔ bula ɛ. Etɛɛ náá, Elood ɛ́ waasaa mɔn étɛp nyɛ neegó nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tin, Zozɛf ɛ́ boozɛwyɛl, nɔɔ mɔn nɛ myɛl, zɛkaab pum-ɛ-pum, tɔ́, kɛsɔwa pɛ Eziptɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Zozɛf zokadi penek ɛ kɛkum ɛlu ɛ ɛsyee ɛ Elood. Ye nasɛɛ deenek ɛ, etɛɛ náá, etɛp ee Ghɛŋ naloolɛɛ tɔ nuub ngoolel-mɛkpa mɛ ɛ, neebela ɛsuk. Ye nabɛ ɛ́ náá: «Mɛ eedjóo mɔn'am étɛp nyɛ neewyis tɔ dɛl ɛ Eziptɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bhis Elood nazɛgu náá, bɛtsoŋ ɛ bot binɔk naakɔɔ nyɛ ɛ, nyɛ naazɛbiyo ɛlyelɛpe. Wɔ gwaa nyɛ zɛdjɛ ɛlee nɛ bot bɛ náá, bɛ tɔ́ pɛ Bheteleɛm nɛ mɛl mɛ di é mengwoob ɛ djas, kɛgó bɔn botom djas di náá, bɛ dinaa ààpaakum membu membá ɔ. Etɛɛ náá, ndem bɛtsoŋ ɛ bot nalɛɛ nyɛ ɛ, ye nabɛ ɛ́ náá, mɔn tak nadi ɛ́, tɔ lɔɔg membu menek. ");
INSERT INTO bkw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tin, etɛp ee ngoolel-mɛkpa ɛ Zɛɛb Zelemi nalɛɛ ɛ́ boo zɛbela ɛsuk. Nyɛ nabɛ ɛ́, nyɛ naake náá: ");
INSERT INTO bkw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Etsim ɛpegék pɛ dɛl ɛ Lama; etsim e boo mɛgwyɛ nɛ mezuk. Ye ɛ́ Lasɛl ɛ di edje bɔn bɛ. Nyɛ aanàkwaakat ɛgwyɛ, etɛɛ náá, bɔn tokapɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bhis ɛsyee ɛ Elood, fofop ɛ Ghɛŋ ngɔt eezɛtuula Zozɛf tɔ dhyam pɛ Eziptɛ. ");
INSERT INTO bkw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nyɛy nɛ nɛ náá: «Wyɛla. Nɔŋa mwalɔ nɛ mɔn, da bi ɛ́ sik pɛ kyee dik Yisalaɛl etɛɛ náá, bot djas nadi ekwyɛl ɛgó mɔn'ɔ ɔ, bɛ eezesi “bhɛɛɛ”.» ");
INSERT INTO bkw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tin, Zozɛf ɛ́ boozɛwyɛl, nɔɔ mɔn nɛ myɛl sik pɛ kyee dik Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tinaak, dáa nyɛ nagwak náá, Alselaɔs naadjila sɛɛg Elood kɔ bóó mɛkoozi pɛ Yude ɛ, bwoo naasa nyɛ é ɛtɔ́ pɛ yiizaag. Zɛɛb ɛ́ boobaazɛdjɛ nyɛ mɛlyo mɛsis tɔ dhyam. Tin, nyɛ eezɛtɔ́ pɛ dhiiti dɛl ɛsis, pɛ kyee dik Ghalile. ");
INSERT INTO bkw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nyɛ ɛ́ boozɛtɔ́ kɛdi pɛ dhiiti dɛl, din ɛ dɛl ɛ tak ɛ́ Nazalɛt. Ye nasɛɛ deenek ɛ́, etɛɛ náá, dhiiti etɛp ee Zɛɛb nalɛɛ tɔ enuub e bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɛ, neebela ɛsuk. Ye nabɛ ɛ́ náá: «Bɛ aadjóo nyɛ mot Nazalɛt.» ");
INSERT INTO bkw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","É ghɛŋ tak ye nabɛ ɛ́ Zaŋ Nduuel-bot eetuula tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ e kyee dik Yude. Nyɛ nadi elyo ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Liigka elyem bin, etɛɛ náá, Ɛyoŋ ɛ di tɔ gwoo ɛ, yɛ eezekunaa!» ");
INSERT INTO bkw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ngoolel-mɛkpa Ezayi nalii étɛp'ɛ ɛ́ náá: «Mot ngɔt ɛpetuud kɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ náá: “Koobalka mɛze ɛ Ghɛŋ! Tuuka nyɛ mɛze mɛ na looba-looba!”» ");
INSERT INTO bkw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kaad Zaŋ nadi ebɔt ɛ nasael ɛ́ nɛ mya mɛ boo yaaga kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. Nyɛ nabɛ ɛ́ nɛ bhɛtɛ ket é kuu. Nyɛ nadedɛ ɛ́ etsemaaka nɛ egho. ");
INSERT INTO bkw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bot ɛ ghaada Yeluzalɛm nɛ bot ɛ kyee dik Yude djas, zɛnɔɔ bot ɛ nadidi mbaka-mbaka nɛ dii Yuldɛn ɔ nadi ezyɛ pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bɛ nadi evaa mesyem mɔɔ é mis mɛ bot. Bhii tak ɔ, Zaŋ zɛduu bɛ Zɛɛb tɔ dii Yuldɛn. ");
INSERT INTO bkw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dáa Zaŋ nabee náá, bɛtɛ nɛ eFalizyɛ nɛ eSaduseɛ nadi ezyɛ pɛ daa lɛ ɛbuɛpe zɛduwa Zɛɛb ɛ, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Biyɔ mbyak mɛgel mak! Ɛzɛ lyo bin náá, bi kaab ɛbuk ɛ Zɛɛb ze kunaa nɛ ɛzyɛ enek? ");
INSERT INTO bkw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Lyaalka nɛ esesɛɛ bin náá, ye ɛ́ tsɛɛtsɛ náá, bi eezeliig elyem bin. ");
INSERT INTO bkw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Betka ɛke biyɔ nɛ biyɔ náá: “Dhiiti sonok aanàkwaasa mena, etɛɛ náá: Abalaam ɛ́ bhaab'enaka.” Etɛɛ náá, Zɛɛb ɛ́ nɛ ghwyil ɛliig mɛkok mak ye liiza bɛdha ɛ Abalaam. ");
INSERT INTO bkw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ye nyɔ ɛ́ bi gu náá, zoŋ moo ɛ́ nɛɛga é ɛbok ɛ le étɛp ye neetsaal ekaŋal e tak. Ele ee di ààdjɛ mbɛɛ bhum ɔ djas, goka ɛ́ nɛ ɛkwyalaa. Bhii tak, da ye ɛ́ kɛmwasaa tɔ du. ");
INSERT INTO bkw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Ye ɛ́ tsɛɛtsɛ náá, mam duu bin Zɛɛb ɛ́ tɔ mɛdii, étɛp ye neelyaal náá, bi eezeliig elyem. Yɛ kabɛ mot di zyɛ bhis'am ɔ, nyɛ aaduu bin Zɛɛb ɛ́, tɔ ghwyil Sisim na Dɛɛ nɛ du. Nyɛ eedhaa mɛ nɛ mɛbwala. Mam aanàkwaakobela-bela duu ɛmalal étɛp ɛkotii-tiiak ekel ekoko bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tɔ mɛmbɔ mɛ, nyɛ eemɛt wal étɛp nyɛ neewa mbɛk pak ezeeza nɛ bhum. Ezeeza pak wat, mbɛɛ bhum yak pak. Tin, nyɛ waakwom mbɛɛ bhum tɔ taa. Yɛ kabɛ ezeeza ɔ, nyɛ kakɛmwas yɛ ɛ tɔ du na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dhiiti dwoo Yezu naazɛdus pɛ kyee dik Ghalile zɛkum pɛ dii Yuldɛn pɛ kyee Zaŋ nadi ɛ́, étɛp nyɛ needuwa Zɛɛb dáa Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Wɔ gwaa Zaŋ zɛbyen yɛ. Nyɛy nɛ nɛ náá: «Ye ɛ́ mam ɛ di egoka nɛ ɛzyɛ, zɛduwa Zɛɛb pɛ daa lɔ. Ghuna ye ɛ́ wɔy ɛ́ kazyɛ pɛ daa lam e!» ");
INSERT INTO bkw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yezu eezɛbɔɔza nɛ nɛ náá: «Wɔ goka ɛ́ wɔ myaal náá, ye sɛ́ɛ deenek é ɛwala ɛlak. Etɛɛ náá, deenek mena sa ɛ́ ɛkwosak ɛ Zɛɛb.» Tin, Zaŋ ɛ́ boo zɛmyaal. ");
INSERT INTO bkw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Dáa Yezu naduwa Zɛɛb ɛ, wyisa nyɛ nazowyis tɔ mɛdii ɛ, é di tak wat, wɔ gwaa gwoo zɛbɛŋel kɔ ɛko ɛ lɛ. Bhii tak, Sisim na Dɛɛ eezyɛ, zɛsul kɔ lɛ tyee ɛghum. ");
INSERT INTO bkw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Dhiiti gwood eezɛgék tɔ gwoo náá: «Nwyak ɛ́ mɔn'am mɛ di kwyɛl ɔ. Mɛ eedyeebamyaala nɛ nɛ ɛbuɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Bhii tak, Sisim Zɛɛb eezɛwyel Yezu, tɔ́ nɛ nɛ pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, etɛɛ náá, Dim mot mɛkɔŋ neekɛwa nyɛ tɔ mɛbhowal. ");
INSERT INTO bkw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dáa nyɛ nazɛtsi edee étɛp mendjaala tyee mɛlu mɛkam-mɛná nɛ epum mɛkam-mɛná ɛ, za naazɛsa nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tin, Satan, Mot mɛbhowal eezɛtiila pɛ daa lɛ. Nyɛy nɛ nɛ náá: «Yɛ bɛ náá, wɔ ɛ́ Mɔn ɛ Zɛɛb ɔɔ, kea nɛ mɛkok mak náá, ye liiza emapa.» ");
INSERT INTO bkw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yezu eezebɔɔza nɛ nɛ náá: «Ekwyala ɛ Zɛɛb lɛɛ ɛ́ náá: “Ye tok emapa nɛ emapa di esa náá, mot di nɛ tsik. Mot tsak ɛ́ nɛ mɛkpa djas di edus tɔ nuub Zɛɛb ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Bhii tak, Dim mot mɛkɔŋ eebaazɛtɔ́ nɛ nɛ pɛ Yeluzalɛm ghaada na dɛɛ. Nyɛ eezɛgel nyɛ kɔ nges Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nyɛy nɛ Yezu náá: «Yɛ bɛ náá, wɔ ɛ́ Mɔn Zɛɛb ɔɔ, tsela, da wɔ ɛ́ kɛduma pɛ si, etɛɛ náá, ekwyala ɛ Zɛɛb lɛɛ ɛ́ náá: “Kɔ ɛsu ɛ lɔ, Zɛɛb ɛ́ waake nɛ efofop bɛ náá: Bɛ bɛp wɔ nɛ mɛmbɔ mɔɔ, é kaab náá, wɔ ɛ́ zɛkɛbema ɛbɛk.”» ");
INSERT INTO bkw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Ekwyala baalɛɛ ɛ́ náá: “Sa wɔ ààwa Ghɛŋ Zɛɛb'ɔ tɔ mɛbhowal.”» ");
INSERT INTO bkw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Dim mot mɛkɔŋ eebaazɛnɔɔ nyɛ, tɔ́ nɛ nɛ pɛ kɔ dhiiti ɛtsok ɛ na vyɛɛgvyɛɛg. Nyɛ eezɛtel nyɛ mɛyoŋ mɛ bɔs djas nɛ mɛkas nɛ enɛm tak djas. ");
INSERT INTO bkw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Dim mot mɛkɔŋ eezɛke nɛ nɛ náá: «Mɛ waadjɛ wɔ esesɛɛ bak djas, wɔ kwyit mɛboŋ mɔ si mɛko mam, da wɔ ɛ́ duwal mɛ ɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","É di'enek, Yezu ɛ́ boozɛke nɛ nɛ náá: «Dusa tin, Satan! Etɛɛ náá, ekwyala lɛɛ ɛ́ náá: “Ye ɛ́ Ghɛŋ Zɛɛb'ɔ ɛ́ wɔ di egoka nɛ ɛduwal. Wɔ goka nɛ ɛsa ɛ́ mɛsa mɛ met.”» ");
INSERT INTO bkw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","É sok'enek, Dim mot mɛkɔŋ eezɛbet nyɛ, nyɛ eezɛtɔ́ yɛ. É di'enek, wɔ gwak efofop zokazyɛ zɛkwyee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bhis Yezu nagwak náá, Zaŋ naamɛtaa é mbok ɛ, nyɛ naazɛtɔ́ pɛ Ghalile. ");
INSERT INTO bkw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nyɛ nabɛ ɛ́ ààkosulal kɔ ghaada Nazalɛt. Tin, nyɛ nakwos ɛ́ ɛkɛdi pɛ ghaada Kapɛlnaum, ghaada tak nadi ɛ́ mbaka-mbaka nɛ boo soob na djato-djato Ghalile, pɛ pak kyee dik ɛ Zabulɔn nɛ Neftali. ");
INSERT INTO bkw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nyɛ nasa deenek ɛ́, etɛɛ náá, etɛp ngoolel-mɛkpa Ezayi nalɛɛ ɛ́ neebela ɛsuk: ");
INSERT INTO bkw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ekyee mɛdhik mɛ Zabulɔn nɛ Neftali pɛ kyee ze boo soob na djato-djato pɛ yii kyiid dii Yuldɛn, Ghalile, pɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda di ɔ! ");
INSERT INTO bkw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mbyak di tɔ ghooghom ɛ waabee boo ngel gwyɛ é kas tɔ lɔɔ! Dɔɔ nɛ bot ɛ di ekɔɔla tɔ ghooghom pɛ kyee dik ɛsyee ɔ, gwyes ɛ́ waakas kɔ lɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kana ɛwala ɛlenek, Yezu naazɛkan ɛlyo bot náá: «Liigka elyem, etɛɛ náá, Ɛyoŋ ɛ di tɔ gwoo ɛ, yɛ eezekunaa!» ");
INSERT INTO bkw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dhiiti dwoo Yezu nadi ekɛ mbaka-mbaka nɛ boo soob na djato-djato e Ghalile. Dáa nyɛ nabee bɛlael ɛ mɛwyet bɛbá, dhyeeb nɛ tel, bɔɔ ela mɛwyet ɛ. Bot ɛ tak nabɛ ɛ́ Simɔŋ, mot nagetaa Pyɛɛd ɔ, zɛnɔɔ dhyeeb Andele ela ɛwyet tɔ dii. ");
INSERT INTO bkw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tin, Yezu eezɛke nɛ nɔɔ náá: «Duka mɛ, mɛ waasa náá, bi di bɛlael ɛ mɛwyet étɛp ɛmɛt ɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","É di'enek wat, bɛ eezɛdhuugal mɛwyet mɔɔ, étɛp ɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bhii Yezu nakɛ ba «zii» ɛ́, nyɛ eezɛboma nɛ bɛdhiiti bot ɛsis, dhyeeb nɛ tel, Zak bɛ nɛ mɔn ɛ nyɛɛg Zaŋ, bɔn ɛ Zɛbɛdɛ. Bɛ nadi ɛ́ tɔ elɛɛd, ekoobal mɛwyet mɔɔ, bɛ nɛ sɛɛg'ɔɔ. Tin, Yezu eezɛdjóo bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","É di'enek wat, bɛ eezɛdhuugal elɛɛd nɛ sɛɛg'ɔɔ, bɛ eezɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tin, Yezu naazɛtɔ́ pɛ kyee dik Ghalile djas, nyɛ nadi edjɛ mɛlyo tɔ mendjaa mɛ mendjaala mɛ eYuda nadi pɛ kyee dik tak ɛ. Nyɛ nadi egoola Mbɛɛ Bhaadal dum nɛ Ɛyoŋ ɛ Zɛɛb, nɛ ɛbaatsik bot ɛ nazyɛ nɛ mɛbɛ́ membi nɛ membi ɔ nɛ bot ɛ nadi nɛ edjam ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ye nabɛ ɛ́, menduk mɛ naakɛ kɔ kyee dik Siili djas. Bɛ ɛ́ boodi zezyɛ nyɛ nɛ bot ɛ nadi nɛ mɛbɛ́ membi nɛ membi ɔ, nɛ bot ɛ embee esisim nadi edhe-dhek ɔ, dɔɔ nɛ bot ɛ nadi ebil djem ɔ nɛ eboka e bot. Yezu zokatsik bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɛdhuu mɛ bot ɛ nadi edu nyɛ ɔ, nadudus ɛ́ pɛ Ghalile, pɛ pak eghaada kam, pɛ ghaada Yeluzalɛm, pɛ Yude nɛ bot ɛ kyee dik nadi pɛ yii kyiid dii Yuldɛn ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Dáa Yezu nabee ɛdhuu ɛ bot binɔk ɛ, nyɛ naazɛbyet kɔ ɛtsok, nyɛ eezɛnɔɔ nyel'ɛ, disi. Bɛdjekel bɛ eezɛdisi e ngwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nyɛ eezɛni é djɛ bɛ mɛlyo: ");
INSERT INTO bkw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mɛnyɔ nɛ bɛdjel ɛ bot tɔ sisim, etɛɛ náá, Ɛyoŋ ɛ di tɔ gwoo ɛ, ye ɛ́ yɔbɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mɛnyɔ nɛ bot ɛ di edje nenak ɔ, etɛɛ náá, Zɛɛb ɛ́ waadis ghoŋ di tɔ elyem bɔɔ ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɛnyɔ nɛ bot ɛ di etela ɔ, etɛɛ náá, bɛ waabela kyee bɔs Zɛɛb nakɛk bɛ ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mɛnyɔ nɛ bot ɛ di nɛ za nɛ gwyes ɛsa ɛkwosak ɛ Zɛɛb ɔ, etɛɛ náá, bɛ waadɛ, djil! ");
INSERT INTO bkw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mɛnyɔ nɛ bot ɛ di gek bot ɛsis ghoŋ ɔ, etɛɛ náá, Zɛɛb ɛ́ waagek bɛ ghoŋ! ");
INSERT INTO bkw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mɛnyɔ nɛ bot ɛ di nɛ mbɛɛ elyem ɔ, etɛɛ náá, bɛ waabee Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mɛnyɔ nɛ bot ɛ di esaa egwyem pak'ɔɔ ɛ, etɛɛ náá, Zɛɛb ɛ́ waadiig bet náá, bɛ ɛ́ bɔn bɛ! ");
INSERT INTO bkw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mɛnyɔ nɛ bot ɛ di tɔ tsik mezuk ɔ etɛɛ náá, bɛ ɛpesa ɛkwosak ɛ Zɛɛb, etɛɛ náá, Ɛyoŋ ɛ di tɔ gwoo ɛ, ye ɛ́ yɔbɔ! ");
INSERT INTO bkw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mɛnyɔ nɛ nen, yɛ bɛ náá, bot ɛpelee bin ɔ, nɛ ɛwa bin tɔ tsik mezuk ɔ, bɛ di esu bin etɛp mbɛs ɔ, nɛ ɛbaasaab dék'en, étɛp'am ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Myaalaka, da bi ɛ́ bɔl zɛŋ, etɛɛ náá, boo etuud bin ɛ́ nɛɛga pɛ tɔ gwoo. Etɛɛ náá, ye ɛ́ deenek ɛ bɛ nazuk bɛngoolel ɛ mɛkpa ɛ Zɛɛb nazyɛ ɛsok nɛ nen ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ye ɛ́ biyɔ ɛ́ di mɛsɔn kɔ bɔs. Yɛ bɛ náá, mɛsɔn moo ɛ́, ààkagwom ɔ, ye goka ɛ́ nɛ ɛsaaa dáa étɛp mɛsɔn neebaagwom? Deenek mɛsɔn aakadi ɛ́, ààbɛ nɛ mɛsa mɛ yɛ aasaaa nɛ yɛ ɛ. Deenek, ye goka ɛ́ nɛ ɛmwasaa pɛ kel, da bot ɛ́ nyal yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ye ɛ́ biyɔ ɛ́ di mɛkas kɔ ɛko ɛ bɔs. Dɛl ɛ di suma kɔ ɛtsok ɔ, tok nɛ ghwyil ɛdi syela. ");
INSERT INTO bkw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wɔ aanàkwaatuub lama, da wɔ ɛ́ wa yɛ si bhe. Yɛ ààseaa deenek, ye goka nɛ ɛkɛlaa ɛ́, pɛ kɔ tɛɛg é di bot djas aadi tɔ gwyɛ tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Deenek ɛ́ di egoka náá, mɛkas men nyen tɔ bot, étɛp bot neebee mɛnyɔ mɛ esesɛɛ bi di esa ɛ, étɛp bɛ needuwal Sɛɛg'en di tɔ gwoo ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Nàkeka náá, mɛ nazyɛ ɛ́ zɛgó etsi ɛ Moiiz nɛ mɛlyo mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb nadjɛ ɛ. Mɛ nabɛ ɛ́ ààzyɛ zɛgó etsi, mɛ nazyɛ ɛ́ zɛlyaal mɛsuk mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Dáa ye di náá, gwoo nɛ bɔs dinaa ààpaadum ɛ, ye tok nɛ sa wat aadisaa tɔ etsi. Ye nakoozodi ba moo ɛtɔn nɛghu ba moo kyeeb, sa wat aanàdus tɔ etsi kɛkum dwoo mɛsik mɛ etɛp djas. ");
INSERT INTO bkw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Étɛp tak ɛ́ di náá, mot aazodis tsi wat, ye nakoozotɔɔl, da nyɛ ɛ́ lyo bɔn nyɛɛg náá, bɛ sa dáa nyɛ sa ɔ, yenɔk aadi ɛ́, mɔɔ dhyeeb tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ. Tin, mot di eduwal etsi da nyɛ ɛ́ lyo bɔn nyɛɛg náá, bɛ sa dáa nyɛy ɔ, yenɔk aadi ɛ́ boo-mot tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mɛ lɛɛ bin ɛ náá: Epiki bin é mis mɛ Zɛɛb ɛ́ di ààdhaa yii bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ ɔɔ, bi aanàkwaani tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ye nabɛ ɛ́, bi naagwak náá, nyɛ nake nɛ bɛbhaab bina náá: “Sa wɔ ààgó mot. Mot ɛ́ gó sɔ mot ɔɔ, ye goka ɛ́ ye tɔ́aa nɛ nɛ é mis mɛ bɛtetɛp, nyɛ neepɛ́ɛaa.” ");
INSERT INTO bkw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yɛ kabɛ mam ɔ, mɛ lɛɛ bin ɛ náá: Mot djas aagwak ɛbuk nɛ mɔn nyɛɛg ɔɔ, ye goka ɛ́ náá, bɛtetɛp pɛ́ɛ nyɛ. Mot aake nɛ sɔ mot náá, “wɔ ɛ́ wo ɔ”, nyɛ goka ɛ́ nyɛ tɔ́ kɛpɛ́ɛaa pɛ boo zɛɛga bɛtetɛp eYuda. Mot aake nɛ sɔ mot náá, “wɔ ɛ́ ndjemet ɔ”, ye goka ɛ́ náá, nyɛ kɛmwasaa tɔ du na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Yɛ bɛ náá, wɔ ɛpetɔ́ pɛ mesa ebuwa étɛp ɛkɛduwal Zɛɛb nɛ esa bɔ ɔɔ, tin, wɔ siiza náá, mɔn nyoog ɛ́ nɛ tɛp nyɛ di ebwak wɔ kɔ ɛsu ɛ tak ɔɔ, ");
INSERT INTO bkw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pookobet esa e duu tak kɔ mesa ebuwa. Da wɔ ɛ́ pookokɛgwakel nɛ mɔn nyoog. Bhii tak ɛ wɔ aakazyɛ, zɛkaa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Mot ɛ́ kɛpit wɔy ɔɔ, bi ɛ́ di etɔ́ pɛ dáa bɛtetɛp ɔɔ, lela ɛgwakel nɛ nɛ é di bi dinaa é ze yenek, é kaab náá, mot tak ɛ́ zɛkɛka wɔ é mis mɛ bɛtetɛp. Bhii tak, da bɛtetɛp ɛ́ djɛ wɔ é mɛmbɔ mɛ esodja, da bɛ ɛ́ wa wɔ é membok. ");
INSERT INTO bkw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Wɔ aanàkwaawyis tin, wɔ di ààtuud dɔɔ nɛ falanga ɛsik ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ye nabɛ ɛ́, bi naagwak náá: “Sa wɔ ààsa ɛzɔ.” ");
INSERT INTO bkw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tin, mam kalɛɛ nɛ nen ɛ náá, motom djas aagwyák mwaa sɔ, da ɛ́ wyeeb nyɛ tɔ lyem ɔ, yenɔk tak eezesa ɛzɔ nɛ moma tak tɔ lyem'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yɛ bɛ náá, ye ɛ́ dis ɛ kyee mbɔ eghɛŋ bɔ ɛ́ di ebelal wɔ náá, wɔ sa mesyem ɔ, wɔ goka ɛ́ nɛ ɛpiid ɛ yɛ, da wɔ ɛ́ mwas yɛ ɛtsetaɛpe. Yɛ aadi ɛ́, ɛnyɔɛpe nɛ nɔ náá, wɔ dis dhiiti kyee nyel'ɔ, ààkabɛ náá, wɔ kɛdyak tɔ du na kɔm-kɔm nɛ nyel'ɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yɛ bɛ náá, ye ɛ́, mbɔ eghɛŋ bɔ ɛ́ di esa náá, wɔ syem ɔ, tsaala yɛ, da wɔ ɛ́ mwas yɛ ɛtsetaɛpe nɛ nɔ. Yɛ aadi ɛ́, ɛnyɔɛpe nɛ nɔ náá, wɔ tsaal dhiiti kyee nyel'ɔ, ààkabɛ náá, wɔ kɛdyak tɔ du na kɔm-kɔm nɛ nyel'ɔ djas.» ");
INSERT INTO bkw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ye nabɛ ɛ́, bɛ naabaake náá: “Mot ɛpɛɛ myɛl ɔɔ, nyɛ goka ɛ́ nɛ ɛdjɛ nyɛ mɛkana mɛ ɛbel ɛ ɛba.” ");
INSERT INTO bkw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yɛ kabɛ mam ɔ, mɛ ke ɛ́ náá: motom djas di epɛɛ myɛl, ààmɛt nyɛ nɛ sa etsi di elu ɔ, motom tak saŋ ɛ́ náá, moma tak di moma mɛzɔ nyɛ baatɔ́ ɛba ɛ sis ɔɔ. Tin, motom aaba moma zebyenaa é ɛba ɔ, nyɛy baasa ɛ́ ɛzɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Ye nabɛ ɛ́, bi naagwak dáa bɛ nake nɛ bɛbhaab binaka náá: “Sa wɔ ààgwakel nɛ mot, da wɔ ɛ́ tuwal myoŋ nɛ mɛsoŋ bhii tak wɔ kadi ɛ́ ààsa sa wɔ nakɛk ɛ. Ye goka ɛ́ náá, wɔ sa sa wɔ kɛk é mis mɛ Ghɛŋ ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yɛ kabɛ mam ɔ, mɛ lɛɛ bin ɛ náá, sa mot ààtuwal myoŋ nɛ mɛsoŋ, da ɛ́ nɔɔ gwoo dáa tyaasɛs, etɛɛ náá, penek ɛ́ pɛ bóó mɛkoozi mɛ Zɛɛb di ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sa mot ààtuwal myoŋ nɛ mɛsoŋ nɛ bɔs, etɛɛ náá, bɔs ɛ́ di Zɛɛb di enyal nɛ mɛko mɛ ɔ. Sa mot ààtuwal myoŋ nɛ mɛsoŋ nɛ din ɛ Yeluzalɛm, etɛɛ náá, ye ɛ́ ghaada ɛ boo Mɛkoozi. ");
INSERT INTO bkw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sa wɔ ààtuwal myoŋ nɛ mɛsoŋ, da ɛ́ wa lo'ɔ é ban, etɛɛ náá, wɔ tok nɛ ghwyil ɛswoola bhoo lo'ɔ náá, ye bhilal nɛghu ye pum. ");
INSERT INTO bkw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yɛ bɛ náá, wɔ eemyaal tɛp ɔɔ, kea “Iyoo”. Yɛ kabɛ náá, wɔ eebyen ɔɔ, kea “ooh”, etɛɛ náá, ekɛla-ekɛla ee bot dyeebakɛl kɔ étɛp'enek dyeebadus ɛ́ pɛ daa Mbee mot.» ");
INSERT INTO bkw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ye nabɛ ɛ́, bi naagwak náá: “Mot ɛ́ tuu sɔ dis ɔɔ, ye goka ɛ́ náá, nyɛ baatuuaa yɛ. Mot ɛ́ bwak wɔ ɛdjɛ ɔɔ, da wɔy ɛ́ baabwak nyɛ ɛdjɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Deenek, mam kalɛɛ bin ɛ náá: Sa mot ààbulal ɛbiyo nɛ ɛbiyo. Mot ɛ́ nyuu wɔ bɛɛz é ɛmuk pɛ mbɔ eghɛŋ ɔ, baaka nyɛ yak kyee ɛmuk. ");
INSERT INTO bkw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mot ɛ́ di esaa wɔ nɛ etɛp étɛp nyɛ neenɔɔ kuwa yɔ ɔɔ, beta nyɛ, nyɛ baanɔɔ dɔɔ nɛ ndjookuwa yɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mot ɛ́ besal wɔ náá, wɔ kɛ nɛŋ wat ɔɔ, kɛa enɛŋ ebá. ");
INSERT INTO bkw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gwyena nɛ mot di ewaab wɔ sonok ɔ. Yɛ bɛ náá, mot eenɔɔ sa yɔ ɔɔ, sa wɔ ààkabaakɛdu.» ");
INSERT INTO bkw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ye nabɛ ɛ́, bi naagwak náá: “Ye goka ɛ́, wɔ kwyɛl sɔ'ɔ mot, da wɔ ɛ́ byen mot mɛbhuka mɔ.” ");
INSERT INTO bkw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yɛ bɛ mam ɔ, mɛ kalɛɛ bin ɛ náá: kwyɛlka bot ɛ mɛbhuka men. Djaalaka Zɛɛb kɔ ɛsu ɛ bot ɛ di ezuk bin ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Deenek ɛ́ bi aadi bɔn Sɛɛg'en di pɛ tɔ gwoo ɔ, etɛɛ náá, Zɛɛb sa ɛ́ náá, gwyes kas kɔ bot djas: bɛmbee ɛ bot nɛ bɛtɛtɛ ɛ bot. Tyee wat, Zɛɛb sil bhi ɛ́, étɛp bot ɛ di sosoob ɔ, nɛ bot ɛ di ààbɛ sosoob ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yɛ bɛ náá, bi goka ɛ́ nɛ ɛzokwyɛl ɛ́ bot ɛ di ekwyɛl bin ɔ, étɛp ye bi di bun náá, bi ɛ́ waabela efute aadus pɛ ɛko ɛ? Dɔɔ nɛ bɛnɔŋel ɛ epata e lapo zobaakwyɛl ɛ́, bot ɛ di ekwyɛl bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yɛ bɛ náá, bi zoswos ɛ́ bɔn nyɛɛg bin ɔ, bi bee tin ɛ́ náá, bi ɛpesa enɛm esa? Etɛɛ náá, bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ, bɔɔ pe zobaasa ɛ deenek! ");
INSERT INTO bkw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dika nɛ mbɛɛ elyem dáa Sɛɛg'en di tɔ gwoo ɔ di nɛ mbɛɛ lyem ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Bi ɛ́ kotiibal dum nɛ dáa bi di esa enɛm esa nɛ bot étɛp ɛduwal ɛ Zɛɛb ɛ. Bi ɛ́ sa deenek é mis mɛ bot, étɛp bot djas neeke náá: “Biyɔ ɛ́ di bɛmbɛɛ bot” ɔ. Deenek, bi ɛ́ sa deenek ɔɔ, bi aanàkwaabela efute e Sɛɛg'en di tɔ gwoo aadjɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wɔ kwyɛl ɛdjɛ djel mot sonok ɔɔ, wɔ goka ɛ́ nɛ ɛsa yɛ tɔ sɔ, sa mot ààgu. Nàsa dáa bot ɛ luwalɛŋ di sa tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ é egba ɛ. Bɛ sa deenek ɛ́ étɛp bot needuwal bɛ. Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Mbi bot binɔk eezebela yɔbɔ efute. ");
INSERT INTO bkw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yɛ bɛ náá, mbɔ eghɛŋ bɔ ɛpedjɛ djel mot sonok ɔɔ, yɛ àànyɔ náá, mbɔ myɛl ɛ lɔ gu. ");
INSERT INTO bkw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Etɛɛ náá, ye goka ɛ́ náá, sa wɔ djɛ mot ɛ, ye di sɔ. Tin, Sɛɛg'en, mot di egu dáa wɔ di ekwyee bot tɔ sɔ ɛ, nyɛ waadjɛ wɔ yɔ efute.» ");
INSERT INTO bkw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yezu eezɛke nɛ nɔɔ náá: «Bi ɛ́ di edjaala ɔɔ, nàdika dáa bot ɛ di nɛ lualɛŋ, bɛ dyeebakwyɛl ɛdjaala ɛ metetel tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ é bɛman, étɛp bot neebee bɛ. Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: bot binɔk eezebela yɔbɔ efute. ");
INSERT INTO bkw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yɛ kabɛ wɔy ɔ, wɔ kwyɛl ɛdjaala Zɛɛb ɔɔ, nia tɔ dhɛŋ'ɔ, da wɔ ɛ́ diyal ɛbɛ. Bhii tak, da wɔ ɛ́ djaala nɛ Soog di tɔ di sɔ ɔ. Tin, Soog, mot di ebee esesɛɛ wɔ di esa tɔ sɔ ɔ, nyɛ waadjɛ wɔ efute. ");
INSERT INTO bkw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«É sok bi di edjaala ɛ́, sa mot ààbasal ɛkpa wat esok nɛ esok gwyes dáa bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ. Bɔɔ gek ɛ́ náá, Zɛɛb ɛ́ waagwak bɛ, etɛɛ náá, bɛ nɛ bil mɛkpa ɛbuɛpe tɔ mendjaala mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sa mot ààbaŋa bɛ, etɛɛ náá, Sɛɛg'en nɛ gu sa elyem bin di ekwos ɛ, ɛsok nɛ bi nɛ waab nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Deenek, Gwakeka dáa bi di egoka nɛ ɛdjaala ɛ. Keka náá: “Sɛɛg'es di tɔ gwoo ɔ, ye goka ɛ́ náá, mot nɛ mot gu náá, wɔ ɛ́ Zɛɛb na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mɛkoozi mɔ zyɛ. Beta náá, ɛkwosak ɛ lɔ sael kɔ bɔs, dáa ye di sael pɛ tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Djɛa bis mɛlu nɛ mɛlu edee di egoka nɛ nes ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pela ɛbiyo ɛ bis zesa ɛ, etɛɛ náá, bisɔ pe, bis ɛpepel bot ɛ nazesa bis ɛbiyo ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sa wɔ ààbet bis tɔ mɛbhowal. Pɛka bis é mɛmbɔ mɛ Mbee mot, etɛɛ náá, ye ɛ́ wɔy ɛ́ di nɛ Mɛkoozi, nɛ mɛbwala, nɛ duma na kɔm-kɔm.”» ");
INSERT INTO bkw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Guka náá: Bi ɛ́ pel ɛbiyo ɛ bot ɛ di etɔ́ nɛ ɛsa bin ɔ, Sɛɛg'en di pɛ tɔ gwoo ɔ waabaapel yebɔ pe. ");
INSERT INTO bkw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tin, yɛ kabela náá, bi ààpel bɛsɔ bin ɔɔ, Sɛɛg'en di tɔ gwoo ɔ aanàkwaabaapel ɛbiyo ɛ bi di esa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Yɛ bɛ náá, bi ɛpetsi edee ɔɔ, sa mot ààdi nɛ bhwoob ghoŋ dáa bot ɛ di nɛ lualɛŋ ɔ. Bɛ lyaal bhwoob ghoŋ deenek ɛ́, étɛp bot djas neegu náá, bɛ ɛpetsi edee. Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: bot binɔk eezebela yɔbɔ efute. ");
INSERT INTO bkw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yɛ kabɛ wɔy ɔ, wɔ tsi edee ɔɔ, gwyiia bhwoob, da wɔ ɛ́ lɔɔb mul é lo, ");
INSERT INTO bkw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","etɛɛ náá, bot needi ààgu náá, wɔ ɛpetsi edee. Tin, ye ɛ́ Soog mot di tɔ sɔ ɔ di egu, deenek Soog, mot di ebee esesɛɛ djas wɔ di sa tɔ sɔ ɔ, nyɛ waadjɛ wɔ efute.» ");
INSERT INTO bkw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Nàsaaka ɛdi ɛ́ nɛ bɛtɛ nɛ ekum é bɔs'ak. Ekum ee di náá, bɛsɛs nɛ emaa ɛ́ waapul ɛ. Ekum ee di náá, bot ɛ djii ɛ́ waakwak ɛbo ɛ ndjaa, da ɛ́ djii, nɔɔ, tɔ́ nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kwomka ekum bin pɛ daa Zɛɛb. Penek, bot ɛ djii aanàkwaani kɛdjii yɛ, bɛsɛs nɛ emaa aanàkwaapul yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Etɛɛ náá, é di mot di ekwom esa bɛ ɔ, lyem'ɛ di ɛ́ tin.» ");
INSERT INTO bkw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Mis mɛ mot ɛ́ dáa lama nyel. Yɛ bɛ náá, mis mɔ ɛpenyaasok ɛnyɔɛpe ɔɔ, gua náá, nyel'ɔ djas ɛ́ tɔ selele. ");
INSERT INTO bkw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yɛ kabɛ náá, mis mɔ ɛpekpaŋ ɔɔ, nyel'ɔ djas ɛ́ tɔ ghooghom. Yɛ kabɛ náá, ngel di tɔ lɔ eezedim ɔɔ, tin, kwaa yenek mɛghomla aanɔŋel nɛ yé?» ");
INSERT INTO bkw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mot ngɔt aanàkwaadi mot-mɛsa mɛ ekukuma ebá. Yɛ bɛ deenek ɔɔ, nyɛ waabhina ngɔt, da nyɛ ɛ́ kwyɛl nwyak ngɔt, nɛghu nyɛ kaseya nɛ mot ɛsok ɔɔ, nyɛ waapɛɛ nwyak ngɔt. Bi tok nɛ ghwyil ɛsa mɛsa mɛ Zɛɛb nɛ mɛsa mɛ epata é di wat. ");
INSERT INTO bkw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Étɛp tak ɛ́ mɛ di elɛɛ nɛ nen náá: Nàbemka ba dum nɛ tɛp edee, nɛ gwyes mɛdii nɛ tɛp eduuba. Etɛɛ náá, tsik eedhaa edee nɛ mɛnyɔ. Nyel eedhaa ekaad nɛ mɛtaŋ. Etsal é? ");
INSERT INTO bkw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Beeka enen pɛ ɛko, bɛ ààbɛ epyeeb, ààbɔ́k edee di ewum tɔ epyeeb ɛ. Bɛ ààkwom edee tɔ mɛbhwaa nɛ kɔ etaa. Tin, dhi Sɛɛg'en di tɔ gwoo ɔ, di djɛ bɛ edee! Bi ààpadhaa enen nɛ boo mɛtaŋ é mis mɛ Zɛɛb é? ");
INSERT INTO bkw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yɛ bɛ náá, bi ɛpebem ba ɔɔ, ɛzɛ pak'en di nɛ ghwyil ɛbil ba ɛlu ɛ wat kɔ mɛlu mɛ tsik'ɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Étɛp ye bi di bem ba kɔ ɛsu ɛ ekaad? Beeka dáa mɛzɛm di ekwyil nɛ wyee tɔ pyeeb ɛ. Mɛzɛm mɛ tak ààsa mɛsa, ààlat ekaad. ");
INSERT INTO bkw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tin, mɛ ɛpelɛɛ bin náá, dɔɔ nɛ Salomɔŋ, nɛ boo duu yɛ, nyɛ nabɛ ɛ́ ààbɛ nɛ mbɛɛ kaad na nyɔ dhaa wat tɔ kɔkɔ mɛzɛm menek. ");
INSERT INTO bkw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yɛ bɛ náá, Zɛɛb ɛpebet eka ee di tɔ dik mos, da djɛmɛn ye ɛ́ nɔŋaa, dikaa tɔ du ɔɔ, tin, nyɛ tok nɛ ghwyil ɛsa deenek nɛ lyem'ɛ met étɛp'en é? Ye nakoozodi náá, bi tok nɛ boo ɛmyaal nɛ nɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Nàbemka ba é ɛkeke náá: “Mena aadɛka yé? Mena aadɛka yaa mɛdii? Mena aabɔtka yé?” ");
INSERT INTO bkw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yenek djas, ye ɛ́ bot ɛ bɔs ɛ́ di ebwos esesɛɛ binek mɛlu djas. Tin, Sɛɛg'en mot di tɔ gwoo ɔ nɛ gu náá, bi ɛ́ nɛ gwyes tak. ");
INSERT INTO bkw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pookosaaka sok Ɛyoŋ ɛ Zɛɛb nɛ tsik tɔ epiki nyɛ di ewaab ɛ. Tin, Zɛɛb ɛ́ waadjɛ bin esa djas bi di nɛ gwyes tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nàbemka ba nɛ etɛp aasael djɛmɛn ɛ, etɛɛ náá, etɛp ee djɛmɛn aagwyɛ lo ɛ́ nyɛ ɛmet. Dwoo nɛ dwoo ɛ́ nɛ yɛ ɛkwosak.» ");
INSERT INTO bkw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Sa bi ààdidi é pɛ́ɛ bot, deenek Zɛɛb aanàkwaapɛ́ɛ bin. ");
INSERT INTO bkw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Etɛɛ náá, Zɛɛb aapɛ́ɛ bin ɛ dáa bi di epɛ́ɛ bɛsɔ bin ɛ. Nyɛ aalwoodal bhwaŋ'en ɛ dáa bi di elwoodal bhwaa bɛsɔ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","É tɛp yé wɔ gwyák kwyɛɛzyoŋ di tɔ dis ɛ sɔ'ɔ mot, wɔ kadi ɛ́ ààbee pek le di tɔ dis ɛ lɔ ɛ? ");
INSERT INTO bkw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wɔ nàkwaake nɛ sɔ'ɔ mot náá: “Mɔn nyaag'am, beta mɛ dis kwyɛɛzyoŋ tɔ dis ɛ lɔ,” wɔy ààbɛ é bee pɛk le di tɔ yɔ dis ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɔy mot mɛdjhaaz pɛ ɛko, bhimis pɛ si, pookodis sok pɛk le tɔ dis ɛ lɔ ɛ! Bhii tak ɛ́ wɔ waanyaa sok, étɛp wɔ needis kwyɛɛzyoŋ di tɔ dis ɛ mɔn nyoog ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Nàdjɛka esa ee di dɛɛ ɛ nɛ bɛbhyɛ, é kaab náá, bhii tak bɛ ɛ́ zɛkɛbula zɛduma wɔ é nyel nɛ mɛkwaala. Nàmwaska mɛvunga sok bhwoob bɛghwyee, é kaab náá, bɛ ɛ́ zɛkɛnyal yɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Waabka, bi ɛ́ waadjɛaa. Saaka, bi ɛ́ waabela. Diigka, bɛ waadii bin ɛbɛ ɛ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Étɛp tak ɛ́ ye di náá, mot ɛ́ waab ɔɔ, nyɛ ɛpedjɛaa. Mot ɛ́ saŋ ɔɔ, nyɛ ɛpebela. Ɛbɛ ɛ ndjaŋ aadiiaa ɛ́, étɛp mot diig ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ye ɛ́ nɛ mot ngɔt pak'en di nɛ ghwyil ɛdjɛ mɔn'ɛ ɛkok bela náá, mɔn waab ɛ́ mapa? ");
INSERT INTO bkw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nɛghu ɛzɛ di nɛ ghwyil ɛdjɛ mɔn nyɔ, yɛ bɛ náá, mɔn waab ɛ́ su ɔɔ? ");
INSERT INTO bkw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kwyii biyɔ, bɛmbee ɛ bot, di gu ɛdjɛ embɛɛ esonok nɛ bɔn bin, gwyata nɛ Sɛɛg'en di tɔ gwoo ɔ aapaadi ààdjɛ embɛɛ esonok nɛ mot aawaab nyɛ sonok ɔ! ");
INSERT INTO bkw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Kanka ɛsa sok nɛ bɛsɔ bin esesɛɛ bi di ekwyɛl náá, bot sa bin yɛ ɛ. Deenek ɛ́ mɛkana mɛ etsi ɛ Moiiz nɛ yii bɛngoolel ɛ mɛkpa ɛ Zɛɛb di elyo.» ");
INSERT INTO bkw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Nika tɔ ɛbɛ ɛ ndjaa na maad-maad, etɛɛ náá, ze di eniigal mot pɛ dɛl ɛ ɛsyee ɛ, ye nɛ bɔk. Bɛtɛ nɛ bot dyeebakwyɛl ɛdhaŋ ɛ́ penek. ");
INSERT INTO bkw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tin, guka náá, ɛbɛ ɛ ndjaa tak nɛ maad, bela náá, pɛ ze di edul bot pɛ ze tsik ɛ, ye nɛ pata. Étɛp tak ɛ́ di náá, bot ɛbuɛpe ààdyeebadu yɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Bi ɛ́ di nɛ etsoŋ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ. Bɛ zyɛ pɛ daa len ɛ́, nɛ ɛzaaba dáa mɔn ɛ taa, ghuna bɛ ɛ́ eben, bɛ zosyel ɛ mya mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bi aagu bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ tak ɛ nɛ mɛfulu mɔɔ. Etɛɛ náá, bum le vin ààbɔ́kaa tɔ mɛkpak mɛ mɛgɔk nɛghu bum fiig kɔ le mɛgɔk. ");
INSERT INTO bkw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Etɛɛ náá, mbɛɛ le zodjɛ ɛ́ mbɛɛ bhum. Mbee le kadjɛ ɛ́ mbee bhum. ");
INSERT INTO bkw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mbɛɛ le tok nɛ ghwyil ɛdjɛ mbee bhum. Tyee wat nɛ mbee le. Ye tok nɛ ghwyil djɛ mbɛɛ bhum. ");
INSERT INTO bkw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ele djas di ààdjɛ bhum ɛ, ye goka ɛ́ nɛ ɛkwyalaa, bhii tak da ye ɛ́ mwasaa tɔ du. ");
INSERT INTO bkw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Étɛp tak ɛ́ di náá, bi aagu bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ tak ɛ́ nɛ embee mɛfulu mɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ye tok bot djas di djóo mɛ: “Ghɛŋ, Ghɛŋ!” ɔ, aani tɔ Ɛyoŋ ɛ di tɔ gwoo ɔ. Bot aani ɛ́, ye ɛ́ bot ɛ di esa ɛkwosak ɛ Saag'am di tɔ gwoo ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","É dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, bot ɛbuɛpe ɛ waake nɛ nam náá: “Ghɛŋ, Ghɛŋ”, ye ɛ́ nɛ din ɛ lɔ ɛ bis nadi bɛngoolel ɛ mɛkpa ɛ Zɛɛb! Etsal é? Ye ɛ́ nɛ din ɛ lɔ ɛ bis nadi esesɔ mɛlyeeb! Etsal é? Ye ɛ́ nɛ din ɛ lɔ ɛ bis nasa bɛtɛ nɛ endem e mɛbwala! Etsal é? ");
INSERT INTO bkw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tin, mɛ waalɛɛ nɛ nɔɔ é mis mɛ bot náá: “Mɛ nabɛ ààgu bin. Duska é mis mam, tɔ́ka ɛtsetaɛpe nɛ nam, biyɔ, bot ɛ di esa embee esesɛɛ ɔ!”» ");
INSERT INTO bkw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Gwakeka, mɛ pookolyaal bin mbi mot zyɛ pɛ daa lam ɔ. Nyɛ gwak mɛkpa mam, da nyɛ ɛ́ kɛ tyee tak ɔɔ, nyɛ ɛ́ mot etsoŋ di esum ndjaŋ'ɛ kɔ ɛkok ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wɔ gwaa bhi zɛnee ɛbuɛpe, tyee bhyoŋ natuula nɛ ghuu na lyel-lyel ɛ, ye naanyuŋa é ndjaŋ'enek. Ààbik, etɛɛ náá, ndjaa tak nasumel ɛ́, ɛnyɔɛpe kɔ ɛkok. ");
INSERT INTO bkw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tin, mot di egwak mɛkpa mam, da nyɛ ɛ́ kadi ààkɛ tyee mɛkpa mɛ tak di elɛɛ ɔ, nyɛ ɛ́ dáa ndjemet mot di esum ndjaa kɔ bɔs bɛsyɛ, ààwyɛl epap kɔ ɛkok ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dáa bhi nakanee ɛbuɛpe ɛ, tin, tyee bhyoŋ nakatuula ɛ, ghuu na lyel-lyel eezɛnyuŋa é epap e ndjaŋ'enek, epap eezɛbik “syɛɛɛ” é di tak wat.» ");
INSERT INTO bkw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dáa Yezu nasilal ɛlyo bɛmɛlyo mɛ ɛ, mɛdhuu mɛ bot naadyeebadjoka dáa nyɛ nadi elelyo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Etɛɛ náá, nyɛ nabɛ ɛ́ ààlyo dáa bɛghaŋ ɛ mɛkana mɛ etsi nalelyo ɛ́, nyɛ nalelyo ɛ́, nɛ eghɛŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dáa Yezu nasul kɔ ɛtsok ɛ, zukamwaa nɛ mot naazɛdu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tin, wɔ gwaa dhiiti mot nadi nɛ ɛbɛ́ ɛ zezam ɔ, zɛtiila pɛ daa lɛ. Nyɛ eezɛkwyit mɛboŋ si, zɛdjaala nɛ nɛ náá: «Ghɛŋ! Mɛ nɛ gu náá: wɔ kwyɛl ɔɔ, wɔ ɛ́ nɛ ghwyil ɛtsik mɛ, nyel'am bula dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tin, Yezu eezɛsɛɛb mbɔ, mɛt nyɛ. Nyɛy nɛ nɛ náá: «Mɛ eekwyɛl. Tsaka!» É di tak wat, wɔ gwaa, ɛbɛ́ ɛ zezam mot'enɔk zɛsi. ");
INSERT INTO bkw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bhii tak, Yezu ɛ boozɛke nɛ nɛ náá: «Gwaka mɛ ɛnyɔɛpe: Sa wɔ ààlɛɛ mot sa dhaa wak ɛ. Tɔ́a, kɛlyaal nyel pɛ daa bɛghaa-Zɛɛb, da wɔ ɛ́ kɛdjɛ esa e ɛgwyena dáa Moiiz nalyo ɛ, étɛp wɔ neelyaal bot djas náá, wɔ eetsak.» ");
INSERT INTO bkw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dáa Yezu nadi eni tɔ ghaada Kapɛlnaum ɛ, wɔ gwaa dhiiti kukuma tɔ lɔɔg esodja zɛzyɛ pɛ daa lɛ. Bhii tak, nyɛ eezɛke nɛ Yezu náá, nyɛ zɛkwyee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nyɛy nɛ nɛ náá: «Ghɛŋ, mot-mɛsa mam ngɔt ɛ́ ndjaasi pɛ ndjaŋ'am, nyɛ eezesɔɔb nyɛ ɛpebɛ́ ɛlyelɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Mɛ ɛpetɔ́, kɛtsik nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","É di'enek, kukuma tɔ lɔɔg esodja binɔk eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, mam ɛ yam zɛ, wɔ neezɛni tɔ ndjaŋ'am. Ye goka ɛ́ náá, wɔ zolóo ɛkpa wat, étɛp mot-mɛsa mam neetsak. ");
INSERT INTO bkw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Di mɛ di'aak, ye ɛ́ nɛ ekukuma bam ɛ, mɛ di egwak esesɛɛ mɛ di egoka nɛ ɛsa nɛ nɔɔ ɛ. Dɔɔ nɛ mam pe, mɛ ɛ́ nɛ esodja si mɛko mam. Mɛ ke nɛ nɔɔ: “Tɔ́ka” ɔɔ, bɛ ɛpetɔ́; “Bulaka” ɔɔ, bɛ ɛpebula; “Saka dáak” ɔɔ, bɛ ɛpesa.» ");
INSERT INTO bkw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dáa Yezu nagwak eyala e kukuma yenɔk ɛ, ye nabɛ ɛ́, nyɛ naadyeebamyaala. Tin, nyɛ ɛ́ booke nɛ bot ɛ nadi egyee bɛ nɛ nɔɔ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: mɛ dinaa ààpaabee mot di edum koŋ nɛ Zɛɛb, kɔ Yisalaɛl dáa mot'ak. ");
INSERT INTO bkw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Betka mɛ lɛɛ bin náá, bot ɛbuɛpe ɛ waadus pɛ ɛbil ɛ dwoo nɛ pɛ ɛdjem ɛ dwoo. Bɛ waazyɛ, zɛdi kɔ mesa wat, bɛ nɛ bɔn Abalaam, Izak nɛ Zakɔɔb tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tin, bot ɛ nagoka nɛ ɛdi ɛ bot ɛ ɛyoŋ ɛ tak ɔ, bɛ aadi ɛ́, wusa pɛ kel, tɔ ghooghom pɛ baadi edje mɛgwyɛ nɛ ɛkwaal ɛ mɛtsok ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Bhii tak, Yezu eezɛke nɛ kukuma esodja binɔk náá: «Sika pɛ ndjaŋ'ɔ etɛɛ náá, kɔ ɛdum ɛ koŋ ɛ lɔ nɛ Zɛɛb, Zɛɛb eedjɛ wɔ sa lyem'ɔ di ekwos ɛ!» É di tak wat, ye nabɛ ɛ́, mot-mɛsa ɛ kukuma esodja binɔk naatsak. ");
INSERT INTO bkw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yezu eezɛwyis, tɔ́ pɛ daa Pyɛɛd. Ghuna tsi yɛ yii moma nadi ɛ́ ndjaasi nɛ mɛkosa ɛkpaŋɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nyɛ eezɛmɛt nyɛ é mbɔ, mɛkosa eezɛsi. É di tak wat, moma yenɔk eezɛwyɛl, nyɛ moo zɛbe bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dáa dwoo nadi esila ɛ, wɔ gwaa bɛ zɛzyɛ nyɛ nɛ bot ɛ mɛlyeeb nadi edhek ɔ. Dáa Yezu nadi elii kɔ membel menɔk ɛ, embee esisim nadi ewyis tɔ lɔɔ, tin, nyɛ naatsik dɔɔ nɛ bot ɛ mɛbɛ́ djas. ");
INSERT INTO bkw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nyɛ nasa deenek ɛ́, etɛɛ náá, esesɛɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ ɛ́ neebela ɛsuk. Nyɛ nake ɛ́ náá: «Nyɛ naanɔɔ edjam bina nɛ mɛbɛ́ mena.» ");
INSERT INTO bkw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bhii tak dáa Yezu nabee ɛdhuu ɛ bot ɛ nadi edu nyɛ ɔ, nyɛ ɛ́ boozɛke nɛ bɛdjekel bɛ náá, bɛ sɛɛ dhaa pɛ yii kyiid boo soob na djato-djato. ");
INSERT INTO bkw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wɔ gwaa dhiiti ghaa mɛkana mɛ etsi zɛzyɛ pɛ daa lɛ. Nyɛy nɛ nɛ náá: «Lyoel, mɛ ɛpekwyɛl ɛdu ɛ wɔ é mɛze djas wɔ aadi tɔ́ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Deenek Yezu eezɛbɔɔza nɛ nɛ náá: «Bɛbhɛk ɛ́ nɛ eku bɛ di djaasi tɔ tak ɛ, enen ɛ́ nɛ mɛk mɔɔ. Yɛ kabɛ Sɛɛŋɛlɛ Mɔn Mot ɔ, nyɛ tok nɛ zeza nɛ di nyɛ aadi ndiindil nɛ ɛdja ɛ gɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dhiiti mot ngɔt pak bɛdjekel bɛ eezɛke nɛ nɛ náá: «Ghɛŋ, ɛsok nɛ mɛ nɛ du wɔ, pookobet mɛ, mɛ pookokɛdel saag'am.» ");
INSERT INTO bkw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tin, Yezu eebɔɔza nɛ nɛ náá: «Dua mɛ. Beta bot ɛ di ààbɛ nɛ tsik ɔ, bɛ delel pak'ɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wɔ gwaa Yezu zɛni tɔ boo elɛɛd sama wat nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ààbɔya deenek, kasɛka ɛ́ boo ghuu na lyel-lyel eezɛkan ɛpupal kɔ boo soob na djato-djato. Mɛpupal mɛ tak eezɛghɛɛ ɛbhyeeb ɛ mɛdii zɛkɛɛza é elɛɛd. Ye kabela tin ɛ́, Yezu edja gɔ́. ");
INSERT INTO bkw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tin, bɛdjekel bɛ zokazɛtiila pɛ pak nyɛ nadi tɔ elɛɛd ɛ. Bɛ eezɛdjem nyɛ nɛ etsim: «Ghɛŋ, tsika bis! Ɛsyee ɛ́ yak!» ");
INSERT INTO bkw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","É di'enek, ye nabɛ ɛ́ Yezu naazɛbɔɔza nɛ nɔɔ náá: «Étɛp yé bi di nɛ kɛŋ? Ɛbwaalel ɛ len nɛ Zɛɛb nɛ tɔɔl!» Bhii tak, nyɛ eezɛwyɛl, zɛbhɛm ghuu, nɛ dii, nyɛ eezɛlyak ghuu. Nyɛy nɛ dii náá: «Sila ghulal'ɔ ye di gwyem.» Wɔ gwaa, ghuu zɛsila, bhwak moo tin «kup». ");
INSERT INTO bkw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bɔɔ djas nabɛ ɛ́, bɛ naadyeebadjoka. Tin, bɔɔ náá: «Nwyak ɛ́ nwyaa kwaambi mot di náá, dɔɔ nɛ ghuu nɛ boo soob na djato-djato ɛpegwak nyɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dáa Yezu nasɛɛ pɛ yii kyiid boo soob na djato-djato pɛ kyee dik Ghadasa ɛ, wɔ gwaa bot ɛbá zɛtuula tɔ mɛvit, bɛ neezɛboma nɛ nɛ. Ye nabɛ ɛ́ bot ɛ embee sisim nadi dhek ɔ, bɛ nadi ɛ́, nɛ mbee mɛnyan dhaa tyɛ, bot nabɛ ɛ́ ààbɛ nɛ ghwyil ɛdhaa é ngwoob mɛvit mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bot binɔk moo tin etsim náá: «Bis sa wɔ yé, wɔy Mɔn Zɛɛb? Wɔ zyɛ wak ɛ́ zɛzɛm bis, sonok ɛwala ɛ tak dinaa ààdjala?» ");
INSERT INTO bkw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ba ɛtsetaɛpe nɛ di tak, ye nabɛ ɛ́ nɛ boo ɛsaŋ ɛ bɛghwyee nadi egɔɔ tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Embee esisim eezɛdjaala nɛ Yezu, bɔɔ náá: «Wɔ kwyɛl ɛsɔ bis ɔɔ, kyeeda bis tɔ ɛsaŋ ɛ bɛghwyee bak.» ");
INSERT INTO bkw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yezu eezɛmyaal, nyɛ eezɛke nɛ nɔɔ náá, bɛ tɔ́. Tin, wɔ gwaa embee esisim zɛwyis tɔ bot binɔk, zɛni tɔ ɛsaŋ ɛ bɛghwyee binɔk. Bhii tak, ɛsaa djas eezɛsul ɛtsok pɛ bɛ nadi ɛ́, kaab, kɛghaaga tɔ dii, bɔɔ djas si na «bhɛɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bot ɛ nadi ebaal ɛsaŋ ɛ bɛghwyee tak ɔ, zokazɛkaab, sik pɛ dɛl. Bɛ moo tin ebaŋa bot ɛ dɛl edjema bɛ bee penek dum nɛ bot ɛbá binɔk. ");
INSERT INTO bkw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tin, wɔ gwaa bot ɛ dɛl djas zokazɛwyis, kɛboma nɛ Yezu. Dáa bɛ naboma nɛ nɛ ɛ, bɛ naazɛdjaala nɛ Yezu náá, nyɛ dus kɔ kyee dik'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wɔ gwaa Yezu zɛni tɔ elɛɛd, sɛɛ boo soob na djato-djato, sik pɛ dɛl. ");
INSERT INTO bkw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tin, bɛdhiiti bot zokazyɛ nɛ mot ngɔt nazesɔɔb nɛ ɛbɛ́ ɔ, byaala kɔ mwaala. Dáa Yezu nabee ɛdum ɛ koŋ ɛ bot ɛ nazyɛ nɛ mbel tak ɛ, nyɛ naazɛke nɛ mbel náá: «Sa mɛghaaz mɔn'am, mesyem mɔ eepelel!» ");
INSERT INTO bkw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dáa bɛ nabee deenek ɛ, bɛdhiiti bɛghaŋ ɛ mɛkana mɛ etsi ɛ Moiiz nabɛ ɛ́, bɛ moo nyiiŋla pak'ɔɔ náá: «Nwyak mot ɛpebyasal Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","É di tak wat, ye nabɛ ɛ́ Yezu naagu esiiza bɔɔ. Nyɛ boozɛke náá: «Étɛp yé bi di nɛ mbee esiiza tɔ elyem bin deenek? ");
INSERT INTO bkw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ɛyé di elyel nɛ nen, ɛke ɛ́ nɛ mot ɛbɛ́ náá: “Mesyem mɔ eepelel” ooho, nɛghu ɛke náá: “Wyɛla, da wɔ ɛ́ kɛ”? ");
INSERT INTO bkw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ye goka ɛ́ bi ɛ́ gu náá, Sɛɛŋɛlɛ Mɔn Mot ɛ́ nɛ ghwyil ɛpel mesyem mɛ bot kɔ bɔs.» Bhii tak, nyɛ eezɛke nɛ mot zesɔɔb nɛ ɛbɛ́ ɔ náá: «Wyɛla, nɔŋa mwaala yɔ, da wɔ ɛ́ sik pɛ ndjaŋ'ɔ!» ");
INSERT INTO bkw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","É di'enek, mot'enɔk eezɛwyɛl, sik pɛ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","É di'enek wat, dáa ɛdhuu ɛ bot ɛ nadi tin ɔ nabee deenek ɛ, bɛ naadyeebadjoka ɛlyelɛpe. Bhii tak, bɛ moo eduwal Zɛɛb dáa nyɛ nadjɛ mbi yenek mɛbwala nɛ bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yezu eezɛdus tin, dáa nyɛ nadi edhaŋ ɛ, nyɛ naazɛbee dhiiti mot, din ɛ lɛ ɛ́ Matye, nyɛ nadi ɛ́ ndiindil é di mɛsa mɛ. Nyɛ nadi ɛ́ nɔŋel epata e lapo. Yezu eezɛke nɛ nɛ: «Dua mɛ!» Matye eezɛwyɛl «ngbat», bhii tak, nyɛ eezɛdu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yezu bɛ nɛ bɛdjekel bɛ nadi edɛ edee pɛ ndjaŋ ɛ Matye. Wɔ gwaa, bɛtɛ nɛ bɛnɔŋel ɛ epata e lapo nɛ bot ɛ mesyem zokazɛlwood tin, zɛdɛ bɛ nɛ bɛ nɔɔ djas kɔ mesa wat. ");
INSERT INTO bkw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Dáa eFalizyɛ nabee deenek ɛ, bɛ naazɛdji bɛdjekel bɛ náá: «Étɛp ye lyoel yen di edɛ edee é di wat bɛ nɛ bɛnɔŋel ɛ epata e lapo nɛ bot ɛ na mbee dék?» ");
INSERT INTO bkw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yezu eegwak dáa bɛ nadi elii ɛ, tin, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Bot ɛ di nɛ mɛnyel ɛnyɔɛpe ɔ tok nɛ gwyes dhɔkɔtɔlɔ nyɛ neegwom bɛ. Ye ɛ́ membel ɛ di nɛ gwyes mɛgwoma. ");
INSERT INTO bkw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tɔ́ka, kɛdjekeka ɛsuk ɛ mɛkpa ɛ Zɛɛb di eke náá: “Mɛ kwyɛl ɛ́ enɛm esa, dhaa ebuwa e bɛtit.” Etɛɛ náá, mɛ nabɛ ɛ́ ààzyɛ zɛsaa bot ɛ epiki. Mam nazyɛ ɛ́ zɛsaa bot ɛ di egu náá, bɛ ɛ́ bot ɛ mesyem ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dhiiti dwoo, bɛdjekel ɛ Zaŋ Nduuel-bot naazyɛ zɛdji Yezu náá: «Étɛp yé bisɔ nɛ eFalizyɛ di etsi edee étɛp mendjaala, dhi bɛdjekel bɔ di ààtsi edee étɛp mendjaala?» ");
INSERT INTO bkw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Wɔ gwaa, Yezu zɛbɔɔza nɛ nɔɔ náá: «Bi nakobee sok paa náá, bɛsɔ ɛ mwaaz di tɔ ghoŋ dwoo ɛba, dhi bɛ di lɔɔg wat nɛ mwaaz, mot paazyɛ, zɛba moma ɔ? Yenek ààsael! Deenek ɛwala tak ɛpezyɛ, ɛwala ɛ di náá, mot zɛba moma ɔ waadisaa pak'ɔɔ. É di tak ɛ́ bɛ aatsi edee. ");
INSERT INTO bkw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Ye tok nɛ mot aanyaa pes bes kaad étɛp ɛkoobal put kaad nɛ yɛ. Wɔ sa deenek ɔɔ, é sok wɔ aagwyii kaad tak ɛ, bes kaad ɛ́ waanyaa put kaad, da ɛ́ bek ɛlen ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mɛnyok mɛ na bes ààwaaa tɔ bhɛɛb na mwa. Yɛ sɛɛ deenek ɔɔ, bhɛɛb ɛ́ nɛ ghwyil ɛbel, da mɛnyok ɛ́ see, deenek bhɛɛb eepulel. Étɛp tak ɛ́ di lɛɛaa náá, yɛ ààgoka deenek, etɛɛ náá, mɛnyok mɛ bes goka ɛ́ tɔ ebes e bhɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dáa Yezu nadi elii nɛ nɔɔ deenek ɛ, wɔ gwaa dhiiti kukuma eYuda zɛzyɛ pɛ daa lɛ. Nyɛ eezɛkwyit mɛboŋ si mɛko mɛ. Nyɛy nɛ nɛ náá: «Ɛsyes ɛ lam ààlóo nɛ pɛka. Mɛ kwyɛl ɛ́, wɔ zɛkɛl mɛmbɔ kɔ lɛ étɛp nyɛ neegom!» ");
INSERT INTO bkw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yezu eezɛwyɛl, «ngbat», bɛ nɛ bɛdjekel bɛ, du nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dhiiti moma nadi ebɛ́ ɛbɛ́ ɛ ghiya, ghiya nadi ekekɛk nyɛ é nyel ààbɛ nɛ ɛtsek. Ɛbɛ́ ɛ tak naaboya nɛ nɛ é di membu kam nɛ ebá. Moma tak zokazɛtiila pɛ bhii koŋ ɛ Yezu, nyɛ eezɛmɛt kyee ɛghɔ ɛ kaad ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Étɛp nyɛ nabɛ ɛ́, nyɛ eeke tɔ lyem'ɛ náá: «Mɛ zomɛt kaad'ɛ ɔɔ, mɛ ɛpetsak!» ");
INSERT INTO bkw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tin, Yezu eezɛliig mis, gwyák nyɛ. Nyɛ eezɛke nɛ nɛ náá: «Sa mɛghaaz ɛsyes ɛ lam! Ɛdum ɛ koŋ ɛ lɔ nɛ Zɛɛb eetsik wɔ.» É di tak wat, moma yenɔk naazɛtsak. ");
INSERT INTO bkw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bhii tak, Yezu eezɛtɔ́ pɛ ndjaa kukuma eYuda é tak. Dáa bɛ nakum ɛ, bɛ kabela bot ɛ, é ebwom ngɔmbi, zɛnɔɔ bak bot é sa yɔbɔ ɛzɛm pɛ ndjaa tak étɛp ɛkoobal esesɛɛ, bɛ neetɔ́ ndela. ");
INSERT INTO bkw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tin, Yezu eezɛke nɛ nɔɔ náá: «Wyiska pɛ kel, etɛɛ náá, ɛsyes ɛlak ààpagwyɛ, nyɛ dja ɛ́ gɔ́.» É di'enek, bɛ moo tin eduk Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dáa bɛ nawyisal ɛdhuu ɛ bot pɛ kel ɛ, Yezu eezɛni tɔ dhɛŋ, nyɛ eezɛmɛt nyɛ é mbɔ, wɔ gwaa ɛsyes ɛlenɔk zɛwyɛl. ");
INSERT INTO bkw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Menduk mɛ tɛp'enek naakɛ kɔ kyee dik'enek djas. ");
INSERT INTO bkw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dáa Yezu nadus tin ɛ, wɔ gwaa bot ɛ mɛbɛ́ mɛ edhim bɛbá zokazɛni edu nyɛ bhii koŋ nɛ etsim: «Mɔn Dhavid, geka bis ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Dáa Yezu nakum pɛ ndjaŋ ɛ, wɔ gwaa, bɛ na edhim binɔk zɛtiila pɛ daa lɛ. Yezu eezɛdji bɛ náá: «Bi eemyaal náá, mɛ ɛ́ nɛ ghwyil ɛsa sa bi di ewaab'enek é?» Bot binɔk eezɛbɔɔza nɛ nɛ náá: «Iyoo, Ghɛŋ! Wɔ ɛ́ nɛ ghwyil ɛsa.» ");
INSERT INTO bkw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tin, Yezu eezɛmɛt bɛ é mis. Nyɛy nɛ nɔɔ náá: «Zɛɛb eedjɛ bin sa djala nɛ ɛdum ɛ koŋ ɛ len ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","É di tak wat, wɔ gwaa bɛ nyaasok. Yezu eezɛlu bɛ ɛlyelɛpe náá: «Gwakeka mɛ ɛnyɔɛpe: sa mot ngɔt ààgu sa sɛɛ wak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tin, bot binɔk katɔ́ ɛ́, elɛɛ tɔ kyee dik'enek djas esesɛɛ Yezu nasa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","É sok bɛ nadi ekwyɛl ɛtɔ́ ɛ, bɛdhiiti bot nabɛ ɛ́ bɛ eezyɛ Yezu nɛ mot ngɔt nadi bubu ɔ, etɛɛ náá, embee sisim nadi edhek nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dáa Yezu nasɔ mbee sisim tak ɛ, é di tak wat mot'enɔk nabɛ ɛ́, nyɛ moo elii. Tin, ye nabɛ ɛ́ ɛdhuu ɛ bot ɛ nadi edi tak ɔ, moo tin edjoka. Bɔɔ náá: «Bis dinaa ààpaakobee kɔkɔ mbi yak sonok tɔ Yisalaɛl.» ");
INSERT INTO bkw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yɛ kabɛ eFalizyɛ ɔ, bɔɔ nake yɔbɔ ɛ́ náá: «Ye ɛ́ kukuma embee esisim ɛ di edjɛ Yezu mɛbwala mɛ nyɛ di esɔ embee sisim nɛ yɛ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yezu nadi ekɛ kɔ boo eghaada nɛ kɔ mɛl. Nyɛ nadi elelyo mɛdhuu mɛ bot tɔ mendjaa mɛ mendjaala mɛ eYuda. Nyɛ nadi egoola bɛ Mbɛɛ Bhaadal dum nɛ Ɛyoŋ ɛ Zɛɛb. Nyɛ nadi etsik bot ɛ di nɛ epel ɔ, zɛnɔɔ bot ɛ nadi nɛ edjam ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ye nabɛ ɛ́ ghoŋ naasa nyɛ ɛlyelɛpe dum nɛ ɛdhuu ɛ bot ɛ nadi tin ɔ. Etɛɛ náá, bot ɛ tak nadi ɛ́ bɛ eezewak dáa mɛsaa mɛ ebhata di ààbɛ nɛ mbaalel ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nyɛ ɛ́ boozɛke nɛ bɛdjekel bɛ náá: «Bhum nɛ bu tɔ bok, tin, bot ɛ ɛbɔ́k ààbu. ");
INSERT INTO bkw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ye goka ɛ́, bi djaala nɛ nakuma pyeeb náá, nyɛ baadhis bot ɛ mɛsa étɛp bɛ neezɛsa mɛsa tɔ pyeeb'ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yezu naazɛdjóo bɛdjekel bɛ kam nɛ bɛbá. Bhii tak, nyɛ eezɛdjɛ bɛ eghɛŋ ɛsɔ embee esisim nɛ ɛtsik ɛ bot ɛ di nɛ epel, zɛnɔɔ bot ɛ́ nadi nɛ edjam ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Beeka min mɛ bot ɛ lwoma kam nɛ bɛbá tak e: Mot mɛkɛn ɛ́ Simɔŋ nadjɛaa din ɛ Pyɛɛd ɔ, nɛ dhyeeb Andele, Zak bɛ nɛ dhyeeb Zaŋ, bɔɔ bɛbá nabɛ ɛ́ bɔn Zɛbɛdɛ, ");
INSERT INTO bkw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip nɛ Bhaatelemi, Toma zɛnɔɔ Matye nɔŋel epata e lapo, baazɛnɔɔ Zak mɔn Alfe, wɔ kabela ɛ́ Tade, ");
INSERT INTO bkw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔŋ, mot di tɔ ɛdhuu ɛ bot ɛ nadi edjóoaa eZɛlɔt ɔ, zɛnɔɔ Yudas Iskaliɔt mot naka Yezu ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yezu zokazɛlwom bɛdjekel bɛ kam nɛ bɛbá étɛp esa mɛsa mɛ. Nyɛy nɛ nɔɔ náá: «Bi ɛ́ kookyee mɛl mɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ. Sa bi ààni pɛ tɔ eghaada e bot ɛ Samali. ");
INSERT INTO bkw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bi goka nɛ ɛtɔ́ ɛ́, pɛ daa ebhata e bot ɛ mbyak Yisalaɛl nazewo ze ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ze ɛ ze, gheegoolaka nɛ bot náá: “Ɛyoŋ ɛ di tɔ gwoo ɛ, moo ɛ́ ɛkunaaɛpe!” ");
INSERT INTO bkw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tsikeka bot ɛ mɛbɛ́. Gomalka bot ɛ ze gwyɛ ɔ. Gelalka bot mɛbɛ́ mɛ zezam, ezezam bɔɔ. Sɔka embee esisim. Esa ee bi bela ààbɔm-bɔmak ɛ, djɛka bot yɛ yii toto. ");
INSERT INTO bkw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nànɔɔka elɔɔd, àànɔɔ epata, ààbaanɔɔ-nɔŋak dɔɔ nɛ meea étɛp ɛwa tɔ mengwyɛ da ɛ́ tɔ́ nɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nànɔɔka mɛkoo mɛ di tɔ́aa nɛ yɛ mɛdjoŋ ɛ. Nànɔɔka dhiiti kuwa. Nànɔɔka bɛdhiiti ekoko. Nànɔɔka sek, étɛp ɛtɔ́ mɛdjoŋ nɛ yɛ, etɛɛ náá, mot di esa mɛsa ɔ goka ɛ́ nyɛ bela sa dek. ");
INSERT INTO bkw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Bi ɛ́ kum kɔ dhiiti mɔɔ dɛl nɛghu kɔ ghaada ɔɔ, saaka mot di nɛ ghwyil ɛmyaal bin náá, bi sulal pɛ daa lɛ ɔ. Dika pɛ daa mot'enɔk. Bi dus tin ɛ, yɛ bɛ bi moo twol kɔ dɛl ɛ tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bi ɛ́ ni tɔ ndjaa mot ɔ, keka náá: “Bis eeswos bin hoo.” ");
INSERT INTO bkw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yɛ bɛ náá, bot ɛ ndjaa tak eemyaal bin ɔɔ, tin, egwyem bin di nɛ nɔɔ. Tin, bɛ pɛɛ náá, bi nàsulal tɔ mendjaa mɔɔ ɔɔ, betka egwyem bin sik nɛ nen. ");
INSERT INTO bkw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Yɛ bɛ náá, kɔ dhiiti dɛl nɛghu tɔ dhiiti ndjaa bɛ eepɛɛ náá, bi nàsulal ɔɔ, bɛ byen ɛgwak bin ɔɔ, wyiska yebɔ kɔ dɛl ɛ́ tak, nɛghu tɔ ndjaa tak, da bi ɛ́ kut piib mɛko men. ");
INSERT INTO bkw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mɛ lɛɛ bin ɛ́ etɛp etsɛɛtsɛ náá, é dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, dɛl ɛlenek aapɛ́ɛaa ɛ́ ɛlyelɛpe dhaa-dhaŋak epɛ́ɛ bot ɛ kyee mɛl mɛ Sodɔm nɛ Ghomɔɔd.» ");
INSERT INTO bkw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Gwakeka! Mɛ kyeed bin ɛ́ dáa ebhata kuku eben. Dika nɛ etsoŋ dáa bɛnyɔ, da bi ɛ́ di bot ɛ edɛɛ dáa mɛgum. ");
INSERT INTO bkw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dika bɛtsoŋ ɛ bot, etɛɛ náá, bot ɛ waakɛpit bin sok bhwoob bɛtetɛp, bi ɛ́ waanyuuŋaa nɛ eghwyɛs tɔ mendjaa mɛ mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kɔ ɛsu ɛ lam, bi ɛ́ waakɛtaŋal pɛ daa ekukuma nɛ bɛmɛkoozi, zɛnɔɔ pɛ daa bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ, étɛp bi needi bɛtyaasɛs ɛ etɛp ee bi nazebee ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","É sok bɛ aatɔ́ nɛ nen sok bhwoob bɛtetɛp ɛ, sa mot ààbem ba étɛp mɛkpa aawyis tɔ enuub bin nɛ dáa bi aataŋal ɛ. Mɛkpa mɛ taŋal ɛ́ waadjɛaa bin é di'enek wat. ");
INSERT INTO bkw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Etɛɛ náá, ye tok biyɔ aakalii tin. Ye ɛ́ Sisim Sɛɛg'en ɛ́ aapakalii é di'enek.» ");
INSERT INTO bkw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Bɔn mɔ ngɔt waakɛkael pak'ɔɔ é ɛsaŋ ɛ náá, mɔn nyɛɛg'ɔɔ neegóaa, dɔɔ nɛ bɛsɛɛg ɛ bɔn aazobaasa ɛ́ deenek nɛ bɔn bɔɔ. Bɔn ɛ́ waapit bɛbyael bɔɔ, bɔɔ kɛmɛtaa, kwyɛ ndjɛ sɔs, góaa. ");
INSERT INTO bkw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bot djas ɛ́ waabhina bin, etɛɛ din ɛ lam. Ye ɛ́ bot ɛ aamaad lyem kɛkum pɛ ɛsik ɔ aapaabela tsik. ");
INSERT INTO bkw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","É sok bi aadi kɔ dhiiti ghaada ɛ, bot ɛ́ ghaada tak ɛ́ di esa bin esa e kokok nɛ etɛp ɛpes nɛ mezuk ɔ, kaabka, da bi ɛ́ tɔ́ pɛ dɛl ɛ sis. Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, bi aanàkwaasilal ɛkɛ kɔ mɛl mɛ di kɔ kyee dik Yisalaɛl ɔ djas, ɛsok nɛ náá, Sɛɛŋɛlɛ Mɔn Mot zyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Ye tok nɛ djekel aadhaa mot di elyo nyɛ ɔ. Ye tok nɛ mot-mɛsa di edhaa kukuma yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Djekel goka ɛ́, nyɛ di dáa lyoel yɛ. Da mot-mɛsa ɛ́ di dáa kukuma yɛ. Kwyii nakuma mɛbyel ɛ́ koodjóoaa Bɛlzebul, “Aah” gwyata nɛ bot ɛ mɛbyel mɛ! Bɛ aazoleleeaa ɛ́ leea.» ");
INSERT INTO bkw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Étɛp tak ɛ́ di náá, sa mot ààkaab bɛmbee bot binɔk. Dhiiti dwoo ɛ́ tak, dwoo di náá, esesɛɛ djas di syela ɛ́ waawyis é gwyɛ ɛ. Esesɛɛ djas di tɔ syaab ɛ waaguaa. ");
INSERT INTO bkw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tɛp mɛ di elɛɛ bin tɔ ghooghom ɛ, lɛɛka yɛ popoopwon é mwos dwoo. Etɛp ee bi nadi nyiiŋlaa tɔ ɛlɔ ɛ, tuudka yɛ ɛlyelɛpe kɔ emii e mendjaa. ");
INSERT INTO bkw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nàkaabka bot ɛ di egu ɛgó epuud ɔ, etɛɛ náá, bɛ aanàkwaagó sisim. Bi goka ɛ́ nɛ ɛkaab ɛ Zɛɛb mot di nɛ ghwyil ɛgó sisim nɛ epuud tɔ du na kɔm-kɔm ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tin, bɔɔ enen ebá tok wak ebɔmsaa nɛ ba mɔɔ pata wat é? Bela náá, ngɔt pak'ɔɔ tok nɛ ghwyil ɛkwyit é bɔs, Sɛɛg'en ɛ di ààmyaal ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yɛ kabɛ biyɔ bɛ ɛmet ɔ, mɛko mɛ bhoo di tɔ elo bin djas ɛ́ elaŋa. ");
INSERT INTO bkw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sa mot ààbem ba etɛɛ náá, é mis mɛ Saag'am bi dhaa bɛtɛ nɛ bɔɔ enen nɛ boo mɛtaŋ!» ");
INSERT INTO bkw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Mot aamyaal popoopwon é mis mɛ bot djas náá, nyɛ ɛ́ djekel'am ɔɔ, mam pe, mɛ waamyaal nyɛ é mis mɛ Saag'am di tɔ gwoo ɔ náá, nyɛ ɛ́ ngbam. ");
INSERT INTO bkw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bela náá, mot aakɛla popoopwon é mis mɛ bot djas náá, nyɛ tok djekel'am ɔɔ, mam pe, mɛ waakɛla nyɛ é mis mɛ Saag'am di tɔ gwoo ɔ náá, mɛ ààgu nyɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Nàgekeka náá, mɛ nazyɛ kɔ bɔs ɛ́, étɛp egwyem tɔ bot. Mɛ nabɛ ɛ́ ààzyɛ, zɛwa egwyem nɛ ɛgwakel tɔ bot. Mɛ nazyɛ ɛ́ zɛkus ɛghuub nɛ ɛzɛbɛk ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mɛ nazyɛ ɛ́ zɛwa membɛk pak sɛɛg nɛ mɔn motom, pak nyɛɛg nɛ mɔn moma, pak nakɔla nɛ bhɛɛbel. ");
INSERT INTO bkw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bot ɛ mɛbhuka men aadi ɛ́, bot ɛ mɛbyel men met. ");
INSERT INTO bkw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mot di ekwyɛl mot ngɔt pak sɛɛg nɛ nyɛɛg, dhaa mɛ ɔɔ, mot tak ààkɔa nɛ nam. Mot di ekwyɛl mɔn'ɛ mɔɔ moma, nɛghu mɔn'ɛ mɔɔ motom dhaa mɛ ɔɔ, mot tak ààkɔa nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mot ɛ di ààbɛp mɛlaaba mɛ, da nyɛ ɛ́ du mɛ ɔɔ, mot tak ààkɔa nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mot aakwyɛl ɛkwyɛɛg tsik'ɛ dhaa mɛ ɔɔ, nyɛ waasu tsik'ɛ. Mot aakakwyɛl ɛsu tsik'ɛ étɛp ɛdu ɛ mɛ ɔɔ, nyɛ waabela tsik.» ");
INSERT INTO bkw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Mot aamyaal náá, bi sulal tɔ ndjaŋ'ɛ ɔɔ, nyɛ myaal ɛ́ mam. Mot aamyaal mɛ tɔ ndjaŋ'ɛ ɔɔ, nyɛ myaal ɛ́ mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mot aamyaal ngoolel-mɛkpa ɛ Zɛɛb tɔ ndjaŋ'ɛ da dil nyɛ náá, nyɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb ɔɔ, nyɛ waabela efute ee di egyee nɛ ngoolel-mɛkpa ɛ Zɛɛb ɛ. Mot di emyaal mot epiki, etɛɛ náá, nyɛ ɛ́ mot epiki ɔɔ, nyɛ waabela efute mot epiki di gyee nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, mot aadjɛ dhiiti ba mɔɔ djekel'am ngɔt ba mɔɔ bɛɛlɛ mɛdii mɛtela, etɛɛ náá, nyɛ ɛ́ djekel'am ɔɔ, nyɛ waabela efute bɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dáa Yezu nasilal ɛlyo bɛdjekel bɛ kam nɛ bɛbá ɛ, nyɛ eezɛdus tin, tɔ́ kɛlyo nɛ ɛkɛgoola Mbɛɛ Bhaadal pɛ eghaada kyee dik'enek. ");
INSERT INTO bkw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zaŋ Nduuel-bot pɛ nyɛ nadi tɔ ndjaa membok ɛ, nyɛ naagwak menduk ɛ Mɛsia. Tin, nyɛ ɛ́ boolwom bɛdhiiti bɛdjekel bɛ ");
INSERT INTO bkw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bɛ kɛdji Yezu náá: «Ye ɛ́ wɔy ɛ́ di Mɛsia nabɛ náá, nyɛ ɛpezyɛ “ohoo”, nɛghu ye ɛ́ náá, ye baabwoodaa dhiiti di baazyɛ ɔ?» ");
INSERT INTO bkw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Kɛlɛɛka Zaŋ sa bi bee ɛ́ nɛ yii bi gwak nɛ mɛlɔ men ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bot ɛ edhim moo nyaa sok. Eboka e bot moo kɛ. Bot ɛ mɛbɛ́ mɛ zezam eezetsak. Bɛ na endiila e mɛlɔ moo gwak, bot ɛ nazegwyɛ ɔ, bɛ ɛ́ zegom. Mbɛɛ Bhaadal ɛpegoolel kɛkum pɛ daa bɛdjel ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mɛnyɔ nɛ mot aadi ààdis ɛbwaalel ɛ lɛ kɔ lam ɔ!» ");
INSERT INTO bkw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bhii bɛdjekel ɛ Zaŋ nasik ɛ, Yezu moo tin elii nɛ zukamwaa nɛ mot nadi tin ɛ kɔ ɛsu ɛ Zaŋ. Nyɛy nɛ nɔɔ náá: «Bi nakɛbee yé pɛ tɔ kyee dik bɛsyɛ di ààbɛ nɛ mɛdii ɛ? Bi nakɛbee ɛ́ mɔɔ le ghwaazok edheegel nɛ pup é? ");
INSERT INTO bkw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“Ha” bi nakɛbee yé pɛ kyee dik bɛsyɛ di ààbɛ nɛ mɛdii ɛ? Bi nakɛbee ɛ́ mot ngɔt nɛ vaŋ mbi bhet é? Bi nɛ gu náá, bot ɛ dyeebabɔt evaŋ ekaad ɔ dyeebadi ɛ́ pɛ tɔ eboo mendjaa bɛmɛkoozi. ");
INSERT INTO bkw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bi nakɛbee yé? Bi nakɛbee ɛ́ ngoolel-mɛkpa ɛ Zɛɛb é? Nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá, nyɛ eedhaa-dhaŋak ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Etɛɛ náá, ye ɛ́ kɔ ɛsu ɛ Zaŋ ɛ ekwyala nalɛɛ náá: “Ɛsok nɛ wɔ nɛ tɔ́, mɛ waalwom ngoola-ngoola yam, nyɛ neekɛdii wɔ ze.” ");
INSERT INTO bkw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá: pɛ tɔ bot djas Zɛɛb nasa ɔ, ye tok nɛ mot dhaa Zaŋ Nduuel-bot. Tin, mot di mɔɔ dhyeeb tɔ Ɛyoŋ ɛ di tɔ gwoo ɔ, ɛ́ boo boo-mot nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kɛkan membu mɛ Zaŋ Nduuel-bot nadi elyo bot tɔ mɛkpa ɛ Zɛɛb ɛ, kɛyaka nɛ ɛlu ɛ mos, ɛni ɛ tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ nɛ lyel. Bot ɛ di nɛ mɛghaaz ɛ́ di nɛ ghwyil ɛdɛk yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kana nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb djas, zɛnɔɔ etsi ɛ Moiiz, mɛkpa mɛ Zɛɛb naagoolel kɛkum membu mɛ ɛkwyil ɛ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bi ɛ́ kwyɛl ɛtiibal ɛnyɔɛpe ɔɔ, ye ɛ́ Zaŋ ɛ́ di Eli, ngoolel-mɛkpa ɛ Zɛɛb nalookɛkaa náá, nyɛ waabula ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yɛ bɛ náá, bi ɛ́ nɛ mɛlɔ ɔɔ, gwakeka yɛ ɛnyɔɛpe! ");
INSERT INTO bkw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Mɛ gek bot ɛ membu mak nɛ bɛzɛ? Bɛ ɛ́ dáa zɛɛga bɔɔ dhyeeb mendiindil kɔ ɛbɛsɛɛ ɛ bot djas di di ɛ, da bɛdhiiti ɛ́ gheetsim kɔ bɛsɔ bɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Bis eebwom bin ngɔmbi, bi ààpabɔl. Bis eedjeeb bin mɛdjeeb mɛ ɛsyee, bi ààpadje!” ");
INSERT INTO bkw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Etɛɛ náá, Zaŋ eezyɛ, nyɛ nabɛ ɛ́, nyɛ eetsi edee nɛ mɛnyok. Deenek, bot kake ɛ́ náá: “Ye ɛ́ embee esisim ɛ di sa nyɛ deenek!” ");
INSERT INTO bkw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sɛɛŋɛlɛ Mɔn Mot eezyɛ. Nyɛ ɛpedɛ yɛ edee nɛ mɛnyok me vin, bi kake ɛ́ náá: “Beeka nwyak é? Mɛsa mɛ ɛ́ ɛdɛ edee nɛ dɛ mɛnyok mɛ vin, nyɛ be mɛsɔ ɛ́ nɛ bɛnɔŋel ɛ epata e lapo dɔɔ nɛ bot ɛ di nɛ mbee tsik ɔ!” Tin, etsoŋ e Zɛɛb nadi enyen tɔ mɛsa mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tin, Yezu eezɛni nɛ mɛlyo mɛ ɛdul ɛ mɛlɔ mɛ bot ɛ eghaada ee nyɛ nasa bɛtɛ nɛ endem e mɛbwala ɔ, etɛɛ náá, bot ɛ eghaada tak nabɛ ɛ́ ààliig elyem bɔɔ. Nyɛ ɛ́ boozɛlɛɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Haa kpaa-ghoŋ nɛ nɔ, dɛl ɛ Koodazin, kpaa-ghoŋ nɛ nɔ, dɛl ɛ Bhɛtsaida! Etɛɛ náá, bɛtɛ nɛ endem e mɛbwala nasael pɛ yebɔ ɔ, yɛ ɛpedi ɛ́ di náá, ye nasael ɛ́ pɛ eghaada Tiid nɛ Sidɔn ɔɔ, pe bot ɛ eghaada binɔk naaloobɔt kaad ɛpum, pe bɛ naazelɔɔba mɛsii, pe bɛ naaloozeliig elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Étɛp tak ɛ́ mɛ di elɛɛ nɛ nen náá, dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, yebɔ epɛ́ɛ ɛ́ waadhaa yii bot ɛ eghaada Tiid nɛ Sidɔn nɛ mɛlyel. ");
INSERT INTO bkw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yɛ kabɛ wɔy ɔɔ, dɛl ɛ Kapɛlnaum, wɔ gek ɛ́ náá, wɔ ɛ́ nɛ ghwyil ɛ byet tɔ́ pɛ tɔ gwoo? Wɔ waasilaa kɛkum pɛ dɛl ɛ bot ɛ nazegwyɛ ɔ. Etɛɛ náá, endem e mɛbwala mɛ nasɛɛ penek ɛ, ye ɛpedi ɛ́ di náá, ye naasɛɛ ɛ́ pɛ dɛl ɛ Sodɔm ɔɔ, pe dɛl ɛlenek dinaa tak dɔɔ nɛ mos. ");
INSERT INTO bkw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Étɛp tak ɛ́ mɛ di elɛɛ bin náá, dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, epɛ́ɛ nyɛ aapɛ́ɛ bin ɛ, yɛ waadhaa yii bot ɛ ghaada Sodɔm nɛ mɛlyel.» ");
INSERT INTO bkw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","É ghɛŋ tak, Yezu naazɛke náá: «Hyee Bhaaba, Ghɛŋ gwoo nɛ bɔs, mɛ ɛpeghaapɛɛ wɔ, etɛɛ náá, esesɛɛ wɔ nasyel bɛtsoŋ ɛ bot nɛ bot ɛ di etselal ɔ, wɔ eelyaal yɛ nɛ bɔɔ dhyeeb. ");
INSERT INTO bkw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyoo, Bhaaba, wɔ nakwyɛl ɛ́, ye sɛɛ deenek. ");
INSERT INTO bkw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Saag'am naadjɛ mɛ esonok djas. Ye tok nɛ mot di egu Mɔn Zɛɛb, yɛ di ààbɛ Sɛɛg nyɛ ɛmet ɔ. Deenek, ye tok nɛ mot di egu Sɛɛg, yɛ di ààbɛ Mɔn nɛghu mot Mɔn aakwyɛl ɛlyaal ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Biyɔ, bot ɛ zewak étɛp ɛbɛp edil-dil mɛkɔm men ɔ, dhaka pɛ daa lam, mɛ needjɛ bin ɛwala. ");
INSERT INTO bkw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Bɛpka kɔm etɛp bam. Tin, betka náá, mɛ djɛ bin etsoŋ, etɛɛ náá, mam ɛ́ mot mɛsila nɛ ɛtela ɛ lyem. Tin, bi ɛ́ waabela di ɛwala biyɔ bɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kɔm mɛ di edjɛ bin ɛ́, yɛ ààdil, ɛbɛp ɛ lam mɛ di djóo bin náá, bi zɛbɛp ɛ, ye nɛ gwyaa.» ");
INSERT INTO bkw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Dhiiti dwoo saba, Yezu nadi edhaa tɔ pyeeb kɔkɔ mbi bhek bhisa di edjóoaa ble ɛ. Tin, wɔ gwaa, za zɛbe bɛdjekel bɛ, bɛ moo tin ebɔ́k mɛbhisa mɛ tak étɛp ɛdɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dáa eFalizyɛ nabee deenek ɛ, bɛ eezɛke nɛ Yezu náá: «Beea, bɛdjekel bɔ ɛpesa esesɛɛ di náá, yɛ ààpadjɛaa bɛ ze dwoo saba ɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yezu zokazɛbɔɔza nɛ nɔɔ náá: «Bi nabɛ ɛ́ ààlaa sa Dhavid nasa é sok bɛ nɛ bot ɛ nadi egyee bɛ nɛ bɛ nɔɔ nagwak za ɛ? ");
INSERT INTO bkw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ye nabɛ ɛ́, bɛ nɛ bot ɛ lɔɔg'ɛ naani tɔ ndjaa Zɛɛb, bɔɔ zokakɛdɛ emapa ee nakaŋaa Zɛɛb ye ɛ́. Dhi ye di náá, bɛ nabɛ ɛ́ ààgoka nɛ ɛdɛ emapa e tak. Etɛɛ náá, etsi bina lɛɛ ɛ́ náá, bot ɛ di egoka nɛ ɛdɛ emapa e tak ɔ, ye ɛ́ bɛghaa-Zɛɛb bɔɔ bɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nɛghu bi nabɛ ɛ́ ààlaa tɔ etsi ɛ Moiiz náá, bɛghaa-Zɛɛb nadi esa mɛsa tɔ Ndjaa-ebuwa dwoo saba ɔ, bɛ nabɛ ɛ́ ààdi eduwal etsi e saba, dhi bɔɔ, ààbela ndjɛ kɔ ɛsu ɛ tak é? ");
INSERT INTO bkw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tin, betka mɛ lɛɛ bin náá, wak, ye ɛ́ nɛ sonok wat di edhaa Ndjaa-ebuwa nɛ mɛbɔk ɔ! ");
INSERT INTO bkw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bi ɛ́ pe di egu ɛnyɔɛpe sa ɛsuk ɛ ekwyala bak: “Mɛ kwyɛl ɛ́ enɛm esa, ààkabɛ ebuwa e bɛtit” di ekwyɛl ɛlɛɛ ɔ, pe bi ààpazyɛ zɛpit bot ɛ di ààgu tɛp ɔ gwyes. ");
INSERT INTO bkw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Etɛɛ náá, Sɛɛŋɛlɛ Mɔn Mot ɛ́ di kukuma dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bhii tak, Yezu eezɛdus tin, nyɛ eezɛtɔ́ pɛ ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tɔ ndjaa mendjaala mɛ eYuda e tak, ye nabɛ ɛ́ nɛ dhiiti mot ngɔt nadi nɛ sɔɔbela mbɔ ɔ. Ɛkwosak ɛ eFalizyɛ nabɛ ɛ́, Yezu bela ndjɛ é mis mɔɔ. Étɛp tak ɛ́ bɛ nadji nyɛ náá: «Etsi bina ɛpemyaal náá, mot tsikaa dwoo saba?» ");
INSERT INTO bkw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Yɛ bɛ náá, mot ngɔt pak'en ɛ́ nɛ sim bhata ngɔt ɔɔ, nyɛ gwak náá, dwoo saba, sim bhata tak eekwyit tɔ guk na dim-dim ɔɔ, nyɛ aanàkwaatɔ́ kɛwyisal nyɛ tɔ guk tak é? ");
INSERT INTO bkw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dáa ye di náá, mot eedhaa bhata nɛ mɛtaŋ ɛ, tin, etsi lɛɛ ɛ́ náá, mena saka bot enɛm esa dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yezu ɛ́ boozɛke nɛ mot nadi nɛ sɔɔbela mbɔ ɔ náá: «Sɛɛba mbɔ'ɔ.» É di tak wat, mbɔ mot'enɔk eezɛbula ɛnyɔɛpe, dáa yak dhiiti mbɔ. ");
INSERT INTO bkw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bhii tak, eFalizyɛ ɛ́ boozɛdus tin, tɔ́ yɔbɔ. Wɔ gwaa bɛ kɛsɛɛga é kwan, étɛp ɛdjek dáa bɛ aadjɛ nyɛ epɛ́ɛ e ɛsyee ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Dáa Yezu nagwak deenek ɛ, nyɛ eezɛdus tin, wɔ gwaa, zukamwaa nɛ mot zokadu nyɛ. Wɔ gwaa, nyɛ zokazɛtsik membel djas. ");
INSERT INTO bkw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tin, nyɛ eezɛlyak bɛ ɛlyelɛpe náá, bɛ nàsa náá, bot gu mbi mot nyɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nyɛ nasa deenek ɛ́, etɛɛ náá, etɛp ee ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ ɛ́, ye neebela ɛsuk. Ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Zɛɛb lɛɛ ɛ́ náá: “Beea mot-mɛsa mam mɛ nasɛ́ɛ ɔ, mot mɛ di ekwyɛl ɔ. Lyem'am ɛ́ tɔ mɛmyaala kɔ ɛsu ɛ lɛ. Mɛ waawa Sisim'am tɔ lɛ. Tin, nyɛy ɛ́ aapagoola nɛ bot ɛ membyak djas, epiki bam mɛ aadhis ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nyɛ aanàkwaawaya nɛ bot. Nyɛ aanàkwaabiyo nɛ mot. Bi aanàkwaagwak gwood'ɛ é gba. ");
INSERT INTO bkw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nyɛ aanàkwaabwak-bwakak mɔɔ le ghwaazok di náá yɛ eezenyaabel ɛ. Nyɛ aanàkwaadimal mɔɔ ngel lama di esaa náá, ye dim ɛ. Nyɛ aasa deenek, kɛkum dwoo epiki bɛ aanyen é mis mɛ bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tin, bot djas di ààbɛ bot ɛ mbyak eYuda ɔ, bɛ waawa ɛbwaalel ɛ lɔɔ kɔ lɛ.”» ");
INSERT INTO bkw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wɔ gwaa bɛ zokazyɛ Yezu nɛ dhiiti mot, mot tak nadi ɛ́, bubu nɛ ɛbɛ́ ɛ edhim. Ye ɛ́ embee sisim ɛ nasa mot tak deenek. Tin, Yezu eezɛtsik mot tak, nyɛ moo tin elii nɛ ɛnyaasok. ");
INSERT INTO bkw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɛdhuu mɛ bot ɛ nadi tin ɔ, naadyeebadjoka. Bɛ moo tin eke náá: «Wɔ ke ɛ́ nwyak tok Mɔn Dhavid é?» ");
INSERT INTO bkw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dáa eFalizyɛ nagwak bot binɔk elii ɛ, bɛ boozɛke náá: «Mot tak sɔ embee sisim ɛ́ etɛɛ náá, Bɛlzebul kukuma embee sisim ɛ, di edjɛ nyɛ kɔkɔ yak mbi mɛbwala mɛ nyɛ di esɔ embee sisim nɛ yɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","É di'enek, Yezu nadi egu egeka e elyem bɔɔ, nyɛ boozɛlɛɛ nɛ nɔɔ náá: «Ɛyoŋ ɛ di náá, mɛsa mɛ bot ɛ tak ɛ mɛwɔ nɛ edho pak'ɔɔ, ɛsik ɛyoŋ ɛ tak ɛ́ ɛbel nɛ ɛwaazel. Bot tɔ ghaada wat nɛghu bot ɛ mɛbyel mɛ wat, ɛ di nɛ mɛwɔ nɛ etuub pak'ɔɔ ɔ, yenek mɛbyel nɛ yenek ghaada aanàkwaapyet ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Yɛ bɛ náá, Satan moo sɔ sa di náá, ye ɛ́ yɛ Satan ɛ, bi ààbee náá, Satan kaduu tuub ɛ, bɛ nɛ nyel'ɛ met e? Tin, ɛyoŋ ɛ lɛ aakapyet dáa? ");
INSERT INTO bkw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","«Yɛ bɛ náá, mam sɔ embee sisim ɛ nɛ ghwyil ɛ Bɛlzebul ɔɔ, ɛzɛ di edjɛ bot bin ghwyil bɔɔ di esɔ embee sisim nɛ yɛ ɛ? Mɛ bee ɛ́ náá, ye ɛ́ bɔɔ bɛ nakuma tak ɛ aapalyaal bin náá, bi tok nɛ gham. ");
INSERT INTO bkw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sa di tsɛɛtsɛ ɛ́ náá: mɛ sɔ embee sisim ɛ́ nɛ ghwyil ɛ Sisim ɛ Zɛɛb. Yenek djas kwyɛl ɛlɛɛ ɛ́ náá, Ɛyoŋ ɛ Zɛɛb moo ɛ́ wak nɛ nena é di wat. ");
INSERT INTO bkw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Ye tok nɛ mot di nɛ ghwyil ɛni tɔ ndjaa mot mɛnyan, da ɛ́ nɔɔ esa e ndjaa mot tak, nyɛ di ààkɔl nyɛ mɛmbɔ nɛ mɛko ɔɔ. Ye ɛ́ bhis ɛkɔl nyɛ ɛ, nyɛ aakabela ghwyil ɛnɔɔ esa e ndjaŋ'ɛ djas, da nyɛ ɛ́ wyis tɔ́ nɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mot di ààdi pɛ yam kyee ɔ, ye lɛɛ ɛ́ náá, mot tak ɛ́ mot di ebhina mɛ ɔ. Tin, mot di ààkwyee mɛ é ɛsɛɛg ɛ bot ɔ, nyɛ waaz ɛ́ waazak. ");
INSERT INTO bkw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Étɛp tak ɛ́ mɛ di elɛɛ bin náá, mɛ ɛ́ nɛ ghwyil ɛpel mesyem mɛ bot djas, ye nakoozodi ebyas nɛ embee esesɛɛ bɛ nasa Zɛɛb ɛ. Yɛ kabɛ náá, mot eebyasal Sisim na Dɛɛ ɔɔ, nyɛ aanàkwaapelaa. ");
INSERT INTO bkw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mot ɛ́ lii ɛbiyoɛpe nɛ Sɛɛŋɛlɛ Mɔn Mot ɔɔ, mesyem mɛ ɛ́ nɛ ghwyil ɛpelaa. Tin, mot ɛ́ lii ɛbiyoɛpe nɛ Sisim na Dɛɛ ɔɔ, mesyem mɛ aanàkwaapelaa tɔ tsik mena dika mos'aak nɛghu tsik ɛbhis.» ");
INSERT INTO bkw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Étɛp wɔ neebela mbɛɛ bhum, ye goka ɛ́ le pookokan ɛdi sok mbɛɛ le. Etɛɛ náá, le ɛ́ di nɛ ɛbɛ́ ɔɔ, bhum tak aabaazodi ɛ́ mɛbɛ́ nɛ mɛbɛ́, etɛɛ náá, le gwyakaa ɛ́ nɛ bhum di ekwyil é tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mbyak mɛgel! Bi aakwak ɛlii embɛɛ etɛp dáa, bela náá bi ɛ́ bɛmbee ɛ bot? Etɛɛ náá, nuub dyeebawyisal ɛ́ etɛp ee zelwood tɔ lyem ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mbɛɛ mot nɔɔ etɛtɛ etɛp ee nyɛ di lii ɛ́ tɔ ɛkwom ɛ mbɛɛ esesɛɛ bɛ. Tyɛ wat nɛ mbee mot, nyɛ nɔɔ embee etɛp ee nyɛ di elii ɛ́, tɔ ɛkwom ɛ mbee esesɛɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Betka mɛ lɛɛ bin, sa di tsɛɛtsɛ náá, dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, bot ɛ waatyaa sok bhwoob bɛtetɛp étɛp mɛlee mɛ bɛ nadi elee bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Etɛɛ náá, ye ɛ́ kɔ mɛkpa mɔ met ɛ wɔ aabela gham nɛghu ɛkwyɛ ndjɛ sɔs é mis mɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","É di'enek, bɛdhiiti bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ zokazɛdji Yezu náá: «Lyoel! Bis kwyɛl ɛ́ náá, wɔ lyaal bis dhiiti ndem mɛbwala.» ");
INSERT INTO bkw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Étɛp yé di náá, bot ɛ di ewaab mos dhiiti ndem mɛbwala pɛ daa Zɛɛb ɔ, di di bɛmbee ɛ bot, bot ɛ di ààbɛ sosoob é mis mɛ Zɛɛb ɔ? Tin, Zɛɛb aazolyaal bɛ ɛ́ ndem wat. Yɛ aadi ɛ́ kɔkɔ mbi ndem ngoolel-mɛkpa ɛ Zɛɛb Yonas nabee ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ye ɛ́ tyɛ wat nɛ dáa ngoolel-mɛkpa ɛ Zɛɛb Yonas nakpaa emwos elɛl nɛ epum elɛl tɔ mɔ boo su ɛ, Sɛɛŋɛlɛ Mɔn Mot aabaasa ɛ́ emwos elɛl nɛ epum elɛl tɔ bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, bot ɛ ghaada ɛ Niniv ɛ waazyɛ, zɛtyaa sok bhwoob bot ɛ di mos'aak étɛp ɛpit bɛ, deenek, bɛ neekwyesal ndjɛ sɔs. Etɛɛ náá, gwaka bɛ nagwak Yonas é ɛlyo bɛ mɛkpa mɛ Zɛɛb ɛ́, ye nabɛ ɛ́ bot ɛ Niniv naaliig elyem bɔɔ. Ye nyɔ ɛ́, bi gu náá, mot di nenak wak'aak, nyɛ eedhaa Yonas. ");
INSERT INTO bkw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, mɛkoozi mɛ moma dɛl ɛ di pɛ kyɛ bɔs ɛ́ waazyɛ, zɛtyaa sok bhwoob bot ɛ di mos'aak étɛp ɛpit bɛ, deenek, bɛ neekwyesal bɛ ndjɛ sɔs. Etɛɛ náá, nyɛ nadus ɛ́ pɛ mɛdhik mɛ ɛtseta, nyɛ ɛ́ boozɛgwak mbɛɛ mɛlyo mɛ etsoŋ e mɛkoozi Salomɔŋ. Ye nyɔ ɛ́ bi gu náá, mot di nenak wak'aak, nyɛ eedhaa Salomɔŋ!» ");
INSERT INTO bkw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«É sok mbee sisim di ewyis tɔ nyel mot ɛ, nyɛ katɔ́ ɛ́ pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, kɛsaa di nyɛ aakɛdi ɛ. É di nyɛ aakadi ààbela di nyɛ aadi ɔ, ");
INSERT INTO bkw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nyɛ kake ɛ́ náá: “Mɛ pookosik pɛ ndjaŋ'am, ndjaa mɛ nawyis tɔ tak sok ɛ.” Tin, sika nyɛ aakasik ɛ, nyɛ aabela ndjaa tak toto, bɛ eezewaabal nɛ ɛkoobal yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tin ɛ nyɛ aakatɔ́, kɛnɔɔ bɛdhiiti embee esisim bɛ na nyan-nyan bɛtɛn nɛ bɛbá di edhaa nyɛ nɛ embee mɛsa ɔ. Tin, bɔɔ djas kabula ɛ́ tɔ ndjaa tak, da ɛ́ be di tin. Deenek, tsik yenɔk mot eezepulel dhaa-dhaŋak yii nabɛ sok ɛ. Yɛ aadi ɛ́ deenek étɛp bɛmbee ɛ bot di pak'ena mos'aak.» ");
INSERT INTO bkw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yezu dinaa kuku ɛlii, wɔ gwaa bɔn nyɛɛg nɛ nyɛɛg zɛkum é di nyɛ nadi ɔ. Bɛ eezɛtyaa pɛ kel. Tin, bɛ nadi ekwyɛl ɛlii nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dhiiti mot ɛ́ boozɛlɛɛ Yezu náá: «Beea, nyoog nɛ bɛdhyeeb bɔ ɛ́ pɛ kel, bɛ ɛpekwyɛl ɛlii nɛ nɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yezu ɛ́ boozɛbɔɔza nɛ mot'enɔk náá: «Nyaag'am ɛ́ zɛ, da mɔn nyaag'am ɛ́ kadi bɛ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bhii tak, nyɛ eezɛlyo bɛdjekel bɛ nɛ djin. Nyɛy náá: «Beeka nyaag'am, nɛ bɔn nyaag'am di wak e. ");
INSERT INTO bkw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Etɛɛ náá, ye ɛ́ mot di esa ɛkwosak ɛ Saag'am di tɔ gwoo ɔ, di mɔn nyaag'am, kɛl'am nɛ nyaag'am.» ");
INSERT INTO bkw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dwoo tak wat, Yezu nadus ɛ pɛ ndjaa nyɛ nadi ɛ́, nyɛ ɛ́ boozɛtɔ́, kɛdisi pɛ ɛboŋ ɛ boo soob na djato-djato. Tin, nyɛ moo zɛlyo bot. ");
INSERT INTO bkw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wɔ gwaa, zukamwaa nɛ mot zokazɛmaala é di tak. Dáa nyɛ nabee náá, zukamwaa nɛ mot naazɛsɛɛga tin ɛ, nyɛ ɛ́ boozɛni tɔ dhiiti elɛɛd, nɔɔ nyel, disi. Nyɛ eezɛpus elɛɛd tɔ dii, ɛdhuu ɛ bot eezɛlik pɛ kyiid é ngwoob dii. ");
INSERT INTO bkw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mɛlyo mɛ nyɛ nalelyo bɛ ɛ nadyeebabu ɛ́ tɔ ekana. Tɔ ekana ee nyɛ nadi elyo bɛ nɛ yɛ ɛ, wat nabɛ ɛ́ kɔ ɛsu ɛ sɔsel mɛbhek. Tin, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Dhiiti dwoo mot ngɔt natɔ́ pɛ pyeeb kɛsɔs bhek. ");
INSERT INTO bkw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dáa nyɛ nakadi emwam bhek tak ɛ, kyee wat nakwyit ɛ́ é gba. Wɔ gwaa enen zokazɛdɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yak kyee kakwyit ɛ́ kɔ bat ɛkok. Tin, ààkobɔya deenek, mɛbhek eezɛkwyil, etɛɛ náá, di tak nadi ɛ́, nɛ ba bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","É di gwyes na ghɛ-ghɛ nakakas ɛ, wɔ gwaa mɛbhek djas zɛsyee, etɛɛ náá, ekaŋal e tak nabɛ ɛ́ ààni tɔ bɔs ɛdimɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yak pak mɛbhek nakakwyit ɛ́ tɔ engwyinini. Wɔ gwaa, engwyinini binek zokawyee, kala kɔ mɛbhek ààbɛ nɛ dáa mɛbhek wyee ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tin, mɛbhek mɛ nakakwyit kɔ mbɛɛ bɔs ɛ, naakwyil ɛnyɔɛpe, wɔ gwaa ye kwyil bhum. É kwos wat, bhum mɛkam-mɛlɛl, é yak mɛkam-mɛtɛn nɛ wat, é yak tak bhum dhet.» ");
INSERT INTO bkw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bhii tak, Yezu eezɛke náá: «Yɛ bɛ náá, bi ɛ́ nɛ mɛlɔ mɛ ɛgwak ɔɔ, gwakeka ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tin, bɛdjekel eezɛtiila pɛ pak Yezu nadi ɛ́, bɛ ɛ́ boozɛdji nyɛ náá: «Étɛp yé wɔ di elii nɛ nɔɔ tɔ ekana?» ");
INSERT INTO bkw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wɔ gwaa nyɛ zɛbɔɔza nɛ nɔɔ náá: «Biyɔ, bi eezedjɛaa etsoŋ ɛgu ɛsuk ɛ Ɛyoŋ ɛ di tɔ gwoo ɛ. Yɛ bɛ bɛsɔ bin ɔ, bɛ dinaa ààpaamɛt ɛsuk ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Etɛɛ náá, mot aadi nɛ ba bim sonok ɔ, bɛ waabil nyɛ dhiiti, étɛp ye neebu. Tin, mot aakadi toto ààbɛ nɛ sonok ɔ, bɛ waadɛk nyɛ dɔɔ nɛ eghutu-ghutu nyɛ lik nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Étɛp tak ɛ́ mɛ di elii nɛ nɔɔ tɔ ekana. Etɛɛ náá, bɛ ɛ́ nɛ ghwyil ɛgwyák nɛ mis, ààbee. Bɛ ɛ́ nɛ ghwyil ɛgwak nɛ mɛlɔ, dhi bɛ di ààsiiza sa ye di ekwyɛl ɛlɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ye ɛ́ deenek ɛ́, etɛp ee ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ ɛ́ aabela ɛsuk. Nyɛ nabɛ ɛ́, nyɛ eeke náá: “Bi ɛ́ waagwak ɛnyɔɛpe, bi ɛ́ aanàkwaagu ɛsuk ɛ tɛp tak. Bi ɛ́ waabee nɛ mis, bi aanàkwaasiiza ɛsuk ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Etɛɛ náá, bot ɛ mbyak'ak nɛ kalyel elyem dhaa nyel. Bɛ nɛ kasa maa-ɛlɔ dhaa tyɛ. Bɛ eezedipal mis mɔɔ étɛp bɛ ɛ́ zɛkɛbee. Bɛ eediyal mɛlɔ mɔɔ, ye nàgwak. Bɛ eezelu ɛtselal ɛ lɔɔ náá, ye nàgwak sonok. Tin, bɛ tok nɛ ghwyil ɛbula, dum koŋ nɛ Zɛɛb etɛɛ náá, Zɛɛb neetsik bɛ.”» ");
INSERT INTO bkw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Yɛ kabɛ biyɔ bɛ ɛmet ɔ, mɛnyɔ nɛ nen, etɛɛ náá, mis men ɛpebee, mɛlɔ men ɛpegwak! ");
INSERT INTO bkw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mɛ lɛɛ bin ɛ́ etɛp ee tsɛɛtsɛ náá: Bɛtɛ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb, bot ɛ epiki naadyeebakwos ɛbee nɛ ɛgwak sa bi di ebee nɛ gwak mos'aak. Bɛ ààpabela bhwoob ɛbee nɛ gwak sa bi di ebee mos'aak.» ");
INSERT INTO bkw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Biyɔ, bot bak! Gwakeka ɛsuk ɛ kana sɔsel mɛbhek: ");
INSERT INTO bkw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bɔs é ngwoob gba di bhek nakwyit ɔ, ye kwyɛl ɛlyaal ɛ bot ɛ nadi egwak etɛp Ɛyoŋ ɛ Zɛɛb, bɛ kadi ɛ́, ààmɛt ɛsuk ɛ tak ɔ. Tin, Mbee Mot eetuula, nyɛ eezɛdɛk mɛbhek bɛaa tɔ elyem bɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bɛdhiiti bot kadi ɛ́ dáa mɛbhek nakwyit kɔ bat ɛkok ɛ, é sok bɛ di egwak-gwakak mɛkpa ɛ Zɛɛb ɛ, bɛ nɛ dyeebamyaala tɔ elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tin, bɛ ààpakabet náá, mɛkpa mɛ tak pookoni bɛ tɔ ebhum elyem ɛnyɔɛpe. Bɛ kadi ɛ́, ààwa zii ɛbuɛpe tɔ ɛbaal ɛ mɛkpa mɛ tak. Tin, é ghɛŋ mezuk nɛ mɛbhowal aatuula bɛ kɔ ɛsu ɛ mɛkpa ɛ Zɛɛb ɔ, ɛliig ɛ lɔɔ koŋ nɛ Zɛɛb ààbɔya. ");
INSERT INTO bkw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bɛdhiiti tɔ len gwak mɛkpa ɛ Zɛɛb ɛ dáa kyee mɛbhek nakwyit tɔ engwyinini ɛ. Bɛ nɛ gwak mɛkpa ɛ Zɛɛb, ye kabela ɛ náá, yɔbɔ elyem ɛ́ tɔ ɛwyeeb ɛ esa e bɔs, mɛvu mɛ di ekɔɔ bot kɔ bɔs'ak ɛ, nɛ mbee esiiza tɔ elyem bɔɔ di enyal mɛkpa ɛ Zɛɛb ɛ. Tin, mɛbhek mɛ tak kadi ɛ́, ààwum. ");
INSERT INTO bkw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bɛdhiiti bot kadi ɛ́ dáa mɛbhek nakwyit kɔ mbɛɛ bɔs ɛ. Bɛ ɛpegwak mɛkpa ɛ Zɛɛb, myaal yɛ nɛ lyem wat, bɛ kakɛ ɛ́ dáa Zɛɛb kwyɛl ɛ. Tin, yɛ waawum ɛbuɛpe. Yak mɛkam-mɛlɛl, yak mɛkam-mɛtɛn nɛ ngɔt, yak dhet.» ");
INSERT INTO bkw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yezu zokabaalɛɛ bɛdhiiti kana sis: «Beeka dhiiti sonok di tyee Ɛyoŋ ɛ di tɔ gwoo ɛ: Dhiiti mot ngɔt naabɛ mbɛɛ mɛbhek tɔ pyeeb'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yak pum, é sok bot ɛ dɛl djas nadi é gɔ́ ɛ, wɔ gwaa dhiiti mot mɛbhuka mɛ zokazɛbɛ nyɛ mbee bhek tɔ pyeeb, nyɛ eezɛnɔɔ nyel sik. ");
INSERT INTO bkw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dáa mɛbhek nakawyee ɛ, yɛ eezɛwum, mbee mɛbhek menek eebaazɛwyee yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tin, bot ɛ mɛsa mɛ nakuma pyeeb tak ɛ́ boozɛlɛɛ nɛ kukuma yɔbɔ náá: “Ghɛŋ, wɔ nabɛ tɔ pyeeb'ɔ ɛ́ mbɛɛ mɛbhek, etsal é? Ha yak mbee bhek kadus paa?” ");
INSERT INTO bkw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: “Ye ɛ́ mot mɛbhuka ɛ́ sa esesɛɛ binek.” Bhii tak, bot ɛ mɛsa ɛ́ boozɛdji nyɛ náá: “Bis sa dáa, wɔ kwyɛl ɛ́, bis kɛdis embee mɛbhek menek é?” ");
INSERT INTO bkw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nyɛ eebaazɛbɔɔza nɛ nɔɔ náá: “Hoo! Ààbɛ! Etɛɛ náá, bi ɛ́ kɛgu yɛ ɔɔ, bi ɛ́ nɛ ghwyil ɛgu dɔɔ nɛ mbɛɛ mɛbhek lɔɔg wat nɛ yiizaag. ");
INSERT INTO bkw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Deenek, betka náá, mɛbhek menek djas wyee lɔɔg wat, kɛkum dwoo yɛ aakabɛ náá, bi moo kɛdis ɛ. Tin, mɛ waalɛɛ nɛ bot aakɛdis ɔ náá, bɛ pookokan sok ɛdis ɛ mbee bhek, da bɛ ɛ́ kɔl yɛ é di wat étɛp bɛ needik yɛ. Bhii tak ɛ bɛ aakasɛɛg mbɛɛ bhek, kwom kɔ taŋ'am.”» ");
INSERT INTO bkw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wɔ gwaa Yezu baazɛlɛɛ bɛ yak kana sis, nyɛy náá: «Ɛyoŋ ɛ di tɔ gwoo ɛ, ye ɛ́ dáa bhek le di edjɛ bhum di edjóoaa mutaad ɛ dhiiti mot nakɛbɛ pɛ tɔ pyeeb'ɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bhum mutaad ɛ́ bhek na sikɛ-sikɛ dhaa mɛbhek djas di ebɛaa kɔ ɛko ɛ bɔs ɛ nɛ mɛtɔɔl. Tin, é ghɛŋ yɛ di ekwyil ɛ, mɛbɔk mɛ di edhaa ele e bok djas nɛ mɛbɔk. Ye kadi ɛ́, ye moo le di náá, enen ɛpebatazɛlóo mɛk mɔɔ kɔ elɛɛ e tak.» ");
INSERT INTO bkw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yezu zokabaazɛdjɛ bɛdhiiti kana. Nyɛy nɛ nɔɔ náá: «Ɛyoŋ ɛ di tɔ gwoo ɛ, ye ɛ́ dáa moma di enɔɔ ba mɔɔ deez pu leviid, sɛɛg nɛ bɛtɛ nɛ pu falin, étɛp nyɛ neesa tsim mapa nɛ yɛ ɛ. Mɔɔ ɛwala bhii tak, tsim'enek djas kadi ɛ́, yɛ eezeghamta.» ");
INSERT INTO bkw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Mɛlyo mɛ Yezu nadyeebadjɛ mɛdhuu mɛ bot ɛ nabe-bɛ ɛ́ tɔ ekana. Nyɛ nabɛ ɛ́ ààdjɛ dhiiti mɛlyo, ààlɛɛ yɛ tɔ kana. ");
INSERT INTO bkw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nyɛ nasesa deenek ɛ́, etɛɛ náá, sa bɛngoolel ɛ mɛkpa ɛ Zɛɛb nalɛɛ ɛ́ neebela ɛsuk. Ye nabɛ ɛ́ bɛngoolel ɛ mɛkpa ɛ Zɛɛb naake náá: «Mɛ waalii nɛ nen tɔ ekana. Tin, mɛ waalɛɛ bɛ esa ee nadi syela kana bɔs nakusel ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Bhii tak, Yezu zokazɛdus tɔ ɛdhuu ɛ bot, nyɛ eezɛsik, tɔ́ pɛ ndjaa. Tin, bɛdjekel ɛ́ boozɛzyɛ pɛ nyɛ nadi ɛ. Bhii tak, bɛ ɛ́ boozɛke nɛ nɛ náá: «Lɛɛa bis ɛsuk ɛ kana mbee bhek tɔ pyeeb.» ");
INSERT INTO bkw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","É di'enek, Yezu ɛ́ boozɛni elɛɛ bɛdjekel bɛ náá: «Ye ɛ́ Sɛɛŋɛlɛ Mɔn Mot ɛ di bɛ mbɛɛ mɛbhek. ");
INSERT INTO bkw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pyeeb kwyɛl ɛlyaal ɛ́ mɛdhik djas di kɔ bɔs ɛ. Mbɛɛ mɛbhek kwyɛl ɛlyaal ɛ́ bot ɛ di ekɛ dáa Ɛyoŋ ɛ Zɛɛb di kwyɛl ɛ. Mbee bhek kalyaal ɛ́ bot ɛ Mbee Mot. ");
INSERT INTO bkw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mot mɛbhuka nazɛbɛ bhek ɔ, kabɛ ɛ́ Dim mot mɛkɔŋ. Dwoo ɛkɛbɔ́k bhum kabɛ ɛ́ ɛsi ɛ bɔs, bot ɛ mɛsa kwyɛl ɛlyaal ɛ́ efofop. ");
INSERT INTO bkw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Dáa ye di náá, embee mɛbhek ɛ́ waatsaalaa étɛp ɛkɛmwasaa tɔ du ɛ, yɛ aabaazodi ɛ́ deenek é ɛsi ɛ bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sɛɛŋɛlɛ Mɔn Mot ɛ́ waalwom efofop bɛ, nyɛ waadis tɔ Ɛyoŋ ɛ lɛ bot djas di ezɛm ɛmyaal ɛ bɔn nyɛɛg bɔɔ ɔ, zɛnɔɔ bot ɛ mbee mɛsa. ");
INSERT INTO bkw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nyɛ waamwas bɛ tɔ boo du di egoo na kɔm-kɔm ɛ. Penek, bot ɛbuɛpe aadi ɛ́ tɔ mɛgwyɛ nɛ ɛkwaal ɛ mɛtsok. ");
INSERT INTO bkw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tin, bot ɛ epiki ɛ́ waakas tɔ Ɛyoŋ ɛ Sɛɛg'ɔɔ dáa gwyes. Yɛ bɛ náá, bi ɛ́ nɛ mɛlɔ mɛ ɛgwak ɔɔ, gwakeka ɛnyɔɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ɛyoŋ ɛ di tɔ gwoo ɛ́ dáa di ɛkwom ɛ epata di syela tɔ pyeeb ɛ. Dáa dhiiti mot nakabela yɛ ɛ, nyɛ ɛ́ boobaazɛsyel yɛ é di sis tɔ pyeeb'enek. É di'enek, nyɛ moo ɛ́ tɔ mɛmyaala, etɛɛ náá, nyɛ nadi ekwyɛl ɛkɛbɔmsa esa bɛ djas étɛp nyɛ neezɛbɔm pyeeb tak. ");
INSERT INTO bkw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Ɛyoŋ ɛ di tɔ gwoo ɛ baanɔŋel ɛ́, nɛ mot di esaa esa e ghoŋ étɛp nyɛ neebɔmsa ɔ. Nyɛ dyeebasaŋ ɛ́ tɛtɛ esa e ghoŋ na nyenyɔ-nyɔ. ");
INSERT INTO bkw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yɛ kabɛ náá, nyɛ eebela yii na nyenyɔnyɔ dhaa bɛsɔ djas nɛ boo mɛtaŋ ɔɔ, nyɛ kakɛbɔmsa ɛ́ esa bɛ djas étɛp nyɛ neezɛbɔm yii zaag na boo mɛtaŋ.» ");
INSERT INTO bkw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɛyoŋ ɛ di tɔ gwoo ɛ, baanɔŋel ɛ́, nɛ ɛwyet bɛ di ela tɔ dii ɛ. Ɛwyet ɛ tak dyeebamɛt ɛ́ ekɔkɔ bɛsu djas. ");
INSERT INTO bkw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tin, yɛ bɛ náá, ɛwyet eezelwood ɔɔ, bɛlael ɛ mɛwyet kadul yɛ ɛ, zyɛ nɛ yɛ pɛ kyiid, da bɛ ɛ́ nɔɔ mɛnyel disi étɛp ɛdis ɛ́ bɛsu ɛ́ bel é ɛwyet ɛ tak ɔ. Tin, bɛ kabɛk bɛ edi ɛ́ bɛkak. Bɛ nɔɔ bɛtɛtɛ, wa tɔ mɛbɔɔl, yɛ kabɛ bɛ na sikɛ-sikɛ nɛ embee e tak ɔ, bɛ kamwas bɛ ɛ́ mwasak. ");
INSERT INTO bkw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ɛsi ɛ bɔs aadi ɛ́ deenek: Zɛɛb ɛ́ waadhis efofop bɛ zɛwa mbek pak mbee bot nɛ bot ɛ epiki. ");
INSERT INTO bkw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Etɛɛ náá, mbee bot ɛ́ waakɛlóoaa tɔ boo du na kɔm-kɔm. Tin, bot ɛbuɛpe waadje mɛgwyɛ nɛ ɛkwaal ɛ mɛtsok.» ");
INSERT INTO bkw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yezu zokazɛdji bɛ náá: «Bi eemɛt ɛsuk ɛ etɛp binek é?» Bɔɔ náá: «Iyoo» ");
INSERT INTO bkw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Étɛp tak ɛ́ di náá: ghaa mɛkana mɛ etsi djas di ekwos ɛdi djekel étɛp Ɛyoŋ ɛ di tɔ gwoo ɔ, nyɛ ɛ́ dáa kuma mot di enɔɔ ɛkwom ɛ lɛ pɛ tɔ mɛvu mɛ na mwa zɛnɔɔ yii na bes ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bhii Yezu nasilal ɛlyo bot tɔ ekana binek ɛ, nyɛ ɛ́ boozɛnɔɔ nyel, tɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nyɛ natɔ́ ɛ́ pɛ dɛl ɛ nyɛ nawyee kɔ tak ɛ. Nyɛ moo tin elyo bot tɔ ndjaa mendjaala mɛ eYuda. Tin, bot ɛ nadi egwak nyɛ ɔ, naadyeebadjoka ɛbuɛpe, bɛ moo tin eke náá: «Nyɛ kɛbela yak kwaambi etsoŋ nɛ mbi yak endem e mɛbwala paa? ");
INSERT INTO bkw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mɔn'ak tok wak mɔn salpande? Ye tok Maali di wak nyɛɛg é? Zak bɛ nɛ Zozɛf, nɛ Simɔŋ, zɛnɔɔ Yudas tok bɛdhyeeb é? ");
INSERT INTO bkw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Haa ye tok bɛkɛl mena nɛ bɛ nɔɔ di mɛlu djas é di wat'aak é? Ha nyɛ kɛbela yenek mɛbwala paa?» ");
INSERT INTO bkw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Egeka binek djas ɛ́ nasa náá, ɛmyaal nɛ ɛbwaalel ɛ bot binɔk djas dus kɔ Yezu. É di'enek, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Ngoolel-mɛkpa ɛ Zɛɛb dyeebaduwalaa ɛ́, pɛ kyee sis, ààbɛ pɛ kɔ dɛl ɛ nyɛ nabyel kɔ tak ɛ, nɛghu tɔ ndjaŋ'ɛ nɛ tɔ bil'ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yezu nabɛ ɛ́ ààsa bɛtɛ nɛ endem e mɛbwala tin, étɛp mɛlyel mɛ elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","É ghɛŋ tak Elood mot nadi mɛkoozi kɔ Yeluzalɛm ɔ, zokagwak menduk ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nyɛ ɛ́ boozɛke nɛ bot ɛ mɛsa mɛ náá: «Ye ɛ́ Zaŋ Nduuel-bot ɛ baagom ɛ́ gomak é! Étɛp tak ɛ́ nyɛ di nɛ ghwyil ɛsa bɛtɛ nɛ yenek endem e mɛbwala.» ");
INSERT INTO bkw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nɛ tsɛɛtsɛ, ye nabɛ ɛ́ mɛkoozi Elood naalwom náá, bɛ mɛt Zaŋ, da bɛ ɛ́ kɔl nyɛ nɛ eghwooz. Bhii tak, bɛ naakɛwa nyɛ é membok. Ye nabɛ ɛ́ étɛp Elodiaad, mwaa tel Filip, ");
INSERT INTO bkw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","etɛɛ náá, Zaŋ naake nɛ Elood náá: «Dum nɛ etsi ɛ Moiiz, ye ààgoka náá, wɔy dɛk Elodiaad mwaa tel'ɔ!» ");
INSERT INTO bkw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Étɛp tak ɛ Elood nakadi esaa dáa nyɛ aasa étɛp nyɛ neegó Zaŋ. Nyɛ nadi ekaab ɛdhuu ɛ bot ɛ mbyak eYuda, etɛɛ náá, bɔɔ djas nakeke ɛ́ náá, Zaŋ Nduuel-bot nabɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tinaak, é dwoo ɛbyoŋ ɛ Elood di eduwal ɛbyel ɛlɛɛ ɛ, ɛsyes ɛ Elodiaad naabɔl é mis mɛ bɛdjoŋ ɛ nadjóoaa é ɛbyoŋ ɔ. Elood naadyeebamyaala nɛ ko zɛŋ ɛsyes ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tin, mɛkoozi Elood ɛ́ booke nɛ ɛsyes ɛ mɔɔ moma yenɔk náá: «Myoŋ nɛ mɛsoŋ mam! Waaba esa ee lyem'ɔ kwyɛl ɛ djas, mɛ waadjɛ wɔ!» ");
INSERT INTO bkw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ɛsyes ɛlenɔk zokazɛwaab sa nyɛɛg nalɛɛ nyɛ ɛ. Nyɛy náá: «Mɛ kwyɛl ɛ́, wɔ djɛ mɛ nenak yak lo ɛ Zaŋ Nduuel-bot kɛla kɔ pɛt kongo na pyaaz!» ");
INSERT INTO bkw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wɔ gwaa, ye sa Mɛkoozi Elood nyel «wɔyɔŋ» nɛ ghoŋ. Tin, nyɛ nabɛ ɛ́ ààkabɛ nɛ tyee nyɛ pɛɛ, etɛɛ náá, nyɛ naazetuwal myoŋ nɛ mɛsoŋ mɛ é mis mɛ bɛdjoŋ. Nyɛ ɛ́ boozɛlɛɛ nɛ bot bɛ náá, bɛ djɛ nyɛ sa nyɛ nawaab ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tin, nyɛ eezɛlwom dhiiti mot étɛp nyɛ neekɛtsaal lo ɛ Zaŋ Nduuel-bot pɛ nyɛ nadi tɔ membok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wɔ gwaa, bɛ zokazyɛ nɛ lo ɛ Zaŋ kɔ pɛt kongo na pyaaz, bɛ eezɛdjɛ ɛsyes ɛ mɔɔ moma yenɔk. Tin, ɛsyes ɛ tak ɛ́ boonɔɔ yɛ, kɛdjɛ nɛ nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tin, bɛdjekel ɛ Zaŋ ɛ́ boozɛnɔɔ muu'ɛ, kɛdel. Bhii tak, bɛ ɛ́ boozɛtɔ́ kɛbaŋa Yezu etɛp djas nadhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Dáa Yezu nagwak etɛp binek djas ɛ, nyɛ ɛ́ boodus tin, nyɛ eezɛni tɔ elɛɛd, tɔ́, kɛsaa di ɛwala pɛ bot aadi ààbee nyɛ ɛ. Ghuna ɛdhuu ɛ bot naagu ze nyɛ natɔ́ ɛ, wɔ gwaa, zukamwaa nɛ mot nadus pɛ mɛl mɛ nadi é engwoob tin ɔ, zɛdu nyɛ nɛ mɛko mbaka-mbaka nɛ dii. ");
INSERT INTO bkw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Dáa Yezu nasul tɔ elɛɛd ɛ, nyɛ kabee ɛ́ ɛdhuu ɛ bot binɔk, ye nabɛ ghoŋ naasa nyɛ ɛlyelɛpe. Nyɛ moo tin etsik bot mɛbɛ́ mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dáa bɛ nabee náá, dwoo moo ɛ́ bikoko ɛ, bɛdjekel ɛ́ boozɛtiila pɛ daa lɛ. Bɔɔ nɛ nɛ náá: «Dwoo eezeleega. Tɔ kakoŋ'ak, ye tok nɛ bɔɔ mɛl. Swaala bot bak étɛp bɛ neekɛsaa edee pɛ bɔɔ mɛl mɛ di é engwoob'aak.» ");
INSERT INTO bkw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Yɛ ààgoka náá, bɛ swaalaa, djɛka bɛ edee biyɔ bɛ ɛmet!» ");
INSERT INTO bkw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tin, bɛ ɛ́ boozɛke nɛ Yezu náá: «Zuka nɛ sa bis di nɛ yɛ wak ɛ, ye ɛ́ etsim e emapa etɛn nɛ bɛsu ɛbá.» ");
INSERT INTO bkw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Dhaka nɛ yɛ wak.» ");
INSERT INTO bkw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","É di'enek, nyɛ ɛ́ boozɛke nɛ mɛdhuu mɛ bot ɛ nadi tin ɔ náá, bɛ disi mendiindil kɔ bɔɔ eka e na bes. Bhii tak, Yezu ɛ́ boozɛnɔɔ emapa etɛn nɛ bɛsu ɛbá binek, nyɛ eezɛben mis pɛ ɛko, zɛghaapɛɛ Zɛɛb. Nyɛ eezɛpyak emapa, nɔɔ, djɛ bɛdjekel bɛ. Bɛdjekel ɛ́ boozɛnɔɔ yɛ, kaa, djɛ ɛdhuu ɛ bot ɛ nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mot nɛ mot naadɛ, djil. Wɔ gwaa, bɛdjekel baabula nɛ mɛbhubhwak mɛ emapa nɛ bɛsu ɛ nalik ɛ, ye naalwoodal mɛbhwaa kam nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bot ɛ nadɛ emapa nɛ bɛsu binek ɔ, nabɛ ɛ́ tyee botom bɛmil ɛtɛn, ààkalaa mɛtaŋ mɛ boa nɛ bɔɔ dhyeeb. ");
INSERT INTO bkw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Batsa bhii tak, Yezu eezelwom bɛdjekel bɛ náá, bɛ ni tɔ elɛɛd, tsaal, tɔ́ pɛ yii kyiid boo soob na djato-djato. Tin, nyɛ eezɛlik é ɛswaal ɛ zukamwaa nɛ bot binɔk pɛ mendjaa mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bhii nyɛ nazeswaal bɛ ɛ, nyɛ ɛ́ boo zɛbyet kɔ ɛtsok étɛp ɛkɛdjaala Zɛɛb. Dáa ye nabɛ náá, dwoo nabɛ ɛ́ yɛ eezesila ɛ, nyɛ nakalik tin ɛ́ nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Elɛɛd nabɛ ɛ́ ye moo ɛtsetaɛpe nɛ ɛboŋ. Wɔ gwaa, boo ghuu zɛpupal kɔ dii, tin, bhuuge moo tin enyuŋa e elɛɛd, etɛɛ náá, pup nadi ebulal bɛ elɛɛd pɛ bhis. ");
INSERT INTO bkw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kuku pum, tɔ ghooghom, wɔ gwaa Yezu zɛsul kɔ dii, nyɛ moo tin edu bɛdjekel bɛ. Nyɛ nadi ekɛ ɛ́ nɛ mɛko mɛ kɔ dii. ");
INSERT INTO bkw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dáa bɛdjekel bɛ nabee nyɛ ekɛ kɔ dii ɛ, bwoo naasa bɛ ɛlyelɛpe. Bɔɔ náá: «Nwyak ɛ́ dim!» Bɛ moo tin etsim nɛ bɛbebwol. ");
INSERT INTO bkw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Batsa deenek, Yezu eezɛdjóo bɛ. Nyɛy náá: «Nàbemka ba. Saka mɛghaaz. Ye ɛ́ mam.» ");
INSERT INTO bkw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dáa nyɛ nabee deenek ɛ, Pyɛɛd ɛ́ boozɛke nɛ Yezu náá: «Ghɛŋ, yɛ bɛ náá, ye ɛ́ tsɛɛtsɛ náá, ye ɛ́ wɔy ɔɔ, kea náá, mɛ kɛ kɔ mɛdii, zyɛ pɛ wɔ di'enek.» ");
INSERT INTO bkw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yezu ɛ́ boozɛke nɛ nɛ náá: «Dha!» Tin, Pyɛɛd ɛ́ boozɛwyis tɔ elɛɛd, sul kɔ dii. É di'enek, Pyɛɛd moo kɛ kɔ dii nɛ mɛko mɛ, etɔ́ pɛ kyee Yezu nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tinaak, dáa nyɛ nabee náá, ghuu naalyel pyep ɛ. Wɔ gwaa bwoo zɛsa nyɛ. É di tak wat, nyɛ moo ediida tɔ dii, nyɛ ɛ́ boozɛtsim ɛlyelɛpe náá: «Ghɛŋ, tsika mɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","É di tak wat, Yezu ɛ́ boozɛsɛɛb mbɔ, wɔ gwaa, nyɛ zokamɛt Pyɛɛd, nyɛ ɛ́ booke nɛ nɛ náá: «Étɛp yé wɔ be mɛso? Ɛmyaal ɛ lɔ ààdyeebabɔk.» ");
INSERT INTO bkw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bhii tak, bɔɔ djas bɛbá eezɛgo tɔ elɛɛd. Tin, ghuu yenek eezɛsila. ");
INSERT INTO bkw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tin, bɛdjekel ɛ nadi tɔ elɛɛd ɔ, zokazyɛ, zɛkwyit mɛboŋ si mɛko ɛ Yezu. Bɔɔ nɛ nɛ náá: «Ye ɛ́ tsɛɛtsɛ náá, wɔ ɛ́ Mɔn Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bhii bɛ nasɛɛ dii ɛ, bɛ ɛ́ boozɛtɔ́ pɛ kyee dik Ghenezalɛt. ");
INSERT INTO bkw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dáa bɛ nakum é di'enek ɛ, wɔ gwaa, bot ɛ dɛl ɛ tak zokazɛgwyak Yezu. Tin, lɛŋ ɛ ɛkum ɛ Yezu zokadjala mɛl djas, wɔ gwaa, bɛ zokazyɛ nɛ membel djas bɛ nadi nɛ nɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bot ɛ tak ɛ́ boozɛdjaala nɛ Yezu náá, nyɛ bet membel djas, bɔɔ bɛ ɛmet zokee-keeak ɛlɔ ɛ ndjookuwa yɛ. Tin, bot djas namɛt nyɛ ɔ nabɛ ɛ́ bɛ naatsak. ");
INSERT INTO bkw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dhiiti dwoo eFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi naadus pɛ Yeluzalɛm zɛboma nɛ Yezu, bɛ ɛ́ boozɛdji nyɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Étɛp yé bɛdjekel bɔ di ààduwal etsi e bɛbhaab bina nalik ɛ? Etɛɛ náá, bɔɔ bɛ ààgwyii mɛmbɔ, bɛ di náá, bɛ moo dɛ edee ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Étɛp yé bi di ààkɛ dáa etsi e Zɛɛb di lɛɛ ɛ? Bi kwyɛl ɛkɛ ɛ́ dáa etsi e mbyak'en di elɛɛ ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Etɛɛ náá, Zɛɛb ke ɛ́ náá: “Dila soog nɛ nyoog. Mot ɛ di ekal sɛɛg nɛ nyɛɛg ɔɔ, nyɛ goka ɛ́ nɛ ɛsyee.” ");
INSERT INTO bkw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yɛ kabɛ biyɔ ɔ, bi lyo bot ɛ́ náá, mot ɛ́ nɛ ghwyil ɛlɛɛ nɛ sɛɛg nɛ nyɛɛg náá: “Esa ee mɛ waakwyee bin nɛ ye ɛ, mɛ eenɔɔ kɛdjɛ étɛp ɛtuud ɛ Zɛɛb nɛ yɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mot ɛ́ ke deenek ɔɔ, nyɛ tok nɛ gwyes ɛkwyee sɛɛg nɛ nyɛɛg. É di'enek, bot ɛbuɛpe ɛpesa náá, mɛkpa ɛ Zɛɛb zɛhoola, étɛp ɛsa nɛ ɛduwal etsi bin biyɔ bɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Ngoolel-mɛkpa ɛ Zɛɛb Ezayi nabɛ ɛ́ nɛ gham nɛ nyɛ nɛ ke náá: ");
INSERT INTO bkw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Bot ɛ mbyak'ak duwal mɛ ɛ́ duwela mɛkɔŋ, elyem bɔɔ ɛ́ pɛ kyee sis. ");
INSERT INTO bkw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zɛɛga mendjaala mɔɔ, ye ɛ́ yii toto é mis mam, etɛɛ náá, mɛlyo mɛ bɛ di elyo ɛ́ mɛlyo mɛ epuud.”» ");
INSERT INTO bkw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wɔ gwaa Yezu zokazɛdjóo ɛdhuu ɛ bot, nyɛ ɛ́ boozɛke nɛ bɔɔ djas náá: «Biyɔ djas, gwakeka mɛ, da bi ɛ́ mɛt sa mɛ di elii'aak: ");
INSERT INTO bkw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ye tok sa mot di ewa tɔ nuub'ɛ ɛ, di epul mot é mis ɛ Zɛɛb ɛ. Ye ɛ́ sa wyis tɔ nuub ɛ di epul mot tak é mis ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tin, bɛdjekel ɛ́ boozyɛ, zɛlɛɛ Yezu náá: «Wɔ nɛ gu náá, etɛp ee wɔ lii'enek eedyeebakpaa eFalizyɛ tɔ elyem é?» ");
INSERT INTO bkw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Mɛbhek djas di náá, ye tok Saag'am di tɔ gwoo ɛ nabɛ ɛ́, yɛ aadi ɛ́ guaa.» ");
INSERT INTO bkw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yezu ɛ́ boozɛke náá: «Betka bɛ. Yɛ ɛ́ bɛ na edhim ɛ di edjɛɛd bɛsɔ bɔɔ bɛ na edhim. Tin, ye nyɔ bi ɛ́ gu náá: Yɛ bɛ náá, ye ɛ́ mot edhim ɛ di edul sɔ mot edhim ze ɔɔ, ɛsik ɛ tak ɛ náá, bɔɔ djas ɛ́ waadjoola tɔ guk.» ");
INSERT INTO bkw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tin, Pyɛɛd ɛ́ boozɛke náá: «Lɛɛa bis sa ekana binek di ekwyɛl ɛlɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yezu ɛ́ boozɛbɔɔza náá: «Dɔɔ nɛ biyɔ pe, bi tok nɛ etsoŋ ɛtiibal é? ");
INSERT INTO bkw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bi ààgu náá, esa djas mot di ewa tɔ nuub ɛ, dhaŋ ɛ́ tɔ mɔ yɛ. Bhii tak, ye kakɛwyis ɛ́ tɔ́ ɛbyeed é?» ");
INSERT INTO bkw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bhii tak, nyɛ eebaazɛke náá: «Sa di ewyis tɔ nuub mot ɛ ààpul edɛɛ e mot. Ye ɛ sa di edus tɔ lyem ɛ di epul edɛɛ e mot. ");
INSERT INTO bkw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Etɛɛ náá, embee egeka dus ɛ́ tɔ lyem mot. Yɛ ɛ́ esiiza ɛ di elwom bot náá, bɛ gó bot, bɛ sa mɛzɔ, bɛ sa mɛpam, bɛ djii, nɛ ɛsu bɔn nyɛɛg bɔɔ etɛp nɛ mɛbhekel. ");
INSERT INTO bkw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yenek ɛ́ esesɛɛ ee di epul ɛgwakel pak bot nɛ Zɛɛb ɛ. Yɛ kabɛ tɛp ɛdɛ edee ààgwyii mɛmbɔ ɔ, yɛ ààpul mot é mis mɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yezu zokadus tin, tɔ́ pɛ kyee dik eghaada Tiid nɛ Sidɔn. ");
INSERT INTO bkw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dhiiti moma dɛl ɛ Kanan nadidi kɔ kyee dik ɛ tak ɔ, zokazyɛ pɛ daa lɛ, nyɛ moo tin etsim náá: «Ghɛŋ, Mɔn Dhavid, geka mɛ ghoŋ, dhiiti kwaambi mbee sisim ɛpedhek mɔn ɛsyes ɛ lam, nyɛ tok ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tin, Yezu gwyem'enek, ààbis moma tak. Wɔ gwaa bɛdjekel bɛ zokazɛke nɛ Yezu náá: «Sɔa nyɛ, étɛp nyɛ ɛpedu mena nɛ etsim lookɛbok mos.» ");
INSERT INTO bkw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","É di'enek, Yezu ɛ́ boozɛbɔɔza náá: «Mɛ nadhisaa ɛ́, kɔ ɛsu ɛ bot ɛ mbyak Yisalaɛl di bɛ eezediib dáa bɔɔ ebhata ee di ààbɛ nɛ mbaalel ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tin, wɔ gwaa moma yenɔk zɛkwyit mɛboŋ si mɛko ɛ Yezu. Nyɛ ɛ́ boozɛke nɛ nɛ náá: «Ghɛŋ, kwyeea mɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yezu ɛ́ boozɛbɔɔza nɛ nɛ náá: «Yɛ àànyɔ náá, bɔn bɛbhyɛ djɛaa emapa di náá, ye ɛ́ yii bɔn bot ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wɔ gwaa moma yenɔk baazɛpesal náá: «Wɔ ɛ́ nɛ gham, Ghɛŋ! Tin, bɛbhyɛ aazodedɛ ɛ́ bɔɔ eghutu-ghutu emapa dyeebakwyit é mesa kukuma yɔɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tin, Yezu eezɛke nɛ moma yenɔk náá: «Hee moma! Ɛdum ɛ koŋ ɛ lɔ nɛ Zɛɛb nɛ bɔk. Étɛp tak ɛ Zɛɛb ɛ́ waadjɛ wɔ sa lyem'ɔ di ekwos ɛ.» É di tak wat, wɔ gwaa mɔn zokatsak. ");
INSERT INTO bkw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bhii tak, Yezu eezɛdus tin, nyɛ eezɛtɔ́ pɛ ɛboŋ ɛ boo soob na djato-djato Ghalile. Nyɛ eezɛbyet kɔ mɔɔ ɛtsok, nɔɔ nyel, disi. ");
INSERT INTO bkw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bot mɛdhuu-mɛdhuu zokazyɛ nɛ bot ɛ edjam, bot ɛ edhim, eboka e bot, ebubu e bot, nɛ bɛtɛ nɛ membel. Bɛ eezɛsil bɛ sok bhwoob'ɛ. Tin, Yezu zokazɛtsik bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɛdhuu ɛ bot naadyeebadjoka dáa bɛ nadi ebee ebubu moo lii ɛ, bot ɛ edjam nɛ eboka moo kɛ ɛ, bot ɛ edhim moo nyaa sok ɛ. Bɛ moo tin eduwal Zɛɛb Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yezu eezɛdjóo bɛdjekel bɛ. Nyɛ ɛ́ booke nɛ nɔɔ náá: «“Ha” kpaa-ghoŋ nɛ ɛdhuu ɛ bot bak e! Mena nɛ bɛ nɔɔ moo mos ɛ́ mɛlu mɛlɛl e di wat. Bɛ tokapɛ nɛ edee e dek. Mɛ tok nɛ ghwyil ɛswaal bɛ pɛ mendjaa mɔɔ tɔ emɔ toto, bɛ waazuk, ze ɛ ze.» ");
INSERT INTO bkw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tin, bɛdjekel bɛ ɛ́ boozɛke nɛ nɛ náá: «Mena aabela edee ee ɛdhuu ɛ bot bak djas aadɛ, djil nɛ yɛ ɛ paa? Menabɛl ɛ́ dika kuku kakoŋ'aak?» ");
INSERT INTO bkw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yezu eezɛdji bɛ náá: «Bi ɛ́ nɛ emapa edhen?» Bɛ ɛ́ boozɛbɔɔza náá: «Etɛn nɛ ebá nɛ ba bɔɔ bɛsu.» ");
INSERT INTO bkw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nyɛ ɛ́ boozɛlɛɛ nɛ ɛdhuu ɛ bot náá, bɛ disi é bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bhii tak, nyɛ eezɛnɔɔ emapa etɛn nɛ ebá nɛ bɛsu binek zɛghaapɛɛ Zɛɛb. Bhii tak nyɛ eezɛpyak yɛ ebil-ebil. Nyɛ eezɛnɔɔ yɛ náá, djɛ bɛdjekel bɛ, bɛ neekaa bot djas. ");
INSERT INTO bkw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mot nɛ mot naadɛ, djil. Bɛdjekel bula nɛ yii nabwak ɛ. Mɛbhubhwak naalwoodal bɛbhwaŋ ɛtɛn nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bot ɛ nadɛ ɔ, naakum botom bɛmil ɛná (4 000), ààlaa-laŋak boa nɛ bɔɔ dhyeeb. ");
INSERT INTO bkw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bhii tak Yezu ɛ́ boozɛswaal bot ɛ tak bɛ sik pɛ mendjaa mɔɔ. É di'enek wat, nyɛ eezɛni tɔ elɛɛd, bɛ nɛ bɛdjekel bɛ zokazɛtɔ́ pɛ kyee dik Maghadan. ");
INSERT INTO bkw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","EFalizyɛ nɛ eSaduseɛ naazyɛ pɛ dáa Yezu étɛp ɛsaŋ ɛ ɛlóo ɛ nyɛ pɛ ɛko, da ɛ́ bwood nyɛ pɛ kiyɛ. Bɛ eezɛke nɛ nɛ náá, nyɛ lyaal bɛdhiiti ndem mɛbwala di edus pɛ tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yezu ɛ́ boo kabulal bɛ dáak: «Dwoo ɛ́ sila ɔɔ, bi ke ɛ́: “Yɛ aadi ɛ́, mbɛɛ dwoo, etɛɛ náá, gwoo moo ɛ́ tɔɔbelaa.” ");
INSERT INTO bkw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kɛɛŋ tɔ mɛlem, bi dyeebake ɛ́: “Bhi ɛ́ waanee mos, etɛɛ náá, gwoo ɛ́ tɔɔbelaa.” Bi nɛ gu ɛbɛk embi e gwoo; ghuna bi ààgu ɛbɛk embi e endem di edhaa mɛlu mak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Biyɔ, bot ɛ mɛlu mak, bi ɛ́ bɛmbee ɛ bot, bot ɛ di ààbɛ sosoob é mis mɛ Zɛɛb ɔ. Bi kasaŋ ɛ́ endem e mɛbwala. Yɛ aanàkwaadjɛaa bin bhis yɛ Yonas nasael ɛ.» Bhii tak, nyɛ eezɛbet bɛ, zɛtɔ́. ");
INSERT INTO bkw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","É di bɛdjekel nadhaa pɛ yii kyiid soob ɔ, bɛ eezɛdjisa ɛnɔŋ ɛ emapa. ");
INSERT INTO bkw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yezu ɛ́ boolɛɛ bɛ náá: «Dika nɛ etsoŋ, da bi ɛ́ kyee leviid e eFalizyɛ nɛ eSaduseɛ di nɛ yɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bɛdjekel moo tin é nyiiŋela pak'ɔɔ náá: «Nyɛ lii deenek ɛ́, etɛɛ náá, mena ààpanɔɔka emapa.» ");
INSERT INTO bkw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yezu eezɛgu sa bɛ nadi enyiiŋela ɛ. Nyɛ ɛ́ boozɛdji bɛ náá: «Étɛp yé bi di elii pak'en: Ye ɛ́ etɛɛ náá, mena tok nɛ mapa é? Dáa ɛbwaalel ɛ len nɛ Zɛɛb di batsa ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bi dinaa ààpaamɛt ɛsuk, bi tok nɛ ghwyil ɛtaala emapa etɛn mɛ nakaa botom bɛmil ɛtɛn yɛ ɛ, dɔɔ nɛ bɛtɛ nɛ mɛbhwaa bi nabula nɛ yɛ ɛ? ");
INSERT INTO bkw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Bi tok nɛ ghwyil ɛtaala emapa etɛn nɛ ebá mɛ nakaa bot bɛmil ɛna yɛ ɛ, nɛ bɛtɛ nɛ bɛbhwaŋ ɛ bi nabula nɛ ye ɛ́? ");
INSERT INTO bkw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Étɛp yé bi di ààgu náá, mɛ bɛ ɛ́ ààlii nɛ nen étɛp emapa é sok mɛ lii nɛ nen ɛ? Mɛ ke ɛ́ náá: “Kyeeka emapa eFalizyɛ nɛ eSaduseɛ”.» ");
INSERT INTO bkw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","É di tak, bɛdjekel eezɛgu náá, nyɛ nabɛ ɛ́ ààke náá, bɛ kyee leviid di waaa tɔ emapa ɛ. Ghuna ye nabɛ ɛ́ mɛlyo mɛ eFalizyɛ nɛ eSaduseɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yezu zɛkum ko bɔs ɛ Sezaad ɛ Filip. Nyɛ ɛ́ boozɛdji bɛdjekel bɛ náá: «Bot ke dáa dum nɛ Sɛɛŋɛlɛ Mɔn Mot?» ");
INSERT INTO bkw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bɛ eezɛbɔɔza nɛ nɛ náá: «Bɛdhiiti ke ɛ́ náá, wɔ ɛ́ Zaŋ Nduuel-bot, bak náá, wɔ ɛ́ Eli. Bɛdhiiti kabaake ɛ́ náá, wɔ ɛ́ Zelemi nɛghu dhiiti ngoolel-mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yezu ɛ́ boozɛdji bɛ náá: «Haa! Biyɔ, bi ke náá, mam ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tin, Simɔŋ Pyɛɛd zɛbɔɔza náá: «Wɔ ɛ́ Mɛsia, Mɔn Zɛɛb di nɛ tsik na kɔm-kɔm ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yezu ɛ́ boozɛke nɛ nɛ náá: «Mɛnyɔ nɛ nɔ, Simɔŋ mɔn Zaŋ, etɛɛ náá, ye tok mot epuud zetel wɔ yenek etsɛɛtsɛ, gua náá ye ɛ́ Saag'am di tɔ gwoo ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yɛ bɛ mam ɔ, mɛ ɛpelɛɛ wɔ, wɔy Pyɛɛd wɔ ɛkok, kɔ ɛkok ɛ tak ɛ́ mɛ aakus di zɛɛga ndjaa mendjaala mam. Ɛsyee aanàkwaakwak yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mɛ waaboodjɛ wɔ bɛsap ɛ ndjaa Ɛyoŋ ɛ di tɔ gwoo ɛ. Sa wɔ aalu kɔ bɔs ɛ, yɛ waaluel tɔ gwoo. Sa wɔ aadjɛ ze kɔ bɔs ɛ, ze ɛ́ waadjɛel tɔ gwoo.» ");
INSERT INTO bkw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bhii tak, Yezu eezɛlu bɛdjekel bɛ náá, sa bɛ ààlɛɛ mot náá, nyɛ ɛ́ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","É di'enek, Yezu moo zɛlɛɛ nɛ bɛdjekel bɛ náá: «Ye goka ɛ́ náá, mɛ tɔ́ pɛ Yeluzalɛm, étɛp mɛ neekɛzuk ɛbuɛpe é mɛmbɔ mɛ bɛpaa eYuda, bɛ nɛ eboo bɛghaa-Zɛɛb, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi. Bɛ waagó mɛ, bhii mɛlu mɛlɛl, mɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","É di'enek, Pyɛɛd eezɛdul nyɛ é ngwoob bɛ nɛ nɛ bɛbá, nyɛ moo djɛ nyɛ mɛbɛ: «Zɛɛb baal wɔ, Ghɛŋ! Yenek aanàkwaakosael.» ");
INSERT INTO bkw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","É di'enek, Yezu eezɛbhɛm nyɛ. Nyɛ nɛ Pyɛɛd náá: «Dusa! Tɔ́a ɛtsetaɛpe nɛ nam, Satan! Wɔ ɛ́ ɛbɛk é ze yam, etɛɛ náá, esiiza bɔ tok dáa yii Zɛɛb, gua náá, yɔ esiiza ɛ́ yii bot.» ");
INSERT INTO bkw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bhii tak, Yezu ɛ́ boozɛke nɛ bɛdjekel bɛ náá: «Mot ɛ́ ke náá, nyɛ aazyɛ bis nɛ nɛ ɔɔ, nyɛ bet ɛsiiza etɛp nyel'ɛ, nyɛ bɛp mɛlaaba mɛ, da nyɛ ɛ́ du mɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Etɛɛ náá, mot di ekwyɛl ɛtsik ɛ nyel'ɔ ɔ, nyɛ ɛ́ waasu nyel'ɛ. Ghuna mot aasu nyel'ɛ étɛp'am ɔ, nyɛ waabela yɛ! ");
INSERT INTO bkw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Duma yé mot aadi nɛ yɛ, nyɛ bela dik djas, da nyɛ ɛ́ kasu ɛ tsik'ɛ ɔ? Ye ɛ́ nɛ dhiiti sa mot aadjɛ étɛp ɛbɔm ɛ tsik'ɛ? Mam ààbee! ");
INSERT INTO bkw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ye ɛ́ deenek ɛ Sɛɛŋɛlɛ Mɔn Mot aazyɛ tɔ duma Sɛɛg, bɛ nɛ efofop bɛ. É di'enek ɛ́ nyɛ aadjɛ mot nɛ mot efute mɛsa mɛ tyee nyɛ nadi eke ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, bɛdhiiti bot ɛ di wak ɔ, bɛ aanàkwaagwyɛ ɛsok nɛ bɛ nɛ bee Sɛɛŋɛlɛ Mɔn Mot ezyɛ tɔ Mɛkoozi mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mɛlu mɛtɛn nɛ wat bhii tak, Yezu naanɔɔ Pyɛɛd, Zak nɛ Zaŋ mɔn nyɛɛg ɛ Zak. Nyɛ naazɛtɔ́ nɛ nɔɔ kɔ vyɛɛg-vyɛɛg ɛtsok é di tak bɛ nadi ɛ́ bɔɔ bɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","É di'enek, wɔ gwaa Yezu zɛswoola bhwoob é mis mɔɔ. Bhwoob'ɛ moo tin ɛkasɛpe dáa gwyes, ekaad bɛ moo ɛkasɛpe dáa dwoo. ");
INSERT INTO bkw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","É di tak wat, bɛdjekel bɛ eezɛbee Moiiz nɛ Eli elɛɛ elɛŋ bɛ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wɔ gwaa Pyɛɛd zokazɛke nɛ Yezu náá: «Ghɛŋ, ye goka ɛ́ náá, mena di wak. Wɔ kwyɛl ɔɔ, mɛ ɛ́ sum epɛt elɛl: wat yɔ, yak yɛ Moiiz, yak wat kadi ɛ́, yɛ Eli.» ");
INSERT INTO bkw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dáa nyɛ nadi nyɛ dinaa elii ɛ́, wɔ gwaa eguud na kas-kas zɛdipal bɛ. Bhii tak, gwood zokazɛgék náá: «Yenɔk ɛ́ mɔn'am mɛ dyeebakwyɛl ɔ, ye ɛ́ nyɛy ɛ́ mɛ natɔ. Gwakeka nyɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","É di bɛdjekel nagwak gwood'enek ɛ, bwoo naazɛsa bɛ ɛlyelɛpe, wɔ gwaa bɛ zɛkwyit mɛboŋ mɔɔ, bhwoob si. ");
INSERT INTO bkw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yezu naazɛtiila pɛ daa lɔɔ, nyɛ eezɛmɛt bɛ. Nyɛy nɛ nɔɔ náá: «Wyɛlka. Nàdika nɛ bwoo.» ");
INSERT INTO bkw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tin, bɛ nakaben mis ɛ, bɛ nabɛ ɛ́ ààkabee dhiiti mot bhii Yezu nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dáa bɛ nadi ewyeed ɛtsok ɛ, Yezu naazɛke nɛ nɔɔ náá: «Sa mot ààlɛɛ mot esesɛɛ mɛbwala mɛ bi bee ɛ. Baalka yɛ kɛkum dwoo Sɛɛŋɛlɛ Mɔn Mot aagom bhis ɛsyee ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bhii tak, bɛdjekel naazɛdji Yezu náá: «Étɛp yé bɛghaŋ ɛ mɛkana mɛ etsi dyeebake náá, Eli ɛ́ kwaaleezyɛ ɛsok?» ");
INSERT INTO bkw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nyɛ naazɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ deenek. Eli ɛ́ di egoka nɛ ɛzyɛ sok étɛp ɛzɛkoobal etɛp djas. ");
INSERT INTO bkw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gwakeka, mɛ lɛɛ bin ɛ́ náá, Eli eezezyɛ, bot ààpagwyak nyɛ. Bɛ kasa nyɛ ɛ, dáa elyem bɔɔ di ekwyɛl ɛ. Ye ɛ́ deenek ɛ, bɛ aatiig Sɛɛŋɛlɛ Mɔn Mot.» ");
INSERT INTO bkw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","É di'enek, bɛdjekel naazɛgu náá, nyɛ nalii nɛ nɔɔ ɛ́ dum nɛ Zaŋ Nduuel-bot. ");
INSERT INTO bkw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dáa bɛ nakum é di ɛdhuu ɛ bot nadi ɔ, wɔ gwaa mot ngɔt zokazyɛ é bhaaz ɛ Yezu, zɛkwyit mɛboŋ si mɛko mɛ. ");
INSERT INTO bkw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nyɛy náá: «Ghɛŋ, geka mɔn'am ghoŋ, nyɛ ɛ́ nɛ ɛbɛ́ ɛ djem. É sok ye dyeebamɛt nyɛ ɛ́, ye nɛ lwak nyɛ, kɛghɛɛg nyɛ tɔ du, é dhiiti ɛwala, ye ghɛɛg nyɛ ɛ́ tɔ dii. ");
INSERT INTO bkw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mɛ naazyɛ nɛ nɛ pɛ daa bɛdjekel bɔ, bɛ nabɛ ɛ́ ààkwak ɛtsik nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","É di'enek, Yezu naazɛkim ɛlyelɛpe, nyɛy nɛ nɔɔ náá: «Biyɔ bɛmbee ɛ bot di ààdum koŋ nɛ Zɛɛb ɔ! Membu medhen mɛ aabaadi di wat nɛ nen sama? Mɛ baamaad bin, kɛkum yaa ɛlu? Dhaka mɛ nɛ mɔn'enɔk wak.» ");
INSERT INTO bkw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tin, wɔ gwaa Yezu zɛbhɛm mbee sisim. Mbee sisim tak naazɛwyis tɔ mɔn'enɔk. É di'enek wat, mɔn'enɔk naazɛtsak. ");
INSERT INTO bkw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","É di'enek, bɛdjekel eezɛtiila é bhaaz ɛ Yezu nyɛy nyɛ ɛmet, bɛ eezɛdji nyɛ náá: «Étɛp yé bisɔ nadi ààkwak ɛsɔ mbee sisim'enek?» ");
INSERT INTO bkw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Étɛp náá, ɛdum ɛ koŋ ɛ len nɛ Zɛɛb nɛ tɔɔl. Mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ náá: Bi ɛ́ pe di nɛ ɛdum ɛ koŋ nɛ Zɛɛb ɛbɔkɛpe dáa bhek le mutaad ɔɔ, pe bi ɛ́ nɛ ghwyil ɛke nɛ ɛtsok ɛlak náá: “Dusa wak. Tɔ́ penek,” pe yɛ waadus. Tin, pe ye tok nɛ sa wat aadi nɛ ghwyil dhaa bin.  ");
INSERT INTO bkw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Guka náá, ye ɛ́ nɛ ghwyil mendjaala nɛ ɛtsi ɛ edee ɛ wɔ aadis mbi yenek embee esisim.» ");
INSERT INTO bkw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dwoo wat, bɛdjekel eezɛdi é di wat pɛ Ghalile. Tin, Yezu eezɛlɛɛ bɛ náá: «Sɛɛŋɛlɛ Mɔn Mot ɛ́ waakaaa é mɛmbɔ mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bɛ waagó nyɛ, mɛlu mɛlɛl bhii tak, nyɛ waagom.» Tin, ghoŋ naazɛmɛt bɛdjekel dhaa nyel. ");
INSERT INTO bkw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","É ghɛŋ Yezu nɛ bɛdjekel bɛ nakum pɛ ghaada Kapɛlnaum ɛ, bɛnɔŋel ɛ epata e lapo Ndjaa-ebuwa zokazyɛ pɛ kyee Pyɛɛd nadi ɛ́. Bɛ ɛ́ boozɛdji nyɛ náá: «Lyoel yen ààtuud lapo Ndjaa-ebuwa?» ");
INSERT INTO bkw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pyɛɛd ɛ naazɛbɔɔza náá: «Hee, nyɛ nɛ tuud.» É ghɛŋ Pyɛɛd nani tɔ ndjaŋ ɛ, Yezu nadi ɛ́ mot mɛkɛn ɛlii. Nyɛy náá: «Wɔ gek dáa, Simɔŋ? Ɛzɛ di egoka nɛ ɛtuud lapo nɛghu bɛdhiiti etuud pɛ dáa bɛmɛkoozi mɛ bɔs'ak? Ye ɛ́ bot ɛ dɛl “ohoo” nɛghu ye ɛ́ bɛdjoŋ?» ");
INSERT INTO bkw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pyɛɛd ɛ́ boozɛbɔɔza nɛ Yezu náá: «Ye ɛ́ bɛdjoŋ.» É di'enek, Yezu eezɛpesal náá: «Wɔ bee ɔɔ, bot ɛ dɛl ààgoka nɛ ɛtuud lapo. ");
INSERT INTO bkw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ye ɛ́, etɛɛ náá, mena ɛ́ zɛkɛdhusal bot binɔk. É di tak, Tɔ́a pɛ boo soob na djato-djato. Lóoa ngwyep tɔ dii, nɔŋa su mɛkɛn wɔ aabela ɛ, da wɔ ɛ́ dii nuub'ɛ, wɔ waabela pata aagoka nɛ ɛtuud ɛ lapo yam nɛ yɔ ɛ. Nɔŋa yɛ, da wɔ ɛ́ tuud mena yenabɛl lapo.» ");
INSERT INTO bkw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","É ɛwala ɛlenek, bɛdjekel naazɛtiila é bhaaz ɛ Yezu, bɛ naazɛdji nyɛ náá: «Ye ɛ́ ɛzɛ di boo-mot tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","É di'enek, wɔ gwaa Yezu zɛdjóo mɔɔ dhyeeb, zɛtel nyɛ é mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nyɛy nɛ nɔɔ náá: «Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá: Bi ɛ́ di ààswoola mɛfulu men, da bi ɛ́ di dáa bɔɔ dhyeeb ɔɔ, bi aanàkwaani tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Boo-mot tɔ Ɛyoŋ ɛ di tɔ gwoo ɔ, ye ɛ́ mot di esil nyel'ɛ, da nyɛ ɛ́ di dáa mɔn'ak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mot ɛ́ be ɛnyɔɛpe mɔɔ dhyeeb dáa mɔn'ak kɔ ɛsu ɛ din ɛ lam ɔɔ, nyɛ be ɛ́ mam.» ");
INSERT INTO bkw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Mot aakwyesal mɔn ngɔt tɔ sama bɔn zedum koŋ nɛ nam tɔ mesyem ɔɔ, ye goka ɛ́ náá, bɛ tiŋal nyɛ boo ɛkok é tsuŋ. Bhii tak, da bɛ ɛ́ lóo nyɛ tɔ boo dii mɛsɔn, da nyɛ ɛ́ diida kɛkum pɛ si. ");
INSERT INTO bkw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Haa” kpaa-ghoŋ nɛ bot ɛ di kɔ bɔs ɔ, etɛɛ náá, mɛbɛk mɛ di ekwyesal bot tɔ mesyem ɔ nɛ bu! Ye tok nɛ ghwyil ɛdi ààbɛ. Tin, “haa” kpaa-ghoŋ nɛ mot aadi mɛbɛk menek ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yɛ bɛ náá, ye ɛ́, mbɔ'ɔ, nɛghu ko'ɔ ɛ́ di esa náá, wɔ gheekwye-kwyɛ tɔ mesyem ɔɔ, tsaala yɛ, da wɔ ɛ́ mwas yɛ ɛtsetaɛpe nɛ nɔ. Ye goka ɛ́ náá, wɔ ni tɔ mbɛɛ tsik nɛ tsaala mbɔ, nɛghu tsaala ko, ààbɛ náá, wɔ baal mɛmbɔ mɛmbá nɛ mɛko mɛmbá, bhii tak, wɔ kakɛmwasaa ɛ́ tɔ du na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yɛ bɛ náá, dis ɛ lɔ, di esa náá, wɔ kwyɛ, tɔ mesyem ɔɔ, piida yɛ, da wɔ ɛ́ mwas yɛ ɛtsetaɛpe nɛ nɔ. Ye goka ɛ́ náá, wɔ ni tɔ mbɛɛ tsik nɛ tiila dis, ààbɛ náá, wɔ baal mis mɛmbá mɔ, bhii tak, wɔ kakɛmwasaa ɛ́, tɔ du na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Bi ɛ́ koobaka! Sa mot ààbyasal mot ngɔt tɔ bɔn bak etɛɛ náá, efofop bɔɔ dyeebadi ɛ́, é di wat é mɛwala djas bɛ nɛ Saag'am di pɛ tɔ gwoo ɔ.  ");
INSERT INTO bkw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Etɛɛ náá, Sɛɛŋɛlɛ Mɔn Mot nazyɛ ɛ́ zɛtsik bot ɛ nabɛ náá, bɛ eezediib ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Bi ke dáa? Pookogekeka náá, dhiiti mot ngɔt nabɛ ɛ́ nɛ ebhata dhet (100). Tin, ngɔt zokazɛdiib, nyɛ aanàkwaalik ebhata mɛkam-mɛtɛn nɛ mɛkam-mɛná nɛ etɛn nɛ ená (99) kɔ ɛtsok, étɛp nyɛ neekɛsaa ngɔt diib ɔ? ");
INSERT INTO bkw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mɛ lɛɛ bin ɛ́ tsɛɛtsɛ náá, nyɛ bela nyɛ ɔɔ, nyɛ waadi tɔ mɛmyaala ɛbuɛpe étɛp bhata wat'enɔk, dhaa ebhata nadi ààdiib ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ye ɛ́ tyɛ wat nɛ Sɛɛg'en di tɔ gwoo ɔ. Nyɛ ààkwyɛl náá, mot ngɔt tɔ bɔn bɛ djas wo ze.» ");
INSERT INTO bkw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Yɛ bɛ náá, mɔn nyoog eesa wɔ ɛbiyo ɔɔ, tɔ́ kɛbee nyɛ wɔy wɔ ɛmet. Da wɔ ɛ́ kɛlyaal nyɛ ɛbiyo ɛ lɛ. Nyɛ gwak wɔ ɔɔ, tin, wɔ eekwak ɛbulal ɛ nyɛ é ze. ");
INSERT INTO bkw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yɛ kabɛ náá, nyɛ ààpagwak wɔ ɔɔ, djóoa dhiiti mot ngɔt nɛghu bot ɛbá. Dáa ekwyala di elyaal ɛ náá: “Etɛp djas koobelaa ɛ́ é mis mɛ bɛtetɛp ɛbá nɛghu bɛlɛl.” ");
INSERT INTO bkw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tin, nyɛ byen ɛgwak bɛ ɔɔ, tɔ́ nɛ nɛ sok bhwoob bot ɛ zɛɛga mendjaala. Nyɛ byen ɛgwak bot ɛ zɛɛga mendjaala ɔɔ, tin, bi kaabee nyɛ ɛ́ dáa mot di ààdum koŋ nɛ Zɛɛb ɔ, dáa bɛnɔŋel ɛ epata e lapo. ");
INSERT INTO bkw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Mɛ ɛpelɛɛ bin, ye ɛ́ tsɛɛtsɛ náá, etɛp djas ee bi ààpɛɛ wak kɔ bɔs ɛ, Zɛɛb ɛ́ waapɛɛ yɛ tɔ gwoo. Etɛp djas bi aamyaal wak kɔ bɔs ɛ, Zɛɛb ɛ́ waamyaal yɛ tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Mɛ kabaalɛɛ bin ɛ náá, wak kɔ ɛko ɛ bɔs, bot ɛbá ɛ́ gwakel, da bɛ ɛ́ waab sonok bɛ aakwyɛl ɛwaab tɔ mendjaala mɔɔ ɔɔ, Saag'am di pɛ tɔ gwoo ɔ waadjɛ bɛ sa bɛ waab ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Etɛɛ náá, bot ɛbá nɛghu bot ɛlɛl ɛ́ sɛɛga kɔ ɛsu ɛ din ɛ lam ɔɔ, mɛ aadi ɛ́ tin, pak'ɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wɔ gwaa Pyɛɛd zokazyɛ pɛ pak Yezu nadi ɛ́. Tin, nyɛ boozɛdji nyɛ náá: «Ghɛŋ, mɛ goka ɛ́ nɛ ɛpel mɔn nyaag'am esok edhen nyɛ sa mɛ ɛbiyo ɔɔ? Tyee esok etɛn nɛ ebá?» ");
INSERT INTO bkw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yezu naazɛbɔɔza nɛ nɛ náá: «Ààbɛ, mɛ ààpalɛɛ nɛ nɔ náá, ye di esok etɛn nɛ ebá. Mɛ lɛɛ wɔ ɛ́, ye di esok mɛkam-mɛtɛn nɛ mɛkam-mɛmbá (70), esok etɛn nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Étɛp tak ɛ́ di náá, Ɛyoŋ ɛ di tɔ gwoo ɔ nɔŋel ɛ, nɛ dhiiti mɛkoozi nadi ekwyɛl ɛkoobal etɛp bɛ nɛ bot ɛ mɛsa mɛ nakola epata bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tin, é ghɛŋ nyɛ nakan ɛdjóo ngɔt-ngɔt ɛ, wɔ gwaa bɛ zokazyɛ nyɛ nɛ mot-mɛsa mɛ ngɔt nakola epata ɛbuɛpe ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mot'enɔk nabɛ ɛ́, ààbɛ nɛ sa nyɛ aabulal epata e kukuma tak nɛ yɛ. Kukuma yɛ ɛ́ boodjɛ ɛlee náá, nyɛy nɛ myɛl nɛ bɔn zɛnɔɔ esa bɛ djas bɔmsaa, etɛp epata e tak neebulal kola nyɛ nadi nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tin, mot-mɛsa menɔk eezɛkwyit mɛboŋ si sok bhwoob kukuma yɛ tak. Nyɛy nɛ nɛ náá: “Sila lyem, da wɔ ɛ́ gek mɛ ghoŋ. Mɛ waazɛbulal wɔ epata binek djas!” ");
INSERT INTO bkw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kukuma yɛ zokazɛgek nyɛ ghoŋ, nyɛ eezɛpel nyɛ nɛ epata ee nyɛ nakola ɛ djas. Bhii tak, nyɛ eezɛbet nyɛ, nyɛ tɔ́. ");
INSERT INTO bkw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Dáa mot-mɛsa menɔk nawyis tin ɛ, nyɛ eezɛboma nɛ dhiiti mɔn nyɛɛg nyɛy nakola nyɛ ba bɔɔ epata ɔ. Nyɛ eezɛvyɛk, mɛt nyɛ é tsuŋ “gbak”, nyɛ moo tin enyam nyɛ é tsuŋ ɛkɛɛ, nyɛ aagó nyɛ góak. Nyɛy nɛ nɛ náá: “Tuuda mɛ kola yam nenak!” ");
INSERT INTO bkw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mɔɔ sɔ zokazɛkwyit mɛboŋ si sok bhwoob'ɛ, nyɛ eedjaala nɛ nɛ náá: “Sila lyem, da wɔ ɛ́ gek mɛ ghoŋ. Bwooda batsa mɛ waatuud kola yɔ!” ");
INSERT INTO bkw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Wɔ gwaa nakuma epata zokapɛɛ. Tin, nyɛ ɛ́ zokakɛkɔɔl mɔn nyɛɛg é mbok é bwood dwoo nyɛ aabulal epata bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Dáa bɛdhiiti bot ɛ mɛsa nabee deenek ɛ, ye naakpaa bɛ tɔ elyem. Bɛ ɛ́ boozɛtɔ́, kɛlɛɛ kukuma yɔɔ etɛp djas dhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tin, kukuma yɔɔ ɛ́ boozɛbaadjóo mot-mɛsa menɔk, nyɛ ɛ́ booke nɛ nɛ náá: “Wɔ ɛ́ mot-mɛsa mɛ di náá, wɔ ɛ́ nɛ mbee lyem! Mɛ bɛ mbembɛ ɛ́, mɛ eepel wɔ nɛ epata bam wɔ nakola ɛ, etɛɛ náá, wɔ bɛ ɛ́, wɔ eedjaala nɛ nam náá, mɛ bet wɔ. ");
INSERT INTO bkw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ye goka ɛ́ náá, wɔ gek mɔɔ sɔ'ɔ ghoŋ dáa mɛ gek wɔ ghoŋ ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tin, ye nabɛ ɛ́, kukuma eezebiyo ɛlyelɛpe, nyɛ ɛ́ boolwom náá, bɛ mɛt mot-mɛsa menɔk. Nyɛ kɛsa mɛsa mɛ bhel kɛkum dwoo nyɛ aaboobulal kola yenek djas ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yezu eebaazɛke náá: «Ye ɛ́ deenek ɛ Saag'am di tɔ gwoo ɔ aasa nɛ nen, yɛ bɛ náá, mot nɛ mot ààpapel sɔ nɛ lyem wat ɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bhii Yezu nasilal ɛlyo bot pɛ kyee dik Ghalile ɛ, nyɛ naazɛtɔ́ pɛ kyee dik Yude, pɛ yii kyiid dii Yuldɛn. ");
INSERT INTO bkw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tin, zukamwaa nɛ mot baazɛdu nyɛ, Wɔ gwaa, nyɛ zokatsik bot ɛ mɛbɛ́ mɛ bɛ nazyɛ nɛ nɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tin, wɔ gwaa bɛdhiiti eFalizyɛ zokazyɛ, zɛlaab nyɛ nɛ dhiiti mɛdjin. Bɔɔ nɛ Yezu náá: «Etsi bina ɛpemyaal náá, mot pɛɛ myɛl kɔ ɛsu ɛ etɛp mbɛs é?» ");
INSERT INTO bkw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Bi ààlaa sa di kwyala tɔ mɛkana mɛ Zɛɛb é? “É ghɛŋ Zɛɛb nakus bɔs ɛ, nyɛ nakus ɛ moma nɛ motom.” ");
INSERT INTO bkw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nyɛ eebaazɛbil náá: “Étɛp tak ɛ́ ye di náá, motom ɛ́ waalik sɛɛg nɛ nyɛɛg, étɛp nyɛ neekɛsɛɛga bɛ nɛ myɛl. Tin, bɔɔ bɛbá aakadi ɛ́, bɛ moo mot ngɔt. ");
INSERT INTO bkw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","É di'enek, bɛ tokapɛ bot ɛbá, bɛ aakadi ɛ́, bɛ moo mot ngɔt. Sa mot ààbɛk sa di náá, Zɛɛb eesɛɛg ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","EFalizyɛ ɛ́ boo baadji nyɛ náá: «Étɛp yé Moiiz nalɛɛ náá, yɛ bɛ náá, motom ɛpekwyɛl ɛsɔ myɛl ɔɔ, nyɛ kwyal nyɛ mɛkana mɛ di lɛɛ mɛsɔ mɛ nyɛ pɛɛ nyɛ kɔ ɛsu ɛ tak ɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Moiiz namyaal náá, bi pɛɛ bɛl bin ɛ́, étɛp mɛlyel mɛ elyem bin. Etɛɛ náá, é ɛkɛn ɛ bɔs, ye nabɛ ɛ́ ààbɛ deenek. ");
INSERT INTO bkw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mɛ lɛɛ bin ɛ́ náá, motom ɛ́ pɛɛ myɛl, da nyɛ ɛ́ baakɛba dhiiti moma sis, ààbɛ náá, myɛl tak eesa ɛzɔ ɔɔ, tin, motom'enɔk eesa ɛzɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tin, bɛdjekel eezɛke nɛ Yezu náá: «Yɛ bɛ náá, etɛp ɛba goka ɛ́ nɛ ɛdi ɛ́ deenek pak moma nɛ motom ɔɔ, ye nyɔ ɛ́ náá, mot di yɛ kɔ, ààba moma.» ");
INSERT INTO bkw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","É di'enek, Yezu eezɛke nɛ nɔɔ náá: «Bot djas ààdyeebakwyɛl mbi mɛlyo mak. Tin, ye ɛ́ bot ɛ Zɛɛb yii nyɛy nyɛ ɛmet aadjɛ ghwyil ɔ aapaakwak yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye ɛ́ nɛ bɛtɛ nɛ etɛp di elu náá, bot nàba ɛ. Ye ɛ́ nɛ bot ɛ nabyel náá, bɛ tok nɛ ghwyil ɛba yɔbɔ ɛ. Yɛ kabɛ bɛdhiiti bot ɔ, ye ɛ́ bɛsɔ bɔɔ bot ɛ aapaasa náá, bɛ nàkwyɛl ɛba. Bɛdhiiti aadi ààba ɛ́, étɛp Ɛyoŋ ɛ Zɛɛb. Deenek yɛ bɛ náá, mot ɛpekwyɛl ɛmyaal mɛlyo mak ɔɔ, nyɛ myaal.» ");
INSERT INTO bkw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dhiiti dwoo, bot naazɛzyɛ Yezu nɛ bɔɔ dhyeeb étɛp nyɛ needjaala bɛ Zɛɛb nɛ ɛkɛl ɛ bɛ mɛmbɔ. Wɔ gwaa bɛdjekel bɛ zokazɛlu bot ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dáa Yezu nabee deenek ɛ́, nyɛ ɛ́ boozɛke nɛ bɛdjekel náá: «Betka bɔɔ dhyeeb, bɛ zyɛ pɛ daa lam! Nàluka bɛ etɛɛ náá, Ɛyoŋ ɛ di tɔ gwoo ɛ goka nɛ bot ɛ di tyee bɔɔ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tin, nyɛ ɛ́ boozɛkɛl bɛ mɛmbɔ. Bhii nyɛ nakasilal ɛ, nyɛ boozɛnɔɔ nyel tɔ́. ");
INSERT INTO bkw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dáa bɛ nadi gba-gba é goŋ ɛ, dhiiti mot zokazyɛ pɛ daa Yezu, mot tak nɛ Yezu náá: «Lyoel! Mɛ goka ɛ́ nɛ ɛsa yaa tɛtɛ sonok étɛp mɛ neebela tsik na kɔm-kɔm?» ");
INSERT INTO bkw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yezu eezɛbɔɔza nɛ nɛ náá: «Étɛp yé wɔ di edji mɛ mɛdjin dum nɛ tɛtɛ etɛp? Ye ɛ́ Zɛɛb nyɛ ɛmet ɛ di tɛtɛ mot. Wɔ kwyɛl ɛni tɔ tsik na kɔm-kɔm ɔ, wɔ goka ɛ́ wɔ looba nɛ sa mɛtiŋ di elɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mot'enɔk eezɛdji Yezu náá: «Yaa mɛtiŋ?» Yezu ɛ́ boozɛlɛɛ nyɛ náá: «Sa wɔ ààgó mot. Sa wɔ ààsa mɛzɔ. Sa wɔ ààdjii sa mot. Sa wɔ ààlɛɛ elɛŋ e etsal dum nɛ mot. ");
INSERT INTO bkw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Duwala soog nɛ nyoog. Kwyɛla sɔ'ɔ mot dáa wɔ di ekwyɛl nyel'ɔ wɔ ɛmet ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ngbaaz'enɔk eezɛbɔɔza nɛ nɛ náá: «Mɛtiŋ menek djas mɛ nɛ duwal yɛ. Mɛ kabaasa yé?» ");
INSERT INTO bkw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","É di'enek, Yezu eezɛbɔɔza nɛ nɛ náá: «Wɔ kwyɛl ɛdi tɔ epiki ɔɔ, tɔ́ kɛbɔmsa esa bɔ djas, da wɔ ɛ́ nɔɔ epata tak, djɛ bɛdjel ɛ bot. Tin, wɔ waabela mɛvu tɔ gwoo. Bhii tak, da wɔ ɛ́ zyɛ, zɛdu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dáa ngbaaz'enɔk nagwak deenek ɛ, «kiyooo» nyɛ eeliigel, sik yɛ, etɛɛ náá, ye naatek nyɛ nyel, étɛp ekum ee nyɛ nadi nɛ yɛ ɛbuɛpe ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bhii tak, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Mɛ lɛɛ bin ɛ́ etɛp ee tsɛɛtsɛ náá: Ɛkɔɔla náá, bot ɛ di nɛ mɛvu ɔ ni tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mɛ baalɛɛ bin ɛ náá, ɛkɔɔla náá, boo yaaga kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ dhaa tɔ ba mɔɔ ɛlen ɛ dhɔɔ. Yɛ kabɛ bɛkum ɛ bot ɔ, ɛni ɛ lɔɔ tɔ Ɛyoŋ ɛ Zɛɛb eebaadhaa-dhaŋak ɛni ɛ yaaga tɔ ɛlen ɛ dhɔɔ nɛ mɛlyel.» ");
INSERT INTO bkw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Dáa bɛdjekel nagwak mɛkpa menek ɛ, bɛ naadyeebadjoka. Bhii tak, bɛ ɛ́ boozɛdji Yezu náá: «Yɛ bɛ deenek ɔɔ, ɛzɛ aabela tsik?» ");
INSERT INTO bkw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yezu zokabɔɔza nɛ nɔɔ náá: «Ye ɛ́ ɛpipɛpe é mis mɛ bot. Tin, mot ɛ dum koŋ nɛ Zɛɛb ɔɔ, yɛ waasael.» ");
INSERT INTO bkw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wɔ gwaa, Pyɛɛd zɛke nɛ nɛ náá: «Gwaka! Bis eezekat mɛze mes nɛ etɛp bis djas étɛp ɛdu ɛ wɔ. Yisɔ efute aakadi tin yé?» ");
INSERT INTO bkw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tin, Yezu eezɛbɔɔza nɛ nɔɔ: «Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, é ghɛŋ Sɛɛŋɛlɛ Mɔn Mot aadi kɔ bóó mɛkoozi mɛ nɛ duma tɔ Ɛyoŋ ɛ na bes ɛ, biyɔ, bot kam nɛ bɛbá namyaal ɛdu ɛ mɛ ɔ, bi aadi ɛ́, kɔ mɛbhóó mɛ mɛkoozi kam nɛ ebá, étɛp ɛpɛ́ɛ ɛ membyak kam nɛ ebá ɛ Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Bot ɛ di ebet mendjaa mɔɔ, bɔn nyɛɛg bɔɔ, nɛ bɛkɛl bɔɔ, zɛnɔɔ bɛsɛɛg bɔɔ nɛ bɛnyɛɛg bɔɔ, bɔn bɔɔ, zɛnɔɔ epyeeb bɔɔ étɛp'am ɔ, bɛ waabela bɛdhet nɛ bɛdhet kala kɔ yii. Bɛ waabela tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tin, ye kabela ɛ́ náá, bɛtɛ nɛ bot ɛ di mos é lɔɔg ɛsok ɔ, bɛ aakaswaala ɛ́ bot ɛ ɛbhis. Bot ɛ di mos pɛ lɔɔg ɛbhis ɔ, bɛ aaswaala ɛ́ bot ɛ lɔɔg ɛsok.» ");
INSERT INTO bkw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Beeka dhiiti sa di enɔŋel nɛ Ɛyoŋ ɛ di tɔ gwoo ɛ: Dhiiti kukuma naazɛwyis tɔ ghooghom mɛlem kɛsaa bot étɛp bɛ neekɛsa mɛsa tɔ pyeeb vin'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bɛ nɛ bɛ nɔɔ zokagwakel náá, efute bɔɔ aadi ɛ́, dáa bot di ezyɛ nɛ ɛfutaa sok ɛ, nɛghu falanga wat tɔ ɛlu ɛ wat. Tin, nyɛ eezɛlwom bɛ, bɛ kɛsa mɛsa tɔ pyeeb'ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«Nyɛ eebaazɛwyis é ɛwala etɛn nɛ ená yii mɛlem, wɔ gwaa nyɛ baazɛboma nɛ bɛdhiiti bot metetel kɔ ɛbɛsɛɛ dɛl, bɔɔ tin, ààbɛ nɛ mɛsa. ");
INSERT INTO bkw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nyɛ ɛ́ boozɛke nɛ nɔɔ náá: “Biyɔ pe, tɔ́ka, kɛsaka mɛsa tɔ pyeeb vin'am, mɛ aadjɛ bin efute dáa ye di egoka ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tin, bot binɔk ɛ́ boozɛnɔɔ mɛnyel, tɔ́.» «Bhii tak, kukuma yenɔk naabaazyɛ kuku mwos dwoo dɔɔ nɛ é ɛwala elɛl yii bikoko. Nyɛ nabaazolii ɛ́ dáa nyɛ nazolii nɛ bot ɛsok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nyɛ eebaazɛwyis bikoko, dwoo eezesila. Tin, nyɛ ɛ́ boo baazɛboma nɛ yak ɛdhuu ɛ bot. Nyɛ eezɛdji bɛ náá: “Étɛp yé bi di wak, kana mɛlem, kɛyaka nɛ yak ɛwala, ààsa sonok?” ");
INSERT INTO bkw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bot binɔk zokazɛbɔɔza nɛ nɛ: “Ye ɛ́, etɛɛ náá, bis tok nɛ mɛsa mɛ ɛsa.” Bhii tak, nyɛ ɛ́ booke nɛ nɔɔ náá: “Dɔɔ nɛ biyɔ pe, tɔ́ka, kɛsaka mɛsa tɔ pyeeb vin'am.”» ");
INSERT INTO bkw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Dáa dwoo nakabɛ, ye moo bikoko ɛ, kukuma ɛ́ booke nɛ mot nadi kɔ elo e bot ɛ mɛsa mɛ djas ɔ náá: “Djóoa bot ɛ mɛsa, da wɔ ɛ́ djɛ mot nɛ mot efute bɛ. Wɔ kan ɛ́ nɛ bot ɛ nadjóoaa ɛbhis ɔ, da wɔ ɛ́ kɛsilal nɛ bot ɛ́ nakanaa ɛdjóoaa sok ɔ.”» ");
INSERT INTO bkw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Tin, bot ɛ nakan mɛsa bikoko ɔ, zokazyɛ, zɛbela yɔbɔ efute e pata wat. ");
INSERT INTO bkw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Dáa bot ɛsok nakazyɛ yɔbɔ ɛ́, bɛ nagek tɔ elyem bɔɔ ɛ náá, bɛ waabela efute dhaa bot ɛ nakan bikoko ɔ. Tin, bɛ nazokabaadjɛ bɛ ɛ́ efute e pata wat. ");
INSERT INTO bkw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Beea bɛ nabee deenek ɛ, bɛ ɛ́ boozɛni é byak kukuma pyeeb. ");
INSERT INTO bkw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bɔɔ náá: “Bot ɛ kan mɛsa nenak bikoko ɔ, bɛ zosa ɛ́ mɛsa é di ɛwala wat. Tin, wɔ kadjɛ bɛ efute ɛ́ tyee wat nɛ dáa wɔ djɛ bisɔ ɛ? Bot ɛ kan mɛsa tɔ mɛlem ɔ, si kas-kas gwyes nɛ etuŋ, zɛnɔɔ mɛnyel na ‘wɔyɔŋ’ ghwyil djas eezesi.”» ");
INSERT INTO bkw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Tin, kukuma ɛ́ boobɔɔza nɛ ngɔt pak'ɔɔ náá: “Mɔn nyaag'am, ye tok nɛ ɛbiyo mɛ sa ɛ. Tin, mena bɛ ààgwakel náá, wɔ sa mɛsa ɛ étɛp wɔ neebela etuud e pata wat, di egoka náá, ye djɛaa nɛ mot sa mɛsa mɛ dwoo wat ɔ, etsal é? ");
INSERT INTO bkw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɔŋa pata yɔ, da wɔ ɛ́ tɔ́ yɔ, etɛɛ náá, mɛ neebaadjɛ nwyak mot kalik'aak dáa mɛ djɛ wɔy ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mɛ tok nɛ ghwyil ɛbe esa bam dáa lyem'am di ekwyɛl ɛ? Étɛp yé wɔ di ebyen náá, mɛ sa enɛm esa?”» ");
INSERT INTO bkw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","É di'enek, Yezu ɛ́ bookabaazɛpesal náá: «Yɛ aadi ɛ́ deenek, bɛtɛ nɛ bot ɛ́ di bot ɛ mɛsik'aak, bɛ kaaswaalaaa ɛ́, bot ɛ ɛsok. Bot ɛ ɛsok'aak aaswaalaa ɛ́ bot ɛ mɛsik.» ");
INSERT INTO bkw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Dáa Yezu nadi etɔ́ pɛ Yeluzalɛm ɛ, nyɛ naazɛnɔɔ bɛdjekel kam nɛ bɛbá bɔɔ bɛ ɛmet. Tin, dáa bɛ nadi ekɛ ze ɛ ze ɛ, nyɛ ɛ́ boozɛlɛɛ bɛdjekel náá: ");
INSERT INTO bkw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Gwakeka, mena tɔ́ka wak ɛ́, pɛ Yeluzalɛm pɛ Sɛɛŋɛlɛ Mɔn Mot aakɛkaaa é mɛmbɔ mɛ eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi ɛ, étɛp bɛ needjɛ nyɛ epɛ́ɛ e ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bhii tak, bɛ waaka nyɛ é mɛmbɔ mɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ, étɛp bɛ needim nyɛ nɛ ɛduk nyɛ. Bɛ waanyuu nyɛ nɛ eghwyɛs bhii tak, da nyɛ ɛ́ kɛbemaa kɔ mɛlaaba. Tin, é mɛlu mɛlɛl bhii ɛsyee ɛ lɛ, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wɔ gwaa, mwaa Zɛbɛdɛ zokazyɛ nɛ bɔn bɛ bɛbá zɛbee Yezu. Dáa bɛ nakum é di Yezu nadi ɛ́, nyɛ eezɛkwyit mɛboŋ sok bhwoob'ɛ étɛp nyɛ neewaab sonok pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yezu ɛ́ booke nɛ nɛ náá: «Wɔ saa yé?» Moma tak ɛ́ boozɛbɔɔza nɛ Yezu náá: «Beea bɔn bam bɛbá bak. Mɛ kwyɛl ɛ́, wɔ kɛk mɛ náá, bɛ bela duma di náá, ngɔt di pɛ mbɔ eghɛŋ bɔ, nwyak ngɔt pɛ mbɔ ɛmyɛl ɛ lɔ, é sok waadi tɔ mɛkoozi mɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tin, Yezu ɛ́ boozɛbɔɔza náá: «Bi ààgu sa bi di ewaab ɛ. Bi ɛ́ nɛ ghwyil ɛbɛp kɔm mezuk mɛ mam aabɛp ɛ?» Bɛ eezɛbɔɔza náá: «Hɛɛɛ! Bis ɛ́ nɛ ghwyil ɛbɛp.» ");
INSERT INTO bkw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yezu eezɛke nɛ bɔn bɛ bɛbá náá: «Ye ɛ́ tsɛɛtsɛ! Bi ɛ́ waabɛp kɔm mezuk mam. Yɛ kabɛ dum nɛ tɛp ɛdi pɛ mbɔ eghɛŋ bam nɛghu pɛ mbɔ ɛmyɛl ɛ lam ɔ, mam tok nɛ ghwyil ɛdjɛ bin edi é tak. Etɛɛ náá, Saag'am ɛ di egu bot ɛ nyɛ aadjɛ edi binek ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dáa bak bɛdjekel kam nalik ɛ nagwak deenek ɛ, ye nabɛ ɛ́, ye naakpaa bɛ elyem nɛ sa Zak bɛ nɛ Zaŋ nasa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bhii tak, Yezu ɛ́ bookazɛdjóo bɔɔ djas, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Bi kabɛ edjak náá, mɛsa mɛ ekukuma e bot ɛ bɔs ɛ́ ɛnyal bot ɛ́ di ezuk ɔ. Mɛsa mɛ bot ɛ di djóoaa eboo bot ɛ bɔs ɛ, ye ɛ́ ɛnyal bot ɛ di eduwal bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ghuna, yɛ ààgoka nɛ ɛsɛ́ɛ deenek pak'en. Ye goka ɛ́ náá, ngɔt pak'en ɛ́ kwyɛl ɛdi kɔ elo bɛsɔ ɔɔ, nyɛ di mot-mɛsa mɛ bɛsɔ. ");
INSERT INTO bkw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","É di'enek, mot aakwyɛl ɛdi pɛ sok bɛsɔ ɔ, di kwom bɛsɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Étɛp tak ɛ́ di náá, ɛzyɛ ɛ́ Sɛɛŋɛlɛ Mɔn Mot nabɛ ɛ́ ààbɛ, etɛɛ náá, nyɛ eezɛliig bot, bot ɛ mɛsa mɛ. Nyɛ nazyɛ ɛ, étɛp ɛzɛdi mot-mɛsa mɛ bot, nɛ ɛzɛdjɛ bot tsik'ɛ nyɛ ɛmet tyee etuud étɛp ɛpɛk bɛtɛ nɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bhii bɛ nawyis kɔ dɛl ɛ Yeliko ɛ, zukamwaa nɛ mot naazɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tin, wɔ gwaa bot ɛ edhim bɛbá nadidi é ngwoob gba ɔ, zokagwak menduk náá, Yezu ɛpedhaa tin. Wɔ gwaa bɛ zɛbo etsim náá: «Ghɛŋ, Mɔn Dhavid! Geka bis ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ɛdhuu ɛ bot ɛ nadi edu Yezu ɔ, moo tin ebhɛm bɛ étɛp bɛ needi gwyem. Wɔ gwaa bɛ zokabaaben ebhyeed bɔɔ ɛlyelɛpe náá: «Ghɛŋ, Mɔn Dhavid! Geka bis ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","É sok'enek, Yezu eezɛtyaa. Wɔ gwaa nyɛ zokadjóo bɛ. Nyɛ eezɛdji bɔɔ bɛbá náá: «Bi kwyɛl náá, mɛ sa bin yé?» ");
INSERT INTO bkw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bot binɔk ɛ́ boopesal náá: «Ghɛŋ, bis kwyɛl ɛ́ náá, bis nyaasok.» ");
INSERT INTO bkw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tin, Yezu zokazɛgek bɛ ghoŋ. Bhii tak, nyɛ eezɛkɛl bɛ mɛmbɔ kɔ mis. É di tak wat, mis mɔɔ eezebɛŋel, tin, bɛ eezɛdu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Dáa bɛ nadi, bɛ moo ekunaa nɛ Yeluzalɛm ɛ, bɛ moo é ngwoob dɛl ɛ bɛ di djóo Bhɛtfaze, pɛ ɛtsok ɛ pyeeb oliv ɛ, Yezu eezɛlwom bɛdjekel bɛ bɛbá: ");
INSERT INTO bkw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nyɛy nɛ nɔɔ náá: «Tɔ́ka kɔ dɛl ɛ di pɛ sok'enek. Tuula bi aatuula kɔ dɛl ɛ tak ɛ, bi ɛ́ waabela dhiiti mbi myɛl tit di edjóoaa an ɛ nɛ mɔɔ swooz tak kɔla é di wat. Tiika bɛ, da bi ɛ́ zyɛ mɛ nɛ nɔɔ wak. ");
INSERT INTO bkw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mot ɛ́ dji bin náá: “Bi tɔ́ nɛ nɔɔ wo ɔɔ?” Lɛɛka nyɛ náá: “Ye ɛ́ Ghɛŋ ɛ́ di nɛ gwyes nɛ nɔɔ ɔ.” Tin, bɛ waaleedjɛ bin bak.» ");
INSERT INTO bkw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Esesɛɛ binek goka nɛ ɛsael, etɛɛ náá, etɛp ee di kwyala tɔ mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb ɛ neebela ɛsuk: ");
INSERT INTO bkw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Lɛɛka nɛ ɛsyes ɛ ghaada Siɔŋ náá: “Beea, mɛkoozi mɔ ɛpezyɛ pɛ daa lɔ. Nyɛ zyɛ ɛ́ nɛ enɛm esa, nyɛ ɛ́ ndiindil kɔ mɔɔ swooz an. Nyɛ zyɛ ɛ́ ààbɛ nɛ ɛbet, nyɛ ɛ́ ndiindil kɔ mɔɔ swooz an.”» ");
INSERT INTO bkw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bhii tak, bɛdjekel eezɛtɔ́. Dáa bɛ nakakum é di tak ɛ, bɛ ɛ́ boozɛsa tyee Yezu nalɛɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wɔ gwaa bɛ zɛsik nɛ myɛl an, nɛ swooz an tak Yezu nawaab ɛ. Bɛ moo tin ezɛkɛl bɛ endjookuwa bɔɔ kɔ ekoŋ. Bhii tak, Yezu eezɛkalal kɔ tak, disi. ");
INSERT INTO bkw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","É di tak wat, bot ɛbuɛpe naabaazɛdja yɔbɔ endjookuwa gba-gba, bɛdhiiti nadi etsaal yɔbɔ ɛ́ ebhuuz e le, étɛp ɛdja é gba. ");
INSERT INTO bkw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ngoŋ bot ɛ́ nadi ekɛ pɛ sok ɔ, nɛ bot ɛ nakabɛ pɛ bhis ɔ, moo tin ekyeeb: «Hozanna nɛ Mɔn Dhavid! Duu nɛ Zɛɛb! Zɛɛb goka ɛ́ nɛ ɛsɛɛ mot di ezyɛ nɛ din ɛ Ghɛŋ ɔ mbɛɛ mɛtel! Hozanna nɛ Zɛɛb pɛ tɔ gwoo!» ");
INSERT INTO bkw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Dáa Yezu nakani tɔ Yeluzalɛm ɛ, bot djas kɔ dɛl nabɛ ɛ́, bɛ moo «nyaa-nyaa», bɛ ɛ́ boozɛdji: «Yenɔk ɛ́ nwyaa mot?» ");
INSERT INTO bkw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mɛdhuu mɛ bot nadi ebɔɔza náá: «Ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb, Yezu mɔn dɛl ɛ Nazalɛt pɛ kyee dik Ghalile.» ");
INSERT INTO bkw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bhii tak, Yezu naazɛni tɔ kok Ndjaa-ebuwa. Deenek, nyɛ moo tin esɔ bot ɛ nadi ebɔmsa esesɛɛ bɔɔ ɔ. Nyɛ baadi esɔ dɔɔ nɛ bot ɛ́ nadi ebɔm-bɔmak nadi tin ɔ, nyɛ naawaaz emesa ee bɛ nadi eswoola epata kɔ tak ɛ, nɛ mɛbhóó mɛ bot ɛ́ nadi ebɔmsa mɛghum ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bhii tak, Yezu eezɛbaakaada bɛ náá: Ye tok kwyala tɔ mɛkpa ɛ Zɛɛb náá: «Ndjaŋ'am aadjóoaa ɛ́, “ndjaa mendjaala” Mɛ bee ɛ́ ɛkɛɛ, biyɔ, bi eezeliig yɛ, ye moo ɛ́ zɛɛga bot ɛ ɛzɛm.» ");
INSERT INTO bkw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","É di tak wat, bot ɛ nadi nɛ edhim ɔ, nɛ bot ɛ nadi nɛ edjam ɔ, naazyɛ pɛ daa Yezu tɔ kok Ndjaa-ebuwa, nyɛy zokatsik bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tin, bɛghaŋ ɛ mɛkana mɛ etsi nɛ eboo bɛghaa-Zɛɛb nabɛ ɛ́ ebee esesɛɛ binek djas Yezu nasa ɛ. Bɛ naabee pe dáa bɔɔ dhyeeb nadi eduwal nyɛ nɛ etsim tɔ Ndjaa-ebuwa ɛ. Bɛ nadi kyeeb ɛ́ náá: «Duu nɛ Mɔn Dhavid!» Bɛ ɛ́ boozɛkpaa elyem. ");
INSERT INTO bkw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bot binɔk ɛ́ boozɛdji Yezu náá: «Wɔ ɛpegwak dáa bɔɔ dhyeeb di eke'enek é?» Yezu eezɛbɔɔza nɛ nɔɔ: «Iyoo! Mɛ ɛpegwak. Bi nabɛ ɛ́ ààlaa tɔ mɛkana mɛ Zɛɛb é di nakwyalaa náá: “Tɔ enuub e bɔɔ dhyeeb nɛ bɔɔ etɔlɔɔ, wɔ eelyaal dáa bis di egoka nɛ ɛduwal wɔ ɛ?”» ");
INSERT INTO bkw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bhii tak, nyɛ zɛwyis, tɔ́ pɛ dɛl ɛ Bhetani pɛ bɛ nakɛdjaasi ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yak mɛlem, é ghɛŋ bɛ nadi esik pɛ boo dɛl ɛ, wɔ gwaa za zɛmɛt Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nyɛ eezɛbee le fiigh é ngwoob gba. Tin, Yezu eezɛtiila si le tak étɛp nyɛ neebɔ́k. Dáa nyɛ nakakum si le ɛ, nyɛ kabela eka nɛ eka, ààbɛ nɛ bhum. É di'enek, Yezu ɛ́ booke nɛ le tak náá: «Kana dwoo pan mos'ak, wɔ aanàkwaakabaawum!» É di tak wat, wɔ gwaa le syee. ");
INSERT INTO bkw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Dáa bɛdjekel nabee deenek ɛ, ye nabɛ ɛ́, bɛ naadyeebadjoka, bɛ ɛ́ boozɛdji Yezu náá: «Étɛp yé le fiigh zosyee é di wat deenek?» ");
INSERT INTO bkw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yezu eezɛbɔɔza nɛ bɛdjekel bɛ náá: «Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá: bi ɛ́ di edum koŋ nɛ Zɛɛb ɔɔ, bi ɛ́ di ààsa mɛso ɔɔ, bi ɛ́ nɛ ghwyil ɛsa esa mɛbwala dhaa yii mɛ sa nɛ le fiigh'ak ɛ. Bi ɛ́ nɛ ghwyil ɛke nɛ ɛtsok ɛlak náá: “Ghɛɛa nyel tin, dusa, kɛghaaga tɔ boo dii,” yɛ ɛpesɛ́ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Bi ɛ́ dum koŋ nɛ Zɛɛb ɔɔ, esesɛɛ djas bi aawaab tɔ mendjaala ɛ, Zɛɛb ɛ́ waadjɛ bin yɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bhii tak, Yezu eezɛni tɔ kok Ndjaa-ebuwa, nyɛ moo tin elyo bot mɛkpa ɛ Zɛɛb. Eboo bɛghaa-Zɛɛb, nɛ bɛpaa ɛ eYuda zokazyɛ pɛ daa lɛ zɛdji nyɛ náá: «Kɔ eghɛŋ e zɛ wɔ di esa esesɛɛ binek? Ɛzɛ nadjɛ wɔ eghɛŋ e tak?» ");
INSERT INTO bkw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bwoodka, mɛ pookodji bin kiya wat. Bi ɛ́ bɔɔza mɛ ɔɔ, ye ɛ́ mɛ aakalɛɛ bin kɔ eghɛŋ e zɛ mɛ di esa esesɛɛ binek. ");
INSERT INTO bkw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ye ɛ́ ɛzɛ nadhis Zaŋ, nyɛ zɛduu bot Zɛɛb? Ye nabɛ ɛ́ Zɛɛb “ohoo”, ye nabɛ ɛ́ mot?» É di'enek, bɛ moo tin esɔs pak'ɔɔ. Bɔɔ náá: «Mena aake nenak náá: “Ye ɛ́ Zɛɛb ɛ́ nadhis nyɛ” ɔɔ, nyɛ waadji mena náá: “Étɛp yé bi nadi ààmyaal Zaŋ?” ");
INSERT INTO bkw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mena aakake nenak náá: “Ye ɛ́ bot ɛ nadhis nyɛ” ɔɔ, ye goka ɛ́ náá, bis kaab ɛdhuu ɛ bot, etɛɛ náá, bɛ dyeebake ɛ́ náá, Zaŋ nabɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bɛ ɛ́ boozɛbɔɔza nɛ Yezu náá: «Bis ààgu.» Tin, Yezu ɛ́ boozɛbulal nɛ nɔɔ náá: «Dɔɔ nɛ mam pe, mɛ aanàkwaalɛɛ bin kɔ eghɛŋ e zɛ mɛ di esa esesɛɛ binek.» ");
INSERT INTO bkw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yezu eebaazɛke nɛ nɔɔ náá: «Yak kwyɛl ɛlɛɛ bin yé? Motom ngɔt nabɛ ɛ́ nɛ bɔn bɛbá. Nyɛ eezɛke nɛ yii mɛgwyak náá: “Mɔn'am, dwoo ɛlak mos, tɔ́ kɛsa mɛsa tɔ pyeeb'am e vin.” ");
INSERT INTO bkw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nyɛ eezɛbɔɔza nɛ sɛɛg: “Hoo, mɛ aanàkwaatɔ́.” Ba ɛwala eezɛdhaa bhii tak, mɔn'enɔk eezɛdjɛ lyem mɛbɛ, tin, nyɛ eezɛnɔɔ nyel, tɔ́ pɛ pyeeb vin sɛɛg nalwom nyɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Wɔ gwaa sɛɛg'ɔɔ baazɛlwom mɔɔ dhyeeb. Mɔn tak eezɛmyaal: “Iyoo, mɛ waatɔ́.” Bhii tak, nyɛ kadi ɛ́, ààtɔ́. ");
INSERT INTO bkw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Tin, tɔ bɔn binɔk bɛbá, ɛzɛ looba dum nɛ lwomel sɛɛg'ɔɔ?» Bɛ eezɛbɔɔza nɛ Yezu náá: «Ye ɛ́ mɔn mɛgwyak.» Tin, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, bɛnɔŋel ɛ epata e lapo nɛ boa ɛ mɛzɔ ɛ́ waaleeni tɔ Ɛyoŋ ɛ Zɛɛb ɛsok nɛ nen. ");
INSERT INTO bkw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Etɛɛ náá, Zaŋ Nduuel-bot nazyɛ ɛ́ zɛlyaal bin ze epiki, bi nabɛ ɛ́ ààmyaal nyɛ. Tin, bɛnɔŋel ɛ epata e lapo nɛ boa ɛ mɛzɔ naamyaal nyɛ. Bela náá, dáa bi naabee yɛ ɛ, bi nabɛ ɛ́ ààliig elyem bin, bi ààpakomyaal-myaalak nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Gwakeka dhiiti kana. Mot ngɔt naabɛ pyeeb ele di edjɛ bhum bɛ di esa mɛnyok mɛ vin nɛ yɛ ɛ. Nyɛ eezɛpeeb pyeeb tak, pu guk tɔ ɛkok é di bɛ aadi esyaal mɛdii mɛ bhum tak ɔ, baasum ndjaa, étɛp bot aadi ebaal pyeeb ɔ. É di tak, nyɛ eezɛdjɛ bot ɛ di egu mɛsa mɛ vin ɔ etɛp bɛ neesa mɛsa tɔ tak. Nyɛ eezɛnɔɔ nyel, tɔ́ mɛdjoŋ. ");
INSERT INTO bkw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tin, mbu epyeeb e tak di ewum ɛ, yɛ eezɛkum. Wɔ gwaa, nakuma pyeeb zokazɛlwom bot ɛ mɛsa mɛ pɛ daa bot ɛ nyɛ nalik bɛ nɛ pyeeb ɔ, étɛp bɛ needjɛ nyɛ yɛ pak vin bɛ bela ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wɔ gwaa, bot ɛ nalik nɛ pyeeb ɔ, zokazɛmɛt bɛ. Bɛ eezɛduma ngɔt é nyel nɛ mɛbin, bɛ eenɔɔ nwyak gó nyɛ, zɛnɔɔ nwyak tak, bɛ eezɛwus nyɛ nɛ mɛkok, gó nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Bhii tak, nakuma pyeeb ɛ́ boozɛkyeed bot ɛbuɛpe dhaa bot ɛ nyɛ nalwom sok ɔ, pɛ pyeeb tak, bɛ nabaazosa nɛ nɔɔ ɛ́ deenek. ");
INSERT INTO bkw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bhii tak, nyɛ ɛ́ boozɛlwom mɔn'ɛ met. Nyɛ nabɛ ɛ́ nɛ geka náá: “Bot binɔk ɛ́ waamyaal nyɛ nɛ ɛdjɛ nyɛ duu, etɛɛ náá, yɛ ɛ́ mɔn'ɛ met.” ");
INSERT INTO bkw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dáa bot ɛ nadi esa mɛsa tɔ pyeeb ɛ nabee mɔn'enɔk ɛ, bɔɔ náá: “Yawee! Beeka mot aalik nɛ mɛvu mak djas ɔ! Dhaka, mena góka nyɛ. Tin, mɛvu mak aakadi ɛ́, yenabɛlka.” ");
INSERT INTO bkw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wɔ gwaa, bɛ zɛmɛt nyɛ, mwas nyɛ bhii pyeeb vin, bɛ eezɛgó nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yezu ɛ́ boozɛdji bɛ náá: «É di'enek, é sok nakuma pyeeb aakazyɛ ɛ́, nyɛ goka nɛ ɛsa bot binɔk dáa?» ");
INSERT INTO bkw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yala yɔbɔ kabɛ ɛ́ náá: «Ye goka ɛ́ nakuma pyeeb gó bot ɛ nadi esa mɛsa tɔ pyeeb'ɛ ɔ ààgek bɛ ghoŋ. Bhii tak, da nyɛ ɛ́ nɔɔ pyeeb, djɛ nɛ bot ɛ sis aazɛdjɛ nyɛ yɛ pak ɛkɛɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","É di'enek, Yezu ɛ́ booke nɛ nɔɔ náá: «Bi dinaa ààpaalaa mɛkpa mak tɔ ekwyala e Zɛɛb é? “Ɛkok ɛ bɛsumel mwas ɛ́, ye moo ɛ́ ɛkok ɛ di epyet ndjaŋ ɛ. Ye ɛ́ nɛ ghwyil ɛ Ghɛŋ. Ye ɛ́ tin ɛ boo mbyok étɛp'ena!”» ");
INSERT INTO bkw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yezu eebaazɛkɛl náá: «Mɛ lɛɛ bin ɛ́ náá, bi ɛ́ waadɛkaa Ɛyoŋ ɛ Zɛɛb, étɛp ye needjɛaa nɛ bot ɛ mbyak aadi edjɛ bhum ɔ.  ");
INSERT INTO bkw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mot aaduma kɔ ɛkok ɛ tak ɔ, nyɛ waabik. Yɛ kabɛ náá, ɛkok ɛ kakwyit kɔ mot ɔɔ, mot tak ɛpetwaalel. Nyɛ moo eghutu-ghutu.» ");
INSERT INTO bkw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gwaka bɛ nagwak kana tak ɛ, eboo bɛghaa-Zɛɛb, nɛ eFalizyɛ nabɛ ɛ́, bɛ eegu náá, Yezu nalii ɛ́ nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bɛ ɛ́ boozɛkan ɛsaa mɛpek étɛp bɛ neemɛt nyɛ. Bɛ nadi ɛ́ nɛ bwoo ekaab mɛdhuu mɛ bot ɛ nadi tin ɔ. Bot ɛ tak nake ɛ́ náá, Yezu ɛ́ ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yezu eebaazɛkan ɛlii nɛ bot tɔ kana. Nyɛy náá: ");
INSERT INTO bkw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Beeka sa di enɔŋel nɛ Ɛyoŋ ɛ di tɔ gwoo ɛ: Dhiiti mɛkoozi naazɛdjóo ɛbyoŋ étɛp ɛba ɛ mɔn. ");
INSERT INTO bkw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ye ɛ́ nyɛ kazɛlwom bot ɛ mɛsa mɛ, bɛ kɛdjóo bot étɛp ɛdɛ edee ɛbyoŋ ɛ ɛba. Tin, bot ɛ tak ààpakakwyɛl ɛzyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bhii yenek, nyɛ eebaazɛlwom bɛdhiiti bot ɛ mɛsa mɛ é yak kɔkɔ nɛ bhaadal náá, bɛ kɛlɛɛ bot náá: “Edee moo ɛ́ ndjaaba. Mɛ eezegó engɔmbɛ nɛ etaa bam na mɛdɛl. Esa djas moo ɛ́ koobela. Dha dɛka ɛbyoŋ.” ");
INSERT INTO bkw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tin, bot ɛ nadjóoaa ɔ, ààkobis-bisak, mot nɛ mot naaghɛɛ yɛ nyel, tɔ́ mɛze mɛ. Nwyak tɔ́ pɛ pyeeb'ɛ, nwyak tɔ́ pɛ nyɛ di ebɔmsa esa bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bak bot zokazɛmɛt bot ɛ mɛsa mɛ kukuma yenɔk nalwom ɔ, duma bɛ é mɛnyel nɛ mɛbin, bɛ ɛ́ boozɛgó bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mɛkoozi zokazɛkpaa lyem: nyɛ ɛ́ bookazɛlwom esodja bɛ, bɛ gó bot ɛ nagó bot bɛ ɔ. Bhii tak, da bɛ ɛ́ dik eghaada bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bhii tak, nyɛ eezɛlɛɛ bot ɛ mɛsa mɛ náá: “Edee e ɛbyoŋ ɛ ɛba moo ɛ́ koobela. Bot ɛ djóoaa bɛ zɛdɛ ɔ, ààkɔa nɛ ɛdɛ edee e tak. ");
INSERT INTO bkw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wyiska, da bi ɛ́ tɔ́ kɔ eboo egba. Djóoka mot djas bi aaboma nɛ nɔɔ ɛ, bɛ zɛdɛ edee e ɛbyoŋ ɛ ɛba.” ");
INSERT INTO bkw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bot ɛ mɛsa zokazɛtɔ́ egba nɛ egba, kɛdjóo bot djas bɛ aaboma nɛ nɔɔ ɔ, bɛmbee ɛ bot nɛ bɛmbɛɛ bot. Tin, koo bɛ nakoobal étɛp ɛbyoŋ ɛ naalwood “kpep”. ");
INSERT INTO bkw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Tin, mɛkoozi eezɛni tɔ koo tak, étɛp nyɛ neekabee bot ɛ zyɛ zɛdɛ edee ɛbyoŋ ɔ. É di'enek, nyɛ kabee kuku bot ɛ́ dhiiti mot ààbɛ nɛ kaad di egoka nɛ ɛbɔtaa é mɛbyoŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nyɛ ɛ́ boodji nyɛ náá: “Mɔɔ sɔ'am, wɔ ni wak dáa, wɔy ààbɛ nɛ kaad bot di egoka nɛ ɛbɔt étɛp ɛ ɛbyoŋ ɛ?” Tin, mot'enɔk kadi ɛ́, ààbɔɔza kiya mɛkoozi menɔk. ");
INSERT INTO bkw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tinaak mɛkoozi eezɛlwom bot ɛ mɛsa mɛ náá: “Mɛtka mot'enɔk, da bi ɛ́ kɔl nyɛ mɛko nɛ mɛmbɔ. Bhii tak, da bi ɛ́ mwas nyɛ pɛ kel, tɔ ghooghom. Penek aadi ɛ́ mɛgwyɛ nɛ ɛkwaal ɛ mɛtsok.”» ");
INSERT INTO bkw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yezu eebaazɛbil náá: «Ye ɛ́, etɛɛ náá, bot ɛbuɛpe ɛ́ waadjóoaa. Tin, bot aasɛ́ɛaa ɔ ààdyeebabu.» ");
INSERT INTO bkw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","EFalizyɛ zokakɛboma étɛp ɛdjek dáa bɛ di egoka nɛ ɛsa, bɛ neekwyesal Yezu nɛ mɛdjin étɛp nyɛ neebela ndjɛ kɔ mɛkpa mɛ ɛmet ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bɛ ɛ́ boozɛkyeed bɛdhiiti bɛdjekel bɔɔ, nɛ bot ɛ zɛɛga ɛ mɛkoozi Elood, bɛ zɛlɛɛ nɛ Yezu náá: «Lyoel, bis nɛ gu náá, etɛp ee wɔ di elɛɛ ɛ, ye ɛ́ etsɛɛtsɛ. Wɔ lyo bot ɛ́ epiki dáa mot di egoka nɛ ɛkɛ dáa Zɛɛb di ekwyɛl ɛ. Wɔ ààbem ba nɛ sa mot di egek tɔ lyem'ɛ ɛ, etɛɛ náá, wɔy ààdyeebagwyák sa bot di esa étɛp bɛ neetela mɛnyel ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Lɛɛa bis, tɔ yɔ egeka dáa wɔ di ebee ɛ: etsi bina lɛɛ ɛ́ náá, bot tuud lapo nɛ mɛkoozi Sezaad, mena tuudka ohoo mena nàtuudka?» ");
INSERT INTO bkw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dáa Yezu nadi egu mbee mɛpek mɔɔ ɛ, nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Étɛp yé bi di ekwyɛl ɛwa mɛ tɔ mɛbhowal? ");
INSERT INTO bkw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pookolyaalka mɛ falanga wat bot di etuud lapo nɛ yɛ ɛ, étɛp mɛ neebee.» Wɔ gwaa, bɛ zɛzyɛ nyɛ nɛ mɔɔ falanga wat. ");
INSERT INTO bkw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bhii tak, Yezu ɛ́ boozɛdji bɛ náá: «Kɔ ghwooz'ak, ye lulaa ɛbhwoob ɛ zɛ? Ye ɛ́ din ɛ zɛ di kwyala kɔ tak?» ");
INSERT INTO bkw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bot binɔk eezɛbɔɔza nɛ Yezu náá: «Ye ɛ́ yɛ Sezaad.» Tin, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Djɛka mɛkoozi Sezaad sa di náá ye ɛ́ yɛ Sezaad ɛ, da bi ɛ́ djɛ Zɛɛb sa di náá, ye ɛ́ yɛ Zɛɛb ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gwaka bɛ nagwak eyala ɛ Yezu deenek ɛ, ye nabɛ ɛ́, bɛ naadyeebadjoka ɛlyelɛpe. Bhii tak, bɛ boozɛnɔɔ mɛnyel, tɔ́ yɔbɔ. ");
INSERT INTO bkw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dwoo tak wat, bɛdhiiti eSaduseɛ zokazyɛ pɛ daa Yezu. ESaduseɛ ɛ́ bot ɛ di ke náá, bot aanàgom bhis ɛsyee ɔ. Bɛ eezɛdji kiya, ");
INSERT INTO bkw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","bɔɔ nɛ Yezu náá: «Lyoel, mɛkana ɛ Moiiz lɛɛ ɛ́ náá: “Mot ɛ́ gwyɛ ààlik mɔn ɔɔ, ye goka ɛ́ náá, dhyeeb mot lik ɔ, ba kus myɛl étɛp nyɛ neekwyiida tel gwyɛ ɔ.” ");
INSERT INTO bkw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bela tin, tɔ lɔɔg'es, ye nabɛ ɛ́ nɛ bɔn botom ɛtɛn nɛ bɛbá. Mot mɛgwyak eezɛba, dáa nyɛ kagwyɛ ɛ́, nyɛ kalik kus myɛl nadi ààbɛ nɛ mɔn ɔ nɛ dhyeeb. ");
INSERT INTO bkw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mot nabɔɔba nyɛ ɛ́ kanɔɔ moma bhii koŋ'ɛ. Nyɛy eebaazɛkpaa nɛ mɛsyee, gwyɛ, ààlik mɔn. Tyee wat nɛ mot nabaazyɛ bhis yenɔk ɔ. Tin, bɔɔ djas bɛtɛn nɛ bɛbá kadi ɛ́, ààbya nɛ moma yenɔk. ");
INSERT INTO bkw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bhis ɛsyee ɛ bɔɔ djas, moma eebaazɛkpaa nɛ mɛsyee, gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Dwoo bot aagom bhis ɛsyee ɛ, moma yenɔk aakadi mwaa zɛ pak bɔɔ bɛtɛn nɛ bɛbá? Etɛɛ náá, bɔɔ djas nabɛ ɛ́ botom bɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi ɛ́ tɔ ɛdjak, etɛɛ náá, bi ààmɛt ɛnyɔɛpe sa di kwyala tɔ mɛkana mɛ Zɛɛb ɛ. Bi ààgu ghwyil ɛ Zɛɛb! ");
INSERT INTO bkw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Etɛɛ náá, é ghɛŋ bot aagom bhis ɛsyee ɛ, botom nɛ boa aanàkwaabaabael. Boa pe aanàni mɛba, etɛɛ náá, bot djas aadi ɛ́, dáa efofop tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dum nɛ tɛp ɛgom bhis ɛsyee, bi dinaa ààpaalaa sa Zɛɛb lɛɛ kɔ ɛsu ɛ tak ɛ? Nyɛ naake ɛ́: ");
INSERT INTO bkw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ye ɛ́ mam, Zɛɛb ɛ Abalaam, yɛ Izak, nɛ Zɛɛb ɛ Zakɔɔb.”» Yezu eebaazɛke náá: «Zɛɛb tok Zɛɛb bot ɛ zegwyɛ ɔ. Nyɛ ɛ́ Zɛɛb bot ɛ di nɛ tsik ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ye nabɛ ɛ́, mɛlyo mɛ tak naadyeebakwyɛsa tɔ elyem e mɛdhuu mɛ bot ɛ nadi egwak nyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dáa eFalizyɛ nagwak náá, Yezu naadiyal eSaduseɛ enuub ɛ, bɛ ɛ́ boozɛsɛɛga. ");
INSERT INTO bkw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Dhiiti lyoel etsi e Zɛɛb naazɛkwyɛl ɛbhoal Yezu. Nyɛy nɛ nɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Lyoel, yaa tsi di edhaa etsi djas?» ");
INSERT INTO bkw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yezu kabɔɔza nɛ nɛ náá: «“Wɔ goka ɛ́, wɔ kwyɛl Ghɛŋ Zɛɛb'ɔ, nɛ lyem'ɔ djas, nɛ sisim'ɔ djas, nɛ ɛtselal ɛ lɔ djas.” ");
INSERT INTO bkw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yenek ɛ́ di boo tsi. Ye ɛ́ tsi di dhaa etsi djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gwaka tsi di ebɔɔba yii mɛkɛn ɛ: “Wɔ goka ɛ́, wɔ kwyɛl sɔ'ɔ mot dáa wɔ di ekwyɛl nyel'ɔ ɛmet ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Etsi ɛ Moiiz djas nɛ mɛlyo mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb pyet ɛ́ kɔ etsi binek ebá.» ");
INSERT INTO bkw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Efalizyɛ nadi ɛ́, tɔ yɔbɔ zɛɛga. Yezu ɛ́ boozɛdji bɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Tɔ yebɔ egeka, Mɛsia ɛ́ zɛ?» Bɛ ɛ́ boozɛbɔɔza nɛ nɛ náá: «Nyɛ ɛ́ dha ɛ Dhavid.» ");
INSERT INTO bkw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","É di'enek, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Ye nakosa dáa náá, Dhavid nɛ ghwyil Sisim na Dɛɛ djóo nyɛ “Ghɛŋ”? Etɛɛ náá, Dhavid naake náá: ");
INSERT INTO bkw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ghɛŋ Zɛɛb nake nɛ Ghɛŋ'am ɛ náá: Dha disi pɛ mbɔ eghɛŋ bam. Mɛ waalwom bot ɛ mɛbhuka mɔ lwoma bhel náá, bɛ zɛdhaa si mɛko mɔ.”» ");
INSERT INTO bkw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Yɛ bɛ náá, Dhavid nyɛ ɛmet naadjóo nyɛ “Ghɛŋ” ɔɔ, é yaa tyɛ Mɛsia aakabaadi dha yɛ?» ");
INSERT INTO bkw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bɔɔ djas moo tin «kup», ààbɛ nɛ ɛkpa ɛlóo bhis étɛp djas Yezu nalii ɛ. Kana dwoo ɛlenek, bot nabɛ ɛ́ ààkadjheebal ɛdji nyɛ mɛdjin. ");
INSERT INTO bkw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wɔ gwaa, Yezu zɛlii nɛ mɛdhuu mɛ bot ɛ nadi tin ɔ, dɔɔ nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Nyɛy nɛ nɔɔ náá: «Mɛsa mɛ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ zɛlyo bot dum nɛ dáa etsi ɛ Moiiz di egoka nɛ ɛkɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bi goka ɛ́ nɛ ɛlooba nɛ nɔɔ, da bi ɛ́ sa esesɛɛ bɛ aalwom bin ɛ, djas. Yɛ kabɛ mɛfulu mɔɔ ɔ, sa mot ààsa dáa bɔɔ. Etɛɛ náá, bɛ ààsa esesɛɛ ee bɛ di elyo bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɛ ɛpekaŋal mɛkɔm mɛ na dil-dil di ɛlyelɛpe é ɛbɛp ɛ, bɛ kakɛl ɛ́ kɔ mɛbyak mɛ bot. É di'enek, bɛ kadi ɛ́, ààkwyɛl ɛkokee-keeak nɛ djin bɛ neekogek mɛdil mɛ mɛkɔm mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bɛ sa esesɛɛ bɔɔ djas ɛ́, étɛp bɛ neetela mɛnyel. Deenek, yɛ kabɛ ekwyala ee mɛkpa mɛ Zɛɛb bɛ di ebɛk é ebhata-bhwoob bɔɔ nɛ é mɛmbɔ mɔɔ ɔ, bɛ sa epɛk e tak ɛ́ ɛbɔkɛpe. Yɔbɔ ekel ee di lataa kɔ ekaad ɛ, nɛ elɔbɔ bɔɔ nɛ dyeebadjaa dhaa tyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tɔ mɛbyoŋ, bɛ dyeebakwyɛl ɛdisi ɛ́ kɔ mɛbhóó mɛ koobelaa étɛp bot ɛ duu ɛ. Yɛ kabɛ tɔ́ ndjaa mendjaala mɛ eYuda ɔ, bɛ dyeebakwyɛl ɛnɔŋ ɛ́ mɛbhóó mɛ pɛ sok é di bɛ aatela mɛnyel ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɛ dyeebakwyɛl ɛ́ bot swos bɛ nɛ duu kɔ mɛbɛsɛɛ é di bot di ɛbuɛpe ɔ. Bɛ kwyɛl ɛ́, bot djóo bɛ “Lyoel”. ");
INSERT INTO bkw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Yɛ kabɛ biyɔ ɔ, nàkeka náá, bi djóoaa “Lyoel”, etɛɛ náá, biyɔ djas ɛ́ bɔn sɛɛg ngɔt. Bi ɛ́ nɛ lyoel ngɔt. ");
INSERT INTO bkw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sa mot ààdjóo mot kɔ bɔs'ak “Sɛɛg'es” etɛɛ náá, biyɔ djas ɛ́ bɔn sɛɛg ngɔt, Sɛɛg'en ngɔt di pɛ tɔ gwoo ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nàkwyɛlka náá, bot djóo bin “Kukuma” etɛɛ náá, kukuma yen ɛ́ ngɔt, Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mot ɛ́ kwyɛl ɛdi mot ɛsok ɛ lɔɔg ɔɔ, ye goka ɛ́ nyɛ di tyee mot-mɛsa mɛ bɔn nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mot di eben nyel tɔ bɛsɔ ɔ, nyɛ waasilaa. Mot di esil nyel tɔ bɛsɔ ɔ, nyɛ waabenaa.» ");
INSERT INTO bkw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi ɛpediyal bot ɛbɛ ɛ Ɛyoŋ ɛ di tɔ gwoo ɛ. Biyɔ bɛmet, bi aanàkwaani, tin, bi ààkwyɛl náá, bot ɛ di ekwos ɛni ɔ, bɛ ni tɔ Ɛyoŋ ɛ tak.  ");
INSERT INTO bkw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi ɛpedɛk bɛkus ɛ boa esa bɔɔ djas. É di tak wat, bi nɛ kwyɛl ɛdul ɛ mendjaala na “kpɔkɔlɔm” étɛp ɛtela mɛnyel tɔ bot. É tɛp tak ɛ́ di náá, bi ɛ́ waapɛ́ɛaa ɛ́ epɛ́ɛ wat di na lyel-lyel, ààbɛ nɛ ghoŋ ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi ɛ́ ɛpetɔ́ mɛdjoŋ é edi djas kɔ bɔs nɛ kɔ eboo mɛdhii mɛ mɛsɔn, étɛp ɛsaa mot ngɔt di emyaal ɛdjaala Zɛɛb eYuda ɔ. Tin mot ɛ́ kadu bin ɔɔ, bi kaliig yii zaag mot ɛ mbi mot di egoka nɛ du na kɔm-kɔm ɛ, dhaa-dhaŋak biyɔ bɛmet. ");
INSERT INTO bkw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Haa kpaa-ghoŋ nɛ biyɔ bot ɛ edhim, biyɔ bot ɛ́ di edjɛɛd bot ɔ. Bi dyeebalɛɛ ɛ́ náá: “Mot ɛ́ tuwal myoŋ nɛ mɛsoŋ kɔ Ndjaa-ebuwa ɔɔ, yɛ aanàsa sonok. Nyɛ katuwal myoŋ nɛ mɛsoŋ kɔ lɔɔd di tɔ Ndjaa-ebuwa ɔɔ, nyɛ goka ɛ́ nɛ ɛsa sa nyɛ tuwal myoŋ nɛ mɛsoŋ kɔ ɛsu ɛ tak ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bi ɛ́ endjemet e bot, bot ɛ edhim! Ɛyé di dhaa mɛtaŋ tin, yɛ lɔɔd “ohoo” nɛghu Ndjaa-ebuwa di edjɛ lɔɔd edɛɛ ɛ? ");
INSERT INTO bkw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","«Bi baalɛɛ ɛ́ náá: “Mot ɛ́ tuwal myoŋ nɛ mɛsoŋ kɔ mesa ebuwa ɔɔ, yɛ aanàsa sonok. Nyɛ katuwal myoŋ nɛ mɛsoŋ kɔ buwa di kɔ mesa ebuwa tak ɔɔ, nyɛ goka ɛ́ nɛ ɛsa sa nyɛ tuwal myoŋ nɛ mɛsoŋ kɔ ɛsu ɛ tak ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Biyɔ bot ɛ edhim! Ɛyé di dhaa mɛtaŋ tin, ɛsa e buwa “ohoo” nɛghu mesa ebuwa bɛ di eka gha kɔ tak ɛ? ");
INSERT INTO bkw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yɛ bɛ náá, mot eetuwal myoŋ nɛ mɛsoŋ kɔ mesa ebuwa ɔɔ, nyɛ tuwal yɛ ɛ́ kɔ mesa ebuwa dɔɔ nɛ kɔ esa e buwa ee di kaaa kɔ mesa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mot ɛ́ di etuwal myoŋ nɛ mɛsoŋ mɛ kɔ Ndjaa-ebuwa ɔɔ, nyɛ tuwal myoŋ nɛ mɛsoŋ mɛ tak ɛ́ dɔɔ nɛ kɔ din ɛ Zɛɛb mot di tɔ ndjaa tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mot di etuwal myoŋ nɛ mɛsoŋ, da nyɛ ɛ́ nɔɔ gwoo dáa tyaasɛs ɔɔ, nyɛ tuwal yɛ ɛ́ kɔ bóó mɛkoozi ɛ Zɛɛb nɛ din ɛ Zɛɛb, mot di kɔ tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi dyeebakwyɛl ɛ́ ɛtuud Zɛɛb nɛ endiyal kam e nadjeebe nɛ eka e na mbɛɛ mɛnuub zɛnɔɔ aghomkɔtɔ. Tin, bi kadjisa ɛ́ etɛtɛ mɛlyo mɛ di nɛ boo mɛsuk tɔ etsi ɛ. Mɛlyo mɛ tak ɛ́: epiki, enɛm esa, nɛ ɛkɛ dáa Zɛɛb di ekwyɛl ɛ. Yenek djas ɛ́ sa di egoka náá, bot du mɛlu djas nɛ zii, ààbet dhiiti sonok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Biyɔ, bɛdjɛɛdel, bot ɛ edhim! Bi ɛpesyal mɛnyok men ekaab náá, ba mɔɔ kuŋ ɛ́ zɛkɛdhaa tɔ tak, ghuna bi ɛpemin boo tu yaaga kyee dik bɛsyɛ di ààbɛ nɛ mɛdii ɛ! ");
INSERT INTO bkw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi gwyii ɛ́ koŋ bɛɛlɛ nɛ koŋ saan, tin pɛ tɔ mɔ tak kadi ɛ́ “tɔɔɔ” nɛ mendi mɛ embee mɛfulu men: esa e djii nɛ embee mɛkwosak men. ");
INSERT INTO bkw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Biyɔ eFalizyɛ, bot ɛ edhim! Pookogwyiika sok tɔ mɔ bɛɛlɛ. Tin, pɛ koŋ tak ɛ waadjhaazal. ");
INSERT INTO bkw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi ɛ́ dáa mɛvit nasumaa ɛnyɔɛpe da ɛ́ lɔɔbaa ɛpyaab ɛ. Enɛm e tak nyen ɛ́ pɛ kel é mis mɛ bot, ghuna tɔ tak, ye ɛ́ ɛbyok ɛ egwyes ààbɛ nɛ tsik nɛ ebet esonok. ");
INSERT INTO bkw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye ɛ́ dáa biyɔ, bot ɛ di ebee bin ɔ, bɛ ke ɛ́ náá, bi ɛ́ bot ɛ epiki. Ghuna pɛ tɔ len, ye ɛ́ “tɔɔɔ” nɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si nɛ embee esesɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Haa kpaa-ghoŋ nɛ nen, biyɔ bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Bi ɛpesum embɛɛ mɛvit étɛp bɛngoolel ɛ mɛkpa ɛ Zɛɛb. Bi ɛpekoobal nɛ ɛsɔn ɛ mɛvit mɛ bot ɛ epiki. ");
INSERT INTO bkw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bi dyeebake ɛ́ náá: “Mena ɛpedi ɛ́, dika é ghɛŋ bɛbhaab binaka ɔɔ, pe mena nabɛ ɛ́ ààgwakel nɛ nɔɔ étɛp ɛgó ɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb.” ");
INSERT INTO bkw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Deenek, bi ɛpemyaal biyɔ bɛmet náá, bot ɛ nadi egó bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɔ nabɛ ɛ́ bɛbhaab bin. ");
INSERT INTO bkw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ɛbɛsɛɛ'enek tsabidibila, belaka, duka ko bɛbhaab bin nalik bin yɛ ɛ. Silalka mɛsa mɛ bɛ nakan ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bɛnyɔ, mbyak mɛgel! Bi aasa dáa étɛp bi needi ààkɛdyak tɔ du na kɔm-kɔm? ");
INSERT INTO bkw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","«Gwakeka mɛ ɛnyɔɛpe: mɛ waadhis bin bɛngoolel ɛ mɛkpa ɛ Zɛɛb, bɛtsoŋ ɛ bot, nɛ embɛɛ bɛghaŋ ɛ mɛkana mɛ etsi. Bi ɛ́ waagó bɛdhiiti, bi ɛ́ waabem bɛdhiiti tak é mɛlaaba. Bi ɛ́ waabi bɛdhiiti nɛ eghwyɛs tɔ mendjaa mɛ mendjaala mɛ eYuda men. Bi ɛ́ waadu bɛ nɛ swaka eghaada nɛ eghaada étɛp bi neegó bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tinaak, guka náá, ɛbiyo djas bot di esa kɔ bot ɛ epiki kana ɛsyee ɛ Abhɛl mot epiki, kɛyaka nɛ yɛ Zakali mɔn Balakyi bi nagó pak Di na Dɛɛ ɛ Ghɛŋ nɛ mesa-ebuwa ɔ, yɛ waabulelaa kɔ len. ");
INSERT INTO bkw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, efute e embee esesɛɛ binek ɛ́ waabulelaa kɔ bot ɛ di é dwoo mena dika mos'aak.» ");
INSERT INTO bkw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Yeluzalɛm! Yeluzalɛm wɔy mot di egó bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɔ, wɔy mot di egó bot ɛ Zɛɛb di edhis ɔ, nɛ mɛkok. É sok edhen mɛ di ekwyɛl ɛsɛɛg bot ɛ di kɔ dɛl ɛ lɔ dáa nabwa-kuu di esɛɛg bɔn bɛ si mɛbhap mɛ ɛ, biyɔ ààkwyɛl! ");
INSERT INTO bkw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Deenek guka náá, ndjaŋ'en ɛ́ waalik wum! ");
INSERT INTO bkw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá, bi aanàkabaabee mɛ, kana dwoo pan mos'ak, kɛyaka nɛ dwoo bi aake náá: “Mɛnyɔ nɛ mot aazyɛ nɛ din ɛ Ghɛŋ ɔ!”» ");
INSERT INTO bkw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dáa Yezu nadi ewyis tɔ Ndjaa-ebuwa ɛ́, bɛdjekel eezɛtiila pɛ daa lɛ étɛp bɛ neelyaal nyɛ zumal Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tin, Yezu moo zɛlii nɛ nɔɔ, nyɛy nɛ nɔɔ náá: «Bi ɛpebee esa djas di tin ɛ? Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, ɛkok wat aanàkwaalik yak kɔ yii. Djas ɛ́ waawaazel.» ");
INSERT INTO bkw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yezu eezɛdisi kɔ ɛtsok ɛ pyeeb oliv, bɛdjekel eezɛdu nyɛ é ngwoob. Bɔɔ nɛ nɛ náá: «Lɛɛa bis esesɛɛ binek sael den? Lyaala bis endem e bis aagu náá, wɔ moo ɛ́ kɔ ɛbula nɛ náá, bɔs moo ɛ́ kɔ ɛsi ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Dika nɛ etsoŋ, sa mot ààkɔɔ bin. ");
INSERT INTO bkw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Etɛɛ náá, bɛtɛ nɛ bot ɛ́ waazyɛ nɛ din ɛ lam. Bɛ waalɛɛ bin náá: “Ye ɛ́ mam ɛ́ di Mɛsia!” Bɛ waasa náá, bot ɛbuɛpe kat ɛdum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bi ɛ́ waagwak bot elii etɛp e mɛɛb é ngwoob'en nɛ menduk mɛ mɛɛb mɛ di pɛ ɛtseta ɛ. Sa mot ààbem ba etɛɛ náá, ye goka ɛ́, esesɛɛ binek sɛ́ɛ. Tin, guka náá, yenek tok mɛsi mɛ bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dhiiti mbyak ɛ́ waaghɛɛ, kɛlumela dɛɛb nɛ yak mbyak. Dhiiti ɛyoŋ ɛ́ waakɛghɛɛ, kɛlumela dɛɛb nɛ yak ɛyoŋ. É bɛdhiiti edi, bɔs ɛ́ waakuu, pwom edee ɛ́ waani kɔ mɛl. ");
INSERT INTO bkw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mɛzel menek djas aadi ɛ́ dáa endem e mɛkɛn ɛsuula ɛbyel ɛ mɔn. ");
INSERT INTO bkw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bot ɛ́ waakɛpit bin, étɛp bi neezukaa. Tin bot ɛ́ waagó bin. Membyak djas ɛ́ waabhina bin kɔ ɛsu ɛ lam. ");
INSERT INTO bkw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","É sok'enek, bot ɛbuɛpe ɛ́ waakat ɛdum koŋ nɛ Zɛɛb. Bot ɛ́ waapitel pak'ɔɔ. Bɛdhiiti ɛ́ waabhina bɛsɔ bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bɛtɛ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ ɛ́ waatuula, bɛ waakɔɔ bot ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dáa ye di náá, embee esa ɛ́ waazɛdhaa tɔ elyem e bot ɛ, kwyɛl tɔ elyem e bot ɛbuɛpe waatyaala. ");
INSERT INTO bkw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tin, mot aakɛ nɛ ɛwa zii, kɛkum pɛ ɛsik ɔ, nyɛ waabela tsik. ");
INSERT INTO bkw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mbɛɛ Bhaadal dum nɛ Ɛyoŋ ɛ Zɛɛb aadi ɛ́ egoolel kɔ ɛko ɛ bɔs'ak djas, étɛp, bot djas di ààgu Zɛɛb ɔ neegwak yɛ. Bhii tak ɛ ɛsik ɛ bɔs aakakum.» ");
INSERT INTO bkw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Bi aabee mot na mbee mesyem mɛ na lyel-lyel dáa ngoolel-mɛkpa ɛ Zɛɛb Daniel nalɛɛ ɛ, nyɛy ebe di tɔ Di na Dɛɛ. Ye goka ɛ́ bot ɛ di egu ɛlaa mɛkana ɔ tiibal ɛnyɔɛpe! ");
INSERT INTO bkw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Étɛp tak ɛ́ di náá, bot aadi pɛ kyee dik Yude ɔ, kan ekaab, tɔ́ pɛ tɔ mɛtsok. ");
INSERT INTO bkw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mot aadi kɔ mii ndjaŋ'ɛ ɔ nàbaasul pɛ si zɛni tɔ ndjaa étɛp ɛkɛnɔɔ sonok. ");
INSERT INTO bkw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mot aadi tɔ pyeeb ɔ, nàbaasik pɛ dɛl, kɛnɔɔ ndjookuwa yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Haa kpaa-ghoŋ dwoo ɛlenek nɛ boa aadi nɛ mɛbum ɔ, zɛnɔɔ boa aadi nɛ bɔn edɛ mɛbel ɔ! ");
INSERT INTO bkw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Djaalaka nɛ Zɛɛb étɛp, bi ɛ́ zɛkɛwyis ekaab é mbu bɛbhi, nɛghu é dwoo saba! ");
INSERT INTO bkw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Etɛɛ náá, é ɛwala tak, mezuk ɛ́ waadhaa mezuk mɛ mena zebee, kana bɔs nakusel ɛ, kɛyaka nɛ dwoo pan mos'ak. Yɛ aanàkwaakabaabɛ nɛ mbi mezuk deenek. ");
INSERT INTO bkw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Zɛɛb nyɛ ɛmet ɛpedi ààbɛk bim mɛlu mɛ tak ɔɔ, pe ye tok nɛ mot aatsak. Ye nyɔ ɛ́, bi gu náá, Zɛɛb bɛk bim mɛlu mɛ mezuk menek ɛ́, kɔ ɛsu ɛ bot ɛ nyɛ nazɛsɛ́ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dhiiti mot ɛ́ lɛɛ bin náá: “Beeka Mɛsia di wak e!” nɛghu bɛ lɛɛ náá: “Mɛsia ɛ́ poon!” ɔɔ, sa mot ààmyaal. ");
INSERT INTO bkw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Etɛɛ náá, bɛmɛsia mɛ etsal nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ ɛ́ waatuula ɛbuɛpe. Bɛ waasa etɛp e mɛbwala nɛ bɛmɛvyɛkɛlɛ ɛbuɛpe étɛp bɛ neekɔɔ bot, dɔɔ nɛ bot ɛ Zɛɛb nazesɛ́ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gwakeka, mɛ dul bin mɛlɔ ɛsok nɛ esesɛɛ binek kum tɔ len. ");
INSERT INTO bkw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Yɛ bɛ náá, bɛ lɛɛ bin ɛ́ náá: “Beeka, nyɛ ɛ́ pɛ tɔ kyee dik bɛsyɛ di ààbɛ nɛ mɛdii!” ɛ, nàtɔ́ka. Nɛghu bɛ kalɛɛ bin ɛ́ náá: “Beeka, yɛ sɔwa ɛ́ wak!” Sa mot ààmyaal, nyɛ tok tin. ");
INSERT INTO bkw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Dáa ngwyes di ekas tɔ gwoo, dus pɛ ɛdjem ɛ dwoo, kɛtɔ́ pɛ ɛbil ɛ dwoo ɛ, Sɛɛŋɛlɛ Mɔn Mot aazyɛ ɛ́ deenek. ");
INSERT INTO bkw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Enen ee di edɛ epuud ɔ dyeebasɛɛga ɛ́ é di muu tit di ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Ààbɔya batsa bhii ɛwala ɛ mezuk menek aadhaŋ ɛ, bi ɛ́ waabee náá, gwyes ɛ́ waagwyiid dhɔɔ, ngɔn aanàkabaakas, ekwyikwyen ɛ́ waadus tɔ gwoo, kwyit é bɔs, esa e mɛbwala djas di tɔ gwoo ɛ waadheegel. ");
INSERT INTO bkw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tin, ndem ɛ Sɛɛŋɛlɛ Mɔn Mot ɛ́ waanyen tɔ gwoo. Membyak djas di kɔ bɔs ɛ, yɛ aadi ɛ́, tɔ etsim nɛ mɛgwyɛ. Tin, bɛ waabee Sɛɛŋɛlɛ Mɔn Mot esul tɔ eguud tɔ gwoo nɛ bɛtɛ nɛ mɛbwala nɛ duma. ");
INSERT INTO bkw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Boo tɔŋ ɛ́ waalɔɔel. Tin, nyɛ waalwom efofop pɛ é edum e bɔs djas, bɛ neekɛsɛɛg bot djas Zɛɛb nazesɛ́ɛ ɔ, kan yak edum e bɔs, kɛyaka nɛ yak edum.» ");
INSERT INTO bkw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Nɔɔka etsoŋ nɛ kana le fiigh: dáa mɛdii mɛ le fiigh aadi, ye moo byet tɔ elɛɛ e tak ɛ, eka moo baakwyil é tak ɛ, bi nɛ gu náá, mbɛɛ mbu eezekunaa. ");
INSERT INTO bkw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ye ɛ́ tyɛ wat nɛ biyɔ, é sok bi aabee endem binek moo nyen ɛ, guka náá, ɛbula ɛ Sɛɛŋɛlɛ Mɔn Mot moo ɛ́, yɛ eezekɔ. Yɛ aasael ɛ́ deenek. ");
INSERT INTO bkw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, bot ɛ membu mak aanàkwaagwyɛ djas esonok bak ààsael. ");
INSERT INTO bkw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gwoo nɛ bɔs ɛ́ waadhaa, ye ɛ́ kabɛ mɛkpa ɛ Zɛɛb ɔ, yɛ aanàkwaadhaa.» ");
INSERT INTO bkw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Yɛ kabɛ dum nɛ dwoo nɛ ɛwala ɛ esesɛɛ binek aasael ɛ, ye tok nɛ mot ngɔt di egu, ààkobɛ-bɛak efofop tɔ gwoo, dɔɔ nɛ Mɔn Zɛɛb pe ààgu dwoo tak. Ye ɛ́ Sɛɛg nyɛ ɛmet ɛ di gu. ");
INSERT INTO bkw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ɛbula ɛ Sɛɛŋɛlɛ Mɔn Mot aadi ɛ́, dáa sa nasɛ́ɛ é ghɛŋ Noe ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Etɛɛ náá, é ghɛŋ tak, ɛsok nɛ boo bhyoŋ nɛ zyɛ, bot nadi ɛ́, tɔ mɛmyaala, edɛ edee, edɛ bɛmɛnyok, eba boa, ekyeed mɛsyes mɔɔ é mɛba, kɛkum dwoo Noe nani tɔ mɛsuwa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bot nabɛ ɛ́ ààbis, kɛkum dwoo boo bhyoŋ nazɛsilal bɔɔ djas na “bhɛɛɛ” ɛ. Yɛ aabaadi ɛ́, deenek dwoo Sɛɛŋɛlɛ Mɔn Mot aabula ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","É ghɛŋ tak ɛ́ di náá, bot ɛbá ɛ́ waadi tɔ pyeeb. Ngɔt ɛ́ waanɔŋaa, nwyak ngɔt ɛ́ waalik. ");
INSERT INTO bkw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Boa ɛbá ɛ́ waadi edum bhum tɔ bwak wat. Ngɔt ɛ́ waanɔŋaa, nwyak ngɔt ɛ́ waalik. ");
INSERT INTO bkw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«Dika nɛ etsoŋ! Bɛɛka mis etɛɛ náá, bi ààgu dwoo Ghɛŋ'en aaboozyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gwakeka sa mɛ di elɛɛ ɛ́, yɛ bɛ náá, nakuma ndjaŋ ɛpedi egu ɛwala ɛ pum mot djii aazyɛ zɛdjii tɔ ndjaŋ'ɛ ɔɔ, pe nyɛ aanàkwaadja gɔ́, étɛp nyɛ neelu mot djii yenɔk, nyɛ nàni tɔ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ye ɛ́ mɛ di elɛɛ bin náá, bi bɛ ɛ́ mis, nàpeebaka, etɛɛ náá, Sɛɛŋɛlɛ Mɔn Mot aatuula ɛ́ é ɛwala bi aadi ààbwood nyɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ɛzɛ di mot-mɛsa mɛ na sosoob nɛ etsoŋ? Ye ɛ́ mot-mɛsa kukuma yɛ djɛ nyɛ mɛsa mɛ ɛbaal ɛ bɛsɔ nɛ ɛdjɛ bɛ edee bɔɔ é ɛwala bɛ di egoka nɛ ɛdɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mɛnyɔ nɛ mot-mɛsa menɔk, yɛ bɛ náá, kukuma yɛ aabula, nyɛ ɛ́ zɛbela nyɛ, nyɛy esa mɛsa mɛ menek ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá: kukuma yenɔk ɛ́ waadjɛ mot-mɛsa menɔk esa bɛ djas nyɛ baal. ");
INSERT INTO bkw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yɛ kabɛ náá, nyɛ ɛ́ mbee mot-mɛsa di ààbɛ sosoob nɛ etsoŋ ɔɔ, nyɛ aake ɛ́ náá: “Kukuma aanàkwaaleebula.” ");
INSERT INTO bkw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Deenek, nyɛ aadi ɛ́, ezuk bɛsɔ di esa mɛsa bɛ nɛ bɛ nɔɔ ɔ, nɛ ɛkɛdedɛ bɛ mɛnyok bɛ nɛ bot ɛ zegel mɛnyel mɔɔ tɔ mɛnyok ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tin, kukuma yɛ aabula ɛ é dwoo nyɛ aadi ebwaal náá, nyɛ aanàkwaazyɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kukuma yenɔk ɛ́ waasɔ mot-mɛsa menɔk. Da nyɛ ɛ́ wa nyɛ é di mezuk, é di wat nɛ bot ɛ lwalɛŋ. Bhii tak nyɛ ɛ́ wus nyɛ pɛ kel pɛ bot ɛ di edje mɛgwyɛ nɛ ɛkwaal ɛ mɛtsok di ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ɛni tɔ Ɛyoŋ ɛ di tɔ gwoo ɛ́ aadi ɛ́, dáa kana mɛsyes kam nanɔɔ elama bɔɔ, wyis, étɛp bɛ neekɛboma nɛ motom di ekwyɛl ɛba ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bɛtɛn pak'ɔɔ nadi ɛ́, endjemet e mɛsyes. Bak bɛtɛn kadi ɛ́ bɛtsoŋ ɛ bɔɔ boa. ");
INSERT INTO bkw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Endjemet e mɛsyes menɔk nanɔɔ yɔbɔ elama ɛ́, àànɔɔ ba mul, nɛ gu yii di tɔ elama ɛ́ waasi. ");
INSERT INTO bkw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yɛ kabɛ bot ɛ nadi bɛtsoŋ ɔ, bhii bɛ nanɔɔ elama ɛ, ye nabɛ ɛ́ bɛ naatɔ́ nɛ yak bim bɛmul bɛ nakwom ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tin, motom kadi ɛ́, ààleetuula. Gɔ́ naazɛsa bɔɔ mɛsyes menɔk, wɔ gwaa, bɔɔ djas zɛkpaa nɛ gɔ́ ndjaasi. ");
INSERT INTO bkw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«É di'enek, wɔ gwaa, boo tuud zokazɛgék kuku ɛgha ɛ pum náá: “Beeka motom ɛba! Kɛbomaka nɛ nɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tin mɛsyes kam menɔk ɛ́ boozɛdjem, bɛ moo tin ekoobal elama bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tin, mɛsyes mɛ nadi endjemet ɔ naazɛke nɛ bɛtsoŋ náá: “Bi ɛ́ nɛ ghwyil ɛbɛk bis ba mul mɛ lama batsa, etɛɛ náá, elama bis ɛpedim.” ");
INSERT INTO bkw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mɛsyes mɛ nadi bɛtsoŋ ɔ ɛ́ boobɔɔza nɛ nɔɔ náá: “Hooo, ààbɛ! Etɛɛ náá, bim bis di nɛ yɛ ɛ, yɛ aanàkwaadjala menabɛlka djas. Ye nyɔ ɛ́, bi kɛbɔm yebɔ tɔ edjando.” ");
INSERT INTO bkw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tin, endjemet e bɔɔ mɛsyes menɔk eezɛtɔ́, kɛbɔm yɔbɔ bɛmul. Bhii koŋ'ɔɔ, motom ɛba eezɛkum, nyɛ zokanɔŋ ɛ́ bɛtɛn ɛ nadi bɛtsoŋ ɔ. Nyɛ ɛ́ boozɛni nɛ nɔɔ tɔ ndjaa nakoobelaa étɛp ɛba ɛ. Bhii tak, bɛ eezɛkɔɔl ɛbɛ ɛ ndjaa nɛ ɛngoŋ. ");
INSERT INTO bkw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bhii ba ɛwala kadhaŋ ɛ, bɛdhiiti bɔɔ mɛsyes menɔk eezɛbula, bɛ moo tin etsim náá: “Ghɛŋ, Ghɛŋ diia bis ɛbɛ ɛ ndjaa!” ");
INSERT INTO bkw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Motom ɛba eezɛbɔɔza nɛ nɔɔ náá: “Mɛ lɛɛ bin nɛ tsɛɛtsɛ ɛ́ náá, mɛ ààgu bin.”» ");
INSERT INTO bkw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bhii tak, Yezu eebaazɛke nɛ nɔɔ náá: «Bɛɛka mis, nàdjaka egɔ́. Dika nɛ etsoŋ etɛɛ náá, bi ààgu dwoo nɛ ɛwala ɛ tak.» ");
INSERT INTO bkw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Yɛ aadi ɛ́, dáa dhiiti motom nadi ekwyɛl ɛtɔ́ mɛdjoŋ, nyɛ ɛ́ boozɛdjóo bot ɛ mɛsa mɛ, da ɛ́ lik bɛ nɛ esa. ");
INSERT INTO bkw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nyɛ ɛ́ boozɛnɔɔ mɛdhɛɛb mɛ lɔɔd ɛtɛn, djɛ mot mɛkɛn. Mot nabɔɔba ɔ, nyɛ kadjɛ nyɛ ɛ́ mɛdhɛɛb mɛ elɔɔd ebá. Mot nazyɛ bhii mot bhɔɔba ɔ, nyɛ kadjɛ nyɛy ɛ́ ɛdhɛɛb lɔɔd wat. Nyɛ zokadjɛ mot nɛ mot ɛ sa di edjala nɛ ghwyil'ɛ ɛ, bhii tak nyɛ eezɛtɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mot-mɛsa nabela mɛdhɛɛb mɛ lɔɔd ɛtɛn eezɛtɔ́, yɛ kɛliig mɛmbɔ nɛ lɔɔd'enek. Wɔ gwaa nyɛ baazɛbela mɛdhɛɛb mɛ lɔɔd ɛtɛn kɔ yii nyɛ nadjɛaa sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ye ɛ́ tyɛ wat nɛ mot nabela mɛdhɛɛb mɛmbá ɔ, nyɛ nabaasa yɛ ɛ́ dáa mot ɛsok nasa ɛ. Wɔ gwaa, nyɛ baabela mɛdhɛɛb mɛ lɔɔd membá kɔ yii nyɛ nalikaa nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mot nabela ɛdhɛɛb ɛ lɔɔd wat ɔ, nyɛ naatɔ́ kɛpu bɔs, da ɛ́ nɔɔ yɛ, syel yɛ pɛ si bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Bɛtɛ nɛ mɛlu bhii tak, kukuma bot ɛ mɛsa menɔk eezɛbula. Bhii tak nyɛ moo zɛdji bɛ dáa bɛ nadi ebe lɔɔd nyɛ nalik bɛ nɛ yɛ ɛ bhii koŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mot-mɛsa na mɛdhɛɛb mɛtɛn ɛ́ boozɛlyaal yɛ mɛdhɛɛb mɛtɛn mɛ nyɛ nabaabela ɛ. Nyɛy nɛ kukuma yɛ náá: “Ghɛŋ, wɔ nadjɛ mɛ ɛ́ mɛdhɛɛb mɛ lɔɔd mɛtɛn. Beea dhiiti mɛdhɛɛb mɛ lɔɔd mɛtɛn mɛ mɛ baabela ɛ́.” ");
INSERT INTO bkw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kukuma yɛ ɛ́ booke nɛ nɛ náá: “Ɛnyɔɛpe! Wɔ ɛ́ mbɛɛ mot-mɛsa nɛ esosoob. Wɔ eesa mbɛɛ mɛsa nɛ sa dem. Mɛ waadjɛ wɔ yii di bu ɛ. Dha myaala é di wat nɛ nam.” ");
INSERT INTO bkw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mot-mɛsa nabela mɛdhɛɛb mɛ lɔɔd ebá ɔ, baazyɛ yɛ. Nyɛy náá: “Ghɛŋ, wɔ nadjɛ mɛ ɛ́ mɛdhɛɛb mɛ lɔɔd ebá. Mam eebaabela yak mɛdhɛɛb membá kɔ tak. Beea yɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tin, kukuma yɛ eezɛke nɛ nɛ náá: “Ɛnyɔɛpe! Wɔ ɛ́ mbɛɛ mot-mɛsa nɛ esosoob. Wɔ eesa mbɛɛ mɛsa nɛ sa dem. Mɛ waadjɛ wɔ yii di bu ɛ. Dha myaala é di wat nɛ nam.” ");
INSERT INTO bkw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Bhii tak, mot nabela ɛdhɛɛb ɛ wat ɔ, nyɛ eezɛzyɛ é yɛ kɔkɔ. Nyɛ nɛ kukuma náá: “Ghɛŋ, mɛ nɛ gu náá, wɔy nɛ goo lo dhaa nyel. Wɔ dyeebakɛnɔɔ edee ɛ́ tɔ epyeeb ee wɔ di ààbɛ ɛ. Wɔ dyeebakɛbɔ́k bhum ɛ́, tɔ pyeeb wɔ nadi ààbɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","É tɛp tak ɛ́ mɛ gwak bwoo. Mɛ ɛ́ bookɛsyel lɔɔd'ɔ tɔ bɔs. Beea lɔɔd'ɔ, nɔŋa.” ");
INSERT INTO bkw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","É di'enek, kukuma ye ɛ́ boobɔɔza nɛ nɛ náá: “Mbee mot-mɛsa, tyaabel. Wɔ ke ɛ́ náá, wɔ nɛ gu náá, mam dyeebakɛnɔɔ esa e dɛk ɛ́ tɔ pyeeb mɛ di ààmwam bhek ɛ. Mɛ kɛbɔ́k bhum ɛ́ tɔ pyeeb mɛ nadi ààbɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Gwaka mɛ, wɔ di àànɔɔ lɔɔd'am, kɛwa tɔ eboo mendjaa mɛ bɛ di ebaal epata e bot ɛ, étɛp yé? Wɔy ɛpedi ɛ́, di tsoŋ mot ɔɔ, pe bula mɛ bula ɛ, mɛ kazɛbela ɛ́ dhiiti lɔɔd eezekala kɔ yii mɛ nalik ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Dɛkeka nyɛ ɛdhɛɛb ɛ lɔɔd'enek, da bi ɛ́ djɛ mot di nɛ mɛdhɛɛb kam ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Etɛɛ náá, mot aadi nɛ ba bim sonok ɔ, bɛ waabil nyɛ dhiiti, étɛp ye neebu. Tin, mot aakadi toto ààbɛ nɛ sonok ɔ, bɛ waadɛk nyɛ dɔɔ nɛ eghutu-ghutu nyɛ lik nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Yɛ kabɛ mbee mot-mɛsa mak ɔ, zyeegalka nyɛ pɛ kel, tɔ ghooghom, tɔ di mɛgwyɛ nɛ di ɛkwaal ɛ mɛtsok.”» ");
INSERT INTO bkw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«É sok Sɛɛŋɛlɛ Mɔn Mot aazyɛ tɔ duma yɛ bɛ nɛ efofop bɛ djas ɛ, nyɛ waazɛdisi kɔ bóó mɛkoozi mɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Membyak djas di kɔ bɔs ɛ́ waazɛsɛɛga sok bhwoob'ɛ, bhii tak nyɛ waawa membɛk pak bot dáa mbaalel mɛsaa di ewa mbɛk pak ebhata nɛ etaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nyɛ waanɛɛg ebhata pɛ mbɔ eghɛŋ, etaa pɛ mbɔ ɛmyɛl. ");
INSERT INTO bkw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tin, mɛkoozi waalɛɛ nɛ bot aadi pɛ mbɔ eghɛŋ ɔ náá: “Biyɔ, bot ɛ Saag'am zesɛɛ mɛtel ɔ, dhaka pɛ kak. Dhanika tɔ Ɛyoŋ ɛ Zɛɛb naloozekoobal bin yɛ é sok nyɛ nadi ekus bɔs ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Etɛɛ náá, za naasa mɛ, bi naadjɛ mɛ edee. Mɛ naagwak gwyes mɛdii, bi naadjɛ mɛ mɛdii. Mɛ nadi ɛ́ ndjoŋ, bi naamyaal mɛ tɔ mendjaa men dáa mɔn nyɛɛg'en. ");
INSERT INTO bkw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mɛ nadi ɛ́ ben toto, bi naabet mɛ. Mɛ naabɛ́, bi naagwom mɛ. Mɛ naani membok, bi naazyɛ zɛbee mɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Deenek bot ɛ nakɛ tɔ epiki ɔ aabɔɔza nɛ nɛ náá: “Ghɛŋ! Yaa dwoo bis nabee wɔ nɛ za, da bis ɛ́ djɛ wɔ edee? Yaa dwoo wɔ nadi nɛ gwyes mɛdii, da bis ɛ́ djɛ wɔ mɛdii? ");
INSERT INTO bkw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yaa dwoo wɔ nadi ndjoŋ, da bis ɛ́ djɛ wɔ di tɔ mendjaa mes? Yaa dwoo wɔ nadi ben toto, da bis ɛ́ bet wɔ? ");
INSERT INTO bkw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yaa dwoo wɔ nadi ebɛ́, da bis ɛ́ zyɛ, zɛgwyák wɔ? Yaa dwoo wɔ nadi é membok, da bis ɛ́ zyɛ zɛbee wɔ?” ");
INSERT INTO bkw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mɛkoozi kabɔɔza ɛ́ náá: “Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, esonok djas bi di esa nɛ mot mɛsik tɔ bɔɔ nyaag'am ɛ, bi sa mbɛɛ esa binek ɛ́ nɛ nam.” ");
INSERT INTO bkw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Bhii tak, kukuma ɛ́ waake nɛ bot aadi pɛ mbɔ ɛmyɛl ɔ náá: “Duska mɛ é mis. Tɔ́ka ɛtsetaɛpe nɛ nam, biyɔ, bot ɛ Zɛɛb zelek ɛbiyoɛpe ɔ. Tɔ́ka tɔ du di ààdim ɛ. Ye nakoobelaa ɛ́, étɛp Dim mot mɛkɔŋ bɛ nɛ efofop bɛ! ");
INSERT INTO bkw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Etɛɛ náá, mɛ nabɛ ɛ́ nɛ za, bi nabɛ ɛ́ ààdjɛ mɛ edee. Mɛ naagwak gwyes mɛdii, bi nabɛ ɛ́ ààdjɛ mɛ mɛdii. ");
INSERT INTO bkw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mɛ nadi ɛ́ ndjoŋ, bi nabɛ ɛ́ ààdjɛ mɛ di tɔ mendjaa men. Mɛ nadi ɛ́ ben toto, bi nabɛ ɛ́ ààbet mɛ kaad. Mɛ nadi ebɛ́, bi nabɛ ɛ́ ààgwom mɛ. Mɛ naani mbok, bi nabɛ ɛ́ ààzɛgwyak mɛ.” ");
INSERT INTO bkw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Wɔ gwaa, bɛ zɛbɔɔza náá: “Ghɛŋ, yaa dwoo bis nabee wɔ nɛ za, nɛ gwyes mɛdii, nɛ nɛghu ndjoŋ? Yaa dwoo bis nabee wɔ ben toto, wɔy ebɛ́, nɛghu wɔy é membok, da bis ɛ́ kadi ààkyee wɔ?” ");
INSERT INTO bkw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kukuma ɛ́ boozɛbɔɔza nɛ nɔɔ náá: “Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, esok djas bi nadi ààsa esonok binek nɛ mot mɛsik tɔ bɔn nyaag'am ɛ, bi nadi ààsa yɛ ɛ nɛ nam.” ");
INSERT INTO bkw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bɛ waatɔ́, kɛbee mɛsuk na kɔm-kɔm. Yɛ kabɛ bot ɛ epiki ɔ, bɛ waabela tsik na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bhii Yezu nasilal mɛlyo mɛ djas ɛ, nyɛ naazɛke nɛ bɛdjekel bɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Bi nɛ gu náá, ye kalik ɛ́ mɛlu mɛmbá, etɛɛ náá, ɛbyoŋ ɛ Pak neesael. Sɛɛŋɛlɛ Mɔn Mot ɛ́ waaseebaa, étɛp nyɛ neekɛbemaa kɔ mɛlaaba.» ");
INSERT INTO bkw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tin, eboo bɛghaa-Zɛɛb nɛ bɛpaa ɛ eYuda naazɛsɛɛga tɔ ndjaa mɛkoozi Kayif, mot nadi boo ghaa-Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Wɔ gwaa, bɔɔ djas zokazɛgwakel náá, bɛ mɛt Yezu tɔ syaab, bhii tak, da bɛ ɛ́ gó nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bɛ nadi eke ɛ́ náá: «Sa mena ààmɛtka nyɛ dwoo ɛbyoŋ ɛ Pak, é kaab náá, bot ɛ́ zɛkɛkpaa elyem, da bɛ ɛ́ sa ɛzɛm.» ");
INSERT INTO bkw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Dáa Yezu nadi pɛ Bhetani tɔ ndjaŋ ɛ Simɔŋ mot na ɛbɛ́ ɛ zezam ɛ, ");
INSERT INTO bkw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wɔ gwaa, dhiiti moma zɛni tɔ ndjaa tak zeza nɛ di Yezu nadi ɛ́. Nyɛ nadi ɛ́, nɛ bɛɛb nasael nɛ ɛkok ɛ albat ɛ «tɔɔɔ» nɛ mɛnanas di nɛ boo mɛtaŋ ɛ. Moma tak zokazɛso mɛnanas menek kɔ lo ɛ Yezu é sok bɛ nadi kɔ mesa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dáa bɛdjekel bɛ nabee deenek ɛ́, ye nabɛ ɛ́, ye nakpaa bɛ elyem. Bɔɔ náá: «Yak ɛ́ yaa kwaambi puluk? ");
INSERT INTO bkw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ɛnyɔ ɛ́ náá, bɛ bɔmsa mɛnanas mɛ tak nɛ boo mɛtaŋ, da ɛ́ nɔɔ epata e tak, djɛ nɛ bɛdjel ɛ bot!» ");
INSERT INTO bkw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ye nabɛ ɛ́ Yezu naagu sa bɛ nadi enyiŋela pak'ɔɔ ɛ. Nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Betka moma yak gwyem. Étɛp yé bi di ezɛm nyɛ? Sa nyɛ sa kɔ ɛsu ɛ lam ɛ, ye ɛ́ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yɛ bɛ étɛp bɛdjel ɛ bot ɔ, bi nɛ bɛ nɔɔ ɛ́ aapaazodi mɛlu djas ɛ é di wat. Yɛ kabɛ mam ɔ, bi aanàdi sama nɛ nam mɛlu djas. ");
INSERT INTO bkw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Moma yak so mɛ mɛnanas é nyel'am ɛ́, étɛp nyɛ neekan ɛkoobal nyel'am e dwoo mɛdela mam. ");
INSERT INTO bkw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, é edi djas Mbɛɛ Bhaadal aadi egoolaa kɔ bɔs ɛ, tseŋa moma yak sa ɛ waakaadaaa mɛdhik nɛ mɛdhik. Tin, bot ɛ waataala enɛm esa nyɛ sa kɔ ɛsu ɛ lam ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tinaak, djekel ngɔt tɔ bɛdjekel kam nɛ bɛbá ɛ Yezu, nadi edjóoaa Yudas Iskaliɔt ɛ, zokazɛtɔ́ pɛ daa eboo bɛghaa-Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nyɛ eezɛdji bɛ náá: «Mam ɛ́ ka bin Yezu ɔɔ, bi kadjɛ mɛ yé é di tak?» Tin, wɔ gwaa, bot ɛ tak zɛwyisal efalanga mɛkam-mɛlɛl e epata, nɔɔ, laa, bhii tak bɛ eezɛdjɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kana tin, Yudas nabɛ ɛ́, nyɛ moo saa mɛpek étɛp nyɛ neeka bɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","É dwoo mɛkɛn mɛ ɛbyoŋ ɛ emapa ee di ààwaaa leviid ɛ, bɛdjekel ɛ Yezu zɛdji nyɛ náá: «Wɔ kwyɛl náá, bis kɛkoobal wɔ di mena aadɛka edee e ɛbyoŋ ɛ Pak wo é?» ");
INSERT INTO bkw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tin, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Tɔ́ka pɛ dɛl, pɛ daa dhiiti mot, da bi ɛ́ lɛɛ nyɛ náá: “Lyoel ke ɛ́ náá: Ɛwala ɛ lam eezekum. Mam nɛ bɛdjekel bam aadɛ ɛbyoŋ ɛ Pak'ak ɛ pɛ tɔ ndjaŋ'ɔ.”» ");
INSERT INTO bkw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tin, bɛdjekel ɛ́ bookɛsa dáa Yezu nalɛɛ bɛ ɛ. Bɔɔ zokazɛkoobal nɛ ɛdjaab edee ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Dáa dwoo nakabɛ, ye moo bikoko ɛ, Yezu eezɛdisi kɔ mesa bɛ nɛ bɛdjekel bɛ kam nɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dáa bɛ nadi kɔ mesa edɛ ɛ, Yezu ɛ́ boozɛke náá: «Mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, ngɔt pak'en ɛ́ waaka mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bɛdjekel djas moo tin nɛ ghoŋ tɔ elyem, bhii tak, ngɔt-ngɔt moo tin ezɛdji nyɛ: «Ghɛŋ, ye ɛ́ mam é?» ");
INSERT INTO bkw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ mot duu mbɔ tɔ saan wat bis nɛ nɛ ɔ aapaaka mɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ye ɛ́ tsɛɛtsɛ, Sɛɛŋɛlɛ Mɔn Mot ɛ́ waagwyɛ dáa ekwyala di elɛɛ kɔ ɛsu ɛ lɛ ɛ. Tinaak, boo ghoŋ nɛ mot aakɛka nyɛ é mɛmbɔ mɛ mbee bot ɔ. Ye nabɛ ààgoka náá, mot'enɔk byel!» ");
INSERT INTO bkw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, mot nadi ekɛka nyɛ gha ɔ ɛ́ boodji náá: «Lyoel, ye kabɛ ɛ́ mam é?» Yezu ɛ́ boozɛbɔɔza nɛ nɛ náá: «Ye ɛ́ wɔ ɛmet ɛ ke deenek». ");
INSERT INTO bkw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dáa bɛ nadi edɛ kɔ mesa ɛ, wɔ gwaa Yezu zɛnɔɔ mapa. Nyɛ eezɛghaapɛɛ Zɛɛb, bhii tak, nyɛ eezɛpyak mapa tak, nɔɔ, djɛ bɛdjekel bɛ. Nyɛy náá: «Nɔɔka yɛ, da bi ɛ́ dɛ, etɛɛ náá, yak ɛ́ nyel'am.» ");
INSERT INTO bkw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bhii tak, nyɛ eezɛnɔɔ bɛɛlɛ nadi nɛ mɛnyok mɛ vin tɔ tak ɛ, nyɛ eezɛbaazɛghaapɛɛ Zɛɛb, nyɛ eezɛke nɛ nɔɔ náá: «Nɔɔka yɛ, da bi ɛ́ dɛ biyɔ djas, ");
INSERT INTO bkw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","etɛɛ náá, yak ɛ́ ghiya yam. Yɛ ɛ́ ghiya di edjɛ bot ze ɛni tɔ ɛbhɛŋ ɛ Zɛɛb ɛ, ghiya nasee kɔ ɛsu ɛ bot ɛbuɛpe étɛp mesyem mɛ bot neepelel ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mɛ lɛɛ bin ɛ́ náá: kana dwoo pan mos'ak, mɛ aanàkabaadɛ mɛnyok mɛ vin, kɛkum dwoo mɛ aakabaakɛdɛ mɛnyok mɛ na bes menabɛlka tɔ Ɛyoŋ ɛ Saag'am ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tin, wɔ gwaa bɛ zɛduwal Zɛɛb tɔ mɛdjeeb. Bhii tak, bɛ eezɛnɔɔ mɛnyel, tɔ́ pɛ ɛtsok ɛ pyeeb oliv. ");
INSERT INTO bkw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tin, Yezu zokake nɛ bɛdjekel bɛ náá: «É pum'ak mos, biyɔ djas ɛ́ waadhuugal mɛ, etɛɛ náá, ekwyala lɛɛ náá: “Mɛ waagó mbaalel ebhata. Tin, ɛsaa djas ɛ́ waawyɛɛza na gwyiiŋ.”» ");
INSERT INTO bkw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yezu eebaazɛbil ɛkpa náá: «Bhii ɛgom ɛ lam, mɛ waatɔ́, kɛbwood bin pɛ Ghalile.» ");
INSERT INTO bkw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pyɛɛd zokake nɛ nɛ náá: «Yɛ bɛ náá, bot djas ɛ́ waakaab wɔ ɔɔ, mam aanàkwaakaab wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tinaak, Yezu kabɔɔza nɛ nɛ ɛ́ náá: «Gwaka, mɛ lɛɛ bin ɛ́ etɛp e tsɛɛtsɛ náá, é pum'ak mos, ɛsok nɛ kuu nɛ kɔk, yɛ aabela ɛ́, wɔ eezelɛɛ nɛ bot esok elɛl náá, wɔ ààgu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pyɛɛd eezɛbɔɔza nɛ Yezu náá: «Mɛ tok nɛ ghwyil ɛke nɛ bot náá, mɛ ààgu wɔ, ye nakoozobɛ ɛsyee, mɛ ɛpemyaal náá, menabɛl bɛbá gwyɛ.» É di'enek, ye nabɛ tin ɛ́, bɛdjekel djas moo ɛkpa wat. ");
INSERT INTO bkw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bhis yenek, Yezu bɛ nɛ bɛdjekel bɛ naazɛkum pɛ di di edjóoaa Ghɛtɛsemani ɛ. É di tak, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Likeka wak. Mɛ pookotiila poon, kɛdjaala Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tin, nyɛ kanɔŋ ɛ́ Pyɛɛd, nɛ bɔn Zɛbɛdɛ bɛbá, tɔ́ nɛ nɔɔ. É di'enek, ye nabɛ ɛ́, keŋ nɛ ghoŋ moo sa nyɛ ɛbuɛpe tɔ lyem. ");
INSERT INTO bkw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nyɛ eezɛke nɛ nɔɔ náá: «Sisim'am ɛ́ tɔ ghoŋ saa-saŋak náá mɛ gwyɛ. Likeka wak dika ndjem sama nɛ nam. Nàdjaka egɔ́, djaalaka Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bhii tak, nyɛ eezɛtiila batsa pɛ sok, zɛkwyit mɛboŋ bhwoob si na «ghɔkɔ», nyɛ moo tin edjaala nɛ Zɛɛb náá: «Saag'am, wɔ kwyɛl ɔɔ, wɔ ɛ́ nɛ ghwyil ɛdis bɛɛlɛ mezuk mak sok bhwoob'am. Ye goka ɛ́ djas sael tɔ ɛkwosak ɛ lɔ, ààkabɛ yam ɛkwosak.» ");
INSERT INTO bkw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bhii tak, nyɛ eezɛsik, tɔ́ pɛ nyɛ lik bɛdjekel bɛ bɛlɛl binɔk ɛ, nyɛ kazɛbela bɛ ɛ́ é gɔ́. Nyɛ ɛ́ boozɛke nɛ Pyɛɛd náá: «Deenek, bi eedja gɔ́! Bi ààpakodi-diak mis membek sama nɛ nam é ɛwala wat é? ");
INSERT INTO bkw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dika ndjem, djaalaka Zɛɛb, etɛɛ náá, bi ɛ́ zɛkɛkwyɛ tɔ mɛbhowal. Sisim ɛ́ ghiŋ, tin, epuud nɛ bu elɛtɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yak kɔkɔ, nyɛ eebaazɛsik pɛ pak nyɛ nadi sok ɛ, nyɛ kadjaala é sok tak ɛ́ dáak: «Saag'am, yɛ kosael náá, bɛɛlɛ mezuk mak dhaa mam ààdɛ yɛ ɔɔ, ye goka ɛ́ náá, ɛkwosak ɛ lɔ sael.» ");
INSERT INTO bkw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yezu eebaazɛbula pɛ nyɛ nalik bɛdjekel bɛ ɛ, nyɛ kabaazobela bɛ é egɔ́, etɛɛ náá, mis mɔɔ nadi ɛ́ ɛdilɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yak sok, Yezu eebaazɛlik bɛ, zɛbaasik, nyɛ eezɛtseta nɛ nɔɔ. Ye nabɛ ɛ́, ɛtɔ́ ɛ lɛ tyee esok elɛl nyɛ nadi etetɔ́ kɛdjaala dáa nyɛ nadjedjaala sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tin, Yezu eezɛbula pɛ bɛdjekel bɛ nadi ɛ́, nyɛy nɛ nɔɔ náá: «Bi dinaa é gɔ́? Bi ɛpewala? Guka náá, ɛwala Sɛɛŋɛlɛ Mɔn Mot aaseebaa é mɛmbɔ mɛ bot ɛ mesyem ɛ eezedjala. ");
INSERT INTO bkw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wyɛlka, ghɛɛka mɛnyel, mena tɔ́ka, etɛɛ náá, mot ka mɛ é mɛmbɔ mɛ bot binɔk ɔ, moo ɛ́ ɛkunaaɛpe nɛ nena.» ");
INSERT INTO bkw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yezu dinaa ààpaakosilal ɛlii deenek, Yudas, ngɔt tɔ bɛdjekel bɛ eezɛtuula nɛ boo ɛdhuu ɛ bot nɛ epɛl nɛ ebhil e ele é mɛmbɔ. Eboo bɛghaa-Zɛɛb, nɛ bɛpaa ɛ eYuda ɛ́ nalwom bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kabela tin ɛ́, Yudas, mot naka bɛ Yezu gha ɔ naazelyaal bɛ geka, bɛ aagwyak Yezu nɛ yɛ ɛ: «Mot mɛ aakɛbeedal ɔ, ye ɛ́ nyɛy, mɛtka nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Batsa deenek, Yudas eezɛtuula, nyɛ eezɛtiila pɛ daa Yezu, nyɛ eezɛke nɛ nɛ náá: «Mɛ eeswos wɔ, Lyoel!» Bhii tak, nyɛ eezɛbeedal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","É di tak, Yezu ɛ́ boozɛke nɛ nɛ náá: «Wɛn sɔ'am! Lela ɛsa sa wɔ zyɛ zɛsa ɛ.» Bhii tak, bot ɛ nazyɛ bɛ nɛ Yudas ɔ ɛ́ boozɛmɛt Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tin, wɔ gwaa, ngɔt pak bot ɛ nadi bɛ nɛ Yezu ɔ, zokawaal pɛl, tsaal dhiiti mot-mɛsa mɛ boo ghaa-Zɛɛb ɛlɔ. ");
INSERT INTO bkw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yezu eezɛke nɛ mot'enɔk náá: «Nɔŋa pɛl'ɔ, da wɔ ɛ́ bulal tɔ pɛp, etɛɛ náá, bot ɛ di egó bɛsɔ bɔɔ bot nɛ epɛl ɔ, bɛ aabaazogwyɛ ɛ́ nɛ pɛl. ");
INSERT INTO bkw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wɔ ààgu náá, mɛ ɛ́ nɛ ghwyil ɛdjóo Saag'am, nyɛ zɛkwyee mɛ? É di tak wat, nyɛ ɛ́ nɛ ghwyil ɛdhis mɛ ɛdhuu ɛ esodja efofop ɛbuɛpe kum-kumak mɛdhuu kam nɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mɛ sa deenek ɔɔ, etɛp ee di tɔ ekwyala aakasael dáa? Etɛɛ náá, ekwyala lɛɛ náá, ye goka ɛ́ etɛp binek sael deenek.» ");
INSERT INTO bkw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bhii tak, Yezu eezɛke nɛ ɛdhuu ɛ bot náá: «Ye goka nɛ nen ɛ́ náá, bi zyɛ nɛ epɛl nɛ ebhil e ele étɛp bi neezɛmɛt mɛ tyee náá, mɛ ɛ́ mot ɛzɛm é? Dhi mɛlu djas mɛ di ndiindil tɔ kok Ndjaa-ebuwa é lelyo, biyɔ ààmɛt mɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Esesɛɛ binek sael ɛ́, etɛɛ náá, etɛp ee nakwyalaa tɔ mɛkana mɛ Zɛɛb dum nɛ nam ɛ́ neebela ɛsuk.» Tinaak, bɛdjekel djas ɛ́ boo zɛghuma nɛ ekaab tɔ́ yɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bot ɛ namɛt Yezu ɔ eezɛtɔ́ nɛ nɛ pɛ daa Kayif, mot nadi kɔ elo e bɛghaa-Zɛɛb ɔ, é di bɛghaŋ ɛ mɛkana mɛ etsi, nɛ bɛpaa ɛ eYuda nakɛsɛɛga ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pyɛɛd nadi edu bɛ, nyɛy ɛtsetaɛpe nɛ nɔɔ, batakɛni tɔ ɛbɛsɛɛ ɛ ndjaŋ ɛ boo ghaa-Zɛɛb. Nyɛy zokani tɔ ɛbɛsɛɛ, nɔɔ nyel, disi bɛ nɛ bot ɛ di ebaal ndjaa tak ɔ, étɛp nyɛ neebee dáa tɛp tak aakɛ sik ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Eboo bɛghaa-Zɛɛb, nɛ bɛdhiiti bot ɛ boo kwan eYuda nadi esaa dhiiti esua-esua étɛp bɛ needjɛ Yezu epɛ́ɛ e ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ye nakoozodi náá, bot ɛbuɛpe naazezyɛ zɛpit nyɛ nɛ etɛp esua-esua, tin, bɛ nakadi ɛ́, ààbela sonok. É di tak, wɔ gwaa, bot ɛbá zokazyɛ zɛpit nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Bɔɔ náá: «Mot tak naake náá: “Mɛ waabwak kok Ndjaa-ebuwa e Zɛɛb, da mɛ ɛ́ sum yɛ tɔ mɛlu mɛlɛl.”» ");
INSERT INTO bkw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tin, boo ghaa-Zɛɛb eezɛwyɛl, zɛdji Yezu náá: «Tɔ mɛpita mɛ bot bak zɛpit wɔ'aak, wɔ ààkataŋal yɔ é?» ");
INSERT INTO bkw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yezu nabɛ ɛ́ ààbɔɔza nyɛ. Boo ghaa-Zɛɛb baazɛdji nyɛ náá: «Tuwala myoŋ nɛ mɛsoŋ mɔ nɛ din ɛ Zɛɛb. Lɛɛa bis tsɛɛtsɛ tyee mwaado: Lɛɛa bis nɛghu wɔy ɛ́ di Mɛsia Mɔn Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tin, Yezu eezɛbɔɔza náá: «Ye ɛ́ wɔy, wɔ ɛmet ɛ́ ke deenek! Mɛ lɛɛ bin ɛ́ náá, kana ɛwala mena dika'aak, bi ɛ́ waabee Sɛɛŋɛlɛ Mɔn Mot ndiindil pɛ kyee mbɔ eghɛŋ ɛ Zɛɛb mɛbwala. Bi ɛ́ waabee nyɛ ezyɛ kɔ eguud tɔ gwoo.» ");
INSERT INTO bkw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","É di'enek, wɔ gwaa, boo ghaa-Zɛɛb zɛnyaa ekaad bɛ, nyɛ ɛ́ boozɛke náá: «Nyɛ eelee Zɛɛb! Mena tokapɛ nɛ gwyes náá, mot zɛlɛɛ mena sa nyɛ di esa ɛ! Bi eegwak ebyas ee nyɛ byasal Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Biyɔ kake dáa?» Bɔɔ djas eezɛbɔɔza náá: «Nyɛ ɛ́ nɛ ndjɛ, nyɛ goka ɛ́ nɛ ɛsyee.» ");
INSERT INTO bkw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bhii tak, bɛ eezɛsɛɛ nyɛ mɛtel é bhwoob, bɛ moo tu nyɛ nɛ ekutupo. Bɛdhiiti bot moo tin epak nyɛ mɛbhɛɛz. ");
INSERT INTO bkw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bɔɔ nɛ nɛ náá: «Naŋa! Wɔy Mɛsia, yɛ ɛ́ zɛmyak wɔ?» ");
INSERT INTO bkw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pyɛɛd nadi ɛ́ ndiindil pɛ kel tɔ ɛbɛsɛɛ. Dhiiti moma nadi esa mɛsa tɔ ndjaa boo ghaa-Zɛɛb ɔ, zɛtiila pɛ daa lɛ. Nyɛ ɛ́ boozɛke nɛ nɛ náá: «Wɔy pe, wɔ nadi ɛ́, bi nɛ Yezu, mot Ghalile yenɔk.» ");
INSERT INTO bkw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wɔ gwaa, Pyɛɛd zɛswonal. Nyɛy náá: «Mɛ ààgu sa wɔ di kwyɛl ɛlii'enek.» ");
INSERT INTO bkw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bhii tak, Pyɛɛd eezɛswoola di tɔ peeb ɛbɛsɛɛ, tɔ́ kɛtyaa pɛ ɛniel. Tin, wɔ gwaa, dhiiti moma mɛsa baazɛgwyak nyɛ. Moma tak eezɛlɛɛ nɛ bot ɛ nadi tin ɔ náá: «Mot'ak nadi ɛ́, bɛ nɛ Yezu, mot Nazalɛt.» ");
INSERT INTO bkw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Tin, wɔ gwaa, Pyɛɛd baazɛkɛla Yezu kɛla sis, nyɛ eetuwal myoŋ nɛ mɛsoŋ nɛ din ɛ Zɛɛb náá: «Mɛ lɛɛ bin ɛ́ tsɛɛtsɛ náá, mɛ ààgu mot'enɔk.» ");
INSERT INTO bkw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bhii tak, bot ɛ nadi é di'enek bɛ nɛ bɛ nɔɔ eezɛtiila pɛ Pyɛɛd nadi ɛ́, bɛ eezɛke nɛ nɛ náá: «Ye ɛ́ tsɛɛtsɛ! Wɔ ɛ́ mot'ɔɔ, etɛɛ náá, ɛlii ɛ lɔ ɛpelyaal pɛ kyee dɛl wɔ dus ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","É di'enek, Pyɛɛd eezɛben gwood, kɛla. Nyɛ ɛ́ bookalal: «Zɛɛb Mɛkaake! Mam ààgu mot bi di eke'enɔk!» Batsa deenek, kuu ɛsok eezɛkɔk. ");
INSERT INTO bkw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tin, Pyɛɛd eezɛtaala sa Yezu nalɛɛ nyɛ ɛ: «Ɛsok nɛ kuu nɛ kɔk, yɛ aabela ɛ́, wɔ eezeswonal mɛ esok elɛl». É di'enek, Pyɛɛd eezɛwyis, tɔ́, nyɛ moo tin edje ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tɔ ghooghom mɛlem, eboo bɛghaa-Zɛɛb, nɛ bɛpaa ɛ eYuda zokazɛsɛɛga. Tɔ zɛɛga tak, bɛ nagwakel ɛ́ náá, bɛ neegó Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bɛ eezɛmɛt nyɛ, kɔl nyɛ mɛmbɔ, zɛnɔɔ nyɛ, tɔ́ nɛ nɛ pɛ daa Pilat mot nadi kukuma dɛl ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Dáa Yudas, mot naka nyɛ gha nagwak náá, Yezu eemɛtaa étɛp nyɛ neekɛgóaa ɛ, ye nabɛ ɛ́, nyɛ naadyeebadjɛ lyem mɛbɛ. Tin, nyɛ ɛ́ bookanɔɔ efalanga mɛkam-mɛlɛl e epata ee eboo bɛghaa-Zɛɛb, nɛ bɛpaa ɛ eYuda nadjɛ nyɛ ɛ, nyɛ eekɛbulal yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nyɛ ɛ́ boozɛlɛɛ nɔɔ náá: «Mɛ eekwyɛ ndjɛ! Mɛ eemyaal náá, mɛ eeka mot baa gwyes nyɛ góaa!» Bot binɔk ɛ́ boozɛbɔɔza nɛ nɛ náá: «Yenek ààkagwyák bisɔ, ye gwyák ɛ́ wɔy.» ");
INSERT INTO bkw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wɔ gwaa Yudas zokanɔɔ epata binek, mwas tɔ Ndjaa-ebuwa. Bhii tak, nyɛ eezɛtɔ́, kɛtiŋal kel é tsuŋ yeeda. ");
INSERT INTO bkw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bot ɛ nadi kɔ eboo bɛghaa-Zɛɛb ɔ ɛ́ boozɛtek epata binek. Bɔɔ náá: «Etsi bina lɛɛ ɛ́ náá, mbi epata dáak ààgoka nɛ ɛbaakɛkwomaa tɔ di epata di ekwomaa tɔ Ndjaa-ebuwa ɛ. Etɛɛ náá, yenek moo ɛ́ epata e ghiya.» ");
INSERT INTO bkw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bhii bɛ nazegwakel ɛ, bɛ ɛ́ boozɛnɔɔ epata binek, kɛbɔm pyeeb mɛel mɛbhe mɛ dyak. Bɛ nabɔm yɛ ɛ́ étɛp ye needi, di mɛvit mɛ bɛdjoŋ. ");
INSERT INTO bkw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Étɛp tak ɛ, bɛ naget pyeeb tak «pyeeb ghiya», kɛkum dɔɔ nɛ dwoo pan mos'ak. ");
INSERT INTO bkw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Djas yenek nasael ɛ́ dáa ngoolel-mɛkpa ɛ Zɛɛb Zelemi nalɛɛ ɛ́: «Bɛ eenɔɔ bɔɔ efalanga mɛkam-mɛlɛl epata binek, mɛtaŋ mɛ bot ɛ Yisalaɛl nazetiŋal kɔ ɛsu ɛ lɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tin, bɛ ɛ́ boozɛnɔɔ epata e tak, bɔm yɛ nɛ pyeeb ɛ mɛel mɛbhe mɛ dyak, dáa Ghɛŋ nalɛɛ mɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yezu eezɛpɛ́ɛaa pɛ daa kukuma. Pilat eezɛdji nyɛ náá: «Wɔ ɛ́ mɛkoozi mɛ eYuda?» Tin, Yezu eezɛbɔɔza náá: «Wɔy, wɔ ɛmet eelɛɛ!» ");
INSERT INTO bkw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bhii tak, dáa eboo bɛghaa-Zɛɛb, nɛ bɛpaa eYuda nakadi esu nyɛ zukamwaa nɛ etɛp ɛ, nyɛ nabɛ ɛ́ ààbɔɔza nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat eezɛke nɛ nɛ náá: «Wɔ ààgwak mɛpita mɛ bɛ di epit wɔ yenek é?» ");
INSERT INTO bkw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tinaak, Yezu kadi ɛ́ ààbɔɔza bɛ ɛkpa wat. Kukuma naadyeebadjoka nɛ dáa Yezu nadi gwyem, ààbɛɛ nuub ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Esok djas yii eYuda nadi ebebɔl ɛbyoŋ ɛ Pak ɛ, ekukuma bɔɔ nabebɛ ɛ́ nɛ mɛfulu mɛ ɛpel ɛ mot membok ngɔt yii ɛdhuu ɛ bot aasɛ́ɛ ɛ, da nyɛ ɛ́ wyiselaa é membok. ");
INSERT INTO bkw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","É di tak, tɔ membok, ye nabɛ ɛ́ nɛ dhiiti ngék mot membok. Din ɛ lɛ nabɛ ɛ́ Yezu Bhaalabas. ");
INSERT INTO bkw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilat ɛ́ boozɛdji ɛdhuu ɛ bot ɛ nadi tin ɔ náá: «Bi kwyɛl náá, mɛ bet bin zɛ? Yezu Bhaalabas “ooho” Yezu, mot di djóoaa Klisto ɔ?» ");
INSERT INTO bkw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tin, Pilat nadi egu náá, Yezu namɛtaa ɛ́, etɛɛ náá, bɛ nabɛ ɛ́ nɛ mbee lyem nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dáa Pilat nadi kɔ bóó epɛ́ɛ bɛ ɛ, myɛl zokadhis nyɛ bhaadal náá: «Sa wɔ ààsa mot epiki yenɔk ɛbiyo, etɛɛ náá, mɛ eedyeebazuk é pum'ak mos tɔ dhyam kɔ ɛsu ɛ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","É di'enek, eboo bɛghaa-Zɛɛb, nɛ bɛpaa ɛ eYuda moo tin ebesal ɛdhuu ɛ bot, bɛ lɛɛ nɛ Pilat náá, nyɛ wyisal bɛ Bhaalabas, da bɛ ɛ́ gó Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wɔ gwaa, kukuma Pilat baazɛdji bɛ náá: «Tɔ bot ɛbá bak, bi kwyɛl náá, mɛ bet bin nwyaa?» Ɛdhuu ɛ bot binɔk kabulal ɛ́ náá: «Bhaalabas.» ");
INSERT INTO bkw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat ɛ́ boozɛbaadji bɛ náá: «Mɛ sa dáa nɛ Yezu di djóoaa Klisto ɛ?» Bɛ kabɔɔza nɛ nɛ náá: «Bema nyɛ kɔ mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat eebaadji bɛ náá: «Yaa etɛp e ɛbiyo nyɛ sa?» Wɔ gwaa, bɛ baazɛtsim ɛlyelɛpe: «Bema nyɛ kɔ mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Dáa Pilat nabee náá, bot nadi enenal ɛ, nyɛ ɛ́ boozɛnɔɔ mɛdii, gwyii mɛmbɔ mɛ é mis ɛdhuu ɛ bot binɔk, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Tɛp ɛsyee ɛ mot'ak ààkagwyák mɛ. Ye kagwyák ɛ́ biyɔ bɛ ɛmet!» ");
INSERT INTO bkw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɛdhuu ɛ bot ɛ nadi tin ɔ zokazɛbɔɔza náá: «Beta náá, esesɛɛ binek djas kwyɛ kɔ elo bis nɛ kɔ elo e bɔn bis!» ");
INSERT INTO bkw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tin, Pilat ɛ́ boozɛwyisal bɛ Bhaalabas, é di'enek nyɛ eezɛlwom bɛ, bɛ bi Yezu nɛ eghwyɛs, bhii tak, nyɛ eezɛdjɛ bɛ Yezu, étɛp bɛ neekɛbem nyɛ kɔ mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Esodja ɛ Pilat zokatɔ́ nɛ Yezu tɔ ɛbɛsɛɛ pɛ daa kukuma, é di'enek, bɛ eezɛwa nyɛ kuku ɛbwak. ");
INSERT INTO bkw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɛ eezɛsɔ nyɛ kaad nyɛ nabɔt ɛ, bhii tak bɛ eezɛbet nyɛ ndjookuwa na tɔɔbelaa. ");
INSERT INTO bkw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tin, bɛ eezɛnɔɔ lɛɛ le mɛgɔk, pyeed nyɛ kɔtɔ mɛkoozi nɛ yɛ. Wɔ gwaa, bɛ sɔm nyɛ yɛ ɛ é lo, bɛ eezɛsɛk nyɛ mɔɔ le ghwaazok é mbɔ eghɛŋ bɛ. Bhii tak, bɛ eezɛkwyit mɛboŋ sok bhwoob'ɛ, bɛ moo tin eduk nyɛ. Bɔɔ nɛ nɛ náá: «Bis eeswos wɔ, mɛkoozi mɛ eYuda!» ");
INSERT INTO bkw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bɛ moo tin esɛɛ nyɛ mɛtel é nyel. Bɛ eezɛdɛk mɔɔ le ghwaazok nyɛ nadi nɛ yɛ é mbɔ ɛ, bɛ eezɛmyak nyɛ nɛ yɛ é lo. ");
INSERT INTO bkw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bhii bɛ nasilal ɛduk nyɛ ɛlyelɛpe ɛ, bɛ ɛ́ boozɛdis nyɛ ndjookuwa bɛ nazebet nyɛ ɛ́, bɛ eebaazɛbet nyɛ ekaad ee nyɛ nadi nɛ yɛ sok ɛ. Bhii tak bɛ eezɛtɔ́ nɛ nɛ étɛp nyɛ neekɛbemaa kɔ mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","É ghɛŋ bɛ nadi ewyis kɔ dɛl ɛ, wɔ gwaa, bɛ zɛboma nɛ dhiiti mot dɛl Silɛn. Din ɛ mot tak nabɛ ɛ́ Simɔŋ. Tin, esodja ɛ́ boolwom nyɛ nɛ bhel náá: Nyɛ kwyee Yezu é ɛbɛp mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tin, bɛ eezɛkum é di bɛ nadi edjóo: Ghologhota ɛ. Din ɛ tak kwyɛl ɛlɛɛ: «Di Bhobho Lo». ");
INSERT INTO bkw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","É di'enek, bɛ ɛ́ boozɛdjɛ Yezu mɛnyok puuza nɛ dhiiti sonok mɛnyan na gwyee-gwyee. Bhii nyɛ nabowal ɛ, nyɛ ɛ́ boozɛpɛɛ ɛdɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bhii tak, bɛ eezɛbem nyɛ kɔ mɛlaaba. Bot ɛ nadi tin ɔ ɛ́ boozɛkaa ekaad bɛ, bhii bɛ nasa ɛgwyeeg étɛp bɛ neesɛ́ɛ mot aanɔɔ ekaad e tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bhii tak, bɛ eezɛdisi tin ebaal Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bɛ nabɛ ɛ́, bɛ eekwyal kɔ lo'ɛ, kɔ ɛko ɛ mɛlaaba mɛsɔ mɛ nyɛ nagóaa étɛp tak ɛ. Ye nakwyalaa ɛ́ náá: «Nwyak ɛ́ Yezu, mɛkoozi mɛ eYuda.» ");
INSERT INTO bkw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɛdhiiti bot ɛ ɛzɛm nɛ etuub bɛbá naabemaa é yɔbɔ mɛlaaba dwoo tak wat, ngɔt pɛ mbɔ eghɛŋ ɛ Yezu, nwyak tak pɛ mbɔ ɛmyɛl ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bot ɛ nadi edhaa tin ɔ, bɛ nadi elee nyɛ, nɛ ɛsyaal elo. ");
INSERT INTO bkw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Bɔɔ nɛ nɛ náá: «Wɔy mot di ekwyɛl ɛwaaz kok Ndjaa-ebuwa, da bhii tak, wɔ ɛ́ baawyɛl yɛ bhii mɛlu mɛlɛl ɔ, tsika nyel'ɔ wɔ ɛmet. Yɛ bɛ náá, wɔ ɛ́ Mɔn Zɛɛb ɔɔ, sula kɔ mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dɔɔ nɛ eboo bɛghaa-Zɛɛb, nɛ bɛghaŋ ɛ mɛkana mɛ etsi, zɛnɔɔ bɛpaa ɛ eYuda moo tin eduk nyɛ. Bɔɔ nɛ nɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Nyɛ ɛpetsik bot ɛ sis, nyɛ tok nɛ ghwyil ɛtsik nyel'ɛ nyɛ ɛmet! Nɛ tsɛɛtsɛ náá, ye ɛ́ nyɛy ɛ́ di mɛkoozi mɛ Yisalaɛl é? Nyɛ pookokasul kɔ mɛlaaba étɛp mena needumka koŋ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nyɛ naadyeebadum koŋ'ɛ nɛ Zɛɛb, nyɛy batake náá: “Mɛ ɛ́ Mɔn Zɛɛb”. Tin, yɛ bɛ náá, Zɛɛb nɛ kwyɛl nyɛ ɔɔ, nyɛ katsik nyɛ é di'enek nenak!» ");
INSERT INTO bkw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bot ɛ ɛzɛm ɛ nadi mbema é mengwoob ɛ Yezu ɔ, moo tin ebaalee nyɛ pe mɛkpa mɛ wat tyee bot ɛ ɛsok nadi elee nyɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dáa ye nakum kuku mwos ɛ, wɔ gwaa, ɛgwyitok zɛgwyiidela kɔ ɛko ɛ bɔs djas, mɛghomla menek naabɔya mɛwala mɛlɛl. ");
INSERT INTO bkw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tin, é ghɛŋ ye nadhaa mɛwala mɛlɛl bhii kuku mwos ɛ, wɔ gwaa, Yezu zɛbo boo tsim: Eli, Eli, lema sabatani? Ye kwyɛl ɛlɛɛ ɛ́ náá: «Zɛɛb Saag'am, Zɛɛb Saag'am! Étɛp yé wɔ bet mɛ mɛ ɛmet deenek?» ");
INSERT INTO bkw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bɛdhiiti bot pak bot ɛ nadi tin ɔ, zokagwak dáa Yezu natsim ɛ. Bɛ ɛ́ boozɛke nɛ bɛsɔ bɔɔ náá: «Gwakeka! Nyɛ ɛpedjóo Eli!» ");
INSERT INTO bkw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tin, mot ngɔt pak'ɔɔ eezɛwyis kaab, kɛnɔɔ pes kaad, zɛkɔl é bil le ghwaazok, duu tɔ mɛnyok mɛ na bwaaz-bwaaz, nyɛ eesɛɛb Yezu yɛ ɛ, nyɛ needɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tin, wɔ gwaa, bɛdhiiti bot zokake náá: «Bwooda, mena pookobeeka nɛghu Eli ɛ́ waazyɛ, zɛdis nyɛ é mɛlaaba.» ");
INSERT INTO bkw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bhis yenek, wɔ gwaa, Yezu baazɛbo boo tsim, bhii tak nyɛ zɛsil eswos. ");
INSERT INTO bkw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","É di'enek wat, wɔ gwaa, boo lɛmbɛ nadi tɔ Di na Dɛɛ ɛ Zɛɛb ɛ zokazɛnyɛɛ kuku tak kan pɛ ɛko kɛkum pɛ si. Bɔs dheegel, mɛkok bel, ");
INSERT INTO bkw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mɛvit diiel. Wɔ gwaa, bot ɛbuɛpe nagwyɛ bɔɔ edum koŋ nɛ Zɛɛb ɔ zokagom. ");
INSERT INTO bkw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bɔɔ zokawyis tɔ mɛvit, bhis ɛgom ɛ Yezu, bɔɔ zokani tɔ Yeluzalɛm dɛl ɛ na dɛɛ, ye nabɛ ɛ́ bot ɛbuɛpe nabee bɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kukuma tɔ lɔɔg esodja nɛ esodja ee nadi tin ebaal Yezu ɔ naabee dáa bɔs nadheegel ɛ, dɔɔ nɛ edjema djas nasael tin ɛ. Boo bwoo naazɛsa bɛ ɛlyelɛpe, bɛ ɛ́ boozɛke náá: «Tsɛɛtsɛ, nyɛ nabɛ ɛ́ Mɔn Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bɛtɛ nɛ boa nadi ɛ́ tin, bɔɔ ebee ɛtsetaɛpe sa nasɛ́ɛ ɛ. Boa tak nadidi ɛ́, bɛ nɛ Yezu, kana pɛ Ghalile. Mɛsa mɔɔ nabɛ ɛ́ ɛkwyee ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pak boa ɛ tak, ye nabɛ ɛ́: Maali, moma dɛl Makdala, Maali nyɛɛg ɛ Zak bɛ nɛ Zozɛf, zɛnɔɔ nyɛɛg bɔɔ Zɛbɛdɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dáa ye nabɛ dwoo moo bikoko ɛ, dhiiti kuma mot dɛl Alimate zokazyɛ, din ɛ lɛ nabɛ ɛ́ Zozɛf. Nyɛ nabaabɛ ɛ́ ngɔt tɔ bɛdjekel ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wɔ gwaa, nyɛ zokatɔ́ pɛ daa kukuma Pilat, kɛwaab muu ɛ Yezu. Tin, Pilat ɛ́ booke náá, bɛ djɛ nyɛ muu ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tin, Zozɛf ɛ́ boozɛnɔɔ bes bheeza na puu, pil muu ɛ Yezu tɔ tak. ");
INSERT INTO bkw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wɔ gwaa, nyɛ zokanɔɔ muu tak, kɛwa yɛ tɔ ɛvit ɛ nyɛ nakpak tɔ bat ɛkok ɛ. Nyɛ ɛ́ zokabiŋal boo ɛkok ɛ bɛ nasa étɛp bɛ neediyal ɛvit ɛ tak nɛ yɛ ɛ. Bhii tak, nyɛ eezɛnɔɔ nyel, sik, tɔ́ pɛ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tin, kabela ɛ́, Maali, moma dɛl Makdala nɛ nwyak Maali nadi ebee di bɛ nawa muu ɛ Yezu ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ɛlu ɛwat bhii tak, ye nabɛ ɛ́ dwoo saba. Eboo bɛghaa-Zɛɛb nɛ eFalizyɛ zokazɛtɔ́ kɛsɛɛga pɛ daa Pilat. ");
INSERT INTO bkw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bɔɔ nɛ nɛ náá: «Ghɛŋ, ye bɛ ɛ́ bis eetaala náá, na ghaa mɛkɔŋ menɔk, é ghɛŋ nyɛ nadi, nyɛ dinaa nɛ tsik ɛ, ye nabɛ ɛ́, nyɛ naalɛɛ náá: “É ghɛŋ mɛ aagwyɛ ɛ, mɛlu mɛlɛl bhii tak, mɛ waagom.” ");
INSERT INTO bkw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ye goka ɛ́, wɔ lwom bot náá, bɛ kɛbaal ɛvit mɛlu mɛlɛl, etɛɛ náá, bɛdjekel bɛ ɛ́ nɛ ghwyil ɛzɛdjii muu, tɔ́ nɛ yɛ, da bɛ ɛ́ kake náá: “Nyɛ eegom!” Tin, mɛkɔŋ menek ɛ́ waabaagék dhaa-dhaŋak yii nabɛ sok ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat ɛ́ booke nɛ nɔɔ náá: «Beeka esodja étɛp ɛkɛbaal é. Tɔ́ka, kɛbaal ɛvit dáa bi di ekwyɛl ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bhii tak, bɛ eezɛtɔ́, kɛkoobal dáa bɛ aakɛbaal ɛvit ɛ. Bɛ ɛ́ boopyet ɛkok é ɛbɛ ɛ ɛvit ɛ tak ɛlyelɛpe. Esodja é tak eezɛnɔɔ mɛnyel, disi tin é ngwoob ɛvit. ");
INSERT INTO bkw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dáa dwoo saba nadhaŋ ɛ, kɛŋ tɔ mɛlem mɛ dwoo mɛkɛn mɛ yenga, wɔ gwaa, Maali moma dɛl Makdala, nɛ nwyak dhiiti Maali zɛtɔ́, kɛbee ɛvit. ");
INSERT INTO bkw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dáa bɛ katɔ́ ɛ́, bɛ kasɛka ɛ́, bɔs moo dheegel ɛlyelɛpe. Fofop ɛ Ghɛŋ ngɔt eedus pɛ tɔ gwoo, sul é bɔs, nyɛ eezɛbiŋal boo ɛkok ɛ bɛ nadiyal ɛbɛ ɛ ɛvit nɛ yɛ ɛ. Bhii tak, nyɛ eezɛnɔɔ nyel, disi kɔ ɛkok ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nyɛ nadi ɛ́, ɛkasɛpe dáa ngwyes bhi, ekaad bɛ mɛpum dhaa nyel. ");
INSERT INTO bkw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tin, esodja ee nazɛbaal ɛvit ɔ, moo tin syeela nɛ bɛbebwol, bɛ moo tin «gbegbagba» epwak nɛ bwoo, saa dáa bɛ sa. ");
INSERT INTO bkw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","É di'enek, wɔ gwaa fofop zokake nɛ nɔɔ náá: «Nàdika nɛ bwoo, mɛ nɛ gu náá, bi saŋ ɛ́ Yezu, mot nabemaa é mɛlaaba ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nyɛ tokapɛ wak. Nyɛ eezegom dáa nyɛ nalɛɛ bin é ghɛŋ nyɛ nadi, nyɛ dinaa nɛ nen é di wat ɛ. Dha beeka di bɛ nakɛl muu'ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lelka, tɔ́ka, kɛlɛɛ nɛ bɛdjekel bɛ náá: “Nyɛ eezegom! Nyɛ eetɔ́, kɛbwood bin pɛ Ghalile. Ye ɛ́ penek ɛ bi aakɛboma nɛ nɛ.” Bhaadal mɛ kwyɛl mɛ neelɛɛ bin ɛ, ye ɛ́ yenek.» ");
INSERT INTO bkw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","É di tak wat, boa binɔk eezɛwyis tɔ ɛvit, bɔɔ zɛsum kaab. Tɔ elyem bɔɔ, ye nabɛ ɛ́ nɛ bwoo nɛ mɛmyaala ɛlyelɛpe. Bɔɔ zokasik kɛgoola lɛŋ pɛ daa bɛdjekel ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","É di tak wat, Yezu zokazɛboma nɛ boa binɔk. Nyɛy nɛ nɔɔ náá: «Mɛ eeswos bin!» Tin, boa binɔk eezɛtiila pɛ dáa Yezu, bɛ eezɛmɛt nyɛ é mɛko, bɛ moo tin nɛ ɛduwal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yezu ɛ́ booke nɛ nɔɔ náá: «Sa bi ààdi nɛ bwoo. Kɛlɛɛka nɛ bɔn nyaag'am náá, bɛ tɔ́ pɛ Ghalile. Ye ɛ́ penek ɛ bɛ aakɛbee mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Boa binɔk dinaa é ze, bɛdhiiti bot tɔ esodja ee nanɛɛgaa étɛp ɛbaal ɛvit ɔ eezɛkum pɛ dɛl. Bɛ moo tin elɛɛ eboo bɛghaa-Zɛɛb esesɛɛ ee nadhaa penek ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bot ɛ nadi kɔ elo e bɛghaa-Zɛɛb ɔ, nɛ bɛpaa eYuda zokasɛɛga é kwan. Bhii bɛ nazegwakel ɛ, wɔ gwaa, bɛ djɛ esodja binɔk bɛtɛ nɛ epata. ");
INSERT INTO bkw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bɛ eezɛke nɛ nɔɔ náá: «Bi lɛɛ bot ɛ náá: “Bɛdjekel bɛ eezyɛ é pum, zɛdjii muu mot'ɔɔ, bisɔ é egɔ́.” ");
INSERT INTO bkw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tin, kukuma yen ɛ gwak ɔɔ, yɛ aanàkwaasa sonok, etɛɛ náá, bis ɛ́ waagu dáa bis aasil nyɛ lyem ɛ. Bis ɛ́ waasa náá, bi nàbela etɛp pɛ di mɛsa men.» ");
INSERT INTO bkw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Esodja é tak ɛ́ boonɔɔ epata é tak. Sika bɛ nakasik ɛ́, bɛ ɛ́ bookɛsa dáa bɛ nalɛɛ bɛ náá, bɛ sa ɛ. Deenek, ye nabɛ ɛ́ menduk mɛ etɛp binek naagék tɔ mɛlɔ mɛ eYuda djas, kɛkum dwoo pan mos'ak. ");
INSERT INTO bkw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bɛdjekel bɛ kam nɛ ngɔt nalik ɔ, nadi etɔ́ pɛ ze Ghalile, pɛ kɔ ɛtsok ɛ Yezu nalyo bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dáa bɛ nakum ɛ, bɛ eezɛbee nyɛ. Bhii tak bɛ moo tin eduwal nyɛ. Ye kabela tin ɛ́, bɛdhiiti nadi ɛ́, nɛ mɛso tɔ elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yezu ɛ́ bootiila pɛ bɛ nadi ɛ́, nyɛ ɛ́ booke nɛ nɔɔ náá: «Ye nabɛ ɛ́, Zɛɛb eedjɛ mɛ eghɛŋ nɛ mɛbwala mɛ djas pɛ tɔ gwoo nɛ kɔ bɔs. ");
INSERT INTO bkw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Deenek, tɔ́ka pɛ daa bot ɛ membyak djas di kɔ ɛko ɛ bɔs ɛ, da bi ɛ́ kɛsa náá, bɔɔ djas liigel, da bɛ ɛ́ di bɛdjekel bam. Duuka bɛ Zɛɛb nɛ din ɛ Sɛɛg, nɛ Mɔn, nɛ Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lyoka bɛ, bɛ kɛlooba nɛ esesɛɛ djas mɛ nalyaal bin ɛ. Tin, bi ɛ́ waabee náá, mena waadika lɔɔg wat mɛlu djas, kɛkum dwoo bɔs'ak aabookɛsi ɛ.»");
INSERT INTO bkw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɛkɛn ɛ Mbɛɛ Bhaadal dum nɛ Yezu Klisto, Mɔn Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Dáa ekwyala di elɛɛ tɔ mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi náá: «Mam Zɛɛb ɛ́ waadhis ngoola-ngoola yam pɛ sok bhwoob'ɔ étɛp nyɛ neekoobal wɔ mɛze. ");
INSERT INTO bkw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ye ɛ́ gwood mot di etuud kɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. Nyɛ nakeke nɛ bot ɛ mbyak'ɛ ɛ́ náá: “Koobalka mɛze ɛ Ghɛŋ! Tuuka nyɛ mɛze mɛ na looba-looba!”» ");
INSERT INTO bkw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tin, Zaŋ Nduuel-bot eezɛzyɛ pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, nyɛy etuud náá: «Liigka elyem, da bi ɛ́ kɛduwa Zɛɛb. Tin, Zɛɛb ɛ́ waapel mesyem men.» ");
INSERT INTO bkw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tin, bot ɛ kyee dik Yude djas nɛ bot ɛ ghaada Yeluzalɛm lɔɔg wat, bɛ eezɛtɔ́ pɛ daa lɛ, kɛvaa mesyem mɔɔ é mis mɛ bot, nɛ ɛduwa Zɛɛb tɔ dii Yuldɛn. ");
INSERT INTO bkw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kaad Zaŋ nadi ebɔt ɛ nasael ɛ́, nɛ mya mɛ boo yaaga kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. Nyɛ nabɛ ɛ́ nɛ bhɛtɛ ket é kuu. Nyɛ nadedɛ ɛ́ etsemaaka nɛ ego. ");
INSERT INTO bkw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nyɛ nadi elyo mɛdhuu mɛ bot binɔk ɛ́ náá: «Mot di ezyɛ bhii mam ɔ, nyɛ eedhaa mɛ nɛ mɛbwala. Mam aanàkwaakobela-belak duu ɛmalal étɛp ɛkotii-tiiak ekel e ekoko bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mam duu bin Zɛɛb ɛ́ pɛ tɔ dii. Yɛ kabɛ nyɛy ɔ, nyɛ aaduu bin Zɛɛb ɛ́ tɔ Sisim na Dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tin, tɔ mɛlu menek, Yezu naazɛdus pɛ Nazalɛt, pɛ kyee dik Ghalile, nyɛ eezɛtɔ́ pɛ dii Yuldɛn, étɛp nyɛ neekɛduwa Zɛɛb pɛ daa Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","É ghɛŋ nyɛ nadi ewyis tɔ dii ɛ́, wɔ gwaa, gwoo zɛbɛŋel. Sisim na Dɛɛ eezɛsul kɔ lɛ tyee ɛghum. ");
INSERT INTO bkw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Gwood wat zɛgék tɔ gwoo eke náá: «Wɔ ɛ́ mɔn'am mɛ dyeebakwyɛl ɔ. Bum lyem'am ɛ́ nɛ mɛmyaala ɛbuɛpe kɔ ɛsu ɛ lɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","É di tak wat, Sisim Zɛɛb eezɛtɔ́ nɛ nɛ pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yezu naazɛsa tin pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, mɛlu mɛkam-mɛná. Satan naawa nyɛ tɔ mɛbhowal. Nyɛ nadi ɛ́ tɔ bɛtit ɛ dik. Efofop nadi ezɛkwyee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ba mɛlu bhii tak, Zaŋ naazɛmɛtaa é mbok. Tin, ye nabɛ ɛ́, Yezu naazɛtɔ́ pɛ Ghalile egoola Mbɛɛ Bhaadal Zɛɛb. Nyɛy náá: ");
INSERT INTO bkw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Ɛwala Zɛɛb nakɛk ɛ, yɛ eezekum! Ɛyoŋ ɛ Zɛɛb moo ɛ́ ɛkunaaɛpe. Liigka elyem, myaalka Mbɛɛ Bhaadal Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yezu nadi ekɛ mbaka-mbaka nɛ boo soob na djato-djato e Ghalile. Wɔ gwaa, nyɛ zɛbee bɛlael ɛ mɛwyet bɛbá, Simɔŋ bɛ nɛ dhyeeb Andele ela mɛwyet tɔ dii. ");
INSERT INTO bkw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yezu eezɛke nɛ nɔɔ náá: «Duka mɛ, mɛ waasa náá, bi di bɛlael ɛ mɛwyet étɛp ɛmɛt ɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","É di'enek wat, bɛ eezɛdhuugal mɛwyet mɔɔ, étɛp ɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bhii Yezu nakɛ ba «ziii» ɛ́, nyɛ eezɛboma nɛ Zak bɛ nɛ dhyeeb Zaŋ, bɔn Zɛbɛdɛ. Bɛ nadi ɛ́, mendiindil tɔ elɛɛd bɔɔ sela é ɛboŋ, bɔɔ ekoobal mɛwyet mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Batsa deenek, Yezu eezɛdjóo bɛ, wɔ gwaa, bɛ zɛdhuugal sɛɛg'ɔɔ Zɛbɛdɛ nɛ bot ɛ mɛsa mɛ tɔ elɛɛd, du nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yezu bɛ nɛ bɛdjekel bɛ eezɛni kɔ dɛl Kapɛlnaum dwoo saba. Wɔ gwaa bɛ zɛni tɔ ndjaa mendjaala mɛ eYuda. Nyɛ eezɛben gwood elyo mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bot ɛ nadi egwak nyɛ ɔ nadi edjoka kɔkɔ mbi yenek lyoa mɛkpa ɛ Zɛɛb. Etɛɛ náá, nyɛ nalelyo ɛ́, nɛ eghɛŋ, ààkabɛ dáa bɛghaŋ ɛ mɛkana mɛ etsi ɛ Moiiz di ezezyɛ nɛ ɛlelyaal bɛ sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","É di tak wat, tɔ bot ɛ nadi tɔ ndjaa mendjaala mɛ eYuda ɔ, ye nabɛ ɛ́ nɛ dhiiti mot mbee sisim nadi dhedhek nyɛ ɔ. Wɔ gwaa, nyɛ zɛkyeeb náá: ");
INSERT INTO bkw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Haa! Mena ɛ́ nɛ yaa tɛp, Yezu, mot Nazalɛt? “Iyeee!” Wɔ zyɛ ɛ́ zɛtwak bis é? Mɛ nɛ gu náá, wɔy ɛ́ Mot na Dɛɛ Zɛɛb nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wɔ gwaa, Yezu zɛbhɛm nyɛ ɛlyelɛpe. Nyɛy náá: «Dia gwyem, wyisa tɔ nyel mot'ak!» ");
INSERT INTO bkw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mbee sisim zokazɛdheeg mot'enɔk ɛlyelɛpe. Bhii tak, nyɛ eezɛwyis tɔ lɛ nɛ boo tsim. ");
INSERT INTO bkw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bot djas naadjoka ɛlyelɛpe, bhii tak bɛ moo djinel pak'ɔɔ: «Nwyak ɛ́ nwyaa kwaambi kɔkɔ lyoel di elyo nɛ eghɛŋ djas'aak? Nyɛ ɛ́ nɛ eghɛŋ nɛ ghwyil ɛbatake nɛ embee esisim náá, bɛ wyis, bɔɔ batagwak nyɛ, da ɛ́ wyis!» ");
INSERT INTO bkw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","É di tak wat, dék din ɛ lɛ zokakɛ kɔ kyee dik Ghalile djas. ");
INSERT INTO bkw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wyisa Yezu nawyis tɔ ndjaa mendjaala mɛ eYuda ɛ, bɛ eezɛtɔ́ pɛ ndjaŋ ɛ Simɔŋ nɛ Andele, bɛ nabɛ ɛ́, bɛ nɛ Zak zɛnɔɔ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bɛ kabela tin ɛ́, tsi ɛ Simɔŋ yii moma «kpop» nɛ mɛkosa ndjaasi. Kuma nyɛ nakum ɛ, bɛ eezɛlɛɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yezu zɛtiila pɛ daa lɛ, bhii tak, nyɛ eezɛmalal kɔ lɛ. Nyɛ eezɛmɛt nyɛ é mbɔ, wyɛl nyɛ. É di tak wat, mɛkosa eezɛsi tɔ lɛ. Tin, tsi ɛ Simɔŋ eezɛwyɛl, nyɛ moo zɛbe bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bikoko, dwoo eezɛsila, wɔ gwaa, bot ɛ dɛl zokazyɛ nɛ bot ɛ mɛbɛ́ membi nɛ membi, dɔɔ nɛ bot ɛ embee esisim nadi edhedhek ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bot ɛ mɛl djas zokazɛmaala é ɛbɛ ɛ ndjaa nyɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tin, Yezu naazɛtsik bɛtɛ nɛ membel membi nɛ membi nazyɛ ɔ, nyɛ naabaasɔ embee esisim tɔ bɛdhiiti. Tin, nyɛ nabɛ ɛ́ ààbet náá, embee esisim gheelii, etɛɛ náá, bɛ nadi egwyák nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tɔ ghooghom mɛlem mɛ yak ɛlu, Yezu eezɛkuud tɔ́ pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, étɛp ɛkɛdjaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔŋ nɛ bot ɛ nadi bɛ nɛ bɛ nɔɔ ɔ eezɛtɔ́ kɛsaa nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bhii bɛ nakabela nyɛ ɛ, bɛ eezɛke nɛ nɛ náá: «Bot djas ɛpesaa wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Djhokaka pɛ yii mɛl etɛɛ náá, ye goka ɛ́ mɛ kɛgoola mɛkpa ɛ Zɛɛb penek etɛɛ náá, mɛ nazyɛ ɛ́ étɛp tak.» ");
INSERT INTO bkw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bhii tak, Yezu zokakɛ kɔ kyee dik Ghalile djas, egoola mɛkpa ɛ Zɛɛb tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ ɛsɔ embee esisim tɔ bot. ");
INSERT INTO bkw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dhiiti mot nadi nɛ ɛbɛ́ ɛ zezam ɔ, zokazɛtiila pɛ daa lɛ, kwyit mɛboŋ si, zɛdjaala nɛ nɛ náá: «Mɛ nɛ gu náá, wɔ ɛ́ nɛ ghwyil ɛtsik mɛ, lyem'ɔ ɛ́ kwyɛl ɔɔ, étɛp mɛ neebula nyel dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wɔ gwaa, ghoŋ zɛmɛt Yezu ɛlyelɛpe. Nyɛ eezɛsɛɛb mbɔ, mɛt nyɛ, nyɛ eezɛke nɛ nɛ náá: «Mɛ eekwyɛl! Tsaka.» ");
INSERT INTO bkw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","É di tak wat, ɛbɛ́ ɛ zezam zokasi é nyel mot'enɔk, nyɛ moo dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bhii tak, Yezu ɛ́ boozɛswaal mot'enɔk é di tak wat. Tin, nyɛ ɛ́ boozɛdul nyɛ mɛlɔ ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nyɛ eezɛke nɛ nɛ náá: «Gwaka mɛ ɛnyɔɛpe! Sa wɔ ààlɛɛ mot sa dhaa wak ɛ. Tɔ́ kɛlyaal nyel'ɔ pɛ daa bɛghaa-Zɛɛb, da wɔ ɛ́ kɛdjɛ ebuwa e bɛtit dáa Moiiz nake ɛ, étɛp ɛlyaal nɛ bot náá, wɔ eetsak.» ");
INSERT INTO bkw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mot'enɔk eezɛtɔ́, nyɛ ààpakadi gwyem. Nyɛ moo lɛɛ nɛ bot egba nɛ egba sa dhaŋ ɛ. Kɔ ɛsu ɛ tak, ye nabɛ ɛ́, ye naalyel nɛ Yezu nyɛ tuula kɔ dɛl. Nyɛ nazokadi ɛ́ pɛ tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. Bot nadi edus pɛ ekyee sis, zyɛ pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ba mɛlu bhii tak, Yezu eezɛbula pɛ Kapɛlnaum. Dáa bot nagwak náá, nyɛ ɛ́ pɛ ndjaŋ ɛ, ");
INSERT INTO bkw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wɔ gwaa zukamwaa nɛ mot zɛsɛɛga kɔ ɛbɛsɛɛ. Mɛbu mɛ bot saa-saŋak di ɛsɛɛ mɛtel. Bot kum-kumak pɛ ɛbɛ ɛ ndjaa. Tin, Yezu nabɛ ɛ́, elyo bot mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bɛdhiiti bot zokazyɛ nɛ mot ngɔt, nyɛ nabɛ ɛ́, nyɛ eezesɔɔb nɛ ɛbɛ́. Bot ɛná ɛ́ nabyaal nyɛ kɔ mwaala. ");
INSERT INTO bkw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dáa ɛdhuu ɛ bot nadi ɛbuɛpe, ààbɛ nɛ ze ɛkpaa étɛp bɛ neekɛnɛɛg nyɛ si mɛko ɛ Yezu ɛ. Wɔ gwaa, bot binɔk zokazɛtuu ɛlen kɔ mii ndjaa, bɛ eezɛsil mwaala mot ɛbɛ́ ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Dáa Yezu nabee ɛdum ɛ koŋ ɛ bot ɛ nazyɛ nɛ mbel tak ɔ, nyɛ ɛ́ boozɛke nɛ mot nazesɔɔb ɔ náá: «Mɔn'am, mesyem mɔ eepelel.» ");
INSERT INTO bkw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bɛdhiiti bɛghaŋ ɛ mɛkana mɛ etsi ɛ Moiiz nadi mendiindil tin ɔ, nabɛ ɛ́, bɛ moo nɛ bɛtɛ nɛ esiiza tɔ elyem bɔɔ. Bɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Mot'ak lii deenek étɛp yé? Nyɛ ɛpebyasal Zɛɛb, etɛɛ náá, mot tok nɛ ghwyil ɛpel mesyem mɛ sɔ mot, bhii Zɛɛb nyɛ ɛmet.» ");
INSERT INTO bkw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","É di tak wat, Yezu naagu esiiza bɔɔ. Nyɛ ɛ́ booke náá: «Étɛp yé bi di nɛ mbi yenek egeka? ");
INSERT INTO bkw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ɛye di elyel nɛ nen, ɛke ɛ́ nɛ mbel náá: “Mesyem mɔ eepelel”, “ooho” nɛghu ɛke ɛ́ náá: “Wyɛla, ghɛɛa mwaala yɔ, da wɔ ɛ́ kɛ”? ");
INSERT INTO bkw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ye goka ɛ́ bi gu náá, Sɛɛŋɛlɛ Mɔn Mot ɛ́ nɛ ghwyil ɛpel mesyem mɛ bot ɛ bɔs.» Bhii tak, nyɛ eezɛke nɛ mot nadi sɔɔba ɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mɛ ke ɛ́ náá: Wyɛla, nɔŋa mwaala yɔ, da wɔ ɛ́ sik pɛ ndjaŋ'ɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","É di'enek wat, bot djas «dhuuu» nɛ mis é nyel'ɛ, mbel eezɛwyɛl, ghɛɛ mwaala yɛ, zɛnɔɔ nyel tɔ́. Bot djas naadyeebadjoka. Bhii tak, bɛ moo duwal Zɛɛb é ɛkeke náá: «Mena dinaa ààpaabee kɔkɔ yak sok!» ");
INSERT INTO bkw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yezu eebaazɛsik mbaka-mbaka nɛ boo soob na djato-djato Ghalile. Bot mɛdhuu-mɛdhuu nadi ezyɛ pɛ daa lɛ. Tin, nyɛy elelyo bɛ mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dáa nyɛ nadi edhaŋ ɛ, nyɛ ɛ́ boozɛbee Levi, mɔn Alfe, ndiindil é di mɛsa mɛ. Nyɛ nadi ɛ́, nɔŋel epata e lapo. Yezu eezɛke nɛ nɛ náá: «Dua mɛ!» Tin, «ngbat», Levi eezɛwyɛl, nyɛ eezɛdu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Bhii tak, Yezu eezɛtɔ́, kɛdɛ edee pɛ ndjaŋ ɛ Levi. É di tak, ye nabɛ ɛ́ nɛ bɛtɛ nɛ bɛnɔŋel ɛ epata e lapo, nɛ bot ɛ mesyem, etɛɛ náá, kwaambi bot binɔk nadi edudu nyɛ ɛbuɛpe. Dɔɔ nɛ bɛdjekel ɛ Yezu pe nadi ɛ́ tin. ");
INSERT INTO bkw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bɛghaŋ ɛ mɛkana mɛ etsi yii eFalizyɛ, nadi ebee dáa nyɛ nadi dɛ edee é di wat, bɛ nɛ bot ɛ mesyem nɛ bɛnɔŋel ɛ epata e lapo ɛ. Bɛ ɛ́ boozɛdji bɛdjekel bɛ náá: «É tɛp yé nyɛ di dɛ edee é di wat bɛ nɛ bɛnɔŋel ɛ epata e lapo nɛ bot ɛ di nɛ mbee mɛfulu ɔ?» ");
INSERT INTO bkw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yezu naagwak dáa bɛ nadi elii ɛ, nyɛ ɛ́ boozɛke nɛ nɔɔ náá: «Bot ɛ di mɛnyel ɛnyɔɛpe ɔ, tok nɛ gwyes ngwomel bot étɛp nyɛ neegwom bɛ. Ye ɛ́ membel ɛ di nɛ gwyes mɛ gwoma mɛ. Mɛ nabɛ ɛ́ ààzyɛ zɛsaa bot ɛ epiki. Mɛ nazyɛ ɛ́ zɛsaa bot ɛ di egu náá, bɛ ɛ́ bot ɛ mesyem ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dhiiti dwoo, bɛdjekel ɛ Zaŋ, bɛ nɛ eFalizyɛ nadi etsi edee étɛp mendjaala. Tin, bot naazɛdji Yezu náá: «Étɛp yé bɛdjekel ɛ Zaŋ nɛ yii eFalizyɛ di etsi edee, bɔ kadi ɛ́, ààtsi?» ");
INSERT INTO bkw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wɔ gwaa, Yezu zokabɔɔza nɛ nɔɔ náá: «Bi nakobee sok paa náá, bɛsɔ ɛ mwaaz tsi edee é dwoo ɛbá, dhi bɛ di lɔɔg wat nɛ mwaaz, mot paazyɛ, zɛba moma ɔ? Mam ààbee. ");
INSERT INTO bkw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ɛwala ɛ tak ɛ́ waakum, é sok yɛ aadi náá, mwaaz mot zyɛ zɛsa ɛbá ɔ aadisaa tɔ lɔɔ ɔ. É di tak ɛ́ bɛ aatsi edee. ");
INSERT INTO bkw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Ye tok nɛ mot aanyaa pes bes kaad étɛp ɛkoobal bet kaad nɛ yɛ. Wɔ sa deenek ɔɔ, é sok wɔ aagwyii kaad tak ɛ, bes kaad ɛ waanyaa bet kaad, da ɛ́ bek ɛlen ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ye tok nɛ mot aawa bes mɛnyok tɔ bhɛɛb na mwa, etɛɛ náá, yɛ wyil ɔɔ, mɛnyok ɛ́ nɛ ghwyil ɛ́ ɛbo bhɛɛb, da mot ɛ́ su mɛnyok, su dɔɔ nɛ bhɛɛb. Ààbɛ! Yɛ ààgoka deenek etɛɛ náá, mɛnyok mɛ na bes goka ɛ́ tɔ ebes e bhɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Dhiiti dwoo saba, Yezu bɛ nɛ bɛdjekel bɛ nadi edhaa tɔ pyeeb kɔkɔ mbi bhek bhusa di edjóoaa ble ɛ. Bɔɔ kuku kyeed, bɛdjekel bɛ nadi ebɔ́k mɛzɛm mɛ tak enyuŋal. ");
INSERT INTO bkw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","EFalizyɛ zɛke nɛ nɛ náá: «Beea etɛp ee bɛ di esa dwoo saba ɛ, yɛ ààpadjɛaa bɛ ze náá, bɛ sa deenek.» ");
INSERT INTO bkw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi dinaa ààpaalaa dáa Dhavid nasa é sok bɛ nɛ bot bɛ nadi tɔ mezuk, ààbɛ nɛ sa dek ɛ? ");
INSERT INTO bkw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bɛ naani tɔ ndjaa Zɛɛb, tɔ́, kɛdɛ emapa ee nakaŋaa Zɛɛb yɛ ɛ. É ghɛŋ tak, ye ɛ́ Abiyataad ɛ́ nadi boo ghaa-Zɛɛb. Ye nakoozodi náá, etsi lɛɛ ɛ́ náá, mot di egoka nɛ ɛdɛ emapa binek ɔ, ye ɛ́ ghaa-Zɛɛb. Tin, mɛkoozi Dhavid naadɛ yɛ, bhii tak, nyɛ naanɔɔ yak kyee, djɛ bot ɛ nadi egyee nɛ nɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yezu zokabaazɛke nɛ nɔɔ náá: «Zɛɛb nasa dwoo saba ɛ́, étɛp bot, ààkabɛ náá, nyɛ nasa mot ɛ́ étɛp saba. ");
INSERT INTO bkw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Étɛp tak ɛ́ Sɛɛŋɛlɛ Mɔn Mot ɛ́ di kukuma dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bhii tak, Yezu eebaazɛsik tɔ ndjaa mendjaala mɛ eYuda. Tɔ tak, ye nadi ɛ́, nɛ dhiiti mot ngɔt nɛ mbɔ sɔɔbela. ");
INSERT INTO bkw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bot moo tinaak «dhuuu» nɛ mis é nyel ɛ Yezu egwyak nɛghu nyɛ waatsik nyɛ é dwoo saba, étɛp bɛ neepit nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yezu eezɛke nɛ mot na mbɔ sɔɔbela yenɔk náá: «Wyɛla, dha! Tyaŋa tetel kuku ɛbwak.» ");
INSERT INTO bkw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nyɛ eezɛdji ɛdhuu ɛ bot ɛ nadi tin ɔ: «Tɔ etsi, ɛyé di egoka nɛ ɛsael dwoo saba, enɛm esa “ooho” embee esesɛɛ?» Tin, bot djas moo tinaak «mɔɔɔ», ààbɔɔza nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yezu eezɛbulal mis, gwyák bɛ nɛ ɛbuk tɔ lyem, nyel tyak nyɛ «wɔyɔŋ» nɛ mbi yenek mɛlyel mɛ elyem mɛ bot ɛ tak. Nyɛ eezɛke nɛ mot tak náá: «Sɛɛba mbɔ'ɔ.» Nyɛ eezɛsɛɛb mbɔ'ɛ, wɔ gwaa, mbɔ'ɛ tak zɛsekel bula ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","EFalizyɛ eezɛwyis tɔ ndjaa mendjaala mɛ eYuda. Tin, bɛ eezɛsɛɛga nɛ bot ɛ zɛɛga mɛkoozi Elood. Bɛ nɛ bɛ nɔɔ ɛ́ boozɛni é boob, étɛp ɛdjek dáa bɛ aasa étɛp bɛ neegó nyɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yezu nɛ bɛdjekel bɛ eezɛtɔ́ mbaka-mbaka nɛ boo soob na djato-djato Ghalile. Wɔ gwaa, zukamwaa nɛ mot zɛdu nyɛ. Bot ɛ tak nadudus ɛ́ pɛ kyee dik Yude nɛ pɛ Ghalile, ");
INSERT INTO bkw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","dɛl ɛ Yeluzalɛm, pɛ kyee dik Idhume, pɛ kyee dik yii kyiid dii Yuldɛn, zɛnɔɔ pɛ kyee dik Tiid nɛ Sidɔn. Bɛ nadi ezyɛ mɛdhuu-mɛdhuu etɛɛ náá, bɛ nabɛ ɛ́ egwak menduk mɛ sa nyɛ nasa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Dáa nyɛ naadi etsik membel ɛbuɛpe ɛ, bɛdhiiti nasuu ɛ́, bɛ ghaaga nyɛ é nyel, étɛp bɔɔ bɛmet neemɛt nyɛ nɛ mɛmbɔ mɔɔ, bɛ neetsak. Tin, Yezu ɛ́ boolɛɛ nɛ bɛdjekel bɛ náá, bɛ nɔɔ nyɛ dhiiti elɛɛd étɛp nyɛ neeni tɔ tak, é kaab náá, bot ɛzɛkɛbila nyɛ é nyel. ");
INSERT INTO bkw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","É sok bot ɛ embee esisim nadi edhedhek ɔ, nadi ebee nyɛ ɛ, bɛ nadi ekwyit mɛboŋ si, si mɛko mɛ, é ɛtsim náá: «Wɔ ɛ́ Mɔn Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yezu ɛ́ bozɛlyak bɛ ɛlyelɛpe náá, bɛ nàsa náá, bot gu mbi mot nyɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bhii tak, Yezu eezɛbyet kɔ ɛtsok. Nyɛ eedjóo bot ɛ nyɛ nasɛ́ɛ ɔ, wɔ gwaa bot ɛ tak zokazyɛ pɛ nyɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bhii tak, nyɛ eezɛtɔ tɔ sama yɔɔ bot ɛ lwoma kam nɛ bɛbá yii nyɛ aadi egyee nɛ nɔɔ ɛ, étɛp nyɛ neekyeed bɛ, bɛ kɛlyo bot mɛkpa ɛ Zɛɛb, ");
INSERT INTO bkw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","dɔɔ nɛ ɛdjɛ bɛ eghɛŋ ɛsɔ embee esisim. ");
INSERT INTO bkw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Beeka min mɛ bɛdjekel kam nɛ bɛbá tak e: Simɔŋ, mot Yezu naget Pyɛɛd ɔ, ");
INSERT INTO bkw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zak nɛ mɔn nyɛɛg Zaŋ, bɔɔ djas bɔn Zɛbɛdɛ. Yezu naget bɛ din ɛ «Bhoanɛlghɛs» ye kwyɛl ɛlɛɛ ɛ́: bot ɛ di dáa ndum bhi ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andele, Filip, Bhaatelemi, Matye, Toma, Zak mɔn Alfe, Tade, Simɔŋ mot di tɔ ɛdhuu ɛ eZɛlɔt ɔ, ");
INSERT INTO bkw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","zɛnɔɔ Yudas Iskaliɔt, mot naka Yezu gha ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bhii tak, Yezu eezɛsik pɛ ndjaa. Wɔ gwaa zukamwaa nɛ mot zɛlwood kɔ ɛbɛsɛɛ, ààbɛ nɛ dáa bɛ nɛ bɛdjekel bɛ dɛ edee. ");
INSERT INTO bkw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Dáa bot ɛ mɛbyel mɛ nagwak deenek ɛ, wɔ gwaa, bɛ ghɛɛ, tɔ́, kɛsaa nyɛ, bɛ neebula nɛ nɛ etɛɛ náá, tɔ elo bɔɔ, bɛ nadi egek ɛ náá: «Yezu ɛpebɛ́ myan.» ");
INSERT INTO bkw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bɛghaŋ ɛ mɛkana mɛ etsi nadus pɛ Yeluzalɛm ɔ, moo tin eke pak'ɔɔ náá: «Nwyak ɛ́ leega nɛ Bɛlzebul, kukuma embee esisim djas.» Bɔɔ náá: «Ye ɛ́ kukuma embee esisim ɛ di edjɛ kɔkɔ yak mbi mɛbwala mɛ nyɛ di esɔ embee esisim nɛ yɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","É di'enek, Yezu eezɛdjóo bɛ. Nyɛ eezɛlii nɛ nɔɔ tɔ kana. Nyɛy náá: «Satan ɛ́ nɛ ghwyil ɛsɔ nyel'ɛ nyɛ ɛmet é? ");
INSERT INTO bkw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yɛ bɛ náá, mɛsa mɛ bot ɛ ɛyoŋ ɛ wat ɛ́ ɛwaya pak'ɔɔ ɔɔ, ɛyoŋ ɛ tak aanàkwaadi. ");
INSERT INTO bkw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Baabela náá, bɔn bil wat ɛ di egena pak'ɔɔ ɔɔ, bil tak aanàkwaadi. ");
INSERT INTO bkw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ye kwyɛl ɛlɛɛ náá, Satan ɛ́ twak nyel'ɛ nyɛ ɛmet ɔɔ, mɛbɛka'enek tɔ ɛyoŋ ɛ lɛ, tin, nyɛ aanàkwaabaabɛ nɛ ghwyil, ɛsi ɛ lɛ'enek. ");
INSERT INTO bkw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Ye tok nɛ mot di nɛ ghwyil ɛni tɔ ndjaa mot mɛnyan, da ɛ́ nɔɔ esa bɛ, yɛ bɛ náá, nyɛ dinaa ààpaamɛt nyɛ sok, da ɛ́ kɔl nyɛ mɛmbɔ nɛ mɛko ɔɔ. Tin ɛ, nyɛ aadjala nɛ ɛnɔɔ esa e ndjaŋ'ɛ djas, da nyɛ ɛ́ wyis, tɔ́. ");
INSERT INTO bkw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Mesyem mɛ bot djas ɛ́ nɛ ghwyil ɛpelaa, ye nakoozodi ebyas djas bɛ byasal Zɛɛb ɛ nɛ mesyem mɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yɛ kabɛ náá, mot eebyasal Sisim na Dɛɛ ɔɔ, nyɛ aanàkwaapelaa, etɛɛ náá, yenek ɛ́ syem na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yezu nalii nɛ nɔɔ deenek ɛ́, etɛɛ náá, bɛ nadi eke náá: «Ye ɛ́ mbee sisim ɛ di tɔ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nyɛɛg ɛ Yezu nɛ bɔn nyɛɛg eezɛkum, bɛ eezɛtyaa pɛ kel, ààni tɔ ndjaa. Bhii tak, bɛ eezɛlwom mot, nyɛ kɛdjóo Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Etɛɛ náá, zukamwaa nɛ mot nadi ɛ́ mendiindil nyɛy kuku ɛbwak. Wɔ gwaa, bɛ zɛlɛɛ nɛ nɛ náá: «Nyoog nɛ bɛdhyeeb bɔ, zɛnɔɔ bɛkɛl bɔ ɛ́ pɛ kel. Bɛ ɛpesaa wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Nyaag'am ɛ́ zɛ? Da bɔn nyaag'am ɛ́ kabɛ bɛzɛ?» ");
INSERT INTO bkw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wɔ gwaa nyɛ bulal mis, gwyák ɛdhuu ɛ bot binɔk djas. Nyɛ ɛ́ booke náá: «Beeka nyaag'am nɛ bɔn nyɛɛg bam di wak e. ");
INSERT INTO bkw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Etɛɛ náá, mot di esa ɛkwosak ɛ Zɛɛb ɔ, nyɛ ɛ́ di mɔn nyaag'am, kɛl'am nɛ nyaag'am.» ");
INSERT INTO bkw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Bhii tak, wɔ gwaa Yezu baazɛni elyo bot mbaka-mbaka nɛ boo soob na djato-djato Ghalile. Wɔ gwaa zukamwaa nɛ mot zɛsɛɛga tin, nyɛ ɛ́ boozɛni tɔ dhiiti elɛɛd. Nyɛ eezɛnɔɔ nyel, disi. Elɛɛd nadi ɛ́ tɔ dii, bot kadi ɛ́ pɛ kyiid é ngwoob dii. ");
INSERT INTO bkw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nyɛ naalyo bɛ bɛtɛ nɛ mɛlyo tɔ ekana. Tɔ dhiiti kana, nyɛ naake nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Gwakeka! Dhiiti dwoo mot ngɔt naatɔ́ pɛ pyeeb'ɛ, kɛsɔs bhek. ");
INSERT INTO bkw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dáa nyɛ nadi esɔs bhek ɛ, kyee bhek wat nakwyit ɛ́, é gba, wɔ gwaa, enen zokazyɛ, zɛdɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yak kyee bhek kakwyit ɛ́, kɔ bat ɛkok. Ààkobɔya deenek, mɛbhek eezɛkwyil etɛɛ náá, di tak nadi ɛ́, nɛ ba bim ebɔs. ");
INSERT INTO bkw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bhii tak, gwyes na “ghɛ-ghɛ” zɛkɛɛza kɔ mɛbhek menek, wɔ gwaa djas zɛsyee etɛɛ náá, ekaŋal e tak nabɛ ɛ́ ààni tɔ bɔs ɛdimɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dhiiti kyee bhek nakwyit ɛ́ tɔ engwyinini. Engwyinini binek wyee, kala kɔ mbɛɛ mɛbhek, ààbɛ nɛ dáa mɛbhek wyee ɛnyɔɛpe. Mɛbhek kadi ɛ́, ààwum. ");
INSERT INTO bkw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tin, dhiiti kyee bhek nakwyit kɔ mbɛɛ bɔs ɔ, naakwyil ɛnyɔɛpe, wɔ gwaa, ye kwyil mɛzɛm. É kwos wat, bhum mɛkam-mɛlɛl, é yak kwos bhum mɛkam-mɛtɛn nɛ wat, é dhiiti kwos bhum dhet.» ");
INSERT INTO bkw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bhii tak, Yezu zɛke nɛ nɔɔ náá: «Yɛ bɛ náá, bi ɛ́ nɛ mɛlɔ mɛ ɛgwak ɔɔ, gwakeka ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","É sok bɛ nadi bɛ nɛ Yezu bɔɔ bɛ ɛmet ɛ, bot ɛ nadi egyee nɛ Yezu ɔ, zɛnɔɔ bɛdjekel bɛ kam nɛ bɛbá, naazɛdji nyɛ ɛsuk ɛ ekana binek. ");
INSERT INTO bkw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wɔ gwaa, nyɛ zɛbɔɔza nɛ nɔɔ náá: «Biyɔ, bi eezedjɛaa etsoŋ ɛgu ɛ ɛsuk ɛ Ɛyoŋ ɛ Zɛɛb. Yɛ kabɛ bɛsɔ bin ɔ, bɛ gwak yɛ ɛ tɔ ekana. ");
INSERT INTO bkw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Deenek, “Bɛ ɛ́ nɛ ghwyil ɛgwyák nɛ mis, ààbee. Bɛ ɛ́ nɛ ghwyil ɛgwak nɛ mɛlɔ, ààmɛt sa ye di ekwyɛl ɛlɛɛ ɛ, é kaab náá, bɛ ɛ́ zɛkɛbula dum koŋ nɛ Zɛɛb, da bɛ ɛ́ bela ɛpelak ɛ Zɛɛb!”» ");
INSERT INTO bkw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bhii tak, nyɛ eebaazɛke nɛ nɔɔ náá: «Bi ààtiibal ɛsuk ɛ kana yak ɛnyɔɛpe? “Aah” bi aagwak ɛsuk ɛ bak bɛdhiiti ekana dáa? Gwakeka ɛsuk ɛ tak: ");
INSERT INTO bkw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Sɔsel mɛbhek kɛsɔs ɛ́ mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bɛdhiiti bot ɛ́ dáa mɛbhek mɛ di é ngwoob egba é di mɛkpa ɛ Zɛɛb kwyit ɔ. Nɛ ɛgwak ɛ bɛ zogwak ɛ, Satan eeleezyɛ, zɛnɔɔ bɛ mɛkpa mɛ tak tɔ ebhum elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tin, ye ɛ́ nɛ kyee bot ɛ di dáa mɛbhek kwyit kɔ bat ɛkok ɔ. Dáa bɛ gwak mɛkpa ɛ Zɛɛb ɛ, wɔ gwaa, bɛ myaal nɛ mɛmyaala djas. ");
INSERT INTO bkw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tin, bɛ ààbet náá, mɛkpa mɛ tak gheeni bɛ ɛnyɔɛpe tɔ ebhum elyem, bɛ ààwa zii ɛbuɛpe. Tin, mezuk nɛ mɛtiiga ɛ́ tuula bɛ kɔ ɛsu ɛ mɛkpa ɛ Zɛɛb ɔɔ, ɛliig ɛ lɔɔ Zɛɛb koŋ ààbɔya. ");
INSERT INTO bkw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bɛdhiiti tɔ lɔɔ gwak mɛkpa ɛ Zɛɛb ɛ́ dáa kyee bhek nakwyit tɔ engwyinini ɛ. Ye ɛ́ bot ɛ di egwak mɛkpa ɛ Zɛɛb ɔ, ");
INSERT INTO bkw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tin, esiiza esa e bɔs'ak, ɛwyeeb ɛ mɛvu, nɛ egwyes e esonok mbɛs ɛ́ di enyal mɛkpa ɛ Zɛɛb tɔ elyem bɔɔ. Tin, ye kadi ɛ́, ààdjɛ bhum. ");
INSERT INTO bkw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bɛdhiiti bot kadi ɛ́ dáa mɛbhek mɛ kwyit kɔ mbɛɛ bɔs ɔ. Ye ɛ́ bot ɛ di egwak mɛkpa ɛ Zɛɛb, myaal yɛ nɛ lyem wat, da bɛ ɛ́ kɛ dáa Zɛɛb di ekwyɛl ɛ. Tin, bɛ waadjɛ bhum ɛbuɛpe, yak mɛkam-mɛlɛl, yak tak mɛkam-mɛtɛn nɛ wat, yak dhet.» ");
INSERT INTO bkw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wɔ gwaa, Yezu baazɛke nɛ nɔɔ náá: «Mot ɛ́ nɛ ghwyil zyɛ nɛ lama, da nyɛ ɛ́ butal si bhwaa, nɛghu ɛnɔɔ yɛ, da ɛ́ wa pɛ si goŋ e? Ye nɛɛgaa ɛ́ pɛ kɔ tɛɛg, etsal é? ");
INSERT INTO bkw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ye tok nɛ sa ɛsɔ aadi àànyen é mwos dwoo. Esa e mɛsɔ djas aadi ɛ́, nyen é gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bɛɛka mɛlɔ min, yɛ bɛ náá, bi ɛ́ nɛ mɛlɔ mɛ ɛgwak ɔɔ, gwakeka ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bhis yenek, Yezu baazɛke nɛ nɔɔ náá: «Dika nɛ etsoŋ dum nɛ étɛp djas mɛ di elɛɛ bin ɛ! Dáa bi di edum koŋ nɛ Zɛɛb ɛ, é di tak wat, nyɛ waabil bin ɛgu. Nyɛ aalwoodal bhwaŋ'en ɛ dáa bi di elwoodal bhwaa bɛsɔ bin ɛ. Tin, nyɛ waalwoodal bin yɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Etɛɛ náá, ye ɛ́ mot aadi nɛ ba bim sonok ɔ, bɛ aabil nyɛ dhiiti. Yɛ kabɛ mot di ààbɛ nɛ sonok ɔ, nyɛ aanàkwaabela sonok. Ba bim nyɛ aadi nɛ yɛ ɛ, yɛ waadɛkaa djas.» ");
INSERT INTO bkw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wɔ gwaa, Yezu baazɛke náá: «Beeka sa di enɔŋel nɛ Ɛyoŋ ɛ Zɛɛb ɛ: dhiiti mot zokakɛmwam mɛbhek é bɔs. ");
INSERT INTO bkw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bhii tak, nyɛ eezɛsik. Nyɛ nakoozodja gɔ é pum, nɛghu nyɛ kadi ɛ́ dwooz, mɛbhek ɛpekwyil nɛ ɛwyee tɔ pyeeb. Nyɛy ààgu dáa di esɛɛ penek ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kabela tin ɛ, mbɛɛ bɔs ɛ di esa náá, mɛbhek menek kwyil nɛ ɛwyee ɛnyɔɛpe. Kan ɛtuu ɛ bɔs, zyɛ, kum le, bhii tak zɛdjɛ mɛzɛm mɛ na bes, batadjɛ bhum mɛbhisa. ");
INSERT INTO bkw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tin, é di yɛ aakabɛ náá, bhisa eezesɔk ɛ, nyɛ kazyɛ ɛ́ nɛ ɛlando, zɛkan mɛsa mɛ ɛdis bhisa tak.» ");
INSERT INTO bkw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wɔ gwaa, Yezu baazɛke náá: «Ɛyoŋ ɛ Zɛɛb aakɔa nɛ yaa mbi sa? Tɔ yaa kana mena aadjala nɛ ɛtel Ɛyoŋ ɛ Zɛɛb? ");
INSERT INTO bkw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ɛyoŋ ɛ Zɛɛb ɛ́ dáa bhek le di edjɛ bhum di edjóoaa mutaad ɛ. É sok bɛ di ebɛ yɛ tɔ bɔs ɛ, nyɛ eedhaa mɛbhek djas kɔ bɔs nɛ mɛtɔɔl. ");
INSERT INTO bkw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tin, yɛ bɛ náá, nyɛ eebɛaa ɔɔ, nyɛ waakwyil, mɛwyee mɛ ɛ́ dhaa ele ee di tɔ mɔɔ bok ɛ djas. Nyɛ waakwyil boo elɛɛ djala náá, enen lóo mɛk mɔɔ kɔ ebhuuz e tak.» ");
INSERT INTO bkw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Deenek, ye ɛ́ tɔ kɔkɔ mbi ekana binek ɛ Yezu nadi lelyo bot. Nyɛ nalelɛɛ bɛ, yii baadjala nɛ ɛmɛt ɛsuk ɛ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nyɛ nabɛ ɛ́ ààlii nɛ bot, ààbɛ nɛ kana tɔ sa nyɛ di ekwyɛl ɛlɛɛ ɛ. Yɛ kabɛ é sok nyɛ nadi bɛ nɛ bɛdjekel bɛ, bɔɔ bɛ ɛmet ɛ, nyɛ nadi elɛɛ bɛ mɛsuk mɛ ekana binek djas. ");
INSERT INTO bkw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bikoko dwoo tak wat, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Djhoosɛɛka pɛ yii kyiid boo soob na djato-djato.» ");
INSERT INTO bkw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bɛ eezɛlik ɛdhuu ɛ bot binɔk, bɛdjekel eezɛtɔ́ sama wat nɛ Yezu tɔ boo elɛɛd. Tin, bɛdhiiti mɛlɛɛd nadi ɛ́, é ngwoob'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ààbɔya deenek, kasɛka ɛ́ boo ghuu ɛlyelɛpe eezɛkan, ghulal tak eeghɛɛ ɛbhyeeb ɛ mɛdii kɛɛza é elɛɛd, elɛɛd moo tin eni mɛdii, kɛsa yɛ aalwood-lwooda. ");
INSERT INTO bkw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yezu, pɛ ɛsik ɛ elɛɛd, nyɛ nadi ɛ́, é gɔ, lo kɔ boola. Bɛdjekel bɛ zokazɛdjem nyɛ nɛ etsim. Bɔɔ náá: «Lyoel, mena ɛ́ di esikaa. Yɛ ààgwyák wɔy é?» ");
INSERT INTO bkw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tin, Yezu eezɛdjem. Bhii tak, nyɛ eezɛlyak ghuu. Nyɛy nɛ dii náá: «Sila ghulal'ɔ. Dia gwyem!» É di'enek, ghuu eezɛsila, bhwak moo tin «kup». ");
INSERT INTO bkw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bhii tak, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Étɛp yé bi di nɛ kɛŋ? Bi ààdum koŋ nɛ Zɛɛb é?» ");
INSERT INTO bkw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ye nabɛ ɛ́, bwoo naasa bɛ ɛlyelɛpe, bɛ moo djinel pak'ɔɔ náá: «Nwyak ɛ́ nwyaa kwaambi mot di náá, dɔɔ nɛ ghuu nɛ boo soob na djato-djato ɛpegwak nyɛ'aak?» ");
INSERT INTO bkw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yezu bɛ nɛ bɛdjekel bɛ eezɛsɛɛ pɛ yii kyiid boo soob na djato-djato Ghalile tɔ́ pɛ kyee dik Ghadasa. ");
INSERT INTO bkw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Dáa nyɛ nadi esul tɔ elɛɛd ɛ, kasɛka ɛ́ dhiiti mot edus tɔ mɛvit, ezyɛ esaa tyee nyɛ aaboma nɛ nɛ. Embee esisim nadi edhek mot tak. ");
INSERT INTO bkw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mot tak nadidi ɛ́ tɔ mɛvit. Nyɛ nabɛ ɛ́ ààbɛ nɛ mot aakwak ɛmɛt nyɛ, étɛp bɛ neekɔl nyɛ nɛ ekel e ghwooz. ");
INSERT INTO bkw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Etɛɛ náá, sok, ye nabɛ ɛ́, nyɛ eewaaa mɛko é mbwak nɛ ɛkɔlaa nyɛ mɛmbɔ nɛ eghwooz, nyɛy zokabwak mbwak, dɔɔ nɛ bwak eghwooz. Ye tok nɛ mot aakwak ɛmɛt nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mɛlu djas, mwos nɛ pum nyɛ nadidi ɛ́ tɔ mɛvit nɛ kɔ mɛtsok, é tsitsim nɛ ɛbaal ɛ nyel'ɛ nyɛ ɛmet nɛ mɛkok. ");
INSERT INTO bkw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ɛtsetaɛpe nyɛ nadi ɛ́, nyɛ eezɛbee Yezu, wɔ gwaa, nyɛ sum kaab, zɛghaaga si, si mɛko mɛ mɛboŋ si. ");
INSERT INTO bkw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nyɛ eezɛtsim ɛlyelɛpe náá: «Mɛ sa wɔ yé, Yezu, Mɔn Zɛɛb Mɛkaake? Mɛ ɛpedjaala nɛ nɔ nɛ din ɛ Zɛɛb, nàtwaka mɛ!» ");
INSERT INTO bkw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nyɛ nadi eke deenek ɛ́, etɛɛ náá, ye nabɛ ɛ́, Yezu naake náá: «Mbee sisim, wyisa tɔ mot'ak!» ");
INSERT INTO bkw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wɔ gwaa, Yezu zokazɛdji nyɛ: «Din ɛ lɔ ɛ yé?» Nyɛ eezɛbɔɔza nɛ nɛ náá: «Din ɛ lam ɛ́ “Mɛkɔm-mɛkɔm” etɛɛ náá, bis nɛ bu.» ");
INSERT INTO bkw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tin, nyɛ eezɛdjaala nɛ Yezu ɛlyelɛpe náá: «Nàsɔ bis ɛtsetaɛpe nɛ kyee dik'ak!» ");
INSERT INTO bkw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","É di tak, ye nabɛ ɛ́ nɛ boo ɛsaŋ ɛ bɛghwyee nadi egɔɔ kɔ mɛtsok menek ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Embee esisim eezɛdjaala nɛ Yezu, bɔɔ nɛ nɛ náá: «Kyeeda bis tɔ bɛghwyee bak. Lɛɛa náá, bis ni tɔ mɛnyel mɔɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yezu zokazɛmyaal bɛ yɛ ɛ. Tin, wɔ gwaa, bɛ zɛwyis tɔ mot'enɔk, ni tɔ ɛsaŋ ɛ bɛghwyee binɔk. Bɛ nadi ɛ́, ɛbuɛpe tyee bɛghwyee bɛmil ɛbá. Bɔɔ djas zɛsul ɛtsok pɛ bɛ nadi ɛ́, nɛ ekaab. Wɔ gwaa, bɛ zɛges, kɛghaaga tɔ dii. Bɔɔ djas si na «bhɛɛɛ». ");
INSERT INTO bkw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bot ɛ nadi ebee edjema binek djas ɔ, zokasik nɛ ekaab, kɛlɛɛ bot kɔ dɛl nɛ tɔ epyeeb. Tin, wɔ gwaa, bɛtɛ nɛ bot zokazyɛ, zɛbee sa nasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bɛ eezɛkum pɛ kyee Yezu nadi ɛ. Tin, bɔɔ zokazɛbee mot embee esisim mɛkɔm-mɛkɔm nadi edhedhek ɔ, ndiindil nɛ ekaad é nyel. Nyɛ nabɛ ɛ́ nyel ɛnyɔɛpe. Wɔ gwaa, bwoo zɛmɛt bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bot ɛ nabee edjema binek djas ɔ, moo tin ebaŋa bot dáa mot na embee esisim mɛkɔm-mɛkɔm natsak ɛ, nɛ dáa bɛghwyee nakɛghaaga tɔ dii ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Étɛp tak, bɛ ɛ́ boozɛdjaala nɛ Yezu, bɔɔ nɛ nɛ náá: «Dusa kɔ kyee dik'es. Tɔ́a pɛ kyee sis.» ");
INSERT INTO bkw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","É ghɛŋ Yezu nadi eni tɔ boo elɛɛd ɛ, wɔ gwaa mot embee esisim nadi edhedhek ɔ zɛke nɛ nɛ náá: «Mɛ kwyɛl ɛ, mɛ di sama wat nɛ nɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tin, yɛ kabɛ Yezu ɔɔ, nyɛ nabɛ ààkwyɛl. Nyɛ ɛ́ booke nɛ nɛ náá: «Sika pɛ ndjaŋ'ɔ, pɛ daa bot bɔ, da wɔ ɛ́ lɛɛ bɛ enɛm nɛ embɛɛ Ghɛŋ sa dum nɛ tsik'ɔ ɛ, nɛ dáa nyɛ gek wɔ ghoŋ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mot'enɔk eezɛtɔ́, nyɛ moo tin ekɛlɛɛ kɔ eghaada kam nadi pɛ kyee dik'enek ɛ, dáa Yezu natsik nyɛ ɛ. Bot djas nadi egwak nyɛ ɔ naadyeebadjoka. ");
INSERT INTO bkw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yezu eezɛbula pɛ yii kyiid dii tɔ elɛɛd, wɔ gwaa, zukamwaa nɛ mot baazɛsɛɛga é ngwoob'ɛ. Tin, nyɛ nadi ɛ́, é ngwoob boo soob na djato-djato. ");
INSERT INTO bkw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","É di'enek, ye nabɛ ɛ́ nɛ dhiiti kukuma ndjaa mendjaala mɛ eYuda, din ɛ lɛ nabɛ ɛ́ Yayilus. Dáa nyɛ nabee Yezu ɛ, nyɛ eezɛkwyit mɛboŋ si, si mɛko mɛ ");
INSERT INTO bkw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","é djaala nɛ nɛ, é basal náá: «Mɔn ɛsyes ɛ lam ɛpebɛ́ ɛlyelɛpe. Mendjaala mam ɛ́ náá, wɔ zyɛ zɛkɛl mɛmbɔ kɔ lɛ étɛp nyɛ neetsak, da nyɛ ɛ́ baadi nɛ tsik kɔ bɔs!» ");
INSERT INTO bkw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yezu eezɛtɔ́ bɛ nɛ nɛ, zukamwaa nɛ mot é du nyɛ, bak é tuma nyɛ é nyel nɛ ɛtiidal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tɔ ɛdhuu ɛ bot binɔk, ye nabɛ ɛ́ nɛ dhiiti moma ghiya nadi ekekɛk nyɛ é nyel boa, ààbɛ nɛ ɛtsek ɔ, ɛbɛ́ ɛ tak naasa nɛ nɛ tyee membu kam nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ye nabela ɛ́, nyɛ naazekɛ nɛ ɛbɛ́ ɛ tak tɔ mendjaa mɛ mɛgwoma ɛbuɛpe, epata si nyɛ «pum», nyɛy ààtsak. Yenek djas nakɛgheghɛɛ nyɛ ɛbɛ́ ɛ ghɛɛa. ");
INSERT INTO bkw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dáa moma yenɔk zɛgwak menduk ɛ Yezu ɛ, nyɛ eezɛni tɔ ɛdhuu ɛ bot binɔk, nyɛ moo du Yezu bhii koŋ, nyɛ eezɛmɛt kyee ɛghɔ ɛ kaad ɛ Yezu wat ");
INSERT INTO bkw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","etɛɛ náá, nyɛ nabɛ ɛ́, nyɛ naake tɔ lyem'ɛ náá: «Mɛ zomɛt kaad'ɛ ɔɔ, mɛ ɛpetsak!» ");
INSERT INTO bkw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tin, mɛta nyɛ zomɛt ɛ, é di tak wat, nyɛ eezɛbee náá, nyɛ eetsak. Ghiya eezɛkat ɛkwyil nyɛ. Nyɛ moo ɛ́ nɛ nyel ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","É di'enek wat, Yezu zɛgu náá, dhiiti mɛbwala eewyis tɔ lɛ. Nyɛ eezɛliigel tɔ ɛdhuu ɛ bot binɔk, wɔ gwaa, nyɛ dji bɛ náá: «Ɛzɛ mɛt mɛ é kaad?» ");
INSERT INTO bkw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bɛdjekel bɛ zokabɔɔza nɛ nɛ náá: «Wɔ eebee yak kwaambi zukamwaa nɛ mot di etiidal wɔ'aak, bɛdhiiti é tuma wɔ é nyel'aak, da wɔ ɛ́ baadji náá: “Ɛzɛ mɛt mɛ é kaad?”» ");
INSERT INTO bkw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tin, Yezu eezɛliig mis, nyɛ moo gwyák é ngwoob'ɛ, étɛp nyɛ neebee mot sa deenek ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Moma tak «gbegbagba» nɛ bwoo, étɛp nyɛ nadi egu sa nyɛ nasa ɛ. Nyɛ eezɛkwyit mɛboŋ si, si mɛko ɛ Yezu, nyɛ eezɛmyaal. Bhii tak, nyɛ eelɛɛ dáa ye nasael ɛ, djas. ");
INSERT INTO bkw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wɔ gwaa, Yezu zɛbɔɔza nɛ nɛ náá: «Ɛsyes ɛ lam, ɛdum ɛ koŋ ɛ lɔ nɛ Zɛɛb eetsik wɔ. Tɔ́a ɛnyɔɛpe, wɔ eezetsak.» ");
INSERT INTO bkw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tinaak, Yezu dinaa elii, bot eezɛdus pɛ ndjaŋ ɛ kukuma ndjaa mendjaala mɛ eYuda, zɛlɛɛ Yayilus náá: «Ɛsyes ɛ lɔ eezepɛka, nàkabaadhek lyoel.» ");
INSERT INTO bkw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yezu nabɛ ààbis sa bɛ nadi elii ɛ. Nyɛ ɛ́ boozɛke nɛ kukuma ndjaa mendjaala náá: «Nàbem ba. Duma koŋ nɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tin, nyɛ eezɛlu bot djas náá, bɛ nàdu nyɛ. Nyɛ natɔ́ ɛ́, bɛ nɛ Pyɛɛd, nɛ Zak bɛ nɛ mɔn nyɛɛg Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bɛ eezɛkum pɛ daa kukuma ndjaa mendjaala mɛ eYuda, bela tin bhwak metetel nɛ mɛgwyɛ, nɛ etaŋal nɛ etsim. ");
INSERT INTO bkw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nyɛ eezɛni tɔ ndjaa. Bhii tak, nyɛ eezɛke nɛ nɔɔ náá: «Yak ɛ́ yaa kwaambi ɛtap nɛ mɛgwyɛ? Mɔn ààpagwyɛ. Nyɛ ɛ́, é gɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wɔ gwaa, bot gɔ nyɛ. Nyɛ eezɛwyisal bot djas pɛ kel. Nyɛ nakalik tɔ ndjaŋ ɛ́, bɛ nɛ sɛɛg, nɛ nyɛɛg mɔn, zɛnɔɔ bɛdjekel bɛ. Bɛ eezɛni tɔ dhɛŋ mɔn tak nadi ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nyɛ eezɛmɛt nyɛ é mbɔ, nyɛ ɛ́ booke nɛ nɛ náá: «Talita kumi!» Ye kwyɛl ɛlɛɛ ɛ́ náá: «Mɔn moma! Mɛ lɛɛ wɔ ɛ́, wyɛla!» ");
INSERT INTO bkw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","É di tak wat, mɔn moma yenɔk eezɛwyɛl, nyɛ moo kɛ. Nyɛ nabɛ ɛ́ nɛ membu tyee kam nɛ ebá. Tin, ye nabɛ ɛ́, bot naadyeebadjoka ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yezu eezɛlyak bɛ náá, bɛ nàlɛɛ bot. Bhii tak nyɛ ɛ́ boolwom bɛ náá, bɛ djɛ mɔn tak edee e dek. ");
INSERT INTO bkw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yezu eezɛdus pɛ nyɛ nadi ɛ, nyɛ eezɛtɔ́ sama wat bɛ nɛ bɛdjekel bɛ pɛ Nazalɛt ghaada nyɛ nawyee kɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Dwoo saba, nyɛ nadi elyo bot tɔ ndjaa mendjaala mɛ eYuda. Zukamwaa nɛ mot nadi tin ɔ naadyeebadjoka ɛbuɛpe. Bɔɔ ekeke náá: «Yak ɛ́ yaa kwaambi ɛlyo ɛ bot? Ɛzɛ djɛ nyɛ mbi yak etsoŋ nɛ endem e mɛbwala mɛ nyɛ di nɛ yɛ'aak? ");
INSERT INTO bkw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ye tok nyɛy di salpande, mɔn Maali, mɔn nyɛɛg ɛ Zak bɛ nɛ Yozɛs, nɛ Yudɛ, zɛnɔɔ Simɔŋ é? Bɛkɛl tok wak mena nɛ bɛ nɔɔ?» Yenek djas naasa náá, nyɛ di tyee boo ɛbɛk dum nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wɔ gwaa, Yezu zɛbɔɔza nɛ nɔɔ náá: «Ngoolel-mɛkpa ɛ Zɛɛb dyeebaduwalaa ɛ́, pɛ kyee sis, ààbɛ pɛ kɔ dɛl ɛ nyɛ nabyel kɔ tak ɛ, nɛghu tɔ ndjaŋ'ɛ nɛ tɔ bil'ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tin, nyɛ nabɛ ɛ́ ààsa dhiiti ndem mɛbwala, bhii nyɛ nazokɛl bɛdhiiti membel mɛmbɔ da bɛ ɛ́ tsak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nyɛ nadi edjoka dáa bot ɛ dɛl ɛ lɛ nadi ààdum koŋ nɛ nɛ ɛ. Bhii tak, Yezu naazɛkɛ elyo bot mɛkpa ɛ Zɛɛb kɔ mɛl mɛ nadi é ngwoob dɛl ɛ lɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nyɛ eezɛdjóo bɛdjekel bɛ kam nɛ bɛbá, nyɛ eezɛkyeed bɛ bɛbá-bɛbá. Wɔ gwaa, nyɛ zɛdjɛ bɛ eghɛŋ kɔ embee esisim. ");
INSERT INTO bkw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nyɛ eezɛdjɛ bɛ tsi náá: «Sa mot àànɔɔ sonok wat, nyɛ neetɔ́ nɛ yɛ mɛdjoŋ. Bi zotɔ́ ɛ́, nɛ sek. Sa mot àànɔɔ mapa, àànɔɔ ɛkoo, àànɔɔ-nɔŋak meea tɔ mengwyɛ men. ");
INSERT INTO bkw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bɔtka bɛmɛpapa. Sa mot àànɔɔ dhiiti kuwa étɛp ɛkɛswoola penek.» ");
INSERT INTO bkw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nyɛ eebaazɛke nɛ nɔɔ náá: «Bi ɛ́ kum dhiiti di ɔɔ, dika tɔ ndjaa bi aasulal ɛ. Dika é di'enek kɛkum dwoo bi aadus tin ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Bot ɛ dɛl ɛpɛɛ náá, bi nàsulal pɛ daa lɔɔ ɔ, nɛghu bɛ kapɛɛ ɛgwak bin ɔ, kpaaka yebɔ, da bi ɛ́ kut bɛ piib di é mɛko min ɛ. Yɛ aadi ɛ́, tyee mwana étɛp embee esesɛɛ bɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bɛdjekel eezɛtɔ́, kɛgoola nɛ bot djas náá, bɛ liig elyem. ");
INSERT INTO bkw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɔɔ zokasɔ bɛtɛ nɛ embee esisim. Bɛtɛ nɛ membel naatsak, bhii bɛ nadi elɔɔb bɛ mul ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ghuna ye nabɛ ɛ́, Mɛkoozi Elood naagwak menduk ɛ Yezu etɛɛ náá, dék'ɛ nabɛ ɛ́, yɛ eezedjala mɛl djas. Bɛdhiiti bot nadi ekeke ɛ́ náá: «Zaŋ Nduuel-bot naagwyɛ, gom. Étɛp tak ɛ́ nyɛ di esa bɛtɛ nɛ yenek endem e mɛbwala.» ");
INSERT INTO bkw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bak náá: «Ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb, Eli!» Yak kyee bot náá: «Ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb, dáa dhiiti ngoolel-mɛkpa ɛ Zɛɛb na mwa!» ");
INSERT INTO bkw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dáa Elood nagwak sa bot nadi elii-lii kɔ ɛsu ɛ Yezu ɛ, nyɛ ɛ́ boozɛke náá: «Yɛ bɛ Zaŋ ɔɔ, ye nabɛ ɛ́, mɛ naazelwom náá, nyɛ tsakaa, nyɛy ɛ́ baagom!» ");
INSERT INTO bkw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nɛ tsɛɛtsɛ ye nabɛ ɛ́, Elood naalwom náá, bɛ mɛt Zaŋ kɔl nyɛ é membok kɔ ɛsu ɛ Helodhiaad, mwaa tel, Filip, nyɛ nadɛk ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Etɛɛ náá, Zaŋ naake nɛ Elood náá: «Yɛ ààgoka náá, wɔ dɛk mwaa mɔn nyoog!» ");
INSERT INTO bkw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Helodhiaad nadi ebhina Zaŋ ɛlyelɛpe. Nyɛ nadi esaa dáa nyɛ aasa étɛp nyɛ neego nyɛ. Tin, nyɛ nabɛ ɛ́, ààbela ghwyil ɛsa. ");
INSERT INTO bkw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Elood nadi ekaab Zaŋ, etɛɛ náá, nyɛ nadi egu náá, Zaŋ nadi ɛ́ mot edɛɛ nɛ epiki. Nyɛ nabɛ ààkwyɛl náá, nyɛ góaa. Nyɛ nadi ekwe-kwyɛl ɛgwak mɛlyo mɛ ɛbuɛpe, ye nakoozodi náá, mɛlyo mɛ tak naadyeebadhedheeg nyɛ mɛsel ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tinaak, dwoo ɛbyoŋ ɛ Elood di eduwal dwoo ɛbyel ɛ lɛ ɛ, ye nabɛ nɛ Helodhiaad ɛ́ mbɛɛ ɛwala étɛp nyɛ neesa sa lyem'ɛ nadi ekwos ɛsa ɛ. Ye nabɛ ɛ́, Elood naadjóo bɛtɛ nɛ ekukuma di esa mɛsa bɛ nɛ nɔɔ ɔ, nɛ ekukuma e esodja bɛ, nɛ boo bɛtsoŋ ɛ bot ɛ kyee dik Ghalile, bɛ zɛdɛ pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tin, ɛsyes ɛ Helodhiaad eezɛtuula kuku ɛbwak, tɔ koo ndjaa é di bot nadi edɛ ɔ. Bhii tak, nyɛ moo bɔl é mis ɛ Elood. Ye nabɛ ɛ́, Elood nɛ bɛdjoŋ bɛ naadyeebamyaala nɛ ko zɛŋ tak ɛbuɛpe. Tinaak, Mɛkoozi Elood ɛ́ boozɛke nɛ ɛsyes ɛ moma tak náá: «Waaba sa lyem'ɔ kwyɛl ɛ, mɛ waadjɛ wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nyɛ nake nɛ nɛ deenek ɛ, nɛ tsɛɛtsɛ nɛ lyem wat: «Mɛ eetuwal myoŋ nɛ mɛsoŋ mam! Sa wɔ waawaab ɛ, mɛ waadjɛ wɔ, ye nakoozodi pes ɛyoŋ ɛ lam.» ");
INSERT INTO bkw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ɛsyes ɛlenɔk eezɛwyis, kɛdji nyɛɛg: «Mɛ waab yé?» Wɔ gwaa, nyɛɛg zɛbɔɔza náá: «Waaba lo ɛ Zaŋ Nduuel-bot.» ");
INSERT INTO bkw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ɛsyes eezɛsik kaab pɛ daa Mɛkoozi Elood. Nyɛ eezɛke nɛ nɛ náá: «Mɛ kwyɛl ɛ́, wɔ djɛ mɛ nenak yak lo ɛ Zaŋ Nduuel-bot kɛla kɔ pɛt kongo na pyaaz!» ");
INSERT INTO bkw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wɔ gwaa, ye sa Mɛkoozi Elood nyel «wɔyɔŋ» nɛ ghoŋ. Tin nyɛ nabɛ ɛ́ ààbɛ nɛ dáa nyɛ pɛɛ, etɛɛ náá, nyɛ naazetuwal myoŋ nɛ mɛsoŋ mɛ é mis mɛ bɛdjoŋ. ");
INSERT INTO bkw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tin, nyɛ eezɛlwom sodja di ebaal nyɛ ɔ, nyɛ tsaal lo ɛ Zaŋ Nduuel-bot, da nyɛ ɛ́ zyɛ nɛ yɛ. É di'enek, sodja ɛ́ boozɛtɔ́ pɛ ndjaa membok, kɛtsaal lo ɛ Zaŋ Nduuel-bot. ");
INSERT INTO bkw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wɔ gwaa, nyɛ zyɛ nɛ lo tak kɔ pɛt kongo, nyɛ eezɛdjɛ ɛsyes ɛ moma yenɔk, ɛsyes ɛ tak ɛ́ boonɔɔ yɛ, kɛdjɛ nɛ nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dáa bɛdjekel ɛ Zaŋ nagwak deenek ɛ, bɛ ɛ́ boozɛnɔɔ muu'ɛ, kɛdel. ");
INSERT INTO bkw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bhis ɛbula ɛ lɔɔ, bot ɛ lwoma eezɛboma pɛ daa Yezu, bɛ moo baŋa nyɛ esesɛɛ ee bɛ nasa ɛ, nɛ mɛlyo mɛ bɛ nadi elyo ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tinaak, bot ɛ nadi ezyɛ, nɛ bot ɛ nadi esik ɔ naadyeebabu, ààbɛ nɛ ɛwala di náá, bɛ nɛ bɛdjekel bɛ dɛ edee. Yezu ɛ́ boozɛke nɛ bɛdjekel bɛ náá: «Djhooka, mena tɔ́ka pɛ kasak di etseta nɛ bot ɛ, étɛp mena neekɛwalaka batsa.» ");
INSERT INTO bkw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bɛ eezɛtɔ́ tɔ elɛɛd, bɔɔ bɛ ɛmet, pɛ bot di ààbɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ghuna bot ɛbuɛpe naabee ze bɛ nadi etɔ́ ɛ. Tin, pɛ bɛ nadi etɔ́ ɛ nadi eguaa, bhwak djas zɛsum kaab é ɛtɔ́ pɛ kyee Yezu nɛ bɛdjekel bɛ nadi etɔ́ ɛ, bɔɔ batakɛkum é di tak ɛsok nɛ Yezu bɛ nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Dáa Yezu nasul tɔ elɛɛd ɛ, nyɛ naabee ɛdhuu ɛ bot binɔk, wɔ gwaa, ghoŋ zɛmɛt nyɛ ɛlyelɛpe, etɛɛ náá, bɛ nadi ɛ́, dáa mɛsaa mɛ ebhata di ààbɛ nɛ mbaalel ɛ. Tin, nyɛ moo zɛlyo bɛ kɔ ɛsu ɛ bɛtɛ nɛ esonok. ");
INSERT INTO bkw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dáa bɛ nabee náá, dwoo moo ɛ́ bikoko ɛ, bɛdjekel bɛ ɛ́ boozɛtiila pɛ daa lɛ. Bɔɔ nɛ nɛ náá: «Dwoo eezeleega, tɔ kakoŋ'ak, ye tok nɛ dɛl. ");
INSERT INTO bkw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Swaala bot bak pɛ bɔɔ mɛl nɛ pɛ tɔ epɛt ee di é engwoob'aak, bɛ neekɛbɔm edee e dek!» ");
INSERT INTO bkw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tin, wɔ gwaa Yezu zɛbɔɔza nɛ nɔɔ náá: «Djɛka bɛ edee biyɔ bɛ ɛmet!» Bhii tak bɛ eezɛdji nyɛ náá: «Bis tok nɛ bɛtɛ nɛ epata ee bis aabɔm emapa aadjala nɛ dek bot bak djas ɛ» ");
INSERT INTO bkw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nyɛ ɛ́ boobaazɛbɔɔza nɛ nɔɔ náá: «Bi ɛ́ nɛ emapa edhen? Pookokɛgwyákeka.» Bhii bɛ kakɛgwyák ɛ, bɛ ɛ́ boozɛlɛɛ nyɛ náá: «Emapa etɛn nɛ bɛsu ɛbá.» ");
INSERT INTO bkw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tin, Yezu ɛ́ boozɛlɛɛ bɛdjekel bɛ náá, bɛ dil bot djas mendiindil, mɛbwak nɛ mɛbwak kɔ ebes eka. ");
INSERT INTO bkw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wɔ gwaa, bot zɛdisi zɛɛga lɔɔg bot dhet, bak mɛkam-mɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bhii tak, Yezu eezɛnɔɔ emapa nɛ bɛsu binek, nyɛ eezɛben mis pɛ ɛko, zɛghaapɛɛ Zɛɛb. Nyɛ eezɛpyak mapa, nɔɔ, djɛ bɛdjekel bɛ etɛɛ náá, bɛ needjɛ bot ɛ bɛ nanɛɛg mendiindil ɔ, dɔɔ nɛ bɛsu ɛbá bɛ nadi nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mot nɛ mot naadɛ, djil. ");
INSERT INTO bkw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bɛdjekel bula nɛ mɛbhebhwak mɛ emapa nɛ bɛsu ɛ́ nalik ɛ, sa yɛ aalwoodal mɛbhwaa kam nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tɔ bot ɛ nadɛ emapa ee nabilel'enek ɔ, botom nadi ɛ́, bɛmil ɛtɛn (5 000). ");
INSERT INTO bkw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ààkobɔya bhii tak'enek, Yezu eezɛbesal bɛdjekel bɛ, bɛ ni tɔ elɛɛd, da bɛ ɛ́ tsaal, tɔ́ pɛ yii kyiid boo soob, pɛ kyee ghaada Bhɛtsaida. É di tak wat, nyɛy nyɛ ɛmet eezɛswaal zukamwaa nɛ bot binɔk, bɛ sik pɛ yɔbɔ. ");
INSERT INTO bkw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bhii nyɛ nasilal ɛswaal bɛ ɛ, nyɛ eezɛbyet kɔ ɛtsok, kɛdjaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dáa ɛgwyitok nabɛ, ye moo gwyiidela ɛ, elɛɛd nabɛ ɛ́ ye moo kuku dii. Tin, Yezu nalik ɛ nyɛ ɛmet pɛ kyiid. ");
INSERT INTO bkw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dáa nyɛ nabee náá, bɛdjekel bɛ nadi ezuk é ɛduk, etɛɛ náá, pup nadi bulal bɛ pɛ bhis ɛlyelɛpe ɛ. Tin, é pum dum nɛ mɛlem, nyɛ ɛ́ boozɛdu bɛ é kɛ kɔ dii nɛ mɛko, ye nabɛ ɛ́, nyɛ naawaadhaa bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Dáa bɛ nabee nyɛ é kɛ kɔ dii ɛ, bɛdjekel nagu ɛ́ náá, ye ɛ́ dim. Bɛ moo tin é tsim. ");
INSERT INTO bkw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Etɛɛ náá, dáa bɔɔ djas nabee nyɛ ɛ́, bɛbebwol naamɛt bɛ. Batsa deenek, nyɛ moo lii nɛ nɔɔ. Nyɛy náá: «Dika nɛ mɛghaaz. Ye ɛ́ mam! Nàdika nɛ bwoo.» ");
INSERT INTO bkw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bhii tak, nyɛ eezɛni tɔ elɛɛd. Tin, pup eezɛtyaala. Bɔ djas naadyeebadjoka ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ye nabɛ ɛ́, bɔɔ àànyɔ ɛmɛt ɛsuk ɛ mɛvyɛkɛlɛ mɛ nasael dum nɛ ɛbil ɛ emapa ɛ. Etɛɛ náá, bɛ nadi ɛ́, nɛ elyem e mɛso. ");
INSERT INTO bkw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bhii bɛ nasɛɛ dii ɛ, bɛ eezɛsel é ɛboŋ ɛ Ghenezalɛt. ");
INSERT INTO bkw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dáa bɛ nawyis tɔ elɛɛd ɛ, ààkobɔya deenek, bot eezɛgwyak Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tin, bot eezɛtɔ́ kɔ mɛl djas, nɛ é di djas kɛnɔɔ membel. Bɛ nadidi ebe-bɛp bɛ ɛ́, kɔ emwaala, tɔ́ é di djas bot nagwak lɛŋ ɛkwyil ɛ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","É di djas bɛ nadi etɔ́ ɛ́, kɔ mɛl, kɔ eghaada nɛ epɛt, bɛ nadi ezyɛ nɛ membel é di bot djas di esɛɛga ɔ. Bɛ nadi edjedjaala nɛ nɛ náá, nyɛ bet bɛ, bɔɔ bɛ ɛmet zokee-keeak ɛlɔ ɛ ndjookuwa yɛ pɛ si. Tin, bot djas namɛt nyɛ ɔ, naatsak. ");
INSERT INTO bkw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dhiiti dwoo eFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi naadus pɛ Yeluzalɛm, bɔɔ zokazɛsɛɛga bɛ nɛ Yezu, ");
INSERT INTO bkw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ye nabɛ ɛ́, bɛ naabee bɛdhiiti bɛdjekel ɛ Yezu nadi edɛ edee, ààgwyii mɛmbɔ dáa etsi di elyaal ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Etɛɛ náá, eFalizyɛ nɛ bot ɛ mbyak eYuda djas nadi ebaal etsi e bɛbhaab bɔɔ nalik ɛ ɛbuɛpe: bɛ ààdɛ edee, ààgwyii mɛmbɔ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Zɛnɔɔ náá, bɛ dus pɛ ndjando ɔɔ, bɛ aanàkwaadɛ edee, ààgwyia. Bɛ nadi eduwal bɛtɛ nɛ bɛdhiiti etsi e mbyak'ɔɔ, dáa vaŋ mbi ɛgwyii ebɛɛlɛ, nɛ ba bɔɔ mɛbhe mɛ dyak, zɛnɔɔ esaan. ");
INSERT INTO bkw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wɔ gwaa, eFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi zɛdji Yezu náá: «Étɛp yé bɛdjekel bɔ di ààsa dáa etsi e bɛbhaab binaka nalik ɛ, di elɛɛ ɛ? Bɛ dɛ ààgwyii mɛmbɔ mɔɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi ɛ́ bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Sa ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ dum nɛ nen ɛ, nabɛ ɛ́ tsɛɛtsɛ. Gwakeka sa di kwyala ɛ: “Zɛɛb ke ɛ́ náá, bot ɛ mbyak'ak duwal mɛ ɛ́ duwela mɛkɔŋ, elyem bɔɔ ɛ́ pɛ kyee sis. ");
INSERT INTO bkw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zɛɛga mendjaala mɔɔ, ye ɛ́ yii toto é mis mam, etɛɛ náá, mɛlyo mɛ bɛ di elyo ɛ́ mɛlyo mɛ epuud.”» ");
INSERT INTO bkw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Bhii tak, Yezu baazɛke náá: «Bi byen ɛ́ etsi e Zɛɛb, da bi ɛ́ kaduwal ɛ́, yii bot nalik bin yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","«Bi eezedhuugal etsi e Zɛɛb ɛlyelɛpe, étɛp ɛduwal etsi e mbyak'en! ");
INSERT INTO bkw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bela náá, ye nabɛ ɛ́ Moiiz eeke náá: “Dila soog nɛ nyoog” nyɛ nabaake pe ɛ́ náá: “Mot di ekal sɛɛg nɛ nyɛɛg ɔ, goka ɛ́ nɛ góaa”. ");
INSERT INTO bkw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yɛ kabɛ biyɔ ɔ, bi lɛɛ bot ɛ náá, mot ɛ́ nɛ ghwyil ɛke nɛ sɛɛg nɛ nyɛɛg náá: “Beea esa ee mɛ aadjɛ wɔ ɛ. Mɛ eekwom yɛ, mɛ needjɛ Zɛɛb ebuwa. Yenek lɛɛ ɛ́ Kɔbɔɔn.” ");
INSERT INTO bkw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Deenek, bi ààbet náá, nyɛ kwyee sɛɛg nɛ nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ye ɛ́ deenek ɛ bi di ehoola mɛkpa ɛ Zɛɛb étɛp ɛgoola etsi e mbyak'en. Zɛnɔɔ bɛtɛ nɛ mbi kɔkɔ esonok ee di esael ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wɔ gwaa Yezu baazɛdjóo ɛdhuu ɛ bot binɔk djas. Nyɛy nɛ nɔɔ náá: «Biyɔ djas, gwakeka mɛ. Mɛtka sa mɛ di elii'aak: ");
INSERT INTO bkw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ye tok nɛ sa di ni tɔ nuub mot di nɛ ghwyil ɛ pul edɛɛ e mot. Ye ɛ́ sa di ewyis tɔ lɛ ɛ di esa náá, mot nàdi dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Gwakeka ɛnyɔɛpe, bi ɛ́ di nɛ mɛlɔ mɛ ɛgwak etɛp ɔɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Dáa Yezu nadus tin ɛ, bɛ eezɛni tɔ ndjaa ɛtsetaɛpe nɛ ɛdhuu ɛ bot, bɛdjekel bɛ zokazɛdji nyɛ sa ɛsuk ɛ kana yenek nadi ekwyɛl ɛlɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Dɔɔ nɛ biyɔ, bi tok nɛ etsoŋ ɛtiibal é? Bi ààgu náá, sa mot di ewa tɔ nuubɛ ɛ́, yɛ aanàkwaapul edɛɛ e mot e? ");
INSERT INTO bkw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Esesɛɛ binek ààni tɔ lyem; ye ni ɛ́ tɔ mɔ'ɛ. Bhii tak, nyɛ kakɛsaaz yɛ ɛ tɔ ɛbyeed.» Tɔ mɛlyo menek Yezu nadi ekwyɛl ɛlɛɛ ɛ́ náá, edee djas goka ɛ́ nɛ ɛdɛel. ");
INSERT INTO bkw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Bhii tak, nyɛ eebaazɛke náá: «Ye ɛ́ sa di wyis tɔ mot ɛ di pul edɛɛ e mot tak. ");
INSERT INTO bkw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Etɛɛ náá, mbee egeka dus ɛ́ tɔ lyem mot. Ye ɛ́ esiiza ɛ di lwom bot náá, bɛ sa ɛpam, djii nɛ ɛgo ɛ bot, ");
INSERT INTO bkw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɛsa ɛ ɛzɔ, dɔɔb epata, mbee lyem, mɛkɔŋ, mɛba mbɛs, ɛwyeeb ɛ esa e baa, ebyas, ɛbet, mɛlyet. ");
INSERT INTO bkw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Esesɛɛ binek djas, egeka tak dus ɛ́ tɔ elyem e bot. Ye ɛ́ di esa náá, edɛɛ e mot pulel é mis ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yezu zɛdus tin, tɔ pɛ kyee dik eghaada Tiid. Nyɛ eezɛni tɔ dhiiti ndjaa, nyɛ nabɛ ɛ́ ààkwyɛl náá, bot gu náá, nyɛ ɛ́ tin. Ye nabɛ ɛ́ ààdjala náá, mot dáa nyɛy di sɔ. ");
INSERT INTO bkw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tin, ye nabɛ ɛ́ nɛ dhiiti moma, mbee sisim nadi edhek mɔn ɛsyes ɛ lɛ ɔ. Dáa nyɛ nagwak menduk ɛ Yezu ɛ, nyɛ eezɛzyɛ kaab pɛ daa lɛ, nyɛ zokazɛkwyit mɛboŋ si, sok bhwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Moma tak nabɛ ààbɛ moma mbyak eYuda. Nyɛ nabyel ɛ́ pɛ dɛl ɛ Fenisi pɛ kyee dik Siili. Nyɛ eezɛdjaala nɛ Yezu náá, nyɛ sɔ mbee sisim nadi tɔ nyel mɔn'ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Beta, bɔn pookodɛ, djil. Etɛɛ náá, mapa bɔn goka ɛ́ nɛ ɛdɛ ɛ, yɛ àànyɔ, ye mwasaa, djɛaa bɔn bɛbhyɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Wɔ gwaa moma yenɔk baazɛpesal náá: «Ghɛŋ, wɔ ɛ́ nɛ gham. Ye goka ɛ́ wɔ gu náá, bɔɔ bɛbhyɛ di si mesa ɔ, bɛ dɛ ɛ́ bɔɔ eghutu-ghutu emapa ee bɔn di kwyital é ghɛŋ bɛ di edɛ kɔ mesa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tin, Yezu eezɛke nɛ moma yenɔk náá: «Wɔy, moma, dum nɛ yala yɔ, sika pɛ ndjaŋ'ɔ. Mbee sisim tak eezewyis tɔ nyel ɛsyes ɛ lɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wɔ gwaa, nyɛ zɛsik pɛ ndjaŋ'ɛ. Tin, nyɛ eekɛbela mɔn'ɛ ndjaasi kɔ goŋ, mbee sisim eezewyis tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bhii tak, Yezu eezɛdus pɛ kyee dik Tiid, zɛdhaa tɔ́ pɛ boo ghaada Sidɔn, zɛtsaal yii kyee bɔs mɛdhik mɛ eghaada kam, étɛp nyɛ neetɔ́ pɛ kyee boo soob na djato-djato Ghalile. ");
INSERT INTO bkw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wɔ gwaa, bɛ zɛzyɛ nyɛ nɛ mot na endiila e mɛlɔ, àànyɔ ɛgu ɛlii ɛnyɔɛpe. Bɛ eezɛdjaala nɛ nɛ náá, nyɛ kɛl nyɛ mɛmbɔ, nyɛ neetsak. ");
INSERT INTO bkw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tin, wɔ gwaa, Yezu zɛnɔɔ mot tak, tiila nɛ nɛ ba ɛtsetaɛpe nɛ ɛdhuu ɛ bot. Bhii tak, nyɛ eezɛwa mot tak bhin tɔ mɛlɔ. Nyɛ eezɛsɛɛ mɛtel, zɛmɛt nyɛ djem nɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bhii tak, nyɛ eezɛben mis pɛ ɛko, nyɛ eezɛso bhiyo. Nyɛy nɛ mot'enɔk náá: «Effata!» Ye kwyɛl ɛlɛɛ náá: «Bɛŋela!» ");
INSERT INTO bkw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","É di'enek wat, mɛlɔ mɛ mot tak eezɛbɛŋel; djem pe eezɛtiŋel. Nyɛ moo elii ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yezu zɛlɛɛ nɛ bot binɔk djas náá, sa mot ààlɛɛ mot ngɔt sa sael wak ɛ, yenek nadhedhɛɛg bot ɛ dhɛɛga. Lyaka nyɛ nadi é lelyak bot ɛ, nabebesal bot ɛ́ beselak. ");
INSERT INTO bkw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bot naadyeebadjoka dhaa nyel. Bɔɔ náá: «Esa ee nyɛ di sa djas ɛ́ ɛnyɔɛpe! Nyɛy batabɛɛ mɛlɔ mɛ bɛ na endiila e mɛlɔ, ebubu batalii!» ");
INSERT INTO bkw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tɔ mɛlu menek, boo ɛdhuu ɛ bot naabaazɛsɛɛga é ngwoob ɛ Yezu. Dáa bɛ nadi ààdɛ ɛ, nyɛ ɛ́ boozɛdjóo bɛdjekel bɛ, nyɛy nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«“Ha” kpaa-ghoŋ nɛ bot bak! Bɛ moo mena nɛ bɛ nɔɔ mos ɛ́ mɛlu mɛlɛl, bɛ tokapɛ nɛ edee e dek. ");
INSERT INTO bkw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mɛ swaal bɛ pɛ mendjaa mɔɔ tɔ emɔ toto ɔɔ, bɛ waazuk é ze. Etɛɛ náá, mɛl mɛ bɛdhiiti nɛ tseta.» ");
INSERT INTO bkw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bɛdjekel bɛ eezɛbɔɔza nɛ nɛ náá: «Mena belaka edee ee bot bak djas aadɛ djil ɛ paa, menabɛl ɛ́ dika kuku kakoŋ'aak?» ");
INSERT INTO bkw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yezu eezɛdji bɛ náá: «Bi ɛ́ nɛ emapa edhen?» Tin, bɛ eebaazɛbɔɔza nɛ Yezu náá: «Etɛn nɛ ebá.» ");
INSERT INTO bkw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tin, nyɛ ɛ́ boozɛlɛɛ nɛ ɛdhuu ɛ bot djas, bɛ disi é bɔs. Bhii tak, nyɛ eezɛnɔɔ emapa etɛn nɛ ebá binek, zɛghaapɛɛ Zɛɛb. Bhii tak, nyɛ eezɛpyak yɛ ebil-ebil, zɛkanɔɔ, djɛ bɛdjekel bɛ, bɛ neekaa bot djas. Bɔɔ sa deenek. ");
INSERT INTO bkw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ye nabaadi ɛ́, nɛ ba bɔɔ bɛsu. Yezu eezɛnɔɔ yɛ, ghaapɛɛ Zɛɛb, bhii tak nyɛ eedjɛ bɛdjekel bɛ, bɛ kaa. ");
INSERT INTO bkw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mot nɛ mot nabɛ ɛ́ nyɛ naadɛ, djil, bɛdjekel bula nɛ mɛbhubhwak bɛbhwaŋ ɛtɛn nɛ ebá. ");
INSERT INTO bkw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","É di tak, bot nadi ɛ́, tyee bot bɛmil ɛná (4 000). Bhii tak, Yezu zɛswaal bɛ, bɛ sik pɛ mɛl mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","É di'enek wat, nyɛ eezɛni tɔ elɛɛd bɛ nɛ bɛdjekel bɛ, zɛtɔ́ pɛ kyee dik Dalmanuta. ");
INSERT INTO bkw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tin, eFalizyɛ eezɛkum pɛ Yezu nadi ɛ́, bɛ moo be mɛso, bɛ nɛ bɛ nɔɔ. Bɛ nadikwyɛl ɛlóo ɛ nyɛ pɛ ɛko, da ɛ́ bwood nyɛ pɛ kiyɛ. Bɔɔ nɛ nɛ náá, nyɛ sa bɛdhiiti ndem mɛbwala mɛ di edus tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tin, Yezu eezɛsyel nyel «wɔyɔŋ». Nyɛ ɛ́ boozɛke náá: «É tɛp yé bot ɛ mɛlu mak di esaa endem e mɛbwala? Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: bi aanàkwaabee!» ");
INSERT INTO bkw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yezu zɛdus é di'enek, ni tɔ elɛɛd, sɛɛ dii, tɔ́ pɛ yii kyiid. ");
INSERT INTO bkw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ye nabɛ ɛ́, bɛdjekel eedjisa ɛnɔɔ emapa. Tin, tɔ elɛɛd bɛ nazodi ɛ́, nɛ mapa wat ɛ djin. ");
INSERT INTO bkw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yezu eezɛdul bɛ mɛlɔ. Nyɛy nɛ nɔɔ náá: «Biyɔ bak! Bi ɛ́ kobaka nɛ leviid eFalizyɛ nɛ leviid Elood.» ");
INSERT INTO bkw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bɛdjekel moo tin elii pak'ɔɔ náá: «Nyɛ ke deenek ɛ́, etɛɛ náá, mena ààpazyɛka nɛ emapa!» ");
INSERT INTO bkw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dáa Yezu gwak deenek ɛ, nyɛ eezɛdji bɛ náá: «Bi gwyɛ yé? Etɛɛ náá, bi tok nɛ emapa? Bi dinaa ààpaasiiza ɛnyɔɛpe? Bi tok nɛ etsoŋ é? ");
INSERT INTO bkw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bi ɛ́ nɛ mis, bi ààbee? Bi ɛ́ nɛ mɛlɔ, bi ààgwak é? Bi ààtaala? ");
INSERT INTO bkw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","É sok mɛ napyak emapa etɛn dwoo tak, da ɛ́ djɛ bot bɛmil ɛtɛn, bɔɔ dɛ, djil ɛ, bɛbhwaŋ ɛdhen nabwak nɛ bɛtɛɛ nɛ ebil emapa tɔ tak?» Wɔ gwaa bɛ bɔɔza nɛ nɛ náá: «Kam nɛ ebá.» ");
INSERT INTO bkw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yezu eebaadji náá: «É dwoo mɛ nabaapyak emapa etɛn nɛ ebá, djɛ bot bɛmil ɛná ɛ, bɛbhwaŋ ɛdhen nabwak nɛ bɛtɛɛ nɛ ebil emapa tɔ tak?» Bɔɔ náá: «Ye nabwak ɛ́ bɛbhwaŋ ɛtɛn nɛ ebá.» ");
INSERT INTO bkw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bhii tak, Yezu eezɛke nɛ nɔɔ náá: «Bhis yenek bi ààgu sa ye di kwyɛl ɛlɛɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bɛ eezɛkum pɛ Bhɛtsaida. Tin, bɛ eezɛzyɛ Yezu nɛ mot edhim, bɔɔ náá, nyɛ mɛt nyɛ étɛp nyɛ neetsik nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yezu eezɛmɛt mot edhim binɔk é mbɔ, tɔ́ nɛ nɛ ba ɛtsetaɛpe nɛ dɛl. Nyɛ eezɛsɛɛ mɛtel, lɔɔb nyɛ yɛ é mis. Bhii tak, nyɛ eekɛl nyɛ mɛmbɔ, nyɛ eezɛdji nyɛ náá: «Wɔ ɛpebee sonok é?» ");
INSERT INTO bkw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mot edhim binɔk eezɛben mis pɛ ɛko. Nyɛy náá: «Mɛ ɛpebee bot! Mɛ bee bɛ ɛ́, dáa ele, bɛ ɛpekɛ!» ");
INSERT INTO bkw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yezu eebaazɛkɛl mɛmbɔ kɔ mis mɛ mot tak. Bhii tak, nyɛ moo zɛbee ɛnyɔɛpe, nyɛ eezɛtsak. Tin, nyɛ moo bee «popoopwon». ");
INSERT INTO bkw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bhii tak, Yezu eezɛke nɛ nɛ, nyɛ sik pɛ ndjaa, nyɛ eezɛke nɛ nɛ náá: «Sa wɔ ààtuula kɔ dɛl.» ");
INSERT INTO bkw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bhis'enek, Yezu bɛ nɛ bɛdjekel bɛ eezɛtɔ́ pɛ kyee mɛl mɛ di é ngwoob kyee dɛl Sezaade ɛ Filip ɛ. Ze ɛ ze dáa bɛ nadi kɛ ɛ́, nyɛ eezɛdji bɛ náá: «Bot ke náá, mam ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bɔɔ náá: «Bɛdhiiti ke ɛ́ náá, wɔ ɛ́ Zaŋ Nduuel-bot. Bak náá: Wɔ ɛ́ Eli. Yɛ kabɛ yak pak bot ɔ, bɔɔ ke ɛ́ náá, wɔ ɛ́ ngɔt tɔ bɛngoolel ɛ mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yezu eezɛke nɛ nɔɔ náá: «Yɛ kabɛ biyɔ ɔ, bi ke náá, mam ɛ́ zɛ?» Pyɛɛd eezɛbɔɔza: «Wɔ ɛ́ Mɛsia ɛ Zɛɛb nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Deenek Yezu eezɛdul bɛ mɛlɔ ɛlyelɛpe náá, sa bɛ ààlɛɛ bot. ");
INSERT INTO bkw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bhis'enek nyɛ moo lyo bɛdjekel bɛ náá: «Ye goka ɛ́ Sɛɛŋɛlɛ Mɔn Mot zukaa ɛbuɛpe. Bɛpaa ɛ eYuda, nɛ eboo bɛghaa-Zɛɛb, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi ɛ́ waabhina nyɛ. Nyɛ waagóaa. Mɛlu mɛlɛl bhis ɛsyee ɛ lɛ, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nyɛ nalelɛɛ bɛ etɛp binek djas ɛ́ «mɛpyɛmɛ», ààsyel sonok wat. Dáa Pyɛɛd nagwak deenek ɛ, nyɛ eezɛdul nyɛ é ngwoob. Nyɛy nɛ nɛ náá: «Nàke deenek.» ");
INSERT INTO bkw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bhii tak, Yezu zokazɛbulal mis, gwyák bɛdjekel bɛ. Tin, nyɛ eezɛbiyo, zɛke nɛ Pyɛɛd náá: «Satan, dusa é mis mam etɛɛ náá, egeka bɔ tok egeka e Zɛɛb. Ye ɛ́ yii bot ɛ epuud!» ");
INSERT INTO bkw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bhii tak, wɔ gwaa, Yezu zɛdjóo ɛdhuu ɛ bot, dɔɔ nɛ bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Yɛ bɛ náá, mot ɛpekwyɛl ɛdu mɛ ɔɔ, nyɛ kat ɛkwyɛɛg ɛ nyel'ɛ, nyɛ bɛp mɛlaaba mɛ, da nyɛ ɛ́ du mɛ. ");
INSERT INTO bkw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Etɛɛ náá, mot ɛ́ di esaa ɛtsik ɛ nyel'ɛ ɔɔ, nyɛ waasu yɛ. Yɛ kabɛ mot aamyaal ɛsu ɛ́ tsik'ɛ kɔ ɛsu ɛ lam, nɛ kɔ ɛsu ɛ Mbɛɛ Bhaadal ɔɔ, nyɛ waabela tsik. ");
INSERT INTO bkw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ye ɛ́ tɛtɛ ye, wɔ bela mɛvu mɛ bɔs'ak djas, da wɔ ɛ́ su tsik na kɔm-kɔm? ");
INSERT INTO bkw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tɛtɛ yaa mbi sa mɛtaŋ etuud mot aadjɛ étɛp wɔ neebɔm tsik? ");
INSERT INTO bkw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mot ɛ́ gwak sen nɛ nam, nɛghu nɛ mɛkpa mam, é mis mɛ bot ɛ mesyem nɛ bot ɛ di ààkaab Zɛɛb é mɛlu mɛ mena dika mos'aak ɔɔ, tin, Sɛɛŋɛlɛ Mɔn Mot ɛ́ waadi nɛ sen nɛ nɛ é ghɛŋ nyɛ aazyɛ zɛɛga nɛ efofop bɛ tɔ duma Sɛɛg ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wɔ gwaa Yezu baazɛke náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Bɛdhiiti bot tɔ sama bi di'aak aanàkwaagwyɛ, bɔɔ ààbee dáa Ɛyoŋ ɛ Zɛɛb aazyɛ nɛ eghɛŋ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bhii ye nadhaa tyee mɛlu mɛtɛn nɛ wat ɛ, Yezu eezɛnɔɔ Pyɛɛd, nɛ Zak zɛnɔɔ Zaŋ, nyɛ zokazɛbyet nɛ nɔɔ kɔ boo ɛtsok pɛ bɛ nadi bɔɔ bɛ ɛmet ɛ. Nyɛ zokazɛswoola bhwoob é mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ekaad bɛ moo puu ɛkasɛpe, mbi mɛkas mɛ wat di ààbɛ nɛ mbi sonok gekaa nɛ yɛ pɛ kɔ bɔs ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Batsa deenek, bɛdjekel kasɛka ɛ́ Eli bɛ nɛ Moiiz moo lɛɛ elɛŋ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wɔ gwaa, Pyɛɛd zɛke nɛ Yezu náá: «Lyoel, ɛnyɔ náá, mena dika wak. Djhoosumka epɛt elɛl: wat yɔ, yak yɛ Moiiz, dhiiti wat yɛ Eli.» ");
INSERT INTO bkw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nyɛ nadi ɛ́, ààgu sa nyɛ nadi elii ɛ́, etɛɛ náá, bɛbebwol naadyeebamɛt bɛ nɛ bɔn nyɛɛg ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eguud zokazɛsul, wɔ gwaa, ye zɛkala kɔ lɔɔ, butal bɛ. Tɔ eguud binek, wɔ gwaa dhiiti gwood zɛgék, é ke náá: «Nwyak ɛ́ mɔn'am mɛ dyeebakwyɛl ɔ. Bi ɛ́ gwak nyɛ!» ");
INSERT INTO bkw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","É di'enek wat, bɛdjekel moo tin é gwyák é mengwoob mɔɔ, bɛ kadi ɛ́, ààkabaabee mot. Ye nazokalik ɛ́ Yezu nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dáa bɛ nadi ewyeed ɛtsok ɛ, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Sa mot ààlɛɛ mot sa bi bee ɛ, kana dwoo ɛlak mos, kɛyaka nɛ dwoo Sɛɛŋɛlɛ Mɔn Mot aagom ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bɛ naamɛt mɛkpa menek djas, bɛ moo tin esɔs pak'ɔɔ náá: «Nyɛ kwyɛl ɛlɛɛ yé dum nɛ “ɛgom bhis ɛsyee”?» ");
INSERT INTO bkw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhii tak, bɛ eezɛdji Yezu náá: «Étɛp yé bɛghaŋ ɛ mɛkana mɛ etsi di elɛɛ náá: ye goka ɛ́ Eli pookonyɛl ɛzyɛ ɛsok?» ");
INSERT INTO bkw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Tsɛɛtsɛ, ye goka ɛ́ náá, Eli pookozyɛ ɛsok étɛp nyɛ neezɛkoobal esesɛɛ djas. “Haa”, étɛp yé ekwyala ɛ Zɛɛb di baalɛɛ náá, ye goka, Sɛɛŋɛlɛ Mɔn Mot zukaa ɛlyelɛpe, náá nyɛ waabhinaa? ");
INSERT INTO bkw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yɛ bɛ mam ɔɔ, betka mɛ lɛɛ bin náá: Eli eezezyɛ, kabela ɛ́, bot eesa nyɛ dáa bɛ nakwos ɛ, dáa mɛkpa ɛ Zɛɛb di ekwyala, dum nɛ nɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dáa bɛ nakakum é di bɛdhiiti bɛdjekel nalik ɔ bɛ kabela ɛ́, zukamwaa nɛ mot, nɛ bɛghaŋ ɛ mɛkana mɛ etsi kuku ɛbwak é suu mɛso. ");
INSERT INTO bkw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Beea bot nabee Yezu ɛ, ye nabɛ ɛ́, bɛ naadyeebadjoka, bɛ eezɛsum ekaab, bɛ neekɛ swos nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yezu eezɛdji bɛdjekel bɛ náá: «Ye ɛ́ mɛso mɛ yé bi di esuu, bi nɛ bɛ nɔɔ?» ");
INSERT INTO bkw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wɔ gwaa mot ngɔt tɔ ɛdhuu ɛ bot binɔk zɛke nɛ nɛ náá: «Lyoel, mɛ eezyɛ nɛ mɔn'am etɛɛ náá, mbee sisim ɛpedhek nyɛ, nyɛ ààlii. ");
INSERT INTO bkw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mbee sisim tak zoghɛɛ nyɛ é edi djas, ghɛɛg nyɛ é bɔs, mɛwyil é nuub, mɔn kwaal mɛtsok, mɔn nyel kaada dáa muu. Mɛ ɛ́ booke nɛ bɛdjekel bɔ náá, bɛ sɔ mbee sisim tak. Bɛ ààpakwak yɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tin, wɔ gwaa Yezu zɛke nɛ nɔɔ náá: «Bi ɛ́ bot ɛ di ààdum koŋ nɛ Zɛɛb ɔ! Mena kalikeka é di wat mɛlu mɛdhen? Ye kabaalik mɛlu mɛdhen mɛ di egoka nɛ ɛmaad ɛ bin? Dhaaka mɛ nɛ mɔn'enɔk wak.» ");
INSERT INTO bkw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhii tak, bɛ eezɛzyɛ nyɛ nɛ mɔn tak. Beea mbee sisim nabee Yezu ɛ, wɔ gwaa, nyɛ zɛdheeg mɔn'enɔk ɛlyelɛpe «buku-buku». Nyɛ eezɛghaaga si, nyɛ moo boola si, mɛdheed ewyis é nuub. ");
INSERT INTO bkw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tin, Yezu eezɛdji sɛɛg mɔn'enɔk náá: «Mɔn'ak moo nɛ ɛbil ɛbɛ́ ɛlak mos mɛlu mɛdhen?» Sɛɛg mɔn nɛ nɛ náá: «Kana edhɔma bɛ, kɛyaka nɛ dwoo pan mos'ak. ");
INSERT INTO bkw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","É dhiiti tyɛ, mbee sisim ɛpezyeegal nyɛ tɔ du, yak tyɛ tɔ dii étɛp nyɛ neegwyɛ. “Yaayee!” Geka bis ghoŋ, tsika bis, wɔ di nɛ ghwyil ɛsa ɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wɔ gwaa Yezu zɛbɔɔza nɛ nɛ náá: «Étɛp yé wɔ ke náá: “Wɔ di nɛ ghwyil ɛsa ɔɔ.” Ghuna ye ɛ́ náá, mot ɛ dum koŋ nɛ Zɛɛb ɔɔ, esa djas nyɛ aawaab ɛ, nyɛ waabela.» ");
INSERT INTO bkw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","É di'enek wat, sɛɛg mɔn'enɔk eezɛtsim ɛlyelɛpe. Nyɛy náá: «Mɛ eedum koŋ. Kwyeea mɛ etɛɛ náá, mɛ neewa lyem tɔ ɛmyaal ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dáa Yezu nabee ɛdhuu ɛ bot ezyɛ ekaab pɛ kyee bɛ nadi ɛ́, nyɛ eezɛbhɛm mbee sisim. Nyɛy nɛ nɛ náá: «Wɔy sisim di ediyal bot mɛlɔ nɛ enuub ɔ, ye ɛ́ mam ɛ di eke nɛ nɔ náá: Wyisa tɔ nyel mɔn'ak. Sa wɔ ààbaabula tɔ lɛ!» ");
INSERT INTO bkw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wɔ gwaa, mbee sisim zɛbo boo tsim, zɛdheeg mɔn'enɔk ɛlyelɛpe. É di tak, mbee sisim tak eezɛwyis, mɔn tak moo tin dáa muu, sa náá, bot ɛ nadi tin ɔ, ke náá: «Nyɛ eegwyɛ!» ");
INSERT INTO bkw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tin, Yezu eezɛmɛt nyɛ é mbɔ, zɛwyɛl nyɛ, mɔn tak eezɛtyaa tetel. ");
INSERT INTO bkw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","É sok Yezu nazɛni tɔ ndjaa bɛ nɛ bɛdjekel bɛ bɔɔ bɛ ɛmet ɛ, bɛdjekel eezɛdji nyɛ náá: «Étɛp yé bis di ààkwak ɛsɔ mbee sisim tak?» ");
INSERT INTO bkw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mbi esisim binek wyis ɛ́, ye ɛ́ bɛ náá, wɔ nɛ djaala Zɛɛb ɛbuɛpe ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bɛ eezɛdus tin, wɔ gwaa, bɛ zɛtsaal kyee dik Ghalile djas. Yezu nabɛ ààkwyɛl náá, bot gu pɛ nyɛ nadi ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Etɛɛ náá, nyɛ nadi elyo bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Sɛɛŋɛlɛ Mɔn Mot ɛ́ waakaaa é mɛmbɔ mɛ bot ɛ mesyem. Bhii tak, bɛ waagó nyɛ. Mɛlu mɛlɛl bhii tak, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tin, bɛdjekel nabɛ ɛ́, ààmɛt lo etɛp ee nyɛ nadi elɛɛ bɛ ɛ. Bɛ nadi ɛ́, nɛ bwoo ɛdji nyɛ etɛp binek djas. ");
INSERT INTO bkw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɛ eezɛkum pɛ Kapɛlnaum. Dáa bɛ nadi tɔ ndjaŋ ɛ, Yezu eezɛdji bɛdjekel bɛ náá: «Mɛso mɛ yé bi di esuu ze ɛ ze?» ");
INSERT INTO bkw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bɔɔ djas «kup», ààlii, bela tin náá, ze ɛ ze bɛ nadi esuu mɛso dum nɛ etooba. ");
INSERT INTO bkw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tin, Yezu eezɛdisi, bhii tak, nyɛ eezɛdjóo bɛdjekel bɛ kam nɛ bɛbá. Nyɛy nɛ nɔɔ náá: «Mot ɛ kwyɛl etooba ɔɔ, ye goka ɛ́ nyɛ di mot ɛbhis tɔ bɛsɔ djas. Nyɛ di mot-mɛsa mɛ bɛsɔ djas.» ");
INSERT INTO bkw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bhii tak nyɛ eezɛnɔɔ dhiiti mɔɔ dhyeeb, nɛɛg nyɛ kuku ɛbwak ɛ lɔɔ. Nyɛ eezɛbeedal nyɛ. Bhii tak, nyɛ eezɛke nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Mot aamyaal mɔɔ dhyeeb dáak kɔ ɛsu ɛ kwyɛl nyɛ di nɛ yɛ nɛ nam ɔɔ, ye ɛ́ mam mɛ ɛmet ɛ nyɛ myaal. Mot aamyaal mɛ ɔɔ, nyɛ ààpamyaal mam mɛ ɛmet. Nyɛ myaal ɛ́ dɔɔ nɛ mot nadhis mɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zaŋ eezɛke nɛ Yezu náá: «Lyoel, bis eebee dhiiti mot esɔ embee esisim nɛ din ɛ lɔ. Bis eekoolyak nyɛ, etɛɛ náá, nyɛ ààkɛ lɔɔg wat mena nɛ bɛ nɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tin, Yezu zɛbɔɔza nɛ nɔɔ náá: «Sa mot ààlyak nyɛ, etɛɛ náá, ye tok nɛ mot aasa endem e mɛbwala nɛ din ɛ lam é di'enek wat, da nyɛ ɛ́ byak mɛ. ");
INSERT INTO bkw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Etɛɛ náá, mot ɛ́ di ààbhina mena ɔɔ, nyɛ ɛ́ mot'ena. ");
INSERT INTO bkw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Nɛ mot aazodjɛ bin djɛak nɛghu bɛɛlɛ mɛdii mɛ wat etɛɛ náá, bi ɛ́ bot ɛ Mɛsia ɔ, nyɛ waabela boo etuud.» ");
INSERT INTO bkw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Mot ɛ́ di tyee boo ɛbɛk étɛp ɛkɔa tɔ mesyem ngɔt tɔ bɔn di dum koŋ nɛ nam ɔ, ye goka ɛ́ náá, bɛ tsel nyɛ boo ɛkok é tsuŋ, da bɛ ɛ́ lóo nyɛ tɔ dii mɛsɔn. ");
INSERT INTO bkw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yɛ bɛ náá, mbɔ'ɔ di esa náá, wɔ kwyit mɛlu djas tɔ mesyem ɔɔ, tsaala yɛ. Ɛnyɔ náá, mot ni tɔ tsik na kɔm-kɔm nɛ mbɔ tsaala. Ɛbiyo kabɛ ɛ́ náá, wɔ di nɛ mɛmbɔ mɛmbá, da wɔ ɛ́ su tsik, da wɔ ɛ́ tɔ́, kɛdyak tɔ du na kɔm-kɔm.  ");
INSERT INTO bkw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pɛ tɔ di di náá, elum ààgwyɛ ɛ, é di di náá, ngel du ààdim ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yɛ bɛ náá, ko'ɔ di esa náá, wɔ gheekwye-kwyɛ mɛlu djas tɔ mesyem ɔɔ, ye goka ɛ́, wɔ tsaal yɛ. Ɛnyɔ náá, mot ni tɔ tsik na kɔm-kɔm nɛ ko tsaala. Ɛbiyo kabɛ ɛ́ náá, wɔ di nɛ mɛko mɛmbá, da wɔ ɛ́ su tsik, da wɔ ɛ́ tɔ́, kɛdyak tɔ du na kɔm-kɔm.  ");
INSERT INTO bkw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yɛ bɛ náá, dis ɛ lɔ ɛ́ di esa náá, wɔ gheekwye-kwyɛ mɛlu djas tɔ mesyem ɔɔ, ye goka ɛ́, wɔ dis yɛ. Ɛnyɔ náá, mot ni tɔ Ɛyoŋ ɛ Zɛɛb nɛ dis wat. Ɛbiyo kabɛ ɛ́ náá, wɔ di nɛ mis mɛmbá, da wɔ ɛ́ su Ɛyoŋ ɛ Zɛɛb, da wɔ ɛ́ tɔ́, kɛdyak tɔ du na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pɛ tɔ di di náá, “elum ààgwyɛ ɛ́, é di di náá, ngel du ààdim ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tin, yɛ aadi ɛ́, bot djas moo egwom zam du. ");
INSERT INTO bkw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«Mɛsɔn ɛ́ mbɛɛ sonok. Yɛ bɛ náá, mɛsɔn moo ɛ́, ààkagwom ɔɔ, “haa” ye saaa dáa, étɛp ye neebaagwom? Dika nɛ mɛsɔn tɔ len, da bi ɛ́ gwakel nɛ bot djas.» ");
INSERT INTO bkw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yezu eezɛtɔ́ pɛ kyee dik Yude, pɛ yii kyiid dii Yuldɛn. Wɔ gwaa, zukamwaa nɛ mot baazɛsɛɛga tin, nyɛ moo baazɛlyo bɛ dáa nyɛ nazezyɛ nɛ ɛsesa sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bɛdhiiti eFalizyɛ eezɛtiila pɛ daa lɛ, étɛp bɛ neelóo nyɛ pɛ ɛko, bwood nyɛ pɛ kyɛ. Bɛ eezɛdji nyɛ náá: «Etsi bina ɛpemyaal náá, mot pɛɛ myɛl é?» ");
INSERT INTO bkw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yezu kabɔɔza nɛ nɔɔ tɔ kiya náá: «Moiiz nakodjɛ bin yaa tsi?» ");
INSERT INTO bkw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɛ eezɛbɔɔza nɛ nɛ náá: «Moiiz nake ɛ́ náá, motom kwyal mɛkana mɛ di lyaal náá, nyɛ eepɛɛ myɛl ɛ. Bhii tak, nyɛ ɛ́ nɛ ghwyil ɛpɛɛ myɛl.» ");
INSERT INTO bkw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Deenek Yezu eezɛke nɛ nɔɔ náá: «Moiiz nakwyal deenek ɛ́, étɛp'en etɛɛ náá, bi nɛ dyeebalyel elyem. ");
INSERT INTO bkw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mena bee é ghɛŋ Zɛɛb nakus bɔs ɔ, “Nyɛ nasaa ɛ́ motom nɛ moma”, ekwyala lɛɛ ɛ́ deenek. ");
INSERT INTO bkw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Étɛp tak ɛ́ di náá, motom ɛ́ waalik sɛɛg nɛ nyɛɛg, kɛsɛɛga nɛ myɛl. ");
INSERT INTO bkw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bhii tak, bɔɔ bɛbá kadi ɛ́, bɛ moo mot ngɔt.” Tin, bɛ tokapɛ bot ɛbá; bɛ moo ɛ́ mot ngɔt. ");
INSERT INTO bkw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tin, sa mot ngɔt ààbo sa Zɛɛb sɛɛg ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","É sok bɛ nazɛni tɔ ndjaŋ ɛ, wɔ gwaa bɛdjekel baazɛdji Yezu mɛdjin dum nɛ tɛp tak. ");
INSERT INTO bkw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Mot ɛ́ pɛɛ myɛl, da nyɛ ɛ́ kɛba moma sis ɔɔ, nyɛ ɛ́ mot mɛzɔ etɛɛ náá, bɛ nɛ moma mɛgwyak dinaa mot ngɔt. ");
INSERT INTO bkw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tyee wat nɛ moma. Nyɛ byen ngom, da nyɛ ɛ́ myaal ɛtɔ́, kɛba motom sis ɔɔ, nyɛ sa ɛ́ ɛzɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bot zokazyɛ Yezu nɛ bɔɔ dhyeeb étɛp nyɛ neekɛl bɛ mɛmbɔ. Tin, bɛdjekel eezɛbhɛm bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dáa Yezu nabee deenek ɛ, lyem naakpaa nyɛ. Bhii tak nyɛ eezɛke nɛ bɛdjekel bɛ náá: «Betka bɔɔ dhyeeb zyɛ pɛ daa lam! Nàluka bɛ etɛɛ náá, Ɛyoŋ ɛ Zɛɛb ɛ́, étɛp bot ɛ di tyee bɔɔ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Mot ɛ di ààmyaal Ɛyoŋ ɛ Zɛɛb dáa mɔɔ dhyeeb ɔɔ, nyɛ aanàkwaani tɔ tak.» ");
INSERT INTO bkw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bhii tak, nyɛ eezɛghɛɛ mɔn ngɔt, nyɛ moo tin ekɛl mɛmbɔ kɔ bɔn binɔk, esɛɛ bɛ mɛtel. ");
INSERT INTO bkw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yezu gba ɛ gba, nyɛy kuku kyeed, dhiiti mot zokazyɛ nɛ kaab, zɛkwyit mɛboŋ si, si mɛko mɛ. Nyɛy nɛ nɛ náá: «Mbɛɛ lyoel, mɛ goka nɛ ɛsa dáa étɛp mɛ neebela tsik na kɔm-kɔm?» ");
INSERT INTO bkw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yezu eezɛbɔɔza nɛ nɛ náá: «Étɛp yé wɔ di edjóo mɛ mbɛɛ lyoel? Ye tok nɛ mbɛɛ mot kɔ bɔs'ak bhii Zɛɛb nyɛy nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wɔ nɛ gu etsi djas: “Sa wɔ ààgó mot, sa wɔ ààsa mɛzɔ, sa wɔ ààdjii sa mot, sa wɔ ààlɛɛ elɛŋ e etsal dum nɛ mot, sa wɔ ààsa sa ɛbiyo nɛ mot, duwala soog nɛ nyoog.”» ");
INSERT INTO bkw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mot'enɔk eezɛbɔɔza nɛ nɛ náá: «Lyoel, etsi binek djas mɛ nɛ duwal yɛ, kana edhɔma bam, kɛkum dwoo pan mos'ak.» ");
INSERT INTO bkw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yezu eezɛgwyák nyɛ nɛ lyem mɛkwyɛla. Nyɛ eezɛke nɛ nɛ náá: «Ye zokalik wɔ ɛ́, wɔ sa sa wat: Tɔ́a, kɛbɔmsa esa bɔ djas, da wɔ ɛ́ nɔɔ epata e tak, djɛ bɛdjel ɛ bot, tin, wɔ waabela mɛvu tɔ gwoo, bhii tak da wɔ ɛ́ zɛdu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dáa mot ekum'enɔk nagwak deenek ɛ, ye nabɛ ɛ́, mɛkpa menek naatek nyɛ nyel «wɔyɔŋ». Nyɛ eezɛsik nɛ ɛbuk etɛɛ náá, nyɛ nadi ɛ́, nɛ ekum ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bhii tak, Yezu eezɛliig mis tɔ ɛbwak, gwyák bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Ɛkɔɔla nɛ bɛkum ɛ bot, bɛ ni tɔ Ɛyoŋ ɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ye nabɛ ɛ́ mɛkpa menek naadyeebadhek bɛdjekel bɛ ebhum elyem, bhii tak Yezu eebaazɛke náá: «Bɔn bam, ɛni ɛ́ tɔ Ɛyoŋ ɛ Zɛɛb, tok ɛbɛɛ! ");
INSERT INTO bkw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɛlyel náá, boo yaaga bal, nyɛ ni tɔ ba mɔɔ ɛlen ɛ dhɔɔ, baalyel dhaa-dhaŋak nɛ mot ekum, nyɛ ni tɔ Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bɛdjekel nadjodjoka yenek djas ɛ́ djoka. Tin, bɛ moo djinel pak'ɔɔ náá: «Yɛ bɛ deenek ɔɔ, ɛzɛ aabela tsik na kɔm-kɔm?» ");
INSERT INTO bkw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yezu zɛbulal mis, gwyák bɛ. Nyɛy nɛ nɔɔ náá: «Yɛ bɛ bot ɔ, bɛ aanàkwaakwak. Ye ɛ́ Zɛɛb nyɛy nyɛ ɛmet ɛ́ aapaakwak, etɛɛ náá, ye tok nɛ sa Zɛɛb aadi ààkwak.» ");
INSERT INTO bkw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wɔ gwaa, Pyɛɛd ke náá: «Gwyáka! Bis eezebet esa bis djas étɛp ɛdu ɛ wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yezu baazɛbɔɔza náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Mot ɛ́ bet sɛɛg nɛ nyɛɛg, nɛ mɔn nyɛɛg, zɛnɔɔ bɔn bɛ, nɛ bɛkɛl, zɛnɔɔ mendjaa mɛ, nɛ epyeeb bɛ étɛp'am, nɛ étɛp Mbɛɛ Bhaadal ɛ Zɛɛb ɔɔ, ");
INSERT INTO bkw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kana mos, nyɛ waabela mendjaa, bɛdhyeeb, bɛkɛl, bɛnyɛɛg, bɔn nɛ epyeeb bɛdhet nɛ bɛdhet kɔ bɔs. É di tak wat, nyɛ waadɛ goo kɔ ɛsu ɛ lam. Tɔ tsik aazyɛ bhis yak ɛ, nyɛ waabela tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bela náá, bɛtɛ nɛ bot ɛ di mos é lɔɔg ɛsok ɔ, bɛ aakaswaala bot ɛ ɛbhis, bot ɛ di mos pɛ lɔɔg ɛbhis ɔ, bɛ aakaswaala ɛ́ bot ɛ lɔɔg ɛsok.» ");
INSERT INTO bkw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bɛ nadi ɛ́ é ze, bɔɔ etɔ́ pɛ Yeluzalɛm. Yezu pɛ sok, bɛdjekel bɛ pɛ bhis nɛ bɛdhiiti bot ɛ nadi edu nyɛ ɔ. Kɛŋ nabɛ ɛ́ ye moo sa bɛ. Wɔ gwaa Yezu baazɛsɛɛg bɛdjekel bɛ kam nɛ bɛbá, nyɛ moo tin elɛɛ bɛ sa aasael dum nɛ nɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nyɛ eezɛlɛɛ bɛ náá: «Gwakeka! Mena ɛpetɔ́ka pɛ Yeluzalɛm pɛ Sɛɛŋɛlɛ Mɔn Mot aakaaa é mɛmbɔ mɛ eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi ɛ. Bɛ waapit nyɛ, bhii tak, bɛ waadjɛ nyɛ epɛ́ɛ e ɛsyee. Nyɛ waadjɛaa é mɛmbɔ mɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bot binɔk ɛ́ waaduk nyɛ, sɛɛ nyɛ mɛtel é mis, nyuu nyɛ nɛ eghwyɛs, gó nyɛ. Mɛlu mɛlɛl bhis ɛsyee ɛ lɛ, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wɔ gwaa Zak bɛ nɛ mɔn nyɛɛg Zaŋ, bɔn ɛ Zɛbɛdɛ, zokazɛtiila pɛ daa Yezu, bɔɔ nɛ nɛ náá: «Lyoel, bis kwyɛl ɛ́ náá, wɔ sa sa bis aadji wɔ nenak'aak.» ");
INSERT INTO bkw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nyɛ eezɛdji bɛ: «Bi kwyɛl náá, mɛ sa bin yé?» ");
INSERT INTO bkw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bɛ eezɛbɔɔza nɛ nɛ náá: «Bis kwyɛl ɛ́ náá, é sok wɔ aadi tɔ duma yɔ ɛ, wɔ djɛ bis duma ɛ djɛ bis ghwyil ɛdisi, ngɔt pɛ mbɔ eghɛŋ bɔ, nwyak ngɔt pɛ mbɔ ɛmyɛl ɛ lɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tin, Yezu zokazɛbɔɔza nɛ nɔɔ náá: «Bi ààgu sa bi di ewaab ɛ. Bi ɛ́ nɛ ghwyil ɛkwak ɛdɛ mɛdii mɛ mbi bɛɛlɛ mam aadɛ ɛ nɛghu bi ɛ́ nɛ ghwyil ɛduwa Zɛɛb kɔkɔ mbi mam aaduwaa ɛ?» ");
INSERT INTO bkw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɔɔ nɛ Yezu náá: «Bis ɛ́ waakwak ɛsa yɛ.» Bhii tak, Yezu zɛbaabɔɔza nɛ nɔɔ náá: «Ye ɛ́ tsɛɛtsɛ náá, bi ɛ́ nɛ ghwyil ɛdɛ tɔ bɛɛlɛ mezuk mɛ mɛ aadɛ ɛ. Bi ɛ́ nɛ ghwyil ɛduwaa mezuk dáa mam aaduwaa ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yɛ kabɛ dum nɛ tɛp ɛdisi pɛ mbɔ eghɛŋ bam nɛghu pɛ mbɔ ɛmyɛl ɛ lam ɔ, ye tok mam di nɛ ghwyil ɛdjɛ bin edi e tak, etɛɛ náá, edi binek aadjɛaa ɛ́, nɛ bot ɛ ye nazekoobela étɛp'ɔ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dáa bɛdjekel kam nalik ɛ, nagwak deenek ɛ, ye nabɛ ɛ́, ye naakpaa bɛ elyem dum nɛ tɛp Zak bɛ nɛ Zaŋ nalii ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tin, Yezu zokazɛdjóo bɛ. Bhii tak, nyɛ eezɛlɛɛ bɛ náá: «Bi nɛ gu dáa bɔs'ak di ɛ: Ye ɛ́ bot ɛ di ebeeaa dáa ekukuma e membyak ɛ́ di ezuk bot bɔɔ. Eboo bot ɛ bɔs ɛpenyal bɛ nɛ mɛko mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yɛ ààgoka nɛ ɛsael deenek pak'en. Ye goka ɛ́ náá, mot di ekwyɛl ɛdi kɔ elo bɛsɔ pak'en ɔ, mot tak paakodi mot-mɛsa mɛ bɛsɔ. ");
INSERT INTO bkw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mot aakwyɛl ɛdi pɛ sok bɛsɔ ɔ, di kwom bɛsɔ djas. ");
INSERT INTO bkw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Étɛp tak ɛ́ di náá, Sɛɛŋɛlɛ Mɔn Mot nyɛy nyɛ ɛmet nabɛ ààzyɛ, etɛɛ náá, bot neezɛdi bot ɛ mɛsa mɛ. Nyɛ nazyɛ ɛ́, zɛsa bot mɛsa, nɛ ɛzɛdjɛ tsik'ɛ tyee etuud étɛp bot ɛbuɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bɛ eezɛkum pɛ dɛl ɛ Yeliko. Dáa Yezu nadi, nyɛ moo wyis bɛ nɛ bɛdjekel bɛ tin ɛ́, zukamwaa nɛ mot nadi edu bɛ. Yɛ nabɛ ɛ́ nɛ dhiiti mot na edhim nɛ engwyeebel, din ɛ lɛ nabɛ Balatime. Nyɛ nabɛ ɛ́ mɔn ɛ Time. Nyɛ nadidi ɛ́ ndiindil é ngwoob gba. ");
INSERT INTO bkw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Dáa nyɛ nagwak náá, ye nabɛ ɛ́ Yezu, mot Nazalɛt ɛ, wɔ gwaa, nyɛ zɛtsim náá: «Yezu, Mɔn ɛ Dhavid, geka mɛ ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bɛtɛ nɛ bot ɛ nadi tin ɔ moo tin ebiyo nɛ nɛ, ebhɛm nyɛ, étɛp nyɛ needi gwyem. Tin, nyɛ eebaazɛloogal gwood ɛlyelɛpe: «Mɔn ɛ Dhavid, geka mɛ ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","É sok'enek, Yezu eezɛtyaa. Nyɛy nɛ bɛdjekel bɛ náá: «Djóoka mɛ nwyak.» Tin, bɛ eezɛdjóo mot edhim binɔk. Bɔɔ nɛ nɛ náá: «Wyɛla, sa mɛghaaz. Nyɛ ɛ́ ɛpedjóo wɔ!» ");
INSERT INTO bkw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tin, «ngbat», Balatime eezɛwyɛl, mwas boo ndjookuwa yɛ, tɔ́ pɛ Yezu nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Deenek Yezu eezɛdji nyɛ náá: «Wɔ kwyɛl náá, mɛ sa wɔ yé?» Mot edhim binɔk eezɛbɔɔza nɛ nɛ náá: «Lyoel, mɛ kwyɛl ɛ́ náá, mis mam bɛŋel!» ");
INSERT INTO bkw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yezu eezɛke nɛ nɛ náá: «Tɔ́a, ɛmyaal ɛ lɔ eetsik wɔ.» É di'enek wat, mis mɛ eezɛbɛŋel. Bhii tak, nyɛ moo du Yezu é gba. ");
INSERT INTO bkw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dáa bɛ nadi, bɛ moo kunaa nɛ Yeluzalɛm ɛ, ye nabɛ ɛ́, bɛ moo é ngwoob Bhɛtfaze nɛ Bhetani, mbaka-mbaka nɛ ɛtsok ɛ pyeeb oliv. Tin, Yezu eezɛlwom bɛdjekel bɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Nyɛy nɛ nɔɔ náá: «Tɔ́ka kɔ dɛl di pɛ sok'enek. Tuula bi aatuula kɔ dɛl ɛ, bi ɛ́ waabee mɔɔ swooz an tiŋela di náá, mot dinaa ààpaago kɔ lɛ ɔ. Tiika nyɛ, da bi ɛ́ zyɛ mɛ nɛ nɛ wak. ");
INSERT INTO bkw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mot ɛ́ dji bin náá: “Bi tɔ́ nɛ nɛ wo ɔɔ?” Lɛɛka nyɛ náá: “Ye ɛ́ Ghɛŋ ɛ́ di nɛ gwyes nɛ nɛ. Nyɛ waabulal bin nwyak nenak.”» ");
INSERT INTO bkw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhii tak, bɛ eezɛtɔ́, bɛ kabela ɛ́, mɔɔ swooz an tiŋela é ɛbɛ ɛ ndjaa dhiiti mot. Wɔ gwaa, bɛ zɛtii nyɛ, zɛsik nɛ nɛ pɛ Yezu nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bɛdhiiti bot ɛ nadi tin ɔ eezɛdji bɛ étɛp yé bɛ di etii mɔɔ swooz an. ");
INSERT INTO bkw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wɔ gwaa, bɛ zɛbɔɔza nɛ nɔɔ dáa Yezu nalɛɛ nɛ nɔɔ ɛ. Tin, bɛ eezɛbet bɛ, bɛ eetii mɔɔ swooz an tak. ");
INSERT INTO bkw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhii tak, bɛ eezɛtɔ́ nɛ mɔɔ swooz an tak pɛ Yezu nadi ɛ́, wɔ gwaa bɛ zɛkɛl nyɛ endjookuwa bɔɔ kɔ koŋ'ɛ, bhii tak Yezu eezɛkalal kɔ lɛ, disi. ");
INSERT INTO bkw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wɔ gwaa bot ɛbuɛpe zɛtɔ́ nɛ ɛdja endjookuwa bɔɔ gba ɛ gba, bɛdhiiti kadja yɔbɔ ɛ́, ebhuuz e ele ee bɛ nadi etsaal tɔ epyeeb ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ngoŋ bot ɛ nadi pɛ sok ɔ, nɛ bot ɛ nadi pɛ bhis ɔ, moo tin edjeeb: «Hozana! Zɛɛb sɛɛ mot zyɛ nɛ din ɛ Ghɛŋ ɔ mɛtel! ");
INSERT INTO bkw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Zɛɛb goka ɛ́ nɛ ɛsɛɛ mɛtel mɛ kɔ Ɛyoŋ ɛ di ezyɛ yenek, ɛyoŋ ɛ Dhavid sɛɛg'enaka! Hozanna nɛ Zɛɛb tɔ gwoo.» ");
INSERT INTO bkw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yezu eezɛni tɔ Yeluzalɛm, nyɛ eezɛtɔ́ pɛ kok Ndjaa-ebuwa. Bhii nyɛ nakazɛgwyák é ngwoob'ɛ ɛ, nyɛ eezɛbee esesɛɛ ee nadi esɛɛ tɔ tak ɛ djas, nyɛ eezɛnɔɔ nyel, bɛ nɛ bɛdjekel bɛ kam nɛ bɛbá dhaa yɔbɔ, tɔ́ pɛ Bhetani, etɛɛ náá, ye nabɛ ɛ́ dwoo eezesila. ");
INSERT INTO bkw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yak mɛlem, é ghɛŋ bɛ nadi edus pɛ Bhetani ɛ, wɔ gwaa za zɛmɛt Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bɛ dinaa ɛtsetaɛpe, wɔ gwaa, nyɛ zɛbee le fiigh nɛ bɛtɛ nɛ eka. Tin, Yezu eezɛtiila si le tak nɛghu nyɛ waabela bhum, étɛp nyɛ neebɔ́k, dɛ. Dáa nyɛ nakakum si le ɛ, nyɛ ààpakabela sonok. Nyɛ kabela ɛ́, eka nɛ eka, etɛɛ náá, yɛ mbu nyɛ di edjɛ bhum ɛ, nabɛ ɛ́, ààdjala. ");
INSERT INTO bkw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tin, Yezu eezɛke nɛ le tak náá: «Kan dwoo pan mos'ak, ye tok nɛ mot aabaadɛ bhum'ɔ!» Bɛdjekel bɛ nabɛ ɛ́ egwak etɛp binek djas. ");
INSERT INTO bkw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bɛ eezɛkum pɛ Yeluzalɛm. Wɔ gwaa bɛ zɛni tɔ kok Ndjaa-ebuwa. Nyɛ eezɛni é sɔ bot ɛ nadi ebɔmsa esa bɔɔ ɔ, nɛ bot ɛ nadi ebɔm-bɔmak ɔ nadi tin ɔ. Nyɛ eezɛwaaz emesa bɛ nadi eswoola epata kɔ tak ɛ, nɛ mɛbhóó mɛ bot ɛ nadi ebɔmsa mɛghum ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yezu nabɛ ɛ́ ààbet náá, mot ngɔt dhaa nɛ sa wat tɔ kok Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bhii tak, nyɛ moo lyo bɛ náá: «Tɔ mɛkpa mɛ Zɛɛb, ye tok kwyala náá: “Ndjaŋ'am aadjóoaa ɛ́, ndjaa mendjaala mɛ eYuda, étɛp bot ɛ membyak djas é”? Yɛ kabɛ biyɔ ɔ, bi eezesa náá, ye di zɛɛga bot ɛ djii.» ");
INSERT INTO bkw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tin, wɔ gwaa etɛp binek djas kum tɔ mɛlɔ mɛ eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi. Bɛ moo tin esaa dáa bɛ aasa étɛp bɛ neegó nyɛ. Etɛɛ náá, bɛ nadi ɛ́, nɛ bwoo dáa bɛ nadi ebee dáa ɛdhuu ɛ bot nadi eduwal mɛlyo mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dáa dwoo nakabɛ yɛ eesila ɛ, wɔ gwaa bɛ nɛ bɛdjekel bɛ zokazɛwyis, tɔ́. ");
INSERT INTO bkw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tɔ mɛlem kɛɛŋ dáa bɛ nakadhaa é ze'enek ɛ, bɛ kabela ɛ́, le fiigh eezesyee dɔɔ nɛ ekaŋal. ");
INSERT INTO bkw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tin, Pyɛɛd eezɛtaala sa nasael koko é di'enek ɛ. Nyɛy nɛ Yezu náá: «Lyoel! Gwyáka le fiigh wɔ nalek koko ɛ. Yɛ eezesyee!» ");
INSERT INTO bkw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yezu eezɛbɔɔza nɛ bɛdjekel bɛ náá: «Mɛ lɛɛ bin ɛ́ náá: Dumka koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Mot ɛ́ ke nɛ ɛtsok ɛlak: “Ghɛɛa nyel tin, dusa, kɛghaaga tɔ dii mɛsɔn” ɔɔ, ye ɛ́ bɛ náá, mot tak tok nɛ mɛso tɔ lyem ɔɔ, nyɛ dum koŋ nɛ Zɛɛb ɔɔ, djas nyɛ aake ɛ, yɛ waasael étɛp'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Étɛp tak ɛ́ mɛ di eke nɛ nen náá: É sok bi di edjaala étɛp ɛwaab sonok ɛ, dumka koŋ náá, bi eezebela, tinaak ɛ́ bi aabela sa bi waab ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tin, bi ɛ́ di tetel étɛp mendjaala ɔɔ, wɔ siiza náá, wɔ ɛ́ nɛ tɛp nɛ mɔn nyoog ɔɔ, ye goka ɛ́ wɔ pel nyɛ etɛɛ náá, Sɛɛg'en di tɔ gwoo ɔ neepel bin yebɔ ɛbiyo bi sa ɛ.  ");
INSERT INTO bkw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Yɛ bɛ náá, bi ààpapel bɔn nyɛɛg bin ɔɔ, Sɛɛg'en di tɔ gwoo ɔ, aanàkwaapel yebɔ mesyem mɛ bi sa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bhii tak, bɛ eezɛbula pɛ Yeluzalɛm, dáa Yezu nadi edjaad tɔ kok Ndjaa-ebuwa ɛ, wɔ gwaa, bɛghaŋ ɛ mɛkana mɛ etsi, nɛ bɛpaa ɛ eYuda, zɛnɔɔ eboo bɛghaa-Zɛɛb, zokazyɛ pɛ daa Yezu bɛghu. ");
INSERT INTO bkw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bɛ nazyɛ zɛdji Yezu ɛ́ náá: «Kɔ eghɛŋ e zɛ wɔ di esa esesɛɛ binek? Ɛzɛ djɛ wɔ eghɛŋ ɛsa deenek?» ");
INSERT INTO bkw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛ pookodji bin kiya wat. Bi ɛ́ bɔɔza mɛ ɔɔ, ye ɛ́ mɛ kalɛɛ bin kɔ eghɛŋ e zɛ mɛ di esa esesɛɛ bak. ");
INSERT INTO bkw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ye ɛ́ ɛzɛ nadhis Zaŋ, nyɛ zɛduu bot Zɛɛb? Ye nabɛ ɛ́ Zɛɛb “ohoo” ye nabɛ ɛ́ mot? Bulalka mɛ kiya yenek.» ");
INSERT INTO bkw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pak'ɔɔ bɛ moo tin esɔs. Bɔɔ náá: «Mena ɛ́ keka nenak náá: “Ye ɛ́ Zɛɛb” ɔɔ, nyɛ waadji mena náá: “Étɛp yé bi nadi ààmyaal Zaŋ?” ");
INSERT INTO bkw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Haa” mena keka nenak náá: “Ye ɛ́ mot ɛ́ nalwom nyɛ ɔɔ”?» Bɛ nake deenek ɛ́, etɛɛ náá, bɛ nadi ekaab ɛdhuu ɛ bot, bela náá, bɔɔ djas nadi eke ɛ́ náá, Zaŋ nabɛ ɛ́ tɛtɛ ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bɛ ɛ́ boozɛbɔɔza nɛ Yezu náá: «Bis ààgu.» Tin, Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Dɔɔ nɛ mam pe, mɛ aanàkwaalɛɛ bin kɔ eghɛŋ e zɛ mɛ di esa esesɛɛ bak.» ");
INSERT INTO bkw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bhii tak, Yezu zɛlii nɛ nɔɔ tɔ kana náá: «Mot ngɔt naabɛ pyeeb vin. Nyɛ zokapeeb pyeeb tak, tin, wɔ gwaa nyɛ kpak tyee mɔɔ bwak tɔ ɛkok, edi bɛ aadi esesyaal mɛdii mɛ bhum vin tak ɔ. Bhii tak, nyɛ eebaazɛsum ndjaa pɛ ɛko, étɛp bot aadi ebaal pyeeb ɔ. Bhii tak nyɛ eezɛdjóo bot ɛ di egu mɛsa mɛ vin ɔ, da ɛ́ djɛ bɛ mɛsa mɛ tak. Nyɛ eezɛnɔɔ nyel, tɔ́ mɛdjoŋ. ");
INSERT INTO bkw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mbu epyeeb e tak di ewum ɛ, yɛ eezɛdjala. Wɔ gwaa, nakuma pyeeb zokazɛlwom mot ngɔt di esa mɛsa pɛ daa lɛ ɔ, pɛ dáa bot ɛ nyɛ nalik nɛ pyeeb ɔ, étɛp bɛ needjɛ nyɛ yɛ pak bhum vin bɛ nabela ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wɔ gwaa, bot ɛ nalik nɛ pyeeb ɔ, zɛmɛt mot tak, duma nyɛ é nyel nɛ mɛbin. Bhii tak swaal nyɛ mɛmbɔ toto. ");
INSERT INTO bkw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bhii mot sok, nakuma pyeeb eebaazɛlwom dhiiti mot di esa mɛsa pɛ daa lɛ ɔ náá, nyɛ tɔ́ pɛ daa lɔɔ tɔ pyeeb, bɛ eezɛnyuu nyɛ é lo, nyek nyɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yak kɔkɔ tyee esok elɛl. Nyɛ eebaazɛlwom nwyak mot, bɔɔ duma nyɛ é nyel nɛ mɛbin, gó nyɛ. Bɛ nabaazosa nɛ bot ɛ nazyɛ ɛbhis ɔ deenek, bɛdhiiti biaa, bak góaa. ");
INSERT INTO bkw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nyɛ nabɛ ɛ́ nɛ ɛtsak ɛ mɔn'ɛ nyɛ nadi ekwyɛl dhaa tyɛ ɔ nalik ɔ. Nyɛ eezɛlwom nyɛ pɛ daa lɔɔ nɛ egeka náá: “Bɛ waadil nyɛ, etɛɛ náá, ye ɛ́ mɔn'ɛ met.” ");
INSERT INTO bkw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dáa bot ɛ́ di esa mɛsa tɔ pyeeb'ɛ nabee mɔn'enɔk ɛ, bɔɔ náá: “Yawee! Beeka mot aalik nɛ mɛvu mak djas ɔ! Djhookɛgóka nyɛ. Tin, mɛvu mak aadi ɛ́, yenabɛlka.” ");
INSERT INTO bkw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wɔ gwaa bɛ zɛmɛt nyɛ, gó nyɛ, mwas muu'ɛ bhii pyeeb vin.» ");
INSERT INTO bkw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yezu eezɛdji bɛ kiya náá: «É di'enek, nakuma pyeeb goka nɛ ɛsa ye? Nyɛ waazyɛ, da nyɛ ɛ́ gó bot ɛ nadi esa mɛsa tɔ pyeeb ɔ. Bhii tak, da nyɛ ɛ́ nɔɔ pyeeb, djɛ nɛ bot ɛsis. ");
INSERT INTO bkw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bi nabɛ ààlaa mɛkpa mak tɔ ekwyala? “Ɛkok ɛ bɛsumel mwas ɛ, moo ɛ́ ɛkok di epyet ndjaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ye ɛ́ nɛ ghwyil ɛ Ghɛŋ ɛ nyɛ moo deenek. Ye tok tin mbyok é mis menaka?”» ");
INSERT INTO bkw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tinaak, bɛghaŋ ɛ mɛkana mɛ etsi, nɛ bɛpaa ɛ eYuda, zɛnɔɔ eboo bɛghaa-Zɛɛb, nadi esaa mɛpek étɛp bɛ neemɛt nyɛ. Tin, bɛ nadi ekaab ɛ́ ɛdhuu ɛ bot, etɛɛ náá, bɛ nabɛ ɛ́, egu náá, Yezu nalɛɛ kana tak ɛ́, kɔ ɛsu ɛ lɔɔ. É di tak wat, bɛ eezɛbet Yezu, tɔ́ yɔbɔ. ");
INSERT INTO bkw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bɛghaa-Zɛɛb zɛkyeed bɛdhiiti eFalizyɛ nɛ bɛdhiiti bot ɛ zɛɛga mɛkoozi Elood pɛ daa Yezu tyee mɛbhowal, étɛp nyɛ neebela ndjɛ kɔ mɛkpa mɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bɛ ɛ́ boozɛke nɛ nɛ náá: «Lyoel, bis nɛ gu náá, etɛp ee wɔ di elɛɛ ɛ, ye ɛ́ tsɛɛtsɛ. Wɔ ààbem ba nɛ mot, etɛɛ náá, wɔy ààdyeebagwyák sa bot di esa ɛ. Wɔ lyo ɛ́ sa Zɛɛb kwyɛl ɛ, nɛ lyem epiki. Tɔ yɔ beea, ye goka ɛ́ náá, bot tuud epata e lapo nɛ mɛkoozi Sezaad é? Bis tuud “ohoo”, bis nàtuud?» ");
INSERT INTO bkw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dáa Yezu nadi egu mbee mɛfulu mɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si ɛ, nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Étɛp yé bi di ekwyɛl ɛwa mɛ tɔ mɛbhowal? Dhaka mɛ nɛ pata wat, étɛp mɛ neebee.» ");
INSERT INTO bkw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɛ eezɛzyɛ nyɛ nɛ pata wat. Yezu eezɛdji bɛ náá: «Kɔ syaa yak, ye ɛ́ wak ɛbhwoob ɛ zɛ? Ye ɛ́ ekwyala e din ɛ zɛ ɛ di kɔ tak?» Bot binɔk eezɛbɔɔza nɛ nɛ náá: «Ye ɛ́ yɛ mɛkoozi Sezaad.» ");
INSERT INTO bkw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bhii tak, nyɛ eebaazɛbɔɔza nɛ nɔɔ náá: «Djɛka Sezaad sa di yɛ Sezaad ɛ, da bi ɛ́ djɛ Zɛɛb sa di yɛ Zɛɛb ɛ.» Gwaka bɛ nagwak deenek ɛ, bɛ eezɛdjoka nyɛ ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ESaduseɛ, bot ɛ nadi eke náá, bhis ɛsyee, bot aanàkwaabaagom ɔ, bɛ eezɛzyɛ yɔbɔ pe, pɛ daa Yezu, zɛdji nyɛ náá: ");
INSERT INTO bkw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Lyoel, mɛkana mɛ Moiiz lɛɛ ɛ́ náá: “Yɛ bɛ náá, mɔn nyɛɛg dhiiti mot eegwyɛ, ààlik mɔn ɔɔ, ye goka ɛ́ náá, mɔn nyɛɛg lik ɔ, ba kus myɛl, étɛp nyɛ neekwyiida mɔn nyɛɛg gwyɛ ààlik bɔn ɔ”. ");
INSERT INTO bkw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Beea: Tin, yɛ bɛ náá, bɛ nadi ɛ́ bɔn mɔ ngɔt bɛtɛn nɛ bɛbá ɔɔ. Mɔn mɛgwyak eezɛba, da gwyɛ, ààlik mɔn. ");
INSERT INTO bkw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mot nabɔɔba mɔn mɛgwyak ɔ, kanɔɔ moma bhii koŋ'ɛ. Tin, nyɛ eebaakpaa nɛ mɛsyee, gwyɛ, ààlik bɔn. Ye zokabaasael ɛ́ tyɛ wat nɛ mot nabaazyɛ bhis yenɔk ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tin, bɔɔ djas bɛtɛn nɛ bɛbá kadi ɛ́ ààbya nɛ moma yenɔk. Bhii bɔɔ djas, moma eebaazɛgwyɛ yɛ pe. ");
INSERT INTO bkw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","É sok bot aagom bhis ɛsyee ɛ, moma yenɔk aakadi mwaa zɛ, tɔ bɔɔ bɛtɛn nɛ bɛbá? Etɛɛ náá, bɔɔ djas nabɛ ɛ́ botom bɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi ààbee tin náá, bi eewo? Etɛɛ náá, bi ààsiiza ɛnyɔɛpe sa di kwyala ɛ, baanɔɔ náá, bi ààgu ghwyil ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Etɛɛ náá, é ghɛŋ bot aagom bhis ɛsyee ɛ, botom aanàkwaakabaaba boa, boa pe ààkwaani mɛba, etɛɛ náá, bot djas aadi ɛ́, dáa efofop tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dum nɛ tɛp ɛgom bhis ɛsyee, bi naalaa tɔ mɛkana mɛ Moiiz sa Zɛɛb nalɛɛ nyɛ dum nɛ tɛp tak tɔ le nagel, ààdyak ɛ: “Ye ɛ́ mam, Zɛɛb ɛ Abalaam, Zɛɛb ɛ Izak, nɛ Zɛɛb ɛ Zakɔɔb.” ");
INSERT INTO bkw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Zɛɛb tok Zɛɛb bɛmyoŋ. Nyɛ ɛ́ Zɛɛb bot ɛ di nɛ tsik ɔ. Bi ɛpedjak ɛbuɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wɔ gwaa dhiiti ghaa mɛkana mɛ etsi ɛ Zɛɛb nadi egwak dáa Yezu nadi elii nɛ bot binɔk ɛ, zokazɛtiila pɛ daa Yezu, etɛɛ náá, nyɛ naabee náá, Yezu nabɛ ɛ́ nɛ gham. Nyɛ ɛ́ boozɛdji Yezu náá: «Tɔ etsi e Zɛɛb djas, yaa di dil dhaa bɛsɔ?» ");
INSERT INTO bkw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yezu ɛ́ boozɛbɔɔza nɛ nɛ náá: «Yii di dil tɔ bɛsɔ ɛ́: “Gwaka, Yisalaɛl, Ghɛŋ Zɛɛb'enaka, ye tok nɛ dhiiti Zɛɛb bhis Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Da wɔ ɛ́ kwyɛl Ghɛŋ Zɛɛb'ɔ, nɛ lyem'ɔ djas, nɛ sisim'ɔ djas, nɛ esiiza bɔ djas, nɛ ghwyil'ɔ djas.” ");
INSERT INTO bkw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Beeka yii di du yɛ ɛ: “Kwyɛla sɔ'ɔ mot dáa wɔ di ekwyɛl nyel'ɔ met ɛ.” Ye tok nɛ dhiiti etsi di edhaa binɔk bɛbá nɛ mɛdil.» ");
INSERT INTO bkw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ghaa-mɛkana mɛ etsi ɛ Zɛɛb'enɔk eezɛke nɛ nɛ náá: «Tsɛɛtsɛ, lyoel! Wɔ ɛ́ lɛɛ tsɛɛtsɛ náá, Zɛɛb ɛ́ ngɔt. Dhiiti Zɛɛb tok bhii koŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Etɛɛ náá, ɛkwyɛl ɛ nyɛ nɛ lyem'ɔ djas, nɛ sisim'ɔ djas, nɛ ɛtselal ɛ lɔ djas, nɛ ghwyil'ɔ djas, nɛ ɛbaakwyɛl ɛ sɔ'ɔ mot, dáa wɔ kwyɛl nyel'ɔ met ɛ, yɛ eedhaa ebuwa e bɛtit, nɛ esa ee di kaŋaa Zɛɛb ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dáa Yezu nabee dáa mot'enɔk nabɔɔza nɛ etsoŋ djas ɛ, nyɛ ɛ́ boozɛlɛɛ nɛ nɛ náá: «Ɛyoŋ ɛ Zɛɛb ààtseta nɛ nɔ.» Bhii tak bot nadi ɛ́, bɛ moo kyee ɛdji ɛ nyɛ ekiya. ");
INSERT INTO bkw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tin, Yezu ɛpelyo bot tɔ kok Ndjaa-ebuwa, nyɛ eezɛdji bot náá: «É tɛp yé bɛghaŋ ɛ mɛkana mɛ etsi di eke náá, Mɛsia ɛ́ dha ɛ Dhavid? ");
INSERT INTO bkw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ye nabɛ ɛ́, Dhavid nyɛ ɛmet nɛ ghwyil ɛ Sisim na Dɛɛ naake náá: “Ghɛŋ Zɛɛb nake nɛ Ghɛŋ'am ɛ náá: Dha disi pɛ mbɔ eghɛŋ bam, kɛkum dwoo mɛ aalwom bot ɛ mɛbhuka mɔ, Bɛ zɛdhaa si mɛko mɔ ɛ.” ");
INSERT INTO bkw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dhavid nyɛ ɛmet naadjóo nyɛ “Ghɛŋ”. É yaa tyɛ nyɛ aakabaadi dha'ɛ?» Zukamwaa nɛ mot nadi tin ɔ, nadi egwak Yezu nɛ mɛmyaala tɔ elyem. ");
INSERT INTO bkw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tɔ mɛlyo mɛ, nyɛ nakeke ɛ́ náá: «Kyeeka bɛghaŋ ɛ mɛkana mɛ etsi, bot ɛ di ekwyɛl ɛkɛ tɔ bot nɛ eboo elɔbɔ na djaa-djaa é ɛlyaalaa mɛnyel, étɛp bɛ needuwalaa nɛ ɛswosaa é edi ee bot di esɛɛga ɛbuɛpe ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Bɛ ɛ́ bot ɛ di saa mɛbhóó pɛ sok tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ mɛbhoo mɛ bɛdhil ɛ bot tɔ edi e mɛbyoŋ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bot ɛ di edɛk bɛkus ɛ boa esa tɔ mendjaa nɛ mɛkɔŋ, ɛkwyɛl ɛ bɛ ɛdul ɛ mendjaala “kpɔkɔlɔm”. Epɛ́ɛ bɔɔ aadi ɛ́ ɛlyelɛpe.» ");
INSERT INTO bkw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wɔ gwaa Yezu zɛdisi, ɛbɔɔl sok bhwoob'ɛ étɛp nyɛ neebee dáa ɛdhuu ɛ bot ɛ di zɛduwal Zɛɛb nɛ esa bɔɔ ɛ. Bɛtɛ nɛ bot ɛ ekum nadi ewa epata ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wɔ gwaa dhiiti djel kus moma zokazyɛ yɛ sok, zɛlóo yɛ tɔ ɛbɔɔl, nyɛ eezɛwa yɛ ba bɔɔ efalanga ebá. ");
INSERT INTO bkw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dáa Yezu nabee deenek ɛ, nyɛ ɛ́ boozɛdjóo bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Djel kus moma yak eelóo tɔ ɛbɔɔl, dhaa yii bot djas lóo tɔ ɛbɔɔl ɛlak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Etɛɛ náá, bot ɛ lóo wak djas'aak, lóo ɛ́ eghutu-ghutu. Yɛ kabɛ djel kus moma yak ɔ, nyɛ djɛ ɛkwom ɛ lɛ djas.» ");
INSERT INTO bkw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dáa Yezu nadi ewyis tɔ kok Ndjaa-ebuwa ɛ, dhiiti djekel'ɛ ngɔt eezɛke nɛ nɛ náá: «Lyoel, gwyáka kɔkɔ yak mbi zumal nɛ mbi yak mɛkok e!» ");
INSERT INTO bkw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yezu zɛbɔɔza nɛ nɛ náá: «Wɔ eebee mbi eboo zumal mendjaa mak é? Tin, yɛ aanàkwaaboolik ɛkok ɛ wat kɛla kɔ sɔ, etɛɛ náá, djas aadi ɛ́, bik, waazel, see é bɔs.» ");
INSERT INTO bkw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yezu eezɛdisi kɔ ɛtsok ɛ pyeeb oliv, pyeeb tak nadi egwyakel ɛ́, nɛ kok Ndjaa-ebuwa. Pyɛɛd nɛ Zak, bɛ nɛ Zaŋ, zɛnɔɔ Andele zokazɛdji nyɛ é ngwoob náá: ");
INSERT INTO bkw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Lɛɛa bis, esesɛɛ binek aasael den? Lyaala bis endem e mɛbwala mɛ bis aagwyak náá, esesɛɛ binek moo kɔ nɛ ɛsɛ́ɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yezu eezɛke nɛ nɔɔ náá: «Dika nɛ etsoŋ, sa mot ààkɔɔ bin. ");
INSERT INTO bkw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bɛtɛ nɛ bot ɛ́ waazyɛ nɛ din ɛ lam. Bɛ aake ɛ́ náá: “Ye ɛ́ mam ɛ́ di Mɛsia!” Bot ɛ tak ɛ́ waakwyital ɛdum ɛ koŋ nɛ Zɛɛb yii bot ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","É sok bi aadi, bi moo gwak mɛɛb nɛ menduk mɛ mɛɛb ɛ, sa mot ààbem ba, etɛɛ náá, ye nyɔ ɛ́ náá, esesɛɛ binek sael. Yenek djas ààlɛɛ náá, ye ɛ́ ɛsi ɛ bɔs. ");
INSERT INTO bkw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yak mbyak ɛ́ waakɛghɛɛ, zɛlumela dɛɛb nɛ sɔ, yak ɛyoŋ nɛ yak sɔ ɛyoŋ. Ye bɛdhiiti edi kɔ bɔs ɛ́ waadheegel, za waani kɔ mɛl. Yenek djas ɛ́ ɛkɛn ɛ ɛsuula ɛbya. ");
INSERT INTO bkw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Yɛ kabɛ biyɔ bɛ ɛmet ɔ, dika nɛ etsoŋ nɛ mɛnyel min. Bi ɛ́ waakɛpitaa pɛ daa bɛtetɛp. Bi ɛ́ waabiaa nɛ eghwyɛs tɔ mendjaa mɛ mendjaala mɛ eYuda. Bi ɛ́ waakɛpitaa pɛ daa ekukuma nɛ pɛ daa bɛmɛkoozi kɔ ɛsu ɛ din ɛ lam, étɛp bɛ neebela gham kɔ len. ");
INSERT INTO bkw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tin, ye goka ɛ́ náá, Mbɛɛ Bhaadal pookogoolel sok kɔ bɔs djas nɛ tɔ membyak djas. ");
INSERT INTO bkw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","É sok bɛ aadi etɔ́ nɛ nen, bɛ neekɛka bin ɛ, sa mot ààbem ba nɛ dáa bi aakɛtaŋal ɛ. Liika dáa Sisim aadjɛɛd bin é di'enek wat ɛ. Etɛɛ náá, ye tok biyɔ aakabaalii tin. Ye ɛ́ Sisim na Dɛɛ paalii é di'en. ");
INSERT INTO bkw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Bɔn mɔ ngɔt ɛ́ waagónel, bɛsɛɛg gó bɔn bɔɔ. Bɔn ɛ waapit bɛbyael bɔɔ é ɛsaa náá, bɛ djɛ bɛ mendjɛ étɛp bɛ neegóaa. ");
INSERT INTO bkw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bot djas ɛ́ waabhina bin étɛp din ɛ lam. Ye ɛ́ mot aamaad lyem kɛkum mɛsik ɔ, nyɛy ɛ́ aapaabela tsik.» ");
INSERT INTO bkw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Bi ɛ́ waabee mot di edjóoaa “etɛp e ɛpes nɛ bwoo” ɔ. Bi ɛ́ waabee nyɛ, nyɛ eezetyaa é di nabɛ náá, nyɛ aanàkwaadi sok ɔ. Bot ɛ di egu ɛlaa mɛkana ɔ, goka ɛ́ nɛ ɛgwak náá, bot aadi pɛ kyee dik Yude ɔ, kaab, tɔ́ pɛ kɔ mɛtsok. ");
INSERT INTO bkw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mot ɛ́ di kɔ mii ndjaŋ'ɛ é ɛwala ɛlenek ɔ, sa nyɛ ààsul, étɛp ɛkɛnɔɔ dhiiti sonok tɔ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mot aadi pɛ pyeeb é ɛwala ɛlenek ɔ, sa nyɛ ààsik, kɛnɔɔ ndjookuwa pɛ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ha kpaa-ghoŋ nɛ boa aadi nɛ mɛbum ɔ, ha kpaa-ghoŋ nɛ boa aadi nɛ bɔn é mbel dwoo tak ɔ! ");
INSERT INTO bkw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Djaalaka Zɛɛb, etɛɛ náá, esonok binek nàkum é mbu kwol. ");
INSERT INTO bkw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Etɛɛ náá, mɛlu menek aadi ɛ́, mɛlu mɛ mezuk, mezuk mɛ wat di náá, ye dinaa ààpaakosɛɛ sok, kana dáa Zɛɛb nalookus bɔs'ak ɛ, kɛyaka nɛ dwoo pan mos'ak. Yɛ aanàkwaadi pe nɛ dhiiti tak deenek. ");
INSERT INTO bkw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ghɛŋ ɛpedi ààsa náá, mɛlu mɛ tak nàdyeebabɔya ɔ, pe ye tok nɛ mot aatsak. Ye ɛ́ kɔ ɛsu ɛ bot ɛ nyɛ nazesɛ́ɛ ɔ, mɛlu mɛ tak di ba bim deenek. ");
INSERT INTO bkw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tin, mot ɛ́ lɛɛ bin náá: “Mɛsia ɛ́ wak” nɛghu nyɛ ke ɛ́ náá: “Beeka nyɛ di poon'enek” ɔ, sa mot ààmyaal nyɛ, ");
INSERT INTO bkw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","etɛɛ náá, bɛmɛsia mɛ etsal nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ ɛ́ waatuula ɛbuɛpe. Bɛ waasa bɛmɛvyɛkɛlɛ nɛ dhiiti endem mɛbwala, étɛp ɛkɔɔ bot ɛ Zɛɛb nazesɛ́ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dika nɛ etsoŋ etɛɛ náá, mɛ eezedul bin mɛlɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Tin tɔ mɛlu menek, bhii mɛlu mɛ mezuk menek, gwyes ɛ́ waagwyiid, dɔɔ nɛ ngɔn pe moo ààkakas, ");
INSERT INTO bkw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ekwyikwyen ɛ́ waadus tɔ gwoo, bil, esa e mɛnyan djas di tɔ gwoo ɛ, yɛ waapulel. ");
INSERT INTO bkw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«É di'enek, bot ɛ́ waabee Sɛɛŋɛlɛ Mɔn Mot etuula tɔ eguud nɛ ghwyil nɛ duma djas. ");
INSERT INTO bkw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tin ɛ́, nyɛ aakalwom efofop, bɛ neekɛsɛɛg bot ɛ Zɛɛb nazesɛ́ɛ ɔ, pɛ tɔ etuma ená yii bɔs, kana pɛ yak edum e bɔs, kɛyaka nɛ pɛ yak edum.» ");
INSERT INTO bkw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Nɔɔka etsoŋ nɛ kana yak, dum nɛ le fiigh. Yɛ bɛ náá, elɛɛ bɛ moo zɛbula ebes ɔɔ, eka moo baakwyil e tak ɔɔ, guka náá, mbu gwyes moo kunaa. ");
INSERT INTO bkw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ye ɛ́ tyɛ wat nɛ biyɔ pe, é sok bi aabee endem binek moo nyen ɛ, guka náá, ɛbula ɛ Sɛɛŋɛlɛ Mɔn Mot moo zɛkunaa. Nyɛ moo ɛ́ é ngwoob ɛbɛ ɛ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Bot ɛ kɔkɔ membu mak aanàkwaasi, esonok ee di elɛɛaa djas'aak, ààsael. ");
INSERT INTO bkw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gwoo nɛ bɔs ɛ́ waadhaa, yɛ kabɛ mɛkpa ɛ Zɛɛb ɔ, yɛ aanàkwaadhaa.» ");
INSERT INTO bkw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Dum nɛ dwoo, nɛ ɛwala ɛ esesɛɛ binek aasael ɛ, ye tok nɛ mot ngɔt di gu, efofop tɔ gwoo ààgu, dɔɔ nɛ Mɔn ààgu dwoo tak. Ye ɛ́ Sɛɛg nyɛ ɛmet ɛ di egu. ");
INSERT INTO bkw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dika nɛ etsoŋ, nyanka mis. Djaalaka Zɛɛb etɛɛ náá, bi ààgu ɛlu nɛ ɛwala esonok binek aasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yɛ aadi ɛ́, dáa mot di etɔ́ mɛdjoŋ, lik ndjaŋ'ɛ. Da nyɛ ɛ́ lik bot ɛ mɛsa mɛ ebaal ndjaa. Tin, nyɛ eezɛkaa mot nɛ mot yɛ mɛsa mɛ nyɛ aasa bhii koŋ'ɛ ɛ. Bhii tak, nyɛ kalɛɛ sangili di é ɛbɛ ɛ ndjaŋ'ɛ ɔ náá, nyɛ lik ebaal. ");
INSERT INTO bkw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nyanka mis, etɛɛ náá, bi ààgu dwoo nakuma ndjaŋ aabula ɛ́, nɛghu nyɛ aabula ɛ́, bikoko, nɛghu yɛ aadi ɛ́, kuku pum, nɛghu yɛ aadi ɛ́ é bɛkuu ɛ sok, nɛghu yɛ aadi ɛ́ tɔ mɛlem. ");
INSERT INTO bkw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kyeeka, nyɛ ɛ́ zɛkɛbela bin zaka, biyɔ egɔ́. ");
INSERT INTO bkw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Etɛp ee mɛ di elɛɛ bin'aak, mɛ lɛɛ yɛ ɛ, nɛ bot djas: “Bɛɛka mis.”» ");
INSERT INTO bkw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mɛlu mɛmbá ɛsok nɛ ɛbyoŋ ɛ Pak nɛ yii bɛ nadi ededɛ emapa ààbɛ nɛ leviid ɛ kan, eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi nadi esaa mɛpek étɛp bɛ neemɛt Yezu tyee syaab, étɛp bɛ neegó nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bɛ nadi eke ɛ́ náá: «Yɛ ààgoka nɛ ɛsɛ́ɛ é dwoo ɛ ɛbyoŋ, ekaab náá, yɛ ɛ́ zɛkɛkus ɛghuub tɔ zukamwaa nɛ mot dwoo ɛbyoŋ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dáa nyɛ nadi pɛ Bhetani tɔ ndjaŋ ɛ Simɔŋ na ɛbɛ́ ɛ zezam ɛ, tin bɔɔ kɔ mesa edɛ edee, wɔ gwaa, dhiiti moma zɛni tɔ ndjaa tak nɛ bɛɛb nasael nɛ ɛkok ɛ albat ɛ, «tɔɔɔ» nɛ mɛnanas na boo mɛtaŋ. Mɛnanas mɛ tak nasael ɛ́, nɛ mɛdii mɛ dhiiti le na mbɛɛ mɛnuub di djóoaa naad ɛ. Ye nabɛ ɛ́, ààpuuzaaa nɛ dhiiti sonok. Wɔ gwaa, moma tak zɛkɔ ɛlas ɛ tak, so kɔ lo ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bɛdhiiti bot ɛ nadi bɛ nɛ bɛ nɔɔ ɔ, naadyeebabyen sa tak. Bhii tak, bɛ moo nyiiŋela pak'ɔɔ: «Yak ɛ́ yaa puluk mɛnanas? ");
INSERT INTO bkw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ye waagoka ɛ́ náá, bɛ bɔmsa mɛnanas mɛ tak nɛ epata mɛkam-mɛtɛn nɛ wat, da ɛ́ nɔɔ epata e tak, djɛ bɛdjel ɛ bot!» Tin, bɛ moo byak moma yenɔk ɛbiyoɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wɔ gwaa, Yezu zɛke náá: «Betka moma yak gwyem. Étɛp yé bi di ezɛm nyɛ? Sa nyɛ sa kɔ ɛsu ɛ lam ɛ, ye ɛ́ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Etɛɛ náá, bi nɛ bɛdjel ɛ bot ɛ́ waadi mɛlu djas é di wat. É sok djas bi aakwyɛl ɛlyaal bɛ ghwyikwyee ɛ, bi ɛ́ nɛ ghwyil ɛsa. Yɛ kabɛ mam ɔ, bi aanàkwaakabaadi nɛ nam mɛlu djas é di wat. ");
INSERT INTO bkw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Moma yak eesa tseŋa nyɛ sa ɛ: nyɛ eelɔɔb mɛ mul é nyel, mam dinaa ààgwyɛ, ekoobal ndela yam. ");
INSERT INTO bkw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Kɔ edi djas Mbɛɛ Bhaadal aadi egoolaa kɔ bɔs ɛ, tɛp moma yak ɛ́ waakaadaaa mɛdhik nɛ mɛdhik. Tin, bot ɛ́ waataala mɛnyɔ mɛ mɛsa mɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas Iskaliɔt, ngɔt tɔ bɛdjekel kam nɛ bɛbá ɛ Yezu, naazɛtɔ́ pɛ daa eboo bɛghaa-Zɛɛb étɛp nyɛ neekɛka Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tin, ye nabɛ ɛ́ eboo bɛghaa-Zɛɛb naadyeebamyaala é ghɛŋ bɛ nagwak lɛŋ tak ɛ. Wɔ gwaa, bɛ zɛkɛk Yudas epata. É di'enek, Yudas kadi tin ɛ́, nyɛ moo saa mɛpek étɛp nyɛ neeka bɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","É dwoo mɛkɛn mɛ ɛbyoŋ ɛ emapa ààbɛ nɛ leviid, dwoo tak ɛ́ bɔn ɛ ebhata e Pak di etsakaa, bɛdjekel ɛ Yezu zɛke nɛ nɛ náá: «Wɔ kwyɛl náá, bis kɛkoobal wɔ di mena aadɛka edee e ɛbyoŋ ɛ Pak wo é?» ");
INSERT INTO bkw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tin, Yezu ɛ́ boozɛkyeed dhiiti bɛdjekel bɛ bɛbá pɛ sok. Nyɛ nɛ nɔɔ náá: «Tɔ́ka pɛ dɛl. Bi ɛ́ waaboma nɛ dhiiti mot ebɛp bhe mɛdii. Duka nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","É di nyɛ aadjɛl ɔ, lɛɛka nakuma ndjaa náá: “Lyoel ke ɛ́, bis dji náá, di bi ekoobal nyɛ yɛ ɛ étɛp nyɛ neezɛdɛ ɛbyoŋ ɛ Pak, bɛ nɛ bɛdjekel bɛ tɔ tak ɛ́ wo é?” ");
INSERT INTO bkw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tin, nyɛ waalyaal bin pɛ ɛko ɛ ndjaa, boo koo koobela nɛ esa djas tɔ tak. Tin ɛ, bi aasa esesɛɛ e ɛbyoŋ ɛ Pak.» ");
INSERT INTO bkw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bɛdjekel eezɛtɔ́ pɛ dɛl ɛ tak. Bɛ kabela djas ɛ dáa Yezu nalɛɛ bɛ ɛ. Bhii tak, bɛ eezɛkan ɛkoobal ɛ ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bikoko Yezu eezɛzyɛ, nyɛ katuula lɔɔg wat nɛ bɛdjekel bɛ kam nɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dáa bɛ nadi kɔ mesa edɛ ɛ, Yezu ɛ́ boozɛke náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá, ngɔt pak'en ɛ́ waaka mɛ. Ye ɛ́ mot bis nɛ nɛ di duu mbɔ tɔ saan wat ɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bɛdjekel djas moo tin nɛ ghoŋ tɔ elyem, bhii tak, bɛ ɛ́ boozɛdji nyɛ ngɔt-ngɔt náá: «Ye ɛ́ mam é?» ");
INSERT INTO bkw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ mot ngɔt pak'en, tɔ biyɔ kam nɛ bɛbá. Ye ɛ́ mot di eduu mbɔ tɔ saan wat nɛ nam ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ye ɛ́ tsɛɛtsɛ náá, Sɛɛŋɛlɛ Mɔn Mot ɛ waagwyɛ, dáa ekwyala di elɛɛ kɔ ɛsu ɛ lɛ ɛ. Tinaak, ha kpaa-ghoŋ nɛ mot aakɛka nyɛ é mɛmbɔ mɛ bɛmbee ɛ bot ɔ. Ye nabɛ ààgoka náá, mbi mot deenek byel-byelak!» ");
INSERT INTO bkw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","É ghɛŋ bɛ nadi edɛ ɛ, wɔ gwaa Yezu zɛnɔɔ mapa, zɛghaapɛɛ Zɛɛb tɔ mendjaala. Bhii tak, nyɛ eezɛpyak mapa, djɛ bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Nɔɔka yɛ. Bi ɛ́ dɛ etɛɛ náá, ye ɛ́ nyel'am.» ");
INSERT INTO bkw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bhii tak, nyɛ eezɛnɔɔ bɛɛlɛ nadi nɛ vin tɔ tak ɛ, baaghaapɛɛ Zɛɛb. Nyɛ eezɛdjɛ bɛdjekel bɛ, bɛ dɛ. Tin, bɔɔ djas eezɛdɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nyɛy nɛ nɔɔ náá: «Yak ɛ́ ghiya yam, ghiya ɛbhɛŋ aasee étɛp bot ɛbuɛpe ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: Mɛ aanàkwaabaadɛ mɛdii mɛ bhum vin, kana mos, kɛyaka nɛ dwoo mɛ aabaadɛ dɛa sis tɔ Ɛyoŋ ɛ Zɛɛb ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bhii tak, bɔɔ zokazɛduwal Zɛɛb nɛ mɛdjeeb. Wɔ gwaa, bɛ zɛtɔ́ pɛ Ɛtsok ɛ pyeeb oliv. ");
INSERT INTO bkw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yezu eezɛke nɛ bɛdjekel bɛ náá: «Biyɔ djas ɛ́ waakaab mɛ mos, etɛɛ náá, tɔ mɛkana mɛ Zɛɛb, ye kwyalaa ɛ náá: “Mɛ waamyak mbaalel etaa, ɛsaa djas ɛ́ waawyɛɛza na gwyiiŋ.”» ");
INSERT INTO bkw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tin, Yezu baabil náá: «Bhii mɛ aagom ɛ, mɛ waatɔ́ kɛbwood bin pɛ sok, pɛ Ghalile.» ");
INSERT INTO bkw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pyɛɛd zokake nɛ nɛ náá: «Yɛ bɛ náá, bot djas ɛ́ waakaab wɔ ɔ, mam aanàkwaakaab wɔ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wɔ gwaa Yezu zɛbɔɔza nɛ nɛ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá: E pum'ak mos, ɛsok nɛ bɛkuu nɛ kɔk esok ebá, yɛ aabela ɛ́, wɔ eezeswonal mɛ esok elɛl.» ");
INSERT INTO bkw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pyɛɛd eezɛben gwood, lɛɛ nɛ Yezu náá: «Mɛ tok nɛ ghwyil ɛke nɛ bot náá, mɛ ààgu wɔ. Yɛ bɛ ɛsyee ɔɔ, mɛ ɛpemyaal náá, menabɛl bɛbá gwyɛ.» Tin, bɛdjekel djas nabɛ ɛ́ ɛkpa ɛ wat. ");
INSERT INTO bkw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhii tak, bɛ eezɛkum pɛ dhiiti mɔɔ sum di, din ɛ di tak nabɛ ɛ́ Ghetɛsemani. Dáa bɛ nakum ɛ, Yezu ɛ́ booke nɛ bɛdjekel bɛ náá: «Dika si wak. Mɛ pookotiila poon, kɛdjaala Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tin, nyɛ kanɔŋ ɛ́ Pyɛɛd, nɛ Zak, zɛnɔɔ Zaŋ, tɔ́ nɛ nɔɔ. Ye nabɛ ɛ́, kɛŋ nɛ bwoo moo sa nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nyɛ eezɛke nɛ nɔɔ náá: «Sisim'am ɛ́ tɔ ghoŋ, kana nenak, kɛyaka nɛ ɛwala ɛsyee. Likeka wak, nàdjaka gɔ, djaalaka Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Bhii tak, nyɛ eezɛtiila ba ɛtsetaɛpe pɛ sok, zɛduma mɛboŋ si, nyɛ moo djaala nɛ Zɛɛb náá, Zɛɛb dis mezuk menek sok bhwoob'ɛ, nyɛ kwyɛl ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nyɛ nadi eke ɛ́ náá: «Bhaaba saag'am, mɛ nɛ gu náá, wɔ ɛ́ nɛ ghwyil ɛsa esonok djas. Disa pɛ sok bhwoob'am baka mezuk mak. Tin, ye goka ɛ́ náá, ɛkwosak ɛ lɔ sael, ààkabɛ ɛkwosak ɛ lam.» ");
INSERT INTO bkw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bhii tak, nyɛ eezɛnɔɔ nyel, sik pɛ nyɛ nalik bɛdjekel bɛ ɛ. Nyɛ kazɛbela ɛ́, bɔɔ é egɔ. Nyɛ ɛ́ boozɛke nɛ Pyɛɛd náá: «Simɔŋ, wɔ eedja gɔ! Wɔ ààpakodi mis membek ɛwala ɛ wat é? ");
INSERT INTO bkw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Djemka, dika dwooz, djaalaka Zɛɛb, etɛɛ náá, bi ɛ́ zɛkɛkwyɛ tɔ mɛbhowal. Sisim ɛ́ nɛ ghwyil ɛlooba, kabela ɛ́ náá, epuud nɛ sa elɛtɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nyɛ eebaasik pɛ kyee nyɛ nadi sok ɛ. Nyɛ eebaazɛdjaala dáa nyɛ nadjaala Zɛɛb sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yezu eebaazɛbula pɛ nyɛ nalik bɛdjekel bɛ ɛ. Nyɛ kabaazobela bɛ ɛ́ é egɔ, etɛɛ náá, mis mɔɔ nadi ɛ́, ɛdilɛpe. É di'enek, bɛ moo «yooo», ààkabaabɔɔza nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yezu baazɛbula yak kɔkɔ tyee esok elɛl, bɔɔ é gɔ. Nyɛ eezɛke nɛ nɔɔ náá: «Bi dinaa edja gɔ? Bi dinaa ewala? Yɛ eedjala! Ɛwala ɛ Sɛɛŋɛlɛ Mɔn Mot moo zɛseebaa é mɛmbɔ mɛ bot ɛ mesyem ɛ, yɛ eezedjala. ");
INSERT INTO bkw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wyɛlka, ghɛɛka mɛnyel. Mena tɔ́ka, etɛɛ náá, mot aaka mɛ ɔ moo zɛkunaa nɛ nena.» ");
INSERT INTO bkw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ye nabela ɛ́, Yezu dinaa elii, é di tak wat, Yudas, ngɔt tɔ bɛdjekel bɛ kam nɛ bɛbá eezɛtuula nɛ ɛdhuu ɛ bot nɛ epɛl nɛ ebhil e ele é mɛmbɔ. Ye nabɛ ɛ́, eboo bɛghaa-Zɛɛb, nɛ bɛghaŋ ɛ mɛkana mɛ etsi, zɛnɔɔ bɛpaa ɛ eYuda nalwom bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kabela tin ɛ́ náá, Yudas, mot naka bɛ Yezu ɔ, nabɛ ɛ́, nyɛ naalyaal bɛ geka bɛ nawaagwyak Yezu nɛ yɛ ɛ. Nyɛ nabɛ ɛ́, nyɛ eezelɛɛ nɛ nɔɔ náá: «Bi zobee ɛ́, mot mɛ aakɛbeedal ɔ, ye ɛ́ nyɛy. Mɛtka nyɛ “gbak”, da bi ɛ́ tɔ́ nɛ nɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Dáa Yudas nɛ bot bɛ natuula ɛ́, nyɛ eezɛtiila pɛ daa Yezu. Nyɛ eezɛke nɛ nɛ náá: «Lyoel!» Bhii tak, nyɛ eezɛbeedal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bhii tak, bot ɛ nazyɛ bɛ nɛ Yudas ɔ, bɛ eezɛmɛt nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tin, mot ngɔt tɔ bot ɛ nadi é di tak ɔ, naazɛwaal pɛl tɔ pɛp, tsaal ɛlɔ ɛ mot nadi esesa mɛsa pɛ daa boo ghaa-Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Wɔ gwaa, Yezu zɛlii nɛ nɔɔ náá: «Mɛ kabɛ ɛ́ mot ɛzɛm étɛp bi neezyɛ, zɛmɛt mɛ nɛ epɛl nɛ ebhil e ele é? ");
INSERT INTO bkw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mɛ tok wak mɛlu djas tɔ len elyo tɔ kok Ndjaa-ebuwa, bi nadi ààmɛt mɛ étɛp yé? Sa bi sa'aak, ye ɛ́ etɛɛ náá, etɛp ee nakwyalaa tɔ mɛkana mɛ Zɛɛb, dum nɛ nam ɛ neebela ɛsuk.» ");
INSERT INTO bkw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tin, bɛdjekel djas eezɛghuma nɛ ekaab «gbes», lik Yezu é mɛmbɔ mɛ bot binɔk. ");
INSERT INTO bkw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Dhiiti ngbaaz ngɔt nadi edu bɛ pɛ bhis, zuka nɛ kaad nyɛ nabɛ nɛ yɛ é nyel ɛ, ye nabɛ ɛ́ kaad ɛsoa kɔ goŋ. Wɔ gwaa bot ɛ tak zɛsuu ɛmɛt mɔɔ ngbaaz tak, ");
INSERT INTO bkw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nyɛ eezɛkaab, lik bɛ kaad tak é mɛmbɔ, nɔɔ nyel'ɛ, tɔ́ ben toto «syɛɛɛ». ");
INSERT INTO bkw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɛ eezɛtɔ́ nɛ Yezu pɛ kɔ ɛbɛsɛɛ ndjaa boo ghaa-Zɛɛb, pɛ di bhoma bot ɛ nadi kɔ elo e bɛghaa-Zɛɛb ɔ, nɛ bɛpaa ɛ eYuda, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi. ");
INSERT INTO bkw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pyɛɛd nadi edu-du nyɛ ɛtsetaɛpe, batakɛni tɔ ɛbɛsɛɛ ɛ boo ghaa-Zɛɛb. Nyɛ eezɛdisi egɔɔl du, bɛ nɛ bot ɛ nadi ebaal ndjaa tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Eboo bɛghaa-Zɛɛb nɛ bɛdhiiti bot ɛ boo kwan eYuda nadi esaa embee etɛp di náá, ye ɛ́ nɛ ghwyil ɛdjɛ Yezu ndjɛ ɛ, étɛp bɛ neegó nyɛ, bɛ kadi ɛ́, ààbela sonok. ");
INSERT INTO bkw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Etɛɛ náá, bot ɛbuɛpe nadi ezezyɛ, zɛsu etɛp e mɛkɔŋ kɔ ɛsu ɛ lɛ. Saabɛgɔs kabɛ ɛ́ náá, bɔɔ djas kadi ɛ́, ààbɛ lɛŋ wat. ");
INSERT INTO bkw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bɛdhiiti wyɛl, zokazyɛ, zɛsu nyɛ tɛp. Bɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Bis naagwak nyɛy eke náá: “Mɛ waabo kok Ndjaa-ebuwa bot nasum'aak. Bhii tak, mɛ kasum ɛ́, dhiiti ndjaa sis. Zumal tak aabɔya mɛlu mɛlɛl. Yiizaag aanàkabaadi zumal mɛmbɔ mɛ bot.”» ");
INSERT INTO bkw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ye kabela tin ɛ́, bɛtɛ nɛ bot ɛ́ napookozyɛ sok, zɛpit nyɛ ɔ, nabɛ ɛ́ ààbɛ nɛ taŋal wat. ");
INSERT INTO bkw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tin, boo ghaa-Zɛɛb eezɛwyɛl kuku ɛdhuu ɛ bot binɔk, zɛdji Yezu náá: «Tɔ mɛpita mɛ bot bak zepit wɔ ɛ, wɔ ààkataŋal yɔ é!» ");
INSERT INTO bkw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yezu zokadi ɛ́ gwyem, ààlii. Boo ghaa-Zɛɛb baazɛdji nyɛ náá: «Yɛ wɔy ɛ́ di Mɛsia, Mɔn Zɛɛb sɛɛ mɛtel é?» ");
INSERT INTO bkw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tin, Yezu eezɛbɔɔza náá: «Hɛɛɛ, ye ɛ́ mam. Bi ɛ́ waabee Sɛɛŋɛlɛ Mɔn Mot ndiindil pɛ mbɔ eghɛŋ mɛbwala ɛ Zɛɛb, ezyɛ tɔ eguud tɔ gwoo.» ");
INSERT INTO bkw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tin, wɔ gwaa, boo ghaa-Zɛɛb zɛnyaa ekaad bɛ. Nyɛ eezɛke náá: «Dum nɛ yak, menaka ɛ́ nɛ gwyes náá, bot zɛlɛɛ mena sa nyɛ di esa ɛ? ");
INSERT INTO bkw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bi eegwak dáa nyɛ di ebyasal Zɛɛb ɛ! Bi bee dáa?» Bɔɔ djas eezɛbɔɔza náá, nyɛ ɛ́ nɛ ndjɛ, nyɛ goka ɛ́ nɛ ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bɛdhiiti bot moo tin esɛɛ Yezu mɛtel é nyel. Bɛ moo tin é zɛbutal nyɛ bhwoob, nɛ tu nyɛ nɛ ekuta. Bɔɔ nɛ nɛ náá: «Naŋa! Ɛzɛ sa wɔ deenek!» Tin, bɛbaalel ɛ Ndjaa-ebuwa, moo tin epak nyɛ mɛbhɛɛz. ");
INSERT INTO bkw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","É ɛwala ɛ Pyɛɛd nadi pɛ si kɔ ɛbɛsɛɛ ɛ, dhiiti moma nadi esa mɛsa tɔ ndjaŋ ɛ boo ghaa-Zɛɛb ɔ zɛzyɛ tin. ");
INSERT INTO bkw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Dáa nyɛ nabee Pyɛɛd egɔɔl du é di tak ɛ, nyɛ eezɛgwyak Pyɛɛd. Bhii tak, nyɛ eezɛke nɛ nɛ náá: «Dɔɔ nɛ wɔy pe, wɔ nagyegyee ɛ́, bi nɛ Yezu, mot Nazalɛt é?» ");
INSERT INTO bkw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wɔ gwaa Pyɛɛd zɛkɛla. Nyɛy náá: «Mɛ ààgu sa wɔ di elii'enek. Mɛ àànyɔ ɛgwak yɛ.» Bhii tak, Pyɛɛd eezɛswoola di, tɔ́ pɛ peeb ɛbɛsɛɛ, tɔ́, kɛtyaa pɛ ɛniel. Tin, wɔ gwaa kuu zɛkɔk. ");
INSERT INTO bkw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","É di'enek, moma tak eebaazɛbee nyɛ, nyɛ moo tin elɛɛ bot ɛ nadi tin ɔ, náá: «Mot tak ɛ́ ngɔt tɔ bɛdjekel bɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pyɛɛd eebaazɛkɛla nyɛ, kɛla sis. Bhii tak, dɔɔ nɛ bot ɛ nadi bɛ nɛ bɛ nɔɔ tin ɔ, baazɛke nɛ Pyɛɛd náá: «Ye ɛ́ tsɛɛtsɛ! Wɔ ɛ́ mot'ɔɔ etɛɛ náá, wɔ ɛ́ mot kyee dik Ghalile.» ");
INSERT INTO bkw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","É di'enek, Pyɛɛd tɔ ɛkɛla tɛp. Wɔ gwaa, nyɛ moo tin etsaal tsuŋ é mis ɛ Zɛɛb: «Zɛɛb pɛ ɛko! Mɛ ààgu mot bi di eke nɛ nam'enɔk.» ");
INSERT INTO bkw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Batsa deenek, kuu eebaakɔk tyee kɔka esok ebá. Tin, wɔ gwaa Pyɛɛd zɛtaala sa Yezu nalɛɛ nyɛ ɛ. «Ɛsok nɛ bɛkuu nɛ kɔk esok ebá, yɛ aakabela ɛ́, wɔ eezekɛla mɛ esok elɛl.» Bhii tak, Pyɛɛd eezɛkɛk nɛ ɛgwyɛ yenek. ");
INSERT INTO bkw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tɔ mɛlem kɛɛŋ, eboo bɛghaa-Zɛɛb, nɛ bɛpaa eYuda, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi, naazɛboma étɛp ɛdjek tɛp tak. Ye nabɛ ɛ́ boo kwan eYuda. Bhii bɛ namɛt Yezu ɛ, bɛ ɛ́ boo zɛkɔl nyɛ mɛmbɔ. Bhii tak, bɛ eezɛtɔ́ nɛ nɛ pɛ daa Kukuma Pilat. ");
INSERT INTO bkw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kuma bɛ nakum nɛ Yezu ɛ, wɔ gwaa, Kukuma Pilat zɛdji nyɛ náá: «Ye ɛ́ wɔy ɛ́ di mɛkoozi mɛ eYuda?» Yezu zɛbɔɔza nɛ nɛ náá: «Hɛɛɛ ye ɛ́ dáa wɔy wɔ ɛmet ke'enek.» ");
INSERT INTO bkw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wɔ gwaa, eboo bɛghaa-Zɛɛb zɛsu nyɛ zukamwaa nɛ etɛp. ");
INSERT INTO bkw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tin, kukuma Pilat eebaazɛke nɛ nɛ náá: «Wɔ ààkataŋal é? Gwaka etɛp djas ee di ekeaa náá, ye ɛ́ wɔy ɛ́ di ekus ɛ.» ");
INSERT INTO bkw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yezu ààkobɔɔza nyɛ yenek. Wɔ gwaa, Pilat djoka nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","É ghɛŋ mɛbyoŋ mɛ ePak djas, Pilat nabebɛ ɛ́ nɛ mɛfulu mɛ ɛpel mot membok ngɔt, da nyɛ ɛ́ wyiselaa é membok. Ɛdhuu ɛ bot ɛ́ naadi esɛ́ɛ, mot Pilat aawyisal é membok ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","É ghɛŋ tak, é membok, ye nabɛ ɛ́ nɛ dhiiti mot ndiila. Din ɛ lɛ nabɛ ɛ́ Bhaalabas. Nyɛ namɛtaa ɛ́ lɔɔg wat, bɛ nɛ bot ɛ nabe boo dho nagó mot ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tin, ɛdhuu ɛ bot ɛ nadi tin ɔ, zokazɛbyet, tɔ́ pɛ daa mɛkoozi étɛp ɛkɛdji nyɛ náá, nyɛ sa, dáa nyɛ bela nɛ ɛsesa sok ɛ, nyɛ bet mot membok ngɔt. ");
INSERT INTO bkw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dáa Kukuma Pilat nabee deenek ɛ, nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Bi kwyɛl ɛ́ náá, mɛ wyisal mɛkoozi mɛ eYuda é?» ");
INSERT INTO bkw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Etɛɛ náá, Pilat nadi egu náá, Yezu nawaaa é membok ɛ étɛp mbee lyem eboo bɛghaa-Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","É di'enek, eboo bɛghaa-Zɛɛb nabɛ ɛ́, bɛ moo besal ɛdhuu ɛ bot bɛ lɛɛ nɛ Pilat náá, ye goka ɛ́, nyɛ wyisal bɛ Bhaalabas. ");
INSERT INTO bkw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat eebaazɛke nɛ nɔɔ náá: «Bi kwyɛl náá, mɛ sa mot bi di edjóo mɛkoozi mɛ eYuda ɔ, dáa?» ");
INSERT INTO bkw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɛdhuu ɛ bot eebaazɛtsim: «Bemka nyɛ é mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat eezɛdji bɛ náá: «Yaa esesɛɛ ɛbiyo nyɛ sa?» Wɔ gwaa, bɛ baazɛtsim ɛlyelɛpe: «Bemka nyɛ é mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Dáa ye nabɛ náá, Pilat nadi ekwyɛl ɛdjɛ bɛ sa elyem bɔɔ nadi ekwyɛl ɛ, nyɛ ɛ́ boowyisal bɛ Bhaalabas. Tin, bhii nyɛ nalwom náá, Yezu nyuŋaa nɛ eghwyɛs ɛ, nyɛ ɛ́ boodjɛ bɛ nya, étɛp bɛ neekɛbem nyɛ é mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Esodja zokazɛtɔ́ nɛ Yezu kɔ ɛbɛsɛɛ ɛ bil ɛ kukuma Pilat. Bhii tak, bɛ eezɛdjóo ɛdhuu ɛ esodja djas, zɛsɛɛg bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bɛ eezɛbet Yezu ndjookuwa na tɔɔbelaa. Bɛ eezɛpyeed nyɛ kel mɛgɔk, sɔm nyɛ yɛ ɛ é lo dáa kɔtɔ mɛkoozi. ");
INSERT INTO bkw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bɛ moo tin eswos nyɛ mɛswosel mɛ mɛduka: «Mɛ eeswos wɔ, mɛkoozi mɛ eYuda!» ");
INSERT INTO bkw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhii tak, bɛ moo nyuu nyɛ é lo nɛ le ghwaazok, esɛɛ nyɛ mɛtel é mis, ekwyit mɛboŋ nɛ ɛmalal sok bhwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bhii bɛ nazeduk nyɛ deenek ɛ, bɔɔ zokazɛdis nyɛ ndjookuwa na tɔɔbelaa bɛ nabet nyɛ ɛ, bɛ eezɛbulal nyɛ ndjookuwa nyɛ nadi nɛ yɛ sok ɛ. Bhii tak, bɛ eezɛwyis nɛ nɛ, étɛp bɛ neekɛbem nyɛ é mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wɔ gwaa, bɛ zɛdjɛ dhiiti mot nadi edus yɛ pɛ pyeeb ɔ, nyɛ kwyee Yezu é ɛbɛp ɛ mɛlaaba nyɛ aakɛbemaa é tak ɛ, nɛ bhel. Din ɛ mot tak nabɛ ɛ́ Simɔŋ, mot dɛl ɛ di djóoaa Silɛn ɛ. Nyɛ nabɛ ɛ́ sɛɛg ɛ Alɛkzandɛlɛ nɛ Lufus. ");
INSERT INTO bkw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tin, bɛ eezɛtɔ́ nɛ Yezu pɛ dhiiti di bɛ nadi edjóo Ghologhota ɛ. Din ɛ tak kwyɛl ɛlɛɛ «Di Bhoobo Lo». ");
INSERT INTO bkw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tin, bɛ eezɛkwyɛl ɛdjɛ Yezu mɛnyok puuza nɛ dhiiti ngwyɛl bɛ di djóo miid ɛ, Yezu eezɛpɛɛ ɛdɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bhii tak, bɛ eezɛbem nyɛ é mɛlaaba. Bot ɛ nadi tin ɔ, zokazɛkaa ekaad bɛ, bhii bɛ nazesa ɛgwyeeg étɛp bɛ neesɛ́ɛ mot aanɔɔ kaad tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bɛ nabem nyɛ é mɛlaaba ɛ́, é ɛwala etɛn nɛ ená yii mɛlem. ");
INSERT INTO bkw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ekwyala ee nadi elɛɛ ɛsuk ɛ bɛ nabem nyɛ é mɛlaaba ɛ, nakwyɛl ɛlɛɛ náá: «Nyɛ ɛ́ mɛkoozi mɛ eyuda.» ");
INSERT INTO bkw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɛ nabem nyɛ é mɛlaaba ɛ́, nɛ bot ɛ djii bɛbá: ngɔt pɛ mbɔ e ghɛŋ; nwyak ngɔt pɛ mbɔ ɛmyɛl.  ");
INSERT INTO bkw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Deenek ɛ́ esesɛɛ djas nadi kwyala ɛ, nabela ɛsuk: «Bɛ nabee nyɛ ɛ́ tyɛ ngɔt nɛ bɛmbee e bot». ");
INSERT INTO bkw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bot ɛ nadi edhaa tin ɔ, nadi egɔ nyɛ, bɔɔ esesyaal elo, edji náá: «Hee! Wɔy mot di náá, wɔ ɛ́ nɛ ghwyil ɛwaaz kok Ndjaa-ebuwa, da wɔ ɛ́ baasum tɔ mɛlu mɛlɛl ɔ, ");
INSERT INTO bkw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tsika nyel'ɔ wɔy wɔ ɛmet. Sula kɔ mɛlaaba mɛ wɔ di bema kɔ tak'enek!» ");
INSERT INTO bkw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tyɛ wat nɛ eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi moo tin ekwyii nyɛ náá: «Nyɛ ɛpetsik bot, nyɛ tok nɛ ghwyil ɛtsik nyel'ɛ nyɛ ɛmet! ");
INSERT INTO bkw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mɛsia, mɛkoozi mɛ bot ɛ mbyak Yisalaɛl, kasul kɔ mɛlaaba bɛ bem wɔ é tak ɛ, étɛp bis neebee, bhii tak, da bis ɛ́ dum koŋ nɛ nɔ!» Dɔɔ nɛ bot ɛ nabemaa bɛ nɛ bɛ nɔɔ ɔ, nabaadi ɛ́, elee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dáa ye nadhaa mɛwala mɛlɛl bhii kuku mwos ɛ, wɔ gwaa, ɛgwyitok zɛgwyiidela kɔ ɛko ɛ bɔs djas, ɛgwyitok ɛlenek naabɔya, kɛkum ɛwala elɛl yii bikoko. ");
INSERT INTO bkw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tin, é ɛwala ɛ tak wat, wɔ gwaa Yezu zɛbo tsim: Eloyi, Eloyi, lama sabatani? Ye kwyɛl ɛlɛɛ ɛ́ náá: «Zɛɛb saag'am, Zɛɛb Saag'am! Étɛp yé wɔ bet mɛ mam mɛ ɛmet deenek?» ");
INSERT INTO bkw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dhiiti mot tɔ bot ɛ nadi tin ɔ, zokagwak dáa Yezu nalii ɛ. Nyɛy nɛ bɛsɔ náá: «Gwakeka! Nyɛ ɛpedjóo Eli!» ");
INSERT INTO bkw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mot ngɔt pak'ɔɔ eezɛwyis kaab, kɛnɔɔ pes kaad, kɔl e le ghwaazok, duu yɛ tɔ mɛnyok mɛ na bwaaz-bwaaz. Bhii tak, nyɛ eezɛsɛɛb Yezu yɛ ɛ, nyɛ needɛ. Wɔ gwaa nyɛ baake nɛ nɔɔ náá: «Betka, djhooka beeka nɛghu Eli ɛ́ waazyɛ, zɛdis nyɛ é mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tin, bhii Yezu bo boo tsim ɛ, nyɛ naazɛsil eswos. ");
INSERT INTO bkw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","É di'enek wat, wɔ gwaa boo lɛmbɛ na pip-pip nadi tɔ Di na Dɛɛ, di ebɛk dhɛŋ nɛ koo tɔ Ndjaa-ebuwa ɔ, zokanyɛɛ kuku tak, kan pɛ ɛko, kɛkum pɛ si. ");
INSERT INTO bkw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Dáa mot di kɔ lo esodja nadi pɛ sok bhwoob ɛ Yezu, nabee dáa Yezu nasil eswos deenek ɛ, nyɛ eezɛke náá: «Nɛ tsɛɛtsɛ, mot'ak nabɛ ɛ́ Mɔn ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ye nabaabɛ pe ɛ́, nɛ boa nadi ebee etɛp binek ɛtsetaɛpe ɔ. Boa ɛ tak nabɛ ɛ́: Maali, moma dɛl ɛ Makdala, nɛ Maali, nyɛɛg ɛ Zak yii mɔɔ dhyeeb bɛ nɛ Yosɛs, zɛnɔɔ Salome. ");
INSERT INTO bkw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ye nabɛ ɛ́, boa nadi egyee e lɔɔg ɛ Yezu ɔ, ye ɛ́ bɔɔ ɛ́ nadi edjedjaabal Yezu é ghɛŋ bɛ nadi pɛ kyee dik Ghalile ɔ, zɛnɔɔ bɛdhiiti bɛtɛ nɛ boa natɔ́ pɛ Yeluzalɛm bɛ nɛ bɛ nɔɔ lɔɔg wat étɛp bɛ neekwyi-kwyee nyɛ nɛ mɛsa ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dáa ye nabɛ náá, dwoo moo ɛ́ bikoko ɛ, ye nagoka ɛ́ náá, mot nɛ mot kɛ ɛkoobal yɛ esesɛɛ etɛɛ náá, mɛlem mɛ nadi du dwoo tak ɛ, nabɛ ɛ́ mɛlem mɛ dwoo saba. ");
INSERT INTO bkw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tin, wɔ gwaa dhiiti mot, din ɛ lɛ nabɛ ɛ́ Zozɛf, nyɛ nadi ɛ́ mot dɛl Alimate. Nyɛ nadi ɛ́, ngɔt tɔ bɛdhil ɛ bot ɛ boo kwan eYuda. Yɛ mɛfulu nabɛ ɛ́ ààdjala nɛ yii bɛsɔ. Nyɛ nabɛ ɛ́ nɛ ɛbwaalel ɛ ɛbee ɛ Ɛyoŋ ɛ Zɛɛb. Wɔ gwaa nyɛ zɛtɔ́, kɛwaab muu ɛ Yezu pɛ daa Kukuma Pilat. ");
INSERT INTO bkw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tin, Pilat eezɛdjoka dáa Yezu naleegwyɛ kaab deenek ɛ. Bhii tak, nyɛ eezɛdjóo mot nadi kɔ elo e esodja bɛ ɔ, nyɛ ɛ́ boozɛdji nyɛ náá: «Yezu eeloogwyɛ mos é?» ");
INSERT INTO bkw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bhii nyɛ nagwak bɔɔza mot nadi kɔ elo e esodja náá, bɛ nalɛɛ nyɛ tsɛɛtsɛ náá, ye nabɛ ɛ́ Yezu naazegwyɛ ɛ́, nyɛ ɛ́ boozɛdjɛ Zozɛf mot Alimate muu ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bhis Zozɛf nakabɔm bheeza na puu ɛ, nyɛ ɛ́ boozɛsil muu ɛ Yezu é mɛlaaba. Bhii tak, nyɛ eezɛpil muu'ɛ tɔ bheeza tak. Tin, nyɛ eezɛnɔɔ yɛ, kɛwa tɔ ɛvit ɛ bɛ nabwak tɔ ɛkok ɛ. Bhii tak, bɛ ɛ́ boozɛdiyal ɛbɛ ɛ ɛvit ɛ tak nɛ boo ɛkok ɛ bɛ nakpak étɛp tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ghuna Maali, moma dɛl ɛ Makdala, nɛ Maali, nyɛɛg ɛ Yosɛs, nadi ebee di bɛ nawa muu ɛ Yezu ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dáa dwoo saba nadhaŋ ɛ, wɔ gwaa Maali, moma dɛl ɛ Makdala, nɛ Maali, nyɛɛg ɛ Zak, zɛnɔɔ Salome zɛtɔ́, kɛbɔm bɛmul ɛ na mbɛɛ mɛnuub étɛp bɛ neekɛlɔɔb yɛ é muu ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tɔ ghooghom mɛlem dwoo mɛkɛn mɛ yenga, bɛ eezɛghɛɛ mɛnyel, zɛtɔ́ pɛ mɛvit. ");
INSERT INTO bkw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bɛ moo tin elii pak'ɔɔ: «Bɛ zɛ aakobiŋal mena ɛkok ɛ bɛ diyal ɛvit nɛ yɛ ɛ nenak é?» ");
INSERT INTO bkw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dáa bɛ kaben mis, gwyák pɛ sok ɛ, bɛ kabee ɛ́, boo ɛkok ɛ bɛ nadiyal ɛvit nɛ yɛ ɛ, yɛ eezebiŋelaa, ye moo é ngwoob ɛvit. ");
INSERT INTO bkw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wɔ gwaa bɛ zɛni tɔ ɛvit, bɛ kabee ɛ́, dhiiti mɔɔ ngbaaz ndiindil pɛ mbɔ eghɛŋ nɛ kaad na puu é nyel. É di tak wat, bwoo eezɛmɛt bɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mɔɔ ngbaaz tak ɛ́ boozɛke nɛ nɔɔ náá: «Sa mot ààbem ba! Bi saŋ ɛ́ Yezu, mot Nazalɛt, nabemaa é mɛlaaba ɔ. Nyɛ eezegom! Nyɛ tokapɛ wak. Beeka di bɛ nakɛl nyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tɔ́ka, kɛlɛɛ nɛ bɛdjekel bɛ nɛ Pyɛɛd náá: “Nyɛ eetɔ́, kɛbwood bin pɛ Ghalile. Ye ɛ́ penek ɛ bi aakɛboma nɛ nɛ dáa nyɛ nalɛɛ bin ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bhii tak, bɛ eezɛwyis tɔ ɛvit, zɛsum kaab é gbakeba etɛɛ náá, bɛbebwol naasa bɛ. Wyisa bɛ nawyis tin ɛ, kaab wat, ààlɛɛ bot étɛp bwoo bɛ nadi nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yezu eezegom tɔ mɛlem mɛ ɛlu ɛkɛn e yenga, nyɛ nakan ɛlyaal nyel'ɛ ɛ́ nɛ Maali, moma dɛl ɛ Makdala, moma nyɛ nasɔ embee esisim etɛn nɛ ebá tɔ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wɔ gwaa Maali tak kɛlɛɛ etɛp e tak nɛ bot ɛ nadi bɛ nɛ Yezu ɔ. Bɛ nadi ɛ́, tɔ ghoŋ nɛ mɛgwyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tin, dáa bɛ nadi egwak dáa Maali nadi eke náá: «Yezu ɛ́ nɛ tsik! Mɛ eebee nyɛ!» Bɔɔ djas nabɛ ɛ́ ààmyaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bhis yenek, bot ɛbá nadi esik, tɔ́ pɛ dɛl ɛ lɔɔ. Wɔ gwaa, Yezu zɛboma nɛ nɔɔ é ze, nyɛ zokazɛtel nyel mbi tela sis. ");
INSERT INTO bkw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bɛdjekel binɔk bɛbá zokabula, zɛlɛɛ bɛsɔ bɔɔ. Bɔɔ ààmyaal bɛ yenek. ");
INSERT INTO bkw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Bhii tak, wɔ gwaa nyɛ zɛtel nyel nɛ bɛdjekel kam nɛ ngɔt nalik ɛ, é sok bɛ nadi kɔ mesa edɛ edee ɛ. Tin, nyɛ eezɛdul bɛ mɛlɔ náá: Bɛ ààdum koŋ nɛ Zɛɛb. Dɔɔ nɛ ɛlyel ɛ lo bɛ di nɛ yɛ ɛ, ààmyaal sa bot ɛ nabee nyɛ, nyɛ eezegom ɔ nalɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bhii tak nyɛ eezɛlɛɛ nɛ nɔɔ náá: «Tɔ́ka kɔ bɔs djas, kɛgoolaka bot ɛ membyak djas Mbɛɛ Bhaadal. ");
INSERT INTO bkw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mot ɛ́ dum koŋ nɛ Zɛɛb, da nyɛ ɛ́ duwa Zɛɛb ɔɔ, mot tak ɛ́ waabela tsik. Mot ɛ́ pɛɛ ɛmyaal ɔɔ, nyɛ waabela ndjɛ tɔ epɛ́ɛ. ");
INSERT INTO bkw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Beeka endem e mɛbwala aalyaal náá, bak ɛ́ bot ɛ di edum koŋ nɛ nam ɔ: Nɛ din ɛ lam, bɛ waasɔ embee esisim. Bɛ waalii elii na bes. ");
INSERT INTO bkw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bɛ waamɛt bɛnyɔ nɛ mɛmbɔ. Nɛghu bɛ dɛ mɛdii mɛ dho ɔɔ, yɛ aanàkwaasa bɛ sonok. Bɛ waakɛl mɛmbɔ mɔɔ kɔ bot ɛ mɛbɛ́, bot ɛ mɛbɛ́ tsak.» ");
INSERT INTO bkw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bhii Ghɛŋ Yezu nazelii nɛ nɔɔ deenek ɛ, wɔ gwaa nyɛ zɛbyet tɔ gwoo. Penek, nyɛ ɛ́ ndiindil pɛ mbɔ eghɛŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bhii tak, bɛdjekel naazɛtɔ́ mɛdhik djas, kɛgoola Mbɛɛ Bhaadal. Ghɛŋ nadi ɛ́ nɛ nɔɔ sama wat, ekwyi-kwyee bɛ tɔ mɛsa. Endem e mɛbwala menek ɛ́ nadi elyaal bot nɛ tsɛɛtsɛ náá, Zɛɛb ɛ́ nadhis bɛ.");
INSERT INTO bkw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Boo-mot Teofil, dáa ye nabɛ náá, bot ɛbuɛpe naakwyɛl ɛkaada tɔ mɛkana etɛp ee nadhaa pak'ena ɛ, ");
INSERT INTO bkw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","nɛ dáa bot ɛ nabee nɛ mis mɔɔ met tyee etɛp bak djas nadi esael nakaadaa bis é mɛkɛn ɛ. Bot ɛ tak nabɛ ɛ́, bɛ moo bot ɛ mɛsa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bhii mɛ nazedu etɛp tak kɛkum pɛ mɛsuk mɛ tak ɛ, mɛ ɛ́ booke náá, ye goka ɛ́ náá, mam pe, mɛ kaada wɔ etɛp bak djas tɔ ekwyala, wɔy kukuma Teofil. ");
INSERT INTO bkw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mɛ sa deenek ɛ́, étɛp wɔ neegu etsɛɛtsɛ e mɛlyo mɛ wɔ nabela ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","É ghɛŋ Elood nadi mɛkoozi kɔ Yude ɛ, ye nabɛ ɛ́ nɛ dhiiti ghaa-Zɛɛb, din ɛ lɛ nabɛ ɛ́ Zakali. Nyɛ nadi ɛ́ ngɔt tɔ sama ɛdhuu ɛ bɛghaa-Zɛɛb nadi tɔ lɔɔg ɛ Abiya ɔ. Myɛl nabɛ ɛ́ dha ɛ boo ghaa-Zɛɛb Alɔn. Din ɛ lɛ nabɛ ɛ́ Elizabɛt. ");
INSERT INTO bkw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bɔɔ djas bɛbá nadi ɛ́ bot ɛ epiki é mis ɛ Zɛɛb. Bɛ nadi eduwal nɛ ɛkɛ tyee etsi nɛ mɛtiŋ ɛ Ghɛŋ di elɛɛ ɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Saabɛgɔs kabɛ ɛ́ náá, bɛ nabɛ ɛ́ ààbɛ nɛ mɔn. Elizabɛt nabɛ ɛ́ kwyiid moma, nyɛ nabɛ ɛ́ ààbɛ nɛ ghwyil ɛbya etɛɛ náá, bɔɔ djas nabɛ ɛ́, bɛ moo bɛtɔa-bot. ");
INSERT INTO bkw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Dhiiti dwoo, Zakali nadi esa mɛsa mɛ yii ghaa-Zɛɛb tɔ Ndjaa-ebuwa, etɛɛ náá, ye nabɛ ɛ́ yɔbɔ lɔɔg ɛ nadi tɔ mɛsa é dwoo tak. ");
INSERT INTO bkw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Bɛ eezɛsa dhiiti ɛgwyeeg tɔ ɛzel ɛ lɔɔ, dáa eboo bɛghaa-Zɛɛb nadi ezezyɛ nɛ ɛsa sok ɛ étɛp bɛ neesɛ́ɛ mot aani, tɔ́ kɛdik bɛmul na mbɛɛ mɛnuub tɔ Di na Dɛɛ ɛ Ghɛŋ ɛ. Zakali ɛ́ nasɛ́ɛaa dwoo tak étɛp ɛkɛdik mɛnanas. ");
INSERT INTO bkw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ɛdhuu ɛ bot djas naleelik ɛ pɛ kel edjaala é ɛwala ɛ mɛnanas na mbɛɛ mɛnuub nadi edikaa tɔ Di na Dɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tin, dhiiti fofop ngɔt ɛ Ghɛŋ zokazɛtuula Zakali «zaka». Fofop tak eezɛtyaa tetel pɛ mbɔ eghɛŋ mesa ebuwa di edikaa bɛmɛnanas ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dáa Zakali nabee nyɛ ɛ́, ye nabɛ ɛ́ bwoo nɛ bɛbebwol naamɛt nyɛ ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","É di'enek, fofop eezɛke nɛ nɛ náá: «Nàdi nɛ bwoo Zakali, etɛɛ náá, Zɛɛb eegwak mendjaala mɔ! Elizabɛt mwalɔ ɛ́ waabela ɛbum. Nyɛ waabya wɔ mɔn mɔɔ motom. Wɔ aaget mɔn tak ɛ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wɔ aadi ɛ́ tɔ boo mɛmyaala. Tin, bot ɛbuɛpe ɛ́ waamyaala dum nɛ ɛbyel ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Etɛɛ náá, nyɛ aadi ɛ́ boo-mot é mis ɛ Ghɛŋ. Nyɛ aanàdɛ mɛnyok mɛ vin, ààdɛ dɔɔ nɛ kwaambi bɛdhiiti mɛnyok mɛ di edjɛ elangi ɛ. Sisim na Dɛɛ ɛ́ waalwood tɔ lɛ nyɛ dinaa tɔ mɔ nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nyɛ waasa náá, bɔn Yisalaɛl ɛbuɛpe bula zɛdum koŋ nɛ Ghɛŋ Zɛɛb'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tin, nyɛ waakɛ sok bhwoob ɛ Ghɛŋ nɛ sisim nɛ eghɛŋ ɛ ngoolel-mɛkpa ɛ Zɛɛb Eli, étɛp nyɛ neebulal ɛgwakel pak bɛsɛɛg nɛ bɔn bɔɔ. Nɛ ɛbaasa náá, bot ɛ di elyel elo ɔ swoola mɛfulu étɛp bɛ needi bot ɛ etsoŋ nɛ epiki.» ");
INSERT INTO bkw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tin, Zakali eezɛke nɛ fofop náá: «Mam aagu náá, etɛp ee wɔ di elɛɛ ɛ, ye ɛ́ tsɛɛtsɛ dáa? Etɛɛ náá, mɛ moo ɛ́ tɔa-mot. Mwalam pe moo ɛ́ yɛ sil-moma.» ");
INSERT INTO bkw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","É di'enek, fofop ɛ́ boozɛbɔɔza nɛ nɛ náá: «Din ɛ lam ɛ́ Ghabhiliɛl. Ye ɛ́ mam ɛ́ dyeebadi sok bhwoob ɛ Zɛɛb étɛp elwomel bɛ. Nyɛ lwom mɛ ɛ, mɛ zɛlii nɛ nɔ, mɛ zɛlɛɛ wɔ mbɛɛ bhaadal'enek. ");
INSERT INTO bkw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Deenek, wɔ ààpamyaal etɛp ee mɛ lɛɛ wɔ ɛ, sonok bɛ náá, etɛp tak ɛ waasɛ́ɛ é ɛwala ɛ Zɛɛb zekoobal ɛ. Étɛp tak ɛ́ di náá, wɔ aadi ɛ́ bubu. Wɔ aanàkwaabaalii, kana dwoo mos kɛkum dwoo esesɛ́ɛ binek djas aasael ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","É di'enek, bot ɛ nazyɛ mendjaala ɔ nadi ebwood Zakali, bɔɔ edjoka dáa nyɛ nadi ebɔya tɔ sum Di na Dɛɛ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tin, dáa nyɛ nakawyis ɛ, nyɛ nabɛ ɛ́, nyɛ moo ààkabɛ nɛ tyee nyɛ kalii nɛ nɔɔ. Tin, bot eezɛgek náá, nyɛ eebee dhiiti djema mɛbwala penek tɔ sum Di na Dɛɛ ɛ Zɛɛb. É di'enek, nyɛ nakalii-lii nɛ nɔɔ ɛ nɛ egeka dáa bubu, étɛp nyɛ nabɛ ɛ́, nyɛ moo bubu. ");
INSERT INTO bkw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tin, dáa Zakali nasilal bim mɛlu mɛ nyɛ nagoka nɛ ɛsa mɛsa mɛ tɔ Ndjaa-ebuwa ɛ Zɛɛb ɛ, nyɛ eezɛsik pɛ dɛl ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ba mɛlu bhii tak, Elizabɛt myɛl eezɛbela ɛbum. Wɔ gwaa, nyɛ zokazɛsɔwa nɛ ɛbum ɛ tak tyee bɛngɔn ɛtɛn. Nyɛ nadi ekeke ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Beea sa Ghɛŋ sa dum nɛ nam ɛ, nyɛ eemyaal ɛdis ɛ mɛ tɔ esa ee nadi edjɛ mɛ sen é mis mɛ bot ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Bhii bɛngɔn ɛtɛn nɛ wat yii ɛbum ɛ Elisabɛt, Zɛɛb eebaazɛdhis fofop Ghabhiliɛl pɛ dɛl ɛ Nazalɛt, pɛ kyee dik Ghalile. ");
INSERT INTO bkw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nyɛ nadhis fofop tak ɛ́ pɛ daa mɔɔ moma ngɔt di ààgu botom ɔ, din ɛ lɛ nabɛ ɛ́ Maali. Nyɛ nadi ɛ́, ghɔɔd motom ngɔt nɛ din ɛ Zozɛf. Zozɛf nabɛ ɛ́ dha ɛ Mɛkoozi Dhavid. ");
INSERT INTO bkw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fofop eezɛtuula nyɛ, swos nyɛ, nyɛy náá: «Dia tɔ mɛmyaala, wɔ eeboma nɛ mbɛɛ bhwoob ɛ Zɛɛb. Ghɛŋ ɛ́ nɛ nɔ lɔɔg.» ");
INSERT INTO bkw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maali moo tinaak «yooo», edjoka nɛ mbi yenek mɛkpa. Nyɛ ɛ́ boozɛdji ɛsuk ɛ yenek mɛswosel. ");
INSERT INTO bkw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Fofop ɛ́ bookake nɛ nɛ náá: «Maali, nàbem ba, etɛɛ náá, wɔ eeboma nɛ mbɛɛ bhwoob ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wɔ waabela ɛbum. Wɔ waabya mɔn mɔɔ motom. Din ɛ wɔ aaget nyɛ ɛ, yɛ aadi ɛ́ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nyɛ aaboodi ɛ́ boo-mot, bɛ aadjóo nyɛ Mɔn Zɛɛb-Mɛkaake. Ghɛŋ Zɛɛb ɛ́ waanɛɛg nyɛ mɛkoozi dáa Dhavid bhaab'ɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Deenek, nyɛ aadi ɛ́ mɛkoozi kɔ mbyak Yisalaɛl kɔm-kɔm. Ɛyoŋ ɛ lɛ aadi ɛ́ ààbɛ nɛ ɛsik.» ");
INSERT INTO bkw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maali eezɛke nɛ fofop náá: «Yiizaag aasael dáa? Mam ɛ́ di ààgu botom'aak?» ");
INSERT INTO bkw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Fofop eezɛbɔɔza nɛ nɛ náá: «Sisim na Dɛɛ ɛ́ waazyɛ kɔ lɔ. Ghwyil ɛ Zɛɛb-Mɛkaake ɛ́ waabutal wɔ. Étɛp tak ɛ mɔn na dɛɛ wɔ waabya ɔ, nyɛ aadjóoaa ɛ́ Mɔn Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dɔɔ nɛ Elizabɛt mɔn nyoog ɛ́ waabya ngbɛ mɔn motom, ye nakoozobɛ náá, nyɛ ɛ́ sil-moma. Nyɛy mot bɛ nadi ekeke náá, nyɛ ɛ́ kwyiid ɔ, ɛbum ɛ lɛ moo mos ɛ́ nɛ bɛngɔn ɛtɛn nɛ wat. ");
INSERT INTO bkw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Etɛɛ náá, ye tok nɛ sa Zɛɛb aadi ààkwak.» ");
INSERT INTO bkw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tin, Maali zɛbɔɔza nɛ nɛ náá: «Mam ɛ́ mot-mɛsa ɛ Ghɛŋ. Ye sael nɛ nam dáa mɛkpa mɔ di eke náá, ye sael ɛ.» Bhii tak, fofop eezɛtɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ààbɔya tɔ mɛlu menek deenek, Maali eezɛghɛɛ, tɔ́ kaab pɛ dɛl ɛ mɛtsok nadi pɛ kyee dik Yude ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nyɛ eezɛni tɔ ndjaŋ ɛ Zakali, bhii tak nyɛ eezɛswos Elizabɛt. ");
INSERT INTO bkw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Dáa Elizabɛt nazogwak-gwakak mɛswosel ɛ Maali ɛ, é di tak wat wɔ gwaa, mɔn zɛkuu nyɛ tɔ mɔ. Tin, wɔ gwaa Sisim na Dɛɛ zɛlwood tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nyɛ eezɛtsim ɛlyelɛpe náá: «Zɛɛb eesɛɛ wɔ mɛtel dhaa boa djas kɔ bɔs'ak! Deenek, esɛɛa mɛtel menek ɛ́ dɔɔ nɛ kɔ mɔn wɔ aabya ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mam ɛ́ yam nwyaa dhiiti vaŋ moma, etɛɛ náá, nyɛɛg ɛ Ghɛŋ'am zyɛ pɛ daa lam? ");
INSERT INTO bkw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Etɛɛ náá, ye bɛ ɛ́, wɔ eebee náá, é sok mɛ gwak mɛswosel mɔ ɛ, ye bɛ ɛ́, mɔn eekuu mɛ tɔ mɔ nɛ mɛmyaala. ");
INSERT INTO bkw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mɛnyɔ nɛ nɔ, etɛɛ náá, wɔ eemyaal náá, Ghɛŋ ɛ́ waasa sa nyɛ lɛɛ wɔ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","É di'enek, Maali eezɛke náá: «Mɛ ɛpeduwal Ghɛŋ nɛ lyem'am djas. ");
INSERT INTO bkw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sisim'am ɛ́ pɛ tɔ boo mɛmyaala kɔ ɛsu ɛ Zɛɛb mɛtsik-bot mam. ");
INSERT INTO bkw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Etɛɛ náá, nyɛ eeliig mis mɛ, gwyák mot-mɛsa mɛ, mam ààkobɛ yam mot ɛtela ɛ nyel. Nɛ tsɛɛtsɛ, kana dwoo ɛlak mos, membu nɛ mesee, bot aakadjóo mɛ ɛ́ “moma Zɛɛb nazesɛɛ mɛtel ɔ”. ");
INSERT INTO bkw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Etɛɛ náá, Zɛɛb Mɛkaake eesa eboo esonok tɔ lam. Nyɛ ɛ́ Zɛɛb na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nyɛ nɛ bu enɛm esa, mɛlu nɛ mɛwala djas dum nɛ bot ɛ di eduwal mɛtiŋ mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nyɛ eesa mɛsa mɛ mɛbwala nɛ eghɛŋ bɛ. Nyɛ eetwak bot ɛ di nɛ mɛbet tɔ elyem ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nyɛ eedis bɛmɛkoozi kɔ mɛbhóó mɛ mɛkoozi mɔɔ. Bhii tak, nyɛ eedjɛ bot ɛ di ààbɛ nɛ ɛbet ɔ, mɛbhóó mɛ mɛkoozi. ");
INSERT INTO bkw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nyɛ eedjɛ mbɛɛ edee nɛ bot ɛ nadi nɛ za ɔ. Nyɛ eeswaal bɛkum ɛ bot mɛmbɔ mɛ toto. ");
INSERT INTO bkw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nyɛ nazyɛ ɛ́ zɛkwyee Yisalaɛl, mot-mɛsa mɛ. Nyɛ ààdjisa ɛlyaal enɛm nɛ embɛɛ bɛ ");
INSERT INTO bkw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nɛ Abalaam bɛ nɛ bɛdha bɛ, kɔm-kɔm sii nɛ kɔm, dáa nyɛ nakɛk bɛbhaab binaka ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tin, Maali eezɛdi pɛ daa Elizabɛt tyee bɛngɔn ɛlɛl, bhii tak, nyɛ eezɛsik pɛ dɛl ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ɛwala nabɛ náá, Elizabɛt ɛ́ waabya ɛ, yɛ eezɛkum. Wɔ gwaa, nyɛ zɛbya mɔn motom. ");
INSERT INTO bkw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bɛsɔ bot ɛ nadi nɛ mendjaa ɛkunaaɛpe nɛ nɛ ɔ, nɛ bot ɛ mɛbyel mɛ zokazɛgwak náá, Ghɛŋ nabɛ ɛ́, nyɛ naagek nyɛ ghoŋ. Bɛ nɛ bɛ nɔɔ moo tin tɔ mɛmyaala bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Dáa mɔn nabɛ, nyɛ moo nɛ mɛlu mɛtɛn nɛ elɛl bhis ɛbyel ɛ lɛ ɛ, wɔ gwaa, bɛ zɛtɔ́ étɛp ɛkɛniigal nyɛ beka. Bɛ nakwyɛl ɛget nyɛ ɛ nɛ din ɛ sɛɛg Zakali. ");
INSERT INTO bkw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tin, nyɛɛg ɛ́ boopɛɛ, nyɛ ɛ́ boozɛke náá: «Ààbɛ! Din ɛ lɛ aadi ɛ́ Zaŋ.» ");
INSERT INTO bkw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","É di'enek, wɔ gwaa bɛ zɛke nɛ nɛ náá: «Deenek, ye tok nɛ mot ngɔt tɔ bot bɔ nadi nɛ din ɛ Zaŋ!» ");
INSERT INTO bkw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tin, tɔ ɛgek ɛ dáa ebubu di elii ɛ, bɛ eezɛdji sɛɛg mɔn, din ɛ nyɛ nakwyɛl ɛget mɔn'ɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wɔ gwaa Zakali zokazɛwaab náá, bɛ zyɛ nyɛ nɛ mɔɔ pɛt ɛbaya bɛ di ezezyɛ nɛ ɛkwyal kɔ tak ɛ. É di tak, wɔ gwaa, nyɛ zokakwyal náá: «Nɛ tsɛɛtsɛ, din ɛ lɛ ɛ́ Zaŋ.» Tin, bɔɔ djas naazɛdjoka ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","É di tak wat, wɔ gwaa, Zakali zɛbaakan ɛlii ɛnyɔɛpe. Nyɛ moo tin etsim ɛlyelɛpe eduwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","É di'enek, bot djas nadi bɛ nɛ bɛ nɔɔ ɛ, bɛ nadi ɛ́ bɛ moo nɛ bwoo, pɛ kɔ mɛl mɛ nadi tɔ mɛtsok mɛ kyee dik Yude ɛ. Tin, bot nazokakekaada ɛ tɛp'enek. ");
INSERT INTO bkw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bot djas nadi egwak dáa tɛp tak nasael ɛ, bɛ moo tin esiiza tɔ bhum elyem bɔɔ, edji náá: «Mɔn tak aadi zɛ?» Ye nabɛ ɛ́ tsɛɛtsɛ náá, ghwyil ɛ Ghɛŋ nadi ɛ́ tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakali, sɛɛg mɔn nabɛ ɛ́, nyɛ eelwood nɛ Sisim na Dɛɛ. Wɔ gwaa, nyɛ zokani egoola mɛkpa mɛ Zɛɛb tɔ Sisim. Nyɛ nadi ekeke ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Mena goka ɛ́ nɛ ɛsɛɛ Ghɛŋ Zɛɛb bot ɛ Yisalaɛl mɛtel. Etɛɛ náá, nyɛ eezɛkwyee bot ɛ mbyak'ɛ, nyɛ eepɛk bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nyɛ eewyisal mena ghɛŋ mot, mɛtsik-bot, pɛ tɔ bɛdha ɛ mɛkoozi Dhavid mot-mɛsa mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ye ɛ́ etɛp ee nyɛ naloozelɛɛ tɔ enuub e bɛngoolel ɛ mɛkpa mɛ na edɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nyɛ naakɛk mena tsik di epɛk mena é mɛmbɔ mɛ bot ɛ mɛbhuka mena ɛ, dɔɔ nɛ si mɛko mɛ bot ɛ di esa mena ɛbiyo ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nyɛ naagék ghoŋ nɛ bɛbhaab benaka. Nyɛ nabɛ ɛ́ ààdjisa ɛbhɛŋ ɛ lɛ na dɛɛ nyɛ nalik ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nɛ tsɛɛtsɛ ye nabɛ ɛ́, Zɛɛb eetuwal myoŋ nɛ mɛsoŋ mɛ é mis mɛ bhaab'ena Abalaam náá, ");
INSERT INTO bkw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nyɛ waazɛpɛk mena é mɛmbɔ mɛ bot ɛ mɛbhuka mena. Étɛp mena neesaka mɛsa mɛ, ààbɛ nɛ bwoo tɔ ebhum elyem bena. ");
INSERT INTO bkw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Etɛɛ náá, mena needika dɛɛ nɛ piki é mis mɛ, é mɛlu mɛ tsik'ena djas. ");
INSERT INTO bkw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Deenek, wɔy mɔn'am, wɔ aadi ɛ́, ngoolel-mɛkpa ɛ Zɛɛb-Mɛkaake. Etɛɛ náá, wɔy ɛ́ kwaakɛ sok bhwoob ɛ Ghɛŋ étɛp wɔ neekoobal mɛze mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Etɛp wɔ neelɛɛ bot bɛ náá, nyɛ ɛpezyɛ zɛtsik bɛ, da pel mesyem mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tsɛɛtsɛ, Zɛɛb'enabɛlka nɛ bu enɛm esa, nɛ kwyɛl. Dusa tɔ gwoo, nyɛ eewyisal kɔ lena gwyɛ tyee wat nɛ mɛkas mɛ gwyes di edjem tɔ mɛlem ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Etɛɛ náá, nyɛ neewyisal bot ɛ di tɔ ghooghom, nɛ tɔ piyo ɛsyee ɔ, tɔ gwyɛ. Nyɛ needjɛɛd mɛko mɛ kyeed mena pɛ ze egwyem.» ");
INSERT INTO bkw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Dáa mɔn nadi ewyee ɛ, sisim yɛ nabaadi ewyee ɛbuɛpe. Nyɛ nadidi ɛ́, tɔ kyee dik bɛsyɛ di ààbɛ nɛ mɛdii ɛ, kɛkum dwoo nyɛ nazɛlyaal bot ɛ Yisalaɛl nyel ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","É ghɛŋ tak, wɔ gwaa, Sezaad Oghust zokazɛlwom bot, bɛ kwyal min mɛ mɛtaŋ mɛ bot ɛ bɔs djas. ");
INSERT INTO bkw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ɛkɛn ɛ ɛlɛɛga nɛ ɛkwyal ɛ min mɛ bot nasael ɛ́ é ghɛŋ Kilinus nadi kukuma dik Siili ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bot djas nadi etɔ́ kɛkwyekwyalaa min ɛ mot nɛ mot pɛ dɛl ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zozɛf zokadus pɛ kyee dik Ghalile, pɛ ghaada Nazalɛt, nyɛ neezɛtɔ́ pɛ kyee dik Yude, pɛ dɛl ɛ Bheteleɛm, etɛɛ náá, nyɛ nabɛ ɛ́ dha ɛ Dhavid. ");
INSERT INTO bkw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nyɛ ɛ́ bootɔ́ pɛ ɛlɛɛga nɛ ekwyala e min bɛ nɛ ghɔɔd'ɛ Maali. Maali nadi ɛ́ nɛ ɛbum. ");
INSERT INTO bkw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Dáa bɛ nakadi tin ɛ, wɔ gwaa, ɛwala ɛ nabɛ náá, Maali ɛ́ waasyas ɛ zokazɛkum. ");
INSERT INTO bkw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nyɛ ɛ́ boozɛbya mɔn mɛgwyak mɛ. Tin, nyɛ ɛ́ boozɛbet nyɛ ɛghɔɔd, pil nyɛ tɔ bhelangiti, bhii tak nyɛ eezɛkɛl nyɛ kɔ mɔɔ tɛɛg bɛ nadi ekekɛl edee e ebhata ɛ, etɛɛ náá, bɛ nabɛ ɛ́ ààbela di tɔ ndjaa bɛdjoŋ. ");
INSERT INTO bkw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","É kyee dik tak wat, ye nabɛ ɛ́ nɛ bɛbaalel ɛ ebhata, bɛ nadi ɛ́ tɔ bal ebaal ɛsaŋ ɛ ebhata bɔɔ é pum. ");
INSERT INTO bkw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wɔ gwaa, fofop ɛ Ghɛŋ zɛtuula bɛ. Mɛkas ɛ Ghɛŋ naazɛkaal bɛ «bwyeee». Wɔ gwaa, bwoo zɛsa bɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tinaak, fofop eezɛlɛɛ bɛ náá: «Nàbemka ba, etɛɛ náá, mɛ zyɛ ɛ́, zɛgoola bin mbɛɛ bhaadal, yii bot djas aamyaala nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","É pum'ak mos, kɔ dɛl ɛ Dhavid, mɛtsik-bot eezebyel étɛp'en. Ye ɛ́ Mɛsia, Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Beeka geka bi aagwyak nyɛ nɛ yɛ ɛ: bi ɛ́ waabela mɔn tɔlɔɔ wola tɔ bhelangiti, ndjaasi kɔ mɔɔ tɛɛg bɛ di ekɛl edee e ebhata ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","É di'enek wat, wɔ gwaa, bɛtɛ nɛ efofop zokadus tɔ gwoo, zɛsɛɛga nɛ fofop nadi tinaak sok ɔ, bɛ moo tin eduwal Zɛɛb, bɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Duu nɛ Zɛɛb pɛ ɛko tɔ gwoo, tin, egwyem kɔ bɔs dum nɛ bot ɛ nyɛ di ekwyɛl ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dáa efofop nalik bɛ, sik pɛ tɔ gwoo ɛ, bɛbaalel ɛ mɛsaa mɛ ebhata zokazɛke pak'ɔɔ náá: «Djhootɔ́ka pɛ Bheteleɛm. Ye goka ɛ́ náá, mena beeka sa tuula penek ɛ, sa Ghɛŋ lyaal menaka ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bɛ eezɛghɛɛ mɛnyel tɔ́, tin, bɛ eezɛbela Maali bɛ nɛ Zozɛf, dɔɔ nɛ mɔn tɔlɔɔ ndjaasi kɔ mɔɔ tɛɛg bɛ nadi ekekɛl edee e ebhata ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Dáa bɛ nakabee nyɛ ɛ́, wɔ gwaa, bɛ zɛlɛɛ etɛp ee fofop'enɔk nalɛɛ bɛ dum nɛ mɔn tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","É ghɛŋ bot djas nadi egwak mbi etɛp ee bɛbaalel ɛ mɛsaa mɛ ebhata binek nadi elɛɛ ɛ, bot djas naadyeebadjoka. ");
INSERT INTO bkw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yɛ kabɛ Maali ɔ, nyɛ nazobaal etɛp binek djas ɛ́ tɔ bum lyem'ɛ. Tin, nyɛ moo esiiza ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhii tak, bɛbaalel ɛ mɛsaa mɛ ebhata ɛ́ boozɛsik. Bɛ nadi eduwal Zɛɛb, étɛp endem ee bɛ nazebee ɛ, nɛ yii bɛ nazegwak ɛ, nɛ etɛp ee efofop nalɛɛ, nabatasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bhii mɛlu mɛtɛn nɛ elɛl mɔn nabyel ɛ, wɔ gwaa, bɛ zɛtɔ́, kɛniigal nyɛ beka, tin, bɛ eezɛget nyɛ din ɛ Yezu, din ɛ fofop nalɛɛ bɛ, ɛsok nɛ nyɛɛg nɛ bela ɛbum ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tin, ɛwala ɛ nabɛ náá, Zozɛf bɛ nɛ Maali kɛsa mɛzel mɛ etsi ɛ Moiiz nadi elɛɛ étɛp ɛbyel ɛ mɔn ɛ, yɛ eezɛdjala. Wɔ gwaa, bɛ zɛtɔ́ nɛ mɔn pɛ kok Ndjaa-ebuwa Yeluzalɛm étɛp ɛkɛlyaal Ghɛŋ mɔn. ");
INSERT INTO bkw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Etɛɛ náá, tɔ etsi ɛ Ghɛŋ, ye nabɛ ɛ́, yɛ eekwyalaa náá: «Mɔn motom, yii mɛgwyak aabyel ɔ, nyɛ aadi ɛ́ ngbɛ Ghɛŋ.» ");
INSERT INTO bkw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bɛ nabaadi ɛ́, edjɛ dɔɔ nɛ dhiiti buwa yii etsi e tak wat di edji ɛ. Ye nabɛ ɛ́: «Mɛpepak mɛmbá, nɛghu bɔɔ mɛgum mɛmbá.» ");
INSERT INTO bkw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pɛ Yeluzalɛm, ye nadi ɛ́, nɛ dhiiti mot, din ɛ lɛ nabɛ ɛ́ Simɛyɔŋ. Nyɛ nadi ɛ́, mot epiki, eduwal Zɛɛb. Nyɛ nadi ebwood mot aazɛtsik Yisalaɛl ɔ. Sisim na Dɛɛ nadi ɛ́ nɛ nɛ lɔɔg. ");
INSERT INTO bkw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sisim na Dɛɛ naaloolɛɛ nyɛ náá, ɛsok nɛ nyɛ nɛ gwyɛ, nyɛ waabee Mɛsia Ghɛŋ aadhis ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Wɔ gwaa, Sisim na Dɛɛ zɛdul Simeyɔŋ, nyɛ tɔ́ pɛ kok Ndjaa-ebuwa. Bɛbyael ɛ Yezu naazyɛ nɛ mɔn'ɔɔ étɛp ɛzɛsa nyɛ dáa mɛkpa mɛ etsi di elɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyɔŋ ɛ́ boobɛp mɔn tɔ mɛmbɔ mɛ. Bhii tak, nyɛ eezɛghaapɛɛ Zɛɛb. Nyɛy náá: ");
INSERT INTO bkw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Nenak, Ghɛŋ, beta kwom'ɔ nyɛ gwyɛ tɔ egwyem, tyee wɔ nalɛɛ nyɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Etɛɛ náá, mis mam eezebee tsik wɔ nadhis bis yɛ ɛ, ");
INSERT INTO bkw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","tsik wɔ nazekoobal étɛp membyak djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ye ɛ́ ngel aasa náá, membyak mesis gu wɔ ɛ. Ye ɛ́ duu bot ɛ mbyak'ɔ, Yisalaɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sɛɛg nɛ nyɛɛg ɛ Yezu nabɛ ɛ́, edjoka dáa Simeyɔŋ nadi elii dum nɛ mɔn'ɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simɛyɔŋ ɛ́ boozɛsɛɛ bɛ mɛtel, nyɛ nɛ Maali nyɛɛg náá: «Zɛɛb dhis mɔn'ak ɛ, étɛp ɛkwyesal bot ɛbuɛpe nɛ ɛwyɛl bot ɛbuɛpe pɛ kɔ Yisalaɛl. Nyɛ aadi ɛ́, ndem ngɔt ɛ Zɛɛb. Bot ɛbuɛpe ɛ́ waasyaala bhyeed kɔ lo'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tin, nyɛ waalyaal popoopwon egeka ee di esyela tɔ ebhum elyem e bot ɛbuɛpe ɛ. Yɛ kabɛ wɔy Maali ɔ, mezuk ɛ waatuu wɔ lyem dáa pɛl, kɛtuula pɛ yii kyee.» ");
INSERT INTO bkw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ye nabaabɛ ɛ́ nɛ dhiiti ngoolel-mɛkpa ɛ Zɛɛb. Din ɛ lɛ nabɛ ɛ́ An. Nyɛ nabɛ ɛ́ ɛsyes ɛ Fanuɛl, mot mbyak ɛ Asɛɛd. Nyɛ nabɛ ɛ́, nyɛ eezedyeebageeb. Nyɛ nabɛ ɛ́, nyɛ naadi membu metɛn nɛ ebá, bɛ nɛ ngom naba nyɛ, nyɛ dinaa ààgu botom ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bhis ɛsyee ɛ ngom, nyɛ nabɛ ɛ́ ààkabaatɔ́ ɛba, kɛkum membu mɛkam-mɛtɛn nɛ elɛl nɛ membu mená (84). Nyɛ nabɛ ɛ́ ààdus tɔ kok Ndjaa-ebuwa. Nyɛ nadidi ɛ́, esa mɛsa mɛ Zɛɛb mwos nɛ pum, nɛ ɛtsi ɛ edee tɔ mendjaala. ");
INSERT INTO bkw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wɔ gwaa, nyɛ zɛtuula dwoo tak wat, nyɛ moo tin eduwal Zɛɛb, bhii tak nyɛ moo elii nɛ bot ɛ nadi ebwood náá, Yeluzalɛm zɛpɛkel é ban ɔ, dum nɛ mɔn tɔlɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dáa sɛɛg nɛ nyɛɛg ɛ Yezu nasilal ɛsa esesɛɛ djas etsi ɛ Ghɛŋ nadi elɛɛ ɛ, bɛ eezɛsik nɛ nɛ pɛ kyee dik Ghalile pɛ dɛl ɛ lɔɔ Nazalɛt. ");
INSERT INTO bkw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tin, ye nabɛ ɛ́ mɔn eewyee nɛ ɛbɛɛ ɛ mis, Zɛɛb naawa tɔ lɛ etsoŋ nɛ enɛm nɛ embɛɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Membu djas bɛbyael ɛ Yezu nabɛ ɛ́, etetɔ́ pɛ Yeluzalɛm étɛp ɛkɛbɔl ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Dáa Yezu nabɛ nyɛ moo nɛ membu kam nɛ ebá ɛ, bɛ ɛ́ boozɛtɔ́ nɛ nɛ, dáa ye nadi ezezyɛ nɛ ɛsesɛɛ tɔ mɛfulu mɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dáa ɛbyoŋ nasi ɛ, bɛ eezɛsik. Ghuna mɔn'ɔɔ Yezu naalik pɛ Yeluzalɛm, tinaak, bɛbyael ɛ Yezu ààgu. ");
INSERT INTO bkw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bɔɔ nadi egek ɛ náá, nyɛ ɛ́ bɛ nɛ bɛdhiiti bot tɔ zukamwaa nɛ bot ɛ nadi ekɛ lɔɔg wat bɛ nɛ bɛ nɔɔ ɔ. Tin, bɔɔ zokakɛ muu dwoo. Wɔ gwaa, bɛ zɛkan ɛsaŋ ɛ nyɛ pak bɔn nyɛɛg bɔɔ, nɛ bɛsɔ bɔɔ bot ɛ nadi é ɛbyoŋ bɛ nɛ bɛ nɔɔ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bɔɔ ààbela nyɛ ɛ yenek. Bɛ ɛ́ boozɛsik pɛ Yeluzalɛm esaa nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tin, kuma ye nakum mɛlu mɛlɛl bɔɔ esaa nyɛ ɛ, wɔ gwaa, bɛ zɛbela nyɛ tɔ kok Ndjaa-ebuwa. Nyɛ nadi ɛ́, ndiindil, bɛlyoel eewa nyɛ kuku ɛbwak, nyɛy egwak bɛ, nɛ ɛbaadji bɛ ekiya. ");
INSERT INTO bkw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bot djas nadi egwak nyɛ ɔ, bɛ nadi edjoka ɛbuɛpe nɛ kwaambi etsoŋ nyɛ nadi nɛ yɛ ɛ, nɛ dáa nyɛ nadi ebɔɔza ekiya bɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Dáa sɛɛg nɛ nyɛɛg nabee nyɛ ɛ, wɔ gwaa bɛ zɛdjoka ɛbuɛpe. Nyɛɛg ɛ́ boozɛke nɛ nɛ náá: «Mɔn'am, étɛp yé wɔ sa bis deenek? Bhum elyem e bis nɛ soog di ɛ́ pɛ ɛko. Bis eesaa wɔ, saa saa.» ");
INSERT INTO bkw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Bi saa mɛ étɛp yé? Bi ààgu náá, mɛ ɛ́ tɔ ndjaa saag'am, étɛp ɛsa mɛsa mɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kabela náá, bɛ nabɛ ɛ́ ààmɛt ɛsuk ɛ sa nyɛ nadi elii ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bhii tak, bɛ eezɛsik nɛ nɛ pɛ Nazalɛt. Nyɛ nadi elooba nɛ nyɛɛg nɛ sɛɛg. Tin, nyɛɛg zokabaal etɛp binek djas tɔ lyem'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yezu moo tin ewyee nɛ tyɛ, nɛ etsoŋ, nɛ enɛm nɛ embɛɛ é mis mɛ Zɛɛb nɛ é mis mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye nabɛ ɛ́, é sok Sezaad Tibɛɛd nadi, nyɛ moo nɛ membu kam nɛ etɛn kɔ bóó ekukuma dik'ɛ ɛ, Pɔɔs Pilat nadi ɛ́ kukuma Yude, Elood kadi ɛ́ ekɔk kɔ Ghalile. Yɛ kabɛ mɔn nyɛɛg Filip ɔ, nyɛ nadi ɛ́ kukuma kyee dik Ituud, nɛ Talakonitid. Lizanyas nakabɛ yɛ ɛ kukuma kyee dik Abilɛn. ");
INSERT INTO bkw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","É ghɛŋ Anas nɛ Kayif nadi eboo bɛghaa-Zɛɛb ɛ, ye nabɛ ɛ́ Zɛɛb naalii nɛ Zaŋ mɔn Zakali pɛ tɔ bal. ");
INSERT INTO bkw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zaŋ zokazyɛ kɔ mɛl mɛ nadi pɛ kyee dik wat nɛ dii Yuldɛn ɛ. Nyɛ natutuud ɛ́ náá: «Liigka elyem, da bi ɛ́ kɛduwa Zɛɛb. Tin, Zɛɛb ɛ́ waapel mesyem men.» ");
INSERT INTO bkw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","É di'enek, etɛp ee nadi kwyala tɔ Mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi ɛ, ye naabela ɛsuk. Ye nabɛ ɛ́ náá: «Mot ngɔt ɛpetuud tɔ bal: “Koobalka ze ɛ Ghɛŋ, da bi ɛ́ tuu nyɛ mɛze mɛ na looba-looba! ");
INSERT INTO bkw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Edi e na sɛbɛtɛɛ di pak mɛtsok djas ɛ, yɛ waabimelaa. Mɛtsok nɛ eghooda djas ɛ́ waasilaa. Memboŋ djas di é ze ɛ, yɛ waasekaa. Mɛze mɛ di, yɛ eezepulel ɛ, yɛ waakoobelaa. ");
INSERT INTO bkw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tin, bot djas ɛ́ waabee tsik Zɛɛb aadjɛ ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mɛdhuu mɛ bot nadi ezyɛ pɛ daa Zaŋ etɛɛ náá, Zaŋ neezɛduu bɛ Zɛɛb. Zaŋ zokake nɛ nɔɔ náá: «Biyɔ mɛgel mak, ɛzɛ lyo bin náá, bi kaab ɛbuk ɛ Zɛɛb di ekunaa yenek? ");
INSERT INTO bkw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Lyaalka nɛ esesɛɛ bin náá, ye ɛ́ tsɛɛtsɛ náá, bi eezeswoola etsik bin, da bi ɛ́ bet ɛke biyɔ nɛ biyɔ náá: “Dhiiti sonok aanàkwaasa mena, etɛɛ náá, Abalaam ɛ́ bhaab'enaka.” Betka mɛ lɛɛ bin náá, Zɛɛb ɛ́ nɛ ghwyil ɛsa náá, mɛkok mak liiza, ye di bɛdha ɛ Abalaam. ");
INSERT INTO bkw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ye goka ɛ́ bi ɛ́ gu náá, zoŋ moo ɛ́ nɛɛga é ɛbok ɛ le, étɛp ye neetsaal ekaŋal e tak. Ele djas aadi ààdjɛ bhum ɛ, goka ɛ́ nɛ ɛtsaalaa. Bhii tak, yɛ waakɛdikaa tɔ du.» ");
INSERT INTO bkw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wɔ gwaa bot moo tin edji nyɛ náá: «Bis goka nɛ ɛsa dáa?» ");
INSERT INTO bkw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Mot di nɛ ekuwa ebá ɔ, goka ɛ́ nɛ ɛgwyena wat, djɛ mot di ààbɛ nɛ yɛ ɔ. Bela náá, mot di nɛ edee e dek ɔ, nyɛ kaa nɛ bot ɛ́ di ààbɛ nɛ yɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bɛnɔŋel ɛ epata e lapo zokabaazyɛ yɔbɔ zɛduwa Zɛɛb. Wɔ gwaa bɛ dji Zaŋ Nduuel-bot náá: «Lyoel, bis goka nɛ ɛsa dáa?» ");
INSERT INTO bkw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Nàwaabka bot epata e lapo dhaa yii kukuma di elɛɛ náá, bi goka nɛ ɛwaab ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Esodja zokabaadji yɔbɔ náá: «Yɛ kabɛ bis ɔ, bis goka nɛ ɛsa dáa?» Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Sa mot ààbaanɔɔ sa mot nɛ bhel, sa mot ààsu mot tɛp. Bi goka ɛ́ nɛ ɛdɛ ɛ efute e mɛsa min.» ");
INSERT INTO bkw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bot djas nadi ebwood nɛ ɛbwaalel djas. Bot djas nagek ɛ́ náá, Zaŋ nabɛ ɛ́ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nyɛ eezɛke nɛ bɔɔ djas náá: «Mam duu bin Zɛɛb ɛ́ tɔ mɛdii. Yɛ kabɛ mot di ezyɛ bhis'am ɔ, nyɛ eedhaa mɛ nɛ mɛbwala nɛ ghwyil. Mam aanàkwaakobela-belak duu ɛmalal étɛp ɛkotii-tiiak ekel e ekoko bɛ. Nyɛy aaduu bin Zɛɛb ɛ́ tɔ ghwyil Sisim na Dɛɛ nɛ tɔ du. ");
INSERT INTO bkw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tɔ mɛmbɔ mɛ, nyɛ eemɛt zyaagal étɛp nyɛ neewa mbɛk pak mbee bhum nɛ mbɛɛ bhum. Tin, da nyɛ ɛ́ wa mbɛɛ bhum kɔ taa. Yɛ kabɛ embee bhum ɔ, nyɛ kakɛmwas yɛ ɛ tɔ du na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zaŋ naalelɛɛ bot Mbɛɛ Bhaadal nɛ bɛtɛ nɛ dhiiti bɛmɛlyo. Nyɛ nadi elyo bɛ nɛ ɛdjɛ bɛ ghwyil. ");
INSERT INTO bkw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Wɔ gwaa, Zaŋ zokazɛdul mɛkoozi Elood mɛlɔ kɔ ɛsu ɛ Helodhiaad mwaa mɔn nyɛɛg nyɛ nadɛk ɔ, dɔɔ nɛ étɛp embee esesɛɛ nyɛ nadi esa ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tin, Elood naabaazɛsa dhiiti mbee tɛp: nyɛ naawa Zaŋ é mbok. ");
INSERT INTO bkw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bhii bot djas nazeduwa Zɛɛb ɛ, Yezu pe naazɛduwa Zɛɛb. Nyɛ nadi edjaala, wɔ gwaa gwoo zɛbɛŋel. ");
INSERT INTO bkw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bhii tak, Sisim na Dɛɛ eezɛsul kɔ lɛ tyee ɛghum. Wɔ gwaa, dhiiti gwood zokazɛgék tɔ gwoo náá: «Wɔ ɛ́ mɔn'am mɛ dyeebakwyɛl ɔ. Mɛ eedyeebamyaala nɛ nɔ ɛbuɛpe.» ");
INSERT INTO bkw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yezu nabɛ ɛ́, nyɛ moo nɛ membu tyee mɛkam-mɛlɛl é sok nyɛ nakan mɛsa mɛ ɛ, nɛ dáa bot nadi eke náá, nyɛ ɛ́ mɔn Zozɛf ɛ. Zozɛf nadi ɛ́ mɔn Eli. ");
INSERT INTO bkw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɛ́ mɔn Mattat, Mattat nakadi ɛ́ mɔn Levi. Levi nabɛ ɛ́ mɔn Mɛlki, Mɛlki nakadi ɛ́ mɔn Zanayi, Zanayi nabɛ ɛ́ mɔn Zozɛf. ");
INSERT INTO bkw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zozɛf nakadi ɛ́ mɔn Mattatya, Mattatya nabɛ ɛ́ mɔn Amɔs. Amɔs ɛ́ mɔn Nawum. Sɛɛg ɛ Nahum nabɛ ɛ́ Esli, Esli ɛ́ mɔn Naghayi. ");
INSERT INTO bkw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naghayi nabɛ ɛ́ mɔn Maat. Mot nabya Maat ɔ nabɛ ɛ́ Matatyas. Matatyas nabɛ ɛ́ mɔn Semeyi. Mot nabya Semeyi ɔ, nabɛ ɛ́ Yosɛk. Yosɛk nabɛ ɛ́ mɔn Yoda. ");
INSERT INTO bkw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda nakadi ɛ́ mɔn Yoanan. Sɛɛg ɛ Yoanan nabɛ ɛ́ Lesa. Lesa nadi ɛ́ mɔn Zolobabɛl, Zolobabɛl nakadi ɛ́ mɔn Salatyɛl, Salatyɛl nabɛ ɛ́ mɔn Neeli. ");
INSERT INTO bkw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeli nakadi ɛ́ mɔn Mɛlki, Mɛlki nadi ɛ́ mɔn Adhi, Adhi nakadi ɛ́ mɔn Kosam, Kosam nadi ɛ́ mɔn Elmadham. Elmadham nakadi ɛ́ mɔn Eed. ");
INSERT INTO bkw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Mot nabya Eed ɔ, nabɛ ɛ́ Zosue, Zosue nabɛ ɛ́ mɔn Eliezɛɛd, Eliezɛɛd kadi ɛ́ mɔn Yolim, Yolim nabɛ ɛ́ mɔn Matat. Matat kadi ɛ́ mɔn Levi. ");
INSERT INTO bkw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi nabɛ ɛ́ mɔn Simeyɔŋ, Simeyɔŋ kadi ɛ́ mɔn Yuda. Yuda nabɛ ɛ́ mɔn Zozɛf, Zozɛf kadi ɛ́ mɔn Yonam, Yonam nabɛ ɛ́ mɔn Eliakim. ");
INSERT INTO bkw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nakadi ɛ́ mɔn Melea, Melea nabɛ ɛ́ mɔn Mena, Mena nakadi ɛ́ mɔn Matata. Sɛɛg ɛ Matata nabɛ ɛ́ Natan, Natan kadi ɛ́ mɔn Dhavid. ");
INSERT INTO bkw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dhavid nabɛ ɛ́ mɔn Yese, Yese kadi ɛ́ mɔn Obɛɛd. Obɛɛd nabɛ ɛ́ mɔn Bhooz, Bhooz kadi ɛ́ mɔn Sala. Sala nabɛ ɛ́ mɔn Naasɔn. ");
INSERT INTO bkw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasɔn kadi ɛ́ mɔn Aminadaab, Aminadaab nabɛ ɛ́ mɔn Almin, Almin kadi ɛ́ mɔn Aalni. Aalni nabɛ ɛ́ mɔn Ɛslɔn, Ɛslɔn kadi ɛ́ mɔn Pelɛɛz, Pelɛɛz nabɛ ɛ́ mɔn Yuda. ");
INSERT INTO bkw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda nabɛ ɛ́ mɔn Zakɔɔb, Zakɔɔb nakadi ɛ́ mɔn Izak. Izak nabɛ ɛ́ mɔn Abalaam. Sɛɛg ɛ Abalaam nabɛ ɛ́ Teela, Teela nabɛ ɛ́ mɔn Nakɔɔd. ");
INSERT INTO bkw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakɔɔd nabɛ ɛ́ mɔn Seluug, Seluug nabɛ ɛ́ mɔn Lewu, Lewu kadi ɛ́ mɔn Pelɛɛg. Pelɛɛg nabɛ ɛ́ mɔn Ebɛɛd, Ebɛɛb nabɛ ɛ́ mɔn Sala. ");
INSERT INTO bkw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala nabɛ ɛ́ mɔn Kenan, Kenan nabɛ ɛ́ mɔn Alpaksaad, Alpaksaad ɛ́ mɔn Sɛm, Sɛm ɛ́ mɔn Noe, Noe ɛ́ mɔn Lemɛk. ");
INSERT INTO bkw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemɛk nabɛ ɛ́ mɔn Matusalɛm, Matusalɛm nabɛ ɛ́ mɔn Enɔk. Enɔk ɛ́ mɔn Yelɛɛd, Yelɛɛd nabɛ ɛ́ mɔn Malaleɛl. Malaleɛl nabɛ ɛ́ mɔn Kenan. ");
INSERT INTO bkw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Tin, Kenan nabɛ ɛ́ mɔn Enɔs, Enɔs nakadi ɛ́ mɔn Sɛt. Sɛt kadi ɛ́ mɔn Adam, Adam ɛ́ mɔn Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dáa Yezu nabula pɛ dii Yuldɛn ɛ, ye nabɛ ɛ́ Sisim na Dɛɛ moo tɔ lɛ na «tɔɔɔ», Sisim zɛdul nyɛ tɔ bal, ");
INSERT INTO bkw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","é di Dim mot mɛkɔŋ nakɛwa nyɛ tɔ mɛbhowal ɔ. Ye nabɛ ɛ́, nyɛ naasa mɛlu mɛkam-mɛná ààdɛ edee. Bhii tak za zokazɛsa nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dim mot mɛkɔŋ eezɛke nɛ nɛ náá: «Nɛghu wɔ ɛ́ Mɔn Zɛɛb ɔɔ, kea nɛ ɛkok ɛlak náá, ye liigel, da yɛ ɛ́ di mapa.» ");
INSERT INTO bkw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yezu eezɛbɔɔza nɛ nɛ náá: «Ekwyala ɛ Zɛɛb lɛɛ náá: “Tsik mot tok nɛ mapa toto.”» ");
INSERT INTO bkw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bhii tak, dim mot mɛkɔŋ eezɛbyet nɛ nɛ kɔ dwol, wɔ gwaa nyɛ lyaal nyɛ tɔ ɛwala ɛwat mɛyoŋ mɛ di kɔ bɔs ɛ, djas. ");
INSERT INTO bkw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satan nɛ nɛ náá: «Gwyáka, mɛ waadjɛ wɔ eghɛŋ nɛ mɛkas mɛ di tɔ mɛyoŋ mak ɛ djas. Etɛɛ náá, ye naazedjɛaa mɛ. Mɛ ɛ́ nɛ ghwyil ɛdjɛ nɛ mot mɛ aakwos ɛdjɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yɛ bɛ náá, wɔ eemyaal ɛkwyit mɛboŋ mɔ si mɛko mam ɔ, mɛ waadjɛ wɔ djas.» ");
INSERT INTO bkw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yezu eezɛbɔɔza nɛ nɛ náá: «Ekwyala lɛɛ ɛ́ náá: “Ye ɛ́ Ghɛŋ, Zɛɛb'ɔ ɛ́ wɔ di egoka nɛ ɛduwal. Wɔ zosa ɛ mɛsa mɛ nyɛy nyɛ ɛmet.”» ");
INSERT INTO bkw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bhii tak, Dim mot mɛkɔŋ eebaazɛtɔ́ nɛ nɛ pɛ Yeluzalɛm, zɛgel nyɛ kɔ ɛko ɛ kok Ndjaa-ebuwa. Nyɛy nɛ Yezu náá: «Yɛ bɛ náá, wɔ ɛ́ Sɛɛŋɛlɛ Mɔn Zɛɛb ɔɔ, tsela, da wɔ ɛ́ kɛduma pɛ si. ");
INSERT INTO bkw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Deenek, etɛɛ náá, ekwyala lɛɛ ɛ náá: “Zɛɛb ɛ́ waalɛɛ nɛ efofop bɛ náá, bɛ baal wɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tin, baabela náá: “Bɛ waabɛp wɔ kɔ mɛmbɔ mɔɔ, é kaab náá, ko'ɔ ɛzɛkɛbema ɛbɛk.”» ");
INSERT INTO bkw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Ekwyala baalɛɛ ɛ́ náá: “Sa wɔ ààwa Ghɛŋ, Zɛɛb'ɔ tɔ mɛbhowal.”» ");
INSERT INTO bkw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bhii nyɛ nazewa Yezu tɔ mɛbhowal dáa nyɛ nakwyɛl ɛ, Dim mot mɛkɔŋ eezɛbet nyɛ, nyɛ tɔ́ ɛtsetaɛpe, kɛkum é dhiiti ɛwala aanyɔ nɛ nɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yezu eezɛsik pɛ Ghalile, ghwyil Sisim na Dɛɛ tɔ lɛ «tɔɔɔ». Duma yɛ zokakɛ kɔ mɛl mɛ nadi mbaka-mbaka nɛ tin ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tin, Yezu moo tin elyo bot mɛkpa ɛ Zɛɛb tɔ mendjaa mɛ mendjaala mɛ eYuda. Bot ɛ nadi egwak nyɛ ɔ, naadyeebaduduwal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Dhiiti dwoo Yezu zɛtɔ́ pɛ Nazalɛt, é di nyɛ nawyelaa ɔ. É dwoo saba, nyɛ eezɛni tɔ ndjaa mendjaala mɛ eYuda dáa nyɛ natawa nɛ ɛsesa ɛ. Nyɛ ɛ́ boowyɛl é mis mɛ bot étɛp ɛlaŋ ɛ ekwyala ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bhii tak náá, bɛ eezɛdjɛ nyɛ mbwoob mɛkana mɛ ngoolel-mɛkpa Ezayi, nyɛ eezɛwyiiz mɛkana mɛ tak. Nyɛ kabela é di nakwyalaa náá: ");
INSERT INTO bkw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Sisim ɛ Ghɛŋ ɛ́ nɛ nam etɛɛ náá, nyɛ naadjɛ mɛ ebotan, étɛp mɛ neezɛtuud bɛdjel ɛ bot mbɛɛ bhaadal. Nyɛ naadhis mɛ, mɛ zɛlɛɛ bot ɛ membok náá, bɛ moo ɛ́ tiia. Mɛ zɛlɛɛ bɛ na edhim náá, bɛ moo zɛnyaa sok. Mɛ zɛlɛɛ bot ɛ́ di nyalaa ɔ, bɛ neepɛka. ");
INSERT INTO bkw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mɛ zɛtuud náá, mena moo ɛ́, é mɛwala mɛ Ghɛŋ di zɛtsik bot bɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bhii tak, Yezu eezɛwol mɛkana, zɛdjɛ nɛ mot nakwokwom mbwoob mɛkana mɛ tak ɔ, nyɛ eezɛnɔɔ nyel, disi. Bot djas nadi tɔ ndjaa mendjaala mɛ eYuda ɔ, moo tin «dhuuu», nɛ mis é nyel'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","É di'enek, nyɛ boozɛlɛɛ bɛ náá: «Mos ekwyala ee bi zegwak ɛ, eedjala.» ");
INSERT INTO bkw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bɔɔ djas nadi etaŋal étɛp'ɛ, bɛ nadi edjoka mbɛɛ etɛp ee nyɛ nadi elɛɛ bɛ ɛ. Bɛ zokazɛdji náá: «Ye tok mɔn Zozɛf'aak é?» ");
INSERT INTO bkw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tin, Yezu eezɛke nɛ nɔɔ náá: «Tsɛɛtsɛ náá, bi ɛ́ waadjɛ kana yak: “Ngwomel bot, tsika nyel'ɔ wɔy wɔ ɛ́ ɛmet.” Bi ɛ́ waabaake nɛ nam náá: “Bis eegwak menduk mɛ mɛsa mɛ wɔ nasa pɛ dɛl ɛ Kapɛlnaum ɛ. Baasa esa e tak wak kɔ ghaada yɔ met!”» ");
INSERT INTO bkw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Bhii tak nyɛ eezɛbaabil náá: «Nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ́ náá, ye tok nɛ dhiiti ngoolel-mɛkpa ɛ Zɛɛb ààmyaalaa kɔ dɛl ɛ lɛ met. ");
INSERT INTO bkw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: É ghɛŋ ɛ ngoolel-mɛkpa ɛ Zɛɛb Eli, ye nabɛ ɛ́ nɛ bɛtɛ nɛ bɛkus ɛ boa tɔ Yisalaɛl, é sok ye nasa membu melɛl nɛ pes, bhi àànee ɛ, é sok boo pwom nasa kɔ dɛl djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Zɛbela náá, Zɛɛb nabɛ ɛ́ ààkyeed Eli pɛ daa kus moma dik'ena. Nyɛ nazokyeed nyɛ ɛ́ pɛ daa dhiiti kus moma, nadidi pɛ dɛl ɛ Salepta ɔ, pɛ kyee dik Sidɔn. ");
INSERT INTO bkw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ye nabaabɛ pe ɛ́, nɛ bot ɛ nadi nɛ ɛbɛ́ ɛ zezam ɔ, ɛbuɛpe tɔ Yisalaɛl é ghɛŋ ɛ ngoolel-mɛkpa ɛ Zɛɛb Eliize. Zɛbela náá, ye nabɛ ààbɛ nɛ mot ngɔt tɔ sama yɔɔ natsak, bhis Naaman, mot kyee dik Siili nyɛ ɛmet.» ");
INSERT INTO bkw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tin, wɔ gwaa ɛbuk zɛmɛt bɔɔ djas tɔ ndjaa mendjaala mɛ eYuda, bhii bɛ nazegwak deenek ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wɔ gwaa bɛ zɛwyɛl, bhii tak bɛ eezɛwyis tɔ́ nɛ Yezu edi sis ààbɛ kɔ dɛl, pɛ kɔ nges boo ɛtsok ɛ Nazalɛt nasumaa kɔ tak ɛ, étɛp bɛ neekɛ zyeegal nyɛ, nyɛ neeges tɔ toŋ. ");
INSERT INTO bkw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tin, Yezu zokazɛsyela tɔ lɔɔ, nɔɔ nyel'ɛ, tɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dhiiti dwoo, Yezu naatɔ́ pɛ Kapɛlnaum, dɛl ɛ Ghalile. Nyɛy é lelyo bot mɛkpa ɛ Zɛɛb, dwoo saba. ");
INSERT INTO bkw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bot naadyeebadjodjoka dáa nyɛ nadi elelyo ɛ, etɛɛ náá, nyɛ nalelyo ɛ́ nɛ eghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tɔ ndjaa mendjaala mɛ eYuda nadi ɛ́ nɛ dhiiti mot nadi nɛ mbee sisim nadi edhedhek ɔ. Mot'enɔk moo zɛtsim ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nyɛy náá: «Haa! Mena ɛ́ nɛ yaa tɛp, Yezu, mot Nazalɛt? Wɔ zyɛ, zɛtwak bis é? Mɛ nɛ gu náá: Wɔy ɛ́ mot na dɛɛ Zɛɛb nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yezu eezɛbhɛm nyɛ ɛlyelɛpe. Nyɛy náá: «Dia gwyem, wyisa tɔ nyel mot'ak!» Mbee sisim zɛghɛɛg mot'enɔk si é mis mɛ bot. Bhii tak, nyɛ eezɛwyis tɔ lɛ, ààzuk nyɛ é dhiiti di. ");
INSERT INTO bkw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bot djas naadjoka ɛlyelɛpe, bɛ moo tin elelii pak'ɔɔ náá: «Yak ɛ́ yaa kɔkɔ lii nɛ nwyak mot? Nyɛ ɛ́ nɛ eghɛŋ nɛ ghwyil ɛbatake nɛ embee esisim náá, bɛ wyis, bɔɔ ɛ́ batawyis.» ");
INSERT INTO bkw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Wɔ gwaa, dék din ɛ lɛ zɛdjala kɔ kyee dik'enek djas. ");
INSERT INTO bkw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yezu eezɛwyis tɔ ndjaa mendjaala mɛ eYuda, tɔ́ pɛ daa Simɔŋ. Ghuna tsi ɛ Simɔŋ yii moma nadi ɛ́ nɛ mɛkosa ɛkpaŋɛpe. Bɛ eezɛke nɛ Yezu náá, nyɛ sa sonok étɛp'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nyɛ eezɛmalal é ngwoob'ɛ, tinaak nyɛ zɛbhɛm mɛkosa, nyɛ wyis. Wɔ gwaa, mɛkosa zɛwyis tɔ lɛ. E di tak wat, moma yenɔk eezɛwyɛl, nyɛ moo ebe bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kasɛka ɛ́, é ɛbil ɛ dwoo ɛ, bot ɛ nadi nɛ membel membi-membi ɔ, naazyɛ nɛ nɔɔ pɛ daa Yezu, nyɛ ɛ́ bookɛl mɛmbɔ kɔ lɔɔ. Bhii tak náá, bɛ eezɛtsak. ");
INSERT INTO bkw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Embee esisim nadi ewyis tɔ bɛtɛ nɛ membel, bɔɔ é tsitsim náá: «Wɔ ɛ́ Mɔn ɛ Zɛɛb!» Yezu ɛ́ boozɛlyak bɛ náá, bɛ diyal enuub etɛɛ náá, bɛ nadi egu náá, nyɛy ɛ́ di Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Dáa mɛlem nalem ɛ, Yezu eezɛdus tɔ ghaada tɔ́ pɛ kyee di ààbɛ nɛ bot ɛ. Tin, zukamwaa nɛ mot moo zɛsaa nyɛ, wɔ gwaa, bɛ zokazɛbela nyɛ. Ɛkwosak ɛ lɔɔ nabɛ ɛ́, bɛ nɛ bɛ nɔɔ di é di wat, nyɛ nàkabaalik bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nyɛ eezɛke nɛ nɔɔ náá: «Ye goka ɛ́ náá, mɛ tɔ́, kɛgoola mbɛɛ bhaadal dum nɛ Ɛyoŋ ɛ Zɛɛb pɛ bɛdhiiti eghaada esis, etɛɛ náá, mɛ nadhisaa ɛ́, étɛp tak.» ");
INSERT INTO bkw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tin, nyɛ nadi egoola mɛkpa ɛ Zɛɛb tɔ mendjaa mɛ mendjaala mɛ eYuda kyee dik Yude. ");
INSERT INTO bkw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dhiiti dwoo Yezu nadi ɛ́, é ngwoob boo soob na djato-djato Ghɛnɛɛzalɛt. Tin, bot ɛbuɛpe eezɛsaala nyɛ é nyel pɛ kyee nyɛ nadi ɛ́, étɛp bɛ neezɛgwak mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nyɛ eezɛbee é ɛboŋ ɛ dii, mɛlɛɛd mɛmbá ye zesɛɛ, bɛlael ɛ mɛwyet naasɛɛ étɛp ɛgwyii mɛwyet mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nyɛ eezɛni tɔ elɛɛd wat. Yiizaag nabɛ ɛ́ yɛ ɛ́ Simɔŋ. Nyɛ ɛ́ booke nɛ nɔɔ náá, bɛ waatiila batsa nɛ ɛboŋ. Bhii tak nyɛ eezɛnɔɔ nyel, disi. Tin, nyɛ moo zɛlyo bot mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Dáa Yezu nasilal ɛlii ɛ, nyɛ ɛ́ booke nɛ Simɔŋ náá: «Tiila kuku dii, bhii tak, da bi ɛ́ la mɛwyet men.» ");
INSERT INTO bkw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simɔŋ ɛ́ boozɛbɔɔza nɛ nɛ náá: «Ghɛŋ, bis eegɔɔl tu pum'ak djas mos, ààbela sonok. Tin, dum nɛ mɛkpa mɔ, mɛ ɛpela mɛwyet.» ");
INSERT INTO bkw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dáa bɛ kala mɛwyet ɛ, wɔ gwaa bɛ zɛmɛt bɛsu ɛbuɛpe, mɛwyet mɔɔ moo saa ye neekɛk. ");
INSERT INTO bkw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bɛ ɛ́ boozɛdjóo bɛsɔ bɔɔ nadi tɔ dhiiti elɛɛd ɔ, bɛ zɛkwyee bɛ. Bɛ ɛ́ boozyɛ. Bɔɔ bela bɛsu, bhii tak, wɔ gwaa bɛ zokazɛlwoodal mɛlɛɛd mɛmbá mɔɔ, mɛlɛɛd ɛkɛɛ saa diida. ");
INSERT INTO bkw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dáa Simɔŋ Pyɛɛd nabee deenek ɛ, wɔ gwaa nyɛ zɛkwyit mɛboŋ si mɛko ɛ Yezu. Nyɛy nɛ nɛ náá: «Ghɛŋ, tɔ́a yɔ ɛtsetaɛpe nɛ nam, etɛɛ náá, mɛ ɛ́ mot mesyem.» ");
INSERT INTO bkw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Etɛɛ náá, ɛkɛɛd naadyeebasa nyɛ nɛ bot ɛ nadi tin bɛ nɛ bɛ nɔɔ ɔ sama, dum nɛ yenek mbi bɛtɛ nɛ bɛsu ɛ bɛ nagó ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ɛkɛɛd ɛ tak baazɛmɛt dɔɔ nɛ Zak nɛ Zaŋ bɔɔ Zɛbɛdɛ bot ɛ bɛ nɛ bɛ nɔɔ nadi ɔ. É di'enek Yezu ɛ́ booke nɛ Simɔŋ náá: «Nàbem ba, etɛɛ náá, kana dwoo pan mos'ak, wɔy aakadi ɛ́ lael mɛwyet étɛp ɛmet bot.» ");
INSERT INTO bkw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bhii bɛ nasel mɛlɛɛd é ɛboŋ ɛ, bɛ eezɛdhuugal esesɛɛ bɔɔ djas, bɛ eezɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yezu nadi ɛ́, kɔ dhiiti dɛl, wɔ gwaa dhiiti mot nadi nɛ ɛbɛ́ ɛ zezam ɔ, zɛtiila pɛ daa lɛ, kwyit mɛboŋ, bhwoob si, zɛdjaala nɛ nɛ náá: «Ghɛŋ, lyem'ɔ ɛ́ kwyɛl ɔɔ, wɔ ɛ́ nɛ ghwyil ɛtsik mɛ, da nyel'am ɛ́ bula dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yezu eezɛsɛɛb mbɔ, mɛt nyɛ. Nyɛ eezɛke nɛ nɛ náá: «Mɛ eekwyɛl! Tsaka.» É di tak wat, zezam zokasi é nyel mot'enɔk. ");
INSERT INTO bkw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tin, nyɛ ɛ́ boozɛdul nyɛ mɛlɔ ɛlyelɛpe náá: «Sa wɔ ààlɛɛ mot sa dhaa wak ɛ. Tɔ́a kɛlyaal nyel pɛ daa ghaa-Zɛɛb, da wɔ ɛ́ kɛdjɛ ebuwa e bɛtit dáa Moiiz nake ɛ́. Etɛp náá, bɛ neetaŋal é di yen dum nɛ tsik wɔ zetsak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tin, dék'ɛ, nabaazɛkala dhaa tyɛ kɔ mɛl djas, bot ɛbuɛpe nadi ezyɛ, zɛgwak mɛlyo mɛ Zɛɛb nɛ zɛsaa tsik pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yezu nabɛ ɛ́ é ɛtetɔ́ tɔ bal é edi di ààbɛ nɛ bot ɔ, étɛp nyɛ neekɛdjaala. ");
INSERT INTO bkw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dhiiti dwoo Yezu nadi elyo bot mɛkpa ɛ Zɛɛb, eFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi nadus mɛl nɛ mɛl pɛ kyee dik Ghalile, nɛ Yude, zɛnɔɔ ghaada Yeluzalɛm ɔ nadi ɛ́ tin mendiindil é gwoob Yezu. Tin, ghwyil ɛ Ghɛŋ Zɛɛb nadi ɛ́ tɔ Yezu étɛp nyɛ neetsik bot ɛ mɛbɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wɔ gwaa, bɛdhiiti bot zokazyɛ nɛ mot zesɔɔb nɛ ɛbɛ́ ɔ, byaala kɔ mwaala. Bɛ nadi esaa dáa bɛ aaniigal nyɛ tɔ ndjaa étɛp ɛkɛnɛɛg nyɛ si mɛko ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dáa bɛ nadi ààbɛ nɛ dáa bɛ sa ɛ, wɔ gwaa, bot binɔk zokazɛbyet kɔ mii ndjaa, tuu ɛlen tɔ ɛbo, bɛ eezɛsil mbel'enɔk kɔ mwaala yɛ, kuku ɛbwak, zeza nɛ di Yezu nadi ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dáa Yezu nabee ɛdum ɛ koŋ ɛ bot ɛ nazyɛ nɛ mbel tak ɔ, nyɛ ɛ́ boozɛke nɛ mbel náá: «Mɔɔ sɔ'am, mesyem mɔ eepelel.» ");
INSERT INTO bkw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ moo tin nɛ bɛtɛ nɛ esiiza tɔ elyem. Bɔɔ náá: «Yenɔk ɛzɛ di ebyasal Zɛɛb deenek? Nwyak mot di nɛ ghwyil ɛpel mesyem mɛ sɔ mot, bhis Zɛɛb nyɛ ɛmet?» ");
INSERT INTO bkw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dáa Yezu naagu esiiza bɔɔ ɛ, nyɛ ɛ́ booke náá: «Étɛp ye bi di nɛ mbi yenek egeka? ");
INSERT INTO bkw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ɛyé di ààdyeebalyel nɛ nen, ɛke ɛ́ náá: “Mesyem mɔ eepelel” ooho, nɛghu ɛke ɛ́ náá: “Wyɛla, da wɔ ɛ́ kɛ”? ");
INSERT INTO bkw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ye goka ɛ́, bi gu náá: Sɛɛŋɛlɛ Mɔn Mot ɛ́ nɛ ghwyil ɛpel mesyem mɛ bot kɔ bɔs.» Bhii tak, nyɛ eezɛke nɛ sɔɔbela mot'enɔk náá: «Mɛ ke ɛ́ náá, wyɛla, nɔŋa mwaala yɔ, da wɔ ɛ́ sik pɛ ndjaŋ'ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","É di'enek wat, bot djas «dhuuu», nɛ mis é nyel mbel, wɔ gwaa, nyɛ zɛwyɛl, ghɛɛ mwaala nyɛ nagheghɛɛaa nɛ yɛ ɛ, zɛnɔɔ nyel, tɔ́ pɛ ndjaŋ'ɛ, nyɛy é duwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bot djas naadyeebadjoka, bhii tak bɛ moo duwal Zɛɛb é ɛkeke náá: «Bis dinaa ààpaabee kɔkɔ yak sok!» ");
INSERT INTO bkw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bhii tak Yezu zokazɛwyis, wɔ gwaa, nyɛ bee dhiiti nɔŋel epata e lapo, din ɛ lɛ nabɛ ɛ́ Levi, ndiindil é di mɛsa mɛ. Yezu eezɛke nɛ nɛ ɛ náá: «Dua mɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ngbat, Levi eezɛwyɛl, nyɛ eezɛlik esesɛɛ bɛ djas, du nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Bhii tak, Levi eezɛsa ɛbyoŋ tɔ ndjaŋ'ɛ. Bɛtɛ nɛ bɛnɔŋel ɛ epata e lapo, nɛ bɛdhiiti bot ɛbuɛpe nadi ɛ́, lɔɔg wat bɛ nɛ bɛ nɔɔ kɔ mesa. ");
INSERT INTO bkw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","EFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi nadi bɛ nɛ bɛ nɔɔ ɛ nadi elii ɛbiyoɛpe nɛ sa tak ɛlyelɛpe. Bɛ ɛ́ boozɛke nɛ bɛdjekel bɛ náá: «Étɛp ye bi di edɛ é di wat bi nɛ bɛnɔŋel ɛ epata e lapo nɛ bot ɛ di nɛ mbee dék ɔ?» ");
INSERT INTO bkw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Bot ɛ di mɛnyel ɛnyɔɛpe ɔ, tok nɛ gwyes ngwomel mot étɛp nyɛ neegwom bɛ. Ye ɛ́ membel ɛ di nɛ gwyes mɛgwoma mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɛ nabɛ ɛ́ ààzyɛ, zɛsaa bot ɛ epiki. Mɛ nazyɛ ɛ́, zɛsaa bot ɛ di gu náá, bɛ ɛ́ bot ɛ mesyem ɔ, étɛp bɛ neeswoola mɛfulu mɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","EFalizyɛ zokazɛdji Yezu náá: «Bɛdjekel ɛ Zaŋ Nduuel-bot nɛ bɛdjekel bis nɛ tsi edee étɛp mendjaala esok nɛ esok. Étɛp yé bɔ bɛdjekel di ààtsi edee étɛp mendjaala?» ");
INSERT INTO bkw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wɔ gwaa, Yezu zokabɔɔza nɛ nɔɔ náá: «Bi nakobee sok paa náá, bɛsɔ ɛ mwaaz tsi edee dwoo ɛba, dhi bɛ di lɔɔg wat nɛ mwaaz, mot paazyɛ zɛba moma ɔ? Mɛ ààbee deenek. ");
INSERT INTO bkw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tin, ɛwala ɛ tak ɛ́ waakum, sɔ'ɔɔ mot zyɛ zɛsa ɛba ɔ, nyɛ waadisaa tɔ lɔɔ. É di tak ɛ́ bɛ aatsi edee.» ");
INSERT INTO bkw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yezu eebaazɛbɔɔza bɛ tɔ kana náá: «Ye tok nɛ mot aanyaa kaad na bes étɛp ɛkoobal bet kaad nɛ yɛ. Yɛ sael deenek ɔɔ, pes bes kaad ɛ́ waanyaa bet kaad, tin, pes bes kaad tok nɛ ghwyil ɛlataa é bet kaad. ");
INSERT INTO bkw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ye tok nɛ mot aawa bes mɛnyok tɔ ebhɛɛb na mwa etɛɛ náá, yɛ wyil ɔ, mɛnyok ɛ́ nɛ ghwyil ɛbo ebhɛɛb. Mɛnyok waasee é bɔs tin, bhɛɛb waapulel. ");
INSERT INTO bkw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ɛnyɔ náá, mɛnyok mɛ bes waaa tɔ ebhɛɛb na bes! ");
INSERT INTO bkw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ye tok nɛ mot aakwyɛl ɛdɛ mɛnyok mɛ bes, bhis nyɛ eezedɛ mɛnyok mɛ na mwa ɔ. Ye dyeebakeaa ɛ náá: “Mɛnyok mɛ na mwa nɛ nyɔ.”» ");
INSERT INTO bkw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Dhiiti dwoo saba Yezu nadi edhaa tɔ pyeeb mɛbhek mɛ di edjóoaa ble ɛ. Bɛdjekel bɛ nadi ebɔ́k mɛbhek nɛ ɛdjas yɛ tɔ mɛmbɔ mɔɔ, bhii tak, bɛ eezɛdɛ bhum tak. ");
INSERT INTO bkw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bɛdhiiti eFalizyɛ ɛ́ boozɛke nɛ Yezu náá: «Étɛp yé bi di esa sa etsi di elyak dwoo saba ɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi dinaa ààpaalaa dáa Dhavid nasa é sok za nasa bɛ nɛ bot bɛ ɛ? ");
INSERT INTO bkw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bɛ naani tɔ Ndjaa Zɛɛb, nyɛy zokanɔɔ emapa ee nakaŋaa Zɛɛb ɛ, dɛ, nɔɔ yak pak, djɛ bot ɛ nadi egyee bɛ nɛ nɛ ɔ. Dhi bɔɔ eezogu ɛnyɔɛpe náá, etsi lɛɛ náá, bot di egoka nɛ ɛdɛ emapa binek ɛ́, yɛ ɛ́ bɔɔ bɛmet bɛghaa-Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yezu zokabaazɛke nɛ nɔɔ náá: «Sɛɛŋɛlɛ Mɔn Mot ɛ́ di kukuma dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dhiiti dwoo saba, Yezu eezɛni tɔ ndjaa mendjaala mɛ eYuda, nyɛ moo tin elyo bot mɛkpa ɛ Zɛɛb. Tɔ tak nadi ɛ́ nɛ dhiiti mot ngɔt nɛ mbɔ eghɛŋ sɔɔbela. ");
INSERT INTO bkw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","EFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi moo tinaak «dhuuu» nɛ mis é nyel ɛ Yezu é gwyák nɛghu nyɛ waatsik nyɛ dwoo saba, étɛp ɛbela lo mɛsɔ mɛ bɛ aapit nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tin, Yezu nadi egu egeka e ebhum e elyem bɔɔ. Nyɛ eezɛke nɛ mot na sɔɔbela mbɔ náá: «Wyɛla! Tyaŋa tetel tin kuku ɛbwak.» Wɔ gwaa, mot'enɔk eezɛwyɛl, nyɛ eezɛtyaa tetel. ");
INSERT INTO bkw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nyɛ eezɛdji ɛdhuu ɛ bot ɛ́ nadi tin ɔ náá: «Tɔ etsi, ɛyé di egoka nɛ ɛsael dwoo saba, enɛm esa “ohoo” embee esesɛɛ? Ɛtsik ɛ mot “ohoo”, nɛghu ɛbet náá, nyɛ gwyɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yezu eebulal mis gwyák bɛ, bhii tak nyɛ eezɛke nɛ mot tak náá: «Sɛɛba mbɔ'ɔ.» Nyɛ eezɛsɛɛb mbɔ'ɛ, yɛ eezɛsekel, bula ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wɔ gwaa bɛghaŋ ɛ mɛkana mɛ etsi nɛ eFalizyɛ zokazɛkpaa lyem ɛlyelɛpe, bɛ moo tinaak esɔs pak'ɔɔ, edjek tyee bɛ aasa kɔ ɛsu ɛ Yezu ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","É ghɛŋ tak, Yezu naazɛbyet kɔ ɛtsok étɛp ɛkɛdjaala Zɛɛb. Nyɛ naadjaala Zɛɛb tu pum tak djas. ");
INSERT INTO bkw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Dáa mɛlem nakalem ɛ, nyɛ eezɛdjóo bɛdjekel bɛ. Bhii tak, nyɛ eezɛsɛ́ɛ tɔ sama yɔɔ bot kam nɛ bɛbá, nyɛ nadjóo bɛ «bot ɛ lwoma». ");
INSERT INTO bkw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Min mɔɔ nabɛ ɛ́: Simɔŋ Yezu naget Pyɛɛd ɔ, zɛnɔɔ mɔn nyɛɛg Andele, Zak nɛ Zaŋ, Filip, Bhaatelemi, ");
INSERT INTO bkw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matye, Toma, Zak mɔɔ Alfe, zɛnɔɔ Simɔŋ, mot di tɔ ɛdhuu ɛ bot ɛ nadi djóoaa eZɛlɔt ɔ, ");
INSERT INTO bkw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","zɛnɔɔ, Yuda mɔɔ Zak, bɛ nɛ Yudas Iskaliɔt, mot aaka nyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yezu eezɛwyeed ɛtsok bɛ nɛ bɛ nɔɔ. Nyɛ eezɛtyaa é di na sɛbɛtɛɛ, é di bɛdhiiti bɛdjekel ɛbuɛpe nadi ɔ. É di tak, ye nabaabɛ ɛ́ nɛ zukamwaa nɛ mot. Bot ɛ tak naadudus ɛ́ pɛ kyee dik Yude nɛ Yeluzalɛm, kɔ eghaada di é ngwoob boo dii mɛsɔn ɛ, pɛ Tiid nɛ Sidɔn. ");
INSERT INTO bkw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɛ nazyɛzɛgwak embɛɛ mɛlyo mɛ Zɛɛb, dɔɔ nɛ zɛsaa tsik. Bot ɛ embee esisim nadi edhedhek ɔ, nabɛ ɛ́, bɛ naabela yɔbɔ tsik. ");
INSERT INTO bkw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bot nadi esuu ɛ́, bɛ mɛt nyɛ bɔɔ bɛ ɛmet, etɛɛ náá, dhiiti kwaambi mɛbwala nadi ewyis tɔ lɛ, é tse-tsik bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yezu eezɛgwyák bɛdjekel bɛ, nyɛy nɛ nɔɔ náá: «Mɛnyɔ nɛ biyɔ, bɛdjel ɛ bot etɛɛ náá, Ɛyoŋ ɛ Zɛɛb ɛ́ yibɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mɛnyɔ nɛ biyɔ, bot ɛ di nɛ za nenak ɔ, etɛɛ náá, bi ɛ́ waadɛ, djil. Mɛnyɔ nɛ biyɔ, bot ɛ di edje nenak ɔ, etɛɛ náá, bi ɛ waagɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Mɛnyɔ nɛ biyɔ, bot ɛ di ebhina bin ɔ, bɛ sɔ bin ɔ, bɛ lee bin, nɛ ɛsaab ɛ dék ɛ len, kɔ ɛsu ɛ Sɛɛŋɛlɛ Mɔn Mot ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","É dwoo tak, myaalka, da bi ɛ́ bɔl zɛŋ, etɛɛ náá, boo etuud bin ɛ́ nɛɛga pɛ tɔ gwoo. Bɛbhaab bɔɔ nasesa ɛ́ deenek nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Haa kpaa-ghoŋ nɛ biyɔ, bɛkuma ɛ bot etɛɛ náá, bi nazebela yebɔ enɛm nɛ embɛɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kpaa-ghoŋ nɛ biyɔ, bot ɛ zedɛ, djil nenak ɔ, etɛɛ náá, bi aadi ɛ́ nɛ za. Haa kpaa-ghoŋ nɛ biyɔ, bot ɛ di egɔ nenak ɔ, etɛɛ náá, bi aadi ɛ́ dje.» ");
INSERT INTO bkw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","«Haa kpaa-ghoŋ nɛ biyɔ, yɛ bɛ náá, bot djas ɛpeduwal bin ɔ. Ye ɛ́ deenek ɛ, bɛbhaab bɔɔ nadi eduwal bɛngoolel ɛ mɛkpa ɛ Zɛɛb yii mɛkɔŋ.» ");
INSERT INTO bkw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yɛ bɛ biyɔ, bot ɛ di egwak mɛ ɔ, mɛ lɛɛ bin ɛ náá: Kwyɛlka bot ɛ mɛbhuka men. Saka enɛm esa nɛ bot ɛ́ di ebhina bin ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sɛɛka bot ɛ di ekal bin ɔ, mɛtel. Da bi ɛ́ baadjaala Zɛɛb étɛp bot ɛ́ di esa bin ɛbiyo ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Yɛ bɛ, mot ɛ́ nyuu wɔ bɛɛz é ɛmuk ɔɔ, baadjɛ yak kyee ɛmuk. Mot ɛ́ nɔɔ wɔ ndjookuwa ɔɔ, beta nyɛ baanɔɔ kuwa yɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gwyena nɛ mot nɛ mot di ewaab wɔ sonok ɔ. Yɛ bɛ mot eenɔɔ seeyɔ ɔɔ, sa wɔ ààkabaadu. ");
INSERT INTO bkw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Saka nɛ bot tyee bi di ekwyɛl náá, bɛ sa nɛ nen ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yɛ bɛ náá, biyɔ zokwyɛl ɛ́ bot ɛ di ekwyɛl bin ɔɔ, étɛp yé bi di ebun náá, bi djɛaa bhɔɔ? Dɔɔ nɛ bot ɛ mesyem zobaakwyɛl ɛ́, bot ɛ di ekwyɛl bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yɛ bɛ náá, biyɔ zosa enɛm esa ɛ, nɛ bot ɛ di esa bin enɛm esa ɔɔ, étɛp yé bi di ebun náá, bi djɛaa bhɔɔ? Dɔɔ nɛ bot ɛ mesyem baasaa deenek. ");
INSERT INTO bkw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yɛ bɛ náá, bi ekola bot esonok ɛ é bwaal náá, bɛ neebaadjɛ bin yɔbɔ ɔɔ, étɛp yé bi di ebun náá, bi djɛaa bhɔɔ? Dɔɔ nɛ bot ɛ mesyem baadjɛel pak'ɔɔ ɛ fulu ɛkola, etɛɛ náá, bɛ neebulela yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yɛ bɛ biyɔ ɔ, ye goka ɛ́, bi kwyɛl bot ɛ mɛbhuka men. Saka bɛ enɛm esa. Gwyenaka nɛ bot esa bin, ààbwaal náá, bɛ waabaabulal bin yɛ. Deenek Zɛɛb ɛ́ waadjɛ bin boo etuud. Bhii tak, bi ɛ́ waadjóoaa bɔn Zɛɛb-Mɛkaake, etɛɛ náá, nyɛ ɛ́ Zɛɛb mɛnyɔ nɛ bot ɛ lwalɛŋ, zɛɛg nɛ bɛmbee ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gekeka bot ghoŋ, dáa Sɛɛg'en di egek bin ghoŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Sa bi ààdidi é pɛ́ɛ bot, deenek Zɛɛb aanàkwaapɛ́ɛ bin. Sa bi ààdidi é kwyesal bot ndjɛ sɔs, deenek Zɛɛb aanàkwaakwyesal bin ndjɛ sɔs. Pelka bot ɛbiyo ɛ bɛ di esa bin ɛ, deenek Zɛɛb ɛ́ waapel bin. ");
INSERT INTO bkw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gwyenaka nɛ bot. Deenek Zɛɛb ɛ́ waadjɛ bin ɛbuɛpe, lwoodal. Zɛɛb ɛ́ waaso tɔ boo bhwaŋ'en bɛtɛ nɛ bhum, nyɔmelaa, dital-dital, “tɔɔɔ” see. Hɛɛɛ! Zɛɛb bee ɛ́ dáa bi di elwoodal bhwaa bɛsɔ bin ɛ. Ye ɛ́ deenek ɛ nyɛ aalwoodal yebɔ bhwaa.» ");
INSERT INTO bkw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tin, Yezu eebaazɛlii nɛ nɔɔ pɛ tɔ kana náá: «Mot edhim tok nɛ ghwyil ɛdul sɔ mot edhim étɛp ɛlyaal ɛ́ nyɛ ze, deenek tɛ? Bɛ ɛ́ sa deenek ɔɔ, bɔɔ djas bɛbá ɛ́ waakɛdjoola tɔ guk. ");
INSERT INTO bkw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ye tok nɛ djekel di nɛ ghwyil ɛdhaa sɛɛg mot di elyaal nyɛ mɛsa ɔ. Tin, yɛ bɛ náá, djekel di edjek mɛsa ɔɔ, nyɛ eezedjek ɛnyɔɛpe ɔ, nyɛ aakaswaala ɛ́, nyɛ moo dáa sɛɛg mɛsa mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Étɛp yé wɔ gwyák kwyɛɛzyoŋ di tɔ dis ɛ sɔ mot, wɔ kadi ɛ́, ààbee pɛk le di tɔ dis ɛ lɔ ɛ? ");
INSERT INTO bkw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wɔ naakwaake nɛ sɔ mot náá: “Mɔɔ sɔ'am, beta, mɛ dis mɔɔ kwyɛɛzyoŋ tɔ dis ɛ lɔ,” dhi wɔy di ààbee pɛk le di tɔ yɔ dis ɛ! Wɔy mot mɛdjhaaz pɛ ɛko, bhimis pɛ si, pookodis sok pɛk le tɔ dis ɛ lɔ! Bhii tak ɛ́ wɔ aanyaa sok, étɛp wɔ needis kwyɛɛzyoŋ di tɔ dis ɛ mɔɔ sɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Mbɛɛ le ààbya mbee bhum. Tyee wat nɛ mbee le, yɛ aanàkwaabya mbɛɛ bhum. ");
INSERT INTO bkw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Le djas gwyakaa ɛ́, nɛ ebhum nyɛ di edjɛ ɛ. Bhum efiigh ààbɔ́kaa kɔ le mɛgɔk. Baadi náá, bhum di saaa mɛnyok mɛ vin nɛ ye ɛ́, yɛ ààbɔ́kaa tɔ engwyinini. ");
INSERT INTO bkw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mbɛɛ mot dyeebawyisal ɛ́ embɛɛ etɛp di edus tɔ di ɛkwom ɛ di tɔ lyemɛ ɛ, kadi ɛ́ náá, mbee mot dyeebawyisal ɛ́ embee etɛp mɛbiyo mɛ di tɔ mbee lyemɛ ɛ. Etɛɛ náá, mɛkpa mɛ mot dyeebawyisal tɔ nuubɛ ɛ, ye ɛ́ mɛkpa mɛ zelwood tɔ lyemɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Étɛp yé bi di edjóo mɛ “Ghɛŋ, Ghɛŋ”, da bi kadi ɛ́, ààsa dáa mɛ ke ɛ? ");
INSERT INTO bkw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mɛ paalyaal bin mbi mot zyɛ pɛ daa lam é gwak mɛkpa mam, da nyɛ ɛ́ kɛ tyee tak ɔ, di egoka nɛ ɛdi ɛ: ");
INSERT INTO bkw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nyɛ ɛ́ dáa mot nadi eesum ndjaa, nyɛ ɛ́ zɛben epap e tak, zɛpu bɔs ɛdimɛpe, tuula kɔ bat ɛkok ɔ. Nyɛ nakawyɛl epap ɛ́ kɔ tak, tyee bhyoŋ nakatuula ɛ, ɛbhyeeb ɛ mɛdii mɛ tak naanyuŋa é ndjaŋ'enek, ààbik, etɛɛ náá, ndjaa naasumel ɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Deenek, mot maa-ɛlɔ di gwak mɛkpa mam, nyɛ kadi ɛ́, ààkɛ tyee tak ɔ, nyɛ ɛ́ dáa mot nasum ndjaŋ'ɛ kɔ bɔs, ààpu ɛdimɛpe, ààbɛ ghus epap. Tyee bhyoŋ nakatuula ɛ, ndjaŋ'enek eezɛbik é di tak wat ɛ́ “syɛɛɛ”.» ");
INSERT INTO bkw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bhii Yezu nasilal ɛlii nɛ mɛdhuu mɛ bot ɛ nazemaala tin ɔ, nyɛ eezɛtɔ́ pɛ Kapɛlnaum. ");
INSERT INTO bkw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tin, dhiiti boo kukuma tɔ lɔɔg esodja eLɔm nadi ɛ́, nɛ dhiiti mot-mɛsa mɛ ngɔt nyɛ nadi ekwyɛl ɛbuɛpe ɔ. Mot-mɛsa mɛ tak nadi ebɛ́ ɛkpaŋɛpe, é siila nɛ ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Dáa boo kukuma esodja tak nagwak menduk ɛ Yezu ɛ, nyɛ ɛ́ boolwom bɛdhiiti bɛpaa ɛ eYuda, bɛ zɛdjóo Yezu étɛp nyɛ neezɛtsik nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bɛ eezɛkum pɛ dáa Yezu. Bɛ moo tin edjaala nɛ nɛ ɛlyelɛpe. Bɔɔ náá: «Mot tak goka ɛ́ náá, wɔ kwyee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nyɛ nɛ kwyɛl bot ɛ mbyak'enaka. Yɛ nyɛy ɛ́ nasum ndjaa mendjaala mɛ eYuda yenaka.» ");
INSERT INTO bkw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tin, Yezu eezɛghɛɛ nyel, tɔ́ bɛ nɛ bɛ nɔɔ. Bɛ dinaa ààpaakotseta nɛ ndjaa deenek e, kukuma esodja eezɛlwom bɛsɔ bɛ, bɛ lɛɛ nyɛ náá: «Ghɛŋ, nàdhek nyel'ɔ gwyes. Mam tok mbɛɛ mot étɛp wɔ neeni tɔ ndjaŋ'am. ");
INSERT INTO bkw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Étɛp tak ɛ́ mam nakuma nyel, di ààzyɛ zɛlii nɛ nɔ. Deenek, “iyeee!” Lóoa ɛkpa wat etɛɛ náá, mot-mɛsa mam neetsak. ");
INSERT INTO bkw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Di mɛ di'aak, mɛ ɛ́ nɛ ekukuma bam mɛ di gwak esesɛɛ mɛ aasa ɛ́ nɛ nɔ ɔ. Pɛ si mɛko mam, mɛ ɛ́ nɛ esodja. Mɛ ke nɛ ngɔt náá: “Tɔ́ak” ɔɔ, nyɛ ɛpetɔ́. Mɛ ke nɛ nwyak náá: “Bulak” ɔɔ, nyɛ ɛpebula. Tin, mɛ ke nɛ mot-mɛsa mam: “Sa dáak” ɔɔ, nyɛ ɛpesa.» ");
INSERT INTO bkw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dáa Yezu nagwak ɛbɔɔza kukuma yenɔk ɛ, ye nabɛ ɛ́, nyɛ naadyeebakwyɛl nyɛ. Nyɛ ɛ́ boo liig mis, nyɛy nɛ ɛdhuu ɛ bot ɛ nadi egyee nɛ nɛ nɔɔ náá: «Mɛ lɛɛ náá, mɛ dinaa ààpaabee kwaambi yak ɛbwaalel nɛ Zɛɛb sok, ye nakoozobɛ kɔ dɛl ɛ Yisalaɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bot ɛ nalwomaa ɔ, eezɛsik yɔbɔ pɛ dáa kukuma esodja, bɛ kakɛbela mot-mɛsa nadi bɛ́ ɔ, nyɛ eezetsak. ");
INSERT INTO bkw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bhii tak, Yezu eezɛtɔ́ pɛ dɛl ɛ di djóoa Nayin ɛ, bɛdjekel bɛ nɛ mɛdhuu mɛ bot ɛ nadi egyee nɛ nɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dáa nyɛ nadi, nyɛ moo é ngwoob ɛniel ɛ dɛl ɛ tak ɛ, bot ɛ dɛl nadi ezyɛ nɛ muu mot pɛ mɛvit étɛp ɛkɛdel nyɛ. Ye nabɛ ɛ́ ɛtsak ɛ mɔn dhiiti kus moma. Bot ɛ dɛl ɛ tak ɛbuɛpe nadi ɛ́, é ngwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Dáa Ghɛŋ nabee kus moma yenɔk ɛ, ghoŋ naasa nyɛ ɛbuɛpe étɛp'ɛ. Nyɛ ɛ́ booke náá: «Nàdje!» ");
INSERT INTO bkw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nyɛ eezɛtiila, wɔ gwaa nyɛ mɛt kɛs, bot ɛ nadi ebɛp kɛs ɔ, eezɛtyaa. Yezu zɛke náá: «Mɔɔ ngbaaz, mɛ lɛɛ náá: Wyɛla!» ");
INSERT INTO bkw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mot nagwyɛ ɔ eezɛgom, di ndiindil, nyɛ moo tinaak elii. Yezu eezɛbulal nyɛ é mɛmbɔ mɛ nyɛɛg. ");
INSERT INTO bkw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bot ɛ nadi tin ɔ, naadjoka ɛbuɛpe. Bɛ ɛ́ boozɛduwal Zɛɛb é ke náá: «Boo ngoolel-mɛkpa ɛ Zɛɛb eetuula pak'enaka. Deenek, Zɛɛb eezɛkwyee bot ɛ mbyak'ɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Bot ɛ kyee dik Yude nɛ mɛl mɛ mengwoob nɛ mengwoob nabɛ ɛ́, bɛ naagwak menduk mɛ sa Yezu nasa ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bɛdjekel ɛ Zaŋ eezɛkaada Zaŋ etɛp binek djas. Zaŋ eezɛdjóo bɛdjekel ɛbá pak'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nyɛ eezɛlwom bɛ pɛ dáa Yezu, étɛp ɛdji Ghɛŋ náá: «Ye ɛ́ wɔy ɛ di Mɛsia nabɛ náá, nyɛ ɛpezyɛ ɔ, “ohoo” nɛghu ye baabwoodaa dhiiti baadi ezyɛ ɔ?» ");
INSERT INTO bkw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dáa bɛ nakum pɛ Yezu nadi ɛ, bɛ eezɛke nɛ nɛ náá: «Zaŋ Nduuel-bot lwom bis ɛ́, bis zɛdji wɔ náá: “Ye ɛ́ wɔy ɛ di Mɛsia nabɛ náá, nyɛ ɛpezyɛ é, ‘ohoo’ nɛghu ye baabwoodaa dhiiti baadi ezyɛ ɔ?”» ");
INSERT INTO bkw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","É ɛwala ɛ tak wat, Yezu zokazɛtsik bɛtɛ nɛ membel, bot ɛ nadi nɛ edjam ɔ, nɛ bot ɛ embee esisim nadi edhedhek ɔ, dɔɔ nɛ ɛbɛ́ ɛ mis mɛ bot ɛ edhim. ");
INSERT INTO bkw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bhii tak Yezu eezɛbɔɔza nɛ engoola-ngoola ɛ Zaŋ náá: «Kɛbaaŋaka nɛ Zaŋ esesɛɛ bi bee ɛ, nɛ yii bi gwak ɛ. Bot ɛ edhim moo nyaasok, bot ɛ di nɛ edjam ɔ moo kɛ ɛnyɔɛpe, bot ɛ nadi nɛ ɛbɛ́ ɛ zezam ɔ, bɛ eezetsak. Bɛ na endiila e mɛlɔ, moo gwak. Bot ɛ zegwyɛ ɔ, bɛ eezegom. Mbɛɛ Bhaadal ɛpegoolel, kɛkum pɛ daa bɛdjel ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mɛnyɔ nɛ mot aadi ààdis ɛbwaalel ɛ lɛ kɔ lam ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhis engoola-ngoola ɛ Zaŋ nasik ɛ, Yezu moo tin elii nɛ zukamwaa nɛ mot nadi tin ɔ kɔ ɛsu ɛ Zaŋ. Nyɛ nalɛɛ nɛ nɔɔ náá: «Bi nakɛbee yé pɛ tɔ bal? Mɔɔ le ghwaazok é dheegel nɛ pup é? Ààbɛ! ");
INSERT INTO bkw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Haa ɛyé bi naakɛbee tɔ bal? Mot ngɔt nɛ vaŋ mbi bhet é? Bi nɛ gu náá, bot ɛ dyeebabɔt evaŋ e ekaad ɔ, nɛ bot ɛ di edi tɔ ekum ɔ, dyeebadi ɛ́ tɔ eboo mendjaa mɛ bɛmɛkoozi. ");
INSERT INTO bkw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ha bi nakɛbee yé? Bi nakɛbee ɛ́ ngoolel-mɛkpa ɛ Zɛɛb é? Nɛ tsɛɛtsɛ mɛ lɛɛ bin náá, yii bi nakɛbee ɛ, nyɛy eedhaa-dhaŋaak ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Etɛɛ náá, Zaŋ ɛ́ mot ekwyala nalɛɛ náá: “Ɛsok nɛ wɔ nɛ tɔ́, mɛ waalwom ngoola-ngoola yam, étɛp nyɛ neekɛkoobal wɔ mɛze.”» ");
INSERT INTO bkw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yezu eebaabil náá: «Mɛ lɛɛ bin ɛ etsɛɛtsɛ náá: Pɛ tɔ bot ɛ di kɔ bɔs'ak ɔ djas, ye tok nɛ mot dhaa Zaŋ Nduuel-bot. Tin, ye guaa náá, tɔ bot djas di tɔ Ɛyoŋ ɛ Zɛɛb ɔ, mot di mɔɔ dhyeeb ɔ di boo-mot nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Bot ɛ mbyak Yisalaɛl djas nɛ bɛnɔŋel ɛ epata e lapo naagwak nyɛ, bɔɔ myaal náá, Zɛɛb ɛ́ mot epiki. Bhii tak, bɔɔ batazɛduwa Zɛɛb pɛ daa Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tin, eFalizyɛ nɛ bɛlyoel ɛ etsi ɛ Zɛɛb naabyen ɛkwosak ɛ Zɛɛb étɛp'ɔɔ, bɛ naapɛɛ náá, Zaŋ duu bɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yezu eebaazɛke náá: «Mɛ gek bot ɛ mɛlu mak nɛ bɛzɛ? Bɛ baakɔa nɛ zɛ é? ");
INSERT INTO bkw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bɛ ɛ́ dáa zɛɛga bɔɔ dhyeeb mendiindil kɔ ɛbɛsɛɛ ɛ bot djas di edi ɛ. Tin, ngɔt katsim ɛ́, lɛɛ nɛ bɔɔ bɛsɔ bɛ náá: “Bis eebwom bin ngɔmbi, bi ààpabɔl. Bis eedjeeb bin mɛdjeeb mɛ ɛsyee, bi ààpadje!” ");
INSERT INTO bkw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Etɛɛ náá, Zaŋ Nduuel-bot eezyɛ. Nyɛ nabɛ ààdɛ mapa, ààdɛ mɛnyok, bi kake ɛ náá: “Ye ɛ́ ɛlyeeb ɛ di esa nyɛ deenek!” ");
INSERT INTO bkw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sɛɛŋɛlɛ Mɔn Mot eezyɛ. Nyɛ ɛpedɛ yɛ edee nɛ mɛnyok, bi kake ɛ náá: “Beeka nwyak é, mɛsa mɛ ɛ́, yɛ ɛ́ ɛdɛ edee nɛ mɛnyok. Nyɛ ɛ́ mɔɔ sɔ bɛnɔŋel ɛ epata e lapo, nɛ bot ɛ di nɛ mbee tsik ɔ!” ");
INSERT INTO bkw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tin, bot djas di myaal etsoŋ e Zɛɛb ɔ, bɛ ɛpegu náá, ye ɛ́ epiki.» ");
INSERT INTO bkw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dhiiti mot Falizyɛ zokazɛdjóo Yezu, nyɛ zɛdɛ edee bɛ nɛ. Wɔ gwaa, Yezu zɛtɔ́ pɛ daa lɛ, nyɛ eezɛnɔɔ di kɔ mesa. ");
INSERT INTO bkw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pɛ kɔ dɛl ɛ tak ye nabɛ ɛ́ nɛ dhiiti moma nadi nɛ mbee dék ɔ. Dáa nyɛ nagwak náá, Yezu nadi ɛ́, kɔ mesa pɛ daa mot Falizyɛ ɛ, nyɛ eezɛzyɛ nɛ bɛɛb nasael nɛ ɛkok ɛ albat ɛ «tɔɔɔ» nɛ mɛnanas. ");
INSERT INTO bkw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nyɛ eezɛtyaa bhii koŋ ɛ Yezu, é dje si mɛko mɛ. Nyɛ moo tin ebel mɛko ɛ Yezu nɛ miŋal mɛ. Tin, nyɛ moo suŋal yɛ nɛ bhoo lo'ɛ, dɔɔ nɛ ɛboma nuub'ɛ é mɛko ɛ Yezu. Bhii tak nyɛ eezɛso mɛnanas kɔ mɛko mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","É ghɛŋ mot Falizyɛ nadjóo Yezu náá, nyɛ zɛdɛ pɛ daa lɛ ɛ, nabee deenek ɛ, nyɛ moo tin elii tɔ lyem'ɛ náá: «Mot tak ɛpedi ɛ́ ngoolel-mɛkpa ɛ Zɛɛb ɔɔ, pe nyɛ eegu mbi moma mɛt nyɛ'aak. Pe nyɛ eegu náá, nyɛ ɛ́ moma na mbee dék!» ");
INSERT INTO bkw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yezu eezɛke nɛ mot Falizyɛ yenɔk náá: «Simɔŋ, mɛ ɛ́ nɛ sa wat mɛ di kwyɛl ɛlɛɛ wɔ.» Simɔŋ eezɛke nɛ nɛ náá: «Bela, liia lyoel.» ");
INSERT INTO bkw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yezu eezɛke nɛ nɛ náá: «Mot ngɔt naakola bot ɛbá epata. Ngɔt nakola ɛ́, epata bɛmil ɛtɛn, dhiiti tak epata bɛmil mɛkam-mɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Dáa bɔɔ djas nadi ààbɛ nɛ ghwyil ɛbulal epata tak ɛ, nakuma epata ɛ́ boopel kola bɔɔ djas bɛbá. Pɛ tɔ bot ɛbá binɔk ɛzɛ aakwyɛl mot'enɔk dhaa tyɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simɔŋ eezɛbɔɔza náá: «Yɛ bɛ mam ɔ, mɛ gek ɛ́ náá, yɛ aadi ɛ́, mot nakola epata ɛbuɛpe ɔ.» Yezu eezɛbɔɔza nɛ nɛ náá: «Simɔŋ, wɔ ɛ́ nɛ gham.» ");
INSERT INTO bkw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bhii tak nyɛ eezɛliig mis, gwyák moma tak. Nyɛy nɛ Simɔŋ náá: «Wɔ eebee moma yak é? Mɛ eeni tɔ ndjaŋ'ɔ, wɔ ààpadjɛ mɛ mɛdii mɛ ɛgwyii ɛ mɛko. Gwyáka! Nyɛ eegwyii mɛ mɛko nɛ miŋal mɛ, bhii tak nyɛ eesuŋal yɛ nɛ bhoo'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wɔ ààpaboma nuub'ɔ é mɛmuk mam. Yɛ kabɛ nyɛy ɔ, dáa mɛ looni wak mos ɛ, nyɛ ààpakat ɛboma nuub'ɛ é mɛko mam. ");
INSERT INTO bkw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wɔ ààpalɔɔb mɛ mul kɔ lo. Yɛ kabɛ nyɛy ɔ, nyɛ eelɔɔb mɛ mɛnanas é mɛko! ");
INSERT INTO bkw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Étɛp tak ɛ́ mɛ di lɛɛ wɔ náá: Bɛtɛ nɛ mesyem mɛ eepelel! Étɛp tak ɛ́ nyɛ lyaal boo kwyɛl deenek. Mot pelaa ba bim ɔ, zobaalyaal ɛ́ ba bim kwyɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yezu ɛ́ boozɛke nɛ moma tak náá: «Mesyem mɔ, eepelel.» ");
INSERT INTO bkw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bot ɛ bɛ nɛ bɛ nɔɔ nadi kɔ mesa ɔ moo tin elii pak'ɔɔ náá: «Nwyak ɛ́ nwyaa kwaambi mot di nɛ ghwyil ɛpel mesyem mɛ bot'aak?» ");
INSERT INTO bkw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tin, Yezu eezɛke nɛ moma yenɔk náá: «Ɛmyaal ɛ lɔ eetsik wɔ. Tɔ́a tɔ egwyem.» ");
INSERT INTO bkw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bhii tak, Yezu eezɛtɔ́ kɛgoola bot Mbɛɛ Bhaadal Ɛyoŋ ɛ Zɛɛb pɛ tɔ eghaada nɛ kɔ bɔɔ mɛl, bɛ nɛ bɛdjekel bɛ kam nɛ bɛbá, ");
INSERT INTO bkw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","zɛnɔɔ bɛdhiiti boa nyɛ nawyisal embee esisim tɔ lɔɔ ɔ, nɛ bot nyɛ natsik bɛ ɔ. Ye nabɛ ɛ́ Maali di djóoaa Maali mot dɛl ɛ Makdala ɔ, mot esisim etɛn nɛ ebá nasɔaa tɔ lɛ ɔ, ");
INSERT INTO bkw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zan, mwaa Kuuza, ngɔt tɔ lɔɔg ekukuma di sa mɛsa tɔ ndjaa mɛkoozi Elood ɔ, Suuzan, nɛ bɛtɛ nɛ bɛdhiiti boa nadi ekwyee Yezu nɛ bɛdjekel bɛ nɛ esa e bɔɔ met. ");
INSERT INTO bkw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Zukamwaa nɛ mot nadus mɛl nɛ mɛl ɔ, naazɛsaala é bhaaz ɛ Yezu. Wɔ gwaa Yezu zɛkan kana yak: ");
INSERT INTO bkw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Dhiiti mot ngɔt zokazɛtɔ́, kɛmwam mɛbhek tɔ pyeeb'ɛ. Tyee nyɛ nadi emwam ɛ, dhiiti kyee bhek eezɛkwyit é ze. Haa kpaa-ghoŋ nɛ bhek'enek, bhii tak, enen ɛ zɛdɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Dhiiti kyee bhek kakwyit ɛ́, kɔ bɔs di nɛ bat mɛkok ɛ. Tyee bhek'enek nakwyit ɛ, ye ɛ́ boozɛsyee, etɛɛ náá, é di tak, bɔs nadi ɛ́ ghas. ");
INSERT INTO bkw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dhiiti yak kyee bhek kazɛkwyit ɛ́ tɔ engwyinini. Bhek tak eezɛkwyil lɔɔg wat nɛ engwyinini. Dikel engwyinini e tak eeboozɛgó yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ghuna dhiiti kyee bhek naazɛkwyit é mbɛɛ bɔs. Tyee yɛ nawyee ɛ, bhek nɛ bhek naadjɛ bhum bɛdhet ɛbuɛpe.» Bhii Yezu nasilal kana yenek ɛ, nyɛ eezɛke náá: «Gwakeka ɛnyɔɛpe, bi ɛ́ di nɛ mɛlɔ étɛp ɛgwak ɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bɛdjekel ɛ Yezu zokazɛdji nyɛ ɛsuk ɛ kana tak. ");
INSERT INTO bkw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wɔ gwaa nyɛ zɛbɔɔza nɛ nɔɔ náá: «Biyɔ, bi eezedjɛaa etsoŋ e ɛgu ɛsuk ɛ Ɛyoŋ ɛ Zɛɛb. Yɛ bɛ bɛsɔ bin ɔ, bɛ gwak yɛ ɛ tɔ ekana. Deenek, “Bɛ ɛ́ nɛ ghwyil ɛgwyák nɛ mis, ààbee. Bɛ ɛ́ nɛ ghwyil ɛgwak nɛ mɛlɔ, ààpiibal sa di kwyɛl ɛlɛɛ ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Gwakeka ɛsuk ɛ kana tak: Bhek ɛ́ mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɛbhek mɛ nakwyit é ngwoob gba ɛ, ye ɛ́ dáa bot ɛ di egwak mɛkpa ɛ Zɛɛb, da Dim Mot Mɛkɔŋ ɛ́ zɛdis bɛ yɛ tɔ ebhum e elyem ɔ, étɛp ɛkaab náá, bɛ ɛ́ zɛkɛdum koŋ nɛ Zɛɛb, da bɛ ɛ́ tsak. ");
INSERT INTO bkw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mɛbhek nakwyit kɔ bɔs di nɛ bat ɛkok ɛ́ dáa bot ɛ di egwak mɛkpa ɛ Zɛɛb ɔ, bɛ dja yɛ ɛ nɛ mɛmyaala. Ghuna bɛ ààbet náá, ye tyaa “zik”. Bɛ dyeebamyaal yɛ ɛ, é ba mɔɔ ɛwala batsa, kasɛka ɛ́, é di mɛbhowal aakatuula ɔ, bɛ eekat ɛdum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bhek nakwyit tɔ engwyinini ɛ, ye ɛ́ dáa mbi bot ɛ di egwak mɛkpa ɛ Zɛɛb ɔ, bhii tak, bɛ kawak ɛ́ tete ze kɔ ɛsu ɛ embee esiiza, nɛ ekum e bɔs'ak, nɛ mɛnyɔ mɛ tsik bɔs'ak. Bɛ tok nɛ ghwyil ɛdjɛ tɛtɛ ebhum. ");
INSERT INTO bkw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bhek kwyit kɔ mbɛɛ bɔs kwyɛl ɛlyaal ɛ, bot ɛ di egwak mɛkpa ɛ Zɛɛb, da bɛ ɛ́ wa lyem é ɛbaal ɛ yɛ, da bɛ ɛ́ kɛ mbɛɛ kyeed, bɛ aadjɛ mbɛɛ ebhum ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Mot ɛ́ nɛ ghwyil ɛtuub lama, da nyɛ ɛ́ butal yɛ nɛ mɔɔ bhe, nɛghu ɛnɔɔ yɛ, da wa pɛ si goŋ é? Ye nɛɛgaa ɛ́, pɛ kɔ tɛɛg etɛɛ náá, bot ɛ di ni tɔ ndjaŋ ɔ, needi tɔ gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Esa ee di tɔ sɔ ɛ djas aadi ɛ́, wyis é gwyɛ mwos dwoo. Esa e mɛsɔ djas aadi ɛ́, nyen é gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dika nɛ etsoŋ dum nɛ etɛp djas bi di egwak ɛ! Etɛɛ náá, mot aadi nɛ ba bim sonok ɔ, bɛ waabil nyɛ dhiiti. Tin, mot kwaadi ààbɛ nɛ sonok ɔ, bɛ aadis nyɛ ba bim djas nyɛ di nɛ yɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nyɛɛg ɛ Yezu nɛ bɔn nyɛɛg zokazyɛ, zɛbela Yezu. Bɛ eezɛtyaa pɛ kel etɛɛ náá, ze ɛdhaa étɛp bɛ neekɛboma nɛ Yezu nadi ɛ́, ɛkɔɔlaɛpe étɛp mɛbu mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Deenek, bɛ eezɛlɛɛ Yezu náá: «Nyoog nɛ bɔn nyoog ɛ́ metetel pɛ kel, bɛ ɛpekwyɛl ɛboma nɛ nɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wɔ gwaa Yezu zɛbɔɔza nɛ bot djas náá: «Nyaag'am nɛ mɔn nyaag'am ɛ́ bot ɛ di egwak mɛkpa ɛ Zɛɛb, da looba nɛ yɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Dhiiti dwoo, Yezu eezɛni tɔ boo elɛɛd bɛ nɛ bɛdjekel bɛ. Bhii tak nyɛ eezɛke nɛ nɔɔ náá: «Djhoosɛɛka, tɔ́ pɛ yii kyiid boo soob na djato-djato.» Bhii tak bɛ eezɛtɔ́. ");
INSERT INTO bkw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dáa bɛ nadi ekɛ tɔ elɛɛd ɛ, gɔ eezɛbe Yezu. Kasɛka ɛ́, boo ghuu ɛlyelɛpe eezɛkan ɛpupal kɔ dii. Mɛpupal mɛ ghuu tak eeghɛɛ ɛbhyeeb ɛ mɛdii kɛɛza é elɛɛd, elɛɛd moo tin eni mɛdii. Mɛdii mɛ tak ɛkɛɛ sa yɛ aalwoodal-lwoodelak elɛɛd, bɛ moo tin pak tsik nɛ ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bɛdjekel ɛ Yezu eezɛtiila pɛ daa lɛ, bɛ eezɛdjem nyɛ nɛ etsim: «Ghɛŋ, Ghɛŋ, mena ɛ́ di esik'aak!» Tin, Yezu eezɛdjem. Bhii tak, nyɛ eezɛbhɛm ghuu nɛ ɛbhyeeb. É di'enek, ghuu eezɛsila, bhwak moo tin «kup». ");
INSERT INTO bkw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bhii tak, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Ɛmyaal ɛ len ɛ́ wo?» Ye nabɛ ɛ́ boo bwoo naamɛt bɛ, bɛ naadyeebadjoka dhaa nyel. Bɛ moo tin edjinel pak'ɔɔ náá: «Nwyak ɛ́ nwyaa kwaa mbi mot di náá, dɔɔ nɛ ghuu nɛ mɛdii ɛpegwak nyɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yezu nɛ bɛdjekel bɛ eezɛkum pɛ kyee dik Ghadasa di di egwyákel nɛ kyee dik Ghalile ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Dáa Yezu nadi esul tɔ elɛɛd ɛ, dhiiti mot dɛl tak zokazyɛ, zɛboma nɛ nɛ. Mot tak nabɛ ɛ́ nɛ embee esisim nadi dhedhek nyɛ ɛ. Nyɛ nabɛ ɛ́ ààbɛ nɛ ekaad é nyel, ààkadidi tɔ ndjaa. Nyɛ nakadidi ɛ́ tɔ mɛvit. ");
INSERT INTO bkw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Dáa nyɛ nabee Yezu ɛ, wɔ gwaa nyɛ zɛbo tsim. Nyɛ eezɛkwyit mɛboŋ si mɛko mɛ. Nyɛ eezɛbo tsim, nyɛy nɛ nɛ, náá: «Mena ɛ́ nɛ yaa tɛp, Yezu, Mɔn Zɛɛb-Mɛkaake? Mɛ ɛpedjaala nɛ nɔ, nàtwak mɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yezu eezɛke nɛ mbee sisim náá, nyɛ wyis tɔ lɛ, etɛɛ náá, ye nabɛ ɛ́, mbee sisim tak eezeloobe di tɔ lɛ. Nyɛ nadi ɛ́ kɔɔla mɛmbɔ nɛ mɛko nɛ eghwooz étɛp nyɛ neemɛtaa é di wat. Mot tak nabebwak yɛ ɛ bwakak. Da mbee sisim tak ɛ́ kazyeegal nyɛ, kyeed nyɛ tɔ bal. ");
INSERT INTO bkw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yezu zokazɛdji nyɛ náá: «Din ɛ lɔ ɛ́ ɛyé?» Nyɛ eezɛbɔɔza nɛ nɛ náá: «Yam din ɛ́ “Mɛkɔm-mɛkɔm”», etɛɛ náá, bɛtɛ nɛ embee sisim naani tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tin, embee esisim nadi edjaala nɛ Yezu náá, nyɛ nàkyeed bɛ tɔ guk di ààbɛ nɛ ɛsik ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","É di tak, ye nabɛ ɛ́ nɛ boo ɛsaŋ ɛ bɛghwyee nadi é ɛgɔɔ kɔ mɛtsok menek ɔ. Embee esisim eezɛdjaala nɛ Yezu, náá, nyɛ kyeed bɛ tɔ mɛnyel mɛ bɛghwyee binɔk. Yezu zokamyaal bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tin, wɔ gwaa embee esisim zɛwyis tɔ mot'enɔk, ni tɔ ɛsaŋ ɛ bɛghwyee binɔk. Bɔɔ djas eezɛsul nɛ ekaab pɛ bɛ nadi kɔ ɛkalel ɛtsok ɛ. Wɔ gwaa bɛ zɛges, kɛghaaga tɔ dii, diida. Bɔɔ djas si na «bhɛɛɛ». ");
INSERT INTO bkw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Dáa bot ɛ nadi ebaal mɛsaa mɛ bɛghwyee binɔk nabee edjema binek djas ɛ, bɛ ɛ́ boozɛtsema nɛ ekaab, sik, kɛlɛɛ bot kɔ eghaada nɛ kɔ bɔɔ mɛl. ");
INSERT INTO bkw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bot zokawyis tɔ́ kɛbee sa nasɛ́ɛ ɛ. Bɛ eezɛkum pɛ kyee Yezu nadi ɛ́. Tin, bɛ eezɛbee mot na embee esisim mɛkɔm-mɛkɔm nawyis tɔ lɛ ɔ, ndiindil é ngwoob ɛ Yezu, nyɛy nɛ ekaad é nyel. Nyɛy nyel ɛnyɔɛpe. Wɔ gwaa, bwoo zɛmɛt bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bot ɛ nabee edjema binek djas ɔ, moo tin ebaŋa dáa mot na embee esisim mɛkɔm-mɛkɔm natsak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tin, bot ɛ kyee dik'enek djas zokazɛdjaala nɛ Yezu náá, nyɛ dus kɔ kyee dik'ɔɔ, etɛɛ náá, ye naadyeebakpaa bɛ boo ɛkɛɛd. Bhii tak, Yezu eezɛni tɔ elɛɛd, nɔɔ nyel'ɛ, sik. ");
INSERT INTO bkw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mot na embee esisim nawyis tɔ lɛ ɔ booke nɛ nɛ náá: «Mɛ kwyɛl ɛ́, mena gyeeka lɔɔg wat.» Yezu ɛ́ boozɛswaal nyɛ. Nyɛ ɛ́ booke nɛ nɛ náá: ");
INSERT INTO bkw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Sika pɛ ndjaŋ'ɔ, da wɔ ɛ́ kɛlɛɛ enɛm nɛ embɛɛ Zɛɛb sa wɔ ɛ.» Mot'enɔk eezɛtɔ́, nyɛ moo tin ekɛtuud kɔ ghaada djas dáa Yezu natsik nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Dáa Yezu nabula pɛ yak kyiid dii ɛ, wɔ gwaa zukamwaa nɛ mot baazɛboma nɛ nɛ, etɛɛ náá, bɛ nadi ebwood nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dhiiti mot, din ɛ lɛ nabɛ ɛ́ Zayilus. Nyɛ nadi ɛ́, kukuma ndjaa mendjaala mɛ eYuda. Nyɛ eezɛkwyit mɛboŋ si mɛko ɛ Yezu, é djaala nɛ nɛ, nyɛ zyɛ pɛ ndjaŋ'ɛ, ");
INSERT INTO bkw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","etɛɛ náá, nyɛ nabɛ ɛ́ nɛ sim ɛsyes ɛ lɛ ngɔt, mɔn membu kam nɛ ebá nadi ebɛ́ ɛkpaŋɛpe pak tsik nɛ ɛsyee. Dáa Yezu nadi etɔ́ ɛ, zukamwaa nɛ mot nadi edu nyɛ, bak eghuŋa nyɛ é nyel, bak tak etiidal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ghuna tɔ ɛdhuu ɛ bot binɔk, ye nabɛ ɛ́ nɛ dhiiti moma, ghiya nadi ekekɛk nyɛ é nyel boa, ààbɛ nɛ ɛtsek ɔ. Ɛbɛ́ ɛ tak naasa nɛ nɛ tyee membu kam nɛ ebá. Nyɛ naasilal epata bɛ djas tɔ mendjaa mɛ mɛgwoma ɛbuɛpe, ɛbɛ́ ààsi. Ye nabɛ ààbɛ nɛ mot nakwak ɛgwom ɛbɛ́ ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nyɛ eezɛdu Yezu bhii koŋ, zyɛ, zɛmɛt kyee ɛghɔ ɛ kaad'ɛ wat. Mɛta nyɛ nazomɛt ɛ, é di tak wat, ghiya eezɛtsek. ");
INSERT INTO bkw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yezu eezɛdji náá: «Ɛzɛ mɛt mɛ?» Wɔ gwaa bot djas kɛla, Pyɛɛd eezɛke náá: «Ghɛŋ, beea kwaambi zukamwaa nɛ mot di etiidal wɔ ekyee djas'aak.» ");
INSERT INTO bkw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Deenek, Yezu eezɛke náá: «Tsɛɛtsɛ mot eekwyɛt mɛ, etɛɛ náá, mɛ eegwyak náá, dhiiti pes mɛbwala eewyis tɔ lam.» ");
INSERT INTO bkw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Dáa moma tak nagu náá, nyɛ eepanaa ɛ, moma tak eezɛtiila, nyɛ moo pwak nɛ bwoo. Bhii tak, nyɛ eezɛkwyit mɛboŋ si, si mɛko ɛ Yezu. Nyɛ eezɛmyam é mis mɛ bot djas, tin, nyɛ moo elɛɛ nɛ bot djas étɛp yé nyɛ namɛt kaad ɛ Yezu ɛ, nɛ dáa nyɛ nakatsak é di tak wat ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wɔ gwaa Yezu eezɛke nɛ nɛ náá: «Ɛsyes ɛ lam, ɛdum ɛ koŋ ɛ lɔ nɛ Zɛɛb eetsik wɔ. Tɔ́a tɔ egwyem.» ");
INSERT INTO bkw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tinaak, Yezu dinaa elii, ngoola-ngoola ngɔt eezɛdus pɛ ndjaŋ ɛ kukuma ndjaa mendjaala mɛ eYuda, zɛlɛɛ nyɛ náá: «Ɛsyes ɛ lɔ eezepɛka. Nàkabaadhek lyoel.» ");
INSERT INTO bkw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yezu nabɛ ààbis sa bɛ nadi elii ɛ. Nyɛ ɛ́ boozɛke nɛ Zayilus náá: «Nàbem ba. Duma koŋ nɛ Zɛɛb, nyɛ waatsak!» ");
INSERT INTO bkw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dáa nyɛ nakum pɛ ndjaŋ ɛ, nyɛ eezɛlu bot djas náá, bɛ nàni tɔ ndjaa. Nyɛ nazomyaal ɛ́, bɛdjekel bɛ, Pyɛɛd, Zaŋ nɛ Zak, zɛnɔɔ sɛɛg nɛ nyɛɛg mɔn. ");
INSERT INTO bkw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bot djas, metetel nɛ mɛgwyɛ, nɛ etaŋal nɛ etsim. É di'enek Yezu ɛ́ booke nɛ nɔɔ náá: «Nàdjeka. Mɔn ààpagwyɛ. Nyɛ ɛ́ é gɔ́.» ");
INSERT INTO bkw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wɔ gwaa bot gɔ nyɛ etɛɛ náá, bɛ nadi egu náá, mɔn naazegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nyɛ eezɛmɛt mɔn é mbɔ, nyɛ eezɛben gwood. Nyɛy nɛ nɛ náá: «Mɔn'am, wyɛla!» ");
INSERT INTO bkw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","É di tak wat, mɔn'enɔk eezɛgom, nyɛ eezɛwyɛl. Bhii tak, nyɛ ɛ́ boolwom bɛ náá, bɛ djɛ mɔn tak edee e dek. ");
INSERT INTO bkw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tin, ye nabɛ ɛ́, sɛɛg nɛ nyɛɛg naadyeebadjoka ɛlyelɛpe. Yezu eezɛlyak bɛ náá, bɛ nàlɛɛ bot sa nasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yezu eezɛsɛɛg bɛdjekel bɛ kam nɛ bɛbá, nyɛ eezɛdjɛ bɛ ghwyil nɛ eghɛŋ ɛsɔ embee esisim nɛ ɛtsik ɛ bot ɛ mɛbɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bhii tak nyɛ eezɛlwom bɛ, bɛ kɛgoola Mbɛɛ Bhaadal Ɛyoŋ ɛ Zɛɛb, nɛ ɛtsik ɛ membel. ");
INSERT INTO bkw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nyɛ eezɛdjɛ bɛ etsi náá: «Sa mot àànɔɔ sonok wat, nyɛ neetɔ́ nɛ yɛ mɛdjoŋ. Sa mot àànɔɔ sek, àànɔɔ ɛkoo, àànɔɔ mapa, kɛyaka nɛ epata tɔ mengwyɛ men. Sa mot ààdi nɛ ekuwa ebá. ");
INSERT INTO bkw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tɔ edi djas bot aamyaal náá, bi sulal ɛ, dika tɔ ndjaa tak, kɛkum dwoo bi aadus tin ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mɛl djas bot aapɛɛ náá, bi nàsulal pɛ daa lɔɔ ɔ, kpaaka yibɔ, da bi ɛ́ kut bɛ piib mɛko men. Yɛ aadi ɛ́, tyee mwana étɛp embee esesɛɛ bɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bɛdjekel eezɛtɔ́ pɛ mɛl djas, kɛlɛɛ bot Mbɛɛ Bhaadal, nɛ ɛtsik ɛ bɛtɛ nɛ membel é edi djas. ");
INSERT INTO bkw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tin, Elood mot nadi mɛkoozi kɔ kyee dik Ghalile ɔ, naagwak menduk mɛ etɛp binek djas. Nyɛ nabɛ ɛ́ ààkagu sa nyɛ gek ɛ, etɛɛ náá, bɛdhiiti bot nadyeebake náá: «Zaŋ Nduuel-bot nagwyɛ ɔ, naazegom.» ");
INSERT INTO bkw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bak náá: «Ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb, Eli, eebaatuula!» Yak kyee bot náá: «Ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb na mwa, eezegom!» ");
INSERT INTO bkw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Elood ɛ́ boozɛke náá: «Ye nabɛ ɛ́ mam ɛmet naazelwom náá, bɛ tsak Zaŋ Nduuel-bot. Ha yenɔk ɛ́ nwyaa mot? Mot mɛ di egwak bot é lii etɛp bak ko ɛsu ɛ lɛ'aak ɛ́ zɛ?» Nyɛ nadi esaa nyɛ neebee Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bot ɛ lwoma zokazɛbula pɛ daa Yezu, bɛ moo tin é baŋa nyɛ esesɛɛ ee bɛ nasa ɛ. Yezu ɛ́ boozɛdul bɛdjekel bɛ, tɔ́ nɛ nɔɔ é ngwoob dhiiti ghaada di edjóoaa Bhɛtsaida ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ghuna bot ɛbuɛpe naagu ze bɛ nadi tɔ́ ɛ, bɛ ɛ boozɛdu bɛ. Yezu zokazɛboma nɛ nɔɔ. Bhii tak, nyɛ moo tin é lyo bɛ dum nɛ Ɛyoŋ ɛ Zɛɛb, nɛ ɛtsik ɛ bot ɛ nadi kwos mɛtsika ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Dáa dwoo nabɛ ye moo sila ɛ, bɛdjekel bɛ kam nɛ bɛbá ɛ́ boozɛtiila pɛ daa lɛ. Bɔɔ nɛ nɛ náá: «Swaala bot bak, bɛ tɔ́ pɛ kɔ mɛl nɛ pɛ tɔ epɛt eedi pak nɛ wak ɛ, etɛɛ náá, penek bɛ waakɛ bela di ndjɔk nɛ edee e dek, etɛɛ náá, menaka wak ɛ́ tɔ bal.» ");
INSERT INTO bkw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","É di'enek, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Djɛka bɛ edee biyɔ bɛ ɛmet!» Bɛ eezɛbaake nɛ Yezu náá: «Bis zokalik ɛ́, nɛ emapa etɛn, zɛnɔɔ bɛsu ɛbá. Wɔ kwyɛl bilak ɛ́ náá, bis kɛɛbɔm edee ee bot bak djas ee?» ");
INSERT INTO bkw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","É di'enek, mɛtaŋ mɛ bot naakum tyee botom bɛmil ɛtɛn. Tin, Yezu ɛ́ boozɛlɛɛ bɛdjekel bɛ náá: «Dhilka bot djas mendiindil, zɛɛga bot mɛkam-mɛtɛɛ-tɛn e di wat.» ");
INSERT INTO bkw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bɛdjekel ɛ́ boozɛsa dáa Yezu nake ɛ. Bɛ eezɛdil bɛ si. ");
INSERT INTO bkw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bhii tak, Yezu zɛnɔɔ emapa etɛn nɛ bɛsu ɛbá binek, nyɛ eezɛben mis pɛ ɛko, zɛghaapɛɛ Zɛɛb étɛp edee binek. Nyɛ eezɛpyak mapa, nɔɔ, djɛ bɛdjekel bɛ, bɛ kaa bot djas. ");
INSERT INTO bkw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mot nɛ mot naadɛ, djil. Bɛdjekel zokabula nɛ mɛbhwaa kam nɛ ebá yii mɛbhubhwak. ");
INSERT INTO bkw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dhiiti dwoo, dáa Yezu nadi é djaala nɛ Zɛɛb e dhiiti sum di ɛ, bɛdjekel nadi ɛ́, bɛ nɛ nɛ. Nyɛ eezɛdji bɛ náá: «Mɛdhuu mɛ bot ke náá, mam ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɛ eezɛbɔɔza nɛ nɛ náá: «Bak ke ɛ́ náá, wɔ ɛ́ Zaŋ Nduuel-bot. Bɛdhiiti náá, wɔ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb Eli. Bɛdhiiti pe ka baake ɛ náá: Wɔ ɛ́ ngɔt tɔ bɛngoolel-mɛkpa ɛ Zɛɛb ee na mwa zegom ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yezu eezɛdji bɛ náá: «Yɛ kabɛ biyɔ ɔ, bi ke náá, mam ɛ́ zɛ?» Pyɛɛd eezɛbɔɔza nɛ nɛ náá: «Wɔ ɛ́ Mɛsia Zɛɛb nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yezu eezɛdul bɛ mɛlɔ ɛlyelɛpe, nyɛ eezɛke nɛ nɔɔ náá, sa bɛ ààlɛɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bhii tak nyɛ eebaazɛbil náá: «Ye goka ɛ́ Sɛɛŋɛlɛ Mɔn Mot zukaa ɛbuɛpe. Bɛpaa, nɛ eboo bɛghaa-Zɛɛb, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi ɛ́ waabhina nyɛ. Nyɛ waagóaa. Mɛlu mɛlɛl bhis ɛsyee ɛ lɛ, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bhii tak, Yezu eezɛlii nɛ bɔɔ djas náá: «Yɛ bɛ náá, mot ngɔt ɛpekwyɛl ɛdu ɛ mɛ ɔ, nyɛ bet ɛkwyɛɛg ɛ nyel'ɛ, da nyɛ ɛ́ bɛp mɛlaaba mɛ mɛlu djas, da nyɛ ɛ́ du mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Etɛɛ náá, mot di ekwyɛl ɛtsik nyel'ɛ ɔɔ, nyɛ aanàkwaabela tsik, mot ɛ́ myaal ɛsu ɛ tsik nyel'ɛ étɛp'am ɔɔ, nyɛ waabela tsik. ");
INSERT INTO bkw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mot ɛbela mɛvu mɛ bɔs djas, da nyɛ ɛ́ gel nyel'ɛ ɛmet ɔɔ, nɛghu ɛpul ɛ nyel ɔɔ, ye ɛ́ tɛtɛ yé nyɛ sa? ");
INSERT INTO bkw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mot aagwak sen étɛp'am nɛ étɛp mɛkpa mam ɔ, tin, mam Sɛɛŋɛlɛ Mɔn Mot ɛ́ waagwak sen étɛp'ɛ dwoo mɛ aazyɛ tɔ duma yam ɛ, nɛ tɔ duma Saag'am nɛ efofop na dɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mɛ lɛɛ bin nɛ tsɛɛtsɛ náá: Tɔ sama bot ɛ di wak'aak, bɛdhiiti aanàkwaagwyɛ, bɔɔ ààbee Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ye naasa tyee yenga wat bhii nyɛ naalii deenek ɛ, Yezu zɛnɔɔ Pyɛɛd, nɛ Zaŋ, zɛnɔɔ Zak, nyɛ eezɛbyet kɔ dhiiti ɛtsok étɛp ɛdjaala nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Esok Yezu nadi edjaala ɛ, bhwoob'ɛ zokaaaswoola; ekaad bɛ moo puu, ɛkasɛpe dáa ngwyes bhi. ");
INSERT INTO bkw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kasɛka tin ɛ́, bot ɛbá é bhaaz'ɛ, bɔɔ elɛɛ elɛŋ nɛ Yezu. Ye nabɛ ɛ́ Moiiz bɛ nɛ Eli. ");
INSERT INTO bkw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bɛ eezɛtuula kuku mɛkas ɛ Zɛɛb. Bɛ nɛ Yezu nadi elii dum nɛ tyee nyɛ aasilal lwomel'ɛ ɛ, nɛ dáa nyɛ aakɛgwyɛ pɛ Yeluzalɛm ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tinaak, Pyɛɛd nɛ bot ɛ lɔɔg'ɛ eezɛduma tɔ gɔ́, «syaaz». Dáa bɛ nakadjem ɛ, bɛ eezɛbee mɛkas ɛ Yezu nɛ bot ɛbá bɛ nɛ bɛ nɔɔ nadi ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","É di nabɛ náá, bot binɔk moo é lik Yezu ɔ, Pyɛɛd eezɛke nɛ nɛ náá: «Ghɛŋ, ye goka ɛ́ náá, mena di wak. Djhoosumka epɛt elɛl: Wat yɔ, dhiiti yii Moiiz, dhiiti kadi ɛ́ yii Eli.» Tinaak, nyɛ nadi ɛ́, ààgu sa nyɛ nadi eke ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","É di nyɛ nadi elii deenek ɔ, eguud eezɛsul, zɛbutal bɛ. Bɛdjekel ɛ́ boozɛgwak bwoo é ɛbee dáa eguud di ebutal bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tɔ eguud binek, gwood zokagék náá: «Nwyak ɛ́ Mɔn'am mɛ nazetɔ ɔ. Gwakeka nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bhii gwood nazegék ɛ, ye nakalik ɛ́, Yezu nyɛ ɛmet. Bɛdjekel ɛ́ boozɛsyel tɛp tak, é ghɛŋ tak, bɛ nabɛ ɛ́ ààbaŋa bot etɛp ee bɛ nabee ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","É yak ɛlu Yezu bɛ nɛ bɛdjekel ɛlɛl binɔk moo é sul ɛtsok ɛlenek, wɔ gwaa zukamwaa nɛ mot zɛboma nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tɔ ɛdhuu ɛ bot binɔk, mot ngɔt moo tin etsim: «Lyoel, mɛ ɛpedjaala nɛ nɔ, kɛla mis kɔ mɔn'am. Ye ɛ́ sim mɔn'am! ");
INSERT INTO bkw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Etɛɛ náá, mbee sisim ɛ́ mɛt nyɛ ɔ, é di tak wat nyɛ ɛpekyeeb, bhii tak, ye ɛ́ kadheeg nyɛ ɛlyelɛpe, é di'enek mɛwyil moo tin ewyis é nuub mɔn. Mbee sisim tak ɛpezuk nyɛ ɛlyelɛpe, ɛdus ɛ lɛ tin nɛ lyel. ");
INSERT INTO bkw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ye bɛ ɛ́, mɛ eedjala nɛ bɛdjekel bɔ náá, bɛ sɔ mbee sisim tak. Bɛ ààpakwak yɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yezu eezɛke nɛ nɔɔ náá: «Embee bot, bot di ààdum koŋ nɛ Zɛɛb ɔ! Mɛlu mɛdhen kalik nɛ nam é ɛdi tɔ len? Baabela náá, mɛlu mɛdhen mɛ di egoka nɛ ɛmaad bin? Dha mɛ nɛ mɔn'ɔ wak.» ");
INSERT INTO bkw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Dáa mɔɔ tak nazokunaa nɛ Yezu ɛ, wɔ gwaa mbee sisim zɛghɛɛg nyɛ si. Bhii tak ye moo zɛdheeg mɔn'enɔk ɛlyelɛpe na «buku-kuku». Tin, Yezu eezɛbhɛm mbee sisim tak, mɔn eezɛtsak. Bhii tak Yezu eezɛbulal nyɛ é mɛmbɔ mɛ sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ye nabɛ ɛ́ bot naadyeebadjoka mɛbwala mɛ Zɛɛb tin. Dáa ye bɛ náá, mot nɛ mot nabɛ ɛ́, nyɛ dinaa edjoka nɛ ɛsɔs etɛp djas Yezu nadi esa ɛ, Yezu ɛ́ boolɛɛ nɛ bɛdjekel bɛ náá: ");
INSERT INTO bkw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Bɛɛka mɛlɔ men ɛnyɔɛpe étɛp bi neebaal sa mɛ aalɛɛ bin ɛ: Ye kalik ɛ́ batsa Sɛɛŋɛlɛ Mɔn Mot neekaaa é mɛmbɔ mɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","É di'enek, bɛdjekel nabɛ ɛ́, ààmɛt lo tɛp nyɛ nalɛɛ bɛ ɛ, etɛɛ náá, ɛsuk ɛ tak nadi bɛ ɛ́ syela étɛp bɛ needi ààmɛt yɛ. Bɛ nadi ɛ́ nɛ bwoo ɛdji ɛ Yezu tɛp'enek. ");
INSERT INTO bkw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bɛdjekel moo tin ebe mɛso pak'ɔɔ étɛp bɛ neegu tɔ sama yɔɔ, ɛzɛ di boo-mot. ");
INSERT INTO bkw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yezu eezɛgu sa nadi edhaa pak'ɔɔ ɛ, wɔ gwaa nyɛ zɛnɔɔ mɔɔ dhyeeb, nɛɛg nyɛ é ngwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nyɛy nɛ nɔɔ náá: «Mot ɛ́ myaal mɔn'ak kɔ ɛsu ɛ kwyɛl nyɛ di nɛ yɛ nɛ nam ɔ, nyɛ myaal ɛ́ mam. Tin bela náá, mot ɛ́ myaal mɛ ɔ, nyɛ myaal ɛ́, mot nadhis mɛ ɔ. Etɛɛ náá, mot di mɔɔ dhyeeb pak biyɔ djas ɔ, ye ɛ́ nyɛy ɛ di boo mot.» ");
INSERT INTO bkw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zaŋ eezɛke nɛ Yezu náá: «Ghɛŋ, bis eebee dhiiti mot esɔ embee esisim nɛ din ɛ lɔ. Bis eelyak nyɛ, etɛɛ náá, nyɛ ààkɛ lɔɔg wat mena nɛ bɛ nɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Sa mot ààlyak nyɛ, etɛɛ náá, mot di ààbhina bin ɔ, yenɔk ɛ́ mot'en.» ");
INSERT INTO bkw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dáa ɛlu ɛ nabɛ náá, nyɛ neebyet tɔ gwoo ɛ, nadi yɛ eezekunaa ɛ, Yezu ɛ́ boozɛke nɛ lyemɛ wat náá: Nyɛ ɛpetɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nyɛ ɛ́ bookyeed engoola-ngoola mɛbhaadal pɛ sok. Engoola-ngoola eezɛtɔ́, bɛ eezɛni tɔ dhiiti dɛl pɛ kyee dik Samali étɛp bɛ neekoobal nyɛ di, nɛ esesɛɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tin, bot ɛ dɛl zokabyen náá, nyɛ nàsulal kɔ dɛl ɛ tak, etɛɛ náá, nyɛ nadi etɔ́ pɛ kyee dik Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dáa Zak nɛ Zaŋ bɛdjekel bɛ nagwak deenek ɛ, bɛ ɛ́ boozɛke náá: «Ghɛŋ, wɔ ɛpekwyɛl náá, bis djóo du, dus tɔ gwoo étɛp ye neezɛdik bɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yezu eezɛliig mis, bhɛm bɛ. Bhii tak, nyɛ moo edul bɛ mɛlɔ. ");
INSERT INTO bkw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bɛ eezɛtɔ́ pɛ dhiiti dɛl. ");
INSERT INTO bkw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yezu bɛ nɛ bot ɛ nadi egyee nɛ nɛ ɔ gba-gba kuku kyeed, wɔ gwaa dhiiti mot zokake nɛ nɛ náá: «Mɛ ɛpekwyɛl ɛdu ɛ wɔ é di djas wɔ aatɔ́ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yezu zokazɛbɔɔza nɛ nɛ náá: «Bɛbhɛk ɛ́ nɛ eku, enen ɛ́ nɛ mɛk. Kabela náá, Sɛɛŋɛlɛ Mɔn Mot tok nɛ di nyɛ di edjaasi nɛ ɛwala ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nyɛ eezɛke nɛ nwyak dhiiti mot náá: «Dua mɛ.» Mot'enɔk eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, pookobet mɛ, mɛ pookokɛdel sok saag'am.» ");
INSERT INTO bkw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yezu eezɛbɔɔza nɛ nɛ náá: «Beta bot ɛ zegwyɛ ɔ bɛ del myoŋ mɔɔ. Yɛ bɛ wɔy ɔ, tɔ́a, kɛlyaal bot Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nwyak dhiiti mot eebaake yɛ náá: «Ghɛŋ, mɛ waadu wɔ. Pookobet náá, mɛ kɛ ɛmwana nɛ bot ɛ mɛbyel mam.» ");
INSERT INTO bkw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yezu eezɛbɔɔza nɛ nɛ náá: «Mot zemɛt awata, da nyɛ baake náá, nyɛ bulal mis, gwyák pɛ bhis ɔ, yenɔk tak ààpakɔa nɛ Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bhii tak Ghɛŋ eebaazɛsɛ́ɛ bɛdjekel mɛkam-mɛtɛn nɛ mɛkam-mɛmbá nɛ ebá. Nyɛ eezɛlwom bɛ bɛbá-bɛbá pɛ tɔ eghaada nɛ kɔ mɛl mɛ Yezu nabɛ náá, nyɛ aadhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nyɛ eezɛke nɛ nɔɔ náá: «Pyeeb nɛ bɔk. Bot ɛ mɛsa ààbu. Ye goka ɛ́ bi djaala náá, nakuma pyeeb nyɛ dhis bɛdhiiti bot ɛ mɛsa étɛp bɛ needis edee tɔ pyeeb. ");
INSERT INTO bkw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tɔ́ka! Mɛ kyeed bin tin ɛ́, dáa bɔɔ ebhata tɔ eben. ");
INSERT INTO bkw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sa mot àànɔɔ ngwyɛ epata, àànɔɔ ɛkoo, àànɔɔ-nɔŋak dɔɔ nɛ mɛpapa. Sa mot ààbe tyɛ étɛp mɛswosel e ze. ");
INSERT INTO bkw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pɛ tɔ mendjaa mɛ bi aani ɛ, keka sok náá: “Betka náá, egwyem di tɔ ndjaŋ'ak!” ");
INSERT INTO bkw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","É di'enek, mot di nɛ egwyem ɔ di tin ɔ, egwyem bin ɛ́ waakala kɔ lɛ. Yɛ kabɛ náá, mot egwyem tok tin ɔ, egwyem bin ɛ́ waabula pɛ daa len. ");
INSERT INTO bkw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sulalka tɔ ndjaa mot egwyem é tak. Bi ɛ́ djɛaa mɛdii nɛ edee ɔɔ, da bi ɛ́ dɛ yɛ, etɛɛ náá, mot-mɛsa goka ɛ́ nɛ ɛbela etuud e mɛsa mɛ. Sa mot ààkɛ mendjaa nɛ mendjaa. ");
INSERT INTO bkw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bi ɛ́ ni kɔ dɛl, da bɛ ɛ́ myaal bin ɔ, dɛka edee bɛ aadjɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsikeka bot ɛ mɛbɛ́ di kɔ dɛl ɛ tak ɔ, da bi ɛ́ lɛɛ bot ɛ dɛl náá: “Ɛyoŋ ɛ Zɛɛb eezekunaa nɛ nen.” ");
INSERT INTO bkw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pɛ kɔ bɛdhiiti mɛl mɛ bi aani, da bot ɛ́ mɛl mɛ tak ɛpɛɛ náá, bi nàsulal pɛ daa lɔɔ ɛ, tɔ́ka kɔ ɛbɛsɛɛ ɛ dɛl, da bi ɛ́ lɛɛ nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bis ɛpekut piib mɛko mes. Ye ɛ́ piib dɛl ɛ len zenaata bis é mɛko ɛ. Ye goka ɛ́ náá, bi gu náá, Ɛyoŋ ɛ Zɛɛb moo ɛ́ ɛkunaaɛpe nɛ nen.” ");
INSERT INTO bkw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mɛ lɛɛ bin ɛ tsɛɛtsɛ náá: Dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, bot ɛ dɛl ɛlak ɛ́ waapɛ́ɛaa ɛ́ ɛlyelɛpe dhaa bot ɛ dɛl ɛ Sodɔm.» ");
INSERT INTO bkw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Haa kpaa-ghoŋ nɛ nɔ, ghaada Koodazin! Haa kpaa-ghoŋ nɛ nɔ, ghaada Bhɛtsaida! Etɛɛ náá, endem e mɛbwala mɛ nasael pɛ yebɔ ɛpedi náá, ye nasael ɛ́ pɛ ghaada Tiid nɛ pɛ Sidɔn ɔ, pe bot ɛ mɛl menɔk eeloobɔt kaad ɛpum, pe bɛ naazelɔɔba mɛsii, pe bɛ naaloozeliig elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Étɛp tak ɛ́ mɛ di elɛɛ bin náá, dwoo bot aadi pɛ́ɛaa ɛ́, yebɔ mɛpɛ́ɛa waadhaa yii Tiid nɛ Sidɔn nɛ mɛlyel. ");
INSERT INTO bkw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapɛlnaum! Yɛ kabɛ wɔy ɔ, egeka bɔ ɛ́ náá, wɔ ɛ́ nɛ ghwyil ɛbyet, tɔ́ pɛ ɛko? Wɔ waasila pɛ si, batakɛkum dɛl ɛ myoŋ mɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nyɛ eebaazɛke nɛ bɛdjekel bɛ náá: «Mot aagwak bin ɔ, nyɛ eegwak mɛ. Mot ɛ byen bin ɔ, nyɛ byen ɛ́ mam. Tin, mot ɛ byen mɛ ɔ, nyɛ eebyen mot nadhis mɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bɛdjekel mɛkam-mɛtɛn nɛ mɛkam-mɛmbá nɛ ebá nalwomaa ɔ, bɛ eezɛbula nɛ mɛmyaala djas. Bɔɔ nɛ Yezu náá: «Ghɛŋ, dɔɔ nɛ embee esisim ɛpegwak bis esok bis di elii nɛ nɔɔ é ghwyil din ɛ lɔ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛ di ɛ́, ebee Satan eedus pɛ ɛko sila pɛ kɔ bɔs tyee ngwyes bhi. ");
INSERT INTO bkw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gwakeka: Mɛ eedjɛ bin eghɛŋ ɛkɛ kɔ bɛnyɔ, ebaalwɔl, dɔɔ nɛ ɛkɛ kɔ ghwyil mot mɛbhuka men. Ye tok nɛ sa yɛ aasa bin. ");
INSERT INTO bkw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tin, nàmyaalaka, etɛɛ náá: Embee esisim ɛpegwak bin. Bi goka nɛ ɛmyaala ɛ́, yɛ bɛ náá, min men ɛ́ kwyalaa tɔ gwoo ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","É ghɛŋ tak, Yezu naazɛbela boo mɛmyaala Sisim na Dɛɛ nadjɛ nyɛ ɛ́. Nyɛ eezɛtsim: «Hee Saag'am, Ghɛŋ gwoo nɛ bɔs. Mɛ eeghaapɛɛ wɔ, étɛp náá, wɔ eelyaal bɔɔ dhyeeb esesɛɛ ee di esyela é mis mɛ bɛtsoŋ ɛ bot nɛ bot ɛ mɛtselal ɛ. Nɛ tsɛɛtsɛ, Saag'am, wɔ nɛ kwyɛl náá, eesael deenek. ");
INSERT INTO bkw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«Saag'am naadjɛ mɛ esonok djas. Ye tok nɛ mot di egu Mɔn, yɛ di ààbɛ Sɛɛg ɔ. Tin, mot aanàkwaagu náá, Sɛɛg ɛzɛ, yɛ di ààbɛ Mɔn ɔ, nɛ bot ɛ Mɔn aakwyɛl ɛlyaal bɛ nwyak ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bhii tak Yezu eezɛliig mis, gwyák bɛdjekel, nyɛy nɛ nɔɔ, bɔɔ bɛmet náá: «Mɛnyɔ nɛ biyɔ, etɛɛ náá, bi ɛpebee sa bi di ebee'enek! ");
INSERT INTO bkw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Etɛɛ náá, mɛ lɛɛ bin ɛ́ tsɛɛtsɛ náá, bɛtɛ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb nɛ bɛmɛkoozi ɛbuɛpe nadi ɛ́, nɛ gwyes ɛbee esa ee bi di ebee'aak. Saabɛgɔs nɛ nɔɔ ɛ́ náá, bɛ nabɛ ɛ́ ààbee. Bɛ nadi ɛ́ nɛ gwyes ɛgwak sa bi di egwak mos'ak, saabɛgɔs nɛ nɔɔ ɛ́ náá, bɛ nabɛ ààgwak.» ");
INSERT INTO bkw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dhiiti lyoel etsi e Zɛɛb naazɛwyɛl, lii, étɛp ɛbhowal ɛ Yezu. Nyɛ eezɛdji nyɛ náá: «Lyoel, mɛ sa dáa étɛp mɛ neebela tsik na kɔm-kɔm?» ");
INSERT INTO bkw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yezu kabɔɔza nɛ nɛ náá: «Haa, yé nakwyalel tɔ mɛkana mɛ etsi bina? Wɔ gwak dáa tɔ tak?» ");
INSERT INTO bkw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mot'enɔk zɛbɔɔza náá: «“Wɔ goka ɛ́ wɔ kwyɛl Ghɛŋ, Zɛɛb'ɔ nɛ lyem'ɔ djas, nɛ sisim'ɔ djas, nɛ ghwyil'ɔ djas, nɛ ɛtselal ɛ lɔ djas.” Zɛnɔɔ náá: “Wɔ goka ɛ́ wɔ kwyɛl sɔɔ mot dáa wɔ di ekwyɛl nyel'ɔ met ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yezu ɛ́ bookake nɛ nɛ náá: «Wɔ ɛ́ bɔɔza ɛnyɔɛpe. Sa deenek, wɔ neebela tsik na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ghuna ghaa mɛkana mɛ etsi ɛ Zɛɛb nakwyɛl ɛ́, nyɛ neebela gham. Nyɛ ɛ́ boodji Yezu náá: «Sɔ'am mot ɛzɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yezu kadjɛ nyɛ kana ɛ́ náá: «Dhiiti motom nadi edus pɛ Yeluzalɛm, eesul pɛ Yeliko. Wɔ gwaa bot ɛ djii zɛmɛt nyɛ, duma nyɛ é nyel nɛ mɛbin, bɔɔ zɛdɛk nyɛ esa bɛ djas. Bɛ eezɛkaab, lik nyɛ ekɔɔ nɛ ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Dhiiti ghaa-Zɛɛb nadi edhaa é ze'enek tyee zɛm-dhyee. É ghɛŋ nyɛ nabee mot'enɔk ɛ, nyɛ eezɛgwoob, tɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tyee wat nɛ dhiiti Lɛvit eezɛkwyil é di'enek, bee mot mɛpyoŋ, gwoob nyɛ, tɔ́ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tin, dhiiti mot dɛl ɛ Samali nadi etɔ́ yɛ mɛdjoŋ ɔ nazɛkum é ngwoob mot mɛpyoŋ menɔk. Dáa nyɛ nakabee nyɛ ɛ́, wɔ gwaa ghoŋ zɛmɛt nyɛ ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nyɛ eebaazɛtiila é bhaaz'ɛ, zɛso nyɛ mɛnyok nɛ mul tɔ mɛpyoŋ, zɛdjɛl nyɛ yɛ ɛ́. Bhii tak, nyɛ eezɛkɛl nyɛ kɔ yaaga yɛ, tɔ́ nɛ nɛ pɛ ndjaa bɛdjoŋ. Tin, nyɛ eezɛgwom nyɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yii myɛn, mot dɛl ɛ Samali yenɔk eezɛwyisal ghwooz epata mɛdil ebá, zokadjɛ nakuma ndjaa bɛdjoŋ. Nyɛy nɛ nɛ náá: “Gwoma motom'ak. Epata djas ee wɔ aadi ebaawyisal étɛp'ɛ ɛ, mɛ waaboobulal wɔ yɛ ɛ́, dwoo mɛ aabula ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yezu eebaazɛdji náá: «Tɔ bɔɔ bɛlɛl, ɛzɛ kɔa nɛ ɛdi ɛ́ mɔɔ sɔ mot bot ɛ djii namɛt ɔ?» ");
INSERT INTO bkw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ghaa etsi zokabɔɔza náá: «Yɛ ɛ́ mot nagek nyɛ ghoŋ ɔ.» Yezu ɛ́ booke nɛ nɛ náá: «Tɔ́a, da wɔ ɛ́ sa deenek.» ");
INSERT INTO bkw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dáa Yezu nadi é ze, bɛ nɛ bɛdjekel bɛ ɛ, wɔ gwaa bɛ zokazɛni tɔ dhiiti dɛl. Tɔ dɛl ɛ tak ye nabɛ ɛ́ nɛ dhiiti moma din ɛ lɛ nabɛ ɛ́ Maat. Nyɛ eezɛsulal pɛ daa lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nyɛ nabɛ ɛ́ nɛ dhyeeb, din ɛ lɛ nabɛ ɛ́ Maali. Maali tak nadi ɛ́ si mɛko ɛ Ghɛŋ Yezu é gwak mɛlyo mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ye kabela ɛ́ náá, Maat nadi eghuula étɛp ɛdjaab ɛ edee e bɛdjoŋ. Maat ɛ́ boozyɛ zɛke nɛ Yezu náá: «Ghɛŋ, wɔ ààbee dáa dhyeeb'am dhuugal mɛ nɛ bɛtɛ nɛ yak mɛsa mam mɛ ɛmet'aak é? Lɛɛa nyɛ náá, nyɛ kwyee mɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ghɛŋ eezɛbɔɔza nɛ nɛ náá: «Maat, Maat, wɔ ɛpebem ba é etɛp e gwyes, lyem'ɔ ɛpesɔs etɛp ɛbuɛpe yii toto. ");
INSERT INTO bkw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ye ɛ́ nɛ sonok wat di nɛ boo mɛtaŋ. Maali sɛ́ɛ sa di nɛ boo mɛtaŋ ɛ. Yiizaag ɛ́ di náá, mot tok nɛ ghwyil ɛ dɛk nyɛ yɛ ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dhiiti dwoo, Yezu nadi edjaala é dhiiti di. Dáa nyɛ nasilal ɛ, djekelɛ ngɔt eezɛke nyɛ náá: «Ghɛŋ, lyaala bis ɛdjaala Zɛɛb, dáa Zaŋ nalyaal bɛdjekel bɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yezu eezɛke nɛ nɔɔ náá: «Bi ɛ́ di edjaala ɔ, keka náá: “Zɛɛb Sɛɛg'es, din ɛ lɔ di Dɛɛ ye guaa. Ɛyoŋ ɛ lɔ zyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Djɛ bis ɛlu nɛ ɛlu edee di egoka nɛ nes ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pela bis mesyem mes etɛɛ náá, bisɔ ɛpepel bot ɛ nasa bis mɛbiyo ɔ. Sa wɔ ààbet bis tɔ mɛbhowal.”» ");
INSERT INTO bkw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yezu eezɛbaake nɛ nɔɔ náá: «Djhoopookogek tyee náá: mot ngɔt pak'en ɛ́ nɛ sɔ, nyɛ eezɛtɔ́ pɛ daa lɛ kuku pum. Nyɛ eezɛke nɛ nɛ náá: “Sɔ'am, djema! Kola mɛ emapa elɛl, ");
INSERT INTO bkw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","etɛɛ náá, dhiiti sɔ'am ngɔt nadi é mɛndjoŋ ɔ, aloo nɛ tuula nenak pɛ daa lam. Mɛ tok nɛ edee mɛ djɛ nyɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Djhoopookogekeka náá: Sɔ'ɛ eezɛbɔɔza nɛ nɛ tɔ ndjaŋ'ɛ náá: “Beta mɛ gwyem! Ɛbɛ ɛ ndjaa moo ɛ́ kɔɔla nɛ ɛngoŋ. Bis nɛ bɔn moo ɛ́ ‘kpop’ mendjaa me si. Mɛ aanàkwaawyɛl, zɛdjɛ wɔ emapa é tak!” ");
INSERT INTO bkw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mɛ lɛɛ bin ɛ tsɛɛtsɛ náá, yɛ bɛ náá, nyɛ di ààwyɛl zɛdjɛ nyɛ ɛ́, kɔ ɛsu ɛ ɛsɔ ɛ bɛ nɛ nɛ ɔ, nyɛ waabatawyɛl, zɛdjɛ nyɛ sa nyɛ saŋ ɛ́, etɛɛ náá, sɔ ɛpenaada ɛwaab, ààbɛ nɛ sen. ");
INSERT INTO bkw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Yɛ bɛ mam ɔ, mɛ kalɛɛ bin ɛ náá: Waabka, bi ɛ waadjɛaa. Saaka, bi ɛ waabela. Diigka é ɛbɛ ɛ ndjaa, bɛ waadii bin ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ye ɛ́ deenek, mot aawaab ɔ, nyɛ waadjɛaa. Mot aasaŋ ɔ, nyɛ waabela. Bɛ dii ndjaŋ ɛ́, nɛ mot diig ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«Yɛ bɛ náá, dhiiti mot pak'en ɛ́ sɛɛg mɔn ɔ, mɔn ɛ́ waab su ɔɔ, nyɛ nɛ ghwyil ɛdjɛ mɔn nyɔ é di tak é? ");
INSERT INTO bkw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yɛ kabɛ náá, mɔn waab ɛ́ ɛke ɔɔ, nyɛ ɛ́ nɛ ghwyil ɛdjɛ nyɛ baalɔɔl é di tak é? Yɛ aanàkwaasael. ");
INSERT INTO bkw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kwyii biyɔ, bɛmbee ɛ bot bi di ɛ, bi nɛ gu ɛdjɛ embɛɛ esonok nɛ bɔn bin, gwyasa nɛ Sɛɛg'en di tɔ gwoo ɔ, nyɛ waadjɛ Sisim na Dɛɛ nɛ mot aawaab ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dhiiti dwoo, Yezu nadi esɔ mbee sisim nanɛɛg dhiiti mot bubu ɛ. Wɔ gwaa mbee sisim zokawyis tɔ mot'enɔk, bubu mot'enɔk moo tin é lii. Tin, ɛdhuu ɛ bot ɛ nadi tin ɔ moo tin é djoka. ");
INSERT INTO bkw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","É di'enek, bot ɛ nadi tin ɔ moo tin é ke pak'ɔɔ náá: «Ye ɛ́ Bɛlzebul, kukuma embee esisim, ɛ di edjɛ kɔkɔ yak mbi mɛbwala mɛ nyɛ di esɔ embee esisim nɛ ye ɛ́!» ");
INSERT INTO bkw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bɛdhiiti nadi ekwyɛl ɛlóo ɛ nyɛ pɛ ɛko, da ɛ́ bwood nyɛ pɛ kyɛ. Bɛ ɛ́ boolɛɛ nɛ nɛ náá: «Sa bis dhiiti ɛtseŋa mɛbwala di elyaal náá, Zɛɛb ɛ́ nadhis wɔ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tin, Yezu nabɛ ɛ́, eegu egeka e elyem bɔɔ. Nyɛ ɛ́ booke nɛ nɔɔ náá: «Ɛyoŋ ɛ di náá, mɛsa mɛ bot ɛ tak ɛwaya pak'ɔɔ ɛ, ɛyoŋ ɛ tak aanàkwaadi. Bɔn bil wat tak ɛ waagonel pak'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yɛ bɛ náá, Satan ɛ́ di etwak nyel'ɛ nyɛ met ɔɔ, ɛyoŋ ɛ lɛ aapyet dáa? Etɛɛ náá, bi ke ɛ́ náá, mɛ twak embee esisim ɛ nɛ ghwyil ɛ Bɛlzebul djɛ mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yɛ bɛ náá, mɛ sɔ embee esisim ɛ́ nɛ ghwyil ɛ Bɛlzebul ɔɔ, haa yebɔ bot aasɔ embee esisim nɛ yaa ghwyil? Étɛp tak ɛ́ di náá, bot bin bɔɔ bɛmet aadi ɛ́ bɛtetɛp bin. ");
INSERT INTO bkw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nɛ tsɛɛtsɛ mɛ lɛɛ bin ɛ náá: Ye ɛ́ nɛ ghwyil ɛ Zɛɛb ɛ mɛ di esɔ embee esisim. Ye kwyɛl ɛlyaal ɛ́ náá: Ɛyoŋ ɛ Zɛɛb eezekum tɔ len. ");
INSERT INTO bkw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Yɛ bɛ náá, mot ghwyil di nɛ mɛkoo mɛ dɛɛb ɛ di ebaal ndjaŋ'ɛ ɔɔ, esa bɛ ɛ́ waabaalaa ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yɛ kabɛ náá, dhiiti mot di dhaa nyɛ nɛ ghwyil eezyɛ ɔɔ, nyɛ kwak ɛbhaad nyɛ si ɔ, bhii tak, nyɛ kadɛk nyɛ mɛkoo mɛ dɛɛb mɛ nyɛ nadi ebe-bwaal ɛ. Tin, nyɛ kanɔɔ esa bɛ djas ɛ́ kaa. ");
INSERT INTO bkw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Mot ɛ di ààdi bis nɛ nɛ ɔ, nyɛ ɛ́ mot mɛbhuka mam. Zɛnɔɔ náá, mot di ààkwyee mɛ nɛ ɛsɛɛg ɔ, waaz ɛ waaz'aak.» ");
INSERT INTO bkw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«É sok mbee sisim di ewyis tɔ nyel mot ɛ, ye dyeebawyis ɛ́ tɔ́, tɔ di di ààbɛ nɛ mɛdii ɔ, é kɛsaa di yɛ aakɛwala ɔ. Yɛ di ààbela di ɔɔ, yɛ kake ɛ́ náá: “Mɛ pookosik pɛ ndjaŋ'am, ndjaa mɛ nawyis tɔ tak ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tin, sika yɛ aakasik ɛ, ye kabela ndjaa tak ɛ́, toto, waabela, koobela. ");
INSERT INTO bkw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","É di'enek, ye katɔ́, kɛnɔɔ bɛdhiiti embee esisim etɛn nɛ ebá di edhaa yɛ nɛ embee mɛsa ɔ. Tin, bɔɔ djas kazɛni ɛ́ tɔ ndjaa bɛ bela di ɛdisi ɔ. É di'enek, tsik mot'enɔk kazɛpulel dhaa-dhaŋak tyee nabɛ sok ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dáa Yezu nadi elii deenek ɛ, dhiiti moma zokazɛben gwood tɔ ɛdhuu ɛ bot, nyɛy nɛ nɛ náá: «Mɛnyɔ nɛ moma nabɛp ɛbum ɛ lɔ ɔ! Mɛnyɔ nɛ mɛbel mɛ wɔ nadɛɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Mɛnyɔ nɛ nen, bot ɛ di egwak mɛkpa ɛ Zɛɛb, da bi ɛ́ kɛ dáa Zɛɛb di ekwyɛl ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dáa mɛdhuu mɛ bot nadi esaala é ngwoob ɛ Yezu ɛ, nyɛ moo tin é ke náá: «Bot ɛ di kɔ bɔs'ak mos'aak àànyɔ bot. Bɛ ɛpewaab dhiiti tseŋa mɛbwala mɛ Zɛɛb. Bɛ aanàkwaakobee dhiiti wat, yɛ di ààbɛ yii nabɛ ye ɛ́ ngoolel-mɛkpa ɛ Zɛɛb Yonas ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Deenek, tyee wat Yonas nadi tseŋa é mis mɛ bot ɛ ghaada Niniv ɛ, deenek ɛ́ Sɛɛŋɛlɛ Mɔn Mot aadi tseŋa étɛp bot ɛ di kɔ bɔs'ak mos'ak. ");
INSERT INTO bkw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","É dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, moma di mɛkoozi kɔ mɛl mɛ di pɛ kyɛ bɔs ɛ, waatyaa sok bhwoob bot ɛ mɛlu mak. Tin, nyɛ waakwyesal bɛ ndjɛ sɔs, etɛɛ náá, nyɛ naadus pɛ mɛsik mɛ bɔs, étɛp ɛzɛgwak mɛkpa mɛ etsoŋ ɛ Salomɔŋ. Ghuna yii di wak ɛ eedhaa-dhaŋak yɛ Salomɔŋ. ");
INSERT INTO bkw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","É dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, bot ɛ dɛl ɛ Niniv waatyaa sok bhwoob bot ɛ mɛlu mak. Tin, bɛ waazɛkwyesal bɛ ndjɛ sɔs, etɛɛ náá, bot ɛ ghaada Niniv naazeliig elyem bɔɔ, bhii bɛ nazegwak mɛlyo ɛ Yonas ɛ. Ghuna yii di wak ɛ dhaa-dhaŋak yɛ Yonas!» ");
INSERT INTO bkw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Mot aanàkwaatuub lama, da nyɛ ɛ́ butal yɛ si bhwaa. Yɛ ààsaaa deenek. Ye goka nɛ ɛkɛlaa ɛ́, pɛ kɔ tɛɛg, etɛɛ náá, bot djas aadi eni tɔ ndjaŋ ɔ needi tɔ gwyɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mis mɔ ɛ́ lambi nyel'ɔ. Mis mɔ ɛ́ di enyaasok ɛnyɔɛpe ɔɔ, gua náá, nyel'ɔ djas ɛ́ tɔ selele. Yɛ kabɛ náá, mis mɔ àànyaasok ɔɔ, nyel'ɔ djas ɛ́ tɔ ghooghom. ");
INSERT INTO bkw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Deenek ɛ́, mɛ di elɛɛ wɔ náá, wɔ di tsoŋ mot étɛp ɛbaal eselele di tɔ lɔ ɛ, é kaab náá, eselele bin ɛzɛkɛliiza ghooghom. ");
INSERT INTO bkw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yɛ bɛ náá, nyel'ɔ djas ɛ́ tɔ selele, ààbɛ nɛ kyee nyel wat di tɔ ghooghom ɔɔ, nyel'ɔ djas aadi ɛ́, tɔ gwyɛ, dáa lambi di edjɛ wɔ gwyɛ nɛ mɛkas mɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Dáa Yezu nasilal ɛlii ɛ, dhiiti Falizyɛ zokadjóo nyɛ, nyɛ zɛdɛ pɛ ndjaŋ'ɛ. Yezu zokani tɔ ndjaa mot tak, nɔɔ nyel, disi kɔ mesa. ");
INSERT INTO bkw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falizyɛ yenɔk zokadjoka dáa nyɛ nabee náá, Yezu nabɛ ààgwyii mɛmbɔ ɛsok nɛ nyɛ nɛ dɛ edee ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tin, Ghɛŋ ɛ́ booke nɛ Falizyɛ yenɔk náá: «Beeka dáa biyɔ eFalizyɛ di ɛ: Bi dyeebagwyii ɛ́ ekoŋ e ebɛɛlɛ nɛ ekoŋ e esaan. Yɛ kabɛ tɔ tak ɔ, bi nɛ bu ɛkwosak ɛ djii nɛ embee elyem dhaa nyel. ");
INSERT INTO bkw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Bi ààtselal, ye tok Zɛɛb mot nasa pɛ kel ɔ naba ààsa tɔ tak é? ");
INSERT INTO bkw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Djɛka bɛdjel ɛ bot esa eedi tɔ ebɛɛlɛ ɛ, nɛ yii di tɔ esaan bin ɛ. Deenek ɛ́ esonok djas aadi, dɛɛ étɛp'en. ");
INSERT INTO bkw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Haa kpaa-ghoŋ nɛ biyɔ, eFalizyɛ etɛɛ náá, bi ɛpetuud Zɛɛb nɛ endiyal kam e nadjeebe nɛ aghomkɔtɔ, zɛnɔɔ mɛwyee mɛ di ebɛaa tɔ bok ɛ. Da bi ɛ́ kapeeba ɛ́ epiki nɛ kwyɛl ɛ Zɛɛb. Ghuna, sa bɛ di egoka nɛ ɛwa lyem é tak ɛ́, yɛ ɛ́ yenek, ààpeeba bɛdhiiti kalik ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Haa kpaa-ghoŋ nɛ biyɔ, eFalizyɛ etɛɛ náá, bi kwyɛl ɛ́, mɛbhóó mɛ pɛ sok étɛp ɛtela mɛnyel tɔ mendjaa mɛ mendjaala mɛ eYuda, bi nɛ kwyɛl bi swosaa nɛ duu kɔ mɛbɛsɛɛ. ");
INSERT INTO bkw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Haa kpaa-ghoŋ nɛ biyɔ, etɛɛ náá, bi ɛ́ dáa mɛvit mɛ di ye moo ààkanyen ɛ. Mɛvit mɛ bot di kɛ kɔ tak ààgu ɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mot ngɔt tɔ bɛlyoel ɛ etsi e Zɛɛb zokazɛdji nyɛ náá: «Lyoel, dáa wɔ di elii deenek'enek, wɔ lee tin ɛ́ dɔɔ nɛ bisɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Kpaa-ghoŋ dɔɔ nɛ biyɔ, bɛlyoel ɛ etsi e Zɛɛb! Bi ɛpekɛl kɔ ekoŋ e bot mɛkɔm mɛ na dil-dil, da bi kadi ɛ́, ààkosɛɛb-sɛɛbak djin wat étɛp ɛkwyee bɛ é ɛbɛp dil-dil mɛkɔm mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Haa kpaa-ghoŋ nɛ nen, etɛɛ náá, bi ɛpesum mɛvit mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb, bɛngoolel ɛ mɛkpa ɛ Zɛɛb bɛbhaab bin nagó ɛ! ");
INSERT INTO bkw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Deenek, bi kwyɛl ɛlyaal ɛ náá, bi eemyaal embee esesɛɛ bɛbhaab bin, etɛɛ náá, bɛ naagó bɛngoolel ɛ mɛkpa ɛ Zɛɛb, ye ɛ́ biyɔ ɛ kadi esum mɛvit mɔɔ! ");
INSERT INTO bkw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kɔ ɛsu ɛ tak ɛ Zɛɛb tɔ etsoŋ bɛ, nake náá: “Mɛ waakyeed bɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb nɛ bot ɛ lwoma, bɛ waagó bɛdhiiti, da bɛ ɛ́ wa bɛdhiiti tɔ tsik mezuk.” ");
INSERT INTO bkw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kana ɛkus ɛ bɔs, bɛtɛ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb naadyeebagóaa, étɛp tak ɛ́ di náá, esesɛɛ binek djas kwyɛ kɔ elo e kɔkɔ bot ɛ di kɔ bɔs dwoo mos'ak. ");
INSERT INTO bkw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kana dwoo ɛsyee ɛ Abhɛl, kɛyaka nɛ yɛ Zakali, mot nagóaa pak mesa ebuwa, bɛ di eka ebuwa ɔ, nɛ Di na Dɛɛ ɛ Ghɛŋ, nɛ tsɛɛtsɛ mɛ lɛɛ bin ɛ́ náá, esesɛɛ binek djas kwyɛ kɔ elo e kɔkɔ bot ɛ di kɔ bɔs dwoo mos'ak. ");
INSERT INTO bkw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Haa kpaa-ghoŋ nɛ nen, biyɔ, bɛlyoel ɛ etsi e Zɛɛb, etɛɛ náá, bi eezediyal ze di etɔ́ nɛ bot pɛ daa Zɛɛb ɛ. Biyɔ bɛmet bi ààpakɛ é ze tak. Tin, bi ɛpela bot ɛ di ekwyɛl ɛdhaa é ze tak ɔ, ze.» ");
INSERT INTO bkw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dáa Yezu nawyis tɔ ndjaŋ'enek ɛ, eFalizyɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi moo tin nɛ mɛbhuk tɔ elyem. Bhii tak bɛ moo tin edji nyɛ bɛtɛ nɛ ekiya dum nɛ bɛtɛ nɛ etɛp. ");
INSERT INTO bkw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","É di'enek, bɛ nadi elóo nyɛ pɛ ɛko, da bwood nyɛ pɛ kyɛ étɛp bɛ neebela mɛkpa mɛ bɛ aapit nyɛ nɛ ye ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","É ghɛŋ tak, bot eezɛsɛɛga é di tak. Mɛbu mɛ bot sa náá, bɛdhiiti nyalel pak'ɔɔ. Tin, Yezu eezɛke nɛ bɛdjekel bɛ náá: «Ɛsok nɛ esonok djas, ye goka ɛ́ náá, bi kyee leviid eFalizyɛ. Ye kwyɛl ɛlyaal ɛ́, mɛfulu mɔɔ yii mɛdjhaaz pɛ ɛko bhimis pɛ si. ");
INSERT INTO bkw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Esesɛɛ djas di esyela ɛ, yɛ waawyis é gwyɛ, etɛp ee nadi tɔ sɔ ɛ, yɛ waaguaa nɛ bot djas. ");
INSERT INTO bkw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Étɛp tak ɛ́ di náá, etɛp djas bi aadi elii tɔ ghooghom ɛ, yɛ aadi egék é gwyɛ mwos dwoo. Sa bi nanyiiŋelaa tɔ ɛlɔ pɛ tɔ dhɛŋ ɛ, yɛ aadi ɛ́ moo tuuda kɔ emii e mendjaa.» ");
INSERT INTO bkw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Biyɔ bɛsɔ bam, mɛ lɛɛ bin ɛ́ náá, nàkaabka bot ɛ di egó tsik epuud ɔ, bhii tak, bɛ kadi ɛ́ ààsa dhiiti sonok. ");
INSERT INTO bkw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mɛ paakolyaal bin sa bot di egoka nɛ ɛkaab dhaa nyel ɛ. Bi goka nɛ kaab ɛ́ Zɛɛb, mot di náá, bhis ɛsyee, nyɛ ɛ́ nɛ ghwyil ɛkɛmwas bin tɔ du na kɔm-kɔm ɔ. Nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá, ye ɛ́ nyɛy ɛ bi di egoka nɛ ɛkaab! ");
INSERT INTO bkw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bot djas nɛ gu náá, bɔɔ enen etɛn dyeebabɔmsaa ɛ́ nɛ epata ebá. Kabela náá, ye tok nɛ sa Zɛɛb aadjisa é mis mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Deenek, bhoo elo bin ɛ́ elaŋa, sa mot ààdi nɛ bwoo, etɛɛ náá, é mis ɛ Zɛɛb, bi ɛ́ nɛ boo mɛtaŋ, dhaa enen!» ");
INSERT INTO bkw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mɛ lɛɛ bin ɛ́ náá, mot aamyam popoopwon é mis mɛ bot djas náá, nyɛ ɛ́ djekel'am ɔ, Sɛɛŋɛlɛ Mɔn Mot pe ɛ́ waamyam nyɛ é mis mɛ efofop ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tin, Mot ɛ kɛla popoopwon é mis mɛ bot djas náá, nyɛ tok djekel'am ɔɔ, mam pe, mɛ waakɛla nyɛ é mis mɛ efofop ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yɛ bɛ náá, dhiiti mot eelóo mbee ɛkpa nɛ Sɛɛŋɛlɛ Mɔn Mot ɔɔ, mot tak ɛ́ nɛ ghwyil ɛbela ɛpelak. Yɛ kabɛ náá, mot eebyasal Sisim na Dɛɛ ɔɔ, yenɔk aanàkwaabela ɛpelak. ");
INSERT INTO bkw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«É sok bɛ aatɔ́ nɛ nen sok bhwoob bɛtetɛp, tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ pɛ daa ekukuma nɛ bɛmɛkoozi ɛ, sa mot ààbem ba dum nɛ dáa bi aataŋal nɛ mɛkpa mɛ bi aalóo ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Etɛɛ náá, é di'enek wat Sisim na Dɛɛ waalyo bin dáa bi di egoka nɛ ɛtaŋal ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mot ngɔt tɔ ɛdhuu ɛ bot ɛ nadi tin ɔ zokazɛke nɛ Yezu náá: «Lyoel! Lɛɛa nɛ mɔn nyaag'am náá, bis kaa esa ee sɛɛg'es nalik ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yezu eezɛbɔɔza nɛ nɛ náá: «Mɔɔ sɔ'am, ɛzɛ nɛɛg mɛ tetɛp dum nɛ etɛp bin, dɔɔ nɛ étɛp ɛkaa esa ee sɛɛg'en nalik bin nɛ yɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bhii tak nyɛ eezɛke nɛ nɔɔ náá: «Bi ɛ́ kobaka nɛ dɔɔ mɛvu, etɛɛ náá, tsik mot tok étɛp mɛvu. Ye nakoozobɛ náá, nyɛ ɛ́ kum mot.» ");
INSERT INTO bkw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tin, nyɛ ɛ́ boozɛlɛɛ bɛ kana yak: «Dhiiti kum mot nadi ɛ́ nɛ mɛdhik mɛ nadi sa náá, nyɛ gó bhek ɛbuɛpe ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nyɛ moo tin é siiza. Nyɛy náá: “Mɛ sa dáa etɛɛ náá, mɛ tok nɛ bɛtɛ nɛ e di étɛp mɛ neekwom edee mɛ gó tɔ pyeeb'am ɛ?” ");
INSERT INTO bkw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bhii tak nyɛ eezɛke náá: “Beea dáa mɛ aasa ɛ: mɛ waawaaz etaa bam, da mɛ ɛ́ lóo bɛ na bɔk-bɔk. Tin, da mɛ ɛ́ wa edee bam nɛ mɛvu mam djas.” ");
INSERT INTO bkw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bhii tak mɛ ka ke nɛ nyel'am ɛ náá: “Mɔɔ sɔam, e di deenek, wɔ moo ɛ́ nɛ mɛvu ɛbuɛpe, yii aadjala étɛp membu ɛbuɛpe ɛ. Wɔ ɛ́ nɛ ghwyil ɛka wala. Dɛa edee nɛ mɛdii. Dia tɔ mɛ myaala.” ");
INSERT INTO bkw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tin, Zɛɛb zokazɛke nɛ nɛ: “Wɔy mot di ààbɛ nɛ lyem'aak! E pum'ak mos mɛ ɛpenɔɔ tsikɔ. Deenek, esesɛɛ ee wɔ kwom ɛ, ɛzɛ aabe yɛ?”» ");
INSERT INTO bkw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yezu eebaazɛke náá: «Yɛ aadi ɛ́, deenek dum nɛ bot ɛ di saa mɛvu mɛ mɛnyel mɔɔ ɛmet. Da é mis mɛ Zɛɛb bɛ ɛ́ kadi ɛ, ààbɛ bɛkuma ɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yezu zɛke bhii tak nɛ bɛdjekel náá: «Étɛp tak ɛ́ mɛ di ke náá: Nàbemka ba étɛp edee bi di nɛ gwyes tak étɛp tsiken ɛ, nɛ étɛp eduuba ekaad ee bi di egoka nɛ ɛbɔt ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Etɛɛ náá, tsik eedhaa edee nɛ mɛnyok. Nyel eedhaa ekaad nɛ boo mɛtaŋ. ");
INSERT INTO bkw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Beeka enen ee di djóoaa kɔlbo enek: Bɛ ààbɛ epyeeb, ààbɔ́k edee ee di wum tɔ epyeeb ɛ. Bɛ tok nɛ edi ɛkwom edee tɔ bhwaa nɛ kɔ etaa. Dhi tin, Zɛɛb é dee bɛ! Biyɔ, bi dhaa enen nɛ boo mɛtaŋ. ");
INSERT INTO bkw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛzɛ pak'en di nɛ ghwyil ɛbil ba mɛlu kɔ mɛlu mɛ tsik'ɛ nɛ esiiza bɛ? ");
INSERT INTO bkw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","«Yɛ bɛ náá, bi tok nɛ ghwyil ɛkwak ɛsa ba sa dem ɔ, étɛp yé bi di bem ba kɔ ɛsu ɛ yii ka likenek? ");
INSERT INTO bkw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pookogwyákeka dáa mɛzɛm di wyee tɔ mɛdhik ɛ: Bɛ ààsa mɛsa. Bɛ ààlat ekaad. Tin, ye goka ɛ́, mɛ lɛɛ bin náá, ye nakoobɛ Salomɔŋ nɛ bɛtɛ nɛ duu, nyɛ nabɛ ɛ́ ààbɛ nɛ mbɛɛ kaad nanyɔ dhaa wat tɔ kɔkɔ mɛzɛm menek. ");
INSERT INTO bkw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kwyii Zɛɛb di e bet eka e mɛdhik, da djɛmɛn ye ɛ́ nɔŋaa, dikaa tɔ du, gwyaasa nɛ biyɔ! Zɛɛb tok nɛ ghwyil ɛsa deenek dum nɛ nen e? Dáa bi di náá, bi tok nɛ boo ɛmyaal nɛ nɛ ɛ! ");
INSERT INTO bkw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nà dhekeka mɛnyel min étɛp ɛsesaa edee nɛ mɛdii mɛ bi aadɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ye ɛ́ bot ɛ bɔs'ak ɛ di pɛɛ Zɛɛb ɔ, di nɛ egwyes e esaala binek. Guka náá, Sɛɛg'en nɛ gu egwyes bin. ");
INSERT INTO bkw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pookosaaka ɛsok Ɛyoŋ ɛ Zɛɛb. Bhii tak, nyɛ waadjɛ bin yii ka lik ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Mɔɔ ɛsaa ɛ́ Zɛɛb, nàbem ba, etɛɛ náá, Sɛɛg'en kwyɛl ɛ́, nyɛ needjɛ bin Ɛyoŋ ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bɔmsaka ekum bin. Sa bi aabela ɛ, bi kaa-kaŋ ɛ́ nɛ bɛdjel ɛ bot. Saka mengwyɛ mɛ epata ee di yɛ ààgwyɛ ɛ́. Kwomka ekum bin pɛ dáa Zɛɛb. Penek, bot ɛ djii aanàkwaani, kɛdjii yɛ. Bɛsɛs aanàkwaagɔɔ yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bi sa deenek etɛɛ náá, e di mot di kwom esa bɛ ɛ, lyemɛ di ɛ́ tak.» ");
INSERT INTO bkw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Dika nɛ ekaad e mɛsa min, nɛ elambi etuuba. ");
INSERT INTO bkw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Dika dáa bot ɛ mɛsa di bwood kukuma yɔbɔ ɔ, etɛɛ náá, esok nyɛ aabula kɛbeeb moma ɛ, nyɛ diig ɛbɛ ɛ ndjaŋ ɔ, bɛ neeleedii. ");
INSERT INTO bkw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mɛnyɔ nɛ bot ɛ mɛsa aadi é nyan ɛ mis ɔ, é ghɛŋ kukuma yɔbɔ aatuula ɛ. Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: kukuma nyɛ ɛmet ɛ́ waabɔt ekaad e mɛsa mɛ, da bhii tak nyɛ ɛ́ dil bɛ kɔ mesa, da nyɛ ɛ́ djɛ bɛ edee. ");
INSERT INTO bkw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nyɛ ɛ́ bula kuku ɛgha ɛ pum ɔ, nɛghu kabɛ pum eezeliig ɔ, da nyɛ ɛ́ bela bɛ e mis membek ɔ, mɛnyɔ nɛ nɔɔ ɛbuɛpe! ");
INSERT INTO bkw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Gwakeka sa mɛ di lɛɛ ɛ: Yɛ bɛ náá, nakuma ndjaŋ ɛpedi ɛ́ di é gu ɛwala ɛ pum mot djii aazyɛ, zɛdjii tɔ ndjaŋ'ɛ ɔ, pe nyɛ aanàkwaabet nyɛ, nyɛ zɛni tɔ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Biyɔ pe nyanka mis, etɛɛ náá, Sɛɛŋɛlɛ Mɔn Mot aatuula e ɛwala bi aadi ààbwood nyɛ ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tin, Pyɛɛd eezɛdji nyɛ náá: «Ghɛŋ, wɔ lɛɛ kana yak ɛ́, étɛp bisɔ bɛ ɛmet “ohoo” étɛp bot djas?» ");
INSERT INTO bkw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wɔ gwaa Ghɛŋ zɛbɔɔza nɛ nɛ náá: «Nwyak mot-mɛsa di sosoob nɛ etsoŋ ee? Beea kukuma ngɔt zokazɛlɛɛ mot-mɛsa mɛ náá, nyɛ baal ndjaŋ'ɛ. Bhii tak, da nyɛ ɛ́ djɛ bɛdhiiti bot ɛ mɛsa yɔbɔ edee e tɛtɛ ɛwala. ");
INSERT INTO bkw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mɛnyɔ nɛ mot-mɛsa menɔk, kukuma ye ɛ́ bula zɛbela nyɛ, nyɛy é sa mɛsa mɛ tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ, náá: Kukuma ɛ waadjɛ mot-mɛsa menɔk esa bɛ djas, nyɛ baal. ");
INSERT INTO bkw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mot-mɛsa menɔk ɛ ka ke náá: “Kukuma aanàkwaaleebula.” Bhii tak nyɛ moo duma botom nɛ boa ɛ di sa mɛsa tin ɔ nɛ mɛbin e mɛnyel. Di nyɛ di dɛ edee nɛ kuka yɛ mɛnyok. ");
INSERT INTO bkw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tin, kukuma yɛ aabula ɛ́, e dwoo nɛ ɛwala mot-mɛsa menɔk aadi pel náá, nyɛ aanàkwaazyɛ dwoo tak ɛ. Nyɛ waasɔ mot-mɛsa menɔk, da nyɛ ɛ́ lyaal nyɛ kyet dáa bot ɛ di ààdum koŋ nɛ Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Mot-mɛsa mɛ di gu sa lyem kukuma yɛ di kwyɛl ɔ, da nyɛ ɛ́ kadi ɛ́, ààsa ɔ, nyɛ waabiaa nɛ ghwyɛs ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yɛ kabɛ náá, mot di ààgu ɛkwosak ɛ kukuma yɛ di sa esonok binek ɔ, yɛ mɛbin aadi ɛ́, ba bim eghwyɛs. Mot ɛ djɛaa bɛtɛ nɛ esa ɔ, pɛ dáa mot tak yɛ aabaawaabaa ɛ́ ɛbuɛpe; pɛ dáa mot bɛ aakwom daa lɛ ɛbuɛpe ɔ, pɛ daa lɛ, bɛ aabaazowaab ɛ ɛbuɛpe kɛdhaa dhaŋaa bim bɛ nakwom ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Mɛ nazyɛ, zɛtuub du kɔ bɔs. Mɛ kwyɛl ɛ́ náá, pe du tak kaa di moo tuuba! ");
INSERT INTO bkw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ye goka ɛ́ náá, mɛ duwa kɔkɔ mbi ɛduwa Zɛɛb sis. Mɛ ɛpebwood ɛduwa Zɛɛb tak nɛ lyem pɛ ɛko, lyem'am ɛ́ pɛ ɛko kɛkum dwoo ɛduwa Zɛɛb ɛlenek aazyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","«Bi gek ɛ́ náá, mɛ nazyɛ kɔ bɔs ɛ́, étɛp egwyem nɛ ɛgwakel tɔ bot e? Ààbɛ! Mɛ lɛɛ bin ɛ náá: mɛ nazyɛ, zɛbɛk nɛ wa ɛghuub pak bot. ");
INSERT INTO bkw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kana dwoo pan mos'ak, bot ɛtɛn di tɔ mɛbyel mɛ wat ɔ, waabɛka. Bot ɛlɛl waapek bot ɛbá. Bot ɛbá waawaya nɛ bak bɛlɛl. ");
INSERT INTO bkw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sɛɛg ɛ waabhina mɔn'ɛ; mɔn bhina sɛɛg. Nyɛɛg bhina mɔn'ɛ mɔɔ moma; mɔn mɔɔ moma bhina nyɛɛg. Bhɛɛbel moma bhina nakɔla; nakɔla bhina bhɛɛbel moma.» ");
INSERT INTO bkw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yezu nadi baake nɛ mɛdhuu mɛ bot náá: «Esok bi di baabee eguud é kɛghɛɛ pɛ ɛbil ɛ dwoo ɛ, e di tak wat, bi dyeebake ɛ náá: “Bhi ɛ waanee.” Ye ɛ́ waabataswaala ɛ nee. ");
INSERT INTO bkw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Yɛ ka bɛ, esok bi bee pup ɛpekɛ ghɛɛ pɛ kyɛ bɔs ɛ, bi dyeebake ɛ náá: “Gwyes ɛ waakas mos ɛbuɛpe.” Yɛ aabataswaala deenek. ");
INSERT INTO bkw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si, bi ɛ́ nɛ ghwyil ɛsiiza ɛnyɔɛpe endem di kɔ bɔs ɛ, nɛ ekyee e bɔs nɛ gwoo. Ha, étɛp yé bi di ààgu sa ɛwala mena dik'ak, di ekwyɛl ɛlɛɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Étɛp yé biyɔ bɛ ɛmet di ààgu ɛpɛ́ɛ náá: “Yak ɛ́ mbɛɛ sonok”? ");
INSERT INTO bkw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Yɛ bɛ náá, wɔ ɛpekɛ taŋal bi nɛ mot ɔ, bi nɛ mot tak ɛ́ di ɛdjaad ze wat ɔ, étɛp ɛtɔ́ pɛ baakɛ pɛ́ɛ bin ɔ, sa mɛghaaz bi gwakel e di bi dinaa e ze'enek ɛsok. Deenek wɔ waalu náá, mot bi nɛ nɛ di nɛ tɛp ɔ nàdul wɔ sok bhwoob bɛtetɛp. Bhii tak bɛtetɛp eezɛdjɛ wɔ e mɛmbɔ mɛ esodja, da wɔ ɛ́ mɛtaa e mbok. ");
INSERT INTO bkw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mɛ lɛɛ wɔ náá, wɔ aanàkwaawyis tin, ààtuud sa mot wɔ nabe ɛ, dɔɔ nɛ bɛna-tseetsa.» ");
INSERT INTO bkw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Eghɛŋ tak, bɛdhiiti bot zokazyɛ, zɛlɛɛ Yezu dáa mɛkoozi Pilat nagó bot ɛ Ghalile esok bɛ nadi djɛ Zɛɛb ebuwa e bɛtit ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yezu ɛ́ boobɔɔza nɛ nɔɔ náá: «Bi gek bilak ɛ́ náá, bot ɛ Ghalile binɔk góaa deenek ɛ́, etɛɛ náá, bɛ nadi ɛ́ bot ɛ mesyem, dhaa bot ɛ Ghalile djas e? Ààbɛ! ");
INSERT INTO bkw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Betka, mɛ lɛɛ bin náá: Bi ɛ di ààliig elyem ɔ, biyɔ djas pe ɛ waagwyɛ dáa bot binɔk. ");
INSERT INTO bkw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tin, bot kam nɛ etɛn nɛ bɛlɛl vyɛɛgvyɛɛg ndjaa Silowe nagó, esok ye nabik ɛ, bi ke bilak ɛ náá: Bɛ nadi egu ɛsuk ɛ tɛp dhaa bot ɛ Yeluzalɛm e? Ààbɛ! ");
INSERT INTO bkw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Betka, mɛ lɛɛ bin náá: Bi ɛ di ààliig elyem ɔ, biyɔ djas pe ɛ waagwyɛ dáa bot binɔk.» ");
INSERT INTO bkw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bhii tak Yezu eezɛlii nɛ nɔɔ tɔ kana náá: «Mot ngɔt nadi ɛ́, nɛ le fiigh tɔ pyeeb vin yɛ, nyɛ zokazɛsaa ɛbɔ́k ɛ bhum, nyɛ kadi ɛ́, ààbela sonok. ");
INSERT INTO bkw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nyɛ eezɛke nɛ mot di baal pyeeb vin tak ɔ: “Beea, e moo mos ɛ́, membu melɛl mɛ di zyɛ, zɛsaa ɛbɔ́k ɛ bhum le fiigh'ak. Mɛ ààbela. Tsaala yɛ, etɛɛ náá, yɛ ààgoka nɛ ɛnɔɔ yenek boo di tin gwyes.” ");
INSERT INTO bkw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tin, mot di baal pyeeb vin tak e zɛbɔɔza nɛ nɛ náá: “Ghɛŋ, pookobaabet nyɛ mbu yak. Mɛ waapu guk e mengwoob. Bhii tak da mɛ ɛ́ wa eka nɛ ezeeza, ye needjɛ nyɛ ghwyil ɛsam. ");
INSERT INTO bkw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Deenek ye ɛ́ nɛ ghwyil ɛwum e mbu di zyɛ yenek. Nyɛ di, ààka wum ɔ, da wɔ ɛ́ ka tsaal yɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dhiiti dwoo saba, Yezu nadi lyo bot mɛkpa ɛ Zɛɛb tɔ ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dhiiti mbel moma nadi ɛ́, tɔ ndjaa tak. Kana membu kam nɛ etɛn nɛ elɛl ye nabɛ ɛ́ dhiiti mbee sisim naazenyak nyɛ koŋ. Nyɛ nabɛ ɛ́ ààbɛ nɛ ghwyil ɛsek ɛ koŋɛ. ");
INSERT INTO bkw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dáa Yezu nabee moma tak ɛ, nyɛ eezɛdjóo nyɛ. Bhii tak nyɛ eezɛke nɛ nɛ náá: «Wɔ ɛ́ pɛkel tɔ ɛbɛ́ ɛ lɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nyɛ eezɛkɛl mɛmbɔ kɔ lɛ, e di tak wat koŋ eezɛsekel nyɛ. Moma tak moo tin é duwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tin, ye nabɛ ɛ́ kukuma ndjaa mendjaala mɛ eYuda naadyeebakpaa lyem dum nɛ dáa Yezu natsik mot dwoo saba ɛ. Kukuma tak ɛ́ booke nɛ ɛdhuu ɛ bot náá: «Bot ɛ́ nɛ mɛlu mɛtɛn nɛ wat bot di sa mɛsa ɛ. Dhaaka zɛtsikaa ɛ́, e mɛlu menek, ààkabɛ dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ghɛŋ zokazɛbɔɔza nɛ nɛ náá: «Bi ɛ́ bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si. Dwoo saba mot nɛ mot aadi etii ngɔmbɛ nɛghu an yɛ étɛp ɛkɛdjɛ bɛ edee nɛ mɛdii, etsal é? ");
INSERT INTO bkw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Moma yak ɛ́ ngɔt tɔ bɛdha ɛ Abalaam. Tin, kabela náá, Satan naazelookɔl nyɛ. Nyɛ moo mos ɛ́ nɛ membu kam nɛ etɛn nɛ elɛl (18). Yɛ ààgoka náá, nyɛ tsikaa e dwoo saba?» ");
INSERT INTO bkw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bɔɔza Yezu nabɔɔza deenek ɛ, ye nasa mot ɛ nadi bhina nyɛ ɔ, boo sen. Yɛ kabɛ mɛdhuu mɛ bot djas nadi tinaak ɔ, bɔɔ bɛ naadyeebamyaala nɛ esesɛɛ e duu djas nasɛɛ tin ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yezu eebaazɛke náá: «Ɛyoŋ ɛ Zɛɛb ko kɔa nɛ yak mbi sa? Mɛ goka nɛ ɛgek yɛ nɛ yaa sonok? ");
INSERT INTO bkw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ɛyoŋ ɛ Zɛɛb ɛ́ dáa bhek na sikɛ-sikɛ di ee djóoaa mutaad ɛ. É sok mot di nɔɔ yɛ kɛbɛ yɛ tɔ bok ɛ, tin, bhek ɛpekwyil, wyee zyɛ boo le, enen lóo mɛk mɔɔ kɔ elɛɛ e tak.» ");
INSERT INTO bkw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yezu zokabaazɛke nɛ nɔɔ náá: «Mɛ koogek bin Ɛyoŋ ɛ Zɛɛb nɛ yak sonok? ");
INSERT INTO bkw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ɛyoŋ ɛ Zɛɛb nɔŋel ɛ́ nɛ met moma di wa tɔ boo ɛdham ɛ tsim nyɛ di pul étɛp nyɛ neesa mapa nɛ yɛ. Ba ɛwala bhii tak, tsim'enek djas aadi ɛ́, eezeghamta.» ");
INSERT INTO bkw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yezu nadi é dhaa eghaada nɛ kɔ mɛl é lyo bot mɛkpa ɛ Zɛɛb, nyɛ eetɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dhiiti mot eezɛdji nyɛ náá: «Ghɛŋ, Zɛɛb aazo tsik ɛ́ ba bim bot ee?» Yezu zɛbɔɔza náá: ");
INSERT INTO bkw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Lyelka ghwyil étɛp bi neeni tɔ ɛbɛ ɛ ndjaa na maad-maad, etɛɛ náá, mɛ lɛɛ bin ɛ́ tsɛɛtsɛ náá, bot ɛbuɛpe ɛ waagek ɛni penek, bɛ aanàkwaakwak ɛni. ");
INSERT INTO bkw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Esok kukuma ndjaa aawyɛl ɛ, nyɛ waakɔl ɛbɛ ɛ ndjaa nɛ ɛngoŋ. Tin, biyɔ, bi ɛ waalik pɛ kel. Bhii tak, bi ɛ waazuk e diig ɛbɛ ɛ ndjaa, é ke náá: “Ghɛŋ! Diia bis ndjaa!” Nyɛ ka bɔɔza nɛ nen ɛ náá: “Mɛ ààgu, pɛ bi dus ɛ!” ");
INSERT INTO bkw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Deenek bi aaka bɔɔza nɛ nɛ náá: “Mena naadɛka edee nɛ mɛdii e di wat. Wɔ nadi lyo mɛkpa ɛ Zɛɛb e egba e ghaada yis.” ");
INSERT INTO bkw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nyɛ aabaazoke nɛ nɔɔ náá: “Mɛ ààgu pɛ bi dus ɛ. Duska e mis mam, biyɔ djas, bot ɛ di sa embee esa ɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ye ɛ́ deenek ɛ bi aadje mɛgwyɛ, nɛ ɛkwaal ɛ mɛtsok, etɛɛ náá, bi ɛ waabee Abalaam, Izak, Zakɔɔb, zɛnɔɔ bɛngoolel ɛ mɛkpa ɛ Zɛɛb penek tɔ Ɛyoŋ ɛ Zɛɛb. Yɛ kabɛ biyɔ ɔ, bi aadi ɛ́ mwasaa pɛ kel. ");
INSERT INTO bkw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bot ɛ waadus pɛ ɛdjem ɛ dwoo nɛ pɛ ɛbil ɛ dwoo, bɛdhiiti dus pɛ kyɛ bɔs nɛ ɛko ɛ bɔs. Bɛ waazɛdisi kɔ mesa wat tɔ Ɛyoŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tin, guka náá, bɛtɛ nɛ bot ɛ di mos pɛ lɔɔg ɛbhis ɔ, bɛ aaswaala bot ɛ lɔɔg ɛsok, bot ɛ di mos e lɔɔg ɛsok ɔ bɛ aakaswaala bot ɛbhis.» ");
INSERT INTO bkw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Edi tak wat, bɛdhiiti eFalizyɛ eezɛzyɛ, zɛlɛɛ nyɛ náá: «Dusa kɔ dɛl ɛ les. Tɔ́a pɛ kyee sis, etɛɛ náá, mɛkoozi Elood ɛpesaa nyɛ neezuk wɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Tɔ́ka, kɛlɛɛ bɛbhɛk binɔk náá: “Mɛ ɛpesɔ mɛlyeeb, mɛ ɛpetsik membel dwoo mos nɛ djɛmɛn. Bɛɛgɛl ɛ́ mɛ aasilal mɛsa mam.” ");
INSERT INTO bkw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ye goka ɛ́ náá, mɛ kɛmos, djɛmɛn nɛ bɛɛgɛl, etɛɛ náá, yɛ àànyɔ náá, ngoolel-mɛkpa ɛ Zɛɛb gwyɛ ɛtsetaɛpe nɛ ghaada Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Yeluzalɛm! Yeluzalɛm! Wɔy mot di gó bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɔ, wɔy mot di gó bot ɛ Zɛɛb di dhis wɔ bak, nɛ mɛkok ɔ. E sok edhen mɛ di kwyɛl ɛsɛɛg bot ɛ di kɔ dɛl ɛ lɔ dáa nabwa-kuu di sɛɛg bɔɔ bɛ si mɛbhap mɛ ɛ, biyɔ ààkwyɛl! ");
INSERT INTO bkw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Deenek, gua náá, ndjaŋ'en ɛ waalik wum! Nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Bi aanàkabaabee mɛ, kana dwoo pan mos'ak, kɛyaka nɛ dwoo bi aake ɛ náá: “Zɛɛb sɛɛ mɛtel mɛ kɔ mot aazyɛ nɛ din ɛ Ghɛŋ ɔ!”» ");
INSERT INTO bkw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Dhiiti dwoo saba Yezu zokazɛtɔ́ pɛ dáa dhiiti kukuma eFalizyɛ ngɔt étɛp ɛkɛdɛ. Bot ɛ nadi é di tak moo tin «dhuuu» nɛ mis é nyel ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dhiiti mot eezɛtyaa tetel sok bhwoob'ɛ, mot tak nabɛ ɛ́, nyɛ eezebeyal nyel nɛ ɛbɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","É di'enek, Yezu zɛke nɛ bɛlyoel ɛ etsi e Zɛɛb nɛ eFalizyɛ náá: «Etsi bina nɛdjɛ mena ze étɛp ɛtsik ɛ bot dwoo saba?» ");
INSERT INTO bkw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bɛ moo tin «gwyem», ààbɔɔza. Bhii tak, Yezu eezɛmɛt mot ɛbɛ́ ɛlenɔk, nyɛ eezɛtsik nyɛ, bhii tak, nyɛ eezɛswaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nyɛ eezɛke nɛ nɔɔ náá: «Yɛ bɛ náá, ngɔt pak'en ɛ́ nɛ mɔn'ɛ, nɛghu ngɔmbɛ yɛ ges ɛ tɔ guk ɔ, nyɛ aanàkwaaleekɛ wyisal nyɛ kaab, ye nàkwyii zo di dwoo saba?» ");
INSERT INTO bkw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bɛ nabɛ ɛ́, ààbɛ nɛ ɛkpa ɛbɔɔza nɛ nɛ kiya tak. ");
INSERT INTO bkw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yezu eezɛbee dáa bot ɛ nadjóoaa ɔ, nadi esaa ɛ́, ɛdisi kɔ mɛbhóó mɛ di pɛ sok ɛ. Deenek nyɛ ɛ́ boozɛlɛɛ kana yak étɛp bot djas: ");
INSERT INTO bkw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Mot ɛ djóo wɔ e ɛbyoŋ ɛ ɛbá ɔ, sa wɔ ààsuu ɛdi kɔ mɛbhóó mɛ di pɛ sok ɛ, e kaab náá: nɛghu ye nabɛ ɛ́, bɛ eedjóo dhiiti dhil mot, dhaa wɔy ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","E kaab náá, mot djóo biyɔ bɛbá ɔ, ɛzɛkɛke nɛ nɔ náá: “Djɛa nyɛ di'ak.” Tin, sen-ɛ-sen, wɔ moo tin é sik, kɛsaa ɛkɛdisi kɔ boo ɛbhis. ");
INSERT INTO bkw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","E nyɔ ɛ́ náá, wɔ ɛ́ djóoaa e ɛbyoŋ ɔ, wɔ goka ɛ́ nɛ ɛdi ɛ́, kɔ boo di pɛ bhis ɛ, etɛɛ náá, esok nakuma ɛbyoŋ aatuula ɛ, nyɛ waake nɛ nɔ náá: “Sɔam, wyɛla, dha zɛdisi kɔ boo di pɛ sok ɛ.” Deenek ɛ waabela duu e mis mɛ bot ɛ bi nɛ bɛ nɔɔ aadi kɔ mesa ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mot ɛ di ekwyɛl ɛghɛɛ nyel nɛ ɛbet ɔɔ, nyɛ waasilaa, mot ɛ di esil nyel, nyɛ ɛ́ di ààbɛ nɛ ɛbet ɔɔ, nyɛ waabenaa.» ");
INSERT INTO bkw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tin, Yezu eezɛke nɛ mot nadjóo nyɛ ɔ náá: «Wɔ ɛ́ di edjɛ bot edee é mwos, nɛghu yii bikoko ɔ, sa wɔ ààdjóo bɔɔ bɛsɔ bɔ, bɔn nyoog, bot ɛ mɛbyel mɔ, bɛkuma ɛ bot bi nɛ bɛ nɔɔ di di e di wat ɔ, e kaab náá, bɛ ɛzɛkɛdjóo wɔ dhiiti dwoo. Tin, e kaab bɛ ɛzɛkɛbhulal yii wɔy nanyɛl ɛdjóo bɛ sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","E nyɔ ɛ́, wɔ djóo ɛbyoŋ ɔ, wɔ goka nɛ ɛdjóo ɛ́, bɛdjel ɛ bot, bɛna-etiyoŋ, eboka, nɛ bɛ na edhim. ");
INSERT INTO bkw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mɛnyɔ nɛ nɔ e di'enek, etɛɛ náá, bɛ tok nɛ ghwyil ɛbulal wɔ yɛ ɛ. Zɛɛb ɛ́ waabulal wɔ yɛ é ghɛŋ bot ɛ epiki aagom tɔ ɛsyee ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bhis bɛ nazegwak etɛp binek djas ɛ, mot ngɔt pak bot ɛ nadi é dɛ bɛ nɛ Yezu kɔ mesa ɔ zokake náá: «Mɛnyɔ nɛ mot aadɛ edee tɔ Ɛyoŋ ɛ Zɛɛb ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yezu eezɛlɛɛ nyɛ kana yak: «Dhiiti mot naazɛdjóo ɛbyoŋ. Nyɛ eezɛdjóo bot ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Esok ɛwala ɛdɛ edee nadjala ɛ, nyɛ eezɛlwom mot-mɛsa mɛ, nyɛ kɛ ɛdjóo bot, mot-mɛsa eezɛke nɛ nɔɔ náá: “Dha dɛka, etɛɛ náá, edee eezebee.” ");
INSERT INTO bkw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Tin, é ɛwala nakoobela étɛp dek ɛ, bot ɛ nadjóoaa ɔ, moo tin, mot nɛ mot é djɛ yɛ gham ɛpeeba. Mot ɛsok eezɛke nɛ mot-mɛsa náá: “Mɛ eebɔm pyeeb na bes. E goka, mɛ tɔ́, kɛ ɛbee yɛ. Pela mɛ, mɔn nyɛɛg.” ");
INSERT INTO bkw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nwyak mot náá: “Ye nabɛ ɛ́, mɛ eebɔm engɔmbɛ kam: Edjas e tɛn, nɛ eswooz e tɛn. Mɛ pookokɛgwyaala mɛghwyil mɔɔ. Pela mɛ, mɔn nyɛɛg.” ");
INSERT INTO bkw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nwyak tak zɛzyɛ yɛ. Nyɛy náá: “Mɛ aloo nɛ beeb ghɔɔdam. Étɛp tak ɛ́ di náá, mɛ tok nɛ ghwyil ɛtɔ́.” ");
INSERT INTO bkw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mot mɛsa menɔk eezɛsik pɛ dáa kukuma yɛ, kɛlɛɛ nyɛ dáa bot binɔk djas lɛɛ ɛ. Nakuma ndjaŋ eezɛkpaa lyem ɛlyelɛpe. Nyɛ ɛ́ booke nɛ mot-mɛsa mɛ náá: “Lela, Tɔ́a kɔ mɛbɛsɛɛ mɛ dɛl nɛ kɔ egba. Tɔ́a, kɛdjóo bɛdjel ɛ bot, eboka e bot, bɛ na edjam, nɛ bɛ na edhim. Dha mɛ nɛ nɔɔ wak.” ");
INSERT INTO bkw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bhii tak, mot-mɛsa eezɛlɛɛ nɛ kukuma yɛ náá: “Ghɛŋ, sa wɔ lwom náá, mɛ sa ɛ, eezesael. Ka bela ɛ náá, e di dinaa tak tɔ ndjaa.” ");
INSERT INTO bkw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tin, kukuma eezɛke nɛ mot-mɛsa mɛ náá: “Tɔ́a egba nɛ egba, nɛ kɔ bɔɔ mɛl pɛ ze epyeeb. Mot nɛ mot wɔ aaboma nɛ nɛ ɔ, besela nyɛ, nyɛ zyɛ. Etɛɛ náá, mɛ kwyɛl ɛ́, ndjaŋ'am lwood.” ");
INSERT INTO bkw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nɛ tsɛɛtsɛ mɛ lɛɛ bin ɛ náá: “Tɔ bot djas mɛ nadjóo sok ɔ, e tok nɛ mot aadɛ edee e ɛbyoŋ ɛ lam!”» ");
INSERT INTO bkw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zukamwaa nɛ mot nadi ekɛ lɔɔg wat bɛ nɛ Yezu. Yezu zokazɛliig mis. Bhii tak, nyɛ eezɛke nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Mot ɛ kwyɛl ɛdu mɛ ɔ, ye goka ɛ́ nyɛ byen sɛɛg nɛ nyɛɛg, myɛl nɛ bɔn, bɔn nyɛɛg nɛ bɛkɛl. Nyɛ goka ɛ́ nɛ ɛbyen-byenaa tsik'ɛ ɛmet. Yɛ di ààdi deenek ɔ, nyɛ aanàkwaakwak ɛdi djekelam. ");
INSERT INTO bkw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mot ɛ di ààbɛp mɛlaaba mɛ, da bhii tak nyɛ ɛ́ du mɛ ɔ, yenɔk tok nɛ ghwyil ɛdi djekelam. ");
INSERT INTO bkw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mot ngɔt pak'en ɛ kwyɛl ɛsum boo ndjaa na vyɛɛgvyɛɛg ɔ, ye goka ɛ́ nyɛ pookodisi, étɛp ɛval nɛghu mɛtaŋ mɛ nyɛ goka nɛ ɛwyisal étɛp ɛsum ndjaa tak ɛ, waadjala. ");
INSERT INTO bkw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","E kaab náá, nyɛ ɛ́ zɛkɛkan mɛsa, da nyɛ ɛ́ sik e ze. Tin, ekpaa-goŋ ɛ bee deenek ɔ, bɛ ɛzɛkɛgɔ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Bot neekeke náá: “Mot tak eekan ɛsum ndjaa ɛnyɔɛpe. Nyɛ ààpakakwak ɛsilal zumal.” ");
INSERT INTO bkw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Ye ɛ́ tyee wat nɛ dhiiti mɛkoozi di kwyɛl ɛkɛ lumela dɛɛb, bɛ nɛ nwyak dhiiti mɛkoozi ɔ. Ye goka ɛ́ nyɛ pookodisi sok étɛp ɛdjek nɛghu, nɛ esodja bɛmil kam, nyɛ ɛ́ nɛ ghwyil ɛkwak ɛlumela dɛɛb nɛ sɔ mot zekɛ ghɛɛ nɛ esodja bɛmil mɛkam-mɛmbá ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yɛ bɛ náá, nyɛ aanàkwaakwak ɔ, nyɛ waakyeed engoola-ngoola nɛ mɛbhaadal pɛ daa sɔ mɛkoozi, nyɛ dinaa ɛtsetaɛpe étɛp ɛdji nyɛ sa nyɛ di kwyɛl ɛ, etɛɛ náá, egwyem needi pak'ɔɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Deenek bhii tak Yezu eebaazɛbil ɛkpa náá: «E tok nɛ mot ngɔt pak'en aakwak ɛdi djekelam, nyɛ di ààbet esa bɛ djas ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mɛsɔn ɛ́ mbɛɛ sonok. Yɛ bɛ náá, mɛsɔn moo ɛ́, ààkagwom ɔ, ye saa dáa étɛp ye neebaabula ɛgwomɛpe? ");
INSERT INTO bkw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yɛ aanàka baako val sonok, ye nàkwyii bɛ étɛp ɛkoobal ɛ bɔs nɛghu étɛp ɛmwas kɔ ɛkwyiid. Yenek kagoka ɛ́ nɛ ɛmwasaa-mwasak pɛ kel. Gwakeka nɛghu bi ɛ́ nɛ mɛlɔ mɛ ɛgwak ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bɛnɔŋel ɛ epata e lapo, bɛ nɛ bot ɛ mbee dék naazɛsesɛɛga e bhaaz ɛ Yezu étɛp ɛzɛ gwak nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","EFalizyɛ bɛ nɛ bɛghaŋ ɛ mɛkana mɛ etsi ɛ Zɛɛb nadi é so-sɔs pak'ɔɔ. Bɔɔ náá: «Ɛzaaba ɛ mot'ak ɛ́ dɔɔ nɛ embee bot. Nyɛ ɛpedɛ bɛ nɛ bɛ nɔɔ e di wat.» ");
INSERT INTO bkw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Deenek, Yezu ɛ́ boolɛɛ bɛ kana yak náá: ");
INSERT INTO bkw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Dhiiti motom pak'en ɛ di nɛ ebhata dhet ɔ, ngɔt ɛ wo ɔ, nyɛy kum ebhata ka bet dhiiti ebhata mɛkam-mɛtɛn nɛ ená nɛ ebhata etɛn nɛ ená lik ɔ, tɔ bal, kɛsaa yii wo ɔ saŋa, kɛbatabela nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yɛ bɛ, nyɛ eebela nyɛ ɔ, nyɛ waamyaala, da nyɛ ɛ́ ka kɛl nyɛ ɛ́, kɔ mɛbyak mɛ, ");
INSERT INTO bkw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bula pɛ dɛl, djóo bɛsɔ nɛ bɔn nyɛɛg, zɛlɛɛ bɛ náá: “Mɛ eebatabela bhata yam nawo ɔ. Dhaaka mena myaalaka.” ");
INSERT INTO bkw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ye ɛ́ tyɛ wat nɛ biyɔ pe. Mɛ lɛɛ bin náá: Yɛ waadi nɛ boo mɛmyaala tɔ gwoo étɛp mot mesyem ngɔt naliig elyem ɔ, dhaa bot mɛkam-mɛtɛn nɛ ená nɛ bot ɛtɛn nɛ ená epiki, di ààbɛ nɛ gwyes ɛliig elyem bɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Nɛghu, yɛ bɛ náá, dhiiti moma naadi nɛ epata kam yii ghwooz na boo mɛtaŋ, yɛ bɛ náá, wat eediib ɔ, nyɛ waatɔ́, kɛtuub lambi, da nyɛ ɛ́ kɛwaabal ndjaŋ'ɛ, bhii tak da nyɛ ɛ́ saa tityok-tityok nɛ lyem wat, batakɛ bela yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yɛ bɛ nyɛ eebela yɛ ɔ, nyɛ waadjóo bɛsɔ boa nɛ bot ɛ bɛ nɛ bɛ nɔɔ di di ɛlɛt mendjaa wat ɔ náá: “Mɛ eebatabela pata yam nadiib ɛ, dhaaka zɛmyaala nɛ nam sama.” ");
INSERT INTO bkw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ye ɛ́ tyɛ wat nɛ biyɔ pe. Mɛ lɛɛ bin náá: Efofop ɛ Zɛɛb ɛ waadi tɔ mɛmyaala étɛp mot mesyem ngɔt aaliig lyem ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yɛ Yezu ka baazɛke náá: «Dhiiti motom nadi ɛ́ nɛ bɔɔ botom ɛbá. ");
INSERT INTO bkw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yɛ ɛ́ dhyeeb tak kazyɛ, ke nɛ sɛɛg náá: “Saag'am, djɛ mɛ yam ɛkɛɛ lyak di náá, mɛ waaboobela ɛ́, nɛ djheed.” E di tak ɛ́, sɛɛg'ɔɔ nazɛkaa ekum bɛ, pak bɔɔ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ye zɛkpaa ba mɛlu bhii tak, ye ɛ́ dhyeeb ka zɛnɔɔ yɛ kyee náá, bɔmsa yɛ, nɔɔ epata e tak, tɔ́ nɛ yɛ pɛ dhiiti dik ɛtsetaɛpe. Penek, wɔ gwaa nyɛ kɛbɔya tɔ mɛdjemel, zɛsaab elyak bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Bhis nyɛ nakazesaab esa bɛ djas ɛ, boo pwom naazɛtuula pɛ dik tak. Nyɛ nakadi ɛ́, nyɛ moo tɔ edjel. ");
INSERT INTO bkw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nyɛ ɛ́ boozɛtɔ́, kɛni mɛsa pɛ dáa dhiiti mot dik tak. Mot'enɔk ɛ́ bookyeed nyɛ kɛbaal engulu tɔ pyeeb ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nyɛ nadi ɛ́, nɛ gwyes ɛdɛ bhum le kalubye engulu nadi é dedɛ ɛ, ye naka saa ɛ́, nɛ nyɛ ààbɛ nɛ mot djɛ nyɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","É di'enek, nyɛ moo tin “ziibilii” é siiza étɛp nyel'ɛ. Nyɛy náá: “Bot ɛ di sa mɛsa pɛ daa saag'am ɔ, djas ɛ lɔɔ ɛpedɛ edee kat, dhi mam eegwyɛ nɛ za wak. ");
INSERT INTO bkw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mɛ paakosik pɛ daa saag'am, kɛlɛɛ nyɛ náá: Saag'am ee! Mɛ naasa mesyem sok bhwoob ɛ Zɛɛb, baasa nɛ nɔ. ");
INSERT INTO bkw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mɛ ààpakabaagoka náá, mɛ djóoaa mɔn'ɔ. Nɔɔŋa mɛ tyee wat dáa bot ɛ mɛsa mɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nyɛ eezɛsik pɛ daa sɛɛg. «Dáa nyɛ nadi, nyɛ dinaa ba ɛtsetaɛpe nɛ ndjaŋ ɛ, sɛɛg eezɛbee mɔn, nyɛ ɛ́ boo gek nyɛ ghoŋ. Sɛɛg eezɛtɔ́ kaab, kɛbhoma nɛ nɛ, nyɛ eezɛbeedal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mɔn eezɛke nɛ sɛɛg náá: “Saag'am, mɛ nasa mesyem sok bhwoob ɛ Zɛɛb, baasa nɛ nɔ. Mɛ ààbaagoka náá, mɛ djóoaa mɔn'ɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wɔ gwaa sɛɛg zɛke nɛ bot ɛ mɛsa mɛ náá: “Lelka ɛzyɛ mɛ nɛ kaad na nyenyɔ-nyɔ. Betka nyɛ yɛ ɛ. Sɔmka nyɛ ghwooz e djin. Betka nyɛ mɛpapa. ");
INSERT INTO bkw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kɛ mɛtka mɔɔ ngɔmbɛ mena nawyel ɔ, da bi ɛ́ gó nyɛ, mena neesaka ɛbyoŋ, ");
INSERT INTO bkw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","etɛɛ náá, mɔn'am nadi ɛ́, nyɛ eezegwyɛ; nyɛ eegom. Nyɛ nadi ɛ́, nyɛ eewo; nyɛ eebatabelaa.” Mbɛɛ ɛbyoŋ ɛ́ boozɛkan. ");
INSERT INTO bkw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«Esok tak, mɔn mɛgwyak mɛ nadi ɛ́, pɛ epyeeb. Dáa nyɛ ka bula ɛ, nyɛ moo kunaa nɛ ndjaŋ ɛ, nyɛ ka gwak ɛ́ dhok ɛ tap, kul nɛ ghom, nɛ mɛbɔl. ");
INSERT INTO bkw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nyɛ eezɛdjóo dhiiti kwom, zɛdji nyɛ náá: “Yenek ɛ́ yaa?” ");
INSERT INTO bkw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ye ɛ́ kwomenɔk ka bɔɔza nɛ nɛ náá: “Boo-mot, dhyeebɔ eebula. E di tak ɛ, soog ɛ́ boogó mɔɔ ngɔmbɛ mena nawyelka ɔ, etɛɛ náá, mɔn eebula nyel ɛnyɔɛpe.” ");
INSERT INTO bkw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mɔn mɛgwyak ɛ́ boobela ɛbuk, nyɛ eezɛbyen ɛni-niaa tɔ ndjaa. Ye ɛ́ sɛɛg kawyis kɛdjaala nɛ nɛ étɛp nyɛ neeni tɔ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Wɔ gwaa mɔn zɛbɔɔza nɛ sɛɛg náá: “Gwaka, mɛ moo ɛ́ nɛ zukamwaa nɛ membu mɛ di sa wɔ mɛsa tyee kwom ɛ. Mɛ ààbyen dhiiti lwomelɔ wat. Wɔ bee ɔ, wɔ dinaa ààpaakodjɛ mɛ djɛak ba mɔɔ ngɔmbɛ étɛp mɛ neesa ɛbyoŋ, bis nɛ bɛsɔ bam. ");
INSERT INTO bkw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Beea, e di mɔn'ɔ nwyak ka bula ɔ, nyɛy mot naasaab elyak bɔ djas nɛ boa mɛzɔ ɔ, étɛp'ɛ, wɔ eebatalwom náá, bɛ gó nyɛ mɔɔ ngɔmbɛ mena nawyel ɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ye ɛ́ sɛɛg ka lɛɛ nyɛ náá: “Mɔn'am ee! Menabɛl ɛ́ di mɛlu djas. Mɛ bee ɛ́ náá, esa ee mɛ di nɛ yɛ djas ɛ, ye ɛ́ yɔ. ");
INSERT INTO bkw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mena goka ɛ́ nɛ ɛsa tɛtɛ ɛbyoŋ, da mena ɛ́ myaala, etɛɛ náá, dhyeebɔ nwyak nadi ɛ́, nyɛ eezegwyɛ; nyɛ eegom. Nyɛ nadi ɛ́, nyɛ eewo ze; mos nyɛ eebelaa.”» ");
INSERT INTO bkw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yezu eezɛke nɛ bɛdjekel bɛ náá: «Dhiiti kum mot nadi ɛ́, nɛ ndɔmbɛ. Bot eezɛlɛɛ kum mot'enɔk náá, ndɔmbɛ yɛ ɛpesaab nyɛ esa. ");
INSERT INTO bkw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kukuma yɛ eezɛdjóo nyɛ, bhii tak nyɛ eezɛke nɛ nɛ náá: “Mɛ ɛpedyeebagwak embee menduk dum nɛ din ɛ lɔ. Pokobaŋa mɛ dáa wɔ di baal esa bam ɛ, etɛɛ náá, wɔ aanàkabaadi ndɔmbɛ yam.” ");
INSERT INTO bkw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ndɔmbɛ eezɛke tɔ lyemɛ met náá: “Mɛ sa dáa, dáa di náá, kukuma yam moo zɛɛdɛk ɛbaalel ɛ esa bɛ e mɛmbɔ mam'aak. Mam ɛ́ di ààbɛ nɛ ghwyil mɛsa mɛ epyeeb bak. Ebeeak nɛ sa mam sen. ");
INSERT INTO bkw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mɛ nɛ gu dáa mɛ aasa étɛp bot neemyaal mɛ tɔ mendjaa mɔɔ bhis kukuma yam aadis mɛ e mɛsa ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tin, nyɛy zokazɛdjóo mot nɛ mot nadi kola kukuma yɛ sonok ɔ. Nyɛ eezɛke nɛ mot ɛsok náá: “Wɔ ɔ nɛ kola kukuma yam edhen?” ");
INSERT INTO bkw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nyɛ eezɛbɔɔza náá: “Etondo bɛmul mɛ bhum oliv dhet.” Ndɔmbɛ zɛke nɛ mot'enɔk náá: “Lela ɛdisi, ba mɛkana mɔ, kwyala tɔ tak mɛkam-mɛtɛn.” ");
INSERT INTO bkw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bhis yenɔk nyɛ eebaake nɛ nyaa tak náá: “Ha wɔy, wɔ ɛ́ nɛ kola kukuma yam edhen?” Mot tak eezɛbɔɔza náá: “Eghuudɛ mɛbhisa dhet”. Ndɔmbɛ zɛke nɛ mot'enɔk náá: “Lela ɛdisi, ba mɛkana mɔ. Kwyala mɛkam-mɛtɛn nɛ mɛkam-mɛlɛl.” ");
INSERT INTO bkw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tin, kukuma zokazɛduwal mbee ndɔmbɛ yenɔk dum nɛ mɛsa mɛ etsoŋ nyɛ sa nɛ bot étɛp nyɛ needi ààbyenaa bhis nyɛ aasɔaa é mɛsa ɛ. Etɛɛ náá, bot ɛ bɔs'ak nɛ gu ɛkwyeel pak'ɔɔ dhaa dhaŋaa bot ɛ di kɛ tɔ gwyɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yezu eebaazɛbil náá: «Deenek mam lɛɛ bin ɛ náá: Beyaka ɛsɔ nɛ mɛvu mɛ di kɔɔ bot kɔ bɔs'ak ɛ. Etɛɛ náá, e di mɛvu menek aadi náá, ye tokapɛ ɔ, Zɛɛb ɛ waamyaal náá, bi di tɔ ndjaŋ'ɛ di na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mot di sosoob tɔ esa ee dem ɔ, mot tak ɛ waadi pe sosoob tɔ eboo esa. Mot aadi ààdi sosoob tɔ esa ee dem ɔ, nyɛ aanàkwaadi sosoob tɔ eboo esonok. ");
INSERT INTO bkw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yɛ bɛ náá, bi nabɛ ààgu ɛdi sosoob ɔ nɛ dáa bi nadi é be mɛvu mɛ mɛkɔŋ di kɔ bɔs'ak ɔ, ɛzɛ aadi nɛ ɛbwaalel nɛ nen, da bɛ ɛ́ djɛ bin tɛtɛ mɛvu? ");
INSERT INTO bkw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yɛ bɛ náá, bi nabɛ ààgu ɛdi sosoob dum nɛ esa e bɔɔ bɛsɔ bin ɔ, ɛzɛ aadjɛ bin embɛɛ esa ee nazekoobela bin ye ɛ́? ");
INSERT INTO bkw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«E tok nɛ mot-mɛsa ngɔt aasa mɛsa mɛ ekukuma ebá. Deenek nyɛ waabhina ngɔt da nyɛ ɛ́ kwyɛl nwyak; nɛghu nyɛ waakɛ kwyɛl ɛsa mɛsa mɛ ngɔt, da nyɛ ɛ́ byen yii nwyak mot. Bi tok nɛ ghwyil ɛsa e di wat mɛsa mɛ Zɛɛb nɛ mɛsa mɛ epata.» ");
INSERT INTO bkw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","EFalizyɛ naagwak etɛp ee Yezu nadi lii ɛ djas. Bɛ ɛ́ boozɛni egɔ nyɛ etɛɛ náá, elyem bɔɔ naadyeebakwyɛl epata dhaa nyel. ");
INSERT INTO bkw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi ɛ́ bot ɛ di tela mɛnyel e mis mɛ bot náá, bi ɛ́ bot ɛ epiki. Guka náá, Zɛɛb nɛ gu ebhum elyem bin. Etɛɛ náá, esa ee bot di bee náá, ye ɛ́ eboo esonok ɛ, Zɛɛb bee ɛ náá, ye ɛ́ etɛp e gwyes e mis mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Ɛwala ɛ etsi ɛ Moiiz nɛ ekwyala e bɛngoolel ɛ mɛkpa ɛ Zɛɛb nabɔya, kɛsik é ghɛŋ ɛ Zaŋ nduuel-bot. Kana membu mɛ tak, Mbɛɛ Bhaadal Ɛyoŋ ɛ Zɛɛb ɛpelɛɛel, mot nɛ mot goka ɛ́ nyɛ sa yɛ mɛghaaz étɛp ɛbela di tɔ tak. ");
INSERT INTO bkw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ye nakoozobɛ náá, gwoo nɛ bɔs ɛ́ nɛ ghwyil ɛsi yɔbɔ, ààbɛ nɛ tɛp. Yɛ kabɛ mɛkpa mɛ etsi ɔ, yɛ aanàkwaakodisaa-disak ba mɔɔ ɛkyɛ wat tɔ tak. ");
INSERT INTO bkw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Motom djas aabyen myɛl, da nyɛ ɛ́ kɛba dhiiti moma sis ɔ, motom tak sa ɛ́ ɛzɔ. Tin, motom aaba moma nazepɛɛaa e ɛbá ɔ, sa pe ɛ́, ɛzɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ye nabɛ ɛ́ nɛ dhiiti mot ekum. Mot ekum tak nabe-bɔt ɛ́ mbɛɛ ekaad bɛna-eboo-mɛtaŋ. Nyɛ nadidi ɛ tɔ mbɛɛ wolo ndjaa nɛ tɔ mɛvu. Nyɛ de-dɛ ɛ́ mbɛɛ edee bɛkuma ɛ bot nɛ boo mɛtaŋ dáa bot ɛ di tɔ mɛbyoŋ ɛ mɛlu djas. ");
INSERT INTO bkw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sok ɛniel ɛ ndjaŋ'ɛ, ye nabɛ ɛ́ nɛ dhiiti djel mot nadi é dje-dja si tin ɔ. Din ɛ mot tak nabɛ ɛ́ Lazaad. Nyɛ nabɛ ɛ́ nɛ mɛpyoŋ “kpeeeŋ” e nyel djas. ");
INSERT INTO bkw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Djel mot'enɔk nabɛ ɛ́ nɛ gwyes ɛ dedɛ bɔɔ eghutu-ghutu edee nadi é kwyit e mesa mot ekum enɔk. Tin, bela náá, bɛbhyɛ nadi ezyɛ, zɛwyiiz mɛpyoŋ mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tin, djel mot eezɛkpaa nɛ mɛsyee, gwyɛ. Efofop zokazɛnɔɔ nyɛ, kɛnɛɛg nyɛ é bhaaz ɛ Abalaam. Mot ekum zokabaazɛgwyɛ yɛ, nyɛ zokadelaa. ");
INSERT INTO bkw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nyɛ nadi ezuk ɛbuɛpe kɔ dɛl ɛ bot ɛ nazegwyɛ ɔ. Nyɛ ɛ́ boo zɛben mis, nyɛ kabee nɛ ɛtseta ɛ́, Abalaam zɛnɔɔ Lazaad e bhaaz'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bhii tak nyɛ eezɛbootsim: “Tata Abalaam! Geka mɛ ghoŋ. Lwoma Lazaad nyɛ duu djin tɔ mɛdii, bhii tak da nyɛ ɛ́ zɛtɔlal mɛ ɛtɔ́ ɛ tak kɔ djem. Etɛɛ náá, mɛ ɛpezuk ɛbuɛpe nɛ mɛgoo mɛ du'ak.” ");
INSERT INTO bkw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tin, Abalaam eezɛbɔɔza nɛ nɛ náá: “Mɔn'am, taala náá, wɔ naabela bɛtɛ nɛ ekum esok wɔ nabɛ, wɔ dinaa nɛ tsik ɛ. Yɛ kabɛ Lazaad ɔ, nyɛ nabɛ ɛ́ mot mezuk. E di nyɛ di wak'ak, nyɛ ɛpebela yɛ mɛnyɔ. Yɛ kabɛ wɔy ɔ, wɔ moo ɛ́ tɔ mezuk. ");
INSERT INTO bkw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Baabela náá, ye ɛ́ nɛ boo guk na diidim pak'enaka. Deenek bot aakwyɛl ɛtsel, étɛp ɛzyɛ penek ɔ, nyɛ aanàkwak ɛtsaal dwoob. Baabela náá, bot aadi ee kwyɛl ɛdhaa, tɔ́ pɛ yii kyee ɔ, aanàkwaakwak pe.” ");
INSERT INTO bkw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mot ekum zokazɛke náá: “Tata, mɛ waab nɛ nɔ náá, wɔ kyeed Lazaad tɔ ndjaa saag'am, ");
INSERT INTO bkw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","penek, mɛ ɛ́ nɛ bɛdhyeeb ɛtɛn. Nyɛ kɛ ɛdul bɛ mɛlɔ e kaab náá, bɛ ɛzɛkɛzyɛ pɛ yak di mezuk.” ");
INSERT INTO bkw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abalaam eezɛbɔɔza nɛ nɛ náá: “Bɔɔ penek, bɛ ɛ́ nɛ etsi ɛ Moiiz nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb étɛp ɛdul ɛ bɛ mɛlɔ. Bɛ gwak mɛlyo mɔɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mot ekum zɛke náá: “Tata Abalaam, yenek djas aanàkwaadjala! E nyɔ ɛ́ náá, mot dus tɔ bot ɛ nazegwyɛ ɔ, da nyɛ ɛ́ kɛlii nɛ nɔ ɔɔ, tin ɛ́ bɛ aaswoola mɛfulu mɔɔ nɛ tsɛɛtsɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Deenek Abalaam eebaazɛke nɛ nɛ náá: “Bɛ ɛ́ di ààkwyɛl ɛgwak Moiiz nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɔ, bɛ aanàkwaakomyaal mot ye nàkoo zo di mot dus tɔ bot ɛ nazegwyɛ ɔ.”» ");
INSERT INTO bkw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yezu eezɛke nɛ bɛdjekel bɛ náá: «Ye ɛ́ tsɛɛtsɛ náá, yɛ waadi nɛ mɛbɛk mɛ di náá, mot aanàkwaagwoob ɛ, mɛbɛk mɛ tak ɛ waasa náá, bot sa mesyem. Tin, saabɛgɔs ɛ́ náá, ha kpaa-ghoŋ nɛ mot aaka mɛbɛk menek ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nɛ mbi mot deenek ye goka ɛ́ náá, bɛ tsel nyɛ boo ɛkok e tsuŋ, da bɛ ɛ́ lóo nyɛ tɔ boo dii mɛsɔn. Yɛ àànyɔ náá, nyɛ kwyesal ngɔt tɔ bɔɔ di dum koŋ nɛ nam ɔ tɔ mesyem. ");
INSERT INTO bkw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nyanka mis. «Mɔn nyoog ɛ syem nɛ nɔ ɔɔ, djóoa nyɛ, da wɔ ɛ́ dul nyɛ mɛlɔ nɛ lyem wat. Tin, nyɛ liig lyem ɔɔ, pela nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nyɛ sa wɔ ɛ́ embee esa dwoo wat esok etɛn nɛ ebá, nyɛ bubula esok djas, étɛp ɛzɛke nɛ nɔ náá: “Pela mɛ! Mɛ eegu ɛbiyo ɛ lam” ɔɔ, da wɔ ɛ́ pel nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bot ɛ lwoma eezɛke nɛ Ghɛŋ náá: «Bila bis ɛdum ɛ koŋ nɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Deenek, Ghɛŋ eezɛbɔɔza nɛ nɔɔ náá: «Bi ɛ́ pe di ɛ́ di, é dum ɛ koŋ nɛ nam ɛbuɛpe dáa mɔɔ ndu le mutaad ɔ, pe bi ɛ waake nɛ ɛtsok ɛlak náá: “Disa ekaŋal bɔ wak. Tɔ́a, kɛbɛ nyel'ɔ tɔ dii mɛsɔn”, nyɛ waasa sa ɛkwosak ɛ lɔ kwyɛl ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Djhooka, pookogek dáa: Wɔ di nɛ mot-mɛsa mɛ di bɛ wɔ epyeeb nɛghu ɛbaal ɛ wɔ ɛsaa ɛ etaŋ ɔ, esok wɔ di é bee mot tak é bula pɛ ndjaa bhis mɛsa ɛ, wɔ nɛ ke nɛ nɛ náá: “Lela ɛzyɛ zɛdi kɔ mesa wɔ needɛ ee”? Ààbɛ! ");
INSERT INTO bkw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mɛ bee ɛ́ náá, nyɛ waake nɛ nɛ náá: “Djaaba mɛ edee, bhii tak da wɔ ɛ́ kɛgwyia, da wɔ ɛ́ swoola ekaad. Bhii tak da wɔ ɛ́ zɛlaa mɛ edee, mɛ needɛ. Bhis mam aasilal ɛdɛ edee nɛ mɛdii ɛ, wɔy ɛ́ nɛ ghwyil ɛka dɛ yɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Nyɛ tok nɛ tɛp ɛghaapɛɛ mot-mɛsa mɛ etɛɛ náá, nyɛ eesa mɛsa mɛ kukuma yɛ lwom nyɛ ɛ́. Ye tok deenek ee? ");
INSERT INTO bkw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ye ɛ́ tyee wat nɛ biyɔ pe. Esok bi aadi náá, bi eezesa mɛsa mɛ bi lwomaa náá, bi sa ɛ, keka náá: “Bis tok vaŋ bot ɛ mɛsa. Bis zo sa ɛ́, yii lwoma náá, bis sa ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dáa Yezu nadi etɔ́ pɛ Yeluzalɛm ɛ, nyɛ nadhaŋ ɛ mbaka-mbaka é kpal pak kyee dɛl ɛ Samali nɛ Ghalile. ");
INSERT INTO bkw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dáa nyɛ natuula kɔ ɛbɛsɛɛ ɛ dɛl ɛ, wɔ gwaa bot ɛ ɛbɛ́ ɛ zezam kam zokazɛboma nɛ nɛ. Bɛ eezɛtyaa tetel ba ɛtsetaɛpe nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bɛ moo tin é tsim náá: «Hyee Yezu, Ghɛŋ! Geka bis ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dáa Yezu nabee bɛ ɛ, nyɛ ɛ́ booke nɛ nɔɔ náá: «Tɔ́ka kɛlyaal mɛnyel men pɛ daa bɛghaa-Zɛɛb.» Dáa bɛ nadi bɛ dinaa etɔ́-tɔ́ak ɛ, bɛ naazɛtsak. ");
INSERT INTO bkw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mot ngɔt pak'ɔɔ zokabula pɛ bhis, é ɛduwal ɛ Zɛɛb nɛ etsim. ");
INSERT INTO bkw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nyɛ eezɛduma sok bhwoob ɛ Yezu mɛboŋ si, nyɛ eezɛghaapɛɛ Yezu. Ye kabela ɛ́ náá, mot tak nabɛ ɛ́ mot dɛl Samali. ");
INSERT INTO bkw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yezu eezɛke náá: «Bɔɔ bot kam djas eetsak, etsal é? Haa bak bot bɛtɛn nɛ bɛná moo wo? ");
INSERT INTO bkw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ye tok nɛ mot ngɔt pak'ɔɔ taala ɛbula étɛp ɛzɛghaapɛɛ Zɛɛb, yɛ di ààbɛ ndjoŋ'ak nyɛ ɛmet ɔɔ?» ");
INSERT INTO bkw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bhii tak Yezu eezɛke nɛ nɛ náá: «Wyɛla, da wɔ ɛ́ nɔɔ nyel'ɔ tɔ́. Ɛmyaal ɛ lɔ eetsik wɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","EFalizyɛ zokazɛdji Yezu náá: «Ɛyoŋ ɛ Zɛɛb aazyɛ den?» Yezu eezɛbɔɔza nɛ nɔɔ náá: «Ɛyoŋ ɛ Zɛɛb aanàkwaazyɛ, mis mɛ bot djas é bee. ");
INSERT INTO bkw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Bot ɛ waake nɛ nen náá: “Beeka, ye ɛ́ wak,” nɛghu “Beeka yɛ di poon'enek!” E nyɔ ɛ́, bi gu náá, Ɛyoŋ ɛ Zɛɛb ɛ́ e di bi di'enek.» ");
INSERT INTO bkw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bhii tak nyɛ eezɛke nɛ bɛdjekel náá: «Ɛwala ɛpezyɛ, ɛwala bi aadi nɛ gwyes ɛbee Sɛɛŋɛlɛ Mɔn Mot, ye nàkoo zo bɛ beeaa ba dwoo wat ɛ. E ɛwala tak bi aanàkwaabee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bɛ waalɛɛ bin náá: “Nyɛ ɛ́ wak,” nɛghu náá, “Nyɛ ɛ́ poon.” Deenek, sa mot ààtɔ́. Sa mot ààdu nɛ kaab. ");
INSERT INTO bkw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dáa ngwyes bhi di kas tɔ gwoo ɛ, djɛ gwyɛ tɔ gwoo djas ɛ, yɛ aadi ɛ́ deenek e dwoo Sɛɛŋɛlɛ Mɔn Mot. ");
INSERT INTO bkw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ɛsok nɛ etɛp binek nɛ sɛɛ, ye goka ɛ́ náá, Sɛɛŋɛlɛ Mɔn Mot pookozuk ɛbuɛpe, da bot ɛ́ di kɔ bɔs'ak mos'aak ɛ pookoswonal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Dáa ye nasael é ghɛŋ ɛ Noe ɛ, yɛ aabaazosael deenek e dwoo Sɛɛŋɛlɛ Mɔn Mot. ");
INSERT INTO bkw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Eghɛŋ tak bot nadi edɛ edee nɛ dɛ mɛnyok. Bɛ nadi eba mɛba nɛ ɛkɛdjɛ bɔɔ bɔɔ é mɛba, kɛyaka nɛ dwoo Noe nani tɔ boo elɛɛd ɛ. Bhii tak, boo bhyoŋ nazyɛ, wɔ gwaa ye zɛdesal bɔɔ djas, bɔɔ djas gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yɛ aadi ɛ́, tyee é ghɛŋ ɛ Lɔt. Eghɛŋ tak, bot nadi edɛ edee nɛ dɛ mɛnyok. Bɛ nadi ebɔmsa esa bɔɔ nɛ bɔm yii bɛsɔ bɔɔ. Bɛ nadi ebɛ epyeeb nɛ ɛsum ɛ mendjaa. ");
INSERT INTO bkw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tin, dwoo Lɔt nadus kɔ dɛl ɛ Sodɔm ɛ, ye nabɛ ɛ́ Zɛɛb naakwyital bhi ma du, nɛ pup na góo-góo kɔ dɛl, bot djas zokagwyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yɛ aabaazosael ɛ deenek é dwoo Sɛɛŋɛlɛ Mɔn Mot aalyaal nyel e mis mɛ bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«E dwoo tak, mot aadi e di di pɛ ko tɔ ndjaŋ'ɛ, da nyɛ ɛ́ ka lik ɛsa bɛ pɛ si tɔ ndjaŋ ɔ, nyɛ tok nɛ ghwyil ɛbaasul étɛp ɛzɛnɔɔ esa ee nyɛ lik pɛ si ɛ. Tyee wat nɛ mot aadi tɔ pyeeb ɔ: Nyɛ aanàkwaabaabela ghwyil ɛsik pɛ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Taalaka sa nasɛɛ nɛ mwaa Lɔt ɛ! ");
INSERT INTO bkw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mot aasuu ɛkwyɛɛg ɛ tsik'ɛ ɔ, nyɛ waasu tsik'ɛ. Mot aakwyɛl ɛsu tsik'ɛ ɔ, waabaal tsik'ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mɛ lɛɛ bin ɛ́ tsɛɛtsɛ náá, e pum tak, bot ɛbá waadjaasi goŋ wat. Ngɔt ɛ waanɔŋaa; nwyak ngɔt likaa. ");
INSERT INTO bkw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Boa ɛbá aadi ɛ́, é dum tɔ bwak wat. Ngɔt ɛ waanɔŋaa; nwyak ngɔt likaa.  ");
INSERT INTO bkw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bot ɛbá ɛ waadi tɔ pyeeb. Ngɔt ɛ waanɔŋaa; nwyak ngɔt likaa.» ");
INSERT INTO bkw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bɛdjekel bɛ zokazɛdji nyɛ náá: «Ghɛŋ, etɛp binek djas aasael pɛ yaa sum di?» Wɔ gwaa nyɛ zɛbɔɔza nɛ nɔɔ náá: «Esok bi aadi é bee mɛbɛk é kii tɔ gwoo ɛ, keka náá, muu tit ɛ́ tin.» ");
INSERT INTO bkw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bhii tak Yezu eebaazɛlii nɛ nɔɔ tɔ kana yak étɛp nyɛ neelyo bɛ náá, bɛ goka ɛ́ náá, bɛ gheedjaala mɛlu djas, ààbula bhis. ");
INSERT INTO bkw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nyɛ eezɛke náá: «Pɛ kɔ dhiiti ghaada wat, ye nabɛ ɛ́ nɛ dhiiti tetɛp ngɔt nadi náá, etɛp e Zɛɛb, ààgwyak nyɛy ɔ. Nyɛ nabɛ ɛ́ ààkobem ba nɛ mot. ");
INSERT INTO bkw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kɔ dɛl ɛ tak, ye nabɛ ɛ́ nɛ dhiiti kus moma nadi é pyap ɛzyɛ pɛ dáa tetɛp tak é zɛkeke nɛ nɛ náá: “Pɛ́ɛa mɛ tɛp bis di nɛ yɛ bis nɛ bot bak'aak,” etɛɛ náá, nyɛ nadi é gu náá, nyɛ ɛ́ nɛ gham. ");
INSERT INTO bkw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","E mɛkɛn, tetɛp nadi byen. Deenek nyɛ eezɛke tɔ lyemɛ náá: “Yɛ ko bɛ náá, mɛ ààkaab Zɛɛb ɔ, baadi náá, mam ààbis bot ɔ, ");
INSERT INTO bkw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dáa ye di náá, kus moma yak ɛpemyel mɛ ɛ, ye goka ɛ́ mɛ pɛ́ɛ tɛp'ɛ étɛp nyɛ neekat ɛpyap wak.”» ");
INSERT INTO bkw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bhii tak Ghɛŋ eezɛbaabil náá: «Gwakeka dáa mbee tetɛp tak nalii ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tin, Zɛɛb tok nɛ ghwyil ɛkwyee bot ɛ nyɛ nazesɛ́ɛ ɔ, bot ɛ tak ɛ di ewaab esonok pɛ daa lɛ mwos nɛ pum ɔ. Nyɛ aanàkwaakwyee bɛ? ");
INSERT INTO bkw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mɛ lɛɛ bin ɛ tsɛɛtsɛ náá: Nyɛ waalel ɛkwyee bin kaab dum nɛ ghamen. Tin, esok Sɛɛŋɛlɛ Mɔn Mot aazyɛ ɛ́, nyɛ waazɛbela bot ɛ di dum koŋ nɛ Zɛɛb ɔ kɔ bɔs'ak ee?» ");
INSERT INTO bkw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yezu eebaazɛlɛɛ kana kɔ ɛsu ɛ bot ɛ di bun náá, bɛ ɛ́ bot ɛ epiki, da bɛ ɛ́ kadyamal ɛ́ bɔn nyɛɛg bɔɔ ɔ. Nyɛ eezɛke nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Bot ɛbá naazɛbyet pɛ kok Ndjaa-ebuwa kɛdjaala; ngɔt nadi ɛ́ Falizyɛ, dhiiti kadi ɛ́ nɔŋel epata e lapo. ");
INSERT INTO bkw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falizyɛ eezɛtyaa e yɛ di, nyɛ moo djaala náá: “Hee, Zɛɛb! Mɛ eeduwal wɔ, etɛɛ náá, mɛ tok dáa bɛdhiiti bot: bɛ ɛ́ bot ɛ djii, embee bot, bot ɛ mɛzɔ. Mɛ ɛpeduwal wɔ, etɛɛ náá, mɛ tok dáa nɔŋel epata e lapo di'ak. ");
INSERT INTO bkw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mam tsi edee ɛ́, esok ebá tɔ yenga wat. Mɛ nɛ djɛ wɔ endiyal kam bam.” ");
INSERT INTO bkw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nɔŋel epata e lapo natyaa ye ɛ́ ba ɛtsetaɛpe. Nyɛy ààben mis pɛ ɛko. Nyɛ eekɛl mɛmbɔ kɔ lo. Nyɛy náá: “Iyeee, Zɛɛb, wɔy ààkogek mɛ ghoŋ e? Mam mot mesyem.”» ");
INSERT INTO bkw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yezu ɛ́ boozɛke náá: «Nɔŋel epata e lapo naka sik ɛ́, Zɛɛb eezɛpel mesyem mɛ, ààbɛ Falizyɛ. Étɛp tak ɛ́ di náá, mot ɛ ghɛɛ nyel ɔ, Zɛɛb ɛ waasiil nyɛ. Mot ɛ siila ɔ, Zɛɛb ɛ́ bin nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bot naazyɛ nɛ bɔɔ tɔlɔɔ bɔɔ pɛ dáa Yezu étɛp nyɛ neekɛl mɛmbɔ kɔ lɔɔ. Tyee bɛdjekel nakabee deenek ɛ, bɛ naazɛbhɛm bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tin, Yezu eezɛke náá, bɔɔ tɔlɔɔ tiila pɛ nyɛ nadi ɛ́: «Betka bɔɔ dhyeeb bɛ zyɛ pɛ daa lam. Sa bi ààlu bɛ, etɛɛ náá, Ɛyoŋ ɛ Zɛɛb ɛ́ yii bot ɛ di dáa bɔɔ dhyeeb ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Mot ɛ di ààmyaal Ɛyoŋ ɛ Zɛɛb dáa mɔɔ dhyeeb ɔ, nyɛ aanàkwaani tɔ tak.» ");
INSERT INTO bkw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dhiiti kukuma eYuda ngɔt zokazɛdji Yezu náá: «Mbɛɛ lyoel, mɛ goka nɛ ɛsa dáa étɛp mɛ neebela tsik na kɔm-kɔm?» ");
INSERT INTO bkw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yezu eezɛbɔɔza nɛ nɛ náá: «Étɛp yé wɔ di djóo mɛ mbɛɛ lyoel? Ye tok nɛ mbɛɛ mot kɔ bɔs'ak bhis Zɛɛb nyɛy nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wɔ nɛ gu etsi djas: “Sa wɔ ààsa mɛzɔ. Sa wɔ ààgó mot. Sa wɔ ààdjii sa mot. Sa wɔ ààlɛɛ elɛŋ e etsal dum nɛ sɔ mot. Duwala soog nɛ nyoog.”» ");
INSERT INTO bkw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mot'enɔk eezɛbɔɔza nɛ nɛ náá: «Etsi binek djas mɛ nɛ duwal yɛ, kana edhɔma bam, kɛkum dwoo pan mos'ak.» ");
INSERT INTO bkw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bhis Yezu nagwak nyɛ ɛ́, nyɛ eezɛke nɛ nɛ náá: «E zokalik ɛ́ wɔ sa sa wat: kɛbɔmsa esa bɔ djas, da wɔ ɛ́ nɔɔ epata e tak, djɛ bɛdjel ɛ bot. Tin, wɔ waabela mɛvu tɔ gwoo, bhii tak da wɔ ɛ́ zɛdu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dáa mot mɛvu menɔk nagwak deenek ɛ, ye nabɛ ɛ́ mɛkpa menek naatek nyɛ nyel na wɔyɔŋ, etɛɛ náá, nyɛ nadi ɛ́, nɛ mɛvu ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Dáa Yezu nabee náá, lyem mot mɛvu menɔk nabɛ ɛ́, ye naakpaŋ ɛ, nyɛ ɛ́ boozɛke náá: «E kɔɔla nɛ bot ɛ di nɛ ekum ɔ, bɛ ni tɔ Ɛyoŋ ɛ Zɛɛb! ");
INSERT INTO bkw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɛlyel náá, boo yaaga kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ dhaa tɔ ba mɔɔ ɛlen ɛ dhɔɔ, baadhaa-dhaŋa mɛlyel nɛ mot mɛvu étɛp nyɛ neeni tɔ Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bot ɛ nadi gwak nyɛ moo tin é ke pak'ɔɔ náá: «Yɛ bɛ deenek ɔ, ɛzɛ aabela tsik?» ");
INSERT INTO bkw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Sa di náá, bot aanàkwak ɛ, Zɛɛb aanàkwaakat yɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Wɔ gwaa Pyɛɛd ke náá: «Gwyáka, bis eezebet djas étɛp ɛdu ɛ wɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yezu ɛ́ boolɛɛ bɛ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Mot ɛ bet ndjaŋ'ɛ, nɛghu myɛl, nɛghu bɔn nyɛɛg, nɛghu sɛɛg, nɛ nyɛɛg, nyɛ baabet bɔɔ bɛ étɛp ɛ Ɛyoŋ ɛ Zɛɛb ɔ, ");
INSERT INTO bkw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nyɛ waabela bɛtɛ nɛ bot binɔk é mɛwala mak. Dɔɔ nɛ tɔ tsik aazyɛ bhis'aak, nyɛ waabela tsik na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Dhiiti dwoo, Yezu zokanɔɔ bɛdjekel kam nɛ bɛbá, e bhaaz'ɛ. Nyɛy nɛ nɔɔ náá: «Gwakeka! Mena moo tɔ́ pɛ Yeluzalɛm. Penek ɛ yɛ aadjala djas bɛngoolel ɛ mɛkpa ɛ Zɛɛb nazekwyal dum nɛ Sɛɛŋɛlɛ Mɔn Mot ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nyɛ waaseebaa é mɛmbɔ mɛ bot ɛ di ààbɛ bot ɛ́ mbyak eYuda ɔ. Bot binɔk aadek nyɛ, lee nyɛ, nɛ ɛsɛɛ ɛ́ nyɛ mɛtel. ");
INSERT INTO bkw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɛ waanyuu nyɛ nɛ eghwyɛs. Bhii tak, bɛ waagó nyɛ. Mɛlu mɛlɛl bhii tak, nyɛ waagom.» ");
INSERT INTO bkw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ghuna bɛdjekel kadi ɛ́, ààgu sa wat tɔ etɛp ee nyɛ nadi é ke ɛ. Ye nadi nɛ nɔɔ syela. Bɛ nadi ɛ́, ààgu sa Yezu nalii ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dáa Yezu nabɛ náá, bɛ moo kunaa nɛ Yeliko ɛ, ghuna dhiiti mot na edhim nadi ɛ́, ndiindil e ngwoob gba. Nyɛ nadi ɛ́, mot engwyeebel. ");
INSERT INTO bkw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nyɛ eezɛgwak ɛtap ɛ zukamwaa nɛ mot eezyɛ pɛ kyee nyɛ nadi ɛ́, wɔ gwaa nyɛ zɛdji sa nadi dhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɛ zɛlɛɛ nyɛ náá: «Ye ɛ́ Yezu, mot Nazalɛt, ɛ di dhaa tin.» ");
INSERT INTO bkw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wɔ gwaa nyɛ zɛtsim náá: «Yezu, Mɔɔ Dhavid, geka mɛ ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bɛtɛɛ nɛ bot ɛ nadi kɛpɛ sok ɔ moo tin é bhɛm nyɛ, nɛ é lyak nyɛ, étɛp nyɛ needi gwyem. Tin, nyɛ eebaazɛloogal gwood ɛlyelɛpe: «Mɔɔ Dhavid, geka mɛ ghoŋ!» ");
INSERT INTO bkw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yezu eezɛtyaa. Bhii tak, nyɛ eezɛlwom náá, bɛ zyɛ nɛ nɛ daa lɛ. Dáa mot edhim binɔk natiila pɛ Yezu nadi ɛ́, Yezu eezɛdji nyɛ náá: ");
INSERT INTO bkw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Wɔ kwyɛl náá, mɛ sa wɔ yé?» Mot edhim binɔk eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, mɛ kwyɛl ɛ náá, mis mam baabɛŋel!» ");
INSERT INTO bkw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yezu zɛke nɛ nɛ náá: «Beea, ɛmyaal ɛ lɔ eetsik wɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","É di'enek wat, mis mɛ eezɛbɛŋel. Bhii tak, nyɛ moo du Yezu é duwal Zɛɛb. Dáa ɛdhuu ɛ bot ɛ nadi tinaak ɔ djas nabee deenek ɛ, bɔɔ djas naduwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bhis nyɛ natuula kɔ dɛl ɛ Yeliko, Yezu eezɛkpaa tɔ́ pɛ yii kyee dɛl. ");
INSERT INTO bkw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kɔ dɛl ɛ tak, ye nabɛ ɛ́ nɛ dhiiti mot, din ɛ lɛ nabɛ ɛ́ Zasye. Nyɛ nadi ɛ́, kukuma bɛnɔŋel ɛ epata ee elapo, nyɛ nadi ɛ́, mot ekum. ");
INSERT INTO bkw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nyɛ nadi esuu ɛbee Yezu, saabɛgɔs kabɛ ɛ́ náá, nyɛ nadi ɛ́ ɛwulalɛpe. Nyɛ nabɛ ɛ́ ààbɛ nɛ tyee nyɛ bee Yezu, etɛɛ náá, bot nadi ɛ́ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tin, nyɛ ɛ́ boozɛwyis kaab tɔ pɛ sok kɛgo kɔ mɔɔ le sikomood, etɛɛ náá, Yezu ɛ dhaa tin ɔɔ, nyɛ neebee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Dáa Yezu nakum é di'enek ɛ, nyɛ zɛben mis pɛ ɛko, nyɛ ɛ́ boolɛɛ nɛ Zasye náá: «Lela ɛsul Zasye, etɛɛ náá, ye goka ɛ́ náá, mos, mɛ sulal tɔ ndjaŋ'ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tin, wɔ gwaa Zasye zɛsul kɔ le kaab ɛ kaab. Bhii tak, nyɛ eekɛdisi bɛ nɛ Yezu tɔ ndjaŋ'ɛ nɛ mɛmyaala ɛbuɛpe tɔ lyem. ");
INSERT INTO bkw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dáa bot nabee deenek ɛ, bot naadyeebalii ɛbiyoɛpe kɔ ɛsu ɛ Yezu étɛp tak. Bɛ nadi ekeke ɛ náá: «Mot tak eetɔ́, kɛdi tɔ ndjaa mot na mbee dék!» ");
INSERT INTO bkw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zasye eezɛwyɛl sok bhwoob ɛ Yezu, nyɛ eezɛke, nɛ nɛ náá: «Ghɛŋ, gwaka. Mɛ waakaa mɛvu mam ekyee ebá. Kyee wat mɛ waadjɛ bɛdjel ɛ bot, yɛ bɛ náá, mɛ naanɔɔ epata e mot, dhaa yii mɛ nawaagoka nɛ ɛnɔŋ ɛ, mɛ waabulal nyɛ mɛtaŋ mɛ mɛnɔŋ ɛ́ esok ená.» ");
INSERT INTO bkw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tin, Yezu eezɛke nɛ nɛ náá: «Dwoo pan mos'ak, tsik eeni tɔ ndjaŋ'ak, etɛɛ náá, wɔy pe ɛ́ dha ɛ Abalaam. ");
INSERT INTO bkw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Etɛɛ náá, Sɛɛŋɛlɛ Mɔn Mot nazyɛ ɛ́, zɛsaa nɛ tsik bot djas nazewo ze ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yezu eebaazɛlɛɛ dhiiti kana dum nɛ bot ɛ nadi é gwak nyɛ ɔ. Nyɛ nadi ɛ́, nyɛ eezekunaa nɛ Yeluzalɛm. Bot nadi é gek ɛ́ náá, Ɛyoŋ ɛ Zɛɛb eezekɔ nɛ ɛtuula. ");
INSERT INTO bkw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tin, Yezu eezɛke nɛ nɔɔ náá: «Mot ngɔt nabyel du wat nɛ bɛkuma ɛ bot ɔ zokazɛtɔ́ mɛdjoŋ pɛ dhiiti dɛl ɛtsetaɛpe nɛ dɛl ɛ lɛ étɛp nyɛ neekɛ djɛaa boo mɛkoozi. Bhii tak nyɛ zɛbula pɛ dɛl ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ɛsok nɛ nyɛ nɛ tɔ́, nyɛ eezɛdjóo bot ɛ mɛsa mɛ kam, lik bɛ mot nɛ mot ɛdhɛɛb ɛ lɔɔd wat nadi nɛ boo mɛtaŋ ɛ. Bhii tak nyɛ eezɛke nɛ nɔɔ náá: “Likeka é liig mɛmbɔ nɛ epata bak, kɛkum dwoo mɛ aaboo bul ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tin, kaa bela náá, bot ɛ dɛl ɛ lɛ nadi bhina nyɛ. Wɔ gwaa bɛ zɛlwom bot nyɛy ààgu, étɛp bot ɛ tak neekɛ lɛɛ náá: “Bis ààpakwyɛl náá, mot'enɔk di mɛkoozi mis.” ");
INSERT INTO bkw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Saabɛgɔs nɛ nɔɔ, ye naka swaala náá, bɛ naabatadjɛ nyɛ boo mɛkoozi. Bhii tak nyɛ eezɛsik pɛ dɛl ɛ lɛ. Dáa nyɛ nakakum ɛ, wɔ gwaa nyɛ zɛdjóo bot ɛ mɛsa mɛ nyɛ nadjɛ bɛ epata ɔ, étɛp nyɛ needji bɛ bim epata ee nakala kɔ yii nyɛ nalik bɛ nɛ yɛ étɛp ɛliig ɛ mɛmbɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mot ɛsok eezɛzyɛ, nyɛy nɛ nɛ náá: “Kukuma, mɛ eebela mɛdhɛɛb mɛ lɔɔd kam kɔ yii wɔ nalik mɛ nɛ ye ɛ́.” ");
INSERT INTO bkw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mɛkoozi eezɛbɔɔza nɛ nɛ náá: “Ɛnyɔɛpe! Wɔ ɛ́ mbɛɛ mot-mɛsa. Dáa ye di náá, wɔ kɛ tɔ etsoŋ dum nɛ bɔɔ esonok ɛ, mɛ eedil wɔ kɔ bóó mɛkoozi mɛ lɛt eghaada kam.” ");
INSERT INTO bkw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mot nadi du bhis koŋ mot ɛsok ɔ eezɛzyɛ yɛ. Nyɛ eezɛke nɛ kukuma yɛ náá: “Kukuma, mɛ eebela mɛdhɛɛb mɛ lɔɔd mɛtɛn kɔ yii wɔ nalik mɛ nɛ yɛ ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mɛkoozi eezɛbɔɔza nɛ nɛ náá: “Ɛnyɔɛpe wɔy, mɛ eedil wɔ kɔ bóó mɛkoozi mɛ lɛt eghaada etɛn.” ");
INSERT INTO bkw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nwyak dhiiti mot-mɛsa eezɛzyɛ. Nyɛ eezɛke nɛ kukuma yɛ náá: “Kukuma, beea ɛdhɛɛb ɛ lɔɔd wɔ nalik mɛ nɛ yɛ ɛ. Mɛ ààpabe. Mɛ kwom ye ɛ́ syela tɔ pes kaad. ");
INSERT INTO bkw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Etɛɛ náá, mɛ di ɛ́, nɛ bwoo nɛ nɔ. Wɔy ɛ́ mot ngɔt di náá, wɔ ɛ́ nɛ biyo dhaa tyɛ. Wɔ nɛ dyeebanɔɔ dɔɔ nɛ sa di náá, wɔ ààpakwom ɛ. Wɔ nɛ tɔ́ tɔ epyeeb e baa, kɛnɔɔ edee bɔɔ, ààbɛ náá, wɔy ɛ́ nabɛ yɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","É di'enek, kukuma yɛ boobɔɔza nɛ nɛ náá: “Mbee mot-mɛsa, beta náá, mɛ pɛ́ɛ wɔ nɛ mɛkpa mɔ ɛmet. Wɔ nadi egu náá, mam dyeebabɔ́k esa ee dɛk ɛ́ tɔ epyeeb mɛ di ààbɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ha wɔ di àànɔɔ epata bam, kɛwa tɔ eboo mendjaa mɛ di ebaal epata ee bot ɛ, étɛp yé? Pe bula mɛ bula ɛ, mɛ eezɛbelaa, mɛ zɛbela bɛdhiiti epata eezekala kɔ yii mɛ nalik ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bhii tak nyɛ eezɛke nɛ bot ɛ nadi tin ɔ náá: “Dɛkeka nyɛ ɛdhɛɛb ɛ lɔɔd ee nyɛ di nɛ yɛ enek, da bi ɛ́ djɛ mot bela kam kɔ yii mɛ nadjɛ nyɛ ɛ́.” ");
INSERT INTO bkw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bot ɛ tak eezɛbɔɔza nɛ kukuma tak náá: “Kukuma, nyɛy moo ɛ́ nɛ mɛdhɛɛb mɛ lɔɔd kam!” ");
INSERT INTO bkw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kukuma eebaazɛbɔɔza náá: “Mɛ lɛɛ bin ɛ náá, ye ɛ́ pɛ dáa bot djas aadi nɛ batsa ɔ bɛ aabil étɛp ye neebu. Tin, mot aakadi toto ààbɛ nɛ sonok ɔ, bɛ waadɛk nyɛ dɔɔ nɛ eghutu-ghutu nyɛ lik nɛ yɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yɛ kabɛ bot ɛ di bhina mɛ ɔ, bot ɛ nadi ààkwyɛl náá, mɛ di mɛkoozi ɔ, dhaaka nɛ nɔɔ wak, da bi ɛ́ tsak bɛ e mis mam.”» ");
INSERT INTO bkw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bhis bɛ nalii deenek ɛ, Yezu eezɛbyet tɔ́ pɛ Yeluzalɛm. Nyɛy pɛ sok lɔɔg mɛdhuu mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dáa bɛ nadi, bɛ moo é kunaa nɛ mɛl mɛ Bhɛtfaze nɛ Bhetani ɛ, e ngwoob Ɛtsok ɛ pyeeb oliv. Tin, Yezu eezɛlwom bɛdjekel bɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nyɛy nɛ nɔɔ náá: «Tɔ́ka kɔ dɛl ɛ di pɛ sok enek. Tuula bi aatuula kɔ dɛl ɛ, bi ɛ́ waabee mɔɔ swooz an tiŋela, nyɛ nabɛ ɛ́, nyɛ di náá, mot dinaa ààpaago kɔ lɛ ɔ. Tiika nyɛ, da bi ɛ́ zyɛ mɛ nɛ nɛ wak. ");
INSERT INTO bkw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mot ɛ́ dji bin náá: “Bi tii nyɛ étɛp yé ɔ?” Lɛɛka nyɛ náá: “Ye ɛ́ Ghɛŋ ɛ́ di nɛ gwyes tak.”» ");
INSERT INTO bkw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bhii tak, bot ɛ nalwomaa ɔ eezɛtɔ́, bɛ kakɛbela esonok djas ɛ́ dáa Yezu nazolɛɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Dáa bɛ nakadi etii mɔɔ swooz an tak ɛ, bɛ nakuma tak eezɛdji bɛ náá: «Bi tii mɔɔ swooz an étɛp yé?» ");
INSERT INTO bkw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wɔ gwaa bɛ zɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ ghɛŋ ɛ́ di nɛ gwyes tak.» ");
INSERT INTO bkw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bɛ eezɛtii mɔɔ swooz an tak. Tin, bɛ eezɛtɔ́ nɛ nɛ pɛ daa Yezu. Bhii tak bɛ eezɛdja endjookuwa bɔɔ kɔ koŋ mɔɔ swooz an tak. Tin, bɛ eezɛgel Yezu kɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dáa bɛ nadi bɔɔ ekɛ, bɛ moo tin edja endjookuwa bɔɔ gba ɛ gba. ");
INSERT INTO bkw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dáa bɛ nadi, bɛ moo kunaa nɛ Yeluzalɛm ɛ, bɛ nadhaŋ ɛ́ pɛ ze di esul Ɛtsok ɛ pyeeb oliv ɛ, mɛdhuu mɛ bɛdjekel moo tin eduwal Zɛɛb ɛlyelɛpe dum nɛ endem e mɛbwala mɛ bɛ nadi ebee ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɛ nakeke ɛ́ náá: «Zɛɛb sɛɛ Mɛkoozi mɛ di ezyɛ nɛ din ɛ Ghɛŋ ɔ mɛtel. Egwyem tɔ gwoo dɔɔ nɛ duma nɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bɛdhiiti eFalizyɛ nadi tɔ mɛdhuu mɛ bot binɔk ɔ zokake nɛ Yezu náá: «Lyoel, lyaka bɛdjekel bɔ náá, bɛ di gwyem.» ");
INSERT INTO bkw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Beeka, mɛ lɛɛ bin náá, bɔɔ bɛ diyal enuub bɔɔ di gwyem ɔ, mɛkok ɛ waatsim e diɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Dáa Yezu nakum e bhaaz ghaada ɛ, beea nyɛ nabee Yeluzalɛm ɛ, Yezu zokadje kɔ ɛsu ɛ dɛl ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nyɛy náá: «Yɛ pe bɛ ɛ́ di náá, dɔɔ nɛ wɔy pe ɛpegu dwoo ɛlak mos dáa ye di egoka nɛ ɛsaa étɛp ɛbela egwyem ɔ. Saabɛgɔs nɛ ye kasa étɛp náá, nenak e moo ɛ́ syela e mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Etɛɛ náá, mɛlu mɛ bot ɛ di bhina wɔ ɔ, aasum boo peeb étɛp ɛzɛlumela nɛ nɔ ɛpezyɛ. Bɛ waakaal wɔ kuku ɛbwak. Bhii tak, bɛ ɛ́ kɛmaadɔ tɔ dhiiti tuma. ");
INSERT INTO bkw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bɛ waasii wɔ, bi nɛ bot bɔ. Bɛ aanàkwaalik wɔ ɛkok ɛwat kɛla kɔ sɔ, etɛɛ náá, wɔ nabɛ ɛ́ ààsiiza ɛwala Zɛɛb nazɛkwyee wɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wɔ gwaa Yezu zɛni tɔ kok Ndjaa-ebuwa, nyɛ eezɛni é sɔ bot ɛ nadi bɔmsa esa bɔɔ tɔ tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nyɛy nɛ bot ɛ tak náá: «Pɛ tɔ ekwyala Zɛɛb lɛɛ ɛ náá: “Ndjaŋ'am aadjóoaa ɛ́ ndjaa mendjaala mɛ eYuda.” Yɛ kabɛ biyɔ ɔ, bi zeliig yɛ, ye di zɛɛga bot ɛ djii.» ");
INSERT INTO bkw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Mɛlu djas Yezu nadi lelyo bot tɔ kok Ndjaa-ebuwa. Tin, eboo bɛghaa-Zɛɛb, nɛ bɛghaŋ ɛ mɛkana mɛ etsi, zɛnɔɔ bɛdhil ɛ bot ɛ dɛl nadi esaa dáa bɛ sa étɛp bɛ neegó Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Deenek bɛ nabɛ ɛ́ ààgu dáa bɛ nawaa di ye goka nɛ ɛsa ɛ. Etɛɛ náá, bot djas nadi kwyɛl ɛgwak mɛlyo mɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dhiiti dwoo, Yezu nadi djɛ bot mɛlyo tɔ kok Ndjaa-ebuwa. Nyɛ nadi lɛɛ bɛ Mbɛɛ Bhaadal ɛ Zɛɛb. Eboo bɛghaa-Zɛɛb, nɛ bɛghaŋ ɛ mɛkana mɛ etsi, zɛnɔɔ bɛpaa ɛ eYuda, zokazɛtuula é di'enek. ");
INSERT INTO bkw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bɛ eezɛdji Yezu náá: «Kɔ eghɛŋ zɛ wɔ di esa etɛp binek? Ɛzɛ djɛ wɔ ghwyil ɛsa deenek?» ");
INSERT INTO bkw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛ pookodji bin kiya wat. Bi ɛ bɔɔza mɛ ɔ, ye ɛ́ mɛ ka lɛɛ bin étɛp yé mɛ di nɛ ghwyil ɛsa esesɛɛ bak. ");
INSERT INTO bkw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ɛzɛ nadhis Zaŋ, nyɛ zɛduu bot Zɛɛb? Ye nabɛ ɛ́ Zɛɛb ohoo ye nabɛ ɛ́ mot?» ");
INSERT INTO bkw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","É di'enek, bɛ moo tin ɛ́, é sɔs pak'ɔɔ. Bɔɔ náá: «Mena ɛ ke nenak náá: “Ye ɛ́ Zɛɛb” ɔ, nyɛ ɛ́ waadji mena náá: “Étɛp yé bi nadi ààmyaal Zaŋ?” ");
INSERT INTO bkw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mena ɛ ka keka náá: “Ye ɛ́ bot ɛ nadhis nyɔ” ɔ, mɛdhuu mɛ bot bak djas ɛ́ waasaa ɛgó mena nɛ mɛkok. Etɛɛ náá, bɔɔ djas nɛ myaal náá, Zaŋ nabɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bɛ ɛ́ boozɛbɔɔza nɛ Yezu náá: «Bisɔ ààgu mot nalwom nyɛ náá, nyɛ zɛduu bot Zɛɛb ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tin, Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Dɔɔ nɛ mam pe mam aanàkwaalɛɛ bin kɔ eghɛŋ e zɛ mɛ di esa esesɛɛ bak ɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bhii tak, Yezu zɛlii nɛ ɛdhuu ɛ bot binɔk tɔ kana náá: «Dhiiti mot ngɔt naabɛ pyeeb ekel e di djɛ bhum vin ɛ. Bhii tak, nyɛ eezɛkola yɛ nɛ bot ɛ di gu mɛsa mɛ vin ɔ étɛp bɛ neesa mɛsa tɔ tak. Nyɛ eezɛnɔɔ nyel, tɔ́ mɛdjoŋ, kɛbɔya pɛ dhiiti dɛl. ");
INSERT INTO bkw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tin, yɛ wum ɔ, da nyɛ ɛ́ lwom dhiiti mot-mɛsa mɛ étɛp bɛ djɛ nyɛ yɛ bim tɔ yii bɛ aabela ɛ. Mbu epyeeb e tak di wum ɛ, eezɛkum. Wɔ gwaa nakuma pyeeb zokazɛlwom mot ngɔt di sa mɛsa daa lɛ ɔ pɛ dáa bot ɛ nyɛ nalik nɛ pyeebɛ ɔ, étɛp bɛ needjɛ nyɛ yɛ pak vin bɛ bela ɛ. É di'enek, wɔ gwaa bot ɛ nalik nɛ pyeeb ɔ mɛt mot tak, duma nyɛ e nyel nɛ mɛbin, bhii tak swaal nyɛ mɛmbɔ toto. ");
INSERT INTO bkw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bhis mot sok, nakuma pyeeb baazɛlwom dhiiti mot di esa mɛsa pɛ daa lɛ ɔ, nyɛ eezɛtɔ́ pɛ daa lɔɔ tɔ pyeeb, bɛ eezɛnyuu nyɛ, zɛnyek nyɛ ɛbiyoɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yak kɔkɔ tyee esok elɛl, nakuma pyeeb eebaazɛlwom nwyak mot, bɔɔ duma nyɛ e nyel nɛ mɛbin, wus nyɛ pɛ kel. ");
INSERT INTO bkw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nakuma pyeeb eezɛdji náá: “Mɛ sa dáa? Mɛ aaka kyeed ɛ́, sim mɔn'am ngɔt mɛ dyeebakwyɛl ɔ. Tin, mɛ bee ɛ náá, bɛ waakaab nyɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dáa bot ɛ di sa mɛsa tɔ pyeebɛ nabee mɔn'enɔk ɛ, bɔɔ náá: “Yawee! Beeka mot aalik nɛ mɛvu mak djas ɔ! Dhaaka, mena góka nyɛ. Tin, mɛvu mak aadi ɛ́, yenabɛlka.” ");
INSERT INTO bkw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wɔ gwaa bɛ zɛmɛt nyɛ, mwas nyɛ bhis pyeeb vin, gó nyɛ.» Tin, Yezu eezɛdji bɛ náá: «É di'enek, nakuma pyeeb goka nɛ ɛsa yé? Nyɛ eebil náá: ");
INSERT INTO bkw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nyɛ waazyɛ, da nyɛ ɛ́ gó bot ɛ nadi sa mɛsa tɔ pyeebɛ ɔ. Bhii tak da nyɛ ɛ́ nɔɔ pyeeb, djɛ nɛ bot ɛsis.» Bhis bot nagwak deenek ɛ, bɛ ɛ́ boozɛke náá: «Ààbɛ! Yenek aanàkwaasael.» ");
INSERT INTO bkw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bhii tak Yezu eezɛliig mis, gwyák bɛ. Nyɛy nɛ nɔɔ náá: «Mɛkpa mɛ di kwyala tɔ mɛkana'aak kwyɛl ɛlɛɛ yé “Ɛkok ee bɛzumel mwas ɛ, moo ɛ́ ɛkok di epyet ndjaŋ ɛ”? ");
INSERT INTO bkw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mot aaduma kɔ ɛkok ɛ tak ɔ, nyɛ waabik ekyes ekyes. Yɛ kabɛ náá, ɛkok ɛ ka kwyit kɔ mot ɔ, yenɔk mot aatwaalel ɛ́ twaalela.» ");
INSERT INTO bkw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tin, bɛghaŋ ɛ mɛkana mɛ etsi, nɛ eboo bɛghaa-Zɛɛb nadi esaa mɛpek étɛp bɛ neemɛt Yezu e di tak wat. Etɛɛ náá, bɛ nabɛ ɛ́, é gu náá, Yezu nalɛɛ kana tak ɛ́, kɔ ɛsu ɛ lɔɔ. Tin, bɛ nadi kaab ɛ́ ɛdhuu ɛ bot ɛ nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bɛ moo tin ebɔŋal Yezu. É di'enek, wɔ gwaa, bɛ zɛdhis bɛdhiiti bot ɛ nadi sa mɛpek náá, bɛ ɛ́ bɛdhil ɛ bot ɔ. Bot ɛ tak nazyɛ ɛ́ étɛp ɛzɛ lóo Yezu pɛ ɛko, da ɛ́ bwood nyɛ pɛ kyɛ nɛ dhiiti vaŋ kiya, étɛp bɛ neebela lo mɛsɔ mɛ di kwyesal nyɛ ndjɛ sɔs e mis mɛ kukuma dɛl ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bɛ ɛ́ boozɛke nɛ nɛ náá: «Lyoel, bis nɛ gu náá, etɛp ee wɔ di lɛɛ ɛ, ye ɛ́ tsɛɛtsɛ. Wɔy ààpɛ́ɛ tɛp mot djhak. Wɔy lyo ɛ, sa Zɛɛb kwyɛl ɛ, nɛ lyem epiki. ");
INSERT INTO bkw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tinaak, lɛɛa bis, etsi lɛɛ ɛ́ náá, epata e lapo tuudaa ɛ́ nɛ Sezaad ee?» ");
INSERT INTO bkw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tin, Yezu eezɛgu mɛpek mɔɔ. Bhii tak nyɛ ɛ́ booke nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Dhaaka mɛ nɛ falanga wat, étɛp mɛ neebee. Bɛ eezɛzyɛ nyɛ nɛ falanga wat. Yezu eezɛdji bɛ náá: bhwoob di sɔna kɔ falanga yak ɛ wak bhwoob zɛ? Ye ɛ́ ekwyala din ɛ ɛzɛ di kɔ tak?» Bot binɔk eezɛbɔɔza nɛ nɛ náá: «Ye ɛ́ bhwoob nɛ din ɛ Sezaad.» ");
INSERT INTO bkw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Bhii tak, Yezu eebaazɛbɔɔza nɛ nɔɔ náá: «Djɛka Sezaad sa di yɛ Sezaad ɛ; da bi ɛ́ djɛ Zɛɛb sa di yɛ Zɛɛb ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kɔkɔ ɛyala ɛ Yezu nayala ɛ, nabɛ ɛ́, ye naalyel nɛ nɔɔ náá, bɛ bela mɛsɔ̌ mɛ nyɛ aabela ndjɛ e tak ɛ. Etɛɛ náá, gwaka bɛ nagwak deenek ɛ, ye nabɛ ɛ́ bɛ nadiaa djoka nyɛ ɛlyelɛpe, tin, bɛ eezɛdi gwyem. ");
INSERT INTO bkw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bɛdhiiti bot tɔ lɔɔg eSaduseɛ zokazyɛ pɛ dáa Yezu zɛdji nyɛ dhiiti kiya. ESaduseɛ, bot ɛ nadi eke náá, bhis ɛsyee, mot aanàkwaabaagom ɔ, ");
INSERT INTO bkw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bɔɔ nɛ Yezu náá: «Lyoel, mɛkana mɛ Moiiz lɛɛ náá: “Yɛ bɛ náá, mɔn nyɛɛg dhiiti mot ɛ gwyɛ, ààlik mɔn ɔ, ye goka ɛ́ náá, mɔn nyɛɛg lik ɔ, ba kus myɛl étɛp nyɛ neekwyiida mɔn nyɛɛg gwyɛ ààlik bɔn ɔ.” ");
INSERT INTO bkw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ghuna tɔ mɔ bot binɔk, bɛ nabɛ ɛ́ bɛtɛn nɛ bɛbá. Mɔn mɛgwyak zɛba, nyɛ eezɛkpaa nɛ mɛsyee, gwyɛ, nyɛ ààpakalik mɔn. ");
INSERT INTO bkw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mot nabɔɔba mɔn mɛgwyak ɔ, nyɛ eeba kus. ");
INSERT INTO bkw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tin, nyɛ eebaakpaa nɛ mɛsyee, gwyɛ, ààlik bɔn. Bhii tak, nwyak tak eebaazɛnɔɔ moma tak, ye zokabaasael ɛ́ tyee wat nɛ bot ɛ naba moma tak sok ɔ, zɛnɔɔ zwaabel lɔɔg. É di'enek, bɔɔ djas bɛtɛn nɛ bɛbá kadi ɛ́, ààbya nɛ moma yenɔk. ");
INSERT INTO bkw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bhis bɔɔ djas, moma eezɛbaagwyɛ yɛ pe. ");
INSERT INTO bkw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Esok bot aagom bhis ɛsyee ɛ, moma yenɔk aakadi mwaa zɛ tɔ bɔɔ bɛtɛn nɛ bɛbá? Etɛɛ náá, bɔɔ djas nabɛ ɛ́ botom bɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛba ɛ́, étɛp botom nɛ boa di kɔ bɔs'ak mos'aak. ");
INSERT INTO bkw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tin, guka náá: Botom nɛ boa aabela mbyok ɛgom bhis ɛsyee, da bɛ ɛ́ kɛdi pɛ kyee dik na bes ɔ, bɛ aakadi ɛ́, botom nɛ boa di ààbael ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bɛ aanàkwaakabaagwyɛ, bɛ aakadi ɛ́ dáa efofop. Bɛ ɛ́ bɔɔ Zɛɛb, etɛɛ náá, bɛ eezedhaa ɛsyee, kɛbela tsik. ");
INSERT INTO bkw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moiiz naalɛɛ popoopwon náá: Bot ɛ nazegwyɛ ɔ waagom. Nyɛ nalɛɛ deenek ɛ́ tɔ ekwyala ee di kaada tɛp ɛkpak nadi é gel ààdyak ɛ. Nyɛ nadjóo Ghɛŋ ɛ́: “Zɛɛb ɛ Abalaam, yɛ Izak, nɛ yɛ Zakɔɔb.”» ");
INSERT INTO bkw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yezu naabil náá: «Zɛɛb tok Zɛɛb bot ɛ zegwyɛ ɔ. Nyɛ ɛ́ Zɛɛb bot ɛ di nɛ tsik ɔ, etɛɛ náá, ye ɛ́, étɛp'ɛ ɛ, bot djas di nɛ tsik.» ");
INSERT INTO bkw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wɔ gwaa bɛdhiiti bɛghaa mɛkana mɛ etsi nadi tin ɔ zokake nɛ Yezu náá: «Lyoel, wɔ eedyeebalii ɛnyɔɛpe.» ");
INSERT INTO bkw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Deenek, bɛ nabɛ ɛ́ ààbɛ nɛ ghwyil ɛdji nyɛ bɛdhiiti mɛkiya. ");
INSERT INTO bkw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tin, Yezu eezɛke nɛ nɔɔ náá: «Dum nɛ yé bot di ke náá, Mɛsia ɛ́ dha ɛ Dhavid? ");
INSERT INTO bkw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Etɛɛ náá, ye ɛ́ Dhavid nyɛ ɛmet ɛ nalɛɛ tɔ Mɛkana mɛ Mɛdjeeb náá: “Ghɛŋ Zɛɛb nake nɛ Ghɛŋ'am ɛ náá: Dha disi pɛ mbɔ eghɛŋ bam. ");
INSERT INTO bkw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mɛ waanɛɛg bot ɛ mɛbhuka mɔ bɛ di esa ee mɛbɔ mɔ aanyal ɛ.” ");
INSERT INTO bkw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yɛ bɛ náá, Dhavid nyɛ ɛmet naadjóo nyɛ “Ghɛŋ” ɔ, ha e yaa tyɛ Mɛsia aakabaadi dha ɛ Dhavid?» ");
INSERT INTO bkw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dáa zukamwaa nɛ mot nadi tin ɛ nadi é gwak nyɛ ɛ́, Yezu eezɛke nɛ bɛdjekel bɛ náá: ");
INSERT INTO bkw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Kyeeka bɛghaŋ ɛ mɛkana mɛ etsi, bot ɛ di kwyɛl ɛ kɛ tɔ bot nɛ ewolo ekaad naboo mɛtaŋ é ɛlyaala mɛnyel étɛp bɛ needuwalaa nɛ swosaa é edi ee bot di sɛɛga ɛbuɛpe ɔ. Bɛ dyeebakwyɛl ɛdi ɛ́ kɔ mɛbhóó mɛ di pɛ ɛsok ɛ tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ tɔ e di e mɛbyoŋ. ");
INSERT INTO bkw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɔɔ dyeebadi é dɛk bɛkus ɛ boa esa tɔ mendjaa mɔɔ. Tɔ mɛkɔŋ mɔɔ, bɛ nɛ kwyɛl ɛdul ɛ mendjaala na kpɔkɔlɔm. Epɛ́ɛ bɔɔ aadi ɛ́, ɛlyelɛpe.» ");
INSERT INTO bkw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yezu zokazɛben lo, nyɛ moo tin é bee dáa bɛkum ɛ bot nadi ezɛduwal Zɛɛb nɛ epata tɔ ɛbɔɔl ɛ, nanɛɛga kɔ ɛbɛsɛɛ ɛ kok Ndjaa-ebuwa étɛp tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nyɛ eezɛbee dhiiti djel kus moma eezyɛ, zɛlóo yɛ tɔ ɛbɔɔl. Tin, nyɛ eezɛwa yɛ bɔɔ efalanga ebá, ààkokoka-koka nɛ pata mot bɔm sonok wat ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Dáa Yezu nabee deenek ɛ, nyɛ ɛ́ booke náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Djel kus moma yak eelóo tɔ ɛbɔɔl dhaa yii bot djas lóo tɔ ɛbɔɔl ɛlak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Etɛɛ náá, bot ɛ djɛ wak djas'aak, djɛ ɛ́ eghutu-ghutu. Yɛ kabɛ djel kus moma ɔɔ, nyɛ djɛ ɛkwom ɛ lɛ djas.» ");
INSERT INTO bkw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bɛdhiiti bot nadi esɔs dum nɛ zumal kok Ndjaa-ebuwa, dáa ye nasumel nɛ mbɛɛ mɛkok ɛ, zɛnɔɔ esa e bot nakadjɛ Zɛɛb ɛ. Tin, Yezu eezɛke náá: ");
INSERT INTO bkw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Dwoo ɛpezyɛ, dwoo yɛ aabɛ náá, yɛ ààka baalik é di'ak ɛkok ɛwat kɛla kɔ sɔ ɛkok tɔ ndjaa bi di bee'enek; etɛɛ náá, djas aadi ɛ́, bik, waazel, see e bɔs.» ");
INSERT INTO bkw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bɛdjekel bɛ eezɛdji Yezu náá: «Lyoel! Lɛɛa bis, esesɛɛ binek ɛ aasael den. Lyaala bis endem e bis aagwyak náá, esesɛɛ binek moo kɔ nɛ ɛsɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nyɛ eezɛbɔɔza náá: «Tselalka, nàbetka náá, bɛ kɔɔ bin etɛɛ náá, bot ɛbuɛpe waazezyɛ nɛ din ɛ lam. Mot nɛ mot ɛ waalɛɛ náá: “Ye ɛ́ mam ɛ di Mɛsia.” Bɛ aake náá: “Ɛlu ɛ tak eezedjala.” Sa bi ààdu bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Esok bi aadi bi moo gwak lɛŋ mɛɛb, nɛ ɛbyen nɛ lek ekukuma ɛ napwakeka, ye goka ɛ́ yenek ko sɛɛ ɛsok, guka náá, yenek aanàkwaaleedi ɛsi ɛ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yezu baazɛke náá: «Mbyak ngɔt ɛ waalumela dɛɛb nɛ dhiiti dhaad mbyak. Ɛyoŋ ɛwat ɛ waalumela dɛɛb nɛ dhiiti ɛyoŋ. ");
INSERT INTO bkw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bɔs ɛ waaboo dheegel ɛlyelɛpe. Edi-nɛ-edi, pwom nɛ gum, bot djas ɛ waagwak bwoo e di baabee edjema nɛ epela tɔ gwoo ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ɛsok nɛ esesɛɛ binek nɛ sael, bi ɛ waakɛ mɛtaa, bi ɛ waakɛ waaa tɔ tsik mezuk, bi ɛ waakɛkaaa étɛp bɛ neekɛ pɛ́ɛ bin tɔ mendjaa mɛ mendjaala mɛ eYuda, bi ɛ waakɛ mɛtaa e membok, bi ɛ waakɛ pɛ́ɛaa dáa bɛmɛkoozi nɛ ekukuma kɔ ɛsu ɛ lam. ");
INSERT INTO bkw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yenek djas aasael étɛp bi neebela ze ɛkɛlɛɛ bot sa bi di gu dum nɛ nam ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tin, guka náá, bi di nɛ lyem wat, sa mot aabem ba nɛ dáa bi aakɛtaŋal ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mam mɛ ɛmet, mɛ waadjɛ bin mɛkpa nɛ etsoŋ. Tin, bot ɛ bi aadi nɛ tɛp nɛ nɔɔ aanàkwaakwak ɛkwyesal ɛ bin, nɛ dupal mɛkpa min. ");
INSERT INTO bkw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bot aaka bin ɔ yɛ aadi ɛ́, bɛsɛɛg bin, nɛ bɛnyɛɛg bin, zɛnɔɔ bɔn nyɛɛg bin, nɛ bɛsɔ bin dɔɔ nɛ bot ɛ mɛbyel min. Bɛtɛɛ nɛ bot pak'en ɛ waadiyalaa e membok mɛ na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","«Bot djas ɛ waabhina bin kɔ ɛsu ɛ lam. ");
INSERT INTO bkw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tin, yɛ aanàkwaadi nɛ ko bhoo wat e elo bin aako diib. ");
INSERT INTO bkw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Go pyetka pɛ yebɔ kyee ɛlyelɛpe, etɛɛ náá, deenek ɛ́ bi aatsik mɛnyel min.» ");
INSERT INTO bkw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Esok bi aabee náá, mɛdhuu mɛ esodja eezɛkaal Yeluzalɛm. Tin, bi ɛ́ nɛ ghwyil ɛka gu náá: Ye ka lik ɛ́ batsa Yeluzalɛm neewaazel! ");
INSERT INTO bkw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","É di'enek, bot aadi pɛ kyee dik Yude ɔ, goka ɛ́, nɛ kaab tɔ́ tɔ mɛtsok. Bot aadi kɔ ghaada Yeluzalɛm ɔ, goka ɛ́ nɛ ɛdus tin, tɔ́ ɛtsetaɛpe. Bot aadi pɛ tɔ epɛt e ɛwala ɛlenek ɔ, ààgoka nɛ sik, tɔ́ pɛ tɔ ghaada. ");
INSERT INTO bkw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Etɛɛ náá, yɛ aadi ɛ́, dwoo Zɛɛb aazɛpɛ́ɛ bot ɛ, ye ɛ́ dwoo ekwyala djas aabela mɛsuk mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ha kpaa-ghoŋ dwoo tak nɛ boa aadi nɛ mɛbum ɔ, nɛ bot aadi nɛ bɔn e mɛbel ɔ. Etɛɛ náá, boo mezuk ɛ waadi dwoo tak kɔ bɔs. Bot ɛbuɛpe waagu ɛbuk ɛ Zɛɛb kɔ ghaada tak. ");
INSERT INTO bkw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bot ɛ tak ɛ waagóaa nɛ epɛl. Bɛdhiiti ɛ naamɛtaa, tɔ́aa nɛ nɔɔ tyee ekwom kɔ mɛl djas. Tin, Yeluzalɛm ɛ waazɛnyalaa nɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ. Bɛ waasa deenek, kɛkum dwoo Zɛɛb nadjɛ bɛ ɛ́ aaboo si ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Bot ɛ waabee edjema nɛ epela tɔ gwyes, tɔ ngɔn, tɔ ekwyikwyen. Pɛ si, membyak djas ɛ waadi nɛ boo ba nɛ kɛŋ, di bɛ aagwak ghuu nɛ ɛbee boo mɛbhyeeb tɔ boo dii mɛsɔn ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dwoo nɛ ngɔn nɛ ekwyikwyen ɛ waadheegel nɛ ghwyil ɛ Zɛɛb. Bhii tak, bɛtɛ nɛ bot ɛ waagwyɛ nɛ bwoo esiiza e etɛp aaboo tuula kɔ bɔs djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","É di'enek, bɛ waabee Sɛɛŋɛlɛ Mɔn Mot é zyɛ tɔ eguud. Nyɛ waazyɛ nɛ ghwyil nɛ mɛkas mɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dwoo etɛp binek ɛ aakan ɛ, tyaaka, pyetka pɛ yebɔ kyee, etɛɛ náá, Zɛɛb moo zɛpɛk bin e ekwom.» ");
INSERT INTO bkw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Bhii tak Yezu eezɛlɛɛ bɛ kana yak: «Pokobeeka mbek le fiigh nɛ bɛdhiiti ele djas. ");
INSERT INTO bkw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","É sok bi di bee náá, eka e bes moo kan ɛkwyil e tak ɛ, guka náá, mbu ele di wum ɛ moo eezekunaa. ");
INSERT INTO bkw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tyɛ wat nɛ biyɔ pe, esok bi aabee endem binek moo nyen ɛ, guka náá, Ɛyoŋ ɛ Zɛɛb moo ɛ́ ye zekunaa. ");
INSERT INTO bkw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Bot ɛ kɔkɔ membu mak aanàkwaasi, esonok ee mɛ di elɛɛ djas ɛ, ààsael.» ");
INSERT INTO bkw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yezu naake náá: «Gwoo nɛ bɔs ɛ waasi, ghuna yam mɛkpa aanàkwaasi.» ");
INSERT INTO bkw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Bi ɛ́ gheedi nɛ etsoŋ, sa bi ààpul ebhum e elyem bin gwyes, nɛ dek mɛnyok e mɛbyoŋ, dɔɔ nɛ étɛp ɛwyiib esa e bɔs'ak. Deenek, dwoo Zɛɛb aazyɛ zɛpɛ́ɛ bot ɛ, yɛ aatuula bin ɛ́ zaka. ");
INSERT INTO bkw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yɛ aazyɛ dáa ɛwyet. Yɛ deenek ɛ́ yɛ aatuula bot ɛ bɔs djas zaka. ");
INSERT INTO bkw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nyanka mis. Gheedjaalaka Zɛɛb mɛlu djas. Deenek ɛ́ bi aabela ghwyil ɛmaad ɛ lyem dum nɛ etɛp ee di zyɛ yenek. Da bi ɛ́ tyaa tetel sok bhwoob Sɛɛŋɛlɛ Mɔn Mot.» ");
INSERT INTO bkw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","É mwos Yezu nadi elelyo bot pɛ tɔ kok Ndjaa-ebuwa, é pum nyɛ katetɔ́, kɛdja si ɛ kɔ ɛtsok ɛ pyeeb oliv. ");
INSERT INTO bkw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tin, tɔ bɛmɛlem djas bot ɛ dɛl ka zyɛ tɔ kok Ndjaa-ebuwa, zɛgwak nyɛ é lelyo mɛlyo mɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ɛbyoŋ ɛ emapa di ààbɛ nɛ leviid, di djóoaa Pak ɛ, nabɛ ɛ́ eezekunaa. ");
INSERT INTO bkw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi nadi esaa mɛpek étɛp bɛ neemɛt Yezu etɛɛ náá, bɛ neegó nyɛ. Tin, bɛ nadi ekaab zukamwaa nɛ mot nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tin, Satan eezɛni tɔ bum lyem ɛ Yudas Iskaliɔt nadi ngɔt tɔ bɛdjekel ɛ Yezu ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yudas nazɛtɔ́ pɛ dáa eboo bɛghaa-Zɛɛb nɛ bot ɛ di kɔ elo e bɛbaalel ɛ kok Ndjaa-ebuwa ɔ, étɛp nyɛ neekɛka bɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tin, bot ɛ di kɔ elo e bɛghaa-Zɛɛb ɔ naadyeebamyaala. Wɔ gwaa bɛ zɛkɛk Yudas epata. ");
INSERT INTO bkw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas eezɛmyaal, nyɛ moo tin é saa mɛpek mɛ nyɛ kabɛ Yezu gha tɔ syaab e kaab náá, mɛdhuu mɛ bot ɛzɛgu. ");
INSERT INTO bkw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","E dwoo ɛbyoŋ ɛ emapa di ààbɛ nɛ leviid ɛ, dwoo bɔɔ ebhata e Pak di tsakaa ɛ, eezɛkum. ");
INSERT INTO bkw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yezu eezɛkyeed Pyɛɛd bɛ nɛ Zaŋ pɛ sok. Nyɛy nɛ nɔɔ náá: «Tɔ́ka, kɛkoobalka mena edee e ɛbyoŋ ɛ Pak.» ");
INSERT INTO bkw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tin, bɛ eezɛdji Yezu náá: «Wɔ kwyɛl náá, bis kɛkoobal wɔ di mena aadɛka edee e ɛbyoŋ ɛ Pak wo?» ");
INSERT INTO bkw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Gwakeka, esok bi aakum kɔ dɛl ɛ, bi ɛ waaboma nɛ dhiiti mot nɛ bhe mɛdii kɔ lo. Duka nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","E di nyɛ aadjɛl ɔ, lɛɛka nakuma ndjaa náá: “Lyoel ke ɛ́, bis dji wɔ náá, ndjaa nyɛ aadɛ ɛbyoŋ ɛ Pak tɔ tak bɛ nɛ bɛdjekel bɛ ɛ, wo ee?” ");
INSERT INTO bkw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tin, nyɛ waalyaal bin pɛ ɛko ɛ ndjaa boo dhɛŋ koobela nɛ esa djas tɔ tak. Tin ɛ́ bi aasa esesɛɛ e ɛbyoŋ ɛ Pak.» ");
INSERT INTO bkw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bɛdjekel eezɛtɔ́ pɛ dɛl ɛ tak. Bɛ ka bela djas ɛ dáa Yezu nalɛɛ bɛ ɛ. Bhii tak, bɛ eezɛni é ɛkoobal ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Dáa ɛwala tak nakadjala ɛ, Yezu eezɛdi kɔ mesa bɛ nɛ bot ɛ lwoma. ");
INSERT INTO bkw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nyɛ eezɛke nɛ nɔɔ náá: «Mɛ bɛ ɛ́ mɛ eedyeebakwyɛl náá, mena dɛka ɛbyoŋ ɛ Pak'ak é di wat, ɛsok nɛ náá, mɛ zuk! ");
INSERT INTO bkw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Etɛɛ náá, ye goka ɛ́ mɛ lɛɛ bin náá, mɛ aanàkabaadɛ ɛbyoŋ ɛlak, kana mos, kɛyaka nɛ dwoo ɛsuk ɛ tak aabela lo tɔ Ɛyoŋ ɛ Zɛɛb ɛ. Tin, mɛ waabaadɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nyɛ eezɛnɔɔ bɛɛlɛ nadi nɛ vin tɔ tak ɛ. Bhii tak, nyɛ eezɛghaapɛɛ Zɛɛb, nyɛ eezɛke nɛ nɔɔ náá: «Nɔɔka bɛɛlɛ vin'ak. Kaaka yɛ pak'en, da bi ɛ́ dɛ, ");
INSERT INTO bkw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","etɛɛ náá, egoka ɛ́, mɛ lɛɛ bin, náá, kana mos, kɛyaka nɛ dwoo Ɛyoŋ ɛ Zɛɛb aazyɛ ɛ, mɛ aanàkabaadɛ mɛnyok mɛ vin.» ");
INSERT INTO bkw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bhii tak nyɛ eezɛnɔɔ mapa, baazɛghaapɛɛ Zɛɛb tɔ mendjaala, bhii tak, nyɛ eezɛpyak yɛ, nɔɔ yɛ, djɛ bɛdjekel bɛ. Nyɛy nɛ nɔɔ náá: «Yak ɛ́ nyel'am zekaaa kɔ ɛsu ɛ len ɛ, gheesesaka deenek étɛp bi neetetaala mɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nyɛ eebaazɛdjɛ bɛ bɛɛlɛ tak wat bhis dek. Nyɛy nɛ nɔɔ náá: «Bɛɛlɛ yak ɛ bɛɛlɛ ɛbhɛŋ ɛ na bes nɛ Zɛɛb, ɛbhɛŋ ɛ kwyalel nɛ ghiya yam see kɔ ɛsu ɛ len ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tin, guka náá, mot aaka mɛ ɛ wak, bis nɛ nɛ ɛ́ kɔ mesa yak! ");
INSERT INTO bkw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ye ɛ́ tsɛɛtsɛ náá, Sɛɛŋɛlɛ Mɔn Mot ɛ waagwyɛ, dáa Zɛɛb nazekoobalɛ ɛ. Tinaak, ha kpaa-ghoŋ nɛ mot aakɛka nyɛ ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tin, bɛdjekel moo tin é djinel pak'ɔɔ náá, nwyak mot pak'ɔɔ aakɛka Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bɛdjekel ɛ Yezu moo tin é be mɛso pak'ɔɔ, etɛɛ náá, bɛ nadi kwyɛl ɛgu náá, ɛzɛ di dhil mot pak'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bɛmɛkoozi mɛ bɔs'ak di ààkwyɛl Zɛɛb ɔ djas ɛpekɛ tyee wakoko kɔ lɔɔ. Bot ɛ di nyal bɛ ɔ djóoaa ɛ́, bot ɛ enɛm esa. ");
INSERT INTO bkw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tin, yebɔ yɛ ààgoka nɛ ɛdi ɛ́ deenek. Etɛɛ náá, pɛ yibɔ, mot di boo-mot ɔ, goka nɛ di tɔ bɛsɔ ɛ́, dáa mɔɔ dhyeeb. Deenek, mot ɛ kwyɛl ɛdi dhil mot ɔ, goka ɛ́ nɛ di mot-mɛsa mɛ bɔɔ bɛsɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Etɛɛ náá, ɛzɛ di boo-mot? Ye ɛ́ mot di kɔ mesa ɔ, ohoo mot di be bɛsɔ ɔ? Ye ɛ́ mot di kɔ mesa ɔ, etsal e? Beeka mam ɛ́ tɔ len tyee mot di sa bin mɛsa ɔ! ");
INSERT INTO bkw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bi ɛ́ bot ɛ nadi mɛlu djas e ngwoobam tɔ mbee mɛbhowal ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tyɛ wat nɛ dáa Saag'am nadjɛ mɛ Ɛyoŋ ɛ lɛ ɛ, tyɛ tak wat mɛ ɛpedjɛ bin Ɛyoŋ ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bi ɛ waadɛ edee nɛ mɛdii kɔ mesa yam, tɔ Ɛyoŋ ɛ lam. Bi ɛ waadi kɔ mɛbhóó mɛ mɛkoozi mam étɛp bi neepɛ́ɛ membyak kam nɛ ebá Yisalaɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yezu eezɛke náá: «Simɔŋ, Simɔŋ, gwaka! Satan bɛ ɛ́, nyɛ eebela ze étɛp ɛsyaal ɛ wɔ dáa bhum di syaalaa tɔ zyaagal étɛp ɛdis ezeeza ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tin, ye bɛ ɛ́, mɛ eedjaala étɛp'ɔ, e kaab náá, ɛdum ɛ wɔ di dum koŋ nɛ Zɛɛb ɛzɛkɛwyii. Tin, bula wɔ aabula daa lam ɛ, djɛaa bɔn nyoog ghwyil.» ");
INSERT INTO bkw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pyɛɛd eezɛke nɛ Yezu náá: «Ghɛŋ, e di mɛ di'ak, mɛ eezemyaal ɛtɔ́ membok, nɛghu ɛsyee menabɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Wɔ gwaa Yezu zɛbɔɔza nɛ nɛ náá: «Beta mɛ lɛɛ wɔ, Pyɛɛd, sa di tsɛɛtsɛ ɛ: E pum'ak mos, ɛsok nɛ bɛkuu nɛ kɔk esok ebá, yɛ aabela wóó zeswonal mɛ esok elɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bhii tak Yezu eezɛke nɛ nɔɔ náá: «Esok mɛ nalwom bin bi kɛ ɛsa mɛsa, toto ààbɛ nɛ ekpa, àànɔɔ ngwyɛ epata, àànɔɔ ekoko, ye nabɛ ɛ́ sa wat nasu bin e?» Bɔɔ náá: «Ààbɛ. Bis nabɛ ɛ́ ààsu sa wat.» ");
INSERT INTO bkw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Deenek nyɛ eezɛke nɛ nɔɔ náá: «Nenak e tokapɛ deenek, ye moo ɛ́ náá, ye goka ɛ́ náá, mot di nɛ ngwyɛ epata bɛ ɔ, nɔɔ yɛ. Tyɛ wat nɛ mot di nɛ kpa ɔ, nɔɔ kpaɛ, dɔɔ nɛ mot di ààbɛ nɛ pɛl ɔ, goka ɛ́ nɛ ɛbɔmsa ndjookuwa yɛ étɛp ɛkɛbɔm pɛl. ");
INSERT INTO bkw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Etɛɛ náá, nɛ tsɛɛtsɛ betka mɛ lɛɛ bin náá, ye goka ɛ́ náá, etɛp ee ekwyala nalɛɛ kɔ ɛsu ɛ lam náá: “Nyɛ nalaŋaa tɔ lɔɔg bot ɛ na mbee mɛsa.” Nɛ tsɛɛtsɛ etɛp ee naliiel kɔ ɛsu ɛ lam ɛ, goka ɛ́ yɛ sɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhii tak bɛdjekel eezɛke nɛ nɛ náá: «Ghɛŋ, beea! Bis ɛ́ nɛ epɛl ebá.» Yezu eezɛke nɛ nɔɔ náá: «Yenek, eedjala.» ");
INSERT INTO bkw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yezu eezɛwyis. Nyɛ eezɛtɔ́ pɛ kɔ Ɛtsok ɛ pyeeb oliv, dáa nyɛ nabela nɛ ɛsesa sok ɛ. Bɛdjekel bɛ zokadu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bhis bɛ nakum e di tak ɛ, Yezu ɛ boo ke nɛ bɛdjekel bɛ náá: «Djaalaka Zɛɛb étɛp bi ɛzɛkɛkwyɛ e mɛbhowal.» ");
INSERT INTO bkw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bhii tak nyɛ eezɛtiila ba zii tyee wusa pwak, nyɛ eezɛkwyit mɛboŋ si, nyɛ moo djaala. ");
INSERT INTO bkw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nyɛ nadi é keke tɔ mendjaala mɛ náá: «Saag'am, wɔ kwyɛl ɔ, wɔ ɛ́ nɛ ghwyil ɛdis bɛɛlɛ mezuk mak sok bhwoob'am. Ye nàkoo zo di, ye goka ɛ́ náá, ɛkwosak ɛ lɔ sael, ààkabɛ yam.»  ");
INSERT INTO bkw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tin, wɔ gwaa fofop ngɔt zokadus tɔ gwoo, zɛdjɛ nyɛ mɛghaaz mɛ ɛmaad. ");
INSERT INTO bkw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yezu tɔ bɛbebwol nɛ bwoo, nyɛ eebaazɛnenal nyel tɔ mendjaala. Ediidyok moo tin é pak nyɛ e nyel, é see e bɔs dáa mɛtɔ mɛ ghiya. ");
INSERT INTO bkw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bhis nyɛ nazedjaala ɛ, nyɛ eezɛwyɛl, sik pɛ kyee bɛdjekel bɛ nadi ɛ́. Nyɛ ka kɛbela bɛ bɔɔ djas mendjaa mɛ si é egɔ́ nɛ kwyɛsa ghoŋ nazekwyɛsa bɛ tɔ elyem ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nyɛ eezɛke nɛ nɔɔ náá: «Étɛp yé bi di edja gɔ́? Wyɛlka, da bi ɛ́ djaala étɛp ɛkaab náá, bi ɛzɛkɛkwyee e mɛbhowal.» ");
INSERT INTO bkw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ye nabelaa ɛ́ Yezu dinaa elii, tin, Yudas, ngɔt tɔ bɛdjekel bɛ, eezɛtuula nɛ ɛdhuu ɛ bot. Bhii tak, Yudas eezɛtiila pɛ dáa Yezu étɛp nyɛ neebeedal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tinaak Yezu zokaaake nɛ nɛ náá: «Yudas, ye ɛ́ nɛ mɛbeedela menek ɛ wɔ dika Sɛɛŋɛlɛ Mɔn Mot e?» ");
INSERT INTO bkw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Dáa bot ɛ nadi gyee nɛ Yezu ɔ nabee sa nadi kwyɛl ɛsael é di'enek ɛ, bɛ ɛ́ boozɛdji nyɛ náá: «Ghɛŋ, wɔ ɛpekwyɛl náá, bis lum bɛ nɛ epɛl e?» ");
INSERT INTO bkw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ngɔt pak'ɔɔ zokakwyal mot-mɛsa mɛ boo ghaa-Zɛɛb, zɛtsaal nyɛ ɛlɔ pɛ kyee mbɔ e ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tin, Yezu ɛ́ booke nɛ nɔɔ náá: «Betka, eedjala.» Bhii tak Yezu eezɛmɛt ɛlɔ mot tak, pyoŋ tak eezɛgel. ");
INSERT INTO bkw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bhii tak, Yezu eezɛke nɛ eboo bɛghaa-Zɛɛb, nɛ bɛbaalel ɛ kok Ndjaa-ebuwa zɛnɔɔ bɛpaa ɛ eYuda zyɛ, zɛmɛt nyɛ ɔ. Nyɛ náá: «Bi zyɛ nɛ epɛl nɛ eghwyɛs ɛ́, e kɛ ɛ́ náá, bi zɛmɛt ɛ́ mot djii? ");
INSERT INTO bkw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bi ɛ bee ɔ, mɛlu djas, mɛ nadi ɛ́, nɛ nen tɔ kok Ndjaa-ebuwa. Bi nabɛ ɛ́ ààsaa náá, bi mɛt mɛ. Ghuna yak ɛwala ɛ́ yibɔ, yii ghwyil ɛ ɛgwyitok.» ");
INSERT INTO bkw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dáa bɛ namɛt Yezu ɛ, bɛ eezɛtɔ́ nɛ nɛ pɛ ndjaŋ ɛ boo ghaa-Zɛɛb. Kaa bela tin, Pyɛɛd é du bɛ pɛ bhis koŋ, ba ɛtsetaɛpe nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ye nabɛ ɛ́ bɛ naapaada du kuku ɛbɛsɛɛ peeb. Tin, Pyɛɛd zokazɛdisi é gɔɔl du bɛ nɛ bot ɛ nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Dhiiti moma nadi é sa mɛsa tɔ ndjaa boo ghaa-Zɛɛb ɔ zokazɛbee nyɛ ndiindil egɔɔl du. Moma tak zɛgwyák nyɛ «kpɛɛɛ», nyɛy nɛ nɛ náá: «Mot tak pe nadi ɛ́, bɛ nɛ Yezu!» ");
INSERT INTO bkw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Wɔ gwaa; Pyɛɛd zɛswonal, nyɛ náá: «Mam ààgu nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ba mɔɔ ɛwala bhii tak, dhiiti mot-mɛsa eebaazɛgwyak nyɛ. Mot tak nɛ Pyɛɛd náá: «Dɔɔ nɛ wɔy pe, wɔ ɛ́ mot'ɔɔ.» Tin, Pyɛɛd eezɛbɔɔza nɛ mot tak náá: «Ààbɛ. Ye tok mam.» ");
INSERT INTO bkw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tyee ba ɛwala wat bhii tak, dhiiti baazɛke nɛ ghwyil djas náá: «Ye ɛ́ tsɛɛtsɛ náá, mot tak nadi ɛ́, bɛ nɛ nɛ, etɛɛ náá, nyɛ ɛ́ mot kyee dik Ghalile.» ");
INSERT INTO bkw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tin, Pyɛɛd eezɛbaabɔɔza náá: «Mɛ ààgu sa wɔ di kwyɛl ɛlii enek.» É di'enek, Pyɛɛd dinaa é lii deenek, kuu eezɛkɔk. ");
INSERT INTO bkw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ghɛŋ zokaliig mis, gwyák Pyɛɛd bhii tak mis mɔɔ eezɛboma. É di'enek, Pyɛɛd eezɛtaala sa Ghɛŋ nalɛɛ nyɛ ɛ́: «Ɛsok nɛ kuu nɛ kɔk mos, yɛ aabela ɛ wɔ eezeswonal mɛ esok elɛl.» ");
INSERT INTO bkw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tin, Pyɛɛd eezɛwyis, tɔ́, nyɛ moo tin é djii ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bot ɛ nadi baal Yezu ɔ moo tin é duk nyɛ. Bhii tak bɛ eezɛnyuu nyɛ nɛ eghwyɛs. ");
INSERT INTO bkw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bɛ eezɛbutalɛ kaad kɔ mis. Bhii tak, bɛ moo dji nyɛ náá: «Naŋa! Ɛzɛ nyuu wɔ?» ");
INSERT INTO bkw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tin, bɛ naalee nyɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɔ mɛlem kɛɛŋ, bɛpaa ɛ eYuda, bɛ nɛ eboo bɛghaa-Zɛɛb, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi eezɛsɛɛga. Bɛ eezɛtel Yezu kuku boo kwan ekukuma eYuda, e di etɛp dii pɛ́ɛaa wɔ. ");
INSERT INTO bkw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tin, bɛ eezɛdji nyɛ náá: «Yɛ bɛ náá, wɔ ɛ́ Mɛsia ɔ, lɛɛa bis!» Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛ lɛɛ bin náá, mɛ ɛ́ Mɛsia ɔ, bi aanàkwaamyaal mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mɛ ko dji bin kiya ɔ, bi aanàkwaabɔɔza mɛ. Bi nakoodi ààmyaal, mɛ ɛpelɛɛ bin náá, ");
INSERT INTO bkw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","kan e dwoo ɛlak mos, Sɛɛŋɛlɛ Mɔn Mot aadi ɛ́ ndiindil, tɔ di dék ɛ Zɛɛb na ghaa Ghwyil.» ");
INSERT INTO bkw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E tyɛ enek, bɔɔ djas zɛdji Yezu náá: «Wɔ ɛ́ Mɔn Zɛɛb e?» Yezu zɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ dáa bi zo ke enek. Ye ɛ́ mam.» ");
INSERT INTO bkw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bɛ kaa tsim ɛ náá: «Mena tokapɛ nɛ gwyes nɛ mot aapit nyɛ ɔ. Nɛ tsɛɛtsɛ menabɛl bɛ ɛmet eegwak mɛkpa mɛ nuubɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bot ɛ sɛɛga djas eezɛwyɛl, bhii tak beezɛtɔ́ nɛ nɛ pɛ dáa kukuma Pilat. ");
INSERT INTO bkw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tin, bɛ moo tinaak é su nyɛ etɛp. Bɔɔ náá: «Bis bela mot tak ɛ́, é besal bot ɛ mbyak es bɛ kus ɛghuub. Nyɛ ɛpelu bot náá, bɛ nàdjɛ epata e lapo nɛ Sezaad. Nyɛ ke ɛ́ náá, ye ɛ́ nyɛy ɛ di Mɛsia, e kwyɛl ɛlɛɛ ɛ́: “mɛkoozi”.» ");
INSERT INTO bkw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kukuma Pilat eezɛdji nyɛ náá: «Wɔy ɛ́ di mɛkoozi mɛ eYuda?» Yezu eezɛbɔɔza nɛ nɛ náá: «Ye ɛ́ dáa wɔy wɔ ɛmet ke enek.» ");
INSERT INTO bkw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bhii tak Mɛkoozi Pilat eeke nɛ eboo bɛghaa-Zɛɛb, nɛ ɛdhuu ɛ bot nadi tin ɔ náá: «Mam ààpabee tɛp mɛ di egoka nɛ ɛkwyesal mot tak ndjɛ sɔs nɛ ye ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tin, bɛ eebaazɛben gwood, tsim ɛlyelɛpe náá: «Nyɛ ɛpebesal bot, bɛ kus ɛghuub nɛ kɔkɔ mbi mɛlyo mɛ. Nyɛ nakan nɛ ye ɛ́, pɛ kyee dik Ghalile. Nyɛ eezɛtuula nɛ yɛ kɔ Yude. Ye ɛ́ nyɛ moo nɛ yɛ mos wak'ak.» ");
INSERT INTO bkw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dáa mɛkoozi Pilat nagwak mɛkpa menek ɛ, nyɛ ɛ́ boodji náá: «Mot tak ɛ́ mot Ghalile?» ");
INSERT INTO bkw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tin, bɛ eezɛlɛɛ nyɛ náá, Yezu nadus ɛ́ pɛ kyee dik Elood, nadi kɔk kɔ tak ɛ. Deenek nyɛ eezɛkyeed nyɛ pɛ dáa Elood. Zɛ bela náá, ye nabɛ ɛ́ mɛkoozi Elood naazyɛ, zɛkwyɛɛg ba mɛlu tin tɔ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mɛkoozi Elood naadyeebamyaala ɛbuɛpe dáa nyɛ nabee Yezu ɛ. Etɛɛ náá, ye nabɛ ɛ́, nyɛ naadyeebagwak menduk ɛ Yezu. Nyɛ nadi esaa ɛboma nɛ nɛ. Nyɛ nadi suu ɛ́ náá, Yezu sa dhiiti ndem mɛbwala e mis mɛ, nyɛ neebee. ");
INSERT INTO bkw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tin, nyɛ eezɛdji Yezu bɛtɛ nɛ mɛdjin, Yezu kadi ɛ́, «gwyem» ààbɔɔza. ");
INSERT INTO bkw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Eboo bɛghaa-Zɛɛb nɛ bɛghaŋ ɛ mɛkana mɛ etsi nadi ɛ́, tin, bɛ nadi é su etɛp e mɛpita ɛbuɛpe kɔ lo ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mɛkoozi Elood bɛ nɛ esodja bɛ zokaduk nyɛ, gɔ nyɛ. Bɛ nabee nyɛ ɛ́ tyee ba vaŋ put mot deenek. Bhii tak bɛ eezɛbet nyɛ mbɛɛ wolo kaad, bhii tak bɛ eezɛswaal nyɛ pɛ dáa kukuma Pilat. ");
INSERT INTO bkw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mɛkoozi Elood bɛ nɛ kukuma Pilat nabɛ sok ɛ́, ààgwakel. Dwoo ɛ tak ɛ́ bɛ nakan ɛgwakel pak'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kukuma Pilat eezɛboma e boob bɛ nɛ eboo bɛghaa-Zɛɛb, nɛ ekukuma eYuda, zɛnɔɔ bɛdhiiti bot ɛ dɛl, ");
INSERT INTO bkw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nyɛ eezɛke nɛ nɔɔ náá: «Bi zyɛ mɛ nɛ mot tak ɛ́, etɛɛ náá, nyɛ ɛpebesal bot bɛ kus ɛghuub. Deenek ye bɛ ɛ́ mɛ eedji yɛ taŋal e mis min wak, ka bela náá, mam ààpabee embee etɛp ee bi zɛpit nyɛ étɛp tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mɛkoozi Elood nabɛ ɛ́ ààbela nyɛ nɛ ndjɛ sɔs étɛp tak ɛ́ nyɛ naswaal nyɛ wak. Deenek mot tak ààpasa dhiiti tɛp mena di egoka nɛ ɛgó ɛ nyɛ kɔ ɛsu ɛ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Étɛp tak ɛ́ di náá, mɛ waalwom náá, bɛ nyuu nyɛ nɛ mɛka. Bhii tak da mɛ ɛ́ bet nyɛ.»  ");
INSERT INTO bkw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Eghɛŋ mɛbyoŋ mɛ ePak djas, mɛkoozi Pilat nabɛ ɛ́ nɛ ɛzel ɛ wyisal mot membok ngɔt. ");
INSERT INTO bkw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wɔ gwaa bɔɔ djas zokazɛtsim náá: «Góa nyɛ, da wɔ ɛ́ bet bis Bhaalabas.» ");
INSERT INTO bkw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Zɛ bela náá, Bhaalabas naamɛtaa ɛ́, étɛp nyɛ nagó mot esok bot ɛ mbyak'ɛ nabe boo dho nɛ eLɔm ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Dáa Pilat nakwyɛl ɛbet ɛ Yezu ɛ, nyɛ eebaazɛdji ɛdhuu ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Deenek bot djas zɛtsim ɛlyelɛpe náá: «Bema nyɛ e mɛlaaba! Bema nyɛ e mɛlaaba!» ");
INSERT INTO bkw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat zokazɛbaadji bɛ tyee djia esok elɛl, nyɛ náá: «Mot tak sa yaa ɛbiyo ee? Mɛ ààpabee ghamen bi di é ke náá, nyɛ góaa ɛ. Étɛp tak ɛ́ mɛ ke náá, bɛ nyuu nyɛ nɛ eghwyɛs, da bɛ ɛ́ bet nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ghuna bot nadi ebesal nɛ etsim ɛlyelɛpe náá, nyɛ bemaa e mɛlaaba. Etsim bɔɔ naadhaa Pilat. ");
INSERT INTO bkw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Deenek Pilat zokazɛtsaal tɛp dhen náá, ye kaa sael dáa ɛdhuu ɛ bot kwyɛl ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tin, kukuma Pilat eezɛwyisal mot bɔɔ nadi kwyɛl náá, nyɛ wyisal ɔ. Mot tak namɛtaa ɛ́, etɛɛ náá, nyɛ naabe boo dho, mot zokagwyɛ e dho tak. ");
INSERT INTO bkw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dáa bɛ nadi tɔ́ nɛ Yezu ɛ, wɔ gwaa bɛ zɛboma nɛ Simɔŋ mot dɛl ɛ Silɛn. Nyɛ nadi é dus ye ɛ pɛ pyeeb. Esodja zokamɛt nyɛ, zɛdjɛ nyɛ mɛlaaba nyɛ kwyee Yezu e ɛbɛp ɛ yɛ pɛ bhis koŋ ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Zukamwaa nɛ mot mɛdhuu-mɛdhuu nadi edu bɛ, zɛnɔɔ boa é dje mɛgwyɛ nɛ etaŋal kɔ ɛsu ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tin, Yezu zokazɛliig mis, gwyák bɛ. Nyɛy nɛ nɔɔ náá: «Boa ɛ Yeluzalɛm, nàdjeka kɔ ɛsu ɛ lam! Bi goka nɛ ɛdje ɛ étɛp'en nɛ étɛp bɔɔ bin! ");
INSERT INTO bkw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Dáa di náá, ɛwala mot aake náá: “Mɛnyɔ nɛ boa di náá, bɛ aanàkwaabya ɔ, nɛ bɛkwyiid ɛ boa, zɛnɔɔ boa di ààgu dáa mɔn di djɛaa ɛbel ɛ!” moo ɛ́, yɛ eezekunaa, nɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","É di'enek, bot ɛ waake nɛ mɛtsok náá: “Dha dumaka kɔ les!” Nɛ eghooda náá: “Dha syelka bis!” ");
INSERT INTO bkw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Etɛɛ náá, kwyii le bes saaa deenek, gwyaaza nɛ syeela le? Bɛ aakasa dáa nɛ yɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Esodja baazɛtɔ́ nɛ botom ɛbá, bɛmbee ɛ bot, bɛ neegó bɛ, bɛ nɛ Yezu lɔɔg wat. ");
INSERT INTO bkw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eghɛŋ bɛ nakum e di bɛ di djóo «Bhobho Lo» ɛ, esodja zokazɛbem Yezu e mɛlaaba, nɛ bɛmbee ɛ bot ɛbá, nwyak pɛ mbɔ e ghɛŋ, dhiiti pɛ mbɔ ɛmyɛl. ");
INSERT INTO bkw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yezu ɛ́ boozɛke náá: «Pela bɛ, Saag'am, etɛɛ náá, bɛ ààgu sa bɛ di sa ɛ.» Bɛ eezɛkaa ekaad bɛ, bhis bɛ nazesa ɛgwyeeg ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mɛdhuu mɛ bot nadi ɛ́, tin é bee. Ekukuma e eYuda moo é gɔ nɛ duk ɛ́ nyɛ. Bɔɔ náá: «Nyɛ naatsik bot ɛsis. Nyɛ kaa tsik nyel'ɛ ɛmet, yɛ bɛ náá, nyɛ ɛ́ Mɛsia Zɛɛb natɔ ɔ!» ");
INSERT INTO bkw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Dɔɔ nɛ esodja pe nadi egɔ nɛ ɛduk ɛ nyɛ. Bɛ zokazɛtiila, wɔ gwaa bɛ djɛ nyɛ mɛnyok mɛ na bwaaz-bwaaz. ");
INSERT INTO bkw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bɔɔ nɛ nɛ náá: «Yɛ bɛ náá, wɔ ɛ́ mɛkoozi mɛ eYuda ɔ, tsika nyel'ɔ wɔy wɔ ɛmet!» ");
INSERT INTO bkw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pɛ ɛko ɛ mɛlaaba ɛ Yezu, ye nabɛ ɛ́, bɛ naabɛk mɔɔ pes le kwyala kɔ tak náá: «Mɛkoozi mɛ eYuda ɛ́ nwyak.» ");
INSERT INTO bkw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tɔ bɛmbee ɛ bot ɛbá nabemaa e mɛlaaba ɔ, ngɔt naabyasal Yezu. Nyɛy nɛ nɛ ɛ náá: «Wɔ paalɛɛ náá, wɔ ɛ́ Mɛsia. Deenek, tsika nyel'ɔ tɔ ɛsyee, da wɔ ɛ́ baatsik bisɔ.» ");
INSERT INTO bkw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tinaak dhiiti mbee mot naadjɛ sɔ mɛbɛ. Nyɛy náá: «Wɔ ààkaab Zɛɛb e, é di wɔ di ezuk dáa nyɛy'aak? ");
INSERT INTO bkw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yenabɛl mezuk e goka, etɛɛ náá, mena gwyɛ ɛ́, étɛp embee esesɛɛ bena. Ghuna mot tak nabɛ ɛ́ ààsa ɛbiyo.» ");
INSERT INTO bkw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bhii tak, nyɛ eebaazeke náá: «Yezu, sa wɔ ààdjisa mɛ, dwoo wɔ aaboozyɛ dáa mɛkoozi tɔ Ɛyoŋ ɛ lɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yezu eezɛbɔɔza nɛ nɛ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá: Mos wɔ aadi ɛ́ nɛ nam tɔ dɛl ɛ mɛmyaala.» ");
INSERT INTO bkw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Dáa dwoo nadi e moo kuku mwos ɛ, wɔ gwaa ɛgwyitok zɛgwyiidela kɔ dik djas, kɛkum dwoo e leega. ");
INSERT INTO bkw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ka sɛka ɛ́, boo kaad na pip-pip di é bɛk Dhɛŋ na Dɛɛ nɛ boo koo, tɔ kok Ndjaa-ebuwa ɔ eezɛnyɛɛ kuku tak. ");
INSERT INTO bkw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yezu zokazɛtsim ɛlyelɛpe, nyɛ náá: «Saag'am, mɛ eenɔɔ sisimam, wa tɔ mɛmbɔ mɔ.» Bhis nyɛ nalii mɛkpa menek ɛ, nyɛ eezɛsil eswos. ");
INSERT INTO bkw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dáa kukuma lɔɔg esodja nabee etɛp binek ɛ, nyɛ naaduwal Zɛɛb. Nyɛy náá: «Mɛ bee ɛ́ náá, mot tak nabɛ ɛ́ ààgu tɛp.» ");
INSERT INTO bkw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mɛdhuu mɛ bot ɛ nazyɛ, zɛbee etɛp ee nadi sɛɛ e di tak ɔ, naabee esesɛɛ binek djas. Bhii tak bɛ eezɛsik, mɛmbɔ kɔ elo, nɛ ghoŋ tɔ elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bɛsɔ ɛ Yezu djas nɛ boa nadus bɛ nɛ bɛ nɔɔ pɛ kyee dik Ghalile ɔ, nadi ɛ́, ba ɛtsetaɛpe é bee esa ee nadi sɛɛ ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ye nabɛ ɛ́ nɛ dhiiti mot, din ɛ lɛ Zozɛf. Nyɛ nadi ɛ́, mot dɛl ɛ Alimate dhiiti ghaada eYuda. Nyɛ nabɛ ɛ́ tɛtɛ mot, epiki. Nyɛ nadi ebwood náá, Ɛyoŋ ɛ Zɛɛb zyɛ, ye nàkwyii zo di náá, nyɛ nabɛ ɛ́ mot ngɔt tɔ bot boob ekukuma e eYuda. Nyɛ nabɛ ɛ́ ààmyaal egeka bɔɔ, nɛ ɛsesel bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nyɛ ɛ́ boozɛtɔ́ pɛ dáa Pilat kɛwaab muu ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Bhii tak, Zozɛf zokasil muu ɛ Yezu e mɛlaaba, zɛwol nyɛ tɔ bheeza na puu, zɛnɛɛg nyɛ tɔ ɛvit ɛ bes, yii nakpakaa tɔ gho ɛkok ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ye nabɛ ɛ́ dwoo ɛkoobal esonok étɛp dwoo saba. Tin, nabɛ ɛ́ saba moo aakan. ");
INSERT INTO bkw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Boa nadus bɛ nɛ Yezu pɛ kyee dik Ghalile ɔ eezɛtɔ́ lɔɔg wat bɛ nɛ Zozɛf. Bɔɔ zokabee ɛvit ɛ Yezu nɛ dáa bɛ nanɛɛg muuɛ tɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bhii tak bɛ eezɛsik pɛ ghaada kɛkoobal bɛmul, nɛ bɛmɛnanas étɛp ɛkɛ lɔɔb muu ɛ Yezu. Dwoo saba bɛ eezɛwala dáa etsi di é lɛɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kɛɛŋ tɔ mɛlem mɛ yenga boa zɛtɔ́ pɛ ɛvit. Bɛ natɔ́ ɛ nɛ bɛmul nɛ bɛmɛnanas bɛ nasa ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bɛ ka bee tin ɛ́, ɛkok ɛ nadiila ɛvit nɛ yɛ ɛ moo ɛ́ mbiŋela ɛtsetaɛpe nɛ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dáa bɛ ka ni tɔ ɛvit ɛ, bɛ nabɛ ɛ́ ààkabela muu ɛ Ghɛŋ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Esiiza bɔɔ nadi ɛ́ ye moo mbɛs. É di'enek, botom bɛbá eezɛtuula bɛ, nɛ ekaad e na kas-kas. ");
INSERT INTO bkw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Boa ɛ́ boosil mis pɛ si nɛ bwoo. Botom binɔk eezɛke nɛ nɔɔ náá: «Étɛp yé bi di saa tɔ myoŋ mot di náá, nyɛ ɛ́ nɛ tsik ɔ? ");
INSERT INTO bkw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nyɛ tokapɛ wak; nyɛ eezegom. Siizaka sa nyɛ nalɛɛ bin esok bi nɛ nɔɔ nadi pɛ Ghalile ɛ: ");
INSERT INTO bkw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ye goka ɛ́ náá, bot ɛ mesyem mɛt Sɛɛŋɛlɛ Mɔn Mot, bem nyɛ e mɛlaaba. Bhis mɛlu mɛlɛl, ye goka ɛ́ náá, nyɛ gom.”» ");
INSERT INTO bkw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tin, bɛ eetaala sa Yezu nalii nɛ nɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bhii tak bɛ eezɛdus pɛ mɛvit, sik pɛ dɛl, kɛbaŋa bɛdjekel kam nɛ ngɔt nalik ɔ zɛnɔɔ bak bɛdhiiti bɛdjekel. ");
INSERT INTO bkw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bot ɛ tak nabɛ ɛ́ Maali moma dɛl ɛ Makdala, Zan zɛnɔɔ Maali, nyɛɛg ɛ Zak. Bɛdhiiti boa nadi bɛ nɛ bɛ nɔɔ ɔ, nabaazo zɛlɛɛ bot ɛ lwoma etɛp binek ɛ tyɛ wat nɛ bot ɛ nazɛlɛɛ sok ɔ. ");
INSERT INTO bkw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Deenek, bɛ nabɛ ɛ́ ààdyeebamyaal tɛp tak, bɔɔ nadi gek ɛ́ náá, etɛp ee boa binɔk nadi lɛɛ bɛ ɛ, nabɛ ɛ́ etsal. ");
INSERT INTO bkw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tin, Pyɛɛd zokazɛwyɛl «piya», sum kaab, tɔ́ pɛ ɛvit. Kuma nyɛ nakum e di tak ɛ, nyɛ eezɛmalal, gwyák tɔ ɛvit, ààbee muu. Nyɛ nazobee ɛ ekaad e na puu bɛ napil nyɛ tɔ tak ɛ. Bhii tak nyɛ eezɛnɔɔ nyel, sik pɛ ndjaa é djoka kɔkɔ mbi sa nyɛ bee ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E dwoo tak wat, bɛdjekel nadi etɔ́ pɛ dɛl ɛ Emayus, dɛl ɛ tak na tseta nɛ Yeluzalɛm tyee ba mɛwala mɛmbá goŋ mɛko. ");
INSERT INTO bkw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bot ɛ tak nadi sɔs etɛp djas ee nadhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dáa bɛ nadi kuku kyeed é ɛtaŋal nɛ ɛsɔs ɛ, wɔ gwaa, Yezu nyɛ ɛmet zokazɛtiila pɛ yɔɔ, nyɛ eezɛni e lɔɔg'ɔɔ. Bɛ moo tin é kɛsama wat. ");
INSERT INTO bkw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bɛ nadi bee nyɛ. Tin, ye nabɛ ɛ́ nɛ sa wat nadipal bɛ mis étɛp bɛ needi ààgwyak nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","É di'enek, Yezu eezɛdji bɛ náá: «Ɛyé bi di sɔs biyɔ, é kɛgba-a-gba?» É di'enek, bɛ eezɛtyaa, mɛnyel e teka nɛ eghoŋ tɔ elyem. ");
INSERT INTO bkw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ngɔt pak'ɔɔ, mot nadi djóoaa Keleopat ɔ zokazɛke nɛ nɛ náá: «Pɛ kɔ dɛl ɛ Yeluzalɛm djas, mot di ààgu etɛp ee sɛɛ penek tɔ tsil mɛlu mak ɛ́ wɔy wɔ ɛmet!» ");
INSERT INTO bkw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yezu eezɛdji bɛ náá: «Ha yé sɛɛ penek?» Bɛ eezɛbɔɔza nɛ nɛ náá: «Sa nasɛɛ dum nɛ Yezu mot dɛl ɛ Nazalɛt ɛ! Nyɛ nabɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb ngɔt nɛ mɛbwala ɛbuɛpe. Nyɛ naalyaal yɛ tɔ kɔkɔ mɛsa mɛ, nɛ etɛp ee nyɛ nadi lelii é mis ɛ Zɛɛb nɛ e mis mɛ bot djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bot ɛ di kɔ elo eboo bɛghaa-Zɛɛb bina ɔ, nɛ ekukuma bina naaka nyɛ étɛp bɛ neepɛ́ɛ Yezu epɛ́ɛ e ɛsyee, da bhii tak, nyɛ ɛ́ kɛ ɛbemaa ɛ, é mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bis nadi ɛ́, nɛ ɛbwaalel náá, nyɛ nabɛ ɛ́ mot nawaazɛpɛk Yisalaɛl e bhel ɔ. Saabɛgɔs ɛ́ náá, ye moo mos ɛ́ mɛlu mɛlɛl etɛp binek djas nazesɛɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bɛdhiiti boa tɔ ɛdhuu ɛlis eediaadjoka bis. Ye ɛ́ tsɛɛtsɛ náá, ye bɛ ɛ́ bɛ eetɔ́ pɛ ɛvit tɔ ghooghom mɛlem. ");
INSERT INTO bkw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Deenek, bɛ bɛ ààbee muuɛ. Bhii tak bɛ eezɛlɛɛ bis náá, ye bɛ ɛ́, Zɛɛb eebɛɛ bɛ mis mɛ bee efofop. Efofop e tak lɛɛ bɛ náá, Yezu ɛ́ nɛ tsik! ");
INSERT INTO bkw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bɛdhiiti pak'es zokatɔ́ pɛ ɛvit, bɛ ka bela esonok ɛ́ dáa boa binɔk nazolɛɛ. Tin, Yezu nɛ Yezu nyɛ ɛmet ɛ́ di náá, bɛ nabɛ ɛ́ ààbela nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bhis yenek Yezu eebɔɔza nɛ nɔɔ náá: «Bi tok nɛ etsoŋ, etɛɛ náá, ɛlyel ɛ bin nɛ ɛmyaal etɛp djas ee bɛngoolel ɛ mɛkpa ɛ Zɛɛb nakwyal ɛ! ");
INSERT INTO bkw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ye nabɛ ɛ́ ààgoka náá, Mɛsia zuk. Bhii tak ɛ́ nyɛ aaka ni tɔ duma yɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bhii tak nyɛ moo tin é lɛɛ bɛ etɛp ee nalɛɛel dum nɛ nɛ tɔ ekwyala ɛ djas. Nyɛ nakan ɛ́, tɔ etsi ɛ Moiiz, zɛnɔɔ yii ekwyala mɛ bɛdhiiti bɛngoolel ɛ mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dáa bɛ nabɛ, bɛ moo kunaa nɛ dɛl ɛ bɛ nadi é tɔ́ ɛ, Yezu eezɛsa tyee náá, nyɛ nadi dhaa yɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tin, bɛ eezɛbee nyɛ. Bɔɔ nɛ nɛ náá: «Pokosulal menabɛlka wak, etɛɛ náá, dwoo eezesila. Ɛgwyitok moo aagwyiidela.» Tin, nyɛ eezɛmyaal ɛsulal e di wat bɛ nɛ bɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Deenek, bɛ eezɛdisi e mesa bɛ nɛ bɛ nɔɔ, bhii tak nyɛ eezɛnɔɔ tsim mapa, nyɛ eezɛghaapɛɛ Zɛɛb, nyɛ eezɛpyak, nɔɔ yɛ djɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","É di'enek, mis mɔɔ eezɛbɛŋel, bhii tak bɛ eezɛgwyak nyɛ. Tin, wɔ gwaa nyɛ zɛdiib bɛ e mis. ");
INSERT INTO bkw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bɛ moo tin é sɔs pak'ɔɔ náá: «Elyem bɛ mena ààdi dak esok nyɛ di é lii nɛ nena gba-gba ɛ, esok nyɛ di kaada mena sa ekwyala nadi é lɛɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","É di'enek wat, wɔ gwaa bɛ zɛwyɛl «ngbat». Bɛ eezɛsik pɛ Yeluzalɛm, bɛ eezɛbela bɛdjekel kam nɛ ngɔt e di wat bɛ nɛ bɛdhiiti bot ɛ lɔɔg'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bɔɔ é keke náá: «Ye ɛ́ tsɛɛtsɛ náá: Ghɛŋ eegom tɔ ɛsyee! Simɔŋ bɛ ɛ́, nyɛ eebee nyɛ!» ");
INSERT INTO bkw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tin, bɔɔ bɛ ɛmet eezɛni é baŋa bɛ dáa ye nadhaa nɛ nɔɔ pɛ bɛ nadus ɛ, nɛ dáa bɛ nakagwyák Yezu esok nyɛ napyak mapa ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Dwoo tak wat, bikoko, dáa bɛdjekel nadi bɛ dinaa é sɔs pak'ɔɔ ɛ, Yezu nyɛ ɛmet eezɛtuula tɔ lɔɔ. Nyɛy nɛ nɔɔ náá: «Zɛɛb djɛ bin egwyem!» ");
INSERT INTO bkw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bɛdjekel djas moo pwak, bɛ moo ɛ́ nɛ bwoo. Nɛ tsɛɛtsɛ, bɛ nagu ɛ náá, bɛ eebee dim, ghuna ye ɛ́ Yezu. ");
INSERT INTO bkw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yezu ka ke nɛ nɔɔ ɛ náá: «Étɛp yé bi di pwak? Étɛp yé bi di nɛ mɛso? ");
INSERT INTO bkw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gwyákeka meez mam, nɛ mɛko mam. Nɛ tsɛɛtsɛ ye ɛ́ mam. Bwooka mɛ, da bi ɛ́ gwyák mɛ. Dim tok nɛ epuud nɛ egwyes dáa mam, dáa bi di bee'aak.» ");
INSERT INTO bkw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nyɛ eezɛke nɛ nɔɔ deenek. Bhii tak, nyɛ eezɛlyaal bɛ mɛmbɔ nɛ mɛko mɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dáa bɛ nadi bɛ dinaa àànyɔ ɛmyaal náá, Yezu eegom ɛ, tin, Yezu eezɛdji bɛ náá: «Bi ɛ́ nɛ edee e dek wak ee?» ");
INSERT INTO bkw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tin, bɛ eezɛdjɛ nyɛ pes su ndika. ");
INSERT INTO bkw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wɔ gwaa Yezu zɛnɔɔ yɛ náá, dɛ e mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bhii tak nyɛ eezɛke nɛ nɔɔ náá: «É sok mɛ nadi menabɛlka dinaa é di wat ɛ, mɛ nabɛ ɛ́, mɛ naalɛɛ bin náá: “Etɛp ee di kwyala kɔ ɛsu ɛ lam tɔ etsi ɛ Moiiz, nɛ tɔ Mɛkana mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb nɛ tɔ bɛmɛkana mɛ Mɛdjeeb ɛ waasael djas.”» ");
INSERT INTO bkw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yezu ɛ́ boozɛdjɛ bɛ etsoŋ étɛp bɛ neegwak sa nakwyalaa ɛ. ");
INSERT INTO bkw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nyɛy nɛ nɔɔ náá: «Beeka sa ze kwyalel ɛ́: Ye goka ɛ́ Mɛsia zuk, da nyɛ ɛ́ gom bhis mɛlu mɛlɛl. ");
INSERT INTO bkw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ye goka ɛ́ náá, bi tuud bot nɛ din ɛ lɛ pɛ dáa bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ djas, kan pɛ Yeluzalɛm náá, bot liig elyem. Tin, Zɛɛb ɛ waapel mesyem mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Biyɔ ɛ kwaa di bɛtyaasɛs esee ee bi zebee ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Bhii tak, mam ɛmet ɛ waadhis sa Saag'am nakɛk ɛ. Yɛ kabɛ biyɔ bɛ ɛmet ɔ, dika tɔ ghaada, étɛp ɛbwood náá, Zɛɛb djɛ bin ghwyil aadus tɔ gwoo ɛ.» ");
INSERT INTO bkw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bhii tak, Yezu ɛ zɛwyis, bɛ nɛ bɛdjekel bɛ, kɔ ghaada, nyɛ eezɛtɔ́ e ngwoob dɛl ɛ Bhetani. É di'enek, nyɛ ɛ́ boo bin mɛmbɔ pɛ ɛko, zɛsɛɛ bɛ mɛtel. ");
INSERT INTO bkw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Esok nyɛ nadi é sɛɛ bɛ mɛtel ɛ, nyɛ eezɛbɛka nɛ nɔɔ, byet tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","É di'enek, bɛdjekel ɛ́ booduwal nyɛ, bula, zyɛ pɛ Yeluzalɛm tɔ boo mɛmyaala. ");
INSERT INTO bkw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bɛ naaka didi ɛ́ tɔ kok Ndjaa-ebuwa mɛlu djas, étɛp ɛduwal ɛ Zɛɛb.");
INSERT INTO bkw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","«Tɔɔɔ» e mɛkɛn mɛ esonok djas, Mɛkpa nabɛ ɛ e moo tak. Ye nabɛ ɛ bɛ nɛ Zɛɛb, Ye nabɛ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ye ɛ́ tsɛɛtsɛ náá, e mɛkɛn «tɔɔɔ», Mɛkpa nadi ɛ́, é di wat bɛ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Esonok djas di kɔ bɔs ɛ, nakusel ɛ nɛ Mɛkpa. Ye tok nɛ sa wat kɔ bɔs'ak Mɛkpa nadi ààkus. ");
INSERT INTO bkw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tsik nadus ɛ pɛ tɔ lɛ. Deenek, tsik tak naasa náá, bot djas nyen popoopwon tɔ gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Gwyes ɛpekas, djɛ boo gwyɛ e di mɛghomla nadi ɛ́. Tin, mɛghomla kadi ɛ́ ààkwak ɛsaab yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ye nabɛ ɛ nɛ dhiiti mot Zɛɛb nadhis ɔ. Din ɛ mot tak nabɛ ɛ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nyɛ nazyɛ ɛ́ tyee tyaasɛs etɛp ɛzɛlyo bot dum nɛ gwyɛ. Etɛɛ náá, bot djas needum koŋ nɛ Zɛɛb kɔ ɛsu ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zaŋ nyɛy nyɛ ɛmet nabɛ ààbɛ gwyɛ tak. Deenek, nyɛ nazyɛ ɛ́ tyee tyaasɛs etɛp ɛzɛlyo bot dum nɛ gwyɛ tak. ");
INSERT INTO bkw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɛkpa mɛ tak nabɛ ɛ sim gwyɛ na tsɛɛtsɛ. Ye nabɛ ɛ tɛtɛ gwyɛ di djɛ bot djas eselele ɛ. Ye nazyɛ kɔ bɔs ɛ, ye neezɛdjɛ bot gwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Deenek, Mɛkpa naazyɛ pɛ kɔ bɔs, ye ɛ́ nyɛy ɛ nakus bɔs. Tin, bot ɛ bɔs'ak ààpakamyaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mɛkpa naazyɛ tɔ bot ɛ mbyak'ɛ. Ye ka bela náá, bot ɛ mbyak'ɛ naabyen ɛmyaal ɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","É di'enek, bot djas aamyaal nyɛ ɔ, bot aadum koŋ nɛ nɛ ɔ, Mɛkpa aadjɛ bɛ ghwyil ɛdi ɛ bɔɔ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Deenek, bot ɛ tak waabyel. Bɛ aanàkwaabyel byela ghiya. Ààbɛ byela di dus tɔ gwyes epuud ɛ. Ààkobaabɛ bɛa byela nɛ ɛkwosak ɛ mot. Ye ɛ́ ɛbyel ɛ byelaa nɛ ɛkwosak ɛ Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mɛkpa nadi e moo mot. Mot tak naazɛbe di tɔ lena. Mena naabeeka mɛkas mɛ, ye ɛ́ mɛkas mɛ sɛɛŋelɛ sim Mɔn di bela nɛ Sɛɛg ɛ. Lwoodela nɛ enɛm nɛ embɛɛ ɛ Zɛɛb nɛ etsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zaŋ naakan ɛdi ɛ́ tyee tyaasɛs etɛp ɛlyo bot dum nɛ nɛ. Nyɛ nadi e tuud náá: «Ye ɛ́ kɔ ɛsu ɛ lɛ ɛ mɛ nadi keke náá: “Mot di zyɛ bhis mam ɔ, nyɛ eedhaa mɛ. Etɛɛ náá, ɛsok nɛ mam nɛ byel, nyɛ nadi ɛ́ tak.”» ");
INSERT INTO bkw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nɛ tsɛɛtsɛ náá, mena naabelaka bɛtɛ nɛ ekum bɛ. Nyɛ naakɛl kɔ lena enɛm nɛ embɛɛ bɛ yak kɔ yii. ");
INSERT INTO bkw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ye ɛ́ tsɛɛtsɛ náá, Zɛɛb naadjɛ mena etsi nɛ Moiiz. Deenek, Zɛɛb ka baadhis mena enɛm nɛ embɛɛ nɛ etsɛɛtsɛ nɛ Yezu Klisto. ");
INSERT INTO bkw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ye tok nɛ mot ngɔt nabee Zɛɛb sok. Sɛɛŋɛlɛ sim mɔn'ɛ ɛmet, nyɛy mot di Zɛɛb ɔ, nyɛ diɛ e di wat bɛ nɛ Sɛɛg. Ye ɛ́ Mɔn ɛ di lyaal bot Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","EYuda e ghaada Yeluzalɛm naalwom bɛdhiiti bɛghaa-Zɛɛb nɛ bɛdhiiti bot ɛ di sa mɛsa tɔ kok Ndjaa-ebuwa. Bot ɛ tak ɛ nakɛ ɛ dji Zaŋ Nduuel-bot náá: «Wɔy ɛ yɔ zɛ ee?» ");
INSERT INTO bkw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nyɛ naazɛlɛɛ bɛ nɛ etsɛɛtsɛ náá: «Ààbɛ, mam tok Mɛsia.» ");
INSERT INTO bkw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhii tak, bɛ eezɛdji nyɛ náá: «Bha wɔy ɛ́ zɛ? Wɔ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb Eli?» Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Ààbɛ! Mɛ ɛ tok Eli.» Bɛ eebaazɛdji nyɛ náá: «Ye ɛ́ wɔy ɛ di ngoolel-mɛkpa ɛ Zɛɛb di bwoodaa ɛ?» Nyɛ eebaazɛbɔɔza nɛ nɔɔ náá: «Ààbɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","É di'enek, bɛ eezɛdji nyɛ náá: «Ah wɔy ɛ́ zɛ? Etɛɛ náá, bis ɛ sikɔ ɔ, bis neekɛlɛɛ bot ɛ dhis bis ɔ. Wɔy nakuma nyel ke náá, wɔ ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nyɛ eezɛbɔɔza náá: «Mɛ ɛ́ gwood mot di tuud pɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ náá: “Koobalka mɛze ɛ Ghɛŋ, ye di looba-looba!”» Dáa ye di kwyala tɔ mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tin, bot ɛ nalwomaa pɛ daa Zaŋ ɔ, nabɛ ɛ bot ɛ ɛdhuu ɛ eFalizyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Deenek, bɛ eebaazɛdji nyɛ náá: «Etɛp yé wɔ di duu bot Zɛɛb, yɛ bɛ náá, wɔy tok Mɛsia, ààbɛ Eli, ààbaabɛ dhiiti ngoolel-mɛkpa ɛ Zɛɛb ɔ?» ");
INSERT INTO bkw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zaŋ eezɛbɔɔza nɛ nɔɔ náá: «Mam duu bin Zɛɛb ɛ, pɛ tɔ mɛdii. Tin, tɔ ɛdhuu ɛ len, ye ɛ́ nɛ mot ngɔt bi di ààgu ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Mot di zyɛ bhis'am ɔ, nyɛ eedhaa mɛ nɛ mɛbwala. Mam aanàkwaakobela-belak duu ɛmalal étɛp ɛkotii-tiiak ekel e ekoko bɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Etɛp bak djas sɛɛ tin ɛ, pɛ ghaada Bhetani, pɛ yii kiid dii Yuldɛn. Ye ɛ́ pɛ kyee Zaŋ Nduuel-bot nadi duu bot Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tɔ yak mɛlem, Zaŋ ka bee ɛ Yezu é zyɛ pɛ daa lɛ. Tin, Zaŋ eezɛke náá: «Beeka mɔɔ bhata Zɛɛb e. Ye ɛ́ nyɛy ɛ di dis mesyem mɛ bot ɛ bɔs djas. ");
INSERT INTO bkw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ye ɛ́ dum nɛ nɛ mɛ nalɛɛ náá: “Mot di zyɛ bhis koŋamɔ ɔ, nyɛ eedhaa mɛ. Etɛɛ náá, ɛsok nɛ mam nɛ zyɛ, nyɛ nadi ɛ́ tak.” ");
INSERT INTO bkw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mam nabɛ ààdi é gu náá, nyɛ Mɛsia. Tin, mam nazyɛ, zɛduu bot Zɛɛb tɔ mɛdii ɛ́. Etɛp mɛ neelyaal bot ɛ Yisalaɛl nya.» ");
INSERT INTO bkw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zaŋ boo zɛkaada sa nyɛ nabee ɛ. Nyɛy náá: «Mɛ eebee Sisim Zɛɛb é dus tɔ gwoo sul pɛ si dáa ɛghum, bhii tak Sisim tak eezɛtyaa kɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kɛkum dwoo ɛlak mos, mam nabɛ ààdi gu náá, nyɛ ɛ́ Mɛsia. É di'enek, ye ɛ́ mot ɛ nadhis mɛ náá, mɛ zɛduu bot Zɛɛb tɔ mɛdii ɔ nalii nɛ nam. Nyɛ nake nɛ nam ɛ náá: “wɔ waabee Sisim é dus tɔ gwoo sul zɛdi kɔ mot. Bhii tak Sisim tak ɛ zɛtyaa kɔ lɛ. Ye ɛ́ nyɛy ɛ́ aapaduu bot Zɛɛb nɛ Sisim na Dɛɛ.” ");
INSERT INTO bkw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mam eebee yɛ nɛ mis mam met. Etɛp tak ɛ mɛ di baŋa bin ye ɛ́. Ye ɛ́ mot tak, nyɛ ɛ́ Mɔn Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yak ɛlu bhii tak, Zaŋ dinaa é di'enek wat, bɛ nɛ bɛdjekel bɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Dáa nyɛ nabee Yezu é dhaŋ ɛ, nyɛ eezɛke nɛ bɛdjekel bɛ náá: «Beeka mot di mɔɔ bhata ɛ Zɛɛb ɔ!» ");
INSERT INTO bkw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bɛdjekel bɛ bɛbá eezɛgwak deenek, wɔ gwaa bɛ zɛdu Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Wɔ gwaa Yezu zɛliig mis, gwyák pɛ bhis, dáa nyɛ nabee náá bɛdjekel binɔk nadi du nyɛ ɛ́, nyɛ ɛ́ booke nɛ nɔɔ náá: «Bi saa yé?» Bɛ eezɛbɔɔza nɛ nɛ náá: «Labhi! Wɔ dyeebadi paa?» Labhi kwyɛl ɛlɛɛ ɛ: Lyoel. ");
INSERT INTO bkw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Dhaaka etɛp bi neezɛbee.» Bhii tak bɛ eezɛdu nyɛ, bɛ eezɛtɔ́, kɛbee sum di Yezu nadidi ɔ. Tin, bot binɔk zokaadi bɛ nɛ Yezu e di wat dwoo tak. Ye nabɛ ɛ́ dwoo eezeleega moo tyee ɛwala ená. ");
INSERT INTO bkw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andele, dhyeeb ɛ Simɔŋ Pyɛɛd, nabɛ ɛ mot ngɔt pak bɛdjekel ɛbá binɔk nagwak lii ɛ Zaŋ, da bhii tak bɛ ɛ́ du Yezu ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andele nakɛleeboma ɛ́ nɛ tel Simɔŋ. Nyɛ ɛ́ boolɛɛ nyɛ náá: «Bis eebela Mɛsia!» Nyɛ nadi eke deenek ɛ etɛɛ náá, din ɛ Mɛsia kwyɛl ɛlɛɛ: Klisto. ");
INSERT INTO bkw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bhii tak nyɛ eezɛdul nyɛ pɛ dáa Yezu. Dáa Yezu nabee nyɛ, nyɛ ɛ́ booke nɛ nɛ náá: «Wɔ ɛ Simɔŋ, mɔɔ Zaŋ. Wɔ aakadjóoaa ɛ Kefas.» E kwyɛl ɛlɛɛ ɛ́: Pyɛɛd. ");
INSERT INTO bkw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","E yak dhiiti dwoo, Yezu nadi kwyɛl ɛtɔ́ pɛ kyee dik Ghalile. Tin, nyɛ eezɛboma nɛ dhiiti mot di djóoaa Filip ɛ. Nyɛy nɛ nɛ náá: «Dua mɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nadi ɛ́, mot Bhɛtsaida, ghaada ɛ Andele bɛ nɛ Pyɛɛd. ");
INSERT INTO bkw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip eezɛkaada etɛp binek nɛ mɔɔ sɔ Natanaɛl. Nyɛy nɛ nɛ náá: «Bis eebela mot Moiiz nakwyal dum nɛ nɛ tɔ mɛkana mɛ etsi ɔ. Ye ɛ́ mot bɛngoolel ɛ mɛkpa ɛ Zɛɛb nabaalii kɔ ɛsu ɛ lɛ ɔ. Yezu mot dɛl ɛ Nazalɛt, mɔɔ Zozɛf.» ");
INSERT INTO bkw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaɛl eezɛke nɛ nɛ náá: «Tɛtɛ sonok ɛ nɛ ghwyil ɛ tuula pɛ Nazalɛt e?» Filip ɛ́ boobɔɔza nɛ nɛ náá: «Dha, wɔ neezɛbee.» ");
INSERT INTO bkw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Dáa Yezu nakabee Natanaɛl é zyɛ pɛ daa lɛ ɛ, nyɛ ɛ́ booke nɛ nɛ náá: «Nɛ tsɛɛtsɛ beeka mot dɛl Yisalaɛl di ààgu mɛkɔŋ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaɛl eezɛdji náá: «Wɔ gu mɛ dáa?» Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Ɛsok nɛ náá, Filip djóo wɔ, e bɛ ɛ́, mɛ zebee wɔ. Wɔ di ɛ́, pɛ si le di djɛ bhum fiigh ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaɛl eezɛbɔɔza, nyɛy nɛ nɛ náá: «Labhi! Wɔ ɛ́ Mɔn Zɛɛb! Wɔ ɛ́ mɛkoozi mɛ Yisalaɛl!» ");
INSERT INTO bkw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yezu eebaazɛbɔɔza nɛ nɛ náá: «Wɔ dum koŋ nɛ nam ɛ́, etɛɛ náá, mɛ eelɛɛ wɔ náá: “Mɛ bɛ ɛ́, mɛ eebee wɔ é ghɛŋ wɔ di si le fiigh ɛ.” Wɔ waabee esonok dhaa yii wɔ di ebee'aak.» ");
INSERT INTO bkw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yezu eebaazɛlɛɛ nyɛ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: bi ɛ waabee gwoo diia, efofop e Zɛɛb é byet nɛ sul kɔ Sɛɛŋɛlɛ Mɔn Mot.» ");
INSERT INTO bkw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mɛlu mɛlɛl bhii tak, ye nabɛ ɛ nɛ ɛbá pɛ dɛl ɛ Kanan, pɛ kyee dik Ghalile. Nyɛɛg ɛ Yezu nadi ɛ́ tin. ");
INSERT INTO bkw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ye nabɛ ɛ Yezu bɛ nɛ bɛdjekel bɛ naadjóoaa pɛ ɛbá ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dáa mɛnyok nabɛ náá, ye naawyii ɛ, nyɛɛg ɛ Yezu ɛ́ booke nɛ Yezu náá: «Bɛ tokapɛ nɛ mɛnyok.» ");
INSERT INTO bkw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tin, Yezu ɛ́ boozɛbɔɔza nɛ nyɛɛg náá: «Wɛɛ moma, yenabɛl mɛsɔ ɛ ye e tɛp'ak? Ɛwala ɛ lam dinaa ààpaakum.» ");
INSERT INTO bkw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Deenek nyɛɛg eezɛke nɛ bot ɛ mɛsa náá: «Saka sa djas nyɛ aalɛɛ bin náá, bi sa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ghuna e di'enek, ye nabɛ ɛ nɛ mɛbhe mɛ mɛkok etɛn nɛ wat. Mɛbhe mɛ tak nadi tin ɛ ɛtɛɛ náá, eYuda neesa mɛzel mɛ ɛdis edhuuda nɛ yɛ dáa etsi ɛ Moiiz nalɛɛ bɛ ɛ. Mɛbhe mɛ tak ɛ nɛ ghwyil ɛnɔɔ bhɛɛb mɛdii mɛkam-mɛtɛn nɛ elɛl nɛghu dhet nɛ mɛkam-mɛmbá etɛɛ náá, ye neelwood. ");
INSERT INTO bkw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tin, Yezu eezɛke nɛ nɔɔ náá: «Lwoodalka mɛbhe menek nɛ mɛdii.» Wɔ gwaa bɛ zɛlwoodal, kum pɛ ka. ");
INSERT INTO bkw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bhii tak Yezu eezɛke nɛ nɔɔ náá: «Daaka yɛ batsa, da bi ɛkɛdjɛ mot di lii etɛp e ɛbyoŋ ɔ, étɛp nyɛ neebowal.» Bɛ eezɛtɔ́ nɛ yɛ daa mot tak. ");
INSERT INTO bkw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Dáa mot tak nabowal mɛdii mɛ zeliigel moo mɛnyok ɛ, nyɛ nadi ɛ́ ààgu pɛ mɛnyok mɛ tak nadus ɛ. Etɛɛ náá, ye nazobɛ ɛ bot ɛ mɛsa mɛ nalwoodal mɛbhe ɔ bɔɔ bɛ ɛmet ɛ nadi gu pɛ kyee ye nadus ɛ. Mot'enɔk ɛ́ boodjóo motom nadi é ba ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nyɛ ɛ́ booke nɛ nɛ náá: «E mɛbyoŋ, bot djas dyeebadjɛ sok ɛ, tɛtɛ mɛnyok na nyeenyɔnyɔ. Da bhii tak, yii di ààdyeebanyɔ ɛ, ka djɛaa ɛ bhis bot ɛ di, bɛ moo tɔ elangi ɔ. Ghuna wɔ bɛ ɛ wɔ eekwom mbɛɛ mɛnyok étɛp ye needɛaa nenak ɛbhis.» ");
INSERT INTO bkw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yenek nabɛ ɛ ndem mɛbwala yii ɛsok Yezu nasa pɛ dɛl ɛ Kanan pɛ kyee dik Ghalile. Deenek ɛ Yezu nalyaal duma nyɛ nadi nɛ ye ɛ́. É di'enek, ye nabɛ ɛ, bɛdjekel bɛ nadum koŋɔ ɔ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bhis yenek, nyɛ eezɛtɔ́ pɛ ghaada Kapɛlnaum bɛ nɛ nyɛɛg, nɛ mɔn nyɛɛg zɛnɔɔ bɛdjekel bɛ. Bɛ naadhaa ba bim mɛlu penek. ");
INSERT INTO bkw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɛbyoŋ ɛ Pak eYuda nabɛ ɛ́ ye moo kunaa, Yezu eezɛtɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nyɛ kazɛbela tɔ kok Ndjaa-ebuwa ɛ, bot ɛ nadi bɔmsa engɔmbɛ, etaa, nɛ mɛghum, dɔɔ nɛ bot ɛ nadi swoola epata ɔ mendiindil kɔ emesa bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tin, Yezu eezɛlóo ghwyɛs nɛ ekel, nyɛ ɛ́ boo zɛsɔ bɔɔ djas tɔ kok Ndjaa-ebuwa, dɔɔ nɛ etaa nɛ engɔmbɛ bɔɔ. Nyɛ eezɛmwas epata nɛ ɛwaaz emesa e bot ɛ nadi swoola epata ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nyɛ eezɛke nɛ bot ɛ nadi bɔmsa mɛghum ɔ náá: «Diska esa bak wak! Nà liigka ndjaa Saag'am náá, ye didi zɛɛga bot ɛ di bɔmsa esa ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tin, bɛdjekel bɛ eetaala náá, ekwyala lɛɛ náá: «Mɛkwyɛla mɛ mɛ di nɛ yɛ dum nɛ ndjaŋ'ɔ ɛ, ɛpegoo mɛ tɔ lyem dáa du.» ");
INSERT INTO bkw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","E kukuma eYuda eezɛke nɛ nɛ náá: «Yaa kɔkɔ ndem mɛbwala wɔ aatel bis, étɛp bis neemyaal náá, wɔ ɛ nɛ ghwyil ɛsa dáa wɔ di esa'aak?» ");
INSERT INTO bkw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tin, Yezu eezɛbɔɔza náá: «Bwakeka Ndjaa-ebuwa yak, bhii tak, tɔ mɛlu mɛlɛl, mɛ waabaawyɛl yɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tin, eYuda eezɛswonal, bɔɔ nɛ nɛ náá: «Daawee? Sonok étɛp ɛsum ɛ Ndjaa-ebuwa yak, ye nabɛ ɛ́, ye naabɔya membu mɛkam-mɛná nɛ etɛn nɛ wat. Wɔy lɛɛ náá, wɔ ɛ nɛ ghwyil ɛsum yɛ tɔ mɛlu mɛlɛl!» ");
INSERT INTO bkw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ghuna Ndjaa-ebuwa Yezu nadi lii ɛ, nabɛ ɛ́ nyel'ɛ met. ");
INSERT INTO bkw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bhis ɛgom Yezu, bɛdjekel bɛ naazɛtaala sa nyɛ nake ɛ. É di'enek, bɛ naazɛmyaal e etɛp ee nadi kwyala tɔ mɛkana mɛ Zɛɛb ɛ, nɛ etɛp ee Yezu nadi lɛɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","E sok Yezu nadi, nyɛ dinaa pɛ Yeluzalɛm ɛ, e ɛbyoŋ ɛ Pak, bot ɛbuɛpe naadyeebadum koŋ nɛ din ɛ lɛ. Etɛɛ náá, bɛ nadi bebee endem e mɛbwala mɛ nyɛ nadi sesa ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tin, Yezu nabɛ ààbɛ nɛ ɛbwaalel nɛ nɔɔ. Etɛɛ náá, nyɛ nadi gu bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Bela náá, nyɛ nabɛ ààbɛ nɛ gwyes náá, mot zɛlɛɛ nyɛ sa bot binɔk di ɛ, etɛɛ náá, nyɛ nadi gu sa nadi tɔ lyem mot nɛ mot ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tɔ sama eFalizyɛ, ye nabɛ ɛ́ nɛ dhiiti mot, din ɛ lɛ nabɛ ɛ́ Nikodhɛm. Nyɛ nadi ɛ́, ngɔt pɛ tɔ ekukuma eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wɔ gwaa nyɛ zokazɛzyɛ pɛ daa Yezu e pum. Nyɛ eezɛke nɛ nɛ náá: «Labhi, bis nɛ gu náá, Zɛɛb ɛ nadhis wɔ pɛ daa les etɛp wɔ neezɛlyo bis. Etɛɛ náá, mot tok nɛ ghwyil ɛsa endem e mɛbwala mɛ wɔ di sa yenek, yɛ di ààbɛ náá, Zɛɛb ɛ nɛ nɛ sama ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yezu eezɛbɔɔza nɛ nɛ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ wɔ ɛ náá: Mot ɛ di ààbyel byela na bes ɔ aanàkwaabee Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodhɛm eezɛke nɛ nɛ náá: «Mot waabaabyel-byelak na bes dáa, mot moo yɛ paa-mot? Nyɛ ɛ́ nɛ ghwyil ɛ́ baani tɔ mɔ nyɛɛg, da nyɛ ɛ́ baabyel byela sis e?» ");
INSERT INTO bkw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yezu eezɛbɔɔza náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ wɔ ɛ náá: mot ɛ di ààbyel nɛ mɛdii nɛ Sisim na Dɛɛ byela sis ɔ, nyɛ aanàkwaabee Ɛyoŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mot ɛ byel, byela tɔ epuud ɔ, nyɛ ɛ́ mot epuud. Mot ɛ byel, byela tɔ Sisim na Dɛɛ ɔ, nyɛ ɛ́ mot sisim. ");
INSERT INTO bkw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nà djoka, etɛɛ náá, mɛ eeke nɛ nɔ náá, “Bi goka nɛ ɛbyel ɛ, byela na bes.” ");
INSERT INTO bkw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pup kɛe ze nyɛ di kwyɛl ɛ. Tin, wɔy ɛpegwak ghuula tak. Deenek, kabela ɛ náá, wɔ ààgu pɛ ye dus ɛ, nɛ pɛ ye di tɔ́ ɛ. Ye dyeebadi ɛ, tyee wat nɛ bot ɛ zebyel tɔ Sisim ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodhɛm eezɛke nɛ nɛ náá: «Yenek aasael dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yezu eezɛbɔɔza nɛ nɛ náá: «Wɔy ɛ́ boo lyoel kɔ Yisalaɛl. Wɔ ààgu etɛp binek e? ");
INSERT INTO bkw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ wɔ ɛ náá, bis dyeebalɛɛ ɛ etɛp ee bis di gu ɛ. Bis baŋa bot ɛ etɛp ee bis nabee nɛ mis mis ɛ. Tin, biyɔ, bi ààmyaal etɛp ee bis di lɛɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Bi ɛ di ààmyaal mɛ, esok mɛ di lyo bin etɛp e bɔs ɛ. Ha bi aamyaal dáa, yɛ bɛ náá, mɛ moo lɛɛ bin etɛp ee di tɔ gwoo ɛ? ");
INSERT INTO bkw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ye tok nɛ mot aabyet ni tɔ gwoo yɛ di ààbɛ mot nadus tɔ gwoo ɔ. Mot tak ɛ, Sɛɛŋɛlɛ Mɔn Mot. ");
INSERT INTO bkw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Deenek ɛ di náá, dáa Moiiz nadi nyɛ dinaa tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, nyɛ naatsel nyɔ e le. Tin, nyɛ eezɛben yɛ pɛ ɛko. Tyɛ wat, ye goka ɛ́ náá, Sɛɛŋɛlɛ Mɔn Mot tselaa e le. ");
INSERT INTO bkw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Etɛɛ náá, deenek ɛ, mot kwaadum koŋ nɛ nɛ ɔ, nyɛ aabela tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Zɛɛb naadyeebakwyɛl bot kɔ bɔs. Ye ɛ́ nyɛ nadhis sɛŋɛlɛ mɔn'ɛ met. Etɛɛ náá, mot kwaadum koŋ nɛ nɛ ɔ needi ààgwyɛ. Nyɛ goka nyɛ bela tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Etɛɛ náá, Zɛɛb nabɛ ààdhis Mɔn'ɛ kɔ bɔs étɛp ɛpɛ́ɛ ɛ bot. Nyɛ nadhis Mɔn'ɛ étɛp bot ɛ bɔs neebela tsik kɔ ɛsu ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mot aadum koŋ nɛ nɛ ɔ, yenɔk mot aanàkwaakwyeselaa ndjɛ sɔs. Tin, mot aadi ààdum koŋ nɛ nɛ ɔ, yenɔk eezelookwyeselaa ndjɛ sɔs. Nyɛ aapɛɛaa, etɛɛ náá, nyɛ nabɛ ɛ́, nyɛ eepɛɛ ɛdum ɛ koŋ nɛ Mɔn Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«Beeka dáa Zɛɛb aapɛ́ɛ bot ɛ. Mɛkas naazyɛ kɔ bɔs. Tin, bot ɛ bɔs kakwyɛl yɔbɔ ɛbuɛpe ɛ ghooghom dhaa mɛkas. Etɛɛ náá, bɛ nadi ɛ́ bot ɛ embee mɛsa. ");
INSERT INTO bkw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bot djas di sa embee mɛsa ɔ, bɛ ààkwyɛl mɛkas. Deenek, mot tak ààkwyɛl ɛtɔ́ pɛ gwyɛ di ɛ. Etɛɛ náá nyɛ ɛpekaab náá, embee etɛp bɛ ɛzɛkɛnyen na “ngbɛlɛlɛ” emis mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tin, mot di ekɛ dáa etsɛɛtsɛ di lɛɛ ɛ, nyɛ ɛpetiila tɔ ngel gwyɛ. Etɛɛ náá, mɛsa mɛ nyɛ di sa sama nɛ Zɛɛb ɛ neenyen popoopwon emis mɛ bot djas.» ");
INSERT INTO bkw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bhii tak, Yezu eezɛtɔ́ pɛ kyee dik Yude bɛ nɛ bɛdjekel bɛ. Bɛ eezɛbe di penek. Tin, nyɛ nadi eduu bot Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","É ghɛŋ tak, pɛ dɛl ɛ Enɔn e ngwoob dɛl Salim, Zaŋ nabaadi pe ɛ, eduu bot Zɛɛb penek etɛɛ náá, pɛ kyee dik tak nabɛ ɛ́ nɛ mɛdhii ɛbuɛpe. Tin, bot ɛbuɛpe nadi ezyɛ, zɛduwa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Etɛp binek djas nasɛɛ, Zaŋ dinaa ààkɔɔla e mbok. ");
INSERT INTO bkw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tin, bɛdhiiti bɛdjekel ɛ Zaŋ nadi é be mɛso bɛ nɛ dhiiti mot dhaad mbyak eYuda. Mot tak nadi lii ɛ dum nɛ dáa mot di egoka nɛ ɛsa étɛp nyɛ needis edhuud da bula dɛɛ e mis ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wɔ gwaa bɛ zokazyɛ pɛ daa Zaŋ, bɛ eezɛke nɛ nɛ náá: «Labhi, é sok mena nadika pɛ yii kyiid dii yuldɛn ɛ, ye nabɛ ɛ́, wɔ naalii nɛ nɛ nes kɔ ɛsu ɛ mot ngɔt. Beea! Mot tak ɛpeduu bot Zɛɛb, deenek bot djas ka tɔ́ ɛ penek pɛ daa lɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zaŋ eezɛbɔɔza nɛ nɔɔ náá: «Dhiiti mot tok nɛ ghwyil ɛbela duu sis, bhis yii Zɛɛb zedjɛ nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Biyɔ bɛ ɛmet nadi ɛ́ tak, esok mɛ nalɛɛ náá: “Mɛ tok Mɛsia ɛ. Mam ɛ mot Zɛɛb nanyɛl ɛdhis ɛsok nɛ nɛ ɔ.” ");
INSERT INTO bkw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mot di nakuma moma ba ɔ, yɛ ngom. Tin, mɔɔ sɔ motom ba moma ɔ di é di'enek é gwak gwoodɛ ɔ. Nyɛ ɛ́ tɔ mɛmyaala ɛbuɛpe dáa nyɛ gwak gwood motom ba ɔ. Tyɛ wat mɛmyaala menek ɛ mɛ mɛmyaala mam. Mɛmyaala mɛ tak eebela ɛsuk. ");
INSERT INTO bkw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ye goka ɛ́ náá, duma ɛ Yezu byet ɛbyet nɛ ɛbyet, da yam ɛ sila. ");
INSERT INTO bkw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Mot dus pɛ ɛko ɔ, nyɛ eedhaa bot djas. Mot di kɔ bɔs ɛ mot bɔs, nyɛ lii ɛ, etɛp e bɔs. Deenek ɛ, di náá, mot dus pɛ ɛko ɔ, nyɛ eedha bot djas. ");
INSERT INTO bkw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nyɛ nɛ dyeebalɛɛ bot esesɛɛ ee nyɛ di bee ɛ, yii nyɛ di gwak ɛ. Tin, bot ààkwyɛl ɛmyaal etɛp ee nyɛ di lii nɛ nɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mot di myaal etɛp ee nyɛ di lɛɛ ɛ, baamyaal ɛ náá, yɛ nɛ tsɛɛtsɛ náá, Zɛɛb lɛɛ ɛ etsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Etɛɛ náá, mot Zɛɛb lwom ɔ, dyeebalii ɛ etɛp e Zɛɛb. Etɛɛ náá, Zɛɛb naadjɛ nyɛ ghwyil Sisim na Dɛɛ djas. ");
INSERT INTO bkw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","«Sɛɛg nɛ kwyɛl Mɔn. Étɛp tak ɛ nyɛ nadjɛ nyɛ eghɛŋ nɛ ghwyil kɔ esonok djas. ");
INSERT INTO bkw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mot ɛ dum koŋ nɛ Mɔn ɔ, yenɔk ɛ waabela tsik na kɔm-kɔm. Tin, mot di ààdum koŋ Mɔn ɔ, yenɔk aanàkwaabela tsik na kɔm-kɔm. Deenek, ɛbuk ɛ Zɛɛb ɛ pɛ kɔ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Bot ɛbuɛpe nadi esaa náá, Yezu duu bɛ Zɛɛb. Tin, Yezu nyɛ ɛmet nabɛ ààdi duu bot ɛ tak Zɛɛb. Ye nabɛ ɛ́ bɛdjekel bɛ ɛ́ nadi duu bot Zɛɛb. Eghɛŋ sama bot ɛ eFalizyɛ nagwak náá, Yezu nadi duu bot ɛbuɛpe dhaa Zaŋ ɛ, wɔ gwaa bɛ zɛsa mbee lyem. ");
INSERT INTO bkw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Eghɛŋ Yezu nagwak bot é lii deenek ɛ, nyɛ naazɛdus pɛ kyee dik Yude, nyɛ ɛ́ zokazɛsik pɛ kyee dik Ghalile. ");
INSERT INTO bkw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","É di'enek, ye nazogoka ɛ nyɛ dhaa pɛ ze kyee dik Samali. ");
INSERT INTO bkw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nyɛ eezɛkum e ngwoob dhiiti ghaada nadi djóoaa Siikaad pɛ kyee dik tak ɛ. Ghaada tak nabɛ ɛ́ e ngwoob pyeeb ɛ Zakɔɔb nadjɛ mɔn Zozɛf ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","E di tak, ye nabɛ ɛ́ nɛ guk mɛdii ɛ Zakɔɔb. Dáa nabela náá, Yezu nabɛ ɛ́ nyɛ eezewak nɛ kyeed ɛ. É di'enek, nyɛ eezɛnɔɔ nyel disi e ngwoob guk mɛdii. Ye nabɛ ɛ́ dwoo moo tyee kuku gwoo. ");
INSERT INTO bkw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Bɛdjekel eezɛtɔ́ pɛ dɛl kɛsaa edee. Bhii tak, dhiiti moma Samali eezɛzyɛ zɛdaa mɛdii. Wɔ gwaa Yezu zokazɛwaab mɛdii nɛ nɛ. Nyɛy náá: «Djɛ mɛ mɛdii mɛ dek.» ");
INSERT INTO bkw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Moma tak eezɛbɔɔza nɛ nɛ náá, «Wɔy ɛ mot dhaad mbyak eYuda. Ekan dáa, étɛp wɔ neewaab mɛdii nɛ mam moma dhaad mbyak Samali?» Tinaak, nyɛ nake deenek ɛ etɛɛ náá, bot ɛ mbyak eYuda ààgwakel nɛ bot ɛ mbyak Samali. ");
INSERT INTO bkw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","É di'enek, Yezu ɛ́ boozɛbɔɔza nɛ nɛ náá: «Wɔ ɛpedi ɛ́ di gu sa Zɛɛb aadjɛ wɔ ɛ. Wɔ ɛ pe baadi gu mot di ke nɛ nɔ náá: “Djɛ mɛ mɛdii, mɛ dek” ɔ. Pe wɔy ɛ waab mɛdii nɛ nɛ. É di'enek, nyɛ waadjɛ wɔ mɛdii mɛ di djɛ tsik ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Moma yenɔk eezɛke: «Ghɛŋ! Wɔ tok nɛ sanoŋ ee wɔ aadaa mɛdii nɛ yɛ. Guk nɛ dim. Ha wɔ aabela mɛdii mɛ di djɛ tsik wo? ");
INSERT INTO bkw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","«Wɔ kwyɛl ɛlɛɛ náá, wɔ ɛ́ boo-mot, dhaa bhaabes Zakɔɔb mot nadjɛ bis guk mɛdii mɛ tak ɔ? Tin, ye nabɛ ɛ́, nyɛ eedɛ mɛdii mɛ tak nyɛy nyɛ ɛmet, zɛnɔɔ bɔɔ bɛ, nɛ mɛsaa mɛ bɛtit ɛ nyɛ nadi wyel ɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Bot djas aadɛ mɛdii mak ɔ, bɛ waabaabela gwyes ɛdɛ mɛdii. ");
INSERT INTO bkw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tin, mot aadɛ mɛdii mɛ mɛ aadjɛ nyɛ ɔ, mot tak aanàkwaabaagwak gwyes mɛdii. Etɛɛ náá, mɛdii mɛ mam aadjɛ nyɛ ɛ́ waaliigel tɔ lɛ sɔɔgɔ mɛdii na kɔm-kɔm ee di ààgel ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Moma yenɔk eezɛke nɛ nɛ náá: «Ghɛŋ, djɛ mɛ mɛdii mɛ tak. Djɛ mɛ étɛp mɛ needi ààbaagwak gwyes mɛdii, mɛ needi ààbaazezyɛ zɛdaa mɛdii wak.» ");
INSERT INTO bkw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yezu eeke nɛ moma tak náá: «Tɔ́a, kɛdjóo ngom'ɔ, da bi ɛ bula wak.» ");
INSERT INTO bkw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tin, moma yenɔk eezɛbɔɔza náá: «Mɛ tok nɛ ngom.» É di'enek, Yezu ɛ́ bookazɛke nɛ nɛ náá: «Wɔ ɛ nɛ gham nɛ ɛke ɛ náá, wɔ tok nɛ ngom. ");
INSERT INTO bkw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Etɛɛ náá, wɔ naaba botom ɛtɛn. Motom wɔ di nɛ nɛ yenɔk tok ngomɔ. É di'enek, wɔ bɛɛ wɔ eelɛɛ sa di náá, ye ɛ́ tsɛɛtsɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Moma yenɔk eezɛke nɛ Yezu náá: «Ghɛŋ, mɛ bee ɛkɛ ɛ náá, wɔ ɛ ngoolel-mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bɛbhaab bis, bot ɛ Samali naduwal Zɛɛb ɛ kɔ ɛtsok ɛ ɛlak. Yɛ kabɛ biyɔ eYuda ɔ, bi ke ɛ náá: “Di di egoka nɛ ɛdjaalaa Zɛɛb ɛ pɛ Yeluzalɛm.”» ");
INSERT INTO bkw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yezu eezɛbɔɔza nɛ nɛ náá: «Wɛɛ moma, myaala sa mɛ di elɛɛ'aak. Ɛwala ɛpezyɛ, ɛwala di náá, bot aanàbaakɛduwal Zɛɛb Sɛɛg pɛ kɔ ɛtsok ɛ ɛlak nɛghu pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Biyɔ bot ɛ Samali, bi dyeebaduwal ɛ Zɛɛb bi di ààgu ɛ. Yɛ kabɛ bisɔ eYuda ɔ, bis duwal ɛ Zɛɛb bis di gu ɛ. Etɛɛ náá, tsik ɛ étɛp bisɔ eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tin, guka náá, ɛwala ɛpezyɛ, ɛwala ɛ tak eezekum, ɛwala bɛtɛtɛ bɛduwalel aaduwal Sɛɛg pɛ tɔ sisim nɛ tɔ etsɛɛtsɛ ɛ. Etɛɛ náá, binɔk ɛ bɛtɛtɛ bɛduwalel ɛ Zɛɛb di kwyɛl ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Etɛɛ náá, Zɛɛb ɛ sisim. Étɛp tak ɛ di ɛnyɔ náá, bot ɛ di duwal nyɛ ɔ, duwal nyɛ pɛ tɔ sisim nɛ tɔ etsɛɛtsɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Moma eebaazɛke nɛ Yezu náá: «Mɛ nɛ gu náá, Mɛsia di djóoaa “Klisto” ɔ waazyɛ. E sok nyɛ aazyɛ ɛ́, nyɛ waazɛlɛɛ bis esa binek djas». ");
INSERT INTO bkw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tin, Yezu eezɛke nɛ nɛ náá: «Mam, mot di elii nɛ nɔ'aak, ye ɛ́ mam ɛ di Mɛsia.» ");
INSERT INTO bkw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","É di'enek, bɛdjekel bɛ eezɛtuula. Bɛ moo tin é djoka etɛɛ náá, bɛ naazɛbela Yezu é lii nɛ moma tak. Tin, mot ngɔt pak'ɔɔ nabɛ ààdji náá: «Wɔ saa ye?» Nɛghu: «Kɔ ɛsu ɛ ye wɔ di é lii bi nɛ moma yak?» ");
INSERT INTO bkw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bhii tak, moma tak zɛlik bhe ɛdaa mɛdii mɛ, nyɛ eezɛnɔɔ nyel'ɛ sik pɛ ghaada. Nyɛ moo tin é ke nɛ bot náá: ");
INSERT INTO bkw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Dha beeka dhiiti mot eelɛɛ mɛ etɛp ee mɛ nadi esa djas ɛ. Mɛ bee ɛ náá, mot tak ɛ di Mɛsia!» ");
INSERT INTO bkw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bot ɛ ghaada tak eezɛghɛɛ, tɔ́ kɛbee Yezu pɛ nyɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","É di'enek, bɛdjekel bɛ eezɛbesal nyɛ náá, nyɛ dɛ edee. Bɔɔ náá: «Labhi, dɛa edee!» ");
INSERT INTO bkw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tin, nyɛ eezɛke nɛ nɔɔ náá: «Mɛ ɛpedɛ mbi edee ee di náá, bi ààgu ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tin, bɛdjekel moo tin é djinel pak'ɔɔ náá: «Dhiiti mot bɛ ɛ́ nyɛ eezyɛ nyɛ nɛ edee bhis koŋ'ena?» ");
INSERT INTO bkw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","É di'enek, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Edee bam ɛ ɛsa ɛ mɛsa mɛ Zɛɛb. Nyɛ ɛ́ nadhis mɛ náá, mɛ sa mɛsa mɛ kɛkum ɛsik ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Biyɔ bɛ ɛmet bi nɛ dyeebakan kana yak: “Ye ka lik ɛ bɛngɔn ɛná, étɛp ɛkɛ dis edee ee ze kwak tɔ epyeeb ɛ.” Mam ka lɛɛ bin ɛ náá: benka mis min, da bi ɛ gwyák mɛbhek min, yɛ eezesɔk, etɛɛ náá, ye neekɛdisaa tɔ epyeeb. ");
INSERT INTO bkw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mot di sa mɛsa mɛ ɛdis edee tɔ pyeeb ɔ, nɛ bela yɛ etuud djala nɛ mɛsa mɛ nyɛ sa ɛ. Nyɛ ɛpesɛɛg mɛbhek. Mɛbhek mɛ tak ɛ, bot djas aabela tsik na kɔm-kɔm ɔ. Deenek etɛɛ náá, mot di bɛ bhek ɔ nɛ mot di dis edee tɔ pyeeb ɔ neemyaala bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","É di'enek, kana di ke náá: “Dhiiti mot ɛpebɛ bhek; nwyak tak ɛzɛ bɔ́k bhum tak ɛ.” Ye ɛ́ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Etɛɛ náá, mɛ eelwom bin, bi tɔ́ kɛ ɛdis mɛbhek, tɔ e di di náá, bi nabɛ ààbɛ mɛbhek mɛ tak ɛ. Bɛdhiiti bot ɛ nazesa mɛsa. Biyɔ ka bɛ ɛ́ bot ɛ zyɛ zɛdɛ edee mɛsa mɛ mezuk mɔɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bɛtɛɛ nɛ bot ɛ Samali yii dɛl ɛlenek naadyeebadum koŋ nɛ Yezu ɛbuɛpe. Bɛ namyaal nyɛ ɛ́ kɔ ɛsu etɛp moma yenɔk nalɛɛ bɛ ɛ. Eghɛŋ nyɛ nadi eke náá: «Dha beeka dhiiti motom eelɛɛ mɛ etɛp ee mɛ di sa djas ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bhii tak, dáa bot ɛ Samali nazɛbela Yezu tin ɛ, bɛ eezɛke nɛ nɛ náá: «Nàkabaadhaa. Zoka di wak.» Tin, Nyɛ eezɛdja mɛlu mɛmbá bɛ nɛ bɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tin, bɛtɛ nɛ bot naazɛdum koŋ nɛ Zɛɛb ɛbuɛpe, kɔ ɛsu ɛ mɛkpa mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tin, bɛ ɛ́ boozɛke nɛ moma yenɔk náá: «E di mena kadi wak nenak'aak, bis ààpadum koŋ nɛ nɛ etɛɛ náá, wɔ nalɛɛ bis. Bis ka myaal ɛ, etɛɛ náá, bis eegwak bisɔ bɛ ɛmet. Bis eegu náá, ye ɛ́ tsɛɛtsɛ náá, nyɛ ɛ́ mɛtsik-bot, kɔ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Bhis mɛlu mɛmbá menek, Yezu eezɛdus kɔ dɛl ɛ tak, nyɛ eezɛsik pɛ kyee dik Ghalile. ");
INSERT INTO bkw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nyɛ nadi esa deenek ɛ́, etɛɛ náá, nyɛy nyɛ ɛmet naalɛɛ náá: «Ngoolel-mɛkpa ɛ Zɛɛb ààduwalaa kɔ dɛl ɛ nyɛ nabyel ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dáa nyɛ nakum pɛ Ghalile, bot ɛ kyee dik tak naabe nyɛ ɛnyɔɛpe. Bɛ naabee sa nyɛ nasa tɔ ɛbyoŋ pɛ Yeluzalɛm ɛ. Etɛp tak ɛ, bɛ nadi myaala nɛ Yezu ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bhii tak Nyɛ eezɛsik pɛ ghaada Kana pɛ kyee dik Ghalile. Kana ɛ ghaada nyɛ naliig mɛdii moo mɛnyok ɛ. Pɛ ghaada Kapɛlnaum, ye nabɛ ɛ́ nɛ dhiiti boo kukuma esodja ɛ mɛkoozi. Mɔn'ɛ nadi bɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nyɛ nagwak náá, ye nabɛ ɛ́ Yezu eezedus pɛ kyee dik Yude tɔ́ pɛ Ghalile. Nyɛ eezɛtɔ́ pɛ daa lɛ. Nyɛ eezɛdjaala nɛ nɛ náá: «Geka mɛ ghoŋ! Dha! Mɔn'am ɛpebɛ́ ɛkpaŋɛpe. Nyɛ moo ɛ́ pak ɛsyee nɛ tsik. Dha tsik nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yezu eezɛbɔɔza nɛ nɛ náá: «Bi ɛ di ààbee endem e mɛbwala nɛ mɛvyɛkɛlɛ ɔ, bi aanàkwaadum koŋ nɛ nam.» ");
INSERT INTO bkw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kukuma tak eezɛke nɛ Yezu náá: «Ghɛŋ, lela ɛzyɛ pɛ daa lam étɛp mɔn'am ɛzɛkɛgwyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yezu eezɛke nɛ nɛ náá: «Sika pɛ ndjaŋ'ɔ. Mɔn'ɔ eetsak.» Tin, mot'enɔk eezɛmyaal sa Yezu nalɛɛ nyɛ ɛ́. Nyɛ eezɛtɔ́. ");
INSERT INTO bkw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dáa nyɛ nadi, nyɛ dinaa e ze ɛ, wɔ gwaa bot ɛ mɛsa mɛ zɛboma nɛ nɛ, bɛ eezɛlɛɛ nyɛ náá: «Mɔn'ɔ ɛ nyel ɛnyɔɛpe nɛ tsik.» ");
INSERT INTO bkw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tin, nyɛ eezɛdji bot ɛ mɛsa mɛ náá: «Nyɛ tsak e yaa ɛwala?» Bɛ eezɛbɔɔza náá: «Koko e ɛwala ɛsok bhis ɛwala ɛ dwoo di tyaa tɔ gwoo ɛ, mɛkosa nasi nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tin, kukuma tak eezɛgwyak náá, ye nabɛ ɛ́ e ɛwala Yezu nake nɛ nɛ náá: «Mɔn'ɔ ɛ nɛ tsik» ɛ. Tin, nyɛ eezɛdum koŋ nɛ Zɛɛb, bɛ nɛ bot ɛ mɛbyel mɛ djas. ");
INSERT INTO bkw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yenek nabɛ ɛ́ ndem mɛbwala yii esok ebá Yezu nasa bhis nyɛ nadus pɛ Yude tɔ́ pɛ kyee dik Ghalile ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bhii tak, ye nabɛ ɛ́ nɛ dhiiti ɛbyoŋ ɛ eYuda. Tin, Yezu ɛ́ boobyet tɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pɛ Yeluzalɛm, e ngwoob ɛbɛɛ nadi djóoaa «ɛniel bhata» ɛ, ye nabɛ ɛ́ nɛ dhiiti boo tok ɛgwyia nadi djóoaa tɔ lii ebhele, Betɛsdha ɛ. E di tak, ye nabɛ ɛ́ nɛ bɔɔ mɛbhaaz mɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Tɔ mɛbhaaz mɛ tak, ye nabɛ ɛ́ nɛ bɛtɛ nɛ membel mendjaamesi. Bot ɛ mɛbɛ́ mɛ tak nabɛ ɛ́, bot ɛ edhim, bɛ na edjam, bot ɛ mɛnyel nazesɔɔb bɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","É di'enek, ye nabɛ ɛ́ nɛ dhiiti mot nazebɔya nɛ ɛbɛ́ ɛ nyel nazesɔab ɔ membu mɛkam-mɛlɛl nɛ membu mɛtɛn nɛ elɛl. ");
INSERT INTO bkw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Dáa Yezu nabee nyɛ ndjaasi ɛ, nɛ dáa nyɛ nagu náá, nyɛ eeloozebɔya nɛ ɛbɛ́ ɛ tak ɛ. Nyɛ ɛ́ boozɛdji nyɛ náá: «Wɔ ɛpekwyɛl ɛtsak e?» ");
INSERT INTO bkw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tin, mot ɛbɛ́ ɛlɛnɔk eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, mɛ tok nɛ mot ghɛɛg mɛ tɔ boo tok ɛgwyia bhis mɛdii aadheegel ɛ. E sok djas mɛ di saa náá, mɛ tɔ́ kɛghaaga ɛ, ye dyeebabela ɛ mot sis eezeghaaga ɛsok nɛ nam.» ");
INSERT INTO bkw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","É di'enek, Yezu eezɛke nɛ nɛ náá: «Wyɛla, nɔŋa mwaala yɔ, da wɔ ɛ kɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","É di'enek, mot yenɔk eezɛtsak. Nyɛ eezɛghɛɛ mwaala yɛ, nyɛ moo kɛ. Tin, etɛp binek nasɛɛ ɛ dwoo saba. ");
INSERT INTO bkw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bhii tak, ekukuma eYuda eezɛke nɛ mot natsikaa ɔ náá: «Wɔ aagoka nɛ ɛghɛɛ mwaala yɔ mos. Etɛɛ náá, mos ɛ dwoo saba.» ");
INSERT INTO bkw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Mot tsik mɛ ɔ lɛɛ nɛ nam ɛ náá: “Ghɛɛa mwaala yɔ, da wɔ ɛ kɛ!”» ");
INSERT INTO bkw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bɛ eezɛdji nyɛ náá: «Yenɔk ɛ nyɔaa mot lɛɛ wɔ náá: “Ghɛɛa mwaala yɔ, da wɔ ɛ kɛ”?» ");
INSERT INTO bkw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tin, mot natsikaa ɔ nabɛ ààgwyak mot natsik nyɛ ɛ́. Etɛɛ náá, ye nabɛ ɛ́, Yezu naazesyela tɔ ɛdhuu nadi é di'enek ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ba mɛwala bhii tak, Yezu eezɛboma nɛ nɛ tɔ kok Ndjaa-ebuwa. Nyɛ eezɛke nɛ nɛ náá: «Beea! Wɔ eezetsak. Sa wɔ ààbaasa mesyem e kaab náá, dhiiti mbee sonok ɛzɛkɛbaabela wɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tin, mot yenɔk eezɛtɔ́, wɔ gwaa nyɛ kɛlɛɛ nɛ eYuda náá, ye ɛ́ Yezu ɛ natsik nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Etɛp tak ɛ, eYuda nadi esaa dáa bɛ sa etɛp bɛ neetiig Yezu. Bɛ nakwyɛl ɛsa deenek ɛ etɛɛ náá, Yezu natsik mot yenɔk ɛ dwoo saba. ");
INSERT INTO bkw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Deenek, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛlu djas, Saag'am ɛpesa mɛsa, dɔɔ nɛ mam pe, mɛ ɛpesa mɛsa.» ");
INSERT INTO bkw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kɔ ɛsu ɛ etɛp binek, ekukuma eYuda nadi esaa dáa sa étɛp bɛ neegó nyɛ. Bɛ nadi sa deenek ɛ etɛɛ náá, Yezu nabɛ ɛ́ ààdi nɛ duu nɛ dwoo saba. Nyɛ baadi ke ɛ náá, Zɛɛb ɛ Sɛɛgɛ met. Nyɛ nabaakeke ɛ náá, nyɛ tyɛ wat nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yezu eezɛlii nɛ nɔɔ náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ náá: Mɔn tok nɛ ghwyil ɛsa dhiiti sonok nɛ ɛkwosak ɛ lɛ. Nyɛ dyeebabee ɛ mɛsa mɛ Sɛɛg di zyɛ nɛ sa sok ɛ. Tin, nyɛ zokasaa deenek. Sa Sɛɛg di sa ɛ, Mɔn pe nɛ sa yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bela náá, Sɛɛg nɛ kwyɛl Mɔn. Tin, nyɛ ɛ́ boo di eelyaal nyɛ esesɛɛ djas nyɛ di sa ɛ. Tin, nyɛ waalyaal nyɛ eboo esonok dhaa yii bi di bee'aak, etɛɛ náá, bi needjoka ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Etɛɛ náá, Sɛɛg nɛ gomal bot tɔ ɛsyee, da djɛ bɛ tsik na kɔm-kɔm. Deenek ɛ di náá, Mɔn'ɛ pe nɛ djɛ tsik nɛ mot nyɛ aakwyɛl ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sɛɛg ààpɛ́ɛ bot, etɛp nyɛ naadjɛ Mɔn eghɛŋ e ɛpɛ́ɛ ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ye nagoka ɛ deenek, bot djas needuwal Mɔn, dáa Mɔn di duwal Sɛɛg ɛ. Etɛɛ náá, Saag'am ɛ nadhis mam mɔn'ɛ. Mot di ààduwal mɔn'ɛ ɔ, nyɛ ààduwal Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«Tsɛɛtsɛ nɛ tsɛɛtsɛ mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: Mot di gwak mɛlyo mam, da nyɛ ɛ́ dum koŋ nɛ mot nadhis mɛ ɔ, nyɛ waabela tsik na kɔm-kɔm. Tin, yenɔk aanàkwaapɛ́ɛaa, deenek, nyɛ eezedus tɔ ɛsyee, ni pɛ tɔ tsik. ");
INSERT INTO bkw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tsɛɛtsɛ nɛ tsɛɛtsɛ, mɛ lɛɛ bin ɛ náá, ɛwala ɛpezyɛ, ɛwala ɛ tak eezekum: ɛwala bot ɛ nazegwyɛ ɔ aagwak gwood ɛ Mɔn Zɛɛb. Tin, bot djas aagwak gwood tak ɔ bɛ waabela tsik. ");
INSERT INTO bkw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yɛ waasɛɛ etɛɛ náá, tyee wat nɛ dáa Sɛɛg di nɛ tsik ɛ, deenek, Zɛɛb eedjɛ mam mɔn pe ghwyil ɛ djɛ tsik. ");
INSERT INTO bkw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Deenek, Zɛɛb naadjɛ nyɛ eghɛŋ ɛpɛ́ɛ ɛ bot, etɛɛ náá, nyɛ ɛ́ Sɛɛŋɛlɛ Mɔn Mot. ");
INSERT INTO bkw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sa mot ààdjoka. Etɛɛ náá, ɛwala bot ɛ nazegwyɛ ɔ ɛpezyɛ, ɛwala di náá, bɛ aagwak gwood ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Bhii tak bɛ waawyis tɔ mɛvit mɔɔ. Bot ɛ nasa enɛm esa ɔ, bɛ waagom tɔ ɛsyee etɛp ɛdi tɔ tsik. Tin, bot nɛ sa embee mɛsa ɔ waagom etɛp bɛ neezɛkwyeselaa ndjɛ sɔs. ");
INSERT INTO bkw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Mam tok nɛ ghwyil ɛsa esonok dáa lyem'am di kwos ɛ. Mɛ pɛ́ɛ ɛ, dáa Saag'am di lɛɛ náá, mɛ pɛ́ɛ ɛ. É di'enek, epɛ́ɛ ɛ mɛ aapɛ́ɛ bot ɛ, yɛ waadiɛ, tɔ epiki, etɛɛ náá, mam ààsaa ɛkwosak ɛ lam. Mɛ saa ɛ ɛkwosak ɛ mot nalwom mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Mɛ lɛɛ bin sa mɛ di gu kɔ ɛsu ɛ lam ɔ, bot aanàkwaamyaal sa mɛ aalɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ye ɛ́ dhiiti mot ɛ di lɛɛ bot etɛp ee mɛ di sa ɛ. Tin, mɛ nɛ gu náá, etɛp ee nyɛ di lɛɛ bot kɔ ɛsu ɛ lam ɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ye nabɛ ɛ́, bi naalwom bɛngoolel ɛ mɛkpa men pɛ daa Zaŋ. Tin nyɛ naalɛɛ bin etɛp ee etsɛɛtsɛ dum nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yɛ bɛ mam ɔ, mɛ tok nɛ gwyes náá, mot lɛɛ bot sa mɛ di ɛ́, nɛ esa ee mɛ di sa ɛ. Tin, mɛ lii etɛp bak ɛ, étɛp bi neetsak. ");
INSERT INTO bkw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zaŋ nabɛ ɛ́ dáa lambi di tuubel, da ye ɛ́ wa bot djas tɔ eselele gwyɛ ɛ. Deenek bi nabɛ ɛ́ bi eemyaala ba ɛwala wat tɔ eselele gwyɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Guka náá, mam ɛ nɛ boo lɛŋ e ɛkaada dhaa Zaŋ. Etɛɛ náá, mɛsa mɛ Saag'am djɛ mɛ náá mɛ sa ɛ, ye ɛ́ mɛsa mɛ tak ɛ di lyaal bot, mot mɛ di ɛ. Ye ɛ́ di lyaal bot náá, Saag'am ɛ nadhis mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Deenek, Saag'am, mot nalwom mɛ ɔ, nyɛy nyɛ ɛmet di kɛm nɛ ɛlyaal ɛ bot kɔkɔ mbi mot mɛ di ɛ. Bi dinaa ààpaakogwak-gwakak gwood'ɛ. Bi dinaa ààpaakobee-beeak bhwoob'ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Bi ààgwak mɛkpa mɛ, étɛp tak ɛ bi di ààdum koŋ nɛ mot nyɛ nadhis ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Bi ɛpewa lyem tɔ ɛdjek ɛ mɛkana mɛ Zɛɛb. Bi bwaal ɛ náá, tɔ ɛwa ɛ zii e mɛdjek mɛ bi di djek ɛ, bi ɛ waabela tsik na kɔm-kɔm. Tin, guka náá, ekwyala binek ɛ di lii nɛ ɛlɛɛ nɛ bot, mot mɛ di ɛ, nɛ mɛsa mam. ");
INSERT INTO bkw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sonok náá, etɛp binek djas nabɛ ɛ́ tsɛɛtsɛ. Bi kadi ɛ, ààkwyɛl ɛzyɛ pɛ daa lam, etɛp bi neebela tsik! ");
INSERT INTO bkw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Mam aanàsaa náá, bot djɛ mɛ duu. ");
INSERT INTO bkw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tin, mɛ nɛ gu náá, kwyɛl Zɛɛb tok tɔ elyem bin. ");
INSERT INTO bkw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Saag'am ɛ nalwom mɛ, etɛp mɛ zɛsa mɛsa mɛ nɛ eghɛŋ bɛ. Bi kadi ɛ, ààmyaal mɛ. Tin, dhiiti mot ɛ zyɛ nɛ ghwyil ɛ met ɔ, bi ɛ waamyaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Biyɔ di náá, mot nɛ mot saŋ ɛ́ yɛ duu nyɛ ɛmet yenek. Bi ààsaa duu di dus pɛ daa Zɛɛb nyɛy nyɛ ɛmet ɛ. Bi aakwak ɛdum koŋ nɛ nam dáa? ");
INSERT INTO bkw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«Sa mot ààgek náá, mam ɛ waakɛpit bin pɛ dáa Saag'am. Mot aakɛpit bin ɔ, yɛ aadi ɛ́ Moiiz, mot bi nawa ɛbwaalel ɛlen kɔ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","É di'enek, guka náá, bi ɛpedi ɛ́, di myaal Moiiz ɔ, pe bi myaal mɛ etɛɛ náá, Moiiz nakwyal ɛ kɔ ɛsu ɛ lam. ");
INSERT INTO bkw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tin, bi ɛ di ààmyaal sa Moiiz nakwyal ɔ, ha bi aamyaal mɛlyo mam dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bhii tak, Yezu eezɛtɔ́ pɛ yii kyeed boo soob na djato-djato kyee dik Ghalile. Boo soob tak baadjóoaa ɛ Tibeliaad. ");
INSERT INTO bkw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wɔ gwaa zukamwaa nɛ mot zɛdu nyɛ, etɛɛ náá, bɛ nadi ebee endem e mɛbwala mɛ nyɛ nadi é sa nɛ ɛtsik ɛ membel ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tin, Yezu eezɛbyet kɔ ɛtsok. Bhii tak nyɛ eezɛnɔɔ nyel disi bɛ nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Eghɛŋ tak, ye nabɛ ɛ́ dwoo Pak, ɛbyoŋ ɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dáa Yezu naben mis bee náá, bot mɛdhuu mɛdhuu nadi zyɛ pɛ pak nyɛ nadi ɛ́. Nyɛ ɛ́ boozɛke nɛ Filip náá: «Mena kɛbɔm emapa etɛp bot bak needɛ ɛ paa?» ");
INSERT INTO bkw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nyɛ nake nɛ Filip deenek ɛ́, etɛp nyɛ neebee dáa nyɛ aasa ɛ. Etɛɛ náá, nyɛy nyɛ ɛmet nadi gu dáa nyɛ aasa étɛp bɛ needɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip eezɛbɔɔza náá: «Nɛ edeniye bɛdhet ɛbá bis tok nɛ ghwyil ɛbɔm emapa aadjala nɛ dek bot bak djas ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Mot ngɔt tɔ bɛdjekel bɛ, yɛ din ɛ nabɛɛ Andele. Nyɛ nadi ɛ́ dhyeeb ɛ Simɔŋ Pyɛɛd, nyɛy zokazɛke nɛ Yezu náá: ");
INSERT INTO bkw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Tɔ sama bot ɛ di wak'ak, ye ɛ́ nɛ mɔɔ ngbaaz ngɔt di nɛ emapa etɛn, zɛnɔɔ bɔɔ bɛsu ɛ ɛbá. Yenek aakosa yé nɛ zukamwaa nɛ mot ɛ di wak'ak?» ");
INSERT INTO bkw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tin, Yezu eezɛke náá: «Dhilka bɛ si mendiindil.» E di tak, ye nabɛɛ, nɛ mɛso-mɛgwyii, ɛbuɛpe ee bot aadi kɔ tak ɛ. Tin, bɛ eezɛnɔɔ mɛnyel, disi. Bot ɛ nadi tin ɔ nabɛɛ tyee botom bɛmil ɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bhii tak, wɔ gwaa Yezu zɛnɔɔ mapa, ghaapɛɛ Zɛɛb. Nyɛ eezɛnɔɔ djɛ bɛ, bɛ kaa bot binɔk ye ɛ́. Bhii tak nyɛ eebaazɛnɔɔ bɛsu, nyɛ eebaadjɛ bɛ, bɛ kaa bot binɔk ye ɛ́. Bot djas naadɛ dáa elyem bɔɔ kwyɛl ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Dáa bot nadɛ djil ɛ, nyɛ ɛ́ booke nɛ bɛdjekel bɛ náá: «Bulaka nɛ epes ee lik ɛ, e kaab náá, ye ɛ́ zɛkɛpulel.» ");
INSERT INTO bkw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tin, bɛdjekel eezɛni é tek ebhil e tak. Wɔ gwaa bɛ zokazɛlwoodal mɛbhwaa kam nɛ ebá nɛ mɛbhubhwak mɛ emapa etɛn nɛ bɛsu ɛbá bot nakat ɛdɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dáa bot nabee endem e mɛbwala mɛ Yezu nasa ɛ. Wɔ gwaa bɛ zɛke náá: «Nɛ tsɛɛtsɛ, nwyak ɛ ngoolel-mɛkpa ɛ Zɛɛb nakɛkaa náá, nyɛ waazyɛ kɔ bɔs'ak ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tin, Yezu naazɛgu náá, bɛ nadi suu ɛzɛmɛt nyɛ nɛ ghwyil, étɛp ɛdil ɛ nyɛ kɔ boo mɛkoozi nɛ bhel ɛ. Nyɛ ɛ́ boo zɛkaab byet kɔ ɛtsok, nyɛy nyɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dáa dwoo nabɛ é moo sila ɛ, bɛdjekel bɛ eezɛwyeed tɔ́ pɛ ɛboŋ ɛ boo soob na djato-djato. ");
INSERT INTO bkw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bhii tak bɛ eezɛni tɔ boo elɛɛd. Tin, bɛ moo tsaal dii tɔ́ pɛ yii kyiid pɛ kyee Kapɛlnaum. Ye nabɛɛ, ɛgwyitok eezegwyiidela. Yezu nadi ɛ́, nyɛ dinaa ààzɛbela bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tin, boo ghuu moo tin é pupal, bhuungee moo tin é ghɛɛ mɛdii ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bhis bɛ naduk tyee enɛŋ etɛn ɛ, bɛ ka bee ɛ Yezu é kɛkɔ dii. Nyɛy é zyɛ pɛ kyee bɛ nadi tɔ elɛɛd ɛ. Ye nabɛɛ bwoo nɛ bɛbebwol naamɛt bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tin, Yezu ɛ́ boozɛke nɛ nɔɔ náá: «Ye ɛ́ mam, nàbemka ba!» ");
INSERT INTO bkw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bɛ nadi kwyɛl ɛniigal nyɛ tɔ boo elɛɛd tak. Edi tak wat, elɛɛd eezɛkum e ɛboŋ ɛ bɛ nadi kwyɛl ɛsɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɛdhuu ɛ bot ɛ nalik pɛ yii kyiid boo soob na djato-djato ɔ. Yak dwoo bhii tak, bɛ eezɛbee náá, ye nazokalik e ɛboŋ ɛ elɛɛd wat. Bɛ nadi gu náá, Yezu nabɛɛ ààtɔ́ tɔ elɛɛd wat bɛ nɛ bɛdjekel bɛ. Bɛ natɔ́ ɛ bɔɔ bɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bɛdhiiti elɛɛd nadi dus pɛ ghaada Tibeliaad. Yɛ eezɛkum pɛ pak bɛ nadi dɛ emapa bhis mendjaala mɛ Ghɛŋ naghaapɛɛ Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eghɛŋ mɛdhuu mɛ bot binɔk nabee náá, Yezu nɛ bɛdjekel bɛ nabɛɛ ààbɛ tin ɛ. Bɛ ɛ́ boozɛni tɔ mɛlɛɛd kɛsaa Yezu bɔɔ bɛ ɛmet pɛ kyee dik Kapɛlnaum. ");
INSERT INTO bkw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bɛ naazɛboma nɛ Yezu pɛ nyɛ nadi pɛ yii kyiid boo soob na djato-djato ɛ. Bɛ eezɛdji nyɛ náá: «Labhi, wɔ ka leezyɛ kak é yaa ɛwala?» ");
INSERT INTO bkw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tin, Yezu eezɛbɔɔza náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: Bi ààsaa mɛ etɛɛ náá, bi naabee endem e mɛbwala mam. Bi saa mɛ ɛ, etɛɛ náá, ye nabɛɛ bi naadɛ emapa, bi naadjil ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nà saka mɛsa étɛp ɛsaŋ ɛ edee ee di náá, yɛ waapulel ɛ. Saka mɛsa étɛp ɛbela edee di bɔya ɛ. Edee di djɛ tsik na kɔm-kɔm ɛ, edee ee Sɛɛŋɛlɛ Mɔn Mot aadjɛ bin ɛ. Etɛɛ náá, Zɛɛb Sɛɛg nyɛy nyɛ ɛmet naadjɛ nyɛ ze ɛsa mɛsa mɛ nyɛ di sa yenek.» ");
INSERT INTO bkw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bɛ eezɛke nɛ Yezu náá: «Bis goka nɛ ɛsa dáa étɛp bis neesa etɛp Zɛɛb di kwyɛl ɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tin, Yezu eezɛbɔɔza náá: «Sa Zɛɛb di kwyɛl ɛ, ye ɛ́ náá, bi dum koŋ nɛ mot nyɛ nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bot binɔk eezɛke nɛ Yezu náá: «Lyaala bis dhiiti ndem mɛbwala. Tin, bis ɛ waadum koŋ nɛ nɔ. Yaa embɛɛ mɛsa mɛ yé wɔ di sa? ");
INSERT INTO bkw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bɛbhaab binaka naadɛ emapa ee nadus tɔ gwoo ɛ. Bɔɔ tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ dáa nakwyalel náá: “Zɛɛb naadjɛ bɛ emapa ee nadus tɔ gwoo ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yezu eezɛbɔɔza náá: «Tsɛɛtsɛ nɛ tsɛɛtsɛ mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: Ye tok Moiiz nadjɛ bin mapa nadus pɛ tɔ gwoo ɛ. Ye ɛ́ Saag'am ɛ di djɛ bin tɛtɛ mapa di dus pɛ tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Etɛɛ náá, mapa Zɛɛb di djɛ bot ɛ, ye ɛ́ mapa di dus pɛ ɛko ɛ. Ye ɛ́ di djɛ tsik nɛ bot ɛ bɔs djas.» ");
INSERT INTO bkw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tin, bɛ ɛ́ boozɛke nɛ nɛ náá: «Ghɛŋ, gheedjedjɛ bis mapa tak mɛlu djas!» ");
INSERT INTO bkw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yezu eezɛbaake nɛ nɔɔ náá: «Ye ɛ́ mam ɛ di mapa di djɛ tsik ɛ. Mot aazyɛ pɛ daa lam ɔ, nyɛ aanàkwaabaagwak za. Deenek, mot aadum koŋ nɛ nam ɔ, nyɛ aanàkwaabaagwak gwyes mɛdii. ");
INSERT INTO bkw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tin, mɛ lɛɛ bin ɛ náá, bi eebee mɛ, saabɛgɔs kabɛ ɛ́ náá, bi ààdum koŋ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bot djas ee Saag'am di djɛ mɛ ɔ, bɛ waazyɛ pɛ daa lam. Deenek, mam, mɛ àànakwaasɔ mot aazyɛ pɛ daa lam ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nɛ tsɛɛtsɛ, mɛ nabɛɛ ààdus pɛ tɔ gwoo, sul kɔ bɔs étɛp ɛsa ɛkwosak ɛ lam. Tsɛɛtsɛ, mɛ nadus pɛ ɛko sul kɔ bɔs ɛ, étɛp ɛsa ɛkwosak ɛ Saag'am mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tinaak, ɛkwosak ɛ mot nadhis mɛ ɔ náá: sa mɛ ààdiibal mot ngɔt, pak bot ɛ nyɛ nadjɛ mɛ ɔ. Ɛkwosak ɛ lɛ ɛ náá, mɛ gomal bot bhis ɛsyee e dwoo mɛsik. ");
INSERT INTO bkw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Etɛɛ náá, ɛkwosak ɛ Saag'am ɛ náá, mot nɛ mot aabee Mɔn ɔ, da bhii tak nyɛ ɛ́ dum koŋ nɛ nɛ ɔ. Mot tak ɛ waabela tsik na kɔm-kɔm. Tin, mɛ waagomal nyɛ bhis ɛsyee ɛ lɛ e dwoo mɛsik.» ");
INSERT INTO bkw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tin, eYuda moo enyiiŋla pak'ɔɔ dum nɛ nɛ. Etɛɛ náá, nyɛ naake náá: «Mapa nadus pɛ ɛko, sul kɔ bɔs ɛ, ye ɛ́ mam.» ");
INSERT INTO bkw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tin, bɛ eebaazɛbil náá: «Mot'ak tok Yezu mɔn Zozɛf mot mena di eguka sɛɛg nɛ nyɛɛg ɔ? Kɔ ɛsu ɛ ye nyɛ di ke nenak náá: mɛ nadus ɛ pɛ ɛko, sul kɔ bɔs?» ");
INSERT INTO bkw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Nà nyiiŋlaka pak'en! ");
INSERT INTO bkw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Etɛɛ náá, mot tok nɛ ghwyil ɛzyɛ pɛ daa lam. Mot zyɛ pɛ daa lam ɛ, yɛ bɛ náá, mot nalwom mɛ ɔ, eedhis nyɛ pɛ daa lam ɔ. Mɛ waagomal nyɛ bis ɛsyee ɛ lɛ e dwoo mɛsik. ");
INSERT INTO bkw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tɔ mɛkana mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb, ekwyala lɛɛ náá: “Zɛɛb ɛ waalyo bot ɛ bɔs djas.” Tinaak bot aagwak Sɛɛg, da bɛ ɛ́ myaal mɛlyo mɛ ɔ, bɛ ɛ́ waazyɛ pɛ daa lam. ");
INSERT INTO bkw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ye kwyɛl ɛlɛɛ náá, ye tok nɛ dhiiti mot zebee Sɛɛg. Mot zebee Sɛɛg ɔ, ye ɛ́ mot nadus pɛ daa Zɛɛb ɔ. Ye ɛ́, nyɛ ɛ́ zebee Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«Mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: mot ɛ dum koŋ nɛ nam ɔ, nyɛ waabela tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ye ɛ́ mam ɛ di mapa tsik. ");
INSERT INTO bkw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bɛ sɛɛg bin naadɛ mapa nadus tɔ gwoo ɛ bɔɔ tɔ bal. Saabɛgɔs ɛ́ náá, bɛ naagwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tin, mot aadɛ mapa dus pɛ tɔ gwoo sul kɔ bɔs ɔ, mot tak aanàkwaagwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ye ɛ́ mam ɛ di mapa di djɛ tsik nɛ bot ɛ. Mapa tak nadus pɛ tɔ gwoo, sul kɔ bɔs. Mot ɛ dɛ mapa tak ɔ, nyɛ ɛpebela tsik na kɔm-kɔm. Tinaak, mapa mɛ aadjɛ ɛ, ye ɛ́ epuud e nyel'am. Mɛ waadjɛ epuud e nyel'am étɛp ɛtsik ɛ bot ɛ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dáa bɛ nagwak deenek ɛ, eYuda eezɛbe mɛso pak'ɔɔ ɛlyelɛpe. Bɛ nadi keke ɛ náá: «Mot tak aasa dáa, étɛp nyɛ needjɛ mena nyel'ɛ, mena needɛka?» ");
INSERT INTO bkw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yezu eezɛbɔɔza náá: «Gwakeka ɛnyɔɛpe sa mɛ di lɛɛ bin'aak. Bi ɛ di ààdɛ epuud e nyel nɛ ghiya ɛ Sɛɛŋɛlɛ Mɔn Mot ɔ, bi tok nɛ tsik tɔ len. ");
INSERT INTO bkw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mot aadɛ epuud e nyel nɛ ghiya yam ɔ, mot tak ɛ waabela tsik na kɔm-kɔm. Tin, mɛ waagomal nyɛ bhis ɛsyee ɛ lɛ e dwoo mɛsik. ");
INSERT INTO bkw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Etɛɛ náá, mɛ lɛɛ bin ɛ náá, ye ɛ́ tsɛɛtsɛ náá, epuud e nyel ɛ mbɛɛ edee, da ghiya yam kadi ɛ, mbɛɛ mɛnyok. ");
INSERT INTO bkw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mot ɛ dɛ epuud e nyel'am, nɛ ghiya yam ɔ, bis nɛ yenɔk aakadi ɛ́, mot ngɔt. Nyɛy tɔ lam, mam tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mɛ ɛ nɛ tsik ɛ kɔ ɛsu ɛ Saag'am mot nadhis mɛ ɔ. Nyɛ ɛ́ di nɛ tsik. Tyɛ wat, mot aadɛ mɛ ɔ, aadi nɛ tsik kɔ ɛsu ɛ lam. ");
INSERT INTO bkw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Beeka mapa dus pɛ ɛko, sul kɔ bɔs ɛ. Nyɛ tok dáa mapa nakwyit tɔ gwoo bɛsɛɛg bin nadɛ ɛ. Etɛɛ náá, bhis bɛ nadɛ ye ɛ́, bɛ naagwyɛ. Yɛ kabɛ yak mapa yam ɔ, mot ɛ dɛ yɛ ɔ, nyɛ ɛpebela tsik na kɔm-kɔm.» ");
INSERT INTO bkw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Etɛp binek djas naliiel ɛ, tɔ mɛlyo mɛ Yezu nalyo bot tɔ ndjaa mendjaala mɛ eYuda pɛ Kapɛlnaum ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bhis bɛtɛ nɛ bɛdjekel nazegwak etɛp ee Yezu nadi lii ɛ, wɔ gwaa bɛ zɛke náá: «Mɛlyo mɛ nɛ lyel. Nyɔaa mot aakwaagwak yɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dáa Yezu nyɛ ɛmet nagu náá, bɛdjekel bɛ nadi lii ɛbiyoɛpe dum nɛ mɛlyo mɛ nyɛ nalyo ɛ. Nyɛ ɛ́ boodji bɛ náá: «Ha etɛp ye, mɛlyo mam di kpaa bin tɔ lyem? ");
INSERT INTO bkw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bha bi ɛ bee Sɛɛŋɛlɛ Mɔn Mot é byet tɔ gwoo pɛ kyee nyɛ nadi sok ɛ, bi aasa dáa? ");
INSERT INTO bkw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ye ɛ́ Sisim Zɛɛb ɛ di djɛ tsik. Epuud e mot ààval dhiiti sonok. Etɛp ee mɛ di lɛɛ bin ɛ, ye ɛ́ etɛp e Sisim. Ye ɛ́ etɛp di djɛ bot tsik ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tin, pak'en, ye ɛ́ nɛ bɛdhiiti bot ɛ di ààdum koŋ nɛ nam ɔ.» Yezu nake deenek ɛ etɛɛ náá, nyɛ nadi gu bot aaboodi ààdum koŋ nɛ nɛ ɔ. Nyɛ nabaadigu mot aakɛka nyɛ gha ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nyɛ eebaazɛbil ɛkpa náá: «Etɛp tak ɛ mɛ di lɛɛ bin náá: “Mot tok nɛ ghwyil ɛzyɛ pɛ daa lam, Saag'am ààmyaal náá, nyɛ zyɛ.”» ");
INSERT INTO bkw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kana dwoo tak, bɛtɛ nɛ bɛdjekel zokazɛdus yɔ bɔ. Bɛ eezɛkat ɛgyee nɛ Yezu lɔɔg. ");
INSERT INTO bkw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tin, Yezu ɛ́ booke nɛ bɛdjekel bɛ kam nɛ bɛbá náá: «Biyɔ, bi ààkwyɛl ɛkaab ɛ mɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","É di'enek, Simɔŋ Pyɛɛd eezɛbɔɔza náá: «Ghɛŋ, bis aatɔ́ paa? Wɔy ɛ di nɛ mɛkpa mɛ di djɛ tsik na kɔm-kɔm ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Bisɔ, bis eedum koŋ nɛ nɔ. Tin, bis nɛ gu náá, wɔy ɛ di Mot na Dɛɛ Zɛɛb nadhis ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","É di'enek, wɔ gwaa Yezu zɛbɔɔza nɛ nɔɔ náá: «Ye ɛ́ mam ɛ nasɛ́ɛ bin, biyɔ bot ɛ lɔɔg kam nɛ bɛbá. Deenek, mot ngɔt tɔ sama yen ɛ nɛ ɛlyeeb.» ");
INSERT INTO bkw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nyɛ nalii deenek ɛ nɛ Yudas, mɔɔ Simɔŋ Iskaliɔt. Etɛɛ náá, nyɛy ɛ kwaakɛka nyɛ gha. Ye nakozodi náá, nyɛ nadi ɛ́ ngɔt tɔ sama bɛdjekel kam nɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bhii tak, Yezu eezɛdjaad tɔ kyee dik Ghalile. Nyɛ nabɛɛ ààkwyɛl ɛgyee pɛ kyee dik Yude. Etɛɛ náá, bot ɛ eYuda nadi kwyɛl ɛgó ɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ghuna mɛlu mɛ ɛbyoŋ ɛ eYuda nadi djóoaa ɛbyoŋ ɛ epɛt ɛ, nabɛɛ yɛ eezekunaa. ");
INSERT INTO bkw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tin, bɔn nyɛɛg ɛ Yezu eezɛke nɛ nɛ náá: «Dusa wak, da wɔ ɛ tɔ́ pɛ kyee dik Yude etɛɛ náá, bɛdjekel bɔ neebee mɛsa mɛ wɔ di sa ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mot ɛ kwyɛl ɛgunel ɔ, nyɛ aanàkwaasa mɛsa mɛ sɔ. Dáa di náá, wɔ ɛpesa eboo étɛp ɛ, wɔ goka ɛ́ wɔ lyaal nyel e mis mɛ bot ɛ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bɛ nadi lii deenek ɛ etɛɛ náá, dɔɔ nɛ bɔn nyɛɛg nabɛɛ ààdi dum koŋ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yezu eebɔɔza nɛ nɔɔ náá: «Yam ɛwala dinaa ààpaadjala, yebɔ ɛ dinaa, mɛlu djas ɛ, mbɛɛ mɛwala etɛp'en. ");
INSERT INTO bkw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Biyɔ, bot ɛ bɔs'ak tok nɛ ghwyil ɛbhina bin. Yɛ kabɛ mam ɔ, bot ɛpebhinaa mɛ. Etɛɛ náá, mɛ ɛpelɛɛ bot náá, mɛsa mɛ bɛ di sa ɛ, yɛ àànyɔ. ");
INSERT INTO bkw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Biyɔ, bi ɛ nɛ ghwyil ɛtɔ́ kɛbɔl ɛbyoŋ. Yɛ kabɛ mam ɔ, e ɛwala ɛlak, mam aanàkwaatɔ́. Etɛɛ náá, tɛtɛ ɛwala mɛ di egoka nɛ ɛtɔ́ ɛ dinaa ààpaakum.» ");
INSERT INTO bkw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bhis nyɛ nazelii nɛ nɔɔ deenek ɛ, nyɛ eezɛlik yɛ pɛ Ghalile. ");
INSERT INTO bkw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tin, dáa nabela náá, bɔn nyɛɛg nabɛɛ, bɛ eezetɔ́ pɛ ɛbyoŋ ɛ. Wɔ gwaa Yezu zɛtɔ́ yɛ pe pɛ ɛbyoŋ ɛ tak tyee syaab, bot ààgu. ");
INSERT INTO bkw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tin, tɔ ɛbyoŋ, eYuda moo tin é saa nyɛ. Bɔɔ náá: «Nyɛ ɛ́ wo?» ");
INSERT INTO bkw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tɔ mɛdhuu mɛ bot ɛ nadi tin ɔ, ye nabɛɛ nɛ bot ɛ nadi lii kɔ ɛsu ɛ lɛ ɔ. Bak bot náá: «Nyɛ ɛ́ mbɛɛ mot.» Bɛdhiiti náá: «Nyɛ ɛ́ ɛpeful bot elo nɛ mɛlyo mɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ye tok nɛ mot nadi lii kɔ ɛsu ɛ lɛ emis mɛ bot. Etɛɛ náá, bɛ nadi kaab ekukuma eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dáa ɛbyoŋ nabɛ e moo kuku tak ɛ, Yezu eezɛtɔ́ tɔ kok Ndjaa-ebuwa. É di'enek, nyɛ moo tin é lyo bot. ");
INSERT INTO bkw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tin, eYuda moo é djoka. Bɔɔ náá: «Nyɛ gu ekwyala e Zɛɛb dáa, nyɛy ààbɛ náá, nyɛ nakɛ djek mɛdjek?» ");
INSERT INTO bkw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «E tok mam nakus mɛlyo mɛ mɛ di elyo'aak. Ye ɛ́ mot nadhis mɛ ɔ di nakuma tak. ");
INSERT INTO bkw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mot di nɛ lyem ɛsa mɛsa mɛ Zɛɛb ɛ waagu nɛghu náá, mɛlyo mam ɛ yii Zɛɛb ɔ. Nyɛ waabaagu nɛghu mɛlyo mɛ tak dus ɛ pɛ daa lam. ");
INSERT INTO bkw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mot di elii dum nɛ nyel'ɛ ɛmet ɔɔ, nyɛ saŋ ɛ́ duu étɛp nyel'ɛ ɛmet. Tin, mot di esaa duu mot nadhis nyɛ ɔ, yenɔk lɛɛ etɛp e tsɛɛtsɛ. Yenɔk mot tok nɛ etsal tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moiiz nabɛɛ ààdjɛ bin etsi? Tin, e tok nɛ mot ngɔt pak'en di kɛdaa etsi e tak di lɛɛ ɛ. Étɛp ye bi di kwyɛl ɛgó ɛ mɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mɛdhuu mɛ bot ɛ nadi tin ɔ zokazɛbɔɔza náá: «Wɔ ɛ nɛ ɛlyeeb tɔ lɔ! Ɛzɛ di saŋ ɛgó ɛ wɔ?» ");
INSERT INTO bkw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","É di'enek, Yezu eezɛke nɛ nɔɔ náá: «Mɛ eesa ndem mɛbwala mɛ ngɔt wak, bi nabɛɛ biyɔ djas naadjoka. ");
INSERT INTO bkw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moiiz naadjɛ bin ze ɛniigal bɔɔ bin beka. Nɛ tsɛɛtsɛ, ye tok náá, Moiiz ɛ nakus beka tak. Ye nadus ɛ pɛ daa bɛbhaab bin. Dɔɔ nɛ dwoo saba bi ɛpemyaal ɛniigal bɔɔ bin beka. ");
INSERT INTO bkw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bi sa deenek ɛ, etɛɛ náá, etsi e Moiiz ɛzɛkɛkataa ɛduwalaa. Dwoo saba bi ɛpeniigal bɔɔ bin beka. Ha etɛp ye bi di biyo nɛ nam etɛɛ náá, mɛ eetsik mot e dwoo saba? ");
INSERT INTO bkw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nà mwaa pɛ́ɛka etɛp dáa biyɔ di bee nɛ mis ɛ. Pɛ́ɛka dáa di egoka tɔ epiki ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bɛdhiiti bot pak bot ɛ ghaada ɛ Yeluzalɛm moo tin é ke náá: «Mot tak tok mot ekukuma bis di saŋ ɛgó ɛ nyɛ ɔ? ");
INSERT INTO bkw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Beeka nyɛ ɛpelii e mis mɛ bot djas, ààbɛ nɛ mot lyak nyɛ. E kwyɛl ɛlɛɛ ɛ náá, ekukuma bina eemyaal náá, ye ɛ́ tsɛɛtsɛ náá, nyɛ ɛ́ Mɛsia? ");
INSERT INTO bkw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Zo bela náá, nwyak mot tak bis nɛ gu pɛ nyɛ dus ɛ. Yɛ kabɛ Mɛsia ɔ, mot aanàkwaagu pɛ pak nyɛ waadus ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","É di'enek, dáa Yezu nadi é lyo bot tɔ kok Ndjaa-ebuwa ɛ, nyɛ naazɛbɛn gwood, ke náá: «Nɛ tsɛɛtsɛ bi nɛ gu mɛ, bi nɛ baagu pɛ kyee mɛ nadus ɛ. Deenek guka náá, mɛ nabɛ ààzyɛ nɛ ɛkwosak ɛ lam met. Tin, mot nadhis mɛ ɔ, ye goka ɛ́ náá bi myaal nyɛ. Etɛɛ náá, nyɛ ɛ́ mot etsɛɛtsɛ. Saabɛgɔs kabɛ ɛ́, bi ààgu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mɛ nɛ gu nyɛ, etɛɛ náá, mɛ nadus ɛ pɛ daa lɛ. Nyɛ ɛ́ nadhis mɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tin, bot moo saa mɛpek mɛ ɛmɛt ɛ Yezu. E sok yenek, e tok nɛ mot nàwaamɛt nyɛ. Etɛɛ náá, ɛwala ɛ nakoobelaa étɛp ɛmɛt ɛ nyɛ nabɛɛ, e dinaa ààkum. ");
INSERT INTO bkw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bot ɛbuɛpe tɔ mɛdhuu mɛ bot ɛ nadi tin ɔ, naadyeebadum koŋ nɛ nɛ. Bɔɔ náá: «E ghɛŋ Mɛsia aazyɛ ɛ́, nyɛ waasa eboo endem mɛbwala dhaa mot tak e?» ");
INSERT INTO bkw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wɔ gwaa eFalizyɛ zokagwak dáa bot nadi é lii deenek pak'ɔɔ, dum nɛ Yezu ɛ. Tin, eboo bɛghaa-Zɛɛb nɛ eFalizyɛ eezɛkyeed esodja di baal kok Ndjaa-ebuwa ɛ, bɛ zɛmɛt nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tin, Yezu eezɛke nɛ nɔɔ náá: «Mɛ dinaa wak menabɛlka ba bim bɔɔ mɛlu, bhii tak, da mɛ ɛ sik pɛ daa mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bi ɛ waasaa mɛ, ka bela náá, bi aanàkwaabela mɛ. Etɛɛ náá, bi tok nɛ ghwyil ɛzyɛ pɛ pak mɛ aadi ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","É di'enek, eYuda moo tin é djinel pak'ɔɔ náá: «Nyɛ aatɔ́ paa? Pɛ di di náá, mena aanàkwaabela nyɛ ɛ́? Nyɛ aatɔ́ ɛ pɛ daa eYuda ee di, e di wat nɛ bot ɛ mbyak eGhɛlɛk e? Étɛp ɛ baakɛlyo bot ɛ yiizaag dhaad mbyak e? ");
INSERT INTO bkw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ɛsuk ɛ mɛkpa nyɛ di ke náá: “Bi ɛ waasaa mɛ, ka bela náá, bi aanàkwaabela mɛ.” Nyɛ naabaake náá: “Bi tok nɛ ghwyil ɛtɔ́ pɛ kyee mɛ di tɔ́ ɛ.” Ye kwyɛl ɛlɛɛ ye?» ");
INSERT INTO bkw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dwoo mɛsik mɛ ɛbyoŋ, dwoo nabɛ nɛ boo mɛtaŋ ɛ, Yezu tetel, wɔ gwaa nyɛ zokabaazɛben gwood, e ke náá: «Mot ɛ di nɛ gwyes mɛdii ɔ, nyɛ zyɛ pɛ daa lam, nyɛ neezɛdɛ mɛdii. ");
INSERT INTO bkw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mot ɛ dum koŋ nɛ nam ɔ, “etok mɛdii mɛ di djɛ tsik ɛ waawo tɔ lɛ”, dáa ekwyala di lɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yezu nadi eke deenek ɛ, étɛp Sisim ɛ Zɛɛb. Bot ɛ di dum koŋ nɛ Yezu ɔ waabela Sisim tak. Tin, ye nabɛɛ Sisim na Dɛɛ dinaa ààzyɛ. Etɛɛ náá, Yezu nabɛɛ, nyɛ dinaa ààpaasik tɔ gwoo étɛp ɛbela duu ɛ Zɛɛb Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dáa mɛdhuu mɛ bot nadi gwak etɛp binek ɛ, bɛ ɛ́ boozɛke náá: «Ye ɛ́ tsɛɛtsɛ náá, mot tak ɛ ngoolel-mɛkpa ɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bak bot náá: «Ye ɛ́ Mɛsia.» Bɛdhiiti kake ɛ tyee sis náá: «Mɛsia tok nɛ ghwyil ɛdus pɛ kyee dik Ghalile! ");
INSERT INTO bkw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tinaak, mena dyeebalaaka tɔ ekwyala e mɛkana mɛ Zɛɛb náá: “Mɛsia dus ɛ tɔ bɔɔ bɛdha ɛ mɛkoozi Dhavid. Mɛsia aadus ɛ pɛ Bheteleɛm, dɛl ɛ Dhavid.”» ");
INSERT INTO bkw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tin, kɔ ɛsu ɛ lɛ, ye nabɛɛ zyaala naani tɔ bot ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bɛdhiiti bot, pak bot ɛ nadhisaa ɛ, nadi kwyɛl ɛ náá, bɛ mɛt nyɛ. Tin, ye tok nɛ mot namɛt nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","É di'enek, bot ɛ di baal kok Ndjaa-ebuwa ɔ eezɛnɔɔ mɛnyel sik pɛ daa eboo bɛghaa-Zɛɛb nɛ eFalizyɛ nadi ɛ́. Dáa bɛ nakakum ɛ, ekukuma eezɛdji bɛbaalel náá: «Bi di ààzyɛ nɛ nɛ étɛp ye?» ");
INSERT INTO bkw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bɛbaalel binɔk eezɛbɔɔza náá: «Bis dinaa ààpaabee mot di elii dáa mot yenɔk!» ");
INSERT INTO bkw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","EFalizyɛ eezɛbɔɔza nɛ bot binɔk náá: «Bis bee ɛ náá, biyɔ pe, bi eezemyaal mɛkɔŋ mɛ! ");
INSERT INTO bkw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ye ɛ́ nɛ dhiiti kukuma, nɛghu dhiiti Falizyɛ, di dum koŋ nɛ nɛ? ");
INSERT INTO bkw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Etɛɛ náá, mɛdhuu mɛ bot ɛ di ààduwal etsi ɛ Moiiz ɔ, ye ɛ́ bot ɛ zelekaa ɛbiyoɛpe ɔ!» ");
INSERT INTO bkw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tin, din ɛ ngɔt tɔ lɔɔg'ɔ nabɛɛ Nikodhɛm. Ye ɛ́ Nikodhɛm tak ɛ nazyɛ sok wat tɔ ghooghom zɛmɔ nɛ Yezu. Nyɛ nadi ɛ́ ngɔt tɔ sama eFalizyɛ. Nyɛ eezɛke nɛ bɛsɔ náá: ");
INSERT INTO bkw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Etsi bina lɛɛ náá, mot ɛ nɛ ghwyil ɛmɛtaa, bot dinaa ààgwak taŋalɛ, bi dinaa ààgu mbee mɛsa mɛ mot tak sa ɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tin, bot ɛ sama yɛ eezɛke nɛ nɛ náá: «Wɔy pe, wɔ ɛ mot Ghalile? Laŋa ekwyala ɛnyɔɛpe. Wɔ aabee náá, ekwyala lɛɛ náá: Ngoolel-mɛkpa ɛ Zɛɛb tok nɛ ghwyil ɛtuula dus pɛ Ghalile.»  ");
INSERT INTO bkw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bhii tak, mot nɛ mot eezɛsik pɛ ndjaŋ'ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yezu eezɛtɔ́ pɛ ɛtsok pyeeb oliv. ");
INSERT INTO bkw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kɛɛŋ tɔ mɛlem, nyɛ eebaazɛsik pɛ kok Ndjaa-ebuwa. Tin, bot ɛbuɛpe eezɛzyɛ pɛ daa lɛ. Nyɛ eezɛnɔɔ nyel disi, nyɛ moo tin é lyo bot. ");
INSERT INTO bkw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","É di'enek, bɛghaŋ ɛ mɛkana mɛ etsi, nɛ eFalizyɛ eezɛzyɛ nyɛ nɛ dhiiti moma ngɔt nabelaa é sa ɛzɔ ɔ. Bɛ eezɛnɛɛg nyɛ kuku ɛbwak, ");
INSERT INTO bkw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","bɛ eezɛke nɛ Yezu náá: «Lyoel, bis mɛt moma yak ɛ, nyɛy é sa ɛzɔ. ");
INSERT INTO bkw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tɔ etsi ɛ Moiiz ye lɛɛ náá, ye goka ɛ́ náá, moma yak góaa nɛ mɛkok. Yɛ kabɛ wɔy ɔ, wɔ ke náá, bɛ sa moma yak dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bɛ nadi eke deenek ɛ, étɛp ɛlóo ɛ nyɛ pɛ ɛko, da bwood nyɛ pɛ kyɛ. Etɛɛ náá, bhii tak bɛ neekɛpit nyɛ. É di'enek, Yezu eezɛsil mis si, nyɛ moo é kwyal e bɔs nɛ djin. ");
INSERT INTO bkw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dáa bɛghaŋ ɛ mɛkana mɛ etsi, nɛ eFalizyɛ nadi belal nyɛ nɛ mɛdjin ɛ, nyɛ ɛ́ boo bin lo, gwyák bɛ. Bhii tak, nyɛ eezɛke nɛ nɔɔ náá: «Pak biyɔ djas di tin yenek, mot di náá, nyɛ dinaa ààpaasa mesyem ɔ, kan ɛ wus moma yak ɛkok ɛsok!» ");
INSERT INTO bkw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Bhii tak nyɛ eebaazɛmalal, tin nyɛ eebaakan ɛkwyal e bɔs. ");
INSERT INTO bkw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Dáa bɛ nagwak deenek ɛ, tin, «kili», mot nɛ mot naazɛliig mis sik: kan nɛ bɛpaa, zɛnɔɔ mengbaaz nɛ bɔɔ dhyeeb. Bhii tak, Yezu nazokalik ɛ bɔɔ bɛbá, bɛ nɛ moma nadi tetel sok bhwoob'ɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dáa Yezu nakaben lo bhii tak, nyɛ eezɛke nɛ moma tak náá: «Wɛɛ moma, bot ɛ zɛpit wɔ moo wo e? Ye tok nɛ mot baadi e djɛ wɔ ndjɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Moma tak eezɛbɔɔza náá: «Ààbɛ, Ghɛŋ! Mot ààpakwyesal mɛ ndjɛ sɔs.» Deenek Yezu ɛ́ boozɛke nɛ nɛ náá: «Dɔɔ nɛ mam pe, mɛ ààpatil wɔ ebhete. Tɔ́a yɔ, sa wɔ ààbaasa mesyem.» ");
INSERT INTO bkw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bhii tak, Yezu eebaazɛlii nɛ mɛdhuu mɛ bot ɛ nadi tin ɔ náá: «Ye ɛ́ mam ɛ di gwyɛ ngel di kas kɔ bot ɛ bɔs djas. Mot aadu mɛ ɔ, nyɛ aanàkwaabaakɛ tɔ ghooghom. Nyɛ waabela gwyɛ ngel di djɛ tsik ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","EFalizyɛ eezɛdji nyɛ náá: «Wɔ lɛɛ etɛp e nyel'ɔ wɔy wɔ ɛmet ɔ, ye kwyɛl ɛlɛɛ ɛ náá, etɛp wɔ di lɛɛ ɛ, tok nɛ ghwyil ɛmyaalaa.» ");
INSERT INTO bkw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Yɛ kobɛ náá, mɛ ɛpelɛɛ etɛp e nyel'am mam ɛmet ɔ, etɛp mɛ di lɛɛ ɛ, ye ɛ́ tsɛɛtsɛ. Etɛɛ náá, mɛ nɛ gu pɛ pak mɛ dus ɛ, nɛ pɛ pak mɛ di tɔ́ ɛ. Deenek, biyɔ, bi ààgu pɛ pak mɛ nadus ɛ, nɛ pɛ pak mɛ di tɔ́ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Bi pɛ́ɛ mɛ ɛ nɛ etsoŋ ee bi di pɛ́ɛ bot ɛ bɔs ɛ. Mam ààpɛ́ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Guka náá, mam ɛ pɛ́ɛ bot ɔ, epɛ́ɛ bam aadi ɛ́, tɛtɛ mɛpɛ́ɛa. Etɛɛ náá, tɔ epɛ́ɛ bam, mɛ tok mam mɛ ɛmet. Mɛ pɛ́ɛ bot ɛ, bis nɛ Saag'am, mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tɔ etsi bin, ye ɛ́ kwyala náá, bot ɛbá ɛ di kaada tɛp tyee wat ɔ, tɛp tak ɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ye ɛ́ mam nakuma nyel ɛ di lɛɛ bin etɛp bam. Dɔɔ nɛ Saag'am, mot nadhis mɛ ɔ, ɛpebaalyaal etɛp bam.» ");
INSERT INTO bkw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tin, wɔ gwaa eFalizyɛ zɛdji nyɛ náá: «Soog ɛ wo?» Yezu eezɛbɔɔza náá: «Bi ààgu mɛ. Bi ààbaagu pe Saag'am. Bi ɛpedi ɛ́ di, é gu mɛ ɔ, pe bi nɛ gu pe Saag'am.» ");
INSERT INTO bkw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yezu nadi é djɛ bot mɛlyo deenek ɛ, nyɛy tɔ kok Ndjaa-ebuwa. Nyɛ nadi ɛ́ e ngwoob ɛbɔɔl ɛ bot nawewa epata ee bɛ nadii zyɛ, zɛpɛk Zɛɛb nɛ ye ɛ́. Tin, Yezu nabɛ ààmɛtaa etɛɛ náá, ɛwala nabɛ náá, nyɛ naamɛtaa ɛ, nabɛɛ ye dinaa ààkum. ");
INSERT INTO bkw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yezu eebaazɛke nɛ nɔɔ náá: «Mɛ waatɔ́, bi ɛ waasaa mɛ. Tin, bi ɛ waagwyɛ tɔ esyem bin. Bi aanàkum pɛ pak mɛ aatɔ́ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tin, eYuda eezɛdjinel pak'ɔɔ náá: «Nyɛ aatɔ́ bilak ɛ, kɛyeeda, etɛɛ náá, nyɛ ke ɛ náá: “Bi tok nɛ ghwyil ɛtɔ́ pɛ pak mam aatɔ́ ɛ”.» ");
INSERT INTO bkw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","É di'enek, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Biyɔ, bi ɛ bot ɛ si; mam ɛ mot pɛ ɛko. Bi ɛ bot ɛ bɔs'ak, mam tok mot bɔs'ak. ");
INSERT INTO bkw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Etɛp tak ɛ mɛ ke nɛ nen náá, bi aagwyɛ tɔ mesyem min. Tsɛɛtsɛ bi aagwyɛ tɔ mesyem min, bi ɛ di ààmyaal náá: “Ye ɛ́ mam ɛ di mot mɛ di lɛɛ náá, ye ɛ́ mam ɔ.”» ");
INSERT INTO bkw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","EFalizyɛ zokabaazɛdji Yezu náá: «Wɔy ɛ́ yɔ zɛ?» Yezu eezɛbɔɔza náá: «Mɛ ɛ mot mɛ nanyɛl ɛlɛɛ bin e mɛkɛn mɛ mɛlyo mam ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mɛ bɛ ɛ́ mɛ eekoolii bɛtɛ nɛ etɛp kɔ ɛsu ɛ lin, nɛ yii ɛpɛ́ɛ bin. Deenek, mot nalwom mɛ ɔ lɛɛ etɛp ee tsɛɛtsɛ, etɛp ee mɛ nadjek dáa lɛ ɛ, mɛ ɛpegoola yɛ nɛ bot kɔ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eghɛŋ nyɛ nadi lii deenek ɛ, bot nabɛɛ ààsiiza náá, nyɛ nadi lii ɛ, dum nɛ Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","É di'enek, Yezu eezɛke nɛ nɔɔ náá: «Esok bi aakan ɛben Sɛɛŋɛlɛ Mɔn Mot ɛ, é di'enek bi ɛ waagwyak náá, etɛp mɛ nalɛɛ ɛ́ ye ɛ́ tsɛɛtsɛ. Bi ɛ waagu náá, mam ɛ di mot mɛ di lɛɛ náá, “ye ɛ́ mam” ɔ. Bi ɛ waagu náá, mam ààsa esonok nɛ ɛkwosak ɛ lyem'am. Mɛ lɛɛ ɛ etɛp ee Saag'am nalyo mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mot nalwom mɛ ɔ, nyɛ ɛ́ lɔɔg wat bis nɛ nɛ. Nyɛ ààpabet mɛ mam ɛmet, etɛɛ náá, mɛ dyeebasa ɛ́, esa ee lyem'ɛ di ekwyɛl ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Dáa Yezu nadi lii deenek ɛ, bot ɛbuɛpe naadum koŋ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tin, Yezu eezɛke nɛ eYuda nadum koŋ nɛ nɛ ɔ náá: «Bi ɛ kɛ tɔ esosoob dáa mɛkpa mam di kwyɛl ɔ, bi ɛ bɛdjekel bam nɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Etɛp tak ɛ di náá, bi ɛ waagu etsɛɛtsɛ, bhii tak, etsɛɛtsɛ waapɛk bin tɔ ekwom.» ");
INSERT INTO bkw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bɛ eezɛbɔɔza náá: «Bis ɛ bɔɔ bɛdha ɛ Abalaam, bis dinaa ààpaakodi ekwom e mot dhiiti dwoo. Etɛp ye wɔ di ke náá: “Bi ɛ waapɛkaa tɔ ekwom”?» ");
INSERT INTO bkw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá, «Nɛ tsɛɛtsɛ mɛ lɛɛ bin ɛ náá: bot djas di sa mesyem ɔ, bɛ ɛ́ ekwom e mesyem. ");
INSERT INTO bkw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Deenek, ye ɛ́ tsɛɛtsɛ náá, mɔn ɛ di mot mɛbyel na kɔm-kɔm, ààkabɛ kwom. Mot di kwom ɔ, tok nɛ ghwyil ɛ liiza mot mɛbyel na tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","É di'enek, yɛ bɛ náá, mɔn eepɛk wɔ tɔ ekwom ɔ, wɔ moo ɛ́ pɛka nɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mɛ nɛ gu náá, bi ɛ bɔɔ bɛdha ɛ Abalaam. Ha etɛp ye bi di saŋ ɛgó ɛ mɛ? Ye ɛ́ etɛɛ náá, bi ààmyaal etɛp ee mɛ di lɛɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mam lɛɛ bin ɛ etɛp ee mɛ nabee pɛ daa Saag'am ɛ. Yɛ kabɛ biyɔ ɔ, bi sa ɛ etɛp sɛɛg'en nalyaal bin ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wɔ gwaa bɛ baazɛbɔɔza nɛ Yezu: «Yisɔ sɛɛg ɛ Abalaam.» Deenek, Yezu eezɛke nɛ nɔɔ náá: «Bi ɛpedi ɛ́ bɔɔ ɛ Abalaam e tsɛɛtsɛ ɔ, pe bi sa étɛp ɛ dáa nyɛy. ");
INSERT INTO bkw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mɛ eelɛɛ bin etsɛɛtsɛ ee Zɛɛb nalyaal mɛ ɛ. Tin, bi kakwyɛl ɛ ɛgó ɛ mɛ. Abalaam nabɛɛ ààsa deenek. ");
INSERT INTO bkw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Biyɔ, bi sa ɛ mɛsa mɛ wat bi nɛ sɛɛg'en.» Bɛ eezɛbaayala nɛ Yezu náá: «Bis tok bɔɔ mbel, bis ɛ bɔɔ du etɛɛ náá, Sɛɛg'es ɛ Zɛɛb nyɛ ɛmet.» ");
INSERT INTO bkw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yezu eebaazɛbɔɔza nɛ nɔɔ náá: «Zɛɛb ɛpedi Sɛɛg'en ɔ, pe bi ɛpekwyɛl mɛ. Etɛɛ náá, Zɛɛb ɛ nadhis mɛ. Mɛ di wak ɛ e di ɛ Zɛɛb. Mɛ nabɛɛ ààzyɛ kɔ ɛkwosak ɛ lam. Ye ɛ́ Zɛɛb ɛ nadhis mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Etɛp ye bi di ààgwak etɛp ee mɛ di lɛɛ bin ɛ? Ye ɛ́, etɛɛ náá, bi tok nɛ ghwyil ɛgwak etɛp bam. ");
INSERT INTO bkw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Deenek sɛɛg'en ɛ Dim mot mɛkɔŋ. Tin, bi dyeebasa ɛ, mɛsa mɛ sɛɛg'en di kwyɛl ɛ. Nyɛ nadi ɛ́, mot ɛgó ɛ bot, kana bɔs nanyɛlaa ɛ. Nyɛ dinaa ààpaakokɛ tɔ etsɛɛtsɛ etɛɛ náá, etsɛɛtsɛ tok tɔ lɛ. E sok nyɛ di, nyɛ moo lɛɛ elɛŋ etsal ɛ, nyɛ lɛɛ ye ɛ́ nɛ lyem wat. Etɛɛ náá, nyɛ ɛ́ mot etsal, nyɛ ɛ́ sɛɛg mɛkɔŋ. ");
INSERT INTO bkw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tin, yɛ kabɛ mam ɔ, mɛ dyeebalɛɛ etɛp ee di tsɛɛtsɛ ɛ. Étɛp tak ɛ bi di ààmyaal mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tɔ lɔɔg'en, ɛzɛ aaben djin náá, mɛ eesa mesyem? Ha yɛ kabɛ náá, mɛ eelɛɛ etɛp ee di náá, ye ɛ́ etsɛɛtsɛ ɔ, étɛp ye bi di ààmyaal mɛ? ");
INSERT INTO bkw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mot di mot Zɛɛb ɔ nɛ gwak mɛkpa ɛ Zɛɛb. Tin, dáa bi di ààgwak mɛkpa mam ɛ, ye lyaal ɛ náá, bi tok bot ɛ nadus pɛ dáa Zɛɛb ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tinaak eYuda zokazɛke nɛ Yezu náá: «Bis ɛ nɛ gham nɛ ɛke ɛ náá, wɔ ɛ mot Samali, wɔ ɛ nɛ ɛlyeeb tɔ lɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Ààbɛ! Mɛ tok nɛ ɛlyeeb. Mɛ kwyɛl ɛ ɛdjɛ duu nɛ ɛdil ɛ Saag'am. Ka bela náá, biyɔ, bi ààkwyɛl ɛdil mɛ nɛ ɛdjɛ mɛ duu. ");
INSERT INTO bkw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mam ààsaa duu kɔ ɛsu ɛ lam met. Etɛɛ náá, ye ɛ́ nɛ mot ngɔt di saa duu'am. Nyɛ ɛ́ di pɛ́ɛ bot tɔ epiki. ");
INSERT INTO bkw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tsɛɛtsɛ mɛ lɛɛ bin etɛp e tsɛɛtsɛ ɛ́ náá: mot di ekɛ dáa mɛkpa mam di elɛɛ ɔ, nyɛ aanàkwaagwyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","EYuda eebaazɛke nɛ nɛ náá: «Tin, bis eemyaal tsɛɛtsɛ náá, ye ɛ́ mbee sisim ɛ́ di dhek wɔ! Etɛɛ náá, Abalaam naazegwyɛ. Bɛngoolel ɛ mɛkpa ɛ Zɛɛb naabaazegwyɛ yɔbɔ pe. Bɔɔ djas naazegwyɛ, wɔ kabaake ɛ́ náá: “Mot di ekɛ dáa mɛkpa mam di elɛɛ ɔ, nyɛ aanàkwaagwyɛ.” ");
INSERT INTO bkw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abalaam, sɛɛg'es, naazegwyɛ. Wɔ kwyɛl ɛlɛɛ náá, wɔ ɛ́ boo-mot nɛ nɛ? Bɛngoolel ɛ mɛkpa ɛ Zɛɛb naabaazegwyɛ yɔbɔ. Wɔ gek náá, wɔ ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Yɛ bɛ náá, mɛ duwal nyel'am mam ɛmet ɔ, yenek duu tak ààval sonok wat. Mot di djɛ mɛ duu ɔ, ye ɛ́ Saag'am. Bi dyeebake kɔ ɛsu ɛ lɛ náá: “Nyɛ ɛ́ Zɛɛbes”. ");
INSERT INTO bkw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ghuna bi ààgu nyɛ. Tin, bela náá, mam nɛ gu nyɛ. Mɛ ɛ́ pe ke náá: “Mɛ ààgu nyɛ” ɔɔ, pe mɛ ɛ́ mot etsal dáa biyɔ. Tin, ye tok deenek, etɛɛ náá, mam nɛ gu nyɛ, etɛp tak ɛ mɛ di ekɛ dáa mɛkpa mɛ di lyo ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abalaam sɛɛg'en naamyaala, etɛɛ náá, nyɛ nadi bwood dwoo ɛzyɛ ɛ lam. Nyɛ naabee, bhii tak, lyemɛ naadyeebamyaala ɛbuɛpe.» ");
INSERT INTO bkw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tin, eYuda eebaazɛke nɛ Yezu náá: «Wɔ dinaa ààpaakokum-kumak membu mɛkam-mɛtɛn. Wɔ lɛɛ ɛ náá, wɔ naabee Abalaam e?» ");
INSERT INTO bkw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yezu eezɛbɔɔza nɛ nɔɔ náá: «“Iyoo” mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá, ɛsok nɛ Abalaam nɛ byel, mɛ ɛ tak.» ");
INSERT INTO bkw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","É di'enek, bɛ ɛ́ boozɛtek mɛkok etɛp ɛwus ɛ Yezu. Nyɛ eezɛsɔwa, bhii tak nyɛ eezɛwyis tɔ kok Ndjaa-ebuwa tyee syaab. ");
INSERT INTO bkw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dáa nyɛ nadi tɔ́ gba-gba ɛ, Yezu eezɛbee mot ngɔt nadi nɛ ɛbɛ́ ɛ edhim kana dwoo mɛbyel mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wɔ gwaa bɛdjekel bɛ zokazɛdji nyɛ náá: «Labhi, ha étɛp ye mot tak nabyel nɛ ɛbɛ́ ɛ edhim? Ye ɛ́ étɛp mesyem mɛ met ohoo etɛɛ náá, sɛɛg nɛ nyɛɛg naasyem?» ");
INSERT INTO bkw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yezu eezɛbɔɔza náá: «E tok tɛp mesyem mɛ sɛɛg nɛ nyɛɛg, nɛghu yii bot bɛ. Nyɛ bɛ́ edhim ɛ, etɛɛ náá, mɛsa mɛ mɛbwala mɛ Zɛɛb neewyis kel kɔ ɛsu ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","E sok di náá, ye dinaa e mwos dwoo ɛ, ye goka ɛ́ mena saka mɛsa mɛ mot nadhis mɛ ɔ. Pum moo ɛ́ ɛkunaaɛpe, esok yɛ aadi náá, mot aanàkwaabaakwak ɛsa mɛsa ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","E sok mɛ di, mɛ dinaa kɔ bɔs'ak ɛ, mɛ ɛ mot di djɛ gwyɛ kɔ bɔs ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bhis nyɛ nazelii deenek ɛ, Yezu eezɛsɛɛ mɛtel e bɔs. Bhii tak nyɛ eezɛpul bɔs nɛ yɛ, nɔɔ bhɔtɔ tak, zɛlɔɔb emis mɛ mot edhim yenɔk. ");
INSERT INTO bkw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Bhii tak, Yezu eezɛke nɛ nɛ náá: «Tɔ́a kɛgwyii mis pɛ tok mɛdii Silowe.» Ɛkpa ɛ Silowe kwyɛl ɛlɛɛ ɛ «Mot lwoma». Tin, mot edhim yenɔk eezɛnɔɔ nyel, tɔ́, kɛgwyii mis. Dáa nyɛ nasilal ɛ, nyɛ eezɛsik. Dáa nyɛ nabula ɛ, ye nabɛɛ, nyɛ moo tin é bee ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bot ɛ bɛ nɛ bɛ nɔɔ nadidi é lɛt mendjaa wat sok ɔ, nɛ bot ɛ nadi ebee dáa nyɛ nadi sok é bɔɔ esa nɛ bot ɛ. Bot ɛ tak zɛni é zɛdjinel pak'ɔɔ náá: «Ye tok mot nadidi ndiindil é ngwoob gba ebɔɔ esa nɛ bot'aak e?» ");
INSERT INTO bkw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tin, bak bot náá: «Hɛɛɛ ye ɛ́ nyɛy.» Yak kyee bot náá: «Ààbɛ! Ye tok nyɛy. Bɛ nɔŋel ɛ́ nɔŋela.» Tin, mot'enɔk eezɛke nɛ nɔɔ náá: «Ye ɛ́ mam.» ");
INSERT INTO bkw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tin, bɛ eezɛdji nyɛ náá: «Ha mis mɔ ka bɛŋel dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mot'enɔk eezɛbɔɔza nɛ nɔɔ náá: «Mot di djóoaa Yezu nɔk ɛ́ sɛɛ mɛtel é bɔs. Bhii tak nyɛ eezɛnɔɔ bhɔtɔ tak, lɔɔb mɛ yɛ é mis. Bhii tak, nyɛ eezɛke nɛ nam náá: “Tɔ́a, kɛgwyii mis pɛ tɔ tok mɛdii Silowe.” É di'enek, mɛ eezɛtɔ́ kɛgwyii mis. Tin, mɛ moo bee ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɛ eebaazɛdji nyɛ náá: «Mot tak moo wo?» Tin, nyɛ eezɛbɔɔza náá: «Mam ààgu.» ");
INSERT INTO bkw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tin, bɛ eezɛzyɛ nɛ mot nadi sok nɛ ɛbɛ́ ɛ edhim ɔ, pɛ daa eFalizyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yezu nasa bhɔtɔ, tsik nyɛ nɛ ye ɛ́ dwoo saba. ");
INSERT INTO bkw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Etɛp tak ɛ́ eFalizyɛ pɛ yɔbɔ kyee nabaadji nyɛ dum nɛ sa nasɛɛ etɛp mis mɛ neebɛŋel ɛ. Deenek, nyɛ ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Nyɛ eelɔɔb mɛ ebhɔtɔ é mis. Bhii tak, mɛ eetɔ́, kɛgwyii mis. Tin, mɛ moo nenak ɛ́, é bee ɛnyɔɛpe.» ");
INSERT INTO bkw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bɛdhiiti bot pak eFalizyɛ moo tin é ke pak'ɔɔ náá: «Mot sa kwaambi etɛp dáak ɔ tok lwomaa ɛ Zɛɛb. Etɛɛ náá, nyɛ ààduwal etsi Zɛɛb dum nɛ dwoo saba.» Yak kyee bot pak'ɔɔ náá: «Mot mesyem tok nɛ ghwyil ɛsa endem e mɛbwala mak.» Tin, eFalizyɛ moo tin ɛ́, bɛ eezesyaala pak'ɔɔ dum nɛ tɛp tak. ");
INSERT INTO bkw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wɔ gwaa eFalizyɛ tak baazɛdji mot edhim natsak ɔ náá: «Mba wɔy wɔ ɛmet, wɔ ke dáa dum nɛ mot bɛ ɛ́ mis mɔ ɔ?» É di'enek, nyɛ eezɛbɔɔza náá: «Nyɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bela tin náá, ekukuma eYuda nabɛɛ ààkwyɛl ɛmyaal náá, nyɛ nadi sok ɛ́, nɛ edhim, mos nyɛ moo nyaa-sok. Etɛp tak ɛ́ bɛ nabaadal sɛɛg nɛ nyɛɛg mot tak náá, bɛ zyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Etɛɛ náá, bɛ neezɛdji bɛ. Tin, bɛ eezɛdji bɛ náá: «Ye ɛ́ tsɛɛtsɛ náá, nwyak ɛ́ mɔn'en e? Ye ɛ́ tsɛɛtsɛ náá, nyɛ nadi sok ɛ́, nyɛ byel ɛ nɛ ɛbɛɛ edhim e? Ye sa dáa, etɛɛ náá, nenak, mis mɛ nyaa-sok?» ");
INSERT INTO bkw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Sɛɛg nɛ nyɛɛg eezɛbɔɔza náá: «Bis eegwyak náá, ye ɛ́ mɔn'es. Nyɛ nabyel ɛ́ nɛ ɛbɛ́ ɛ edhim. ");
INSERT INTO bkw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nenak nyɛ moo bee ɛnyɔɛpe. Tin, dáa nyɛ tsak ɛ, mot tsik nyɛ ɔ di náá, bis ààgu yisɔ. Djika nyɛy nyɛ ɛmet. Etɛɛ náá, nyɛ moo ɛ́ nɛ membu di náá, nyɛ ɛ́ nɛ ghwyil ɛlɛɛ bin nyɛ ɛmet dáa e sael ɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sɛɛg nɛ nyɛɛg nalii deenek ɛ́, etɛɛ náá, bɛ nadi kaab ekukuma eYuda. Etɛɛ náá, bɛ nadi egu náá, mot aake náá, Yezu ɛ́ Mɛsia ɔ, mot tak ɛ waasɔaa tɔ ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ye ɛ́, étɛp tak ɛ sɛɛg nɛ nyɛɛg nake náá: «Nyɛ moo ɛ́ nɛ membu di náá, nyɛ ɛ́ nɛ ghwyil ɛlɛɛ bin nyɛ ɛmet dáa e sael. Djika nyɛ, nyɛy nyɛ ɛmet!» ");
INSERT INTO bkw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wɔ gwaa eFalizyɛ zokabaadjóo mot edhim natsak ɔ, djóoa sis. Bɛ eebaazɛke nɛ nɛ náá: «Lɛɛa bis nɛ tsɛɛtsɛ emis ɛ Zɛɛb, etɛɛ náá, bis nɛ gu náá, mot yenɔk ɛ mot mesyem.» ");
INSERT INTO bkw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Mam ààgu yam, nɛghu nyɛ ɛ́ mot mesyem ɔ. Mam gu ɛ sa wat náá: Mɛ nadi ɛ́ nɛ edhim. Nenak, mɛ moo bee ɛnyɔɛpe.» ");
INSERT INTO bkw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","EFalizyɛ eezɛdji nyɛ náá: «Nyɛ sa wɔ ye? Nyɛ tsik mis mɔ dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mot yenɔk eebaazɛbɔɔza nɛ nɔɔ náá: «Mɛ eezelɛɛ bin, bi ààkwyɛl ɛgwak. Etɛp ye bi di kwyɛl náá, mɛ baabasal bin yɛ esok ebá? Mɛ bee ɛ náá, bi ɛpekwyɛl náá, bi di bɛdjekel bɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tin, bɛ eezɛlee nyɛ, bɛ eezɛke nɛ nɛ náá: «Ye ɛ́ wɔy ɛ di djekel mot tak, etɛɛ náá, bisɔ ɛ bɛdjekel ɛ Moiiz. ");
INSERT INTO bkw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Bisɔ nɛ gu náá, Zɛɛb naalii nɛ Moiiz. Yɛ kabɛ nyɛy ɔ, bis ààgu nyɛ, ààbaagu pe pɛ kyee nyɛ nadus ɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mot edhim natsikaa ɔ, zokabaake nɛ nɔɔ náá: «Beeka, sa mɛ di djoka ye ɛ́ yenek: Bi ààbaagu pɛ kyee nyɛ nadus ɛ, dhi biyɔ é bee náá, nyɛ ɛ́ tsik mɛ. Ye ɛ́ mɛ di bee ɛnyɔɛpe'aak. ");
INSERT INTO bkw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bela náá, mena nɛ guka náá, Zɛɛb ààgwak bot ɛ mesyem. Nyɛ dyeebagwak ɛ bot ɛ di duwal nyɛ nɛ ɛsa ɛkwosak ɛ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kana bɔs nalookusel, mena dinaa ààpaagwak sok náá, dhiiti mot ɛpetsik mis mɛ mot nabyel nɛ ɛbɛ́ ɛ edhim ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mot'ak ɛpedi ɛ́ ààdus pɛ daa Zɛɛb ɔɔ, pe nyɛ aanàkwaasa etɛp e mɛbwala mɛ nyɛ di esa'aak.» ");
INSERT INTO bkw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","EFalizyɛ eezɛke nɛ mot yenɔk náá: «Kana dwoo mɛbyel mɔ, kɛyaka nɛ dwoo pan mos'ak, wɔ ɛ “tɔp” tɔ mesyem. Da mbi mot dáa wɔy ɛ zɛlyo bis e?» Bhis nyɛ nake deenek ɛ, wɔ gwaa bɛ zɛsɔ nyɛ tɔ ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Dáa Yezu nagwak náá, eFalizyɛ naasɔ mot yenɔk tɔ ndjaa mendjaala mɛ eYuda ɛ, nyɛ ɛ́ boo zɛboma nɛ nɛ. Nyɛ eezɛdji nyɛ náá: «Wɔ nɛ ɛdum koŋ nɛ Sɛɛŋɛlɛ Mɔn Mot e?» ");
INSERT INTO bkw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tin, mot yenɔk eezɛbɔɔza nɛ Yezu náá: «Lɛɛa mɛ, Ghɛŋ, ye ɛ́ ɛzɛ, étɛp mɛ needum koŋ nɛ nɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yezu eezɛbɔɔza nɛ nɛ náá, «Wɔ ɛpebee nyɛ, etɛɛ náá, nyɛy ɛ di sok bhwoob'ɔ, nyɛ ɛ́ di lii nɛ nɔ nenak'aak.» ");
INSERT INTO bkw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tin, mot yenɔk eezɛbɔɔza náá: «Ghɛŋ, mɛ eedum koŋ nɛ nɔ!» Bhii tak, nyɛ eezɛkwyit mɛboŋ si sok bhwoob ɛ Yezu, étɛp ɛduwal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yezu eezɛbil ɛkpa náá: «Mɛ nazyɛ kɔ bɔs'ak ɛ, etɛɛ náá, bot neezɛpɛ́ɛaa. Etɛɛ náá, mis mɛ bot ɛ edhim neebɛŋel. Etɛɛ náá, bot ɛ nadi nyaa sok ɔ, neebela edhim.» ");
INSERT INTO bkw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bɛdhiiti eFalizyɛ nadi e bhaaz'ɛ ɔ, naagwak dáa nyɛ nalii deenek ɛ. Wɔ gwaa bɛ zɛdji nyɛ náá: «Bot ɛ edhim tak ɛ dɔɔ nɛ bisɔ e?» ");
INSERT INTO bkw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Bi ɛpedi ɛ́ bot ɛ edhim ɔ, pe bi ààpasa mesyem. Dáa bi di ke náá: “Bis ɛpebee” ɛ, étɛp tak ɛ bi di tɔ ndjɛ sɔs dáa bot ɛ mesyem.» ");
INSERT INTO bkw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yezu eezɛke náá: «Mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ náá: Mot ɛ di ààni tɔ beeba ebhata pɛ ɛniel ɔ, nyɛ tsel peeb tselak e dhiiti di ɔ, yenɔk mot ɛ mot djii. Nyɛ ɛ́ mot ebhooba. ");
INSERT INTO bkw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Deenek, mot di ni pɛ ɛbɛ ɛ beeba ebhata ɔ, nyɛy ɛ di mbaalel ebhata. ");
INSERT INTO bkw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","É di'enek, mot di baal beeba ebhata ɛ waadi nyɛ ɛbɛ ɛ beeba. Tin, ebhata ɛ waagwak gwoodɛ, bhii tak nyɛ ka djóo bɛ, ngɔɔngɔt nɛ min mɔɔ. Bhii tak nyɛ ɛ́ wyisal bɛ pɛ kel. ");
INSERT INTO bkw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bhis nyɛ aazewyisal bɔɔ djas pɛ kel ɛ, nyɛ kakɛ ɛ́ pɛ sok. Ebhata é du nyɛ pɛ bhis, etɛɛ náá, bɛ nɛ gu gwoodɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tin, ebhata tok nɛ ghwyil ɛdu ndjoŋ mot. Deenek, yɛ bɛ náá, bɛ ààgu mot tak ɔ, bɛ waakaab nyɛ, tɔ́ ɛtsetaɛpe, etɛɛ náá, bɛ ààgu gwoodɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","E sok Yezu zɛlɛɛ bɛ kana ɛ, bot ɛ nadi gwak nyɛ ɔ, nabɛɛ àànyɔ ɛmɛt ɛsuk ɛ kana tak. ");
INSERT INTO bkw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yezu eebaazɛke náá: «Mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ náá: Ye ɛ́ mam ɛ di ɛbɛ ɛ ɛniel beeba ebhata. ");
INSERT INTO bkw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bot djas nazyɛ ɛsok nɛ nam ɔ, nabɛɛ bot ɛ djii, bot ɛ ɛzɛm. Deenek, ebhata nabɛɛ ààgwak bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ye ɛ́ mam ɛ di ɛbɛ ɛ ndjaa. Mot aadhaa pɛ daa lam etɛp nyɛ neeni ɔ, nyɛ waabela tsik. Nyɛ ɛ́ nɛ ghwyil ɛni nɛ ɛwyis dáa nyɛ kwyɛl ɛ. Nyɛ waabela edee e dek. ");
INSERT INTO bkw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Etɛɛ náá, mot djii zyɛ ɛ́ étɛp ɛzɛ djii, nɛ zɛgó, nɛ saab. Mam nazyɛ etɛɛ náá, bot neebela tsik, bɛ neebela esa djas di egoka nɛ nɔɔ étɛp bɛ needi tɔ mbɛɛ tsik ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Ye ɛ́ mam ɛ di mbɛɛ mbaalel ebhata. Mbɛɛ mbaalel ka nyel'ɛ gha kɔ esu ɛ ebhata bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mot nɔŋaa e mɛsa mɛ ɛbaal ɛ ebhata, étɛp nyɛ neetuudaa nɛ epata ɔ. Ye tok nyɛy di mbaalel ebhata. Ɛtɛɛ náá, ebhata tok yɛ. Nyɛ bee ben é zyɛ ɔ, nyɛ ɛ́ nɛ ghwyil ɛdhuugal ɛsaa ɛ ebhata da nyɛ kpaa nɛ ekaab. É di'enek, ben ɛ waaghaaga ɛsaa ebhata binɔk e nyel, nɔɔ bɛ, dɛ bɛ nɛ ɛtwak ɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Beeka, ye sɛɛ deenek ɛ, etɛɛ náá, mot tak sa mɛsa ɛ, etɛp nyɛ neetuudaa. Nyɛ ààbem ba nɛ tɛp ebhata. ");
INSERT INTO bkw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Ye ɛ́ mam ɛ di mbɛɛ mbaalel ebhata. Etɛɛ náá, mɛ nɛ gu ebhata bam; ebhata bam pe nɛ gu ɛ mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tyee wat nɛ dáa Saag'am di gu mɛ ɛ; mam pe nɛ gu Saag'am. Deenek ɛ mɛ di gwyena tsik'am kɔ ɛsu ɛ ebhata bam. ");
INSERT INTO bkw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mɛ ɛ nɛ bɛdhiiti ebhata di náá, bɛ dinaa ààpaani tɔ beeba ɛ. Ye goka ɛ́ náá, mɛ kɛ ɛnɔɔ bɛ, etɛp ɛdjɛɛd ɛ bɛ. Bɛ ɛ́ waagwak gwoodam. Bhii tak bɛ waazyɛ bɔɔ bɛ ɛmet zɛsɛɛga nɛ bɔɔ bɛ sɔ bɔɔ, si mɛko mɛ mbaalel ngɔt. ");
INSERT INTO bkw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Saag'am dyeebakwyɛl mɛ ɛ etɛɛ náá, mɛ waagel nyel'am, bhii tak da mɛ ɛ baabulal yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mot tok nɛ ghwyil ɛnɔɔ tsik'am. Ye ɛ́ mam mɛ ɛmet ɛ di gwyena yɛ nɛ ɛkwosak ɛ lyem'am. Mɛ ɛ nɛ ghwyil ɛdjɛ yɛ. Mɛ ɛ nɛ ghwyil ɛ ɛbaanɔɔ. Ye ɛ́ nɛ eghɛŋ ɛ saag'am ɛ mɛ nasa deenek.» ");
INSERT INTO bkw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mɛkpa menek naabaazɛwa mɛbɛka ɛlyelɛpe pak eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kyee wat eYuda náá: «Mot tak ɛ nɛ ɛlyeeb tɔ lɛ! Nyɛ ɛ́ mot mɛlyet! Étɛp ye bi di gwak etɛp bɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yak kyee náá: «Mot di nɛ ɛlyeeb tɔ lɛ ɔ, tok nɛ ghwyil ɛlii dáa nyɛ di lii'aak. Ɛlyeeb ɛ nɛ ghwyil ɛtsik mot edhim nyɛ nyaa sok e?» ");
INSERT INTO bkw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ye nabɛɛ, e mbu kwol, pɛ Yeluzalɛm bɛ nadi ebɔl ɛbyoŋ ɛ bɛ nadi taala dwoo Ndjaa-ebuwa nadiiaa ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yezu nadi duula si bhaaz mɛ kok Ndjaa-ebuwa nagetaa din ɛ «bhaaz ɛ Salomɔŋ» ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tin, wɔ gwaa eYuda zɛsɛɛga e ngwoobɛ, bɛ ɛ́ boozɛdji nyɛ náá: «Wɔ kwyɛl ɛ náá, bis di ebhwood kɛkum yaa ɛwala? Nɛghu wɔ ɛ Mɛsia ɔ, lɛɛa bis ɛnyɔɛpe, etɛp bis neegwak.» ");
INSERT INTO bkw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mɛ nabɛɛ, mɛ eezelɛɛ bin, bi ààkwyɛl ɛdum ɛ koŋ nɛ nam. Sonok esa e mɛbwala mɛ mɛ di sa nɛ din ɛ Saag'am ɛ ye ɛpetaŋal mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Tin, bi di ààdum koŋ nɛ nam ɛ etɛɛ náá, bi tok tɔ ɛsaa ɛ ebhata bam. ");
INSERT INTO bkw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɛsaa ɛ ebhta bam nɛ gwak gwoodam; mɛ nɛ gu bɛ. Etɛp tak ɛ bɛ di du mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mɛ ɛpedjɛ bɛ tsik na kɔm-kɔm, bɛ aanàkwaadiib dhiiti dwoo. Mot tok nɛ ghwyil dɛk mɛ ba. ");
INSERT INTO bkw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sa Saag'am nadjɛ mɛ ɛ, eedhaa esonok djas. Etɛp tak ɛ di náá, dhiiti mot tok nɛ ghwyil ɛdɛk sa tak tɔ mbɔ Saag'am. ");
INSERT INTO bkw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mam nɛ Saag'am, bis ɛ mot ngɔt.» ");
INSERT INTO bkw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tin, wɔ gwaa eYuda baazɛtek mɛkok étɛp bɛ neegó nyɛ nɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","É di'enek, Yezu eezɛke nɛ nɔɔ náá: «Mɛ eedyeebazelyaal bin embɛɛ mɛsa mɛ Saag'am. Tɔ mɛsa menek djas, kɔ esu ɛ yaa mɛsa mɛ mɛ sa etɛp mɛ goka nɛ ɛgóaa nɛ mɛkok?» ");
INSERT INTO bkw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tin, eYuda eezɛbɔɔza nɛ nɛ náá: «Bis ààsaŋ ɛgó ɛ wɔ nɛ mɛkok etɛp mbɛɛ mɛsa. Bis aasaŋ ɛgo ɛ wɔ etɛɛ náá, wɔ ɛpebyasal Zɛɛb! Dhi wɔy di mot, wɔ kwyɛl ɛlyaal bot ɛ náá, wɔ ɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","É di'enek, Yezu ɛ́ boozɛbɔɔza nɛ nɔɔ náá: «Tɔ etsi bin, ekwyala ke ɛ náá: “Mɛ ke ɛ náá, bi ɛ bɛzɛɛb.” ");
INSERT INTO bkw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mena nɛ guka náá, mena tokeka nɛ ghwyil ɛdis sa zeekwyalaa ɛ. Deenek, Zɛɛb djóo bot ɛ di gwak mɛkpa mɛ nɛ bot ɛ di myaal yɛ ɔ, “bɛzɛɛb”. ");
INSERT INTO bkw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yɛ kabɛ mam ɔ, Saag'am naazetɔ́ mɛ, bhii tak Nyɛ eezɛlwom mɛ kɔ bɔs. Etɛp ye bi di ke náá, mɛ eelee Zɛɛb, etɛɛ náá, mɛ eelɛɛ náá: “Mɛ ɛ Mɔn Zɛɛb” e? ");
INSERT INTO bkw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yɛ bɛ náá, mɛsa mɛ mɛ di sa ɛ, tok mɛsa mɛ Saag'am ɔ. Ye ɛ́ deenek ɛ bi aadi ààdum koŋ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yɛ kozobɛ náá, bi ààdum koŋ nɛ nam ɔ. Dumka koŋ dum nɛ endem e mɛbwala mɛ mɛ di sa ɛ. Étɛp bi neegu gua wat náá: Saag'am ɛ tɔ lam; deenek mam ɛ tɔ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tin, bɛ nabaadiɛ, é saa dáa bɛ mɛt nyɛ. Nyɛ naadus bɛ e mɛmbɔ. ");
INSERT INTO bkw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Bhii tak Yezu eebaazɛtɔ́ pɛ yii kyiid dii Yuldɛn, e di Zaŋ Nduuel-bot nadi é duu bot Zɛɛb sok ɔ. Nyɛ eekɛdi ba mɛlu penek. ");
INSERT INTO bkw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tin, wɔ gwaa mɛdhuu mɛ bot zokazyɛ pɛ nyɛ nadi ɛ́. Bot ɛ tak eezɛke nɛ nɛ náá: «Zaŋ nabɛɛ ààsa dhiiti ndem mɛbwala mɛ wat. Beeka náá, etɛp djas nyɛ di lɛɛ dum nɛ mot tak ɛ djas ɛ tsɛɛtsɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","É di'enek, bot ɛbuɛpe naazɛdum koŋ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dhiiti mot ngɔt din ɛ lɛ nabɛɛ Lazaad, zokazɛbɛ. Nyɛ nadidi ɛ kɔ ghaada di djóoaa Bhetani ɛ, dɛl ɛ Maali bɛ nɛ mɔn nyɛɛg Maat. ");
INSERT INTO bkw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maali ɛ moma naso ɛlas mɛnanas kɔ mɛko ɛ Ghɛŋ Yezu ɔ, da bhii tak nyɛ ɛ́ zɛsuŋal nɛ bhooɛ ɔ. Ye ɛ́ dhem, Lazaad ɛ nadi bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Boa binɔk bɛbá ɛ, zokazɛlwom mot, nyɛ lɛɛ nɛ Yezu náá: «Ghɛŋ, sɔɔ wɔ di kwyɛl ɔ ɛpebɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dáa Yezu nagwak bhaadal tak ɛ, nyɛ ɛ́ booke náá: «Lazaad ɛpebɛ. Ɛbɛ́ ɛ tak tok etɛp nyɛ neegwyɛ. Deenek ɛ, etɛɛ náá, dék ɛ Zɛɛb neenyen emis mɛ bot. Deenek ɛ etɛɛ náá, Mɔn Zɛɛb neebaabela dék é mis mɛ bot, dum nɛ tɛp tak.» ");
INSERT INTO bkw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Bela tin náá, Yezu naadyeebakwyɛl Maali, nɛ Maat zɛnɔɔ dhemɔɔ Lazaad. ");
INSERT INTO bkw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ghuna dáa nyɛ nagwak bhaadal náá Lazaad ɛpebɛ́ ɛ, nyɛ naabaadjaasi mɛlu mɛmbá bhii tak kɔ dɛl ɛ nyɛ nadi ɛ́, nyɛy ààtɔ́. ");
INSERT INTO bkw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bhii tak nyɛ eezɛke nɛ bɛdjekel bɛ náá: «Djhooka sikeka pɛ kyee dik Yude.» ");
INSERT INTO bkw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tin, bɛdjekel eezɛke nɛ nɛ náá: «Labhi, bɛ aalóo nɛ saŋ ɛgó ɛ wɔ nɛ mɛkok penek koko-ɛ-koko. Mos wɔ baakwyɛl ɛ, ɛtɔ́ penek e?» ");
INSERT INTO bkw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","É di'enek, Yezu eezɛbɔɔza nɛ nɔɔ náá: «Mwos wat ɛ mɛwala kam nɛ ebá. Mot ɛ kɛ tɔ gwyɛ mwos ɔ, nyɛ aanàkwaabema ɛbɛk. Etɛɛ náá, nyɛ ɛpebee gwyɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tin, mot ɛ kɛepum ɔ, nyɛ waabema ɛbɛk. Etɛɛ náá, nyɛ tok nɛ sa aasa náá, nyɛ bee ze ɛnyɔɛpe.» ");
INSERT INTO bkw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bhis Yezu nake deenek ɛ, nyɛ ɛ́ boo baakɛl náá: «Mɔɔ sɔ yena Lazaad eedhaa gɔ́. Mɛ ɛpetɔ́, kɛdjem nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bɛdjekel eezɛbɔɔza náá: «Ghɛŋ, yɛ bɛ náá, nyɛ eedja gɔ́ ɔ, nyɛ waatsak.» ");
INSERT INTO bkw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yezu nadi lii deenek ɛ, étɛp ɛsyee ɛ Lazaad. Bɛdjekel bɛ nagu ɛ náá, nyɛ nadi lii ɛ, dum nɛ tɛtɛ gɔ. ");
INSERT INTO bkw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tin, Yezu ɛ́ boozɛlɛɛ bɛ mɛpyɛmɛ ààsyeeba náá: «Lazaad eegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mɛ ɛpemyaala etɛɛ náá, mɛ bɛɛ ààdi penek. Yɛ waasa náá, bi dum koŋ nɛ nam. Tin, djhokaka pɛ kyee nyɛ di ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tin, Toma nagetaa din ɛ «Ɛwas» ɔ, eezɛke nɛ bak bɛdhiiti bɛdjekel náá: «Djhootɔ́ka, yɛ bɛ ɛsyee ɔ, bɛ gó menabɛlka djas.» ");
INSERT INTO bkw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Dáa Yezu nakum ɛ, Nyɛ eegwak náá, Lazaad moo nɛ ɛdiyo mos ɛ mɛlu mɛná. ");
INSERT INTO bkw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tinaak, nɛŋ pak dɛl Bhetani nɛ Yeluzalɛm nabɛɛ tyee ekilomɛtɛlɛ elɛl. ");
INSERT INTO bkw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","É di'enek, bɛtɛ nɛ eYuda nabɛɛ, bɛ eezyɛ pɛ daa Maali nɛ Maat étɛp ɛzɛdjɛ bɛ ghwyil kɔ ɛsyee ɛ dhem'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Dáa Maat nagwak náá, Yezu eetuula ɛ, wɔ gwaa nyɛ zɛtɔ́, kɛboma nɛ nɛ. Tin, Maali eezɛlik yɛ ndiidil pɛ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maat eezɛke nɛ Yezu náá: «Ghɛŋ, wɔ ɛpedi wak ɔ, pe dhem'am ààpagwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Deenek, mɛ nɛ gu náá, dɔɔ nɛ nenak, esonok djas waawaab nɛ Zɛɛb ɛ, nyɛ waadjɛ wɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tin, Yezu zɛbɔɔza náá: «Dhemɔ ɛ waagom tɔ ɛsyee.» ");
INSERT INTO bkw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maat eezɛbɔɔza náá: «Mɛ nɛ gu náá, nyɛ waagom tɔ ɛsyee e dwoo mɛsik, esok bot djas aazɛgom tɔ ɛsyee ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yezu zokabaazɛbɔɔza náá: «Ye ɛ́ mam ɛ di ɛgomel ɛ bot ɛ nagwyɛ ɔ. Mam ɛ di tsik. Mot ɛ dum koŋ nɛ nam ɔ, nyɛ waabela tsik, ye nàkozodi náá, nyɛ naazegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tin, mot di nɛ tsik, e dum koŋ nɛ nam ɔ, nyɛ aanàkwaagwyɛ. Wɔ eemyaal e?» ");
INSERT INTO bkw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maat eezɛmyaal náá: «Iyoo Ghɛŋ. Mɛ nɛ gu náá, wɔ ɛ Mɛsia, Mɔn Zɛɛb. Wɔ ɛ di mot Zɛɛb nakɛk náá, nyɛ ɛpezyɛ kɔ bɔs ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bhis mɛkpa menek, Maat eezɛsik pɛ ndjaa kɛdjóo mɔn nyɛɛg Maali. Tin, nyɛ eezɛnyeŋal nyɛ tɔ ɛlɔ náá: «Lyoel eetuula, nyɛ ke ɛ náá, wɔ kɛboma nɛ nɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Dáa Maali nagwak deenek ɛ, nyɛ eezɛwyɛl «ngbat», nɔɔ nyel, tɔ́ pɛ pak Yezu nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ghuna Yezu nabɛɛ, nyɛ dinaa ààkotuula-tuula kɔ dɛl ɛ tak. Nyɛ nabɛɛ nyɛ dinaa e di bɛ nɛ Maat naboma ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","EYuda naazɛmɔ nɛ Maali tɔ ndjaa étɛp ɛdjɛ nyɛ ghwyil kɔ ɛsyee. Dáa bɛ nabee nyɛ nawyɛl deenek «ngbat», wyis pɛ kel ɛ, bɛ eezɛdu nyɛ. Etɛɛ náá, bɛ nagek ɛ náá, nyɛ natɔ́ ɛ pɛ ɛvit kɛdje. ");
INSERT INTO bkw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bhii tak, Maali zɛkum pɛ Yezu nadi ɛ́. Dáa nyɛ nabee nyɛ ɛ́, nyɛ eezɛghaaga si mɛko mɛ. Nyɛy nɛ Yezu náá: «Ghɛŋ, wɔ ɛpedi wak ɔ, pe dhemam ààpagwyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yezu nabee nyɛ, bɛ nɛ bot ɛ nadu nyɛ edje. Tin, ye naazɛsa nyɛ ghoŋ dhaa nyel. ");
INSERT INTO bkw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","É di'enek, nyɛ eezɛdji bɛ náá: «Bi kɛnɛɛg muu ɛ paa?» Bɛ eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, dha, wɔ neezɛbee.» ");
INSERT INTO bkw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tin, Yezu eezɛdje. ");
INSERT INTO bkw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Deenek, eYuda eezɛke náá: «Beeka dáa nyɛ nadi kwyɛl nyɛ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tin, bɛdhiiti bot pak eYuda binɔk moo tin é ke náá: «Nyɛy mot di ebɛɛ bot ɛ edhim mis ɔ, nyɛ bɛ ɛ́ ààkwak ɛlu náá, Lazaad nàgwyɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yɛ eezɛbaasa Yezu boo ghoŋ tɔ lyem, bhii tak nyɛ eezɛtɔ́ pɛ ɛvit. Ye nabɛɛ tɔ gho ɛkok kpaka. Ɛvit ɛ tak nadidi aalaa ɛ nɛ boo ɛkok na bɔk-bɔk. ");
INSERT INTO bkw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tin, Yezu eezɛke nɛ nɔɔ náá: «Diska ɛkok!» Wɔ gwaa Maat, kɛl mot nagwyɛ ɔ, zɛpesal náá: «Ghɛŋ, nyɛ moo mos ɛ nɛ mɛlu mɛná bhis nyɛ nazedelaa ɛ. Nyɛ ɛ́ nɛ ghwyil ɛka nuub ɛlyelɛpe.» ");
INSERT INTO bkw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yezu eezɛbɔɔza nɛ nɛ náá: «Mɛ bɛ ɛ́ ààlɛɛ wɔ náá, wɔ dum koŋ nɛ nam ɔ, wɔ waabee duma ɛ Zɛɛb e?» ");
INSERT INTO bkw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bhii tak, bɛ eezɛdis ɛkok nadi é ɛbɛ ɛ ɛvit ɛ. É di'enek, Yezu eezɛben mis pɛ ɛko, wɔ gwaa nyɛ ke náá: «Saag'am, ghaapɛɛ etɛɛ náá, wɔ eegwak mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mɛ nɛ gu náá, wɔ eeloozyɛ nɛ ɛgwak ɛ mɛ, Tinaak, mɛ lii deenek ɛ, etɛɛ náá, mɛdhuu mɛ bot ɛ di wak'ak neemyaal náá, wɔy ɛ nadhis mɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Dáa nyɛ nazɛke deenek ɛ, wɔ gwaa Yezu zɛbam ɛlyelɛpe náá: «Lazaad, wyisa!» ");
INSERT INTO bkw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tin, mot nagwyɛ ɔ eezɛwyis tɔ ɛvit. Nyɛ eezɛwyis nɛ mɛmbɔ nɛ mɛko ewola nɛ epes ekaad nyɛ napilaa tɔ tak ɛ. Dɔɔ nɛ bhoob dipela nɛ epes ekaad e tak. Bhii tak, Yezu eezɛke nɛ nɔɔ náá: «Tiika nyɛ epes ekaad binek e nyel nyɛ neekɛ ɛnyɔɛpe. Da bi ɛ bet nyɛ, nyɛ tɔ́.» ");
INSERT INTO bkw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","EYuda ɛbuɛpe tɔ sama bot ɛ nazyɛ, zɛmɔ nɛ Maali tɔ ɛsyee ɔ nabee edjema mɛbwala mɛ Yezu nasa ɛ. Wɔ gwaa bɛ zokazɛdum koŋ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tinaak, bɛdhiiti bot tɔ sama eYuda tak eezɛtɔ́, pɛ daa eFalizyɛ. Bɛ eekɛlɛɛ bɛ etɛp djas ee nasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tin, wɔ gwaa eboo bɛghaa-Zɛɛb nɛ eFalizyɛ zokazɛsɛɛga tɔ boo kwan eYuda. Bɔɔ náá: «Mena saka dáa? Mot tak dinaa, esa bɛtɛ nɛ eboo endem e mɛbwala yenek! ");
INSERT INTO bkw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mena betka nyɛ, nyɛ gheesa endem e mɛbwala menek ɔ, bot djas ɛ waadum koŋ nɛ nɛ. Tin, ekukuma eLɔm waazɛwaaz Ndjaa-ebuwa lena nɛ dhaad mbyak yena.» ");
INSERT INTO bkw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mot ngɔt pak'ɔɔ, din ɛ lɛ nabɛɛ Kayif. Nyɛ nabɛɛ boo ghaa-Zɛɛb e mbu tak. Nyɛ eezɛke nɛ nɔɔ náá: «Bi ààtiibal ɛnyɔɛpe! ");
INSERT INTO bkw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bi ààgu sa di nyɔ nɛ nena ɛ? Ye goka ɛ́ mot ngɔt gwyɛ étɛp bot ɛ mbyak yena. Deenek ɛ di náá, bot ɛ mbyak yena djas aanàkwaawyɛɛza.» ");
INSERT INTO bkw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ghuna nyɛ nabɛɛ ààdi é ke deenek nɛ ɛtselal ɛ lɛ ɛmet. Ye nabela ɛ náá, nyɛy ɛ nadi boo ghaa-Zɛɛb e mbu tak. Nyɛ nadi lɛɛ etɛp binek nɛ ghwyil ɛ Zɛɛb náá, Yezu ɛ waagwyɛ kɔ ɛsu ɛ bot ɛ mbyak eYuda. ");
INSERT INTO bkw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tin suk ɛsyee ɛ Yezu tak nabɛɛ ààbɛ étɛp eYuda bɔɔ bɛ met. Ye nabɛɛ dɔɔ nɛ étɛp ɛsɛɛg e nyel wat bɔɔ Zɛɛb djas zewyɛɛza «lapa-lapa» kɔ bɔs ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kana dwoo tak, ekukuma eYuda naamyam ɛgó ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Etɛp tak ɛ Yezu nakat ɛduula emis eYuda. Tin, nyɛ eezɛtɔ́ pɛ dhiiti dɛl e ngwoob bal. Din ɛ dɛl ɛ tak nabɛɛ Efalayim. Penek ɛ nyɛ nakɛkwɛɛg ba mɛlu bɛ nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ye nabɛɛ, ɛbyoŋ ɛ eYuda di djóoaa «Pak» eezekunaa. Bot ɛbuɛpe nadi dus pɛ mɛl mɔɔ, tɔ pɛ ghaada Yeluzalɛm. Bɛ natɔ́ ɛ étɛp bɛ neekɛdis edhuud ɛsok nɛ dwoo ɛbyoŋ kum. Bɛ neezɛsa edjema etsi nadi lɛɛ étɛp mot needi dɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","É di'enek, bɛ moo tin é saa Yezu, ààbee nyɛ. Bɛ moo tin tɔ kok Ndjaa-ebuwa é djinela pak'ɔɔ náá: «Bi ke ɛ náá, nyɛ ɛ́ nɛ ghwyil ɛzyɛ e ɛbyoŋ ɛlak mos e?» ");
INSERT INTO bkw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ka bela náá, eboo bɛghaa-Zɛɛb nɛ eFalizyɛ naazedjɛ ɛlee náá, mot ɛ bee Yezu ɔ, da nyɛ ɛ́ zɛlɛɛ bɛ. Etɛɛ náá, bɛ nadi saŋ ɛmɛt ɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mɛlu mɛtɛn nɛ wat ɛsok nɛ dwoo ɛbyoŋ ɛ Pak kum, Yezu eezɛtɔ́ pɛ Bhetani, dɛl ɛ Lazaad mot nagwyɛ da nyɛ ɛ́ gomal nyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tin, bɛ eezɛdjaab edee etɛɛ Yezu. Maat ɛ nadi sa mɛsa mɛ ɛkɛka edee. Tɔ bot ɛ nadi kɔ mesa nɛ Yezu ɔ, ye nabɛɛ nɛ Lazaad. ");
INSERT INTO bkw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wɔ gwaa Maali zokanɔɔ pes litɛlɛ mɛnanas na boo mɛtaŋ nadi djóoaa naad ɛ. Nyɛ eezɛkɔ ɛlas ɛ tak, so kɔ mɛko ɛ Yezu. Bhii tak nyɛ moo suŋal yɛ nɛ bhoo lo'ɛ. Tin, mɛnuub mɛ mɛnanas menek zokadjala ndjaa djas. ");
INSERT INTO bkw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mot ngɔt tɔ bɛdjekel ɛ Yezu, Yudas Iskaliɔt, mot aakɛka Yezu ɔ, eezɛke náá: ");
INSERT INTO bkw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Étɛp ye mena di ààbɔmsa mɛnanas mɛ tak ɛ nɛ boo mɛtaŋ? Da nɔɔ epata mɛkam-mɛtɛn nɛ wat tak, djɛ nɛ bɛdjel ɛ bot.» ");
INSERT INTO bkw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nyɛ nabɛɛ ààke deenek, etɛɛ náá, nyɛ nadi gek bɛdjel ɛ bot ghoŋ. Nyɛ nadi eke deenek ɛ, etɛɛ náá, nyɛ nadi ɛ́ mot djii. Nyɛy ɛ nadi mɛt kola epata. Nyɛ nadi djii epata ee bot nadi wa tɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tin, Yezu ɛ́ boobɔɔza nɛ nɔɔ náá: «Betka moma yak gwyem, etɛɛ náá, nyɛ nakwom mɛnanas menek ɛ étɛp dwoo mɛdela mam. ");
INSERT INTO bkw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Etɛɛ náá, bi nɛ bɛdjel ɛ bot ɛ waadi e di wat mɛlu djas. Yɛ kabɛ mam ɔ, bi aanàkwaabaadi nɛ nam mɛlu djas.» ");
INSERT INTO bkw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bɛtɛɛ nɛ mɛdhuu mɛ eYuda zokazɛgwak náá, Yezu nadi ɛ́ pɛ Bhetani. Bɛ naazɛtɔ́, bɛ nabɛɛ ààtɔ́ étɛp ɛkɛboma nɛ Yezu nyɛy nyɛ ɛmet. Bɛ nabaatɔ́ ɛ, étɛp ɛkɛbee Lazaad, mot Yezu nagomal ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tin, eboo bɛghaa-Zɛɛb zokabaagwakel náá, ye goka ɛ́ bɛ gó dɔɔ nɛ Lazaad. ");
INSERT INTO bkw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Etɛɛ náá, ye ɛ́ kɔ ɛsu ɛ lɛ ɛ eYuda ɛbuɛpe nadi dus tɔ ɛdhuu ɛ lɔɔ étɛp ɛdum ɛ koŋ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tɔ yii mɛlem, zukamwaa nɛ mot nazyɛ étɛp ɛbyoŋ ɛ Pak ɔ zokagwak náá, Yezu nadi zyɛ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wɔ gwaa bɔɔ djas zokawyis nɛ mɛmbɔ mɛ mɛbhi e mɛmbɔ. Bɛ eezɛdus kɔ ghaada, étɛp ɛkɛboma nɛ Yezu. Bɛ nadi tsim náá: «Duu nɛ Zɛɛb! Zɛɛb goka ɛ́ nɛ ɛsɛɛ mot di zyɛ nɛ din ɛ Ghɛŋ ɔ mɛtel. Zɛɛb sɛɛ mbɛɛ mɛtel pɛ kɔ Mɛkoozi mɛ Yisalaɛl!» ");
INSERT INTO bkw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tin, Yezu eezɛbela mɔɔ swooz an. Nyɛ eezɛdisi kɔ lɛ dáa ekwyala e mɛkana mɛ Zɛɛb di elɛɛ ɛ: ");
INSERT INTO bkw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Nàbem ba, wɔy, ɛsyees ɛ ghaada Siɔŋ! Beea, mɛkoozi mɔ ɛpezyɛ, ndiindil kɔ mɔɔ swooz an.» ");
INSERT INTO bkw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","É di'enek, bɛdjekel bɛ nabɛ ɛ́ àànyɔ ɛtiibal etɛp binek. É sok Zɛɛb aaniigal Yezu tɔ dék ɛ, tin bɛ waazɛtaala náá, ekwyala naazelɛɛ etɛp binek kɔ ɛsu ɛ lɛ. Tin, bɛ naasa esa ee nagoka nɛ ɛsael dum nɛ nɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bot ɛ nadi lɔɔg wat bɛ nɛ Yezu esok nyɛ nadjóo Lazaad wyis tɔ ɛvit, da nyɛ ɛ́ gomal nyɛ ɔ. Bot ɛ tak moo tin é lɛɛ bot esesɛɛ djas nadhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Etɛp tak ɛ mɛdhuu mɛ bot nazyɛ, zɛboma nɛ nɛ. Bot naagwak náá, nyɛ naasa ndem e mɛbwala menek. ");
INSERT INTO bkw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tin, eFalizyɛ moo sɔs pak'ɔɔ náá: «Bot eebee náá, bot tokapɛ nɛ ghwyil ɛbaasa dhiiti sonok e. Etɛɛ náá, bot djas moo ɛ́ bhis koŋɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bɛdhiiti bot ɛ mbyak eGhɛlɛk, nadi ɛ́ tɔ sama bot ɛ nazyɛ pɛ Yeluzalɛm zɛduwal Zɛɛb tɔ ɛbyoŋ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tin, bɛ eezɛtiila pɛ daa Filip mot dɛl Bhɛtsaida pɛ kyee dik Ghalile. Bɔɔ nɛ nɛ náá: «Ghɛŋ, bis ɛpekwyɛl ɛbee Yezu.» ");
INSERT INTO bkw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tin, Filip eekɛlɛɛ Andele, bhii tak bɔɔ djas bɛbá eezɛtɔ́, kɛlɛɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","É di'enek, Yezu zɛbɔɔza nɛ nɔɔ náá: «Ɛwala ɛ Zɛɛb aadjɛ Sɛɛŋɛlɛ Mɔn Mot duu ɛ, eezedjala. ");
INSERT INTO bkw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ, ndu bhisa dyeebadi wat ɛ, ye dinaa ààbɛaa. Yɛ bɛ náá yɛ eewaaa tɔ bɔs tyee mot di delaa ɛ, yɛ waawyis, da djɛ bhum ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mot di kwyɛl tsik'ɛ ɔ, nyɛ waasu yɛ. Tin, mot ɛ kwyɛl Zɛɛb dhaa dáa nyɛ di kwyɛl tsik'ɛ kɔ bɔs'ak ɔ, mot yenɔk ɛ waabaal tsik'ɛ. Nyɛ waadi e di wat bɛ nɛ Zɛɛb kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mot ɛ di kwyɛl ɛsa mɛsa mam ɔ, ye goka ɛ́ náá, mot tak du mɛ. Deenek ɛ di náá, mot-mɛsa mam aadi ɛ́, e di mɛ di ɔ. Deenek ɛ Saag'am aadjɛ duu nɛ mot di sa mɛsa mam ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«É di mena kadi wak nenak'aak, lo'am moo ɛ́ zɛm-zɛm nɛ bɛtɛ nɛ esiiza ɛbuɛpe. Ye goka ɛ́ mɛ ke dáa? Mɛ ke náá: “Saag'am, pɛka mɛ e sa di kwyɛl ɛzyɛ mɛ e nyel e ɛwala ɛlak nenak”? Tin, ye ɛ́, étɛp sa di kwyɛl ɛ sael mɛ e nyel e ɛwala ɛ ɛlak ɛ mɛ nazyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Saag'am, djɛa din ɛ lɔ duu!» É di'enek, wɔ gwaa gwood wat zɛbam tɔ gwoo náá: «Mɛ naaloozedjɛ yɛ duu. Mɛ ɛpebaadjɛ yɛ duu djɛa sis.» ");
INSERT INTO bkw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ɛdhuu ɛ bot ɛ nadi tin, nakwak gwood tak ɔ, moo tin é ke náá: «Ye ɛ́ ndum bhi!» Bak bot náá: «Ye ɛ́ dhiiti fofop ngɔt ɛlii nɛ Yezu!» ");
INSERT INTO bkw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","É di'enek, Yezu eezɛke nɛ nɔɔ náá: «Gwood yenek ààpagék étɛp'am. Gwood tak gék ɛ étɛp'en. ");
INSERT INTO bkw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mena mooka ɛ́ é ɛwala bot ɛ bɔs'ak aapɛ́ɛaa ɛ. Deenek, mɛkoozi mɛ bot ɛ bɔs'ak moo zɛsɔaa. ");
INSERT INTO bkw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tin, esok mam aadus kɔ bɔs, benaa ɛ, mɛ waadul bot ɛ bɔs djas pɛ daa lam.» ");
INSERT INTO bkw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tɔ mɛkpa menek, Yezu nadi lɛɛ ɛ kɔkɔ ɛsyee nabɛ náá, nyɛ waagwyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tin, mɛdhuu mɛ bot binɔk eezɛke nɛ nɛ náá: «Bis djek tɔ mɛkana mɛ etsi bis ɛ náá, Mɛsia aadi ɛ́ nɛ tsik na kɔm-kɔm. Ha étɛp ye wɔ ke náá, “Sɛɛŋɛlɛ Mɔn Mot aadus kɔ bɔs, da nyɛ ɛ́ benaa pɛ ɛko”? Yenɔk “Sɛɛŋɛlɛ Mɔn Mot” ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yezu eezɛbɔɔza nɛ nɔɔ náá: «Gwyɛ ngel dinaa pak'en, étɛp ba mɔɔ ɛwala batsa. Kɛka e di bi dinaa tɔ gwyɛ ngel yenek, e kaab náá, ɛgwyitok ɛzɛkɛbela bin zaka. Etɛɛ náá, mot di kɛ tɔ ɛgwyitok ɔ, ààgu ze nyɛ di tɔ́ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dumka koŋ nɛ gwyɛ ngel esok bi dinaa bi nɛ bɛ nɔɔ e di wat yenek. Etɛɛ náá, bi needi bɔɔ gwyɛ ngel.» Bhis nyɛ nalii nɛ nɔɔ deenek ɛ, Yezu eezɛnɔɔ nyel, tɔ́, kɛsɔwa ɛtsetaɛpe nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bela náá, ye ɛ́ tsɛɛtsɛ náá, nyɛ naasa bɛtɛ nɛ endem e mɛbwala emis mɔɔ, bɛ nabɛɛ ààdum koŋ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Deenek ɛ, etɛp e ngoolel-mɛkpa ɛ Zɛɛb Ezayi nalɛɛ ɛ, neebela ɛsuk. Nyɛ nake ɛ náá: «Ghɛŋ, ɛzɛ myaal bhaadal yena? Ghɛŋ lyaal zɛ ghwyilɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ngoolel-mɛkpa ɛ Zɛɛb Ezayi naalɛɛ ɛ etɛp ee bot bak aadi ààdum koŋ nɛ Zɛɛb ɛ: ");
INSERT INTO bkw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Zɛɛb naadjɛ bɛ mis mɛ edhim. Nyɛ naadiyal etsoŋ bɔɔ, etɛɛ náá, mis mɔɔ needi àànyaa sok. Náá, etsoŋ bɔɔ aanàkwaadjɛ ghwyil ɛmɛt etɛp djas mɛ nasa nɛ nɔɔ ɛ. Bɛ ɛ́ nɛ ghwyil ɛliig mis gwyák Zɛɛb bula pɛ daa lam étɛp mɛ neetsik bɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ngoolel-mɛkpa ɛ Zɛɛb Ezayi nake deenek ɛ, etɛɛ náá, nyɛ nabɛɛ, nyɛ eebee dék ɛ Yezu. Étɛp tak ɛ nyɛ nadi é lii kɔ ɛsu ɛ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ghuna tɔ sama ekukuma eYuda, bɛtɛ nɛ bɛdhiiti nadi edum koŋ nɛ Yezu. Tin, dáa bɛ nadi é kaab náá, eFalizyɛ ɛ́ zɛkɛsɔ bɛ tɔ mendjaa mɛ mendjaala mɛ eYuda ɛ. Bɛ nabɛɛ ààdi lyaal ɛmyaal ɛ lɔɔ popoopwon. ");
INSERT INTO bkw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Deenek etɛɛ náá, bɛ naadyeebadje náá, bot duwal bɛ ɛbuɛpe, dhaa dhaŋa duu Zɛɛb di djɛ bot ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yezu eezɛben gwood, é ke náá: «Mot ɛ dum koŋ nɛ nam ɔ, nyɛ ààpadum koŋ nɛ nam, mam mɛ ɛmet. Nyɛ baadum koŋ ɛ nɛ mot lwom mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mot ɛ bee mɛ ɔ, nyɛ eebee mot lwom mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mam zyɛ kɔ bɔs ɛ dáa gwyɛ ngel. Deenek etɛɛ náá, mot aadum koŋ nɛ nam ɔ needi ààdi tɔ ghooghom. ");
INSERT INTO bkw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Mot di gwak mɛlyo mam. Da nyɛ ɛ́ di, ààkɛ dáa mɛkpa mɛ tak di kwos ɛ, ye tok mam di kwyesal nyɛ ndjɛ sɔs. Etɛɛ náá, mɛ nazyɛ, zɛtsik bot ɛ bɔs. Mɛ nabɛɛ ààzyɛ, zɛpɛ́ɛ bot ɛ bɔs'ak. ");
INSERT INTO bkw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mot ɛ byen ɛmyaal ɛ mɛ ɔ, nyɛ ɛ́ pɛɛ ɛmyaal mɛkpa mam ɔ, nyɛ eebela lo mɛsɔ mɛ nyɛ aapɛ́ɛaa dum nɛ tak ɛ. Ye ɛ́ mɛlyo mɛ mɛ di lyo ɛ, paakwyesal nyɛ ndjɛ sɔs e dwoo Zɛɛb aapɛ́ɛ bot ɛ bɔs ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","É di'enek, mɛ aanàkwaalii kɔ ɛkwosak ɛ lam. Etɛɛ náá, Saag'am mot nadhis mɛ ɔ, nabɛɛ, nyɛ eedjɛ mɛ ɛlee dum nɛ mɛkpa mɛ mɛ di egoka nɛ lɛɛ ɛ, nɛ etɛp mɛ goka nɛ ɛlyo ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Deenek ɛ mɛ di nɛ gu náá, mɛtiŋ mɛ nyɛ di djɛ bot ɛ, djɛ ɛ tsik na kɔm-kɔm. Etɛp tak ɛ di náá, etɛp ee mɛ di lɛɛ bin ɛ, mɛ dyeebalɛɛ dáa Saag'am nalwom mɛ lɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ye nabɛɛ e ges ɛbyoŋ ɛ Pak. Yezu nadi gu náá, ɛwala ɛ lɛ nabɛɛ, eezekum. Ɛwala nyɛ aadus kɔ bɔs, tɔ́ pɛ daa Sɛɛg tɔ gwoo ɛ. Nyɛ naadyeebakwyɛl bɔɔ bɛsɔ bɛ di kɔ bɔs ɛ. Nyɛ naakwyɛl bɛ kɛkum mɛsik. ");
INSERT INTO bkw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yezu bɛ nɛ bɛdjekel bɛ nadi dɛ edee bikoko. Ye nabɛɛ, Dim mot mɛkɔŋ eezewa tɔ lyem ɛ Yudas Iskaliɔt, mɔɔ Simɔŋ, gwyes ɛkɛ seeb ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Tin, Yezu nadi gu náá, Zɛɛb ɛ nadhis nyɛ. Nyɛ nawaabaazosik ɛ pɛ daa lɛ. Yezu nɛ gu deenek ɛnyɔɛpe. Nyɛ nɛ baagu náá, Sɛɛg naadjɛ nyɛ eghɛŋ kɔ esa e bɔs djas. ");
INSERT INTO bkw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bɔɔ é dɛ kɔ mesa, wɔ gwaa Yezu zɛwyɛl «ngbat». Nyɛ eezɛdis kuwa é nyel. Bhii tak nyɛ eezɛnɔɔ pes kaad pil e kuu dáa dhut. ");
INSERT INTO bkw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bhii tak nyɛ eezɛso mɛdii tɔ kongo (silba). Tin, nyɛ eezɛni, e ɛgwyii ɛ bɛdjekel bɛ mɛko. Nyɛ eezɛnɔɔ pes kaad nyɛ napil e kuu dáa dhut ɛ, nyɛ moo tin é suŋal bɛ mɛko nɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Dáa nyɛ nakum pɛ dáa Simɔŋ di baadjóoaa Pyɛɛd ɛ, wɔ gwaa nyɛ zɛke nɛ nɛ náá: «Ghɛŋ, wɔ kwyɛl ɛ, wɔ neegwyii mɛ mɛko?» ");
INSERT INTO bkw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yezu eezɛbɔɔza nɛ nɛ náá: «Sa mɛ di sa nenak'aak, wɔ aanàkwaalee nyɔ ɛmɛt ɛsuk ɛ tak. Wɔ aaboomɛt ɛsuk ɛ tak ɛ ɛbhis.» ");
INSERT INTO bkw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tin, Pyɛɛd eezɛbɔɔza náá: «Ààbɛ, wɔy tok nɛ ghwyil ɛgwyii mɛ mɛko!» É di'enek, Yezu eezɛbɔɔza nɛ nɛ náá: «Mɛ di ààgwyii wɔ mɛko ɔ, wɔ tok mot'am.» ");
INSERT INTO bkw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tin, Simɔŋ Pyɛɛd eezɛke nɛ nɛ náá: «Yɛ bɛ deenek ɔ, Ghɛŋ, nàgwyii mɛ mɛko nɛ mɛko. Zo ka gwyii mɛ dɔɔ nɛ mɛmbɔ nɛ lo!» ");
INSERT INTO bkw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yezu eebaazɛbɔɔza náá: «Mot di náá, nyɛ eezegwyia ɔ, nyɛ tokapɛ nɛ gwyes ɛgwyia, bhis nyɛ gwyiiaa mɛko ɛ. Biyɔ, mɛnyel min djas moo ɛ́ dɛɛ. Tin, ye ɛ́ nɛ mot ngɔt tɔ len di ààbɛ dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yezu nadi gu, mot waakɛka nyɛ ɔ. Étɛp tak ɛ nyɛ nake náá: «Etok biyɔ djas di dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bhis nyɛ nazesilal ɛ gwyii ɛ bɛ mɛko ɛ, Yezu eezɛnɔɔ kuwa yɛ sɔm e nyel. Nyɛ eebula zɛdisi e ngwoob mesa. Tin, nyɛ eezɛbaake nɛ nɔɔ náá: «Bi eemɛt ɛsuk ɛ sa mɛ sa bin ɛ? ");
INSERT INTO bkw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bi dyeebadjóo mɛ “Lyoel” nɛ “Ghɛŋ”. Bi ɛ nɛ gham etɛɛ náá, mɛ ɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yɛ bɛ náá, mam Ghɛŋ, Lyoel'en, mɛ eegwyii bin mɛko ɔ, ye goka ɛ́ náá, bi gwyii mɛko mɛ bɛsɔ bin pak'en. ");
INSERT INTO bkw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mɛ lyaal bin tin ɛ, dáa bi di egoka nɛ ɛbe bɔn nyɛɛg bin pak'en ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mɛ eelɛɛ bin étɛp e tsɛɛtsɛ náá, etok nɛ mot-mɛsa ngɔt di dhaa kukuma yɛ. Zɛbaanɔɔ náá, etok nɛ ngoola-ngoola di dhaa mot nalwom nyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tin nenak yak, bi eezegu deenek, bi aadi tɔ mɛmyaala ɛ bi ɛ di sa dáa mɛ lyaal bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Mɛ ààlii deenek nɛ biyɔ djas. Mɛ lii ɛ nɛ bot ɛ mɛ zesɛ́ɛ ɔ. Tin, ye goka ɛ́ náá, mɛkpa mɛ Zɛɛb di lɛɛ náá: “Mot bis nɛ nɛ nadi pyaala epes e tsim ɔ, nyɛ eeliig mɛ ɛkoŋ ɛ wak” neebela ɛsuk. ");
INSERT INTO bkw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ɛsok nɛ etɛp bak nɛ sael, mɛ eezepoonyɛl ɛlɛɛ bin. Etɛɛ náá, esok esesɛɛ tak aazɛsael ɛ, bi neemyaal náá: “Mɛ ɛ mɛsia.” ");
INSERT INTO bkw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mɛ lɛɛ bin étɛp e tsɛɛtsɛ náá, mot aamyaal mot mam dhis ɔ, myaal ɛ dɔɔ nɛ nam. Tin, mot aamyaal mɛ ɔ, myaal ɛ mot dhis mɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bhis Yezu nazelii deenek ɛ, ye nabɛɛ, ghoŋ naazemɛt nyɛ ɛbuɛpe. Nyɛ ɛ́ booke náá: «Mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá, mot ngɔt pak'en ɛ waakɛka mɛ gha.» ");
INSERT INTO bkw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bɛdjekel moo tin «ziibilii» é gwyakel pak'ɔɔ, ààgu mot nyɛ nadi eke deenek kɔ ɛsu ɛ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ngɔt tɔ bɛdjekel, mot Yezu nadi é kwyɛl ɛbuɛpe ɔ, nadisi ɛ, e ngwoob ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simɔŋ Pyɛɛd eezɛtut nyɛ dis, étɛp nyɛ needji Yezu mot nyɛ nadi é lii deenek kɔ ɛsu ɛ lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tin, djekel yenɔk é zɛsil lo, kɛl kɔ bet ɛ Yezu. Bhii tak nyɛ eezɛdji nyɛ náá: «Ghɛŋ, mot tak ɛ́ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","É di'enek, Yezu eezɛbɔɔza nɛ nɛ náá: «Mɛ ɛpeduu pes mapa tɔ saan. Mot mɛ aadjɛ nyɛ pes mapa tak ɔ, mot tak ɛ nɔk.» Bhii tak Yezu eezɛnɔɔ pes mapa, duu tɔ saan, nyɛ eezɛnɔɔ yɛ, djɛ Yudas Iskaliɔt, mɔɔ Simɔŋ. ");
INSERT INTO bkw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dáa Yudas nanɔɔ pes mapa tak, dɛ ɛ, e di tak wat, Satan eezɛni tɔ lɛ. Yezu eezɛke nɛ nɛ náá: «Sa wɔ di kwyɛl ɛsa ɛ, lela ɛsa yɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tɔ sama bot nadi kɔ mɛsa ɛ, mot ngɔt pak'ɔɔ nabɛɛ ààmɛt ɛsuk ɛ etɛp é nyɛ nadi lii deenek ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dáa nabela náá, Yudas ɛ nadi é mɛt kola epata ɛ. Bɛsɔ nagu ɛ náá, Yezu naalwom nyɛ, nyɛ kɛɛbɔm dhiiti esa ee bɛ nadi nɛ gwyes tak etɛp ɛbyoŋ ɛ. Nɛghu bɛ kɛɛdjɛ dhiiti esonoŋ nɛ bɛdjel ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tin, Yudas eezɛnɔɔ pes mapa yenek zɛwyɛl «ngbat», nyɛ eezɛwyis tɔ́. Ye nabɛɛ ɛgwyitok eezegwyiidela. ");
INSERT INTO bkw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bhis Yudas nakawyis ɛ, Yezu eezɛke náá: «É di mena kadi wak nenak'aak, dék ɛ Sɛɛŋɛlɛ Mɔn Mot eezenyen. Tin, dɔɔ nɛ dék ɛ Zɛɛb eenyen tɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yɛ bɛ náá, Sɛɛŋɛlɛ Mɔn Mot eedual Zɛɛb ɔ, ye ka lik ɛ batsa, Zɛɛb nyɛ ɛmet ɛ waalyaal e mis mɛ bot duu Sɛɛŋɛlɛ Mɔn Mot di nɛ ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bɔɔ bam, mɛ ka lik nɛ nen mos ɛ ba bɔɔ mɛlu batsa. Bi ɛ waasaa mɛ. Dáa mɛ nalɛɛ nɛ eYuda ɛ, ye ɛ́ mɛ baadi elɛɛ nɛ nen'aak. Bi tok nɛ ghwyil ɛzyɛ pɛ pak mɛ di tɔ́ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","«Ye ɛ́ mɛ di djɛ bin ɛtiŋ ɛ na bes náá: Kwyɛlaka pak'en. Ye goka bi kwyɛla pak'en dáa mɛ nakwyɛl bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bi ɛ kwyɛla pak'en ɔ. Deenek ɛ, bot aagu náá, bi ɛ bɛdjekel bam.» ");
INSERT INTO bkw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simɔŋ Pyɛɛd zokazɛdji Yezu náá: «Ghɛŋ, wɔ tɔ́ paa?» Yezu eezɛbɔɔza nɛ nɛ náá: «Nenak yak, wɔ tok nɛ ghwyil ɛdu mɛ pɛ pak mɛ di tɔ́ ɛ. Deenek, wɔ waaboodu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tin, Pyɛɛd eezɛke nɛ nɛ náá: «Ghɛŋ, étɛp yé mɛ di ààgoka nɛ ɛdu ɛ wɔ nenak? É di mɛ di'ak, mɛ eezemyam ɛdjɛ tsik'am é di yɔ!» ");
INSERT INTO bkw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yezu eezɛdji nɛ náá: «Wɔ eezemyam ɛdjɛ tsikɔ kɔ ɛsu ɛ lam e? Tin, beta mɛ lɛɛ wɔ tsɛɛtsɛ náá, ɛsok nɛ bɛkuu nɛ kɔk, yɛ aaka bela, wɔ eezeswonal mɛ tyee esok elɛl.» ");
INSERT INTO bkw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yezu eezɛke nɛ nɔɔ náá: «Sa mot ààbem ba. Dumka koŋ nɛ Zɛɛb, da bi ɛ baadum koŋ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mɛdhɛŋ nɛ bu tɔ ndjaa Saag'am. Ye ɛ́ pe diɛ, ààbɛ tak ɔ, pe mɛ eelɛɛ bin. Étɛp tak ɛ mɛ di tɔ́ étɛp ɛkɛkoobal bin di ee bi aakɛdi ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bhis ɛtɔ́ ɛ lam kɛkoobal bin e di ɛ, mɛ aakazyɛ zɛsaa bin étɛp bi needi e ngwoobam. Bi needi e di mam aadi ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bi nɛ gu ze di dul bot pɛ pak mɛ di ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tin, Toma eezɛke nɛ nɛ náá: «Ghɛŋ, bis ààgu pɛ pak wɔ di tɔ́ ɛ. Bis aagu ze dáa?» ");
INSERT INTO bkw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yezu eezɛbɔɔza nɛ nɛ náá: «Ye ɛ́ mam ɛ di ze. Mɛ ɛ etsɛɛtsɛ, nɛ tsik. Mot tok nɛ ghwyil ɛtɔ́ pɛ dáa Saag'am, nyɛ di ààdhaa pɛ daa lam ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dáa ye di náá, bi nɛ gu mɛ ɛ, bi nɛ baagu pe Saag'am. Deenek, di mena kadi nenak'aak, bi nɛ gu nyɛ etɛɛ náá, bi eebee nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tin, Filip eezɛke nɛ nɛ náá: «Ghɛŋ! Lyaala bis Soog. Tin, elyem ɛ waasila bis.» ");
INSERT INTO bkw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","É di'enek, Yezu eezɛbɔɔza náá: «Mena eezebɔya mɛlu ɛbuɛpe e di wat, wɔ dinaa ààpaagu mɛ, Filip? Mot zebee mɛ ɔ, nyɛ eezebee Saag'am. Étɛp ye wɔ di baake náá: “Lyaala bis Soog”? ");
INSERT INTO bkw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wɔ ààmyaal náá, mɛ ɛ́ pɛ tɔ Saag'am, dáa Saag'am baadi tɔ lam ɛ? Etɛp ee mɛ di elɛɛ nɛ biyɔ djas'aak, yɛ ààdus pɛ daa lam. Ye ɛ́ Saag'am, mot di tɔ lam ɔ, di sa náá, esesɛɛ binek djas sael. ");
INSERT INTO bkw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Myaalka mɛ esok mɛ di ke náá, mɛ ɛ́ tɔ Saag'am, Saag'am ɛ́ pɛ tɔ lam pe. Yɛ bɛ náá, bi ààmyaal ɔɔ, zomyaalka, etɛɛ náá, bi ɛpebee endem e mɛbwala mam. ");
INSERT INTO bkw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«Mɛ lɛɛ bin ɛ, ye ɛ́ tsɛɛtsɛ náá, mot ɛ dum koŋɛ nɛ nam ɔ, nyɛ waasa endem e mɛbwala. Nyɛ waasa eboo endem e mɛbwala etɛɛ náá, mɛ ɛpetɔ́ pɛ daa Saag'am. ");
INSERT INTO bkw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tin, mɛ waasa esa ee djas bi aawaab nɛ din ɛ lam ɛ. Étɛp náá, Mɔn neelyaal bot duu ɛ Sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Bi ɛ waab sonok nɛ din ɛ lam ɔ, mɛ waasa sa tak.» ");
INSERT INTO bkw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Yɛ bɛ náá, bi nɛ kwyɛl mɛ ɔ, kɛka dáa mɛtiŋ mam di lyaal ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mɛ waawaab nɛ Saag'am nyɛ dhis bin dhiiti mot étɛp nyɛ neezɛkɛm bin. Etɛɛ náá, nyɛ needi sama wat nɛ nen kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mot tak ɛ Sisim etsɛɛtsɛ. Tinaak, bot ɛ bɔs'ak aanàkwaabela Sisim tak. Etɛɛ náá, bɛ tok nɛ ghwyil ɛbee nyɛ, bɛ tok nɛ ghwyil ɛgwyak nyɛ. Yɛ kabɛ biyɔ ɔ, bi ɛ́ waagwyak nyɛ etɛɛ náá, nyɛ ɛ́ nɛ nen sama. Nyɛ ɛ́ tɔ len. ");
INSERT INTO bkw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Mam aanàkwaalik bin biyɔ bɛ ɛmet tyee bɔɔ nyel. Mɛ waabula pɛ daa len. ");
INSERT INTO bkw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ye ka lik ɛ batsa etɛɛ náá, bot ɛ bɔs'ak needi ààbaabee mɛ. Yɛ kabɛ biyɔ ɔ, bi ɛ waabebee mɛ. Etɛɛ náá, mɛ ɛ nɛ tsik, dɔɔ nɛ biyɔ pe, bi ɛ waadi nɛ tsik. ");
INSERT INTO bkw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dwoo tak bi ɛ waasiiza ɛnyɔɛpe náá, bis nɛ Saag'am ɛ mot ngɔt. Dáa biyɔ baadi mot ngɔt nɛ nam ɛ, mam ɛ mot ngɔt nɛ nen. ");
INSERT INTO bkw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Mot di emɛt mɛtiŋ mam, da nyɛ ɛ́ kɛ dáa ɛkwosak ɛ tak di elɛɛ ɛ, mot di ekwyɛl mam ɛ nɔk. Saag'am aakwyɛl nyɛ. Mam pe, mɛ waakwyɛl nyɛ. Mɛ waalyaal nyɛ nyel'am.» ");
INSERT INTO bkw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudas, ààkabɛ Yudas Iskaliɔt, zokazɛke nɛ nɛ náá: «Ghɛŋ, étɛp ye wɔ aalyaal bisɔ nyel'ɔ, da wɔ ɛ kaadi, ààlyaal bot ɛ bɔs di ààmyaal wɔ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tin, Yezu eezɛbɔɔza nɛ nɛ náá: «Mot di kwyɛl mɛ ɔ, nyɛ waakɛ dáa mɛ di lɛɛ ɛ. Tin, Saag'am ɛ waakwyɛl nyɛ. Bis nɛ Saag'am ɛ waazyɛ pɛ daa lɛ, bis aadi nɛ nɛ ɛ sama. ");
INSERT INTO bkw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mot di ààkwyɛl mɛ ɔ, nyɛ ààkɛ dáa mɛkpa mam di lɛɛ ɛ. Bela náá, etɛp ee mɛ di lii nɛ nen ɛ ààdus pɛ daa lam. Ye dus ɛ pɛ dáa Saag'am, mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Mɛ bɛ ɛ́, mɛ eelɛɛ bin etɛp binek, esok mena dika e di wat ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mot-Mɛghɛm aazyɛ. Ye ɛ́ nyɛ ɛ́ di Sisim na Dɛɛ ee Saag'am aadhis nɛ din ɛ lam ɛ, étɛp nyɛ neelyaal bin esonok djas. Nyɛ waasa náá, bi siiza etɛp djas mɛ nadi lelɛɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Mɛ lik bin ɛ, egwyem. Ye ɛ́ egwyem bam ɛ mɛ di edjɛ bin. Mam ààpadjɛ bin yɛ dáa bot ɛ bɔs'ak di djɛ ɛ. Sa mot ààbem ba. Sa mot ààdi nɛ bwoo. ");
INSERT INTO bkw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bi eegwak dáa mɛ ke náá: “Mɛ ɛpetɔ́, mɛ waabula pak'en”. Bi ɛ kwyɛl mɛ ɔ, bi ɛ waadi tɔ mɛmyaala étɛp mɛ ke náá, mɛ ɛpetɔ́ pɛ daa Saag'am ɛ. Etɛɛ náá, Saag'am eedhaa mɛ boo dhaŋa. ");
INSERT INTO bkw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mɛ eezelɛɛ bin ye ɛ́ nenak, ɛsok nɛ esesɛɛ bak djas nɛ sael. E sok esonok binek djas aazyɛ, bi ɛ waadum koŋ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mɛ aanàkwaabaalii ɛbuɛpe nɛ nen etɛɛ náá, mbee mɛkoozi mɛ bɔs'ak moo aazyɛ. Nyɛ tok nɛ ghwyil ɛsa mɛ dhiiti sonok. ");
INSERT INTO bkw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tin, ye goka ɛ́ náá, bot ɛ bɔs'ak gu náá, mɛ nɛ kwyɛl Saag'am. Deenek, mɛ sa mɛsa mam ɛ, dáa Saag'am nalwom mɛ náá, mɛ sa ɛ. Wyɛlka. Djhooduska wak.» ");
INSERT INTO bkw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Ye ɛ́ mam ɛ di tɛtɛ le vin. Saag'am ɛ nakuma pyeeb tak. ");
INSERT INTO bkw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nyɛ waatsaal elɛɛ djas di dus e kuuam di ààdjɛ bhum ɛ. Tinaak, elɛɛ di djɛ bhum ɛ, nyɛ ka koobal ye ɛ́ koobela, etɛɛ náá, ye needjɛ bɛtɛ nɛ bhum. ");
INSERT INTO bkw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Bi moo mos ɛ bot ɛ na dɛɛ dáa le zekoobela ɛ dum nɛ mɛlyo mɛ mɛ djɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Dika mot ngɔt nɛ nam, dáa mɛ di mot ngɔt bis nɛ Saag'am ɛ. Lɛɛ le tok nɛ ghwyil ɛbya bhum, ye ɛ́ di àànaata e kuu le ɔ. Tyee wat nɛ nen, bi tok nɛ ghwyil ɛbya bhum, bi ɛ di, ààdi nɛ nam sama wat ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Ye ɛ́ mam ɛ di le vin, biyɔ ɛ elɛɛ. Mot ɛ di tɔ lam ɔ, mot ɛdi nɛ nam sama wat ɔ. Nyɛ waabya bɛtɛ nɛ bhum, etɛɛ náá, ye tok nɛ sa bi aasa, mam ààbɛ tak. ");
INSERT INTO bkw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mot ɛ di ààdi tɔ lam ɔ, nyɛ waamwasaa pɛ kel dáa esɔsela elɛɛ e le. Dáa yɛ aadɛ náá, bɛ eezesɔs ɛ, nyɛ waatekaa da sɛɛga nɛ bɛdhiiti esɔsela elɛɛ e le da bɛ kɛdikaa tɔ du. ");
INSERT INTO bkw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bi ɛ be di tɔ lam ɔ, da mɛkpa mam ɛ di tɔ len ɔ. Waabka esesɛɛ djas bi aadi nɛ gwyes tak ɛ, deenek bi ɛ waabela yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eghɛŋ bi aadjɛ bɛtɛ nɛ bhum ɛ, yɛ waalyaal nɛ bot náá, bi ɛ bɛdjekel bam. Deenek ɛ, bi ɛ waadjɛ Saag'am boo duu. ");
INSERT INTO bkw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mɛ nɛ kwyɛl bin dáa Saag'am di kwyɛl mɛ ɛ. Dika tɔ kwyɛlam. ");
INSERT INTO bkw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bi ɛ duwal mɛtiŋ mam ɔ. Bi ɛ waadi tɔ kwyɛlam, dáa mam naduwal mɛtiŋ mɛ Saag'am ɛ, mɛ ɛ́ boodi tɔ kwyɛlɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«Mɛ lɛɛ bin etɛp binek ɛ, etɛɛ náá, mɛmyaala mam needi mɛmyaala men. Da mɛmyaala men ɛ di yii tsɛɛtsɛ nɛ lyem wat. ");
INSERT INTO bkw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Beeka yam ɛtiŋ e: Gheekwyi-kwyɛlaka pak'en. Kwyɛlaka pak'en dáa mɛ ɛ́ boozyɛ nɛ ɛkwyɛl bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mɛkwyɛla mɛ na bɔk-bɔk mot di egoka nɛ ɛlyaal ɛ, ye ɛ́ ɛdjɛ nyel'ɛ met étɛp bɛsɔ. ");
INSERT INTO bkw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bi ɛ di sa etɛp ee mɛ di kwyɛl náá bi sa ɛ, deenek ɛ bi ɛ waadi bɛsɔ bam. ");
INSERT INTO bkw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tin, mɛ aanàkwaabaadjóo bin bot ɛ mɛsa, etɛɛ náá, mot-mɛsa ààgu sa kukuma yɛ di sa ɛ. Mɛ djóo bin ɛ bɛsɔ bam, etɛɛ náá, mɛ eezelyo bin esa ee Saag'am nalyo mɛ ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ye tok biyɔ natɔ́ mɛ. Ye ɛ́ mam ɛ natɔ́ bin. Mɛ eedjɛ bin lwomel bi tɔ́, bi kɛɛdjɛ bhum. Bi kɛɛdjɛ bhum aadi bɛtɛ nɛ mɛlu ɛ. Deenek ɛ Saag'am ɛ waadjɛ bin esonok djas bi aawaab pɛ daa lɛ nɛ din ɛ lam ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mɛ djɛ bin mɛtiŋ menek ɛ, etɛɛ náá, bi gheekwyi-kwyɛla pak'en.» ");
INSERT INTO bkw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Yɛ bɛ náá, bot ɛ bɔs'ak ɛpebhina bin ɔɔ, guka náá, bɛ naaloozebhina mɛ ɛsok nɛ biyɔ. ");
INSERT INTO bkw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Bi ɛpedi bot ɛ bɔs'ak ɔ, pe bot ɛ bɔs'ak ɛpekwyɛl bin, dáa bot bɔɔ. Tin, ye nabɛɛ, mam eesɛ́ɛ bin, mɛ eebɛk bin nɛ bot ɛ bɔs'ak. Deenek bi tokapɛ bot ɛ bɔs'ak. Etɛp tak ɛ, bot ɛ bɔs'ak di bhina bin. ");
INSERT INTO bkw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gheetaalaka sa mɛ nalɛɛ bin ɛ: “Mot-mɛsa tok nɛ ghwyil ɛdhaa kukuma yɛ.” Etɛɛ náá, yɛ bɛ náá, bot naatiigal mɛ ɔɔ, guka náá, bɛ waatiigal bin pe. Yɛ bɛ náá, bɛ naawa elyem tɔ mɛlyo mam ɔ, bɛ waabaawa elyem tɔ mɛlyo min pe. ");
INSERT INTO bkw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tinaak, bɛ aasa bin etɛp binek djas ɛ étɛp'am, etɛɛ náá, bɛ aagu mot nadhis mɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Mɛ ɛpedi ààzyɛ, étɛp ɛzɛlii nɛ nɔɔ etɛp bak ɔ, pe bɛ tok kwyɛ ndjɛ sɔs. Tin, dáa bɛ di náá, bɛ naazegwak mɛ ɛ, e tokapɛ nɛ mot aapel mesyem mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","«Mot di bhina mɛ ɔ, nyɛ eebaabhina dɔɔ nɛ Saag'am. ");
INSERT INTO bkw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ye ɛ́ pe diɛ náá, mɛ nabɛɛ ààsa endem e mɛbwala di náá, dhiiti mot dinaa ààpaakosa sok é mis mɔɔ ɛ, e di'enek, pe bɛ tok nɛ mesyem. Tin, e dwoo pan mos'ak, bɛ eezebee endem e mɛbwala mɛ mɛ nasa ɛ, bhii tak bɛ ɛ́ kadi ebhina bis nɛ Saag'am. ");
INSERT INTO bkw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tin, etɛp binek sael ɛ etɛɛ náá, esa ee di kwyala tɔ mɛkana mɛ etsi ɛ, neebela ɛsuk ɛ tak. Ye ɛ́ kwyala náá: “Bɛ eebhina mɛ, ààbɛ nɛ lo tɛp.” ");
INSERT INTO bkw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Mot-mɛghɛm ɛ ɛpezyɛ. Ye ɛ́ Sisim etsɛɛtsɛ Saag'am aadhis ɛ. Sisim tak aadus ɛ pɛ daa Saag'am, mɛ waadis bin ye ɛ́. Nyɛ waalyaal bin etsɛɛtsɛ dum nɛ mbi mot mɛ di ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tin, dɔɔ nɛ biyɔ pe, bi ɛ waalɛɛ bot esa ee bi di gu kɔ ɛsu ɛ lam ɛ. Etɛɛ náá, mena ɛ́ boolɔɔd nɛ ɛgyee sama wat, kana mɛkɛn mɛ mɛsa mam.» ");
INSERT INTO bkw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mɛ lɛɛ bin etɛp bak djas ɛ, etɛɛ náá, bi needi ààkat ɛdum ɛ koŋen nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bi ɛ waasɔaa tɔ mendjaa mɛ mendjaala mɛ eYuda. Deenek, ɛwala waazyɛ. Ɛwala di náá bot aadi gó bin ɛ, bɛ waake náá, yɛ deenek ɛ bɛ di sa mɛsa mɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bɛ aasa deenek ɛ, etɛɛ náá, bɛ nabɛɛ ààgu Saag'am, ààgu dɔɔ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tin, mɛ lɛɛ bin etɛp binek ɛ, etɛɛ náá, esok ɛwala ɛ tak aakum ɛ, bi neegheesisiiza náá, ye nabɛɛ mɛ eezeloolɛɛ bin.» «Mɛ nadi ààlee lɛɛ bin ye ɛsok ɛ, etɛɛ náá, mena nadika ɛ mena dinaa e di wat. ");
INSERT INTO bkw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nenak, mɛ moo tɔ́ pɛ daa mot nadhis mɛ ɔ. Tin, ye tok nɛ mot pak'en aabaadji mɛ náá: “Wɔ tɔ́ paa”? ");
INSERT INTO bkw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Deenek, elyem bin eelwood nɛ ghoŋ, kɔ ɛsu ɛ etɛp mɛ di lɛɛ bin'aak. ");
INSERT INTO bkw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ghuna mɛ lɛɛ bin ɛ tsɛɛtsɛ náá, kɔ ɛsu ɛ len, ɛnyɔ ɛ náá, mɛ tɔ́. Etɛɛ náá, mɛ ɛ di ààtɔ́ ɔ, Mot-Mɛghɛmen di egoka nɛ ɛzyɛ ɔ, nyɛ aanàkwaabaazyɛ pɛ daa len. Tin, mɛ tɔ́ ɔ, mɛ ɛpedhis bin nwyak. ");
INSERT INTO bkw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tin, esok nyɛ aazyɛ ɛ́, nyɛ waalyaal bot ɛ di kɔ bɔs'ak ɔ, ɛdjak ɛ lɔɔ kɔ ɛsu ɛ mesyem mɔɔ. Nyɛ waalyaal bot ɛ di kɔ bɔs'ak ɔ, ɛdjak ɛ lɔɔ kɔ ɛsu ɛ epiki e Zɛɛb, zɛnɔɔ dáa Zɛɛb aapɛ́ɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mesyem mɛ bot ɛ bɔs ɛ náá, bot ɛpebyen ɛdum koŋ nɛ nam. ");
INSERT INTO bkw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yɛ bɛ dum nɛ epiki ɛ Zɛɛb ɔ, bot ɛ tɔ ɛdjak, etɛɛ náá, mɛ ɛpetɔ́ pɛ daa Saag'am. Tin, bi aanàkabaabee mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yɛ kabɛ dum nɛ daa Zɛɛb aapɛ́ɛ ɔ, bot ɛ tɔ ɛdjak, etɛɛ náá, Zɛɛb eezepɛ́ɛ mɛkoozi mɛ bot ɛ bɔs'ak. ");
INSERT INTO bkw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Mɛ dinaa nɛ bɛtɛ nɛ etɛp ee mɛ aalɛɛ bin, saabɛgɔs ɛ́ náá, bi tok nɛ ghwyil ɛtiibal yɛ nenak. ");
INSERT INTO bkw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","E sok Sisim etsɛɛtsɛ aazyɛ ɛ́, nyɛ waadjɛɛd bin tɔ etsɛɛtsɛ djas. Nyɛ aanàkwaalii nɛ nen kɔ ɛsu ɛ lɛ ɛmet. Nyɛ aalɛɛ bin ɛ etɛp ee nyɛ nagwak ɛ. Nyɛ waalɛɛ bin etɛp ee di zyɛ pɛ sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nyɛ waaduwal mɛ etɛɛ náá, nyɛ waabela etɛp ee mɛ di nɛ ye ɛ́ djas. Bhii tak, nyɛ ka zyɛ, zɛbaŋa bin ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Etɛp e Saag'am djas ɛ etɛp bam. Kɔ ɛsu ɛ tak ɛ, mɛ di ke náá, Sisim na tsɛɛtsɛ waanɔɔ mɛkpa mam da nyɛ ɛ́ eezɛgoola bin ye ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ye ka lik ɛ ba ɛwala, bi aanàbaabee mɛ. Tin, ba ɛwala batsa bhii tak, bi ɛ waabaabee mɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bɛdhiiti bot tɔ sama bɛdjekel, bɛ zokazɛdjinel pak'ɔɔ náá: «Nyɛ dyeebakwyɛl ɛlɛɛ yé, esok nyɛ di ke náá: “Ye ka lik ɛ ba ɛwala, bi aanàbaabee mɛ. Bhis ba ɛwala, bi ɛ waabaabee mɛ”. Dɔɔ nɛ esok nyɛ di ke náá: “Mɛ ɛpetɔ́ pɛ daa Saag'am”? ");
INSERT INTO bkw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ba ɛwala batsa” nyɛ di lɛɛ wak ɛ, ye kwyɛl ɛlyaal yé? Mena ààmɛtka ɛsuk ɛ sa nyɛ di lɛɛ mena ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tinaak, Yezu eezɛgu náá, bɛ naadi kwyɛl ɛdji nyɛ bɛdhiiti etɛp. Wɔ gwak nyɛ zɛke nɛ nɔɔ náá: «Mɛ eelɛɛ bin náá: “Ye ka lik ɛ ba bim ɛwala, bi aanàbaabee mɛ.” Ye ɛ́ dum nɛ tak ɛ bi di djinel pak'en e? ");
INSERT INTO bkw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mɛ lɛɛ bin ɛ etɛp e tsɛɛtsɛ náá, bi ɛ waadje mɛgwyɛ, bi waadi tɔ́ mezuk. É di'enek, bot ɛ bɔs'ak aadi ɛ́, tɔ mɛmyaala ɛbuɛpe. Bi aadi ɛ́, tɔ ghoŋ. Tin, ghoŋen ɛ waaliiza mɛmyaala. ");
INSERT INTO bkw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","«Esok moma di kɛbya ɛ, nyɛ bya tɔ mezuk nɛ mɛkpa. Etɛɛ náá, ɛwala ɛ mezuk mɛ dyeebadi ɛ́, eezedjala. Tin, ye ɛ́ kabɛ náá, mɔn eebyel ɔ, nyɛ eedjisa mezuk menek. Nyɛ moo tɔ mɛmyaala etɛɛ náá, dhiiti mot na bes eezyɛ kɔ bɔs'ak. ");
INSERT INTO bkw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tyee wat nɛ nen, é di mena mooka nenak'aak, bi ɛ́ tɔ ghoŋ nɛ mezuk. Tin, mɛ waabaaboma nɛ nen. Tin, elyem bin aadi ɛ́, tɔ mɛmyaala. É di'enek, e tokapɛ nɛ mot aadis mɛmyaala menek tɔ elyem bin. ");
INSERT INTO bkw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Esok yɛ aadɛ náá, ɛlu ɛ tak eekum ɛ, bi aanàkwaabaadji mam kiya dum nɛ dhiiti tɛp. Mɛ lɛɛ bin etɛp e tsɛɛtsɛ náá: Saag'am ɛ waadjɛ bin esesɛɛ djas bi aawaab nɛ din ɛ lam ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kɛ yaka nɛ dwoo pan mos'ak, bi dinaa ààpaawaab sonok nɛ din ɛ lam. Tin, waabka, bi ɛ waadjɛaa. Deenek mɛmyaala min ɛ waadi tɛtɛ mɛmyaala nɛ lyem wat.» ");
INSERT INTO bkw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mɛ lɛɛ bin etɛp bak djas ɛ, tɔ ekana. Ɛwala mɛ aadi ààka baalii nɛ nen tɔ ekana ɛpezyɛ. Tin e di mɛ aazɛlɛɛ bin etɛp mɛpyɛmɛ dum nɛ Saag'am. ");
INSERT INTO bkw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dwoo tak, bi ɛ waab esonok nɛ Saag'am nɛ din ɛ lam. Tin, mɛ ààpalɛɛ bin náá, mɛ waadjaala nɛ Saag'am kɔ ɛsu ɛ len. ");
INSERT INTO bkw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mɛ aanàdjaala nɛ Saag'am étɛp'en, etɛɛ náá, nyɛ ɛmet nɛ kwyɛl bin. Nyɛ kwyɛl bin ɛ, etɛɛ náá, bi nɛ kwyɛl mɛ. Ye ɛ́, etɛɛ náá, bi nɛ myaal náá, mɛ nadus ɛ pɛ daa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mɛ nadus ɛ pɛ daa Saag'am, bhii tak mɛ eezɛzyɛ kɔ bɔs'ak. Nenak, mɛ moo zɛdus kɔ bɔs'ak, étɛp ɛsik pɛ daa Saag'am.» ");
INSERT INTO bkw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tin, wɔ gwaa bɛdjekel bɛ zɛke nɛ nɛ náá: «Beea! Nenak wɔ moo lii mɛpyɛmɛ, ààbɛ tɔ ekana. ");
INSERT INTO bkw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Deenek, ye di mena kadi wak nenak'aak, bis nɛ gu náá, wɔ nɛ gu djas. Tin, wɔ tok nɛ gwyes ɛbwood náá, bis dji wɔ dhiiti tɛp. Étɛp tak ɛ bis di myaal náá, wɔ nadus ɛ́ pɛ daa Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tin, Yezu eezɛbɔɔza nɛ nɔɔ náá: «É di'enek, bi moo myaal e? ");
INSERT INTO bkw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Deenek, beeka ɛwala ɛpezyɛ, ɛwala ɛ tak eezezyɛ. Ewala ɛ biyɔ djas aawyɛɛza na “gwyeeŋ” ɛ, mot nɛ mot ɛ waasik pɛ daa lɛ. Bi ɛ waalik mɛ mam mɛ ɛmet ɛ. “Ààbɛ”, e tok tsɛɛtsɛ náá, mɛ ààlik ɛ mam mɛ ɛmet etɛɛ náá, bis nɛ Saag'am ɛ́ aapaadi. ");
INSERT INTO bkw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mɛ lɛɛ bin etɛp bak djas ɛ, étɛp bi needi tɔ egwyem. Tin, bi ɛ di tɔ ɛgwakel nɛ nam pak'en ɔ, bi ɛ waazukaa nɛ ɛtiigaa kɔ bɔs'ak. Tin, saka mɛghaaz, etɛɛ náá, mɛ naazekwak etɛp e bɔs'ak djas.» ");
INSERT INTO bkw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bhis nyɛ zelii deenek ɛ, Yezu eezɛben mis pɛ ɛko, nyɛ eezɛke náá: «Saag'am, ɛwala ɛ tak eezedjala. Djɛa Mɔn'ɔ duu etɛɛ náá, Mɔn'ɔ needjɛ wɔ duu. ");
INSERT INTO bkw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wɔy naadjɛ nyɛ eghɛŋ kɔ bot ɛ bɔs djas étɛp nyɛ needjɛ bot ɛ wɔ nadjɛ nyɛ ɔ, tsik na kɔm-kɔm. ");
INSERT INTO bkw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tsik na kɔm-kɔm ɛ náá, bot gu wɔ, wɔy Zɛɛb etsɛɛtsɛ, Zɛɛb ngɔt, dɔɔ nɛ ɛgu ɛ Yezu Klisto, mot wɔ nadhis ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mɛ eelyaal duma yɔ kɔ bɔs. Mɛ eesa mɛsa mɛ wɔ nalwom mɛ náá, mɛ zɛsa ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nenak, Saag'am, djɛ mɛ sok bhwoob'ɔ duma mɛ nadi nɛ yɛ esok mɛ nadi e ngwoobɔ ɛ, ɛsok nɛ bɔs nɛ kusel. ");
INSERT INTO bkw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Mɛ eelyaal wɔ nɛ bot ɛ wɔ nasɛɛ tɔ sama bot bɔs, da wɔ ɛ́ djɛ mɛ bak ɔ. Bɛ nabɛɛ bot bɔ, wɔ naadjɛ mɛ bak. Tin, ye nabɛɛ bot ɛ tak eegwak mɛkpa mɔ. ");
INSERT INTO bkw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nenak bɛ eezegu náá, esonok djas wɔ nadjɛ mɛ ɛ nadus ɛ pɛ daa lɔ. ");
INSERT INTO bkw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Etɛɛ náá, mɛ eezelɛɛ mɛkpa mɛ wɔ nadjɛ mɛ ɛ. Tin, bɛ naamyaal yɛ, bɛ eegu náá, tsɛɛtsɛ mɛ nadus ɛ pɛ daa lɔ. Tin, bɛ eemyaal náá, wɔy ɛ nadhis mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«Mɛ djaala nɛ nɔ ɛ, kɔ ɛsu ɛ lɔɔ. Mɛ ààdjaala nɛ nɔ kɔ ɛsu ɛ bot ɛ bɔs'ak. Ye ɛ́, étɛp bot ɛ wɔ nadjɛ mɛ ɛ, etɛɛ náá, bɛ ɛ́ bɔ. ");
INSERT INTO bkw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tin, bot djas mɛ di nɛ nɔ ɔɔ, bɛ ɛ́ bɔ. Deenek bot bɔ djas ɛ bot bam. Tin, bɛ naadjɛ mɛ duu. ");
INSERT INTO bkw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«Mɛ tokapɛ kɔ bɔs. Tin, yɛ kabɛ bɔɔ ɔ, bɛ ɛ́ kɔ bɔs. Yɛ bɛ mam ɔ, mɛ ɛpetɔ́ pɛ daa lɔ. Saag'am na Dɛɛ, baala bɛ tɔ ghwyil din ɛ lɔ, ghwyil mɛbwala mɛ wɔ nadjɛ mɛ ɛ, etɛɛ náá, bɛ needi mot ngɔt dáa wɔy nɛ mam di mot ngɔt ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","E sok bis nɛ bɛ nɔɔ nadi, bis dinaa e di wat ɛ, mɛ nadi baal bɛ nɛ ghwyil mɛbwala mɛ din ɛ lɔ. Ghwyil mɛbwala mɛ wɔ nadjɛ mɛ ɛ. Mɛ nabebaal bɛ ɛ́ nɛ yɛ. Ye tok nɛ mot ngɔt diib tɔ lɔɔ, bhis mot nabɛ náá, nyɛ waadiib, etɛɛ náá, ekwyala e mɛkana mɛ Zɛɛb, neebela ɛsuk ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«Deenek, nenak mɛ moo zyɛ pɛ daa lɔ. Mɛ lii etɛp bak ɛ esok mɛ di, mɛ dinaa kɔ bɔs ɛ. Etɛɛ náá, bɔɔ bɛ ɛmet needi nɛ mɛmyaala mam, da bɛ ɛ́ di nɛ mɛmyaala yii tsɛɛtsɛ nɛ lyem wat. ");
INSERT INTO bkw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mɛ naadjɛ bɛ mɛkpa mɔ. Tin, bot ɛ bɔs ɛpebhina bɛ. Etɛɛ náá, bɛdjekel bam tok bot ɛ bɔs'ak, dáa mam di ààdi mot bɔs'ak ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mɛ ààpawaab náá, wɔ dis bɛ kɔ bɔs'ak. Tin, mɛ kwyɛl ɛ, wɔ baal bɛ nɛ Mbee mot. ");
INSERT INTO bkw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bɛ tok bot ɛ bɔs'ak, dáa mam pe di ààdi mot bɔs'ak ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Lyaala bɛ etsɛɛtsɛ, bɛ needi bot bɔ nɛ lyem wat. Mɛkpa mɔ ɛ di etsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mɛ eelwom bɛ pɛ kɔ bɔs, dáa wɔy nalwom mɛ kɔ bɔs ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mɛ eedjɛ wɔ tsik'am djas kɔ ɛsu ɛ lɔɔ. Etɛɛ náá, bɔɔ pe bɛ needi bot bɔ na dɛɛ nɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Mendjaala mam tok étɛp bɔɔ bɛ ɛmet. Mɛ djaala ɛ dɔɔ nɛ étɛp bot ɛ aadi gwak mɛlyo mɔ ɔ, da bɛ ɛ́ dum koŋ nɛ nam ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mendjaala mam ɛ náá, bɔɔ djas di mot ngɔt. Saag'am, bɛ di mot ngɔt nɛ nena dáa wɔ di pɛ tɔ lam, mam tɔ lɔ ɛ. Bɛ di mot ngɔt etɛɛ náá, bot ɛ bɔs neemyaal náá, ye ɛ́ wɔy ɛ nadhis mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","«Mɛ eedjɛ bɛ duu wɔ nadjɛ mɛ ɛ, etɛɛ náá, bɛ needi mot ngɔt dáa mena di mot ngɔt ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mɛ eebe di tɔ lɔɔ, wɔy tɔ lam. Deenek ɛ bɛ aakwak ɛdi ɛnyɔɛpe mot ngɔt. Ye ɛ́ deenek ɛ, bot ɛ bɔs'ak aagu náá, wɔy ɛ nadhis mɛ. Wɔ nɛ kwyɛl bɛ dáa wɔ di kwyɛl mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Saag'am, wɔ naadjɛ mɛ bak. Ɛkwosak ɛ lam ɛ náá, bɛ di bis nɛ nɔɔ e di mɛ aadi ɛ́, etɛp bɛ neebee duu'am. Ye ɛ́ duu wɔ nadjɛ mɛ ɛ. Etɛɛ náá, wɔ nakwyɛl mɛ ɛ ɛsok nɛ bɔs nɛ kusel. ");
INSERT INTO bkw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Saag'am, wɔ mot epiki. Bot ɛ bɔs'ak nabɛɛ ààgu wɔ, ye ɛ́ kabɛ mam ɔ, mam naagu wɔ. Deenek, bɛdjekel bam bak eegu náá, ye ɛ́ wɔy ɛ nadhis mɛ. ");
INSERT INTO bkw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mɛ naazelyaal bɛ din ɛ lɔ. Tin, mɛ waabaalyaal bɛ yɛ, etɛɛ náá, bɛ neekwyɛla pak'ɔɔ dáa wɔ di kwyɛl mɛ ɛ. Deenek, da mam ɛ di tɔ elyem bɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bhis nyɛ nazelii deenek ɛ, Yezu bɛ nɛ bɛdjekel bɛ eezɛtɔ́ pe yii kyiid dii Sedelɔn. E di tak ye naabɛɛ nɛ dhiiti bok. Wɔ gwaa nyɛ zɛni tɔ tak, bɛ nɛ bɛdjekel bɛ. ");
INSERT INTO bkw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Tin, Yudas, mot naka nyɛ ɔ, nadi egu di tak etɛɛ náá, Yezu bɛ nɛ bɛdjekel bɛ nadi ezezyɛ sok zɛsɛɛga é di tak. ");
INSERT INTO bkw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Deenek, Yudas zokazɛtɔ́ pɛ bok tak, bɛ nɛ ɛdhuu ɛ esodja. Tɔ sama esodja tak, ye nabɛ ɛ́ nɛ bɛbaalel ɛ kok Ndjaa-ebuwa, ee eboo bɛghaa-Zɛɛb nalwom ɔ, zɛnɔɔ bot ɛdhuu ɛ eFalizyɛ. Bot binɔk djas nadi ɛ́ nɛ mɛkɔɔ, nɛ etwol nɛ elambi e mɛmbɔ. ");
INSERT INTO bkw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tin, dáa Yezu nadi gu sa nadi kwyɛl ɛsɛɛ dum nɛ nɛ ɛ, wɔ gwaa nyɛ zɛtiila pɛ kyee bɛ nadi ɛ́. Tin, nyɛ eezɛdji bɛ náá: «Bi saa zɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","É di'enek, wɔ gwaa bɛ zɛbɔɔza nɛ nɛ náá: «Yezu mot Nazalɛt.» Tin, Yezu eezɛke nɛ nɔɔ náá: «Ye ɛ́ mam.» Yudas mot naka bɛ nwyak ɔ nadi ɛ́ tin, bɛ nɛ bɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Dáa Yezu nake nɛ nɔɔ náá: «Ye ɛ́ mam» ɛ, wɔ gwaa bɛ bula pɛ bhis, zɛghaaga si. ");
INSERT INTO bkw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wɔ gwaa Yezu baadji bɛ yak sok náá: «Bi saa zɛ e?» Bɛ eebaazɛbɔɔza náá: «Yezu mot Nazalɛt.» ");
INSERT INTO bkw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tin, Yezu eezɛke nɛ nɔɔ náá: «Ye bɛ ɛ́ mɛ eezelɛɛ bin náá, ye ɛ́ mam. Yɛ bɛ náá, bi saŋ ɛ mam ɔ, betka bot ɛsis bɛ tɔ́ yɔbɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nyɛ nake deenek ɛ, etɛɛ náá, etɛp ee nyɛ nalɛɛ náá: «Saag'am, mɛ ààpadiibal mot ngɔt tɔ bot ɛ wɔ nadjɛ mɛ ɔ» neebela mɛsuk. ");
INSERT INTO bkw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simɔŋ Pyɛɛd nabɛɛ nɛ pɛl. Tin, nyɛ eezɛwaal yɛ tɔ pɛp, nyɛ eezɛkwyal mot-mɛsa mɛ boo ghaa-Zɛɛb. Wɔ gwaa nyɛ zɛtsaal nyɛ ɛlɔ pɛ kyee mbɔ e ghɛŋ. Din ɛ mot-mɛsa mɛ tak nabɛɛ Malkus. ");
INSERT INTO bkw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","É di'enek, Yezu eezɛke nɛ Pyɛɛd náá: «Bulela pɛlɔ tɔ pɛp! Wɔ ke ɛ náá, mɛ aanàkwaadɛ bɛɛlɛ mezuk mɛ Saag'am zedjɛ mɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Deenek, ɛdhuu ɛ esodja nɛ mot nadi kɔ elo bɔɔ ɔ, zɛnɔɔ bɛbaalel ɛ e kukuma eYuda, zokazɛmɛt Yezu. Bɛ eezɛkɔl nyɛ mɛmbɔ nɛ ekel. ");
INSERT INTO bkw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bhii tak bɛ eezɛtɔ́ nɛ nɛ sok pɛ daa Han. Anas nabɛɛ sɛɛg ɛ mwaa Kayif, mot nadi boo ghaa-Zɛɛb e mbu tak ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ghuna, Kayif nadjɛ mɛlyo menek nɛ ekukuma eYuda, náá: «E nyɔ náá, mot ngɔt gwyɛ kɔ ɛsu ɛ bot djas.» ");
INSERT INTO bkw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simɔŋ Pyɛɛd bɛ nɛ dhiiti djekel nadi du Yezu pɛ bhis. Tin, dhiiti djekel'enɔk nadi gunel nɛ boo ghaa-Zɛɛb. Deenek, ye naasa náá, nyɛ ni tɔ kok ndjaŋ ɛ boo ghaa-Zɛɛb lɔɔg wat bɛ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tin, Pyɛɛd zokazɛlik pɛ kel, e ngwoob ɛniel. Tin, wɔ gwaa dhiiti djekel nadi gunel nɛ boo ghaa-Zɛɛb ɔ zɛwyis, tɔ́, kɛlii nɛ moma mɛsa nadi baal ɛniel ɔ. Bhii tak, bɛ eezɛniigal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Moma nadi baal ɛniel tak eezɛke nɛ Pyɛɛd náá: «Dɔɔ nɛ wɔy pe, wɔ nadi ɛ́ ngɔt tɔ sama bɛdjekel ɛ mot yenɔk e?» Wɔ gwaa Pyɛɛd zɛswonal. Nyɛy náá: «Ààbɛ! Mɛ ààgunel nɛ nɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Dáa ɛgwyiyo nadi pupal ɛbuɛpe ɛ. Wɔ gwaa bot ɛ mɛsa nɛ bɛbaalel ɛ kok Ndjaa-ebuwa zokazɛpaada du. Bɛ moo tin é gɔɔl bɔɔ djas. Dɔɔ nɛ Pyɛɛd pe nadi ɛ́ tin, bɛ nɛ bɛ nɔɔ é gɔɔl du. ");
INSERT INTO bkw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tin, boo ghaa-Zɛɛb eezɛdji Yezu mɛdjin dum nɛ bɛdjekel bɛ nɛ dum nɛ mɛlyo mɛ nyɛ di lyo ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","É di'enek, Yezu eezɛbɔɔza nɛ nɛ náá: «Mam nalelyo ɛ, popoopwon emis mɛ bot djas, ààbɛ tɔ syaab. Mɛ nalelyo ɛ, tɔ mendjaa mɛ mendjaala mɛ eYuda nɛ tɔ kok Ndjaa-ebuwa, e di e eYuda djas nadidi é sesɛɛga ɔ. Ye tok nɛ tɛp mɛ nalii tɔ syaab. ");
INSERT INTO bkw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Etɛp yé wɔ di dji mɛ yenek mɛdjin? Djia bot ɛ nadi gwak mɛ ɔ etɛp ee mɛ nadi lelɛɛ bɛ ɛ. Bɔɔ, bɛ nɛ gu ɛnyɔɛpe sa mɛ nadi é lɛɛ bɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dáa Yezu nabɔɔza deenek ɛ, wɔ gwaa mot ngɔt tɔ bɛbaalel ɛ kok Ndjaa-ebuwa nadi tin ɔ zokazɛnyuu nyɛ bɛɛz. Nyɛy nɛ Yezu náá: «Bɛ lii nɛ boo ghaa-Zɛɛb ɛ deenek e?» ");
INSERT INTO bkw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yezu eezɛbɔɔza nɛ nɛ náá: «Yɛ bɛ náá, mɛ eelii ɛbiyoɛpe ɔ, lyaala mɛ tɛp ɛbiyo ɛ tak. Yɛ kabɛ náá, mɛ eelii etsɛɛtsɛ ɔ, ha wɔ ka myak mɛ etɛp yé?» ");
INSERT INTO bkw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tin, Anas eezɛkyeed Yezu pɛ dáa Kayif boo ghaa-Zɛɛb, mɛmbɔ ekɔla. ");
INSERT INTO bkw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","E ɛwala ɛlenek djas Simɔŋ Pyɛɛd nadi ɛ́ tin tɔ ɛbɛsɛɛ ɛ kok ndjaŋ ɛ boo ghaa-Zɛɛb é gɔɔl du. Wɔ gwaa bɛ zɛdji nyɛ náá: «Dɔɔ nɛ wɔy pe, wɔ tok ngɔt tɔ bɛdjekel ɛ mot tak e?» É di'enek, Pyɛɛd zɛswonal, nyɛy náá: «Ààbɛ! Mam ààgyee bis nɛ nɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tin, mot ngɔt tɔ sama bot ɛ mɛsa ɛ boo ghaa-Zɛɛb, mot nadi byel nɛ mot Pyɛɛd natsaal ɛlɔ ɛ. Nyɛ eezɛke nɛ Pyɛɛd náá: «Wɔ ke ɛ́ náá, mɛ bɛ ɛ́ ààbee wɔ mbembɛ tɔ bok é?» ");
INSERT INTO bkw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tin, Pyɛɛd eebaazɛswonal nyɛ swonela sis. Deenek, e di tak wat kuu eezɛkɔk. ");
INSERT INTO bkw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tin, bɛ eezɛdus nɛ Yezu pɛ daa Kayif, tɔ́ nɛ nɛ pɛ ndjaŋ ɛ dhiiti kukuma eLɔm. Ye nabɛɛ tɔ mɛlem kɛɛŋ. Tin, ekukuma eYuda nabɛɛ ààni yɔbɔ pɛ daa kukuma eLɔm. Bɛ nasa deenek ɛ étɛp bɛ nadi kaab náá, bɛ ɛzɛkɛpul etsi bɔɔ. Étɛp bɛ needɛ edee e ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Étɛp tak ɛ, Pilat nazɛboma nɛ nɔɔ pɛ kel. Tin, nyɛ ɛ́ boozɛdji bɛ náá: «Lo mɛsɔ̌ mɛ bi zɛpit mot tak ɛ yé?» ");
INSERT INTO bkw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tin, bɛ eezɛbɔɔza nɛ nɛ náá: «Nyɛ ɛ́ pe di ɛ, ààdi mbee mot ɔ, pe bis ààpazyɛ nɛ nɛ pɛ daa lɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tin, wɔ gwaa Pilat zɛbɔɔza nɛ nɔɔ náá: «Yɛ bɛ deenek ɔ, nɔɔka nyɛ, da bi ɛ kɛpɛ́ɛ nyɛ dáa etsi bin di lɛɛ ɛ.» É di'enek, eYuda eezɛbɔɔza náá: «Bisɔ eYuda, bis tok nɛ eghɛŋ ɛdjɛ mot epɛ́ɛ e ɛsyee.» ");
INSERT INTO bkw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ye nasɛɛ deenek ɛ etɛɛ náá, mɛkpa mɛ Yezu nalɛɛ dum nɛ kɔkɔ mbi ɛsyee ɛ nyɛ aagwyɛ ɛ́, neebela ɛsuk. ");
INSERT INTO bkw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tin, Pilat eezɛni tɔ ndjaŋ ɛ, bhii tak, nyɛ eezɛdjóo Yezu. Nyɛ eezɛdji nyɛ náá: «Wɔ ɛ mɛkoozi mɛ eYuda?» ");
INSERT INTO bkw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Deenek, Yezu eezɛbɔɔza nɛ nɛ náá: «Ye ɛ́ esiiza bɔ met ɛ di ke náá, wɔ dji mɛ deenek ohoo? Wɔ dji deenek ɛ, etɛɛ náá, bot ɛ sis ɛlɛɛ wɔ deenek kɔ ɛsu ɛ lam?» ");
INSERT INTO bkw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tin, Pilat eezɛbɔɔza náá: «Wɔ bee mɛ mot dhaad mbyak eYuda? Bot ɛ dhaad mbyak ɔ nɛ eboo bɛghaa-Zɛɛb ɛ zɛpit wɔ pɛ daa lam. Wɔ sa yé?» ");
INSERT INTO bkw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","É di'enek, Yezu eezɛbɔɔza nɛ nɛ náá: «Ɛyoŋ ɛ lam tok yii bɔs'ak. Ɛyɔŋ ɛ lam ɛpedi ɛ́ di yii bɔs'ak ɔ, pe bot ɛ di baal mɛ ɔ eelumla dɛɛb nɛ nen. E kaab náá, eYuda ɛzɛkɛmɛt mɛ, kɛka mɛ e mɛmbɔ mɛ ekukuma bɔɔ. Ààbɛ! Ye tok deenek, ɛyoŋ ɛ lam tok ɛyoŋ ɛ bɔs'ak.» ");
INSERT INTO bkw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tin, Pilat eebaazɛdji nyɛ náá: «Deenek, ye kwyɛl ɛlɛɛ náá, wɔ ɛ́ mɛkoozi?» É di'enek, Yezu eebaazɛbɔɔza náá: «Wɔy wɔ ɛmet eeke náá, mɛ ɛ mɛkoozi. Mɛ eezebyel, tin, mɛ nazyɛ kɔ bɔs ɛ etɛp mɛ neezɛbaŋa bot sa etsɛɛtsɛ di ɛ. Mot di myaal etsɛɛtsɛ ɔ, nɛ gwak etɛp ee mɛ di lii ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","É di'enek Pilat eezɛdji náá: «Etsɛɛtsɛ kwyɛl ɛlɛɛ yé?» Bhis nyɛ nadji nyɛ deenek ɛ, Pilat eebaazɛsik, kɛboma nɛ eYuda pɛ kel. Nyɛ eezɛke nɛ nɔɔ náá: «Mam ààbee lo mɛsɔ̌ mɛ mɛ di egoka nɛ ɛpɛ́ɛ mot tak epɛ́ɛ e ɛsyee dum nɛ tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tin, dáa bi di náá: «Bi nɛ gu dáa mena di zyɛka nɛ ɛsesa sok. E mɛbyoŋ mɛ ePak djas ɛ, mɛ nɛ dyeebapel bin mot membok ngɔt. Bi kwyɛl ɛ náá, mɛ pel mɛkoozi mɛ eYuda?» ");
INSERT INTO bkw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bɛ eezɛbɔɔza nɛ Pilat nɛ etsim náá: «Oo! Ààbɛ nyɛy! Bis kwyɛl ɛ náá, wɔ wyisal Bhaalabas!» Ghuna Bhaalabas nabɛɛ mot ɛzɛm nɛ ebhooba. ");
INSERT INTO bkw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Deenek, Pilat eezɛlwom náá, bɛ nɔɔ Yezu. Da bɛ ɛ́ nyuu nyɛ nɛ eghwyɛs. ");
INSERT INTO bkw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tin, wɔ gwaa esodja zokazɛsa kɔtɔ nɛ kel mɛgɔk, sɔm Yezu ye ɛ́ e lo. Bɛ eezɛbet nyɛ ndjookuwa na tɔɔbelaa. ");
INSERT INTO bkw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bɛ moo tin é tiila sok bhwoob'ɛ. Bɛ ka tin ɛ, é swos nyɛ mɛswosel mɛ mɛduka náá: «Mɛ eeswos wɔ, mɛkoozi mɛ eYuda!» Nɛ ɛpak nyɛ mɛbhɛɛz. ");
INSERT INTO bkw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tin, Pilat eebaazɛwyis pɛ kel wyisa sis. Nyɛ eezɛke nɛ edhuu ɛ bot náá: «Gwakeka, mɛ ɛpezyɛ nɛ nɛ wak étɛp bi neegu náá, mɛ ààpabela lo mɛsɔ mɛ di egoka nɛ ɛdjɛ mot tak epɛ́ɛ e ɛsyee dum nɛ tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tin, Yezu eezɛwyis, nyɛ eebɔt kɔtɔ mɛgɔk nɛ ndjookuwa na tɔɔbelaa e nyel. Tin, Pilat eezɛke náá: «Beeka mot tak e!» ");
INSERT INTO bkw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tin, eboo bɛghaa-Zɛɛb nɛ bɛbaalel ɛ kok Ndjaa-ebuwa nabee nyɛ ɛ́. Wɔ gwaa bɛ zɛtsim náá: «Bemka nyɛ e mɛlaaba! Bemka nyɛ e mɛlaaba!» É di'enek, Pilat eezɛke nɛ nɔɔ náá: «Kɛ bemka nyɛ e mɛlaaba, biyɔ bɛ ɛmet. Etɛɛ náá, tɔ yam beea, mam ààbee lo mɛsɔ mɛ di egoka nɛ ɛdjɛ mot tak epɛ́ɛ e ɛsyee dum nɛ tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","É di'enek, eYuda eezɛke nɛ nɛ náá: «Bis ɛ nɛ etsi, dum nɛ etsi tak, nyɛ goka ɛ́ nɛ ɛsyee. Etɛɛ náá, nyɛ ke ɛ náá, nyɛ ɛ Mɔn Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Dáa Pilat nagwak elii bot binɔk ɛ, bwoo nabaazɛsa nyɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nyɛ eezɛsik tɔ ndjaa, bhii tak, nyɛ eezɛdji Yezu náá: «Wɔ dus paa?» Tin, Yezu nabɛɛ, ààbɔɔza nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat eezɛke nɛ nɛ náá: «Wɔ ààkwyɛl ɛbɔɔza e mɛdjin mam e? Wɔ ààgu náá, mɛ ɛ nɛ ghwyil ɛbet wɔ, dɔɔ nɛ ghwyil ɛlwom náá, bɛ bem wɔ e mɛlaaba?» ");
INSERT INTO bkw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yezu eezɛbɔɔza nɛ nɛ náá: «Wɔ tok nɛ dhiiti ghwyil wat kɔ lam, bhis yii Zɛɛb nadjɛ wɔ ɛ. Étɛp tak ɛ di náá, mot zɛseeb mɛ e mɛmbɔ mɔ ɛ, nyɛ ɛ́ nɛ boo ndjɛ dhaa dhaŋa yɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","É di'enek, Pilat nabɛɛ, nyɛ moo saa mɛpek etɛɛ nyɛ bet Yezu. Tin, eYuda eebaazɛni é tsim náá: «Wɔ ɛbet mot yenɔk ɔ, wɔ tok sɔ ɛ Sezaad boo mɛkoozi. Etɛɛ náá, mot ɛ ke wak náá, nyɛ mɛkoozi ɔ, yenɔk ɛ mot mɛbhuka mɛ Sezaad!» ");
INSERT INTO bkw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dáa Pilat nagwak mɛkpa menek ɛ, nyɛ ɛ́ boozɛwyisal Yezu pɛ kel. Bhii tak nyɛ eezɛdisi kɔ boo bɛtetɛp e di bɛ nadi é djóo tɔ lii ebhele: «Ghabata» ɛ. Yɛ ɛ di ɛbɛsɛɛ di náá, mɛkok ɛ djaa si é bɔs ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ye nabɛɛ e ges dwoo saba ɛbyoŋ ɛ Pak, ye moo tɔ tyee ɛwala kuku mwos. Tin, Pilat eezɛke nɛ eYuda náá: «Beeka mɛkoozi min e!» ");
INSERT INTO bkw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","É di'enek bɔɔ djas eezɛtsim ɛlyelɛpe náá: «Góa nyɛ! Góa nyɛ! Bema nyɛ e mɛlaaba!» Pilat eezɛdji bɛ náá: «Bi kwyɛl ɛ náá, mɛ bem mɛkoozi min e mɛlaaba?» Eboo bɛghaa-Zɛɛb eezɛbɔɔza náá: «Bis tok nɛ dhiiti mɛkoozi bhis mɛkoozi Sezaad!» ");
INSERT INTO bkw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tin, Pilat eezɛka bɛ Yezu étɛp bɛ neekɛbem nyɛ e mɛlaaba. Bɛ eezɛtɔ́ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tin, Yezu nyɛ ɛmet eezɛbɛp mɛlaaba mɛ étɛp ɛwyis kɔ dɛl. Da nyɛ ɛ tɔ́ pɛ dhiiti di bɛ nadi djóo tɔ lii ebhele «Ghologhota» ɛ. Ye kwyɛl ɛlɛɛ ɛ: «Di Bhobho Lo». ");
INSERT INTO bkw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","E di tak ɛ esodja nabem Yezu e mɛlaaba. E ɛwala ɛ tak wat, bɛ zokabaabem bɛdhiiti bot ɛbá e mɛlaaba, nwyak pɛ yak kyee, nwyaa ngɔt pɛ yii kyee. Yezu nadi ɛ́, kuku tak. ");
INSERT INTO bkw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tin, Pilat zokalwom náá, bɛ nɔɔ mɔɔ pɛt ɛbaya, da bɛ ɛ́ tsel kɔ mɛlaaba mɛ tak. Kɔ mɔɔ pɛt ɛbaya ɛ tak bɛ nakwyal ɛ náá: «Yezu, mot Nazalɛt, mɛkoozi mɛ eYuda.» ");
INSERT INTO bkw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bɛtɛɛ nɛ eYuda naalaa ekwyala e tak etɛɛ náá, di bɛ nabem Yezu e mɛlaaba ɔ, nabɛɛ, e ngwoob dɛl. Deenek, ekwyala e tak nabɛɛ tɔ lii ebhele, nɛ tɔ lii eLɔm, dɔɔ nɛ tɔ lii eGhɛlɛk. ");
INSERT INTO bkw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tin, wɔ gwaa eboo bɛghaa-Zɛɛb zokazɛke nɛ Pilat náá: «Ye bɛ ààgoka náá, wɔ kwyal náá: “Mɛkoozi mɛ eYuda.” Tin, wɔ goka nɛ ɛkwyal ɛ náá: “Mot tak ke ɛ́ náá: Mɛ ɛ mɛkoozi mɛ eYuda.”» ");
INSERT INTO bkw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat eezɛbɔɔza nɛ nɔɔ náá: «Sa mɛ zeekwyal ɛ, ye lik ɛ kwyala.» ");
INSERT INTO bkw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dáa esodja nasilal ɛbem Yezu e mɛlaaba ɛ, bɛ eezɛnɔɔ ekaad bɛ, wɔ gwaa bɛ zɛkaa yɛ ekyee ená, mot nɛ mot nɛ yɛ kyee. Bɛ zokabaazɛnɔɔ lɔbɔ yɛ nadi lata nɛ kel wat kana pɛ si kɛkum pɛ ɛko ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tin, esodja moo tin é ke pak'ɔɔ náá: «Sa mena àànyaaka lɔbɔ yak. Deenek djhooka sa ka ɛgwyeeg étɛp mena neeguka mot aanɔɔ yɛ ɔ.» Ye ɛ́ deenek ɛ, mɛkpa mɛ Zɛɛb di lɛɛ náá: «Bɛ naakaa ekaad bam. Bɛ naasa ɛgwyeeg étɛp ɛnɔɔ kaadam» naabela ɛsuk. Beeka dáa esodja nasa enek. ");
INSERT INTO bkw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nyɛɛg ɛ Yezu nabɛɛ tin titel, e ngwoob mɛlaaba, bɛ ɛ́ mɔn nyɛɛg, zɛnɔɔ Maali mwaa Keleopas, dɔɔ nɛ Maali, moma dɛl ɛ Makdala. ");
INSERT INTO bkw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yezu eezɛbee nyɛɛg, tin, djekel nyɛ nadyeebakwyɛl ɔ e ngwoobɛ. Nyɛ ɛ́ boozɛke nɛ nyɛɛg náá: «Nyaag'am, beea mɔn'ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Bhii tak nyɛ eezɛke nɛ djekel tak náá: «Beea nyoog e». Tin, kana ɛwala ɛlenek, djekel yenɔk eezɛnɔɔ nyɛ, tɔ́, kɛdi e di wat bɛ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bhis etɛp binek, dáa Yezu nadi é gu náá, etɛp djas nabɛɛ, ye naazesael ɛ. Nyɛ eezɛke, etɛɛ náá, esesɛɛ ee nadi ekwyala ɛ djas neebela mɛsuk. Ye na bɛ ɛ́ yɛ eekwyalaa náá: «Mɛ ɛ nɛ gwyes mɛdii.» ");
INSERT INTO bkw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","E di tak, ye nabɛɛ nɛ bhe nɛ mɛnyok mɛ na bwaaz-bwaaz tɔ tak «tɔɔɔ». Tin, wɔ gwaa esodja zokaduu pes mɛnyuku tɔ mɛnyok mɛ tak, bɛ eezɛkɔl e lɛɛ mɔɔ le. Bhii tak bɛ eezɛsɛɛb yɛ pɛ pak nuub ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yezu eezɛdɛ mɛnyok mɛ na bwaaz-bwaaz menek, bhii tak nyɛ zɛke náá: «Djas eedjala!» É di'enek, nyɛ eezɛsil lo si. Bhii tak, nyɛ eezɛsil eswos. ");
INSERT INTO bkw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ye nabɛɛ, e ges dwoo saba. Ekukuma eYuda nabɛ ààkwyɛl náá, emuu di kɔ mɛlaaba e dwoo saba. Bela náá, ye nabɛɛ boo saba. Tin, bɛ ɛ́ boozɛke nɛ Pilat náá, nyɛ lwom bot, bɛ kɛɛbwak mɛko mɛ bot ɛ nadi e mɛlaaba ɔ, da bɛ ɛ́ dis emuu bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tin, esodja naazɛzyɛ zɛbwak bɛ mɛko mɛ bot ɛbá nabemaa e mɛlaaba lɔɔg wat nɛ Yezu ɔ. ");
INSERT INTO bkw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dáa bɛ nakazyɛ étɛp ɛzɛbwak yɛ Yezu ɛ, bɛ ka bee ɛ, nyɛ eezegwyɛ. Étɛp tak ɛ bɛ nadi ààbwak nyɛ mɛko. ");
INSERT INTO bkw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tin, wɔ gwaa sodja ngɔt zokazɛlum nyɛ nɛ ɛkɔɔ e bhaaz. Wɔ gwaa, ghiya nɛ mɛdii zokazɛwyis e sum di tak. ");
INSERT INTO bkw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mot nabee nɛ mis mɛ dáa étɛp bak djas nadi sɛɛ ɛ di kaada etɛp bak. Etɛp ee nyɛ di lɛɛ wak ɛ, ye ɛ́ etɛp etsɛɛtsɛ. Nyɛ nɛ gu náá, nyɛ lɛɛ ɛ etɛp etsɛɛtsɛ. Nyɛ lɛɛ bin ɛ, etɛɛ náá, biyɔ pe, bi neemyaal. ");
INSERT INTO bkw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Etɛp bak djas nasael ɛ, etɛɛ náá, sa nakwyalaa tɔ mɛkana mɛ Zɛɛb náá: «Nyɛ aanàkwaabwakaa gwyes wat ɛ» neebela ɛsuk. ");
INSERT INTO bkw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E dhiiti di, mɛkana mɛ Zɛɛb baalɛɛ ɛ náá: «Bɛ waabee mot bɛ lum nyɛ e bhaaz ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bhii tak, Zozɛf mot dɛl Alimate eezɛwaab nɛ Pilat náá, nyɛ djɛ nyɛ ze étɛp ɛnɔɔ muu ɛ Yezu nyɛ neekɛdel. Zozɛf nabɛɛ djekel ɛ Yezu tɔ syaab, etɛɛ náá, nyɛ nadi kaab ekukuma eYuda. Pilat zokamyaal, bhii tak, nyɛ eezɛtɔ́, kɛnɔɔ muu ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodhɛm, mot natɔ́ kɛboma nɛ Yezu dhiiti dwoo e pum ɔ, zokazyɛ. Nyɛ nazyɛ ɛ nɛ epuuza bɛmɛnanas ekilo mɛkam-mɛlɛl yii nasael nɛ miid nɛ aloe ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tin, bɔɔ bɛbá eezɛnɔɔ muu ɛ Yezu. Wɔ gwaa bɛ zɛpil yɛ tɔ epes bheeza, nɛ ɛsoso mɛnanas menek e tak. EYuda dyeebazezyɛ nɛ ɛsesa deenek, esok bɛ di ɛkɛdel mot ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","E ngwoob di bɛ nawa Yezu e mɛlaaba ɛ, ye nabɛɛ nɛ bok wat tin. Tɔ bok tak, ye nabɛɛ nɛ ɛvit ɛ na bes nadi náá, bɛ dinaa ààpaawa mot tɔ tak sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Dáa nadi náá, ye nabɛɛ e ges dwoo saba eYuda ɛ, nɛ dáa ye nabela náá, ɛvit nadi ɛ́ ɛkunaaɛpe ɛ. Etɛɛ tak ɛ, bɛ zokanɛɛg muu ɛ Yezu tɔ tak. ");
INSERT INTO bkw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kɛɛŋ tɔ ghooghom mɛlem mɛ dwoo yenga, Maali moma dɛl Makdala eezɛtɔ́ pɛ ɛvit. Nyɛ kabee ɛ, ɛvit moo mbek, boo ɛkok ɛ nadi eyalaa ɛvit nɛ yɛ ɔ, moo mbiŋela e ngwoob ɛ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nyɛ eezɛsum kaab, tɔ́, kɛlɛɛ Simɔŋ Pyɛɛd nɛ dhiiti djekel ɛ Yezu nadi kwyɛl ɛbuɛpe ɔ. Tin, nyɛ eezɛlɛɛ bɛ náá: «Bɛ eedis muu ɛ Ghɛŋ tɔ ɛvit ɛ lɛ. Bis ààgu pɛ kyee bɛ kɛnɛɛg nyɛ ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tin, Pyɛɛd bɛ nɛ dhiiti djekel eezɛnɔɔ mɛnyel tɔ́ pɛ ɛvit ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bɔɔ djas bɛbá eezɛsum kaab. Dáa bɛ nadi kaab ɛ, dhiiti djekel yenɔk naadhaa Pyɛɛd nɛ kaab, nyɛ eezɛkum pɛ ɛvit ɛsok. ");
INSERT INTO bkw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tin, nyɛ eezɛmalal gwyák tɔ ɛvit, nyɛ kabee ɛ bɔɔ epes e kaad bɛ nadjɛl Yezu nyel nɛ ye ɛ́, nɛɛga si. Nyɛ kadi ɛ, ààni tɔ́ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔŋ Pyɛɛd mot nadi du nyɛ pɛ bhis'ɔ eebaazɛkum yɛ. Wɔ gwaa nyɛ zɛni tɔ ɛvit, nyɛ kabee ɛ bɔɔ epes e kaad bɛ nadjɛl nyɛ nyel nɛ ye ɛ́, nɛɛga si. ");
INSERT INTO bkw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Dɔɔ nɛ bhɛɛ bɛ nabutal lo ɛ Yezu nɛ ye ɛ́. Bhɛɛ tak nabɛɛ ààdi e di wat nɛ bɔɔ epes e kaad bɛ nadjɛl nyɛ nyel nɛ ye ɛ́. Bhɛɛ nadi ɛ́, pila e dhiiti di. ");
INSERT INTO bkw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tin, djekel naleedum ɛsok ɔ, zokazɛni tɔ ɛvit. Dáa nyɛ nabee deenek ɛ, nyɛ eezɛdum koŋ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tin, kɛkum ɛwala ɛlenek, bɛdjekel ɛ tak nabɛɛ bɛ dinaa ààmɛt ɛsuk ɛ ekwyala e Zɛɛb di ke náá, Yezu nawaadiɛ gom tɔ ɛsyee ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bhii tak, bɛdjekel binɔk bɛbá eezɛsik, tɔ́ pɛ ndjaŋ ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maali nadi ɛ́ tetel pɛ kel e ngwoob ɛvit, nyɛy é dje. Dáa nyɛ nadi é dje ɛ, wɔ gwaa nyɛ malal gwyák tɔ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nyɛ kabee ɛ, efofop ebá nɛ ekaad e na puu e mɛnyel, bɔɔ mendiindil e di bɛ nanɛɛg muu ɛ Yezu ɔ. Ngɔt pɛ kyee bɛ nanɛɛg lo ɛ Yezu ɛ, nwyak ngɔt pɛ kyee mɛko. ");
INSERT INTO bkw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","É di'enek, efofop eezɛdji nyɛ náá: «Wɔ dje yé?» Nyɛ eezɛbɔɔza nɛ nɔɔ náá: «Bɛ eedis Ghɛŋ'am. Mɛ ààgu pɛ bɛ kɛnɛɛg nyɛ ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dáa nyɛ nalii deenek ɛ, nyɛ eezɛliig mis, nyɛ eebee Yezu tinaak tetel. Tin, Maali nabɛɛ ààgu náá, ye nabɛɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wɔ gwaa Yezu zɛdji náá: «Wɛɛ moma, wɔ dje yé? Wɔ saa zɛ?» Nyɛ nagu ɛ náá, ye nabɛɛ mot-mɛsa mɛ bok. Étɛp tak ɛ nyɛ nabɔɔza nɛ nɛ náá: «Yɛ bɛ náá, wɔy ɛ dis nyɛ ɔ, lɛɛa mɛ pɛ wɔ kɛnɛɛg nyɛ ɛ́, mɛ neetɔ́, kɛnɔɔ nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tin, Yezu eezɛke nɛ nɛ: «Maali!» Nyɛ eezɛliigel, gwyák pɛ Yezu nadi ɛ́. Bhii tak, nyɛ eezɛlii nɛ nɛ tɔ dhaad lii ebhele náá: «Rabhuni!» Ye kwyɛl ɛlɛɛ ɛ: «Lyoel». ");
INSERT INTO bkw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yezu eezɛke nɛ nɛ náá: «Nà mɛt mɛ etɛɛ náá, mɛ dinaa paa byet pɛ daa Saag'am. Deenek, Tɔ́a, kɛlɛɛ nɛ bɔn nyɛɛg bam náá, mɛ ɛpebyet pɛ daa Saag'am, baadi pe Sɛɛg'en ɔ; pɛ daa Zɛɛbam, baadi pe Zɛɛben ɔ.» ");
INSERT INTO bkw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","É di'enek, Maali moma dɛl Makdala eezɛsik, tɔ́ pɛ bɛdjekel nadi ɛ́. Nyɛ eekɛlɛɛ bɛ náá: «Mɛ eebee Ghɛŋ!» Bhii tak, nyɛ moo elɛɛ bɛ etɛp ee nyɛ nalɛɛ nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ye nazobɛ ɛ dwoo yenga tak wat bikoko, bɛdjekel nadi ɛ́ bɔɔ djas e di wat tɔ dhiiti ndjaa. Ye nabɛɛ, bɛ eekɔɔl ɛbɛ ɛ ndjaa ghiŋ, etɛɛ náá, bɛ di kaab ekukuma eYuda. Yezu zɛzyɛ, nyɛ eezɛtyaa tetel kuku ɛbwak ɛ lɔɔ. Nyɛy nɛ nɔɔ náá: «Egwyem di nɛ nen!» ");
INSERT INTO bkw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tin, dáa nyɛ nasilal ɛke nɛ nɔɔ deenek ɛ, nyɛ moo tin é lyaal bɛ ebam e mɛmbɔ mɛ nɛ yii bhaaz'ɛ. É di'enek, elyem bɛdjekel nalwood nɛ mɛmyaala dáa bɛ nabee Ghɛŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yezu eebaazɛke nɛ nɔɔ náá: «Egwyem di nɛ nen! Dáa Saag'am nalwom mɛ ɛ, mam pe mɛ eelwom bin.» ");
INSERT INTO bkw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bhis mɛkpa menek, Yezu eezɛwuubal kɔ lɔɔ, nyɛy nɛ nɔɔ náá: «Nɔɔka Sisim na Dɛɛ! ");
INSERT INTO bkw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bot ɛ bi aapel mesyem mɔɔ ɛ, mesyem mɔɔ waapelel. Bot ɛ bi aapɛɛ ɛpel ɛ mesyem mɔɔ ɛ, mesyem mɔɔ aanàkwaapelel.» ");
INSERT INTO bkw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ghuna ngɔt tɔ bɛdjekel kam nɛ bɛbá, Toma mot nagetaa din ɛ «Ɛwas» ɔ, nabɛ ààdi tak é ghɛŋ Yezu nazyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tin, bɛdhiiti bɛdjekel zokazɛlɛɛ nyɛ náá: «Bis eebee Ghɛŋ!» Wɔ gwaa Toma zɛbɔɔza nɛ nɔɔ náá: «Mɛ ɛ di ààbee ebam mɛpyoŋ mɛ epɔndi tɔ mɛmbɔ mɛ ɔ. Mɛ di ààwa djin tɔ ebam mɛpyoŋ mɛ tak ɔ. Mɛ di ààwa mbɔ tɔ bam bɛ natuu nyɛ ɛkɔɔ é ebhaaz ɔ. Yɛ di ààbɛ deenek ɔɔ, mɛ tok nɛ ghwyil ɛmyaal.» ");
INSERT INTO bkw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yenga wat bhii tak, bɛdjekel nabaadiɛ zɛɛga e di wat tɔ ndjaa. Toma nadi ɛ́ tin, bɛ nɛ bɛ nɔɔ. Mɛbɛ mɛ ndjaa nadi ekɔɔla ghiŋ. Tin, Yezu eezɛzyɛ, nyɛ eezɛtyaa tetel kuku ɛbwak ɛ lɔɔ. Nyɛy nɛ nɔɔ náá: «Egwyem di nɛ nen!» ");
INSERT INTO bkw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Bhii tak, nyɛ eezɛke nɛ Toma náá: «Wa djinɔ wak, da wɔ ɛ bee mɛmbɔ mam. Sɛɛba mbɔ ɔ, da wɔ ɛ zɛwa tɔ ebhaaz bam. Kata ɛswonal, da wɔ ɛ dum koŋ nɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tin, Toma eezɛbɔɔza náá: «Ghɛŋ'am, Zɛɛbam.» ");
INSERT INTO bkw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","É di'enek, Yezu eezɛke nɛ nɛ náá: «Wɔ dum koŋɔ nɛ nam ɛ, etɛɛ náá, wɔ eebee mɛ? Ɛnyɔ nɛ bot ɛ di dum koŋɔɔ nɛ nam, bɔɔ ààbee mɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yezu naasa dhiiti bɛtɛ nɛ endem e mɛbwala e mis mɛ bɛdjekel bɛ. Endem e mɛbwala ngɔt di náá, etok kwyala, tɔ mɛkana mak ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Yak tak nakwyalaa ɛ, étɛp bi neemyaal náá, Yezu ɛ Mɛsia Mɔn Zɛɛb. Tin, bi ɛ dum koŋ nɛ nɛ deenek ɔ, bi ɛ waabela tsik na kɔm-kɔm nɛ din ɛ lɛ. ");
INSERT INTO bkw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Bhis ba mɛlu, Yezu baazɛtel nyel tela sis nɛ bɛdjekel bɛ e ɛboŋ ɛ dii Tibeliaad. Beeka dáa ye nadhaŋ ɛ. ");
INSERT INTO bkw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔŋ Pyɛɛd, nɛ Toma nadi djóoaa «Ɛwas» ɔ, zɛnɔɔ Natanaɛl mot ghaada Kana, pɛ kyee dik Ghalile. Baazɛnɔɔ bɔn ɛ Zɛbɛdɛ bɛbá, nɛ bɛdhiiti bɛdjekel bɛbá, bɛ nadi ɛ́ sama wat. ");
INSERT INTO bkw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simɔŋ Pyɛɛd eezɛke nɛ nɔɔ náá: «Mɛ ɛpetɔ́ kɛlóo ngwyep.» Bɛ eezɛbɔɔza nɛ nɛ náá, «Djhookaka.» Tin, bɛ eezɛwyis, zɛni tɔ boo elɛɛd. Deenek, e pum yenek djas bɛ nabɛɛ ààkobela sonok. ");
INSERT INTO bkw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","E mɛlem kɛɛŋ, Yezu eezɛtyaa e ngwoob dii tak. Tin, bɛdjekel naabee nyɛ, ààgu náá, ye ɛ́ Yezu. ");
INSERT INTO bkw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nyɛ eezɛke nɛ nɔɔ náá: «Ehe biyɔ mengbaaz, bi tok nɛ ba bɛsu?» Bɛ eezɛbɔɔza nɛ nɛ náá: «Ohoo, bis tok nɛ yɛ hoo.» ");
INSERT INTO bkw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nyɛ eezɛke nɛ nɔɔ náá: «Laka ɛwyet pɛ kyee mbɔ eghɛŋ e boo elɛɛd bin, bi ɛ waabela.» Tin, bɛ eezɛlaa ɛ́ yenek, wɔ gwaa bɛ zɛbela bɛtɛ nɛ bɛsu. Mɛbu mɛ tak ààdjala nɛ dáa bɛ aakwak ɛghɛɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Djekel Yezu nadi é kwyɛl ɛbuɛpe ɔ, zokake nɛ Pyɛɛd náá: «Ye ɛ́ Ghɛŋ!» Dáa Simɔŋ Pyɛɛd nagwak mɛkpa mɛ náá: «Ye ɛ́ Ghɛŋ!» Nyɛ eezɛkɔl ndjookuwa yɛ e kuu, etɛɛ náá, ye nabɛ ɛ́, nyɛ naadis ndjookuwa étɛp ɛla ɛwyet. Bhii tak nyɛ eezɛghaaga tɔ dii. ");
INSERT INTO bkw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bɛdhiiti bɛdjekel eezɛbula tɔ boo elɛɛd bɔɔ é dul ɛwyet «tɔɔɔ» nɛ bɛsu tɔ tak. Bɛ nabɛɛ ààdyeebatseta nɛ ɛboŋ bɛ nadi ɛ́ tyee emɛtɛlɛ bɛdhet ebá nɛ ɛboŋ. ");
INSERT INTO bkw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dáa bɛ nazesɛɛ nɛ elɛɛd e bɔs ɛ, bɛ ka sɛka ɛ du nɛ su kɔ tak, zɛnɔɔ mapa. ");
INSERT INTO bkw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yezu eezɛke nɛ nɔɔ náá: «Dhaaka nɛ bɛdhiiti bɛsu ɛ bi gó ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tin, Simɔŋ Pyɛɛd eezɛgo tɔ elɛɛd. Nyɛ eezɛdul ɛwyet ɛ nazelwood nɛ bɛsu ɛ, pɛ kyiid. Deenek, tɔ ɛwyet, ye nabɛɛ nɛ eboo bɛsu dhet nɛ mɛkam-mɛtɛn nɛ elɛl. Tin, nɛ eboo bɛsu binek, ɛwyet nabɛɛ àànyɛɛ. ");
INSERT INTO bkw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Bhii tak, Yezu eezɛke nɛ bɛdjekel náá: «Dha dɛka!» Tin, tɔ bɛdjekel, ye nabɛ ààbɛ nɛ mot ngɔt nabɛɛ nuubɛ, dji náá: «Wɔ ɛ́ zɛ?» Etɛɛ náá, bɔɔ djas nadi gu náá, ye nabɛɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yezu eezɛtiila. Wɔ gwaa nyɛ zɛnɔɔ mapa, kaa bɛ ye ɛ́. Bhii tak nyɛ eebaazɛnɔɔ su, kaa bɛ ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yenek tak nabɛɛ tyee esok elɛl ee nyɛ nalyaal bɛdjekel bɛ nyel, bhis Zɛɛb nagomal tɔ esyee nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bhis bɛ nasilal ɛdɛ edee ɛ, Yezu eezɛke nɛ Simɔŋ Pyɛɛd náá: «Simɔŋ mɔɔ Zaŋ, wɔ nɛ kwyɛl mɛ dhaa bak bot e?» Simɔŋ eezɛbɔɔza náá: «Hɛɛɛ, Ghɛŋ, wɔy wɔ ɛmet nɛ gu náá, mɛ nɛ kwyɛl wɔ.» Tin, Yezu eezɛlɛɛ nɛ nɛ náá: «Wyeela bɔɔ ebhata bam.» ");
INSERT INTO bkw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nyɛ eebaazɛdji djia sis tyee esok ebá: «Simɔŋ, mɔɔ Zaŋ, wɔ nɛ kwyɛl mɛ?» Tin, Pyɛɛd eezɛbɔɔza nɛ nɛ náá: «Hɛɛɛ, Ghɛŋ, wɔ nɛ gu djas. Wɔ nɛ gu náá, mɛ nɛ kwyɛl wɔ!» Yezu eebaazɛbɔɔza nɛ nɛ náá: «Baala etaabam.» ");
INSERT INTO bkw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nyɛ eebaazɛdji djia sis tyee esok elɛl náá: «Simɔŋ, mɔɔ Zaŋ, wɔ nɛ kwyɛl mɛ?» Tin, lyem nabɛɛ, ye kpaa Simɔŋ nɛ dáa nyɛ nabaadji mɛdjin mɛ tak djia sis náá: «Simɔŋ, mɔɔ Zaŋ, wɔ nɛ kwyɛl mɛ?» Tin, Pyɛɛd eezɛbɔɔza nɛ nɛ náá: «Ghɛŋ, wɔ nɛ gu djas, wɔ nɛ gu náá, mɛ nɛ kwyɛl wɔ!» Yezu eebaazɛbɔɔza nɛ nɛ náá: «Wyeela etaabam. ");
INSERT INTO bkw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mɛ lɛɛ wɔ yɛ tsɛɛtsɛ: Eghɛŋ wɔ nadi, wɔ dinaa ngbaaz ɛ, wɔ nakokɔl bhɛtɛ yɔ e kuu ɛ wɔy wɔ ɛmet. Wɔ natetɔ́ ɛ pɛ lyemɔ nadi kwos ɛtɔ́ ɛ. Tin, eghɛŋ yɛ ààkabɛ náá, wɔ eezegeeb ɛ, wɔ aazokasesɛɛb ɛ mɛmbɔ, da mot sis ɛ kɔl wɔ bhɛtɛ. Da nyɛ ɛ́ tɔ́ nɛ nɔ pɛ lyemɔ aadi ààkwos ɛtɔ́ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nɛ mɛkpa menek, Yezu nadi é lyaal ɛ dáa ɛsyee ɛ Pyɛɛd aadi ɛ́, dáa ɛsyee ɛ lɛ aadjɛ Zɛɛb duu ɛ. Bhii tak, Yezu eezɛke nɛ nɛ náá: «Dua mɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pyɛɛd eezɛliig mis, nyɛ eezɛbee djekel ɛ Yezu nadi é kwyɛl ɛbuɛpe ɔ. Djekel tak ɛ mot namalal pɛ daa Yezu esok bɛ nadi é ɛdɛ edee ɛ. Da nyɛ zɛdji Yezu náá: «Ghɛŋ, ɛzɛ aakɛka wɔ gha?» ");
INSERT INTO bkw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tin, beea Pyɛɛd nabee nyɛ ɛ́, nyɛ eezɛdji Yezu náá: «Ha nyɛy, Ghɛŋ, ɛyé aasa nyɛy?» ");
INSERT INTO bkw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yezu eezɛbɔɔza náá: «Mɛ kwyɛl náá, nyɛ di nɛ tsik kɛyaka nɛ dwoo mɛ waabula ɔ, ye gwyák wɔ wo? Wɔy, dua mɛ!» ");
INSERT INTO bkw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tin, lɛŋ tak eezɛkɛ pak bot ɛ nadi dum koŋ nɛ Zɛɛb ɔ náá, djekel yenɔk aanàkwaagwyɛ. Ghuna Yezu nabɛɛ ààke nɛ Pyɛɛd náá: «Nyɛ aanàkwaagwyɛ.» Nyɛy nake ɛ náá: «Mɛ kwyɛl náá, nyɛ di nɛ tsik, kɛyaka nɛ dwoo mɛ waabula ɛ, ye gwyák wɔ wo?» ");
INSERT INTO bkw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ye ɛ́ djekel tak nyɛ ɛmet ɛ di kaada etɛp ee nyɛ bee ɛ. Nyɛ ɛ́ boo wa yɛ tɔ ekwyala. Deenek, mena nɛ guka náá, etɛp ee nyɛ di lɛɛ ɛ, ye ɛ́ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yezu naabaasa bɛdhiiti bɛtɛ nɛ esonok. Ye ɛ́ pe bɛ ɛ, bɛ kwyal djas tɔ bɛmɛkana ɔ. Mɛ bee ɛ́ náá, pe bɔs djas aanàkwaakodjala-djalak étɛp ɛnɛɛg ɛ bɛmɛkana mɛ tak.");
INSERT INTO bkw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Wɛn sɔ'am Teofil, tɔ mɛkana mam yii ɛsok, mɛ naakaada etɛp ee Yezu nasa ɛ, nɛ mɛlyo mɛ nyɛ nalyo djas e mɛkɛn «tɔɔɔ» ɛ, ");
INSERT INTO bkw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","zɛkum dwoo Zɛɛb naben nyɛ tɔ́ tɔ gwoo ɛ. Ɛsok nɛ nyɛ nabyet tɔ́ tɔ gwoo, ye nabɛɛ nyɛ eelik bot ɛ lwoma mɛlyo nɛ ghwyil Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Etɛɛ náá, bhis ɛsyee ɛ lɛ, nyɛ nadidi ɛ é lelyaal bɛ nyel, étɛp bɛ neemyaal náá, nɛ tsɛɛtsɛ nyɛ ɛ́ nɛ tsik. Mɛlu mɛkam-mɛná, nyɛ nadi é lelyaal bɛ nyel, nyɛ nadi é lii nɛ nɔɔ kɔ ɛsu ɛ Ɛyoŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dhiiti dwoo nyɛ nadi é dɛ edee lɔɔg wat bɛ nɛ bɛ nɔɔ, nyɛ eezɛke nɛ nɔɔ náá: «Sa mot ààtseta nɛ ghaada Yeluzalɛm. Bwoodka sa Saag'am nakɛk ɛ, sa mɛ nalɛɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Etɛɛ náá, Zaŋ Nduuel-bot naduu bot Zɛɛb ɛ́ tɔ mɛdii, gɔs ɛ náá, tɔ kil mɛlu mɛ di zyɛ yenek, biyɔ aaduwa Zɛɛb ɛ tɔ Sisim na Dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Deenek, bot ɛ nasɛɛga e di wat bɛ nɛ Yezu ɔ ɛ boozɛdji nyɛ náá: «Ghɛŋ, ye ɛ́ é ɛwala ɛlak ɛ́ wɔ aagomal ɛyoŋ ɛ Yisalaɛl ee?» ");
INSERT INTO bkw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yezu eezɛbɔɔza náá: «Dum nɛ tɛp ɛwala nɛ dwoo ɛlenek ààgwyák biyɔ, etɛɛ náá, Saag'am ɛ nazekoobal yenek nɛ ghwyil ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Yɛ kabɛ biyɔ, bi ɛ́ waabela boo ghwyil esok Sisim na Dɛɛ aasul kɔ lin ɛ bi aadi ɛ́ bɛtyaasɛs bam pɛ Yeluzalɛm, pɛ kyee dik Yude nɛ Samali kɛkum pɛ mɛsik mɛ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bhis Yezu nake deenek ɛ, nyɛ eezɛbyet tɔ́ tɔ gwoo, bɔɔ djas é bee, wɔ gwaa eguud zokazɛdipal nyɛ é mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dáa bɛ nadi gwyák tɔ́ gwoo esok Yezu nadi é byet ɛ, e di tak bot ɛbá nɛ ekaad ee na puu eezɛtuula bɛ, ");
INSERT INTO bkw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bɛ eezɛke nɛ nɔɔ náá: «Bot ɛ Ghalile, étɛp yé bi di gwyɛ é gwyák tɔ gwoo? Yezu yenɔk mot Zɛɛb zedis nyɛ pak'en bin nyɛ tɔ́ tɔ gwoo ɔ, nyɛ aabaazobula ɛ dhatyee bi bee nyɛ é byet enek.» ");
INSERT INTO bkw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bot ɛ lwoma eezɛsik pɛ Yeluzalɛm, dusa pɛ ɛtsok ɛ pyeeb Oliv. Ɛtsok ɛ tak natseta nɛ ghaada ɛ́ tyee pes ɛwala ɛwat é kyeed mɛko. ");
INSERT INTO bkw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Dáa bɛ nakum pɛ Yeluzalɛm ɛ, bɛ eezɛni tɔ dhiiti dhɛŋ nadi pɛ ɛko ɛ́, ye nabɛɛ e di bɛ nadi zyezyɛ nɛ ɛsɛɛga sok ɛ. Ye nabɛɛ Pyɛɛd, Zaŋ, Zak, Andele, Filip nɛ Toma, zɛnɔɔ Bhaatelemi, nɛ Matye, Zak mɔɔ Alfe, Simɔŋ mot di tɔ ɛdhuu ɛ bot ɛ nadi djóoaa eZɛlɔt ɔ, zɛnɔɔ Yudas, mɔɔ Zak. ");
INSERT INTO bkw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɔɔ djas, bɛ nabɛ ɛ nɛ mɛfulu mɛ ɛsesɛɛga é zɛɛga mendjaala bɛ nɛ boa, nɛ Maali nyɛɛg ɛ Yezu, zɛnɔɔ bɔn nyɛɛg ɛ Yezu esok nɛ esok. ");
INSERT INTO bkw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dwoo wat wɔ gwaa bot ɛ nadi dum koŋ nɛ Zɛɛb ɔ zokazɛsɛɛga e di wat, mɛtaŋ mɛ bot ɛ tak nabɛ tyee bot dhet nɛ mɛkam-mɛmbá. Wɔ gwaa Pyɛɛd zɛtiaa tetel kuku ɛbwak ɛ lɔɔ, nyɛ eezɛke náá: ");
INSERT INTO bkw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Bɔn ɛ nyɛɛg bam, ye bɛ ɛ́ yɛ eegoka náá, sa Sisim na Dɛɛ naloolɛɛ tɔ ekwyala e Zɛɛb ɛ sɛɛ. Pɛ tɔ nuub ɛ Dhavid, nyɛ naaloolii dum nɛ Yudas náá. Ye ɛ́ Yudas ɛ nadul bot ɛ nazɛmɛt Yezu ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nyɛ nadi ɛ́ ngɔt tɔ lɔɔg'es bot ɛ lwoma, nyɛ nabɛ ɛ nyɛ eebela yɛ kyee ɛkɛɛ tɔ lwomel bis nalwomaa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Deenek, nɛ epata ee bɛ nadjɛ nyɛ étɛp nyɛ nazekɛ seeb Yezu ɛ, nyɛ naabɔm pyeeb. Nyɛ nabɛɛ nyɛ eeduma si nɛ ɛghet é bɔs, mɔ tii nyɛ, mendja djas pɛ kel. ");
INSERT INTO bkw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bot ɛ Yeluzalɛm djas naagwak tɛp tak, e di tak ɛ bɛ naget pyeeb tak tɔ lii'ɔɔ ɛ “Akɛldama”. Ye kwyɛl ɛlɛɛ ɛ́ “pyeeb ghiya”.» ");
INSERT INTO bkw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«Tinaak, beeka sa di kwyala tɔ mɛkana mɛ mɛdjeeb ɛ: “Ndjaŋ'ɛ goka nɛ ɛlik ɛ́ wum; sa dhiiti mot ààlik tɔ tak.” Ye nabaakwyalel ɛ́ náá: “Da dhiiti mot ɛ zɛdjila nyɛ tɔ mɛsa mɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«É goka nɛ ɛnɔŋaa ɛ, mot ngɔt tɔ sama bot ɛ nadi é gyee mena nɛ bɛ nɔɔ esok mena nadi é kɛka mɛlu djas mena nɛ Ghɛŋ Yezu ɛ: ");
INSERT INTO bkw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kɛkan dwoo Zaŋ naduu nyɛ Zɛɛb ɛ, kɛyaka nɛ dwoo Zɛɛb nadis nyɛ pak'enaka ɛ́. Mot tak aakadi ɛ́ tiaa-sɛs mena bɛ nɔɔ, étɛp kɛbaŋa nɛ bot náá, Yezu naazegom bhis ɛsyee ɛ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tin, bɛ eezɛlyaal bɛ bot ɛbá: Ye nabɛɛ Zozɛf. Dhiiti din ɛ lɛ nabɛɛ Bhaalsabhas, nyɛ nabaadi é djóoaa ɛ́ Justus. Zɛ nɔɔ Mathias. ");
INSERT INTO bkw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Bhii tak bot ɛ nadi dum koŋ nɛ Zɛɛb ɔ zokazɛsɛɛga, bɛ moo tin é djaala náá: «Ghɛŋ, wɔy mot di é gu ebhum elyem e bot ɔ. Lyaala bis mot wɔ tɔ́ tɔ sama bot ɛbá bak ɔ, ");
INSERT INTO bkw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","étɛp nyɛ needi ngɔt tɔ sama bot ɛ lwoma, e di mɛsa ɛ Yudas mot lik bhis tɔ́ e di di egoka nɛ nɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tin, wɔ gwaa bɛ zɛsa dhiiti ɛgwyeeg, ɛgwyeeg ɛ tak ka sɛɛ ɛ́ Mathias. Mathias ɛ boozɛni tɔ sama bot ɛ lwoma kam nɛ ngɔt. ");
INSERT INTO bkw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Dáa dwoo Pɔtekɔt nakakum ɛ́, bot ɛ nadi é dum koŋ nɛ Zɛɛb ɔ nadi ɛ́ é zɛɛga sum wat. ");
INSERT INTO bkw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ka sɛɛka tɔ gwoo ɛ, dhiiti mɛwuŋal dáa ghuu na lyelyel eezɛlwoodal ndjaa djas bɛ nadi tɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Tin, bɛ eezɛbee esonok eezɛtyaa kɔ elo bɔɔ tyee mengel me du. Bhii tak wɔ gwaa ngel tak zokazɛbɛka bɔɔ epes-epes, kyee waa-wat eekɛtyaa kɔ lo mot ngɔɔngɔt. ");
INSERT INTO bkw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bɔɔ djas naalwood nɛ Sisim na Dɛɛ. Bhii tak bɛ moo tin é lii membyak mesis. Dáa Sisim ɛ nadi é djɛ bɛ ghwyil ɛlii ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tin, é ghɛŋ tak, bot ɛ mbyak eYuda nambɛɛ elyem di kɔ mɛl djas di kɔ bɔs ɔ nadi ɛ́ tin kɔ ghaada Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dáa bɛ nagwak ɛtap ɛlenek ɛ, bɔɔ djas zokasum ekaab zɛsɛɛga e di wat. Bɛ moo tin é djoka ɛbuɛpe etɛɛ náá, mot nɛ mot nadi gwak bot ɛ nadi dum koŋ nɛ Zɛɛb ɔ é lii tɔ membyak mɔɔ met. ");
INSERT INTO bkw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bɛ naadyeebadjoka ɛbuɛpe, bɔɔ náá: «Bot ɛ di lii'aak tok bot ɛ dɛl ɛ Ghalile? ");
INSERT INTO bkw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ye sa dáa náá, mot nɛ mot pak'ena gwak sa bɛ di é lii ɛ tɔ dhaad mbyak'ɛ? ");
INSERT INTO bkw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pak'ena wak ye ɛ́ nɛ bot ɛ dus pɛ dɛl ɛ Paltɛs, dɛl ɛ Medɛs, zɛnɔɔ dɛl ɛ Elam. Bɛdhiiti bot dus ɛ pɛ Meezopotami pɛ kyee dik Yude, pɛ dɛl ɛ Kapadɔs, nɛ Pɔŋ pɛ kyee dik Azia, ");
INSERT INTO bkw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","pɛ Filji, nɛ pɛ Panfili zɛnɔɔ pɛ Eziptɛ nɛ é ngwoob ghaada Sylɛn pɛ Libi. Ye nabɛ ɛ nɛ bot ɛ nadus pɛ dɛl ɛ Lɔm ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Bɛdhiiti nabɛɛ bot ɛ mbyak eYuda, bak bɛdhiiti nabɛɛ bot ɛ nazemyaal ɛdjaala Zɛɛb eYuda ɔ, bɛdhiiti tak nabɛ ɛ bot ɛ ghola Klɛt, nɛ bot ɛ dik Alaabi. Bisɔ djas ɛ́ pe gwak pɛ tɔ membyak mis dáa bɛ di lɛɛ embɛɛ nɛ eboo esesɛɛ Zɛɛb di sa ɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bɔɔ djas naadiaadjoka dhaa tyɛ, bɛ moo tin «yoo» ààbɛ nɛ dáa bɛ sa, bɛ moo tin é djinel pak'ɔɔ náá: «Yak tak kwyɛl ɛlɛɛ yé?» ");
INSERT INTO bkw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tin, bɛdhiiti bot nadi é gɔ bɛ, bɔɔ náá: «Elangi e mɛnyok ɛ di sa bɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tin Pyɛɛd eezɛtyaa tetel bɛ nɛ bak bɛdjekel kam nɛ ngɔt, nyɛ moo tin é tuud nɛ mɛdhuu mɛ bot ɛlyelɛpe náá: «Bɔn ɛ nyɛɛg bam eYuda, zɛnɔɔ biyɔ bot ɛ di dwoo'lak mos kɔ Yeluzalɛm ɔ, egoka bi mɛt ɛsuk ɛ sa di é sɛɛ ɛ. Gwakeka ɛnyɔɛpe sa mɛ di kwyɛl ɛlɛɛ bin ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bot bak tok tɔ elangi e mɛnyok dáa bi di gek tɔ elyem bin ɛ, etɛɛ náá, mena dinaaka ɛ́ é ɛwala etɛn nɛ ená yii mɛlem. ");
INSERT INTO bkw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","É di'enek guka náá sa ngoolel-mɛkpa ɛ Zɛɛb Joɛl nalɛɛ ɛ moo zɛsael. Nyɛ nabɛɛ nyɛ eeke náá: ");
INSERT INTO bkw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Zɛɛb naake náá: Tɔ mɛlu mɛ ɛsik, mɛ waadjɛ bot djas Sisim yam. Bɔn bin, bɔn botom nɛ bɔn boa bɛ aadi ɛ́ é ngoolel-mɛkpa ɛ Zɛɛb, mengbaaz ɛ waakan ɛbee etɛp tyee tɔ mɛdhyam tin bɛtɔa-bot ɛ waadjem mɛdhyam. ");
INSERT INTO bkw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tsɛɛtsɛ nɛ tsɛɛtsɛ tɔ mɛlu menek, mɛ waadjɛ Sisim yam nɛ bot ɛ mɛsa mam yii botom nɛ yii boa, bɛ waalii dáa bɛngoolel ɛ mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mɛ waasa esa e mɛbwala pɛ ɛko tɔ gwoo, nɛ endem pɛ si kɔ bɔs: ghiya, du, eguud nɛ eguluk. ");
INSERT INTO bkw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gwyes ɛ waaghomela, ngɔn ɛ waate zooŋ dáa ghiya, ɛsok nɛ, dwoo ɛ Ghɛŋ zyɛ, boo dwoo duma. ");
INSERT INTO bkw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tin mot nɛ mot aadjaala nɛ din ɛ Ghɛŋ ɔ waatsak.” ");
INSERT INTO bkw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Bot ɛ dhaad mbyak Yisalaɛl, gwakeka sa mɛ di elii'aak: Zɛɛb naalyaal bin eghɛŋ dum nɛ mbi mot Yezu mot Nazalɛt, etɛɛ náá, nyɛ naalyaal ghwyil nɛ eghɛŋ bɛ tɔ eboo endem nɛ esesɛɛ é mɛbwala membi nɛ membi, nyɛ nasa ɛ, biyɔ bɛ ɛmet ne gu yɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bi nabɛɛ bii seeb mot tak é mɛmbɔ mɛ bot ɛ di ààgu Zɛɛb ɔ. Bɛ naagó nyɛ mbema é mɛlaaba, etɛp binek djas nasɛɛ dáa Zɛɛb naloozekɛk nɛ ɛlɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tin Zɛɛb nagomal nyɛ bhis ɛsyee, nyɛ naapɛk nyɛ tɔ mezuk mɛ ɛsyee, etɛɛ náá, ye nabɛ ààdjala náá, ɛsyee di nɛ eghɛŋ kɔ lɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Beeka dáa mɛkoozi Dhavid naake kɔ ɛsu ɛ lɛ: “Mɛ nadi é bebee Ghɛŋ sok bhwoob'am, nyɛ é ngwoobam é kaab náá, mɛ zɛkɛpwak nɛ bwoo. ");
INSERT INTO bkw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","É tɛp tak di náá, lyem'am ɛ́ tɔ boo duu, mɛkpa mɛnuubam eelwood nɛ boo mɛmyaala, nyel'am ɛ tɔ boo ɛbwaalel. ");
INSERT INTO bkw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Etɛɛ náá, Ghɛŋ, wɔ tok nɛ ghwyil ɛlik mɛ kɔ dɛl ɛ bot ɛ zegwyɛ ɔ, wɔ tok nɛ ghwyil ɛbet náá, mam mot edɛɛ ɛ Zɛɛb mɛ syep tɔ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wɔ eelyaal mɛ ze di dul bot pɛ tsik ɛ, wɔ ɛ́ pe djɛ mɛ mɛmyaala é mis mɔ.”» ");
INSERT INTO bkw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«Bɔn ɛ nyɛɛg bam, betka mɛ lɛɛ bin popoopwon dum nɛ bhaab'ena Dhavid, nyɛ naagwyɛ, bhii tak nyɛ naadelaa. Ɛvit ɛ lɛ ɛ tak dɔɔ nɛ dwoo pan mos'ak, wak ɛkunaaɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dáa nyɛ nadi náá nyɛ ngoolel-mɛkpa ɛ Zɛɛb ɛ, nɛ dáa Zɛɛb nakɛk nɛ tuwal myoŋ nɛ mɛsoŋ mɛ náá, ngɔt tɔ bɛdha bɛ ɛ́ waadjila kɔ boo mɛkoozi mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dhavid nabɛɛ, nyɛ eegu sa nawaasael ɛ. Tin, ye nabɛɛ nyɛ eelɛɛ bot dum nɛ ɛgom ɛ Mɛsia bis ɛsyee, étɛp tak ɛ́ nyɛ nake náá: “Nyɛ nabɛ ààdhuugela tɔ dɛl ɛ bot ɛ nazegwyɛ ɔ, tin, muuɛ nabɛɛ, ààsyep tɔ ɛvit.” ");
INSERT INTO bkw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Zɛɛb eegomal Yezu mɛ di lii kɔ ɛsu ɛ lɛ'aak bis ɛsyee. Bisɔ djas ɛ bɛtyaasɛs étɛp tak. ");
INSERT INTO bkw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyɛ naadjɛa boo duu pɛ mbɔ eghɛŋ ɛ Ghɛŋ, nyɛ naabela Sisim na Dɛɛ Zɛɛb nakɛk ɛ. Bhii tak nyɛ eelwoodal bis nɛ yɛ: yenek ɛ etɛp ee bi di bee nɛ ɛgwak, mos enek. ");
INSERT INTO bkw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bela náá, Dhavid nyɛ ɛmet nabɛ aabyet tɔ gwoo, tin, ye nabɛɛ nyɛ eeke náá: “Ghɛŋ Zɛɛb naake nɛ Ghɛŋ'am náá: Dha disi pɛ mbɔ eghɛŋ bam. ");
INSERT INTO bkw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mɛ waalwom bot ɛ mɛbhuka mɔ lwoma bhel náá, bɛ zɛɛ dhaa si mɛko mɔ.”» ");
INSERT INTO bkw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«É goka ɛ́ náá, bot ɛ mbyak Yisalaɛl djas gu ɛnyɔɛpe náá: Yezu bi nabem nyɛ é mɛlaaba ɔ, ye ɛ́ nyɛy ɛ, Zɛɛb sa nɛ nɛ mos Ghɛŋ nɛ Mɛsia!» ");
INSERT INTO bkw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bot ɛ nadi e di tak ɔ naadyeebadjoka mbi yenek kɔkɔ mɛkpa. Bɛ boozɛdji Pyɛɛd bɛ nɛ bɛdhiiti bot ɛ lwoma náá: «Mɔn nyɛɛg, bis goka nɛ ɛsa dáa?» ");
INSERT INTO bkw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pyɛɛd zɛbɔɔza nɛ nɔɔ náá: «Mot nɛ mot tɔ len, liigka elyem, da bi ɛ duwa Zɛɛb nɛ din ɛ Yezu Klisto etɛɛ náá, mesyem min neepelaa. Bhii tak bi ɛ waabela ekɛk ɛ Zɛɛb, Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tin, Zɛɛb nakɛk etɛp bak ɛ́ kɔ ɛsu ɛ len, nɛ bɔɔ bin, zɛnɔɔ bot ɛ dii kɔ mɛl mɛ dii ɛtsetaɛpe ɛ, bot djas Ghɛŋ Zɛɛb'ena aadjóo ɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pyɛɛd naalii nɛ nɔɔ bɛtɛ nɛ etɛp, étɛp bɛ neemyaal nɛ étɛp ɛdjɛ bɛ ghwyil. Nyɛ nadi é ke nɛ nɔɔ ɛ náá: «Myaalka tsik étɛp bi ɛmet needi ààkyee é laab bot ɛ di mos'aak, bɛ eezewo ze!» ");
INSERT INTO bkw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ye nabɛɛ, bot ɛbuɛpe tɔ sama yɔɔ naamyaal mɛlyo ɛ Pyɛɛd, wɔ gwaa bɛ zokaduwa Zɛɛb. Dwoo tak, bot ɛkɛsa yɛ aasa bɛmil ɛlɛl naabaazɛbilel kɔ sama bot ɛ nazedum koŋ nɛ Zɛɛb sok ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bɔɔ djas naadiaawazii tɔ ɛgwak ɛ mɛlyo mɛ bot ɛ lwoma nadi lyo bɛ ɛ. Bɛ nadi ɛ́ tɔ boo mɛgwakel pak'ɔɔ, bɛ nadi é dɛ edee ɛ́ e di wat, nɛ ɛdjaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mot nɛ mot nabɛ é kaab Zɛɛb ɛlyelɛpe. Tin dum nɛ bot ɛ lwoma, Zɛɛb nadi sa bɛtɛ nɛ endem e mɛbwala. ");
INSERT INTO bkw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bot ɛ nadi é dum koŋ nɛ Zɛɛb ɔ nadi ɛ́ lyem wat tɔ mɛgwakel. Bɛ nadi é kekaa pak'ɔɔ esa djas bɛ nadi nɛ ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bɛ nadi bebɔmsa esa nɛ ekum bɔɔ. Bhii tak, epata ee bɛ aabela ɛ, bɛ ka kaa ye ɛ́ pak'ɔɔ, é ɛbee ɛkwosak ɛ mot nɛ mot. ");
INSERT INTO bkw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mɛlu djas, nɛ bɛ nadi esɛɛga tɔ kok Ndjaa-ebuwa e Zɛɛb ɛ. Bɛ nadi é dedɛ edee bɔɔ ɛ e di wat tɔ mendjaa mɔɔ, tin bɛ nadi é dɛ ɛ́ nɛ boo mɛmyaala tɔ elyem, ààbɛ nɛ lyem ɛbet. ");
INSERT INTO bkw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bɛ nadi é duwal Zɛɛb tɔ mɛdjeeb, tin, bot nadi kwyɛl bɛ ɛbuɛpe. Tin mɛlu djas, Ghɛŋ nadi bil tɔ ɛdhuu ɛ lɔɔ, bot ɛ nyɛ nadi é tsikɔ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dhiiti dwoo, Pyɛɛd bɛ nɛ Zaŋ zokazɛbyet pɛ kok Ndjaa-ebuwa étɛp ɛkɛdjaala, ye nabɛɛ é ɛwala elɛl yii bikoko. ");
INSERT INTO bkw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","É ngwoob ɛniel ɛ di djóoaa «ɛbɛ ɛ ndjaa na nyɔɔnyɔ ɛ», e di tak ye nabɛɛ nɛ dhiiti mot boka kana edhɔma bɛ. Mɛlu djas bot nadi eghɛɛ nyɛ, zɛmak nyɛ tin, étɛp nyɛ neezɛwaab epata pɛ dáa bot ɛ nadi é zyɛ pɛ kok Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dáa nyɛ nabee Pyɛɛd bɛ nɛ Zaŋ é kwyɛl ɛni tɔ kok Ndjaa-ebuwa ɛ, nyɛ eezɛwaab bɛ epata. ");
INSERT INTO bkw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","É di'enek, Pyɛɛd bɛ nɛ Zaŋ zɛgwyák nyɛ «kpɛɛɛ», bhii tak Pyɛɛd eezɛke nɛ nɛ náá: «Gwyáka bis.» ");
INSERT INTO bkw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tin mot'enɔk eezɛgwyák bɛ «kpɛɛɛ», etɛɛ náá, tɔ lyemɛ, nyɛ nadi é gek ɛ náá, bɛ waadjɛ nyɛ sonok. ");
INSERT INTO bkw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","É di'enek, Pyɛɛd ɛ booke nɛ nɛ náá: «Mɛ tok nɛ epata, ààkobɛ nɛ lɔaad, sa mɛ di nɛ ye ɛ́, mɛ pe djɛ wɔ: nɛ din ɛ Yezu Klisto mot Nazalɛt, wyɛla da wɔ ɛ́ kɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bhii tak nyɛ eezɛmet nyɛ pɛ mbɔ e ghɛŋ, nyɛ eezɛkyee nyɛ é ɛwyɛl. E di tak wat, mɛko nɛ mɛtii mɛ mɛko mɛ mot'enɔk eezɛlyel. ");
INSERT INTO bkw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Vasaka, e di tak wat, nyɛ eezɛtyaa tetel, nyɛ moo tin é kɛɛnek, bhii tak nyɛ eezɛni lɔɔg wat bɛ nɛ bot ɛ lwoma pɛ tɔ kok Ndjaa-ebuwa, nyɛy é kɛnɛ mɛko mɛ, é tsel nɛ ɛduwal ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bot djas nadi tin ɔ naabee nyɛ é kɛnɛ ɛduwal ɛ Zɛɛb tɔ mɛdjeeb. ");
INSERT INTO bkw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dáa bɛ nagwyák náá, ye nabɛɛ mot nadyeebadidi ndiindel é «ɛbɛ ɛ ndjaa na nyɔɔnyɔ» yii kok Ndjaa-ebuwa étɛp ɛwaab epata ɔ, tin bɔɔ djas naabela bɛbebwol nɛ ɛdjoka ɛbuɛpe dum nɛ sa nasɛɛ nɛ boka mot'enɔk ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dáa mot'enɔk nanaata Pyɛɛd nɛ Zaŋ ɛ, bot djas tɔ ɛdjoka bɛ nadi é djoka ɛ. Wɔ gwaa bɛ zokazyɛ kaab pɛ pak bɛ nadi ɛ, ye nabɛɛ di mɛbhaaz mɛ nadi é djóoaa «mɛbhaaz ɛ Salomɔŋ» ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dáa Pyɛɛd nabee deenek ɛ, nyɛ ɛ́ booke nɛ ɛdu ɛ́ bot binɔk náá: «Bɔn ɛ nyɛɛg bam bot ɛ Yisalaɛl, étɛp yé bi di djoka tsik mot tak tsak ɛ deenek? É tɛp yé bi di gwyák tyee náá, bis tsik mot tak ɛ́ nɛ ghwyiles met nɛghu etɛɛ náá, bis ɛpesa zii étɛp ɛdu ɛ Zɛɛb? Ye tok deenek! ");
INSERT INTO bkw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ye ɛ́ Zɛɛb ɛ Abalaam, Zɛɛb ɛ Izak nɛ Zakɔɔb, Zɛɛb bɛbhaab binaka eelyaal duu mot-mɛsa mɛ, Yezu. Biyɔ bɛ ɛmet bi naseeb nyɛ é mɛmbɔ mɛ ekukuma, nɛ swonal nyɛ é mis mɛ Pilat, ka bela náá, Pilat naakwyɛl ɛbet nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Biyɔ bi naabyen mot na dɛɛ, na epiki, biyɔ nakwyɛl ɛ náá, Pilat bet mot di é gó bot ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Deenek, bi naagó mot di nakuma tsik ɔ. Tin, bhis etɛp binek djas, Zɛɛb naagomal nyɛ tɔ ɛsyee, bis ɛ́ bɛtyaasɛs étɛp tak. ");
INSERT INTO bkw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ye ɛ́ kɔ ɛsu ɛ mɛbwala mɛ din ɛ Yezu, dum nɛ ɛdum ɛ koŋ nɛ nɛ ɛ bulal ghwyil mot bi di bee nɛ ɛgu'aak. Ye ɛ́ ɛdum ɛ koŋ nɛ Yezu ɛ sa náá, nyɛ bela tsik nyel djas bi di é bee'enek. ");
INSERT INTO bkw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Bela náá, bɔn nyɛɛg bam, mɛ nɛ gu ɛnyɔɛpe náá, biyɔ nɛ ekukuma bin nasa deenek ɛ́, etɛɛ náá, bi ɛ tɔ boo ɛdjak dum nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ye ɛ́ deenek ɛ Zɛɛb kwyɛl ɛlyaal ɛsuk ɛ etɛp ee nyɛ naloolɛɛ tɔ enuub e bɛngoolel ɛ mɛkpa ɛ Zɛɛb djas ɛ. Nyɛ nabɛɛ nyɛ eelɛɛ náá, Mɛsia mɛ ɛ́ waazuk. ");
INSERT INTO bkw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Swoolaka mɛfulu min, da bi ɛ dum koŋ nɛ Zɛɛb etɛɛ náá, nyɛ needis mesyem min. ");
INSERT INTO bkw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Deenek bhii tak, Ghɛŋ ɛ waazɛdjɛ bin ɛwala ɛ bi aawala ɛ. Tin, bi ɛ waabee Mɛsia nyɛ naloozetɔ́ kɔ ɛsu ɛ len ɛ: Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nenak yak, é gokaa náá, Yezu pookodi pɛ ɛko kɛkum mɛlu mɛ yɛ aadi náá, esonok djas ɛ waabula bes dáa Zɛɛb naloozelɛɛ tɔ enuub e bɛngoolel ɛ mɛkpa mɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ye nabɛɛ Moiiz naake náá: “Ghɛŋ Zɛɛben waadhis bin ngoolel-mɛkpa ɛ Zɛɛb dáa mam. Nyɛ aadi ɛ́ mot dhaad mbyak en, da bi ɛ́ gwak etɛp ee nyɛ aalɛɛ bin ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mot djas aadi ààgwak etɛp ee ngoolel-mɛkpa ɛ Zɛɛb tak ɔ, nyɛ waasɔaa tɔ sama bot ɛ mbyak, bhii tak nyɛ waagóaa.” ");
INSERT INTO bkw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Tɔ bɛngoolel ɛ mɛkpa ɛ Zɛɛb djas, kana Samyɛl, kɛyaka nɛ bot ɛ nakazyɛ bhis koŋɛ ɔ, ye nabɛɛ bɛ naalii nɛ nen dum nɛ mɛlu mak. ");
INSERT INTO bkw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Etɛp ee Zɛɛb nakɛk bin tɔ nuub bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɛ nabɛɛ yibɔ. Bi ɛ́ nɛ yebɔ di tɔ ɛbhɛŋ ɛ Zɛɛb nakwyala bɛ nɛ bɛbhaab bin. Nyɛ naake nɛ Abalaam náá: “Mɛ waasɛɛ mɛbyel djas kɔ bɔs djas mɛtel kɔ lo ɛ bɛdha bɔ.” ");
INSERT INTO bkw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","É tɛp tak ɛ di náá, Zɛɛb napoo lee ɛdhis mot-mɛsa mɛ sok ɛ kɔ ɛsu ɛ len, nyɛ napoo lee dhis nyɛ étɛp nyɛ neezɛsɛɛ bin mɛtel, nɛ ɛsa náá, mot neeliig koŋ nɛ embee mɛfulu mɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Bela tin náá, Pyɛɛd nɛ Zaŋ nadi é lii nɛ zukamwaa nɛ mot nadi tin ɔ. Wɔ gwaa bɛghaa-Zɛɛb, ekukuma bɛbaalel ɛ kok Ndjaa-ebuwa, zɛnɔɔ bot ɛ ɛdhuu ɛ eSaduseɛ zokazyɛ pɛ kyee bɛ nadi ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Elyem naadyeebakpaa bɛ etɛɛ náá, bɛ nàbɛ ààkwyɛl náá, Pyɛɛd nɛ Zaŋ Bot ɛ Lwoma bɛbá gheelelyo bot tɔ mɛlyo mɔɔ náá, Yezu Klisto mot nagwyɛ ɔ eezegom. Bɛ nadi sa deenek ɛ etɛɛ náá, bɛ nadi eke ɛ náá, bot ɛ zegwyɛ ɔ nɛ ghwyil ɛgom bhis ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tin bɛ boo zɛmet Pyɛɛd nɛ Zaŋ zɛwa bɛ embok. Wɔ gwaa bɛ zokazɛdjɛk bɛ tin kɛkum mɛlem etɛɛ náá, bɛ namet bɛ ɛ́ bikoko. ");
INSERT INTO bkw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bela náá, bɛtɛ nɛ bot ɛ nagwak mɛkpa mɛ bot ɛ lwoma ɔ, ye nabɛɛ bɛ eedum koŋ nɛ nɛ. Mɛtaŋ mɛ bot ɛ tak nabilel, kum tyee bot bɛmil ɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Yii myɛn tak, ekukuma eYuda, bɛpaa, zɛnɔɔ bɛghaŋ ɛ mɛkana mɛ etsi, zokazɛsɛɛga pɛ dɛl ɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bot ɛ nadi tɔ zɛɛga tak ɔ nabɛ ɛ Andele, Anas boo ghaa-Zɛɛb, Kayif, Zaŋ, Alɛkzandɛlɛ zɛnɔɔ bot ɛ mɛbyel ɛ boo ghaa-Zɛɛb djas. ");
INSERT INTO bkw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bɛ eezɛtel bɛ metetel sok bhwoob'ɔ, tin, bɛ eezɛdji bɛ náá: «Bi sa esesɛɛ bak nɛ yaa mɛbwala, nɛ din ɛ zɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tin, Pyɛɛd eezelwood nɛ Sisim na Dɛɛ, nyɛ booke nɛ nɔɔ náá: «Ekukuma e dhaad mbyak nɛ bɛpaa eYuda: ");
INSERT INTO bkw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Bɛ dji bis mɛdjin mak mos ɛ, étɛp enɛm esa ee bis sa nɛ boka mot ɛ. Bɛ dji bis ɛ náá, mot'ak tsak dáa? ");
INSERT INTO bkw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ɛnyɔɛpe, ye goka ɛ́ bi gu náá, biyɔ djas, dɔɔ nɛ bot ɛ Yisalaɛl, yɛ bɛ náá, mot'ak eetyaa tetel nɛ nyel ɛnyɔɛpe é mis men ɔ, ye ɛ́ nɛ ghwyil din ɛ Yezu Klisto mot Nazalɛt, mot bi nabem é mɛlaaba, da Zɛɛb ɛ gomal nyɛ bhis ɛsyee ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yezu mot Ekwyala e Zɛɛb di lɛɛ tsɛɛtsɛ náá: “Ɛkok ee bɛzumel mwas ɛ, moo ɛ́ ɛkok di epyet ndjaŋ ɛ.”» ");
INSERT INTO bkw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«Tsik belaa ɛ́, tɔ din ɛ Yezu Klisto nyɛ ɛmet. Dhiiti mot Zɛɛb nadhis kɔ bɔs'ak náá, nyɛ neetsik mena ɔ, tok.» ");
INSERT INTO bkw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dáa bɛ nabee eghɛŋ ɛ Pyɛɛd nɛ Zaŋ ɛ, bot ɛ zɛɛga boo kwan eYuda naadjoka. Bɛ naadjoka etɛɛ náá, ye bɛ ɛ́ bɛ eesiiza náá, bɛ nabɛɛ mbi vaŋ bot ɛ nadi ààtɔ́ mɛdjek ɔ. Bɛ nadi gu náá, bɛ nadi gyee sama wat nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tin, bɛ nadi é bee mot natsak ɛ tetel é ngwoob ɔ, bɛ nàbɛ ààkabɛ nɛ ɛkpa ɛ ɛyala. ");
INSERT INTO bkw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bɛ eezɛke nɛ nɔɔ náá, bɛ wyis tɔ ndjaa epɛ́ɛ. Bɛ moo tin é sɔs pak'ɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bɛ nadi keke ɛ náá: «Mena aasaka nɛ bot bak dáa? Etɛɛ náá, bot dɛl ɛ Yeluzalɛm djas nɛ gu pupwoopwon náá, ndem mɛbwala mak sael ɛ nɛ nɔɔ, mena tok nɛ ghwyil ɛswonal. ");
INSERT INTO bkw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tin, yɛ ààgoka náá, menduk mɛ tɛp'ak gek tɔ mɛlɔ mɛ bot bak djas. Mena ɛ waalyak bɛ nɛ mɛbhɛma náá, bɛ nàbaalii nɛ bot kɔ ɛsu ɛ din ɛ Yezu.» ");
INSERT INTO bkw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bɛ eezɛdjóo bɛ, bhii tak bɛ eezɛlyak bɛ ɛlyelɛpe náá, bɛ nàbaalii nɛghu ɛlyo ɛ bot nɛ din ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tin, Pyɛɛd nɛ Zaŋ eezɛbɔɔza nɛ nɔɔ náá: «Pɛɛka biyɔ bɛ ɛmet nɛghu ye ɛ́ ɛnyɔɛpe é mis mɛ Zɛɛb náá, bɛ looba nɛ nen nɛghu bɛ looba nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yɛka bɛ bisɔ ɔ, bis tok nɛ ghwyil ɛ byen ɛlii dum nɛ sa bis nabee nɛ mis nɛ ɛgwak nɛ mɛlɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bot ɛ boo kwan eebaazɛbhɛm bɛ, bhii tak bɛ eezɛbet bɛ. Bɛ nàbaabɛ nɛ tyɛ bɛ aazuk bɛ, etɛɛ náá, ɛdhuu ɛ bot djas nadi duwal Zɛɛb kɔ ɛsu ɛ etɛp ee nasael ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mot natsak nɛ mɛbwala ɛ Zɛɛb ɔ nabɛ ɛ nɛ membu mɛkam-mɛná kɛdhaa. ");
INSERT INTO bkw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Dáa bɛ nabet bɛ ɛ́, Pyɛɛd bɛ nɛ Zaŋ eezɛtɔ́ pɛ pak ɛdhuu ɛ bɛsɔ bɔɔ nadi ɛ. Bɛ moo tin é baŋa bɛ etɛp djas eboo bɛghaa-Zɛɛb nɛ bɛpaa eYuda nalɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bhis bɛ nazegwak etɛp binek djas ɛ, bɔɔ djas eezɛgwakel, tin, bɛ eezɛdjaala Zɛɛb náá: «Zɛɛb Mɛkaake, ye ɛ́ wɔy ɛ nakus gwoo nɛ bɔs, nɛ boo dii mɛsɔn zɛnɔɔ esonok djas di tɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ye ɛ́ wɔy ɛ di náá, nɛ ghwyil Sisim na Dɛɛ wɔ naasa náá, Dhavid bhaabes mot-mɛsa mɔ naake náá: “Bhwak ɛ pe kuu, ye ɛ́ étɛp ye? Bot ɛ membyak ɛpedi bhoob yii toto. ");
INSERT INTO bkw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bɛmɛkoozi mɛ bɔs eezekomsa étɛp ɛkɛ lumla dɛɛb, eboo ekukuma eezesɛɛga. Bɛ sɛɛga ɛ bɛ neekɛ lumla dɛɛb nɛ Ghɛŋ nɛ mɛkoozi mɛ nyɛ nadjɛ ebotan ɔ.” ");
INSERT INTO bkw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ye ɛ́ tsɛɛtsɛ náá, Elood nɛ Pɔɔs Pilat eezesɛɛga kɔ dɛl ɛ ɛlak bɛ nɛ ekukuma e membyak mesis, zɛnɔɔ bot ɛ Yisalaɛl bɛ neegena nɛ mot-mɛsa mɔ na Dɛɛ Yezu, mot wɔ nazedjɛ ebotan ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tin, bee sa esonok djas wɔ naloogek nɛ ɛkwosak ɛ lɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","É di'enek, Ghɛŋ, bɛɛa mis kɔ mɛbhɛma mɔɔ, tin da wɔ ɛ́ djɛ bot ɛ mɛsa mɔ ze ɛgoola mɛkpa mɔ, nɛ boo ɛbwaalel. ");
INSERT INTO bkw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sɛɛba mbɔ ɔ, etɛɛ náá, bot neetsak, endem e mɛbwala neesɛɛ nɛ din ɛ mot-mɛsa mɔ na Dɛɛ Yezu.» ");
INSERT INTO bkw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dáa bɛ nasilal ɛdjaala ɛ, di bɛ nasɛɛga ɔ zokazɛkuu, wɔ gwaa Sisim na Dɛɛ zokalwood tɔ lɔɔ. Bhii tak bɛ eezɛni é goola mɛkpa mɛ Zɛɛb nɛ ɛbwaalel djas. ");
INSERT INTO bkw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɛdhuu ɛ bot djas nadi dum koŋ nɛ Zɛɛb ɔ, nadi ɛ́ tɔ ɛgwakel ɛnyɔɛpe, tɔ elyem nɛ esisim. É tok nɛ mot ngɔt pak'ɔɔ nadi é ke náá, esa bɛ ɛ yii nyɛy nyɛ ɛmet. Esa ee bɛ nadi nɛ ye ɛ́ nabɛ ɛ yii bɔɔ djas. ");
INSERT INTO bkw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ye ɛ́ nɛ boo mɛbwala ɛ bot ɛ lwoma nadi é lɛɛ bot dáa Ghɛŋ Yezu nagom, tin, Zɛɛb nadjɛ bɔɔ djas bɛtɛ nɛ enɛm nɛ embɛɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ye tok nɛ mot ngɔt pak'ɔɔ, nasu sa mot di egoka nɛ ɛdi nɛ yɛ étɛp tsik'ɛ ɛ. Deenek, bot ɛ nadi nɛ epyeeb nɛghu mendjaŋ ɔ nadi bɔmsa yɛ, ");
INSERT INTO bkw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","bhii tak da bɛ ɛ́ zyɛ nɛ epata ee bɛ bela ɛ, zɛdjɛ bot ɛ lwoma. Bhii tak, bɛ ka kaa epata e tak ɛ nɛ mot nɛ mot é ɛbee ɛkwosak ɛ mot di nɛ ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Djhoogek nyɛ nɛ Zozɛf mot di Lɛvit ɔ mot ghola Siipɛlɛ, mot bot ɛ lwoma naget din ɛ Bhaalnabhas ɔ. Din ɛ tak kwyɛl ɛlɛɛ ɛ: «Mot di djɛ ghwyil nɛ mɛghaaz ɔ». ");
INSERT INTO bkw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nyɛ naabɔmsa pyeebɛ, bhii tak nyɛ eezɛnɔɔ epata, zɛdjɛ bot ɛ lwoma. ");
INSERT INTO bkw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tin, dhiiti motom din ɛ lɛ nabɛ ɛ Ananias, din ɛ myɛl nabɛɛ Safiida, naazɛgwakel étɛp ɛbɔmsa bɛɛdok nadi yɔ bɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nyɛ eezɛnɔɔ kyee pata wat syel, yak kyee nyɛ boo kɛdjɛ bot ɛ lwoma. Myɛl nadi é gu. ");
INSERT INTO bkw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tin, Pyɛɛd eezɛkɛ nɛ nɛ náá: «Ananias étɛp ye Satan zeni wɔ tɔ lyem deenek? Wóó kɔɔ Sisim na Dɛɛ, wóó syel kyee pata wat ee wɔ bɔmsa bɛɛdokɔ étɛp'ɔ met. ");
INSERT INTO bkw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ɛsok nɛ wɔ nɛ bɔmsa yɛ, ye nadi ɛ́ yɔ. Bhii wɔ kazebɔmsa yɛ ɛ, epata bɛ ɛ́ yɔ, etsal e? Ha étɛp ye wɔ sa mbi yenek esesɛɛ? Wɔ ààpakɔɔ bot, wɔ kɔɔ ɛ́ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Gwaka nyɛ nagwak mɛkpa menek ɛ, Ananias eezɛduma si é bɔs, nyɛ eezɛgwyɛ. Tin bwoo naazɛmɛt bot djas nagwak menduk mɛ tɛp tak ɔ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mengbaaz ɛ boo zɛpil muuɛ tɔ bheeza, bhii tak bɛ eezɛtɔ́ nɛ muuɛ kɛdel. ");
INSERT INTO bkw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ba mɛwala mɛlɛl nadhaa bhii tak, mwaa Ananias zɛkum, ààgu sa sɛɛ sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pyɛɛd eezɛdji nyɛ náá: «Lɛɛa mɛ, ye bɛ ɛ́ bii bɔmsa bɛɛdoken nɛ mɛtaŋ mak ɔ?» Nyɛ eezɛbɔɔza: «Hɛɛɛ yɛ nɛ mɛtaŋ menek ɛ bis bɔmsa yɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","É di'enek, Pyɛɛd ɛ boo ke náá: «Bi sa dáa étɛp bi neegwakel étɛp ɛbowal Sisim ɛ Ghɛŋ? Gwyáka, bot ɛ kɛdel ngomɔ ɔ moo ɛ́ é ɛbɛ ɛ ndjaa, bɛ waabaabɛp muuɔ tɔ́ nɛ yɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","E di tak wat, nyɛ zɛghaaga si, si mɛko mɛ bot ɛ lwoma, nyɛ eezɛgwyɛ. Mengbaaz mɛ nadus ndela ɔ eezɛkum, bɛ ka bela nyɛ ɛ́ muu. Tin, bɛ eezɛghɛɛ nyɛ, bɛ eezɛtɔ́ kɛdel nyɛ é ngwoob di bɛ nadel ngom ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bot ɛ zɛɛga mendjaala djas nɛ bot ɛ nagwak menduk mɛ tak ɔ, naabela boo bwoo. ");
INSERT INTO bkw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bɛtɛɛ nɛ endem e mɛbwala nadi sɛɛ tɔ mɛdhuu mɛ bot dum nɛ bot ɛ lwoma. Bot djas nadi dum koŋ nɛ Ghɛŋ ɔ zokasɛɛga pɛ tɔ bhaaz ɛ Salomɔŋ di tɔ ɛbɛsɛɛ Ndjaa-ebuwa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bot ɛbuɛpe nàbɛ ààkadjheebal ɛkɛ é lɔɔg'ɔ, ye nakoozodi náá, bot nadi kwyɛl bɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Botom nɛ boa aluu naaluu nadi dum koŋ nɛ Ghɛŋ ɔ naazɛni tɔ lɔɔg'ɔ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tin bot zokakɛghɛɛ membel zɛnenɛɛg bɛ é ngwoob egba, kɔ emwaala nɛ kɔ bhum. Bɛ nasa deenek ɛ etɛɛ náá, esok Pyɛɛd aadhaŋ ɛ, sisim yɛ neegheebutal bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bɛdhiiti mɛdhuu mɛ bot naazɛdus pɛ mɛl mɛ nadi é mengwoob mɛ Yeluzalɛm ɛ. Bɔɔ zokazyɛ nɛ membel nɛ bot ɛ embee esisim nadi dhedhek ɔ. Bɔɔ djas zokatsak. ");
INSERT INTO bkw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dáa bɛ nabee edjema binek ɛ, boo ghaa-Zɛɛb nɛ bot ɛ lɔɔg'ɛ, bot ɛ tak nabɛ ɛ bot ɛ zɛɛga eSaduseɛ, wɔ gwaa bɛ zokazɛkpaa elyem ɛbuɛpe dum nɛ bot ɛ lwoma binɔk. Bɛ boozɛke náá: «Egoka ɛ, mena lyak ka tɛp'ak.» ");
INSERT INTO bkw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bɛ eezɛmɛt bot ɛ lwoma, bhii tak bɛ eezɛkɔɔl bɛ é membok. ");
INSERT INTO bkw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Tin, é pum, wɔ gwaa fofop ɛ Ghɛŋ zokazɛdii ɛbɛ ɛ ndjaa membok, bhii tak nyɛ eezɛwyisal bot ɛ lwoma, nyɛ eezɛke nɛ nɔɔ náá: ");
INSERT INTO bkw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Tɔ́ka pɛ tɔ kok Ndjaa-ebuwa, lɛɛka bot etɛp djas di dum nɛ tsik na bes ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bot ɛ lwoma eezɛgwak fofop tak. Tɔ ghooghom mɛlem bɛ eezɛtɔ́ pɛ kok Ndjaa-ebuwa, tin, bɛ zɛni é lyo bot mɛlyo mɔɔ. Boo ghaa-Zɛɛb, nɛ bot ɛ lɔɔg'ɛ ɛ boo zɛsɛɛg bɛpaa ɛ dhaad mbyak eYuda étɛp bɛ neeboma é boo kwan. É di'enek, bɛ zɛlwom bɛbaalel bɛ kɛ ɛnɔɔ bot ɛ lwoma pɛ ndjaa membok. ");
INSERT INTO bkw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Tin dáa bɛbaalel tak nakakum ɛ, bɛ ààpakabela bɛ tɔ dhɛŋ tak. É di'enek, bɛ eezɛsik pɛ boo kwan, bee kɛlɛɛ bɛ náá: ");
INSERT INTO bkw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Bis bela ɛ ndjaa membok ndiila ɛnyɔɛpe, bɛbaalel tin, é e di bɔɔ, é mɛbɛ ɛ ndjaa. Tin, kadi ɛ, bis ààpabee mot tin tɔ tak.» ");
INSERT INTO bkw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dáa bɛ nagwak deenek ɛ, kukuma bɛbaalel ɛ kok ndjaa-ebuwa nɛ eboo bɛghaa-Zɛɛb ɔ naadhaa bɛ ghwyil, bɛ moo tin é sɔs dum nɛ sa sɛɛ nɛ bot ɛ lwoma ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","É di'enek, dhiiti mot eezɛtuula, nyɛ eezɛlɛɛ bɛ náá: «Gwakeka! Bot ɛ bi nakɔɔl é membok ɛ pɛ tɔ kok Ndjaa-ebuwa é lyo bot mɛlyo mɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bhii tak, kukuma bɛbaalel eezɛtɔ́ bɛ nɛ bot, étɛp bɛ neekɛnɔɔ bot ɛ lwoma bula nɛ nɔɔ. Tin bɛ nalii nɛ nɔɔ mɛdjɛmɛdjɛ ààbɛ nɛ bel é kaab naabot dɛl ɛzɛkɛwus bɛ nɛ mɛkok. ");
INSERT INTO bkw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bhis bɛ naka bula nɛ nɔɔ ɛ, bɛ eezɛpɛɛ bɛ sok bhwoob boo kwan eYuda. Tin, boo ghaa-Zɛɛb moo tin é til bɛ nɛ ɛdjɛ bɛ tɛp. ");
INSERT INTO bkw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Nyɛ eezɛke nɛ nɔɔ náá: «Bis di ɛ bis eezelu bin ɛlyelɛpe náá, bi nàbaalyo bot dum nɛ din ɛ mot'enɔk. Ghuna bhis batasa náá mɛlyo men kɛdjala kɔ ghaada Yeluzalɛm djas. Bi kwyɛl ɛ ɛsaa náá, embee ebaka ɛsyee ɛ mot tak kwyɛ kɔ elo bis?» ");
INSERT INTO bkw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pyɛɛd bɛ nɛ bɛdhiiti bot ɛ lwoma ɛ zɛbɔɔza náá: «Egokaa nɛ ɛgwakaa zɛ, bot ohoo Zɛɛb? ");
INSERT INTO bkw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Zɛɛb bɛbhaab binaka eegomal Yezu bi nagó nyɛ bema kɔ mɛlaaba ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Zɛɛb eetel nyɛ tetel pɛ mbɔ eghɛŋ bɛ, nyɛ eedjɛ nyɛ dék étɛp mɛkoozi nɛ Tsika-bot. Nyɛ nasa deenek ɛ, étɛp ɛdjɛ bot ɛ mbyak Yisalaɛl ɛpɛɛd étɛp bɛ neeswoola mɛfulu mɔɔ, bɛ neebela ɛpelak ɛ mesyem mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bis ɛ́ bɛtyaasɛs etɛp binek djas. Bisɔ nɛ Sisim na Dɛɛ Zɛɛb nadjɛ bot ɛ di gwak nyɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wɔ gwaa ɛbuk baazɛsa bot ɛ boo kwan eYuda ɛbuɛpe bhis bɛ nazegwak mɛkpa menek ɛ. Tin, gwyes ɛgó ɛ bot ɛ lwoma nasa bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bela náá, tɔ ɛdhuu ɛ lɔɔ ye nabɛɛ nɛ dhiiti Falizyɛ din ɛ lɛ nabɛɛ Ghamalyɛl, nyɛ nadi ɛ́ ghaa mɛkana mɛ etsi ɛ Moiiz, bot nadi duwal nyɛ ɛbuɛpe. Wɔ gwaa nyɛ zɛwyɛl tyaa tetel kuku ɛbwak ɛ zɛɛga bot ɛ boo kwan, nyɛ eezɛke náá bɛ wyisal bot ɛ lwoma pɛ kel ba mɔɔ pes ɛwala. ");
INSERT INTO bkw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bhii tak nyɛ eezɛke nɛ bot ɛ kwan náá: «Bot ɛ Yisalaɛl, bi ɛ́ kobaka nɛ sa bi aasa nɛ bot bak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ye dinaa ààpaakobɔya, wak koko ɛ koko ye nabɛ ɛ Tedas natuula náá, nyɛy ɛ yɛ kuma mot. Ye nabɛɛ botom tyee mɛtaŋ bɛdhet ɛ nànaadu nyɛ. Bela naanyɛ naagóaa, bhii tak, bot ɛ nadu nyɛ ɔ naawyɛɛza bɔɔ djas, tin zɛɛga tak naazɛgwyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bhis nyɛy, esok ɛlɛɛga ɛ mɛtaŋ mɛ bot, Yudas mot Ghalile naazɛsɛɛg zukaa mwaa nɛ mot naadu nyɛ. Tin, nyɛ naabaagóaa yɛ pe, é di'enek bot djas nadu nyɛ ɔ naazɛwyɛɛza gwyiiŋ. ");
INSERT INTO bkw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nenak mɛ ka lɛɛ bin ɛ náá, sa mot ààka baabis bɛ. Betka bɛ, bɛ tɔ́, etɛɛ náá, yɛ bɛ náá, ɛsuk ɛ egwyes bɔɔ nɛghu mɛsa mɔɔ dus ɛ nɛ bɔɔ bɛ ɛmet ɔ, yɛ waasi. ");
INSERT INTO bkw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nɛghu Zɛɛb ɛ di ɛsuk ɛ tak nɛ tsɛɛtsɛ ɔ, bi tok nɛ ghwyil ɛ lyak yɛ. Nà gheeg ka mɛnyel étɛp ɛbowal ɛ Zɛɛb.» Tin, bot boo kwan eezɛmyaal etɛp ee Ghamalyɛl nalɛɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tin, bɛ boo zɛbaazɛdjóo bot ɛ lwoma, bɛ eezɛnyuu bɛ nɛ eghwyɛs. Bhii tak bɛ eezɛlyak bɛ náá bɛ nàbaalyo bot dum nɛ din ɛ Yezu, tin bɛ eezɛbet bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bot ɛ lwoma eezɛdus e di kwan ɛ́ yenek, nɛ mɛmyaala etɛɛ náá, Zɛɛb eebee náá, bɛ ɛ́ bot di egoka nɛ zukaa kɔ ɛsu ɛ din ɛ Yezu ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tin mɛlu djas tɔ kok Ndjaa-ebuwa nɛ mendjaa nɛ mendjaa, bot ɛ lwoma nadi tɔ́ nɛ ɛ goola Mbɛɛ bhaadal ɛ Yezu Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Eghɛŋ tak, bela náá, mɛtaŋ mɛ bɛdjekel nabɛɛ yɛ eebaazebilel ɛbuɛpe. Eyuda ee di lii, lii eGhɛlɛk ɔ nabɛɛ be taŋal dum nɛ bot ɛ nadi elii ebhele ɔ. Bɛ nadi eke ɛ náá, yɔ bɔ bɛkus ɛ boa nàbɛ ààdi kwyɛɛgaa mɛlu djas é ghɛŋ bɛ nadi kekaa edee ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Bot ɛ lwoma kam nɛ bɛbá boo zɛsɛɛg bɛdjekel djas, bɛ ɛ́ boozɛke nɛ nɔɔ náá: «Yɛ ààgoka náá, bis bet ɛgoola mɛkpa mɛ Zɛɛb, étɛp ɛkɛ kaa edee. ");
INSERT INTO bkw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Deenek, bɔn nyɛɛg, sɛɛka pak'en bot ɛtɛn nɛ bɛbá di sosoob nɛ epiki ɛ, bot ɛ di, “tɔɔɔ” ne Sisim na Dɛɛ nɛ etsoŋ ɔ. Da mena ɛ djɛ bɛ mɛsa mɛ tak. ");
INSERT INTO bkw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tinaak, bis ɔ aakadi ɛ́ é sa mɛsa mɛ mendjaala nɛ ɛgoola Mbɛɛ Bhaadal.» ");
INSERT INTO bkw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bot ɛ zɛɛga djas naamyaal egeka e tak. É di'enek, bɛ ɛ́ boo zɛsɛɛ Etiɛn mot nadi nɛ boo ɛdum koŋ ɛbuɛpe nɛ Zɛɛb zɛnɔɔ Sisim na Dɛɛ ɔ. Ye nabɛ nɛ Filip, Polokɔɔd nɛ Nikanɔɔd, Timɔn, Palmenas, nɛ Nikolas mot dɛl ɛ Antiɔs, mot namyaal ɛdjaala Zɛɛb eYuda ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bhii tak bɛ eezɛlyaal bɛ nɛ bot ɛ lwoma, tin bɛ eezɛdjaala Zɛɛb nɛ ɛkɛl ɛ bɛ mɛbɔ. ");
INSERT INTO bkw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tin, mɛkpa mɛ Zɛɛb nadi goolel ɛbuɛpe. Mɛtaŋ mɛ bɛdjekel nadi bilel, ɛbilel nɛ ɛbilel pɛ Yeluzalɛm. Deenek, bɛtɛ nɛ bɛghaa-Zɛɛb nadi dum ekoŋ nɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiɛn tɔɔ nɛ ghwyil enɛm nɛ embɛɛ é Zɛɛb, nɛ mɛbwala, nyɛ naadi esa bɛtɛ nɛ endem e mɛbwala ɛbuɛpe tɔ bot ɛ mbyak. ");
INSERT INTO bkw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tin bɛdhiiti bot ɛ ndjaa mendjaala mɛ eYuda zokazɛbyen lek'ɛ. Bot ɛ tak nabɛ ɛ́ kyee wat bot mɔɔ ndjaa mendjaala nadi djóoaa «ekwom pɛka» ye nabɛɛ eYuda e kyee dik Silɛn nɛ Alɛkzandili, yak kyee eYuda kyee dik Silisi nɛ pɛ pes dik kyee Azia. Bɛ moo tin é suu mɛso nɛ Etiɛn. ");
INSERT INTO bkw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tin bɛ nàbaakwak nyɛ, etɛɛ náá, nyɛ naleliiɛ nɛ etsoŋ ee Sisim na Dɛɛ nadi é djɛ nyɛ ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tin, wɔ gwaa bɛ zɛdjɛ bot epata étɛp bɛ neeke náá: «Bis eegwak nyɛ é lóo mɛkpa mɛ mɛlee dum nɛ Moiiz nɛ Zɛɛb!» ");
INSERT INTO bkw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tin bɛ eezɛni é besal mɛdhuu mɛ bot, bɛpaa nɛ bɛghaŋ ɛ mɛkana mɛ etsi. É di'enek bɛ eezɛmɛt Etiɛn, bhii tak bɛ eezɛtɔ́ nɛ nɛ pɛ zɛɛga boo kwan eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wɔ gwaa bɛ zokabaazyɛ nɛ etiaa-sɛs e etsal binɔk. Bɛ eezɛke náá: «Mot'ak ààkat ɛnyek ɛ kok Ndjaa-ebuwa na dɛɛ yena, dɔɔ nɛ etsi ɛ Moiiz! ");
INSERT INTO bkw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Bis eegwak nyɛ é ke náá, Yezu mot Nazalɛt tak ɛ waabwak kok Ndjaa-ebuwa, da nyɛ ɛ́ swoola etsi ɛ Moiiz nalik mena ye ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bot djas nadi mendiindil tɔ ndjaa e di kwan ɔ moo tin dhuu nɛ mis é nyel ɛ Etiɛn, tin bɛ eezɛbee náá, bhwoob'ɛ nabɛ ɛ moo tyɛ wat nɛ yii fofop. ");
INSERT INTO bkw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Boo ghaa-Zɛɛb eezɛdji nyɛ náá: «Etɛp ee bɛ di lii kɔ ɛsu ɛ lɔ'aak ɛ́ tsɛɛtsɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiɛn eezɛbɔɔza náá: «Bɔn ɛ nyɛɛg bam nɛ bɛsɛɛg bam, gwakeka mɛ! Zɛɛb duu naatel bhaab'enaka Abalaam nyel esok nyɛ nadi pɛ kyee dik Meezopotami ɛ, ɛsok nɛ nyɛ kɛ ɛ́ di pɛ dɛl ɛ Alan. ");
INSERT INTO bkw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","É di'enek, nyɛ naake nɛ nɛ náá: “Dusa kyee dik'ɔ, beta bot ɛ mɛbyel mɔ, da wɔ ɛ́ tɔ pɛ kyee dik mɛ aalyaal wɔ ɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tin Abalaam ɛ boozɛdus kɔ kyee dik eKaldeɛ, nyɛ eezɛtɔ́ kɛdi pɛ kyee dɛl ɛ Alan. Tinaak, bhis ɛsyee ɛ sɛɛg, Zɛɛb eezɛdis nyɛ kɔ kyee dɛl ɛ Alan tɔ́ nɛ nɛ pɛ bi kadi mos'aak. ");
INSERT INTO bkw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bela náá, Zɛɛb nàbɛ ààdjɛ nyɛ pes bɔs, ààkobɛ mɔɔ pes ɛbɔ ɛ bɛɛdok wat. Tin bela náá, Zɛɛb naazekɛk náá, nyɛ waadjɛ nyɛ kyee dik, bɛdha bɛ ɛ́ waalik nɛ yɛ bhis koŋɛ. Bela náá, é ghɛŋ tak nabɛɛ Abalaam di náá, ààkobɛ bɛa nɛ mɔn. ");
INSERT INTO bkw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Beeka etɛp ee Zɛɛb nalɛɛ ɛ: “Bɛdha bɔ aadi ɛ́ kɔ mɛdhik mɛ mɛdjoŋ, e di bɛ aadi ekwom ɔ, e di bɛ aatiiga membu bɛdhet-ɛná ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tin, mɛ waapɛ́ɛ mɛdhik mɛ bɛ aadi é ekwom é tak ɛ. Bhii tak, bɛ waadus e di'enek, bɛ waakɛ sɛɛga é mendjaala é di'ak.” ");
INSERT INTO bkw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Deenek, Zɛɛb naagwakel nɛ Abalaam étɛp ɛkwyal ɛbhɛŋ, ndem tak ɛ beka. Ye ɛ́ kɔ lo mɛsɔ mɛ tak ɛ Abalaam naniigal Izak mɔn'ɛ beka é ɛlu ɛ etɛn nɛ elɛl bhis mɛbyel mɛ, tyɛ wat nɛ dáa Izak naniigal Zakɔɔb mɔn'ɛ beka ɛ, Zakɔɔb zokaniigal bɔɔ bɛ bot ɛ di bɛsɛɛg ɛ bɛbhaab membyak kam nɛ ebá Yisalaɛl ɔ beka. ");
INSERT INTO bkw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Bɛbhaab ɛ tak nadi ɛ́ nɛ mɛbhuka nɛ Zozɛf. Tin, bɛ ɛ́ boo zɛbɔmsa nyɛ étɛp nyɛ needi kwom pɛ Eziptɛ. Tin pe, Zɛɛb nabɛɛ nɛ nɛ lɔɔg. ");
INSERT INTO bkw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nyɛ nadi pɛk nyɛ tɔ mezuk mɛ djas, nyɛ naadjɛ Jozɛf etsoŋ, nyɛ naasa náá, nyɛ djɛ djɔŋ é mis mɛ Falaɔn, mɛkoozi mɛ Eziptɛ. Nyɛ naazɛdjɛ Zozɛf boo ekukuma kɔ kyee dik Eziptɛ, nɛ tɔ ndjaa mɛkoozi mɛ djas. ");
INSERT INTO bkw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Wɔ gwaa pwom zɛni kɔ kyee dik Eziptɛ djas nɛ Kanan: ye nabɛɛ boo mezuk. Tin bɛbhaab binaka nabaabɛ nɛ edee e dek. ");
INSERT INTO bkw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dáa Zakɔɔb nagwak náá, edee nabɛ ɛ pɛ Eziptɛ ɛ, nyɛ boolwom bɛbhaab bina é kɔkɔ ɛsok. ");
INSERT INTO bkw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dáa bɛ nabaatɔ́ Tɔ́a tyee Tɔ́a esok ebá ɛ, Zozɛf ɛ boo tel bɔn nyɛɛg nyel. É di'enek ɛ mɛkoozi mɛ dik Eziptɛ nazɛgu bot ɛ mɛbyel Zozɛf. ");
INSERT INTO bkw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tin, Zozɛf eezɛlwom bot bɛ kɛ ɛnɔɔ Zakɔɔb sɛɛg, zɛnɔɔ bot ɛ mɛbyel mɛ djas. Ye na bɛ bot mɛkam-mɛtɛn nɛ ebá nɛ bot ɛtɛn. ");
INSERT INTO bkw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tin, Zakɔɔb ɛ boozɛtɔ́ pɛ Eziptɛ pɛ paa nyɛ nakɛ gwyɛ ɛ́, zɛnɔɔ bɛdhiiti bɛbhaab bena. ");
INSERT INTO bkw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bɛ naanɔɔ myoŋ mɛ bot bɔɔ, tɔ́ nɛ yɛ pɛ dɛl ɛ Sisɛm. Bɛ boo kɛdel bɛ tɔ ɛvit ɛ Abalaam nabɔm nɛ epata é mɛmbɔ mɛ bɔɔ Amɔɔd pɛ Sisɛm ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Dáa ye nabɛ náá, ɛwala ɛ Zɛɛb nadi kwyɛl ɛsa sa nyɛ nakɛk Abalaam ɛ, ye nabɛ ɛ́ Zɛɛb eebil mɛtaŋ mɛ bot, bot bina moo ɛbuɛpe kɔ Eziptɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tin, dhiiti mɛkoozi mɛsis nàdi ààgu Zozɛf ɔ eezɛnɔɔ boo mɛkoozi kɔ Eziptɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mɛkoozi mɛ tak naakɔɔ bot ɛ mbyak ená. Nyɛ naazuk bɛbhaab bina é ɛlwom bɛ nɛ bhel náá, bɛ bet bɔɔ etɔlɔɔ étɛp bɛ neegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Eghɛŋ tak ɛ Moiiz nabyel, nyɛ nadi ɛ́ nɛm mɔɔ motom Zɛɛb nakwyɛl ɔ. Nyɛ naabaalaa bɛngɔn ɛlɛl tɔ ndjaa sɛɛg. ");
INSERT INTO bkw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","E sok nyɛ naalikaa ɛ, ye nabɛ ɛ ɛsyes ɛ mɛkoozi mɛ dik Eziptɛ naatek nyɛ, nyɛ ɛ́ boo zɛwyel nyɛ dáa mɔn'ɛ met. ");
INSERT INTO bkw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tin, Moiiz nadjek ɛgu nɛ etsoŋ e bɔs bot ɛ Eziptɛ, ye naasa náá, nyɛ di mot mbyok dum nɛ elii bɛ nɛ esesɛɛ bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Dáa nyɛ nadi nyɛ moo nɛ membu mɛkam-mɛná ɛ, Moiiz ɛ boozɛke náá, é gokaa ɛ náá, pookotɔ́ kɛbee bɔn nyɛɛg bot dhaad mbyak Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tin wɔ gwaa nyɛ zɛbee dhiiti mot kyee dik Eziptɛ é zuk ngɔt tɔ lɔɔ. Nyɛ ɛ́ zɛkɛm mot nadi zukaa wɔ, é ghɛm tak, nyɛ eezɛgó mot dɛl ɛ Eziptɛ tak. ");
INSERT INTO bkw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nyɛ nadi é gek náá, bɔn nyɛɛg bot ɛ Yisalaɛl nadi gu náá, ye nabɛ ɛ dum nɛ nɛ ɛ, Zɛɛb naawaaa pɛk bɛ ekwom. Tin, kaa bela ɛ náá, bɛ nàbaagu. ");
INSERT INTO bkw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Yii myɛn tak, nyɛ eezɛbaatɔ́ pɛ dáa lɔɔ, nyɛ ka bela ɛ bot ɛ Yisalaɛl bɛbá é duu pak'ɔɔ, nyɛ ɛ́ boo zɛsuu ɛbee bɛ, nyɛ neebulal ɛgwakel pak ɔ. Nyɛy náá: “Bɛwɛn, bi ɛ bɔn nyɛɛg, étɛp ye bi di genel pak'en?” ");
INSERT INTO bkw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tin, mot nadi zuk mɔɔ sɔ eezɛlɔɔ Moiiz mbee mɛkpa, nyɛy náá: “Ɛzɛ djɛ wɔ boo ekukuma wɔ ne di tetɛp kɔ les? ");
INSERT INTO bkw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wɔ kwyɛl ɛ wɔ neegó mɛ dáa wɔ nagó mot Eziptɛ koko ɛ?” ");
INSERT INTO bkw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dáa Moiiz nagwak mɛkpa menek ɛ, nyɛ boo zɛkaab kɛdi pɛ kyee dik Madian. Penek ɛ nyɛ naabya bɔɔ ba. ");
INSERT INTO bkw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Membu mɛkam-mɛná bhii tak, pɛ tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ é ngwoob ɛtsok ɛ Sinayi, fofop ngɔt zokatuula Moiiz pɛ tɔ ngel du tɔ ɛkpak. ");
INSERT INTO bkw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nyɛ naadjoka é ɛbee mbi yenek mɛvyɛkɛlɛ mɛ nyɛ natelaa ɛ. Tin, esok nyɛ nadi sa étɛp nyɛ neebee ɛnyɔɛpe é ngwoob ɛ, wɔ gwaa nyɛ zokazɛgwak gwood ɛ ghɛŋ é ke náá: ");
INSERT INTO bkw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ye ɛ́ mam Zɛɛb bɛbhaab bɔ, Zɛɛb ɛ Abalaam, Zɛɛb ɛ Izak nɛ Zakɔɔb.” Gbegbaagba nɛ bwoo, nyɛ nàbɛ ààkadjheebal ɛgwyák pɛ yiizaag. ");
INSERT INTO bkw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tin, Ghɛŋ eezɛke nɛ nɛ náá: “Disa mɛpapa mɔ, etɛɛ náá, di wɔ di'aak ɛ́ di na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mee bee dáa bɛ di zuk bot ɛ mbyak'am pɛ kyee dik Eziptɛ ɛ, mɛ eegwak etsim bɔɔ, é di'enek ɛ mɛ zyɛ zɛpɛk bɛ. Deenek, Tɔ́a, mɛ kwyɛl ɛ mɛ lwom wɔ pɛ dik Eziptɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Ye ɛ́ Moiiz tak ɛ bot ɛ Yisalaɛl nabyen, é lóo mɛkpa náá: “Ɛzɛ djɛ wɔ boo ekukuma, nɛ wɔ di tetɛp kɔ les?” Zɛɛb eedhis nyɛ tyee kukuma nɛ pɛkel-bot, Zɛɛb dum nɛ fofop nalyaal nyɛ nyel tɔ gel ɛkpak. ");
INSERT INTO bkw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ye ɛ́ Moiiz ɛ nawyisal bɔɔ Yisalaɛl kɔ dik Eziptɛ, nɛ endem e mɛbwala mɛ nyɛ nadi sa kɔ dik tak ɛ, pɛ boo Dii Mɛsɔn na Tɔɔbelaa, nɛ tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ tɔ membu mɛkam-mɛná. ");
INSERT INTO bkw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ye ɛ́ Moiiz tak ɛ nabaake nɛ bɔɔ Yisalaɛl náá, “Zɛɛb ɛ waadhis bin ngoolel-mɛkpa mɛ dáa mam, nyɛ aadi ɛ́ mot dhaad mbyak en.” ");
INSERT INTO bkw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Baabela náá, é sok bɔn Yisalaɛl nadi esɛɛga tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ, ye ɛ́ nyɛy ɛ́ nadi tyaa pak bɛbhaab binaka nɛ fofop nadi elii nɛ nɛ pɛ kɔ ɛtsok ɛ Sinayi ɛ. Nyɛ naabela mɛkpa mɛ tsik ɛ Zɛɛb, étɛp nyɛ neezɛgoola mena ye ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tin, ye ka bela náá bɛbhaab bina nàbaagwak nyɛ. Bɛ naabyen nyɛ, dáa bɛ ka kwyɛl ɛ ɛsik pɛ Eziptɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bɛ naalɛɛ nɛ Alɔn náá: “Sa bis bɛzɛɛb di kɛsok bhwoob'es ɛ, etɛɛ náá, bis ààgu sa sɛɛ nɛ Moiiz mot wyisal bis tɔ Eziptɛ ɔ.” ");
INSERT INTO bkw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tin, wɔ gwaa bɛ zɛlul mɔɔ ngom ngɔmbɛ e di zɛɛb, bhii tak bɛ eezɛgó zɛɛb tak buwa. Tin, bɛ eezɛbɔl ɛbyoŋ nɛ mɛmyaala ɛbuɛpe dum nɛ sa bɛ nalul bɔɔ bɛ ɛmet ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","É di'enek, Zɛɛb eezɛliig bɛ koŋ, nyɛ eezɛbet bɛ bɛ duwal ekwyikwyen tɔ gwoo. Etɛp tak sael ɛ dáa di kwyala tɔ mɛkana mɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb náá: “Bot ɛ dhaad mbyak eYuda, ye ɛ́ mam ɛ bi nadjɛ ebuwa é bɛtit nɛ bɛdhiiti mbi ebuwa, é membu mɛkam-mɛná mena nadika tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ààbɛ! Gunaa, bi naabɛp pɛt ɛ zɛɛb Molok, nɛ ekpaka-kpaka kwyikwyen zɛɛben Lefan! Bɛzɛɛb binɔk, bi nakpak bɛ étɛp bi needuwal bɛ. É tɛp tak ɛ di náá, Mɛ waakyeed bin dhaa ghaada Bhabhilɔn.” ");
INSERT INTO bkw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Pɛ tɔ bal, bɛbhaab binaka nadi ɛ́ nɛ pɛt na Dɛɛ ɛ Zɛɛb bɛ nawa ɛbup ɛ mɛkana di lii etɛp ee ɛbhɛŋ ɛ. Ye nasael ɛ dáa Zɛɛb nɛ lɛɛ Moiiz ɛ, etɛɛ náá, nyɛ naake nɛ Moiiz náá, nyɛ zoo sum ɛ ɛzel wat nɛ yii nyɛ nabee ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Deenek ɛ pɛt na Dɛɛ ɛ Zɛɛb tak nalik nɛ bɛbhaab bina nɛ bot naka du yɔbɔ bhis ɔ. Ye nabɛ ɛ Zozuwe dulel lɔɔg'ɔ bɛ nɛ bot bɛ naadɛk mɛdhik mɛ bot ɛ membyak me Zɛɛb nadi é sɔ bɛkum ɛ tak kɔ ɛsu ɛ lɔ. Pɛt na Dɛɛ ɛ Zɛɛb tak nadi kɛkum esok Dhavid nadi mɛkoozi ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tin, Dhavid naabela mbɛɛ bhwoob emis ɛ Zɛɛb. Nyɛ ɛ́ boo zɛwaab náá, Zɛɛb gek nyɛ goŋ étɛp nyɛ neesum ndjaa Zɛɛb bɛdha ɛ Zakɔɔb. ");
INSERT INTO bkw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tin, Salomɔŋ naka sum nyɛ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bela náá, Zɛɛb Mɛkaake ààdi tɔ mendjaa me Zumal bot. Dáa ngoolel-mɛkpa ɛ Zɛɛb nalɛɛ náá: ");
INSERT INTO bkw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ɛko ɛ, boo mɛkoozi mɛ, Ghɛŋ lɛɛ ɛ deenek, bɔs ɛ, di mɛbɔ mɛ di nyal ɔ. Ye ɛ́ yaa kwaambi ndjaa biyɔ aakosum mɛ ye ɛ́? É yaa di mɛ aakwak ɛ di? ");
INSERT INTO bkw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ye tok mam nasa yɛ nɛ mɛbɔ mam met e?” ");
INSERT INTO bkw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Biyɔ bot ɛ maa-ɛlɔ, bot ɛ di náá, elyem nɛ mɛlɔ men eezɛdiyalel dum nɛ ndjóoel ɛ Zɛɛb di djóo bin ɛ. Bi ɛ nɛ maa-ɛlɔ dum nɛ Sisim na Dɛɛ! Bi ɛ dáa bɛbhaab bin! ");
INSERT INTO bkw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Baa bɛngoolel ɛ mɛkpa mɛ Zɛɛb bɛbhaab bin nadi ààtiigal? Bɛ naagó bot ɛ nazyɛ nɛ bhaadal náá, Mot Epiki ngɔt ɛpezyɛ ɛ. Ye ɛ́ nyɛy ɛ bi naka nyɛ, nɛ ɛgó ɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Biyɔ bot ɛ efofop nadjɛ etsi ɛ Zɛɛb ɔ, bi nàbaaduwal yɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Dáa bot ɛ boo kwan eYuda nagwak deenek ɛ, bɛ naazɛkpaa lyem, nɛ ɛkwaal ɛ mɛtsok kɔ lo ɛ Etiɛn. ");
INSERT INTO bkw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Tin, nyɛy «tɔɔɔ» nɛ Sisim na Dɛɛ tɔ lɛ, nyɛ eezɛben mis pɛ ɛko, gwyák tɔ gwoo. É di'enek nyɛ eezɛbee mɛkas ɛ Zɛɛb, zɛnɔɔ Yezu Klisto tetel pɛ mbɔ eghɛŋ ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tin, Etiɛn eeke náá: «Mɛ ɛpebee gwoo mbek, Sɛɛŋɛlɛ Mɔn Mot tetel pɛ mbɔ eghɛŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bɛ eezɛtsim ɛlyelɛpe, bhii tak bɛ eezɛdiyal mɛlɔ, bɔ djas eewyis kaab, zɛduma nyɛ é nyel. ");
INSERT INTO bkw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bɛ eezɛtɔ́ nɛ nɛ pɛ bhis dɛl, tin, bɛ moo zɛbyaal nyɛ nɛ mɛkok étɛp bɛ neegó nyɛ. Wɔ gwaa bɛtyaasɛs zokadjɛ ekaad bɔɔ nɛ dhiiti mɔɔ ngbaaz din ɛ lɛ nabɛ ɛ́ Sɔl, nyɛ baal bɛ yɛ. ");
INSERT INTO bkw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","E sok bɛ nadi é wus nyɛ nɛ mɛkok ɛ, Etiɛn nadi ye ɛ́ é djaala náá: «Ghɛŋ Yezu, nɔŋa sisim yam!» ");
INSERT INTO bkw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Bhii tak, nyɛ eezɛkwyɛ mɛboŋ si, nyɛ eezɛtsim ɛlyelɛpe náá: «Ghɛŋ, nàkɛla syem'ak kɔ lɔɔ!» Bhis nyɛ nake deenek ɛ, nyɛ eezɛsil eswos. ");
INSERT INTO bkw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔl naamyaal ɛsyee ɛ Etiɛn. É dwoo tak wat ɛ mezuk mɛ bot ɛ zɛɛga mendjaala Yeluzalɛm nakan. Bot djas nadi dum koŋ nɛ Zɛɛb ɔ naazɛwyɛɛza tɔ́ pɛ kyee dik Yude, nɛ pɛ Samali. Tin bot ɛ lwoma ɛ nazokalik. ");
INSERT INTO bkw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bɛsosoob ɛ́ boonɔɔ muu ɛ Etiɛn kɛdel, wɔ gwaa bɛ zɛdje nyɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔl nadi sa mɛghaaz étɛp ɛkɛ waaz ezɛɛga mendjaala. Bhii tak, nyɛ nadi tɔ́ mendjaa nɛ mendja kɛmɛt botom nɛ boa nadi dum koŋ nɛ Zɛɛb ɔ, é kokɔɔl bɛ é mbok. ");
INSERT INTO bkw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bot ɛ nawyɛɛza ɔ djas, nadi kɛmɛl ɛ mɛl kɛgoola Mbɛɛ Bhaadal. ");
INSERT INTO bkw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip eezɛtɔ́ pɛ boo dɛl ɛ Samali, tin, nyɛ eezɛni é lyo bot ɛ dɛl dum nɛ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bot ɛ dɛl djas nadi gwak etɛp ee Filip nalɛɛ bɛ ɛ́ nɛ lyem wat, tɔ mɛdjek nɛ ɛ bee ɛ endem e mɛbwala nyɛ di sa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Deenek, embee esisim nadi wyis tɔ membel é ɛbo ɛ boo etsim. Tin, dɔɔ nɛ bɛtɛ nɛ bot ɛ nazesɔɔb ɔ nɛ bot edjam nadi tsak. ");
INSERT INTO bkw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Deenek, bot naadyeebamyaala ɛbuɛpe kɔ dɛl ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dhiiti mot din ɛ lɛ nabɛ Simɔŋ, nyɛ naaloobe di sok kɔ dɛl ɛ tak. Nyɛ nasa mɛvyɛkɛlɛ bot ɛ del Samali nadi djodjoka ɛ. Nyɛ nadi kwyɛl ɛlyaal ɛ naanye ɛ́ yɛ ngek mot. ");
INSERT INTO bkw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tin, mengbaaz djas nɛ eboo bot, nadi duwal nyɛ ɛbuɛpe. Bɛ nadi eke ɛ náá: «Mot'ak ɛ nɛ mɛbwala ɛ Zɛɛb, yii di djóoaa “boo mɛbwala ɛ”.» ");
INSERT INTO bkw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bɛ nadi gwak nyɛ ɛbuɛpe, etɛɛ náá, nyɛ eeloozyɛ nɛ sa náá, bot gheedjoka mɛsa mɛ mɛvyɛkɛlɛ mɛ. ");
INSERT INTO bkw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tin, dáa bɛ namyaal Mbɛɛ Bhaadal Filip nadi lɛɛ bɛ dum nɛ ɛyoŋ ɛ Zɛɛb nɛ dum nɛ Yezu Klisto ɛ. Tin, bɛ naazɛduwa Zɛɛb botom nɛ boa. ");
INSERT INTO bkw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Dɔɔ nɛ Simɔŋ nyɛy ɛmet naadum koŋ nɛ Zɛɛb. Nyɛy pe zokaduwa Zɛɛb, nyɛ nadi é ngwoob ɛ Filip, nyɛ nabɛɛ é djodjoka ɛbuɛpe esok nyɛ nadi é bee endem e mɛbwala mɛ nadi é sael ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Dáa bot ɛ lwoma nakum pɛ Yeluzalɛm ɛ, bɛ eezɛgwak náá, bot ɛ Samali naazemyaal mɛkpa mɛ Zɛɛb, é di'enek bɛ ɛ́ boozɛkyeed bɛ Pyɛɛd bɛ nɛ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dáa bɛ nakakum pɛ Samali ɛ, wɔ gwaa bɛ zɛdjaala bot ɛ nazedum koŋ Zɛɛb ɔ Zɛɛb, étɛp bɛ neebela Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bɛ nadjaala deenek ɛ etɛɛ náá, Sisim na Dɛɛ nabɛ ɛ, nyɛ dinaa ko sul-sulak kɔ mot ngɔt. Bɛ zo duwa Zɛɛb ɛ tɔ mɛdii nɛ din ɛ Ghɛŋ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tin, Pyɛɛd bɛ Zaŋ eezɛkɛl bɛ mɛmbɔ, bɛ eezɛbela Sisim na Dɛɛ. ");
INSERT INTO bkw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dáa Simɔŋ nabee náá, bot ɛ di dum koŋ nɛ Zɛɛb ɔ naadjɛaa Sisim na Dɛɛ esok bot ɛ lwoma nakɛl bɛ mɛmbɔ ɛ, nyɛ eezɛdjɛ Pyɛɛd nɛ Zaŋ epata. ");
INSERT INTO bkw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nyɛy náá: «Djɛka dɔɔ nɛ mam pe mɛbwala mɛ tak, etɛɛ náá, bot ɛ mɛ aagheekɛl mɛmbɔ kɔ lɔɔ ɔ neebela Sisim na Dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tin, Pyɛɛd eezɛbɔɔza nɛ nɛ náá: «Beta náá, wɔy nɛ epata bɔ bi pulel, etɛɛ náá, wɔ gek ɛ náá, ɛkɛɛ ɛ Zɛɛb bɔmaa ɛ nɛ epata! ");
INSERT INTO bkw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wɔ tok nɛ ɛkɛɛ waako bela belaa di tɔ tɛp'ak, etɛɛ náá lyemɔ tok piki é mis mɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Deenek swoola embee esiiza bɔ, da wɔ ɛ́ djaala Ghɛŋ, nɛghu nyɛ ɛ́ nɛ ghwyil ɛpel wɔ étɛp mbi esiiza bɔ binek. ");
INSERT INTO bkw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Etɛɛ náá, mɛ eebee náá, lyemɔ ɛ “tɔɔɔ” nɛ embee esesɛɛ, e di'enek, wɔ moo ɛ́ kwom mesyem.» ");
INSERT INTO bkw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tin, Simɔŋ eezɛke nɛ Pyɛɛd bɛ Zaŋ náá: «Biyɔ bɛ ɛmet djaalaka Ghɛŋ étɛp'am, etɛɛ náá, sa bi ke ɛ needi ààsael nɛ nam.» ");
INSERT INTO bkw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bhis bɛ nazebaŋa bot etɛp binek dum nɛ Yezu, é ɛlyo ɛ bot nɛ mɛkpa ɛ Ghɛŋ ɛ, tin bot ɛ lwoma binɔk bɛbá eezɛsik pɛ Yeluzalɛm. Ze ɛ ze bɛ nadi goola Mbɛɛ Bhaadal pɛ kɔ bɛtɛ nɛ mɛl mɛ Samali. ");
INSERT INTO bkw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dhiiti fofop ɛ Ghɛŋ eezɛke nɛ Filip náá: «Wyɛla da wɔ ɛ́ tɔ́ pɛ kyɛ bɔs, pɛ ze di dus pɛ Yeluzalɛm é tɔ́ pɛ dɛl ɛ Ghaaza ɛ, ze di dhaa tɔ bal.» ");
INSERT INTO bkw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","E di tak wat, Filip eezɛghɛɛ nyel tɔ́. Tin, é ze, dhiiti mot eezɛtuula, mot tak nabɛ mot di ààbɛ nɛ ghwyil ɛbá ɔ, yii dik Etsopi. Nyɛ nabɛ ɛ boo kukuma, mɛsa mɛ nabɛɛ, ɛbaal epata nɛ esa djas ɛ Kandase, moma di mɛkoozi mɛ Etsopi ɔ. Nyɛ nazyɛ pɛ Yeluzalɛm ɛ zɛduwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Tin, nyɛ nadi sik pɛ dɛl ɛ lɛ. Nyɛ nadi ɛ́ ndiindel kɔ mbem mɛ yaaga di dul ɛ, nyɛ nadi laa mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi. ");
INSERT INTO bkw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tin, Sisim na Dɛɛ eezɛke nɛ Filip náá: «Tɔ́a pɛ paa mbem diak.» ");
INSERT INTO bkw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tin, Filip eezɛtɔ́ kaab pɛ mot tak nadi ɛ, nyɛ ka gwak ɛ mot'enɔk é laa mɛkana mɛ ngoolel-mɛkpa ɛ Zɛɛb Ezayi. Filip eezɛdji nyɛ náá: «Wɔ nɛ gu sa mɛkpa mɛ wɔ di laŋ'enek di kwyɛl ɛlɛɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mot'enɔk eezɛbɔɔza náá: «Mɛ aagu yɛ dáa, mot ɛ di ààlyaal mɛ ɔ?» Tin, neezɛdjóo Filip nyɛ zɛdisi é ngwoobɛ kɔ mbem. ");
INSERT INTO bkw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pes di Ekwyala e Zɛɛb nyɛ nadi elaŋ ɛ na bɛ ɛ́ yak: «Nyɛ nadi ɛ́ dáa mɔɔ taa di tɔ́aa nɛ nɛ kɛtsakaa ɛ, dáa mɔɔ bhata di ààtsim sok bhwoob bot ɛ di tsik nyɛ mya ɔ. Nyɛy nuub mɛdiba. ");
INSERT INTO bkw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nyɛ naadhuselaa, ààbɛ nɛ mot kɛm nyɛ. Ɛzɛ aakwak ɛlii nɛ bɛdha bɛ? Etɛɛ náá, bɛ naatsaal mɛlu mɛ tsik'ɛ kɔ bɔs.» ");
INSERT INTO bkw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tin, kukuma yenɔk ɛ boozɛke nɛ Filip náá: «Mɛ pe djaala nɛ nɔ, lɛɛa mɛ, kɔ ɛsu ɛzɛ ngoolel-mɛkpa ɛ Zɛɛb di lii deenek? Nyɛ lii ɛ kɔ ɛsu ɛ lɛ met hooo kɔ ɛsu ɛ mot sis?» ");
INSERT INTO bkw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","É di'enek, Filip eekan ɛlii nɛ nɛ dum nɛ pes mɛkpa mɛ Ekwyala e Zɛɛb nyɛ laŋ ɛ, nyɛ moo tin é lɛɛ nyɛ Mbɛɛ Bhaadal ɛ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bɛ eezɛgoola tɔ́, ze bɛ nadi é tɔ́ yɔbɔ ɛ, wɔ gwaa bɛkum é dhiiti di nadi nɛ dii ɛ. Kukuma yenɔk eezɛke náá: «Beea mɛdii, ɛyé di lu náá, mɛ duwa Zɛɛb?»  ");
INSERT INTO bkw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip eezɛke nɛ nɛ náá: «Wɔ myaal nɛ lyemɔ djas ɔ, wɔ ɛ́ nɛ ghwyil ɛ duwa Zɛɛb.» Tin, mot'enɔk eezɛbɔɔza náá: «Mee myaal náá, Yezu ɛ Mɔn Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tin, nyɛ eezɛke náá, yaaga tyaa, bhii tak, bɛ nɛ Filip eezɛsul tɔ dii, wɔ gwaa nyɛ zɛduu nyɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dáa bɛ naka sɛɛ tɔ dii ɛ́, Sisim ɛ Ghɛŋ eezɛdis Filip é mis mɛ kukuma tak, nyɛ moo tin, ààkabee Filip. É di'enek nyɛ eezɛkpaa tɔ́ yɛ pɛ paa nyɛ nadi é tɔ́ ɛ, nɛ boo mɛmyaala. ");
INSERT INTO bkw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ka kɛtuula ye ɛ́ pɛ dɛl ɛ di djóoaa Azɔt ɔ, nyɛ moo tin é tɔ́ kɛgoola Mbɛɛ Bhaadal, mɛl nɛ mɛl djas. Nyɛ nadi dhaŋ ɛ kɛkum pɛ ghaada Seezale. ");
INSERT INTO bkw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eghɛŋ tak, mɛsa ɛ Sɔl nabɛ ɛ ɛtiig nɛ ɛwun ɛ ɛgó ɛ bɛdjekel ɛ Ghɛŋ. Wɔ gwaa nyɛ zɛtɔ́ kɛbee boo ghaa-Zɛɛb, ");
INSERT INTO bkw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bhii tak nyɛ eezɛwaab mɛkana mɛ di edjɛ nyɛ ze, nyɛ neekɛbee mendjaa mɛ mendjaala mɛ eYuda di pɛ ghaada Dhamas ɛ. Nyɛ nasa deenek ɛ nɛghu nyɛ waabela boa nɛ botom ɛ di du Ze ɛ Ghɛŋ étɛp nyɛ neemɛt bɛ, da nyɛ ɛ́ sik nɛ nɔɔ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dáa nyɛ nadi nyɛ dinaa é ze é ɛtɔ́ ɛ, nyɛ nadi ɛ́ nyɛ moo kunaa nɛ ghaada ɛ, kasɛka ɛ, dhiiti ngel eezɛdus tɔ gwoo, yee zɛkaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wɔ gwaa nyɛ zɛduma si, bhii tak nyɛ eezɛgwak gwood wat é ke nɛ nɛ náá: «Sɔl, Sɔl, étɛp ye wɔ di tiig mɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nyɛ eezɛdji náá: «Wɔy ɛ́ zɛ, Ghɛŋ?» Tin gwood yenek eezɛbɔɔza náá: «Ye ɛ́ mam Yezu wɔ di tiig ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Deenek, wyɛla, da wɔ ɛ́ ni tɔ ghaada, tin bɛ waalɛɛ wɔ sa wɔ di egoka nɛ ɛsa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bot ɛ nadi kɛsama wat nɛ Sɔl ɔ zokazɛtyaa, ààlóo ɛkpa ɛ wat. Bɛ nadi gwak gwood, tin ààbee mot. ");
INSERT INTO bkw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tin Sɔl eewyɛl, nyɛ eezɛbɛɛ mis, ka bela ɛ náá, nyɛ ààkabee. Bɛ eezɛmɛt nyɛ é mbɔ tɔ́ nɛ nɛ pɛ Dhamas. ");
INSERT INTO bkw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mɛlu mɛlɛl naadhaa nyɛ, nyɛ ààkabee, tin nyɛ nadi ɛ́ ààdɛ edee nɛ mɛdii. ");
INSERT INTO bkw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pɛ kɔ ghaada Dhamas, ye nabɛ ɛ nɛ dhiiti djekel ngɔt din ɛ lɛ nabɛɛ Ananias. Ghɛŋ zokazɛtuula nyɛ tɔ sisim, nyɛy nɛ nɛ náá: «Ananias!» Nyɛ eezɛbɔɔza náá: «Beea mɛ Ghɛŋ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ghɛŋ eezɛke nɛ nɛ náá: «Tɔ́a nenak yak pɛ gba di djóoaa “piki ɛ”. Pɛ tɔ ndjaŋ ɛ Yudas, djia dhiiti mot dɛl ɛ Talase, din ɛ lɛ ɛ Sɔl. E di mena di nenak'aak nyɛ ɛ́ pe djaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Tin, tɔ dyam'ɛ nyɛ eebee dhiiti mot ngɔt din ɛ lɛ ɛ Ananias é ni tɔ ndjaa étɛp ɛkɛl nyɛ mɛmbɔ, mis mɛ neebɛŋel-bɛŋela sis.» ");
INSERT INTO bkw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias eezɛbɔɔza náá: «Ghɛŋ, bot ɛbuɛpe eedyeebalii nɛ nam kɔ ɛsu ɛ mot'ak, dum nɛ bɛtɛ nɛ embee etɛp é nyɛ di sa, nɛ Bot bɔ na Dɛɛ pɛ Yeluzalɛm ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Deenek, nyɛ zyɛ wak ɛ́ nɛ eghɛŋ boo ghaa-Zɛɛb nadjɛ nyɛ ɛ́ étɛp ɛmɛt bot djas di edjaala nɛ din ɛ lɔ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Tin, Ghɛŋ ɛ booke nɛ nɛ náá: «Tɔ́a, etɛɛ náá, mɛ eetɔ́ mot tak étɛp nyɛ neetɔ́ kɛgoola din ɛ lam pɛ daa bot ɛ membyak mesis nɛ bɛmɛkoozi mɔɔ, zɛnɔɔ bot ɛ mbyak Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mam mɛ ɛmet mɛ waalyaal nyɛ mezuk djas nyɛ aazuk kɔ ɛsu ɛ din ɛ lam ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tin, Ananias eezɛtɔ́. Nyɛ eezɛni tɔ ndjaa tak, bhii tak nyɛ eezɛkɛl Sɔl mɛmbɔ, nyɛ eezɛke nɛ nɛ náá: «Sɔl, mɔɔ nyaag'am, Ghɛŋ Yezu mot tel wɔ nyel é gba pɛ ze wɔ di zyɛ ɛ́, lwom mɛ, étɛp wɔ neebaazɛbee beea sis da wɔ lwoodel nɛ Sisim na Dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","E di tak wat, dhiiti mbi esonok tyee epapa eezɛkwyit é mis mɛ Sɔl, tin, nyɛ moo tin ɛ é baazɛnyaasok. Nyɛ eezɛwyɛl ɛ́ yenek, nyɛ eezɛduwa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Bhii tak nyɛ eezɛdɛ edee, nyɛ eezɛbela ghwyil. Sɔl zokazɛkpaa ba mɛlu e di wat bɛ nɛ bɛdjekel ɛ nadi pɛ Dhamas ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ààkobɔya deenek, nyɛ moo tin é goola mɛkpa ɛ Zɛɛb pɛ tɔ mendjaa mɛ mendjaala mɛ eYuda náá, Yezu ɛ Mɔn Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bot ɛ nadi gwak nyɛ ɔ djas nadi djoka, tin, bɛ ɛ́ boo di é dji náá: «Ye tok mot'ak nadi tiig ɛlyelɛpe bot ɛ nadi tuwal din ɛ Yezu ɔ pɛ Yeluzalɛm e? Wɔ ke ɛ náá, nyɛ aazyɛ wak ɛ étɛp ɛzɛmet bɛ nyɛ neesik nɛ nɔɔ pɛ dáa boo bɛghaa-Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Tin, mɛlu djas, ɛgu ɛ Sɔl nadi é ghɛɛ nɛ ghɛɛ tɔ mbi mɛlyo mɛ nyɛ nadi lyo ɛ. Eyuda ee nadidi pɛ Dhamas ɔ, nabɛ ààkabaabɛ nɛ ɛkpa ɛ bulal nyɛ esok nɛ nadi é pɛs mɛsuk mɛ di lyaal náá, Yezu ɛ Mɛsia ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ba mɛlu bhii tak, wɔ gwaa eYuda djas zokagwakel étɛp bɛ neegó Sɔl. ");
INSERT INTO bkw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tin, Sɔl eezɛgu boob'ɔ. Bɛ nadi ebaal ɛbɛ ɛ ɛniel ɛ ghaada mwos nɛ pum, étɛp bɛ neegó nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tin, é pum, wɔ gwaa bɛdjekel bɛ zokanɔɔ nyɛ, tɔ́ nɛ nɛ, étɛp ɛkwyɛɛg nyɛ pɛ yii kyee peeb ghaada tɔ djhan. ");
INSERT INTO bkw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Dáa nyɛ na kum pɛ Yeluzalɛm ɛ, wɔ gwaa Sɔl zokazɛgek ɛsɛɛga bɛ nɛ bɛdjekel. Bɔɔ djas nadi ɛ́ nɛ bwoo, etɛɛ náá, bɛ nàbaadi myaal ɛnyɔɛpe náá, nyɛ nadi ɛ́ djekel nɛ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Tin, Bhaalnabhas ɛ boozɛnɔɔ nyɛ, tɔ́ nɛ nɛ pɛ dáa bot ɛ lwoma. Nyɛ eezɛbaŋa bɛ dáa Sɔl naboma nɛ Ghɛŋ é ze ɛ, nɛ dáa Ghɛŋ nalii nɛ nɛ ɛ. Nyɛ eebaazɛlɛɛ bɛ mbi mɛghaaz mɛ Sɔl nadi lyo bot nɛ din ɛ Yezu pɛ Dhamas ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kana ɛwala ɛlenek, Sɔl ɛ boo zɛdi bɛ nɛ bɛ nɔɔ. Nyɛ nadi ekɛpɛ tɔ Yeluzalɛm djas, é goola Mbɛɛ Bhaadal nɛ ɛbwaalel djas nɛ din ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nyɛ nadi é lii nɛ eYuda e di lii, lii Ghɛlɛk ɔ, nyɛ nadi suu mɛso bɛ nɛ bɛ nɔɔ, ghuna bɔɔ nadi esaa ɛgó ɛ nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Dáa bɔn nyɛɛg nagwak náá, bɛ nadi kwyɛl ɛgó nyɛ ɛ́, bɛ eezɛtɔ́ nɛ Sɔl pɛ ghaada Seezale, étɛp bɛ neekɛkyeed nyɛ pɛ ghaada Talase. ");
INSERT INTO bkw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Zɛɛga bot ɛ mendjaala nadi ɛ́ tɔ egwyem kɔ kyee dik Yude, Ghalile nɛ Samali djas. Bɛ nadi ɛ́ bɛ eezelyel tɔ ɛdum ɛ koŋ nɛ Zɛɛb, bɛ nadi ɛ́ tɔ tsik ɛgwak ɛ Ghɛŋ. Zɛɛga bot ɛ mendjaala nadi é bɔk ɛbɔk nɛ ɛbɔk, etɛɛ náá, Sisim na Dɛɛ nadi kwyee bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pyɛɛd mot nadi kɔ kyee dik tak djas ɔ zokazɛtɔ́ dhiiti dwoo pɛ dáa bot ɛ di dum koŋ nɛ Zɛɛb ɔ, nadidi pɛ dɛl ɛ Lidha ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wɔ gwaa nyɛ zɛbela dhiiti motom din ɛ́ ɛ lɛ nabɛɛ Enee. Nyɛ nabɛ ɛ nyɛ eesa membu mɛtɛn nɛ elɛl ndjaasi, etɛɛ náá, ye nabɛ ɛ nyɛ eezesɔɔb. ");
INSERT INTO bkw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pyɛɛd eezɛke nɛ nɛ náá: «Enee, Yezu Klisto eetsik wɔ! Wyɛla da wɔ ɛ́ koobal goŋɔ.» Ka sɛka ɛ, Enee eezɛwyɛl. ");
INSERT INTO bkw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bot ɛ ghaada Lidha djas nɛ bot ɛ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ Saalɔn naabee nyɛ, wɔ gwaa bɛ zokaliig elyem du Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pɛ kɔ dɛl ɛ Jafa ye na bɛ ɛ́ nɛ dhiiti moma nadi dum koŋ nɛ Zɛɛb ɔ, din ɛ lɛ nabɛɛ «Tabita» din ɛ tak kwyɛl ɛlɛɛ ɛ «Dɔlkas», ɛsuk ɛ tak lɛɛ «kwyee». Mɛlu djas mɛsa mɛ nabɛɛ, ɛsa enɛm é sa, nɛ ɛkwyee ɛ bɛdjel ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Eghɛŋ tak wɔ gwaa nyɛ zɛbɛ, bhii tak, nyɛ eezɛgwyɛ. Bhis bɛ nagwyii muu ɛ, wɔ gwaa bɛ kɛnɛɛg yɛ tɔ dɛŋ, pɛ ɛko tɔ ndjaa. ");
INSERT INTO bkw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Bɛdjekel ɛ nadi pɛ Jafa ɔ naagwak náá, Pyɛɛd nadi ɛ́ pɛ Lidha, ye nadi ɛ́ ɛkunaaɛpe nɛ Jafa. Bɛ eezɛkyeed bot ɛbá nɛ bhaadal yak: «Bis eedjaala nɛ nɔ, lela ɛzyɛ kaab pɛ yesɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","E di tak wat Pyɛɛd eezɛghɛɛ nyel tɔ́ bɛ nɛ bɛ nɔɔ. Dáa bɛ nakum ɛ, bɛ eezɛdul nyɛ tɔ dɛŋ, pɛ ɛko tɔ ndjaa. Bɛ kus ɛ boa djas eezɛtiila pɛ dáa lɛ nɛ mɛgwyɛ, bɛ moo tin é liial nyɛ ekuwa nɛ endjookuwa ee Tabita nalat esok nyɛ nadi nyɛ dinaa nɛ tsik ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pyɛɛd eezɛwyisal bot djas pɛ kel, e di'enek, nyɛ eezɛkwyit mɛboŋ si é djaala. Bhii tak, nyɛ eezɛliigel pɛ muu nadi ɛ, nyɛ eezɛke náá: «Tabita wyɛla!» Nyɛ eezɛbɛɛ mis, tin, dáa nyɛ na bee Pyɛɛd ɛ nyɛ eezɛnɔɔ nyel disi. ");
INSERT INTO bkw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pyɛɛd eezɛmɛt nyɛ é mbɔ étɛp ɛkyee nyɛ, nyɛ neewyɛl. Bhii tak, nyɛ eezɛdjóo bot ɛ di dum koŋ nɛ Zɛɛb ɔ nɛ bɛkus ɛ boa, nyɛ eezɛtel bɛ nyaa nyɛy nɛ tsik. ");
INSERT INTO bkw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wɔ gwaa bot ɛ ghaada Jafa djas zokagwak menduk mɛ tak, tin, bot ɛbuɛpe naazɛdum koŋ nɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pyɛɛd zokadi kɔ Jafa bɛtɛ nɛ mɛlu pɛ dáa dhiiti mot nadi sa mɛsa mɛ ekwood é bɛtit ɔ. Din ɛ mot tak nabɛ ɛ Simɔŋ. ");
INSERT INTO bkw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pɛ ghaada Seezale, ye nabɛ ɛ nɛ dhiiti mot din ɛ lɛ nabɛ ɛ Kɔɔdnɛy, nyɛ nadi ɛ́ kukuma tɔ lɔɔg esodja bot ɛ Lɔm di djóoaa: «Mwaka esodja Itali». ");
INSERT INTO bkw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Mot tak nabɛ ɛ sosoob dɔɔ nɛ bot ɛ mɛbyel mɛ djas. Nyɛ nadi zezyɛ zɛɛga mendjaala bot nadi duwal Zɛɛb é tak ɛ. Nyɛ nadi kwyi-kwyee bɛdjel ɛ bot yii bot ɛ mbyak eYuda nɛ lyem wat, nyɛ naadjedjaala Zɛɛb é mɛwala djas. ");
INSERT INTO bkw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bhis kuku dwoo é ɛwala ɛ elɛl, wɔ gwaa nyɛ zokazɛbee tɔ sisim. Nyɛ naabee popoopwon fofop ɛ Zɛɛb ngɔt é zɛni pɛ dáa lɛ, nyɛy nɛ nɛ náá: «Kɔɔdnɛy!» ");
INSERT INTO bkw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nyɛ eezɛgwyák fofop nɛ lyem bwoo, bhii tak nyɛ eeke nɛ nɛ náá: «Ɛyé Ghɛŋ?» Fofop eezɛbɔɔza nɛ ɛ náá: «Zɛɛb eegwak mendjaala mɔ, nɛ ghwyiikwyee wɔ di kwyee bɛdjel ɛ bot ɛ, nyɛ ààpadjisa wɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tinaak, kyeeda bot pɛ Jafa bɛ neekɛ djóo dhiiti mot nɛ din ɛ Simɔŋ, mot nagetaa Pyɛɛd ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nyɛ di ɛ pɛ dáa dhiiti mot di sa mɛsa mɛ ekwood bɛtit ɛ, din ɛ lɛ Simɔŋ, ndjaŋ'ɛ é ɛboŋ ɛ boo dii mɛsɔn.» ");
INSERT INTO bkw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Dáa fofop nadi é lii nɛ nɛ ɛ natɔ́ ɛ, Kɔɔdnɛy eezɛdjóo bot ɛ mɛsa mɛ bɛbá, nɛ ngɔt pak esodja eedii sa mɛsa pɛ daa lɛ ɔ, mot nadi sosoob ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nyɛ eezɛbaŋa bɛ etɛp ee nadhaŋ ɛ djas, bhii tak nyɛ eezɛlwom bɛ pɛ Jafa. ");
INSERT INTO bkw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Djɛmɛn tak, bɔɔ é ze, bɛ moo kunaa nɛ Jafa. Pyɛɛd eezɛbyet kɔ ɛko ɛ ndjaa, kuku mwos kɛdjaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tin, za eezɛsa nyɛ. Dáa bɛ nadi é djaab nyɛ edee ɛ, nyɛ eezɛdjem dyam. ");
INSERT INTO bkw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nyɛ eezɛbee gwoo é bɛŋel, dhiiti sonok é sul: siaa tak dáa boo poba mɛta é mɛghɔ mɛ tak ená, esul é bɔs. ");
INSERT INTO bkw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tɔ tak ye nabɛɛ nɛ bɛtit ɛ́ di kɛkɔ mɛko mɛná ɔ, bɛtit ɛ di nɛ epapa ɔ, nɛ membi me enen djas. ");
INSERT INTO bkw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dhiiti gwood é zɛke nɛ nɛ náá: «Wyɛla, Pyɛɛd, góa da wɔ ɛ́ dɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tin, Pyɛɛd eezɛbɔɔza náá: «Ohoo ààbɛ! Ghɛŋ, etɛɛ náá, mɛ dinaa ààpaakodɛ sok esa e tsi nɛ esee mendi.» ");
INSERT INTO bkw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gwood'enek eebaazɛgek, é ke náá: «Nàbeea sa mendi sa Zɛɛb ke náá ye ɛ́ dɛɛ ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ye sɛɛ deenek tyee esok elɛl, bhii tak, siaa tak eezɛbyet tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tin, Pyɛɛd moo zɛdji sa dyam tak nadi kwyɛl ɛlɛɛ ɛ. Ghuna, é ɛwala ɛ tak ɛ, bot ɛ Kɔɔdnɛy nalwom ɔ nadi dji bot étɛp ɛ gu ndjaa Simɔŋ nadi tɔ tak ɛ. Ye ka bela ɛ bɛ moo é ɛniel ɛ peeb. ");
INSERT INTO bkw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bɛ eezɛdjóo, bhii tak bɛ eezɛdji náá: «Simɔŋ, mot nagetaa Pyɛɛd ɔ diɛ wak ee?» ");
INSERT INTO bkw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ye na bela Pyɛɛd dinaa kuku esiiza dum nɛ dyam nyɛ nadjem ɛ. É di'enek Sisim na Dɛɛ eezɛke nɛ nɛ náá: «Gwaka, bot ɛlɛl ɛpesaa wɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wyɛla, sula da wɔ ɛ́ tɔ́ bi nɛ bɛ nɔɔ sama ààbis sonok, etɛɛ náá, mam ɛ lwom bɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pyɛɛd eezɛsul pɛ bot ɛ tak nadi ɛ, nyɛ eezɛke nɛ nɔɔ náá: «Mot bi di saŋ ɔ ye ɛ́ mam. Bi zyɛ étɛp ye?» ");
INSERT INTO bkw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɛ eezɛbɔɔza náá: «Ye ɛ́ Kɔɔdnɛy, kukuma tɔ lɔɔg esodja eLɔm ɛ lwom bis. Nyɛ ɛ́ mot epiki, nyɛ nɛ duwal Zɛɛb zɛbela náá, eYuda djas nɛ kwyɛl nyɛ. Fofop ɛ Zɛɛb ngɔt lwom nyɛ ɛ́, nyɛ lɛɛ wɔ náá, “wɔ tɔ́ pɛ dáa lɛ étɛp wɔ neekɛ lɛɛ nyɛ lɛŋ wɔ di nɛ ye ɛ́.”» ");
INSERT INTO bkw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tin, Pyɛɛd eezɛniigal bɛ tɔ ndjaa, bhii tak nyɛ eezɛdjɛ bɛ e di é mendjɛk. Tɔ mɛlem, bɛ eezɛtɔ́ bɛ bɛ nɔɔ, bɛdhiiti bot ɛ Jafa zokakɛkyeed bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bhis ɛlu ɛ tak, bɛ eezɛkum pɛ Seezale. Kɔɔdnɛy nadi bwood nyɛ bɛ nɛ bot ɛ mɛbyel mɛ djas, nɛ bɛsɔ bɛ nyɛ nadjóo ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dáa Pyɛɛd nadi nyɛ moo kwyɛl ɛ ni ɛ, Kɔɔdnɛy eezɛboma nɛ nɛ. Tin, nyɛ eezɛmalal si, étɛp nyɛ neeswos nyɛ nɛ duu. ");
INSERT INTO bkw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tin, Pyɛɛd eezɛwyɛl nyɛ, bhii tak, nyɛ eezɛke nɛ nɛ náá: «Wyɛla, etɛɛ náá, mam pe mɛ ɛ mot dáa wɔy.» ");
INSERT INTO bkw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tin, bɔɔ kuku elɛŋ bɛ nɛ Kɔɔdnɛy, nyɛ eezɛni pɛ tɔ ndjaa, e di zukamwaa nɛ mot nazesɛɛga ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","É di'enek, nyɛ eezɛke nɛ nɔɔ náá: «Bi nɛ gu náá, mot dhaad mbyak eYuda ààgoka nɛ ɛbeya ɛsɔ, nɛghu, ɛtɔ́ tɔ mendjaa mɛ bot ɛ membyak mesis. Deenek, Zɛɛb eelyo mɛ náá, yɛ ààgoka náá, mɛ bee mot dáa mot mendi, nɛghu dáa mot di ààgoka nɛ Tɔ́a pɛ dáa lɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","É tɛp tak ɛ di náá, dáa bi djóo mɛ ɛ, mɛ ɛ́ boozyɛ ààbyen. Mɛ kwyɛl ɛ mɛ gu tɛp bi djóo mɛ kɔ ɛsu ɛ tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔɔdnɛy eezɛbɔɔza náá: «E moo mos ɛ nɛ mɛlu mɛlɛl, é ɛwala ɛ ɛlak wat, é mɛwala mɛlɛl bii kuku dwoo, mɛ nadi é djaala Zɛɛb pɛ ndjaŋ'am. Ka sɛka e di tak wat ɛ, dhiiti mot nɛ ekaad é na kas-kas eezɛtuula sok bhwoob'am. ");
INSERT INTO bkw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tin, nyɛ eezɛke nɛ nam náá: “Kɔɔdnɛy, Zɛɛb eegwak mendjaala mɔ, nyɛ eesiiza ghwyiikwyee yɔ dum nɛ bɛdjel ɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kyeeda bot pɛ Jafa, étɛp bɛ neekɛdjóo Simɔŋ Pyɛɛd. Nyɛ di ɛ pɛ dáa dhiiti mot din ɛ lɛ Simɔŋ, nyɛ sa ɛ mɛsa mɛ ekwood bɛtit, ndjaŋ'ɛ é ɛboŋ ɛ boo dii mɛsɔn.” ");
INSERT INTO bkw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","E di tak wat ɛ mɛ lwom bot bɛ kɛ ɛsaa wɔ, tin, wóó myaal ɛzyɛ. Nenak, bisɔ djas bis ɛ wak é mis mɛ Zɛɛb, étɛp bis neegwak etɛp ee Ghɛŋ lwom wɔ, wɔ zyɛ zɛlɛɛ bis ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pyɛɛd eezɛkan ɛlii nyɛy náá: «Nenak mɛ eezegu nɛ tsɛɛtsɛ náá, Zɛɛb kwyɛɛg bot djas ɛ́ tyɛ wat. ");
INSERT INTO bkw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Deenek, nyɛ kwyɛl ɛ bot djas, ye nakozo zo bɛ bot ɛ membyak me sis, zuka nɛ tak ɛ náá, mot di é duwal nyɛ, nɛ ɛkɛ tɔ epiki. ");
INSERT INTO bkw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tin, Zɛɛb naakyeed bhaadal lɛ pɛ dáa bot ɛ mbyak Yisalaɛl. Mbɛɛ Bhaadal tak ɛ egwyem nɛ Yezu Klisto mot di Ghɛŋ bot djas ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Bi nɛ gu sa napoo dhaa sok pɛ Ghalile ɛ, bhii tak pɛ kɔ Yude djas, Zaŋ natuud náá, “duwaka Zɛɛb”. ");
INSERT INTO bkw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Bi nɛ gu dáa nyɛ naasɛ́ɛ Yezu mot Nazalɛt nɛ ghwyil Sisim na Dɛɛ ɛ. Bi nɛ baagu dáa Yezu nadi kɛkɔ bɔs é ɛsa enɛm esa, nɛ ɛtsik ɛ bot djas ɛ nadi si bhel ɛ dim mot mɛkɔŋ ɔ. Etɛɛ náá, Zɛɛb nadi gyee nɛ nɛ lɔɔg wat. ");
INSERT INTO bkw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tin, bis ɛ bɛtyaasɛs etɛp ee nyɛ nasa pɛ kyee dik eYuda nɛ pɛ Yeluzalɛm ɛ. Bɛ nagó bema kɔ mɛlaaba. ");
INSERT INTO bkw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Deenek, Zɛɛb eebulal nyɛ tsik é ɛlu ɛ elɛl bhis ɛsyee. Nyee djɛ nyɛ ghwyil ɛlyaal nyel, ");
INSERT INTO bkw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ààkabɛ nɛ bot djas, nyɛ nazo lyaal ɛ́ nɛ bisɔ bot ɛ Zɛɛb naloozesɛɛ bis, bis di bɛtyaasɛs ɔ. Bis naadɛ edee nɛ mɛdii e di wat, bhis Zɛɛb nagomal nyɛ bhis ɛsyee ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nyɛ lwom bis ɛ, bis goola Mbɛɛ Bhaadal pɛ dáa bot ɛ membyak, nɛ ɛlyaal náá, ye ɛ́ nyɛy ɛ di mot Zɛɛb nasɛɛ étɛp nyɛ neepɛ́ɛ, bot ɛ di nɛ tsik nɛ bot ɛ nazegwyɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Bɛngoolel ɛ mɛkpa ɛ Zɛɛb djas naalii kɔ ɛsu ɛ lɛ, bɔɔ náá, mot aadum koŋ nɛ nɛ ɔ waabela ɛpelak ɛ mesyem mɛ, nɛ ghwyil din ɛ lɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bela tin Pyɛɛd dinaa é lii, Sisim na Dɛɛ eezɛsul kɔ bot ɛ nadi gwak etɛp ee nyɛ nadi lii ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Bot ɛ di dum koŋ nɛ Zɛɛb ɔ yii dhaad mbyak eYuda nazyɛ bɛ nɛ Pyɛɛd ɔ, naadiaadjoka ɛbuɛpe. Etɛɛ náá, bɛ nabee náá, Sisim na Dɛɛ Zɛɛb nadjɛ ɛ naasul dɔɔ nɛ kɔ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Etɛɛ náá, bɛ nadi gwak bɛ é lii membyak mesis, nɛ ɛduwal ɛ mɛnyɔ ɛ Zɛɛb. Tin, Pyɛɛd ɛ boozɛke náá: ");
INSERT INTO bkw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Mena ɛ nɛ ghwyil lu bot bak nenak náá, bɛ naduwa Zɛɛb tɔ mɛdii, dáa bɛ di náá, bee bela Sisim na Dɛɛ dáa menabɛlka ɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tin, wɔ gwaa nyɛ zɛlwom náá, bɛ duu bɛ Zɛɛb nɛ din ɛ Yezu Klisto. Bhii tak bɛ eezɛke nɛ nɛ náá, nyɛ kwyɛɛg ba mɛlu bɛ nɛ bɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bot ɛ lwoma nɛ bɔn nyɛɛg bɔɔ nadi pɛ Yude ɔ naazɛgwak náá, bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ naamyaal pe mɛkpa mɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dáa Pyɛɛd nasik pɛ Yeluzalɛm ɛ, eYuda ee nadi dum koŋ nɛ Zɛɛb ɔ moo tin é byak nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bɔɔ náá: «Wɔ eeni tɔ ndjaa ezibo, wɔ eekɛdɛ edee bi nɛ bɛ nɔɔ!» ");
INSERT INTO bkw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tin, Pyɛɛd ɛ boo zɛbaŋa bɛ mɛdjɛmɛdjɛ etɛp ee nadhaŋ ɛ djas. Nyɛ nalɛɛ ɛ́ náá: ");
INSERT INTO bkw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Mɛ di ɛ pɛ tɔ ghaada Jafa, mɛ nadi é djaala, e di tak mɛ eezɛdjem dhyam. Mɛ bee ɛ dhiiti sonok é sul pɛ kyee mɛ nadi ɛ. Ye nabɛ sonok é nɔŋel nɛ boo poba, mɛta é mɛghɔ mɛ tak ená, é dus tɔ gwoo sul é bɔs é bhaasam. ");
INSERT INTO bkw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mɛ eezɛgwyák tɔ tak “piii”, mɛ kabee ɛ, bɛtit di kɛ nɛ mɛko mɛná ɔ, bɛtit ɛ dik, nɛ bɛtit ɛ di nɛ epapa ɔ, zɛnɔɔ enen. ");
INSERT INTO bkw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Wɔ gwaa mɛ zɛgwak gwood wat é ke nɛ nam náá: “Wyɛla, Pyɛɛd, góa da wɔ ɛ́ dɛ!” ");
INSERT INTO bkw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tin, mɛ eezɛbɔɔza náá: “Ohoo ààbɛ! Ghɛŋ, etɛɛ náá, mɛ dinaa ààpaakodɛ sok sa etsi eYuda di lu ɛ, dɔɔ nɛ esee mendi dinaa ààpaakɛ tɔ nuub'am.” ");
INSERT INTO bkw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tinaak, gwood'enek eebaazɛgek, é ke tɔ gwoo náá: “Nàbeea sa mendi sa Zɛɛb ke náá, ye tok nɛ mendi ɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ye sɛɛ deenek tyee esok elɛl, bhii tak siaa tak eezɛbyet tɔ gwoo. ");
INSERT INTO bkw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Tin, é ɛwala tak wat, wɔ gwaa bot ɛlɛl zokazɛkum pɛ ndjaa mɛ nadi ɛ. Bɛ nadus ɛ pɛ ghaada Seezale, bɛ nadi esaa pɛ mɛ nadi e di ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sisim na Dɛɛ eezɛke nɛ nam náá, mɛ tɔ́ bis nɛ nɔɔ ààbem ba. Deenek, bɔn nyɛɛg bam bɛtɛn nɛ wat mɛ zyɛ nɛ nɔɔ wak'ak ɛ kɛkyeed mɛ pɛ Seezale. Bisɔ djas bis bɛ ɛ́ bis eeni tɔ ndjaŋ ɛ Kɔɔdnɛy. ");
INSERT INTO bkw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kɔɔdnɛy eezɛkaada bis dáa nyɛ nabee fofop eetyaa tetel tɔ ndjaŋ'ɛ, é lɛɛ nɛ nɛ náá: “Kyeeda bot pɛ Jafa, étɛp bɛ kɛ ɛdjóo Simɔŋ Pyɛɛd. ");
INSERT INTO bkw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mot tak ɛ waalɛɛ wɔ mɛpka mɛ di náá, wɔy nɛ bot ɛ mɛbyel mɔ djas ɛ waabela tsik nɛ ye ɛ́.” ");
INSERT INTO bkw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Tin, dáa mɛ nadi mɛ moo kan ɛlii ɛ, wɔ gwaa Sisim na Dɛɛ zɛsul kɔ lɔɔ, dáa ye nasul kɔɔ les é mɛkɛn ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tin, mɛ eezɛtaala sa Ghɛŋ nalɛɛ ɛ́: “Zaŋ naduu bot Zɛɛb ɛ tɔ mɛdii, yɛ kabɛ biyɔ ɔ, bi aaduwaa Zɛɛb ɛ tɔ Sisim na Dɛɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Deenek ɛ Zɛɛb nadjɛ bɛ mbi ɛkɛɛ ɛ tak wat nyɛ nadjɛka mena, é ghɛŋ mena namyaalka Ghɛŋ Yezu Klisto ɛ. Mam nadi zɛ, étɛp mɛ neebe mɛso nɛ Zɛɛb?» ");
INSERT INTO bkw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bhis bɛ nagwak etɛp binek djas ɛ, elyem bɔɔ djas eezɛsila, bɛ moo tin é duwal Zɛɛb é ɛke náá: «Ye ɛ́ tsɛɛtsɛ náá, Zɛɛb eebaadjɛ pe bot ɛ dii ààbɛ bot ɛ mbyak eYuda ɔ, ghwyil ɛ swoola mɛfulu mɔɔ, nɛ yii ɛbela tɛtɛ tsik.» ");
INSERT INTO bkw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tsik mezuk nasɛɛ é ghɛŋ Etiɛn nagóaa ɛ naasa náá, bot ɛ nadi dum koŋ nɛ Zɛɛb ɔ wyɛɛza. Bɛ naatɔ́ batakɛkum pɛ kyee dik Fenisi, pɛ ghola Siipɛlɛ, nɛ pɛ boo ghaada Antiɔs. Bela náá, bɛ nazo gegoola mɛkpa mɛ Zɛɛb ɛ pɛ dáa bot ɛ mbyak eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Bela tin náá, bɛdhiiti bot ɛ nadi é dum koŋ nɛ Zɛɛb ɔ yii Siipɛlɛ nɛ Silɛn ɔ naatɔ́ pɛ Antiɔs. Bɛ naalii nɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ, é goola bɛ Mbɛɛ Bhaadal ɛ Ghɛŋ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ghwyil ɛ Ghɛŋ nadi ɛ́ nɛ nɔɔ lɔɔg wat, é sa náá, zukamwaa nɛ mot naaswoola mɛfulu mɔɔ nɛ ɛdum nɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ye nabɛ ɛ bot ɛ zɛɛga mendjaala Yeluzalɛm naagwak menduk me tak. Bɛ ɛ́ boozɛlwom Bhaalnabhas pɛ Antiɔs. ");
INSERT INTO bkw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Dáa nyɛ nakum ɛ, tin, nyɛ eezɛbee dáa Zɛɛb nazesɛɛ bot ɛ di é dum koŋ nɛ Zɛɛb ɔ mɛtel ɛ, nyɛ eezɛmyaala. Bhii tak, nyɛ eezɛdjɛ bɛ mɛghaaz mɛ ɛwa lyem étɛp bɛ neewa zii ɛdu ɛ Ghɛŋ tɔ esosoob. ");
INSERT INTO bkw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bhalnabas nadi ɛ́ mbɛɛ mot. Sisim na Dɛɛ nɛ ɛdum ɛ koŋ nɛ Zɛɛb «tɔɔɔ» tɔ lɛ. Tin, wɔ gwaa zukamwaa nɛ mot zokamyaal ɛdu ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bhii tak Bhalnabas eezɛtɔ́ pɛ dɛl ɛ Talase kɛsaa Sɔl. ");
INSERT INTO bkw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bhis nyɛ nakabela nyɛ ɛ́, nyɛ ɛ́ bootɔ́ nɛ nɛ pɛ Antiɔs. Tin, bɔɔ bɛbá naazɛdhaa tu mbu tɔ zɛɛga mendjaala mɛ tak, e di'enek, bɛ naalyo bot ɛbuɛpe dum nɛ ɛdum ɛ koŋ nɛ Zɛɛb. Ye ɛ́ kɔ ghaada Antiɔs ɛ bot ɛ lwoma nakan ɛdjóoaa sok «eKeletyɛ». ");
INSERT INTO bkw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eghɛŋ tak, ye nabɛ ɛ, bɛngoolel ɛ mɛkpa ɛ Zɛɛb naazɛdus pɛ Yeluzalɛm tɔ́ pɛ Antiɔs. ");
INSERT INTO bkw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Dhiiti pak'ɔɔ, din ɛ lɛ nabɛ ɛ Aghabis, Sisim na Dɛɛ é pem nyɛ, nyɛ eezɛni é lɛɛ náá, boo za moo aatuula kɔ bɔs djas. Bela náá, mbi za tak naasɛɛ esok Kolood nadi mɛkoozi mɛ Lɔm ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tin, bɛdjekel eezɛgwakel náá, mot nɛ mot ɛ waadjɛ yɛ ba bim nyɛ aabela ɛ, étɛp ɛkyee bɔn nyɛɛg bɔɔ nadi pɛ Yude ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɛ nasaa ɛ deenek, wɔ gwaa bɛ zokakyeed esa binek pɛ dáa bɛpaa ɛ eYuda, é mɛmbɔ ɛ Bhaalnabhas bɛ nɛ Sɔl. ");
INSERT INTO bkw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Eghɛŋ tak, mɛkoozi Elood Aghilipa moo tin é tiigal bɛdhiiti bot ɛ zɛɛga mendjaala. ");
INSERT INTO bkw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nyɛy zokalwom bɛ gó Zak mɔn nyɛɛg ɛ Zaŋ nɛ pɛl. ");
INSERT INTO bkw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Deenek, dáa nyɛ nabee náá, eYuda naakwyɛl ye ɛ́, nyɛ eezɛlwom bɛ mɛt Pyɛɛd é ghɛŋ ɛbyoŋ ɛ emapa ee di ààwaaa leviid ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Elood eezɛlwom náá, bɛ mɛt nyɛ, da bɛ kɔɔl nyɛ é membok. Tin, nyɛ ɛ́ boodjɛ mɛsa mɛ ɛbaal ɛ nyɛ nɛ mɛdhuu mɛná esodja, é ɛdhuu ɛ wat, ye nabɛ ɛ nɛ esodja ená. Nyɛ nadi ɛ́ gek ɛ náá, nyɛ neepɛ́ɛ nyɛ emis mɛ bot bhis ɛbyoŋ ɛ Pak. ");
INSERT INTO bkw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tin, Pyɛɛd nadi ɛ́ kɔɔla tɔ ndjaa membok, deenek bot ɛ zɛɛga mendjaala nadi wa zii tɔ ɛdjaala ɛ Zɛɛb kɔ ɛsu ɛ lɛ ɛlyelɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Bela náá, dáa Elood nadi kwyɛl ɛpɛɛ nyɛ é mis mɛ bot ɛ, é pum Pyɛɛd nadi egɔ pak esodja ebá. Nyɛ nabɛɛ kɔla nɛ ekel e ghwooz ebá. Bɛbaalel ɛ ndjaa membok nadi ɛ́ tin é sum e di bɔɔ, é ɛbɛɛ ndjaa membok. ");
INSERT INTO bkw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kasɛka ɛ dhiiti fofop ɛ Ghɛŋ ngɔt eezɛtuula tin, tɔ dɛŋ moo tin «buweee» nɛ mɛkas. Tin, fofop eezɛkwyɛt nyɛ é bhaaz, nyɛ eezɛdjem nyɛ, nyɛy nɛ nɛ náá: «Lela ɛ djem, wyɛla!» Tin, wɔ gwaa ekel eghwooz nyɛ nakɔlaa nɛ yɛ é mɛmbɔ ɛ zokakwyit. ");
INSERT INTO bkw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Tin, fofop eezɛke nɛ nɛ náá: «Bɔta bhɛtɛ yɔ, da wɔ ɛ́ kɔl ekel e mɛpapa mɔ.» Pyɛɛd eezɛgwak nyɛ, bhii tak fofop eebaazɛbil náá: «Bɔta ndjookuwa yɔ da wɔ ɛ́ du mɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Wɔ gwaa Pyɛɛd zɛwyis tɔ membok, nyɛ moo tin é du fofop. Nyɛ nàbɛ ààgek náá, etɛp ee fofop nadi sa ɛ nabɛɛ etɛp é tsɛɛtsɛ. Nyɛ nagu ɛ náá, nyɛ tɔ dyam. ");
INSERT INTO bkw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bɛ eezɛdhaa sum di bɛbaalel yii mɛkɛn, bhii tak yii bhɔɔba, bɛ eezɛkum pɛ ɛbɛɛ membok nasael nɛ ghwooz ɛ. Ɛbɛ́ ɛ tak tuula ɛ kɔ ɛbɛsɛɛ ɛ dɛl. Ɛbɛ ɛ tak zokazɛdiiel nyɛ ɛmet é mis mɔɔ. Bɛ eezɛwyis, tin, bɛ eezɛtiila é gba, e di tak wat kasɛka ɛ fofop eezɛdiib nyɛ é mis. ");
INSERT INTO bkw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tin, Pyɛɛd eezɛsiiza sa nasɛɛ ɛ ɛnyɔɛpe, nyɛ ɛ́ boozɛke náá: «Wak nenak mɛ moo bee náá, ye ɛ́ tsɛɛtsɛ. Ghɛŋ eedhis fofopɛ, nyɛ eepɛk mɛ é ghwyil ɛ Elood, nɛ mezuk mɛ bot ɛ mbyak eYuda di kwyɛl náá, mɛ bee ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Dáa nyɛ nazegwyak di nyɛ nadi ɛ, nyɛ ɛ́ boozɛtɔ́ pɛ ndjaŋ ɛ Maali, nyɛɛg ɛ Zaŋ mot tak nagetaa ɛ «Malak» ɔ. Tin, bɛtɛ nɛ bot naasɛɛga étɛp ɛdjaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pyɛɛd eezɛdiig é ɛbɛ ɛ ndjaa, tin, moma mɛsa ngɔt eezɛzyɛ, étɛp nyɛ neezɛdii ndjaa. Din ɛ moma tak nabɛ ɛ Lood. ");
INSERT INTO bkw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nyɛ eezɛgwyak gwood ɛ Pyɛɛd, nyɛ moo tin tɔ mɛmyaala. Ye waagoka náá, nyɛ kaa dii ndjaa, nyɛy ka sik ɛ kaab kɛlɛɛ bot tɔ ndjaa náá, Pyɛɛd ɛ pɛ kel. ");
INSERT INTO bkw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bɛ eezɛbɔɔza nɛ nɛ náá: «Wɔɔ pe lyet!» Tin, nyɛ eezɛbasal náá, ye ɛ́ tsɛɛtsɛ. É di'enek bɛ eezɛke náá: «Ye ɛ fofop'ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Tinaak, Pyɛɛd kuku ɛdiig ɛ yenek, dáa bɛ nakazɛdii ndjaŋ ɛ, bɛ eezɛbee nyɛ, bɛ naadiaadjoka ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nyɛ eezɛlyak bɛ nɛ mbɔ náá, bɛ di gwyem. Bhii tak, nyɛ eezɛni é lɛɛ bɛ dáa Ghɛŋ nawyisal nyɛ é membok ɛ. Nyee baazɛke náá: «Lɛɛka Zak nɛ bɛdhiiti bɔn nyɛɛg bina sa dhaŋ ɛ.» Bhii tak nyɛ eezɛwyis tɔ́ pɛ kyee sis. ");
INSERT INTO bkw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Dáa mɛlem nakalem ɛ, esodja moo tin zɛɛzɛm pak'ɔɔ. Bɛ nadi é djinel pɛ pak Pyɛɛd natɔ́ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elood eezɛlwom bot náá, bɛ kɛnɔɔ nyɛ, tin, bɛ ààpakabela nyɛ. Bɛ eezɛdji bɛbaalel ɛ ndjaa membok, tin, nyɛ boodjɛ bɛ ɛlee náá, bɛ gó bɛ. Bhii tak, Elood eezɛtɔ́ pɛ kyee dik Yude, pɛ Seezale penek nyɛ naasa ba bim mɛlu. ");
INSERT INTO bkw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elood naadyeebakpaa lyem nɛ bot Tiid nɛ Sidɔn. Tin, bot ɛ tak ɛ boo zɛgwakel náá, bɛ tɔ́ pɛ dáa lɛ. Ye nabɛ ɛ bee gwakel nɛ Balastus. Nyɛ nadi ɛ́ kukuma di é sa mɛsa tɔ ndjaŋ mɛkoozi ɔ. Tin, bɛ eezɛtɔ́ kɛlɛɛ nɛ Elood náá, ɛgwakel bula bɛ nɛ bot ɛ eghaada e tak etɛɛ náá, edee ee bot binɔk nadi dedɛ ɛ nadudus ɛ pɛ mɛl ɛ Elood. ");
INSERT INTO bkw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Dáa ye nakum dwoo tak ɛ, Elood eezɛbɔt kaad mɛkoozi mɛ, nyɛ eezɛdisi kɔ boo mɛkoozi mɛ. Tin, nyɛ eezɛni é lii nɛ nɔɔ é mis mɛ mɛdhuu mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mɛdhuu mɛ bot binɔk eezɛtsim náá, «Yɛ zɛɛb ɛ di lii, ààkabɛ mot!» ");
INSERT INTO bkw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tin, e di tak wat, wɔ gwaa fofop ngɔt ɛ Ghɛŋ zokazɛdjɛ Elood baka, etɛɛ náá, nyɛ naakwyɛl ɛnɔɔ duu di ye ɛ́ Zɛɛb ɛ. Elum zokazɛdɛ nyɛ nyel, nyɛy batagwyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ghuna, mɛkpa ɛ Zɛɛb nadi é goola, ɛgoolel nɛ ɛgoolel. ");
INSERT INTO bkw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Yɛ kabɛ Bhaalnabhas bɛ nɛ Sɔl ɔ, bhis bɛ nasilal lwomelɔ pɛ Yeluzalɛm ɛ, bɛ eezɛsik, tin, bɛ ka tɔ́ ɛ nɛ Zaŋ mot nagetaa din ɛ Malak ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pɛ tɔ zɛɛga mendjaala Antiɔs ye nabɛ ɛ́ nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb, nɛ bɛlyoel, ye nabɛ ɛ́: Bhaalnabhas, Simɛyɔŋ mot nagetaa nɛ din ɛ na «dhɔɔ mot» ɔ, Lusius mot dɛl ɛ Silɛn, Manaɛn sɔ ɛ Elood kana edhɔma, zɛnɔɔ Sɔl. Eghɛŋ tak, Elood ɛ nadi kɔk kɔ Ghalile. ");
INSERT INTO bkw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Dhiiti dwoo, é ghɛŋ bɛ nadi tɔ mendjaala nɛ tɔ ɛtsi edee étɛp mendjaala ɛ, Sisim na Dɛɛ eezɛke nɛ nɔɔ náá: «Sɛ́ɛka mɛ Bhaalnabhas bɛ nɛ Sɔl, étɛp bɛ neekɛsa mɛsa mɛ mɛ nadjóo bɛ étɛp tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","É di'enek, bhis bɛ nazedjaala nɛ ɛtsi edee étɛp mendjaala ɛ, bɛ eezɛkɛl bɛ mɛmbɔ, bhii tak bɛ eezɛbet bɛ, bɛ tɔ́. ");
INSERT INTO bkw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Dáa Sisim na Dɛɛ nalwom bɛ ɛ, bɛ eezɛtɔ́ pɛ ɛboŋ Seleesi, pɛ bɛ nazɛni tɔ boo elɛɛd étɛp bɛ neetɔ́ pɛ ghola Siipɛlɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Dáa bɛ na kum pɛ dɛl ɛ Salamin ɛ, bɛ eezɛni é goola mɛkpa ɛ Zɛɛb tɔ mendjaa mɛ mendjaala mɛ eYuda. Bɛ nadi ɛ́ bɛ nɛ Zaŋ Malak étɛp nyɛ neegheekwyi-kwyee bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bɛ naazɛkɛ kɔ pes ghola tak djas kɛkum pɛ dɛl ɛ Pafɔs. Penek bɛ eezɛboma nɛ dhiiti mot mɛsimba mɛ ɛlyeeb, din ɛ lɛ ɛ Baad-Yezu, mot dhaad mbyak eYuda nadi eke náá, nyɛ ɛ́ ngoolel-mɛkpa ɛ Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nyɛ nadidi ɛ́ pɛ dáa kukuma dɛl, din ɛ lɛ ɛ Seedgyus Polus, nyɛ nadi ɛ́ mot ɛtselal. Wɔ gwaa mot tak zɛdjóo Bhaalnabhas bɛ nɛ Sɔl, etɛɛ náá, nyɛ nadi kwyɛl ɛgwak mɛkpa ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Tin, tɔ dhaad mbyak eghɛlɛk, Elimas kwyɛl ɛ lɛ ɛ: «Mot mɛsimba mɛ ɛlyeeb». Nyɛ eezɛni é suu mɛso nɛ nɔɔ, nyɛ moo tin é saa náá, kukuma nàdum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tin, Sɔl mot nabaadi é djóoaa Pɔl ɔ, moo tin «tɔɔɔ» nɛ Sisim na Dɛɛ, nyɛ eezɛgwyák nyɛ «kpɛɛɛ». ");
INSERT INTO bkw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Bhii tak, nyɛ eezɛke náá: «Mot mɛkɔŋ nɛ embee esa, mɔɔ dim mot mɛkɔŋ, mot byen embɛɛ esesɛɛ! Wɔ aanàkwaaboo kat ɛlet ɛ mɛze ɛ Ghɛŋ e! ");
INSERT INTO bkw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nenak, gwaka: Ghɛŋ ɛ waadjɛ wɔ baka, wɔ waabɛ edhim, wɔ aanàkabaabee mɛkas mɛ gwyes é ba bim mɛlu.» E di tak wat, mis ɛ Elimas eezɛdipel, nyɛ moo tin tɔ ghooghom: Nyee moo tin bako-bako é liigel é gwyák é mengwoob djas, nyɛ nadi esaa mot, étɛp nyɛ neemɛt nyɛ é mbɔ, étɛp ɛ lyaal ɛ nyɛ ze. ");
INSERT INTO bkw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Dáa kukuma nabee sa nadhaŋ ɛ, nyɛ eezɛdum koŋ nɛ Zɛɛb, etɛɛ náá, ye nabɛɛ mɛlyo naadyeebakwyɛsa nyɛ tɔ lyem ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl bɛ nɛ bot ɛ sama yɛ eezɛni tɔ boo elɛɛd pɛ Pafɔs, bhii tak bɛ eezɛtɔ́ pɛ Panfili kɔ ghaada Pɛɛdje. É di'enek, Zaŋ Malak ɛ boo zɛlik bɛ, sik pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bɛ eezɛdus Pɛɛdje, goola tɔ́ pɛ Pisidi kɔ ghaada Antiɔs. Dwoo saba, bɛ naazɛni tɔ ndjaa mendjaala mɛ eYuda, bɛ eezɛnɔɔ mɛnyel disi. ");
INSERT INTO bkw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bhis bɛ laa tɔ mɛkana mɛ etsi nɛ yii bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɛ, ekukuma e ndjaa mendjaala mɛ eYuda ɛ́ boolwom bot bɛ, bɛ lɛɛ nɛ nɔɔ náá: «Bɔn ɛ nyɛɛg, bi ɛ di nɛ etɛp ɛlii nɛ bot ɛ zɛɛga étɛp ye needjɛ bɛ mɛghaaz nɛ zii ɔ, bi ɛ nɛ ghwyil ɛ lii nenak.» ");
INSERT INTO bkw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tin, wɔ gwaa Pɔl zɛwyɛl, nyɛ eezɛsa dhiiti tseŋa nɛ mbɔ bɛ di gwyem, nyɛ eezɛke náá: «Biyɔ bot ɛ Yisalaɛl, nɛ biyɔ bot ɛ zyɛ é mendjaala mena zɛdjaalaka Zɛɛb'ak gwakeka mɛ! ");
INSERT INTO bkw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Zɛɛb bot ɛ mbyak Yisalaɛl naatɔ́ bɛbhaab bena. Nyɛ naasa náá, mɛtaŋ mɛ bot byet esok bɛ nadi é mɛdjoŋ pɛ Eziptɛ ɛ. Bhii tak, nyɛ naazɛwyisal bɛ kɔ kyee dik tak nɛ ghwyil mɛbwala. ");
INSERT INTO bkw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nyɛ naadiaamaad ebus bɔɔ membu mɛkam-mɛná bɔɔ tɔ bal. ");
INSERT INTO bkw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Bhii tak, nyɛ eezɛsilal bot ɛ membyak mɛtɛn nɛ ebá pɛ kyee dik Kana “bɛɛɛ”. Nyɛ eezɛnɔɔ mɛdhik mɛ tak djɛ nɛ bot ɛ mbyak'ɛ bɛ di bɛkum ɛ tak. ");
INSERT INTO bkw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Deenek ye naasa tyee membu bɛdhet-ɛná nɛ membu mɛkam-mɛtɛn (450). «Bhii tak nyɛ eezɛdjɛ bɛbhaab bina bɛtetɛp kɛkum é ghɛŋ membu ɛ ngoolel-mɛkpa ɛ Zɛɛb Samyɛl. ");
INSERT INTO bkw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bhii tak, bɛ eezɛwaab náá, Zɛɛb djɛ bɛ mɛkoozi. Tin, nyɛ ɛ́ boozɛdjɛ bɛ Sɔl mɔɔ Kis mot dhaad mbyak'ɛ Bɛɛzamɛ. Sɔl tak naadi kukuma yɔɔ membu mɛkam-mɛná. ");
INSERT INTO bkw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bhis nyɛ naka zɛbyen Sɔl ɛ, Zɛɛb ɛ́ boozɛdjɛ bɛ Dhavid, nyɛ di mɛkoozi mɔɔ. Nyɛ nabɛɛ nyɛ eeke kɔ ɛsu ɛ lɛ náá: “Mee bela Dhavid mɔɔ Yese, mot tak ɛ mot lyem'am kwyɛl ɔ. Nyɛ waasa esa ee lyem'am di kwyɛl ɛ djas.” ");
INSERT INTO bkw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ngɔt tɔ bɛdha ɛ Dhavid nabɛ Yezu, mot Zɛɛb nanɛɛg nyɛ dáa mɛtsik-bot étɛp dhaad mbyak Yisalaɛl, dáa nyɛ nakɛk ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ɛsok nɛ Yezu nɛ zyɛ, ye nabɛɛ Zaŋ naagoola mɛkpa ɛ Zɛɛb nɛ membyak djas yii Yisalaɛl, etɛɛ náá, bɛ neeliig elyem bɔɔ da bɛ duwa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eghɛŋ Zaŋ nadi nyɛ moo pɛ ɛsik ɛ mɛsa mɛ ɛ, ye nabɛ ɛ nyɛ naake náá: “Bi gek náá, mam ɛ́ zɛ? Mam tok mot bi di bwood ɔ. Tin, gwakeka: Nyɛ ɛpezyɛ bhis koŋam, bela tin náá, mɛ tok nɛ ghwyil ɛ bela duu ɛtii-tiiak ekel é ekoko é mɛko mɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Mɔn nyɛɛg, biyɔ bɛdha ɛ Abalaam, nɛ biyɔ bot ɛ zyɛ wak étɛp ɛ zɛdjaala Zɛɛb ɔ: Ye ɛ́ kɔ ɛsu ɛlenaka ɛ bhaadal étɛp tsik enek nadi esaa. ");
INSERT INTO bkw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nɛ tsɛɛtsɛ, bot ɛ dɛl ɛ Yeluzalɛm nɛ ekukuma bɔɔ nabaa gu mbi mot Yezu nadi ɛ. Bela náá, bɛ àànyɔ ɛgwak mɛkpa ɛ Zɛɛb di laŋaa dwoo esaba djas ɛ. Tin, bɛ naadjɛ Yezu epɛ́ɛ é ɛsyee, etɛɛ náá, mɛkpa menek neebela mɛsuk. ");
INSERT INTO bkw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Baabela náá, bɛ nàbɛ ààbela mɛsɔ mɛ nyɛ pɛɛaa epɛ́ɛ é ɛsyee tɛp tak ɛ, bɛ naake nɛ Pilat náá, nyɛ gó nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bhis bɛ nazesa etɛp djas ekwyala ɛ Zɛɛb nalɛɛ kɔ ɛsu ɛ lɛ ɛ, bɛ eezɛsil nyɛ kɔ mɛlaaba, bhii tak, bee kɛnɛɛg nyɛ tɔ ɛvit. ");
INSERT INTO bkw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wɔ gwaa Zɛɛb zɛgomal nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Mɛlu ɛbuɛpe Yezu nadi elyaal bot ɛ nadi egyee nɛ nɛ ɔ nyel, dusa pɛ Ghalile ɛtɔ́ pɛ Yeluzalɛm. Bot ɛ tak moo mos ɛ bɛtyaasɛs é mis mɛ bot ɛ mbyak Yisalaɛl. ");
INSERT INTO bkw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bisɔ bɛ ɛmet, bis ɛpezɛgoola bin Mbɛɛ Bhaadal. Mbɛɛ Bhaadal tak ɛ sa Zɛɛb nakɛk bɛbhaab binaka ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Nyɛ nasa deenek ɛ kɔ ɛsu ɛ lena bɛdha bɔɔ, nyɛ naagomal Yezu bhis ɛsyee. Ekwyala lɛɛ ɛ tɔ mɛkana mɛ Mɛdjeeb ɛlaŋel ebá ɛ náá: «Ye ɛ́ wɔy ɛ di mɔn'am, kana dwoo pan mos'ak mɛ Soog.» ");
INSERT INTO bkw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Zɛɛb nabɛɛ ɛ nyɛ eelɛɛ náá, nyɛ waagomal nyɛ bhis ɛsyee, étɛp nyɛ needi ààsik kɛbɔ. Nyɛ nake ɛ náá: «Mɛ waasɛɛ bin tɛtɛ mɛtel mɛ edɛɛ, yii etsɛɛtsɛ mɛ nakɛk Dhavid ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«É tɛp tak ɛ nyɛ di baalɛɛ tɔ dhiiti ekwyala náá: “Wɔ aanàkwaabet náá mot'ɔ na Dɛɛ kɛsyep tɔ ɛvit.” ");
INSERT INTO bkw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Eghɛŋ ɛ Dhavid, ye nabɛɛ nyɛ naasa etɛp ee Zɛɛb nadi kwyɛl ɛ. Bhis nyɛ naka gwyɛ, nyɛ nakɛ delaa ɛ é ngwoob bɛbhaab bɛ, ye nabɛ ɛ nyɛ naabɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ghuna, mot Zɛɛb nagomal ɔ nàbɛ ààbɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Bɔn nyɛɛg, egoka ɛ bi gu náá: ye ɛ́ kɔ ɛsu ɛ Yezu ɛ nalɛɛaa ɛpelak ɛ mesyem min. Ye ɛ́ kɔ ɛsu ɛ lɛ di náá, bot djas aadum koŋ nɛ nɛ ɔ waapɛkel tɔ bhel mesyem djas. Mɛpɛkel mɛ tak tok nɛ ghwyil ɛ bɛlel tɔ ɛduwal etsi ɛ Moiiz. ");
INSERT INTO bkw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bɛɛka mis, etɛɛ náá, etɛp ee bɛngoolel ɛ mɛpka ɛ Zɛɛb nakwyal ɛ needi ààsael nɛ biyɔ bɛ ɛmet. ");
INSERT INTO bkw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Beeka biyɔ bot ɛ ɛbet! Djokaka, da bi ɛ dus mɛ emis, etɛɛ náá, e mɛlu mɛ tsiken, mɛ waasa dhiiti dem di náá, mot ɛ kaada bin yɛ ɔ, bi aanàkwaamyaal ɛ!”» ");
INSERT INTO bkw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Dáa Pyɛɛd bɛ nɛ Bhalnabas nawyis tɔ ndjaa mendjaala ɛ, bɛ eezɛke nɛ nɔɔ náá, bɛ baabula yii saba poon étɛp bɛ neebaazɛlyo bɛ mɛkpa mɛ tak wat. ");
INSERT INTO bkw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bhis zɛɛga tak, bɛtɛ nɛ eYuda nɛ bot ɛ nazemyaal ɛdjaala Zɛɛb eYuda ɔ zokazɛdu Pɔl bɛ nɛ Bhaalnabhas. Bɛ nadi lii nɛ nɔɔ, nɛ ɛdjɛ bɛ mɛghaaz mɛ ɛdi bɛsosoob si esɛɛa mɛtel ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Dáa ye nakum yak dwoo saba ɛ, wɔ gwaa bot tyee, yɛ aasa-saa bot ɛ dɛl djas zɛsɛɛga, étɛp bɛ neezɛgwak mɛkpa ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Dáa eYuda nabee mɛdhuu mɛ bot binɔk ɛ, ye nakpaa bɛ elyem. Bɛ moo tin é let etɛp ee Pɔl nadi lii ɛ, tin, bɛ eezɛlee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pɔl bɛ nɛ Bhaalnabhas eezɛlɛɛ bɛ nɛ lyem wat náá: «Ye bɛ ɛ́ yɛ eegoka náá, mɛkpa ɛ Zɛɛb pookoko goolaa sok pɛ dáa len. Dáa di náá, bi ɛpebyen ye ɛ́, nɛ dáa bi di bee náá, tsik na kɔm-kɔm tok dhiiti vaŋ sonok é mis min ɛ, hakiba, bis ka tɔ́ pɛ dáa bot ɛ di ààdi bot ɛ mbyak eYuda ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Beeka dáa Ghɛŋ nake nɛ nes ɛ, “Mee nɛɛg wɔ dáa ngel étɛp membyak djas, étɛp wɔ neetɔ́ bɛ nɛ tsik kɛkum pɛ edum e bɔs!” » ");
INSERT INTO bkw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Dáa bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ nagwak deenek ɛ, bɛ naamyaala. Bhii tak bɛ moo tin é duwal mɛkpa ɛ Ghɛŋ. Tin, bot djas nazesɛɛaa étɛp bɛ neebela tsik na kɔm-kɔm ɔ eezɛliig elyem bɛ moo du Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Mɛkpa ɛ Ghɛŋ nadi goola ɛgoolel nɛ ɛgoolel kɔ kyee dik'enek djas. ");
INSERT INTO bkw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Tin, eYuda eezɛbesal bɛdhil ɛ boa di bɛkum ɔ nadi duwal Zɛɛb ɔ, nɛ bɛdhil ɛ botom ɛ ghaada, étɛp bɛ neewa Pɔl bɛ nɛ Bhaalnabhas tɔ tsik mezuk. Bhii tak, bɛ eezɛsɔ bɛ kɔ kyee dik'ɔɔ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bot ɛbá binɔk ɛ boo zɛkut epiib é mɛko mɔɔ étɛp ɛdul ɛ bɛ mɛlɔ, bhii tak bɛ eezɛtɔ́ pɛ dɛl ɛ Ikoniɔm. ");
INSERT INTO bkw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yɛ kabɛ bɛdjekel pɛ bɛ nadi pɛ Antiɔs ɔ, bɛ nadi ɛ́ tɔ boo mɛmyaala nɛ Sisim na Dɛɛ tɔ lɔɔ na «tɔɔɔ». ");
INSERT INTO bkw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔl bɛ nɛ Bhalnabas naabaazɛni tɔ ndjaa mendjaala mɛ eYuda, tin, mɛlyo mɛ bɛ nadi lyo bot ɛ naasa náá, bɛtɛ nɛ bot ɛ mbyak eYuda nɛ bot ɛ nadi ààbɛ bot ɛ mbyak eYuda ɔ, dum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tin, bot ɛ mbyak eYuda nabyen ɛdu ɛ Zɛɛb ɔ zokaful bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ elo, étɛp bɛ neebhina bɔn nyɛɛg bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Deenek, Pɔl bɛ nɛ Bhalnabas naadi mɛlu ɛbuɛpe pɛ dɛl ɛ Ikoniɔm. Bɛ nadi elii-lii ɛ nɛ eghɛŋ djas, zɛnɔɔ ɛbwaalel nɛ Ghɛŋ. Ghɛŋ nadi djɛ bɛ ghwyil ɛsa endem e mɛbwala, deenek, étɛp ɛlyaal etsɛɛtsɛ etɛp ee bɛ nadi lyo bɛ dum nɛ mbɛɛ lyem enɛm esa e Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tin, bot ɛ dɛl zokazɛbɛka: ɛdhuu ɛ wat kyee bot nadi du eYuda ɔ, yak ɛdhuu kabɛ ɛ bot ɛ nadi du bot ɛ lwoma ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bot ɛ mbyak eYuda, nɛ bot ɛ di ààbɛ bot ɛ mbyak eYuda ɔ, nɛ bɛ mɛkoozi mɔɔ nadi gwakel étɛp bɛ neezuk Pɔl bɛ nɛ Bhalnabas da bɛ ɛ́ gó bɛ nɛ mɛkok. ");
INSERT INTO bkw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Dáa bot ɛbá tak nagwak ɛ, wɔ gwaa, bɛ zɛkaab tɔ́ pɛ mɛl mɛ Listɛ nɛ Dɛlɛɛb, eghaada é kyee dik Likaoni, nɛ mɛl mɛ di é mengwoob ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kɔ mɛl mɛ tak, bɛ eezɛni é baagoola Mbɛɛ Bhaadal. ");
INSERT INTO bkw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pɛ kɔ ghaada Listɛ, ye nabɛ nɛ dhiiti mot nadi ààbɛ nɛ ghwyil ɛ tyaa tetel ɔ, etɛɛ náá, mɛko mɛ nadi esɔɔbela. Nyɛ nadi ɛ́ boka kana edhɔma bɛ, nyɛ nabɛɛ ààbɛ nɛ ghwyil ɛkɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nyɛ nadi gwak etɛp ee Pɔl nadi lii ɛ. Tin Pɔl eezɛgwyák nyɛ «piii», nyɛ eezɛbee náá, ɛdum ɛ koŋ ɛ lɛ nɛ Zɛɛb ɛ waasa náá, mot tak bela tsik. ");
INSERT INTO bkw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nyɛ eezɛben gwood, zɛke nɛ nɛ náá: «Wyɛla, tyaŋa tetel nɛ mɛko mɔ met!» Vasaka mot'enɔk eezɛtyaa tetel, nɛ mɛko mɛ, nyɛ moo tin é kɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dáa mɛdhuu mɛ bot nabee sa Pɔl nasa ɛ, bɛ eezɛtsim tɔ dhaad mbyak ɔ, din ɛ lii tak ɛ Likoniɛ, bɔɔ náá: «Bɛzɛɛb eenɔɔ mɛnyel mɛ bot, tin, bee sul pɛ pak mena dika ɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wɔ gwaa bɛ zɛget Bhaalnabhas din ɛ «Zees», bɛ ka get Pɔl ɛ «Hɛɛdmɛs», etɛɛ náá, Pɔl nadi ɛ́ ngoola-ngoola. ");
INSERT INTO bkw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ndjaa zɛɛb ɛ Zees nadi é ɛniel ɛ dɛl. Wɔ gwaa ghaa-zɛɛb ɛ Zees zokazyɛ nɛ engɔmbɛ ee bɛ nazekomsa nɛ epyeeda e mɛzɛm mɛ ele bɛ napyeed ɛ, é ɛbɛɛ ndjaa zɛɛb tak. Bɛ nasa deenek ɛ étɛp bɛ needjɛ Pɔl bɛ nɛ Bhalnabas ebuwa. ");
INSERT INTO bkw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tin, dáa bot ɛ lwoma binɔk bɛbá nagwak menduk mɛ tak ɛ, bɛ eezɛnyaa ekaad bɔɔ. Bhii tak, bɛ eezɛlel ɛni tɔ ɛdhuu ɛ bot é tuud náá: ");
INSERT INTO bkw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Bɛwɛn, bi sa deenek étɛp ye? Bis ɛ bot, dáa biyɔ. Bis zɛgoola bin ɛ Mbɛɛ Bhaadal, bis ke nɛ nen ɛ naabi bet ɛduwal ekpaka-kpaka nɛ elula-lula ye tok dhiiti vaŋ sonok. Duka Zɛɛb di nɛ tsik ɔ, mot nakus gwoo nɛ bɔs, boo dii mɛsɔn nɛ esa ee di tɔ tak ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","É membu me nadhaŋ'enek, ye nabɛ nyɛ nabet náá, membyak nɛ membyak sa esa ee elyem bɔɔ di kwyɛl ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bela náá, nyɛ nadi é nye-nyen tɔ bot nɛ enɛm esa nyɛ di sa ɛ. Nyɛy tɔ gwoo, nyɛ ɛpedis bin bɛbhi, étɛp ye neesa náá, bhek nɛ bhek kwyil é yɛ mbu, nyɛ pe djɛ bin edee, nɛ ɛlwoodal elyem bin nɛ mɛmyaala.» ");
INSERT INTO bkw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bɛ nagu zo lii deenek, ye nabɛ ɛ ɛlyelɛpe nɛ bot ɛ lwoma bɛ lyak ɛdhuu bot binɔk bɛ nàdjɛ bɛ buwa. ");
INSERT INTO bkw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bhii tak, eYuda eezɛzyɛ pɛ Antiɔs é Pisidi nɛ pɛ Ikoniɔm, tin, elii bɛ nalii nɛ mɛdhuu mɛ bot ɛ naasa náá, bɛ kwyɛl bɛ. Wɔ gwaa Pɔl zɛwusaa nɛ mɛkok étɛp nyɛ neegóaa, bhii tak bɛ eezɛwyisal nyɛ kɔ dɛl, bɛ nadi gek ɛ náá, nyɛ eezegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tin, dáa bot ɛ di edum koŋ nɛ Zɛɛb ɔ nazɛsɛɛga é ngwoob'ɛ, nyɛ eezɛwyɛl, bhii tak nyɛ eezɛsik tɔ ghaada. Djɛmɛn tak, nyɛ eezɛtɔ́ pɛ dɛl di djóoaa Dɛlɛɛb bɛ nɛ Bhaalnabhas. ");
INSERT INTO bkw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pɔl bɛ nɛ Bhaalnabhas nadi goola Mbɛɛ Bhaadal pɛ kɔ dɛl ɛ Dɛlɛɛb. Tin, bɛ naabela bɛdjekel ɛbuɛpe. Bhii tak, bɛ eezɛsik pɛ Listɛ, pɛ Ikoniɔm pɛ Antiɔs kyee Pisidi. ");
INSERT INTO bkw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bɛ nadi djɛ ghwyil nɛ bot ɛ namyaal ɛ du Zɛɛb ɔ, bɛ nadi djɛ bɛ mɛghaaz mɛ ɛwa zii tɔ ɛdum ɛ koŋ nɛ Zɛɛb, bɛ nadi eke ɛ náá: «Mena goka ka ɛ nɛ kpaa tɔ boo tsik mezuk étɛp mena neenika tɔ Ɛyoŋ ɛ Zɛɛb.» ");
INSERT INTO bkw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pɛ tɔ mendjaa mɛ mendjaala djas, bɛ nadi sɛɛ bɛpaa. Deenek bhis mendjaala nɛ ɛtsi edee étɛp mendjaala, bɛ nadi djɛ bɛ ebotan e Ghɛŋ bɛ nadum koŋ nɛ nɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bɛ eezɛdhaa Pisidi kɛkum pɛ kyee dik Panfili. ");
INSERT INTO bkw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bɛ naagoola Mɛkpa mɛ Zɛɛb pɛ ghaada Pɛɛdje, bhii tak, bɛ eezɛtɔ́ pɛ ghaada Atali. ");
INSERT INTO bkw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Dusa tin, bɛ eezɛnɔɔ mɛsuwa tɔ́ pɛ Antiɔs pɛ kyee Siili, ghaada bɛ nadjɛ bɛ ebotan ɛ Zɛɛb étɛp lwomel bɛ nagoka nɛ sa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Dáa bɛ nakakum pɛ Antiɔs ɛ, bɛ ɛ́ boo zɛsɛɛg bot ɛ zɛɛga mendjaala mɛ tak djas. É di'enek, bɛ boo zɛbaŋa bɛ esesɛɛ djas Zɛɛb nasa nɛ nɔɔ ɛ, nɛ dáa Zɛɛb nadjɛ pe bot ɛ di ààdi bot ɛ mbyak eYuda ɔ ghwyil ɛdum koŋ nɛ Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Deenek, Pɔl bɛ nɛ Bhalnabas naadi ba mɛlu ɛbuɛpe bɛ nɛ bɛdjekel ɛ dɛl ɛ Antiɔs. ");
INSERT INTO bkw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bɛdhiiti bot naazɛdus pɛ kyee dik Yude, tɔ́ pɛ Antiɔs, tin, bɛ moo tin é lyo bɔn nyɛɛg náá: «Bi ɛ di ààsa beka, dáa etsi ɛ Moiiz di lɛɛ, bi aanàkwaabela tsik.» ");
INSERT INTO bkw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl bɛ nɛ Bhalnabas zokazɛbela boo zyaala dum nɛ tɛp tak, bɛ ɛ́ boo zɛgwakel náá, Pɔl bɛ nɛ Bhaalnabhas, nɛ bɛdhiiti bot ɛ dɛl ɛ Antiɔs, waatɔ́ pɛ Yeluzalɛm étɛp ɛkɛkoobal etɛp é tak bɛ nɛ bot ɛ lwoma nɛ bɛpaa. ");
INSERT INTO bkw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Wɔ gwaa bot ɛ zɛɛga mendjaala mɔɔ zɛdjɛ bɛ esa djas nadi egoka étɛp ɛtɔ́ mɛdjoŋ nɛ yɛ ɛ, bɛ eezɛghɛɛ tɔ́, bɛ eezɛdhaa kyee dik Fenisi nɛ Samali, bɔɔ é baŋa bot dáa bot ɛ di ààdi bot ɛ mbyak eYuda ɔ nazeliig elyem, du Ghɛŋ ɛ. Bhaadal tak nadyeebadjɛ boo mɛmyaala nɛ bɔn nyɛɛg djas. ");
INSERT INTO bkw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Dáa bɛ nakakum pɛ Yeluzalɛm ɛ, bɛ eezɛsulal pɛ dáa bot ɛ zɛɛga mendjaala, bot ɛ lwoma nɛ bɛpaa naazɛswos bɛ nɛ mɛ myaala. Bɛ ɛ́ boo zɛbaŋa bɛ etɛp ee Zɛɛb nadi sesa nɛ bot dum nɛ nɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tin, bɛdhiiti bot tɔ sama ɛdhuu eFalizyɛ nazedum koŋ nɛ Zɛɛb ɔ ɛ boozɛwyɛl, bɛ eezɛke náá: «Egoka náá, bot ɛ di ààdi bot ɛ mbyak eYuda nadum koŋ nɛ Zɛɛb ɔ, niigelaa beka. Bhii tak, da bi ɛ́ lɛɛ bɛ náá, bɛ duwal etsi ɛ Moiiz.» ");
INSERT INTO bkw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tin, bot ɛ lwoma nɛ bɛpaa zokazɛsɛɛga étɛp ɛdjek tɛp tak. ");
INSERT INTO bkw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bhis bɛ nazesɔs tɛp tak ɛbuɛpe ɛ, Pyɛɛd é zɛnɔɔ lii nyɛy náá: «Bɔn ɛ nyɛɛg, bi nɛ gu náá, Zɛɛb naalootɔ́ mɛ pak'en étɛp mɛ neegoola Mbɛɛ Bhaadal pɛ dáa bot ɛ di ààdi bot ɛ mbyak eYuda ɔ bɛ neegwak, bhii tak da bɛ ɛ́ dum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Deenek, Zɛɛb mot di gu elyem ee bot ɔ eelyaal náá, nyɛ eemyaal bɛ, nyɛ eedjɛ bɛ Sisim na Dɛɛ dáa menabɛlka. ");
INSERT INTO bkw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nyɛ nabɛ ààwa mbɛk pak mena nɛ nɔɔ: dáa di náá, bɛ eezedum koŋ nɛ Zɛɛb ɛ, nyɛ eezegwyii elyem bɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ha étɛp ye nenak bi di é be mɛso nɛ Zɛɛb? Tin, bi ɛpeɛwaab waaba bhel nɛ bot ɛ di dum koŋ nɛ Zɛɛb ɔ náá, bɛ bɛp kɔm na dil-dil di náá, ye nakoozobɛ bisɔ, nɛghu bɛbhaab bin nabɛ ààbɛ nɛ ghwyil ɛbɛp-bɛpak! ");
INSERT INTO bkw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ye goka ɛ́ mena myaalka náá, mena belaka tsik ɛ kɔ ɛsu ɛ mbɛɛ lyem ɛ Ghɛŋ Yezu, tyee wat nɛ nɔɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tin, bot ɛ zɛɛga djas moo tin kup, bhii tak bɛ moo tin é gwak Bhaalnabhas bɛ nɛ Pɔl nadi baŋa bɛ endem nɛ etɛp ee mɛbwala ɛ Zɛɛb nasa nɛ nɔɔ esok bɛ nadi pɛ dáa bot ɛ di ààdi bot ɛ mbyak eYuda ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dáa bɛ nasilal ɛ lii ɛ, Zak eezɛwyɛl, bhii tak nyɛ eezɛke náá: «Bɔn ɛ nyɛɛg, gwakeka mɛ! ");
INSERT INTO bkw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɛyɔŋ eebaŋa mena dáa Zɛɛb nalookan ɛkwyee bot ɛ di ààdi bot ɛ mbyak eYuda é mɛkɛn ɛ, étɛp nyɛ neesɛɛ tɔ lɔɔ dhaad mbyak aadi ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Deenek, etɛp ee bɛngoolel ɛ mɛkpa mɛ Zɛɛb djas ɛpenɔŋel nɛ yak, etɛɛ náá, Ekwyala lɛɛ ɛ náá: ");
INSERT INTO bkw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Ghɛŋ lɛɛ náá, bhis yenek, mɛ waabula, étɛp ɛ baazɛsum ndjaŋ ɛ Dhavid nazebik ɛ, mɛ waawyɛl embikela epap é tak, mɛ waabulal yɛ piki. ");
INSERT INTO bkw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tin, bot ɛ membyak djas ɛ waasaa Ghɛŋ, nɛ tsɛɛtsɛ, bot ɛ membyak djas mɛ nadjóo náá, bɛ di bam ɔ, sa Ghɛŋ nalɛɛ ɛ́ yenek, ");
INSERT INTO bkw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","nyɛy mot naloozɛlɛɛ bot egeka bɛ ɔ.” » ");
INSERT INTO bkw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Wɔ gwaa Zak baazɛbil náá, mɛ bee ɛ náá: «Mena tok ka nɛ ghwyil ɛ saa etɛp nɛ bot ɛ di ààdi bot ɛ mbyak eYuda ɔ, di liig elyem du Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Deenek, djhookwyalka bɛmɛkana étɛp ɛlɛɛ bɛ náá, bɛ nàdɛ bɛtit tsakaa étɛp ɛdjɛ bɛzɛɛb ɛ bot di kpak nɛ ɛluel ɛ́ ebuwa. Bɛ kyee mɛzɔ, bɛ nàdɛ bɛtit góaa nɛ bhiyo, bɛ nàdɛ ghiya. ");
INSERT INTO bkw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Etɛɛ náá, kana é ghɛŋ bɛbhaab bot ɛpelyo bot etsi ɛ Moiiz pɛ kɔ eghaada nɛ eghaada, yɛ ɛpelaŋaa tɔ mendjaa mɛ mendjaala é mɛlu mɛ saba djas.» ");
INSERT INTO bkw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tin, bot ɛ lwoma, nɛ bɛpaa, zɛnɔɔ bot ɛ zɛɛga mendjaala zokagwakel náá, bɛ sɛɛ bɛdhiiti bot pak ɔ, bɛ neelwom bɛ pɛ Antiɔs lɔɔg wat nɛ Pɔl nɛ Bhaalnabhas. Tin, wɔ gwaa bɛ zokazɛsɛɛ, Yude dhiiti din ɛ lɛ nabaadi pe ɛ́ Balsabas, zɛnɔɔ Silas. Bot ɛbá tak nabɛɛ tɔ sama bot ɛ nadi é kɔ elo ee bot ɛ zɛɛga ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bɛɛ booke nɛ nɔɔ náá, bɛ tɔ́ nɛ mɛkana di lɛɛ náá: «Bot ɛ lwoma, nɛ bɛpaa, bɔn nyɛɛg bin eeswos bɔn nyɛɛg bɔɔ di ààdi bot ɛ mbyak eYuda ɔ di kɔ ghaada Antiɔs, pɛ kyee dik Siili, dɔɔ nɛ pɛ Silisi ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Bis eegwak náá, bɛdhiiti bot ɛ dus pɛ dɛl ɛ les eezɛm bin nɛ ɛpul ɛ bin esiiza nɛ etɛp ee bɛ di lɛɛ ɛ. Bisɔ ààpalwom bɛ, bɛ zɛɛ lii nɛ nen dum nɛ etɛp binek. ");
INSERT INTO bkw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","É tɛp tak bisɔ djas gwakel náá, bis sɛɛ bot ɛ bis aadhis ɔ. Bot ɛ tak neezɛkyeed Pɔl bɛ nɛ Bhaalnabhas bɛsɔ bena. ");
INSERT INTO bkw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bot ɛ nawaagel mɛnyel kɔ ɛsu ɛ din ɛ Ghɛŋ'ena Yezu Klisto ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bis eedhis bin Yude bɛ nɛ Silas bɛ neezɛlɛɛ bin nɛ enuub bɔɔ ɛmet, etɛp é bis kwyal wak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ye ɛ́ náá, bisɔ nɛ Sisim na Dɛɛ nabɛ ɛ bis eegwakel náá, bis aanàbaabil bin dhiiti kɔm na dil-dil bhis mɛsa mak di nɛ eboo mɛgham ɛ: ");
INSERT INTO bkw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nàdɛka bɛtit ɛ tsakaa étɛp ɛdjɛ bɛzɛɛb ɛ bot zekpak nɛ ɛlul ɛ ebuwa, nàdɛka ghiya, ààdɛ epuud é tit góaa nɛ bhiyɔ ɔ, sa bi ààsa mɛzɔ. Bi ɛ sa deenek ɔ, yɛ aadi ɛ́ ɛnyɔɛpe. Dika ɛnyɔɛpe!» ");
INSERT INTO bkw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Deenek, bɛ eezɛbet bot ɛ bɛ nalwom ɔ, bot ɛ tak eezɛtɔ́ pɛ Antiɔs. Tin, bɛ eezɛsɛɛg bot ɛ zɛɛga mendjaala. Bhii tak, bɛ eezɛdjɛ bɛmɛkana. ");
INSERT INTO bkw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wɔ gwaa bɛ zɛlaa yɛ, mɛkana mɛ tak naadjɛ bɛ ghwyil bɛ moo tin nɛ mɛmyaala. ");
INSERT INTO bkw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Dáa Yude bɛ nɛ Silas nadi bɛngoolel ɛ mɛkpa ɛ Zɛɛb bɔɔ bɛ ɛmet ɛ, bɛ naazɛlii nɛ bɔn nyɛɛg bɔ ɛbuɛpe étɛp ɛdjɛ bɛ ghwyil nɛ mɛghaaz tɔ ɛdum ɛ koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bhis bɛ nadhaa ba bim mɛwala e di tak ɛ, bɔn nyɛɛg bɔɔ eezɛmwana nɛ nɔɔ bɛ sik tɔ egwyem pɛ dáa bot ɛ nalwom bɛ ɔ.  ");
INSERT INTO bkw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Tin, Silas ɛ booke yɛ náá, nyɛ lik tinaak. ");
INSERT INTO bkw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bela tin náá, Pɔl bɛ nɛ Bhaalnabhas eezɛlik pɛ Antiɔs. Bɛ nɛ bɛdhiiti bot, bɛ nadi é lyo bot nɛ ɛgoola mɛkpa ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ba mɛwala bhii tak, Pɔl eezɛke nɛ Bhaalnabhas náá: «Djhoosik kɛgwyák bɔn nyɛɛg bina pɛ kɔ eghaada djas mena nagoola mɛkpa ɛ Ghɛŋ ɛ, mena neekɛbee dáa bɛ di penek ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bhaalnabhas nakwyɛl ɛ, bɛ tɔ́ lɔɔg wat bɛ nɛ Zaŋ mot nagetaa din ɛ Malak ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Tin, Pɔl nàbɛ ààkwyɛl geka tak, etɛɛ náá, ye nabɛɛ nyɛ naabet bɛ esok bɛ nadi pɛ kyee dik Panfili ɛ, nyɛ naka bɛ ààtɔ́ bɛ nɛ nɔɔ pɛ ze lwomel. ");
INSERT INTO bkw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","É di'enek, ye nabɛ ɛ bɛ naabela boo zyaala, batasa náá, bɛ bɛka. Tin, Bhaalnabhas eezɛnɔɔ Malak, bɛ eezɛni tɔ mɛsuwa, tɔ́ bɛ nɛ nɛ pɛ ghola Siipɛlɛ, ");
INSERT INTO bkw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pɔl eezɛnɔɔ yɛ Silas tɔ́ nɛ nɛ, bhis bɔn nyɛɛg bɔɔ nazewa bɛ é mɛmbɔ ɛ Ghɛŋ tɔ mendjaala ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pɔl eezɛkpaa kɔ mɛl mɛ Siili nɛ Silisi é ɛdjɛ mɛghaaz nɛ ghwyil ɛ ɛdum ɛ koŋ nɛ Zɛɛb tɔ ezɛɛga mendjaala. ");
INSERT INTO bkw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔl eezɛkum pɛ dɛl ɛ Dɛlɛɛb, nɛ pɛ ghaada Listɛ. Tin ye nabɛ ɛ nɛ dhiiti mot nadi é dum koŋ nɛ Zɛɛb ɔ, din ɛ lɛ nabɛ ɛ Timote, nyɛ nabɛ ɛ mɔɔ dhiiti moma eYuda nadi dum koŋ nɛ Zɛɛb ɔ, sɛɛg nabɛ ɛ mot dhaad mbyak eGhɛlɛk. ");
INSERT INTO bkw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Bɔn nyɛɛg nadi e di pɛ Listɛ nɛ pɛ Ikoniɔm ɔ nadi ɛ́ nɛ mbɛɛ taŋal dum nɛ Timote. ");
INSERT INTO bkw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl eezɛsɛɛ nyɛ étɛp nyɛ neegyee nɛ nɛ. Tin, nyɛ eezɛniigal nyɛ beka, étɛp bot ɛ mbyak eYuda ee nadi kɔ kyee mɛdhik menek ɛ. Nyɛ nasa deenek ɛ etɛɛ náá, bot djas nadi gu náá, sɛɛg nadi ɛ́ mot dhaad mbyak eGhɛlɛk. ");
INSERT INTO bkw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pɛ kɔ eghaada ee bɛ nadi é dhaŋ ɛ, bɛ nadi baŋa bot ɛ di du Zɛɛb ɔ etɛp é bɛ nɛ bot ɛ lwoma nɛ bɛpaa nakɛ lii pɛ Yeluzalɛm ɛ, da bɛ ɛ́ baalɛɛ bɛ náá, bɛ kɛdeenek. ");
INSERT INTO bkw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Bot ɛ zɛɛga mendjaala nadi bela ghwyil tɔ ɛdum ɛ koŋ nɛ Zɛɛb, mɛtaŋ mɛ bot nadi bilel ɛbilel nɛ ɛbilel. ");
INSERT INTO bkw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Sisim na Dɛɛ eezɛlu bɛ náá, bɛ nàkɛgoola mɛkpa ɛ Zɛɛb pɛ kyee dik Azia, bɛ eezɛdhaa kyee dik Fliji nɛ Ghalati. ");
INSERT INTO bkw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Dáa bɛ nakum é ngwoob pes dik Misi ɛ, bɛ eezɛbela ɛkwosak ɛ ɛtɔ́ pɛ pes dik Bhitini. Tin, Sisim ɛ Yezu naazɛlyak bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bɛ eezɛkpaa pɛ Misi, zɛtɔ́ pɛ ɛboŋ ɛ Toloas. ");
INSERT INTO bkw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","É pum, wɔ gwaa Pɔl zɛdjem dyam. Nyɛ eezɛbee dhiiti mot kyee dik Masedwan, tetel é djaala nɛ nɛ náá: «Dhaŋa pɛ kyee dik Masedwan, da zɛkyee bis!» ");
INSERT INTO bkw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ààbɔya bhis dyam enek, bis eezɛsaŋ ɛtɔ́ pɛ kyee dik Masedwan, etɛɛ náá, bis nabɛ ɛ bis eebee tsɛɛtsɛ náá, Zɛɛb nabɛɛ nyɛ eedjóo bis náá, bis kɛ ɛgoola Mbɛɛ Bhaadal pɛ dáa bot ɛ kyee dik tak. ");
INSERT INTO bkw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bis eezɛdus pɛ boo ghaada Toloas tɔ elɛɛd tɔ́ pɛ ghola ɛ Somatalas bhii tak, é yak ɛlu pɛ ghaada ɛ Neapolis. ");
INSERT INTO bkw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bhis tin, bis eezɛtɔ́ pɛ Filip, ghaada mɛkɛn pes dik Masedwan, ghaada eLɔm nasum ɛ, bis naadhaa mɛlu ɛbuɛpe kɔ ghaada tak. ");
INSERT INTO bkw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","É dwoo saba, bis eezɛwyis kɔ ghaada tɔ́ pɛ ɛboŋ, pɛ bis nadi gek náá, bis ɛ nɛ ghwyil ɛ bela sum di mendjaala eYuda. Bis eezɛnɔɔ mɛnyel disi, bhii tak bis moo lii nɛ boa ɛ nasɛɛga tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tɔ boa ɛ tak, din ɛ ngɔt nadi ɛ́ Lydi, nyɛ nadus ɛ pɛ ghaada Tyatiid nyɛ nadi ebomsa etina ekaad é bɛ na nyɔɔnyɔ, na mɛdii mɛ na tɔɔbelaa, nyɛ nadi kwyɛl Zɛɛb ɛbuɛpe. Nyɛ nadi gwak, Ghɛŋ naabɛɛ nyɛ mɛlɔ étɛp nyɛ neegwak nɛ ɛmɛt mɛkpa mɛ Pɔl nadi lii ɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wɔ gwaa nyɛ zɛduwa Zɛɛb bɛ nɛ bot ɛ mɛbyel mɛ, bhii tak nyɛ eezɛdjóo bis pɛ dáa lɛ nyɛy náá: «Bi ɛ myaal nɛ tsɛɛtsɛ náá, mɛ eemyaal Ghɛŋ ɔ, da dika pɛ daa lam.» Nyɛ eezɛsa náá, bis myaal. ");
INSERT INTO bkw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dhiiti dwoo, dáa bis nadi tɔ́ pɛ sum di mendjaala mɛ tak ɛ, wɔ gwaa dhiiti kwom moma mɛsa zokazyɛ zɛboma nɛ nes. Pɛ tɔ lɛ, ye nabɛ ɛ nɛ sisim bhɔm nadi sa náá, nyɛ gheenaa bot eghaa etɛp e di zyɛ pɛ sok ɛ. Nyɛ nadi bela bɛkum bɛ bɛtɛ nɛ epata tɔ ɛnaŋ ɛ eghaa bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tin, nyɛ eezɛni é du bisaa bɔɔ Pɔl, nyɛy é tsim náá: «Bot bak ɛ bot ɛ mɛsa ɛ Zɛɛb Mɛkaake! Bɛ tɔ́ kɛlɛɛ bot ze di djɛ tsik ɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nyɛ naasesa deenek mɛlu ɛbuɛpe. Bhii tak, ye nabɛ ɛ Pɔl naazɛbiyo. Wɔ gwaa nyɛ zɛliig mis, nyɛy nɛ mbee sisim náá: «Nɛ din ɛ Yezu Klisto mɛ lɛɛ wɔ, wyisa tɔ lɛ!» Tin, e di tak wat sisim eezɛwyis. ");
INSERT INTO bkw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Dáa bɛkum bɛ nabee náá, ɛbwaalel ɛ ɛbela epata bɔɔ kɔ ɛsu ɛ lɛ eedus ɛ, bɛ boozɛmɛt Pɔl bɛ nɛ Silas tɔ́ nɛ nɔɔ kɔ ɛbɛsɛɛ ɛ bot djas kɔ boo ghaada, sok bhwoob ekukuma e ghaada tak. ");
INSERT INTO bkw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bɛ eezɛtɔ́ nɛ nɔɔ pɛ dáa bɛtetɛp eLɔm, bɔɔ nɛ nɔɔ náá: «Bot bak ɛ pe kus ɛzɛm kɔ ghaada yena. Bɛ ɛ́ bot ɛ mbyak eYuda, ");
INSERT INTO bkw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","bɛ ɛpelyo bot mɛzel mɛ di náá menabɛl eLɔm tok ka nɛ ghwyil ɛdu nɛ ɛsa ɛ ye ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tin, dɔɔ nɛ mɛdhuu mɛ bot zokazɛbyen bɛ. Bɛtetɛp ɛ boozɛke náá, bɛ sɔ Pɔl nɛ Silas ekaad é nyel, bɛ eezɛlwom náá, bɛ nyuu bɛ nɛ eghwyɛs. ");
INSERT INTO bkw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bhis bɛ nasilal ɛnyuu bɛ nɛ eghwyɛs esok nɛ esok ɛ, bɛ boo zɛkɔɔl bɛ tɔ membok, bɛ eezɛlɛɛ nɛ baalel ndjaa membok mɛ tak náá, bɛ baal bɛ ɛnyɔɛpe ");
INSERT INTO bkw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dáa mbaalel tak nagwak dáa bɛtetɛp nalii ɛ, bɛbaalel ɛ ndjaa membok ɛ boo kɛwa bɛ tɔ dhiiti dɛŋ pɛ ɛsik tɔ membok bhii tak bɛ eezɛwa bɛ mɛko tɔ embwak. ");
INSERT INTO bkw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ye moo tiila nɛ kuku pum, Pɔl bɛ nɛ Silas nadi é djaala nɛ ɛduwal Zɛɛb dum nɛ mbɛɛ esesɛɛ bɛ, tin, bɛdhiiti bot ɛ membok nadi gwak bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","É di'enek wat, wɔ gwaa bɔs zɛkuu ɛlyelɛpe, epap é ndjaa membok kuu. Mɛbɛ mɛ ndjaa membok djas zokabɛŋel, e di tak wat, eghwooz e bot ɛ membok nakɔl bɛ nɛ ye ɛ́ zokatiiel. ");
INSERT INTO bkw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mbaalel ndjaa membok eezɛdjem ɛ́ yenek, dáa nyɛ nabee náá, ɛbɛ ɛ ndjaa membok nadi ɛ́ mbek ɛ, nyɛ boo waal pɛlɛ étɛp nyɛ neegó nyel. Nyɛ nasa deenek ɛ etɛɛ náá, tɔ egeka bɛ, nyɛ nadi eke ɛ náá, bot ɛ membok eezekaab. ");
INSERT INTO bkw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Tin, Pɔl eezɛtsim nɛ ghwyilɛ djas náá: «Nà zuka nyel'ɔ, bisɔ djas ɛ wak!» ");
INSERT INTO bkw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tin, mbaalel ndjaa membok eezɛwaab náá, bɛ tuub twol. Bhii tak, nyɛ eezɛwyis kaab ni tɔ dhɛŋ tak nyɛy é gbakeba nɛ bwoo, nyɛ zɛduma mɛboŋ si mɛko ɛ Pɔl nɛ Silas. ");
INSERT INTO bkw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tin, nyɛ eezɛwyisal bɛ. Bhii tak, nyɛ eezɛdji bɛ náá: «Bot, mɛ goka nɛ sa dáa étɛp mɛ neebela tsik?» ");
INSERT INTO bkw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bɛ eezɛbɔɔza náá: «Duma koŋ nɛ Ghɛŋ Yezu, tin, wɔ waabela tsik wɔy nɛ bot ɛ mɛbyel mɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","É di'enek, bɛ ɛ́ boo zɛgoola nyɛy nɛ bot ɛ ndjaŋ'ɛ Mɛkpa ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","É ɛwala ɛ tak wat, mbaalel ndjaa membok eezɛtɔ́ nɛ nɔɔ é pum kɛgwyii nɛ gwom bɛ mɛpyoŋ. E di tak wat nyɛ eezɛduwa Zɛɛb bɛ nɛ bot ɛ ndjaŋ'ɛ djas. ");
INSERT INTO bkw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nyɛ eezɛbyet nɛ Pɔl bɛ nɛ Silas pɛ ndjaŋ'ɛ. Bhii tak, nyɛ eezɛdjɛ bɛ edee e dek. Mot tak nɛ bot ɛ mɛbyel mɛ djas nadi ɛ́ tɔ mɛmyaala etɛɛ náá, bɛ naadum koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Dáa mɛlem nakalem ɛ, bɛtetɛp eLɔm eezɛlwom bot, étɛp ɛkɛlɛɛ nɛ mbaalel ndjaa membok náá: «Betka bot binɔk.» ");
INSERT INTO bkw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mbaalel ndjaa membok eezɛlɛɛ Pɔl náá: «Bɛtetɛp eedhis bhaadal náá, bi wyiselaa. Deenek bi ɛ nɛ ghwyil ɛ ka wyis da bi ɛ tɔ́ tɔ egwyem.» ");
INSERT INTO bkw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pɔl eezɛbɔɔza nɛ bot ɛ nalwomaa ɛ náá: «Bee lwom náá, bis nyuŋaa nɛ eghwyɛs é mis mɛ bot djas, di bis di bot ɛ dɛl eLɔm. Bhii tak, bee kɔɔl bis é membok, bisɔ ààpɛ́ɛaa dáa ye di egoka nɛ ɛsael ɛ. Deenek, sa bɛ di kwyɛl ɛsa nenak ɛ ɛwyisal ɛ bis tyee syaab e! Ha bɛ deenek e! Ye goka ɛ́ bɛ zɛɛ wyisal bis bɔɔ bɛ ɛmet.» ");
INSERT INTO bkw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bot binɔk eezɛsik kɛlɛɛ etɛp binek dáa bɛtetɛp e dhaad mbyak eLɔm. Dáa bɛ nagwak náá, bɛ ɛ́ bot ɛ dɛl eLɔm ɛ, ye nabɛɛ bwoo naasa bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tin, bɛ boo zɛwaab ɛpelak pɛ dáa lɔɔ, bhii tak bɛ eezɛwyisal bɛ é mbok, bɛ eezɛdjaala nɛ nɔɔ náá, bɛ dus kɔ ghaada. ");
INSERT INTO bkw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Dáa bɛ nawyis é membok ɛ, bɛ eezɛtɔ́ pɛ dáa Lydi. Bhis bɛ nazɛboma nɛ bɔn nyɛɛg bɔɔ, nɛ ɛdjɛ bɛ mɛghaaz nɛ ghwyil tɔ ɛdu ɛ Zɛɛb ɛ, bɛ eezɛnɔɔ mɛnyel tɔ́. ");
INSERT INTO bkw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bɛ eezɛdhaa pɛ eghaada Anfipolis nɛ Apoloni, tin, bɛ eezɛkum pɛ ghaada Tesalonik pɛ eYuda nadi nɛ ndjaa mendjaala ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Dáa nyɛ nabela nɛ sesa sok tɔ mɛfulu mɛ ɛ, Pɔl zɛtɔ́ é esaba é lɛl tɔ mendjaa mɛ mendjaala mɛ eYuda, bɛ nadi lii dum nɛ Ekwyala e Zɛɛb, bɛ nɛ bot ɛ nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nyɛ nadi lyo nɛ ɛlyaal bɛ ze di lɛɛ náá, ye nabɛ ɛ náá, Mɛsia ɛ waazukaa, nɛ náá, nyɛ waagom bis ɛsyee. Nyɛ nadi eke nɛ nɔɔ ɛ náá: «Ye ɛ́ Yezu mɛ di lii nɛ nen kɔ ɛsu ɛ lɛ'aak ɛ di Mɛsia.» ");
INSERT INTO bkw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bɛdhiiti bot tɔ sama bot ɛ nadi tin ɛ naamyaal etɛp é tak, bɛ ɛ boozɛdu Pɔl nɛ Silas. Dɔɔ nɛ bɛtɛ nɛ bot ɛ mbyak eGhɛlɛk é nadi duwal Zɛɛb ɔ naazɛsɛɛga nɛ nɔɔ, zɛnɔɔ bɛtɛ nɛ bɛdhiiti bɛdhil ɛ boa. ");
INSERT INTO bkw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tin, eYuda naazɛkpaa lyem, wɔ gwaa bɛ zɛsɛɛg bɛdhiiti ewo é mengbaaz bɛ nabela é gba ɛ, bɛ boo zɛkus ɛghuub tɔ ɛdhuu ɛ bot ɛ nadi tin ɔ. Wɔ gwaa bɛ zɛkus ɛzɛm kɔ ghaada bɛ eezɛtɔ́ pɛ ndjaŋ ɛ Zasɔn kɛsaa bɛ étɛp bɛ neemɛt Pɔl nɛ Silas bɛ neezyɛ nɛ nɔɔ é mis mɛ mɛdhuu mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Dáa bɛ nadi ààbela bɛ ɛ, bɛ ɛ boozɛmɛt Zasɔn bɛ nɛ bɛdhiiti bɔn nyɛɛg, tɔ́ nɛ nɔɔ pɛ dáa ekukuma é ghaada. Bɛ moo tin é tsim náá: «Bot bak ɛ pe zɛm dik djas, deenek, nenak bee kɛzyɛ nɛ yɛ wak! ");
INSERT INTO bkw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Zasɔn eemyaal náá, bot ɛ tak sulal pɛ dáa lɛ! Bot ɛ tak djas ààsa dáa etsi ɛ kukuma di lɛɛ ɛ, etɛɛ náá, bɛ ke ɛ náá, ye ɛ́ nɛ dhiiti mɛkoozi mɛsis, din ɛ lɛ Yezu.» ");
INSERT INTO bkw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Etɛp binek naadjɛ ekukuma nɛ mɛdhuu mɛ bot ɛ ghaada bwoo. ");
INSERT INTO bkw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bot ɛ tak naasa náá, Zasɔn bɛ nɛ bɔn nyɛɛg zɛdjɛ boo etuud dáa ekukuma étɛp bɛ neebetaa. ");
INSERT INTO bkw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Dáa ɛgwyitok nagwyiidela ekeletyɛ ɛ́ bookyeed Pɔl bɛ nɛ Silas bɛ tɔ́ pɛ dɛl ɛ Bheede. Dáa bɛ nakum ɛ, bɛ eezɛtɔ́ pɛ ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beezaag nàbɛ ààbɛ nɛ embee elyem dáa bot ɛ Tesalonik. Bɛ naagwak mɛkpa ɛ Zɛɛb nɛ mbɛɛ lyem. Mɛlu djas bɛ nadi sɛɛga étɛp ɛdjek mɛkpa ɛ Zɛɛb nɛ ɛfial ɛ etsɛɛtsɛ é etɛp ee Pɔl nadi lii ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ye ɛ́ kɔ ɛsu ɛ tak ɛ bɛtɛ nɛ bot pak ɔ nabɛɛ bɛ moo dum koŋ nɛ Zɛɛb, dɔɔ nɛ tɔ sama bot ɛ mbyak eGhɛlɛk, bɛdhil ɛ boa nɛ botom ɛbuɛpe namyaal ɛ du ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Dáa bɛdhiiti eYuda é dɛl Tesalonik nagwak náá, Pɔl nabaadi goola mɛkpa ɛ Zɛɛb pɛ Bheede ɛ, bɛ eezɛzyɛ zɛkus ɛghuub, nɛ ɛzɛm tɔ mɛdhuu mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bɔn nyɛɛg eezɛkyeed Pɔl kaab ɛ kaab pɛ ze boo dii mɛsɔn. Tin, Silas bɛ nɛ Timote eezɛlik pɛ Bheede. ");
INSERT INTO bkw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bot ɛ nakɛ kyeed Pɔl ɔ zokatɔ́ nɛ nɛ kɛkum pɛ ghaada Atɛn. Bhii tak, bɛ eezɛlee sik yɔbɔ pɛ Bheede nɛ bɛbhaadal ɛ Pɔl nakyeed Silas bɛ nɛ Timote ɛ, nyɛ nake nɛ nɔɔ ɛ náá, bɛ lel ɛkɛ baakɛ boma nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Dáa Pɔl nadi bwood bɛ pɛ Atɛn ɛ, wɔ gwaa goŋ zɛmɛt nyɛ ɛlyelɛpe dáa nyɛ naabee dɛl «tɔɔɔ» nɛ bɛzɛɛb ɛ elula-lula ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nyɛ moo tin é lii tɔ ndjaa mendjaala bɛ nɛ eYuda nɛ bot ɛ nadi duwal Zɛɛb ɔ, dɔɔ nɛ kɔ ɛbɛsɛɛ, e di bot djas di di. Mɛlu djas nyɛ nadi é lii nɛ bot ɛ nyɛ nadi boma nɛ nɛ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bɛdhiiti bɛlyoel ɛ nadi djóoaa «bot ɛ Epikyiid ɔ» nɛ bot nadi é djóoaa «bot ɛ Zenɔŋ ɔ» zokazɛlii nɛ nɛ. Bɛdhiiti eezɛdji nyɛ náá: «Mot ɛtap ɛlak kwyɛlɛlɛɛ ye?» Bɛdhiiti náá, «Ye di ɛkɛɛ náá, nyɛ ɛpelyo bot bɛzɛɛb sis.» Bɛ nake deenek ɛ etɛɛ náá, bɛ nàdi gwak Pɔl é goola mɛkpa mɛ Zɛɛb kɔ ɛsu ɛ Yezu nɛ étɛp ɛgom ɛ lɛ ɛ bis ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bɛ eezɛnɔɔ nyɛ, tɔ́ nɛ nɛ pɛ sum di zɛɛga bɛ di edjóo «Ɛlopaaj» ɛ. Tin, bɛ eezɛke nɛ nɛ náá: «Bis ɛ nɛ ghwyil ɛgu mɛlyo mɛ na bes wɔ di ke ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wɔ ɔ pe lyaal bis etɛp ee na bes, bis kwyɛl ɛ náá, bis gu mɛsuk mɛ tak.» ");
INSERT INTO bkw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ye goka ɛ́ wɔ ɛ́ gu náá, bot ɛ ghaada Atɛn djas nɛ bɛdjoŋ ɛ nadidi bɛ nɛ bɛ nɔɔ ɔ naadhaa mɛwala mɔɔ ɛ é sɔs nɛ ɛgwak etɛp é na bes é tak. ");
INSERT INTO bkw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","É di'enek, Pɔl tetel kuku ɛbwak ɛ zɛɛga pɛ «Ɛlopaaj», nyɛ eezɛke náá: «Bot ɛ ghaada Atɛn, mɛ eebee náá, bi nɛ dyeebaduwal bɛzɛɛb ɛbuɛpe embii djas. ");
INSERT INTO bkw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Deenek, esok mɛ di kɛkɔ ghaada yen ɛ, mɛ di ɛ é bee mesa ɛ bɛzɛɛb ɛ elula-lula bi di duwal ɛ, mɛ eebee dɔɔ nɛ mɔɔ di na dɛɛ wat é tak kwyala náá: “Ye ɛ́ yii mɔɔ zɛɛb ngɔt bot di ààgu ɛ.” É di'enek, ye ɛ́ yii bi di duwal ààgu ɛ, mɛ zyɛ zɛlyaal bin nwyak. ");
INSERT INTO bkw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Zɛɛb mot nakus bɔs nɛ esesɛɛ ɛ djas ɛ, Ghɛŋ gwoo nɛ bɔs. Nyɛy ààdi tɔ mendjaa mɛ bot dii sum nɛ mɛmbɔ mɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nyɛ tok pe nɛ gwyes náá, bɛ kyee nyɛ nɛghu bɛ djɛ nyɛ yak sonok, etɛɛ náá, nyɛy ɛ di djɛ bot djas tsik, eswos nɛ esonok djas ka lik ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kɛ kan nɛ mot ngɔt, nyɛ naasa membyak djas, bhii tak nyɛ eezɛdjɛ mot nɛ mot yɛ di kɔ bɔs. Nyɛ naakoobal kɔ ɛsu ɛ lɔɔ membu nɛ mɛsik nɛ mɛtsek mɛ mɛdhik mɛ bɛ nagoka nɛ ɛdi kɔ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nyɛ nasa deenek ɛ, étɛp bɛ neesaa nyɛ ye nakozo zo lyel, nɛghu bɛ nɛ ghwyil ɛ batabela nyɛ. Nɛ tsɛɛtsɛ, Zɛɛb ààtseta nɛ mot ngɔɔngɔt pak'ena, ");
INSERT INTO bkw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","etɛɛ náá: “Ye ɛ́ kɔ ɛsu ɛ lɛ ɛ mena dika nɛ tsik, mena di kuuka, mena dika.” Ye ɛ́ etɛp ee bɛdhiiti bɛsaŋel ɛ esesa bin nazolɛɛ ɛ: “Menaka ɛ́ bɔn bɛ pe.” ");
INSERT INTO bkw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Dáa ye di náá, menaka ɛ́ bɔn bɛ ɛ, mena tokeka nɛ ghwyil ɛgek náá, Zɛɛb ɛ́ dáa sonok lulaa nɛ lɔaad, nɛ ghwooz di saaa epata nɛ ye ɛ́, nɛghu nɛ ɛkok ɛ mot di sa nɛ egeka nɛ etsoŋ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ghuna, Zɛɛb ààka bis etɛp ee nasɛɛ sok nɛ bot nadi tɔ ɛdjak ɔ, deenek nenak nyɛ ɛpedjóo bot djas pɛ e di é bɛ di ɛ, bɛ swoola mɛfulu mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Etɛɛ náá, nyɛ naazekoobal ɛlu ɛ nyɛ aazɛpɛ́ɛ bot ɛ bɔs djas, epɛ́ɛ é epiki ɛ, nɛ mot nyɛ nazesɛɛ ɛ. Nyee djɛ bot djas ndem, esok nyɛ nagomal nyɛ pak myoŋ ɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Dáa bɛ nagwak Pɔl é lii dum nɛ ɛgom bhis ɛsyee ɛ, bɛdhiiti eezɛduk nyɛ, bak tak eezɛke náá: «Bis ɛ waaka boo gwak wɔ kɔ ɛsu ɛ tak dhiiti dwoo.» ");
INSERT INTO bkw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","É di'enek ɛ Pɔl nazɛlik bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ye ka belaa tin ɛ náá, bɛdhiiti bot naazɛni zɛɛga yɔɔ, bɔɔ dum koŋ nɛ Zɛɛb. Tɔ sama bot ɛ tak, ye nabɛ ɛ, Denis mot zɛɛga boo kwan nadi pɛ Ɛlopaaj ɔ, dhiiti moma din ɛ lɛ ɛ́ Damalis, nɛ bak bɛdhiiti bot. ");
INSERT INTO bkw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bhis yenek, Pɔl eezɛtɔ́ pɛ ghaada Atɛn bhii tak nyɛ eezɛtɔ́ pɛ ghaada Koolɛt. ");
INSERT INTO bkw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wɔ gwaa, nyɛ zɛboma nɛ dhiiti mot dhaad mbyak eYuda, din ɛ mot tak nabɛɛ Akilas, nyɛ nabyel ɛ pɛ kyee dik Pɔŋ. Nyɛ nabɛ ɛ nyɛ dinaa ààbɔya nɛ dus ɛ pɛ kyee dik Itali bɛ nɛ myɛl, Pilisil, etɛɛ náá, Kolod mɛkoozi mɛ Lɔm naalɛɛ nɛ bot ɛ mbyak eYuda djas náá, bɛ dus kɔ ghaada Lɔm. Tin, Pɔl zokatɔ́ kɛboma nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Dáa nyɛ nadi mot-mɛsa mɛ wat bɛ nɛ bɛ nɔɔ ɛ, mɛsa mɔɔ nadi ɛ́ ɛsa epɛt nɛ eket e bɛtit. Nyɛ eezɛsulal pɛ dáa lɔɔ, étɛp nyɛ neesa mɛsa. ");
INSERT INTO bkw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","É emwoos mɛ esaba djas, Pɔl nadi elii tɔ ndjaa mendjaala mɛ eYuda, nyɛ nadi elyo bot, é sa náá, bot ɛ mbyak eYuda nɛ eGhɛlɛk myaal. ");
INSERT INTO bkw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Dáa Silas bɛ nɛ Timote nadus pɛ dik Masedwan ɛ, tin, Pɔl eezɛdjɛ lyemɛ djas é lyo bot mɛkpa mɛ Zɛɛb. Nyɛ naalyaal eYuda náá, Yezu ɛ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tin, wɔ gwaa eYuda zɛbe mɛso nɛ ɛlee ɛ nyɛ. É di'enek, nyɛ eezɛkut bɛ piib ekaad bɛ bhii tak, nyɛ eezɛke nɛ nɔɔ náá: «Bi ɛ diib ɔ, mɛbɛ mɛ tak ɛ kɔ elo bin met. Yenek ààkagwyák mam. É ɛwala ɛ ɛlak, mɛ aakatɔ́ ɛ pɛ dáa bot ɛ membyak mesis.» ");
INSERT INTO bkw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nyɛ eezɛdus tin, tɔ́ pɛ daa dhiiti mot din ɛ lɛ nabɛ ɛ́ Titus Yustus, mot tak nadi eduwal Zɛɛb, ndjaŋ'ɛ nadi é ngwoob ndjaa mendjaala mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilipus kukuma ndjaa mendjaala mɛ eYuda zokamyaal Ghɛŋ, bɛ nɛ bot ɛ mɛbyel mɛ djas. Wɔ gwaa bɛtɛ nɛ bot ɛ ghaada Kolɛt nadi é gwak Pɔl ɔ zokazɛdum koŋ nɛ Zɛɛb, bhii tak, bɔɔ kɛduwa Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","É dhiiti pum, Pɔl zokazɛdjem dhyam, tɔ dhyam tak, Ghɛŋ naalɛɛ nyɛ náá: «Nabem ba, gheelii, sa wɔ ààdiyal nuub, ");
INSERT INTO bkw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","etɛɛ náá, mɛ ɛ nɛ nɔ sama, mot tok nɛ ghwyil ɛzuk wɔ, etɛɛ náá, bot ɛbuɛpe tɔ ghaada yak ɛ bot bam.» ");
INSERT INTO bkw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔl zokazɛdi kɔ Kolɛt tyee mbu wat nɛ pes, nyɛ nadii lyo bot djas mɛkpa mɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","É membu mɛ Ghaliɔn nadi kukuma dik Akayi ɛ, eYuda zokazɛgwakel kɔ ɛsu ɛ Pɔl étɛp ɛlu mɛsa ɛ mɛ. Wɔ gwaa bɛ zɛtɔ́ nɛ nɛ sok bhwoob kukuma tak, ");
INSERT INTO bkw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bɔɔ náá: «Mot tak ɛpeful bot lo náá, bɛ duwal Zɛɛb dhiiti mbi duuela sis ààbɛ dáa etsi bi nadi lyo ɔ!» ");
INSERT INTO bkw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dáa Pɔl nawaadi é kwyɛl ɛlii ɛ, Ghaliɔn eezɛbɔɔza nɛ eYuda náá: «Yɛ bɛ náá, nyɛ gó ɛ mot ɔ, nɛghu nyɛ sa eboo embee étɛp ɔ, ye ɛ́ mɛ ka nɔɔ nyel disi étɛp mɛ neegwak bin, biyɔ eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Dáa di náá, ye ɛ́ ɛsuu ɛ mɛso dum nɛ mɛkpa nɛ min, zɛnɔɔ etsi bin met ɛ, yenek gwyák ɛ biyɔ bɛ ɛmet. Mee pɛɛ ɛdi tetɛp mbi etɛp deenek!» ");
INSERT INTO bkw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tin, nyɛ ɛ́ boozɛswaal bɛ sok bhwoob zɛɛga bɛtetɛp. ");
INSERT INTO bkw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tin, wɔ gwaa bɔɔ djas zɛmɛt Sɔstɛn mot nadi kukuma ndjaa mendjaala mɛ eYuda ɔ zɛduma nyɛ é nyel é mis mɛ bot ɛ zɛɛga bɛtetɛp. É di'enek, Ghaliɔn na bɛ ààkobis yɛ. ");
INSERT INTO bkw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔl eebaazɛdhaa ba bim mɛlu ɛbuɛpe pɛ dɛl ɛ Kolɛt. Tin, nyɛ zɛlik bɔn nyɛɛg, nyɛ eeni tɔ boo elɛɛd tɔ́ pɛ dik Siili bɛ nɛ Pilisil nɛ Akilas. Ye nabɛ ɛ, nyɛ eezewaadal lo ɛboŋ esok nyɛ nɛ nadi pɛ dɛl ɛ saakele ɛ, etɛɛ náá, ye nabɛ ɛ nyɛ eesa ekɛk nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wɔ gwaa, bɛ zɛkum pɛ ghaada Efɛɛz. Tin, nyɛ eezɛlik Pilisil bɛ nɛ Akilas. Bhii tak nyɛ eezɛtɔ́ pɛ ndjaa mendjaala mɛ eYuda, tin nyɛ eezɛmɔ bɛ nɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bɛ eezɛke nɛ nɛ náá, nyɛ di bɛ nɛ bɛ nɔɔ ba mɛlu, tin, nyɛ na bɛ ààkwyɛl. ");
INSERT INTO bkw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nyɛ eezɛlik, bɛ nyɛy nɛ nɔɔ náá: «Zɛɛb ɛ kwyɛl ɔ, mɛ waaboo baazyɛ pɛ daa len.» Tin, nyɛ eezɛdus pɛ Efɛɛz tɔ mɛsuwa. ");
INSERT INTO bkw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bhis nyɛ nadus pɛ ghaada Seezale ɛ, nyɛ eezɛtɔ́ sok pɛ Yeluzalɛm étɛp nyɛ neekɛ swos bot ɛ zɛɛga mendjaala. Bhii tak, nyɛ eezɛtɔ́ pɛ ghaada Antiɔs. ");
INSERT INTO bkw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nyɛ eezɛkwyɛɛg ba mɛlu penek, bhii tak nyɛ eezɛsik. Nyɛ eezɛdhaa, pɛ mɛdhik mɛ Ghalati, bhii tak pɛ Filiji é ɛdje-djɛ bɛdjekel djas mɛghaaz tɔ ɛdum ɛ koŋ nɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Eghɛŋ tak, dhiiti mot dhaad mbyak eYuda din ɛ lɛ nabɛɛ Apolɔs, nyɛ nabyel ɛ́ pɛ ghaada Alɛkzandili, naazɛkum pɛ ghaada Efɛɛz. Nyɛ nadi ɛ́ tsoŋ mot tɔ lii, nyɛ nadi é gu Ekwyala e Zɛɛb ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nyɛ naadiaadjek ɛkɛ tɔ mɛkpa mɛ Ghɛŋ, tin, nyɛy é wa zii ɛbuɛpe. Nyɛ nadi goola, nɛ ɛlyo ɛ bot nɛ lyem wat etɛp e di dum nɛ Yezu ɛ. Ye ka bela ɛ náá, nyɛ nazodi é gu ɛ ɛduwa ɛ Zɛɛb ɛ Zaŋ. ");
INSERT INTO bkw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nyɛ eezɛni é lii nɛ bot nɛ ɛbwaalel djas tɔ ndjaa mendjaala mɛ eYuda. Bhis bɛ nasilal ɛgwak etɛp ee nyɛ nadi é lii ɛ, Pilisil bɛ nɛ Akilas eezɛnɔɔ nyɛ, tɔ́ nɛ nɛ lɔɔg wat, étɛp bɛ neekɛ pɛs ɛgu ɛ lɛ dum nɛ mɛze ɛ Zɛɛb ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Bhii tak, Apolɔs eezɛgwak gwyes ɛ́ ɛtɔ́ pɛ dik Akayi. Bɔn nyɛɛg zokadjɛ nyɛ ghwyil nɛ mɛghaaz, tin, bɛ eezɛkwyal bɛdjekel ɛ nadi pɛ kyee dik tak ɔ mɛkana, étɛp bɛ neemyaal náá, nyɛ sulal daa lɔ nɛ mbɛɛ lyem. Dáa nyɛ nakakum ɛ́, nyɛ nadyeebakwyee bot ɛ nadum koŋ nɛ Zɛɛb ɔ, nɛ enɛm nɛ embɛɛ e Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Etɛɛ náá, é mis mɛ bot djas, nyɛ nadi é lyaal popoopwon náá, eYuda eezewo ze. Nyɛ nadi lyaal bɛ tɔ Ekwyala e Zɛɛb náá, Yezu ɛ Mɛsia. ");
INSERT INTO bkw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dáa Apolɔs nadi pɛ Kolɛt ɛ, Pɔl nadi dhaa pɛ mɛl ɛ mɛtsok pɛ kyee dik Azia, bhii tak, nyɛ eezɛkum pɛ ghaada Efɛɛz. Nyɛ eezɛbela ba bim bɛdjekel tin, ");
INSERT INTO bkw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","nyɛ eezɛdji bɛ náá: «Ye nabɛɛ bi naabela Sisim na Dɛɛ esok bi nadum koŋ nɛ Zɛɛb ɛ?» Bɛ eezɛbɔɔza nɛ nɛ náá: «Bis dinaa ààpakogwak-gwakak bot é lii-liak dum nɛ Sisim na Dɛɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Tin, Pɔl eezɛdji bɛ náá: «Bi duwa Zɛɛb yaa kwaambi ɛduwa?» Bɛ eezɛbɔɔza náá: «Ɛduwa Zɛɛb ɛ Zaŋ.» ");
INSERT INTO bkw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pɔl eezɛke nɛ nɔɔ náá: «Zaŋ naduu ɛ bot ɛ namyaal ɛswoola mɛfulu ɔ. Nyɛ nadi eke nɛ bot ɛ mbyak Yisalaɛl náá, bɛ dum koŋ nɛ mot di zyɛ bhis nyɛy ɔ, mot tak nabɛ ɛ Yezu.» ");
INSERT INTO bkw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bhis bɛ nazegwak etɛp binek djas ɛ, bɛ eezɛduwa Zɛɛb nɛ din ɛ Ghɛŋ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bhii tak, Pɔl eezɛkɛl bɛ mɛmbɔ tin, bɛ eezɛbela Sisim na Dɛɛ. Bɛ moo tin elii tɔ elii membyak mesis nɛ ɛgoola bɛbhaadal ɛ Zɛɛb djɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bot ɛ tak nadi ɛ́ bot kam nɛ bɛbá. ");
INSERT INTO bkw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","É bɛngɔn ɛlɛl, Pɔl nadi etɔ́ pɛ ndjaa mendjaala mɛ eYuda, tin, nyɛ naalelii nɛ ɛbwaalel djas. Nyɛ nalelii nɛ nɔɔ ɛ́ dum ɛ Ɛyoŋ ɛ Zɛɛb, nyɛ nadi sa náá, bot ɛ nadi gwak nyɛ ɔ myaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Deenek, bɛdhiiti bɛtɛ nɛ bot nadiaa sa maa-ɛlɔ, bɔɔ byen ɛmyaal, bɛ moo tin é sa abhusu dum nɛ mɛze ɛ Ghɛŋ é mis mɛ mɛdhuu mɛ bot. Deenek, Pɔl eezɛdus tin lik bɛ. Nyɛ eezɛtɔ́ bɛ nɛ bɛdjekel bɛ, tin, nyɛ nadi lyo bɛ mɛlu djas tɔ ndjaa mɛlyo ɛ dhiiti mot din ɛ lɛ ɛ Tilanus. ");
INSERT INTO bkw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Deenek, ye naabɔya membu membá, ye nasa náá, bot ɛ mbyak eYuda nɛ bot ɛ membyak mesis nadi pɛ kyee dik Azia ɔ djas, gwak mɛkpa ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Zɛɛb nadi sa eboo endem e mɛbwala nɛ Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Etɛp tak ɛ bot nadi tɔ́ pɛ dáa bot ɛ mɛbɛ́ nɛ epes e kaad, nɛ ekaad ee Pɔl namɛt ɛ, nɛghu yii nakee-kea é nyel'ɛ ɛ. Deenek, bɛ nadi bela tsik, embee esisim nadi wyis tɔ lɔɔ ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bɛdhiiti eYuda ee nadi é kɛmɛl ɛ mɛl kɛsɔ embee esisim tɔ bot ɛ mɛbɛ́ ɔ, nagek ɛsa yɛ nɛ din ɛ Ghɛŋ Yezu. Deenek, bɛ nakeke nɛ embee esisim náá: «Mɛ lɛɛ bin ɛ náá, bi wyis nɛ din ɛ Yezu Pɔl di goola mɛkpa mɛ ɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ye ɛ́ deenek ɛ bɔɔ tɛn nɛ bɛbá boo ghaa-Zɛɛb nadi djóoaa Seeva nadi é sa. ");
INSERT INTO bkw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Tin, dhiiti dwoo, wɔ gwaa mbee sisim zɛbɔɔza nɛ nɔɔ náá: «Mɛ nɛ gu Yezu, mɛ nɛ baagu pe Pɔl. Yɛ kabɛ biyɔ, biyɔ ɛ́ bɛzɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","É di'enek, wɔ gwaa mot nadi nɛ mbee sisim ɔ zɛghɛɛ bɛ, dáa nyɛ nadi nɛ ghwyil dhaa bɛ ɛ́, wɔ gwaa nyɛ zɛduma bɛ é mɛnyel nɛ mɛbin nɛ ebhooba djas. Bɛ nadus tɔ ndjaŋ'ɛ tin ɛ nɛ ekaab bin toto, nɛ mɛpyoŋ é mɛnyel kpeŋ. ");
INSERT INTO bkw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bot ɛ dɛl ɛ Efɛɛz, bot ɛ mbyak eYuda nɛ bot ɛ di ààdi bot ɛ mbyak eYuda ɔ, zokagwak tɛp tak, wɔ gwaa boo bwoo zɛmɛt bɛ. Tin, bɛ naazɛbela boo duu dum nɛ din ɛ Ghɛŋ Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bɛtɛ nɛ bot tɔ sama bot ɛ namyaal Zɛɛb ɔ nadi ezyɛ zɛvaa é mis mɛ bot djas embee esesɛɛ bɛ nadi sa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bɛtɛɛ nɛ bot tɔ sama bot ɛ nadi sa etɛp ee mɛvyɛkɛlɛ mɛ mɛsimba ɔ, zokazyɛ nɛ bɛmɛkana mɛ tak, zɛdik yɛ emis mɛ bot djas. Dáa bɛ nalaa mɛtaŋ mɛ bɛmɛkana mɛ tak ɛ, ye naasa tyee bɛmil mɛkam-mɛtɛn mɛtaŋ mɛ eghwooz ee di saaa epata nɛ ye ɛ́. ");
INSERT INTO bkw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ye ɛ́ deenek ɛ ye nadi náá, dum nɛ ghwyil ɛ Ghɛŋ, Mbɛɛ Bhaadal nadi goolel, kaab nɛ mɛbwala. ");
INSERT INTO bkw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bhis etɛp binek, Pɔl eezɛmyaal ɛtsaal kyee dik Masedwan nɛ Ghɛlɛs é ɛtɔ́ pɛ Yeluzalɛm, dáa Sisim nalɛɛ nyɛ ɛ́. Nyɛy náá: «Bhii mɛ aakum ɛ, egoka ɛ mɛ dhaa kɛbee dɛl ɛ eLɔm.» ");
INSERT INTO bkw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tin, nyɛ eezɛkyeed bot ɛ nadi kwyi-kwyee nyɛ ɔ bɛbá pɛ Masedwan, ye nabɛɛ Timote bɛ nɛ Edast. Tin, nyɛy zokazɛlik ba mɛlu pɛ kyee dik Azia. ");
INSERT INTO bkw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Eghɛŋ tak, ye nabɛ ɛ boo ɛghuub naazɛni kɔ ghaada Efɛɛz dum nɛ ɛdu ɛ mɛze ɛ Ghɛŋ. ");
INSERT INTO bkw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Wɔ gwaa dhiiti mot ɛswom din ɛ lɛ nabɛ ɛ Demetyus, nyɛ nadi ɛ́ lulel mɛvunga. Nyɛ nadi é lul esonok nɛ mbi eghwooz djas ee di saaa epata nɛ ye ɛ́, yii mɔɔ ndjaa zɛɛb Aletemis, etɛɛ náá, ye nadi djɛ bɛswom ɛ bot bɛtɛ nɛ epata. ");
INSERT INTO bkw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Nyɛ ɛ́ boo zɛsɛɛg bot ɛ tak, nɛ bot ɛ mɛsa mɔɔ nadi nɔŋel nɛ mɛsa mɛ tak ɛ, nyɛ eezɛke nɛ nɔɔ náá: «Bɛwɛn, bi nɛ gu náá, ye ɛ́ mɛsa mak ɛ di djɛka mena ekum. ");
INSERT INTO bkw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Deenek, bi ɛpegwak nɛghu ɛbee sa di sɛɛ: Pɔl tak lɛɛ bot ɛ náá, bɛzɛɛb ɛ bot di kpak nɛ mɛmbɔ ɛ, tok bɛtɛtɛ bɛzɛɛb. Nyee batasa náá, ye nasik nɛ bot ɛbuɛpe e di wak kɔ Efɛɛz ɔ yɛ dɔɔ nɛ bot ɛ mɛl mɛ di pɛ kyee dik Azia djas ɔ myaal etɛp bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Etɛp binek ɛ sa náá, mɛsa mena gwyɛ, deenek, mɛsa mena waabyenaa e di tak, bot ɛ waabhina ndjaa zɛɛb moma Aletemis. Tin, bot waadis duu boo zɛɛb Aletemis nyɛy nyɛ ɛmet. Bela náá, zɛɛb moma yak ɛpeduwala kɔ kyee dik Azia djas nɛ kɔ ɛko ɛ bɔs djas.» ");
INSERT INTO bkw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Dáa bɔt ɛ nazyɛ tin ɔ nagwak deenek ɛ, bɛ boozɛkpaa elyem ɛbuɛpe, bɛ moo tin é tsim náá: «Aletemis yii bot ɛ Efɛɛz nɛ bɔk!» ");
INSERT INTO bkw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tin, ɛzɛm eeni kɔ ghaada djas. Wɔ gwaa bɛ zɛmɛt Ghayus bɛ nɛ Aalistaalak bot ba dɛl ɛ Masedwan ɛ nadi djee bɛ nɛ Pɔl é mɛdjoŋ ɔ. Tin, zukamwaa nɛ mot'enɔk eezɛtɔ́ nɛ nɔɔ kaab pɛ ɛbwak ɛ boo zɛɛga. ");
INSERT INTO bkw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","É di'enek, Pɔl nadi kwyɛl ɛni nyɛ neekɛ lyaal nyel pɛ zukamwaa nɛ mot nasɛɛga ɛ. Tin, bɛdjekel eezɛlu nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bɛdhiiti ekukuma e kyee dik Azia nadi bɛsɔ bɛ ɔ zokadhis nyɛ menduk mɛ tak wat náá, nyɛ nàtɔ́ pɛ ɛbwak ɛ boo zɛɛga tak. ");
INSERT INTO bkw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","É di'enek tɔ mɛdhuu mɛ bot binɔk, ye nabɛ ɛ́ nɛ boo zyaala. Bɛdhiiti nadi tsim sa sis, bak tak yɔbɔ sa sis, bak bɛdhiiti bot pak ɔ nabaa di é gu mɛsɔ mɛ tɛp bɛ nasɛɛga kɔ ɛsu ɛ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wɔ gwaa bɛdhiiti eYuda tɔ mɛdhuu mɛ bot binɔk zokazɛbesal dhiiti mot din ɛ lɛ nabɛ ɛ Alɛkzandɛlɛ pɛ sok. Tin, bɛ eezɛbaŋa nyɛ lo tɛp, é di'enek Alɛkzandɛlɛ eezɛben mbɔ étɛp nyɛ neelii, nyɛ neelɛɛ lo mɛsɔ. ");
INSERT INTO bkw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tin, dáa bot nagwyák náá, nyɛ nadi ɛ́ mot dhaad mbyak eYuda ɛ, bɔɔ djas ɛ boo zɛbo boo tsim wat, ye naabɔya tyee mɛwala mɛmbá bɔɔ é tsim náá: «Bɔk-bɔk ɛ di Aletemis bot ɛ dɛl ɛ Efɛɛz!» ");
INSERT INTO bkw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tin, dhiiti kukuma ngɔt e ghaada eezɛsil bɛ elyem nyɛy náá: «Bot ɛ dɛl ɛ Efɛɛz, bot djas nɛgu náá, ghaada di ebaal ndjaa boo zɛɛb moma Aletemis, dɔɔ nɛ sa nakpakaa nɛ ɛkok yii di nɔŋel nɛ ɛbhwoob ɛ lɛ nadus tɔ gwoo ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ye tok nɛ mot aaswonal yɛ. Deenek bi goka ɛ́ nɛ ɛsil elyem, nàsaka etɛp dáa bot ɛ di ààdi nɛ esiiza. ");
INSERT INTO bkw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Bi zyɛ wak ɛ nɛ bot ɛ wat di náá, bɛ ààpadjii esa ee di tɔ mendjaa me zɛɛb, baabela náá, bɛ ààpalee Zɛɛb'ena yii moma. ");
INSERT INTO bkw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Yɛ bɛ náá, Demetyus bɛ nɛ sama bɛswom ɛ bot ɛ nɛ tɛp bɛ di egoka nɛ ɛpit mot'ak kɔ ɛsu ɛ tak ɔ, ye ɛ́ nɛ mendjaa mɛ etɛp di pɛ́ɛaa ɛ nɛ bɛtetɛp ɛ tak. Ye ɛ́ penek ɛ bɛ di egoka nɛ ɛkɛpit. ");
INSERT INTO bkw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tin, yɛ bɛ náá, bi dinaa nɛ dhiiti tɛp bi di baakwyɛl ɛ lii ɔ mena waaka liika pɛ zɛɛga di egoka nɛ ɛliiaa etɛp ee di dum nɛ etsi bina ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Etɛɛ náá, mena nɛ ghwyil ɛdjóoaa bot ɛ di kus ɛghuub ɔ dum nɛ sa sɛɛ mos ɛ. Bela náá, mena tok ka nɛ mɛgham mɛ mena aadjɛka é mbi yak zɛɛga, bɛ ko dji ɛsuk ɛ tak ɔ, ye tok nɛ mot aabaŋa bot ɛnyɔɛpe lo tɛp aani bot tɔ elyem ɛnyɔɛpe ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bhis nyɛ nalii deenek ɛ, wɔ gwaa, nyɛ zɛswaal zukamwaa nɛ mot nadi tin ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dáa ɛghuub nasi ɛ, Pɔl eezɛsɛɛg bɛdjekel, nyɛ eezɛni é ɛdjɛ bɛ mɛghaaz mɛ ɛwa zii tɔ ɛdum koŋ nɛ Zɛɛb. Bhii tak nyɛ eezɛmwana nɛ nɔɔ, deenek, nyɛ eezɛnɔɔ nyel tɔ́ pɛ dik Masedwan. ");
INSERT INTO bkw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nyɛ eezɛkpaa kɔ pes dik tak, tin, nyɛ eebaazɛdjɛ bɔn nyɛɛg di penek ɔ ghwyil ɛ wa zii tɔ ɛdu ɛ Zɛɛb. Bhii tak, nyɛ eezɛtɔ́ pɛ kyee dik Ghɛlɛs ");
INSERT INTO bkw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","pɛ nyɛ nasa bɛngɔn ɛlɛl ɛ. Nyɛ nawaakwyɛl ɛtɔ́ pɛ dik Siili tɔ mɛsuwa, dáa nyɛ naka gwak náá, eYuda ɛ é boob kɔ ɛsu ɛ lɛ ɛ. Nyɛ ɛ́ boozɛke náá, egoka nyɛ sik pɛ ze Masedwan. ");
INSERT INTO bkw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tin, Sopatɛɛd, mɔɔ Pyiidus mot dɛl ɛ Bheede, zokatɔ́ sama wat nɛ nɛ, zɛnɔɔ Aalistaalak nɛ Sɛkundus mot ghaada Tesalonik, Ghayus mot dɛl ɛ Dɛlɛɛb, nɛ Timote, nɛ Tsisik zɛnɔɔ Tolofim mot kyee dik Azia. ");
INSERT INTO bkw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bɔɔ djas nalee tɔ ɛsok, wɔ gwaa bɛ kɛbwood bis pɛ ghaada Toloas. ");
INSERT INTO bkw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yɛka bɛ bis ɔ, bis nadus pɛ ghaada Filip tɔ mɛsuwa ɛ bhis ɛbyoŋ ɛ emapa ee di ààwaaa leviid. Tin, mɛlu mɛtɛn bhii tak, bis ɛ boo kɛboma nɛ nɔɔ pɛ Toloas, é di'enek bis naadi yenga wat. ");
INSERT INTO bkw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","É ɛlu ɛ etɛn nɛ wat é yenga, bis naazɛboma étɛp bis needɛ edee ɛ Ghɛŋ. Tin, Pɔl eezɛni elii nɛ bot ɛ zɛɛga dáa ye nadi náá, nyɛ nadi kwyɛl nyɛ aadhaa djɛmɛn tak ɛ, nyɛ ɛ́ boozɛdul ɛlii kɛkum kuku ɛgha ɛ pum. ");
INSERT INTO bkw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pɛ tɔ dhɛŋ bis nasɛɛga tɔ tak pɛ kyes pɛ ɛko, ye nabɛ ɛ nɛ elambi ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Dhiiti mɔɔ ngbaaz nɛ din ɛ Etik nadi ɛ́ ndiindel kɔ ka fenɛtɛlɛ. Wɔ gwaa nyɛ zɛni é gɔ syaaz esok Pɔl nadi é lii ɛ, gɔ nyɛ nadja ɛ naasa náá, nyɛ batadus pɛ vyɛɛgvyɛɛg di nɛ nadi kɔ ges ɛ duma si. Wɔ gwaa bɛ zokazɛghɛɛ nyɛ, nyɛ nadi ɛ́ nyɛ eezegwyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tin, Pɔl eezɛsul, nyɛ eezɛmalal kɔ lɛ, bhii tak nyɛ eezɛbɛp nyɛ kɔ mɛmbɔ mɛ, nyɛy náá: «Na bemka kɛŋ: nyɛ nɛ tsik!» ");
INSERT INTO bkw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bhii tak nyɛ eezɛbaabyet, nyɛ eezɛnɔɔ mapa, pyak yɛ, tin nyɛ eezɛnɔɔ dɛ. Bhis nyɛ naka baalii ɛbuɛpe, kɛkum ɛlyamela ɛ mɛlem ɛ, nyɛ boozɛkpaa nɛ ze tɔ́. ");
INSERT INTO bkw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tin bɛ eezɛtɔ́ nɛ mɔɔ ngbaazenɔk nyɛy nyel ɛnyɔɛpe nyɛ nɛ tsik. Ye nabɛɛ ye nadjɛ bot djas boo mɛghaaz mɛ ɛdu ɛ Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Bis eetɔ́ ɛsok étɛp ɛkɛni tɔ mɛsuwa mɛ natɔ́ pɛ Asɔs pɛ kyee bis nawaakɛnɔɔ Pɔl ɛ, etɛɛ náá, nyɛy nakwyɛl ɛtɔ́ ɔ nɛ mɛ mɛko. ");
INSERT INTO bkw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Dáa nyɛ naka boma nɛ nes pɛ Asɔs ɛ, bis eezɛnɔɔ nyɛ tɔ mɛsuwa étɛp bis neetɔ́ pɛ dɛl ɛ Mitilɛn. ");
INSERT INTO bkw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Dusa bis nadus tin ɛ, bis eezɛsik, tin, djɛmɛn tak bis eezɛkum pɛ Siyo. Bhis djɛmɛn tak bis eekum pɛ Samɔs, tin, emyɛn tak bis eezɛkum pɛ Milɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pɔl nabɛ ààkwyɛl ɛtyaa pɛ Efɛɛz é kaab nyɛ zɛkɛbɔya kɔ kyee dik Azia, nyɛ nadi tɔ́ kaab ɛkaab é suu náá, dwoo Pɔtekɔt neekɛbela nyɛ, nyɛy pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɛ Pɔl nadi pɛ Milɛ ɛ, nyɛ eezɛkyeed mot nɛ bhaadal pɛ Efɛɛz, bɛ kɛ ɛdjóo bɛpaa ɛ zɛɛga mendjaala. ");
INSERT INTO bkw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Dáa bɛ nakakum pɛ dáa lɛ ɛ, nyɛ eezɛke nɛ nɔɔ náá: «Bi nɛ gu mɛfulu mɛ mɛ nadi é gyee nɛ yɛ pak'en kana dwoo mɛ nakum pɛ kyee dik Azia ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mɛ naasa mɛsa ɛ Ghɛŋ ààbɛ nɛ ɛbet, tɔ ghoŋ nɛ mezuk dum nɛ bhoob mbee lyem bot ɛ mbyak eYuda nadi nɛ yɛ nɛ nam ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Bi nɛ gu náá, etok nɛ dhiiti mbɛɛ tɛp mɛ nasyel ɛlɛɛ bin. Mɛ naazegoola nɛ ɛlyo ɛ bin dum nɛ etɛp djas é mɛbɛsɛɛ nɛ tɔ mendjaa men. ");
INSERT INTO bkw_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mɛ naadul bot ɛ mbyak eYuda nɛ bot ɛ mbyak eGhɛlɛk mɛlɔ náá, bɛ liig elyem du Zɛɛb da bɛ ɛ́ dum koŋ nɛ Ghɛŋ'ena Yezu. ");
INSERT INTO bkw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","E di mena kadika wak nenak'aak, mɛ moo tɔ́ pɛ Yeluzalɛm, dáa Sisim na Dɛɛ lwom mɛ nɛ bhel náá, mɛ sa ɛ, tin, mɛ ààku sa di bwood mɛ pɛ sok ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Sa mɛ di gu ɛ náá, kɔ eghaada djas, Sisim na Dɛɛ nadi lɛɛ mɛ náá, membok nɛ mezuk ɛpebwood mɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bela náá, tsik'am met tok nɛ boo mɛtaŋ é mis mam. Yii di nɛ boo mɛtaŋ ɛ, ɛtɔ́ kɛkum pɛ ɛsik ɛ lwomel, nɛ ɛsilal ɛ bim mɛsa mɛ Ghɛŋ Yezu nadjɛ mɛ ɛ: Ɛgoola ɛ Mbɛɛ Bhaadal yii enɛm nɛ embɛɛ e Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«Mee dhaa tɔ sama yen é ɛgoola Mbɛɛ Bhaadal Ɛyoŋ ɛ Zɛɛb, tin, mɛ nɛ gu naaetok nɛ mot aakabaabee mɛ tɔ sama yin. ");
INSERT INTO bkw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","É tɛp tak ɛ mɛ di lɛɛ nɛ nen mos náá, mɛ esosoob: mot ngɔt pak'en ɛ ka wo ze ɔ, yenek ààkagwyák mɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Etɛɛ náá, mɛ eezɛlyaal bin egeka ɛ Zɛɛb djas ààsyel sa wat. ");
INSERT INTO bkw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bi ɛ́ konyan mis kɔ biyɔ bɛ ɛmet, nɛ kɔ ɛsaa ɛ Sisim na Dɛɛ djɛ bin bi baal ɛ. Bi ɛ ko baal zɛɛga mendjaala Zɛɛb nabɔm nɛ ghiya mɔn'ɛ met ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mɛ nɛ gu náá, bhis mɛ aatɔ́ ɛ bot ɛ di nɔŋel nɛ eben ɔ waazɛni pak'en, tin, bɛ aanàkwaagek ɛsaa ghoŋ. ");
INSERT INTO bkw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tin, dɔɔ nɛ tɔ sama yin, bot ɛ waani é lɛɛ elɛŋ é etsal étɛp bɛdhiiti bot ɛ di dum koŋ nɛ Zɛɛb ɔ ne du bɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bɛɛka mis, da bi ɛ taala náá, tɔ membu melɛl mwos nɛ pum, mɛ nabɛ ààkat ɛdul ɛ bin mɛlɔ, ye nakoozodi nɛ miŋal é mis. ");
INSERT INTO bkw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Nenak mɛ ɛpedjɛ bin é mɛmbɔ mɛ Zɛɛb, nɛ bhaadal mbɛɛ bhwoob'ɛ. Nyɛ ɛ́ nɛ ghwyil ɛ sa náá, bi wyee tɔ ɛdum ɛ koŋ nɛ Zɛɛb nɛ ɛdjɛ bin esesɛɛ djas nyɛ nakwom étɛp bot bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mɛ nabɛ ààsaa epata, ààbɛ elɔaad, ààbɛ ekaad e bot. ");
INSERT INTO bkw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Biyɔ bɛ ɛmet nɛ gu náá, mɛ nadi sa mɛsa nɛ mɛ mbɔ mam met étɛp mɛ neebela esee bis nɛ bot ɛ di gyee nɛ nam aadi nɛ gwyes tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mɛ nabɛ ɛ mɛ eelyaal bin naaegoka bi sa mɛsa étɛp bi neekwyee bɛdjel ɛ bot. Bi baataala etɛp ee Ghɛŋ Yezu nyɛy ɛmet nake náá: “Ɛgwyena nɛ mot eedhaa ɛdjɛaa sonok nɛ mɛnyɔ!” » ");
INSERT INTO bkw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bhis yenek, Pɔl eezɛkwyit mɛboŋ si bɛ nɛ bɛ nɔɔ, bɛ eezɛni é djaala. ");
INSERT INTO bkw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bɔɔ djas moo tin é dji, bhii tak, bɛ eezɛbeedal nyɛ tɔ mɛmbɔ mɔɔ bɛ neemwana nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bɛ nadi ɛ́ nɛ boo goŋ tɔ elyem etɛɛ náá, Pɔl naake náá, bɛ aanàka baaboma. Bhii tak bɛ eezɛtɔ́ kɛmwana nɛ nɛ pɛ mɛsuwa. ");
INSERT INTO bkw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Bhis bis nɛ bɛ nɔɔ nabɛka ɛ, bis eezɛni tɔ mɛsuwa tɔ́ pɛ ghola Kɔɔs. Djɛmɛn tak, bis eezɛkum pɛ ghola Lood, dusa bis nadus tin ɛ bis eezɛtɔ́ pɛ ɛboŋ Patala. ");
INSERT INTO bkw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Dáa bis nabela mɛsuwa é tsaal tɔ pɛ Fenisi ɛ, bis eezɛni tɔ mɛsuwa mɛ tak, bis eezɛtɔ́. ");
INSERT INTO bkw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dáa bis nadi, bis moo pɛ kyee kyɛ bɔs é ngwoob ghola Siipɛlɛ ɛ, bis eezɛdhaa pɛ paa kyɛ ghola tak étɛp bis neetɔ́ pɛ dik Siili, bis eezɛtɔ́ pɛ ghaada Tiid pɛ kyee bɛ nadi kɛkɛɛ esa ee nadi tɔ mɛsuwa ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Bis eezɛboma nɛ bot ɛ di dum koŋ nɛ Zɛɛb ɔ, bis eezɛdhaa yenga wat tin bis nɛ bɛ nɔɔ. Dáa ye nabɛ náá, Sisim na Dɛɛ naazedul bɛ mɛlɔ ɛ, bɛ ɛ́ boo zɛlu Pɔl náá, nyɛ na tɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tin, dáa yenga tak nadhaŋ ɛ, bis eezɛnɔɔ mɛnyel dhaa. Wɔ gwaa bɛ zɛmwana nɛ nes pɛ esik ɛ dɛl, bɔɔ nɛ bɛl bɔɔ, zɛnɔɔ bɔɔ bɔɔ. Tin, bis eezɛkwyit mɛboŋ si é ɛboŋ ɛ boo dii mɛsɔn, bis moo tin é djaala Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Deenek, dáa bis nɛ bɛ nɔɔ nasilal ɛmwana ɛ, bis eezɛni tɔ mɛsuwa, e di'enek, bɛ eezɛsik pɛ mendjaa mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Bis nasilal goŋ mɛdjoŋ mes ɛ, kɔ boo dii mɛsɔn bhis bis nadusa pɛ Tiid tɔ́ pɛ ɛboŋ Potolemayis ɛ. Bhis bis nasilal ɛswos bɔn nyɛɛg bis di kɔ ghaada tak ɛ, bis eezɛkwyɛɛg ɛlu ɛ wat bis nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Djɛmɛn tak bis eezɛsik, bis eezɛtɔ́ pɛ ghaada Seezale. É di'enek, bis eezɛsulal pɛ ndjaŋ ɛ Filip, lyoel mɛkpa mɛ Zɛɛb e di bis nadjaa si ɔ. Nyɛ nabɛ ɛ ngɔt tɔ bot ɛ tɛn nɛ bɛbá bɛ nasɛɛ pɛ Yeluzalɛm ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nyɛ nabɛɛ nɛ esyes e bɔɔ boa ɛná, bɛ nadi gegoola mɛbhaadal mɛ Zɛɛb nadi djɛ bɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Bis nabɛ bis moo nɛ bɛtɛ nɛ mɛlu tin, é ghɛŋ dhiiti ngoolel-mɛkpa ɛ Zɛɛb nɛ din ɛ Aghabis nazɛdus pɛ Yude, zyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nyɛ eezɛzyɛ pɛ dáa les, nyɛ eezɛnɔɔ bhɛtɛ ɛ Pɔl, kɔl mɛko mɛ nɛ mɛmbɔ mɛ, bhii tak, nyɛy náá: «Beeka sa Sisim na Dɛɛ lɛɛ ɛ: Nakuma bhɛtɛ yak ɛ waakɔlaa nɛ ekel dáak nɛ eYuda, pɛ Yeluzalɛm, bhii tak, nyɛ waakaa é mɛmbɔ mɛ bot ɛ membyak mesis.» ");
INSERT INTO bkw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bhis bis nagwak etɛp binek ɛ, wɔ gwaa bisɔ djas nɛ bɔn nyɛɛg bis é dɛl ɛ Seezale zokazɛdjaala nɛ Pɔl náá, nyɛ na tɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tin, nyɛ eezɛbɔɔza náá: «É tɛp ye bi di edji nɛ ɛsa náá, bi djɛ mɛ lyem bwoo? Mam eezemyaal nɛ lyem'am, ye nakoozobɛ ɛkɔlaa nɛ ekel, nɛghu ye kabɛ ɛsyee pɛ Yeluzalɛm kɔ ɛsu ɛ din ɛ Ghɛŋ Yezu.» ");
INSERT INTO bkw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dáa bis nadi ààkwak ɛlu ɛ nyɛ ɛ, bis nabɛ ààbaanenal nyel, bis ɛ́ booke náá: «Ɛkwosak ɛ Ghɛŋ sael!» ");
INSERT INTO bkw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Dáa bis naka dhaa ba mɛlu é di'enek ɛ, bis eezɛkaŋal esa, bhii tak, bis eezɛtɔ́ pɛ Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bɛdjekel ɛ nadi pɛ Seezale ɛ zokakɛkyeed bis, bɔɔ kɛkyeed bis pɛ ndjaa dhiiti mot bis nawaasulal pɛ dáa lɛ ɔ. Din ɛ mot tak nabɛɛ Mɛnasɔn, mot Siipɛlɛ, nyɛ nadi ɛ́ tɔ sama bɛdjekel ɛ mɛkɛn. ");
INSERT INTO bkw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Dáa bis nakum pɛ Yeluzalɛm ɛ, bɔn nyɛɛg bis zokazɛboma nɛ nes nɛ mɛmyaala djas. ");
INSERT INTO bkw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","É djɛmɛn tak, bis nɛ Pɔl eezɛtɔ́ pɛ dáa Zak, pɛ paa bɛpaa ɛ zɛɛga mendjaala nasɛɛga ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Tin, Pɔl eezɛswos bɛ, bhii tak, nyɛ eezɛni é baŋa bɛ etɛp é Zɛɛb nasa pɛ dáa bot ɛ membyak mesis ɛ waa-wat. ");
INSERT INTO bkw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bhis bɛ nazegwak nyɛ ɛ́, bɛ eezɛduwal Zɛɛb. É di'enek, bɛ eezɛke nɛ Pɔl náá: «Mɔn ɛ nyɛɛg wɔ eebee dáa eYuda bɛmil nɛ bɛmil moo mos é dum koŋ nɛ Zɛɛb, elyem bɔɔ djas nɛ dyeebakwyɛsa tɔ etsi. ");
INSERT INTO bkw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ghuna, beeka sa bis nalɛɛ bɛ kɔ ɛsu ɛ lɔ ɛ: wɔ pe lyo bot ɛ mbyak eYuda djas ee di di e di wat bɛ nɛ bot ɛ membyak mesis ɔ náá, é nyɔ ɛ bɛ byen etsi ɛ Moiiz. Wɔ nɛ lɛɛ bɛ náá, bɛ kat ɛniigal bɔn bɔɔ beka, dɔɔ nɛ ɛkat ɛ du ɛ mɛzel mɛ eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bis sa dáa? Bɛ waagu nɛ tsɛɛtsɛ náá, wɔ eezekum. ");
INSERT INTO bkw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Deenek, sa sa bis lɛɛ wɔ ɛ. Menaka wak ɛ́ nɛ botom bɛná zesilal ɛ sa ekɛk nɛ Zɛɛb ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nɔŋa bɛ, da bi ɛ kɛgwyia edhuud bɛ nɛ bɛ nɔɔ, bhii tak da wɔ ɛ́ kɛdjɛ bɛ efute ee di egoka ɛ, étɛp bɛ neetsik bɛ lo. Deenek, bot djas neegu náá, etɛp ee bot nadi lɛɛ dum nɛ nɛ ɛ nabɛɛ etɛp ee mɛkɔŋ, deenek dɔɔ nɛ wɔy pe wɔ nɛ duwal etsi ɛ Moiiz. ");
INSERT INTO bkw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Yɛ kabɛ bot ɛ membyak mesis di dum koŋ nɛ Zɛɛb ɔ, tɔ mɛkana mɛ bis nakwyala ɛ, ye nabɛ ɛ bis naalɛɛ bɛ egeka bis djas. Ye nabɛɛ náá: bɛ ààgoka nɛ ɛdɛ bɛtit ɛ kaa bɛzɛɛb ɛ elula-lula nɛ ekpaka-kpaka buwa ɛ, nɛ ghiya nɛ epuud e bɛtit ɛ góaa nɛ bhiyo ɛ, zɛnɔɔ náá, sa bi ààsa mɛzɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tin, Pɔl eezɛtɔ́ bɛ nɛ bot ɛna binɔk, tɔ yak dwoo tak, bee tɔ́ kɛsa mɛzel ɛsɛla etsi. Bhii tak bɛ eezɛtɔ́ pɛ kok Ndjaa-ebuwa etɛp ɛkɛlɛɛ dwoo mɛzel ɛsɛla etsi aasi ɛ, yɛ dwoo tak ɛ bɛ di egoka nɛ gó ebuwa kɔ ɛsu ɛ ngɔt-ngɔt pak'ɔɔ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ye nabɛ ɛ mɛlu mɛtɛn nɛ ebá moo kɔ nɛ kum, wɔ gwaa eYuda e kyee dik Azia zokazyɛ zɛbee Pɔl pɛ tɔ kok Ndjaa-ebuwa. Wɔ gwaa bɛ zɛful ɛdhuu ɛ bot ɛ nadi tin ɔ elo. Bhii tak, bɛ eezɛmɛt Pɔl, ");
INSERT INTO bkw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bɔɔ é tsim náá: «Bot ɛ Yisalaɛl, dhaaka zɛkwyee bis! Beeka mot di lyo bot djas é e di djas mbee mɛlyo dum nɛ Yisalaɛl, nɛ etsi ɛ Moiiz, zɛnɔɔ dum nɛ kok Ndjaa-ebuwa ɔ. Deenek, nyɛ eezebataniigal bot ɛ di ààdi bot ɛ mbyak eYuda ɔ tɔ Di na Dɛɛ. Tin, nyɛ eezesaab Di na Dɛɛ tak!» ");
INSERT INTO bkw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bɛ nalii deenek ɛ etɛɛ náá, ye nabɛɛ bɛ naabee Tolofim mot dɛl Efɛɛz bɛ Pɔl pɛ tɔ ghaada. Bɛ nagu ɛ náá, Pɔl naaniigal nyɛ tɔ kok Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ɛghuub ɛ tak eezɛdjala kɔ ghaada djas, bhwak moo tin metetel nɛ ekaab, e di djas é tɔ́ pɛ Pɔl nadi ɛ. Bɛ eezɛmɛt Pɔl, bɛ eezɛwyisal nyɛ tɔ kok Ndjaa-ebuwa, bhii tak bɛ eezɛdiyal mɛbɛ mɛ kok Ndjaa-ebuwa. ");
INSERT INTO bkw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dáa bɛ nadi é kwyɛl ɛgó Pɔl ɛ, ye nabɛ menduk mɛ ɛzɛm ɛ nadi sɛɛ pɛ Yeluzalɛm ɛ naagek pɛ dáa komanda mwaka esodja eLɔm. ");
INSERT INTO bkw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","E di tak wat, nyɛ eezɛnɔɔ bɛdhiiti ekukuma lɔɔg esodja, nɛ bɛdhiiti esodja é pɛ si, bɛ eezɛwyis kaab tɔ́ pɛ kyee ɛdhuu ɛ bot nadi ɛ. Dáa bɛ nabee komanda esodja nɛ bɛdhiiti esodja ɛ, bɛ ɛ́ boo zɛkat ɛ bi ɛ Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tin, komanda esodja eezɛtiila pɛ dáa lɛ, nyɛ zɛlwom náá, bɛ mɛt nyɛ, nyɛ eezɛlwom náá, bɛ kɔl nyɛ nɛ ekel é ghwooz ebá. Bhii tak, nyɛ eezɛdji nyɛ náá: «Wɔy ɛzɛ, wɔ sa ye?» ");
INSERT INTO bkw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tin, pɛ tɔ ɛdu ɛ bot, bɛdhiiti bot nadi tsim ɛ sa sis, bak tak dhiiti tɛp sis. Tin, ye nabɛ yee lyel náá, komanda mɛt sa wat tɔ ɛzɛm ɛ tak. Nyɛ ɛ́ booke náá, bɛ tɔ́ nɛ Pɔl pɛ mbwak. ");
INSERT INTO bkw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Dáa Pɔl nakum kɔ ɛgoel ɛ ndjaŋ ɛ, esodja ee naghwyil eezɛghɛɛ nyɛ é ɛkaab ɛlyel ɛ kuukuu mɛdhuu mɛ bot, ");
INSERT INTO bkw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","etɛɛ náá, bot djas nadi du nyɛ bɔɔ é tsitsim náá: «Góa nyɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Eghɛŋ bɛ nadi kwyɛl ɛniigal Pɔl tɔ mbwak ɛ, nyɛ zɛke nɛ komanda náá: «Mɛ ɛ nɛ ghwyil ɛ lii e?» Tin, komanda esodja eezɛdji nyɛ náá: «Wɔ nɛ gu ɛlii dhaad mbyak eGhɛlɛk e? ");
INSERT INTO bkw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Deenek wɔ tok mot dik Eziptɛ nazɛkus ɛghuub wak kpaambel da nyɛ zɛtɔ́ nɛ bot ɛ di gu ɛlumela dɛɛb ɔ bɛmil ɛna tɔ kyee bɔs bɛsyɛ di ààbɛ nɛ mɛdii ɛ ɔ?» ");
INSERT INTO bkw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tin, Pɔl eezɛbɔɔza náá: «Mam ɛ mot dhaad mbyak eYuda, mɛ nabyel ɛ pɛ ghaada Talase pɛ kyee dik Silisi ndiel kɔ dhiiti boo ghaada di nɛ boo ngek ɛ. Me mɛt wɔ ɛboŋ, beta náá, mɛ lii nɛ bot bak.» ");
INSERT INTO bkw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","É di'enek, komanda eezɛdjɛ nyɛ ze ɛlii. Tin, Pɔl eezɛtyaa tetel kɔ ɛbyetel, nyɛ eezɛpyap ɛdhuu ɛ bot binɔk mbɔ bɛ di gwyem étɛp bɛ neegwak nyɛ. Bɔɔ djas eezɛdi gwyem, tin nyɛ moo lii nɛ nɔɔ tɔ lii ebhele. ");
INSERT INTO bkw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Bɔn ɛ nyɛɛg bam nɛ bɛsɛɛg bam, gwak ka sa mɛ di lɛɛ bin nenak dum nɛ yam taŋal ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Dáa bɛ nadi gwak nyɛ nadi é lii tɔ lii ebhele ɛ, bɛ eebaazɛdi gwyem ɛnyɔɛpe, tin, Pɔl eezɛke náá: ");
INSERT INTO bkw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Mɛ ɛ mot dhaad mbyak eYuda, mɛ nabyel ɛ pɛ Talase pɛ kyee dik Silisi, deenek mɛ nawyilaa ɛ wak kɔ Yeluzalɛm. Deenek, lyoel yam nabɛ Ghamalyɛl, nyɛy ɛ nalyaal mɛ náá, mɛ tiibal ɛnyɔɛpe etsi bɛbhaab benaka. Mɛ nabɛ ɛ́ mɛ naakwyɛl mɛsa mɛ Zɛɛb dhaa nyel dáa biyɔ djas di ekwyɛl mos'aak. ");
INSERT INTO bkw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mɛ naawa bot ɛ nadi é du mɛze ɛ Ghɛŋ ɔ tɔ tsik mezuk batakɛ gó bɛ góa. Mee mɛt boa nɛ botom wa bɛ é membok. ");
INSERT INTO bkw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Boo ghaa-zɛɛb nɛ bot ɛ kwan bɛpaa ɛ nɛ ghwyil ɛ di bɛtyaasɛs náá, etɛp ee mɛ di lɛɛ ɛ tsɛɛtsɛ. Ye nabɛ ɛ bɛ naadjɛ mɛ mɛkana mɛ ɛtɔ́ pɛ dáa bɔn nyɛɛg bam yii dɛl ɛ Dhamas, deenek mɛ naatɔ́ pɛ ghaada tak. Mɛ nadi kwyɛl kɛɛmɛt bot ɛ tak, étɛp mɛ neetɔ́ nɛ nɔɔ pɛ Yeluzalɛm, bɛ neekɛ waaa é mezuk.» ");
INSERT INTO bkw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Mɛ nadi ɛ́ gba-gba mɛ moo kunaa nɛ dɛl ɛ Dhamas, ye nabɛ ɛ ye moo kunaa nɛ kuku mwos. Mɛ ka sɛka tin ɛ, boo ngel é dus tɔ gwoo, mɛkas mɛ tak eezɛkaal mɛ. ");
INSERT INTO bkw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tin, mɛ eezɛduma si, e di tak mɛ ka gwak ɛ dhiiti gwood é ke nɛ nam náá: “Sɔl, Sɔl, étɛp ye wɔ di tiig mɛ?” ");
INSERT INTO bkw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tin, mɛ eezɛdji náá: “Wɔy ɛ́ zɛ, Ghɛŋ?” Gwood'enek eezɛbɔɔza náá: “Ye ɛ́ mam Yezu mot Nazalɛt, wɔ di tiig ɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bot ɛ nadi gyee nɛ nam ɔ naabee ngel, saabɛgɔs kabɛ ɛ́ náá, bɛ na bɛ ààgwak gwood mot nadi lii nɛ nam ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tin, mɛ eezɛdji náá: “Mɛ goka nɛ sa dáa, Ghɛŋ?” É di'enek, Ghɛŋ eezɛke nɛ nam náá: “Wyɛla, Tɔ́a pɛ ghaada Dhamas. Ye ɛ́ penek ɛ bɛ aalɛɛ wɔ esa ee Zɛɛb ke náá, wɔ sa ɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Dáa ye nabɛ náá, mɛkas mɛ ngel tak naadipal mɛ mis ɛ, bot ɛ nadi gyee nɛ nam ɔ ɛ boo zɛmɛt mɛ é mbɔ, bɛ ɛ́ boozɛtɔ́ nɛ nam pɛ ghaada Dhamas. ");
INSERT INTO bkw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Kɔ dɛl ɛ tak ye nabɛ ɛ nɛ dhiiti mot din ɛ lɛ nabɛɛ Ananias, mot epiki nɛ esosoob tɔ etsi bena. Bot ɛ dhaad mbyak eYuda é Dhamas djas nadi duwal nyɛ ɛbuɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nyɛ eezɛboma nɛ nam, nyɛ eezɛtyaa é ngwoobam, nyɛ eezɛke nɛ nam náá: “Sɔl, mɔɔ nyaag'am, mis mɔ bɛŋel!” E di tak wat, mis mam eezɛbula é bee ɛnyɔɛpe, bhii tak mɛ eezɛbee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Deenek nyɛ eezɛbaakɛl náá: “Zɛɛb bɛbhaab binaka naazesɛɛ wɔ étɛp wɔ neegu ɛkwosak ɛ lɛ, wɔ neebee sim Mot Epiki da wɔ ɛ́ gwak gwoodɛ met, ");
INSERT INTO bkw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","etɛɛ náá, wɔ needi tyaasɛsɛ, étɛp wɔ neegoola nɛ bot djas sa wɔ bee ɛ nɛ yii wɔ gwak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tin, nenak wɔ ka baabwood ye? Wyɛla, kɛduwa Zɛɛb nɛ ɛgwyii ɛ mesyem mɔ, é ɛdjóo ɛ din ɛ lɛ.”» ");
INSERT INTO bkw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Mee zɛsik pɛ Yeluzalɛm. Dáa mɛ nadi é djaala Zɛɛb pɛ tɔ kok Ndjaa-ebuwa ɛ, wɔ gwaa mɛ zɛbee tyee tɔ dhyam. ");
INSERT INTO bkw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tin, mɛ eezɛbee Ghɛŋ, nyɛy nɛ nam náá: “Lela ɛdus kɔ Yeluzalɛm, etɛɛ náá, bot ɛ dɛl ɛ tak aanàkwaamyaal etɛp ee waalɛɛ bɛ kɔ ɛsu ɛ lam ɛ.” ");
INSERT INTO bkw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mɛ eezɛbɔɔza náá: “Ghɛŋ, bɛ nɛgu náá, mɛ nadi tetɔ́ tɔ mendjaa mɛ mendjaala mɛ eYuda étɛp ɛkɛmɛt bot, wa bɛ embok nɛ ɛbi ɛ bot ɛ nadi dum koŋ nɛ nɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tin, é ghɛŋ bɛ nagó Etiɛn tyaasɛsɔ ɛ, mam pe mɛ nadi ɛ́ e di tak. Mɛ naakɛm bot ɛ nagó nyɔ ɔ, mɛ naabaal ekaad bɔɔ.” ");
INSERT INTO bkw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Tin, Ghɛŋ eezɛke nɛ nam náá: “Tɔ́a, etɛɛ náá, mɛ waakyeed wɔ ɛtsetaɛpe, pɛ daa bot ɛ membyak mesis!”» ");
INSERT INTO bkw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ɛdhuu ɛ bot binɔk zokagwak Pɔl kɛkum e di'enek. Bhii tak, bɔɔ djas eezɛni é tsim náá: «Nyɛ góa, mbi mot dáak ààgoka nɛ di nɛ tsik kɔ bɔs'ak!» ");
INSERT INTO bkw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bɛ nadi tsim, nɛ ɛnyaŋ ɛ ekaad bɔɔ, é ghɛɛ piib wus pɛ ɛko. ");
INSERT INTO bkw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tin, komanda eLɔm eezɛlwom náá, bɛ niigal Pɔl tɔ ɛbɛsɛɛ ndjaa esodja, da bɛ ɛ́ nyuu nyɛ nɛ eghwyɛs étɛp nyɛ neetaŋal nɛ bhel. Nyɛ nasa deenek ɛ étɛp bɛ neegu lo mɛsɔ mɛ mɛdhuu mɛ bot nadi tsim deenek kɔ ɛsu ɛ lɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Tin, dáa bɛ nakɔl nyɛ étɛp bɛ neenyuu nyɛ ɛ́, Pɔl eeke nɛ dhiiti kukuma tɔ lɔɔg esodja ee nadi tin ɔ náá: «Bi ɛ nɛ gham ɛbi ɛ mot dik eLɔm di náá, nyɛ dinaa ààpaapɛɛaa ɛ, dáa mɛtiŋ mɛ eLɔm di lɛɛ ɛ?» ");
INSERT INTO bkw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Dáa kukuma esodja tak nagwak mɛkpa menek ɛ, nyɛ ɛ́ bootɔ́ kɛdul komanda mɛlɔ: «Nyee zɛke nɛ nɛ náá, wɔ kwyɛl ɛsa ye? Mot'ak ɛ mɔɔ dik eLɔm!» ");
INSERT INTO bkw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tin, komanda eezɛzyɛ pɛ paa Pɔl nadi ɛ, nyɛ eezɛdji nyɛ náá: «Lɛɛa mɛ, ye ɛ́ tsɛɛtsɛ náá, wɔ ɛ́ mɔɔ dɛl ɛ eLɔm?» Pɔl eezɛmyaal náá: «Iyoo». ");
INSERT INTO bkw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tin, komanda esodja eezɛke náá: «Mam naadjɛ boo mɛtaŋ mɛ epata étɛp mɛ needi mɔɔ dɛl ɛ eLɔm.» Pɔl eezɛbɔɔza nɛ nɛ náá: «Yam ɛ yii mbyela mɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","É di tak wat bot ɛ nadi ekwyɛl ɛbi nyɛ étɛp bɛ neebesal nyɛ, nyɛ lii nɛ bhel eezɛbula pɛ bhis ɛtsetaɛpe nɛ nɛ. Tin, komanda esodja naazɛgwak bwoo dáa nyɛ nagu náá, Pɔl nabɛ ɛ́ mɔn ɛ dɛl ɛ eLɔm, bela náá, nyɛ naazelwom náá, nyɛ kɔlaa nɛ eghwooz ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Komanda esodja nadi kwyɛl ɛgu ɛnyɔɛpe lo mɛsɔ mɛ eYuda nadi pit Pɔl ɛ. É tɛp tak ɛ di náá, é djɛmɛn yii ɛlu ɛ tak, nyɛ eezɛlwom náá, bɛ tii nyɛ ekel eghwooz nyɛ nakɔlaa nɛ ye ɛ́. Nyɛ eezɛdjóo eboo bɛghaa-Zɛɛb, zɛnɔɔ bot ɛ boo kwan bɛtetɛp eYuda. Bhii tak, nyɛ eezɛzyɛ nɛ Pɔl, tin, nyɛ eezɛpɛɛaa é mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔl eezɛgwyák bot ɛ zɛɛga boo kwan eYuda «kpɛɛɛ», nyɛ eezɛke náá: «Bɔn ɛ nyɛɛg yɛ nɛ lyem'am selele ɛ mɛ sa mɛsa mɛ Zɛɛb kɛkum dwoo pan mos'ak.» ");
INSERT INTO bkw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Dhiiti boo ghaa-Zɛɛb Ananias eezɛlwom bot ɛ nadi e ngwoob ɛ Pɔl ɔ náá, bɛ nyuu nyɛ e nuub. ");
INSERT INTO bkw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tin, Pɔl eezɛke nɛ nɛ náá: «Ye ɛ́ Zɛɛb ɛ́ aapaamyak wɔ, biyɔ epap ee zelɔɔbaa ɛpyaab ɔ, bot ɛ mɛdjhaaz pɛ ɛko, bhimis pɛ si! Wɔ di tin ɛ étɛp wɔ neepɛɛ mɛ dum nɛ etsi ɛ Moiiz, bela náá, wɔy ààduwal etsi tak, etɛɛ náá, wɔ eelwom náá bɛ myak mɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bot ɛ nadi é ngwoob ɛ Pɔl ɔ é zɛke nɛ nɛ náá: «Wɔ lee ɛ boo ghaa-Zɛɛb ɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pɔl eezɛbɔɔza náá: «Bɔn ɛ nyɛɛg, mɛ bɛ ààgu náá, ye bɛ ɛ́ boo ghaa-zɛɛb. Etɛɛ náá, Ekwyala lɛɛ ɛ náá: “Sa wɔ aalii ɛbyɔɛɛpe nɛ dhiiti kukuma bot ɛ mbyak en!”» ");
INSERT INTO bkw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pɔl nadi é gu náá, tɔ zɛɛga boo kwan eYuda tak, ye nabɛɛ, kyee wat eSaduseɛ yak kyee eFalizyɛ. Etɛp tak ɛ nyɛ natsim ɛlyelɛpe kuku ɛbwak ɛ lɔ náá: «Bɔn ɛ nyɛɛg, mɛ ɛ Falizyɛ, mot nabya mɛ ɔ nyɛ Falizyɛ. Mɛ ɛ nɛ ɛbwaalel náá, Zɛɛb ɛ waagomal bot bhis ɛsyee, etɛp tak bi di pɛɛ mɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Dáa nyɛ nazosilal ɛ lii deenek ɛ, eFalizyɛ bɛ nɛ eSaduseɛ «tombooo» nɛ ɛwɔ pak'ɔɔ, tin, zɛɛga eebɛka. ");
INSERT INTO bkw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Deenek, bɛ nadi suu mɛso ɛ etɛɛ náá, eSaduseɛ ke ɛ náá, ɛgom bis ɛsyee tok, efofop tok, sisim tok. Yɛ kabɛ eFalizyɛ ɔ, bɔɔ nɛ myaal yɔbɔ náá, esonok binek djas tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bot djas moo tin é tsim ɛlyelɛpe, tin, bɛdhiiti bɛghaŋ ɛ mɛkana mɛ etsi, bot ɛ nadi bot ɛ sama eFalizyɛ ɔ e zɛwyɛl, bɛ eezɛbyen lek tak ɛlyelɛpe, bɔɔ náá: «Bis ààpabee dhiiti tɛp ɛbiyo tɔ mot'ak. Dhiiti sisim nɛghu dhiiti fofop eelii bilaa nɛ nɛ!» ");
INSERT INTO bkw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Dáa ye nadi náá, ɛwɔ nadi bɔk, ɛbɔk nɛ ɛbɔk daa tye ɛ́, wɔ gwaa komanda zɛbela bwoo é kaab náá, bɛ zɛɛgɛ duma Pɔl ɛ nyel da gó nyɛ. Tin, nyɛ ɛ́ boolwom esodja bɛ náá, bɛ sul pɛ zɛɛga kwan, bɛ neekɛpɛk Pɔl é mɛmbɔ mɔɔ, bhii tak da bɛ ɛ́ sik nɛ nɛ pɛ ɛbɛsɛɛ esodja. ");
INSERT INTO bkw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","E yak pum bhii tak, Ghɛŋ eezɛlyaal Pɔl nyel, nyɛy nɛ nɛ náá: «Dia nɛ mɛghaaz! Wɔ eedi tyaasɛs'am wak, kɔ ghaada Yeluzalɛm, deenek, egoka wɔ tɔ́ kɛsa yɛ pɛ ghaada Lɔm.» ");
INSERT INTO bkw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Dáa mɛlem nakalem ɛ, dhiiti ba bim eYuda eezɛgwakel e boob, bɛ eezɛtuwal myoŋ nɛ mɛsoŋ mɔɔ náá, bɛ aanàkwaadɛ edee nɛ mɛdii ɛsok nɛ bɛ nɛ pookogó Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bot ɛ nagwakel é boob tak ɔ naadhaa bot mɛkam-mɛná. ");
INSERT INTO bkw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bɛ eezɛtɔ́ kɛbee eboo bɛghaa-Zɛɛb nɛ bɛpaa, tin, bɛ eezɛke nɛ nɔɔ náá: «Bisɔ, bis eegwakel nɛ ɛtuwal myoŋ nɛ mɛsoŋ mis nɛ tsɛɛtsɛ náá, bis aanàkwaadɛ edee bis dinaa ààgó Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Deenek, biyɔ, sama wat nɛ bot ɛ zɛɛga boo kwan eYuda, kɛwaab ka nenak nɛ komanda náá, nyɛ zyɛ bin nɛ Pɔl, kɔɔ ka nyɛ náá, bi ɛpekwyɛl ɛdjek tɛpɛ ɛnyɔɛpe. Yɛka bɛ bisɔ ɔ, bis aadi ɛ́, é bwood nyɛ étɛp bis neegó nyɛ, ɛsok nɛ nyɛ nɛ kum wak.» ");
INSERT INTO bkw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Tin, dhiiti mɔɔ kɛl ɛ Pɔl, zokagwak dáa bɛ nadi é lii e boob ɛ. Nyɛ eezɛtɔ́ pɛ ɛbɛsɛɛ esodja, bɛ eezɛniigal nyɛ, etɛp ɛkɛlɛɛ Pɔl etɛp ee bot binɔk nadi lii dum nɛ nɛ ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tin, Pɔl eezɛdjóo dhiiti kukuma tɔ lɔɔg esodja, nyɛ eezɛke nɛ nɛ náá: «Tɔ́a nɛ mɔɔ ngbaaz'ak pɛ dáa komanda, etɛɛ náá, nyɛ ɛ́ nɛ tɛp nyɛ aalɛɛ nyɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kukuma esodja eezɛnɔɔ nyɛ, nyɛ eetɔ́ nɛ nɛ dáa komanda, nyɛy nɛ nɛ náá: «Mot membok Pɔl bɛ ɛ́ nyɛ eedjóo mɛ, nyɛ eezɛke nɛ nam náá, mɛ zyɛ wɔ nɛ mɔɔ ngbaaz'ak. Nyɛ ɛ́ nɛ tɛp ɛlɛɛ wɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kukuma esodja eezɛmɛt mɔɔ ngbaaz tak é mbɔ, nyɛ eezɛdul nyɛ e ngwoob bɔɔ bɛbá. Tin, nyɛ eezɛdji nyɛ náá: «Wɔ kwyɛl ɛlɛɛ mɛ ye?» ");
INSERT INTO bkw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nyɛ eezɛbɔɔza náá: «eYuda eegwakel náá, bɛ ɛpezɛwaab náá, djɛmɛn, Pɔl tɔ́ sok bhwoob boo kwan eYuda. Bɛ aakɔɔ ɛ náá, bot ɛ tak ɛpekwyɛl ɛdjek tɛpɛ ɛnyɔɛpe. ");
INSERT INTO bkw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","É di'enek, sa wɔ ààmyaal bɛ, etɛɛ náá, bot dhaa bot mɛkam-mɛná pak'ɔɔ waalaab nyɛ. Bɛ sa deenek ɛ etɛɛ náá, bɛ eezegwakel nɛ ɛtuwal myoŋ nɛ mɛsoŋ mɔɔ náá, bɛ aanàkwaadɛ edee nɛ mɛdii ɛsok nɛ bɛ nɛ gó nyɛ. Bɛ eezekoobal etyɛ bɛ zokabwood ɛ wɔ myaal.» ");
INSERT INTO bkw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Bhis komanda nalɛɛ nɛ mɔɔ ngbaaz tak náá, sa nyɛ ààlɛɛ bot etɛp ee nyɛ baŋa nyɛ ɛ́, nyɛ eezɛswaal nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Bhii tak komanda eezɛdjóo bɛdhiiti ekukuma esodja bɛ bɛbá, nyɛ eezɛke nɛ nɔɔ náá: «Sɛɛgka esodja bɛdhet ɛbá dɔɔ nɛ esodja ee di kɛkɔ eyaaga ɛ mɛkam-mɛtɛn nɛ mɛkam-mɛmbá, zɛnɔɔ bot bɛdhet ɛbá nɛ mɛkɔɔ mɔɔ, koobalka étɛp ɛtɔ́ pɛ ghaada Seezale é ɛwala ɛ elɛl bhis ɛgwyiidela ɛgwyitok. ");
INSERT INTO bkw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Dáa bi ɛ baakoobal dɔɔ nɛ eyaaga, étɛp bi neebɛp Pɔl tɔ́ nɛ nɛ, nyel ɛnyɔɛpe pɛ dáa mɛkoozi dik Feliksɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Bhii tak nyɛ eezɛkwyal mɛkana náá: ");
INSERT INTO bkw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Mam Kolood Lyzias ɛpeswos, wɔy dhaandiŋaa Feliksɛ mɛkoozi mɛ dik. ");
INSERT INTO bkw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ye bɛ ɛ́ eYuda eemɛt mot mɛ dhis bin nwyak'enok, tin, bɛ di kwyɛl ɛgó ɛ nyɛ. Dáa mɛ nagwak náá, nyɛ nadi ɛ́ mot eLɔm ɛ, bis nɛ esodja bam ɛ boo kɛlyak, bis eezɛpɛk nyɛ e mɛbɔ mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dáa mɛ nadi kwyɛl ɛgu lo mɛsɔ mɛ eYuda nadi pit nyɛ dum nɛ tak ɛ, mɛ naazɛtɔ́ nɛ nɛ sok bhwoob zɛɛga boo kwan eYuda. ");
INSERT INTO bkw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mɛ eezɛgu náá, bɛ nadi pit nyɛ kɔ ɛsu ɛ etɛp e di dum nɛ etsi bɔɔ ɛ, bela náá, bɛ na bɛ ààbɛ nɛ tɛtɛ tɛp nyɛ nadi goka nɛ ɛgóaa nɛghu ɛ mɛtaa e mbok kɔ ɛsu ɛ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Bhii tak bɛ naazɛlɛɛ mɛ náá, eYuda nadi gwakel etɛp ɛgó ɛ nyɛ, deenek mɛ booke e di tak wat náá, mɛ dhis bin nwyak. Tin, mɛ ɛ́ boolɛɛ nɛ bot ɛ zɛpit nyɛ ɔ náá, bɛ zɛpit nyɛ pɛ dáa ɛ lɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Esodja eezɛsa dáa komanda yɔɔ nalɛɛ bɛ ɛ. Bɛ eezɛnɔɔ Pɔl tɔ́ nɛ nɛ pum ɛ pum kɛkum pɛ ghaada Antipatilis. ");
INSERT INTO bkw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","E yak mɛlem, esodja ee natɔ́ nɛ mɛko ɔ eezɛbula yɔbɔ pɛ ɛbɛsɛɛ esodja, tin, bɛ eezɛbet bot ɛ nadi kɔ eyaaga ɔ bɛ goola mɛdjoŋ mɔɔ nɛ Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Dáa bɛ nakum pɛ Seezale ɛ, esodja ee nazyɛ kɔ eyaaga ɔ boodjɛ kukuma dik mɛkana mɛ komanda nadhis ɛ, bhii tak bɛ eezɛlyaal ɛ Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kukuma dik eezɛlaa mɛkana, bhii tak nyɛ eezɛdji Pɔl, mot kyee dik nyɛ nadi ɛ. Bhis nyɛ nagwak náá, nyɛ ɛ́ mot kyee dik Silisi ɛ, ");
INSERT INTO bkw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nyɛ eezɛke nɛ nɛ náá: «Mɛ aadji wɔ mɛdjin ɛ, esok bot ɛ zɛpit wɔ aakum ɛ.» Nyɛ eezɛlwom náá, bɛ baal Pɔl pɛ tɔ ndjaa mɛkoozi ɛ Elood. ");
INSERT INTO bkw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Mɛlu mɛtɛn bhii tak, boo ghaa-Zɛɛb Ananias eezɛkum pɛ ghaada Sezaade bɛ nɛ bɛdhiiti bɛpaa, zɛnɔɔ mot ghɛm taŋal nɛ din ɛ Tɛɛltulus. Bɛ naazɛzyɛ pɛ daa kukuma dik etɛp bɛ neezɛlɛɛ nyɛ mɛsɔ mɛ mɛpita mɛ bɛ napit Pɔl ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bɛ naazɛdjóo Pɔl, tin, Tɛɛltulus naazɛpit nyɛ, nyɛ náá: «Dhaandiŋaa Feliksɛ, kɔ ɛsu ɛ lɔ ɛ bis di wak mos tɔ egwyem e étɛp djas. Ye ɛ́ dum nɛ esosoobɔ nɛ dáa wɔ di pɛ́ɛ étɛp ɛ bis di bee ɛswoola tɔ dhaad mbyak is. ");
INSERT INTO bkw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bis eeghaapɛɛ wɔ dum nɛ embɛɛ esesɛɛ djas bis di bela e mɛwala djas nɛ e di djas ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Deenek mɛ ààpakwyɛl ɛdulal wɔ tɛp ɛdjaŋɛpe, etɛp tak ɛ mɛ kwyɛl náá, wɔ di nɛ mbɛɛ lyem e ɛgwak bis ba mɔɔ pes ɛwala. ");
INSERT INTO bkw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bis eebee náá, mot'ak ɛ mbee mot dhaa nyel: dáa di náá, nyɛ ɛ́ kukuma zɛɛga eNazaleyɛ ɛ́, nyɛ ɛpekus ɛghuub tɔ bot ɛ mbyak eYuda djas kɔ bɔs. ");
INSERT INTO bkw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Nyɛ nabɛɛ nyɛ eekwyɛl ɛtukusa edɛɛ e Ndjaa-ebuwa. Tin, bis ɛ boo mɛt nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Wɔ dji nyɛ ɔ, wɔ ɛ nɛ ghwyil ɛgu wɔy ɛmet etsɛɛtsɛ e étɛp ee bis zɛpit nyɛ kɔ ɛsu ɛ tak ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tin, ekukuma eYuda naazɛkɛm taŋal tak, bɔɔ náá, étɛp ee nyɛ lii ɛ ye ɛ́ tsɛɛtsɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kukuma Feliksɛ naazɛsa dhiiti tseŋa ɛlɛɛ nɛ Pɔl náá, nyɛ lii, é di'enek Pɔl ɛ booke náá: «Mɛ nɛ gu náá, wɔ moo mos ɛ nɛ membu ɛbuɛpe ee wɔ di sa mɛsa mɛ epiki kɔ kyee bɔs'es ɛ. Etɛp tak ɛ mɛ di nɛ ɛbwaalel ɛ ɛtaŋal e mis mɔ. ");
INSERT INTO bkw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wɔ ɛ nɛ ghwyil ɛ saa ɛgu wɔy wɔ ɛmet, mɛ moo mos ɛ nɛ mɛlu kam nɛ ebá ee mɛ natɔ́ pɛ ghaada Yeluzalɛm etɛp ɛkɛduwal Zɛɛb. ");
INSERT INTO bkw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ye tok nɛ mot zɛbela mɛ pɛ tɔ kok Ndjaa-ebuwa é waya bis nɛ dhiiti mot, nɛghu é ful ɛdhuu ɛ bot elo, ààbaabɛ-bɛak tɔ ndjaa mendjaala mɛ eYuda nɛghu é dhiiti di sis kɔ ghaada. ");
INSERT INTO bkw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bot bak tok nɛ ghwyil ɛ lyaal wɔ ɛnyɔɛpe etɛp ee bɛ zɛpit mɛ kɔ ɛsu ɛ tak ɛ nenak. ");
INSERT INTO bkw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bela náá, sa mɛ di myam e mis mɔ ɛ náá, mɛ eemyaal ɛdu ɛ mɛze ɛ Ghɛŋ, bɔɔ di ke náá, ye ɛ́ zɛɛga bot ɛ di djaala mbee bɛzɛɛb ɔ. Deenek, mam duwal ɛ Zɛɛb bɛbhaab benaka. Tin, mɛ nɛ ɛmyaal nɛ etɛp ee di kwyala tɔ bɛmɛkana mɛ etsi nɛ bɛngoolel ɛ mɛkpa ɛ Zɛɛb ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mɛ nɛ ɛbwaalel ɛ tak nɛ Zɛɛb, ɛbwaalel ɛ tak wat ɛ bɛ baazo di nɛ yɛ, ye ɛ́ náá, ye nakozo zo di bot ɛ mbee mɛfulu, nɛghu bot ɛ epiki, bɛ waagom bis ɛsyee. ");
INSERT INTO bkw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","É tɛp tak mɛ di sa mɛghaaz mɛ ɛnɛɛg lyem'am sɛŋ mɛlu djas e mis mɛ Zɛɛb nɛ e mis mɛ bot. ");
INSERT INTO bkw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Bhis mɛ nadi ààbɛ kɔ dɛl membu ɛbuɛpe ɛ, mɛ eebula pɛ Yeluzalɛm étɛp ɛ zɛkwyee bot ɛ mbyak'am, nɛ zɛdjɛ Zɛɛb ebuwa. ");
INSERT INTO bkw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mɛ nabɛɛ mɛ eezesa ɛbyoŋ ɛ ɛdis edhuud bam, bhii tak ɛ bɛ nazɛbela mɛ tɔ kok Ndjaa-ebuwa ɛ. Ɛdhuu ɛ bot nàbɛ ààdi tin, ààkobɛ-bɛak nɛ ɛzɛm. ");
INSERT INTO bkw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tin, bɛdhiiti eYuda e kyee dik Azia nadi ɛ́ tin. Deenek, tɛp ɛ pe dye ɛ́ di ɔ, pe ye ɛ́ bɔɔ waazyɛ zɛpit mɛ pɛ daa lɔ. ");
INSERT INTO bkw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Yɛ di ààbɛ deenek ɔ, bot bak kaa zyɛ zɛlɛɛ mɛ embee esesɛɛ mɛ sa ɛ. Nɛghu náá, esok mɛ kɛtaŋal sok bhwoob zɛɛga boo kwan eYuda ɛ ye bɛ mɛ eekwyɛ ndjɛ sɔs é mis mɔɔ. ");
INSERT INTO bkw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nɛghu yɛ kɔ ɛsu ɛ mɛ ke sok bhwoob zɛɛga boo kwan eYuda náá, “mɛ eemyaal náá, bot ɛ waagom bis ɛsyee, bɛ zɛpɛɛa mos e mis mɔ!”» ");
INSERT INTO bkw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliksɛ mot nadi gu ɛnyɔɛpe etɛp djas e zɛɛga bot ɛ di du mɛze ɛ Ghɛŋ ɔ eezɛswaal tɛp tak, etɛɛ ye neeliiaa dhiiti dwoo, nyɛy nɛ bot ɛ napit Pɔl ɔ náá: «Mɛ aapɛɛ tɛpen ɛ esok komanda esodja Lyzias aazyɛ ɛ́.» ");
INSERT INTO bkw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nyɛ naazɛlwom dhiiti kukuma tɔ lɔɔg esodja náá, nyɛ baal Pɔl e di nyɛ nanɛɛgaa ɛ, nyɛ eezɛke náá, bɛ djɛ nyɛ ba ɛpɛɛd etɛp bɛsɔ bɛ neegheezyɛ zɛkwe-kwee nyɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ba mɛlu bhii tak, Feliksɛ naazɛzyɛ bɛ nɛ myɛl Dulusil nadi moma dhaad mbyak eYuda ɔ. Nyɛ naazɛlwom náá, bɛ kɛ ɛnɔɔ Pɔl, bhii tak nyɛ eezɛgwak sa Pɔl nadi lii dum nɛ ɛdum ɛ koŋ nɛ Yezu Klisto ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","E sok Pɔl nakan ɛlii dum nɛ tɛtɛ lek epiki e tsik ɛ, nɛ ɛgu ɛdil ɛ lyem, zɛnɔɔ epɛ́ɛ e Zɛɛb di zyɛ pɛ sok yenek. Tin, Feliksɛ moo tin ɛ́ «nya-nyaa», nyɛ ɛ́ boozɛke náá: «Yɛ eedjala, wɔ ɛ́ nɛ ghwyil ɛkatɔ́, esok mɛ aabela ba mɔɔ ɛpɛɛd ɛ ɛwala ɛ, mɛ waadjóo wɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nyɛ nadi ebwaal ɛ náá, Pɔl ɛ́ waadjɛ nyɛ epata, étɛp tak ɛ nyɛ nadi edjóo nyɛ ngwyis, bɛ zɛmɔ bɛ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Membu membá naazɛdhaa deenek, tin, Pɔlsius Fɛstus naazɛgila Feliksɛ kɔ boo ekukuma dik. Dáa yenɔk tak nadi esaa náá, eYuda kwyɛl nyɛ ɛ́, nyɛ naazɛbet Pɔl kɔɔla e mbok. ");
INSERT INTO bkw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mɛlu mɛlɛl bhis nyɛ nakum pɛ kyee dik tak ɛ, Fɛstus naazɛdus pɛ ghaada Seezale tɔ́ pɛ ghaada Yeluzalɛm. ");
INSERT INTO bkw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Penek ɛ, eboo bɛghaa ɛ Zɛɛb nɛ bɛdhil ɛ bot eYuda nakɛpit Pɔl pɛ daa lɛ ɛ. Bɛ naazɛdjaala nɛ nɛ náá, ");
INSERT INTO bkw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","nyɛ myaal ɛswaal bɛ Pɔl pɛ Yeluzalɛm. Bɛ nake deenek ɛ etɛɛ náá, ye nabɛɛ bɛ naazedi boob kɔ ɛsu ɛ lɛ, tin, bɛ nadi kwyɛl ɛgó nyɛ e ze. ");
INSERT INTO bkw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Tin, Fɛstus naazɛbɔɔza náá, Pɔl ɛ e membok pɛ Seezale, ye ka lik ɛ batsa nyɛy ɛmet neesik pɛ ghaada tak. ");
INSERT INTO bkw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bhii tak nyɛ naabaazɛke náá: «Egoka ɛ náá, ekukuma bin zyɛ bis nɛ bɛ nɔɔ pɛ Seezale, bɛ zɛpit mot tak, yɛ bɛ náá, nyɛ eesa etɛp ɛbiyo ɔ.» ");
INSERT INTO bkw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstus zokazɛdjaasi, tin bɛ nɛ bɛ nɔɔ tyee mɛlu mɛtɛn nɛ elɛl nɛghu kam, bhii tak nyɛ naazɛsik pɛ Seezale. E dwoo nabɔɔba ɛ, nyɛ naazɛdisi pɛ sum di bɛ di pɛɛ bot ɛ, nyɛ naazɛlwom náá, bɛ kɛnɔɔ Pɔl. ");
INSERT INTO bkw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Dáa nyɛ nakakum ɛ, eYuda nadus pɛ Yeluzalɛm ɔ naazɛwa nyɛ kuku ɛbwak. Wɔ gwaa bɛ zokazɛsu nyɛ bɛtɛ nɛ embee etɛp mɛpita mɛ bɔɔ bɛmet di ààbɛ nɛ ghwyil ɛlyaal mɛsɔ mɛ tak ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Tin, Pɔl naazɛtaŋal yɛ, nyɛy náá: «Mɛ ààpasa pɔtɔ dum nɛ etsi eYuda, ààkobɛ dum nɛ Ndjaa-ebuwa, ààkobɛ bɛa dum nɛ Sezaad mɛkoozi mɛ Lɔm.» ");
INSERT INTO bkw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛstus mot nadi kwyɛl ɛsa náá, eYuda neekwyɛl nyɛ ɔ, ɛ boozɛdji Pɔl náá: «Wɔ ɛpɛkwyɛl ɛtɔ́ pɛ Yeluzalɛm etɛp wɔ neekɛpɛ́ɛaa e mis mam dum nɛ tɛp'ak e?» ");
INSERT INTO bkw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pɔl naazɛbɔɔza náá: «Mɛ ɛ tetel sok bhwoob di epɛ́ɛ e Sezaad, deenek, ye ɛ́ wak ɛ mɛ di egoka nɛ ɛpɛ́ɛaa. Ye tok nɛ mbee sa mɛ sa eYuda dáa wɔy wɔ ɛmet di gu yenek. ");
INSERT INTO bkw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nɛghu mɛ ɛ nɛ ndjɛ ɔ, yɛ bɛ mɛ eesa sa mɛ di egoka nɛ ɛgóaa kɔ ɛsu ɛ tak ɔ, mɛ ààpabyen ɛsyee. Deenek, yɛ kabɛ náá, étɛp e mɛpita mɛ bot bak pit mɛ ye tok tsɛɛtsɛ ɔ, mot tok nɛ ghwyil ɛ seeb mɛ e mɛmbɔ mɔɔ. Ye ɛ́ mɛ di lii nɛ Sezaad mɛkoozi mɛ Lɔm mot di egoka nɛ ɛpɛ́ɛ mɛ dum nɛ sa mɛ sa ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Deenek, dáa Fɛstus nasilal ɛlii bɛ nɛ bɛtsoŋ ɛ bot bɛ ɛ, nyɛ naazɛbɔɔza náá: «Dáa wɔ tuwal din ɛ boo mɛkoozi ɛ, wɔ aakakɛtaŋal ɛ sok bhwoob ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ba mɛlu bhii tak, mɛkoozi Aghilipa bɛ nɛ Bheelenis kɛl naazɛkum pɛ Seezale etɛp ɛkɛswos Fɛstus. ");
INSERT INTO bkw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Dáa nyɛ nadi nɛ bɛtɛ nɛ mɛlu tin ɛ, Fɛstus naazɛlii nɛ mɛkoozi étɛp ɛ Pɔl náá: «Wak, ye ɛ́ nɛ dhiiti mot Feliksɛ nalik e mbok ɔ. ");
INSERT INTO bkw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Eghɛŋ mɛ natɔ́ pɛ Yeluzalɛm ɛ, ekukuma e bɛghaa-Zɛɛb, nɛ bɛpaa eYuda naazɛpit nyɛ. Bɛ naazɛke nɛ nam náá, mɛ djɛ nyɛ ndjɛ sɔs. ");
INSERT INTO bkw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mɛ ɛ boozɛbɔɔza nɛ nɔɔ náá, eLɔm tok nɛ mɛfulu mɛ ɛka mot e mɛmbɔ mɛ bot ɛ zɛpit nyɛ ɔ, bɛtetɛp dinaa ààgwak yɛ taŋal. ");
INSERT INTO bkw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bɛ zyɛ wak pɛ Sezaale ɛ bis nɛ bɛ nɔɔ. Mɛ bɛ ɛ́ ààka baakwyɛl bɔya-bɔya, mɛ eenɔɔ di é sum di bot di pɛɛaa ɔ. Tin, djɛmɛn tak, mɛ eezɛlwom náá, bɛ zyɛ nɛ mot tak. ");
INSERT INTO bkw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bot ɛ nadi é pit nyɛ ɔ eezɛzyɛ, e dieneek, bɛ ààpatuwal dhiiti mbee tɛp nyɛ sa ɛ. Tin, mɛ naasaa sa mɛ sa. ");
INSERT INTO bkw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bɛ nɛ bɛ nɔɔ nazosuu ɛ mɛso dum nɛ Zɛɛbɔ met, dɔɔ nɛ kɔ ɛsu ɛ dhiiti mot din ɛ lɛ ɛ Yezu. Mot nazegwyɛ, da Pɔl ɛ di é ke náá, nyɛ ɛ́ nɛ tsik ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Yɛka bɛ mam ɔ, mɛ bɛ ààbee tyee mɛ lii mbi yenek tɛp ɛ. Etɛp tak ɛ mɛ dji Pɔl náá, nyɛ kwyɛl ɔ, nyɛ tɔ́ pɛ Yeluzalɛm, etɛp nyɛ neekɛpɛ́ɛaa dum nɛ tɛp tak. ");
INSERT INTO bkw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Tin, Pɔl eebyen, nyɛ booke náá, nyɛ di e mbok kɛkum dwoo boo mɛkoozi mɛ dik eLɔm nyɛ ɛmet pɛ́ɛ tɛp tak ɛ. Mɛ ɛ́ boozɛlwom náá, nyɛ nɛɛga e mbok, kɛkum dwoo mɛ aakyeed nyɛ pɛ dáa Sezaad mɛkoozi mɛ dik ɛ.» ");
INSERT INTO bkw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aghilipa eezɛke nɛ Fɛstus náá: «Mɛ kwyɛl ɛ mɛ gwak mot'ak mam ɛmet nɛ mɛlɔ mam.» Fɛstus eezɛbɔɔza náá: «Wɔ waagwak nyɛ djɛmɛn.» ");
INSERT INTO bkw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","E yak mɛlem mɛ tak e, Aghilipa bɛ nɛ Bheelenis naazɛtuula nɛ zukamwaa mot nɛ boo duu djas bɛ nɛ ekomanda esodja nɛ bɛdhil ɛ bot ɛ ghaada. Wɔ gwaa bɛ zɛni tɔ boo wal bɛ nadi zyɛ nɛ pepɛ́ɛ ɛ bot. Fɛstus naazɛke náá, bɛ zyɛ nɛ Pɔl, tin, bɛ naazyɛ nɛ nɛ. ");
INSERT INTO bkw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","É di'enek, Fɛstus naazɛke náá: «Mɛkoozi Aghilipa nɛ biyɔ bot ɛ di wak'ak, bi ɛpebee mot'ak e. Bot ɛ dhaad mbyak eYuda djas eezyɛ zɛpit nyɛ pɛ daa lam, kana pɛ Yeluzalɛm zɛkum wak, etsim bɔɔ ɛ náá, nyɛ ààkagoka nɛ tsik. ");
INSERT INTO bkw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Yɛka bɛ mam ɔ, mɛ bee ɛ náá, nyɛ ààpasa dhiiti tɛp di egoka náá, nyɛ góaa etɛp tak ɛ. Bela náá, nyɛy nakuma nyel bɛ ɛ́ nyɛ eelɛɛ náá, bɛ tɔ́ nɛ nɛ sok bhwoob ɛ boo mɛkoozi mɛ dik eLɔm, mɛ eemyaal ɛkyeed ɛ nyɛ nwyak. ");
INSERT INTO bkw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Tinaak, mɛ tok nɛ tɛtɛ mɛsɔ mɛ mɛ aakwyal mɛkana kyeed daa boo mɛkoozi dum nɛ tɛpɛ. Etɛp tak ɛ mɛ sa náá, nyɛ taŋal e mis men, deenek, e mis mɔ, wɔy mɛkoozi Aghilipa. Etɛɛ náá, bhis mɛdjin mɛ bi aadji nyɛ ɛ́, mɛ neebela sa mɛ waakwyal tɔ mɛkana ɛ. ");
INSERT INTO bkw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Etɛɛ náá, ɛkyeed ɛ mot membok pɛ dɛl ɛ Lɔm ààbɛ nɛ lo mɛsɔ mɛ nyɛ mɛtaa etɛp tak ɛpepip mam e mis.» ");
INSERT INTO bkw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mɛkoozi Aghilipa eezɛke nɛ Pɔl náá: «Bɛ eedjɛ wɔ ze wɔ taŋal.» Tin, Pɔl naazɛghɛɛ mbɔ etɛp nyɛ neelii. Wɔ gwaa nyɛ zɛkan ɛzɛtaŋal náá: ");
INSERT INTO bkw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Mɛkoozi 