﻿USE sofia;
DROP TABLE IF EXISTS sofia.bkqNT_vpl;
CREATE TABLE bkqNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bkqNT_vpl WRITE;
INSERT INTO bkqNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesus Cristo wâgâ ise unâgu. Davi iwerypyry myakâwâm Jesus Cristo, Davi pylâ Abraão iwerypyry-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Saguhoem kuru ise Jesus idamudo kâengatuly, Abraão donropyrylâ, pymâ Daviram. Abraão myakâwândy Isaque nhunwym; Isaque, Jacó nhunwym. Jacó, Judá, iwaigorudolâ warâ nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, Peres, Zera warâ nhunwym. (Tamar myakâwândy isemo ezedy.) Peres, Esrom nhunwym. Esrom, Arão nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arão, Aminadabe nhunwym. Aminadabe, Nasom nhunwym. Nasom, Salmom nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmom, Boaz nhunwym. (Boaz ise myakâwândy Raabe keho.) Boaz, Obede nhunwym. (Obede ise myakâwândy Rute.) Obede, Jessé nhunwym. Jessé, Davi nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesus idamudo ise iwerâ kâengatuly, Davidâpalâ, kypemugudo sawâtybyem Babiloniaram satyby modoram. Kydamudo iwymâry ton-honreim, tynrenseim warâ myakâwândy Davi. Davi, Salomão nhunwym. (Bate-Seba keho agâ imerymo. Urias iwydypyry myakâwândy mâkâ.) ");
INSERT INTO bkqNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomão, Roboão nhunwym. Roboão, Abias nhunwym. Abias, Asa nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, Josafá nhunwym. Josafá, Jorão nhunwym. Jorão, Uzias nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzias, Jotão nhunwym. Jotão, Acaz nhunwym. Acaz, Ezequias nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequias, Manassés nhunwym. Manassés, Amom nhunwym. Amom, Josias nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josias, Jeconias, iukonodolâ warâ nhunwym. Israeldâ Jeconias pymâem awyly ume myakâwândy kydamudo adaholy Babiloniaram. Iweâpa myakâwândy Babiloniadâ awylymo, tâtymo anaxilâ odopâdomoem en-hem kehomba tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jesus idamudo ise iwerâ kâengatuly, kydamudo Babiloniaram satoem sawâtyby modo dompyryenlâ, Jesus iazehobyryram. Jeconias, Salatiel nhunwym. Salatiel, Zorobabel nhunwym. Akaemo ume myakâwândy kydamudo Babilôniadâpa odopâdylymo tâtymo anaxilâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, Abiúde nhunwym. Abiúde, Eliaquim nhunwym. Eliaquim, Azor nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, Sadoque nhunwym. Sadoque, Aquim nhunwym. Aquim, Eliúde nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúde, Eleazar nhunwym. Eleazar, Matã nhunwym. Matã, Jacó nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacó, José nhunwym. José akâwâm Jesus nhunwyn-em ini, Maria agâ tohogüinduo. Jesus ani Maria imery. Jesus mawânkâ Cristo kelygue tâzekeim, Messias “Deus Ingonotyby” keze aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jesus idamudo merâ kâengatuly: Abraão donropyryem katorze lelâ iepadomobyry, Daviram; eagonro katorze modo lâpylâ Davi donropyryem israelita domodo Babiloniaram satyby modoram, eagonro katorze iepadobyryem lâpylâ Jesus iazeho odaxi. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus iazehobyry wâgâ ise unâ kâengatuly. Pekodo Maria keho myakâwâm ise. Uguondo José keho agâ ohogüinrim wâne myakâwâm mâkâ. Ohogüinlymo iraynâlâ olâ myakâwâm Deus Ispiritury eon-honrugue adamyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Moisés inweniby ara lelâ adâidysedo myakâwâm mâkâ José. Maria imegu tiuntuduo olâ myakâwâm imoze tâkeze, âdykâ aniempyra tawylygue. “Eagonro uguondoram adâiehoze keanra awâkâ” tâkeduo. Aituo tutuzebalâ imoze kely, Maria tâwentâzeba itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","“Âdara ise awidyly-ro?” kely ume myakâwâm, nhâenkyem Deus eanjury âepanâguely; eyam aguely myakâwâm: — José, Davi iwerypyry, tywypazeba ikâ Maria agâ ohogüinze. Tymegue lelâlâ wâne, âdaunlo uguondoram nâdynanâoba olâ. Awâkâ pekodo iodano iamudo, Deus Ispiritury awâkâ xuguni. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uguondo ise awâkâ imery. Awâkâ iamudo wâgâ ise Deus kurâdo nhemakely, inakanhe aitomobyry nhygakely warâ. Awylygue ise “Jesus” kelygue mâenzetâdyly — kely myakâwâm anju Joséram. (“Jesus”, “Kâmakerim” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Iweâpalâ myakâwândy Isaías aguely: “Pekodo âdykâ uguondo nhynanâdânry adamyze. ‘Emanuel’ kely ise imery ezedy” kewândymy Isaías tinweniby wâgâ. (“Emanuel”, “Kagâlâ Deus” keze aguely.) Jesus iazeduo, aguehobyry aralâ myakâwâm aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kopaelâgâem myakâwâm José, anju aguehobyry ara aidyly. Maria tagâ nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nynanâbyra olâ myakâwâm, imery saguho iazeho odaxi kehoem. “Jesus” kelygue myakâwâm iamudo nhezetâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus iazely myakâwâm xidadâ imeimbyry Belémdâ, Judéia eynynâ, Herodes pymâem awyly ume. Jesus iazepygueduo, xixi egaseho eynynonro modo ewy idâlymo myakâwâm xidadâ Jerusalémram. Ximukâ enuagaeni modo myakâwâm akaemo, âdy aini awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Saintybyem myakâwâm tonlo modo nhapâiguelymo: — Âdykâka iamudo judeu domodo iwymâryem iazeypy? Xixi egaseho eynynâ ani xina ximukâ nhedyly, iazehobyry xutuho. Enado âzeguhoam ise, ehogueze warâ xina âewyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Egary tindatuo, toenzepa kehoem myakâwâm pymâ Herodes âseguâdâdyly. Toenzepa lâpylâ myakâwâm mârâ xidadâ odano modo âda tâidyly nutuba idylymo, âseguâdâdylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aituo Herodes, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ indâtyguyly, tyampâiguehomoem: — Âdykâka ise Messias Deus Ingonokyly iazely? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aituo in-hogulymo: — Belémdâ ise iazely, Judéia eynynâ. Warâ myakâwâm Deus itaumbyry egatuimbyry Miquéias inwenily: ");
INSERT INTO bkqNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Kydamu Judáram xuduypy onro odaylâ myakâwâm awârâ xidadâ imeimbyry, Belém. Tâwâlâ lelâlâ wâne mârâ xidadâ imeimbyry awyly. Alâ olâ ise mârâ xidadâ egary, târâ pymâ ton-honreim iazely awylygue. Israelita domodo iwymâry ise mâkâ. Kaneru eni modo tâguy nhedyly ara ise tynynonro modo nhedyly’ nygue Deus” kewânmy Miquéias tinweniby wâgâ — kely judeu domodo iwymârydo Herodesram. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aituo myakâwâm Herodes, akaemo ximukâ enuagaeni modo ingâsenehonly, eagâmo lelâ adâkehoem. Saintuomo, adapâigueolymo: — Âdaraka ani mârâ ximukâ Messias iazely xutuho âepanâguely? — kely. Aituo tientobyry nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aguepygueduomo, eyanmo aguely: — Inepa Belémram idâwâtaungâ. Koendâ iamudo âdykâ awyly xutuwâdaungâ. Mâentuomo, yam egatuwâdaungârâ. Udâdyse lâpylâ urâ myarâ, enadoram âzeguhoam ise, koendonroem awyly wâgâ auguehoem — kely Herodes; kewâdyly kulâ olâ myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ilâpygueduo, ximukâ enuagaeni modo âxiguelymo. Belémram idâlymo myakâwâm. Tâtâdaymolâ, ximukâ xixi egaseho eynynâ saguhoem tientybymolâ nhetonguylymo kau wâgâ. Toenzepa kehoem myakâwâm iomazelymo mârâ ximukâ tientonduomo. Iwaunrorumoenlâ mârâ ximukâ idâly, idâhomo tânehonze. Iamudo eydâ ato nhangawaym myakâwâm ximukâ epagudyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Âtâ odaji egawântybyem myakâwâm iamudo nhedylymo Maria ihuay. Iamudo enado âzeguhoam idylymo, tynrense tawyly tienehon-homoem. Ilâpyryem tysejiguy etary nhenahunguelymo. Iamudo xurâem tiantyby nhudulymo: ouru, incensu tyânrânguneim, mirra warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ilâpygueduo myakâwâm kopae nhâenkymoenlâ Deus eyanmo aguely: — Herodesram egatuze todopâzebane itaungâ — kely. Aituo tâty anaxilâ odopâdylymo eagonro ânwa oze, Jerusalém einkâ sakadânry oze. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ximukâ enuagaeni modo idâpygueduo myakâwâm anju âepanâguely Joséram, nhâenkyem. Eyam aguely: — Autaungâ. Inepa tarâpa itaungâ. Merâ iamudo xuien-honze enra Herodes, tyâen-hon-hoem. Egitoram âwientaungâ iamudo agâ. Târâlâ wao itaungâ. Âgâsezemo urâ, modopâdomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anju agueduo myakâwâm inepa kehoem José saudyly. Kopaelâ kehoem âwiendylymo iamudo agâ Egitoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodes iguely ara myakâwâm târâ awylymo. “Egitodâba ymery xigâsedâ” kewândymy Deus, Oséias inweniby wâgâ. Jesus iamugâry Egitodâba odopâduo, Deus aguehobyry ara kehoem myakâwâm aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ximukâ enuagaeni modo tonokudobyry tiuntuduo myakâwâm Herodes iewiâpadyly. Aituo tyzodadury modoram aguely: — Belémram idâwâtaungâ. Iamudo uguondo imeombyry xyâwâtaunda tâjihuano modo dompyryem, azagâ anupeom modoram xyâwâtaunda. Idânârâ xyâwâtaungâ, xidadâ odano modo, poji anano modo, xidadâ iwaguepaom modo alelâ — kely. Jerusalémdâ tatay, ximukâ enuagaeni modo aguewânmomy: “Azagâ anu sakadyby wâgâ akâwâm mârâ ximukâ pymâ iazely xutuho xina nhedyly” kewânmomy. Aguehomobyry wâgâ myakâwâm Herodes, idânârâ iamudo uguondo imeombyry tâjihuano modo dompyryem, azagâ anupeom modoram nhâen-honwâdyly, âdykonlo pymâem ini awyly nutuba tawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Arâ myakâwândy Deus itaumbyry egatuimbyry Jeremias aguehobyry ara aidyly: ");
INSERT INTO bkqNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Xidadâ Ramádâ kurâ domodo tytyrungue toenzepa eogunrumo xina nidadâ. Tymeombyry xyâhobyry wâgâ Raquel eogunru xina nidadâ. Ânguy nhetubanâguylyemba itynrumo idânârâ tymeombyry xyâhobyry wâgâ” kewândymy tinweniby wâgâ. Jeremias inwenihobyry ara kehoem myakâwâm Herodes uguondo modo imeombyry nhâen-honwâdyly. (Israel iwydy Raquel iweompyrylâ mawânkâ israelita domodo.) ");
INSERT INTO bkqNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes igueduo myakâwâm Deus, tyanjury Egitoram ingonodyly, José xuruse. José xykyly ume myakâwâm anju âepanâguely nhâenkyem. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Eyam aguely: — Aukâ. Israelram odopâgâ, iamudo, ise warâ agâ. Mâkâ iamudo tyândysedonro modo ipa, niguemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aituo myakâwâm José, Maria, Jesus warâ saudylymo. Israelram odopâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Saintybyem myakâwâm “Arquelau pymâ, Herodes imerybyry, tunwym ejipyano” kely indadyly. Awylygue myakâwâm José eanu myarâ Judéia yan-yam idâze, “Pymâ iwelo iamudo xyâen-honze enra” tâkeduo. Nhâenkyenlâ olâ myakâwâm Deus aguely: — Galiléia yan-yam âxidâdaunda — kely. Aituo Galiléia yan-yam âxidâze idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Xidadâ Nazarédâ myakâwâm âxidâdylymo. Iweâpa Deus itaumbyry egatuwânibyry modo, “nazareno” kelygue âzezekeoze kehomobyrylâ. Nazaréram iamudo Jesus agâ âxidâze idâduomo, Deus aguehobyry ara aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tâlâ myani uguondo João Batista keho Judéia eynynâ. Âji âdy peba atodâ myani mâkâ âxidâdybyem awyly. Deus itaumbyry mykâinane nhegatuly kurâ domodo myarâ idânri modoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Alâ mykâinane aguely: — Âjityendaungâ, inakanhe kulâ amitomobyry wâgâ. Deus izepa ato aiedyly imowâdaungâ warâ. Iweâpa nitaymba ise Deus Ingonotyby âewyly. Kywymâryem ise — tâkeze mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Warâ myakâwândy Deus itaumbyry egatuimbyry Isaías inwenily João Batista wâgâ: “Messias wâgâ agueim târâ âji âdy peba atodâ ise aguely. Adâkely idase idâwâtyby modoram: ‘Inepa ise Deus Ingonotyby saindyly. Izepa ato aiedyly imowâdaungâ. On-hondybyem lelâ itaungâ, aguely mâindatomoem. Pymâ ton-honreim kâty anaxi âewyly kiuntuduo wâne, kâty inatary tuonse, tuonkeze warâ kurâ, myara on-hondybyem lelâ kydawyly aguely idase’ ” kely ise mâkâ unâ egatuim, warâ myakâwândy Deus itaumbyry Isaías inwenily. João Batista myani Kywymâry saindyly egatuim. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Camelu xuhudugue xygatyby mykâinane João ety iwogonro, âdy pebaom ety iwogonro emyenro kulâ. Tâjitubygue kulâ mykâinane iwanxiegu. Kahuli, penrâ warâ mykâinane ipyniry. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalémdâ tâtyuneim modo, Judéia eynynonro modo, paru Jordão emelano modo warâ tâtâzemo mykâinane João aguely idase. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","João aguely tindatuomo myani toenzepa kurâ domodo aguely eyam: — Deus izepa ato aieni xina. Adâidyly tumoze olâ xina-ro warâ — kelymo. Arâ agueduomo myani paru Jordão ikay Joãoram batiza âieholymo, Deus izepa ato adientomobyry wâgâ tâjityenze tawylymo tienehon-homoem, inakai modo adiendyly imoimbyryem tawylymo tienehon-homoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Agui kehoem myani fariseu domodo, saduceu domodo warâ Joãoram batiza âiehoze idâlymo. Tutuze olâ myani João, akaemo nâjityembyra awyly Deus izepa ato adientomobyry wâgâ. Awylygue aguely eyanmo: — Âgâu poji âduguely ume âsemagueze kewâni ara kulâ âmaemo! Warâ wâne amyguelymo: “João batiza kyetuo ise kydâsemaguely. Deus kânagazedaymba ise” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","“Deus eynynonro urâ” myguelymo wâne, Deus eynynonro keba olâ âmaemo. Deus izepa ato amânhetomobyry wâgâ tâjityenze mawylymo enehorim aietaungâ, inakanhe amidylymo imoimbyryem mawylymo mâenehon-homoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Deus kânagazenehonwâbyra ise, Abraão iweonma kurâ” tâkezeba itaungâ. Abraão iweryem tadawyly mâkeba mârâ kuru. Âdy mâkeba awârâ! Auguely xirâ âyanmo. Ton-honre Deus, xirâ tuhu modo Abraão iweryem ienehonze. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nady koendâ ewisedânry pygue satâly. Iwindy âzesagueoly. Peto onwanji adameoly alelâ aieholy. Nady koendâ ewisedânry ara kulâ âmaemo. Deus izepa ato mâinmopa âmaemo-ro watay, inepa ise Deus inagazenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","— Urâ pygueduo eagonro âese lâpylâ Deus wâgâ aguenri. Ton-honreim ise mâkâ, iemyenro keba. Mâkâ ise yakadâ kuru ton-honreim. Ihuru etary sanienlâ witoem nudupa lâgâlâ. Urâ parugue batiza âenimo, Deus izepa ato amânhekylymo wâgâ tâjityenze mawylymo mâenehon-homoem, inakanhe amidylymo imoimbyryem mawylymo mâenehon-homoem warâ. Mâkâ âeni olâ ise Deus Ispiritury xudunri, eynynâ mawylymo xutuhoem. Inakanhe amitomobyry xygakeze, peto wâne saxium nhaduândyly âpa ezay myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigu ekaunâni wâneam tuduakeze ewy nhekaunâdyly myara mâkâ. Tynynonro modo iduakewâze ejidy tâkehobyryanlâ ise nhekanâdyly, trigu etary kehobyry odaxilâ ekanâdyly myara. Tynynâbaom modo olâ typygueba kehoem enagazeze peto âdaunloenlâ nhântânry onwanxi ise nhamely — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Alâ myani Jesus Galiléia eynynâba idyly, paru Jordãoram idâly, João batiza tyetoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","João myani batiza tiendyseba, Jesus tynrenseim kuru awyly tutuze tawylygue. Aituo aguely: — Batiza âetoem yam mâewyly. Âmâlâ yakadâ kuru tynrenseim. Âmâ batiza yekâ — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Warâ olâ Jesus aguely: — Ize wato aralâ nidâ. Batiza yekâ. Ara ise Deus ize ato aguiendyly — kely. Aituo João âkeá kely. Jesus batiza âieholy myani, Deus eynynonroem tawyly tienehon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus âjikaguely paikayba. Âjikaguebygueduo myani kau âzenahunguely nhedyly. Papaem myani Deus Ispiritury xytâguyly, ekadyly nhonwa. ");
INSERT INTO bkqNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aituo kau oday Deus itanru indadyly lâpylâ: — Ymery toenzepa kâinwyneguyly merâ, toenzepa womazeâni — kely myani Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ilâpyryem myani Jesus adaholy Deus Ispirituryam âji âdy peba atoram. Tarâ myani Deus izepa ato anhetoem Satanás aiese kely wâne. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Quarenta iguandyly, quarenta emedyly warâ myani Jesus nâwinduapyra awyly. Alâ myani toenzepa kehoem ewindupadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aituo Satanás eyam saindyly, aguely: — “Deus imery urâ” mygueansema. Âkealâ kuru amyguely-ro watay, awârâ tuhu pãoem iekâ pylâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aituo myani Jesus aguely: — Amyguehobyry agânhetaymba ise urâ. “Pão kiendawynlygue lelâ inkâba kyiguepa kydawyly. Idânârâ Deus agueho kieinwândyly, aguiendyly warâ watay, kyiguewâpyra kurâ” kely mawânrâ Deus itaumbyry awo wâgâ iweniby — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ilâpygueduo myani Satanás, Jesus nhadyly Jerusalémram. Deus ijidadâry kelygue tâzekeim myani mârâ xidadâ. Deus ety nhangakuedaji myani nhadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aituo aguely: — “Deus imery urâ” mygueansema. Âkealâ kuru amyguely-ro watay, tarâpa onro onwa adamegâ. Mâdyâwâpyra ise âmâ. Warâ mawânrâ iwenibyem Deus itaumbyry awo wâgâ: “Deus nhese lelâ. Anju domodo igonose awâniem. Âihugueduo, awâse lelâ tâmarygue, âda mipyra mitoem, âhuru tuhu onwa nâdyâpa itoem warâ” kely iwenibybe mawânrâ — kely Satanás. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aituo myani Jesus eyam aguely: — Onro onwa kadamewâbyra ise urâ. Warâ lâpylâ iwenibyem awyly Deus itaumbyry awo wâgâ: “Deus imakelymo mâentomoem kulâ, kâmayno akâiedaundâ. Amidylymo-ro watay, mâinwâmpyra mawylymo kulâ ise mâenehonlymo” warâ lâpylâ iwenibyem awyly — kely Jesus Satanásram. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ilâpyryem myani iwy kaynonro onwa adaholy Satanásram. Idânârâ onro anano modo nhenehonly; idânârâ âdydo imeom iwâkuru modo, tâwâenseim modo warâ nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Aituo myani aguely Jesusram: — Idânârâ awârâ mâentaynly modo âyam xuduze urâ, ienado âzeguhoam midyly yrentoen-ro watay — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus aguely: — Âyrentoem inado âzeguhoam witaymba ise urâ! Deus itaumbyry awo wâgâ iwenibyem: “Kywymâry Deus enado lelâ âzeguhoam itaungâ. Aguehobyry ara lelâ aitaungâ” kely iwenibyem. Idâ, Satanás. Tarâpa ikâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aituo Satanásram âjionly. Satanásram âjiompygueduo myani anju domodo saindyly, Jesus eydâ atoram xuahuze, idânârâ ize ato modo xuduze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","João Batista kadeia oday kely tindatuo myani Jesus Galiléia yan-yam idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xidadâ Nazaréamba olâ myani odopâdondyly-ro warâ. Xidadâ Cafarnaumdâ myani âxidâdyly, Galiléia iwalu iwaguepa, saguhoem kydamudo Zebulom, Naftali warâ eonronruem xuduypy eynynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","16","Enanâguewâdaungâ saguhoem Deus itaumbyry egatuimbyry Isaías inweniby: “Kydamudo Zebulom, Naftali warâ eonronru Galiléia eynynâ ejiku, paru Jordão kuynâ, tuomareim kuru ise âmaemo judeu, judeu keba alelâ, mârâ anaym tâjikuneim modo, âdaralâ Deus itaumbyry mâuntuba olâ âmaemo. Awylygue toenzepa âiguelymo mâyntadylymo, mâseguâdâdylymo warâ. Deus wâgâ âzenomedâoze olâ âmaemo, iajinu odano aramo lelâ ise, iamu odanopyryem” kewândymy. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Deus xunâry egatuze myan-yam Jesus idâduo, Isaías inweniby ara kehoem myani aidyly. Târâlâ myani Jesus unâ nhegatuly adaguly. Alâ myani aguezesedyly: — Âjityendaungâ inakanhe amitomobyry wâgâ. Inakanhe adâjidyly imowâdaungâ warâ. Arâ lelâ ise Deus âwymârymoem awyly — kezesedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Paru Galiléia emelay tadakobâday myani Jesus azagâ uguondo nhedyly, iwaigoru, iukono warâ; Simão Pedro, André warâ. Âedâgue kanra sawâni myani akaemo, vende tientoem. Âedâ paikaji nhamedaymo myani Jesusram âzeholymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Azakâlâram myani Jesus aguely: — Âetaungâ. Saguhoem kanra keankâ mawelymo; iwerâ kurâ domodo ynynonroem itoem unâry egaturin-em ise âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Inepa kehoem myani âedâ kanra sawâto inmolymo, Jesus eynynonroem tâitomoem, Deus wâgâ tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tâtâday myani Jesus azagâ uguondo modo nhetondyly, Tiago, iukonolâ João warâ. Zebedeu imeombyry myani akaemo. Ekadybymoem myani tywepirymo oday tunwym agâ. Âedâ kanra sawâto myani kua nhekylymo, kopaelâgâroem. Aituo myani Jesus akaemo ingâsedyly tynynonroem itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Inepa kehoem tywepiry odayba idylymo. Tunwym tyânzemo myani, Jesus agâ tâtâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Idânârâ Galiléia eynynonro âtâ anakâ myani Jesus sakadyly. Âtâdyguyhomodâ mykâinane Deus wâgâ nhenomedâdylymo. Deus iwymârymoem idyly wâgâ mykâinane unâ iwâkuru nhegatuly. Tâwânuneim modo, âsenagazeni modo warâ kua tyese mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tâinkâ lelâba myani anhekyly egary idâly Síria eynynâ. Aituo pylâ myani tâwâneim modo Jesusram nhadylymo-ro warâ. Âdaunlo tâzewânulâ kua nhekyly. Kadopâgue taseim modo kua nhetaynly. Ekomani modo kua nhetaynly. Adakobâdânry modo kua nhetaynly lâpylâ warâ myani. Idânârâ tâwâneim modo tyam idâypy kua tyese lelâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Toenzepa myani kurâ domodo nhapygue awyly, Galiléia eynynâba âetaymby modo, Dez Xidadâ anano modo, Jerusalém donro modo, Judéia eynynonro modo warâ, paru Jordão kuynonro modo lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Toenzepa kehoem myani kurâ domodo Jesus eydâ atoram idâly. Arâ kurâdo tientuo myani iwy onwa âkuly, ekadyly warâ. Eynynonro modo iopaji idylymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aituo myani kurâ domodo enomedâdyly Jesus nhaguly. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Aituo Jesus aguely kurâ domodoram: — Tuomareim kuru mâkâ, Deuslâ idânârâ tâlâ tato xuduim awyly xuturim. Imâemba lelâlâ wâne, Deus kaynonro olâ iwymâry, eni warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","— Tuomareim kuru mâkâ iwerâ âjityeni. Itynru ume, Deuslâ mawânkâ ise iomazeâni. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","— Tuomareim kuru mâkâ tâlâ tato modo wâgâ kulâ sawoem itânry. Deus tynynonro modoram, “Xuduze urâ” kehobyry emakeze mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","— Tuomareim kuru mâkâ Deus ize ato modo lelâ adiendyse donro. Kurâ tâwinzeim, tatuanzeim warâ wâne pyni, paru warâ lelâ ize ato, myara lâpylâ Deus ize ato lelâ adiendyse awyly. Idânârâ ize ato xuduze Deus, ton-honre lelâ tâinwântoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","— Tuomareim kuru mâkâ âkelo modo ityeni. Deus mawânkâ ityenze lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","— Tuomareim kuru mâkâ Deus izepa ato aniempyra tâitoem Deus xurâ modo wâgâ lelâ âtynanâni, Deus eydâ atoram idâze mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","— Tuomareim kuru mâkâ, tâdâtuebadyly, tâdâseguebyly warâ adain-hoem aini. Tymery ara lelâ mawânkâ ise Deus nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","— Tuomareim kuru mâkâ Deus ize ato ara aidylygue tânagazezeim. Deus kaynonro mawânkâ ise iwymâry, eni warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","— Ynynonro mawylymogue, ynynâbaom modoram âjiewiâseoze âmaemo. Âunâguezemo. Inagazenehonzemo. Âwâgâmo kewâdylymo kulâ ise warâ. Arâ wâne ise amyguehonlymo, tuomare lelâ olâ ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tytywanzeba itaungâ, tuomare lelâ. Deus olâ eydâ tatodâ imâem âyanmo nhudulype, omazeânimo nhekanâdybybe. Deus izepaom modoram mâzenagazeolymo. Alâ mykâinane Deus xunâry egatuim modo nhenagazedylymo lâpylâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Aituo Jesus aguely: — Peku pyni tâkubâzeânze, podo niwânzeânehomba warâ, myara âmaemo taunlo modo ywâgâ amyguelymo, kurâ domodo yeinwântomoem, inakanhe nâiehoba itomoem warâ. Peku onro agâ on-hoam ityby olâ pyni ikaji ietoem nudupa. Âdaitoem ânguy ize inkâba. Awylygue adameoly lelâ, adakabeoly warâ sakani modoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","— Iajinu, iamu oday kydadakobâdo kiento nhesagonly myara ywâgâ mâuntuen-honlymo. Koendâ kehoem wâne xidadâ iwy angatay saunâtyby edyly myara ywâgâ totoenzeba aguewâtaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lamparina kienmanâdyly watay, âdylâ iaxi kioentaymba kurâ. Kayanlâ kianlokuândyly, idânârâ âtâ odano modo nhesagon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Lamparina kaynâ ekanâdyby ara ise koendâ amidylymo âzeholy idânârâam, Deus mâinwândylymo warâ. Koendâ amidylymo tientuo: “Koendonroem unwânmo Deus kaynonro awyly” aguehonze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesus aguely: — “Jesus aguehobyry lelâ iwerâ kyzeinwâne, âdaitoem saguhoem Moisés agâ, tunâry egatuwâni modo agâ warâ, Deus aguehobyry kieinwântaymba kurâ” tâkezeba itaungâ. Deus Moisésram kâzewenry inwenien-hoymby koendâ kuru mâuntuhomoem xirâ kâewyly, mâinmohomoem inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kau, onro warâ tâlâ awyly ara, Moisés inweniby tâlâ lelâ lâpylâ ise; tugukewâduneba ise xypyry etaji kehoem. Iwenihobyry tokalâ letralâ tygakeduneba ise. Xirâ mawânrâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Moisés inweniby modo ewy einwântânry, kurâ domodo mârâ neinwâmpyra itoem aguenri watay âdy mâkeba ise mâkâ, Pymâ Deus nhekyly modo duay. Deus Moisésram kâzewenry inwenien-hoymby ara aini, kurâ domodo enomedâni waunlo watay, tywyneim ise mâkâ Pymâ Deus eydâ atodâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Warâ âyanmo auguely. Fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâma koendâ aini, tâkewâze kurâ. Kurâ domodo tynrentomoem kulâ olâ akaemo aidyly-ro warâ. Deusgue âwymâgumo ize mataymo, kurâ domodo ize ato ara kulâ aini modo takaze Deus ize ato aietaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesus aguely: — Tydaselâ âmaemo, Moisés kydamudoram aguehobyry: “Ânguy kâdyâwâtaundâ. Kyâimpyry pymâ domodo xyâen-honze lâpylâ” kewândymy Moisés. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Urâ olâ warâ âyanmo auguely. Deus enanaji, kagonro kienwiâsedyly, inakai kuru, ânguylâ kyânly aralâ lâpylâ. Awylygue kyewiâsenibe-ro watay, adaholy pymâdoram âzenagazeohoem. Âkelo xunâguenibyry tribunalram sadyly lelâ, setenta pymâ tynreim modoram âzenagazeohoem. “Tuândy kulâ âmâ” keypy watay, samely lelâ peto nhântânry onwanji. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Tâwâlâ lelâlâ wâne Deus etydâ mawylymo, âdylâ Deusram egameze, târâ mawylymo ume, mâdunâgueohomobyry mâenanâguelymo-ro watay, Deus xurâem mantybymo târâlâ wao nhânwâtaungâ, mâengamebamolâ. Waunroem mâkâ âewiâsenimobyry agâ âtunâguedaunda wao. Koendâ lelâ agâmo-ro watayma tâwâlâ Deus etyram modopâdylymo, Deus xurâem mantybymo egameze. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","— Ânguylâ tribunalram adysemo watay, waunroem wao eagâ koendâ âtunâguedaungâ, agâmo tyewiâseba itoem. Arâ amipyra âmaemo-ro watay, tribunalram asemo. Târâ ise; pymâ domodo polícia domodoram igameinmo-ro warâ mâzetadâohomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dinheru mâempywadomoem juiz aguehobyry idânârâ mâempywabyra âmaemo-ro watay, igasewâbyra ise âmaemo târâpa. Arâ lâpylâ Deus agâ koendâ itaungâ koendâ mitomobe awyly umelâ. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesus aguely: — Tutuzelâ âmaemo Moisés inweniby: “Âwydymo keba kulâ kâdynanâdaundâ” kely myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Urâ olâ warâ âyanmo auguely: Uguondo pekodo enupeguygueni, tynanâdyze, iwydy keba olâ waunlo, inakanhe mâkâ xunâgu tyangahu oday. Nynanâbyra wâne, arâlâ olâ âzewentâoly Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Inwentânehoinmo Deus mâendysebamo ato kâzetaundâ. Koendâ tâise azakâlâ inumo etyly, Deus mâendysebamo ato mâempyra mitomoem. Koendonro kuru tânuembalâ Deus agâ tadawyly; idânârâ kodo peto nhântânry onwanxi adameoly mawânrâ koendâpaom kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Deus xurâem inwentânehoinmo akâiedaundâ imarymogue. Koendâ tâise imarymo satâly, samely warâ, Deus izepa ato amânhepyra mitomoem. Koendonro kuru tâmaguebalâ Deus agâ tadawyly; idânârâ kodo peto nhântânry onwanxi adameoly mawânrâ koendâpaom kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesus aguely: — Tutuzelâ âmaemo Moisés inweniby: “Pekodo eagâ mohogüin-homobyry mâinmodyze âmaemo watay, tâwâlâ imowâdaungâ. Âdaituo mâinmolymo awyly xutuhoem pape mâinwenibymo olâ eyam xuduwâtaungâ” kely myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Urâ olâ warâ âyanmo auguely. Âdaituoba kulâ âwydymo kâjimowâdaundâ. Eagonro uguondo agâ ituo lelâma pekodo imoly. Pekodo imoyby agâ ohogüimby watay Deus izepa ato ara kulâ lâpylâ aidyly. Deus xurâem, waunroem eagâ ohogüimbylâ mawânkâ iso kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesus aguely: — Tutuzelâ âmaemo Moisés inweniby: “Deusram amyguehomobyry watay, aietaungâ lelâlâ; amyguehomobyry amânhepyra tâiseba itaungâ” kely myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Urâ olâ warâ âyanmo auguely. Âdaunloenlâ Deus ezedy âwankuem kâietaundâ. “Mâkâ kaynonro tutuze âkealâ auguely awyly” tâkezeba itaungâ. “Mâkâ kaynonro” myguelymo-ro watay, Deusranlâ amyguelymo lâpylâ, kaynâ ejidy awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Mâkâ onro xyganipyry âkealâ auguely awyly tutuze” tâkezeba itaungâ. Deusranlâ arâ amyguelymo. Deus mawânkâ onro anaynlâ lâpylâ. “Mâkâ Jerusalém donro âkealâ auguely awyly tutuze” tâkezeba itaungâ, Deusranlâ arâ amyguelymo, Deus Ijidadâry kelygue tâzekeim awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Iangatolezeze urâ, uguewâdyly kulâ-ro watay” tâkezeba itaungâ. Tokalâ kyangahudu kiampekanânehonwâbyra kurâ, kienmyguymanânehomba warâ, Deus nhygatyby awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Aiese urâ” myguelymo watay, aietaungâ. “Agânhepyra ise urâ” myguelymo watay, akâiedaundâ. Amyguehomobyry aralâ aitaungâ, Deus ezedy mâempâguebamolâ. Deus ezedy mâempâguelymo-ro watay, Diabulâ aienehonrim — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesus aguely: — Tutuzelâ âmaemo Moisés inweniby: “Ânguylâ otoguylymo, inuxiguylymo warâ watay, enuxiguywâdaungâ lâpylâ. Âerymo nhukagâdyly watay, iery xukagâdaungâ lâpylâ” kely myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Urâ olâ warâ âyanmo auguely: “Ânguylâ âdalâ âetuomo, âpeânze tâkezeba itaungâ” uguely. Mâjiwapagainhoduomo, tâpeânzeba itaungâ. MYRYK itaungâ, iladune âwapagain-homoem lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Âdylâ amânhetomobyry wâgâ mâzewentâolymo watay, policiaram adahoze âmaemo. Târâ “Âgamizary merâ uguondoram xudugâ” myguehonduomo, tâwâlâ âwalitoru nadâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Sodadu Roma donro âyanmo “Ysejiguy sakâ tokalâ kilômetro” keduo, azagâ kilômetro lelâ sataungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Âyanmo âdylâ ekanibyryram âunduwâtaungâ. Âdylâ tiempywaguylyem ekanibyryam âunduwâtaungâ lâpylâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesus aguely: — Tutuzelâ âmaemo Moisés inweniby: “Âwynenimo lelâ iwynedaungâ. Âwynedânrymo kâjiwynedaundâ” kely myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Urâ olâ warâ âyanmo auguely. Âwynedânrymo agâ koendâ lelâ itaungâ, ataen-homo mâinwyneguylymo agâ matomo ara. Ânguylâ inakanhe âedylymo watay, inakanhe aitobyry wâgâ Deusram ekadaungâ, eagâ koendâ lelâ itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Koendonro mawânkâ Deus, tynynonro modo agâ, tynynâbanro modo agâ alelâ. Xixi tohobanâze mawânkâ koendonro modoem, inakai modoem alelâ. Kopâ tyihugueânze lâpylâ tâinwânni modoem, tâinwântânry modoem alelâ. Awylygue koendâ lelâ âmaemo ataen-homo, âduerymo alelâ agâ-ro watay, Deus kaynonro xurâem kuru mawylymolâ mâenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Agâmo koendonro agâ kulelâ koendâ mawylymogue, “Deus koendonro kurâem xuduze, koendonro kydawylygue” tâkewâzeba itaungâ. Âdyem itaymba awârâ. Asaemo dinheru impostu epywadobyry emakewâni modo tataen-ho modo agâ koendâ lelâmo lâpylâ. Awylygue arâ amidylymo watay, âkelo modo takaze amidylymo mâkeba. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Âpemugudomo agâ lelâ, ataen-homo agâ lelâ warâ mâsedaengulymo, âunâgumo warâ lâpylâ watay, âkelo modo takaze amidylymo mâkeba. Deus eynynâbaom modo mawânkâ tataen-ho modo agâ koendâ lelâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Koendâ lelâ idânârâ kurâ domodo agâ itaungâ, Kunwym kaynonro ara, mâkâ idânârâ koendâ eni ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus aguely. — Xirâ âyanmo augueho. Tâmaynelâ itaungâ, tâzenanaym kehoem âdylâ amânhepyra mitomoem, amyguepa mitomoem warâ. Igaromoem kulâ âdylâ koendonro amânhedylymo-ro watay, Deus ipywadaymbamo ise amânhetybymo wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","— Awylygue kaikâ modo mâenmawyadâdylymo watay, amânhetybymo ânguyam kâzegaetaundâ. Koendonroem âdutuim modo aito araba aitaungâ. Kaikâ modo nhemawyadâdylymo watay, tâinkâ lelâba adientyby nhegatulymo, kurâ domodo âtâdyguyho odakâ, xidadâ earuary oze warâ. Kurâ domodo tywâgâ koendâ aguehoem kulâ kaikâ modo nhemawyadâdylymo. Deus koendonro nuduwâpyra ise eyanmo. Aitomobyry ebyrylâ ise awârâ kurâdoram âzehogueolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Awylygue âdy pebaom modo mâenmawyadâdylymo watay, ânguyam kâzegaetaundâ. Koendâ kehoem aietaungâ, ataen-homo kuru nhutulyemba kehoem, imarymo pâem eynynonro wâne, imarymo aho eynynonro anhekyly nutuba myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Awylygue kaikâ modo emawyadâdaungâ, ânguy nutubalâ. Kunwym Deus olâ idânârâ aguienkyly tâense. Koendonro amânhekylymo tâense, ipywazemo-ro warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesus aguely: — Deus agâ amyguedaymo, koendonroem âdutuim modo ara inkâba itaungâ. Deus agâ adâkehomoem XYDYK idylymo, âtâ tâdâtâdyguyho oday, arua iskinarydâ warâ, kurâ domodo tâentoem kulâ. Deus koendonro nuduwâpyra ise eyanmo. Aitomobyry ebyrylâ awârâ kurâdoram âzehogueohomo. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Koendonro lelâlâ Deus agâ agueze kydâtâdyguyly. Koendonro lâpylâ olâ kurâ kulelâ eagâ aguykely. Awylygue âji ânguy âynanâbyramo atodâ eagâ aguewâtaungâ. Kunwym Deus awâtârâlâ ise agâmolâ. Mâempyra lelâlâ wâne âmaemo, alâ olâ eagâ aguewâtaungâ. Âmaemo kulelâ eagâ amyguelymo tydase mâkâ. Arâ amituomo koendonro âyanmo xuduze. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","— Deus agâ amyguedaymo, amyguehomobyrylâ adâkezezeba itaungâ. Deus einwântânry modo ara inkâba aitaungâ. Deus tydadyly waunlo ara, enanajimo, imeâgâemba kehoem adâkelymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aguehomo ara inkâba aguewâtaungâ. Tutuze mawânkâ Kunwym Deus âdy ize matomo, mâenkadylymo iraynâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Deus agâ amyguedaymo, warâ aguewâtaungâ: “Pabai kaynonro, tynrenseim lelâlâ mawyly, izedy awyly warâ idânârâ nhutudyzemo xina. Ânguy âwankuem âepyra nidâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tarâ xina iwymâryem ikâ. Xina xirâ onro anano modo ize mato ara lelâ xina aiedyse awyly, târâ kaynâ agonro modo ize mato ara aito ara lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Âmâlâ kopaelâgâembaba xina ipyniry âundugâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inakanhe xina aitobyry xygakegâ, âkelomo inakanhe tynynâ aitobyry xina nhenanânehon-ho ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanás izepa mato aienehonze keduo, xina agâlâ ikâ, izepa mato xina aniempyra itoem. Xina iwymâry âmâ. Ton-honre kehoem âmâ, amânhedyse mato aiese. Tynrenseim âmâ. Aunlolâ ise âmâ, typygueim keba. Arâlâ ise” — warâ aguewâtaungâ Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","— Inakanhe âetomobyry mâenanânehonlymo-ro watay, Kunwym kaynonro xygakeze lâpylâ inakanhe amitomobyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Inakanhe âetomobyry mâenanânehomba âmaemo-ro watay, Kunwym kaynonro nygakeba lâpylâ ise inakanhe amitomobyry — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesus aguely: Tâjityenzeba itaungâ, Deus agâ amyguehomoem mâwinduapyra midylymo watay. Koendonro emyenro modo ara inkâba itaungâ. Deus agâ adâkehomoem nâwinduapyra tâise tawyly xutudyzemo. Awylygue tytyreim ara idylymo. Nâzemelagogueba, nâzekagâimba warâ awylymo. Kurâ domodo tywâgâ koendâ aguehoem kulâ arâ aidylymo. Âdy koendonro nuduwâpyra ise Deus eyanmo. Aitomobyry ebyrylâ awârâ kurâdoram âzehogueolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Âmaemo olâ, Deus agâ amyguehomoem mâwinduapyramo mituomo, tuomare lelâ itaungâ. Âzemelagoguewâdaungâ lelâ, âzekagâinwâdaungâ lelâ warâ, ânguy mâwinduapyra mawylymo nutuba itoem. Kunwym kaynonro agâmolâ. Amidylymo tutuze mâkâ. Mâkâlâ ise âyanmo koendonro xudunri — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesus aguely: — Tarâ onro anaym âdydo imeom tâwâentuneim modo kâzekanâdaundâ, potogo, tuonro warâ inakanhe nhetodâ, âzemagazeohodâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Awylygue âzeon-hondâdaungâ, Deus ize ato amânhetomoem. Arâ ise koendonro ekanâdybybe mawylymo târâ kaynâ. Âdaunloenlâ tuonro, potogo warâ inakanhe nhetânry. Tâmagazeim modo nemagazebyra ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Xirâ anano tâenseim wâgâ kulâ mâpaunzedylymo watay, mârâ wâgâ kulâma âwaunkymo. Deus xurâ toenzepa ize matomo-ro watay olâ ise, ize ato ara lelâ ise amidylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesus aguely: — Kânugue mawânrâ kytâho kiendyly, iajino oze kytâly. Koendâ kiendyly-ro watay, ânwa iozeno oze lelâ kytâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Koendâ kiempyra kurâ-ro watay, tuzase kurâ, iamu duay tâduzato ara. Epy xurâem toenzepa lelâlâ iamu — kely Jesus. {“Kânu agâlâ mawânrâ kyangahu âsewanily” keze Jesus aguely. Deus ize ato aguiendyse kurâ-ro watay, iozeno lelâ aguienkyly. Arâ aguiendyseba kurâ-ro watay, iozeno keba kulâ aguienkyly. Toenzepa ise kydâsenagazedyly, aguehobyry kieinwâmpyra kurâ-ro watay.} ");
INSERT INTO bkqNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesus aguely: — Azagâ tywymâgueim kurâ watay, nuduwâpyra azakâlâ agueho aguientoem; tokalâ âdylâ aguiendyse, eagonro âdylâ aguiendyse lâpylâ. Aituo tokalâ aguehobyry lelâ aguienkyly. Arâ lâpylâ Deus ize, toenzepa tydinherugu ize waunlo modo Deusgue lelâ iwymâgoem nudupa awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","— Warâ âyanmo auguely. Tâseguâdâzeba itaungâ pyni wâgâ, okumo wâgâ warâ, âiguepa mitomoem. Itymo owogonromo wâgâ tâseguâdâzeba itaungâ. Pyni keba, okumo keba, âtâ tâjiwogonro keba warâ tywyneim kuru. Deus ize matomo xuduze lelâ âpynirymo, itymo owogonromo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Etaungâ atâingâ konopio modo. Typiembamo. Typyniry netâbyramo, nekaunâbyramo, netadâbyramo etary odaji warâ wâne. Deus olâ ipynirymo tuduze. Deus xurâ âmaemo. Tawâguneim modo ipyniry tiunduho ara, âyanmo xuduze lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mâungukedânrymo wâgâ tâseguâdâzeba itaungâ. Âdara âiguelymo wâgâ tâseguâdâzeba itaungâ. Kyigueho odaji ituo, kyiguepa kitoem aguientaymba kurâ. Deuslâ kyigueho xutuim. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","— Mâzetydâdomogue, mâpâgudâdomogue warâ tâseguâdâzeba itaungâ. Etaungâ poji anano tadawanku. Nâsewanibamo, tâty tywogonro tianâtomoem. Kâdâkerâ nawâpyramo tâty tywogonro adientomoem warâ wâne. Deuslâ olâ iwâkudâni. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kydamu Salomão toenzepa âdypeom myakâwândy, toenzepa lelâlâ. Iwâkuru modo myakâwândy ety iwogonro. Poji anano sawanku olâ Salomão ety iwogonro takaze kuru tywâkurein-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iweâpa nipyra olâ awârâ poji anano sawanku. Iwerâ koendâ, tywâkure warâ, kopaelâgâem ipa, iladybyem lelâ, peto emanâdoem âieholy lelâ warâ. Awârâ sawanku tâense Deus; nhesemo lâpylâ. Itymo owogonromo xuduze. Mâinwâmpyra olâ âmaemo! ");
INSERT INTO bkqNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","— Tâseguâdâzeba itaungâ. “Âdykâ kaise xina typyniry, toku, tâty tywogonro warâ nhedyly?” tâkezeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Deus einwântânry modo typynirymo, tokumo, tâty tywogonro modo wâgâ warâ kulâ inanry âtynanâdylymo. Âmaemo olâ, awârâ wâgâ tâtynanâzeba itaungâ. Tunwyn-em âmaemo Deus kaynonrogue. Tutuze mâkâ idânârâ ize matomo. Âpynirymo, okumo, itymo owogonromo, awârâ modo xuduze lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Awylygue âwymârymo Deus ize ato modo waunroem aietaungâ. Mâkâ ize ato wâgâ waunroem mâpaunzeduomo, idânârâ ize matomo xuduze Deus — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","— Tâseguâdâzeba itaungâ kopaelâgâ ainigue. Kopaelâgâembaba mawânkâ Deus tynynonro modo nhedyly. Mâseguâdâdomogue kulâ mâpaunzedylymo watay, adakaladâze âmaemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus aguely: — Ânguy kâzewentâdaundâ, Deus iwentâbyramo itoem lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Âkelomoram mâundulymo ara lâpylâ ise Deus âyanmo nhuduly. Imâem mâundulymo watay, imâem lâpylâ ise Deus nhuduly. Imâemba watay, imâembalâ ise nhuduly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Agonromo tâwentâze âmaemo, âdiempa inakanhe aitobyry wâgâ kulâ, âmaemo olâ inakanhe kuru aini. Koendonro mâkeba awârâ. Agonro âzenupialodobyry lelâ mâenkylymo, inumo odano se iwatary imâsedo pylâ mâempyra âmaemo-ro myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Agonromo âzenupialodobyry etyze myguewâdylymo, inumo oday se iwatarybe awyly umelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Saguhoem wao inumo odano se iwatary etywâdaungâ, koendâ agonromo âzenupialodobyry mâentyhomoem. Koendonro emyenro wâne âmaemo, inakanhe kulâ olâ amidylymo! Saguhoem kuru wao inakanhe amidylymo imowâdaungâ. Inakanhe amidylymo mâinmopygueduomoma ise tâwâlâ agonrodo mâunrudylymo, inakanhe anipyra itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","— Deus itaumbyry egatuly izepaom modo tindadyseba awyly umelâ aguehonly watay, tindadyseba inkâba, Deus itaumbyry iweniby kaxoroam samely waunlo ara kulâ. Amyguelymo watay, kaxoro ara otoguyzemo, nhâsemo warâ. Tuhu tâwâenseim pâsega nhakabehoem samely myara kulâ ise amyguehomobyry — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesus aguely: — Ekadaungâ. Mâenkaduomo, emakeze lelâ âmaemo. Xuiwâtaungâ. Mâwinduomo, soenkeze lelâ âmaemo. Pyantaylâ âtâ sodo igâsedaungâ, enahungueze lelâ mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Idânârâ ekanibyry modo emakeze. Xuirimpyry modo soenkeze. Âtâ sodo pyantay tygâsenibyryram enahungueze. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Âmerymo turu nhekaduo, tuhu mâunduwâpyra âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kanra âjihuyby nhekaduo, âgâu mâunduwâpyra âmaemo eoduem. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Inakai wâne âmaemo, iwâkuru modo olâ âmerymoram mâundulymo. Kunwym kaynonroma kuru koendonro-ro; koendonro modo xuduze ekanibyry modoram! ");
INSERT INTO bkqNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","— Âkelomo agâ koendâ itaungâ, agâmo koendâ awyse matomo ara. Xirâ aguely mawânrâ Moisés inweniby, akaemo Deus wâgâ aguewâni modo konomedâdobyry warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesus aguely: — Agui lelâ yeinwândysebaom modo tâwâlâ ize tato ara kulâ adâidyse awylymo; Deus ize ato ara adâidysebamo. Pyanta tâtaydygueim oze tâgawândyse awylymo, ânwa tâtaydygueim oze tâtâdyze awylymo warâ. Awylygue ise tâdâsenagazedoram kulâ idâlymo, Satanás eydâ atoram. Akaemo araba itaungâ. Yeinwântaungâ, pyanta tâtabigueim oze egawânni ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ton-honreim olâ awârâ ânwa tâtabigueim oze tâdâtâly, pyanta tâtabigueim oze tâzegawândyly warâ, myara lâpylâ aguipa kulâ Deus eydâ atoram idâwâni modo, tâwâlâ âjize tawyly imowâni modo, Deus ize ato ara lelâ aitaynrim modo warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus aguely: — Tonomeguelâ itaungâ, “Deus itaumbyry egatuim xina” kewâni modo agâ. Udodo kaneru xuhudugue âzetydâdyby emyenro kulâ akaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Inakanhe aidylymogue olâ ise Deus eynynonro keba awylymo mâuntulymo. Tyguyreim, uvague tâwituneba; kazainwam, figugue tâwiseba warâ. Tâwilygue lelâ mawânrâ nady modo ewitu. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Se takyguenry, koendâ lelâ ewily, ein-hoem tuduze. Se takygueim, inakanhe lâpylâ ewily, ein-hoem nudupa. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Se koendâ tâwisenry satâly lelâ. Peto onwanji samely-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Warâ ise ânguy Deus wâgâ koendâ aguenri, ânguy konokuni warâ awyly, mâuntulymo aidyly wâgâlâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesus aguely: — Deus aguehobyry ara aini modo lelâ ise Deus eydâ atoram idânri. Toenzepa kurâ domodo yam, “Pymâ, pymâ” kewâni modo, kewâdylymo kulâ olâ. Pabai kaynonro eydâ atoram nâtâwâbyramo ise, Deus aguehobyry ara anipyra awylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Xypyry etay, “Jesus eynynonro xina” kewâtyby modo warâ ise yam aguelymo: “Pymâ, Deus itaumbyry xina egatuwâm on-honrugue. Toenzepa kadopâ modo xina egaseânmâ, toenzepa adyesenry modo warâ xina aiemâ on-honrugue” kezemo yam. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Warâ olâ ise eyanmo auguely: “Âutuwâbyramo urâ. Ydâpa itaungâ, âmaemo inakanhe aitaynrim modo!” keze lelâ urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesus aguely: — Deus itaumbyry indadyly, aguehobyry ara aidyly waunlo uguondo tonomegueim, tuhu wâgâ tâty itânibyry emyenro. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Toenzepa kopâ ihugueduo, paru inwenly. Sapezenru ton-honre kehoem âtâ onwa idâly. Mârâ âtâ olâ nihugueba, tâhugane kehoem tuhu wâgâ itâdyby awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","— Deus itaumbyry idani, aguehobyry ara aniempyra olâ waunlo uguondo sagunu wâgâ tâty itâni emyenro kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Toenzepa kopâ ihugueduo, paru inwenly. Ton-honre kehoem adapezeinly âtâ onwa. Aituo âtâ ihuguely. Idânârâ kehoem adakalaguely, tâhuganeba itâdyby awylygue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus aguepygueduo, toenzepa myani kurâ domodo âsewânily, arâ tâzenomedâoduomo. ");
INSERT INTO bkqNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Aguelymo: — Adâkeho tutuze lelâlâ awâkâ uguondo! Ton-honruguelâ awâkâ aguely, akaemo Moisés inweniby wâgâ enomedâni modo ara inkâba — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iwy wâgâpa Jesus xytâguyly. Toenzepa myani kurâ domodo nhapygue awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aituo myani uguondo iopaji saindyly. Jesus enado âzeguhoam idyly, tynrense tawyly tienehon-hoem. Tâjimituguelygue tâwâneim myani mâkâ. Aituo Jesusram aguely: — Pymâ, kua yese ton-honre mawyly, xutuanze. Kua yedyse âmâ watay, kua yekâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus tâmarygue MÂʼ nhedyly. Eyam aguely: — Kua âedyse urâ. Tâwânepa âmâ iweâma. Kua âetai — kely. Ilâenlâ kehoem kua idyly. Iwâgâ pinuri peba idyly, itugoenzely warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Eyam aguely: — Idakâ. Iweâma tâwâlâ idâ. Ânguyran-ne xirâ kua âetobyry kâzegatu — kely. — Kurâdo eynynâ Deus agâ agueinram âzehora, kua itybyem mawyly nhetoem. Kua itybyem mawyly kurâdo nhetoem, Deusram âdylâ xudugâ, kâzewenryem Moisés inweniby agueho ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jesus idâly xidadâ Cafarnaumram. Saimpygueduolâ kehoem myani sodadu domodo iwymâry idâly eyam. Aituo aguely: — Pymâ, târâ ietydâ yagâ tâwaneim toenzepa ewânu. LYK itoenlâ nudupa. Toenzepa âpyneândyly. Kua mânhedyse wâne urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","— Idâze urâ itynra, kua iese — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Târâ endaylâ Jesus mâkâ tâwâneim kua iese ton-honre awyly tâinwânse olâ myani mâkâ uguondo. Aituo myani aguely: — Pymâ, âdy mâkeba urâ, ietyram mâwântoem. Toenzepa ton-honreim âmâ. Iwague endaylâ yagâ tâwaneim kua itoem amyguely watay, kua ise lelâ mâkâ — kely sodadu iwymâry. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","— Ywymâry modo aguely tâinwânse urâ. Tyzodadugue lâpylâ urâ, yeinwânni modogue warâ. Kâingonotuo, tâtâze lelâ. Eagonro kâingâseduo, tâese lelâ warâ. Yagâ tâwaneinram “Xirâ aiekâ” ugueduo, inepa adyese lelâ warâ — kely myani cem sodadu domodo iwymâry. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Awârâ tindatuo myani Jesus toenzepa kehoem âsewânily, mâkâ sodadu domodo iwymâry toenzepa tâinwândyly tiuntuduo. Aguely mâkâ kurâdo tyampygueni modoram: — Eagâ tâwaneim kua kânhedyly tâinwânse mynra merâ uguondo. Ânguy yeinwânni kâentaymba urâ merâ Roma donro yeinwânto ara kehoem. Kypemugudo israelita domodo duay kuru ânguy yeinwânni lâpeba merâ ara! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","— Enanâguewâdaungâ xirâ. Toenzepa ise israelita domodo keba ewy Deus pymâem atoram idâim. Xixi egaseho eynynonro modo, egawânto eynynonro modo warâ kehoem ise âtâdyguylymo Deus pymâem atodâ. Toenzepa ise âzetyguedylymo, iomarumo warâ, kydamudo Abraão, Isaque, Jacó akaemo agâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tâlâ olâ ise toenzepa kypemugudo israelita domodo ewy Deus pymâem atoram idâdânry, yeinwâmpyra awylymogue. Iamu odaxi ise adameolymo, toenzepa kehoem âsenagazedomoem. Toenzepa ohogüenzemo, tyery saguzemo warâ, tâsenagazedylymogue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus aguely sodadu iwymâryam: — Idâ ityam. Agâ tâwaneim kua kânhedyly; meinwântaima. Aituo enra kua kânhedyly — kely. Jesus aguely umelâ myani sodadu iwymâry agâ tâwaneim kua idyly lelâ târâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sodadu modo iwymâry agâ âtunâguedybyem myani Jesus idâly Simão Pedro etyram. Saintybyem myani Simão imenhundu tâwâne, toenzepa kehoem iaturu kely indadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus tâwâneim eguetonra idâly. Emary wâgâ nhawâdyly. Ilâ umelâ kehoem myani kua idyly; tyatureba idyly, pekodo saudyly, ipynirymo aiese, âwinduatomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iguampygueduo myani kurâ domodo kadopâgue taseim modo, tâwânuneim modo warâ Jesusram nhadylymo. Kadopâ kurâ domodo odaypa egasehoem, tâwânuneim modo kua itoem warâ aguely. Aituo kadopâ modo egasewâdyly, idânârâ tâwânuneim modo kua itaynly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Warâ myakâwândy Deus itaumbyry egatuimbyry Isaías aguely iwâgâ: “Mâkâlâ kâwânu kua ieni, kydâpyneândo etynri warâ” kewândymy. Jesus kurâ domodo kua nhetuo, Isaías aguehobyry aralâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Alâ myani Jesus toenzepa kurâ domodo nhedyly, taynâ, tâynâ warâ kehoem. Tynynonro modo agâ kulelâ tidyse lâwâne myani. Aituo eyanmo aguely: — Kydâzekuâne paru kuyam — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Egaselymo iraynâ kehoem olâ myani Moisés inweniby wâgâ enomedâni saindyly. Jesusram aguely: — Pymâ, âynynonroem widyse urâ. Âdyam mydâhobyryram idâze lelâ urâ, agâ kâsenomedâdoem — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus aguely: — Ton-honre ise enra. Idânârâ ânguydo imeom tâjikune lelâ xykyhobe warâ; poroho, tawâguneim modo warâ tâjikune lelâ. Urâ, Uguondo Kaynâpa Âetyby olâ, iekobyzeguehoenlâ tâtyemba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aituo eagonro uguondo koendâ kehoem Jesus aguely idanipyry aguely: — Pymâ, saguhoem pabai ugueho wao ise kâenkyly, niguepa awyly ara. Igueduo, epyâbygueduo ise âynynonroem widyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus olâ eyam aguely: — Iweâ lelâlâ âekâ ynynonroem. Yeinwântânry modo igueypy ara kulâ, iazeontoem Deus aniempyra awylygue. Xirâ anano wâgâ kulâ âtynanâdylymo. Xirâ onro anano modo wâgâ âtynanâni modolâ igueypy nepyâdâ — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Akaemo azagâ uguondo agâ agueypyem myani Jesus tynynonro modo agâ paruam idâly. Pepi odaxi âxiedyly, paru tienkuâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mârâ paru imâsedo tuotagueze ataymo kehoem myani kopâ sapezenru ton-honreim agonro adaguly. Ton-honre kehoem myani sapezenru paru nhahugânily. Parugue pepi adapadyly warâ. Jesus olâ myani xykyly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aituo eynynonro modo nhuagueândyly, adaenkelymo warâ: — Pymâ, âwaguegâ! Aukâ! Kâmakegârâ. Kyiguely ise xirâ! Pepi xytyzeaji xirâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aituo myani tuagueântuo, Jesus eyanmo aguely: — Tâseanezeba itaungâ. Imakezemo ton-honre wawyly mâinwâmpyra lâgâlâ ianumo — kely. Aituo saudyly. Ton-honre kehoem aguely: — Arâ kehoem tadapezeinzeba ikâ! — kely sapezenruram. — Tahugâneba ikâ! Ipagugâ! — kely paru sahugânuram warâ. Agueduo, tapezenremba idyly, paru tahugâneba idyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Toenzepa myani âsewânilymo, âseguâdâdylymo warâ. Aituo aguelymo: — Etaungâ! Sapezenru nadapezeimba itoem adyese. Paru tahugâneba itoem adyese warâ. Ânguy kuruka awâkâ eon-honru xudunri, awârâ modo anhetoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus tynynonro modo agâ saindyly paru Galiléia kuyam, Gadararam. Târâ myani azagâ uguondo kadopâbeom modo agâ oxiodylymo. Tâdâzepyâdodâpa myani idâlymo, târâlâ âxidâdybyem tawylymogue. Kâmayno, tytazeim warâ myani akaemo. Mârâ âji einkâ sakani modoram tâdytaozemo mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesus tientuo myani ago kehoem adaenkelymo: — Xina kâdynanâdâ, Deus imery. Xina âsenagazedo naimpyralâka xina enagazeze mâewyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tâlâ myani târâ iwaguepa toenzepa pâsega âwinduani modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aituo kadopâdo aguely Jesusram: — Xina mânhânkyduo, awâkâ pâsega modo iodaxilâ xina igonokâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aituo Jesus aguely: — Tâwâlâ, idâwâtaungâ — kely. Agueduo, kadopâ modo akaemo uguondo modo odaypa egasewâdyly. Pâsega modo iodaxi egawândylymo. Kadopâbe tâituo myani pâsega modo enuimbadaynly. Egatudylymo. Iwy wâgâpa paikaji adamunedylymo. Idânârâ kehoem tyense, iguewâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pâsega eni modo iwy wâgâpa pâsega paikaji adamunedyly tâensemo myani. Mârâ aidyly tientuo, âwenkelymo. Inepa kehoem idâlymo xidadâram. Xidadâ odaxi taintuo tonlo modoram tientyby nhegatulymo. Tâgatuzemo lâpylâ myani Jesus kadopâ modo nhânkyhobyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Arâ egary tindatuomo, idânârâ kehoem mârâ xidadâ odano modo Jesus agâ oxioze idâlymo. Toxioduomo, aguelymo eyam: — Âxiguegâ xina ety anaymba. Taynynâ inkâba ikâ — kelymo Jesusram, tâguy pâsega nhaindyseba tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ilâpygueduo myani Jesus tynynonro modo agâ paruam idâly. Pepi imâsedo odaxi âxiedylymo, paru tienkuâdomoem. Âzekuâdybyem, tyjidadâry Cafarnaumram saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tonlo modo ewy uguondo adakobâdânry nhadylymo sawo wâgâ, Jesus kua nhetoem. Kua nhedyly tâinwânsemo awyly tiuntuduo myani Jesus aguely tâwâneinra: — Ton-honre ikâ. Idânârâ inakanhe amitobyry modo xygakeagui — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Moisés inweniby wâgâ enomedâni modo Jesus aguely tindatuo, tâpaunzezemo myani. — Koendâpa awâkâ Jesus aguely! Deus nhunâguedyly kulâ awâkâ! Deus agâ âzekiba tâidyse awyly kulâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tutuze olâ Jesus âdy nhangahumo oday xunârymo awyly-ro warâ. Aituo aguely: — Arâ ywâgâ tâpaunzezeba itaungâ. Unâguedaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","— Merâ adakobâdânryam: “Idânârâ inakanhe amitobyry modo xygakeagui” uguely-ro watay, mâuntuwâbyra ise âmaemo âkealâ, âkealâba warâ auguely awyly. “Aukâ. Adakobâgâ” ugueduo, adakobâdyly-ro watay olâ xutuze âmaemo ton-honre wawyly! ");
INSERT INTO bkqNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Merâ koendâ adakobâdyly mâentuomo, xutuze âmaemo, kurâ domodo inakanhe aito xygakeze ton-honre wawyly urâ Uguondo Kaynâpa Âetyby — kely Jesus. Aituo adakobâdânryam aguely: — Aukâ. Iguetudobyry sanâkâ; adakobâgâ; idâ itynra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aguely umelâ kehoem kua idyly. Saudyly. XYDYK idyly. Adakobâdyly. Tâtyram idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mâkâ aidyly tientuo kurâ domodo âsewânilymo, âseanedylymo warâ. Aituo myani aguelymo: — Koendonro, ton-honreim warâ Deus, awâkâ uguondo tâwânuneim modo kua nhetoem eon-honru nhuduhobyry wâgâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Adakobâdânry kua tiempygueduo myani Jesus târâpa âxiguely. Tadakobâday myani Jesus iedyly, urâ Mateus. Pymâ Roma donro xurâem dinheru impostu epywadobyry emakerim urâ. Târâ dinheru kâenmakezezedodâ ekadybyem wawyly ume ani Jesus yam aguely: — Yagâ âekâ. Ynynonroem ikâ, yagâ mâsenomedâdoem — kely. Aituo yaudyly. Jesus agâ udâly, eynynonroem witoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kopae ietydâ âwinduatoem kâingâsedyly. Aituo Jesus ietyram idâly. Xina âwinduadyly ume, yataen-ho modo ewy saindylymo, impostu epywado emakewâni modo. Kurâ domodo saindylymo lâpylâ, inakanhe tâgaruneim modo. Xina agâ ekadylymo, tâwinduatomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseu domodo ewy Jesus xina agâ âwinduadyly tientuomo, Jesus eynynonro modoram aguelymo: — Kâzewenry araba kulâ awâkâ âwymârymo Jesus aidyly! Dinheru impostu epywado emakewâni modo agâ, kurâdo inakai modo agâ warâ nâwinduapyra tâise awâkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aguelymo tindatuo Jesus eyanmo aguely: — Deus wâgâ auguehoem uirimpyrylâ asaemo. Tâwânuneim modo mawânkâ kua tyeni xuirim, tâwânunenry modo keba. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Deus itaumbyry awo wâgâ iweniby mâuntuba lelâ kuruka âmaemo: “Ânguydo imeom xyâly, iaduândyly mâkeba ize kuru wato, kurâ domodo âjigue koendâ awyly” kewândy Deus. Koendâ âpaunzedaungâ, âdakeze aguely awyly mâuntuhomoem. Inakanhe aitaynrim modo igâseze kâewyly. Inakanhe aitânry modo igâseze inkâba xirâ kâewyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aituo João Batista eynynonro modo ewy saindylymo, Jesusram aguelymo: — Xina João Batista eynynonro modo, fariseu domodo warâ xina nâwinduapyra tâise inanry, Deus agâ adâkehoem. Âynynonro modo olâ nâwinduapyra nipyramo, Deus agâ adâkehomoem. Âdaituoka xina aito ara anipyra awylymo kâzewenry agueho ara? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aituo Jesus eyanmo aguely: — Eagâmo watay, nâwinduapyra nitaymbamo ise. Eagâmopa wituo olâ nâwinduapyra isemo, Deus agâ adâkehomoem. Todohogüin-horam igâsedaymby modo ohogüinrim agâ tatay, nâwinduapyra nitaymbamo, etygumo lelâ. Ohogüinrim tuduaypa ituo lelâ nâwinduapyra idylymo myara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesus aguely: — Âtâbâ adauguehobyry tawentâzeba âtâ iwelo sapidubygue. Âtâ sawentâdobyry tukuiduo, odopâduo, tadaugueze mawânrâ âtâbâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tâjituby vinhu etaryem xygatyby iwelo keba odaxi vinhu iwelo tâkanâduneba. Tâjituby iwelo keba odaxi ekanâduo, etary tadaugueze mawânrâ. Aituo vinhu apâdyly. Aypa olâ, vinhu iwelo etaryem tâjituby iwelo xygatyby odaxilâ ekanâdyly watay, vinhu nhewantuo, imâem ituo warâ, tâjituby iwelo tâzepâgueze. Etary, vinhu alelâ nâxiumebyra — kely Jesus. {Jesus aguely, saguho konomedâdobyry kinmohoem, iwelo konomedâdo kieinwântoem warâ. Saguhobyry mawânrâ nâseinwâmbyra iwelo agâ.} ");
INSERT INTO bkqNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus eyanmo aguely ume myani uguondo âtâ tâdâtâdyguyho iwymâry Jesus iopaji saindyly; âzeguhoam idyly enado. Aguely: — Inoro wao ietyam. Iexiryze nigueaki. Nhonwa imary MÂʼ ieta wao, kurâem itondoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aituo Jesus eagâ idâly. Xina Jesus eynynonro modo tâtâze lâpylâ ani eagâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pymâ etyram xina idâly ume, pekodo tâwâneim Jesus ikaynâ saindyly. Imery etary myani âunkeim; kuapa idyly agâ toenzepa myani iunu ihuguely, toenzepa lelâlâ. Doze anupe myani mâkâ arâ ewânu. Eyam taintuo, ety MÂʼ nhedyly, ikaynâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Warâ tâpaunzeduo myani aidyly. — Etylâ MÂʼ kânhetuo, kua yese lelâ — tâkeduo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tâty tywogonro MÂʼ ietuo, Jesus MYRYK idyly. Pekodo nhedyly. Eyam aguely: — Tyanepa ikâ. Kua ietybyem âmâ, kua kyetâ wawyly mâinwântobyry wâgâ — kely. Aguely umelâ kehoem myani pekodo kua idyly lelâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ilâpygueduo ani xina idâly lelâ. Pymâ etyram xina saindyly. Saintybyem, âguedy tuhu esagueyby odaxi etadâdo eremu xina indadyly. Idânârâ ani tonlo modo eogunrumo, âpyneândylymo warâ, âwynsaundo igueypyem lelâlâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aituo ani Jesus eyanmo aguely: — Igasewâdaungâ wao. Niguewâpyra awâkâ âwynsaundo; xykyly kulâ — kely. {Arâ aguely, kurâem tientondyly tiuntuduo.} Arâ aguely tindatuomo, nheinledylymo. Igueypyem lelâlâ awyly tiuntuduomo, nâepaigueba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Egasebygueduomo, Jesus idâly igueypy eguetunâdobyryram. Egawântybyem Jesus âguedy emary wâgâ nhawâdyly. Ilâenlâ kehoem kurâem nhetondyly, kama wâgâpa saudyly idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Idânârâ âtâ anary iwaguepaom modo Jesus âwynsaundo kurâem nhetondobyry egary tydasemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus agâ târâpa xina âxiguely ume, azagâ epy xina nhapygue idâly. Warâ adaenkelymo: — Xina tytyenzelâ ikâ, Jesus. Pymâ ton-honreim âmâ, âdamu Davi ara! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus âtâ tâxidâdobyryram saintuo azagâ epy modo eagâ egawândyly. Iopaji saindylymo. Jesusram adapâigueolymo: — Tâinwânse lelâlâka âmaemo, kua âenimoem wawyly? — kely. — Tâinwânse xina, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aituo Jesus enumo onwa tâmary MÂʼ nhedyly, kua tientomoem. — Kua âedyly; tâinwânse mawylymogue kua midylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aguely umelâ kehoem epyemba idylymo. Kua tiempygueduomo, Jesus eyanmo aguely: — Awitobyry ânguyram kâzegatuwâdaundâne! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tâtâdaymo olâ mâkânra lelâba nhegatulymo Jesus kua tyetobyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Azagâ epy kua ityby idâpygueduomo, kurâ domodo ewy uguondo tytarenry nhadylymo. Nâjitaimba mâkâ uguondo, kadopâram nâjitaimba âiehoybyem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus mâkâ iodano kadopâ egasehoem agueduo, uguondo koendâ âjitainly adaguly. Idânârâ kurâ domodo âsewânilymo. Aituo aguelymo: — Âdykâ Israeldâ uguondo kadopâbeom kua ieni xina netaymba, Jesus anheto ara! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseu domodo enanaji olâ Jesus aidyly Deus eon-honrugueba. — Kadopâ modo iwymâry eon-honrugue kulâ awâkâ kadopâ modo nhegaseândyly — kelymo; kewâdylymo kulâ olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Idânârâ âtâ anakâ ani Jesus adakobâdyly. Âtâ tâdâtâdyguyho odakâ kurâ domodo nhenomedâdyly. Unâ iwâkuru nhegatuly, âdara Deus idânârâ kurâ domodo iwymâryem idyly wâgâ. Âdaunlo tâzewânugue tâwâneim modo kua tyese lelâ ani. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tadakobâdodâ Jesus toenzepa kurâ domodo nhedyly, kaikâem kulâ. Tientuo, toenzepa intyendylymo, âseguâdâdylymogue, itynrumogue warâ, kaneru todonenry ara kulâ awylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Aituo xinaram aguely: — Etaungâ kurâ domodo. Koendâ tâise Deus itaumbyry nhutulymo. Aguipa kulâ olâ egatuim modo. Deusram ekadaungâ, agui kurâ ingonotoem tywâgâ agueze. Urâem, asaemo kurâ domodo mârâ etâdyby sahuadyby tâkaunâzeim ara, ekaunâni modo olâ ipa myara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aituo Jesus xina doze lelâ tinduakeyby modo indâtyguyly. Xinaram aguely: — On-honrumo kâunduly, kadopâ mânhânkyhomoem, tâwânuneim modo kua mânhetomoem warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Induakeyby modo ezedy xirâ, tywâgâ aguenriem: Waunroeno Simão (Pedro kelygue tâzekeim) André (Simão iukono) Tiago, João warâ (Zebedeu imeombyry) Filipe Bartolomeu Tomé Mateus (Levigue tâzekeim lâpylâ urâ, saguhoem dinheru impostu epywado emakerimbyry) Tiago (Alfeu imerybyry) Tadeu Simão (tâty anary izetonro lelâlâ tawylygue, Roma donrogue tywymâgu izepaom) Judas (Queriote donro, Jesus egamenribyry izepaom modoran-ro warâ) Warâ ani xina doze lelâ, Jesus induakeyby modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Deus xunâry egatuze ani xina âjigonoholy. Xina idâly iraynâ, Jesus aguely: — Judeu keba modo ety anaxi tâtâzebane itaungâ. Samaria eynynonro modo ety anaxi tâtâzeba itaungâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kypemugudoram lelâ Deus itaumbyry egatuwâdaunda, Israelita modoram. Kaneru xuzatyby ara kulâ akaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Warâ ise amyguelymo: “Inepa ise Deus kurâ domodo iwymâryem idyly” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tâwâneim modo kua ietaungâ. Tâjimituguelygue tâwâneim modo kua ietaungâ. Igueypy modo kurâem ietondaungâ. Kurâ domodo kadopâbeom modo kua ietaungâ warâ. Awârâ modo amânhetomoem tâbyguepa on-honrumo kâunduly. Awylygue kadopâbeom modo, tâwânuneim modo warâ kua ietaungâ, tâbyguepalâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mydâdaymo âdylâ manâtomoem ouru, prata, dinheru, awârâ modo kadataundâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Owosarymo kadataundâ. Âgamizarymo, âhurumo etary warâ mâungukehomo kadataundâ. Amatagorumo ânwa oze mâzesebydâdomoem kadataundâ lâpylâ warâ. Tâwaneim mawânkâ âdy ize tato tâmakeze lelâ tâzetoem. Awylygue idânârâ ize matomo ara âdydo imeom âduduoze lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","— Âtâ anaxi aintuomo, âdaunlo uguondo koendonro awyly etaungâ, târâ eagâlâ mitomoem. Mâkâ etydâlâ itaungâ, eagonro âtâ anaryam mydâlymo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Âdaunlolâ âtâ odaji igawândylymo watay, tonlo modo agâ âsedaenguwâdaungâ. “Deus koendâ nhese” kewâtaungâ eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tonlo âtâ odano modo koendâ idaenkulymo, mâengatulymo tindadysemo warâ watay, koendâ ise Deus akaemo agâ awyly. Koendâ idaenkubamo, unâ mâengatulymo tindadysebamo warâ watay olâ Deus eagâmo koendâ itoem kâzekadaundâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","— Mârâ âtâ odano modo, xidadâ odano modo koendâ idaenkubamo, mâengatulymo tindadysebamo warâ watay, inepa târâpa âxiguewâdaungâ. Igasedaymo, âhurumo etary etywâdaungâ, xutoleguguewâdaungâ warâ, Deusram tânagazezeim awylymo xutuhoem, ize ato ara anipyra awylymogue, yeinwâmpyra awylymogue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Sodoma donro modo, Gomorra donro modo warâ myakâwândy ânguydo kulâ. Awylygue myakâwândy Deus peto in-hugueândyly nhonwamo adain-homoem. Xypyryem, idânârâ tynynâbanro modo enagazeze. Deus itaumbyry mâengatulymo izepanro modo olâ ise Sodoma donro modo, Gomorra donro modo warâ âsenagazedobyry takaze kehoem kuru âsenagazezeni. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesus aguely: — Ydataungâ. Deus xunâry egatuze ogonodylymo kâmayno modo duaxi, auwa tâwinzeim modo duaxi kaneru igonodyly ara. Âgâu ara, tonomegue itaungâ, kâmaynodâpa tâdâsemaguely mâuntuhomoem. Koendâ olâ itaungâ, papa ara, âdanimo mânhewiâpanânehomba mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tonomeguelâ itaungâ. Yizepaom modo awâsemo, yeinwândylymogue. Adahoze âmaemo pymâ modo enadoram, mâzenagazeohomoem. Apiogüen-honzemo âtâ tâdâtâdyguyho oday. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yeinwândylymogue, idânârâ pymâ domodoram adahoze âmaemo. “Tumunreim âmaemo” keze akaemo pymâdo, inagazedomoem. Pymâ domodo enado mataymo tâwâlâ ise unâ iwâkuru mâengatulymo âdara imakehomobyry wâgâ judeu domodo iwymâryam, judeu keba modo iwymâryam warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Amyguehomo wâgâ tadahulizeba olâ itaungâ, pymâ domodo enadoram madahoduomo. Deus agâmolâ ise. Âurusemo amyguehomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Âunârymo wâgâ kulâ inkâba ise amyguelymo, Deus Ispiritury xunâry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","— Ipemugudomoanlâ ise yeinwânni modo âzenagazeoly. Ipemugumolâ ise pymâdoram egamenrimo, âdyohomoem. Âjiukonoem, âjiwaigoruem warâlâ ise âsegamelymo. Tâjiunwym, tymery agâlâ ise âsegamelymo lâpylâ, âdyohomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ynynonroem mawylymogue, toenzepa ise mâjiewiâseolymo. Âmaemo yeinwândyly imodânry modo olâ âsemagueze, aunloenlâ Deus agâ mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mârâ xidadâ eydâ matomodâ ynynonroem mawylymogue mâzenagazeoduomo, eagonro âtâ anaxi âwientaungâ, târâ ywâgâ amyguehomoem. Auguely âyanmo. Urâ Uguondo Kaynâpa Âetyby odopâze urâ, idânârâ Israel eynynâ âtâ anakâ ywâgâ amyguelymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","— Enomedâni mawânkâ tonomedâzeim takazeno. Pymâ mawânkâ tâwaneim takazeno. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tonomedâni eto ara lâpylâ ise âsenomedâni âzeholy. Âwanu sodo ara lâpylâ tâwaneim âzeholy. Ayetomo ara lâpylâ ise amâieholymo. Inakanhe aguezemo ywâgâ. Belzebu eon-honrugue kulâ iewanu nhegaedylymo. Âunâguezemo lâpylâ; inakanhe aguezemo âwâgâmo — kely Jesus. (Belzebu, Satanás ezedy eagonro). ");
INSERT INTO bkqNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aituo Jesus aguely: — Ânguy kâdytadaundâ, ywâgâ inagazedylymogue kulâ. Idânârâ soentaymby âjiepanâgueowâze lelâ. Idânârâ koendâ tydasenrybyry MON warâ âjidahoze. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Âyanmo kulelâ auguehobyry idânârâ kurâ domodoram egatuwâdaungâ. Âmaemo kulelâ mâindatybymogue kurâ domodo xurutaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","— Ârinmo kâdytadaundâ; igadopyrymo âdaunloenlâ adaindânry tyân-hoem ton-honremba mawânkâ. Tâwâlâ lelâlâ wâne inagazedylymo. Ton-honremba olâ Satanás eydâ tatoram ogonosemo. Deus anhekyly xytadaungâ. Awâkâ kulelâ mawânkâ âigueduomo, Satanás eydâ atoram ogonosemo ton-honreim. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Idânârâ tâense awâkâ Deus. Etaungâ konopio. Imâem tâwâentuneba konopio. Tokalâ moeda imeimbyry tâwâensenrygue azagâ konopio tadanâhoze. Onro onwa igueypyem nihuguebamo olâ Deus aguehobyry odayba kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nhetâmo lâpylâ Deus. Âdara lelâ angahumo wâgâ angahudumo awyly tutuze. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Awylygue tâseguâdâzeba itaungâ. Deus konopio tâense watay, âmaemoma kuru nhesemo lâpylâ. Xurâem, âmaemo tywyneim kuru, konopio modo takaze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesus aguely: — Tâjiduay, “Jesus eynynonro urâ” myguelymo-ro watay, “Ynynonrolâ asaemo” keze lâpylâ urâ Pabai kaynonroam, enado mawylymo ume. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tâjiduay, “Jesus eynynonro keba urâ” myguelymo-ro watay olâ, Pabai kaynonroam, “Ynynonro mâkeba asaemo” keze lâpylâ urâ, enado mawylymo ume — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesus aguely: — Kâetuo, inakanhe tadawyly, tâdâseguebyly warâ adainly keanra keankâ, inanajimo. Arâpa olâ. Espada iemaym kâenewyly waunlo ara urâ. Ynynonro kebaom modo ynynonro modo agâ âseguebyzemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yeinwândylymogue, âpemugudomolâ ise âewiâsenimo. Tâjimeom tunwym iewiâseze. Tâzexiry tyze iewiâseze. Tâjiweise tymenhundu iewiâseze. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Warâ ise âpemugudomolâ âewiâsedylymo, âkelomo agâmo iewiâky takaze kehoem yeinwândylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","— Ynynonroem midyse mataymo, unwânmo, âzemo, âmerymo, ixirymo warâ takaze kehoem ywynedaungâ. Yakadâ âdaunlo kurâdo kulâ mâinwyneguylymo-ro watay, ynynonroemba ise âutulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ynynonroem lelâlâ midyse mataymo, ize matomo ara kulâ amidylymo imowâdaungâ. Mâsenagazedylymo umelâ auguely idataungâ, yeinwântaungâ warâ, âiguehomo odaji kehoem, kruz manâdylymo-ro waunlo ara. Arâpa-ro watay, ynynonroemba ise mataunaze. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tyâzepa mitomoem kulâ, “Jesus eynynonro keba urâ” myguelymo watay, Deus eydâ atoram mydâpa ise âmaemo. “Âdykâ ‘Jesus eynynonro mâkeba urâ’ uguewâpyra ise urâ, tâwâlâ ise kâdyoly” myguelymo watay, Deus eydâ atoram idâze âmaemo, aunloenlâ eagâ mitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesus aguely: — Koendâ nhenimo, koendâ iedyly lâpylâ. Koendâ ieni, ugononibyry Deuslâ koendâ nhekyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Koendonro xuduze Deus tunâry egatuwâni modoram. Koendonro xuduze lâpylâ olâ tunâry egatuwâni modo emawyadâni modoram. Koendonro xuduze Deus, koendâ aitaynrim modoram. Xirâ koendonro lâpylâ xuduze Deus, koendâ aitaynrim modo emawyadâni modoram, koendâ aidylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","— Âdylâ amânhekyly ynynonro modo emawyadâdoen-ro watay, tâwâlâ wâne parugue kulâ mankuilymo, alâ olâ ise Deusram mâzepywaolymo. Tâwâlâ lelâlâ wâne ynynonro modo âdy keba awyly, alâ olâ Deusram âzeholymo. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus xina doze lelâ tinduakeyby modo xurudyly ewanikeimbyryem, târâpa idâly, xidadâ modo anakâ Deus wâgâ unâ iwâkuru egatuze. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kadeia oday myani João Batista, Jesus Cristo egary indadyly. Egary tindatuo, azagâ tynynonro modo ewy ingonodyly Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesusram taintuo, aguely indadylymo aidyly nhedylymo warâ. João aguehobyry ara Jesus nhapâiguelymo: — “Deus Ingonotyby âese” kehobyrylâ âmâ? Eagonro ise xina inwânwânkyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aituo Jesus in-hoguly: — Odopâdaungâ. Mâentybymo, mâindatybymo warâ Joãoram egatuwâdaunda. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Jesus tâwâneim modo kua nhedyly xina nedâ. Epybyry modo koendâ tâense. Adakobâdânrybyry modo tadakobâzemo iwerâ. Tâjimituguelygue tâwânuneimbyry modo itugoenzeybyem. Kydatânrybyry modo koendâ tydasemo. Iguewâtyby modo kurâem tyetonze. Kaikâ modoram Deus xunâry iwâkuru Jesus nhegatuly xina nidadâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","‘Tuomareim ise yeinwândyly imodânry modo!’ nygue Jesus” myguelymo ise Joãoram — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aituo João eynynonro modo azakâlâ odopâdylymo. Idâpygueduomo Jesus aguely João wâgâ kurâ domodoram: — Agui âmaemo ewy tâtâze âji âdy peba atoram, João aguely idase. Âdaunloka mâkâ, inanajimo? Etaungâ adapezeinly-ro watay, poji wayam wayam warâ tâzekânize. Myara keankâ João, inanajimo? Âdy pebaom modoram âkelo unâ nhegatuly, âdypeom modoram âkelo unâ nhegatuly warâ keankâ aguely, inanajimo? Ainkâba, tokalelâ mâkâ xunâry. Âdypebaom agâ, âdypeom agâ alelâ mâkâ Deus wâgâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Medâmolâ ety iwogonro iwâkuru keba awyly. Âdypeom xidadâ odano, âtâ imâsedo iwâkurugue tâtyreim warâ mawânkâ âtâ tâjiwogonro tâwâenseim ieni. Âdypeom mâkeba mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","— Âdaunlo kuruka mâkâ, âmaemoem? Deus itaumbyry egatuim? Mâkâlâ mâkâ Deus itaumbyry egaturinlâ. Warâ olâ auguely âyanmo. Deus itaumbyry egatuim âdaunlo kulâ mâkeba mâkâ. Idânârâ Deus itaumbyry egatuim modo takaze tynreim mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Warâ iwenibyem awyly Deus itaumbyry awo wâgâ: “Anra unâry egatuim. Waunroenlâ ise merâ kâingonodyly, kurâ domodo nhonse Messias saintodâ” kewândy Deus. Kurâ domodo yaintodâ nhoniem kehobyry mâkâ João. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Uguondo âdaunlo kulâ mâkeba mâkâ João. Tynreim mâkâ, idânârâ saguhoem Deus itaumbyry egatuwâni modo takaze. Mâkâlâ keankâ “Inepa ise Deus Ingonotyby âewyly” keim. Âdara Deus kurâ domodo iwymâryem idyly awyly koendâ nutuba olâ mâkâ. Iwerâ Deus Ingonotybygue tywymâgueim watay, mâkâ takaze ise xynru. Tâwâlâ lelâlâ wâne âdaunlo kulâ awyly. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","— João Deus wâgâ unâ egatuly nhagupygueduolâ keankâ kurâ domodo Deus tywymâryem izetonro modo âzenagazeoly Deus eynynonro keba modoram. Inakai modoram adainhoze kelymo, Deusgue iwymâgumogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Saguhoem Moisés iweniwândymy âdara Deus pymâem idyly awyly wâgâ. Deus eynynâ aguewâni modo iweniwânmo lâpylâmy warâ. “Elias emyenro sainse, Deus itaumbyry egatuim, Deus Ingonotyby saindyly iraynâ” kelymo. Aguehomobyrylâ mawânkâ mâkâ João. Aguely mâinwâmpyra olâ keankâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Augueho mâuntudyze âmaemo watay, koendâ idataungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","— Âdaunloem mawylymo wâgâ agueze urâ, âmaemo xirâ umeno modo. Iamimeom tagonrodo taseray âzenanâdogue tâzenanâdyzebaom ara kulâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tataen-hodo tugoru indyduo, tâidysebamo. Tataen-hodo itynru ume, tytyrembamo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Âdiempa kulâ João Batista âwinduadyly, vinhu nenypa. Warâ awylygue, “Kadopâbeom awâkâ” myguelymo. Urâ Uguondo Kaynâpa Âetyby kâwinduadylygue, kadakuilygue warâ, “Idolai awâkâ. Nhuduypymo tâinze, tânyze alelâ. Impostu epywado emakewâni modo, kurâdo inakai modo eataen-ho warâ awâkâ” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aguitobyry, aguykehobyry warâ wâgâlâ Deus nhutuly xurâem, xurâempa warâ kydâzeholy — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Xidadâ Corazimdâ, Betsaidadâ, Cafarnaumdâ warâ Jesus Deus eon-honrugue toenzepa adyesenry modo aiemâ. Tâenselâ wâne akaemo Jesus aidyly; alâ olâ neinwâmpyra awylymo. Inakanhe adâidylymogue nâjityembyramo lâgâlâ. Adâidyly timodyzebamo. Aituo Jesus ton-honre kehoem iwâgâmo aguely adaguly: ");
INSERT INTO bkqNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","— Warâ auguedyse wawyly unâry izepaom modoram. Toenzepa kehoem ise mâsenagazedylymo, âmaemo Corazim donro modo, Betsaida donro modo warâ. Toenzepa adyesenry modo kehoem ajiedâ âjidadârymodâ, Deus eon-honru kâenehohoem. Yeinwândyseba olâ mataunaguynre. Tumunruneim modo akâwândy Tiro, Sidom warâ donro modo. Deus eon-honru enehonze âjidadârymodâ awitobyry ara ânguylâ aidyly-ro watay, inakanhe adâidyly tumozemo tâise, Deus tâinwânsemo warâ. Tâzetydâzemo tâise âtâem saku tyxieim sakâjibygue, pelupâ tyangahumo onwa tyesemo tâise warâ, inakanhe adâitomobyry wâgâ tâjityendyly tienehon-homoem, imoimbyryem tawyly tienehon-homoem warâ. Deus eon-honrugue awidyly tâense lelâlâ wâne âmaemo. Inakanhe amidylymo mâinmopa olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","— Corazim donro modo, Betsaida donro modo warâ, tâdâsenagazedo saintuo, âmaemo ynynâbaom modo toenzepa ise mâsenagazedylymo, Tiro, Sidom warâ donro modo âsenagazedo takaze kehoem. Xirâ mâuntudyzemo kuru wato. Medâmolâ Deus eon-honrugue awidyly. Akaemo olâ nepyra. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","— Âmaemo Cafarnaum donro modo koendonro, tynreim warâ âmaemo, inanajimo. Deus eydâ atoram mydâlymo warâ wâne, inanajimo. Arâpa olâ. Satanás eydâ atoram ise mâjigonoholymo. Inakai kehoem akâwândy Sodoma donro modo. Deus eon-honru enehonze Cafarnaumdâ awitobyry nhedylymo-ro watay, inakanhe adâidyly tumozemo tâise, Deus tâinwânsemo warâ. Ijidadârymo tainzepa tâise. Deus eon-honrugue awidyly tâense lelâlâ wâne âmaemo. Inakanhe amidylymo mâinmopa olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Cafarnaum donro modo, xypyry etay, tâdâsenagazedo saintuo, âmaemo ynynâbaom modo toenzepa ise mâsenagazedylymo, Sodoma donro modo âsenagazedo takaze kehoem. Xirâ mâuntudyzemo kuru wato. Tâenselâ âmaemo Deus eon-honrugue awidyly. Akaemo olâ nepyra — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ilâpyryem Jesus aguely Deusram: — Kau odano modo, onro wogonro modo warâ sodo âmâ, Pabai! Âdaunlo modoanlâ âunârybyry mutuen-ho, tonomegueim modoram lelâ inkâba, enomedâdaymby modoram lelâ inkâba warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Amânhedyse mato aralâ ise aidyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Deus agâ adâkebygueduo, Jesus agueondyly tonlo modo agâ: — Pabai idânârâ won-honru, ienomery warâ xuduim. Mâkâ kulelâ koendâ kuru utunri. Urâ lelâ lâpylâ Pabai Deus koendâ kuru xuturim warâ. Eyam kâuntuen-hoymby lâpylâ olâ koendâ Deus xutuze. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","— Mâkâ tâmânreingue tyekeim wâne ekozely, myara ekozeybyem mawylymo. Yeinwântaungâ, ikuâdânimo, ahulirinmo warâ kâentyhoem. Âkarymo wogonro tâmânreingue âekelymo waunlo ara ise, ikobyzeguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ynynonroem itaungâ. Âsenomedâdaungâ ywâgâ. Ikobyzeguehomo ese âmaemo. Koendonro urâ, tyewiâseim mâkeba. Imakerinmoem ise urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kâenomedâdo ara amitomoem ton-honruneba, agâmolâma ise urâ, on-hondâzemolâ. Tâmânreim sanâni emawyadâni emyenro urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tâzekobyzegueho oday ani Jesus agâ xina trigu ejidy ezakâ sakadyly. Toenzepa ani xina ewindy. Sahuadybyem ani trigu ewily. Awylygue xina nhasewâdyly, tâmarygue xina nhatuguely, xina nhaguly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseu domodo ewy xina aidyly tientuo ani Jesusram aguelymo: — Egâ âynynonro modo aidyly! Trigu ewily nhasewâdylymo, nhatuguelymo warâ. Tutuzelâ âmâ, kâzewenry eynynâ kokobyzegueho oday kydâsewaniba kydawyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aituo Jesus aguely: — Enanâguewâdaungâ typynigueba tâituomo, kydamu Davi, eagonro modo warâ aitomobyry, toenzepa tâwindymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deus ety odaji myakâwândy Davi egawândyly. Târâ myakâwândy Deusram xuduypy pão modo nhanâdyly, nhedawynlymo tagonrodo agâ. Kâzewenry eynynâ olâ tâise akaemo pão nedawympa. Kurâdo eynynâ Deus agâ aguewâni modo lelâ tâise mârâ pão edawynrim, âkelo modo lâpylâ warâpa. Deus xurâem olâ myakâwândy akaemo inakanhe aidyly keba. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kurâdo eynynâ Deus agâ aguewâni modo kokobyzegueho oday âsewaniduo, inakanhe aidylymo mâkeba lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","— Deus ety takaze mâynrenkylymope tarâ âduaymo awyly olâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Warâ Deus aguehobyry iwenibyem awyly: “Ânguydo imeom xyâly, iaduândyly mâkeba ize wato kuru, kurâ domodo âjigue koendâ awyly” kewândy Deus. Xirâ mâuntuba olâ âmaemo. Âdakeze xirâ aguely awyly mâuntulymo watay, ynynonro modo âdaituoba kulâ mâenwentâdaymba tâise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Uguondo Kaynâpa Âetyby urâ. Âdy iwâkuru adyeseim, adyesenry warâ tâzekobyzegueho oday xuturim urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Târâpa âxigueybyem Jesus idâly âtâ tâdâtâdyguyhoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uguondo âzemapiluguedânrybe ani târâ. Tâlâ pylâ ani kurâdo ewy Jesus izepaom modo. Jesus tiunâguedomoem kulâ aidyly enuagaeni modo. Xunâzelymo: — Tâzekobyzegueho oday Jesus, awâkâ uguondo emary kua nhedyly watay, Moisés inweniby araba aidyly awyly aguykenre. “Deus aiedyseba ato amientai” kykenre — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aituo Jesus in-hoguly: — Tâzekobyzegueho oday iguymo kaneru tâtagueim odaxi ihuguely-ro watay, kopaelâgâem mânhenehonwâbyra âmaemo, mâentyhomoem. Kydâsewaniho keba awyly umelâ, tâzekobyzegueho oday iguymo tâtyze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kaneru takaze kywynu! Awylygue, tâzekobyzegueho oday koendonro aguiendyly watay, Deus ize atolâ aguienkyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aituo Jesus uguondo âzemapiluguedânryram aguely: — Âzemapiluguegâ — kely. Jesus agueduo, uguondo âzemapiluguely, emary kua ienipyryem awylygue. Koendâ idyly; emaduno ara idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseu domodo olâ târâpa egaselymo, Jesus tyâen-hon-hoem tâtunâguedomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tyâly kelymo tiuntuduo ani Jesus târâpa âxiguely. Toenzepa ani kurâ domodo nhapygue idâlymo. Akaemo duano tâwânuneim modo idânârâ kua nhetaynly. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Aituo ani eyanmo aguely: — Ânguyran-ne awitobyry kâzegatuwâdaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Saguhoem iweniwânlâmy Isaías Deus Ingonotyby arâ aidyly wâgâ. Deus aguehobyry aralâ kehoem Jesus wâgâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ ‘Etaungâ! Anra merâ iemary kâinduakeyby. Toenzepa kâinwyneguyly merâ, toenzepa womazeâni warâ. Yispiritury nhonwa iese urâ. Judeu domodoram, judeu keba modoram alelâ ise unâry koendonro nhegatuly. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kurâ domodoram tyewiâse aguepa ise, nadaenkeba ise warâ. Arua oze nâseubyra ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Toenzepa ise kytyendyly. Awylygue ise kurâ domodo âdiempa tâinwânni modo koendâ lelâ nhedyly. Peto nhâseajiom wâne tyânlânehonzeba myara ise âdiempa tâinwânni nitywanânehomba awyly. Inakai modo adain-ho odaxi alâ ise aisezedyly. Kurâ domodo inakanhe tâentuneim modo koendâ lelâ nhedyly, se iwatary âdukagâdyby saseudyly wâne myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Einwânse akaemo idânârâ, tâmakehomoem’ kely Deus,” itaumbyry Isaías iweniby. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ilâpygueduo ani Jesusram uguondo nhadylymo, tytaremba, kâempyra warâ âiehoyby kadopâram. Jesus mâkâ kua nhedyly. Kadopâ egaseduo uguondo koendâ âjitainly idyly, epyemba idyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Awârâ tientuo, tonlo modo toenzepa âsewânilymo. Âjigue aguelymo: — Davi kydamudo iwymâryem awyly myakâwândy myara keanra ise Jesus kywymâryem awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Awârâ tindatuo fariseu domodo aguely: — Kadopâ modo iwymâry Belzebu eon-honrugue kulâ awâkâ kadopâ modo nhânkyly — kelymo; kewâdylymo kulâ olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Âdara xunâgumo awyly tutuze myani Jesus. Aituo aguely: — Âjigue âzety anano modo âseguebyly-ro watay, mârâ âtâ anary tadainze. Âjiukonoem, âjiwaigoruem warâ âjigue âseguebyly-ro watay, tunwyndo sodokewâzemo. Koendâ nâzepyramo, âjidueryem tâisemo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kadopâ modo iwymâry mawânkâ Satanás. Kadopâ modo âjigue âseguebylymo, tygue tygue idylymo warâ watay, ton-honremba tâise Satanás. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Jesus kadopâ nhânkyly olâ, Belzebu mawânkâ aitoem eon-honru xudunri” tâkeze âmaemo. “Belzebu eon-honrugue kulâ kadopâ mânhânkylymo” myguepa olâ âmaemo âynynonromoam. Arâ âynynonromoram amyguepa âmaemo-ro watay, arâ yam adâkezeba lâpylâ itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Deus eon-honruguelâ kadopâ modo kânhânkyly. Won-honru tiundulygue, tutuen-honze mâkâ, tarâ pymâem wawyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","— Uguondo ton-honreim ety odaji ânguy negawântaymba, emagaduze, tâkâjizeba mâkâ watay. Ekâjiduo lelâ isejiguy emagazedyly. Satanás eon-honrugue aini mâkeba urâ, eon-honru sainrim lâkuru — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","— Ynynâba âmaemo-ro watay, ynynonroem inkâba âmaemo. Kurâ domodo Deus nheinwântoem iemawyadâbyra âmaemo watay, neinwâmpyra itomoem amânhenehonlymo lakuru. Ydâ iwague mânhenehonlymo; mâindâtyguylymo tâise koendonro kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","— Deus izepa ato amânhedylymo, amyguelymo, mâunâguedylymo warâ watay, idânârâ awârâ modo xygakeze Deus, mâenkadylymo-ro watay. Deus Ispiritury ewanu wâgâ inakanhe kulâ amyguehomobyry olâ ise Deus nygakeba. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Urâ Uguondo Kaynâpa Âetyby wâgâ inakanhe amyguelymo-ro watay, idânârâ yam inakanhe amyguehomobyry xygakeze Deus, Deusram mâenkadylymo nhygakehoem watay. Deus Ispiritury ewanu wâgâ inakanhe kulâ amyguehomobyry olâ ise Deus nygakeba. Xirâ mawânrâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesus aguely: — Se takyguenry koendâ lelâ ewisely; kiein-hoem tuduze. Se takygueim inakanhe kulâ ewisely; kiein-hoem nudupa. Ewily wâgâlâ se âdaunlo awyly xutuly, koendonro, inakai warâ awyly — kely Jesus. {Koendâ aguidyly, aguykely wâgâlâ koendonro kydawyly âdutuoly. Inakanhe aguidyly, aguykely warâ wâgâlâ inakai kydawyly âdutuoly. Warâ Jesus konomedâze aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jesus aguely: — Âgâu ara kâmayno kulâ myaze âmaemo! Awylygue koendonro modo wâgâ amyguepa mawylymo. Kyangahu odanolâ mawânrâ aguykeho. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Âdylâ ekanâdo oday koendonro ekanâdyby watay, koendonrolâ tâtyzeim. Inakai ekanâdyby watay, inakailâ lâpylâ tâtyzeim. Arâ lâpylâ kunâry kyangahu oday kydâpaunzedo kienkanâdyby. Koendonro watay, koendonrolâ aguykeho. Inakai watay, inakailâ aguykeho warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","— Xypyry etay, Deus enadoram mâepanâgueduomo, inakanhe amyguehomobyry ara ise mâkâ idânârâ inagazedylymo. Xirâ mawânrâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Âunârymo wâgâlâ âdaunlo mawylymo tutuen-honze âmaemo. Âunârymo wâgâlâ ise Deus tâwentâzeinhe, tâwentâzein-emba warâ mawylymo nhutuly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ilâpygueduo Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ Jesus iopaji idâlymo, aguelymo: — Âdylâ adyesenry amânhedyly tiendyse xina, Deuslâ ogononi, on-honru xuduim warâ awyly xina nhutuhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aituo Jesus eyanmo aguely: — Iumunrumi âmaemo xirâ umeno modo! Deus tumoze âmaemo, pekodo tuso inmoho ara. “Adyesenry aiekâ, Deus Ingonotyby mawyly xina tiuntuhoem” tâkeze âmaemo. Deus itaumbyry egatuimbyry Jonas aitobyry enanâguewâdaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kanra imâsedoram xuoympyem, azagâ emedyly idyly ara myakâwândy mâkâ ioday awyly, Niguepa olâ myakâwândy; kanra imâsedo âjitaguiguely ara. Alâpylâ ise, yigueduo, ieguepybyry etadâdybyem awyly. Azagâ emedyly idyly wâgâ olâ ise kurâem witondyly. Mâenanâgueduomo ise, Deus Ingonotybylâ wawyly, mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kanra adyry odanopyryem myakâwândy Jonas idâly Niniveram, Deus itaumbyry egatuze. Jonas aguely tindatuomo myakâwândy, mârâ xidadâ odano modo Deus nheinwândylymo. Âjityendylymo inakanhe tawyly inmolymo warâ. Akaemo emyenro keba olâ âmaemo. Urâ, Jonas takaze won-honru. Auguely mâindadysebamo, mâinwândysebamo warâ olâ âmaemo. Awylygue ise xypyry etay, Deus enadoram mâepanâgueduomo, warâ ise Nínive donro modo Deusram aguelymo: “Tâwâlâ akaemo kurâ domodo Jesus aidyly, aguely warâ einwântânrybyry modo nâsenagazedâmo” kezemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","— Enanâguewâdaungâ mâkâ pekodo Sabádâ pymâpyry. Taypa myakâwândy mâkâ idâly, eagonro anaymba, Salomão enomery idase. Ienomery olâ Salomão enomery takaze kehoem. Tarâ âduaymo lelâlâ wâne urâ, arâlâ olâ inomedâdomo mâindadyseba, mâuntudyzeba warâ mawylymo. Awylygue ise xypyry etay Deus enadoram mâepanâgueduomo, warâ ise mâkâ pekodo pymâ aguely Deusram: “Tâwâlâ akaemo kurâ domodo Jesus tonomedâdyly tindadysebamo atomobyry ara nâsenagazedâmo” keze — kely Jesus fariseu domodoram, Moisés inweniby wâgâ enomedâni modoram warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus aguely: — Tâlâ myani kadopâ kurâ odaypa nhânkyby. Mâkâ kadopâ adakobâdyly myani paru peba ato einkâ, tâjidy xuize. Tâjidy nepyra olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aituo mâkâ kadopâ tâwâlâ aguely: “Iegasehobyryanlâ ise kodopâdyly mâkâ saguhoem inakanhe kânhetybyanlâ” kely. Adâkeduo, odopâdyly. Nodopâbyra awyly ara, koendâ myani mâkâ uguondo, eagonro kadopâram nâdynanâoba, âtâ koendâ kehoem nhontyby, taxiemba wâne myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aituo myani mâkâ kadopâ sete lelâ tataen-hodo inakai modo kuru ese idâly, mâkâ uguondo odaxi tâxiedomoem. Aituo mâkâ uguondo ago kehoem kuru inakanhe itondyly, tokalâ kadopâbe tatobyry takaze kehoem. Arâ lâpylâ ise inakanhe misezedylymo, yeinwâmpyra âmaemo watay — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus aguely ume ise, iukonodo warâ saindylymo eydâ atoram. Kuoholâ ingâsenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aituo Jesusram aguenri aguely: — Âze, âukonodo warâ tarâ kuohomo. Agâ adâkedyzemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aituo Jesus aguely: — Yze lelâlâ mâkâ pekodo. Konodo lelâlâ akaemo uguondo modo warâ. Tâlâ lâpylâ olâ yze ara lelâ, konodo ara lelâ warâ kâenkyly kuru — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","— Etaungâ ynynonro modo. Asaemo mawânkâ yze ara, konodo ara warâ kâenkyly, kâinwyneguyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Idânârâ mâkâ Pabai kaynonro ize ato ara aitaynrim modo mawânkâ konodo ara, koudo ara, yze ara warâ kâenkyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ilâ iguandyly umelâ Jesus âtâ odayba egasely. Paru Galiléia emelaji idâly. Târâ ekadyly, kurâ domodo enomedâze. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Toenzepa kurâ domodo eydâ awyly tânâmize kehoem. Awylygue pepi imeimbyry târâ ekâjiby odaxi idyly, târâ enday kurâ domodo tienomedâdoem. Kurâ domodo tâpagune lelâ paru emelay, Jesus xunâry idase. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Unâ ani nhegatuly, kurâ domodo tienomedâdoem. Aguely: — Xirâ idataungâ. Tâlâ myani uguondo trigu tamuinze etâni typi ezay. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nhamuinday, tâlâ myani ânwa oze ihugueim. Mârâ myani konopio modoram tadaguoze. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tâlâ pylâ myani toenzepa tuhube atoram ihugueim, onro tâsanigueba atoram. Inepa kehoem myani târâ iazely wâne, tydâetâgueba olâ mârâ ago idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xixi myani nady tyaduânse, iwindy ago ondaxi nâtâba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tâlâ myani tyguyreimpe atoram ihugueim. Tyguyreim modo, trigu modo warâ âzekiba ago idyly myani. Tyguyreim olâ ago ini kuru, trigu takaze kehoem. Aituo kopâ ihugueyby nikuiba. Mârâ duay tawylygue trigu newiseba. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tâlâ myani onro iwâkuru onwa ihugueim. Awylygue koendâ kehoem ago itaynly. Toenzepa myani mârâ nady modo ewitunu. Koendâ kehoem myani ekaunâdyly ewy modo wâgâ cem, sessenta, trinta alelâ kehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Warâ Jesus nhegatuly eyanmo. — Xirâ unâ koendâ mâuntudyze mataymo, koendâne angahumo odaji ietaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aituo xina Jesus eynynonro modo kuru nhapâiguely: — Âdaituoka mâenomedâday unâ mâengatuly, ago lelâ amyguepa mawyly? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aituo Jesus in-hoguly: — Saguhoem mykâinane Deus kaynonro nutuen-homba âdara idânârâ iwymâryem tâidyly. Urâlâ olâ xutuen-hoim âyanmo. Koendâ ise âyanmo auguely. Deus koendâ tiuntudyzebaom modo olâ unâ tâgatuzeingue lelâ kâenomedâdyly; ago lelâ auguepa. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Imâem ywâgâ mâuntudyze âmaemo watay, Deuslâ ise mâuntuhomoem aieni. Ânguy ywâgâ tiuntudyzeba watay olâ, âdiempa ywâgâ tiuntuyby enanânehonze, utuba ise warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Awylygue, kurâ domodo kâenomedâday, unâ kâengatuly, tahule kâenomedâdomo nutuba itomoem. Agânhekyly tâensemolâ wâne, nutubamo olâ, nepyramo-ro waunlo ara kulelâ. Auguely tydasemolâ wâne, âdakeze auguely nutubamo olâ ise, nidapyra waunlo ara lelâmo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Deus aguehobyry Isaías inweniby ara aidyly iwerâ: “ ‘Idase wâne âmaemo, âdakeze aguely awyly mâuntuba olâ ise âmaemo. Ese wâne âmaemo, âdy mâenkylymo awyly mâuntuba olâ ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Auguely mâindadyseba, yeinwândyseba warâ âmaemo. Mâpaunzebyramo itybyem, âzenuahuymbyem, âjiwantahuybyem waunlo ara lelâ âmaemo, inomedâdomo mâuntuba mawylymogue. Ywâgâ mâuntudyze lelâlâ âmaemo watay, auguely tydase, tâinwânse warâ tâise âmaemo. Tâpaunzeze tâise âmaemo, âjiwantahudânry ara, âzenuahudânry ara warâ. Inakanhe amitomobyry tygakeze tâise urâ, ynynonroem mitomoem’ nygue Deus” kely myakâwândy Isaías inwenily — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesus xinaram agueondyly: — Tutuze olâ âmaemo, awylygue omarumo. Mâenkylymo tutuze lelâ âmaemo. Mâindatyby tâinwânse lelâ âmaemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Saguho Deus eynynâ aguewâni modo, kurâdo Deus eynynonro modo warâ toenzepa mâenkylymo tiendyse tâisemo myakâwândy, nhetomoem anipyra olâ myakâwândy. Mâindakylymo tindadyse tâisemo myakâwândy, nidapyramo olâ myakâwândy. Xirâ mawânrâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Aituo Jesus aguely: — Ydataungâ wao. Inomedâzemo nady ewy wâgâ auguehobyry ise âyanmo koendâ kâengatuly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mârâ nady ewy ânwa oze tamuinze etâdyby tadaguoze. Aituo âdy niazepa myani târâ samuin-hobyrydâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tydasemo wâne. Inepa olâ Satanás idânârâ indatybymo nhangahumo odayba nhetyly. Aituo pylâ Deus neinwâmpyra awylymo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","— Mârâ nady ewy onro tuhubeom onwa ihuguewâdyby inepa kehoem iazely. Iwindy modo ago ondaxi nâtâba awylygue olâ, inepa iladaynly, iguewâdyly warâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tindatyby modo tâinwânsemo wâne tuomare kehoem. Tâzenagazeoduo olâ inepa kehoem Deus neinwâmpyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","— Mârâ nady ewy tyguyreim duaxi ihuguewâdyby; ago tâise wâne, newiseba olâ, tuahuze mârâ tyguyreim awylygue. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo, Deus tâinwânse wâne. Xirâ onro anaym adienkyly modo wâgâ kulâ olâ âseguâdâdylymo. Toenzepa âdype tâidyly kulâ, toenzepa tydinherugadyly kulâ warâ olâ ize atomo. Awylygue Deus nhenanânehonlymo. Deus itaumbyry nidapyra, iwâgâ nâpaunzebyra warâ idylymo. Deus wâgâ ânguy agâ aguepa idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","— Mârâ nady ewy onro iwâkuru onwa ihuguewâdyby olâ koendâ iazely, ago idyly warâ. Toenzepa ewisely. Tâlâ myani ewy wâgâ cem lelâ ewily xuduim, sessenta lelâ ewily xuduim, trinta lelâ ewily xuduim warâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo tindakylymo lelâ nheinwânkylymo. Deus lelâ nheinwânkylymo. Ize ato lelâ anhekylymo. Iwâgâ aguelymo toenzepa kurâ domodo nheinwântoem warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ilâpygueduo, Jesus âkelo unâ nhegatuondyly tienomedâdomoem. Aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly wâgâ mâuntuhomoem. Tâlâ myani uguondo typi ezay trigu ewy tamuinze etâni. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nhamuimbygueduo myani, kopae xykylymo ume, iduery ipi ezaji idâly. Trigu ewy samuin-hobyrydâ myani joiu keho ewy nhamuinly. Samuinrimbyryem myani idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aituo myani trigu ewy, joiu ewy warâ samuimby iazewâdyly, ago itaynly, âzekiba kehoem ewisewâdyly warâ. Aituo myani sodo agâ tâwanuneim modo mârâ joiu, trigu-empa awyly nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aituo myani âpa ezary sodoram idâlymo. Aguelymo eyam: “Trigu ewy kulelâma keankâ mamuinly târâ âpa ezay; toenzepa olâ joiu, trigu duakâ. Ânguyka keankâ joiu ewy mârâ ezaxi samuinrim?” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","— Aituo âpa ezary sodo in-hoguly: “Uduery keanra keankâ samuinrim” kely. — Eagâ tâwamuneim modo aguelymo: “Joiu xina nhonkedyzeka âmâ iweâ lelâlâ?” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","— Warâ olâ âpa ezary sodo aguely eyanmo: “Alâ nidâ. Joiu monhokelymo-ro watay, trigu nhonkeze lâpylâ mataunaze. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tâwâlâ trigu, joiu alelâ âzekiba ago nidâ. ‘Ekaunâdo odaji ituo joiu ise waunroem kuru monhokelymo, mâintugâjilymo, iaduhoem, peto onwanji manmelymo warâ. Ilâpygueduo ise trigu mâenkaunâdylymo. Kâenkanâdo odaxi mâenkanâdylymo-ro warâ’ keze urâ ekaunâni modoram” kely myani sodo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus âkelo unâ nhegatuondyly eyanmo tienomedâdomoem. Aguely: — Unâ segatuji wao âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tutuzelâ âmaemo, idânârâ nady ewy modo takaze kehoem mostarda ewy imeimbyryem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tâtâduo olâ tyazeze, eagonro modo etâdaymby modo takaze kehoem ago tâise, imâsedo modoem kehoem tywatazeze warâ. Awylygue tawâguneim modo iwatary wâgâ tâty anhetoem nhuduly — kely Jesus. {“Myara lâpylâ saguhoem kuru aguipa kurâdo kulâ Deus tywymâryem awyly einwânni modo. Ilâpygueduo olâ agui idylymo” keze Jesus aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus âkelo unâ nhegatuondyly, tienomedâdomoem. Aguely: — Xirâ unâ lâpylâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Pekodo pão aieni imâem trigu nhedyly; fermentu olâ âdiempa kulâ nhedyly. Mârâ fermentu pão ioliho âdiempaombyry olâ trigu tuolize imâem kehoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Unâem lelâ ani Jesus kurâ domodo nhenomedâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Warâ myakâwândy Deus itaumbyry egatuimbyry Asafe inwenily: “Unâ ise kâengatuly, eagâmo augueday. Adaguday tutuzenrybyry wâgâ augueday” kely myakâwândy. Aituo Jesus unâ kurâ domodo tienomedâdoem nhegatuduo, Deus itaumbyry egatuimbyry aguehobyry ara kehoem aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Agueypyem Jesus kurâ domodo nhodokely. Xina agâ âtânra idâly. Saintybyem iopaji xina idâly, sapâigueze: — Kurâ domodo agâ kydatay, joiu trigu duano wâgâ amygueaki. Âdyka enra awârâ unâgue mâenomedâdyzemo mato? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aituo xinaram aguely: — Urâ Uguondo Kaynâpa Âetyby trigu ewy tamuinze etâni emyenro urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Trigu ewy, joiu ewy alelâ âpa ezay etâdyby ara mawânkâ kurâ domodo tarâ onro anaym awyly, ynynonro modo, ynynâbaom modo alelâ. Ynynonro modo, Deusgue tywymâgueim, trigu ewy aramo. Satanás eynynonro modo pylâ joiu emyenro-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","40","Âpa ezary sodo iduery emyenro mawânkâ Satanás. Nady ekaunâdyly umeno ara lâpylâ ise xypyry etay aidyly. Tâwaneim modo joiu iaduhoem peto onwanji nhamehomo, ara lâpylâ ise xypyry etay anju domodo, Deus eynynâbaom modo eydâpa nhamelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Pymâem kuru wituo, iemary modo igonose urâ târâ kaynâpa, kurâdo inakanhe aityby modo, idânârâ kurâdo inakanhe kulâ aitoem aienibyry modo warâ idâtyguyze. Mâkâ modo duaypa ynynonro modo iese iemary modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Peto nhântânry onwanji ise inakai modo nhamelymo. Târâ ise eogunrunumo, tyery nhagulymo warâ tâpyneândylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Awârâ ume ise ânguy Deus eynynonro kuru awyly edyly. Xixi wâne eunu duaypa idyly myara ise Deus eynynonro modo, tynakaiguneim modo duaypa idylymo. Pabai Deus pymâem atodâ ise ejikumo. Xirâ koendâ mâuntudyze mataymo, koendâ idataungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Aituo Jesus aguely: — Unâ segatuji wao âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tâlâ myani uguondo âpa ezay tâtagueim esagueim. Tiensagueday myani tâwâenseim epyâdyby nhoenkely. Toenzepa kehoem mârâ tientuo, iomazely. Âpa ezary sodo keba olâ myani mâkâ. Aituo mârâ tâwâenseim tiempyâgueyby, nhepyâdondyly. Ilâpygueduo, idâly. Idânârâ tâlâ tato modo vende nhedyly. Ebyry tienmakeybygue, mârâ tâwâenseim tiempyâdobyry onro nhanâdyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesus aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tâlâ myani uguondo pérola vende ieni, sanâni warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","“Xirâ pérola toenzepa tâwâenseim, tâwâenseim lelâlâ, sanâkâ” kehonly myani. Aituo idânârâ tâlâ tato modo vende nhedyly. Ebyry tienmakeybygue mârâ pérola tâwâenseim lelâlâ nhanâdyly — kely Jesus. {“Koendonro kuru Deusgue kywymâgu, idânârâ tâlâ kydato takaze kehoem” keze Jesus aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesus aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly, mâuntuhomoem. Tâlâ myani uguondo modo ewy âedâgue kanra sawâni. Agui kehoem myani âedâ oday kanra inwynly, tâseim, tâsenry alelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Âedâ kanrague xumyduo myani paru emelaji nhuxidylymo. Sagunu wâgâ ekadybyem, kanra iduakelymo. Cestu modo odaxi tâseim nhedylymo. Tâsenry nhamelymo lelâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Arâ lâpylâ ise xypyry ume kurâ domodo âjiduakeoly. Anju domodo âese; kurâ domodo iduakeze. Kurâ inakai modo etyzemo Deus eynynonro modo duaypa. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Deus eynynâbaom modo tâdâsenagazedo peto nhântânry onwanxi adameozemo. Târâ ise eogunrumo, tyery nhagulymo warâ, tâsenagazedylymogue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesusram xina adapâigueoly: — Idânârâ auguehobyry tutuze wâne âmaemo? — kely. Aituo xina in-hoguly: — Tutuze — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aituo Jesus aguely: — Koendâ lelâlâ Moisés inweniby wâgâ enomedâni modo yeinwândylymo watay. Tâwâlâ Moisés inweniby wâgâ, âdara Deus kaynonro kywymâryem idyly awyly wâgâ alelâ nhenomedâdylymo, uguondo wâne koendonro modo tienkanâdyby saguhobyry, iwelo alelâ nhoenkely myara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Unâ tiengatubygueduo ani Jesus târâpa âxiguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Xidadâ Nazaréram odopâdyly, tânamadobyryanlâ. Târâ tâdâtâdyguyhodâ kurâ domodo nhenomedâdyly. Aguely idanipyry modo toenzepa âsewânilymo nhenomedâdo wâgâ. Aituo âjigue aguelymo: — Toenzepa awâkâ enomegu; kiuntuba olâ kurâ ânguy enomedânibyry awyly. Adyesenry modo adyese lelâlâ; kiuntuba olâ kurâ âdara awârâ anhedyly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Segue âdydo imeom xygani Maria agâ imery kulâ mawânkâ; Tiago, José, Simão, Judas warâ iwaigoru kulâ awâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eaundudo tarâ kuduaylâ inanry kyjidadârydâlâ. Kiuntuba olâ kurâ âdykâ awâkâ awârâ nhutuhobyry awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jesus iamugâry enipyry tawylymogue, Deus Ingonotyby mâkâ awyly neinwâmpyra awylymo. Aguely tindadyseba awylymo warâ. Warâ olâ Jesus eyanmo aguely: — Unâ egatuim tâty anaym, unâ nhegatuduo ipemugudoram nâzeinwân-honwâbyra. Ety odano modoram, ety anano modoram warâ tâinwântuneba, âkelo kulâ einwânni — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Neinwâmpyra tawylymogue tonlo modo Jesusram nâtâba awylymo. Aituo myani âdiempa kulâ adyesenry modo târâ anhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mârâ ume Herodes Galiléia eynynonro modo iwymâry. Jesus anhekyly egary indadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aituo tagâ tâwanuneim modoram aguely: — João Batista kurâem itondyby keanra awâkâ Jesus. Awylygue mawânkâ eon-honru adyesenry modo aiese — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","João igueypyem awyly tutuze olâ myani Herodes, mâkâlâ lelâlâ nhangasagânehoimbyry tawylygue. Âdara João xyâhobyry awyly ise kâengatuly wao. Herodes myani Herodias agâ tohogüindyze, tukono Filipe iwydyem awyly umelâ. Alâ mykâinane João aguezesedyly eyam: — “Kukono iwydy agâ todohogüinly lâpeba” kelype Moisés inweniby wâgâ — kezesedyly. Awylygue myani Herodes tyzodadury modoram aguely: — João Batista sawâtaunda. Emakâjiwâdaungâ, etadâdaungâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes wâne myani João tyâen-hondyze, tyangahu oday xunâzely olâ: — Kâyâen-honly-ro watay, kurâdo iewiâpaze yagâ — kely. Kurâdo enanaji Deus itaumbyry egatuim mawânkâ myani João. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","João kadeia oday awyly umelâ myani Herodes iazehobyry etyguedo saindyly. Alâ myani Herodias âdara João tyâen-honly awyly nhutuly. Mârâ âty ume Herodias exiry myani igâsedaymby modo nhetoem âini. Âidyly tientuo myani Herodes toenzepa kehoem nhehoguedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aituo âwynsaundoram aguely: — Tâwâlâ âdylâ ize mato ekagâ; xuduze lelâ urâ. Tâwâlâ ise Deus ienagazedyly, mâenkadyby kâundupa wituo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Âdy nhekaguyly awyly agueimpyryem olâ myani ise. Awylygue myani Herodesram aguely: — João Batista mânhangasagânehonly ize wato. Iweâma ise nhangahubyry mâenenehonly prato oday xarâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Awârâ tindatuo myani pymâ Herodes toenzepa kehoem itywandyly. Adâkehobyry awylygue olâ myani anhenehonly lelâlâ, tingâsedaymby modo, “Tâwâlâ ise Deus ienagazedyly, mâenkadyby kâundupa wituo” kely idanipyrymoem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aituo sodadu ingâsedyly. Eyam aguely: — João nhangasagâda. Nhangahubyry xarâ enekâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aituo sodadu idâly, João etadâdobyryram nhangasagâze. Ilâpyryem nhangahubyry prato odaxi nhedyly, nhadyly âwynsaundoram. Âwynsaundo tyzeram xuduim. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aituo myani João eynynonrobyry modo xyâhobyry egary indadylymo. Tiuntuduomo myani eguepybyry ese idâlymo. Nhadylymo. Tuhu esagueyby odaxi nhetadâdylymo warâ. Jesusram, egatuze tâtâzemo myani. Warâ myani João âdyoly, awylygue myani Herodes tutuze lelâ awyly, João igueypyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","João xyâhobyry egary tindatuo ani Jesus pepi odaxi âxiedyly. Paru ozelâ xina âxiguely. Âji âdy peba atoram xina idâly. Kurâ domodo olâ âdyam idâhobyry tutuze. Xidadâ odano modo, âtâ anary iwaguepaom odano modo warâ myani tuhuru wâgâ Jesus agâ oxioze idâwâni modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pepi odayba itybyem Jesus toenzepa kurâ domodo tynwânwâni modo nhedyly. Akaemo ityenmâ Jesus. Iduaymo tâwânuneim modo kua iemâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iguandyly ume Jesus iopaji xina idâly. Eyam xina aguely: — Iguandyly enra. Âdykâ pyni xuiho lâpeba tarâ. Asaemo igonokâ, âtâ anary iwaguepaonram, typyniry xuize — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus olâ warâ xinaram aguely: — Nâtâwâbyramo ise. Âmaemolâ ipynirymo âunduwâtaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aituo xina aguely: — Nuduwâpyra xina nhuantomoem! Cinco pão, azagâ kanra âjihuyby alâ kulâ taunlo — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","— Enetaungâ pão, kanra âjihuyby warâ yam — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aituo aguely: — Tâwâlâ kurâ domodo nekadâ âji koendonrodâ — kely. Aituo ani Jesus cinco pão, azagâ kanra âjihuyby warâ nhanâdyly. Sanânibyryem, kayam MYK idyly. Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai, awylygue xinaem xirâ pão, merâ kanra warâ mâunduly — kely. Ilâpyryem pão nhepajiwâdyly. Xinaram nhuduly, kurâdoram xina nhepâdoem. Xina nhepâdaynly umelâ kehoem Jesus pão epajiwâdyby, kanra âjihuyby warâ agui nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ize tato ara kehoem ani idânârâ kurâdo âwinduadyly; kanra âjihuyby nhâdylymo, pão nhedawynlymo warâ. Koendâ kehoem iolataynlymo. Ilâpygueduo pão, kanra âjihuyby warâ âsegubydâdaymby xina nhekanâdyly cestu imâsedo modo odaji. Doze cestu tumyke ani xina nhekanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Toenzepa âwinduani modo, cinco mil uguondo modo lelâ, pekodo modo, iamimeom warâ tapâguezebamo. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ilâpyryem Jesus aguely xinaram: — Âxiedaunda pepi odaxi. Idâwâtaungâ Galiléia iwalu kuyam. Tarâ asaemoram âsedaengüybyem ise oiosemo udâly — kely. Aituo xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tonlo modoram tâsedaengubygueduo Jesus iwy onwa âkuly, mâkâ kulelâ Deus agâ adâkehoem. Iguampygueduo, mâkâ kulelâ ani Jesus târâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ilâem pepi oday ani xina paru iotay. Toenzepa ani xina yan-yam adapezeinly; awylygue toenzepa paru adahugânily xina iwepiry onwa. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Emedylylâ, aukuma igâtudyly ume ani, Jesus idâly xinaram paru wâgâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesus paru wâgâ adakobâdyly tientuo, toenzepa xina âseanedyly. — Etaungâ! Kadopâ mâkâ! — tâkewâduo, xina adaenkely tyanugue. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Warâ olâ ani Jesus aguely xinaram: — Âzeon-hondâdaungâ! Tâseanezeba itaungâ! Jesuslâ urâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aituo Pedro aguely eyam: — Pymâ, âkealâ kuru âmâlâ matay, âyam paru wâgâ udâhoem aguekâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","— Âekâ — kely Jesus. Aituo Pedro pepi odayba idyly. Paru wâgâ SE SE warâ idâly Jesus XYDYK warâ atoram. Koendâ lelâ Pedro idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sapezenru eon-honru tiuntuduo olâ âseanedyly, xytyly adaguly. Aituo adaenkely: — Pymâ, iemakegâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Inepa kehoem Jesus tâmary IUK nhedyly Pedro adawâtoem, nytyba itoem. Jesus aguely eyam: — Pedro, imâem yeinwâmpyralâ myanze âmâ! Inepa kehoem imakeinhe wawyly mâinwâmpyra mitai! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aituo azakâlâ pepiram idâlymo, âxiedylymo, sapezenru epagudyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aituo xina Jesus nhehoguedyly: — Âkealâ Deus imery lelâlâ âmâ! — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesus agâlâ xina paru nhekuâdyly. Genesaréram xina saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jesus saintybyem awyly tiuntuduomo tonlo modo aguely: — Etaungâ. Awâkâ mawânkâ Jesus! — kelymo. Âji iwaguepaom donro modoram aguelymo, tâwânuneim modo nhatomoem. Aituo toenzepa kehoem tâwânuneim modo adaholy Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eyam nhekadylymo: — Ity owogonro wao MÂʼ ienehongâ asaemo tâwânuneim modoram, kua itomoem — kelymo. Idânârâ tâty tywogonro MÂʼ ienipyry modo ara kua tyese ani. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aituo fariseu domodo ewy, Moisés inweniby wâgâ enomedâni modo ewy warâ idâlymo Jerusalémdâpa, Jesus agâ âtunâgueze. Aituo aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","— Kydamudo ezewenrypyry ara inkâba âynynonro modo aidyly. Tâwinduatomoem nâzemaunguewâbyramo, kâzewenry ara. Kâzewenry nhakadylymo. Koendâpa akaemo awârâ modo inmoly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aituo Jesus eyanmo aguely: — Âmaemolâ Deus aguehobyry aietânry. Izewenrymolâ mâinwânkylymo, Deus aguehobyry mâkeba. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Unwânmo, âzemo warâ einwântaungâ. Ize atomo eyanmo âunduwâtaungâ” kewândy Deus. “Tunwym, tyze warâ âsenagazedoem Deusram ekani xyâwâtaungâ” kewândy lâpylâmy warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Âmaemo olâ aypa mâenomedâdylymo. “Unwânmo, âzemo warâ âdylâ nhekadylymo watay, ‘Tâlâ wato Deusram ise kâunduly. Awylygue âdy âyanmo kâundupa wawyly’ kewâtaungâ” myguelymo. Alâ kulâ mâenomedâdylymo, amidylymo warâ. Deus aguehobyry âwankuem mânhekylymo, amyguehomobyry lelâ mâinwântomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Koendonro emyenro wâne âmaemo. Izewenrymo kulâ olâ amyguehomo. Âwâgâmo Deus aguehobyry iweniwânmy Isaías: ");
INSERT INTO bkqNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Tytanrugue ywâgâ koendâ adâkezemo, Tuodaxi niepyramo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ywâgâ koendâ adâkezemo wâne, tâzewenke kulâ olâ kurâdo nhenomedâdylymo, augueho araba” kehobyry — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aituo Jesus kurâ domodo ingâsedondyly, eyanmo adâkehoem: — Idataungâ, xutuwâdaungâ xirâ augueho. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mâimpymo mâkeba Deus agueho mankadomoem aieni; mâimpymo tâgaseze mawânrâ. Deus izepa ato amânhedyse mawylymo mawânrâ Deus xurâem inakai; angahumo odaylâ mawânrâ awârâ âtugudyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aituo Jesus opaji xina saindyly. Xina aguely: — Fariseu domodo tutuze iwâgâmo amyguely awyly, awylygue akaemo agâ iewiâky — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus xinaram aguely: — Nady inakai ojionkeoly, adameoly alelâ. Arâ lâpylâ ise idânârâ Pabai kaynonro eynynâbaom modo adameoly eydâpa. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tâseguâdâzeba itaungâ fariseu domodo kywâgâ aguelygue. Epy wâne eagonro epy nhakobâdyly myara akaemo. Deus aguehobyry koendâ nutuba tawylymo umelâ, kurâdo enomedâze kewâdylymo, Epy, epy alelâ adakobâdylymo watay, azakâlâ tyihuguezemo tâtagueim odaxi — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aituo Pedro aguely eyam: — “Mâimpymo mâkeba Deus agueho mankadomoem aieni; mâimpymo tâgaseze mawânrâ. Deus izepa ato amânhedyse mawylymo mawânrâ Deus xurâem inakai; angahumo odaylâ mawânrâ awârâ âtugudyly” myguely enra. Koendâ wao awârâ wâgâ aguekâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aituo Jesus aguely: — Iweâpa lelâlâ wâne yagâ mawylymo; inomedâdomo wato mâuntuba lelâ olâ âmaemo! ");
INSERT INTO bkqNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Âpynirymo mâkeba Deus izepa ato amânhetomoem aienehoim. Eimpy mawânrâ kuwe odaxi idâly, ilâpyryem pylâ kokomiry odaxi-ro warâ. Awârâ modo odakâ sakadybyenma egasely lelâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","— Kyangahu oday mawânrâ kydâpaunzedo, aguiendyse kydato, aguykeho warâ âtugudyly. Awylygue angahumo odayba âeni Deus izepa ato aienehonrim awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Angahumo oday Deus izepa ato amânhedylymo wâgâ tunâgue âmaemo, kurâ mâyândyse midylymo; âkelo iwydy mâynanâdyze midylymo; eagâ mohogüin-homobyry keba kulâ mâynanâdyze midylymo; uguondo, uguondo agâ tâidyse awyly âewyly; pekodo, pekodo agâ tidyse awyly âewyly; imagadudyze midylymo; tâdâsenogudyly myguedyse midylymo; âkelo mâunâguedyze midylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Awârâ modo mawânrâ Deus xurâem âwykanânehoinmo. Tâdâzemaunguebalâ tâdâwinduadylyma Deus xurâem inakai mâkeba-ro — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus agâ xina târâpa idâly, xidadâ Tiro, Sidom warâ iwaguepaonram. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Târâ xina awyly ume pekodo Jesusram saindyly. Judeu keba mâkâ pekodo, idamudo cananéu awylygue. Aituo adaenkely: — Ytyendâlâ ikâ. Âdamu Davi ara pymâ ton-honreim âmâ! Iexiry kadopâgue taseim; kua iekârâ wao. Toenzepa mâkâ âsenagazedyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus olâ âdakepa. Aituo Jesus opaji xina idâly. Eyam xina aguely: — Igonokâ awâkâ pekodo. Kyampyguedyly kulâ awâkâ. Kâkuâdâdyly kulâ awâkâ saenlu — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus xinaram aguely: — Kypemugudo judeu domodo eniem keankâ kâjigonoholy; kaneru xuzatyby wâne myara awylymogue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aguely tindatuo mâkâ pekodo iwaguepa kehoem Jesusram saindyly. Âzeguhoam idyly. Enado âzeguhoam itybyem aguely: — Pymâ, iexiry odayba kadopâ nhânkygâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aituo Jesus aguely: — Koendâ inkâba iamudo ipyniry emakely, kaxorodoam xuduhoem — kely. {Awârâ adâkehogue, koendâ inkâba judeu keba modoram, judeu domodo xurâ xuduly. “Judeu domodo kua kânheto iwerâ. Judeu keba modo kua kânhedyly-ro watay, iamimeom pãogue kâenmakely, kaxorodoam kâunduhoen-ro waunlo ara ise” keze aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Âdakeze aguely awyly xutuwâm olâmy mâkâ pekodo. Aituo aguely: — Arâlâ, Pymâ. Sodo modo mesa iaxi pyni in-hugueânehoymby tâinze olâ kaxoro imeombyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus aguely: — Yeinwântâ mawylygue olâ ise ixiry kua kânhedyly. Mâkâ odaypa kadopâ kânhânkyly, mâenkadobyry ara — kely. Aguely umelâ kehoem myani mâkâ pekodo exiry koendâ idyly, kadopâ tuodaypa egaseduo. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tonlopyryem Jesus agâ xina idâly, paru Galileiaram. Aituo Jesus iwy angataji âkuly. Târâ ekadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Toenzepa kehoem kurâdo eyam idâly. Nhakylymo ezeumpadyby modo, tywyke iazeypy modo, epy modo, tytarenry modo, âkelogue tâwânuneim modo lâpylâ warâ. Enadoram nhakylymo. Idânârâ kehoem kua nhetaynly. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tytarenrybyry modo koendâ kehoem âjitainlymo. Tywyke iazeypy koendâ idylymo. Adakobâdânrybyry modo koendâ adakobâdylymo idyly. Epybyry modo koendâ nhedylymo warâ. Awârâ tientuo tonlo modo toenzepa kehoem âsewânilymo. Aituo israelita domodo iDeusry nhehoguedylymo: — Koendonro, ton-honreim warâ âmâ, Deus — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus xina ingâsedyly. Aguely xinaram: — Ytynroem enra asaemo kurâdo. Kopaelâgâbygueduolâ asaemo yagâ awyly. Taypa âetybybe asaemo duay. Âdy nheinlymo peba-ro warâ. Ipynirymo kâundupa kulâ kâingonodysebamo urâ, tâtyram todopâdaymo ânwa oze ihuguezemo mawânkâ tokozelymogue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aituo xina aguely Jesusram: — Kuantomoem nudupa lâpylâ olâ, iwague xidadâdâ kydawylygue. Asaemo xuato âdykâ imâem pyni kiempyra ise kurâ — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","— Âdara pãobeka âmaemo? — kely. — Sete lelâ, PU warâ kanra âjihuyby warâ — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aituo kurâdoram aguely: — Ikadaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mârâ sete pão, kanra âjihuwâdyby warâ nhanâdyly. Tianâpygueduo Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai. Awylygue xirâ pão, merâ kanra âjihuyby warâ mâunduly — kely. Deus agâ agueypyem nhepajiwâdyly. Xinaram nhuduly, kurâdoram xina nhepâdoem. Xina nhepâdyly umelâ kehoem Jesus pão, kanra âjihuyby warâ agui nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Idânârâ âwinduadylymo ize tato ara kehoem; koendâ kehoem ioladylymo warâ. Ilâpyryem xina cestu imâsedo modo odaxi âsegubydâdyby modo nhekanâdyly. Sete cestu tumyke lelâ xina nhekanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Toenzepa âwinduani modo, quatro mil uguondo modo lelâ, pekodo modo, iamimeom warâ tapâguezeba. ");
INSERT INTO bkqNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ilâpyryem Jesus aguely kurâdoram: — Tâwâlâ itymoram idâwâtaungâ — kely. Agueypyem xina agâ pepi odaji âxieze idâly. Magadã keho yan-yam ani xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iweâpa ipygueduo fariseu domodo ewy, saduceu domodo ewy warâ idâlymo Jesusram. Tienwentâdomoem wâne inakanhe kulâ aguedyse awylymo. Aituo eyam aguelymo: — Deus lelâ anhekyly aiekâ, mâkâlâ ogononi, on-honru xuduim warâ awyly xina nhutuhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aituo Jesus eyanmo aguely: — Iguandyly ume, kau sapabiladyly watay, “Koendâ isenra kopaelâgâ emedyly, kopâ peba” tâkeze âmaemo. Adâise inanry amyguehomobyry ara kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Emetybyem, tyame, eunu tâmyguyne warâ watay, “Kopâ ihugueze iwerâ” myguelymo. Amyguehomobyry ara adâise lelâlâ. Tutuze âmaemo, kau mâendylymo watay, kopâ ihugueze, nihugueba warâ awyly. Agânhekyly modo Deus eon-honruguelâ agânhedyly awyly mâuntuba lelâ olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ânguydoem kulâ âmaemo xirâ umeno modo iwerâ! Deus einwândyly mâinmolymo, pekodo tuso inmoho ara. “Adyesenry aiekâ, Deus ingonotyby mawyly xina nhutuhoem” mygueakimo yam. Deus unâry egatuimbyry Jonas aitobyry enanâguewâdaungâ. Jonas kanra imâsedo tuompygueduo egasehobyry ara, igueypyem kurâem witondyly watay, xutuze âmaemo Deus Ingonotyby lelâlâ wawyly — kely. Agueypyem Jesus akaemo nhodokely, idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Paru tienkuâday pão sadyly xina enanânehonwâm. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aituo Jesus xinaram aguely: — Idataungâ. Tâmaynelâne itaungâ fariseu domodo, saduceu domodo warâ ifermenturygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Âdakeze Jesus arâ aguely awyly xina nutuba olâ. Aituo âjigue xina aguely: — Âdaituoka awâkâ arâ aguely? Pão kienepyra kydatobyry wâgâ? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus olâ xina aguely idamâ. Aituo xinaram aguely: — Âdauguewâpyra urâ, pão mâenanânehon-homobyry wâgâ. Pão wâgâ inkâba auguely. Mâinwâmpyra olâ âmaemo, idânârâ ize matomo ara tuduze wawyly. Âdiempa kulâ mawânrâ yeinwândylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","— Âdaituoka ton-honreim wawyly mâinwâmpyra mawylymo! Saguhoem cinco mil uguondo modo xuadâ cinco pãogue. Idânârâ âwinduatyby modo nioladâmo. Toenzepa cestu modo mumytâdâmo âsegubydâdybygue warâ. Tânanâguezelâ keanra âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iwerâ quatro mil uguondo modo xuatai lâpylâ sete pãogue. Idânârâ âwinduatyby modo niolataimo. Toenzepa cestu modo mumytâdaimo âsegubydâdybygue. Tânanâguezelâ keanra âmaemo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pão wâgâpa auguely awyly mâuntuba gâlâ olâ keanra âmaemo, “Tâmaynelâne itaungâ fariseu domodo, saduceu domodo warâ ifermenturygue” ugueduo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tahuleba kehoem xina fermentu pão ioliho keba agueho awyly xina nhutuly. Fariseu domodo, saduceu domodo warâ nhenomedâdo wâgâ olâ myani Jesus aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ilâpygueduo Jesus idâly xina agâ âtâ anary modo Cesaréia de Filipe iwaguepa. Aituo xinaram aguely: — Ânguy tâkezeka inanry kurâdo yam, urâ Uguondo Kaynâpa Âetybyam? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aituo xina in-hoguly: — Tâlâ inanry, “João Batista kurâem itondyby awâkâ Jesus” kewâni modo. Tâlâ inanry, “Elias kurâem itondyby awâkâ” keim modo warâ. Tâlâ lâpylâ inanry, “Deus eynynâ aguenripyry Jeremias kurâem itondyby awâkâ” keim modo. Tâlâ lâpylâ inanry, “Deus eynynâ aguewâtyby modo ewy kurâem itondyby awâkâ” keim modo warâ — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aituo xinaram aguely: — Âmaemo-ro? Ânguy tâkeze âmaemo yam? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aituo Simão Pedro in-hoguly: — Messiaslâ âmâ, Deus iguedânry imery — kely. (“Deus Kâmakeze Ingonotyby” keze “Messias” kely.) ");
INSERT INTO bkqNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesus eyam aguely: — Mâkâlâ urâ. Tuomareim kuru âmâ, Simão, João imery. Ânguy awârâ mâuntuhoem inomedâdaymba. Pabai kaynonrolâ âyam xutuen-hoim. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Âmâ Pedrogue tâzekeim. “Tuhu imâsedo” keze xirâ âze aguely. Amyguehobyry ara Deus Ingonotybylâ wawyly einwânni watay, ynynonrolâ. Âtâ tuhu wâgâ itâdyby wâne alâ kulâ nihugueba myara ise ynynonro modo âda tyeseba awyly. Tâwâlâ wâne iguelymo, idâzemo olâ yam, yagâ aunloenlâ itomoem. Xirâ mâuntudyze wato kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ynynonro modo mâentoem aiese urâ, pymâ âtâ ijawerygue tâmaseim wâne, âtâ tânahungueze, tânahunze warâ myara ise âmâ. Tarâ onro anaym aiedyseba matobe watay, Deus anienehonwâbyra ise. Tarâ onro anaym aiedyse matobe watay, Deus aienehonze warâ — kely Pedroram. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aituo Jesus aguely idânârâ xinaram: — Mâkâlâ urâ, Deus Ingonotyby. Iwerâ kuru wao olâ Messiaslâ wawyly kâzegatuwâdaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ilâenlâ Jesus nhegatuly xinaram âda tyedyly awyly. — Jerusalémram idâze urâ. Kywymâry modo toenzepa târâ ienagazenehonzemo. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ ienagazenehonzemo. Akaemo ise yiguehoem aienehonrim. Yigueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro olâ neinwâmpyra arâ Deus Ingonotyby âdyoly awyly. Awylygue nhejikely, eagâ adâkehoem: — Pymâ, arâ adâkezeba ikâ. Âtyenze Deus. Inagazenehonwâbyra ise warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aituo Jesus MYK idyly xinaram. Pedro aguehobyry nehoguebyra tawylygue aguely eyam: — Satanás arâ amyguehoem aieni, Pedro. Satanás aguely kâindataymba ise urâ. Ânwa ozeno tuhu wâne kuhodaigâdyly myara Deus ize ato agânhedyseba mawyly. Deus xunâry ara inkâba âunâgu, uguondo modo xunâry ara kulâ — kely Pedroram. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aituo Jesus aguely xinaram: — Ynynonroem ize mataymo, augueho ara aitaungâ. Kopaelâgâembaba ize wato aietaungâ; amânhedyse matomo mâkeba aietaungâ. Kurâ tyâzeim kruz nhadyly tyâhoram myara, ynynonro modo on-hondybyem nidâ igueze. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Jesus eynynonro keba urâ” myguelymo, tyâzepa mitomoem kulâ watay, âdiempa kulâ ise xirâ anaym kurâem mawylymo. Âigueduomo Deus enadoram mydâwâpyra ise âmaemo. Yeinwândylymogue mâdyolymo watay olâ, Deus enadoram idâze âmaemo; aunloenlâ ise eagâ mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tâwâlâ wâne âdydo imeom sodoem mawylymo, ize matomobe mawylymo warâ, Deus eydâ atoram mydâhomoem nepywabyra olâ awârâ modo. Deus agonro keba âmaemo watay, âdype matomo âdy mâkeba. Ânguy niguepa tâitoem nepywadaymba. Tâdâsenagazedo amaxi ise mydâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","— Uguondo Kaynâpa Âetyby urâ. Idâze urâ Deus eydâ atoram; odopâze olâ urâ Deus dompyryem anju domodo agâ. Kodopâdyly ise Kunwym eon-honru tânehonze. Pymâ tynrenseinhe lelâlâ ise urâ. Yeinwânni modo yagâlâ ienehonze urâ. Yeinwântânrybyry modo tâdâsenagazedoram igonose urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iwerâ ydataynrim modo ewy esemo Deus eon-honrugue pymâem widyly adaguly. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis iguandyly ipygueduo ani Jesus iwy onwa âkuly. Pedro, Tiago, Tiago iukono João warâ tagâ nhakyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Târâ Jesus âkeloem idyly nhedylymo myani. Xixi ara kehoem emydy ehozeladyly; esagoymby ara kehoem ety iwogonro sapekadyly warâ nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moisés, Elias warâ nhedylymo lâpylâ, Jesus agâ xunâgumo ume. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aituo Pedro aguely Jesusram: — Koendâ kehoem tarâ kydawyly, Pymâ. Ize matay, azagâ tokalâ warâ âtâ imeimbyry aiese urâ, âmâem, Moisés-em, Elias-em warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro aguely umelâ eunu tohozeleim xytâguyly nhonwamo. Eunu duay Deus aguely indadylymo: — Ymery toenzepa kâinwyneguyly merâ, toenzepa womazeâni. Aguely idataungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pedro, Tiago, João warâ tâjitanru tindatuo, tâseanezemo myani. Awylygue âzeguhoam idylymo onwâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aituo Jesus eyanmo idâly. MÂʼ nhedylymo. Eyanmo aguely: — Autaungâ. Tyanepa itaungâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Adâkehonduo iwykaudylymo enuaguynrumo. Jesus kulelâ olâ nhekylymo; Moisés, Elias warâ netombyramo. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aituo xytâguylymo iwy wâgâpa. Tytâguylymo ume Jesus aguely Pedro, Tiago, João warâam: — Mâentybymone iweâkuru ânguyram kâzegatuwâdaundâ. Yiguely, kurâem witondyly wituo maise tâwâlâ mâengatulymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aituo aguelymo: — Moisés inweniby wâgâ enomedâni modo adâkeze: “Elias âese, Messias Deus Ingonotyby iraynâ” tâkezemo. Âdaituoka arâ aguelymo? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aituo Jesus in-hoguly: — Âkealâ aguelymo; Eliaslâ mawânkâ Messias saindyly wâgâ agueim. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Warâ olâ âyanmo auguely: “Elias ara ini nâedâ” uguely. Deus eynynâbaom modo olâ ize tato ara kehoem nenagazedâ. Myara lâpylâ ise ienagazenehonlymo, urâ Uguondo Kaynâpa Âetyby — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aguely tindatuomo Pedro, Tiago, João warâ tutuzemo lelâ João Batista wâgâ aguely awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesus, Pedro, Tiago, João warâ agâ iwy wâgâpa xytâguybygueduomo, toenzepa kurâdo târâ âtâdyguybyem awyly. Uguondo kurâ domodo duay Jesus iopaji saindyly, enado âzeguhoam idyly, eyam aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","— Pymâ, ymery wao ityengâ! Kua iekâ! Tokomaze inanry merâ; toenzepa inanry âsenagazedyly. Tokomaduo, peto onwanji tyihugueze inanry, paikaji atay warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Âynynonro modoram sekadai wâne, kua nhetomoem. Kua niepyramo olâ enra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aituo Jesus aguely: — Âdy einwânni kebalâ myanze âmaemo! Ânguydo kulâ âmaemo! Agâmolâ wâne urâ, yeinwâmpyra olâ âmaemo. Ynadaize yeinwâmpyra lelâ mawylymogue. Enetaungâ awâkâ salokuzenomo xarâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesusram nhadylymo. Tyam nhatuomo ton-honre kehoem Jesus mâkâ salokuzenomo iodano kadopâram aguely: — Igasegâ iweâ lelâlâ merâ salokuzenomo odaypa, kadopâ! Todopâzeba ikâ-ro warâ! — kely Jesus. Agueduo kadopâ egasely. Salokuzenomo kua idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mârâ aipygueduo xina Jesus iopaji saindyly. Mâkâ kulelâ awyly ume xina nhapâiguely: — Ton-honre lâwâne enra xina aidyly, kadopâ tiânkyhoem. Âda xina niepyra olâ enra. Âdaituo kukeanra? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aituo Jesus in-hoguly: — Deus koendâ mâinwâmpyra mawylymogue enra mâkâ kadopâ mâingonopyra mawylymo. Mostarda ewy imeimbyry aralâ âdiempalâ yeinwântâ âmaemo watay, adyesenry adyese lelâ tâise âmaemo. Xirâ mâuntudyzemo kuru wato. Yeinwântâ lelâlâ âmaemo-ro watay, xirâ iwyram “Âxiguegâ; tarâpa ikâ” myguelymo-ro watay, tâxigueze tâise. Adyesenry amânhetomoem ton-honre lelâ tâise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ton-honreim lelâlâ mâkâ kadopâ salokuzenomo iodanopyry. Deus eon-honru kienkadoem, kydâwinduapyra kidyly wao warâ lelâ mâkâ igonodyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galiléia eynynâ xina adakobâday Jesus xinaram agueondyly tyiguely wâgâ: — Urâ Uguondo Kaynâpa Âetyby yizepaom modo emaxi âzegameoze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Akaemo ise yâen-honri. Yigueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. Jesus tyiguely wâgâ aguely tindatuo, toenzepa kehoem ani xina itynwandyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cafarnaumram xina saimpygueduo aunlo keba uguondo modo âewyly xina eydâ atoram. Deus ety impostury epywado emakeim myani akaemo. Pedroram idâlymo sapâigueze: — Âwymâry Deus ety impostury epywaze? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aituo Pedro in-hoguly: — Epywaze mâkâ — kely. Ilâpygueduo Pedro egawândyly Jesus eydâ atoram. Deus ety Impostury epywado wâgâ Pedro aguely iraynâ, Jesus Pedroram aguely: — Ânguyka tâise pymâdoram impostu epywani? Xirâ anano modolâ? Âkelo anano modo? Âdara mâuntuly, Simão? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aituo Pedro in-hoguly: — Âkelo anano modo tâise epywani — kely. Aituo Jesus aguely: — Iozelâ amyguely — kely. — Pymâ ety anano modo tâise nepywabyra. Alâpylâ urâ Deus ety impostury epywani keba wawyly tâise, Deus eydâpa âetyby wawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Alâ olâ ise kâempywadyly, Deus ety impostury epywado emakewâni modo newiâpabyra itomoem. Paruam idâ. Atâry samegâ. Saguho maweypy ikaguegâ. Mâkâ kanra itay moedape ise. Mârâ moeda ise Deus ety impostury epywado emakeim modoram mâunduly. Xuduze lelâ mârâ, urâ, âmâ warâ impostu kiempywadoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ilâpygueduo kehoem xina Jesus iopaji idâly, sapâigueze: — Ânguyka xina enday tynrenseim kuru Deus kaynonro pymâem atodâ? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aituo Jesus iamudo tonlo ingâsedyly tyam. Iamudo saintuo, Jesus xina ontaji iamudo nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aituo aguely: — Merâ iamudo ara itaungâ. Âwâlâ kulâ mâzehoguedylymo tâiseba itaungâ. Iamudo arâpa âmaemo-ro watay, mydâpa ise âmaemo Deus pymâem atoram. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Merâ iamudo ara mâdutuduomoma toenzepa ise âynrumo Deus nhekyly modo duay. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pymâem xynru waunlo keba merâ iamudo. Mâkâ ynynonro xurâem koendâ amânhedylymo, tynrenseim keba awyly umelâ warâ watay, urâenlâ amânhedylymo. Mâkâ ynynonro xurâem koendâ amidylymo, tynrenseim keba awyly umelâ warâ watay, urâenlâ amidylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesus aguely: — Merâ iamudo yeinwânto ara yeinwânni yeinwâmpyra ienehoim koendâ tâise tuhu imâsedo iwymy wâgâ ekâjily, parutabâ ikaji samely, iguehoem, yeinwâmpyra nhenehonly iraynâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kurâ domodo Deus izepa ato aiedyly imodânry modo mawânkâ toenzepa âsenagazezemo. Yeinwâmpyra itomoem aienehoim olâ ise toenzepa kuru âsenagazeni. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","— Imarymogue Deus izepa ato akâiedaundâ; mydâdysebamo atoram tâtâzeba itaungâ warâ. Koendâ tâise imarymo atay, âhurumo atay warâ satâly, samely warâ, Deus izepa ato amânhepyra mitomoem. Koendonro kuru tâmaguebalâ, tuhuguebalâ warâ Deus agâ aunloenlâ mawylymo; idânârâ kodo peto nhântânry onwanji adameoly mawânrâ koendâpaom kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Deus mâendysebamo ato kâzetaundâ. Koendâ tâise inumo etyly, samely warâ, Deus mâendysebamo ato mâempyra mitomoem. Koendonro kuru tânuembalâ Deus agâ aunloenlâ mawylymo; idânârâ kodo peto nhântânry onwanji adameoly mawânrâ koendâpaom kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesus aguely: — Imâemba yeinwânni izepa tâiseba itaungâ. Deus anju domodo tugonose akaemo eniem. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kaneru eni wâne tâguy xuzatyby xuize tâtâze, myara lâpylâ ynynâbaom modo kâwinly, inakanhe awylymo kâyngakehoem, kâenmakehomoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Cem kaneru ewy tokalâ xuzatuo, âdaidylyka sodo, inanajimo? Noventa e nove tyânze âwinduatodâlâ, mâkâ xuzatyby xuize tâtâhoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nhuinly, nhedyly. Tientuo, toenzepa kehoem iomazely, noventa e nove âwinduani tionmaendyly takaze kehoem iomaru. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kaneru sodo tokalâ tâguy xuzadyseba awyly ara lâpylâ Kunwym Deus kaynonro tokalâ kurâ ewy Satanás ejidyram idâdyseba awyly; tâwâlâ lelâlâ wâne tynrenseim keba awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus xinaram aguely: — Ynynonro ewy inakanhe idyly agâmo-ro watay, idâwâtaungâ eagâ agueze. Inakanhe itobyry wâgâ aguewâtaungâ; âmâ, mâkâ warâ âtunâguedaungâ. Amyguelymo koendâ tindatuo, “Aetobyry enanânehongâ” kely âyanmo watay, aitobyry enanânehonwâdaungâ. Eataen-hoem itondaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amyguelymo tindadyseba watay olâ tokalâ atay, azagâ atay warâ agâmo antaungâ, eagâ amygueontomoem. Wakely iwenibybe mawânrâ Deus itaumbyry awo wâgâ: “Ânguy tânagazezeba ise, azagâ, azagâ tokalâ warâ ewentâni peba watay” kely iwenibybe. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akaemo aguely tindadyseba watay olâ idânârâ yeinwânni modoram anhetyby modo wâgâ aguewâtaungâ, mâkâ agâ aguehomoem. Turudyly tindadyseba watay olâ, Deus einwântânry modo ewyenlâ mâkâ nidâ; impostu epywado emakewâni modo aralâ etaungâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jesus aguely: — Tarâ onro anaym aiedyseba matomobyrybe watay, Deus aidyseba lâpylâ ise târâ kaynâ; tarâ onro anaym aiedyse matomobyrybe watay, Deus aiedyse lâpylâ târâ kaynâ. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","— Tarâ onro anaym âmaemo azagâ mâseinwândylymo, tokalelâ mâenkadomoem watay, Pabai kaynonro xuduze lelâ mâenkadybymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yagâ agueze âtâdyguywâni modo eagâlâ urâ, tâwâlâ wâne azagâ, azagâ tokalâ warâ kulâ awyly. Xirâ mâuntudyzemo kuru wato lâpylâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro Jesusram iwaguepa idâly, nhapâiguely: — Ânguylâ inakanhe kulâ ynynâ aisezedyly watay, âdaraka ise awidyly aitobyry kâenanânehohoem, Pymâ? Sete lelâ inakanhe ynynâ aisezebygueduo tâwâlâ kâpeândyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aituo Jesus in-hoguly: — Sete lelâ âdalâ mâiehoduo tâpeânzeba ikâ. Aedyly agâ, aedyly agâ warâ enanânehongâ aetobyry. Mapâguely eki kehoem awyly umelâ, enanânehongâ; tâpeânzeba ikâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Deusgue tywymâguneim modo inakanhe tuduery tyetobyry modo tânanânehonze. Unâ segatuji wao: — Tâlâ myani pymâ tagâ tâwanuneim modo igondary wâgâ adâkedyzedonro. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aituo akaemo tokalâ, tokalâ warâ ingâsedyly. Saguho ingâseguyly myani imâem kuru tugondagueim. Milhão kehoem myani igondary. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Âdara nhepywadoem nudupa lelâlâ myani, âdy peba tawylygue. Aituo myani iwymâry aguely: “Vende âedylymo isenra, âmâ, âwydy, âmeombyry alelâ” kely. “Tydinherugueinram ise vende âedyly. Idânârâ âsejiguy modo vende iese urâ warâ. Mâkâ eagâ iwano iwelo ise idânârâ dinheru mâenmakely yam xudunri, ogondary mâempywadyly ara” kely mâkâ toenzepa tugondagueinram. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Agueduo, mâkâ tâwaneim toenzepa kehoem adahulily. Aituo âzeguhoam idyly iwymâry enado. Eyam aguely: “Ytyendâlâ wao ikâ. Arâ kehoem ayedâ. Âdiempa wao iwânwânkâ. Epywaze lelâ urâ agâ ugondago” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","— Tutuze olâ iwymâry, mâkâ tagâ tâwaneim âdy peba awyly. Aituo aguely: “Yagâ ogondago enanânehonze urâ. Yagâ tugondaguneba ise âmâ. Idâ lelâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aituo tâwaneim idâly. Târâpa âxigueybyem myani tataen-ho tagâ tugondagueim agâ oxiodyly. Âdiempa kulâ olâ myani mâkâ eagâ igondagu, cem moeda pratagueto lelâ. Aituo myani tataen-ho iwymy wâgâ nhawâdyly. Tingounkuly ume eyam aguely: “Iweâ lelâlâ kehoem iepywagâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","— Aituo myani eataen-ho âzeguhoam itybyem aguely: “Ytyendâlâ ikâ. Iwânwânkâ wao. Idânârâ kehoem agâ ugondago epywaze lelâ urâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","— En-hem kepa olâ myani. Tataen-ho nhadyly lelâ etadânehonze kadeia odaxi. “Tarâlâ ise âmâ, idânârâ yagâ ogondago mâempywadoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tataen-ho nityembyra kehoem aidyly tâense myani akaemo eagonro modo. Tientuo, mâkâ tataen-ho aienibyry izepa tâisemo myani. Aituo myani nhegatulymo tywymâryam. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aituo iwymârymo mâkâ aityby ingâsenehonly. Aguely eyam: “Koendonro keba myaze âmâ! Âtyendylygue yagâ imâem ogondago idânârâ kehoem senanânehoangui, mâenkadobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ataen-ho mityendyze, âtyendobyry ara” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","— Tyewiâpaduo myani pymâ tyzodadury modoram aguely: “Merâ tumunreim kadeia odaxi sataungâ. Târâlâ yagâ tugondago nepywadâ” kely. Warâ myani mâkâ tataen-ho tagâ igondago tienanânehondyzebaom aieholy — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Xina agâ tunâry tympygueândoem kuru Jesus aguely: — Arâ lâpylâ ise Pabai kaynonro aedylymo, inakanhe amâiehohomobyry mâenanânehomba âmaemo-ro watay — kely Jesus xinaram. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Agueypyem Jesus xina agâ idâly Galileiadâpa. Judéia yan-yam xina odopâdyly ânwa oze, paru Jordão kuynâ, xixi egaseho eynynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Toenzepa kurâdo xina agâ awyly. Iduanomo tâwânuneim modo kua tyese ani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseu domodo ewy eagâ agueze idâlymo. Tienwentâdoem wâne inakanhe kulâ aguedyse awylymo. Aituo Jesus nhapâiguelymo: — Kâzewenry eynynâ, tâwâlâka uguondo tywydy inmoly âdy wâgâlâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aituo Jesus in-hoguly: — Deus itaumbyry iweniby tutuzelâ âmaemo. “Kaudyly umelâ myakâwândy Deus uguondo, pekodo warâ nhygadyly, ohogüinrin-em” warâ iwenibyem awyly Deus itaumbyry awo wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Warâ lâpylâ myakâwândy Deus aguely: “Awylygue mawânkâ uguondo, tunwym agâpa, tyze agâpa warâ idyly, tywydy agâ lelâ tâitoem. Awylygue azagâpa awylymo, tokalelâ” kewândymy Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Awylygue mawânkâ ohogüimby modo tywydy agâ tokalelâ awylymo, Deuslâ âzeyam ienimo awylygue. Awylygue ânguy ohogüimby modo âximohoem aniempyra nidâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseu domodo Jesusram agueondylymo: — Tutuzelâ âmâ Moisés inweniby: “Âwydy mâinmodyze âmaemo watay, tâwâlâ imowâdaungâ” kely. “Iweniwâdaungâ olâ âdaituo mâinmolymo awyly. Aitybyem eyam pape mâinwenibymo eyam xuduwâtaungâ. Igonotaungâ lelâ-ro warâ” kely myakâwândy inwenily. Arâ-ro watay, âdaituo pylâka koendâpa tâjiwydy imoly awyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus in-hoguly: — Tutuze myakâwândy Moisés, tienkyly modo ânguydo kulâ, Deus ize ato adiendysedo keba awylymo. Awylygue myakâwândy Moisés “Tâwâlâ tâjiwydy imoly” kely inwenily, pekodo tâwentâzeba itoem. Kaudyly umelâ olâ myakâwândy Deus ohogüinwâdyby modo âximoly izepa awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Agâmo ohogüimbyem tawyly umelâ, eagonro uguondoram âdynanâoly watay lelâ imowâdaungâ, mâinmodyze mataymo olâ-ro warâ. Tâwâlâ lâpylâ arâ aidyly umelâ eagâ mawylymo. Âdaituoba kulâ âwydymo mâinmolymo, eagonro agâ mitomoem kulâ-ro watay olâ, Deus ize ato araba kulâ amidylymo. Waunroem mohogüin-homobyrylâ âwydymo kuru Deus xurâem, nhatano keba. Xirâ mâuntudyzemo kuru wato — kely Jesus fariseu domodoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aituo xina aguely: — Arâ atayma, uguondo nohogüimbalâ koendâ awyly-ro — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus aguely: — Âkealâ, Deus eon-honru nhuduypy lelâ olâ nohogüimba tawyly emaenrim. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tâlâ mawânkâ âdaituo uguondo nohogüimba ato. Tâlâ imezedânryenlâ iazeypy; awylygue tohogüindyzeba awylymo. Tâlâ emukeybyem tawylygue, tohogüindyzebaom. Tâlâ mâkâ Deus itaumbyry tiengatuhoem tohogüindyzebaom, pekodogue, iamudogue warâ aekuru tâtynanâdyzeba tawylygue. Deus, nohogüimba itoem eon-honru nhuduypy lelâ ohogüindânry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ilâpygueduo tâjiunwyndo Jesusram tymeom nhadylymo. — Asaemo nhangahu onwa imary iekâ. Deusram koendâ âzehohomoem ekagâ asaemo xurâem — kelymo. Xina olâ ani akaemo iamudo sanipyry modo tâuse: — Jesus kâdynanâdaundâ — tâkeze. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Arâ xina agueduo Jesus xinaram aguely: — Arâ adâkezeba itaungâ! — kely. — Tâwâlâ iamimeom yam nâedâ. Kodopâdaundâmo. Iamimeom wâne enra ohondybyem lelâ yam tâetoem, myara lâpylâ kurâ domodo nohondâ, yeinwântomoem, Deus kaynonro iwymârymoem itoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aituo Jesus nhangahumo onwa tâmary nhedyly; mâkânra, mâkânra warâ aguely: — Deus koendâ nhese — kely. Aitybyem idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Alâ ani uguondo Jesusram saintybyem, aguely: — Pymâ koendonro, âdyka ise koendonro enday agânhekyly, Deusram udâhoem, aunloenlâ eagâ witoem warâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aituo Jesus in-hoguly: — Amyguely tutuzeka âmâ? Âdaituoka koendonro myguely yam? Tokalelâ koendonro kuru, Deus lelâ. Deus agâ midyse âmâ-ro watay, Moisés inweniby wâgâ agueho ara aikâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","— Âdaunloka ise Moisés inweniby ewy agânhekyly? — kely uguondo. Jesus in-hoguly: — “Ânguy kâdyâ. Eagâ mohogüin-hobyry lelâ xynanâgâ. Tâmagazeba ikâ. Aitobyry wâgâpa kulâ âkelomo kâzewentâdâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Unwâm, âze warâ einwânkâ, xyrenkâ warâ. Agonro agâ âpynegâ; koendâ mâzeto ara, arâ lâpylâ agonrodo agâ koendâ ikâ” — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aituo uguondo aguely: — Aunlolâ inanry idânârâ amyguehobyry Moisés inweniby ara awidyly. Âdy pylâka ise agânhetonguyly, Deus agâ lelâ witoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus aguely: — Deus enudâ kuru amidyse matay, âsejiguy modo idânârâ vende ieta. Ebyry ise âdy pebaom modoram mâunduly-ro warâ. Awârâ amânhedyly-ro watay, tâlâ lelâ ise âmâ koendonro Deus eydâ atodâ ekanâdyby. Idânârâ tâlâ mato mâunduduo, odopâgâ, ynynonroem mitoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesus arâ aguely tindatuo ani mâkâ uguondo toenzepa tydinherugueim âjityendyly, tysejiguy modo vende tiendyseba tawylygue. Tytynre kehoem idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aituo Jesus xinaram aguely: — Ton-honre lelâlâ âdypeom modo yeinwântoem, Deus kaynonro iwymârymoem itoem warâ, tysejiguy kulâ ize atomo kuru awylygue. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ton-honre camelu agüie ihu oze sakadoem, arâ lâpylâ ton-honre âdypeom modo tâlâ tato inmohomoem, Deusgue lelâ tywymâgomoem warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","“Ton-honre lelâlâ âdypeom modo Deusgue iwymâgomoem” Jesus keduo, toenzepa kehoem xina âseguâdâdyly. Xina enanaji, âdypeom modo lakuru Deus eydâ atoram idâim waunlo ara awylygue. Âjigue xina aguely: — Arâ atayma ise ânguy nâsemaguewâbyra-ro — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aituo Jesus xinaram MYK itybyem aguely: — Âkealâ, ânguy nâsemaguewâbyra ton-honrugue kulâ, Deus olâ kurâ domodo anhetânry adyese lelâ. Âdy anhetânry lâpeba Deus — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jesus aguely tindatuo myani Pedro aguely: — Xina-ro? Idânârâ tâlâ tato xina niâm, âynynonroem tâitoem. Iwerâ ise-ro? Âdy ise xina nhemakely? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus xinaram aguely: — Deus idânârâ kehoem iweloem nhetondyly ume, pymâ xurery iwâkuru wâgâ ise iekadyly, pymâem witoem, urâ Uguondo Kaynâpa Âetyby. Pymâem wituo, pymâem lâpylâ ise âmaemo. Pymâdo xurery wâgâ ise ikadylymo, kypemugudo israelita domodo iwymâryem. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Idânârâ tâlâ matomo mânhânlymo, ynynonroem mitomoem watay, Deus xuduze lelâ ipa matomo. Xirâ mâuntudyzemo kuru wato. Itymo mânhânduomo, âykyhomoem ijidymo xuduze. Âwaigorumo, âukonomo, nhaundumo, unwânmo, âzemo, âmeonmo warâ mânhânduo, Deus âpemugumo nhetomo ara kehoem nhenimo, âwynenimo warâ xuduze. Âpimo mânhânduomo, Deus âpynirymo xuduze. Tâlâ matomo mânhânlymo ynynonroem mitomoem watay, âdy ize matomo xuduze, mânhâympymo takaze kehoem ise tâlâ mawylymo. Âigueduomo olâ ise aunloenlâ Deus agâ mawylymo. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iwerâ waunropyry modo, ilâem âgânâynra ise. Âgânonrobyry modo, ilâem waunroem ise warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tâlâ myani uguondo imâsedogue tyfazendagueim. Typi ezay uva etânehonrimbyryem myani. Ekaunâdyly ume, emedyly wâgâ idâly tâwanuneim modo xuize, uva nhekaunâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uguondo modo tientuo myani, eyanmo aguely: “Tâwanuneim modo ize urâ iwerâ, uva ekaunâniem. Koendâ ise ipywadylymo. Tuguanse mâsewanilymo-ro watay, tokalâ moeda prataguetogue ise ipywadylymo” kely. Tutuzemo myani koendâ nhepywadyly awyly. “Ize lelâ ise xina amygueho ara. Âpi ezay âsewanize lelâ xina iwerâ” kelymo myani. Arâ âseinwândybyem, âpa ezary sodo akaemo ingonodyly âsewanize. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Emedyly wâgâ nove horas awârâem myani eagonro tâwanuneim modo xuionse idâondyly. Tâsewanidyzedonro modo âtâdyguyhoam idâly. Tâsewanidyzedo modo tientuo, eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Uva ekaunâni ize urâ” kely. “Iwerâ wao ypi ezaji âsewaniwâdaunda. Koendâ ise ipywadylymo” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","— Âseinwândybyem myani âpa ezaji âsewanize idâlymo. Kuotatay myani âpa ezary sodo idâondyly tâwanuneim modo xuionse. Tientuo myani eyanmo aguely: “Urâem uva ekaunâdaunda. Koendâ ise ipywadylymo” kely. Inepa kehoem myani akaemo aguewâtobyry modo idâly âpa ezaji. Três horas kogoneyam lâpylâ warâ tâwanuneim modo xuionse idâondyly Tâsewanidyzedonro modo tientuo myani, eyanmo aguely: “Urâem uva ekaunâdaunda. Koendâ ise ipywadylymo” kely. Inepa kehoem myani akaemo aguewâtobyry modo idâly âpa ezaji. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kogoneyam, cinco horas awârâem myani âpa ezary sodo idâondyly tâsewanidyzedo modo âtâdyguyhoam. Tâsewanidyze donro modo tientuo myani aguely: “Âdy amânhepyralâ inanry tarâ âguansezedylymo. Âdaituoka âsewanize mydâpa mawylymo?” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","— “Tâsewanidyze wâne xina, ânguy olâ xina ewanu nudupa” kelymo. — “Ypi ezaji pylâ uva ekaunâdaunda” kely âpa ezary sodo. Agueduo myani idâlymo âsewanize. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","— Iguandyly ume, seis horas awârâem myani sodo aguely tâwanuneim modo iwymâryram: “Tâwanu inmoho odaylâ akaemo. Idânârâ tâwanuneim modo igâsegâ, mâempywadomoem. Tokalâ hora lelâ âsewaniby modo saguhoem epywagâ, xypyryem ise tuguanse âsewaniby modo-ro warâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","— Warâ myani nhepywadaynly. Saguhoem nhepywaguyly myani akaemo tokalâ hora lelâ âsewaniby modo. Tokalâ moeda prataguetogue myani âzepywaolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tuguanse âsewaniby modo awârâ tientuo myani, aguelymo âjigue: “Imâem ise kâpywadyly, tokalâ moeda takaze” kelymo. Tokalâ moeda prataguetogue kulâ olâ myani akaemo modo âzepywaolymo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tâpywadobyry tientuomo myani âpa ezary sodo agâ iewiâpadylymo. Eyam aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Koendâ xina mâempywanehonwâbyra enra âmâ. Tokalâ hora kulâ awâkâ agâ saintyby modo nâsewaniagui. Xina lakuru enra tuguanse kehoem âdâpigu oday âsewanirim. Xina agâ âzekiba kehoem akaemo mepywanehoangui. Xina menokudai” kely akaemo tuguanse âsewaniby modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","— Aituo myani âpa ezary sodo eyanmo aguely: “Idataungâ wao. Inokudaymbamo urâ. ‘Tokalâ moeda prataguetogue tuguanse âsewanize lelâ xina’ mygueakimoma. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Ize wato ara ydinheruru agânhedyly. Âzekiba idânârâ kâempywanehonly-ro watay, inokudylymo mâkeba. Akaemo modo arâ kâempywadobyry wâgâ tyewiâseba itaungâ. Mâsewânilymo kulâ. Anra ipywadomo. Emakewâdaungâ. Idâwâtaungâ-ro warâ” kely. Warâ myani, âpa ezary sodo, tâwanuneim modo warâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iwerâ waunropyry modo, xypyry etay âgânâynra ise. Âgânonrobyry modo, xypyry etay waunroem ise — kely Jesus. {Koendâ lelâ awâkâ Jesus agaityon-enlâ tâinwânni agâ, iamudoenlâ tâinwânni agâ alelâ keze awârâ aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Xidadâ Jerusalémram xina âkuly. Tâtâday Jesus aguiom modo duaypa xina nhejikely. Aituo xinaram aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","— Idataungâ wao auguely. Jerusalémram xirâ kytâly. Yizepaom modoram adawâhoze urâ, urâ Uguondo Kaynâpa Âetyby. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ iegamezemo. “Nigue awâkâ” kezemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Judeu keba modo emaxi iegamezemo. Akaemo ise âwankuem yeni, yapiogunri, kruz wâgâ yârim warâ. Awârâpygueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeu iwydy, Tiago, João warâ agâ Jesusram saindylymo. Enado âzeguhoam itybyem eyam aguely: — Âyam kâenkaguyly wao aiekâ — kely mâkâ pekodo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aituo Jesus mâkâ pekodo nhapâiguely: — Âdyka mâenkadyze mato? — kely. Pekodo in-hoguly: — Pymâem kuru mituo, asaemo azagâ ymeombyryne apay ekanâgâmo, tokalâ aho eynynâ, tokalâ pâem eynynâ warâ, pymâem agâ itomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus aguely mâkâ imeombyryram: — Mâuntuwâbyra âmaemo âdara yagâ pymâem mitomoem adâjidyly awyly. Toenzepa kâsenagazedo ara kehoem âsenagazeze tâeganeka ise âmaemo? — kely. Aituo aguelymo: — Emaenze lelâ xina, mâenmaen-ho ara — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus aguely: — Âsenagazeze urâ, âmaemo lâpylâ warâ. Yahoru eynynâ ekani, pâem eynynâ ekani warâ kâinduakeba olâ urâ. Pabai kaynonrolâ ise iduakeim. Mâkâ mawânkâ târâ tâzekado nhonipyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tiago, João warâ ise nhekadobyry tindatuo, xina nehoguebyra ani. Eagâmo xina tyewiâpadaynze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aituo Jesus xina idânârâ ingâsedyly tuopaji, xina agâ adâkehoem: — Tutuzelâ âmaemo, pymâdo ton-honreim modo, tyewiâse kehoem kurâdo agâ aguely, adâkehobyry anhetomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Âmaemo olâ arâpa itaungâ. Mâdyren-hondyze mataymo, tâzemaryenlâ itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Imawyadâbyramo ise urâ. Pymâ wawylygue; âmaemolâ ise urâem aieni” tâkezeba itaungâ, pymâem mituomo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yara itaungâ. Deus Ingonotyby lelâlâ wâne urâ, iemawyadâdomoem âetyby keba olâ urâ, imarymo lakuru urâ. Igueze âetyby urâ. Kurâdo inakanhe aito modo epywaze ise yiguely, Deus aguehobyry ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericódâba xina egaseday, toenzepa kurâ domodo xina nhapygue idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tâlâ ani azagâ epy ânwa edazekâ ekadybyem. “Jesus awâkâ sakani” kely tindatuomo, azakâlâ adaenkelymo: — Xina tytyenzelâ ikâ, Pymâ ton-honreim! Âdamu Davi ara pymâ ton-honreim âmâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ton-honre kehoem kurâdo eyanmo aguely: — MYK alelâ itaungâ. Tadaenkezeba itaungâ warâ — kelymo. Adâkehonduomo lakuru ago kuru adaenkelymo: — Xina tytyenzelâ ikâ, Pymâ. Âdamu Davi ara pymâ ton-honreim âmâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus epagudyly. Akaemo azagâ ingâsedyly. Tuopaji saintuomo Jesus aguely: — Âdyka âmaemoem agânhedyse matomo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","— Tiendyse xina, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tintyenduomo Jesus enumo MÂʼ nhedyly. Inepa kehoem nhedylymo. Xina nhapygueniem idylymo lelâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Âtâ anary Betfagé iwaguepa xina saindyly, Jerusalém iwaguepa, iwy Se Oliveira Ekaram. Myarâ saintybyem, Jesus xina ewy azagâ waunroem ingonodyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wakely eyanmo: — Idâwâtaungâ Betfagéram. Aindylymo umelâ ise tokalâ jumenta, imerylâ warâ ekâjiby mâendylymo. Azakâlâ ekâjiguewâdaungâ. Enetaungâ xarâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Âdaituoka jumenta, imery warâ mandylymo?” myguehonlymo watay, “Kywymâry asaemo izetonro. Inepa olâ ise jumenta, imery warâ nhopânehonly” myguelymo lelâ ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Warâ myakâwândy Deus itaumbyry egatuim Zacarias inwenily: “Jerusalém donro modoram aguewâtaunda: ‘Etaungâ! Âwymârymo saindyly. Pymâ ton-honreim ara kehoem inkâba ise âewyly. Jumentinhu wâgâ ise âewyly, jumenta imery wâgâ’ kewâtaunda eyanmo” kely myakâwândy inwenily. Jesus jumentinhu wâgâ Jerusalémram saintuo, Zacarias inweniby ara kehoem aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aituo akaemo azagâ ingonotyby modo idâly. Jesus aguehobyry ara aidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jumentinhu, ise alelâ nhadylymo. Tygaparyguelâ jumentinhu, ise warâ inkawendâdylymo. Ilâpyryem Jesus jumentinhu onwa âkuly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesus saindyly iray toenzepa kehoem kurâ domodo tygapary ânwa oze PO PO nhedylymo, Jesus tynrense tawyly tienehon-homoem. Tâlâ pylâ wakuri sary tiantâwâdyby modo onro onwa PO PO ieni modo, tynrense tawyly tienehon-homoem, pymâ ton-honreim kehoem iray adâitomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Waunroem idâwâni modo, âgânâ idâwâni modo warâ adaenkewâdylymo adaguly: — Hosana Davi iwerypyry! — kelymo. (“Tohoguezeim Davi iwerypyry” keze aguely.) — Tohoguezeim kuru awâkâ Deus eon-honru enehonze âeni! Hosana Deus kaynonro! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Warâ Jesus Jerusalém odaxi saindyly. Idânârâ kehoem mârâ xidadâ odano modo âjigue aguelymo: — Ânguyka mâkâ saini? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aituo kurâdo in-hoguly: — Jesus mâkâ, Deus ynynâ aguenri. Galiléia eynynonro, xidadâ Nazaré donro mâkâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus egawândyly Deus ety idaseraji. Âdydo imeom vende ieni modo, sanâni modo warâ târâpa nhegaseândaynly, Deus ety oday aidylymo awylygue. Dinheru troca ieni modo iwenzary nhamely. Papa vende ieni modo xurery nhamunedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Egaseânimobyryem eyanmo aguely: — Deus itaumbyry awo wâgâ iwenibyem: “Xirâ iety yagâ agueho xirâ” kewândy Deus. Kurâ domodo mâenmagazedylymo kulâ olâ. Ânguydo imeom Deusram tiunduly nhanâdylymo watay, toenzepa mâenwâentanâdylymo. Dinheru âmaemoenlâ mânhedylymo. Deus ety, tâmagazeim modo otoendoem mânhedylymo kulâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesus Deus ety idaseray atay, epy modo, adakobâdânry modo warâ eyam idâlymo. Kua tyesemo ani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aituo tonlo modo iamimeom adaenkewâdyly: — Hosana Davi iwerypyry! — kelymo. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby enomedâni modo warâ Jesus akaemo tâwânuneim modo kua nhedyly nhedylymo, iamimeom saenlu indadylymo warâ. Aituo toenzepa kehoem iewiâpadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesusram aguelymo: — Iamimeom âwâgâ aguely midatai? Arâ aguepa nidâmo — kelymo. — Xidatailâ. Kâeumpyramo olâ ise urâ. Tutuze urâ, Deus itaumbyry awo wâgâ iweniby tutuzelâ mawylymo: “Iamimeonra, iamimeom tâjihuano modoram warâ ise mâzehogueoly kuru” kely iweniby — kely Jesus eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus Deus ety odayba egasebygueduo, xina idâly Jerusalémdâpa. Betanianra xina xykyze idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kopaelâgâem emedyly wâgâ Jesus agâ xina odopâdyly Jerusalémram. Tâwinze myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Awylygue figueira ânwa edazekânro toenzepa saryum tientuo, ago iopaji saindyly. Tâwise-ro waunlo ara, enanaji, tarysely agâlâ ewiseim mawânrâ figueira. Tâwiseba olâ ani mârâ, toenzepa saryun-em lelâ. Aituo Jesus figueiraram aguely: — Iwiseondaymba olâ ise âmâ — kely. Aguepygueduolâ kehoem figueira iladyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Xina emâ figueira sary iladyly. Toenzepa kehoem xina âsewânily. Aituo xina aguely: — Inepa kehoem awârâ figueira sary niladai! — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus xinaram aguely: — On-honrumo kâunduly mâinwândylymo, âkealâ kuru ton-honre wawyly mâinwândylymo warâ watay, adyesenry modo aiese lelâ âmaemo, figueira agânhetobyry takaze. Amânhetomoem on-honrumo kâunduypygue idânârâ aiese lelâ âmaemo. Xirâ iwyram “Âxiguegâ; paikaji adamegâ” myguelymo-ro watay, tâjidydâpa tâxigueze tâise, paikaji tadameze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Emakeze mawylymo mâinwântuomo, mâenkadybymo âyanmo xuduze Deus. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jerusalémram saintybyem, Jesus idâly Deus ety odaji. Târâ kurâdo nhenomedâdyly ume, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, eagonro pymâ modo warâ eyam idâlymo. Aituo nhapâiguelymo: — Ânguyka tarâ Deus etydâ arâ amitoem agueim? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aituo Jesus in-hoguly: — Apâiguezemo lâpylâ wao urâ. Uhoguduomo ise ânguy ugononibyry awyly auguely — kely. Aituo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","— Ânguyka ani João Batista inakanhe adâitobyry wâgâ âjityendyby modo batiza nhetoem aguenri? Deuslâ? Âdaunlo uguondo kulâ? Uhoguwâdaungâ wao — kely. Aituo myani âjigue aguelymo: — Iwerâ, ise-ro? Âdara kuru ise kin-hoguly? “Deuslâ agueim” kykeduo, “Âdaituo pylâka João aguehobyry mâinwâmpyra mawylymo?” keze. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Uguondo kulâ ani João aitoem agueim, Deus mâkeba” kykeduo, kurâ domodo kagâ iewiâpadaynze. “Deuslâ João Batista igononi” tâkezemo inanry — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Awylygue warâ in-hogulymo: — Xina nutuwâbyra ânguy João Batista batiza nhetoem agueim awyly — kelymo. Aituo Jesus aguely: — Arâ atayma auguepa lâpylâ ise urâ, ânguy xirâ agânhetoem ugononi awyly-ro — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus aguely pymâ modoram: — Adâjitobyry ise unâ kâengatuly. Koendâne idataungâ mâuntuhomoem. Tâlâ myani uguondo azagâ tymegueim. Tymery saguhobyryram aguely: “Ypi uva kâentâdobyry ezaxi isenra âsewanize mydâly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Imery aguely: “Kâsewanidyzeba aze iwerâ. Udâpa ise aze” kely. Agueypyem olâ tunâry nhugukely. Idâly âpa ezaji âsewanize. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aguely lâpylâ iukonoam: “Uva kâentâdobyry ezaxi isenra âsewanize mydâly” kely. Mâkâma, “Idâze lelâ urâ, Pabai” keim. Agueypyem olâ myani âsewanize nâtâba. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","Aituo Jesus aguely pymâ domodoram: — Âdaunloka akaemo enday tunwym ize ato ara aini? — kely. Aituo in-hogulymo: — Iwaigoru âsewanize idâhobyry wâgâ — kelymo. Jesus eyanmo aguely: — Âkealâ awârâ. Mâkâ iukono ara kulâ olâ amidylymo. Impostu epywado emakewâni modo, pekodo inakanhe aini modo warâ mawânkâ yeinwântâmo. Âmaemo kulelâ yeinwântânry. Âdara Deus ize ato ara lelâ amidylymo awyly enomedâze keankâ mâkâ João Batista âewyly. Aguely mâindadyseba olâ keankâ âmaemo. Akaemo kurâdo izepa matomo keankâ toenzepa João aguely idani. Akaemo impostu epywado emakewâni modo, pekodo inakanhe aini modo warâ nâjityendâmo inakanhe adâitomobyry wâgâ, adâidyly nimomo warâ. Akaemo aidyly mâentuomolâ, mâjityendylymo, inakanhe amidylymo mâinmolymo mipyra olâ keankâ âmaemo. Deus ize ato ara amitaymba âmaemo. Awylygue ise Deus pymâem atoram mydâpa mawylymo. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ilâpyryem Jesus tonlo modoram aguely: — Idataungâ wao xirâ unâ. Tâlâ myani uguondo uva etâdybybeom. Aituo uva ejidy nhahodânehonly tuhu imâsedo modogue. Onwâgâ tâtagueim nhesaguehonly, uva ekuguehoem tâjihurugue, vinhu xygatoem. Âtâ imeimbyry kaynâ olâ-ro waunlo aienehonwânmy tâmagazeim enuagaendo, ânguydo imeom nady saguwâni modo enuagaendo warâ. Ilâpyryem myani uva ejidy etaynrim modope nhedyly. Warâ myani eyanmo aguely: “Ypi mâendylymo-ro watay, uva xutuduo, epajigâze urâ agâmo” kely. Koendâ lelâ myani in-hogulymo. Aituo myani idânârâ âtunâguedybyem, âtâ anary iwaguenonra idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva ekaunâdo odaji ituo myani tâmary modo ingonodyly, akaemo tâwaneim modoram nhekaunâdybymo ewy turâ emakeze. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Aituo myani ingonotyby modo idâlymo âpa ezaji. Saintuomo, tâzenagazeozemo myani uva ejidy etaynrim modoram. Adapioguolymo, âdyolymo, tuhugue tadamytâoze âdyolymo warâ myani aieholymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aituo myani uva sodo eagonro tâmary modo ingonotondyly wâne, turâ emakeze. Adyetonzemo lelâ olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","— Ilâpyryem myani uva sodo tymery ingonodyly. “Ymery tokaleom awylygue âda nientaymbamo ise” tâkeduo myani ingonodyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sodo imery saindyly tientuo myani âpa ezay tâwanuneim modo âjigue aguelymo: “Uva ejidy sodo imery mâkâ âeni. Tunwym igueduo, mâkâ ise ipibyry sodo. Kydyânrene, nhunwym ipibyry kurâenlâ itoem” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","— Aituo myani mâkâ uva sodo imery nhawâdylymo. Sawânipyryem, âpa ezayba nhedylymo, tyân-hoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aituo Jesus adâkely idani modo nhapâiguewâdyly: — Uva ejidy sodo odopâdyly watay, ise-ro? Âdaiehoze akaemo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aituo in-hogulymo: — Todopâduo, tumunruneim modo xyâen-honze mâkâ. Eagonro modo ise mârâ uva ejidy eniem nhekyly-ro warâ. Ipi eni iwelo modoma tienkaunâduo, sodo xurâ xuduze — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aituo Jesus eyanmo aguely: — Deus itaumbyry awo wâgâ iweniby mâintaimbymo enanâguewâdaungâ. “Tâlâ myani tuhu imeâgâkeba, âtâ itâdo. Idânârâ itâdaynrim modo mârâ tuhu tâensemo, mârâgue âtâ tintâdyzebamo olâ. Deus xurâem olâ mârâ tuhu tywyneim kuru! Kywymâry Deus induakeyby mârâ tuhu, âtâ itâdoem. Deus anhetyby awylygue iwâkuruem awyly!” warâ iwenibyem awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","— Yizepa matomobyry enanâguewâdaungâ. Awylygue judeu keba modoram ise âdara Deus kywymâryem idyly awyly egatuly. Yeinwânsemo-ro warâ. Akaemo iwymâryem ise Deus, âwymârymoemba. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ânguylâ mârâ tuhu onwa ihugueyby, âdyâze. Ânguy onwalâ mârâ tuhu ihugueduo, samiunze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aituo ani akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, fariseu domodo warâ Jesus unâ nhegatuyby indadylymo. Tywâgâ aguely awyly nhutulymo myani, Jesus izetonro keba tawylygue, tâwanuneim modo âpa ezary sodo imery izepa atomobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Awylygue Jesus tientadânehondyze idylymo, tyâen-hon-hoem. Âjigue aguelymo: — Iweâ lelâlâ kianwânehonly watay, kurâdo kagâ iewiâpaze Xurâmoem, koendonro lelâlâ awâkâ Jesus, Deus eynynâ aguenri awâkâ — kelymo. Awylygue Jesus âdara niepyra awylymo ilâenlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus âkelo unâ nhegatuly, tienomedâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Warâ aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tâlâ myani pymâ tynrenseim, tumuru ohogüin-hoem âty imâsedo aieni. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Toenzepa myani kurâdo tâtyram âwinduase idâhoem ingâsedyby modo. Alâ ituo myani tâmary modo ingonodyly aguewâtobyry modo igâseze, âwinduase idâhomoem. Akaemo olâ myani tâtâdyzeba. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ine warâ myani tâmary eagonro modo ingonodyly. Warâ myani aguely eyanmo: “ ‘ “Alâ pyni nâwanikeagui. Tapirâ tadygueim modo nâdyoaki, nâjihuoagui warâ. Alâ idânârâ. Yagâ âzetyguedaungârâ” keanry xina iwymâry’ kewâtaunda kâingâsedaymby modoram” kely âty sodo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","— Aituo myani emary modo idâondyly igâsedonzemo. Todohogüin-ho etyryam tâtâdyzeba olâ myani akaemo. Âsewanize lelâ myani idânârâ idâlymo. Tâlâ myani tyfazendaryanlâ âsewanize idâim, tylojaryanlâ âsewanize idâim warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tâlâ lâpylâ olâ myani tygâseze idâypy modo sawâni, sapiogurim, xyârim warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Âty sodo tâmary modo enagazenibyry modo agâ iewiâpadyly myani. Aituo myani tyzodadury modoram aguely: “Iemary modo xyârimpyry modo xyâwâtaunda. Ijidadârymo iaduântaunda warâ” kely. Tywymâry aguehobyry ara myani sodadu domodo aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ilâpyryem warâ myani aguely tâmary modoram: “Alâ wâne todohogüin-ho etyry. Kâingâsedaymby modo olâ enra yagâ tâzetyguedyzeba. Awylygue ise kâingâsedombyramo wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Idâwâtaungâ arua oze. Idânârâ monhontybymolâ ise mâingâseguylymo âtynra âetomoem” kely myani âty sodo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","— Aituo myani emarydo arua oze idâlymo. Idânârâ kurâdo tiontyby ara nhadylymo âtynra. Kurâ domodo inakanhe aitânry modo, inakanhe aini modo alelâ myani nhakylymo. Saintybyem, âtâ tâjiwogonro iwâkuru tâduduoze myani eyanmo. Âty sodo ety tumyze myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Inepa kehoem myani âty sodo egawândyly, saintyby modo edaenkuze. Akaemo duay tâlâ olâ myani uguondo âtâ iwâkurugueba kulâ âzetydâni, igâsedyby modo âtâ odaji egawântoem xuduypygueba kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aituo myani âty sodo mâkâ uguondo nhapâiguely: “Âdaituoka kâingâsedaymby modoram kâunduypy âtâguepa âzetydâdybyem mawyly?” kely eyam. Mâkâ olâ myani nihoguba. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aituo myani âty sodo aguely tâmary modoram: “Etaungâ awâkâ uguondo; kâingâsedyby modoram kâunduypy âtâguepa kulâ âzetydâdyly. Tarâpa tâise awâkâ. Emakâjiwâdaungâ. Ihugâjiwâdaungâ. Iamu odaji samewâdaungâ warâ. Myarâ samewâdyby modo âsenagazedoram, ohogüendomoram, tyery nhaguhomoram warâ” kely myani âty sodo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Arâ lâpylâ wâne, idânârâ kurâdo igâsedyly Deusgue iwymâgoem. Aguipa kulâ olâ yeinwânni modo. Awylygue ise aguipa kulâ lâpylâ Deus eydâ atoram idânri modo awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesus aguely tindatuo myani fariseu domodo âxiguely âtunâgueze, Jesus tienwentâdomoem. Warâ aguelymo: — Moisés inweniby wâgâpa kulâ aguehoem aguyjiene — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Âtunâguedybyem tynynonro modo ewy, Herodes eynynonro modo ewy warâ Jesus agâ agueze ingonodylymo. Saintybyem, ingonotaymby modo Jesusram aguelymo: — Pymâ, konokuni keba mawyly, tutuze xina. Deus ize ato wâgâ âkealâ xina mâenomedâdyly. Iozeno lelâ amygueho, ânguy izepa awyly umelâ. Pymâdo tynrenseim modo ize ato amânhetoem kulâ amygueho mâungukewâbyra âmâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Awylygue âdara impostu epywadyly wâgâ mâuntuly wao xinaram aguekâ. Moisés inweniby ara, koendâ pymâ Roma donro César-ram impostu ebyry epywadyly? Koendâpa? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","César tiunâguedoem kulâ tapâiguelymo awyly xuturimbyryem olâ myani Jesus. Aituo aguely: — Koendonro emyenro wâne âmaemo, koendonro keba olâ âmaemo. Inra esagueyby odaji wâne ânguylâ ihuguely myara wâne ienokudyze mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moeda enetaungâ, pymâ Roma donro xurâem kiempywado — kely. Agueduo moeda nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Emaxi nhudulymo. Jesusram adapâigueolymo: — Ânguy emydy ekudoka xirâ wogonro? Ânguy ezedy iwâgâ iweniby warâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aituo in-hogulymo: — Roma donro kywymâry César ezedy, emydy warâ — kelymo. Jesus aguely: — César xurâ, Cesaranlâ xuduwâtaungâ. Deus xurâ, Deusranlâ xuduwâtaungâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesus aguely tindatuo âseguâdâdylymo. Napâigueombyra idylymo. Aituo idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mârâ iguandyly wâgâlâ saduceu domodo ewy Jesus agâ âtunâgueze idâlymo. Iguewâtyby modo kurâem itondyly einwânni keba myani akaemo. Jesus iopaji saindylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Aguelymo: — Idakâ, Pymâ. Moisés ezewenry tutuzelâ âmâ, iweâpa kydamudoem inweniby: “Uguondo tywydy namypalâ iguely-ro watay, iukonobyrylâ nohogüim iwydypyry agâ, imezeândoem. Aituo iamudo iazeypy, igueypy imeryenlâ âdutuoly” kelype. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Xina olâ ise warâ nhegatuly. Tâlâ myakâwâm sete uguondo modo âjiwaigoruem, âjiukonoem waunlo. Iwaigoru ohogüinly myakâwâm. Tywydy namypalâ iguely. Iukonobyrylâ myakâwâm ohogüinrim pypâ agâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mâkâ lâpylâ myakâwâm tywaigoru iwydypyry namypalâ iguely. Azagâ tokalâ ietomo iukono ohogüinly myakâwâm pypâ agâ. Mâkâ lâpylâ iguewâm, tywaigoru iwydypyry namypalâ. Tywaigoru iwydypyry namypalâ lâpylâ myakâwâm quatro ietomo, cinco ietomo, seis ietomo, sete ietomo warâ iguewâdylymo. Sete uguondo lelâ myakâwâm mâkâ pekodo agâ ohogüimby. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Idânârâ mâkâ uguondo modo iguewâpygueduo myakâwâm, mâkâ pekodo iguely lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","— Xirâ xina apâiguedyze ato. Âkealâ kuru igueypy kurâem itondyly watay, âdaunlo uguondo akaemo sete ewy iwydyenka ise mâkâ, kurâem itonduomo? Idânârâ akaemo sete lelâ iwydyem ityby mawânkâ! — kelymo. Âdalâ kulâ in-hoguly tientomoem kulâ olâ ara aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aituo Jesus in-hoguly: — Iozepa kulâ âunâgumo! Mâuntuwâbyra âmaemo Deus itaumbyry awo wâgâ iweniby. Âdydo imeom aiese Deus ton-honre awyly, mâuntuba gâlâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iguewâtyby modo kurâem itonze lelâlâ, nigueompyra tâitomoem. Anju domodo nohogüinwâbyra. Alâpylâ iguewâtyby modo, kurâem itonduo, nohogüin-ondaymbamo ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Iozeno kuru iguewâtyby modo kurâem itonze kely mâintaimbaka minasemo? Enanâguewâdaungâ Deus Moisésram aguehobyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Deus aguewânmy: “Deus urâ, Abraão, Isaque, Jacó warâ iDeusry; tarâlâ asaemo yagâlâ” kewândymy. Kurâdo enanaji olâ, Deus einwânni iguewâtyby modo, iguewâtybyem lelâlâ. Deus xurâem olâ akaemo igueypyemba, târâlâ akaemo Deus eydâ atodâ. Arâ aguehobyry wâgâ Deus einwântaynrim modo nigueompyra awyly kiuntuly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesus aguely tindatuo toenzeim keba gâlâ kurâdo âsewânily, arâ kurâdo nhenomedâduo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Saduceu domodo nhewentâguylyemba kehoem Jesus aguely, kely tindatuo myani fariseu domodo âtâdyguylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Moisés inweniby wâgâ enomedânibe myani akaemo ewy. Inakanhe kulâ Jesus aguedyse wâne myani. Awylygue Jesusram aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","— Toenzepa Moisés kâzewenryem inweniby modo. Âdaunloka koendonro kuru? Âdaunloka awârâ modo takazeno kuru? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus in-hoguly: — “Kywymâry Deus iwynedaungâ âdydo imeom, kurâ domodo warâ mâinwynedomo takaze kehoem. Idânârâ ize matomo, Deus ize ato ara lelâ nidâ. Idânârâ angahumo oday âunâgomo Deus ize ato lelâ nidâ warâ.” ");
INSERT INTO bkqNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Xirâ aguely mawânrâ tâzezewenry takazeno kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Eagonro tâzezewenry koendonro lâpylâ xirâ: “Agonromo agâ âpynedaungâ; koendâ mâzetomo ara, arâ lâpylâ agonrodo agâ koendâ âzetaungâ” kewândy Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Arâ aini kydatay, idânârâ Moisés inweniby aralâ aguidyly, Deus itaumbyry egatuwâni modo inweniby aralâ warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Târâ fariseu domodo âtâdyguybyem atay, Jesusram adapâigueolymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","— Âmaemoem, ânguyka Messias, inanajimo? Ânguy iwerypyry? — kely. Aituo in-hogulymo: — Davi iwerypyry ise Messias. Davi pymâem atobyry ara ise mâkâ tarâ onro anaym pymâem awyly — kelymo. Aituo Jesus eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","— Iozepa kulâ amyguelymo. Tutuzelâ myakâwândy Davi, âdaunlolâ kurâ takaze kehoem ton-honreim Messias awyly. Awylygue “Ywymâry” kewândy Davi Messiasram, niazepa awyly umelâ. Deus Ispiriturylâ mawânkâ eyam xutuen-hoim. Tutuzelâ âmaemo Davi inweniby: ");
INSERT INTO bkqNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Deus aguely myakâwâm Ywymâryram: ‘Yahoru eynynâ ikagâ tynrenseim ekadodâ, âduery modo eon-honru kainly ara, âdydo ara kulâ âhuru iaxi kânhedylymo ara’ kely Deus” kely myakâwândy Davi inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","— Davilâ Messias tywymâryem awyly wâgâ aguewândymy. Awylygue kiuntuly âdaunlo kulâ uguondo keba awyly. Messias tynrenseim kuru awyly xutuwâdaungâ, Davi takaze — kely Jesus eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesus aguely tindatuo ânguy adâkedyzeba idyly, âkealâ aguely awylygue. Ilâpyryenlâ, ton-honremba idylymo, sapâigueze. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ilâpyryem Jesus xinaram, kurâ domodoram warâ aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ koendâ tutuzemo Moisés inweniby. Awârâlâ akaemo ewanu, Moisés inweniby wâgâ enomedâdylylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Awylygue aguedaymo, koendâ aguelymo idataungâ, idânârâ aguehomobyry ara aitaungâ warâ. Earamo adâiseba olâ itaungâ. Koendâ lelâlâ wâne nhenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Aiekâ” tâkehomobyry ara anipyramo lâpylâ olâ. Tâjienwyeno tâmânreim sanâdyly tâmaenzeba ato ara awârâ nhenomedâdomo, tâmaenzein-emba awyly. Akaemolâ nemaembamo, ânguy tienmawyadâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tâzehogueoly kulâ ize atomo. Tâjituby wâgâ Deus itaumbyry inwenilymo watay imeâgâemba kehoem tâjituby tywendy wâgâ, tâwâry wâgâ warâ nhekâjilymo. Etaungâ etymo. Tâty tywogonro wâgâ imâem kehoem panu ihomigadyby nhekâjien-honlymo, tynrentomoem kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Âtâ tâdâtâdyguyho odaji tâtâduomo, tâgareim ekado wâgâ ekadylymo, arâ lâpylâ âty mododâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Âdykâlâ kurâdo âtâdyguyho einkâ takaduomo, mâkâ modo tâdaenkudyzemo, tynrendysemo warâ inanry. “Konomedâni” kelygue lelâ tâzekedyze awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","— Urâ lelâ inomedânimo kuru. Awylygue “Ienomedâni” myguehondyze tâiseba itaungâ. Agonromo takazeno mâkeba âmaemo; idânârâ âzekiba âmaemo, âjiukono, âjiwaigoru waunlo ara lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tunwyune lelâlâ wâne âmaemo, tarâ onro wâgâ. Deus kaynonro olâ unwânmo kuru âugunimopyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nhenimope lelâlâ wâne âmaemo, “Pymâ” myguehomo. Deus kaynonro olâ âwymârymo kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Âduaymo tynrenseimbe-ro watay, imawyadâdâmo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Koendonroem tawyly wâgâ aguewâni modo, tynrempa âiehoze. Koendonroem tawyly wâgâ aguedânry modo olâ, âdyren-honze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aituo Jesus aguely, Moisés inweniby wâgâ enomedâni modoram, fariseu domodoram warâ: — Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendâ lelâ aini emyenro wâne âmaemo, koendonro aieni keba olâ âmaemo. Deus kaynonro âwymârymoem awyseba âmaemo; kurâ domodo iwymâryem idyseba warâ. Pyanta kadiadugue enahuimbyryem xave soeni emyenro âmaemo, igawâmpyra mitomoem, tâgawândysedo modo mâenkaunânehomba mitomoem lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro ara wâne amyguelymo, koendonro aieni keba olâ âmaemo. Pekodo pypâ modoram amyguelymo inanry: “Xinalâ ise âsejiguymo eni; tusonebama âmaemo” myguelymo. Isejiguymo âmaemoem mânhetomoem kulâ olâ mâenokudylymo. Deus agâ amyguedaymo, imeâgâemba kehoem amyguelymo, koendâ igaromoem kulâ. Awylygue ise Deus inagazedylymo, eagonro modo takaze kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro emyenro wâne âmaemo, koendonro keba aieni olâ âmaemo. Taypa kehoem wâne mydâlymo, kâmayno einkâ kehoem akadylymo warâ wâne mâinwânkylymogue kurâdo enomedâze. Arâ amidylymo, aguipa kurâdo mâenomedâdomo tyeinwântoem, saguho tâzezewenry inmoly umelâ. Mâenomedâdomo einwânni modo inakanhe kehoem adâisemo-ro warâ, amânhekylymo takaze kehoem. Agâmolâ ise idâlymo peto nhântânry onwanji. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","— Âmaemo Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ toenzepa âsenagazeze âmaemo! Epy eagonro epy sakobâni ara kulâ âmaemo. Inanajimo, Deus ety oday ourugue xygatyby modo tywyneim kuru, Deus ety takaze. “ ‘Tâwâlâ ise Deus ety adakalaguely, auguehobyry agânhepyra urâ watay’ myguelymo-ro watay, tâwâlâ ‘Aiese urâ’ myguehobyry amânhepyra mawylymo. ‘Tâwâlâ ise Deus ety odano ourugue xygatyby modo âjimatywâdyly, auguehobyry agânhepyra urâ watay’ myguelymo-ro watay olâ, ‘Aiese urâ’ myguehobyry aietaungâ” warâ inanry mâenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Âindonro âmaemo. Epy emyenro âmaemo! Deus ety tywyneim kuru, iodano modo takaze. Mârâ ioday awylygue kulâ awârâ modo iwynu. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Inanajimo, awârâ Deusram xuduypy tywyneim kuru, mesa Deusram xuduypy ekanâdo, altar takaze. “ ‘Tâwâlâ ise altar inakanhe idyly, auguehobyry agânhepyra urâ-ro watay’ myguelymo-ro watay, tâwâlâ ‘Aiese urâ’ myguehobyry amânhepyra mawylymo. ‘Tâwâlâ ise Deusram kâunduypy inakanhe idyly, auguehobyry agânhepyra urâ-ro watay’ myguelymo-ro watay olâ, ‘Aiese urâ’ myguehobyry aietaungâ” warâ mâenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Epy emyenro âmaemo! Deusram mâengamelymo âdy mâkeba mâkâ xurâem, ety odano mesa onwa mâenkanâdylymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Awylygue altar iwogonro tynrense kurâ watay, altar, iwogonro modo alelâ kiynrenkyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Deus, ety alelâ tywyneim. Deus ety tynrense kurâ-ro watay, alâpylâ Deus kiynrendyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Deus eydâ ato wâgâ aguykely watay, Deus wâgâ lâpylâ aguykely, mâkâlâ mawânkâ pymâ ton-honreim awâtârâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro emyenro kehoem âmaemo, koendonro aieni keba olâ. Dez âsejiguymo ewy, tokalâ inanry mâundulymo Deusram, Moisés inweniby agueho ara. Âpa ezano pyni ekubâzeândo ewy warâ inanry Deusram mâundulymo, hortelã, erva-doce, cominho, awârâ modo. Âdainkâba awârâ modo mâundulymo Deusram. Deus xurâem tywyneim kuru amânhepyra olâ minasemo. Âdypebaom, kaikânro modo warâ mâintyendaymba minasemo. Ioze lelâ amipyra, Deus mâinwâmpyra âmaemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Epy eagonro epy sakobâni emyenro âmaemo. Toenzepa kuru Moisés inweniby modo wâgâ kulâ mâtynanâdylymo; mârâ tywyneim kuru pylâ amânhepyra âmaemo-ro. Okumo ikano mazagâ mainguelymo, camelu pylâ monwonlymo-ro myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro emyenro âmaemo, koendonro aieni keba olâ âmaemo. Moisés inweniby ara amidyse mawylymo umelâ, inakanhe kulâ adâiselâ âmaemo tyewiâpazelâ warâ. Tâdâjitoguyly tâkeze minasemo, ize matomo mâenmakehomoem. Tâlâ wâne kopu, prato warâ ikaynâ lelâ nhagokely, ioday pylâ nagokeba waunlo emyenro âmaemo. Deus ize ato ara adâjidyly mâuntuba olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Epy ara kulâ âmaemo, fariseu domodo. Deus ize ato ara lelâ aitaungâ. Aituomoma ise Deus tywykeba nhedylymo. Kopu koendâ sagokeyby ara ise âmaemo, kuoho, odaymo alelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","— Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro emyenro âmaemo, koendonro aieni keba olâ âmaemo. Igueypy etadâdo emyenro âmaemo! Kuoho tywâkure kehoem tapekeingue iwâkudâdybyem awylygue, iodano olâ tâjibyry, tywângueim myara âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Koendonroem mawyse mawylymo kulâ, koendonro mâkeba âmaemo, angahumo oday âunârymo inakanhe lelâlâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jesus aguely: — Âmaemo Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ, toenzepa âsenagazeze âmaemo! Koendonro emyenro âmaemo, aunlo keba olâ âmaemo. Deus itaumbyry egatuwânibyry modo eguepybyry etadâdobyry nhangatay tuhu iwâkuru kehoem ekanâni âmaemo. Torre iwâkuru kehoem aieni âmaemo, koendonro modo iguewâtyby enanâgueho. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Amyguelymo: “Tâlâ kurâ mârâ ume-ro watay, Deus emary modo kyânwâpyra tâise kurâ; kydamudo ara aguitaymba tâise kurâ” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","— Inakanhe mawylymo soense myguelymo wâgâlâ âdamudomo Deus emary modo xyârimpyry aralâ ânguydoem mawylymo mâenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Alâ ise amidylymo âdamudomo aitobyry aralâ. Âmaemo ise akaemo aitobyry takaze kuru inakanhe aini. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Âgâu tyewiâseim emyenro âmaemo! Âgâu poji iaduly ume âsemagueze kewâni emyenro kulâ âmaemo! “Âsemagueze kurâ” myguelymo wâne. Peto nhântânry onwanji idâze lelâlâ olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","— Urâlâ ise ywâgâ aguenri âyanmo igononi. Aguelymo, mâinwantaguedyzeba olâ ise âmaemo. Akaemo ewy xyâze âmaemo. Akaemo ewy kruz onwa sakâjize âmaemo. Eagonro modo sapioguze âmaemo âtâ tâdâtâdyguyhodâ. Tâinkâ lelâba ise mâwinlymo, mâenagazedomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Âdamudomo kurâdo koendonro modo nhâhobyry wâgâ âmaemo ise tânagazezeim. Abel, Adão imery, âdaityby mâkeba myakâwândy saguhoem âdyoim. Alâ myakâwândy toenzepa âdaitânry modo âdyozesedyly. Xypyryem xyâypy myakâwândy Zacarias, Baraquias imery, âdyoly Deus etydâ. Mesa Deusram xuduypy ekanâdo, Âji Tynrenseim Kuru warâ ontay myakâwândy âdyoly. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Idânârâ âdamudomo aitobyry modo wâgâ âmaemo xirâ umeno modo ise tânagazezeim. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ilâpygueduo Jesus aguely Jerusalém donro modo wâgâ, eydâmolâ waunlo ara lelâ: — Âmaemo, Jerusalém donro modoram xirâ auguely. Iweâparoem, âjidadârymo donro modo Deus itaumbyry egatuwânibyry modo xyâwânmomy. Agui Deus ingonotaymby modo tuhugue tyâzemo myakâwâm. Arâlâ olâ toenzepa âwynedylymo. Aukuma wâne tymeombyry tawâry iaxi tydâtyguyze, tuan-hun-hoem, myarâ idânârâ nhedysemo wawyly. Agui olâ keankâ âmaemo ewy yizepaom modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Deus odokezemo. Saguhoem wâne ani koendâ agâmo myarapa ise Deus. Âtâ sodokeyby ara ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ietondaymba ise âmaemo, “Koendonro lelâlâ âmâ, Deus Ingonotyby” yam myguelymo ara. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus xina agâlâ âxiguely Deus ety idaserayba. Tâtâday, Jesus iopaji idâypyem, xina aguely ani: — Egâ xirâ Deus ety! Iwâkuru kehoem xirâ! — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aituo Jesus aguely: — Arâ wâne awârâ Deus ety imâsedo mâendylymo. Adainhoze olâ awârâ. Idânârâ adakalagueoze. Angato inkâba ise awârâ tuhu modo; ihuguewâze awârâ onro onwa — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ilâpyryem xina idâly iwyram, Se Oliveira Ekaram. Târâ Jesus ekadyly. Iopaji idâypyem xina nhapâiguely: — Âdara kaise xypyry iwaguepa idyly, xina nhutuly? Âdy kaise inepa modopâdo odaxi itybyem awyly xina nhutuho? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus in-hoguly: — Inanaynmolâ itaungâ, kodopâdo wâgâ ânguy inokubyramo itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Xypyry etaji idyly ume, toenzepa ise “Messias urâ, Deus Ingonotyby” kewâni modo. Toenzepa ise agueduomo âsenogudaynrim modo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tâinkâ lelâba âseguebylymo, âdyâwâdylymo warâ kely idase âmaemo. Tadahulizeba olâ itaungâ, awârâ modo egary mâindatuomo. Aise awârâ modo, âdypydâdo keba olâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Âkelo anano modo âdyâwâsemo; âjitanwebaom modo âdyâwâsemo warâ. Tâinkâ lelâba ise onro âzekânily. Âtâ anakâ pyni peba ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tâdâsenagazedyly imâem isezedyly, pekodo âsenagazedyly xigâlegueam tymery iazehoem ewânugue myara. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","— Yizepaom modo awâsemo, yeinwândylymogue, asemo pymâ modo enado. Toenzepa inagazenehonzemo, âehonzemo warâ. Ynynonroem mawylymogue, toenzepa ise mâjiewiâseolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mârâ ume, toenzepa ise yeinwândyly imowâni modo, nâzenagazeoba tâitoem. Yeinwândyly imowânibyry modo, yeinwânni modo iewiâseze. Pymâ domodo enagazenehonzemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kurâdo enokuni modope ise. Warâ ise aguelymo: “Deus wâgâ aguenri xina” kezemo. Kewâdylymo kulâ olâ ise. Toenzepa kurâdo enokuzemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tâinkâ lelâba ise inakai modo awyly. Awylygue ise ânguy tagonrodo niwynebyra awyly. Peto wâneam tyântoem âdiempa tâise, myara ise kurâdo âpynedyly adainly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Idânârâ awârâ emaenwânibyry modo olâ âsemagueze. Aunloenlâ ise Deus agâ awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tâinkâ lelâba ise unâ iwâkuru sani idâly. Deusgue tywymâgu wâgâ aguelymo ise. Xirâ modopygueduo ise kodopâdyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesus aguely: — Âepanâgueze Deus izepaom kuru, mâkâ inakai kuru. Jerusalémdâ ise âepanâguely, Deus ety oday, Deus unâry egatuim Daniel iwâgâ aguehobyry. (Xirâ itainwâni modo xutuze, âdara keze aguely awyly.) ");
INSERT INTO bkqNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mâkâ inakai Jerusalémram saintuo, âmaemo Judéia donro modo iwyram âwientaungâ, otoenze. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Inepa kehoem âwientaungâ. Itymo inatay âmaemo watay, tâwânseba itaungâ itymo odaji, âdylâ ese. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Âpa ezay âsewanize mataymo, inepa âwientaungâ. Itymo mâungukehomo ese todopâzeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toenzepa âsenagazeze pekodo modo ioday tymegueim, tuhuazeim modo warâ. Tahule âwienniembamo mawânkâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Deusram ekadaungâ, kopâ umepa, tâzekobyzegueho odaypa warâ, xirâ tâdâsenagazedo saindyly itoem, inepa tâdâwientoem nudupa ise. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","— Ton-honre ise awârâ tâdâsenagazedyly saindyly. Deus onro nhugutobyryenlâ arâ kehoem tâdâsenagazedyly peba awyly. Anitombyra ise-ro warâ xirâ emyenro kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Deus olâ mârâ tâdâsenagazedo epagunâze, aisezedyly lelâ waypa itoem. Aypa watay, ânguy nemaenwâbyra tâise; idânârâ tadainze. Tynynonroem tinduakeyby modo wâgâ olâ Deus anhedyly ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","— Kodopâdo xutuze âmaemo, ânguy âdakepalâ. Awylygue, “Anra merâ Messias” kely mâindatuomo, kâzeinwântaundâ. “Awâtârâlâ awâkâ Messias” kely mâindatuomo, kâzeinwântaundâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mârâ ume toenzepa ise konokuni modo. “Deus Ingonotyby urâ” kezemo, kurâdo enokuze. “Deus keankâ ugononi, xunârybyry egatuze” kewâni modope lâpylâ ise, kurâdo enokuze. Adyesenry modo kehoem aiesemo, kurâ domodo iomazeâni aiesemo lâpylâ warâ. Idânârâ enokuze kezemo; Deus induakewâdyby modo enokuze kezemo lâpylâ, akaemo olâ ise nâzenokuoba. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","— Inanaynmolâ itaungâ. Âurudylymo olâ waunroenlâ, mârâ ume mâzenokuoba mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ânguylâ, “Egâ. Messias naintai. Poji anaym mâkâ” kely-ro watay, kâzeinwântaundâ. Uize tâtâzeba itaungâ, kodopâdaymba ise urâ ilâem. “Messias naintai. Âtâ oday notoendai” kely-ro watay, kâzeinwântaundâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Idânârâ kodopâdyly esemo. Ielu wâne kau wâgâ, âzehoruguely xixi egaseho eynynâ, egawânto eynynâ warâ idânârâ nhetomoem, myara ise kodopâduo, idânârâ yaindyly nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tywângueimpe atoram elaho modo âtâdyguyly, ânguy “Târâ igueypy” keduo inkâba. Arâ lâpylâ ise kurâdoram kodopâdyly âdutuoly, ânguy âdakepalâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesus aguely: — Mârâ tâdâsenagazedyly sakabygueduo, xixi, nunâ warâ tohoreba ise. Ximukâ modo kau wâgâpa ihuguewâze. Kaynâ tyngataymby modo ihugueânze Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ilâem ise kau oday âepanâguely urâ Uguondo Kaynâpa Âetyby kodopâdyly xutuho. Idânârâ ynynâbaom modo mârâ tientuo, âseanezemo. Eunu duay ytâguyly esemo. Pymâem kuru wawylygue, toenzepa won-honru enehonze. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Târâ kaynâ trombeta idyen-honze urâ. Anju domodo igonose urâ, idânârâ âtâ anakâ Deus iduakeyby modo idâtyguyze, xixi egaseho eynynâ, egawânto eynynâ, norte eynynâ, sul eynynâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesus aguely: — Inepa kodopâdyly awyly xutuhobe ise, iwaguepa kopâ ihugueho awyly xutuho ara. Etaungâ figueira. Iwatary modo ikuandaynly, sary ilusewâdyly warâ watay, tutuze âmaemo kopâ ume idyly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Myara lâpylâ ise xirâ auguehobyry modo aidyly adaguly mâentuomo, kodopâdo iwaguepa awyly mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aise xirâ âdydo imeom, idânârâ xirâ onro anano modo iguelymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kau, onro warâ adainze. Auguehobyry olâ ise nadaimpa, nâtugugueba warâ; aunloenlâ ise. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesus aguely: — Kunwym Deus kulelâ xuturim kuru âdara kodopâdyly awyly, kopae atay, peto oday atay warâ. Ânguy xirâ anano nutuwâbyra. Anju domodo nutuwâbyra. Urâ Deus imerylâ kâuntuwâbyra urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé umenobyry ara, arâ lâpylâ ise urâ Uguondo Kaynâpa Âetyby kodopâduo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Saguhoem, paru inwenlygue tadainlymo iray, kurâdo xara tatomo aralâ mykâinane. Âwinduadylymo. Adakuilymo. Salokuzenomo modo, âwynsaundo modo warâ ohogüinlymo warâ myakâwândy aidylymo, Noé pepi imâsedo âtâ emyenro tyngatyby odaji âxiedyly iray. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Inepa iguein-em tawyly nutuwâbyramo myakâwândy. Deus olâ myakâwândy toenzepa kehoem kopâ tugonose idânârâ adain-homoem, myara lâpylâ ise agui kurâ domodo kodopâdyly nenuembyra awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","— Kodopâduo, ynynonro modo sase urâ. Ynynâbaom modo olâ ise urâ kampyra. Ynynonro modo, ynynâbaom modo agâ on-hoan-ro watay, ynynonro modo lelâ ise taseim Deus eydâ atoam. Azagâ uguondo âpa ezay tâwaneim, ynynonro, ynynâbaom warâ watay, ynynonro adahoze Deusram, eagonro olâ âjionze. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Azagâ pekodo trigu sakoim, ynynonro, ynynâbaom warâ watay, ynynonro adahoze Deusram, eagonro olâ âjionze. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ywânwântâlâ itaungâ. Mâuntuwâbyra âmaemo, âdara urâ Uguondo Kaynâpa Âetyby kodopâdyly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Âdara tâmagazeim saindyly awyly nutuwâbyra âtâ sodo. Tutuze-ro watay, tânanaynlâ tâise, tysejiguy tienmakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kodopâdyly tânuenzelâ itaungâ; inanaynmolâ lâpylâ itaungâ warâ. Ienuendylymo ume inkâba ise urâ Uguondo Kaynâpa Âetyby kodopâdyly. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesus aguely: — Unâ segatuji wao, âdara kodopâdyly awyly mâuntuhomoem. Fazenda sodo taypa tâtâly iraynâ, tagâ tâwaneim tonomegueim, koendonroram watâkeze: “Udâly wao ise. Âmâ ise iety, ysejiguy, yagâ tâwanuneim modo warâ eni. Kopaelâgâembaba ise akaemo mâwandyly. Âdy ize atomo âundugâ” tâkeze mâkâ eagâ ewano, tâtâday. Tâwaneim koendonro eagâ tâwano tânuenze myara ienuendaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Fazenda sodo aguehobyry ara aidyly-ro watay, koendâ ise iwymâry eagâ awyly, todopâduo. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tâmaryam aguely ise: “Koendonro lelâ âmâ. Koendâ lelâ tâwanuneim modo medâ. Awylygue idânârâ ysejiguy modo eniem ise âmâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Koendâ tâwaneim keba mâkâ watay olâ eagâ tâwano aguehobyry ara anipyra. “Tahule nodopâdaymba ise mâkâ sodo” kely tyangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Adâkeduo, koendâ tagonro modo nepyra. Tapioguzemo. Âtydâ kulâ warâ. Âwinduadyly, adakuily, toku ikaji kehoem idyly toku ikano modo agâ warâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mâkâ tâwaneim tynwânwândyly umepa iwymâry saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eagâ ewano mâkâ tâwaneim agâ tyewiâpaze, tâdâsenagazedoram talehoze-ro warâ, Deus einwântânry modo âsenagazedoram. Ohogüenze, tyery saguze warâ tâsenagazedylygue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesus aguely: — Unâ segatuji wao, âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Tâlâ myani kopae salokuzenomo ohogüin-ho etyry. Kuoho myani akaemo dez âwynsaundo modo mâkâ salokuzenomo enuenze. Lamparinague tâmatunemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Cinco lelâ myani akaemo âwynsaundo modo ewy tonomegueim. Tumyke myani tylamparinary nhadylymo, sapadondo warâ. Cinco âwynsaundo modo myani tonomegueim keba. Tumyke lelâ tylamparinary nhadylymo; sapadondo napyramo olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tahuleba idyly myani ohogüinrim. Aituo myani idânârâ âwynsaundo modo xuedunu iwynely, xykylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","— Kuetâji xuagueânimo adaenkely: “Etaungâ! Ohogüinrim saindyly! Iotaungârâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","— Aituo myani âwynsaundo modo xuaguewâdyly. Tylamparinary nhântybyem awyly nhedylymo, taseba awylygue. Aituo tonomegueim modo nhapadylymo, nhemanâdylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aituo myani akaemo âwynsaundo modo tonomeguenry aguely: “Âdiempa wao xina ilamparinary eoku âunduwâtaungâ. Xina ilamparinary nhâdyly olâ” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","— Tonomegueim modo olâ en-hem kepa. Aguelymo myani: “Sapadondo xina nhenetyby nuduwâpyra âmaemoem. Âlamparinarymo eoku anâtaunda” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","— Agueduomo myani akaemo tonomeguenry modo idâlymo tylamparinary eoku sanâse. Nodopâbyramolâ myani ohogüinrim saindyly. Akaemo tonomegueim modo myani ohondybyenlâ tawylygue, eagâlâ egawândylymo âtyam. Warâ myani pyanta âzenahuoly, xavepe âieholy warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","— Ilâpygueduo myani akaemo âwynsaundo modo tonomeguenry saindylymo. Ohogüinrinram adaenkelymo: “Yataen-ho! Yataen-ho! Xina egawântoem pyanta enahunguegâ” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","— Ohogüinrim eyanmo aguely: “Kâenahungueba ise aze. Tarâpa itaungâ. Yataen-ho mâkeba âmaemo” kely. Warâ myani âwynsaundo modo, tonomegueim, tonomeguenry warâ aidylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Warâ Jesus xinaram aguely: — Inanaynmolâ itaungâ! Mâuntuwâbyra ise âmaemo âdara kodopâdyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesus aguely: — Unâ segatuji wao âdara Deus kaynonro kywymâryem lelâlâ idyly awyly mâuntuhomoem. Uguondo tydinherugueim âkelo âtâ anaxi tâtâly iraynâ myani tagâ tâwanuneim modo ingâsedyly. Eyanmo aguely: “Koendâne ysejiguy etaungâ. Dinheru xirâ âyanmo kâunduly. Imâem ienehowâdaungâne xirâ âyanmo kâunduypy” kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aiedyly nhutulymo aralâ olâ myani nhuduly, imâem nhetomoem. Saguhoram quinhentas moedas ourugueto modo myani nhuduly, nhatanoram duzentas moedas, azagâ tokalâ ietomoram, cem moedas warâ. Aitybyem myani idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mâkâ quinhentas moedas lelâ emakerimbyry âdydo imeom nhanâdyly, tyanâtyby vende nhedyly warâ myani mârâ dinherugue. Alâ imâem nhenehonly; mil moedas lelâ idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mâkâ duzentas moedas emakerimbyry, alâpylâ myani âdydo imeom nhanâdyly, tyanâtyby vende nhedyly warâ mârâ dinherugue. Alâpylâ dinheru imâem nhenehonly; quatrocentas moedas nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mâkâ cem moedas emakerimbyry olâ myani anipyra. Tâtagueim tâsagueze, dinheru tâpyâze warâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","— Iweâpa itybyem myani mâkâ dinheru sodo odopâdyly. Saintybyem myani tokalâ, tokalâ warâ tâmary modo ingâsedyly, dinheru âdanhetybymo awyly tiuntuhoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Saguhoem kuru saini myani mâkâ quinhentas moedas emakerimbyry. Mil moedas myani nhuduly eagâ tâwanonra. Aituo myani aguely: “Pymâ, quinhentas moedas keankâ yam mâunduly. Âdydo imeom sanâdâ, kanâtyby vende xiedâ warâ, quinhentas moedas kânhetondoem. Anra, mil moedas lelâ âdinheruru” — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","— “Koendâlâ myze amidâ!” kely myani iwymâry. “Koendonro âmâ. ‘Aiekâ’ uguehobyry amiendâ. Koendâmy awârâ âdiempa dinheru kâunduypy mewani. Âdydo imeom manâdâ, manâtyby vende miedâ warâ. Aituo, imâemba kâunduypy imâem mânhenehon-hobyry wâgâ, imâem ise âmâem kâunduly. Yagâ âzetyguegârâ” kely myani iwymâry. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","— Ilâpyryem myani duzentas moedas emakerimbyry idâly. Aituo aguely: “Pymâ, duzentas moedas keankâ yam mâunduly. Âdydo imeom sanâdâ, kanâtyby vende xiedâ warâ âdinherurugue, duzentas moedas kânhetondoem. Anra xirâ quatrocentas moedas lelâ âdinheruru” — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","— “Koendâlâ myze amidâ!” kely myani iwymâry. “Koendonro âmâ. ‘Aiekâ’ uguehobyry amiendâ. Koendâmy awârâ âdiempa dinheru kâunduypy mewani. Âdydo imeom manâdâ, manâtyby vende miedâ warâ. Aituo, imâemba kâunduypy imâem mânhenehon-hobyry wâgâ, imâem ise âmâem kâunduly. Âekâ. Yagâ âzetyguegârâ” kely lâpylâ myani mâkânra. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","— Aituo myani mâkâ cem moedas emakerimbyry idâly, aguely: “Pymâ, ânguy ityeni keba mawyly, tutuze urâ. Mâsewanihobyrygueba âdype midyly. Xina âsewanirim, âmâ pylâ xina ewanopyrygue âdypeon-ro. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Âytadâ, awylygue âdinheruru ondaxi sepyâdâ. Egâ, anra tarâ dinheru mâunduypy” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","— Iwymâry eyam aguely myani: “Inakanhe tâwaneim, xynumi warâ myanze âmâ. Yam amyguely enra: ‘Mâsewanihobyrygueba âdype midyly. Xina âsewanirim, âmâ pylâ xina ewanopyrygue âdypeon-ro’ mygueanse. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ydinheruru imâem itoem âdy amânhedyseba matay, dinheru xynanâdaynrim modoram metadânehondyze banco odaji. Imâem ydinheruru tyenehonze tâise akaemo. Arâ tâise kodopâduo imâem kâenmakely” kely. Aituo iwymâry aguely eagonrodoram: ");
INSERT INTO bkqNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Merâ inakanhe tâwaneim emaymba moeda emakewâdaungâ. Mil moeda modopeonra xuduwâtaungâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Mâkâ toenzepa tâlânro, imâem emakeze, iwerâ tâlâ tato takaze. Mâkâ agui ipaom olâ, âzemakeoze iwerâ aguipa tâlâ ato. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iamu odaxi awâkâ tâwaneim inakai samewâdaungâ, toenzepa âsenagazedoem. Ohogüenze, tyery saguze warâ awâkâ târâ tâsenagazedylygue” kely myani iwymârymo tonlo modoram. Warâ myani akaemo azagâ tokalâ warâ tâwaneim aidylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus aguely xinaram: — Pymâem kuru wituo ise kodopâdyly. Anju domodo agâ ise kâewyly. Yaimpygueduo, pymâ tynreim ekado wâgâ ise iekadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tâinkâ lelâba ise anju domodo adakobâdyly kurâdo idâtyguyze. Kaneru eni wâne, kaneru modo âikânra tyese kabra modo duaypa myara ise ynynonro modo âikânra âedylymo, ynynonro keba modo duaypa. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yahoru eynynâ ise ynynonro modo kâenjitâdyly. Pâem eynynâ ise ynynâbaom modo kâenjitâdyly, tyguelâ itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aituo ise yahoru eynynonro modoram auguely: “Yagâ âetaungâ, Deus xurâem tywyneim âmaemo. Deus idânârâ nhugudyly iraynâlâ myakâwândy, âmaemoem koendonro nhekanâdyly. Deusgue tywymâgueim modo xurâ tâlâ mâkâ, mârâ koendonro lelâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Koendâ lelâ ise Deus agâmo, koendâ yagâ mawylymogue. Iewindy ume, uwamâmo. Yatuandyly ume, parugue yakuiwânmo. Itymo anakâ kadakobâdyly ume, itymodâ ykyânmâmo, utubamolâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iety ywogonro muduwânmo, tâtyemba wawyly ume. Iewânu ume, wonmâmo, Iewiânmâmo warâ, kua witoem. Kadeia oday watay, yam IU ise mydâwânmo, womazeânze” keze urâ ynynonro modoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","— Aituo ise koendonro modo yam aguely: “Pymâ, xina nutuwâbyra âdakeze amyguely awyly” kelymo ise. “Âdykâ tâty anaym xina nhetaymba ani. Inwindy ume xina âwapyra ani. Âdykâ xina akuiwâbyra, atuandyly ume. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Âykyândaymba lâpylâ warâ xina tâty oday. Tâtyemba mawyly ume, xina itydâdaymba ani. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Iwânu ume, ontaymba, iweântaymba warâ ani xina, kua mitoem. Kadeia oday matay, omazeânze xina nâtâwâbyra ani” kezemo yam. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Warâ ise auguely eyanmo: — “Ynynonro modoram pyni, paru, âtâ xykyhomo warâ muduwânmo. Ynynonro modo ewânumo ume, kadeia oday awylymo ume warâ, iomazeânze mydâwânmo. Ukono emyenro modo koendâ memâmo. Kaikânro modo, tâwâneim modo warâ koendâ mâendylymo-ro watay, urâlâ mâenkylymo” keze urâ yagonro modoram. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","— Warâ ise akaemo pâem eynynonro modoram auguely: “Ydâpa itaungâ, âmaemo Deus izepa ato modo. Inakanhe kehoem ise mâsenagazedylymo. Mârâ peto nhântânry Diabu ejidyem, eanjury kadopâ keho modo ejidyem warâ Deus anhetyby odaji idâze âmaemo. Âdara igasewâbyra ise âmaemo târâpa. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Koendâ inkâba ani iedylymo. Awylygue ise mâzenagazeolymo lâpylâ. Iewindy ume, uwapyra mataunaguynre. Yatuandyly ume, yakuiba mataunaguynre parugue. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Itymo anakâ kadakobâdyly ume, itymodâ ykyâmbyra mataunaguynre. Tâtyemba wawyly ume, iety ywogonro mâundupa mataunaguynre. Iewânu ume, wompyra, iewiâmpyra warâ mataunaguynre, kua witoem. Kadeia oday watay, yam IU ise mydâwâpyra mataunaguynre womazeânze” keze urâ ynynâbaom modoram. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","— Warâ ise yam aguelymo: “Âdykâ nhetaymba xina. Awylygue ani koendâ tawyly tienehon-hoem xina aniempyra awyly. Inwindy ume xina âwapyra; atuandyly ume, xina akuiba, âdykâ xina agâ mipyra mawylygue. Tâtyram âykyânze xina apyra; ity owogonro xina nudupa, xina agâ mipyra mawylygue. Iwânu ume, kadeia oday mawyly ume warâ xina âyam IU nipyra, xina âutuba awylygue” kezemo yam. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","— Aituo ise auguely eyanmo: “Âdykâ kaikânro modo mâenmawyadâdaymba ani âmaemo. Akaemo mâenmawyadâdaymba âmaemo watay, urâlâ mâenmawyadâdyzeba matomo” keze urâ eyanmo. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","— Akaemo ynynâbaom modo idâlymo ise myarâ kurâdo inakai modo âsenagazedoram. Ynynonro modo olâ Deus agâ idâze aunloenlâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Waunroem aini modogue xina tienomedâbygueduo, Jesus xinaram agueondyly: ");
INSERT INTO bkqNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","— Tutuzelâ âmaemo, kopaelâgâbygueduo kâtyry Páscoa awyly, kydamudo Egitodâba âsemaguehomobyry etyry. Yizepaom modo yawânehonzemo, kruz onwa yakâjien-honzemo yiguehoem warâ. Warâ ise ayedylymo urâ Uguondo Kaynâpa Âetyby — kely xinaram. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aguehobyry ara kehoem aidyly. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, kywymâry modo warâ Caifás ety imâsedo oday myani âtâdyguylymo. Caifás ani kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Âjigue aguelymo myani, âdara Jesus tientadânehonly, tyâen-honly warâ wâgâ. Kurâ domodo nhutudyzebamo olâ myani. Aituo myani aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","— Koendâpa ise enra âty ume sawâdyly. Toenzepa ise kurâdo âzetygueni modo. Jesus etadâdobyry egary indadylymo watay, kagâ iewiâpazemo, âjitoguyzemo warâ — kelymo wâne myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesus agâ xina idâondyly âtâ anary Betanianra. Târâ tatay xina idâly Simão tâjimituguelygue tâwâneimpyry etyram. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xina âwinduadyly ume, pekodo Jesus iopaji saindyly. Alabastrogue uriza etary xygatybygue tâmase; uriza tâwâenseim nardogue tumyke ani mârâ. Uriza tyânrângueim nhapâdyly Jesus nhangahu onwa. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pekodo uriza nhapâdyly tientuo aidyly xina nehoguebyra. Aituo âjigue xina aguely: — Etaungâ! Awâkâ pekodo uriza tâwâenseim alâ kulâ nhumedyly! ");
INSERT INTO bkqNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Awârâ uriza vende iedylylâ-ro watay, toenzepa tâise idinherugu. Koendâ tâise vende nhedyly, âdy pebaom modoram dinheru tiunduhoem — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xina aguely xuturimbyryem olâ Jesus. Aituo xinaram aguely: — Arâ adâkezeba itaungâ merâ pekodoram. Âwankuem kâietaundâ warâ. Koendonro merâ urâem anhekyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Aunlolâ ise âdy pebaom modope awyly mâenmawyadâdomoem. Urâ olâ ise âdiempa kulâ agâmo wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wonwa uriza tyânrângueim niapâdai, yigueduo, ieguepybyry etadâdo odaji ietoem, wondyly ara. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Merâ anhetyby ânguy nenanânehonwâbyra ise. Âdykâlâ unâ koendonro egatuly watay, tânanâguezeinlâ ise merâ aitobyry. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aituo Jesus eynynonroem ityby ewy Judas xidadâ Queriote donro idâly kurâdo eynynâ Deus agâ aguewâni modo iwymârydoram, Jesus wâgâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Aituo myani Judas aguely: — Âdaraka ise iepywadylymo, Jesus âyanmo kâengameduo? — kely. — Trinta moedas pratague ise ipywadyly. Anra — kelymo myani. Aituo Judas dinheru nhemakely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ilâpygueduo Judas âdara Jesus tiengamely awyly wâgâ âpaunzedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pão ioliho pebaom etyguedo adaguly ume Jesusram xina aguely: — Âdykâka ise pyni iwâkuru xina anhenehondyze mawyly, xirâ Páscoa ume kydawinduatoem? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus in-hoguly: — Jerusalémdâ ise kydâwinduadyly. Idâwâtaungâ wao myarâ. Mâkâ uguondo auguehobyry agâ oxioze âmaemo. “ ‘Alâ enra iweâma’ keanryze Konomedâni. Itydâ ise tynynonro modo agâ Páscoa nhetyguedyly, âwinduadyly warâ” kewâtaunda eyam — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesus aguehobyry ara aidylymo. Pyni modo adyenehonzemo myani, Páscoa xina nhetyguedoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iguampygueduo xina myarâ idâly Jesus agâ. Xina ekadyly tâwinduatoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Xina âwinduatay Jesus aguely xinaram: — Idataungâ wao. Tokalâ âmaemo ewy ise yizepanro modoram iegamerim — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jesus agueduo xina itynwandyly. Mâkâ, mâkâ warâ xina aguely: — Urâ mâkeba ise igamenri, Konomedâni! — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aituo Jesus aguely: — Âmaemo ewylâ olâ ise iegamerim, yagâ pão edawynrim modo ewylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Deus itaumbyry egatuwâni modo iweniwânmy ywâgâ: “Uguondo Kaynâpa Âetyby âdyoze” kely myakâwâm inwenilymo. Aguehomobyry ara ise awidyly. Toenzepa âsenagazeze olâ yizepanro modo emaxi iegamerimbyry. Niazepa wânkâ nidyse! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aituo egamenrianlâ adapâigueoly, Judasram: — Yanlâ amyguely watay, Ienomedâni. Urâ mâkeba ise igamenri — kely. Aituo Jesus in-hoguly: Mâkadulylâ awârâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tâwinduatay Jesus pão nhanâdyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ pão mâundulygue — kely. Aguenripyryem pão nhepajiwâdyly. Mâkânra, mâkânra warâ nhuduly. Aguely xinaram: — Sawâtaungâ. Edawynwâtaungâ. Xirâ pão kâempajiwâdyby, wodolâ xirâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ilâpyryem kopu vinhugue taseim tâmaxi nhedyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ vinhu mâundulygue — kely. Aguenripyryem, mâkânra, mâkânra warâ nhuduly, xina nhenyhoem. Aituo aguely xinaram: — Enywâdaungâ idânârâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Unulâ xirâ. Tâunkeze ise yiguely, toenzepa kurâdo emakeze, inakanhe aitomobyry xygakeze. “Ynynonro modo emakeze urâ” Deus kehobyry mawânrâ. Awylygue ise unu tyapâze yigueduo, iwelo tâdâsemaguehobe Deus nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Xirâ pygueduo, Páscoa kâentyguedombyra, vinhu kâenyombyra warâ wao ise urâ agâmo, Pabai Deus eynynonro modo myarâ pymâem atoram saindylymo ara. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Âty âwanikebygueduo, xina igâtudyly Deus tionmaendoem. Igâtudybyem xina idâly iwy Se Oliveira Ekaram. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesus aguely xinaram: — Xirâ kopae idânârâ âwiense âmaemo. Wodokeze âmaemo. Deus itaumbyry sawo wâgâ iwenibyem: “Kaneru sodo xyâduo, idânârâ eguy modo adapâeguyze” kewânmy Deus. Arâ ise ayedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yigueduo, kurâem itonze olâ urâ. Kurâem witombygueduo, âwaynâmolâ ise udâly Galileiaram — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Agueduo myani Pedro aguely: — Tâwâlâ wâne ise idânârâ odokelymo. Urâ olâ ise odokeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus olâ warâ eyam aguely: — Xirâ kopae, aukuma igâtudyly iraynâ, azagâ tokalâ warâ ise “Jesus kâuntuwâbyra urâ” myguely. Xirâ mâuntudyze wato kuru — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro olâ agueondyly lelâ: — “Jesus kâuntuwâbyra urâ” uguewâpyra ise urâ. Tâwâlâ ise agâlâ yâlymo. “Jesus kâuntuwâbyra urâ” uguepa olâ ise urâ — kely. Idânârâ xina Jesus eynynonro modo aguely: — “Jesus kâuntuwâbyra urâ” xina kepa lâpylâ ise — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Xina saindyly âji Getsemaniram. Myarâ saintybyem Jesus xinaram aguely: — Tarâlâ wao itaungâ, ikadaungâ warâ, Deus agâ agueze udâday — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Adâkebygueduo, Jesus Pedroram, azagâ Zebedeu imeombyryram warâ aguely: — Yagâ âetaungâ; akaemo modo lelâ ise taunlo — kely. Aituo eagâ idâlymo iwague nekâ. Târâ myani toenzepa kehoem Jesus itywandyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aituo myani aguely eyanmo: — Toenzepa enra ytynru, yigueho ara kehoem. Tarâlâ wao itaungâ. Tykyzeba olâ itaungâ, ynynâ Deus agâ amyguehomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Âdiempa waunroem idâly myani. Târâ myani âzeguhoam idyly, Deus agâ adâkehoem: — Pabai, toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly, ize mato aralâ — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Deus agâ agueypyem myani, Pedro, Tiago, João warâ âxiân-hobyryram idâly, xykylymo ume. Xuagueânimopyryem myani aguely Pedroam: — Âmâ, agonrodo warâ âykylymo enra. Âdiempalâ ynynâ Deus agâ amyguehomoem âykyba mitomoem nudupa kuru? — kely. Aituo eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","— Nhaum, xuagueypyem lelâ itaungâ, inanaynmolâ warâ. Satanás umohomoem aienehonze keze. Deusram ekadaungâ, Satanás ize ato amânhepyra mitomoem. Deus eon-honru peba kulâ yagâ tâdâsenagazedyly mâenmaenwâbyra ise âmaemo, yagâ mâsenagazedyze mawylymo umelâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus idâondyly âdiempa waunroem, Deus agâ agueonse: — Pabai, idânârâ adyese âmâ. Toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly, ize mato aralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ilâpyryem myani odopâdondyly Pedro, Tiago, João warâ eydâ atoram. Xykyondybymoem awyly nhedyly. Toenzepa myani xuedunumo, xuagueypyem lelâ itomoem nudupa. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesus târâpa âxigueondyly. Deus agâ agueonse idâly. Alâpylâ myani agueondyly: — Pabai, idânârâ adyese âmâ. Toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly, ize mato aralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ilâpyryem Jesus eagâ idâypy modo warâ odopâdylymo xina eydâ atoram. Xinaram Jesus aguely: — Âykylymo kulâ enra. Inuzeba lelâ mataunaze, Deus agâ amyguehomoem. Alâ! Iweâ lelâlâ yizepaom modo emaxi âduduoze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Autaungâ. Inoro, eagâmo kydoxioda. Etaungâ! Awâkâlâ iegamerim saindyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus aguely ume Judas saindyly. Jesus eynynonrolâ kâinane mâkâ. Toenzepa kurâdo eynynâ Deus agâ aguewâni modo iwymârydo ingonotaymby modo, kywymârydo ingonotaymby modo warâ Judas agâ saindylymo. Espadague, segue warâ tâmatune kehoem saindylymo, Jesus sawâse. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Taindylymo umelâ myani Judas eyanmo aguely: — Uguondo konhonuguguyly, mâkâlâ ise mâkâ, Jesuslâ. Tâwâlâ ise manwâdylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aituo Judas saindyly Jesus iopaji, aguely: — Âdapalâ wâne, Pymâ? — kely. — Âdainkâba urâ — kely Jesus. Aguenripyryem Jesus iwaparydâ nhonugudyly; tataen-ho agâ adâito ara nhedaenkuly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus eyam aguely: — Yataen-ho, inepa aiese mâetobyry aiekâ — kely. Aituo Judas agâ idâwâtyby modo Jesus nhawâdylymo, nhemakâjilymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Xina ewy tydahoru imâsedo ety odayba tâtyze ani. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru agâ tâwaneim iwantazagâmâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aituo eyam Jesus aguely: — Adâiseba ikâ. Âdahoru ekanâgâ. Tutuzelâ âmâ, “Espadague âseguebyby, espadaguelâ ise âdyoly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kâsemaguehoem âmâ, uguewâpyra urâ. Pabairam tâise kâenkadyly kâsemaguehoem. Inepa tâise toenzepa kehoem anju domodo ingonodyly iemakeze. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Deus itaumbyry awo wâgâ inwenibyem olâ ara âsenagazeniem wawyly. Anju domodo kâingâsedyly watay, iwenihobyry aguehobyry araba ise awidyly — kely Jesus mâkâ aienibyryam. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ilâ ume Jesus aguely kurâdo tawâse idâypy modoram: — Espadague, segue warâ tâmase kehoem yawâse mâewylymo, tâmagazeim urâ-ro waunlo ara. Yawâtomo tuduzelâ keankâ saguhoem, kyâho pebalâ. Kopaelâgâembaba keankâ Deus ety idaseray, agâmo agueze wawyly. Târâlâ yawâpyra olâ mataunaguynre. Yawâto odayba awylygue keankâ ilâenlâ yawâpyra mawylymo. Tâwâlâ yawâtaungâ lelâ, âdaitybyemba wawyly umelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Arâlâma Deus itaumbyry egatuwâni modo ywâgâ inwenibyem awyly Deus itaumbyry awo wâgâ — kely Jesus. Jesus sawâtuo, idânârâ xina eagonropyry modo nhodokely. Xina âwiendyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ilâpygueduo Jesus nhadylymo kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru Caifás etyram. Idânârâ pymâ tynruneim modo târâ âtâdyguybyem awylymo. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydobe, Moisés inweniby wâgâ enomedâni modo warâmo myani târâ, idânârâ uguondo modo tynrenseim modope warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Myarâ idâdaymo myani âgânâ kehoem Pedro idâly, Caifás ety idaseraji. Tâgawânse, tâkaze warâ myani akaemo guarda domodo agâ, âdara Jesus nhedylymo tientoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, kywymâry modo, kurutaynrim modo warâ, âdara Jesus tienwentâdo wâgâ aguelymo myani. Mâkâ wâgâ âdalâ kulâ aguenri nhuinlymo warâ, âdy wâgâ tiân-homo awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Akaemo pymâ domodoem olâ myani âdy ewentâdo peba, iwâgâ aguewâni modo kewâdyly kulâ awylygue. Ilâpyryem myani azagâ uguondo saindyly pymâdo enadoram. Jesus ewentâze kewâdylymo kulâ olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Warâ aguelymo: — Jesus aguehobyry tindatyby ise xina nhegatuly. “Deus ety sakalagueze urâ. Azagâ emedyly idyly ara saunâtonze olâ urâ” kely, xina nidadâ — kelymo myani, Jesus tienwentâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aguelymo idanipyryem, kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru saudyly. Jesus nhapâiguely: — Âwâgâ aguelymo midatailâ. Âkealâ, âkealâba iwentâdomo awyly ise amygueho? Âdamyguepaka ise âmâ mâsemaguehoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Âdakepa olâ myani Jesus tâsemaguehoem. Aituo myani kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru nhapâigueondyly: — Messiaslâka âmâ, Deus Ingonotyby? Deus iguedânry imerylâka âmâ? Âkealâ xinaram mâengatuba âmâ-ro watay, âsenagazeze âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aituo Jesus in-hoguly: — Mâkâlâ urâ, amygueho aralâ. Xirâpygueduo ekadybyem ise urâ Deus ton-honreim ahoru eynynâ. Eagâ ise pymâem wawyly. Eunu duay ise Deus eydâpa kâewyly. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Toenzepa kehoem kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru iewiâpadyly “Deus imerylâ urâ” Jesus kely tindatuo. Tyewiâkygue tâty tywogonrolâ nhaunguely. Pymâdo târâ âtâdyguyby modoram aguely: — Deus nunâguedai merâ Jesus. Deus agâ âzekiba tawylylâ agueho, “Deus imerylâ urâ” keduo. Ânguy kingâsedaymba ise kurâ, ewentâniem. Midataimolâ Deus wâgâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Âdara iedylyka inanajimo inakanhe kehobyry wâgâ? — kely. Aituo pymâ domodo aguely: — Uguondo inakai kulâ awâkâ! Xyâly lelâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Agueypyem emydy onwa KUITÚ kelymo, nhapiogulymo warâ. Jesus nhenuahulymo, tiampioguhoem. Sapiogunrimbyryem, aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","— Ânguyka apiogurim? Apiogüimbyry xutugâ, âkealâ kuru Deus Ingonotyby matay — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jesus pymâdo enado atay, Pedro târâ taseraylâ myani. Pekodo târâ tâwaneim ewy Pedro einkâ sakadyly. Koendâ kehoem enipyryem aguely: — Jesus Galiléia donro eynynonro modo ewylâ âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aituo myani kurâdo enanaym Pedro aguely: — Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ! Ânguyka awâkâ Jesus, iwâgâ amyguehomo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Agueypyem myani taseraji tâdâwânto iwyantaji Pedro idâly. Eagonro pekodo târâ tâwaneim modo ewy, Pedro tientuo, tydâ iwaguepanro modoram aguely myani: — Jesus Nazaré donro eynynonro ewy awâkâ uguondo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mâkâ pekodo aguely tindatuo myani Pedro agueondyly: — Âdykâ Jesus eynynonroem witaymba urâ. Kâuntuwâbyra urâ awâkâ. Tâwâlâ ise Deus ienagazenehonly, uguewâdyly kulâ-ro watay — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ilâpyryem myani uguondo modo ewy Pedro iopaji saindylymo. — Jesus eynynonrolâ âmâ. Tutuze xina, Galiléia donro mawyly, earamolâma amyguely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aituo myani Pedro agueondyly: — Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ uguondo! Tutuze Deus âkealâ auguely awyly. Tâwâlâ ise Deus ienagazenehonly, uguewâdyly kulâ-ro watay — kely. Pedro. Aguely umelâ myani aukuma igâtudyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tindatuo, Pedro Jesus tyam aguehobyry nhenanâguely, “Xirâ kopae, aukuma igâtudyly iraynâ, azagâ tokalâ warâ ise ‘Jesus kâuntuwâbyra urâ’ myguely” kehobyry. Aguehobyry tienanâgueduo myani toenzepa Pedro itynwandyly. Târâpa âxiguely. Tâjityenze kehoem eogumadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Emetybyem idânârâ akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, pymâ judeu domodo iwymârydo warâ âtunâguedylymo, âdara kuru Jesus tyâen-honlymo awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tonlo guarda modoram nhekâjien-honlymo, nhaleholymo, nhegamehonlymo warâ Pilatosram, pymâ Romadâpa ingonotybyram. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesus egamenribyry, pymâdo Jesus tiân-homoem aguelymo tientuo, toenzepa kehoem âjityendyly, pymâdoram mâkâ tiengamehobyry wâgâ. Awylygue myani kurâdo eynynâ Deus agâ aguewâni modo iwymârydoram, kywymâry modoram warâ idâly. Mârâ trinta moeda sopâze kely mâkâ tiengamehobyry ebyry. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Eyanmo aguely: — Inakanhe lelâlâ awidâ; mâkâ uguondo âdaityby keba kulâ sawâneho — kely. Aituo eyam aguelymo: — Awârâ tiuntudyze inkâba xina. Âmâ inakanhe aini, xina mâkeba — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Agueduomo, Judas mârâ dinheru nhamely Deus ety odaji. Dinheru sameimbyryem, idâly okogâjize. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo mârâ moeda pratagueto sanânibyryem, aguelymo: — Xirâ dinherugue keankâ uguondo xyâhoem epywadyly. Awylygue ise Moisés inweniby eynynâ, Deus ety oday kienwanipa kydawyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aituo âtunâguedybyem, mârâ dinherugue onro nhanâdylymo. “Âdydo imeom onrogue xygato” kehobyry. Mârâ onro nhanâdylymo judeu keba modo igueypy etadâdoenlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jesus iguehoem egamehobyry ebyrygue sanâtyby awylygue, “Xyâhoem egamehobyry ebyrygue sanâtyby” kelyguelâ mârâ âji ezeku iwerâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aguewânlâmy Jeremias, Deus eynynâ agueypy: “Trinta lelâ moeda pratagueto nhemakelymo. Israel iweom ‘Warâ ise ebyryem kiunduly’ kehobyry” kewâm. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mârâ dinheru tienmakeybygue, âdydo imeom onrogue xygato ejidy nhanâdylymo. Warâ myani aidylymo, Kywymâry Deus aguehobyry ara tâkeze myakâwânmy Deus eynynâ agueim. Warâ myani Judas mârâ dinheru, Jesus tiengamehobyry ebyry anhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus XYDYK warâ, mâkâ pymâ Romadâpa ingonotyby, Pilatos enado. Pilatosram adapâigueoly: — Judeu domodo iwymâry kuruka âmâ? — kely. Jesus in-hoguly: — Mâkâlâ urâ, amygueho ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, kywymâry modo warâ tâwentâduo, âdakepa olâ Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilatos aguely Jesusram: — Akaemo iwentâdo midatailâ. Amyguehonly mâin-hogubaka ise âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus olâ âdakepa. Toenzepa kehoem Pilatos âseguâdâdyly, Jesus tâsemaguehoem âdakepa awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Páscoa etyguedyly ume, aunlolâ mykâinane Pilatos etadâdyby modo ewy tokalâ nhetaguehonly, âdaunlolâ kurâdo nhekadybylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ilâ ume tâlâ myani uguondo kadeia oday tâtagueim, kurâ domodo nhutuly, Barrabásgue tâzekeim. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aituo kurâdo âtâdyguyly, Pilatos ety iwyantay. Pilatos eyanmo aguely: — Ânguyka kâentaguedyze matomo, Jesus Barrabás keho, Jesus Messias keho Deus Ingonotyby? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tâsewânilygue kulâ akaemo judeu domodo iwymâry, Jesus tyam nhegamely awyly, tutuze olâ myani Pilatos. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatos târâ tribunaldâ ekadybyem awyly ume myani iwydy âjitaumbyguely eyam. — Jesus âdakâiedâ. Koendonro awâkâ uguondo. Âdy inakanhe anientaymba awâkâ. Kopae eagâ kâjiâensedai. Toenzepa kâsenagazedai eagâ kâjiâensedobyry wâgâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, kywymâry modo warâ toenzepa kurâdoram aguelymo. — Barrabás nhetaguehoem ekadaungâ Pilatosram. Jesus xyâhoem ekadaungâ-ro warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ine warâ myani Pilatos kurâdoram agueondyly: — Âdykonlo uguondoka kâentaguehondyze matomo? — keondyly. Aituo in-hogulymo: — Barrabás! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","— Âdakânhedyly pylâka ise merâ Jesus, Messias, Deus Ingonotyby? — kely myani Pilatos. Idânârâ kehoem in-hogulymo: — Kruz onwa sakâjien-hongâ, iguehoem! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","— Âdaituo? Ienanaji, âda nitaymba merâ iguehoem — kely Pilatos. Agueduo olâ idânârâ adaenkelymo ton-honre kehoem: — Kruz onwa sakâjien-hongâ, iguehoem! — keondylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tutuze olâ Pilatos, aguiom kurâdo tunâry nugukeba awyly. Tutuze lâpylâ, akaemo tagâ iewiâpadyly, aguehomobyry ara anipyra-ro watay. Aituo tâzemaunguehoem paru nhenenehonly. Enanaynmo âzemaunguely, tâwentâzeba tawyly tienehon-hoem. Eyanmo aguely: — Urâ keba ise âsenagazeni merâ uguondo iguehobyry wâgâ. Âmaemo ise tâwentâzeim, mâyâen-hohomobyry wâgâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Idânârâ kurâdo aguely: — Xinalâ ise tâwentâzeim awâkâ iguehobyry wâgâ, xina, xina imeombyry, xina iweompyry alelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aituo Barrabás nhetaguehonly, nhekadomobyry ara. Ilâpyryem myani Roma donro sodadu domodoram aguely: — Jesus sapioguwâdaungâ. Ilâpyryem ise mandylymo, kruz onwa sakâjize-ro warâ, iguehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ilâpyryem sodadu domodo Jesus nhadyly palaciuram, Pilatos etyram. Idânârâ târâ sodadu modo âtâdyguylymo myani. Jesus tuontaji nhedylymo, âwankuem tientomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jesus etygueimbyryem, âtâ BOH waunlo tapabileingue nhetydâdylymo, pymâ âzetydâdo ara, âwankuem tientomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tyguyreim koroaem xygatyby myani mâkâ nhangahu onwa nhekylymo. Aho eynynâ segue nhematâdylymo, pymâ ara. Enado âzeguhoam idylymo, pymâ enado adâitomo ara. Eyam aguelymo: — Tynrenseim âmâ, judeu domodo iwymâry kuru! — kelymo, âwankuem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","KUITÚ kelymo nhonwa, segue nhangatainlymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Âwankuem ienipyryem âtâ BOH waunlo tapabileim Jesus wâgâpa nhetylymo. Ety iwogonropyryguelâ nhetydâdylymo. Ilâpyryem nhadylymo, kruz se xygatyby onwa sakâjize. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xidadâ odaypa tâgasedaymo, uguondo Simão agâ oxiodylymo. Xidadâ Cirene donro myani mâkâ. Aituo myani, sodadu domodo kruz Jesus tiankâjiho eyam nhanânehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgotaram myani Jesus nhadylymo. (Iwy Calvariogue tâzekeim lâpylâ, tâjiangahubyry ara enurunugue.) ");
INSERT INTO bkqNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Târâ myani vinhu tâzenukuru agâ ietybygue sakuize kelymo. Ekunibyryem myani tienydyzeba idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","38","Aituo kruz onwa nhakâjilymo. Jesus merâ, judeu domodo iwymâry kuru kely iweniby sakâjiwânmomy Jesus nhangawaym kruz wâgâ. Âdaituo Jesus nhakâjilymo awyly xutuhoem myani mârâ anhedylymo. Ilâem lâpylâ azagâ tâmagaduneim modo nhakâjilymo. Tokalâ Jesus ahoru eynynâ, eagonro pâem eynynâ warâ nhakâjilymo. Sakâjirimbyryem, Jesus ety iwogompyry nhepajiwâdylymo. Dadu nhamelymo ânguy, ânguy warâ Jesus ety iwogompyry emakeim awyly tiuntuhomoem. Aitybyem ekadylymo, akaemo azagâ tokalâ warâ kruz onwa sakâjiwâdyby ânguy nynanâbyra itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tâinkâ sakadaynrim modoram âwankuem âieholy. Angakânilymo, inwykelymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","— “Deus ety sakalagueze urâ” myguema. “Azagâ emedyly idyly ara kulâ saunâtonze urâ” mygue warâ. Ton-honreim lelâlâ matay, tâwâlâ âsemaguegâ! Deus imery âmâ watay, kruz wâgâpa âytâguygâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo, kywymâry modo warâ âwankuem nhedylymo. Aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","— Âkelomo nemake, tâwâlâ nâsemagueba olâ! Israelita domodo iwymâry lelâlâ-ro watay, iweâ lelâlâ kruz wâgâpa nytâguy. Xytâguyly-ro watay, einwânse kurâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Deus imery urâ” nygue. “Deus ietâ” nygue warâ mawânkâ. Âkealâ kuru-ro watay, Deus kruz wâgâpa xytâguyânze âese iweâ lelâlâ! Deus tâense watay, nemake pylâ! — kelymo, âwankuem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Akaemo azagâ tâmagaduneim modo eagâ sakâjiwâdyby modoram âwankuem âieholy lelâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kuotatay idânârâ iamadyly; azagâ tokalâ warâ horas ani iamu. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Azagâ tokalâ horas ituo myani Jesus adaenkely: — Eli, Eli, lemá sabactani? — kely. (“Pabai, âdaituoka wodokely?” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tonlo modo, koendâ nidapyra tawylygue, Elias ingâsedyly ara nhenehonlymo, Deus eynynâ agueim lâpylâ mykâinane mâkâ. Aituo aguelymo: — Idataungâ. Elias ingâsedyly tâmakehoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Akaemo ewy egatudyly myani vinhu nhewantybygue esponja ikuize. Tinkuibygueduo se iopiry onwa nhekâjily. Jesus nhugakâin-hoem wâne nhuduly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Eagonro modo eyam aguely: — Ine wao. Elias awâkâ ingâseguyly. Elias emakeze âewyly kyzene wao — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aituo Jesus adaenkeondyly ago kehoem, tyiguehoem kuru. Ipa kuru idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iguely ume kehoem myani, Deus ety oday Deus Âepanâgueho xuahuho tyxieim iotagâ adauguely kaynonrobyryem, on-yam; Deus, kurâdo agâ tygue ito myani mârâ xuahuru. Ton-honre kehoem onro âzekânily. Tuhu imâsedo modo tatuwâze myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Onro âzekâniduo, âguedy modo etadâdo âzenahunguewâdyly. Aituo myani Deus eynynonro igueypy modo myarâ ietyby, kurâem itondylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tâkanâdobyrydâba egaselymo. Deus, Jesus kurâem nhetombygueduo myani akaemo idâly xidadâ Jerusalémram, Deus ijidadâryam. Târâ tâtyuneim modoram tâzehozemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sodadu Roma donro modo iwymâry, izodadury Jesus etaynrim modo warâ onro âzekânily tâensemo myani. Aidyly tâensemo warâ. Tientuomo, toenzepa kehoem myani âseanedylymo. Aguelymo: — Deus imery lelâlâ mynra merâ uguondo! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tâlâ myani târâ pekodo modo, iwaguelâ olâ nhedylymo. Jesus sakâjily iraynâ, Jesus Galiléia eynynâ atay, emawyadânibyry ani akaemo pekodo modo tâlâ tatomogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Maria (Magdala donro), Maria (Tiago, José warâ ise), Zebedeu imeom ise warâ myani iduaymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iguandyly iraynâ uguondo tydinherugueim José saindyly, xidadâ Arimatéia donro. Jesus einwânni lâpylâ myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aituo José, Pilatosram idâly agueze: — Jesus nigueaki, Pymâ. Kruz wâgâpa kâyntâguyândyze olâ urâ, tuhu imâsedo tâtagueim odaxi kâenkanâdoem. Tâwâlâ kâyntâguyândyly? — kely. Aituo Pilatos, Jesus eguepybyry José nhatoem, — Tâwâlâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aituo José, Jesus eguepybyry kruz wâgâpa nhytâguyândyly. Xytâguyânibyryem intuwynly âtâ iwelo linhuguetogue. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tyigueduo tâtaryem tiensaguehoymby odajilâ myani Jesus eguepybyry nhetadâdyly. Iwelo esagueze myani mârâ tâtagueim. Myarâ eguepybyry ienipyryem nhenahunly tuhu imâsedogue. Ilâpygueduo, idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Azagâ pekodo modo: Maria Magdala donro, Maria lâpylâ warâ Jesus eguepybyry etadâdobyrydâmolâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Páscoa etyry sakabygueduo, iguandyly ume akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, fariseu domodo warâ idâlymo Pilatos agâ âtunâgueze. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","— Pymâ, tyiguely iraynâ, warâ keankâ Jesus aguely: “Yigueduo, azagâ emedyly idyly wâgâ kurâem itonze urâ” nygue. Xirâ âkealâba kulâ aguehobyry enra xina nhenanâguely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Awylygue Jesus eguepybyry etadâdobyry koendâ mâenehonly xina ize ato. Azagâ emedyly idyly ara enipe târâ nidâ, eynynonrobyry modo eguepybyry nemagazebyra itomoem. Tienmagazeduo, “Jesus kurâem nitondâ” kezemo mawânkâ. Toenzepa iwerâ “Jesuslâ Messias” kelygue tonokudo einwânni modo. “Jesus kurâem itondybyem” kely nheinwândylymo watay lakuru ise aguykeho einwândyly inmolymo kuru — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aituo Pilatos eyanmo aguely: — Âdainkâba. Anra yzodadury modo. Idâzemo lelâ agâmo, azagâ emedyly ise târâ agâmo awyly, Jesus etadâdobyry eniem. Imawyadâzemo, ânguy Jesus eguepybyry nynanâbyra itoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aituo myani Roma donro sodadu domodo tagâ nhadylymo. Tâtagueim enahun-ho enahungueybyem awyly xutuho tyesemo myani, ânguylâ Jesus eguepybyry eydâ atoram egawânipyryem awyly tiuntuhomoem. Adiempygueduo myani idâlymo. Sodadu domodo lelâ myani eniem âxiânrim. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tâzekobyzegueho sakabygueduo domingo pealâ pekodo modo Jesus eguepybyry etadâdobyryram idâlymo, Maria Magdala donro, Maria lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tadaguzeim kulâ onro âzekânily. Anju Deus ingonotyby myani Jesus eguepybyry etadâdobyry enahun-ho ejikeim. Tuhu imâsedo ejikeimbyryem myani nhonwa ekadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ielu ara kehoem myani ehoru, tapeke kehoem ety iwogonro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Târâ eniem âxiâymby modo tâseaneze myani, tadapânizemo warâ. Onro onwa ihuguewâdylymo myani, ekomadybyem. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Anju kaynâpa âetyby pekodo modoram aguely myani: — Tâseanezeba itaungâ. Tutuze urâ, Jesus mâwinlymo awyly, kruz onwa sakâjiby. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tarâpa olâ mâkâ. Ipa, kurâem nitondai, aguehobyry aralâ! Etaungârâ etadâdobyryam. Ânguy lâpeba tarâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Inepa idâwâtaungâ, eynynonro modoram egatuze. “Kurâem nitondai! Waunroenlâ ise Galileiaram idâly. Târâ ise mâendylymo” kewâtaunda eyanmo. Auguehobyry ara ise aidyly — kely myani anju. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Inepa kehoem pekodo modo Jesus eguepybyry etadâdobyry nhodokelymo. Toenzepa myani eanumo, iomarumo lâpylâ warâ. Egatudylymo Jesus eynynonro modoram tiengatuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jesus eagâmo toxioze myani. Aituo myani aguely: — Âdapa lâwâne âmaemo? — kely. — Âdapa — kelymo. Iopaji saindylymo. Enado âzeguhoam idylymo. Ixinary tywymogoynzemo myani, koendonroem awyly wâgâ adâkezemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aituo myani Jesus eyanmo aguely: — Tâseanezeba itaungâ. Idâwâtaungâ. Ynynonro modoram aguewâtaunda. “Âwaynâmolâ ise Jesus idâly Galileiaram. Târâ ise âwânwândylymo. Ese âmaemo” warâ kewâtaunda — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pekodo modo xinaram Jesus wâgâ agueze idâday myani guarda domodo ewy xidadâram odopâdylymo. Idânârâ tientyby ara myani kurâdo eynynâ Deus agâ aguewâni modo iwymârydoram nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kurâdo eynynâ Deus aguewâni modo iwymârydo myani kurâdo nhutudyzeba akaemo tyam nhegatuyby. Aituo myani kywymârydo agâ âtunâgueze idâlymo. Koendâ âtunâguedybyem myani toenzepa kehoem guarda domodoram dinheru nhudulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Warâ myani eyanmo aguelymo: — Jesus eguepybyry wâgâ amyguehonly-ro watay, “Kopae xina xykyly ume Jesus eynynonro modo nâtâ, eguepybyry emagazeze” kewâtaungâ lelâne. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilatos âykyhomobyry wâgâ agâmo iewiâpadyly-ro watay, xina ise eagâ aguenri, inagazebyramo itoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aituo myani guarda domodo dinheru nhemakely. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo aguehobyry ara lelâ aguelymo. Arâ lelâ myani judeu domodoram nhegatulymo, kypemugudoram. Xirâ tonokudobyry tâinwânselâ akaemo judeu domodo ewy iwerâ. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xina idâly Galileiaram. “Târâ ise kydoxiodyly” Jesus kehobyry iwy onwa xina âkuly. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Târâ Jesus tientuo, toenzepa kehoem xina iomazely. Enado xina âzeguhoam idyly. Koendâ awyly wâgâ xina aguely warâ. Tâlâ olâ ani xina ewy Jesuslâ awyly einwântânry. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aituo Jesus xinaram saindyly, aguely: — Deus kaynâ, onwâgâ alelâ pymâem witoem anygue. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awylygue idâwâtaungâ awârâem kurâdope ato ara enomedâzemo, yeinwântomoem. Yeinwâmpygueduomo, batiza ietaungâmo, ynynonroem, Pabai Deus eynynonroem, Deus Ispiritury eynynonroem warâ awylymo xutuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Amitomoem inomedâdomobyry ara lâpylâ enomedâdaungâmo. Enanâguewâdaungâ, agâmolâ wawyly, koendâ nhetomoem xypyry etaji kehoem — kely Jesus. Alâ kulâ. Mateus");
INSERT INTO bkqNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Deus Imery Jesus wâgâ xirâ unâ aguely; Deus imery lelâlâ awâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iweâpalâ myakâwândy Isaías Deus itaumbyry wâgâ agueseze awyly. Awârâ âdydo imeom aidyly wâgâ inwenily warâ. Saguhoem warâ myakâwândy Deus, Tingonotybyram aguely: “Ynynonro modoram mydâly iraynâ, uguondo igonose urâ, âwâgâ aguenriem on-hondybyem lelâ itomoem, âdatomoem, âinwântomoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Messias wâgâ agueim târâ âji âdy peba atodâ ise aguely. Adâkely idase idâwâtyby modoram: ‘Inepa ise Deus Ingonotyby saindyly. Izepa ato aiedyly imowâdaungâ. On-hondybyem lelâ itaungâ’ aguely mâindatomoem. Pymâ ton-honreim kâty anaxi âewyly kiuntuduo wâne, kâty inatary tuonse, tuonkeze warâ kurâ, myara on-hondybyem lelâ kydawyly aguely idase” warâ myakâwândy Deus itaumbyry Isaías inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Arâlâ myani João âji âdy peba atodâ awyly, Isaías aguehobyry aralâ. Kurâ domodo idâly myani eydâ atoram. Eyanmo aguely myani Deus aguehobyry: — Âjityendaungâ, inakanhe amitomobyry wâgâ. Deus izepa ato aiedyly imowâdaungâ. Deus einwântaungâ, inakanhe amitomobyry nhygakehoem. Parugue batiza âiehowâdaungâ, inakanhe amidylymo imoimbyryem amidylymo mâenehon-homoem — kely. Inakanhe tadawyly timoduomo myani, Deus eynynonroem tawyly nhenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Toenzepa mykâinane xidadâ Jerusalém donro modo João aguely idase idâlymo. Tâtâze lâpylâ mykâinane Judéia donro modo. Aguewâdylymo myakâwâm: — Deus izepa ato aieni ani xina. Adâidyly tumoze olâ xina-ro warâ — kelymo. Arâ agueduomo, Joãoram batiza âieholymo paru Jordão ikay, Deus izepa ato adientomobyry wâgâ tâjityenze tawylymo tienehon-homoem, inakai modo adiendyly imoimbyryem tawylymo tienehon-homoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Camelu xuhudu xygatyby mykâinane João ety. Tâjitubygue kulâ mykâinane iwanxiegu. Kahuligue, penrâgue warâ mykâinane ipynigu. Kurâ domodoram aguely mykâinane: ");
INSERT INTO bkqNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","— Eagonro âese lâpylâ Deus wâgâ aguenri. Ton-honreim ise mâkâ, iemyenro keba. Mâkâ ise yakadâ kuru ton-honreim. Âdy mâkeba urâ. Ihuru etary ekâjiguerin-enlâ witoem nudupa lâgâlâ, ihuru kâingokehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Urâ parugue batiza âenimo, Deus izepa ato amânhetomobyry wâgâ tâjityenze mawylymo mâenehon-homoem, inakai modo aiedyly imoimbyryem mawylymo mâenehon-homoem warâ. Mâkâ âeni olâ ise Deus Ispiritury xuduim, einwânni modo eon-honwanâniem, izepa ato aniempyra itomoem, ize ato lelâ anhetomoem warâ — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Aituo Jesus idâly Galiléia eynynonro âtâ anary Nazaré donropyryem myarâ João eydâ atoram. Târâ myani Jesus batiza âieholy Joãoram paru Jordão ikay, Deus eynynonro tawyly tienehon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Paikayba tâjikagueday myani Jesus kau âzenahunguely nhedyly. Papaem Deus Ispiritury xytâguyly nhonwa. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aituo kau oday Deus itanru indadyly lâpylâ: — Ymery âmâ, toenzepa kâinwyneguyly; toenzepa womazeâni âmâ — kely Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aituo Deus Ispiritury Jesus nhadyly âji âdy peba atoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Quarenta iguandyly, quarenta emedyly warâ Jesus târâ awyly. Ânguydo imeom tyewiâtuneim modope mykâinane târâ. Târâ atay Deus iduery Satanás âepanâguely. Idânârâ wâne myani anhedyly, Jesus, Deus ize ato araba aitoem. Jesus olâ myani mâkâ agueho ara anipyra. Ilâpygueduo myani anju domodo xytâguyly Jesus eydâ atoram xuahuze, idânârâ ize ato modo xuduze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","João Batista etadâbygueduo myani Jesus Galiléia eynynâ adakobâdyly, Deus itaumbyry iwâkuru egatuze. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Aguely myani: — Inepa ise idânârâ mâuntulymo Deus pymâ ton-honreim awyly. Âjityendaungâ, inakanhe amitomobyry wâgâ. Inakanhe adâjidyly imowâdaungâ warâ. Deus itaumbyry iwâkuru einwântaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aituo Jesus paru Galiléia emelay adakobâdyly. Tadakobâday azagâ uguondo nhedyly, Simão Pedro, iukonolâ André warâ. Âedâgue kanra sawâni myani akaemo, vende tientoem. Âedâ paikaji nhamelymo ume myani Jesusram âzeholymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus aguely eyanmo: — Âetaungâ. Saguhoem kanra keankâ mawelymo; iwerâ kurâ domodo ynynonroem itoem unâry egaturin-em ise âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Inepa kehoem âedâ kanra sawâto inmolymo, Jesus eynynonroem tâitomoem, Deus wâgâ tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tâtâday myani Jesus azagâ uguondo modo nhetondyly, Tiago, iukonolâ João warâ. Zebedeu imeombyry myani akaemo. Ekadybymoem tywepirymo oday; âedâ kanra sawâto kua nhedylymo, kopaelâgâroem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aituo myani Jesus akaemo ingâsedyly tynynonroem itomoem. Tunwynmo, tagâ tâwaneim modo warâ tyânzemo myani, Jesus agâ tâtâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aituo Jesus tynynonro modo agâ xidadâ Cafarnaumram saindyly. Tâzekobyzegueho oday myani Jesus idâly âtâ tâdâtâdyguyho odaji, enomedâzemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aituo idataynrim modo aguely: — Koendâ lelâlâ wânkâ merâ konomedâdyly uguely! — kelymo. Ton-honre kehoem mawânkâ aguely, adâkely tutuze tawylygue, tâzewenry ara kulâ kurâ domodo enomedâni modo arapa. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Târâ enomedâzemo Jesus atay myani uguondo kadopâgue taseim âepanâguely. Uguondo oday myani kadopâ adaenkely Jesusram: ");
INSERT INTO bkqNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","— Xina kâdynanâdâ! Tutuze urâ koendâ kehoem ânguy mawyly, Jesus Nazaré donro! Xina eon-honru etyze âetyby mawyly, tutuze urâ. Inakanhe amitaymba âmâ; Deus ingonotyby âmâ warâ — kely uguondo kadopâgue taseim; uguondo keba olâ agueim, kadopâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ton-honre kehoem myani Jesus aguely mâkâ uguondo odano kadopâram: — MYK alelâ ikâ! Adâkeonzeba ikâ! Igasegâ iweâ lelâlâ merâ uguondo odaypa! — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesus agueduo kadopâ uguondo nhapânily ton-honre kehoem. Ton-honre kehoem adaenkely. Ilâ umelâ myani uguondo odaypa egasely, idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Idânârâ etaynrimbyry modo tâsewânizemo, tuomazezemo warâ myani. Aituo âjigue aguelymo: — Iwelo modogue awâkâ konomedâdyly! Âdykâ awârâ aguely kindataymba kurâ! Kadopâ takaze kehoem awâkâ aguehobyry eon-honru. Warâ keduo, aguely âzeinwân-honly lelâ — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Inepa kehoem Galiléia eynynonro modo Jesus egary indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ilâpygueduo, Jesus egasely Tiago, João warâ agâ âtâ tâdâtâdyguyho odaypa. Simão, André warâ etyram myani idâlymo. Simão imenhundu tâwâne myani toenzepa iaturu. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jesus egawândyly tientuo, tonlo modo eyam aguely: — Toenzepa Simão imenhundu ewânu — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aituo tâwâneim eguetonra idâly. Emary wâgâ nhawâdyly, sautoem. Ilâenlâ kehoem myani iaturu inmoly. Aituo myani pekodo tyatureimbyry saudyly, ipynirymo aiese, âwinduatomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xixi âwâmpygueduo, myani tonlo modo tâwânuneim modo, kadopâgue taseim modo warâ Jesusram nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Toenzepa kurâdo âtâdyguyly Simão ety inataji, Jesus aidyly ese. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Âkelo tâzewânugue tâwânuneim modo kua tyese lâpylâ myani. Kadopâ modoram aguely: — Kurâ domodo imowâdaungâ. Ânguy wawyly adâkezeba itaungâ-ro warâ. Jesus arâ aguely myani, Deus Imery Jesus awyly tutuze kadopâ modo awylygue, awârâ xutuen-hon-ho odaji nipyra awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pealâ myani Jesus âxiguely. Âji âdy peba atoram idâly, Deus agâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tuagueduo Simão Pedro domodo Jesus târâpa awyly nhedylymo. Aituo xuize idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Deus agâ aguely ume nhodylymo. Tiontuo aguelymo: — Âdaituoka tarâ mawyly? Idânârâ âdykâ mawyly tiuntudyzemo enra — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aituo Jesus in-hoguly: — Âkealâ. Taunloem kulelâba olâ keankâ kâjigonoholy. Inoro âtâ anary iwaguepaonram, Deus xunârybyry egatuze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aituo âtâ anary Galiléia eynynonro modo einkâ adakobâdylymo. Deus wâgâ adâkeze myani âtâ tâdâtâdyguyho odakâ, kadopâgue taseim modo kua tyese warâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesus adakobâday myani uguondo iopaji saindyly. Tâjimituguelygue tâwâneim myani mâkâ. Jesus enado âzeguhoam idyly, tynrense tawyly tienehon-hoem. Aituo myani Jesusram aguely: — Pymâ, kua yese ton-honre mawyly, xutuanze. Kua yedyse âmâ watay, kua yekâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Toenzepa myani Jesus mâkâ tâwâneim intyendyly, arâ tientuo. Aituo tâmarygue MÂʼ nhedyly. Eyam aguely: — Kua âedyse urâ. Tâwânepa âmâ iweâma. Kua âetai — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ilâenlâ kehoem kua idyly. Iwâgâ pinuri peba idyly, ituby itugoenzely warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Uguondo kua tiempygueduo Jesus aguely: — Iweâma tâwâlâ idâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ânguyran-ne xirâ kua âetobyry kâzegatu — kely. — Kurâdo eynynâ Deus agâ agueinram âzehora, kua itybyem mawyly nhetoem. Kua itybyem mawyly kurâdo nhetoem, Deusram âdylâ xudugâ, kâzewenryem Moisés inweniby agueho ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mâkâ uguondo olâ myani târâpa itybyem kua tyetobyry tâgatuze lelâ. Idânârâ egary indadylymo. Awylygue, xidadâ imâsedo odakâ Jesus nâtâba awyly, toenzepa kurâdo tydâtyguyba itoem. Kurâ domodo aguipaom duay, xidadâ imeombyry oday alelâ ize awyly. Kurâ domodolâ aguely idase, nhenomedâdo xutuze warâ idâim. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iweâpa itybyem myani Jesus odopâdyly xidadâ Cafarnaumram. Inepa kehoem egary indadylymo warâ; Jesus târâ awyly nhutulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Toenzepa lâpylâ kurâdo myarâ idâypy âtâdyguybyem awylymo. Tasera tumyke kehoem, toenzepa lelâlâ âtâ odaji tâdâwântoemba lâgâlâ. Deus wâgâ Jesus aguely indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesus âtâ oday aguely ume uguondo tâwâneim adaholy. Adakobâdânry myani mâkâ. Aituo quatro eataen-hodoram adaholy sawo wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Toenzepa kurâdo awylygue olâ myani Jesus iopaji naimpyra awylymo. Pyanta oze tâgawâmpyra tawyly tientuomo myani âkulymo âtâ angawanxi tâdâkuho wâgâ adakobâdânry agâ. Jesus nhangawaym kehoem myani in-hoguylymo. Ilâ oze myani tâwâneim eguetudo wâgâlâ tasegue nhytâguyândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aidylymo tientuo Jesus tyangahu oday aguely: — Awâkâ adakobâdânry kua kânhedyly tâinwânse asaemo — kely. Aituo Jesus aguely eyam: — Idânârâ inakanhe amitobyry modo xygakeagui — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisés inweniby wâgâ enomedâni modo târâlâ myani âtâ oday ekadaymbyem. Jesus aguely tindatuomo, âpaunzedylymo: ");
INSERT INTO bkqNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","— Koendâpa awâkâ Jesus aguely! Deus nhunâguedyly kulâ awâkâ! Deus agâ âzekiba tâidyse awyly kulâ! Âdaunlo uguondo nhygakely mâkeba awârâ idânârâ inakanhe adâjitobyry modo! Deus lelâ awârâ xygakerim — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tutuze olâ myani Jesus âdy nhangahumo oday xunârymo awyly. Aituo aguely: — Arâ ywâgâ tâpaunzezeba itaungâ! Unâguedaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","— Merâ adakobâdânryam: “Idânârâ inakanhe amitobyry modo xygakeagui” uguely-ro watay, mâuntuwâbyra ise âmaemo âkealâ, âkealâba warâ auguely awyly. “Aukâ. Iguetudobyry sanâkâ. Adakobâgâ” ugueduo, adakobâdyly-ro watay olâ xutuze âmaemo, ton-honre wawyly! ");
INSERT INTO bkqNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Merâ koendâ adakobâdyly mâentuomo, xutuze âmaemo, kurâ domodo inakanhe aito xygakeze ton-honre wawyly, urâ Uguondo Kaynâpa Âetyby — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Aituo adakobâdânryam aguely: — Aukâ, iguetudobyry sanâkâ, adakobâgâ, idâ itynra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aguely umelâ kehoem koendâ idyly, saudyly idânârâ enanaynmo. Tâguetudobyry nhanâdyly, adakobâdyly, egasely, tâtyram idâly. Idânârâ âsewânilymo, iomazelymo warâ. Aituo aguelymo: — Koendonro, ton-honreim warâ Deus! Âdykâ aunlo kientaymba kurâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aituo Jesus egaseondyly. Idâondyly paru Galiléia edazekâam. Toenzepa myani kurâdo saindyly eyam, Deus wâgâ nhenomedâdoam. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Târâ tadakobâday Jesus, uguondo impostu epywado emakeim nhedyly. Levi myani mâkâ, Alfeu imery. Ekadybyem myani kurâdo impostu nhepywadodâ. Aituo Jesus aguely eyam: — Yagâ âekâ, Ynynonroem ikâ, yagâ mâsenomedâdoem — kely. Aituo Levi saudyly. Jesus agâ idâly, eynynonroem tâitoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ilâpygueduo kopae Jesus tynynonro modo agâ âwinduadylymo Levi etydâ. Dinheru impostu epywadobyry emakewâni modo, kurâdo judeu domodo izepa ato modo, Jesus aguely idase eagâ adakobâni modo warâ târâmo lâpylâ âwinduadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ âdara idyly awyly tânuagaenzemo myani. Izepa tatomo agâ Jesus âwinduadyly tientuomo, Jesus eynynonro modoram aguelymo: — Kâzewenry araba kulâ awâkâ Jesus aidyly! Dinheru impostu epywado emakewâni modo agâ, kurâ domodo inakanhe kulâ aini modo agâ warâ âxiduaji nipyra tâise awâkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aguelymo tindatuo Jesus eyanmo aguely: — Deus wâgâ auguehoem uirimpyrylâ asaemo. Tâwânuneim modo mawânkâ kua tyeni xuirim, tâwânunenry modo keba. Inakanhe aini modo igâseze kâewyly, “Inakanhe aitânry urâ” kewâni modo igâseze inkâba xirâ kâewyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","João Batista eynynonro modo, fariseu eynynonro modo warâ ezewenrymolâ mykâinane nâwinduapyra idylymo, Deus agâ adâkehoem. Aituo kurâ domodo saindyly; Jesusram aguelymo: — João Batista eynynonro modo, fariseu eynynonro modo warâ nâwinduapyra tâisemo inanry, Deus agâ adâkehomoem. Âynynonro modo olâ nâwinduapyra nipyramo, Deus agâ adâkehomoem. Âdaituoka anipyra awylymo kâzewenry agueho ara? — kelymo. Aituo Jesus eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","— Eagâmo wawyly ara, nâwinduapyra nitaymbamo ise. Eagâmopa wituo olâ nâwinduapyra isemo, Deus agâ adâkehomoem. Todohogüin-horam igâsedaymby modo mawânkâ ohogüinrim agâ tatay, nâwinduapyra nipyra, etygumo lelâ. Ohogüinrim tuduaypa ituo lelâ nâwinduapyra idylymo myara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesus eyanmo agueondyly. Nhenomedâdylymo xirâ modogue. — Âtâbâ adauguehobyry tawentâzeba âtâ iwelo sapidubygue. Âtâ sawentâdobyry tukuiduo, odopâduo, tadaugueze mawânrâ âtâbâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tâjituby vinhu etaryem xygatyby iwelo keba odaji vinhu iwelo tâkanâduneba. Tâjituby iwelo keba odaji ekanâduo, etary tadaugueze mawânrâ. Aituo vinhu apâdyly. Aypa olâ, vinhu iwelo etaryem tâjituby iwelo xygatyby odajilâ ekanâdyly watay, vinhu nhewantuo, imâem ituo warâ, tâjituby iwelo tâzepâgueze — kely Jesus. {Jesus aguely, saguho konomedâdobyry kinmohoem, iwelo konomedâdo kieinwântoem warâ. Saguhobyry mawânrâ nâseinwâmbyra iwelo konomedâdo agâ.} ");
INSERT INTO bkqNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tâzekobyzegueho oday myani Jesus tynynonro modo agâ trigu ejidy ezakâ sakadylymo. Sahuadybyem myani trigu ewily. Tâtâdaymolâ Jesus eynynonro modo trigu ewily nhasewâdyly; tâzewenkelâ aidylymo. Tâmarygue nhekyguelymo, nhagulymo idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aituo fariseu domodo ewy, akaemo aidyly tientuomo, Jesusram aguelymo: — Egâ âynynonro modo âsewanily! Trigu ewily nhasewâdylymo, nhatuguelymo warâ. Tutuzelâ âmâ, kâzewenry eynynâ kokobyzegueho oday âdy aguiento keba awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aituo Jesus aguely: — Enanâguewâdaungâ typynigueba tâituomo, kydamu Davi, eagonro modo warâ aitomobyry. Ewindymo lelâlâ myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Deus ety odaji egawândylymo. Abiatar myakâwândy mârâ ume kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru. Davi, eagonro modo warâ tytyenze tawylygue myakâwândy, Deusram xuduypy pão modo Daviram nhuduly. Kâzewenry eynynâ olâ tâise Davi domodo nedawympa. Kurâdo eynynâ Deus agâ aguenri lelâ mawânkâ tâise mârâ pão edawynrim, âkelo modo lâpylâ warâpa. Davi myakâwândy tâdawynze, tagonrodo tuase warâ. Deus olâ myakâwândy nehoguebyramo nipyra, nhedawynduomo. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tyanepa kine, ânguylâ tâzekobyzegueho oday emawyadâze. Deus tâzekobyzeguehoem anhetyby lelâlâ wâne sábado. Tâwâlâ olâ xirâ oday tâdâsemawyadâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Uguondo Kaynâpa Âetyby urâ. Âdy iwâkuru adyeseim, adyesenry warâ tâzekobyzegueho oday xuturim urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus egawântondyly âtâ tâdâtâdyguyho odaxi. Uguondo âzemapiluguedânrybe myani târâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tâlâ lâpylâ myani târâ kurâdo ewy Jesus izepaom. Jesus tiunâguedomoem kulâ aidyly enuagaeni modo xunâzelymo: — Tâzekobyzegueho oday Jesus awâkâ uguondo emary kua nhedyly watay, Moisés inweniby araba aidyly awyly aguykenre. “Deus aiedyseba ato amientai” kykenre — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aituo Jesus mâkâ uguondo âzemapiluguedânry ingâsedyly: — Âekâ xarâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mâkâ tuopaji idâduo Jesus âtâdyguyby modo nhapâiguely: — Âdaraka Moisés inweniby aguely, koendâ aguidyly, inakanhe aguidyly tâzekobyzegueho oday? Ânguylâ tâzekobyzegueho oday kâmaynoem watay, kienmakely? Tâwâlâ kingueânehonly? — kely Jesus. Ânguy olâ aguely nihoguba. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus tyewiâpaze, tytywanze warâ myani. Saguho tâzewenrylâ ize atomo kuru awylygue, mâkâ uguondo nityembyramo myani. Aituo Jesus uguondoram aguely: — Âzemapiluguegâ — kely. Jesus agueduo, uguondo âzemapiluguely, emary kua ienipyryem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Awârâ tientuo fariseu domodo târâpa egaselymo. Herodes eynynonro modo ewy agâ âtunâgueze idâlymo, Jesus tyâen-hon-homoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Târâpa Jesus âxiguely. Paru Galiléia emelaji myani idâlymo tynynonro modo agâ. Toenzepa kurâdo Galiléia donro, Judéia donro warâ eagâ idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xidadâ Jerusalém donro, Iduméia donro warâ eagâ idâwânmo lâpylâ. Paru Jordão eynynonro, Tiro eynynonro, Sidom eynynonro modo warâ idâwânmo lâpylâ. Tâinkânro modo lelâba myakâwâm eagâ idânri modo, anhekyly tiuntudyze tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Toenzepa kurâdo okonodyly tientuo tynynonro modoram aguely: — Pepine nhontaungâ. Kurâdo yakabeba itoem, pepi oday ekadybyem ise kâenomedâdylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Toenzepa kurâdo kua nhedyly awylygue, tâwânuneim modo kurâdo agâ okonodylymo, Jesusram taintomoem, “MÂʼ kientuo, kua ise kurâ” tâkeduomo. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kadopâgue taseimbe lâpylâ târâ. Jesus tientuo myani enado âzeguhoam itybyem, aguelymo: — Deus imerylâ âmâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus olâ ton-honre kehoem aguely: — Ânguyem wawyly adâkezeba itaungâ — kely kadopâ modoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ilâpygueduo Jesus iwy onwa âkuly toenzepa kurâdo agâ. Akaemo ewy myani induakely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Induakewâdyby modo iopaji idâim. Doze lelâ induakely tunâry egaturin-em. — Ynynonro ise âmaemo, yagâ âsenomedâniem. Ogonodylymo olâ, Deus itaumbyry egatuze. “Jesus tunâry egatuze ingonotaymby modo” kely ise izedymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","— On-honrumo xirâ kâunduly, kadopâ mânhânkyhomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Doze lelâ induakeyby: Simão (“ ‘Pedro’ ise izedy” Jesus kehobyry) ");
INSERT INTO bkqNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago, João warâ, Zebedeu imeombyry (“Boanerges” kelygue nhezetâdyby lâpylâ asaemo, “Ton-honre tytareim” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André Filipe Bartolomeu Mateus Tomé Tiago (Alfeu imery) Tadeu Simão (Tâty anary izetonro lelâlâ tawylygue, Roma donrogue tywymâgu izepaom.) ");
INSERT INTO bkqNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas, Queriote donro (Jesus egamenribyry izepaom modoran-ro) Warâ Jesus induakewâguyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ilâpyryem Jesus egawândyly âtâ odaji tynynonro modo agâ. Târâ awyly tiuntuduo toenzepa kurâdo Jesus tiendysedonro modo myarâ idâly. Awylygue, tynynonro modo agâ âwinduatoem nudupa lâgâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesus ipemugudo awârâ tiuntuduo ese idâlymo, Jesus “Âindâam idyly” kely idanipyryem tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jesus ipemugudo saindyly ume myani Moisés inweniby wâgâ enomedâni modo Jerusalémdâpa saintybyem, Jesus wâgâ aguelymo: — Belzebu eon-honrugue kulâ awâkâ kadopâ modo nhânkyly — kelymo; kewâdylymo kulâ olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aituo Jesus akaemo arâ aguewâtyby modo tuopaji ingâsedyly. Tienomedâdomoem, Satanás eon-honrugueba kadopâ modo inwenkely wâgâ, aguely: — Satanás kadopâ niwenkewâbyra, eynynonrolâ mawânkâ. Tâwâlâ Satanás okonodyly waunlo ara kulâ tâise. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Âjigue âzety anano modo âseguebyly-ro watay, mârâ âtâ anary tadainze. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Âjipemugu âjigue kulâ âseguebylymo watay, tyewiâpadaynzemo, tâwiensemo warâ. Tagonro agâ koendâ nâzepyramo, âjidueryem tâisemo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kadopâ modo iwymâryma Satanás. Kadopâ modo âjiguelâ âseguebyly, tygue tygue idylymo warâ watay, ton-honremba tâise Satanás. Tywymâgueba tâisemo mawânkâ. Satanás eon-honrugue inkâba kadopâ modo kânhânkyly. Satanás eon-honru kainly lakuru Deus eon-honrugue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","— Uguondo ton-honreim ety odaji ânguy negawântaymba, emagaduze, tâkâjizeba mâkâ watay. Ekâjiduo lelâ isejiguy emagazedyly. Satanás eon-honrugue aini mâkeba urâ, eon-honru sainrim lakuru — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","— Deus izepa ato amânhedylymo, amyguelymo, mâunâguedylymo warâ-ro watay, idânârâ awârâ modo xygakeze Deus, mâenkadylymo-ro watay. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Deus Ispiritury ewanu wâgâ inakanhe kulâ amyguehobyry olâ ise Deus nygakeba. Arâ agueim modo aguehobyry Deus nygakewâbyra aunloenlâ. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Kadopâ agâ awâkâ Jesus” kerim modope awylygue myani Jesus arâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus aguely ume, ise, iukonodo warâ saindylymo eydâ atoram. Kuoholâ ingâsenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Toenzepa târâ kurâdo iopay ekadaymbyem awyly. Târâ mawânkâ aguehonly: — Âze, âukonodo warâ târâ inuendyly — kehonly. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aituo Jesus aguely: — Yze lelâlâ mâkâ pekodo. Konodo lelâlâ akaemo uguondo modo warâ. Tâlâ lâpylâ olâ yze ara lelâ, konodo ara lelâ warâ kâenkyly kuru — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Arâ adâkebygueduo Jesus MYK idyly, tânâmize ekadaymby modoram, aguely: — Etaungâ. Asaemo mawânkâ yze ara, konodo ara warâ kâenkyly, kâinwyneguyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Idânârâ mâkâ Deus ize ato ara aietaynrim modo mawânkâ konodo ara, koudo ara, yze ara warâ kâenkyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus kurâdo nhenomedâdondyly paru Galiléia emelay. Toenzepa myani kurâdo eydâ âtâdyguybyem awyly. Aituo ekadyly pepi sagunu iwaguepanro odaji. Kurâ domodo tâpagune lelâ paru emelay, Jesus xunâry idase. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus unâ nhegatuly, kurâ domodo tienomedâdoem, aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","— Xirâ idataungâ. Tâlâ myani uguondo trigu ewy tamuinze etâni typi ezay. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nhamuinday olâ myani tâlâ ânwa oze ihugueim. Mârâ myani konopio modoram tadaguoze. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tâlâ pylâ toenzepa tuhube atoram ihugueim, onro tâsanigueba atoram. Inepa kehoem myani târâ iazely wâne, tydâetâgueba olâ mârâ ago idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xixiram tâjiaduân-honze myani nady tyaduânse, iwindy ago ondaxi nâtâba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tâlâ myani tyguyreimpe atoram ihugueim. Tyguyreim modo, trigu modo warâ âzekiba ago tâise myani. Tyguyreim olâ ago ini kuru, trigu takaze kehoem. Aituo kopâ ihugueyby nikuiba. Aituo âdaitoem nudupa. Mârâ duay tawylygue trigu newiseba. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tâlâ myani onro iwâkuru onwa ihugueim. Tyazewâse, ago tâise, tâwiseze warâ myani. Toenzepa myani mârâ nady modo ewitunu. Koendâ kehoem myani ekaunâdyly ewy modo wâgâ cem, sessenta, trinta alelâ kehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Warâ Jesus nhegatuly eyanmo. — Xirâ unâ aguely koendâ mâuntudyze mataymo, koendâne angahumo odaji ietaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ilâpygueduo kurâ domodo idâwâdyly, Jesus aguely idanipyryem. Jesus eynynonro modo, târâ âxiânwâdyby modo warâ Jesus nhapâiguelymo: — Âdaituoka mâenomedâday unâ mâengatuly, ago lelâ amyguepa mawyly? — kelymo Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aituo Jesus in-hoguly: — Saguhoem mykâinane Deus nutuen-homba âdara idânârâ iwymâryem tâidyly. Urâlâ olâ xutuen-hoim âyanmo, âmaemoma mâindadysedonromo. Koendâ ise âyanmo kâuntuen-honly. Deus koendâ tiuntudyzebaom modo olâ unâ tâgatuzeingue lelâ kâenomedâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Agânhekyly tâensemolâ wâne, nutubamo olâ, nepyramo-ro waunlo ara kulelâ. Auguely tydasemolâ wâne, âdakeze auguely nutubamo olâ ise. Koendâ tiuntuduomo, Deus izepa ato aiedyly tumozemo tâise. Deus tâinwânsemo tâise, inakanhe aitomobyry tygakeze tâise Deus warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Alâ Jesus agueondyly: — Nady wâgâ kâengatuyby mâuntuba âmaemo watay, eagonro modo kâengatuduo mâuntuwâbyra ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Inomedâzemo nady ewy wâgâ auguehobyry ise âyanmo koendâ kâengatuly. Mâkâ nady ewy âpa ezay tamuinze etâni emyenro mawânkâ Deus itaumbyry egatuim modo. Deus itaumbyry iwâkuru pylâ awârâ nady ewy ara-ro. Onro onwa nady ewy samuin-hobyry ara lâpylâ Deus itaumbyry kurâ domodoram âzegatuoly. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mârâ nady ewy ânwa oze tamuinze etâdyby tadaguoze myani. Aituo âdy niazepa awyly târâ samuin-hobyrydâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tydasemo wâne. Inepa olâ Satanás idânârâ indatybymo nhangahumo odaypa nhetyly. Aituo pylâ Deus neinwâmpyra awylymo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","— Mârâ nady ewy onro tuhubeom onwa ihuguewâdyby inepa kehoem iazely. Iwindy modo ago ondaxi nâtâba awylygue olâ, inepa iladaynly, iguewâdyly warâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tindatyby modo tâinwânsemo tuomare kehoem. Tâzenagazeoduo olâ inepa kehoem Deus neinwâmpyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","— Tâlâ mârâ nady ewy tyguyreim duaxi ihuguewâdyby, ago tâise wâne, newiseba olâ, tuahuze mârâ tyguyreim awylygue. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo, Deus tâinwânsemo wâne. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Xirâ onro anaym adienkyly modo wâgâ kulâ olâ âseguâdâdylymo. Toenzepa âdype tâidyly kulâ, toenzepa tydinherugadyly kulâ warâ olâ ize atomo. Kurâdo tohoguedyly kulâ ize atomo. Awylygue Deus nhenanânehonlymo. Deus itaumbyry nidapyra, iwâgâ nâpaunzebyra warâ idylymo. Deus wâgâ ânguyram aguepa idylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","— Mârâ nady ewy onro iwâkuru onwa ihuguewâdyby olâ koendâ iazely, ago idyly warâ. Toenzepa ewisely. Tâlâ myani ewy wâgâ cem lelâ ewily xuduim, sessenta lelâ ewily xuduim, trinta lelâ ewily xuduim warâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo, tindakylymo lelâ nheinwânkylymo. Deus lelâ nheinwânkylymo. Ize ato lelâ anhekylymo. Iwâgâ aguelymo, toenzepa kurâ domodo nheinwântoem warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus aguely: — Âyanmo kâengatuyby koendâ mâuntudyzemo urâ. Peto tyatygueim âdylâ iaxi toentuneba, kama iaxi tyeseba, cestu iaxi tyeseba warâ. Kayanlâ kianlokuândyly âtâ oday, idânârâ nhesagon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Idânârâ unâry mâuntuba mitomoemba xirâ auguely. Koendâ kehoem mâuntuhomoem auguely. Idânârâ soentaymby modo âjiepanâgueowâze; idânârâ koendâ tydasenrybyry modo âjidahoze, keze mawânrâ xirâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Xirâ unâ koendâ mâuntudyze âmaemo watay, koendâne angahumo odaji ietaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Idânârâ auguehobyry koendâ idataungâ. Mâindatomobyry ara lelâ amidylymo-ro watay, ago kuru mâuntuhomoem inomedâdonzemo lelâ urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Imâem ywâgâ mâuntudyze âmaemo watay, imâem ise mâuntulymo. Ywâgâ mâuntudyzeba âmaemo watay olâ, âdiempa ywâgâ mâuntuybymo enanânehonze âmaemo. Utuba ise âmaemo warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aituo Jesus agueondyly. Unâ nhegatuondyly enomedâzemo: — Deus kywymâryem kuru idyly wâgâ ise auguely. Tâlâ myani uguondo nady ewy tamuinze etâni. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nady ewy tientâbygueduo myani eagonro âwanu anhekyly. Peto oday âsewanily, kopae xykyly. Eagonro ewanu anhetay, nady ewy iazely, ago itaynly. Deuslâ mârâ ago ieni, uguondo keba. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Onro iwâkuru watay, ewy samuimby tyazeze, ago tâise, tâwiseze, tahuaze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Trigu sahuaduo, sodo nhatâwâdyly, ekaunâdo odaji itybyem awylygue — kely Jesus. {Deus itaumbyry lelâ kieinwânkyly watay, ize ato ara aise lelâ kurâ. Awyara lâpylâ ise ohondybyem lelâ kydawyly kâense Jesus âewyly-ro watay.} ");
INSERT INTO bkqNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tienomedâdondomoem Jesus âkelo unâ nhegatuondyly myani eyanmo. Aguely: — Unâ segatuji wao âdara Deus kywymâryem lelâlâ idyly awyly mâuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tutuzelâ âmaemo, idânârâ nady ewy modo takaze kehoem mostarda ewy imeimbyryem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tâtâduo olâ tyazeze, kaynâ kehoem ago tâise, eagonro modo etâdaymby modo takaze kehoem ago tâise; imâsedo modoem kehoem tywatazeze warâ. Awylygue tawâguneim modo iwatary wâgâ tâty anhetoem nhuduly — kely Jesus. {“Myara lâpylâ saguhoem kuru aguipa kurâdo kulâ Deus tywymâryem awyly einwânni modo. Ilâpygueduo olâ agui idylymo” keze Jesus aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus Deus wâgâ kurâdo nhenomedâdyly, unâ nhegatuly warâ. Nhutuhomo aralâ olâ mykâinane nhenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kurâdo nhenomedâdyly watay, âdylâ wâgâ mykâinane unâ nhegatuly. Tynynonro modo koendâ tonomedâze olâ mykâinane âdara keze mârâ unâ aguely awyly wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ilâ iguandyly ume Jesus tynynonro modoram aguely: — Paru kuyam kydâzekuâne — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aituo kurâ domodoram âsedaengulymo. Pepi odaji âxiedylymo, tâzekuâdomoem Jesus agâ. Kurâ domodo idâwânmo lâpylâ eagonro pepi modo oday. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Âzekuâdylymo ume myani kopâ sapezenru ton-honreim kopâ agonro adaguly. Toenzepa kehoem myani paru adahugânily, xytyânimobelâ kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mârâ aitay myani Jesus pepi ihudâ xykyly tyangahu awo wâgâ. Aituo tytylymo tiuntuduo, eynynonro modo nhuagueândyly. Adaenkelymo: — Pymâ, âwaguegâ! Aukâ! Kyiguely ise xirâ! Kytyly awyly mâempyraka âmâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aituo saudyly. Ton-honre kehoem aguely: — Arâ kehoem tadapezeinzeba ikâ! — kely sapezenruram. — Tahugâneba ikâ! Ipagugâ! — kely paru sahugânuram warâ. Agueduo tapezenremba idyly, paru tahugâneba idyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aituo myani aguely tynynonro modoram: — Tâseanezeba itaungâ. Imakezemo, ton-honre wawyly mâinwâmpyra lelâ waunlo ara lâgâlâma âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Toenzepa myani âseanedylymo, aguelymo: — Etaungâ! Sapezenru nadapezeimba itoem adyese. Paru tahugâneba itoem adyese warâ. Ânguy kuruka awâkâ eon-honru xudunri, awârâ modo anhetoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus tynynonro modo agâ paru Galiléia kuyam saindyly myani, Gerasaram. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus pepi odaypa âzetybygueduo uguondo kadopâgue taseim agâ oxiodyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tâdâzepyâdodâpa myani idâly, târâlâ âxidâdybyem tawylygue. Aunlolâ mykâinane âzekâjioly kurâdoram, korenty ferroguetogue, ton-honreingue kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Toenzepa wâne mykâinane nhemakâjilymo, in-hugâjilymo warâ. Mârâ tâkâjiho tukagâze lelâ olâ mykâinane mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Iwy tâtaguneim modo igueypy etadâdo odakâ mykâinane adakobâdyly. Peto oday, kopae alelâ mykâinane tâinkâ adakobâdyly. Aunlolâ mykâinane saenlu, tâwâlâ kulâ tuhugue âdyâly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aituo myani iwaguelâ Jesus nhedyly. Eyam tâgase kehoem idâly. Inepa kehoem âzeguhoam idyly Jesus enado. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Arâ aituo Jesus aguely mâkâ odano kadopâ modoram: — Igasewâdaungâ merâ uguondo odaypa. Merâ uguondo kâzenagazedaundâ — kely. Agueduo uguondo adaenkely. — Ynanâdâ, Jesus, Deus Ton-honreim Imery! Ienagazenehomba mitoem âyam kâenkadyly — kely myani uguondo kadopâgue taseim. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Arâ adaenkeduo myani Jesus aguely eyam: — Ânguyka izedy? — kely. — “Aguiom” xina ezedy, agui tawylygue — kely mâkâ kadopâdo iwymâry uguondo oday. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kadopâ uguondo odano agueondyly: — Xina xirâ âjidâpa kâzejike — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tâlâ myani târâ iwaguepa toenzepa pâsega âwinduani modo iwy wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aituo myani kadopâ modo aguely Jesusram: — Awâkâ pâsega modo iodaxilâ xina igonokâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Agueduo Jesus eyanmo aguely: — Tâwâlâ, idâwâtaungâ iodaximo — kely. Aituo myani uguondo odaypa egaselymo. Pâsega iodaxi pylâ egawândylymo. Toenzepa myani pâsega târâ awyly, azagâ mil awârâem. Kadopâbe tâituo myani pâsega modo enuimbadaynly. Egatudylymo. Iwy wâgâpa adamunedylymo paikaji. Idânârâ kehoem tyense, iguewâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pâsega eni modo iwy wâgâpa pâsega paikaji adamunedyly emâmomy. Mârâ tientuo, âwenkelymo. Inepa kehoem idâlymo xidadâram. Poji anakâ takadaymo, tonlo modoram nhegatulymo pâsega modo aitobyry. Xidadâram taintuomo tonlo modoram nhegatulymo lâpylâ. Arâ egary tindatuo myani xidadâ odano modo aityby ese idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesusram saindylymo. Târâ uguondo kadopâgue taseimbyry kua ietybyem, âzetydâdybyem warâ nhedylymo, saguhobyry araba, ekadybyem, koendâ lelâ xunâgu warâ. Arâ mâkâ tientuomo, toenzepa âseanedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesus aidyly etaynrimbyry modo âdara aitobyry awyly tâgatuzemo myani. Jesus mâkâ uguondo kadopâgue taseim kua nhetobyry, pâsegado paikay nhetayn-hombyry warâ nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Awârâ tindatuo Jesusram aguelymo: — Âxiguegâ xina ety anaymba. Taynynâ inkâba ikâ — kelymo, Jesus tâguy pâsega nhaindyseba tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Agueduomo myani Jesus idâly pepi odaji ekaze. Aituo myani uguondo kua ityby aguely eyam: — Idâze urâ agâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesus olâ warâ aguely: — Atâlâ ikâ. Itynralâ odopâgâ. Âmâem koendonro Deus anhetyby egatura âpemugudoram — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aituo myani uguondo idâly. Dez Xidadâ anakâ myani Jesus kua tyetobyry egatuze. “Jesus kua yedâ” kely tindatuomo toenzepa âsewânilymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aituo Jesus tynynonro modo agâ mârâ paru nhekuâdondylymo. Toenzepa myani kurâdo iose idâly mârâ paru emelaji. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eagâmo aguely ume âtâ tâdâtâdyguyho iwymâry Jairo, Jesus iopaji saindyly; âzeguhoam idyly enado. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jesusram aguely: — Inoro wao ietyram. Iexiry iguely mârâ. Ytyengâ wao — kely. — Nhonwa imary MÂʼ ietâ wao, kua itoem, niguepa itoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aituo Jesus eagâ idâly. Idâday, taynâ, tâynâ warâ tadakabezelâ kehoem kurâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kurâdo duay tâlâ myani pekodo tâwâneim. Imery etary myani âunkeim; kuapa idyly agâ toenzepa iunu ihuguely, toenzepa lelâlâ. Doze anupe myani mâkâ arâ ewânu. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tâpyneândylygue idâzesedyly kua kyeni modoram. Tâwâense nhepywadyly, kua nipyra-ro warâ. Âdara tienwiândyly awyly nutubamo olâ mykâinane. Toenzepa kua kyeni modo epywanibyryem myani mâkâ pekodo, tâsewiândoem wâne, inakanhe idyly lakuru olâ myani, tydinheruguepa idyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","“Kua kyetâ Jesus” kely tindatuo myani aguelymo tindatobyry aralâ tyangahu oday xunâzely: — Ety MÂʼ kânhetuo, kua ise lelâ urâ — kely. Aituo kurâ domodo duakâlâ Jesus ikaingâ saindyly. Eyam taintuo, ikaynâ ety iwâmudâ MÂʼ nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ety MÂʼ nhedyly umelâ kehoem myani iunu ihuguely epagudyly. Jesus kua tyeni awyly xutuwânmy. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Awârâ umelâ kehoem lâpylâ Jesus nhutuly, ânguylâ kua ienipyryem tawyly. Aituo âsemyombâdyly kurâdo tientoem. Aituo kurâdoram aguely: — Ânguyka enra iety MÂʼ yeni? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aituo Jesus eynynonro modo in-hogulymo: — Egâ, toenzepa kurâdo okonodaynlymo onwa. Agui asaemo ewy ity MÂʼ nietai — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Âdakepa olâ Jesus enuaguynru lelâ, ânguy tâty MÂʼ ienipyry awyly tientoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kua itybyem tawyly tiuntuduo mâkâ pekodo tyanugue, tapâne kehoem Jesus enadoam saindyly, âzeguhoam idyly, aguely: — Ity MÂʼ ienipyryem kua witai — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aituo Jesus aguely pekodoam: — Kua itybyem âmâ, kua kyetâ wawyly mâinwântobyry wâgâ. Idâ lelâ ityam. Awârâ aunlogue, tâwânepa ise âmâ iweâma — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus aguely umelâ Jairo ety donro modo saindyly; Jairoram aguelymo: — Ipa ixiry nigueaki! Itynra âdaiseba kulâ Jesus kadadâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jairoram aguelymo idanipyryem tawylygue Jesus aguely: — Tadahulizeba ikâ. Yeinwânkâ — kely Jairoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pedroram, Tiagoram, iukono Joãoram warâ Jesus aguely: — Âmaemo lelâ ise yagâ idâim. Eagonro modo nâtâba ise — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aituo myani Jairo etyram saindylymo, egawândylymo. Egawântybyem myani Jesus, tonlo modo âwynsaundo epyâdoem on-hondylymo nhedyly. Tâguepymo eongüendylymo, âpyneândylymo warâ nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aituo myani Jesus aguely: — Âdaituoka ogunrumo, mâpyneândylymo warâ? Niguewâpyra awâkâ âwynsaundo; xykyly kulâ — kely. {Arâ aguely, kurâem tientondyly tiuntuduo.} ");
INSERT INTO bkqNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Arâ aguely tindatuomo nheinledylymo. Igueypyem lelâlâ awyly tiuntuduomo, nâepaigueba awylygue. Aituo Jesus aguely: — Kuohoram igasewâdaungâ wao. Âwynsaundo nhunwym, ise, Pedro, Tiago, João alelâ yagonro nidâ — kely. Agueypyem myani Jesus eagâmo egawândyly igueypy ejidyram. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tâgawâmpygueduomo myani igueypy emary wâgâ sawânipyryem, Jesus aguely: — Talitá kumi — kely. (“Aukâ, âwynsaundo” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Adâkehonly umelâ kehoem myani âwynsaundo âepaigueondyly, kurâem itondyly. Kama wâgâpa saudyly, adakobâdyly idyly. (Doze anupe myani âwynsaundo.) Adakobâdyly tientuo myani enipyry modo âseguâdâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aituo Jesus aguely: — Ânguyran-ne tarâ aityby kâzegatuwâdaundâ — kely. Âwynsaundo sodo modoram, — Xuataungâne merâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Cafarnaumdâba Jesus âxiguely. Tynynonro modo agâ xidadâ Nazaréram odopâdyly, tânamadobyryanlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tâzekobyzegueho oday âtâ tâdâtâdyguyho odaji idâly. Târâ Deus wâgâ aguely, kurâdo enomedâze. Toenzepa aguely idani modo âseguâdâdylymo. Aituo aguelymo: — Koendâ Deus wâgâ tutuze lelâlâ awâkâ uguondo; kiuntuba olâ kurâ âdykâ awârâ nhutuhobyry awyly. Toenzepa awâkâ enomegu, kiuntuba olâ kurâ ânguy enomedânibyry awyly. Adyesenry modo adyese lelâlâ; kiuntuba olâ kurâ âdara awârâ modo anhedyly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mure, mesa, awârâ modo segue xygahudâni Maria agâ imery kulâ mawânkâ; Tiago, José, Judas, Simão warâ iwaigoru kulâ awâkâ. Eaundudo tarâ kuduaylâ inanry kyjidadârydâlâ — kelymo. Jesus iamugâry enipyry tawylymogue, Deus Ingonotyby mâkâ awyly neinwâmpyra awylymo. Aguely tindadyseba awylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aituo myani Jesus aguely: — Unâ egatuim tâty anaym, unâ nhegatuduo ipemugudoram nâzeinwân-honwâbyra; âkelo âtâ anano modo kulâ einwânni — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Neinwâmpyra tawylymogue tonlo modo Jesusram nâtâba awylymo. Aituo âdiempa kulâ adyesenry modo târâ anhedyly. Aguipa kulâ tâwâneim tâmarygue MÂʼ nhekyly, kua tientoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Toenzepa myani âpaunzedyly, agui târâ Nazarédâ tâinwântânry modo awylygue. Ilâpyryem myani Jesus kurâdo nhenomedâdyly âtâ anary imeombyry anakâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akaemo doze tynynonro modo igâsemâmy, Deus wâgâ agueze tingonotomoem. Azagâ myarâ, azagâ myarâ, azagâ myarâ warâ myani ingonodylymo. Kadopâ nhânkyhomoem eon-honrumo nhuduly. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Egaselymo iraynâ aguely: — Unâ idataynrim modolâ ise âdy ize matomo xudunri. Pyni, dinheru, âsejiguymo etary warâ kadataundâ. Amatagorumo lelâ sataungâ, ânwa oze mâzesebydâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Owogonromo lelâ itymo sataungâ; âhurumo etary mâungukehomo kadataundâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Âtâ anaxi aintuomo, saguhoem âgâsenimobyry etydâlâ itaungâ. Târâlâ âykywâdaungâ, eagonro âtâ anaryam mydâlymo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ânguy idaenkubamo, amyguelymo tindadyseba warâ atoram aindylymo-ro watay, inepa igasewâdaungâ. Târâpa igasedaymo, âhurumo etary etywâdaungâ, xutoleguguewâdaungâ warâ, Deusram tânagazezeim awyly xutuhomoem, ize ato ara anipyra awylymogue, yeinwâmpyra awylymogue warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aituo eynynonro modo Deus itaumbyry egatuze idâlymo. Alâ myani tâtâhobyrydâ aguezesedylymo: — Âjityendaungâ Deus xurâem inakanhe amitomobyry wâgâ. Inakanhe Deus xurâem amitomo imowâdaungâ. Aguely kadakadaundâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kadopâ tyânkyzemo mykâinane. Toenzepa kurâdo tâwânuneim modo nhangahu onwa azeiti tyesemo mykâinane warâ, kua tientomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesus anhekyly modo egary idamâmy pymâ Herodes, tâinkâ lelâba Jesus wâgâ aguelymo awylygue. Tâlâ wakenri modo: — João Batista kurâem itondyby keanra awâkâ Jesus. João kurâem nitondâ. Awylygue eon-honru adyesenry modo aiese — keim. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tâlâ lâpylâ wakenri modo: — Mâkâ keba awâkâ. Elias awâkâ Jesus-em ini — keim. Tâlâ pylâ, — Mâkâ keba awâkâ. Saguho modo Deus itaumbyry egatuwânibyry ewy kurâem ityby awâkâ Jesus — keim. Warâ myani aguelymo, ânagadoem kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ânguyem Jesus awyly wâgâ aguelymo idamâmy Herodes. Aituo myani aguely: — João Batistama igueypyem, xiangasagâneho mawânkâ, Jesus-em olâ âepanâguely iwerâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Âdara João xyâhobyry awyly ise kâengatuly wao. Herodes myani Herodias agâ tohogüinze, tukono Filipe iwydyem awyly umelâ. Alâ mykâinane João aguezesedyly eyam: — “Kukono iwydy agâ todohogüinly lâpeba” kelype Moisés inweniby wâgâ — kezesedyly. Awylygue myani Herodes tyzodadury modoram aguely: — João Batista sawâtaunda. Emakâjiwâdaungâ, etadâdaungâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias myani João izepa, tyâen-honly mykâinane ize ato. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","João xyâen-honze tyane olâ myani Herodes, uguondo koendâ lelâ aini mâkâ awyly, tutuze tawylygue. Deus ize ato ara lelâ aini João awyly tiuntulygue lâpylâ warâ. Awylygue myani nhetadânehonly lelâ. Alâ mykâinane Herodes xunâgu João agâ. Ize ato mykâinane João agâ tâdunâgu. João aguely tindatuo, âdy adienkyly awyly nutuba idyly mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Alâ myani Herodias âdara João tyâen-honly awyly nhutuly. Herodes tyazehobyry nhetyguedyly myani. Idânârâ pymâ domodo, sodadu iwymâry modo, uguondo tâgaruneim modo warâ tygâseze myani. Idânârâ myani âzetyguedylymo Herodes agâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Âwinduadylymo ume myani Herodias exiry âise egawândyly nhetomoem, iomazeânzemo. Âidyly tientuo myani Herodes, eagonro modo warâ toenzepa kehoem nhehoguedylymo. Aituo myani eyam aguely: — Tâwâlâ âdylâ ize mato ekagâ; xuduze lelâ urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tâwâlâ ise Deus ienagazedyly, mâenkadyby kâundupa urâ-ro watay. Pymâ ton-honreim urâ. Âdypeom urâ. Idânârâ tâlâ wato epajiwâze urâ, ize matay — kely âwynsaundoam. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aituo myani mâkâ âwynsaundo tyze agâ agueze idâly. — Âdyka ise kâenkaguyly? — kely. — João Batista nhangahu ekagâ; ilema ise xarâ mâenenehonly-ro warâ — kely ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aituo myani mâkâ âwynsaundo odopâdyly pymâ Herodesram. Aguely myani: — João Batista mânhagasagânehonly ize wato. Iweâma ise nhangahubyry mâenenehonly prato oday xarâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Awârâ tindatuo toenzepa kehoem myani pymâ Herodes itynwandyly. Tingâsedyby modo enanaym adâkehobyry awylygue olâ myani anhenehonly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aituo myani sodadu kyârim ingâsedyly, eyam aguely: — João nhangasagâda. Nhangahubyry xarâ enekâ-ro warâ — kely. Aituo myani sodadu idâly João etadâdobyryam nhangasagâze. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ilâpyryem myani nhangahubyry prato odaji nhedyly, nhadyly âwynsaundoam. Âwynsaundo myani tyzeram xuduim. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aituo myani João eynynonrobyry modo xyâhobyry egary indadylymo. Tiuntuduomo myani eguepybyry ese idâlymo. Nhadylymo. Tuhu esagueyby odaji nhetadâdylymo warâ. Awârâ wâgâ myani Herodes âpaunzedyly. Awylygue myani “João keanra awâkâ Jesus” kely tyangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesus xunâry egatuze igonotaymby modo todopâdaynzemo myani. Odopâdybyem adientaymby modo, tienomedâdaymby modo warâ Jesusram nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Toenzepa Jesus tynynonro modo agâ atoam, kurâdo saindyly, egasely warâ, Jesus tynynonro modo agâ koendâ âwinduatomoemba. Aituo tynynonro modoram Jesus aguely: — Inoro âji âdy peba atoam. Ekozeybyem mataunaze adakobâzezedybyem. Âetaungâ yagâ. Ikobyzeguewâdaungârâ wao — kely. — Inoro pylâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aituo Jesus tynynonro modo agâ pepi oday âdy peba atoram idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kurâdo olâ pepi oday idâlymo tâense-ro warâ. Awylygue Jesus tynynonro modo agâ âdykâ awyly nhutulymo. Aituo tysegoze idâlymo tuhuru wâgâ, paru nhere. Waunroenlâ saindylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pepi odayba itybyem Jesus toenzepa kurâdo tynwânwâni modo nhedyly. Akaemo tytyenze myani Jesus ânguy Deus wâgâ nhutuhomoem aguenri peba awylygue. Kanerudo eni pebaom aramo mawânkâ. Aituo Deus wâgâ kurâdo nhenomedâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Iguandyly ume Jesus eynynonro modo eyam saintaynly. Aituo aguelymo: — Iguandyly enra. Âdykâ pyni xuiho lâpeba tarâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Asaemo igonokâ âpa ezaji, pyni xuize, âtâ anary iwaguepaonram warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus olâ aguely: — Nâtâwâbyramo ise. Âmaemolâ ipynirymo âunduwâtaungâ — kely. — Arâ xina anipyra ise enra! Toenzepa dinherupe-ro watay lelâ tâise, duzentas moedas prataguetogue lelâ merâ idânârâ ipyniry adanâdyly. Âdy peba xina-ro warâ — kelymo. {Tokalâ iguandyly âwanopyry epywado mawânrâ myani tokalâ moeda pratagueto.} ");
INSERT INTO bkqNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aituo Jesus aguely: — Âdara pãobeka akaemo? — kely. Aituo xutuze idâlymo. Odopâdybyem Jesusram aguelymo: — Cinco pão, azagâ kanra âjihuyby warâpe — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aituo Jesus aguely: — PU târâ, PU târâ warâ ikadaungâ âji koendonrodâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kurâdo idânârâ ekadaynly PU târâ, PU târâ, PU târâ warâ cem, cinquenta warâ âzepajiwâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aituo Jesus cinco pão, azagâ kanra âjihuyby warâ nhanâdyly tâmaxi. Sanânibyryem, kayam MYK idyly. Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai, awylygue xinaem xirâ pão, merâ kanra warâ mâunduly — kely. Ilâpyryem pão nhepajiwâdyly, tynynonro modoram nhuduly, kurâdoram nhepâdomoem. Nhepâdylymo umelâ kehoem Jesus pão epajiwâdyby, agui nhenehonly. Azagâ kanra âjihuyby nhepajiwâdyly tynynonro modoram nhuduly lâpylâ myani, kurâdoram nhepâdomoem. Nhepâdaymolâ kehoem kanra âjihuyby agui idyly lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ize tato ara kehoem idânârâ kurâdo âwinduadyly; kanra âjihuyby nhâdylymo, pão nhedawynlymo warâ. Koendâ kehoem iolataynlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ilâpygueduo myani Jesus eynynonro modo pão, kanra âjihuyby warâ âsegubydâdyby nhekanâdylymo cestu imâsedo modo odaji. Doze cestu tumyke âsegubydâdyby nhuduly. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Toenzepa myani âwinduani modo, cinco mil uguondo modo lelâ, toenzepa lâpylâ pekodo modo, iamimeom warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ilâpyryem Jesus tynynonro modoram aguely: — Âxiedaunda pepi odaji. Idâwâtaungâ paru kuyam kurâdo Betsaida donro modoram. Tarâ asaemoram âsedaengüybyem ise oiosemo udâly — kely. — Idâze lelâ xina — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tonlo modoram tâsedaengubygueduo, Jesus iwy onwa âkuly, Deus agâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iguampygueduo, Galiléia iwalu iotay pepi odano modo; mâkâ kulelâ myani Jesus târâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesus iwaguelâ nhedylymo. Kura kehoem inkâguelymo eon-honrugue, nhonwamo adapezeinly awylygue. Emedyly wâgâ, aukuma igâtuduo myani Jesus idâly eyanmo. Sakazemo kely ume myani, ");
INSERT INTO bkqNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","paru wâgâ adakobâdyly nhedylymo. “Kadopâ” tâkewâduo adaenkelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jesus olâ myani eyanmo aguely: — Âzeon-hondâdaungâ. Tâseanezeba itaungâ! Jesuslâ urâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aituo pepi odaji âxiedyly. Âxieduo, tapezenremba idyly. Awârâ tientuomo, toenzepa kehoem âseanedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesus pão, kanra warâ agui tienehonduo, enehonwâm, Deus Ingonotyby tawyly. Awârâ anhetuolâ ânguy Jesus awyly nutubamo olâ myani. Awylygue mawânkâ nutuba awylymo, âdara mâkâ paru wâgâ adakobâdyly awyly, ago lelâlâ Messiaslâ mâkâ awyly neinwâmpyra tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesus tynynonro modo agâ paru nhekuâdylymo. Genesaréram saindylymo. Saintybyem, pepi nhekâjilymo sagunu wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesus âzetyly umelâ myani kurâdoram âdutuoly, aguelymo warâ: — Etaungâ. Awâkâ mawânkâ Jesus! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Inepa kehoem tonlo modo xuruse idâwâdylymo, “Jesus naintai” keze. Târâ tawyly ume, eagonro âtâ anakâ idâwâm lâpylâ Jesus, tynynonro modo agâ. Tâtymo anaxi Jesus saintybyem awyly tiuntuduo, tonlo modo tâwânuneim modo eguetudo wâgâ eyam nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Âdyam idâhobyrydâ, tonlo modo, tâwânuneim modo tasemo lelâ Jesus kua nhetoem. Eyam nhekadylymo: — Ity owogonro wao MÂʼ ienehongâ asaemo tâwânuneim modoram, kua itomoem — kelymo. Idânârâ tâty MÂʼ ienipyry modo ara kua tyese myani. Arâlâ myani aidylymo xidadâ imeimbyry odakâ idâduo, xidadâ imâsedo odakâ, âtâ anary imeimbyry modo odakâ lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aituo fariseu domodo ewy, Moisés inweniby wâgâ enomedâni modo warâ Jerusalémdâpa idâlymo Jesus eydâ atoam. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Âjigue aguelymo: — Etaungâ Jesus eynynonro modo aidyly. Kydamudo ezewenrypyry araba kulâ akaemo aidyly. Kâzewenry ara nâzemaunguewâbyramo, tâwinduatomoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Judeu domodoma tâzewenry saguhobyry nimopa, fariseu domodo sahogueni kuru. Agaityom modo aitobyry aralâ aidylymo. Âzemaungueybyem lelâ âwinduadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tianâtybymo tugokezemo lelâ, tydâlâseim, tâinzeim warâ tugokezemo, âmugâ, kudupi, awârâ modo sagokely wâne myara. Saguho modo ezewenry nimopamo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Awylygue myani fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâ Jesusram aguelymo: — Kydamudo ezewenrypyry ara inkâba âynynonro modo aidyly. Tâwinduatomoem nâzemaunguewâbyramo kâzewenry ara. Koendâpa akaemo awârâ modo inmoly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aituo Jesus eyanmo aguely: — “Deus tâinwânse xina” tâkeze wâne âmaemo; âtuahuze kulâ olâ amyguelymo. Âwâgâmo Deus aguehobyry iweniwânmy Isaías: “ ‘Tytanrugue ywâgâ koendâ adâkezemo. Tuodaxi niepyramo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ywâgâ koendâ adâkezemo wâne, tâzewenke kulâ olâ kurâdo nhenomedâdylymo, augueho araba’ kely Deus” kely myakâwândy Isaías inwenily — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Aituo myani Jesus agueondyly fariseu domodoram, Moisés inweniby wâgâ enomedâni modoram warâ: — Deus ezewenry tutuze wâne âmaemo, uguondo modo ezewenry kulâ olâ amânhekylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Saguhobyry modo aguehobyry kulâ mâinwânkylymo, Deus aguehobyry mâkeba. “Deus aguely tâinwânse xina” tâkewâze wâne âmaemo, mâinwâmpyra olâ âmaemo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tâlâ myakâwândy Deus aguehobyry Moisés inweniby wakely: “Unwânmo, âzemo warâ einwântaungâ. Ipa atomo eyanmo âunduwâtaungâ” kewândymy Deus. “Tunwym, tyze warâ âsenagazedoem Deusram ekani xyâwâtaungâ” kewândy lâpylâmy warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Âmaemo olâ aypa mâenomedâdomo. “Unwânmo, âzemo warâ âdylâ nhekadyly watay, ‘Tâlâ wato Deusram ise kâunduly. Awylygue âdy âyanmo kâundupa wawyly’ kewâtaungâ” myguelymo. Alâ kulâ mâenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Arâ mâenomedâduomo, Deus itaumbyry idadyly mâinmolymo, amyguehomobyry lelâ mâinwântomoem. “Âmeonmo enomedâdaungâ xina aguehobyry ara” tâkeze âmaemo. Inakai modo adyese âmaemo — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aituo Jesus kurâ domodo ingâsedondyly, eyanmo adâkehoem: — Idataungâ, xutuwâdaungâ xirâ augueho. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mâimpymo mâkeba Deus agueho mankadomoem aieni; mâimpymo odaymopa tâgaseze mawânrâ. Deus izepa ato amânhedyse mawylymo mawânrâ Deus xurâem tywykeim; angahumo odaylâ mawânrâ awârâ âtugudyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Xirâ unâ koendâ mâuntudyze mataymo, koendâ angahumo odaji ietaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eyanmo aguenripyryem Jesus kurâdodâpa âxiguely. Egawândyly âtâ odaji tynynonro modo agâ. Tâgawâmpygueduomo nhapâiguelymo: — Âdara kezeka enra mârâ amyguely? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Aituo Jesus aguely: — Iweâpa wâne yagâ mawylymo; kurâdo ara lâpylâ olâ mâuntuba mawylymo! Auguely wâne mâindadysemo wato. Âpynirymo mâkeba Deus izepa ato aienehoim. Eimpy mawânrâ kuwe odaxi idâly, ilâpyryem pylâ kokomiry odaxi-ro warâ. Awârâ modo odakâ sakadybyenma egasely lelâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aituo agueondyly: — Kyangahu oday mawânrâ kydâpaunzedo, aguiendyse kydato, aguykeho warâ âtugudyly. Awylygue angahumo odayba âeni Deus izepa ato aienehonrim awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Angahumo oday Deus izepa ato amânhedylymo wâgâ tunâgue âmaemo. Arâ amidyse âmaemo watay, eagâ mohogüin-homobyry keba kulâ mâynanâdyze midylymo; imagadudyze midylymo; kurâ mâyândyse midylymo; âkelo iwydy mâynanâdyze midylymo; toenzepa âdype midyse mawylymo; âkelo xurâem inakanhe amidyse midylymo; tâdâsenogudyly myguedyse midylymo; âkelo isejiguybe midyse mawylymo; âkelo mâunâguedyze mawylymo; âkelo modo takaze kehoem mâdutudyze midylymo; amidylymo, amyguelymo warâ âdy mâuntubamo kulâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Idânârâ inakanhe adâjito angahumo odaylâ mawânrâ âtugudyly; awârâ modo mawânrâ Deus xurâem tywykeinhe âenehoinmo. Tâdâzemaunguebalâ tâdâwinduadylyma Deus xurâem inakai mâkeba-ro — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tonlopyryem Jesus idâly myani xidadâ Tiro iwaguepaom yan-yam. Saintybyem egawândyly âtâ odaji. Târâ Tiro oday tawyly nhutudyzebamo wâne myani Jesus; inepa olâmy târâ awyly xutuwânmo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Târâ xidadâ oday tâlâ myani pekodo exiry kadopâgue taseim. Jesus saintybyem awyly tiuntuduo, mâkâ ise eyam idâly, âzeguhoam idyly enado. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Âkelo anano myani mâkâ; Judá donro keba. Feniciadâ egaseyby, âtâ anary Síria eynynâ. Enado âzeguhoam itybyem aguely: — Pymâ, iexiry odayba kadopâ nhânkygâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus aguely: — Tâwâlâ iamimeom nâwinduadâ saguhoem. Koendâ inkâba iamudo ipyniry emakely, kaxorodoram xuduhoem — kely. {Awârâ adâkehogue, koendâ inkâba judeu keba modoram, judeu domodo xurâ xuduly. “Judeu domodo kua kânheto iwerâ. Judeu keba modo kua kânhedyly-ro watay, iamimeom pãogue kâenmakely, kaxorodoram kâunduhoen-ro waunlo ara ise” keze aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Âdakeze aguely awyly xutuwâm olâmy mâkâ pekodo. Aituo aguely: — Arâlâ, Pymâ. Iamimeom mesa iaxi pyni in-hugueânehoymby tâinze olâ kaxoro imeombyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","— Arâ amyguehobyry wâgâ yeinwântâ mawyly tutuze urâ. Awylygue enra ixiry odaypa kadopâ kânhânkyly. Tâwâlâ itynra odopâgâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Agueduo myani pekodo tâtyram idâly. Saintybyem tâxiry kua itybyem awyly nhedyly. Koendâ lelâ tykyho wâgâ eguetudybyem awyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aituo Jesus egasely Tirodâpa. Sidom einkâ, âji Dez Xidadâ kelygue tâzekeim einkâ warâ sakadyly. Paru Galiléia emelaji myani idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uguondo kydatânry, koendâ âjitaindânry warâpe myani târâ. Eataen-hodo Jesusram nhadylymo myani, aguelymo eyam: — Ityengâ wao merâ uguondo. MÂʼ iekâ wao, kua itoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Agueduomo, Jesus âdiempa kurâdo duaypa nhejikely. Tâmary ewily iwantary onwa nhedyly. Ilâpyryem KUITÚ kely. Tâdaku âdiempa uguondo ilu onwa nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ilâpyryem kayam MYK idyly. Tunwym agâ aguely. Ton-honre kehoem âepaiguely, aguely: — Efatá — kely. (“Âzenahunguegâ” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mâkâ aguepygueduo, inepa kehoem myani uguondo koendâ indadyly, âjitainly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus aguely kurâdoram: — Ânguyran-ne xirâ kâzegatuwâdaundâ — kely. Aguehobyryenlâ olâ tâinkâ lelâba nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jesus egary tindatuomo toenzepa myani âsewânilymo. — Koendonro lelâlâ mâkâ! Kydatânry modo indatoem adyese, tytarenry modo âjitain-hoem adyese warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ilâpyryem iweâpa nipyralâ kurâ domodo Jesus aguely idase âtâdyguyondylymo. Âdygue typyniguebamo myani. Arâ awylymo tiuntuduo, Jesus tynynonro modo ingâsedyly. Eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","— Ytynroem enra asaemo kurâdo. Kopaelâgâbygueduolâ keankâ yagâ awylymo. Âdy nheinlymo peba-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taypa âetybybe asaemo duay. Koendâpa ise nâwinduapyralâ etymoram kingonodylymo. Arâ kâingonodylymo-ro watay, ekozezemo tâwindygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aituo Jesusram eynynonro modo aguely: — Kuantomoem nudupa lâpylâ enra, iwague xidadâdâ kydawylygue. Asaemo xuato âdykâ imâem pyni kiempyra ise kydaze — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aituo Jesus aguely: — Âdara pãobeka âmaemo? — kely. — Aituo in-hogulymo: — Sete lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aituo kurâdoram aguely: — Ikadaungâ — kely. Mârâ sete pão sanânibyryem, Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai. Awylygue xirâ pão mâunduly — kely. Deus agâ agueypyem, pão nhepajiwâdyly. Tynynonro modoram nhuduly, kurâdoram nhepâdomoem. Nhepâdylymo umelâ kehoem Jesus pão epajiwâdyby agui nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tâlâ lâpylâ myani aguipa kanra imeombyry âjihuyby. Jesus agueondyly Deus agâ: — Koendonro lelâlâ âmâ, Pabai; awylygue xinaram merâ kanra mâunduly — kely. Deus agâ agueypyem myani tynynonro modoram Jesus aguely: — Epâdaungâ merâ kanra kurâ domodoram — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Idânârâ âwinduadylymo ize tato ara kehoem, koendâ kehoem ioladylymo warâ. Ilâpyryem Jesus eynynonro modo cestu imâsedo modo odaji âsegubydâdyby modo nhekanâdylymo, sete cestu tumykune lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Toenzepa âwinduani modo; quatro mil lelâ kurâdo. Ilâpyryem Jesus aguely kurâdoram: — Tâwâlâ itymoram idâwâtaungâ lelâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Agueypyem pepi odaji âxieze idâly tynynonro modo agâ. Dalmanuta yan-yam idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aituo fariseu domodo Jesus iopaji idâlymo. Tienwentâdomoem wâne inakanhe kulâ aguedyse awylymo. Aituo eyam aguelymo: — Deus lelâ anhekyly aiekâ, mâkâlâ ogononi, on-honru xuduim warâ awyly xina nhutuhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Toenzepa myani Jesus itynru, tâinwâmpyra awylymo tiuntuduo. Aituo imâem âepaigueybyem aguely: — Kurâdo ize ato ara âdylâ adyese lelâ urâ, Deuslâ ugononi awyly kâenehohoem. Deus ingonotyby wawyly kâenehondyzelâ urâ. Mâenkadybymo agânhepyra olâ ise urâ, mâkâ eon-honru keba mawânrâ mâendyse matomo, ienwentâdomoem kulâ arâ amyguelymo — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aituo myani Jesus târâpa âxiguely. Pepi odaji odopâdyly, paru tienkuâdoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesus eynynonro modo pão sadyly enanânehonwânmomy. Tokalâ kulâ myani pão nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aituo myani Jesusram âduruholymo: — Idataungâ. Tâmaynelâne itaungâ fariseu domodo, Herodes warâ ifermenturygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Âdakeze Jesus arâ aguely nutubamo olâ. Awylygue myani âjigue aguelymo: — Âdaituoka awâkâ arâ aguely? Pão kienepyra kydatobyry wâgâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus olâ aguelymo idamâ. Aituo eyanmo aguely: — Âdauguewâpyra urâ, pão mâenanânehon-homobyry wâgâ. Pão wâgâ inkâba auguely. Âdy inomedâdomo awyly mâuntuba lelâ kuru mataunaze. Deus eon-honrube wawyly mâinwâmpyra lelâ âmaemo. Âdaituoka augueho mâuntuba mawylymo! ");
INSERT INTO bkqNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Agânhekyly tâenselâ âmaemo, auguely tydaselâ âmaemo warâ. Agânhetaynly modo, kurâdo kâenomedâdo modo warâ Deus xurâlâ awyly, mâinwâmpyra lelâ olâ âmaemo. Kurâdo toenzepaom modo kânwantobyry enanâguewâdaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cinco mil uguondo modo xuadâ cinco pãogue. Idânârâ âwinduatyby modo nioladâmo warâ. Âdara cestu tumykeka mekanâdâmo âsegubydâdyby? — kely. — Doze cestu lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesus eyanmo agueondyly myani: — Quatro mil kurâdo xuatoem sete pão agui xienehoangui, âdara cestu tumykeka mekanâdaimo âsegubydâdyby? — kely. — Sete cestu lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","— Won-honru tâense lelâlâ wâne âmaemo, ânguy wawyly mâuntuba lelâ olâ âmaemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ilâpygueduo, Jesus, eynynonro modo warâ xidadâ Betsaidaram saindylymo. Saimpygueduomo, tonlo modo uguondo epy eyam nhadylymo. Jesusram aguelymo: — Xina tytyenzelâ ikâ. Merâ uguondo enu MÂʼ iekâ, nhetoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Emary wâgâ sawânipyryem Jesus epy kurâdo duaypa nhedyly. Tâmary ewily edakudânibyryem Jesus uguondo enu MÂʼ nhedyly. Aienibyryem eyam aguely: — Âdylâ tâense âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","MYK itybyem, uguondo aguely: — Âdiempa tâense wâne urâ. Se ara kulâ olâ kurâdo adakobâdyly kâendyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aituo Jesus tâmarygue enudâ MÂʼ nhetondyly. Ilâenma koendâ nhedyly idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ilâpyryem Jesus uguondo ingonodyly. — Tâwâlâ idâ ityam. Todopâzeba waone ikâ Betsaidaram — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ilâpygueduo myani Jesus, eynynonro modo warâ tuhuru wâgâ idâlymo âtâ anary modo Cesaréia de Filipe iwaguepa. Tâtâdaymo myani Jesus tynynonro modoram aguely: — Ânguy tâkezeka inanry kurâdo yam? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Warâ myani eynynonro modo in-hoguly: — Tâlâ inanry, “João Batista kurâem itondyby awâkâ Jesus” kewâni modo. Tâlâ inanry, “Elias kurâem itondyby awâkâ” keim modo. Tâlâ lâpylâ inanry, “Deus eynynâ aguewâtyby modo ewy kurâem itondyby awâkâ” keim modo warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","— Âmaemo-ro? Ânguy tâkeze âmaemo yam? — kely Jesus. Aituo Pedro in-hoguly: — Messiaslâ âmâ — kely. (“Deus Kâmakeze Ingonotyby” keze “Messias” kely.) ");
INSERT INTO bkqNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aituo myani Jesus eyanmo aguely: — Mâkâlâ urâ. Iwerâ kuru wao olâ Messiaslâ wawyly kâzegatuwâdaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aituo myani Jesus tynynonro modoram aguely: — Urâ Uguondo Kaynâpa Âetyby toenzepa âsenagazeze urâ. Kywymâry modo yizemo inkâba ise. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ ienagazenehonzemo. Akaemo ise yiguehoem aienehoim. Yigueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kulâkâba kehoem myani Jesus iguein-em tawyly nhutuen-honly. Pedro olâ myani neinwâmpyra arâ Deus Ingonotyby âdyoly awyly. Awylygue myani nhejikely, eagâ adâkehoem: — Pymâ, arâ adâkezeba ikâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aituo Jesus MYK idyly, tynynonro modoram. Pedro aguehobyry nehoguebyra, tawylygue myani aguely: — Satanás arâ amyguehoem aieni, Pedro. Deus xunâry ara inkâba âunâgu, uguondo modo xunâry ara kulâ. Satanás aguely kâindataymba ise urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aituo Jesus kurâ domodo, tynynonro modo warâ ingâsedyly, eyanmo aguely: — Ynynonroem ize mataymo, augueho ara aitaungâ. Kopaelâgâembaba ize wato aietaungâ; amânhedyse matomo mâkeba aietaungâ. Kurâ tyâzeim kruz nhadyly tyâhoram myara, ynynonro modo on-hondybyem nidâ igueze. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Jesus eynynonro keba urâ” myguelymo, tyâzepa mitomoem kulâ watay, âdiempa kulâ ise xirâ anaym kurâem mawylymo. Âigueduomo Deus enadoram mydâwâpyra ise âmaemo. Yeinwândylymogue, unâry mâinwândylymogue warâ mâdyolymo watay olâ, Deus enadoram idâze âmaemo; aunloenlâ ise eagâ mawylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tâwâlâ wâne âdydo imeom sodoem mawylymo, ize matomobe mawylymo warâ, Deus eydâ atoram mydâhomoem nepywabyra olâ awârâ modo. Deus agonro keba âmaemo-ro watay, âdype matomo âdy mâkeba. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ânguy, niguepa tâitoem nepywadaymba. Tâdâsenagazedo amaxi ise mydâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Uguondo Kaynâpa Âetyby urâ. Idâze urâ Deus eydâ atoam, odopâze olâ urâ Deus dompyryem anju domodo agâ. Kodopâdyly ise Kunwym eon-honru tânehonze. Iwerâ xirâ inakanhe tadawyly ume ywypazeni, kâenomedâdo iwypazeni warâ, kodopâduo, iwypazeze lâpylâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","— Iwerâ ydataynrimbyry modo ewy Deus eon-honrugue lelâ pymâem idyly enipe ise — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis iguandyly ipygueduo Jesus iwy onwa âkuly. Pedro, Tiago, João warâ myani tagâ nhakyly. Târâ Jesus âkeloem idyly nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Toenzepa myani ety iwogonro sapeku, ehozelu warâ, âtâ igokewâni modo lâgâlâ tâise myara kehoem napekanâbyra. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Moisés, Elias warâ nhedylymo lâpylâ Jesus agâ xunâgumo ume. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aituo myani Pedro aguely Jesusram: — Koendâ kehoem tarâ kydawyly, Pymâ. Azagâ tokalâ warâ âtâ imeimbyryla xina nitâdâ, âmâem, Moisés-em, Elias-em warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro, Tiago, João warâ toenzepa tâseanezemo myani. Awylygue myani Pedro âdara tâkely awyly nutuba kulâ arâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Inepa kehoem myani eunu xytâguyly nhonwamo. Eunu duay Deus aguely indadylymo: — Ymery toenzepa kâinwyneguyly merâ. Aguely idataungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Adâkehonduo iwykaudylymo enuaguynrumo. Jesus kulelâ olâ myani nhekylymo; Moisés, Elias warâ netombyramo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aituo xytâguylymo iwy wâgâpa. Tytâguylymo ume, Jesus aguely Pedro, Tiago, João warâam: — Mâentybymone iweâ kuru ânguyram kâzegatuwâdaundâ. Yiguely, kurâem witondyly wituo maise tâwâlâ mâengatulymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aguely einwânmâmomy. Âjigue olâ warâ aguelymo: — Âdaituoka awâkâ arâ aguely? Deus Ingonotyby awâkâ. Âdaraka ise iguely, kurâem itondyly warâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aituo Jesus nhapâiguelymo: — Moisés inweniby wâgâ enomedâni modo adâkeze: “Elias âese, Messias Deus Ingonotyby iraynâ” tâkezemo. Âdaituoka arâ aguelymo? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aituo in-hoguly: — Âkealâ aguelymo; Eliaslâ mawânkâ Messias saindyly wâgâ agueim. Iwenibyem Deus itaumbyry awo wâgâ: “Uguondo Kaynâpa Âetyby âzenagazeoze. Agueho tindadyse inkâbamo ise” kely iwenibyem. Awârâpe angahumo oday? ");
INSERT INTO bkqNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“Elias ara ini nâedâ” uguely. Deus eynynâbaom modo olâ nenagazedâ, Deus itaumbyry awo wâgâ agueho ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesus, Pedro, Tiago, João warâ agâ iwy wâgâpa xytâguybygueduomo myani, tagonrodo nhedylymo kurâ domodo duay. Moisés inweniby wâgâ enomedâni modo ton-honre kehoem âjihogulymo Jesus eynynonro modo agâ, kadopâ niânkyba awylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesus saindyly tientuo, toenzepa kurâdo âsewânily. Inepa kehoem myani edaenkuze idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aituo Jesusram adapâigueolymo: — Âdy wâgâka enra amyguelymo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uguondo kurâ domodo duay in-hoguly myani: — Pymâ, ymery senetai âyam; kadopâgue tase merâ, âjitain-hoemba-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kadopâ ymery odaji idyly watay, onro onwa tameze lelâ inanry, itabigonzely, tyery nhaguly warâ inanry ton-honremba nhedyly. Âynynonro modoram sekadai wâne, kua nhetomoem. Kua niepyramo olâ enra — kely salokuzenomo nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aituo Jesus aguely: — Âdy einwânni kebalâ myanze âmaemo! Agâmolâ wâne urâ, yeinwâmpyra olâ âmaemo. Ynadaize yeinwâmpyra lelâ mawylymogue. Enetaungâ awâkâ salokuzenomo xarâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesusram nhadylymo. Jesus tientuo, kadopâ salokuzenomo nhapânily. Salokuzenomo ihuguely, onro wâgâ âtâgumidyly; itabigonzely idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aituo Jesus salokuzenomo nhunwym nhapâiguely: — Iweâpa merâ âmery arâ awyly? — kely. Nhunwym in-hoguly: — Iamugâryenlâ merâ arâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Alâ inanry kadopâram adameozezedyly peto onwanji, paikaji warâ tyân-hoem. Xina tytyenzelâ ikâ. Kua mânhedyse matay, ymery kua iekâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus aguely: — Âdaituoka yam, “Kua mânhedyse matay” myguely? Tâinwânni xurâem âdylâ adyese lelâ Deus — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aguely umelâ salokuzenomo nhunwym aguely: — Âdiempa tâinwânse urâ. Won-hondâgâ, imâem kâinwântoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aituo Jesus toenzepa kurâdo tuopay âtâdyguyly nhedyly. Tientuomo, ton-honre kehoem kadopâram aguely: — Igasegâ iweâ lelâlâ merâ salokuzenomo odaypa, kadopâ! Nidapyra itoem, aguepa itoem warâ akâiedâ. Tâwântonzeba ikâ iodaxi! — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesus aguely tindatuo, kadopâ adaenkely. Salokuzenomo ton-honre kehoem nhapânily. Iodaypa egaselylâ-ro warâ. Kadopâ tuodaypa egasebygueduo igueypy ara idyly. — Etaungâ. Nigueaki awâkâ! — kely tonlo modo, onro wâgâ awyly tientuo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesus olâ salokuzenomo emary wâgâ XYDYK itoem nhaunâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mârâ aipygueduo myani Jesus egawândyly tynynonro modo agâ âtâ odaji. Mâkâ kulelâ awyly ume Jesus nhapâiguelymo: — Ton-honre lâwâne enra xina aidyly, kadopâ tiânkyhoem. Âda xina niepyra olâ enra. Âdaituo kukeanra? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aituo Jesus in-hoguly: — Ton-honreim lelâlâ mâkâ kadopâ salokuzenomo iodanopyry. Deus eon-honru kienkaduo lelâ mâkâ igonodyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus tynynonro modo agâ târâpa âxiguelymo. Galiléia einkâ myani sakadylymo. Ânguy âdykâ tawyly nhutudyzeba myani Jesus, ");
INSERT INTO bkqNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tynynonro modo lelâ tienomedâdyze ato awylygue. Aituo aguely: — Urâ Uguondo Kaynâpa Âetyby yizepaom modo emaxi âzegameoze urâ. Akaemo ise yâen-honri. Yigueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Âdaituo Jesus tyiguely wâgâ aguely awyly nutuba olâ myani eynynonro modo. Eyam “Âdaituoka arâ amyguely?” keze tywypazemo myani. Nutuba lelâ tawylymogue, tâudylymo ytaze. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Jesus, eynynonro modo warâ Cafarnaumram idâlymo myani. Tâtâlymo ume myani, Jesus eynynonro modo tuduay ânguy tynrenseim kuru awyly wâgâ aguelymo. Aituo myani tykyhoram saintybyem, eyanmo Jesus aguely: — Âdyka enra ânwa oze âunâgomo? — kely. MYK imâmo lelâ olâmy tunârybyry tinwypazedylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aituo myani Jesus ekadyly. Eyanmo aguely: — Kuturin-em tidysedo, tynrendysedo warâ idânârâ nemawyadâdâ, mâkâ keba tâmawyadâzeim nidâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aituo myani tonlo iamudo nhenenehonly tyam. Mâkâ myani iontajimo nhekyly. Iwymogoimbyryem myani eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","— Pymâem xynru waunlo keba merâ iamudo. Mâkâ ynynonro xurâem koendâ amânhedylymo, tynrenseim keba awyly umelâ warâ watay, urâenlâ amânhedylymo. Âdylâ urâem amânhetuomo, ugononibyry xurâenlâ ise amânhedylymo lâpylâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aituo João aguely: — Xina Enomedâni, âunâry egatuze xina tâtâly ume, uguondo on-honrugue kadopâ nhânkyrim xina nedâ. “Jesus eon-honrugue kadopâ modo kâjiânky” xina nygue eyam. Xina ewy keba awylygue keankâ xina aguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aituo Jesus aguely: — “Adâiseba ikâ” tâkezeba itaungâ. Won-honrugue adyesenry modo aieholy watay, urâenlâ mâkâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kuduery keba watay, kataen-holâ mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ynynonro modo âmaemo. Koendâ nhenimopyryam koendonro xuduze Deus. Parugue kulâ wâne akuilymo, alâ olâ ise Deusram âzepywaolymo. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Aituo Jesus agueondyly: — Merâ iamudo yeinwânto ara yeinwânni yeinwâmpyra ienehoim koendâ tâise tuhu imâsedo iwymy wâgâ ekâjily, parutabâ ikaji samely, iguehoem, yeinwâmpyra tienehonly iraynâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imarymogue Deus izepa ato akâiedaundâ. Koendâ tâise imarymo satâly, Deus izepa ato amânhepyra mitomoem. Koendonro kuru tâmaguebalâ Deus agâ aunloenlâ mawylymo; koendâpa mawânrâ peto nhântânry onwanji madameolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Târâ iguewâtyby modo toenzepa tâsenagazeze, tâjynryryram tâdâhoze, peto adaindânryam tâjiaduân-honzemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","— Deus mydâdysebamo atoram tâtâzeba itaungâ. Koendâ tâise âhurumo satâly, Deus mydâdysebamo atoram mydâpa mitomoem. Koendonro kuru Deus agâ mawylymo, ihuru satâybyem; koendâpa mawânrâ infernudâ peto nhântânry onwanji madameolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Târâ iguewâtyby modo toenzepa tâsenagazeze, tâjynryryram tâdâhoze, peto adaindânryam tâjiaduân-honzemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","— Deus mâendysebamo ato kâzetaundâ. Koendâ tâise inumo etyly, Deus mâendysebamo ato mâempyra mitomoem. Koendonro kuru tânuembalâ aunloenlâ Deus pymâem atodâ mawylymo; koendâpa mawânrâ tâdâsenagazedo peto nhântânry onwanji madameolymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Târâ iguewâtyby modo toenzepa tâsenagazeze, tâjynryryram tâdâhoze, peto adaindânryam tâjiaduân-honzemo warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","— Tâseanezeba itaungâ, mâsenagazeduomo. Peto kyaduântobyry ara kehoem wâne kydâsenagazedyly ewânu. Tâseguâdâzeba olâ itaungâ. Deusram âtuybyem kurâ, ize tato kagâ anhetoem. Kydâsenagazedyly watay, âdy mâkeba awârâ. Kyzeinwâne, kieinwâmpyra kipyra kine, peku, tanepa nipyra myara. ");
INSERT INTO bkqNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Peku pyni ekubâzeândoem koendâ awyly, podo niwânzeânehomba warâ, myara âmaemo taunlo modo ywâgâ amyguelymo, kurâ domodo yeinwântomoem, inakanhe nâiehoba itomoem warâ. Peku, onro agâ on-hoam ityby olâ pyni ikaji tyeseba. Arâ lâpylâ mâpaunzedomo koendâ ietaungâ. Arâ ise koendâ mawylymo. Ânguy agâ inakanhemba mawylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus tynynonro modo agâ idâly Cafarnaumdâba myani Judéia yan-yam. Ilâpygueduo paru Jordão nhekuâdylymo. Toenzepa myani kurâdo âtâdyguyondyly iopay. Âtâdyguyduomo tâzewenry aralâ nhenomedâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseu domodo ewype lâpylâ myani târâ. Tienwentâdoem wâne myani inakanhe kulâ aguedyse awylymo. Aituo myani Jesus nhapâiguelymo: — Kâzewenry eynynâ, tâwâlâka uguondo tywydy inmoly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus in-hoguly tiampâiguelymo agâlâ: — Âdaraka Moisés inweniby aguely tâjiwydy imoly wâgâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aituo myani in-hogulymo: — Tutuzelâ âmâ, kydamu Moisés inweniby: “Âwydy mâinmodyze matay, tâwâlâ imogâ. Iwenigâ olâ âdaituo mâinmoly awyly. Aitybyem pape mâinwenibymo eyam xudugâ. Igonokâ lelâlâ-ro warâ” kely myakâwândy inwenily — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aituo Jesus aguely: — Tutuze myani Moisés, tienkyly modo ânguydo kulâ, Deus ize ato adiendysedo keba warâ awyly. Awylygue myakâwândy Moisés “Tâwâlâ tâjiwydy imoly” kely inwenily, pekodo tâwentâzeba itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaudyly umelâ olâ myakâwândy Deus ohogüinwâdyby modo âximoly izepa awyly. “Kaudyly umelâ myakâwândy Deus uguondo, pekodo warâ nhygadyly, ohogüinrin-em” warâ iwenibyem awyly Deus itaumbyry awo wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Alâpylâ iwenibyem awyly: “Awylygue mawânkâ uguondo, tunwym agâpa, tyze agâpa warâ idyly, tywydy agâ lelâ tâitoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ohogüinduomo, tokalâ kurâ ara lelâ Deus xurâem” warâ iwenibyem awyly Deus itaumbyry awo wâgâ. Awylygue azagâpa awylymo, tokalelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ohogüinduomo Deuslâ âzeyam ienimo; awylygue ânguy ohogüimby modo âximohoem aniempyra nidâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aituo âtâ oday ataymo, Jesus eynynonro modo agueondylymo: — Awârâ wâgâ agueonkâ xinaram, âdara awylygue uguondo, pekodo warâ nâximoba awyly wâgâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aituo Jesus agueondyly: — Uguondo modo, âwydymo kâjimowâdaundâ. Mâinmolymo watay, eagonro pekodo agâ tohogüinzeba itaungâ. Eagonro agâ mohogüinduomo, Deus izepa. Deus xurâem, saguholâ âwydymo, nhatano keba. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pekodo modo, osomo kâjimowâdaundâ. Mâinmolymo watay, eagonro agâ tohogüinzeba itaungâ. Deus xurâem, saguholâ osomo, nhatano keba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ilâpygueduo tâjiunwyndo tymeom nhadylymo Jesusram. — Asaemo nhangahu onwa imary iekâ. Deusram koendâ âzehohomoem ekagâ asaemo xurâem — kelymo Jesusram. Jesus eynynonro modo olâ myani akaemo iamimeom sanipyry modo tâuse: — Jesus kâdynanâdaundâ — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesus olâ aguelymo nehoguebyra; awylygue myani tynynonro modoram aguely: — Arâ adâkezeba itaungâ! — kely. — Tâwâlâ iamimeom nâedâ. Kodopâdaundâmo. Iamimeom wâne enra ohondybyem lelâ yam tâetoem, myara lâpylâ kurâ domodo nohondâ, yeinwântomoem, Deus iwymârymoem itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yam tâetoem ohondânry modo Deusgue tywymâgunebamo ise, iamimeom wâne enra ohondybyem lelâ yam tâetoem myarapa tawylymogue. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aituo tokalâ, tokalâ warâ Jesus iamimeom nhanâdyly. Nhangahumo onwa tâmary nhedyly, mâkânra, mâkânra warâ aguely: — Deus koendâ nhese — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus egasely, idâly. Uguondo ânwa oze tâgase kehoem âewyly. Jesus enado âzeguhoam itybyem myani aguely: — Koendonro lelâlâ âmâ, Pymâ. Âdaraka awidyly Deusram udâhoem, aunloenlâ eagâ witoem warâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aituo Jesus in-hoguly: — Amyguely tutuzeka âmâ? Âdaituoka “Koendonro lelâlâ âmâ” myguely yam? Kurâ koendonro lâpeba, Deus lelâ koendonro. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tutuzelâ âmâ, âdy Deus aguiendyse ato awyly Moisés inweniby: “Ânguy kâdyâ. Eagâ mohogüin-hobyry lelâ xynanâgâ. Tâmagazeba ikâ. Aitobyry wâgâpa kulâ âkelomo kâzewentâdâ. Unwâm, âze warâ einwânkâ, xyrenkâ warâ” — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aituo uguondo aguely: — Salokuzenomoem wawyly umelâ idânârâ Moisés inweniby ara awidyly; adyesezelâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tywyneze kehoem Jesus mâkâ nhedyly, eyam aguely: — Tâlâ lâpylâ olâ amânhekyly. Âsejiguy modo idânârâ vende ieta. Ebyry ise âdy pebaom modoram mâunduly-ro warâ. Awârâ amânhedyly-ro watay, tâlâ lelâ ise âmâ mârâ koendonro Deus eydâ atodâ ekanâdyby. Idânârâ tâlâ mato mâunduduo odopâgâ, ynynonroem mitoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesus arâ aguely tindatuo myani uguondo tuomareba idyly, itynwandyly, idânârâ tysejiguy vende tiendyseba tawylygue, idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aituo Jesus tynynonro modo nhedyly. Eyanmo aguely: — Ton-honre lelâlâ âdypeom modo yeinwântoem, Deusgue iwymâgomoem warâ, tysejiguy kulâ ize atomo kuru awylymogue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Agueduo, Jesus eynynonro modo toenzepa âseguâdâdylymo. Toenzepa âdypeom lakuru Deus ize ato waunlo ara mawânkâ, enanajimo. Aituo Jesus agueondyly: — Ton-honre lelâlâ âdypeom modo yeinwântoem, Deus tywymâryem nhetoem warâ, tysejiguy mawânkâ ize atomo kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ton-honre camelu agüie ihu oze sakadoem, arâ lâpylâ ton-honre âdypeom modo tâlâ tato inmohomoem, Deusgue lelâ tywymâgomoem warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","“Ton-honre lelâlâ âdypeom modo Deusgue iwymâgomoem” Jesus keduo myani, toenzepa kehoem Jesus eynynonro modo âseguâdâdylymo, âdypeom modo lakuru Deus eydâ atoram idâim waunlo ara enanajimo awylygue. Aituo âjigue aguelymo: — Arâ atayma ise ânguy nâsemaguewâbyra-ro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aituo Jesus eyanmo MYK itybyem aguely: — Âkealâ, ânguy nâsemaguewâbyra ton-honrugue, Deus olâ kurâ domodo anhetânry adyese lelâ. Âdy anhetânry lâpeba Deus — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jesus aguely tindatuo, Pedro aguely: — Xina-ro? Idânârâ tâlâ tato xina niâm, âynynonroem tâitoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Aituo myani Jesus eyanmo aguely: — Idânârâ tâlâ matomo mânhânlymo, ynynonroem mitomoem watay, Deus xuduze lelâ ipa matomo. Xirâ mâuntudyzemo kuru wato. Itymo mânhânduomo, âykyhomoem ijidymo xuduze. Âwaigorumo, âukonomo, nhaundumo, unwânmo, âzemo, âmeonmo warâ mânhânduomo, Deus âpemugumo nhetomo ara kehoem nhenimo, âwynenimo warâ xuduze. Âpimo modokelymo watay, Deus âpynirymo xuduze. Tâlâ matomo mânhânlymo Deus itaumbyry egatuze madakobâdomoem watay, âdy ipa matomo xuduze, mânhâympymo takaze kehoem, até cem vezes lelâ. Âiguepa mawylymo ara, toenzepa ise yeinwântânry modoram mâzenagazeolymo yeinwândylymogue. Âigueduomo aunloenlâ ise Deus agâ mawylymo. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iwerâ waunropyry modo, ilâem âgânâynra ise. Âgânonrobyry modo, ilâem waunroem ise warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus, eynynonro modo warâ tuhuru wâgâ xidadâ Jerusalémram âkulymo. Waunroem myani Jesus idâly. Tyanepa, adâieholy tutuze tawylygue, âgânâ eynynonro modo idâly-ro warâ. Izepanro modo mârâ xidadâ oday awyly tiuntuduomo eynynonro modo âdara tâidyly nutuba idylymo. Tyane myani kurâdo eagâ idâwâni modo. Aituo Jesus tynynonro modo aguiom duaypa nhejikely iwaguedope, âdatidyly awyly wâgâ adâkehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","— Idataungâ wao auguely. Jerusalémram xirâ kytâly. Yizepaom modoram adawâhoze urâ Uguondo Kaynâpa Âetyby. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ iegamezemo. “Nigue awâkâ” kezemo. Judeu keba modo emaxi iegamezemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Akaemo ise âwankuem yeni, iedakudâni, yapiogunri, yârim warâ. Awârâpygueduo azagâ emedyly idyly ara olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ilâpygueduo Zebedeu imeom Tiago, João warâ Jesus iopaji saindylymo. Nhekadylymo eyam: — Xina nhekadybyne aiekâ, xina kely, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Agueduomo, Jesus aguely: — Âdyka mâenkadyze matomo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Warâ in-hogulymo: — Pymâem kuru mituo, xina iduakegâne, agâ pymâem xina itoem. Tokalâ aho eynynâ, tokalâ pâem eynynâ warâ xina ekanâgâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Arâ agueduomo, Jesus aguely: — Mâuntuwâbyra âmaemo âdara yagâ pymâem mitomoem amidylymo awyly. Toenzepa kâsenagazedo ara kehoem âsenagazeze tâeganeka ise âmaemo? Yiguely ise myara igueze tâeganeka ise âmaemo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","— Emaenze lelâ xina, mâenmaen-ho ara — kelymo myani. Aituo myani Jesus aguely: — Âsenagazeze urâ, âmaemo lâpylâ warâ. Igueze urâ, igueze lâpylâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yahoru eynynâ ekani, pâem eynynâ ekani warâ kâinduakeba olâ urâ, yagâ pymâem itoem. Deuslâ ise iduakeim. Mâkâ mawânkâ târâ tâzekado nhonipyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tiago, João warâ Jesus agâ pymâem tâidyse awyly tindatuo, eagonrodo eagâmo iewiâpadaynly. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aituo Jesus idânârâ ingâsedylymo tuopaji, eagâmo adâkehoem. — Tutuzelâ âmaemo, pymâdo ton-honreim modo, tyewiâse kehoem kurâdo agâ aguely, adâkehobyry anhetomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Âmaemo olâ arâpa itaungâ. Mâdyren-hondyze mataymo, tâzemaryenlâ itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","“Imawyadâbyramo ise urâ. Pymâ wawylygue, âmaemolâ ise urâem aieni” tâkezeba itaungâ, pymâem mituomo. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yara itaungâ. Deus Ingonotyby lelâlâ wâne urâ, iemawyadâdomoem âetyby keba olâ urâ, imarymo lakuru urâ. Igueze âetyby urâ. Kurâdo inakanhe aito modo epywaze ise yiguely, Deus ize ato ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus, tynynonro modo agâ xidadâ Jericó einkâ sakadylymo. Kurâdogue tyampyguenone kehoem xidadâ odaypa egaselymo ume epy Bartimeu, ânwa edazekâ ekadybyem awyly, sakadaynrim modoram dinheru tienkadoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","— Jesus Nazaré donro enra awâkâ sakani — kely tindatuo myani adaenkely: — Ytyendâlâ ikâ, Jesus. Âdamu Davi ara pymâ ton-honreim âmâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ton-honre kehoem eyam aguelymo: — MYK alelâ ikâ! Tadaenkezeba ikâ! — kelymo eyam. Agueduomo lakuru myani epy adaenkely: — Ytyendâlâ ikâ, Jesus! Âdamu Davi ara pymâ ton-honreim âmâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus epagudyly. Aguely tonlo modoram: — Epy yam enetaungâ — kely. Epynra aguelymo: — Tyanepa ikâ! Aukâ. Âgâsedyly mâkâ — kelymo eyam. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aituo Bartimeu tâty BOH waunlo tâmaegoze kehoem nhetyly, nhamely, saudyly, Jesus iopaji adaholy. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aituo Jesusram adapâigueoly: — Âdyka âmâem agânhedyse mato? — kely. — Kâentondyze urâ, Pymâ — kely in-hoguly. ");
INSERT INTO bkqNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","— Ipa, kua mitai, kua âeniem wawyly mâinwântobyry wâgâ. Idâ lelâ itynra — kely Jesus. Ilâenlâ kehoem Bartimeu nhetondyly, ânwa oze Jesus nhampygue idâly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Âtâ anary Betfagé, Betânia warâ Jerusalém iwaguepaonram myani Jesus, tynynonro modo, kurâ domodo warâ agâ saindylymo. Iwy Se Oliveira Ekadâ epagudylymo. Myarâ saintybyem Jesus tynynonro ewy azagâ waunroem ingonodyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wakely eyanmo: — Idâwâtaungâ mârâ âtâ anary iwaguepaonram. Myarâ aindylymo umelâ ise jumentinhu ekâjiby mâendylymo. Ânguy âkuhobyry keba mâkâ. Ekâjiguewâdaungâ; enetaungâ xarâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ânguylâ apâiguelymo: “Âdaituoka jumentinhu mandylymo?” kely-ro watay, “Kywymâry merâ izetonro. Inepa olâ ise nhopânehonly” myguelymo lelâ ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Myarâ idâypyem jumentinhu kuoho ekâjibyem nhedylymo. Aituo nhekâjiguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Aidylymo tientuo, tonlo modo aguelymo: — Âdaituoka mâenkâjiguelymo? Iguymo mâkeba awâkâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus tyam aguehobyry ara myani aguelymo: — Kywymâry merâ izetonro. Inepa olâ ise nhopânehonly — kelymo. Aituo tonlo modo aguely: — Âdainkâba. Sataungâ lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jumentinhu nhadylymo Jesusram. Saintybyem myani tygaparyguelâ jumentinhu inkawendâdylymo. Aituo Jesus jumentinhu onwa âkuly. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Toenzepa kurâ domodo tâty BOH waunlo ânwa oze, PO PO tyesemo myani Jesus idâwaym. Tâlâ pylâ myani wakuri sary tiantâwâdyby modo onro onwa PO PO ieni modo, tynrense tawyly tienehon-homoem, pymâ ton-honreim idâwaym adâitomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Waunroem idâwâni modo, âgânâ idâwâni modo warâ adaenkelymo adaguly: — Hosana Deus! — kelymo. (“Tohoguezeim Deus” keze aguely.) — Tohoguezeim kuru awâkâ Deus eon-honru enehonze âeni! ");
INSERT INTO bkqNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ton-honreim âmâ! Xina iwymâry ise âmâ! Davi pymâem atobyry ara ise pymâem mawyly! Hosana Deus kaynonro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus Jerusalém ijidadâry odaji saindyly. Saintybyem, Deus ety odaji egawândyly, nhenuagaendyly. Enuagaenibyryem, egasely. Betânia anaxi odopâdyly doze tynynonro modo agâ, iguandyly awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kopaelâgâem Jesus, tynynonro modo agâ odopâdyly Betânia donropyryem Jerusalémram. Tâwinze myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iwague endaylâ figueira nhedyly, tarygoengue kehoem. Tâwise-ro waunlo ara, enanaji, tarysely agâlâ ewiseim mawânrâ figueira. Aituo eyam iwaguepa saindyly. Ewily sasegâze wâne, tâwiseba olâ, âdaunloenlâ ipa lelâlâ, ewiseho umeba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aituo Jesus figueiraram aguely: — Iwiseondaymba olâ ise âmâ. Ânguy iwily neinhotaymba ise — kely. Eynynonro modo Jesus aguely idamâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Figueiraram agueypyem Jesus, tynynonro modo agâ Jerusalémram saindylymo. Saintybyem, Jesus egawândyly Deus ety idaseraji. Âdydo imeom vende ieni modo târâ aidyly tientuo nehoguebyra, kurâdo nhenokudylymo kulâ awylygue. Aituo tyewiâse kehoem idânârâ sanâni modo, vende ieni modo warâ nhegaseândaynly. Dinheru troca ieni modo iwenzary nhamunedyly, papa vende ieni modo xurery nhamely idyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","— Xirâ âtâ âwankuem kâietaundâ. Âsejiguymo xirâ taseragâ kadakobâdaundâ. Idâwâtaungâ. Igasewâdaungâ tarâpa — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Egaseânimobyryem eyanmo aguely: — Deus itaumbyry awo wâgâ iwenibyem: “Xirâ iety idânârâ kurâ domodo yagâ agueho xirâ” kewândymy Deus. Kurâ domodo mâenmagazedylymo kulâ olâ. Ânguydo imeom Deusram tiunduly nhanâdylymo watay, toenzepa mâenwâentanâdylymo. Dinheru âmaemoenlâ mânhedylymo. Deus ety, tâmagazeim modo otoendoem mânhedylymo kulâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ Jesus aguely idamâmy. Jesus agâ iewiâpadylymo myani. Jesus anhekyly lelâ kurâdo nhehogueguyly, aguely lelâ inwantagueguylymo warâ awylygue. Awylygue âdara Jesus tyâly awyly wâgâ tyangahu oday xunâzelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iguandyly ume Jesus, tynynonro modo agâ Jerusalémdâpa idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Emetuo Jesus, tynynonro modo agâ odopâdyly Jerusalémram. Jesus, “Iwiseondaymba ise âmâ” kehobyry figueira einkâlâ myani sakadylymo, todopâdaymo. Igueypyem lelâ mârâ se nhedylymo. Iwindy agâ kehoem warâ iladybyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tientuo, Pedro nhenanâguely Jesus mârâ figueiraram aguehobyry. Aituo Jesusram aguely: — Egâ figueira, Pymâ. Kopaelâgâ kulâ keankâ “Iwiseondaymba ise âmâ” myguely eyam. Ipa iwerâ, idânârâ kehoem iladybyem awyly — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aituo myani Jesus eyanmo aguely: — Toenzepa Deus einwântaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Deusram mâenkadybymo aidyly tâinwânse âmaemo watay, adâise lelâ. Tâinwânse lelâlâ âmaemo watay lelâ olâ ise aidyly. Amânhetomoem on-honrumo kâunduypygue idânârâ aiese lelâ âmaemo. Xirâ iwyram, “Âxiguegâ; paikaji adamegâ” myguelymo watay, tâjidydâpa tâxigueze tâise, paikaji tadameze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Deus agâ amyguelymo, tâinwânse kehoem amyguelymo watay, xuduze lelâ. Arâ amyguelymo watay, mâenkadybymo aiese lelâ. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Deus agâ amyguedaymo, âkelomo agâmo inakanhe aitobyry enanânehonwâdaungâ, Kunwym Deus inakanhe amitomobyry nhygakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Âkelomo aitobyry mâenanânehomba âmaemo-ro watay, inakanhe amitomobyry Kunwym Deus nygakewâbyra ise, mâenkadybymo nudupa ise warâ. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus, eynynonro modo warâ Jerusalémram saintondylymo. Saintybyem, idâlymo Deus ety odaji. Taseragâ myani Jesus adakobâdyly. Jesus târâ atay, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo, uguondo tâgareim modo warâ iopaji idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aituo nhapâiguelymo: — Ânguyka tarâ Deus etydâ arâ amitoem agueim? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aituo Jesus in-hoguly: — Apâiguelymo lâpylâ ise. Uhoguduomo, ânguy ugononibyry awyly agueze urâ — kely. Aituo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","— Ânguyka ani João Batista, inakanhe adâitobyry wâgâ âjityendyby modo batiza nhetoem agueim? Deuslâ? Âdaunlo uguondo kulâ? Uhoguwâdaungâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aituo aguelymo: — Iwerâ ise-ro? Âdara kuru ise kin-hoguly? “Deuslâ agueim” kykeduo, “Âdaituo pylâka João aguehobyry mâinwâmpyra mawylymo?” keze. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Uguondo kulâ ani João aitoem agueim, Deus mâkeba” kykeduo, kurâ domodo kagâ iewiâpazemo — kely pymâ domodo. João Batista, Deus itaumbyry egatuin-em igonotyby awyly tâinwânse mawânkâ myani kurâ domodo. Awylygue “Deus mâkeba igononi” keze eanumo. ");
INSERT INTO bkqNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Awylygue in-hogulymo: — Xina nutuwâbyra ânguy João batiza nhetoem agueim awyly — kelymo. — Arâ atayma auguepa lâpylâ ise urâ, ânguy xirâ agânhetoem ugononi awyly-ro — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ilâpyryem Jesus tonlo modo kurâdoram agueondyly. Enomedâzemo unâ nhegatuly: — Tâlâ myani uguondo uva etâdybybeom. Aituo uva ejidy nhahodânehonly tuhu imâsedo modogue. Onwâgâ tâtagueim nhesaguehonly, uva ekuguehoem tâjihurugue, vinhu xygatoem. Âtâ imeimbyry kaynâ olâ-ro waunlo aienehonwânmy tâmagazeim saindyly enuagaendo, ânguydo imeom nady saguwâni modo enuagaendo warâ. Ilâpyryem myani uva ejidy etaynrim modope nhedyly. Warâ myani eyanmo aguely: “Ypi mâendylymo-ro watay, uva xutuduo, epajigâze urâ agâmo” kely. Koendâ lelâ myani arâ âjihogulymo. Aituo myani idânârâ nhonipyryem, âtâ anary iwaguenonra idâly. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","— Uva ekaunâdo odaji ituo myani tâmary ingonodyly akaemo tâwaneim modoram, turâ emakeze. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Aituo ingonotyby idâly âpa ezaji. Saintuo, tâzenagazeozemo myani uva ejidy etaynrim modoram. Sawâmâmomy, sapioguwânmomy warâ. Aguelymo: “Idâ. Xina âdy nuduwâpyra ise âpa ezary sodoram” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Saguho âdy peba odopâduo myani uva sodo eagonro tâmary ingonotondyly wâne, nhekaunâdybymo ewy turâ emakeze. Âpa ezary etaynrim modo olâ myani mâkâ tânagazezemo, tyangatainzemo, kywypadoem kulâ adyesemo warâ. Âdy nudupamo myani âpa ezary sodoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aituo myani eagonro ingonodyly myarâ âpa ezaji. Tâwanuneim modo nhâlymo lelâ. Alâ pylâ myani eagonro modo aiehowâdyly. Toenzepa kehoem nhapiogulymo. Eagonro modo nhâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","— Alâ tâmary ingonokyly peba idyly. Imery inwyneguyly kulelâ idyly. Alâ ingonodyly. “Merâ ymery tokaleom awylygue âda nientaymbamo ise” tâkeduo, ingonodyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sodo imery saindyly umelâ, âpa ezay tâwanuneim modo âjigue aguelymo: “Uva sodo imery mâkâ âeni. Tunwym igueduo, mâkâ ise ipibyry sodo. Kydyânrene, nhunwym ipibyry kurâenlâ itoem” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","— Aituo myani mâkâ uva sodo imery nhawâdylymo, nhâlymo, eguepybyry nhamelymo âpa ezayba — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aituo Jesus adâkely idani modo nhapâiguely: — Âdyka ise mâkâ uva sodo akaemo âpa ezary eni modoem anhekyly? Agueze urâ âyanmo. Todopâduo, uguondo modo xyâwâse mâkâ sodo. Eagonro modo ise mârâ uva ejidy eniem nhekyly-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Deus itaumbyry awo wâgâ iweniby mâintaimbymo enanâguewâdaungâ: “Tâlâ myani tuhu imeâgâkeba, âtâ itâdo. Idânârâ itâdaynrim modo mârâ tuhu tâensemo, mârâgue âtâ tintâdyzebamo olâ. Deus xurâem olâ mârâ tuhu tywyneim kuru! ");
INSERT INTO bkqNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kywymâry Deus induakeyby olâ mârâ tuhu, âtâ itâdoem. Deus anhetyby idânârâ iwâkuru kurâem!” warâ iwenibyem awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pymâdo, âpa ezary eni inakai wâgâ unâ tindatuo, toenzepa iewiâpadylymo. Tywâgâ aguely awyly nhutulymo, Jesus izetonro keba tawylygue, tâwaneim modo âpa ezary sodo imery izepa atomobyry ara. Awylygue Jesus tientadânehondyze idylymo, tyâen-hon-hoem. Âjigue aguelymo: — Iweâ lelâlâ kianwânehonly watay, kurâdo kagâ iewiâpaze — kelymo âjigue. Awylygue myani Jesus âdara niepyra awylymo ilâenlâ, nhodokelymo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mârâpygueduo judeu domodo iwymârydo aguely fariseu domodo ewyram, Herodes eynynonro modo ewyram warâ: — Idâwâtaungâ Jesus agâ agueze. Moisés inweniby wâgâpa kulâ aguehoem ise amyguelymo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Saintybyem igonotaymby modo Jesusram aguelymo: — Pymâ, konokuni keba mawyly, tutuze xina. Deus ize ato wâgâ âkealâ xina mâenomedâdyly. Iozeno lelâ amygueho, ânguy izepa awyly umelâ. Pymâdo tynrenseim modo ize ato amânhetoem kulâ amygueho mâungukewâbyra âmâ. Awylygue âdara impostu epywadyly wâgâ mâuntuly wao xinaram aguekâ. Moisés inweniby ara, koendâ pymâ Roma donro César-ram impostu epywadyly? Koendâpa? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","César tiunâguedoem kulâ tapâiguelymo awyly xuturimbyryem olâ myani Jesus. Aituo aguely: — Inra esagueyby odaji wâne ânguylâ ihuguely myara wâne ienokudyze mawylymo. Moeda enetaungâ, kâentoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aituo moeda nhadylymo, nhudulymo, Jesusram adapâigueolymo: — Ânguy emydy ekudoka xirâ wogonro? Ânguy ezedyka iwâgâ iweniby warâ? — kely. Aituo in-hogulymo: — Roma donro kywymâry César ezedy, emydy warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aituo Jesus aguely: — César xurâ, Cesaranlâ xuduwâtaungâ. Deus xurâ, Deusranlâ xuduwâtaungâ warâ — kely. Jesus aguely tindatuo Jesus enokuze kewâtyby modo âseguâdâdylymo. Âdara tienwentâdo nutuba tâituomo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceu domodo ewy Jesus agâ âtunâgueze idâlymo myani. Iguewâtyby modo kurâem itondyly einwânni keba akaemo. Jesus iopaji saindylymo. Aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","— Idakâ, Pymâ. Moisés ezewenry tutuzelâ âmâ, iweâpa kydamudoram inweniby: “Uguondo tywydy namypalâ iguely-ro watay, iukonobyrylâ nohogüim iwydypyry agâ, imezeândoem. Aituo iamudo iazeypy, igueypy imeryenlâ âdutuoly” kelype. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Xina olâ ise warâ nhegatuly. Tâlâ myakâwâm sete lelâ uguondo modo âjiwaigoruem, âjiukonoem waunlo. Iwaigorumo ohogüinly myakâwâm. Tywydy namypalâ iguely. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iukonobyrylâ myakâwâm ohogüinrim pypâ agâ. Mâkâ lâpylâ myakâwâm tywaigoru iwydypyry namypalâ iguely. Azagâ tokalâ ietomo iukono ohogüinly myakâwâm pypâ agâ. Mâkâ lâpylâ iguewâm, tywaigoru iwydypyry namypalâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tywaigoru iwydypyry namypalâ lâpylâ myakâwâm quatro ietomo, cinco ietomo, seis ieto, sete ietomo warâ iguewâdylymo. Sete uguondo lelâ myakâwâm mâkâ pekodo agâ ohogüimby. Idânârâ mâkâ uguondo modo iguewâpygueduo myakâwâm, pekodo iguely lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","— Xirâ xina apâiguedyze ato. Âkealâ kuru igueypy kurâem itondyly watay, âdaunlo uguondo akaemo sete ewy iwydyenka ise mâkâ, kurâem itonduomo? Idânârâ akaemo sete lelâ iwydyem ityby mawânkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aituo Jesus in-hoguly: — Iozepa kulâ âunâgumo! Deus itaumbyry awo wâgâ iweniby mâuntuba kuruka âmaemo! Âdydo imeom aiese Deus ton-honre awyly, mâuntuba gâlâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iguewâtyby modo kurâem itonze lelâlâ, nigueompyra tâitomoem. Anju domodo nohogüinwâbyra. Alâpylâ iguewâtyby modo, kurâem itonduo, nohogüin-ondaymbamo ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","— Iozeno kuru iguewâtyby modo kurâem itondyly, kely mâintaimbaka minasemo. Enanâguewâdaungâ Moisés inweniby igueypyem kurâem tâjitondyly wâgâ, se imeimbyry niadupalâ tyatygueindâ Deus aguehobyry: “Deus urâ, Abraão, Isaque, Jacó warâ iDeusry; tarâlâ akaemo ywâgâ” kewândy Moisésram. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kurâdo enanaji olâ Deus einwânni iguewâtyby modo, iguewâtybyem lelâlâ. Deus xurâem olâ akaemo igueypyemba, târâlâ akaemo Deus eydâ atodâ. Arâ aguehobyry wâgâ Deus einwântaynrim modo nigueompyra awyly kiuntuly. Ioze inkâba awârâ “Igueypy kurâem nitombyra” myguelymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moisés inweniby wâgâ enomedâni ewy aguelymo idamâ. Koendâ lelâ Jesus saduceu domodo aguelymo in-hoguhobyry tutuze tawylygue, Jesusram aguely: — Toenzepa Moisés kâzewenryem inweniby modo. Âdaunloka koendonro kuru? Âdaunloka awârâ modo takazeno kuru? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aituo Jesus in-hoguly: — Warâ mawânrâ Deus itaumbyry awo wâgâ iwenibyem awyly: “Israel iweom, ydataungâ. Kywymâry awâkâ Deus. Awâkâ kulelâ Kuturim! Tokalâ kulâ awâkâ! ");
INSERT INTO bkqNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kywymâry Deus iwynedaungâ idânârâ âdydo imeom, kurâ domodo warâ mâinwynedomo takaze kehoem. Idânârâ ize matomo, Deus ize ato ara lelâ nidâ. Idânârâ angahumo oday âunâgomo Deus ize ato lelâ nidâ. Idânârâ amânhekylymo Deus ize ato ara lelâ nidâ” warâ. Xirâ aguely mawânrâ tâzezewenry takazeno kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","— Eagonro tâzezewenry koendonro lâpylâ xirâ: “Agonromo agâ âpynedaungâ; koendâ mâzetomo ara, arâ lâpylâ agonrodo agâ koendâ âzetaungâ” kewândymy Deus. Xirâ azagâ tâzezewenry auguehobyry mawânrâ mârâ kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aituo Moisés inweniby wâgâ enomedâni ewy aguely Jesusram: — Koendâ lelâlâ amyguely, Pymâ. Âkeá lelâlâ amyguehobyry modo. Deus kulelâ kywymâry. Ipa eagonro Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Deus kinwyneguyly kuru nidâ, kurâdo, âdydo imeom warâ takaze. Mâkâ ize ato ara lelâ kyangahu oday kunâgu nidâ. Ize ato ara lelâ aguine. Ton-honre kehoem eagâ kydawyly nidâ. Mâkâ agâ, mâkâ agâ alelâ âjize kine, âwâlâ âjize kydato ara. Deus ize kurâ, kurâ domodo ize kurâ warâ watay lâpylâ olâ iomaru kuru-ro warâ, âdydo imeom, ânguydo imeom warâ egameduo iomaru takaze kehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Awârâ tindatuo, tutuze myani Jesus, mâkâ Moisés inweniby wâgâ enomedâni tutuze kehoem aguely awyly. Aituo eyam aguely: — Koendâ kehoem Deus wâgâ tutuze âmâ. Deusgue tywymâgueinhe iseaji mynra âmâ — kely. Agueduo tonlo modo Jesus napâigueba idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Deus ety idaseray kurâdo tienomedâdyly ume, Jesus aguely tydataynrim modoram: — Moisés inweniby enomedâni modo, “Uguondo kulâ Messias; Davi iwerypyry tarâ onro anaym kulâ ise pymâem awyly” kelymo. Âyanmo auguely olâ, âkealâ awyly mâuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tutuzelâ myakâwândy Davi, âdaunlolâ kurâ takaze kehoem ton-honreim Messias awyly. Awylygue “Ywymâry” kewândymy Davi Messiasram, niazepa awyly umelâ. Deus Ispiriturylâ mawânkâ eyam xutuen-hoim. Tutuzelâ âmaemo Davi inweniby: “Deus aguely myakâwâm Ywymâryram: ‘Yahoru eynynâ ikagâ tynrenseim ekadodâ, âduery modo eon-honru kainly ara, âdydo ara kulâ âhuru iaxi kânhedylymo ara’ kewândymy Deus” kely myakâwândy Davi inwenily, Deus Ingonotyby wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","— Davilâ myakâwândy Messias tywymâryem awyly agueim. Awylygue kiuntuly âdaunlo kulâ uguondo keba awyly. Messias tynrenseim kuru awyly xutuwâdaungâ, Davi takaze — kely Jesus. Koendâ kehoem kurâdo Jesus tonomedâdyly indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aituo Jesus agueondyly kurâdoram: — Tonomeguelâ itaungâ Moisés inweniby wâgâ enomedâni modo aito ara amipyra mitomoem. Koendonro aramo wâne, koendonro kebamo olâ. Earamopa itaungâ. Kurâ domodoram tâzehogueoly kulâ ize atomo. BOH waunlogue lelâ etyunmo, Deus eynynonroem tawyly tienehon-homoem. Âdykâlâ kurâdo âtâdyguyho einkâ takaduomo, mâkâ modo tâdaenkudyzemo, tynrendysemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Âtâ tâdâtâdyguyho odaji tâtâduomo, tâgareim ekado wâgâ ekadylymo, arâ lâpylâ âty mododâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pekodo pypâ modoram aguelymo inanry: “Xinalâ ise âsejiguymo eni; tusonebama âmaemo” kelymo. Isejiguymo turâem tientomoem kulâ olâ nhenokudylymo. Deus agâ adâkedaymo, imeâgâemba kehoem aguelymo, koendâ tâgaromoem kulâ. Awylygue ise Deus nhenagazedylymo, kurâdo takaze kehoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Deus ety idaseray Jesus ekadyly, dinheru Deusram xuduypy etary iwaguepa. Ilâ odaji dinheru ieni modo myani nhenuagaendyly. Toenzepa tydinherugueim modo imâem dinheru nhetadâdylymo nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aituo pypâ âdy pebanro kehoem saindyly. Azagâ moeda imeimbyry, tâwâensenry nhetadâdyly nhedyly lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Awârâ tientuo, Jesus aguely tynynonro modoram: — Deus xurâem, mâkâ pypâ nhetadâdyby tâwâenseim kuru, akaemo âdypeom modo nhetadâdyby takaze. ");
INSERT INTO bkqNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dinheru âsegubydâdyby akaemo nhuduly. Mâkâ olâ idânârâ tâlâ tato ara nuduaki, typyniry tianâto alelâ. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Aituo Jesus âxiguely Deus ety idaserayba. Tâtâday, Jesus eynynonro ewy aguely: — Egâ, Pymâ. Iwâkuru kehoem Deus ety! Tuhu iwâkuru kehoem âtâ itâdobyry! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aituo Jesus aguely: — Arâ wâne awârâ Deus ety imâsedo mâendylymo. Adainhoze olâ awârâ. Idânârâ adakalagueoze. Angato inkâba ise awârâ tuhu modo; ihuguewâze awârâ onro onwa — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ilâpyryem idâlymo iwy onwa Se Oliveira Ekaram. Târâ iwy wâgâ ekadybyem Jesus Deus ety nhesedyly iwague endaylâ. Pedro, Tiago, João, André warâ eyam idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Eagonrodo naimpyra awyly umelâ sapâigueze: — Âdara kaise xypyry iwaguepa idyly xina nhutuly? Âdy kaise tâenseim Deus ety adakalagueoho odaji itybyem awyly xutuhoem? Âdara kaise awârâ adaguhoem aidyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aituo Jesusram âzenomedâolymo: — Inanaynmolâ itaungâ, kodopâdo wâgâ ânguy inokubyramo itoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Xypyry etaji idyly ume, toenzepa ise “Messias urâ, Deus Ingonotyby” kewâni modo. Toenzepa ise agueduomo âsenogudaynrim modo. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tâinkâ lelâba âseguebylymo, âdyâwâdylymo warâ kely idase âmaemo. Tadahulizeba olâ itaungâ, awârâ modo egary mâindatuomo. Aise awârâ modo, âdypydâdo keba olâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Âkelo anano modo âdyâwâsemo. Âjitanwebaom modo âdyâwâsemo warâ. Tâinkâ lelâba ise onro âzekânily. Âtâ anakâ pyni peba ise. Tâdâsenagazedyly imâem iseze, pekodo âsenagazedyly xigâlegueam tymery iazehoem ewânugue myara. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","— Tonomeguelâ itaungâ. Yizepaom modo awâsemo yeinwândylymogue. Asemo pymâ domodo enadoram, mâzenagazeohomoem. Apiogüen-honzemo âtâ tâdâtâdyguyho oday. Yeinwândylymogue, pymâ domodoram adahoze âmaemo. Pymâ domodo enado mataymo tâwâlâ ise unâ iwâkuru mâengatulymo âdara imakehomobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Xypyry etaji idyly iray, unâ iwâkuru ywâgâ agueim âzegatuoze idânârâ kurâdoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Adahoze âmaemo pymâ domodo enadoram, âzetadâoze âmaemo warâ. Amyguehomo wâgâ tadahulizeba itaungâ, pymâdo enadoram madahoduomo. Pymâdo enado mawylymo ume, Deus agâmolâ ise. Âurusemo amyguehomoem. Âunârymo wâgâ kulâ inkâba ise amyguelymo, Deus Ispiritury xunâry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","— Ipemugüanlâ ise yeinwânni modo âzenagazeoly. Ipemugumolâ ise pymâdoram egamenrimo, âdyohomoem. Âjiukonoem, âjiwaigoruem warâlâ ise âsegamelymo. Tâjiunwym, tâjimery warâlâ ise âsegamelymo lâpylâ, âdyohomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ynynonroem mawylymogue, toenzepa ise mâjiewiâseolymo. Âmaemo yeinwândyly imodânry modo olâ âsemagueze, aunloenlâ Deus agâ mitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aituo Jesus agueondyly: — Âepanâgueze “Deus izepaom kuru” keho, mâkâ inakai kuru. Jerusalémdâ ise âepanâguely, Deus ety oday, tâjidydâpa kulâ. (Xirâ itainwâni modo xutuze, âdara keze aguely awyly.) Mâkâ inakai kuru Jerusalémram saintuo, âmaemo Judéia donro modo iwyram âwientaungâ, otoenze. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inepa kehoem âwientaungâ. Itymo inatay âmaemo watay, tâwânseba itaungâ itymo odaji, âdylâ ese. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Âpa ezay âsewanize mataymo, inepa âwientaungâ, itymo iwanomoguelâ. Itymo mâungukehomo ese todopâzeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","— Toenzepa âsenagazeze pekodo modo ioday tymegueim, tuhuazeim modo warâ. Tahule âwienniembamo mawânkâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Deusram ekadaungâ, kopâ umeba xirâ tâdâsenagazedo saindyly itoem; inepa tâdâwiento nudupama ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ton-honre ise awârâ tâdâsenagazedyly saindyly. Deus onro nhugutobyryenlâ arâ kehoem tâdâsenagazedyly peba awyly. Anitombyra ise-ro warâ mârâ emyenro kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Deus olâ mârâ tâdâsenagazedo epagunâze, aisezedyly lelâ waypa itoem. Aypa watay, ânguy nemaenwâbyra tâise; idânârâ tadainze. Tynynonroem tinduakeyby modo wâgâ olâ ise Deus anhedyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jesus aguely: — Kodopâdo xutuze âmaemo, ânguy âdakepalâ. Awylygue “Anra merâ Messias” kely mâindatuomo, kâzeinwântaundâ. “Awâtârâlâ awâkâ Messias” kely mâindatuomo, kâzeinwântaundâ warâne. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Toenzepa ise enra konokuni modo. “Deus Ingonotyby urâ” kezemo. “Deus keankâ ugononi, itaumbyry egatuze” kezemo. Adyesenry modo kehoem aiesemo, kurâ domodo iomazeâni aiesemo warâ. Idânârâ enokuze kezemo; Deus induakewâdyby modo enokuze kezemo lâpylâ, akaemo olâ ise nâzenokuoba. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Inanaynmolâ itaungâ. Âurudylymo olâ waunroenlâ, mârâ ume mâzenokuoba mitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aituo Jesus aguely: — Mârâ tâdâsenagazedyly sakabygueduo, xixi, nunâ warâ tohoreba ise. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ximukâ modo kau wâgâpa ihuguewâze. Kaynâ tyngataymby modo ihugueânze Deus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Idânârâ kurâdo kâepanâguely ese, urâ “Uguondo Kaynâpa Âetyby” keho. Eunu duay ise ytâguyly. Pymâem lelâlâ wawyly; toenzepa won-honru enehonze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anju domodo igonose urâ idânârâ âtâ anakâ, Deus induakeyby modo idâtyguyze. Xixi egaseho eynynâ, egawânto eynynâ, norte eynynâ, sul eynynâ warâ ise yeinwântaynrim modo âewyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Aituo Jesus aguely: — Inepa kodopâdyly awyly xutuhobe ise, iwaguepa kopâ ihugueho awyly xutuho ara. Etaungâ figueira. Iwatary modo ikuandaynly, sary ilusewâdyly warâ watay, iwaguepa kopâ ume idyly awyly tutuze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Myara lâpylâ ise xirâ auguehobyry modo aidyly adaguly mâentuomo, kodopâdo iwaguepa awyly mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Aise xirâ âdydo imeom, idânârâ xirâ onro anano modo iguelymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kau, onro warâ adainze. Auguehobyry olâ ise nadaimpa, nâtugugueba warâ; aunloenlâ ise. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Aituo Jesus aguely: — Kunwym Deus kulelâ xuturim kuru âdara kodopâdyly awyly, kopae atay, peto oday atay warâ. Ânguy xirâ anano nutuwâbyra. Anju domodo nutuwâbyra. Urâ Deus imerylâ kâuntuwâbyra urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tonomeguelâ olâ itaungâ. Kâewyly inwânwântaungâ. Mâinwânwâmpyra tâiseba itaungâ, âdara kodopâdyly mâuntuba mawylymogue kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","— Unâ ise âyanmo kâengatuly, mâuntuhomoem. Alâ myani uguondo adakobâze idâly. Tâgasely iraynâ tagâ tâwanuneim modoram aguely: “Iegasely ise. Âdara kodopâdyly kâuntuba olâ urâ. Iwanumone aietaungâ. Auguehobyry aietaungâ” kely myani. Pyanta eniram aguely myani: “Inanaynlâne ikâ, pyanta mâenahunguehoem kodopâduo” kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Awylygue myani tâwanuneim modo âsewanilymo lelâ. Nâsewaniba nipyramo. Âdara âtâ sodo odopâdyly nutubamo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Arâ lâpylâ aunlolâ kodopâdyly iwânwântaungâ. Auguehobyry amânhepyra tâiseba itaungâ. Tyneim, xykynri warâ ara inkâba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yeinwâmpyra tâiseba itaungâ. Auguehobyry amânhepyra tâiseba itaungâ, kodopâdyly ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Azagâ iguandyly kulâ myani Páscoa etyry adaguhoem, judeu domodo idamudo Egitodâba âsemaguehomobyry etyguedo, pão ioliho pebaom nhedawyn-homo. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ âjigue âtunâguedylymo myani, âdara Jesus tianwânehonly, tyâen-honly warâ wâgâ. Kurâ domodo nhutudyzebamo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aituo aguelymo: — Koendâpa ise enra âty ume sawâdyly. Toenzepa ise kurâdo âzetygueni modo. Jesus sawâtobyry egary indadylymo-ro watay, kagâ toenzepa iewiâpazemo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus idâondyly âtâ anary Betanianra. Târâ tatay myani idâly Simão tâjimituguelygue tâwâneimbyry etyram. Jesus, eynynonro modo warâ Simão agâ âwinduadylymo myani. Âwinduadylymo ume, pekodo Jesus iopaji saindyly. Alabastrogue uriza etary xygatybygue tâmase; uriza tâwâenseim nardogue tumyke mârâ. Etary enahuru nhukagâdyly, tienahunguehoem. Ilâpyryem uriza tyânrângueim nhapâdyly Jesus nhangahu onwa. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Uriza nhapâdyly tientuo, tonlo modo, aidyly nehoguebyra. Aituo aguelymo: — Etaungâ! Awâkâ pekodo uriza tâwâenseim alâ kulâ nhumedyly! ");
INSERT INTO bkqNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Awârâ uriza vende iedyly-ro watay, trezentas moedas takaze kehoem tâise idinherugu. Koendâ tâise vende nhedyly, ebyry âdy pebaom modoram tiunduhoem — kelymo. Toenzepa pekodo nhunâguedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aituo Jesus aguely: — Arâ adâkezeba itaungâ merâ pekodoam. Kâjiwypazenehonwâdaundâ. Koendonro merâ urâem anhekyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aunlolâ ise âdy pebaom modope awyly; ize matomobyry aralâ ise âdylâ mâundulymo. Urâ olâ ise âdiempa kulâ agâmo wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Idânârâ adienkyly ara anientai. Wonwa uriza tyânrângueim niapâdai, yigueduo, ieguepybyry etadâdo odaxi ietoem wondyly ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Merâ anhetyby ânguy nenanânehonwâbyra ise. Unâ koendonro egatuly âdykâlâ-ro watay, tânanâguezeinlâ ise merâ aitobyry. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aituo myani Judas xidadâ Queriote donro Jesus eynynonro modo ewy, idâly kurâdo eynynâ Deus agâ aguewâni modo iwymârydoam, eagâmo âtunâgueze. Eagâmo âseinwândyly myani Jesus eyanmo tiengamehoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aguely tindatuo, toenzepa kehoem iomazelymo. — Xina emaxi Jesus mâengamely-ro watay, ipywaze xina — kelymo myani. Eagâmo adâkebygueduolâ kehoem Judas, âdara Jesus tiengamehoem adâidyly awyly nhutuly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Egitodâba tydamudo âsemaguehomobyry tienanâguehoem, judeu domodo pão ioliho pebaom nhedawyn-ho, kordeiru nhâhomo warâ, âty Páscoa keho oday awylygue myani Jesus eynynonro modo aguelymo eyam: — Âdykâka ise pyni iwâkuru xina anhenehondyze mawyly, xirâ Páscoa ume kydawinduatoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aituo Jesus azagâ tynynonro ewy ingonodyly âji nhonse. Egaselymo iray Jesus aguely eyanmo: — Idâwâtaungâ xidadâ Jerusalémram. Myarâ aintuomo, uguondo âmugâ oday paru sani iose âmaemo. Idâwâtaungâ eagâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Igawântaungâ egawântobyry âtâ odaji. Mârâ âtâ sodo agâ aguewâtaungâ: “Pymâ mawânkâ âty Páscoa tientyguedyze tarâ xirâ kopae. Âdykonlo âtâ sahomery oday kaise tynynonro modo agâ kordeiru nhunru nhâdyly, pão ioliho pebaom nhedawynly warâ?” kewâtaungâ âtâ sodoram. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eagâlâ ise mâkulymo, âtâ sahomery kaynonro odaji. Târâ ise sahomery imeâgâ keba nhenehonly Tâlâ ise târâ mesa, tâzekado, idânârâ ize kydato modo warâ. Târâ ise kypyniry amânhenehonlymo — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesus aguepygueduo, azakâlâ idâlymo. Saindylymo xidadâram. Saintybyem, Jesus aguehobyry ara lelâ nhedylymo. Mâkâ uguondo agâ oxiodylymo, idâlymo eagâ, âtâ nhedylymo warâ, Páscoa tientyguedomoem. Pyni modo aienehonrimbyryem myani odopâdylymo Jesus eydâ atoam. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iguampygueduo, Jesus myarâ idâly tynynonro modo agâ. Saindylymo. Âwinduadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Âjigue tâwinduataymo, Jesus aguely eyanmo: — Idataungâ auguely. Tokalâ âmaemo ewy yâdysedo modo emaxi iegameze. Yagâ âwinduani modo ewylâ ise iegameim — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesus agueduo, itywandylymo. Mâkâ, mâkâ warâ aguelymo: — Urâ mâkeba ise igamenri, Pymâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aituo Jesus aguely: — Âmaemo ewylâ olâ ise iegamerim, yagâ pão edawynrim modo ewylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Deus itaumbyry egatuwâni modo iweniwânmy ywâgâ. Uguondo Kaynâpa Âetyby âdyoze, kelymo myakâwâm. Aguehomobyry ara ise aidyly. Toenzepa âsenagazeze olâ yizepanro modo emaxi iegamerimbyry. Niazepalâ wânkâ nidyse! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tâwinduatay, Jesus pão nhanâdyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ pão mâundulygue — kely. Agueypyem, pão nhepajiwâdyly. Mâkânra, mâkânra warâ nhuduly, nhedawyn-homoem. Aituo aguely eyanmo: — Sawâtaungâ. Xirâ pão kâempajiwâdyby, wodo xirâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ilâpyryem kopu vinhugue taseim tâmaxi nhedyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ vinhu mâundulygue — kely. Agueypyem, mâkânra, mâkânra warâ nhuduly nhenyhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aituo Jesus aguely: — Unulâ xirâ. Tâunkeze ise yiguely, toenzepa kurâdo emakeze. “Ynynonro modo emakeze urâ” Deus kehobyry mawânrâ. Awylygue ise unu tyapâze yigueduo, iwelo tâdâsemaguehobe Deus nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xirâ pygueduo, Páscoa kâentyguedombyra, vinhu kâenyombyra warâ wao ise urâ agâmo, Pabai Deus eynynonro modo myarâ pymâem atoram saindylymo ara. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Âty âwanikebygueduo igâtudylymo Deus tionmaendoem. Igâtudybyem idâlymo iwy Se Oliveira Ekaram. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aituo tâtâlymo ume, Jesus aguely tynynonro modoram: — Xirâ kopae idânârâ âwiense âmaemo. Wodokeze âmaemo. Deus itaumbyry sawo wâgâ iwenibyem: “Kaneru sodo xyâduo, idânârâ eguy modo adapâeguyze” kewânmy Deus. Arâ ise ayedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yigueduo, kurâem itonze olâ urâ. Kurâem witombygueduo, waunroenlâ ise Galileiaram udâly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Agueduo Pedro aguely: — Tâwâlâ wâne ise idânârâ odokelymo. Urâ olâ ise odokeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus olâ warâ eyam aguely: — Xirâ kopae, aukuma igâtudyly azagâ ieto iraynâ, azagâ tokalâ warâ ise “Jesus kâuntuwâbyra urâ” myguely. Xirâ mâuntudyze wato kuru — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro olâ agueondyly lelâ: — “Jesus kâuntuwâbyra urâ” uguewâpyra ise urâ. Tâwâlâ ise agâlâ yâlymo. “Jesus kâuntuwâbyra urâ” uguepa olâ ise urâ-ro warâ — kely. Idânârâ Jesus eynynonro modo aguelymo lâpylâ: — “Jesus kâuntuwâbyra urâ” xina kewâpyra lâpylâ ise — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aituo Jesus, tynynonro modo agâ âji Getsemaniram idâlymo. Myarâ saintybyem myani Jesus eyanmo aguely: — Tarâlâ wao itaungâ, ikadaungâ warâ, Deus agâ agueze udâday — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Adâkebygueduo, Jesus Pedroram, Tiagoram, Joãoram warâ aguely: — Yagâ âetaungâ; eagonro modo lelâ ise taunlo — kely. Aituo eagâ idâlymo iwague nekâ. Târâ myani toenzepa kehoem Jesus itywandyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aituo aguely: — Toenzepa enra ytynru, yigueho ara kehoem. Tarâlâ wao itaungâ. Tykyzeba olâ itaungâ, ynynâ Deus agâ amyguehomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Âdiempa waunroem idâly myani. Târâ âzeguhoam idyly, Deus agâ adâkehoem: — Pabai, Pabai, idânârâ adyese âmâ. Toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly ize mato aralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Deus agâ agueypyem, Pedro, Tiago, João warâ âxiân-hobyryram idâly, xykylymo ume. Xuagueânimobyryem, aguely Pedroam: — Âykyly enra, Pedro. Agonrodo lâpylâ warâ xykylymo enra. Âdiempalâ ynynâ Deus agâ amyguehomoem âykyba mitoem nudupa kuru? — kely. Aituo eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","— Nhaum, xuagueypyem lelâ itaungâ, inanaynmolâ warâ. Satanás umohomoem aienehonze keze. Deusram ekadaungâ, Satanás ize ato amânhepyra mitomoem. Deus eon-honru peba kulâ yagâ tâdâsenagazedyly mâenmaenwâbyra ise âmaemo, yagâ mâsenagazedyze mawylymo umelâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aituo Jesus idâondyly âdiempa waunroem, Deus agâ agueonse: — Pabai, idânârâ adyese âmâ. Toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly, ize mato aralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ilâpyryem myani odopâdondyly Pedro, Tiago, João warâ eydâ atoram. Xykyondybymoem awyly nhedyly. Toenzepa myani xuedunumo, enuzehomoemba. Xykylymo tientuo, âduagueân-honlymo, aguely: — Âykylymo kulâ enra. Inuzeba mataunaze, Deus agâ amyguehomoem — kely. Tywypadylymogue âdakepamo myani eyam. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aituo Deus agâ agueze idâondyly. Ilâpyryem odopâdondyly tynynonro modo eydâ atoam. Nhuagueântondylymo. Aituo agueondyly eyanmo: — Âykylymo kulâ enra. Inuzeba lelâ mataunaze, Deus agâ amyguehomoem. Alâ! Iweâ lelâlâ yizepaom modo emaxi âduduoze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Autaungâ. Inoro; eagâmo kydoxioda. Etaungâ. Awâkâlâ iegamerim saindyly! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus aguely ume myani Judas saindyly, Jesus eynynonrolâ kâinane mâkâ. Toenzepa kurâdo eynynâ Deus agâ aguewâni modo iwymârydo ingonotaymby modo, Moisés inweniby wâgâ enomedâni ingonotaymby modo, kywymârydo ingonotaymby modo warâ Judas agâ saindylymo. Espadague, segue warâ tâmatune kehoem saindylymo, Jesus sawâse. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Taindylymo ume Judas eyanmo aguely: — Uguondo konhonuguguyly, mâkâlâ ise mâkâ, Jesuslâ. Tâwâlâ ise manwâdylymo. Kâzemakehonwâdaundâne — kely myani Judas. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aituo Judas saindyly Jesus iopaji, aguely: — Pymâ — kely. Aguenripyryem Jesus iwaparydâ nhonugudyly; tataen-ho agâ adâito ara nhedaenkuly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aituo Judas agâ idâwâtyby modo Jesus nhawâdylymo, nhemakâjilymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesus eynynonro ewy tydahoru ety odayba nhetyly. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru agâ tâwaneim inwantazagâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus aguely kurâdo tawâse idâypy modoram: — Espadague, segue warâ tâmase kehoem yawâse mâewylymo, tâmagazeim urâ-ro waunlo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yawâtomo tuduzelâ keankâ saguhoem, kyâho pebalâ. Kopaelâgâembaba keankâ Deus ety idaseray, agâmo agueze wawyly. Târâlâ yawâpyra olâ mataunaguynre. Yawâto odayba awylygue keankâ ilâenlâ yawâpyra mawylymo. Tâwâlâ yawâtaungâ lelâ, âdaitybyemba wawyly umelâ. Arâlâma ywâgâ iwenibyem awyly Deus itaumbyry awo wâgâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesus sawâtuo, idânârâ kehoem Jesus eynynonro modo nhodokelymo, âwiendylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Salokuzenomo BOH waunlogue tâtyeim lelâ myani Jesus nhataymo nhapygue idâim. Mâkâ sawâse kewânmo lâpylâmy. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tâty tywogonro wâgâ tadawâhoduo, âzetyguewâm olâmy; tâtyembalâ myani âwiendyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ilâpygueduo, Jesus nhadylymo kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru etyram. Idânârâ pymâ tynruneim modo târâ âtâdyguybyem awylymo. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo, idânârâ uguondo modo tynrenseim warâ myani tonlo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Myarâ idâdaymo, âgânâ kehoem Pedro idâly, kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru ety idaseraji. Tâgawânse, tâkaze warâ myani peto opaji, guarda domodo agâ âunse. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, idânârâ judeu domodo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ myani âjigue aguelymo âtâ oday: — Azagâ atay, azagâ tokalâ warâ atay kurâ domodo ewy kuduinre, âzekiba lelâ Jesus wâgâ ewentâniem, kyâen-hon-hoem — kelymo. Arâ ize tatomo ara kurâdo ewy nepyramo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Toenzepa mawânkâ kurâdo Jesus ewentâze kewâni modo. Iozepa kulâ aguewâdylymo. Âikâ âikâ warâ kulâ aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ilâpyryem tonlo modo ewy saudyly pymâdo enanaym, Jesus ewentâze kewâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","— “Deus ety uguondo modo intâdyby sakalagueze urâ. Azagâ emedyly idyly ara saunâtonze urâ” kely, xina nidadâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Toenzepa kurâdo Jesus ewentâni, “Deus ety sakalagueze urâ” kehobyry wâgâ wâne. Nâzeinwân-hombamo olâ, âzekiba aguenri peba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aguelymo idanipyryem, kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru saudyly idânârâ tâzenanaym, Jesus nhapâiguely: — Âwâgâ aguelymo midatailâ. Âkealâ, âkealâba inwentâdomo awyly ise amygueho? Âdalâ myguepaka ise âmâ mâsemaguehoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus olâ âdakepa myani tâsemaguehoem. Aituo kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru nhapâigueondyly: — Messiaslâka âmâ, Deus Ingonotyby? Deus koendonro imerylâ âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aituo Jesus in-hoguly: — Messiaslâ urâ, Deus imerylâ warâ. Xirâpygueduo ekadybyem ise urâ, Deus ton-honreim ahoru eynynâ. Eagâ ise pymâem wawyly. Eunu duay ise Deus eydâpa kâewyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Toenzepa kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru iewiâpadyly, “Deus imerylâ urâ” Jesus kely tindatuo. Tyewiâkygue tâty tywogonrolâ nhaunguely. Pymâdo târâ âtâdyguywâdyby modoram aguely: — Ânguy kingâsedondaymba ise kurâ, Jesus ewentâniem. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Deus nunâguedai awâkâ Jesus. “Deus imerylâ urâ” keduo, Deus agâ âzekiba tawylylâ agueho. Ânguy kiunhotaymba ise kurâ, ewentâniem. Midataimolâ, Deus wâgâ aguely. Âdara iedylyka inanajimo inakanhe kehobyry wâgâ? — kely. Aituo pymâ domodo aguely: — Uguondo inakai kulâ awâkâ! Xyâly lelâ awâkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aituo nhedakudâdylymo, nhenuahulymo, nhapiogulymo nhedylymo. — Ânguyka apiogurim? Apiogüimbyry xutugâ, âkealâ kuru Deus Ingonotyby matay — kelymo. Ilâpyryem guarda domodoram nhegamelymo. Guarda domodoram âjiwapagainholy, adapioguoly âieholy myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jesus pymâdo enado atay, Pedro târâ taseraylâ. Pekodo târâ tâwaneim ewy Pedro einkâ sakadyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro âundyly nhedyly. Koendâ kehoem enipyryem aguely: — Jesus Nazaré donro eynynonro modo ewylâ âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","— Mâkâ mâkeba urâ. Kâuntuwâbyra urâ awâkâ. Ânguyka awâkâ Jesus, iwâgâ amygueho? — kely myani Pedro. Agueypyem, pyanta taseraji tâdâwântoram Pedro idâly. Mârâ umelâ myani aukuma igâtudyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Eagonro pekodo târâ tâwaneim modo ewy, Pedro tientuo, iwaguepaom modoram aguely: — Jesus eynynonro ewy awâkâ uguondo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mâkâ pekodo aguely tindatuo, Pedro agueondyly: — Âdykâ Jesus eynynonroem witaymba urâ. Kâuntuwâbyra urâ awâkâ — kely. Ilâpyryem tonlo modo agueondyly: — Jesus eynynonrolâ âmâ. Tutuze xina, Galiléia donro mawyly, earamolâma amyguely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aituo Pedro agueondyly: — Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ uguondo amyguehomo! Tutuze Deus âkealâ auguely awyly. Tâwâlâ ise Deus ienagazenehonly, uguewâdyly kulâ-ro watay — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedro aguely umelâ, aukuma igâtudondyly. Tindatuo Pedro, Jesus tyam aguehobyry nhenanâguely, “Xirâ kopae, aukuma azagâ igâtudyly iraynâ, azagâ tokalâ warâ ise ‘Jesus kâuntuwâbyra urâ’ myguely” kehobyry. Aguehobyry tienanâgueduo, toenzepa Pedro âjityendyly, ohogüendyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Emetybyem myani pymâ tynrentuneim modo âtâdyguyly: kurâdo eynynâ Deus agâ aguewâni modo iwymârydo; Moisés inweniby wâgâ enomedâni modo; judeu domodo iwymârydo, akaemo Sinédrio kelygue tâzekeim; iwymâry modo warâ. Âtunâguedylymo, âdara kuru Jesus tyâen-honlymo awyly tiuntuhomoem. Guarda domodoram nhekâjien-honlymo, nhaleholymo, nhegamehonlymo warâ Pilatosram, pymâ Romadâpa igonotybynra. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesus tânado atay, Pilatos nhapâiguely: — Judeu domodo iwymâry kuruka âmâ? — kely. Jesus in-hoguly: — Mâkâlâ urâ, amygueho ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo toenzepa myani Jesus nhewentâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aituo Pilatos aguely Jesusram: — Akaemo iwentâdo midatailâ. Amyguehonly mâin-hogubaka ise âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesus olâ âdakepa. Toenzepa kehoem Pilatos âseguâdâdyly, Jesus tâsemaguehoem âdakepa awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Páscoa etyguedyly ume, aunlolâ mykâinane Pilatos etadâdyby ewy tokalâ nhetaguehonly, kurâdo nhekadybylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ilâ ume tâlâ myani uguondo kadeia oday tâtagueim, Barrabásgue tâzekeim. Târâlâ mâkâ, tagonrodo agâ, pymâ Roma donro agâ âjizepa awylymogue; kyâim awylymogue warâ nhetadâdybymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Agui kurâdo idâwânmy Pilatosram ekaze: — Âty ume aunlolâ ani etadâdyby ewy mâentaguehonly. Uguondo xina etaguedyze ato etaguehongâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","— Âwymârymo Jesus âdara kânhenehonlyka ize matomo? Kâinmoen-hondyzeka âmaemo? — kely Pilatos. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","“Ekâjiguen-hongâ” kelymo-ro waunlo ara myani, enanaji. Tâsewânilygue kulâ akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Jesus tyam nhegamely awyly, tutuze myani Pilatos. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo toenzepa kurâdoram aguelymo: — Barrabás nhetaguehoem ekadaungâ Pilatosram. Jesus xyâhoem ekadaungâ-ro warâ — kelymo. Akaemo aguehobyry ara kurâdo aguely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aituo Pilatos nhapâigueondyly: — Merâ uguondo “Pymâ” myguehomo âdakânhedylyka ize matomo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aituo adaenkelymo: — Kruz wâgâ sakâjien-hongâ iguehoem! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","— Âdaituo? Ienanaji, âda nitaymba merâ iguehoem — kely Pilatos. Agueduo olâ idânârâ adaenkelymo ton-honre kehoem: — Kruz wâgâ sakâjien-hongâ iguehoem! — keondylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kurâdo tionmazeândyze myani Pilatos. Awylygue Barrabás nhetaguehonly, nhekadomobyry ara. Ilâpyryem Roma donro sodadu domodoram aguely: — Jesus sapioguwâdaungâ. Ilâpyryem ise mandylymo, kruz onwa sakâjize-ro warâ, iguehoem — kely Pilatos. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ilâpyryem sodadu domodo Jesus nhadyly Pilatos ety idaseraji. Idânârâ sodadu domodo târâ âtâdyguylymo, Jesus âwankuem tientomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Âtâ BOH waunlo tapabileingue nhetydâdylymo, pymâ âzetydâdo ara, âwankuem tientomoem. Tyguyreim koroaem xygatyby myani mâkâ nhangahu onwa nhekylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","— Tynrenseim lelâlâ âmâ, judeu domodo iwymâry kuru! — kelymo, âwankuem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Edakudâmâmomy, segue nhangatainwâmomy warâ. Enado âzeguhoam idylymo, pymâ enado adâitomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Âwankuem ienipyryem âtâ BOH waunlo tapabileim Jesus wâgâpa nhetylymo. Ety iwogonropyryguelâ nhetydâdylymo. Ilâpyryem nhadylymo kuohoram, kruz se xygatyby onwa sakâjize. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ânwa oze tâtâdaymo, uguondo Simão agâ oxiodylymo. Xidadâ Cirene donro mâkâ, Alexandre, Rufo warâ nhunwym. Xidadâ odaji saindyly myani poji ananobyryem. Tiontuo, sodadu domodo kruz Jesus tiankâjiho eyam nhanânehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Golgotaram myani Jesus nhadylymo. (Iwy Calvariogue tâzekeim lâpylâ, tâjiangahubyry ara enurunugue.) ");
INSERT INTO bkqNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Târâ vinhu mirra agâ ietybygue sakuize kelymo, kruz onwa takâjily newânebyra itoem wâne, nenypa olâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","27","Nove horas atay myani kruz onwa nhakâjilymo. Jesus merâ, judeu domodo iwymâry kuru kely iweniby sakâjiwânmomy Jesus nhangawaym kruz wâgâ. Idânârâ âdaituo Jesus nhakâjilymo awyly xutuhoem mârâ anhedylymo. Ilâem lâpylâ azagâ tâmagaduneim modo nhakâjilymo. Tokalâ Jesus ahoru eynynâ, eagonro pâem eynynâ warâ nhakâjilymo. Sakâjirimbyryem, Jesus ety iwogonropyry nhepajiwâdylymo. Dadu nhamelymo myani, ânguy, ânguy warâ Jesus ety iwogonropyry emakeim awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Deus itaumbyry saguho wâgâ iweniby ara kehoem aidylymo. “Mâkâ Deus Ingonotyby inakanhe kehoem aityby ara ise âzenagazeoly” kewânmy. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tâinkâ sakadaynrim modoram âwankuem âieholy. Angakânilymo, inwykelymo warâ. — “Deus ety sakalagueze urâ” myguema. “Azagâ emedyly idyly ara saunâtonze urâ” mygue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ton-honreim lelâlâ matay, tâwâlâ âsemaguegâ! Kruz wâgâpa adakâjiguegâ, âytâguygâ warâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ âwankuem nhedylymo, aguelymo: — Âkelo modo nemake, tâwâlâ nâsemagueba olâ! ");
INSERT INTO bkqNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Messias urâ, Deus Ingonotyby” nygue. “Âwymârymo kuru urâ” nygue. Kruz wâgâpa xytâguyly watay, Messiaslâ awyly einwânse kurâ — kelymo myani. Akaemo azagâ tâmagaduneim modo eagâ sakâjiwâdyby modoram âwankuem âieholy lelâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kuotatay idânârâ iamadyly. Iamapygueduo três horas lelâ myani iamu. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Azagâ tokalâ warâ horas ituo, Jesus adaenkely: — Eloí, Eloí, lemá sabactani? — kely. (“Pabai Deus, âdaituoka wodokely?” keze aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tonlo modo, koendâ nidapyramo tawylygue, Elias ingâsedyly ara nhenehonlymo myani, Deus eynynâ agueim lâpylâ mykâinane mâkâ. Aituo aguelymo: — Idataungâ. Elias awâkâ ingâsedyly, tâmakehoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Akaemo ewy egatudyly myani, esponja, vinhu nhewantybygue ikuize. Tinkuibygueduo, se iopiry onwa nhekâjily. Jesus nhugakâin-hoem wâne nhuduly. Aituo eagonro modo aguely: — Ine wao. Elias ingâseguyly. Elias kruz wâgâpa etyze âewyly kyzene wao — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aituo Jesus adaenkeondyly ago kehoem, tyiguehoem kuru. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iguely ume kehoem Deus ety oday Âji Tynrenseim xuahuho tyxieim iotagâ adauguely kaynonrobyryem, on-yam; Deus, kurâdo agâ tygue ito myani mârâ xuahuru. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Târâ Jesus sakâjihobyry ipebaylâ myani sodadu iwymâry. Jesus iguely emâmy. Iguely tientuo aguely: — Deus imery lelâlâ keanra enra merâ uguondo! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tâlâ myani târâ pekodo modo, iwaguelâ olâ nhedylymo. Maria, (Magdala donro), Salomé, Maria (José, iukonolâ Tiago warâ ise), eagonro pekodo modo warâ lâpylâ iduanomo. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Xirâ modo iraynâ, Galiléia eynynâ atay, tâlâ tatogue Jesus emawyadânibyry akaemo pekodo modo. Tâlâ lâpylâ târâ pekodo modo Jesus nhapyguenibyry modo Jerusalémram saintay. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tâzekobyzeguehoem todohondo âwanikely myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iguandyly iraynâ myani José idâly tâegane kehoem pymâ Pilatos agâ agueze. Xidadâ Arimatéia donro myani mâkâ. Judeu domodo iwymâry Sinédrio kelygue tâzekeim ewy myani. Idânârâ kurâdoram tâdutuoze, tâdyren-honze warâ mykâinane. Idânârâ kurâdo iwymâryem Deus idyly sainto tânuenze mykâinane. Pilatos etyram saindyly, aguely: — Jesus nigueaki, Pymâ. Kruz wâgâpa kâyntâguyândyze olâ urâ, tuhu imâsedo tâtagueim odaji kâenkanâdoem. Tâwâlâ kâyntâguyândyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Jesus nigueaki” kely tindatuo, Pilatos neinwâmpyra myani. Awylygue sodadu domodo iwymâry Gólgota donrobyry ingâsedyly. Sodadu domodo iwymâry saintuo myani nhapâiguely: — Âkealâ “Jesus nigueaki” kehonly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aituo sodadu domodo iwymâry aguely: — Âkealâ, nigueaki lelâlâ — kely. Aituo Pilatos Joséram aguely: — Tâwâlâ, Jesus eguepybyry sakâ tuhu imâsedo tâtagueim odaxi — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agueduo, José idâly. Âtâ tapaileim linhugueto tâwâenseim nhanâdyly. Ilâpyryem Jesus eguepybyry kruz wâgâpa nhytâguyândyly, intuwynly warâ. Ilâpygueduo, eguepybyry nhetadâdyly tuhu imâsedo tâtagueim esagueyby odaji. Myarâ ienipyryem, nhenahunlymo tuhu imâsedogue. ");
INSERT INTO bkqNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Azagâ pekodo Jesus eguepybyry sadyly etaunmâmomy, Maria (Magdala donro), Maria (José ise) warâ. Âdykâ Jesus eguepybyry etadâdyly awyly emâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tâzekobyzegueho iguampygueduo Maria Magdala donro, Salomé, Maria (Tiago ise) warâ idâlymo uriza tyânrângueim sanâse, Jesus eguepybyry onwa tientomoem, tâzewenrymo ara. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kopaelâgâem, pealâ idâlymo Jesus eguepybyry etadâdobyryam. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ânwa oze tâtâday myani âjigue xunâgumo: — Pekodo modo lelâ kurâ. Ânguyka ise tuhu imâsedo tâtagueim enahun-hombyry etyim? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tuhu imâsedo awylygue arâ aguelymo. Iwaguepa saintybyem olâ tâtagueim enahun-hobyry tuhu imâsedo ejikeybyem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aituo myani Jesus eguepybyry etadâdobyryram âwândylymo. Tâwântaymo, salokuzenomo ekadyby iwaguelâ tahoru eynynâ nhedylymo. Âtâ tapekeingue âzetydâdybyem awyly. Tientuo, pekodo modo toenzepa âseanedyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mâkâ olâ myani aguely: — Tâseanezeba itaungâ. Tutuze urâ, Jesus Nazaré donro mâwinlymo awyly, kruz onwa sakâjiby. Tarâpa olâ mâkâ. Ipa, kurâem nitondai! Etaungârâ etadâdobyryam. Ânguy lâpeba tarâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Idâwâtaungâ, Pedro domodoram egatuze: “Waunroenlâ ise Galileiaram idâly. Târâ ise âwânwândylymo, mâendylymo warâ aguehobyry aralâ” myguelymo ise eyanmo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aituo pekodo modo egasely. Inepa kehoem Jesus eguepybyry etadâdobyry nhodokelymo. Âseguâdâdylymo, toenzepa kehoem adapânilymo, tâseaneduo. Xidadâram todopâdylymo ume ânguyram negatubamo tientyby modo, tindatyby modo warâ. Toenzepa lelâlâ ekuâgumo. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo pealâ, Jesus kurâem itombygueduo, Maria Magdala donro waunroem kuru eni. Iweâpa xirâ modo aidyly iraynâ, Jesus mâkâ pekodo odano sete lelâ kadopâ tyânkyze myani. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesus kurâem itondybyem awyly tientuo, idâly eataen-ho modoram Jesus kurâem itondybyem awyly egatuze. Toenzepa myani itynrumo, eogunrumo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eyanmo saintybyem, Maria Magdala donro aguely: — Jesus kurâem nitondai! Urâ lelâlâ setai — kely. Agueduo neinwâmpyramo. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ilâpyryem azagâ Jesus einwânni modo idâly eagonro âtâ anaxi. Ânwa oze awylymo ume, Jesus âepanâguely eyanmo. Saguhoem tientobyry arapa tiendyly awylygue myani ânguy nutuba mâkâlâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jesus lelâlâ mâkâ awyly tiuntuduomo, Jerusalémram odopâdylymo tagonro modoram, Jesus tientobyry egatuze. Akaemo azagâ aguely neinwâmpyramo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kopae onze lelâ uguondo modo Jesus eynynonro âjigue âwinduadylymo ume, Jesus âepanâguely eyanmo. Aituo aguely: — “Jesus kurâem nitondai. Xina netai kurâem itondyby” kehonduolâ mâinwâmpyra lâgâlâ âmaemo. Tâegane kehoem âmaemo, mâindatybymo mâinwântomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Adâkebygueduo, agueondyly: — Idâwâtaungâ tâinkâ lelâba Deus itaumbyry idânârâ kurâdoram agueze. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Warâ aguewâtaungâ: “Jesus mâinwântuomo, Jesus einwânniem mawylymo mâenehon-homoem batiza âiehowâdaungâ, Deus imakezemo, aunloenlâ eagâ mitomoem. Jesus mâinwâmpyra âmaemo watay, Deus eydâ atoram aintaymba ise âmaemo.” Warâ idânârâam aguewâtaunda. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yeinwântaynrim modoram won-honru xuduze urâ, adyesenry modo kehoem anhetomoem. Won-honrugue kurâdo odaypa kadopâ nhânkyze âmaemo. Won-honrugue tâjitanru âdykâ tydasenry agueze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Âgâu manwâdylymo, venenu mâenylymo warâ watay, âda mitaymba ise âmaemo. Won-honrugue tâwânuneim modo kua iese âmaemo, imarymogue MÂʼ mânhetuomo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tynynonro modo agâ aguepygueduo, Kywymâry Jesus adaholy Deus eydâ atoam. Deus ahoru eynynâ ekadybyem awyly, eagâ pymâem tâitoem. ");
INSERT INTO bkqNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesus Deusram idâpygueduo myani eynynonro modo Deus itaumbyry egatuze idâlymo. Idânârâ âtâ anakâ tâtâhobyrydâ mykâinane aguelymo Jesus wâgâ. Jesuslâ eon-honrumo xuduim; tywâgâ unâ iwâkuru nhegatudaymo, mâkâlâ eon-honrumo xudunri adyesenry modo anhetomoem. Mârâ anhetuomo, kurâ domodo tutuze âkealâ aguelymo awyly. Alâ kulâ. Marcos");
INSERT INTO bkqNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pymâ Teófilo, xirâ pape wâgâ âdaise Jesus onro anaym atobyry, anhetyby modo warâ wâgâ mâuntuhoem waunroem kâinwenily mâkeba xirâ. Eagonro modo iweniwânmomy lâpylâ anhetaymby modo wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Saguhoem Jesus aidyly etaynrimbyry modo agâ âtunâguemâmomy. Egatuhobyry ara pylâ iwâgâ aguelymo, inwenilymo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Urâ lâpylâ, kura kehoem koendâ aitaymby modo ara kâuntuhoem awidyly. Ienanaji, koendâ âyam kâinwenily, koendâ kehoem âurutoem Jesus aitobyry wâgâ, aguehobyry wâgâ warâ, adaguhobyrylâ, xypyryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Toenzepa Jesus wâgâ tâzenomedâoze âmâ. Xirâ kâinwenily olâ, âkealâ kuru egary awyly mâuntuhoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Saguhoem kâinwenily ise, Zacarias, iwydylâ warâ aitomobyry wâgâ. Herodes, judeu domodo eonronru anaym pymâem awyly ume tâlâ myakâwâm uguondo Zacarias keho, iwydylâ Isabel warâ, saguhoem kurâdo eynynâ Deus agâ aguewâni modo ipemugubyry myakâwâm mâkâ. Eagâ Zacarias âsewaniho myakâwâm “Abias Ipemugudo” kelygue tâzekeim. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarias, Isabel warâ koendâ mykâinane aidylymo Deus ize ato ara lelâ. Judeu domodoram Deus aguehobyry modo ara lelâ mykâinane aidylymo. Tâwentâzeba tâitomoem âdy inakai aniempyramo mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tymeguebamo myakâwâm, imezerim keba Isabel awylygue, agaityoem iso, aripiem iwydy warâ awylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Deus ety oday tâwanu aiese myakâwâm Zacarias, âsewaniho oday awylygue. Akaemolâ mykâinane tagonrodo iduakeim âdylâ aieniem, tâwâlâ, tâwâlâ warâ tâwanu xuduypy anhetomoem. Zacarias myakâwâm induakelymo se atuby tyânrângueim Deusram egameyby iaduâniem. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Deus ety odaji egawândyly myakâwâm se satuby tyânrângueim modo iaduânse. Ilâ iaduântay mykâinane kuoho kurâ domodo Deus agâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aituo myakâwâm anju kaynâpa âetyby Zacariasdâ âepanâguely. XYDYK warâ myakâwâm, mesa se satuby tyânrângueim iaduânto sahoru eynynâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mâkâ tientuo myakâwâm Zacarias toenzepa âseanedyly. Âda tâidyly nutuba idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aituo myakâwâm anju aguely eyam: — Tâseanezeba ikâ, Zacarias. Deus amyguely nidatai. Mâenkadyby ara aiese lelâ. Âwydy adamyze lelâ. João kelygue ise mâenzetâdyly-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Toenzepa ise iazeduo mohomaendyly, kurâdo ohomaenze lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Deus xurâem, uguondo tywyneim ise mâkâ. Vinhu enynri keba, toku ikaji ini keba warâ ise mâkâ. Niazepa awyly umelâ ise Deus Ispiritury Koendonro eagâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israelita domodo Kywymâry Deus nheinwântoem aienehonze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kurâ domodo koendâ iese Kywymâry sainto iray. Deus itaumbyry egaturin-em iesemo warâ. Deus Ispiritury myakâwâm Elias eon-honru tuduze, myara ise âmery agâ awyly, tâjimery modo tunwym agâ koendâ itoem aiese. Deus einwântânrybyry modoram, Deus einwânehonze. Warâ ise Israel donro modo koendâ nhedyly, Kywymâry saindyly iray — kely myakâwâm anju Zacariasram. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aituo myakâwâm Zacarias aguely anjuam: — Xina nimezewâbyra ise! Agaityoem urâ, aripiem ywydy warâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aituo myakâwâm anju aguely: — Gabriel urâ. Kopaelâgâembaba Deus agâ wawyly emaryem. Mâkâlâ âyam ugononi, xirâ unâ iwâkuru auguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Auguely mâinwâmpyra wâne âmâ, aito odaxi ituo olâ auguehobyry aise. Mâinwâmpyra matobyry wâgâ âmery iazeho odaxi ise tytaremba mawyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Xunâgumo ume toenzepa myakâwâm kurâdo âtâdyguybyem awyly kuoho, Zacarias egasely inwânwânse. Âjigue aguelymo: — Iweâpa idyly enra Zacarias se satuby iaduântodâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Egaseybyem agueze kewâdyly wâne eagâmo; tytaremba itybyem lelâ. Tâmaryguelâ egatuze kewâdyly târâ adâitobyry. Aituo myakâwâm aguelymo: — Deus gâlâ awâkânra târâ se satuby tyânrângueim iaduântodâ nâepanâgueagui — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Deus ety oday tâwanu ewanikeimbyryem myakâwâm Zacarias tâtyram idâly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iweâpa nipyralâ myakâwâm iwydy Isabel adamyly. Cinco nunâ ara lelâ myakâwâm âdyam negaseba awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alâ mykâinane tyangahu oday xunâgu: — Koendonro lelâlâ awâkâ Pymâ Deus urâem! Awylygue iwerâ kâpybazebyra wawyly, tymegue wawylygue; ânguy unâguebyra ise warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Seis nunâ Isabel adamybyem awyly ume myakâwâm, Deus tâmary anju ingonodyly unâ enese xidadâ imeimbyry Galiléia donro Nazaréram. Gabriel myakâwâm mâkâ Deus emary ezedy. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mariaram myakâwâm Deus itaumbyry nhadyly. Âwynsaundo myakâwâm mâkâ, ânguy nhuniby keba, José agâ ohogüinrim kehobyry, pymâ Davi iwerypyry agâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aituo myakâwâm anju Mariaram idâly, aguely: — Tuomare ikâ, Maria. Kywymâry Deus agâlâ, koendonro âmâem adientoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anju aguely tindatuo, Maria âpaunzedyly âda tâidyly nutuba idyly, âseguâdâdyly. Âdakeze mâkâ aguely tiuntudyze. — Âdaituoka arâ amyguely? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aituo anju aguely: — Tâseanezeba ikâ, Maria — kely. — Deus induakeyby âmâ, koendâ kehoem nhetoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","— Adamyze âmâ. Jesus kelygue ise âmery mâenzetâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Aunlo kulâ keba ise mâkâ, uguondoem ituo. “Deus ton-honreim imery” ise mâkâ. Pymâem ienehonze Deus. Tydamudo Davi pymâem atobyry ara ise âmery pymâ tâgarein-em awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","— Jacó iweompyry modo iwymâryem, enimoem warâ lâpylâ ise. Aunlolâ ise pymâem awyly, typygueim keba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aituo Maria anjuram aguely: — Âdaraka ise awârâ aidyly? Âdykâ mawânkâ uguondo ynanâbyra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aituo anju aguely: — Deus Ispiriturygue ise madamyly. Deus tâgareim Ispiritury onwa âese âmezehoem. Awylygue ise iamudo iazeim “Kywymâry Deus Imery” kelygue ezeku. Deus imery tawylygue ise, Deus ize ato lelâ anhekyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","— Âpemugu Isabel agâ aityby enanâguegâ. “Nimezewâbyra ise awâkâ” kehobyry mâkâ. Iwerâ olâ aripienlâ tymegue, seis nunâguetogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Âdy adiendyse tato adyese lelâ Deus — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aituo Maria aguely: — Âdy Deus aidyse ato tâwâlâ ise yagâ anhedyly ize tato aralâ — kely Maria. Maria aguepygueduo anju odopâdyly Deus eydâ atoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Iweâpa nipyralâ Maria ohondyly, xidadâ imeimbyry iwy donroram Judéia yan-yam tâtâhoem, Zacarias, Isabel warâ etyram. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Saintybyem, egawândyly. Typemugu Isabel nhedaenkuly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria, Isabel nhedaenkudaylâ myakâwâm Isabel ioday iamudo âjitâgüily. Deus Ispiritury Isabel enomery nhuduly, waunroem aitaynrim modo wâgâ aguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aituo Isabel aguely Mariaram: — Deus induakeyby âmâ pekodo modo enday, koendâ kehoem nhentoem, iamudo iazenri lâpylâ koendâ kehoem tientoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Odaypa iazeim iamudo ise ton-honreim kuru, ymery takaze kehoem. Tuomare olâ urâ, âmâ Kâmakerim ise ietyram mâetobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iedaenkuly tindatuo, iamudo niomazeagui woday, nâjitâgüiagui warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tuomareim lelâlâ âmâ, Deus koendonro âmâem anhetobyry wâgâ; warâ kehobyry tâinwânse mawylygue — kely Isabel Mariaram. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aituo Maria aguely: — Ywymâry Deus koendonro awyly wâgâ tunâgue urâ yangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iemakerim mâkâ. Toenzepa womaru. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Âdy mâkeba urâ, ienanânehomba olâ keankâ. Iwerâma ise idânârâ aguelymo: “Koendonroem Maria awyly Deus xurâem, Deus aguehobyry ara aitobyry wâgâ” kelymo ise. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ton-honreim lelâlâ awâkâ Deus; koendâ kehoem iedyly. Koendonro lelâ aieni awâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Koendonro tawyly tânehonze idânârâ âwankuem tyetânry modoram, adaguhobyrylâ, xypyryam kehoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Toenzepa ton-honreim awâkâ. Tâwâlâ kulâ tywâgâ koendonroem tawyly aguewâni modo tainze Deus. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ton-honruneim modo ton-honremba tyese, ton-honrenry eon-honru tuduze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Âdy pebaom modoram âdy koendonro modo tuduze Deus. Âdypeom modo olâ âdy peba tyese. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xina nâzemakeo. Israelita domodo agâ koendonroem tawyly adâkehobyry nenanânehomba Deus. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Iweâpa myakâwândy aguely tako Abraão agâ: “Koendâ ise urâ agâ, âweom agâ warâ” kewândymy. Adâkehobyry anhedyly — kely Maria. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Azagâ tokalâ warâ nunâ lelâ Maria, Isabel agâ awyly. Ilâpyryem tâtyram odopâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Alâ Isabel âjihuadâdo odaji idyly. Uguondo imeimbyry iazely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ety iwaguepaom modo, ipemugudo warâ imery iazehobyry egary indadylymo. Awylygue, Deus, Isabel agâ koendonroem kuru awyly nhutulymo. Idânârâ nhomaendylymo eagâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Iamudo iazehobyry tokalâ semana ipygueduo, âtybe myakâwâm ezedy xuduho, ilery ety iopiry satâho warâ. Mâkâ uguondo imeimbyry ilery ety nhatâlymo, judeuem awyly xutuhoem. Tonlo modo wâne Zacariasgue tienzetâdyze awylymo, nhunwym ezedyguelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aituo iamudo ise aguely: — “João” ise ezedy — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aituo aguelymo: — Âdaituo? Awârâgue tâzekeingue typemuguneba âmaemo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Isabel, “Zacarias” kelygue tienzetâdyzeba awyly tiuntuduomo, tâmarygue nhunwym nhapâiguelymo, âdakelygue tienzetâdyze awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tâmaryguelâ Zacarias tinweniho nhekadyly. Nhuduypymo wâgâ inwenily: “ ‘João’ ise iamudo ezedy” kely inwenily. Âze inweniby tientuomo, idânârâ eydonro modo âseguâdâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Awârâ ume kehoem myakâwâm Zacarias âjitain-ondyly. Deus koendonroem awyly wâgâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aituo toenzepa tonlo modo âseguâdâdylymo. Târâ tâtyuneim modo tâinkâ lelâba, iwy odakâ Judéia eynynonro awârâ modoem, mâkâ aitobyry lelâ nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Idânârâ egary idataynrimbyry modo ara awârâ wâgâ xunâgumo âpaunzedylymo, aguelymo lâpylâ warâ: — Uguondo aunlo kulâ mâkeba ise awâkâ. Âdy wânkâ ise anhekyly? — kelymo. Kywymâry Deus olâ mykâinane tâenselâ-ro warâ ton-honrugue. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aituo myakâwâm Deus Ispiritury, Zacarias enomery nhuduly. Deus aguehobyry nhegatuly: ");
INSERT INTO bkqNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","— Koendonro mawyly wâgâ xina aguely, pymâ Deus! Xina israelita domodo xurâem koendonro âmâ. Kâmaynodâpa xina etyze mâedâ. Âynynonro modo memake. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xina emakerim ton-honreim migonodâ, pymâ Davi iwerypyry. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Âunâry egatuwâni modo agâlâ myakâwâm amyguely: “Igonose urâ Davi iwerypyry, Messias” myguely. Amyguehobyry aralâ amidyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Imakezemo urâ âduerymo amaymba. Âizepanromo amaymba warâ” myguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","“Âtyendâmolâ ise urâ, âweonmo lâpylâ warâ. Agâmo auguehobyry kâenanânehonwâbyra ise urâ” warâ myakâwândy xina idamudoram amyguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Saguhoenlâ myakâwândy xina idamu Abraãoram amyguely: “Âweompyry modo iduery amaymba emakeze urâ, tyanepa auguehobyry anhetomoem. Auguehobyry agânhepyra witaymba urâ” myguely myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Warâ myakâwândy amyguely, aunloenlâ, xina israelita domodo âmâenlâ itoem, ize mato lelâ xina anhetoem warâ — kely Zacarias, Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ilâpygueduo, Zacarias tymeryram aguely: — Ymery, Deus Ton-honreim xunâry aguenri ise âmâ. Pymâ tâgareim iray todohondyly wâne saintodâ, myara ise Kywymâry saindyly iray kurâ domodo mâunrudyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Warâ ise israelita domodoram amyguely: “Deus kâmakeze. Inakanhe aguitobyry Deus xygakeze” myguely ise, ymery. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Toenzepa awâkâ Deus kywynedyly. Aunlolâ kagâ koendâ awyly. Kâmakerim igonose. Deusdâpalâ ise Kâmakerim âewyly. Kyajimanânibe awylygue wâne kytâho kiendyly myara ise mâkâ wâgâ Deusram tâdâtâly kiuntuly. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Deus wâgâ xutuen-honze kyam. Iwerâma iamu odano ara kulâ kurâ-ro. Tâjiguely amaym kulâ kurâ. Kâmakerim olâ ise ânwa iajimanâni ara. Deus agâ koendâ lelâ kyese, tyanepa eagâ kitoem — kely Zacarias tymeryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zacarias imery ago idyly, uguondoem idyly. Deus wâgâ nhutuly, iwâgâ aguely warâ Deus Ispiriturybe xuturim awylygue. Âji âdy peba atoram idâly wao, Deus itaumbyry israelita modoram tiengatuly iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","João iazepygueduo, iweâpa nipyralâ myakâwâm pymâ kuru Roma donro Augusto aguely: — Urâ Augusto, pymâ kuru. Xirâ ytaumbyry kâingonodyly idânârâ kurâdo kâentaynly modoram: “Idânârâ âmaemo âdamudomo iazehobyrydâlâ izedymo iweniehonwâdaungâ. Kurâdo kampâguely mawânrâ” — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Saguhoem kuru kurâ domodo sapâguelylâ myakâwâm Augusto pymâem awyly ume. Ilâ ume Cirênio pymâ Siriadâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aituo idânârâ kurâ domodo idâwâdylymo tydamudo iazehobyryanlâ, tâzedy iweniehonze. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aituo myakâwâm xidadâ Nazaré, Galiléia eynynonro dombyryem José idâly Belémram, Judéia eynynonro anaxi. Pymâ Davi iwerypyry myakâwâm mâkâ. Awylygue tâzedy iweniehonze idâly Belémram, Davi iazehobyryanlâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tywydy agâlâ myakâwâm José Belémram idâly. Idâhu imeâgâemba myakâwâm Maria. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belémdâ ataymolâ myakâwâm iamudo egaseho saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toenzepa myakâwâm târâ kurâdo awyly. Âtâ âxidâdomo peba myakâwâm. Awylygue myakâwâm tapirâ xykyhodâlâ âxidâdylymo. Târâ Maria imebyary uguondo imeimbyry iazely. Tymery ikowendânibyryem myakâwâm Maria nheguetunâdyly tapirâ xuato odaji. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kopae myakâwâm kaneru etaynrim modo poji anaym awylymo, Belémdâ iwaguepalâ, tâguy kaneru ese. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aituo anju âepanâguely eyanmo, Deus tâmaryem ingonotyby. Tohozely kehoem myakâwâm, Deus eydâpa âewyly awylygue. Târâ kaneru eni mododâ MAH warâ kehoem myakâwâm peto odano ara kehoem iajimadyly. Aituo toenzepa âseanedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anju olâ aguely: — Tâseanezeba itaungâ! Unâ iwâkuru egatuze xirâ âyanmo kâewyly. Idânârâ xirâ unâ idataynrim modo toenzepa iomazeze — kely myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","— Imakerinmo niazeaki iwerâ, târâ Davi iazehobyrydâ. Deus Ingonotyby mâkâ, Messias, âwymârymoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Âkealâ augueho mâuntuhomoem, tapirâ xuato oday ise uguondo imeimbyry ituwymbyem eguetunâdybyem warâ mâendylymo — kely myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Inepa lâpylâ toenzepa anju modo âepanâguewâdyly. Igâtudylymo myakâwâm: ");
INSERT INTO bkqNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","— Târâ eydâ atodâ Deus nâzehogueo! Xirâ onro anano modo nadahuliba nidâmo, turâem itoem Deus induakewâdyby modo! — kely myakâwâm, igâkymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tygâtubygueduomo myakâwâm anju domodo odopâdylymo lelâ Deusranlâ. Odopâbygueduomo myakâwâm kaneru etaynrim modo âjigue aguelymo: — Inoro Belémram, âdaityby kyzeta. Kywymâry aguehobyry kudutura — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Inepa kehoem myakâwâm idâlymo. Maria, José, warâ nhedylymo. Tapirâ xuato oday iamudo nhedylymo eguetunâdybyem, ituwymbyem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aituo anju domodo iamudo wâgâ aguehobyry nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaneru etaynrim modo aguehobyry idanipyry modo toenzepa kehoem myakâwâm âsewânilymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria tyangahu oday xunâgu mârâ nhegatuybymo wâgâ. Awârâ modo tyangahu oday nhekanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aituo myakâwâm iamudo enipyryem uguondo modo, poji anaxi odopâdylymo. Deus koendonro awyly wâgâ igâkymo Deus wâgâ iomarumo. — Koendonro lelâlâ Deus, koendonro modo kientoem, kindatoem warâ anhetobyry wâgâ — kely, igâkymo. Anju domodo aguehobyry aralâ myakâwâm nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Iamudo iazehobyry tokalâ semana itybyem awyly ume, âtybe myakâwâm, ezedy xuduho, judeu domodo aito ara. Ilery ety nhatâlymo lâpylâ myakâwâm, israelitalâ awyly xutuhoem, Deus induakeyby ewy. “Jesus” kelygue nhezetâdylymo. Maria nadamypalâ myakâwâm anju aguely: “ ‘Jesus’ kelygue ise mâenzetâdylymo” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ilâpygueduo, Maria inwânwândyly myakâwâm Deus ety odaji tâtâho saindyly, pekodo ekuize israelita Deus aguehobyry ara aito. Aituo myakâwâm Maria, José warâ iamudo Jerusalémram nhadylymo, Deusram enehonze. Kurâdo eynynâ Deus agâ agueinram nhenehonlymo, iamudo Deus xurâ awyly xutuhoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Saguhoem Moisés inweniby mawânrâ myakâwândymy: “Saguho iamudo iazeypy watay, Deus xurâem lelâ” kewândymy. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jesus ise idâly myakâwâm azagâ tawâguneim modogue tâmase, Deusram tiengamehoem. Deus ety oday tâwaneinram nhuduly, mâkâ nhâhoem, nhaduântoem warâ. Moisés inweniby wâgâ mawânrâ iwenibyem: “Pekodo âdy pebaom iamudo iazeypy ise israelita watay, azagâ papa, azagâ pâmuko atay warâ nhuduly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mârâ ume uguondo Simeão tâtyem myakâwâm Jerusalémdâ. Judeu domodo ezewenry eynynonro mykâinane. Deus ize ato ara lelâ mykâinane aidyly. Alâ mykâinane typemugudo emakerim Deus ingonodyly nhenuendyly. Eagâlâ mykâinane Deus Ispiritury. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","“Âiguely iraynâ ese âmâ Deus Ingonotyby” Deus Ispiritury kehobyrylâ Simeãoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jesus Deus ety odaji sato emedyly ume Deus Ispiritury aguely myakâwâm Simeãoram: — Idâ Deus ety odaji — kely. Aituo myakâwâm idâly. Maria, José warâ iamudo Jesus agâ saindylymo myakâwâm; Deus itaumbyry iweniby agueho ara aidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aituo Simeãoram âzeholymo. Simeão iamudo nhanâdyly. Deus koendonroem awyly wâgâ aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","— Iweâma tuomare urâ, Pymâ Deus. “Igonose urâ” myguehobyry migonodâma. Alâ ise. Tâwâlâ ise iweâma yiguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ienugue kehoenma setai, merâ kurâ domodo emakerim âydâpa âetyby. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Idânârâ kurâdo emakerin-em migonodâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Judeu keba modoram xutuen-honze âdara Deus ize awyly, iajinu wâne kydadakobâdo nhesagonly myara. Mâkâ wâgâ, judeu domodo koendâ aguehonze, kurâ domodo mâinduakeyby — kely myakâwâm Simeão Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeão iamudo wâgâ aguely tindatuo myakâwâm José, Maria warâ âsewânilymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeão agueondyly myakâwâm eyanmo: — Deus agâmolâ ise, nhenimoem — kely. Aituo myakâwâm Jesus isenra aguely: — Deus induakeyby wâne merâ iamudo, kypemugudo judeu domodo ewy âmery neinwâmpyramo olâ ise. Awylygue ise Deus agâpa âieholymo. Igueduomo âji tâdâsenagazedoram ise idâlymo. Tâlâ pylâ olâ ise âmery einwânni modo. Deus eydâpa nâiehobamo ise-ro warâ. Igueduomo eydâ atoram ise idâlymo. Âmerylâ ise kurâ domodoram âdara âsemaguelymo wâgâ aguenri. Toenzepa olâ ise izepanro modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Deus âdara kydawyly xutuen-honze, Jesus eynynâ, eynynâba warâ kydawyly. Âsenagazeze âmâ, âmery aietaynlygue. Espadague ihoguyby ara ise âmâ — kely Simeão, Jesus isenra. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ilâpyryem myakâwâm aripi Ana saindyly, Deus itaumbyry agueim, Maria, José warâ iamudo agâ, Deus ety oday atomoram. Fanuel exiry myakâwâm mâkâ, judeu domodo ewy myakâwâm Aser iweompyry. Âwynsaundoem tatay myakâwâm ohogüinly. Sete anu ohogüimbyem awyly ume olâ myakâwâm iso iguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Iweâpa myakâwâm pypâbyryem awyly. Oitenta e quatro anupe myakâwâm ilâem. Alâ mykâinane idâly Deus ety odaji. Kopae, peto oday alelâ mykâinane Deus wâgâ aguely. Nâwinduapyra tâise mykâinane, Deus agâ adâkehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeão, Maria, José warâ agâ xunâgu ume myakâwâm mâkâ saindyly, aguely: — Koendonrolâ enra Deus! — kely. Deus Jerusalém donro modo nhemakely enuenni lâpylâ myakâwâm Ana. Kurâ domodoram aguely lâpylâ Maria imery wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Moisés ezewenry ara aitybyem myakâwâm José, Maria warâ iamudo agâ odopâdylymo Galiléia yan-yam, tâtymoram Nazaré anaxi. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iamudo ago idyly myakâwâm. Eon-howanzedyly, enomezezedyly warâ. Koendâ lelâ myakâwâm Deus nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Aunlolâ myakâwâm José, Maria warâ Jerusalémram idâlymo Páscoa etyguedoram, Egitodâba tydamudo âsemaguehobyry etyguedoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus doze anupe awyly ume Páscoa etyguedoram idâlymo myakâwâm Jerusalémram, ezewenrymolâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Âtybygueduo myakâwâm José, Maria warâ odopâdylymo tâtyam. Jesus Jerusalémdâlâ âxiânly nepyramo myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Odopâdaynrim modo duaylâ enanajimo. Iguandyly ara lelâ ânwa oze idâlymo. Iguandyly ume myakâwâm nhuinlymo, typemugudo duay, tataen-ho modo agâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nepyramo olâ. Aituo myakâwâm emetobyry aralâ xuize odopâdylymo Jerusalémram. Tuguanse myakâwâm, nhuinlymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Deus ety oday myakâwâm nhedylymo, Moisés inweniby wâgâ aguewâni modo duay ekadybyem. Eagâmo xunâgu, aguelymo, indadyly, nhapâiguely idyly ume. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Toenzepa myakâwâm târâ idataynrim modo âsewânily. — Aekuru wânkâ merâ iamudo enomegu! Tutuze lelâlâ merâ koendâ kehoem kunâry in-hoguly! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Maria, José warâ âsewânilymo lâpylâ, tientuo, tindatuo warâ. Ise aguely myakâwâm eyam: — Xina arâ akâiedâ, Mery. Urâ, unwâm warâ âdykâ mawyly nutuba tawylygue, toenzepa xina âwize nâsenagazedâ — kely Maria. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aituo myakâwâm Jesus aguely eyanmo: — Uipa midysemo. Pabai ety odaylâ wawyly mutudyzemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Arâ Jesus agueduo nutubamo myakâwâm âdakeze aguely awyly. Nutubamo myakâwâm âdy aiese kuru Jesus âewyly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aituo myakâwâm Jesus odopâdyly eagâmo Nazaréram. Aguelymo nakabyra. Ise olâ myakâwâm idânârâ aitaymby modo nenanânehomba. ");
INSERT INTO bkqNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus ago idyly, enomezely alelâ. Toenzepa kurâ domodo, Deus warâ ize atoem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","João, Deus itaumbyry nhegatuly adaguly ume, quinze anos myani Tibério, Romadâ pymâem awyly. Pôncio Pilatos myani Judéia donro modo iwymâry. Galiléia donro modo iwymâry myani Herodes. Iwaigoru Filipe myani Ituréia eynynâ, Traconitesdâ warâ pymâem awyly. Lisânias myani Abilenedâ pymâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás warâ myani kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru. Âji âdy peba atodâ myani Zacarias imery, João. Târâ awyly ume myani Deus aguely eyam, tytaumbyry egatuze kurâ domodoram idâhoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aituo myani João Deus itaumbyry egatuze idâly. Idânârâ paru Jordão eynynâ mykâinane adakobâdyly, Deus itaumbyry egatuze. Warâ myani aguezesedyly: — Âjityendaungâ inakanhe amitomobyry wâgâ. Deus izepa ato aiedyly imowâdaungâ. Deus einwântaungâ, inakanhe amitomobyry nhygakehoem. Parugue batiza âiehowâdaungâ, inakanhe mawylymo imoimbyryem mawylymo mâenehon-homoem — kely mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Saguhoem Deus itaumbyry egatuim Isaías aguehobyry ara awârâ aidyly: “Messias wâgâ agueim târâ âji âdy peba atodâ ise aguely. Adâkely idase âetaymby modoram: ‘Inepa ise Deus Ingonotyby saindyly. Izepa ato aiedyly imowâdaungâ. On-hondybyem lelâ itaungâ, aguely mâindatomoem. Pymâ ton-honreim kâty anaxi âewyly kiuntuduo wâne, kâty inatary tuonse, tuonkeze warâ kurâ, myara on-hondybyem lelâ itaungâ saindyly iray. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Idânârâ koendâpanro modo kua iedyly. Tâtaguneim modo mâentamuhomo ara; tywyguneim modo, mâinwyguehomo ara, ânwa tâkâineim, mâenkâinuguehomo ara, ânwa tâtagueim modo, tywyguneim modo warâ âzekiba lelâ mânhetomo ara warâ, Arâ lâpylâ ise inakai modo mâinmolymo, Deus Ingonotyby iray. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Idânârâ kurâ domodo ese âdara Deus kâmakely awyly’ kely ise” kewândymy Isaías. João Batista myani Kywymâry saindyly egatuim. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","João, Deus itaumbyry nhegatuduo, toenzepa kurâdo idâly eyam: — Batiza tyedyse xina — kelymo. Tyam idâwâni modoram myani João aguely: — Âgâu poji âduguely ume âsemagueze kewâni ara kulâ âmaemo! Warâ wâne amyguelymo: “João batiza kyetuo ise kydâsemaguely. Deus kânagazedaymba ise” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","“Deus eynynonro urâ” myguelymo wâne, Deus eynynonro keba olâ âmaemo. Deus izepa ato amânhetomobyry wâgâ tâjityenze mawylymo enehorim aietaungâ, inakanhe amidylymo imoimbyryem mawylymo mâenehon-homoem warâ. “Deus kânagazenehonwâbyra ise, Abraão iweonma kurâ” tâkezeba itaungâ. Abraão iweryem tadawyly mâkeba mârâ kuru. Âdy mâkeba awârâ! Auguely xirâ âyanmo. Ton-honre Deus, xirâ tuhu modo Abraão iweryem ienehonze. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nady koendâ ewisedânry pygue satâly. Iwindy âzesagueoly. Peto onwanji adameoly alelâ aieholy. Nady koendâ ewisedânry ara kulâ âmaemo. Deus izepa ato mâinmopa âmaemo watay, inepa ise Deus inagazedylymo — kely myani João. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aituo myani kurâdo aguely: — Âdaraka Deus xina aidyse awyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","João in-hoguly: — Deus tâinwânse lelâlâ mawylymo enehonwâdaungâ. Itymo owogonromo azagâpe âmaemo watay, ipaonra tokalâ âunduwâtaungâ. Typynigue mataymo, epajigâdaungâ ipanro agâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aituo myani Romadâ pymâem dinheru impostu ebyry emakewâni modo ewy saindyly. João batiza tyedysemo, Deus xurâem tawyly tienehon-homoem. Aituo João nhapâiguelymo myani: — Konomedâni, âdara kuruka ise xina aidyly, Deus tâinwânse tawyly tienehon-hoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aituo João in-hoguly: — Pymâ aguehobyry ara lelâ dinheru emakewâdaungâ. Âunârymo wâgâ kulâ imâem nhuduhomoem adâkezeba itaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sodadu domodo ewyram lâpylâ myani adapâigueoly: — Xina-ro? Âdaraka ise xina aidyly, inakanhe adâidyly imoimbyryem tawyly, Deus einwânniem tawyly warâ tienehon-hoem? — kelymo. Aituo myani João in-hoguly: — Ânguy idinheruru kâzemakewâdaundâ, tutoguyze kehoem. Ânguy âdanipyra kulâ âdygue kâzewentâdaundâ. Tuomare lelâ itaungâ ipywadomogue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Toenzepa myani kurâdo inwauntunu, koendonro modo lelâ aini awyly tiuntuduomo. Aituo âjigue aguelymo: — Messias kinwânwânkylylâ keanra awâkâ João, Deus Ingonotyby! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aituo myani idânârâ eyanmo João aguely: — Âese eagonro Deus wâgâ aguenri. Ton-honreim ise mâkâ, iemyenro keba. Mâkâ ise yakadâ kuru ton-honreim. Ihuru kâingokehoem, ihuru etary ekâjiguerin-em witoenlâ nudupa lâgâlâ. Urâ parugue batiza âenimo, Deus izepa ato amânhetomobyry wâgâ tâjityenze mawylymo mâenehon-homoem, inakanhe amidylymo imoimbyryem mawylymo mâenehon-homoem warâ. Mâkâ âeni ise Deus Ispiritury xudunri, eynynâ mawylymo xutuhoem. Inakanhe amitomobyry xygakeze, peto wâne saxium tyaduânse âpa ezay myara. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigu ekaunâni wâne ewy wâgâpa ewily tyekygueze myara ini mâkâ. Tynynonro modo iduakewâze ejidy tâkehobyryanlâ ise nhekanâdyly, trigu etary kehobyry odajilâ ekanâdyly myara. Tynynâbaom modo olâ typygueba kehoem enagazeze, peto âdaunloenlâ nhâtânry onwanji ise nhamely — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Arâ adâkely umelâ myani, João, Deus itaumbyry nhegatuly kurâdoram. Mârâgue lelâba nhurudylymo. Ton-honre kehoem eyanmo aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pymâ Herodes, Herodias agâ ohogüimbyem. Herodes iwaigoru iwydylâ myani mâkâ. Aituo João aguely Herodesram: — Koendâ inkâba âwaigoru iwydy agâ mohogüinly — kely pymânra. Idânârâ inakanhe aitobyry modo wâgâ lâpylâ warâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes olâ João aguely neinwâmpyra. Nhawânehonly lelâ, kadeia odaxi nhetadânehonly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tâzetadâoly iraynâ, João toenzepa kurâ domodo batiza tyese, Deus eynynonroem tawyly nhenehon-homoem. Alâpylâ Jesus batiza âieholy Joãoram, Deus eynynonroem tawyly tienehon-hoem. Paikayba itybyem, Jesus aguely myani Deus agâ. Aituo kau âzenahunguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Papaem myani Deus Ispiritury xytâguyly nhonwa. Aituo myani kau odaypa Deus itanru indadyly lâpylâ. — Ymery âmâ, toenzepa kâinwyneguyly; toenzepa womazeâni âmâ — kely Deus. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Batiza tyepygueduolâ myani Jesus Deus xunâry egatuly nhaguly. Trinta anu awârâempe myani. Judeu domodo xurâem, José imery mâkâ. Eli imery, José. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matate imery, Eli. Levi imery, Matate. Melqui imery, Levi. Janai imery, Melqui. José imery, Janai. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias imery, José. Amós imery, Matatias. Naum imery, Amós. Esli imery, Naum. Nagai imery, Esli. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maate imery, Nagai. Matatias imery, Maate. Semei imery, Matatias. José imery, Semei. Jodá imery, José. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanã imery, Jodá. Resa imery, Joanã. Zorobabel imery, Resa. Salatiel imery, Zorobabel. Neri imery, Salatiel. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melqui imery, Neri. Adi imery, Melqui. Cosã imery, Adi. Elmadã imery, Cosã. Er imery, Elmadã. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josué imery, Er. Eliézer imery, Josué. Jorim imery, Eliézer. Matate imery, Jorim. Levi imery, Matate. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeão imery, Levi. Judá imery, Simeão. José imery, Judá. Jonã imery, José. Eliaquim imery, Jonã. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleá imery, Eliaquim. Mená imery, Meleá. Matatá imery, Mená. Natã imery, Matatá. Davi imery, Natã. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jessé imery, Davi. Obede imery, Jessé. Boaz imery, Obede. Salá imery, Boaz. Nasom imery, Salá. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadabe imery, Nasom. Admim imery, Aminadabe. Arni imery, Admim. Esrom imery, Arni. Peres imery, Esrom. Judá imery, Peres. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacó imery, Judá. Isaque imery, Jacó. Abraão imery, Isaque. Tera imery, Abraão. Naor imery, Tera. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serugue imery, Naor. Reú imery, Serugue. Pelegue imery, Reú. Éber imery, Pelegue. Salá imery, Éber. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainã imery, Salá. Arpaxade imery, Cainã. Sem imery, Arpaxade. Noé imery, Sem. Lameque imery, Noé. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalém imery, Lameque. Enoque imery, Matusalém. Jarede imery, Enoque. Maalalel imery myakâwândy Jarede. Cainã imery, Maalalel. ");
INSERT INTO bkqNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos imery, Cainã. Sete imery, Enos. Adão imery, Sete. Deus nhygatyby myakâwândy Adão. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Deus xurâem tawyly tienehon-hoem Joãoram batiza âiehoybyem myani Jesus paru Jordãodâpa âxiguely. Deus Ispiritury agâ myani. Aituo Deus Ispirituryam adaholy âdy peba atoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Quarenta iguandyly, quarenta emedyly warâ myani Jesus târâ awyly. Târâ tawyly ara, nâwinduapyra. Alâ myani ewindupadyly. Târâ atay Deus iduery Satanás âepanâguely. Toenzepa wâne Jesus enokuze kely, Deus aguehobyry nhakadoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aituo Satanás eyam aguely: — “Deus imery urâ” mygueansema. Âkealâ kuru amyguely-ro watay, awârâ tuhu pãoem iekâ pylâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aituo Jesus aguely: — Amyguehobyry agânhetaymba ise urâ. “Pão kiendawynlygue lelâ inkâba kyiguepa kydawyly” kely iwenibybe Deus itaumbyry awo wâgâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ilâpyryem iwy onwa adaholy Satanásram. Idânârâ kehoem onro anano modo nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aituo myani aguely: — Idânârâ awârâ mâentaynly modo iwymâryem âese urâ. Tâinkâ lelâba ise pymâem mawyly. Koendonro modo idânârâ âmâem xuduwâse urâ. Idânârâ awârâ mâentaynly modo sodoma urâ. Ânguylâ pymâem kânhedyse urâ-ro watay, adyese urâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Âmâenlâ ise idânârâ awârâ modo, ienado âzeguhoam midyly, yrentoen-ro watay — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus aguely: — Inado âzeguhoam witaymba ise urâ! Warâ Deus itaumbyry aguely: “Kywymâry Deus enado lelâ âzeguhoam itaungâ. Aguehobyry ara lelâ aitaungâ” kely iwenibyem — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ilâpygueduo myani Satanás, Jesus nhadyly Jerusalémram. Deus ety nhangakuedaji sanipyryem aguely: — “Deus imery urâ” mygueansema. Âkealâ kuru amyguely-ro watay, tarâpa onro onwa adamegâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mâdyâwâpyra ise âmâ. Warâ mawânrâ iwenibyem Deus itaumbyry awo wâgâ: “Deus nhese lelâ. Anju domodo igonose awâniem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Âihugueduo, awâse lelâ tâmarygue, âda mipyra mitoem, âhuru tuhu onwa nâdyâpa itoem warâ” kely iwenibybe mawânrâ — kely myani Satanás. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aituo myani Jesus eyam aguely: — Onro onwa kadamewâbyra ise urâ. Warâ lâpylâ iwenibyem awyly Deus itaumbyry awo wâgâ: “Deus imakelymo mâentomoem kulâ, kâmayno akâiedaundâ. Amidylymo-ro watay, mâinwâmpyra mawylymo kulâ ise mâenehonlymo” warâ lâpylâ iwenibyem awyly — kely Jesus Satanásram. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Warâ myani Satanás aguely, Jesus Deus aguehobyry nhakadoem wâne. Satanás aguehobyry ara anipyra olâ myani Jesus. Aituo myani Satanás, Jesus nhodokely. Âdara kuru Jesus Deus aguehobyry nhakadoem adiendyly xutuze wao. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus odopâdyly myani Galiléia yan-yam. Eagâlâ myani Deus Ispiritury. Idânârâ mârâ âji anakâ myani Jesus egary indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Deus wâgâ mykâinane âzenomedâolymo, âtâ judeu domodo âtâdyguyho odakâ. Koendâ lelâ myani Jesus wâgâ aguelymo: — Idataungâ. Ânguy awâkâ ara koendâ konomedâni lâpeba! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Târâpa Jesus âxiguely. Tânamadobyry Nazaréram idâly. Tâzekobyzegueho oday myani tâzewenry ara âtâ tâdâtâdyguyho odaji idâly. Târâ tawyly ume, saudyly myani Deus itaumbyry kaynâ kehoem tintain-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aituo pape ituwymby imâsedo âduduoly, Isaías inweniby. Iweâpa Deus itaumbyry egatuimbyry myakâwândy mâkâ. Warâ kelydâ lelâ myani Jesus pape ituwymby nhawynkely: ");
INSERT INTO bkqNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kywymâry Deus Tyispiritury ingonodyly yam. Mâkâlâ keankâ ugononi, unâ iwâkuru âdy pebanro modoram kâengatuhoem, etadâdaymby modo, tânagazezeim modo warâ kâenmakehoem, epyem itaymby modo nhetondoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Iweâma ise Deus tynynonro modo nhemakely’ keze ugononi keankâ” warâ Deus itaumbyry awo wâgâ iwenibyem awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tintaimbygueduo, Jesus pape imâsedo intuwyondyly. Târâ âtâ tâdâtâdyguyho oday tâwaneinram nhuduondyly, ekadyly. Idânârâ tonlo modo toenzepa myani Jesus nhesedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aituo myani Jesus aguely: — Iwelo keba xirâ mâindakylymo; iwerâ olâ ise xirâ aidyly adaguly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Idânârâ tonlo modo aguely myani: — Idataungâ! Koendonro kehoem awâkâ uguondo! Âdydo imeom koendâ kehoem aguely, âdykâ kindatânry kehoem. José imery kulâ wâne, tonomegueim olâ — kelymo âjigue. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aituo Jesus aguely: — Cafarnaumdâ awitobyry tutuze âmaemo. Awylygue ise târâ awitobyry ara, tarâ ienamadobyrydâ awidyse mawylymo. Warâ ise yam amyguelymo: “Tâwâlâ âsewiângâ, kua kyeni” myguelymo ise. Âdylâ adyesenry, agânhedyse mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Unâ egatuim ipemugudoram kuru tâinwântuneba; âkelo kulâ einwânni. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","— Saguhoem Deus tynynâ aguewâni modo eon-honru tuduze myakâwândy adyesenry modo anhetomoem, Israelita keba modo nhemawyadâdomoem. Elias ume toenzepa myakâwândy tarâ Israeldâ pypâbyry modo. Typynigueba tawylygue âsenagazeni modo, três anos e meio kopâ nihugueba awylygue, âdy âpa ezay ago nipyra awylygue, toenzepa myakâwândy pypâ israelita modo typyniguenry. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Deus olâmy Elias igonomâ Sarepta donro pypâ emawyadâze. Israelita keba myakâwândy mâkâ, Sidom eynynonro. Deus eon-honrugue myakâwândy Elias mâkâ pekodo ipyniry aguipaombyry agui nhenehonly, kopâ ihugueondyly nhotoem. Pypâ israelita xurâem myara aniempyra myakâwândy Elias. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Toenzepa lâpylâ myakâwândy tâdâjimituguelygue tâwânuneim modo tarâ Israeldâ, Eliseu ume. Deus olâ myakâwândy Eliseu eon-honru nudupa akaemo kua nhetoem. Sodadu domodo iwymâry Naamã keho kua iese lelâ ingonodyly, israelita keba myakâwândy mâkâ, Síria donro — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Awârâ tindatuo, toenzepa iewiâpadylymo, judeu keba modo lelâ Deus nhemawyadâguyly kely tindatuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aituo myani sautaynlymo. Sautybyem Jesus nhawâdylymo. Xidadâ odaypa nhadylymo. Iwy iay myani mârâ xidadâ ejiku. Awylygue iwy angataji nhadylymo. Târâpa igonose kelymo ihuguely, iguely itoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Âdaniepyramo olâ. Aituo Jesus kurâ domodo duakâ kehoem sakadyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aituo myani Jesus idâly, Galiléia eynynonro xidadâ Cafarnaumram. Târâ myani kurâdo nhenomedâdyly tâzekobyzegueho oday. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Arâ nhenomedâdyly tindatuo myani toenzepa kehoem kurâdo âsewânilymo. Aguelymo: — Pymâ ara kehoem aguely. Adâkely tutuze, âkeá lelâlâ aguely warâ merâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tâlâ myani târâ âtâ tâdâtâdyguyho oday uguondo kadopâgue taseim. Uguondo oday myani kadopâ adaenkely Jesusram: ");
INSERT INTO bkqNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","— Xina kâdynanâdâ. Tutuze urâ koendâ kehoem ânguy mawyly, Jesus Nazaré donro! Xina eon-honru etyze âetyby mawyly, tutuze urâ. Inakanhe amitaymba âmâ; Deus ingonotyby âmâ warâ — kely uguondo kadopâgue taseim; uguondo keba olâ agueim, kadopâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ton-honre kehoem Jesus aguely mâkâ uguondo odano kadopâram: — MYK alelâ ikâ! Adâkeonzebane ikâ! Igasegâ iweâ lelâlâ merâ uguondo odaypa! — kely Jesus. Idânârâ kurâdo enanaym kehoem mâkâ kadopâ uguondo onro onwa nhamely. Onro onwa sameimbyryem kadopâ egasely uguondo odaypa, âdaniepyra olâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Idânârâ etaynrimbyry modo âsewânilymo. Âjigue aguelymo: — Idataungâ konomedâni ton-honre kehoem aguely. Ton-honreim merâ! Tunâry wâgâlâ awâkâ kadopâ nhâkyly! Agueduo, idâly lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Inepa kehoem Galiléia eynynonro modo Jesus egary indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ilâpyryem myani Jesus egasely âtâ tâdâtâdyguyho odaypa. Simão Pedro etyram idâly. Simão imenhudu toenzepa myani iaturu. Jesus egawândyly tientuo, tonlo modo eyam aguely: — Toenzepa Simão imenhudu iaturu — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aituo myani eydâ atoram idâly. Saintybyem eatado XYDYK idyly. Aituo aguely ton-honre kehoem, mâkâ tyatureba itoem. Aguely umelâ, tyatureba idyly. Inepa kehoem myani saudyly; ipynirymo aiese, âwinduatomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Xixi egawâmpygueduo, idânârâ tonlo tâwânuneim modo Jesusram adaholymo. Mârâgue lelâba tâwânuneim modo myani nhakylymo. Aituo myani Jesus akaemo nhangahu onwa tâmary nhedyly, kua itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kadopâgue taseim modope myani akaemo duay. Jesusram tâjiânkyoduo, tadaenkeze kehoem kurâdo odaypa adâkewâdyly: — Deus Imery âmâ! — tâkeze. Warâ olâ Jesus aguely kadopâ modoram: — Âdatâkezeba itaungâ! — kely. Messias-em tawyly nhutuduomo, ânguyram nhegatudyzebamo myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Emetybyem myani xidadâ odaypa Jesus egasely. Âji âdy peba atoram idâly. Toenzepa kurâdo Jesus xuize awyly. Tiontuo myani aguelymo: — Tâtâzeba ikâ, Jesus. Xina agâlâ ikâ tarâ Cafarnaumdâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesus olâ aguely: — Tarâ lelâ wipyra ise aze. Deus xunârybyry âkelo âtâ anakâ auguedyse lâpylâ urâ. “Inepa ise Deus pymâem awyly xirâ anaym” uguedyse lâpylâ urâ. Agueze Deus ingonotybyma urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tâdâtâdyguyho modo odakâ mykâinane Deus xunârybyry nhegatuly idânârâ âji judeu domodope ato ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Paru Galiléia emelay sagunu wâgâ Jesus eagâmo awyly. Tokonoze kehoem myani kurâ domodo, Deus xunârybyry nhegatuly idase awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aituo azagâ pepi sagunu wâgâ TUXUK TUXUK ietyby nhedyly. Sodo modo myani iodaypa itybyem, âedâ kanra awâto igokeze aidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mârâ tokalâ pepi sodo myani Simão Pedro. Aituo Jesus pepi odaji âxiedybyem sodoram aguely: — Âwepiry wao âdiempa igonokâ — kely. Jesus aguehobyry ara sodo anhedyly. Aituo Jesus pepi oday ekadybyenlâ kurâ domodo sagunu wogonro modo nhenomedâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Enomedâdylymo ewanikeimbyryem Simão Pedroam aguely: — Paru esanigonra pepi sakâ — kely. Simão Pedroram, pepi odano modoram warâ aguely: — Âedâ samewâdaungâ paikaji, kanra manwâtomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aituo Simão Pedro aguely: — Ah, Pymâ, tâmese enra xina kanra sawâse kewâdyly. Ânguy xina nawâtaymba enra. Amyguehobyry ara aise lelâ olâ xina — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aituo âedâ nhameondylymo paikaji. Ilâenma toenzepa kehoem kanra nhawâdylymo-ro, âedâ adauguezeseaji kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aituo Simão Pedro eagonro pepi odano modo tâmaryguelâ tâmawyadâze âetomoem ingâsedyly. Myarâ saintybyem, azakâlâ kehoem kanrague pepi xumywâdyly, xytyzeaji kehoem kanrague tumykugue. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kanra peba atobyrydâ toenzepa sawâtyby tientuomo, myani Simão Pedro Jesus enado âzeguhoam itybyem, aguely: — Tâwâlâ wixi, Pymâ. Âdy mâkeba urâ âmâem, inakanhe aini kulâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mâkâlâ, eataen-ho modo warâ âsewânilymo, toenzepa kehoem kanra tianwâtuomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeu imeombyry, Tiago, João warâ toenzepa kehoem âsewânilymo lâpylâ, Simão Pedro eagonrodo. Aituo Jesus aguely Simão Pedroam: — Tâegane ikâ. Saguhoem kanra sawâniem makynre. Kurâ domodo ynynonroem itoem unâry egaturin-em ise âmaemo iwerâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Agueduo, pepi modo nhuxidylymo sagunu onwa, târâlâ âxiân-hoem. Idânârâ timobygueduo myani Jesus agâ idâlymo, âsenomedâze. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus myani uguondo tâjimituguelygue tâwâneim ety anaym. Toenzepa myani uguondo âjimituguely. Jesus nhedyly. Aituo eyam idâly. Jesus enado âzeguhoam idyly, tâmydy onro onwa nhedyly, Jesus tynrense tawyly tienehon-hoem. Aituo Jesusram aguely: — Pymâ, kua yese ton-honre mawyly, xutuanze. Kua yedyse âmâ watay, kua yekâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus tâmarygue MÂʼ nhedyly. Eyam aguely: — Kua âedyse urâ. Tâwânepa âmâ iweâma. Kua âetai — kely. Ilâenlâ kehoem kua idyly. Iwâgâ pinuri peba idyly, itugoenzely warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Eyam aguely: — Idakâ. Iweâma tâwâlâ idâ. Ânguyran-ne xirâ kua âetobyry kâzegatu — kely. — Kurâdo eynynâ Deus agâ agueinram âzehora, kua itybyem mawyly nhetoem. Kua itybyem mawyly kurâdo nhetoem, Deusram âdylâ âundugâ, kâzewenryem Moisés inweniby agueho ara — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tâinkâ lelâba Jesus egary âjidaholy. Aituo myani kurâ domodo aguely idase idâlymo. Tâwânuneim modo idâly kua tyetoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aunlolâ myani Jesus idâly âji âdy peba ato modoram, Deus agâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesus Deus wâgâ nhenomedâdyly myani. Eydâ iwaguepa ekadybyem fariseu domodo ewy, Moisés inweniby wâgâ enomedâni modo warâ. Jerusalémdâpa âewylymo; idânârâ xidadâ Galiléia eynynâba, Judéia eynynâba lâpylâ warâ âetaynlymo. Kywymâry Deus eon-honrugue Jesus kurâ domodo kua nhetaynly. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aituo myani uguondo modo adakobâdânry nhadylymo kama emyenro xygatyby wâgâ, Jesus kua nhetoem. Âtâ odaji tienkaunâdyzemo wâne, Jesusram tiantomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Toenzepa kurâdo awylygue olâ âdara nâwâmpyra awylymo mâkâ agâ. Aituo pyanta oze tâgawâmpyra tâituomo, âkulymo âtâ nhangataji tâdâkuho wâgâ mâkâ uguondo agâ. Tarâ tyntâguyândo in-hoguylymo. Mârâ adientybymo oze tâwâneim nhytâguyândylymo kurâdo tonlo modo duakâ kehoem Jesus enadoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aidylymo tientuo myani Jesus tyangahu oday aguely: — Awâkâ adakobâdânry kua kânhedyly tâinwânse asaemo — kely. Aituo Jesus aguely adakobâdânryam: — Inakanhe amitobyry modo xygakeagui — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ Jesus aguely tindatuo, tâpaunzezemo myani. — Koendâpa awâkâ Jesus aguely! Deus nhunâguedyly kulâ awâkâ! Deus agâ âzekiba tâidyse awyly kulâ! Âdaunlo uguondo nhygakehonly mâkeba awârâ inakanhe adâjitobyry modo! Deus lelâ awârâ xygakerim — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tutuze olâ Jesus âdy nhangahumo oday xunârymo awyly-ro warâ. Aituo aguely: — Arâ ywâgâ tâpaunzezeba itaungâ! Unâguedaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","— Merâ adakobâdânryam: “Inakanhe amitobyry modo xygakeagui” uguely-ro watay, mâuntuwâbyra ise âmaemo, âkealâ, âkealâba warâ auguely awyly. “Aukâ, adakobâgâ” eyam ugueduo, adakobâdyly-ro watay olâ, xutuze âmaemo ton-honre wawyly! ");
INSERT INTO bkqNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Merâ koendâ adakobâdyly mâentuomo, xutuze âmaemo, kurâ domodo inakanhe aito xygakeze ton-honre wawyly urâ Uguondo Kaynâpa Âetyby — kely Jesus. Aituo myani adakobâdânryam aguely: — Aukâ, iguetudobyry sanâkâ, adakobâgâ. Idâ itynra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aguely umelâ kehoem kua idyly, Saudyly idânârâ enanaynmo. Tâguetudobyry nhanâdyly. Adakobâdyly, egasely, tâtyram idâly. Deusram aguely: — Koendonro, ton-honreim warâ âmâ! — tâkeze, idâly. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Toenzepa kehoem Idânârâ âsewânilymo, âseanedylymo warâ. Deusram aguelymo: — Koendonro, ton-honreim lelâlâ warâ âmâ, Deus! Koendonro modo aieni. Âdykâ koendonro awârâ emyenro kientaymba kurâ, iwerâ olâ kyzetai! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ilâpygueduo myani Jesus târâpa âxiguely. Tadakobâday myani pymâ ton-honreim Roma donro xurâem dinheru impostu epywado emakeim nhedyly. Levi myani mâkâ impostu epywado emakerim ezedy. Ekadybyem myani kurâdo dinherugue impostu nhepywadodâ. Jesus aguely myani eyam: — Yagâ âekâ. Ynynonroem ikâ, yagâ mâsenomedâdoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aituo myani Levi saudyly. Dinheru Roma donro pymâ xurâem emakely inmoly. Jesus agâ idâly; eynynonroem tâitoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ilâpyryem Levi âty anhedyly, Jesus tynynonroem tygâsebygueduo. Pyni tâkubâgueim anhenehonly. Jesus ingâsedyly âtyam, dinheru impostu epywado emakewâni modo lâpylâ, kurâ domodo warâ. Toenzepa myani Levi etydâ kurâdo âwinduani modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tâlâ lâpylâ myani târâ uguondo modo ewy Jesus izepaom: fariseu domodo, Moisés inweniby enomedâni modo warâ, (fariseu domodo lâpylâ akaemo.) Jesus, akaemo modo agâ âwinduadyly tientuomo, toenzepa iewiâpadylymo. Aituo Jesus eynynonro modoram aguelymo: — Kâzewenry ara inkâba amidylymo! Dinheru impostu epywado emakewâni modo agâ, kurâdo inakai modo agâ warâ mâwinduapyra tâise âmaemo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus olâ eyanmo aguely: — Deus wâgâ auguehoem uirimpyrylâ asaemo. Tâwânuneim modo mawânkâ kua tyeni xuirim, tâwânenry modo keba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","— Inakanhe aitaynrim modo igâseze kâewyly, inakanhe adâjidyly imohomoem. “Inakanhe aitânry urâ” kewâni modo igâseze inkâba xirâ kâewyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tonlo modo ewy Jesusram aguely: — João Batista eynynonro modo, fariseu eynynonro modo warâ nâwinduapyra tâisemo inanry, Deus agâ adâkehomoem. Akaemo pylâ âwinduadylymo, adakuilymo alelâ. Koendâpa akaemo arâ aidyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Aituo Jesus eyanmo aguely: — Eagâmo watay, nâwinduapyra nitaymbamo ise. Eagâmopa wituo olâ nâwinduapyra isemo, Deus agâ adâkehomoem. Todohogüin-horam igâsedaymby modo watay, ohogüinrim agâ tatay, nâwinduapyra nitaymbamo, etygumo lelâ. Ohogüinrim tuduaypa ituo lelâ nâwinduapyra idylymo myara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aituo Jesus enomedâzemo aguely: — Ânguy âtâ iwelo natâwâbyra, âtâbâ tianwentâdoem. Nhawentâduo, âtâ iwelo inakanhe nhedyly kulâ tâise. Sawentâdobyry iwelo nadauguepa tâise. Tawentâzeim tâise, adauguein-ro warâ. Âtâ iwelo ewy koendâpa âtâbâ sawentâdoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tâjituby vinhu etaryem xygatyby iwelo keba odaxi vinhu iwelo tâkanâduneba. Tâjituby iwelo keba odaji ekanâduo, etary tadaugueze mawânrâ. Aituo vinhu apâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aypa olâ, vinhu iwelo etaryem tâjituby iwelo xygatyby odajilâ ekanâdyly watay, vinhu nhewantuo, imâem ituo, tâjituby iwelo tâzepâgueze. Etary, vinhu alelâ nâxiumebyra. ");
INSERT INTO bkqNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ânguy vinhu iwelo tienydyze inkâba, vinhu nhewantyby enyrimbyryem. “Vinhu saguhobyrylâ koendonro tânyzeinhe” tâkezemo — kely. {Jesus aguely, saguho konomedâdobyry kinmohoem, iwelo konomedâdo kieinwântoem. Saguhobyry mawânrâ âzekiba nâseinwâmbyra iwelo konomedâdo agâ.} ");
INSERT INTO bkqNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tâzekobyzegueho oday Jesus tynynonro modo agâ trigu ejidy ezakâ sakadylymo. Iduakâ takaday olâ myani Jesus eynynonro modo trigu ewily tasewâzemo. Tâmarygue nhatuguelymo, nhagulymo idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fariseu domodo ewy, akaemo aidylymo tientuo Jesus eynynonro modoram aguelymo: — Kadasewâdaundâ, kadatuguewâdaundâ warâ awârâ trigu ewily iwerâ. Tutuzelâ âmaemo, kâzewenry eynynâ kokobyzegueho oday kydâsewaniba kydawyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aituo Jesus aguely: — Enanâguewâdaungâ typynigueba tâituo, kydamu Davi, eagonro modo warâ aitomobyry, toenzepa tâwindymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deus ety odaji myakâwândy Davi egawândyly. Deusram xuduypy pão modo nhanâdyly, nhedawynly idyly. Tagonrodo nhedawyn-hoem xuduwânmy warâ. Judeu domodo eynynâ olâ tâise akaemo awârâ pão modo nedawympa. Kurâdo eynynâ Deus agâ aguenri lelâ mawânkâ tâise mârâ pão edawynrim, âkelo modo lâpylâ warâpa. Deus olâ myakâwândy nehoguebyramo nipyra mârâ nhedawynduomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Uguondo Kaynâpa Âetyby urâ. Âdy iwâkuru adyeseim, adyesenry warâ tâzekobyzegueho oday xuturim urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tâzekobyzegueho oday Jesus egawântondyly âtâ tâdâtâdyguyho odaji. Âwântybyem, Deus xunârygue tonlo modo nhenomedâdyly. Târâ uguondo emary eahoru eynynonro âzemapiluguedânrybe myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tâlâ lâpylâ myani târâ fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâ. Jesus tiunâguedoem kulâ aidyly enuagaeni modo xunâzelymo: — Tâzekobyzegueho oday Jesus awâkâ uguondo emary kua nhedyly watay, Deus ezewenry arapa aitobyry kyzegatunre. “Deus aiedyseba ato amientai” kykenre — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus olâ myani tutuze akaemo nhangahumo oday xunârymo. Awylygue uguondo âzemapiluguedânryam aguely: — Aukâ. XYDYK ikâ; âekâ xarâ waunroem — kely Jesus. Agueduo uguondo saudyly, XYDYK idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus tonlo modoram aguely: — Âdaraka Moisés inweniby tâzekobyzegueho oday aguienkyly wâgâ aguely? Âdyka adyeseinhe agueho, koendonro aguiendyly, inakai aguiendyly, kely? Ânguylâ tâzekobyzegueho oday kâmaynoem watay, kienmakely, tâwâlâ kingueânehonly? — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aituo Jesus idânârâ kehoem kurâdo tydonro modo nhenuagaendyly. Aguely uguondo âzemapiluguedânryram: — Âzemapiluguegâ — kely. Jesus agueduo, uguondo âzemapiluguely myani, emary kua ienipyryem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Awârâ tientuo myani Moisés inweniby wâgâ enomedâni modo, fariseu domodo warâ iewiâpadaynlymo. Âjigue aguelymo: — Âdakiendylyka ise awâkâ Jesus? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ilâpygueduo Jesus iwy onwa âkuly, tynynonro modo agâ, Deus agâ agueze. Tâmese myani Deus agâ xunâgu. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Emetybyem, tynynonro modo ingâsedyly. Akaemo ewy doze lelâ induakely. Aituo eyanmo aguely: — Âduakelymo, ywâgâ amyguehomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Doze lelâ iduakeyby: Simão (“ ‘Pedro’ ise izedy” Jesus kehobyry.) André (Simão iukono) Tiago João Filipe Bartolomeu ");
INSERT INTO bkqNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus Tomé Tiago (Alfeu imery) Simão (tâty anary izetonro lelâlâ tawylygue, Roma donrogue tywymâgu izepaom) ");
INSERT INTO bkqNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Tiago imery) Judas, Queriote donro (Jesus egamenribyry izepanro modoran-ro.) Warâ Jesus induakely. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ilâpyryem myani Jesus xytâguyly eagâmo iwy wogompyryem. Toenzepa iwy iakoay eynynonro modo. Toenzepa lâpylâ myani iwagueno modo ewy: Jerusalém donro modo, Judéia eynynonro modo, azagâ xidadâ parutabâ emelano Tiro, Sidom warâ donro modo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Âdy Jesus agueho awyly xutuze, kua âiehoze warâ myani akaemo idâly. Kadopâgue taseim modo idâly myani, kua âieholymo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Idânârâ tâwânuneim modo MÂʼ tiendyse, eon-honrugue kua tâitomoem. Idânârâ MÂʼ ienipyry modo kua itaunmâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ilâpygueduo myani Jesus tynynonro modoram MYK idyly. Eyanmo aguely: — Tuomareim kuru âmaemo âdy pebaom modo. Deuslâ olâ âwymârymo, nhenimo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","— Tuomareim kuru âmaemo tâwinzeim modo. Ilâpyryem ise idânârâ ize matomo tâlâ lelâ. — Tuomareim kuru âmaemo tytyruneim modo, tuoguruneim modo warâ. Ilâpyryem olâ ise omarumo, âilumo lelâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","— Tuomareim kuru ise âmaemo. Iwerâ kulelâ mâjiewiâseolymo; ânguy izepa ato modo, tywykeduneim modo, tunâgueduneim modo warâ. Urâ Uguondo Kaynâpa Âetyby xurâem mawylymogue ise mâzenagazeolymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Arâ watay, tytywanzeba itaungâ, tuomare lelâ. Deus olâ eydâ tatodâ imâem âyanmo nhudulype, omazeânimoem nhekanâdybybe. Deus izepanro modoram mâzenagazeolymo. Alâ mykâinane akaemo idamudo lâpylâ Deus xunâry egatuwâni modo nhenagazedyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tynynâbaom modoram aguely lâpylâ: — Kaikâlâ ise âmaemo âdypeom modo. Iwerâ kulelâ omarumo. Ilâpyryenma ise tuomareba âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","— Kaikâ âmaemo iwerâ pyni sodo modo. Âsewinzeze âmaemo. — Kaikâlâ âmaemo iwerâ tuomareim, tyeileim warâ. Âjityenze, ohogüenze warâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","— Kaikâlâ ise âmaemo, Deus izepa ato aieni modoram âzehogueorim modo. Alâ pylâ mykâinane âdamudomoram iozepa kulâ Deus itaumbyry egatuwâni modo âzehogueoly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Aituo myani Jesus agueondyly eyanmo: — Ydataynrim modoram xirâ auguely. Âwynedânrymo agâ koendâ lelâ itaungâ, ataen-homo mâinwyneguylymo agâ matomo ara lelâ. Âewiâsenimo agâ koendâ lelâ itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ânguylâ âmeodoram igameduomo, âmeodoram igameinmobyry xurâem Deusram ekadaungâ koendâ lelâ nhetoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mâjiwapagainhoduomo, tâpeânzeba itaungâ. MYRYK itaungâ, iladune âwapagain-homoem lâpylâ. Âgamizary âzemagazeoduomo, tâwâlâ âwalitoru nadâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Âyanmo âdylâ ekanibyryram âunduwâtaungâ. Ânguylâ âsejiguy nhemagazeduo, “Epywagâne” tâkezeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Koendâ itaungâ âkelomo agâ, agâmo koendâ awyse matomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","— Koendâ lelâ itaungâ idânârâ agâ, ataen-homo agâ kulelâ inkâba. Agâmo koendonro agâ kulelâ koendâ mawylymo watay, âdyem nitaymba awârâ. Ânguy takazeno mâkeba âmaemo. Kurâdo inakai modo kuru tataen-ho agâ koendâmo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Agâmo koendonro agâ kulelâ koendâ mawylymogue, “Deus koendonro kurâem xuduze, koendonro kydawylygue” tâkewâzeba itaungâ. Âdyem itaymba awârâ. Kurâdo inakai modo kuru, tagâ koendonro agâ koendâmo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ipywanimoem awyly mâuntulymoram kulelâ âdylâ mâundulymo-ro watay, “Deus âdylâ koendonro xuduze aguitobyry wâgâ” tâkewâzeba itaungâ. Deus einwântânry modo arâ adâisemo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","— Akaemo ara inkâba itaungâ. Inagazenimo agâ koendâ itaungâ. Koendâ lelâ xurâem aitaungâ, ipywadomo peba awylymo umelâ. Inagazenimo koendâ lelâ mâendylymo watay, ise Deus koendâ nhedylymo, koendonro nhuduly âyanmo warâ. Kurâ koendonro agâ kulelâba Deus koendâ awyly, kurâ inakanhe aini modo agâ lâpylâ, “Kagâ koendonro mâkeba Deus” kewâni modo agâ. Idânârâ agâ koendâ mataymo, Deus eynynonroem mawylymo âdutuoze. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Koendâ itaungâ, Kunwym kaynonro ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesus aguely myani: — Ânguy kâzewentâdaundâ, Deus iwentâbyramo itoem lâpylâ. Ânguy kâdunâguedaundâ, Deus âunâguebyramo itoem lâpylâ. Âkelomo inakanhe aitobyry enanânehonwâdaungâ, Deus inakanhe amitomobyry nhygakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Âkelomoram ipa ato âunduwâtaungâ, tâwânrempa, Deus ize matomo nhuduhoem lâpylâ, saku kiampazezeduo, xumykadyly ara. Arâ lâpylâ ise Deus âyanmo imâem nhuduly, tâwânrempa mataymo. Imâem mâundulymo watay, imâenlâ ise Deus âyanmo nhuduly. Imâemba watay, imâembalâ ise nhuduly warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aituo Jesusram âzenomedâolymo, aguely: — Epy, eagonro epy akobâniem nitaymba. Aidyly-ro watay, azakâlâ tyihuguezemo tâtagueim odaji. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Enomedâni mawânkâ tonomedâzeim sakani kuru. Pymâ mawânkâ tâwaneim sakani kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","— Agonromo tâwentâze âmaemo, âdiempa inakanhe aitobyry wâgâ kulâ, âmaemo olâ imâem inakanhe kuru aini. Koendonro mâkeba awârâ. Agonro âzenupialodobyry lelâ mâenkylymo, inumo odano se iwatary imâsedo pylâ mâempyra âmaemo-ro myara. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Agonromo âzenupialodobyry etyze myguewâdylymo, inumo oday se iwatarybe awyly umelâ. Saguhoem wao inumo odano se iwatary etywâdaungâ, koendâ agonromo âzenupialodobyry mâentyhomoem. Saguhoem kuru wao inakanhe amidylymo imowâdaungâ. Inakanhe amidylymo mâinmopygueduomoma ise tâwâlâ agonrodo mâunrudylymo, inakanhe anipyra itoem — keze Jesus aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesus aguely: — Se takyguenry, koendâ lelâ ewily, ein-hoem tuduze. Se takygueim, inakanhe lâpylâ ewily, ein-hoem nudupa. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ewily wâgâlâ se âdaunlo awyly xutuly. Tyguyreim, uvague tâwituneba; kazainwam, figugue tâwiseba warâ; tâwilygue lelâ mawânrâ nady modo ewitu. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Âdylâ ekanâdo oday koendonro ekanâdyby watay, koendonrolâ tâtyzeim. Inakai watay, inakai lâpylâ tâtyzeim. Arâ lâpylâ kunâry, kyangahu oday kydâpaunzedo kienkanâdyby. Koendonro watay, koendonrolâ aguykeho. Inakai watay, inakailâ aguykeho warâ. Aguykeho mawânrâ, âdara kyangahu oday kunâgu awyly xutuen-hoim — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesus eyanmo aguely: — “Pymâ, Pymâ” myguelymo kulâ yam, auguehobyry mâinwâmpyra olâ âmaemo. Koendâpa awârâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Âdaunlo ynynonro modo kuru awyly wâgâ ise kâengatuly. Auguely tydasemo; auguehobyry adyesemo warâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tâlâ uguondo koendâ kehoem tâty itânibyry nihugueba itoem; mâkâ emyenro asaemo. Tâsanigue kehoem tâty enu etary nhesaguely, tâhugamune kehoem tiempadâdoem, nâzekâniba itoem. Toenzepa kopâ ihugueduo, paru inwenduo, mârâ âji nhytyândyly warâ. Mârâ âtâ olâ nihugueba, tâhugane kehoem tuhu wâgâ itâdyby awylygue. Arâ lâpylâ yeinwânni modo kâenomedâdobyry imodânry modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tâlâ lâpylâ auguely idani modo, auguehobyry aniempyramo olâ waunlo. Uguondo koendâ tâty itâdânry emyenro akaemo. Sagunu wâgâ kulâ tâty intâdyly. Imâem nesagueba âtâ enu tiempadâdoem. Toenzepa kopâ ihugueduo, paru inwenduo, mârâ âji nhytyândyly. Aituo âtâ ihuguely. Idânârâ kehoem adakalaguely, tâhuganeba itâdyby awylygue — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Akaemo kurâdo agâ agueypyem Jesus idâly xidadâ Cafarnaumram. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tâlâ myani mârâ xidadâdâ sodadu Roma donro iwymâry. Tâlâ lâpylâ myani eagâ tâwaneim mâkâ ize ato kuru. Toenzepa myani mâkâ tâwaneim ewânu iguezeseaji kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aituo myani sodadu iwymâry “Jesus kurâdo kua nhedyly” kely indadyly. Awârâ tindatuo myani judeu domodo iwymâry ewy ingâsedyly. Eyanmo aguely: — Jesusram ekadaunda wao, yagâ tâwaneim kua iese âetoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aituo idâlymo Jesus agâ agueze. Eagâ toxioduomo, aguelymo mâkâ sodadu iwymâry aguehobyry. Myarâ idâhoem nhekazezedylymo. Aguelymo: — Uguondo koendonro mâkâ. Toenzepa xina izetonro mâkâ. Nhekadyby aieta wao. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Roma donro wâne mâkâ, kurâ judeu domodo izetonro olâ mâkâ. Mâkâlâ keankâ âtâ itânehonrim, xina Deus wâgâ agueze âtâdyguyho — kelymo Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aituo Jesus eagâmo idâly. Âtânra saindylymo ume, sodadu iwymâry tataen-ho modo ewy Jesusram agueze ingonodyly. — “Pymâ, âdy mâkeba urâ, ietyram mâwântoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Toenzepa ton-honreim âmâ, agâ tunâgueim mâkeba tâise urâ. Ton-honreim âmâ. Iwague endaylâ yagâ tâwaneim kua itoem amyguely watay, kua ise lelâ merâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ywymâry modo aguely tâinwânse urâ. Tyzodadugue lâpylâ urâ yeinwânni modogue warâ. Kâingonotuo, tâtâze lelâ. Eagonro kâingâseduo, tâese lelâ warâ. Yagâ tâwaneinram ‘Xirâ aiekâ’ ugueduo, inepa kehoem adyese lelâ warâ” keanry xina iwymâry — kelymo ingonotaymby modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Awârâ tindatuo myani Jesus toenzepa kehoem âsewânily, mâkâ sodadu domodo iwymâry toenzepa tâinwândyly tiuntuduo. MYK idyly. Aguely mâkâ kurâdo tyampygueni modoram: — Eagâ tâwaneim kua kânhedyly tâinwânse mynra mâkâ uguondo. Ânguy yeinwânni kâentaymba urâ mâkâ Roma donro yeinwânto ara kehoem. Kypemugudo israelita domodo duay kuru ânguy yeinwânni lâpeba mâkâ ara! — kely Jesus. Iwague endaylâ myani Jesus aguely: — Kua ikâ — kely. Agueduo, uguondo kua idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Sodadu iwymâry eataen-ho modo odopâdyly etyram. Saintybyem mâkâ tâwâneimbyry kua itybyem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mâkâ uguondo kua ienipyryem ine nipyralâ, Jesus idâly xidadâ Naimram. Eynynonro modo, toenzepa kurâ domodo warâ idâlymo eagâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Xidadâ odaxi tâdâwânto iwaguepa ataymo, Jesus âguedy epyâdoram sani modo nhodylymo. Pypâ imery tokaleom myani mâkâ âguedy. Toenzepa myani kurâdo mârâ xidadâ odano modo igueypy nhapygue idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Isebyry tientuo toenzepa myani Jesus intyendyly. Aituo aguely: — Tuogunrepa ikâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Agueypyem myani iwaguepa saindyly. Mâkâ igueypy sawo MÂʼ nhedyly, sani modo epagudoem. Aituo myani epagudylymo. Epaguduomo, Jesus aguely igueypyram: — Kurâem itongâ. Aukâ, salokuzenomo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesus aguely umelâ kehoem mâkâ salokuzenomo kurâem itondyly. Tawo wâgâpa saudyly, âjitainly alelâ. Jesus aguely isenra: — Anra âmery — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Salokuzenomo igueypy, kurâem itondyly tientuo toenzepa kehoem idânârâ âseanedylymo. Deusram aguelymo myani: — Koendonro âmâ, Deus! Xina agâlâ merâ âynynâ agueim, mâkâ xina emakeze mâingonotyby! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Idânârâ Judéia eynynâ, tâinkâ iwaguepaom modo eynynâ warâ indataynlymo Jesus Naim donro salokuzenomo igueypy kurâem nhetondobyry. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","João Batista Jesus aitobyry egary indadyly. Eynynonro modo eyam egatuim. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aitobyry egary tindatuo myani azagâ tynynonro modo ewy ingâsedyly. Eyanmo aguely: — Jesusram idâwâtaungâ. “ ‘Deus ingonotyby âese’ kehobyrylâka âmâ? Eagonro ise xina inwânwânkyly?” kewâtaunda Jesusram — kely João Batista. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aituo Jesusram idâlymo. Saintybyem, aguelymo: — “ ‘Deus ingonotyby âese’ kehobyrylâ âmâ? Eagonro ise xina inwânwânkyly?” keze João Batista ingonotyby xina. Awârâ mawânkâ tiuntudyze ato — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Saintaymo toenzepa myani Jesus kurâdo tâwânuneim modo kua nhedyly. Kurâdo inakanhe ieni kadopâ nhâkywâdyly. Epy modo nhetoem kua nhedyly lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aituo Jesus aguely mâkâ azagâ João ingonotybyram: — Odopâdaungâ. Mâentybymo, mâindatybymo warâ Joãoram egatuwâdaunda. “Jesus tâwâneim modo kua nhedyly xina nedâ. Epybyry modo koendâ tâense. Adakobâdânrybyry modo tadakobâzemo iwerâ. Tâjimituguelygue tâwânuneimbyry modo itugoenzeybyem. Kydatânrybyry modo koendâ tydasemo. Iguewâtyby modo kurâem tyetonze. Kaikâ modoram Deus xunâry iwâkuru Jesus nhegatuly xina nidadâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tuomareim ise yeinwândyly imodânry modo!” nygue Jesus. Myguelymo ise Joãoram — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aituo João eynynonro modo odopâdylymo. Idâpygueduomo Jesus aguely João wâgâ kurâ domodoram: — Agui âmaemo ewy tâtâze keankâ âji âdy peba atoram, João aguely idase. Âdaunloka mâkâ, inanajimo? Etaungâ adapezeinly-ro watay, poji wayam wayam warâ tâzekânize. Myara keankâ João, inanajimo? Âdy pebaom modoram âkelo unâ nhegatuly, âdypeom modoram âkelo unâ nhegatuly warâ keankâ aguely, inanajimo? Ainkâba, tokalelâ mâkâ xunâry. Âdypebaom agâ, âdypeom agâ alelâ mâkâ Deus wâgâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Medâmolâ ety iwogonro iwâkuru keba awyly. Âdypeom xidadâ odano, âtâ imâsedo iwâkurugue tâtyreim warâ mawânkâ âtâ tâjiwogonro tâwâenseim ieni. Âdypeom mâkeba mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","— Âdaunlo kuruka mâkâ, âmaemoem? Deus itaumbyry egatuim? Mâkâlâ mâkâ Deus itaumbyry egaturinlâ. Warâ olâ auguely âyanmo. Deus itaumbyry egatuim âdaunlo kulâ mâkeba mâkâ. Idânârâ Deus itaumbyry egatuwâni modo takaze tynreim mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Warâ iwenibyem awyly Deus itaumbyry awo wâgâ: “Anra ytaumbyry egatuim. Waunroenlâ ise merâ kâingonodyly, kurâ domodo nhonse Messias saintodâ” kewândymy Deus. Kurâ domodo yaintodâ nhoniem kehobyry mâkâ João — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus aguely eyanmo: — Uguondo âdaunlo kulâ mâkeba mâkâ João, uguely olâ âyanmo. Tynreim mâkâ, idânârâ saguhoem Deus itaumbyry egatuwâni modo takaze. Mâkâlâ keankâ “Inepa ise Deus Ingonotyby âewyly” kerim. Âdara Deus kurâ domodo iwymâryem idyly awyly koendâ nutuba olâ mâkâ. Iwerâ Deus Ingonotybygue tywymâgueim watay, mâkâ takaze ise xynru. Awârâ xuturim watay, mâkâ takaze ise xynru, tâwâlâ lelâlâ wâne ise âdaunlo kulâ awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pymâ domodo mâkeba myani João aguely ehogueni, âdaunlo kurâdo kulâ, Roma iwymâryem impostu emakewâni modo kulâ warâ. Awârâ tindatuo, toenzepa kurâdo mâkâ xunâry ize idyly. Deus ize ato araba aitybyem tawyly tutuzemo tawylygue. Deus tâinwânseim awyly tutuzemo. Aituo Joãoram batiza âieholymo, Deus eynynonroem tawyly tienehon-homoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Judeu domodo iwymârydo olâ myani, João aguely tindadysebamo, fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâ. Awylygue myani Deusram nâzemakeoba awylymo, Joãoram batiza nâiehoba awylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus kurâdo târâ âtâdyguybyram aguely: — Âdaunloem mawylymo wâgâ agueze urâ, âmaemo xirâ umeno modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iamimeom tagonrodo taseray âzenanâdogue tâzenanâdyzebaom ara kulâ âmaemo. Tataen-hodo tugoru indyduomo, tâidysebamo. Tataen-hodo itynru ume, tytyrembamo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Âdiempa kulâ João Batista âwinduadyly, vinhu nenypa. Warâ awylygue, “Kadopâbeom awâkâ” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Urâ Uguondo Kaynâpa Âetyby kâwinduadylygue, kadakuilygue warâ, “Idolai awâkâ. Nhuduypymo tâinze, tânyze alelâ. Impostu epywado emakewâni modo, kurâdo inakai modo eataen-ho warâ awâkâ” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aguitobyry wâgâlâ Deus xurâem, Deus xurâempa warâ kydâzeholy — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tâlâ myani uguondo Simão keho. Fariseu myani mâkâ. Jesus ingâsedyly myani tâtyram âwinduase idâhoem. Jesus idâly. Egawântybyem ekadyly tâwinduatoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tâlâ myani târâ xidadâ oday pekodo inakanhe kehoem aityby. Jesus olâ inakanhe aitobyry modo xygakeimbyryem. Inakanhe adâitobyry modo Jesus nhygakehobyry wâgâ myani mâkâ pekodo eagâ tuomare tawyly tienehondyze awyly. “Kopae fariseu Simão etydâ ise Jesus âwinduadyly” kely tydase myani. Aituo Jesus âwinduatoram idâly. Uriza etary tâwâenseim alabastrogue xygatyby myani tagâ nhakyly urizague tase. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Egawândyly. Jesus eydâ atoram iwaguepa kehoem idâly. LÂPU idyly. Eogumadyly. Aituo Jesus ihuru inkuily tânugurugue. Tyangahuduguelâ Jesus ihuru in-huguoguely. Ihuru nhonugudyly. Ihuru onwa uriza nhapâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pekodo aidyly tientuo myani Simão aguely tyangahu oday: — Deus eynynâ agueim mâkeba keanra awâkâ Jesus. Deus Ingonotybylâ-ro watay, tutuze tâise, awâkâ pekodo toenzepa inakai lelâlâ awyly. MÂʼ nâiehowâbyra tâise warâ — kely myani Simão tyangahu odaylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Simão xunâry tutuze olâ myani Jesus. Aituo eyam aguely: — Simão, koendâ idakâ. Âdylâ auguedyse watobe urâ âyam — kely. — Aguekâ lelâ, Ienomedâni — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aituo Jesus aguely: — Tâlâ myani azagâ uguondo, tydinherugueinram dinheru ekanibyry modo. “Ipywaze lelâ xina” kewânmomy. Tokalâ myani imâem kehoem dinheru ekani, quinhentas moedas pratagueto lelâ. Eagonro myani âdiempalâ nhekadyly, cinquenta moedas prataguetolâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akaemo azakâlâ olâ myani, tienkadyby ebyry nudupamo, âdy peba tawylymogue. Aituo dinheru xuduimpyry aguely azakâlâam: “Âdainkâba. Enanânehonze lelâ urâ awârâ” kely azakâlâam. Aituo, mâkâ azakâlâ tâpywabyra ato nhenanânehonly — kely Jesus. Aituo Simão nhapâiguely: — Âdaunloka mâkâ ewy ogondarymo enanânehonze lelâ urâ keduo, mâkâ agueypy iwyneni kuru, imâem tugondagueim, imâemba tugondagueim? Âdara inanaji, Simão? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aituo Simão in-hoguly: — Mâkâ imâem tugondagueim — kely. — Iozelâ mihoguagui — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesus MYK idyly pekodoam. Simãoram agueondyly: — Metai merâ pekodo anhekyly. Amânhetyby takaze kehoem merâ pekodo ayedyly; ywynedâ kuru tawyly nhenehonly, xurâem agânhetyby wâgâ. Kâzewenryem adakobâni aieto ara ayepyra enra âmâ. Ity odaji iegawâmpygueduo, agâ tâwaneinram uhuguoguehonwâbyra enra âmâ. Merâ olâ tânuguruguelâ kehoem uhuru nigokeagui. Tyangahudugue uhuguogueagui warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yaimpygueduo, wonugubyra enra âmâ. Merâma uhuru ionuguzezelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Âdiempalâ azeiti yangahu onwa mânhepyra enra âmâ. Merâma uriza tâwâenseingue kehoem uhuru niârânzeântai. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Warâ âyam auguely, Simão. Toenzepa yagâ tuomaru nhenehonly merâ pekodo, idânârâ inakanhe aitobyry modo kâyngakeduo. Imâem inakanhe aitobyry kâyngakewâdyby modo, imâem lâpylâ aidylymo urâem ywynedâ tawyly tienehon-homoem. Imâemba kulâ inakanhe aitobyry kâyngakewâdyby modo olâ imâemba kulâ urâem aidylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ilâpyryem myani Jesus aguely pekodoram: — Idânârâ nhutuhomoem, saguhoem inakanhe amitobyry modo xygakeimbyryem wawyly, augueondyly. Inakanhe amitobyry modo xygakeagui — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Târâ eagâ âwinduataynrim modo aguelymo: — Idataungâ! Arâ aguepa tâise awâkâ. Deus lelâ inakanhe aguitobyry modo xygakeim, âdaunlo kulâ mâkeba — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus olâ pekodoram aguely: — Yeinwândylygue, enra imakely. Agâlâ ise Deus nheniem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iweâpa itybyem Jesus adakobâze idâly xidadâ modo anakâ, poji anakâ warâ, unâ iwâkuru agueze, âdara Deus kywymâryem awyly wâgâ. Doze eynynonro modo eagâ tâtâzemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Xidadâram, poji anaxi warâ tâtâly iraynâ, Jesus pekodo modo tâwâneim, kadopâgue taseim modo warâ kua nhedyly. Azagâ tokalâ warâ mâkâ ewy Jesus einwânniem imâ: Maria Magdala donro (sete kadopâgue taseimbyry Jesus kua nhetyby), ");
INSERT INTO bkqNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana, (Herodes isejiguy eni Cuza iwydy), Susana, eagonro pekodo modo lâpylâ warâ, Jesus, eynynonro modo tâmawyadâzemo myani, tydinheruruguelâ, tâlâ tatoguelâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Toenzepa kurâdo Jesus aguely idase idâlymo, xidadâ âkelo anano modo warâ kehoem. Idânârâ âtâdyguybyem awylymo ume myani enomedâzemo unâ nhegatuly; ");
INSERT INTO bkqNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","aguely: — Tâlâ myani uguondo trigu tamuinze etâni typi ezay. Nhamuinday, tâlâ myani ânwa oze ihugueim. Mârâ myani sakadaynrim modoram tadakabeoze, konopio modoram tadaguoze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tâlâ pylâ myani toenzepa tuhube atoram ihugueim. Mârâ myani tyazeze, tyiluseze warâ. Ago nipyra olâ. Iladaynly lelâ, iwindy ago ondaxi nâtâba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tâlâ myani tyguyreimpe atoram ihugueim. Tyguyreim modo, trigu modo warâ âzekiba ago tâise myani. Tyguyreim olâ ago ini kuru, trigu takaze kehoem. Aituo kopâ ihugueyby nikuiba. Mârâ duay tawylygue trigu newiseba. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tâlâ myani onro iwâkuru onwa ihugueim. Iazewâdyly, ilusewâdyly, koendâ ago itaynly warâ myani. Toenzepa myani mârâ nady modo onro koendonro wâgâ iazeypy ewitunu. Koendâ kehoem myani ekaunâdyly, toenzepa ewitugue. Ewy wâgâ cem lelâ myani ewily nhuduly — kely Jesus. Eyanmo Jesus aguely: — Xirâ unâ koendâ mâuntudyze âmaemo-ro watay, koendâne angahumo odaji ietaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Akaemo doze lelâ Jesus eynynonro modo nutubamo âdakeze aguely awyly. Aituo nhapâiguelymo: — Âdakezeka awârâ unâ aguely? — kelymo Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aituo Jesus aguely: — Saguhoem mykâinane Deus nutuen-homba âdara idânârâ iwymâryem tâidyly. Urâlâ olâ xutuen-hoim âyanmo. Koendâ ise âyanmo kâuntuen-honly. Deus koendâ tiuntudyzebaom modoram olâ unâ tâgatuzeingue kulelâ kâenomedâdyly. Agânhedyly tâensemolâ wâne, nepyramo-ro waunlo ara kulelâ. Auguely tydasemolâ wâne, âdakeze auguely nutubamo olâ ise, nidapyra waunlo ara lelâmo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","— Unâ nady ewy târâ târâ warâ ihugueyby, âdakeze kâenomedâdo aguely awyly ise kâengatuly. Mârâ nady ewy ara mawânrâ Deus itaumbyry aidyly. Târâ târâ warâ onro onwa nady ewy samuin-hobyry ara lâpylâ mawânkâ Deus itaumbyry idataynrim modo âzekiba lelâba nheinwândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mârâ nady ewy ânwa oze tamuinze etâdyby tadaguoze, tadakabeoze warâ. Aituo âdy niazepa myani târâ samuin-hobyrydâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tydasemo wâne. Inepa olâ Satanás idânârâ indatybymo nhangahumo odaypa nhetyly. Aituo Deus neinwâmpyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","— Mârâ nady ewy onro tuhubeom onwa ihuguewâdyby inepa kehoem iazely. Iwindy modo ago ondaxi nâtâba awylygue olâ, inepa nady iladaynly, iguewâdyly warâ. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo. Tindatyby modo tâinwânsemo tuomare kehoem. Tâzenagazeoduo, âwankuem tâiehoduo, tâdunâgueoduo warâ olâ inepa kehoem Deus neinwâmpyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","— Mârâ nady ewy tyguyreim duaxi ihuguewâdyby, ago tâise wâne, newiseba olâ, tuahuze mârâ tyguyreim awylygue. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo, Deus tâinwânsemo wâne. Âdype tidyly kulâ, tohomaendyly kulâ warâ olâ enananomo. Toenzepa tydinherugadyly kulâ ize atomo warâ. Awylygue Deus nhenanânehonlymo, ize ato aniempyra idylymo warâ. Deus wâgâ ânguy agâ aguepa idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","— Mârâ nady ewy onro iwâkuru onwa ihuguewâdyby olâ koendâ iazely, ago idyly warâ. Toenzepa ewisely. Tâlâ myani ewy wâgâ cem lelâ ewily xuduim. Tâlâ lâpylâ arâ Deus itaumbyry idataynrim modo, tindakylymo, nheinwândylymo lelâlâ. Deus aguehobyry wâgâ lelâ âpaunzedylymo. Adyesemo lelâlâ Deus “Aietaungâ” kehobyry — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aituo Jesus aguely: — Tâdâzesagon-ho kienmanâduo, âdylâ iaxi kioentaymba kurâ. Kama iaxi kioempyra lâpylâ kurâ warâ. Kayanlâ kianlokuândyly ejidyanlâ, idânârâ âwântaynrim modo nhesagon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Idânârâ unâry mâuntuba mitomoemba xirâ auguely. Koendâ kehoem mâuntuhomoem auguely. Idânârâ soentaymby modo âjiepanâgueoze lelâ. Idânârâ tydasenrybyry âjidahoze. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","— Idânârâ auguehobyry koendâ idataungâ. Imâem ywâgâ mâuntudyze âmaemo watay, imâem ise mâuntulymo. Ywâgâ mâuntudyzeba âmaemo watay olâ, imâemba mâuntuybymo enanânehonze âmaemo. Utuba ise âmaemo warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus aguely ume ise, iukonodo warâ saindylymo eydâ atoram. Toenzepa myani kurâdo eyam iwaguepa saintomoemba. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aituo tonlo modo ewy Jesusram aguely: — Âze, âukonodo warâ tarâ kuohomo. Agâ adâkedyzemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus aguely idânârâ tonlo modoram: — Yze lelâlâ mâkâ pekodo. Konodo lelâlâ akaemo uguondo modo warâ. Deus xunâry idataynrim modo, aietaynrim modo warâ olâ yze ara, konodo ara warâ kâenkyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Alâ myani pepi odaxi âxiedybyem Jesus tynynonro modoram aguely: — Paru kuyam inoro — kely. Aituo âzekuâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tâzekuâdaymo myani Jesus xykyly. Kopâ sapezenru ton-honreim agonro adaguly. Toenzepa kehoem paru adahugânily. Pepi xumyly parugue, xytyzeaji kehoem idyly. Kâmaynomoem kehoem myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aituo âseanedylymo xytyzeaji kehoem tawylymogue. Tâseaneduomo, Jesus nhuagueândylymo. Adaenkelymo: — Pymâ, âwaguegâ! Aukâ! Kyiguely ise xirâ! Pepi xytyzeaji xirâ! — kelymo. Aituo saudyly. Ton-honre kehoem aguely: — Arâ kehoem tadapezeinzeba ikâ! — kely sapezenruram. — Tahugâneba ikâ. Ipagugâ — kely paru sahugânuram warâ. Agueduo tapezenremba idyly, paru tahugâneba idyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aituo tynynonro modoram aguely: — Yeinwâmpyra lelâ waunlo ara lâgâlâma âmaemo! — kely. Toenzepa âsewânilymo, âseguâdâdylymo warâ. Aguelymo: — Etaungâ! Sapezenru nadapezeimba itoem adyese. Paru tahugâneba itoem adyese warâ. Âdara kuruka awârâ modo anhedyly? Ânguy kuruka awâkâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesus, tynynonro modo agâ saindyly myani paru Galiléia kuyam, Gerasaram. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Jesus pepi odayba ipygueduo myani uguondo mârâ xidadâ odano eyam idâly. Iweâpa myani mâkâ uguondo, kadopâ modoram inakanhe âieholy. Âtâ oday nitaymba mykâinane. Tâtyemba mykâinane adakobâdyly tâdâzepyâdo odakâ. Alâ myani korenty ferroguetogue in-hugâjilymo, nhemakâjilymo warâ. Tatâwâze lelâ olâ mykâinane kadopâ modo eon-honrugue. Kadopâ modolâ mykâinane sani âdy peba atoram. Aituo Jesus iopaji saintybyem, mâkâ kadopâgue taseim toenzepa kehoem adaenkely. Jesus enado âzeguhoam idyly. Jesus aguely kadopâ modoram: — Igasewâdaungâ merâ uguondo odaypa — kely. Arâ Jesus agueduo myani kadopâ modo mâkâ uguondo ioday aguelymo Jesusram: — Xina kâdynanâdâ, Jesus, Deus Ton-honreim Imery! — kely ago kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Arâ adaenkeduo Jesus aguely eyam: — Ânguyka izedy? — kely. — “Aguiom” iezedy — kely myani. Arâ aguely, agui kadopâ modo tuoday awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kadopâ modo aguely: — Mârâ tâtagueim tuhuadaguenry odaji xina kâjigonodâ, xina âsenagazedoram — kelymo. Tadaenkeze myani aguezesedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tâlâ myani târâ iwaguepa toenzepa pâsega âwinduani modo iwy wâgâ. Aituo kadopâ modo aguelymo Jesusram: — Awâkâ pâsega modo iodaxilâ xina igonokâ — kelymo. Aituo Jesus eyanmo aguely: — Tâwâlâ idâwâtaungâ iodaximo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Arâ Jesus agueduo myani, kadopâ modo uguondo odaypa egasewâdyly. Pâsega modo odaxi egawândylymo. Kadopâbe tâituo myani, pâsega modo enuimbadaynly. Egatudylymo. Iwy wâgâpa adamunedylymo paikaji. Idânârâ kehoem tyense; iguewâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pâsega eni modo, iwy wâgâpa pâsega paikaji adamunedyly emâmomy. Mârâ tientuomo, âwenkelymo. Inepa kehoem idâlymo xidadâram. Poji anakâ takadaymo tonlo modoram nhegatulymo pâsegado aitobyry. Xidadâ odaxi taintuo myani tonlo modoram aidyly tientyby nhegatulymo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Arâ egary tindatuomo, xidadâ odano modo aityby ese idâlymo lâpylâ. Jesusram saindylymo. Myarâ saintybyem myani uguondo kadopâgue taseimbyry nhedylymo. Âzetydâdybyem, ekadybyem warâ Jesus aguely idase saguhoem tientomobyry araba. Koendâ, kua itybyem tientuomo myani Jesus nhytadylymo, kadopâ modo nhâkyze eon-honrugue. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jesus awâkâ uguondo kua nhedyly etaynrimbyry modo tientyby wâgâ nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aituo idânârâ Gerasa eynynonro modo Jesus nhytadylymo. — Âdylâ aiese awâkâ tarâlâ watay — kelymo. Aituo eyam aguelymo: — Âxiguegâ xina ety anaymba. Taynynâ inkâba ikâ — kelymo, Jesus tâguymo pâsega nhaindyseba tawylymogue. Agueduomo Jesus âxiguely; pepi odaji âxiedyly, tâtâhoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aituo kadopâgue taseimbyry aguely eyam: — Idâze urâ agâ — kely. Jesus olâ aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","— Itynra odopâgâ. Âmâem Deus anhetyby egatura — kely. Agueduo, uguondo idâly. Idânârâ târâ tâtyuneim modoram, Jesus kua tyetobyry egatuwânmy. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus, eynynonro modo warâ mârâ parulâ myani nhekuâdonguylymo. Toenzepa myani kurâ domodo târâ mâkâ inwânwânse awyly. Iomarumo saindyly tientuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eagâmo aguely ume myani uguondo Jairo keho, âtâ tâdâtâdyguyho iwymâry, Jesus iopaji saindyly; âzeguhoam idyly enado. Aguely: — Inoro wao ietyam. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iexiry, tokaleom, doze anugueto toenzepa ewânu, iguezeseaji kehoem. Kua ietâ wao — kely. Aituo myani Jesus eagâ idâly. Idâday, tokonoze kehoem kurâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tâlâ lâpylâ myani pekodo tâwâneim kurâ domodo duay. Imery etary myani âunkeim; kuapa idyly agâ toenzepa myani iunu ihuguely, toenzepa lelâlâ. Doze anupe myani mâkâ arâ ewânu. Tâpyneândylygue mykâinane idâzesedyly kua kyeni modoram. Tâwâense nhepywadyly, kua nipyra-ro warâ. Âdara tienwiândyly awyly nutubamo olâ mykâinane. Toenzepa kua kyeni modo epywanibyryem myani kua tâitoem tâkewâduo, idinheruru olâmy adainwâm. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aituo myani saindyly Jesus ikaynâ. Eyam taintuo, ety iwogonro MÂʼ nhedyly, ikaynâlâ. Ety MÂʼ nhedyly umelâ kehoem myani iunu ihuguely epagudyly, kua idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aituo Jesus nhapâiguely: — Ânguyka enra MÂʼ yeni? — kely. — Urâ keba — kely Jesus iopano modo. Aituo Pedro aguely: — Egâ, toenzepa tarâ kurâ domodo awyly; onwa MÂʼ tâiselâ kehoem, Pymâ. Agui asaemo ewy MÂʼ âetai — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus olâ wakely lelâ: — Ânguylâ MÂʼ yetai. Won-honrugue ânguylâ kua xietai, xutuanze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mâkâ pekodo myani totoendo nutuba tâituo. Tyanugue, tapâne kehoem Jesus enadoram saindyly. Âzeguhoam idyly, tâinwânse tawylygue. Idânârâ enanaynmo aguely: — Urâ enra MÂʼ âeni, Jesus, kua yeniem mawyly, kâuntuduo. MÂʼ âetuolâ enra koendâ kehoem kua widyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aituo Jesus eyam aguely: — Kua itybyem âmâ, kua kyetâ wawyly mâinwântobyry wâgâ. Idâ lelâ itynra Tâseguâdâzeba ikâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus aguely umelâ Jairo ety donro saindyly, aguely: — Jairo, ipa ixiry, nigueaki! Itynra âdaiseba kulâ Jesus kadadâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mâkâ aguely tindatuo Jesus Jairoram aguely: — Tadahulizeba ikâ. Yeinwânkâ. Kurâem itonze lelâ ixiry, koendâ ise lelâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aituo myani saindylymo Jairo etyram. Jairoram aguely: — Inoro âmâ, âwydy warâ igueypyram — kely. Ilâpyryem tynynonro modoram aguely myani: — Pedro, João, Tiago alelâ xina agâ negawândâ. Eagonrodoma talâ wao nidâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Idânârâ târâ âtâdyguyby modo eogunrunu, itynrunu warâ, âwynsaundo igueduo. Aituo Jesus aguely: — Tuogunrepa itaungâ. Niguewâpyra awâkâ âwynsaundo, xykyly kulâ — kely. {Arâ aguely, kurâem tientondyly tiuntuduo.} ");
INSERT INTO bkqNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Arâ agueduo myani nheinledylymo. Igueypyem lelâlâ awyly tiuntuduomo, nâepaigueba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus idâly myani igueypy eguetunâdobyryram. Egawântybyem myani Jesus âwynsaundo igueypy emary sawânipyryem aguely: — Aukâ, âwynsaundo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Adâkehonly umelâ kehoem myani âwynsaundo âepaigueondyly, kurâem itondyly, saudyly idyly. Ilâpygueduo myani Jesus aguely âwynsaundo sodo modoram: — Xuataungâne — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nhunwym, ise warâ toenzepa kehoem âsewânilymo. Warâ olâ myani Jesus eyanmo aguely: — Ânguyran-ne tarâ aityby kâzegatuwâdaundâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus doze tynynonro modo ingâsedyly myani. Eyanmo aguely: — On-honrumo kâunduly, idânârâ kadopâ mânhâkyhomoem, tâwânuneim modo kua mânhetomoem warâ. Won-honrugue ise amidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aguewâtaunda unâ iwâkuru, âdara Deus kywymâryem idyly awyly wâgâ. Tâwânuneim modo kua ietaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Mydâdaymo âdy kadataundâ. Amatagorumo ânwa oze mâzesebydâdomoem kadataundâ. Sakola kadataundâ. Pyni, dinheru warâ kadataundâ. Owogonromo lelâ itymo sataungâ, mâtuguguehomo kadataundâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Âtâ anaxi aintuomo, saguhoem âgâsenimobyry etydâlâ itaungâ. Târâlâ âykywâdaungâ, âkelo âtâ anaryam mydâlymo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mârâ xidadâ odano modo idaenkubamo, unâ mâengatulymo tindadysebamo warâ watay, inepa târâpa âxiguewâdaungâ. Igasedaymo âhurumo etary etywâdaungâ, xutoleguguewâdaungâ warâ, Deusram tânagazezeim awylymo xutuhoem, ize wato ara anipyra awylymogue, yeinwâmpyra awylymogue warâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aguepygueduo eynynonro modo idâlymo, myarâ, myarâ warâ, unâ iwâkuru egatuze, âdara Deus kywymâryem idyly awyly wâgâ, tâwânuneim modo kua iese warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes myani Galiléia eynynonro modo iwymâry. Idânârâ kehoem Jesus, eynynonro modo warâ aidyly egary indadyly. Aituo Jesus wâgâ âdatâkeho nutuba idyly. Tâlâ wakenri modo: — João Batista kurâem itondyby awâkâ Jesus — keim. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tâlâ lâpylâ myani wakenri modo: — Mâkâ mâkeba awâkâ. Elias, awâkâ Jesus-em ini — keim. Tâlâ pylâ, — “Mâkâ mâkeba awâkâ. Saguho modo Deus itaumbyry egatuwânibyry ewy kurâem ityby awâkâ Jesus” keim. Awylygue Herodes âdatâkeho nutuba idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aituo myani aguely: — Tutuze ku-aze João Batista igueypyem awyly-ro. Urâlâma keankâ nhangasagânehoim. Ânguyka awâkâ Jesus? Âdaunlo uguondo kulâ mâkeba keanra awâkâ, adyesenry anhetoem ton-honre awyly egary xidadâ mawânkâ — kely. Toenzepa myani Jesus tiendyse awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesus xunâry egatuze odopâdaynlymo. Odopâdaymbyem myani adientaymby modo Jesusram nhegatulymo. Ilâpygueduo myani Jesusram adaholymo Betsaidaram, akaemo kulelâ tagâ itoem wâne. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Agui olâ myani kurâdo Jesus idâypyem awyly xutuwâni modo. Aituo idâlymo xuize. Saintuomo myani Jesus nhedaenkulymo. Deus idânârâ iwymâryem ituo âdara aidyly awyly wâgâ myani aguely. Tâwânuneim modo kua nhedyly lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iguandyly awylygue myani akaemo doze Jesus eynynonro modo Jesusram idâlymo; eyam aguelymo: — Iguandyly enra. Egâ toenzepa kurâdo! Xurâmoem pyni peba, xykyhomo peba warâ tarâ. Âpa ezajilâ, âtâ anary iwaguepaom modoranlâ warâ asaemo igonokâ, âwinduatomoem, xykyhomoem warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus olâ warâ aguely: — Tarâlâ nidâmo. Âmaemolâ ipynirymo âunduwâtaungâ — kely. — Nuduwâpyra xina nhuantomoem! Cinco pão, azagâ kanra âjihuyby alâ kulâ taunlo. Xina idâdyseka âmâ âdyanlâ pyni xuize, asaemo kurâ domodo xuatoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Toenzepa myani târâ kurâdo awyly, uguondo modo kulelâ cinco mil lelâ. Aituo myani Jesus aguely tynynonro modoram: — PU târâ, PU târâ, PU târâ warâ cinquenta, cinquenta warâ âzepajiwâdomoem aguewâtaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesus aguehobyry ara anhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aituo myani Jesus cinco pão, azagâ kanra âjihuyby warâ sanânibyryem kayam MYK idyly. Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai, awylygue xinaem xirâ pão, merâ kanra warâ mâunduly — kely. Ilâpygueduo pão, kanra âjihuyby warâ nhepajiwâdyly. Tynynonro modoram nhuduly, kurâdoram nhepâdomoem. Nhepâdaymolâ kehoem myani Jesus pão epajiwâdyby, kanra âjihuyby warâ agui nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ize tato ara kehoem myani idânârâ kurâdo âwinduadyly; kanra âjihuyby nhâdylymo, pão nhedawynlymo, koendâ kehoem iolataynlymo warâ. Ilâpygueduo myani Jesus eynynonro modo pão, kanra âjihuyby warâ âsegubydâdaymby nhekanâdylymo cestu imâsedo odaji. Doze cestu tumyke myani âsegubydâdyby nhekanâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Alâ myani Jesus idâly mâkâ kulelâ, Deus agâ agueze. Eagâlâ myani eynynonro modo iwaguepalâ. Deus agâ agueypyem tynynonro modoram aguely: — Ânguy tâkezeka inanry kurâdo yam? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Warâ myani eynynonro modo in-hoguly: — Tâlâ inanry, “João Batista kurâem itondyby awâkâ Jesus” keim modo. Tâlâ inanry, “Elias, awâkâ” keim modo. Tâlâ lâpylâ inanry, “Deus eynynâ aguewâtyby modo ewy kurâem itondyby awâkâ” keim modo warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","— Âmaemo-ro? Ânguy tâkeze âmaemo yam? — kely Jesus. Aituo Pedro in-hoguly: — Messiaslâ âmâ, Deus ingonotyby — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","— Mâkâlâ urâ. Iweâ kuru wao olâ Messiaslâ wawyly kâzegatuwâdaundâ — kely Jesus eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aituo myani Jesus eyanmo agueondyly: — Urâ Uguondo Kaynâpa Âetyby, toenzepa âsenagazeze urâ. Kywymâry modo yizemo inkâba ise. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry modo, Moisés inweniby wâgâ enomedâni modo warâ ienagazenehonzemo. Akaemo ise yiguehoem aienehonrim. Yigueduo, azagâ emedyly idyly wâgâ olâ ise kurâem witondyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ilâpygueduo myani Jesus aguely idânârâ tonlo modoram: — Ynynonroem ize mataymo, augueho ara aitaungâ. Kopaelâgâembaba ize wato lelâ aietaungâ; amânhedyse matomo mâkeba aietaungâ. Kurâ tyâzeim kruz nhadyly tyâhoram myara, ynynonro modo on-hondybyem nidâ igueze. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Jesus eynynonro keba urâ” myguelymo, tyâzepa mitomoem kulâ watay, âdiempa kulâ ise xirâ anaym kurâem mawylymo. Âigueduomo, Deus enadoram mydâwâpyra ise âmaemo. Yeinwândylymogue mâdyolymo watay olâ, Deus enadoram idâze âmaemo; aunloenlâ ise eagâ mawylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tâwâlâ wâne âdydo imeom sodoem mawylymo, ize mato modope mawylymo warâ, Deus eydâ atoram mydâhomoem nepywabyra olâ awârâ modo. Deus agonro keba âmaemo watay, âdype matomo âdy mâkeba. Ânguy niguepa tâitoem nepywadaymba. Tâdâsenagazedo amaxi ise mydâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uguondo Kaynâpa Âetyby urâ. Idâze urâ Deus eydâ atoram. Odopâze olâ urâ Deus dompyryem. Kodopâdyly ise Kunwym eon-honru tânehonze. Anju domodo mâkâ ingonotyby ehozelugue tânâmize kehoem ise kâewyly. Kurâ domodo enanaym ywypazeni modo, kâenomedâdo iwypazeni modo warâ, kodopâduo, iwypazeze lâpylâ urâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Asaemo ydataynrimbyry modo ewy Deus lelâ pymâem idyly enipe ise. Xirâ mâuntudyzemo kuru wato — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tokalâ semana awârâem ipygueduo myani Jesus iwy onwa âkuly, Deus agâ agueze. Pedro, Tiago, João warâ kulâ myani tagâ nhakyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Deus agâ aguely ume myani Jesus âkeloem idyly. Emydy âkeloem idyly, ety iwogonro toenzepa kehoem sapeku, ehozelu idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aituo myani azagâ uguondo modo târâ âepanâguely, Moisés, Elias warâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aguelymo myani Jesus agâ Jerusalémdâ âzenagazeoly wâgâ, iguely wâgâ warâ, Deus aguehobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, eagonro modo warâ toenzepa ekozeybyem tawylygue myani xykylymo, azagâ Deus donropyry âepanâgueday. Xuaguelymo. Jesus âkeloem itybyem nhedylymo, tohozele kehoem. Azagâ uguondo eagâ nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jesusdâpa Moisés, Elias warâ âxiguelymo. Âxiguelymo ume myani Pedro aguely: — Koendâ kehoem tarâ kydawyly, Pymâ. Azagâ tokalâ warâ âtâ imeimbyryla xina nitâdâ, âmâem, Moisés-em, Elias-em warâ — kely. Âdara tâkely awyly nutuba kulâ arâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro aguely umelâ myani eunu âepanâguely. Nhamanâdyly. Pedro, Tiago, João warâ toenzepa kehoem âseanedylymo tydâ iamatuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eunu duay Deus aguely indadylymo myani: — Ymery merâ, Messias-em kâingonotyby, “Igonose urâ” uguehobyry. Aguely idataungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Deus aguepygueduo myani mâkâ kulelâ Jesus awyly nhedylymo, Moisés, Elias warâ xuzatybymoem. Jesus eynynonro modo awârâ ânguyram inepa aguepamo, negatubamo warâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kopaelâgâem myani Jesus eagâ idâypy modo warâ iwy wâgâpa xytâguylymo. Tytâguybygueduomo myani toenzepa kurâdo Jesus inwânwâni modo nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aituo myani uguondo kurâdo duay adaenkely: — Ymery tokaleom kua iekâ wao, Pymâ! Kadopâ ymery odano nhâkygâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kadopâ iodaxi âwândyly watay, inakanhe tyese lelâ inanry. Toenzepa tadaenkeze, tadapânize, tytabigonzeze warâ inanry. Ymery tânagazeze kuru awâkâ kadopâ. Iguezeseaji tyese kehoem, âdaunloenlâ nimopa-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Âynynonro modoram sekadai wâne, kua nhetomoem. Kua niepyramo olâ enra — kely salokuzenomo nhunwym. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aituo Jesus aguely: — Âdy einwânni kebalâ myanze âmaemo! Ânguydo kulâ âmaemo! Agâmo lâwâne urâ, yeinwâmpyra olâ âmaemo. Ynadaize yeinwâmpyra lelâ mawylymogue — kely. Aituo aguely mâkâ salokuzenomo nhunwynram: — Enekâ âmery xarâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jesusram salokuzenomo saindyly ume myani onro onwa adameoly kadopâram. Adapânily, ekomadyly warâ. Ton-honre kehoem Jesus kadopâram aguely: — Igasegâ iweâ lelâlâ merâ salokuzenomo odaypa, kadopâ! Todopâzeba ikâ-ro warâ! — kely. Aguely tindatuo kadopâ egasely, idâly. Salokuzenomo kua idyly. Kua tiempygueduo nhunwynram nhuduly. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Idânârâ âsewânilymo, Jesus Deus eon-honrugue anhetyby tientuomo. Jesus salokuzenomo kadopâbeom kua tiempygueduo, tynynonro modoram aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","— Koendâne xirâ âyanmo auguely idataungâ. Kâzenanânehonwâdaundâ. Urâ Uguondo Kaynâpa Âetyby yizepaom modo emaxi âzegameoze urâ. Akaemo ise yâen-honri — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Idamâmo wâne, âdakeze aguely awyly nutubamo olâ myani, Deus nhutuhomoem aniempyra awylygue. “Xina nutuba enra âdakeze amyguely awyly. Xinaram wao aguekâ” keze tyanemo olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesus eynynonro modo ânguy tyduaymo tynrenseim kuru awyly wâgâ âtunâguedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Âjigue aguehomo xutuimbyryem olâ myani Jesus. Aituo iamudo tonlo ingâsedyly. Iamudo âetuo, tatadoram nhedyly, ");
INSERT INTO bkqNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","aguely: — Deus xurâem, âduaymo tynrenseim kuru, mâkâ âwâlâ kulâ âtyrendânry. Inanajimo, merâ iamudo âdy keba-ro waunlo ara wâne. Auguely olâ xirâ âyanmo. Pymâem xynru waunlo keba merâ iamudo. Mâkâ ynynonro xurâem koendâ amânhedylymo, tynrenseim keba awyly umelâ warâ watay, urâenlâ amânhedylymo. Âdylâ urâem amânhetuomo, ugononibyry xurâenlâ ise amânhedylymo lâpylâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Aituo myani João aguely: — Xina Enomedâni, âunâry egatuze tâtâly ume, uguondo on-honrugue kadopâ nhâkyrim xina nedâ. “Jesus eon-honrugue kadopâ modo kâjiânky” xina nygue eyam. Xina ewy keba awylygue keankâ arâ xina aguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aituo Jesus aguely. — “Adâiseba ikâ” tâkezeba itaungâ. Kuduery keba watay, kataen-holâ mâkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iwaguepa myani Jesus tunwym enadoram odopâdo. Âda tâieholy awyly tutuzelâ myani aralâ olâ Jerusalémram idâly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tâtâdaymolâ myani uguondo modo ewy ingonodyly. — Idâwâtaungâ waunroem, kykyho xuize — kely. Idâlymo. Saindylymo âtâ anary Samaria eynynonroram. Saintybyem myani tykyho nhuinlymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tonlo modo olâ myani Jesus ingonotyby modoram warâ aguelymo: — Judeu âmaemo. Tarâ xinadâ âykydyzebamo enra xina, Jerusalémram mydâlymo awylygue — kelymo. {Arâ aguelymo, Samaria donro modo Judeu domodo izepa tawylymogue. Samariadâma myani Deus ehoguedo, enanajimo.} ");
INSERT INTO bkqNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ingonotaymby modo odopâdyly Jesus agâ oxioze. Eagâ toxioduomo myani aguelymo: — Samaria donro modo kykydyzeba tâtymo anaym — kelymo. Tiago, João warâ awârâ tindatuo myani aguelymo: — Saguhoem Deus ingonokyly myakâwândy peto kau odano, tyizepanro modo tyain-hoem. Âdara amyguely, Konomedâni? Deusram peto ingonotoem xina nhekadyzeka âmâ, mârâ âtâ anano modo iguehomoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aituo myani Jesus MYRYK idyly. Âzeuholymo. Arâ kehoem aguelymo nehoguebyra. Eyanmo aguely: — Âizepanromoem inakanhe adâiseba itaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aituo myani eagonro âtâ anaxi xykyze idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesus, eynynonro modo warâ ânwa oze idâlymo ume myani uguondo eyam aguely: — Âynynonroem widyse urâ. Âdyam mydâhobyryram idâze lelâ urâ, agâ kâsenomedâdoem — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aituo Jesus aguely: — Ton-honre ise enra. Idânârâ ânguydo imeom tâjikune lelâ, xykyhomobe warâ; poroho, tawâguneim modo warâ tâjikune lelâ. Urâ, Uguondo Kaynâpa Âetyby olâ, iekobyzeguehoenlâ tâtyemba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aituo myani Jesus aguely eagonro uguondoram: — Âekâ yagâ, âdyam udâhobyrydâ, ywâgâ mâsenomedâdoem — kely. Mâkâ olâ warâ aguely: — Pymâ, saguhoem pabai ugueho wao ise kâenkyly, niguepa awyly ara. Igueduo, epyâbygueduo ise âynynonroem widyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Warâ olâ myani Jesus eyam aguely: — Yeinwântânry modo igueypy ara kulâ mawânkâ xirâ onro anano wâgâ kulâ âtynanâdylymo. Xirâ onro anano modo wâgâ âtynanâni modolâ igueypy nepyâdâ. Deus kywymâry awyly wâgâ aguera — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Eagonro uguondo aguely: — Âynynonroem widyse urâ. Âdyam mydâhobyryram idâze lelâ urâ. Saguhoem kodopâdyly wao olâ ise ypemugudoram âsedaenguze. Ilâpyryem ise udâly agâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","— Ynynonroem lelâlâ ize matay, ize mato modo enanânehongâ, augueho ara amitoem. Mâinmoyby mâynanâdombyra âmâ-ro watay, Deus emary koendonro ise âmâ, agonro modo duay Deus eydâ atodâ. Ânwa aieni âgânâynra âsemyombâzezedyly-ro watay, tâkâine kulâ anhedyly, inakanhe kulâ warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ilâpygueduo myani Kywymâry setenta e dois lelâ uguondo modo induakewâdyly. Azagâ myarâ, azagâ myarâ, azagâ myarâ warâ ingonodylymo. Eyanmo aguely: — Yraynâ idâwâtaungâ âji udâho modo ara. Xidadâ modoram idâwâtaungâ, poji anakâ kurâdope atoram warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kurâdo xuruse ingonodylymo myani. Âji modoram idâlymo iraynâ myani aguely: — Anji ekaunâdo odano ara ise yeinwântaynrim modo. Anji odo ara awâkâ Deus. Anji ekaunâni ara awâkâ Deus xunâry egatuim modo. Aguipamo kulâ olâ. Deusram ekadaungâ, tâinkâ lelâba tâwanuneim modo unâ egatuze ingonotoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Deus xunâry egatuze ogonodyly, kaneru, auwa modo duaxi igonodyly ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dinheru kadataundâ. Owosarymo kadataundâ warâ. Owogonromo kulelâ âhurumo etary sataungâ, eagonro kadataundâ. Ânwa oze monhontybymo agâ iweâpa tâtunâguezeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","— Âtâ odaji âwântybyem “Deus agâmolâ ise” kewâtaungâ tonlo modoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Deus xurâem tâidysedonrobe târâ-ro watay, eagâmolâ ise Deus, amyguehomobyry ara. Deus xunâry tindadyseba tonlo modo watay olâ, agâmo kulelâ ise Deus, eagâmopa. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mârâ âtâ saguhoem kuru mâzekaunâohomobyry odaylâ itaungâ. Nhegameybymo einwâtaungâ, enywâdaungâ alelâ. Âdylâ nhuduypymo einze tywypazeba itaungâ, Deus xunâry mâengatulymoguelâ, mawânrâ âpynirymo mâempywadylymo. Âtâ modo odaji tâtuguguezezeba itaungâ, âji iwâkuru koendonro waunlo xuize. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","— Âdaunlo âjiram aindylymo, tonlo modo koendâ idaenkulymo warâ watay, târâlâ itaungâ, nhuduypymo einwâtaungâ lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tonlo tâwânuneim modo kua ietaungâ. “Iweâpa nitaymba ise Deus ton-honru nhenehonly âduaymo” kewâtaungâ tonlo modoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Âdaunlolâ âjiram mydâlymo, tonlo modo amyguelymo tindadyseba-ro watay, warâ aguewâtaungâ igasedaymo: ");
INSERT INTO bkqNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xirâ âji anano onro sawionu tuhuru etary onwa ityby xina nhutoleguguely, Deus aguehobyry mâindadyseba mawylymogue âsenagazeze xutuhoem, Deus xunâry âyanmo xina egatuze âetobyry mâindadyseba matomobyry wâgâ. Mâkâ Deus eon-honru enehorim izepa matomobyry wâgâ” kewâtaungâ târâpa mâxiguelymo ume. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sodoma donro modo mykâinane tumunruneim kehoem; awylygue myakâwândy Deus peto in-hugueândyly nhonwamo adain-homoem. Xypyryem, idânârâ turâ keba ara enagazeze. Deus itaumbyry mâengatulymo tindadysebaom modo olâ ise Sodoma donro modo âsenagazedobyry takaze kehoem âsenagazeze. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Aituo myani Jesus eyanmo aguely: — Warâ auguedyse wawyly unâry izepaom modoram. Toenzepa kehoem ise mâsenagazedylymo, âmaemo Corazim donro, Betsaida donro modo warâ. Toenzepa adyesenry modo kehoem ajiedâ âjidadârymodâ, Deus eon-honru kâenehohoem. Yeinwândyseba olâ mataunaguynre. Tumunruneim modo akâwândy Tiro, Sidom warâ donro modo. Deus eon-honru enehonze âjidadârymodâ awitobyry ara ânguylâ aidyly-ro watay, inakanhe adâidylymo tumozemo olâ tâise. Deus tâinwânsemo warâ. Tâzetydâzemo tâise âtâem saku tyxieim sakâjibygue, pelupâ tyangahumo onwa tyesemo tâise warâ, inakanhe adâitomobyry wâgâ tâjityendyly tienehon-homoem, imoimbyryem tawyly tienehon-homoem warâ. Deus eon-honrugue awidyly tâense lelâlâ wâne âmaemo. Inakanhe amidylymo mâinmopa olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","— Tâdâsenagazedo saintuo, âmaemo ynynâbaom modo toenzepa ise mâsenagazedylymo, Tiro, Sidom warâ donro modo âsenagazedo takaze kehoem. Medâmolâ Deus eon-honrugue awidyly. Akaemo olâ akâwândy nepyramo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Koendonro, tynreim warâ âmaemo, Cafarnaum donro modo, inanajimo. Deus eydâ atoram mydâlymo warâ wâne, inanajimo. Arâpa olâ. Satanás eydâ atoram ise mâjigonoholymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Aituo myani aguely tynynonro modoram: — Pabai Deus ugonotobyry aralâ, ogonodylymo. Ywâgâ ise unâ mâengatulymo, Pabai Deus wâgâ kâengatuho ara. Awylygue amyguelymo idani modo, auguelylâ indakylymo waunlo ara lelâ ise. Amyguelymo tindadysebaom modo watay, ydadyseba awylymolâ ise. Auguely izepamo-ro watay, Deus xunârylâ ise izepa atomo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Deus xunâry egatuze idâypyem myani setenta e dois uguondo modo odopâdylymo; Jesusram aguelymo: — Tuomare kehoem xina. Toenzepa kurâ domodo kadopâbeom xina kua niedâ. Kadopâ modo egasewâdyly keankâ, Jesus ezedy xina agueduo, “Jesus eon-honrugue xina aidyly” xina keduo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus aguely myani: — Satanás takaze kehoem won-honru. Târâlâ wakâwândy, Deus, Satanás eon-honru nhetyday. Ielu kau wâgâpa ihuguely ara akâwândy mâkâ Deus ezaypa ihuguely kâendyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Idataungâ. On-honrumo xudu, âgâu, ielawada, awâkâ modo mankabeduomo, mâdâhoba mitomoem. On-honrumo xudu; Satanás eon-honru mankadomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Âdainkâba kadopâ modo mânhâkyhomobyry wâgâ omarumo. Deusram idâwâni modo ezedy iweniho wâgâ izedymo iwenibyem awylygue olâ omarumo kuru nidâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Xirâ umelâ kehoem, Deus Ispiritury Jesus nhomazeândyly. Aituo myani Jesus aguely Deusram: — Kau odano modo, onro wogonro modo warâ sodo âmâ, Pabai! Âdaunlo modoanlâ âunârybyry mutuen-ho, tonomegueim modoram lelâ inkâba, enomedâdaymby modoram lelâ inkâba warâ. Amânhedyse mato aralâ ise aidyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Deus agâ adâkebygueduo myani Jesus agueondyly tonlo modo agâ: — Pabailâ idânârâ won-honru, ienomery warâ xuduim. Mâkâ kulelâ koendâ kuru utunri. Urâ lelâ lâpylâ Pabai Deus koendâ kuru xuturim warâ. Eyam kâuntuen-hoymby lâpylâ olâ koendâ Deus xutuze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aituo myani Jesus âsemygâiguely. Tynynonro modoram aguely: — Tuomareim kuru olâ akaemo won-honru tânugue etaynrim modo, mâentomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Awidyly tâense; auguely tydase warâ âmaemo. Saguho Deus xunâry egatuwânibyry modo, saguho pymâ domodo warâ mâenkylymo tiendyse tâisemo myakâwândy, nhetomoem anipyra olâ myakâwândy. Mâindakylymo tindadyse tâisemo myakâwândy, nidapyramo olâ myakâwândy. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aituo myani Moisés inweniby wâgâ enomedâni saindyly Jesus iopaji. Jesus nhapâiguely myani, tâzewenrymo eynynâ, eynynâba warâ Jesus in-hoguly awyly tiuntuhoem kulâ. — Âdaraka awidyly, Deus eydâ atoram udâhoem, aunloenlâ eagâ witoem, Konomedâni? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus in-hoguly myani: — Moisés inweniby tutuzelâ âmâ. Âdakelyka mârâ wâgâ iweniby? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uguondo in-hoguly myani: — Deus itaumbyry awo wâgâ iweniby iwâkuru kuru: “Kywymâry Deus iwynedaungâ âdydo imeom, kurâ domodo warâ mâinwynedomo takaze kehoem. Idânârâ ize matomo, Deus ize ato ara lelâ nidâ. Idânârâ amânhekylymo, Deus ize ato ara lelâ nidâ. Idânârâ angahumo oday âunâgomo warâ.” “Agonromo agâ âpynedaungâ; koendâ mâzeto ara, arâ lâpylâ agonrodo agâ koendâ âzetaungâ” kewândymy Deus — kely uguondo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","— Âkealâ amyguely. Arâ amidyly-ro watay, Deus eydâ atoram idâze âmâ, typygueba kehoem eagâlâ mitoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Moisés inweniby wâgâ enomedâni uguondo koendonroem myani âdutuly. Awylygue myani Jesus nhapâiguely: — Ânguyka ise koendâ kâenkyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aituo myani Jesus unâ tienomedâdoem nhegatuly. Aguely: — Tâlâ myani uguondo judeu Jericóram idânri, Jerusalém donropyryem. Tâmagaduneim modoram isejiguy âzemagazeoly. En-hem kepalâ kehoem nhetyguelymo. Idinheruru nhemakelymo. Nhapiogulymo. Iguezeseaji kehoem inmolymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mârâ ânwa oze lâpylâ Deus ety oday kurâdo eynynâ Deus agâ agueim idâly myani. Târâ uguondo âdyâypyem ânwa edazekâ nhedyly. Aituo inmyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ilâpyryem Deus ety oday tâwaneim, levita kelygue tâzekeim, idâly mârâ ânwa ozelâ. Uguondo âdyâypy tientuo, sakadyly lelâ, âdaniepyralâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","— Ilâpyryem myani uguondo Samaria donro sakadyly mârâ ânwa ozelâ. Samaria donro modo, judeu domodo warâ âjizetonro keba, eagâmo tâtunâguedylylâ izetonro keba. Alâ olâ, mâkâ Samaria donro judeu âdyâypy tientuo, epagudyly, toenzepa kehoem intyendyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iopaji saindyly. Âdyâhobyry nhokodyly azeitigue, vinhugue warâ onwa nhedyly. Âdyâhobyry tionkobygueduo myani nhaunâdyly. Tâguy onwalâ nhalokuândyly; nhadyly tâdykyho odaji. Târâ myani emedyly ara kehoem nhonse awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Emetybyem myani uguondo Samaria donro azagâ dinheru tâwâenseim nhetyly tysejiguy tiankobâdo odaypa. Tâdykyho sodo nhepywadyly. Aituo myani aguely: “Udâzesedyly ise enra. Koendâ waone merâ nhonkâ. Anra dinheru âdylâ sanâto awâkâ xurâem. Xuduze lelâ wâne keanra kua mânhetoem. Nudupa takaze idyly-ro watay, kodopâday ise kâempywadyly” kewânmy — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Xirâ unâ tiengatubygueduo myani Jesus aguely Moisés inweniby wâgâ enomedâniram: — Âdykonloka mâkâ âdyâypy koendâ eni: Deus ety oday kurâdo eynynâ Deus agâ agueim? Levita? Samaria donro? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","— Mâkâ ityenibyry — kely Moisés inweniby wâgâ enomedâni. — Mâkâ ara aikâ. Kaikânro modo ityengâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ilâpygueduo myani Jesus tynynonro modo agâ idâzesedyly Jerusalémram. Ânwa oze awylymo ume myani Marta, Maria warâ etydâ epagudylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta pyni anhedyly ume myani iwidy Maria, Jesus iopay ekadyly, nhenomedâdo idase, tywary nemawyadâbyra idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Saintaymby modo wâgâ toenzepa myani Marta ewanu. Tywidy tâmawyadâdyze myani. Awylygue Jesus iopaji saindyly, aguely: — Egâ ywidy, Pymâ. Urâ kulelâ yânly, Toenzepa iewanu ume, emynru kulâ tarâ. Igonokâ iemawyadâze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aituo myani Jesus eyam aguely: — Iozepa kulâ awârâ amyguely, Marta. Toenzepa kuru âtâ oday iwanogue mâtynanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iwanu, amânhedyse mato kuru, ydadyse mawyly takaze. Maria olâ kâenomedâdo tydase. Xirâ tutuzeim kuru, amânhekyly takaze. Ânguy merâ kâenomedâdobyry nhangahu odayba netywâbyra ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Alâ myani Jesus Deus agâ aguely. Deus agâ aguepygueduo, eynynonro modo ewy eyam aguely: — Deus agâ xina aguehoem, xina enomedâgâ, Pymâ. João Batista tynynonro modo nhenomedâdobyry ara, xina enomedâgâ lâpylâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aituo Jesus aguely: — Deus agâ amyguedaymo, warâ aguewâtaungâ: “Pabai, idânârâ tynrenseim lelâlâ mawyly, izedy awyly warâ idânârâ nhutudyzemo xina. Ânguy âwankuem âepyra nidâ. Tarâ xina iwymâryem ikâ Xina xirâ onro anano modo ize mato ara lelâ xina aiedyse awyly, târâ kaynâ agonro modo ize mato ara aito ara lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Âmâlâ kopaelâgâembaba xina ipyniry âundugâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inakanhe xina aitobyry xygakegâ, âkelomo inakanhe tynynâ aitobyry xina nhenanânehon-ho ara. Satanás, izepa mato aienehonze keduo, xina agâlâ ikâ, izepa mato xina aniempyra itoem” warâ aguewâtaungâ Deusram — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Aituo myani Jesus aguely tynynonro modoram: — Idataungâ. Ataen-ho itynra kuetâji saindyly tâwinze watay; âdylâ mâunduly peba. Aituo ity apanonra mydâly, âzekainze: “Yataen-ho ietyram naintai. Âdy nheinly, nhenyly warâ peba olâ urâ. Âdylâ wao kâwantoem âundugâ” myguely tâise. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Warâ olâ tâise ity apano janela enahuymby oze aguely: “Kuetâji awârâ! Pealâ enra tâdâzekainly. Ykyly xirâ xatay ynanâdâ. Kadiadupe ietybyem pyanta. Idânârâ xina âtâ odano modo xykyly lâpylâ warâ! Yaupyra ise aze mâenkadyby xuduze kulâ” kely tâise. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aituo, mâenkazezedyly watay, xuduze tause mâkâ. Eataen-hoem mawylygueba olâ nhuduly, mâenkazezedyly imaze. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","— Ekadaungâ. Mâenkaduomo, emakeze lelâ âmaemo. Xuiwâtaungâ. Mâwinduomo, soenkeze lelâ âmaemo. Pyantaylâ âtâ sodo igâsedaungâ, enahungueze lelâ mawânkâ. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Idânârâ ekanibyry modo emakeze. Xuirimpyry modo soenkeze. Âtâ sodo tygâsenibyryram enahungueze. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Âmerymo kanra âjihuyby nhekaduo, âgâu mâunduwâpyra âmaemo eoduem. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aukuma nhoru idâtyby nhekaduo, ielawada mâunduwâpyra âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Inakai wâne âmaemo, iwâkuru modo olâ âmerymoram mâundulymo. Kunwym kaynonroma kuru koendonro-ro. Awylygue ise Tyispiritury ingonodyly ekanibyry modoram! — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tâlâ myani uguondo kadopâram tytaremba âiehoyby. Aituo myani idâly Jesusram, kadopâ nhâkyhoem. — Merâ uguondo odaypa igasegâ; todopâzebane ikâ iodaxi — kely Jesus. Kadopâ egaseduo, uguondo koendâ âjitainly idyly. Toenzepa tonlo modo mâkâ uguondo tytarenrybyry âjitainduo, âsewânilymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tonlo modo ewy Satanás eon-honrugue kua nhedyly-ro waunlo ara, enanajimo, Deus eon-honrugueba. Awylygue âjigue aguelymo: — Belzebu eon-honrugue kulâ awâkâ kadopâ modo nhâkyly — kelymo; kewâdylymo kulâ olâ myani. (Satanás ezedy eagonro awârâ “Belzebu.”) ");
INSERT INTO bkqNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kurâ domodo wâne myani Jesusram aguelymo: — Deus anhekyly lelâ aiekâ, on-honru mâenehon-hoem, Satanás eon-honru warâpa — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Âdara xunâgumo awyly tutuze myani Jesus. Aituo aguely: — Âjigue âzety anano modo âseguebyly-ro watay, mârâ âtâ anary tadainze. Âjiukonoem, âjiwaigoruem warâ âjigue âseguebylymo-ro watay, tunwyndo sodokewâzemo. Tagonro agâ koendâ nâzepyramo, âjidueryem tâisemo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kadopâ modo iwymâryma Satanás. Kadopâ modo âjiguelâ âseguebyly, tygue tygue idylymo warâ watay, ton-honremba tâise Satanás. Tywymâgueba tâisemo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Jesus kadopâ modo ingonodyly olâ, Belzebu mawânkâ aitoem eon-honru xudunri” tâkeze âmaemo. “Belzebu eon-honrugue kulâ kadopâ mânhâkylymo” myguepa olâ âmaemo âynynonromoam. Arâ âynynonromoram amyguepa âmaemo watay, arâ yam adâkezeba lâpylâ itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Deus eon-honruguelâ kadopâ modo kânhânkyly. Won-honru tiunduypyguelâ nhutuen-honly tarâ pymâem tawyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","— Uguondo ton-honreim, typyeim koendâ tâty nhenuagaendyly watay, idânârâ tâlâ ato âdapa lelâ. Ânguy negawântaymba isejiguy emagazeze. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Uguondo mâkâ takaze ton-honreim âewyly watay olâ, mâkâ nemaemba. Aituo mâkâ âtâ odo ipy âsemagueho âzemakeoly, isejiguy idânârâ adaholy, tataen-ho agâ mâkâ uguondo ton-honreimbyry kuru nhepajigâdyly warâ. Satanás takaze ton-honreim wawylygue, xurâ modo kainly. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","— Ynynâba âmaemo-ro watay, ynynonroem inkâba âmaemo. Kurâ domodo Deus nheinwântoem iemawyadâbyra âmaemo watay, neinwâmpyra itomoem amânhenehonlymo lakuru. Ydâ iwague mânhenehonlymo, mâindâtyguylymo tâise koendonro kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aituo myani Jesus aguely: — Tâlâ myani kadopâ kurâ odaypa nhânkyby. Mâkâ kadopâ adakobâdyly myani paru peba ato einkâ, tâjidy xuize. Tâjidy nepyra olâ myani. Aituo mâkâ kadopâ tâwâlâ aguely: “Iegasehobyryanlâ ise kodopâdyly mâkâ saguhoem inakanhe kânhetybyanlâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Adâkeduo ituo odopâdyly. Nodopâbyra awyly ara, koendâ myani mâkâ uguondo, eagonro kadopâram nâdynanâoba, âtâ koendâ kehoem nhontyby, taxiemba wâne myara. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aituo myani mâkâ kadopâ sete lelâ tataen-hodo inakai modo kuru ese idâly, mâkâ uguondo odaxi tâxiedomoem. Aituo mâkâ uguondo ago kehoem kuru inakanhe itondyly, tokalâ kadopâbe tatobyry takaze kehoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus aguepygueduo myani pekodo kurâdo duano ago kehoem aguely: — Tuomareim mâkâ pekodo igaseânibyry, tywanrygue âkuirimbyry warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aituo myani Jesus aguely: — Tuomareim kuru olâ Deus itaumbyry idani, einwânni warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kurâdo âtâdyguybyem atay myani Jesus aguely: — Iumunrumi âmaemo xirâ umeno modo! Yam, “Adyesenry aiekâ, Deus Ingonotyby lelâlâ mawyly xina nhutuhoem” tâkeze âmaemo. “Amânhepyra âmâ watay, xina âinwâmpyra ise” myguelymo warâ. Jonas aitobyry enanâguewâdaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nínive donro modoram Jonas aguewânmy: “Deus inagazenehonzemo, inakanhe amidylymogue” kewândymy. Urâ, Uguondo Kaynâpa Âetyby, Deus Ingonotyby lâpylâ urâ; Jonas unâ nhegatuybylâ âyanmo kâengatuly lâpylâ. “Deus inagazenehonzemo, yeinwâmpyra mawylymogue” uguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","— Enanâguewâdaungâ mâkâ pekodo Sabádâ pymâpyry. Taypa myani mâkâ idâly, âkelo anaymba, Salomão enomery idase. Ienomery olâ Salomão enomery takaze kehoem. Tarâ âduaymo lelâlâ wâne urâ, arâlâ olâ inomedâdomo mâindadyseba, mâuntudyzeba warâ mawylymo. Awylygue ise, xypyry etay, Deus enadoram mâepanâgueduomo, warâ ise mâkâ pekodo pymâ aguely Deusram: “Tâwâlâ akaemo kurâ domodo, Jesus tonomedâdyly tindadyseba atomobyry ara nâsenagazedâmo” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kanra imâsedo odanopyryem myakâwândy Jonas idâly Niniveram, Deus itaumbyry egatuze. Jonas aguely tindatuomo myakâwândy, mârâ xidadâ odano modo Deus nheinwândylymo. Âjityendylymo, inakanhe tawyly inmolymo warâ. Akaemo emyenro keba olâ âmaemo. Urâ, Jonas takaze won-honru. Xirâ mâuntudyzemo kuru wato. Auguely mâindadyseba, mâinwândyseba warâ olâ âmaemo. Awylygue ise xypyry etay Deus enadoram mâepanâguelymo-ro watay, warâ ise Nínive donro modo Deusram aguelymo: “Tâwâlâ akaemo kurâ domodo Jesus aidyly, aguely warâ einwântânrybyry modo nâsenagazedâmo” kezemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Aituo myani Jesus aguely: — Lamparina kienmanâdyly watay, âdylâ iaxi kioentaymba kurâ. Cestu iaxi kiempyra kurâ warâ. Nhesagon-hodâ kienkanâdyly, egawântaynrim modo koendâ kehoem nhetoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kânugue mawânrâ kytâho kiendyly, iajino oze kytâly. Koendâ kiendyly-ro watay, ânwa iozeno oze lelâ kytâly. Koendâ kiempyra kurâ-ro watay, tuzase kurâ, iamu duay tâduzato ara. Epy xurâem toenzepa lelâlâ iamu — kely Jesus. {“Kânu agâlâ mawânrâ kyangahu âsewanily” keze Jesus aguely. Deus ize ato aguiendyse kurâ-ro watay, iozeno lelâ aguienkyly. Arâ aguiendyseba kurâ-ro watay, iozeno keba kulâ aguienkyly. Toenzepa ise kydâsenagazedyly, aguehobyry kieinwâmpyra kurâ-ro watay.} ");
INSERT INTO bkqNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Inanaynmolâ itaungâ. Yeinwânniem mawylymo xutuwâdaungâ. Esagonrim ara xirâ unâry mâindakylymo. Yeinwâmpyra âmaemo-ro watay olâ iamu odano ara kulâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yeinwântâ kuru mataymo, koendâ utuze, koendâ ugononibyry xutuze warâ âmaemo. Ânwa tyajineim oze idânri ara ise âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus aguepygueduo myani fariseu aguely eyam: — Âwinduakârâ ietyram — kely. Jesusmy idâwâm. Âwântybyem mesa onwa ekadyly, nâzemaunguebalâ judeu domodo ezewenry ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Awârâ tientuo myani fariseu tyangahu oday aguely: — Inakanhe kulâ merâ uguondo aidyly. Nâzemaunguewâbyra merâ, kâzewenry ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aituo myani Jesus aguely eyam: — Âmaemo fariseu domodoram xirâ auguely. Moisés inweniby ara amidyse mawylymo umelâ, inakanhe kulâ adâiselâ âmaemo tyewiâpazelâ warâ. Tâdâjitoguyly tâkeze minasemo, ize matomo mâenmakehomoem. Tâlâ wâne kopu, prato warâ sagokeim ikaynâ kulâ nhagokely, ioday iwyku netyba waunlo, myara kulâ âmaemo. Deus ize ato ara adâjidyly mâuntuba âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tuândy kulâ âmaemo! Tâsenoguze âmaemo, angahumo oday inakanhe âunârymo soense myguewâdylymogue. Deuslâ kodo xugunipyry, mâkâlâ lâpylâ kyangahu oday kunâry xudunri warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Deus ize ato kuru âdy pebanro modoram pyni mâundulymo. Awylygue ipanro modoram âunduwâtaungâ, arâ ise tywykeba mawylymo, Moisés inweniby agueho ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","— Toenzepa âsenagazeze âmaemo fariseu domodo! Dez lelâ âsejiguymo ewy, tokalâ inanry mâundulymo Deusram, Moisés inweniby agueho ara. Âpa ezano ewy pyni ekubâzeândo Deusram mâundulymo inanry, hortelã, arruda, awârâ modo mâentâdybymo. Moisés inweniby kuru olâ inanry amânhepyra âmaemo. Âdypebaom, kaikânro modo warâ mâintyembyra olâ minasemo. Deus mâinwântaymba âmaemo. Tâwâlâ âsejiguymo dez ieto ewy tokalâ âunduwâtaungâ Deusram, âdypebaom modo mâintyendylymo mâenanânehombamolâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","— Toenzepa âsenagazeze âmaemo, fariseu domodo! Kurâdoram mâdyren-hondyze mawylymogue. Âtâ tâdâtâdyguyho odaji mydâduomo, waunroem kehoem inanry ikadylymo pymâ modo xurery wâgâ kehoem. Kurâdo âwankuem âedyseba minasemo madakobâdomodâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","— Toenzepa âsenagazeze âmaemo, fariseu domodo! Âkelo modoram koendonroem kehoem wâne mâzehodyze mawylymo. Koendonro keba olâ âmaemo. Âguedy etadâdobyry tywâkureim emyenro âmaemo. Einkâ kakadyly watay, âdy ioday tywângueim awyly kiuntuba olâ kurâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Agueduo myani Moisés inweniby wâgâ enomedâni Jesusram aguely: — Arâ amyguelygue, xina lâpylâ mâunâgueguyly, fariseu domodo kulelâ inkâba amygueho — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aituo myani Jesus aguely: — Toenzepa âsenagazeze lâpylâ âmaemo Moisés inweniby wâgâ enomedâni modo. Amyguehomobyry ara amitaymba lâpylâ âmaemo. Tâjienwyeno tâmânreim tâmaenzeba ato ara awârâ mâenomedâdomo, tâmaenzeba awyly. Tyekeim emawyadâdânry emyenro âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Toenzepa âsenagazeze âmaemo, Moisés inweniby wâgâ enomedâni modo, âdamudomo aralâ tumunreim mawylymogue. Saguhoem myakâwâm Deus itaumbyry egatuwâni modo nhâlymo. Koendonroem kehoem wâne mâzehodyze mawylymo. Awylygue akaemo Deus itaumbyry egatuim saguhobyry eguepybyry etadâdobyry modo mâinwâkudâdylymo iwerâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Arâ amidylymogue âdamudomo aitobyry ara lâpylâ amidylymo tânehonze âmaemo. Deus itaumbyry egatuwâni modo xyâwânmomy. Eguepymobyry etadâdomobyrydâ iwâkudâni âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Deus toenzepa tonomegugue, aguely: “Igonose urâ âyanmo iemary modo ytaumbyry egatuwâni modo, ywâgâ aguewâni modo warâ. Egoiguezemo, xyâzemo warâ âmaemo” kewâm Deus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","— Abel, Adão imerylâ myakâwândy saguhoem kuru Deus itaumbyry wâgâ agueim enday âdyoypy. Alâ sakazezedyly, toenzepa Deus eynynâ aguewâni modo lâpylâ âdyowâdyly myakâwândy. Xypyryem xyâypy Zacarias, Joiada imery. Deus etydâlâ myakâwândy âdyoly, mesa Deusram egameyby ekanâdo, Deus Âepanâgueho iwyantary warâ ontay. Idânârâ âdamudomo aitobyry modo wâgâ ise mâsenagazedylymo. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","— Toenzepa âsenagazeze âmaemo, Moisés inweniby wâgâ enomedâni modo! Deus imakedyze inkâba âmaemo, ânguyram unâ tâdâsemagueho mâengatudyzeba lâgâlâ âmaemo warâ. Pyanta kadiadupe ieni, ilema xave nhoendyly-ro waunlo emyenro âmaemo, igawâmpyra mitomoem, eagonro modo mâenkaunânehomba mitomoem lâpylâ warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Agueypyem myani Jesus egasely âtâ odayba. Fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâ toenzepa kehoem iewiâpadaynlymo, Jesus tywâgâ agueduo. Aituo egaseduo, nhapâiguelymo mârâgue lelâba. ");
INSERT INTO bkqNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tyangahumo oday xunâgumo: — Inakanhe aguehoem aguiendyly-ro watay, kienwentâdobe ise kurâ, kyân-hoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Toenzepa kehoem myani kurâdo âtâdyguyly Jesus eydâ atoram. Tokonozemo kehoem. Aituo myani Jesus aguely tynynonro modoram, kurâdo indatoem: — Fariseu domodo arapa itaungâ. Koendonro aramo wâne, koendonro keba olâ akaemo. Fermentu massa nholiho ara akaemo inakanhe ato imâem idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Idânârâ soentaymby âjiepanâgueowâze lelâ. Idânârâ koendâ tydasenrybyry MON warâ âjidahoze. Âdaunloem mawylymo âzehoze, koendonro, inakai warâ mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Âdylâ amyguelymo kopae iguetubygueduomo watay, emetybyem idânârâ amyguehomobyry âdutuoze. Ity oday amyguehomobyry, idânârâ kurâ domodoram âzegatuoze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus aguely myani: — Ârinmo kâdytadaundâ; igadopyrymo âdaunloenlâ adaindânry tyân-hoem ton-honremba mawânkâ. Tâwâlâ lelâlâ wâne inagazedylymo. Ton-honremba olâ Satanás eydâ atoram ogonosemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Deus anhekyly xytadaungâ. Awâkâ kulelâ mawânkâ âigueduomo, Satanás eydâ atoram ogonosemo ton-honreim. Augueondyly xirâ: Deus lelâ xytadaungâ. Xirâ mâuntudyzemo kuru wato, yataen-hodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","— Idânârâ tâense awâkâ Deus. Imâem tâwâentuneba konopio. Azagâ moeda imeimbyry tâwâensenrygue, cinco konopio tanâse lelâ kurâ. Deus olâ koendâ edyly nimopa. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nhetâmo lâpylâ Deus. Koendâ kehoem tutuze, angahumo wâgâ âdara angahudumo awyly. Awylygue tâseguâdâzeba itaungâ. Deus konopio tâense, âmaemoma kuru nhesemo lâpylâ. Xurâem, âmaemo tywyneim kuru, konopio modo takaze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Wakely myani Jesus: — Tâjiduay, “Jesus eynynonro urâ” myguelymo-ro watay, “Ynynonrolâ asaemo” keze lâpylâ urâ. Pabai, anju domodo warâ enado ise auguely: “Ynynonrolâ akaemo” uguely. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tâjiduay, “Jesus eynynonro keba urâ” myguelymo-ro watay olâ, Pabai Deus, anju domodo warâ enado, “Ynynonro mâkeba asaemo” keze lâpylâ urâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Urâ Uguondo Kaynâpa âetyby izepa wato amânhedylymo, amyguelymo warâ watay, idânârâ awârâ inakai modo xygakeze Deus, mâenkadylymo watay. Deus Ispiritury ewanu wâgâ inakanhe kulâ amyguehomobyry olâ ise Deus nygakeba. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Âizepanromo, pymâ modo enadoram, âtâ tâdâtâdyguyho odaji pymâdo enadoram warâ adylymo ise, iwentâdomoem. Myarâ madahoduomo, tadahulizeba itaungâ. “Kâsemagueho peba ise aze. Âdara uguely kâuntuba urâ pymâdo enanaym nhewentâduomo” tâkezeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Deus Ispiriturylâ ise mârâ ume amyguehomoem inomerymo xudunri — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kurâdo duano ewy uguondo aguely myani Jesusram: — Pabai tyigueduo, idânârâ niâm paigoem, urâem warâ, Konomedâni. Paigoram aguekâ: “Âukono agâ unwâm xurâpyry epajigâgâ” kekâ — kely mâkâ uguondo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aituo myani Jesus aguely: — Unwâm isejiguybyry ânguy xurâ awyly agueim mâkeba urâ. Âmâ, âwaigoru warâ xurâ wâgâ auguewâpyra ise urâ — kely Jesus eyam. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aituo myani Jesus tonlo modoram aguely: — Auguely idataungâ; tâmaynelâ itaungâ. Idânârâ âdydo imeom sodoem lelâ waypa itaungâ. Toenzepa âdype tadawyly kulâ aunloenlâ kuomazeândaymba, aunloenlâ kitoem aguyetaymba warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aituo Jesusram unâgue âzenomedâolymo: — Tâlâ myani uguondo toenzepa âdydo imeom sodo. Idânârâ ipi ezay etâdaymby modo koendâ kehoem ago itaynly. Eagâ tâwanuneim modo toenzepa kehoem nhekaunâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Toenzepa kehoem tientuo, mâkâ âdydo imeom sodo aguely tyangahu oday: “Toenzepa kehoem xirâ tâkaunâzeim. Ekanâdoem ejidy peba urâ. Âdara kukeanra ise agânhedyly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tyangahu oday tâwâlâ myani xunâgu: “Ah, xutuagui. Âdydo imeom etadâdo imeimbyry modo ise yagâ tâwanuneim modo nhakalaguely, imâsedo tintâdomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tâwâlâ ise auguely. ‘Tâlâ urâ idânârâ ize wato iweâpa iniem. Âdygue kâseguâdâbyra ise urâ. Iekobyzeguely ise. Kâwinduadyly, kadakuily warâ. Tuomare ise urâ warâ’ ” kely mâkâ uguondo tâwâlâ tyangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aituo myani eyam Deus aguely: “Tuândy âmâ! Xirâ kopaelâ ise âiguely. Âkelo ise mâenkanâdyby sodo, âmâ mâkeba” kely. Arâ myani mâkâ âdydo imeom sodo iguely. Tâlâ atobyry modo idânârâ âxiânly. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","— Auguely xirâ âyanmo. Adâise lâpylâ mâkâ âdydo imeom toenzepa turâem ekanânibyry modo. “Âdypeom xina” warâ aguelymo. Deus xurâem olâ âdypeom keba mâkâ agueim — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Agueypyem myani Jesus aguely tynynonro modoram: — Warâ âyanmo auguely. Tâseguâdâzeba itaungâ, pyni wâgâ, itymo owogonromogue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pyni keba, âtâ tâjiwogonro keba warâ tywyneim kuru. Deus ize matomo xuduze lelâ, âpynirymo, itymo owogonromo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Etaungâ konopio modo. Typiembamo. Typyniry netâbyramo, nekaunâbyramo warâ. Typyniry netadâbyramo etary odaji warâ wâne. Deus olâ ipynirymo tuduze. Deus xurâ âmaemo. Tawâguneim modo ipyniry tiunduho ara, âyanmo xuduze lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","Mâungukedânrymo wâgâ tâseguâdâzeba itaungâ. Âdara âiguelymo wâgâ tâseguâdâzeba itaungâ. Kyigueho odaji ituo, kyiguepa kitoem aguientaymba kurâ. Deuslâ kyigueho xutuim. Âigueho tâwâlâ mâungukehoem nudupa-ro watay, itymo owogonromo, âpynirymo, awârâ modo wâgâma kuru toenzepa tâpaunzezeba itaungâ. Deuslâ idânârâ ize kydato xuduim. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","— Mâzetydâdomogue, mâpâgudâdomogue warâ tâseguâdâzeba itaungâ. Etaungâ poji anano tadawanku. Nâsewanibamo, tâty tywogonro tianâtomoem. Kâdâkerâ nawâpyramo, tâtymo tywogonro adientomoem warâ wâne. Deuslâ olâ iwâkudâni. Kydamu Salomão toenzepa âdypeom myakâwândy, toenzepa lelâlâ. Iwâkuru modo myakâwândy ety iwogonro. Poji anano sawanku olâ Salomão ety iwogonro takaze kuru, tywâkurein-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iweâpa nipyra olâ awârâ poji anano sawanku. Iwerâ koendâ, tywâkure warâ, kopaelâgâem ipa, iladybyem lelâ. Awârâ sawanku tâense Deus watay, nhesemo lâpylâ. Itymo owogonromo xuduze. Mâinwâmpyra olâ âmaemo! ");
INSERT INTO bkqNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pyni wâgâ, okumo wâgâ warâ tâseguâdâzeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Deus einwântânry modo typynirymo, tokumo, tâty tywogonro wâgâ warâ kulâ inanry âtynanâdylymo. Âmaemo olâ, awârâ wâgâ tâtynanâzeba itaungâ. Tunwyn-em âmaemo Deusgue. Tutuze mâkâ idânârâ ize matomo. Âpynirymo, okumo, itymo owogonromo, awârâ modo xuduze lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Awylygue âwymârymo Deus ize ato modo waunroem aietaungâ. Mâkâ ize ato wâgâ waunroem mâpaunzeduo, idânârâ ize matomo xuduze Deus — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesus aguely myani: — Aguipa, ton-honremba warâ wâne âmaemo, tyanepa olâ itaungâ, âmaemo ynynonro modo. Kunwym Deus âduakewânmo, yagâ pymâem mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Âsejiguymo modo vende ietaungâ; ebyry âdy pebaom modoram xuduwâtaungâ warâ. Âzeon-hondâdaungâ, Deus ize ato amânhetomoem. Arâ ise koendonro ekanâdybybe mawylymo târâ kaynâ. Tâmagazeim modo nemagazebyra ise. Âdaunloenlâ tuonro nygataymba ise warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Xirâ anano tâenseim wâgâ kulâ mâpaunzedylymo watay, mârâ wâgâ kulâ âwaunkymo. Deus xurâ toenzepa ize matomo-ro watay olâ ise, ize ato ara lelâ ise amidylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesus aguely myani tynynonro modoram: — Inanaynmolâ itaungâ kodopâdo odaji ituo, ohondybyem lelâ. Tâzemary koendonro mawânkâ eagâ tâwano odopâdo oday ohondybyem, saindyly tynwânwânselâ, âzetydâdybyem, âjihuretadâdybyem, iwanxiery ekâjibyem, lamparina tyatygueim emaym warâ. Alâpylâ ohondaungâ, kodopâdyly mâinwânwântomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Inomedâdomoem ise xirâ unâ âyanmo kâengatuly. Tâlâ myani pymâ kopae todohogüin-ho etyryam idâim. Warâ myani aguely tagâ tâwaneim modoram, âtynra tâtâly iraynâ: “Kodopâdyly tynwânwânselâne itaungâ” kely. Agueypyem idâly. Âzetyguedyly. Iweâpa itybyem odopâdyly. Odopâdybyem, pyanta TON TON nhedyly, ingâsedyly. Aituo eagâ tâwaneim modo nhenahunguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tuomareim mâkâ tâwaneim modo. Tywymâry odopâdyly tynwânwânselâ waunlo. Awylygue toenzepa âzehogueolymo iwymârymoram. Pymâlâ ise on-honi akaemo tuantoem. Tâty iwâkuru etyze, tâdâsewanihongue ise âzetydâdyly, ipynirymo tiunduhoem. Mesaram ekadomoem aguely âwinduatomoem. Mâkâlâ pyni aieni, xuanimo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Âdara odopâdyly awyly nutubamo myani, kuetâji atay, pealâ atay warâ. Arâlâ olâ, nykyba awylymo. Tânanaym lelâ awylymo, ohondybyem lelâ. Aituo iwymârymoram koendâ kehoem âzeholymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","— Âdara tâmagazeim âewyly awyly nutuwâbyra âtâ sodo. Tutuze watay, tânuenze tâise, tânanaynlâ warâ, tysejiguy tienmakehoem. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kodopâdyly tânuenzelâ itaungâ; inanaynmo lâpylâ itaungâ warâ. Ienuendylymo ume inkâba ise urâ Uguondo Kaynâpa Âetyby kodopâdyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aituo myani Pedro aguely: — Megatuaguilâ awârâ tâwaneim eagâ tâwano inwânwânse pyantay atobyry. Ânguyranka amyguely, xinaram kulâ, idânârâam, Konomedâni? — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aituo myani Jesus in-hoguly: — Tâwaneim koendonro, eagâ tâwano tânuenze myara ienuendaungâ. Fazenda sodo taypa tâtâly iraynâ, tagâ tâwaneim tonomegueim, koendonroram watâkeze: “Udâly wao ise. Âmâ ise iety, ysejiguy, yagâ tâwanuneim modo warâ eni. Kopaelâgâembaba ise akaemo mâwandyly. Âdy ize atomo âundugâ” tâkeze mâkâ eagâ ewano, tâtâday. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Fazenda sodo aguehobyry ara aidyly-ro watay, koendâ ise iwymâry eagâ awyly, todopâduo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tâmaryam aguely ise: “Koendonro lelâlâ âmâ. Koendâ lelâ tâwanuneim modo medâ. Awylygue idânârâ ysejiguy modo eniem ise âmâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","— Koendâ tâwaneim keba mâkâ-ro watay olâ eagâ tâwano aguehobyry ara anipyra. “Ah, tahule nodopâdaymba ise mâkâ xirâ sodo” kely tyangahu oday. Adâkeduo, koendâ tagonro modo nepyra. Pekodo modo, uguondo modo warâ târâ tâwanuneim tapioguzemo tâise. Âtydâ kulâ, âwinduadyly, adakuily, toku ikaji kehoem idyly tataen-ho inakai modo agâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mâkâ tâwaneim tynwânwândyly umepa iwymâry saindyly. Eagâ ewano mâkâ tâwaneim agâ tyewiâpaze, tâdâsenagazedoram talehoze-ro warâ, Deus einwântânry modo âsenagazedoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","— Tâwaneim, eagâ tâwano aguehobyry aietânry, toenzepa âsenagazeze, adienkyly tutuzelâ aniempyra-ro waunlo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mâkâ tywymâry aiedyse ato nutuba tawylygue aniempyra awyly waunloma âdiempa kulâ ise âsenagazedyly, adyeseim aniempyra itobyry wâgâ. Tâwaneim, adyeseim tutuze kulâ, aietânry olâ, iwymâry toenzepa enagazenehonze aniempyra atobyry wâgâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus aguely myani: — Peto wâne saxiondâ saxium nhaduândyly, nhainly warâ-ro mârâ emyenro urâ. Inakanhe tadawyly sainze xirâ anaxi kâewyly, yeinwânni modo ioday inakanhe awyly sainze. Koendâ awyly kuru tâise “Aiekâne” kehobyry ewanikeimbyryem urâ-ro watay. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Toenzepa âsenagazeze urâ, igueze warâ. Toenzepa kadahulily, anipyra awyly ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kâetuo, inakanhe tadawyly, tâdâseguebyly warâ adainly keanra keankâ, inanajimo. Arâpa olâ. Yeinwântânry modo, yeinwânni modo izepamo ise. Ynynâbaom modo, ynynonro modo enagazezemo, tâwâlâ wâne âjipemugüem awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Âtâ odakâ yeinwânni, yeinwântânry modo warâlâ âewiâmunezemo. Tygue tygue itaynzemo, âjigue âjitoguyzemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tâjiunwym, tymeombyry iewiâseze. Tâjimery, tunwym iewiâseze. Tâjise, tâxirydo iewiâseze. Tâzexiry, tyze iewiâseze. Tâjimenhundu, tyweise ynynonro iewiâseze. Tâjiweise, tymenhundu ynynonro iewiâseze warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aituo Jesus aguely kurâdoram: — Kau emyguymadyly mâendylymo-ro watay, inepa kehoem kopâ ihuguerin-em awyly mâuntulymo, tâihugueze lelâlâ-ro warâ. Kopâ ihuguely xutuho awârâ eunu kau wâgâ emyguymadyly watay. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sul ynynâba sapezenru âewyly mâuntulymo-ro watay, “Âdâpigu adaguly isenra” myguelymo. Âdâpigu adaguho tainse lelâlâ-ro warâ. Âdâpigu adaguho xutuho awârâ sapezenru sul eynynâba âeni. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tonomegueinhe wâne mâdutulymo, tonomegueba olâ âmaemo. Kau mâendylymo-ro watay, kopâ ihugueze, nihugueba warâ awyly tutuze âmaemo. Se modo sawanseduo, tutuze âmaemo, âdâpigu saindyly awyly. Âdaituo Deus eon-honrugue agânhedyly awyly olâ mâuntuba lelâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus aguely myani: — Âdaituoka tâwâlâ âdykonlo koendonro, inakai warâ awyly mâuntuba mawylymo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Etaungâ, ânguylâ agâmo tyewiâse. Âwankuem mânhetomobyry wâgâ watay, iwentâguedylymo. Aguely: “Pymânra ise adylymo, itadânehon-homoem” kely. Myarâ adylymo iraynâlâ, eagâ koendâ âtunâguedaungâ, tyewiâseba ietaungâ warâ. Amyguepa âmaemo eagâ watay, tuxize kehoem pymânra asemo. Aituo ise pymâ itadânehonlymo, pyanta nhenahuen-honly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pymâ aguehobyry ara idânârâ mâempywabyra âmaemo watay, igasewâbyra âmaemo târâpa. Arâ lâpylâ Deus agâ koendâ itaungâ koendâ mitomobe awyly umelâ — kely Jesus tonlo modoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ilâ ume kurâdo ewy Jesus iopaji idâlymo. Aguelymo myani: — Tutuze âmâ, Galiléia domodo târâ Jerusalémdâ aietomobyry. Deus ety oday ânguydo imeom xyâypy egameze ataymo, Pilatosram âzegameolymo xyâhomoem. Inakanhe awylymoguelâ âdyolymo. Âdara inanaji? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aituo myani Jesus aguely: — Inanajimo arâ Galiléia domodo âdyoly, tagonrodo takaze inakai awylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Arâpa olâ! Tagonrodo takaze koendâpa awylygue inkâba myani akaemo iguely. Inakanhe mawylymo mâinmopa âmaemo yeinwântoem watay, Deus eydâ atoram mydâwâpyra ise âmaemo âigueduomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tânanâguezelâ keanra âmaemo, dezoito uguondo Siloé donro modo mârâ torre tuonwa ihugueduo iguewâtyby modo. Jerusalém donro modo takaze inakaigumogue akaemo iguely, inanajimo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Arâpa olâ. Awârâ wâgâ inkâba myani arâ iguelymo. Igueze lâpylâ âmaemo. Deus izepa ato aiedyly mâinmopa âmaemo yeinwântomoen-ro watay, Deus eydâ atoram mydâwâpyra ise âmaemo. Deus agâ iwaguelâ ise âmaemo. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ilâpyryem Jesus unâ nhegatuly, enomedâzemo. Aguely: — Tâlâ myani nady figueira, âtâ inatay, nady tâwituneim modo duay etâdyby. Âdaunloenlâ newiseba olâ myani mârâ figueira. Aunlolâ mykâinane sodo, ewiseyby ese idâzesedyly wâne. Newiseba lelâ olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aituo myani aguely mâkâ nady modo eniram: “Egâ awârâ figueira. Azagâ tokalâ warâ anu awârâ ewisely kâempyra wawyly. Ewiseho odaji ituo kâewyly ese. Âdalâ ewitu kâempyra urâ. Satâgâ. Newisewâbyra awârâ. Alâ kulâ awârâ onro nhuan-huly târâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Warâ olâ myani mâkâ tâwaneim aguely: “Alâ wao nidâ tokalâ anu lelâ. Tânâmize esagueze lelâ urâ. Toenzepa adubu iese urâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Awârâ anu âeni wâgâ ewiseze wâne keanra awârâ figueira. Newiseba lelâ-ro watay maise tâwâlâ mantâen-honly” kely myani — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tâzekobyzegueho oday myani Deus xunârygue Jesus kurâdo nhenomedâdyly âtâ tâdâtâdyguyho oday. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pekodo dezoito anu tâwâneimpe myani târâ, tykadâungueim. Âdara kua ini-emba. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tientuo myani Jesus tyam ingâsedyly. Eyam Jesus aguely: — Kua âese urâ, koendâ âkary itoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Agueypyem myani Jesus tâmary nhonwa nhedyly. Ilâ umelâ kehoem tykadâungue adakobâdybyem koendâ ikary idyly. Deus wâgâ aguely: — Koendonro awâkâ Deus urâem! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Âtâ tâdâtâdyguyho iwymâry toenzepa kehoem iewiâpadyly, Jesus mâkâ tâzekobyzegueho oday kua nhetobyry wâgâ. Aituo myani kurâdoram aguely: — Seis emedyly lelâ tâdâsewaniho. Kua midyse mataymo, tâzewano oday âetaungâ. Tâzekobyzegueho oday kua ise tâeseba itaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aituo myani Kywymâry Jesus aguely: — Koendonroem wâne mâdutulymo, koendonro keba olâ âmaemo. Tâdâzekobyzegueho oday tâsewanize lâpylâ âmaemo! Iguymo tapirâ, jumentu warâ paru nhenyhoem tywykâjigueze tâzekobyzegueho odaylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Merâ pekodo, kydamu Abraão iwery. Dezoito anu Satanás merâ pekodo inakanhe ieseze awyly, âzewykehoemba awyly. Tâzekobyzegueho oday lelâlâ merâ kua kânhedyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Awârâ tindatuo myani Jesus izepanro modo âpybazedylymo. Izetonro modo olâ iomaru lelâ Jesus Deus eon-honrugue aidyly tientuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus aguely myani: — Unâ segatuji wao âdara Deus kywymâryem lelâlâ idyly awyly mâuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tutuzelâ âmaemo, âpa ezay mostarda ewy tâtâzeim, imeimbyry kulâ awyly. Mostarda ewy imeombyry kuru, nady ewy modo enday. Tâtâduo olâ tyazeze, ago tâise, imâsedo modoem kehoem tywatazeze warâ. Awylygue tawâguneim modo iwatary wâgâ tâty anhetoem nhuduly — kely myani Jesus. {“Myara lâpylâ saguhoem kuru aguipa kurâdo kulâ Deus tywymâryem awyly einwânni modo. Ilâpygueduo olâ agui tâisemo” keze Jesus aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus agueondyly: — Xirâ unâ lâpylâ segatuji wao, âdara Deus kywymâryem lelâlâ idyly awyly mâuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pekodo pão aieni imâem trigu nhedyly; fermentu olâ âdiempa kulâ nhedyly. Mârâ fermentu pão ioliho âdiempaombyry olâ trigu tuolize imâem kehoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ilâpyryem myani Jesus Jerusalémram idâly. Âtâ anary imâsedo anakâ, imeombyry anakâ warâ sakadyly, kurâdo tonomedâdaynze. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aituo myani adapâigueoly: — Pymâ, aguipa kulâ ise tâmakezeim modo? Aguipa kulâ mawânkâ ise Deus izepa ato aiedyly imowâni modo, inakanhe atomobyry nhygakehoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Aituo myani Jesus in-hoguly: — Auguely xirâ âyanmo. Deus agueho mâinwântomoem âzeon-hondâdaungâ, izepa ato amânhepyra mitomoem. Tagarane kehoem pyanta tâtabigueim oze kâgawântoem, ara lâpylâ eon-honru, inakai modo aiedyly mâinmohomoem. Toenzepa wâne inakanhe tawyly imoze kewâni modo, nimopamo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","— Âtâ odo pyanta enahunze xavegue kehoem. Kuoholâ ise âmaemo. Aituo ise mâingâsedylymo: “Tâwâlâla xina negawândâ, Pymâ” keze âmaemo. “Igawâmpyra ise mataunaze. Âdykâ ynynonrobyry mâkeba âmaemo” keze sodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aituo ise amyguelymo: “Agâlâ ani xina âwinduadyly, adakuily warâ. Xina ijidadârydâ ani mâenomedâdyly” myguelymo ise. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aguely ise: “Âutuwâbyramo urâ. Ydâpa itaungâ, âmaemo inakanhe aitaynrim modo!” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraão, Isaque, Jacó, eagonro modo, Deus eynynâ aguewâtyby modo warâ, Deus eydâ atodâ akaemo iwerâ. Âmaemo olâ ise eydâ atomoram mydâpamo. Mâpyneândylymogue, eogumase âmaemo âtynrumogue. Toenzepa mâsenagazedylymogue âerymo saguze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Deus ize ato lelâ aienibyry modo olâ eagâ iwerâ. Tâinkânro modo lelâba ise âtâdyguynri Deus pymâem atodâ. Xixi egaseho eynynonro modo, egawânto eynynonro modo, sul ynynonro modo, norte ynynonro modo warâ ise âtâdyguylymo. Yagâ ise âwinduadylymo; Deus tywymâryem awyly nhomaendylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iwerâ âgânonrobyry modo, ilâem waunroem ise. Waunropyry modo ise âgânâyam ise warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesus aguely ume myani fariseu domodo ewy iwaguepa saindylymo, aguelymo: — Idâ. Tarâpa ikâ. Âehondyze enra Herodes — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aituo Jesus aguely: — Wakewâtaunda mâkâ, poroho todu enokuni ara konokuniram: “Jesus itanrubyry xirâ âyam. ‘Iweâpa witaymba ise urâ. Kâsewanily, kâempagunâbyra olâ ise urâ. Tâwânuneim modo kua iese urâ. Kadopâgue taseim modo kua iese warâ. Iwerâ, kopaelâgâ warâ ise awârâ modo agânhedyly. Azagâ tokalâ warâ iguandyly bygueduo ise aiese kâjigonohohobyry modo kâenwanikely’ keanry” kewâtaunda. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Awylygue iwerâ, kopaelâgâ, kopaelâgâbygueduo warâ ise Jerusalémram idâzeseze wawyly. Jerusalémdâ lelâ mawânkâ Deus eynynâ aguewâni modo iguely — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ilâpygueduo myani Jesus aguely Jerusalém donro modo wâgâ, eydâmolâ-ro waunlo ara lelâ: — Âmaemo, Jerusalém donro modoram xirâ auguely. Iweâparoem, âjidadârymo donro modo Deus itaumbyry egatuwânibyry modo xyâwânmomy. Agui Deus ingonotaymby modo tuhugue tyâzemo myani. Arâlâ olâ toenzepa âwynedylymo. Aukuma wâne tymeombyry tawâry iaxi tydâtyguyze, tuan-hun-hoem, myara toenzepa idânârâ nhedysemo wawyly. Agui olâ âmaemo ewy yizepaom modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Deus odokezemo. Saguhoem wâne ani koendâ agâmo myarapa ise Deus. Âtâ sodokeyby ara ise âmaemo. Ietondaymba ise âmaemo, “Koendonro lelâlâ âmâ Deus Ingonotyby” yam myguehomo odaji idyly ara. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tâzekobyzegueho oday myani fariseu domodo iwymâry ewy Jesus tâtyram âwinduase idâhoem ingâsedyly. Aituo Jesus idâly. Idânârâ tonlo modo Jesus nhenuagaendylymo, âdylâ anhedyly tientomoem, “Âdylâ adyesenry aiese lelâlâ enra tâzekobyzegueho oday” tâkeduomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Târâ uguondo tâwâneimbe, ewâry, ixinary warâ toenzepa myani sakygu. Mâkâ tâwâneim Jesus iopaji saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tientuo myani Jesus aguely fariseu domodoram, Moisés inweniby wâgâ enomedâni modoram warâ: — Âdaraka Moisés inweniby aguely tâzekobyzegueho oday tâwâneim kua iedyly wâgâ? Tâwâlâ, tâwâlâpa kua iedyly? — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nihogubamo olâ. Aituo myani Jesus tâwâneim onwa tâmary MÂʼ nhedyly. Adyetuo, tâwâneim kua idyly. Kua tiempygueduo eyam aguely: — Idâ lelâ itynra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aituo myani Jesus aguely fariseu domodoram: — Tâsewanize lâpylâ âmaemo tâzekobyzegueho oday. Âmerymo atay, iguymo tapirâ atay warâ, tâtagueim odaji ihuguely tâzekobyzegueho oday-ro watay, kopaelâgâem mânhenehonwâbyra âmaemo. Ilâ umelâ mâentylymo, tâzekobyzegueho oday awyly umelâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Âdara kepamo lâgâlâ, âkealâ Jesus aguely awyly tutuze tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Igâsedaymby modo mesa wâgâ tâjidy koendonro lelâ induakelymo tânuagaenze myani Jesus. Mure âty sododâ iwaguepanro kehoem induakelymo, tynreim modo ekadodâ kehoem. Awârâ tientuo myani Jesus aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","— Mâwinduatomoem mâjigâseolymo-ro watay tynruneim modo ekadodâba ikadaungâ, akadâmo tynreim, mure sodo modo sainse mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aituo ise âty sodo âyanmo aguely: “Eagonrodâ ikadomo xuiwâtaungâ. Xirâma akadâmo tynreim modo ekado-ro” keze âgâsenimobyry. Aituo ise toenzepa kehoem mâpybazedylymo. Mure âty sodo xurerydâ iwague ise mâzekanâolymo, kurâdo âdaunlo modo agâ kulâ. Arâ mawânkâ “Tynrenseim urâ” kewâni modo aieholy. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","— Mâwinduatoem mâjigâseolymo-ro watay, iwaguelâ âty sododâ ikadaungâ, kurâdo âdaunlo modo duaylâ. Awylygue mawânkâ ise âgâsenimobyry warâ âyanmo aguely: “Âetaungâ wopaji, yataen-ho modo. Xirâ pymâ modo ekado onwa ikadaungârâ” kely. Awârâ tientuo, idânârâ igâsedaymby modo tynrenseim mawylymo xutuze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Deus enanajima, kurâ domodo tâwâlâ kulâ âtyrenni watay, âdaunlo modo kulâ awâkâ aunlo. Âtyendânry modo olâ Deus xurâem, tynreim kehoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ilâpygueduo myani Jesus aguely igâsedaymby modoram: — Âty odo âmaemo-ro watay, ataen-homo lelâ inkâba, âukonodo lelâba, âwaigorudo lelâba, âpemugudo lelâba, âdydo imeom sodo modo lelâba warâ igâsedaungâ. Ilâpygueduo, âgâsezemo lâpylâ mawânkâ âdaralâ tâtyram. Âgâseni modo kulelâ mâingâseguylymo-ro watay, ânguy mâenmawyadâdylymo mâkeba awârâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Itydâ âty ize mataymo, âdy pebaom modo, kurâdo tywykuneim modo, ixigalamadaymby modo, epy modo warâ lâpylâ âingâsedaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mâkâ kurâ domodo mâingâsedylymo-ro watay, toenzepa omaromoem Deus aiese. Akaemo olâ ise eagâmo mâzetyguedomoem âgâsebyramo, mâingâsebygueduomo âdy âyanmo tiunduly peba tawylymogue. Deuslâ ise omarumo xudunri. Xypyry etay, Deus tynynonro modo kurâem nhetonduo, ipywazemo lelâ. Âdy pebanro modo koendâ mâentomobyry wâgâ âzepywaoze âmaemo Deusram — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Awârâ tindatuo myani uguondo târâ âwinduani aguely Jesusram: — Koendonro ise Deus pymâem atoram idâwâni modo, iomarumo eagâ âwinduase — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aituo myani Jesus unâ nhegatuly, tienomedâdomoem, idânârâ igâsedaymby modo ara Deus eydâ atoram nâtâwâbyra ise kely. — Âdydo imeom sodo myani âty imâsedoem adientoem ton-honze. Toenzepa kurâdo tygâseze myani, tâtyram âwinduase idâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Alâ ituo, tagâ tâwaneim ingonodyly myani, ingâsedaymby modoram “Alâ iweâma. Yagâ âzetyguedaungârâ” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eagâ tâwaneim idâly. Ingâsedaynly. Igâsedaymby modo olâ tâtâdyzeba. Awylygue idânârâ âdaituo nâtâba tawyly wâgâ aguelymo. Saguho aguely myani mâkâ emaryram: “Ypi agânheto ejidy sanâdâ. Iweâ lelâlâ udâly ise ese. Kekâne âty sodoram, yagâ newiâpabyra itoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","— Eagonro aguely: “Dez tapirâ sanâdâ, ygarosary epâgueinhe. Koendâ âsewanily kâendyly wao ise. Kekâne âty sodoram, yagâ newiâpabyra itoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","— Eagonro aguely: “Iweâ kulâ enra kohogüinly. Awylygue ise udâpa wawyly. Kekâne âty sodoram, yagâ newiâpabyra itoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","— Aituo myani mâkâ emary odopâdyly. Idânârâ nhegatuly âty sodoram. “Agâ tâzetyguedyzeba mâingâsedaymby modo” kely. Awârâ tindatuo, âty sodo toenzepa kehoem tyewiâpaduo aguely: “Idâ inepa taseragâ; âdaunlo ânwa ozelâ idâ, âdy pebaom modo etyram. Âdy pebaom modo xarâ enekâ, kurâdo tywykuneim modo, epy modo, sautânry modo warâ eagâmo kâwinduatoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","— Emary idâly myani. Odopâdyly kurâdo âdaunlo modo agâ kulâ. “Idânârâ senetai, ese ugonotobyry modo. Ity tumykebalâ olâ; toenzepa âjipelâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","— Aituo myani âty sodo aguely: “Kurâdo iwagueno modo eta, iwerâ yagâ âwinduatomoem. Âpa ezaji, xidadâ iwaguenonra warâ idâ. Idânârâ monhontaynly modoram yagâ âwinduase âetomoem aguekâ. Tâewyseba awylymogue kulâ, eagâmo amyguepa tâiseba olâ ikâ, agâ âewylymo mâentoem. Iety xumydyze urâ kurâdogue” kely tâmaryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Idânârâ tonlo modoram aguely: “Âkeá lelâlâ xirâ auguely âyanmo, kâingâsedaymby âetânrybyry modo yagâ nâzetyguedaymba ise” kely mâkâ âty sodo — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesus Jerusalémram idâly ume toenzepa myani kurâdo nhapygue awyly. Aituo âsemyombâdyly. Eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","— Ynynonroem midyse mataymo, yeinwândyse mataymo, unwânmo, âzemo, âwydymo, âmeombyrymo, âwaigorumo, âukonomo, nhaundumo warâ takaze kehoem ywynedaungâ. Yakadâ âdaunlo kurâdo kulâ mâinwyneguylymo-ro watay, ynynonroemba ise âutulymo. Ize wato aietaungâ, ize matomo takaze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ynynonroem lelâlâ midyse mataymo, ize matomo ara kulâ amidylymo imowâdaungâ. Mâsenagazedylymo umelâ auguely idataungâ; yeinwântaungâ, âiguehomo odaji kehoem, kruz manâdylymo-ro waunlo ara. Arâpa-ro watay, ynynonroemba ise mataunaze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","— “Jesus eynynonro urâ” myguelymo iraynâ, tâmaenze mawylymo xutuwâdaungâ wao, yeinwâmpyra mipyra mitomoem. Saguhoem kuru âtâ itâni tintâdyly iraynâ, idânârâ âtâ isejiguy nhuduly wao nhekyly tintâdoem. Idânârâ âtâ isejiguy peba-ro watay, âtâ nitâdaymba mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Âtâ itâdyly nhaguly idânârâ âtâ isejiguy, sary warâ peba kulâ-ro watay, mârâ âtâ nadahuba awyly etaynrim modoram âwankuem âiehoze, âjeileoze warâ. Aguelymo ise: ");
INSERT INTO bkqNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Etaungâ awârâ âtâ. Sodo wâne itâdyly nagu, newanikeba olâ” kezemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","— Âseguebyze tâtâly iraynâ, sodadu modo iwymâry saguhoem kuru tuduery agâ tienmaenly, tienmaemba warâ tawyly wao nhutuly. Dez mil kulâ izodadury, vinte mil lelâ iduery izodadury-ro warâ watay, tyangahu odaylâ agueze: “Kienmaen-hoem ton-honre wânkâ ise kurâ âseguebyze?” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tâwâlâ aguely watay: “Kienmaemba ise kydaze” kely-ro watay, tuduery iwague awyly umelâ ise eyam agueim ingonodyly, nâseguebyba tâitomoem âtunâgueze. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","— Koendâ lâpylâ angahumo oday âdutuwâdaungâ, yeinwândyse, yeinwândyseba warâ mawylymo. Ynynonroem mataymo, ize matomo ara amidylymo imowâdaungâ, urâem lelâ amitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesus aguely myani: — Koendonro wâne peku, pyni tâkubâzeânze, podo niwânzeânehomba warâ. Peku, onro agâ on-hoam ityby olâ pyni ikaji ietoem nudupa. ");
INSERT INTO bkqNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Âdaitoem ânguy ize inkâba mârâ aunlo. Samely lelâ. Xirâ koendâ mâuntudyze mataymo, koendâ idataungâ, xutuwâdaungâ warâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impostu epywadobyry emakewâni modo, judeu domodo ezewenry ara aitânry modo warâ saindylymo Jesus iopaji, aguely idase. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseu domodo, Moisés inweniby wâgâ enomedâni modo warâ myani Jesus nhunâguedylymo. Aguelymo: — Kurâdo inakai modo agâ tadawyly keduonro. Eagâmo tâdâwinduadyly keduonro warâ merâ uguondo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aituo myani Jesus warâ aguely, enomedâzemo: ");
INSERT INTO bkqNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","— Cem ovelhape âmaemo watay, tokalâ xuzatuo, tuize tâise âmaemo. Noventa e nove tâtadâze tâise âmaemo etadâdo odaji xuzatyby xuize mydâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mâentuomo, tuomazeze tâise âmaemo. Âewandaymo tâise mâenewylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Itymoram aintuomo, itymo apano modo, ataen-hodo warâ mâingâsedylymo tâise. Amyguelymo: “Ohomaendaungâ yagâ. Ieguy xuzatybyma setai” myguelymo tâise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","— Deus, eagâ kaynonro modo warâ toenzepa tohomaenzemo lâpylâ, tokalâ kurâ inakanhe adâidyly inmoly, Deus tyeinwântoem watay, mâkâ tâinwânni modo nhomaendyly takaze kehoem. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesus aguely myani, enomedâzemo: — Tokalâ pekodo dez moedapeom, tokalâ tiamehonduo, tiamehoymby tuize myani. Lamparina tohobanâze, âtâ tawinkoenze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tientuo, tataen-hodo, tâty apano modo warâ ingâsedyly. Aguely: “Yagâ ohomaendaungâ. Ymoedary kamehoymbyma setai” kely. Warâ myani pekodo aidyly tiamehoymby tientuo, iomaru. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","— Deus emary kaynonro modo iomazezemo toenzepa kehoem, tokalâ kurâ âjityendyly, inakanhe adâidyly inmoly warâ watay. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aituo myani Jesus unâ nhegatuly, tienomedâdomoem: — Tâlâ myani uguondo, azagâ tymegueim. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Alâ myani imery iukono tunwynram aguely: “Âigueduo, mânhâympy modo urâem, paigoem warâ ise âzepajiwâdyly. Âiguely kâinwânwândyseba aze. Urâem ini mâundudyse urâ inepa kehoem” kely salokuzenomo. Aituo myani nhunwym tâlâ tato ara nhepajiwâdyly iukonoem, iwaigoruem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Inepa myani mâkâ iukono idânârâ turâ âjigue nhedyly. Taypa âkelo âtâ anaxi idâly. Myarâ taintuo myani etygu kulâ. Kywypado, inakai modo warâ anhedyly. Idânârâ tunwym dinheru nhuduypy nhainly myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","— Idinheruru adaimpyem myani âdara typyniry nhanâto peba idyly. Awylygue toenzepa myani mâkâ salokuzenomo tâwindygue âsenagazedyly. Mârâ xidadâdâ aekuru pyni peba lâpylâ; toenzepa lâpylâ tâwinzeim modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aituo myani âdylâ tâwanu xuize idâly tâwinduatoem. Uguondo tonlonra agueze idâly. Aguely myani eyam: “Âmâem âsewanize urâ, kâwinduatoenlâ. Âdy kâinly peba aze” kely mâkâ salokuzenomo. Aituo myani uguondo aguely: “Tâwâlâ yfazendaryram âsewanira. Ieguy pâsega modo ise mâenkyly” kely. Aituo myani idâly fazendaram, uguondo eguy pâsega eniem. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Toenzepa myani ewindy. Ânguy olâ myani nuapyra. Awylygue myani toenzepa pâsega ipyniry ewy tieindyse idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","— Toenzepa myani âsenagazedyly. Aituo aguely: “Inakanhe awitobyry wâgâlâ xirâ kâsenagazedyly. Pabai agâ tâwanuneim modo tâsegubydâzelâ kehoem ipynirymo. Ilâ enday urâ tarâ kâsewinzedyly! ");
INSERT INTO bkqNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pabairam kodopâdyly ise. Warâ ise eyam auguely: ‘Deus enanaym, inakanhe awidâ. Agâ inakanhe awidâ lâpylâ warâ, Pabai. Idânârâ mâunduypyma saim. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Awylygue âmery ara inkâba iegâ. Agâ tâwaneim ara kulâ iegâ’ warâ ise saintybyem pabairam auguely” kely mâkâ salokuzenomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aituo myani târâpa odopâdyly tunwym etyram. — Âtâdâ iwague endaylâ, nhunwym nhedyly. Tientuo, toenzepa kehoem intyendyly. Tâgase kehoem tymery iose idâly. Oxiodybyem inwymogoynly. Nhonugudyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aituo myani mâkâ salokuzenomo aguely: “Deus enanaym, inakanhe awidâ. Agâ inakanhe awidâ lâpylâ warâ, Pabai. Idânârâ mâunduypyma saim. Awylygue âmery ara inkâba iegâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","— Aituo myani nhunwym tagâ tâwanuneim modoram aguely: “Iokobadaungâ, âtâ iwogonro iwâkuru kehoem enetaungâ. Etydâdaungâ. Ane iwâkuru emary ewily onwa ietaungâ. Ihuru etary ihuru onwa ietaungâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kâtygu ise! Tapirâ kiandyzeântyby xyâwâtaungâ warâ. Kydâwinduane! Kydohomaene! ");
INSERT INTO bkqNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ymery mawânkâ nodopâdai. Igueypy ara keankâ merâ, kagâlâ olâ iwerâ! Xuzatyby ara keankâ, xarâ kyam olâ nâepanâgueondai” kely nhunwym. Ilâpygueduo myani etyrymo adaguly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","— Ilâ ume myani iwaigoru saindyly âpa ezay tâwaneimbyryem. Âtâ iwaguepa saintybyem myani tydyzeim modo aguely indadyly, tâdâidyly indadyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aituo myani tâwaneim ingâsedyly, nhapâiguely: “Âdyka awârâ? Âdaituoka âidylymo, âdydo imeom indylymo warâ?” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","— Aituo mâkâ tâwaneim in-hoguly: “Âukono nodopâdai. Unwâm tapirâ kiandyzeântyby nyâen-hoagui. Âukono odopâdobyry xina nhetygueguyly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","— Awârâ tindatuo myani iwaigoru iewiâpadyly. Tâgawândyseba idyly. Tiuntuduo myani nhunwym egasely kuohoram. Idâly eydâ atoram. “Igawânkâ. Xina agâ ohomaengâ, Mery” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Imery olâ warâ aguely eyam: “Iweâpa agâ âsewanizeze wawyly. Âdykâ amyguehobyry kankadaymba urâ. Tokalâ bodylâ yam mâundupa olâ âmâ, yataen-ho modo agâ kâzetyguedoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Koendâpa aityby keankâ awâkâ âmeryma-ro. Idânârâ tydinheruru mâunduypy naim, pekodo inakai modo agâ tâitoem kulâ. Sainrimpyryem pylâ odopâdyly. Tapirâ sadyzeântyby mâyâen-honly, âty aietoem” kely myani iwaigoru. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","— Aituo nhunwym aguely: “Yagâlâ minase, Mery. Idânârâ tâlâ wato, âmâ xurâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Xirâ âty agânhedyse wawyly olâ enra, kuomaru kâenehohoem. Âukono mawânkâ nodopâdai. Igueypy ara keankâ mâkâ, kagâlâ olâ iwerâ! Xuzatyby ara keankâ, xarâ kyanlâ olâ nâepanâgueondai” kely nhunwym — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aituo myani Jesus unâ nhegatuly, tynynonro modo tienomedâdomoem: — Uguondo tydinherugueim toenzepa âdydo imeom sodo myani mâkâ. Tâlâ lâpylâ myani uguondo mâkâ âdydo imeom sodo isejiguy eni. Eagonro tâwanuneim modo tywymâryam agueze idâlymo, mâkâ isejiguy eni wâgâ. “Inokudyly kulâ mâkâ âsejiguy eni. Âdinheruru nhainly kulâ awâkâ” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Awârâ tindatuo myani sodo mâkâ tâwaneim ingâsedyly. Eyam aguely: “Iwerâ ise-ro? ‘Ienokudyly kulâ myinanry. Koendâ ysejiguy mâentaymba âmâ’ nyguemo. Âkealâka? Pape wâgâ iwenigâ idânârâ mâentaynly modo igondago, âdara yagâ deve awylymo kâuntuhoem. Yagâ mâsewaniombyra ise maze” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","— Aituo myani tâwaneim âpaunzedyly: “Tâwanepa widyly ise enra. Âdaraka ise iwerâ awidyly! Ton-honreba urâ, âpa ezay tâwaneinhe. Tywypaze urâ, âkelomoram âzekainze. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah! Awidyly xutuagui iweâma. Tutuze urâ, âdara ywymâry agâ tugontaguneim modo eataen-hoem widyly lelâ ise. Awituo ise akaemo yagâ koendâ awylymo. Tarâpa kâjigonoholy watay, ypyniry, ipa wato modo warâ xuduzemo” kely myani mâkâ tâwaneim tyangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","— Aituo myani idânârâ mâkâ uguondo âdydo imeom sodo agâ tugondagueim modo ingâsedyly. Saguhoram aguely: “Âdara lelâka eagâ iewano agâ ogondagu?” kely. Mâkâ in-hoguly myani: “Imâem enra kâempywaguyly, quatro mil litros azeiti ioseaji” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Anra ogondary iwenibyem. Xugukeze urâ imâemba. Eagonro pape wâgâ imâembalâ ise kâinwenily. Azagâ mil litros azeiti lelâ ogondary, quatro mil mâkeba. Ikagâ. Izedy iwenigâ xirâ pape iwelo wâgâ” kely mâkâ tâwaneim. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","— Ilâpyryem myani eagonroram aguely: “Âmâ-ro, âdara lelâka eagâ iewano agâ ogondagu?” kely. Aituo myani in-hoguly: “Toenzepa ugondagu. Cem trigu etary lelâ” kely. “Xugukeze urâ ogondary. Oitenta etary lelâ ise ogondary iwerâ. Tarâ xirâ pape iwelo wâgâ izedy iwenigâ” kely mâkâ tâwaneim konokuni. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","— Aituo myani iwymâry aitobyry nhutuly. Aituo aguely: “Ienokudâ wâne. Tonomegue lelâlâ olâmy makynre. Angahu oday, âdara âpyniry, ipa mato modo mâendyly mutu, yagâpa iwanu ipygueduo. Koendâ kehoem amidâ, waunroem mâzetoem” kely myani tâwaneinram. Warâ myani tâwaneim konokuni aidyly — kely Jesus. Aituo myani Jesus agueondyly: — Deus einwântânry modo tyangahu oday, âdara waunroem adâidyly awyly tutuzemo. Turâem pyni, ipa tato modo warâ xuduwâni modo eataen-hoem tâise lelâ. Arâ adâjidylyem lakuru enomegumo, Deus eynynonro modo takaze kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tonomegue âdinheruru tâlâ matomo aietaungâ, agonromo mâenmawyadâdomoem. Âdinherurumo adainly watay, Deus eydâ atodâ tâjike lelâ ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Âdiempa tâlâ tatogue, âkelomo emawyadâninra xuduze Deus toenzepa tâwâenseim târâ eydâ tatodâ. Âdiempa tâlâ tatogue, âkelomo emawyadâdânryram olâ ise Deus nudupa tâwâenseim târâ eydâ tatodâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Âiguelymo iraynâlâ, koendâ âdinherurumo aiedyly mâuntuba âmaemo watay, Deus iwâkuru modo nudupa lelâlâ ise, âigueduomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Koendâ nhuduypy amânhepyra âmaemo tarâ onro anaym watay, nudupa lâpylâ ise koendonro modo târâ eagâ mataymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","— Azagâ tywymâgueim kurâ watay, nuduwâpyra azakâlâ agueho arâ aguientoem; merâ âdylâ aguiendyse, mâkâ âdylâ aguiendyse lâpylâ. Aituo tokalâ aguehobyry lelâ aguienkyly. Arâ lâpylâ mawânkâ awâkâ Deusgue tywymâgu ize tawyly umelâ toenzepa dinheru izetonro modo, Deusgue iwymâgüem nudupa awyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Toenze kulâ dinheru izetonro mâkeba fariseu domodo. Aituo, “Deus ize ato amânhekylymo atay, toenzepa âdype midylymo wâgâ mâpaunzedylymo atay warâ iduakewâdaungâ” Jesus kely tindatuomo, aguehobyry wâgâ âwankuem nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aituo myani Jesus aguely: — Âkelomo enanaji, koendonro âmaemo. Deus olâ tutuze koendonro keba mawylymo. Tywângueim ara kulâ kurâdo iomazeândoem amânhekylymo Deus xurâem. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","— Saguhoem kydamudo âdara Deus ize ato adiendyly nhutulymo myakâwâm kâzewenry Moisés inweniby wâgâ, Deus eynynâ aguewâni modo nhenomedâdo wâgâ warâ. Warâ mykâinane kydamudo aidyly, até João Batista ume. Iwerâ ozelâ ani, âdara Deus pymâem idyly wâgâ João Batista aguely. Arâ lâpylâ urâ unâ koendonro kâengatuly, âdara Deus kywymâryem idyly wâgâ. Toenzepa kurâdo Deus tywymâryem ize awyly, pymâem atoram tâtâdyze awylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","— Onro, kau warâ adainze. Deus aguiendyse ato Moisés iweniby olâ nâtugugueba. Âdaunloenlâ tokalâ ezewenry iweniby ewy tâtywâduneba ise warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","— Eagonro pekodo agâ mohogüinlymo, saguho âwydymo mâinmopygueduomo-ro watay, inakanhe midylymo awârâ. Aituo Deus izepa ato ara amidylymo. Deus xurâem, waunro tâjiwydylâ, iwydy kuru, nhatano keba. Pekodo imoyby agâ ohogüimby watay Deus izepa ato ara kulâ lâpylâ aidyly. Deus xurâem, waunroem eagâ ohogüimbylâ mawânkâ iso kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aituo myani Jesus unâ nhegatuondyly, enomedâzemo: — Uguondo âdydo imeom sodo myani. Kopaelâgâembaba âtâ tywogonro iwâkuru, tâwâenseim warâ nhedyly. Âtybeom ara lelâ myani etydâ. Aunlolâ myani etydâ pyni tâwâenseim, tâkubâguneim modobe awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","— Tâlâ pylâ myani uguondo âdy pebaom Lázaro keho. Toenzepa myani iwâgâ pinuri modo egasely. Kopaelâgâembaba myani adaholy, mâkâ âdypeom ety iwyantaji. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Aunlolâ myani âsewinzedyly. Mâkâ âdypeom typyniry egupyry nhameyby, iwenzary wâgâpa ihugueyby modo kulâ myani nheinzeseguyly. Kaxorodoram iwinuriry âjilugainholy. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","— Aituo mâkâ kaikâ iguely. Anju domodoram myani egadopyry adaholy, kydamu Abraão eyam iwaguepa, Deus ize ato ara lelâ aini modoram. Tuomare kehoem myani târâ awyly. Mâkâ âdypeom tâigueze lâpylâ myani. Eguepybyry myani igueypy modo etadâdo odaji adaholy. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Deus ize ato aietânry modo egadopyry idâhoram myani adaholy. Toenzepa târâ âsenagazedyly. Tâsenagazeday, iwaguelâ Abraão nhedyly, eagâ Lázaro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aituo myani adaenkely: “Tako Abraão, ytyendâlâ ikâ! Toenzepa tarâ peto onwaym kâsenagazedyly. Lázaro tâmary ewily paikaji inkuihoem aguekâ wao, ulu nhâkânwanâze âetoem. Kâenmaemba aze tarâ âdâpigu!” kely mâkâ âdypeombyry. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","— Warâ olâ myani Abraão eyam aguely: “Âiguepa mawyly ume, toenzepa ani âdinherugu, âdydo imeom iwâkuru modope mawyly warâ. Lázaro ani âdy peba, toenzepa âsenagazedyly. Iwerâ mâkâ saguhoem âsenagazedyby Deus enado, awârâ modo nhewânukely. Âmâ toenzepa âsenagazeni iwerâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eydâ matoram merâ idâhoem nuduwâpyra, kuontay tâtagueim imeâgâemba kehoem tâsanigueimbe. Awyarâ tâzekuâdyze donro modo âzekuâdomoem nuduwâpyra. Atonlo modo xayam nâzekuâbyra lâpylâ warâ” kely Abraão mâkâ âdypeombyryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","— Aituo myani mâkâ aguely: “Xirâem olâ ytyendâ ikâ, tako Abraão. Pabai ety donro modo xuruse Lázaro igonokâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cinco lelâ konodope urâ târâ. Tâwâlâ Lázaro xurusemo nâtâ, niguepa tawylymo umelâ, inakanhe adâidyly inmohomoem. Deus izepa ato aiedyly nimopamo-ro watay, âese lâpylâ akaemo xarâ, xirâ âji toenzepa kehoem tâdâsenagazedoam” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","— Aituo myani Abraão aguely: “Tâlâ Moisés aguehobyry iweniby Deus aguiendyse ato wâgâ kuruni. Tâlâ lâpylâ, saguhoem kuru Deus wâgâ aguewâni modo aguehobyry, âdara Deus agâ koendâ kitoem aguidyly wâgâ. Ilâ agueholâ âukonodo, Deus ize ato adiendyse tatay, neinwândâmo” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","— “Tako Abraão, Deus itaumbyry saguhobyry tindadysebamo, tyeinwândysebamo warâmo olâ inanry. Tâlâ Deus einwânniem itomoem aieto. Ânguylâ igueypy kurâem itondyby Deus wâgâ eyanmo agueze idâly-ro watay, inakanhe adâidyly imozemo, Deus tyeinwântoem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","— Aituo myani Abraão aguely: “Moisés aguehobyry nidapyramo, saguho Deus wâgâ aguewâni modo aguehobyry nidapyramo warâ watay, neinwâmpyra awylymolâ ise, ânguylâ igueypy kurâem itondyby Deus wâgâ aguenri awyly umelâ” kely Abraão — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Aituo myani Jesus aguely tynynonro modoram: — Aunlolâ kurâ domodo Deus neinwâmpyra ienehoim modo aidyly. Toenzepa kehoem âsenagazeze mâkâ yeinwânni yeinwâmpyra ienehoim. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Koendâ tâise mâkâ iguely, yeinwânni yeinwâmpyra tienehonly iraynâlâ. Koendâ tâise tuhu imâsedo iwymy onwa ekâjily, parutabâ ikaji samehoem, yeinwânni yeinwâmpyra idyly iraynâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tâmaynelâ aitaungâ, aguewâtaungâ warâ. Yeinwânni modo ewy âynynâ inakanhe aidyly-ro watay, eyam aguewâtaungâ: “Deus izepa ato ara midyly awârâ. Adâiseba ikâ. Deus einwânkâ” kewâtaungâ eyam. Inakanhe adâidyly inmoly-ro watay, enanânehonwâdaungâ aitobyry. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Inakanhe adâidyly wâgâ âjityendyly watay, “Awitombyra ise urâ” keduo, inakanhe awyly enanânehonwâdaungâ. Toenzepa inakanhe aidyly umelâ, sete lelâ tokalâ iguandyly ara, inakanhe awyly enanânehonwâdaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesus induakeyby modo aguelymo myani eyam: — Xina âinwândyly imâem iekâ, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aituo myani aguely: — Mostarda ewy imeimbyry aralâ, âdiempa yeinwândylymo watay, toenzepa on-honrumo xuduze urâ. Figueiraram, “Onkegâ. Parutabâ ikaji âzetâda” mygueduomo, aise amyguehomobyry ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aituo myani Jesus unâ nhegatuly, tienomedâdomoem: — Etaungâ. Âduaymo tâlâ uguondo emary poji anaym tâwaneim, eguy kaneru eni warâ watay, mâkâ poji anaymba saintuo, iwymâry eyam, “Ikobyzeguegâ. Ikagâ mâwinduatoem” kewâpyra tâise. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wakely tâise: “Iokobagâ, ypyniry aiekâ. Mesa onwa enekâ. Ohondybyem lelâ ikâ, kâwinduadyly ume, kadakuily ume warâ kâenkadyby mâenetoem. Kâwanikebygueduo ise tâwâlâ mâwinduadyly, madakuily warâ” kely tâise tâmaryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pymâ tâmaryam wakepa: “Koendonro âmâ; xirâma urâem amientai” kepa. Aguehobyry aieni kulâ mâkâ emary. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Deus emary âmaemo. “Aiekâ” kehobyry amânhedylymo watay, iwanumolâ mârâ amânhekylymo. “Koendonro âmaemo” kely kâzenuedaundâ. “Amyguehobyry aieni kulâma xina” kewâtaungâ Deusram — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalémram tâtâly ume myani Jesus Samaria, Galiléia warâ ontagâ sakadyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Âtâ anary imeimbyry odaji saindyly ume myani dez uguondo tâjimituguelygue tâwânuneim modo idâlymo iose. Iwaguelâ epagudylymo, awârâgue tâwânuneim modo iopaji ânguy naimpyra awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Târâ endaylâ adaenkelymo: — Xina tytyenzelâ ikâ, Jesus. Xina kua iekâ, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tientuomo myani Jesus aguely: — Kurâdo eynynâ Deus agâ aguewâni modoram âzehowâdaunda, kua ietybyem mawylymo nhutuhomoem — kely Jesus. Aituo myani mâkâ dez uguondo modo ânwa oze idâlymo umelâ, kua idylymo Jesus eon-honrugue. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kua itybyem tawyly tientuo myani tokalâ mâkâ uguondo modo ewy odopâdyly Jesusram. Todopâdyly ume myani mâkâ kaynâ kehoem xunâgu: — Koendonro awâkâ Deus! Ton-honreim awâkâ Deus! — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus eydâ atoram saintondybyem, enado âzeguhoam itybyem aguely: — Koendonro lelâlâ âmâ. Toenzepa agâ womaru, kua yetaima — kely. Samaria donro lelâlâ wâne, alâ olâ myani Jesusram odopâdyly, kua tyetuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aituo myani Jesus aguely: — Dez uguondo lelâ kua xietai. Akaemo nove lelâ odopâdylymo lâpylâ olâ tâise koendonro. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Âkelo anano merâ: “Koendonro âmâ, kua yetaima” keim. Ytynru olâ, judeu modo ewy yam âdalâ keze nodopâbyra awylygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aituo myani Jesus aguely uguondo kua itybyram: — Aukâ. Idâ. Koendâ kehoem kua itybyem âmâ, ton-honre wawyly mâinwântobyry wâgâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aituo myani fariseu domodo ewy Jesus nhapâiguely: — Âdaraka ise Deus pymâem tawyly nhenehonly xirâ anaym? — kelymo. Jesus in-hoguly: — Kienkyly mâkeba ise, Deus pymâem idyly adaguly. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuodaylâ mawânrâ Deus pymâem ato. Ânguylâ wakewâpyra ise: “Etaungâ, anra tarâ. Anri târâ” kewâpyra. Odaymolâ mawânrâ Deus pymâem ato. Tâenseim keba mawânrâ Deus kuoday anhekyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesus aguely myani tynynonro modoram: — Âsenagazeze âmaemo. Toenzepa ise agâmo wawyse mawylymo, on-hondâzemo. Tâwâlâ wâne âdiempa kulâ awyly. Urâ Uguondo Kaynâpa Âetyby tarâ agâmo witoem nudupa olâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Âyanmo aguelymo ise: “Nhaum, anra Jesus” kezemo. Tâlâ pylâ, “Jesus târâ” kewâni modo. Kâzeinwântaundâ. Uize tâgasezeba itaungâ aguehomobyryam. Tarâ inkâba ise urâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Urâ Uguondo Kaynâpa Âetyby kodopâduo, idânârâ iesemo. Ielu wâne kau xypyryram, xypyryram warâ tâzehorugueze, tâzehoze warâ, myara ise kodopâduo, idânârâ yaindyly âzehoze. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Awârâ iray, âzenagazeoze olâ urâ. Toenzepa ise tywymâryem yizepanro modo ilâ ume. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","— Noé umenobyry ara, arâ lâpylâ ise urâ Uguondo Kaynâpa Âetyby kodopâduo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Saguhoem myakâwândy, paru inwenlygue tadainlymo iray, kurâdo xara tatomo aralâ mykâinane. Âwinduadylymo. Adakuilymo. Salokuzenomo modo, âwynsaundo modo warâ ohogüinlymo warâ mykâinane aidylymo, Noé pepi imâsedo âtâ emyenro tyngatyby odaji âxiedyly iray. Âxiebygueduomo olâmy Deus inepa kehoem kopâ ihugueânmâ, adain-homoenlâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","— Ló umemy aimâ myara aitonze. Mârâ umeno modo xaralâ mykâinane aisezedylymo. Âwinduadylymo. Adakuilymo. Âdydo imeom nhanâdylymo. Vende nhedylymo. Typi nhetâdylymo. Tâty intâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodomadâpa Ló âxigueduo olâ myakâwândy Deus peto kau odaypa tyihugueânze. Kopâ ihuguely ara kehoem tuhu tohoreim emyenro enxofre ihuguely. Idânârâ kehoem iguelymo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","— Arâ lâpylâ ise urâ Uguondo Kaynâpa Âetyby kodopâduo, aguipa kulâ ise ywânwânni modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kaynâ itymo nhangatay ilajiry wâgâ mataymo, âytâguywâdaungâ. Âwientaungâ. Âsejiguymo enanânehonwâdaungâ. Âpa ezay âsewanize mataymo, inepa âwientaungâ. Todopâzeba itaungâ âtânra âsejiguymo ese. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Enanâguewâdaungâ, Ló iwydy aitobyry. Deus, “Inepa âwientaungâ” keduo, neinwâmpyra myakâwândy. Xidadâram odopâze kewândymy. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","— Tâwâlâ âdutuze keim âmaemo watay, mâzemakeowâbyra ise âmaemo. Âigueduo, Deus agâ mohomaendaymba ise âmaemo. Deusram tâenseim mataymoma âzemakeoze âmaemo. Âigueduomo, Deus agâ typyguenryem ise omarumo. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kodopâduo, ynynonro modo sase urâ. Ynynâbaom modo olâ ise urâ kampyra. Azagâ kurâ âjigamary wâgâ xykyim, ynynonro ynynâbaom warâ watay, ynynonro adahoze Deusram, eagonro olâ âjionze. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Azagâ pekodo trigu sakoim, ynynonro, ynynâbaom warâ watay, ynynonro adahoze Deusram, eagonro olâ âjionze. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Azagâ uguondo âpa ezay âsewanirim, ynynonro, ynynâbaom warâ watay, ynynonro adahoze Deus eydâ atoram, eagonro olâ âjionze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Awârâ tindatuo myani eynynonro modo nhapâiguely: — Âdykâ ise awârâ aidyly, Pymâ? — kelymo. Aituo Jesus in-hoguly; âdykâ awyly aguepalâ: — Tywângueimpe atoram elaho modo âtâdyguyly, ânguy, “Târâ igueypybe” keduo inkâba. Arâ lâpylâ ise kurâdoram kodopâdyly âdutuoly, ânguy âdakepalâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aituo myani Jesus unâ nhegatuly, tynynonro modo tienomedâdoem, Deusram tâwâlâ ize tato nhekazezedomoem, aunlolâ eyam nhekadomoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","— Tâlâ myani xidadâ oday uguondo, kurâdo ewentâdyly, tâwentâzeba warâ awyly wâgâ tâwaneim, awylygue juizgue ezeku. Koendonro keba olâ myani mâkâ, Deus ize ato ara aini keba, kurâ domodo koendâ eni keba, tienmawyadâdyzedonro keba warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tâlâ myani mârâ xidadâ oday pekodo pypâ. Aunlolâ myani juizram idâzesedyly, eagâ aguezeseze. “Mâkâ urâem inakanhe aityby agâ wao aguekâ” kezesedyly juizram. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","— Iweâpa myani juiz mâkâ pypâ aguely indasezedyly kulelâ. Ilâpyryem olâ myani âpaunzedyly: “Âkealâ, Deus ize ato agânhedysedonro keba lelâlâ urâ. Kurâdo kâenmawyadâdyzeba warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ynadyly olâ pypâ yam nhekazezedylygue. Awylygue ise aguehobyry agânhenehonly. Agânhepyra urâ-ro watay, aguezesedylygue xynazema urâ” kely. Aituo juiz, mâkâ pypâ nhekadyby anhedyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesus aguely: — Âpaunzedaungâ juiz aguehobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Adiendyseba lelâlâ wâne, pypâ nhekazezedyby olâ aiemâ. Mâkâ juiz ânguydo kulâ pypâ aiedyse ato aiemâ, nhekazedylygue; Deusma kuru ise koendonro tawylygue, tyam ekazezenibyryram xuduze. Koendonro ise anhekyly, aunlolâ ekani modo xurâem. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Tynynonro modo emakeze; inepa kehoem ise awârâ modo anhedyly. Urâ Uguondo Kaynâpa Âetyby kodopâduo olâ ise aguipa kulâ yeinwânni modo. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus unâ nhegatuly myani “Tagonro takaze kehoem koendonro urâ” keim modo wâgâ. Eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","— Azagâ uguondope myani. Tokalâ myani fariseu, judeu domodo ezewenry Moisés inweniby ara lelâ adâidysedo. Eagonro myani impostu epywadobyry emakerim, pymâ ton-honreim Roma donro xurâem. Azakâlâ idâlymo myani Deus etyram eagâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","XYDYK itybyem myani fariseu. Deus agâ adâkely waunlo ara myani tânanaji; tywâgâ kulâ olâ myani aguely. Aguehobyry Deusram naimpyra. “Tuomare urâ, yagonrodo takaze koendonro urâ. Ânguy enokuni keba urâ. Ânguy kâenmagazedaymba urâ. Moisés inweniby agueho ara lelâ awidyly. Ywydy lelâ kâynanâguyly, eagonro pekodo lâpylâ warâpa. Tuomare urâ, mâkâ pymâ Roma donro xurâem impostu epywadobyry emakeim araba wawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Azagâ iguandyly lelâ inanry semana oday kâwinduapyra widyly wao, imâem agâ auguehoem. Dez lelâ âdylâ kâenmakely-ro watay, aunlolâ inanry tokalâ âyam kâunduly” kely fariseu. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","— Impostu epywadobyry emakeim olâ myani toenzepa âpybazeni, inakanhe aini tawylygue. Awylygue myani enagozeybyem lelâ awyly, iwaguelâ Deus agâ aguewâni mododâ awyly. Âjihogainly tytyrungue. Aguely: “Inakanhe aini kulâ urâ, Deus. Ytyendâlâ ikâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","— Deus agâ adâkely ewanikeimbyryem, fariseu tâtyram odopâdyly. Impostu epywadobyry emakeim tâtyram odopâdyly lâpylâ. Warâ myani aidylymo. Impostu epywadobyry emakeim inakanhe aitobyry lelâ myani Deus nhygakely. Deus xurâem, mâkâma koendonro kuru, fariseu keba. Koendonroem tawyly wâgâ aguewâni modo, tynrempa âiehoze. Koendonroem tawyly wâgâ aguedânry ise âdyren-hoim. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ilâpygueduo tâjiunwyndo Jesusram tymeom nhadylymo. — Asaemo nhangahu onwa imary iekâ. Deusram koendâ âzehohomoem ekagâ asaemo xurâem — kelymo Jesusram. Awârâ tientuo Jesus eynynonro modo iamudo sanipyry modoram aguely: — Jesus kâdynanâdaundâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Aguelymo tindatuo olâ myani Jesus tynynonro modoram aguely: — Arâ adâkezeba itaungâ! Tâwâlâ yam iamimeom nâedâ. Kodopâdaundâmo. Iamimeom wâne enra ohondybyem lelâ yam tâetoem, myara lâpylâ kurâ domodo nohondâ, yeinwântomoem, Deus iwymârymoem itoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yam tâetoem ohondânry modo Deusgue tywymâgunebamo ise, iamimeom wâne enra ohondybyem lelâ yam tâetoem myarapa tawylymogue. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ânwa oze myani uguondo tysejiguyeim aguely Jesusram: — Koendonro lelâlâ âmâ, Pymâ. Âdaraka awidyly, Deusram udâhoem, aunloenlâ eagâ witoem warâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aituo Jesus in-hoguly: — Amyguely tutuzeka âmâ? Âdaituoka “Koendonro lelâlâ âmâ” myguely yam? Kurâ koendonro lâpeba, Deus lelâ koendonro. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tutuzelâ âmâ, âdy Deus aguiendyse ato awyly Moisés inweniby wâgâ: “Eagâ mohogüin-hobyry lelâ xynanâgâ. Ânguy kâdyâ. Tâmagazeba ikâ. Aitobyry wâgâpa kulâ âkelomo kâzewentâdâ. Unwâm, âze warâ einwânkâ, xyrenkâ warâ” — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aituo myani uguondo aguely: — Salokuzenomoem wawyly umelâ idânârâ Moisés inweniby ara awidyly, adyesezelâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uguondo aguely tindatuo myani Jesus aguely: — Tâlâ lâpylâ olâ amânhekyly. Âsejiguy modo idânârâ vende ieta. Ebyry ise âdy pebaom modoram mâunduly-ro warâ. Awârâ amânhedyly-ro watay, tâlâ lelâ ise âmâ mârâ koendonro Deus eydâ atodâ ekanâdyby. Idânârâ tâlâ mato mâunduduo, odopâgâ, ynynonroem mitoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesus arâ aguely tindatuo myani toenzepa kehoem uguondo itywandyly, tysejiguy modo vende tiendyseba tawylygue. Tytynre kehoem idâly. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mâkâ toenzepa âjityendyly tientuo Jesus aguely: — Ton-honre lelâlâ âdypeom modo yeinwântoem, Deusgue tywymâgomoem warâ, tysejiguy kulâ ize atomo kuru awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ton-honre camelu agüie ihu oze sakadoem, arâ lâpylâ ton-honre âdypeom modo tâlâ tato inmohomoem eon-honru, Deusgue tywymâgomoem warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","“Ton-honre âdypeom modo Deusgue iwymâgomoem” Jesus keduo idani modo toenzepa kehoem âseguâdâdylymo, âdypeom modo lakuru Deus eydâ atoram idâim waunlo ara enanajimo awylygue. Aituo aguelymo: — Arâ atayma ise ânguy nâsemaguewâbyra-ro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","— Deus olâ kurâ domodo anhetânry adyese lelâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jesus aguely tindatuo, Pedro aguely: — Xina-ro? Idânârâ tâlâ tato xina niâm, âynynonroem tâitoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aituo myani Jesus eyanmo aguely: — Idânârâ tâlâ matomo mânhânlymo, ynynonroem mitomoem watay, Deus xuduze lelâ ipa matomo. Itymo mânhânduomo, âykyhomoem ijidymo xuduze. Âwydymo, âwaigorumo, âukonomo, nhaundumo, unwânmo, âzemo, âmeombyrymo warâ mânhânduomo, Deus âpemugumo nhetomo ara kehoem nhenimo, âwynenimo warâ xuduze lelâ. Iwâgâ mânhâympymo takaze ise Deus nhuduly. Âigueduomo aunloenlâ ise Deus agâ mawylymo. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus doze tynynonro modo aguiom duaypa nhejikely, aguely: — Idataungâ wao auguely. Jerusalémram xirâ kytâly. Deus itaumbyry aguewâni modo aguehobyry ara ise agâieholy, urâ Uguondo Kaynâpa Âetyby. Arâ ise târâ aidyly idânârâ aguehomobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Judeu keba modoram ise kâzegameoly. Âwankuem yesemo. Unâguezemo. Iedakudâzemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yapiogüen-honzemo. Ilâpyryem ise yâen-honlymo. Azagâ emedyly idyly wâgâ kurâem itondybyem lelâ olâ ise urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Âdakeze aguely awyly nutubamo myani eynynonro modo. Nutuba itomoem aietybyem waunlo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus, eynynonro modo warâ âtâ anary Jericóram saindylymo ume, epy ânwa edazekâ ekadybyem. Sakadaynrim modoram aguely myani: — Ytyendâlâ itaungâ. Ydinheruru âunduwâtaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Târâ ekadybyem tatay, toenzepa kurâdo sakadyly indadyly. Aituo mâkâ lelâba nhapâiguely: — Âdyka awârâ? Ânguyka sakani? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","— Jesus Nazaré donro awâkâ sakani — kehonly. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Adâkehonduo, adaenkely: — Ytyendâlâ ikâ, Jesus! Âdamu Davi ara pymâ ton-honreim âmâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jesus eatado idâwâni modo aguelymo eyam: — MYK alelâ ikâ! Tadaenkezeba ikâ! — kelymo. Agueduomo lakuru myani ago kuru epy adaenkely: — Ytyengâ, Davigue tydamudogueim! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aituo myani Jesus epagudyly. Aguely tonlo modoram: — Epy yam enetaungâ — kely. Tuopaji saintuo myani Jesus nhapâiguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","— Âdyka âmâem agânhedyse mato? — kely. — Kâentondyze urâ, Pymâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","— Etonze lelâ âmâ. Kua âeniem wawyly mâinwântobyry wâgâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ilâenlâ kehoem myani epy nhetondyly. Ânwa oze Jesus nhapyguenoem idyly lelâ. Tâtâly ume aguely myani: — Koendonro lelâlâ Deus! Ton-honreim awâkâ Deus! — kely. Idânârâ tonlo modo, kua itybyem awyly tientuo, aguelymo: — Âkealâ, ton-honreim lelâlâ Deus! Koendonro lelâlâ awâkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aituo myani Jesus xidadâ Jericóram saintybyem, sakadyly xidadâ odakâ ");
INSERT INTO bkqNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kurâ domodo duay tâlâ myani uguondo âdypeom, Zaqueu. Impostu epywadobyry emakewâni modo iwymâry myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesus tiendyse. Imâkeba tawylygue olâ myani tâjiduay nepyra awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aituo tâgase waunroem idâly. Se imâsedo sicômoro keho, figueira emyenro, onwa âkuly, Jesus iwaguepa tientoem sakadyly ume. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Se iaxi taintuo myani Jesus kayam MYK idyly. Se iwatary wâgâ ekadybyem nhedyly. Tientuo aguely: — Zaqueu, iokobagâ âytâguygâ. Itydâ ise aze iwerâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ilâ tindatuo myani Zaqueu inepa kehoem se sicômoro wâgâpa xytâguyly. Toenzepa myani iomaru. Aituo Jesus tâtyram nhadyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tonlo modo myani Jesus Zaqueu ety odaji egawândyly tientuo aguelymo: — Etaungâ! Jesus negawântai inakanhe aini ety odaji, eagâ âwinduase. Anipyra tâise awâkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueu tâpague myani Jesus enado, aguely: — Idakâ, Pymâ. Tâlâ wato epajiwâze urâ âdy pebaom modo agâ. Impostu epywadobyry kâenmakely ume, epywado imâem kehoem kâenkadyby watay, dinheru xuduonse urâ eyanmo. Tokalâ moeda kâenmagazedyby watay, quatro moeda ise eyanmo kâunduly. Azagâ moeda kâenmagazedyby watay, oito moeda ise eyanmo kâunduly. Warâ ise awidyly — kely Zaqueu. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aituo myani Jesus aguely: — Xirâ âtâ sodo inakanhe aitobyry xygakeagui. Inakanhe aityby lelâlâ wâne, judeulâ olâ merâ Abraão iwerypyrylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tâjiunwym wâne tymery xuzatyby xuize tâtâze myara xuzatyby modo kâwinly, Deusdâ iwagueno modo, inakanhe awylymo kâyngakehoem, kâenmakehomoem warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Xidadâ imâsedo Jerusalém iwaguepa Jesus. Aituo tonlo modo aguely: — Inepa wânkâ ise Jesus Jerusalémdâ pymâem idyly? — kelymo âjigue. Arâ xunârymo tiuntuduo myani Jesus unâ nhegatuly, idanipyry modo tienomedâdoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","— Tâlâ myani uguondo pymâ tynreim iwerypyry. Taypa kehoem myani âjigâseoly, pymâ iwagueno agâ agueze. Pymâ iwagueno aguely: “Âmâ ise ity anano modo eni” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Taypa kehoem tâtâly iraynâ, dez lelâ tagâ tâwaneim modo ewy ingâsedaynly. Mâkâem, mâkâem warâ tokalâ moeda ourugueto tiunduday, aguely: “Anra moeda. Xirâ dinherugue âdylâ anâtaungâ, manâtomobyry takaze vende mânhetomoem. Warâ ydinheruru imâem mânhenehon-homoem kodopâdyly ara” kely myani mâkâ uguondo. Agueypyem idâly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ety anano modo izepa ato myani mâkâ. Awylygue myani kurâdo ingonodylymo pymâ iwaguenonra agueze: “Awâkâ uguondo izepa xina tywymâryem” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","— Mâkâ pymâ iwagueno olâ aguely: “Merâ ise âwymârymo, izepa lelâlâ wâne âmaemo” kely. Ilâpygueduo pymâ iwelo tâty anaxi odopâdyly lelâ. Saintybyem myani, tagâ tâwanuneim modo ingâsenehonly, âdara lelâ dinheru imâem ienehonrimbyryem awylymo tiuntuhoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Saguho saintyby aguely: “Tokalâ moeda ourugueto tâwâenseim yam mudu. Mârâgue âdydo imeom sanâdâ; kanâtyby vende xiedâ. Aunlolâ keankâ arâ awidyly imâem itoem. Iwerâ dez moeda, toenzepa tâwâenseimbe urâ. Anra tarâ idânârâ âmâem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","— “Koendâ tâwaneinlâ myanze âmâ! ‘Aiekâ’ uguehobyry amiendâ. Koendonro amiendâ âdiempa kâunduypygue. Awylygue ise dez lelâ xidadâ anano modo eniem âduakely” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","— Ilâpyryem nhatano tâwaneim âewyly. Aguely: “Tokalâ moeda tâwâenseim yam mudu. Mârâgue âdydo imeom sanâdâ; kanâtyby vende xiedâ. Aunlolâ keankâ arâ awidyly, imâem itoem. Iwerâ cinco moeda, toenzepa tâwâenseimbe urâ. Anra tarâ idânârâ âmâem” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","— Aguely tindatuo myani, mâkâ uguondo tâwaneinram aguely: “Koendonro amiendâ âdiempa kâunduypygue. Awylygue ise cinco lelâ xidadâ anano modo eniem âduakely” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","— Ilâpyryem eagonro tâwaneim idâly. Aguely: “Anra xirâ moeda tokaleom mâunduypy, pymâ. Âtâ tâjiwogonrogue xitunwym. Sekanâdâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Âytadâ urâ. Uguondo ânguydo kulâma âmâ. Mâsewanihobyrygueba âdype midyly. Xina âsewanirim; âmâ pylâ xina ewanopyrygue âdylâpe ini-ro” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","— Arâ agueduo myani, eagâ ewano aguely: “Inakanhe tâwaneim lelâlâ âmâ. ‘Uguondo ânguydo kulâ âmâ’ mygueanse. ‘Mâsewanihobyrygueba âdype midyly. Xina âsewanirim; âmâ pylâ xina ewanopyrygue âdylâpe ini-ro’ mygueanse. Iweâ lelâlâ xutuze âmâ, amyguehobyry ara lelâlâ wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ydinheruru imâem itoem âdy amânhedyseba matay, dinheru xynanâdaynrim modoram metadânehondyze banco odaji. Imâem ydinheruru tyenehonzema tâise akaemo. Arâ tâise kodopâduo imâem kâenmakely” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","— Aituo mâkâ uguondo tonlo modoram aguely: “Merâ inakanhe tâwaneim emaymba moeda emakewâdaungâ. Dez lelâ moedapeonram xuduwâtaungâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","— “Dez moedapelâ awâkâ, pymâ!” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","— Iwymâry aguely: “Mâkâ toenzepa tâlânro, imâem emakeze, iwerâ tâlâ tato takaze. Mâkâ agui ipaom olâ, âzemakeoze iwerâ aguipa tâlâ ato. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwerâ, yizepanro modo xarâ enetaungâ, iwymâryem wawysebaombyry modo. Xarâ enenimobyryem, ienanaym xyâwâtaungâ” kely mâkâ iwymârymoem itoem iduakeyby. Warâ xirâ unâ kâengatuly inomedâzemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Agueypyem myani Jesus waunroenlâ idâly Jerusalémram. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iwy Se Oliveira Ekaram saindylymo. Azagâ âtâ anary imeimbyry Betfagé, Betânia warâ iwaguepamo myani. Iwyram taintuo, Jesus tynynonro ewy azagâ waunroem ingonodyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Warâ myani eyanmo aguely: — Idâwâtaungâ âtâ anary waunroenoram. Aindylymo umelâ ise, jumentinhu ekâjibyem mâendylymo, âdykâ ânguy nhahozeândyby mâkeba ise mâkâ. Ekâjiguewâdaungâ. Enetaungâ xarâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Ine wao. Âdaituoka awâkâ mandylymo?” myguehonlymo watay, “Kywymâry merâ izetonro. Inepa ise nhopânehonly” myguelymo lelâ ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Idâlymo. Saintybyem jumentinhu nhedylymo, Jesus aguehobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nhekâjiguelymo ume myani, adapâigueolymo jumentinhu sodo modoram: — Âdaituoka mâenkâjiguelymo? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","— Kywymâry merâ izetonro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aituo myani jumentinhu nhadylymo Jesusram. Saintybyem myani tygaparyguelâ jumentinhu inkawendâdylymo. Aituo Jesus jumentinhu onwa âkuly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesus jumentinhu wâgâ âkuybyem idâly ume, toenzepa kurâ domodo tygapary ânwa oze PO PO nhedylymo, Jesus iray, tynrense tawyly tienehon-homoem, pymâ ton-honreim kehoem iray adâitomo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalémdâ iwaguepa awyly ume, ânwa iwy Se Oliveira Eka enagozehodâ, toenzepa kurâ domodo nhapygueni modo. Toenzepa tuomarumogue, tygâky nhagulymo, Jesus anhetyby tientomobyry wâgâ: — Ton-honreim awâkâ Deus! Koendonro awâkâ! Tâense xina âdykâ âdaunlo uguondo anhetânry anhedyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aituo myani adaenkelymo: — Koendonrolâ awâkâ Kywymâry Jesus, Deus ingonotyby! Awâkâ wâgâ kurâ domodo koendâ itybyem Deus agâ. Koendonro awâkâ Deus kaynâ tâtyreim! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tâlâ lâpylâ myani kurâ domodo duay fariseu domodo ewy. Akaemo aguely tindatuo, Jesusram aguely: — Idakâ ampygueni modo saenlu, Konomedâni. “MYK alelâ itaungâ” kekâ eyanmo — kelymo Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aituo Jesus aguely: — MYK idylymo-ro watay, Deus tuhu itainhehonze, yrentomoem, iehoguedomoem warâ. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalém iwaguepa itybyem Jesus xidadâ nhesedyly. Târâ tâtyuneim modo eongüendyly myani, toenzepa tintyendylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Târâmolâ-ro waunlo ara kehoem eyanmo aguely: — Kaikâ âmaemo-kâ Jerusalém donro modo! Yeinwântuomo lelâ Deus imakelymo awyly, mâuntudyzemo wâne urâ. Mâuntuba olâ âmaemo! ");
INSERT INTO bkqNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mâsenagazedomo sainse. Âizepanromo modo âjidadârymo sahodâze. Ahodâduomo, onro, se satâwâdyby warâ muralha ipebaji idâtyguyzemo, tâkuhomoem, tâgawântomoem warâ. Tâinkâ lelâba ise sodadu modope awyly, âdaunlolâ judeu nâsemagueba itoem. Ânguydo imeom mydy oday tawâseim ara ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Âdyoze, itymo adakalagueoze warâ. Tuhu angatonro lâpeba ise. Âsenagazeze âmaemo, iweâ lelâlâ Deus imakedyzemo awyly mâuntudyzeba mawylymogue. Deus âwymârymoem idysebama keankâ âmaemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aituo myani Jesus egawândyly Deus ety idaseraji. Âdydo imeom vende ieni modo nhedyly. Deus etydâ aidylymo tientuo myani, Jesus nehoguebyra arâ aidylymo. Ânguydo imeom vende ieni modo nhegaseândaynly. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aituo eyanmo aguely: — Deus itaumbyry awo wâgâ iwenibyem: “Xirâ iety yagâ agueho xirâ” kewândymy Deus. Kurâ domodo mâenmagazedylymo kulâ olâ. Ânguydo imeom Deusram tiundulymo nhanâdylymo watay, toenzepa mâenwâentanâdylymo. Dinheru âmaemoenlâ mânhedylymo. Deus ety, tâmagazeim modo otoendoem mânhedylymo kulâ — kely myani Jesus. Ilâpyryem myani Deus ety odaypa egasely. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kopaelâgâembaba Jesus idâly Deus ety idaseraji, Deus wâgâ kurâ domodo enomedâze. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo, kurâ domodo iwymâry warâ Jesus tyândysemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Âdara adiendyly awyly nutubamo olâ. Tyanemo myani Jesus sawânehonze; kurâ domodo tyizepa idyly tyntadylymogue. Kurâ domodo mawânkâ myani Jesus aguely tohoguezemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kopaelâgâem myani Jesus Deus etydâ awyly. Tonlo modo myani nhenomedâguyly. Unâ koendonro nhegatuly âdara Deusram âzemakeolymo wâgâ. Târâ Jesus awyly ume, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo, judeu domodo iwymâry modo lâpylâ warâ âewylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aituo nhapâiguelymo: — Ânguyka tarâ Deus etydâ arâ amânhetyby amânhetoem agueim? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aituo Jesus in-hoguly: — Apâiguelymo lâpylâ ise. Uhoguwâdaungâ wao. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ânguyka ani João Batista, inakanhe adâitobyry wâgâ âjityendyby modo batiza nhetoem aguenri? Deuslâ? Âdaunlo uguondo kulâ? — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aituo myani âjigue aguelymo: — Iwerâ ise-ro? Âdara kuru ise kin-hoguly? “Deuslâ agueim” kykeduo, “Âdaituo pylâka João aguehobyry mâinwâmpyra mawylymo?” keze. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Uguondo kulâ ani João aitoem agueim, Deus mâkeba” kykeduo, taunlo modo kagâ iewiâpadaynze. “Deuslâ, João Batista igononi” tâkezemo inanry. Aituo ise tuhugue tamytâze kyâlymo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Awylygue warâ in-hogulymo: — Xina nutuwâbyra, João batiza nhetoem ânguy agueim awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","— Arâ atayma auguepa lâpylâ ise urâ, ânguy xirâ agânhetoem ugononi awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ilâpyryem myani Jesus tonlo modo enomedâze unâ nhegatuly. — Tâlâ myani uguondo uva etâdybybeom. Uva ejidy etaynrim modope iemâmy. Warâ myani eyanmo aguely: “Ypi mâendylymo-ro watay, uva xutuduo, epajigâze urâ agâmo” kely. Koendâ lelâ myani in-hogulymo. Aituo myani idânârâ âtunâguedybyem, âtâ anary iwaguenonra idâly. Iweâpa myani târâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","— Uva ekaunâdo odaji ituo myani tâmary ingonodyly akaemo tâwaneim modoram, nhekaunâdybymo ewy turâ emakeze. Uva ewily ekaunâni modo mâkâ ingonotyby saintuo, nhawâdylymo, nhapiogulymo alelâ. Âdy nudupamo âpa ezary sodoram nhatoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Saguho âdy peba odopâduo myani eagonro tâmary ingonotondyly. Uva ewily ekaunâni modo olâ nhawâdylymo, nhapiogulymo, kywypadoem kulâ anhedylymo. Âdy nudupamo lâpylâ âpa ezary sodoram nhatoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aituo myani eagonro ingonodyly wâne. Uva ewily ekaunâni modo olâ nhawâdylymo. Nhapiogulymo lâpylâ. Sapiogunrimbyryem, ingonodylymo. Âdy nudupamolâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","— Aituo uva sodo âpaunzedyly, aguely: “Iwerâ ise-ro? Âdaraka ise awidyly? Ah, xutuagui. Ymery tokaleom kâinwyneguyly ise kâingonokyly. Ypi etaynrim modo âda nientaymbamo ise” kely. Aituo tymery tokaleom ingonodyly myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","— Sodo imery saindyly umelâ myani âpa ezay tâwanuneim modo nhedyly. Âjigue aguelymo: “Uva sodo imery mâkâ âeni. Tunwym igueduo, mâkâ ise ipibyry sodo. Kydyânrene, nhunwym ipibyry kurâenlâ itoem” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","— Aituo myani mâkâ uva ejidy sodo imery nhawâdylymo, âpa ezayba nhedylymo, tyân-hoem — kely Jesus. Aituo myani Jesus adâkely idani modo nhapâiguely: — Âdyka ise mâkâ uva ejidy sodo akaemo âpa ezano modoem anhekyly? ");
INSERT INTO bkqNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Agueze urâ âyanmo. Todopâduo, uguondo modo xyâwâse mâkâ uva sodo. Ilâpyryem ise etaybyano modo nhuinly uva ejidy eni — kely Jesus. Aituo aguelymo: — Arâne Deus anienehomba nidâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus koendâ kehoem akaemo nhedyly. Agueondyly: — Warâ Deus itaumbyry awo wâgâ aguely: “Tâlâ myani tuhu imeâgâkeba, âtâ itâdo. Idânârâ itâdaynrim modo mârâ tuhu tâensemo, mârâgue âtâ tintâdyzebamo olâ. Deus xurâem olâ mârâ tuhu tywyneim kuru!” warâ iwenibyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","— Ânguylâ mârâ tuhu onwa ihugueyby, âdyâze. Ânguy onwalâ mârâ tuhu ihugueduo, samiunze — kely myani Jesus. {Mâkâ uva sodo imery emyenro, tuhu âtâ itâni modo izepa atobyry emyenro warâ awâkâ Jesus.} ");
INSERT INTO bkqNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Moisés inweniby enomedâni modo iwymârydo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo warâ awârâ unâ Jesus nhegatuly indadylymo myani. Ilâ tindatuo, toenzepa kehoem iewiâpadylymo, tyanlâ Jesus aguely awyly tiuntuduomo. Jesus agâ tyewiâsemo wâne myani, nawânehombamo olâ, “Kianwânehonly iwerâ watay, kurâdo kagâ iewiâpaze” tâkeduomo, âdaunlo kurâ domodolâ mawânkâ Jesus izetonro awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aituo Jesus anhekyly, agueho warâ nhenuagaendylymo, pymâ Pilatos enanaym tienwentâdomoem. Uguondo modo ingâsedylymo. Eyanmo aguelymo: — Jesus agâ aguewâtaunda. Sapâiguewâdaunda. Mâuntudyze mawylymogue mapâiguelymo waunlo ara lelâne nidâ. Kâzewenkeba aguehoem kulâ ise mampâiguelymo kelymo. Agueduo ise kianwânehonly. Roma iwymâry induakeybyram ise kiunduen-honly. Awâkâ ise xyâen-hoin-ro warâ — kely myani pymâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Saintybyem, ingonotyby modo Jesusram aguelymo: — Pymâ, konokuni keba mawyly, tutuze xina. Deus ize ato wâgâ âkealâ xina mâenomedâdyly. Iozeno lelâ amygueho, ânguy izepa awyly umelâ. Pymâdo tynrenseim modo ize ato amânhetoem kulâ amygueho mâungukewâbyra âmâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Awylygue âdara impostu wâgâ mâuntuly wao xinaram aguekâ. Moisés inweniby ara, koendâ pymâ Roma donro César-ram impostu epywadyly? Koendâpa? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tâwentâdomoem kulâ tapâiguelymo awyly, tutuze olâ myani Jesus. Aituo myani aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","— Moeda enetaungâ — kely. Moeda nhadylymo. Jesusram adapâigueolymo myani: — Ânguy emydy ekudoka xirâ wogonro? Ânguy ezedy iwâgâ iweniby warâ? — kely. Aituo in-hogulymo: — Roma donro kywymâry César emydy, ezedy warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesus aguely: — César xurâ, Cesaranlâ xuduwâtaungâ. Deus xurâ, Deusranlâ xuduwâtaungâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesus tienokudyzedo modo âda tiendyly nutuba idylymo, tâzenanaym tienwentâguedoem anienehomba tawylygue. Tonomegue kehoem in-hoguly awyly tiuntuduo myani akaemo âdakepa idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduceu domodo ewy Jesus agâ âtunâgueze idâlymo myani. Judeu domodo ewy akaemo. Iguewâtyby modo kurâem itondyly einwântânry ani akaemo. Jesus iopaji saindylymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Aguelymo: — Idakâ, Pymâ. Moisés ezewenry tutuzelâ âmâ iweâpa kydamudoram inweniby: “Uguondo tywydy namypalâ iguely-ro watay, iukonobyrylâ nohogüim iwydypyry agâ, imezeândoem. Aituo, iamudo iazeypy, igueypy imeryenlâ âdutuoly” kelype. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Xina olâ ise warâ nhegatuly. Tâlâ myakâwâm sete uguondo modo âjiwaigoruem, âjiukonoem waunlo. Iwaigoru ohogüinly myakâwâm. Tywydy namypalâ iguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iukonobyrylâ myakâwâm ohogüinrim pypâ agâ. Mâkâ lâpylâ myakâwâm tywaigoru iwydypyry namypalâ iguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Azagâ tokalâ ietomo iukono ohogüinly myakâwâm pypâ agâ. Mâkâ lâpylâ iguewâm, tywaigoru iwydypyry namypalâ. Tywaigoru iwydypyry namypalâ lâpylâ myakâwâm quatro ietomo, cinco ietomo, seis ietomo, sete ietomo warâ iguewâdylymo. Sete uguondo lelâ myakâwâm mâkâ pekodo agâ ohogüimby. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Idânârâ mâkâ uguondo modo iguewâpygueduo myakâwâm mâkâ pekodo iguely lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","— Xirâ xina apâiguedyze ato. Âkealâ kuru igueypy kurâem itondyly-ro watay, âdaunlo uguondo akaemo sete ewy iwydyenka ise mâkâ, kurâem itonduomo? Idânârâ akaemo sete lelâ iwydyem ityby mawânkâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus in-hoguly: — Iozepa kulâ âunâgumo. Xirâ anaym kulâ uguondo, pekodo warâ ohogüinly. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Igueduomo olâ ohogüin-homobyry tâtygagueze. Târâ Deus ezaylâ ise tagâ iniem Deus nhutuyby modo. Tarâ onro anaym ohogüimby modo, târâ nohogüin-ondaymbamo ise. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iguewâtyby modo kurâem itonze lelâlâ, nigueompyra tâitomoem. Anju domodo nohogüinwâbyra. Alâpylâ iguewâtyby modo, kurâem itonduo, nohogüin-ondaymbamo ise. Tymeombyry ara lelâ ise Deus nhedylymo, mâkâlâ kurâem ietonimo awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","— Iozeno kuru iguewâtyby modo kurâem itondyly kely mâintaimbaka minasemo? Enanâguewâdaungâ Moisés inweniby igueypyem kurâem tâjitondyly wâgâ, se imeimbyry niadupalâ tyatygueindâ Deus aguehobyry: “Deus urâ, Abraão, Isaque, Jacó warâ iDeusry; tarâlâ akaemo ywâgâ” kewândymy Moisésram. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Arâ aguehobyry wâgâ Deus einwântaynrim modo nigueompyra awyly kiuntuly. Kurâdo enanaji olâ Deus einwânni iguewâtyby modo iguewâtybyem lelâlâ. Deus xurâem olâ akaemo igueypyemba, târâlâ akaemo Deus eydâ atodâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aituo myani Moisés inweniby wâgâ enomedâni modo ewy aguely: — Koendâ mihoguagui, Konomedâni — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aituo saduceu domodo MYK idylymo. Âdy napâigueombyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Deus Ingonotyby Messias wâgâ âpaunzedylymo myani Jesus ize ato. Awylygue warâ aguely: — Moisés inweniby enomedâni modo, “Uguondo kulâ Messias, Davi iwerypyry tarâ onro anaym kulâ ise pymâem awyly” kelymo. Âyanmo auguely olâ, âkealâ awyly mâuntuhomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","— Tutuzelâ myakâwândy Davi, âdaunlolâ kurâ takaze kehoem ton-honreim Messias awyly. Messias wâgâ Davi tywenize myakâwândy pape Salmos wâgâ: “Deus aguely myakâwâm Ywymâryram: ‘Yahoru eynynâ ikagâ tynrenseim ekadodâ, ");
INSERT INTO bkqNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","âduery modo eon-honru kainly ara, âdydo ara kulâ âhuru iaxi kânhedylymo ara’ kewândymy Deus” kely myakâwândy Davi. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davilâ myakâwândy Messias tywymâryem awyly agueim. Awylygue kiuntuly âdaunlo kulâ uguondo keba awyly. Messias tynrenseim kuru awyly xutuwâdaungâ, Davi takaze — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aituo myani kurâdo indatoem, Jesus aguely tynynonro modoram: ");
INSERT INTO bkqNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","— Tonomeguelâ itaungâ, Moisés inweniby wâgâ enomedâni modo aito ara amipyra mitomoem. Koendonro aramo wâne, koendonro kebamo olâ. Earamopa itaungâ. Kurâ domodoram tâzehogueoly kulâ izetonro. BOH waunlogue lelâ etyunmo, Deus eynynonroem tawyly tienehon-homoem. Âdykâlâ kurâdo âtâdyguyho einkâ takaduomo, mâkâ modo tâdaenkudyzemo, tynrendysemo warâ inanry. Âtâ tâdâtâdyguyho odaji tâtâduomo, tâgareim ekado wâgâ lelâ ekadylymo, arâ lâpylâ âty mododâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pekodo pypâ modoram aguelymo inanry: “Xinalâ ise âsejiguymo eni, tusonebama âmaemo” kelymo. Isejiguymo turâem tientomoem kulâ nhenokudylymo. Deus agâ adâkedaymo, imeâgâemba kehoem aguelymo, koendâ tâgaromoem kulâ. Awylygue ise Deus nhenagazedylymo, eagonrodo takaze kehoem — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus myani Deus ety idaseray, kurâdo enuagaenze. Tokalâ, tokalâ warâ dinheru kaixa odaji ieni modo myani nhenuagaendyly. Toenzepa tydinherugueim modo toenzepa dinheru nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pypâ âdy pebanro kaixa odaji azagâ moeda imeimbyry, tâwâensenry nhetadâdyly emâmy lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Awârâ tientuo myani Jesus aguely: — Deus xurâem olâ mâkâ pypâ nhetadâdyby tâwâenseim kuru, akaemo âdypeom modo nhetadâdyby takaze. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Dinheru âsegubydâdyby akaemo nhuduly. Mâkâ olâ idânârâ tâlâ tato ara nuduaki, typyniry tianâto alelâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kurâ domodo ewy aguelymo myani Deus ety wâgâ: — Iwâkuru kehoem Deus ety! Iwâkuru kehoem tuhu imâsedo âtâ itâdobyry! Iwâkuru kehoem ekudyby modo, tuhu imeimbyry tâwâenseim kehoem iwâkudâdoem kurâ domodo nhuduypy warâ! — kelymo. Aituo myani Jesus aguely: ");
INSERT INTO bkqNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","— Arâ wâne, âdykonlo umelâ olâ ise awârâ mâenkylymo adakalagueoly. Idânârâ adakalagueoze lelâlâ. Angato inkâba ise awârâ tuhu modo; ihuguewâze awârâ onro onwa — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesus aguehobyry tindatuomo myani tonlo modo nhapâiguelymo: — Âdara kaise xypyry iwaguepa idyly, xina nhutuly? Âdy kaise tâenseim Deus ety adakalagueoho odaji itybyem awyly xutuhoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aituo myani Jesus in-hoguly: — Inanaynmolâ itaungâ, kodopâdo wâgâ ânguy inokubyramo itoem. Xypyry etaji idyly ume, toenzepa ise “Messias urâ, Deus Ingonotyby” kewâni modo, “Messias naintai” kewâni modo warâ. Kâzeinwântaundâ olâ! Kâjiampyguedaundâmo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tâinkâ lelâba âseguebylymo, âdyâwâdylymo warâ kely idase âmaemo. Tywymâry agâ kurâdo âseguebyly kely idase âmaemo warâ. Tadahulizeba olâ itaungâ, awârâ modo egary mâindadylymogue. Aise lelâlâ awârâ modo, âdypydâdo keba olâ ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","— Âkelo anano modo âdyâwâsemo, âjitanwebaom modo âdyâwâsemo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tâinkâ lelâba ise onro âzekânily. Tâinkâ lelâba pyni peba ise. Toenzepa ise tâwânuneim modo tâzewânu inakaigue mâkâ onwa, mâkâ onwa inigue ewânu. Âdydo imeom inakai modo kulâ ise aini. Kau wâgâ esemo âdypydâdo iwague kuruba awyly xutuho. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","— Tonomeguelâ itaungâ. Awârâ modo aidyly iraynâ yizepanro modo inagazezemo yeinwândylymogue. Adahoze âmaemo âtâ tâdâtâdyguyho iwymâry modoram. Kadeia odaxi âiehoze âmaemo. Yeinwândylymogue, pymâ domodoram adahoze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Enadomo mataymo, tâwâlâ ise amyguelymo âdara imakehomobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tadahulizeba olâ itaungâ amyguehomo wâgâ, pymâ domodo enadoram madaholymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Urâlâ ise amyguehomo xudunri mâsemaguehomoem. Amyguelymo tindatuo, âizepaom modo âkealâ amyguelymo xutuzemo. Âdakeontaymbamo ise âyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","— Âpemugudomolâ ise yeinwâmpyra tawylymogue igamenrimo yizepanro modo emaxi. Unwânmolâ, âwaigorumolâ, âukonomolâ, âpemugudomolâ, ataen-homolâ warâ ise inwentâguenimo pymâ domodo enanaym. Âmaemo ewy xyâen-honze pymâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ynynonroem mawylymogue, toenzepa ise mâjiewiâseolymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mâsenagazedylymo ume, âiguelymo ume, warâ olâ, “Deus ienanânehoangui” tâkezeba itaungâ. Idânârâ Deus emaynlâ ise âmaemo, angahudumolâ âda tyetuneba ise. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yeinwândyly kâjimowâdaundâ! Yeinwândyly mâinmopa âmaemo-ro watay, Deus imakezemo lelâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aituo Jesus aguely: — Sodadu domodoram âduahuoybyem Jerusalém mâendylymo-ro watay, inepa ise adainholy awyly mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jerusalém adainholy xutuho saintuo, Judéia donro modo iwyram nâwiendâmo, otoenze. Jerusalém oday tâtyuneim modo inepa negasemo. Poji anano modo xidadâram nâwâmpyramo nidâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Yeinwântânry modo toenzepa enagazeze urâ, tâdâsenagazedo ume” kewândy Deus tytaumbyry awo iweniby wâgâ. Aituo ise xirâ ume Deus eynynonro keba modo toenzepa âsenagazedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Toenzepa âsenagazeze pekodo modo ioday tymegueim, tuhuazeim modo warâ. Tahule âwienniembamo mawânkâ ise. Kurâdo taunlo Jerusalém donro modo toenzepa âsenagazeze. Toenzepa ise Deus eagâmo iewiâky. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tâdâseguebyday âdyorim modope ise. Tâlâ ise âzetadâoze taseim eagonro âtâ anaxi. Israelita domodo keba ise Jerusalémdâ xutuim, arâ aitomo âwanikeho ara — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Aituo Jesus aguely: — Xixi, nunâ, ximukâ warâ ise xypyry etay awyly xutuen-hoim. Tâinkâ lelâba kurâdo âdara tidyly nutuba ise, âseanezemo mawânkâ. Ton-honre kehoem ise parutabâ sahugânu. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tâinkâ lelâba ekomadaynzemo tyanumogue, âdaituo aidyly awyly tiuntuduomo. Idânârâ kaynâ tyngataymby modo ejikehonze Deus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aituo ise kâepanâguely urâ Uguondo Kaynâpa Âetyby. Eunu duay ise ytâguyly. Pymâem lelâlâ wawyly; toenzepa won-honru enehonze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Awârâ modo aidyly adaguly-ro watay, tytywanzeba itaungâ, âzeon-hondâdaungâ lakuru. Tuomare lelâ itaungâ. Inepama ise kodopâdyly imakezemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aituo Jesus aguely enomedâzemo: — Se sawanku mâendylymoenlâ mâuntulymo âdy iume idyly awyly, kopâ ume atay, âdâpigu ume atay warâ. Figueira sary wâgâ atay, se modo sawanku wâgâ atay warâ mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sary ilusewâdyly mâentuomo, iwaguepa kopâ ihugueho awyly tutuze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Myara lâpylâ ise xirâ auguehobyry modo aidyly adaguly mâentuomo, mâuntulymo. Deus on-hondybyem awyly, mâkâlâ pymâ kuru tawyly tienehon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Aise xirâ âdydo imeom, idânârâ xirâ onro anano modo iguelymo iraynâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kau, onro warâ adainze. Auguehobyry olâ ise nadaimpa, nâtugugueba warâ; aunloenlâ ise. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aituo Jesus aguely: — Inanaynmolâ itaungâ. Âtydâ lelâ waypa itaungâ. Adakuize kulâ waypa itaungâ, okumo ikaji mipyra mitomoem. Pyni wâgâ tâtynanâzeba itaungâ, itymo owogonromo wâgâ, kopaelâgâembaba iwanumo wâgâ warâ. Awârâ modo wâgâ kulâ mâtynanâdylymo-ro watay, awârâ kulâ ise angahumo odano, yaindyly mâkeba. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ânguydo imeom mydy onwa ihugueduo adapâendyly ara, ise âdykâingâlâ adapâendylymo kodopâduo, ywânwâmpyra tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Awylygue, yaindyly tânuenzelâ itaungâ, uguely. Deus agâ amyguepa tâiseba itaungâ. On-honrumo ekadaungâ tâdâsenagazedyly mâenmaen-homoem. “Warâ ise agâmo aidylymo” keze kurâdoram, ienado ton-honre mitomoem ekadaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kopaelâgâembaba myani Jesus kurâdo nhenomedâdyly Deus ety idaseray. Kopae olâ idâly iwy imeimbyry, Se Oliveira Ekaram xykyze. ");
INSERT INTO bkqNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Emedyly wâgâ myani kurâ domodo idâly Deus etyram, Jesus aguely idase. Târâlâ myani toenzepa kehoem kurâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iwaguepa myani judeu domodo etyry saintoem Pão Ioliho Pebaom etyguedoem. Páscoa kelygue tâzekeim lâpylâ myani mârâ âty. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby wâgâ enomedâni modo warâ âjigue âtunâguedylymo myani âdara Jesus xyâly wâgâ. Akaemolâ âdara Jesus tyâen-honly wâgâ agueim, kurâ domodo nhutudyzebamo olâ myani, tagâ iewiâpadylymo tyntadylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aituo myani Satanás, Judas xidadâ Queriote donro, Jesus eynynonro, nhangahu odaji xunâry inakanhe nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo agâ, guarda iwymâry modo agâ warâ Judas agueze idâly. Jesus tiengamehoem âseinwândyly eagâmo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Judas agueduo myani, toenzepa kehoem iomazelymo. — Xina emaxi Jesus mâengamely-ro watay, ipywaze xina — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","— Inepa ise kâengamely — kely myani Judas. Eagâmo agueypyenlâ myani Judas, âdara Jesus tiengamely awyly nhugudyly, kurâdo nutubalâ Jesus tiengamehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Judeu domodo pão ioliho pebaom nhedawyn-homo, kordeiru nhâhomo warâ, Páscoa saindyly, Egitodâba tydamudo âsemaguehobyry tienanâguehomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aituo myani Pedro, João warâram Jesus aguely: — Iwerâ kopae ise Páscoa kientyguedyly. Kypyniry, âji, kydâwinduato warâ nhonehonwâdaunda — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","— Aituo aguelymo: — Âdykâka ise xina anhenehondyze mawyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus in-hoguly: — Idâwâtaungâ xidadâ Jerusalémram. Myarâ aintuomo, uguondo âmugâ oday paru sani iose âmaemo. Idâwâtaungâ eagâ. Igawântaungâ egawântobyry âtâ odaji. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mârâ âtâ sodo agâ aguewâtaungâ: “Pymâ mawânkâ âty Páscoa tientyguedyze tarâ xirâ kopae. Âdykonlo âtâ sahomery oday kaise tynynonro modo agâ kordeiru nhunru nhâdyly, pão ioliho pebaom nhedawynly warâ?” kewâtaungâ âtâ sodoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eagâlâ ise mâkulymo, âtâ sahomery kaynonro odaji. Târâ ise sahomery imeâgâ keba nhenehonly. Tâlâ ise târâ mesa, tâzekado, idânârâ ize kydato modo. Târâ ise kypyniry amânhenehonlymo — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aituo myani azagâ uguondo idâly. Saindylymo xidadâram. Saintybyem myani Jesus aguehobyry ara lelâ nhedylymo. Mâkâ uguondo agâ oxiodylymo myani. Âtâ nhedylymo, pyni modo anhenehonlymo warâ, Páscoa tientyguedomoem. Pyni modo aienehonrimbyryem myani odopâdylymo Jesus eydâ atoam. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kopae tâdâwinduato odaji ituo myani Jesus idâly myarâ tynynonro modo agâ. Saintybyem myani ekadylymo âwinduase. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Aituo myani Jesus aguely: — Páscoa kâentyguedyly xypyrylâ ise xirâ tarâ onro anaym. Awylygue toenzepa agâmo kâwinduadyse wawyly, yiguely iraynâ. Xirâpyryem kâentyguedondyly ise, Deus tynynonro modo idânârâ târâ pymâem tatodâ nhemakeduo lelâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aituo myani Jesus kopu vinhugue taseim tâmaxi nhedyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ vinhu mâundulygue — kely. Aguenripyryem myani tynynonro modoram aguely: — Mâkâ, mâkâ warâ xirâ vinhu enywâdaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Páscoa kâentyguedondaymba ise urâ agâmo, vinhu kâenyombyra ise urâ warâ, Deus eynynonro modo myarâ pymâem atoram saindylymo ara. Xirâ mâuntudyzemo kuru wato — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ilâpyryem myani pão tâmaxi nhedyly. Deusram aguely: — Koendonro âmâ, Pabai, xirâ pão mâundulygue — kely. Agueypyem myani pão nhepajiwâdyly. Mâkânra, mâkânra warâ nhuduly, nhedawyn-homoem. Aituo myani eyanmo aguely: — Wodolâ xirâ. Iwaguepama âmaemoem yigueho. Xirâ pão mâendawynduomo, âmaemoem yiguehobyry enanâguewâdaungâne — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pão tiendawympygueduo myani Jesus kopu vinhugue taseim tâmaxi nhedyly. Aguely: — Unulâ xirâ. Tâunkeze ise yiguely imakezemo. “Ynynonro modo emakeze urâ” Deus kehobyry mawânrâ. Awylygue ise unu tyapâze yigueduo, iwelo tâdâsemaguehobe Deus nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Eagonro ise xirâ augueho. Tarâ yagâ ekadybyenlâ merâ iegamerim. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Igueze urâ. Urâ, Uguondo Kaynâpa Âetyby âdyoze urâ, Deus “Warâ ise” kehobyry ara. Toenzepa âsenagazeze olâ yizepaom modo emaxi iegamerimbyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Awârâ tindatuo myani eynynonro modo âjigue aguelymo: — Ânguy wânkâ ise konomedâni egamenri-ga? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ilâpygueduo myani Jesus eynynonro modo âjigue aguelymo: — Ânguyka kurâpyry enday, kurâ domodo enanaji, tynrenseim kuru? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aituo myani Jesus aguely: — Idânârâ pymâ domodo tâdyren-honze lelâ, ton-honreim awylymogue, “Warâ aiekâ” kerim awylymogue warâ. Tâlâ lâpylâ olâ pymâdo koendonroem tawyly adâkehohoem kurâdo ewanirim tiemawyadâdoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Tynrenseim urâ” tâkezeba itaungâ. Tynrenseimbe âduanomo watay, tynrensenryenlâ nidâ. Mâkâ “Aietaungâ” keze ton-honreim âduaymo, aieni ara lâpylâ nidâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ânguyka tynrenseim kuru? Mesa onwa âwinduase ekadyby? Ipyniry mesa onwa ieni? Urâ olâ âdaunlo kurâ ara kulâ âduaymo wawyly, âmaemoem aise, urâem amitomoem inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","— Kâsenagazedyly ume wodokeba keankâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yeinwândyly mâinmopa mawylymogue ise on-honrumo kâunduen-honly pymâem mitomoem, Pabai won-hondâdâ pymâem witoem myara. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Deus agâ pymâem wawyly ume, târâ yagâlâ ise âmaemo. Âdaunlolâ pymâ eataen-ho modo wâne tâwinduase, tadakuize warâ eagâ myara lâpylâ ise mâwinduadylymo, madakuilymo warâ yagâ Pabai enado. Pymâem wituo, pymâem lâpylâ ise âmaemo. Pymâdo xurery wâgâ ise ikadylymo, kypemugudo israelita domodo iwymâryem mitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ilâpyryem myani Jesus aguely Simão Pedroram: — Yeinwândyly mâinmohomoem adiendyse Satanás, Simão. Pekodo trigu nhahogudyly ume, sary sapezenruram tadahoze, ewily koendonro olâ tâxiânze. Arâ lâpylâ ise, ynynonro modo âxiânly yeinwândylymogue. Ynynâbaom modo olâ iaduwâse. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Deusram on-honru nhuduhoem sekadâ, yeinwândyly mâinmopa mitoem, Pedro. “Jesus eynynonro keba urâ” keze âmâ. Inepa olâ ise yeinwântondyly. Yeinwântonduo, ataen-ho modo eon-hondâgâ, yeinwândyly nimopa itomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Agueduo myani Pedro aguely: — Âinwândyly kâinmowâbyra ise urâ, Pymâ! Agâ kadeia odaxi âzetadâoze, âdyoze warâ wâne urâ, odokeba olâ ise urâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus olâ myani warâ eyam aguely: — Auguely xirâ âyam, Pedro. Xirâ kopae, aukuma igâtudyly iraynâ, azagâ tokalâ warâ ise “Jesus kâuntuwâbyra urâ” myguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Xirâpygueduo myani Jesus tynynonro modo nhapâiguely: — Enanâguewâdaungâ Deus xunârybyry egatuze ogonotomobyry. “Dinheru, âsejiguy etary, âhurumo etary eagonro warâ kadataundâ” ugue âyanmo. Âdy peba midâmoka ilâem? — kely. — Âdy ipaom lâpeba keankâ. Idânârâ xina ize ato tâlâ keankâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aituo myani Jesus aguely: — Iwerâma, tywoietygue, dinherupe warâ mataymo, sataungâ. Espada mâsemaguehomo peba-ro watay, anâtaungâ. Espada sanâto peba-ro watay, âgamizarymo vende ietaungâ, manâtomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Idânârâ Deus itaumbyry awo wâgâ ywâgâ iwenihobyry ara kehoem ise aidyly: “Kyâim ara ise kâzeholy” warâ. Inepa ise arâ ayedylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aituo myani eynynonro modo aguely: — Azagâ espada tâdâsemaguehobe xina — kelymo. — Âdainkâba ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Warâ tynynonro modoram aguenripyryem myani Jesus xidadâ odaypa idâly. Kopae tâtâho aralâ myani idâly iwy imeimbyry Se Oliveira Ekaram, tynynonro modo agâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Myarâ saintybyem myani Jesus aguely tynynonro modoram: — Satanás inakanhe amidysemo. Âynanâduomo, Deus eon-honru ekadaungâ, Satanás ize ato ara amipyra mitomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ilâpyryem myani Jesus âxiguely iwague kubalâ eydâmopa, trinta metros awârâem. Târâ myani âzeguhoam idyly, Deus agâ adâkehoem: ");
INSERT INTO bkqNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","— Pabai, toenzepa kuru kâsenagazedyly warâ izepa wâne urâ. Ize wato araba olâ aidyse wawyly, ize mato aralâ — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aituo Deus anju ingonodyly eon-hondâze. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Toenzepa tytyrungue, Jesus aguezesedyly Deus agâ, ton-honre kehoem. Tadahulilygue myani tune kehoem ikobizely ihuguely onro onwa. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Deus agâ agueypyem myani saudyly. Akaemo tynynonro modo âxiân-homobyryam idâly. Toenzepa tytyrumogue xykylymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xykylymo tientuo myani âduagueân-honlymo. Aguely: — Tykyzeba itaungâ. Âwaguewâtaungâ. Deusram ekadaungâ, Satanás ize ato amânhepyra mitomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus aguely ume, Judas saindyly. Jesus eynynonrolâ kâinane mâkâ. Toenzepa myani kurâdo eagâ âewyly. Aituo Judas saindyly Jesus iopaji. Tadataen-ho modo agâ adâito ara iwaparydâ nhonugudyly tiendaenkuday. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Arâ aituo myani Jesus eyam aguely: — Judas, koendâ inkâba, urâ Uguondo Kaynâpa Âetyby ayedyly. Yataen-ho âmâ-ro waunlo ara lelâ wonugudyly, iegamehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eynynonro modo awârâ indadyly, aidyly nhedyly warâ myani. — Xirâ espadague ise kydâsemaguely, Pymâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aituo myani tokalâ akaemo ewy tydahoru ety odayba nhetyly. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru agâ tâwaneim iwantazagâmâmy. Tâzewyze myani mâkâ tâsemaguehoem. Aituo pylâ iwantary aho eynynonro nhatâly-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aituo myani Jesus eyam aguely: — Adâiseba ikâ! — kely. Aituo Jesus, uguondo iwantary satâhobyrydâ MÂʼ nhedyly. MÂʼ nhetuo, kua idyly lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ilâpyryem myani Jesus aguely kurâdo eynynâ Deus agâ aguewâni modo iwymârydoam, Deus etydâ guarda domodo iwymârydoam, Judeu domodo iwymârydo tawâse âetybyram warâ: — Espadague, segue warâ tâmase kehoem yawâse mâewylymo, tâmagazeim urâ-ro waunlo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yawâtomo tuduzelâ keankâ saguhoem, kyâho pebalâ. Kopaelâgâembaba keankâ Deus ety idaseray, agâmo agueze wawyly. Târâlâ yawâpyra olâ mataunaguynre. Yawâto odayba awylygue keankâ ilâenlâ yawâpyra mawylymo. Iweâma yawâtomo odaylâ. Iweâma Deus iduery ton-honreim ize tato anheto odaji itybyem. Iamu odano modo aito odaji itybyem iweâma-ro — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ilâpygueduo myani Jesus nhadylymo kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru etyram. Myarâ nhataymo myani iwaguelâ Pedro idâly âgânâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Saintybyem myani peto nhehobanâdylymo taseray. Âunse peto tânâmize ekadybyenmo myani. Pedro idâly myani. Eydâmo ekadyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pekodo târâ tâwaneim ewy Pedro nhedyly, peto opay âundyly ume. Koendâ kehoem enipyryem myani aguely: — Jesus eynynonro modo ewylâ awâkâ uguondo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","— Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ! — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ilâpygueduo uguondoram âzeholy, aguehonly lâpylâ: — Jesus eynynonro ewy âmâ — kely. Mâkâ aguely tindatuo, Pedro agueondyly: — Jesus eynynonro mâkeba urâ. Kâuntuwâbyra urâ awâkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tokalâ hora sakabygueduo myani eagonroram âzeholy, aguehonly lâpylâ: — Jesus eynynonrolâ âmâ! Tutuze xina, Galiléia donro mawyly, earamolâma amyguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aituo Pedro agueondyly: — Âdy wâgâ amyguely awyly kâuntuwâbyra urâ! Kâuntuwâbyra urâ awâkâ! — kely. Pedro aguely umelâ myani aukuma igâtudyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aituo myani Jesus MYK idyly Pedroam. Pedro MYK idyly lâpylâ Jesusram. Pedro âsenanâguely tyam aguehobyry wâgâ: “Auguely xirâ âyam, Simão. Xirâ kopae, aukuma igâtudyly iraynâ, azagâ tokalâ warâ ise ‘Jesus kâuntuwâbyra urâ’ myguely” Jesus kehobyry. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aguehobyry tienanâgueduo myani Pedro itynwandyly. Târâpa âxiguely. Tâjityenze kehoem eogumadyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Sodadu domodo Jesus âwankuem nhedylymo myani. Nhenuahulymo, nhapioguly idylymo. — Ânguyka apiogurim? Apiogurimbyry xutugâ, âkealâ kuru Deus Ingonotyby matay — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Toenzepa myani aguelymo eyam, tienagazedoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Emetuo myani Judeu iwymârydo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés ezewenry wâgâ enomedâni modo warâ âtâdyguylymo. Âjigue aguelymo myani. — Jesus kânado enenehonze kurâ — tâkehobyryem, anhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aguelymo: — Messiaslâka âmâ, Deus Ingonotybylâ? Xina kâzenokudâ! — kelymo. Aituo myani Jesus in-hoguly: — Âkealâ uguely-ro watay, yeinwântaymba ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Apâiguelymo-ro watay, “Deus Ingonotyby wawyly tâinwânse âmaemo?” uguely-ro watay, uhoguwâbyra ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Inepa ise urâ Uguondo Kaynâpa Âetyby Deus eydâ atoram udâly. Târâ ise tynrenseinhe wawyly. Mâkâ Ton-honreim kuru ahoru eynynâ ise ekadybyem wawyly. Târâ ise won-honru âzeholy — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aituo myani nhapâiguelymo: — Deus imeryka âmâ? — kelymo. — Mâkâlâ urâ, amyguehomo aralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Agueduo myani aguelymo: — Ânguy kingâsedondaymba ise kurâ, Jesus ewentâniem. “Deus imerylâ urâ” kelyma kyjidatai — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ilâpyryem myani idânârâ pymâ domodo âtâdyguywâdyby, sautaynlymo, tâtunâguedyly âwanikeybyem awylygue. Pilatosram nhaleholymo, pymâ Roma donro ingonotybyram. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Myarâ saintybyem myani Jesus ewentâdyly nhagulymo. Aguelymo: — Kywymâry Roma donro iewiâseni awâkâ uguondo. Kywymâry modo idueryem kurâdo tiendyse awâkâ. “Roma iwymâry César-ram impostu kâzepywadaundâ” nygue. “Messias urâ, Deus Ingonotyby” nygue lâpylâ. “Urâ ise âwymârymo kuru” nygue — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aituo myani Pilatos, Jesus nhapâiguely: — Judeu domodo iwymâry kuruka âmâ? — kely. Jesus in-hoguly: — Mâkâlâ urâ, amygueho ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aituo myani Pilatos aguely kurâdo eynynâ Deus agâ aguewâni modo iwymârydoram, kurâdo tonlo modoram warâ: — Urâem, âdy ewentâdo lâpeba merâ uguondo. Âdy wâgâ enagazedo lâpeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jesus izepaom modo olâ xunâguedyly nimopamo myani. — Tâinkâ lelâba inanry idâly kurâdo xuruse: “Pymâ Roma donro aguely kâjidataundâ” nygue. Judéia eynynâ adakobâdyly inanry. Galileiadâ ani Deus wâgâ aguely adaguly; iwerâ tarâ Jerusalémdâ — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jesus Galileiadâ aitobyry tindatuo, Pilatos nhapâiguely myani: — Galiléia donroka merâ uguondo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","— Tonlo awâkâ — kelymo. Galiléia donro Jesus awyly tiuntuduo myani Pilatos, Herodesram Jesus ingonodyly. Pilatos tutuze lâpylâ myani Herodes Jerusalémdâlâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesus egary tydaselâ myani Herodes. Iweâpa myani tiendyse awyly. Âkealâ kuru Jesus egary tiuntudyze. Awylygue âdylâ Deus eon-honrugue anhedyse awyly tientoem. Awylygue myani toenzepa iomazely, Jesus tânadoram satuo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aituo myani Herodes toenzepa Jesus nhapâiguely aitobyry wâgâ, aguehobyry wâgâ warâ. Jesus olâ nihoguba. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Moisés inweniby enomedâni modo warâ târâlâ lâpylâ myani. Toenzepa kehoem Jesus nhewentâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes, izodadury modolâ warâ Jesus âwankuem nhedylymo myani. Izepa tawylygue lelâlâ anhedylymo. Âwankuem tiendylymo umelâ myani iwâkuru kehoem âtâ pymâ ety emyenro nhonwa nhedylymo. Ilâpyryem myani Herodes nhopânehonly Pilatos enadoranlâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes, Pilatos warâ saguhoem âjizepaombyrymoem. Xirâ ume myani adataen-hoem idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ilâpygueduo myani Pilatos, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, judeu domodo iwymârydo, kurâ domodo warâ indâtyguyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aituo myani eyanmo aguely: — Merâ uguondo yam menetondaimo. “ ‘Pymâ domodo kâdytadaundâ’ kely kurâdoram” mygueansemo. Awârâ wâgâ sapâigueagui idânârâ inanaynmo. Ienanaji, mâenwentâdomoem inakanhe anipyra, aguepa warâ merâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes xurâem âdy inakanhe aitobyry lâpeba lâpylâ warâ. Awylygue yam ingonotondyly. Âdaityby mâkeba merâ uguondo iguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ewentâdo kâuntuba lelâlâ wâne urâ, alâ olâ kampiogüen-honly, omazeândomoem. Sapiogüen-honze urâ, imoen-honze urâ alelâ — kely Pilatos. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aunlolâ mykâinane Pilatos, Páscoa etyry ume etadâdyby modo ewy tokalâ nhetaguehonly, âdaunlolâ kurâdo nhekadybylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","“Kâinmoen-honly” Pilatos keduo myani idânârâ adaenkewâdylymo: — Kruz onwa sakâjien-hongâ awâkâ uguondo, iguehoem! — kelymo! — Barrabás xina mâentaguehondyze ato — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jerusalém donro modo, pymâ romano domodo agâ âseguebyby ewy myani mâkâ Barrabás. Kurâ domodo pymâ agâ iewiâpaday, uguondo modo tyâze myani. Awylygue myani kadeia odaxi âzetadâoly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatos myani Jesus timoen-hondyze. Awylygue myani agueondyly kurâdoram: — Jesus sapiogüen-honze, imoen-honze warâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Adaenkezezedylymo lakuru toenzepa kehoem: — Kruz wâgâ nigue! Kruz onwa sakâjien-hongâ, iguehoen-ro warâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aituo myani azagâ tokalâ warâ Pilatos aguely idyly: — Âdaituo? Ienanaji, âda nitaymba merâ iguehoem! Xikotygue sapiogüen-honze urâ. Ilâpyryem ise kâinmoen-honly-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Agueduo olâ myani kurâdo toenzepa adaenkeondylymo: — Kruz wâgâ nigue! Kruz onwa sakâjien-hongâ, iguehoem! — kezeselâ kurâ domodo. Nadaenkeba nipyramo. Toenzepa kehoem myani adaenkelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aituo myani Pilatos nhekadomobyry ara anhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sodadu domodoram aguely myani: — Kadeiaram idâwâtaungâ. Mâkâ Barrabás etaguewâdaunda, kyârimpyry, kurâdo, pymâ Roma donro izepa ienehonrimbyry. Ilâpyryem ise Jesus kruz onwa sakâjize mandylymo — kely Pilatos. Aituo myani Pilatos, judeu domodo iwymârydoram aguely: — Mâenkadybymo ara enra sodadu modoram agânhenehonly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aituo myani sodadu domodo Jesus nhawâdylymo, nhadylymo, kruz onwa sakâjize iguehoem. Ânwa oze tâtâdaymo myani uguondo Simão agâ oxiodylymo. Xidadâ Cirene donro myani mâkâ. Poji ananobyryem myani odopâdyly. Tiontuo myani sodadu domodo kruz Jesus tiankâjiho eyam nhanânehonlymo. — Xirâ kruz sakâ, Jesus nhapygue — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Toenzepa myani kurâ domodo nhapyguemo awyly, pekodo modo lâpylâ warâ. Toenzepa ohogüendylymo, igueho awyly tiuntuduomo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus MYK idyly pekodo modoram. Aituo eyanmo aguely: — Agâieholygue tohogüenzeba itaungâ, pekodo modo Jerusalémdâ tâtyruneim modo. Âwâgâmolâ, âmeombyrymo wâgâlâ warâ ohogüendaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Xidadâ oday tâtyuneim modo toenzepa ise âsenagazedaynlymo. Tâsenagazedylymogue ise pekodo imezedânry modoram aguelymo: “Koendâ ise âmaemo, âdykâ tymegueba mawylymogue, âdykâ âwanrymogue iamudo makuiba mawylymogue warâ” kezemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Toenzepa tâsenagazedylymogue iwyram wakezemo: “Âihuguegâ xina onwa, xina xyâze, tâsenagazedyly xina nepyra itoem” kezemo Jerusalém donro modo. “Xina epyâze âihuguegâ” kezemo iwy wogonro tuhu imâsedo modoram. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iwerâ, urâ âdykâ inakanhe aitânry kâsenagazedyly. Âmaemo inakanhe aitaynrim modo lakuru olâ ise toenzepa âsenagazeni. Wauguely: “Peto emanâdyby, peto iladânrygue kionguandyly watay, tyatyguzelâ peto iladybygue kionguatuoma kuru-ro!” — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Azagâ uguondo inakai aienibyry samâ lâpylâ sodadu domodo, kruz onwa tiankâjihomoem, Jesus agâ iguehomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Iwy Calvarioram myani saindylymo. Myarâ saintybyem Jesus nhakâjilymo kruz onwa. Azagâ kyârimpyry nhakâjilymo eagâ, tokalâ aho eynynâ, eagonro pâem eynynâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aituo Deus agâ Jesus aguely: — Pabai, awâkâ kurâdo kâzenagazedâ. Inakanhe aitomobyry xygakegâ. Âdara tâidyly nutuwâbyra asaemo — kely Jesus. Sakâjirimbyryem myani sodadu domodo Jesus ety iwogonropyry nhepajiwâdylymo mâkâem, mâkâem warâ. Dadu nhamelymo, ânguy, ânguy warâ Jesus ety iwogonropyry emakeim awyly tiuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Târâ aidyly esezezelâ myani kurâdo, tywymârymo Jesus âwankuem nhetay. Pymâdo eyam aguelymo myani: — Âkelo modo nemakewâdâ; tâwâlâ nâsemagueba olâ! Deus Ingonotyby tatay pylâ tâwâlâ nâsemague — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sodadu domodo âwankuem nhedyly, nheinledyly idylymo myani. Iopaji idâlymo. Aguelymo myani: — Anra vinhu mâenyhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","— Judeu domodo iwymâry kuru matay, kruz wâgâpa âytâguygâ, âiguepa mitoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesus merâ, judeu domodo iwymâry kuru kely iweniby sakâjiwânmomy Jesus nhangawaym kruz wâgâ. Mârâ iwenibyem awyly myani, gregu, romano, judeu warâ itanwe. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tokalâ inakanhe aityby ewy kruz wâgâ sakâjiby Jesusram aguely myani: — “Cristo urâ, Deus Ingonotyby” mygueanse. Kâinwâmpyra olâ urâ. Cristo matay pylâ, tâwâlâ âsemaguegâ. Kruz wâgâpa adakâjiguegâ, âytâguygâ warâ. Xina emakegâ lâpylâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aituo eagonro aguely: — Arâ adâkezeba ikâ. Deus mâynrentaymba âmâ! Azakâlâ awâkâ ara kydâsenagazedyly. Azakâlâ ise kyiguely, awâkâ ara lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kurâma âkealâ aguydâieholy-ro inakanhe itybyma kurâ. Âkealâ aguydâieholy. Awâkâ olâ âdaityby keba — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aituo Jesusram aguely: — Pymâem modopâduo, âinwânnipyryem wawyly enanâguegâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aituo myani Jesus in-hoguly: — Âkealâ xirâ âyam auguely. Kyiguely ise xirâ, Iwerâlâ olâ ise yagâ mydâly Deus eydâ atoram — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kuotatay myani xixi tohoreba idyly. Azagâ tokalâ warâ horas ara lelâ idânârâ iamataynly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Deus tynrenseim etydâ, Deus, kurâdo agâ tygue ito xuahuru iotagâ adauguely kaynonrobyryem, on-yam. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aituo myani Jesus adaenkely ago kehoem: — Pabai, imaxi iegadopyry kâengamely — kely myani. Agueypyem myani, iguely. Ipa idyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sodadu Roma donro modo iwymâry myani idânârâ aidyly eselâ. Aidyly tientuo myani aguely: — Koendonro keankâ merâ uguondo. Âda nitaymba keankâ merâ, xyâhoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Toenzepa myani kurâdo târâ awyly mârâ ese. Iguely enipyryem myani tâtyram odopâdylymo. Tâjihogainze myani idâlymo, tytyrumogue. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Idânârâ Jesus eataen-ho modo iwaguemolâ myani, pekodo modo lâpylâ, Jesus agâ Galileiadâbalâ âetaymby modo. Jesus kruz wâgâ nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tâlâ myani târâ Judeiadâ uguondo José; Arimatéia donro mâkâ, koendâ lelâ, Deus agueho ara lelâ aini warâ. Idânârâ kurâdo iwymâryem Deus idyly sainto tânuenze mykâinane. Judeu domodo iwymâry Sinédrio kelygue tâzekeim ewy myani. Tataen-ho modo, Jesus xyâen-honze keduomo, eagâmo nâseinwâmbyra myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aituo myani José, Pilatosram idâly agueze: — Jesus nigueaki, Pymâ. Kruz wâgâpa kâyntâguyândyze olâ urâ, tuhu imâsedo tâtagueim odaxi kâenkanâdoem. Tâwâlâ kâyntâguyândyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","— Tâwâlâ — Pilatos keduo, José idâly myani. Ilâpyryem myani José, Jesus eguepybyry kruz wâgâpa nhytâguyândyly. Xytâguyânibyryem, intuwynly âtâ linhugue. Ilâpygueduo, eguepybyry nhetadâdylymo tuhu imâsedo tâtagueim esagueyby odaji. Ânguy etarybyry keba myani mârâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sexta-feira oday myani Jesus iguely, tâzekobyzeguehoem todohondo iguandyly ume. Iguandylylâ myani âguedy myarâ nhetadâdomo, tâzekobyzegueho adagulylâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pekodo modo Jesus agâ Galileiadâpa âetaymby modo José nhapygue idâwânmo lâpylâmy. Âdykâ Jesus eguepybyry etadâdyly awyly emâmomy warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tiempygueduo myani tâtyram odopâdylymo. Tyânrânguneim modo, óleo tyânrângueim warâ nhondylymo, âguedy ituwyn-ho onwa, tiampâdomoem. Ohondybyem myani ekobyzeguelymo, judeu domodo ezewenryem mawânrâ tâzekobyzegueho oday ânguy nâsewaniba. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo pealâ myani pekodo modo Jesus eguepybyry etadâdobyryram idâlymo. Uriza tyânrângueim tiontaymby modo nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Saintybyem myani, tâtagueim enahun-ho tuhu imâsedo ejikeybyem awyly nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tâwânsemo myani tâtagueim odaxi. Âwântybyem myani Kywymâry Jesus eguepybyry târâpa awyly nhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Toenzepa myani âseguâdâdylymo. Iwaunkymo ume myani azagâ uguondo âepanâguely eyanmo, tohozeleingue kehoem tâtyeim. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pekodo modo âseanedyly myani; toenzepa lelâlâ myani âseanedylymo. Tyanumogue uguondoram MYK nipyramo myani, enagozeybymoem lelâ. Aituo myani uguondo modo aguely: — Kurâem itondyby kâduiwâtaundâ iguewâtyby modo ejidydâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Tarâ inkâba mâkâ. Ipa, kurâem nitondai. Saguhoem Galileiadâ agâmo tatay aguehobyry enanâguewâdaungâ: “Urâ Uguondo Kaynâpa Âetyby tumunreim modo emaxi âzegameoze urâ. Iemakâjizemo, ienagazezemo. Yakâjizemo kruz onwa, yiguehoem. Igueze urâ. Azagâ emedyly idyly wâgâ olâ ise kurâem witondyly” kehobyry — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aguehobyry nhenanâguely myani pekodo modo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tâtagueim odayba egaselymo. Odopâdylymo. Saintybyem myani akaemo onze lelâ Jesus eynynonro modoram, kurâ domodoram warâ nhegatulymo, idânârâ tientybymo ara. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Asaemo: Maria (Magdala donro), Joana, Maria (Tiago ise), eagonro pekodo modo warâ myani Jesus eguepybyry etadâdobyryram idâypy. Tientybymo ara, tindatybymo ara warâ myani akaemo nhegatulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pekodo modo aguely indadylymo. Neinwâmpyramo olâ myani, kewâdylymo kulâ waunlo ara awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro olâ myani saudyly. Tâgase kehoem idâly Jesus eguepybyry etadâdobyryram. Saindyly. Koendâ târâ tientoem âzewyly. Ituwyn-hobyry lelâ nhekyly. Aituo myani tâpaunzeze odopâdyly tâtyam. — Iwerâ ise-ro? Âdaituo kuruka arâ aidyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pekodo modo, “Jesus kurâem nitondai” kehobyry iguandyly ume myani azagâ uguondo Jesus nhapyguenibyry modo tuhuru wâgâ idâlymo Emaúsram. Dez kilômetros awârâem Jerusalémdâpa awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Idânârâ Jesus agâ aitaymby modo wâgâ, pekodo modo nhegatuyby wâgâ warâ xunâgumo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Awârâ wâgâ tunâgue idâlymo ume myani Jesus saindyly iopajimo. Eagâmo idâly myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nhedylymo wâne, mâkâem awyly nutubamo olâ myani. Jesuslâ awyly nutubamo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aituo myani Jesus eyanmo aguely: — Âdyka ânwa oze âunâgomo? — kely. Uguondo tagâ aguely tindatuo myani epagudylymo, tytynre kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aituo myani Cleopas aguely: — Jerusalémdâ aitaymby modo wâgâ kulâ enra xina xunâgu. Âmâ kulelâ keanra xirâ modo wâgâ âdy xutudânry! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aituo myani Jesusram adapâigueolymo: — Âdyka amyguehomo? — kely. In-hogulymo: — Jesus Nazaré donro aietobyry wâgâ enra xina aguely. Deus eynynâ agueim keankâ mâkâ. Uguondo anhetânry aieni keankâ mâkâ, Deus anhekyly aieni warâ. Koendâ keankâ Deus wâgâ kurâdo nhenomedâdyly. Deus, kurâ domodo alelâ keankâ nhomazeânguyly, adienkylygue, adâkehogue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kywymâry modo olâ keankâ izepa. Awylygue keankâ kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, eagonro pymâ modo warâ nhegamelymo pymâ Romadâpa ingonotyby emaxi. Pymâ Roma donro induakeyby nakâjien-ho kruz wâgâ iguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mâkâlâ wâne keankâ xina israelita domodo tânagazeni modo emaymba tâmakeinhe nhutuly. Kopaelâgâbygueduo olâ keankâ iguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","— Toenzepa olâ iwerâ xina âseguâdâdyly, unâ âkelo tindatobyry wâgâ. Iwerâ pealâ pekodo modo nâtyagui Jesus eguepybyry etadâdobyryram. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","“Eguepybyry târâpa” keanrymo olâ-ro warâ. Nodopâdaimo. “Anju kaynonro nâepanâgueagui târâ. Xina agâ agueakimo” keanrymo. “Jesus kurâem nitondai” keanrymo xinaram warâ. Warâ enra pekodo modo xinaram nhegatuly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Awârâ tindapygueduo, eynynonrobyry ewy nâtyagui Jesus eguepybyry etadâdobyryram. Koendâ kuru pekodo modo aguehobyry ese. “Ipa târâ eguepybyry” keanrymo olâ — kely Cleopas. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aituo myani Jesus aguely eyanmo: — Tahule âdy einwânni kebalâ mataunaze! Saguho Deus itaumbyry egatuwânibyry modo aguehobyry mâinwândylymo-ro watay, akaemo pekodo modo aguehobyry tâinwânse tâise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“Âsenagazedyly, iguely warâ ise Deus Ingonotyby” tâkeze myakâwâm saguho modo Deus itaumbyry egatuwâni modo. “Kurâem itonze warâ. Deus enado ise xynru, Deus tagâ eon-honru âzekiba ienehonze” tâkezemo myakâwâm — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Idânârâ tywâgâ, Deus itaumbyry awo wâgâ inweniby koendâ kehoem nhegatuly myani. Moisés, Deus eynynâ aguewâtyby modo lâpylâ warâ, tywâgâ inwenibymo, koendâ kehoem nhegatuly myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús iwaguepa saindylymo myani. Jesus sakadyly lelâ waunlo ara enanajimo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aituo myani idâdysebamo aguelymo: — Xina agâlâ ikâ; kogonekâ awârâ, iguandyly ise — kelymo. Aituo myani Jesus mâkâ azagâ tagonropyry agâ etymo odaji egawândyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Âwinduase ekadylymo myani. Jesus pão nhanâdyly. Deus agâ aguely myani: — Tuomare xina, pão mâunduhobyry wâgâ, Pabai — kely. Deus agâ agueypyem myani pão nhepajiwâdyly; mâkânra, mâkânra warâ nhuduly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pão nhuduly ume kulâ myani mâkâ uguondo Jesuslâ awyly nhutulymo. Akaemo tutuduo myani âtygaguely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aituo myani akaemo azagâ aguelymo: — Ânwa oze kydatay, Deus itaumbyry agueduo toenzepa kuomazeaguilâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aituo myani saudylymo inepa kehoem. Jerusalémram odopâdylymo. Saintybyem myani idâlymo Onze lelâ Jesus eynynonrobyry modo, kurâdo Jesus einwânni modo warâ âtâdyguyhobyryam. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Akaemo azagâ saintybynra aguelymo myani: — Kywymâry kurâem nitondai lelâlâmy! Igueypyem inkâba. Kurâem nitondaimy! Simão netai — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","— Tutuzelâ xina! Xina netai lâpylâ! Xina Emaúsram idâday, uguondo nâepanâgueagui. Xina agâ Emaúsram nâtyagui warâ. Kywymâryem awyly xina nutuagui, pão nhepajiwâday — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nhegatudaymo myani Jesus âepanâguely eyanmo. — Koendâ lelâ âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tientuo myani adapâendylymo, âseanedylymo warâ. Jesus egadopyry kulâ waunlo ara enanajimo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesus olâ myani eyanmo aguely: — Tâseanezeba itaungâ. “Jesus egadopyry awâkâ” tâkewâzeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Urâlâ urâ! Etaungâ iemary, uhuru warâ. MÂʼ ietaungâ, kadopâemba wawyly mâetomoem, kurâem wawyly mâinwântomoem warâ. Igueypy egadopyry mawânkâ tunrempa, tybyguepa warâ xara ietomo ara — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Agueypyem myani tâmary, tuhuru warâ nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mâkâlâ kuru awyly neinwâmpyramolâ. Takalaguemolâ warâmo wâne myani, toenzepa olâ iomarumo, ekuâgumo lâpylâ warâ. Aituo myani Jesus eyanmo aguely: — Âdylâ tâinzeimpe tarâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kanra âjihuyby epajigâdyby nhudulymo. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Enanaynmolâ kanra âjihuyby nhâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tâwinduapygueduo myani Jesus aguely: — Yiguely iraynâ agâmo watay, âyanmo augue. “Deus itaumbyry awo wâgâ Moisés ywâgâ inweniby ara ise awidyly. Deus unâry egatuwânibyry modo ywâgâ aguehobyry ara ise awidyly. Deus xurâem tygâtuneim modo ywâgâ inweniby ara ise awidyly” ugue wâne-ro — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Warâ Deus aguehobyry nhutuen-honly; nhangahumo odaji nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aguely: — Warâ inwenibyem awyly: “Deus Ingonotyby âsenagazeze, igueze warâ. Azagâ emedyly idyly wâgâ olâ ise kurâem itondyly” kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Tâinkâ lelâba ise einwânni modo xunârybyry egatuze idâly. Aguezemo: ‘Inakanhe kulâ amidylymo wâgâ âjityendaungâ. Deus izepa ato aiedyly imowâdaungâ. Arâ ise Deus inakanhe mitomobyry nhygakely, Ingonotyby tâinwânse mawylymogue’ kezemo. Jerusalémdâ ise nhegatulymo adaguly, ilâpyryem ise tâinkâ lelâba-ro warâ” warâ inwenibyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Âmaemo awidyly enipyry modo, auguely idanipyry modo warâ, aituo xirâ modogue kurâ domodoram aguewâtaunda. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Yspiritury igonose urâ” nygue Deus. Urâlâ ise Deus “Igonose urâ” kehobyry igononi. Deus eydâpa ise ywâgâ amyguehomoem on-honrumo eneni âewyly. Saindyly ara tarâ xidadâdâlâ itaungâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aituo myani Betanianra idâlymo Jesus agâ. Târâ tâmary IUK ienipyryem aguely myani: — Pabai, eagâmolâne ikâ, âda kâienehomo warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Adâkely umelâ myani Jesus eydâmopa âxiguely. Eydâ tatoram Deus nhalokuândyly. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Awârâ modo tindatuo, tientuo warâ myani aguelymo: — Koendonro mâkâ Jesus! Deuslâ mâkâ! Ânguy mâkâ emyenro lâpeba! — kelymo, tiynrentomoem. Ilâpygueduo myani tuomamune odopâdaynlymo Jerusalémram. ");
INSERT INTO bkqNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kopaelâgâembaba myani idâlymo Deus etyram. Târâ Deus koendonroem awyly wâgâ aguelymo, igâkymo iwâgâ warâ. Alâ kulâ. Lucass");
INSERT INTO bkqNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Idânârâ âtugudyly iraynâ, âdy peba awyly ume, tâlâ myakâwândy kyam Deus Xutuen-hoim. Tunwym Deus agâlâ myakâwândy mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Idânârâ nhugudyly iraynâ, Deus Xutuen-hoim Deus agâlâ myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Deus Xutuen-hoinlâ, idânârâ tâlânro modo adâkelygue kulâ xugunehonri. Mâkâ aguepa watay, âdy peba, ânguy peba warâ tâise. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Deus Xutuen-hoim mawânkâ xirâ anaym tâlâ kyenehonri. Mâkâ wâgâlâ ise Deus eydâ atoam kytâly, kieinwândylygue. Iajinu wâne kytâho kientoem ânwa tâsagonze, myara lâpylâ Deus wâgâ kiuntuhoem anhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iajinu emyenro mâkâ, inakanhe aguitobyry xutuen-hoim. Iamu, iajinu tohoreba nietaymba, arâ lâpylâ inakanhe tadawyly Deus wâgâ kiuntuly nianlâpyra awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jesus Deus wâgâ aguely adaguly iraynâ, Deus eagonro uguondo unâ egatuim igonomâmy, João Batistalâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iajinu oze kytâduo, âdyam kytâly awyly tutuze kurâ, arâ lâpylâ Jesus âdara Deusram kaindyly awyly nhutuen-honly. Jesus wâgâ agueze myani João âewyly. Idânârâ adâkely indatomoem, Jesus nheinwântomoem warâ myani João aguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Deus Xutuen-hoim kuru mâkeba myani João. Jesus mawânkâ kyam Deus Xutuen-hoim kuru; mâkâ wâgâ ani João aguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesus xirâ onro anaxi âewyly myakâwâm, Deus kyam xutuen-honze. Mâkâ wâgâ mawânrâ âdara mâkâ xurâem kydawyly xutuly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mâkâ kyam Deus Xutuen-hoim onro anaxi âemâ; tarâ kuduaylâ akâwâm. Mâkâ lelâlâ idânârâ onro anano modo tytanrugue kulâ xugunipyry, Deus xurâ keba modo olâ Messiaslâ mâkâ awyly nutubamo, Deus Ingonotyby. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Typemugudo judeu domodo duaxilâ wâne myani âewyly. Ipemugudo judeu domodo ewy olâ myani, eynynonroem tâidysebamo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tâlâ olâ myani einwânni lâpylâ, awylygue akaemo Deus xurâem nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tâjimery tyze odaypalâ iazely, nhunwynlâ xuguni warâ. Arâpa olâ Deus tymeryem kyedyly. Eynynonroem kydawylygue tymeryem kyedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Deus kyam Xutuen-hoim Jesus Cristo karalâ akâwâm kurâem awyly. Kuduaylâ akâwâm xirâ onro anaym awyly. Kagâ koendonro lelâlâ mâkâ. Mâkâlâ mawânkâ âkealâ kuru âdaunlo Deus awyly xutuen-hoim. Deus imery tokaleom tawylygue, koendâ, ton-honre warâ mâkâ. Tâense kurâ koendonro kehoem awyly, ton-honre awyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mâkâ Deus kyam Xutuen-honri wâgâ myakâwâm João Batista aguely: — Saguhoem iwâgâ auguehobyrylâ merâ. Auguehobyry enanâguewâdaungâ, “Inepa ise mâkâ yakadâ kuru xuturim âewyly. Urâ lelâlâ wâne ani waunroem iazeim, tâlâ olâ myakâwândy merâ yazely iraylâ” uguehobyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Koendonro lelâlâ mâkâ, koendâ lelâ inanry, idânârâ kagâ awyly. Aunlolâ inanry kurâem koendonro anhesezedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Saguhoem kuru Moisésram myakâwândy Deus kâzewenry nhegatuen-honly, kydamudo judeu domodo ezewenry. Jesus Cristo wâgâ olâ iwerâ Deus koendonroem tawyly, ton-honre tawyly warâ nhenehonly. Jesus Cristo wâgâ mawânrâ âdaunlo Deus awyly kiuntuly. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ânguy Deus netaymba. Mâkâ imery tokaleom olâ tâense, Deus agâ âzekibalâ tawylygue. Tunwym agâlâ mâkâ. Mâkâlâ ani koendâ kuru âdaunlo Deus awyly xutuen-honri. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judeu domodo iwymârydo Jerusalém donro, kurâdo eynynâ Deus agâ aguewâni modoram, emary modoram warâ aguelymo myakâwâm: — Joãoram idâwâtaungâ. Sapâiguewâdaunda: “Âmâ-ro? Ânguyka âmâ? Âwâgâlâ amyguely? Messiaslâ âmâ, Deus ingonokyly tynwânwânseinlâ?” kewâtaunda — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aituo idâlymo; João nhapâiguelymo. Tapâiguehobyry koendâ kehoem in-hoguly: — Messias mâkeba urâ, mâkâ Deus ingonokyly kurâdo inwânwânkyly mâkeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aituo nhapâigueondylymo: — Messias keba matay, Elias kurâem itondyby âmâ? — kelymo. Aituo João in-hoguly: — Elias mâkeba urâ — kely. — Moisés ara Deus itaumbyry egatuim tynwânwânseinlâ âmâ? — kelymo. — Mâkâ keba aze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aituo agueondylymo Joãoram: — Arâ atay, ânguy pylâka âmâ? Tugononibyryam mâin-hoguhobyry tiandyse xina. Âdara tâkezeka âmâ âwâgâlâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aituo João in-hoguly, saguhoem lelâlâ Isaías inweniby aralâ: — Âdy peba atodâ Messias wâgâ agueinlâ urâ. “Ohondaungâ Kywymâry Deus Ingonotyby saintodâ, taseray tuonse wâne pymâ ton-honreim saintoem myara. Inakanhe amidylymo imowâdaungâ” keim urâ — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Aituo, sapâigueze igonotyby modo duano, fariseu domodo, Joãoram aguelymo: — Messias keba, Elias kurâem itondyby keba, unâ egatuim Deus ingonokyly tynwânwânseim keba warâ âmâ-ro watayma kurâ domodo batiza iese ton-honruneba âmâ-ro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aituo João aguely eyanmo: — Urâ parugue batiza âenimo. Âduaymolâ olâ awâkâ, eon-honru mâuntudânrymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Urâ pygueduo lelâlâ wâne Deus xurâem tâwanu nhaguly, awâkâ olâ yakadâ kuru tynrenseim. Mâkâ mawânkâ Deus wâgâ agueim kuru. Mâkâ ara iedylymo watay, âdy mâkeba urâ. Ihuru kâingokehoem ihuru etary etyrinhe witoenlâ nudupa lâgâlâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betaniadâ myakâwâm awârâ aidyly, âtunâguedylymo, paru Jordão kuynâ, João, Deus eynynonroem tâidysedo modo batiza nhetondâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kopaelâgâem João, Jesus nhedyly. Tyam idâly tientuo tonlo modoram aguely: — Etaungâ Deus Ingonotyby. Awâkâ wâgâ ise Deus inakanhe aguitobyry nhygakely. Saguhoem, kordeiru tyâze, tyaduânse warâ mykâinane kurâdo eynynâ Deus agâ aguewâni modo. Awârâ tientuo mykâinane Deus, inakanhe aguitobyry nhygakely. Arâ lâpylâ ise awâkâ âeni kâtaybyay iguely. Awâkâ iguehobyry wâgâ ise, inakanhe aguitobyry Deus nhygakely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Auguehobyry enanâguewâdaungâ: “Inepa ise mâkâ yakadâ kuru xuturim âewyly. Urâ lelâlâ wâne ani waunroem iazeim, tâlâ olâ myakâwândy awâkâ yazely yraynâlâ” uguehobyry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","34","Aituo João nhegatuly ânguy Deus Ingonotyby awyly. — Âdaunlo uguondo wâgâ inakanhe aguitobyry xygakely awyly kâuntuwâbyra wakynre, kordeiru ara inakanhe aguitobyry epywaze tyâzeim. “Kurâdo parugue batiza iekâ” nyguelâ Deus. “Yspiritury uguondo onwa âewyly ese âmâ. Mâkâ ise Yspiritury xuduim, ânguy ynynonro awyly tienehon-hoem, iwerâ wâne enra kurâdo batiza mânhedyly, ânguy ynynonro awyly âzehohoem myara” nygue Deus, ânguy Ingonotyby awyly kâuntuhoem. Deus aguehobyry ara, Deus Ispiritury kaynâpa xytâguyly kâendyly papaem Jesus onwa. Aituo lelâlâ ânguy Messias, Deus Ingonotyby awyly kâuntuly. Messias âewyly iray on-honi modo parugue batiza iedyly mawânrâ iewanu, ânguy mâkâ awyly israelita domodo nhutuhoem. Awylygue “Deus imery awâkâ Jesus” uguely — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kopaelâgâem târâlâ João azagâ tynynonro modo agâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus sakadyly tientuo, João aguely: — “Kordeiru Deus Ingonotyby” keholâ awâkâ, mâkâ iwâgâ auguehobyrylâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Agueduo, akaemo azagâ Jesus nhapygue idâlymo âgânâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Aituo Jesus MYK idyly tykayam. Tyampygue idâlymo awyly tientuo, aguely: — Âdaituoka yampyguedylymo? — kely. — Konomedâni, âdykâka mâxidâdyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus in-hoguly: — Âetaungâ. Inoro eydâ watoam — kely. Kogoneyam, quatro horas awârâem, Jesus agâ idâlymo. Nhedylymo âdykâ Jesus âxidâdybyem awyly. Eagâlâ iguandylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","João Batista eynynonrolâ akaemo azagâ uguondo modo. Jesus aguely tindapygueduo olâ eagâ idâlymo lelâ, iwâgâ tâsenomedâdomoem. Akaemo azagâ uguondo modo ewy André, Simão Pedro iukono, myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesus agâ adâkebygueduo myani André tywaigoru nhuinly, aguely: — Paigo, Deus Ingonotyby Messias xina netai — kely. (“Cristo” keze “Messias” kely gregüem.) ");
INSERT INTO bkqNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aituo tywaigoru nhadyly Jesusram. Jesus Simão enipyryem, aguely: — Simão izedy, João imery. Iwerâ olâ ise izedy iwelo Cefas — kely. (Pedro kezelâ gregüem Cefas kely, “tuhu imâsedo” kezelâ.) ");
INSERT INTO bkqNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kopaelâgâem Jesus Galiléia yan-yam tâtâdyze idyly. Tâtâly iraynâ, Filipe agâ oxiodyly; eyam aguely: — Yagâ âekâ, ynynonroem mitoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida donro myani mâkâ Filipe, André, Pedro warâ ety anano. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipe, Natanael agâ agueze idâly. — Saguhoenlâ Moisés pape kâzewenry awo wâgâ inweniby Deus Ingonokyly wâgâ aguehobyry xina netai. Deus itaumbyry egatuimbyry modo tywenizemo lâpylâ mâkâ âeni wâgâ. Jesuslâ, Deus Ingonotyby, José imery, xidadâ Nazaré donro — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Awârâ tindatuo, Natanael aguely: — Âdy koendonro lâpeba târâ Nazarédâ! Nazaré donro ewy Messias awyly kâinwântaymba urâ — kely. — Âekâ. Egârâ — kely Filipe. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael saindyly tientuo, Jesus aguely tagonro modoram: — Israelita lelâlâ awâkâ saini. Ânguy enokuni mâkeba awâkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesus aguely tindatuo, Natanael, Jesus nhapâiguely: — Âdaraka utuly? Waunroem kydoxiodylylâma xirâ! — kely. Aituo Jesus in-hoguly: — Kâenkylyemba lelâlâ wâne enra iwague mawyly, Filipe. Âgâsedyly iraylâ olâ enra se figueira iay ekadybyem mawyly kâendyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael inwauntudyly, aguely: — Konomedâni, Deus imery âmâ! Israelita domodo iwymâry kehobyry! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus aguely: — “Figueira iay enra nhedyly” uguehobyry wâgâ kulâ yeinwândyly! Ago kuru yeinwânse olâ âmâ, awârâ modo takazeno agânhedyly mâentuo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aituo idânârâam aguely: — Kau âzenahunguely-ro waunlo ara ise mâendylymo. Anju domodo yagâ xytâguyly, âkuly warâ ese âmaemo, urâ Uguondo Kaynâpa Âetyby agâ. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Azagâ iguandyly ipygueduo, Canádâ todohogüinlybe akâwâm, Galiléia eynynâ. Târâlâ akâwâm Jesus ise, todohogüin-hodâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesus agâ xina idâwâm lâpylâ, igâsedybyem tawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aituo vinhu adainly, âty nadaimpalâ. Awârâ tiuntuduo Jesus ise eyam aguely: — Mery, igâsedyby modo sakuihoem vinhu lâpeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus aguely: — Âdaituoka yam amyguely? Iewanu kanguhu oday inkâba awârâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Arâ aguepygueduolâ Jesus ise âty sodo emary modoram aguely: — Ymery aguehobyry arane aitaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tâlâ ani âtâdâ seis poty tuhugue xygatyby modo, paru ekanâdo. Oitenta, cem litros warâ mârâ modo nhawâdyly. Tâzewenry ara, tâzemaunguehomoem, tywykeba tâitomoem warâ judeu domodo parugue nhumytâguylymo myani mârâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus aguely vinhu epâni modoram: — Xirâ poty modo parugue xumytâdaungâ — kely. Aituo parugue poty nhumytâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ilâpyryem aguely: — Xirâ poty odano ewy paru âentywâdaungâ. Sataungâ âty iwymâryam — kely. Aguehobyry ara aidylymo. Paru nhetylymo, nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jesus olâ mârâ paru vinhuem ienehonrimbyryem. Aituo âty iwymâry mârâ xuduypy nhekudyly. Ipa, mârâ paru, vinhuem itybyem lelâ. Âdykâ mârâ vinhu nhetylymo awyly nutuba mâkâ. Emary modo olâ mârâ paru poty odano modo vinhuem ietybyem awyly tutuze. Akaemolâ mawânkâ mârâ tânyzeim poty odayba etyim. Aituo âty iwymâry uguondo ohogüinrim ingâsedyly, aguely: ");
INSERT INTO bkqNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","— Kâzewenryem vinhu tâkubâgueim mawânrâ waunroem tâpâzeim igâsedyby modoram. Ize tato ara nhenybygueduomo pylâ eagonro vinhu ewy epâdyly-ro warâ. Âmâ olâ vinhu tâkubâgueim mekanâdai; âty adainze idâly ume kulâ pylâ mâempâdyly-ro! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Târâ Canádâ, Galiléia eynynâ, saguhoem kuru adyesenry anhedylylâ ani Jesus Deus eon-honru tienehon-hoem. Xina Jesus eynynonro modo Jesus anhetyby tientuo, einwânmâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Awârâpygueduo xidadâ Cafarnaumram Jesus idâly. Ise, iukonodo warâ eagâ idâwânmo, xina lâpylâ warâ. Iweâpa xina nipyra ani târâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Âty Páscoa etyguedo saindyly iray Jesus idâly xidadâ Jerusalémram, mârâ âty aitoam, kydamudo Egitodâpa âsemaguehomobyry enanâgueho. Eagâ xina idâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Deus ety idaseraji egawântybyem kurâ domodo nhedyly. Uguondo modo tapirâ, ovelha, papa, awâkâ modo vende nhedylymo. Tanâseim ani mâkâ modo, xyâhoem, iaduântoem warâ, Deusram egamehoem. Mesa wâgâ ekadyby modo kurâdo idinheruru troca nhedyly, nhedyly lâpylâ. Târâ adyeseim keba anhekylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aituo kordague xikoty anhedyly. Vende ieni modo Deus etydâba inwenkewâdyly, ovelha, tapirâdo warâ agâlâ. Dinheru troca ieni modo iwenzary nhamunedyly. Aituo idinherurumo adapâeguyly onro wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","— Tarâpa merâ modo etywâdaungâ — kely papa vende ieni modoram. — Pabai xyrento xirâ âtâ, âdydo imeom vende ieto, sanâto warâ mâkeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Xina Jesus eynynonro modo nhenanâguely saguhoem Deus itaumbyry awo Salmos wâgâ iweniby: “Deus, toenzepa âtâ âyrento ize wawyly. Woday peto yaduândyly-ro waunlo ara kehoem ity kâinwynedyly. Awârâ ise yiguehoem aienehonrim” warâ iwenibyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesus anhetyby tientuo myani, pymâdo aguely: — Âdylâ Deus eon-honrugue amânhedyly tiendyse xina, Deuslâ, Deus keba tarâ amitoem aguenri mawyly tiuntuhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","— Xirâ âtâ mankalagueduomo, azagâ emedyly idyly ara, saunâtonze urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","— Nuduwâpyra! Quarenta e seis anu samâ xirâ âtâ itâdoem. “Azagâ emedyly ara saunâtonze urâ” myguely. Myguewâdyly kulâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Deus ety wâgâ wâne Jesus aguely, tywâgâlâ olâ aguely lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Igueypyem, kurâem itonduo, Deus ety azagâ emedyly ara tiaunâdyly wâgâ aguehobyry xina enanâguewâm. Tienanâgueduo, âkealâ Jesus aguehobyry awyly xina nhutuly, Deus itaumbyry awo wâgâ iweniby âkealâ awyly lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Páscoa etygueday Jesus Jerusalémdâ awyly ume, toenzepa kurâdo Jesus nheinwândyly, Deus Ingonotyby Messiaslâ awyly, adyesenry modo kehoem anhedyly tientuomo. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesus olâ kurâdo neinwâmpyra, koendâ kehoem akaemo âdaunloem awyly tutuze tawylygue; tutuze agui akaemo ewy tyizepa awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Idânârâ kurâdo tutuze lelâ Jesus ânguy eyam negatubalâ. Idânârâ tyangahu oday xunâgomo tutuze, ânguy eyam aguepalâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tâlâ myakâwâm uguondo Nicodemosgue tâzekeim. Fariseu myakâwâm mâkâ, judeu domodo iwymâry. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kopae idâly Jesus agâ agueze. — Tutuze xina, konomedâni mawyly, Deus ingonotyby. Agâpa Deus watay, adyesenry kehoem amânhetaymba tâise âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus aguely: — Azeompyra kulâ, Deusgue tywymâguneba âmâ. Arâ lelâ mawânrâ Deus xurâem tâjidyly. Xirâ mâuntudyze kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","— Âwâ! Ânguy xutuybyem itybyem niazeontaymba! Nuduwâpyra kyze idâhu odaxi kydodopâdoem, kyazeontoem — kely Nicodemos. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus aguely: — Deus Ispirituryam iweloem kydâiehoba, parugue kyazeontaymba kurâ warâ watay, Deusgue tywymâguneba. Xirâ mâuntudyze kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kyze idâhu odayba kâgaseduo, kurâenlâ kyazely. Awârâ keba olâ Deus einwânni modo Deus xurâem ienehoim, Deus Ispiriturylâ iweloem kyenehoim. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Awylygue tâseguâdâzeba ikâ, “Azeontaungâ” uguelygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sapezenru igâky tydase, ponwary, se iwatary warâ nhekânily tâense warâ âmaemo, sapezenru kuru olâ mâempyra âmaemo. Arâ lâpylâ Deus Ispiritury, Deus einwântaynrim modo wâgâ aidyly mâempyra mawylymo; aitobyry modo lelâ mâenkylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemos aguely: — Kâuntuba lelâ aze. Âdara kuruka amyguehobyry aidyly, Deus Ispiriturygue xina iazeondyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus in-hoguly: — Kâzewenry enomedâni âmâ, awârâ olâ mâuntuba âmâ! ");
INSERT INTO bkqNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Idakâ. Tiuntuybylâ xina Deus eynynonro âyanmo agueho, tientybylâ xina âyanmo nhegatuly warâ. Arâlâ olâ xina agueho mâinwâmpyra mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Xirâ onro anano wâgâ augueduo mâinwâmpyra âmaemo, Deus wâgâ augueduo lakuru ise mâinwâmpyra kuru mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ânguy xirâ anano kulâ Deus ezaxi nâkuwâbyra, iwâgâ egatuze nodopâbyra warâ. Urâ, Uguondo Kaynâpa Âetyby lelâ târâpa xytâguyby. Urâ lelâ Deus wâgâ aguenriem xurutyby — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aituo aguely: — Enanâguegâ, saguhoem kydamudo Deus einwântânry modo âji âdy peba ato einkâ adakobâday, âgâuram sâtobyry. Deus, Moisés âgâu bronzegueto anhetoem, se wâgâ nhaunâtoem warâ aguewâm, mâkâ âgâuram MYK ityby modo kua itoem. Mâkâ âgâu bronzegueto saunâtobyry ara, arâ lâpylâ ise urâ, Uguondo Kaynâpa Âetyby keho, se wâgâ kadaunâhonly, ");
INSERT INTO bkqNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","idânârâ yeinwântaynrim modo, aunloenlâ Deus agâ itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Idânârâ Deus kywynedyly. Awylygue urâ tymery tokaleom ugonodyly. Idânârâ yeinwântaynrim modo eyam âzemakeoze. Deus agâpa tyetunebamo ise, aunlolâ ise eagâ awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Deus ugonodyly, xirâ anano modo igueduo tienagazedoem inkâba, idânârâ yeinwântaynrim modo tienmakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","— Urâ Deus imery yeinwântaynrim modo âji tâdâsenagazedoam nâtâwâbyramo ise. Yeinwântânry modo olâ idâze mârâ âji tâdâsenagazedoam, urâ Deus imery tokaleom yeinwâmpyra atomobyry wâgâ, aunloenlâ Deus agâpa ietomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iajinu MAH nheto ara xirâ anaym Deus wâgâ koendonro segatu, urâ Deus imery; Deus xurâ keba modo olâ Deus izepa ato adiendylylâ ize atomo, awylygue yizepa awylymo. Iamu duay adakobâni aramo kulâ, iajinu oday adakobâni ara inkâba. Awârâ mawânrâ yeinwântânry modo aunloenlâ âsenagazedomoem egamehonrimo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inakai aieni modo yizemo inkâba; ydâpa tâwiensemo lelâ. Yam idâlymo-ro watay, inakai anhekylymo tâdutuoze tâise. Inakanhe adâidyly timodyzebamo tawylygue, adienkyly nhoendylymo, ânguy nutuba itoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Deus ize ato aieni modo olâ wopaji tainsemo. Iajinu aguienkyly nhesagon-ho ara, idânârâam koendâ anhekylymo âzeholy, Deuslâ anhetomoem eon-honrumo xuduim awyly nhutulymo warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Awârâpygueduo, Judéia einkâ Jesus adakobâdyly. Eagâlâ xina idâly. Iweâpadobe târâ xina awyly, inakanhe adâitobyry wâgâ âjityeni modo, adâidyly timodyzedo modo warâ parugue batiza âiehoday. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","João lâpylâ Enomdâ parugue batiza nhetaynlymo, Salim iwaguepa, târâ toenzepa paru awylygue. Toenzepa myani kurâdo idâly eyam batiza âiehoze. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Tâtadâzeba João ilâem.) ");
INSERT INTO bkqNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Judeu agâ João eynynonro modo ewy âjihoguly. Deus enanaym âdara tywykeba tâjidyly wâgâ aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","João eynynonro modo eyam agueze idâly. — Tânanâgueze âmâ mâkâ uguondo paru Jordão kuynâ agonropyry, iwâgâ amyguehobyry. Toenzepa kurâdo eyam idâly batiza âiehoze, âyam âeni modo takaze — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","João aguely: — Tuomare urâ, kurâdo eyam idâlygue. Deuslâ awârâ aienehonrim. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Auguely midadâmolâ: “Messias mâkeba urâ” ugue. Iraynâlâ olâ kâjigonoholy, sainto koendâ konhontoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Todohogüinday, uguondo ohogüinrim xurâ mawânkâ pekodo. Eataen-ho tuomazeze lâpylâ olâ, ohogüinrim ohomaenduo. Arâ lâpylâ kohomaendyly, toenzepa kurâ domodo Jesus nheinwândyly kâuntuduo. Mâkâ mawânkâ Messias, urâ keba. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Agui Jesus aguely idase idâlymo ize wato, auguely idase âewylymo mâkeba — kely João. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Deus eydâ atodâlâ Messias âewyly. Idânârâ duay tynrenseim awâkâ Messias. Xirâ onro anano kulâ kurâ, xirâ ananolâ kiuntuly. Kydâ iwaguepa aityby kulâ kiuntuly. Tarâ kientyby, kindatyby warâ kulâ aguykeho. Messias olâ idânârâ duay tynrenseim kuru. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Deus eydâ atodâ tientyby wâgâ, tindatyby wâgâ warâ aguely. Arâlâ olâ, agui aguely einwântânrybe awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Warâ einwânni modo aguely: “Âkeá lelâlâ ‘Jesus, Deus imery awyly’ Deuslâ mawânkâ agueim” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Deus aguedyse ato, mâkâ Deus ingonotyby agueho, Deus Ispiritury eagâpa nitaymba. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kunwym Deus toenzepa lelâlâ tymery inwynedyly. Awylygue emaxilâ idânârâ nhuduly. Deuslâ idânârâ aitaynrim modo iwymâryem itoem agueim. ");
INSERT INTO bkqNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Awylygue ise, Deus imery einwântaynrim modo Deus agâpa tyeseba awylymo. Tyigueduo, Deusram idâzemo, aunloenlâ eagâ tâitomoem. Deus imery einwântânry modo olâ ise, Deus agâ nipyramo. Tyigueduo, âji tâdâsenagazedoam idâzemo, aunloenlâ Deusdâ iwague itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesus nhenomedâdo idani modo aguiom kuru, João aguely idani modo takaze, Jesus agui kurâdo batiza nhenehonly, João batiza nhetyby takaze, kely tydase myani fariseu domodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Jesus keba olâ tâinwânni modo batiza ieni, xina eynynonro modo.) ");
INSERT INTO bkqNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Unâ tywâgâ, João wâgâ warâ tiuntuduo, Jesus Judéia eynynâba idyly, Galileiaranlâ odopâdyly. Eagâlâ xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria einkâ takadyze Jesus. Awylygue tâinkâ xina sakadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria donro xidadâ Sicar kehoam iwaguepa xina saindyly. Mârâ xidadâ iwaguepa, onro saguhoem lelâlâ kydamu Jacó tymery Joséram nhuduypybe târâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Mârâ onrodâ paru etyho Jacó nhesaguehoymbybe. Kuotatay awârâem paru etyhoram xina saindyly. Toenzepa adakobâdybyem tawylygue, Jesus ekozeybyem. Aituo paru etyhodâ ekadyly tokobyzeguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Târâ awyly ume, pekodo Samaria donro paru etyze idâly; Jesus eyam aguely: — Parugue yakuigâ wao — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Târâpa ani xina Jesus eynynonro modo, pyni sanâse xidadâam idâypyem.) ");
INSERT INTO bkqNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pekodo aguely: — Judeu âmâ, samaritana urâ warâ. Ypemugudo, âpemugudo agâ âjizetonro mâkeba; koendâ oxioni keba warâ. Xina adakuihobyry oday, madakuidyzedo mâkeba âmaemo. Awylygue ywalu etary odano ewy mâenyhoem mâenkaduo, kâseguâdâdyly — kely pekodo. Mâkâ pekodo arâ aguely, judeu domodo, samaritano domodo warâ âjizetonro keba awylymogue. Samaria donro modo adakuihobyry oday nadakuiwâbyra judeu domodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aituo Jesus aguely: — Deus âmâem nhuduly mâuntuly ânguy paru ekani awyly warâ mâuntuly watay, yam paru tâkaze tâise âmâ mâenyhoem. Yam mâenkaduo, âyam tuduze tâise urâ. Mâenyly-ro watay, iweloem tâiehoze tâise âmâ; âigueduo, aunloenlâ Deus agâ mitoem eyam tâtâze tâise âmâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","— Tâsanigue xirâ paru etary, etyho peba âmâ-ro warâ. Nuduwâpyra paru iweloem yetoni yam mâunduhoem, mârâ aunloenlâ Deus agâ witoem ayenehoim. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Saguhoenlâ myakâwândy kydamu Jacó xirâ paru etyho nhesaguehonly. Mâkâ, imeom, eguy modo warâ taunlolâ myakâwândy paru nhenylymo, tâiguewâsemo olâ. “Mâenyly-ro watay, iweloem tâiehoze tâise âmâ” mygueduo, “Jacó takaze ton-honreim urâ” myguelylâ awârâ — kely pekodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aituo Jesus aguely: — Tâwâlâ lelâlâ wâne tatuanzeim modo xirâ paru ewy nhenylymo, inepa lâpylâ olâ ise satuandondylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Paru kâunduypy enywânibyry modo olâ ise natuandombyra. Inatagâdo oze aunlolâ paru egasely myara xirâ paru iwâgâ augueho. Deus agâpa nipyra tyenehonzemo mawânrâ kâunduypy. Iguelymo-ro watay, Deusram idâzemo, aunloenlâ eagâ tâitomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aituo pekodo aguely: — Awârâ paru ewy yam âundugâ wao. Arâ ise yatuambyra wawyly. Xirâ paru ese kâetombyra wawyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","— Oso igâseda. Xarâlâ eagâ odopâgâ-ro warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","— Tusonuneba urâ — kely pekodo. Jesus aguely: — Âkealâ, “Tusonuneba urâ” myguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cinco lelâ tusoneimbyry mawyly, tutuze urâ. Iwerâ ohogüimbyem inkâba âmâ uguondo eagâ mato agâ. Âkealâ amyguely — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Âdaunloem tawyly Jesus agueduo, pekodo âseguâdâdyly. Eyam aguely: — Iweâma tutuze urâ, Deus wâgâ agueim mawyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xina idamudo Deus nhehoguedyly mykâinane xirâ iwy wâgâ. Âmaemo, judeu domodo olâ “Jerusalémdâ lelâ ehoguedo” tâkeze. Âdaunlo unâka iozeno kuru? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aituo Jesus in-hoguly: — Sainse mârâ Deus einwânni modo kuru âdykâingâlâ nhehoguedo, tarâ xirâ iwy Samaria donro wâgâ kulelâba, Deus ety Jerusalém donrodâ kulelâba warâ ise Deus ehoguedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Âmaemo, Samaria donro modo, Deus ehogueze tâkewâze wâne âmaemo, mâuntuba olâ âmaemo mâkâ kuru. Xina judeu domodo olâ tutuze, tâinwânse warâ. Judeu ewylâ mawânkâ Deus Ingonotyby imakerinmoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sainse mârâ Deus eynynonro modo, Deus ize ato ara kehoem nhehoguedo. Anri awârâ aidyly adaguly-ro warâ. Âdara ioze ehoguedyly awyly xutuen-honze eagâmolâ ise Deus Ispiritury. Deus wâgâ enomedâzemo mâkâ. Awâkâ ioze lelâ ehogueni modo mawânkâ Deus ize ato tohogueniem. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tâentuneim mâkeba Deus. Tyispirituryenlâ mâkâ ekaduo nhuduly. Deus Ispiriturygue lelâ Deus nhehoguedyly, ize ato ara kehoem, âkealâ adâkehobyry nhenehon-ho ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Pekodo aguely: — Tutuzelâ urâ, âdaralâ Messias, Deus Ingonotyby, saindyly awyly. Âewyly-ro watay, idânârâ kehoem ise Deus wâgâ kiuntudyze ato aguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","— Urâ agâ tunâgueim, Messiaslâ urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mârâ ume kehoem xina odopâdyly, pyni sanânibyryem. Jesus pekodo agâ xunâgu tientuo, tâseguâdâze ani xina. Xina ezewenry keba mawânrâ pekodo tiuntudânry agâ tâdunâgu. — Âdyka merâ agâ ize mato? — xina kepa olâ ani pekodoam. — Âdaituoka awâkâ pekodo agâ âunâgu? — xina kepa gâlâ Jesusram warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aituo pekodo idâly, tywalu etary târâlâ nhânly. Xidadâam odopâdyly. Tonlo modoram aguely: ");
INSERT INTO bkqNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","— Paru ese watay, uguondo âdykâ kâentyby keba xiotai. Idânârâ agânhetaymby modo wâgâ agueanry olâ. Etaungârâ. Messiaslâ keanra mâkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aituo agui kurâdo xidadâ odaypa egaselymo. Idâlymo Jesus eydâ atoam. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pekodo idâpygueduo, xidadâ odano modo saindyly ume, xina aguely Jesusram: — Anra xina nhanâtyby pyni. Kydâwinduane, Konomedâni — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesus olâ aguely xinaram: — Mâenetybymo kâinwâpyra ise urâ. Tâlâ urâ mâenetybymo takaze kehoem, pyni koendonro. Âdy augueho awyly mâuntuba lelâ olâ âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aituo xina aguely: — Ânguylâ keanra ipyniry nenetai — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","— Ânguy ypyniry nenetaymba. Mâkâ ugononibyry agânhetoem aguehobyry aiedylylâ ypyniry. Idânârâ ize ato agânhetuo, âdy izetonze inkâba urâ, tuomare lelâ, âwinduatybyen-ro waunlo ara lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wamyguelymo inanry: “Quatro nunâ pygueduo kientâdyby kienkaunâdyly lelâ ise” myguelymo. Etaungâ akaemo âeni modo. Trigu ekaunâdo odaxi ityby emyenro akaemo. Iwerâ koendâlâ Deus itaumbyry eyanmo egatuhoem; iweâpa tâiseba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","— Etânibyry, ekaunânibyry warâ tâzepywaozemo. Koendâ lelâ âzekaunâdyly watay, tohomaenzemo. Arâ lâpylâ, waunroem ywâgâ egatuwânibyry modo, ilâpyryem ywâgâ imâem kuru enomedânibyry modo warâ ohomaendyly ise, aguelymo idani modo yeinwândylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Âkealâ wakehonly: “Mâkâ etâni, eagonro pylâ ekaunâni-ro” kehonly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ogonodylymo, ywâgâ mâengatuhomoem. Eagonro ewanugue kulâ âgâmylymo, eagonro nhetâdyby kulâ mâenkaunâguylymo waunlo ara. Saguhoenlâ mawânkâ Messias saindyly wâgâ eagonro modo aguewâm. Unâ mâengatulymo idani modo yeinwânsemo, amyguelymo tindadylygue kulâba olâ, saguhoem ywâgâ aguely tindatybymo tienanâgueduomo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria eynynonro, âtâ anary Sicar donro modo ewy agui myani Jesus Messiaslâ awyly einwânni modo, “Uguondo âdykâ kâentânry xiotai. Idânârâ agânhetaymby modo wâgâ agueanry olâ” pekodo keduo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Imâem myani Jesus wâgâ tiuntudyze awylymo. Awylygue Jesusram taintuomo, tagâlâ itoem nhekadylymo. Aituo azagâ iguandyly Sicardâ nhakadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mâkâ lelâlâ aguely tindatuomo, kurâ domodo nheinwândylymo Messiaslâ mâkâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pekodoam aguelymo: — Mâkâ tâinwânse xina iwerâ, mâengatuyby wâgâ kulelâba olâ, xina lelâlâ nhenomedâdo tindatobyry wâgâ. Tutuze xina, idânârâ tâinwânni modo emakeze âetyby awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Târâ azagâ iguandyly sakanibyryem, Jesus agâ Samaria eynynâba xina egasely. Galiléia yan-yam eagâlâ xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Deus itaumbyry egatuim tâinwântuneba ety anano modoram kuru” kely ani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galileiaram xina saintuo olâ ani tonlo modo koendâ kehoem xina nhedaenkulymo. Jerusalémram tâtâzemo myani, Páscoa etygueze. Tâensemo myani târâ Jesus anhetaymby modo. Awylygue koendâ nhedaenkulymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aituo mârâ âjidâpa Jesus âxiguely, xidadâ Canánra odopâdondyly, Galiléia eynynonroam, paru vinhuem tienehon-hombyryam. Tâlâ ani Cafarnaumdâ tâjikeim pymâ emary. Toenzepa myani imery ewânu. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","“Judeiadâpa Jesus naindâ; Galileiadâ iwerâ” kely tindatuo myani pymâ emary Canánra idâly Jesus agâ agueze: — Toenzepa ymery ewânu târâ Cafarnaumdâ. Yagâ wao inoro, kua mânhetoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus aguely eyam: — Adyesenry agânhedyly mâentuomo lelâ yeinwândylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tâwâneim nhunwym aguely: — Iguezeseaji enra iegaseday. Iokobagâ inoro, iguely iraynâlâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","— Tadahulizeba ikâ. Ityam odopâgâ lelâ. Ipa, âmery kua nitai, niguewâpyra ise — kely Jesus. Tâwâneim nhunwym Jesus tymery kua ienipyryem awyly nheinwândyly, eydâ iwague awyly umelâ. Aituo odopâdyly tâtyam. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ânwa oze tâmary modo agâ oxiodyly. Aituo aguehonly: — Âmery niguewâpyra! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aituo adapâigueolymo: — Âdara hora awyly umeka keankâ ymery koendâ idyly? — kely. Aituo in-hogulymo: — Kopaelâgâ, kogoneyam tokalâ hora awyly umelâ keankâ iaturu inmoly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aituo iamudo nhunwym mârâ kogonekâlâ Jesus “Âmery kua nitai. Niguewâpyra ise” kehobyry nhenanâguely. Aituo Jesus einwânniem idyly, idânârâ ety odano modo lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judéia yan-yam tâtâly iraynâ adyesenry aiemâlâ Jesus Canádâ paru vinhuem tyenehonze. Galiléia yan-yam odopâdondybyem, azagâ adyesenry anhedyly idyly ani Canádâ, pymâ emary imery kua nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pymâ emary imery kua ienipyryem Jesus idâly Jerusalémram, âtyam. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalémdâ, Ovelha Modo Iwyantary keho iwaguepa tâlâ mawânrâ paru etary. Hebraiku-em, “Betezata” mârâ paru etary ezedy. Cinco lelâ varanda modo, târâ mawânkâ tâwânuneim modo emynru eguetunu warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mârâ âjiam Jesus idâday, toenzepa tâwânuneim modo onwâgâ awyly: epy modo, nadakobâbyra ityby modo, tywykelâ iazeypy modo warâ. Paru sahugânily inwânwândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Anju Deus ingonotyby mawânkâ mykâinane tytâguyze mârâ paru sahugânize. Anju anhepygueduo mawânkâ tâwânuneim modo ihuguely; paikaji waunroem ihugueybylâ olâ kua ini. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tâlâ ani iduaymo uguondo iweâpa tâwâneim; trinta e oito anu myani mâkâ ewânu; nadakobâbyra awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eguetudybyem awyly ume Jesus nhedyly. Iweâpa arâ ewânu awyly nhutuly. Aituo eyam aguely: — Kua midyse âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Uguondo in-hoguly: — Ânguy paikaji yeni peba adahugânioduo. Iegawândyse wâne urâ, eagonro tâwâneim olâ inanry uwakadâ lelâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus aguely eyam: — Aukâ. XYDYK ikâ. Iguetudobyry sanâkâ. Idâ ityam tadakobâze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ilâ umelâ kehoem, uguondo kua idyly Jesus eon-honrugue. Tâguetudobyry nhanâdyly, adakobâdyly. Sábado oday ani awârâ aidyly, kokobyzegueho âdaunloenlâ kydâsewaniho keba ume. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Judeu domodo iwymâry ewy mâkâ uguondo tâguetudobyry nhanâdyly nhedylymo. Awylygue eyam aguelymo: — Kokobyzegueho iwerâ. Kâzewenry ara inkâba awârâ amidyly, âdy aieto mâkeba iwerâ awârâ iguetudobyry kadadâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aituo aguely: — Uguondo kua yenipyry agueanry: “Iguetudobyry sanâkâ. Idâ ityam tadakobâze” keanry — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","— Ânguyka enra arâ amitoem agueim? — kelymo eyam. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kua tyenipyry ezedy nutuba olâ mâkâ uguondo, tonlo modo duaylâ Jesus idâypyem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ilâpygueduo Jesus kua tientyby nhedyly Deus etydâ. Aguely eyam: — Auguely wao idakâ. Kua itybyem âmâ. Deus izepa ato kulâne akâiedâ, arâ matobyry takaze kehoem amipyra mitoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesus aguepygueduolâ mâkâ uguondo târâpa âxiguely. Kua tyenipyry wâgâ agueze idâly judeu domodo iwymâryam. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesus nhewiâsedylymo nhenuagaendylymo warâmo myani, tâzekobyzegueho oday kua nhedyly awylygue. Awylygue eynynâ inakanhe aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus aguely eyanmo: — Kopaelâgâembaba Pabai âsewanily; ara lâpylâ iewanu kâempagunâbyra wawyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","“Pabai ugueho” Jesus keduo, Deuslâ agueho awyly tutuzemo ani. Awylygue toenzepa iewiâpadylymo, âdara tyânly awyly wâgâ âseinwândylymo, tâzekobyzegueho oday kua nhetobyry wâgâ kulelâba, Deus “Pabai ugueho” kehobyry wâgâ lâpylâ. Arâ adâkeduo, Deus agâ âzekiba tawyly mawânkâ Jesus agueho. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus aguely: — Deus imery lelâlâ wâne urâ, won-honrugueba olâ âdydo imeom agânhedyly. Pabailâ agânhetoem agueim. Pabai anhedyly kâenkyly lelâ agânhekyly. Mâkâ anhekyly, adyese urâ, imery wawylygue. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Imery wawylygue, toenzepa Pabai ywynedyly. Awylygue idânârâ adienkyly modo nhenehonly. Agânhetyby modo tâense âmaemo. Pabai yam nhenehonly aiese olâ urâ, mârâ iwâkuru kuru. Mârâ agânhetuo, âsewânize lelâlâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Iguewâtyby modo, kurâem tyetonze Pabai. Turâ xurâ modo aunloenlâ tagâ tyenehonze mâkâ. Pabai anheto aralâ agânhedyly. Aituo ise aunloenlâ Deus agâ kânhenehonly, mâkâ eagâ kânhenehondyze wato lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Xypyry etay Pabai mâkeba ise ânguy tâmakezeim, tâmakezenry warâ awyly agueim. Aunloenlâ eagâ ini modo kâinduakehoem, âji tâdâsenagazedoam idâwâni modo kâinduakehoem warâ agueypyenlâ mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Arâ Pabai agânhetoem aguely, idânârâ yrendylymo mawânkâ ize ato, mâkâ mâynrentomo ara lâpylâ. Yrempyra âmaemo-ro watay, Pabai ugononibyry mâynrentaymba lâpylâ âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Jesus aguely: — Auguely indadyly, ugononibyry nheinwândyly waunlo âdaunloenlâ Deus agâpa tyetuneba ise. Iguely-ro watay, aunloenlâ ise Deus agâ awylymo. Âdalâ âji tâdâsenagazedoam nâtâwâbyramo ise. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Idataungâ auguely. Anri adaguly, Deus eynynâbaom modo augueho indato. Deus xurâempa awylymogue, igueypy aramo kulâ. Auguely indadylymo, yeinwândylymo warâ watay olâ, igueypyem, kurâem itondyby aramo ise. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Âdaunloenlâ Deus agâpa tyetunebamo ise, iguely iraynâ, igueduo alelâ, ton-honre mawânkâ Pabai awârâ adientoem. Ynynonro modo Deus agâpa kânhenehomba witoem aguewâm lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","“Uguondo Kaynâpa Âetyby mawylygue, auguely âyam, âynynonro modo xurâem koendonro lelâ mâunduhoem; âynynonro keba modo pylâ ise mâenagazenehonly-ro” kewâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","— Xirâ âyanmo augueho wâgâ tâseguâdâzeba itaungâ. Anri saindyly, idânârâ iguewâtyby modo ytaumbyry indato. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kurâem itonzemo. Âji tâpyâdomobyrydâpa âzepyâguezemo, egasezemo-ro warâ. Deus ize ato aienibyry modo aunloenlâ ise Deus agâ awylymo, âdaunloenlâ eagâpa tyeseba itomoem. Deus izepa ato aienibyry modo olâ âzewentâozemo. Âjigonohonzemo âji tâdâsenagazedoam, aunloenlâ târâ itomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesus aguely: — Unâry wâgâ kulâ inkâba idânârâ agânhekyly modo agânhedyly. Deus aguehobyrylâ agânhekyly. Yeinwântaynrim modoram koendonro lelâ ise kâunduly; yeinwântânry modo pylâ kâenagazenehonly-ro warâ. Pabai aguehobyry lelâ mawânrâ agânhekyly. Ize wato kulâ mâkeba agânhekyly, mâkâ ugononibyry ize atolâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","— Ywâgâlâ auguely-ro watay, “Deus ingonotyby urâ” ugueduo, auguehobyry âdyem nitaymba, âkealâ keim kepa watay. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tâlâ ynynâ agueim, Deus, Pabai ugueho. Ânguy wawyly tutuze mâkâ. Ywâgâ agueho âkealâ awyly tutuze urâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ânguy wawyly mâuntuhomoem, João Batista tapâiguen-honze ani âmaemo. Âkealâ ani mâkâ ywâgâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ywâgâ aguenriem ânguygue kâtuiwâbyra urâ, ânguyem wawyly mâuntuhomoem. Arâlâ olâ ynynâ João aguehobyry âyanmo kâenanâguehonly. Aguehobyry mâinwândylymo, yeinwândylymo-ro warâ watay, âzemakeoze lelâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","— Lamparina koendâ kehoem tyatygueim wâne, kytâho nhesagonly, myara ani João aguehobyry mâuntulymo âdara Deus ezaxi tâdâtâly wâgâ. Mâkâ aguehobyry mâindatuomo omazemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Âdiempa mutumo ywâgâ. Iwerâma adyesenry kehoem agânhedyly tâense âmaemo, âkealâ kuru Deus Ingonotyby wawyly mâuntuhomoem. Pabai Deus adyesenry modo kehoem agânhetoem anygue. Mâentuomo, xutuze âmaemo, Ingonotybylâ wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pabai ywâgâ adâkeze lâpylâ, mâkâlâ ugononi awylygue. Agueho mâindadyseba olâ âmaemo, nhutuen-honly mâuntudyzebamo warâ. Âdykâ mâkâ itanru mâindapyra, emydy mâempyra warâ olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ywâgâ Pabai aguehobyry mâinwândylymo-ro watay, yeinwântâ tâise âmaemo. Yeinwâmpyra, ywâgâ Pabai agueho mâinwâmpyra warâ olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Âdara mâsemaguelymo awyly mâuntudyze mawylymogue, Deus itaumbyry awo wâgâ iweniby mâintainlymo. Mâsenomedâdylymo, âdara aunloenlâ Deus agâ tâjidyly kyigueduo awyly mâuntuhomoem wâne. Iweniby modolâ ywâgâ âkealâ agueim, ywâgâ lelâ mawânrâ Deus eydâ atoam tâdâtâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aralâ olâ, yeinwândyseba mawylymo, aunloenlâ Deus agâ mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","— Koendâ wawyly wâgâ, won-honru wâgâ warâ kurâdo aguepa awylygue kâseguâdâdaymba urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Koendâ âutudâmo urâ, angahumo oday âunârymo alelâ. Deus izetonro ara midylymo kulâ awyly, tutuze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Pabai ugueho ingonotybyenlâ xirâ kâewyly, yizepa, yeinwândyseba warâ olâ âmaemo. Pabai ingonotybyemba âeni watay olâ âmaemo tâinwânse. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ataen-homo âwâgâmo koendâ aguely ize matomo. Deus tokaleom âwâgâmo koendâ aguehoem, koendâ lelâ amidylymo mipyra olâ âmaemo. Awylygue mawânrâ nudupa awyly yeinwântomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kâzewenry Moisés inwenihoem Deus aguehobyry mâinwânkylymo. Awylygue, “Aunloenlâ Deus agâ tâitoem idâze xina” myguelymo. Xypyry etay, idânârâ kurâ domodo Pabai enado âepanâgueduo, urâ keba ise agueim, Moiséslâ ise agueim: “Deus neinwâmpyra atomobyry wâgâ asaemo ise tâwentâzeim” kerim. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ywâgâlâ myakâwândy Moisés inwenily urâ Deus Ingonotyby wâgâ. Moisés inweniby tâinwânse lelâlâ âmaemo-ro watay, yeinwântâ lâpylâ tâise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Inweniby mâinwâmpyra mawylymogue, augueho mâinwâmpyra mawylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Arâ agueypyem, Jesus Galiléia iwalu nhekuâdyly pepi oday; Tiberíades kelygue tâzekeim lâpylâ mârâ paru. Eagâlâ ani xina. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Târâ Jesus awyly tiuntuduomo, agui kurâ domodo myarâ idâly, toenzepa tâwânuneim modo kua nhedyly tientomobyry wâgâ. Adyesenry anhedyly tientondyze tawylymogue, nhapygue idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus âkuly iwy onwa xina agâ. Târâ xina ekadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Páscoa etyguedo iwaguepa idyly ani. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus wayam wayam warâ MYK idyly. Tyampygue toenzepa kurâ domodo iwy onwa âkuly nhedyly. Aituo Filiperam aguely: — Âdykâ kaise pyni kianâdyly merâ kurâ domodo ipyniryem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kurâdo tuantoem âdy adienkyly awyly tutuzelâ olâ myani Jesus-ro warâ. Âdara Filipe in-hoguly awyly tiuntuhoem kulâ arâ aguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aituo Filipe in-hoguly: — Duzentas moedas pratagueto tainze tâise kurâ, pyni sanâtoem, mâkâem, mâkâem warâ pão epajiwâdoem, tydinheruguepa kurâ — kely. (Tokalâ iguandyly âwanopyry epywado mawânrâ tokalâ moeda pratagueto.) ");
INSERT INTO bkqNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aituo Simão Pedro iukono André idâly Jesus agâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","— Tâlâ tarâ iamudo cinco pão cevadagueto, azagâ kanra âjihuyby warâpeom. Nudupa olâ ise toenzepa kurâ domodo xuatoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aituo aguely Jesus xinaram: — Âji iwâkurudâ ekadomoem aguewâtaungâ — kely. Poji wâgâ ekadomoem âji iwâkurube ani târâ. Aituo idânârâ ekadaynlymo. Toenzepa târâ kurâdo awyly, uguondo modo kulelâ cinco mil lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aituo Jesus cinco pão sanânibyryem, Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai; awylygue xinaem xirâ pão mâunduly — kely. Arâ agueypyem, pão nhepajiwâdyly; xina nhepâdoem nhuduly. Xina nhepâdaynly umelâ kehoem Jesus pão epajiwâdyby agui nhenehonly. Ilâpygueduo, Jesus azagâ kanra âjihuyby nhanâdyly, Deus agâ aguely: — Koendonro lelâlâ âmâ, Pabai; awylygue xinaem merâ kanra mâunduly — kely. Arâ agueypyem, kanra nhepajiwâdyly, xina nhepâdoem nhuduly. Xina nhepâdaynly umelâ kehoem, kanra agui nhenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ize tato ara kehoem idânârâ kurâdo âwinduadyly. Kanra âjihuyby nhâdylymo; pão nhedawynlymo; koendâ kehoem iolataynlymo warâ. Koendâ kehoem âwinduapygueduomo, xinaram aguely: — Âsegubydâdyby modo saunkuwâdaungâ, nâxiumebyra itoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ilâpyryem pão, kanra âjihuyby warâ âsegubydâdyby xina nhetadâdyly. Doze cestu tumyke lelâ xina nhekanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Awârâ adyesenry Jesus anhedyly enipyry modo aguelymo: — Âkealâ mynra, Deus itaumbyry egatuim kinwânwânkylylâ mynra merâ. Roma donro takaze kehoem merâ kywymâryem kyjiene! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tywymâryem tyese kelymo tiuntuduo, mâkâ kulelâ târâpa âxiguely, eagonro âjiam idâly. Pymâ onro anano keba tawyly, tutuze mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iguandyly ume, târâ Jesus cinco pão, azagâ kanra warâgue kurâ domodo nhuantobyrydâpa xina xytâguyly. Galiléia iwaluam xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesus xina agâ nâepyra. Pepi odaxi xina âxiedyly, paru tienkuâdoem, xidadâ Cafarnaumram tâtâhoem. Xina idâzesedyly umelâ, iamadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tahuleim kulâ adapezeinly ton-honre kehoem xina yan-yam; toenzepa kehoem paru adahugânily. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sagunudâpa âxigueybyem, cinco, seis kilômetros awârâem xina awyly ume, paru wâgâ Jesus adakobâdyly xina nhedyly. Xina iwepiry iwaguepa saindyly. Jesus paru wâgâ adakobâdyly tientuo, toenzepa xina âseanedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Warâ olâ Jesus aguely xinaram: — Tâseanezeba itaungâ! Jesuslâ urâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aituo Jesus pepi odaji âxiedyly. Toenzepa xina iomazely, mâkâ tagâ awylygue. Inepa xina saindyly eyam tâtâhoam. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Emetybyem, Jesus tuizemo myakâwâm târâ paru emelay, xina pepi odaxi âxiedobyrydâ. — Âdykâ Jesus? — kelymo. — Tokalâ kulâ keankâ pepi taunlo. Jesus olâ keankâ iodaxi nâxiebyra. Eynynonro modo lelâ keankâ âxieni. Mâkâ pebalâ keankâ idâlymo. Iwerâ olâ tarâpa — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aguelymo ume, xidadâ Tiberíadesdâpa âetyby modo paru nhekuâdylymo. Tywepiry odaypa âzetywâdylymo, Jesus kurâ domodo tuantoem, “Koendonro lelâlâ âmâ, awylygue xina ipyniry mâunduly” kehobyry iwaguepa. Xuize idâwânmomy, nepyramo olâ myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesus, xinalâ warâ târâpa awyly tientuomo, Tiberíadesdâpa âetaymby modo tywepiry odaji âxiedaynlymo, paru tienkuâdoem. Cafarnaum iduantaji saintybyem xuize idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Paru ekuânibyryem, Cafarnaumram saintybyem, Jesus agâ oxiodylymo. Eyam aguelymo: — Âmâ enra xina nhuinly, Jesus. Âdaraka xarâ aindyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","— Kopaelâgâ pãogue âwatomobyry wâgâ kulâ uilymo, âdaituo adyesenry modo kehoem agânhedyly awyly mâuntuhomoem inkâba. Pão agui kânhenehonly medâmo lelâlâ wâne, adâituo agânhedyly awyly mâuntuba olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pyni inepa adainrim, inakanhe ini warâ wâgâ inkâba âpaunzedaungâ. Tâlâ ise pyni emyenro âmaemoem, âdaunloenlâ inakanhe itânry. Emakewâni modo aunloenlâ Deus agâpa tyetuneba ise. Igueduo, aunloenlâ eagâ tâitoem eyam idâzemo. Âzeon-hondâdaungâ, xirâ augueho tâlâ mitomoem. Urâ, Uguondo Kaynâpa Âetyby kelygue tâzekeim, xuduze urâ âyanmo, yeinwândylymo-ro watay. Awârâ agânhetoem kâewyly awyly nutuen-ho Pabai Deus — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aituo Jesus nhapâiguelymo: — Âdyka Deus xina anhedyse ato awârâ amyguehobyry xina nhemakehoem, awârâ pyni emyenro? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aituo Jesus in-hoguly: — Âdaunlo âwanu mâkeba ise amânhekylymo. Yeinwândylymo kulâ Deus ize ato, urâ mâkâ ingonotyby — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","— Adyesenry pylâ aiekâ, Messiaslâ mawyly, xina nheinwântoem. Âdyka ise amânhekyly, Deus Ingonotyby mawyly mâenehon-hoem? ");
INSERT INTO bkqNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iweâpa kydamudo Egitodâba egaseday, âji âdy peba ato einkâ adakobâdaymo, maná myakâwândy ipynirymo. Iwenibyem Deus itaumbyry awo wâgâ: “Pão kaynâpa eyanmo ingonokyly nhedawyn-homoem” — kelymo Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aituo Jesus aguely: — Kaynâpa Deus ingonotyby maná kehogue, kydamudo xuamâmy Moisés. Pabai Deus lelâ mawânkâ pyni kuolanâni emyenro xudunri. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Deus, kydamudo tâwindygue niguepa itoem maná kau odaypa tingonotobyry, ara lâpylâ mâkâ ugonodyly xarâ onro anaxi. Pyni ize kurâ kyiguepa kitoem, arâ lâpylâ yeinwântaungâ, aunloenlâ Deus agâ mitomoem, âdaunloenlâ eagâpa mipyra mitomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","— Pymâ, aunlolâ awârâ amygueho xinaram xudugâ, awârâ pyni mygueho — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","— Urâlâ mawânrâ mârâ pyni emyenro. Urâlâ ise yeinwânni modo aunloenlâ Deus agâ ienehonri, eagâpa ienehondânry warâ. Ynynonro modo nâsewinzedondaymba natuandondaymba warâ ise. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Deus eon-honrugue agânhekyly mâendylymo umelâ olâ auguehobyry mâinwândyseba mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Idânârâ yeinwânniem Pabai ize ato modo, urâ xurâ lelâ. “Yam âetaungâ, aunloenlâ yagâ mitomoem” warâ auguely yeinwândysedo modoram. Yam âetaymby modo âdaunloenlâ izepa witaymba urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","— Deusdâpa ani kâewyly, ize ato agânhetoem, ize wato aiese inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Pabai koendâ yeinwântaynrim modo kâendyse awyly. Ynynonro modo tydâpa iedyly ize inkâba mâkâ. Xypyry etay, ynynonro modo kurâem kânhetondyze mâkâ, aunloenlâ eagâ itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pabai ize ato mawânrâ idânârâ tymery einwânni modo, aunloenlâ eagâ awyly, eagâpa nipyra. Aguehobyry awylygue ise xypyry etay kurâem kânhetondylymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Judeu domodo ewy nehoguebyra Jesus tywâgâlâ aguely: “Urâlâ Deus tydâpa ingonotyby pyni emyenro” kehobyry. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aituo aguelymo: — José imery kulâ awâkâ Jesus. Nhunwym, ise warâ tutuze kurâ. Alâ “Deusdâpa kâewyly” kely. Kewâdyly kulâ awâkâ. Nuduwâpyra awâkâ Deusdâpa âetoem! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus aguely eyanmo: — Inakanhe kulâ amyguelymo imowâdaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Âwâlâ kulâ ânguy yeinwântaymba, Pabai ugononibyry yeinwântomoem aniempyra watay. Pabai ugononibyry mawânkâ kurâdo yeinwântoem aienehoim. Xypyry etay olâ kurâem itondomoem aienehonze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Saguhoem Deus itaumbyry aguewâni modo ewy warâ akâwândy inwenily: “Idânârâ ise Deusram âzenomedâolymo, âdara einwândyly awyly wâgâ.” Idânârâ Pabai nhenomedâdo idani modo, tyangahu odaji ieni modo warâ yeinwânsemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ânguy xirâ anano modo Pabai ugueho netaymba. Urâ lelâ mâkâ eni. Eydâlâma kâewyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","— Idataungâ auguely. Yeinwântaynrim modo Deus agâpa nitaymbamo ise. Igueduo, Deusram idâzemo, aunloenlâ eagâ itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Pyni emyenro urâ. Urâlâ ise yeinwântaynrim modo aunloenlâ Deus agâ ienehoim. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Âji âdy peba ato einkâ tadakobâdyly ume maná myakâwândy kydamudo ipyniry. Manágue âduahonwânmo lelâlâ wâne, iguewânmo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Deusdâ âetyby einwânni modo, iguezemo lelâlâ wâne, nadaimpamo olâ ise. Idâzemo aunloenlâ Deus agâ tâitomoem. Pyni emyenro mawânkâ Deus Ingonotyby. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pyni emyenrolâ urâ on-hondâzemo Deus ingonotyby. Yeinwântaynrim modo Deus agâpa tyetuneba ise. Iguelymo-ro watay, idâzemo Deusram, aunloenlâ eagâ tâitomoem. Yiguely ise, ynynonro modo aunloenlâ Deus agâ itomoem. Ynynonro modo eon-hondâniem, wodo pylâ ipynirymo-ro waunlo ara ise — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aituo idanipyry modo âjigue aguelymo: — Kypyniryem nitaymba ise awâkâ sodo! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus aguely eyanmo: — Wodo mâmpyra âmaemo, unu mâenypa âmaemo warâ-ro watay, aunloenlâ Deus agâ mitaymba ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wodo sâni, unu enyim warâ olâ aunloenlâ ise Deus agâ awylymo, eagâpa tyesebamo. Xypyry etay ise kurâem âiehondylymo-ro warâ. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jesus aguely: — Pyni lelâlâ wodo, tânyzeim lelâlâ unu warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wodo sâni, unu enyim warâ watay, aunloenlâ ise yagâ awyly. Eagâlâ ise urâ; yagâlâ ise warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Pabai ugononibyry igueypyem inkâba; aunlolâ mâkâ tâlâ awyly. Eagâ wawylygue, kadainwâpyra ise urâ; tâlâ lelâ. Wodo sâni modo lâpylâ yagâpa nipyramo, nadainwâpyramo warâ ise, tâlâ lelâ. Iguelymo-ro watay, eydâ watoam idâzemo, aunloenlâ yagâ tâitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Waunlo urâ pyni emyenro Deus eydâ atodâ igonotyby. Kydamudo ipynirybyry maná emyenro keba urâ. Maná tâinzemo lelâlâ wâne myakâwândy kydamudo, iguewâm olâ. Deus ezaypa xytâguybylâ urâ. Wodo sâni, unu enyim warâ yagâpa nâiehowâbyramo ise. Tyigueduo, idâzemo aunloenlâ Deus agâ tâitomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cafarnaumdâ Jesus xirâ modo aguely, âtâ tâdâtâdyguyho oday tienomedâdylymo ume. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Awârâ tindatuo, Jesus nhapygueni modo ewy aguelymo: — Arâ agueduo kiuntuwâbyra kurâ âdakeze aguely awyly. Kieinwântoem nuduwâpyra awârâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Akaemo agueho ânguy negatuba lelâlâ wâne Jesusram, tonomedâdomo izepa awylymo tutuze olâ Jesus. Awylygue eyanmo aguely: — Iwerâ yeinwântaymba âmaemo, augueho mâindadyseba midylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Âdaise wânkâ âmaemo, eydâ watobyryanlâ kâkuly mâentuomo? ");
INSERT INTO bkqNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Deus Ispiritury wâgâ mawânkâ ynynonro modo yeinwândylymo, âdalâ yagâpa nâiehoba tâitomoem. Igueduomo, Deus ezaxi idâze awylymo tutuen-honze Deus Ispiritury. Ânguy tâwâlâ kulâ âsemagueim lâpeba; ânguy tâwâlâ anientaymba Deus eydâ atoam tâtâhoem. Auguehobyry einwânni, aieni modo warâ agâlâ mawânkâ Deus Ispiritury. Deus Ispiritury agueduo lelâ akaemo âzemakeoly, aunloenlâ Deus agâ tâitoem tyigueduo. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Alâ olâ âmaemo ewy yeinwâmpyra mawylymo — kely. Tâinwâmpyramo awyly wâgâ Jesus aguewâm, tutuzelâ mawânkâ akaemo ewy tâinwâmpyra awyly. Ânguy tâgameim awyly xutuwâm lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesus aguely: — Âmaemo idânârâ inkâba yeinwândylymo. Awylygue âyanmo auguely. Pabai, yeinwântoem aguehobyry modo lelâ yeinwânni — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Awârâ tindatuo, Jesus aguely idase nhapygueni modo ewy agui eagâpa tâisemo ani. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aituo Jesus xina nhapâiguely: — Âmaemo-ro? Mydâdyse lâpylâ âmaemo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simão Pedro in-hoguly: — Agâpa tâidyse inkâba xina, Jesus. Âmâ lelâ âdara aunloenlâ Deus agâ xina idyly awyly wâgâ enomedâni, âdalâ eagâpa xina nipyra itoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Âmâ lelâ xina nheinwânkyly. Deus Ingonotyby mawyly, tutuze xina — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus aguely: — Kâinduakeyby âmaemo, doze lelâ. Tokalâ âmaemo ewy olâ Diabu emary — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas wâgâ Jesus aguely, Simão Queriote donro imery. Jesus eynynonro lelâlâ wâne Judas, arâlâ olâ izepanro modo emaxi Jesus nhegamely nhâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Arâ adâkely ewanikeimbyryem, Galiléia eynynâ Jesus adakobâdyly. Judéia eynynâ nadakobâbyra awyly, tonlo pymâ domodo mawânkâ tyândyse. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Âty Âtâ Wakurigueto etyguedo iwaguepa ani, kydamudo âji âdy peba ato einkâ adakobâdaymo, âtâ wakurigueto oday kulâ xykyhomobyry enanâgueho. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aituo Jesus iukonodo eyam aguelymo: — Tarâpa ikâ. Judeiaram idâ, xidadâ Jerusalémram, Judeiadâ matay ampyguenibyry modo amânhekyly nhetomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mâkâ kurâ tâdutuodyze donro, adienkyly noentaymba, kurâ domodoram tâzehohoem. Aunlolâ inanry adyesenry kehoem amânhedyly; kurâ domodo enanaym pylâ aiekâ — kelymo. Âwankuem tiendylymogue kulâ, arâ aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iukonodo lelâlâ wâne, Jesus Messiaslâ awyly neinwâmpyramo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus aguely: — Âtyam udâho oday inkâba awârâ. Âmaemo olâ âdalâ mydâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yeinwântânry modo âizemo lelâ, urâ olâ yizepamo. Anhekylymo inakai wâgâ auguelygue, yizepa awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Âmaemolâ âtyam idâwâtaungâ. “Idâ” mygueduomo kulâ inkâba ise âtyam udâly; Pabai ugonotuo ise udâly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Arâ adâkebygueduo, Galileiadâlâ wao Jesus iweâpa kuba olâ târâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Âtyam tukonodo idâpygueduo, Jesus idâwâm lâpylâ. Tutuzebalâ idâly, kurâdo nutubalâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judeu domodo iwymâry âtydâ nhuinlymo. Tonlo modo nhapâiguelymo: — Âdykâ Jesus? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Toenzepa iwâgâ aguewâni modo. Aguelymo: — Koendonro lelâlâ mâkâ — keim. Tâlâ, — Koendonro mâkeba mâkâ, konokuni kulâ — kewâni modo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tutuzenryenlâ Jesus wâgâ aguelymo, pymâdo indadyseba tawylymogue. Jesus wâgâ adâkeduo, tânagazedyly tyntadylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Âty quatro iguandyly sakadybyem awyly ume, Jesus idâly Deus etyam. Târâ taseray âtâdyguyby modo nhenomedâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pymâdo Jesus aguely tindatuo âsewânilymo; warâ aguelymo: — Kydâsenomedâdobyry ara nâsenomedâdaymba awâkâ, toenzepa olâ enomegu! Âdaraka awâkâ enomegu? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aituo Jesus in-hoguly: — Unârygue kulâ inkâba xirâ kâenomedâdylymo. Deus ugononibyry, “Aguekâ” kehobyrylâ, augueho. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pabai ize ato aieni modo xutuzemo Deus “Aguekâ” kehobyry augueho awyly; yangahu oday unâry kulâ mâkeba augueho awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tunâry tyangahu odano kulâ tagonroam egatuim tonomery wâgâ koendâ adâkehon-hoem kulâ aguely. Aunlo mâkeba olâ urâ. Unâ egatuim konokuni keba watay, tunâry kulâ mâkeba agueho, tugononibyry aguehobyrylâ. Tugononibyry mâkâ ehoguedyze ato, mâkâ mâkeba. Unâ egatuin-em Deus ingonotyby urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés myakâwândy Deus aguiendyse ato kâzewenry iweninri. Âmaemo olâ kâzewenry agueho mâinwâmpyramo. Yâze myguelymo, âdawipyralâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kurâ domodo aguely: — Tuândy kulâ âmâ! Diabu agonro keanra âmâ, arâ amyguehoem! Ânguy âze kewâpyra — kelymo: ");
INSERT INTO bkqNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","— Iweâ kulâ keankâ adyesenry agânhedyly. Tâwâneim kua kânhedyly. Tâzekobyzegueho oday agânhedyly awylygue mâseguâdâdâmo, yagâ âewiâpadâmo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Deus aguiendyse ato kâzewenryem saguhoenlâ Moisés iweniwâm. Warâ tâzezewenry wâgâ iwenibyem awyly: “Iamudo iwelo egaseyby tokalâ semana ipygueduo ilery ety iopiry satâwâdaungâ, Judeu tawyly nhenehon-hoem” kely. Moisés agâ inkâba kâzewenry tâjilery ety iopiry satâly adaguly, kydamudo agâlâ. Iamudo tokalâ semana ipygueduo, kâzewenry agueho arâ ilery ety iopiry mantâlymo, tâzekobyzegueho umelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iamudo ilery iopiry ety tâzekobyzegueho odaylâ kehoem tatâze âmaemo watay, nhewentâdaundâ, tâzekobyzegueho odaylâ tâwâneim kua kânhedylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Inakanhe aini mâentuomo, inepa kâzewentâdaundâ. Âkealâ, âkealâba warâ awyly koendâ mâuntuduomo lelâ ewentâdaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Aituo târâ Jerusalémdâ aguelymo: — Kywymârydo tyândyse atolâ awâkâ uguondo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Etaungâ! Notoendaymba awâkâ. Tarâlâ idânârâam aguely. Ânguy etadâze kewâpyra. Kywymârydo nutumo keanra Deus Ingonotyby Messiaslâ awâkâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kurâem olâ awâkâ Messias keba. Tutuzema kurâ awâkâ âdykonlo awyly. Messias âewyly watay, MOK alelâ ise âepanâguely. Ânguy âdykonlo mâkâ awyly nutuwâbyra ise — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Deus ety idaseray tienomedâday, kaynâ kehoem Jesus aguely: — Koendâ kehoem utudâ, âdykonlo wawyly tutuze warâ wâne âmaemo, inanajimo. Iozepa olâ arâ âunâgumo. Unâry wâgâ kulâ inkâba xirâ onro anaxi kâewyly; igonotybyem tarâ wawyly. Kewâdyly kulâ nitaymba mâkâ ugononibyry; tâinwânseim lelâlâ mâkâ agueho. Mâuntuba olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Urâ olâ tutuze ingonotybyenlâ mawânrâ kâewyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aguely tindatuo, sawâse kelymo. Ânguy olâ tâmary nhonwa niepyra, sawâto odayba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tonlo modo ewy agui Jesus tâinwânsemo myakâwâm. Aguelymo: — Messias âewyly-ro watay, adyesenry kehoem ise anhekyly, tâkezemo inanry. Awâkâ anhekyly takaze ânguy anientaymba. Arâ atayma Messiaslâ awâkâ-ro — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseu domodo, “Messiaslâ awâkâ Jesus” kely indadylymo. Aguely izepamo. Aituo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo agâ aguelymo. Deus ety donro guarda modoram warâ aguelymo: — Jesus sawâtaunda; enetaungâ xarâ-ro warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Arâ âturudaymo, Jesus aguely tonlo modoram: — Âdiempa kulâ ise agâmo wawyly. Inepa ise kodopâdyly mâkâ ugononibyryanlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uize âmaemo, iepyra olâ ise âmaemo, udâhoram mydâpa mawylymogue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Aituo aguelymo: — Âdyanka ise awâkâ idâly, kiempyra kitoem? Eagonro xidadâ modoam ise idâly, judeu keba modo ety anaxi enomedâzemo? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","— Âdakezeka enra awâkâ aguely: “Uize âmaemo, iepyra olâ ise âmaemo” kely? Xina nutuba enra awârâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Âty xypyry tohoguezeim kuru ume Jesus saudyly. Kaynâ kehoem aguely: — Yeinwântaungâ, âmaemo kâunduly mâenmakedyze donro modo. Yam âetaungâ, tatuanzeim paru enyze âeto ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xirâ Deus itaumbyry awo wâgâ iweniby enanâguewâdaungâ: “Yeinwânni modo iweloem âiehozemo, âdaunloenlâ Deus agâpa nâiehoba itomoem. Paru sawedânry ara ise iodaymo eon-hondânimobe awyly aunlolâ” — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Deus Ispiritury tâinwântaynrim modoam ingonokyly wâgâ ani Jesus aguely. Xirâ modo ume Deus Ispiritury eyanmo tugonoseba ani, xirâ anaynlâ Jesus awylygue, Tunwym tynrenseim ezaxi nâtâba awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aguely idanipyry modo aguelymo: — Âkealâ, Deus eynynâ agueinlâ awâkâ uguondo. Messias kinwânwânkylylâ awâkâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Einwântânry modo olâ aguelymo: — Messias mâkeba awâkâ. Galileiadâ kulâ mawânkâ âewyly. Mârâ eynynâ inkâba ise Messias âewyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Davi ipemugu ewy ise Messias” tâkeze myakâwândy Deus lelâlâ. Iazely ise Belémdâ, Davi iazehobyrydâ. Arâ mawânrâ Deus itaumbyry awo wâgâ iwenibyem awyly — kelymo. Belémdâlâ iazeypy Jesus awyly nutuba tawylymogue, arâ aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesus einwânni, einwântânry idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ânguy olâ myakâwâm nawâpyra. Einwântânry modo ewy Jesus tianwâdysemo ani. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Deus ety iguardary modo Jesus sawâse igonotyby modo odopâdylymo, fariseu domodo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo warâ eydâ atomoam. Aituo aguehonlymo: — Âdaituoka Jesus mâenepyra mawylymo? — kehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aituo in-hogulymo: — Ânguy mâkâ agueho ara kehoem aguewâpyra — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseu domodo iewiâpadaynly, aguelymo: — Mâkânra mâzenokuoaguimo lâpylâmy! ");
INSERT INTO bkqNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kywymârydo mâkâ neinwântaymba. Xina fariseu domodo ewy tokalâ mâkâ neinwântaymba. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Âdaunlo modo kulâ mâkâ einwânni. Kâzewenry wâgâ nâsenomedâdaymba akaemo, xina âsenomedâdo ara. Inakanhe âiehoze akaemo Deusram — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Akaemo duay tâlâ myani fariseu Nicodemos keho, kopae Jesus agâ agueze idâypy. Tataen-hodo aguely tindatuo, aguely: ");
INSERT INTO bkqNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","— Idânârâ kehoem kâzewenry tutuze kurâ. Koendâpa ânguylâ iguehoem aguely, eagâ aguykeba kulâ, warâ awyly tutuzelâ kurâ. Âdy anhetyby kiuntuba kulâ âsenagazedoem kienwentâdaymba kurâ. Xarâ kyjigâsene, tâsemaguehoem, âdara kely awyly kindatoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","— Galiléia donro modo mâkâ eynynonro ewy ara amyguely. Tutuzelâ âmâ, Galileiadâ Deus itaumbyry egatuim âdaunloenlâ ipa awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aituo kurâ domodo tâtyam idâwâdylymo. Jesus olâ idâly iwy Se Oliveira Ekaram. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kopaelâgâem pealâ Jesus odopâdyly Deus etyam. Ekadyly, tydâtyguyim modo enomedâdyly nhaguondyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nhenomedâdyly ume, fariseu domodo, Moisés inweniby enomedâni modo iwymârydo warâ Jesusram pekodo nhenewylymo. Eagonro uguondoam âdynanâoly emâmomy. Pekodoam aguelymo: — Tarâ ikâ idânârâ nhetodâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesusram aguelymo: — Konomedâni, ohogüimby merâ pekodo, eagonro uguondoam âdynanâoly xina netai olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Imeâgâemba kehoem merâ inakanhe aitobyry. Moisés kâzewenryem inweniby wâgâ: “Tuhugue tamytâze xyâwâtaungâ pekodo isoamba kulâ âdynanâoim” kelype. Âmâ-ro, âdara tâkeze âmâ? Tâwâlâ tuhugue xina nhâly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Awârâ arâ nhapâiguelymo, Jesus âdalâ kulâ in-hoguly-ro watay tienwentâdomoem. “Tyâzepa awâkâ pekodo nidâ” kely-ro watay, “Kâzewenry neinwântaymba awâkâ Jesus” tâkezemo tâise. (“Xyâly lelâ awâkâ pekodo” kely-ro watay, “Nityendaymba awâkâ” tâkezemo tâise warâ.) Nhapâiguehomo nihoguba Jesus; enagozely lelâ, tâmary ewilygue onro wâgâ inwenily lelâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mâkâ pekodo wâgâ sapâiguezezemolâ. Aituo iwykaudyly, aguely: — Âmaemo ewy âdaunloenlâ inakanhe aitânrybe-ro watay, tâwâlâ waunroem merâ pekodo onwa tuhu name — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Agueypyem âzewyondyly. Onro wâgâ inweniondyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesus arâ agueduo, idânârâ tutuzemo mawânkâ Deus izepa ato aieni lelâ tawylymo. Aituo tokalâ, tokalâ warâ âxiguewâdylymo, agaityom modo waunroem kuru âxigueim. Ânguy peba idyly, Jesus, pekodo alelâ âxiâim. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aituo Jesus iwykaudyly, nhapâiguely: — Âdykâ âiguehoem iwentâni modo nitaimo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","— Ânguy lâpeba, Pymâ! — kely pekodo. — Âhoem auguewâpyra lâpylâ urâ. Iweâma idâ, inakanhe adâitonzeba olâ ikâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus agueondyly Deus ety idaserano modoram: — Iajinu wâne kydadakobâdo tâsagonze, myara lâpylâ ywâgâ âdara Deusram tadaindyly xutuly. Yeinwântaynrim modo Deus agâpa tyetunebamo ise. Igueduomo, idâzemo lelâ aunloenlâ eagâ tâitomoem. Ize ato ara adâidyly xutuzemo. Iamu odaypa ise adakobâdylymo, ânwa tyajineim odakâ adakobâdylymo waunlo ara ise — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseu domodo eyam aguely: — Âwâgâlâ awârâ amyguely. Ânguy âkealâ amyguely awyly eon-hondâni lâpeba. Awylygue amygueho âdyem nipyra awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aituo Jesus aguely: — Âkealâ ywâgâ auguely, tâinwânseim xirâ augueho. Idataungâ auguely. Tutuze urâ, âdykâba kâewyly, âdyam udâly warâ awyly. Âmaemo olâ mâuntubamo âdykâba kâewyly, âdyam udâly warâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ywâgâ koendâ mâuntuba lelâlâ wâne âmaemo, arâlâ olâ nhewentâdylymo. Ânguy ewentâze inkâba kâewyly, emakeze lakuru. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","“Inakanhe kulâ mâkâ aidyly” uguely watay olâ; âkeá lelâlâ auguely. Yagâlâ Pabai ugononibyry; auguehobyry modogue yagâ tâseinwânze mâkâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kâzewenry wâgâ iwenibyem: “Azagâ kurâ âkealâ aguelymo-ro watay, aguehomobyry tâzeinwân-honze” warâ iwenibyem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tâlâ azagâ âkealâ ywâgâ agueim, urâ, Pabai ugononibyry warâ. Awylygue xina agueho tâinwânseim lelâlâ awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Akaemo aguely: — Âdykâka Pabai mygueho? — kelymo. Aituo Jesus in-hoguly: — Ânguy wawyly mâuntuwâbyra âmaemo. Pabai koendâ mâuntuwâbyra âmaemo warâ. Utulymo-ro watay, Pabai tutuze lâpylâ tâise âmaemo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus xirâ modo wâgâ aguely, Deus ety idaseray tienomedâdaymo. Deusram dinheru xuduypy etadâdo kaixa iwaguepa. Tâwâlâ wâne izepaom modo agueho izepa awylymo, ânguy olâ nawâpyra, sawâto odaypa awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus aguely: — Idâze urâ; uize âmaemo-ro warâ. Inakanhe amitomobyry tygakezebalâ ise âiguelymo. Awylygue ise udâhoram mydâpa mawylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aituo judeu domodo adapâiguelymo: — Âdyanka ise awâkâ idâly, kytâba kitoem? Âdyâly ise? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus aguely: — Taunlo onwogonrolâ âmaemo. Urâma kaynonro. Xirâ ananolâ âmaemo, urâ olâ xirâ anano keba. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yeinwâmpyra lelâ âmaemo-ro watay, inakanhe amitomobyry tygakeduneba ise. Inakanhe amitomobyry wâgâ tâzewentâgueozelâ ise âiguelymo, URÂLÂ URÂ kelygue tâzekeim mâinwâmpyra âmaemo-ro watay — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aituo nhapâiguelymo: — Ânguyka âmâ? — kelymo. Aituo in-hoguly: — Tutuzelâ âmaemo, aunlolâ inanry ywâgâ auguezesedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Toenzepa âwâgâmo auguehobe wâne urâ. Augueho mâinwâmpyra olâ âmaemo, Deus ize ato amânhepyra mawylymo kâuntuen-hondyze wato. Mâkâ ugononibyry olâ kewâdyly kulâ waypa. Xirâ anano modoam auguehoem aguehobyrylâ augueho — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nutubamo myani mâkâ “Ugononibyry” keduo, tunwym Deus wâgâlâ aguely awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Awylygue Jesus aguely: — Iwerâ ânguyem wawyly mâuntuwâbyra âmaemo. Yiguehoem kruz onwa yakâjibygueduomo, xutuze âmaemo, Uguondo Kaynâpa Âetyby wawyly, mâkâ URÂLÂ URÂgue tâzekeinlâ wawyly. Xutuze âmaemo, Pabai auguehoem aguehobyrylâ kâenomedâdo awyly, yangahu oday unâry kulâ mâkeba. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yagâlâ ugononibyry, urâ kulelâ yânwâpyra, ize ato lelâ mawânrâ agânhekyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Arâ aguely tindatuomo, agui kehoem einwânmâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aituo Jesus aguely: — Augueho mâinwândylymo-ro watay, yagonroem lelâlâ ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ânguy wawyly koendâ mâuntulymo-ro watay, xutuze âmaemo, auguely âkealâ awyly. Mâuntuduomo, âzemakeoze âmaemo, mâkâ âuturimo emaymba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aituo aguelymo: — Abraão iweompyrylâ xina. Âdykâ ânguyam xina nâdutuoba, xina tawâseba warâ. Âdaituoka “Mâkâ âuturimo emaymba âzemakeoze âmaemo” myguely? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","— Diaburam kulâ Deus izepa ato aietaynrim modo âdutuoly. Inakanhe adâjidyly nimopamo. Diabu mawânkâ Deus izepa ato aiesezeni modo iwymâry; Satanásgue tâzekeim lâpylâ mâkâ. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mâkâ kurâ adanâhoymby, tâwâlâ vende âieholy eagonro emaryem. Mâkâ imery olâ, aunlolâ imeryem awyly; âdaunloenlâ tunwym xurâempa nipyra. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Deus imery urâ. Diabu emaymba imakelymo-ro watay, mâkâ mâinwântondaymba ise âmaemo. Aunlolâ inakanhe amitomoem aguehobyry amânhetombyra ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraão iweompyry lelâlâ wâne âmaemo. Arâlâ olâ, yâdyse mawylymo, inomedâdomo mâinwândyseba mawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pabai yam nhenehoymby inanry augueho. Amânhekylymo olâ, Diabu amânhetomoem aguehobyry kulâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aituo aguelymo: — Abraão iweompyry xina. Mâkâ aitobyry aralâ mawânrâ xina aidyly — kelymo. Aituo Jesus aguely: — “Abraão iweompyry xina” tâkeze wâne âmaemo, Abraão aitobyry arapa olâ amidylymo. Abraão aitobyry ara amidyse âmaemo-ro watay, Deus ize ato tâise amânhekylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Âkealâ Deus aguehobyry kâindatyby inanry âyanmo augueho. Arâlâ olâ, yâze myguelymo. Awârâ amânhedyse matomo emyenro anientaymba akâwândy Abraão! ");
INSERT INTO bkqNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Unwânmo Diabu aito ara kulâ amidylymo — kely. Aituo aguelymo: — Diabu imeom mâkeba xina! Tokalelâ xina nhunwym, Deus lelâ. Deus imeom lelâlâ xina — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aituo Jesus aguely: — Deuslâ unwânmo-ro watay, ywynedâ tâise âmaemo, Deus ingonotybyenlâ mawânrâ tarâ wawyly. Âwâlâ kulâ inkâba kâewyly. Deuslâ mawânkâ ugononi. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Âyanmo augueho tydase lelâlâ wâne âmaemo, inomedâdyzemo wato mâuntudyzeba olâ âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Diabu imeom kulâ âmaemo; ize atolâ mawânrâ amânhedyse matomo. Adagudaylâ Diabu kyârin-em awyly. Iozeno modo iduery kulâ mâkâ. Aunlolâ mâkâ kewâdyly kulâ awyly. Kewâdyly kulâ-ro watay, tâzewenrylâ mâkâ agueho. Augueondyly, konokuni kulâ mâkâ, idânârâ tâdâsenogudo modo adaguholâ mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Uguewâdyly kulâ witaymba urâ, âmaemo olâ yeinwândysebamo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Idânârâ âmaemo, inakanhe awipyra wawyly, tutuze âmaemo. Ânguy ienwentâni lâpeba. Awylygue augueho einwântaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Deus xurâ modo mawânkâ Deus agueho tâinwânsemo. Mâkâ mâinwâmpyra mawylymo, xurâ keba mawylymogue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aituo tonlo modo judeu domodo eyam aguelymo: — “Âkealâ enra Samaria donro modo emyenro kulâ âmâ kadopâbeom” xina kely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aituo Jesus aguely: — Kadopâbeom mâkeba urâ. Pabai ugueho tynrense urâ; âmaemo olâ yrempyramo âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Won-honru wâgâ, koendonroem wawyly wâgâ warâ auguepa wâne urâ. Pabai olâ ywâgâ koendâ adâkeze. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Idânârâ auguehobyry einwântaynrim modo niguewâpyramo ise. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Arâ Jesus aguely tintaduo, judeu domodo iwymârydo, aguelymo: — Iweâma tutuze xina, kadopâ agâ kulâ mawyly! Iweâpa myakâwândy kydamu Abraão iguely. Idânârâ saguhoem Deus eynynâ agueim modo lâpylâ iguewânmo. Warâ olâ amyguely: “Idânârâ auguehobyry einwântaynrim modo niguewâpyramo ise” myguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kydamu Abraão, saguhoem Deus itaumbyry egatuwânibyry modo alelâ iweâpalâ myakâwândy iguelymo. Akaemo takaze tynrenseim mâkeba âmâ! Uguondo tynrenseim mawyly tâgaese wâne âmâ, âdy keba olâ âmâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aituo Jesus aguely: — Ywâgâ kulâ koendâ auguely-ro watay, augueho modo âdyem nitaymba tâise. Urâ lelâ ywâgâ koendâ aguein-ro watay, ânguy auguehobyry neinwântaymba tâise. Pabai olâ ywâgâ koendâ agueim, mâkâ “Xina iDeusry” myguehomolâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Âdykâ Deus mâentaymba âmaemo, urâ olâ tâense. “Kâuntuba urâ” uguely âyanmo-ro watay, uguewâdyly kulâ tâise. Koendâ kehoem tutuze, tâinwânse warâ olâ urâ yam agueho modo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kydamu Abraão toenzepa iomazewâm, tarâ xirâ onro anaym wawyly tientuo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","— Âwâ! Cinquenta anu peba kuru maze-ro. Iweâpa lelâlâ myakâwândy Abraão iguely, azely iraynâlâ. Abraão mâentaymba âmâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aituo Jesus aguely: — Abraão iazely iray, tâlâ wakâwâm — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesus aguely tindatuomo, tyândyse idylymo. Tuhu nhanâdylymo, nhonwa tiamehomoem. Totoenze olâ ani. Aituo Deus etydâba egasely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Alâ ani tadakobâday Jesus uguondo epyem iazeypy nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aituo xina Jesus nhapâiguely: — Konomedâni, âdaituoka awâkâ uguondo epyem iazely? Izepa tato aieniem awyly xutuwâm Deus? Nhunwyndo inakanhe aitobyry wâgâ? — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aituo Jesus in-hoguly: — Awârâ modo wâgâ inkâba. Awâkâ arâ iazely, Deus eon-honru iwâgâ âzehohoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tâmaryem akâwâm Deus xirâ anaxi ugonodyly. Peto oday lelâ kydâsewanily. Arâ lâpylâ Deus aguiendyse ato aguyjiene, kydâsewaniho nhuduly umelâ. Inepa mawânrâ ise xurâem aguipyra kito saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Xirâ anaym wawyly ara, âdara Deusram tâdâtâly awyly wâgâ konomedâdâ urâ; âdyam kytâly awyly kientoem iajimanâni emyenro urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Arâ aguenripyryem, Jesus KUITÚ kely onro onwa. Onro tâdakugue nhepizeândyly. Aienibyryem epy enu onwa PYRY PYRY nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Aguely: — Idâ, Siloé donro paru etaryam âzemelagoguera — kely. (“Mâkâ igonotyby” keze Siloé kely.) Epy idâly âzemelagogueze. Odopâdyly, tâense lelâ, Jesus kua nhetybyem. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ety iwaguepa tâtyuneim modo mâkâ epyemba awyly nhedylymo. Saguhoem dinheru nhekadyly enipyry modo lâpylâ koendâ tâense awyly nhedylymo. Aituo âseguâdâdylymo, aguelymo: — ÂH! Mâkâ epy ekadybyem, sakani modoam dinheru ekanibyrylâ awâkâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","— Mâkâlâ — kewâdylymo. — Mâkâ mâkeba. Emyenro kulâ awâkâ — kelymo. Mâkâ olâ warâ aguely: — Mâkâlâ urâ, epyem iazeypylâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aituo nhapâiguelymo: — Âdaraka amidyly kua mitoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aituo in-hoguly: — Mâkâ uguondo Jesus keho enra ikila ienu onwa PYRY PYRY ieni. “Idâ, Siloé donro paru etaryam âzemelagoguera” keanry-ro warâ. Aituo enra udâly. Kâzemelagogueagui. Iwerâ tâense urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","— Âdykâka mâkâ uguondo? — kelymo. — Kâuntuba aze — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Tâzekobyzegueho oday Jesus epy kua nhedyly. Aituo mâkâ kua ietyby fariseu domodoram adaholy. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseu domodoram adapâigueoly: — Âdaraka kua midyly? — kelymo. — Mâkâ uguondo kua yenipyry onro enra ienu onwa PYRY PYRY nhekyly. Parugue kâzemelagoguehoem agueanry. Âzemelagogueybyenlâ enra kâendyly-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fariseu domodo ewy aguely mâkânra: — Mâkâ kua âenipyry, tâzekobyzegueho oday mâkâ aidyly. Arâ atayma Deus ingonotyby mâkeba mâkâ uguondo-ro; adyesenry mawânkâ anientai tâzekobyzegueho oday — kelymo. Tâlâ olâ fariseu domodo ewy wakeim: — Deusram aguehomba adyesenry anhetoen-ro watay, Deus eon-honru tienehon-hoem adienkyly anientaymba tâise — keim. Jesus Messias awyly einwânni, einwântânry tâisemo ani. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aituo eyam agueondylymo: — “Epyemba yetai mâkâ” mygueanse. Âdara mâkâ wâgâ âunâry? — kelymo. — Ienanaji, Deus eynynâ agueinlâ mâkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pymâ domodo mâkâ aguely neinwâmpyramo. Aituo aguelymo: — Myguewâdyly kulâ. Epyem inkâba ani azely — kelymo. Awylygue sodo modo ingâsedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Sodo modo saintuo, nhapâiguelymo: — Âmerymoka awâkâ, epyem iazeypy myguehomo? Âdaituo pylâka iwerâ nhedyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aituo in-hogulymo: — Xina imerylâ awâkâ. Tutuze xina epyem iazeypy awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Âdara kua itobyry olâ xina nutuba. Ânguy kua ieni awyly xina nutuba lâgâlâ warâ. Xutuybyem mawânkâ. Awâkâlâ sapâiguewâdaungâ. Awâkâlâ ise âyanmo egatuim — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Arâ sodo modo aguely olâ mârâ âtâ tâdâtâdyguyho odaypa tâzegaseonlymo xytaze, “Jesuslâ Messias” kelymo-ro watay. “Deus Ingonotyby Jesus awyly einwânni-ro watay, âtâ tâdâtâdyguyho odaxi negawâmpyra ise” tâkeze akâwâm pymâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Awylygue mawânkâ: “Xutuybyem awâkâ. Awâkâlâ sapâiguewâdaungâ” kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aituo mâkâ uguondo kua ietyby ingâsenehondylymo. Aguelymo eyam: — Amyguely idaselâ awâkâ Deus. Awylygue âkeá lelâlâ xinaram aguekâ. Tutuze xina, Deus izepa ato aieni awâkâ kua âenipyry awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aituo in-hoguly: — Deus izepa ato adyese, aniempyra warâ awyly kâuntuwâbyra urâ. Kâuntuly epybyryem wawyly, iwerâ tâense urâ, mâkâ kua nhetybyem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aituo nhapâigueondylymo: — Âdaraka enra aidyly? Âdaraka enra epyemba âedyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aituo uguondo in-hoguly: — Azagâ lelâ âyanmo augueaki, yeinwâmpyra olâ âmaemo. Auguehobyry kompâzedyly-ro watay, mâinwâmpyra mawylymo, tutuze urâ. Mâkâ kua yenipyry mâinwândysemo lâpylâ âmaemo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aituo mâkâ agâ toenzepa kehoem iewiâpadylymo, aguelymo: — Âmâlâ mâkâ eynynonro, xina mâkeba! Moisés inweniby lelâ xina nheinwânkyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Deuslâ, Moisés kydamudo nhenomedâdoem agueim awyly, tutuze xina. Âdy Jesus wâgâ xina nutuwâbyra. Ânguy aguehoem igononi awyly xina nutuwâbyra warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aituo mâkâ uguondo aguely: — Âwâ! Kua nhetybyem wawyly tâenselâ âmaemo. Toenzepa kâseguâdâdyly, Deus ingonotybylâ mâkâ awyly mâuntuba mawylymogue! ");
INSERT INTO bkqNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Deus tynynonro keba modo nhekadyby nudupa awyly, tutuzelâ kurâ, izepa ato aieni nhekadyby nuduwâpyra. Tynynonro modo nhekadyby lelâ anhekyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","— Kaudyly umelâ ânguy epyenlâ egaseyby kua tyese kely tydatuneba. Ânguy awâkâ uguondo ara aieni lâpeba. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iwerâ olâ Jesus kua yetai. Deus keba igononi-ro watay, kua yetaymba tâise — kely uguondo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","— Epyem azely Deus izepa ato aienilâ mawylygue. Awylygue xinaram arâ kehoem adâkezeba ikâ — kelymo. Aituo, âtâ tâdâtâdyguyho odaypa nhegaseândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Âtâ tâdâtâdyguyho odaypa uguondo egaseândobyry xutuwânmy Jesus. Awylygue nhuinly. Tientuo, nhapâiguely: — Mâkâ Uguondo Kaynâpa Âetyby tâinwânse âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aituo uguondo aguely: — Kâinwândyse urâ. Ânguy awyly yam aguekâ, ânguy amygueho awyly kâuntuhoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","— Tâenselâ âmâ! Eagâlâ amyguely! Urâlâ Uguondo Kaynâpa Âetyby — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesus aguely idanipyryem, âzeguhoam idyly enado, tynrentoem, aguely: — Pymâ, âinwântâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus aguely: — Xirâ anaxi kâewyly, ânguy yeinwânni, yeinwântânry warâ awyly âdutuhomoem. Epy modo wâne tyajine awyly nutuba myara Deus xurâ kebaom modo, nutuba awylymogue. Yeinwântaynrim modo olâ Deus xutuzemo, epybyryem kua ietybymoen-ro waunlo ara — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseu domodo ewy eydâ iwaguepalâ. Aituo aguely indadylymo. — “Epy ara” mygueduo, xinaranlâ enra amyguely? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aituo Jesus in-hoguly: — “Xina Deus nutuwâbyra, tiuntudyze olâ xina” myguelymo-ro watay, Deus tygakeze tâise izepa ato amânhetomobyry. Tâwâlâ kulâ olâ, “Koendâ Deus tutuze xina” myguelymo, yeinwâmpyra kulâ. Arâma inakanhe amitomobyry tygakezeba awyly tânehonze awârâ. Deus xurâem, epy emyenro kulâ âmaemo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus aguely: — Idataungâ auguely. Kaneru sodo kura odaxi pyanta oze egawândyly. Tâmagazeinma tâzegawânto ozepa egawândyly, sahodâdobyry nhakaguyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaneru sodo tâzegawânto oze egawânni. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Egawântoem pyanta tâzenahugueoze. Ezedy wâgâ sodo tâguy ingâsedaynly. Todo itanru tydase kaneru. Kura odaypa nhetaguewâdyly. Poji nhaguhomoem nhadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Waunroem idâly, eguydo nhapygue-ro warâ, todo itanru tydase tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tiuntudânry kulâ niampyguedaymba. Itanru âkeloem awylygue, tâwenkeze lelâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kaneru todo nhutuho ara, “Yeinwânni modo utuly” keze ani Jesus aguely. Kaneru wâgâ kulelâba aguely awyly, nutubamo olâ-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aituo Jesus aguely: — Kura iwyantary emyenro urâ. Pyanta oze kaneru domodo tâtary odaypa egasely poji aguze, egawântondyly tâxidâdomoem warâ. Arâ lâpylâ ywâgâ lelâ Deusram tâdâtâhoem wawyly. Xirâ mâuntudyzemo kuru wato. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Xirâ onro anaxi kâewyly iraynâ, toenzepa akâwâm “Deus Ingonotyby urâ” kewâni modo. Kewâdylymo kulâ olâ-ro warâ. Kaneru emagazeni emyenro kulâ akâwâm akaemo kewâdyly kulâ waunlo modo. Ynynonro modo olâ akâwâm aguelymo niwantaguebyramo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Deus eydâ atoam tâzegawântolâ urâ. Tâsemaguehoem wâne kaneru kura odaxi tâgawânse myara ynynonro modo kâenmakely. Kaneru sodo tâguy poji anaym awyly ume tânuagaenzelâ myara lâpylâ ynynonro modo kâendyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kaneru domodo emagazeze, inwenkeze, xyâze warâ kulâ tâmagazeim âewyly. Urâ olâ ynynonro modo emakeze kâewyly, igueduomo Deus agâ aunloenlâ itomoem lakuru. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","— Kaneru sodo koendonro emyenro urâ. Koendâ tâguy nhedyly; emakezemo tâigueze warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Tâlâ olâ dinheru tienmakehoem kulâ kaneru eni, sodo keba olâ mâkâ. Auwa âepanâguely watay, todokeze lelâ. Aituo auwa kaneru nhawâdyly, ipemugudo adapâeguyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mâkâ kaneru odo koendonro emyenro urâ. Utudâ Pabai; Pabai tutuze urâ warâ. Ynynonro modo tutuze lâpylâ urâ, kaneru odo koendonro tâguydo nhutuho ara. On-hondybyem urâ, ynynonro modoem yiguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tâinkâ lelâba ynynonro modobe awyly. Utuzemo, yeinwânsemo warâ. Tokalâ âjiam lelâ ise ynynonro modo kâindâtyguyly, kâentomoem, kaneru odo koendonro, tientoanlâ tâguy indâtyguyho ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","— Toenzepa Pabai ywynedyly, yeinwânni modo emakeze iguein-em wawylygue. Yigueduo, kurâem itonze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ynynonro modo emakezelâ ise yiguely, awidyse wawylyguelâ. Aypa-ro watay, ânguy yâwâpyra tâise. “Igueze âmâ, kurâem itonze âmâ warâ” Pabai kehobyry aralâ ise awidyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Awârâ tindatuo, judeu domodo nâseinwâmbyra idylymo Jesus wâgâ, aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","— Kadopâbe itybyem awâkâ! Awylygue âindâ kulâ awyly! Aguely kâjiwantaguedaundâ — kelymo. Tâlâ olâ warâ aguewâni modo: ");
INSERT INTO bkqNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","— Kadopâ agonro arâ aguewâpyra, epy kua nietaymba warâ! — kewâni modo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Azagâ nunâ sakabygueduo, kopâ ihuguely adaguly ume, âty “Deus Ety Koendâ Ietobyry Enanâgueho” saindyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Deus ety ivarandarydâ Jesus adakobâdyly, Salomão intânehoymbydâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Târâ atay, eydâ âtâdyguyby modo aguely: — Xina kâzenokudâ. Deus Ingonotybylâ âmâ? Mâkâ keba? Koendâ aguekâ, xina nhutuhoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aituo Jesus in-hoguly: — Deus Ingonotybylâ urâ, ugue. Yeinwâmpyra olâ mataunaguynre. Pabai eon-honrugue adyesenry modo ajiedâ, mâkâ ingonotybylâ wawyly kâenehohoem. Agânhekyly modo mâkâlâ ugononi awyly xutuen-hoim. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ynynonro keba mawylymogue olâ Deus Ingonotyby wawyly mâinwâmpyra mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ynynonro modo ytanru tydase; idânârâ utudâmo warâ. Kaneru todo itanru tindatuo, eyam tâtâze myara ynynonro tawylygue, auguehobyry anhedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ynynonro modo aunloenlâ Deus agonroem ienehonze urâ. Igueduomo eagâmolâ ise Deus. Typygueim keba ise eagâ awylymo. Iemakoaymo waunlo ara kehoem ise; ânguy iemaymba nhemakelyemba kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Pabai won-honru nhuduypy, idânârâ takaze kehoem imâem awyly; ânguy mâkâ emaymba nhemakelyem inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tokalelâ xina Pabai agâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesus aguely tindatuo, iopano modo tuhu nhanâtondylymo Jesus tyân-homoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aituo Jesus eyanmo aguely: — Inumo angataylâ keankâ koendonro modo agânhedyly, Pabai “Aiekâ” kehobyry ara. Âdaunlo agânhekyly wâgâka tuhugue yâdyse mawylymo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In-hogulymo: — Koendonro amânhedylygue inkâba xina âdyse awyly, Deus mâunâguedylygue. Xina emyenro kulâ âmâ, uguondo, Deus agâ âzekiba ise kerim. Awylygue xina tuhugue âdyse awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aituo Jesus eyanmo agueondyly: — Warâ Deus itaumbyry awo wâgâ iwenibyem awyly: “deuslâ âmaemo” kely Deus eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Âkealâ Deus itaumbyry awo wâgâ iweniby aguely awyly, tutuze kurâ. Deuslâ akaemo deusgue ezetâni awyly, tutuze kurâ, saguhoem kuru iwâgâ aguewâtyby modo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Deuslâ xirâ onro anaxi ugononi, aguehobyry aiese. “Deus imery urâ” ugueduo kulâ, “Deus nhunâguedyly awâkâ” myguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pabai “Aiekâ” kehobyry agânhepyra urâ-ro watay, âdy wâgâ yeinwântaymba tâise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Auguelygue kulâ yeinwâmpyra âmaemo-ro watay, agânhekyly mâentuomolâ einwântaungâ. Pabai Deus agâlâ wawyly, yagâlâ Pabai Deus awyly warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aguely tindatuomo tyanwâdyse idylymo. Âsemaguewâm lelâ olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aituo Jesus târâpa âxiguely. Paru Jordão kuyam idâondyly, João kurâdo batiza nhetobyryam. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Toenzepa myani xuiwâni modo aguely: — Merâ uguondo adyesenry modo anhedyly ara, âdy aniempyra wâne ani João. Âkealâ olâ mykeankâ merâ uguondo wâgâ aguely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Agui tonlo modo Jesus tâinwânsemo myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tâlâ ani uguondo, Lázaro keho, Betânia donro, Maria, Marta warâ iwiry. Tâwâne myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Mâkâ Maria, Pymâ Jesus ihuru onwa uriza nhapâdyly, tyangahudugue in-hugoguely itybylâ mâkâ.) ");
INSERT INTO bkqNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Paru Jordão kuynâ Jesus awyly ume, Lázaro eaundudo kurâ ingonodylymo Jesusram: — “Pymâ, toenzepa enra ataen-ho mâinwyneguyly ewânu!” kera. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aguely tindatuo, Jesus aguely: — Tutuze urâ, Lázaro ewânu toenzepa awyly. Tâwânugue igueze, igueypyem lelâ nâtâzezebyra olâ ise. Mâkâ aidyly tientuo, toenzepa ise aguelymo: “Koendonro, ton-honreim warâ awâkâ Deus. Koendonro, ton-honreim warâ lâpylâ imery” kezemo. Aituo ise urâ, Pabai Deus warâ xina âdyren-honly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Toenzepa Jesus inwyneguyly mykâinane Maria, Marta, Lázaro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Toenzepa Lázaro ewânu kely tindatuo, myarâ idâze nadahulebyra ani; azagâ emedyly takaze wao mârâ âjidâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Aituo xinaram aguely: — Judéia yan-yam kydodopâne — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xina olâ warâ aguely: — Konomedâni, iweâ kulâ keankâ kypemugudo, judeu domodo, tuhugue âze kelymo. Myarâ kydodopâbyra koendâ kydawyly — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Aituo Jesus xinaram aguely: — Odopâdonze urâ. Kopaelâgâembaba xixi iatygu doze horas ara lelâ. Peto oday adakobâni modo nâjihodaigâdaymba, xixi wâgâ. Kopae adakobâni modo olâ tâjihodaigâze, iamu oday tâtâho nepyra tawylygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aituo Jesus xinaram agueondyly: — Xykyly kulâ mâkâ kataen-ho Lázaro. Xuagueânse olâ urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","— Pymâ, xykyly kulâ watayma, koendâ ise lelâ-ro — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","“Igueypyem Lázaro” keze olâ ani Jesus aguely. Xina nutuba olâ âdakeze aguely awyly. Lázaro xykyly kulâ-ro waunlo ara, xina enanaji. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aituo koendâ xina nhutuhoem Jesus aguely: — Lázaro nigue. Ipa kuru nidâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Lázaro iguely iraynâ udâpa wawyly keankâ, won-honru mâentomoem. Âkealâ kuru yeinwântuomo, toenzepa ise womaru. Inoro, âguedy kyzeta — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aituo Tomé, Azagonropyry kelygue tâzekeim, xinaram aguely: — Inoro lâpylâ Jesus nhâduomo eagâlâ kyiguehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Aituo xina Betânia iwaguepa saindyly. Jerusalémdâ iwague kuruba mârâ âji, três kilômetros awârâem. Âguedy eaundudopyry etyam xina saindyly iraynâ, uguondo saindyly xinaram agueze: — Ipa Lázaro nigue. Eguepybyry tuhu imâsedo odaji xina nhetadâdobyry quatro iguandyly idyly iwerâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Toenzepa eaundudopyry itynrumo. Toenzepa ipemugudo idâly, âkelo kurâ domodo warâ etubanâzemo, iwirymo iguehobyry tiuntuduo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesus tâtyam saindyly egary tindatuo myani Marta iose idâly, Maria olâ âtâdâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Aituo Marta Jesusram aguely: — Tarâlâ âmâ-ro watay, wi niguewâpyra tâise keankâ! ");
INSERT INTO bkqNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Igueypyem lelâlâ wâne, tutuze olâ urâ, Deusram mâenkaduo amyguehobyry adyese awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aituo Jesus eyam aguely: — Igueypyem lelâ idâzesedyly nitaymba ise âwiry. Kurâem itonze lelâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","— Xypyry etay kurâem itondyly, tutuze urâ — kely Marta. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aituo Jesus aguely: — Iguewâtyby modo kurâem ietoni urâ, aunloenlâ typyguenryem itomoem. Tâwâlâ ise yeinwânni modo iguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yagâpa nitaymbamo ise yeinwânni modo. Deusram ise, tyigueduo, idâlymo aunloenlâ eagâ tâitomoem, nigueontaymbamo ise. Tâinwânse âmâ? — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","— Idânârâ amyguehobyry modo tâinwânse urâ. Deus, “Xirâ onro anaxi igonose urâ” kehobyrylâ mawyly tâinwânse urâ. Deus imery lelâlâ mawyly tâinwânse urâ warâ — kely Marta. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Agueypyem Marta idâly tywidyam agueze. Tydawere aguely, ânguy nidapyra itoem. — Idy, Jesus naintai. Âgâsedyly-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Awârâ tindatuo myani Maria inepa kehoem saudyly. Jesus agâ oxioze idâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Etymoam kuru Jesus naimpyralâ, Marta agâ xina oxiodobyrydâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Târâ âtâ oday Maria etubanâze idâypy modope myani. Mâkâ saudyly, tâmaegoze kehoem egasely tientuo, tâgasezemo lâpylâ myani. Aituo nhapygue idâlymo, — Âguedy etadâdobyryam keanra idâly ohogüenze — tâkewâduomo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesus eydâ atoam saintybyem, Maria âzeguhoam idyly enado. Aitybyem eyam aguely: — Tarâlâ âmâ-ro watay, wi niguewâpyra tâise keankâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aituo Jesus, Maria eogunru nhedyly; eagonro modo eogunru nhedyly lâpylâ warâ. Aituo Jesus toenzepa itywandyly, tuoday âsewânily warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aituo nhapâiguelymo: — Âdykâka keankâ Lázaro eguepybyry mâentadâdylymo? — kely. — Egârâ, Pymâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus eogumadyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aituo tonlo modo aguely: — Lázaro tywyneze lelâlâ galâ awâkâ Jesus! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tâlâ olâ wakenri: — Epy kua niedâ awâkâ. Ton-honreba olâ keankâ Lázaro niguepa itoem aiese — kerim. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus idâly Lázaro eguepybyry etadâdobyryam, tâtagueim tuhugue tânahugueinram. Toenzepa kehoem itywandyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aituo aguely: — Awârâ tuhu etywâdaungâ! — kely. Aituo âguedy eaundupyry Marta aguely Jesusram: — Alâ nidâ! Tywângue awâkâ! Etadâdobyry quatro iguandyly idyly iwerâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aituo Jesus aguely: — “Yeinwântâ lelâlâ âmâ-ro watay, Deus eon-honru ese âmâ” uguehobyry mâenanâguebaka âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aituo mârâ tuhu imâsedo nhetylymo. Jesus kayam MYK idyly, aguely: — Pabai, tuomare urâ, âyam auguely tydase mawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ydatâlâ mawyly tutuze urâ, tâwâlâ lelâlâ wâne yangahu oday kulâ unâgu. Ago olâ iwerâ auguely, merâ kurâ domodo auguely indatoem, âmâlâ ugononi awyly nheinwântomoem warâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Arâ adâkebygueduo adaenkely: — Lázaro, igasegâ kuohoram! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aituo Lázaro kurâem itondyly, egasely. Ituwyn-hobyry aralâ, ixinary, ihuru, ewâry, emary alelâ. Panugue emyan-huymbyem awyly. Aituo Jesus aguely: — Awârâ ituwyn-hobyry etywâdaungâ, adakobâdoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesus Lázaro kurâem nhetonduo, judeu domodo Maria etubanâze idâwâtyby modo ewy nheinwândyly lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tâlâ olâ myakâwâm fariseu domodoram aitobyry egatuze idâim. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aituo fariseu domodo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, judeu domodo iwymârydo warâ âtâdyguylymo. Âjigue aguelymo: — Âdakiendylyka awâkâ Jesus? Adyesenry modo kehoem awâkâ anhekyly. Kurâ domodo aidyly tohoguezemo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Alâ aguienehonzezedyly-ro watay, idânârâ kurâ domodo awâkâ einwânsemo lâpylâ. Aituo ise kywymâry Roma donro modo kagâ iewiâpadaynlymo. Kagâ âseguebyze âesemo, kainzemo, Deus ety sakalaguezemo warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ilâem Caifás myakâwâm kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru. Aituo myani aguely: — Âdy mâuntuwâbyra âmaemo! ");
INSERT INTO bkqNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jesus kydyâen-honre, kydadainhopa kitoem! Tokalâ iguelylâ ise koendonro, idânârâ kyiguepa kitoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Âdatâkely awyly nutuwâbyra myani mâkâ. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry lâwâne mâkâ ilâem, Jesus izetonro keba olâ myakâwâm. Alâ wâne, Deus nhutuen-honly, Jesus, judeu domodoem iguely awyly. Tyangahu odano kulâ mâkeba myani mâkâ agueho, Deus nhutuen-hoymbylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kurâ judeu domodoem kulelâ inkâba Jesus iguely, idânârâ kurâdo onro anano modoem. Mâkâ iguely, idânârâ tâinwânni modo tâinkonro lelâba, mâkâ nheinwântomoem, tokaleom ara lelâ itoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ilâ umelâ myani judeu domodo iwymârydo Jesus xyâhoem aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Awylygue Jesus kurâdo tâentoem kehoem nadakobâbyra awyly. Judeiadâpa âxiguely. Âtâ anary Efraim kehoam idâly; âji âdy peba ato iwaguepa myani mârâ âji. Xina agâlâ akâwâm târâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iwaguepa akâwâm Páscoa etyguedo. Toenzepa poji anaym tâtyuneim modo Jerusalémram idâly âty iraynâ. Kâzewenry ara aguidyly, kydokoguely wao warâ kydâzetyguedoem. Tâzetyguedoem ohonze myani idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Fariseu domodo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo warâ, “Jesus âdykâ awyly mâuntulymo-ro watay, xina xurutaungâ, xina nhawânehon-hoem” kehomobyry wâgâ, myani ohonze idâypy modo Jesus nhuinlymo. Âjigue adapâiguelymo: — Âdara inanajimo? Âese wânkâ mâkâ âtyam? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis iguandyly Páscoa etyguedoem awyly ume, Jesus agâ xina idâly Betanianra, Lázaro etyram, igueypyem awyly ume kurâem nhetondyby. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Xina saindyly ani. Kopae Jesus ipyniry anhedylymo. Marta pyni epâni. Lázarope lâpylâ Jesus agâ mesa wâgâ âwinduase. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xina âwinduadyly ume Maria uriza etary meio litru tâmânreim tâmaxi nhedyly. Nady nardo iwindy ekurugue aietyby ani mârâ uriza. Âjigueto myani mârâ, âdy agâ itugândyby keba. Awylygue toenzepa ewâendyly. Jesus ihuru onwa uriza nhapâdyly. Aitybyem tyangahudugue in-hugoguely. Toenzepa âtâ oday nhârânzely. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Queriote donro ani Maria aidyly nehoguebyra. (Jesus eynynonro modo ewy izepaom modo emaxi egamenribyrylâ awâkâ Judas.) Aituo Judas aguely: ");
INSERT INTO bkqNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","— Toenze tâwâenseim keba awârâ uriza! Awâkâ nhumeguyly! Awârâ uriza vende iedyly-ro watay, âdy pebaom modoram tâise ebyrypyry xuduly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Âdy pebaom modo tintyendylygue inkâba ani arâ aguely, tâmagazeim tawylygue. Dinheru Jesusram xuduypy etary eni ani mâkâ. Turâem tâtyze olâ mârâ odaji ietyby ewy. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aituo Jesus xinaram aguely: — Arâ adâkezeba itaungâ Maria wâgâ. Kâjiwypazenehonwâdaundâ. Yigueduo ieguepybyry onwa tiampâdoem keankâ merâ pekodo xirâ nhekanâdyly. Niwânwâmpyra olâ, awylygue iweâlâ wonwa nhapâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Aunlolâ ise âdy pebaom modope awyly. Urâ olâ ise âdiempa kulâ agâmo wawyly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Agui kurâdo Jesus Betaniadâ kely indadylymo myani. Aituo myarâ idâlymo; Jesus ese kulelâba olâ idâlymo, Lázaro ese lâpylâ, mâkâ Jesus eon-honrugue kurâem itondyby. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Aituo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo âjigue aguelymo: — Lázaro kydyâen-honre lâpylâ warâ. Mâkâ kurâem itondyby tientuo, toenzepa kurâdo Jesus nheinwândylymo, kienomedâdomo neinwâmpyra idylymo. Âdara pylâka ise xyâhoem aguiendyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kopaelâgâem Jerusalémram Páscoa etygueze idâwâtyby modo, Jesus saindyly kely indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Toenzepa myani iomarumo, saindyly tiuntuduomo. Wakuri sary nhatâwâdylymo; xidadâ odaypa egaselymo, tuomare kehoem Jesus iose. — Hosana Deusram! — kelymo. (“Tohoguezeim Deus” keze aguely.) Tohoguezeim kuru awâkâ Deus eon-honru enehonze âeni! Koendâ lelâ ise Deus israelita domodo iwymâryem ini agâ — kely kurâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Aituo Jesus jumentinhu nhawâdyly. Nhonwa âkuly. Iwâgâ idâly. Deus itaumbyry iweniby agueho ara aidyly: ");
INSERT INTO bkqNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Âmaemo Jerusalém donro modo tyanepa itaungâ. Etaungâ. Âwymârymo saindyly. Pymâ ton-honreim kawaru wâgâ sainto ara inkâba ise âewyly; jumentinhu wâgâ ise saindyly!” kely myakâwândy iweniby. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesus agâ tatay tâense, tydase warâ ani xina awârâ modo aidyly; âdakeze aguely awyly xina nutuba olâ. Igueypyem, Jesus kurâem itombygueduo, Deus eydâ atoam odopâduo warâ lelâlâ ani xina nhenanâguely, aise Deus kehobyry ara aituo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Toenzepa kurâdo Jesus iose idâwâdylymo, xidadâ odaxi sainse idâly ume. Awârâ iraynâ, Lázaro igueypyem awyly ume kurâem nietondâ kely idamâmomy. “Lázaro, awâtârâba igasegâ” keduo aitobyry egatuly nimopamo myani enipyry modo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jesus wâgâ koendâ kurâ domodo aguely tindatuo, fariseu domodo âjigue aguelymo: — “Jesus kâzeinwântaundâ” kykely neinwântaymbamo. Etaungâ! Idânârâ eagâ idâlymo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gregu ewy idâypybe myakâwâm Jerusalémram âty aiese idâwâtyby modo duay. Judeu kebamo wâne, alâ olâ Deus nhyrendylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yataen-ho Filipe, Galiléia eynynonro, Betsaidadâ tâtyreim iose myakâwâm idâlymo. Aituo aguelymo Filiperam: — Jesus agâ adâkedyze xina — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aituo myani Filipe, Andréram aguely. — Gregüem aguewâni modo ewy Jesus agâ adâkedyze — kely. Aituo azakâlâ Jesus agâ agueze idâlymo, Filipe, André alelâ. — Judeu keba modo ewy agâ adâkedyze — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus aguely: — Âdainkâba, tâwâlâ nâedâmo. Iwaguepa, won-honru, koendâ wawyly warâ idânârâ kurâdo nheto. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Idataungâ auguely. Nady ewy tâtâzeba watay, agui nitaymba, tokalâ kulâ. Ondaxi etâduo olâ, tyazeze, ago tâise, tâwiseze, ewyem tâise warâ. Arâ ewy agui idyly — kely. {“Yiguely, kurâem witondyly wipygueduo, toenzepa kurâ domodo yeinwânsemo” keze myakâwâm Jesus arâ aguely.} ");
INSERT INTO bkqNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aituo Jesus aguely: — “Ize wato aralâ ise awidyly. Tâwâlâ Deus nidâ” myguelymo-ro watay, âigueduomo, Deus agâ inkâba ise âmaemo. Eydâ atoam mydâwâpyra ise âmaemo. “Deus ize ato ara lelâ ise awidyly, ize wato ara kulâba, tâwâlâ ise kâsenagazedyly, yiguely warâ” myguelymo watay olâ, Deus eydâ atoam idâze âmaemo, aunloenlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tywymâryem yizetonro modo, yeinwântaungâ. Auguely idataungâ warâ. Eydâ watodâ lâpylâ ise âmaemo. Pabai Deus koendâ ise yeinwânni modo wâgâ aguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aituo Jesus aguely: — Takalague urâ iwerâ. Inepa kâzenagazeoly awyly, tutuze urâ. “Kâsenagazedo amaymba yekâ” keze urâ Pabairam? Arâ auguepa ise aze! Xirâ onro anaxi igueze âetybylâ urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Koendonro typygueim keba warâ on-honru enehongâ” keze olâ urâ Pabairam — kely. Aituo kaynâ tâjitanru aguely: — Koendonro typygueim keba warâ won-honru senen-ho. Kâenehondyly ise-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Atonlo modo tâjitanru kau odaypa âeni indadyly. Aituo akaemo modo ewy aguely: — Kopâ awârâ agueim! — kelymo. Eagonro modo warâ agueim: — Kopâ keba agueim. Anju eagâ agueim — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Warâ olâ Jesus aguely: — Kopâ keba, anju keba warâ agueim. Urâem inkâba Pabai târâ kaynâ aguely âmaemoenlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Inepa kehoem Deus agueze xirâ onro anaym yeinwântânry modoram: “Âmaemo tâwentâzeim inakanhe amidylymogue” kely ise. Inepa ise Deus, Diabu pymâem ato xirâ anaym nhainly. Adiendyse tato anientaymba ise Diabu. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kruz wâgâ sakâjibyem kadaunâhonduo, eon-honru sainze urâ. Idânârâ ynynonro modo igâseze urâ, yeinwântomoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Adâkezelâ ani Jesus tyiguely iraynâ, âdara tyiguely awyly wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Atonlobyry modo aguelymo: — Niguewâpyra ise Messias, tâkezema kâzewenry iweniby wâgâ. Aunloenlâ ise awâkâ Deus Ingonotyby, tâkeze warâ. “Urâ Uguondo Kaynâpa Âetyby yiguehoem kruz onwa âiehoze urâ” mygueaki olâ. Messiaslâ âmâ-ro watay, âdaituo pylâka “Igueze urâ” myguely? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aituo Jesus in-hoguly: — Kydadakobâdo tâense wâne kydaze peto oday, myara ise Deus ize ato ara adâjidyly inomedâdomobyry mâuntulymo. Yeinwântaungâ, yeinwântomo nhuduly umelâ. Âdiempa kulâ ise agâmo wawyly. Yeinwântaungâ, iamu odaxi âsenagazeze mydâpa mitomoem. Iamu oday adakobâni modo wâne âdyam tâtâly nepyra, myara ise awâkâ yeinwântânry modo tâsenagazedoam tâtâly nutubamo awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Agâmo wataylâ, auguely einwântaungâ. Arâ ise peto oday adakobâni ara mawylymo — kely. Agueypyem Jesus târâpa âxiguely, kurâdo tâempyra itoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus aidyly tâensemo lelâlâ wâne myakâwâm, arâlâ olâ agui judeu domodo neinwâmpyra awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Saguhoem Deus wâgâ agueypy Isaías aguehobyry ara kehoem aidyly: “Deus, agui kurâdoram xina âtaumbyry negatu, aguipa kulâ olâ keankâ xina aguehobyry einwânni. Tâensemo lelâlâ wâne toenzepa on-honrugue amânhetyby, aguipa kulâ olâ âinwânni modo” kely iweniwâm Isaías. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Deus izepa tawylymogue neinwâmpyra awylymo. Saguhoem Isaías inwenihobyry ara iwerâ aidyly: ");
INSERT INTO bkqNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Deuslâ mawânkâ tienkyly modo nutuba itomoem aienehonrim, nhangahumo nhuanwanâdyly waunlo ara. Warâ neinwâmpyra awylymo, Deus ton-honru tânehonzelâ wâne, Tytaumbyry nhegatuen-hoymby nidadâmolâ wâne warâ. Tâinwânsemo wâne watay, tâsemaguezemo tâise” kely Isaías. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Deus, Jesus wâgâ aitaynrim modo nhenehonduo, mâkâ arâ inwenily. Awylygue arâ Jesus wâgâ inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Agui myani judeu iwymârydo Jesus einwânni modo, ânguyram negatubamo olâ myakâwâm. Fariseu domodo tâdâtâdyguyhoam tâkaunâbyra awyly nhytaguylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kurâ domodo kulâ tohoguedyze atomo, Deus keba tohogueniem ize atomo. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ton-honre kehoem Jesus aguely: — Urâ kulelâ inkâba yeinwânni modo nheinwânkyly, mâkâ ugononibyry lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Utuwâni modo ugononibyry tutuzemo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Urâ iajimanâni emyenro xirâ onro anaxi kâewyly, yeinwânni modo Deus itaumbyry nhutuhomoem. Kâewyly ani, yeinwânni modo iamu odaypa iese. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ânguy ewentâze inkâba xirâ onro anaxi kâewyly. Xirâ onro anano modo emakeze kâewyly, enagazezemo inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Augueho tindadyseba neinwâmpyra waunlo olâ xypyry etay, tâdâsenagazedoam igonose Deus. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","— Unâry wâgâ kulâ inkâba awidyly. Pabailâ ugononi, awitoem, auguehoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Deus aguehobyry ara lelâ amidylymo-ro watay, eagâpa mitaymba ise âmaemo. Âigueduomo, idâze âmaemo aunloenlâ eagâ mitomoem. Tutuze urâ, xirâ âkealâ awyly; Pabai “Aguekâ” kehobyrylâ xirâ augueho — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tokalâ iguandyly kulelâ, Páscoa etyry adaguhoem. Tutuze myani Jesus tyigueho saindyly awyly, xirâ onro anaymba tâito, tunwynram todopâdo. Toenzepa xina inwynedyly tânehonze kâinane, tyigueho odaxi kehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kopae Jesus agâ xina âwinduadyly ani. Awârâ iraynâ, Diabu, Judas Queriote donro, Simão imery, nhangahu odaji xunâry nhedyly, Jesus tyândyse donro modoram nhegamehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Idânârâ adienkyly modo adientoem Tunwym ton-honru tuduze awyly, tutuze akâwâm Jesus. Deusdâpa tâewyly, eyam todopâdyly warâ, tutuze myani. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Xina âwinduadyly umelâ Jesus saudyly. Tâty BOH waunlo nhetyly. Ilâpygueduo toalha nhanâdyly, âzepagâjily. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Adâipygueduo, paru bacia odaji XU nhedyly. Tokalâ, tokalâ warâ xina ihuru ingokely. Ilâpygueduo, toalhague xina in-hugoguewâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simão Pedroam saintuo, mâkâ tuhuru igokedyzeba, âdykâ pymâ ânguy ihuru ingokely nepyra tawylygue. Aituo Jesusram aguely: — Urâem tâwaneim mâkeba âmâ, Pymâ. Awylygue uhuru mâingokedyzeba wawyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aituo Jesus eyam aguely: — Iwerâ mâuntuba wâne âmâ âdaituo arâ awidyly awyly. Xutuze olâ âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","— Uhuru mâingokewâbyra ise âmâ — kely Pedro. Aituo Jesus eyam aguely: — Âhuru kâingokeba urâ-ro watay, ynynonro mâkeba ise âmâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jesus agueduo, Pedro aguely: — Pymâ, arâ atayma, uhuru lelâba igokegâ-ro, iemary, yangahu alelâ-ro! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aituo Jesus aguely: — Kipygueduo, idânârâ kodo tywykuneba, kuhuru lelâ tugokezeim, itybyem kaimpygueduo. Deus inakanhe matomobyry nhygakeduo, iweâ kulâ ityby ara âmaemo. Idânârâ tywykuneba wâne âmaemo; tokalâ olâ tywykeim Deus xurâem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tutuze myakâwâm Jesus, ânguy tuduery emaxi tyâhoem tâgamenri awyly. Awylygue “Idânârâ tywykuneba wâne âmaemo; tokalelâ olâ tywykeim” kely, Judas agueho. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Xina ihuru ingokebygueduo, Jesus tâty BOH waunlo nhetondyly. Mesa onwa ekadondyly. Xinaram aguely: — Âdaituo âhugoguelymo mâuntuba mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Xina iwymâry”, tâkeze, “xina enomedâni” tâkeze warâ âmaemo yam. Âkealâ amyguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Âwymârymo lelâlâ urâ, inomedânimo lelâlâ warâ, âhurumo olâ xigokeagui, tagonro emawyadâni wâne myara. Agonromo ihugoguewâdaungâ lâpylâ, âsemawyadâni mawylymo mâenehon-homoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aetomobyry ara amitomoem, âsemawyadâdaungâ, imawyadâdomobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Idataungâ auguely. Tâzemary, tywymâry takaze kehoem tynrentuneba; unâ sani, igononibyry takaze kehoem tynrentuneba. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Âmaemoma midataimo auguely. Awidyly metaimo warâ. Âjigue mâsemawyadâduomo, koendâ kehoem ise Deus agâmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","— Âmaemo kâinduakeyby modo âutudâmo urâ. Tutuze urâ, tokalâ âmaemo ewy agâ Deus koendâpa awyly. Deus itaumbyry iweniby ara ise aidyly: “Uduery ise yagâ âwinduani” kely iweniby. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Agâieholy wâgâ xirâ auguely, yizepanro modo emaxi kâzegameoly iraynâ, “Aise” uguehobyry aidyly-ro watay, URÂLÂ URÂ kelygue tâzekeim wawyly mâinwântomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kâingonotaymby modo koendâ edaenkunri, urâlâ nhedaenkuly waunlo ara lelâ. Koendâ iedaenkunri, mâkâ ugononibyrylâ koendâ nhedaenkuly. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Agueypyem, toenzepa kehoem Jesus adahulily. Xinaram aguely: — Idataungâ wao. Tokalâ âmaemo ewy ise yâdysedo modo emaxi iegamerim — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Aituo xina âzedyly. Toenzepa xina âseguâdâdyly, ânguy agueho xina nutuba tawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Urâ Jesus toenzepa inwyneguyly iwaguepa ani iopay ekadybyem wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simão Pedro PUK PUK idyly, ânguy wâgâ Jesus aguely awyly auguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aituo ago Jesus iopaji udâly, kampâiguehoem: — Pymâ, ânguyka ise âdysedonro modo emaxi igameim? — uguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus in-hoguly: — Mâkâ pão ikuiby kâunduhobyry — kely. Aituo pão SAGAI ietyby nhanâdyly, inkuily prato odanogue, Judasram nhuduly, Simão Queriote donro imeryram. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas pão nhemakely. Ilâenlâ Satanás emaxi idyly, Satanás “Aiekâ” kehobyry anhetoem. Aituo Jesus eyam aguely: — Amânhedyse mato inepa aiekâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Xina mesa wogonro modo nutuwâbyra akâwâm âdaituo Jesus arâ aguely awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas dinheru etary eni awylygue ani xina ewy tyangahu oday aguely: Tâlâ pylâ wakeim modo: — Jesus gâlâ keanra Judas pyni nhanâdyse âtyem warâ? — keim. Eagonro modo aguely: — Âdy pebaom modoram âdylâ nhuduen-honly lâgâlâ keanra Jesus — warâ kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pão emakeimbyryem, inepa kehoem Judas idâly. Iamu odaylâ egasely, kopae awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas âxiguebygueduo Jesus xinaram aguely: — Iwaguepa urâ Uguondo Kaynâpa Âetyby yigueho. Yigueday ise won-honru, koendâ wawyly, Deus koendâ awyly, eon-honru warâ kâenehonly. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Deus koendâ awyly, eon-honru warâ enehonze urâ. Alâpylâ awâkâ, koendâ wawyly, won-honru warâ enehonze. Inepa ise awârâ aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tâjiunwym tymery inwynedo ara lâpylâ âwynedylymo. Âdiempa kulâ ise agâmo wawyly. Udâpygueduo, uize âmaemo. Judeu domodo iwymârydoam uguemy myara olâ âyanmo auguely: “Udâhobyryam mydâpa olâ ise âmaemo.” ");
INSERT INTO bkqNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Iwelo tâzezewenry ise xirâ: “Mâkâ agâ, mâkâ agâ warâ âpynedaungâ, âwynedylymo ara.” ");
INSERT INTO bkqNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mâpynedylymo-ro watay, idânârâ kurâdo xutuze ynynonro mawylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aituo ani Simão Pedro Jesus nhapâiguely: — Âdyanka ise mydâly, Pymâ? — kely. Aituo Jesus in-hoguly: — Iwerâma ise âmâ udâhobyryam mydâpa. Iweâkuba ise mydâly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro nhapâigueondyly: — Âdaituoka iwerâ mydâhoram, udâpa wawyly? Kâmayno amaymba imakeze iguein-em kâdutuly! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aituo Jesus eyam aguely: — Âkeaka? Xirâ enanâguegâ. Xirâ kopae, aukuma igâtudyly iraynâ, azagâ tokalâ warâ ise “Jesus kâuntuwâbyra urâ” myguely — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aituo Jesus xinaram aguely: — Tytyremba, tâseguâdâzeba warâ itaungâ. Deus einwântaungâ, yeinwântaungâ lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pabai eydâ atodâ toenzepa âtâ modo mâxidâdomoem. Ijidymo nhonse udâly. Aypa-ro watay, auguewâpyra tâise urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ijidymo nhonse idâypyem, odopâze urâ, nhesemo, yagâ eydâ watoam mydâhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tutuze âmaemo ânwa eydâ watoam kani — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aituo Tomé aguely: — Xina nutuwâbyra âdyam mydâly awyly, Pymâ. Tutuzeinhe inkâba awârâ ânwa âyam tâdâtâho — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aituo Jesus aguely: — Ânwa Pabairam tâdâtâholâ urâ. Yagâ lelâ âdy iozeno awyly âdutuoly. Ywâgâ lelâ Deus eydâ atoam tadaindyly. Yeinwânni modo lelâ ise Pabairam idâim. Yeinwâmpyra âmaemo-ro watay, Pabairam aintaymba âmaemo. Yeinwântuomo lelâ eyam aindylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Iwerâ utudâ âmaemo. Pabai xutuze lâpylâ âmaemo. Ietâ, utudâ warâ mawylymogue, Pabailâ mâuntulymo, mâenkylymo warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aituo Filipe aguely Jesusram: — Pymâ, Kunwym Deus enehongâ. Awârâ kulâ xina nhekaguyly, tuomazehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aituo Jesus aguely: — Filipe, iweâpa lelâlâ wâne agâmo wawyly. Ânguy wawyly mâuntuba lelâ waunlo ara olâ âmâ! Ieni modo, Pabai tâensemo lâpylâ. Awylygue ietâ kulâ, “Pabai mygueho enehongâ” tâkezeba ikâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pabai agâ tokalâ wawyly; yagâ tokalâ Pabai awyly warâ tâinwânse wânkâ âmâ, Filipe? — kely. Aituo Jesus xinaram aguely: — Yangahu odano kulâ mâkeba xirâ augueho, Pabai “Aguekâ” kehobyrylâ. “Aiekâ” kehobyrylâ agânhekyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Auguely einwântaungâ. Einwântaungâ Pabai agâ tokalelâ wawyly. Auguely wâgâ yeinwândyseba mataymo, Pabai Deus eon-honrugue agânhetaymby modo mâentybymo wâgâlâ yeinwântaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Idataungâ auguely. Idânârâ yeinwânni modo agânhetaymby modo aiese. Yara adyesenry modo anhetoem agueypyem urâ, adyesenry ton-honreim lelâlâ. Inepa ise Pabairam udâly. Urâ lelâlâ agânheto nuduompyrama ise. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Agânhetoem mâenkadybymo aiese urâ, iezedy wâgâ idânârâ kehoem agânhetoem amyguehomobyry. Pabai ton-honreim, koendonro warâ awyly kâenehohoem ise awidyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Idânârâ iezedy wâgâ mâenkadybymo aiese urâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aituo Jesus aguely: — Ywynedâ mataymo, auguehobyry lelâ aietaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pabairam ekaze urâ, âurunimo ingonotoem. Odokewâbyramo ise; alâ ise agâmo awyly. Deus Ispiriturylâ ise mâkâ. Mâkâ ise Deus wâgâ âkealâ kuru agueim. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Deus eynynâbaom modo agâ inkâba Deus Ispiritury. Nutuwâbyramo netaymbamo warâ ise. Âmaemo olâ xutuze. Alâ mawânkâ agâmo awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","— Âxigueze wâne urâ, omopamo olâ ise urâ. Agâmo witoem odopâze urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Inepa ise Deus eynynâbaom modo iepyra idylymo. Âmaemo olâ iese. Igueypyem kurâem witondobyry wâgâ ise Deus agâpa mâseagongueba mawylymo; igueypyem, yagâlâ ise âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kurâem witonduo ise mâuntulymo, Pabai agâpa wipyra wawyly. Yagâpa mipyra mawylymo, agâpamo wipyra wawyly warâ mâuntulymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","— Yeinwânni modo, auguehobyry idani modo warâ ywynedâ tawyly tânehonzemo. Ywyneni tywyneze Pabai. Iwynezemo lâpylâ urâ, koendâ utuhomoem aiese urâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aituo Judas, Jesus nhapâiguely, Queriote donro keba olâ, eagonro: — Âdaituoka ise xinaram kulelâ mâenehonly; Deus eynynâbaom modo pylâ nepyramo-ro warâ awyly? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aituo Jesus in-hoguly: — Ywyneni modo auguehobyry lelâ ise anhekylymo; Pabai iwynezemo lâpylâ. Eagâmolâ ise xina-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ywynedânry modo auguehobyry takazemo lelâ. Urâ kulâ mâkeba xirâ mâindakylymo agueim, Pabai aguehobyryenlâ xirâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","— Agâmo wawyly umelâ xirâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Âxigueze urâ. Âurunimo âyanmo âese olâ. Deus Ispiritury ise mâkâ, Deus ingonotyby ietaybyaji agâmo itoem. Idânârâ âyanmo auguehobyry enanâgueze, inomedâzemo warâ auguehobyry modo mâuntuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","— Yara madahuliba âesemo. Xirâ onro anano modo toenzepa ise adahulilymo, eanumo warâ. Âmaemo olâ tadahulizeba itaungâ, tyanepa warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Idâze wâne urâ, odopâze olâ urâ” uguely midataimolâ. Toenzepa awârâ mâindatuomo madahulilymo. Tadahulizeba itaungâ. Urâem koendâ lelâ aidyse mataymo, tâjityenzeba itaungâ; tuomare itaungâ, Pabai ugononibyryam kodopâdyly awylygue. Yakadâ ton-honreim kuru mâkâ lelâ, unâ sodo ton-honreim kuru, egatuim takaze. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pabairam udâly iraynâ xirâ auguely âyanmo. Udâduo ise, auguehobyry âkealâ awyly mâinwândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Agâmo alâ auguezesedyly witaymba ise urâ. Deus eynynâbaom modo iwymâry Diabu saindyly mawânkâ. Ton-honreba olâ ise mâkâ yagâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Idânârâ, Pabai “Aiekâ” kehobyry lelâ agânhekyly, Pabai tywyneze lelâlâ wawyly, eynynâbaom modo nheinwântomoem. — Autaungâ. Inoro tarâpa — kely ani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus xinaram aguely: — Uva ipery emyenro urâ. Pabai pylâ uva eni emyenro-ro warâ. Se tywindyen-ro watay, iwatary modo niguewâpyra, arâ lâpylâ urâ, ynynonro modo niguepa itoem aienehonrim wawyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Deus aguehobyry adiendysebaom modoma uva iwatary ewisedânry emyenro. Uva iwatary ewisedânry eni tatâwâze myara, ise Pabai tydatânry modo tygue nhedyly. Uva iwatary ewisenri watayma eni tâense, tuonse warâ. Inakai modo lelâ nhatâwâguyly, iwatary toenzepa ewiseondoem. Arâ lâpylâ Pabai, tynynonro modo odaypa izepa tato nhetyly, ize tato lelâ anhetomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pabai inakanhe amitomo nhygakely ani, inomedâdomobyry mâinwântomobyry wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yeinwânsezedaungâ lelâ, yagâpa mâiehowâbyra ise âmaemo; agâpamo wipyra ise urâ warâ. Uva iwatary wâne ipery wâgâ atay lelâ ewisely myara lâpylâ âmaemo, yeinwântuomo lelâ Deus ize ato ara amidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","— Uva ipery emyenro urâ, uva iwatary emyenro âmaemo-ro warâ. Ipery wâgâ wâne uva iwatary koendâ kehoem PE warâ awyly, myara ise yagâpa itânry modo koendâ lelâ Deus ize ato ara aidyly. Urâ peba kulâ, mâkâ ize ato ara amipyra âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Uva sodo iwatary satârimbyryem, âpa ezaypa nhamely. Aituo iwatary modo iladyly. Ilâpygueduo, indâtyguyly, nhaduândyly. Awyara ise, yagâpanro modo Deus iopayba iedyly. Petomâ onwanxi ise samely, mârâ uva iwatary ewisedânry iaduânto ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","— Yagâpa mipyra âmaemo, âyanmo auguehobyry mâinwânsezedylymo lelâ watay, emakeze lelâ âmaemo idânârâ Pabairam mâenkadybymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Koendonro amânhedysemo wato amânhedylymo watay, uva iwatary tâwiseim emyenro ise âmaemo. Deus koendâ awyly, eon-honru warâ enehonze âmaemo amânhekylymo wâgâ. Arâ ise ynynonro kuru mawylymo mâenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pabai ywynedyly ara lâpylâ âwynedylymo. Auguehobyry ara lelâ aitaungâ, âwynedâmo wawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pabai agânhedyse ato agânhepyra witaymba urâ. Awylygue kadahuliba wawyly, ywynedâ awyly tutuze urâ. Arâ lâpylâ, “Aietaungâ” ugueho mâinmopa âmaemo-ro watay, madahuliwâbyra ise âmaemo, âwynedâmo wawyly enanâgueze âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","— Madahulidyzemo inkâba urâ, awylygue âurudylymo, tuomare lelâ mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Xirâ auguehobyry ara aitaungâ: “Agonromo agâ âpynedaungâ; koendâ mâzetomo ara lâpylâ agonromo agâ koendâ âzetaungâ.” ");
INSERT INTO bkqNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mâkâ tataen-ho emakeze iguerim mawânkâ tataen-ho iwyneni kuru. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Auguehobyry amânhedylymo watay, yataen-ho âmaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Yataen-ho” uguely âyanmo; “iemary” uguely mâkeba. Awylygue agâmo unâgu ywâgâ aini wâgâ. Pymâ tywâgâ aguewâpyra tâmarydoam. Âyanmo olâ auguely, idânârâ Pabai “Aguekâne” kehobyry. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","— Âmaemo mâkeba keankâ atâen-homoem witoem uduakeim; urâlâ keankâ âduakenrimo, Deus ize ato amânhetomoem, yeinwândyly mâinmopa mitomoem. Arâ ise uva iwatary tâwiseim ara mawylymo, ewily inakanhe itânry. Ywâgâ mâenkadylymo-ro watay, idânârâ mâenkadybymo xuduze lelâ Pabai. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Awylygue, xirâ auguely: “Agonromo agâ âpynedaungâ; koendâ mâzetomo ara lâpylâ agonromo agâ koendâ âzetaungâ.” ");
INSERT INTO bkqNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesus xinaram aguely: — Ynynâbaom modo âizepamo watay, enanâguewâdaungâ, âizepamo idyly iraynâ yizepa atomobyry. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Deus eynynâbaom modo eynynâlâ âmaemo-ro watayma tâise âwynedylymo. Saguhoem Deus eynynâba wâne ani âmaemo, alâ olâ âduakelymo urâ xurâem mitomoem. Awylygue iwerâ Deus eynynâbaom modo anhekyly amânhedyseba mawylymo. Awylygue âizepamo awylymo, inagazedylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","— Auguehobyry enanâguewâdaungâ. Tâzemary, tywymâry takaze kehoem tynrentuneba. Pymâ eto ara lâpylâ ise emary modo âzeholy. Ienagazeni modo inagazezemo lâpylâ. Kâunrutomobyry anhedylymo-ro watay, mâunrutomo aiesemo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mâzenagazeolymo ise, ynynonroem mawylymogue. Mâkâ ugononibyry nutubamo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Xirâ onro anaxi kâewyly, Deus wâgâ agueze. Tindatuo, neinwântaymbamo ani. Kâepyra urâ, eyanmo auguepa warâ watay, tâwâlâ tâise aguelymo: “Âdykâ Deus itaumbyry xina nidataymba. Tânagazeduneba xina, tindatânry kulâ neinwâmpyra tawylygue” kelymo tâise. Auguely tydase, agânhekyly tâense warâ akaemo, yeinwâmpyramo olâ; xypyry etay Deus enagazezemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","— Yizepanro modo, Pabailâ izepa atomo lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Enanaynmolâ adyesenry modo kehoem agânhedyly. Idânârâ olâ yeinwâmpyramo. Xirâ adyesenry modo agânhepyra urâ-ro watay, “Tâwentâguezeinhe mawylymo” aguewâpyra tâise Deus. Akaemo iwerâ tâwentâguezeim, agânhetyby tâensemolâ mawânkâ, yeinwâmpyramo olâ. Yize inkâba akaemo, Pabai izepamo lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Warâ ise aidyly” tâkezelâ Deus. Iwenibyem itaumbyry awo wâgâ: “Âdaituoba kulâ yizepa awylymo” kely iwenibybe. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","— Âurunimo âese, Deus Ispiritury keho, Deus eydâpalâ âeni. Deus wâgâ âkealonro ise inomedâdomo. Pabaidâpalâ ise âyanmo kâingonodyly, ywâgâ agueze lâpylâ mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Xirâ onro anaym iewanu kanguly umelâ yagâ mawylymo. Awylygue ise ywâgâ mâindatybymo, mâentybymo warâ mâengatulymo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesus xinaram aguely: — “Ynynonro modo, ynynâbaom modoram âzenagazeoze” tâkeze urâ. Aidyly-ro watay, âtywambyramo, yeinwândyly mâinmopamo warâ mitomoem olâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Âtâ tâdâtâdyguyho odaypa igaseânzemo, akaemo âhomo sainse. Âlymo-ro watay, Deus ize ato aralâ adâidyly waunlo ara ise enanajimo. Iozepa kulâ olâ arâ âpaunzedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Arâ aidylymo olâ ise, utuba, Pabai nutuba warâ tawylymogue. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aidyly iraylâ olâ xirâ âyanmo auguely, mâzenagazeoduomo, madapâendyba mitomoem. “Kyam Jesus aguehobyrylâ xirâ aini” keze âmaemo — kely. Jesus aguely: — Yeinwâmpygueduomo, âdara mâzenagazeolymo awyly wâgâ auguepa ani urâ, agâmolâ wawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Inepa olâ ise udâly, mâkâ ugononibyryam. Âmaemo ewy olâ yapâigueba: “Âdyanka ise mydâly?” myguepamo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Toenzepa âtynrumo, “Âydâpamo widyly” uguely mâindatuomo. Tâseguâdâzeba itaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","— Idataungâ auguely. Udâly lakuru âmaemoem koendonro. Udâpa urâ-ro watay, Âurunimo nâetaymba ise. Udâduo olâ, âyanmo igonose urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Deus Ispiritury âetuo, agueze mâkâ ynynâbaom modoram: “Wamyguelymo: ‘Tutuze xina, Deus ize ato, izepa ato warâ. Tutuze xina, koendonro, koendonro keba warâ. Tutuze xina, Deus ânguy nigonopyra awyly tâdâsenagazedoam âsenagazedoem’ myguelymo. Iozepa olâ amyguelymo” kely ise eyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","— “Tutuze xina, Deus ize ato, izepa ato warâ” kelymo. Iozepa kulâ aguelymo, yeinwâmpyramo mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","“Koendonro, koendâpaom warâ tutuze xina” kelymo. Iozepa kulâ aguelymo. Pabairam idâze urâ; ietombyra ise âmaemo-ro warâ. Myarâ kodopâduo ise koendonro lelâ wawyly mâuntulymo. Ietombyra ise âmaemo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","“Tutuze xina, Deus ânguy nigonopyra awyly tâdâsenagazedoam âsenagazedoem” kelymo. Iozepa kulâ aguelymo lâpylâ. Saguhoenlâ Deuslâ agueim: “Urâ xurâ keba modo iwymâry aunlolâ ise infernudâ âsenagazedyly” keim. “Ynynâbaom modo lâpylâ aunlolâ infernudâ Deus enagazenehonze” keim lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","— Tâlâ urâ toenzepa âyanmo augueho, mâuntuhomoem nudupa olâ, toenzepa mawânrâ iwerâ âtynrumo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Deus Ispiritury âetuo olâ, âyanmo xutuen-honze, idânârâ âkealonro Deus mâuntudyzemo ato. Âdy aini awyly wâgâ ise mâkâ aguely. Tyangahu odano kulâ mâkeba ise mâkâ agueho. Mâkâ agueho olâ ise Kunwym Deus tyam aguehobyrylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Auguehobyry, âyanmo enanâguehonze mâkâ. Arâ ise mâkâ, koendâ wawyly, won-honru warâ nhutuen-honly. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Idânârâ augueho modo, Pabai aguehobyrylâ. Deus Ispiritury auguely idase, âyanmo egatuze-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesus xinaram aguely: — Iweâ lelâlâ ise iepyra midylymo. Inepa olâ ise, ietondylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Xina âjigue aguely: — Âdakeze aguely awyly kiuntuwâbyra kurâ, “Iweâ lelâlâ ise iepyra midylymo. Inepa olâ ise ietondylymo” keduo. Wakeanry lâpylâ: “Iepyra mawylymo ise, Pabairam udâly awylygue” keanry. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Âdakezeka “Inepa olâ ise, ietondylymo” kely? Kiuntuwâbyra kurâ awârâ — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Agueho koendâ xina nutuba awyly, tutuzelâ olâ Jesus. Awylygue aguely: — Idataungâ auguely. Adâkeonze urâ warâ. “Iweâ lelâlâ iepyra ise âmaemo. Inepa olâ ise ietondylymo.” Xirâ kebaka agonromo agâ madapâiguehomo? ");
INSERT INTO bkqNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Toenzepa âjityenze, eogumase warâ âmaemo. Ynynâbaom modo iomamunumo ume, tytynre ise âmaemo; omarumoem ise olâ awârâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tymery egaseday, pekodo tuomaruneba ewânugue. Iamudo iazepygueduo olâ toenzepa tuomazeze, tymegue mawânkâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Arâ ise âtynrumo aunloenlâ nipyra awyly. Tytynre âmaemo iwerâ, “Iweâ lelâlâ ise iepyra midylymo” ugueduo, nhetonzemo olâ urâ. Aituo ise toenzepa omarumo. Ânguy tuomareba âenehonwâbyramo ise. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","— Âurunimo âetuo, inomedâzemo mâkâ. Agâmopa lelâlâ wâne ise urâ, mâkâ olâ ise agâmolâ. Tâwâlâ mapâiguelymo mâuntudânrymo wâgâ. Idataungâ auguely. Iezedy wâgâ Pabai uguehoam mâenkadylymo-ro watay, xuduze mâkâ âyanmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","“Jesus ezedy wâgâ xina nhekadyly” myguepa lelâ olâ âmaemo Deus agâ. Ekadaungâ. Mâenkadybymo emakeze âmaemo, toenzepa omaromoem. Xirâ mâuntudyzemo kuru wato — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesus aguely: — Tutuzenryem xirâ unâ kâengatuly, âdaunlo Deus awyly wâgâ inomedâdomoem. Tutuzeinhelâ inomedâdomo sainse olâ. Mâindakylymoenlâ mawânrâ ise âyanmo Pabai wâgâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mârâ ume, Deus agâ amyguedaymo, “Xina xirâ nhekadyly Jesus ezedy wâgâ” keze âmaemo. Âmaemoem auguezesedyly witaymba ise urâ. Âmaemolâma ise eagâ agueim. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pabai âwynedâmo awylygue, koendonro xuduze mâkâ âmaemoem. Ywynedylymogue, Deusdâpa kâewyly tâinwânse mawylymogue warâ âwynedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xirâ anaxi kâetoem, Deus ingonotyby urâ. Inepa ise tarâpa widyly. Pabairam ise udâly — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Aituo xina aguely: — Iweâma tutuzeinhelâ amyguely. Amyguedyse mato moempyra âmâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Idânârâ tutuze mawyly, tutuze xina. Xina apâiguely iraynâlâ, tutuze âmâ, xina adâkedyze ato. Awylygue Deuslâ ogononi awyly xina nhutuly — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus aguely: — Deus ingonotyby wawyly tâinwânse lelâlâ wâne âmaemo, arâlâ olâ koendâ yeinwâmpyra mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Inepa ise wodokelymo. Adapâeguywâze âmaemo, itymoam, itymoam ise âmaemo. Urâ kulelâ ise yânlymo. Urâ kulelâba olâ ise urâ, Pabai yagâlâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Xirâ modo wâgâ auguely aidyly iraynâlâ, âtywambyra mitomoem. Yeinwântâ mawylymogue, koendâ lelâ itaungâ, tâseguâdâzeba. Xirâ anaym mawylymo ara ton-honre ise âmaemoem; âsenagazeze âmaemo. Tâegane olâ itaungâ. Won-honruma ynynâbaom modo iwymâry Diabu eon-honru takazeno kuru — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aguenripyryem, Jesus kauram MYK idyly. Deus agâ aguely: — Pabai, amyguehobyry aralâ ise inepa yiguely. Âmery wawylygue, enehongâ koendonro wawyly, won-honru warâ. Arâ awidyly, koendonroem mawyly, on-honru warâ kâenehohoem lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Idânârâ iwymâryem witoem amyguewâm. Kâenkyly lelâ asaemo. Âmâlâ lâpylâ asaemo ynynonroem ienehonrimo. Awylygue ise ynynonro modo agâpa kânhenehomba wawyly; igueduomo, aunloenlâ agâ nidâmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Akaemo aunloenlâ agâ itaynrim modo, idânârâ koendâ kehoem âutudâmo, âmâ lelâ Deus tokaleom mawyly. Utudâ lâpylâ asaemo, Jesus Cristo mâingonotyby wawyly. Kagâpa tyetuneba ise asaemo; igueduomo, idâzemo aunloenlâ kagâ itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","— Koendonro mawyly, on-honru warâ senen-ho, xirâ anaym wawyly ara. Âwanu aiese ugonotobyry sewanike warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pabai, târâ agâ wawyly ume, tâdyren-honze akâwândy urâ, onro peba awyly ume. Tâwâlâ kâdyren-hondonji, izay watay kâdyren-hon-hobyry ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","— Pabai, ynynonroem mânhenehonwâdyby modoram ânguy mawyly senen-ho. Âmâ xurâ lâpylâ asaemo. Âmâlâ ynynonroem ienehoinmo. Amygueho tâinwânse asaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tutuze asaemo, idânârâ agânhetaymby modo, won-honru mâunduypyguelâ agânhetaynly awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Unâ eyanmo kâengatuhoem amyguehobyry segatu. Auguehobyry neinwândâmo. Eydâ matodâlâ mâingonotybyenlâ kâewyly awyly, tutuze asaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","— Pabai, âyam kâenkadyly, koendâ asaemo mâentoem. Yeinwântânry modo mâentoem kâenkadaymba urâ. Ynynonro modo olâ koendâ egâ. Âynynonro lâpylâ mawânkâ asaemo. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Idânârâ ynynonro modo, âynynonro lâpylâ. Idânârâ âynynonro modo, ynynonro lâpylâ. Adâkeday, adientay warâ tânehonzemo, koendonro wawyly, ton-honre wawyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","— Inepa ise udâly eydâ matoam. Xirâ anaymba ise urâ; asaemo olâ ise tarâlâ, yeinwântânry modo duaymo ise-ro warâ. Pabai, koendonro lelâlâ âmâ; inakanhe amitaymba âmâ. Toenzepa ton-honreim lâpylâ âmâ, on-honrugue awitoem yam amygue. Asaemo ynynonro modo egâ on-honrugue, tokaleom ara lelâ itomoem, urâ, âmâ warâ tokaleoem kydawyly ara. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ijipyay, xirâ anaym eagâmo watay, on-honrugue tâensemo keankâ urâ. Asaemo ewy tokalâ kulâ keankâ ynynâba ini. Âunâry awo wâgâ iweniby aralâ keankâ aidyly, aise kehobyry aralâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","— Inepa ise eydâ matoam udâly. Tarâ xirâ anaym wawyly ara, ynynonro modo xurâem agâ auguely, nâjityembyra itomoem, tytyremba wato ara, imâem kehoem iomarumo nidâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Eyanmo kâengatuhoem amyguehobyry segatu. Tâinwânse asaemo. Ynynâbaom modo adiendyse ato, adiendyse inkâba asaemo, ynynâbaom modo anhekyly, agânhedyseba wato ara lâpylâ. Awylygue, ynynâbaom modo izepa idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","— Pabai, ynynâbaom modo duaypa mâentyhomoem kâenkadaymba urâ. Diaburam nâdynanâoba itomoem xuahurumoem ikâ wao, uguely olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ynynâbaom modo adiendyse ato agânhedyse inkâba urâ, arâ lâpylâ asaemo adiendysebamo awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amyguehobyry ara lelâ anidâmo; idânârâ amygueho âkealâ mawânrâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Âynynâbaom modo duaxi ugonotobyry ara, arâ lâpylâ asaemo kâingonodyly ynynâbaom modo duaxi. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Âyam kâtuly, idânârâ agânhedyse mato agânhetoem, kâenmakehomoem. Arâ awidyly âmâ xurâem itomoem, ize mato anhetomoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","— Asaemo lelâba mâentoem kâenkadyly. Asaemo ywâgâ aguely tindatuo yeinwânni modo olâ egâ lâpylâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pabai, kâenkadyly, idânârâ yeinwânni modo tokaleom ara lelâ itomoem. Tokaleom ara kagâ itomoem kâenkadyly, yagâ mawyly ara, agâ wawyly ara warâ nidâmo. Tokaleoem nidâmo, yeinwântânry modo âmâlâ ugononi awyly nhutuhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ton-honre witoem, koendonroem witoem warâ amyguehobyry ara lâpylâ eyanmo auguely, eon-honromoem, koendonroem itomoem warâ. Arâ awidyly, tokaleom ara lelâ itomoem, yagâ tokaleom mawyly ara, agâ wawyly ara warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Augueondyly, Pabai. Tokaleom waunlo ara eagâmo wawyly; tokaleon-ro waunlo ara yagâ mawyly. Aituo tokaleom ara lelâ kagâ awylymo. Arâ tientuo, ynynâbaom modo xutuzemo, âmâ ugononi awyly, ywynedo ara lâpylâ mâinwynedylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","— Pabai, âdykâ watodâlâ, yagâ ize urâ ynynonroem mânhenehonwâdyby modo. Kytanrugue kulâ onro kiungudyly iray ywynemâ. Ywynedylygue, koendonroem, ton-honreinhe warâ witoem amyguewâm. Urâ xurâ modo won-honru, koendâ wawyly warâ nhedysemo urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pabai, âdykâ inakanhe amitaymba âmâ. Yeinwântânry modo âutuwâbyra. Urâ olâ âutudâ. Akaemo yeinwântoem amânhenehoymby modo tutuzemo âmâ ugononi awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Akaemoam âutuen-ho, alâ ise awisezedyly, âdara tagonro agâ tâpynedyly nhutuhomoem, ywynedâ âmâ ara, urâlâ eagâmo witoem, nhutuhomoem warâ — kely Jesus tunwym Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Deus agâ agueypyem, Jesus xina agâ idâly. Xina xytâguyly; paru egatudo Cedrom xina nhekuâdyly; xina salokuly. Xina idâly toenzepa se modope atoam. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jesus iduery modo emaxi egamenribyry, tutuze lâpylâ ani mârâ âji Se Oliveira Eka. Tâtâzezema kâinane xina myarâ Jesus agâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Târâ awyly tutuze tawylygue, Judas idâly Se Oliveira Ekaram sodadu pymâ romano ingonotyby modo agâ. Fariseu domodo, kurâdo eynynâ Deus agâ aguewâni modo iwymârydo warâ, Deus ety iguardary modo ingonodylymo Judas agâ. Espada, se, esagon-ho, tyatygueim warâgue tâmatunemo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tutuzelâ Jesus idânârâ âdy aini awyly. Eagâmo oxioze idâly. Nhapâiguelymo: — Ânguyka mâwinlymo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","— Jesus Nazaré donro — kelymo. — Mâkâ mâwinlymolâ urâ! — kely Jesus. Eagâmolâ akâwâm Judas, Jesus egamenribyry. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Mâkâ mâwinlymolâ urâ” Jesus keduo, âjihujiguylymo, onro onwa ihuguewâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ihugueybyem, sautuomo, Jesus agueondyly: — Ânguyka mâwinlymo? — keondyly. — Jesus Nazaré donro — keondylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","— “Mâkâlâ urâ” ugueanselâma. Urâ mâwinlymo atay, asaemo yagonro modo tâwâlâ nâtâmo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Deus agâ adâkeday, “Tâensemo urâ. Tokalelâ olâ keankâ yagâpa ini” tâkehobyry wâgâ. Guarda domodoram nhekadyly tynynonro modo nawâpyra itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simão Pedro tyspadary nhetyly ety odayba, kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru ety oday tâwaneim Malco keho iwantary aho eynynonro nhatâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aituo Jesus aguely Pedroam: — Adâiseba ikâ. Âdahoru ekanâgâ. Pabai aguehobyry ara âsenagazeze urâ. Tâwâlâ lelâlâ wâne tâdâsenagazedyly eon-honru, tânyzeim tudureim kâenyly-ro waunlo ara kehoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ilâpygueduo, sodadu domodo iwymâry, sodadu domodo warâ Jesus nhawâdylymo, nhemakâjilymo. Deus ety iguardary domodo eagâmo adâisemo lâpylâ ani. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Waunroem kuru nhadylymo Anás etyram, Caifás imeindamunra. Mârâ ume kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru Caifás. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifáslâ awârâ iraynâ judeu domodo iwymârydoam agueim: “Tokalâ iguelylâ ise koendonro, idânârâ kyiguepa kitoem” keim. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simão Pedro, urâ warâ xina idâly Jesus sani modo nhapygue âgânâ. Tâdutuoze ani urâ, kurâdo eynynâ Deus agâ aguewâni modo iwymâryam. Awylygue kâzekaunâoly lelâ âtâ idaseraji Jesus nhapygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro olâ kuoholâ tâxiânze, pyanta iwaguepa. Pedro yagâ negawâmpyra awyly kâentuo, iegasely, auguely pekodo agâ, pyanta taseraji tâzegawânto enahungueim agâ: — Tâwâlâ yataen-ho negawândâ — uguely. Augueduo pekodo pyanta nhenahunguely, Pedro egawântoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aituo pekodo eyam aguely: — Awâkâ uguondo eynynonro modo ewylâ âmâ — kely. Adâkehonduo: — Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ! — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kopae igâwynugue târâ tâwanuneim modo, guarda domodo warâ taseray peto emanânimobyryem. XYDYK, XYDYK warâ peto tânâmize awylymo, tâuntomoem. Pedro âundyly lâpylâ eagâmo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anás Deus agâ aguewâni modo iwymârybyry Jesusram aguely: — Akaemo agonropyry modo wâgâ aguekâ yam. Ânguyka akaemo? Âdyka keankâ mâenomedâdomo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus in-hoguly: — Totoenzeba keankâ auguezesedyly. Âtâ tâdâtâdyguyho modo oday, Deus etydâ idânârâ kurâdo âtâdyguyho oday warâ kâenomedâdaymo, toense kulâ inkâba keankâ auguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ydataynrimbyry modo tutuzemo âdy kâenomedâdomobyry awyly. Akaemo sapâiguegâ, urâ mâkeba — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Arâ Jesus agueduo, Deus ety iguardary ewy eydâ iwaguepaom inwapagainly, aguely warâ: — Arâ adâkezeba ikâ kurâdo eynynâ Deus agâ aguewâni modo iwymârybyryam! — kely Jesusram. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","— Iozepa augueaki watay, iozepa auguehobyry aguekâ. Iozelâ augueaki watay olâ, âdaituoba kulâ ywapagainhagui — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Awârâpygueduo, Anás aguely guarda domodoram: — Caifásram Jesus sataungâ, kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuruam — kely. Aituo Caifásram Jesus nhadylymo, emakâjibyenlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Târâlâ Pedro, peto opay âundyly. Aituo aguehonly: — Awâkâ uguondo eynynonro modo ewylâ âmâ — kehonly. — Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ! — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Caifás etydâ tâwaneim ewy Pedro nhedyly, aguely. (Pedro iwantary nhatâyby ipemugu ani mâkâ.) — Nhentai waunlo ara olâ Jesus agâ Se Oliveira Ekadâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","— Mâkâ mâkeba urâ! Kâuntuwâbyra urâ awâkâ! — keondyly Pedro. Pedro aguely umelâ, aukuma igâtudyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caifás ety dombyryem Jesus nhadylymo Pilatos ety imâsedo idaseraji, pymâ Romadâpa ingonotyby etyram emedyly wâgâ. Judeu domodo iwymâry Pilatos ety odaji tâgawândysebamo, judeu keba awylygue. Aguelymo: — Kâzewenry ara, judeu keba modo ety odaji kâgawântaymba kurâ. Kâgawândyly-ro watay, tywykeim ara kulâ ise Deus kâendyly. Aituo ise xirâ kopae Páscoa kientyguebyra kurâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aituo Pilatos ety odaji akaemo tâgawândyseba awylygue, Pilatoslâ egaserim, eagâmo oxioze. Eyanmo aguely: — Âdara nidâka awâkâ uguondo, ienado mâenwentâguedomoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","— Inakanhe aitobyry wâgâ merâ ewentâdyly. Inakanhe anipyra-ro watay, xarâ xina nenetaymba tâise. Xina ezewenry neinwântaymba merâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","— Âwymârymoanlâ sataungâ. Izewenrymo ara anipyra-ro watay, akaemolâ nenagazeneho — kely Pilatos. Aituo judeu domodo iwymârydo aguely: — Xinama ânguy nyâen-homba. Âmaemo Roma donropyry modo lelâ aieniem aguehoymby — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Judeu domodolâ xyâen-hoin-ro watay, kruz wâgâ inkâba tâise iguely, romano domodo lelâ mawânkâ ewentâdyby modo kruz wâgâ takâjize xyâen-honrim. Arâ aidyly olâ Jesus “Warâ ise yiguely” kehobyry adahowandoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatos tâty odaji egawântondyly. Sodadu domodoram aguely: — Xarâ Jesus enetaungâ — kely. Âtâ odaji Jesus nhadylymo. Târâ Pilatos aguely: — Judeu domodo iwymâry kuruka âmâ? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus in-hoguly: — Awârâ yapâigueho angahu odanolâ awârâ? Eagonro modo awârâ ywâgâ âyam agueim? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aituo Pilatos aguely: — Judeu mâkeba urâ. Yangahu oday inkâba xirâ unâry âtugudyly. Âpemugudolâ, kurâdo eynynâ Deus agâ aguewâni modo iwymârydolâ warâ inwentâni. Âdara midâka, akaemo iwentâdoem? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aituo Jesus in-hoguly: — Pymâ lelâlâ wâne urâ, xirâ anaymba olâ pymâem wawyly. Xirâ anano pymâlâ urâ-ro watay, ynynonro modo tâjitoguyzemo tâise, iemakehomoem, ienwentâgueni judeu domodo emaxi kâzegameomba witoem — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesus aguely tindatuo, Pilatos aguely: — Pymâ kuru âmâ? — kely. Jesus in-hoguly. — Pymâlâ urâ, amygueho aralâ. Xirâ onro anaynlâ yazely. Unâ iozeno egatuze keankâ kâewyly. Idânârâ unâ iozeno tindadysedo modo koendâ tydasemo, tutuzemo warâ augueho — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aituo Pilatos aguely: — Âdyka unâ iozeno mygueho? — kely. Egaseybyem Pilatos agueondyly Jesus ewentâni modoram: — Ienanaji, merâ iguehoem! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","— Izewenkemo alâ inanry Páscoa mâentyguedylymo ume etadâdyby ewy tokalâ kâentaguehonly, âdaunlo uguondo mâinduakeybymolâ. Âwymârymo Jesus âdara kânhenehonlyka ize matomo? Kâinmoen-hondyzeka âmaemo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aituo idânârâ in-hogulymo: — Alâ awâkâ nidâ! Barrabás etaguehongâ! — kelymo. Tâmagazeim, kyâim warâ myakâwâm Barrabás. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ilâpyryem myani tonlo Roma donro sodadu domodoram Pilatos aguely: — Jesus sapioguwâdaungâ xikotygue — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Agueduo, sodadu domodo Jesus nhapiogulymo. Ilâpyryem Jesus âwankuem nhedylymo. Tyguyreim koroaem xygatyby myakâwâm Jesus nhangahu onwa nhekylymo, pymâ domodo nhangahu wogonro ara. Âtâ BOH waunlo tapabileingue nhetydâdylymo, pymâdo âzetydâdo ara, âwankuem tientomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iopaji saindylymo. — Tynrenseim âmâ, judeu domodo iwymâry kuru! — kelymo, âwankuem nhedylymo. Tywapagainzemo myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatos egaseondyly. Kurâdoram aguely: — Idataungâ auguely! Jesus enenehondonze urâ xarâ, xyâhoem urâem âdygue ewentâdo lâpeba mâkâ awyly mâuntuhomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aituo sodadu domodo Jesus nhenetondylymo, âtâ BOH waunlo tapabileingue etydâdybyem, koroa tyguyreim xygatyby nhangahu wâgâ warâ. Pilatos aguely: — Etaungâ awâkâ uguondo! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aituo kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, Deus ety iguardary modo warâ Jesus tientuomo, adaenkelymo: — Kruz wâgâ nigue! Kruz onwa sakâjien-hongâ, iguehoem! — kelymo. Aituo Pilatos aguely: — Âmaemolâ sataungâ, kruz onwa sakâjiwâdaungâ warâ, iguehoem. Urâenma awâkâ âdanipyra — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Târâ âtâdyguywâdyby modo aguelymo: — Tâwâlâ awâkâ nigue! Uguondo kulâ awâkâ, “Deus agâ âzekibaom urâ” nygue olâ. “Deus imery urâ” nygue lâpylâ warâ. Xina ezewenryem, Deus ara tâidysedonro xyâly lelâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“ ‘Deus imery urâ’ nygue Jesus” kely tindatuo lakuru Pilatos, xyâen-honze âseanedyly kuru. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tâty odaxi egawântondyly, Jesus târâlâ awylygue, nhapâiguely: — Âdykonloka âmâ? — kely. Nihoguba olâ Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aituo Pilatos aguely: — Uhogugâ! Tarâ Jerusalémdâ pymâ kuru wawyly enanâguegâ. Ize urâ-ro watay, omoen-hondâ urâ, kruz wâgâ âehondâ urâ warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","— Deus amânhedyse ato lelâ yagâ amânhekyly. Deus aguepa kulâ, âdy yagâ amânhetaymba âmâ. Yâen-honly-ro watay, inakanhe kulâ awârâ, tutuzelâma âmâ, âdara wipyra wawyly yiguehoem. Âsenagazeze âmâ ayenehon-hombyry wâgâ. Mâkâ âyam iegamerimbyry olâ ise akadâ kehoem kuru âsenagazeni — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesus aguely tindatuo, Pilatos aguely: — Omoen-hoze urâ — kely. Judeu domodo târâ âtâdyguywâdyby aguelymo: — “Pymâ ton-honreim urâ” keanry Jesus. Romadâ kywymâry kuru toenzepa tyewiâpaze, tâjipyay pymâ kuruem ise kewâni modo agâ. Awâkâ uguondo mâimoen-honly-ro watay, pymâ Roma donro agâ iewiâpaze — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aguelymo tindatuo, Pilatos ekadyly tâwentâze, tâwentâzeba warâ awyly agueho mure onwa. Hebraiku-em, “Gabatá” awârâ âji ezedy: “Tadakobâdo tuhugue xygatyby” keze aguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kuotataji iseaji Páscoa etyguedo iray akâwâm awârâ aidyly, âtyem todohondyly ume. Tonlo modoram Pilatos aguely: — Etaungâ! Anra tarâ âwymârymo kuru! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Akaemo olâ adaenkelymo lelâ: — Kruz wâgâ nigue! Kruz onwa sakâjien-hongâ, iguehoem! — kelymo. Aituo Pilatos eyanmo aguely: — Âwymârymo kâyâen-hondyzeka âmaemo? — kely. Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo olâ warâ in-hogulymo: — Xina iwymâry mâkeba awâkâ! César lelâ pymâ kuru, Roma donro pymâ ton-honreim! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aituo Pilatos, Jesus nhegamely sodadu domodoram. Kruz onwa Jesus sakâjize nhadylymo, iguehoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kruz takâjiho tanâse Jesus idâly âji Calvário kehoram. (“Gólgota” keze aguely hebraiku-em.) ");
INSERT INTO bkqNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Myarâ saintybyem Jesus nhakâjilymo kruz onwa. Azagâ uguondo kyârimpyry nhakâjilymo lâpylâ, tokalâ aho eynynâ, eagonro pâem eynynâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tábua wâgâ iweniehonwânmy Pilatos: Jesus Nazaré donro merâ, judeu domodo iwymâry kuru kely akâwâm mârâ wâgâ iweniby azagâ tokalâ warâ itanwe: hebraiku-em, latín-em, gregüem warâ. Kruz wâgâ Jesus nhangawaym sodadu domodoram nhakâjien-honly. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Agui judeu domodo mârâ tábua wâgâ iweniby tytainzemo myakâwâm. Xidadâ iwaguepalâ mârâ âji Jesus nhakâjihomobyry awylygue, toenzepa sakadaynlymo-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo aguelymo Pilatosram: — “Judeu domodo iwymâry kuru” kely keba tâise mâinwenien-honly. “ ‘Judeu domodo iwymâry kuru urâ’ nygue merâ” kely tâise mâinwenien-honly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatos aguely: — Kâinwenien-hoymby, iwenibyenlâ ise! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kruz onwa Jesus tiankâjibygueduo, quatro sodadu domodo Jesus ety iwogompyry nhanâdylymo, nhepajiwâdylymo lelâ. Ilâpyryem, ety iwogonro BOH waunlo takâjizenry nhanâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aituo âjigue aguelymo: — Ety BOH waunlo kiaunguepa kine. Dadu kydyânre, mâkâ tyzortygueim ise âtâ BOH waunlo sodo — kelymo. Aituo arâ aidylymo. Saguhoenlâ myakâwândy Deus itaumbyry awo wâgâ iwenibyem awyly: “Mâkâem, mâkâem warâ iety ywogonropyry nepajiwâdâmo. Ânguy ietybyry BOH waunlo sodoem ini awyly tiuntuhomoem dadu namemo” warâ iwenibyem awyly. Arâ aituomo iwenihobyry ara kehoem aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kruzdâ iwaguepalâ akâwâm quatro pekodo modo: Maria, Jesus ise; Maria iwary; Maria (Magdala donro); Maria (Cleopas iwydy) warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","On-yam MYK itybyem Jesus tyze nhedyly, iedyly warâ, urâ toenzepa inwyneguyly. Aituo aguely tyzeram: — Âmerylâ-ro waunlo ara ise awâkâ João nhedyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aguely lâpylâ yam: — Awâkâlâ yze. Egâ, âzelâ mâenkyly-ro waunlo ara lelâ — kely. Agueduo, yze aralâ mâkâ kâendyly-ro warâ Jesus ize awyly. Ilâpyryem ietyram kandyly kâentoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ilâpygueduo tutuze myakâwâm Jesus kâmakehoem aiese tâetobyry âwanikely awyly. Saguhoenlâ Deus itaumbyry awo wâgâ iweniby aguehobyry ara aidyly aitoem aguely: — Tatuanze urâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tâlâ akâwâm vinhu nhewantybygue etary tumykeim. Mârâ ikaji esponja inkuilymo. Se hissopo wâgâ ekâjibyem, Jesus itaryam nhalokuândylymo, nhugakâin-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Mârâ xugakâinrimbyryem, aguely. — Iweâma alâ aiese kâetobyry! Arâ aguely kâmakehoem aiese tâetobyry âdypygueândyly awylygue. Agueypyem, enagozely, iguely lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aituo judeu domodo iwymârydo Pilatosram idâlymo, aguelymo: — Kruz modo onwa sakâjiwâdyby izepa enra xina târâ awyly xirâ kopae, kopaelâgâ warâ. Sodadu domodoram ixinarymo xukawânehongâ, inepa iguehomoem, eguepymobyry niguampyralâ etyhoem — kelymo eyam. Tâzekobyzegueho adagulylâ mawânrâ tynrenseim lelâlâ ani mârâ tâzekobyzegueho-ro warâ, Páscoa etyguedo awylygue. Inakanhe mawânrâ tâise âty tynrenseim ume kehoem âguedy sakâjibyem awyly. Awylygue târâpa enâtâguyly, sadyly warâ ize awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aituo nhekadybymo ara Pilatos anhenehonly. Sodadu domodo idâly. Jesus eapay kruz wâgâ sakâjiwâdyby modo ixinary nhukawâdylymo, mârâ ewânugue inepa iguehomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesus iopaji saintybyem olâ, igueypyem awyly nhedylymo. Awylygue ixinary nukagâbyra awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sodadu domodo ewy olâ akâwâm eledydâ Jesus tuhoguyze tylançarygue. Inepa kehoem iunu paru agonro ihuguely. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Urâ Jesus kruz wâgâ iguely enipyrylâ xirâ egatuim. Urâ kâentyby lelâlâ xirâ kâengatuly, mâinwântomoem lâpylâ. Âkealâ xirâ kâinwenily. Kâinweniby ara kehoem akâwâm aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Warâ myakâwândy saguhoenlâ iwenibyem awyly Deus itaumbyry awo wâgâ: “Ibyry ewy âdaunloenlâ tukagâduneba ise” warâ iwenibyem awyly. Aralâ akâwâm aidyly-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Arâ lâpylâ Deus itaumbyry awo wâgâ iwenibyem awyly: “Esemo mâkâ lançague tin-honguybymo” warâ iwenibyem awyly. Awârâ aituo saguhoenlâ Deus inwenien-hoymby ara kehoem aidyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Aituo myakâwâm José Arimatéia donro Pilatosram idâly agueze: — Jesus nigueaki, Pymâ. Kruz wâgâpa kâyntâguyândyze olâ urâ, tuhu imâsedo tâtagueim odaji kâenkanâdoem. Tâwâlâ kâyntâguyândyly? — kely. — Tâwâlâ — Pilatos keduo, José idâly myakâwâm. Jesus einwânni lelâlâ myakâwâm José, ânguyram negatuba olâ-ro warâ, pymâdo tyntadylygue. Aituo myakâwâm José, Jesus eguepybyry kruz wâgâpa nhytâguyândyly, nhaleholy-ro warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemos kopae Jesus agâ agueze idâypy, José agâ idâwâm lâpylâmy. Toenzepa myakâwâm Nicodemos aloés, mirra warâ nhadyly, trinta e cinco kilos lelâ, mârâ edunu tyânrânguneim âguedy onwa tientoem, inepa eguepybyry niwânzepa itoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesus eguepybyry nhadylymo, intuwynlymo, panu Nicodemos nhatyby tyânrânguneimpe tientybygue; kâzewenry awârâ, kâguepybyry kiontoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kruz wâgâ Jesus iguehobyry iwaguepa, tâlâ myakâwâm âji toenzepa se imâsedo modo etâdyby, jardim keho. Mârâ jardindâ tâlâ myakâwâm tâtagueim iwelo esagueyby tuhu imâsedo oday ânguy igueypy tâtadâzeba myarâ, iweloem awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Iwaguepalâ myani mârâ jardim, Calvariodâ. Awylygue José, Nicodemos warâ Jesus eguepybyry myarâ nhetadâdylymo, tâzekobyzegueho adagulylâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo, pealâ koendâ nemepyra awyly umelâ myani Maria Magdala donro Jesus eguepybyry etadâdobyryam idâly. Saintybyem, tâzegawânto enahun-ho tuhu ejikeybyem awyly nhedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aituo tâgase kehoem xinaram idâly. Toenzepa urâ Jesus inwyneguyly, Pedro warâ xina eydâ atoam idâly. Mâkâ xinaram aguely: — Kywymâry Jesus eguepybyrymy etadâdobyrydâba netymo. Âdyam nhetomobyry tutuzeba-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aituo Pedro, urâ warâ âguedy etadâdobyryam xina idâly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Xina egatudyly. Pedro takaze olâ akâwâm iegaky awylygue waunroenlâ yaindyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ioday kâentoem kâzewyly; panu linhugueto kâendyly, iegawâmpyra olâ akâwâm urâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yaimpygueduo akâwâm Pedro saindyly, egawândyly alelâ. Târâpa Jesus eguepybyry. Panu âguedy ituwyn-hobyry lelâ nhekyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Panu apiduby Jesus nhangahu wogonropyry lelâ warâ nhekyly. Mârâ Jesus ituwyn-hobyry modo duaypa nhangawyn-hobyry, âikâlâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Urâ, waunroem saintyby, tâtagueim odaji iegawândyly lâpylâ, âguedy etadâdobyryam. Âguedy târâpa awyly kâentuo, kâinwândyly Jesus kurâem itondobyry. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iwenibyem Deus itaumbyry awo wâgâ, Messias igueypyem kurâem itonze, kely. Tâenselâ, tydaselâ warâ lelâlâ wâne xina. Arâlâ olâ xina awârâ nutuba lelâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Koendâ kehoem enuagaenibyryem, tâtyam xina odopâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Âguedy etadâdobyry kuoholâ myakâwâm Maria Magdala donro ohogüendyly. Tuogunru umelâ, âzewyly, IU idyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Azagâ anju nhedyly, âtâ tapekeingue âzetydâdybyem, Jesus eguepybyry etadâdobyrydâ ekadybymoem; târâpa itybyem olâ Jesus eguepybyry. Tokalâ ekadybyem awyly nhangahu ejidypyrydâ, eagonro ekadybyem awyly ihuru ejidypyrydâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anju domodo pekodo nhapâiguelymo: — Âdaituoka ogunru? — kelymo. Aituo pekodo in-hoguly: — Ywymâry eguepybyry nadâmomy. Âdyam nhetomobyry kâuntuba olâ urâ-ro warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Awârâ agueypyem, MYRYK idyly. XYDYK warâ uguondo nhedyly. Jesuslâ myakâwâm; nutuba olâ mâkâem awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aituo Jesus aguely: — Âdaituoka ogunru? Ânguyka mâwinly? — kely. Mârâ âji enilâ-ro waunlo ara mâkâ enanaji. Awylygue in-hoguly: — Âmâlâ eguepybyry tarâpa etyin-ro watay, âdyam mânhetobyry yam aguekâ. Urâ ise eagonro âjiam sanehoim — kely pekodo. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","— Maria! — kely Jesus eyam. Tâzedy wâgâ tygâseduo, Jesus lelâlâ awyly nhutuly, aguely: — Rabôni! — kely. (Hebraiku-em, “Ywymâry” keze awârâ aguely.) ");
INSERT INTO bkqNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus aguely: — Yawâdâ. Pabairam kodopâdaymba lelâ urâ. Ynynonro modoram idâ, akaemo konodo ara kehoem kâinwyneguyly modoram. Warâ eyanmo aguekâ: “ ‘Pabairam ise kodopâdyly, mâkâ Pabai myguehomo, âDeusrymo warâam’ keanry Jesus” kera eyanmo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aituo Maria Magdala donro xina eydâ atoram idâly; xinaram aguely: — Kywymâry Jesus kurâem itondybyem setai — kely. Tyam Jesus aguehobyry xinaram nhegatuly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mârâ domingo, kopaelâ, âjigue âtâdyguybyem xina Jesus eynynonro modo. Pymâdo tawânehonly tytaze akâwâm xina. Awylygue pyanta modo koendâ kehoem enahunwâdybyem awyly. Pyanta enahuymby ozelâ Jesus egawândyly; âepanâguely xina ontay kehoem. Xinaram aguely: — Tâseguâdâzeba itaungâ, tyanepa warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ilâpyryem xinaram tâmary kruz onwa takâjihobyry nhenehonly; sodadu lançague tuhoguyhobyry nhenehonly warâ. Emarydâ, eledydâ warâ xyâhobyry tientuo, tutuze akâwâm xina, Jesus lelâlâ mâkâ awyly. Awylygue toenzepa akâwâm xina ohomaendyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aituo Jesus agueondyly: — Tâseguâdâzeba itaungâ, tyanepa warâ. Pabai ugonotobyry ara lâpylâ ogonodylymo, unâry mâengatuhomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ilâpyryem xina onwa ÂBU kely, aguely: — Tâwâlâ Deus Ispiritury âyanmo nâedâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Deus izepa ato aienibyry modoam, “Deusram ekaze urâ, inakanhe amitomobyry nhygakehoem” mygueduomo, Deus xygakeze lelâ. “Inakanhe amitomobyry Deus nygakeba itoem ekaze urâ” mygueduomo olâ, Deus nygakeba ise — kely xinaram. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Xinaram Jesus âepanâgueday, xina agâ inkâba akâwâm Tomé; xina eataen-ho Jesus eynynonro lâpylâ mâkâ. “Azagonropyry” kely lâpylâ mâkâ ezedy. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ilâpygueduo, saimpygueduo, eyam xina aguely: — Kywymâry Jesus kurâem itondyby xina netai — xina kely. Xina neinwâmpyra olâ mâkâ. — Mâkâ kurâem itondybyem awyly kâinwântaymba urâ. Kâinwândyly ise, pregugue emarydâ sakâjihobyry kâendyly, iemarygue MÂʼ kânhedyly, sodadu tylançarygue eledydâ in-hoguyhobyry iemarygue MÂN kânhedyly warâ watay lelâ ise kâinwândyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tokalâ semana sakanibyryem xina âtâdyguyondyly târâ, pyanta modo enahunwâdybyem kadiadugue. Ilâ ume Tomé târâlâ xina agâ. Pyanta enahuymby ozelâ Jesus egawândyly xina ontaji lelâ. Idânârâ xinaram aguely: — Tâseguâdâzeba itaungâ, tyanepa warâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ilâpyryem Toméram aguely: — Egâ iemary ihoguyhobyry; imary nhonwa iekâ. Iwâry saunâkâ, ieledydâ ihoguyhobyry onwa imary iekâ. Mâinwâmpyra mawyly imogâ. Kurâem itondybyem wawyly einwânkâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aituo Tomé eyam aguely: — Ywymâry, yDeusry warâ âmâlâ! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","— Kurâem itondybyem wawyly mâinwândyly, ietuo kulâ, tuomare âmâ-ro warâ. Tuomareim kuru olâ ise iepyralâ yeinwânni modo! — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Xina eynynonro modo tâense akâwâm toenzepa lelâlâ ton-honrugue anhetyby. Xirâ pape wâgâ kâinwenipa olâ urâ idânârâ kehoem adyesenry modo Jesus anhetyby. ");
INSERT INTO bkqNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Xirâ pape kâinwenily olâ, Jesus tâinwânsezelâ mitomoem, Deus Ingonotyby Messias awyly mâuntuhomoem. Deus imery awâkâ Jesus. Tâinwânse âmaemo-ro watay, aunlolâ ise agâmo awyly. Âiguelymo watay, Deusram idâze âmaemo, aunloenlâ eagâ mitomoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Awârâpygueduo, Jesus âepanâguely tynynonro modoram. Saimu imâsedo Tiberíades emelay xina awyly ume Jesus âepanâgueondyly xinaram. (“Saimu Galiléia” kelygue lâpylâ mârâ ezeku.) Aityby ise âyanmo kâengatuly. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Xina sete lelâ âjigue târâ xina awyly: Simão Pedro, Tomé (Azagonropyry kelygue tâzekeim), Natanael (Caná, Galiléia eynynonro), urâ João, paigo Tiago, azagâ xina eataen-ho lâpylâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Aituo Simão Pedro aguely xinaram: — Pepi oday kanra saweze ise udâly — kely. — Agâ kanra saweze idâze lâpylâ xina — xina kely. Aituo idânârâ xina idâly saimu emelaji. Pepi odaji xina âxiedyly. Emedyly ara kehoem âedâ paikaji samezeseze xina awyly, ânguy niwympa olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Emedyly wâgâ, paru emelay uguondo xina nhedyly. Jesuslâ akâwâm mâkâ, xina nutuba olâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Aituo Jesus ago kehoem aguely xinaram: — Âdara kanra maweakimo? Agui maweakimo? — kely. Xina in-hoguly: — Ânguy xina nawewâpyra enra! — xina kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xinaram aguely: — Pepi eahoru yan-yam âedâ samewâdaungâ. Toenzepa sawâse âmaemo — kely. Aituo xina âedâ nhamely. Inepa kehoem kanra modo inwynly. Toenzepa awylygue, pepi odaji epâguely xina nemaemba akâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aituo urâ João, Jesus toenzepa inwyneguyly, Pedroram auguely: — Kywymâry Jesus mâkâ! — uguely. Simão Pedro auguely tindatuo, tâty BOH waunlo nhetondyly, kanra tianwâtoem tientyby. Paikaji adamely. Sagunuram idâly tywâre, inepa Jesusram taintoem. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pepi oze xina idâly, tykâgueze, âedâ kanrague tumyke tâpâgueze, cem metros awârâem kulâ saintoem sagunu onwa. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pepi odayba âzetybyem, peto ehoru kanra pylâ nhangatay âjihuly-ro warâ xina nhedyly. Pãobe lâpylâ akâwâm peto opay. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aituo xinaram Jesus aguely: — Awâkâ kanra manwâtybymo ewy âenetaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aituo Simão Pedro pepi odaji âxiedyly. Âedâ sagunu wâgâ nhuxidyly. Tumyke kehoem mârâ âedâ, cento e cinquenta três kanra imâsedo modogue, nadatâwâbyra olâ mârâ âedâ. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","— Âwinduataungârâ — kely Jesus. Jesuslâ awyly tutuzelâ akâwâm xina, tywypaze olâ akâwâm xina, mâkâlâ awyly tiuntuhoem eyam agueze. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aituo Jesus iopaji xina saindyly. Pão nhanâdyly. Xina ara nhepajiwâdyly. Xina ara lâpylâ kanra âjihuyby nhepajiwâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus kurâem itondybyem, azagâ tokalâ warâ âepanâguely idyly akâwâm xina tynynonro modoram. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Xina âwinduapygueduo, Jesus Simão Pedro nhapâiguely: — Simão, João Betsaida donro imery, toenzepa lelâlâ ywynedâ âmâ âdydo imeom takaze kehoem? — kely. Aituo Pedro in-hoguly: — Tutuzelâ âmâ, toenzepa âize wawyly — kely. — Arâ atayma ywâgâ aguekâne iwelo yeinwânni modoram. Tâguy ovelha imery nheto ara egâmo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aituo Jesus agueondyly: — Simão, toenzepa lelâlâka ywynedyly? — kely. — Tutuzelâ âmâ, toenzepa âize wawyly — kely Pedro. — Arâ atayma ywâgâ aguekâne yeinwânni modoram. Ovelha eni ovelha nheto ara lâpylâ egâmo — keondyly Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus agueondyly, saguhoem adâkehobyry araba: — Simão, toenzepa yize mawyly? — kely. Awârâ tindatuo, Pedro itywandyly, in-hoguly: — Idânârâ xuturinlâ âmâ; toenzepa âizetonro wawyly tutuzelâ âmâ — kely. Aituo Jesus agueondyly: — Arâ atayma ywâgâ aguekâne yeinwânni modoram. Ovelha eni, ovelha nheto ara egâmo — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","— Salokuzenomoem mawyly ume, ton-honre ani âmâ, ize matobyryam mydâhoem. Xirâ âyam augueho olâ ise âkealâ. Agaityoem mituo âzemakâjioze âmâ. Mydâdyseba matoam ise madaholy — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Awârâ arâ adâkeday, Jesus nhutuen-honly, âdara Pedro iguely awyly. Arâ Pedro tyigueho odaji kehoem Deus nheinwântobyry wâgâ ise Deus âzehogueoly Pedro eon-honru nhuduhobyry wâgâ. Aituo Jesus Pedroram aguely: — Ynynonroenlâne ikâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro ikaynâ akâwâm urâ, urâ toenzepa Jesus inwyneguyly. Kopae Páscoa ume xina âwinduatay, urâlâ akâwâm Jesus eatado ekani; urâlâ, “Ânguyka ise igamenri âehondyzedo modo emaxi?” kerim. Âdara tyiguely awyly wâgâ Jesus aguely idanipyryem, Pedro MYRYK idyly. Tykaynâ iedyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jesus nhapâiguely: — Âdyka ise João agâ aini? — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus in-hoguly: — Awârâ wâgâ tâtynanâzeba ikâ. “Kodopâdo odaji niguepa nidâ” uguely watay, mâuntuly mâkeba awârâ. Yeinwânsezedyly wâgâ lelâ âtynanâgâ — kely Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Awylygue âjigue Jesus einwânni modo aguelymo: “ ‘Kodopâdo odaji niguewâpyra ise João’ nygue Jesus” kelymo. “Âiguewâpyra ise âmâ” kewâpyra akâwâm Jesus ywâgâ. Warâ ani aguely: “ ‘Kodopâdo odaji niguepa nidâ’ uguely watay, awârâ modo wâgâ tâtynanâzeba ikâ” kely Pedroram. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kâentyby, kâindatyby warâ xirâ kâinwenily Jesus eynynonrolâ urâ João toenzepa inwyneguyly. Idânârâ yataen-ho modo tutuzemo âkealâ xirâ pape wâgâ kâinwenily awyly. ");
INSERT INTO bkqNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tâlâ wâne xirâ pape wâgâ kâinweniby. Tâlâ olâ toenzepa âdydo imeom modo Jesus anhetaymby. Idânârâ kehoem anhetyby, aguehobyry warâ iwenily watay, toenzepa lelâlâ tâise livrupe awyly! Idânârâ onro anaym pape iweniby ejidy lâpeba tâise. João");
INSERT INTO bkqNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Âyam xirâ pape kâinwenily, Teófilo. Azagâ ieto xirâ kâinwenily. Waunro kâinweniby wâgâ Jesus tarâ onro anaym tâwanu nhaguday anhetyby, nhenomedâdobyry warâ, kayam idâhobyryam. Deus eydâ atoram tâtâly iraynâ, Deus Ispiritury eon-honrugue, tunâry egaturin-em tinduakeyby modo eon-honru xuduwânmy, aitomoem, aguehomoem warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kurâem tâitombygueduo, quarenta emedyly ara tâepanâguezezelâ myani tunâry egatuwâni modoram. Toenzepa adyesenry modo Deus eon-honrugue adyese myani, igueypyemba tawyly tienehon-hoem. Âdara Deus pymâem kuru idyly awyly wâgâ myani eagâmo aguely. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tunâry egaturin-em tinduakeyby modo agâ Jerusalémdâ tatay, warâ myani Jesus eyanmo aguely: — Tâgasezeba wao itaungâ xirâ âtâ anaymba. Tarâlâ wao itaungâ, Deus Ispiritury âyanmo saindyly ara. Saguhoem âyanmo, “Deus Tyispiritury igonose” uguelâ. Saindyly inwânwântaungâ wao. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Saguhoem João batiza nhedyly ani parugue. Iweâpa nipyralâ olâ ise Deus Ispiriturygue batiza mâieholymo, ynynonroem mawylymo mâenehon-homoem — kewânmy Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tunâry egaturin-em tinduakeyby modo agâ âtâdyguybyem myani Jesus. Aituo myani akaemoram adapâigueoly: — Pymâ, anri ise iweâma kypemugudo israelita domodo eon-honru mâunduly, âjiguelâ kywymâgoem, Roma donro modo keba kywymâry itoem? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aituo myani Jesus in-hoguly: — Tâseguâdâzeba itaungâ awârâ wâgâ. Pabai Deus “Warâ ise aidyly” kehobyry saintuo, idânârâ aguehobyry ara aise. Mâuntulymo keba ise anhekyly modo; âdara aidyly awyly mâuntuwâbyra ise âmaemo. Pabai kulelâ xuturim. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Deus Ispiritury âyanmo saintuo olâ, on-honrumo xuduze, unârybyry mâengatuhomoem. Waunroem kuru tarâ Jerusalémdâ ise unârybyry mâengatulymo. Ilâpyryem ise Judeiaram, Samariaram warâ mydâlymo unârybyry egatuze; ilâpyryem ise idânârâ kurâdo onro anano modo ara-ro warâ — kely myani Jesus. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tunâry egaturin-em induakeyby modo agâ awyly umelâ myani Deus eydâ tatoram nhalokuânehonly. Âkuly umelâ myani eunu duaxi xuzadyly. Aituo myani nepyra idylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Târâ Jesus âkuhobyrydâ nhesedylymo ume myani azagâ anju, uguondoem tapekeingue tâtyem âepanâguely; Deus emary myani akaemo. Jesus tunâry egaturin-em induakeyby modoram myani âewylymo. Aituo myani aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","— Nhaum, Galiléia donro modo, âdaituoka kaynâ lelâ inurumo? Âydâmopa nitai wâne mâkâ Jesus odopâze olâ. Iwerâ âkuly mâentomobyry ara lâpylâ ise odopâdyly, âzeholy — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aituo myani Jesus tunâry egaturin-em induakeyby modo odopâdaynly Jerusalémram, iwyry Se Oliveira Eka dombyryem. Tokalâ kilômetro myani mârâ âtâ anaymba awyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Âtâ anaxi saintybyem myani âtâ tâxidâdomobyryanlâ idâlymo. Salá imâsedo kaynonro odaymo myani. Pedro, João, Tiago (Alfeu imery), André, Filipe, Tomé, Bartolomeu, Mateus, Tiago warâ, Simão, (tâty anary izetonro lelâlâ, tawylygue Roma donro kulâ tywymâryem izepaom modo ewy), Judas (Tiago imery) warâ myani akaemo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aunlolâ myani târâ pekodo modo agâ âtâdyguylymo Deus agâ adâkehoem. Jesus ise, iukonodo warâ târâmolâ lâpylâ myani. Aunlolâ myani akaemo idânârâ idâly, Deus agâ agueze. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Iweâpa nipyralâ myani toenzepa kehoem kurâdo Jesus einwânni modo âtâdyguyly, cento e vinte awârâem myani kurâdo. Âtâdyguybyem awylymo ume myani Pedro saudyly, aguely: ");
INSERT INTO bkqNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","— Nhaum, ydataungâ, Cristo eynynâ ypemugudo. Davi iweniwânmy iweâpa mâkâ Judas aitobyry wâgâ. Deus Ispiritury, Daviram inwenien-hoymby ara kehoem keankâ aidyly. Mâkâ Judas keankâ Jesus egamenri. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Xina duano lâpylâ keankâ mâkâ, xina agâ tâwaneinhe iduakeyby mawânkâ keankâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Âmaemo, Jerusalém donro modo tutuze âmaemo Judas dinheru nhemakehobyry, Jesus iduery modoram tiengamehoem. Mârâ dinheruguelâ mykeankâ onro adanâholy. Târâlâ mykeankâ kaynâpa tâihugueduo, atuly. Atuduo, idânârâ kehoem ekomiry modo egasewâdyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Idânârâ Jerusalém donro modo aityby nutumo. “Aceldama” kelygue mârâ âji nhezetâdylymo. (“Xyâhoem egamehobyry ebyrygue sanâtyby” keze aguely) — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Aituo myani Pedro aguely: — Arâ lâpylâ livru Salmosdâ iwenibyem awyly: “Ânguy lâpeba ise ety oday. Ânguy lâpeba nidâ ioday” — warâ kelype. Alâpylâ Salmosdâ iweniby: “Âkelo ejipyano nidâ, anhekyly kehobyry anhetoem” warâ myakâwândy saguhoem Deus itaumbyry iweniby. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","— Arâ atay, uguondo kinduakenre kuduanoem, Judas Queriote donro ejipyano Jesus xunâry egaturin-em. Jesus kurâem itondybyem awyly xuturim, enipyry. Pymâ Jesus kiampygueday kyampyguenibyry, ");
INSERT INTO bkqNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jesus ewanu adaguday, âdypygueânday warâ eagâ idâypy, Jesus Joãoram batiza âieholy enipyry, Deusram adalokuonly enipyry ise kinduakely — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aituo myani idânârâ tonlo modo âseinwândylymo. Aguelymo: — José Barsabás (“Justo” keho) atay, Matias atay warâ nidâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Âdykonlo akaemo azagâ enday iduakeyby awyly tiuntuhomoem myani, Deus agâ aguelymo. Warâ myani aguelymo: — Pymâ, tutuze âmâ idânârâ kurâ domodo âdaunlo awyly. Enehongâ âdykonlo mâinduakeyby awyly. Âdykonloka asaemo azagâ enday xina agâ mâingonokyly, Judas etaybyay âunâry egatuze? Xirâ âwanu mawânkâ Judas nimo. Ejidy mâinduakeybyanlâ nâtâ warâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ânguy akaemo azagâ uguondo enday tuduakezeim awyly tiuntuhoem aiemâmomy. Arâ myani Matias induakelymo. Aituo mâkâ Jesus xunâry egaturin-em iduakeyby modo arâ aguenriem idyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostes etyguedo ume myani idânârâ Jesus einwânni modo tâjidydâ âtâdyguylymo. Trigu ekaunâdyly israelita domodo nhetyguedo myani mârâ âty. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ilâ ume myani Deus Ispiritury nhonwamo xytâguyly. Sapezenru ton-honreim ara kehoem myani Deus eydâ atodâba ipyru xytâguyly indadylymo. Idânârâ kurâdo âtâ oday ekadaymby modo idamâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aituo myani peto iatygu emyenro nhedylymo. Agui myani mârâ aunlo âzepajiwâdyly, mâkâ angawaym, mâkâ angawaym, mâkâ angawaym warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Deus Ispiritury nhonwamo âewyly, koendâ kehoem enomerymo xuduze. Aituo myani Deus Ispiriturybe tâituomo, âkelo anano modo itanwe aguelymo lâpylâ, tytanwe lelâba. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Târâ Jerusalémdâ toenzepa myani judeu domodo Deus einwânni. Mârâ ananobyry lelâba myani myarâ saini. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jesus einwânni modo âkelo anano modo itanwe aguely tindatuo myani akaemo eagonro anano modo ewy âtâdyguylymo. Mârâ tâjitanrugue nâsenomedâbyralâ myani aguelymo. Idase âtâdyguywâdyby modo toenzepa myani âsewânilymo. Koendâ kehoem mawânkâ myani aguehomo indadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Toenzepa myani âsewânilymo, awylygue âjigue aguelymo: — Galiléia donro asaemo aguewâni modo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Kytanwelâ olâ aguelymo kindakyly! Âdara kuruka arâ kehoem aguelymo? ");
INSERT INTO bkqNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Âzeydonro keba, âjitanweom keba warâma kurâ. Pártia donro, Média donro, Elão donro, Mesopotâmia donro, Judéia donro, Capadócia donro, Ponto donro, Ásia donro warâ kurâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Tâlâ kuduay Frígia donro, Panfília donro, Egito donro warâ. Tâlâ tarâ kuduay Líbia eynynonro modo, Cirene iwaguepanro. Tâlâ kurâ Romadâpa âetyby. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tâlâ tarâ kuduay judeu domodo lelâlâ, Israel iweompyry. Tâlâ lâpylâ tarâ âkelo kurâdo; akaemoma Israel iweom keba; judeu domodo ezewenry iweniby tâinwânsemo olâ. Creta donro, Arábia donro warâpe tarâ kuduay. Âdaraka tâjitanru tiuntudânrygue aguelymo? Kytanwelâ asaemo, Deus koendâ anhetaymby modo wâgâ aguely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Âseguâdâdylymo myani. Âdara tâkeho nutuba idylymo. Aituo myani âjigue adapâiguelymo: — Âdaituoka awârâ awyly? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kurâdo olâ myani Jesus einwânni modo tyeilezemo lelâ. Warâ myani aguelymo: — Toku ikay tawylygue kulâ asaemo arâ aguely — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Aituo myani Pedro agueze saudyly. Târâ lâpylâ myani akaemo onze lelâ Jesus tunâry egaturin-em induakeyby modo. Ago kehoem myani târâ âtâdyguyby modoram, Jerusalémdâ tâtyuneim modoram, saintaymby modoram warâ aguely: — Nhaum, koendâ auguely idataungâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Toku ikay inkâba xina, amyguehomo ara inkâba. Emedyly wâgâ kulâ awârâ, nove hora kulâ. Emedyly wâgâ xina judeu domodo vinhu nenywâbyra. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Warâ âyanmo auguely, xina arâ aguely mâindatomobyry wâgâ. Deus itaumbyry egatuimbyry Joel Deus aguehobyry inwenibylâ xirâ aini. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Warâ myakâwândy Deus aguely: “Xypyry iray ise xirâ agânhedyly. Mârâ ume, Yispiritury idânârâ kurâdoram igonose urâ, âuturimoem. Judeu domodoram, judeu keba modoram alelâ ise kâingonodyly. Âweompyrymo unâry egatuze, uguondo modo, pekodo modo alelâ. Salokuzenomo modo, âwynsaundo modo warâ Yispiritury anhekyly nhetomoem aienehonze urâ. Agaityom modoram, aripidoram warâ ywâgâ auguely ise nhâenkymoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ynynonro modoram ise mârâ ume Yispiritury kâingonodyly. Pekodo modo agâ, uguondo modo agâ alelâ ise. Ywâgâ ise mârâ ume aguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kyaneni kau wâgâ iepanâgueze urâ, ton-honre wawyly kâenehohoem. Onro anaym adyesenry modo aiese lâpylâ urâ, won-honru kâenehohoem. Toenzepa ise munru apâdyly. Toenzepa âjiaduâhonzemo petoam. Nâepaiguebamo ise eunu wâgâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Xixi tohoreba ise. Munru ara ise nunâ, sapabilu. Kywymâry sainto iray ise awârâ aidyly. Toenzepa ton-honre tawyly tânehonze ise âewyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Idânârâ, ‘Xina emakegâ, Pymâ’ keypy emakeze” kely iweniwânmy Joel, Deus itaumbyry egatuimbyry — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Aituo myani Pedro agueondyly tonlo modoram: — Nhaum, Israel donro modo, idataungâ xirâ auguely. Jesus Nazaré donro wâgâ xirâ auguely. Tyiguely iraynâ, agâmo tatay, inanaynmolâ keankâ âdaunlo uguondo kulâ anhetânry modo anhedyly. Kyzedâlâ koendonro modo, adyesenry modo warâ kientoem anhedyly. Deuslâ keankâ mârâ koendonro modo, adyesenry modo warâ Jesusram aienehonrim, tingonotyby kuru awyly tienehon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Âmaemolâ olâ keankâ Jesus egamenri, tumunreim modoram kruz onwa adakâjiohoem, iguehoem warâ. Deus aguehobyry aralâ olâ keankâ awârâ modo aidyly. Tutuzelâ myani arâ amidylymo awyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jesus igueypyem awyly ume, Deus olâ kurâem nietondâ. Nigueompyra ise mâkâ-ro warâ. Nudupa lelâlâ tâise mâkâ iguewâtyby modo ejidydâ etadâdyby ara itoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kydamu Davi iweniwânmy Jesus wâgâ: “Ywymâry aunlolâ yagâ awyly, tutuze urâ. Yagâpa nitaymba. Tyanunepa urâ, yagâlâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Awylygue toenzepa womaru. Auguepa witaymba urâ Deus koendonroem awyly wâgâ, womazeândylygue. Iguein-em wawyly umelâ, kâinwâmpyra wipyra wawyly. Iekobyzeguehobe wawyly tynwânwânse wawylygue. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tutuze urâ, alâ igueypyenlâ yenehomba mawyly. Wodo mâinwânzeânehomba mawyly warâ, Pymâ. Âynynonroem wawylygue, imary wawylygue warâ, igueypy modo duay yenehonwâbyra ise âmâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Âdara aunloenlâ kyiguepa kitoem aguidyly wâgâ ienomedâdâ. Toenzepa ise womaru, aunloenlâ agâ wawylygue” kely iweniwânmy Davi — kely Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Aituo myani Pedro agueondyly: — Ypemugudo, koendâ mâuntuhomoem awârâ Davi inweniby wâgâ agueze urâ. Tywâgâ inkâba myakâwândy aguely. Iweâpa mawânkâ myakâwândy kydamu Davi iguely. Eguepybyry sadyly myakâwândy, tâtagueim esagueyby tuhu imâsedo odaji. Târâ myakâwândy inwânzely. Iwague inkâba mâkâ Davi eguepybyry etadâdobyry tâtagueim tarâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Deus itaumbyry egatuim myakâwândy mâkâ, niguepa tatay. “Tokalâ âwerymo ewy ise pymâem kânhekyly. Judeu domodo iwymâry wâne maze myara ise pymâem awyly. Agânhekyly modo lelâlâ xirâ âyam augueho” kewânmy Deus, Daviram. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Awylygue myakâwândy Davi tutuze lelâ awyly Deus ingonokylybe awyly. Deus Ingonotyby igueypyem, kurâem itondyly Deus eon-honrugue awyly tutuze myakâwândy. Awylygue myakâwândy, “Igueypyem lelâ mânhenehomba, eguepybyry mâinwânzeânehomba warâ ise âmâ” kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","— Âkealâ olâ Deus eon-honruguelâ keankâ Jesus kurâem itondyly. Tutuze xina âkealâ awyly. Jesus igueypyemba awyly xina nedâ. Âkealâ tâkeze xina: “Kurâem itondybyem mawânkâ!” ");
INSERT INTO bkqNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eydâ tatoram olâ Deus nadâ. Pymâ tynrenseinhe mâkâ iwerâ, Tunwym ahoru eynynâ ekadybyem awyly. “Ispíritu igonose urâ” tâkehobyry Jesus nigonotai xinaram iwerâ. Sapezenru ton-honreim ara kehoem âjipyruguely midataimolâ. Peto iatygu ara kehoem xina wâgâ metaimolâ. Âtanwemo xina aguely midataimolâ warâ. Iwerâ Ispíritu Jesus ingonotybylâ awârâ modo aieni. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tywâgâ inkâba myakâwândy kydamu Davi aguely. Deus eydâ atoram nâtâwâbyra myakâwândy eguepybyry. Jesus wâgâ myakâwândy awârâ Deus aguehobyry Davi inwenily: “Yahoru eynynâ ikagâ tynrenseim ekadodâ, ");
INSERT INTO bkqNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","âduery modo eon-honru kainly ara, âdydo ara kulâ âhuru iaxi kânhedylymo ara” kewândymy Deus. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","— Nhaum, Israel domodo, koendâ ydataungâ. Kywymâryem Deus ingonotyby keankâ mâkâ Messias kruz onwa mankâjien-honlymo, Deus Ingonotyby “Âese” kehobyrylâ — kely myani Pedro târâ âtâdyguyby modoram. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Arâ Pedro aguely tindatuo myani idânârâ kehoem itywandylymo, Jesus tienagazenehon-hobyry wâgâ. Aituo myani Pedro domodoram aguelymo: — Âdaraka ise xina aidyly iwerâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aituo Pedro in-hoguly: — Âjityendaungâ inakanhe kulâ amitomobyry wâgâ. Deus izepa ato aiedyly imowâdaungâ. Jesus einwântaungâ warâ, Deus inakanhe amitomobyry nhygakehoem. Batiza âiehowâdaungâ, Jesus eynynonroem mawylymo mâenehon-homoem. Tyispiritury igonose mâkâ, aunloenlâ agâmo itoem — kely myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","— “Âyanmo, âmeombyrymoam, âweompyrymoam, idânârâ âtâ anary onro anano modoram warâ ise kâingonodyly” nygue mawânkâ. Deus tynynonroem tingâsedaymby modoram Tyispiritury igonose — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eyanmo aguezesezelâ myani Pedro; aguely: — Inakanhe amidylymo imowâdaungâ. Jesus einwântaungâ, imakehomoem, Jesus einwântânry modo ara mâsenagazebyra mitomoem — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Agui tonlo modo ewy Pedro aguely tâinwânsemo myani. Jesus nheinwântuomo myani batiza âieholymo, Jesus eynynonroem tawyly tienehon-homoem. Ilâem toenzepa kurâdo Jesus tâinwânsemo myani, três mil awârâem. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Koendâ kehoem myani Jesus tunâry egaturin-em induakeyby modo aguely indadylymo. Tindatuo myani toenzepa kehoem nheinwândylymo, Jesus wâgâ nhenomedâdylymo warâ. Âdy pebaonram tâlâ tato nhudulymo. Deus agâ agueze âtâdyguylymo. Âwinduase âtâdyguylymo lâpylâ warâ, Jesus iguehobyry tienanâguehomoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Deus eon-honrugue adyesenry modo kehoem myani Jesus tunâry egaturin-em induakeyby modo anhekyly. Awârâ modo anhedylymo tientuo, idânârâ kurâdo Deus tynrensemo tawyly enehonwânmomy. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Idânârâ Jesus einwânni modo âjigue nâtâdyguyba nipyramo myani. Tâlâ tato nhepâdylymo ipaom modoram. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tonrorumo, âdydo imeom tâlâ tato warâ vende nhedylymo. Ebyry tienmakeybygue, âdy pebanro modo xurâem âdylâ nhanâdylymo warâ myani aidylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kopaelâgâembaba myani Deus ety idaseray âtâdyguylymo. Alâpylâ myani tâtydâ âtâdyguylymo âwinduase, Jesus kruz wâgâ iguehobyry tienanâguehomoem. Âjigue iomarunumo. Tâwânrempamo myani, âkelomo agâ tâzepajigâzemo lelâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Deus nhomaendylymo. — Deus koendonro kehoem âmâ xina agâ — kezesedylymo. Jerusalém donro modo myani akaemo ehogueni. Kopaelâgâembaba myani kurâdo Jesus einwânni âtâdyguyly, agui isezedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Três horas kogonekâ, judeu domodo Deus agâ agueho oday myani Pedro, João warâ Deus ety odaji idâlymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Târâ myani uguondo adakobâdânry nhedylymo, ihuru, ipaunru warâ tywyke iazeypy. Kopaelâgâembaba myani eataen-ho modo nhadyly Deus ety iwyantaji, “Portão Iwâkuru” kehoram. Târâ myani ekadybyem tawyly ume, Deus ety odaji egawânni modo nhekaendyly: — Ytyendaungâ. Ydinheruru wao âunduwâtaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aituo myani Pedro, João warâ egawândyly. Akaemo tientuo myani aguely: — Ydinheruru wao âunduwâtaungâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Agueduo azakâlâ eyam MYK idylymo. Pedro aguely eyam: — Xinaram MYK ikâ — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Agueduo myani mâkâ uguondo MYK idyly eyanmo. — Ydinheruru nhudulymo wâne isenra — kely tyangahu oday. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Warâ olâ myani Pedro aguely: — Tydinherugunepa urâ. Dinheru takaze kehoem koendonro olâ ise âyam kâunduly. Jesus Cristo Nazaré donro eon-honrugue âyam auguely: “Aukâ. Adakobâgâ warâ” — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Agueypyem myani Pedro mâkâ uguondo emary aho eynynonro wâgâ nhawâdyly, sautoem. Ilâ umelâ kehoem myani mâkâ uguondo saudyly, adakobâdyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kua itybyem tawylygue, tuomarugue tadameze kehoem myani Deus ety idaseraji idâly, Pedro, João warâ agâ. Warâ myani aguely: — Deus, koendonro kehoem âmâ, kua yetai — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Idânârâ tonlo modo emâmomy mâkâ adakobâdyly, adamely warâ. Deus koendonroem awyly wâgâ aguely tydasemo lâpylâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Âseguâdâmâmomy mâkâ koendâ adakobâdyly tientuomo. Aituo myani âjigue aguelymo: — Mâkâ pyantano adakobâdânrybyrylâ awâkâ. Aunlolâ inanry sakadaynrim modo nhekaendyly. Etaungâ! Adakobâdyly, adamely warâ aidyly! Ânguy nheinwânkylyemba lâgâlâ! — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mâkâ uguondo adakobâdânrybyry Pedro, João warâ agâ tâise lelâ myani; Alpendre de Salomão keho taserano oday myani akaemo azagâ tokalâ warâ. Mâkâ kua itobyry wâgâ tâsewânilymogue myani kurâ domodo tâgaune kehoem idâlymo eyanmo, kua ityby ese. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Târâ toenzepa kurâdo âtâdyguyly tientuo myani Pedro aguely eyanmo: — Nhaum, koendâ ydataungâ, kydamu Israel iweom. Tâseguâdâzeba itaungâ. Xina arâ kâzesedaundâ. Ton-honrugue inkâba enra xina merâ adakobâdânrybyry kua nhedyly. Xina koendonroem awylygue inkâba merâ adakobâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kydamudo Abraão, Isaque, Jacó warâ iDeusry enra Jesus eon-honrugue kua itoem aieni, koendonro, ton-honreim waunlo Jesus awyly tienehon-hoem. Tâmaryem myani Deus, Jesus ingonodyly. — Alâ olâ keankâ pymâ modoram mâengamelymo, kruz wâgâ iguehoem. Pymâ Pilatos wâne keankâ tienagazenehondyzeba. “Kruz onwa sakâjien-hongâ iguehoem!” myguewâtaundâmo olâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Koendonro, âdaini keba keankâ mâkâ Jesus. Pilatos nenagazenehomba itoem âkeá myguepa olâ mataunaguynre. “Kyârim Barrabás etaguehongâ. Jesus kruz onwa sakâjien-hongâ” myguelymo lelâ keankâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kyigueânehondânry keankâ iguedyse matomo. — Deus kurâem nietondâ olâ-ro warâ. Jesus kurâem itybyem awyly, tutuze xina, tientobyry wâgâ, aguely tindatobyry wâgâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Merâ uguondo âdaunlopyry awyly koendâ tutuzelâ âmaemo. Jesus eon-honrugue olâ enra kua idyly. Koendâ adakobâdyly metaimolâ. Inumo angataylâ enra Jesus eon-honrugue kua idyly, Jesus adyese awyly xina nheinwândylygue. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","— Ypemugudo, âwymârymo agâ Jesus kruz onwa mankâjien-hondaymo, Jesus, Messiaslâ awyly mâuntuwâbyra keankâ akaemo. “Kruz wâgâ sakâjien-hongâ” myguedaymo, Deus Ingonotyby mâkâ awyly mâuntuba mawylymo xutu. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“Kâinduakeyby âzenagazeoze, igueze warâ” kewânmy Deus, tytaumbyry egatuwâni modo aguehoem. Arâlâ keankâ anhenehonly, adâkehobyry ara aitoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Âjityendaungâ, inakanhe amitomobyry wâgâ. Deus izepa ato aiedyly imowâdaungâ. Jesus einwântaungâ, inakanhe amitomobyry Deus nhygakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Arâ aitaungâ, Pymâ Deus kua âetomoem lâpylâ, Jesus âyanmo ingonotoem warâ. Deus, “Messias igonose urâ einwânni modoram” kewânmy. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","— Iwerâ Jesus târâ Deus eydâ atodâ. Tytaumbyry egatuim modo aguehoem aguewânlâmy Deus: “Auguehobyry saintuo, idânârâ iweloem iese urâ” kewânmy. Adâkehobyry saintuo, Jesus igonotonze mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Iweâpa Moisés inweniby ara ise aidyly: “Tokalâ kypemugu âyanmo igonose Kywymâry Deus. Deus wâgâ ise mâkâ âyanmo aguely. Tunâry egatuze ugonodâ myara ise mâkâ ingonodyly lâpylâ. Idânârâ aguehobyry ara aitaungâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Inakanhe kehoem ise Deus idânârâ tâinwândysebanrobyry modo nhenagazenehonly. Deus eynynonro modo duaypa ise akaemo tyguelâ. ‘Ynynonro keba asaemo’ keze mâkâ-ro warâ” kewândymy Moisés. Jesus onro anaxi naimpyra ataylâ myakâwândy inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","— Idânârâ myakâwândy akaemo saguhoem Deus itaumbyry egatuwânibyry modo Deus Ingonokyly saintuo aitaynrim modo wâgâ aguelymo. Samuel, eagonro modo warâ xirâ wâgâ aguewânmomy. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Deus itaumbyry egatuwânibyry modo iweompyrylâ kurâ, âmaemo, xina lâpylâ warâ. “Koendonro âmaemoem xuduze urâ” kewândymy Deus kydamudoram. Eyanmo lelâba myakâwândy aguely, kyam lâpylâ warâ. Kydamu Abraãoram aguehobyry enanâguewâdaungâ: “Tokalâ âwerypyry ewy wâgâlâ ise idânârâ onro anano modo agâ koendâ wawyly” kehobyry. ");
INSERT INTO bkqNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","— Iweâpalâ “Messias igonose urâ” tâkehobyrylâ myakâwândy Deus, ingonokyly kurâ israelita domodoram. Koendâ kyese, kieinwântoem, inakanhe kydawyly kinmohoem warâ myani ingonodyly — kely myani Pedro târâ âtâdyguyby modoram. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro, João warâ aguelymo ume myani kurâdo eynynâ Deus agâ aguewâni modo iwymârydo saindyly. Deus ety iguardary iwymâry, saduceu domodo warâ saindylymo, aguelymo idase. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro, João warâ, “Tyigueduo, Jesus kurâem nitondâ. Awylygue lakuru mawânrâ idânârâ iguewâtyby modo kurâem itonze awyly kiuntuly” kelymo tindatuo myani toenzepa kehoem iewiâpadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aituo myani guarda domodoram aguelymo: — Awâkâ azagâ uguondo sawâtaungâ. Ekâjiwâdaungâ. Sataungâ kadeia odaxi. Târâlâ wao nemedâmo. Nudupa enra iwerâ, juizram satomoem — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Toenzepa myani akaemo, azagâ uguondo Jesus wâgâ aguehomobyry idataynrimbyry modo Jesus nheinwândylymo. Cinco mil uguondo modo awârâem myani Jesus einwânni, iwelo einwânni modo agâ, pekodo modo, iamimeom warâ tapâguezeba. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kopaelâgâem myani pymâ Jerusalém donro modo âtâdyguylymo, judeu domodo iwymâry, agaityom modo, Moisés ezewenry wâgâ iweniby enomedâni modo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Târâlâ myani Anás. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru myani mâkâ. Ipemugudo tarâlâ lâpylâ myani, Caifás, João, Alexandre, eagonro modo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Aituo myani sodadu domodoram aguelymo: — Pedro, João warâ enetaungâ xarâ — kelymo. Aituo myani ese idâlymo, nhadylymo. Saintuomo myani pymâdo tânadoram ingâsedylymo. Tânadoram idâduomo myani nhapâiguelymo: — Ânguy unâry wâgâka keankâ uguondo adakobâdânrybyry kua mânhedylymo? Ânguy eon-honrugueka keankâ koendâ adakobâdoem amânhedylymo? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Deus Ispiritury ton-hondâni awylygue tyanepa kehoem eyanmo Pedro wakely: — Idaenkulymo wao, pymâ domodo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mâuntudyze âmaemo merâ uguondo adakobâdânrybyry xina kua nhetobyry, âdara xina kua nhetobyry awyly warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Egatuze urâ, mâuntuhomoem, idânârâ judeu domodo nhutuhoem lâpylâ warâ. Uguondo kua idyly keankâ, Jesus Cristo Nazaré donro eon-honrugue, mâkâ kruz wâgâ mâyâympymo, Deus kurâem nhetondyby eon-honruguelâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus izepa keankâ âmaemo. Tâlâ âwâgâmo Deus aguehobyry iweniby. Warâ aguely: “Tâlâ myani tuhu imeâgâkeba, âtâ itâdo. Idânârâ itâdaynrim modo mârâ tuhu tâensemo, mârâgue âtâ tintâdyzebamo olâ. Deus xurâem olâ mârâ tuhu tywyneim kuru!” warâ iwenibyem awyly. Âtâ itâni modo tuhu âtâ saunâto kuru izepa atomobyry ara ise mâkâ imakerinmo izepa mawylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesus kulelâ kâmakerim, eagonro lâpeba. Ânguy eagonro nigonotaymba Deus kâmakerin-em — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tyanepa kehoem Pedro, João warâ aguelymo tindatuo myani pymâ tynruneim modo toenzepa kehoem âsewânilymo. Tutuzemo mawânkâ myani âsenomedâdyby keba, âdy keba warâ awylymo; tonomegueim agueho ara kehoem agueduomo olâ Jesus eynynonrobyry asaemo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eagâmolâ myani mâkâ uguondo adakobâdânrybyry epagu. Awylygue myani Pedro, João warâ wâgâ âdakepa awylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aituo myani Pedro, João, uguondo kua nhetybymoram warâ aguelymo: — Âxiguewâdaungâ wao tarâpa — kelymo. Âxiguebygueduomo myani akaemo pymâ domodo âjigue aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","— Âdakiendylyka ise akaemo azagâ uguondo modo? Idânârâ Jerusalémdâ tâjikeim modo tutuzemo, adyesenry anhetomobyry, mâkâ uguondo kua nhetomobyry. “Adakobâdânrybyry kua nietaymbamo” kykely-ro watay, kurâdo kyeileze. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kyjigâsedon-nemo wao, “Mâkâ uguondo kua ityby wâgâ, Jesus wâgâ warâ ânguyram adâkezeba itaungâ” kykehoem. “Jesus wâgâ amyguezesedylymo-ro watay, toenzepa kehoem inagazenehonzemo xina” kykely ise eyanmo — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aituo myani akaemo azagâ ingâsenehonlymo, aguelymo: — Jesus xunârybyry aguely imowâdaungâ. Ânguyram iwâgâ adâkezeba itaungâ. Âdaunloenlâ Jesus xunârybyrygue ânguy kâzenomedâdondaundâ — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Agueduomo Pedro, João warâ aguelymo lâpylâ: — Deuslâ keankâ, “Jesus xunâry egatuwâdaunda” kerim. Âmaemo pylâ “Kâzegatuwâdaundâ” kerin-ro. Ânguyka ise xina nheinwânkyly kuru? Âmaemo? Deus? ");
INSERT INTO bkqNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jesus aidyly xina nedâ. Nhenomedâdo xina nidadâ warâ. Awylygue ise iwâgâ adâkely xina nimopa awyly — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Arâ agueduomo myani pymâ domodo eyanmo aguely: — Tarâpa itaungâ. Jesus xunâry ânguyram kâzegatuondaundâ olâ-ro warâ. Iwâgâ amyguezesedylymo-ro watay, toenzepa kehoem inagazenehonzemo enra xina — kelymo. Warâ olâ myani kurâ domodo mârâ âtâ anano modo aguelymo: — Koendonro awâkâ Deus. Ton-honru nudu akaemo azagâram, mâkâ adakobâdânrybyry kua nhetomoem — kelymo. Agueduomo myani pymâ domodo akaemo azagâ tienagazenehon-ho nutuba idylymo. Aituo myani aguelymo: — Kienagazenehonlymo-ro watay, kurâdo kagâ iewiâpadaynzemo — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Quarenta anos takaze myani mâkâ uguondo Deus eon-honrugue kua ityby. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Âzetagueoybyem myani Pedro, João warâ idâlymo Jesus einwânni modoram. Idânârâ kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, judeu domodo iwymârydo warâ aguehomobyry tâgatuzemo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nhegatuybymo tindatuo myani idânârâ kehoem Deus agâ aguelymo: — Pymâlâ âmâ, Deus, idânârâ xugunipyrylâ, kau, onro, parutabâ, paru warâ. Idânârâ tâlânro modo âmâlâ xuguni. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Âispirituryguelâ myakâwândy imary Davi xirâ aguely inwenily: “Judeu keba modo tyewiâpazemo; judeu domodo inakanhe âedyly wâgâ tyangahu oday tunâgue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Idânârâ pymâdo on-hoam isemo. Kywymâry Deus agâ âseguebyze kezemo. Deus Ingonokyly idueryem isemo warâ” kely myakâwândy Davi inwenily. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","— Davi aguehobyry ara kehoem keankâ aidyly. Herodes, Pôncio Pilatos warâ, judeu domodo agâ, judeu keba modo agâ warâ nâtâdyguywâdaundâmo, tarâ Jerusalémdâ âmery Jesus tienagazedomoem. Inakanhe aityby keba lelâlâ wâne keankâ; alâ olâ keankâ Mâingonotyby nhenagazenehonlymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tutuzelâ makynre arâ ainiem awylymo, “Warâ ise aidyly” myguehobyrylâ awylygue. Idânârâ awârâ modo aidyly on-honruguelâ, arâ ize mawylyguelâ warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","— Pabai, tutuzelâ âmâ, pymâ domodoram xina âjiewiâseolymo. Xina tienagazedyze akaemo. Imary tawylygue xina on-honru nhekadyly, tyanepa xina âwâgâ aguezesedoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","On-honru xinaram xudugâ, tâwânuneim modo kua xina nhetoem, adyesenry modo kehoem xina anhetoem warâ, xina agâlâ mawyly xutuhoem. Warâ xina imarydo aiekâ, Jesus âdykâ inakanhe ityby keba eon-honrugue xina aitoem — kelymo myani Deusram. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Deus agâ adâkely nhewanikebygueduomo myani mârâ âtâ âtâdyguyhomo âzekânily; Deus Ispiritury eyanmo âewyly, eon-hondâzemo. Aituo myani idânârâ kurâdo eon-honru âduduoly, Jesus xunâry egatuze tyanepa itomoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Koendâ kehoem myani idânârâ Jesus einwânni modo âzetaynlymo. Aguimo wâne, tokaleom aramo lelâ olâ myani. Turâem lelâ waypamo myani, tâlâ tato modo ipaom modoram nhepâdylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","— Pymâ Jesus nigue wâne. Iwerâ olâ kurâem itondybyem. Kurâem itondybyem awyly ume xina nedâ — kezesemolâ myani. Deus toenzepa eon-honrumo tuduze myani, tunâry nhegatuhomoem. Koendâ lelâ myani akaemo Jesus einwânnipyry modo agâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tâty ioday tato vende iemâmomy. Tonroguneim modo tonroru vende ietaunmâmomy warâ. Ebyrypyry myani Jesus tunâry egaturin-em induakeyby modoram nhudulymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Akaemo myani dinheru xudunri âdy pebaom modoram. Arâ myani akaemobyry âdy peba nipyra awyly. Idânârâ ipa tato aralâ mykâinane nhemakelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tâlâ myani uguondo José keho. (Akaemo Jesus xunâry egatuwâni modo olâ myani “Barnabé” kerim eyam. “Kon-hondâni” keze aguely.) Ilha Chipre anaym iazeypy, Levigue tydamudogueim warâ myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tonroru vende iemâmy. Ebyrypyry Jesus tunâry egaturin-em induakeyby modoranlâ myani nhuduly, âdy pebanro modoram nhuduhomoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tâlâ myani Jesus einwânni Ananias, iwydylâ Safira warâ. Tonroru vende iemâmomy. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Aituo myani Ananias tywydyram aguely: — Âdiempa xirâ dinheru ewy kurâem kienkanâne. Jesus tunâry egaturin-em induakeyby modoram kiunduday, olâ “Idânârâ xirâ dinheru xina eonronru ebyrypyry tarâ awyly” keze lelâ kurâ — kelymo myani. Aituo myani Ananias, Jesus tunâry egaturin-em induakeyby modoram dinheru nhadyly. Warâ myani saintybyem aguely: — Anra dinheru. Idânârâ tarâ onro ebyrypyry kâenmakeyby awyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aituo myani Pedro ton-honre kehoem eyam aguely: — Satanás amidyse ato ara kulâ amidyly. Deus Ispiritury enokuze myguely. “Idânârâ tarâ onro ebyrypyry kâenmakeyby awyly” myguely wâne. Xirâ dinheru ewy mâenkanâdybymo tâlâ olâ âmaemo — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","— Ânguy “Onroru vende iekâ” kewâpyra keankâ. Vende mânhepygueduo ânguy lâgâlâ keankâ “Idânârâ dinheru mâenmakeyby âdy pebanro modoram xudugâ” kepa warâ. Âmâ xurâlâ keankâ mârâ onro, tâwâlâ ize mato ara amânhetoem. Vende mânhepygueduo, âmâ xurâlâ keankâ dinheru warâ, tâwâlâ ize mato ara amânhetoem. Inakanhe inkâba dinheru mâempajigâdyly âmaemoem. Iwâgâ tâdâsenogudyly myguely olâ inakai. Xina kulelâ mâkeba enokuze mygueho, Deus lâpylâ warâ! — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pedro aguepygueduolâ kehoem myani Ananias onro onwa ihuguely. Iguely lelâ-ro warâ. Idânârâ Ananias aitobyry xutuwânibyry modo toenzepa kehoem myani âseanedylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aituo myani salokuzenomo modo ewy idâly, Ananias eguepybyry ituwynze. Tintuwymbygueduo myani tâdâzepyâdoam nhadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Três horas sakabygueduo myani Ananias iwydypyry saindyly Pedro eydâ atoram. Tuso igueypyem awyly nutuba myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aituo myani Pedro eyam aguely: — Oso dinheru onro ebyrypyry mâenmakeybymo yam nenetai, âdy pebanro modoram kâunduhoem. Idânârâ mâenmakeybymo ara nenetai? — kely. — En-hem, idânârâ xina nhemakeyby aralâ enra mâkâ âyam nhuduly — kely lelâ myani iwydypyry. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aituo myani Pedro aguely: — Âmâ, oso warâ myguewâdylymo kulâ. Deus Ispiritury enokuze myguehomobyry wâgâ mâsenagazebyra warâ keanra keankâ inanajimo. Idakâ ihurumo aguely. Salokuzenomo modo oso eguepybyry tâdâzepyâdoam sanipyry modo akaemo odopâni. Âmâ ise iwerâ nhakylymo! — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aguepygueduolâ kehoem myani iguely. Pedro enadoram kehoem myani ihuguely. Salokuzenomo modo saindylymo myani. Egawândylymo. Âwântybyem, pekodo igueypyem lelâlâ awyly nhedylymo. Aituo myani eguepybyry nhadylymo iso eatadoanlâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Idânârâ myani Jesus einwânni modo nhutulymo, Ananias, iwydylâ warâ Deus enokuze kehomobyry wâgâ iguehomobyry. Jerusalémdâ tâtyuneim modo egary tydasemo myani. Aituo myani toenzepa kehoem âseanedylymo. Idânârâ kehoem Deus eon-honru nhytadylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesus tunâry egaturin-em induakeyby modo Jerusalémdâ Deus eon-honru tânehonzemo myani. Âdykâ ânguy anhetânry kehoem myani anhekylymo Deus eon-honrugue. Alâ myani idânârâ Jesus einwânni modo Deus etydâ âtâdyguylymo Galpão de Salomão oday. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Agui isezedyly myani pekodo modo, uguondo modo warâ Jesus einwânni modo. Iwelo einwântaynrim modo akaemo saguhoem einwânnipyry modo agâ tâtâdyguyzemo myani. Idânârâ Jerusalém donro modo koendâ myani iwâgâmo aguely. Jesus einwântânry modo olâ myani tyane eagâmo âtâdyguyze. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Deus eon-honrugue tâwânuneim modo kua tyese myani Jesus tunâry egaturin-em induakeyby modo. Awylygue mykâinane Pedro ânwa oze sakadyly tiuntuduomo, sakadodâ typemugu tâwâneim nheguetunâdylymo. Pedro sakaday, egadopyry iwâgâmo sakaduo, kua tyese mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalém iwaguepa tâtyuneim modo, toenzepa myani tâwânuneim modo, kadopâgue taseim modo warâ nhadylymo Pedro eydâ atoram. Mâkâ modo kua tyetaynze lelâ myani Deus eon-honrugue. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Toenzepa myani akaemo kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru, eataen-homolâ saduceu domodo warâ iewiâkymo tâsewânilymogue, ânguy adâkely nidapyra awylygue, kurâdo, akaemo Jesus tunâry egaturin-em induakeyby modo aguely lelâ nheinwânkylymo awylygue warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aituo myani pymâdo aguely Deus ety iguardary modoram: — Sawâtaungâ akaemo Jesus xunâry egatuwâni modo. Kadeia odaxi sataungâ — kelymo. Aituo myani nhawâdylymo, nhetadâdylymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mârâ kopaelâ olâ myani anju Deus eydâ atodâba xytâguyly. Saintybyem myani kadeia iwyantary modo nhenahunguewâdyly, tientaguehomoem. Egasebygueduomo koendâ kehoem pyanta modo tânahuonze olâ myani. Eagâmo kuohoram idâwânmy. Aituo myani eyanmo aguely: ");
INSERT INTO bkqNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","— Emedyly wâgâ idâwâtaungâne Deus etyam. Jesus unârybyry egatuwâdaungâ akaemo tonlo modoram unâ tâdâsemagueho — kely myani Pedro domodoram. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aituo myani Jesus tunâry egaturin-em induakeyby modo mâkâ anju aguehobyry ara emedyly wâgâ Deus etyram idâlymo. Deus ety idaseraji egawândylymo warâ. Kâmakerim Jesus wâgâ kurâdo enomedâdyly nhaguondylymo myani. Kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru, eataen-ho modo lâpylâ warâ idânârâ judeu iwymâry modo ton-honreim tygâsezemo myani; idânârâ âtâdyguylymo. Pedro domodo tâtaguelâ-ro waunlo ara myani enanajimo. Awylygue myani Deus ety iguardary modoram aguelymo: — Akaemo Deus itaumbyry egatuwâni modo etaunda — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aituo myani guarda domodo kadeiaram idâlymo. Myarâ saintybyem olâ myani, Jesus tunâry egaturin-em induakeyby modo nepyramo. Tiempyramo tituo myani odopâdylymo pymâdo âtâdyguyhobyryam. Aituo myani aguelymo: ");
INSERT INTO bkqNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","— Ânguy lâpeba târâ kadeia oday! Idânârâ pyanta modo koendâ kehoem enahunwâdybyenlâ, pyanta eni modopelâ warâ olâ enra. Xina pyanta nenahungueagui. Kadeia oday xina netai warâ. Akaemo etadâdyby modo peba olâ enra târâ. Ânguy xina nepyra enra — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kurâdo eynynâ Deus agâ aguewâni modo iwymârydo, guarda iwymâry warâ kadeiaram idâwâtyby modo aguely idamâmomy. Tindatuo, âseguâdâmâmomy âdara itomobyry awyly nutuba tawylymogue. Aituo myani âjigue aguelymo: — Âdaraka enra akaemo Jesus xunâry egatuwâni modo aidyly? Âdykâmo wânkâ? — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aguelymo ume myani egatuim saindyly. Aguely: — Idataungâ! Akaemo uguondo modo kopaelâgâ mâentadânehoymbymo anrimo târâ, Deus ety idaseray. Jesus wâgâ kurâdo nhenomedâdondylymo — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mâkâ aguely tindatuo myani akaemo Deus ety iguardary iwymâry, izodadury modo warâ Jesus tunâry egaturin-em induakeyby modo sawâtonze idâlymo. Sawâtonibyryem, nenagazebyramo olâ myani. — Asaemo kienagazedyly-ro watay, kurâ domodo tuhu kuonwa samezemo. Toenzepa kurâdo asaemo nhehoguedyly — kelymo myani tyangahu oday. Awylygue myani âdaniepyra kehoem nhadylymo pymâdo âtâdyguyhobyryam. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pymâdo enadoram myani nhadylymo. Aituo myani kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru aguely eyanmo: ");
INSERT INTO bkqNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","— “Jesus wâgâ kurâdo kâzenomedâdaundâ” xina nygue wâne-ro. Etaungâ! Idânârâ asaemo taunlo Jerusalém donro modo iwâgâ unâ indadylymo. Amyguelymogue kurâ domodo xina ewentâgueze Jesus iguehobyry wâgâ — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aituo myani Pedro domodo aguely: — Deus aguehobyry ara lelâ xina aidyly, kurâdo aguehobyry ara inkâba. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesus iguehoem kruz wâgâ makâjien-homo. Deus kydamudo nhyrentyby olâ kurâem nietondâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deus Ingonotybylâ mâkâ Jesus pymâem itoem. Deus ahoru eynynâ mâkâ iwerâ, pymâ tynrenseim ejidydâ. Kâmakerim mâkâ. Kurâ Israel iweompyry modo inakanhe kydawyly kinmohoem myani Deus, awârâ modo anhedyly. Kurâ judeu modo Jesus kieinwândyse mâkâ, inakanhe kydawyly tyngakehoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jesus aidyly enipyry modolâ, aguely idanipyry modolâ warâ xina, iwâgâ aguenri. Deus olâ Tyispiritury tugonose lâpylâ tâinwântaynrim modoram, Jesus wâgâ ton-honre aguehomoem. Awylygue xina adâkeho nhutuly — kely myani Pedro. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Arâ kehoem Pedro aguely tindatuo myani akaemo pymâ tynrenseim modo toenzepa kehoem iewiâpadylymo. Akaemo Jesus xunâry egatuwâni modo xyâze kelymo warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aituo myani tokalâ akaemo ewy saudyly. Fariseu domodo ewy myani mâkâ, Gamaliel keho. Moisés inweniby wâgâ enomedâni myani mâkâ, idânârâ nhyrenkylymo warâ. Aituo myani guarda domodoram aguely: — Asaemo uguondo modo wao kuohoram sataungâ — kely. Egasebygueduomo myani tagonrodoram aguely: ");
INSERT INTO bkqNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","— Nhaum, idataungâ, kydamudo Israel iweompyry. Koendâne akaemo uguondo modo âdara kiendyly awyly kydutunre. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Uguondo Teudas aitobyry enanâguewâdaungâ. “Uguondo tynrenseim urâ. Auguely idataungâ” tâkeze myani. Toenzepa myani uguondo modo eagâ idâwâtyby modo awyly, quatrocentos awârâem. Tâdyoze olâ myani. Igueduo, idânârâ eagonropyry modo tâwenkezemo, tâtyram todopâdaynzemo warâ myani. Mâkâ Teudas aiese kewâtobyry, ton-honremba tâise myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","— Judas aitobyry enanâguewâdaungâ lâpylâ. Galiléia donro myakâwâm mâkâ. Kurâdo sapâgueho ume myakâwâm âepanâguely. Toenzepa kehoem kurâdo Judas agâ tâtâzemo myakâwâm. Tâdyoze lâpylâ olâ myakâwâm mâkâ. Igueduo, idânârâ eagonropyry modo tâwenkezemo lâpylâ myakâwâm. Adiendyse atobyry ton-honremba tâise lâpylâ myakâwâm. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Awylygue olâ âyanmo auguely. Jesus wâgâ aguewâni modo âdalâ kulâ aguiempyra kine, uguely. Kyzetaguehonremo lelâ. Alâ nâtâzezedaymbamo ise, ton-honrumogue kulâ, kurâdo nhenomedâdylymo-ro watay. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Deus eon-honrubemo-ro watay olâ ise âdakiempyramo kurâ, Deus agâ kydâseguebyly awylygue — kely. Gamaliel aguely tindatuo myani idânârâ âseinwândylymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Aituo myani guarda domodoram aguelymo: — Xarâ enetondaungâ akaemo Jesus xunâry egatuwâni modo — kelymo. Aituo myani pymâdo enadoram adahondylymo. Nhapiogüen-honlymo lelâ myani. Tiampiogüen-hombygueduo myani eyanmo aguelymo: — Ânguyran-ne Jesus wâgâ adâkeonzeba itaungâ — kelymo. Agueypyem myani inmoen-honlymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aituo myani Jesus tunâry egaturin-em induakeyby modo târâpa âxiguelymo. Toenzepa kehoem iomazelymo, Jesus Cristo wâgâ adâkeduo tâzenagazeolymo awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jesus wâgâ aguepa nipyramo olâ myani. Kopaelâgâembaba myani iwâgâ aguelymo. Deus ety oday kurâdo nhenomedâdylymo warâ. Âtâ odakâ adakobâdylymo lâpylâ, Jesus unâry egatuze, Jesus wâgâ agueze. — Kâmakerim mâkâ, Deus Ingonotyby — kelymo mykâinane. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mârâpygueduo toenzepa myani kurâdo Jesus einwânni modo. Judeu gregu itanwe aguewâni modo, judeu hebraiku itanwe aguewâni modo aidyly nehoguebyramo myani. Awylygue pyni âdy pebaom modoram xuduly wâgâ aguelymo: — Aunlolâ inanry typyniguenry modo xuatay, pypâ hebraiku itanwe agueim modo lelâ imâem nhuankylymo awyly, pypâ gregu itanwe agueim takaze kehoem — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aituo myani doze lelâ Jesus tunâry egaturin-em induakeyby modo idânârâ Jesus einwânni modo indâtyguylymo. Âtâdyguyduomo myani eyanmo aguelymo: — Deus itaumbyry egatuly xina ewanu. Koendâ inkâba, Jesus wâgâ adâkely xina inmoly, pypâ modoram pyni tiempâdoem kulâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nhaum, sete lelâ uguondo âinduakewâdaungâ, âdy pebaom modoram pyni epâniem. Koendonro modo iduakewâdaungâ, Deus Ispiritury agueho ara aini, tonomegueim warâ. Mâinduakeybymo ise kopaelâgâembaba pyni epâni. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jesus xunârybyry egatuly, eagâ adâkely warâ xina nimopa mawânrâ ise. Awârâ kulelâ ise xina ewanu, âdy pebanro modoram pyni epâdyly keba — kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Idânârâ tonlo modo, Jesus tunâry egaturin-em induakeyby modo agueho ara izemo lelâ myani. Saguhoem kuru induakelymo myani Estêvão. Jesus einwânni myani mâkâ, Deus Ispiritury aguehobyry ara lelâ aini warâ. Ilâpyryem myani Filipe, Prócoro, Nicanor, Timom, Pármenas, Nicolau warâ induakelymo. Antioquia donro myani mâkâ Nicolau, judeu keba, Moisés inweniby tâinwânse olâ myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Akaemo iduakerimbyryem myani nhadylymo Jesus tunâry egaturin-em induakeyby modoram. Aituo myani Deus agâ aguelymo: — Pabai, asaemo uguondo modo agâ ikâ; eon-honrumo xudugâ, âmâem aitomoem — kelymo. Jesus tunâry egaturin-em induakeyby modo iduakewâdyby modo nhangahu onwa tâmary nhedylymo myani, ewanumo iwelo xudurimpyryem Deus awyly xutuhoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jerusalémdâ agui idyly myani Deus itaumbyry idataynrim modo, toenzepa lâpylâ Jesus einwânni modo warâ. Agui lâpylâ myani kurâdo eynynâ Deus agâ aguewâni modo ewy Jesus einwânni modo. Jesus einwânni modo agui isezedyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Koendâ myani Deus, Estêvão agâ awyly. Eon-honru tuduze mykâinane Deus, adyesenry modo anhetoem. Anhekyly tientuo, tutuze myani kurâ domodo Deus eagâlâ awyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tâlâ olâ myani judeu domodo ewy Estêvão iewiâseni, Jesus wâgâ aguelygue. Mârâ âtâ Etadâdyby Modo Etagueyby Âtâdyguyho kelygue tâzekeim oday âtâdyguywâni modo myani akaemo, Cirene, Alexandria, Cilícia Ásia warâ donropyry modo. Aituo myani tyewiâse kehoem Estêvão nhapâiguelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Koendâ lelâ olâ myani in-hoguly, Deus Ispiritury aguehoem xurunipyryem awylygue. Pymâdo enado tâwentâdoem âdalâ kulâ aguely nitaymba myani mâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aituo myani kurâdo ewy nhepywadylymo, âdalâ kulâ Estêvão wâgâ aguehomoem: — “Mâkâ uguondo, Moisés nhunâguedyly, Deus nhunâguedyly warâ xina nidadâ” myguelymo ise — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Arâ myani akaemo aguely Estêvão wâgâ. Arâ aguelymo tindatuo myani kurâdo Estêvão agâ iewiâpadaynly, pymâ domodo, Moisés inweniby wâgâ enomedâni modo warâ. Inepa kehoem myani idâlymo myarâ Estêvão eydâ atoam. Estêvão sawânipyryem, nhadylymo lelâ myani pymâdo ton-honreim âtâdyguyhobyryam. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Akaemo kewâdyly kulâ waunlo modo idâwânmomy lâpylâ myarâ. Aituo myani aguelymo: — Xinalâ keankâ awâkâ uguondo Deus nhunâguedyly idani. Deus ety, Moisés inweniby warâ xunâguedyly nimowâbyra awâkâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Jesus Nazaré donro Deus ety sakalagueze; idânârâ Moisés kurutoem inweniby xugukeze warâ Jesus” nygue — kelymo myani. ");
INSERT INTO bkqNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Idânârâ târâ pymâdo âtâdyguyho odano modo ara myani aguelymo indadylymo. Agueduomo myani, toenzepa kehoem Estêvão nhesedylymo. Anju emydy ara kehoem myani emydy nhedylymo, Deus eagâlâ awylygue. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Aituo myani kurâdo eynynâ Deus agâ aguewâni modo iwymâry kuru Estêvão nhapâiguely: — Âkealâka âwâgâ aguelymo? — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aituo myani Estêvão in-hoguly: — Ydataungâ, pymâ domodo, kurâ domodo warâ. Kydamu Abraão agâlâ mykâinane Deus ton-honreim. Kydamu Abraão Mesopotâmia eynynâ atay, Harãram idâly iraynâ, Deus idâwânmy eyam agueze: ");
INSERT INTO bkqNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Ity anaymba âxiguegâ. Âpemugudo nhângâ. Mârâ âtâ anary âyam kâenehonly anaxi idâ” kewândymy Deus. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","— Aituo myakâwândy kydamu âxiguely “Caldéia” kehodâba. Harã anaxi myakâwândy âxidâze idâly typemugudo agâ. Harã anaynlâ myakâwândy nhunwym iguely. Ilâpyryem myakâwândy Deus Abraão ingonodyly xirâ eydâ kydato anaxi. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Canaãdâ lelâlâ wâne myakâwândy kydamu ejiku, eonronruempa olâ myakâwândy. Deus olâmy eyam, “Ity anarylâ ise xirâ” kewândymy. “Âigueduo, âweompyry ety anaryenlâ ise” kewândymy warâ. Deus arâ agueday, kydamu Abraão tymeguneba myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Tarâpa âxigueze âweompyry modo. Âkelo anaxi idâzemo. Âkelo kurâdo duaxi âxidâze, idâzemo warâ. Iweâpa ise tâty anaymba awylymo, quatrocentos anos awârâem. Mârâ âtâ anary idâhomobyry iwymâry modo âweom enagazezemo. Âweom mârâ âtâ anaym âsewanihobyry tâpywaduneba ise. Kaikâem kulâ ise enagazedylymo” kewândymy Deus — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","— “Âweom enagazedaynrim modo enagazeze lâpylâ olâ urâ. Ilâpygueduo ise odopâdylymo mârâ âtâ anaymba, tarâ yrentomoem” kewândymy Deus kydamu Abraãoram. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Uguondo imeimbyry iazely-ro watay, ilery ety iopiry satâgâ, israelitalâ awyly xutuhoem” kewândy lâpylâmy. “Ynynonro modo aito ara aikâ” kewândymy kydamuam. Aituo myakâwândy Isaque iazely, Abraão imery. Sete emedyly itybyem atay myakâwândy nhunwym ilery ety iopiry nhatâly, Deus, “Aiekâne” kehobyry ara. Isaque uguondoem itybyem, Jacógue tymezeduo ilery ety iopiry satâwâm lâpylâmy. Uguondoem itybyem, doze lelâ myakâwândy Jacó imeom uguondo modo. Sete emedyly itybyem myakâwândy tymeombyry iazely agâ ilery ety iopiry nhatâwâdyly, israelitalâ awylymo xutuhoem. Akaemo doze uguondo modolâ idânârâ israelita modoem iepani — kely myani Estêvão. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Aituo myani Estêvão agueondyly: — Tâlâ myakâwândy Jacó imery, José keho. Mâkâ myakâwândy inwyneguyly kuru, eagonro tymeombyry takaze. Awylygue myakâwândy ipemugudo iwâgâ âsewânilymo. Aituo myakâwândy José vende nhedylymo Egitoram idâwâni modoram. José agâlâ olâ myakâwândy Deus. Tâenselâ târâ Egitodâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","José âzenagazeoduo, Deuslâ myakâwândy eon-hondâni. Toenzepa kehoem myakâwândy enomery nhuduly. Salokuzenomo koendonroem tyenehonze myakâwândy. Awylygue myakâwândy Egito donro modo iwymâry “Faraó” keho, toenzepa José ize awyly, pymâem nhenehonly warâ. Tâty, tysejiguy warâ eniem nhedyly myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","— Mârâ ume myakâwândy âpa ezay etâdyby iladaynly, iguewâdyly warâ Egitodâ. Tâlâ myakâwândy toenzepa âsewinzeni modo. Pyni tadainze lâpylâ myakâwândy tarâ Canaãdâ. Kydamudo typynigueba idyly myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egitodâ trigu ekanâdybybe kely tindatuo myakâwândy kydamu Jacó tymeombyry ingonodyly sanâse. José iwaigorudo saguhoem myarâ idâlymolâ myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","— José esedaunmâmomy, ânguyem awyly nutubamo olâ myakâwândy. Idânârâ idâontomobyry wâgâ myakâwândy, “José urâ, unwânmo imery” kely eyanmo. “Ypemugudo asaemo” kewândymy Faraóram. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Canaãram odopâdylymo iraynâ myakâwândy eyanmo José aguely: “Pabai agâ, âwydymo agâ, âmeonmo agâ warâ xarâ âetaungâ” kely. Aituo myakâwândy idânârâ kydamudo Egitoram idâlymo. Setenta e cinco lelâ myakâwândy kurâdo myarâ idânri. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","— Târâlâ myakâwândy José nhunwym iguely. Imeom, iweom warâ tâigueze lâpylâ myakâwândy târâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iweâpa ipygueduo myakâwândy kydamudo ibyrypyry âzenehonly Siquémram, xarâ Canaã anaxi. Iweâpalâ olâmy Abraão onro sanâmâ Hamor imeombyry emaym, typemugudo eguepybyry tuhu esagueyby odaji etadâdoem. Aituo myakâwândy târâ kydamudo ibyrypyry etadâdyly — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Aituo myani Estêvão agueondyly, tydamudo âdara itobyry awyly nhenanâguehomoem: — Iweâpalâ Deus, Abraãoram aguehobyry adahowando odaxi itybyem myakâwândy, xirâ onro anaxi odopâdomo odaji itybyem. Egitodâ tataymo, toenzepa tyepaze olâ myakâwândy kydamu Jacó iweompyry modo. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mârâ ume eagonro myakâwândy pymâem ini Egitodâ. Mâkâ pymâ iwelo toenzepa myakâwândy kydamudo nhenagazedyly, târâ xyrentyby José ipemugu awylymo umelâ. Iweâpa mawânkâ myakâwândy kydamu José iguely, mâkâ pymâ iwelo ipa ataylâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","— Kydamudo enokumâmy, enagazemâmy warâ mâkâ pymâ iwelo. “Âmerymo iazely uguondo-ro watay, samewâdaungâ paikaji iguehoem” kewândymy eyanmo. Israelita domodo agui idyseba myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Mârâ ume myakâwândy kydamu Moisés iazely. Iamudo iwâkuru kehoem myakâwândy mâkâ. Azagâ tokalâ warâ nunâ myakâwândy nhunwym, ise warâ soenseze awyly âtâ oday. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","— Ago idyly olâ myakâwândy, toensein-emba idyly. Aituo myakâwândy cestu odaji nhedylymo, paikaji ingonodylymo warâ. Niguepa olâ myakâwândy. Pymâ exiry myakâwândy cestu oday awyly ume eni. Aituo tymeryem nhadyly. Tymery ara lelâ nhenamanâdyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pymâ iwery ara kehoem myakâwândy. Awylygue myakâwândy idânârâ Egito donro modo ezewenrygue, enomerygue warâ nhenomedâdyly. Uguondoem itybyem atay, toenzepa myakâwândy enomegu. Tonlo modoram tâdyren-honze myakâwândy — kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aituo myani Estêvão agueondyly, Moisés wâgâ, tydamudo wâgâ warâ: — Uguondoem myakâwândy Moisés, quarenta anos, typemugudo israelita domodo tiendyse myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aituo myakâwândy eydâ atomoram idâly. Târâ tatay, âdaituoba kulâ israelita Egito donroam adapioguoly tâense myakâwândy. Awylygue myakâwândy typemugu emakeze idâly, Egito donro xyâwânmy warâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Ypemugudo keanra tutuze emakerimoem Deus induakeyby wawyly” kely myakâwândy Moisés. Akaemo olâ myakâwândy Moisés neinwâmpyramo. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kopaelâgâem myakâwândy azagâ israelita domodo âseguebyhoram idâly. Âseguebylymo epagunâze kely myakâwândy. Awylygue eyanmo aguely: “Tâseguebyzeba itaungâ. Âjipemugulâ âmaemo” kely. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","— Mâkâ tagonro enagazeni myakâwândy Moisés agâ iewiâpani, âjitoguylymo epagunâze keduo. Ihohu wâgâ igononibyryem myakâwândy aguely: “Xinaram adâkezeba ikâ. Xina iwymâry mâkeba âmâ! Xina mâuntuwâbyra âmâ! ");
INSERT INTO bkqNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tutuze urâ, kopaelâgâ egípcio mâyân-hobyry. Iwerâ urâ mâyândyse mato?” kely myakâwândy Moisésram. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Agueduo Moisés âseanedyly. Tâzenagazeoly nhytadyly, egípcio tyân-hombyry wâgâ. Aituo Egitodâba âwiendyly. Midiã anaxi idâly. Pekodo Midiã anano agâlâ myakâwândy ohogüinly. Azagâ lelâ imeom iazely târâ. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Quarenta anos sakabygueduo, târâ âji aguipa kurâdo atodâlâ myakâwândy Moisés, iwy Sinai iwaguepa. Moisés tuhogueim iatygu emâmy. Mârâ iatygu duay myakâwândy anju âepanâguely. Âdaunloenlâ iwatarylâ, sary warâ niadupa olâ myakâwândy. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mârâ arâ tientuo myakâwândy Moisés âseguâdâdyly. Iwaguepa saindyly, koendâ tientoem. Iwaguepa saintybyem myakâwândy Deus aguely indadyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Deus urâ, âdamudo Abraão, Isaque, Jacó warâ iDeusry” kely. Aguely tindatuo myakâwândy Moisés adapânily tyanugue. Tiendyseba idyly. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","— Aituo myakâwândy Kywymâry Deus aguely: “Tarâlâ urâ. Âhuru etary etygâ. Ienado ihuru tâtagueba ikâ, yrentâ mawyly mâenehon-hoem. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tutuze urâ, ynynonro modo Egitodâ âzenagazeoly. Alâ inanry saenlumo kâindadyly. Emakezemo kâewyly. Inepa ise Egitoram ogonodyly emakezemo” kewândymy Deus eyam — kely myani Estêvão. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Aituo myani Estêvão agueondyly: — Kydamudo iwymâryem, Egitodâba emakerimoem warâ myakâwândy Deus Moisés induakely. Deus anju igonomâmy emawyadâze, mâkâ anju tuhogueim tyatygueim duay âepanâgueyby. Kydamudo olâ myakâwândy Moisés izepa, aguely tindadysebamo warâ. “Ânguy xina emakerin-em âduakewâbyra keankâ. Ânguy aguewâpyra keankâ xina iwymâryem mitoem” kelymo lelâ myakâwândy Moisésram. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moiséslâ myakâwândy kydamudo sani Egitodâba. Adyesenry modo aiemâmy Deus eon-honrugue, Deus tagâlâ awyly tienehon-hoem. Egitodâ tataylâ myakâwândy nhenehonly Deus eon-honru tagâ awyly. Parutabâ Tapabileim kelygue tâzekeim takadomoem iotagâ wayam, wayam tienehonday, Deus eon-honru enehonwâm lâpylâmy. Kydamudo quarenta anos âji âdy peba ato einkâ adakobâday myakâwândy Deus ton-honru nhenehonly Moisésram. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moiséslâ myakâwândy kydamudoram agueim: “Kyweompyryram igonose Deus tytaumbyry egatuim. Kypemugulâ ise mâkâ. Uduake wâne Egitodâpa imakerinmoem myara lâpylâ ise mâkâ kâmakerim ingonodyly” kerim. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kydamudo iwymâry myakâwândy Moisés, mârâ âji âdy peba ato einkâ adakobâdaymo. Deus ingonotybylâ myakâwândy mâkâ anju târâ iwy Sinaidâ, Moisés agâ agueim. Xirâ unâ iozeno agueho tâinwânselâ kurâ até iwerâ — kely myani Estêvão. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aituo myani Estêvão akaemo âsenanâguehoem Moisés wâgâ agueondyly. — Kydamudo olâ myakâwândy Moisés aguehobyry ara adâidysebamo, tywymârymoem izepamo warâ. Awylygue myakâwândy Egitoram odopâze kelymo. ");
INSERT INTO bkqNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","— Aituo myakâwândy Arãoram ague