﻿USE sofia;
DROP TABLE IF EXISTS sofia.bki_vpl;
CREATE TABLE bki_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bki_vpl WRITE;
INSERT INTO bki_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kristo naio miyotuba ea bajulukuti na tormoruo juo na tortoru na kulo Ju nalo korobilo, nina be Epraamo naio beamu, bija Teviti naio iorou kanio. Yesu korobinio nalo nonovio, sialo ajibe nei: ");
INSERT INTO bki_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epraamo naio kenerinio napano Aisak. Aisak naio kenerinio napano Yakovo. Yakovo naio kenerinio napano Yuta, naliko kuruano dolu nalo. ");
INSERT INTO bki_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuta naio kenerinio juo Beresi naljuo kuruano Jera, naljuo abe savoro, napano kenielo Tem̃ar. Beresi naio kenerinio napano Esrono. Esrono naio kenerinio napano Remo. ");
INSERT INTO bki_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Remo naio kenerinio napano Aminatapo. Aminatapo naio kenerinio napano Nesono. Nesono naio kenerinio napano Solomon. ");
INSERT INTO bki_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Solomon naio kenerinio napano Boasa, ana Boasa nene napano kenieno napano Reavo. Boasa naio kenerinio napano Ovete, ana Ovete nene na kenieno Ruta. Ovete nene kenerinio na Jese. ");
INSERT INTO bki_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese naio kenerinio napano Teviti, ana Teviti nene napano be parinio tubo na vio Israel. Teviti naio kenerinio napano Solomon, ana Solomon nene na kenieno tira na Uraia koano jukamu. ");
INSERT INTO bki_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon naio kenerinio napano Reopoam. Reopoam naio kenerinio napano Apia. Apia naio kenerinio napano Asa. ");
INSERT INTO bki_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa naio kenerinio napano Jeosevata. Jeosevata naio kenerinio napano Joramo. Joramo naio kenerinio napano Usaia. ");
INSERT INTO bki_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaia naio kenerinio napano Jotamo. Jotamo naio kenerinio napano Easa. Easa naio kenerinio napano Esekaia. ");
INSERT INTO bki_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaia naio kenerinio napano M̃anasa. M̃anasa naio kenerinio napano Amon. Amon naio kenerinio napano Josaia. ");
INSERT INTO bki_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia naio kenerinio napano Jekonaia naliko kuruano nalo. Naruei ea kialo bogo nei, kulo buruvenuo dolu napano Bapilon nalo abano aburu bulag kulo Israel nalo ka ava aim̃au kurano ga tibe na yako Bapilon. ");
INSERT INTO bki_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka bogo napano amim̃au kurano ga yako Bapilon kia ga vo, Jekonaia naio kenerinio napano Sieltiel. Sieltiel naio kenerinio napano Serupapele. ");
INSERT INTO bki_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serupapele naio kenerinio napano Aviyuti. Aviyuti naio kenerinio napano Eliakim. Eliakim naio kenerinio napano Aso. ");
INSERT INTO bki_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso naio kenerinio napano Setoko. Setoko naio kenerinio napano Akimi. Akimi naio kenerinio napano Eliuti. ");
INSERT INTO bki_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuti naio kenerinio napano Eliesa. Eliesa naio kenerinio napano Matano. Matano naio kenerinio napano Yakovo. ");
INSERT INTO bki_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakovo naio kenerinio napano Yoseve, napano koano Mere. Mere nei, naio be Yesu kenieno, nam̃a aberii naio ka be Naverikariano. ");
INSERT INTO bki_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Naruei jikar ea Epraamo binimei bokar Teviti, be taara duelimo ba veri 14. A jikario ea Teviti binimei bokar bogo napano kulo Bapilon aburu bulag kulo Israel nalo ka ava aim̃au kurano ealo, be bunu taara duelimo ba veri 14. A mia jikario ea bogo na nalo ajua vio Bapilon binimei bokar bogo napano Kristo kiano yotubaiano, be bereio taara duelimo ba veri 14. ");
INSERT INTO bki_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ninei be tukunu napano abar Yesu Kristo eaio, m̃arabo nene ninei: kenieno tira napano Mere, na beamu aberkakario ka mia naio soro ka toro tai, siano Yoseve. Ana bogo na maka asoro vo, mia Mere mijoglubar ka be m̃abono, napano m̃abono nei binimei ea Niununo Lu. ");
INSERT INTO bki_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ana Yoseve napano aberkar ka mia naio rivuru Mere nei ve koano, naio be toro novo tai, a naio maka tom̃a river Mere naio mila vite na bova tenia. Mia naio mial ka mia nalo ve juo monoka ala korov kialo verikariano nei, mia naio jidomii ka mia rim̃aukanio ea bajago novo tai napano melumu ga, bior naio maka sidom rila Mere rimou m̃ele rivior vite nei. ");
INSERT INTO bki_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mia bogo napano naio jidomii ka mia rila tibena, Atua kiano nailiano tai miyotuba kanio ea monovovuano tai bogiano, naruei nailiano nei berii kanio, berinavo “Yoseve, jau Teviti kiano bajulukuti, jau kojog re rivova ka mia kovuru tira na Mere ka ve koamo, bior tete na joa mabono, binimei ea Niununo Lu. ");
INSERT INTO bki_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mia Mere naio rivar tete sum̃ano tai, mia monoka jau kesisia siano ka Yesu Naioruriano, bior mia naio rilakon nonovio kiano tomu nalo kialo kariano nalo.” ");
INSERT INTO bki_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Naruei vite nalo nei miyotuba jibe na ka rila iliano tai rimei rive riano tavukia na Atua naio berial nua ea niono Naverialiano Aisea, ");
INSERT INTO bki_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","napano naio berenio, berinavo “Mia merevono tai na maka rijikia sum̃ano vo, mia naio ve m̃abono, mia naio rivarlar kenerinio sum̃ano tai, mia nalo asisia siano aver ‘Emanuela.’ ” Sio nei “Emanuela,” berenio “Atua to kiteaku.” ");
INSERT INTO bki_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Naruei Yoseve naio jevijo bereio, ana naio mila jibe ka napano Atua kiano nailiano berkanio, ana joro ka Mere, buru be koano. ");
INSERT INTO bki_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mia maka nalo atubiju vo bano-o bokar bogo napano Mere naio barlar kenerinio nene karina. Ana bogo napano Mere bar kiritete nene, ana mo Yoseve jisia tete nene ka Yesu. ");
INSERT INTO bki_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu kiano yotubaiano ea komeli tai na siano Betleem, ea tanobuku na vio Yutea, ka bogo na Erot naio be parinio tubo ka kulo Israel nalo. Mia maka vesiou ga ka bogo nene, ana tomu tai nam̃a amijikia batitig bajago na m̃arivitano nalo, abinimei ea vio Yerusalemo. Nalo nei ajumolu ea kialo buruvenuo ea vio nam̃a m̃erenio mijivi eaio abinimei. ");
INSERT INTO bki_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Naruei nalo abika den tomu nalo, aberenio “?Tete na miyotuba voniganei, na aber mia naio ve kulo Israel kialo parinio tubo, naio jo be? Kumemi numial kiano m̃arivitano nene ruei, miyotuba ea vio napano m̃erenio mijivi eaio, ana kumemi nubinimei ka nuvilivu ka siano.” ");
INSERT INTO bki_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bogo na iliano nei binimei bokar Parinio tubo Erot naliko kulo Yerusalemo nalo tealo, amijogio, mia nalo maka asaaro kanio. ");
INSERT INTO bki_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Naruei Parinio tubo Erot naio bio tomu na tortoru na kulo lu nalo naliko naverloglogiano na tuboiano nalo abinimei amial naio, ana naio bika denlo, berinavo “?Mia Naverikariano nam̃a aju aberiio vurua na, mia naio rimei riyotuba to be?” ");
INSERT INTO bki_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nalo nei aberdop̃e, aberinavo “Mia Naverikariano naio riyotuba ea tanobuku na vio Yutea, ea komeli na vio Betleem. ");
INSERT INTO bki_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nina bior beamu naverialiano tai naio bivitauiakar iliano nalo nei, berenio ‘Atua naio ber jibe nei, berinavo “Kamiu na vio Betleem, maka kuvijikia kuver kulo dolu na tortoru nalo na ga ea vio Yutea, nalo ga abe tomoruo loa kamiu, ana kamiu kumitutano, makanio, bior mia navurim̃araboiano na toru tai riyotuba ea kamiu rimemedu, naio rivitikar vatitig kiaku kulo Israel nalo.” ’ ” ");
INSERT INTO bki_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Karina Parinio Tubo Erot naio bio bena ga tomu napano amijikia bajago na m̃arivitano nalo, abokar vioriano tai naliko naio ga, ka naio jidom rijogio vatitig denlo ka m̃arivitano nene naio miyotuba memedu ka bogo vaio. ");
INSERT INTO bki_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bisi na naio ber kalo, berinavo “Monoka kamiu kuva kuvisirag tete nene, ver kuvilealio, ana mo mia kumei kuverialio va kiniou bereio, ka mia kiniou bunu nava nolotu ka siano,” bisi na naio miilalo aba Betleem. Mia kanano iliano nei be sibiano ga, naio jidom rileal tete domudomu nei ka mia naio riva ruebinio ga. ");
INSERT INTO bki_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ana tomu nalo nei amiagago ka Parinio Tubo Erot kiano iliano nalo bisi, ana nalo aban ea kialo m̃arabo, ana amial bereio m̃arivitano nei nua amialio naio jo merera ea vio na m̃erenio mijivi eaio. Mia bogo na nalo amial bereio m̃arivitano nene, nalo amijog bo toru laka, ana m̃arivitano nei naio buru m̃arabo kalo abano-o aboru ea vio na kiritete nei naio mon eaio. ");
INSERT INTO bki_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Naruei nalo aba joomo ea yimo, amial kiritete bija kenieno Mere. Naruei nalo aminie kamu kean naio, amilivu ka siano. Karina nalo abetavo ea kialo basaro nalo, ana abar kanano jidomiano nalo banio, niogo tai, bija bonotanunu na siano vrakenses, bija pomat, na puruveru nene bavin laka, siano mer. ");
INSERT INTO bki_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Naruei bogiano, ana Atua mil banlo ea monovovuano tai, berburelo ka mia avan re bunu aial Erot. Naruei nalo ajumolu, ajel ea m̃arabo dolu aban bereio ea kialo vio. ");
INSERT INTO bki_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bogo na tomu nalo nei ajuvan vio nei ruei abano, ana Atua kiano nailiano tai miyotuba ka Yoseve ea monovovuano tai, naio berkanio, berinavo “Yoseve, jau kotumolu, kodu kiritete domudomu naljuo keniene, kuva kuvitu bilig ea vio Ijivi, bior Tubo Erot naio jom̃a jidomii kakar ka mia riila kiano tomu na mira nalo asirag kiritete domudomu na ka mia auebinio. Kamiu monoka kuva kuvitua vio na rivano-o ver kiniou never kamiu kumei, ana mo kumei bereio.” ");
INSERT INTO bki_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ana Yoseve jumolu, midu kiritete domudomu naljuo keniene, ka bogiano nene ga ajumolu amiel ka avan ea vio Ijivi. ");
INSERT INTO bki_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nalo ajua vio na jiou kija, bano-o bokar bogo na Parinio Tubo Erot naio m̃aro. Tena maluvo jel jibe nei ka mia rimemedu ka Atua kiano iliano tai na naio beriio ban Naverialiano Osea nanua ruei, berinavo “Keneriku joa vio Ijivi, mia kiniou nobio naio ka rimei bereio.” ");
INSERT INTO bki_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mo bogo na Parinio Tubo Erot naio mijikia ka tomu napano amijikia batitigio m̃arivitano amiyotel ea naio, maka bunu amei eaio, naio tinienmimi toru, ana naio ber ka kiano tomu na mira nalo, ka ava asirag kiritete sum̃ano nalo napano ajua vio Betleem bija komeli nalo napano aju jouro ea tanobuku nei, nalo nonovio na kialo yuka maka rivokar yuka ve juo vo, ka mia nalo auebinvinlo am̃arm̃aro. A naio buluku bogo nei memedu jibe nei, bior iliano napano naio mijogio den tomu nalo nei nua, aberial memedu ban naio ka bogo napano m̃arivitano nene naio miyotuba garuei be moti eaio. ");
INSERT INTO bki_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ea m̃arabo nei, vaio napano Naverialiano Jeremaia ber nua bini-mei miyotuba be riano, na naio berinavo ");
INSERT INTO bki_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Jooa na tegiano tai amijogio ea vio Rama, tegiano na tinie jaleleiano. Rejel naio jom̃a jegi kumabinio nalo, naio miilkue ka aiolip̃ilip̃i naio, bior kumabinio nalo am̃arm̃aro liki.” ");
INSERT INTO bki_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mia bogo na Parinio Tubo Erot naio m̃aro, Yoseve nalo aju kia ga Ijivi vo, naruei naio monovovu, mial bereio Atua kiano nailiano tai, napano naio binimei berkanio, ");
INSERT INTO bki_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","berinavo “Yoseve, jau kotumolu, kodu tete na vija keniene, kamiu kuvan bereio ea kenemiu venuo napano Israel, bior Parinio Tubo Erot nanua m̃a jidom ruei kiritete na, naio m̃aro ruei.” ");
INSERT INTO bki_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Naruei Yoseve naio jumolu, midu tete bija keniene, ana nalo aban bereio ea kialo venuo napano Israel. ");
INSERT INTO bki_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mia bogo napano Yoseve mijogial ka Akaleasi jo jeleig karam̃ano Erot, ka naio be parinio tubo ea vio Yutea, Yoseve naio merou ka rivan bereio ea vio Yutea. Ana Atua mil bereio ban Yoseve ea monovovuano tai, berbure naio ka mia naio rivan re bunu ea vio Yutea bereio, naruei Yoseve naio ban ea vio dolu, vio nene siano Kalele. ");
INSERT INTO bki_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ana nalo aba ajua komeli tai napano ea tanobuku na, siano Nasarete. Vite na maluvo jibe na ka rila naverialiano nalo kanalo iliano nalo ave riano, napano m̃a aberii Verikariano nei nanua ruei, aberinavo “Mia averenio naio be toro re Nasarete tai.” ");
INSERT INTO bki_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesu naio miluo binimei toru, nina ea vio Nasarete kia ga vo, mia ka bogo na, Jone Baruei miyotuba binimei ea vio yauo na Yutea, naio mioliolu berinavo ");
INSERT INTO bki_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kamiu monoka kuvilig kamiu bior Atua kanano navenatuboiano jo binimei.” ");
INSERT INTO bki_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mia ninei be toro napano Naverialiano Aisea naio jom̃a berial nua ruei, berinavo “Toro tai bio jouo ea vio yauo, berinavo ‘Kamiu kuvila Atua kiano m̃arabo rimemedu, ka mia naio riyotuba ea kenemiu meuliano nalo.’” ");
INSERT INTO bki_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jone Baruei nene naio javukia Naverialiano Elaija re nua, jibe ka napano naio maka m̃ano kulum̃arauo novo nalo, mia m̃ano kulukoti amim̃aukanio ea vijinio kamele ga a naio mior m̃ano kulukoti ka niati kulubue marauo tai ga. Sano sinaniano na yeturu nene naio be surubu nalo ga bija vite sesei napano sukabak nalo amim̃aukanio. ");
INSERT INTO bki_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mia tomu na vio Yerusalemo bija komeli dolu nalo na vio Yutea, bija komeli nalo napano m̃a aju vaataro ka m̃arauei na vio Yortano, abinimei ka naio. ");
INSERT INTO bki_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ana aber bulag kialo kariano nalo banio, naruei naio baruei ealo ea m̃arauei na vio Yortano. ");
INSERT INTO bki_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Be bogo tai, Jone mial ka napano be tiniobi na terati juo na nalotuano na kulo Ju nalo kialo, nina be Varisis bija Satusis nalo, abinimei ka naio rivaruei ealo, mia naio mil jikili banlo, naio berinavo “?Kamiu kumitavukia maro nalo ga napano amerou ka sebi tai naruei nalo aburo, mia kamiu kuberiam̃a mia kumijikia kuvuro ka sebi napano mia Atua riila rimei, napano kamiu maka kuvilig vatitigio kamiu rivu vo? ");
INSERT INTO bki_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A ver kamiu kube riano ka kubilig tiniemiu bior kenemiu kariano nalo, mia kuvila titai medave ea kenemiu meuliano nalo ka mia ajikia ka kube riano. ");
INSERT INTO bki_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mia maka rivu kam̃a kuvarvar ka kamiu, tibe kanio nam̃a kumilaio, kuberinavo ‘Kito robo ruei, robe Epraamo kiano bajulukuti nalo.’ Mia kiniou neber ka kamiu, neber vite na maka ve titenia, bior Atua naio mijikia rivar puruveru nalo nei riviliglo amei ave Epraamo kiano bajulukuti nalo, ka adu jelemiu. ");
INSERT INTO bki_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Neber ka kamiu, yekesi tai jua burupati iesi ruei, ju rorea ka mia ate bulag buruiesi nalo napano maka avar m̃arati nalo na bo, mia ate bulaglo avukulo avan ea sebi sisenlo. ");
INSERT INTO bki_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kiniou nojukamu nebinimei, nojom̃a nabaruei ea kamiu ka uei ga, ka rila rimeravo ka kamiu kuvilig kamiu ruei, mia be toro dolu tai napano jo binimei iorou ka kiniou. Naio jo loa kiniou, a kiniou maka navare ka neive kar kiano kulubue, p̃elina nala kiano im̃auano dolu tai. Mia naio naruei mia rivaruei ea kamiu ka Niununo Lu vija kiano sebi ka sisen kon bulag iorosoro nalo den kenemiu meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Naio midukar titai jibe ka m̃artea joa jum̃ano, ka mia naio rilakon vatitig kanano uiti nalo. Mia naio rivar uiti napano be nioti uiti na bo, ava joomo ea kunuano, mia nalo na abe vinikiti ga, mia naio risebilo ka sebi tai napano maka rijikia rim̃aro bogo tai leleio.” ");
INSERT INTO bki_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mia Yesu naio juvan vio Kalele, binimei ea m̃arauei Yortano, ka Jone naio rivaruei eaio. ");
INSERT INTO bki_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mia Jone naio jidom riverbure be deio, ana naio ber “?Jum̃abe ana jau kobinimei ka navaruei easo? Kejiio, memedu ga ka jau kavaruei ea kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mia Yesu naio berdop̃e, berinavo “P̃eli ga koig, mia tibena re. Jau kala ninei beamu vo, bior bo laka ka mia kito ve juo monoka rotum̃a rataki vite nalo napano Atua jidom ka kito roim̃aukanio.” Naruei Jone mijamo ka Yesu binimei, ana naio baruei eaio. ");
INSERT INTO bki_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mia bogo napano Jone baruei eaio bisi, ana Yesu nene jaluvo den uei, ana vaarakurano naio mial vio mave betavo ka naio, ana naio mial Atua kiano Niununo Lu batove javukia vaama tai, binimei bujo jua Yesu. ");
INSERT INTO bki_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Naruei Atua mil batove, naio ber “Nina be keneriku napano kiniou nejidom m̃elea naio. Kiaku jidomiano joa naio, kiniou najaaro toru m̃ele ka naio.” ");
INSERT INTO bki_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iorou ka bogo napano Jone Baruei naio baruei ea Yesu bisi, ana Niununo Lu buru Yesu ban ea vio yauo tai ka sim̃aro nalo kanalo parinio tubo rila von naio. ");
INSERT INTO bki_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Naruei Yesu naio mondulu ka bogoti duelimo va veri 40 a bogiano duelimo va veri 40, ka bolkouo, mia iorou ka bogoti nalo nei ana jijer taneaio. ");
INSERT INTO bki_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ana mo Sim̃aro, toro nam̃a milavonvon tomu nalo, naio ber ka Yesu, berinavo “Verenio jau kobe Atua kenerinio riano, ana mo kover ka puruveru nalo na aju na, ka amei ave joko, ka kesen tai.” ");
INSERT INTO bki_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ana Yesu naio berdop̃eio, berinavo “Makanio, bior Niosi Lu naio berenio ruei, berinavo ‘Maka toro rijikia rimeul ea ga sinaniano, mia toro mijikia rimeul ea iliano nonovio napano Atua naio berenio.’” ");
INSERT INTO bki_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mia Sim̃aro naio milavon Yesu kiano jidomiano bereio, naio jiloglog Yerusalemo, naio buru kiano jidomiano bavin mave ea Atua Kunuano Lu. ");
INSERT INTO bki_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Naruei Sim̃aro ber ka Yesu, berinavo “Verenio jau kobe Atua kenerinio, ana mo jau koviako kavatove ea borotano. Mia jau kovu ga na, bior Iliano Lu naio berii Atua, berinavo ‘Mia naio mijikia riila kiano nailiano nalo, ka amei atu avitikariso. Mia nalo adukarso ga ka jum̃alo mave, ka mia kavan re jaamo ea puruveru.’” ");
INSERT INTO bki_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ana Yesu berdop̃e Sim̃aro, berinavo “Makanio, bior Niosi Lu ber bunu ruei, berinavo ‘Maka rivu ka kalavon kanamo Tubo Atua, jau katadua re naio ka rila kiamo vite tai.’” ");
INSERT INTO bki_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Naruei Sim̃aro naio milavon Yesu bereio, ka jidom rivuru Yesu kiano jidomiano rivavin ea burusuku na toru laka tai, ka mia naio rijikia siloglog buruvenuo nonovio na vio yetemeriba nei ka Yesu, rivija vite maraiu nene nalo. ");
INSERT INTO bki_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Naruei Sim̃aro milavon Yesu bereio va rolu nene, berinavo “Saba nalo na komial na mia kiniou najamo kalo vanso, verenio jau keinietano, jau kolotu ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mia Yesu naio mil ban Sim̃aro, berdop̃e kiano iliano, berinavo “Jau kovuro den kiniou, Sim̃aro. Niosi Lu naio berenio ruei, berinavo ‘Mia jau kolotu ka ga Tubo kiamo Atua, naio ga takurano, mia naio ga kala kanano im̃auano.’” ");
INSERT INTO bki_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Naruei Sim̃aro buro den Yesu, ana nailiano nalo abinimei, aju naliko amiyolup̃ilup̃i naio. ");
INSERT INTO bki_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Mia ka bogo nei, parinio tubo Erot kiano tomu na mira nalo tai aba abokar Jone Baruei, ana aburu naio ban ea yimo na tetavokoiano. Mia ka legiano nene ga Yesu naio mijogial lilianiano nei, naruei naio jumolu den vio na, ana ban bereio ea tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Mia naio maka riva toa vio Nasarete, mia naio mijaka batove ea m̃arkomeli na vio Kapeneam, napano naio jo vaataro ka ueiyabo na toru na vio Kalele. Vio nalo nei napano jikar Kalele batove boru koyou ea tei, beamu borotano nei naio be Sebulano kiano bajulukuti nalo bija Naptali kiano bajulukuti nalo kialo nua. ");
INSERT INTO bki_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tenei miyotuba jel jibe nei ka mia rila iliano nalo napano Naverialiano Aisea berialio nanua ruei, rimei rive riano tibe ka napano naio berenio, berinavo ");
INSERT INTO bki_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kamiu tomu nalo na Sebulano bija Naptali kialo vio nalo, napano kamiu kumitu iviso ka m̃arauei na vio Yortano bija tei na toru, kamiu na vio Kalele, vio na tomu na maka ajikia Atua, kamiu kuvijog iliano nei: ");
INSERT INTO bki_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tomu nalo napano m̃a aju nunu ga, mia nalo aial burum̃ara yulu tai. Nalo na aju nunu dam̃ariga, ka mia m̃a am̃arm̃aro ga, mia burum̃ara yulu tai naio rimereralilo.” ");
INSERT INTO bki_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mia jikar ea bogo nei, ana Yesu naio jom̃a mioliolu, naio berinavo “Kamiu monoka kuvilig kenemiu jidomiano nalo ka kenemiu kariano nalo, bior navenatuboiano na vio mave naio binimei vaataro ruei.” ");
INSERT INTO bki_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu naio jom̃a mieliel kiki jakii baramudou na ueiyabo napano toru na vio Kalele, ana naio mial tomu juo, Saimon Pitere naio kuruano Adru. Naljuo ajum̃a ajuvan sup̃ede, bior naljuo amijikia bajago nam̃a aburu niado. ");
INSERT INTO bki_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mia naio ber kalo, berinavo “Kamjuo kuvitakisor kiniou, mia kiniou nala kamiu kuve navagadeano na tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mia vaarakurano, naljuo ajuvan kialo sup̃ede nalo ajubo, ana nalo ajakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Karina Yesu naio miel ban lie kija ga bereio, ana naio mial tomjuo dolu bereio, Yemesi naio kuruano Jone, nalo abe Sepeti kenerinio nalo. Nalo ajua kialo buluku uako naliko karam̃alo, nalo ajum̃a amila batitig kialo sup̃ede. Naruei Yesu biolo ka atakisorio, ");
INSERT INTO bki_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","mia vaarakurano ga, nalo ajumolu sop̃eli, ajuvan karam̃alo jobo ea kialo uako, ana nalo ajakisor Yesu abano. ");
INSERT INTO bki_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Naruei Yesu naio jom̃a mieliel ea vio nalo napano Kalele, naio jom̃a berloglog kulo Ju nalo ea kialo yimo na lotuano nalo. Naio jom̃a berial ioluano novo nei na Atua kiano navenatuboiano, mia naio mieliel ka tomu napano nam̃a amie, naio milarur tomu nam̃a mieiano dedade nalo milalo, abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naruei ajukunu ka Yesu siano banbano barko reraio bunu burum̃ara tanobuku na vio Kalele tivelinio batove, napano ajisia ka Siria. Naruei tomu nalo na vio na bunu abarvar kialo namieiano nalo abinimei amial Yesu. Nalo nene tealo amie, tealo amijog niabele mijalele, tealo niadu jualo, tealo ajum̃a amiabulu m̃arm̃aro, mia nalo tealo napano niabele nalo am̃arm̃aro, mia Yesu naio milarurlo abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mia tiniobi toru na tomu nalo ajakisor Yesu ka bogo na. Nalo nei amolmoluo ea vio Kalele, ea vio napano ajisia ka Komeli Duelimo, mia ea vio Yerusalemo a ea vio dolu nalo na vio Yutea, a ea vio nalo napano jua m̃arauei na vio Yortano tivelinio bano. Nalo na vio nalo nei naruei nalo ajakisor Yesu ea bogo na. ");
INSERT INTO bki_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mia be bogoti tai, ana Yesu naio mial tiniobi toru abinimei aju naliko, naruei naio bavin ea suku tai. Jibe ka kialo naverloglogiano tai, naio jotano, ana na kiano tomu nalo abinimei ajutano jeliviv eaio, ");
INSERT INTO bki_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ana na naio berlogloglo. ");
INSERT INTO bki_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Mia Yesu kanano iliverloglogiano nalo na tortoru tai ajibe nei. Naio berinavo “Nalo napano abitilubar ka maka aleal Atua ea kialo meuliano nalo vo, mia ilivuiano rimei toalo, bior mia Atua naio rive Parinio Tubo ka tomu nalo na ajibe na. ");
INSERT INTO bki_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nalo napano amijog bova ka jaleleano nalo, ana ajum̃a ajegi, mia ilivuiano rimei toalo, bior mia nalo avokar lup̃ilup̃iano, ka mia nalo ajog rivu bereio. ");
INSERT INTO bki_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nalo napano tinielo melumu bo, mia ilivuiano rimei toalo, bior napano Atua berkario ruei ka mia rije tonovo na yetemeriba nei vanlo. ");
INSERT INTO bki_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nalo napano ajidom m̃elea bajago napano memedu javukia napano m̃a Atua naio jidomio, mia ilivuiano rimei toalo, ana na mia nalo aial bajago na memedu nalo nei amei avujo lou vatitig ea kialo meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nalo ga napano ajum̃a tinielmiia tomu dolu nalo, mia ilivuiano rimei toalo, ka mia Atua naio mijikia tinienriialo ve toru. ");
INSERT INTO bki_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nalo ga napano kialo iviso meravo bo, ilivuiano rimei toalo, ka mia aial Atua. ");
INSERT INTO bki_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nalo ga napano abe tomu nam̃a amila tum̃aro, mia ilivuiano rimei toalo, ka mia Atua naio riviolo ave kenerinio nalo. ");
INSERT INTO bki_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nalo ga napano amonea Atua, napano mia m̃a tomu dolu nalo amila baravo kalo bior kialo moneano nene, mia ilivuiano rimei toalo, bior mia Atua rivurlo ava jouro ea kiano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kamiu napano verenio tomu nalo amila lelan kamiu ajum̃a amijil kamiu, a ajum̃a amila sibi ea kamiu, napano ajum̃a aber niegeniege kamiu, nina bior kube kanaku tomu nalo, mia ilivuiano rimei toa kamiu bunu. ");
INSERT INTO bki_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kamiu kuvisidom bijovijon re, kuvisaaro ga, bior amila kiki kamiu ea bajago na ga amila ka naverialiano nalo re nua. Mia kamiu kuvar kenemiu burum̃ara ijaiano ea vio mave.” ");
INSERT INTO bki_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ana Yesu ber bunu, berinavo “Kamiu kube vaatei na tomu nalo na yetemeriba nei, napano kenemiu bajago novo naio bakar vio yetemeriba nei maka riva rivova laka. Ana verenio vaatei nei rijea re bunu rivu, maka bunu rijikia rila kanano im̃auano, a maka bunu titai rijikia rila rivu, mia naio bo ka ga avukuio rivano. ");
INSERT INTO bki_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamiu kumitavukia yulu na yetemeriba nei. Mia verenio m̃arkomeli tai toa suku levlevi mave, mia bogiano tomu nalo napano aju koalabo amijikia aial yulu na m̃arkomeli nene, tomu nalo napano ajuaio maka ajikia aduvan kanalo m̃arkomeli nei. ");
INSERT INTO bki_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mia bogo napano verenio rejelan yulu, kito maka rejikia reivekoio ka baja bereio, mia kito rejelan ka reive takilele mave ka vio reraio amerera. ");
INSERT INTO bki_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ana ea bajago nene ga, kamiu monoka kuvijamo ka kenemiu yulu nalo na kenemiu meuliano amerera rivokar tomu nalo, ka ajikia aial vatitig im̃auano novo nalo napano m̃a kamiu kumim̃aukanio. A bogo napano nalo aial kenemiu im̃auano novo nalo, mia avamenea Karamemiu napano joa vio mave riviorio.” ");
INSERT INTO bki_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ana Yesu berii bunu, berinavo “Mia maka rivu ka kamiu kuvitum̃a kuver kiniou nebinimei ka nala lelan Mosis kiano tuboiano nalo vija naverialiano nalo kialo iliano nalo, p̃eli ga, maka lele tibena. Kiniou nebinimei ka mia natakii masosoua nonovio, ka nevisi vatitig nioti nene nalo. ");
INSERT INTO bki_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kamiu kuvisidomiikar vatitig iliano nei, mia tuboiano nalo nei maka ajikia ava kovio bogo tai-o-a ka vio mave vija borotano ave juo avakovio. Tuboiano nei be ilisesa nene nalo telabo, mia maka lele kiri m̃ariliano na tai tertelisu nalo nei rijikia rivakovio, riva rivokar bogo na kiano im̃auano nalo amalmaluvo nonovio. ");
INSERT INTO bki_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tenene na, verenio toro tai rilakorov kiri tuboiano nalo nei tertelisu nei tai, mia naio tom̃a riverloglog toro dolu ka mia nalo atavukia naio, mia toro nene naio toa vio tai napano jotano maaro ea Atua kiano navenatuboiano. Mia verenio toro na naio bakar batitig tuboiano nalo nei, a naio jom̃a berloglog tomu dolu nalo ka mia ala tavukia naio, mia naio ve toro na toru tai ea Atua kiano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kamiu kumitum̃a kumisidomii kuberenio naverloglogiano na tuboiano nalo a Varisis nalo abe tomu na memedu nalo laka ruei, a kamiu monoka kuvila bajago nalo na memedu lie vo tuvululo, ver p̃eli, mia kamiu kuvijikia re kuva jouro ea Atua kiano navenatuboiano.” ");
INSERT INTO bki_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ana Yesu berii bunu, berinavo “Kamiu kumijog ruei ka napano aberloglog kiado tormoruo nalo re nua beamu, aber ‘Kouebini re toro,’ mia bunu ‘Toro na riuebin toro rim̃aro, mia memedu ka avuru naio riva komeli ka mia ail vanio.’ ");
INSERT INTO bki_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mia kiniou nei, neber ka kamiu: verenio toro na tinienjer kuruano, mia memedu ka avuru naio riva komeli labo, toro napano mil bova toru ka kuruano, naio berenio ‘!Jau kobo ka ga iakurano!,’ memedu ka avuru naio ea kiado tomu na tortoru nalo kialo vioriano. Mia verenio toro tai napano naio mil m̃ele ban kuruano, naio berenio ‘Pariparimo miavovu’ mia memedu ka mia avuku naio rivan ea sebi ea vio na jogvaiano. ");
INSERT INTO bki_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ka tena, verenio bogo tai jau komei ea Atua kiano vio na sida ka mia kodu kanamo ijaiano van naio, mia tiniem rimaio ka napano kanamo vite tai joa jau kamjuo kuruamo, ");
INSERT INTO bki_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jau monoka kodu batitig kanamo ijaiano tobo ea vio na sida nei beamu vo, ana monoka kavan bereio kala merevuiano kam ve juo beamu vo, avona iorou kanio ana mo jau komijikia komei bereio ka kodu kanamo ijaiano rivan Atua. ");
INSERT INTO bki_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Verenio jau bogo tai kovilvil ea toro tai ka titai, karina naio jidom rivurso kava komeli kario, mia bo ka jau kavan sop̃eli keial naio ka keil vatitig vija naio tukamu, ka bogo napano maka avuruso kava komeli vo. Verenio makanio, p̃eli mia naio ruduso kotoa toro na toru jum̃ano ka naio tibureso, a mia naio naruei ruduso kotoa toro nam̃a bokakar toro jum̃ano, ka toro nene naio ruduso kotoa yimo na tetavokoiano. ");
INSERT INTO bki_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kiniou neber kaso, verenio tibena mia jau maka kejikia kataluvo den yimo na tetavokoiano rivan rivokar bogo na mia jau kovulu nonovio kanamo mauo beamu, avona bisi ana jau komijikia kataluvo.” ");
INSERT INTO bki_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ana Yesu berii bunu, berinavo “A kamiu kumijog bunu ruei ka napano aberloglogio ruei, aber ‘Mia kala re siakaiano.’ ");
INSERT INTO bki_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mia kiniou neber ka kamiu, verenio toro na biti va ea tira tai ka naio jidom rivurio, mia naio mila siakaiano ban tira nene ruei ea kiano iviso. ");
INSERT INTO bki_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","30","Verenio miramo tivelinio rilaso kala kariano, bo ka jau ketelario, kovuku rivano. A verenio jum̃amo tinene rilaso kala kariano, bo ka jau ketelario, kovuku rivano. Bo kanio jau kalavenio niabemo togio tibena, ver p̃eli, mia mokotenamo reraio rivakovio ea vio na jogvaiano.” ");
INSERT INTO bki_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ana Yesu berii bunu, berinavo “Bereio, aber bunu nua, aberinavo ‘Toro napano jitiglar koano, mia naio monoka rudu m̃esi na silubariano tai vanio, napano naio beriio meravo ka naio jitiglar naio ruei, tira na maka bunu ve koano.’ ");
INSERT INTO bki_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mia kiniou neber ka kamiu, ver toro na ver jitiglar koano, ka iakurano ga maka tira nei naio rive kodovo van koano neibano jukamu, mia ver tira neibano naio rila siakaiano, mia koano moruo naio be burupati nene. Mia toro na ver soro ka tira na jibe nei mia naio mila siakaiano.” ");
INSERT INTO bki_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ana Yesu berii bunu, berinavo “Kamiu kumijog bunu ruei ka nalo aberii ka kiado tormoruo nalo nua bogobe, aberver jau kover Atua siano ka mia rila kanamo verikariano to sikili, mia maka jau kalakorov bereio kanamo iliano nene. A vaio napano jau koberkar ban Atua, monoka jau kalaiio. ");
INSERT INTO bki_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“Mia kiniou neber ka kamiu, neber jau maka kejikia kover titai siano leleio ka rila kanamo verikariano to sikili. Maka kejikia kover ‘Riano mave’ ver p̃elina jau kojom̃a kamila bulag tolu na vio mave napano be vio na Atua kiano. ");
INSERT INTO bki_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A maka kejikia kover ‘Riano, vio yetemeriba novo na,’ ver p̃eli, mia jau kala bulag tolu na vio yetemeriba na jotano ka Atua kiano moroano. Maka kejikia koverenio ‘Riano, komeli lu yako Yerusalemo niako vo’ ver p̃eli, jau kojom̃a komila bulag tolu na vio na kanado Parinio Tubo Lu kanano. ");
INSERT INTO bki_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A maka kejikia koverenio ‘Riano, paripariku nei’ kanio rila kanamo verikariano to sikili, ver p̃elina jau kojom̃a komila bulag Atua kiano tolu napano naio ga takurano mijikia rila viju parido tai ve takurano rimei riuvu p̃elina rimei ribobogio. ");
INSERT INTO bki_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ea kenemiu verikariano nalo, monoka kamiu kuver ga ‘Nao,’ p̃elina kamiu kuver ga ‘Makanio,’ nina ga barei na. Iliano dolu nalo napano m̃a kumitum̃a kuberenio, nalo abinimei den Sim̃aro.” ");
INSERT INTO bki_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ana Yesu berii bunu, berinavo “Mia kamiu kumijog naverloglogiano nalo aberii nua ruei, aberinavo ‘Verenio toro tai rila lelan toro dolu mirano tinene, monoka ala lelan mirano bunu. Mia verenio toro tai tukular toro dolu m̃arjuvono tai, monoka atukular m̃arjuvono bunu.’ ");
INSERT INTO bki_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mia kiniou nei naruei neber ka kamiu, Mia koviolua re toro napano mila bova banso. Verenio toro rijuba yaba miramo tivelinio, monoka jau kovilig yaba miramo tivelinio rivan kean naio, ka naio rijuba bunu. ");
INSERT INTO bki_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A verenio toro tai rivurso ea komeli ka tutuaso ka m̃amo kulusoto, mo mia jau kajamo ka vanio vija m̃amo kulukoti bunu. ");
INSERT INTO bki_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A verenio toro na toru tai ritutuaso ka kavar kiano basaro keiel ka aura ve takurano, tibe ka napano naio mijikia berenio, monoka kasaaro ga ka kavario keiel ka aura ve takurano bereio vo. ");
INSERT INTO bki_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Verenio toro tai rivika vite tai denso, mia monoka jau kodu vite nene vanio, a verenio toro tai sidom rudu kija vite na be kanamo, mia monoka kajamo ka vanio mia koverbureio re.” ");
INSERT INTO bki_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ana Yesu berii bunu, berinavo “Mia kamiu kumijog naverloglogiano nalo aberii nua ruei, aberinavo ‘Monoka jau kosidom nalo napano aju vaataro kaso, mia jau kovijuku die kanamo uolu nalo.’ ");
INSERT INTO bki_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mia kiniou nei naruei, neber ka kamiu, neber monoka kamiu kuvisidom kenemiu uolu nalo, a kubolkouo ka nalo napano amila lelan kamiu, ");
INSERT INTO bki_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ka mia kamiu kuvitakii vatitigio bajago na Karamemiu na ea vio mave, napano naio jidom nalo beverare ga. Tenene na naio mila kanano inio merera a kanano yuo bovo ea tomu nonovio, toro napano bo, a toro napano bova. ");
INSERT INTO bki_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Verenio kamiu kuvitum̃a tiniemiu riia tomu nalo na ga tiniel miia kamiu, Atua maka rijikia rijev ijaiano van kamiu riviorio. Tomu nalo nam̃a abarbijii takis, napano kulo dolu nalo aberinavo nalo abe kulo va, mia nalo abare ka ala tibe na. ");
INSERT INTO bki_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Verenio kamiu kuvitum̃a kuvan jumemiu kamliko ga kenemiu tomu nalo, nina maka tovulu bajago na kulo va nalo. Tomu nalo napano maka amonea Atua, ajum̃a ajidom bunu kanalo m̃aratavo nalo. ");
INSERT INTO bki_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mia kenemiu meuliano nalo monoka tibe ka na Karamemiu napano joa vio mave kiano bajago, napano memedu, a bo laka ban tomu nonovio.” ");
INSERT INTO bki_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ana Yesu naio mil banlo, berinavo “Vite nalo napano kiado nalotuano naio berenio bo ka alaio, kamiu kuvila re tavukia napano kamiu kumilaio ka mia tomu ve telabo ajikia avitilubario ka napano kamiu kumila tonovo. Verenio kamiu kuvitum̃a kuvila tibe na, mia Karamemiu napano joa vio mave, naio maka rijikia rije ijaiano van kamiu rivior vite na. ");
INSERT INTO bki_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tibe na, ea bogo nalo napano jau kesian ijaiano van talim̃asa nalo, jau keil vevavin re kanio, tavukia nailikuleiano nalo. Nalo ajum̃a aber bulag kanalo im̃auano novo nalo joomo ea yimo na volkouano, a tavio bunu ea vio medave, ka rila ana tomu nalo avamenealo kanio. Mia kiniou neber ka kamiu, vameneano na kulo dolu na, nina ga be kialo ijaiano, mia maka bunu ajikia avokar vite dolu bereio. ");
INSERT INTO bki_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mia ver bogo na jau kodu ijaiano tai van talim̃asa nalo, monoka jau kala ea bajago na tai napano mia jau ga ve takurano kejikia kanamo im̃auano novo na, a napano kanamo jidomiano rivarvar re naio kanio. ");
INSERT INTO bki_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ver jau kalavan kiamo im̃auano vu tibe na, mia Karam̃amo napano mijikia mial vite nalo napano kulo dolu maka ajikia aialio, naio mia sian ijaiano vanso riviorio.” ");
INSERT INTO bki_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ana na Yesu berii bunu, berinavo “Verenio bogo napano kamiu kubolkouo, mia maka rivu ka jau kala takii bajago napano nailikuleiano nalo kialo. Nalo ajidom m̃elea ka atumolu ka abolkouo joomo ea yimo na volkouano, a tavio ea vio medave nalo, ka tomu nalo amijikia aialo. Vameneano na kulo dolu na, nina ga be mauo, mia maka bunu ajikia avokar vite dolu bereio. ");
INSERT INTO bki_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mia ver bogo napano jau kobolkouo, mia bo ka jau kala ka mia jau ga ve takurano kava joomo ea kunuamo yesobi, ea vio na tomu nalo ajikia re ka aialso, mia jau ketetavoko kiamo m̃aratavo, ana mo jau kobolkouo van Karam̃amo napano naio jo, mia maka toro tai rijikia rial naio. Ana mia Karam̃amo nene naio ga mijikia rial vite nonovio nalo napano tomu nalo maka ajikia aialio, mia naio rijev mauo nene vanso riviorio. ");
INSERT INTO bki_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Mia ver bogo napano kamiu kubolkouo, maka rivu ka kamiu kuver iliano ve telabo tibe ka tomu dolu nalo na maka amonea Karam̃ado riano vo. Nalo ajidomii aber mia avokar vaio napano ajum̃a abolkouo kanio, bior nalo aju aber iliano telabo telabo ea kanalo volkouano nalo, mia be deio ga. ");
INSERT INTO bki_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mia kamiu kuvila re takii kialo bajago, bior Karamemiu, naio mijikia ruei vite nalo na kumisidomio, bogo napano kamiu maka kuvika vite nalo nei denio vo. ");
INSERT INTO bki_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Bior vite na, memedu ka mia kamiu kubolkouo tibe ka volkouano nei, napano naio berenio, berinavo ‘Karamememi napano jau kojoa vio mave, memedu ga ka tomu nalo atu avatove ka siamo lu. ");
INSERT INTO bki_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kumemi nubolkouo ka kanamo navenatuboiano rimei tumolu tu sikili ea vio yetemeriba nei, ka mia tomu nalo alaio tavukia ga napano jau kojidomio, tibe ka napano nalo na vio mave ajum̃a amilaio. ");
INSERT INTO bki_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aiou, jau kesian van kumemi sememi sinaniano, banei a ea legiano nonovio. ");
INSERT INTO bki_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","A jau koviekokoa kumemi rivior kenememi kariano nalo, tibe ka kumemi numitum̃a nubiekokoa tomu dolu nalo napano amila vite jorokor ban kumemi. ");
INSERT INTO bki_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A jau kajamo ka re vite va nalo na ajukujuku kumemi m̃ele, a kovuru bulag kumemi den sim̃aro napano jidom rila lelan kumemi.’ ");
INSERT INTO bki_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Bior ver kamiu kuviekokoa tomu nalo na abijuku jorokor ban kamiu, mia Karamemiu na joa vio mave naio riviekokoa kenemiu vijukuano torokoriano nalo bunu. ");
INSERT INTO bki_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mia ver kamiu kuvisaaro re ka kuviekokoa nalo napano abijuku jorokor ban kamiu, mia Karamemiu naio maka rijikia riviekokoa kamiu ka kenemiu torokoriano nalo bunu.” ");
INSERT INTO bki_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ana Yesu berii bunu, berinavo “A bereio, ver bogo napano kamiu kumituvan semiu sinaniano, kuvel ga ka tiniemiu rimaio ka Atua a kuvolkouo vanio, maka kamiu kuvijikia kuvila tibe ka maka kuvisekon miremiu, p̃elina kamiu kuvila miremiu tibe ka jijer tanea kamiu, ka tomu nalo avitilubar tena kamiu kumitum̃a kumilaio. Nina be im̃auano na bova ga na nailikuleiano nalo kialo. Ana verenio nalo ala tibe na, a tomu tai tiniel riialo, nina be kialo vuluiano napano amijikia ajevio rivior kanalo monduluano, mia Atua maka rijikia sian titai vanlo bereio. ");
INSERT INTO bki_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Mia jau, bogo napano ver kotuvan samo sinaniano to tibe na, bo ka jau koyovovua vatitig miramo, tavukia nam̃a jau kojom̃a komilaio julaka ga, ");
INSERT INTO bki_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ka mia tomu nalo ajikia re vaio napano jau komilaio. Karam̃amo ga napano jo, maka tomu nalo aialio, mia naio ga rivitilubario bior naio rial vite nalo napano tomu dolu nalo maka ajikia aialio, ana na mia naio rijev mauo nene vanso kanio.” ");
INSERT INTO bki_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ana Yesu berii bunu, berinavo “Maka rivu ka kamiu kuvitum̃a kuvila bijii kenemiu saba novo nalo ea vio yetemeriba nei ka mia kuve tomu na sanibaiano. Bior vio yetemeriba nei be vio na sivinia nalo, a tauo bunu napano mijikia rila bulag kenemiu saba novo nalo, a toro na vinauano bunu napano mijikia rimei rivar bulag saba nalo napano kamiu kumim̃auka bijon kanio. ");
INSERT INTO bki_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mia kamiu monoka kuvila bijii kenemiu saba novo nalo tu mave, ea vio napano sivinia a tauo a tomu na vinauano nalo ajikia re ka amei ala bulag kenemiu saba novo nalo napano kubar batitiglo aju. ");
INSERT INTO bki_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Bo ka kamiu ve kenemiu saba novo nalo vetelabo atua vio mave, bior mia kenemiu iviso rivujo tulaka ea jidomiano nalo na vio napano ga kenemiu saba novo nalo ajuaio.” ");
INSERT INTO bki_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ana Yesu berii bunu, berinavo “Toro mirano be vio tai napano yulu binimei joomo ea mokotenano. Verver miramo rimeravo rivu, mia komijikia kovitilubar vatitig toro dolu, ka koija naio. Verver kala tibe na, kiamo iviso bujolou ka yulu. ");
INSERT INTO bki_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mia verver miramo rimeravo re rivu, mia maka kojikia kovitilubar vatitig toro dolu, mia koto kovitii kiamo saba nalo ga, ana koto kove viti kalo. Verver kala tibe na, kiamo iviso bujolou ka melijokouo, a ver melijokouo ritoa vio napano memedu ka yulu toaio, nina jau kojoa melijokouo na bobogio mia kiri bobogio laka.” ");
INSERT INTO bki_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mo Yesu berii bunu, berinavo “Verenio toro ve takurano, naio maka rijikia rim̃au buron ea tubo ve juo ve vaarakurano. Verenio tibe na, mia naio tinien tii tinene, mia naio rilikue ka tinene, p̃elina mia naio rudu niono tinene, mia tuvan tinene. Kamiu maka kuvijikia kuvila ka kuve Atua kiano tomu nalo a kamiu kuve tomu na puruveru bunu ka bogo nene ga.” ");
INSERT INTO bki_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ana Yesu berii bunu, berinavo “Ka tenene, kiniou neber ka kamiu, maka rivu ka tiniemiu rivujo m̃ele ka kenemiu im̃auano na kuvitikar kamiu nalo, ka mia kuvivika, kuver ?Mia releal sado sinaniano vija m̃ado uei tum̃abe, a mia releal m̃ado kuluniabedo na mia reyaio toko mokotenado tum̃abe? Mia jidomiano nalo na biniu kiri torokor laka, bior kenemiu meuliano nalo, naio bo loa sinaniano, mia mokotenemiu nalo, abo loa kuluniabelo. ");
INSERT INTO bki_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kamiu kuvial von menu nalo napano m̃a aju amier janea vio. Mia nalo maka ala tiniavio, a nalo maka avarbijii sinaniano rimei vonuo, a nalo maka avar batitig sinaniano tu joomo ea yimo. Mia Karamemiu na vio mave naio baganlo, mia kamu ea mirano, naio mial kamiu kumitu mave loa menu nalo, mia naio monoka rivitikar kamiu rivu lie vo loalo. ");
INSERT INTO bki_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","?Kamiu kuberiam̃a toro tai mijikia rila kiano meuliano na bulati rimei ve tebievi kija bereio, bior jom̃a jidom m̃elea kiano meuliano? P̃eli ga, maka tibe na, ana bo ka kamiu kuvisidom m̃elea re kenemiu meuliano. ");
INSERT INTO bki_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?A bior vaio ana kamiu kumitum̃a kumisidom bereverei ea kuluniabemiu? Kuvisidomii von burunieginiegi nalo napano aju amiluo janea vio ga. Nalo maka aim̃au a maka atul m̃alo kuluniabelo nalo. ");
INSERT INTO bki_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mia kiniou neber ka kamiu, Parinio Tubo Solomon re nua, napano naio be toro na sanibaiano tai, jum̃ano bujo ka saba nonovio, mia m̃ano kuluniabene maka tavukia burunieginiegi nalo nei m̃alo. ");
INSERT INTO bki_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Burunieginieg nalo na abe tena bogoti takurano ga, mia beni ana mia aisebilo ea sebi, mia Atua naio jo miyovovua batitiglo bo laka. ?Ana na kamiu kuberiam̃a naio maka rijikia rivar kenemiu kuluniabemiu van kamiu? !Aa, maka lele garuei kuviekouo ea Atua sikili leleio! ");
INSERT INTO bki_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bior vite nalo na, mia maka rivu ka kenemiu iviso nalo avujo ka jidomiano nalo na, ka kuvika kuver ‘?Jum̃abe, mia resen venia, romunu venia, a releal kiado kuluniabedo nalo tum̃abe?’ ");
INSERT INTO bki_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nao, bogo nonovio ga tomu na maka amonea Atua nalo ajum̃a ajidomii m̃ele vite nalo na jibe na julaka, mia kamiu, Karamemiu napano jo mave, naio mijikia ruei ka monoka kamiu kumisidom ka kuvar vite nalo na. ");
INSERT INTO bki_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Vite na be moti ka mia kuvisidomiio ve toru laka ea kenemiu meuliano, naio be Atua kiano navenatuboiano, vija kiano namemeduano nene nalo. Verenio tibe na, mia naio rivar bunu vite dolu nalo na rivan kamiu.” ");
INSERT INTO bki_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Tibe na maka rivu ka banei, kamiu kuvitum̃a kuvisidomii m̃elea rivior tena legiano na beni. Beni ga, ana mo kamiu kumijikia kuvisidomii tena vio beni, bior legiano na banei, naio be kiano jaleleano nalo telabo ruei.” ");
INSERT INTO bki_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Naruei Yesu mil kia ga vo banlo, berinavo “Mia monoka kamiu kuvitibure niegeniege m̃elea re toro dolu. Tibe na, mia Atua naio tibure re kamiu sikili, ");
INSERT INTO bki_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","bior jidomiano napano joa kamiu ka bogo napano m̃a kamiu kumitibure toro dolu, mia jidomiano na ga jibe na joa Atua ea bogo napano mia naio tibure kamiu. Mia kamiu kuvar tibureiano rive verare ga ka tibureiano napano kamiu kumisianio. ");
INSERT INTO bki_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Maka rivu ka jau kotom̃a koververii soro napano telisu ga joa kuruamo mirano, mia jau maka keial kar ka be burum̃ara bulapati iesi tai napano joa miramo. ");
INSERT INTO bki_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Jum̃abe ana na jau kober komijikia keil van kuruamo na, koberinavo ‘P̃eli nelelar soro na telisu na monea miramo beamu?’ ");
INSERT INTO bki_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Jibe na, jau maka kotom̃a kovitilubar kiamo kariano, ana na jau kojom̃a kojiibure kulo dolu nalo kialo kariano nalo! Mia jau kobe toro na ilikuleiano ga. Jau kodular bulapati iesi na den miramo beamu vo, karina mo jau kovitii batitig rivu ea niati soro na telisu na ea toro dolu mirano. ");
INSERT INTO bki_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Maka rivu ka kuvila von ka kuverial Atua kiano Iliano Lu van tomu nalo napano maka asaaro ka ajevio. Nina jibe ka napano kamiu kumitum̃a kubagan kuli deden ka sinaniano novo nalo, naruei bogo napano ajenio bisi, ana mia avilig pariparilo mia nalo aser kamiu bereio. Jibe ga na bunu verenio kamiu kuvisian ijaiano novo nalo van kiribue nalo, mia nalo avie dodomlo ea bulukinia.” ");
INSERT INTO bki_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Mia Yesu berinavo “Toro na ver jom̃a bika vite, julaka mia naio mijikia rijevio, mia verenio toro na jom̃a jirag vite, julaka mia naio mijikia rilealio, mia ver toro na naio jom̃a minia m̃aratavo, julaka mia m̃aratavo nene mijikia rivetavo ka naio. Tibe na, mia kamiu kumijikia kuvar vite nalo nam̃a kumitu kubika den Atua, mia kamiu kumijikia kuvileal vaio nam̃a kamiu kumitum̃a kumisirag denio, mia m̃aratavo nam̃a kumitum̃a kuminia, mia Atua rivetavo ka van kamiu. ");
INSERT INTO bki_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Verenio kenerimo tai siserio, rivika kiri joko napano jo, mia jau maka kejikia kesian puruveru van naio, ");
INSERT INTO bki_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","p̃elina ver naio rivika batitig ga niado na jo ruei, maka kejikia kodu maro tai van naio ka senio. ");
INSERT INTO bki_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Riano ka kamiu kube kulo va ga nalo, mia maka kamiu tai rijikia rila tibe na, kamiu kumitum̃a kumisaaro dam̃ariga ka kuvisian vite novo nalo van kenerimiu nalo. Jibe na ga, ver bogo napano kamiu kubika vite tai den Karamemiu na vio mave, mia naio jaaro ga ka sian vite novo nene nalo rivan kamiu kenerinio vevinio nalo rivavin ve toru laka vo. ");
INSERT INTO bki_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bo ka kamiu kuvila rivu van tomu dolu nalo dam̃ariga ea vite na bo nalo, tibe ka ga na kamiu kumisidom tomu dolu nalo monoka ala rivu van kamiu. Iliano nei naruei naio be burupati na iliano nalo na jua tuboiano napano Mosis jirio, bija bunu vaio napano naverialiano re nua nalo aberiio.” ");
INSERT INTO bki_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ana na Yesu berii bunu, berinavo “Be burum̃ara bulumorouo tai napano betavo laka jo, mia m̃arabo nene jagati toru laka be vodobi bo. Mia tomu telabo ajum̃a ajakii m̃arabo nene, mia m̃arabo nei naio ban ea vio na avokar vironiano. Mia kamiu monoka kuvisel ea bulumorouo dolu napano naio kiritavaso. M̃arabo nene naio jikili, mia maka tomu nalo ve telabo napano ajeliaio, mia m̃arabo nei naio be m̃arabo na meuliano.” ");
INSERT INTO bki_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ana na Yesu berii bunu, berinavo “Bo ka kamiu kuvitikar vatitig ka tomu nalo nam̃a aju aber nalo abe naverialiano, mia nalo ajum̃a aberloglog vite na be sibiano ga. Bogo napano ajidom averloglog kamiu, abinimei ajibe ka kenemiu bilbilu novo kamliko, napano ea kuluniabelo amom̃avo novo ga, jibe ka nunu nalo, mia ea kialo iviso nalo ajavukia kuli deden nalo ga, napano m̃a jijerlo ka vite nonovio. ");
INSERT INTO bki_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mia kamiu kuvitilubarbarlo ea m̃arati na kialo meuliano nalo. Soro napano be niononoti, bija teli nalo napano abe niononoti, maka atum̃a avar sinaniano novo p̃eli m̃arati napano jesei bo. ");
INSERT INTO bki_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Buruiesi napano jo miluo bo, naio monoka rivar m̃arati na bo, mia buruiesi napano maka riluo rivu, naio monoka rivar m̃arati na bova ga. ");
INSERT INTO bki_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Buruiesi napano jo miluo bo, maka rijikia rivar m̃arati na bova, a buruiesi napano maka riluo rivu, maka rijikia rivar m̃arati novo nalo. ");
INSERT INTO bki_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jibe na naruei, ana buruiesi va nalo nei napano maka avar m̃arati novo nalo, mia monoka ate bulaglo ga ana mo avukulo van ea sebi. ");
INSERT INTO bki_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jibe na naruei, m̃arati napano miyotuba ea toro kiano meuliano, mila meravo ka toro na naio be toro na jum̃abe, mia kamiu kumijikia kuvitilubar naverialiano va nalo na ea m̃arati va nalo napano amiyotuba ea kialo meuliano nalo.” ");
INSERT INTO bki_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ana Yesu mil berinavo “Tiniobi toru ajum̃a abio kiniou, aber ‘!Kiaku Tubo, kiaku Tubo o!’ mia nalo aviniu re napano mia amijikia ava jouro ea Atua kiano navenatuboiano ea vio mave. Toro napano mijikia riva jouro, naio be toro ga napano jom̃a mila vite nalo napano Karam̃aku naio jidomio. ");
INSERT INTO bki_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mia ka bogo napano mia Atua tibure tomu nalo, mia tomu ve miroano avio kiniou, tibe ka kiniou nebe kialo Tubo. Mia averinavo ‘?Tubo, jum̃abe ka kumemi? Kumemi numim̃auka vite telabo na bo ea siamo, a kumemi nuber bulavulag kiamo iliano, a kumemi numijil bulag sim̃aro nalo, a numila vremesiano nalo telabo bunu. ?Mia jau maka bunu kosidomial kenememi im̃auano novo nalo nene a?’ ");
INSERT INTO bki_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mia kiniou neverial kalo rimemedu ga ea miralo, neverinavo ‘Kiniou maka leleio nejikia kamiu bogo tai, napano kamiu kube kiaku. Kamiu tomu na kariano ga. !Kamiu kuvitaluvo den kiniou vonganei!’” ");
INSERT INTO bki_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ana Yesu naio mil berinavo “Tibe na, nalo napano atakii vatitigio tibe ka napano kiniou neberloglog kamiu ruei, mia nalo atavukia toro tai na be masou, napano mim̃auka kunuano, napano mebija kiano m̃artea nene batove bokar tabap̃ilio na jikili. ");
INSERT INTO bki_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iorou kanio, ana yuo bovo toru binimei, mia ueimia buru vio toru, mia jegi miuvuvu biloulo, midon yimo nei, mia yimo nene maka rijoru, bior toro na yimo nei naio milakar kunuano jo mave ea tabap̃ilio. ");
INSERT INTO bki_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mia nalo napano maka atakii vatitigio rivu tibe ka nam̃a kiniou neberloglog kamiu ruei, nalo ajavukia toro tai napano kiano jidomiano kirivova, telikiti napano naio mim̃auka kunuano, naio bitiri bulag m̃artea nene nalo mave ea bayono ga. ");
INSERT INTO bki_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iorou kanio, mia yuo bovo batove, ueimia buru vio toru, mia jegi miuvuvu biloulo midon yimo nei, mia yimo nei mijoru. Mia bogo na naio mijoru, toro nei kiano im̃auano binimei bova kitkitio garuei.” ");
INSERT INTO bki_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iorou ka napano Yesu mila nonovio kiano iliano bisi, mia tomu nalo aju amiilo manenea kanio, ");
INSERT INTO bki_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","bior abitii kiano iliano maka tavukia kialo tomu na verloglogiano na tuboiano nalo kialo, mia kiano iliano tomi laka, a jo julu kialo jidomiano nalo, a naio ber bulavulag iliano nalo javukia na moroano joa naio. ");
INSERT INTO bki_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mia Yesu naio jumolu den suku, napano naio jom̃a berloglog tomu nalo eaio, naio batove, ana tomu telabo ajakisor naio. ");
INSERT INTO bki_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Naruei toro tai napano naio bar burumieni binimei vaataro keanio, naio minie kamu kanio, ana balea, berinavo “!Tubo! Kiniou namoneaso ka jau komijikia kalarur kiniou bereio, ana ver jau kajaaro, nejidom nevika denso ka jau kala tibe na van kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ana Yesu maka rimerou ka tokol toro nei rivior kiano mieiano, mia naio jian jum̃ano, jokolio, ana naio berinavo “Kiniou nejidom jibe na. Neberinavo, mo, niabemo rivu.” Mia vaarakurano ga niabene meravo, mia burumieni nei naio bisi denio. ");
INSERT INTO bki_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ana na Yesu berkanio, berinavo “Jau komijog, jau kava koverii re tenei van tomu nalo vo, mia vonganei jau kava koverloglog niabemo ka toro lu, ka naio ria veve niabemo. Karina, jau kava kolotu van Atua, keisebi sida nam̃a Mosis naio berenio monoka toro rilaio bior vite na jibe na, mo iorou kanio nina, mia toro lu naio mijikia riverialio river burumieni nei naio bisi.” ");
INSERT INTO bki_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mia bogo na Yesu naio ba jouro ea bulukomeli na Kapeneam, boru na mira tai na vio Romo binimei mialio, naio jegi banio, ");
INSERT INTO bki_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","naio berinavo “Tubo, kiaku naim̃auano tai naio mijoru mon kea ea m̃ano jogu ea kunuaku. Niabene togio m̃aro, a naio mijog bova toru laka.” ");
INSERT INTO bki_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ana Yesu naio berkanio, berinavo “Mo, kito ve juo ravano. Mia kiniou nala naio rijog rivu bereio.” ");
INSERT INTO bki_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mia boru na toro na mira nei naio berdop̃eio, berinavo “Tubo, kiniou maka neve verare ka jau komei joomo ea kunuaku, jibe kanio kiniou maka neve toro Ju, mia ver jau kover iliano tai ga, mia kiniou nemijikia ka mia kiaku toro nene naio mijikia rijog rivu bereio. ");
INSERT INTO bki_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mia kiniou nemijikia ka monoka tibe na, bior kiniou nemijikia ka kiamo iliano amije moroano toru. Naio jibe kanio tomu na mira nalo napano aju yetano ka kiniou, napano mia monoka ajogkar kiaku iliano. Ver never ka tai ‘Kavano’ mia monoka rivano, p̃elina never ‘Komei’ monoka rimei, p̃elina never ‘Kala tibe na,’ mia monoka naio rilaio. Mia kiniou bunu monoka nala tena kiaku boru na toru naio berii ka kiniou. Jibe na naruei, ana kiniou nomoneaso ka ver kover ga titai, mia monoka tibe na.” ");
INSERT INTO bki_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mia bogo na Yesu mijogial iliano nei, mila naio miilo toru a naio jaaro toru laka kanio. Naruei naio ber ka tiniobi nalo napano aju naliko, berinavo “Riano ga kiniou neber ka kamiu memedu, kiniou maka leleio neleal toro tai na vio Israel naio riviekar kiniou sikili tibe ka toro nei. ");
INSERT INTO bki_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mia kiniou neber ka kamiu neber, maka kulo Ju nalo ga ajikia amei jouro ea jokoluolu na toru ea legiano na maaro. Makanio, mia tomu dolu nalo bunu ve telabo tibe ka toro nei, ea vio dolu nalo ea yetemeriba nei, napano mia amei ka atutano vio takurano ka asinan naliko Epraamo, Aisak, a Yakovo. Mia nalo na atu rivu bogo nonovio tibe na jouro ea Atua kiano navenatuboiano ea vio mave. ");
INSERT INTO bki_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mia kulo Ju nalo napano Atua biolo jukamu ka ava jouro, voniganei maka bunu amonmonea kiniou, ana mia Atua rivuku bulaglo ava atu tavio ea melijokouo, ea vio napano tomu ajum̃a ajegi ajer m̃arjuvolo eaio.” ");
INSERT INTO bki_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Naruei Yesu ber ka boru na mira nei, naio berinavo “Mo, bo ga, jau komijikia kava vonuo. Mia rimaluvo kaso tibe ka na jau komoneaio.” Mia memedu ka bogo nene garuei, toro na im̃auano nei niabene binimei bo bereio. ");
INSERT INTO bki_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ana Yesu naio jo kia ga Kapeneam, ana naio ban ea Pitere kunuano, mia naio mial Pitere koano kenieno mieyulu, naio jo mon ea m̃ano jogu. ");
INSERT INTO bki_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naruei Yesu mijiou jokol tira nene jum̃ano, ana kiano mieyuluano nei jaluvo denio, ana naio mijog bo jumolu, naruei naio jian sinaniano ban Yesu. ");
INSERT INTO bki_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ea niogoravo na legiano nei, tomu nalo aburu tomu telabo abinimei ea Yesu, napano sim̃aro nalo ajualo. Naruei naio mijil bulag sim̃aro nalo nei ea ga kiano iliano, ana naio mila tomu na mieiano nalo bunu amijog bo bereio. ");
INSERT INTO bki_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Vite nalo nei amaluvo jibe nei ka mia rila Naverialiano Aisea kiano iliano rimei rimaluvo, tibe ka napano naio berenio, berinavo “Naio bar bulag kiado mieiano nalo, a naio bar kiado niabe jaleleano nalo bunu.” ");
INSERT INTO bki_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ea bogoti dolu bereio, ana Yesu jo naliko tomu telabo napano aju jeliviv ea naio, ana naio jidom taluvo denlo, naruei naio ber ka kiano naiagagoano nalo, berinavo “Kito m̃a, ravan ea ueiyabo tivelinio.” ");
INSERT INTO bki_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mo nalo abarvio ka mia avano, ana naverloglogiano na tuboiano tai binimei ea naio, berkar ban Yesu, berinavo “Naverloglogiano, mia kiniou natakisorso navan ea vio vabe na jau kavan eaio.” ");
INSERT INTO bki_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ana na Yesu naio berdop̃e banio, berinavo “Kuli deden nalo abe m̃alo p̃ili na amon eaio, a menu nalo abe m̃alo niuku. Mia kiniou, Kulorinio Kenerinio, kiniou maka ve kiaku vio tai, ka nava nomonmel eaio. Mia verenio jau kajaaro ka meuliano na jibe nei mia jau komijikia komei.” ");
INSERT INTO bki_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ea bogo nene ga, Yesu kiano naiagagoano dolu bereio berkanio, berinavo “Tubo, jau kajamo ka kiniou nava nevitikar kiaku tormoruo beamu vo, mia verenio bogo tai naio rim̃aro ana mia kiniou nemei bereio natakisorso.” ");
INSERT INTO bki_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ana Yesu naio berkanio, berinavo “Komei katakisor kiniou ga. Kotuvan tomu napano niunulo am̃aro ruei ka ativin kialo tomu nalo napano am̃arm̃aro.” ");
INSERT INTO bki_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mia Yesu naliko kiano naiaga-goano nalo abinimei aboru ea ueiyabo nei bisi, ana nalo abavin ea uako tai ea vio na. ");
INSERT INTO bki_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nalo aju abano, mia burum̃ara jegi tai binimei miuvuvu mila ueiyabo nei bieveluo m̃ele, mila uako nei jikar ka jidom rimadudu. Mia Yesu naio joa uako, mia naio mon ea selailugu monmelio, ");
INSERT INTO bki_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","mia nalo aba amila bonio, nalo aberinavo “!Tubo, keialio! Vaataro ka ramadudu naruei, jau monoka kalarur kito.” ");
INSERT INTO bki_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Naruei Yesu naio mil banlo, naio berinavo “!Mm! ?Kamiu kumerou ka venia? Kamiu maka kuvitu sikili ea kiaku moroano leleio.” Karina naio jumolu ju, ana naio mil berbure jegi ber riuvuvu re, naio mil berbure tei, ber rivatove. Ana vio binimei melumu bo. ");
INSERT INTO bki_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bogo napano naiagagoano nalo amial ka vio jubabinio bo jibe na, nalo amiilo toru, nalo aberenio “!Tomu nalo! Toro nei maka garuei, mil ga jibe nei, mia jegi naio tei naljuo amiduio. !Toro na naio maka tibe ka toro na!” ");
INSERT INTO bki_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mo bogo napano Yesu naio boru ea yaba ueiyabo tivelinio, ana naio ban ea kulo Katara nalo kialo vio. Ea vio na, tomu juo amiyotuba ea buluvae nalo na tomu na m̃ariano nalo, ana naljuo amileal Yesu. Tomu juo nei niadu ban ealo, mia nalo abe deden m̃ele, ana mila tomu nalo amerou m̃ele ka m̃a asel ea m̃arabo na. ");
INSERT INTO bki_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mia bogo napano nalo amial Yesu, naljuo amiaga jouo, aberinavo “?Jau Atua Kenerinio, kiamo vaio joa kumemi? ?Jau kobinimei ka koje vironiano van kumemi napano maka ve kenememi bogo nene vo, a?” ");
INSERT INTO bki_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana ea vio na taara na kiribue nalo ajum̃a amiuoiuo ea borotano, ");
INSERT INTO bki_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ana niadu nalo nei ajegi, abika jikili den Yesu, aberinavo “A verenio jau kejil bulag kumemi, nuberibo kaso jau keiila kumemi nuva joomo ea kiribue nalo na.” ");
INSERT INTO bki_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Naruei Yesu naio ber kalo, berinavo “Kuvano.” Naruei nalo ajaluvo den tomu juo nei, ana aba joomo ea kiribue nalo neibano. Mia vaarakurano ga, kiribue nalo nei ajikiti, aban ea yabalili tai, ana na ajibirbil abavatove ea ueiyabo nei, abava kovio eaio. ");
INSERT INTO bki_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Naruei tomu nalo nam̃a abitikar kiribue nalo nene aburo, aban ea kialo komeli, ana na nalo aberial vite nalo napano maluvo, a aberii bunu vaio napano bokar tomu juo nei napano beamu niadu jualo. ");
INSERT INTO bki_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Naruei vaarakurano ga, tomu nalo na komeli nene abinimei ka aial Yesu, mia bogo na amialio, nalo amil jikili ban naio ka naio taluvo den kialo vio. ");
INSERT INTO bki_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ana Yesu naio ban bereio naliko kiano naiagagoano nalo, abavin ea uako nei bereio, nalo abarkor ueiyabo na toru nei bereio, naruei nalo abinimei ea kiano komeli nei Kapeneam. ");
INSERT INTO bki_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mia tomu tai ap̃ier toro na mieiano tai binimei ea naio napano niabene togio m̃aro, naio mon ea m̃ano jogu. Ana bogo napano Yesu mialio ka nalo amonea jikili ka mia Atua rilarur toro na mieiano nei, naio ber ka naio, berinavo “Keneriku, jau komerou re. Kiniou nebiekokoa kiamo vijuku vovaiano ruei.” ");
INSERT INTO bki_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ana ka bogo nene tomu tai na verloglogiano na tuboiano nalo bunu aju, mia amijog Yesu kiano iliano nalo nei. Sop̃eli ga nalo aberii naio banlo, aberinavo “Toro na mil mila bulag tolu na Atua siano. Naio jo mil jibe na jibe ka naio be Atua ruei.” ");
INSERT INTO bki_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mia Yesu bitilubar kialo jidomiano nalo, naruei naio berinavo “?Ka vaio ana kenemiu jidomiano bujo ka sidom vovaiano jibe na? ");
INSERT INTO bki_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ver kiniou never tibe na ka toro na, never ‘Kiniou nebiekokoa kiamo vijuku vovaiano nalo,’ p̃eli na never kanio, never ‘Jau kotumolu keiel,’ mia iliano juo nei, tinene jikili ka averenio, a tinene naio monmaio ka averenio. Nina iliano na napano naio berinavo ‘Jau kotumolu, jau keiel,’ naio jikili laka, bior tomu nalo amijikia avitilubar ka toro nene jumolu p̃elina maka tumolu. ");
INSERT INTO bki_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mia kiniou neim̃auka titai napano mia kamiu kuvisidomii kuver Atua naio ga takurano mijikia rilaio, bior kiniou nejidom nala rimeravo van kamiu ka Kulorinio Kenerinio naio bare ka riviekokoa kariano ea yetemeriba nei.” Naruei Yesu mil ber ka toro na mieiano nene, naio berinavo “Jau kotumolu, jau kojuku m̃amo jogu, jau keiel kava vonuo.” ");
INSERT INTO bki_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana toro nei naio jumolu jibe na, ana naio ba vonuo. ");
INSERT INTO bki_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Telikiti na tiniobi nalo nei amialio vite nei nalo amerou, a nalo abamenea Atua, bior naio mijamo ka moroano ban toro tai ka naio mijikia rila tibe na. ");
INSERT INTO bki_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mia Yesu naio juvan vio na, naio miel kija ga ba lie bano. Naio jo miel bano, ana naio mial kiniou nojom̃a nojotano ea kanaku vio na im̃auano. Mia kanaku im̃auano ea bogo na, nojom̃a nabarbijii puruveru na takis. Naruei Yesu bio kiniou, naio berinavo “Mataiu, jau komei katakisor kiniou.” Mia kiniou nojumolu sop̃eli, najakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Karina Yesu binimei jinan ea kunuaku, ana ea bogo na noburu tomu telabo na abarbijii takis, bija kulo va dolu nalo telabo bunu abinimei, ka amijikia atutano asinan burukuti naliko Yesu naliko kiano naiagagoano nalo. ");
INSERT INTO bki_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ana na Varisis nalo tai amial ka napano Yesu jo vio takurano naliko tomu nalo nei, ana abika den kiano naiagagoano nalo, aberinavo “?Ka venia ana kenemiu naverloglogiano naio jom̃a jinan burukuti vio takurano jibe na naliko tom na bova na?” ");
INSERT INTO bki_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mia Yesu naio mijog kialo iliano nei, ana na naio berdop̃e banlo, berinavo “Tomu na niabelo jikili bo, nalo maka asidom toro na kulekuleiano, mia tomu na abar mieiano, nalo ajidom naio. ");
INSERT INTO bki_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bo ka kamiu kuvisidomii nioti na iliano tai napano joa Iliano Lu, napano Atua naio berenio, berinavo ‘Kiniou maka nesidom kenemiu sida nalo mia kiniou nejidom tinievuiano toa kenemiu meuliano nalo.’ Kiniou maka nemei ka novio nalo napano ajidomii aber nalo abe tomu na amemedu ruei, p̃eli ga, mia kiniou nebinimei ka novio tomu na bova nalo ka atakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iorou ka vite na, naiagagoano nalo na Jone Baruei kiano abinimei ea Yesu, nalo abika denio, aberinavo “Kumemi numisidom jau koverial vite na ka kumemi. ?Kumemi numondulu dam̃ariga ka nubolkouo, mia Varisis nalo bunu amila jibe na, mia bior vaio ana kiamo naiagagoano nalo maka alaio?” ");
INSERT INTO bki_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ana Yesu naio berdop̃e banlo, berii naio naliko naiagagoano nalo, jibe kanio napano nalo ajaaro toru laka bogo napano naio jo naliko, mia monoka nalo ajog rivova iorou ka bogo napano mia naio taluvo denlo, ana naio berinavo “?Bogo napano toro napano naio joro jo kia ga vo ea jokoluolu naliko kiano bilbilu nalo, kamiu kuberiam̃a amijikia ateg rivior naio? P̃eli ga. Mia bogo tai, verenio toro nei kiano uolu tai amei avurular naio den kiano bilbilu nalo, ka bogo na naruei mia nalo amijikia amondulu ka sinaniano bior nalo amijog bova toru.” ");
INSERT INTO bki_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Bajago na monduluano, naio be bajago moruo tai na nalotuano na kulo Ju nalo kialo, mia Yesu naio jidom rila rimeravo vanlo ka bajago moruo na jibe na, maka ajikia aviran rivija vite vou nalo napano naio jom̃a jiloglog kalo, ana naio jii jamerijiano tai tivelinio banlo, naio berinavo “Jau maka kejikia kodu niati kulum̃arauo napano be terivou, ka jau kotuluko ka kulum̃arauo moruo tai ka toko vio na burup̃e. Bior niati kulum̃arauo vou nei, naio mijikia rila korov kulum̃arauo moruo na togio, ana na mia bulujeleigio rimei ve toru lie vo. ");
INSERT INTO bki_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ana na jau maka kejikia koison m̃arjum̃elm̃elu vou napano naio jom̃a jarabujo kia ga vo ea kulukuti nani napano be terimoruo napano amison m̃arjum̃elm̃elu ea va telabo ruei. Verenio jau kala tibe na, mia m̃arjum̃elm̃elu nene riyukuio, rila kulukuti nani nene rivurup̃eio, naruei ana m̃arjum̃elm̃elu nene riou bulagio, ana kulunani nene rimei rivova bunu. Mia m̃arjum̃elm̃elu vou, jau monokanio koisonio rivan ea kulukuti nani napano be terivou, jikili bo, ana na jau komijikia kodu vatitig m̃amo m̃arjum̃elm̃elu toaio.” ");
INSERT INTO bki_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bogo napano Yesu naio jom̃a mil jibe na ban Jone kiano naiagagoano nalo, toro na toru tai na nalotuano na kulo Ju nalo kialo naio binimei vaataro keanio, naio minie tano ka Yesu, jegi banio, berinavo “Aue koig keneriku vevinio naio m̃aro vonganei ga, mia kiniou nebikaso ka nejidom komei, kodu jum̃amo toaio, ka mia naio rimeul bereio.” ");
INSERT INTO bki_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Naruei Yesu jumolu jakisor toro nei, naio naliko kiano naiagagoano nalo abano. ");
INSERT INTO bki_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Mo bogo napano Yesu naio jo miel ban jibe na, naruei tira tai naio jo napano mieiano na jada joa naio mila ka legiano nonovio ga, bokar yuka duelimo ba juo 12 ruei. Naruei naio mial Yesu jo binimei, naio jo ber ea kiano iviso, naio berinavo “Ver kiniou notokol ga kiano kulukoti, mia kiaku mieiano taluvo den kiniou.” Naruei tira nei binimei iorou ka Yesu taakano, ana naio jokol juluvati na kiano kulukoti. ");
INSERT INTO bki_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sop̃eli ga Yesu barip̃iligio, mial tira nei, ana naio berkanio, berinavo “Nena, jau komerou re. Kiamo viekouoiano ea kiniou burumeuliaso bereio.” Naruei memedu ka bogo na, mieiano nei naio jaluvo den tira nene. ");
INSERT INTO bki_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Telikiti napano Yesu naio boru ea toro na toru nei kunuano, naio mial tomu nalo aju tiniel miia tira sesa nei, ajum̃a ajegio, amiou ka iou na m̃ariano nalo. ");
INSERT INTO bki_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naruei naio mil banlo, berinavo “Kamiu kuvatavio kuviel dedade bereio. Tira sesa na naio maka rim̃aro na, mia naio monmelio ga.” Mia nalo na amiyotel ea naio, abital ea ga. ");
INSERT INTO bki_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Naruei nalo amiila bulag tomu nalo nei abatavio, ana Yesu naio ba joomo ea yimo. Naio ba bokar tira sesa nei jum̃ano, ana naio jumolu, meul vatitigio bereio. ");
INSERT INTO bki_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Naruei lilianiano na tenei buro janea vio ninio, bokar vio reraio jeliviv ea vio nei. ");
INSERT INTO bki_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mia Yesu naio jaluvo den toro na toru neibano kunuano, mia bogo napano naio jo miel bano, mia merebono juo ajakisorio, nalo ajum̃a abio naio, aberinavo “!Jau tormoruo Teviti kiano bajulukuti, jau kobe Naverikariano, aui koig, tiniem riia kumemi juo liki!” ");
INSERT INTO bki_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ana Yesu ba joomo ea yimo tai, naruei merebono juo nei abinimei ea naio. Naruei Yesu naio bika denlo, berinavo “?Kamjuo kumonea ka mia nemijikia nalarur kamiu tibe na?” Ana tomjuo nei aberdop̃e, aberinavo “Nao Tubo, kumemi numoneaio.” ");
INSERT INTO bki_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ana Yesu mije jum̃ano monea tomjuo nei miralo, ana naio berinavo “Mia rimei tibe ka na kamjuo kumoneaio.” ");
INSERT INTO bki_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ana na tomjuo nei miralo binimei bo bereio ea aura nene. Naruei Yesu berburelo jikili, naio berinavo “Mia kamiu kuverial re tenei van tomu dolu nalo.” ");
INSERT INTO bki_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mia abe juo abatavio, ana aberial lilianiano nei ka vaio napano Yesu milaio banbano-o bokar nonovio vio reraio nei biniu. ");
INSERT INTO bki_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Telikiti na naljuo nei abatavio, mia tomu dolu nalo aburu toro tai binimei ban Yesu. Toro nene niadu ban ea naio, mila na naio be buru maka rijikia ril. ");
INSERT INTO bki_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mia Yesu jan ka niadu nei jaluvo den naio, ana toro nei naio mijikia mil bo naruei, mia tiniobi nalo nei amiilo toru kanio, aberenio aberinavo “Uerei, maka leleio reial titai tibe nei kija ea kito kulo Israel-o, mia banei ga.” ");
INSERT INTO bki_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mia Varisis nalo aju aberenio, aberinavo “Tete na naio jom̃a jan ka niadu nalo jibe na ea ga moroano napano sim̃aro nalo kialo parinio tubo ga mijamo ka ban naio.” ");
INSERT INTO bki_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ana Yesu naio jo miel jeliviv ea komeli nalo a naio jom̃a berloglog tomu nalo ea kialo yimo na volkouano nalo. Naio jom̃a berial lilianiano vou na Atua kiano navenatuboiano, mia naio milarur tomu na mieiano nalo a tomu na niabele nalo bova bunu. ");
INSERT INTO bki_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mia bogo napano naio jom̃a miel jeliviv jibe na, naio jo mial tiniobi nalo, naio mialo jibe ka kialo jidomiano nalo bujo laka a nalo abokar jaleleano telabo laka ea kialo meuliano nalo, naruei naio tinien miialo toru laka, bior ajavukia nunu nalo na maka ve kialo toro na vitikariano tai, maka ajikia bunu ka mia atum̃abe naruei. ");
INSERT INTO bki_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Naruei naio ber ka kiano naiagagoano nalo, berinavo “Riano ga, m̃arimeuano toru meruo jua tiniavio, mia maka tomu ve telabo na aju ka m̃a abarvario binimei vonuo. ");
INSERT INTO bki_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kamiu monoka kuvalea sikili ea tubo na tiniavio nei, ka mia riila bulag tomu tabunu avan ka avar kiano sinaniano nalo rimei.” ");
INSERT INTO bki_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Naruei Yesu bio kiano naiagagoano duelimo ba juo 12 ka amei aialio. Nalo abinimei, ana naio mil batitig banlo, bisi na mije moroano banlo ka mia amijikia atitig bulag niununo va den tomu nalo, a ka amijikia aieliel ka tomu nalo napano m̃a amie ka mieiano dedade nalo bunu. ");
INSERT INTO bki_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Atevi nalo sialo nalo nei: nana jukamu, Saimon, napano abio ka Pitere, napano naio be kialo toro na toru, a Adru, napano Pitere kuruano; Yemesi naio kuruano Jone, napano Sepeti kenerinio nalo; ");
INSERT INTO bki_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Vilip; Bartolomio; Tomas; kiniou Mataiu, napano nebe toro na var bijii takis; Yemesi napano Alveas kenerinio; Tateas; ");
INSERT INTO bki_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, napano naio mila poletik m̃ele laka ka jidom rijil bulagio kulo Romo nalo; a Jutas na vio Kariot, napano mia iorou kanio ana naio jiveluku ka Yesu ban kulo va nalo. ");
INSERT INTO bki_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mia Yesu naio mil batitig ban nalo duelimo ba juo 12 nei, karina naio miila bulaglo abano. Ilivatitigiano napano naio berii kalo, nainei, naio berinavo “Mia kamiu kuvan ea re nalo napano maka ave kulo Ju nalo, a kamiu kuvan ea re m̃arkomeli nalo na vio Sameria vo. ");
INSERT INTO bki_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kamiu kuvan rivior ga nunu nalo na vio Israel napano amilaluv m̃arabo. ");
INSERT INTO bki_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mia ver bogo napano kamiu kuvan ka nalo na, mia kamiu monokanio kuvioliolu, kuverinavo ‘!Vonganei be bogo na mia Atua kiano navenatuboiano naio jo binimei ea kito!’ ");
INSERT INTO bki_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mia monokanio kamiu kuvieliel ka namieiano nalo, a kamiu kuvurumeulia tomu nalo napano am̃arm̃aro ameul bereio. Kamiu kuvilarur nalo napano burumieni milalo, niabelo ameravo bereio, a kamiu monokanio kuvititig bulag niadu nalo ea tomu nalo. Im̃auano nalo na, mia kamiu kuvim̃au kanio ea moroano tai napano kamiu kumijev kurano ka ga, ana mo mia kamiu monokanio kuvisian kurano ka ga bereio van tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mia kamiu kuvar re kenemiu puruveru tai vija kamiu ea kenemiu siveu nalo, ");
INSERT INTO bki_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","kamiu kuvar re kenemiu basaro tai napano m̃a kumison kenemiu kuluniabemiu dolu nalo vija kulubue na jaamiu dolu bunu ban eaio, a kuvar re kenemiu iesi na abanio vija kamiu kuvano. Tomu nalo napano m̃a amila im̃auano novo jibe ka kamiu, mia tomu nalo napano nalo nei amim̃au kanalo, monokanio mia nalo avitikar vatitiglo.” ");
INSERT INTO bki_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ana Yesu berii bunu, berinavo “Bogo napano verenio kamiu kuva kuvoru ea m̃arkomeli tai, mia monokanio kamiu kuvisirag toro tai napano naio jaaro ka rivurukar kamiu ka kuvitua kunuano, ana mo kuvitu vija naio rivano-o rivokar bogo napano mia kamiu kuvituvan m̃arkomeli nene bereio. ");
INSERT INTO bki_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Avena verenio bogo na kamiu kuvan kuvitu vija m̃aratavo na toro nei kiano, monokanio kamiu kuvan jumemiu kamliko, kuver kalo, kuver ‘Tum̃aro to vija kamiu.’ ");
INSERT INTO bki_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Avena verenio m̃aratavo nei avijuku rivu ka kamiu, mia kenemiu tum̃aro napano kamiu kuber kanio mia naio to vijalo, mia ver avijuku rivu re van kamiu, mia tum̃aro nei rimei bereio vija kamiu. ");
INSERT INTO bki_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mia ver tomu tai ailkue ka avurukar kamiu ea kunualo, mia ver ailkue ka aiagago ka kamiu, mia kamiu kuvituvan m̃aratavo nene p̃elina m̃arkomeli nene to. Mia bogo na kamiu kuvituvan vio nene, ana mo kuvijuba kon yevi ea jaamiu, tibe ka kenemiu iliano na jikili tai banlo ka mia avokar vironiano tai napano memedu ga ka kialo bajago va nalo. ");
INSERT INTO bki_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Riano kiniou neber batitig ban kamiu, mia sikili lie vo van nalo na ea bogo na tibureiano, tovulu bogo napano Atua naio jiibure kulo Sotomo bija kulo Komora nalo nanua beamu.” ");
INSERT INTO bki_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mia Yesu naio berii kalo, berinavo “Kamiu kuvisidomii vatitig rivu. Kiniou nemiila bulag kamiu ka kuvano, mia kamiu kuvano jumemiu yauo ga tibe na, napano kuvitibe ka nunu nalo napano aju iviso ka kuli deden nalo. Tibe na, monokanio kamiu kuve masou rivu, a monokanio kamiu kumelumu vatitig rivu. ");
INSERT INTO bki_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bo ka mia kamiu kuvitikar vatitig kamiu rivu, bior mia tomu nalo avuru kamiu kuvan ea komeli a ea kialo yimo na volkouano ka ail van kamiu, ana na mia atibure kamiu a mia avitiv kamiu. ");
INSERT INTO bki_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mia avuru kamiu kuva kuvitumolu kuvitu kamu ea tomu na tortoru nalo na buruvenuo miralo, kar ga kamiu kube kiaku naiagagoano nalo, mia ka bogo nene mia kamiu kumijikia kuverial kenemiu moneano na ea kiniou kamu ea nalo na miralo, a kamu ka nalo na maka amonea Atua miralo. ");
INSERT INTO bki_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mia ka bogo na nalo amei avuru kamiu, bo ka mia niukniuku rivie re kamiu m̃ele, kuver ‘?Mia neil tum̃abe, a never venia vanlo?’ bior mia Niununo Lu naio sian iliano van kamiu ka mia kuverialio, rimemedu ka bogo na iliano. ");
INSERT INTO bki_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ana bogo napano kamiu kuvil, mia ve re kenemiu iliano, mia ve Karamemiu kiano Niununo na naio mil ea kamiu. ");
INSERT INTO bki_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ea bogokouo na, mia toro mijikia rijamo ka kulo va dolu nalo amei avurular kuruano kar garuei, p̃elina kenerinio kar garuei, ka mia auebinvinlo am̃arm̃aro, nina bior ka napano nalo amonmonea kiniou. Mia kiritete nalo bunu amijikia atumolu, ka averial karam̃alo kenielo nalo napano amonmonea kiniou, ka mia am̃arm̃aro tibe na bunu. ");
INSERT INTO bki_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Naruei mia tomu nalo tiniel tii re kamiu, mia atup̃e kenemiu iliano ka kamiu napano siaku jua kamiu, mia ver toro napano riviekouo dam̃ariga rivano-o rivokar bogokouo nei ribisi, mia Atua rilarur naio. ");
INSERT INTO bki_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bogo na ver tomu nalo ala baravo ka kamiu ea komeli tai, mia kamiu kuvuro kuvan ea nana lie kanio, mia verenio nalo ala baravo ka kamiu ea vio na, monokanio kamiu kuvuro bereio. Riano kiniou neber ka kamiu, mia kenemiu im̃auano riviniu re vo ea m̃arkomeli nalo nonovio na vio Israel nei vo, mia kiniou Kulorinio Kenerinio, nemei bereio.” ");
INSERT INTO bki_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mia Yesu berenio “Naiagagoano, naio maka rijikia to loa kiano naverloglogiano, mia toro na im̃auano, naio maka rijikia to loa kiano tubo. Tibe na, mia kamiu monokanio kuvisidomii re kuver mia sikili re van kito bogo tai, ");
INSERT INTO bki_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","bior bajago na jikili napano mia ala ka naverloglogiano, mia ala ka naiagagoano bunu, a vite kouo napano m̃a tubo rivokario, mia kiano toro monokanio rivokario bunu. Jibe ka tomu nalo abio niegeniege kiniou, napano kiniou nabe tobu ka kiaku m̃aratavo, aberinavo kiniou nebe Belsabel, napano nina be sio na tubo na sim̃aro nalo kialo, mia amijikia avio niegeniege kamiu rivova lie vo, kamiu napano kube kiaku m̃aratavo nalo.” ");
INSERT INTO bki_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ana Yesu berinavo “Bior mia ail rivova ka kamiu tibe ka ga na amil bova ka kiniou, mia kamiu kumerou re kalo. Vite va nonovio na tomu nalo ajum̃a amila luklukuaio, p̃elina aber vavanio, mia amalmaluvo amei medave navo, ka tomu nonovio amijikia ajikiaio. ");
INSERT INTO bki_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A kamiu bunu, vite novo nalo napano nojom̃a neber ka kamiu ea burumelijo, kamiu monoka kuverialio bereio ea miamoiano, a vite nalo nam̃a kiniou nojom̃a nomijuvaluva kanio ea burutiliniemiu ga, monokanio kamiu kum̃adu ka bereio ea tomu nalo miralo, ka tomu nalo aviniu amijikia ajogio. ");
INSERT INTO bki_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kamiu kumerou re ka nalo na amijikia auetam̃aria mokotenemiu, bior napano nalo maka ajikia auetam̃aria niunumiu, mia monokanio kamiu kumerou ka ga Atua, napano naio mijikia rila lelan mokotenemiu vija niunumiu ea vio na jogvaiano. ");
INSERT INTO bki_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kuvialio, menu nalo napano sialo kirijako, nalo miroano laka, aju janea vio, mia ap̃iliṽili kanio puruveru telisu ga ka juo, mia ver nalo tai rijoru ea borotano, Karamemiu naio rijikiaio. ");
INSERT INTO bki_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A vijumiu nalo na pariparimiu nalo, nalo miroano laka bunu, mia Atua bulukuio nonovio abeve terakurano, naio mijikialo. ");
INSERT INTO bki_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Naruei, kamiu maka kuvijikia kumerou m̃ele, bior naio mial kamiu kubo loa kirijako nalo nei, mia naio rivitikar vatitig kamiu ka vite nonovio nalo ea kenemiu meuliano nalo.” ");
INSERT INTO bki_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ana Yesu berinavo “Toro napano riverial ea tomu nalo miralo, riverinavo naio be kiaku toro tai, toro na, mia kiniou bunu neverial ea Teta na joa vio mave mirano never toro na naio be kiaku. ");
INSERT INTO bki_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mia toro napano naio riverial naio ea tomu nalo miralo riverinavo naio maka ve kanaku, mia kiniou bunu neverial naio kamu ea Teta na joa vio mave neverinavo naio maka ve kanaku.” ");
INSERT INTO bki_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ana Yesu berinavo “Kamiu kuvisidomii re kuver kiniou nebinimei ka nala burum̃ara tum̃aro ve toru toa vio yetemeriba nei. Makanio, mia kiniou maka nemei ka nodu tum̃aro toaio, mia kiniou nebinimei bija iobogu na mira tai, napano mia tomu nalo ala baravo a ala mira rivior kiniou. ");
INSERT INTO bki_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mia kiniou nebinimei ka nala m̃eaku nalo atup̃e karam̃alo nalo, a merevono nalo atup̃e kenielo nalo, a tira m̃eaku nalo napano ajoro vonga, mia atup̃e kenielo simemi nalo. ");
INSERT INTO bki_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mia nalo nam̃a tiniel mimi toru julaka ka kiaku naiagagoano nalo, nina maka ve kulo dolu nalo, mia nalo na abe kialo m̃aratavo ga nalo.” ");
INSERT INTO bki_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ana na Yesu naio berinavo “Verenio toro tai na naio jidom kenieno toru laka, p̃elina karam̃ano, p̃elina kenerinio, tuvulu napano naio jidom kiniou, toro na naio maka rijikia rimei rive kiaku naiagagoano. ");
INSERT INTO bki_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo verenio toro tai rudu re kiano m̃akolkolo, ka takisor kiniou, tibe ka napano naio maka rijamo ka naio ka rijog rivova kar kiniou, toro na maka rijikia rimei rive kanaku naiagagoano. ");
INSERT INTO bki_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Verenio toro tai tom̃a sidom m̃elea kiano meuliano, toro na mia rilaluvu kiano meuliano. Mia verenio kiaku naiagagoano tai rilaluvu kiano meuliano bior naio be kiaku, mia naio mijikia rivokar meuliano napano maka rijikia ribisi.” ");
INSERT INTO bki_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ana na Yesu berenio, berinavo “Verenio toro tai rivuru kamiu kuva joomo ea kunuano, nina jibe ka ga napano naio buru kiniou ga naba joomo ea kunuano. A verenio toro tai rivuru kiniou nava joomo ea kunuano, nina jibe ka ga napano buru naio napano miila kiniou nebinimei, naio ba joomo ea kunuano. ");
INSERT INTO bki_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","A verenio toro tai rivuru naverialiano tai p̃elina toro na memedu tai tibe na rivan ea kunuano, bior naio mijikia ka toro nei naio be toro lu tai na Atua kiano im̃auano, mia naio rivokar mauo na ga napano mia Atua rivar van kiano tomu na tortoru nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kiniou neber vatitig ban kamiu, ka verenio toro tai rije baja na uei menini ga van kanaku naiagagoano tai, napano naio maka sidomii river naiagagoano na naio be toro na toru tai, p̃elina naio be toro kurano ga, mia toro nene rijev kiano mauo tai rivior vite novo napano naio milaio ban kanaku toro neibano.” ");
INSERT INTO bki_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Naruei bogo na Yesu mil batitig ban kiano naiagagoano nalo duelimo ba juo 12 nei bisi, ana naio jumolu den vio nei, naruei naio ban ka riverlogloglo a rioliolu vanlo ea komeli nalo na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kanio bogo nei, Jone Baruei joa yimo na tetavokoiano, a naio mijog lilianiano na im̃auano nalo napano Kristo jom̃a mim̃au kalo, naruei naio miila kiano naiagagoano tealo, ");
INSERT INTO bki_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","abano abika den Yesu, aberinavo “?Jum̃abe? ?Jau kobe toro na ajum̃a aberiio na nanua ruei aberinavo mia toro na toru tai naio rimei ka rivurim̃arabo ka kito, p̃elina jau maka kove toro nene kiana navo, ana monoka kumemi nuviturorea toro dolu bereio vo ka mia naio rimei?” ");
INSERT INTO bki_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Naruei Yesu berdop̃e banlo, berinavo “Kamiu kuvan bereio, kuvial Jone, ana kamiu kuverial vanio vite nalo napano kamiu kumial napano kiniou nomim̃aukalo ea vio nei, a vite nalo na kumijog aberii ban kamiu ea kiniou, jibe ka vite nalo napano Naverialiano Aisea beriio na nanua ruei, napano naio berinavo: ");
INSERT INTO bki_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Merebono nalo, ajirarag bereio ruei, a nalo napano abe jaba milalo a abe javuluku milalo, vonganei amiel bereio ruei, a nalo napano burumieni milalo, vonganei niabele binimei meravo bo nonovio bereio ruei, a nalo napano abe bulubau nalo, vonganei amijog vite bereio ruei, a nalo napano am̃arm̃aro, vonganei nalo amemeul bereio ruei, a nalo napano abe talim̃asa, vonganei kiniou nojom̃a neberial Lilianiano Vou banlo ruei.’ ");
INSERT INTO bki_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“A kamiu kuva kuver ka Jone bunu, kuver ‘Toro napano maka leleio kiano jidomiano riveve juo ea kiniou bogo tai, mia ilivuiano rimei van naio.’” ");
INSERT INTO bki_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bogo napano Jone Baruei kanano naiagagoano nalo ajumolu ka avan bereio, Yesu berii Jone nene ban tomu nalo, berinavo “?Bogo napano kamiu kubatavio ea vio yauo na beamu, kamiu kuban ka kuvial venia? !Maka ve tinieku ka kamiu kuban ka kuvial javiniu nalo napano jegi jom̃a buku biliviliglo janea vio julaka ga! ");
INSERT INTO bki_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A kiniou maka ve tinieku bunu ka kamiu kuban ka kuvial toro na toru tai napano naio miya kuluniabele maraiu, bior tomu na jibe na nalo maka ajikia atua vio na miagiago jibe ka vio yauo kurano ga na, mia nalo bogo nonovio ajua yimo novo na tubo na toru kunuano. ");
INSERT INTO bki_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Makanio, mia kiniou neber p̃eli kamiu kuban ka kuvial naverialiano tai, a? Mo nina bo ga, mia kiniou neber ka kamiu, neberinavo toro napano kamiu kumitumolu ka kuva kuvial naio, naio toru lie, juvulu naverialiano re nua nalo, ");
INSERT INTO bki_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","bior Atua naio berii Jone nene ea kiano Iliano Lu ruei, naio berinavo ‘Kiniou nemiila kanaku naverialiano jukamu kaso, ka naio rila vatitig kanamo m̃arabo.’ ");
INSERT INTO bki_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Riano, kiniou neber ka kamiu, neberinavo ea vio yetemeriba nei, Jone Baruei naio jo mave loa tomu dolu nalo abiniu. Mia nalo aviniu napano mia amei joomo ea navenatuboiano na Atua kiano, riva rivokar toro na maariano kalo nana jotano laka garuei, nalo na naruei aviniu atu mave loa Jone, ka mia nalo avar ilivuiano na Atua kiano tuvulu Jone. ");
INSERT INTO bki_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jikario ea bogo napano Jone Baruei jikar ka m̃a mioliolu, binimei bokar banei, tomu nalo ajum̃a amilidie navenatuboiano na Atua kiano, a uolu kouo na mira nalo bunu ajumolu m̃a amila vio ka atuvulio. ");
INSERT INTO bki_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Be bogo binimei bokario bogo na Jone, naverialiano nalo a Mosis kiano tuboiano napano naio jirilo, aberial vite telabo napano mia amijikia ayotuba iorou. ");
INSERT INTO bki_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A verenio kamiu kumisaaro ka kumonea vite nalo nei napano mia ayotuba iorou, mia kamiu kumijikia kuvitilubar ka kuver Jone Baruei naio be Elaija na nanua aberkario nua ruei ka mia naio rimei bereio. ");
INSERT INTO bki_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A verenio be tiliniemiu, bo ka kuviagago vatitig ka kiaku iliano nei.” ");
INSERT INTO bki_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","19","Ana na Yesu mil lie vo, berinavo “?Mia kiniou nemijikia never iliano vaio ka mia rivokar bajago na tomu na vonganei? Ea m̃arabo nonovio napano Atua milaio ka rila von ka mia rivu ka kamiu, mia kamiu maka lele kuvisidomio, kamiu kumitu bereio m̃a kumil niegeniege naio biorio. Bior bogo napano Jone naio jo, naio jom̃a mondulu ka sinaniano ka tom̃a rivolkouo, a naio jo bel bunu ka m̃arjum̃elm̃elu, ana tomu nalo amialio jibe na, ana nalo amiila naio, aber ‘Tete na niadu jua naio.’ Mia bogo napano Kulorinio Kenerinio naio binimei jo, naio jinan batitigio a naio munu batitigio, ana nalo amil ea naio, aber ‘Kuvialio vo, toro na naio be toro na jinan m̃ele, a miokovo ka sinaniano julaka, a naio be toro na munu m̃elea m̃arjum̃elm̃elu, a naio be toro tai napano kiano bilbilu nalo abe tomu na abarbijii takis a tomu na bova ga nalo.’ “Ka tenene, kiniou nemial kamiu tomu na vio banei, napano kamiu kuvitibe ka kiritete nalo napano ver ajum̃a ajerjere ea vio medave na komeli, mia nalo atu aviovio van kialo bilbilu sesa nalo, aver ‘!Oi, kamiu kubova ga! Verenio kumemi numitu numue bulaiu, mia kamiu maka kuvisidom kuvolu vija kumemi, a verenio numiou ka iou na m̃ariano, mia kamiu maka kuvisidom kuviteg vija kumemi.’ “Mia vite nonovio napano amalmaluvo ea Atua kiano masouano, beamu tomu telabo amilikue keanio, mia iorou ana mia naio rila rimeravo ka masouano nei keano, naio memedu ga a be riano laka.” ");
INSERT INTO bki_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Naruei Yesu mil berkakar ban tomu nalo na ea komeli nalo napano naio mim̃auka burutomoluo telabo kalo, bior nalo amial kiano vite nalo nei, mia nalo maka leleio aviliglo. ");
INSERT INTO bki_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Naio berenio “!Kulo Koresin nalo, naliko kulo Betsaeta nalo, kamiu kumila lelan kamiu toru laka! Verenio kulo Taia naliko kulo Saiton nanua aial burutomoluo nalo nei napano kamiu kumialio nei ruei, mia nalo aviliglo nua ruei. Nalo maka ave kulo Ju, mia aya kuluniabelo na be m̃adati a mia nalo avisivisii bulum̃aroro ea pariparilo ruei, ka tomu nalo avitilubario ka nalo amijog bova riano bior kialo kariano nalo. ");
INSERT INTO bki_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kiniou neber ka kamiu memedu, ea bogo na tibureiano, mia kenemiu vironiano tovulu nana ve kialo. ");
INSERT INTO bki_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“!A kamiu kulo Kapeneam, napano m̃a kumitum̃a kubarvar ka kamiu, a kumisidom kuvitu mave laka, mia kamiu kuvitikar kamiu! Mia Atua naio rivuku kamiu kuvatove laka ea bulukusebi. A verenio kulo Sotomo nalo aial burutomoluo nalo napano kamiu kumialio nei, mia p̃eli aviliglo ka mia burum̃ara sebi na vio mave maka rijikia sisen kialo vio rivakovio. Mia kamiu kumial burutomoluo nalo nei ruei, mia kamiu maka kuvilig kamiu leleio vo. ");
INSERT INTO bki_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tenene na kiniou neber ka kamiu, ka bogo na tibureiano, mia Atua tinien riialo tovulu kamiu.” ");
INSERT INTO bki_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mia ka bogo nei, Yesu bolkouo, ber “!Teta o, Tubo na vio mave, a Tubo na yetemeriba! Neber siva banso, bior jau koberloglog vite nalo napano ea kiniou, ban nalo napano kialo jidomiano jibe ka kiritete nalo ga, mia nalo napano ajidom ka abe masou laka, bija nalo napano ajidom aber amijikia vite, mia jau komilavan vite nalo nei kalo. ");
INSERT INTO bki_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Riano, Teta, ninei javukia ga nana jau kojidomio.” ");
INSERT INTO bki_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Karina Yesu ber bunu, berinavo “Karam̃aku juvan vite nonovio jua jum̃aku ruei. Mia Karam̃aku, naio ga takurano mijikia batitig kiniou, mia kiniou nei napano nebe kenerinio, kiniou ga takurano napano nemijikia batitig naio. Kiniou kumemliko nalo napano nebijauialo ka nesiloglog Karam̃aku kalo ka avarkar tinielo ea naio, kumemi nene naruei numijikia batitig naio napano be karamememi.” ");
INSERT INTO bki_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ana Yesu berii bunu, berinavo “Kamiu nonovio napano tiniemiu maro m̃ele bior kamiu kumitum̃a kubar de kenemiu bagaro nalo na teremi ea kenemiu meuliano, bo ka kamiu kumei, kamiu kumei ea kiniou, ka mia kiniou nemijikia nejev jilimebiano van kamiu. ");
INSERT INTO bki_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kamiu kuvudu kiaku iliano nalo tibe ka vuu tai na kenemiu meuliano, a kamiu kuvudu kanaku bajago nalo, bior kiniou nebe toro na momavo ga, kanaku jidomiano batove. Tibe na, mia kamiu kuvileal ka kenemiu jidomiano nalo ajilimebi, ");
INSERT INTO bki_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","bior kanaku verloglogiano nalo, nalo amonm̃ai ga a amelala ga, a vite nalo napano mia kiniou navar van kamiu ka mia kuvario, mia ve temi laka re ka kamiu.” ");
INSERT INTO bki_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Naruei ka bogoti dolu bereio napano be Legiano Lu, Yesu naliko kiano naiagagoano nalo amiel abano, mia kialo m̃arabo jel iviso bure tiniavio na m̃arauiti. Nalo ajum̃a amiel jibe na, naruei kiano naiagagoano nalo jijerlo, ana amikiti kokorov m̃arati uiti nalo tealo ka asenio. ");
INSERT INTO bki_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nalo ajum̃a amila jibe na, naruei Varisis nalo tai ajua vio na, aju amial Yesu nalo, naruei nalo amil ban Yesu, aberinavo “!Ei, jau keialio! Kiamo naiagagoano nalo ajum̃a abar sinaniano ea tiniavio jibe na, ajum̃a amila im̃auano ea Legiano Lu, ana verenio amila jibe na, nalo ajum̃a amila korov kiado tuboiano.” ");
INSERT INTO bki_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ana Yesu berdop̃elo, naio berinavo “?Jibe na kovio, p̃elina maka kamiu kuvuluku kovio ea Iliano Lu bogo tai, ea vite nalo napano Parinio Tubo Teviti re nua milaio, a? Naio naliko kiano tomu nalo jijerlo toru, ");
INSERT INTO bki_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","naruei naio ba joomo ea Atua kiano Tobobo Lu, naio midu joko lu na tuboiano berenio kulo lu nalo ga amijikia asenio, mia Teviti nalo bunu ajenio. ");
INSERT INTO bki_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Jibe na kovio, p̃elina kamiu maka kuvuluku bunu ea Tuboiano na Mosis kiano, napano ea Legiano Lu nalo, kulo lu nalo monokanio ava joomo ea yimo lu na Atua kiano, ka nalo ala kialo im̃auano eaio? Jibe na, nalo ajum̃a amila korov tuboiano na berbure ber toro maka rijikia rim̃au ka Legiano Lu, mia Atua naio maka sidomialio tena river nina be tena bova tai. ");
INSERT INTO bki_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kiniou neber ka kamiu, neberinavo be navenatuboiano vou tai jo vonganei, napano naio jo mave laka jovulu tuboiano na Atua Kunuano Lu, ");
INSERT INTO bki_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","mia naio jibe ka napano ea Iliano Lu, napano Atua naio berenio, berinavo ‘Kiniou maka nesidomii kenemiu sida nalo, mia kiniou nejidomii ga bajago na tinieiaiano.’ ?P̃elina kamiu maka kuvijikia nioti na iliano na navo? A verenio kamiu kumijikia ruei, mia kamiu kuvitu re kuvitibure searo ea kanaku naiagagoano nalo nei napano maka ala titai na bova. ");
INSERT INTO bki_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kulorinio Kenerinio, naio naruei naio be tubo na Legiano Lu.” ");
INSERT INTO bki_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Naruei Yesu naio juvan vio na, naio miel bano, ana na naio ba joomo ea kialo yimo na volkouano tai. ");
INSERT INTO bki_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ea vio na, toro tai naio jo na, naio be jumekirikokouro, a tomu tai bunu aju ajidom aleal torokoriano tai ea Yesu verenio naio rila vite rimemedu re. Naruei tomu nalo nei abika Yesu, aberinavo “?Jum̃abe, kiado tuboiano berbure im̃auano ka ala batitig mokotenano toro ka Legiano Lu, p̃elina naio maka riverbureio? !Jau kover von vite na!” ");
INSERT INTO bki_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naruei Yesu berdop̃e, berinavo “?A verenio toro tai kiano nunu tai, mia nunu nene ga rijoru ea p̃ili tai ea Legiano Lu, kuberiam̃a mia toro nei maka rijikia riva rivuru lario bereio? !Nao, mia kito nonovio monokanio rala tibe na van kiado temeul nalo! ");
INSERT INTO bki_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","A verenio memedu jibe na ea kiado tuboiano ka kito rajai nunu ea Legiano Lu, jibe na kito romijikia rala im̃auano ka rajai toro ea Legiano Lu bunu, bior toro naio bo loa nunu.” ");
INSERT INTO bki_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Naruei Yesu ber ka toro na be jumekirikokouro, berinavo “Kovitirii jum̃amo rimemedu.” Naruei naio mila jibe ka napano Yesu naio berenio, ana na naio jum̃ano binimei bo bereio, javukia jum̃ano tinene. ");
INSERT INTO bki_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ana na Varisis nalo napano aju ea bogo nei amijoku, naruei nalo abatavio, ka averii tum̃abe naruei ka mia amijikia auebin Yesu rim̃aro. ");
INSERT INTO bki_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mia Yesu naio mijikia ka Varisis nalo ajidom aue naio, naruei naio juvan vio nei, naio naliko tomu telabo napano ajakisorio. Naruei naio jo milarur tomu nalo na amie, ");
INSERT INTO bki_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","mia naio mil jikili banlo, naio berburelo ka ava averii re naio van kulo dolu nalo. ");
INSERT INTO bki_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Naio mila jibe na ka mia Atua kiano iliano tai mijikia rimei rive riano, napano Naverialiano Aisea berialio nua, a iliano nei naio ber jibe nei, berinavo ");
INSERT INTO bki_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nina be toro napano mim̃au kanaku, napano kiniou nebijauialar naio. Kiniou nejidom m̃elea naio bo laka, a kanaku jidomiano jaaro toru kanio. Mia kiniou nodu Niunuku toa naio, ka mia naio riverial bajago nalo napano memedu van tomu nonovio nalo na yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mia naio maka rivukuju van toro, naio maka vijago m̃ele, mia naio maka rijikia rivuku iliano ve telabo ea vio medave. ");
INSERT INTO bki_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mia naio maka rijikia telar javiniu napano burukorovio jaklele ruei jo, a naio maka rijikia rijukon bin yulu na volvolkouo ka rim̃aro. Mia naio rim̃au tibe na rivanvano-o rivokar napano bajago na memedu naio tumolu sikili tu tovulu bajago na bova. ");
INSERT INTO bki_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","A mia tomu nalo nonovio na yetemeriba nei, mia nalo avarkar tinielo ea naio sikili ka mia naio rilarurlo.” ");
INSERT INTO bki_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Naruei tomu nalo aburu toro tai napano niadu ban ea naio, naio binimei ea Yesu. Niadu nene mila naio mirano bono, a naio be buru bunu, mia Yesu naio mila batitig mirano a tiniajono abinimei abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Naruei nalo napano amial vite nalo nei amiilo toru, amemebiju kanio, ana na aberinavo “!Uerei! ?Tete na naio be Teviti kenerinio nam̃a roju rorea naio kovio, p̃elina makanio?” ");
INSERT INTO bki_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mia bogo na Varisis nalo amijog tomu nalo kialo iliano nei, mia nalo amijoku toru, nalo aberenio “Toro na jitig bulag niadu nalo ea ga moroano napano sim̃aro nalo kialo tubo napano siano Belsabel, mijamo ka ban naio.” ");
INSERT INTO bki_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mia Yesu naio mijikia kialo jidomiano, ana naio ber kalo, berinavo “A verenio tubo tai, kiano tomu nalo avuruburelo, napano togio nene ail die togio nene, mia tubo nene kanano im̃auano nalo monoka mia atibirbili; a verenio komeli tai, p̃elina m̃aratavo tai, tomu nene nalo avuruburelo, ka togio ajidom ajil bulag togio nene, mia tomu nalo nei maka ajikia atu rivu bogo tai. ");
INSERT INTO bki_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","?A jibe na bunu, verenio Setano kanano tava nalo tealo atu ajil bulag nalo togio dolu, nina berial ka nalo aburuburelo ruei, ana na mia navenatuboiano na Setano kanano naio sikili tu tum̃abe? ");
INSERT INTO bki_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","!Mia kamiu kumitum̃a kuberenio kuber jibe na naruei, kuberenio kiniou nojom̃a nemijil bulag niadu dolu nalo ea moroano na burum̃ara sim̃aro napano Belsabel, mia maka rijikia tibe na leleio garuei! ?Mia verenio tibe ka napano kamiu kuberenio, jum̃abe naruei ana kamiu tealo bunu ajum̃a amijil bulag niadu? ?Kei mijamo ka moroano na jibe na banlo, p̃eli Setano bunu koviobo? Bo ka verenio kenemiu naiagagoano napano ajum̃a amijil bulag niadu, ajog kenemiu iliano na. ");
INSERT INTO bki_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ana makanio, kamiu kuber maka rimemedu ga. Kiniou nojom̃a nejitig bulag niadu ea moroano na Atua kiano Niununo ga, mia tenei berial ber Navenatuboiano na Atua kiano ju iviso bure kamiu ruei. ");
INSERT INTO bki_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“!Kuvijiio! Verenio toro tai sidom riva joomo ea toro kouo tai kunuano ka mia naio rivina ka kanano saba nalo, mia naio monokanio rivar teli riorkar toro nene sikili beamu vo, avona bisi, ana na mo naio mijikia riva joomo ka rivina ka nonovio saba nalo na kanano. Mia kiniou nojom̃a nomila jibe na naruei ka toro kouo napano Setano. ");
INSERT INTO bki_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Toro napano maka takisor kiniou, naio jo berbure kiniou, a toro napano maka rim̃au vija kiniou ka nuvuru kiaku tomu nalo amei vio takurano, naio jom̃a mijil dedade ealo abeve terakurano. ");
INSERT INTO bki_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Jibe na naruei, kiniou neber ka kamiu, kariano nalo bija ilivovaiano nalo, a iliano napano mila bulag Kulorinio Kenerinio, mia Atua naio mijikia riviekokoa toro riviorio, mia toro napano naio ril rivova ka Niununo Lu, riverenio kiano im̃auano nalo be Setano ga mim̃aukanio, toro na jibe na, Atua naio maka rijikia riviekokoa naio bogo tai, ea bogo nei a ea bogo dolu napano mia rimei.” ");
INSERT INTO bki_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","A Yesu naio ber bunu, berinavo “Kito romijikia rovitilubar buruiesi nalo ea salo m̃arati napano abarlo. Buruiesi napano miluo bo, bar m̃arati na bo, mia buruiesi napano miluo bova, naio bar m̃arati napano bova. ");
INSERT INTO bki_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mia ea meuliano na toro kiano jibe na bunu, napano kiano iviso jibe kanio burupati tai, a iliano nalo napano amolmoluo ea kiano meuliano ajibe ka m̃arati nalo napano amolmoluo ea burupati nei. ?Mia kiniou nemial kenemiu burupati nalo amenunu ruei, mia tum̃abe ana m̃arati na bo tai mijikia rimoluo ea kenemiu iliano nalo? !Kamiu kube bajulukuti na maro nalo ga! ");
INSERT INTO bki_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Toro napano bo, naio barbijii vite na bo nalo jua kiano iviso, naruei bogo nonovio kiano jidomiano na bo naio jo, napano naio mijikia sian bulagio, mia toro na bova, naio jo barbijii vite nalo na bova jua kiano iviso, naruei naio maka rijikia sian bulag jidomiano na bo bogo tai. ");
INSERT INTO bki_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mia kiniou nejidom kamiu kuvijikia ka ea bogo na tibureiano, mia tomu nalo nonovio monokanio ala kialo veriiano ea kialo ilivovaiano nonovio veve terakurano napano ajum̃a aberenio ea kialo meuliano nalo, ");
INSERT INTO bki_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","bior mia Atua naio tibure kanamo meuliano rivior kanamo iliano nalo. Nina bior kanamo iliano nalo amijikia alaso komeul, p̃elina mia alaso kovokar vironiano.” ");
INSERT INTO bki_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ana tomu na verloglogiano na tuboiano, naliko Varisis nalo tai aber ka Yesu, aberinavo “Ei, jau napano abioso ka Naverloglogiano, kumemi numisidom ka jau kala vremesiano tai van kumemi ka mia nuvial kanamo moroano.” ");
INSERT INTO bki_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mia Yesu naio berdop̃e banlo, berinavo “Tomu nalo napano ajidom aial ga vremesiano nalo, abe kulo va nalo, nalo amila kodovo ban Atua jibe ka nalo napano m̃a amila siakaiano. Makanio, mia kamiu kuvial re vremesiano tai, mia vremesiano na Naverialiano Jona ga nanua, nina ga mia kamiu kuvialio. ");
INSERT INTO bki_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona nene naio jo joomo ea burum̃ara keniene kelijumdumu na toru tai mabono ka legiano tolu a bogiano tolu, naruei mia tibe na bunu ea Kulorinio Kenerinio, napano mia naio toa bulum̃abono borotano ka legiano ve tolu a bogiano ve tolu. ");
INSERT INTO bki_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Naruei nalo na vio Nineva re nua, amijog Jona kanano iliano, mia nalo abiliglo, a mia nalo na atumolu atu ea legiano na tibureiano, ka mia averilubarbar kenemiu torokoriano nalo, bior be toro tai napano naio loa ka Jona naio jo bija kamiu vonganei, mia kamiu maka kuvilig kamiu leleio vo. ");
INSERT INTO bki_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Nanua bunu be tira na toru tai napano naio be parinio tubo napano juvan kiano buruvenuo koalabo laka, naio batove binimei ka rijog tormoruo Parinio Tubo Solomon kiano ilimasosouano nalo. Naruei mia tira na toru nei bunu, mia naio tumolu tu ea legiano na tibureiano, naio riverlubarbar kenemiu torokoriano nalo, bior toro tai napano naio be masou loa ka Solomon naio jo bija kamiu vonganei, mia kamiu maka kuvisidom naio leleio.” ");
INSERT INTO bki_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Karina Yesu ber bunu, berinavo “Bogo tai, napano ver ajitiglar niadu ea toro, niadu nene naio mijikia riva yeturu, sirago ka buluvio na mia naio rijilmebi eaio. Mia ver naio maka rijikia rilealio, ");
INSERT INTO bki_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mia naio river ‘Ee, bo ka mia kiniou naiadu ka bereio kunuaku moruo na beamu vo.’ Naruei, bogo napano naio rimei bereio mia naio rial yimo nei beteauo, a mila kon a meravo bo, a amila batitig saba nene nalo memedu ruei ju. ");
INSERT INTO bki_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Naruei naio mijikia riva rivuru bereio niadu dolu nalo ve aluo napano abova laka loa naio, amei vija naio, ka mia amijikia ava joomo bereio atua toro nei. Mia toro nei nua kiano meuliano bova, mia iorou kanio kiano meuliano rivova lie vo. A mia tibe na ga bunu ea meuliano na tomu na bova nalo ea bogo nei.” ");
INSERT INTO bki_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Bogo na Yesu jom̃a mil kia ga vo bija tomu nalo nei, kenieno naliko kuruano nalo abinimei aboru ea vio nei, nalo ajikili aju tavio, ajidom ail vanio. ");
INSERT INTO bki_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mia nalo nei tai berial ka Yesu, berinavo “Oi, koniomo naliko kuruamo nalo ajikili aju tavio, amilavio ka ail vanso kija beamu vo.” ");
INSERT INTO bki_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mia Yesu naio miolu berdop̃elo, berinavo “?A konioku be kei, a kuruaku nalo abe kei?” ");
INSERT INTO bki_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana naio jiloglog kiano naiagagoano nalo, naio berinavo “?Kumial nalo na aju na? Konioku a kuruaku nalo, nalo nei aju nei! ");
INSERT INTO bki_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bior ver toro napano rila tavukia napano Teta na vio mave naio jidomio, toro na jibe na naio be kuruaku, p̃eli kuvivinioku, p̃eli konioku.” ");
INSERT INTO bki_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka legiano nene, Yesu jaluvo den vonuo, ba jotano koyou ea baramudou na ueiyabo na toru ka to riverloglog tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mia tiniobi toru abinimei ka naio ka bogo na, mila ana naio bavin ea uako tai, jotano eaio, mia tiniobi toru nei nalo aju bin baramudou aju, ");
INSERT INTO bki_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ana naio jo berloglog vite telabo kalo ea jamerijiano nalo. Ana naio berii kalo, berenio “Kuvijiio toro tai napano ban ka rivisivisii kurukuti ea kiano tiniavio. ");
INSERT INTO bki_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Telikiti napano naio jom̃a bisivisii kurukuti nalo nei, tealo ajibiribil ea m̃arabo, ana iorou kanio, menu nalo abinimei amikiti bulagio nonovio. ");
INSERT INTO bki_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A kurukuti tealo ajibiribil ea vio na be tabap̃ilio yetano kanio, mia maka sano tano nene rimerorolu. Mia abitovtov sop̃eli, bior salo tano menivinivi ga. ");
INSERT INTO bki_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ana bogo napano m̃erenio mijivi nieja jikili nieje salo toti nalo, vaarakurano ga amekekeu, bior maka ve salo bati ka avatove batitigio vo. ");
INSERT INTO bki_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mia kurukuti tealo ajibiribil ea vio napano beamu maka atekono vatitig teli va nalo eaio, mia iorou kanio, ana teli va nei naio miluo bereio toru, ana mueko miralo-o ana na nalo am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mia kurukuti dolu nalo bereio ajibiribil ea tano na bo tai, naruei nalo amiluo, ajakou abar m̃arati nalo, napano tealo abar duelimo toromomou 100, tealo abar duelimo va ari 60, a tealo abar duelimo va rolu 30.” ");
INSERT INTO bki_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ana na Yesu ber kalo, berinavo “Toro napano be tiliniene monokanio naio riiagago vatitig ka iliano nei.” ");
INSERT INTO bki_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Mia iorou kanio, ana na Yesu kiano naiagagoano nalo abinimei abika den naio, aberinavo “?Bior vaio ana jau kojom̃a koberloglog tomu nalo jel ea jamerijiano jibe na?” ");
INSERT INTO bki_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naruei Yesu berdop̃e banlo, berinavo “Atua mila jibe na ka mia kamiu kuvijikia kuvileal m̃ajig na navenatuboiano na kiano, mia naio maka jian jikiaiano nei van kulo dolu nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kiniou neber jibe nei ka kamiu, ka toro napano verenio be kiano saba ruei, mia naio rijev tabunu bere vo ka mia ve miroano, mia toro napano maka ve kanano saba tai, mia naio rila deven vite vaio na telisu napano be kiano ruei. ");
INSERT INTO bki_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tenene na kiniou nojom̃a neberlogloglo ea jamerijiano, bior aju amial vite, mia maka lele avitilubario, a ajum̃a amiagago, mia maka lele ajoglubarbario. ");
INSERT INTO bki_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tomu nalo na jibe nei naruei, nalo nam̃a Atua beriilo nanua ruei, ea ilirianiano napano Naverialiano Aisea naio berialio, berinavo ‘Mia kamiu kuvijogio rivano-o, mia kamiu maka leleio kuvijikia kuvijoglubarbario bogo tai. Mia kamiu kuvialio rivano-o, mia maka leleio kuvijikia kuvitilubarbario bogo tai, ");
INSERT INTO bki_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","bior kamiu kumitibe ka tomu nalo napano kialo jidomiano nalo am̃arm̃aro, jibe ka napano ajinioko tilinielo nalo, a ajetavoko miralo nalo ruei. Verenio nalo ala re tibe na, p̃eli mia miralo rivitii dulu vite, p̃elina tilinielo rijoglubarbar vite, a p̃eli kialo jidomiano rijoglubarbar vite, ana tibe na ana amijikia aviliglo amei ka kiniou ka mia kiniou noim̃au ka vatitiglo.’ ");
INSERT INTO bki_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kiniou neber ka kamiu, kanaku naiagagoano nalo, ilivuiano joa kamiu, bior miremiu nalo aju amial vite nalo napano kamiu kumialio, a tiliniemiu nalo amijog vite nalo napano kiniou nojom̃a neberloglogio ka kamiu. ");
INSERT INTO bki_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Naverialiano nalo telabo bija Atua kiano tomu nalo nanua, nalo ajidom toru ka aial vite nalo napano kamiu kumialio vonganei, mia maka lele aialio, mia nalo amila vio toru ka ajog venia na kamiu kumijogio vonganei, mia nalo maka ajog vite nalo nei tai leleio.” ");
INSERT INTO bki_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mia Yesu mil banlo, berinavo “Mo, kamiu kuviagago vatitig ka kuvijog nioti na jamerijiano na toro napano ban ka rivisivisii kurukuti ea kiano tiniavio. ");
INSERT INTO bki_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Vite na jukamu, be kurukuti na jibiribil ea m̃arabo, nina javukia napano tomu nalo na amijog Ioluano Vou na navenatuboiano nei, mia nalo maka ajoglubario. Kurukuti novo nalo na ajibiribil ea kialo jidomiano nalo, mia toro va nei Sim̃aro naio binimei ana naio bar bulag Ioluano Vou nei bereio den kialo iviso. ");
INSERT INTO bki_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Kurukuti dolu tealo nalo, ajibiribil ea vio na be tabap̃ilio yetano napano tano nene menivinivi ga, nina javukia napano tomu nalo na amijog Ioluano Vou nei, mia nalo ajaaro sop̃eli ga kanio, ");
INSERT INTO bki_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mia jibe ka maka ve salo pati tai. Amijikia atu ka bogo ve bulati ga, mia verenio bogo na jikili rimei, p̃elina tomu nalo ajilo kar amonea Atua kiano iliano, mia vaarakurano ga nalo ajoru bereio. ");
INSERT INTO bki_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Dolu bunu, nina be kurukuti na jibiribil ea vio na teli va juaio, mia nina jibe ka napano tomu nalo amijog Ioluano Vou nei, mia nalo ajidom m̃elea kialo meuliano, a tinieljii saba nalo na yetemeriba nei toru laka. Bajago nalo na jibe nei jibe ka teli va, ana nalo abivibin Ioluano Vou nei ka mia naio rivar re m̃arati ea kialo meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Mia na maariano nene, naio be kurukuti na jibiribil ea borotano na bo, ninei javukia napano tomu nalo na amiagago ka Ioluano Vou nei, mia nalo amijoglubarbario, naruei ajakou abar m̃arati na Ioluano Vou nei ea kialo meuliano nalo, napano mia tai atakou avar m̃arati rivokar duelimo va rolu 30, mia tealo atakou avar m̃arati ve duelimo va ari 60, mia tealo atakou avar ve telabo, tibe ka m̃arati ve duelimo toromomou 100.” ");
INSERT INTO bki_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Naruei Yesu berii jamerijiano dolu banlo, berinavo “Bajago napano Atua buru tomu nalo abinimei jouro ea kiano navenatuboiano nene jibe nei. Toro na toru tai napano naio ba bisivisii kurukuti uiti na bo ea kanano tiniavio, ");
INSERT INTO bki_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","mia bogo napano tomu nalo amonomel bogiano, ana kiano uolu tai binimei, bisivisii kurukuti soro na bova ea tiniavio nei bunu, karina naio buro ban bereio. ");
INSERT INTO bki_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Naruei kurukuti vite juo nei amiluo biju vaarakurano, abe verare ga, mia bogo na ga uiti nalo ajikar ka ajakou, mia tomu nalo na toro na toru nei kiano nalo abitilubar ka soro na bova bunu miluo biju bija uiti nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ana na nalo abinimei amial naio, abika denio, aberinavo ‘?Boru, jum̃abe? Kurukuti nalo napano romebijalo ea kanamo tiniavio, nalo abe kurukuti na bo ga. ?Mia soro va nei naio binimei jum̃abe?’ ");
INSERT INTO bki_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ana na naio berii kalo, berinavo ‘Makanio, nina kiaku uolu tai napano naio mila vite na jibe nei.’ “Naruei kiano tomu nalo abalea naio bereio, aberinavo ‘?Mo, ana mia tum̃abe, jau kojidom nuva nuvuru bulag soro va nalo nene?’ ");
INSERT INTO bki_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mia naio berburelo, berinavo ‘Makanio, atubo beamu vo. ?Verenio kamiu kuva kuvuru bulag soro va na, p̃eli mia kamiu kumijikia kuvuru bulag belea uiti bunu, ve juo vaarakurano koviobo? ");
INSERT INTO bki_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mia nalo amijikia ave juo ailuo biju vio takurano riva rivokar bogo napano avarbijii uiti m̃arati rimei joomo. Ka bogo na, mia kiniou nemijikia never ka tomu nalo avan ka ate uiti nalo, mia ate bulag soro va nalo nene beamu, aiorkakarlo ve bagaro ka mia avukulo rivan ea sebi. Iorou kanio, ana mo amijikia ava ate uiti nalo ka avario rimei vonuo.’” ");
INSERT INTO bki_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Naruei Yesu naio berial jamerijiano dolu tai bereio banlo, berinavo “Navenatuboiano na vio mave naio javukia kurukuti m̃arabako napano naio mijoru balea buruiesi. ");
INSERT INTO bki_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mia kurukuti nene naio kiritavaso leleio ga, mia bogo napano naio pitov mia naio binimei be buruiesi na burutomoruo tai, juvulu buruiesi dolu nalo, naruei menu nalo amue m̃alo niuku nalo ea sano jaati nene nalo.” ");
INSERT INTO bki_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Mia Yesu berial jamerijiano dolu bereio kalo, berinavo “Navenatuboiano napano Atua kiano, naio javukia tira tai napano mim̃auka isi na telisu ga bija burum̃ara baju na yevi, mia isi na telisu neibano naio miyuku joko nalo nei biniu tortoru.” ");
INSERT INTO bki_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ea Yesu kanano iliano nalo nei, naio ber bulag vite nalo jibe na ban tomu nalo, mia va telabo napano naio mil ea jamerijiano banlo. ");
INSERT INTO bki_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jibe na, ana mila naverialiano nanua kanano iliano be riano, napano Atua ber “Mia kiniou neverial kanaku iliano nalo ea ga jamerijiano, mia kiniou neverial saba nalo napano ajuluku koalabo laka nua ruei aju nunu kia ga vo, jikar ka bogo na nejii yetemeriba, binimei bokar banei.” ");
INSERT INTO bki_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Karina Yesu juvan tiniobi, ana naio ba joomo ea yimo, naruei kiano naiagagoano nalo abinimei kean naio, abika denio, aberinavo “?Aiou koig, kumemi numisidom kovisi nioti na jamerijiano na soro va na miluo ea tiniavio na uiti nei?” ");
INSERT INTO bki_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ana Yesu naio berdop̃elo, berinavo “Toro na toru napano bisivisii kurukuti na bo, naio be Kulorinio Kenerinio. ");
INSERT INTO bki_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mia kanano tiniavio nene, naio be yetemeriba nei. A kurukuti na bo nalo nei, nalo abe tomu nalo napano aju jouro ea navenatuboiano na Atua kanano. Mia soro va nalo nei nalo abe Sim̃aro kanano tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A uolu napano bisivisii kurukuti soro va nei, nina naio be Sim̃aro ga. A bogo na avarbijii m̃arati uiti, nina naio be bogo na tagap̃iano. A tomu nalo na im̃auano nei napano avan ka ate bijii m̃arati uiti nalo nei, nina naio be nailiano nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A im̃auano na ayobijii soro va karina aisebilo, nina bajago napano mia rimei ea bogo na maaro, ");
INSERT INTO bki_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","napano mia Kulorinio Kenerinio, naio riila kiano nailiano nalo ka avan ka avar bulag vite nalo napano amila toro mijoru ea kariano, vija tomu nalo na amila bijuku vovaiano nalo, ka mia nalo ajikia atu re bunu naliko tomu nalo na kiano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mia nailiano nalo avukulo avan ea sebi na toru, ea vio napano tomu nalo ajum̃a ajegi eaio, a ajum̃a ajer m̃arjuvolo nalo eaio. ");
INSERT INTO bki_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mia iorou kanio, ana tomu na memedu nalo atu jouro ea Karam̃alo kiano navenatuboiano, mia nalo nei amerera atavukia m̃erenio. A toro napano be tiliniene, bo ka naio riagago vatitig ka iliano nei.” ");
INSERT INTO bki_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mia Yesu naio berinavo “Bajago na ver toro napano jidom riva jouro ea navenatuboiano na Atua kiano, jibe ka jamerijiano nei: toro tai ba mial borotano tai, mia naio miilo ka burum̃ara puruveru novo tai napano jovorvoru ga eaio. Naruei naio jivin vanio lie ka puruveru nei bereio, mia naio ba p̃iliṽili bulag ka nonovio kanano saba nalo biniu, ka mia naio mijikia rivulular borotano nei, bior naio mijog bo toru laka ka tonovo napano naio milealio.” ");
INSERT INTO bki_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mia Yesu berii bunu, berinavo “Mia bereio, bajago na toro napano jidom riva jouro ea navenatuboiano na Atua kiano, javukia bunu: toro tai, napano naio jom̃a bulu basabebe novo nalo den tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mia bogo tai ana naio mileal tai napano bo, ana naio berinavo ‘Riano ga na, kiniou tinieku jii vite nei toru laka. !Verenio kiniou nemijikia nodu ve kiaku garuei! Mia monoka kiniou nava noṽiliṽili bulag ka kanaku saba dolu nalo nonovio, ka mia kiniou nemijikia nemei novulu vite novo nei.’” ");
INSERT INTO bki_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ana Yesu naio ber bereio, berinavo “Mia bereio, bajago na Atua kiano ka rivuru tomu nalo ava jouro ea kiano navenatuboiano, naio javukia bunu, napano bogo na tomu nalo ajuvarvan levlevi ea ueiyabo, ana amijikia avuru ko niado kinkin nalo ve telabo eaio. ");
INSERT INTO bki_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ana bogo napano levlevi bujo vatitig bo, mia tomu nalo aburio bauro, naruei nalo ajaburuburu, abarburevure niado nene nalo. Ana niado nalo na bo, amisonlo aban ea kanalo basaro nalo, mia niado na bova nalo, nalo abuku lo abano. ");
INSERT INTO bki_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mia nina rimei tibe na ea bogo na maaro, mia nailiano nalo ava alaburevure tomu nalo, avuru bulag tomu na bova nalo, ");
INSERT INTO bki_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","avukulo avan ea sebi na toru, na tomu nalo ajum̃a ajegi eaio, ajum̃a ajer m̃arjuvolo nalo eaio.” ");
INSERT INTO bki_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Naruei Yesu bika den kiano naiagagoano nalo, ber “?Kamiu kumijoglubarbar iliano nalo nei?” Ana nalo aberdop̃e, aberinavo “Nao, kumemi numijikia koviobo.” ");
INSERT INTO bki_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ana naio ber kalo, berinavo “Saba nalo nei jibe ka toro tai napano beamu, naio be naverloglogiano na tuboiano nalo na Atua kiano Iliano Lu, mia iorou kanio, ana naio binimei be kanaku naiagagoano tai ea navenatuboiano na Atua kanano. Naio javukia toro na toru tai napano kiano saba novo na im̃auano nalo telabo ea kunuano. Ana bogo nonovio, naio mijikia rivar bulag kiano vite na be terimoruo na bo kia ga vo, a naio mijikia rivar bulag bunu kiano tena be terivou, ka mia naio rila kiano im̃auano nalo ealo.” ");
INSERT INTO bki_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bogo napano Yesu berial jamerijiano nalo nei bisi, ana naio juvan vio nei, ");
INSERT INTO bki_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","binimei bereio ea kiano vio. Naruei naio jom̃a berloglog tomu nalo na vio nei, joomo ea kanalo yimo na volkouano, mia nalo amiilo toru ka kiano iliano nalo. Ana nalo ajum̃a aberverii kalo, aberinavo “!Tomnei! ?Tete na, naio bokar m̃asosouano nei jum̃abe, a naio jom̃a mila vremesiano nalo na jum̃abe? ");
INSERT INTO bki_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Romijikia tete nei ruei. Naio karam̃ano napano be toro nam̃a mim̃auka yimo ga napano Yoseve, a napano kenieno, tira napano Mere. A kuruano nalo, nina Yemesi, a Yoseve, a Saimon, a Jutas, nalo na abe kurualo ea naio. ");
INSERT INTO bki_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A kuvivinieno nalo, nalo nei ga aju kitoliko ga. ?Mia tete na naio jaluvo den kito, ba bar tenalo na be?” ");
INSERT INTO bki_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naruei nalo tiniel jer naio, maka asidom naio leleio. Mia Yesu naio ber kalo, berinavo “Toro napano be naverialiano, tomu dolu nalo amijikia ajovonio, mia tomu na kanano vio, naliko kanano m̃aratavo nalo, nalo na ga maka ajikia atovon naio.” ");
INSERT INTO bki_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Naruei ea vio na, Yesu naio maka rila vremesiano ve telabo, bior nalo maka amonea naio. ");
INSERT INTO bki_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka bogo nei, aber Yesu ba bokar Parinio Tubo Erot, na naio be parinio tubo na tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana Parinio Tubo Erot naio mijog iliano nalo nei, ana naio ber ka kiano tomu na tortoru nalo, berinavo “?Toro napano ajum̃a aberiio na, naio be Jone Baruei ga kovio, napano naio meul bereio den na m̃ariano bo? Tenene na naio mije moroano ka mim̃auka vremesiano nalo na.” ");
INSERT INTO bki_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Parinio Tubo Erot naio mil jibe na, bior naio naruei muetam̃aria Jone Baruei m̃aro ruei, ana naio jo merou m̃ele kanio. A tukunu na m̃ariano na Jone Baruei kiano jibe nei: Parinio Tubo Erot nei kuruano Vilip, napano naljuo karam̃alo takurano mia keniele juo. Ana beamu, Vilip nene, naio joro ka tira tai siano Niarotias. Mia iorou kanio, ana Parinio Tubo Erot naio ba burular tira nene. Tenene na, Jone jom̃a mil ban Parinio Tubo Erot kanio, berinavo “Tena jau komila na maka rimemedu ka, napano jau koburular tira na, bior naio be kuruamo koano.” Mia Niarotias maka saaro leleio ka Jone kanano iliano, naruei naio mil ban Parinio Tubo Erot, ana Parinio Tubo Erot miila kanano tomu tai aba abokar Jone, amiorkario, ana amidu joa nalakoiano. ");
INSERT INTO bki_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Mia Parinio Tubo Erot milavio ka ruebin Jone, mia naio merou kija kanio kulo Israel nalo, bior nalo amonea Jone aberinavo naio be kialo naverialiano tai. ");
INSERT INTO bki_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naruei Niarotias nei, naio be kenerinio vevinio tai, mia bogo napano nalo amila jokoluolu ka atekar bogo napano abar Parinio Tubo Erot eaio, ana niatira nene naio bolu kamu ka nalo na ajua jokoluolu nei miralo. Naruei Parinio Tubo Erot naio jaaro toru ka merevono nei kanano voluano, ");
INSERT INTO bki_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","naruei naio berkakario jikili banio, berenio vaio napano ver naio rivika denio, mia naio rudu vanio. ");
INSERT INTO bki_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Naruei Niarotias naio mil bija kenerinio vevinio, bisi ana kenerinio vevinio nei naio ber ka Parinio Tubo Erot, berinavo “Vonganei, kiniou nejidom kodu van kiniou Jone Baruei pariparinio, toa baju tai, rimei ea vio nei.” ");
INSERT INTO bki_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mia iliano nei mila Parinio Tubo Erot mijog bova bior kiano verikariano na yokovoano nei, mia naio berenio ka ala bo ka tibe ka ga na merevono nei naio berenio, bior naio mila ilikakariano jikili jibe na ea kanano bilbilu nalo miralo ruei. ");
INSERT INTO bki_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ana nalo aban ea yimo na lakoiano, ajekorov Jone burujono, ");
INSERT INTO bki_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ana amidu parinio joa baju tai, ana amidu binimei ban merevono nene, ana merevono nene na midu ba ban kenieno. ");
INSERT INTO bki_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iorou kanio ana Jone kiano naiagagoano nalo abinimei amidular mokotenano aba ajivinio, ana nalo aba aberial ka Yesu. Mo tukunu na Jone Baruei kiano m̃ariano biniu ea vio nei. ");
INSERT INTO bki_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Naruei bogo napano Yesu mijogial ka Parinio Tubo Erot naio jo berii naio, berinavo naio be Jone Baruei naio meul bereio den na m̃ariano, ana Yesu jumolu den vio na, ana naio bavin ea uako tai, ka naio rivan ea vio yauo tai napano be tum̃aro napano maka tomu nalo atuaio. Mia bogo napano tiniobi nalo amijikia ka naio ban jibe na, amolmoluo ea kialo m̃arkomeli nalo, ajakisorio, ajel uro. ");
INSERT INTO bki_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mia bogo napano Yesu bauro, mia naio mial ka tiniobi na tomu nalo aju ruei, mia naio tinien miialo toru, ana naio mila kialo tomu na mieiano nalo abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mia bogo napano m̃erenio batove, ana Yesu kiano naiagagoano nalo abinimei kean naio, aberinavo “Tubo, vio nei maka rivu, a vaataro ka vio rimelijo bunu. Bo ka jau keiila tiniobi nalo na avanvan bereio ea komeli nalo, ka avulu salo sinaniano tai.” ");
INSERT INTO bki_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ana Yesu berdop̃e ber kalo, berinavo “Makanio, nalo amijikia atu tibe na rivu ga na. Bo ka kamiu kuvar sinaniano tai vanlo.” ");
INSERT INTO bki_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ana nalo aber kanio, aberinavo “!Uerei p̃eli ga, kumemi nubokar joko sesa jumo ga, bija momaio bana juo ga!” ");
INSERT INTO bki_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ana Yesu berinavo “Kuvar rimei van kiniou,” ");
INSERT INTO bki_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ana naio ber ka tiniobi nei, berinavo “Kamiu kuvitutano ea soro beamu vo.” Naruei naio bar joko sesa jumo bija momaio bana juo nei, naio jirarago bavin ea vio tiniabene, ana naio ber siva ban Atua ka sinaniano nei, karina naio burekokorovio joko sesa nei, naio jian ban kiano naiagagoano nalo ka nalo avar van tiniobi nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mia nalo ajinan bano-o, mabolo jouo bo, mia niati na sinaniano nalo napano maka asenio, nalo abe verare ka aisonlo rivan ea basaro solokobaro nalo napano tortoru ve duelimo ba juo 12. ");
INSERT INTO bki_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mia tomu nalo napano ajinan, sum̃analo ga abokar kovio ea menu jumo 5,000, mia maka avuluku tire nalo vija kiritete nalo. ");
INSERT INTO bki_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Karina Yesu ber ka kiano naiagagoano nalo, berenio “Kiniou nejidom ka kamiu kuvidu kiado uako, kamiu beamu kuva tivelinio ea ueiyabo na toru nei, mia kiniou noto nei beamu vo ka mia neiila tiniobi nalo nei avanvan bereio ea kialo m̃arkomeli dedade nalo.” ");
INSERT INTO bki_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ana bogo napano naio miila dedade ea tiniobi nalo nei abanvan bisi, ana naio bavin ea suku tai, naio takurano, ka rivolkouo. Bogo napano vio melijo ruei, mia Yesu jo naio ga takurano, ");
INSERT INTO bki_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","mia ka bogo nei, uako neibano naio jo koalabo ruei, iviso ea tinia ueiyabo. Naruei niatuva toru laka, a nalo aju ajup̃e jegi, mila ana nalo amidu tei mia amidu tei. ");
INSERT INTO bki_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mia vaataro ka vio rivuruburevure ka viorijeni, ana Yesu binimei ka rialo, naio jo miel manono mave ea tei. ");
INSERT INTO bki_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mia bogo na kiano naiagagoano nalo amial naio jo miel binimei jibe na, mia nalo amerou, ana aber “!Uerei! ?Titai yako, p̃eli sim̃aro tai koviobo, p̃eli venia jibe na?” Mia nalo amiaga jouo, bior nalo amerou m̃ele, ");
INSERT INTO bki_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","mia vaarakurano Yesu naio mil banlo, berinavo “!Ei, kamiu kumerou re bunu, mia be kiniou ga nei!” ");
INSERT INTO bki_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ana Pitere berdop̃e, berinavo “Tubo, a verenio be jau riano, mia kajamo ka kiniou bunu neiel mave ea tei neviedu keanso.” ");
INSERT INTO bki_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ana Yesu berinavo “Jau, bo ga, komei.” Ana Pitere batove den uako, naio jikar miel mave ea tei, naio ban vaataro ka Yesu, ");
INSERT INTO bki_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","mia bogo napano naio tinien maio bereio ka jegi napano jikili nei, naio merou. Mia bogo na naio merou jibe na, ana naio jikar ka madudu, naruei naio bio ban Yesu, berinavo “!Tubo, jau kajai kiniou!” ");
INSERT INTO bki_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Vaarakurano ga Yesu mijiou bokar Pitere jum̃ano, ana naio berkanio, berinavo “?Jum̃abe ana niukniuku bieso? !Maka leleio koviekar kiniou sikili leleio kija vo!” ");
INSERT INTO bki_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mia bogo napano nalo abe juo abavin ea uako bereio, vaarakurano jegi juba bin, ");
INSERT INTO bki_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","mia nalo napano ajua uako amiaia Yesu, aberenio “Riano ga, jau kobe Atua kenerinio riano.” ");
INSERT INTO bki_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ana Yesu nalo aban ea kialo uako abarkorovio ueiyabo labo nei, aba tivelinio, naruei nalo abauro ea vio tai, siano Kenasarete. ");
INSERT INTO bki_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mia bogo napano tomu na vio nei amijikia naio, ana nalo amiila toru janea vio nonovio jeliviv ea vio nei. Ana nalo aburu tomu na mieiano nalo abinimei ea naio, ");
INSERT INTO bki_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","naruei nalo abalea naio ka rijamo ana nalo napano amie atokol ga kiano ikit kulum̃arauo. A nalo na atokolio tibe na, mia kialo mieiano nalo ribisi, ana mia nalo avu bereio. ");
INSERT INTO bki_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ana bogo nene, Varisis nalo tai naliko naverloglogiano na tuboiano nalo tai ajuvan vio Yerusalemo, abinimei ka aial Yesu. ");
INSERT INTO bki_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nalo abika denio, aberinavo “?Ka vaio ana kanamo naiagagoano nalo ajum̃a amiakurano ea bajago moruo na kiado nalotuano, na kiado navurim̃araboiano nalo na beamu ajum̃a aberloglog ka kito, aberinavo bogo nonovio ver toro sidom sinan, monokanio naio takii vatitig m̃arabo na memedu nene, ka sekon jum̃ano beamu vo, karina mo naio mijikia sinan?” ");
INSERT INTO bki_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ana Yesu berdop̃e banlo, berinavo “?Ana kamiu bunu, bior vaio ana kamiu kumisikili ka kumitakii kenemiu bajago moruo nalo nei, mia ea kenemiu bajago moruo kamiu kumitum̃a kumilakokorov Atua kanano tuboiano? ");
INSERT INTO bki_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mia Atua nene, naio ber ‘Jau komonmonea karam̃amo a koniomo,’ mia naio ber bunu, berinavo ‘Ver toro tai naio ril rivova ka karam̃ano a kenieno, kamiu kuvuebin naio rim̃aro.’ ");
INSERT INTO bki_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mia vonganei, verenio toro tai berkar ber kiano saba nalo abe lu, mia naio rivar van Atua bogo tai, naio ber jibe na mia iorou kanio, ana naio maka rijikia rivitikar kiano tormoruo juo nei, p̃eli rijailo ka saba nalo nene, ");
INSERT INTO bki_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ana kamiu kumitu kuber jibe na naio bo ga na, nina maka ve vite tenia. Mia ea bajago na, kamiu kumitum̃a kumila Atua kiano tuboiano binimei be iakurano, bior kamiu kumisidom kuvokar ga kenemiu bajago moruo nalo. ");
INSERT INTO bki_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Mia kamiu kumilasibi ga na, kamiu kumitum̃a kumil kurano ga! Naverialiano Aisea naio berii kamiu nua ruei, napano naio berial iliano na Atua naio berenio, napano ber ");
INSERT INTO bki_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tomu nalo na amonmonea kiniou ka kialo iliano nalo ga, mia kialo jidomiano nalo aju koalabo den kiniou kia ga vo. ");
INSERT INTO bki_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mia nalo aju amilotu ban kiniou kurano ga, bior bogo napano aberloglog toro, nalo aber iliano na, naio be Atua nene kanano, mia iliano na be nalo kulorinio ga kialo.’” ");
INSERT INTO bki_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Naruei Yesu naio bio tomu nalo ka amei vio takurano ea naio, ana naio mil banlo, berinavo “Bo ka kamiu kuviagago vatitigio, monoka kamiu kuvijoglubar kanaku iliano. ");
INSERT INTO bki_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Maka sinaniano napano ba joomo ea toro niono, naio mijikia rila toro riagiago ea Atua mirano, mia iliano nalo napano m̃a moluo ea toro niono, naina naruei napano mila toro miagiago.” ");
INSERT INTO bki_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ana karina, kiano naiagagoano nalo abinimei, aber kanio, aberinavo “?Ai koig, jau komijikia ka Varisis nalo tiniel mimi toru ka iliano nalo napano jau kojom̃a koberenio?” ");
INSERT INTO bki_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ana Yesu berdop̃e ber kalo, berinavo “Kamiu kuvisidomial re nalo na. Venia napano nalo ajum̃a amilaio, naio maka ve Atua kiano im̃auano na, mia Teta napano joa vio mave mia naio rivuru bulag nonovio vite nalo napano naio maka rimebijalo. ?Tomu nalo na abe merebono ga, mia ajidom avurim̃arabo ka toro dolu napano be merebono, mia nalo ave juo aiel tum̃abe? !Mia nalo ave juo amijikia ajoru ea bulukup̃ili tai na!” ");
INSERT INTO bki_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Naruei Pitere bika den Yesu, ber “Koig, jau kobijuku bo komijikia koverial nioti na jamerijiano neibano jau koberiio jukamu ban kumemi.” ");
INSERT INTO bki_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mia Yesu berenio “?Jum̃abe, p̃eli parimiu merorol bunu kia ga vo? ");
INSERT INTO bki_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","P̃elina kamiu kumijikia kija ruei, bior vaio napano ba joomo ea toro niono, jelea mabono ba tavio den mokotenano bereio, ");
INSERT INTO bki_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","mia vaio napano moluo ea toro niono, naio moluo ea kiano iviso jukamu, naruei naio mijikia mila toro miagiago. ");
INSERT INTO bki_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mia nina bior kiano jidomiano va nalo amoluo ea tiniene toro, jibe ka amila bin toro, amila siakaiano, a m̃eaku naljuo niatira amila siakiano, a vinauano, a ilisibiano, a ilivovaiano. ");
INSERT INTO bki_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mia nina be bajago nalo napano amijikia amila toro miagiago kamu ea Atua mirano. Mia bajago napano ajinan, maka asekon jum̃alo tukamu, naio maka rijikia rila toro riagiago tibe na.” ");
INSERT INTO bki_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Naruei Yesu juvan vio nei, ana naio batove ea bulukomeli juo na vio Taia bija Saiton. ");
INSERT INTO bki_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ana tira valauo tai na vio Kenano, naio joa tanobuku na vio nei ruei, ana naio binimei mial Yesu, naio bio banio, berinavo “Tubo, jau kobe Naverikariano napano komiyotuba ea Teviti kiano bajulukuti. Kiniou neber bo kaso tiniem riia kiniou. Keneriku vivinio, niadu tai ban ea naio, a mila lelan naio jikili laka.” ");
INSERT INTO bki_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Naruei Yesu mijog tira nei kiano iliano, mia maka riolu riverip̃e titai leleio van tira nei. Iorou kanio, ana kiano naiagagoano nalo abinimei, aber kanio aberinavo “Tubo, tira nei, naio jom̃a bio lili kito toru laka. Bo ka jau keiila naio rivabilig.” ");
INSERT INTO bki_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ana Yesu maka riverdop̃elo, mia naio mil ban tira nei, berinavo “Atua miila kiniou nebinimei ka navan ea kulo Israel nalo ga, nalo napano ajavukia nunu nalo napano amilaluvu m̃arabo.” ");
INSERT INTO bki_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mia tira neibano naio binimei, minie kamu kean Yesu jaano, ana naio berinavo “Tubo, neber bo kaso nejidom jau kajai kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mo Yesu naio berdop̃e, ber “Maka rivu ka navar bulag kiritete nalo salo sinaniano, novuku van kuli nalo.” Naio mil jibe na bior naio mijikia ka bogo na, kulo Ju dolu nalo aberiam̃a nalo ga abe Atua kenerinio nalo, bior ajum̃a aberii searo ea tomu nalo napano maka ave kulo Ju, abiolo aber abe kuli ga liki. ");
INSERT INTO bki_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mia tira neibano naio mil, berinavo “Jau kober riano, Tubo, mia kuli nalo amijikia asen ga iororoti sinaniano napano jibiribili jel tano ka boru na kuli nalo nei kiano barobaro na sinaniano.” ");
INSERT INTO bki_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ana Yesu berdop̃e vatitig ban naio naruei, berinavo “Tira, jau kobiekouo ea kiniou koju jikili laka. Mia vonganei jau keialio rimei vanso tibe ka napano jau komoneaio.” Mia memedu ka bogo nene, ana tira neibano kenerinio vivinio neibano binimei bo bereio. ");
INSERT INTO bki_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Karina, Yesu jumolu den vio na bereio, naio ban bereio ea tanobuku na vio Kalele. Naio jom̃a miel barlaka, ban vaataro ka ueiyabo na tanobuku nei, naruei naio bavin ea suku tai, naio jotano. ");
INSERT INTO bki_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Naio jotano jibe na, naruei tiniobi na tomu nalo abinimei ka naio, bija javuluku nalo, a nalo napano abe jam̃aba kirikokouro, a merebono nalo, a buru nalo, a tomu na mieiano dedade nalo bunu. Aburulo abinimei, ajuvanlo aju vaataro ka Yesu, naruei Yesu naio milarurlo abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ana tomu nalo amiilo toru ka bogo napano nalo amial buru nalo amil, jam̃aba kirikokouro nalo abo, javuluku nalo amiel, a merebono nalo ajirarago, naruei nalo amialio, ana amiaia kulo Israel nalo kialo Atua toru laka biorio. ");
INSERT INTO bki_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ana Yesu bio kiano naiagagoano nalo ka amei aialio, karina naio berinavo “Kiniou tinieku miia tiniobi na toru nei, bior nalo aju kitoliko bogoti tolu ruei, mia vonganei salo sinaniano nalo biniuviniu. Mia kiniou maka nejikia neiilalo avanvan vonuo ver maka sinaniano, bior ver kiniou nala tibe nei, p̃eli mia tomu tai miralo ribobogio ea m̃arabo rivior vitu.” ");
INSERT INTO bki_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naruei Yesu kiano naiagagoano nalo aber kanio, aberinavo “?Mia ravar salo sinaniano ea vio be? Bior vio nei be vio yauo kurano ga, a tiniobi toru laka.” ");
INSERT INTO bki_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ana Yesu bika denlo, berinavo “?Kamiu kubar joko vio?” Ana nalo aberinavo “Joko aluo 7 ga, bija momaio tealo.” ");
INSERT INTO bki_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Naruei Yesu ber ka tiniobi na toru nei, berinavo “Kamiu kuvitutano beamu vo.” ");
INSERT INTO bki_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ana naio bar joko aluo 7 neibano, bija momaio nalo nei, ana naio ber siva kanio ban Atua, karina naio burekokorovlo, ana bario ban kiano naiagagoano nalo. Ana kiano naiagagoano nalo kija abario abiovio ka janea tiniobi nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Naruei nalo ajenio bano-o mia mabolo jouo bo. Mia iorou kanio, ana nalo amison niati sinaniano nalo napano aju, ban ea basaro sarobobotu nalo aluo, abujovujo vatitigio bo. ");
INSERT INTO bki_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mia tomu nalo napano ajinan, sum̃ano nalo ga abokar menu veri 4,000, mia maka avuluku tire nalo vija kiritete nalo. ");
INSERT INTO bki_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Karina Yesu miila dedade ea tiniobi nalo nei abanvan bereio vonuo, mia naio ban bereio ea kialo uako, ana naio juvan vio nei, naio binimei jo bogo bulati ga ea tanobuku na burum̃ara komeli na vio M̃akatano. ");
INSERT INTO bki_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bogo tai, ana Varisis nalo naliko Satusis nalo abinimei amial Yesu, ajidom ka alavon naio, ana nalo aberinavo “Kumemi numisidom jau kalavon vremesiano na toru tai van kumemi, napano mia jau koim̃aukanio ea moroano na vio mave.” ");
INSERT INTO bki_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ana Yesu naio berdop̃e banlo, berinavo “Bogo napano m̃erenio jo batove, mia verenio kamiu kumial vio bilvili ea vio na m̃erenio jo batove eaio, ana kamiu kumijikia kuverenio ‘Mia nieta beni,’ ");
INSERT INTO bki_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","a bogo napano m̃erenio bavin, mia verenio kamiu kumial vio bilvili ana kumial melijo bobogio, ana kumijikia kuverenio ‘Mia yuo rivovo banei.’ ?Mia kamiu kumijikia kubitii vremesiano na ea tiniabene ruei, ka mia kuverenio mia bogo tum̃abe, mia jum̃abe ana kamiu maka kuvijikia kuvitilubar kiaku vremesiano nalo ea burum̃ara bogo toru nei nojo bija kamiu nei?” ");
INSERT INTO bki_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mia Yesu berii bunu banlo, berinavo “Tomu nalo na ajidom aial ga vremesiano nalo, abe kulo va nalo, nalo nam̃a amila kodovo ban Atua, abilig taakalo ban naio, jibe ka nalo napano amila siakaiano aburo den koualo nalo. Makanio, mia kamiu maka kuvijikia kuvial vremesiano tai, mia kamiu kuvial ga napano mia riyotuba ka kiniou tavukia vremesiano na Naverialiano Jona re nua, napano Atua mila naio meul bereio.” Ana naio jumolu denlo juvanlo ajubo. ");
INSERT INTO bki_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mia bogo na Yesu naliko kiano naiagagoano nalo ajumolu abano, ana abarkorov ueiyabo na toru nei aba tivelinio, ana kiano naiagagoano nalo tiniel bobogia ka avarkar salo joko tai. Mia bogo na aboru tivelinio, ");
INSERT INTO bki_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ana Yesu jian iliano tai banlo, ana naio berinavo “Kamiu kuvitikar vatitig kamiu rivu ka isi na Varisis naliko Satusis nalo kialo.” ");
INSERT INTO bki_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ana nalo amijog iliano nei, mia nalo ajum̃a aberiio ka nalo bereio, aberinavo “?Naio mil jibe na bior maka ravarkar joko tai rimei ea vio nei koviobo?” ");
INSERT INTO bki_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Mia Yesu mijikia kanalo jidom-iano nalo nene, ana naio ber “?Bior vaio ana kamiu kumitum̃a kumisidomii m̃elea mabomiu nalo, ka mia kito resen venia? ?Jum̃abe ana maka kuvijoglubar vite nei vo? !Kenemiu moneano kiritavaso! ?P̃eli kamiu tiniemiu bobogia bunu joko jumo nanua na, nabar ban tiniobi menu jumo 5,000, bija basaro solokobaro nalo na kumisonlo abujovujo? ");
INSERT INTO bki_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?P̃eli kamiu tiniemiu bobogia bunu joko aluo nanua na, nabar ban tiniobi menu veri 4,000 nalo, a basaro sarobobotu vio napano kamiu kumisonlo abujovujo iorou kanio? ");
INSERT INTO bki_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Jum̃abe maka kuvijoglubar ka kiniou maka neil van kamiu ka joko? Mia neber ka kamiu bereio, kuvitikar vatitig isi na Varisis naliko Satusis nalo kanalo.” ");
INSERT INTO bki_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mia vonganei nalo amijikia ka naio maka riverii isi na joko miyuku, mia naio jo ber avitikar batitig Varisis naliko Satusis nalo kanalo ilisibiano nalo napano mia averlogloglo kanio, napano mijikia rila toro parinio turobi ve toru, mijikia riva rila searo ea nono togio na kiano meuliano, tavukia napano isi mila ka joko. ");
INSERT INTO bki_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Naruei Yesu nalo abatove ea tanobuku na bulukomeli na toru nei Sisiria Vilipai, mia ka bogo na naio bika den kiano naiagagoano nalo, berinavo “?Kamiu kumijog ka tomu nalo ajum̃a aberverii aber Kulorinio Kenerinio naio be kei?” ");
INSERT INTO bki_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ana nalo aberinavo “Tomu tealo aber jau kobe Jone Baruei bereio, a tealo aber jau kobe Elaija, a tealo aber jau kobe Jeremaia, p̃elina naverialiano dolu tai re nua nua.” ");
INSERT INTO bki_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Naruei naio bika denlo, berinavo “?Ana kamiu, kamiu na kuber kiniou nebe kei?” ");
INSERT INTO bki_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ana Saimon Pitere naio berdop̃e, berinavo “Jau kobe Naverikariano, jau kobe Atua na meul kenerinio.” ");
INSERT INTO bki_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ana Yesu berdop̃e banio, berinavo “Saimon, Jone kenerinio, mia ilivuiano rimei vanso. Vite na jau koberialio, maka kulorinio riverial kaso, mia Teta napano joa vio mave, naio berial banso. ");
INSERT INTO bki_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mo jau na siamo dolu nene napano Pitere naio ber jibe nei ber ‘Veru,’ a be riano laka, ka kiniou nemialso jibe ka veru tai napano jo, a mia kiniou nevitirilar kanaku taara na lotuano nalo ea tabap̃ilio tibe na naruei, mia moroano na m̃ariano maka rijikia tovulu taara na. ");
INSERT INTO bki_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mia kiniou nodu ki nalo na vetavoiano a na tetavokoiano na navenatuboiano na Atua kanano vanso, ka mia verenio vite napano jau koverbure ea yetemeriba nei, mia Atua na vio mave bunu riverbure kamiu ve juo, mia verenio vite napano jau kajamo kanio ea yetemeriba nei, mia Atua na vio mave naio bunu rijamo kanio kamiu ve juo.” ");
INSERT INTO bki_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ana na Yesu ber jikili ban kiano naiagagoano nalo, berinavo “Mia kamiu kuverial re van tomu nalo ka kiniou nebe Naverikariano.” ");
INSERT INTO bki_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mia jikar ea bogo na, Yesu milavon ka riverial rimeravo van kiano naiagagoano nalo, ka mia naio monoka rivavin ea vio Yerusalemo, ana ea vio na, mia tubo nalo na vio Israel, a nalo napano abe parinio kulo lu nalo, a naliko naverloglogiano na tuboiano nalo, nalo nei naruei nalo aviniu ala lelan searo ea naio. Mia Yesu berial banlo bunu ber mia nalo nei auetam̃aria naio rim̃aro, mia bogoti ve tolu 3 nene, ana mia Atua naio rivurular naio tumolu rimeul bereio. ");
INSERT INTO bki_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naruei Pitere biolar Yesu denlo, ana naio jikar mil jikili banio, berbureio, berinavo “Yesu, monoka mia Atua naio riverbure tena. Vite nalo na maka rijikia rimaluvo kaso tibe na.” ");
INSERT INTO bki_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mia Yesu barp̃ilig naio, ana mil jikili ban Pitere, berinavo “!Setano, kotu koalabo den kiniou! Jau kojom̃a komilavon kiniou ea kanamo jidomiano napano be toro ga kiano, mia maka ve Atua kanano jidomiano leleio.” ");
INSERT INTO bki_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Naruei Yesu ber ka kiano naiagagoano nalo, naio berinavo “Toro napano ver jidom rimei tu iorou ka kiniou, monoka naio sidom ve iakurano ga ea kiano tinieiaiano nalo, mia monokanio naio rudu kanano m̃akolkolo, ana mo naio takisor kiniou. ");
INSERT INTO bki_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Toro napano jidom rilarur kiano meuliano, mia naio rilaluvuio, mia toro napano rilaluvu kiano meuliano rivior kiniou, mia naio mijikia rivokar meuliano na be riano. ");
INSERT INTO bki_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Naruei verenio toro tai napano na rivokar saba nalo nonovio na vio yetemeriba nei riviniu, mia naio milaluvu m̃arabo na meuliano, naio nei maka rijikia rivokar telerinio nabo tai leleio, mia iorou kanio, mia kiano saba novo nalo nei maka rijikia rivulu meran kanano meuliano bereio. ");
INSERT INTO bki_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mia vaataro ka Kulorinio Kenerinio rimei bereio naliko kanano nailiano nalo, mia naio rimei vija karam̃ano kanano miamoiano, naruei mia naio rivulu tomu nalo rive verare ka kialo im̃auano nalo. ");
INSERT INTO bki_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Riano ga kiniou neber ka kamiu, be tomu tai nalo ajumolu ajua vio na, napano mia nalo maka ajikia am̃aro vo, rivano-o mia rivokar bogo napano mia aial Kulorinio Kenerinio naio rimaluvo rimei vija kiano navenatuboiano, ka mia rimei rive tubo ka tomu nonovio.” ");
INSERT INTO bki_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mia iorou ka bogoti ari 6 barlaka, ana Yesu buru Pitere, a Yemesi, a kuruano Jone, ana nalo veri abavin ea burusuku tai. ");
INSERT INTO bki_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bogo napano nalo aju jibe na, ana naiagagoano tolu nei amial Yesu niabene binimei be dolu, a mirano binimei merera toru jibe ka m̃erenio, a m̃ano kulum̃arauo nalo abinimei amiuvu novo mia amiuvu nonovio garuei. ");
INSERT INTO bki_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naruei nalo tolu nei amial Mosis naio Elaija amaluvo bunu, ana naljuo aju amil naliko Yesu. ");
INSERT INTO bki_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ana Pitere ber ka Yesu, berinavo “Tubo, bo ka kito rotua ga vio nei. Mia ver kajamo kanio, ana mo noim̃auka tobobo ve tolu ea vio nei, tai ve kanamo, tai ve Mosis kanano, a tai ve Elaija kanano.” ");
INSERT INTO bki_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bogo napano Pitere naio jo mil kia ga vo, ana melijo tai napano merera binimei jovukolo, naruei nalo amijog iliano tai maluvo ea melijo nene, na berinavo “Nina be keneriku napano kiniou nejidom m̃elea na. Kiaku jidomiano joaio na, mia kiniou najaaro m̃elea kanio na. Mia monoka kamiu kumonmonea vatitig naio.” ");
INSERT INTO bki_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ana kiano naiagagoano nalo amijog iliano nei, naruei nalo amerou mia amerou, ana nalo amijoru ea tano ana amiduvan miralo. ");
INSERT INTO bki_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mia Yesu naio binimei ealo, ana naio mijubaluba taakalo abe tolu, ana naio ber kalo, berinavo “Kamiu kuvitumolu, kamiu kumerou re.” ");
INSERT INTO bki_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naruei bogo napano nalo abar bulag pariparilo ajirarag bavin bereio, mia maka bunu aial tomu juo nei, mia Yesu ga takurano ju. ");
INSERT INTO bki_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tilikiti napano nalo ajuvan burusuku nei, aju abatove bereio, ana Yesu berii kalo berburelo, berinavo “Vite napano Atua mila kamiu kumialio, mia kamiu kuverial re ka tomu tai rivano-o rivokar bogo napano Kulorinio Kenerinio rimeul bereio ea m̃ariano, ana ea bogo na naruei, ana mia kamiu kumijikia kuverial ka tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Karina naiagagoano tolu nei abika den Yesu, aberinavo “?Jum̃abe ana naverloglogiano na tuboiano nalo ajum̃a aber jibe nei, aberinavo ‘Monoka mia Elaija naio rimei bereio tukamu vo, avona bisi ana mia Naverikariano nei naio mia riyotuba’?” ");
INSERT INTO bki_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ana Yesu berdop̃e banlo, berinavo “Tena ajum̃a aberverii na jibe nei, tena be riano ga na, bior Naverialiano Malakaia naio berenio jibe na ea kanano niosi ruei. Elaija monoka mia naio rimei tukamu, ka mia naio rila batitig vite nalo nonovio atu batitig ka mia Naverikariano nene naio mijikia rimei, ");
INSERT INTO bki_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","mia kiniou neber ka kamiu, neberinavo Elaija nene naio binimei ruei, mia tomu nalo maka avitilubar naio, a nalo maka asidomial naio. Mia ea ga bajago nene, mia ala lelan Kulorinio Kenerinio bunu tibe na.” ");
INSERT INTO bki_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ka bogo nei, kiano naiagagoano tolu nei miralo madulu ana nalo amijikia ka Elaija napano Yesu naio jom̃a beriio, naio be Jone Baruei ga. ");
INSERT INTO bki_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mia Yesu naliko nalo tolu nei aban bereio, naruei nalo amiabure tiniobi nalo napano ajua bogo na, naruei toro tai binimei minie tano ea Yesu jaano, ana naio berinavo ");
INSERT INTO bki_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Koig, jau kobijuku bo, kiniou nejidom jau tiniem riia keneriku m̃eaku, nejidom kajai naio, bior mieiano tai joa naio. Mieiano nene mila naio jom̃a miabulum̃arm̃aro va telabo, a mila lelan m̃eleia naio-o mia, mila naio jom̃a mijorutate ban ea sebi a ban ea uei nalo bunu. ");
INSERT INTO bki_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mia kiniou noburu naio binimei ban kanamo naiagagoano nalo ruei, amim̃aukanio bano-o, mia maka ajikia aim̃auka naio rivu.” ");
INSERT INTO bki_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ana Yesu naio mil ban kiano naiagagoano nalo, berinavo “?Kamiu na, jum̃abe jibe na? Kamiu maka kuvitu sikili ea Atua leleio, bogo nonovio ga m̃a kumiavovu. ?Mia kiniou monoka noto vija kamiu rivano-o mia rivokar nagi? Mia kiniou tinieku maro ruei ka kamiu. Mo, bo ga, kamiu kuvuru m̃eaku nene rimei van kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ana nalo aburu m̃eaku nene binimei, ana Yesu janka niadu napano joa naio, berinavo “!Komoluo den naio vonganei ga!,” ana vaarakurano ga m̃eaku nei naio binimei bo bereio. ");
INSERT INTO bki_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ana iorou ka bogo nene, bogo napano Yesu jo naio takurano, ana kiano naiagagoano nalo abinimei kean naio, abika denio aberinavo “?Jum̃abe ana kumemi maka nuvijikia nuvititiglar niadu napano joa m̃eaku na?” ");
INSERT INTO bki_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ana Yesu ber kalo, berinavo “Nina bior kamiu maka kuviekouo ea kiniou sikili rivare vo. Riano, kiniou neber ka kamiu, verenio kamiu kuviekouo ea kiniou ve kiritavaso leleio ga tavukia kurukuti burubako, mia verenio kenemiu viekouoiano na rive riano rivu, ana mia kamiu kumijikia kuver ka burum̃ara burusuku na, kuver ‘Kataluvo den vio na,’ mia naio taluvo. Mia maka titai ka mia kamiu kuvijikia re ka kamiu kuvilaio. ");
INSERT INTO bki_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mia ka natitiglariano na niadu nalo tibe nei, m̃arabo nene jibe nei: toro naio monoka rivolkouo, a naio rimodulu ka sano sinaniano. Ea bajago na ga, mia naio mijikia titiglar niadu ninio nalo na.” ");
INSERT INTO bki_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bogo tai ana Yesu naliko kiano naiagagoano nalo abinimei vio takurano ea vio Kalele, ana naio ber kalo, berinavo “Vaataro ka mia adu Kulorinio Kenerinio toa tomu nalo jum̃alo, ");
INSERT INTO bki_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ka mia auetam̃aria naio rim̃aro, ana mia iorou kanio, bogoti ve tolu nene, ana mia Atua rila naio rimeul bereio.” Ana kiano naiagagoano nalo amijog iliano nei, nalo amijog bova toru laka. ");
INSERT INTO bki_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tilikiti napano Yesu naliko kanano naiagagoano nalo abinimei aboru Kapeneam, tomu nalo nam̃a abarbijii takis na Atua Kunuano Lu, nalo abinimei kean Pitere, abika denio, aberinavo “?Jum̃abe, kanamo naverloglogiano na naio jom̃a bulu takis na bunu, p̃elina makanio?” ");
INSERT INTO bki_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naruei Pitere berdop̃e, berinavo “Nao, naio buluio.” Naruei Pitere ban bereio ea yimo napano Yesu joaio, mia Pitere maka river iliano tai vo, ana Yesu naio mil jukamu banio, bika berinavo “Saimon, jau kosidomii von parinio tubo na yetemeriba nalo. ?Kulo be nalo napano m̃a ajum̃a abulu takis banlo? ?Nalo napano abe m̃aratavo, p̃elina kulo dolu nalo?” ");
INSERT INTO bki_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Naruei Pitere berinavo “Tomu dolu nalo ga monoka avuluio.” Ana Yesu berenio “Nao, jibe na naruei, a nina berenio m̃aratavo nalo na parinio tubo nalo, maka ajikia avuluio. A kiniou naruei, nebe m̃aratavo na Parinio Tubo na Yimo Lu napano memedu, mia kiniou maka nejikia novulu takis na ajum̃a abika denso na. ");
INSERT INTO bki_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mia bo ka kito juo rala bulag re tomu nalo na ajum̃a abarbijii takis, mia kito juo bunu rovuluio bo ka ga. Mo, jau kavatove ea ueiyabo, ana kosuvan tap̃ig, mia niado nana mia kovuruio tukamu, mia keial puruveru tai ea niono, na bare ka kiado takis kito juo, mia kodu kava kovulu kanio.” ");
INSERT INTO bki_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana memedu ka bogo nene, naiagagoano dolu nalo abinimei memedu ka Yesu, abika denio, aberinavo “Kumemi numisidom nuvijikia: ?Toro kei na mia naio jo mave loa tomu dolu nalo jouro ea Atua kiano navenatuboiano?” ");
INSERT INTO bki_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ana na Yesu bio kiritete tai ka rimei kean naio, naruei naio mila naio jumolu ju iviso kalo, ana naio ber ");
INSERT INTO bki_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Riano, kiniou neber ka kamiu memedu, verenio kamiu kuvilig re kamiu, ka kenemiu bajago nalo amei atavukia bajago na kiritete nei kiano, mia kamiu maka lele kuvijikia kumei jouro ea navenatuboiano na Atua kanano bogo tai. ");
INSERT INTO bki_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mia verenio toro na rila kanano jidomiano totano tavukia kiritete na telisu nei, mia naio mijikia rimei to mave loa, tovulu tomu dolu nalo nam̃a aju jouro ea Atua kiano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Toro na kiano jidomiano rivatove ka kiniou, mia naio saaro ka rive merevu van kiritete nalo na tertelisu na tai jibe na, nina jibe ka ga napano naio jom̃a jaaro ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mia Yesu berii bunu, berinavo “Mia verenio toro tai rila kiritete nei tai ka mia naio tuvan kiniou, riviekouo ea re bunu kiniou, mia toro nene naio rivokar vironiano na jikili laka tai. Verenio aiorikar puruveru na toru tai ea burujono, ana avukuio rivatove rimadudu ea bulu niogovu, nina naio be vironiano tai na monmaio ga, mia toro na naio rivokar rivan lie vo tovulu ninei. ");
INSERT INTO bki_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","!Banalo! Yetemeriba nei naio bova nonovio ruei, naio bujo ka saba nalo na ajum̃a amila lili tomu nalo ka mia m̃a nalo alaluvu kialo viekouoiano ea kiniou. Mia tiboliboiano nalo na mia atu iviso ka kamiu bogo nonovio, mia rivova laka van tomu nalo na abar tibol boiano va nalo na jibe na amei van kulo dolu nalo. ");
INSERT INTO bki_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","“A verenio jum̃amo, p̃elina jaamo, p̃elina miramo, p̃elina vite dolu venia bunu ea kiamo meuliano, verenio vite nalo nene tai rilaso koviekouo ea re bunu kiniou, bo ka jau ketelar vite nene denso, ana kovukuio rivano. A verenio jau ketelar bajago na kariano den kiamo meuliano tibe na, mia jau komijikia kava jouro ea meuliano, a verenio jau kava jouro ea meuliano napano jum̃amo, p̃elina jaamo, p̃elina miramo, p̃elina vite dolu venia bunu ea kiamo meuliano, verenio vite nalo nene tai rivakovio denso ruei, nina bo ga na. Mia bova laka ka verenio taniabemo momou vija kiamo bajago va momou atu rivu ga easo, mia karina avukuso kavan ea sebi na maka rijikia rivatove bogo tai ea vio na jogvaiano.” ");
INSERT INTO bki_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ana Yesu berii bunu, berinavo “Kamiu monokanio kuvitikar batitig kamiu rivu ka mia kamiu kuviakurano re ea kanaku kiritete nalo nei tai bogo tai. A ver makanio, ana mia kamiu kuvitikar kamiu, bior tete nalo nei abe kanaku, ana nalo abe kanalo nailiano nalo napano ajua vio mave, napano ajum̃a abitikar batitiglo, a nailiano nalo nene, nalo aju bogo nonovio ea Teta na joa vio mave mirano. ");
INSERT INTO bki_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Naruei Kulorinio Kenerinio, kiano im̃auano jibe na ga: naio binimei ka rilarur nalo na amilaluvu m̃arabo. ");
INSERT INTO bki_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kamiu kuviagago batitig ka tukunuano nei: Be toro tai napano be kiano nunu toromomou 100, mia nalo tai mila pariparinio ba koalabo, ana naio milaluvu m̃arabo. ?Mia toro nei naio rila tum̃abe naruei? Monokanio naio tuvan kiano nunu duelimo va koveri ba koveri 99 nalo nei, atu asinan ea vio na soro bo eaio, ana mia naio monokanio riva rila von ka sirag napano milaluvu m̃arabo a ba kovio tai. ");
INSERT INTO bki_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Riano ga kiniou neber ka kamiu, bogo napano naio mileal bereio nunu nene, mia naio mijikia saaro m̃ele kanio, tovulu napano naio jaaro ka kanano nunu dolu nalo napano telabo aju bo ga, maka avarlaka m̃ele ka mia ava kovio tai. ");
INSERT INTO bki_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","“Mia karamemiu na vio mave, naio bunu jibe na, naio maka sidom ka kiritete nalo nei tai rilaluvu m̃arabo riva kovio.” ");
INSERT INTO bki_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ana Yesu berii bunu, berinavo “Avena kuruamo rila vite rimemedu re vanso, monoka jau kava keial naio, kam ve juo ga kuvitu, ana jau koverial kiano vijuku vovaiano nene ka naio. Avena naio saaro ka rijog kanamo iliano nalo, nina jibe ka kanamo iliano nalo amila merevuiano ban kamjuo bereio ruei. ");
INSERT INTO bki_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mia ver naio maka sidom ka riagago ka kanamo iliano nalo, monokanio jau kava kovuru bereio tomu dolu tai amei vijaso, ka aijaso ka kanamo iliano, tavukia napano Niosi Lu berenio, berinavo ‘Iliano nonovio monoka ve ilitusoliano na tomu ve juo p̃elina ve tolu, ka mia iliano nei tu sikili tu.’ ");
INSERT INTO bki_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mia ver kuruamo neibano naio to riilkue ka riagago vatitig rivu kaso, mia monokanio jau koverial kanano siniabu van taara na namoneano nalo, ka nalo tealo amijikia amei aial naio. Mia ver naio jikili kia ga vo, ka naio riagago vatitig re ka nalo bunu, mia kamiu kuvial naio tibe ka valauo ga tai, p̃elina naio tibe ka tomu nalo napano ajum̃a abarbijii takis, maka tomu nalo ala bilbilu nalikolo leleio.” ");
INSERT INTO bki_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ana Yesu berii bunu, berinavo “Riano, kiniou neberii ka kamiu, mia verenio vite napano kamiu kuverbure ea yetemeriba nei, mia Atua na mave naio riverbureio bunu vija kamiu, mia verenio vite na kamiu kuvijamo ka ea yetemeriba nei, mia Atua na mave naio rijamo kanio bunu kamliko. ");
INSERT INTO bki_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A bereio, kiniou neber bunu ka kamiu, neber verenio tomu ve juo ea kamiu, naljuo ala ilivirakariano tai ea yetemeriba nei ka titai, ana verenio nalo abolkouo riviorio, mia Karam̃aku na mave mia naio rila tenene vanlo. ");
INSERT INTO bki_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bior ver tomu ve juo p̃elina ve tolu avior vio takurano ea siaku, mia kiniou bunu noto iviso kalo.” ");
INSERT INTO bki_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Naruei Pitere binimei mial Yesu, ana bika denio, berinavo “?Tubo, verenio kuruaku rila rivova van kiniou bogo nonovio, mia kiniou neviekokoa naio ve va vio? ?Monokanio riva rivokar ve va aluo, p̃elina jum̃abe?” ");
INSERT INTO bki_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mia Yesu berdop̃e banio, berinavo “Makanio, mia jau koviekokoa re naio rivokar ve va aluo ga, mia monokanio jau koviekokoa naio rivokar duelimo va aluo va aluo bereio 70 va 7. ");
INSERT INTO bki_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bajago na viekokoano jouro ea Atua kiano navenatuboiano, naio monokanio tibe ga na. Kamiu kuviagago ka tukunuano tai napano berii bajago na viekokoano napano berenio, berinavo: Parinio tubo tai, na naio jidom rivitii veve jabue nalo napano kiano tomu na im̃auano nalo amila jua naio. ");
INSERT INTO bki_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mia naio mila jibe na bano-o, na aburu kiano toro na im̃auano tai binimei ea naio, napano toro nei mila jabue na veru taam̃aka 1,000,000 vio ea kiano toro na toru nei. ");
INSERT INTO bki_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bogo napano abika veru den toro nei, ana naio berenio maka rijikia rivulu meran bereio jabue nene. Ana na toro na toru nei, naio ber ka kiano tomu nalo, berinavo ‘Mo, bo kanio kamiu kuvilalar naio, a kuṽiliṽili lario, ka naio ve toro na toru dolu kanano, naio riva rim̃au kurano ga ea naio. A aṽiliṽililar ka koano bunu, naliko kenerinio nalo, vija kialo saba nonovio, mo kuvar puruveru nene rimei ka avulu bulag ka kiano jabue nene togio.’ ");
INSERT INTO bki_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Naruei na toro nei naio mijoru kamu ea kiano parinio tubo nei jaano, ana naio jegi jouo banio, berinavo ‘Jau kobe parinio tubo, koig, mia kiniou nabaleaso ka nejidom kodu bogo ve telisu bereio van kiniou beamu vo, ka mia nala von ka navulu nonovio jabue nei denso.’ ");
INSERT INTO bki_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Naruei parinio tubo nei tinienmiia toro nei, ana naio biekokoa nonovio kanano jabue nei, ka mia naio rivulu kean re bunu, ana naio juvan toro nene bano. ");
INSERT INTO bki_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mia bogo napano toro nene naio bano, ana naio mial kiano bilbilu tai, napano bilbilu nene naio kiano jabue tai telisu ga jua naio. Mia naio ba bokar toro dolu nei, ana naio mikiti burujono, naio berkanio, berinavo ‘Monokanio jau kovulu bulag kanamo jabue na jua kiniou vonganei.’ ");
INSERT INTO bki_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naruei kiano bilbilu nei naio mijoru ea jaano, naio mila mirano melumu kanio, jegi banio, berinavo ‘Koig, mia kiniou nabaleaso ka nejidom kodu bogo ve telisu bereio van kiniou beamu vo, ka mia nemijikia ka novulu nonovio jabue nei denso.’ ");
INSERT INTO bki_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mia toro nei naio maka sidom riviekokoa kiano bilbilu neibano, naruei naio ba mila aburu naio ban ea nalakoiano, ka naio to rivano-o mia naio rivulu bulag nonovio jabue nei, karina naio mijikia taluvo bereio. ");
INSERT INTO bki_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mia bogo na parinio tubo nei kiano tomu tealo amial bajago nei, nalo amijog bova toru kanio, ana na nalo aban ea kialo parinio tubo nei, aberial saba nalo nonovio ban naio. ");
INSERT INTO bki_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ana parinio tubo nene, naio bio kiano toro neibano ka naio rimei bereio ea naio, ana naio mil jikili banio, berkanio, berinavo ‘!Aa, jau kobe toro va kitkiti tai! Kiniou nebiekokoa nonovio kanamo burum̃ara jabue nanua ruei, bior kejegi toru ban kiniou kanio, ana mila kiniou tinieku miiaso kanio. ");
INSERT INTO bki_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Mia jum̃abe ana maka kejikia tiniem riia bunu kiamo bilbilu dolu, tibe ka napano kiniou tinieku miiaso jukamu ruei?’ ");
INSERT INTO bki_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ana parinio tubo nene naio tinien mimi lie vo, ana naio berinavo monokanio avuku naio riva toa nalakoiano, a monokanio nalo atu avar vironiano vanio-o, rivokar bogo na naio rivulu bulag nonovio kanano jabue nene.” ");
INSERT INTO bki_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ana Yesu naio berinavo “A verenio kamiu kuviekokoa re kuruemiu nalo tulaka ve riano, ea iviso na tiniemiu momou nalo, mia karam̃aku na mave naio tinien ser kamiu tibe na, mia naio sian vironiano tibe ga na van kamiu.” ");
INSERT INTO bki_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bogo na Yesu berenio iliano nalo nei bisi, ana naio juvan vio Kalele naio bavin tivelinio ea tanobuku na vio Yutea, ea m̃arauei na Yortano tivelinio bano. ");
INSERT INTO bki_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ana tiniobi toru ajakisorio ka bogo na, mia ea vio na naio mila batitig tomu na mieiano nalo telabo abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mia Varisis nalo tai bunu ajua vio na, nalo abinimei amial Yesu ka ajidom ala von naio bereio, ana abika vikadeniano tai denio, aberinavo “?Kiado tuboiano berii vaio tivelinio ka bajago na toro mijikia titiglar koano? ?Memedu ga ka toro mijikia rila tibe na kar vite ninio ga, p̃elina mijikia rila kar ga vite na tortoru ga tai?” ");
INSERT INTO bki_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ana Yesu berdop̃elo, berinavo “P̃eli kamiu maka kuvijikia Atua kiano Iliano Lu na naio berenio, berinavo ‘Tikariano, Atua naio jii vite nonovio, a naio jii bunu kulorinio juo, napano tinene be sum̃ano a tinene be tira.’ ");
INSERT INTO bki_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tena kamiu kumijikia ruei, bija bunu iliano dolu na napano berinavo ‘Tibe na, toro tai rivuro den karam̃ano naio kenieno, riva rivijurukar koano, mia naljuo ave takurano.’ ");
INSERT INTO bki_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nina mila ana maka bunu ave juo, mia nalo abinimei abe takurano ga. Naruei vite napano Atua naio birokario, maka rivu ka kulorinio rilakorovio bereio.” ");
INSERT INTO bki_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ana Varisis nalo nei amijog iliano nei, ana nalo abika den Yesu bereio, aberinavo “?Bo ga, ana jum̃abe na Mosis naio berial tuboiano na jamoiano ka mia toro mijikia rudu m̃esi na silubariano tai rije van koano, ka mia naio mijikia titiglar naio rivano?” ");
INSERT INTO bki_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ana Yesu berdop̃elo, berinavo “Ee, ana mia beamu ka bogo na tiiano na yetemeriba naio maka tibe na, mia bior kamiu pariparimiu nalo binimei kirisikili laka, tenene na mila ana Mosis mijamo kanio jikar ea korobimiu nalo binimei, ka kamiu kumijikia kuvila titiglar kouemiu nalo tibe na. ");
INSERT INTO bki_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mia vonganei, kiniou neberii ka kamiu, ka verenio toro tai, koano naio rila siakaiano, mia toro nene mijikia rila titig koano nene. Mia verenio tira nene naio maka rila siakaiano, mia kiano sum̃ano nene naio titiglario, ana naio riva rivuru tira dolu, ver tibe na, Atua naio mial jibe ka toro nene naio mila siakaiano bija tira dolu nene ruei, naio milakiki tira nei napano be koano jukamu.” ");
INSERT INTO bki_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ana Yesu kiano naiagagoano nalo aber ka naio, aberinavo “Ver bajago na soriano jikili laka jibe na, bo laka ka kito rala re bunu soriano ka kito.” ");
INSERT INTO bki_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Mia Yesu ber kalo, naio berinavo “Nao, be riano ka napano be tomu tealo napano mia asoro re bogo tai, jibe ka napano tealo amiyotuba mia niabele nalo abova, p̃elina tealo napano amila bulag niabele nalo, jibe ka napano ajivivi nalo, naruei nalo maka ajikia asoro. Mia tomu tealo maka asoro bior ka napano nalo ajuvan soriano ga ka amim̃au jikili ka Atua kiano navenatuboiano. Mia Iliano Lu naio berinavo bo kanio sum̃ano a tira, ave juo asoro, a bo ka nalo ve juo atu rivu vija naljuo rivokar jukuti na kialo meuliano nalo ve juo. Mia jau napano jau kajaaro ka iliano nei, a napano jau komial ka napano Atua naio mila jibe na banso ruei, mia bo ka kovokar sikili iliano na ea kiamo meuliano.” ");
INSERT INTO bki_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Naruei nalo tai aburu kenerilo nalo abinimei ea Yesu, ka naio rudu jum̃ano toalo, a ka rivolkouo kalo. Mia kiano naiagagoano nalo amialio, ana nalo amil jikili ban tomu nalo nei, aberburelo, ");
INSERT INTO bki_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ana Yesu berii kalo, berinavo “Kamiu kuverbure re kiritete nalo nei, kamiu kuvituvanlo amei ea kiniou, bior kiritete nalo na nalo ajavukia nalo napano aju jouro ea navenatuboiano na Atua kiano.” ");
INSERT INTO bki_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ana naio midu jum̃ano joa kiritete nalo nei, iorou kanio, ana naio miel bano. ");
INSERT INTO bki_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ka bogoti dolu tai, m̃eaku tai binimei mial Yesu, ana naio bika denio, berinavo “?Naverloglogiano, mia monokanio kiniou nala im̃auano novo na vabe, ka napano mia rila kiniou nemijikia nejev meuliano na jo jobo jo?” ");
INSERT INTO bki_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ana Yesu berkanio, berinavo “?Jum̃abe ana kobika den kiniou jibe na, ka never im̃auano na bo tai vanso? Atua ga takurano naio bo, a verenio jau komonmonea kiano tuboiano nalo, ana mia jau komijikia kejev meuliano na bo nene.” ");
INSERT INTO bki_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ana na m̃eaku nei naio bika denio bereio, berinavo “?Ana jau kojom̃a koberii tuboiano nalo na vabe na?” Naruei Yesu berii kanio, berinavo “Tuboiano nalo nene nei naruei, napano aberinavo: jau kouebin re toro, jau kesiaka re siakaiano, jau kovina re, ");
INSERT INTO bki_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","jau kala sibi re, jau kotovon karam̃amo naio koniomo, mia kosidom tomu nalo napano aju vaataro kaso, jau kovitikar vatitiglo, tibe kanio napano jau kobitikarso.” ");
INSERT INTO bki_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ana m̃eaku nei naio ber ka Yesu, berinavo “Tuboiano nalo napano jau kojom̃a koberenio na, kiniou nojom̃a nobokario nonovio ruei. ?Mia vite venia bereio napano naio jo kiano vo, napano kiniou maka nalaio vo?” ");
INSERT INTO bki_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ana na Yesu berdop̃e banio, berinavo “Verenio jau kosidom ka komei komemedu rivu batitigio, rivare ka meuliano na jo jobo jo, mia jau kala tibe nei: jau kavano, koṽiliṽili bulagio ka kanamo saba nalo nonovio riviniu, ana mo jau kavar puruveru nene, kava kovioa ka talim̃asa nalo. Verenio jau kala tibe na, mia ve kanamo togogo novo ve toru ea vio mave. Mo, jau, kava kalaiio, karina jau komei katakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mia bogo napano m̃eaku nei naio mijog iliano nei, mia kiano iviso mijog bova toru, kiano jidomiano temi, bior naio kiano saba toru laka. Ana naio jaluvo den Yesu. ");
INSERT INTO bki_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Naruei Yesu ber ka kiano naiaga-goano nalo, berinavo “Riano, kiniou neber ka kamiu, verenio toro tai na kiano saba toru, mia naio sidom riva jouro ea navenatuboiano na Atua kiano, mia vite nene naio kirisikili kija na. ");
INSERT INTO bki_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nao, kiniou neber ka kamiu, verenio kamele tai naio riovo dulu ea bulu mirano nitil, nina kirisikili kija, mia verenio toro tai napano kiano saba toru, naio jidom ka riva jouro ea navenatuboiano na Atua kiano, nina kirisikili laka lie vo.” ");
INSERT INTO bki_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mo bogo napano naiagagoano nalo amijog iliano nei, nalo amiilo toru kanio, ana nalo aberinavo “?Tomnei, verenio tibe na, ana mia kei naio mijikia rijev meuliano nei?” ");
INSERT INTO bki_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mia Yesu jirarag bitikarlo, ana naio berinavo “Nao, riano ka kulorinio maka rijikia rila kulorinio rijev meuliano nei, mia Atua ga naio mijikia rila vite nalo nonovio.” ");
INSERT INTO bki_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naruei Pitere berdop̃e, berinavo “?Mia jum̃abe ka kumemi? Kumemi numituvan kenememi saba nalo nonovio ruei, ana kumemi nubinimei ka nuvitakisorso. ?Mia kumemi nuvijev kija vite nalo na abo tai, p̃elina makanio?” ");
INSERT INTO bki_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ana Yesu ber kalo, berinavo “Riano ga kiniou neber ka kamiu, bogo napano verenio Kulorinio Kenerinio totano ea kiano burum̃ara jobaro lu ea yetemeriba vou nene napano mia rimei, kamiu napano kamiu kumitum̃a kumitakisor kiniou vonganei, mia kamiu kuvitutano ea burum̃ara jobaro duelimo vaarakurano ba juo 12 ka kuve boru ka bajulukuti duelimo vaarakurano ba juo 12 na Israel, tibe ka kialo parinio tubo nalo. ");
INSERT INTO bki_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mia toro na verenio tuvan kunuano, p̃eli kuruano p̃elina kuvivinieno, p̃elina karam̃ano p̃elina kenieno, p̃elina kenerinio, p̃elina kiano borotano, mia verenio naio tuvan vite nalo nei rivior kiniou ga, mia naio mijikia rivar meran bereio ea yetemeriba nei, vite nalo napano juvanlo ruei, riva rivokar ve va duelimo toromomou, mia mave ka mia naio rijev meuliano na jo jobo jo. ");
INSERT INTO bki_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Mia tomu nalo telabo na aju mave, mia nalo atu tano, a tomu nalo na ajutano, mia nalo atu mave.” ");
INSERT INTO bki_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ana Yesu naio jo mil dolu ka ga bano, ana naio berinavo “Vite na kiniou neber vonganei, naio jibe ka bajago na Atua jom̃a mila ban tomu nalo na aju jouro ea kiano navenatuboiano. Mia kiniou never vite nei van kamiu ea jamerijiano tai, napano jibe ka: Toro na toru tai, napano naio be boru ka jiotilikrevi na toru tai. Mia kavijo tai, viomijeni mermeravo vonga, ana naio ban ea m̃arkomeli tai ka naio rivuru tomu tai ka ava aim̃au ea kanano jiotilikrevi ka legiano nei. ");
INSERT INTO bki_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Naio mial tai, ana naio berkar banlo ka puruveru tai na naio bare ka im̃auano na legiano vodolu tai, ana naio miila bulaglo ka ava aim̃au ea kiano jiotilikrevi nei. ");
INSERT INTO bki_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mia ka m̃erenio kover, ana naio ban bereio ea m̃arkomeli nei, ana naio mial tomu nalo dolu bereio, aju kurano ga, maka ve kialo im̃auano, ");
INSERT INTO bki_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","naruei naio ber kalo, berinavo ‘Bo ka kamiu bunu kumei kuvim̃au kija ea kanaku jiotilikrevi, mia kiniou novulu kamiu rimemedu ga.’ ");
INSERT INTO bki_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Naruei nalo nei aba amim̃au, ana iorou ka bereio, napano leri, a ea m̃erenio tolu kijev bunu, toro na toru nei naio ba buru tom tai ka aim̃au kanano tibe na. ");
INSERT INTO bki_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mia bogo tai bereio, ka m̃erenio jumo kijev ruei, ana naio ban bereio ea m̃arkomeli nei, ana naio mial tomu tai aju kurano ga ea vio nei kia ga vo, naruei naio ber kalo, berinavo ‘?Ka venia ana kamiu kumitu kumilakule legiano momou nei ea vio na, maka kuvim̃au tai?’ ");
INSERT INTO bki_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Naruei nalo nei aberdop̃e, aberinavo ‘Ana maka toro tai rimei rivio kumemi ka nuva nuvim̃au kanano tai.’ “Naruei toro na toru nei naio ber kalo, berinavo ‘Mo bo ga, ver tibe na kiniou novuru kamiu bunu. Kamiu, kumei kuvim̃au kanaku.’ ");
INSERT INTO bki_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mia kijev laka, ana toro na toru nei naio ber ka kiano boru na im̃auano, berinavo ‘Mo bo ga, jau kovio tomu na im̃auano nalo na amei, ana mo jau kovululo. Mia jau kala tibe nei: ketikar ea nalo na ajikar amim̃au iorou, rivano-o rivokar nalo na abinimei ajikar amim̃au jukamu kavijo.’ ");
INSERT INTO bki_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mia bogo na nalo na ajikar amim̃auka m̃erenio jumo abinimei, ana toro na naio bululo bare ka legiano takurano momou na im̃auano. ");
INSERT INTO bki_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mia bogo na nalo napano amim̃au jukamu abinimei ka avar kialo puruveru, aberiam̃a mia nalo avar rivavin tovulu nalo napano amim̃au ka bogo bulati ga, mia boru nei bar kialo vuluano banlo beverare ga. ");
INSERT INTO bki_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Mia bogo na nalo amial kialo puruveru jibe ga na, mia nalo aju abar lele kuluniolo, aju amil mum̃i die toro na toru nei. ");
INSERT INTO bki_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ana nalo amiila nalo tai ba bika denio, berinavo ‘Nalo napano abinimei vonganei, amim̃au ka aura takurano ga, mia kumemi numim̃auka legiano momou ea burutinianio nei. Mia kumemi numialio kobululo be verare ga ka kobulu kumemi. ?Vite na jum̃abe na?’ ");
INSERT INTO bki_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mia toro na toru nei naio berdop̃e banio, naio ber ‘Koig, kiniou maka nala lelanso. Kito juo robirokar jukamu ruei, roberenio mia jau koim̃au legiano momou ve takurano nei, mia kiniou novuluso rimemedu kanio. ");
INSERT INTO bki_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mo verenio tibe na, ana bo ka kodu puruveru na be kanamo ana kava vonuo ga. Nina be kiaku jidomiano tai jibe na naruei, ka puruveru na nemijev banso, kiniou nejidom nejev van nalo na abinimei maaro bunu tibe na. ");
INSERT INTO bki_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","?Jau koberiam̃a mia kiniou maka nejikia nala tibe ka napano kiniou nejidom ka kanaku puruveru? ?Jum̃abe ana jau komijoku ka tomu nalo na kiniou tinieku miialo?’ Ana jamerijiano nene maaro ea vio na.” ");
INSERT INTO bki_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ka Yesu rila nonovio kiano iliano nalo nei, naio berinavo “Ana tomu nalo napano nalo iorou, mia nalo atu kamu, a nalo napano aju kamu, mia nalo iorou.” ");
INSERT INTO bki_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ana Yesu naio jo bavin ea vio Yerusalemo naruei, ana bogo napano nalo aju amiel ea m̃arabo ka abano, ana naio bio kiano naiagagoano duelimo ba juo 12 nalo abinimei ea naio, naruei naio mil banlo, berinavo ");
INSERT INTO bki_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kamiu kuviagago vatitigio. Vonganei, kito roju rabavin ea vio Yerusalemo, ka mia vesiou re ga, ana adu Kulorinio Kenerinio toa parinio kulo lu nalo jum̃alo, a tomu na verloglogiano na tuboiano, ka mia atibure naio ka mia aver naio monoka rim̃aro. ");
INSERT INTO bki_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Karina mia adu naio toa kulo Romo nalo jum̃alo, ka mia ayotel va ea naio, avitiv naio, mia atukukakar naio ea m̃akolkolo ka mia naio rim̃aro. Mia bogo napano naio rim̃aro ribisi, bogoti ve tolu nene, ana mia Atua rila naio rimeul bereio.” ");
INSERT INTO bki_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Naruei Sepeti koano, naio buru kenerilo abe juo Yemesi naio Jone, abinimei ea Yesu. Naio minie yetano kamu ka Yesu jaano, naio bika denio, berinavo “Kiniou nejidom kajamo ka titai van kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Mia Yesu berdop̃e ban naio, bika denio “?Jau kojidom kovika vaio?” Mia tira nei naio berinavo “Kiniou nejidom verenio bogo na mia jau kovitirilar kanamo navenatuboiano, mia kenerimemi juo nei amijikia atutano vijaso ea kanamo vio lu na jo mave laka, ka mia tinene totano tivelinio vameruo, a tinene totano tivelinio mal.” ");
INSERT INTO bki_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mia Yesu berdop̃e banlo, berinavo “Kamiu maka kuvijikia tena mia kuvitum̃a kuvikanio na. ?Jum̃abe, kamjuo kuber kubare ga ka romunu bitiran ea baja na jaleleano na mia kiniou monokanio nomunu eaio?” Ana naljuo nei aberinavo “Ee, kumemi juo nubare.” ");
INSERT INTO bki_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mia Yesu naio berii ka tomu juo nei, berinavo “Mm, be riano ka kamjuo bunu kumunu ea kanaku baja na jaleleiano nene, mia tena kamjuo kubikanio na, ka mia kamiu kuvitutano rivija kiniou ea jum̃aku ve juo, nina maka ve kanaku ka mia nesian van kamjuo. Vio nalo na jibe na, abe nalo na ga karam̃aku mila batitig ruei ajurorealo, kanio napano naio berkar ruei banlo berii mia nalo atutano eaio.” ");
INSERT INTO bki_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bogo napano naiagagoano duelimo 10 dolu nene amijog vite na, mia nalo tiniel jer kurualo juo 2 nei. ");
INSERT INTO bki_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Naruei Yesu biolo ka amei ea naio ka naio ril vanlo, naruei naio berinavo “Kito romijikia ruei bajago na tomu nalo napano maka amonea Atua. Kito romial tubo nalo bija tomu na tortoru na yetemeriba nei, nalo ajidom avututua kulo dolu nalo ka atutano kalo tulaka ga. ");
INSERT INTO bki_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Mia kamiu kiaku naiagagoano nalo, kenemiu bajago tibe na re. Verenio kamiu tai sidom ka naio rimei ve toro na toru p̃elina naio rive kenemiu navurim̃araboiano, mia m̃arabo nene jibe nei: monokanio toro nene naio rimei tibe ka toro na rim̃au kenemiu tai. ");
INSERT INTO bki_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kulorinio Kenerinio naio mila jibe naruei, ka naio maka rimei ka mia tomu nalo ala im̃auano na ka mia aija naio, mia naio binimei ka rila im̃auano na ka mia naio rijailo, a kanio rijamo ka kiano meuliano ka rivulu bulag tomu nalo ve telabo.” ");
INSERT INTO bki_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka bogo nene Yesu naliko kiano naiagagoano nalo aju Jeriko, mia bogo napano nalo ajaluvo den komeli na, mia tomu nalo telabo laka ajakigsorlo. ");
INSERT INTO bki_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Naruei merebono juo, napano nalo ajutano ea ikim̃arabo. Mia bogo napano naljuo amijog ka tomu nalo aju amiolu juva aberinavo Yesu jo miel ea m̃arabo binimei, ana na naljuo abio jouo, aberinavo “!Tubo o, jau Teviti kiano bajulukuti, kumemi juo numisidomso tiniem riia kumemi!” ");
INSERT INTO bki_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naruei tomu nalo amil jikili banlo, aberinavo “Kuvuetuba re, tomjuo.” Mia tomjuo nei abio dolu ka ga, nalo abio jouo mave aberinavo “!Tubo, jau Teviti kiano bajulukuti, tiniemriia kumemi juo!” ");
INSERT INTO bki_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ana na Yesu naio jikil ju m̃arabo, ana naio bio tomjuo nei, naio ber kalo, berinavo “?Tomjuo, kamiu kumisidom ka kiniou nala tum̃abe ka kamjuo?” ");
INSERT INTO bki_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ana naljuo nei aber kanio, aberinavo “Tubo, jau kobijuku bo, kumemi juo numisidom ka mirememi rivu, ka mia nuvijikia ka nuvisirarago.” ");
INSERT INTO bki_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ana na Yesu tinien miialo, ana naio jokol tomu juo nei miralo, vaarakurano nalo amial vite nalo ea bogo nei, ana nalo ajumolu ajakisor Yesu abano. ");
INSERT INTO bki_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Vonganei, Yesu nalo aju abinimei vaataro ka Yerusalemo naruei, mia beamu kanio nalo amaluvo ea m̃arkomeli tai, siano Petevas, napano naio joa suku na aberii Suku Na Buruolivi. Naruei Yesu miila kiano naiagagoano naljuo nei, berinavo ");
INSERT INTO bki_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Kamiu kuvan ea m̃arkomeli yako, mia verenio bogo na kamiu kuva jouro eaio, mia kamiu kuvial togki tai amiadikario ju, naio ju bija kirikiti. Ana kamiu kuvijubar lario, ana kuvurulo amei van kiniou ea vio nei. ");
INSERT INTO bki_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Avena verenio toro tai ril van kamiu kanio, mia kamiu kumijikia kuverii kanio, kuverenio ‘Kiado tubo naio jidom temeul juo nei ka ala kiano im̃auano tai’ ana bogo napano kamiu kuver iliano nei, mia ve vaarakurano ga naio mijikia tuvan temeul juo nene van kamiu.” ");
INSERT INTO bki_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tena miyotuba jibe na ka rila iliano na naverialiano naio beriio nua ruei rimei rive riano, napano naio berenio, berinavo ");
INSERT INTO bki_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kamiu kuvio ka kulo Saion nalo, kuverinavo ‘Kuvialio, vonganei kenemiu parinio tubo naio jo binimei ea kamiu. Naio be toro tai napano kiano jidomiano melumu batove ga, mila naio midu togki ga, togki tai napano telisu ga, napano naio be tete kia ga vo.’” ");
INSERT INTO bki_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Naruei kiano naiagagoano juo nei abano, amila jibe ka napano Yesu berenio. ");
INSERT INTO bki_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ana bogo napano naljuo aburu togki nei bija kirikiti abinimei, naruei nalo abisi kanalo kulukoti ea togki juo nei taakalo, mia Yesu naio ba jotano mave ea na telisu nene. ");
INSERT INTO bki_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mia tomu nalo telabo abisi kanalo kulukoti nalo ea m̃arabo labo, a nalo tealo aje kokorov m̃am̃ali abar abinimei abue ka Yesu kiano togki mijikia riel ealo. Tibe na, jibe ka nalo amila ka nalo avatove ka Yesu, tibe kanio naio be parinio tubo na toru tai. ");
INSERT INTO bki_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ana nalo aju amiel ka ava jouro ea vio Yerusalemo, ana tiniobi toru aju kamu ka Yesu bija nalo na ajakisor naio, nalo aju abiovio jouo jibe nei, aberinavo Aiou bo mia bo laka “!Kito ravamenea naio napano be Teviti kiano bajulukuti nei! Atua Sop̃i, jau keilivu ka ninei napano naio binimei ea siamo. Kamiu napano ea mave laka, kamiu bunu kuvilivu ka naio.” ");
INSERT INTO bki_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mia bogo na Yesu naio ba jouro ea vio Yerusalemo, ana tomu nalo tinielo mudulo, amila iliano telabo, nalo aju abivika denlo aberinavo “?Toro na naio be kei?” ");
INSERT INTO bki_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mia nalo napano abinimei bija Yesu aberdop̃elo jibe nei, aberinavo “Nina naio be naverialiano napano naio maluvo ea m̃arkomeli na Nasarete ea vio Kalele, na naio siano Yesu.” ");
INSERT INTO bki_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ana na Yesu bavin ea Atua kunuano Lu, ana bogo nene naio mial ka be tomu telabo napano ajua m̃arsup̃iki na yimo nene. Nalo na ajum̃a amila im̃auano na avuru veru, nina ea tivelinio ea ijaiano a sida nalo na ea Yimo Lu nei, mia nalo ajum̃a amijukubin tomu nalo toru. Mia bogo na Yesu mial vite nei, naruei naio maka saaro ka leleio. Naruei naio ba mijil bulaglo, a naio javu bulag kialo barobaro nalo napano ajum̃a abar bereverei ka puruveru eaio, a naio buku bulag kanalo iesi nalo nam̃a ap̃iliṽili ka sibo. ");
INSERT INTO bki_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Naruei naio berii kalo, berinavo “Atua naio berenio ea kiano Iliano Lu, naio berinavo ‘Mia averenio Kunuaku Lu naio ve yimo na volkouano,’ mia kamiu kubilig lario ruei binimei be buluvae na tomu na vinauano nalo.” ");
INSERT INTO bki_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Naruei bogo na Yesu naio joa kia ga Atua Kunuano Lu nei vo, ana tomu na miralo bono a tomu na jaalo be kiri kokouro a javuluku milalo nalo abinimei ea Yesu, naruei naio milalo abo bereio. ");
INSERT INTO bki_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mia tomu na tortoru na kulo lu nalo kialo, naliko naverloglogiano na tuboiano nalo, amial Yesu kiano im̃auano novo nalo nei, a amijog bunu kiritete nalo ajum̃a abiovio kia ga vo, aberinavo “!Bo mia bo! !Kito ravamenea naio napano be Teviti kiano bajulukuti tanie!,” naruei tomu nalo na tortoru nei tiniel mimi toru. ");
INSERT INTO bki_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nalo tiniel mimi jibe na, ana aber ka Yesu, aberinavo “?Ei jum̃abe, jau komijog iliano nam̃a ajum̃a aberenio na?” Naruei Yesu naio berdop̃e banlo, berinavo “Ee, kiniou nomijogio kiana. Ana kiniou nemialio jibe ka maka leleio kamiu kuvuluku Iliano Lu na Atua kiano napano naio berenio, berinavo ‘Atua o, mia jau komijikia kala kiritete nalo, vija nalo na amidomudomu kia ga vo, avameneaso rivu.’” ");
INSERT INTO bki_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Naruei Yesu juvan nalo na, ana naio ban ea m̃arkomeli na telisu na Betani, naio ba monmelio ea vio na. ");
INSERT INTO bki_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mia Yesu monmelio ea vio na, mia viomijeni kavijo, ana naio jidom ka rivan bereio Yerusalemo, mia naio jo miel ban jibe na, mia naio mijog jijerio. ");
INSERT INTO bki_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ana naio mial buruviki tai ju ikim̃arabo, m̃ati telabo, mia maka m̃arati tai tuaio. Bior maka ve m̃arati tai tibe na, ana Yesu mil ban buruiesi nei, naio berinavo “Jau katakou re bunu bereio.” Mia bogo napano naio mil jibe na, vaarakurano ga buruviki nei naio mekekeu menoko nonovio. ");
INSERT INTO bki_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana kiano naiagagoano nalo amial buruviki nei naio menoko jibe nei, ana nalo amagmagodu toru, ana nalo abika den Yesu, aberinavo “?Vaio mila buruviki na menoko sop̃eli jibe na?” ");
INSERT INTO bki_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Naruei Yesu berdop̃e berii kalo, berinavo “Riano ga kiniou neberii ka kamiu, verenio kamiu kuvitu sikili ea kiniou, ka mia kenemiu jidomiano riveve juo re, mia kamiu bunu kumijikia kuvila tibe na, mia kamiu kumijikia kuvila bunu nana mave lie vo ka ninei. Verenio kamiu kuver ka burum̃ara suku na, ka naio tumolu tabujo rivan ea tei, mia naio rila tibe na. ");
INSERT INTO bki_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mia verenio kamiu kuvitu sikili ea Atua, ka mia kamiu kumonea riano, mia kamiu kumijikia kuvijev vaio napano verenio kamiu kubolkouo, kuvikanio.” ");
INSERT INTO bki_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Mia bogo na Yesu ban bereio jouro ea burusio na Atua Kunuano Lu, naio ba jo berloglog tomu nalo bereio. Mia parinio tomu na tortoru na kulo lu nalo bija navurim̃araboiano na Israel abinimei ea naio abika denio, aberinavo “?Jau kojom̃a komila saba nalo na ea kei siano? ?A kei naio mijamo ka banso ka jau kala tibe na?” ");
INSERT INTO bki_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ana Yesu berdop̃e berii kalo, berinavo “Mo kiniou bunu nejidom nevika vikadeniano tai bunu den kamiu. Ver kamiu kuverdop̃e kanaku vikadeniano, ana mo mia kiniou neverialio ka kamiu ka kei napano naio mijamo ka kiniou ka nala saba nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Mo kanaku vikadeniano jibe nei: ?Varueiano na Jone naio mila ban tomu nalo nanua, naio be tena Atua jian ban Jone ka naio mijikia rila, p̃elina tomu nalo ga aber kanio?” Yesu kiano vikadeniano mila nalo abilvilii ealo kanio, mia aberenio “?Mia kito rover tum̃abe ka naio? !Rovitikario! Verenio kito rover varueiano na Atua naio berii ka Jone, monokanio mia toro nei naio rivika kito river jum̃abe ana maka romonea Jone. ");
INSERT INTO bki_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mia maka rejikia rover varueiano na tomu nalo ga aberii ka Jone, ver tibe na p̃eli mia tomu nalo na mia nalo ala titai ka kito kovio na, bior nalo amonea Jone ruei ka aberenio naio be Atua kiano Naverialiano riano tai.” ");
INSERT INTO bki_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kialo jidomiano nalo jibe nei mila na nalo amiolu aber ka Yesu jibe nei ga, aber “Kumemi maka nuvijikiaio.” Naruei Yesu berenio “Mo bo ga, mia kiniou bunu maka nejikia neverial ka kamiu ka kei naio mijamo ka ban kiniou ka nala saba nalo nei.” ");
INSERT INTO bki_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ana Yesu berii bunu kalo, berinavo “Kamiu kuvisidomii von tukunuano nei. Toro tai kenerinio sum̃ano juo, naio berii ka motoru nene berenio ‘Keneriku, banei mia jau kava koim̃au ea kiado jiotilikrevi.’ ");
INSERT INTO bki_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ana tete nene naio berdop̃e berenio ‘Eau. Kiniou maka nosidomio.’ Mia iorou kanio, kiano jidomiano biligio, ana naio ba mim̃au jibe ka napano karam̃ano berkanio. ");
INSERT INTO bki_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mia karam̃alo nene naio jo jidomii berinavo mia kenerinio nei mia naio rivan re, naruei naio ba mial kenerinio maratoru nene, naio berenio iliano nei ban naio, naruei kiritete nei berdop̃e kirinovo ban naio berinavo ‘Bo ga, teta.’” ");
INSERT INTO bki_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ana Yesu bika denlo, berinavo “?Naljuo nei, na vabe nene naio mila jibe ka na karam̃alo jidomio?” Nalo aberdop̃e aberinavo “Motoru.” Ana Yesu berii kalo, berinavo “Tenene na. A riano kiniou neber ka kamiu, tomu na bova nalo jibe ka tomu na abarbiji takis, bija tire nalo na m̃arabo nalo, nalo naruei aju abinimei jouro ea Atua kiano navenatuboiano, aju abiliglo ruei, mia kamiu kumitu iorou maaro kalo ga ruei. ");
INSERT INTO bki_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bogo na Jone Baruei naio binimei nei, berloglog kamiu ka bajago na m̃arabo na memedu, mia tomu na bova nalo nei amonea naio. Mia kamiu bunu, kamiu kumial vite nalo nei, mia maka leleio kuvilig kamiu ve riano, ka kumonea naio leleio.” ");
INSERT INTO bki_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Mia Yesu mil kia ga vo, naio berenio berinavo “Kamiu kuviagago rivu ka jamerijiano dolu tai, napano berii toro na toru tai, bija kanano jiotilikrevi tai. Toro nei mila batitig kiano vio nei, mila siokoa tai jeriko nonovio jeliviv, a naio mim̃auka kanano vio tai ka rivie bulag vati m̃arkrevi, a naio mim̃auka bunu kanano burutili yimoliu tai ka avieii avavin atu mave ka asirarag kuku ka jiotilikrevi nei. “Mia bogo tai, ana toro na toru nei naio jidom riel kiki kija rivan ea buruvenuo dolu, ana naio juvan kanano jiotilikrevi ban kulo dolu nalo tealo, ka mia amei aim̃au eaio, ka mia avulu van naio. ");
INSERT INTO bki_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Naruei toro na toru nei naio ba jo laka o-o, karina naio mial ka vonganei bogo na m̃arati krevi meruo naruei. Ana naio miila kiano tomu tealo ka avan bereio ea nalo napano ajua jiotilikrevi na kanano nei, ka avar puruveru na krevi nalo nei togio napano tomu dolu nei monokanio avulu vanio kanio. ");
INSERT INTO bki_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mia bogo na kanano tomu nalo nei abinimei, tomu dolu nalo neibano amuelo, napano mia nalo tai abitivio, dolu nene ajukubin naio m̃aro, a dolu bereio ajubabinio ka puruveru m̃aro. ");
INSERT INTO bki_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Mia toro na toru nei naio miila kiano tomu dolu nalo bereio nalo telabo kija, mia nalo nei amila bere ga bajago nei kalo bereio. ");
INSERT INTO bki_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naruei toro na toru nei naio jo jidomii m̃elea kialo bajago nam̃a ajum̃a amilaio, ana naio berenio, berinavo ‘Monoka kiniou neiila keneriku garuei rimemedu ka naio rivano, monoka mia nalo avatove ka naio,’ ana naio miila kenerinio bano. ");
INSERT INTO bki_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mia bogo napano nalo amial naio, nalo aju aberverii kalo aberinavo ‘Nina naio be toro na toru kenerinio na kito rava roue bin naio rim̃aro, ka mia romijikia rodu jiotilikrevi na, mia rudu tibe ka karam̃ano kiano jajum̃ano ve kanado.’ ");
INSERT INTO bki_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Naruei nalo abano aba kakario kirisikili ana aburio ba tavio ka jiotilikrevi nei ana nalo amuebinio m̃aro.” ");
INSERT INTO bki_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Naruei Yesu bika berinavo “?Bogo napano toro na toru na jiotilikrevi nei naio rimei bereio, mia naio rila tum̃abe ka nalo na ajum̃a amim̃au ea kanano jiotilikrevi nei?” ");
INSERT INTO bki_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nalo aberdop̃e banio, aberinavo “Kulo va nalo na, mia toro na toru nei naio ruebinvinlo, am̃arm̃aro sel ea bajago na jogdedeiano tai. Iorou kanio, ana mia naio rudu kiano jiotilikrevi toa kulo dolu nalo jum̃alo, ka mia amijikia avulu van naio rimemedu ka bogo nene.” ");
INSERT INTO bki_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Naruei ana Yesu berii kalo berinavo “Ea Iliano Lu tai napano Atua kiano, be iliano tai jibe nei napano naio berenio ‘Puruveru na, tomu na amila yimo aberenio naio bova abukuio ban ruei, mia vonganei puruveru nene naio binimei be puruveru na bo tai ka bokar sudu na yimo ka rudukar yimo sikili rivu. Tena Atua na jo mave laka naio milaio, mia kumemi numialio bo laka.’ “?Mia kamiu iliano nei kamiu kubuluku bogo tai ruei p̃elina makanio vo?” ");
INSERT INTO bki_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Mia kiniou neberii ka kamiu, mia Atua rudular kiano navenatuboiano den kamiu, ana mia naio rudu van kulo dolu nalo na kialo meuliano nalo amijikia avar m̃arati novo nalo rivare ka mia amijikia atu jouro eaio. ");
INSERT INTO bki_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mia verenio toro tai rijoru ea puruveru nei, mia puruveru nene tiviniegeniege niabene, rivurboṽeio, p̃elina verenio puruveru nei rijoru mave ea toro tai, mia puruveru nene tuba kitkiti toro nene mia rim̃akitkit vatitigio.” ");
INSERT INTO bki_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mia bogo napano kulo lu nalo nei naliko Varisis nalo amijog Yesu kiano jamerijiano nalo nei, mia nalo amijikia ka naio jo beriilo ga. ");
INSERT INTO bki_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mia bogo napano nalo ajidom ka avokar naio, mia nalo amerou ka tomu nalo, bior tomu nalo amonea naio ruei ka naio be Atua kiano Naverialiano tai. ");
INSERT INTO bki_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Naruei, Yesu mil ka jamerijiano banlo bereio, naio berinavo ");
INSERT INTO bki_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Atua kiano bajago na jom̃a bio tomu nalo ka amei jouro ea kiano navenatuboiano, naio jibe nei: Parinio tubo tai napano naio mila batitig sinaniano na toru tai ka rila jokoluolu na soriano ka kenerinio. ");
INSERT INTO bki_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Naio miila toru ka tomu nalo telabo ruei ka atu rorea ka mia nalo amei ea jokoluolu nene, mia bogo napano naio miila kiano atevi nalo ka avuru tomu nalo nene amei, mia tomu nalo nei maka bunu asidom ka amei. ");
INSERT INTO bki_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Naruei parinio tubo nei ber ka kiano atevi dolu nalo, berinavo ‘Kamiu kija kuvan bereio, kamiu kuverii kanaku iliano nei vanlo, kuverenio romue buluku ruei bija temeul dolu nalo napano amijabojabo bo, mia saba nonovio na sinaniano nei biniu ju batitig bo ruei. Kuver kalo monokanio nalo amei aiasol kito ea jokoluolu nei.’ ");
INSERT INTO bki_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ana nalo abano aberii kalo jibe nei, mia nalo nei amiakurano ea ga parinio tubo nei kanano iliano, aju amila ga kialo jidomiano nalo. Tai bavenei ea kanano tiniavio, mia dolu jo bitikar kiano yimo na ṽilṽiliano, ");
INSERT INTO bki_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","a nalo tealo abakakar parinio tubo nei kiano atevi nalo, amila lelanlo, amuebinvinlo am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Naruei parinio tubo nei naio tinien mimi toru, ana naio miila kiano tomu nalo na mira nalo abano, amuebinvin kulo va nalo napano amisebi kunualo a kialo komeli bunu. ");
INSERT INTO bki_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Naruei parinio tubo nei naio berii ka kiano atevi nalo, berinavo ‘Sinaniano nei ju batitig bo ruei, mia nalo na kiniou nobiolo ruei ka amei avijurukario, nalo maka bunu avu ka amei, mia kito rotuvanlo. ");
INSERT INTO bki_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kiniou nejidom kamiu kuvitakii m̃arabo sesa dolu nalo mia toro kei napano verenio kamiu kuvilealio, mia kamiu kuvikalo ka nalo amei ea jokoluolu nei.’ ");
INSERT INTO bki_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Naruei kiano atevi nalo nei abano, nalo amila jibe ka napano naio berii kalo, ana aburu tomu nalo abinimei, bekurano ka tomu nalo na abo p̃elina nalo na abova, nalo amei tibe ga na, ka nalo aison vatitig vio na jokoluolu nei rivujo. ");
INSERT INTO bki_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mia bogo napano nalo aju jouro ea vio nei ruei, mia parinio tubo nei naio binimei ka rivanjum̃ano nalikolo, mia ka bogo na naio mial toro tai napano naio maka riya kulum̃arauo na bo tai napano beverare ka jokoluolu nei, mia naio miya kulum̃arauo p̃ilip̃ili ga. ");
INSERT INTO bki_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Naruei parinio tubo nei naio bika den toro nei, naio berinavo ‘?Koig, jum̃abe ana jau kobinimei joomo nei, ana maka keya m̃amo kulum̃arauo na bo na jokoluolu nei tai?’ Mia naio niono buru maka bunu rijikia river titai. ");
INSERT INTO bki_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Naruei parinio tubo nei naio ber ka kiano atevi nalo, berinavo ‘Kamiu kuviorkar jum̃ano ve juo a nalo ve juo, ana kuvuku naio riva tavio, ea vio na melijokouo, ea vio na mia naio to teg tulaka a naio ser m̃arjuvono eaio.’” ");
INSERT INTO bki_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ana na Yesu berenio, berinavo “Atua bio tomu nonovio, mia maka ve telabo napano naio bijauialo ka nalo ave kiano.” ");
INSERT INTO bki_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naruei Varisis nalo abano ka alavon ka aleal vikadeniano nalo na jikirkili tai ka alavon Yesu eaio, ka napano mia naio rijikia re ka riverdop̃elo eaio. ");
INSERT INTO bki_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bogo na aberio-o bisi, ana amiila kialo naiagagoano tai, naliko kulo dolu nalo na taara na Erot kiano, abinimei ea Yesu. Ana nalo nei amijubolbolili ka ilisibiano novo nalo, aberinavo “Yesu, kumemi numijikia ka jau kobe naverloglogiano, jau kobe toro na memedu tai. Kiamo iliano nalo abiniu abe riano, a jau kojo koberloglog tomu nalo ka bajago nalo na Atua naio jidomio. Mia jau maka kejikia kovitii ga tomu tai, mia jau kobitii tomu nalo abiniu abe verare ga. ");
INSERT INTO bki_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","?Tenene na, kumemi numisidom jau kover von ka kumemi, ka ea kiado tuboiano, naio berii jum̃abe? ?Memedu ka kito kulo Ju nalo rovulu takis van Sisa, napano parinio tubo na vio Romo, p̃elina maka rimemedu ka tibe na?” ");
INSERT INTO bki_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mia Yesu naio mijikia ka nalo ajidom ala kiki naio ga, ana naio berenio “Kenemiu iliano nalo kirinovo mia kirinovo, mia kenemiu iviso nalo kirivova joono ruei. ?Kamiu kumitu kumila von kiniou jibe na ka venia? ");
INSERT INTO bki_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mo bo ga, kamiu kuvudu puruveru na takis tai rimei van kiniou.” Naruei nalo amidu tai binimei ban naio, ");
INSERT INTO bki_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ana na Yesu bika denlo, berinavo “?Kei mirano nei joa puruveru nei? ?A sio nei be kei siano?” Ana nalo aberenio, aberinavo “Sisa mirano na a siano na bunu.” ");
INSERT INTO bki_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Naruei naio berii kalo, berenio “Mo, vite napano be Sisa kanano, kuvar van Sisa. Mia vite napano be Atua kiano, kuvar van Atua.” ");
INSERT INTO bki_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bogo na nalo amijog iliano nei, nalo amiilo toru kanio, ana nalo ajuvan Yesu ajaluvo den naio abano. ");
INSERT INTO bki_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ea bogoti nene ga, kulo Satusis nalo tai abinimei ea Yesu, nalo ajidom avika naio ea tivelinio na vite napano nalo amonea jikili ea naio, napano nalo amonea aberinavo tomu nalo na am̃arm̃aro maka bunu ajikia ameul bereio ea bogo na tagap̃iano. Ka tenene, nalo abika Yesu jibe nei, aberinavo ");
INSERT INTO bki_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Yesu, jau kobe naverloglogiano, kumemi numisidom nuvika denso, ka jum̃abe ka iliano tai napano tormoruo Mosis naio berenio jukamu nua ruei. Naio berinavo ‘Verenio toro tai rim̃aro den koano, maka ve kenerilo tai vo, mo kuruano monokanio soro ka taanou nene. Ea bajago na, mia naljuo ve kenerilo ka mia rivokar toro na m̃aro ruei siano.’ ");
INSERT INTO bki_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naruei ea kenememi m̃aratavo tai, tomu aluo napano abe kurualo. Motoru nene naio joro, karina naio m̃aro den koano napano maka ve kenerilo tai, ana kuruano maratoru naio buru tira nene. ");
INSERT INTO bki_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Naruei, kuruano na toru naio bunu m̃aro den tira neibano, a nana lieie kaniao jibe na bunu, bano-o bokar kurualo aluo, nene abiniu amila bajago takurano ga. ");
INSERT INTO bki_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mia iorou kalo abiniu am̃arm̃aro tira nei bunu m̃aro. ");
INSERT INTO bki_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naruei kumemi numisidom jau koverial van kumemi vite nei: ea tagap̃iano, bogo napano aberii tomu nalo ameul bereio, mia tira nei ve kei koano, bior naio joro ruei ka kurualo aluo nei abiniu?” ");
INSERT INTO bki_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Naruei Yesu berenio “P̃eli ga, kenemiu jidomiano jokoro, bior kamiu maka kuvijikia vaio napano Atua kiano Iliano Lu naio berenio, a kamiu maka kuvijikia vaio napano kiano moroano na toru naio mijikia rilaio. ");
INSERT INTO bki_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bogo napano tomu nalo ameul bereio, mia atibe ka nailiano nalo na mave ga, mia bajago na soriano naio maka bunu. ");
INSERT INTO bki_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Ana ea tivelinio na meuliano bereio nei, be Atua kanano Iliano Lu tai naio jo napano naio mijikia rijai kito ea vio nei, p̃eli kamiu maka kuvulukuio vo? Iliano na naio berenio jibe nei berinavo ‘Kiniou nebe Epraamo a Aisak a Yakovo kialo Atua.’ ?Ana iliano na naio berenio venia? Nalo tolu nei am̃aro ea yetemeriba nei bogo be nua ruei, ana yuka telabo barlaka ana Atua berii vonga iliano nei, ka naio be kialo Atua. Jibe na, ana kanano iliano nei naio jiloglog ka nalo tolu nei am̃aro ea yetemeriba, mia nalo aju ameul ea naio kia ga vo. Atua maka sidom ka kanano tomu nalo ave tomu na am̃arm̃aro ga, mia naio jidom ka naio rive Atua na tomu nalo na ameul.” ");
INSERT INTO bki_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ana bogo napano tiniobi nalo amijog Yesu kiano iliano nei, nalo amiilo toru ka vite nalo nei napano naio jom̃a berlogloglo kanio. ");
INSERT INTO bki_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Telikiti napano Varisis nalo amijog ka Yesu mila Satusis nalo maka bunu ajikia aver titai, ana nalo abior telisu beamu vo karina abinimei ea Yesu, nalo bunu ajidom ala vonio. ");
INSERT INTO bki_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Naruei nalo tai napano naio be masou ka Tuboiano, naio bika vikadeniano tai den Yesu, berinavo ");
INSERT INTO bki_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“?Naverloglogiano, kiniou nejidom ka jau koverial von, ka ea iliano nonovio napano ajua kiado Tuboiano, na vabe nene napano naio toru, jo mave jovulu dolu nalo?” ");
INSERT INTO bki_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ana Yesu ber ka toro nei berinavo “Iliano Lu berenio jibe nei, berinavo ‘Atua Sop̃i napano be kanamo Atua, jau monokanio kosidom naio ka tiniemo momou, ka kiamo meuliano momou, ka kiamo jidomiano momou.’ ");
INSERT INTO bki_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nina naruei napano naio be tuboiano na be moti, a toru laka bunu. ");
INSERT INTO bki_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A tinene kanio, napano naio toru bunu jibe ka napano jukamu nene, na naio berenio, berinavo ‘Mia jau monokanio kosidom tomu nalo napano aju vaataro kaso, kala rivu vanlo, rivare ka napano jau kojidomiiso.’ ");
INSERT INTO bki_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tuboiano juo nei, nalo abe burupati na tuboiano dolu nalo nonovio napano Mosis kiano, bija Naverialiano nalo kialo iliano bunu, napano ajua kiado Niosi Lu nei.” ");
INSERT INTO bki_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Naruei ka bogo nei mia Varisis nalo aju vio takurano naliko Yesu, ana naio bunu bika vikadeniano tai denlo, berinavo ");
INSERT INTO bki_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Ea kenemiu jidomiano nalo aberenio mia Naverikariano rimaluvo ea kei kiano bajulukuti?” Mia nalo aberii kanio, aberinavo “Naio ve tormoruo parinio tubo Teviti kiano bajulukuti tai.” ");
INSERT INTO bki_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","Naruei Yesu bika bereio denlo, berinavo “?Ee, kamiu kuber riano ga na, ana jum̃abe ana Niununo Lu joa Teviti, naruei Teviti mil, berenio ‘Atua Sop̃i naio berkanio kiaku Tubo, naio berinavo “Jau koto tano tivelinio vameruo ka kiniou, rivano-o mia kiniou nala kiamo uolu nalo amei atibe kanio yebe sesa na kobijankon jaamo eaio.” ’ “Ea vio na naruei, kito romialio ka napano Teviti naio jo bio naveri-kariano nene berinavo naverikariano naio be kiano Tubo ruei. ");
INSERT INTO bki_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","?Mia bior Teviti naio berii jibe na, jum̃abe ana kamiu kumitum̃a kuber Naverikariano nei naio miyotuba ea Teviti, ana naio be kiano bajulukuti tai ga?” ");
INSERT INTO bki_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Naruei maka toro tai rijikia river iliano tai van Yesu. Mia jikario ea bogo na, mia maka bunu toro tai rijikia rila von Yesu ea navikadeniano nalo. ");
INSERT INTO bki_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mia ka bogo na, ana Yesu mil ban tiniobi, naliko bunu kiano naiagagoano nalo, naio berinavo ");
INSERT INTO bki_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Be riano ka vonganei, naverloglogiano na tuboiano a Varisis nalo, nalo amidu Mosis jeleigio kam̃a aberial nioti na tuboiano na Atua kanano. ");
INSERT INTO bki_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mo verenio tibe na, ana tenene na kamiu monokanio kamiu kumonmonealo, kamiu kuvila tibe ka napano nalo aberenio. Mia kamiu kuvitakii re kialo bajago, bior nalo maka atum̃a ala tenalo nam̃a aju aberiio ka tomu dolu nalo. ");
INSERT INTO bki_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nalo aju aburonkar bereio tuboiano sesa nalo telabo na nalo ga amilaio, amila jikili laka, mia nalo ajutua tomu nalo ka aiagago kalo. A nalo aju amila im̃auano na jibe na ka nalo ajum̃a amison vite nalo na kiri teremi nalo laka ban tomu nalo, mia maka leleio asaaro ka aija tomu nalo ka avar bitiran vite nalo nene. ");
INSERT INTO bki_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Nalo abarvar kalo m̃ele ka kialo im̃auano nalo, napano nalo amila jibe na ka mia avuru ga tomu dolu nalo miralo. Kamiu kuvial kialo bulusiveu nalo na amison Atua kiano Vivitauiano Lu juaio, ka mia m̃a amiorkario jua merinialo a mokojum̃alo nalo. Nalo ajidom ka kanalo monokanio ve tortoru loa tomu dolu nalo kanalo. Mia kamiu kuvial bunu ka abili iki m̃alo kulukoti na volkouano nalo terebievi laka. A abavavin m̃ele ka vite nalo nei, a ajidom ga ka tomu nalo avamenealo riviorio. ");
INSERT INTO bki_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ana ea bogo na jokoluolu a joomo ea yimo na volkouano bunu, nalo ajidom ka mia bogo nonovio nalo atutano ea tomu na tortoru nalo jelelo, ");
INSERT INTO bki_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","a verenio nalo aiel ea vioruru, mia nalo ajidom tomu nalo avatove kalo, a avio batitiglo averinavo ‘!Nao, kiaku naverloglogiano novo, kavijo bo o!’ ");
INSERT INTO bki_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mia kamiu, kenemiu naver loglogiano takurano ga naruei, a kamiu kumitibe ka m̃aratavo takurano ga, mia verenio tibe na, kamiu kuvijamo ka re tomu nalo ka mia m̃a avio kamiu tai ka ‘Naverloglogiano.’ ");
INSERT INTO bki_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ana mia kamiu kuvio re toro na yetemeriba nei tai ka teta, bior kamiu be karamemiu takurano ga, napano naio jo mave. ");
INSERT INTO bki_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A mia kamiu kuvijamo ka re tomu nalo avio kamiu tai aver kube navurim̃araboiano na kialo bior kamiu kenemiu navurim̃araboiano takurano ga, naio napano be Naverikariano. ");
INSERT INTO bki_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mia toro napano naio be kenemiu toro na toru laka, mia monokanio naio rimei ve kenemiu toro na im̃auano ga. ");
INSERT INTO bki_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mia toro na naio ga bitirilar naio ka naio to mave, mia Atua rila naio to yetano. Mia verenio toro napano naio ga rila naio to yetano, mia Atua rivitirilar naio to mave.” ");
INSERT INTO bki_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ana Yesu mil dolu ka ga banlo, berinavo “!Kamiu Varisis nalo kamliko naverloglogiano na tuboiano, o-o! Kamiu kumila lelan kamiu toru laka, mia ve kirivova laka van kamiu, kanio kenemiu iliano nalo kirinovo, mia tiniemiu nalo abova, ajoron ruei. Tomu nalo ajidom amei jouro ea Atua kiano navenatuboiano, mia kamiu kumitu kumitetavoko morouo kalo ea miralo, ka mia nalo ajikia re ka amei jouro, mia mave kanio, kamiu bunu maka kuvitu kumei jouro. Kamiu kubova ruei. Kamiu kumitum̃a kuburu kenemiu volkouano nalo terebievi laka, mia be sibiano ga, bior ka bogo nene ga mia kamiu kumitum̃a kumijubolibo lili taanou nalo nei, kam̃a kubina ka kialo saba nalo. Bior tena, mia kenemiu tibureiano sikili lie vo. ");
INSERT INTO bki_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","15","“!Kamiu Varisis nalo kamliko naverloglogiano na tuboiano, o-o! Kamiu kumim̃au bova ga. Kamiu kumisaaro ka kuviel ea uako, ka kuvan ea buruvenuo dolu nalo ka kuvuru tomu nalo atakisor kamiu, mia bogo napano kamiu kubokar tai binimei, mia maka vesiou, mia naio bokar nonovio kenemiu bajago va nalo ba bova laka, bova jovulu kamiu bereio. ");
INSERT INTO bki_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Kamiu navurim̃araboiano nalo, kamiu miremiu bono ga. Mia kumila lelan kamiu laka, mia rivova laka van kamiu. Ea bogo napano tomu nalo aber titai ka rila kialo verikariano tu sikili, mia ver averenio ‘Kiniou neber riano, Atua kunuano Lu yako jo,’ a karina, ala korov verikariano nei bereio, ana kuberenio ‘Nina maka ve titenia.’ Mia verenio averinavo ‘Kiniou neber riano, niogo nalo na ajua Atua kunuano Lu joomo, nalo na aju,’ mia kamiu kuber iliano na naio jikili laka, maka ajikia ala korovio bereio. ");
INSERT INTO bki_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aire tomu nalo, kamiu miremiu bono, a pariparimiu nalo amiavovu. ?Venia napano naio be lu laka: niogo nalo, p̃elina Atua kunuano Lu napano naio mila niogo nalo abe lu? ");
INSERT INTO bki_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mia verenio toro tai riverenio ‘Neber riano, boda naio yako jo,’ kamiu kuber iliano nei be kurano ga. Mia verenio naio riverenio ‘Kiniou neberii riano, sida na naio joa boda,’ mia kamiu kuber iliano nei jikili laka, toro tai maka rijikia rilakorovio. ");
INSERT INTO bki_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!Jibe kanio napano neberiio ruei, kamiu kube merebono riano! ?Venia naio be lu laka: sida napano joa boda p̃elina boda na mila sida nei be lu? ");
INSERT INTO bki_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Monokanio kamiu na kuvitilubar vite nalo nei, bior verenio toro tai naio jo jiloglog boda ka rila kiano iliano nei tu sikili, mia naio jo jiloglog bunu bija sida napano joa boda nene. ");
INSERT INTO bki_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A toro napano ver jom̃a jiloglog ban ea Atua kunuano Lu, naio jo jiloglog bunu bija nana naio be kanano yimo nene, ");
INSERT INTO bki_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ana toro na jom̃a jiloglog mave, naio jom̃a jiloglog bunu bija jobaro lu na Parinio tubo lu na toru kanano, tenene naio jom̃a jiloglog Atua garuei memedu. ");
INSERT INTO bki_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Kamiu naverloglogiano na tuboiano kamliko bunu Varisis nalo, o-o! Kamiu kumila lelan kamiu toru laka, mia rivova laka rivan kamiu. Kiniou nemijikia napano kamiu kumitum̃a kubitii bo julaka, ka verenio mia kuvar semiu sinaniano ve duelimo, mia ve takurano monokanio rivan ea Atua Kunuano, tibe ka napano tuboiano naio jom̃a berenio, a kamiu kumitum̃a kumila jibe na ka kenemiu saba nonovio nalo, rivano-o rivokar bunu m̃am̃esi na kiritavarvasu nalo a vite nalo bunu napano javukia m̃arsili nalo. Mia vite tomormoruo nalo napano tuboiano naio berenio, kamiu maka kuvisidomial leleio, tibe ka napano naio berenio berinavo kamiu kumemedu rivu, a kamiu monokanio tiniemiu riia kulo dolu nalo, monokanio kamiu kuvokar kenemiu verikariano. Verenio kamiu kuvisidom kuvokar sikili vite nalo na kiritavarvasu, naio bo ga, mia vite nalo na tomormoruo nei naruei bo ka kamiu kuvitum̃a kuvilaio garuei, ana makanio. ");
INSERT INTO bki_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“!Aire tomu nalo, kamiu navurim̃araboiano nalo, kamiu miremiu bono ga! Kamiu kumitum̃a kumila jibe na kanio napano bogo na ana kamiu kumunu saba, mia kamiu tiniemiu maio jikili ka mia kuvilaluvu re ka kuviovolar nionono tai napano mijoru batove ea kenemiu baja nalo, mia kamiu maka kuvial kar ka kumdidiomo belia kamel napano joaio. ");
INSERT INTO bki_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Kamiu naverloglogiano na tuboiano bija Varisis nalo bunu! Kamiu kumila lelan kamiu toru laka, mia rivova laka rivan kamiu. Kamiu kumitum̃a kumitakii vatitig tuboiano nalo napano kiritavarvasu nalo tivelinio ka sekoniano na kenemiu baju a baja nalo, naruei kamiu kuberiam̃a kenemiu vite nalo nonovio ameravo bo ruei. Mia kenemiu baju nalo nei abujo ka sinaniano na vinauano napano kamiu kubario ea bajago na yebekavoano. ");
INSERT INTO bki_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamiu Varisis nalo, kamiu miremiu bono riano. Verenio kamiu kuvisidomii ka kenemiu baju a baja nalo ameravo rivu bogo nonovio, mia kamiu kuvisonlo re bunu ka sinaniano nalo napano kenemiu kariano juaio. ");
INSERT INTO bki_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Kamiu naverloglogiano na tuboiano bija Varisis nalo, o! Kamiu kumila lelan kamiu toru laka, mia rivova lie vo van kamiu. Kamiu kumitavukia m̃artanbo napano amiovovua miuvu meravo kirinovo bo jel tavio, mia vajoomo nene naio bujo ka buriu na tomu nalo napano am̃arm̃aro, bija mokotenalo napano ajorono. ");
INSERT INTO bki_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jibe na, bogo na tomu nalo aial tavio na kamiu, mia nalo amijikia averenio kamiu kumemedu bo, mia makanio, vajoomo na kamiu bujo ka juboluboiano a kariano nalo. ");
INSERT INTO bki_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Kamiu naverloglogiano na tuboiano nalo bija Varisis nalo! Kamiu na bogo nonovio kumil ka kuluniomiu ga. Mia rivova lie vo van kamiu kenemiu jidomiano nalo beve juo. Kamiu kumitum̃a kubitikar vatitig m̃artanbo na naverialiano nalo re nua, a kamiu, kumiovovua bo bunu puruveru na sidomkariano na tomu memedu nalo, ana jum̃abe: ?Kamiu kuberiam̃a kumemedu kamliko nalo na a? ");
INSERT INTO bki_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mia kamiu kumitu kuberinavo verenio kamiu kumeul nua ruei ea bogo na korobimiu nalo, mia kamiu maka kuvijikia kuvijurukar nalo na ka bogo napano nalo amuebinvin Atua kiano naverialiano nalo re nua. ");
INSERT INTO bki_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mia ea kenemiu ilisibiano nei, kamiu kumitum̃a kumil lelan kamiu bereio ga, bior iliano napano berial ka kamiu kube bajulukuti memedu na korobimiu nalo na amuebinvin naverialiano nalo. ");
INSERT INTO bki_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mo bo ga, kamiu kuvim̃au bo ka rivano-o, kamiu kuvila von ka kuvila nonovio im̃auano na korobimiu nalo nei ajikario nanua bogobe ruei.” ");
INSERT INTO bki_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Naruei Yesu mil jikili kia ga banlo, naio berinavo “Kamiu kumitibe ka maro nalo garuei memedu. ?Kamiu kuberiam̃a mia kumijikia kuvuro ka kenemiu vironiano na ea vio na jogvaiano? !Maka leleio! ");
INSERT INTO bki_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Verenio mia kiniou neiila naverialiano nalo aviedu, vija tomu napano abe masou bo ka Atua kiano iliano nalo, a vija bunu naverloglogiano na tuboiano nalo, verenio aviedu ea kamiu, mia kamiu kuvuebinvin tealo am̃aro ea m̃akolkolo, a tealo mia kamiu kuvitivlo ea kenemiu yimo na volkouano nalo, a mia kuvijili bulaglo ea kenemiu m̃arkomeli nalo. ");
INSERT INTO bki_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mia kamiu kuvila tibe na kalo dam̃ariga rivano-o, mia kamiu naruei kuvokar vironiano na m̃ariano na tomu na memedu nalo nei aviniu napano korobimiu nalo nanua amuebinvinlo. Tenei jikar ea Epel, na naio maka rila titai napano tokor leleio, binimei bokar Sakaraia, na Parakaia kenerinio, naio napano korobimiu nalo amuebin naio jo vaataro ka boda, joomo ea Atua Kunuano Lu. ");
INSERT INTO bki_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Riano kiniou neberii ka kamiu, mia vironiano na m̃ariano na tomu nalo nei, mia rivokar kamiu, napano kumeul kia ga vo vonganei.” ");
INSERT INTO bki_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ana Yesu jegi bior Yerusalemo, ana naio berinavo “!Yerusalemo-o, Yerusalemo-o! ?Bior vaio ana kojom̃a komuebinvin naverialiano nalo, a kojuba binvin nalo napano Atua miilalo abiedu easo? Va telabo kiniou nejidom nodu jum̃aku selvivko kiamo tomu nalo, tibe ka tu sabarou buru kirikiti nalo abinimei ajuluku ea sibiano, mia kiamo tomu nalo maka asaaro ka kiniou. ");
INSERT INTO bki_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jau, komial na, Atua jo juvanso naruei, mia jau komei kove vio yauo kurano ga naruei. ");
INSERT INTO bki_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tenene na neber ka jau, mia kiamo tomu nalo aial re bunu kiniou bereio, rivano-o rivokar bogo napano mia nalo averenio bereio tenei, averinavo ‘Atua Sop̃i, jau keilivu ka ninei napano naio jo binimei ea siamo.’ ” ");
INSERT INTO bki_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ana Yesu batavio den Atua Kunuano Lu, mia bogo na naio miel bano, kiano naiagagoano nalo abinimei ana nalo ajiloglog yimo tomormoruo nalo napano aju jouro ea burusio na Atua Kunuano Lu, mia abo laka, ana aberii ka Yesu ka naio siraragdi rialo. ");
INSERT INTO bki_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mia Yesu naio berii kalo, berinavo “?Kamiu kumial yimo nalo na? Riano kiniou neber ka kamiu, yimo nalo na, mia ve re bunu puruveru nene tai totano vatitig ea jeleigio, bior mia tomu tai amei aue bulagio nonovlo.” ");
INSERT INTO bki_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Telikiti na nalo amiel jibe ga na, nalo abinimei ea Suku Na Buruolivi, naruei Yesu naio jotano ea vio na. Mia bogo na maka bunu tomu dolu nalo tai atu naliko, ana kiano naiagagoano nalo abinimei ea naio, abika denio, aberinavo “?Mia aue bulag Yimo Lu nene nagi, a kijokijo na vabe na kanamo liliuano, napano mia jau komei bereio ea bogo na maaro?” ");
INSERT INTO bki_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Naruei Yesu berdop̃e banlo, naio berinavo “Bo ka mia kamiu kuvitikar vatitig kamiu rivu, ka mia ve re toro tai rimei ka rijubolbolili kamiu, ");
INSERT INTO bki_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","bior mia tomu ve telabo napano mia adu siaku, naruei mia nalo amei averinavo ‘Kiniou nebe Naverikariano nene,’ naruei nalo avuru tomu ve telabo aiel vovu. ");
INSERT INTO bki_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ana ea bogo na bunu, mia kamiu kuvijog m̃aduano na mira napano ju vaataro, a lilianiano na mira nalo na aju koalabo, mia kamiu kumemebiju m̃ele re. Vite nalo na monokanio nalo amalmaluvo tukamu beamu vo, mia nina maka legiano na maaro nene navo. ");
INSERT INTO bki_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ana parinio tubo nalo ala mira ka parinio tubo dolu nalo, a venuo dolu nalo atumolu ka venuo dolu nalo. Mia ve bogo na vitu na toru, mia m̃ii rikulkulu ea vio yetemeriba reraio. ");
INSERT INTO bki_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mia vite nalo nei, maka ve bogo na maaro nene navo, mia tibe ka tira napano naio be m̃abono, naio jikar ka mijog be moti garuei ka taakano mijalele ka mia naio rivar kenerinio, mia burum̃ara jogvaiano naio maka navo. ");
INSERT INTO bki_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Mia ka bogo nene, kamiu na napano siaku joa kamiu, mia avokakar kamiu, a adu vironiano va nalo van kamiu, rivano-o mia auebinvin kamiu kum̃arm̃aro. Ana mia tomu na buruvenuo dolu nalo nonovio asidom lele re kamiu, mia ail die kamiu. ");
INSERT INTO bki_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Vite nalo na, mia rila tomu nalo ve telabo atu sikili re bunu ea kiniou, a nalo na amonmonea kiniou jukamu, mia nalo asidom re bunu nalo na amonea kiniou jikili kia ga ea bogo nene, mia nalo ativeluku kalo van kialo uolu nalo nei jum̃alo. ");
INSERT INTO bki_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mia naverialiano nalo na tuboluboiano ve telabo atumolu, mia avuru tomu ve telabo aiel tokoro. ");
INSERT INTO bki_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mia vijuku vovaiano nonovio riluo ve toru lie vo rila ana tomu ve telabo kialo iviso rimei rimenini, asidom re bunu Atua. ");
INSERT INTO bki_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mia verenio toro na tu sikili dam̃ariga ea kiniou riva rivokar bogokouo nei ribisi, mia Atua rilarur naio. ");
INSERT INTO bki_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mia ioluano vou na navenatuboiano nei, mia aioliolu van taara kinkin nalo kanio ea vio yetemeriba reraio, jibe ka kijokijo tai napano berial ka legiano na iorou maaro jo binimei.” ");
INSERT INTO bki_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Naruei Yesu berii bunu iliano dolu tai, napano bo ka verenio toro na rivulukuio, bo ka naio rila von ka rijikia vatitig nioti nene. Iliano nene berii jibe nei, berinavo “Mia kamiu kumijikia kuvial avitirilar tavoru tai napano kirivova mia kirivova laka, tumolu tu rila niegeniege vio Lu na Atua Kunuano Lu. Vite na Naverialiano Taniel naio berialio nanua ruei, ");
INSERT INTO bki_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ana verenio bogo na kamiu kuvial vite nene, kamiu napano kumitua vio Yutea, monokanio kamiu kuvuro kuva kuvituluku ea suku nalo. ");
INSERT INTO bki_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka bogo na, verenio toro tai to rijilmebi tavio ea kunuano, mia naio maka bunu rijikia riva joomo ka rivar kanano saba tai bereio, ");
INSERT INTO bki_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","p̃elina verenio toro tai toa kanano tiniavio, mia naio maka bunu rijikia riva vonuo bereio ka rivar kanano kuluniabeno. ");
INSERT INTO bki_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ana ka bogo nene kia ga vo, mia rivova laka van tire nalo na m̃abolo, a nalo na ajum̃a amije yu ban kenerilo tete mudomudomu nalo. ");
INSERT INTO bki_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Verenio tibe na, monokanio kamiu kubolkouo ka kamiu, ka kenemiu bogo na jaleleano nei, ka mia rimei re rivokar kamiu ea bogo na niavo, p̃elina ea legiano tava tai, ");
INSERT INTO bki_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","bior bogo na jikili nei, naio sikili lie todovulu bunu bogo tealo na jikili, jikar ea bogo napano Atua jii vio yetemeriba binimei bokar banei, ka mia ve re bunu jaleleano na burutomoruo tai tibe nei bogo tai bereio. ");
INSERT INTO bki_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mia Atua naio jidomii ruei ka mia naio tekorov ve bulati ga bogo na jikili nei, kanio tomu nalo napano naio bijauialo ka ave kanano, napano ajua bogo na. Ana verenio naio tekorov re ve bulati tibe na, mia maka toro tai rijikia rimeul to. ");
INSERT INTO bki_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A ka bogo nene, verenio toro tai river ka kamiu, riverinavo ‘Kamiu kuvialio, nina naio be Naverikariano na,’ p̃elina naio riverinavo ‘Nina naio be Naverikariano naio yako,’ mia kamiu kumonmonea re kiano iliano nalo na, ");
INSERT INTO bki_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","bior naverikariano na tiboliboiano nalo ve telabo atumormolu, vija naverialiano na ti boliboiano ve telabo mia nalo nene ala kijokijo na tortoru, vija tokokouro nalo na iloiano. Mia nalo ala tibe na, ka avuru tomu nalo aiavovu, rivano-o rivokar napano mia alavon ka avuru bunu tomu nalo napano Atua bijauialo ka ave kanano, mia vite nei maka ajikia alaio. ");
INSERT INTO bki_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mia kamiu kuvitikar kamiu, bior kiniou neberial vite nalo nei ban kamiu jukamu ruei, ka bogo na tenene nalo maka amalmaluvo vo. ");
INSERT INTO bki_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Naruei ka tenene, verenio tomu nalo averii ka kamiu, averinavo ‘Kamiu kuvialio, Naverikariano naio joa vio yauo yako ruei,’ mia kamiu kuvan re ea vio nene, a verenio averii ka kamiu averinavo ‘Kamiu kumial na, naio jo joomo ea yimo yako ga,’ mia kamiu kumonealo re. ");
INSERT INTO bki_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ana ea bogo napano Kulorinio Kenerinio naio rimei bereio, mia naio rimei rimeravo ka tomu nalo nonovio, tavukia vio bijano, naio merera rudul batitig vio tiniabene reraio tikar is van ea ues. ");
INSERT INTO bki_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ea bogo nene, mia tavukia bunu napano verenio tena m̃aro tai toa vio tai, mia bebekumo rinio nalo napano ajum̃a ajen temeul nalo nam̃a am̃arm̃aro, mia nalo amei kanio, monokanio aje buronlo ve telabo.” ");
INSERT INTO bki_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Naruei Yesu naio berinavo “Mia bogo na jaleleano nei naio ribisi, vaarakurano ga m̃erenio naio rimei ribobogio, mia siberio rimerera re bunu. M̃arivitano nalo na tiniabene mia nalo atibirbil, mia tenalo na jikirkili nalo na tiniabene, mia Atua rikulkulu kalo.” ");
INSERT INTO bki_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Mia ka bogo nene mia kijokijo na Kulorinio Kenerinio riyotuba ea tiniabene, a mia m̃atatoko nalo na yetemeriba nei mia nalo ateg ve toru aviovio mia aial Kulorinio Kenerinio riyotuba ea melijo nalo vija kiano burum̃ara moroano a vija kiano burum̃ara miamoiano. ");
INSERT INTO bki_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mia karina, simeduo na toru riolu, ana mia naio riila kiano nailiano nalo ava aseliviv ea vio yetemeriba reraio a vio mave bunu, ka avuru kiano tomu nalo napano naio bijauialo ruei, amei vio takurano ea naio.” ");
INSERT INTO bki_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ana Yesu naio berinavo “Kamiu kuvisidomii von buruiesi napano aber buruviki. Naio mijikia riverloglog kamiu ka vite tai napano kamiu monokanio kuvitii vatitigio. Bogo napano kamiu kuvial ka jaati nalo amei amemeiaio, amelumu, tikar ka mia rivarboṽeio, kamiu kumijikia ka kuverenio bogo binimei vaataro ka bogo na m̃erenio rivitunu ve toru. ");
INSERT INTO bki_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka tenene, bogo na kamiu kuvial kijokijo nalo na ea vio yetemeriba, tavukia na kiniou neberenio ka kamiu ruei, mia kamiu kuvijikia ka Kulorinio Kenerinio naio jumolu jikili jua m̃aratavo ruei, vaataro ka naio rimaluvo naruei. ");
INSERT INTO bki_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Riano kiniou neberii ka kamiu, mia vite nalo na mia ayotuba tukamu vo, mia iorou, ana taara na tomu nalo napano m̃a ameul ka bogo na, mia mijikia ava kovio den vio yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mia tiniabene a yetemeriba ave juo bunu ava kovio, mia kanaku m̃ariliano nalo maka ajikia ava kovio bogo tai leleio. ");
INSERT INTO bki_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mia maka toro tai rijikia legiano nene p̃elina aura nene napano mia Kulorinio Kenerinio naio rimei eaio. Nailiano nalo na vio mave, naliko Atua Kenerinio, maka ajikiaio, mia Karam̃aku ga takurano naio mijikiaio.” ");
INSERT INTO bki_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ana Yesu naio berinavo “Rivano-o rivokar bogo na Kulorinio Kenerinio rimei bereio, mia tomu nalo atu batitig re, tibe ka bogo na tormoruo Noa kiano nanua. ");
INSERT INTO bki_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ea kiano bogo nene naruei, bogo na ueimia na toru nei naio maka rimei vo, ana tomu nalo ajum̃a ajinan, a ajum̃a amunu tenalo nam̃a amunmunio, ajum̃a amila soriano jibe na ga, binimei bokar bogo napano Noa naio ba joomo ea kiano uako na toru napano naio mim̃aukanio. ");
INSERT INTO bki_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mia tomu nalo na aju dam̃ariga jibe na, maka asidomial titai, naruei amial ga burum̃ara ueimia nei binimei buru bulaglo. Mia kiniou neber ka kamiu, mia bogo na Kulorinio Kenerinio naio riyotuba rimei bereio, mia tomu nalo ave virare ga ka nalo nei nua beamu ea Noa kiano bogo. ");
INSERT INTO bki_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mia verenio tomu ve juo atu aim̃au ea tiniavio, mia nailiano nalo amei avurular tinene, mia tinene atuvanio tobo, ");
INSERT INTO bki_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","mia verenio tira ve juo atum̃a ala sinaniano, mia avurular tinene, mia tinene atuvanio tobo. ");
INSERT INTO bki_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tenene na mia kamiu monokanio kuvitikar vatitigio, bior kamiu maka kuvijikia ea legiano na vabe napano mia kenemiu Tubo naio rimei bere eaio. ");
INSERT INTO bki_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mia monokanio kamiu kuvitilubar vite nei, ka verenio toro na toru tai, verenio naio mijikia memedu ka bogo na mia toro na vinauano tai rimei ea kunuano, ka mia naio rivina ka kiano saba nalo, mia naio to derevijo rivu dam̃ariga, ka mia toro na vinauano naio rimei. ");
INSERT INTO bki_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tenene na, mia monokanio kamiu kuvitu derevijo rivu dam̃ariga, kanio mia Kulorinio Kenerinio naio riyotuba ea bogo tai napano mia kamiu kuvisidomial re ka mia naio rimei eaio.” ");
INSERT INTO bki_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Naruei Yesu naio berinavo “?Verenio toro na im̃auano tai, napano naio be masou bo ka kiano im̃auano, a naio bokar vatitigio, mia naio rim̃au tum̃abe? Naio rim̃au tibe nei, napano verenio kiano toro na toru tuvan vio nei ka naio riel riva koalabo, ana toro na toru nei rudu naio to ka rivitikar vatitig rivu tomu na im̃auano dolu nalo, ana mia toro nei naio rivokar vatitig im̃auano nalo nei. ");
INSERT INTO bki_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mia bogo napano toro na toru nei naio rimei bereio, mia naio rijikia rileal kiano boru na im̃auano nei naio jo bokar vatitig im̃auano nalo nei bo. Ana mia boru na im̃auano nei naio rijikia rijog rivu ve toru, ");
INSERT INTO bki_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","bior mia toro na toru nei naio tuvan kiano saba nalo nonovio tua toro na im̃auano nei jum̃ano. Ierinio, mia Atua rila tibe ga na bunu. ");
INSERT INTO bki_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Mia verenio boru na im̃auano nei naio rivova, mia bogo na toro na toru nei naio tuvan vio, ana naio riva koalabo, mia boru na im̃auano nei naio rijikia river ‘?Ee, toro na toru nei naio jo kirisiou laka, p̃eli mia naio rimei re bunu koviobo, p̃elina jum̃abe?’ ");
INSERT INTO bki_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ana mia naio tumolu rila lelan tomu dolu na im̃auano nalo, mia naio rijikia riva rimunu uei naliko tomu na pariparilo nalo m̃a amiavovu, mia nalo atu asen searo ea toro na toru neibano kanano puruveru nalo. ");
INSERT INTO bki_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mia toro na toru neibano naio rimei bereio ea legiano tai napano toro na im̃auano nei riilo kanio garuei, a ea bogo tai napano toro nei risidomial re ka mia naio rimei eaio. ");
INSERT INTO bki_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Naruei toro na toru nei naio rudu vironiano ve toru van boru nei, mia naio riila naio riva to vija tomu na tibolboiano dolu nalo ea vio napano tomu nalo ajum̃a ajegi, ajerkakar m̃arijuvolo nalo eaio.” ");
INSERT INTO bki_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ana Yesu berenio, berinavo “Ka bogo napano mia Kulorinio Kenerinio naio rimei bereio, mia Atua kiano navenatuboiano naio tibe ka jamerijiano nei naio berenio. Jamerijiano nei berii jokoluolu na soriano tai, napano jakii kanalo bajago, nalo na tivelinio ka sum̃ano aburu naio ban ea niatira kunuano ka avuru naio rimei rivijaio. Naruei kuviviniene duelimo 10 nei nalo aju bo ga ea kunuano, ka aiomon vite nonovio tu rivu vatitigio. Ana vaataro ka melijo tarako m̃esi naruei kuviviniene nalo abar kanalo yulu nalo amielko m̃arabo kalo, ka aviniu amei bereio. ");
INSERT INTO bki_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Kuviviniene nalo neibano, jumo nene abe masou bo, abe kialo jidomiano napano nalo abarkar kialo bauei na kanalo sunsunu ka mia aison bereio kanalo yulu nalo, mia nalo jumo nene nalo abe taboso ga, maka kialo jidomiano rivu tibe na ka avarkar kanalo bauei na sunsunu tai ka verenio sunsunu tabo, ana mia amijikia aison bereio. ");
INSERT INTO bki_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ana nalo aju rorea toro na soriano jiou jibe na bano-o, mia maka naio rila sop̃eli, ana merevono nalo nei miralo temi toru ana nalo amonmelio. ");
INSERT INTO bki_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Mia kanio bogiano viovare sebisaro, toro tai bio, berinavo ‘Toro na soriano, naio jo binimei naruei. Kamiu kumei kuviviuo naio.’ ");
INSERT INTO bki_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ana na merevono duelimo nei nalo ajevijo, ana amim̃aukanio kialo yulu nalo ka avilvil rivu bereio. Amilakon julu na kanalo yulu nalo, a abitii batitig kialo sunsunu nalo. ");
INSERT INTO bki_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Naruei nalo na abe taboso abitilubar ka kialo yulu nalo, vaataro ka mia am̃arm̃aro, naruei nalo abika den kuluelo jimo nene, aberinavo ‘Aiou banalo, kamiu kubo, kuviyon kija kenemiu sunsunu rivan kumemi, ver p̃eli mia kenememi yulu nalo am̃arm̃aro koviobo.’ ");
INSERT INTO bki_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mia nalo na abe masou, aberinavo ‘Vedeio ga, sunsunu maka rivare ka kumemi a kamiu bunu. Bo ka kamiu kuvan ea yimo na ṽilṽiliano ka kuvulu kenemiu tai.’ ");
INSERT INTO bki_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Naruei nalo napano abe taboso aba ka avulu kanalo sunsunu, ana bogo napano nalo aju koalabo kia ga vo, mia toro na soriano naio boru. Naio ba jouro ea kiano vonuo, naliko merevono jimo na aju rorea naio, naliko abijurukar ea sinaniano na soriano. Naruei bogo napano tomu nalo aba aju jouro ruei, ana nalo ajetavoko m̃aratavo bo batitigio. ");
INSERT INTO bki_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Karina iorou kanio, ana merevono nalo na abe taboso abinimei bereio, abio aberinavo ‘!Kumanememi, kumanememi, jau kobijuku bo kajamo ka kumemi nuviedu joomo!’ ");
INSERT INTO bki_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mia toro na soriano naio riverinavo ‘!Ierinio, kiniou neberii ka kamiu, kiniou maka nejikia bunu kamiu kube kei!’” ");
INSERT INTO bki_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mia Yesu berii jamerijiano nei bisi, ana naio berinavo “Mo, kamiu monokanio kuvitikar batitig rivu, bior kamiu maka kuvijikia legiano na vite nei a aura nene.” ");
INSERT INTO bki_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ana na Yesu mil berinavo “Mo, mia bogo na Kulorinio Kenerinio rimei bereio, mia tibe ka bunu napano jamerijiano nei berenio, napano toro na toru tai na naio miomon ka mia naio riel riva koalabo ea buruveno dolu. Ana toro na toru nei naio bio kanano atevi na im̃auano nalo ka amei aialio, naruei naio mil banlo, naio bar kanano saba nalo jua jum̃alo ka avitikar vatitigio, ka aim̃au rivijaio. ");
INSERT INTO bki_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Naio bitii vatitig kialo jikiaiano, naruei ea nalo tai jum̃ano naio midu siveu na puruveru jimo, ea dolu jum̃ano naio midu siveu na puruveru juo a ea dolu jum̃ano naio midu siveu na puruveru takurano ga, karina naio juvanlo, ana na naio ba jo koalabo kirisiou kija. ");
INSERT INTO bki_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Naruei toro na bar siveu na puruveru jimo, vaarakurano ga naio ba mila im̃auano telabo ka puruveru nalo nei, bano-o naio bokar bereio siveu na puruveru jimo dolu bereio. ");
INSERT INTO bki_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mia ea bajago nene kia ga, toro napano mijev siveu na puruveru juo, naio bokar bereio siveu na puruveru juo dolu bereio. ");
INSERT INTO bki_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mia toro napano naio mijev siveu na puruveru takurano ga, naio ba mikil p̃ili ea borotano, ana naio jivin puruveru napano be kiano tubo kanano. ");
INSERT INTO bki_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Naruei bogo jiou barlaka ruei bano, karina toro na toru na tomu tolu nei kialo naio binimei bereio. Naruei naio jidom rial kanano puruveru nalo napano naio bario ban tomu tolu nei. ");
INSERT INTO bki_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Naruei toro na bokar siveu na puruveru jimo jukamu, naio binimei jumolu jikili jukamu ea toro na toru nei mirano, naio bar bereio siveu na puruveru jimo dolu bereio. Naruei naio berenio ‘Tubo, Beamu jau kabar siveu na puruveru jimo ban kiniou, siveu jimo nene ninei. Mia nana kiniou nemim̃au nabokario tenene ninei, be siveu na puruveru jimo bereio, napano kiniou namiladu kanio be kanamo.’ ");
INSERT INTO bki_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Naruei toro na toru nei naio berkanio, berinavo ‘A siva toru. Jau kobe kanaku atevi na im̃auano novo, jau kobokar vatitig bo laka kanaku im̃auano telisu na nemije monea jum̃amo, mo mia kiniou nevitiri larso ka mia jau kovitikar kanaku im̃auano dolu nalo na tortoru. M̃araiu novo, jau komei kovijurukar kiniou kiteaku ea kanaku jokoluolu na tiniesaariano nei.’ ");
INSERT INTO bki_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Karina toro napano bar siveu na puruveru juo beamu, naio binimei jumolu jikili jukamu ea toro na toru nei mirano, ana naio berenio ‘Tubo, beamu jau kabar siveu na puruveru juo ban kiniou. Siveu juo nene ninei, mia nana kiniou nemim̃au nabokario bereio tenene ninei, be siveu na puruveru juo, napano kiniou namiladu kanio be kanamo.’ ");
INSERT INTO bki_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ana toro na toru nei berkanio, berinavo ‘A siva toru. Jau kobe kanaku atevi na im̃auano novo, jau kobokar vatitig bo laka kanaku im̃auano na telisu napano nemije monea jum̃amo, mo mia kiniou nevitiri larso ka mia jau kovitikar kanaku im̃auano dolu nalo na tortoru. Jau komei, kovijurukar kiniou ea kanaku jokoluolu na tiniesaariano nei.’ ");
INSERT INTO bki_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Karina, toro napano mijev siveu na puruveru takurano ga naio binimei, jumolu jikili jukamu ea toro na toru nei mirano na berkovio ga, berenio berinavo ‘Koig, kiniou nejidomii ka jau kobijuku m̃ete. Jau komijikia kokilkili ea tiniavio na maka jau komebijo eaio, a jau komijikia kabar m̃ariesi ea buruiesi napano maka jau komebijaio. ");
INSERT INTO bki_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bior tena, kiniou nemerou, ana nabano nomidu van kanamo puruveru, nejivin joa borotano. Keialio, ninei be kanamo puruveru na jo bo ga jo.’ ");
INSERT INTO bki_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mia toro na toru nei naio berenio ‘Aa jau, toro va tai, jau komiovo toru. Jau komil searo ea kiniou ruei, ka kober kiniou nebe toro p̃ilip̃ili tai jibe na jibe na, naruei verenio jau komial ka kiniou nebe toro kouo tai jibe na bior vaio ana jau komidu kanaku puruveru jo kurano ga jibe na. ");
INSERT INTO bki_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Verenio jau kava kodu toa yimo na puruveru mia kiniou nemijikia navar bulagio vija kirikiti nene, ka bogo na kiniou nebinimei bereio jibe nei.’ ");
INSERT INTO bki_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ana na toro na toru naio ber ka kiano navitikariano nalo, naio berinavo ‘Mo, kamiu kuva kuvidu denio puruveru na ea jum̃ano, kamiu kuvidu van toro napano naio bokar siveu na puruveru duelimo ruei. ");
INSERT INTO bki_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kiniou neber jibe nei ka kamiu, neber toro napano verenio be kiano saba ruei, mia naio mijikia rivokar tabunu bereio vo ka mia ve miroano, mia toro napano maka ve kanano saba tai, mia naio rila deven vite na telisu napano be kiano. ");
INSERT INTO bki_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mia taboso nei, kamiu kuvuku naio riva tavio ea vio na melijokouo, ea vio na tomu nalo ajum̃a ajegi a ajum̃a ajer m̃arijuvolo eaio.’” ");
INSERT INTO bki_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mia Yesu naio mil berinavo “Bogo napano mia Kulorinio Kenerinio naio rimei naliko kiano nailiano nalo, ea kiano mermerano ka rive Parinio Tubo, naruei mia naio rimei ka mia totano ea kiano jobaro lu. ");
INSERT INTO bki_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Naruei mia nailiano nalo avan ka avuru m̃atatoko nalo nonovio na yetemeriba nei amei, ka mia atumolu atu kamu ea mirano, mo ka bogo na mia naio tiburevure tomu nalo, ana avan ea taara ve juo, tavukia toro tai napano naio jo bitikar kiano temeul nalo jiburevure kanano nunu nalo ka nani nalo. ");
INSERT INTO bki_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mia parinio tubo nei naio tiburevure nunu nalo ka ava atua jum̃ano meruo, mia nani nalo ava atua jum̃ano mal. ");
INSERT INTO bki_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ana mia naio river ka nalo na ea jum̃ano meruo, riverenio ‘Kamiu kumei naruei, kube tomu nalo napano karam̃aku milivu ka kamiu. Kamiu kumei kuvidu jelemiu jouro ea kiano navenatuboiano, napano naio mila batitigio jororea kamiu ruei, ka bogo napano naio jii yetemeriba nei eaio. ");
INSERT INTO bki_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kamiu kumei, bior ka bogo napano m̃a jijer kiniou, ana kamiu kumije sinaniano ban kiniou, a bogo napano m̃a midoujer kiniou, kumijev uei ban kiniou. A bogo napano nebe valauo, mia kamiu kuburu kiniou naba joomo ea kunuemiu, ");
INSERT INTO bki_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","a bogo napano kiniou niabeku yauo, kamiu kubar kulum̃arauo ban kiniou. Bogo na kiniou nemie, kamiu kubinimei kumiadu ka kiniou, a bogo napano kiniou nojoa yimo na tetavokoiano, kamiu kubinimei kumitukunu bija kiniou.’ ");
INSERT INTO bki_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","39","“Mia tomu nalo na memedu nei napano ajua jum̃ano meruo, mia nalo avika denio, averenio ‘?Tubo, jum̃abe? Jau kojom̃a koberenio kumemi numitum̃a numiijaso ea kiamo bogokouo nalo na jibe na, mia kumemi maka bunu tiniememi rimaio ka kumemi numila jibe na banso leleio. ?Kumemi numila vite nalo na nagi?’ ");
INSERT INTO bki_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ana na Parinio tubo nei mia naio river kalo riverinavo ‘Riano kiniou neber ka kamiu, bogo nam̃a kamiu kumila jibe nei ban toro na kiaku m̃aratavo nalo nei tai, bekurano ka ver naio be toro na jum̃abe, mia jibe ka kamiu kumila ban kiniou ga na.’ ");
INSERT INTO bki_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mia iorou kanio, mia naio ril bunu van nalo na ea jum̃ano mal, mia naio river kalo, riverinavo ‘Kamiu kuvuro den kiniou, Atua miobap̃e ka kamiu ruei. Kamiu kuvan ea sebi na maka rijikia rim̃aro bogo tai, napano naio jororea kia Setano ruei naliko kanano nailiano nalo ka avan eaio. ");
INSERT INTO bki_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kanio bogo napano jijer kiniou, mia kamiu maka kuvar sinaniano van kiniou, a bogo napano midoujer kiniou, mia maka kuvijev uei van kiniou, ");
INSERT INTO bki_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","a bogo napano kiniou nebe valauo, mia kamiu maka kuvuru kiniou neviedu joomo ea kunuemiu a bogo napano niabeku yauo, mia kamiu maka kuvar kulum̃arauo van kiniou, a bogo napano kiniou nemie, p̃eli na nojoa yimo na tetavokoiano, mia kamiu maka kumei kuviadu ka kiniou.’ ");
INSERT INTO bki_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ana mia nalo averdop̃e Parinio Tubo nei, averinavo ‘?Tubo! Ana kumemi numialso nagi napano jau jijerso, p̃eli napano midoujerso, p̃eli napano kobe valauo, p̃eli na niabemo yauo, p̃eli napano komie, p̃eli napano kojoa yimo na tetavokoiano? ?Ana bogo jum̃abe napano jau kojibe na, ana maka kumemi nuviedu nuvijaiso?’ ");
INSERT INTO bki_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Mia naio ril vanlo, riverinavo ‘Riano kiniou neberii ka kamiu, bogo napano maka kamiu kuvisidomial ka kamiu kuvila tibe na van kiaku toro tai napano naio be toro na jum̃abe, nina jibe ka kamiu maka kuvisidom ka kuvila van kiniou.’” ");
INSERT INTO bki_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naruei Yesu mila nonovio kiano iliano, ana naio berinavo “Nalo na mia avan ka ajev vironiano tai napano maka rijikia ribisi bogo tai. Mia tomu na memedu nene nalo ava ajev meuliano napano maka rijikia ribisi bogo tai.” ");
INSERT INTO bki_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ana telikiti napano Yesu berloglog kiano tomu nalo ka iliano nalo nei avona bisi, ana naio berii kalo, naio berinavo ");
INSERT INTO bki_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kamiu kumijikia ruei ka veua ana Jokoluolu na Sidomkariano Na Ioruriano tikario. Mia ea bogo na jokoluolu nene, mia nalo adu Kulorinio Kenerinio toa tomu nalo jum̃alo ka mia atukukakario ea m̃akolkolo ka mia naio rim̃aro.” ");
INSERT INTO bki_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Naruei kanio bogo nene, tomu na tortoru na kulo lu nalo, naliko navurim̃araboiano na kulo Israel nalo aju abior ea parinio toro lu kunuano, napano siano Kaivas. ");
INSERT INTO bki_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nalo amil kavulio ka mia avokar Yesu bena ga ka mia tomu nalo ajikia re, mia nalo adu vironiano na m̃ariano vanio. ");
INSERT INTO bki_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mia nalo aberenio, aberinavo “Kito maka rejikia rala ea bogo na jokoluolu, bior mia tomu nalo tiniel ser kito ve toru, mia uetubaiano ve toru, bior nalo telabo napano tiniel jii tete neibano ruei.” ");
INSERT INTO bki_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Mia iorou kanio, Yesu naio joa m̃arkomeli na Betani, naio joa toro tai kunuano napano abio ka Saimon Burumieni, kunuano bior mieiano na burumieni jua naio nua. ");
INSERT INTO bki_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mia ka bogo tai napano Yesu jo jinano ea yimo nei kia ga vo, mia tira tai binimei ea naio, tira nene midu bauei tai napano amim̃aukanio ea puruveru novo tai, napano bujo ka bonotanunu napano puruveru nene burutomoruo laka. Ana tira nei miyon nonovio bonotanunu nei ea Yesu parinio. ");
INSERT INTO bki_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mia bogo napano Yesu kiano naiagagoano nalo amial vite nei, mia nalo tiniel mimi, ana nalo aberinavo “?Ka venia ana naio mila kule bonotanunu na jibe na? ");
INSERT INTO bki_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Verenio naio riṽilṽili kanio ga, mia naio mijikia rivokar puruveru ve toru eaio, ka mia naio rivar van talim̃asa nalo.” ");
INSERT INTO bki_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mia Yesu mijikia ka ajum̃a amil jibe na, ana naio ber kalo, berinavo “?Jum̃abe ana kamiu kumila lelan tira nei jibe na? Naio mila tonovo tai ban kiniou. ");
INSERT INTO bki_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Talim̃asa nalo na, mia nalo atu dam̃ariga iviso ka kamiu, ka mia kamiu kumijikia kuvijailo, mia kiniou, kiniou noto re kitoliko tulaka. ");
INSERT INTO bki_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vite napano tira nei naio milaio, napano naio miyon bonotanunu nei ea niabeku, nina jibe ka naio mila batitig kiniou rorea kanaku tiviniano. ");
INSERT INTO bki_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Riano kiniou neber ka kamiu, ea vio yetemeriba nonovio na averial kanaku ioluano nei eaio, mia monokanio mia atukunu bunu ka vite napano tira nei naio milaio, ka mia asidomkario dam̃ariga bereio kiano burum̃ara tinietiiano, napano naio tinien miia kiniou toru riano.” ");
INSERT INTO bki_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Karina kiano naiagagoano duelimo ba juo 12 nei tai, napano siano Jutas na vio Kariot, naio ban ea tomu na tortoru na kulo lu nalo, ");
INSERT INTO bki_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ana naio berinavo “?Verenio kiniou netiveluku ka Yesu riviedu ea jumemiu, mia kamiu kuvar venia van kiniou?” Ana nalo abulu ka puruveru silva duelimo va rolu 30 banio, ");
INSERT INTO bki_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ana mo jikario ea bogo na, Jutas jom̃a jirag m̃arabo ka mia naio tiveluku ka Yesu vanlo eaio. ");
INSERT INTO bki_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ana binimei bokar bogoti napano be moti ka jokoluolu nei, napano abio ka bunu Jokoluolu Na Asen Beskit Na Mioboba, ana kiano naiagagoano nalo abinimei kean Yesu, ana abika aberinavo “?Jau kojidom kumemi nuva nuvila vatitig vite nalo nene ea vio na vabe, ka mia kito rala Sinaniano na Sidomkariano Na Ioruriano eaio?” ");
INSERT INTO bki_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ana Yesu naio berdop̃e banlo, berinavo “Kamiu kuva Yerusalemo, kamiu kuvial toro na, kuverii kanio, kuverinavo ‘Kenememi naverloglogiano naio berii kiano bogo binimei vaataro na ruei. Mia naio jidom naio naliko kumemi kiano naiagagoano nalo, numei nuvila sinaniano nei ea kunuamo.’ ” ");
INSERT INTO bki_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana Yesu kiano naiagagoano nalo aba amila javukia napano naio berii kalo, ana nalo amila batitig vite nalo na jokoluolu nene. ");
INSERT INTO bki_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naruei iorou kanio ana Yesu nalo abinimei ea vonuo nene, ana bogiano binimei, naruei Yesu binimei naliko kiano naiagagoano nalo ajutano, ana nalo aju amijev sinaniano nene, ");
INSERT INTO bki_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ana Yesu berenio, berinavo “Riano kiniou neberii ka kamiu, be kamiu tai napano mia naio tiveluku ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Telikiti na kiano naiagagoano nalo amijog naio mil berii jibe nei, mia nalo amijog bova toru, ana nalo abiniu abivika denio, aberinavo “?Tubo, be kiniou kovio, a?” ");
INSERT INTO bki_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mia Yesu berdop̃elo, berinavo “Toro napano kumemi ve juo nuvititi ka joko ea baju ve takurano naio naruei be toro nene. ");
INSERT INTO bki_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mia Kulorinio Kenerinio naio monokanio rim̃aro tibe ka na Vivitauiano Lu berenio, mia toro na naio ritiveluku ka naio, mia rivova laka van naio, bo laka ka ver naio rimoluo re.” ");
INSERT INTO bki_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mia Jutas, toro napano karina naio jiveluku ka Yesu, bika berinavo “?Naverloglogiano, be kei? ?Kiniou bo, a?” Ana Yesu berdop̃e naio, berenio berinavo “Tenene ga naruei na jau koberenio na.” ");
INSERT INTO bki_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Telikiti napano nalo aju ajinan kia ga vo, ana na Yesu midu joko tai, ber siva ban Atua kanio, karina naio bure kokorovio ana naio bar jian ban kiano naiagagoano nalo, naio berenio berinavo “Kamiu kuvijevio, kamiu kuvisenio. Nina be mokotenaku.” ");
INSERT INTO bki_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Karina naio mijev baja na m̃arjum̃elm̃elu, ana naio mil berenio siva ban Atua kanio, karina naio jian banlo, ana naio berinavo “Kamiu kuviniu kumunu bitiranio ga ea baja nei, ");
INSERT INTO bki_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","bior ninei be kanaku burukija, napano mia rila Atua kiano verikariano tu sikili, napano mia naio rioukar viekokoano na vijuku vovaiano na tomu ve telabo kialo. ");
INSERT INTO bki_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kiniou neberkar ban kamiu, mia kiniou nomunu re bunu m̃arjum̃elm̃elu na bereio, rivano-o mia nomunu m̃arjum̃elm̃elu vou na kitoliko, ea Teta kiano navenatuboiano.” ");
INSERT INTO bki_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Karina nalo amijev iou tai maariano ea Iouano Nalo bisi, ana nalo abatavio, abano maariano ea Suku na Buruolivi. ");
INSERT INTO bki_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Naruei Yesu berii kalo, berinavo “Ka bogiano nei, mia kenemiu moneano ea kiniou ajoru, kar vite nalo napano mia amei avokar kiniou. Mia tavukia ga na Atua berenio ea kiano Vivitauiano Lu, napano naio berenio, berinavo ‘Mia kiniou nouebin toro na bitikar nunu naio rim̃aro, ana mia kanano nunu nalo avuro dedade atan ea vio nonovio.’ ");
INSERT INTO bki_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Mia bogo napano nemeul bereio den nam̃ariano, mia kiniou notukamu nava Kalele, ana mia kamiu bunu monokanio kumei iorou.” ");
INSERT INTO bki_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naruei Pitere berial kanio, berinavo “Yesu p̃eli mia nalo dolu na aviniu kialo moneano ajoru kaso, ana avuro, mia kiniou maka nejikia notuvanso bogo tai.” ");
INSERT INTO bki_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mia Yesu berdop̃e, berkanio berinavo “Riano kiniou neber kaso, mia ka bogiano nei ga, bogo na tormano tokokoreko re vo, mia jau kavarbonbonua kiniou ve varolu, koverenio maka kejikia kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ana Pitere naio berial meravo ban Yesu, ea miralo abiniu, berinavo “Verenio nalo asidom auebin kiniou bunu kito ve juo, nina bo ga na, mia kiniou maka nejikia navar bonbonuaso, ka never kiniou maka nove kanamo.” Mia kiano naiagagoano dolu nalo bunu aberii jibe na. ");
INSERT INTO bki_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Karina Yesu naliko kiano naiagagoano nalo aban ea vio tai, siano Ketsemani. Naruei naio ber kalo, berinavo “Kamiu kuvitua vio nei beamu vo, mia kiniou nava lie kija bereio, ka nava novolkouo ve telisu yako.” ");
INSERT INTO bki_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Naruei naio buru Pitere naliko Sepeti kenerinio juo, Yemesi naio Jone, nalo tolu naliko aban lie kija telisu bereio, mia ka bogo nei Yesu mijog kiano iviso binimei temi laka, naio mijog bova toru laka. ");
INSERT INTO bki_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ana naio mil ban nalo tolu nei, berinavo “Vonganei, nemijog niunuku burukokorov toru, mila vaataro ka nam̃aro kario. Aiou bo ka kamiu kuvitevijo vija kiniou ve telisu beamu ea vio nei vo.” ");
INSERT INTO bki_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ana Yesu miel ba lie kija telisu bereio, ana naio mijoru minie, dabuko mirano ka rivolkouo. Ana naio bio, berinavo “Teta o-o, verenio jau komijikia kala vite nei, aiou kiniou nejidom ka jau kejelar baja na jogvaiano nei den kiniou ka mia kiniou nomunu ea re. Mia kala re tibe ka na kanaku jidomiano, mia kala ea ga kanamo.” ");
INSERT INTO bki_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Karina, naio binimei bereio kean naiagagoano tolu nei, naio mialo ajum̃a amonmelio ruei. Karina ajevijo, ana Yesu berii ka Pitere, ber “?Jum̃abe ana kamiu maka kuvijikia kuvitevijo rivija kiniou ka aura ve takurano ga nei? ");
INSERT INTO bki_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kamiu monokanio kuvitikar vatitig rivu, a kamiu monokanio kumolkouo bogo nonovio, ka mia natiboliboiano nalo ala re kamiu kuvijoru ea kariano. Riano ga, kenemiu jidomiano jikili bo, mia niabemiu melukluku toru laka.” ");
INSERT INTO bki_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Karina valuo nene, naio ban bereio ea vio nabano, naio bolkouo bereio, berinavo “Teta o-o, verenio jau maka kejikia kodular baja na jogvaiano na kiaku nei, mia kiniou monokanio nomunu eaio, bior monokanio tibe kanio ga na jau kojidomio.” ");
INSERT INTO bki_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Karina, naio binimei bereio, mial nalo tolu nei ajum̃a amonmelio bereio, bior nalo miralo jouo ajevijo dedeio. ");
INSERT INTO bki_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Naruei naio juvan nalo tolu nei aju ga, ana naio ban bereio ea vio napano naio bolkouo ber bereio iliano takurano ga, mila varolu ka ninei. ");
INSERT INTO bki_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Naruei naio binimei bereio kean nalo tolu nei, ana berenio “?Ei, kamiu kumijilimebi, kamiu kumonmel kia ga vo? !Kamiu kuvitikario! Vaataro ka bogo na Kulorinio Kenerinio naio rivan ea tomu na bova nalo jum̃alo naruei. ");
INSERT INTO bki_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kito, kuvitumolu, ravano. Kamiu kumial na, toro na jiveluku ka kiniou nana ju binimei vaataro ga naruei.” ");
INSERT INTO bki_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ana bogo na Yesu naio jom̃a ber iliano nene kia ga vo, Jutas neibano naio be naiagagoano duelimo ba juo 12 tai, naio binimei, naliko tomu telabo na mira nalo abar iobogu na mira bija kialo nia nalo. A tomu na tortoru nalo na kulo lu nalo naliko navurim̃araboiano nalo na kulo Israel, nalo naruei amiilalo abinimei. ");
INSERT INTO bki_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mia beamu ka nalo amaluvo, toro na tiveluku Jutas naio berial kijokijo tai banlo, naio berinavo “Toro na verenio kiniou neviviuo naio tukamu, naio naruei kamiu kuvokakar naio sikili,” ");
INSERT INTO bki_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","mia bogo napano nalo amiyotuba, Jutas miel memedu ka Yesu, biviuo naio ana naio berkanio, berinavo “!Bogiano bo-o, Naverloglogiano! Tum̃aro to vijaso.” ");
INSERT INTO bki_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ana Yesu berkanio, berinavo “Koig, im̃auano napano kobinimei kanio, mia jau kalaiio ga.” Naruei nalo abinimei, abokakar Yesu jikili. ");
INSERT INTO bki_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mia bogo napano abokar naio jibe na, ana Pitere burular kiano iobogu, p̃iligio je titire ea Parinio toro Lu kiano toro tai ana jelar tilinieno tivelinio. ");
INSERT INTO bki_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naruei Yesu mil banio, berinavo “Kodu vatitig kanamo iobogu rivan ea sivi nene bereio. Toro na jo midu iobogu na mira, mia naio rim̃aro ea iobogu na mira. ");
INSERT INTO bki_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","?Kamiu kuberiam̃a maka nejikia nevio van Teta ka naio rijai kiniou? Verenio nevio van naio, mia ve vaarakurano ga, naio riila kiano taara na nailiano nalo ve telabo ka mia amei avitikar kiniou. ");
INSERT INTO bki_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mia verenio kiniou nala tibe na, mia iliano nalo nanua jua Vivitauiano Lu, mia maka ajikia amei ve riano, tibe kanio napano aberkario nua ruei.” ");
INSERT INTO bki_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mia Yesu mil ban tomu nalo nei, naio berinavo “?Ka vaio ana kamiu kubar kenemiu iobogu nalo bija kenemiu nia nalo? Kubokar bena kiniou jibe na? ?P̃eli kamiu kuberiam̃a kiniou nebe toro kouo na vinauano, p̃eli na napano m̃a mue toro? ?Mia legiano nonovio kiniou nojom̃a noberloglog tomu nalo ea Atua Kunuano Lu, mia jum̃abe ana maka kamiu kumei kuvokar kiniou ea bogo na? ");
INSERT INTO bki_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mia vite nalo nei bo ga na, bior vite nalo na kamiu kumitu kumilaio, jibe ka ga napano naverialiano nalo aberialio nanua ruei ea Vivitauiano Lu, ana kialo iliano nalo nene, aju abinimei abe riano naruei.” Ana ea ga aura nei, naiagagoano nalo ajuvan Yesu, nalo aburo ka naio. ");
INSERT INTO bki_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mia nalo napano abokar Yesu, aburu binimei ka ala naio tumolu tukamu kean Kaivas, Parinio toro lu, napano naverloglogiano na tuboiano nalo naliko navurim̃araboiano na kulo Ju nalo kialo abinimei vio takurano ea kiano komeli nene ruei. ");
INSERT INTO bki_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mia Pitere bunu jakisor Yesu ka bogo nene, mia naio maka rivan vaataro ka naio, mia bogo na abinimei jouro ea burusio na komeli labo nei, Pitere naio ba jotano naliko Kaivas kiano tomu na im̃auano nalo, ka mia rijog von ka mia ala tum̃abe ka Yesu. ");
INSERT INTO bki_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Naruei tomu na tortoru na kulo lu nalo, bija tomu na tortoru dolu nalo na aju joomo ea vioriano nei, nalo ajirag tomu nalo tai ka mia ajubolbo ka Yesu, ka mia aver vite nalo tai ka napano aial ka amijikia auebin Yesu riviorio. ");
INSERT INTO bki_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Naruei nalo amil, ana tomu telabo ajumolu, amijubolbo bano-o, mia vioriano nei maka rial vite tai ea kialo iliano nalo rivare ka mia ala tibe na ka Yesu. Kialo iliano nalo beve dolu ga jibe na bano-o bisi ana tomu juo ajumolu, ");
INSERT INTO bki_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aber iliano takurano ga aberinavo “Toro na naio berenio mijikia rue bulag Atua kunuano Lu, karina naio rivon vavin bereio ka bogoti ve tolu ga.” ");
INSERT INTO bki_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Naruei Parinio toro lu nei naio jumolu, mil ban Yesu, berinavo “?Jum̃abe, jau koverdop̃elo, p̃eli na makanio? ?Jum̃abe ka iliano nalo nam̃a aju aber bulagio na?” ");
INSERT INTO bki_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mia Yesu maka ril, naio ju buru ga. Naruei Parinio toro lu nei berkanio bereio berinavo “?Kiniou neber kaso, jau monokanio kover Atua Meul siano kover riano ka jau kobe Naverikariano, napano Atua kenerinio, p̃eli na jau maka kove naio? ?Jau monokanio koverialio vatitig van kumemi vonganei!” ");
INSERT INTO bki_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Naruei Yesu mil banio, berinavo “Vite nene naruei, jau kojom̃a koberenio kiana. Mia kiniou neber ka kamiu, iorou kanio vesiou re, kamiu kuvial Kulorinio Kenerinio napano mia naio totano tivelinio vameruo ea Atua na moroano, a mia kuvial naio riyotuba ea melijo nalo ea yetemeriba.” ");
INSERT INTO bki_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mia Parinio toro lu nei, naio tinien mimi m̃ele, ana mijede m̃ano kulukoti, ana naio berinavo “!Barei naruei! Toro na naio ber niegeniege Atua siano lu ruei. ?Kamiu kumijogio? ?Jum̃abe ana roju rejirag bereio toro tai ka mia river bereio titai ka naio? ");
INSERT INTO bki_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Vioriano jidomii jum̃abe? ?Mia roviron tum̃abe?” Nalo amil aberenio, aberinavo “Bo kanio auebin toro na naio rim̃aro.” ");
INSERT INTO bki_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Naruei nalo abule mirano, a ajuku naio, mia tealo amijuba bilivilig naio, ");
INSERT INTO bki_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ana nalo amiyotel ea naio, abika denio aberinavo “?Ei, Naverikariano, jau koverial vonio, kenia mijubaso vonga na?” ");
INSERT INTO bki_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ana ka bogo nene Pitere naio jotano jouro ea burusio nei, ana niatira tai napano jom̃a bitikar yimo naio binimei, berinavo “!Uerei, jau bunu kamliko Yesu na vio Kalele neibano!” ");
INSERT INTO bki_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mia kamu ea miralo abiniu, Pitere barbonbonua tenei, naio berinavo “Kiniou maka nejikia tena jau kojom̃a koberenio na.” ");
INSERT INTO bki_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Naruei naio buro den niatira nene, batavio jua morouo na toru na burusio na komeli nei. Ana ea vio na, niatira dolu mialio, ana naio berii ka tomu nalo na aju vaataro, berinavo “Tete na, naio naruei naliko Yesu re Nasarete.” ");
INSERT INTO bki_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ana Pitere naio barbonbonua tena bereio, naio mila kiano iliano jikili, mia naio berinavo “P̃eli ga, kiniou maka leleio nejikia toro na.” ");
INSERT INTO bki_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ana maka vesiou, ana tomu nalo na aju vaataro ea morouo nene abinimei ea Pitere, aberii kanio aberinavo “Ninei be riano, jau kobe nalo tai, bior jooa na kojom̃a kabar ka kiamo iliano, jibe ka kulo Kalele nalo.” ");
INSERT INTO bki_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mia Pitere naio mila iliano jikili lie vo, ana naio berinavo “!Maka leleio! !Riano ka tiniabene! !Kiniou neberenio ruei, maka nejikia tete na!” Ana memedu ka bogo nene, tormano tai jokokoreko, ");
INSERT INTO bki_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ana mila Pitere tinien maio ka Yesu kiano iliano, napano naio berkanio berinavo “Riano kiniou neber kaso, mia ka bogiano nei ga, bogo na tormano tokokoreko re vo mia jau kavarbonbonua kiniou ve varolu, koverenio maka kejikia kiniou.” Naruei Pitere batavio, naio jegi mia jegi ka tinie na jogvaiano toru. ");
INSERT INTO bki_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Naruei kavijo, binimei bogo na m̃erenio bavin, tomu na tortoru na parinio kulo lu nalo naliko navurim̃araboiano na kulo Israel nalo, ajutano bereio ka alavon ka avirakar m̃arabo tai rivu, ka mia rila ana Yesu monokanio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mia bogo napano amil bisi, ana amiorkar Yesu jum̃ano, ana aburu naio ba ban Pailat, napano naio be Parinio tubo na vio Romo napano naio bitikar Israel ka bogo na, ana nalo amidu Yesu joa Pailat nene jum̃ano, ka mia naio tibureio. ");
INSERT INTO bki_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mia Jutas, napano naio jiveluku ka Yesu karina, naio bitilubar ka ajibure Yesu ruei ka monokanio mia naio rim̃aro, ana naio mijog bova toru ka vite na milaio. Ana naio bilig kiano jidomiano bereio ruei, ana naio bar bereio silva duelimo va rolu 30 nei, ba ban tomu na tortoru nalo nanua abar banio jukamu. ");
INSERT INTO bki_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naruei naio ber kalo, berinavo “Kiniou nabijuku bova bior nejiveluku ka toro na maka rila titai leleio tokoro, mia kanaku iliano ga mila ka mia ala bin naio rim̃aro.” Ana nalo nei aberii kanio ga, aberinavo “?Ai koig, jum̃abe ana jau kobinimei kejegi bereio ban kumemi? Kumemi nubisi denso ruei.” ");
INSERT INTO bki_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Naruei Jutas p̃ilig m̃elea ga puruveru nalo nei joomo ea Atua kunuano Lu, ana naio batavio, ba jelan burujono ka teli, ka naio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mia tomu na tortoru na kulo lu nalo nei aba abar puruveru nalo nene, naruei nalo aberenio “Puruveru nei, burukija na toru miou kario ruei, ana ea kiado tuboiano, maka rejikia rodu puruveru na jibe na toa basaro na Atua kunuano Lu.” ");
INSERT INTO bki_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ana nalo aberiio, karina nalo abar puruveru nene, aba abulu ka niatano tai, napano beamu, siano “Borotano Na Tanop̃ili,” naruei nalo ajuvan niatano nei be pakeltavo na valauo nalo m̃alo. ");
INSERT INTO bki_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tenene na, binimei bokar banei, tomu nalo ajum̃a abio niatano nene, aberenio “Borotano na Burukija.” ");
INSERT INTO bki_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Vite na jibe na, ana mila Naveri-aliano Jeremaia kiano iliano tai re nua naio binimei be riano, napano berenio “Abar puruveru silva veru duelimo va rolu 30, bare ka napano kulo Israel aberenio naio bare ka avulular ka toro, ");
INSERT INTO bki_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ana nalo aba abulular borotano nei den toro nam̃a mim̃auka tanop̃ili, jibe ka na Atua berii ka kiniou ka noim̃au kanio.” ");
INSERT INTO bki_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ana nalo aburu Yesu binimei jumolu jukamu ea Parinio Tubo Pailat, ana na bika den Yesu berinavo “?Jau kobe Parinio tubo ka kulo Israel nalo p̃eli na makanio?” Ana Yesu mil berdop̃eio, berinavo “Tenene na, jau kojom̃a koberenio na.” ");
INSERT INTO bki_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mia bogo napano tomu na tortoru na kulo lu nalo naliko navurim̃araboiano nalo aberii lualua vite nalo telabo kar Yesu, mia Yesu maka bunu riverdop̃e titai. ");
INSERT INTO bki_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mia Yesu naio juburu ga jibe na, naruei mila Pailat bika bereio, berinavo “?Jum̃abe, jau maka kosidomial ka ajum̃a aberenio vite telabo na bova karso?” ");
INSERT INTO bki_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mia ea tivelinio na vite nalo na ajum̃a aberenio nei, mia Yesu maka leleio riverip̃e titai vanlo, naruei Parinio tubo nei miilo toru kanio. ");
INSERT INTO bki_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ka bogo nene, mia nalo aju kia ga vo ea Jokoluolu na Sidomkariano Na Ioruriano, mia ka yuka nonovio ea jokoluolu nei, Parinio tubo na Romo nei naio jom̃a mila vite tai ka kulo Israel nalo. Naio jibe ka napano verenio nalo tealo ajua tetavokoiano, ana nalo amijikia aver nalo tai kalo, ka mia parinio tubo nei naio rijamo ka naio riva tavio. ");
INSERT INTO bki_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mia ka bogo nei, toro na poletik tai joa tetavokoiano, napano mia tomu nalo amijikia batitig naio, siano Yesu Barabas. ");
INSERT INTO bki_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Naruei bogo na tomu nalo abior vio takurano nalo telabo ea vio nei, Pailat bika denlo, berinavo “?Kamiu kumisidom kiniou najamo ka kei taluvo riviedu bereio ea kamiu? ?Yesu Barabas, p̃eli na Yesu na aju abio naio ka Naverikariano?” ");
INSERT INTO bki_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat bika jibe nei, bior naio mijikia ruei ka tomu nalo na tortoru na kulo Ju nalo, nalo ga aburu Yesu binimei banio bior im̃auano na jokuano ga, bior kialo tomu nalo ajaaro toru ka Yesu. ");
INSERT INTO bki_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ana ea bogo na bunu napano naio jotano ea vio na tibureiano ka rila iliano nei, mia kouano miila toru binimei banio berinavo “Jau kala re titai ka toro na. Naio maka rila titai, mia ka bogiano kiniou nomonbovuii naio, mia vonganei kiniou nomijog bova toru kario.” ");
INSERT INTO bki_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tenene na, Pailat jidom tuvan Yesu, mia tomu nalo na tortoru na kulo lu nalo naliko navurim̃araboiano na kulo Ju nalo, amila bulag tomu nalo kialo jidomiano nalo, ajikili laka kalo, aberinavo monoka averii ka Pailat naio tuvan Barabas, mia naio rila Yesu riva rim̃aro. ");
INSERT INTO bki_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Naruei Parinio tubo nei naio bika denlo bereio, berenio berinavo “?Kamiu kumisidom kiniou najamo ka tomu juo nei, na vabe nene naio taluvo rivano?” Ana nalo abio jouo, aberenio aberinavo “Barabas.” ");
INSERT INTO bki_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naruei Pailat bika denlo, berinavo “?Mo, bo ga, ana mia kiniou nala tum̃abe ka Yesu napano ajum̃a abio naio ka Naverikariano?” Mia nalo abiniu amiaga jouo, aberenio “!Kotukukar naio toa m̃akolkolo!” ");
INSERT INTO bki_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ana naio berinavo “?Kar vaio? ?Venia bova napano naio milaio?” Mia nalo amiaga kilkil, aberinavo “Kotukukario, kotukukario toa m̃akol kolo.” ");
INSERT INTO bki_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Telikiti na Pailat mial ka maka rijikia riverburelo, bior uetubaiano jumolu m̃ele ruei, ana naio midu baju na uei tai, naruei kamu ka tiniobi nei, naio jekon jum̃ano, ana naio berenio “Mia burukija na toro nei toa re kiniou. Kiano m̃ariano naio be kenemiu im̃auano ga.” ");
INSERT INTO bki_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Naruei tomu nalo amil aberdop̃e, aberenio “Bo ga na, jibe na garuei ana kumemi numisidom, napano kiano m̃ariano be kenememi im̃auano, a napano kiano burukija naio toa kumemi vija kenerimemi nalo.” ");
INSERT INTO bki_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ana Pailat naio mijamo ka Barabas banlo, jibe ka na nalo ajidomio, ana naio midu Yesu joa kiano kulo na mira nalo jum̃alo ka avitivio, a ka avuruio rivan ka atukukario toa m̃akolkolo. ");
INSERT INTO bki_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naruei Pailat kiano kulo na mira nalo aburu Yesu abatavio ea vio medave na kanano komeli nene, mia nalo abio bunu kulo na mira taara dolu nalo ka amei aial Yesu. ");
INSERT INTO bki_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Naruei nalo amiya bulag kanano kuluniabene, ana amiya kulukoti tai ea naio napano niabene be vabolo jibe kanio nam̃a parinio tubo nalo amiyaio, ");
INSERT INTO bki_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","naruei nalo abar tilikou abili vatitig bisi, ana amive joa parinio, jibe ka parinio tubo kanano batubatu tai, ana nalo amidu bunu iesi tai joa jum̃ano meruo ka naio rivokario. Naruei nalo aju aminie ka sudu jaalo kanio, ana nalo aju amiyotel eaio, aberinavo “!Kumemi nubameneaso, jau Parinio tubo novo na Kulo Israel kialo!” ");
INSERT INTO bki_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ana nalo aju abule titia naio, a amidu burusubavio nene, amue ka Yesu pariparinio. ");
INSERT INTO bki_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mia bogo napano amiyotel ea naio bisi, ana nalo amiyalar kulukoti vabolo nei denio, ana amiya m̃ano kuluniabene ea naio bereio, ana nalo aburu naio, abatavio ka atukukakario ea m̃akolkolo. ");
INSERT INTO bki_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ana bogo na kulo na mira nalo aburu m̃arabo ka Yesu aba tavio, ana nalo amileal toro na vio Saireni tai, siano Saimon, naruei nalo ajutua naio ka naio kija rudu Yesu kiano m̃akolkolo rivano. ");
INSERT INTO bki_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mia nalo aba abokar suku tai, napano siano Kolkota, napano nioti nene berenio vio na jibe kanio bordada. ");
INSERT INTO bki_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bogo napano nalo amijivi ea vodobi na suku nene, nalo ajidom adu m̃arjum̃elm̃elu tai van Yesu ka rimunuio, mia m̃arjum̃elm̃elu nei vati titai napano mijea juaio, ka mia rila Yesu niabene je ka mia rijog re rijalele m̃ele, mia bogo napano Yesu miomo vonio, mia maka sidom rimunuio. ");
INSERT INTO bki_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nalo aburu Yesu bano, ana ajukukakar naio ea m̃akolkolo. Karina, nalo amila jibe ka na amiere m̃abujo ka aleal ka mia kei rivar Yesu m̃ano kuluniabene tai a kei rivar dolu nene, ");
INSERT INTO bki_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ana nalo ajutano ea vio nene ka aviti kuku ka naio. ");
INSERT INTO bki_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ana nalo ajiri verialiano tai, ajukukario jo mave ka parinio, naio berial vite na mila amuebin naio biorio, napano naio berenio “Nina be Yesu, Parinio tubo na kulo Ju nalo.” ");
INSERT INTO bki_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mia nalo amidu tomu juo na vinauano ajukukakarlo bunu ea m̃akolkolo jibe ka Yesu, amidu tinene jo tivelinio vameruo, a tinene jo tivelinio vam̃ali. ");
INSERT INTO bki_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Naruei tomu nalo napano m̃a amiel abarlaka ea vio na, ap̃iligṽilig pariparilo, aberii niegeniege Yesu liki, nalo aberinavo ");
INSERT INTO bki_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“!A! Jau m̃a na, nanua m̃a kober komijikia kala bulag Atua Kunuano Lu, ka mia bogoti ve tolu ana koivon kar vavin bereio, mia jum̃abe naruei? !Ee, mia bo ka jau kalarur kanamo meuliano vonio! !A verenio jau kobe Atua kenerinio riano, kataluvo den m̃akolkolo na, ana katabulu!” ");
INSERT INTO bki_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ea bajago nene ga bunu, tomu na tortoru na kulo lu nalo naliko naverloglogiano na tuboiano nalo naliko navurim̃araboiano nalo aju abital eaio, ");
INSERT INTO bki_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","nalo aju aberinavo “!P̃eli naio milarur tomu dolu nalo telabo ruei, mia vonganei, naio maka rivare ka rilarur naio! ?Naio be kito kulo Ju nalo kiado Parinio Tubo na, p̃eli na makanio? Bo ka naio tabulu den m̃akolkolo vonganei, ka mia kito romonea naio. ");
INSERT INTO bki_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Toro na naio berenio naio biekouo ea Atua, naio berenio naio be Atua Kenerinio. !Mo, kito reial vonio, verenio Atua jaaro kanio, mia naio rilarur naio vonganei!” ");
INSERT INTO bki_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mia tomu juo na vinauano napano ajukukakarlo ea m̃akolkolo jibe ka Yesu, naljuo bunu amil bova ka Yesu, abironkar nalo nei ka kialo ilivovaiano nalo nalikolo. ");
INSERT INTO bki_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ana ea legiano viovare, ana melijokouo binimei miununuko vio reraio, mia jo jibe na bano-o bokar m̃erenio tolu niogoravo, ");
INSERT INTO bki_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","mia vaataro ka bogo na, Yesu miaga jouo ea kiano iliano memedu, naio berinavo “?Eli, Eli, lam̃a sabatani?” napano berenio “?Kiaku Atua, kiaku Atua, ka vaio ana kojuvan lelan kiniou nojo jibe nei?” ");
INSERT INTO bki_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mia tomu nalo nei tai ajua vio na, nalo aju abitii vite nalo na malmaluvo, nalo amijog belia Yesu miaga jibe nei, nalo aberenio “Toro na naio jo bio tormoruo Elaija, ka rimei rijai naio.” ");
INSERT INTO bki_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mia sop̃eli ga, nalo tai jikiti binimei, midu burujumu tai, miyon m̃arjum̃elm̃elu na mijea ban eaio, julu kario ka iesi tai, ana jianio ban Yesu ka rimunuio. ");
INSERT INTO bki_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mia kulo dolu nalo aberenio “!Ei, jau koto vo! Reial vonio, p̃eli mia tormoruo Elaija rimei rilarur naio bo, p̃eli na mia rimei re.” ");
INSERT INTO bki_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Karina Yesu miaga jouo bereio, naio buru maaria kanano jegi, ana juvan niununo bano, ana mo naio m̃arodobi liki. ");
INSERT INTO bki_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Monloglog ea bogo nene ga, jagidago na ea Atua Kunuano Lu, napano joko vio lu na be vio lu laka, naio burup̃e tivelinio juo, jikario mave batove boru yetano. Mia m̃ii mukulkulu ka borotano, ana puruveru nalo na tortoru aburuboṽelo, ");
INSERT INTO bki_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mia ea pakeltavo, martanbo telabo na tomu nalo na memedu nua ajuvavo, mia tomu nene nalo amemeul bereio. ");
INSERT INTO bki_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ana amolmoluo den salo m̃artanbo, mia iorou ka bogo na Yesu bunu meul bereio ea nam̃ariano, nalo nei amiel aban ea bulukomeli lu na Yerusalemo, naruei tomu telabo amialo. ");
INSERT INTO bki_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Naruei kulo na mira nalo, naliko kialo toro na toru, napano aju abitikar Yesu, bogo na amijog m̃ii mukulkulu, nalo amial vite nalo na amalmaluvo, nalo amerou toru, amemebiju, ana nalo aberenio “!Aue, tomu nalo, toro nei be Atua Kenerinio riano ga!” ");
INSERT INTO bki_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A tire nalo telabo ea vio na, nalo ajikili aju koalabo, aju abitivitii Yesu. Nalo na, nanua ajaluvo Kalele ruei, ajum̃a ajakisor Yesu bano-o, a nalo ajum̃a amiija naio. ");
INSERT INTO bki_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ana iviso ka tire nalo nei, tolu nene tai be Mere tira re Maktala, a Mere napano Yemesi naio Yoseve kenielo, a tira napano Sepeti kouano. ");
INSERT INTO bki_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Naruei toro tai na vio Arimatea naio jo, napano naio be Yesu kanano naiagagoano, a naio be toro na sanibaiano, siano Yoseve. Naruei bogo napano vaataro ka m̃erenio rivatove, ");
INSERT INTO bki_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","naio ba jikili jukamu ka Pailat mirano, ana naio bika Yesu mokotenano. Naruei Pailat berii ka kiano kulo na mira nalo ka adu Yesu mokotenano rivan naio. ");
INSERT INTO bki_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ana Yoseve naio midu Yesu mokotenano, mijuvulukoio ka kulum̃arauo tai na miuvu bo, ");
INSERT INTO bki_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ana naio midu ba joa m̃ano buluvae vou, napano aje batitigio vonga. Ana amilivlivi ka puruveru na toru nene binimei, ajubonkokar buluvae nei m̃aratavo nene, ana Yoseve nalo aban bereio. ");
INSERT INTO bki_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ana Mere juo nei, tinene tena vio Maktala, naliko naljuo dolu nene, abinimei ajua vio nei, ajutano memedu ka m̃aratavo na buluvae nei napano Yesu mokotenano jo joomo eaio. ");
INSERT INTO bki_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Vite nalo na amalmaluvo ea legiano na ka rila vite nonovio atu batitigio ea Legiano Lu. Mia bogoti dolu nene, napano naio be Legiano Lu nei naruei, tomu na tortoru na kulo lu nalo naliko Varisis nalo aba ajumolu aju kamu ea Pailat mirano, ");
INSERT INTO bki_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nalo aberinavo “O Pailat, kumemi numisidom nuverial titai kaso beamu vo, napano kumemi numitum̃a numisidomii kia ga toro na sibiano nei, ka bogo napano naio meul kia ga vo, ana naio jom̃a berkar berenio ‘Iorou ka legiano ve tolu, mia kiniou nemeul bereio.’ ");
INSERT INTO bki_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tenene na, kumemi numisidom nuvika denso, ka jau keiila kanamo kulo na mira nalo tai avan ka atukuku ka buluvae na riva ribisi ea legiano tolu nene. Tibe m̃a na mia kiano naiagagoano nalo amei avinalar ka mokotenano, ana mia nalo ala sibi, averial ka tomu nalo averenio ‘Naio meul bereio ea nam̃ariano.’ Verenio tibe na, mia kiano sibiano na iorou nene mia naio rivova laka, tovulu nana jukamu.” ");
INSERT INTO bki_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Naruei Pailat berii kalo berinavo “Mo, bo ga, kamiu kuvuru kiaku na mira nalo tai avano, ka ala vite nonovio tibe ka na kamiu kumisidom, ka kuvitikar vio na.” ");
INSERT INTO bki_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ana nalo aba amila vatitigio puruveru nei a abijuru ka bijuru tai, ka verenio toro tai rikulkulu ka veru nei, mia bijuru nene rivurikorovio, ka mia amijikia avitilubario. Ana abar bunu kulo na mira nalo ajukuku ka vio nene. ");
INSERT INTO bki_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Legiano Lu barlaka, ana legiano napano binimei iorou, napano be legiano moti na sude, bogo napano m̃erenio mijivi, ana Mere na vio Maktala, naljuo Mere dolu, abe juo aba ka aial buluvae nene. ");
INSERT INTO bki_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naljuo aba aboru ea vio nei, sop̃eli ga m̃ii mukulkulu toru, bior Atua kiano nailiano tai moluo den vio mave binimei ea yetemeriba, melivlivilar ka puruveru nei, ana naio ba jotano mave eaio. ");
INSERT INTO bki_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Mirano merera o-o mia, kiano kuluniabene meravo a miuvu mia miuvu kirinovo, ");
INSERT INTO bki_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","mia bogo na kulo na mira nalo amialio, nalo amerou kilkil bano-o mia m̃a am̃arm̃aro yulu kanio garuei aju. ");
INSERT INTO bki_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naruei nailiano nei naio mil ban tira juo nei, naio berinavo “Kamjuo kumerou re. Kiniou nemijikia ka kamjuo kubinimei nei kar ga Yesu napano ajukar naio ea m̃akolkolo, ");
INSERT INTO bki_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","mia naio maka bunu toa vio nei, naio meul jumolu bereio ruei, jibe kanio napano naio berkario jukamu. Kamjuo kumei kuvial vio napano nanua mokotenano mon eaio. ");
INSERT INTO bki_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naruei kuve juo kuvan sop̃eli, kuverialio ka kiano naiagagoano nalo ka naio meul bereio den nam̃ariano. Mia vonganei, naio tukamu rivatove Kalele, mia kamiu kuviniu kuvatove bunu kuvial naio ea vio na. Ninei naruei be kanaku iliano ban kamjuo.” ");
INSERT INTO bki_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naruei naljuo ajuvan buluvae, amila sop̃eli aba. Naljuo abano jibe ka napano amerou kia ga vo, mia ajaaro toru bunu. Naruei abe juo ajikiti aban ka averial lilianiano nei ka kiano naiagagoano nalo, ");
INSERT INTO bki_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","mia naljuo aju aba kia ga jibe na, ana abitavo bija Yesu. Amiilo binvinlo garuei, ana naio mil banlo berinavo “Kavijo bo.” Naruei naljuo aba aminie yetano ka Yesu jaano, ana abe juo abokar jaano, ana amilotu kanio. ");
INSERT INTO bki_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Naruei Yesu berii ka naljuo nei, berinavo “Kamjuo kumerou re. Kuve juo kuvan bereio kuverialio ka kuruaku nalo ka mia nalo ava Kalele, naruei ea vio na mia nalo amijikia aial kiniou.” ");
INSERT INTO bki_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bogo napano tira juo nei aban bereio ea naiagagoano nalo, naruei kulo na mira nalo tealo aban bereio Yerusalemo, aberial vite nalo na amalmaluvo ka tomu na tortoru na kulo lu nalo. ");
INSERT INTO bki_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naruei kulo lu nalo nei aba vio takurano naliko navurim̃araboiano nalo, aberii vite nei bano-o, bisi na abironikar ka abar veru toru ban kulo na mira nalo nei, ");
INSERT INTO bki_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ana nalo amil jikili banlo, aberinavo “Kamiu monokanio kuva kuverialio ga ka tomu nalo, kuverinavo ‘Kiano naiagagoano nalo ga abinimei bogiano, bogo napano kumemi numitum̃a numonmelio, naruei nalo abinalar ka mokotenano, amidu abano.’” ");
INSERT INTO bki_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aber kalo bunu, aberinavo “Verenio iliano na tenei riva rivoru ea Pailat, mia kumemi nuva nuvila vatitigio vija naio, mia kamiu kuvijog re bunu iliano tai.” ");
INSERT INTO bki_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Naruei kulo na mira nalo nei ajaaro ka veru nei, ana abario naruei, ana nalo aba amila ilisibiano janea vio jibe ka na aberii kalo, mila ana Kulo Israel nalo ajum̃a aberver iliano nei binimei bokar banei. ");
INSERT INTO bki_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Naruei naiagagoano duelimo ba tai 11 abatove Kalele, ea burusuku na Yesu berii kalo, ");
INSERT INTO bki_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","mia bogo na nalo amial naio nalo amilotu ka naio, mia nalo tealo ajidom dede ga ka be Yesu p̃eli na maka ve naio. ");
INSERT INTO bki_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Naruei Yesu binimei vaataro kalo, ana naio berii kalo, berinavo “Atua mijamo ka vite nonovio jua jum̃aku, napano mave a na vio yetemeriba nei bunu, ka mia kiniou neje tuboiano kalo. ");
INSERT INTO bki_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tenene na, kiniou nemiila bulag kamiu naruei, ka kamiu monoka kuvan ea m̃atatoko nalo ea vio yetemeriba reraio, monoka kamiu kuvurulo amei ave kiaku naiagagoano nalo, napano kuvaruei ealo ea Teta, Kenerinio a Niununo Lu sialo, ");
INSERT INTO bki_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","a napano kamiu kuverlogloglo ka mia ajogkar iliano nalo napano kiniou neber ka kamiu ruei. Mia monokanio kamiu tiniemiu rimaio ka tulaka ka na mia kiniou noto kitoliko dam̃ariga, rivano-o rivokar juluvati na yetemeriba. Mm.” ");
INSERT INTO bki_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Niosi nei, naio be Ioluano Vou na Yesu Kristo kiano, Atua kenerinio. ");
INSERT INTO bki_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tukunuano na ioluano vou nei naio jikario bija Jone Baruei, jibe napano Atua kiano Iliano Lu beriio nuanua ruei, ea iliano tai napano naverialiano Aisea berialio, napano Atua naio berenio, berinavo “Naio be toro tai na ridu kiaku iliano, napano kiniou nemiila naio biedu jukamu kaso, ka rila vatitigio kiamo m̃arabo nalo ameravo rivu. ");
INSERT INTO bki_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mia naio jom̃a bio ea vio yauo, berinavo ‘Kamiu kuvila vatitigio m̃arabo nalo na Tubo Atua kiano, nalo amemedu rivu, ka naio mijikia rieliel ealo, naio rimaluvo ea kenemiu meuliano nalo!’ ” ");
INSERT INTO bki_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jibena naruei, Jone Baruei naio miyotuba ea vio yauo ea tanobuku na Yutea, ana naio jo mioliolu ka Atua kiano iliano ban tomu nalo. Naio berial banlo berinavo “Kamiu monokanio kuvilig kamiu rivior kenemiu kariano nalo, a kumei, ana mia navaruei ea kamiu ka uei, naruei mia Atua riviekokoa kamiu riviorio.” ");
INSERT INTO bki_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mia tomu telabo laka yako Yerusalemo a ea komeli dolu nalo na ea tanobuku na vio Yutea, nalo aban ka aiagago ka Jone, naruei nalo ajum̃a aber bulag kialo vovaiano nalo ban Jone ana naio baruei ealo ea marauei na Yortano. ");
INSERT INTO bki_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Mia bogo napano Jone Baruei joa vio yauo jibe na, naio mila javukia tormoruo naverialiano re nua nei, Elaija, jibe napano naio maka to riya kulum̃arauo novo nalo leleio, m̃ano kulukoti abie bija vijinio temeul na toru tai ga kamel, mia miorikar m̃ano kulukoti nene bija niati kulubue marauo ga. Mia sano sinaniano ea vio yauo nene, be surubu nalo ga bija vite sese nalo nei napano jago deden mim̃aukanio. ");
INSERT INTO bki_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana Jone berkar ban tomu nalo, berinavo “Mia toro tai, napano kiano moroano loa kiniou, naio mia takisor kiniou rimei. Toro nene loa ka kiniou, mia kiniou maka navare ka nomon korkor neialar kiano kulubue, p̃elina nala im̃auano dolu tai na jibena van naio. ");
INSERT INTO bki_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kiniou nabaruei ea kamiu ea uei ga, mia naio rivaruei ea kamiu ea Niununo Lu.” ");
INSERT INTO bki_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mia maka vesiou, Yesu juvan komeli nei Nasarete, ea tanobuku na Kalele, binimei ea vio na ea marauei nei Yortano, ana Jone baruei ea naio ka uei nene. ");
INSERT INTO bki_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bogo napano Jone baruei ea Yesu bisi, Yesu binimei mave, jaluvo den uei, mia vaarakurano ga tiniabene betavo, ana naio mial ka Niununo Lu jo batove jibe ka vaama tai napano binimei yetano, bujo joa naio. ");
INSERT INTO bki_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ana amijog Atua na tiniabene nei mil batove, berinavo “Jau kobe keneriku novokario ga takurano na, a tinieku jiiso toru. Kiaku jidomiano joaso, kiniou najaaro toru kaso.” ");
INSERT INTO bki_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ana ea bogo nene bunu, Niununo Lu buru Yesu naio takurano ban lie ea vio yauo, ");
INSERT INTO bki_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ana Yesu joa vio na ba bokar bogoti duelimo va veri 40 napano bogo nonovio Sim̃aro jom̃a mila von naio laka. Yesu naio jo bija tededen nalo ea vio nene, mia Atua kiano nailiano nalo abitikar naio. ");
INSERT INTO bki_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mia iorou, abinimei abokar Jone Baruei, ana abuku naio ban ea yimo na lakoiano. Mia Yesu mijog lilianiano nei, karina jaluvo den vio nei, naio ba batove bereio ea tanobuku na vio Kalele, ana jikar ea bogo na, naio jo mioliolu ka Atua kiano Ioluano vou. ");
INSERT INTO bki_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Bogo na naio mioliolu, jo berinavo “Vonganei, Atua mila ka kenemiu bogo memedu ka kuvilig kamiu naruei. Atua kiano navenatuboiano jo binimei ea kamiu naruei, mia vonganei monokanio kuvilig kamiu a kumonea Ioluano Vou nei.” ");
INSERT INTO bki_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iorou kanio, ana na Yesu jom̃a mieliel ea baramudou na burum̃ara ueiyabo na Kalele, mial tomjuo, nam̃a aburuvurua niado, be Saimon bija kuruano Andru, napano naljuo aju aburu kialo levlevi. ");
INSERT INTO bki_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ana naio ber kalo abe juo, berinavo “Kamiu kumei kuvitakisor kiniou. Mia kiniou nala kamiu kuve tomu nalo na avuru tomu nalo amei ave kanaku tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mia vaarakurano ga, naljuo ajuvan kialo levlevi, ajakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Karina Yesu miel ba lie kija, ana mial Sepeti kenerinio abe juo, be Yemesi naio kuruano Jone. Nalo aju ajutano joomo ea kialo uako ana nalo abe juo amila batitig kialo levlevi. ");
INSERT INTO bki_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mia bogo napano Yesu mial naljuo nei, naio bio naljuo, ka atakisor naio bunu, mia ajuvan karam̃alo Sepeti joa uako bija kialo tomu nalo na im̃auano, ana naljuo ajakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ana Yesu nalo amiel aba abokar m̃arkomeli na Kapeneam, a ea Legiano Lu, nalo aba joomo ea yimo na volkouano, ana Yesu jo berloglog tomu nalo ka Atua kiano Iliano Lu. ");
INSERT INTO bki_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mia nalo napano amiagago nalo amiilo laka, bior nalo amijog Yesu kiano verloglogiano maka tibe ka kialo naverloglogiano dolu nalo, bior napano Yesu kiano temi vatitig bo, ana Atua kiano moroano joaio. ");
INSERT INTO bki_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ana ka bogo na, toro tai napano niununo va joaio, naio jo naliko, ");
INSERT INTO bki_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ana mila toro neibano miaga va souo, naio mil ban Yesu berinavo “?Yesu re Nasarete, kiamo venia jua kumemi? P̃eli na jau kobinimei ka kala lelan kumemi, a! Kiniou namijikiaso ruei, ka jau kobe kirinovo, kobe Atua kiano Tolu tai.” ");
INSERT INTO bki_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mia Yesu mil kirisikili ban niununo va neibano, joko vio ka naio, berinavo “E! Jau keil re! Jau kataluvo den toro na vonganei ga!” ");
INSERT INTO bki_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mia niununo va neibano naio mila kema neibano naio miaburusalsal, ana naio miaga souo vaarakurano bereio, naruei naio moluo den naio ana buro bano. ");
INSERT INTO bki_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mia tomu nalo na vio na amiilo laka, nalo ajum̃a aberverii Yesu, aberinavo “?E jum̃abe nei? ?Verloglogiano vou tai bereio nei, p̃eli venia na? Toro na, kiano moroano kirisikili laka na, naio mil ga ban niununo va nalo, nalo amijogkar naio.” ");
INSERT INTO bki_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kar vite nalo na naruei nalo ajaaro, ana nalo ajum̃a aber vatitig Yesu siano novo ban ea vio nonovio ea tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mia Yesu naliko tomu nalo nei, Yemesi bija Jone a Saimon bija Andru, nalo abatavio ea yimo na volkouano mia nalo aban ea Saimon naio Andru kunualo, ninei ea m̃arkomeli na Kapeneam kia ga vo. ");
INSERT INTO bki_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Naruei ea m̃aratavo nene, Saimon kenieno simemi, naio mie m̃a niabene bituvitunu na naio jom̃a mon ea ga m̃ano jogu, mia nalo aberial ka Yesu. ");
INSERT INTO bki_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ana Yesu naio binimei bokar tiramoruo neibano jum̃ano, naio burular naio jumolu, jotano ea m̃ano jogu, ana niabene minini bereio, mia naio jumolu ju, ba borosebi salo. ");
INSERT INTO bki_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ea kijev na legiano nene, bogo napano Legiano Lu bisi, bogo na m̃erenio batove ruei, mia tomu nalo abarvar tomu nalo na amie bija nalo na sim̃aro nalo abujo ealo abinimei ea Yesu. ");
INSERT INTO bki_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mia tomu nalo miroano laka, jibe ka napano vaataro ka tomu nalo na m̃arkomeli neibano abinimei amivinkakarlo vatitig ea m̃aratavo na yimo neibano, vio telisu. ");
INSERT INTO bki_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Mia Yesu naio milarur tomu nalo miroano na amie ka mieiano ninio nalo, naio mijil bulag sim̃aro miroano den tomu nalo, naio joko vio ka sim̃aro nalo neibano ka nalo aver re titai leleio, ka napano nalo amijikia ruei ka naio be Naverikariano riano. ");
INSERT INTO bki_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mia ea vio niogoravo, bogo na tu naio maka tokokoreko vo, ana Yesu naio jumolu jaluvo den yimo, mia naio ban ea vio tai napano vio melumu bo laka, mia naio rivolkouo rivan karam̃ano. ");
INSERT INTO bki_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ana iorou, tomu nalo abinimei ka naio ea yimo bereio, mia Saimon nalo maka bunu aial naio, mia nalo aban ka asiravo naio. ");
INSERT INTO bki_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nalo ajiravo naio bano-o, nalo amilealio ea vio nei, mia nalo aber ka naio, aberinavo “Tomu dolu nalo miroano abinimei kaso, mia nalo aju ajiragso.” ");
INSERT INTO bki_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ana Yesu berdop̃e banlo, berinavo “Riano, kiniou nemijikia na. Mia makanio, kito monokanio ravan lie ea m̃arkomeli dolu nalo napano aju kia vo, ka mia kiniou nemijikia noioliolu ka ioluano vou nei ea vio dolu nalo bunu. Ka tena naruei, kiniou najaluvo yako nebinimei ea vio nei biorio.” ");
INSERT INTO bki_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mia Yesu naio ba mieliel ea vio nonovio na Kalele, na naio jo mioliolu ea yimo na volkouano na kulo Ju nalo kialo, a jo mijil bulag sim̃aro telabo den tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mia toro tai napano bokar menko burumieni naio binimei ea Yesu, naio minie tano keanio, naio bika kirisikili denio, berinavo “Neber bo, ver jau kojamo ka ga, kiniou nomonea ka jau komijikia kolarur kiniou, nomeravo bereio.” ");
INSERT INTO bki_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mia Yesu tinien miia naio laka, ana naio maka river mirou ka tokolio ka kiano mieiano, mia naio midu jum̃ano joa naio, ana berkanio “Kiniou nemijamo; voniganei niabemo monoka rimeravo.” ");
INSERT INTO bki_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mia vaarakurano ga menko burumieni neibano naio jaluvo den toro nei niabene, naruei naio meravo bereio. ");
INSERT INTO bki_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Mia Yesu jutua naio, berinavo “Jau komijog, jau kava koververii re tenei van tomu nalo vo, a voniganei ga jau kova kosel ea toro lu ka naio mijikia rivitii veve niabemo. Karina jau komijikia kava kala lotuano van Atua vija koisebi bunu ga sida ka meravoiano nei napano m̃a Mosis naio berenio, napano toro monoka rilaio bior vite na jibena. Karina iorou ka nina, toro lu naio mijikia riverialio ka menko burumieni nei naio biniu ruei.” Ana Yesu miila toro neibano bano. ");
INSERT INTO bki_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ana bogo na toro neibano naio bano, mia naio ba jo berii tenalo neibano ka tomu nonovio, mila na iliano neibano ban ea vio nonovio, bano-o napano mila Yesu naio maka bunu rijikia ka riel ka riva joomo ea m̃arkomeli nalo, ka ver naio rivano, tomu ve miroano laka amei ka naio. Naio jojo tavio ga ka vonuo, mia tomu nalo amalmaluvo ea kialo vio nonovio kiavo, nalo abinimei eaio. ");
INSERT INTO bki_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ana bogoti nalo tealo abarlaka ruei, ana na Yesu naio ban bereio ea m̃arkomeli napano Kapeneam, a maka ve kirisiou, mia tomu nalo amijogial ka naio binimei bereio ruei. ");
INSERT INTO bki_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ana nalo miroano abinimei ea Yesu, mia joomo ea yimo neibano naio bujomagmago kalo, a tavio ea m̃aratavo bunu, vio telisu ga. Mia bogo napano aju vio takurano jibe na, ana na Yesu mioliolu ka Atua kiano iliano lu banlo. ");
INSERT INTO bki_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mia ea bogo nene, tomu nalo ap̃ier nalo tai napano naio mie binimei, napano niabene nonovio m̃aro. Mia nalo veri ap̃ier ea ga m̃ano jogu, napano naio jo monmoneaio. ");
INSERT INTO bki_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mia bogo napano abinimei abokar vio neibano, amial ka vio nene teliki laka, mia nalo maka ajikia adu kialo bilbilu nei rivan vaataro ka Yesu. Naruei nalo ap̃ier abavin ea yimo mave, ana nalo amuedulu vodobi loglog vio napano Yesu naio jo memedu kanio yetano, ana ajuvarvan toro nei batove bija m̃ano jogu batove ea buluvio, batove joomo ea yimo. ");
INSERT INTO bki_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mia bogo na Yesu mial vite nei, naio mijikia ka tomu nalo nei amonea naio kirisikili laka, ka mia naio rijai toro neibano mie nei, mia Yesu ber ka kema neibano mie nei berinavo “Keneriku, kiniou nebiekokoa kiamo kariano nalo.” ");
INSERT INTO bki_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ea bogo nene tomu nalo tai tena naverloglogiano na tuboiano, nalo bunu ga aju, mia nalo amijog Yesu kiano iliano. Ana kialo jidomiano jo mim̃au bova ka vite nei, ");
INSERT INTO bki_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","nalo aju amil niege naio, aberinavo “Jum̃abe ana toro nei naio mil mila bulag Atua siano lu jibe na? Atua naio takurano ga naio mijikia riviekokoa kariano, maka bunu toro dolu tai bereio, ana kema nei naio jo mil jibe ka naio jo jidomii ka beriam̃a naio be Atua naruei.” ");
INSERT INTO bki_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mia vaarakurano ga Yesu naio mijoglubar ea naio mijikia ka tomu nalo neibano aju ajidomii va jibe na ka naio, mia naio ber kalo berinavo “?Ka vaio ana kenemiu iviso bujo ka jidomiano va nalo na jibe na? ");
INSERT INTO bki_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A ver kiniou never tibe nei ka namieiano nei neverinavo ‘Kiniou nebiekokoa kiamo kariano’ p̃elina kiniou never kanio, neverinavo ‘Jau kotumolu, kojuku m̃amo jogu ana keiel,’ ana ea iliano juo nei, tai naio jikili ka averenio, ana tai naio monmaio ga ka averenio. Ana naina berinavo ‘Kotumolu keiel,’ naio jikili bior ka kamiu kuvijikia kuvitilubar kiaku iliano nei naio be riano p̃elina naio maka rive riano, ka toro nei naio tumolu p̃elina makanio. ");
INSERT INTO bki_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mia vonganei, kiniou noim̃auka titai napano mia kamiu kuvisidomii kuver Atua ga takurano naio mijikia rim̃aukanio, ka mia kamiu kuvijikia kuvitilubar ka kiniou Kulorinio Kenerinio, kiaku moroano bare ka noviekokoa bunu kariano na yetemeriba nei. Kamiu kuviagago vatitigio.” ");
INSERT INTO bki_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ana na Yesu mil ban namieiano nei, berinavo “Kiniou neber kaso, jau kotumolu, kojuku m̃amo jogu, keiel kava vonuo.” ");
INSERT INTO bki_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mia kirisop̃eli ga ea tiniobi miralo napano aju amialio, toro neibano naio jumolu ana na naio mijuku m̃ano jogu, ana miel ba tavio ba vonuo. Bogo na tiniobi neibano amial tenei, mia nalo amiilo toru, abamenea Atua, aberinavo “Koig, kito maka lele reial titai tibena ea kiado meuliano, mia banei ga.” ");
INSERT INTO bki_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mia Yesu batove tivelinio bereio ea burum̃ara ueiyabo neibano, mia tiniobi nalo abinimei vio takurano aju jeliviv eaio, naio berlogloglo. ");
INSERT INTO bki_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Karina, naio mieliel ba lie, mia naio mial toro tai jotano joa kiano vajoomo na im̃auano ea yimo na abarivar bijii veru na takis. Toro nene, be Livai, Alveas kenerinio. Ana Yesu bio naio berinavo “Komei kotakisor kiniou,” mia sop̃eli ga Livai naio jumolu ana jakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Karina, Yesu ba jinano ea Livai neibano kunuano, mia ea bogo na, tilikiti na tomu dolu nalo na abarvar bijii takis, bija tilikiti na veribinio dolu nalo, nalo bunu abinimei ajutano burukuti bija Yesu naliko kiano naiagagoano nalo, bior napano bogo nei, tomu ninio ga aju ajakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mia tomu na verloglogiano na tuboiano tealo, napano nalo abe Varisis, nalo amial ka Yesu naio jom̃a jotano burukuti bija tomu nalo na jibena, ana nalo abika den naiagagoano nalo aberinavo “?Kar vaio ana kenemiu naverloglogiano naio ba jom̃a jinano burukuti jibena bija tomu veribinio nalo na?” ");
INSERT INTO bki_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mia Yesu naio mijog iliano nei, mia naio berdop̃e berenio banlo, berinavo “Nalo napano mokotenalo kirisikili bo, nalo maka asidom ka ava aial toro nam̃a mieliel ka namieiano nalo, mia namieiano nalo ajidom m̃elea naio. Kiniou maka nemei ka novio tomu nalo na aber nalo amemedu ruei ea Atua mirano ka nalo atakisor kiniou, mia kiniou nebinimei ka tomu nalo na abova ajibe ka tomu nalo nei naruei.” ");
INSERT INTO bki_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Naruei ea bogo nei, Jone Baruei kiano naiagagoano nalo bija Varisis nalo ajum̃a abokar bajago na veliano na sinaneano ka nalo abolkouo ban Atua. Ana tomu nalo abinimei ea Yesu, mia abika veve denio, aberinavo “?A jum̃abe? Jone Baruei kiano naiagagoano nalo abel ka sinaneano kam̃a abolkouo, a Varisis nalo kialo naiagagoano bunu ga amila jibe na, ana jum̃abe na jau kiamo naiagagoano maka atum̃a alaio?” ");
INSERT INTO bki_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ana Yesu berdop̃e banlo, berii naio naliko kiano naiagagoano nalo jibe kanio napano nalo ajaaro toru laka bogo napano naio jo naliko, mia nalo ajog rivova iorou ka bogo napano mia naio taluvo denlo, ana berinavo “?Bogo napano toro na naio joro jo kia ga vo ea jokoluolu naliko kiano bilbilu nalo, kamiu kuberiam̃a amijikia atuvan sinaniano na jokoluolu? Maka leleio. ");
INSERT INTO bki_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mia bogo tai navo, ver bogo tai toro nei kiano uolu tai amei avurular naio den kiano bilbilu nalo, ea bogo na naruei mia kiano bilbilu nalo amijikia aveli ka sinaniano, bior napano nalo tiniel miia naio laka.” ");
INSERT INTO bki_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Bajago na veliano na sinaneano, naio be bajago moruo tai na kulo Ju nalo kialo lotuano, mia Yesu naio jidom rila rimeravo vanlo ka bajago moruo na jibe na, nalo maka ajikia aveverare rivija vite vou nalo napano naio jom̃a berlogloglo kalo. Ana naio ber jamerijiano tai tivelinio kalo, naio berinavo “Kito maka rejikia rodu niati kulum̃arauo napano be terivou, ka rotuluko ka kulum̃arauo moruo tai ka toko bulukuti vio na burup̃e eaio. Bior napano niati kulum̃arauo vou nei naio mijikia rila korov kulum̃arauo moruo na togio, ana mia bulujeleigio mijikia rimei ve toru lievo. ");
INSERT INTO bki_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ana m̃arjum̃elm̃elu vou napano naio jom̃a jarabujo kia ga vo, maka rojikia roisonio rivan ea kulukuti nani napano be terimoruo, napano amison m̃arjum̃elm̃elu ban ea vatelabo ruei. Verenio jau kala tibe na, mia m̃arjum̃elm̃elu nene riyukuio, rila kulukuti nani nei saburu, mia m̃amo m̃arjum̃elm̃elu riou bulagio ana bauei nene rimei rivova bunu. Mia m̃arjum̃elm̃elu vou, jau monokanio koisonio rivan ea kulukuti nani napano be terivou bunu, jikili bo, naruei na jau komijikia kodu batitigio to vesiou.” ");
INSERT INTO bki_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana ka legiano tai bereio, napano naio be Legiano Lu, Yesu naliko kiano naiagagoano nalo amiel abano, mia kialo m̃arabo ba jel bure tiniavio na subavio. Nalo amiel jibe na, naruei naiagagoano nalo jijerlo ana amikiti kokorov subavio nei m̃arati tealo ana ajenio. ");
INSERT INTO bki_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nalo ajum̃a amila jibe na, naruei Varisis tealo ajua vio na, napano aju abitii Yesu nalo, naruei nalo aber ka Yesu, aberinavo “Ai, kal kija! Kiamo naiagagoano nalo aju amila jum̃abe na, mia nalo maka ajikia ala im̃auano na ea Legiano Lu, ver tibe na nalo ajum̃a amila korov kiado tuboiano na.” ");
INSERT INTO bki_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ana Yesu berdop̃e banlo, berinavo “?P̃eli kamiu maka kuvuluku Iliano Lu bogo tai bo, napano berii vite nalo napano Parinio Tubo Teviti na nanua naio jom̃a milaio? Naio naliko kiano tomu nalo, nalo jijerlo m̃ele, ");
INSERT INTO bki_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ana naio ba joomo ea Atua kiano vio lu, ana naio midu joko lu napano tuboiano ber kulo lu ga amijikia asenio, mia Teviti nalo nei ajenio. Ana Abieta, napano naio be parinio toro lu ka bogo na, naio mijamo ka banlo ga. ");
INSERT INTO bki_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kiniou neber ka kamiu, neber kiado tuboiano nalo maka ka atutua niegeniege kito bereio. Jibe na, Legiano Lu naio maka ve tena rila bulag kiado meuliano bereio, mia naio be tena ka rijai kito. ");
INSERT INTO bki_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mia kiniou nebe Kulorinio Kenerinio, a naio be tubo ka vite nonovio, naio naruei be tubo ka Legiano Lu bunu. Mia naio ga mijikia river venia napano ramijikia rala ea Legiano Lu, p̃eli venia na maka rimemedu ka kito ralaio.” ");
INSERT INTO bki_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ana ea Bogoti Lu tai bereio, Yesu naio ban bereio ea yimo na volkouano, mo na ka bogo nene, jumevuluku tai naio jo joomo bunu napano naio jum̃ano buluku. ");
INSERT INTO bki_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mia Varisis tealo napano tiniel jer Yesu ruei, nalo aju vaataro ka ga Yesu ea bogo neibano, nalo ajum̃a miralo jua ga Yesu ka ajidom aleal bajago va nalo eaio Yesu. Naruei nalo ajidom ka aial von ka ver Yesu rilarur kema neibano ea Bogoti Lu nei p̃eli mia rila re. ");
INSERT INTO bki_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mia Yesu naio mil ban kema neibano, berinavo “Jau kotumolu, komei mave nei beamu vo.” ");
INSERT INTO bki_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ana Yesu bika den tomu nalo na aju, berinavo “?Kiado tuboiano naio berinavo kito romijikia rola venia ea Bogoti Lu? ?Naio bo ka kito reim̃auka tena bo, p̃eli na bo ka kito reim̃auka tena bova? ?P̃eli na naio berinavo bo ka kito ralarur tomu nalo, p̃eli na bo ka kito rouebinvinlo?” Mia tomu nalo neibano maka leleio aver iliano tai bereio. ");
INSERT INTO bki_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naruei Yesu jirarag jeliviv ealo, napano naio mial miralo nalo kirisikili ga, mia naio mijog bova toru biorio a naio tinien jerlo. Naruei naio mil ban kema neibano bereio, berinavo “Kala von ka kovitirii jum̃amo beamu vo,” mia ea bogo na ga toro na mila jibe na, jum̃ano binimei bo bereio. ");
INSERT INTO bki_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mia Varisis nalo nei abava tavio, aban memedu ga abiviuo vio takurano bija Parinio Tubo Erot kiano tomu nalo, ka nalo alavon ka aleal m̃arabo ka amijikia auebin Yesu rim̃aro tum̃abe. ");
INSERT INTO bki_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ana Yesu naliko kiano naiagagoano nalo ajaluvo denlo abatove bereio ea burum̃ara ueiyabo, mia tomu nalo miroano ajakisorlo abatove. Tomu nalo neibano, tealo abinimei ea vio dolu nalo tealo ea vio nei Kalele, ");
INSERT INTO bki_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ana nalo tealo abinimei rove yako ea vio Yutea bija kiano m̃arkomeli nei Yerusalemo, mia tealo abinimei ea tanobuku na vio Itumea, a tealo abinimei ea vio nalo napano marauei na Yortano tivelinio bano, ana tealo abinimei ivin ea tei napano toru laka ea komeli nalo na ea komeli juo nei, Taia bija Saiton. Nalo nonovio nei abiniu nalo amijog ruei iliano na vite nalo napano m̃a Yesu naio jom̃a milaio, naruei nalo ajidom ka amei kanio. ");
INSERT INTO bki_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ana bogo napano nalo miroano aju tivelinio ea ueiyabo napano ana Yesu ber ka kiano naiagagoano ka nalo averiko tauako sesa tai to, ka tomu nalo miroano laka, mia naio merou ka mia tomu nalo amei m̃a aivinkakar naio laka. ");
INSERT INTO bki_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nina bior naio milarur tomu nalo miroano napano amie amijog bo bereio ruei, naruei tomu dolu nalo na amie kia ga vo nalo ajum̃a amila von ka aivinlo tibe na ka mia nalo bunu amijikia atokol Yesu. ");
INSERT INTO bki_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mia ka bogo nene aver niununo va nalo tai napano ajua tomu nalo tealo, bogo na amial Yesu, mia nalo monokanio avatove ka naio, nalo ajorua jaano, abio toru, aberinavo “Jau kobe Atua Kenerinio.” ");
INSERT INTO bki_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ana Yesu mil kirisikili ban niununo va nalo neibano berburelo, berinavo mia nalo atu re aververii ka tomu nalo aver naio be kei. ");
INSERT INTO bki_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Naruei iorou kanio ana na Yesu naio bavin mave ea suku nalo, ana naio bio tomu nalo tai abinimei eaio. ");
INSERT INTO bki_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bogo na nalo abinimei, naio bitiri bulag nalo duelimo ba juo 12, naio ber nalo ave atevi nalo, napano kialo im̃auano naio jibe nei, mia nalo aiel vija naio tulaka ka mia naio rilalo avar ioluano vou avan ea vio nalo, ");
INSERT INTO bki_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a mia moroano na ajil bulag sim̃aro nalo tualo. ");
INSERT INTO bki_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Naruei Yesu kiano atevi duelimo ba juo 12 sialo ajibe nei: Saimon, napano Yesu midu sio vou joa berinavo Pitere. ");
INSERT INTO bki_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","A Yemesi, napano Sepeti kenerinio. A Jone napano Yemesi kuruano napano Yesu midu sio vou ban naljuo nei, berinavo Boanejes, napano ber nalo abe juo atibe ka tubaal memedu, bior naljuo na niolo jaburu julaka ga. ");
INSERT INTO bki_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","A Andru, a Vilip, a Bartolomio, a Mataiu, a Tomas, a Yemesi, napano Alveas kenerinio, a Tatesa, a Saimon, napano naio mila poletik die kulo Romo nalo. ");
INSERT INTO bki_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","A Jutas na Kariot, napano iorou kanio, ana naio jiveluku ka Yesu ban kiano uolu nalo. ");
INSERT INTO bki_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ana iorou, Yesu naio binimei bereio vonuo, mia tiniobi toru abinimei ka naio bereio, ana Yesu bija kiano naiagagoano nalo amim̃au kalo bano-o nalo maka bunu averio ajilimebi kija ka asinan. ");
INSERT INTO bki_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Naruei Yesu kiano torogio nalo amijog ka napano Yesu naio jo mim̃au m̃ele jibena, a nalo amijog bunu ka tomu nalo ajum̃a amil dieio, aberinavo “P̃eli kema nei, naio milaluvu parinio ruei kovio!” Mia Yesu kenieno bija kuruano nalo aban ka ajidom ka alavon ka avurular naio den tomu nalo nei. ");
INSERT INTO bki_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Naruei ea bogo nene, tomu nalo na naverloglogiano na tuboiano, nalo ajaluvo den vio Yerusalemo abatove ea vio neibano, mia nalo ajum̃a amilidie Yesu ban tomu nalo ajum̃a aberial, aberinavo “Sim̃aro nalo kialo Tubo Belsabel, naio ba joa toro na ruei,” a nalo aju bunu ga aber “Toro na naio jom̃a jitig bulag sim̃aro ea moroano na ga napano Belsabel juvan ban naio.” ");
INSERT INTO bki_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Naruei Yesu biolo abinimei eaio, ana na naio mil banlo ea jamerijiano, berinavo “?Jum̃abe na kamiu kuberiam̃a Sim̃aro bereio naio mijikia titiglar sim̃aro. Maka rijikia tibe na! ");
INSERT INTO bki_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","A verenio tubo tai napano kiano tomu nalo avuruburelo, napano togio atum̃a aildie nalo togio, mia tubo neibano naio kiano im̃auano nalo maka rijikia atu sikili leleio. ");
INSERT INTO bki_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ana verenio ea m̃aratavo tai na nalo ajum̃a aburuburelo napano nalo togio ajum̃a ajitig nalo togio, mia nalo maka leleio ajikia atu rivu bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A jibe na bunu ga, averenio niadu nalo na Sim̃aro kiano togio nalo atumolu alavon ka ajil bulag togio dolu nene, nina jibe ka moroano na Sim̃aro kiano maka bunu rijikia tumolu tu, kiano moroano bakovio ruei. Mia maka leleio, Sim̃aro p̃irinio kirisikili dolu ga kiana vo. ");
INSERT INTO bki_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“!Kuvijiio! Verenio toro tai sidomii ka riva joomo ea toro kouo tai kunuano ka mia naio rivina ka kanano saba nalo, mia naio monoka rivar teli riorkar toro kouo nei sikili beamu vo, avona bisi ana mo naio mijikia riva joomo ka rivina ka nonovio saba nalo na be toro kouo nei kanano. Mia kiniou nojom̃a nomila jibe na naruei ka toro kouo neibano Sim̃aro. ");
INSERT INTO bki_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mia kiniou neber riano ka kamiu, tomu nalo kialo kariano bija iliano va nalo nam̃a ajum̃a aberenio, Atua mijikia riviekokoalo riviorio, ");
INSERT INTO bki_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","mia toro na mil bova lelan Niununo Lu naio berenio kiano im̃auano tealo Sim̃aro ga naio mim̃aukanio, toro na jibe na naio mia maka lele rijikia rivokar viekokoano bogo tai, kiano kariano naio mia toa naio rivano-o, mia maka rijikia ribisi.” ");
INSERT INTO bki_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Naruei Yesu naio berii vatitig iliano jikili nei banlo, bior nalo naruei ajum̃a aberii ruei ka niununo napano joa naio, be niununo va. ");
INSERT INTO bki_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mia Yesu kenieno bija kuruano nalo abinimei amiyotuba kean naio ea bogo nei, mia nalo abinimei ajikili aju tavio ga, na amiila toru ban ka naio rimoluo rimei rialo. ");
INSERT INTO bki_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ana ea bogo na, tiniobi toru ajutano vaataro ka Yesu, mia iliano binimei bokario, ana nalo aberinavo “Ai, koniomo bija kuruamo bija kuviviniemo nalo aju tavio, ajidom ka ail kijaso beamu vo.” ");
INSERT INTO bki_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ana na Yesu berdop̃e berinavo “?A kenioku nalo be kei? A nalo na abe kuruaku nalo abe kei?” ");
INSERT INTO bki_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Naruei naio jiraravo bitikar tomu nalo napano ajum̃a ajutano vaataro ka naio, ana berinavo “!Kamiu kuvial, nalo nei abe konioku bija kuruaku nalo, nalo nei naruei. ");
INSERT INTO bki_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bior toro napano mila jibe ka napano Atua jidomio, toro na jibe na naio be kuruaku, a be kuvivinieku, p̃eli na abe konioku ruei.” ");
INSERT INTO bki_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana ea bogo dolu bereio, Yesu naio jo berloglog tomu nalo ea tivelinio na ueiyabo na Kalele. Mia tomu telabo laka napano abinimei ea naio ka bogo na, mila na naio bavin ea uako sesa tai napano joa ueiyabo nei, ana naio ba jotano mave eaio, mia tomu nalo aju reraio ea baramudou uro. ");
INSERT INTO bki_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mia Yesu jo berlogloglo ka vite telabo ea jamerijiano nalo, ");
INSERT INTO bki_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","mia naio ber kalo berinavo “Kamiu kuvilavon ka kuviagago vatitigio. Toro tai, ban ka rivisivisii kurukuti subavio ea kiano tiniavio. ");
INSERT INTO bki_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Naio jo bisivisiio jibe nei bano, mia kurukuti tealo ajibirbili vaataro laka ka ikim̃arabo tivelinio. Ana iorou, menu nalo abinimei amikiti bulaglo bereio. ");
INSERT INTO bki_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Mia kurukuti tealo ajibirbili ea vio na be tabaver yetano, mia ea vio na maka tano rimerorolu napano rivu mave, mila na nalo amiluo sop̃eli. ");
INSERT INTO bki_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mia bogo na m̃erenio mijivi ana naio junulo ana sop̃eli ga amekekeu ka bati nalo maka avatove vatitigio. ");
INSERT INTO bki_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Mia nalo tealo ajibirbili ea vio tai na beamu maka ate bulag vatitig teli va nalo na beve niononoti ealo, mia iorou teli neibano miluo toru bereio, ana naio misoveko kialo vitoviano nalo bano-o am̃arm̃aro, mia maka ave m̃arati nalo. ");
INSERT INTO bki_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Mia kurukuti dolu tealo bereio, ajibirbili ea borotano novo tai, mia nalo amiluo bo, bano-o ajarako abar m̃arati nalo. Tealo abar m̃arati abokar duelimo va rolu 30, nalo tealo abokar duelimo va ari 60, mia nalo tealo abokar toromomou takurano 100.” ");
INSERT INTO bki_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mia Yesu naio berkalo berinavo “Kamiu kubiniu kube burutiliniemiu, bo ka kamiu monokanio kuvijogkar kiaku iliano nalo.” ");
INSERT INTO bki_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ana iorou kanio tiniobi nalo abanvan bereio, ana na Yesu jo naio takurano ga, naruei tomu nalo napano aju bija naio bija kiano naiagagoano nalo, abinimei abika den naio aberinavo “Vaio naruei naio be nioti na jamerijiano na? Mia ka vaio ana jau kojom̃a komil jibe na, a koberloglog tomu nalo jamerijiano nalo?” ");
INSERT INTO bki_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Ana Yesu berdop̃e banlo, berinavo “Kiniou nojom̃a neberlogloglo ka jamerijiano nalo na bior abe veribinio laka. Nalo ajibe ka, ajum̃a amila iliano tai na naverialiano Aisea nua binimei maluvo, napano naio berenio ‘Nalo ajum̃a abitii, abitiio bano, a aju amijogii, amijogiio bano, mia maka lele aver avitilubar a maka lele mia ajog lubar vite. !Ver makanio, p̃eli nalo avilig kialo jidomiano nalo ruei, a p̃eli Atua biekokoa kialo kariano ruei!’ “Jibe na naruei kiniou neber nalo pariparilo kirisikili laka, nalo aju koalabo laka keano vo. Mia kamiu naruei bo lie vo ban kamiu. Ililuklukuano nalo na Atua kiano navenatuboiano, mia kiniou neverial rimeravo ga rivan kamiu. ");
INSERT INTO bki_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“?Ana jum̃abe, kamiu maka kuvijoglubar nioti na kurukuti subavio neibano? A ver kamiu maka kuvijikia kuvisidomii lubarbar nioti nene, mia tum̃abe naruei na mia kamiu kuvijoglubar jamerijiano dolu nalo na mia kiniou neverio ka tomu nalo?” ");
INSERT INTO bki_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ana Yesu berinavo “Mo, mia kiniou never bisivisii nioti na jamerijiano neibano van kamiu. Nioti nene naio jibe nei: Borotano ninio nalo na, nalo ajibe ka tomu nalo kialo iviso ninio nalo. Mia toro nei nana jo bisivisii kurukuti ea borotano nalo na, naio jibe ka toro napano jom̃a berial Atua kiano iliano ban tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Borotano na kirisikili na jel ikim̃arabo tivelinio, naio jibe ka toro na napano naio mijog Atua kiano iliano, ana iliano nene maka lele riva joomo vatitig ea kiano iviso na jikili leleio. Mia menu nalo neibano, ajibe ka Sim̃aro, napano naio binimei vaarakurano ga, naio midular bereio iliano nei ea toro napano kiano iviso. ");
INSERT INTO bki_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“A borotano na puruveru toru yetano tabap̃ilio, naio jibe ka toro na napano naio mijog Atua kiano iliano, mia kirisop̃eli ga naio tiniene jaaro kanio, miduio. ");
INSERT INTO bki_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ana iliano nene naio maka totano vatitig joomo ea kiano iviso. Mia naio miluo jibe ka titai napano maka ve sano bati novo, napano mijikia riluo bogo ve bulati ga. A verenio bogokouo rimei p̃elina tomu nalo asidom ka ajil lo rivior ka amonea Atua kiano iliano, a mia sop̃eli ga nalo atuvan bereio. ");
INSERT INTO bki_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Mia borotano na napano teli na bova juaio, naio jibe ka tomu nalo napano bogo na amijog Atua kiano iliano, ");
INSERT INTO bki_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mia karina, nalo ajum̃a ajidomii m̃elea ga kialo meuliano nalo, a jidomii ka avar vite ve telabo rimei rive sibiano ga rivanlo, a nalo ajum̃a ajidomii m̃elea vite novnovo nalo na yetemeriba nei. Bajago nalo na abinimei jibe ka teli va, ana na amikitiko ioluano vou nei ka rivar re m̃arati ea tomu nalo tibe na ea kialo meuliano. ");
INSERT INTO bki_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ana borotano na bo na, jibe ka tomu nalo napano bogo na nalo amijog Atua kiano iliano, amijoglubario ana tiniel jaaro kanio a amiduio ea kialo iviso ana iorou kanio abar m̃arati na ioluano vou neibano ea kialo meuliano nalo, napano na tealo abar m̃arati duelimo va rolu 30, a tealo abar m̃arati duelimo va ari 60, a nalo tealo abar bokar toromomou takurano 100. “Ninei naruei jamerijiano na kurukuti uiti, naio bisi ea vio na.” ");
INSERT INTO bki_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mia Yesu ber bereio banlo, berinavo “Kito tomu nalo, ver kito rotilan yulu tai, mia kito rodu van re to yetano ka basaro tai. Maka leleio, kito monokanio rotilan to mave ga ka rimererali vio vatitigio. ");
INSERT INTO bki_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A bo ga, Atua kiano navenatuboiano naio jibe ka yulu na, napano vonganei naio jo malmaluvo terteliki ea kito ka rimermerali vite nonovio nalo, a mia vite nonovio napano ajuluku ju, a bija ililuklukuano nonovio mia monoka amei medave. ");
INSERT INTO bki_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mia kamiu nonovio kube burutiliniemiu, bo ka kamiu kuvijoglubar kiaku iliano nei.” ");
INSERT INTO bki_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mia Yesu ber kalo bereio, beri-navo “Kamiu monoka kuviagago vatitig ka kiaku iliano nalo, a kuvila von ka kuvisidomii vatitiglo. Toro na jo mijog ga mia maka to takiio, mia naio maka bunu rijikia rijoglubar vatitigio bereio. A toro na mijogkar kiaku iliano nalo, mia naio mijikia rijoglubarbar vatitig kiaku verloglogiano ve telabo iorou. ");
INSERT INTO bki_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Toro napano kiano saba nalo miroano ruei, mia naio rivar lie ve miroano laka, mia toro na maka kiano saba, mia naio rilaluvu vaio napano kiri teliki na be kiano.” ");
INSERT INTO bki_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ber bereio, berinavo “Atua kiano navenatuboiano naio jibe kurukuti napano toro bisivisiio ea kiano borotano. ");
INSERT INTO bki_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bogo na naio bukuio bisi, mia naio maka bunu river rila titai ka kurukuti nene bereio. Toro neibano monmelio, jumolu, monmelio, jumolu, bogiano bija legiano, mia kurukuti nene naio ga takurano bitovi moluo, ana jo miluo. Jom̃a miluo jibe na banbano-o mia toro neibano maka lele rijikia ka kurukuti neibano jom̃a miluo jum̃abe. ");
INSERT INTO bki_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Toro nei maka rijikia, naio maka rila titai, mia vite nei miyuku jum̃ano nalo aba laka, ana maka vesiou bar niati, bano-o bar nioti. ");
INSERT INTO bki_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","“Naruei bogo na nioti meruo bo, kema neibano jikario ka mim̃au bereio naruei, midu kiano iobogu ba je bulag m̃arati. “Mia Atua kiano navenatuboiano jom̃a miluo tertelisu jibe ka jeliviv ea vio yetano nei vonganei, a ea bogoti tai, mia reial m̃arati na toru naio rimei mave.” ");
INSERT INTO bki_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ana Yesu ber bereio, berinavo “Bajago na Atua kiano navenatuboiano, naio be dolu laka, naio kirisikili ka mia neleal jamerijiano tai bereio ka never naio jum̃abe. ");
INSERT INTO bki_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","P̃eli naio jibe ka kurukubako, napano naio teliki ka kurukuti dolu nalo tealo nam̃a remebijaio ea kiado tiniavio nalo, naio teliki mia teliki. ");
INSERT INTO bki_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mia bogo na naio miluo binimei toru, burupati toru loa ka sinaniano dolu nalo napano ea kiado tiniavio. Mia jaati nalo tortoru, napano menu nalo aba ajuaio ka vamelu nene bunu ga bo.” ");
INSERT INTO bki_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","A Yesu jo berloglog tomu nalo ka ioluano vou ea jamerijiano na miroano jibe na, jibe napano bare ka nalo ajoglubario. ");
INSERT INTO bki_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","A iliano nalo nonovio napano naio berloglog kalo, mia be jamerijiano ju joomo eaio, ana bogo na aju jibe naio ga bija kiano naiagagoano nalo, ea bogo na naruei naio jo ber bisivisii vatitig jamerijiano nalo na kalo. ");
INSERT INTO bki_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mia Yesu joa kea uako napano naio ba joa ka verloglog tomu nalo, mia bogo na m̃erenio jo batove, naio ber ka kiano naiagagoano nalo, berinavo “Ei, kito ravarkorov rava tivelinio ea ueiyabo neibano yako.” ");
INSERT INTO bki_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mia naiagagoano nalo ajuvan tomu nalo neibano aju, ana abavin ea uako na Yesu ju joomo eaio ruei, ana aburu naio abano. Mia uako dolu nalo bunu ga aban bijalo. ");
INSERT INTO bki_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uako nalo neibano aburo abano-o, mia burum̃ara jegi tai jumolu, mila na burum̃ara tei nalo ajum̃a abievelveluo a abava joomo ea uako bano-o bujo ka tei vare ga rimadudu. ");
INSERT INTO bki_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mia Yesu jo milugu ea selailugu tai ea uako iorou, naio jo monmelio ga. Naruei nalo aba abio bonio, ana nalo aber kanio aberinavo “!Naverloglogiano! ?Jum̃abe na jau maka kosidomial kito ka vaataro ka mia ramadudu naruei?” ");
INSERT INTO bki_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ana Yesu jumolu, mia mil kirisikili ban jegi, naio mil ban burum̃ara tei bija bievelveluo tortoru nalo nei, berinavo “Kamiu kumelumu.” Ana vaarakurano ga jegi m̃aro, vio melumu nonovio. ");
INSERT INTO bki_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ana Yesu ber kalo berinavo “?Ka vaio ana kamiu kumerou jibe na? P̃eli kamiu maka kuvarkar tiniemiu ea kiniou kovio?” ");
INSERT INTO bki_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naruei nalo amerou m̃elei, ana ajum̃a aberver kalo bereio aberinavo “?Toro kenia nei? Naio mil jibe na ga, mia jegi bija tei, abe juo amijogkar naio! Ou!” ");
INSERT INTO bki_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Naruei Yesu nalo amaluvo aboru ea burum̃ara ueiyabo nei tivelinio, naina memedu ka vio na Kerasa, mia nalo tealo ajisia ka Katara p̃eli na Kerkasa. ");
INSERT INTO bki_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Naruei nalo abauro ea vio nene, ana ea vio nene be buluvae nalo na tomu na am̃arm̃aro nalo ajuaio, mia be toro tai napano niununo va telabo ajuaio, napano naio jo joa m̃artanbo nei, jibe ka kiano vio. Naruei bogo na Yesu jabulu den uako nei, mia vaarakurano ga toro neibano moluo ea m̃artanbo nei, jikiti binimei ka rial Yesu. ");
INSERT INTO bki_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Toro nene be deden laka, mia tomu nalo amila von ka aiorikario banbano-o mia amila de ga. ");
INSERT INTO bki_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Va telabo ruei amiorkar jaano bija jum̃ano ka m̃arimieni, mia naio jo burukokorovio ga, mia va telabo amiorkar ea iesi, mia jo mila kokorovio ga, banbano-o napano maka bunu ve toro tai na be kiano moroano bare ka rila toro nei rimei melumu. ");
INSERT INTO bki_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ana ea legiano nonovio a bogiano nonovio naio jom̃a jeliviv ea m̃artanbo nalo a bunu mave ea suku dedade nalo, a naio jom̃a miaga m̃erere, a naio jo jukujuku niabeno ka puruveru nalo. ");
INSERT INTO bki_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ana toro nei naruei napano bogo na naio jo koalabo kia ga vo ka vio na Yesu nalo abauro eaio, mia naio mial Yesu, ana jikiti batove keanio, a batove ka naio, minie tano kamu kanio. ");
INSERT INTO bki_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ana Yesu berenio, berinavo “Niununo va, kotuvan kema na, kotaluvo den naio vonganei!” Mia niununo va nei miaga toru laka ban Yesu naruei, ana berinavo “Mia jau, Yesu, Atua kenerinio napano meul, jau kiamo vaio joa kiniou? Kiniou nebikaso ea Atua siano, ka mia kosian re vironiano rivan kiniou!” ");
INSERT INTO bki_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Mia Yesu bika denio, berinavo “?Na siamo, kei?” Naruei niununo va nei berdop̃eio, berinavo “Kiniou siaku, burutiniobi na mira, bior kumemi miroano laka nei.” ");
INSERT INTO bki_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Mia niununo va nei naio jo bivika kirisikili den Yesu bereio, ka Yesu rijil bulaglo re ea kialo tanobuku nei. ");
INSERT INTO bki_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mia ea burusuku neibano tivelinio, be burum̃ara taara na kiribue nalo miroano, nalo aju amiuo ea borotano, abokar kovio menu juo 2,000, ");
INSERT INTO bki_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ana sim̃aro nalo neibano ajegi, nalo abika kirisikili den Yesu aberinavo “Nuber bo banso, jau koiila kumemi nuvan ea kiribue nalo na, jau kajamo ka kumemi nuva nuvitu joomo ealo.” ");
INSERT INTO bki_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Mia Yesu naio mijamo kalo, berinavo “Bo ga, kamiu kuvano.” Naruei nalo ajaluvo den toro neibano, ana aba aju joomo ea kiribue nalo neibano. Ana sop̃eli ga kiribue nalo neibano ajikiti, abatove ea bavio tai burukorovio, ana nalo ajibirbili abavatove ea ueiyabo na toru ana nalo amunu tei banbano-o abiniu amadudu. ");
INSERT INTO bki_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naruei tomu nalo na abitikar kiribue aburo, aban bereio vonuo, aban aberial vite nei, a aberveriio ea vio dedade nonovio bunu, mila na tomu telabo abinimei ajidom aialio. ");
INSERT INTO bki_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mia bogo na aba amial ka Yesu naio jo, naio bija toro neibano nua niununo va nalo ajuaio, napano vonganei, naio miya vatitig kulum̃arauo ruei, naio jom̃a jotano marga, a maka bunu rive deden leleio. Nalo amialio ka naio binimei bo ruei jibe na, mia amerou. ");
INSERT INTO bki_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mia nalo napano m̃a aju beamu, napano amial vite nonovio nalo, ajukunu ka nalo na abinimei vonga, aber vaio na Yesu mila ka toro nei, a jum̃abe na kiribue nalo neibano aba amadudu ea tei. ");
INSERT INTO bki_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mia nalo amialio bova ga, mia nalo ajum̃a ajikili ka Yesu, ajidom ka mia naio tubilig den kialo vio. ");
INSERT INTO bki_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mia Yesu nalo abatove ea kialo uako bereio, mia bogo napano Yesu jo bavin mave ea uako, toro neibano na, naio binimei bika kirisikili den Yesu, berinavo “Aiou, Tubo, kiniou nojidom ka ver jau kajamo ka kiniou nemei vijaso.” ");
INSERT INTO bki_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mia Yesu naio maka rijamo kanio, mia naio ber ka ga berinavo “Makanio, bior bo laka ka jau kova vonuo bereio, a kava kotukunu rivan kiamo m̃aratavo vija kiamo bilbilu nalo, jau kover kalo ka jum̃abe na Atua tinien miiaso toru laka, ana naio mila bo mia bo laka banso jibe na.” ");
INSERT INTO bki_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Naruei toro nei naio ban bereio, ana naio jo jeliviv ea vio nalo na kiano tanobuku nei, napano ajisia ka Komeli Duelimo, napano tomu nalo na maka ave Ju ajuaio, a naio berial im̃auano novo nalo napano Yesu jom̃a mila ka naio. Mia nalo na amijog kanano tukunuano nei, nalo amiilo toru ka naio. ");
INSERT INTO bki_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mia Yesu nalo ajel ea uako, abarkorov bereio ueiyabo nei aba tivelinio ruei, ana bogo na Yesu biako yetano jo bauro ga, tiniobi toru na tomu nalo abinimei ajelivivi eaio bereio. ");
INSERT INTO bki_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ana toro na toru tai na kialo yimo na volkouano ea vio na, siano Jairas, naio binimei mial Yesu, binimei vaataro kanio, minie keanio. ");
INSERT INTO bki_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ana naio jegi ban Yesu, bika berinavo “Keneriku tira sesa mie mia mie, vonganei p̃eli naio m̃aro ruei. Mia kiniou nebika denso ka jau komei, kodu jum̃amo toaio, ka naio mijikia rijog rivu bereio, ka naio rimeul kia to.” ");
INSERT INTO bki_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ana Yesu naio jumolu, ban naljuo kema neibano abano, ana tomu telabo na tiniobi neibano, nalo bunu ga aban bijalo, napano ajum̃a aba amivinvinkakarlo janea vio jeliviv ea ga Yesu. ");
INSERT INTO bki_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A nalo tai napano aju aban bija Yesu jibena, naio be tira tai, napano mieiano na jada mila naio bogoti nonovio ga, bokar yuka duelimo ba juo 12 ruei. ");
INSERT INTO bki_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A tira neibano, naio bulu nakulekuleano nalo banbano-o kiano veru biniu, mia nalo amim̃auka naio bano-o, mia mijog bova ga, kiano mieiano nei jo ba bova lie dam̃ariga. ");
INSERT INTO bki_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Naio jom̃a mijog vatelabo ruei napano tomu nalo ajum̃a ajukunu ka Yesu ruei, mia be kiano jidomiano tai, berinavo “A ver kiniou notokol ga m̃ano kulum̃arauo, mia kiaku mieiano ribisi vatitigio.” Mia naio binimei juluku ga iviso ea tomu nalo neibano, ana jo binimei binimei iorou vaataro ka Yesu taakano ana naio jian jum̃ano jibe na, jokol Yesu m̃ano juluvati kulukoti ga. ");
INSERT INTO bki_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mia naio jokol Yesu m̃ano kulum̃arauo jibe na, ana monloglog ka bogo nene ga, jada nei mijelkorovio, mia naio mijoglubar ea niabeno ka kiano mieiano jaluvo denio ruei. ");
INSERT INTO bki_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mia Yesu bunu ga mijogii ea naio, naio mijogii ka kiano moroano jaluvo den naio, ana sop̃eli ga barp̃ilig naio iviso ka tomu nalo, ana naio bika berinavo “?Mia kei naio jokol vonga kiaku kulum̃arauo?” ");
INSERT INTO bki_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mia naiagagoano nalo aber ka naio aberinavo “?Jau kobika koberinavo kei naio jokolso vonga na, ana jum̃abe, jau maka keial ka tomu nalo na miroano nei na aju ga amivinkakarlo jeliviv easo?” ");
INSERT INTO bki_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ana Yesu naio jo jiraravo jeliviv kia ga vo mila von ka rial kei jokol naio. ");
INSERT INTO bki_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mia tira neibano, naio mijikia ruei ka naina, ana naio merou laka, ana jo memebiju, mia naio binimei ea Yesu, mijorua Yesu jaano, ana naio berial vite nonovio. ");
INSERT INTO bki_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Mia Yesu berkanio, berinavo “Nena, kiamo viekouoiano ea kiniou milaso komijog bo bereio ruei, kiamo mieiano na maka bunu. Atua kiano tum̃aro to vijaso, jau kava vonuo bereio ga.” ");
INSERT INTO bki_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mia bogo na Yesu jo mil kiaga vo ban tira nei, mia iliano tai binimei den Jairas kunuano, aber ka toro na toru nei, aberenio “Kenerimo tira sesa m̃aro ruei. Bo ka jau kovuru re bunu naverloglogiano na toru na rimei, kala bulag re naio.” ");
INSERT INTO bki_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mia Yesu bunu ga mijogio, ana naio ber ka Jairas, berinavo “Kiamo iviso rivova re, jau komonea kar ga Atua sikili.” ");
INSERT INTO bki_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Naruei Yesu berbure tom nonovio ka mia atakisor re bunu naio avan ea vio neibano, ana naio buru ga tom tolu nei, nina Pitere, bija Yemesi, bija kuruano Jone, abano. ");
INSERT INTO bki_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mia bogo na abinimei vaataro ka toro na toru nei kunuano, amial ka tomu nalo ajum̃a tiniel miia tira sesa neibano ruei, aju ajegi, a amila burum̃ara uetubaiano. ");
INSERT INTO bki_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mia Yesu ba joomo, ber ka tomu nalo nene berinavo “?Ka vaio ana kamiu kumitum̃a kumila uetubaiano toru, a kumitum̃a kumiteg jibe na? Tira sesa na naio maka rim̃aro, naio jo monmelio ga.” ");
INSERT INTO bki_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mia nalo abital niege naio ga. Mia Yesu miila bulag tomu nalo abava tavio, ana naio buru tira sesa nei karam̃ano bija kenieno ga, bija kiano naiagagoano nalo tolu neibano, nalo aba joomo ea vio na tira sesa nei mokotenano mon eaio. ");
INSERT INTO bki_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ana Yesu ba bokar jum̃ano, mia naio mil banio jelea kialo iliano, berinavo “Talita kum” napano naio berenio “Keneriku tira sesa, jau kotumolu von beamu vo.” ");
INSERT INTO bki_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mia ea bogo nene ga, tira sesa nei, napano kiano yuka duelimo ba juo 12, jumolu, ana jo mieliel. Mia nalo na amialio vite nei, amiilo bano-o, jidomiano bulati ga. ");
INSERT INTO bki_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mia Yesu ber kalo berenio mia adu sinaniano ve telisu vanio, a naio ber bunu banlo ber mia tomu dolu nalo monokanio ajog re tenei. ");
INSERT INTO bki_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mia Yesu jaluvo ea vio nei, ana binimei bereio ea kiano vio, naio naliko kiano naiagagoano nalo. ");
INSERT INTO bki_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mia ea Legiano Lu, naio bija tomu nalo na kiano vio aba joomo ea kialo yimo na volkouano, ana naio jo berlogloglo. Mia bogo napano amijogio, nalo amiilo laka ka kiano iliano nalo. Ana nalo aberenio “Tomnei! ?Kema na naio bar tenalo na be? ?Naio bokar masouano na jum̃abe? ?A naio jom̃a mila vremesiano nalo na jum̃abe? ");
INSERT INTO bki_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kito romijikia kema na naruei. Naio be toro na mim̃auka yimo nalo ga na, tira na Mere kenerinio na. Mia nalo nei Yemesi, a Joses, a Jutas, a Saimon, nalo na abe kuruano nalo. A kuviviniene nalo, nalo nei napano aju kitoliko ga.” Naruei nalo tiniel jer naio, maka asidom naio. ");
INSERT INTO bki_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mia Yesu ber kalo, berinavo “Toro napano be naverialiano, tomu dolu nalo amijikia atovon naio, mia tomu na kanano vio, naliko kanano m̃aratavo nalo, nalo na ga maka ajikia atovon naio.” ");
INSERT INTO bki_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Naruei ea kiano vio memedu nei, Yesu maka rijikia rila vremesiano, mia midu jum̃ano jua tom juo p̃eli tolu ga na amie, milarurlo bereio. ");
INSERT INTO bki_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mia Yesu miilo laka ka tomu nalo na kiano vio na, bior napano maka asidom amonea naio leleio. Ana naio juvan kiano vio na, ana ba jeliviv ea m̃arkomeli dolu nalo napano naio jo berloglog tomu nalo. ");
INSERT INTO bki_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mia Yesu bio kiano duelimo ba juo 12 nei, ana mil batitig banlo, naio jian moroano banlo ka nalo amijikia atuvulu niununo va nalo, mia iorou naio miila bulaglo abeve juo abano. ");
INSERT INTO bki_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ilivatitigiano nalo na naio beriio beamu ruei nua ka avano, ajibe nei, napano naio berinavo “Ea tivelinio na kenemiu m̃arabo, mia kamiu kuvar re titai vija kamiu, mia kenemiu nasitoga ga na kubanio, kumijikia kuvario. Mia kamiu kuvar re semiu sinaniano tai kuvano, p̃elina kenemiu basaro, p̃elina kenemiu veru. ");
INSERT INTO bki_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kamiu kumijikia kuvar kenemiu kulubue kuviya ea jaamiu, a mia maka kuvijikia kuvar kenemiu kulum̃arauo dolu nalo bereio, mia kamiu kuvar ga kenemiu kulum̃arauo ve takurano ga napano kuviya bogo na kuviel kuvano.” ");
INSERT INTO bki_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ana Yesu ber bunu, berinavo “Bogo napano ver avuru kamiu kuva joomo ea kunualo nalo tai, mia kamiu monoka tiniemiu saaro ka kuvitu kamlikolo, m̃aratavo nalo na vonuo nene, rivano-o rivokar bogo napano mia kuvitaluvo den m̃arkomeli na bereio. ");
INSERT INTO bki_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ana ver ea m̃arkomeli tai, tomu tai maka asidom avuru kamiu kuvan ea kunualo nalo, p̃elina maka asidom aiagago ka kamiu, mia kuvituvan ga kialo vio na to, mia bogo na kamiu kuvitaluvo den vio na, kamiu monoka kuvijubakon yevi na vio na den jaamiu nalo, jibe ka kijokijo tai p̃elina kenemiu iliano tai na kirisikili banlo, ka mia nalo avokar vironiano tai na memedu ga ka kialo bajago na bova nene.” ");
INSERT INTO bki_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mia atevi nalo aban abeve juo jibe na naruei, mia aba amioliolu ban tomu nalo ka monoka aviliglo, ");
INSERT INTO bki_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","a amijil bulag sim̃aro telabo den tomu nalo, ana nalo amionion bonotanunu na m̃arolivi teliki ea tomu na amie telabo parilo, jibe kijokijo tai na Atua kiano ilivuiano, ana amijog bo bereio. ");
INSERT INTO bki_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naruei ea bogo nei, Parinio tubo Erot naio bunu mijog kija vaio na Yesu jom̃a milaio, bior ka Yesu siano, ajum̃a aberverii janea vio nonovio, mia tomu nonovio amijikia batitigio ruei. Ana tomu tealo ajum̃a aberii Yesu, aberinavo “Nina be Jone Baruei bere na, napano vonganei meul bereio ea m̃ariano. Tenei naruei napano mila naio be kiano moroano ka rila kijokijo nalo na.” ");
INSERT INTO bki_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ana nalo dolu nalo aberii Yesu, aberinavo “Nina tormoruo Elaija re nua na,” ana tealo aberenio “Nina be naverialiano tai na, jibe kiado naverialiano moruo nalo tai re nuanua laka.” ");
INSERT INTO bki_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mia bogo na Parinio tubo Erot mijog vaio na Yesu jom̃a milaio, berinavo “Toro na p̃eli Jone Baruei bere ga na! Kiniou nejelar pariparinio ruei, mia vonganei naio meul bereio ea m̃ariano bo?” ");
INSERT INTO bki_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Parinio tubo Erot mil jibe na bior naio naruei muetam̃aria Jone Baruei m̃aro ruei, ana jo merou m̃elea kanio. Mia tukunuano na m̃ariano na Jone Baruei kiano naio jibe nei. Parinio tubo Erot kuruano nei, be Vilip, napano naljuo nei, karam̃alo takurano mia keniele naljuo. Vilip naio joro ka tira tai siano Erotias, mia iorou kanio ana Parinio tubo Erot naio ba burular tira nene. Tenena Jone jom̃a mil ban Parinio tubo Erot kanio, berinavo “Tena jau komila na maka rimemedu, ka na jau koburu tira na, bior naio be kuruamo koano.” Mia Erotias maka leleio saaro ka Jone kanano iliano, naio tinienjer Jone, mila na Parinio tubo Erot miila kiano tomu nalo tealo abano abokar Jone amiorkario aburu ban ea yimo na lakoiano. ");
INSERT INTO bki_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mia Erotias jo jidom ka auebin Jone rim̃aro, mia naio maka rijikia rilaio, ");
INSERT INTO bki_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bior Erot merou ka ruebinio. Naio merou jibe na bior naio mijikia ka Jone be toro na memedu tai, a be toro lu bunu, ana naio bokar vatitigio ga jo. Bogo telabo naio bio Jone binimei ka ave juo atukunu, mia naio jidom Jone kanano iliano nalo, mia bogo nonovio iliano nalo nei aju ajulu naio bunu, a mila na naio kiano jidomiano beve juo naruei. ");
INSERT INTO bki_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mia maka vesiou, Erotias mial ka be kiano bogo. Nina, ea bogo napano nalo amim̃auka jokoluolu ka asidomkar bogo na Erot moluo eaio. Ana Erot naio mila jokoluolu tai ka kiano tomu nalo na tortoru bija kiano navurim̃araboiano na kiano im̃auano nalo bija tomu nalo na tortoru na tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Ea jokoluolu nei naruei, Erotias kenerinio tira naio binimei bolu ea ga miralo, ana Erot nalo tinielo jaaro laka ka kiano voluano, naruei Erot naio mila verikariano tai kirisikili ban naio berinavo “Vaio na jau kovika den kiniou, mijikia rivano-o rivokar togio na kiaku vite nalo nonovio, ana mia kiniou nemijikia notuvan ga rivanso.” ");
INSERT INTO bki_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mia tira neibano naio ba tavio, ana bika den kenieno, Erotias, berinavo “?Nena, mia kiniou nevika vaio denio?” Naruei kenieno ber banio, berinavo “Mia jau kover ka ga koverinavo naio monokanio rudu Jone Baruei parinio rivan kito juo.” ");
INSERT INTO bki_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Naruei kenerinio tira nei naio mila sop̃eli bere ga ba joomo, ba bika sop̃eli ga den Erot, berinavo “Kiniou nojidom ka jau kodu Jone Baruei parinio ea baju tai ana kodu rimei ea vio nei vonganei.” ");
INSERT INTO bki_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Naruei iliano nei mila tubo Erot mijog kirivova, mia naio maka bunu rijikia rila korov kiano verikariano na kirisikili nei napano naio mila ea kiano bilbilu nalo miralo ruei, ");
INSERT INTO bki_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","mia ea bogo nene ga naio miila kiano toro tai na mira, ba ber ka mia adu Jone parinio rime. Naruei nalo aban ea yimo na lakoiano ana aje korov Jone burujono, ");
INSERT INTO bki_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ana amidu Jone parinio neibano ea baju tai, amidu abinimei ban tira neibano, ana tira neibano naio midu ba ban kenieno. ");
INSERT INTO bki_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mia iorou, bogo na amijog vite nei, Jone kiano naiagagoano nalo abinimei amidu mokotenano, aba amidu batove jua m̃artanbo. Naruei tukunu na berii Jone Baruei, naio maaro ea vio na, mia bogo na Erot mijog veriiano na Yesu, mila naio merou laka, ber p̃eli Jone Baruei nene napano naio muebinio, meul bereio. ");
INSERT INTO bki_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Naruei atevi nalo napano Yesu miila bulaglo abano ka aioliolu, mia abinimei bereio naruei. Mia nalo aju aberialio ban Yesu vaio nalo napano amila ka tomu nalo, bija jum̃abe ajum̃a aberlogloglo. ");
INSERT INTO bki_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mia tomu miroano napano aju abinimei ealo, karina nalo abano, ana tealo bere abinimei, karina aban bereio, mia jibe na ga bano, mia Yesu nalo maka ajikia ajilimebi leleio, maka leleio bogo vare ka ajikia adu salo sinaniano ve teliki. Naruei Yesu ber kalo berinavo “Bo ga, mia kito ravano. Kito rala von ka rotu p̃ilig den vio nei ve telisu vo beamu, kito rava resiravo vio tai na be tum̃aro vatitigio, napano kamiu kumijikia kuvijilimebi vatitig eaio.” ");
INSERT INTO bki_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jibe na aba amidu uako tai, ana ajel eaio ka ava asirarag ka vio tai ea ueiyabo tivelinio, napano maka tomu nalo atua vio nene. ");
INSERT INTO bki_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mia tomu miroano na abitilubar ka Yesu nalo ajaluvo jibe na, ana nalo bunu ga ajaluvo den kialo m̃arkomeli nalo, ajikiti, ajel uro, ana aba abokar beamu vio napano amial ka uako nei naio jom̃a ban eaio, beamu ka Yesu nalo. ");
INSERT INTO bki_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mia Yesu bauro, a bogo na naio mial ka tomu telabo aju ruei, mia naio tinien miialo laka, bior naio mialo jibe ka nunu nalo napano amilaluvu m̃arabo, napano maka toro tai ka rivitikarlo, ana naio jom̃a berlogloglo ka iliano novo nalo telabo. ");
INSERT INTO bki_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mia bogo na m̃erenio batove, kiano atevi nalo abinimei eaio, aberinavo “Ai Tubo! Vio nei naio bova ga, a vaataro ka vio ribobogio naruei bunu. ");
INSERT INTO bki_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bo kanio jau keiila tiniobi nalo na avanvan bereio ea kialo vonuo nalo p̃elina avanvan ea m̃arkomeli nalo na aju dedade ea vio nalo nei, ka avulu salo sinaniano tai.” ");
INSERT INTO bki_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mia Yesu ber kalo, berinavo “E, makanio, bo kanio kamiu ga kuvar sinaniano tai rivanlo.” Mia aberiam̃a Yesu maka river vatitigio, naruei nalo aberinavo “E! Bo ga na p̃eli jau kojidom ka kumemi nuvar kiado puruveru na toru na, kumemi nuvario nuvulu ka joko rivare ka tomu menu telabo nei ka asenio?” ");
INSERT INTO bki_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Naruei Yesu ber kalo berinavo “Mia kamiu kuva kuvial von ver joko vio na ju bija kamiu vonganei.” Mia nalo aba amialio, ana abinimei bereio, aberinavo “Kumemi nubar joko jimo na tereteliki ga ju, bija niado momaio juo.” ");
INSERT INTO bki_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mia Yesu ber ka tomu nalo, berinavo “Kamiu kuvitutano ea soro na beamu,” ");
INSERT INTO bki_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ana ajutano ea taara nalo, napano tealo abokar duelimo va limo 50, a tealo abokar toromomou takurano 100. ");
INSERT INTO bki_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ana naio bar joko jimo nei bija momaio juo nei, jirarago bavin ea tiniabene, ber siva ban Atua biorio, ana burekokorov joko nalo nei, jian ban kiano atevi nalo, ka avario asian van tiniobi nalo nei, mia naio janka bunu ga niado tereteliki juo neibano jibe na. ");
INSERT INTO bki_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mia nalo ajinan bano-o, mia mabolo jouo vatitigio, ");
INSERT INTO bki_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","mia ioroti sinaniano bija niado nalo napano ajen ana nina beva aju, nalo amisonio ban ea basaro nalo bokario duelimo ba juo 12. ");
INSERT INTO bki_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mia tomu nalo napano ajinan, napano sum̃ano nalo ga, nalo abokar jibe kovio menu jimo 5,000. ");
INSERT INTO bki_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Karina Yesu berii ka kiano atevi nalo, berenio “Kiniou nojidom ka kamiu kuvidu kiado uako, kuvan beamu tivelinio ea ueiyabo nei, ea m̃arkomeli na Betsaeta, mia kiniou noto nei beamu vo ka mia naiila tiniobi nalo nei avanvan bereio.” ");
INSERT INTO bki_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ana bogo na miila bulag tiniobi nalo nei abano beve terakurano bisi, naio bavin ea suku ka rivolkouo. ");
INSERT INTO bki_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ana bogo na vio binimei viobobogio ruei, uako jo koalabo tavio ea tinia tei ruei, mia Yesu jo naio takurano ga uro. ");
INSERT INTO bki_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ana Yesu mial ka nalo ajum̃a amila bijon ka m̃a abeluo ka uako neibano, bior aju abiniua jegi ga, mila nalo aburo melmelumu laka ga. Mia vaataro ka viorijeni mermeravo, naio binimei ealo, jom̃a miel mave ea niunuku tei. Nina naio jidom rivan vaataro ga kalo, ka riva rivoru tivelinio tukamu kalo, ");
INSERT INTO bki_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mia bogo na nalo aju abitii naio jo miel mave ea niunuku tei binimei vaataro kalo jibena, abio souo, aberinavo “E! ?Vaio na binimei jibe na? ?P̃eli sim̃aro tai, p̃elina venia na jibe na?” ");
INSERT INTO bki_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nalo abiniu ajum̃a abitikar naio jibena, mia amerou laka. Mia kirisop̃eli Yesu mil banlo “E, kamiu kumerou re bunu, kiniou ga na.” ");
INSERT INTO bki_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Mia Yesu bavin ea uako bijalo, ana ea bogo na memedu ga, jegi neibano m̃aro, ana nalo na ajua uako amiilo toru laka garuei. ");
INSERT INTO bki_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nalo amiilo jibe na bior kialo jidomiano nalo kirisikili laka kia ga vo, maka atu avitilubar vite nalo napano Yesu mijikia rila ea kiano moroano, jibeka vaio napano naio mim̃auka bija joko jimo tereteliki neibano. ");
INSERT INTO bki_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ana Yesu nalo abarkorov ueiyabo neibano aban ea kialo uako tivelinio, naruei aba aboru ea vio tai, siano Kenasarete. Mia bogo na abuku veru ba uro, ");
INSERT INTO bki_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mia abavatove ea uako, ana sop̃eli ga tomu nalo na vio na abitilubar Yesu. ");
INSERT INTO bki_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Naruei nalo ajikiti ajeliviv ea kialo m̃arkomeli nalo, aju abarvar kialo namieiano nalo ea m̃alo jogu nalo, abinimei ea vio nalo vabe napano amijog ka Yesu jom̃a ban eaio. ");
INSERT INTO bki_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ana ea vio nonovio na Yesu naio jom̃a ban eaio, ea m̃aratavo nalo, ea m̃arkomeli nalo, p̃elina ea m̃arabo nalo, nalo ajum̃a abar kialo namieiano nalo, aju abarlo ju vatitig ea vio medave, ana aju abika denio ka rijamo ka namieiano nalo nei atokol ga juluvati na kiano kulum̃arauo. Mia nalo na mia atokolio tibena, kialo mieiano nalo ribisi, a nalo amei rivu bereio. ");
INSERT INTO bki_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mia ea bogo nei, Varisis tealo abinimei vio takurano ea Yesu, bija bunu naverloglogiano na tuboiano, napano nalo ajaluvo ea vio Yerusalemo abinimei. ");
INSERT INTO bki_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mia nalo aju amial ka bogo napano Yesu kiano atevi nalo ajum̃a ajinan, amila napano ea Varisis nalo kialo vitiiano, jum̃alo nalo abova. Nina bior napano maka atakii vatitig kiri m̃arabo sesa nalo telabo ka asekon jum̃alo, napano Varisis nalo aber tomu nalo monoka alaio, karina amijikia asinan. ");
INSERT INTO bki_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nina bior ea bogo na, Varisis nalo bija kulo Ju dolu nalo ajikili laka ka ala tibena naruei, ka nalo monoka atakii vatitig rivu kialo bajago moruo na kialo lotuano re beamu. ");
INSERT INTO bki_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ajum̃a amila jibena ka ver nalo amiel aban ea komeli p̃eli na vio vabe, mia bogo na abinimei vonuo bereio, mia monoka nalo atakii tuboiano na ka asekonlo ameravo rivu p̃eli na ave lu vatitigio rivu bereio. Iorou ka nina, amijikia atikar ka asinan naruei, bior ver nalo ala re, maka ajikia atokol sinaniano leleio. Mia be tuboiano sesa telabo bereio jibe na napano monoka atakiio, napano tealo, aber monoka asekon baja tibe na tibe na, a tealo, aber monoka asekon p̃ili marauo tibe na tibe na, a tealo, aber monoka asekon baju na amim̃aukanio ea burujievi na be bras tibe na tibe na, rivan tibe na. ");
INSERT INTO bki_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Vite na naruei mila Varisis nalo abika den Yesu, aberinavo “?Ka vaio ana kanamo atevi nalo maka atu atakii bajago moruo nalo na kiado lotuano nanua, napano kiado navurim̃araboiano nalo na ajum̃a aberloglogio ka kito. Kanamo nalo na, ajum̃a ajinan bija niamiamo nalo na jum̃alo, bior napano maka asekon batitig jum̃alo nalo.” ");
INSERT INTO bki_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ana Yesu berdop̃e banlo, berinavo “Riano ga na, naverialiano Aisea re nua naio berii memedu ga kamiu tomu nalo na sibiano na, napano naio berial iliano nei napano Atua naio berenio, napano ber ‘Tomu nalo na abamenea kiniou ka kialo iliano nalo ga, mia kialo jidomiano nalo aju koalabo den kiniou kia ga vo. ");
INSERT INTO bki_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mia nalo aju amilotu ka kiniou kurano ga, bior bogo napano aberloglog tomu nalo, nalo aju aber nina Atua kanano iliano na, mia makanio, iliano nei be tomu nalo kialo ga.’ ” ");
INSERT INTO bki_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ana Yesu ber kalo berinavo “Kamiu kumitum̃a kumituvan Atua kiano tuboiano, ana kumitum̃a kubokar bajago moruo na kulorinio ga kiano kirisikili laka. ");
INSERT INTO bki_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Maka leleio rimemedu ka mia kamiu kuvitum̃a kuvila tibe na, bior napano kamiu kumitum̃a kumisikili ka kuvitakii bajago moruo nalo na toro ga kanano, mia vonganei kamiu kumila banbano-o mia bajago nei naio jo midu jeleig vio p̃elina naio jo bukular Atua kanano tuboiano. ");
INSERT INTO bki_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosis kiano tuboiano naio berenio ruei, berinavo ‘Jau komonmonea karam̃amo naio koniomo,’ a naio ber bunu, berinavo ‘Toro na mil bova ka karam̃ano naio kenieno, mia kamiu kuvuebinio rim̃aro.’ ");
INSERT INTO bki_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Tuboiano nei berenio ka kito monoka rovitikar vatitig kiado tormoruo juo nei, mia kamiu kumitu kumila dolu nei. Verenio toro tai verko kario kiano vite tealo ka river abe Atua kiano, ana ver tormoruo juo jum̃alo bulati, amei avikanio, mia kamiu kuver van naio ka monoka rila vaio van naljuo? ");
INSERT INTO bki_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mia kamiu kuvitutua naio, kuverinavo ‘Maka lele, maka kojikia kosian van naljuo nei, bior kanado bajago moruo ber vaio na kuberkoio ban Atua, monoka kosian ga van kiano tomu lu nalo, jau maka kojikia kotuvan van toro dolu.’ ");
INSERT INTO bki_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kamiu kuberenio jibena, mia vaio na jibena? Kamiu kumitu jikili ea bajago moruo nalo, kamiu kumitu kumituvarvan batove, mia jo mila Atua kiano tuboiano binimei be vite kurano tai. Mia maka nina ga, mia kamiu kumitu kumila vite telabo na jibena.” ");
INSERT INTO bki_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Naruei Yesu bio tomu nalo ka amei vio takurano bereio ea naio, ana naio mil banlo, berinavo “Kamiu nonovio kuviagago vatitig ka kiniou, kamiu monokanio kuvijoglubar kanaku iliano nei. ");
INSERT INTO bki_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Maka leleio ve vite tai nam̃a jo tavio ea toro, mia river riva joomo ea naio mijikia rila naio riagiago ea Atua mirano. Mia vite nalo nam̃a aju joomo ea naio, napano m̃a amoluo ea naio, vite nalo na naruei amila naio miagiago ea Atua mirano.” ");
INSERT INTO bki_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ana Yesu jaluvo den tomu nalo nei, ana ba vonuo bereio, ana karina, kiano naiagagoano nalo abinimei, abika denio jamerijiano napano naio jom̃a berii kalo. ");
INSERT INTO bki_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ana Yesu berinavo “?Jum̃abe, p̃eli kamiu bunu parimiu bono kia ga vo javukia nalo na? Bior vaio napano kamiu maka kuvitilubar vite na? Vite vaio na jo tavio, jibe sinaniano nalo, verinavo riva joomo ea toro, nalo maka ajikia ala toro rivova ea Atua mirano. ");
INSERT INTO bki_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nina bior napano vite nalo nei maka ava avokar kiano jidomiano, mia abatove ea mabono ga, karina abarlaka amoluo den niabene bereio.” Mia Yesu ber jibe na naruei, ana karina, tomu nalo abitilubario von naruei ea kiano iliano nei, Yesu mila meravo ka maka ve sinaniano tai napano toro monoka rivel kanio ka rila naio rimeravo rivu ea Atua mirano, mia sinaniano nonovio ga nalo abo ga ka asenio. ");
INSERT INTO bki_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A Yesu berenio bunu “Mia vite nalo napano ajua toro ruei, ana aju amalmaluvo ea kiano meuliano, vite nalo na naruei amijikia ala toro riagiago. ");
INSERT INTO bki_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nina bior joomo ea toro, be bajago va nalo napano aju amoluo ea naio, jibe jidomiano va, siakiano, vinauano, amue tam̃aro ea toro, siakaiano, ");
INSERT INTO bki_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tinieiiano, bajago na bova, sibiano, lakoroviano na tuboiano, jokuano, tii ilisibiano nalo, ilivarvariano, bija vovuiano. ");
INSERT INTO bki_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bajago va nalo nei naruei, nalo amoluo den toro kiano iviso, mia nalo nei naruei vite nalo nam̃a amijikia ala toro riagiago kamu ea Atua mirano.” ");
INSERT INTO bki_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ana Yesu jaluvo den vio na, naio batove ea tanobuku na komeli nei Taea. Mia naio ban ea yimo tai, naio jidom rila ka mia tomu nalo ajikia re ka naio joa vio na, mia naio maka rijikia toluku tibena. ");
INSERT INTO bki_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Naruei tira tai joa vio na napano maka ve Ju, bior napano kiano torogio nalo abe Kris ga, mia abinimei ajua tanobuku na Vonisia vaataro ka Siria. Tira nene, kenerinio kiri tira sesa, niununo va tai joaio, mia bogo na tira neibano mijog ka Yesu joa vio na, naio binimei minie tano ka Yesu jaano, jegi banio, ka naio rijil lar sim̃aro nene den kenerinio niatira sesa nei. ");
INSERT INTO bki_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mia Yesu berdop̃e naio, berinavo “Mia memedu ka kiritete nalo monoka asinan beamu! Maka rimemedu ka navar bulag kiritete nalo salo sinaniano nalo denlo, novuku rivan kuli nalo.” Naio berenio jibe na bior ka bogo na, kulo Ju nalo, napano aberiam̃a nalo ga abe Atua kenerinio nalo, nalo ajum̃a abio niegeniege tomu nalo napano maka ave kulo Ju, aberinavo “Kamiu kuli nalo ga.” ");
INSERT INTO bki_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mia tira neibano berdop̃e naio, berinavo “Jau kober be riano Tubo, mia kuli nalo aju aban vaataro ka vio na kiritete nalo salo sinaniano, ka mia amijikia asen yororoti sinaniano nalo nam̃a ajibirbil yetano ea borotano.” ");
INSERT INTO bki_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Naruei Yesu berkanio, berinavo “Jau kojian verdop̃eiano novo tai ka kiaku iliano nei. Naruei bior kanamo iliano novo na, kiniou nebitilubar ka jau tiniemo barkar vatitig kiniou, ana bo, neber kaso ka jau komijikia kava vonuo ga, sim̃aro nene jaluvo den kenerimo niatira nene ruei.” ");
INSERT INTO bki_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Naruei tira nei naio ban bere vonuo, ana binimei mial kiritete neibano kenerinio naio jo melumu ga, naio jo mon vatitig ea m̃ano jogu. ");
INSERT INTO bki_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mo, karina Yesu juvan tanobuku nei Taea, ana naio ba jel ea m̃arkomeli dolu na Saiton, ana binimei bereio ea ueiyabo na Kalele, nina tivelinio na tanobuku napano abio ka Komeli Duelimo. ");
INSERT INTO bki_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ana nalo na vio na aburu toro tai binimei banio, ka naio rudu jum̃ano toaio, bior toro nene naio tiliniene bono, naio mil dede laka ga. ");
INSERT INTO bki_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Naruei Yesu buru toro nei jaluvo den tiniobi nalo nei napano aju, naruei naljuo aba laka kija. Naruei Yesu miyuku m̃arjukjum̃ano ban ea bulukuti buru tiliniene, karina naio midu titinio, mia ea kema neibano buruminano. ");
INSERT INTO bki_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Karina Yesu jirarago mave ea tiniabene, naio burukar kiano jegi toru, ana ber ka kema neibano jel kialo, berinavo “Evata,” napano iliano na berenio “Jau kovetavo.” ");
INSERT INTO bki_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Naruei vaarakurano ga, kema neibano, buru tiliniene betavo, bija buruminano mim̃au vatitigio, mila na kema neibano naio mijog vite bo a mil vatitig meravo ga. ");
INSERT INTO bki_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Naruei Yesu jadu kalo, ka mia avan re atukunu ka tenei tanea vio van tomu dolu nalo, mia bogo na naio jo berii jibe na ka tomu nalo, mia nalo aba aberverii lie vo ea vio reraio ga. ");
INSERT INTO bki_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nalo aberii m̃elea jibe na, bior amiilo mia amiilo ka vite nalo nonovio napano m̃a nalo amialio ka Yesu mijikia mim̃aukanio. Nalo ajum̃a aberverii aberinavo “Yesu nei mila nalo nam̃a tilinielo bono nalo amijog vite, a naio mim̃auka tomu na maka ajikia ail, nalo amil. Kaleliki, kema na mim̃auka vite nalo nonovio bo mia bo laka, mm.” ");
INSERT INTO bki_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ana bogo tai, tiniobi toru tai na tomu telabo nalo abinimei ea Yesu bereio. Mia nalo aju bija naio bano-o, ana nalo jijerlo, ana nalo maka bunu salo sinaniano. Ana Yesu bio kiano naiagagoano nalo abinimei ea naio, ana naio ber kalo, berinavo ");
INSERT INTO bki_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kiniou tinieku jii tiniobi nalo nei toru, bior aju bija kito bogoti tolu ruei, mia salo sinaniano biniu ruei. ");
INSERT INTO bki_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","A ver kiniou neiila bulaglo avan ea kunualo napano maka ve salo sinaniano jibenei, p̃eli tealo siserlo ve toru ea m̃arabo togio ana miralo ribobogio, bior nalo tealo, kialo komeli aju koalabo laka.” ");
INSERT INTO bki_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ana Yesu kiano atevi nalo aber ka naio, aberinavo “Ana mia kito ravagan tomu nalo nei ea vio iauo nei tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ana Yesu bika denlo, berinavo “Ana kamiu be semiu joko vio?” Ana nalo aber “Aluo ga.” ");
INSERT INTO bki_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Naruei Yesu mil ban tiniobi toru nei, berinavo “Kamiu kuvitutano ea vio nei beamu vo.” Ana naio bar joko aluo nei, naio ber siva ban Atua kanio, karina naio burekokorovio, ana bario janea kiano naiagagoano nalo ka avar van tomu nalo, ana nalo aba ajankanio ealo. ");
INSERT INTO bki_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A nalo abar niado momaio juo na tertelisu ea bogo nene, ana Yesu ber siva kalo bunu, ana berinavo “Kuva kuvitan kalo bunu van tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ana nalo ajenio banbano-o, napano mabolo jouo vatitig, ana amison basaro aluo bereio abujo magmago vatitig bija ioroti sinaniano nalo na ju. ");
INSERT INTO bki_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ana nalo na ajinan ea bogo nei, nalo abokar p̃eli menu veri 4,000. Naruei Yesu miila bulag tiniobi nei aban bereio ea kialo komeli, ");
INSERT INTO bki_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ana naio ban ea kialo uako na, bija kiano atevi nalo, a nalo ajuvan vio na, aba abokar tanobuku na vio Dalmanuta. ");
INSERT INTO bki_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ana ea bogo tai na, Varisis nalo tai abinimei ajidom avilvil ea Yesu, a ajidom ala vonvon naio, ana nalo aberinavo “Kumemi numisidom jau koverloglog kijokijo tai na toru ka nuvialio, napano jau kalaio vija sikiliano na tiniabene.” ");
INSERT INTO bki_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Mia Yesu naio buru kiano jegi, jibe napano naio tinien maro kalo ruei, ana berdop̃e banlo, berinavo “Ka vaio kamiu na tena banei, kumitu kumisidom kuvial kijokijo tai tibena? Kiniou neber be riano ban kamiu, maka leleio, mia kenemiu bajulukuti na banei mia maka ajikia aial kijokijo tai.” ");
INSERT INTO bki_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ana Yesu jaluvo denlo juvanlo ajubo, ana naio ban ea uako bereio, naio barkorov bereio ueiyabo ba tivelinio. ");
INSERT INTO bki_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ana bogo na nalo ajaluvo aba abokar tivelinio na ueiyabo na toru nei, nalo ajidomii von bereio napano tinielo bobogia ka avar salo joko tai rimei, mia salo joko takurano ga jo bijalo ea uako. ");
INSERT INTO bki_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ana Yesu ber iliano tai banlo, berinavo “Kamiu monoka kuvitikar vatitig kamiu, ka Varisis nalo bija Erot kialo is.” Yesu berenio jibe na ber ka bajago va nalo na kialo navurim̃araboiano nalo, mia atevi nalo maka asidomiilubario. ");
INSERT INTO bki_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nalo amijog ga, ana aju aberii ealo, aberinavo “P̃eli naio mil jibe nei bior napano kito maka ravar joko tai rimei.” ");
INSERT INTO bki_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ana Yesu mijikia kialo jidomiano na, ana berinavo “Kamiu kumitu kuberii napano m̃aka ve sado joko ka vaio? Jum̃abe, kamiu maka kuvijoglubar p̃eli maka kuvitilubar vite nalo navo? P̃eli tiniemiu nalo jikili laka ga! ");
INSERT INTO bki_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kamiu, miremiu nalo ju, mia kamiu maka kuvitu kuvitilubar vite, a burutiliniemiu nalo ju, mia kamiu maka kuvijoglubar vite. P̃eli kamiu maka bunu kuvitu kuvisidomii bereio vite nalo napano kiniou nomilaio ban tomu nalo? ");
INSERT INTO bki_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bogo na kiniou nemila burevure joko jimo nua na ruei ea tomu nalo menu jimo 5,000 na, nalo ajenio banbano-o mia kamiu kumison iororoti sinaniano nalo aban ea basaro vio?” Nalo aberdop̃e ban naio, aberinavo “Kumemi numison duelimo ba juo.” ");
INSERT INTO bki_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ana naio bika bereio, berinavo “Ana bogo na nalo menu veri 4,000 na ajen ga joko aluo na, iorou kamiu kumison basaro vio bereio?” Ana nalo aberdop̃e, aberinavo “Kumemi numison aluo.” ");
INSERT INTO bki_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ana naio ber kalo, berinavo “Boga, ana jum̃abe vonganei? Kamiu kumijikia kija vite nalo nei naruei, p̃eli na makan vo?” ");
INSERT INTO bki_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Naruei Yesu nalo abinimei abokar komeli nei, Betsaeta. Ana nalo na vio na, aburu merebono tai binimei ea Yesu, ajegi ban Yesu ka naio tokol vatitig toro nene. ");
INSERT INTO bki_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ana Yesu bokar merebono napano jum̃ano, ana naio burio bano, ana naljuo aban bilig ea komeli tivelinio abano. Naruei Yesu midu titinio jua toro napano mirano, a naio midu jum̃ano joa mirano be juo, ana bika den naio, berinavo “Jum̃abe, jau kojo komial vite, p̃elina makan vo?” ");
INSERT INTO bki_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ana toro napano naio jirarago, mial vio, mia naio ber berinavo “Nao-o, kiniou nemial tomu nalo, a nemial nalo jibe bulapati buruiesi ga nalo napano aju amiel.” ");
INSERT INTO bki_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ana Yesu midu jum̃ano joa naio bereio ea bogo valuo nene, ana toro nei, mirano binimei bo nonovio garuei, ana naio jirarago bereio, mial vite nalo meravo mia meravo bo. ");
INSERT INTO bki_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ana Yesu berkanio, berinavo “Mia kavan re bunu keial nalo na ajua komeli, kavan memedu ea kunuamo.” ");
INSERT INTO bki_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mia Yesu bija kiano atevi nalo ajidom avatove ea m̃arkomeli na tertelisu vaataro ka komeli na toru nei Sisiria Vilipai, a bogo napano nalo aju amiel ea m̃arabo ka avatove ea vio na, naio bika denlo berinavo “Kamiu kumitu kumijog tomu nalo aju aberverii kiniou ka kiniou kiniou kei?” ");
INSERT INTO bki_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nalo aberdop̃e banio, aberinavo “Tealo aberinavo jau Jone Baruei bereio, a tealo aber Elaija, a tealo aber jau naverialiano na nuanua laka.” ");
INSERT INTO bki_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ana naio bika bereio den nalo, berinavo “A jum̃abe ka kamiu, kamiu kumitu kuberii kiniou kiniou kei?” Naruei Pitere berdop̃eio, berinavo “Jau kobe kenememi Naverikariano memedu na.” ");
INSERT INTO bki_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ana Yesu ber memedu banlo, beri-navo “Bo, mia kamiu kuva kuverialio re vite nei van tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ana ea bogo na, Yesu jikar ka milavon ka riverloglog kiano atevi nalo ka Kulorinio Kenerinio, mia monoka nalo ala vite ve telabo napano mia naio rijog rivova kanio, a mia navurim̃araboiano nalo na kulo Israel bija kialo parinio kulo lu nalo, bija tomu na verloglogiano na tuboiano nalo, mia nalo avukular naio. A Yesu ber bunu mia auebin naio, mia bogoti ve tolu nene, mia naio tumolu bereio, naio tovulu m̃ariano. ");
INSERT INTO bki_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iliano nalo nei, Yesu berialio meravo vatitig kalo, a bogo na Pitere mijogio, bio Yesu, burular naio, mil jikili banio, jidom verbure naio, ber mia tibe na re. ");
INSERT INTO bki_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A sop̃eli ga Yesu naio bilig taakano ka Pitere, naio bitii ban ea kiano atevi nalo dolu na aju, ana naio mil koko vio jikili ban Pitere, ber kaio, berinavo “Sim̃aro, kava bilig den kiniou! Kiamo jidomiano na be toro kiano ga, maka Atua kiano jidomiano leleio.” ");
INSERT INTO bki_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ana Yesu bio tiniobi nalo bija kiano naiagagoano nalo, ka amei ea naio, ana ber kalo, berinavo “Toro na jidom takisor kiniou, naio monoka sidomii iakurano ea kiano sidomiano nalo, monoka rudu kiano m̃akolkolo, ana takisor kiniou. ");
INSERT INTO bki_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Toro na jidom rilarur kiano meuliano, mia rilaluvuio. Mia ver toro tas milaluvu kiano meuliano bior kiniou, p̃eli na bior kiaku Ioluano Vou, mia naio rije ioruriano. ");
INSERT INTO bki_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Verver toro tai rije vite nonovio na yetemeriba nei, mia iorou naio rilaluvu m̃arabo na meuliano, naio maka rije tena bo tai leleio. ");
INSERT INTO bki_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mia kiano vite novo nalo nei napano bario, maka ajikia avulu kean bere kiano meuliano bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tomu nalo miroano ea taara na vonganei nalo amila kariano, nalo maka leleio ave riano ea Atua, nalo abova laka, a nalo amimou ka tomu dolu nalo bior kiniou bija kiaku iliano. Ana iorou mia Kulorinio Kenerinio rimei bereio, naio vija kiano nailiano lu nalo, vija karam̃ano kiano mermerano, a bogo na amei, ver toro mimou ka naio vonganei, mia naio bunu rimou ka toro nene.” ");
INSERT INTO bki_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A Yesu ber bunu banlo, berinavo “Riano ga neber ka kamiu, tomu nalo tai na aju ajikili ajua vio nei, napano mia nalo maka ajikia am̃arm̃aro, rivanvano-o rivokar bogo na nalo aleal Atua kiano Navena-tuboiano rimei riyotuba vija kiano burum̃ara sikiliano.” ");
INSERT INTO bki_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iorou ka bogo nei, bogoti ari barlaka ruei, ana Yesu buru Pitere, a Yemesi, a Jone, nalo abano mave ea burusuku tai na bavin laka, napano nalo veri ga. Ana bogo na nalo aju jibena, naiagagoano tolu nei amial Yesu niabene jo binimei be dolu, ");
INSERT INTO bki_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","a nalo amial kiano kulum̃arauo nalo amieg, a nalo amiuvu bo mia amiuvu nonovio garuei, jovulu vite dolu nalo tealo na yetemeriba neibano na amiuvu. ");
INSERT INTO bki_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ana nalo amial bunu naverialiano Elaija bija tormoruo Mosis, naljuo amiyotuba, naljuo aju ajukunu bija Yesu. ");
INSERT INTO bki_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ana Pitere ber ka Yesu, berinavo “Tubo, bo ka kito rotua vio nei. Bo ka kumemi nuvim̃auka yimo tobobo ve tolu ea vio nei, kiamo ve takurano, Mosis kiano ve takurano, a Elaija kiano ve takurano.” ");
INSERT INTO bki_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitere mil vovu jibe na ka nalo amemebiju laka, a nalo amerou, nalo maka bunu ajikia mia aver venia. ");
INSERT INTO bki_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ana vaarakurano ga, melijo tai binimei jovukolo, ana nalo amijog iliano tai binimei eaio, berinavo Ninei be keneriku na, napano kiniou nojidom naio laka. Kamiu monoka kuvijogkar vatitig naio. ");
INSERT INTO bki_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Naiagagoano nalo amijog iliano na, ana ajiraravo jeliviv ealo, ana maka bunu aial naljuo nabano, mia amial Yesu naio ga takurano jo bijalo. ");
INSERT INTO bki_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ana nalo ajaluvo den burusuku neibano, nalo aju abatove bereio, ana Yesu mil jikili banlo, berburelo berinavo “Tena Atua mila kumialio, mia kamiu kuvan kuver re ka tomu nalo vonganei, riva riva rivokar bogo na Kulorinio Kenerinio naio rimeul bereio ea nam̃ariano, naruei ea bogo na mia kuverialio ka tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ana nalo amijogkar Yesu kiano iliano nei, mia nalo abokar iliano nei be kialo ga, kar na nalo aju abivika denlo aber venia naruei be nioti na kiano iliano nei napano naio jo berii rimeul bereio ea nam̃ariano. ");
INSERT INTO bki_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ana naiagagoano tolu nei nalo abika den Yesu, aber “Jum̃abe ka tomu na verloglogiano na tuboiano nalo aju aber Elaija mia rimei bereio beamu, iorou Naverikariano nei mia riyotuba?” ");
INSERT INTO bki_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ana Yesu berdop̃e banlo, berinavo “Nina nalo aberiio be riano ga, Elaija monoka rimei beamu ka rila saba nalo rimemedu ka Naverikariano naio rijikia rimei. Mia iliano lu nalo aju aber todolu tai bunu na nalo maka atu asidomiio, nina jo berii Kulorinio Kenerinio, berinavo mia naio monoka riviviuo bogokouo ve telabo, a mia tomu nalo asidomii va lelan naio laka. ");
INSERT INTO bki_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A kiniou neber ka kamiu, neber Elaija nei naio binimei vonga garuei, a tomu nalo maka asidom naio. Jibe Iliano Lu naio berenio, nalo amila bova ka naio ruei.” ");
INSERT INTO bki_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Naruei Yesu bija nalo tolu nei aju aban ea naiagagoano dolu nalo, ana amial napano tiniobi miroalo aju jeliviv ealo, a nalo amial ka naverloglogiano nalo na tuboiano bunu aju jeliviv ealo. ");
INSERT INTO bki_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ana bogo na tiniobi nalo nei amial Yesu jo binimei bereio, nalo amiilo ka naio, a nalo ajaaro toru ka amialio, ana nalo ajikiti abinimei eaio, nalo aban jum̃alo bija naio. ");
INSERT INTO bki_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ana Yesu bika den naiagagoano nalo berinavo “Ee, kamiu kumitu kumitukunu ka vaio bija nalo na?” ");
INSERT INTO bki_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ana nalo tai ber ka Yesu, berinavo “Naverloglogiano, kiniou naruei noburu keneriku sum̃ano m̃eaku binimei easo ka jau keial naio, ka sim̃aro tai na buru joa naio. ");
INSERT INTO bki_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ana bogo na jo mim̃aukanio, buku naio batove ea borotano, titinio miou kirivova jibe tililevlevi, naio jer m̃arjuvono, a niabene nalo am̃arm̃ariulu. Ana kiniou noburu naio binimei, ana jau maka koto, ana nebika kiamo naiagagoano nalo ka abolkouo ka ajil lar sim̃aro nene, ana nalo amila vonvonio, amila banbano-o, nalo abijukudeio.” ");
INSERT INTO bki_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ana Yesu berdop̃e, mil banlo, naio berinavo “Kamiu na, jum̃abe jibe na? Kamiu maka kuvitu sikili ea Atua leleio. Kiniou monoka noto vija kamiu vano-o vokar nagi? Kiniou tinieku maro ka kamiu ruei. Mo, bo ga, kuvuru m̃eaku nene rimei ea kiniou.” ");
INSERT INTO bki_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ana nalo aburu binimei, ana bogo napano sim̃aro nene mial Yesu, mila m̃eaku neibano niabene m̃arm̃ariulu, mila mijoru ea borotano, naio jo bilivilig janea vio jibe na, a mila titinio miou bova jibe jo bep̃eili. ");
INSERT INTO bki_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ana Yesu bika sum̃ano m̃eaku nei karam̃ano, berinavo “A sim̃aro nei jikar mila naio jibe na nagi ruei?” Ana karam̃ano berdop̃eio, berinavo “O, tenei nua ruei, bogo na naio be tete kia ga vo. ");
INSERT INTO bki_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Binimei bokar banei bogo telabo ruei, tena jom̃a mila naio jo mijoru batove ea sebi p̃eli ea bulukue. Tena jidom ruebulag naio laka, a ver jau komijikia kala titai ka naio, kumemi nubika denso, aua jau tiniem riia kumemi, jau koija kumemi rivior kenerimemi nei.” ");
INSERT INTO bki_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ana Yesu ber ka naio berinavo “Kiniou nomijog ka kober jibe na, ver kiniou nejikia neim̃aukaio. Ana kiniou neber kaso, verver jau komonmonea ga, jau komijikia koim̃auka vite nonovio.” ");
INSERT INTO bki_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Naruei sum̃ano m̃eaku nei karam̃ano bio sop̃eli ban Yesu, jegi banio, berinavo “Nojo nomonea teliki, a maka nomonea vare vo. Aua jau koija kiniou ka kiaku moneano rimei ve toru lie.” ");
INSERT INTO bki_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ana bogo na Yesu mial ka tiniobi abinimei miroano aju ajelivivi ealo, ana naio mil ban niununo va nei napano joa sum̃ano m̃eaku nei, berinavo “Jau niununo va na tiliniene bono, a na be buru, neber memedu banso, neber jau kataluvo den naio vonganei, a mia kavan lele re bunu joomo eaio bereio bogo tai.” ");
INSERT INTO bki_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ana niununo va nene miaga va laka, a mila sum̃ano m̃eaku nei niabene am̃arm̃ariulu banbano ba bova laka, ana naio jaluvo denio, buro bano. Vonganei sum̃ano m̃eaku nei niabene melukluku laka jo, jibe ka naio m̃aro ga, a tomu nalo na aju abitii aber jibe nei naruei, aberinavo “O, sum̃ano m̃eaku nei naio m̃aro ruei na.” ");
INSERT INTO bki_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mia Yesu bokar jum̃ano, ana buru sum̃ano m̃eaku nene jumolu, ana jumolu ju vatitig jo. ");
INSERT INTO bki_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mia iorou, Yesu ban bere ea komeli bereio, ana ka bogo na, napano naio jo naio takurano ga, kiano naiagagoano nalo abinimei abika, aberinavo “Jum̃abe kumemi maka nuvijikia nuvijililar sim̃aro na joa sum̃ano m̃eaku na?” ");
INSERT INTO bki_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ana Yesu ber kalo, berinavo “Sim̃aro ninio nalo na jibe na, nalo ajikili laka, volkouano ga mijikia rijil bulaglo.” ");
INSERT INTO bki_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mia Yesu nalo ajuvan vio nei, ana nalo abanvano amalmaluvo ga ea tanobuku nalo na Kalele, mia ea bogo na, Yesu maka sidom ka tomu nalo ajikia venia na naio jo milaio, p̃eli ea vio vabe na nalo aju aban eaio. ");
INSERT INTO bki_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nina, bior ka naio jo berloglog kiano naiagagoano nalo ea bogo na, ana naio jo ber kalo, berinavo “Vaataro ka mia adu Kulorinio Kenerinio van ea tomu nalo jum̃alo napano mia auebin naio rim̃aro, mia iorou, ea bogoti ve tolu, mia Atua rila naio rimeul bereio.” ");
INSERT INTO bki_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A kiano naiagagoano nalo maka ajoglubarbar vo venia napano Yesu naio jo berenio banlo, a nalo amerou ka avika vatitig denio bereio. ");
INSERT INTO bki_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ana iorou, bogo tai abinimei abokar bereio Kapeneam, abinimei joomo ea yimo tai, ana Yesu bika den kiano naiagagoano nalo, berinavo “Kamiu kumitu kubivivika iliano ea kamiu ea m̃arabo bior vaio?” ");
INSERT INTO bki_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mia maka averdop̃eio van naio, bior ka bogo na nalo aju amiel abinimei ea m̃arabo, nalo aju amil banlo, aber kei kalo na jo loa mave, p̃eli kei naio bo loa tealo. ");
INSERT INTO bki_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ana Yesu jotano, bio nalo duelimo ba juo 12 nei ka amei vaataro ka naio, ana naio ber kalo, berinavo “Verver kamiu tai na jidom naio to ve moti, a naio jidom ka siano to mave, bo ga, ana mia naio monoka rila naio rimei ve na maariano, to totano maariano laka garuei, naio monoka rimei tibe toro na im̃auano na nalo dolu beamu.” ");
INSERT INTO bki_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ana Yesu bio kiritete tai napano jo binimei ea naio, naio miduio jikili ju iviso kalo, ana naio bokar tete nei ana ber kalo, berinavo ");
INSERT INTO bki_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Toro na kiano jidomiano batove ka kiniou, ana naio tinien jaaro ka rila vatitig kiritete tai na jibe nei, nina, jibeka ga na naio jo jaaro ka kiniou. A toro na jaaro ka kiniou jibe na, maka saaro ka kiniou ga, mia naio jaaro ka nina naio miila kiniou nebinimei.” ");
INSERT INTO bki_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ana naiagagoano nei Jone ber ka Yesu, berinavo “Naverloglogiano, kumemi numial toro tai, napano naio jo mijil bulag sim̃aro nalo, naio jo mijil bulaglo ea siamo. A toro nene maka nuvijikiaio, naio maka ve kito tai, mia kito rotuko vio ka naio.” ");
INSERT INTO bki_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ana Yesu ber kalo, berinavo “Makanio, kamiu kuverbure re naio. Verver toro tai jibe naio be riano, ana naio mila im̃auano nalo na bo tortoru laka ea siaku, mia toro na maka rijikia ril vova ea siaku bereio bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Toro na maka to toko vio ka kito, naio jo miija kito na. ");
INSERT INTO bki_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Neber be riano ban kamiu, ka ver toro tai mijikia ka kamiu kumitu kubar Kristo siano ea kamiu, ana naio midu baja na uei tai ban kamiu ka kumunio, toro na mia maka rijikia rilaluvu kiano jidomiano tai na bo mia naio ruduio iorou.” ");
INSERT INTO bki_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","A Yesu ber bunu, berinavo “A verver toro tai rila ka tete tai naio maka bunu sikili ea kiniou, mia toro na ridu mauo tai na jikili lie vo, todovulu nina mia ver aiorikar puruveru tai na toru ea burujono ana avuku naio rivan ea niogovu. ");
INSERT INTO bki_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","46","“Verver jum̃amo tai p̃eli na jaamo tai milaso maka bunu koto sikili ea kiniou, bo ka ketelario rivan ga. Verver kete bajago na kariano ea kiamo meuliano tibe na, mia komijikia kava joomo ea meuliano, a ver kava joomo ea meuliano a jum̃amo tivelinio p̃eli jaamo aba kovio ruei, nina bo ga na. Mia bova laka ver jum̃amo ve juo vija jaamo ve juo nalo atu rivu ga, mia iorou avukuso ea sebi na maka rijikia rim̃aro bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","P̃eli ver miramo, p̃eli venia bereio ea kiamo meuliano milaso maka bunu koto kesikili ea kiniou, bo ka jau koija lario ga. Tibe na, mia jau kava joomo ea Atua kiano navenatuboiano napano vite teliki nei bakovio denso ruei, a nina bo ga na. A bova laka ver miramo ve juo p̃eli kiamo bajago bova nalo ju bo ga easo, mia iorou tenalo teliki nei ga buru kiamo meuliano ban ea sebi ea vio na jogvaiano, ");
INSERT INTO bki_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","napano sebi nene maka rijikia rim̃aro bogo tai, sorel nalo aju ajen mokotenamo bogo nonovio ga. ");
INSERT INTO bki_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Jibe na tei mijikia rila sinaniano maka jikia soono, mia Atua ridu sebi toa tomu nalo ka sisen bulag soro nalo na joa kialo meuliano. ");
INSERT INTO bki_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mia romial bunu tei mila sado sinaniano jesei bunu, a ver kiano sikiliano riva kovio, naio maka bunu rijikia rila kiano im̃auano. Vonganei kamiu monoka kuvijamo ka Atua kiano tei rim̃au ea kamiu bogo nonovio, ka kenemiu meuliano soono re, a ka kenemiu bajago naio sese, mia kamiu kuvitu vija tum̃aro bogo nonovio.” ");
INSERT INTO bki_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ana iorou, Yesu juvan vio Kalele, naruei naio bavin tivelinio ka tanobuku na Yutea, ea m̃arauei na vio Yortano tivelinio bano. Ana tiniobi nalo aju abinimei ea naio bereio ea vio na, a javukia napano naio jom̃a mila julaka, naio berlogloglo ka vite telabo. ");
INSERT INTO bki_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mia Varisis tai aju bunu ea bogo nei, mia nalo abinimei ea Yesu, a ajidom alavon naio bereio, naruei nalo abika vikadeniano tai denio. Nalo aberinavo “Tuboiano na kanado naio ber vaio ka tivelinio na bajago nei napano toro naio jitiglar koano? Jum̃abe, jau be tiniemo ka napano toro mijikia rila tibena, p̃eli na maka rimemedu?” ");
INSERT INTO bki_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ana Yesu bika ber banlo, berinavo “Mia tormoruo Mosis naio berial venia ea kiano tuboiano ruei?” ");
INSERT INTO bki_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mia Varisis nalo nei aberenio, aberinavo “Mosis naio berial ea tuboiano tai napano mijamo ka toro mijikia sian m̃esi tai van koano, naruei naio mijikia riilalar naio rivano.” ");
INSERT INTO bki_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mia Yesu naio berdop̃e banlo, berinavo “Nao, mia Mosis naio bivitauia iliano na bior napano ga pariparimiu nalo abinimei jikili laka, tenene na naruei mila naio mijamo jibe na kar kamiu kumijikia kuviilalar kouemiu nalo. ");
INSERT INTO bki_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mia jikario ea tiiano naio maka tibena, bior napano Atua kanano iliano lu naio berinavo ‘Ea burupati Atua jii tomu nalo, napano sum̃ano bija tira.’ ");
INSERT INTO bki_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“A iliano dolu bunu berinavo ‘Tibena, mia toro tuvan karam̃ano a kenieno, naruei riva to rivijurukar vija koano, ");
INSERT INTO bki_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","naruei naljuo abinimei abe takurano ga.’ “Nina naio mila ka naljuo maka bunu ave juo, mia naljuo abinimei abe takurano ga. ");
INSERT INTO bki_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mia venia na Atua miasolio binimei be takurano, maka rimemedu ka toro silubar bereio.” ");
INSERT INTO bki_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ana bogo napano nalo aba joomo ea yimo bereio, Yesu kanano naiagagoano nalo abika naio bereio tivelinio na iliano nalo nei. ");
INSERT INTO bki_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ana Yesu ber memedu banlo, berinavo “Verenio toro tai titiglar koano, karina naio riva rivuru tira dolu tai, Atua mial jibe toro nei naio jo mila siakaiano ruei, naio mila lelan bunu tira nei napano naio be koano jukamu. ");
INSERT INTO bki_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mia verenio tira tai rivuro den kanano sum̃ano, riva soro ka toro dolu tai bereio, naio bunu Atua mial ka naio mila siakaiano ruei.” ");
INSERT INTO bki_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Naruei tealo aburu kenerilo nalo abinimei ea Yesu ka naio tokol lo, ana naiagagoano nalo amialio, naruei amil jikili ban tomu nalo nei aberburelo. ");
INSERT INTO bki_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mia bogo napano Yesu mialio, maka saaro leleio ka napano kanano naiagagoano nalo amila jibena, ana naio ber kalo, berinavo “Kamiu kuverbure re kiritete nalo na, kamiu kuvijamo kalo amei ea kiniou ga, bior napano kiritete nalo ajibe ka ga tomu nalo napano aju jouro ea Atua kiano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kiniou neber riano ka kamiu, ka toro napano naio jidom riva jouro ea Atua kiano navenatuboiano, naio monoka rijikia ka naio javukia kiritete teliki tai ga, naio maka rijikia rila vite tai ka rila ka naio rudu Atua kiano navenatuboiano nei ea kiano meuliano.” ");
INSERT INTO bki_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ana Yesu bokar kiritete nalo nene, jikario naruei ka naio midu jum̃ano joa pariparilo ka naio rilivu kalo. ");
INSERT INTO bki_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Naruei bogo napano Yesu jo batavio ka riel rivano, toro tai jikiti binimei minie tano ka Yesu, naio bika denio, berinavo “?Naverloglogiano novo, kiniou monoka nala im̃auano vaio ka rila ka mia kiniou novokar meuliano nei napano maka rijikia ribisi?” ");
INSERT INTO bki_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ana Yesu ber ka naio berinavo “?Bior vaio ana jau kobio kiniou jibe na kober kiniou nebe naverloglogiano novo? Maka ve toro tai napano be kirinovo to, mia Atua naio ga takurano naio be kirinovo. ");
INSERT INTO bki_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A jau komijikia bunu kanano tuboiano nalo, napano kito monoka romonea nalo, napano aber jibene aberinavo: Jau kouebin re toro, jau kola re siakaiano, jau kovina re, jau kala sibi re, jau kojukujuku re toro, jau kavamenea karam̃amo naio koniomo.” ");
INSERT INTO bki_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ana m̃eaku nene berkanio, berinavo “Naverloglogiano, tuboiano nalo na napano jau koberenio, bogo napano kiniou nebe tete kia ga vo, kiniou nojom̃a nobokar nonovlo, binimei bokar banei.” ");
INSERT INTO bki_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ana Yesu bitikar naio bano-o, tinien jii naio toru bior kanano iliano nei, ana naio berkanio, berinavo “Vite takurano ga jo keano vo, napano jau maka kalaio vo. Jau kava koṽiliṽili bulag ka kanamo vite nonovio nalo, ana jau kavar veru na vite nalo nene, jau kava kotiburevure van talim̃asa nalo. Ver jau kala tibena, mia jau ve kanamo vite novonovo nalo ve miroano ea tiniabene. Mo, jau kava kalaio, karina komei katakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mia bogo na m̃eaku nei mijog iliano nei, naio miilo va kanio, ana kanano iviso mijog bova toru, bior napano naio be kiano vite miroano. Ana naio jaluvo den Yesu. ");
INSERT INTO bki_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Naruei Yesu jirarag jeliviv ea naiagagoano nalo, ber kalo, berinavo “?Kiniou neber batitig ban kamiu, neber ver toro tai napano be kiano vite miroano, mia naio jidom riva jouro ea Atua kanano navenatuboiano, nina naio jikili mia jikili na.” ");
INSERT INTO bki_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mia naiagagoano nalo amiilo toru laka ka Yesu kiano iliano nei, ana naio ber bereio kalo, berinavo “Riano keneriku nalo, ka ava jouro ea Atua kanano navenatuboiano, jikili mia jikili na. ");
INSERT INTO bki_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kiniou neber ka kamiu, ka kamele tai riovodulu ea bulumirano nitil tai, naio jikili laka, mia ka toro tai napano be kanano vite miroano ka naio rijikia riva jouro ea Atua kanano navenatuboiano, nina naio kirisikili lie vo.” ");
INSERT INTO bki_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ana bogo na naiagagoano nalo amijog iliano nalo nei, mia nalo amiilo toru laka kanio, ana aberinavo “Tomnei! Mia karina, aber mia kei naio mijikia rivokar meuliano?” ");
INSERT INTO bki_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mia Yesu jirarag bitikarlo, berinavo “Toro maka rijikia rilarur toro, mia Atua naio mijikia rila vite nonovio.” ");
INSERT INTO bki_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naruei Pitere naio jidom ril naruei, berinavo “?Mia jum̃abe ka kumemi? Kumemi numituvan kenememi vite nonovio ruei, ana kumemi nubinimei numitakisorso.” ");
INSERT INTO bki_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ana Yesu ber kalo, berinavo “Kiniou neber riano ban kamiu, ka toro kei napano naio tuvan kunuano, p̃eli kuruano bija kuviviniene, p̃eli kenieno bija karam̃ano, p̃eli kenerinio, p̃eli kiano borotano, rivior kiniou a rivior kanaku ioluano vou nei, ");
INSERT INTO bki_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mia naio rijev bereio venia naio juvan riva rivokar toromomou ve takurano 100. Ea yetemeriba nei, mia naio rivokar bereio yimo nalo, kuruano nalo, kuviviniene nalo, kenieno nalo, kenerinio nalo, borotano nalo, mia vija vite nalo nei mia naio rivokar bogokouo nalo ve telabo, napano tomu nalo ajerm̃i ka naio bunu. A mave ka vite dolu nalo nei, ea bogo napano jo binimei, mia naio rivokar bunu meuliano nei napano maka rijikia ribisi. ");
INSERT INTO bki_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mia tomu telabo napano m̃a aju mave vonganei, iorou nalo atu yetano, a nalo napano m̃a aju yetano vonganei, iorou mia nalo atu mave.” ");
INSERT INTO bki_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ana Yesu nalo aju amiel ea m̃arabo, aju abavin Yerusalemo naruei. Ana Yesu naio jo miel jukamu ka kanano naiagagoano nalo, mia aju amiilo laka napano naio jo burum̃arabo kalo aba Yerusalemo, bior nalo amijikia ka tomu nalo na vio na ajerm̃i laka ka Yesu. A nalo dolu nam̃a aju abinimei iorou kalo, nalo bunu aju amermerou kija naruei. Mia Yesu naio bio kanano duelimo ba juo 12 amei vaataro ka naio, ana naio berial bere kalo jum̃abe mia ala kiki naio yako Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Naio ber bisivisii banlo, naio berinavo “Kamiu kuviniagago vatitig. Vonganei kito roju rabavin Yerusalemo naruei, napano rivesiou re, mia adu Kulorinio Kenerinio toa tomu na tortoru na kulo lu nalo jum̃alo nalo vija naverloglogiano na tuboiano, naruei mia nalo na atibure naio ka mia naio monoka rim̃aro. A mia adu naio toa kulo Romo nalo jum̃alo, ");
INSERT INTO bki_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","naruei nalo na mia ayotel va ea naio, avule mirano, mia avitiv naio, rivan mia auebinio rim̃aro. Mia ka bogoti ve tolu nene, mia naio rimeul bereio.” ");
INSERT INTO bki_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ana nalo aban lie telisu bereio, ana Sepeti kenerinio juo nei Yemesi naio Jone, naljuo abinimei vaataro ka Yesu, ana abika denio, aberinavo “Naverloglogiano, kumemi juo numisidom ver venia na mia kumemi ve juo nuvika denso vonganei, mia jau kotuvan van kumemi juo ga.” ");
INSERT INTO bki_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ana Yesu berdop̃e ban naljuo, berinavo “?A kamjuo kumisidom kuvika ka mia kiniou nela vaio ka kam ve juo?” ");
INSERT INTO bki_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ana nalo abe juo aberdop̃eio, aberinavo “Kumemi juo numisidom ka kajamo ana ver bogo napano jau komei tibe parinio tubo ea yetemeriba nei, mia kumemi juo numijikia nuvitutano ea kiamo vio lu vaataro kaso, tai toa jum̃amo meruo, a tai ea mali.” ");
INSERT INTO bki_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ana Yesu ber ka naljuo, berinavo “Kamjuo maka kuvijikia tena kamiu kumitu kubikanio? Jum̃abe, kamjuo na kumisidom ka kamjuo kubare ka romunu vio takurano ea baja na jogvaiano na mia kiniou monoka nomunu eaio? P̃eli kamjuo kuber kamjuo kumijikia kuvidu varueiano napano abaruei ea kiniou kanio?” ");
INSERT INTO bki_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ana naljuo aber ka naio, aber “Ee, kumemi juo nubare.” Ana Yesu ber ka naljuo, berinavo “Ee, be riano ka mia kamjuo kumunu ea kiaku baja na jogvaiano, a be riano bunu ka mia avaruei ea kamiu ka uei napano abaruei ea kiniou kanio, ");
INSERT INTO bki_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","a vite na kamiu kubika na, ka kam ve juo kuvitutano vija kiniou, ea tivelinio ve juo na kiniou, tena maka ve kiaku ka mia nejikia notuvan van kamjuo. Vio nalo na jibe na, nalo ga na Karam̃aku mila vatitigio kalo, a napano naio berkar ruei ka mia nalo atutano ealo.” ");
INSERT INTO bki_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mia naiagagoano duelimo dolu amijog tenei napano kurualo juo nei Yemesi naio Jone abikanio, ana nalo tiniel jerlo abe juo. ");
INSERT INTO bki_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ana Yesu bio nalo abinimei ka naio ril vanlo, ana naio ber kalo, berinavo “Kito romijikia ruei tomu nalo kialo bajago napano maka amonea Atua. Kito romial ka tubo nalo bija tomu nalo na tortoru ea vio yetemeriba nei, nalo aju ajututua tomu nalo dolu ka atu yetano ka nalo bogo nonovio. ");
INSERT INTO bki_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","A kiaku naiagagoano nalo kenemiu bajago monoka tibena re. Verver kamiu tai sidom ka rimei rive toro na toru tai p̃eli naio rimei rive kenemiu toro na vurim̃araboiano tai, kiano m̃arabo jibe nei. Toro na monoka rimei tibe toro tai ga na rim̃au kenemiu. ");
INSERT INTO bki_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kulorinio Kenerinio mila jibena ruei, na naio maka rimei ka tomu nalo aija naio, mia naio binimei ka rijai tomu nalo a ka rijamo ka kiano meuliano ka rivulu bulag tomu ve miroano.” ");
INSERT INTO bki_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ana Yesu bija kiano naiagagoano nalo abinimei aju Jeriko, ana iorou, bogo na nalo ajum̃a abanvan ea komeli nei, tomu miroano ajakisorlo. Nalo aju amiel abano, ana merebono tai naio jom̃a jotano ea ikim̃arabo tivelinio ea vio nei. Toro nene, karam̃ano siano Timeas, ana nalo abio kenerinio nene ka Batimeas. Batimeas nene, naio jom̃a jotano ea m̃arabo bogo nonovio ga, naio jo bio ban tomu nalo ka nalo aje veru ve teliki van naio ka rimeul eaio. ");
INSERT INTO bki_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A bogo na mijog ka Yesu na vio Nasarete nei naio jo miel ea m̃arabo binimei, naio jo bio, berinavo “Oi Yesu, jau Teviti kiano bajulukuti! Kiniou nojidom tiniem riia kiniou beamu.” ");
INSERT INTO bki_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ana tomu nalo dolu amil tiniemimi ban naio, aberinavo “!Ei, jau koyotuba re!” A naio jo bio mave lie, berinavo “Oi Tubo, jau Teviti kiano bajulukuti! Neber bo kaso tiniem riia kiniou!” ");
INSERT INTO bki_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ana Yesu binimei jikili joa vio nei, ber ka tomu nalo ber avio toro napano na rimei vaataro ka naio, ana nalo aba aber ka merebono napano, aber “?Ei, komijikia vaio?” Ana toro neibano ber “Venia?” Nalo aber “Yesu nei naio berenio jau komei vaataro ka naio beamu vo. Bo ga, jau kotumolu kito ravano.” ");
INSERT INTO bki_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ana toro napano naio miyalar m̃ano kulukoti, naio jumolu sop̃eli ga, ana binimei ea Yesu. ");
INSERT INTO bki_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mia Yesu bika den naio berinavo “?Ana jau kojidom mia nala vaio kaso?” Mia toro nei berdop̃e, berinavo “Tubo, aua, kiniou nojidom ka kala miraku nalo rimei rivu, ka kiniou nejikia nesirarago.” ");
INSERT INTO bki_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mia Yesu ber kanio, berinavo “Bo, jau komijikia kavan bere ea kiamo vonuo, kiamo viekouoiano naio mila na jau kobinimei bo ruei.” Mia toro nei naio mial vatitig vite ea aura nene ga, mia naio jo mieliel ea m̃arabo, naio jo jakisor Yesu bano. ");
INSERT INTO bki_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Vonganei, Yesu nalo abini mei vaataro ka Yerusalemo naruei, ana beamu kanio, nalo amiyotuba ea komeli juo nalo na terteliki nei, Betevas bija Betani, napano nalo aju tivelinio ea suku nei napano ajisia ka Suku na Buruolivi. Ana Yesu miila kiano naiagagoano juo, berinavo ");
INSERT INTO bki_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Kamjuo kuvan ea komeli yako na, mia memedu ka bogo na kam ve juo kuva jouro eaio, mia kuvial kirikiti togki tai, napano amiadikario ju, napano toro maka lele totania kija taakano vo. Mia kam ve juo kuvijubarlar sano teli, ana kuvuruio rimei bereio van kiniou ea vio nei. ");
INSERT INTO bki_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A verver toro tai ril rivan kamiu kanio, rivika riverinavo ‘?Kamiu kumila jibe na ka venia,’ mia kamiu kuver ka naio, kuverinavo ‘Tubo naio jidom temeul nei, a mia naio riila rimei bereio ea vio nei vesiou re.’ ” ");
INSERT INTO bki_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ana naiagagoano juo nei abano, ana aba amial kirikiti togki nene, napano amiadikario, naio jumolu ju ju tavio ka m̃aratavo na yimo tai tivelinio ka m̃arabo. Ana naljuo ajidom ka ajubarlar sano teli, ");
INSERT INTO bki_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mia nalo napano ajua vio na, abika aberinavo “?Oi, kamiu kumitu kumila venia na, na kumitu kumijubar bulag teli nene na?” ");
INSERT INTO bki_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mia naljuo aber kalo iliano nalo na Yesu ber kalo ruei, napano mia nalo amijikia averii ka tomu nalo, ana tomu nalo amijamo ka naljuo amijikia avuru togki riva rivu ga. ");
INSERT INTO bki_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ana naljuo aburu togki nene binimei, ana nalo abisi m̃alo kulukoti nalo ea taakano, ana Yesu bavin jotano mave eaio. ");
INSERT INTO bki_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ana tomu nalo miroano amiya bulag m̃alo kulukoti nalo abisi ea m̃arabo, a nalo tealo aba aje m̃am̃ali nalo, abar abulan ea m̃arabo ka togki naio rijikia riel eaio. Jibe na, nalo amila ka avatove ka Yesu jibe ka naio be tubo tai na toru laka. ");
INSERT INTO bki_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ana nalo amiel ka abano ka ava jouro Yerusalemo, a tiniobi nalo napano aban jukamu ka Yesu, bija nalo napano iorou ka naio, nalo aju amiaga laka jibe nei, nalo aberinavo !Bo mia bo laka! Roiovu ka naio! !Atua Sop̃i jau keilivu ka naio nei napano binimei ea siamo! ");
INSERT INTO bki_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!Kito rajaaro toru ka Navenatuboiano na kiado tormoruo Teviti nei napano joa binimei! Kamiu nalo na tiniabene mave kuviovu bunu ka naio! ");
INSERT INTO bki_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ana Yesu ba jouro yako Yerusalemo, a naio ba bokar Atua Kunuano Lu. Ana naio ba joomo, ba bitii vio nalo nene, a vite nalo nonovio napano amila eaio. Ana m̃erenio jo batove ruei, mia naio buru kiano naiagagoano duelimo ba juo 12, ana nalo ajaluvo ea komeli na toru nei bereio, nalo aba amon Betani. ");
INSERT INTO bki_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ana kavijova, nalo ajaluvo Betani bereio, nalo amiel abinimei bereio Yerusalemo, ana Yesu naio mijog vitu. ");
INSERT INTO bki_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana naio bitii buruviki tai jo, ana naio miel ba vaataro kanio ka rivar m̃arati tealo. Mia bogo na naio binimei mialio, naio mial ka buruviki nene, m̃ati telabo, a maka ve m̃arati, bior maka ve bogo nene vo. ");
INSERT INTO bki_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ana Yesu naio mil ban buruviki nene, berinavo “Jau, mia jau maka leleio kejikia kavar m̃arati bereio ka tomu nalo ajikia asenio.” A kiano naiagagoano nalo amijog bunu ka naio ber iliano nei. ");
INSERT INTO bki_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ana Yesu nalo aba abokar Yerusalemo bereio, ana nalo aban bereio joomo ea Atua Kunuano Lu. A Yesu bitii bereio ka tomu nalo miroano ka nalo aju tivelinio ka yimo, nalo aju amim̃auka im̃auano nalo na ka ajev veru eaio, a tomu miroano aju abulu saba nalo na aju ap̃ilṽili kanio. Ana naio maka leleio saaro kanio, naio ba mijil bulaglo, bilig dea ka barobaro nalo napano nalo ajum̃a amijebukua veru nalo na vio Romo binimei ea veru na kulo Ju nalo kialo, napano nalo ajum̃a ajuvanio ea Yimo Lu. A ba bunu buku bulag kialo iesi na totaniano na nalo aju ap̃ilṽili ka sibo na sida. ");
INSERT INTO bki_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A naio berbure bunu nalo nam̃a aju ajidom avar kialo saba nalo na im̃auano ka aiel avarkorov yati na Yimo Lu nei. ");
INSERT INTO bki_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ana naio berlogloglo, berinavo “?Jum̃abe, kamiu maka kuvijikia ka Atua berial ea kiano Iliano Lu, ber ‘Mia nalo aver kiaku Yimo Lu naio be yimo na volkouano na taara nonovio na tomu nalo na yetemeriba reraio’? ‘A mia kamiu kumitu kubilig Yimo Lu nei ruei ka rimei tibe buluvae tai na vinauano.’ ” ");
INSERT INTO bki_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana maka vesiou tomu nalo na tortoru na kulo lu bija naverloglogiano nalo na tuboiano, amijog venia na Yesu naio mila ruei ea Atua Kunuano Lu, mia nalo tiniel mimi laka, nalo ajidom ala titai kanio. Mia nalo amerou laka ka Yesu, nalo maka bunu ala, bior nalo abitilubar ka tomu nalo ajidom laka ka naio, nalo aju amiilo ka kiano verloglogiano novo nalo. ");
INSERT INTO bki_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mia ka bogo na m̃erenio jo batove ruei, Yesu nalo ajaluvo Yerusalemo bereio. ");
INSERT INTO bki_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mia kavijo, nalo aju amiel abano Yerusalemo bereio, ana amial bereio buruviki napano beamu na, ana nalo amial ka vonganei m̃ati nalo mekekeu biniu ruei. ");
INSERT INTO bki_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ana Pitere naio jidomii bereio Yesu kiano iliano, ana naio ber ka naio, berinavo “Tubo, jau keial vo! Buruviki nei napano jau komil banio niovo, vonganei naio binimei mekekeu nonovio ruei!” ");
INSERT INTO bki_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ana Yesu berdop̃eio, ber kalo, berinavo “Kamiu monoka kuvitu sikili vija Atua. ");
INSERT INTO bki_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kiniou neber be riano ban kamiu, ver toro kei na maka kiano jidomiano veve juo, a monea kirisikili, ana venia na naio berenio, mia monoka tibe na ga. Verver naio ril van burusuku na toru nei, river kanio riverinavo ‘Jau kavatove koviako ea tei,’ nina, mia monoka tibe na ga. ");
INSERT INTO bki_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nina naruei kiniou neber ka kamiu, ka venia na kamiu kumitu kubika ea kenemiu volkouano, verver jau komonea sikili ka tena be kiamo ruei, bo, mia monoka tibe na ga naruei. ");
INSERT INTO bki_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","A ea bogo nonovio na kamiu kuvisidomii ka kubolkouo, kamiu monoka tiniemiu maio ka bunu, ka ver titai joaso bija toro dolu, monoka koviekokoa beamu, karina jau komijikia kotumolu koverialio ea kiamo volkouano nene van Atua. Verver jau kala tibena, mia Karam̃ado na tiniabene, naio bunu mia sidomii ka riviekokoaso ka kiamo vovaiano nalo.” ");
INSERT INTO bki_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ana Yesu nalo amiel abinimei abokar bereio Yerusalemo, ana nalo aba jouro ea burusio na Atua Kunuano Lu bereio. Ana bogo napano nalo aju amiel jouro, tomu nalo na tortoru na kulo lu nalo, bija tomu na verloglogiano na tuboiano, bija tomu na vurim̃araboiano na kulo Ju kialo, nalo abinimei ea naio. ");
INSERT INTO bki_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nalo abika naio, aberinavo “?Jau kojo komila jibena ea vio nei ea kei siano? P̃eli kei bereio na berii kaso ka jau kala tibena?” ");
INSERT INTO bki_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ana Yesu naio ber kalo, berinavo “Bo ga, a kiniou bunu nojidom nevika vikadeniano tai van kamiu beamu. Verver kamiu kuverdop̃e kiaku vikadeniano nei rivu, mia kiniou neverial van kamiu jum̃abe ana kiniou nemijikia nemila jibe nei. ");
INSERT INTO bki_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bo ga, kiaku vikadeniano naio jibe nei naruei, berinavo ?Baruei nei na Jone naio mila von nua bogobe ka tomu nalo, naio be titai na Atua ber ka Jone ka naio rilaio, p̃eli tomu nalo ga nalo aber ka naio? Kamiu kuvilavon ka kuverdop̃e kiaku vikadeniano nei.” ");
INSERT INTO bki_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mia Yesu kiano vikadeniano nei naio mila nalo abilvili ealo bereio, nina nalo aju aberinavo “?Mia kito rover tum̃abe ka naio? !Rovitikar batitig kito nei! Verver kito rover varueiano nene Atua naio ber ka Jone, mia toro na monoka rivika den kito river ka venia na kito maka romonea Jone. ");
INSERT INTO bki_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ana kito maka rejikia rover bereio Jone kiano varueiano nene naio miyotuba ea tomu nalo kialo jidomiano ga, ka ver maka mia tomu nalo tiniel ser kito!” Tomu nalo na tortoru nei nalo amerou ka aver iliano nei, ka nalo amijikia ka tomu nalo aju amonea Jone jikil ruei ka naio be Atua kiano naverialiano tai na be riano. ");
INSERT INTO bki_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ana kialo jidomiano nalo jibe nei mila nalo aberdop̃e Yesu jibe nei ga, nalo aber ga “Kumemi maka nuvijikiaio.” Ana Yesu ber ka nalo neibano, berinavo “Jum̃abe, mia kiniou bunu, kiniou maka nejikia nover ka kamiu kei naruei naio ber ka kiniou ka nala im̃auano nalo nei.” ");
INSERT INTO bki_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mia bogo na Yesu naio jo berlogloglo, naio jo berii jamerijiano banlo bogo nonovio. Jamerijiano tai naio ber jibe nei, naio berii toro na toru tai, bija kiano jiotilikrevi tai. Toro nene naio mim̃auka vatitig ka kiano vio nene, naio mila burusio tai jikili jeriko tivelinio nalo biniu, ana naio mila vio tai ka rivie bulag vati m̃arkrevi, a naio mila bunu kanano burutili vio tai ka avoio avavin atu mave eaio ka asiraragkuku ka jiotilikrevi nei. Mia bogo tai, toro na toru nei naio jidom riel kiki kija rivan ea buruvenuo dolu nalo, ana naio juvan kanano jiotilikrevi nei ban kulo dolu nalo tealo, ka nalo amei aim̃au eaio, nalo avuluio van naio. ");
INSERT INTO bki_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Naruei toro na toru nei naio ba jo laka-o, karina naio mial ka vonganei be bogo na m̃ariesi nalo ameruo naruei. Ana naio miila kiano toro tai ban bereio, ka rivar veru na m̃arati krevi nene togio ve kiano, nina monoka avario van naio. ");
INSERT INTO bki_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ana bogo napano naio ba miyotuba kean nalo nei, nalo amue niegeniege naio bova laka, ana nalo amijil deven naio ban bereio naruei naio maka rivar titai leleio. ");
INSERT INTO bki_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mia tubo nei naio miila kiano toro dolu bano, mia nalo nei amueio, bar ja ea parinio, nalo amila bova toru banio bano-o nalo amijil lar naio ban bereio. ");
INSERT INTO bki_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Karina naio miila bereio tai, nalo amuebinio m̃aro, a iorou kanio naio miila kiano tomu nalo miroano nalo abano, a nalo aju ajukulo a amuelo bunu nalo am̃arm̃aro ga. ");
INSERT INTO bki_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Naruei toro na toru nei naio mial ka toro ga takurano naio jo naruei, nina be kenerinio memedu na naio tinien jii m̃elea naio, ana naio jidomii banbano na berenio “Vonganei, monoka neiila keneriku ga naio rivano, mia nalo monoka avamenea naio.” ");
INSERT INTO bki_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ana bogo na kulo va nalo nei amial toro na toru nei kenerinio binimei, nalo aju aberverii kalo, aberinavo ‘Nina be toro na toru kenerinio na. Toro na naruei, napano verver toro na toru rivakovio, mia naio naruei rudu tanobuku nei tibe kanano jajum̃ano. Bo ka rouebin bunu naio rim̃aro, ka mia kito ga rojikia rovokar tanobuku nene ve kiado.’ ");
INSERT INTO bki_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tibe na naruei, nalo aba abokakar naio kirisikili, nalo amuebinio, ana nalo abukuio batavio ea jiotilikrevi nene.” ");
INSERT INTO bki_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Naruei Yesu naio bika denlo, berinavo “?Bogo na toro na toru na jiotilikrevi nene mia naio rimei bereio, mia naio rila tum̃abe ka nalo na aju amim̃au ea kanano jiotilikrevi? Tomu nalo bova nei, mia naio rimei ruebinvin nalo am̃arm̃aro ea bajago tai na jikili, a mia naio rudu kiano jiotilikrevi rivan kulo dolu na bo.” ");
INSERT INTO bki_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Naruei Yesu ber kalo, berinavo “Iliano tai ea Atua kiano Iliano Lu napano naio ber jibe nei, berinavo Veru na, tomu nalo na amim̃auka yimo aberinavo naio bova, ana nalo abuku ban ruei, mia vonganei veru nene binimei be veru tai napano bo ka toa sudu na yimo, ka naio rivokar yimo sikili. ");
INSERT INTO bki_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tena, Atua ga naio mila, a kumemi numial jibe ka bo mia bo.” “?Ana jum̃abe naruei, iliano na kamiu kumijikia ruei, a p̃eli kamiu maka kuvulukuio kija bogo tai?” ");
INSERT INTO bki_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mia bogo na Yesu berii jamerijiano nei bisi, mia nalo na tortoru abitilubar ka naio ber iliano na jibe na ka kialo bajago, ana nalo tiniel mimi, mila nalo aju ajidom alavon ka avokar naio sikili to, karina nalo amial tomu miroano laka, ana nalo amerou kalo, ana nalo ajuvan naio jo, nalo aju koalabo den naio ga. ");
INSERT INTO bki_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mia tomu nalo na tortoru aba abitii tenei, mia nalo amiila Varisis tealo bija Erot kiano burukuti tealo abinimei, ka alavon ka avika vikadeniano tealo na jikirkili ka alavon Yesu kanio, napano mia naio maka rijikia ka riverdop̃eio. ");
INSERT INTO bki_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mia nalo abinimei ea Yesu, amila sibilili naio ka iliano novo nalo, nalo aberii “Naverloglogiano, kumemi numijikia ka jau kobe riano garuei. A jau, jau maka koto komerou ka toro, ka toro na jo loa nalo dolu p̃eli toro na toru p̃eli na jum̃abe, a jau kojo koberial memedu Atua kiano m̃arabo ka tomu nalo abiniu. Mia kumemi numisidom nuvika denso tibenei, kiado tuboiano naio ber jum̃abe? ?Naio berii memedu ka kito kulo Ju rovulu takis van Parinio Tubo Sisa nei na Romo, p̃eli naio ber maka rimemedu? ");
INSERT INTO bki_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bo ka rovulu takis nalo p̃eli na makanio?” Ana Yesu naio mijikia ka aju abivika sibisibi ga, nalo ajidom ala bulag naio ga, ana naio berkalo, berinavo “?Ee, kamiu kumitu kumisidom kuvilavon kiniou tibe na ka vaio? Bo, kuvidu veru tai rimei ka nevitiio.” ");
INSERT INTO bki_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ana nalo amidu tai binimei banio, ana naio bika denlo, berinavo “?Mirano toro kei nei joa veru na teliki nei? ?A sio na abivitauia joaio, naio be toro kei siano?” Nalo aberenio “Parinio Tubo Sisa mirano na, a siano bunu.” ");
INSERT INTO bki_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ana naio ber kalo berinavo “Bo ga, vite na be Sisa kiano, kamiu monoka kuvar van Sisa, a vite na be Atua kiano, kamiu monoka kuvar van Atua.” Mia bogo na amijog verdop̃eiano nene, nalo amiilo va laka. ");
INSERT INTO bki_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mia iorou kanio, ana Satusis tealo abinimei ea Yesu, napano nalo ajidom avika den naio tivelinio na vite tai napano nalo amonea kirisikili eaio, napano tomu nalo na am̃arm̃aro, nalo maka bunu ajikia ameul bereio ea bogoti na maaro. Nina naruei nalo abika den Yesu, nalo aberinavo ");
INSERT INTO bki_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Naverloglogiano, kumemi numi-sidom nuvika denso, ka jum̃abe ka iliano tai na tormoruo Mosis naio bivitauia be kiado beamu nua. Naio berinavo ver toro tai, kuruano naio m̃aro den koano tira, na nalo maka ve kenerilo tai vo, mia toro na monoka rivuru taanou nene ve koano. Ana verver tira nei rivar tete, nalo amijikia asisia naio takii karam̃ano na m̃aro ruei, ka siano rimeul to. ");
INSERT INTO bki_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mia ea bogo tai, tomu aluo na abe kurualo. Nana beamu laka kalo naio buru koano tai, a mia naio m̃aro den koano napano naljuo maka avar kiritete tai vo. ");
INSERT INTO bki_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Karina kurualo juo nene naio buru tira neibano, karina naio bunu m̃aro denio, na maka ve kenerinio, a iorou kurualo tolu nene naio bunu mila jibe na, ");
INSERT INTO bki_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","banbano-o bokar kurualo aluo nene, nalo nonovio amila jibe na ga, nalo am̃arm̃aro den tira nene. A iorou ka koano sum̃ano nalo nei napano abiniu am̃arm̃aro ruei jibe na, tira nene naio bunu m̃aro. ");
INSERT INTO bki_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mia jau kover von tenei? Ea legiano na maaro, bogo na mia atu aver ka mia tomu nalo amemeul bereio, mia tira neibano ve kei koano, ka napano naio joro ka tomu aluo napano abe kurualo ruei?” ");
INSERT INTO bki_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mia Yesu naio berinavo “Makanio, kenemiu jidomiano na naio ba kirivova laka. ?A p̃eli kamiu maka kuvijikia venia mila kenemiu jidomiano bova jibe na, a? Nina ka maka kuvijikia venia na Atua kiano iliano lu berenio, a kamiu maka kuvijikia venia bunu kiano moroano na toru rijikia rilaio. ");
INSERT INTO bki_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bogo na tomu nalo amemeul bereio, mia nalo atibe ka nailiano nalo na tiniabene ga, ana mia nalo maka bunu ala tenei soriano. ");
INSERT INTO bki_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A ea tivelinio na ameul bereio nei, kiano iliano jo ruei ea niosi na Mosis bivitauia, napano naio berii iesi na teliki napano sebi jijenio, na Atua mil ban Mosis, berinavo ‘Epraamo, Aisak, a Yakovo, kiniou nebe kialo Atua.’ “?Vede kamiu maka kuvuluku iliano nei kija bogo tai, ");
INSERT INTO bki_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ana mia kiniou never bisivisii van kamiu ka rivuririi kenemiu jidomiano nalo. Nalo tolu nei am̃arm̃aro ea yetemeriba nei bogo be nua ruei, mia yuka telabo barlaka ruei karina Atua naio ber vonga iliano nei, ber naio be kialo Atua. Tibena, kanano iliano nei berenio nalo tolu nei am̃arm̃aro ea yetemeriba nei, mia nalo aju ameul ea naio kiano vo. Atua naio maka sidom ka kiano tomu nalo ave tomu nalo na am̃arm̃aro ga, mia naio jidom ka rive Atua ka tomu nalo napano amemeul.” ");
INSERT INTO bki_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Naruei naverloglogiano na tuboiano nalo tai binimei jikili ju bunu ka bogo nei, mia naio jom̃a mije tiliniene ka napano Satusis nalo ajum̃a ajidom ka alavon Yesu, mia Yesu naio jom̃a juvululo ea kiano verdop̃eiano novo nalo. Naruei naverloglogiano nei naio be tiniene ka naio kija, mia naio bika den Yesu, berinavo “?Ea kiado tuboiano nalo, nana vabe nene naio bo lie loa laka juvulu nalo dolu nalo?” ");
INSERT INTO bki_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Naruei Yesu berkanio, berinavo “Iliano Lu naio ber jibenei, berinavo ‘Tomu nalo na Israel, kamiu kumije tiliniemiu. Atua Sop̃i, kiado Atua, naio takurano be Atua Sop̃i. ");
INSERT INTO bki_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Atua Sop̃i napano be kiamo Atua, jau monoka tiniemo tii naio ka kiamo iviso momou, ka kiamo meuliano momou, ka kiamo jidomiano momou, a ka kiamo moroano momou.’ ");
INSERT INTO bki_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Nina naruei naio be moti, a juo nene, naio ber jibe nei, berinavo ‘Jau tiniemo tii nalo napano aju vaataro kaso, jau kovijuku rivu kalo, tavukia napano kojom̃a tiniemo jiiso.’ “Mia maka bunu ve tuboiano dolu tai bereio napano naio loa laka ka juo nei.” ");
INSERT INTO bki_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Naruei naverloglogiano na tuboiano nei naio berdop̃e, berinavo “Riano ga naverloglogiano, jau kober memedu ga. Jau kober be riano, ka Toro na Toru naio takurano ga, maka ve dolu tai. ");
INSERT INTO bki_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Mia jau kober be riano bunu, ka kiniou monoka tinieku tii naio vija tinieku momou, a vija kiaku jikiaiano momou, a vija kiaku moroano momou, a kiniou monoka tinieku tii nalo napano m̃a aju vaataro ka kiniou, tavukia napano tinieku jii kiniou kiniou takurano. Be riano na, ea Atua kiano vitiiano, ver kito rala tibe na, nina naio jo mave laka, naio bo laka ka sida nalo napano m̃a kito roju romilaio ea Kunuano Lu.” ");
INSERT INTO bki_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mia Yesu mijog kiano verdop̃eiano naio bo, naio be masou, naruei naio berkanio, berinavo “Kiniou neber kaso, neberinavo, jau kojo vaataro ruei, ka mia jau kava jouro ea Atua kiano navenatuboiano navo.” Ana mia iorou ka bogo na, maka bunu toro tai rila vonvon Yesu ea vikadeniano bereio. ");
INSERT INTO bki_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ana iorou, Yesu jom̃a berloglog tomu nalo joomo ea Atua Kunuano Lu, karina naio kija bika vikadeniano tai denlo. Naio bika, berenio “?Kiniou nomijikia ka naverloglogiano na tuboiano ajum̃a aberloglog kamiu, mia kiniou nojidom novika ka bior vaio ana ajum̃a aberenio Naverikariano naio monoka riyotuba ea tormoruo Teviti nei kiano yati, napano naio be Parinio Tubo beamu. ");
INSERT INTO bki_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiniou nebika nina, bior napano beamu, Niununo Lu naio binimei ea Teviti, mila na naio mil berinavo ‘Atua Sop̃i naio ber ka kanaku Tubo, berinavo “Jau kototano tivelinio vameruo na kiniou, jau kotororea rivano-o mia kiniou novuru kanamo uolu nalo amei ave m̃adayebe tai tena kovijankon jaamo eaio.” ’ ");
INSERT INTO bki_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ea vio na kito romialio ka napano Teviti naio jom̃a bio Naverikariano nei naio be kiano Tubo ruei. Naruei bior Teviti naio ber jibena, jum̃abe ana ajum̃a aberinavo mia Naverikariano nene mia naio riyotuba ea Teviti, be kiano yati ga?” Mia burum̃ara tiniobi napano aju ka bogo na, ajidom m̃elea verloglogiano na jibe ka Yesu kanano, nalo amije tilinielo toru laka eaio. ");
INSERT INTO bki_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mia bogo napano Yesu jom̃a berlogloglo, naio jo jokol bunu bajago na m̃arouano na kialo navuri-m̃araboiano. Naio berinavo “Kamiu kuvitikar kamiu ka naverloglogiano na tuboiano nalo. Nalo abarvar kalo m̃elea ka kialo burutili kulum̃arauo nalo na, mia verenio amiel ea vio na vioruru, nalo ajidom ka tomu nalo monoka avatove kalo, a avio batitiglo aver ‘Naverloglogiano, kavijo bo!’ ");
INSERT INTO bki_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","A ea bogo na jokoluolu a joomo ea yimo na volkouano bunu nalo ajidom dam̃ariga nalo atutano ea vio na tomu na tortoru jelelo ga. ?Kamiu kubitilubarlo ruei, a? ");
INSERT INTO bki_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","A ajum̃a aburii kialo volkouano terebievi laka, mia ajum̃a amila sibi ga, bior bogo nene kia ga, nalo ajum̃a amijukujuku taanou nalo ka amijikia avina ka kialo saba nalo. Naruei bior kialo bajago nalo na, mia kialo mauo nene mia naio sikili lie vo.” ");
INSERT INTO bki_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Naruei iorou kanio, Yesu mijian naio ba jotano vaataro ka vio nam̃a abuku ijaiano na Yimo Lu nei, mia naio bilig pariparinio bitivitii tomu nalo nam̃a ajuvan kialo ijaiano. Naruei naio mial tomu telabo napano abe sanibaiano, nalo abar kialo burum̃ara ijaiano nalo abinimei, ajuvanio. ");
INSERT INTO bki_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mia karina naio mial bunu ka napano tiramoruo tai naio binimei, naio be taanou ga tai, a naio be talim̃asa laka. Naruei naio bar veru sesa subaier juo binimei naio jian ban Atua. ");
INSERT INTO bki_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Naruei Yesu bio kiano naiaga-goano nalo ka amei ea naio, naruei naio mil banlo, naio berinavo “Kamiu kumial tiramoruo na, napano naio juvan veru sesa juo na? Kiniou neber be riano ka kamiu, ka naio jian loa, naio jovulu ijaiano dolu nalo nonovio napano na sanibaiano nalo ajuvanio. ");
INSERT INTO bki_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nalo na, be kialo burum̃ara puruveru nalo, mia amije bena ga torogio nene, mia taanou nei, kiriveru teliki na naio bokar jo ka mia rijai kiano meuliano, naio jian nonovio ban Atua.” ");
INSERT INTO bki_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mia Yesu naio jaluvo den Atua Kunuano Lu, mia bogo napano naio jom̃a miel bano, naiagagoano nalo tai naio jiloglog burum̃ara yimo nalo na Yimo Lu nei, ana berinavo “Naverloglogiano, jau keialio! Yimo nalo na bija salo puruveru nene nalo romial lo amieg kirinovo laka, a!” ");
INSERT INTO bki_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ana Yesu berkanio, berinavo “?Jau komial yimo nalo na tortoru na? Mia iorou kanio mia ve re salo puruveru nene nalo atu batitig ea jeleigio, bior mia tomu tai, mia amei auebulag lelan nonovio yimo nalo na aviniu.” ");
INSERT INTO bki_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ajum̃a amiel jibe na, abinimei ea Suku na Buruolivi Nalo, nina naio jo jirarago ban ea Yimo Lu, ana Yesu naio jotano ea vio na. Ka bogo napano maka ve kulo dolu nalo atu, a naiagagoano ver abinimei ea naio, nina be Pitere, Yemesi, Jone a Andru. Naruei nalo abika denio, aberinavo ");
INSERT INTO bki_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“?Mia auebulag Yimo Lu na nagi, a venia naruei mia naio rila vite nalo nei monoka amalmaluvo?” ");
INSERT INTO bki_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ana Yesu mil banlo naruei, naio berdop̃e, berinavo “Bo ka kamiu kuvitikar vatitig kamiu rivu, ka mia ve re toro tai rimei rila sibilili kamiu, ");
INSERT INTO bki_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","bior mia tomu ve telabo napano mia adu siaku, ana mia amei averinavo ‘Kiniou nobe Naverikariano nene,’ naruei mia avuru tomu ve telabo aiel vovu. ");
INSERT INTO bki_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ana ver ea bogo na, mia kamiu kuvijog uetubaiano na mira naio jo binimei vaataro, p̃eli na kamiu kuvijog lilianiano na burum̃ara mira nalo napano m̃a aju koalabo, mia kamiu kumemebiju m̃elea re. Vite nalo nei monoka amalmaluvo beamu vo, mia nina maka ve legiano na maaro nene navo. ");
INSERT INTO bki_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A mia parinio tubo nalo, mia ala mira ka parinio tubo dolu nalo, mia buruvenuo nalo mia atumolu ka buruvenuo dolu. Mia vio reraio ea yetemeriba nei, mia m̃ii rikulkulu ve toru, a mia ve burum̃ara bogo na vitu bunu, mia vite nalo na, maka ve Legiano na Maaro nene navo. Vite nalo na naio jibe ka ga napano tira napano m̃abono, naio mijog dovorovo ka taakano mijalele garuei be moti ka rudu kenerinio, mia burum̃ara jaleleano nei naio maka navo. ");
INSERT INTO bki_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“A kamiu monoka kuvitikar vatitig kamiu rivu, bior ka napano tomu nalo mia avuru kamiu ea komeli nalo p̃eli ea kialo yimo na volkouano ka mia ail van kamiu, naruei mia atibure kamiu p̃eli mia avitiv kamiu. Mia monoka avuru kamiu kuva kuvitu kamu ea mirano tomu na tortoru na buruvenuo nalo rivior ga kamiu kube kiaku naiagagoano, ana ea bogo na kamiu kumijikia kuverial kenemiu moneano ea kiniou kamu ka miralo. ");
INSERT INTO bki_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ana Ioluano Vou, mia aioliolu kanio van taara nalo na tomu nalo na yetemeriba nei beamu vo, karina mia vite nalo nei amijikia amalmaluvo. ");
INSERT INTO bki_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ver nalo amei avokakar kamiu, ka avuru kamiu kuvan ka atibure kamiu, mia kamiu kuvisidomii bijovijon re laka, verenio ‘?Mia kiniou never vaio vanlo?’ Mia kamiu kuverial ga iliano vaio napano mia Niununo Lu naio sian rivan kamiu, rimonloglog bogo napano mia kamiu monoka kuvil, bior ka napano mia ve re kamiu napano kuvil, mia naio rive Niununo Lu napano mia naio ril moluo ea kamiu. ");
INSERT INTO bki_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ea bogokouo na, mia toro mijikia rijamo ka tom na bova dolu nalo nei amei avuru bulag kuruano rimemedu p̃eli na kenerinio memedu, ka auebinvinlo am̃arm̃aro, nina kar ga napano amonea kiniou. A mia kiritete nalo amijikia atumolu bunu ka averial keniele nalo a karam̃alo nalo napano amonea kiniou, ka am̃arm̃aro bunu tibe na. ");
INSERT INTO bki_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mia tomu nalo aserm̃i m̃elea ka kamiu napano siaku joa kamiu, mia kamiu kei napano naio tumolu tu sikili riva rivokar juluvati na bogokouo nei, mia Atua rilarurio.” ");
INSERT INTO bki_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ana Yesu naio ber iliano dolu tai bunu, napano naio bo ka ver toro napano naio rivuluku, rilavon ka rijikia vatitig nioti nene. Iliano nei naio ber jibe nei, berinavo “Mia kamiu kuvial ka napano mia avitirilar tavoru tai napano kirivova mia kirivova laka, naio tumolu toa vio lu tai napano maka rimemedu ka toaio. A bogo na kamiu kuvial vite nei, kamiu napano kumitu Yutea, bo ka kamiu kuvuro bilig, kamiu kuva kuvitoluku ea burusuku nalo. ");
INSERT INTO bki_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ea bogo na, ver toro tai to rijilmebi tavio ea kunuano, naio monoka riva joomo re bereio ka rivar kanano saba tai, ");
INSERT INTO bki_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","p̃eli ver toro tai toa kanano tiniavio, mia naio monoka rivan re bunu ea kunuano ka rivar kanano kulum̃arauo, mia naio monoka rivuro sop̃eli tibe na ga rivano. ");
INSERT INTO bki_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka bogo na, mia rivova laka bunu rivan nena nalo napano abe m̃abolo, vija nalo nam̃a amije yu ban kenerilo solbouo nalo. ");
INSERT INTO bki_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ver tibe na, bo ka kamiu kubolkouo rivior kamiu, ka bogo na kenemiu vuroiano nei ka mia naio rivokar re kamiu ea bogo na burum̃ara niavo. ");
INSERT INTO bki_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nina bior ka napano bogo na, mia sikili mia sikili, sikili lie tovulu bogokouo dolu nalo, napano jikar ea bogo na Atua naio jii yetemeriba nei binimei bokar banei, a mia ve re bunu burum̃ara bogokouo na toru tai tibe nei bereio bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mia Atua jidomii ruei ka mia naio tekor bogokouo nei ve bulati ga, bior kanano tomu nalo napano naio bijauia bulaglo ka ave kanano ajua bogo nei. Ver naio tekoro re ve bulati tibe na, mia ve re toro tai rijikia rimeul to. ");
INSERT INTO bki_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mia ver tomu nalo averver ka kamiu ka bogo nei, averinavo ‘Kamiu kumial toro yako, nina be Naverikariano na,’ p̃eli na ver averii toro dolu, averinavo ‘Naio be Naverikariano na niako laka,’ mia kamiu kumonea re kialo iliano nalo na. ");
INSERT INTO bki_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Naverikariano telabo napano maka ave riano amijikia atumormolu, vija bunu naverialiano na sibisibiano, mia nalo na amijikia ala jamerijiano nalo, vija vite nalo na memebijuiano. Mia nalo ala tibe na, ana mia avuru tomu nalo ave vovu, riva rivokar napano mia alavon ka avuru bunu Atua kiano tomu nalo napano bijauia bulaglo ka ave kiano, mia vite nei mia maka ajikia alaio ga. ");
INSERT INTO bki_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mia kamiu kumijikia kuvitikar vatitigio, bior napano kiniou neberial vite nalo nei ka kamiu vonganei ruei, napano maka amalmaluvo vo.” ");
INSERT INTO bki_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ana Yesu berinavo “Naruei ea bogo na, iorou ka napano jaleleano nalo nei ribisi, mia m̃erenio rimei ribobogio, a mia siberio rimermera re bunu. ");
INSERT INTO bki_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","M̃arvitano nalo ea bul niogovu mia atibirbili, a moroano na vio yauo, mia Atua rikulkulu kalo. ");
INSERT INTO bki_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Naruei ea bogo na, mia aial Kulorinio Kenerinio rimaluvo ea melijo vija kiano burum̃ara moroano a vija kiano burum̃ara mermerano. ");
INSERT INTO bki_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Avona bisi, mia naio riila kiano nailiano nalo aseliviv ea vio reraio yetemeriba a tiniabene, a mia avuru kiano tomu nalo napano naio bijauia bulaglo ruei, nalo amei vio takurano ea naio.” ");
INSERT INTO bki_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ana Yesu berenio, berinavo “Kamiu kuvisidomii von buruiesi nei, napano aber buruviki. Naio be kiano titai ka verloglog ka kamiu, napano kamiu monoka kuvitii vatitig eaio. Bogo na kamiu kumial ka sudoti vou nalo aju amiluo, aju abinimei amemeaio, ana kumijikia ka bogo na inio ve toru jo binimei vaataro. ");
INSERT INTO bki_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tibe na, bogo na kuvial jamerijiano nalo na ea yetemeriba, nalo aju amalmaluvo jibe ka napano kiniou neber ka kamiu ruei, mia kamiu kumijikia ka Kulorinio Kenerinio jikili jua m̃aratavo ruei, vaataro ka riyotuba naruei. ");
INSERT INTO bki_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Riano, kiniou neber ka kamiu, mia tenalo na mia amaluvo beamu, ana iorou, tarati na tomu nalo napano ameulial bogo na amijikia am̃arm̃aro ea yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ana mia buluniogovu vija yetemeriba nei, naljuo avakovio bunu, mia kiaku iliano nalo maka ajikia avakovio bogo tai. ");
INSERT INTO bki_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mia maka toro tai napano mijikia bogoti na p̃eli aura nene napano mia Kulorinio Kenerinio rimei bere eaio. Nailiano nalo na tiniabene, bija Atua kenerinio, nalo maka ajikia, mia Karam̃aku, naio takurano ga mijikia.” ");
INSERT INTO bki_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naruei Yesu berenio, berinavo “Tibe na, kamiu monoka kuvitu kuvitikar vatitigio rivu, bior kamiu maka kumijikia ka legiano na vabe naruei mia kenemiu Tubo rimei bere eaio. ");
INSERT INTO bki_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Vite na naio jibe ka napano toro na toru tai juvan kiano vonuo ka riva rudu kiano burum̃ara ieliano tai. Beamu ka naio taluvo ea kanano vio, mia naio juvan kiano saba nonovio jua kiano tomu na im̃auano nalo jum̃alo, ka avitikar kiano im̃auano nalo, a mia ril vatitig van nalo napano abe nakukuano ea kiano morouo, ka monoka avitikar rivu. ");
INSERT INTO bki_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Vonganei, jibe na bunu ban kamiu, naruei mia kamiu bunu monoka kuvitu kumisirarag kuku rivu, bior kito maka rejikia ka mia toro na toru na vonuo mia naio rimei nagi. Vede naio rimei ka niogoravo, vede ka bogiano, vede ka bogo na tu riolu, vede kavijo va, ");
INSERT INTO bki_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","mia maka rivu ka ver naio rimaluvo kean kamiu, ana rial napano kamiu kumitu kumonmelio ga. ");
INSERT INTO bki_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Naruei iliano nei napano kiniou naber ka kamiu, naio memedu ga ka tomu nalo aviniu monoka ajogio, napano berio kamiu kuvitikar rivu, kamiu kuvitikar kamiu rivu.” ");
INSERT INTO bki_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Naruei, bogo binimei vaataro ka yuka nonovio nalo ajum̃a amila kialo jokoluolu juo na tortoru. Bogoti juo ju kia vo, ka mia aim̃auka jokoluolu na sidomkariano na ioruriano tukamu, ana kario na aim̃auka ka jokoluolu na asen beskit na jikili. Mia ea bogo nene, tomu na tortoru nalo na kulo lu kialo bija naverloglogiano nalo na tuboiano, ajum̃a ajidom kea auebin Yesu. Aju kea amilavon ka asirag m̃arabo tai ka mia avokarvan ga naio. ");
INSERT INTO bki_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mia nalo ajum̃a aberii banlo bereio, aberinavo “Vite na, kito maka rojikia roim̃auka ea tomu nalo miralo napano abinimei ea jokoluolu nei, ver p̃eli mia nalo tiniel ser tanea kito kanio, mia ala burum̃ara uetubaiano na, bior napano nalo telabo ajum̃a ajidom kema nei laka ruei.” ");
INSERT INTO bki_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mia ka bogo nene, Yesu joa m̃arkomeli na Betani, naio ba jo miadu ka toro nei napano ajisia ka Saimon Burumieni, napano nanua beamu naio bokar burumieni ea niabene. Mia Yesu jo jinano ea vio na, tira tai binimei eaio napano naio midu bauei tai na amim̃auka ea puruveru na kirinovo tai, mia bauei neibano naio bujo ka m̃aatei na kirinovo tai napano amim̃aukanio ea uei na baiesi na buruiesi tai, napano puruveru nene toru laka garuei. Mia tira neibano naio mijukonlar tiniu na bauei neibano, ana miyon nonovio m̃aatei nene ea Yesu parinio. ");
INSERT INTO bki_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mia nalo tealo napano ajua vio neibano amial tenei, mia nalo tiniel jer tira neibano, aju amil mum̃ii kanio ban berelo, aberinavo “?Ka venia na tira na miyon bulag kule m̃aatei na bo nei jibe na? ");
INSERT INTO bki_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A ver naio rivulvulu kanio ga, mia naio rivar burum̃ara puruveru tai, ana naio mijikia rivar puruveru nene ka rijai talim̃asa nalo. Mila bulagio ga na!” Ana ajum̃a amil niegeniege tira neibano jibe na. ");
INSERT INTO bki_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mia Yesu ber kalo berinavo “?E, kamiu kumila jibe na ban tira na ka vaio? Kamiu kuvil niegeniege re naio tibe na, naio mila tonovo tai ban kiniou, milivu ka kiniou laka. ");
INSERT INTO bki_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Talim̃asa nalo nam̃a kumitu kuberiilo na, mia nalo bogo nonovio atu burukuti vija kamiu, ana kamiu kuvijikia kuvijailo bogo nonovio ea bogo ve telabo napano kamiu kumisidom. Ana kiniou, mia noto re bogo nonovio rivija kamiu na. ");
INSERT INTO bki_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tena, tira nei mim̃aukanio, napano naio miyon m̃aatei na ea kiniou, naio mila nonovio saba nalo na bo bo laka ga, napano naio mijikia rim̃aukanio, ka rijikia rila vatitig mokotenaku ka mia navan ea m̃ariano. ");
INSERT INTO bki_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kiniou neber be riano ban kamiu, ea vio nonovio ea vio yetemeriba reraio napano mia averial kiaku ioluano vou nabo eaio, mia nalo atukunu bunu ka vaio na tira nei naio mim̃aukanio, ka nalo asidomial bereio bogo nonovio tena tira nei kiano tinietiiano ban kiniou, napano naio tinien miia riano kiniou.” ");
INSERT INTO bki_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Naruei Jutas na Kariot, napano naio bunu be Yesu kiano naiagagoano duelimo ba juo 12 tai, naio jo jidomii ruei ka mia tiveluku ka Yesu, ana naio ba mial tomu nalo na tortoru na tomu lu nalo. ");
INSERT INTO bki_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mia bogo na nalo amijog ka mia naio rim̃aukanio m̃arabo ka nalo ajikia avokar lukua Yesu, nalo ajaaro laka, aberkar ban naio aberinavo “Naio bo laka na, a ver jau kajai kumemi tibe na, mia kumemi nuvisian ijaiano tai ve telisu rivanso riviorio.” Naruei jikar ea bogo nene, Jutas naio jo jiravo buluvio tai na mia naio riven Yesu rivan ea kulo lu nalo nei jum̃alo. ");
INSERT INTO bki_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Naruei ea legiano napano be moti na jokoluolu ka asen taba na, be Taste, a ea legiano nene ajum̃a amila sida ka nunu solbouo nalo ka sidomkariano na ioruriano. Naruei ea bogoti nei naiagagoano nalo abika den Yesu, aberinavo “?Jau kojidom ka mia kumemi nuva nuvila batitig sado sinaniano na jokoluolu nei ea vio vabe?” ");
INSERT INTO bki_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Mia naio ber kalo abe juo, berinavo “Kuve juo kuva jouro Yerusalemo, mia kamiu kuvial toro tai napano midu burum̃ara bauei tai, naio rimei riviviuo vija kamiu. Mia kuve juo kuvitakisor naio kuvano, ");
INSERT INTO bki_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ana mia naio rivuru kamiu kuvan ea yimo tai. Naruei bogo na kamiu kuve juo kuva joomo ea yimo nene, mo na kamiu kuvil van boru na yimo nene, kamiu kuverii tibe nei, kuverinavo ‘Kiado naverloglogiano naio bikanio, berenio vajoomo vabe na valauo nalo kialo, ka naio naliko kumemi kanano naiagagoano nalo, kumemi numijikia nuvisen sinaniano na sidomkariano na ioruriano eaio?’ ");
INSERT INTO bki_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Kuve juo kuvil tibe na vanio, ana mia naio siloglog burum̃ara vajoomo na yimo tai napano ea kotkoti na jo mave ka kamiu, napano vite nonovio jua ruei, ana mia kamiu kuve juo kuviomon vite nonovio na sinaniano nei ea vio nene.” ");
INSERT INTO bki_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mia Yesu ber jibe nei ka naiagagoano juo neibano bisi, ana nalo abe juo abano, nalo amiel aba abokar vio Yerusalemo. Mia ea bogo nene amial ka saba nalo nonovio amalmaluvo jibe ka ga napano Yesu berii kalo abe juo jukamu. Jibe na naruei, ana na naljuo amila batitig sinaniano na maariano na jokoluolu na Yesu kiano, karina abe juo aban bereio. ");
INSERT INTO bki_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Naruei ea bogiano, Yesu naliko kiano duelimo ba juo abinimei Yerusalemo, naruei nalo aban ea yimo neibano. ");
INSERT INTO bki_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Naruei bogo napano nalo ajum̃a ajinan, Yesu mil banlo, berinavo “Kiniou neber be riano ban kamiu, ka mia kamiu tai ga mia naio riṽilṽili bena ga ka kiniou, kamiu ga tai napano mia kumemi ve juo nuvisinan burukuti vonganei.” ");
INSERT INTO bki_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Naruei naiagagoano nalo amijog ka naio ber jibe na, mia nalo tinielo miia naio toru laka, ana na nalo ajum̃a abivika veve terakurano denio, aberinavo “?Koig, maka ve kiniou, a?” ");
INSERT INTO bki_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ana na Yesu berdop̃eio, berinavo “Nana mia naio rila tibe nei ka kiniou, naio be tai ga ea kiaku duelimo ba juo 12 nei ga, naio napano mia kumemi ve juo nuvititi ka sememi joko ea baju ve takurano ga. ");
INSERT INTO bki_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mia Kulorinio Kenerinio monokanio rim̃aro tibe ka na vivitauiano lu nalo aberii nua ruei, mia toro napano naio ṽilṽili bena ga ka naio, mia rivova laka van naio, bo laka verenio naio rimoluo re.” ");
INSERT INTO bki_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ana bogo napano nalo ajum̃a ajinan jibe na, Yesu midu joko tai, ber siva ban Atua kanio, ana burekokorovio bar banlo, ana ber kalo, berinavo “Kamiu kuvijevio kuvisenio, ninei naio be mokotenaku.” ");
INSERT INTO bki_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mia iorou kanio nina, Yesu midu baja na m̃arjum̃elm̃elu tai, ana naio ber siva ban Atua kanio, ana jian ban kiano naiagagoano nalo, mia nalo abeve terakurano abiniu amunu tertelisu eaio. ");
INSERT INTO bki_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ana naio ber kalo, berinavo “Ninei naio be kiaku burukija, ka rila Atua kiano virakariano tumolu tu sikili bogo nonovio, bior mia kiaku burukija nei naio riou ka sovoko tomu ve miroano kialo meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kiniou neberkar be riano ban kamiu, ka mia kiniou nomunu re m̃arjum̃elm̃elu na bereio rivano-o rivokar bogo na ga mia kiniou nomunu m̃arjum̃elm̃elu vou ea Atua kiano navenatuboiano.” ");
INSERT INTO bki_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mia bogo napano Yesu naio mila jibe na bisi, ana na nalo amiou ka iou tai napano joa niosi na Iouano nalo, avona bisi ana nalo abava tavio, aban ea Suku na Buruolivi Nalo. ");
INSERT INTO bki_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Naruei bogo na ajua burusuku nene, Yesu ber kalo berinavo “Banei bogiano na, kenemiu moneano ea kiniou mia rijoru, bior iliano lu naio ber ruei, berinavo ‘Mia kiniou nouebin toro na bitikar nunu, ka mia kiano nunu nalo mia avuro ave dedade tanea vio.’ ");
INSERT INTO bki_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ea iliano nei, Iliano Lu jo berii venia napano mia rimaluvo ea kiniou, mia bogo na kiniou nemeul bereio ea m̃ariano, mia kiniou notu-kamu nava Kalele, ana mia kamiu monokanio kumei iorou, kumei ea vio nene bunu ga.” ");
INSERT INTO bki_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naruei bogo na Pitere naio mijog ka Yesu ber jibe na ana naio mil ban Yesu, berial, ber “P̃eli kumemi tealo nonovio mia kialo moneano easo rijoru, mia nalo avuro denso, mia kiniou maka nejikia notuvanso bogo tai.” ");
INSERT INTO bki_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mia Yesu berkanio, berinavo “Bo Pitere, ka na jau kober jibe na, mia kiniou neber be riano ga banso neber ka mia bogiano na ga, mia tu tokokoreko ve valuo ga, ana mia jau kavarbonbonua kiniou rive varolu ruei.” ");
INSERT INTO bki_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mia Pitere naio mil joko vio ka iliano na, naio berkar iliano na kirisikili lie, berinavo “A ver nalo ajidom ka auebin kiniou vijaso, bo laka lie vo, mia kiniou, maka nejikia nalabonuaso ka never kiniou maka nove kiamo.” Ana bogo nene, naiagagoano dolu nalo bunu aber iliano nene bunu ga. ");
INSERT INTO bki_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mia iorou, Yesu nalo abarp̃iliglo ajel tivelinio ea suku neibano, abatove abokar bolu na telisu tai, aban ea vio tai siano Ketsemani. Ana naio ber kalo, berinavo “Kamiu kuvitu nei vo, mia kiniou nava nobolkouo ve telisu kija tukamu.” ");
INSERT INTO bki_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mia naio buru Pitere naljuo Yemesi naio Jone, nalo aban bija naio, ana nalo aban lie kija telisu ga, ana ea bogo na Yesu kiano iviso binimei temi laka, ana naio mijog naio bova laka. ");
INSERT INTO bki_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Naruei Yesu mil banlo abe tolu, berinavo “Vonganei namijog jibe ka niunuku burukorovio ruei, mila na kiniou vaataro ka nam̃aro kanio. Neber bo ban kamiu, kamiu kuvilavon ka kuvitevijo kuvitu vija kiniou ea vio nei kija ga vo.” ");
INSERT INTO bki_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ana Yesu naio miel ba lie kija ga, ana naio mijoru minie ana bolkouo ban karam̃ano, berinavo “Teta o, Teta o! Verver jau komijikia kajamo ga ka aura na jogvaiano nei naio rimei ea re bunu kiniou. ");
INSERT INTO bki_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jau komijikia komila vite nonovio, mia kiniou nobika denso ka jau kodular baja na jogvaiano den kiniou, ka mia kiniou nomunu eaio re. Mia jau kala re tibe ka na kiniou nejidom, mia be kiamo ga.” ");
INSERT INTO bki_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kario naio binimei bereio ea kiano naiagagoano tolu neibano ana naio mial amonmelio ruei, mia bogo na nalo ajevijo ana Yesu ber ka Pitere, berinavo “?Saimon jum̃abe na jau kojo komonmelio jibe na? ?Kamiu maka kuvijikia kuvitevijo kuvitu vija kiniou ka aura ve takurano ga? ");
INSERT INTO bki_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kamiu monokanio kuvitikar vatitigio, ka mia kamiu monokanio kubolkouo bogo nonovio, ka mia lavonvoniano nalo ala re kamiu kuvijoru ea kariano. Ee, kenemiu jidomiano nalo kirisikili vatitig, mia mokotenemiu nalo niabelo mave.” ");
INSERT INTO bki_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mia iorou kanio ana naio bano bereio ea vio napano, ana naio bolkouo bereio jaki kiano ilibolkouoiano napano jukamu. ");
INSERT INTO bki_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Naruei naio binimei bereio mial ka nalo tolu nei ajum̃a amonmelio bereio, bior miralo jouo tomi laka, a bogo na naio mil banlo, maka bunu ajikia averdop̃e titai bereio rivanio. ");
INSERT INTO bki_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mia naio ba bolkouo bereio, nainei be varolu nene, karina naio binimei bereio, mia naio mil banlo berinavo “E, kamiu kumitum̃a kumijilimebi kia ga vo, kamiu kumonmelio kia ga vo. Bo ga, bare naruei! Na vonganei vaataro ka bogo na Kulorinio Kenerinio naio rivan ea tomu va nalo jum̃alo naruei. ");
INSERT INTO bki_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ei, kamiu kuvitumolu, kito ravano. Toro na ṽilṽili bena ka kiniou, naio yako jo binimei vaataro.” ");
INSERT INTO bki_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Naruei monloglog bogo na Yesu naio jo ber kea iliano nalo nei kia navo, Jutas neibano be nalo duelimo ba juo 12 tai, naio binimei naliko tomu nalo miroano, napano nalo abar iobogu na mira nalo bija kialo nia nalo. Nalo na naruei, tomu nalo na tortoru na kulo lu nalo, bija naverloglogiano nalo na tuboiano, bija navurim̃araboiano nalo na kulo Ju nalo, nalo amiilalo abinimei. ");
INSERT INTO bki_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nua na maka amei vo tibe na, toro na jiveluku neibano Jutas, naio jii jamerijiano tai ruei kalo, napano naio berinavo “A ver toro na navan jum̃aku vija naio tukamu, toro nene naruei napano kito rojidomio, ana kenemiu tomu nalo na be p̃irilo monoka avokario avuru naio avano.” ");
INSERT INTO bki_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mia ka bogo na nalo abinimei naruei, Jutas naio miel ban memedu ka Yesu, naio berkanio, berinavo “Bogiano bo, Naverloglogiano.” Ana naio ban jum̃ano bijaio. ");
INSERT INTO bki_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ana kialo tomu nalo abinimei abokario kirisikili, nalo ajidom ka avuru naio rivano. ");
INSERT INTO bki_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nalo abakar naio jibe na naruei, ana naiagagoano nalo na ajua vio na nalo tai midular kiano iobogu na mira, jidom ka te toro tai na Parinio Kulo Lu kialo, naruei naio jeluvuio ana jelar ga burutiliniene tivelinio. ");
INSERT INTO bki_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Yesu mil ban tomu nalo neibano, berinavo “?Jum̃abe ana kamiu kubar kenemiu iobogu a kenemiu nia nalo? Bior venia ana kamiu kumisidom ka kumei kuvokar kiniou tibe na? P̃eli na kamiu kumitum̃a kumisidomii kuber kiniou nebe toro tai na be p̃iriku ka nevina bija nouebin toro? ");
INSERT INTO bki_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Julaka ea bogoti nonovio, kiniou nojom̃a neberloglog kamiu ea Atua kunuano lu ruei, ana ka venia ana kamiu maka kumei kuvokar kiniou ea bogo nalo nene? Mia bo ga na, bior vite nalo napano vivitauiano lu berenio nua bogobe ruei, monoka amei tibe na ga.” ");
INSERT INTO bki_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mia ea bogo nei, naiagagoano nalo ajuvan Yesu ana nalo aburo dedade denio. ");
INSERT INTO bki_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mia bogo nene, m̃eaku tai naio jom̃a jakisorilo, ana aburu Yesu bano ana m̃eaku neibano naio jukulou ga. Mia nalo tealo abitilubarbar naio, mia nalo ajidom ka avokar naio bunu ga, ");
INSERT INTO bki_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","naruei nalo abuluvu naio, nalo abokar ga kiano tukulou ana nalo aburu lario denio, naio buro jibe na ga napano be blamoma ga jo. ");
INSERT INTO bki_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Naruei nalo aburu Yesu binimei jikili jukamu ka Parinio Toro Lu, nina be Kaivas, ana tomu na tortoru nalo na kulo lu nalo, bija naverloglogiano nalo na tuboiano, bija navurim̃araboiano nalo na kulo Ju nalo, nalo abinimei vio takurano ea vio neibano bunu. ");
INSERT INTO bki_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mia Pitere bunu jom̃a jakisosor Yesu ea bogo nene, mia naio maka riva vaataro kanio, mia bogo na nalo abinimei jouro ea burusio na komeli neibano, Pitere naio ba jotano bija tomu nalo na amim̃au Kaivas kiano, napano nalo ajum̃a ajutano vaataro ka sebi, bior vio menini. ");
INSERT INTO bki_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Naruei tomu nalo na tortoru napano aju joomo ea vioriano neibano, nalo ajirag von tomu tealo ka aver vite nalo tai napano Yesu jom̃a mila p̃eli nam̃a naio jo berenio, ka nalo amijikia auebin naio riviorio, ana nalo maka aleal tai. ");
INSERT INTO bki_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nalo amileal tealo napano aburulo abinimei aberial iliano miroano, mia iliano nalo na abiniu ajum̃a amila sibi ga, mia nalo ajum̃a aber saba nalo na abeve dolu, naruei kialo ilisibiano nalo nei ajum̃a ajibirbili ga. ");
INSERT INTO bki_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mia karina tomu tealo na sibiano nalo neibano nalo amileal iliano tai, ana ajikili aberinavo ");
INSERT INTO bki_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kumemi numijog ka kema na, naio jom̃a mil barvar m̃elea ka naio jibe na naruei, berii Yimo Lu neibano korobido nalo amim̃aukanio bija jum̃alo nalo, berinavo naio ga mia rue bulagio bereio, ka mia naio ga rim̃auka vatitig Yimo Lu vou tai bereio, ka bogoti ve tolu 3 ga, napano mia toro jum̃ano rim̃auka re.” ");
INSERT INTO bki_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nalo aber iliano nalo na bano-o, mia karina kialo iliano nalo amierier janea vio ga, maka bunu atu sikili. ");
INSERT INTO bki_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Naruei parinio toro lu nei jumolu jikili jua miralo, mil ban Yesu, bika denio berinavo “?Mia jau koverdop̃eio vanlo, p̃eli makanio? Jum̃abe ka iliano nalo nei napano aju aber bulagio?” ");
INSERT INTO bki_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mia Yesu naio jo ga jibe na, maka riverdop̃e vanio bereio. Naruei Parinio Toro Lu nei ber bereio ban Yesu, berinavo “?Jum̃abe, jau kobe Naverikariano nei napano naio be Atua Lu kenerinio, p̃eli na makanio?” ");
INSERT INTO bki_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Naruei Yesu berdop̃e banio, berinavo “Ee, Naverikariano na be kiniou na. Mia kiniou najidom never bunu vanso, never iorou, mia rivesiou re, mia kamiu kuvial kiniou Kulorinio Kenerinio napano nojo nojotano ea tivelinio vameruo ea Atua na moroano. Mia kamiu kuvial ka mia noyotuba ea melijo nemei bereio ea vio yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ana Parinio Toro Lu neibano tinien mimi laka, naio mijede kiano kulukoti, berinavo “Bisi ea vio na! ?Bior venia ana kito rojum̃a rejiravo toro dolu bereio ka river saba nalo tealo rivanio? ");
INSERT INTO bki_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","?Kamiu kumijogio na? Toro na naio jo mila bulag tolu na Atua siano lu ruei! Mia vioriano naio jidom jum̃abe, mia kito rotibure naio tum̃abe?” Ana nalo ajibure Yesu, aberinavo memedu ga ka nalo monoka auebinio. ");
INSERT INTO bki_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mia nalo tealo ajum̃a abuvule eaio, napano abiviko mirano, ana ajukuio, naruei nalo amiyotel eaio, abika denio, aber “Ei, jau kover von, kei mijubaso vonganei?” Naruei Parinio Toro Lu kiano tomu nalo nei abinimei ka avuru Yesu ajaluvo den vio neibano, mia nalo neibano bunu napano ajum̃a ajuku naio bija amijuba naio napano mia nalo aju aburu naio abano. ");
INSERT INTO bki_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Naruei ea bogo nei, Pitere naio jo jouro ea burusio nei kia ga vo, ana tira tai na jo bitikar Parinio Toro Lu kunuano naio binimei ea vio neibano. ");
INSERT INTO bki_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mia bogo na naio mileal ka Pitere jo juva sebi, ana naio mial mijikia Pitere, mia naio berkanio, berinavo “Ei, jau bunu kojo kajakisor toro na Nasarete na!” ");
INSERT INTO bki_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mia vonganei, Pitere naio mila bonua tenei, berinavo “Ei, kiniou maka leleio nojoglubarbar vaio na jau kojom̃a koberenio.” Naruei naio jaluvo den vio neibano, ba vaataro ka burum̃ara m̃aratavo na toru na yimo neibano. ");
INSERT INTO bki_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mia ea vio nei, tira neibano mialio bereio, a naio berealio ka tomu nalo napano aju na, berinavo “Toro na, naio be nalo tai na abe kiano.” ");
INSERT INTO bki_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ana Pitere naio mila bonua iliano nei bereio. Ana maka vesiou, ana tomu nalo na ajua vio na aber ka Pitere, aberinavo “Maka, jau kobe nalo tai na, bior jau kobe toro tai na vio Kalele memedu na!” ");
INSERT INTO bki_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mia Pitere mil kirisikili lie ea iliano nalo na kirisikili, berinavo “Riano mave, kiniou neber ruei, kiniou maka lele nejikia kema na kamiu kumitum̃a kuberenio na.” ");
INSERT INTO bki_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Naruei memedu ka bogo na Pitere naio berenio jibe na, tu naio jokokoreko valuo nene, mila na Pitere naio tinien maio ka bereio iliano na Yesu berenio berinavo “Riano ga kiniou neber kaso, mia bogiano na ga, bogo na tu naio tokokoreko rive valuo nene vo, mia jau kalabonua kiniou rive varolu ruei.” Mia Pitere mijog tinieno bova mia bova, ana batavio, mia naio jegi mia jegi. ");
INSERT INTO bki_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Naruei ka Vraire kavijova, tomu na tortoru na kulo Israel nalo ajutano bereio ea kialo burum̃ara komeli. Nalo nei, tomu na tortoru na kulo lu nalo kialo, bija navurim̃araboiano nalo a kialo naverloglogiano nalo na tuboiano. Nalo amil bano-o, nalo abokar jidomiano tai, ana iorou amiorkar Yesu jum̃ano, aburu naio aban ea Parinio Tubo Pailat, ana ajuvan Yesu jua jum̃ano ka tibureio. ");
INSERT INTO bki_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ana Parinio Tubo Pailat naio bika den Yesu berinavo “?Jau kobe Parinio tubo ka kulo Israel nalo p̃eli na makanio?” Ana Yesu berdop̃e, berinavo “Tenene na naruei, jibe na kojom̃a koberenio kia na.” ");
INSERT INTO bki_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mia tomu na tortoru na kulo lu nalo aberii bulavulag vite nalo telabo kar Yesu, aberinavo naio jo mila vite telabo na bova. ");
INSERT INTO bki_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Naruei Pailat bika bereio, berinavo “Jum̃abe? Nalo nei aberenio vite telabo na bova biorso ruei, mia jau be kiamo verdop̃eiano kanio, p̃eli makanio?” ");
INSERT INTO bki_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mia ea tivelinio na venia nalo na ajum̃a aberenio, mia Yesu maka bunu sian verdop̃eiano tai bereio vanlo, naruei Pailat miilo toru kanio biorio. ");
INSERT INTO bki_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ea bogo na, mia nalo aju kia ga vo ea Jokoluolu na Sidomkariano na Ioruriano, a ka yuka nonovio ea jokoluolu nei, Parinio Tubo na Romo naio jom̃a mila vite tai ka kulo Israel nalo. Naio mila jibe ka napano verenio nalo tealo ajua lakoiano, tomu nalo amijikia avika nalo tai napano ajidom, ka mia Pailat rijamo ka naio riva tavio ga. ");
INSERT INTO bki_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ana ea bogo na, toro na poletik tai joa lakoiano, napano tomu nalo amijikia batitig naio, napano siano be Barabas. Naio be toro tai na kirisiou napano ajumolu ka ala mira keano kulo Romo, naio muebinvin tealo am̃arm̃aro, naruei ajetavokio ea lakoiano biorio. ");
INSERT INTO bki_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jibe na, ana tiniobi nalo abinimei telabo vio takurano ea Pailat mirano, nalo abika den naio ka rila rivanlo tavukia nam̃a naio jom̃a mila, ka naio monoka rijamo ka nalo tai kalo napano joa lakoiano naio riva tavio bereio. ");
INSERT INTO bki_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Naruei Pailat berdop̃e, berinavo “Moo, p̃eli kamiu kumisidom ka kiniou najamo ka kema nei rivatavio bereio, nina be kamiu kulo Ju kenemiu Parinio Tubo?” ");
INSERT INTO bki_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat bika jibe nei, bior naio mijikia ruei ka tomu na tortoru nalo na kulo lu nalo na Ju nalo ga aburu Yesu binimei ban naio, jibe ka im̃auano na jokuano ga, bior amial ka tomu dolu nalo ajaaro laka kanio. ");
INSERT INTO bki_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jibe na, Pailat jidom tuvan Yesu rivano, mia tomu na tortoru na kulo lu nalo amila bulag tomu nalo kialo jidomiano binimei bitunu m̃elea, ana aber monoka asikil ka Pailat ka naio tuvan re Yesu rivano, mia naio tuvan ga Barabas rivano. ");
INSERT INTO bki_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mia Pailat naio mijog venia napano ajum̃a aber ka naio, naruei naio bika denlo bereio, berinavo “Mo bo ga, a ver tibe na, mia kiniou nala tum̃abe ka toro nei nam̃a kamiu kubio Parinio Tubo na kulo Ju nalo kialo?” ");
INSERT INTO bki_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mia nalo abiniu amiaga mave bereio, aberinavo “!Kuvitukukakar naio ea m̃akolkolo!” ");
INSERT INTO bki_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Naruei Pailat bika denlo, berinavo “?Mia bior vaio, naio mila vaio na kirivova?” Mia nalo amiaga jouo lie vo, aberinavo “Kuvitukukakario, kuvituku-kakar naio mave ea m̃akolkolo!” ");
INSERT INTO bki_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mia Pailat maka bunu rijikia naruei mia naio rila tum̃abe, mia jidom ka naio monoka river titai ka mia tomu nalo nei amijikia ajog rivu riviorio, naruei naio berinavo Yesu naio tobo, mia naio tuvan Barabas bere rivanlo. Ana naio midu Yesu joa kiano na mira nalo jum̃alo ka nalo avitivio, ana ka avurio riva atukukakario ea m̃akolkolo. ");
INSERT INTO bki_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naruei Pailat kiano na mira nalo aburu Yesu aba joomo ea burusio na kanano komeli, mia nalo abio kialo taara dolu nalo telabo abinimei ka aialio. ");
INSERT INTO bki_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Naruei nalo amiya bulag kanano kulum̃arauo, ana amiya kulukoti tai ea naio napano be vabolo, jibe ka nam̃a parinio tubo nalo amiyaio, a nalo abar nionoti tilikibi abili, amiveio ea parinio, jibe ka parinio tubo tai kanano batubatu. ");
INSERT INTO bki_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mia bogo napano abar tenalo na bisi, amiyotel eaio, aberinavo “Parinio Tubo na kulo Ju kialo, o! Kumemi nubatove kaso, kumemi numiaiaso!” ");
INSERT INTO bki_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ana nalo amidu jaati subavio, amue pariparinio, a abuvule niegeniege naio, aminie ka naio jibe ka abameneaio. ");
INSERT INTO bki_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mia bogo nam̃a amiyotel ea naio jibe na bisi, nalo amiyalar kulukoti vabolo nei denio, ana amiya m̃ano kulum̃arauo eaio bereio, ana nalo aburu naio, abatavio ka atukukakar naio ea m̃akolkolo. ");
INSERT INTO bki_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ana bogo na na mira nalo aburu Yesu aju abano, nalo amileal toro tai napano naio ba yeturu jo miel binimei. Toro nei, nina be Saimon nanua beamu naio be toro na Saireni, a napano naio be karam̃ano tomu juo nei Aleksada bija Rovus. Naruei nalo amial naio, ana ajutua ka naio kija rudu Yesu kiano m̃akolkolo rivano. ");
INSERT INTO bki_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mia nalo aburu m̃arabo ka Yesu aba abokar suku tai, siano Kolkota, napano nioti nene berenio vio na jibe kanio bordada na buriu na toro. ");
INSERT INTO bki_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Naruei bogo napano nalo amijivi ea suku nene, nalo ajidom adu m̃arjum̃elm̃elu van Yesu ka rimunuio. Mia m̃arjum̃elm̃elu nei, nalo amiyon buron vite tai mijea ban bijaio ka rila Yesu niabene rije, ka naio rijog rijalele m̃elea re, mia bogo na nalo ajian banio mia naio maka sidom rimunuio. ");
INSERT INTO bki_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ana nalo amidu Yesu, ana ajuku kakario mave ea m̃akolkolo. Karina, nalo amiere m̃abujo, ka aleal ka kei kalo mia rivar kiano kulum̃arauo tai, a mia kei rivar dolu nene. ");
INSERT INTO bki_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mia bogo napano amidu Yesu joa m̃akolkolo nei, nina kavijova, ea aura kover jibe na. ");
INSERT INTO bki_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ana na mira nalo na Romo nei, nalo ajiri iliano tai, napano berial vite napano navurim̃araboiano nalo na ajidom auebin naio rim̃aro riviorio, napano berinavo “Toro nei, naio be Parinio Tubo na Ju nalo.” ");
INSERT INTO bki_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mia ka bogo na bunu, tomu va juo na vinauano, ajukukakarlo bunu ea m̃akolkolo jibe ka Yesu, tai abitirilario ea vameruo na naio, a tinene abitirilario ea vam̃ali. ");
INSERT INTO bki_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ea bajago nei naruei, nalo amila ka mia iliano moruo tai na Iliano Lu naio rimei rive riano, napano berenio berinavo “Nalo amidu naio mon naliko tomu nam̃a amila kokorov tuboiano.” ");
INSERT INTO bki_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Naruei tomu nalo napano m̃a amiel abarlaka ea vio na, nalo aju ap̃iligṽilig pariparilo, nalo amil niegeniege Yesu liki, aberinavo “Aie, jau na, nanua m̃a kober komijikia kala bulag Atua Kunuano Lu, a mia jau kovitiri lario bereio ka bogoti ve tolu ga, mia jum̃abe vonganei? ");
INSERT INTO bki_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","!Bo ga, jau kalavon ka kalarurso, jau kataluvo den m̃akolkolo na, jau katabulu!” ");
INSERT INTO bki_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ea bajago na bunu, tomu na tortoru na kulo lu nalo naliko naverloglogiano na tuboiano nalo aju abital niegeniege naio, nalo aberinavo “!Naio milarur tomu dolu nalo telabo ruei, mia naio maka bunu rijikia rilarur naio bereio naruei! ");
INSERT INTO bki_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","?Naio be Naverikariano, naio be Parinio Tubo ka kito kulo Ju, p̃eli? Bo ka naio tavulu den m̃akolkolo vonganei, ka mia kito reial ka naio be riano, ka mia kito romijikia romonea naio.” Mia naljuo napano ajukukakarlo ea m̃akolkolo bija Yesu, naljuo na bunu amiasol ilivaiano nalo ea naio jibe na. ");
INSERT INTO bki_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mia ka legiano viovare, ana melijokouo binimei miununuko vio reraio garuei, naio jo jibe na bano-o bokar m̃erenio tolu niogoravo. ");
INSERT INTO bki_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ana ea bogo na, Yesu miaga jouo ea kiano iliano memedu, naio berinavo “?Eli, Eli, lam̃a sabatani?” napano berenio “?Kiaku Atua, kiaku Atua, ka vaio ana kojuvan kiniou nojo jibe nei?” ");
INSERT INTO bki_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mia tomu tealo napano ajum̃a ajumolu ajua vio nei, napano nalo aju abitii vite nalo na, nalo amijog belea Yesu kiano iagaiano nei, naruei nalo aberinavo “Kamiu kumijog, toro na naio jo bio tormoruo Elaija na, ka rimei rijai naio.” ");
INSERT INTO bki_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mia sop̃eli ga, nalo tai jikiti binimei, midu burujumu, miyon m̃arjum̃elm̃elu na mijea banio, ana julukar ka iesi tai, ana miyuku ban ka Yesu rimunu eaio, berinavo “!Ei, kito rotu vo! Reial von, p̃eli mia tormoruo Elaija rimei rilarur naio kovio, p̃eli na rimei re.” ");
INSERT INTO bki_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naruei Yesu miaga jouo, naio buru maaria kanano jegi, naio m̃arodobi. ");
INSERT INTO bki_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ea bogo nene na ga, jagidago merorolu laka napano jaklele ea Atua Kunuano Lu, nam̃a joko vio lu na be vio lu laka, naio burup̃e tivelinio juo, jikar mave batove boru yetano. ");
INSERT INTO bki_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Naruei toro na toru ka na mira nalo, napano ju bitikar Yesu, bogo na mial Yesu buru maaria kiano jegi jibe na, naio berinavo “!Banalo tom nalo, toro nei be Atua Kenerinio riano ga!” ");
INSERT INTO bki_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","A tire tealo napano ajum̃a ajakisor Yesu aju ka bogo nei, nalo ajikili aju koalabo kija, aju abitikar kialo naverloglogiano. Ea nalo nei, nalo tolu nei, be Mere tira re Maktala, a Mere dolu napano Yemesi naio Yoseve kenielo, a tira napano Salome. ");
INSERT INTO bki_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nalo nei naruei napano bogo na Yesu jo Kalele nua ruei, ajum̃a ajakisor naio, ajum̃a amijaio. A be tire telabo dolu nalo bunu ajumolu aju ea bogo na, napano nalo bunu ajaluvo Kalele, ajakisor Yesu abinimei mave Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Mia bogoti nei be Vraire, naio be bogo na ala vite nonovio atu batitig rivu ea Legiano Lu nei beni, mia bogo napano vaataro ka m̃erenio rivatove, ");
INSERT INTO bki_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","toro tai na Arimatea, naio siano Yoseve, naio mila kiano jidomiano jikili, ana ba jikili jukamu ka Pailat mirano, naio bika Pailat ka rijikia ridu Yesu mokotenano. Mia kirisikili ka Yoseve naio rila tibe na, bior ka naio be tarati tai na burum̃ara vironiano na komeli na kulo Ju kialo, mila na tomu nalo amijikia batitig naio, a naio be toro tai bunu nam̃a jidom laka ka Atua kiano navenatuboiano rimei. ");
INSERT INTO bki_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ana ka bogo na, Pailat maka rijikia ka Yesu naio m̃aro ruei p̃eli na makan vo, naruei naio bio kiano toro na toru na kiano na mira nalo, ka vika denio. ");
INSERT INTO bki_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mia bogo napano naio mijogial ka Yesu naio m̃aro ruei, naio mijamo ka Yesu mokotenano ban Yoseve. ");
INSERT INTO bki_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mia Yoseve naio je m̃ano buluvae tai be terivou ga maka vesiou vo, karina naio ba bulu kulum̃arauo vou tai, naio ba amidular Yesu mokotenano batove ea m̃akolkolo, ana amijuvuliko ka kulum̃arauo neibano, ana nalo amidu abano mon ea m̃ano buluvae napano. Ana amelivlivi ka puruveru na toru nene binimei, ajubonkokar m̃aratavo nene, ana aban bereio. ");
INSERT INTO bki_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ana Mere juo nei, tinene tena vio Maktala, naliko dolu nene napano be Joses kenieno, naljuo bunu abinimei amial vio nei napano Yesu mokotenano joaio. ");
INSERT INTO bki_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mia bogo napano Legiano Lu naio barlaka ruei bisi, nina ka bogo napano m̃erenio jikar batove vonga kijev ka Sarere, mia Mere na vio Maktala, bija Mere napano Yemesi kenieno, bija Salome bunu, nalo tolu nei aba abulu bonotanunu nalo tealo ka amijikia aion ea Yesu niabene. ");
INSERT INTO bki_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Naruei ka Sade kavijo, bogo na m̃erenio jikar ka mijivio kia ga vo, nalo tolu amiel ka avan ea buluvae nene. ");
INSERT INTO bki_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aju amiel abano, nalo ajum̃a abivika denlo, aberinavo “?Mia bogo na rovoru yako, mia kei mijikia rimelivlivilar ka burum̃ara puruveru napano ajubonkokar buluvae nei van kito, ka romijikia rava joomo?” ");
INSERT INTO bki_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mia bogo napano nalo abinimei vaataro ka vio nei, nalo amial ka burum̃ara puruveru nei, napano toro tai melivlivilario ruei. ");
INSERT INTO bki_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Naruei nalo aba joomo ea buluvae nene, amiilo ka m̃eaku tai, naio jotano tivelinio vameruo, napano naio miya kulum̃arauo nalo na amiuvuruvu laka, mia bogo na nalo amial naio amiilo bova laka. ");
INSERT INTO bki_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naruei naio mil banlo, berinavo “!Ei, kamiu kumerou re! Kiniou nemijikia ruei ka napano kamiu kubinimei ea vio nei bior Yesu na vio Nasarete, napano ajukar naio ea m̃akolkolo. Mia naio jumolu meul bereio ruei, naio maka bunu toa vio nei. Kamiu kumei von kuvialio! Ninei naruei vio nanua amidu batitig mokotenano mon eaio! ");
INSERT INTO bki_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mia kamiu kuvan sop̃eli, kuva kuverial ka Pitere vija naiagagoano dolu nalo, ka mia Yesu rivatove tukamu kalo yako Kalele, mia nalo bunu monokanio atakisor naio, mia nalo amijikia aialio ea vio na, tavukia na nanua berkar kalo nua ruei.” ");
INSERT INTO bki_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naruei tire nalo nei amila sop̃eli, ajaluvo den buluvae, aburo abano, bior nalo amiilo toru laka ka vite nalo neibano bano-o m̃a amemebiju garuei. Ana amerou m̃elea bunu, mila ana maka ava averial ka tomu dolu nalo leleio, mia nalo aban memedu ka naiagagoano nalo ga. ");
INSERT INTO bki_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ana Yesu naio meul bereio jibe nei ea kavijo vio buru vurevure ka Sade nei ruei, napano naio be legiano moti na bogoti aluo. Naruei naio jo malmaluvo keanlo napano ajakisor naio, mia nana miyotuba kean beamu be Mere re Maktala, nina napano naio mijil bulag sim̃aro nalo aluo eaio nua ruei. ");
INSERT INTO bki_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana iorou ka na Mere naio mial Yesu, naio ba miyotuba kean nalo nanua m̃a ajakisor naio, napano aju amijog bova a ajum̃a ajegi kia ga vo, ana naio berial kalo ka napano Yesu naio meul bereio ruei. ");
INSERT INTO bki_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Naio ber batitig kalo ka naio mial Yesu ruei ka mirano, mia nalo maka amonea naio. ");
INSERT INTO bki_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ana iorou ka bereio, ea bogo tai napano naiagagoano juo aju ajaluvo den Yerusalemo, naljuo aju amiel abano, ana Yesu naio maluvo kean naljuo. Naruei naljuo amial jibe ka napano Yesu niabene be dolu, naio maka tibe ka nua. ");
INSERT INTO bki_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mia bogo napano amial naio bisi, abe juo abarp̃iliglo, aban bere, abano aberial vite nei ban nalo dolu, mia bogo tai bereio, nalo dolu nei maka amonea vite nei. ");
INSERT INTO bki_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ana iorou ka bereio, Yesu naio miyotuba kean naiagagoano duelimo ba tai, ea bogo tai napano nalo ajutano aju ajinan. Ana naio mil kija banlo, bior ka napano maka avar tinielo ea naio, a bior ka napano kanalo iviso nalo jikili laka, mila na maka atu amonmonea kialo iliano nalo ka amial naio meul bereio ruei. ");
INSERT INTO bki_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ana Yesu naio ber kalo, berinavo “Vonganei, kamiu monoka kuvano, kuvitan ka kamiu ea vio nonovio na yetemeriba nei, a kamiu monoka kuvioliolu ka kanaku Ioluano Vou van tom nonovio. ");
INSERT INTO bki_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ver toro tai rijogio, mia naio rimoneaio, mia karina avaruei ea naio, toro nene mia naio rijev ioruriano. Ana naio napano ver maka rimoneaio, mia Atua naio riverkar m̃ariano vanio. ");
INSERT INTO bki_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Mia nalo napano m̃a amoneaio, mia vremesiano nalo toalo, tibe ka napano mia ajil bulag sim̃aro nalo ea moroano na siaku, a mia ajev iliano dolu nalo, ");
INSERT INTO bki_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mia ver bogo tai avokar maro tai, mia nalo avu ga, a ver bogo tai amunu vite tai napano monoka am̃aro kario, mia vite nene naio maka rijikia rila titai kalo, a mia adu jum̃alo toa namieiano nalo, naruei mia nalo amei avu bereio.” ");
INSERT INTO bki_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ana iorou ka napano kiado Tubo Yesu ber iliano nalo nei banlo bisi, Atua burular naio ban bereio mave tiniabene, midu naio jotano tivelinio vameruo na naio. ");
INSERT INTO bki_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Naruei naiagagoano nalo abanvan tavio naruei, aba amioliolu ea vio nonovio, a nalo amial ka napano Tubo naio jo mim̃au bijalo, naio jo mila lo amila vremesiano telabo ka rila tomu nalo avitilubar ka kanalo iliano nalo nei abe riano. A tukunu nei naio bisi ea vio na. ");
INSERT INTO bki_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kiniou Luka nebivitauia tukunuano nei banso, toro na toru Tiovilas. Jibe ka napano jau komijikia ruei, tomu telabo abivitauia ruei tukunuano na vite nalo nei nanua amalmaluvo ka kito yuka tealo bar laka ruei. ");
INSERT INTO bki_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Vite nene nalo, kito maka reialio rimemedu ka mirado, mia tomu nalo napano jikar ea burupati nene, nalo aju amialio, a ka napano nalo ajibe ka tomu na be moti na Lilianiano Vou nabo, nalo naruei aberial sosolio batitig binimei ban kito. ");
INSERT INTO bki_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naruei jikar nanua ruei, kiniou nojom̃a nebitii batitig m̃esi dolu nalo nam̃a abivitauiaio, a nojom̃a nabar iliano na vite nene nalo, naruei namial jibe bo ka ver nalavon ka navar torogio dolu nalo na tukunuano nei, novivitauia sosolio amei tibe ka niosi novo tai napano jakii memedu kiri m̃arabo sesa nalo na tukunuano novo nei. ");
INSERT INTO bki_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Naio naruei nobivitauiaio ruei jo, mia kiniou najaaro ka notuvan riviedu ve kiamo, ka mia jau komijikia kovulukuio, komijikia kovitilubar ka vite nalo nam̃a kojom̃a komijogio ruei amemedu ga a abe riano, ajavukia nam̃a kanaku niosi nei berialio. ");
INSERT INTO bki_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tukunuano nene naio jikar jibe nei: Ea bogo nam̃a Parinio Tubo Erot naio jo mije tuboiano ea tanobuku na vio Yutea, toro lu tai, naio be m̃aratavo na Abija, a naio buru tira tai napano naio bunu miyotuba ea yati na kulo lu nalo, nina ea m̃aratavo na tormoruo Erono, Mosis kuruano re nua laka. Toro nene siano Sakaraia, a koano, siano Lesveti. ");
INSERT INTO bki_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mia naljuo nei, kialo meuliano kiri memedu laka ea Atua kiano vitiiano, ka nam̃a amonmonea kiano tuboiano, a nalo ajum̃a amila bajago nalo na memedu kam̃a amila bogo nonovio ga, maka atum̃a ala belea tai. ");
INSERT INTO bki_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mia vite takurano ga, naljuo maka ve kenerilo tai, bior tira nei Lesveti naio jumolumu ga, mia vonganei naljuo abinimei abe kulo moruo nalo laka ruei. ");
INSERT INTO bki_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mia ka bogo tai, naio be bogo na Sakaraia kiano taara nalo monoka ava ala sida ea Atua Kunuano Lu, tavukia nam̃a taara nalo amila terakurano ea sude nalo. ");
INSERT INTO bki_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mia dam̃ariga, bogo nam̃a amilala jibe na, nalo monoka ala tibe ka nam̃a amiere m̃abujo, ka mia aleal nalo na vabe kalo naruei napano mia naio mijikia rila burum̃ara im̃auano nei ka mia m̃a riva joomo ea Vio Lu na Yimo Lu nei, ka risebi sida ea boda na jo. Mia ka bogo na amilaiio jibe na, mia Sakaraia siano mijoru loglogio, ka mia naio naruei riva rilaii burum̃ara im̃auano nene. ");
INSERT INTO bki_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Naruei monloglog bogo nam̃a amisebi sida nene, ana naio ba joomo ka rilaiio, a burutiniobi toru na tomu nalo aju tavio ajum̃a abolkouo. ");
INSERT INTO bki_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ana bogo na Sakaraia naio ba joomo, mia miilobin naio ka mial Atua kiano nailiano tai napano naio miyotuba kanio, jikili ju tivelinio vameruo na boda nene. ");
INSERT INTO bki_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mia bogo na Sakaraia mial nailiano nei, naio maka bunu rijikia ka mia tum̃abe naruei, a merou toru bunu. ");
INSERT INTO bki_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mia nailiano nei naio mil banio, berinavo “Sakaraia, jau komerou m̃ele re. Kiniou nebinimei ka neverial ga vanso ka Atua mijog kenemiu volkouano kube juo ruei, a mia koamo tira na Lesveti, mia naio rivar kenerimo solbouo sum̃ano tai, mia bogo na naio riyotuba, mia jau monoka kesisia naio ka Jone. ");
INSERT INTO bki_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mia bogo na naio riyotuba dovorovo, mia kuve juo tiniemiu saaro ve toru laka, tiniemiu sese, mia kamiu ve juo re ga, mia kulo dolu nalo bunu mia asaaro ve toru laka. ");
INSERT INTO bki_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kiritete nene, mia naio rimei rive Atua kanano toro na toru tai, a mia naio tibe ka toro lu tai, mia naio rivel ka m̃arjum̃elm̃elu vija uei na bitunu. Tikario ea bogo napano joa kia ga kenieno mabono, mia Niununo Lu to rivujolou ea naio ruei. ");
INSERT INTO bki_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mia naio rive toro tai napano mia naio rivilig kulo Israel nalo ve telabo amei bereio ea Atua Sop̃i, kialo Tubo. ");
INSERT INTO bki_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mia aial ka napano niununo a moroano nanua joa Naverialiano Elaija mia to rivare ka ga naio bereio, bior mia naio tukamu rimei, ka riverial ka mia Naverikariano naio rimei iorou ka naio vesiou re. Mia naio rivilig teta nalo kialo iviso nalo ka mia asidomial vatitig bereio kenerilo nalo, a mia rivilig tomu nalo nam̃a amila kokorov tuboiano ka mia atakii bereio bajago napano be masou a memedu. Ea m̃arabo nalo na naruei, mia naio rila vatitig rivu taara na tomu nalo tai ka mia ave Atua kiano, ka atu rorea naio ka mia riyotuba kalo.” ");
INSERT INTO bki_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mia Sakaraia naio mijog iliano nei, ana naio berkanio nailiano nei, berinavo “Ai, abe kover re tibe na. Maka rijikia tibe na, bior kumemi juo nei m̃erenio batove ruei nei.” ");
INSERT INTO bki_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ana na nailiano nei mil ban bereio, berinavo “Makanio, mia tibe ga na. Kiniou nebe nailiano Kapriel nei, nam̃a bogo nonovio najikili nojua Atua mirano ka m̃a nabar kanano iliano, naruei naio miila kiniou nebinimei easo ka neverial lilianiano novo nei vanso. ");
INSERT INTO bki_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mo bogo na kiniou neberialio kaso, mia jau maka komoneaio, naruei kiniou never kaso ka mia kove buru, a mia jau koto tibe na rivano-o rivokar bogo na keial vite nalo nene ayotuba kaso, nina ea bogo nene rimemedu.” ");
INSERT INTO bki_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mia bogo na nailiano jom̃a mil kia ga jibe na ban Sakaraia, mia tomu nalo ajikili aju tavio kia ga vo, aju rorea bano deio, ana nalo aju ajidomii aberinavo “?Ka venia ana naio ba joomo, bijuku kiki jibe na?” ");
INSERT INTO bki_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ana iorou kanio, ana naio batavio bereio, mia nalo amial ka naio maka bunu rijikia ril vanlo, naruei nalo abitilubar ka naio jo joomo naio mial titai napano mila naio jibe na. Naruei naio jom̃a mil ka ga jum̃ano banlo, maka bunu ril be buru ga jo. ");
INSERT INTO bki_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mia naio jidel dolu ka ga m̃a jo mila kiano im̃auano ea Yimo Lu na Atua Kunuano, bano-o kiano bogo nene bisi, ana naio ban bereio vonuo. ");
INSERT INTO bki_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Naruei nalo aju jibe na bano-o, mia maka vesiou, ana koano p̃igi, mia bogo na naio mial ka naio be m̃abono jibe na, mia naio ba jo vonuo ga bano-o bokar siberio jumo. ");
INSERT INTO bki_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ana ea bogo na, naio jo ber jibe nei, berinavo “!Atua bijuku bo tanea ban kiniou nei! Beamu tomu nalo ajum̃a abiti sa ea kiniou bior maka navar tete, mia vonganei, Atua naio mial kiniou, tinien miia kiniou, naruei naio midular imouiano na kanaku jumolumu nene ruei.” ");
INSERT INTO bki_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Naruei Lesveti naio be m̃abono siberio ari ruei, ana na Atua miila kiano nailiano nei, Kapriel, ka riva riverial kiano iliano tai rivan niatira tai, siano Mere, napano naio be niatira tai na komeli na vio Nasarete ea tanobuku na vio Kalele. Ea bogo na, aberkar Mere nene ruei ka mia riva soro ka toro tai, siano Yoseve, napano naio miyotuba ea yati na Parinio Tubo Teviti re nua, mia Mere naio maka riva to rivija naio vo. ");
INSERT INTO bki_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana na nailiano nei Kapriel naio binimei, miyotuba ka Mere, naio berinavo “Mere-o, abe Atua naio jo jaaro toru laka ka jau, naio milivu kaso, a naio jo bijaso riano.” ");
INSERT INTO bki_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mia bogo na Mere mijog iliano nei, naio jidom bijovijonio toru laka, ana ber mia riviti von, ka nailiano nei mil kirinovo laka ban naio jibe nei, ber nioti nene venia. ");
INSERT INTO bki_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Karina nailiano nei mil bereio banio, berinavo “Mere, jau komerou re. Atua tinieno jaaro kaso ga, mia rila burum̃ara ilivuiano tai rimei ea kiamo meuliano. ");
INSERT INTO bki_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vonganei, mia jau kove m̃abomo, vano-o mia kodu kenerimo sum̃ano tai, a ver naio riyotuba kario, ana monoka jau kesisia ka Yesu. ");
INSERT INTO bki_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iliano Lu re nua berii kenerimo nene ruei, na naio berinavo ‘Naio mia rive toro na toru, a mia siano rive “Atua Na Loa Laka Kenerinio,” a Atua Tubo rila naio rimei ve parinio tubo tai, napano ridu jeleig korobinio re nua nene, napano parinio tubo Teviti, ");
INSERT INTO bki_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","naruei mia naio rije tuboiano ka nalo napano na amiyotuba ea Yakovo kanano m̃aratavo, nina be kulo Ju nalo na aju vonganei, a ka mia nalo na amei iorou, a kanano navenatuboiano mia naio maka rijikia ribisi bogo tai.’ ” ");
INSERT INTO bki_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Naruei Mere naio miilo toru laka ka iliano na ber mia naio rudu tete, ana bika den nailiano nei, berinavo “?Ana mia vite nene riyotuba sel tum̃abe liki nei, bior kiniou maka nuvitu biju kumemi juo kanaku sum̃ano vo?” ");
INSERT INTO bki_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ana na nailiano berdop̃e, berinavo “Mia Niununo Lu rivatove easo, a mia moroano na Atua Na Loa Laka kiano rimei sovokoso, ana na mia jau kop̃igi. Ana bior mia jau kotibe na, mia nalo averinavo kiritete lu napano mia jau koduio be ‘Atua kenerinio.’ ");
INSERT INTO bki_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Ea kanamo vitiiano, jau komial tena kirisikili laka ka mia tibe na, ana bo ka jau kosidomii von koniomo tiramoruo Lesveti yako. Aju amial aber mia naio rivar kulu re tete ga, mia naber kaso, naio be tiramoruo ruei, mia vonganei, naio kiano siberio ari ruei. ");
INSERT INTO bki_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jau monoka tiniemo rimaio, ka jibe ka napano Atua ber ka tiramoruo Sera re nua laka, ea tivelinio ka naio, maka ve titai leleio napano mia naio rijikia re ka rilaio.” ");
INSERT INTO bki_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ana na Mere naio berdop̃e, berinavo “Ierinio ga. Kiniou nobe niatira na Atua kanano im̃auano ga, mo kiniou nomijamo ga ka mia naio rila vite nalo na ayotuba ka kiniou tibe ka ga napano naio jidomio, tibe kanio na jau koberial ban kiniou na.” Ana na nailiano nene juvan naio ban bereio. ");
INSERT INTO bki_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana na Mere jom̃a jidomii nailiano nei kanano iliano nalo nei, karina naio jidom toru ka riva rial kenieno nene napano Lesveti, mia maka vesiou ga, ana naio jumolu den kiano vio, mila sop̃eli ban ea m̃arkomeli napano Lesveti naio koano Sakaraia ajuaio, nina ea tanobuku na suku nalo na vio Yutea. ");
INSERT INTO bki_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mia Mere neibano bokar naljuo nei kunualo nene, naio ba bio Lesveti. ");
INSERT INTO bki_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mia bogo napano Lesveti naio mijog lubar Mere joono ka mil banio, naio mijog ka kenerinio napano joa naio, bijobijo toru. Naruei Niununo Lu binimei ea Lesveti, naio binimei bujolou eaio, ");
INSERT INTO bki_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","naio miaga manenea, berinavo “Aiou Mere, Atua rilivu kaso ve toru laka, loa tira dolu nalo aviniu, a mia kanano burum̃ara ilivuiano toa bunu kanamo m̃arati napano mia kovario! ");
INSERT INTO bki_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kiniou maka nove tira na memedu leleio ka mia kanaku Tubo Kenieno rimei riadu ka kiniou tibe nei, mia namial kirinovo laka ban kiniou. ");
INSERT INTO bki_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mia kanaku solbouo naio bitilubarso, naio jaaro toru laka, bior monloglog bogo napano numijog joomo be moti garuei, naio bijobijo toru laka ea kiniou. ");
INSERT INTO bki_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kito juo rajaaro mia rajaaro, bior robiekar batitig Atua Sop̃i kanano iliano, a mia rimei rive riano van kito juo tavukia ga napano naio berkar ban kito ruei.” ");
INSERT INTO bki_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ana ka bogo na, Mere kanano iouano tai jibe nei, berinavo “Kanaku iviso miaia Atua toru, ");
INSERT INTO bki_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","niunuku jaaro toru laka ea Tubo kiaku ioruriano, ");
INSERT INTO bki_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","naio mial kiniou nojotano, tira na kiano im̃auano tai, naio be Atua na Moroano, jidomial kiniou, mila tonovo ban kiniou. Taara nalo napano amei iorou, averii kiniou, averinavo ‘Tira nei, Atua milivu toru.’ Nomidular siano lu, ");
INSERT INTO bki_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","tinien miia nalo nam̃a ajutano kanio, taara re nua, na iorou. ");
INSERT INTO bki_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Moroano na jum̃ano mila vite miroano, naio jiburevure nalo nam̃a tinielo jikili, mila dedade ealo abeve terakurano. ");
INSERT INTO bki_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mila bulag parinio tubo den jelelo, bitiri bulag nalo nam̃a jidomiano batove ga. ");
INSERT INTO bki_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nalo nam̃a jijerlo, naio bagan batitiglo, nalo nam̃a abe sanibaiano, naio mijil bulaglo, jum̃alo yauo ga. ");
INSERT INTO bki_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Naio mila nam̃a berkario nua ban korobido nalo, binimei miija kito, kanano kulo Israel nalo. Maka rivitoviton ea Epraamo, tinienriia kiano bajulukuti nam̃ariga-o tobo to.” ");
INSERT INTO bki_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Naina naruei Mere kiano iouano maaro ea vio na, mia naio jo bija Lesveti bano-o bokar siberio tolu, karina ban ea kanano vonuo bereio. ");
INSERT INTO bki_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Naruei binimei monloglog bogo na mia Lesveti rudu kenerinio, mia naio barlar be sum̃ano. ");
INSERT INTO bki_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mia bogo napano Lesveti kiano m̃aratavo bija tomu na vaataro nalo amijogial vite nei, nalo ajaaro toru laka bija naio ka Atua kanano burum̃ara tinieiiano nei banio, ka beamu naio be jumolumu ga, mia vonganei naio barlar kenerinio motoru. ");
INSERT INTO bki_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mia bogo na kiritete nei naio bokar bogoti aluo, ana abinimei ka ala pakuveu ka naio. Ka bogo na, ajidom ka adu siano bunu, avio ka Sakaraia, tibe ka karam̃ano siano, ");
INSERT INTO bki_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mia kiritete kenieno berbure, berinavo “Makanio, naio siano Jone.” ");
INSERT INTO bki_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Naruei nalo amil banio, aberinavo “?Venia na? !Maka lele garuei kanamo m̃aratavo tai napano adu sio na jibe na toa naio!” ");
INSERT INTO bki_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Naruei amil ka ga jum̃alo ban kiritete nei karam̃ano, ka avika denio ka naio jidom ka adu sio na vabe toa kenerinio nene. ");
INSERT INTO bki_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ana na Sakaraia mil ka jum̃ano banlo, ber adu m̃esi tai rimei vanio, naruei naio bivitauia, berinavo “Siano, Jone.” Vite na naruei mila nalo na vio na amiilo toru laka kanio, ");
INSERT INTO bki_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","mia monloglog bogo na bunu, Sakaraia minano mijuo, naruei naio mijikia mil bereio, ana na miaia Atua. ");
INSERT INTO bki_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mia tomu nonovio nalo na tanobuku na, amijogial vite nei, amiilo va kanio, mia tukunuano nene mererako janea m̃arkomeli dolu nalo na tanobuku na suku nalo na vio Yutea. ");
INSERT INTO bki_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ana na nalo nam̃a amijogio, ajidom bijovijon toru laka kanio, bior abitilubar ka Atua jum̃ano jo bijaio, naruei nalo ajum̃a abivika denlo, aberinavo “?Kiritete lu nei mia naio tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Naruei Niununo Lu binimei bujomagmago ea Sakaraia, kiritete telisu nei karam̃ano, ana naio berial jibe nei, ber ");
INSERT INTO bki_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kito raiaia kanado Atua siano, Tubo re Israel, batove kean kito, bulular kito, ");
INSERT INTO bki_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","bitirilar kiano siyovo, miyotuba ea bajulukuti na kiano toro na im̃auano Teviti, ka mia rilarur kito. ");
INSERT INTO bki_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nina kiano verikariano nanua, naverialiano nalo aberialio, aber ");
INSERT INTO bki_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Naio mia rivuru bulag kito den kiado uolu nalo jum̃alo, ");
INSERT INTO bki_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tiniene ribobogia re kanano virakariano bija korobido nalo, tinien miialo kia ga vo. ");
INSERT INTO bki_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nina verikariano jikili nene bija korobido Epraamo, ");
INSERT INTO bki_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","nanua Atua berkar ber rilarur kito ka kiado uolu nalo jum̃alo, ka romerou re bunu, rove lu, romemedu kamu ea mirano, roim̃au kanano ka legiano nonovio ea kiado meuliano. ");
INSERT INTO bki_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Keneriku, mia avioso ka Atua Loa Laka kiano Naverialiano, mia kotukamu ka kala vatitig Tubo kiano m̃arabo. ");
INSERT INTO bki_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Mia koverial ka mia Atua tinien riia kiano tomu nalo, tinien tiilo, ana mia riviekokoa kialo kariano nalo, a rilarurlo. Mia Atua riila kiano kiriyulu telisu na kavijo ve moti rimererali kito, ");
INSERT INTO bki_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","rimei rimererali kito napano m̃a rojua melijokouo, napano niununu nam̃ariano miununuko kito ruei, a mia rimei rimererali m̃arabo na tum̃aro ka rotum̃a reiel eaio.” ");
INSERT INTO bki_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mia bogo na yuka nalo aju abarlaka bano, Jone nene naio miluo bavin ririo bo, a kiano jidomiano meruo batitigio, a naio biekouo ea Atua kiano im̃auano bo. A naio ba joa vio yauo, ka riva rivokar bogo na mia naio monoka riyotuba ea kulo Israel nalo miralo. ");
INSERT INTO bki_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana ka bogo na, parinio tubo na kulo Romo kialo, naio siano Sisa Okastas. Naruei naio berial ka mia monoka avuluku tomu nalo na venuo nalo nam̃a ajutano ka kiano vitikariano. ");
INSERT INTO bki_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Im̃auano na abuluku tomu nalo nei, naio be moti na amila jibe na, a ka bogo na amilaio, mia toro tai na Sisa kanano naio jom̃a bitikar burum̃ara tanobuku nei na vio Siria, a toro na toru nene, siano Kuarenias. ");
INSERT INTO bki_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ana ka ala im̃auano nei, aberenio tomu nonovio monoka avanvan bereio ea kialo vio nalo, ka mia amijikia avivitauia vatitig sialo, a avuluku vatitiglo. ");
INSERT INTO bki_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Vite na naruei mila ana Yoseve naio jumolu den komeli na vio Nasarete, nam̃a naio jojoaio, nina ea tanobuku na vio Kalele, ana naio bavin ea komeli na vio Betleem, ea vio na tormoruo Parinio Tubo Teviti naio moluo eaio nua, nina ea tanobuku na vio Yutea, bior Yoseve naio miyotuba ea yati na tormoruo Teviti nene. ");
INSERT INTO bki_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mo Yoseve burukar koano Mere jakisorio, napano ka bogo na, vaataro ka rivarlar kenerinio. ");
INSERT INTO bki_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Naruei abe juo abano, mia bogo na nalo aju kia ga Betleem vo, mia Mere mijog ea naio ka kiano bogo na mia naio to joomo binimei nonovio naruei. ");
INSERT INTO bki_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ana na Mere midu kenerinio motoru, naio be sum̃ano, a naio bivikakari batitigio ka niakulm̃arauo, mia maka kanano vio nabo tai, bior abe juo amilavon ka ava atua yimo na valauo, mia naio bujo ruei, naruei Mere mila kenerinio mon joomo ea vio na abagan temeul nalo eaio. ");
INSERT INTO bki_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Naruei ka bogiano nene, be tomu tai nam̃a abitikar nunu aju bija kialo temeul nalo, ea soro tavio ka Betleem nene ga. ");
INSERT INTO bki_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Naruei Atua kanano nailiano tai batove keanlo, a Atua kiano mermerano midulii rera vio nene jibe ka burum̃ara yulu tai, mila nalo nei amerou toru laka. ");
INSERT INTO bki_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Naruei nailiano nei mil banlo, berenio berinavo “Kamiu kumerou re. Kiniou nomidu iliano nabo tai ka naver ka kamiu, ka mia naio mijikia rila tomu nonovio ajog rivu ve toru laka. ");
INSERT INTO bki_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ka bogiano nei ga, ea komeli na Parinio tubo Teviti re nua kanano, nina ea vio Betleem, kiritete solbouo tai naio moluo vonga, ka mia naio rive kenemiu ioruriano. Naina naruei be kenemiu Tubo, naio be Naverikariano nam̃a Atua berkario nua ruei ka mia riilaio rimei. ");
INSERT INTO bki_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","“A naina naruei be kijokijo na vite nene: Mia kamiu kuvileal kiritete telisu nene, napano amila kokouro ea naio. Mia kuvial ka napano abivikario ka niakulm̃arauo nalo ga, ka mia adu naio ka rimon ea vio na temeul nalo salo sinaniano.” ");
INSERT INTO bki_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Naruei nalo amiilo ka sop̃eli ga, burum̃ara taara na nailiano dolu nalo na vio mave abinimei amiasolo bija nailiano neibano. Naruei nailiano nalo nei amiaia Atua, a amiou aber ");
INSERT INTO bki_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mave niogovu, nalo ajum̃a amiaia Atua toru, a ea yetemeriba nei, tum̃aro joa tomu na Atua jaaro kalo.” ");
INSERT INTO bki_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nailiano nalo aberial iliano nei ruei, bisi na ajaluvo den tomu na abitikar nunu nalo nei bereio, karina abavin mave niogovu. Naruei nalo nei ajum̃a aberverii vite nei banlo bereio, aberinavo “Ai, abe ravano. Bo ka rava Betleem ka reial vite nei miyotuba vonganei, napano Atua berial ka kito.” ");
INSERT INTO bki_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ana nalo amila sop̃eli, aba amileal Mere naio Yoseve, a amijaka aba amiadu ka kiritete sesa napano monea m̃ano vio nam̃a abavagan temeul eaio. ");
INSERT INTO bki_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mia bogo na amial vite nalo nei, ana aber bulavulag nonovio iliano nalo napano nailiano berial kalo ruei, tivelinio na kiritete sesa nei. ");
INSERT INTO bki_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Telikiti na kulo dolu nalo amijog tukunuano nei, tinielo bujo ka burum̃ara vameneano tai. ");
INSERT INTO bki_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mia Mere, mijekar vatitig nonovio vite nalo nei jua kiano iviso, maka tiniene ribobogia, naio jom̃a jo jidomiio julaka ga. ");
INSERT INTO bki_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mia tomu nalo nei aban bereio ea kialo nunu nalo, a ajum̃a abamenea Atua siano, a nalo ajum̃a amiaia naio toru laka ka vite kirinovo nalo napano amijogio a amialio, napano kirimemedu ga ka nailiano nei kiano iliano napano berial banlo. ");
INSERT INTO bki_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Telikiti napano kiritete bokar kiano sude takurano, naio be bogo na mia ala pakuveu ea naio. Amila jibe na, kario ajisia ka Yesu, napano sio nei be sio nanua nailiano berial kalo jukamu ruei, avona bisi ana Mere naio be p̃igi kanio. ");
INSERT INTO bki_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Telikiti na Yesu miyotuba sude ari barlaka ruei vo, bisi na be bogo na monoka avuru sida na lakoniano ea Atua Kunuano Lu, nina bior burukija na tira na bar tete. Naruei aba aburu sida nene, jakii tuboiano na Mosis kiano berenio, berinavo “Talim̃asa nalo amijikia aue ga vaama ve juo, p̃eli na kirisibo ve juo.” Ana ka bogo nene, amidu dovorovo Yesu ban ea Atua Kunuano Lu, amiokoio ban Atua. Vite na jakii Mosis kiano tuboiano, na naio berenio “Tete sum̃ano nalo nonovio na amoluo jukamu, nalo abe lu, abe Atua kanano.” ");
INSERT INTO bki_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mia be toro tai joa Atua Kunuano Lu ka bogo na, siano be Simion. Naio be tena vio Yerusalemo ga tai, naio be namemedu tai, a naio be toro tai nam̃a biekouo ea bajago na volkouano. Naio jororea jidom m̃elea ka rial Atua kanano Natinieiiano, nina Naverikariano, rimei ea kulo Israel nalo ea bogokouo nei ajuaio. Mia Simion nei naio be toro tai nam̃a Niununo Lu jojoa m̃a naio nam̃ariga, ");
INSERT INTO bki_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","mia Niununo Lu berial ka naio ruei ka mia naio rivakovio re vo rivano-o mia mirano rialio Atua kiano Naverikariano. ");
INSERT INTO bki_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ana Niununo Lu buru naio binimei ea Atua Kunuano Lu, monloglog bogo na amidu kiritete sesa Yesu binimei, ka ala bajago na tuboiano nene. ");
INSERT INTO bki_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ana Simion midu kiritete nene, ana naio miaia Atua a ber siva banio, berinavo ");
INSERT INTO bki_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tubo toru o, vonganei nemial vite na jau koberkar ka kiniou, naio miyotuba ruei. Mila tum̃aro binimei ea tinieku, ana vonganei jau komijikia kajamo ka kiniou kanamo naim̃auano, nataluvo den yetemeriba nei neviedu. ");
INSERT INTO bki_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ea miraku ga namial kanamo Ioruriano, ");
INSERT INTO bki_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","napano komiila binimei ea tomu kinkin nalo na yetemeriba nei miralo, ");
INSERT INTO bki_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","javukia yulu tai napano jiloglogso ka kulo dolu nalo, a ka mia aiaia kumemi kanamo kulo Ju nalo, bior kenememi mermerano nei, Yesu.” ");
INSERT INTO bki_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ana Yoseve naio Mere, abe juo amiilo toru laka ka Simion kanano iliano nalo nam̃a berii Yesu, ");
INSERT INTO bki_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ana Simion mil bereio, milivu kalo, naruei naio mil ban Yesu kenieno, berinavo “Atua mila kiritete nei binimei ban kito na vio Israel ka rila kito ve telabo rojoru, a kanio rila kito ve telabo rotumolu bereio. Atua mila naio binimei jibe ka kijokijo tai, mia tomu ve telabo ail rivova ka naio, ");
INSERT INTO bki_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ana tibena mia naio rila kialo jidomiano nalo napano m̃a ajuluku nei amalmaluvo ea vio medave. Mia tivelinio ka jau, mia jogvaiano tulu tiniemo tavukia iobogu na mira, mia kanamo iviso rivurup̃eio kar tenalo na napano mia ayotuba ka kenerimo nei.” ");
INSERT INTO bki_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Mia tiramoruo tai bunu jo ka bogo nene, siano Ana, napano naio be naverialiano tai. A Ana nene, karam̃ano siano Vanuele, napano naio miyotuba ea yati na tormoruo Aisere re nua. Naio joro nua ruei, ka bogo na naio be niatira kia ga vo, mia naio jo bija koano ka yuka aluo ga, ana koano m̃aro denio. Naruei naio be taanou jibe na ga, bano-o kiano yuka bokario duelimo va arolu ba veri 84. Naio be tira tai napano monmon ka ga m̃a jojoa m̃a Atua Kunuano Lu, napano naio jom̃a bijurukar bogo na lotuano na kavijo bano-o bokario na kijevi, a dam̃ariga naio mondulu ka m̃a jo bolkouo. ");
INSERT INTO bki_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka bogo na naruei, naio binimei vaataro kalo, ana naio bolkouo, ber siva toru ban Atua bior kiritete nei, a iorou ka nina, naio ba tavio ba jom̃a berii Yesu ban tomu nalo nam̃a aju ajirarag rorea ka Atua rimei rilarur Yerusalemo, mia Ana ber bisivisii banlo ka kanalo Naverikariano naio binimei ruei. ");
INSERT INTO bki_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Telikiti napano Yoseve naio Mere amila nonovio vite nalo nei biniu javukia nam̃a Atua kanano tuboiano berenio, mo Yesu abatove bereio ea kanalo komeli na Nasarete, nina ea tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mia kiritete nene miluo binimei toru, a kiano jidomiano binimei be masou laka, a amial ka napano Atua miija naio ka naio rila vite nonovio rivu ea kiano meuliano. ");
INSERT INTO bki_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana ka yuka nonovio, kulo Ju nalo ajum̃a amila kanalo jokoluolu tai, napano naio be Sidomkariano na Ioruriano. A dam̃ariga, nalo nam̃a aju janea vio dolu, tiniel jii toru ka avavin Yerusalemo ka ala jokoluolu nene, a Yesu kanano tormoruo juo bunu amila jibe na. ");
INSERT INTO bki_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ana ka yuka tai, bogo napano Yesu kanano yuka bokar duelimo ba juo 12 kia ga vo, aban bereio aburu Yesu bijalo. ");
INSERT INTO bki_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mia amila vite nalo na jokoluolu nei bano-o biniu, ana tomu nalo amieliel bere abanvan ea kanalo vio nalo. Mia Yesu naio maka rivano, naio jobo kia Yerusalemo, mia kanano tormoruo juo, maka ajikiaio. ");
INSERT INTO bki_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Naljuo ajidomii aberiam̃a naio jo kovio bija lo bure burum̃ara taara na m̃aratavo bija kanalo bilbilu nalo, mia nalo amiel ba bokar legiano momou takurano. Mia bogiano ana ajirag Yesu bano-o, ");
INSERT INTO bki_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mia maka aialio to vijalo, naruei nalo amial ka monoka atakii bere jaalo ava Yerusalemo alavon ka alealio. ");
INSERT INTO bki_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amiel bogoti takurano momou, abinimei aboru bereio Yerusalemo, nalo ajiragio bano-o, ana ea bogoti dolu nene, be bogoti tolu na kialo ieliano, ana amileal vonga naio, amial naio jom̃a jotano ea Atua Kunuano Lu. Naio jotano bija naverloglogiano nalo na vio na, naio jom̃a mije tiliniene ka kialo iliano nalo, a jom̃a bivika vikadeniano denlo. ");
INSERT INTO bki_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A nalo nam̃a aju vaataro ka Yesu ea bogo na, amiilo toru ka kiano burum̃ara masouano a jikiaiano na, a kanio verdop̃eiano nalo nam̃a naio jian ban nalo nam̃a ajum̃a abika vite denio. ");
INSERT INTO bki_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ana telikiti napano kanano tormoruo juo nalo amial ka napano naio jom̃a mila jibe na, amiilo toru kanio, ana kenieno mil banio, berinavo “!Ai, keneriku! ?Bior vaio ana kojidom ka kala lelan kumemi ve toru tibe na? Keialio, kumemi juo numisiragso-o mia, maka lele nuvilealso, komila kumemi numijog kirivova-o mia.” ");
INSERT INTO bki_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ana ka bogo na Yesu midu verdop̃eiano tai banlo, napano ber jibe nei, berinavo “?Bior vaio ana kubano kumitum̃a kumisirag kiniou janea vio dolu nalo jibe na? Jum̃abe, kamjuo maka kumisidomii ka kiniou monoka notom̃a nala Teta kanano im̃auano joomo ea kunuano?” ");
INSERT INTO bki_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mia verdop̃eiano na ber kalo, maka ajikia ajog lubar nioti nene. ");
INSERT INTO bki_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Naruei Yesu jumolu den vio nei, ana naio ban bijalo, abatove bereio ea kanalo vio Nasarete. Ana Yesu jobo bijalo ea vio na, naio jo mijogkarlo bo dam̃ariga. A kenieno Mere naio jom̃a jidomikar vite nalo nei joomo ea kanano iviso bogo nonovio. ");
INSERT INTO bki_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mia yuka nalo aju abinimei abarlaka bano, mia Yesu jo miluo binimei toru nonovio, a kiano masouano bija kiano moroano jo binimei toru lie vo, mia Atua jo milivu kanio toru laka, mila ana tomu nalo amial naio bo laka, ajaaro toru kanio. ");
INSERT INTO bki_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Yuka tealo bar laka ruei vo bisi, ana Jone Baruei, Sakaraia kenerinio, naio miyotuba ea vio yauo. Nina ea bogo na burum̃ara parinio tubo Taiperias Sisa na vio Romo naio be tubo bokar kiano yuka duelimo ba jimo ruei, ana ka telikiti na naio bitiri bulag kanano tomu na tortoru nalo tai ruei, jibe Pontas Pailat, naio mije tuboiano ea vio Yutea, a Erot, naio mije tuboiano ea vio Kalele, a kuruano Vilip, naio mije tuboiano ea tano na vio Ituraia bija Trakonaetis, a Lesanias, naio mije tuboiano ea tanobuku na vio Abilini. Ana ka bogo na bunu, parinio kulo lu juo napano m̃a aju Yerusalemo, be Anas naljuo Kaivas. Mia Jone joa vio yauo, ana Atua jian iliano ban naio, ");
INSERT INTO bki_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","naio ba jeliviv ea tanobuku nalo na Yortano, naio jom̃a mioliolu berinavo tomu nalo monoka aviliglo, a avaruei, tibe na ana mia Atua riviekokoa kanalo kariano nalo. ");
INSERT INTO bki_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Naio mila javukia ga na nanua m̃a Naverialiano Aisea naio ber nua ruei ea kiano niosi, napano m̃a berenio “Niono tai naio jo bio ea vio yauo, berinavo: Kuvila vatitig Atua kanano m̃arabo nalo, ka naio mijikia rimei ea kenemiu meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mia monoka kuvitiviniko bop̃ap̃ili nalo, a monoka kuvikili bulag yasuku nalo avatove rivu, a vio nalo na jorokoro monoka nalo amemedu rivu, a vio nalo nam̃a jukujukuduo monoka nalo aierivin rivu; ");
INSERT INTO bki_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","tibe na, ana mia taara nonovio na tomu nalo aial kialo Ioruriano napano Atua riila riel ea m̃arabo nei riyotuba kalo.” ");
INSERT INTO bki_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Im̃auano na be Jone kanano, naio jo ka m̃a rioliolu tibe na naruei, mia telikiti na tiniobi toru aba tavio ea vio yauo ka naio rivaruei ealo, naio mil jikili banlo, naio ber jibe nei berinavo “Kamiu na kumitibe ka maro nalo ga napano amerou ka sebi tai ana aburo, mia kuberiam̃a kumijikia kuvuro ka buruta kenieno sebi na mia Atua rionio rimei? Makanio, bior maka kuvilig kamiu vatitigio vo. ");
INSERT INTO bki_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mia ver kube riano ka napano kumerou ka vironiano nei, kenemiu meuliano monoka avar m̃arati nabo napano rivare ka kenemiu viligiano nene. Mia kuvitikar, kuve re m̃arou bereio, tibe ka nam̃a kumila ruei, nam̃a kumitum̃a kuberinavo ‘Ee, kito roju bo ruei, bior kito naruei robe Epraamo kiano yati nalo memedu kia nei.’ Mia nina maka titenia, bior ver Atua sidom, naio mijikia rivar puruveru nalo na ga rim̃aukalo ave Epraamo kanano yati ve telabo, ka mia adu jelemiu. ");
INSERT INTO bki_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kiniou neber ka kamiu, ka m̃aryekesi jo ruei ka te bulag buruiesi nalo na maka avar m̃arati nabo, ka avukulo avan ea burutinia sebi.” ");
INSERT INTO bki_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Telikiti na tiniobi neibano amijogio amerou mia amerou, ana abika aberinavo “Mo aver tibe na, ana mia kumemi nuvila tum̃abe naruei?” ");
INSERT INTO bki_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ana Jone berdop̃elo, berinavo “Toro na m̃ano kulukoti juo, mia monoka naio rijamo ka tinene van toro na maka ve m̃ano tai; a toro na be sano sinaniano miroano, mia naio monoka riviovio ka tealo van toro na maka ve sano taio.” ");
INSERT INTO bki_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A tomu na takis, nam̃a abe tomu na jukujukuano memedu, telabo bunu abinimei ka Jone rivaruei ealo, mia nalo bunu abitilubar kialo vovaiano nalo, naruei abika bunu aberinavo “?Naverloglogiano, tum̃abe ka kumemi, mia monoka nuvila tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana naio ber kalo, berinavo “Mia kuvar den tomu nalo rive verare ka ga nana mia monoka avuluio, mia to loa re, tibe ka nam̃a kumilala mugaruei.” ");
INSERT INTO bki_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mia tomu na mira tealo bunu abika jibe na ka Jone, aberinavo “?Mia kumemi, nuvila tum̃abe?” Naruei naio ber kalo, berinavo “Kamiu kubar kenemiu tenalo na mira ana tomu nalo aju amerou laka ka kamiu, mila na bogo napano kamiu kumisidom vite tai, kuber ga, ana nalo monoka ajamo bior napano amerou. Mia bajago na, mia monoka kuvila re bereio. A kamiu kumitum̃a tiniemiu mimi dam̃ariga ka kuber tom na tortoru nalo ajum̃a abulu kamiu telisu ga, p̃eli bare ga kovio vo, mia kamiu monoka kuvisaaro ga kanio.” ");
INSERT INTO bki_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mia ea bogo na, kulo Ju ajidomii aber kialo Naverikariano vaataro ka maluvo, ana nalo amijog Jone kiano ilinovoiano nalo nei, ana nalo ajaaro kanio, naruei vikadeniano joa kialo jidomiano, ajum̃a abivika, aberinavo “?Aa, p̃eli toro na naruei, p̃eli naio be kiado Naverikariano koviobo?” ");
INSERT INTO bki_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mia Jone naio jom̃a ber lubarbario banlo, naio berinavo “Makanio, kiniou nebinimei jukamu, nojom̃a nabaruei ea kamiu ka uei ga, mia be toro dolu tai napano naio jo binimei iorou ka kiniou. Toro nene, naio loa lie vo ka kiniou, mia kiniou maka navare ka neialar kanano kulubue na jaano, p̃eli nala kanano im̃auano dolu tai. Mia naio naruei, mia rivaruei ea kamiu ka Niununo Lu, rivija kanano sebi, ka risebi kon niamiamo nono den kenemiu meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Naio jibe ka napano naio midukar burup̃ia m̃artea tai, ka mia rikurkar ka uiti nalo, rip̃ilig kon m̃arati nalo. Tibe na, ka mia naio rivar m̃arati uiti nabo nene ava vonuo, mia naio rivuku vinikiti nene rivan ea sebi tai napano mia maka rijikia rim̃aro bogo tai.” ");
INSERT INTO bki_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nina naruei, Jone Baruei naio jom̃a mioliolu ka ioluano vou nabo ban tomu nalo jibe na naruei, a naio jom̃a ber iliano dolu nabo telabo ka tunukakarlo, a ka rilabonlo. ");
INSERT INTO bki_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mia be toro tai naio tiniene maka saaro ka Jone nene leleio, nina be Parinio tubo Erot, bior ka napano Jone naio jom̃a mil banio ka napano naio burular tira nei Erotias, napano kuruano koano, mia mil banio bunu ka vite dolu telabo napano jom̃a milaio. ");
INSERT INTO bki_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mia loa ka kanano vovaiano dolu nalo, Erot tinien jer Jone banbano-o deio, ana jumolu buku naio ban ea yimo na lakoiano. ");
INSERT INTO bki_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mia bogo na Jone maka rivan ea yimo na lakoiano vo, naio jom̃a baruei ea tomu nalo banbano-o, mia bogo tai ana Yesu bunu binimei ea vio nene, ana na Jone baruei ea naio bunu. Naruei telikiti na Yesu jaluvo den uei, naio jom̃a bolkouo, ana vio mave betavo, ");
INSERT INTO bki_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","naruei Atua kanano Niununo midu niabene, naio batove binimei jibe ka vaama tai, binimei bujo jua naio. Ana na Atua mil jel mave batove berkanio, berinavo “Jau kobe keneriku na, nam̃a nejidomso toru laka. Tinieku joaso, tinieku jaaro toru kaso.” ");
INSERT INTO bki_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mia iorou ka na Jone baruei ea Yesu, ana na naio jikar kiano im̃auano naruei, ana ka bogo na, naio kiano yuka bokar duelimo va rolu. Mia yati na Yesu miyotuba eaio, nina tivelinio ka sum̃ano, jikar ea Yoseve, napano amial jibe ka naio be Yesu karam̃ano, naio jo ban jibe na: Yoseve, naio be Eli kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli naio be M̃atata kenerinio M̃atata naio be Livai kenerinio Livai naio be Melki kenerinio Melki naio be Janae kenerinio Janae naio be Yoseve kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoseve naio be M̃atateas kenerinio M̃atateas, naio be Amos kenerinio Amos, naio be Neam kenerinio Neam, naio be Esli kenerinio Esli, naio be Nagae kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae, naio be M̃at kenerinio M̃at, naio be M̃atateas kenerinio M̃atateas, naio be Semein kenerinio Semein, naio be Yosek kenerinio Yosek, naio be Jota kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota, naio be Joanan kenerinio Joanan, naio be Resa kenerinio Resa, naio be Serupapele kenerinio Serupapele, naio be Sieltiel kenerinio Sieltiel, naio be Neri kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri, naio be Melki kenerinio Melki, naio be Adi kenerinio Adi, naio be Kosam kenerinio Kosam, naio be Elm̃atam kenerinio Elm̃atam, naio be Ere kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere, naio be Yosua kenerinio Yosua, naio be Eliesa kenerinio Eliesa, naio be Jorim kenerinio Jorim, nao be M̃atat kenerinio M̃atat, naio be Livai kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai, naio be Simion kenerinio Simion, naio be Yuta kenerinio Yuta, naio be Yoseve kenerinio Yoseve, naio be Jonam kenerinio Jonam, naio be Eliakim kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim, naio be Melea kenerinio Melea, naio be Mena kenerinio Mena, naio be M̃atata kenerinio M̃atata, naio be Netan kenerinio Netan, naio be Teviti kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Teviti, naio be Jese kenerinio Jese, naio be Ovete kenerinio Ovete, naio be Boasa kenerinio Boasa, naio be Sala kenerinio Sala, naio be Nesono kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nesono, naio be Aminatapo kenerinio Aminatapo, naio be Atmin kenerinio Atmin, naio be Ani kenerinio Ani, naio be Esrono kenerinio Esrono, naio be Peres kenerinio Peres, naio be Yuta kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuta, naio be Yakovo kenerinio Yakovo, naio be Aisak kenerinio Aisak, naio be Epraamo kenerinio Epraamo, naio be Tera kenerinio Tera, naio be Nao kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao, naio be Seruk kenerinio Seruk, naio be Reu kenerinio Reu, naio be Pelek kenerinio Pelek, naio be Epa kenerinio Epa, naio be Sela kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela, naio be Kaenan kenerinio Kaenan, naio be Avaksati, kenerinio Avaksati, naio be Sem kenerinio Sem, naio be Noa kenerinio Noa, naio be Lamek kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek, naio be Metusela kenerinio Metusela, naio be Inok kenerinio Inok, naio be Jarete kenerinio Jarete, naio be M̃alalel kenerinio M̃alalel, naio be Kaenan kenerinio ");
INSERT INTO bki_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaenan, naio be Enos kenerinio Enos, naio be Sete kenerinio Sete, naio be Atam kenerinio ana Atam, naio be Atua kenerinio. ");
INSERT INTO bki_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Naruei telikiti na Yesu naio binimei bereio ea tanobuku na marauei na Yortano ea vio na Jone baruei ea naio, naio binimei bujo vatitig ka Niununo Lu. Ana na Niununo buru Yesu ban ea vio yauo bereio, ");
INSERT INTO bki_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mo naio joa vio na bano-o bokar bogoti duelimo va veri 40, napano mia sim̃aro nalo kanalo parinio tubo nei jom̃a milalilio. A ka bogoti nalo na, naio maka m̃a to sinano, banbano-o na mijog ka jijer naio. ");
INSERT INTO bki_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana Setano nene binimei, berinavo “Ver jau kobe Atua kenerinio riano, jau kover von ka puruveru na ka rimei rive joko, ka kosenio.” ");
INSERT INTO bki_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ana Yesu berdop̃e, berinavo “Maka leleio, bior Iliano Lu naio ber ruei, berinavo ‘Maka toro rijikia rila toro rimeul ea sinaniano ga.’ ” ");
INSERT INTO bki_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ana na Setano jidom rilavon Yesu bereio, naruei naio buru kanano jidomiano bavin ea burum̃ara burusuku tai. Ana vaarakurano ga naio jiloglog buruvenuo nalo na yetemeriba nei kanio, ");
INSERT INTO bki_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ana naio berkanio, berinavo “Navitikariano na vio nalo na, bija kialo mermerano nonovio nalo na, ajua jum̃aku ruei. Kiniou nabar siano kario, ka namijikia najamo ka van kei napano tinieku ka naio. ");
INSERT INTO bki_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mo, ver jau kojorua jaaku ga, kobolkouo ka kiniou ga, mia kiniou najamo ka vite nalo na riviniu tua jum̃amo.” ");
INSERT INTO bki_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mia Yesu berdop̃e, naio berenio berinavo “Iliano Lu naio berenio ber ‘Jau kobolkouo ka Atua ga, jau monoka kala kanano im̃auano naio ve takurano ga, bior naio ga be kanamo Tubo.’ ” ");
INSERT INTO bki_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Naruei Setano naio jidom rila-von Yesu bereio, naio buru kiano jidomiano ba Yerusalemo, midu naio jo levlevi ea vio tai, mave ea Atua kunuano, ana berkanio, berinavo “Ver jau kobe Atua Kenerinio, koviako yetano. Ver jau kalaio, mia rivu ga na, ");
INSERT INTO bki_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","bior Iliano Lu berii Atua, berinavo ‘Naio mia riila kiano nailiano nalo, ka mia amei atu avitiikarso, atukuku kaso. ");
INSERT INTO bki_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mia aisopkarso mave ga ka jum̃alo ka mia kavan re jaamo ea puruveru.’ ” ");
INSERT INTO bki_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mia Yesu berdop̃e naio bereio, berinavo “Maka leleio, bior Iliano Lu ber bunu ber ‘!Jau kolavon re Tubo kiamo Atua ka naio rila kanamo vite tai!’ ” ");
INSERT INTO bki_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mia telikiti na Setano mila juboluboiano nalo nei bisi, ana buro denio, ba jo rorea ka rileal bogo dolu tai napano naio jidom ber mia mijikia tovulu Yesu eaio. ");
INSERT INTO bki_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Karina, Yesu miel ea moroano na Niununo Lu, binimei boru Kalele, mia tomu nalo ajum̃a aberii naio banbano-o ba bokar vio nonovio ea tanobuku nei. ");
INSERT INTO bki_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana naio jom̃a ban ea kanalo yimo nalo na volkouano, naio jom̃a berlogloglo, naruei nalo ajaaro toru kanio, ajum̃a amidular siano bavin. ");
INSERT INTO bki_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Bogo tai Yesu binimei boru ea kiano vio Nasarete, vio napano naio miluo binimei toru eaio, ana ka Legiano Lu, javukia nam̃a naio jom̃a mila bogo nonovio, naio ban bijalo ea kanalo yimo na volkouano. Ana aber naio rivuluku bulag Atua kanano Iliano Lu vanlo, ana na amidu niosi nam̃a Aisea naio bivitauia binimei banio. Ana naio jumolu betavo ea niosi nene, mileal vio na naio jidom rivuluku bulag vanlo, ana naio bulukuio, napano naio ber jibe nei, berinavo ");
INSERT INTO bki_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Niununo na Atua kanano naio joa kiniou ruei, bior Atua naio jiloglog kiniou ka kiniou naruei noioliolu ka Ioluano vou nabo rivan talim̃asa nalo. Naio miila kiniou nebinimei ka neverial van nalo na ajua lakoiano, ka vonganei, amijikia avanvan tavio bereio ga tibe na, a ka kiniou neverial ka merebono nalo, ka vonganei, miralo mijikia rimei rivu bereio. A naio miila kiniou, ka tomu nalo nam̃a ajutano, napano kulo dolu nalo ajum̃a amila kikilo julaka, mia kiniou novuru bulaglo, amei atua vio tai nabo bereio. ");
INSERT INTO bki_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tenene na, kiniou nemijikia nala rimeravo, ka vonganei, Atua mila kanano bogo vou nabo tai miyotuba ka tomu nalo nene naruei.” ");
INSERT INTO bki_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Telikiti na Yesu buluku nina bisi, ana na mijukukarko niosi nene, jian ber ban tikon, ana naio ba jotano mave ea jeleigio vio nam̃a amioliolu eaio, ka naio ril van tomu nalo. Naruei nalo abiniu napano aju joomo aju abiti kilkil ea Yesu ka ajog ka venia napano mia naio river kalo. ");
INSERT INTO bki_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Mia bogo napano naio jikar kiano iliano, naio ber jibe nei, berinavo “Kiniou neber ka kamiu, ka Atua kiano Iliano Lu na kumijogio vonganei, iliano nalo nei kanano abinimei be riano bo vonganei ga, ea miremiu.” ");
INSERT INTO bki_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mia telikiti na tomu nalo amijog Yesu kiano iliano nalo nei, amijog jibe ka naio mil bo mia bo, melokloko a m̃adigdig, mia nalo abameneaio toru, ajum̃a aberverenio jibe nei, aberinavo “!Ana kema na, naio be Yoseve kenerinio ga na! ?Mia naio jom̃a bar tanea iliano novo nalo na ea vio be?” ");
INSERT INTO bki_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ana na Yesu berdop̃elo, berinavo “P̃eli kumisidom kuver kanado iliano moruo tai ka kiniou, napano ber ‘Nakulekuleano, jau kala vatitigso beamu vo, karina jau komijikia kajai tomu dolu.’ Nina bior kamiu kumijog ruei ka bogo napano nojo yako Kapeneam, nojom̃a namieliel ka tomu telabo, tenene na kumitu kumisidomii kuber bior vaio ana maka nemei nala tena van kamiu ea kanado vio nei bunu. ");
INSERT INTO bki_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Be riano never ka kamiu, ka ver naverialiano tai, mia tomu na kanano vio memedu, maka ajikia asaaro kanio, maka ajikia avatove kanio. ");
INSERT INTO bki_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Nina be riano ga. Nejidom ka kamiu kuvisidomii von tormoruo Elaija re nua. Ka bogo na, yuo maka rivovo bano-o bokar yuka tolu togio, a burum̃ara vituiano tai jovuko rera vio Israel. ?Ana Atua miila Elaija ba miija kei ka bogo na? Kam kuvialio, naio maka riila naio rivan ka riija taanou re Israel tai nam̃a aju amijog bova, mia naio miila ba miija taanou na bulukomeli na vio Serevati, nina ea tanobuku dolu na vio Saiton. ");
INSERT INTO bki_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A kuvisidomii von tormoruo Elisa kiano bogo bunu. ?Ka bogo na, tomu miroano na abar burumieni, mia Atua milarur kei? Naio maka rilarur nalo na Israel tai na bokar mieiano nei, mia naio milarur toro re Siria nei, Nomano. Be riano, kito tomu nalo nam̃a roju rober kito robe Atua kiano tomu nalo memedu, mia nalo nam̃a Atua miilalo abinimei ka ala im̃auano van kito, mia kito romielikue kalo ga.” ");
INSERT INTO bki_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ana na nalo napano aju joomo ea yimo na volkouano nei amijog iliano nei, kialo jidomiano bilig ba be dolu, vonganei nalo tiniel jer Yesu toru. ");
INSERT INTO bki_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Naruei nalo ajerm̃i ka Yesu, ana aburio bano, aburu ba tavio ka kanalo komeli, ana aburu naio ba abavin ea burum̃ara yabalili tai napano kanalo komeli joaio ka ajidom avuku Yesu rivatove ea vio na naruei. ");
INSERT INTO bki_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mia Yesu jaluvo den jum̃alo bea ga, ana naio miel jel burelo ga bano, naio juvanlo ajubo. ");
INSERT INTO bki_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ana na Yesu miel batove bokar komeli dolu tai na vio Kalele, nina be Kapeneam, mia ka Legiano Lu berlogloglo ea kanalo yimo na volkouano. ");
INSERT INTO bki_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mia nalo nam̃a amije tilinielo amiilo toru laka, bior amijog Yesu kanano iliano temi bo, a Atua kanano moroano joaio. ");
INSERT INTO bki_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ana ka bogo na, toro tai jo joomo naliko, napano niununo na sim̃aro va tai joa mila bulag naio, mia toro nene miaga m̃erere kirivova tai vo, naio mil ban Yesu, berinavo ");
INSERT INTO bki_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“?Ei, Yesu re Nasarete, kiamo vaio joa kumemi? !P̃eli jau kobinimei ka kalakiki kumemi, a! Bior nemijikiaso ruei, ka kobe Toru Lu nabo tai na Atua kanano.” ");
INSERT INTO bki_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ana Yesu mil jikili ban niadu va nene, berbureio, berinavo “!Ee, abe keil re bunu! Jau kataluvo den toro na vonganei ga.” Ana niununo va nei buku toro nei mijoru iviso burelo, ana na naio jaluvo denio, buro bano, mia toro nei mijog bo bereio jo. ");
INSERT INTO bki_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naruei tomu na vio nei amiilo toru laka, mia nalo ajum̃a aberverii Yesu, aber “Ei, iliano na jum̃abe tenia na? Nina be buruvayukouo tenia, kiano moroano buru tomoruo loa laka. Naio mil ga ban niununo va nalo, mia aburovuro jibe na ga.” ");
INSERT INTO bki_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ana bior tena mia nalo ajaaro, ajum̃a aberial vatitig Yesu siano ba janea vio bokar vio nonovio na tanobuku nei. ");
INSERT INTO bki_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ana Yesu jumolu den yimo na volkouano nei, mia naio ban ea Saimon kunuano, nina ea komeli na Kapeneam kia ga vo. Naruei ea vonuo nei, Saimon kenieno simemi naio jo mon ea m̃ano jogu, mie yulu, niabene bituvitunu, mia aberial ka Yesu, abika den naio aber jum̃abe ka tiramoruo nei. ");
INSERT INTO bki_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Naruei Yesu binimei jikili ju tivelinio ka tira neibano, ana mo naio mil berbure mieiano nei, ana niabene binimei menini nonovio bereio, naio mijog bo bereio, ana jumolu, ba milaii salo sinaniano. ");
INSERT INTO bki_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mia bogo nam̃a m̃erenio batove, jibe ka na Legiano Lu na bisi, ana nalo nam̃a nalo tealo amie ajum̃a, abarvarlo abinimei ban Yesu, ana naio mije jum̃ano monealo, mieliel kalo. ");
INSERT INTO bki_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A telabo kalo, sim̃aro nalo abava tavio denlo, napano ajum̃a amiaga, aberinavo “!Ei, jau naruei jau kobe Atua kenerinio a!” Mia Yesu berbure sim̃aro nalo nei ka mia aver re bunu titai leleio, bior amijikia ruei ka naio be Naverikariano riano. ");
INSERT INTO bki_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mia kavijova kia ga vo, ana Yesu jumolu ana naio takurano batavio den yimo, ban ea vio tai napano be tum̃aro bo. Kar iorou, ana tomu nalo abinimei kanio, ajirag naio bano-o mia amileal naio joa vio nei naruei, ana ajidom naio to naliko, amila vio ka averbure naio ka tuvanlo re, ");
INSERT INTO bki_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","mia naio ber kalo, berinavo “Makanio, monoka kiniou nava noioliolu ka Ioluano vou nabo na navenatuboiano na Atua kanano nei van komeli dolu nalo na aju keano vo, bior amiila kiniou nebinimei ka vite nei naruei.” ");
INSERT INTO bki_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ana naio jaluvo denlo, ba mioliolu janea yimo na volkouano nalo ea komeli nonovio na tanobuku nei Yutea. ");
INSERT INTO bki_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bogo tai, ana Yesu joa yaba ueiyabo na toru nei, nam̃a tomu tealo ajum̃a abio ka Ueiyabo na Kenasarete, a tealo abio ka Ueiyabo na Kalele. Ana ka bogo na, tomu nalo miroano laka ajumolu aju jelviviko Yesu, jibe ka vio telisu ga, bior ajidom ajog naio rioliolu ka Atua kiano iliano rivanlo. ");
INSERT INTO bki_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Mia Yesu mial ka uako sesa juo aju ga vaataro kalo yako, napano aburulo abavauro ajua baramudou ea bayono, a naio mial ka napano tomu nene nalo ajudobi ea tei, ajum̃a ajekon kanalo sup̃ede. ");
INSERT INTO bki_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Mia Yesu miel bano-o biako ea uako sesa nei tinene, napano be Saimon kanano, ana naio berkanio ber naio riyuku lario rivajou lie kija ga. Naruei Yesu jotano ea uako sesa nei, ana naio jom̃a berloglog nalo napano m̃a aju bijilo uro. ");
INSERT INTO bki_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mia bogo na naio mil banlo-o avona bisi, ana naio ber ka Saimon, berinavo “Kito, kiniou nejidom ravajou lie kija koyou von ka rovuku sup̃ede beamu vo.” ");
INSERT INTO bki_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ana Saimon berdop̃e, berinavo “E abe toro na toru, kumemi numisidel ka tena ruei o-o viomijeni nei, maka nuvokar niado tai leleio. Mia bior jau naruei kober ka kiniou jibe na, bo, kiniou najaaro ka rava lie kija bere vo.” ");
INSERT INTO bki_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ana nalo aba amila jakiio napano Yesu berenio, mia amiilo ka burum̃ara taara na niado napano bujo ea kialo sup̃ede, mila kanalo sup̃ede jikar ka buruboṽeio, ");
INSERT INTO bki_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","naruei abio nalo dolu nalo na ajua uako sesa dolu, ajuvanjum̃alo kalo ka amei aijalo. Ana nalo nei abinimei, ana aburu bitiran sup̃ede ka niado nalo nei binimei joomo ea buluku uako, bano-o uako juo nei abujovujo vatitigio, vaataro ka m̃a amadudu. ");
INSERT INTO bki_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mia Saimon Pitere mial tenei, naio bitilubar ka Yesu ga mila tenei ea kiano burum̃ara moroano lu nei, ana minie tano ea Yesu jaano, berinavo “Tubo, kiniou nobe toro na bova ga tai. Bo laka ka kovuro den kiniou, jau kotu re vaataro ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mia maka naio ga ve takurano, mia nalo dolu napano aju naliko ka aura nei, nalo abiniu abameneaio toru laka ka burum̃ara tiniobi na niado na abokarlo, ");
INSERT INTO bki_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","bija bunu Sepeti kenerinio juo nei, Yemesi naio Jone, napano naljuo amiasol Saimon amim̃au vio takurano, naljuo amiilo toru kanio. Ana na Yesu mil ba Saimon, naio berinavo “Ei, jau komerou re ka vite na tibe na. Bior tikar banei, mia jau kovuru bere re niado, mia jau kotom̃a kovuru tomu nalo amei atakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ana nalo abinimei bereio, aburu kialo uako nalo nene abauro bereio, mia maka bunu ala titai, mia ajuvan kialo saba nalo biniu ju bo ga jibe na, ana ajakisor Yesu abano. ");
INSERT INTO bki_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana iorou kanio, ea bogo tai, ana Yesu joa komeli na vio na tai, ana toro tai mialio, binimei ka naio, napano toro nene, mieiano na burumieni mila tanea niabene-e mia mila bulagio laka. Naruei naio binimei mijoru ea Yesu jaano, jegi banio, bika jikili denio berinavo “!Tubo! Kiniou nomoneaso jikili ka jau komijikia kalarur kiniou bereio, mia ver jau komijamo, kiniou nejidom nevikaso ka jau kalakon kiniou ga.” ");
INSERT INTO bki_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mia Yesu maka rienien ka tokol kiano menko nene, mia midu jum̃ano joaio, naio berinavo “Nao, kiniou nejidom komeravo.” Mia vaarakurano ga niabene meravo, burumieni nei m̃apm̃apvo denio. ");
INSERT INTO bki_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ana na Yesu berkanio, berinavo “Komijog, jau kava koverii re tenei ka toro tai vo, mia vonganei ga jau kejaka kava kesel ea toro lu ka naio riia veveso mia mijikia riverial niabemo meravo ruei. Karina monoka kava kolotu van Atua a keisebi sida na kanamo lakoniano, tavukia nam̃a Mosis naio ber monoka alaio.” ");
INSERT INTO bki_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesu naio ber toro nei naio riva riverii re vite nei, ana deio ga, maka vesiou ana ajum̃a aberverii Yesu banbano-o, ba bokar vio reraio biniu, mila ana tiniobi na toru aju abinimei ka ajog kiano iliano nalo, a ajidom ka rilarur kialo mieiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mia ka bogo nalo nene, Yesu jom̃a miel batavio ea tomu nalo bunu, naio jom̃a janea vio yauo, bolkouo ban Atua. ");
INSERT INTO bki_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mia ka bogo tai, ana Yesu jom̃a berlogloglo, mia Varisis tai naliko naverloglogiano na tuboiano ajum̃a ajutano ea vio nei, napano nalo abe nalo na komeli dolu nalo na tanobuku na Kalele bija Yutea, a tealo ajuvan vio Yerusalemo abinimei. Ana ka bogo na, Atua kiano moroano jo binimei toru nonovio ea Yesu, mila ana naio mijikia milarur tomu na mieiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ana tom tai ap̃ier toro na mieiano tai binimei, napano niabene biniu m̃aro, mia nalo ap̃ier binimei, naio mon ea ga m̃ano jogu. Ajidom adu naio riva joomo rimon vaataro ka Yesu, ");
INSERT INTO bki_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mia amial tiniobi toru jo joomo ruei, mia vio nene telisu laka, maka ajikia adu kialo bilbilu rivano. Naruei amidu naio abavin ea yimo, ana amijag bulag vodobi mave memedu ka vio na Yesu jotano loglogio, ana ajuvarvan toro nei bija m̃ano jogu batove ea buluvio nene ba jotano iviso ka tomu nalo, kamu kean Yesu mirano memedu. ");
INSERT INTO bki_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mia bogo na Yesu mial vite nei, mijikia ka nalo aju abiekouo kilkilii ea naio ka mia naio rijai toro na mieiano nei, ana naio berkanio berinavo “Koig, kiniou nebiekokoaso ka kiamo vovaiano nalo.” ");
INSERT INTO bki_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mia bogo napano Varisis nalo bija naverloglogiano na tuboiano nalo amijog iliano nei, aju ajidomii kirivova-o mia, naruei nalo ajum̃a abivika denlo, aberinavo “?Kei tenia m̃a jo mil niegeniege tolu na Atua siano jibe na? Atua ga takurano naio mijikia riviekokoa kariano, maka toro dolu bereio, mia tete na naio jom̃a mil jibe na ka jo jidom ber naio naruei, naio be Atua ruei kovio.” ");
INSERT INTO bki_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mia Yesu mijoglubar ea naio ka ajum̃a ajidomii kirivova jibe na ka naio, ana ber kalo, berinavo “?Kar venia ana tiniemiu nalo bujo ka jidomiano na kirivova jibe na? ");
INSERT INTO bki_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ver never ka toro na mieiano nei, neverinavo ‘Kiniou nebiekokoaso ka kanamo kariano,’ p̃eli kiniou never kanio neverinavo ‘Jau kotumolu, keiel,’ ana ea iliano juo nei, tinene jikili ka averenio, a tinene naio monmaio ga. Nana berenio ‘Jau kotumolu, keiel’ naio jikili lie, bior mia kamiu kumijikia kuvitilubar ka kanaku iliano nei naio be riano p̃eli na makanio, ka napano toro nei naio jumolu p̃eli maka tumolu. ");
INSERT INTO bki_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mia vonganei, kiniou noim̃au ka titai na mia kamiu kuveriam̃a Atua ga takurano mijikia rilaio, kanio mia kamiu kuvitilubar ka kiniou Kulorinio Kenerinio nemijev moroano. A kiniou neber ka kamiu, neberinavo moroano nene naruei naio bare ka kiniou nemijikia neviekokoa kariano bunu ea yetemeriba nei. Kamiu kuviagago vatitigio.” Ana Yesu ber ka namieiano nei, naio berinavo “Kiniou neber kaso, ka jau kotumolu, kojukular m̃amo jogu, jau keiel kava vonuo.” ");
INSERT INTO bki_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mo sop̃eli ga, ea mirano tomu nalo na aju amialio, toro nei naio jumolu jibe na, midu m̃ano jogu miel batavio, ana ba vonuo napano naio miaia Atua ga naio jo bano. ");
INSERT INTO bki_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mia bogo na tiniobi nei amial vite nei, abamenea naio toru riano, kuluniabelo p̃ili burevure biorio, a nalo ajum̃a amiaia Atua, ajum̃a aberinavo “!Uerei tom nei, riano ga, banei romial titai napano dolu laka!” ");
INSERT INTO bki_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iorou kanio, ana Yesu miel kiki kija ga bano, naruei naio mial toro tai jom̃a jotano ea kiano vio na totanian na imauiano, joomo ea vio na m̃a barbijii veru na takis eaio. Toro nene siano tai Livai. Ana Yesu bio naio, berinavo “Jau komei katakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mia sop̃eli ga Livai jumolu, juvan kiano im̃auano, juvan kiano saba nonovio ju bo ga jibe na, naruei jakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Karina, Livai nene mim̃auka Yesu sano burum̃ara sinaniano tai ea kunuano, mia ka bogo na, tomu telabo dolu nalo nam̃a abarbijii takis bija tomu dolu nalo na jibe na, nalo bunu abinimei ajutano vio takurano naliko Yesu a kiano naiagagoano nalo ea sinaniano nene. ");
INSERT INTO bki_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mia Varisis tealo, naliko kialo naverloglogiano na tuboiano tealo, amil niege naiagagoano nalo, aberinavo “?Bior vaio ana kumitum̃a kumisinan burukuti kamliko tomu na bova a tom na pariparilo kiri merorol na?” ");
INSERT INTO bki_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mia Yesu naruei naio berdop̃elo, berinavo “Tomu na niabele jikili bo, maka m̃a tiniel tii ka m̃a avan ea toro nam̃a mim̃auka mieiano, mia tomu nam̃a amijogjog mieiano, nalo naruei ajidom naio toru. ");
INSERT INTO bki_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kiniou maka nemei ka novio nalo na ajum̃a aber amemedu ruei kamu ea Atua mirano ka atakisor kiniou, mia kiniou nebinimei bior tomu na bova jibe ka nalo na naruei, ka aviliglo rivior kialo vovaiano nalo.” ");
INSERT INTO bki_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naruei nalo abika vikadeniano tai den Yesu, nalo aberinavo “Jone Baruei kanano naiagagoano nalo ajum̃a abokar jikili bajago nam̃a vatelabo, ajum̃a ajuvan sinaniano kam̃a abolkouo ban Atua, a Varisis nalo bunu ajum̃a amilala jibe na. ?Mia bior vaio ana kanamo naiagagoano nalo maka atum̃a alalaio?” ");
INSERT INTO bki_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ana Yesu berdop̃elo, berii naio bija kiano naiagagoano nalo, jibe ka napano amijog bo laka ka bogo na naio jo naliko, ana mia ajog rivova iorou ka bogo na ver naio taluvo denlo. Naio berinavo “?Bogo na toro na soriano naio jo kean ea jokoluolu naliko kiano bilbilu nalo, kuberiam̃a mia amijikia atuvan sinaniano na jokoluolu nei to, asenio re? P̃eli ga. ");
INSERT INTO bki_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mia ve bogo tai rimei napano mia avurular toro na soriano nei denlo, mia ka bogo na naruei mia nalo amijikia atuvan sinaniano bior amijog bova toru kanio.” ");
INSERT INTO bki_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bajago nam̃a ajuvan sinaniano na, naio be bajago moruo tai na kulo Ju nalo kanalo lotuano, mia Yesu jidom rila rimeravo vanlo ka bajago moruo nalo na jibe na, maka ajikia atusol vite vou nalo nam̃a naio jom̃a berloglog kalo. Ana naio beri jamerijiano tai kalo. Naio berinavo “Jau maka kejikia kavar niati kulum̃arauo tai na be terivou, kejedep̃e lario niati nene tai, ana jau kotuluko ka kulum̃arauo na be terimoruo ka toko vio na burup̃e be bulukuti eaio. Ver tibe na, jau komijedelar kule ga niakulm̃arauo vou nene kurano ga, a niati nene, mia keial ve kirivova-o mia. ");
INSERT INTO bki_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A jau maka kejikia koison m̃arjum̃elm̃elu vou napano jom̃a jarabujo kia ga vo rivan ea kulukuti nani napano be terimoruo nam̃a amison m̃arjum̃elm̃elu vatelabo ban ea ruei. Ver jau kala tibe na, mia m̃arjum̃elm̃elu vou nei riyukuio, mia rila kulukuti nei saburu, ana mia m̃arjum̃elm̃elu nene riiou kule ga na, mia bati nene bunu rimei rivova. ");
INSERT INTO bki_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mia m̃arjum̃elm̃elu vou, monoka jau koison rivan ea kulukuti nani na be terivou bunu, na jikili bo, naruei komijikia kodu vatitigio m̃amo m̃arjum̃elm̃elu to rivu eaio. ");
INSERT INTO bki_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A bunu, bogo nam̃a tomu nalo ajum̃a amunu m̃arjum̃elm̃elu na amim̃auka jiou kija ruei, mia asaaro re bunu ka amunu m̃arjum̃elm̃elu vou napano amim̃auka vonganei ga, mia monoka averenio m̃arjum̃elm̃elu moruo nei naio jesei kiano vo.” ");
INSERT INTO bki_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Naruei ka legiano tai bereio, napano naio be Legiano Lu, Yesu naliko kiano naiagagoano nalo ajum̃a amiel abano, mia kanalo m̃arabo naio ba jel bure tiniavio na kon. Amiel jibe na naruei, mia naiagagoano nalo jijerlo naruei ana nalo ajavo bulag m̃arati tealo abal kon avona bisi ajenio. ");
INSERT INTO bki_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ajum̃a amila jibe na, mia Varisis nalo tai ajua vio na ka bogo nene, napano aju amial Yesu nalo, naruei nalo aberinavo “!Ai, bior vaio kumitu kumila im̃auano na ea Legiano Lu jibe na? Jibe na, kamiu kumitu kumilakorov kanado tuboiano ga na.” ");
INSERT INTO bki_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ana na Yesu berdop̃elo, naio berinavo “?Ii, p̃eli jibe na kovio, ana kamiu maka kuvuluku ea Iliano Lu bogo tai vo, ka vite nalo nam̃a Parinio tubo Teviti re nua jom̃a milaio? !Kamiu kumijikia ruei tena! Naio naliko kiano tomu nalo jijerlo toru laka, ");
INSERT INTO bki_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","naruei naio ba joomo ea Atua kiano Yimo Lu, mia midu joko lu nam̃a tuboiano berenio kulo lu ga nalo amijikia asenio, mia Teviti nalo ajenio.” ");
INSERT INTO bki_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ana Yesu ber kalo, naio berinavo “Kiniou Kulorinio Kenerinio, kiniou naruei nebe Tubo ka Legiano Lu, mia nemijikia neverenio venia na memedu ka mia alaio ea Legiano Lu, p̃eli na venia na maka rimemedu ka mia alaio re ea Legiano Lu.” ");
INSERT INTO bki_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ana ea Legiano Lu dolu bereio, Yesu ba ba joomo bereio ea yimo na volkouano, mia naio berlogloglo. Mia ka bogo na be toro tai bunu jo joomo napano jum̃ano tivelinio vameruo be jumevuluku. ");
INSERT INTO bki_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Naruei naverloglogiano na tuboiano nalo bija Varisis nalo, napano tiniel jer Yesu ruei, aju vaataro ka naio ka bogo nei. Nalo ajum̃a abitikuku vatitig bo ka naio ka alavon ka aleal bajago na bova tai eaio, jibe na naruei ajidom aial ka mia rieliel ka jumevuluku ea kialo Legiano Lu nei p̃eli na mia rila re. ");
INSERT INTO bki_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mia Yesu mijikia batitig bo ruei venia napano jo joomo ea kialo jidomiano nalo, naruei naio mil ban kema neibano, naio berinavo “Jau kotumolu, komei, kotu mave ea vio nei beamu vo,” naruei toro neibano jumolu bano. ");
INSERT INTO bki_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ana na Yesu bika den nalo neibano aju nei, naio berinavo “?Kiado tuboiano ber kito romijikia rala venia ka Legiano Lu nalo? ?Naio berenio bo ka kito rala tena bo p̃eli na bo ka rala tena bova? ?Naio ber bo kanio kito ralarur kulorinio, p̃eli na bo kanio rouebin toro rim̃aro?” ");
INSERT INTO bki_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ana Yesu barp̃ilig, naio bitiilo abiniu jeliviv, avona bisi ana na naio ber ka toro neibano bereio, berinavo “Jau kovitirii jum̃amo vonio.” Mia monloglog bogo neibano ga toro nei naio mila jibe na, mia jum̃ano binimei bo vatitigio bereio. ");
INSERT INTO bki_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mia Varisis nalo tinielo kiri mimi, bano-o m̃a tinielo bitunu mia bitunu vatitigio laka, naruei nalo abava tavio aber vonvon ka mia ala tum̃abe ka Yesu. ");
INSERT INTO bki_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ana iorou ka bogo dolu bereio, Yesu jaluvo denlo ban ea burusuku na toru tai ka tom̃a rivolkouo van Atua, naruei naio jo mila jibe na ea vio nene bano mia viomijeni konio garuei. ");
INSERT INTO bki_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ana kavijo nene naio binimei bere, bio kiano naiagagoano nalo abinimei vio takurano ea naio, mia ea nalo nei naio berial nalo duelimo ba juo, napano bitiri bulaglo, berenio nalo nene naruei nalo abe atevi. ");
INSERT INTO bki_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mia duelimo ba juo neibano, sialo nalo ajibe nei: Saimon napano Yesu midu sio dolu ban ber Pitere, a Andru, na naio kuruano, a Yemesi, a kuruano Jone, a Vilip, a Bartolomio ");
INSERT INTO bki_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","a Mataiu, a Tomas, a Yemesi, napano Alveas kenerinio, a Saimon, nanua m̃a mila poletik, jidom ka rijil bulag kulo Romo, a Jutas, na Yemesi kenerinio, ");
INSERT INTO bki_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","a Jutas re Kariot, napano karina naio jiveluku ka Yesu. ");
INSERT INTO bki_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mia Yesu buru atevi nalo neibano abatove bereio, ana amileal vio vodobi tai, ana aba ajuaio. Ana ka bogo na, vio bujo ka Yesu kiano naiagagoano nalo miroano dolu nalo bunu, naliko burum̃ara tiniobi nalo na komeli dolu na vio Yutea, a kulo Yerusalemo bunu bija bunu tomu na vio Taia a tom na vio Saiton napano ajumormolu den kialo vio rove yako ea tei na toru abinimei. ");
INSERT INTO bki_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nalo nei abinimei ka ajidom ajog Yesu kiano iliano nalo, a bunu ajidom ka naio rieliel ka kialo namieiano nalo. Naruei Yesu milaiilo jibe na bano-o, ba bokar bunu tomu nam̃a niadu jualo m̃a mila lelanlo vururu. ");
INSERT INTO bki_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tomu nalo miroano laka, mia abiniu ga ajidom atokol Yesu, ka avokar kija burum̃ara moroano nam̃a amial jom̃a miyotuba ea naio, napano m̃a jo mila batitig tomu nalo miroano ruei. ");
INSERT INTO bki_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ana na Yesu jom̃a bitii kiano naiagagoano nalo nene, karina naio berlogloglo, naio berinavo: “Kamiu nam̃a kubitilubar ka m̃a kube talim̃asa, ilivuiano toa kamiu, bior kamiu naruei, Atua naio be Parinio Tubo ka kamiu, mia naio vitikar kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Kamiu nam̃a jijer kamiu vonganei, ilivuiano toa kamiu, mia kamiu kuvijog ka kamiu kubinimei kuvujo vatitig ka vite novo nalo. Kamiu nam̃a kamiu kumitum̃a kumiteg vonganei, ilivuiano toa kamiu, mia kamiu kumijikia kuvisaaro.” ");
INSERT INTO bki_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kamiu nam̃a tomu nalo maka asaaro ka kamiu, a napano m̃a maka asidom kamiu, a napano m̃a amil niegeniege lelan kamiu, a napano m̃a abuku bulag siemiu nalo aberinavo kamiu tomu na kirivova ga, nina bior kamiu kube kiniou Kulorinio Kenerinio kanaku tomu nalo, ilivuiano toa kamiu bunu.” ");
INSERT INTO bki_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ka bogo nalo na jibe na, kamiu kuvisidom bijovijon re, mia kuvitatabujo vija saariano, bior ajum̃a amila lelan kamiu ea ga bajago na nanua m̃a korobilo nalo amilaio ban naverialiano nalo re nua. Mia naio bo ga, mia kamiu kuvijev burum̃ara ijaiano nene ea vio mave.” ");
INSERT INTO bki_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mia kamiu tomu na sanibaiano mia rivova ve toru laka van kamiu, bior kamiu kubar kenemiu jogvuiano a kenemiu saariano na kenemiu meuliano nabo na ruei ea yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Mia kamiu nam̃a mabomiu bujo batitig ruei jo, mia ve kirivova laka rivan kamiu, bior mia siser tanea kamiu ve toru laka. A kamiu napano kumitum̃a kubital banei kia ga vo, mia rivova laka rivan kamiu, bior mia kamiu kuvijog rivova ve toru laka mia kuviteg ve toru.” ");
INSERT INTO bki_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mia kamiu monoka kuvitikar vatitig bogo napano tomu nalo aju amiaia siemiu. Verver tibe na, maka rivu ka kamiu bunu kuvisidomii kuver kubo, bior napano naverialiano sibisibiano re nua, kiado tormoruo nalo, ajum̃a amiaia sialo, mia Atua bitiilo abova ga, naruei naio mije vironiano banlo.” ");
INSERT INTO bki_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ana na Yesu berenio, berinavo “Kamiu nam̃a kumijoglubarbar kanaku iliano, kiniou neber ka kamiu, neber: Monoka kito rosidom kanado uolu nalo, a monoka rovijuku rivu ka nalo nam̃a maka asidomii kito, ");
INSERT INTO bki_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","a monoka reilivu ka nalo nam̃a amiolua kito, a monoka robolkouo kalo nam̃a ajum̃a amila kiki kito. ");
INSERT INTO bki_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Verenio toro tai rujuba kulbibimo tivelinio, monoka jau kovilig kulbibimo tivelinio vanio ka rijikia rijuba bunu, mia verenio toro tai sikili ka rivar m̃amo koti, mia kasaaro ga ka kajamo ka m̃amo soto bunu van naio rivario. ");
INSERT INTO bki_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mia ver toro tai rivika kiamo titai, monoka jau kajamo ka rivanio, a ver toro tai rudular kanamo titai, mia jau kovika re bunu ka rudu merano bere rivanso. ");
INSERT INTO bki_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bajago na vabe nam̃a jau kojidom ka tomu nalo ala vanso, bajago nene naruei monoka jau kala rivanlo. ");
INSERT INTO bki_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mia ver kito rotum̃a tiniedo riia ga nalo na ga m̃a ajidom kito, nina maka ve titenia, bior tomu na kariano nalo tiniel jii tomu nalo nam̃a aju ajidomlo mugaruei. ");
INSERT INTO bki_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","P̃eli na ver rotum̃a rovijuku rivu ka ga nalo nam̃a abijuku bo mugaruei ka kito, naio bunu maka rive titenia, bior tomu na kariano nalo, nalo bunu ajum̃a amila jibe na mugaruei. ");
INSERT INTO bki_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","P̃eli na ver rotum̃a rajamo ka veru van nalo na ga amijikia avar meran bereio, naio bunu maka ve titenia, bior tomu na kariano nalo, nalo bunu ajum̃a amilala jibe na mugaruei. ");
INSERT INTO bki_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Mia kiniou neber ka kamiu, neberinavo: Monoka tiniemotii kanamo uolu, a mia kovijuku rivu kanio, a mia kajamo ka kanamo veru tibe na ga, napano kosidom bijovijon re ka na naio bario, ka mia naio mijikia rivar kean bogo tai, p̃eli na mia naio rivar kean lele re bunu. Mia ver jau kotom̃a kalala tibe na, kojom̃a kabar bajago na karam̃ado, Toro na Loa laka, mia naio sian kanamo ijaiano tai na mia ve toru lie vo, bior naio be toro tai napano kiano iviso bo ga ka nalo na maka atu aver siva vanio, p̃eli na nalo na ajum̃a ajidomial nalo ga bereio. ");
INSERT INTO bki_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ver tibe na, jau monoka tiniem riia tomu nalo tavukia nam̃a karam̃ado tinien miialo.” ");
INSERT INTO bki_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mia Yesu mil kia ga banlo vo, naio berinavo “Mia kamiu monoka kuvitu re m̃a kuvitibure m̃elea toro dolu p̃eli na kuvijev vironiano vanio. Aver tibe na, mia Atua tibure laka re kamiu tibena, mia naio rije re vironiano van kamiu. Ver kuviekokoa toro dolu, mia Atua riviekokoa kamiu, ");
INSERT INTO bki_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","mia ver kuvisian titai van toro dolu, mia Atua sian vite rimei van kamiu. Mia Atua sian vite van kamiu ve toru loa nana kamiu kumisianio, mia naio sian ve miroano lie vo, tavukia nam̃a ajosonu ea bake, ajan kakario, amielio bano-o mia josonu batitigio bo, vite nene nalo bujo magmago ana na jibirbili. Riano, mia avar van kamiu rive verare ka ga nana m̃a kamiu kumitum̃a kumisian ban tomu dolu nalo.” ");
INSERT INTO bki_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mia Yesu jom̃a mil banlo kia ga vo, naio ber jamerijiano tai banlo, berinavo “?Jum̃abe, ver toro tai ve merebono to, naio mijikia rivuru m̃arabo ka merebono dolu ka nalo ve juo ava aiel nunu? P̃eli ga, mia ave juo atibirbil avatove ea bulukup̃ili tai na! ");
INSERT INTO bki_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Naiagagoano, naio maka to loa nana berloglog naio, mia ver naio rila kakar vatitig vite nonovio na naverloglogiano berloglogio kanio, mia naio mijikia rimei rive verare ka kiano naverloglogiano. ");
INSERT INTO bki_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Maka rivu ka kotom̃a koververii niamiamo na telisu na joa kuruamo mirano, mia jau maka keial kar burum̃ara burupati iesi na joko miramo jo. ");
INSERT INTO bki_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","?Jum̃abe jau koberiam̃a komijikia keil van kuruamo na, kover ‘Koig, mia nelelar niamiamo na joa miramo na beamu vo’? Ver tibe na jau kojom̃a kobitoviton ia kia ga ka kiamo vovaiano, a jau kojom̃a kejibure toro dolu kiano vovaiano ga. Jau komijikia ruei ka jau kobova ga, ana jau kojidom kala van tomu nalo ka aver jau kobo ruei. Jau monoka kodular beamu burum̃ara bulapati iesi na den miramo beamu vo, karina mo jau komijikia kovitii vatitig niamiamo na monea toro dolu mirano.” ");
INSERT INTO bki_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ana Yesu ber bunu, berinavo “Buruiesi na bo maka rijikia rivar m̃arati na bova, a buruiesi na bova maka rijikia rivar m̃arati na bo. ");
INSERT INTO bki_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nao, jibe na naruei, napano kito rojum̃a robitilubar buruiesi nalo ka ajum̃abe ea salo m̃arati. M̃arati nalo na bo a nam̃a jesei bo, kito maka rotum̃a ravarlo ea soro na be niononoti, makanio. ");
INSERT INTO bki_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Toro na tiniene bo, naio jom̃a miobijii vite nalo na bo jua kiano iviso, naruei bogo nonovio be kiano jidomiano na bo napano jo ka mijikia jian bulagio. Ana toro na bova naio jo miobijii vite nalo na bova jua kiano iviso, naruei naio jian bulag jidomiano na bova ga. Vite venia napano bujo toru ea toro kiano iviso p̃eli na kiano jidomiano, vite na naruei mia naio tom̃a rimalmaluvo bogo nonovio ea niono.” ");
INSERT INTO bki_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ana Yesu ber kalo, berinavo “?Bior vaio ana kumitum̃a kubio kiniou kuber ‘Tubo o, Tubo o,’ karina maka kuvitum̃a kumonmonea venia nam̃a kiniou nojom̃a neber ka kamiu ka m̃a kuvilaio? ");
INSERT INTO bki_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Toro na ver binimei ka kiniou, mijog kiaku iliano, naio monoka rimonmoneaio a naio monoka rilaiio. Toro nam̃a rila tibe na, naio javukia tukunu tai napano berii, ber jibe nei: ");
INSERT INTO bki_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Toro tai jo mim̃auka kunuano, mia toro nene be masou laka, jom̃a mikil p̃ili nene nalo bululuo batove yetano laka ka rivokar vio na borotano jikili eaio, karina mebija m̃artea nene nalo ea bulukup̃ili nalo neibano. Mia bogo na bogu va, burum̃ara ueimia mieraro, mia maka rijikia rila yimo rikulkulu leleio, bior toro nene mim̃aukanio, mim̃auka jikili bo. ");
INSERT INTO bki_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mia toro nam̃a mijog kanaku iliano nalo mia maka tom̃a rimonmoneaio, naio jibe ka toro dolu tai. Toro nene naio bunu mim̃auka kunuano tai, mia naio be vovu, mim̃auka jumolu ju vorvoru mave ea ga borotano, mia m̃artea nene maka rivatove rivare leleio. Mia bogo na bogu va, burum̃ara ueimia binimei, mila yimo nene mijoru, burukokorovio nonovio, bova laka.” ");
INSERT INTO bki_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Naruei bogo na Yesu ber bulag nonovio kiano verloglogiano nalo nene ban tomu nalo bisi, ana naio ba jouro ea bulukomeli na vio Kapeneam. ");
INSERT INTO bki_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mo ea vio na, be natukamuano na mira na kulo Romo naio jo, mia naio be kiano toro novo na im̃auano tai mie toru laka, vaataro ga ka rim̃aro. ");
INSERT INTO bki_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ana bogo napano naio mijog ka napano tomu nalo ajum̃a aberii ka mia Yesu rimei ea kialo vio naruei, ana bio navurim̃araboiano na kulo Ju nalo, miilalo aban ka Yesu, ka avikanio rimei rieliel ka namieiano neibano. ");
INSERT INTO bki_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Naruei nalo nei abinimei ea Yesu, aberii toro namieiano nei banio, a abika jikili banio jibe nei, aberinavo “Natukamuano na, memedu ka jau komei keijaio. ");
INSERT INTO bki_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Be riano ka naio maka ve kito tai, naio be toro re Romo ga, mia naio be toro tai nam̃a jidomii m̃elea taara na kiado tomu nalo, a naio bunu miija kumemi toru ruei ea vio nei, napano naio mim̃auka kenememi yimo na volkouano. Naruei numial bo laka ka ver kajaaro ka komei keial kanano toro na mie toru neibano.” ");
INSERT INTO bki_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ana Yesu mijamo kanio, naruei ban bijalo. Aju amiel abano, ana bogo napano aju koalabo kija kia ga vo ka natukamuano na mira nei kunuano, mia nalo amial ka tomu tealo ajum̃a amiel abinimei. Nalo nei natukamuano nene kiano bilbilu nalo tealo bereio, napano naio miilalo abinimei ea Yesu, ka aver kiano iliano tai kanio. Naruei abinimei aber ka Yesu, aberinavo “Toro Romo nei miila kumemi nubinimei easo bereio, naio ber jibe nei, ber naio jo mila lelanso toru laka. Naio berenio berinavo naio mial naio jibe ka napano naio maka ve toro na bare ka mia jau komei joomo ea kunuano. ");
INSERT INTO bki_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A jidomiano nei bunu mila naio mial ka maka rivu bunu ka riyotuba kaso, bior naio maka ve Ju tibe kaso, mia naio ber ga, ver jau kover ga iliano tai, mia kanano toro neibano rijog rivu bereio ga na. ");
INSERT INTO bki_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Naio mijikia ka monoka tibe na, bior naio mijikia ka kanamo iliano mije moroano. Naio berenio berinavo vite na naio jibe ka tomu na mira nalo napano ajutano yetano ka naio, napano monoka ajogkar kanano iliano nalo. Ver naio river ka tai riverinavo ‘Jau kavano,’ naio monoka rivano, p̃eli na riverinavo ‘Jau komei,’ naio monoka rimei, p̃eli na riverinavo ‘Jau kala tibe na,’ mia naio monoka rilaio. A naio berinavo naio bunu monoka rim̃auka vaio napano kanano natukamuano na toru river kanio. Jibe na naruei, naio monea ka ver jau kover titai ga, mia monoka tibe na.” ");
INSERT INTO bki_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Telikiti na Yesu mijog iliano nei, naio miilo toru ka natukamuano nei kiano jidomiano, a bunu naio jaaro toru kanio, naruei mil ban tiniobi nalo napano m̃a aju naliko ka bogo nei, berenio berinavo “Kiniou neber ka kamiu, ka kiniou maka neleal leleio toro Ju tai napano naio tumolu tu sikili ea kiniou tibe ka toro nei.” ");
INSERT INTO bki_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mo iorou kanio, nalo nene aban bereio ea natukamuano nei kunuano, mia amiilo ka napano amial toro na mie neibano naio binimei bo nonovio bereio ruei jo. ");
INSERT INTO bki_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ana iorou kanio, maka vesiou, ana Yesu miel ba bokar m̃arkomeli dolu tai, siano Naeni, a jibe ka titiliu, kiano naiagagoano nalo naliko kulo dolu nalo telabo ajum̃a ajakisorio. ");
INSERT INTO bki_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ana tilikiti napano Yesu nalo nei aju abinimei vaataro ka morouo labo na komeli nei, amial ka tomu nalo amidu buronlo amielvei abinimei, nalo aju ap̃ier tasim̃aro tai ka ava ativinio. Naio napano m̃aro ruei, naio be m̃eaku sum̃ano tai, napano kenieno be taanou. Taanou nene, naio maka rivar kenerinio dolu tai bereio, naio bar takurano ga neibano m̃aro ruei. ");
INSERT INTO bki_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mia Yesu nalo aju amial nalo napano m̃a aju amiel abinimei, mia bogo na kiado Tubo mial taanou nei, naio tinien miiaio toru laka-o mia. Naruei naio ban vaataro kanio, berkanio, berinavo “Ai, jau koteg re bunu.” ");
INSERT INTO bki_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ana Yesu binimei vaataro ka tasim̃aro nei, midu jum̃ano joaio, a nalo napano ajum̃a ap̃ier ba ajumomou ga aju jibe na, maka bunu aiel. Ana naio mil banio, berinavo “Koig, kiniou neber kaso, jau kotumolu bereio.” ");
INSERT INTO bki_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Naruei m̃eaku nei naio jumolu jibe na, jo mil banlo, ana amidular naio bereio, ana Yesu jukamu kanio ba ban kenieno bereio. ");
INSERT INTO bki_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mia bogo na tomu nalo amial vite nei, burevure burelo toru laka, mia aju abamenea Atua, aberenio aberinavo “!Uerei, burum̃ara naverialiano na Atua kanano tai jumolu ju iviso ka kito vonganei naruei!” A tealo aber bunu, aberinavo “!Riano ga na! Atua miyotuba ka kiano tomu nalo naruei.” ");
INSERT INTO bki_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mia tukunuano na tenei, ajum̃a aber lilianio banbano-o bokar tanobuku na vio Yutea, bija vio dolu nalo napano m̃a aju ga vaataro kanio. ");
INSERT INTO bki_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana ea bogo na, Jone Baruei naio joa yimo na tetavokoiano ruei, ana kiano naiagagoano nalo abinimei ajukunu banio ka vite nalo napano m̃a Yesu jom̃a milaio. ");
INSERT INTO bki_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Naruei Jone mil ban kanano tom juo, naio miilalo aban ea kiado Tubo, ka ava avika vatitig denio, ka naio be Naverikariano na, nam̃a aju rorea ka mia rimei, p̃eli na maka ve naio. ");
INSERT INTO bki_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ana amiel ka amei aial Yesu, mia bogo napano amileal naio, abika jibe nei naruei denio, aberinavo “Kenememi toro na toru nei Jone, jidom rijikia jum̃abe? ?Jau kobe toro na nanua m̃a aberenio ruei aber ka mia toro na toru tai rimei ve kiado navurim̃araboiano, p̃eli na jau maka kove naio vo, mia monoka kumemi nuviturorea kiano vo ka mia toro nene naio rimei?” ");
INSERT INTO bki_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mia memedu ka bogo napano abinimei ka avika vikadeniano nei, Yesu jom̃a mieliel ka tomu na mieiano nalo, a jom̃a mijil bulag niadu nalo denlo, a jo mila merebono nalo miralo abinimei abo bereio, ana Jone kiano naiagagoano nalo amial vite nalo nei. ");
INSERT INTO bki_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Naruei Yesu berdop̃e vikadeniano nei, naio berinavo “Kamiu kuvan bereio kuvoru ea Jone, ana mo kuverial vanio vite venia napano kumialio p̃eli kumijogio ea vio nei. Ajibe ka vite nalo nam̃a Naverialiano Aisea berial nua ruei, napano berinavo: ‘Merebono nalo, vonganei amial vatitig vite bo bereio ruei, a javuluku nalo, vonganei nalo amiel bo bereio ruei, a tomu nalo napano burumieni milalo, vonganei niabelo binimei meravo bo ruei, a nalo na abe bulubau, vonganei tilinielo bo bereio ruei, a tomu nalo na am̃arm̃aro, vonganei amemeul bereio ruei, a talim̃asa nalo, vonganei neberial Ioluano Vou banlo ruei.’ ");
INSERT INTO bki_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mia kamiu kuva kuverial ka Jone bunu, kuverinavo ‘Toro napano ver maka leleio kiano jidomiano riveve juo ea kiniou bogo tai, ilivuiano toa naio.’ ” ");
INSERT INTO bki_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ana bogo napano Jone Baruei kiano naiagagoano nalo ajuvan ka avan bereio, Yesu berii Jone nei ban tomu nalo napano aju naliko, naio berinavo “?Bogo nam̃a kamiu kubatavio ea vio yauo na beamu, kamiu kuban ka kuvial venia? !Maka tinieku ka kamiu kuban ka kuvial buruburi nam̃a jegi jom̃a miuvuio p̃iligṽiligio! ");
INSERT INTO bki_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A maka tinieku bunu ka kamiu kuban ka kuvial toro na toru tai napano m̃a miya kulum̃arauo na kirinovo a napano joa meuliano nabo, bior tomu nalo na jibe na maka ajikia atua vio na kiriniagiago jibe ka vio yauo na, mia nalo dam̃ariga ajujua yimo nabo na be tubo na tortoru nalo kunualo. ");
INSERT INTO bki_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Makanio, mia kiniou tinieku ka kamiu kubatavio ka kuvial naverialiano tai, inau? Nina bo na, mia kiniou neber ka kamiu, Jone nam̃a kamiu kubatavio ka m̃a kumialio, naio loa laka, naio jovulu naverialiano nalo re nua, ");
INSERT INTO bki_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","bior Atua berii naio ea kiano Iliano Lu ruei, naio berinavo ‘Kiniou nemiila kiaku atevi na binimei jukamu kaso, ka rila vatitig kiamo m̃arabo.’ ");
INSERT INTO bki_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Riano neber ka kamiu, ka ea yetemeriba nei, Jone Baruei naio loa laka ka kulo dolu nalo abiniu. Mia nalo nonovio napano mia amei jouro ea Atua kanano navenatuboiano, riva rivokar toro na maariano kalo nana jotano laka garuei, nalo na abiniu nalo loa laka ka Jone, napano mia avar Atua kiano ilivuiano nalo ve toru loa tovulu naio.” ");
INSERT INTO bki_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mia bogo na aban amijog Jone Baruei jo mioliolu, berial m̃arabo na Atua ka ajikia aviliglo, mia tomu na bova telabo, ba bokar tomu na takis bunu, amial ka m̃arabo nene be riano, ana abiliglo ana Jone baruei ealo. ");
INSERT INTO bki_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mia kulo dolu nalo, jibe ka Varisis bija naverloglogiano na tuboiano nalo, abilig taakalo ka m̃arabo na Atua naio mila ka ajikia aviliglo ka naio, ana Jone Baruei naio maka rivaruei ealo. ");
INSERT INTO bki_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Mia Yesu berii kulo m̃arou nalo nei ka bogo na, naio berinavo “?Mia kiniou never iliano na vabe na mia mijikia rivokar tomu re banei kialo bajago, ka river nalo tomu na ajum̃abe? ");
INSERT INTO bki_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","34","Vite nonovio na Atua mila ka rilavonio rivu van kamiu, mia kamiu maka kuvisidomio ga, mia kumil niegeniege naio ga biorio. Bior bogo napano Jone naio binimei, naio jom̃a monodulu ka m̃a bolkouo, a naio bel ka m̃arjum̃elm̃elu, mia tomu nalo amial jibe na, nalo ajum̃a amilia naio aberinavo ‘Tete na sim̃aro juaio.’ “Mia bogo na kiniou Kulorinio Kenerinio nebinimei nojo, nejinan batitig bo a nomunu batitig bo, naruei amilia kiniou, aberinavo ‘!Keal, tete na naio be toro nam̃a jinano m̃ele, a naio be toro nam̃a munu m̃elea m̃arjum̃elm̃elu, a napano kanano bilbilu nalo, nalo abe tomu nam̃a abarbijii takis a tomu na abova!’ “Bior vite na naruei, kiniou nemial kamiu tomu na vio banei napano kamiu kumitibe ka kiritete nalo, napano ver ajum̃a amijejea ea vio yauo na komeli, mia nalo aviovio aiagiaga van kialo bilbilu sesa nalo, averinavo ‘!Oi, kamiu kubova na! Ver kumemi numitum̃a numue bulaiu, mia kamiu maka kuvisidom kuvolu rivija kumemi, p̃eli na ver kumemi numitum̃a numiou ka iou na m̃ariano, mia kamiu maka kuvisidom kuviteg vija kumemi!’ ");
INSERT INTO bki_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Nina naruei, tomu nalo maka asidom Atua kanano m̃arabo nalo, mia kirim̃arati novo napano maluvo ea toro kiano meuliano na jo jakii Atua kiano m̃arabo, rila rimeravo ka m̃arabo na naruei naio be m̃arabo na masouano napano be riano.” ");
INSERT INTO bki_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mia Varisis nalo tai kalo, siano Saimon, naio berinavo naio jidom rim̃auka Yesu sano sinaniano tai, ana Yesu ban ea kiano vonuo, a naio ba jotano ka asinan. ");
INSERT INTO bki_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ana ea komeli na, be tira tai napano jo naio mila bajago miroano na kirivova laka, naruei naio mijog ka napano Yesu ba jo jinano ea Varisis nei Saimon kunuano. Naruei tira nene bitilubar kiano kariano, mijog kirivova toru laka, naruei naio mijog ka monokanio riva rial Yesu, ana naio midu kanano bauei na bonotanunu nabo tai, naio midu binimei ea yimo nei. ");
INSERT INTO bki_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Mia Yesu mijoru mon ka merikono ka sinano, naruei tira nei binimei jumolu ju iorou ka naio ea jaano, napano jogumirano miou jibirbili bavatove ea Yesu jaano. Jogumirano nei jom̃a jekon Yesu jaano jibe na, naruei naio bar burutili vijinio m̃a na, naio jom̃a miolkono ka Yesu jaano, a naio mije kulbibinio tivelinio mon mave ea Yesu suvajaano, avona bisi ana na miyon bonotanunu nei eaio. ");
INSERT INTO bki_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naruei Varisis neibano miog Yesu binimei ea kunuano, naio jom̃a bitii vite nei, naruei naio jom̃a tiniene bova kanio kija. Naio jom̃a jidomii jibe nei, berinavo “Verenio Yesu na naio be naverialiano riano tai, p̃eli mia rijikia batitig ruei ka tira na naio be tira na kariano mugaruei jibe na, mia naio rijikia re rijamo ka naio tokol jaano lu na. Mia naio mijamo ka ga naio ka rila tibe na, kiniou maka bunu nejikia vatitig naio naruei.” ");
INSERT INTO bki_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Mia Yesu mijikia kiano jidomiano, naruei berdop̃e banio, berinavo “Saimon, kiniou nejidom never kiri iliano tai ve telisu vanso beamu vo.” Ana Saimon berdop̃e berinavo “Bo ga, Naverloglogiano. Jau komijikia koverenio.” ");
INSERT INTO bki_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Naruei Yesu berdop̃e jibe nei banio berinavo “Toro tomoruo tai, mia tomu juo amila jabue ea naio. Ea naljuo nei, tinene kiano jabue toru, mia tinene, naio kiano jabue burutomoruo laka. ");
INSERT INTO bki_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ana ea bogo na ka avulu meran bereio jabue nalo nei, mia abe juo maka ajikia avulu meran bereio, naruei toro tomoruo nei tiniene mialo abe juo, naio biekokoalo abe juo ka kialo jabue nonovio. ?Mo bior vite na, tom juo nei na vabe nene na naio monoka tinienriia m̃elea toro tomoruo nei?” ");
INSERT INTO bki_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ana Saimon berdop̃e ban Yesu, naio berinavo “Kiniou maka nejikia, p̃eli na kanano jabue burutomoruo laka kovio, naio monoka sidomii naio rivu lie.” Ana Yesu berenio berinavo “Nao koig, naio jibe na naruei.” ");
INSERT INTO bki_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mo Yesu barp̃ilig naio ka tira nei, jiloglog naio ka Saimon, berinavo “Saimon, bogo na kiniou nebinimei joomo ea kunuamo, maka neial toro tai rudu uei tai rimei ka mia nemijikia nesekon bulagio niamiamo na m̃arabo den jaaku, napano javukia kanado bajago, jau monoka kalaiio. Mia jau keial tira nei, naio naruei jekon jaaku ka jogumirano, a miolkon juva ka vijinio. ");
INSERT INTO bki_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kiniou nebinimei joomo ea kunuamo, mia jau maka kavan jum̃amo vatitig rivija kiniou tibe ka nebe kanamo bilbilu nabo tai, mia jikar ea bogo na kiniou nebinimei joomo, naio midu kulbibinio tivelinio mon mave ea suvajaaku nam̃ariga. ");
INSERT INTO bki_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jau maka kavar bonotanunu rimei ka koyon ea paripariku, mia naio mila ka jaaku ruei. ");
INSERT INTO bki_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mia kiniou neber batitig banso, ka tira nei, kanano kariano nalo miroano laka, mia kiniou nebiekokoa nonovlo biniu ruei, ana mila na tinien jii kiniou toru laka. Mia kiniou nemial ka toro na kanano kariano maka ve toru, kiniou nebiekokoa naio, mia naio tinien jii kiniou maka rive toru.” ");
INSERT INTO bki_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mia Yesu mil batitig ban tira nei bunu, naio berkanio berinavo “Kiamo kariano nonovio nam̃a kojom̃a kojidomii bova vururu biorio, kiniou nebiekokoa nonovlo ruei.” ");
INSERT INTO bki_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mia bogo na Yesu ber iliano na, kulo dolu nalo napano ajum̃a ajinan vio takurano naliko ka bogo nei, nalo maka asaaro laka, nalo ajum̃a amijuvaluva tertelisu banlo, ajum̃a aberinavo “?Mia tete na naio jidom naio rive kei, napano jom̃a berenio naio mila bulag kariano na tomu nalo kanalo jibe na?” ");
INSERT INTO bki_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mia Yesu mil ber ban tira nei vaarakurano bereio, naio berinavo “Kanamo viekouoiano milaso kobokar ioruriano ruei. Jau maka bunu kojog rivova, jau komijikia kavano ga, mia Atua kanano tum̃aro to vijaso.” ");
INSERT INTO bki_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ana maka vesiou bereio, Yesu naio jom̃a mieliel bano, naio jo ba jel burevure komeli nalo na tertelisu a nalo na tortoru, mia ea vio nonovio naio jom̃a mioliolu, a jom̃a midu lilianiano vou nabo na Atua kiano navenatuboiano binimei ban tomu nalo. Mia jibe ka titiliu, kiano duelimo ba juo 12 nalo aju bija ka bogo na, ");
INSERT INTO bki_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mia tire nalo telabo kija bunu aju iorou ka nalo. Ea tire nalo nene, tealo kalo napano Yesu mieliel kalo bior niununo nalo na kirivova a kanio mieiano na jualo, jibe ka Mere na Maktala, napano nanua beamu niadu aluo ajua naio, ");
INSERT INTO bki_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bija Joana, napano naio be toro nei Kusa koano, nanua naio be toro na toru tai na im̃auano na Parinio tubo Erot kiano, a bija Susano bunu. Mia nalo miroano lie vo bereio, napano nalo amiija Yesu nalo toru, mia nalo ajum̃a abitikarlo ka ijaiano nalo nam̃a tomu nalo aju ajian banlo. ");
INSERT INTO bki_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Naruei ea kiri bogo tai, burum̃ara tiniobi na tomu nalo amoluo ea komeli telabo beve terakurano na kanalo, naruei nalo abinimei amiobijiilo jeliviv ea Yesu, naruei naio mil banlo, buku jamerijiano tai kalo. ");
INSERT INTO bki_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Naio berenio jibe nei, berinavo “Be toro tai napano ban ka rivisivisii kurukuti ea kiano tiniavio. Bogo napano jom̃a bisivisii kurukuti nene abano, kurukuti tealo ajibirbili ea m̃arabo, mia iorou, tomu nalo abinimei amiel ea abie lelanlo, a menu nalo amikiti nonovlo. ");
INSERT INTO bki_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A kurukuti tealo ajibirbili ea vio na be tabap̃ilio eaio, abitovtov sop̃eli, mia karina abinimei amekekeu ga, bior maka ve uei tai ea vio nene. ");
INSERT INTO bki_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mo kurukuti tealo ajibirbili ea vio nanua beamu maka atekon batitig rivu teli va nalo eaio, mia iorou kanio ana p̃eli nana bova nei naio barboṽeio miluo bereio, bisovoko toti nalo bano-o mia am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mia kurukuti dolu tealo bereio ajibirbili ea kiri borotano nabo tai, mia nalo amililiuo bano-o, ajakou abar m̃arati nalo, bokar toromomou takurano 100.” Mia bogo napano Yesu berenio iliano nei banlo bisi, ana naio miaga m̃erere banlo, naio berinavo “Toro na be tiliniene, monokanio riagago vatitig ka iliano nei.” ");
INSERT INTO bki_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ana iorou kanio, ana naiagagoano nalo abinimei ea Yesu mia nalo abika nioti na jamerijiano nei denio. ");
INSERT INTO bki_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naruei naio berdop̃e banlo, berinavo “Atua naio mila jibe na ka mia kamiu kumijikia kuvileal ililuklukuano nalo na kiano navenatuboiano. ‘Mia ea kulo dolu nalo, ililuklukuano nalo na ajuluku ea jamerijiano kia navo, mia ajum̃a abitio-o mia maka avitilubarlio, a ajum̃a amiagago-o mia maka ajog lubarlo.’ ” ");
INSERT INTO bki_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Naruei Yesu ber bisivisii masosoua jamerijiano nei banlo. Naio berenio berinavo “Mo, nioti na jamerijiano nei naio jibe nei. Vite na be moti, naio be kurukuti, mia nina naio jibe kanio Atua kiano iliano. ");
INSERT INTO bki_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mia kurukuti nalo napano ajibirbili ea m̃arabo, nina naio jibe kanio napano tomu nalo amijog iliano nei, a kurukuti novo nei ajibirbili ban ea kialo jidomiano nalo. Mia Parinio Sim̃aro nei naio binimei bar bulag iliano nei bereio den kialo iviso nalo, ka rila amonea re bunu, a ajikia re avokar ioruriano. ");
INSERT INTO bki_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Dolu, nina kurukuti nalo napano ajua tabap̃ilio, mia nina jibe kanio tomu nalo nam̃a amijog Lilianiano Vou na bo nei, mia nalo amijevio, ajaaro kanio, mia jibe kanio napano maka ve salo bati na bo. Nalo amonea ka bogo bulati ga, mia verenio ve bogokouo, p̃eli na juboluboiano rimei, mia nalo ajoru bereio ga. ");
INSERT INTO bki_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Dolu bunu, nina kurukuti nalo napano m̃a ajua vio napano be teli na bova eaio, a nina jibe kanio napano tomu nalo na amijogio, mia bogo nam̃a aju amiel abano jibe na, mia ajidom yebekavo toru ea kialo meuliano, mia ajidom m̃elea puruveru, a nalo tiniel jii m̃elea serevuiano nalo na yetemeriba nei. Bajago nalo na abinimei jibe ka teli na bova tai nam̃a muekolo, ka mia rila ana na mia nalo ajikia re avar m̃arati napano meruo bo ea kialo meuliano nalo leleio. ");
INSERT INTO bki_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Mia nana maariano, nina kurukuti napano ajua borotano nabo, nina javukia napano tomu nalo nam̃a amiagago ka Lilianiano Vou nabo nei, naruei nalo amije batitigio monea kialo iviso nalo, abokario jikili vatitig bo be riano. Kulo novo nalo na jibe na, nalo ala kialo jidomiano nalo ve terebievi, naruei nalo aim̃au rimemedu rivanvano-o mia avar m̃arati na Ioluano Vou nei ea kialo meuliano nalo.” ");
INSERT INTO bki_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ana Yesu ber bunu, berinavo “Kito tomu nalo, verenio kito ravar yulu rimei, mia ve re tai napano roduvanio sel tano ka basaro p̃eli na vite na jibe na. P̃eli ga, kito reive takilele mave ga ka rila tomu nalo na ver amei joomo aial ka napano vio merera bo. ");
INSERT INTO bki_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mo, na Atua kanano navenatuboiano naio jibe ka yulu nei, napano vonganei jom̃a malmaluvo ea kito ka rudulii vite nonovio. Vite nonovio napano ajuluku aju, a ililuklukuano nalo, mia nalo monoka amalmaluvo ea vio medave ka tomu nalo avitilubario. ");
INSERT INTO bki_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kamiu monoka kuviagago vatitig ka kanaku iliano nalo, a kuvilavon ka kuvisidomii vatitigio. Toro napano be kiano saba miroano ruei, mia naio rivar rivan lie vo ve telabo laka, mia toro napano maka kiano saba, mia rila luvuio vite vaio na telisu nei napano naio tiniene ka ber kiano ruei.” ");
INSERT INTO bki_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ana na Yesu kenieno naliko kuruano nalo amiyotuba ka naio ka bogo nei, mia nalo maka ajikia avokar naio joomo, bior burutiniobi toru laka, mila vio telisu. ");
INSERT INTO bki_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mia tomu nalo aber lilian iliano binimei bokar Yesu, ana aberenio aberinavo “!Ai, koniomo naliko kuruamo nalo, nalo yako ajikili aju tavio, ajidom aialso beamu vo!” ");
INSERT INTO bki_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mia Yesu berdop̃e banlo, berinavo “Nana naio be kenieku, p̃eli na kuruaku, nina nalo ga nei napano amijog Atua kiano iliano lu, a nalo ajum̃a amila javukia ga napano iliano nei berenio.” ");
INSERT INTO bki_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mo ea legiano tai, Yesu buru naiagagoano nalo, abiako ea uako tai, naruei Yesu ber kalo, berinavo “Kito m̃a rava tivelinio ea ueiyabo nei.” Naruei ajuvan vio, ana abano, ");
INSERT INTO bki_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","mia bogo na uako jo juvan bano, mia Yesu mirano jouo toru ana monmelio. Ana iorou kanio, ana burum̃ara jegi tai jumolu binimei ea ueiyabo nei, mia burum̃ara kenieno niatuva nalo na amidon tanealo bano-o mia uako nei binimei bujo ka jumu, mia nalo amialo ka bova kitkiti ga naruei. ");
INSERT INTO bki_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana nalo aba abio bon Yesu, aber kanio, aberinavo “!Tubo, Tubo, vaataro ka mia kito ramadudu naruei!” Ana na Yesu jevijo jumolu, ana naio berbure jegi bija burum̃ara kenieno niatuva nalo nei, naruei vite nalo nei ajuba binilo, vio be tum̃aro nonovio bo. ");
INSERT INTO bki_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ana Yesu ber kalo berinavo “?Kenemiu viekouoiano nibe?” Naruei nalo amerou mia amerou laka, amiilo toru, ana na nalo ajum̃a abivika denlo bereio, aberinavo “?Toro kenia na? Naio mil ga jibe na mia jegi naio tei amijogkar niono. !Tomnei!” ");
INSERT INTO bki_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Naruei Yesu nalo abarkor abokar tivelinio nene, napano Kalele jirarago ban eaio, nina memedu ka vio nei Kerasa. ");
INSERT INTO bki_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mia bogo napano Yesu jabulu, bauro ea vio nei, toro na vio nei tai binimei ka rivitavo vijaio, napano toro nene sim̃aro nalo ajuaio. Bogobe nua ruei, toro nene naio jo jibe ga na, maka riya kulum̃arauo tai, a maka m̃a monmon ea yimo, mia tinien jii ka m̃a mon ea pakeltavo ga, ea buluvae nalo nam̃a abar kanalo tasim̃aro nalo aba amonmoneaio. ");
INSERT INTO bki_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Sim̃aro nalo nei ajum̃a ajutua kiki toro nei va telabo ruei, mila na tomu nalo amilavon ka atukuku kanio dam̃ariga, a nalo ajum̃a amiorkakar ka m̃armieni, p̃eli amiorkakar jaano a jum̃ano ka teli, mia naio jom̃a mila kokorovlo ga, a sim̃aro nalo nei amijil deven naio binimei joa vio mom̃a nei. Mia Yesu mialio, mil ban niununo va nei, jitig naio berinavo tuvan toro nene. Mia toro nei mial Yesu, naio bio banio, a naio mijorua jaano, ana niununo neibano joa naio mil burutomoruo, naio berenio berinavo “?Mia jau, Yesu, Atua Sop̃i kenerinio, kanamo vaio joa kiniou? !Kiniou nobika jikili denso, ka mia jau kesian re vironiano van kiniou!” ");
INSERT INTO bki_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ana na Yesu bika denio berinavo “?Ana siamo, kei?” Ana na niununo va nei naio berdop̃e, berinavo “Siaku be ‘Tomu na mira miroano.’” Naio ber jibe na, bior sim̃aro nalo nam̃a aba joomo ea naio nalo miroano laka. ");
INSERT INTO bki_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Mia niununo va nalo nene nalo ajum̃a abivika jikili den Yesu bereio ka mia naio rijil nalo re, naio rila lo re ava ajoru avatove yetano ea burum̃ara bulukuti sebi. ");
INSERT INTO bki_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mo ea suku tivelinio na vio nei, be burum̃ara taara na kiribue, nalo ajum̃a amiuoiuo ea borotano, ana sim̃aro nalo neibano amiaga ban Yesu, abika jikili denio aberinavo naio rila lo ava joomo ga ea kiribue nalo nei. Ana na Yesu mijamo ka jibe na banlo, ");
INSERT INTO bki_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","naruei nalo ajaluvo den toro nei, ana nalo aba joomo ea kiribue nalo neibano. Mia sop̃eli ga, kiribue nalo nene ajikiti, ajibirbili ea yabalili tai, abavatove yetano ea burum̃ara ueiyabo nei, amadudu nonovio ea bulu niogovu. ");
INSERT INTO bki_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ana bogo napano tomu na abitikar kiribue amial vite nei, mia nalo bunu aburo kilkil, aban bereio vonuo, aberial vite nei, mia nalo aberial janea vio reraio bunu, ");
INSERT INTO bki_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","mila ana vio bujo ka tomu nalo abinimei, ka ajidom aial kija. Mia bogo na abinimei, amial ka na Yesu naio jo, a toro nam̃a niununo va nalo neibano aburo denio ruei, naio jom̃a jotano ea Yesu jaano. Naruei naio miya batitig kulum̃arauo nabo ruei, mia naio jo melumu bo ruei jo, maka bunu rive deden leleio. Bogo napano amialio ka napano toro nei naio binimei bo ruei jibe nei, mia nalo amerou toru. ");
INSERT INTO bki_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mia nalo napano aju jukamu, napano amial vite nonovio, nalo ajukunu kanio ban nalo na abinimei vonga, nalo aberbisivisiio banlo jum̃abe ka toro nei nua niadu nalo aban ea naio, mia Yesu mila naio binimei bo bereio ruei. ");
INSERT INTO bki_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mia tomu nalo na tanobuku nalo na vio Kerasa, nalo amial ka bova ga, naruei nalo aju ajadu jikili ka Yesu ka ajidom ka mia naio taluvo denlo, bior vite na milalo amerou toru laka. Naruei Yesu nalo abajou bereio ka avan ea kialo uako, ka nalo avan bereio. ");
INSERT INTO bki_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ana bogo na ajum̃a abajou, toro neibano naio binimei balea Yesu jikili, ka jidom riva to naljuo bogo nonovio, mia Yesu maka rijamo kanio, mia naio berkanio, berinavo ");
INSERT INTO bki_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Makanio, bior bo laka ka kava vonuo bereio, a jau kava kover van tomu nalo, kover kalo jum̃abe napano Atua mila bo mia bo laka banso jibe na.” Ana toro nei ban bereio, a naio jom̃a miel jeliviv ea vio nalo na ea tanobuku na kanano burum̃ara bulukomeli, a naio jom̃a ber bulavulag im̃auano novo nei napano Yesu mila ban naio. ");
INSERT INTO bki_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Naruei Yesu nalo abarkor bereio ueiyabo aba tivelinio, mia burum̃ara tiniobi na tomu nalo aju rorea naio, mia nalo ajaaro toru ka amial naio bereio. ");
INSERT INTO bki_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mia toro na toru tai na yimo na volkouano na kanalo na vio nei, siano Jairas, naio binimei vaataro ka Yesu. Naruei minie yetano kanio, jegi banio, baleaio ka rimei ea kunuano, ");
INSERT INTO bki_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ka rial kenerinio vevinio, napano mie toru. Tira sesa nei, naio be toro na toru nei kenerinio takurano m̃anono ga, a kiano yuka be titai jibe ka duelimo ba juo ga 12, mia kiano mieiano binimei biloulo ruei, mila ana amial ka vaataro ka mia naio rim̃aro. Naruei Yesu jumolu, ban bija toro nei abano. Mia bogo na naio jo ban jibe na, vio bujo ka burum̃ara tiniobi na aju ajakisosorio, nalo ajum̃a amivinkakarlo ajeliviv ea Yesu. ");
INSERT INTO bki_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mia nalo nene tai kalo, naio be tira tai, napano kiano mieiano na monoleri mila naio ka legiano nonovio ga, bokar yuka duelimo ba juo 12 ruei, mia maka ve toro tai napano mijikia rila rivu kiano mieiano nei leleio. ");
INSERT INTO bki_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naruei tira nei, naio milavan naio bure tomu nalo nei, naruei mijian lilie ka naio binimei vaataro ka Yesu taakano, ana na naio jian jum̃ano jibe na ana jokol m̃ano ikiniono kulukoti. Naio jokol Yesu m̃ano kulum̃arauo jibe na, mia monloglog bogo nei ga, kiano mieiano nei bisi ruei. ");
INSERT INTO bki_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Mia kolvare ga Yesu bika, berinavo “?Kenia na jokol kiniou vonganei ga?” Mia nalo aber “Maka toro tai tokolso,” mia Pitere bunu berkanio berinavo “?Ana Tubo, jum̃abe? Tom miroano miroano laka na amivinkakarlo jeliviv easo, a ajum̃a abalbaliaso.” ");
INSERT INTO bki_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ana Yesu berkanio, berinavo “Makanio, toro tai jokol batitig kiniou nei, bior nomijog lubar ka kanaku moroano togio jaluvo ea kiniou ban ea toro nene ruei.” ");
INSERT INTO bki_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naruei tira nene, naio bitilubar ka naio maka bunu rijikia rilavan naio, naruei naio binimei ea Yesu, napano naio merou toru bano m̃a jo memebiju ka garuei. Naio binimei mijoru ea Yesu jaano, kamu ka tomu nalo napano aju na miralo, naio ber bulag nonovio vite ea naio banio, jibe na kar vaio napano naio binimei jokol Yesu, a jum̃abe napano naio binimei bo ruei ea bogo nei. ");
INSERT INTO bki_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ana na Yesu berkanio, berinavo “Nena, kanamo viekouoiano ea kiniou milaso kobo bereio ruei. Atua kiano tum̃aro to vijaso, jau kava vonuo ga bereio.” ");
INSERT INTO bki_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naruei bogo napano Yesu jom̃a mil ban tira nei kia ga vo, iliano binimei ea toro na toru nei kunuano, berinavo “Kenerimo vevinio nam̃a na, naio bakovio ruei. Bo ka mia jau kovuru re bunu naverloglogiano na toru na rimei, ka kala lelan kule re naio.” ");
INSERT INTO bki_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mia Yesu bunu mijog iliano nei, ana na naio ber ka Jairas, berinavo “Jau niukniuku rivieso re, jau kavarkar tiniemo sikili ea Atua ga, bior mia kenerimo vevinio naio rimeul bereio na.” ");
INSERT INTO bki_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naruei Yesu ban bija toro nei ea kiano vonuo, mia bogo napano abinimei abokar vio nene, naio berbure nalo dolu berinavo mia nalo ava joomo re naliko naio, mia naio buru ga Pitere naljuo Jone, bija Yemesi, naliko niatira sesa nei karam̃ano a kenieno, mia nalo na ga aba joomo. ");
INSERT INTO bki_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mia bogo na nalo aba joomo jibe na, amial ka napano tomu nalo ajum̃a tiniel miia niatira sesa nene ruei, nalo ajum̃a ajigio, mia Yesu ber kalo, berinavo “Kamiu kuviteg re rivior niatira na tibe na. Naio maka rim̃aro na, mia naio jo monmelio ga na.” ");
INSERT INTO bki_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mia nalo abital m̃elea ga banio, bior nalo amijikia ruei ka napano niatira nei naio m̃arodobi ruei. ");
INSERT INTO bki_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naruei Yesu ba bokar niatira nei jum̃ano, a naio mil banio, berinavo “Kanaku niatira, jau kotumolu von.” ");
INSERT INTO bki_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naruei monloglog bogo nei ga, nalo amial ka napano niatira nei kiano meuliano binimei bere joaio bereio, naruei naio jumolu jikili ju, naio jom̃a miel, ana na Yesu ber kalo berinavo bo ka adu kiri sinaniano tai vanio. ");
INSERT INTO bki_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mia karam̃ano a kenieno, nalo amiilo toru napano mila kanalo jidomiano bakovio ruei, mia Yesu ber kalo berinavo mia averial re vite nei van kulo dolu nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Naruei Yesu bio biroviron kiano duelimo ba juo 12, ana na naio mil batitig banlo, jian moroano banlo, mijamo kalo ka amijikia atuvulu sim̃aro, a ka amijikia aieliel ka mieiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Naio mila jibe na ka mia naio riila bulaglo ka mia ava aioliolu ka Atua kiano navenatuboiano, a ka aieliel ka namieiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A iliano nabo nalo tealo napano naio ber kalo beamu vo, avona bisi ana na nalo abanio aber jibenei, napano naio berinavo “Tivelinio ka kenemiu m̃arabo, mia kamiu kuvar re titai. Mia kamiu kuvar re kenemiu nasitogo nam̃a kubanio, p̃eli na kenemiu basaro, p̃eli na sinaniano, p̃eli na kenemiu puruveru, a mia kuvar re kenemiu kulum̃arauo ve juo, mia kamiu kuvar kenemiu kulum̃arauo ve takurano ga nam̃a kumiya kar vonganei ka kuvano. ");
INSERT INTO bki_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Mo vonuo na vabe na mia avurukar kamiu kuvitum̃a, kuva jouro eaio, mia monoka kamiu kuvisaaro ka mia kuvitu kamliko m̃aratavo na vonuo nene, mia kuvituvan vonuo nei bogo napano mia kuvitaluvo den m̃arkomeli nei bereio. ");
INSERT INTO bki_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A ea m̃arkomeli na vabe na ver maka asidom avurukar kamiu ea kunualo nalo, mia kamiu kuvituvan ga kialo vio nene, a bogo na kamiu kuvitaluvo denio, kamiu monoka kuvijubakon bulukievi na m̃arabo na vio neibano den jaamiu nalo, tibe ka kijokijo tai, p̃eli na iliano na kirisikili tai na kenemiu banlo, ka mia avar vironiano tai napano memedu ga ka kialo bajago na bova nene.” ");
INSERT INTO bki_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ana na naiagagoano nalo abava tavio naruei, nalo aba ajel ea m̃arkomeli nalo, nalo ajum̃a amioliolu ka Lilianiano Vou nabo, a nalo ajum̃a amieliel ka tomu nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ana ea bogo na, Parinio Tubo Erot nene bunu naio mijog kija ka vaio napano m̃a Yesu nalo ajum̃a amilaio, naruei naio jo tiniene burukokorov biorio, bior tomu tealo ajum̃a aberii Yesu, ka naio be Jone Baruei, napano naio meul bereio den nam̃ariano, ");
INSERT INTO bki_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","mia nalo dolu ajum̃a aber vonvon aberinavo Yesu be tormoruo Elaija re nua, napano naio miyotuba bereio, a nalo tealo ajum̃a aberinavo Yesu be naverialiano nalo re nua nua tai, napano naio jumolu bereio den nam̃ariano. ");
INSERT INTO bki_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mia Parinio Tubo Erot naio berinavo “Maka ve Jone Baruei na, bior kiniou nomiovlar pariparinio ruei, mia toro nam̃a ajum̃a aberveriio na, naio be kenia bereio?” Mo jidomiano nei mila ana naio jidom toru ka rial kija Yesu. ");
INSERT INTO bki_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ana naiagagoano nalo napano Yesu miila bulaglo ka ava aioliolu, nalo aborvoru bereio, naruei nalo aberial ka Yesu vite nalo nonovio napano m̃a amim̃aukanio. Ana Yesu burulo ajaluvo den tomu nalo, ajubilig telisu ea m̃arkomeli tai, siano Betsaeta. ");
INSERT INTO bki_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mia karina, tomu nalo amijog ka aju aban ea vio nei, mia nalo bunu ajakisorilo, aban ea vio nene bunu. Mia Yesu naio jaaro ga, naio jukunu kija naliko, a kario naio berlogloglo ea tivelinio na navenatuboiano na Atua kiano, a naio mila batitig nalo nam̃a aju ajidom toro tai ka rieliel kalo. ");
INSERT INTO bki_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mia Yesu jo naliko banbano-o, karina nalo amial ka napano m̃erenio jo batove nonovio, naruei kanano duelimo ba juo 12 abinimei keanio, aberinavo “Ai, Tubo, bo kanio jau kajamo ka tiniobi nei avan bereio ea kanalo vonuo nalo, p̃eli na ea m̃arkomeli tealo na, ka amijikia avulu salo sinaniano tealo, a ka amijikia aleal vio tai ka mia amon eaio, bior vio nei kito rojua nei naio bova ga, maka rivu ka vio ribobogko kito eaio.” ");
INSERT INTO bki_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mia Yesu ber kalo, berinavo “Ee, makanio. Bo kanio kamiu ga kuvar sinaniano vanlo.” Mia nalo aberdop̃e aberinavo “!Ajerei! Abe kumemi nubarkar ga joko sesa jimo, bija niado na tertelisu juo. ?P̃eli na ver makanio, jau kojidom ka mia kumemi naruei, nuva nuvulu sinaniano rivare ka burutiniobi nalo na?” ");
INSERT INTO bki_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mia nalo aber jibe na bior tomu nalo napano aju na nalo miroano laka, napano kulovu nalo ga abokar titai kovio jibe ka menu jimo 5,000. Ana na Yesu ber kalo berinavo “Kamiu kuva kuver ka tomu nalo na kuver atutano beamu vo, atutano ea taara nalo, napano mia tomu veve duelimo va jimo 50 atua taara tai.” ");
INSERT INTO bki_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Naruei nalo abano amila javukia napano naio berenio, naruei tomu nalo ajutano ea taara nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Naruei Yesu bar joko jimo bija niado na tertelisu juo nei, naio jirarago bavin tiniabene, naio milivu kanio, karina burekokorovio, ana bar jian ban naiagagoano nalo ka aviovio ka tanea taara nalo nei. ");
INSERT INTO bki_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Naruei nalo ajinan banbano-o, mabolo jouo batitigio bo, a iororoti sinaniano napano ajen digio ju, nalo amisonsonlo aban ea basaro solokobaro nalo bokar duelimo ba juo 12. ");
INSERT INTO bki_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mia bogo tai, ana Yesu jo bolkouo naio takurano, a kanano naiagagoano nalo aju vaataro ka ga naio, naruei naio bika denlo, berinavo “?Kamiu kumitum̃a kumijog tomu nalo ajum̃a aberverii kiniou aber kiniou nebe kei?” ");
INSERT INTO bki_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ana na nalo aber kanio, aberinavo “Tealo aber jau kobe Jone Baruei, a tealo aber jau kobe Naverialiano Elaija, a tealo aber jau kobe naverialiano dolu nalo re nua nua tai napano meul bereio den nam̃ariano.” ");
INSERT INTO bki_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mo naio bika denlo, berinavo “?Mo ana jum̃abe ka kamiu, kamiu kumitum̃a kuber kiniou nebe kei?” Ana na Pitere naio berdop̃e, berinavo “Jau kobe Naverikariano na Atua kanano.” ");
INSERT INTO bki_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Naruei Yesu mil jikili, ber kalo memedu, berinavo mia nalo avan re averial vite nei ka tomu nalo, ");
INSERT INTO bki_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","mia naio ber batitigio bo banlo ka mia tum̃abe ka naio. Naio berenio berinavo “Kiniou nebe Kulorinio Kenerinio, mia navurim̃araboiano nalo na kulo Israel nalo kialo, vija tomu na tortoru na kulo lu nalo, bija naverloglogiano na tuboiano nalo, mia avukular kiniou, monoka mia ala vite ve telabo ka ala lelan kiniou. Mia monoka auebin kiniou nam̃aro, mia ka bogoti ve tolu nene, mia Atua rivitirilar kiniou nemeul bereio.” ");
INSERT INTO bki_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Naruei ea bogo na, Yesu mil banlo, naio berenio berinavo “Toro napano jidom rimei takisor kiniou, naio monoka sidom iakurano ga ea kanano sidomiano nalo, ana mia naio monoka rudu kanano m̃akolkolo ea legiano nonovio, jibe napano mia nodu kanaku, naruei naio takisor kiniou nam̃ariga. ");
INSERT INTO bki_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Neber jibe na bior toro na ver sidom ridururu kiano meuliano, mia naio rilaluvu kiano meuliano. Mia toro na ver rijamo ka kiano meuliano rivior kiniou, mia naio rijev kiano meuliano bereio. ");
INSERT INTO bki_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Avona ver toro tai bokar vite novo nalo na yetemeriba nei riviniu, mia rilaluvu m̃arabo a rilaluvu kiano meuliano, naio maka rijev vite novo tai leleio. ");
INSERT INTO bki_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Toro nam̃a mimou ka kulo dolu nalo miralo bior kiniou p̃eli bior kanaku iliano, mia kiniou Kulorinio Kenerinio, mia kiniou bunu noimou ea Atua mirano rivior toro nene, ea bogo napano mia nemei bereio eaio, napano mia nemei vija burum̃ara mermerano napano kanaku, a napano be karam̃aku kanano, a napano be nailiano lu nalo kanalo. ");
INSERT INTO bki_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riano kiniou neber ka kamiu, be tomu tai ajumolu aju ea vio nei, napano mia maka ajikia am̃aro, rivanvano-o rivokar bogo napano mia aial navenatuboiano na Atua kanano riyotuba.” ");
INSERT INTO bki_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iorou ka bogo na napano Yesu berenio iliano nalo na, titai jibe ka sude takurano barlaka bereio ruei, naruei naio buru Pitere, Jone, a Yemesi, nalo veri abavin ea burusuku tai, napano jidom rivolkouo. ");
INSERT INTO bki_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Naruei nalo abinimei abokar vio nene, a bogo nam̃a Yesu jom̃a bolkouo, naiagagoano tolu nalo nei amialio napano mirano binimei be dolu, a amialio ka napano m̃ano kulum̃arauo merera laka, a amiuvu bo mia amiuvu nonovio garuei. ");
INSERT INTO bki_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ana iorou, tormoruo juo nei Elaija naio Mosis, naljuo amiyotuba bija burum̃ara miamoiano na mermerano na tiniabene, ana na abe juo ajum̃a ajukunu naliko Yesu, napano ajum̃a aberii ka mia tum̃abe ana na mia naio monoka riva Yerusalemo, a monoka m̃aro den yetemeriba nei, tavukia napano Atua berkario ruei. ");
INSERT INTO bki_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mia beamu, Pitere nalo nei amijog miralo jouo toru, amiyukudovo banbano-o mia amonmelio garuei, mia bogo napano ajevijo bereio, amiilo ka vite nalo nei, napano amial Yesu kiano burum̃ara miamoiano na mermerano, a amial tomu juo nei ajumolu aju bijaio. ");
INSERT INTO bki_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Naruei nalo amial ka napano naljuo neibano aju ajuvan vio ka avan bereio, naruei Pitere naio jidom ril, mia maka rijikia vaio ka mia riverenio, ana naio ber ilikodovoiano tai ban Yesu, berenio berinavo “Tubo, bo ka napano kito rojua vio nei. Bo kanio kito roim̃auka tobobo ve tolu ea vio nei, tai ve kiamo, tai ve Mosis kiano, a tai ve Elaija kanano.” ");
INSERT INTO bki_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mia bogo napano naio jom̃a ber iliano nei, melijo tai binimei midukolo, mia bogo napano amialio ka nalo aju joomo ea melijo nene, nalo amerou binvinlo. ");
INSERT INTO bki_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Naruei amijog iliano tai miyotuba ea melijo neibano, naio berenio berinavo “Nina be keneriku na, napano kiniou nebitirilar naio ruei. Naina naruei monoka kumonmonea naio rivu.” ");
INSERT INTO bki_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mia bogo na iliano nei bisi, melijo bakovio, amial ka napano Yesu naio ga takurano ju naliko bereio. Iorou ka nina, naiagagoano nalo aju ajurbanin kanio ga aju, maka ava averii vite neibano amialio ka tomu dolu nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mia ea legiano dolu nene, Yesu naliko nalo tolu nei ajuvan burusuku nei, abatove bereio, mia burum̃ara tiniobi na tomu nalo aju rorea ka ajidom aial naio. ");
INSERT INTO bki_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mia bogo napano amiyotuba kalo, toro tai kalo bio jouo ban Yesu, naio berenio berinavo “Naverloglogiano, neber aiou banso, kovitii von keneriku m̃eaku nei, bior naio be keneriku takurano m̃anono ga. ");
INSERT INTO bki_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Niununo va tai jom̃a binimei ea naio jibe na, mila naio miaga burutomoruo laka, a miaburusalsal bano-o m̃a titilevlevi bavin eaio. Tenei jom̃a mila naio napano kirivova laka, mila lelan naio laka, a naio jom̃a monmon ga milaio, naio maka lele tuvan naio torm̃aro bogo tai. ");
INSERT INTO bki_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kiniou noburu naio ban ea kiamo naiagagoano nalo, neber aiou kalo ka ajilar niununo va nei, naruei nalo amila von, amim̃aukanio bano-o, mia abijukudeio ga.” ");
INSERT INTO bki_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Naruei Yesu berdop̃e, mil banlo, berinavo “?Kamiu na, jum̃abe jibe na? Kamiu maka kuvarkar tiniemiu sikili ea Atua leleio. ?Mia kiniou monoka noto vija kamiu kelvovu nalo riva rivokar nagi? Kiniou tinieku m̃aro ea kamiu ruei. Mo, bo ga, kovuru kenerimo nene rimei vonio.” ");
INSERT INTO bki_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naruei nalo aba aburu kiritete nene binimei, mia bogo napano aju abinimei kia ga vo, niununo va nei mila m̃ele niadua kiritete nei bereio-o mia, mila niabene memebiju a ba burukar jikili. Mia Yesu mil jikili, berbure niununo va nene, ana naio mieliel ka m̃eaku nene, naruei naio buru bereio ba ban karam̃ano. ");
INSERT INTO bki_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mia nalo napano amial vite nalo nei, nalo amiilo toru laka ka Atua kanano moroano na loa laka na kirinovo nei, napano mila bo laka jibe nei ban tete m̃eaku nei. Ana memedu ka bogo na napano m̃a kulo dolu nalo ajum̃a aberverii vite novo napano Yesu milaio, mia Yesu ber iliano tai ka kanano naiagagoano nalo. ");
INSERT INTO bki_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Naio ber kalo, berinavo “Kamiu kuvije tiliniemiu rivu ka kanaku iliano nei, kamiu kuvidu vatitigio toa kenemiu jidomiano nalo, ka mia tiniemiu ribobogia re bereio bogo tai. Nao, kiniou neber batitigio ban kamiu, Atua miila kiniou jibe Kulorinio Kenerinio, mia vaataro naruei ka mia adu kiniou navan ea tomu nalo jum̃alo napano mia ala bin kiniou nam̃aro.” ");
INSERT INTO bki_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mia naiagagoano nalo maka ajog lubar vo venia napano Yesu jom̃a berii kalo, jibe ka nioti nene joluku kia ga vo, mila maka ajikia ka avitilubario, a amerou bunu ka avika batitig den Yesu tivelinio ka iliano nene. ");
INSERT INTO bki_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mia iorou, ana baravo tai moluo iviso bure naiagagoano nalo, ka mia kei naio to mave ka nalo dolu. ");
INSERT INTO bki_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mia Yesu mijikia kialo jidomiano nalo, naruei naio bio kiritete tai napano jo miel binimei kanio, naruei naio midu kiritete nene ji ju tivelinio ka naio, ");
INSERT INTO bki_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ana naio ber kalo, berinavo “Toro napano kiano jidomiano batove ka kiniou, mo naio saaro ka rijev kiritete nei, nina javukia ga napano naio jaaro ka rijev kiniou. A toro nam̃a jaaro ka kiniou, jibe ka napano naio jaaro ka nana miila kiniou nebinimei. Nina bior nana ka kamiu napano kiano jidomiano rivatove laka, naio naruei napano mia naio loa laka ka kam nonovio.” ");
INSERT INTO bki_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ana Jone ber ka Yesu, berinavo “Tubo, kumemi numial toro tai, napano naio jom̃a mijil bulag sim̃aro nalo, naio jo mijil bulaglo ea siamo. Mia toro nene, kumemi maka nuvijikiaio, naio maka ve kito tai, naruei kumemi nuberbureio.” ");
INSERT INTO bki_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mia Yesu berkanio, berinavo “Makanio, kamiu kuverbure re naio, bior toro napano maka m̃a riverbure kito, naio jom̃a miija kito kiana.” ");
INSERT INTO bki_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mia Yesu bitilubar ka vonganei, vaataro ka mia Atua rivuru naio rivavin bereio tiniabene, naruei naio midu vatitig kiano jidomiano ruei ka kiano m̃arabo monoka rivavin mave Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana na nalo aju amiel abano, ana Yesu miila kiano atevi nalo ajukamu, aban ea m̃arkomeli tai na kulo Sameria kialo, ka ayomon vite nonovio rimemedu ka mia naio mijikia rimei iorou. ");
INSERT INTO bki_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mia nalo na vio na, maka asidom Yesu nalo amei jouro ea kialo vio, bior nalo maka atum̃a tiniel tii ka aija kulo Ju nalo, napano ajum̃a ajel ea kialo vio na abavin Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tilikiti napano naiagagoano juo nei Yemesi naio Jone naljuo amial ka napano nalo ajum̃a aberburelo jibe na, abika den Yesu, aberinavo “Tubo, kojidom nubolkouo, nuvio sebi tai taluvo ea vio mave rivatove sisen tanea nalo na?” ");
INSERT INTO bki_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mia Yesu naio bilig naio banlo, berbure kialo jidomiano na jikili nei. ");
INSERT INTO bki_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ana naio jukamu kalo, maka bunu ava jouro ea vio nei, mia amiel ga aban ea komeli dolu tai. ");
INSERT INTO bki_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tilikiti napano aju amiel ea m̃arabo abano, toro tai binimei vaataro ka Yesu, naio berkar banio, berinavo “Mia kiniou natakisorso, ea vio na vabe na jau kavan eaio.” ");
INSERT INTO bki_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ana Yesu berdop̃e banio, berinavo “Kuli deden nalo abe m̃alo bulukup̃ili na amon eaio, a menu nalo abe m̃alo niuku nalo. Mia kiniou Kulorinio Kenerinio napano nebinimei tiniabene, maka ve kiaku vio tai, ka mia nava nomon eaio. Ver jau kajaaro bunu ka meuliano na jibe na, jau komijikia komei.” ");
INSERT INTO bki_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ana ea bogo nei, toro dolu tai, Yesu berkanio bunu ber rimei takisorio, ana naio berdop̃e banio, berinavo “Tubo, bo ga, mia jau kajamo ka kiniou navan nevitikar kanaku tormoruo beamu vo, mia ver naio rim̃aro bogo tai, mia kiniou nemei bereio natakisorso.” ");
INSERT INTO bki_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ana Yesu ber ka naio, berinavo “Jau kotuvan tomu nalo napano maka ajev meuliano vo ka mia ava ativin kanalo tomu na am̃arm̃aro. Mia jau, komei ga, rava roioliolu ka Atua kanano navenatuboiano.” ");
INSERT INTO bki_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A dolu tai bunu mila sop̃eiano jibe nei, naio bika den Yesu, berinavo “Tubo, mia kiniou tulaka ga natakisorso, mia vite tai ga, kiniou nojidom ka jau kajamo ka kiniou nava never bogiano bo van nalo na ea kanaku vonuo beamu vo.” ");
INSERT INTO bki_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ana Yesu ber iliano tai banio jibe nei, berinavo “Toro nam̃a jom̃a jidom m̃elea kanano vonuo a kiano saba nalo nonovio nei, naio jibe toro nam̃a jelanvu ka uako, a julaka jom̃a jiraragdi. Toro na jibe na maka rivare ka rimei ve toro na Atua kiano navenatuboiano.” ");
INSERT INTO bki_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ana ea bogo na, kiado Tubo bitiri bulag kiano naiolioluano tealo bereio. Nalo duelimo va aluo ba juo 72 abiniu, a naio jom̃a jidomii ka mia rila lo ava atukamu ka naio, ava aveve juo ea m̃arkomeli a ea vio nalo napano mia naio rivarlaka ealo iorou. ");
INSERT INTO bki_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Naio berlogloglo jibe nei, naio berinavo “Be sinaniano miroano laka ju mermeruo ea tiniavio, mia tomu nalo maka ve telabo aju abarvar bijiilo binimei vonuo. Kamiu monoka kuvika sikili van boru na tiniavio nene, ka mia naio riila bulag tomu ta bunu avan ka avarvar sano sinaniano nene nalo rimei. ");
INSERT INTO bki_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ver tibe na, mo kamiu monoka kuvidu kenemiu m̃arabo kuvano. Mia bo kanio kamiu kuvitilubar ka nemiila kamiu kuba tavio, jibe ka napano kamiu kumitavukia nunu solbouo nalo, napano kumitum̃a kuba tavio ka mia kuviniua burum̃ara kuli deden nalo. ");
INSERT INTO bki_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Bogo na ver kamiu kuvano, mia kuvar re siveu na kenemiu puruveru, mia kuvar re kenemiu basaro nalo, a kuvar re kulubue na jaamiu tai bereio. Mia kuviel yauo ga tibe na kuvano, kuvitukunu p̃ilip̃ili re ea m̃arabo van tomu nalo. ");
INSERT INTO bki_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“A bogo napano kuvano-o kuviyotuba ea yimo na vabe, vite na be moti ka mia kuverenio, kuver tibe nei, kuverinavo ‘Tum̃aro toa vonuo nei.’ ");
INSERT INTO bki_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ana verenio toro na toa vonuo nei naio tinien tii ka tum̃aro, mia tum̃aro neibano kuberenio mijikia to vija naio, mia verenio ve re toro tai tibe na, mia tum̃aro nei rimei ea kamiu bereio. ");
INSERT INTO bki_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A kamiu kuvitatan ea re yimo nalo, mia kamiu kuvitua ga yimo ve takurano nei ga, mia kamiu kuvisaaro ga ka kumisen sinaniano vaio p̃eli na kumunu vaio na avar rimei asian van kamiu. Kamiu kuvimou re ka kuvijev vite novo vaio napano ajidom ala van kamiu, bior memedu ga ka toro na im̃auano monoka rivar kiano ijaiano ve telisu. ");
INSERT INTO bki_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Tibe na, m̃arkomeli na vabe na kuva kuviyotuba eaio, ver asaaro ka avitikar kamiu, mia monoka kamiu kuvisaaro ka sinaniano vaio napano mia asian van kamiu, ");
INSERT INTO bki_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","a mia kamiu monoka kuvieliel ka tomu na mieiano nalo na vio nene, a kamiu kuvijikia kuver kalo, kuver ‘Vonganei, Atua kanano navenatuboiano binimei vaataro ka kamiu, vonganei Atua jo binimei ka ve kenemiu Tubo naruei.’ ");
INSERT INTO bki_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“A bogo tealo mia kamiu kumalmaluvo ea m̃arkomeli tai, mia nalo asaaro re ka mia avuru kamiu kuva kuvitu kamliko. Verenio tibe na, mia kamiu kuvitakii ga m̃arabo labo kuvan na jel jouro medave ea komeli nene, a kuverial ka tomu nene nalo tibe na, kuverinavo ");
INSERT INTO bki_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yevi na m̃arabo na kenemiu vio nei, kumemi numijuba kon bulagio den jaamemi, jibe ka kijokijo tai ka kamiu kuvisidomiio. Kamiu monoka tiniemiu ribobogia re, ka vaataro ga ka Atua kanano navenatuboiano riviedu kean kamiu ruei, mia kamiu kumilkue kanio, naruei kumilaluvuio ruei.’ ");
INSERT INTO bki_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Kiniou neber riano ka kamiu, ka legiano na tibureiano, mia nalo na jibe na avar vironiano nana jikili loa tovulu nana mia nalo na bulukomeli na Sotomo re nua mia nalo avario.” ");
INSERT INTO bki_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Naruei Yesu mil jikili ban tomu nalo ea vio tealo, berenio berinavo “!Kulo Korosin, bija kulo Betsaeta, kamiu kumila lelan kamiu toru liki-e mia! Ver kulo Taia vija kulo Saiton nalo aial kijokijo neibano kamiu kumialio ruei nei, mia nalo aviliglo nua ruei. Nalo maka ave kulo Ju, mia nalo aya m̃adabake ga a avuku bulukievi ea pariparilo ruei, nalo atutano atu tibe na ka tomu nalo avitilubar ka nalo amijog bova toru riano bior kialo kariano nalo. ");
INSERT INTO bki_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kiniou neber ka kamiu, ea bogo na tibureiano, mia kenemiu vironiano tovulu napano ve nalo nei kanalo. ");
INSERT INTO bki_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“!A kamiu kulo Kapeneam, napano kubarvar ka kamiu m̃ele, napano m̃a kumisidom kumijalar kamiu ka kumitu mave levlevi, kamiu kuvitikar kamiu! Mia Atua rivuku bulag kamiu kuvatove laka ea bulukuti sebi.” ");
INSERT INTO bki_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","A Yesu ber bunu ka nalo, berinavo “Toro napano verenio ka mia naio rudukar kamiu, naio jo midukar kiniou, a ver toro napano maka sidom kamiu, naio jo maka sidom kiniou, a ver toro na maka sidom kiniou jibe na, naio jo maka sidom toro na toru napano naio miila kiniou nebinimei.” Naruei bija iliano na, Yesu miila kiano naiolioluano nalo abatavio ka ala im̃auano. ");
INSERT INTO bki_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Naruei naiolioluano nalo nei aba amila im̃auano novo nalo telabo, karina iorou kanio ana abinimei bereio ea Yesu, napano tinielo bujo laka ka saariano ka vite nalo napano m̃a amilaio. Abinimei bereio aber ka Yesu, aberinavo “!Tubo, kumemi numim̃auka vite nalo ea siamo bano-o bokar napano sim̃aro nalo bunu ajutano ka kumemi!” ");
INSERT INTO bki_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ana na Yesu berdop̃elo berinavo “Ee, kiado im̃auano jibe na naruei. A kiniou bunu, nemial Sim̃aro jumolu den tiniabene, amiila deven naio mijoru batove jibe ka viobijiio tai. ");
INSERT INTO bki_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vonganei, kiniou nomijamo ka ban kamiu ruei, ka kamiu kumijikia kuvivikar maro a buruolu, a moroano na kiado uolu kiano naio totano ka jaamiu bunu, ana mia ve re titai rijikia re rila bulag kamiu. ");
INSERT INTO bki_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mia kamiu kuvarvar ka kamiu re ka vaio napano kiniou nemijamo ka ban kamiu, napano niununo va nalo ajutano ka kamiu, mia be vite takurano ga napano kamiu kumijikia kuvujo ka saariano kanio, nina napano siemiu nalo, ajirikakarlo aju joomo ea niosi na meuliano ruei.” ");
INSERT INTO bki_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mia ka bogo nei, Yesu bolkouo, berinavo “!Teta o, Tubo na vio mave a Tubo na yetemeriba! Neber siva banso, bior vite nalo napano ea tivelinio na kiniou, jau kobisip̃eio banlo napano kialo jidomiano jibe ka kiritete nalo ga, mia nalo napano ajidomii ka abe m̃asou laka, bija nalo napano ajidomii aber amijikia vite, mia jau komilavan vite nalo nei kalo. Riano, Teta, ninei javukia ga nana jau kojidomiio.” ");
INSERT INTO bki_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A Yesu ber bunu berinavo “Karam̃aku mijamo ka vite nonovio jua jum̃aku ruei. Teta naio ga takurano napano mijikia batitig kiniou ka nobe kei, a kiniou napano nobe kenerinio, kiniou ga takurano napano nomijikia batitig naio, ka naio be kei. Kiniou bija nalo napano nebijauia bulaglo abe kanaku, ka mia nesiloglog Teta kalo ka mia avarkar tinielo eaio, kumemi naruei numijikia batitig naio ka naio be karimememi.” ");
INSERT INTO bki_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Naurei Yesu barp̃ilig ka kiano naiaga-goano memedu nalo, naio mijuvaluva banlo bare ka nalo ga ajogio, naio berinavo “Atua mila bo ban kamiu, napano kumijikia kuvial vite nalo na. ");
INSERT INTO bki_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Naverialiano telabo a parinio tubo telabo re nua napano ajidom m̃elea ka aial vite nalo na, mia maka aial kija bogo tai, a abijuku kouo ka ajog vite nalo na bunu, mia maka ajog kija leleio.” ");
INSERT INTO bki_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mia bogo tai bereio, toro tai napano be m̃asou bo ka tuboiano, naio jidom rijukujuku Yesu ea vikadeniano tai na kirisikili, naruei naio jumolu ju, bika den Yesu, berinavo “?Naverloglogiano, verenio kiniou nesidom nalavon ka navokar meuliano napano maka ve jukuti nene, mia kiniou monoka nala tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naruei Yesu berdop̃e banio, berinavo “?Mia kiado Niosi Lu naio ber venia ka tivelinio na? ?Jau kobuluku komialio ber jum̃abe?” ");
INSERT INTO bki_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ana na toro neibano berdop̃eio berinavo “Niosi Lu ber jibe nei, berinavo: Atua Sop̃i napano naio be kiamo Atua, jau monoka tiniemo tii naio, kodu naio to tukamu ea kiamo iviso momou, a ea kiamo meuliano momou, a ea kiamo sikiliano momou, a ea kiamo jidomiano momou, a jau monoka tiniemo tii nalo napano aju vaataro kaso, jau kovijuku rivu kalo, tavukia napano m̃a tiniem jiiso.” ");
INSERT INTO bki_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ana Yesu berkanio, berinavo “Nao, jau kober kirimemedu tanea na. Mia ver jau kala tibe na, mia jau kovokar meuliano na kojom̃a kobikanio na.” ");
INSERT INTO bki_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mia tete nei nao mijikia ka naio maka tom̃a rila rimemedu tibe na, mia naio jidom rila sop̃eiano, naio bika den Yesu, berinavo “?Ana be kei nalo napano m̃a ajuju vaataro ka kiniou, napano kiniou monoka nala rivu kalo?” ");
INSERT INTO bki_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Naruei Yesu berdop̃e kiano vikadeniano nei ea jamerijiano tai, napano naio ber jibe nei berinavo: Toro tai, bogo tai naio juvan vio Yerusalemo naio jo miel batove yako Jeriko. Naruei naio jom̃a miel ba bokar vio kouo tai, naruei naio miilo ka taara tai na tomu nalo na vinauano, napano abiako eaio, amue tanea, naio, abar bulag nonovio kiano saba nalo, ana aburo kilkil, napano ajuvan toro nei m̃ariulu mijoru joa kiano m̃arabo togio. ");
INSERT INTO bki_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ana kanado toro lu tai, naio bunu jo miel naio iorou kanio ea m̃arabo nene, ana bogo na naio binimei vaataro kean toro neibano, naio ju p̃ilig kanio jel ea ikim̃arabo tivelinio ka ga bano, naio miel barlaka denio ban ga. ");
INSERT INTO bki_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ana iorou kanio, ana toro dolu tai miel binimei. Naio be Livai nalo tai na, napano ajum̃a amila im̃auano nalo nonovio ea Atua Kunuano Lu, mia bogo na binimei bokar toro nei, naio bunu maka sidom rijai naio, naio miel ga barlaka ban ea ikim̃arabo tivelinio ban ga. ");
INSERT INTO bki_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mia iorou ka bereio, toro dolu tai, napano naio jo miel ea kiano burutili m̃arabo na, naio binimei. Naio be tete re Sameria tai, naruei jibe napano romijikia, nalo nene abe bilbilu va toru naliko kito kulo Ju nalo. Mia bogo na naio binimei bokar vio na, mial toro na m̃ariulu mijoru mon ea m̃arabo, mia tinien miia naio toru. ");
INSERT INTO bki_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","“Mia naio binimei vaataro keanio, ana jekon batitigio kiano niajebijo nalo, a mia titikivaka ealo, a bitakar batitiglo bo. Naruei naio burular toro nene jumolu, midu jotano mon mave ea kiano togki taakano, ana miel ka bija naio bano-o abinimei abokar vio tai napano be yimo na jilimebiano tai joaio. Ana naio buru toro neibano ba joomo ea vio nene, miija batitig naio bo mia bo laka. ");
INSERT INTO bki_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Mia kavijo, ana naio bar kanano puruveru tai, bar ban boru na yimo na jilimebiano nei, berenio berinavo ‘Kiniou monoka navan ea kanaku m̃arabo, mia toro nei toa jum̃amo beamu vo. Kovitikar batitig ka vite nonovio, a verenio puruveru na rivare re, mia kiniou nevitii bereio ka bogo na nemei nei bereio ea kanaku ieliano.’ ” ");
INSERT INTO bki_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naruei Yesu bika den toro neibano bika vikadeniano nei denio, berinavo “?Jau komial tukunu nei jum̃abe? ?Ka nalo tolu neibano amiel ea m̃arabo napano toro nei jo mon eaio, na vabe kalo mila banio jibe ka napano naio be toro tai napano jo vaataro ka naio?” ");
INSERT INTO bki_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ana na toro nei berinavo “P̃eli nana tinien miiaio.” Mia Yesu ber ka bereio, berinavo “Ee naio nao, a jau bunu, jau kava kataki kiano bajago novo na.” ");
INSERT INTO bki_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mia ka bogo na, Yesu naliko kiano naiagagoano nalo ajum̃a amiel abavin mave Yerusalemo, naruei nalo amalmaluvo ea m̃arkomeli na telisu na Betani, ana ea vio na tira na Marita naio buru Yesu ban ea kialo vonuo. ");
INSERT INTO bki_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mia bogo na Yesu ba jo bijalo, ana Marita nene kuluene tai, siano Mere, naio jotano kamu ka Yesu jaano, naio jom̃a miagago ka kiano verloglogiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mia ka bogo na, Marita maka tovon ka riagago, naio jom̃a bukudeli toru ka rila vite nonovio riviniu tu vatitig rorea Yesu, a naio jo jidomii bijovijon ka im̃auano nalo nei. Mia iorou kanio, ana naio binimei mial Mere naio jom̃a jotano, naio jom̃a miagago ka Yesu, naruei naio ber ka Yesu, berinavo “Tubo, kulueku na naio jotano kurano ga jum̃abe na, napano kiniou ga takurano nojom̃a nomila vite nonovio nalo. P̃eli jau maka koto kovitilubar koviobo, mia bo kanio jau kover ka rimei riija kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mia kiado Tubo berdop̃e naio berinavo “Marita, jau kobe tira tai nam̃a kojo kojidom bijovijon vite m̃ele, a jau kojom̃a komijog bova m̃ele ka vite telabo na jibe na. ");
INSERT INTO bki_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mia be vite takurano ga jo ka mia jau kosidomii ve temi kanio, a vite nene Mere nei naio jo mileal ruei ea kiano meuliano, mia maka nejikia nodu lario den naio bereio.” ");
INSERT INTO bki_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bogoti tai, Yesu ba bolkouo ea vio tai, avona bisi, ana naio binimei bereio, ana na kiano naiagagoano nalo tai bika denio, berinavo “Tubo, bo laka ka ver jau kalavon ka koverloglog kumemi ka kumemi bunu nuvijikia nubolkouo, tavukia na Jone berloglog kiano naiagagoano nalo beamu ka abolkouo tavukia naio.” ");
INSERT INTO bki_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ana Yesu mijamo kanio, naio berinavo “Mo, ver kamiu kuvisidom kubolkouo, kamiu kumijikia kuver tibe nei, kuverinavo: ‘Karamememi, memedu ga ka kumemi nuvitu nuvatove ka siamo lu. Kumemi nubolkouo ka kiamo navenatuboiano rimei. ");
INSERT INTO bki_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kumemi nubika denso ka kavar simemi sinaniano na banei a legiano nonovio. ");
INSERT INTO bki_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A koviekokoa kumemi rivior kenememi kariano nalo, bior nam̃a kumemi numitum̃a nubiekokoa nalo nam̃a abijuku bova ban kumemi. A jau kotuvan re vite nalo alavon kumemi m̃ele.’ ” ");
INSERT INTO bki_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Mia Yesu naio jidom ka nalo monoka amerou re ka avika vite den Atua, naruei naio ber jamerijiano tai banlo, berinavo “Verenio ka bogiano vio vare, keiilo ka kanamo bilbilu tai napano miel binimei boru ea kanamo vonuo. Mia samo sinaniano maka bunu tai rito, mia monoka jau ketikiti kavan ea tai na kunuano jo vaataro keanso, monoka kovika sikili denio, kover ‘Koig, bilbilu tai miyotuba ka kiniou vonganei ga, mia kiniou nebe deio riano. Maka bunu ve titai leleio ka mia nomijikia nodu rivan naio ka mia senio. ?Jau samo sinaniano tai beva ju kovio napano komijikia kajamo kanio van kiniou beamu vo?’ ");
INSERT INTO bki_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Mia jum̃abe, rojidomii rober p̃eli mia toro na mijikia riverdop̃e, verinavo ‘Ee koig, jau kala m̃elea re kiniou tibe na. Jau keialio, kumemi numituboniko m̃aratavo ruei, mia kumemliko kiritete nalo, kumemi numitua mememi jogu nalo ruei, naruei maka bunu nejikia notumolu bereio.’ Mia toro na maka rijikia river tibe na.” ");
INSERT INTO bki_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mia Yesu naio jusol tukunuano, ana naio ber kalo, berinavo “P̃eli bogo tealo toro tai rijikia sidomii iakurano ka riijaso bior jau kojo vaataro ga ka naio. Mia ver jau koim̃au re ka kovivika sikili denio vano-o, mia monoka sian vite venia napano m̃a kojo kobivika banio.” ");
INSERT INTO bki_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Mia tibe ka kiano jamerijiano Yesu ber bunu kalo berinavo “Toro na ver jom̃a bika vite, julaka mia naio mijikia rijevio, mia verenio toro na jom̃a jirag vite julaka, mia naio mijikia rilealio, mia ver toro na jom̃a miniania m̃aratavo julaka, mia m̃aratavo nene mijikia rivetavo kanio. Tibe na, mia kamiu kumijikia kuvar vite nalo nam̃a kumitum̃a kubika denio, a mia kamiu kuvileal venia na kamiu kumitum̃a kumisiragio denio, a m̃aratavo nam̃a kumitum̃a kuminianiaio mia naio rivetavo ka kamiu. ");
INSERT INTO bki_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ver kenerimo tai siserio, naio rivika niado sesa na jo, mia maka kejikia kodu maro tai vanio, ");
INSERT INTO bki_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","p̃eli na ver rivika boboti tu na jo, mia maka kejikia kodu buruolu rivan naio ka senio. ");
INSERT INTO bki_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Be riano ka kamiu kube tomu na kirivova ga nalo, mia maka kamiu tai mijikia rila tibe na, kamiu kumitu kumisaaro julaka ga kam̃a kumisian tonovo nalo ban kenerimiu nalo. Jibe ga na, bogo napano kamiu kumitum̃a kubika den karamemiu na tiniabene, naio jaaro ga ka sian Niununo Lu van kamiu kenerinio nalo.” ");
INSERT INTO bki_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana iorou kanio, ana aburu m̃arabo ka toro tai na sim̃aro ban ea naio binimei ban Yesu, sim̃aro nene mila toro nei maka ril, mia Yesu mijidiglar sim̃aro nene denio, naruei naio mil bo bereio, mila ana nalo napano amial vite nei amiilo toru laka. ");
INSERT INTO bki_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mia nalo tealo amijoku, naruei nalo aberii niegeniege Yesu, nalo aberinavo “Tete na naio jom̃a mijil bulag sim̃aro nalo ea ga moroano na sim̃aro nalo kanalo tubo, napano siano Belsabel, naio mijamo ka ban naio.” ");
INSERT INTO bki_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A nalo tai bereio, ajidomii bova bunu ka Yesu, naruei nalo ajum̃a amilavon naio, nalo ajidom ala lup̃ilup̃i naio ka naio rila kijokijo tai ea moroano na vio mave ka amijikia aialio. ");
INSERT INTO bki_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mia Yesu mijoglubarbar kialo jidomiano nalo, ana na naio berinavo “Ver tubo tai, kanano tomu nalo avuruburelo, napano mia togio atup̃elo ka togio dolu, mia tubo nene kanano im̃auano nalo monoka atibirbil. A ver vonuo tai, atum̃a avuruburelo napano togio sidom rijil togio dolu, mia nalo na maka ajikia atu rivu bogo tai. ");
INSERT INTO bki_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","?Jibe ga na bunu, ver sim̃aro nalo na Setano kanano atum̃a avuruburevurelo ruei, ana mia navenatuboiano na Setano kanano tumolu tu tum̃abe? !Ana kamiu kumitum̃a kuberinavo jibe na naruei, ka kuber kiniou nojom̃a nemijil bulag sim̃aro dolu nalo ea moroano na burum̃ara sim̃aro na Belsabel kanano, mia maka rijikia tibe na leleio! ");
INSERT INTO bki_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?Mia ver tibe ka nam̃a kamiu kuberenio, jum̃abe naruei ana kam tealo bunu ajum̃a amijil bulag sim̃aro? ?Kei naio mijamo ka moroano na banlo, p̃eli Setano bunu ga bo? Bo ka ver kenemiu naiagagoano nalo nam̃a ajum̃a amijil bulag sim̃aro nalo ajog kenemiu iliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mia makanio, kamiu kuber nina maka rimemedu na. Mia kiniou nojom̃a nemijil bulag sim̃aro nalo ea moroano na Atua jum̃ano ga, mia vite na berialio ka Atua kanano navenatuboiano naio ju iviso ka kamiu ruei. ");
INSERT INTO bki_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“!Kamiu kuvialio! Jibe kanio napano ver torkouo tai, naio rivar kiano saba na mira nalo, a tukuku vatitig ka burum̃ara kunuano. Naruei, vite nalo na toru nei kiano aju bo ga jouro ea kanano burusio. Naina naruei Setano kiano im̃auano jibe na naruei. ");
INSERT INTO bki_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mia ver torkouo dolu tai rimei napano naio p̃irinio jikili loa naio, mia naio rila mira kanio-o tuvulu Setano, ana mia naio mijikia rivar bulag vite nalo na mira na be kanano, napano beamu barkar tinieno eaio, a naio mijikia rivar vite nonovio napano ju jouro ea burusio na torkouo kanano, tan kalo van kanano tomu nalo. ");
INSERT INTO bki_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Toro napano maka takisor kiniou, naio jo berbure kiniou, a toro na maka rim̃au vija kiniou ka kumemi nuvuru kanaku tomu nalo amei vio takurano, naio jom̃a mijil dedade ealo abeve terakurano.” ");
INSERT INTO bki_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ana Yesu ber bunu, berinavo “Bogo tai, bogo nam̃a amijil lar niadu den toro tai, niadu nene mijikia riva yeturu ka sirago kunuano dolu tai. Mia ver rileal re tai, mia naio riverinavo ‘Ee, mia nalavon ka navan bere ea kunuaku moruo na beamu vo.’ ");
INSERT INTO bki_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mia bogo napano naio binimei, mia rileal ka yimo nene meravo bo jo, abar batitig vite nene nalo biniu ju memedu bo ruei. ");
INSERT INTO bki_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ana mia naio rivan rivuru niadu ve aluo dolu napano nalo abova loa naio lie vo, amei vija naio, ka na mia nalo ava joomo bereio ka atua toro nene. Ana toro nene, beamu kiano meuliano bova, mia iorou kiano meuliano bova bova laka.” ");
INSERT INTO bki_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ana ka bogo na, tira tai jo naliko nalo napano ajum̃a amial vite nalo nei, napano m̃a amijog Yesu kanano iliano, naruei tira nei jaaro m̃ele kanio. Mia naio miaga m̃erere laka naio berinavo “!Aiou liki! Koniomo napano bariso, midu yu banso, Atua kiano ilivuiano ve toru laka toa naio, napano bar tete tai jibe ka jau.” ");
INSERT INTO bki_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mia Yesu berdop̃e ban naio, berinavo “Nao, nina be riano na, mia kiniou neber ka jau ka mia Atua kiano ilivuiano rimei ve toru lie bereio vo van toro kei napano naio monmonea Atua kiano iliano nalo, naio mila venia napano naio jom̃a berenio.” ");
INSERT INTO bki_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ana ka bogo na, tiniobi nalo nam̃a amiagago ka Yesu nalo aju abinimei telabo lie vo, mia Yesu naio mijikia ka nalo miroano kalo nalo abinimei ka ajidom aial kiano kijokijo nalo ga, ana naio mil banlo, berinavo “Kiniou nemial jibe ka tomu nalo na taara na kenemiu banei abova laka. Nalo aju ajidom aial kijokijo toru laka, mia makanio, mia Atua maka rijikia sian kijokijo tai leleio vanlo. Mia naverialiano Jona, kiano kijokijo re nua ga, nina ga mia amijikia aialio. ");
INSERT INTO bki_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Atua miila Jona, jibe ka kijokijo tai ban nalo na vio Nineva re nua ruei, ana naio miila bunu kiniou Kulorinio Kenerinio nebinimei jibe kijokijo tai ban kamiu na vonganei. ");
INSERT INTO bki_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Mia kulo Nineva re nua napano amijog Jona kiano iliano nalo, abiliglo ka bogo nene, a mia nalo na atumolu ea legiano na tibureiano, mia aver bulag rimemedu kenemiu torokoriano nalo, bior be toro tai napano naio loa laka ka Jona naio jo bija kamiu, mia maka kuvilig kamiu. “Nanua bogo tai bunu tira na toru tai na naio be parinio tubo tai napano naio jumolu ea kiano buruvenuo, napano jo koalabo laka, naio batove binimei ka rijog tormoruo parinio tubo Solomon kiano ilimasosouano. Naruei tira na toru nei bunu mia naio tumolu tu ea legiano na tibureiano, naio river bulag rimemedu kenemiu torokoriano nalo, bior be toro tai napano naio be masou loa Solomon naio jo bija kamiu, mia kamiu maka kuvisidom naio leleio.” ");
INSERT INTO bki_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mia Yesu ber bunu, berinavo “Bogo na ver rejelan yulu, kito maka retelan ka mia rava roduvanio toa bulutanbo tai ea borotano, p̃eli na mia kito reivekoio ka basaro tai bereio, mia kito rejelanio ka mia reiveio takilele mave, ka mia ver toro na rimei mia mijikia rial ka yulu mereralii vio nonovio biniu.” ");
INSERT INTO bki_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A Yesu ber bunu, berinavo “Toro mirano naio jibe ka vio takurano napano yulu mijikia mereraliio binimei joomo ea mokotenano. Tibe na, ver miramo rimeravo rivu, rivitii batitig vite nalo, mia tibe ka napano tiniemo bujo magmago ka yulu. Mia verenio miramo rivova, tinie jii vite nonovio nam̃a jom̃a mialio, mia jibe kanio napano tiniemo bujo magmago ka melijokouo. ");
INSERT INTO bki_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tibe na, mia kamiu monoka kuvitikar rivu, ka yulu napano joa tiniemiu rimei re bunu tibe ka melijokouo bereio. ");
INSERT INTO bki_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mia ver tiniemiu rivujo ka yulu tulaka nam̃ariga, napano maka ve melijokouo tai ve telisu toaio, mia kenemiu meuliano rimerera vatitig rivu, rudulii vatitig vio nonovio rivu.” ");
INSERT INTO bki_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mia Yesu mil ban tiniobi nalo bano-o, naruei Varisis tai napano jom̃a miagago kanio ber ka Yesu berinavo mia rivuru naio rivan ea kunuano, ka rila sano sinaniano tai. Ana na Yesu ban bija naio, mia bogo na sinaniano amiomon ju, Yesu ba jotano ea vio na sinaniano. ");
INSERT INTO bki_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Naruei ka bogo nene, Varisis nalo abokar jikili kialo tuboiano tai ka toro monoka takii m̃arabo tealo ka m̃a sekon jum̃ano karina mijikia sinano. Mia Varisis nei naio jidom ber Yesu naio be toro lu tai, naio monoka rila tibe ka napano kialo bajago na jikili nei berenio, mia bogo napano naio mial ka Yesu maka sidom bijon ka naio rilaio, naio miilo toru laka kanio. ");
INSERT INTO bki_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ana Tubo mil ban toro nei, naio berinavo “Kiniou nemijikia kenemiu bajago kamiu Varisis nalo ruei. Kamiu tiniemiu jii m̃elea ka m̃a kumisekon vatitig rivu dam̃ariga kenemiu baja nalo a kenemiu baju nalo, ana kumitum̃a kube m̃arou kanio, kumitum̃a kuberiam̃a kamiu kumeravo, a kube lu. Mia burum̃ara niamiamo na bijurukar kamiu kia navo, bior kenemiu iviso nalo abujo magmago ka m̃a kumijukubin toro, a kumila kiki toro, a bajago nalo na kirivova jibe na. ");
INSERT INTO bki_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Ai, abe mia m̃a kuviavovu m̃elea re tibe na! ?Kamiu maka kuvitilubar ka Atua nam̃a jii vatavio na vite nonovio, naio ji bunu vajoomo na vite nonovio, mia bo laka ka ver kamiu kuvilakon nono tivelinio na kamiu rimeravo rivu ve riano, vatavio a vajoomo bunu. ");
INSERT INTO bki_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tonovo nalo nam̃a kamiu kumitum̃a kumisonlo toru bogo nonovio ban ea kenemiu baju nalo a bija kenemiu baja nalo, ver kamiu kuvitum̃a kuvilavon ka m̃a kuvio ka kija ga rivan talim̃asa nalo ga, mia rivu. Ver tibe na, p̃eli mia kamiu kuvial ka kenemiu vite nonovio nalo amei rimeravo vatitig ruei, ana mia m̃a kumila bijon re bunu kenemiu bajago dolu nalo.” ");
INSERT INTO bki_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Naruei Yesu berii bajago nalo na juboluboiano na navurim̃araboiano na nalotuano nalo ba lie vo, naio berinavo “!Kamiu kulo Varisis, aua! Kamiu kumila bulag kamiu toru laka, mia rivova laka van kamiu. Kiniou nemijikia ka kamiu kumitum̃a kubitikar batitig bo dam̃ariga, ka ver kubar semiu m̃arsinaniano duelimo, mia monoka ve takurano rivan ea Atua kunuano, tavukia na tuboiano naio jom̃a berenio, a kumitum̃a kumila jibe na ka saba nonovio na be kenemiu, ba bokar bunu m̃asebitu sesa nalo a vite nalo bunu na jibe ka m̃arsili nalo. Mia vite nalo na tomormoruo nam̃a tuboiano berenio, kamiu maka kuvisidomialio leleio, jibe ka nam̃a ber monoka kamiu kumemedu rivu, a kamiu monoka tiniemiu tii Atua a kulo dolu nalo bunu. Ver kamiu kuvisidom kuvokar sikili vite nalo na tertelisu nei, naio bo ga, mia vite nalo na tomormoruo nei naruei naio bo ka kamiu kuvitum̃a kuvila ruei, mia maka lele kuvilaio. ");
INSERT INTO bki_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“!Kamiu kulo Varisis o! Kamiu kumila lelan kamiu toru laka, mia rivova laka van kamiu. Joomo ea yimo nalo na volkouano, kamiu kumisidom ka bogo nonovio kuvitutano ea vio na be tomu na tortoru nalo jelelo ga, a verenio kuviel ea tomu nalo miralo, kumisidom ka avatove ka kamiu, a avio vatitig kamiu, a averinavo ‘Aiou, naverloglogiano novo, kavijo bo!’ ");
INSERT INTO bki_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mia ve kirivova laka rivan kamiu bior kamiu kube tekurano ga, kumitavukia m̃artanbo moruo nalo na tinielo bobogia ea ruei, amiel p̃ilinio mave ea ga, maka bunu ve tinielo ka vite jono tai napano menunu mon tano nei.” ");
INSERT INTO bki_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ana ea bogo na, toro tai napano naio be masou bo ka tuboiano, naio bunu jom̃a miagago, ana mijog jibe ka Yesu kiano iliano bokar naio bunu bija nalo napano amim̃au jibe ka naio, ana na naio berinavo “!Naverloglogiano, kiniou nomijog jibe ka kojidom keil niegeniege kumemi bunu!” ");
INSERT INTO bki_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ana Yesu berdop̃e, naio berinavo “!Nao-o, mia rivova van kamiu tomu nalo natuboiano bunu! Kamiu kumitum̃a kubitiri bulag bereio tuboiano sesa nalo tivelinio ka nalotuano bogo nonovio, nalo ajibe ka vite na teremi napano kumivon kakarlo ea tomu nalo taakalo ka monoka avarlo, mia kamiu kumitu jibe na ga, maka kuvikulkulu ka m̃arjukujumemiu tai leleio ka rilavon ka riijailo. ");
INSERT INTO bki_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mia rivova van kamiu, bior kamiu kumitum̃a kumiyovovua batitig m̃artanbo na naverialiano nalo na Atua kiano, mia kamiu kubevirare ga ka korobimiu tormoruo nalo re nua, napano nalo naruei amuebinvin naverialiano nene nalo am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kamiu bija nalo nei kubare ga, bior nanua, tormoruo nalo nei amue naverialiano nalo, mia banei kamiu kumisaaro ka kialo im̃auano nene, kumitusolio bereio napano m̃a kumitum̃a kumiyovovua martanbo nene nalo. ");
INSERT INTO bki_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kamiu kumitibe ka ga napano ilimasosouano na Atua kiano ber nua, naio berinavo ‘Mia kiniou neiila kiaku naverialiano nalo a atevi nalo aviedu ealo, mia ala lelanlo, p̃eli mia auebinvinlo am̃arm̃aro.’ ");
INSERT INTO bki_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iliano nei sano nioti nene ber mia kamiu naruei kuvokar vironiano nam̃a korobimiu nalo re nua amuebinvin naverialiano nonovio nalo, jikar ka bogo na tikariano na yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nina jikar ea Epel, binimei bokar Sakaraia, napano korobimiu nalo amue tam̃aria naio iviso ka boda bija Vio Lu joomo ea Atua Kunuano Lu. Riano, kiniou neber ka kamiu nei, ka vironiano na burukija na Atua kiano naverialiano nalo jua kamiu na vonganei. ");
INSERT INTO bki_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nao, mia ve kirivova lie vo van kamiu tomu nam̃a amijikia batitig tuboiano, bior kamiu naruei kumidu van navetavoiano na m̃aratavo na jikiaiano, ana kamiu maka bunu kuvitum̃a kuva joomo eaio, a kamiu kumitum̃a kumituko m̃arabo ka tomu dolu nalo nam̃a ajum̃a amila vio ka ava jouro.” ");
INSERT INTO bki_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ana Yesu ber iliano nalo nei bisi ana naio batavio den yimo neibano, naruei naverloglogiano na tuboiano naliko Varisis nalo tinielo bitunu tanea ka naio, napano tiniel mimi laka. Ana na nalo abie sosor Yesu dam̃ariga, nalo ajum̃a abika iliano nalo a vikadeniano nalo na jikirkili banio, ka alavon ka ayukuru naio a ka rila naio river iliano tai na maka rimemedu. ");
INSERT INTO bki_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Amiliviko Yesu jibe naio be temeul deden tai, bior ajidom ka aleal kiano iliano nalo tai ka mia amijikia atibure naio riviorio. ");
INSERT INTO bki_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ana na tiniobi nalo ajum̃a abinimei ea Yesu keano vo, ajovulu menu na tomu nalo miroano. Mia bogo nam̃a abinimei vio takurano jibe na, vio telisu garuei, napano m̃a ajum̃a amivinkakarlo ga. Ana na bogo na Yesu maka ril vanlo vo, mia naio mil ban kiano naiagagoano nalo jukamu, berinavo “Kamiu monoka kuvitikar vatitigio ka Varisis nalo kialo bajago va nalo, bior nalo ajum̃a amil ka kuluniolo ga, ajum̃a amil moruo mia amila sibi ga. Kialo bajago va nalo nei amijikia amaluvo rivokar a rila bulag toro dolu nalo, jibe isi na joko telisu ga mia kirisop̃eli ba mim̃au bokar joko nonovio. ");
INSERT INTO bki_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vite nonovio na bova nam̃a tomu na jibe na ajum̃a amilavanio, p̃eli nam̃a aber luklukua ga, mia amalmaluvo ea vio medave navo, ka mia aviniu ajikiaio. ");
INSERT INTO bki_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iliano vaio nam̃a toro jom̃a berenio ea meljokouo, mia monoka ajogio bereio ea legiano, a vite nalo nam̃a toro jom̃a mijuvaluva kanio ea kunuano ga, mia aiaga m̃erere bereio ea tomu nalo miralo, ka mia aviniu amijikia ajogio.” ");
INSERT INTO bki_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ana na Yesu ber ka bunu kiano naiagagoano nalo, naio berinavo “Banalo, kiniou neber ka kamiu ka kamiu kumerou re ka nalo nam̃a amijikia aue tam̃aria mokotenemiu nalo ga, karina mia maka bunu ajikia ala titai bereio ka niunumiu nalo. ");
INSERT INTO bki_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mia nejidom neil vatitig rivan kamiu ka mia kumerou ka toro kei? Mia kamiu monoka kumerou riano ka Atua ga, napano mia naio mijikia rila niabemiu rim̃aro beamu, karina mia mijikia rivu niunumiu bunu rivan ea vio nam̃a ajog rivova eaio. Lerinio, toro na naruei kamiu monoka kumerou ka naio. ");
INSERT INTO bki_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mia ver kumerou kanio, mia kamiu maka bunu kuvijikia kumerou ka todolu bereio, bior Atua jom̃a bitikar kamiu, naio jo jidomial kamiu. Kuvisidomii von menu sesa napano kirijako. Nalo miroano laka janea vio ga, ajibe ka soro ga, ap̃iliṽili kalo veru telisu ga ka kirijako jimo, mia Atua jom̃a tinien maio kalo abeve terakurano dam̃ariga, naio maka tinien ribobogialo. ");
INSERT INTO bki_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A vijumiu nalo na ea pariparimiu bunu, miroano laka, mia naio buluku nonovlo beve terakurano ga. Mia Atua naio jo mial kamiu kubo laka jovulu kirijako nalo nei, naruei mia naio rivitikar vatitig kamiu rivu ka vite nonovio na kenemiu meuliano.” ");
INSERT INTO bki_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ana na Yesu berenio, berinavo “Kei nam̃a berial kamu ka tomu nalo miralo ber naio be kanaku toro tai, mia kiniou Kulorinio Kenerinio, kiniou bunu neverial siano van nailiano nalo na mave ka toro nene be kanaku. ");
INSERT INTO bki_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mia toro kei nam̃a berial kamu ka tomu nalo miralo ber naio maka ve kiaku, mia kiniou Kulorinio Kenerinio kiniou bunu neverial van nailiano nalo na mave never toro na naio maka ve kanaku. ");
INSERT INTO bki_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Kariano nalo bija ilivovaiano nalo, bija iliano nalo nam̃a mila lelan kiniou Kulorinio Kenerinio, Atua mijikia riviekokoa toro riviorio, mia toro na ver mila lelan tolu na Niununo Lu, berii Niununo Lu kiano im̃auano, berinavo Sim̃aro ga mim̃aukanio, toro na jibe na, Atua maka rijikia riviekokoa bogo tai leleio. ");
INSERT INTO bki_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“A verenio bogo tai, tomu nalo tiniel ser kamiu, mia avan ea ilivatitigiano ka kamiu. Mia amijikia avuru kamiu kuvan kuvitumolu kuvitu kamu ea tomu na tortoru na yimo na volkouano nalo miralo, a ea komeli bunu, mia kamiu kuvisidomial m̃ele re ka mia kuverdop̃elo tum̃abe, p̃eli na mia kuver iliano na vabe vanlo. ");
INSERT INTO bki_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Rimonloglog aura nei ga, mia Niununo Lu ga rijai kamiu, ka riverloglog kamiu ka iliano na vabe na mia kamiu kumijikia kuverenio.” ");
INSERT INTO bki_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Naruei tiniobi nei napano aju nei nalo tai, naio bio ban Yesu, berinavo “Naverloglogiano, kuruaku naio jom̃a mijukubin kiniou-o mia, naio maka tom̃a tan ka batitig karamememi jajum̃ano rivija kiniou. Bo kanio mia jau kover kanio ka naio rila rive verare ga vija kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ana na Yesu berdop̃e, berinavo “Ai, abe vite na maka ve kanaku ka nalaiio. Kiniou maka nove toro nana mia netibure kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jibe na naruei ana na Yesu maka rila tibe ka na kema nei naio berkanio, mia naio jian iliano tai tivelinio ka sidom m̃elea vite nalo. Naio berinavo “Kamiu monoka kuvitikar rivu, maka rivu ka kuvitum̃a kuvijoku m̃ele ka kulo dolu nalo, kumisidom m̃ele ka kuvar vite nalo na be kialo. Kiado meuliano maka toa vite ve telabo nalo napano na roju rabario, mia kiado meuliano jikili jua vite dolu.” ");
INSERT INTO bki_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mia Yesu jusol kiano iliano ea vio na lie vo, naio ber jamerijiano tai banlo, naio berinavo “Toro sanibaiano tai kiano borotano toru laka, a bo laka, naruei kiano tiniavio nalo abar marimeuano toru ealo. ");
INSERT INTO bki_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mia tete nei naio mial sinaniano nalo nei, naio maka bunu rijikia mia rila tum̃abe naruei, ka mia rivar vatitig sano sinaniano nalo nei tua vio na vabe, bior kiano yimo na varvatitigiano na sinaniano bija kiano vio dolu nalo abujovujo nonovio ruei. ");
INSERT INTO bki_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ana na kema neibano, berinavo ‘!Mia noue bulag kanaku yimo na varvatitigiano na sinaniano moruo nalo nei, ana mo nomijikia noim̃au kanio na be terivou dolu nalo bereio, na mia nalo ave tortoru lie vo, na mia rivare ka sinaniano a vite dolu nalo na miroano nei kanaku. ");
INSERT INTO bki_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mia bogo na ver noim̃au kanio riviniu, mia kiniou naial kiniou tibe ka kiniou riano, kiniou nobo kija naruei! Riano ga, mia kiniou nojog rivu! Mia kiaku saba na miroano nei, mia nesenilo rivano-o mia avitikar vatitig kiniou rivano-o rivokar yuka ve miroano. Ka bogo na, mia noim̃au lele re bunu mia nesen vaio na nojidom, a mia nomunu uei tibe na ga, mia notoa meuliano nabo nam̃ariga na.’ ");
INSERT INTO bki_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Toro nei naio jom̃a jidom jibe na bano-o, mia naio maka rijikia ka Atua berii ruei ka mia ril vanio naruei, naio berinavo ‘E kodovo, komiavovu ga na, bogiano nei ga, kiniou nojidom nodular bereio kanamo meuliano denso. A vite nalo na miroano nam̃a komim̃au bijon kalo na, nam̃a jau komiobijilo be kanamo na, mia ave kei kiano bereio liki na?’ ” ");
INSERT INTO bki_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ana na Yesu ber kalo, berinavo “Mia tibe na naruei rivan tomu nalo nam̃a ajum̃a abarbijii kialo saba telabo, napano abe tomu na sanibaiano tivelinio na yetemeriba nei, mia maka leleio ave sanibaiano tivelinio na saba nalo na ea Atua.” ");
INSERT INTO bki_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ana na Yesu ber ka bunu kiano naiagagoano nalo, naio berinavo “Kar tena, kiniou naber ka kamiu, ka maka rivu ka kenemiu jidomiano rivujo m̃ele ka im̃auano na kuvitikar kamiu ga, ka na mia m̃a kuvivika, kuverinavo ‘?Mia vio na vabe na mia kito romijikia releal sinaniano?’ P̃eli na ‘?Mia rovokar kulum̃arauo na royaio tum̃abe?’ ");
INSERT INTO bki_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jidomiano nalo na maka rimemedu, bior kenemiu meuliano naio bo loa ka sinaniano, a niabemiu naio bo loa ka kulum̃arauo. ");
INSERT INTO bki_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kuvisidomii von menu maina nalo nam̃a ajum̃a amierier janea vio nalo na. Nalo na maka m̃a aim̃auka kialo tiniavio, a maka avavenei ka avarbijii sinaniano rimei vonuo, a maka avar batitig salo sinaniano nalo tua vio nene tai. Mia Atua jom̃a baganlo, a ea kiano vitiiano, naio mial kamiu kubo lie loa ka menu nalo, ana mia naio rivitikar kamiu rivu laka tovulu nalo. ");
INSERT INTO bki_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","?Kamiu kuberiam̃a toro napano jom̃a jidomii kiano meuliano toru laka naio mijikia rila kiano meuliano na bulati na rimei vetebievi kija bere ve telisu? ");
INSERT INTO bki_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Makanio, maka tibe na, mia bior kamiu maka kuvijikia kuvila titai na telisu jibe na, bo kanio kamiu kuvisidom bijovijon re vite dolu nalo na ea kenemiu meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Kuvisidomii von buruniegniegi novo nalo nam̃a ajum̃a amililuo janea vio na. Nalo na maka m̃a atu aim̃au a maka m̃a atulu m̃alo kuluniabele nalo. Mia kiniou naber ka kamiu, Parinio tubo Solomon re nua, napano naio be nasanibaiano laka, a naio be kiano saba nonovio, kulum̃arauo nalo nam̃a miyaio maka rivar niogniogu na bo tibe ka m̃aniegniegi nalo nei. ");
INSERT INTO bki_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","M̃aniegniegi nalo nam̃a abe tena bogoti takurano ga, mia beni ana aisebilo ea sebi, mia Atua jo miyovovualo batitigio abo laka. Jum̃abe, kuberiam̃a Atua maka rijikia rivar kulum̃arauo van kamiu? Kaleliki, kamiu na maka kuviekar naio sikili leleio a! ");
INSERT INTO bki_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bior vite nalo na, mia maka rivu ka kenemiu iviso rivujo ka jidomiano nalo na, kuverinavo ‘?Tum̃abe ana na mia rosinan, a romunu, a releal kulum̃arauo?’ Mia maka rivu ka kuvitum̃a kuvisidomii bijovijon m̃elea laka tibe na. ");
INSERT INTO bki_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ierinio, tomu nalo reraio na buruvenuo nonovio na yetemeriba neibano ajum̃a ajidomii m̃elea vite nalo jibe na bogo nonovio ga, mia kamiu, karamemiu naio mijikia ruei ka monoka kuvar vite nalo na jibe na. ");
INSERT INTO bki_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tena be moti ka mia kuvisidomii ve toru ea kenemiu iviso nalo, naio be Atua kiano navenatuboiano. Mia verenio kuvila tibe na, ana na mia naio rivar bunu vite dolu nalo nei rivan kamiu. ");
INSERT INTO bki_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ierinio kiaku nunu sesa nalo, karamemiu naio jidom toru ka rijamo ka kamiu kumei kuve tubo ka kiano tomu nalo, ana na mia kamiu kuvisidomial re titai leleio, mia vite nonovio rimei rivu ka kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ana na Yesu ber bunu ber “Bo kanio kamiu kuṽiliṽili bulag ka kenemiu saba nalo na, kuvar veru nene van talim̃asa nalo ka kuvijailo. Ver kuvitum̃a kuvila tibe na, jibe kanio kumitu kubar kenemiu burum̃ara basaro tai joa vio mave, napano mia maka rijikia rimei dagdago bogo tai, a kuvitum̃a kuvison bijii kenemiu saba nalo na miroano rivan eaio, ka mia kuvarkar tiniemiu eaio, ka mia toro na vinauano rijikia re ka rivar bulagio den kamiu bereio, p̃eli na mia sivinia ser dudulio re. ");
INSERT INTO bki_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mia bo kanio kamiu ve kenemiu saba novo nalo na atua vio mave tibe na, bior mia kenemiu jidomiano nalo atu tulaka ea vio na ga napano kenemiu saba na bo nalo ajuaio.” ");
INSERT INTO bki_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Ana na Yesu ber bunu kalo, berinavo “Kamiu monoka kuvitu derevijo tulaka ka mia kenemiu Tubo riyotuba ka kamiu. Kamiu monoka kuvitibe ka tomu nam̃a amim̃au toro na toru tai kanano, napano naio juvanlo ka ban ea soriano tai. Naruei nalo amiyovovualo, ajelan bunu yulu nalo, ajumormolu aju, mia bogo vaio napano mia kialo toro na toru naio rivoru, naio rimei rinia m̃aratavo, mia nalo aju rorea ruei, amijikia avetavo kanio vaarakurano ga. ");
INSERT INTO bki_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mia burum̃ara ilivuiano van tomu nalo nam̃a amim̃au jibe na, ka bogo napano kialo toro na toru boru keanlo, mia nalo aju rorea ruei, nalo ajevijo aju. Mia kialo toro na toru naio saaro ve toru kalo, ana na mia naio riva riija naio, karina mia rimei mia amiilo ka naio riviolo ka amei atutano ea kiano vio na sinaniano, naio biovio ka sinaniano novo tai banlo. ");
INSERT INTO bki_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mia bekurano ka ver vio bobogio ruei, p̃eli na ba bokar bogiano vio vare, p̃eli na vaataro ka tu riolu, mia ver toro na toru naio rimei, rial ka kiano tomu nalo ajevijo aju rorea naio jibe na, mia naio rila vatitiglo rivu-o mia. ");
INSERT INTO bki_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Mia bereio be verare ga ka ver toro tai napano mijikia memedu ka bogo na toro na vinauano mia rimei ea kunuano, mia toro nei maka rijikia tuvan kunuano to ga tibe na ka naio riva vio dolu, naio monoka to derevijo rorea naio to. ");
INSERT INTO bki_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tibe na, kamiu bunu monoka kuvitu rorea vatitig rivu ka mia kiniou Kulorinio Kenerinio nomaluvo, bior mia nomaluvo ka kamiu bereio ea bogo tai napano maka toro tai rijikiaio, p̃eli na tom̃a sidomii ka mia river nemei bereio eaio.” ");
INSERT INTO bki_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ana mo Pitere bika den Yesu, berinavo “?Tubo, jamerijiano na jau kober vonganei na, jau kober ban kumemi kanamo naiagagoano ga, p̃eli na kober ban tomu nalo nei ga abiniu?” ");
INSERT INTO bki_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mia Yesu maka sian verdop̃eiano nene rimemedu vanio, mia naio berdop̃e ban ea jamerijiano tai. Jamerijiano nene naio jibe nei, ber “Ver toro na im̃auano tai, napano naio be masou bo laka, a naio biekouo ea kiano im̃auano, mia naio rim̃au tum̃abe naruei? Ver kiano toro na toru juvan vio ka riva koalabo, mia naio tuvan kiano naim̃auano nalo atua naio jum̃ano. Mia kema nei naio rivitikar kiano tomu na im̃auano dolu nalo, mia naio rivokar vatitig im̃auano nalo nene. ");
INSERT INTO bki_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mia bogo na toro na toru naio rimei bereio, mia naio rileal ka kiano toro na im̃auano nei, naio jo bokar batitig im̃auano nalo nene kiano vo. Mia ka bogo na, mia toro na im̃auano nei naio rijog rivu ve toru laka, ");
INSERT INTO bki_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","bior mia toro na toru nei naio tuvan vite nonovio na kanano tua jum̃ano. Ierinio, mia Atua rila tibe na ga bunu. ");
INSERT INTO bki_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Mia ver toro na im̃auano nei naio rim̃au rivova, mia bogo na ver kiano toro na toru nei tuvan vio ka riva to koalabo, mia naio jidom riverinavo ‘E, toro na toru nei naio ba jo yako kirisiou laka ruei, p̃eli mia rimei re bunu naruei.’ Ana na mia naio tumolu rila kiki tomu na im̃auano dolu nalo, a rivijuku rivova ka tire nalo na im̃auano, a mia naio tom̃a sen veru na toro na toru nei kiano, a riva rimunu uei ea legiano nonovio. ");
INSERT INTO bki_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ana mia toro na toru nei naio rimei bereio ea legiano tai na mia toro na im̃auano nei naio riilo kanio garuei, ea bogoti tai na mia naio risidom re ka mia boru nei rimei eaio. Ana na mia toro na toru nei sian burum̃ara vironiano van toro nei napano mia rila naio riva toa vio na tomu na pariparilo kirisikili ajuaio. ");
INSERT INTO bki_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mia toro na im̃auano napano mijikia batitig venia napano kiano boru jidomio ka naio monoka rilaio, karina maka rilaio, mia monoka avitii vatitig naio. ");
INSERT INTO bki_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mia toro na im̃auano napano mila na bova memedu ga ka mia avitii vatitig naio riviorio, verver naio maka rijikiaio, mia avitiv naio ve toru re. “Toro na Atua mije ban naio ve toru, Atua jidom ka rial toro nene rim̃au ve toru rivijaio. Mia ver toro napano tomu nalo amije vite nalo miroano monea jum̃ano, mia amijikia avika vite ve miroano lie vo den naio bereio.” ");
INSERT INTO bki_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ana na Yesu berenio berinavo “Kiniou nebinimei ka noyon sebi rimemedu ea vio yetemeriba nei, mia bo ka ga ver sebi nene rivilvili ruei, ana makan vo. ");
INSERT INTO bki_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Burum̃ara im̃auano kouo tai monokoro jo kamu ka miraku kia navo, ka mia monoka nevija dulu eaio, mia vonganei notom̃a nop̃idig kar kiniou ruei riviorio. Bo ka tenene rimei sop̃eli, ka nomijikia nala nonovio. ");
INSERT INTO bki_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Kamiu kumisidom kuberiam̃a kiniou nebinimei ka nala burum̃ara tum̃aro toa yetemeriba nei? Makanio, maka nemei ka nodu tum̃aro toaio, mia nebinimei ka nala bajago na vuruvureiano rimei ve toru lie vo. ");
INSERT INTO bki_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mia tikar vonganei, p̃eli ea vonuo tai, tomu nalo jumo ajuaio, ana mia nalo tolu nene avuruburelo ka naljuo nene, p̃eli na juo nene avuruburelo ka nalo tolu nene. ");
INSERT INTO bki_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mia tomu nalo avuruburevurelo, ka na mia tete m̃eaku nalo atudie karam̃alo nalo, mia teta nalo atudie kialo tete m̃eaku nalo, mia nena nalo atudie kenerilo niatira vevinio nalo, a niatira vevinio nalo atudie kialo nena nalo, a mia niasimemi nalo atudie niatira na joro vonga ka kenerilo m̃eaku nalo, ana mia niatira nalo atudie kenielo niasimemi nalo.” ");
INSERT INTO bki_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ana mo Yesu mil ban tiniobi nalo bereio, naio berinavo “Bogo na kito rotum̃a roial burum̃ara melijo na bobogio joa vio nam̃a jegi moluo eaio, romijikia ka mia yuo rimei, mia maka vesiou ga ana na yuo bovo. ");
INSERT INTO bki_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mia bogo nam̃a romijog ka kanado jegi na saot jom̃a miuvuvu, nina naruei romijikia ka mia vio rivitunu m̃ele, ana na mia monoka tibe na ga na. ");
INSERT INTO bki_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","?Nina naruei, kamiu kumitum̃a kubitilubar ruei kijokijo na vio yauo a yetemeriba, ka mia bogo tum̃abe p̃eli mia tum̃abe, ana mia jum̃abe kamiu maka kuvijikia kuvitilubar kijokijo nalo na ea kanaku burum̃ara bogo na vonganei nei napano m̃a nojo bija kamiu? P̃eli kamiu maka kuvisidom kuvitilubar ga kovio? Tomnei, kamiu kubarvar laka ka kamiu, kuber vite nalo mia maka kuvilaii.” ");
INSERT INTO bki_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bo ka ver kamiu kuvilavon ka kuvijikia kuvitilubar kija ka m̃arabo na vabe naruei na naio memedu ka kamiu kuvitakiio. ");
INSERT INTO bki_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Verver bogo tai jau kala baravo kam juo toro tai ka titai, mia naio sidom rivurso kavan kotumolu kotu kamu ea toro na tibureiano mirano riviorio, mia bo ka jau kala vio sikili ka keil vatitig rivija naio, beamu ka bogo na kamiu maka kuvoru komeli vo. Ver makanio, p̃eli mia naio ruduso kotoa toro na toru nam̃a jijibure toro jum̃ano, ana na toro na toru nei p̃eli mia naio ruduso kotoa tomu nam̃a abokakar tomu nalo jum̃alo, ana mia nalo aduso kotoa yimo na tetavokoiano. ");
INSERT INTO bki_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ierinio, kiniou neberii kaso, ka ver tibe na, mia jau maka kejikia kataluvo bereio den yimo na tetavokoiano nene, rivanvano-o mia jau kovulu bulag nono kiamo mauo riviniu beamu vo, ana mia jau komijikia kataluvo bereio.” “Mia iliano nei naio be riano ban kenemiu meuliano na yetemeriba nei, a be riano bunu ea tivelinio na kamiu bija Atua.” ");
INSERT INTO bki_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mia tomu nalo na aju ea bogo na, ajukunu ka kulo Kalele tealo ban Yesu, napano toro na toru na Romo nei Pailat mila bajago na kirivova tai kalo. Nalo aberenio “Nalo na ajua Atua Kunuano Lu, mia monloglog bogo na aju amilotu ka Atua, amila sida banio, mia Pailat nalo abinimei amiel binvinlo am̃arm̃aro, mia amila kitkiti kialo burukija bija burukija na kialo sida neibano ajum̃a amilaio.” Naruei bogo na aber vite nei ka Yesu, ajidomii ruei ka vite na bova nei na maluvo kalo, p̃eli be Atua kiano vironiano tai banlo, bior kialo vovaiano tai napano p̃eli nalo amilaio. ");
INSERT INTO bki_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ana na Yesu berdop̃e banlo, berinavo “Kamiu kuvial kulo Kalele nalo na am̃arm̃aro kirivova jibe na jum̃abe na? P̃eli kuberiam̃a nalo abe tomu na bova laka, jovulu kulo Kalele dolu nalo, naruei naio be kialo vironiano ga? ");
INSERT INTO bki_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kiniou nojidom nover ka kamiu never makanio, naio maka tibe na. Mia monoka kuvitikar vatitig rivu, bior ver kuvilig re kamiu, mia kumijikia kum̃aro bunu ea bajago na jibe na. ");
INSERT INTO bki_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Mia kamiu kuvisidomii von yimo na siraragkuiano napano joa komeli na Sailomo. Naio bavin loa laka, mia bogo nanua naio mijoru, na jibirbil ea tomu nalo mia nalo duelimo ba arolu 18 am̃arm̃aro. ?Mia jum̃abe ka nalo na? ?P̃eli kumitum̃a kuber nalo na bunu abova loa ka kulo dolu nalo na vio Yerusalemo, mia nina naio jibe ka kialo vironiano tai, a? ");
INSERT INTO bki_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mia makanio, naio bunu maka tibe na. Mia kiniou neber bereio ka kamiu, neber monoka kuvitikar kamiu rivu, bior ver kuvilig re kamiu, mia kumijikia kum̃arm̃aro bunu ea bajago na tai jibe na.” ");
INSERT INTO bki_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ana na Yesu ber jamerijiano tai bereio, napano naio ber jibe nei, berinavo “Toro tai, kiano burubilivo tai jua kiano tiniavio. Mia bogo tai ana toro nei naio binimei ea burubilivo nene, jidom ka rial von naio jakou p̃eli na maka takou. Naruei naio binimei mial ka buruiesi nene maka takou leleio. ");
INSERT INTO bki_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mia naio mil ban toro nam̃a bitikar kiano tiniavio, berinavo ‘Vonganei bokar yuka tolu ruei, napano nobinimei najirarago ka burubilivo nei m̃arati, mia maka lele tai. Niabeku mave ka ruei, naio jukoko vio na bo nei kurano ga, mia jau ketelario ga rivano.’ ");
INSERT INTO bki_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ana na toro na im̃auano neibano naio tinien miia burubilivo nei toru, ana ber ka kiano toro na toru nei, berinavo ‘Ver tum̃abe, mia kito ralavon ka rotuvan tu ka yuka ve takurano bereio von. Ka mia kiniou nalavon ka noim̃au ka vatitigio von beamu vo, mia nekil p̃ili selvivia burupati, ka mia novisivisi tera buluku ea ka mia rila riluo rivu. ");
INSERT INTO bki_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Naruei ver riluo rivu, rivar kija m̃arati ka yuka yako, mia mijikia tu bo tibe na bo kanio, ver makanio, mia jau komijikia ketelario rivano.’ ” Jamerijiano nene ber be bogo telisu kiano jo ka tomu nalo amijikia aviliglo, verver makanio mia Atua rijev vironiano vanlo. ");
INSERT INTO bki_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana ea Legiano Lu tai, mia Yesu naio jom̃a berloglog tomu nalo joomo ea kialo yimo na volkouano. ");
INSERT INTO bki_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ana ea vio na be tiramoruo tai naio jo, napano niununo na bova tai na mieiano joa naio. Ana niununo napano miadikar naio ka yuka duelimo ba arolu 18 ruei, napano mila na tiramoruo nei taakano jup̃e laka, naio maka rijikia rivitiri naio memedu leleio. ");
INSERT INTO bki_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mia bogo na Yesu jirarag loglogio, bio naio binimei, ana mil banio, ber jibe nei berinavo “Tiramoruo, kiniou neber jibe nei, neber jau, mieiano nam̃a bivikakarso na, mia ritaluvo denso vonganei ga.” ");
INSERT INTO bki_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ana bija iliano nei Yesu midu jum̃ano joaio, mia vaarakurano ga taakano binimei memedu bo bereio, naruei tiramoruo nei mijog bo toru laka, miaia Atua Sop̃i-o mia. ");
INSERT INTO bki_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mia navurim̃araboiano na yimo na volkouano nei, naio tinien jer Yesu ka napano naio mieliel ka tiramoruo nei ea Legiano Lu. Naruei naio mil ban tomu nalo, berinavo “Jibe ka na kito romijikia ruei, romijikia ka roim̃auka bogoti ve ari, mia bogoti takurano, maka roim̃au. Ver kamiu kuvisidom ka aieliel ka kamiu, mia bo kanio kumei ka bogoti ve ari ga, mia Legiano Lu na jibe nei naio maka rive bogo nene rimemedu.” ");
INSERT INTO bki_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ana na Tubo berdop̃eio berinavo “?Jum̃abe? P̃eli kamiu kumitum̃a kumijian kenemiu bue m̃arauo nalo ka Legiano Lu, p̃eli maka kumijianlo? P̃eli na kamiu kumitum̃a kubagan kenemiu temeul nalo a kumitum̃a kumiyon uei banlo ka Legiano Lu, p̃eli na maka kuvila tibe na? ?Mia bior vaio ana maka kuvisaaro ka namila batitig tonovo tai ea tiramoruo nei? !Kamiu kubarvar laka, kuber vite nalo mia maka kuvila! ");
INSERT INTO bki_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tiramoruo nei, naio be kuviviniedo tai napano kito robiniu romiyotuba ea yati na tormoruo Epraamo, mia Najuboliboiano miorikar naio ka mieiano nei mijil yuka duelimo ba arolu 18 ruei. Ana kiniou namial jibe ka Legiano Lu naio memedu ga ka kito rovurular naio den vio na bova nei napano joaio.” ");
INSERT INTO bki_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mia bogo na Yesu ber iliano nei, mila kiano uolu nalo nei amijog amimou toru laka ea tomu nalo miralo. Mia kulo dolu nalo, nalo ajaaro toru laka ka im̃auano na bo nalo na miroano napano Yesu milaio banlo. ");
INSERT INTO bki_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mia Yesu mil bereio, naio berinavo “?Kiniou never iliano venia rivan kamiu ka mia rila na kamiu kuvijikia ka Atua kanano navenatuboiano naio jum̃abe? ?Mia kiniou never navenatuboiano nene naio javukia vite venia? ");
INSERT INTO bki_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mia nalavon ka nala rimeravo rivan kamiu ka jamerijiano nei, napano naio ber jibe nei, berinavo, Navenatuboiano nene, naio jibe ka kurukubako napano mijoru ba birakar joa buruiesi tai. M̃arati nei kiritavaso leleio, mia bogo na miluo, binimei be buruiesi tai na burutomoruo laka, naruei menu nalo abinimei amila m̃alo niuku nalo jua jaati nene nalo.” ");
INSERT INTO bki_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ana Yesu ber jamerijiano dolu tai bereio banlo, naio berinavo “?P̃eli mia kiniou neverinavo Atua kiano navenatuboiano naio javukia vite venia bereio? ");
INSERT INTO bki_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Navenatuboiano nei, naio javukia tira tai nam̃a jo milalaglag isi na teliki ga bija burum̃ara baju na yevi tai, naruei isi na teliki nei naio mila joko nonovio miyuku toru.” ");
INSERT INTO bki_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ana Yesu naio jo midu kiano m̃arabo bereio, naio jo jidom ka rivavin bere Yerusalemo. Mia bogo na jo ban jibe na, jo miel jel ea komeli nalo, jom̃a berloglog tomu nalo. ");
INSERT INTO bki_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Naruei ea komeli tai, be toro tai bika denio, naio berinavo “?Tubo, nalo na mia avokar meuliano, nalo telabo, p̃eli na maka ve telabo laka?” ");
INSERT INTO bki_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Naruei Yesu berdop̃elo, berinavo “Kamiu monoka kuvilavio sikili ka mia kuva joomo ea bulutavo dolu na, napano na teliki ga. Kiniou neber riano ka kamiu, ka mia tomu ve telabo asidom ava joomo, mia maka ajikia alaio. ");
INSERT INTO bki_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nina bior iorou, ana mia toro na toru na yimo mia naio rial ka bare ruei, mia naio tumolu, tetavoko vatitigio bereio. Ka bogo na, mia kamiu ve telabo kumei kuvidu buron kamiu ea m̃aratavo nei, mia kuviniu kuvio kuverinavo ‘Tubo, kumemi nuber bo ka jau kovetavo ka kumemi.’ Mia toro na toru nei naio riverdop̃e ga tibe nei, naio riverinavo ‘Ai, abe kiniou maka najikia kamiu leleio! Kamiu kube kulo be nalo?’ ");
INSERT INTO bki_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ana na mia kamiu kuvilavon ka kuver kanio ka bogo na, kuverinavo ‘Ana jum̃abe, jau maka bunu kosidomial ka kito naruei rojum̃a rajinan vio takurano dam̃ariga beamu mugaruei m̃a na? !Kumemi nene nei naruei nam̃a jau kobinimei m̃a koberloglog kumemi janea vio medave nalo ea kenememi komeli nalo!’ ");
INSERT INTO bki_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mia naio river kalo, riverinavo ‘Kiniou neber ka kamiu vaarakurano nua ruei, ka maka lele nejikia kamiu, kamiu kube kulo be. Mia namijikia ga ka napano kamiu kube tomu nam̃a amim̃auka bajago na kirivova ga. !Kamiu, kuvitaluvo den kiniou vonganei!’ ");
INSERT INTO bki_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ka bogo na, mia kuvijog rivova ve toru, mia ve burum̃ara tegiano, kuviser m̃arjuvomiu. Nina bior ka mia kamiu kuvial ka napano Atua kiano tomu novo nalo, jibe ka Epraamo, Aisak, Yakovo, a naverialiano dolu nalo bunu, nalo aju bo jouro ea kiano navenatuboiano ruei, mia kamiu, avuku kamiu kuvitu bo ga tavio tibe na. ");
INSERT INTO bki_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ea bogo na, mia kulo dolu vetelabo ayotuba ea sudu veri na yetemeriba nei, amei ka atutano ka asinan ea burum̃ara jokoluolu na jouro ea Atua kiano navenatuboiano, mia kamiu maka kuvijikia kuva jouro eaio. ");
INSERT INTO bki_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mia tibe na naruei, ka nalo nam̃a aju iorou, mia atu tukamu, a nalo nam̃a aju jukamu, mia atu iorou.” ");
INSERT INTO bki_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka bogo na, ana Yesu jo bavin Yerusalemo kia vo, mia Varisis nalo tai abinimei eaio, aberial kanio, aberinavo “P̃eli jau maka kejikia, ana Parinio Tubo Erot na, naio berkar ruei ka mia ruebinso. Bo ka jau kataluvo den tanobuku na naio jom̃a be tubo eaio, jau kovuro kava Yutea beamu vo.” ");
INSERT INTO bki_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ana na Yesu berdop̃elo berinavo “Kiniou maka nosidomial souo kurkuru na ka naio be toro tai na mijikia rila titai ka kiniou. Kuva kuverial ea mirano kuver kiniou noto nala kiaku im̃auano beamu vo. Kuver kanio kuver kiniou nojom̃a nemijil bulag sim̃aro nalo, a nojom̃a nemieliel ka tomu nalo, a mia notom̃a noim̃au tibe na banei, beni, veua bereio, rivano-o mia neial ka namila nonovio ruei. ");
INSERT INTO bki_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mia kiniou namijikia na ver ka kamiu, ka mia kamiu kuvisidomii m̃elea re kiniou, bior ka legiano nalo nei, kiniou nojo najaluvo den tanobuku nei navan tibe na naruei. Monoka najaka nava novoru Yerusalemo vo, bior namial jibe ka vio na naruei nam̃a tomu nalo ajum̃a amuebinvin naverialiano nalo eaio, jikar nua ruei.” ");
INSERT INTO bki_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ana na ka bogo na, Yesu tinien miia Yerusalemo m̃a jegidu kanio, naio berinavo “!Yerusalemo, Yerusalemo-o! Bior vaio ana kojom̃a komuebinvin naverialiano nalo, a kojom̃a kojuba binvin tomu nalo nam̃a Atua jom̃a miilalo abinimei easo? Vatelabo kiniou nejidom nodu jum̃aku selvivko kiamo tomu nalo tibe ka sabarou bio kirikiti nalo abinimei amiyuku jel tano ka sibiano, mia kanamo tomu nalo maka asaaro kanio. ");
INSERT INTO bki_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mia komialio na, Atua naio jo bilig taakano kaso ruei nei, ana naio miila kiniou nebinimei be moti nei naruei, ana naber kaso, neber mia kanamo tomu nalo ajikia re aial kiniou bereio, rivano-o rivokar bogo na avitilubar kiniou, averii kiniou averinavo ‘!Atua sop̃i loa laka, jau keilivu ka naio napano naio jo binimei ea siamo!’ ” ");
INSERT INTO bki_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana ka Legiano Lu tai, navurim̃araboiano na Varisis tia bio Yesu ba jinano ea kunuano. Mia tomu dolu nalo tealo nam̃a maka tiniel tii Yesu, nalo aju bunu ka bogo nei, ajum̃a abitivitii julaka ver naio rila vite tai na maka rimemedu, mia amijikia ala tibekovio ka naio. ");
INSERT INTO bki_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mia toro na mieiano tai jo naliko joomo ka bogo nei, napano toro nene niabene nalo jurojurobi tortoru laka. Mia Yesu mial toro nene, ");
INSERT INTO bki_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","naruei mil ban naverloglogiano na tuboiano nalo, bija Varisis nalo napano aju, naio bika denlo, berinavo “?Jum̃abe ka tivelinio na kiado tuboiano? ?Naio berenio kito romijikia reieliel ka toro ea Legiano Lu, p̃eli na ber maka rejikia reieliel kanio?” ");
INSERT INTO bki_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mo bogo na Yesu bika vikadeniano nei, amial jibe maka bunu ajikia asian verdop̃eiano rivanio, mia maka bunu ail. Ana na Yesu buru toro nei binimei vaataro keanio, ana mieliel vatitig ka naio bo bereio, berinavo mijikia rivan bereio vonuo. ");
INSERT INTO bki_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ana naio mil ban nalo na aju, naio berinavo “Kamiu kuvilavon ka kuvisidomii vonio. Ver kamiu tai, ka Legiano Lu, kenerinio tai, p̃eli na kanano temeul tai, naio riva rijoru rivatove ea bulukuei tai, ana mia jau kala tum̃abe? ?Mia jau monoka kala sop̃eli ga kava kovurular bereio, p̃eli na mia koverinavo ‘Uerei bova naruei, vonganei be Legiano Lu ruei, tuboiano berenio mia kiniou noim̃au re ea Legiano Lu, mia p̃eli keneriku p̃eli na kanaku temeul na tobo beamu vo ea p̃ili na, mia beni ga ana mia nava novuru lario?’ P̃eli mia maka bunu kejikia koto rorea titai bereio, mia jau kala sop̃eli ga na.” ");
INSERT INTO bki_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mia nalo maka bunu ajikia ka mia aver verdop̃eiano venia ka tivelinio na rivan naio bereio, aju buru ga jibe na. ");
INSERT INTO bki_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mia bogo na aju ka atutano ea sinaniano, Yesu bitilubar ka nalo tealo napano boru na jokoluolu biolo abinimei, tiniel jii toru ka ajidom aleal vio na bo, nalo aba ajutano mave ea tomu na tortoru jelelo. Ana Yesu mial kialo bajago na m̃arouano nei, ana ber kalo, berinavo ");
INSERT INTO bki_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ver bogo tai avioso ka kavan ea sinaniano na soriano tai, p̃eli na jokoluolu tai na jibe na, maka rivu ka koyokovo sop̃eli ka kava kototano ea tomu na tortoru jelelo garuei. P̃eli jau maka kejikia ka vio na, amila batitigio bo jororea toro na toru tai, ");
INSERT INTO bki_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ana mia boru na jokoluolu nei mia rimei river ka jau, riverinavo ‘Aiou kuruaku liki, mia p̃eli jau kavatove beamu vo, bior jau kojom̃a kojotano ea kanaku toro na toru jeleigio na.’ Naruei mia jau kavar burum̃ara imouiano tai na rila kojog ve kirivova laka, mia monoka jau kavatove ga bereio, kalavon ka keleal kiri vio sesa tai ka na mia komijikia ketivan miramo eaio. ");
INSERT INTO bki_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mia bajago na bo naio jibe nei: Ver avioso ka kavan ea sinaniano tai, bogo na kovoru eaio, jau kava kototano rivija tomu ninio ga. Mia ver boru na jokoluolu nene naio rimei, mia naio rialso, mia naio riverinavo ‘Oi, burum̃ara toro, kiniou nemije batitig jelemo na jo mave ruei, mia kito ve juo ravan ana neti vatitigso.’ Ana ka bogo na, mia komijikia kojog rivu ve toru laka, ka boru na jokoluolu rivitiri larso tibe na ea kulo dolu nalo miralo nam̃a kumisinan vio takurano. ");
INSERT INTO bki_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tibe na naruei, ka mia toro nam̃a miyuku lelar naio, mia adu naio totano, mia toro nam̃a midu naio jotano mia ayukular naio to mave.” ");
INSERT INTO bki_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ana ka bogo na, Yesu ber iliano tai bunu ban toro napano bio naio binimei jinano ea kiano vonuo, naio berkanio, berinavo “Vonganei, kito romial ka napano tomu nalo, bogo na amila sinaniano tai, tiniel jii ga ka avio kialo bilbilu na bo, p̃eli kurualo nalo, p̃eli na kialo m̃aratavo dolu nalo, vija bunu tomu na tortoru nalo na abe sanibaiano nam̃a aju vaataro ga kalo. Ajum̃a amilala jibe na naruei, bior amijikia ka iorou, ver nalo nei bunu ala sinaniano tai bogo tai, mia monoka ala meran rivanlo bereio. ");
INSERT INTO bki_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Mia bajago na bo ka rila bogo na jokoluolu naio maka tibe na. Bo laka ka kovio kulo dolu nalo, jibe ka nalo nam̃a abe talim̃asa, p̃eli na nalo na niabelo maka rivu, p̃eli na jaba nalo, p̃eli na merebono nalo, p̃eli na tomu nalo na ajiberbena, amei asinan rivijaso. ");
INSERT INTO bki_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tomu nalo na jibe na maka ajikia ala meran rivanso bogo tai, mia bogo na Atua mial ka jau tiniem jaaro ka koburulo abinimei ajinan kamliko ea kanamo vonuo, mia naio saaro laka kaniso. Karina naio rilivu kaso, a mia jau kavar vonga kiamo ijaiano na bo biorio, ea bogo na naio rila kanano tomu na memedu ameul bereio den nam̃ariano.” ");
INSERT INTO bki_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ana na toro tai napano joa sinaniano nei, naio mijog ka napano Yesu berii ka mia Atua rivitiri bulag kiano tomu na memedu ea legiano na maaro, naruei naio berinavo “!Ierinio, mia rivu lie rivan kito ka bogo na, ka napano mia kito raiasol burum̃ara jokoluolu na jouro ea Atua kanano navenatuboiano nene!” ");
INSERT INTO bki_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Toro na, p̃eli naio jom̃a ber naio bo kovio ruei, mia tomu na jibe na maka asidom ava jouro, naruei Yesu ber jamerijiano tai ea tivelinio na, napano jibe nei “Toro na toru tai, naio jidom ka rila sinaniano tai, mia naio bio tomu nalo telabo ka amei. ");
INSERT INTO bki_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ana bogo na naio miomon vite nonovio bisi ju, ana miila kiano toro tai ka riva rivuru nalo nam̃a abiolo ruei ka amei. ");
INSERT INTO bki_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mia bogo na kiano toro nene bano-o miyotuba kalo, nalo abiniu abare ga, ajum̃a amila ilisop̃eiano ga. Tai ber jibe nei, berinavo ‘Ierinio, mia kiniou nobulu von ga kiaku niatano tai, naruei nojo napano ka neial von ka borotano nene jum̃abe. Mia kover ka toro na toru kover aua toru vanio, mia maka nejikia neviedu vonganei.’ ");
INSERT INTO bki_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mia dolu, naio ber jibe nei, berinavo ‘Ierinio, mia kiniou nobulu von ga kanaku buluku nalo tai, ka avuru kanaku rukuruku nalo, naruei nojidom ka nava neial ka be p̃irilo jikili jum̃abe. Mia kover ka toro na toru kover aua toru laka, mia maka nejikia neviedu vonganei.’ ");
INSERT INTO bki_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mia dolu bunu, naio berinavo ‘Ierinio, mia kiniou namila jokoluolu na kanaku soriano maka vesiou vo, naruei namial jibe ka p̃eli mia maka nejikia neviedu, bior saba telabo laka.’ ");
INSERT INTO bki_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ana na toro nei binimei berial iliano nalo nei ka kiano toro na toru, mia bogo na naio mijogio mila naio mila siniabu kalo. Naruei miila kiano toro nei bereio, naio berinavo ‘Mo, jau kala sop̃eli kavan ea m̃arabo nalo na tertelisu vaataro na, kava keleal talim̃asa nalo, vija nalo napano abe mervitovi, vija merebono nalo, ana kuvurulo amei ea kiado jokoluolu.’ ");
INSERT INTO bki_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naruei naio ba milaio, mia iorou kanio ana naio binimei bereio ea kiano toro na toru nei, ana naio berinavo ‘Tubo, vite napano jau koberenio, kiniou nemilaiio ruei, mia tomu telabo abinimei ruei mia be vio toru jo kiano vo.’ ");
INSERT INTO bki_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ana miila naio bereio, berinavo ‘Tibe na, jau kavan bereio, kava lie kija ea vio nalo na komeli, mia katadua sikili toro kei na ver jau keialio, ka monoka amei, ka aison kanaku burusio, ka rila jokoluolu nei rive kirinovo tanea. ");
INSERT INTO bki_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nalo dolu nam̃a amila ilisop̃eiano na kirivova na, kiniou nobiolo batitig ka amei ea jokoluolu nei ruei, mia vonganei, mia maka nalo tai kalo napano mia rijikia sen kiri sinaniano nei tai leleio ea jokoluolu nei. !Kiniou neber vatitigio kiana!’ ” ");
INSERT INTO bki_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Naruei Yesu naio jo midu kiano m̃arabo ka rivavin Yerusalemo bereio vo, mia tiniobi niukniuku vio bujo kalo ajum̃a ajakisorio. Amiel bano-o, mia naio barp̃ilig kalo, ber kalo, berinavo ");
INSERT INTO bki_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Toro na jidom rimei rue jaaku, mia naio monoka rudu kiniou noto tukamu ea kiano meuliano, kiniou loa laka lie vo ka karam̃ano, kenieno, koano, kenerinio, kuruano, p̃eli na kuviviniene. Toro napano ver maka riilkue ka kiano meuliano, naio maka rivare ka rimei rive kanaku naiagagoano tai. ");
INSERT INTO bki_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mia toro nam̃a jidom ka rimei rive kiaku naiagagoano, naio monoka rila tibe nei. Naio monoka rudu kiano m̃akolkolo, rue jaaku nam̃ariga, tibe ka mijamo ka naio ka rijog jaleleano rivior kiniou. ");
INSERT INTO bki_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bo ka kuvisidomii vatitig rivu vite nei beamu vo, beamu ka na mia kuvil sop̃eli, kuver mia kuvitakisor kiniou. “Naio jibe ka na toro tai, ver naio sidom ka rim̃auka burum̃ara yimo tai, naio monoka totano, rivitii beamu vo, mia rivuluku vatitig beamu kiano veru na vuliano na im̃auano nei, mia monoka rivitii veve rivu ka naio bare ka mia rila nonovio burum̃ara im̃auano nei, p̃eli na maka rivare. ");
INSERT INTO bki_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ver p̃eli na, mia naio tikar rim̃auka batitig bulapati, rivavavin kija ga, ana mia naio riilo ka napano jum̃ano bulati garuei, ana na mia im̃auano nei tei riuedom tobo. Naruei bogo na kulo dolu nalo amei aial yimo neibano jo bija bayimo nene be togio ga jo, a maka ve vodobi nene, mia avital niegeniege m̃elea toro nene-o mia averinavo ");
INSERT INTO bki_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘O, kema na, kiano jidomiano kirinovo laka. Naio jidom rim̃auka kunuano, mia maka rila batitig tiiano na im̃auano, mila na maka rijikia rila nonovio riviniu.’ ");
INSERT INTO bki_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Jibe ga na, toro na jidom riverkar ka mia rimei rila im̃auano vija kiniou, naio monoka rila tavukia parinio tubo tai, napano toro na toru dolu jumolu ka naio, buru kiano burum̃ara taara na mira abinimei ka ala mira kanio. Tomu na mira na parinio tubo nei kanano nalo maka ve telabo tavukia toro na toru nei kanano, mia parinio tubo nei monoka rivitii vatitigio ga beamu vo, monoka sidomii vatitigio rivu ka naio mijikia tovulu burum̃ara taara neibano naio jo binimei ka naio kiana, p̃eli na maka rijikia tovulio. ");
INSERT INTO bki_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ver naio rial ka maka rijikia rilaio, naio monoka riila toro rieliko m̃arabo ka toro na toru nei, ka bogo napano naio jo koalabo kia ga vo. Naio monoka rivika denio, ka mia rivulu venia na ver toro na toru nei riverenio, ka mia ave juo atua tum̃aro bereio. Tibe na ana naio monoka rivatove ka toro na toru nei, rijamo ka naio nonovio rivanio. ");
INSERT INTO bki_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mo kamiu nam̃a kumisidom ka kumei kuvitakisor kiniou, kamiu monoka kuvitilubar ka kamiu bunu monoka kuvila tibe na ka kiniou. Toro na maka rijamo ka kiano meuliano kar kiniou, vija rera garuei kiano saba nalo, naio maka rijikia rimei rive kiaku naiagagoano tai.” ");
INSERT INTO bki_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ana Yesu ber jamerijiano dolu banlo, naio berinavo “Vaatei naio be tonovo tai, mia ver bogo tai ana vaatei nene naio rijea re bunu rivu, naio maka bunu rijikia rila kiano im̃auano, p̃eli na maka bunu ve titai rijikia rila rijea rivu bereio. ");
INSERT INTO bki_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mo vaatei naio jibe na, naio maka rijikia rila im̃auano na bo easo ea kanamo vonuo, p̃eli na ea kanamo tiniavio bunu. Vite na bo kanio, bo ka avuku rivan ea vio na soro ga. Nina naruei be tovorovo na kanaku naiagagoano napano milaluvu kanano moroano ka rila kanaku im̃auano. “Ana toro na be tiliniene bo, bo ka naio rijoglubar kanaku iliano nei.” ");
INSERT INTO bki_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana ea bogo nalo na jibe na, amial ka napano tomu tealo napano tomu dolu nalo maka tiniel tiilo, jibe ka tomu na takis nalo, bija kulo dolu nalo napano Varisis aber abova, nalo bunu abinimei vaataro ka Yesu ka aiagago ka naio. ");
INSERT INTO bki_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Naruei bogo na Varisis naliko naverloglogiano na tuboiano nalo aju amial ka Yesu jom̃a tinien jii ka tukunu vijalo, amial kirivova, ana aju aberinavo “Riano ga, tete na naio jidom ga tomu na kariano na jibe na, a bogo nonovio naio jidom ka riva sinano vio takurano naliko bunu. ?P̃eli naio mial ka kialo bajago ga naio bo, a kiado naio bova, a?” ");
INSERT INTO bki_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mia kialo jidomiano jibe na mila ana Yesu jukunu banlo ka jamerijiano nalo nam̃a aberii jum̃abe ka napano naio binimei ea yetemeriba nei kar toro napano milaluvu m̃arabo. ");
INSERT INTO bki_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Yesu kiano jamerijiano na be moti ka tivelinio na naio jibe nei, napano naio ber kalo, berinavo “Toro tai, naio be toro nam̃a bagan nunu nalo, mia kiano nunu nalo abokar toromomou takurano 100. Kiano nunu nalo telabo mugaruei jibe na, mia ver bogo tai, nalo tai riva kovio, mia naio sidomveia ga, p̃eli mia naio sidom bijovijon kanio? Mia monoka naio tuvan kiano nunu dolu nalo na atu bo beamu vo, mia naio rivakar napano ba kovio, mia naio sirag rilealio. ");
INSERT INTO bki_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mia bogo napano naio milealio, mia saaro ve toru laka, mia naio rudular nunu tavaliki nene rimon mave ea burusovonano, ana naio rudu rimei bereio. ");
INSERT INTO bki_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ana na iorou, ka bogo napano naio batove binimei ea kiano vonuo bereio, mia rivio nalo na ea kiano m̃aratavo, p̃eli na kiano bilbilu dolu nalo bunu, ka amei. Ana mia naio tukunu vanlo, riverinavo ‘Ei, vite tai napano kito ramijikia rasaaro ve toru m̃ele riviorio. Kanaku nunu tai napano ba kovio napano ba kovio laka garuei, mia karina naban kanio, najiragio-o, namilealio. !Bogo napano namilealio, najaaro mia maka garuei!’ ” ");
INSERT INTO bki_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ana Yesu mila meravo ban Varisis nalo, berinavo “Mia tibe na ga bunu ea vio mave. Tomu telabo napano ajua vio yetemeriba nalo ajavukia kamiu, be tinielo ka aber nalo amemedu ruei, ana p̃eli mia saariano na mave rivior kamiu tomu kinkin na jibe na kovio? Mia ver toro na kariano tai ga, naio rivilig kiano meuliano, mia ve burum̃ara saariano ea vio mave, riva lie vo ka mia ve burutomoruo laka. Vite na naruei mila ana tinieku jaaro ka notukunu vija tomu nalo nam̃a kamiu maka tiniemiu tiilo.” ");
INSERT INTO bki_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ana Yesu ber jamerijiano ta bunu ea tivelinio na, naio berinavo “Be tira tai, kiano kurukuveru duelimo, napano naio miduvan batitigio bo jo joomo ea kunuano. Ana ver bogo tai, rimei ber riadu kalo mia rial ve takurano naio mijoru ruei, ba kovio tai, mia naio rila tum̃abe naruei? Monoka naio rigoru yulu, rija bulag kiano saba nalo, a riakon vatitig vio ea kunuano, rivano-o mia rilealio. ");
INSERT INTO bki_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ana bogo napano rilealio, mia naio rivio nalo na ea kiano m̃aratavo, p̃eli na kiano bilbilu dolu nalo, ka amei. Ana naio tukunu kanio vanlo, riverinavo ‘Ai, abe vite tanie napano romijikia rojog rivu ve toru kanio. Kanaku burum̃ara kurukuveru tai nemilaluvuio mijoru banbo kovio tai, mia karina, nejiragio bano-o ana nemilealio bereio. !Bogo napano nemilealio, kiniou nomijog bo-o mia!’ ” ");
INSERT INTO bki_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ana na Yesu mila meravo ka Varisis nalo, naio berinavo “Naruei mia tibe na ga bunu ea vio mave. Ka bogo napano ver toro na kariano ga tai naio rivilig kiano meuliano, mia Atua kiano nailiano nalo aialio mia saariano ve toru laka ea vio mave.” ");
INSERT INTO bki_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mia Yesu kiano jamerijiano na maariano na tivelinio nei, naio jibe nei, napano berenio berinavo “Kulovu tai, be kenerinio sum̃ano juo, nam̃a aju amim̃au bijaio ea kialo borotano. ");
INSERT INTO bki_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ana ka bogo tai, maratoru na naljuo nei naio jumolu, berial ka karam̃alo abe juo, berinavo ‘Teta, kiniou nejidom navar saba togio na jajum̃amo ve kanaku ga.’ “Mia vite na maka rimemedu leleio ka naio rivika tibe na, bior karam̃alo naio meul jo kia vo. Mia karam̃ano maka ril, naio jan ka nonovio kiano saba nalo, mijamo ka togio ban m̃eaku nei, a togio be motoru kanano. ");
INSERT INTO bki_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Avona bisi, ana na m̃eaku nei naio jom̃a p̃ilṽili ka saba nalo napano karam̃ano bar banio, mia iorou, maka vesiou, amialio ka naio mison nonovio kiano saba nalo, bar kiano puruveru beven ka bano. Mia ba joa buruvenuo dolu tai koalabo laka, ana ea vio na, naio ba mijamo ka momon naio ban bajago na bova, jinan ka puruveru nei bano-o mia mila lelan nonovio biniu. ");
INSERT INTO bki_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Vonganei naio bitilubar ka jum̃ano bulati naruei, ana ea bogo na, burum̃ara vituiano tai binimei bokar buruvenuo neibano naio joaio, naio midu m̃eaku nei naio joa vio tai na kirisikili laka kanio. ");
INSERT INTO bki_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ana na naio ba jirag im̃auano tai ka mia rim̃aukanio ka mia p̃eli mijikia rilarur kiano meuliano, naruei ba mim̃au ea toro na toru tai na vio nene, ba bagan kiano kiribue nalo. M̃eaku nei naio maka rimemedu ka rila im̃auano nei, bior naio bel ka kiribue jibe ka kito kulo Ju dolu nalo, mia nina be im̃auano takurano ga napano naio mijikia rilealio. ");
INSERT INTO bki_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","“Naruei naio mim̃au jibe na bano-o, mia maka avar sinaniano vanio, a maka m̃arabo tai ka rileal sano sinaniano eaio, mila jijer naio nam̃ariga. Naio jijer jibe na bano-o mila naio jidom sian jum̃ano rivan ea basaro na sinaniano torogio na menunu bija botuotu na kon nam̃a kiano toro na toru naio jom̃a bagan ka kiano kiribue nalo ajenio. ");
INSERT INTO bki_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mia bogo napano jidom ka rila tibe na, naio bitilubar naio bereio, naio mial ka kiano bijuku m̃eteano ga mila lelan naio bereio. Mo naio tinien maio bereio ka karam̃ano bija kiano vonuo, naio berinavo ‘Riano ga, kiniou nomiavovu toru laka. Kiaku bijuku m̃eteano ga mila kiniou nam̃aro ka vituiano ea vio nei, mia kosidomii von nalo nam̃a atibe ka tomu na im̃auano ga na teta kanano. Naio jom̃a jian sinaniano novo nalo telabo banlo ka legiano nonovio ga, maka ajikia asen nonovio. ");
INSERT INTO bki_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ver tibe na, bo laka ka kiniou nalavon ka navan bereio ga, noim̃au kija ga tavukialo. Mia kiniou nava naial teta, never kanio, neverinavo “Aiou teta, kiniou namila burum̃ara kariano va tai ban Atua, a banso bunu. ");
INSERT INTO bki_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Vonganei, maka bunu rimemedu ka jau keial kiniou tibe ka nebe kenerimo tai, mia nobika denso ka tiniem riia kiniou ka noim̃au kija ga tavukia nalo nam̃a amim̃au kanamo.”’ ");
INSERT INTO bki_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mia naio mila vatitig kiano jidomiano jibe na bisi, naruei naio jumolu, binimei ju lilie ju lilie, binimei boru ea karam̃ano. “Mia naio maka rijikia, mia karam̃ano naio jo tinien maio ka naio julaka ga, naio jom̃a jirarag lili m̃arabo ka p̃eli mia naio rimei. Mia bogo na naio ju koalabo ka kunuano kia ga vo, mia karam̃ano bitilubar naio, tinien miia naio-o mia, ana jikiti ka riva rivitavo vijaio. Mia bogo napano naio binimei bokar kenerinio nene, miabukario ka jum̃ano be juo, maka sidom tuvanio bereio. ");
INSERT INTO bki_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ana m̃eaku mil ban karam̃ano naruei, berinavo ‘Aiou teta, kiniou nomila burum̃ara kariano va tai ban Atua, a banso bunu. Vonganei, maka rimemedu ka jau keial kiniou notibe ka kenerimo.’ ");
INSERT INTO bki_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Mia karam̃ano berbureio, bio kiano tomu na im̃auano nalo, berinavo ‘Ai, kamiu kuvila sop̃eli kuva, kuvar kulum̃arauo na bo laka, vija kiano kulubue na jaano, a kiano p̃ejelinio, vite nalo na jibe na, kuvar kumei kuviya eaio. ");
INSERT INTO bki_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","A kiribue m̃arauo nam̃a roju rabagan vurua m̃adigdig kirinovo na, kamiu kuva kuvueio, ka kito rala sado sinaniano tai ka ramijikia rasaaro kitoliko keneriku maratoru nei. ");
INSERT INTO bki_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bior keneriku nei, naio m̃aro ruei, mia meul bereio; naio ba kovio, mia kito romileal naio bereio.’ Ana ka bogo na, nalo abukudel ka jokoluolu na m̃eaku neibano. ");
INSERT INTO bki_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ana ka bogo nene, kiritete motoru naio bavenei ea tiniavio, ba jo mim̃au ruei, avona kario ana naio binimei bere vonuo. Mia bogo na naio binimei vaataro ka vonuo, naio mijog ka ajum̃a amioiou, a mijog joa na voluano jo jaburu bunu. ");
INSERT INTO bki_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ana naio mial nalo na im̃auano nei tai, bika denio, berinavo ‘?Ei, venia na jibe na nam̃a aju amila vonuo jibe na?’ ");
INSERT INTO bki_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Ana toro neibano berinavo ‘!Ai, abe kuruamo m̃a na! Naio binimei bere ruei, meul bo kia ga vo. Tenene na, karam̃amo naio jidom rila sano sinaniano tai. Amue kiribue m̃arauo nam̃a na ruei!’ ");
INSERT INTO bki_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mia bogo napano motoru mijogio naio tinien mimi, maka riva joomo naliko. Naruei karam̃ano binimei mil banio, ka rivuru naio riva joomo, mia naio miilkue ga ka rivano. ");
INSERT INTO bki_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naio ber ka ga karam̃ano, berinavo ‘?Teta, yuka vio ruei nam̃a kiniou nojom̃a nomim̃au kanamo ea vio nei? Kiniou nomidu niomo batitig bo ea vite nonovio, mia jau maka lele kala titai tibe na van kiniou. Kiniou maka lele neial ka napano jau koue kirikiti nani tai van kiniou bogo tai ka nala sinaniano tai vija kanaku bilbilu nalo. ");
INSERT INTO bki_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mia bogo napano ga jau komial kenerimo novo na naio binimei vonuo bereio, ana kojumolu komue kiribue m̃arauo novo nam̃a rojum̃a rabaganio jo mijabo m̃adigdig bo na. ?Mia tete na naio mila venia bo ruei banso a? Naio bar bulag kanamo burum̃ara puruveru togio ruei, naio ba jen puruveru nene ka ga m̃a mior ka tire nalo ga, bano-o miakon batitig garuei. ?P̃eli bajago na naruei na jau tiniem jii, tenene na jau komila sano sinaniano kanio a?’ ");
INSERT INTO bki_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mia karam̃ano tinien miia motoru nei bunu, ana naio berkanio, berinavo ‘Ei, keneriku, kiniou maka m̃a noto nosidomii tibe na liki. Jau komila kiniou najaaro toru ruei, napano m̃a kojo bija kiniou dam̃ariga, a kanaku saba nonovio na ju, kiniou namijamo ka nonovio ruei banso. ");
INSERT INTO bki_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Be riano ka keneriku maratoru na naio milaluvu m̃arabo na kiano meuliano, mia bogo na naio bilig naio binimei bereio, kiniou tiniek miia naio, ana namial jibe bo ga ka kito rasaaro ka naio, rala sinaniano tai kitoliko. Kuruamo na naio m̃aro ruei, mia meul bereio; naio ba kovio, mia kito romileal naio bereio.’ ” Naruei Yesu ber ka Varisis nalo, naio berinavo “Mo, jamerijiano nei naio bisi naruei ea vio na. Mia jibe ka napano naio berenio, bo ka toro napano milaluvu m̃arabo, naio monoka rivilig naio bereio, tavukia maratoru nei. Mia kamiu monoka kuvitikar vatitigio bunu ka mia kuvitavukia re motoru nei, napano kiano jidomiano kirisikili laka, naio mijoku ka kuruano napano bilig naio ka kiano bajag moruo ruei.” ");
INSERT INTO bki_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iorou kanio, ana Yesu mil ban kiano naiagagoano nalo, naio berii jamerijiano tai banlo, ana naio berii toro na im̃auano tai. Toro nene, naio mial ka mia kiano boru rivukular naio, naruei naio jumolu mim̃auka vite tai ka mia iorou ana kiano meuliano rivu ga. Jamerijiano nene naio jibe nei, berinavo “Toro na toru tai, naio bitirilar kiano toro tai ka rivitikar kiano puruveru nalo. Mia bogo tai, iliano binimei bokar naio ber kiano toro nene naio jom̃a jen kiano puruveru nalo, jom̃a mila lelan kiano saba nalo. ");
INSERT INTO bki_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Naruei naio bio kiano toro nene binimei mial naio, mil ban berinavo ‘Ei, tomu nalo amidu kanamo veriiano ban kiniou ruei. Kiniou namial bo ka mia nodu larso den im̃auano na bereio, mia jau kobisi ga. Mia beamu ka na jau kavano, nojidom ka jau kavar vatitig saba nalo beamu vo, ka mia kiniou namijikia noviti jabue nam̃a tomu nalo amila jua kiniou.’ ");
INSERT INTO bki_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mia toro na im̃auano nei naio mijog bova, berinavo ‘Riano, vonganei bova nono naruei. Toro na toru midular im̃auano novo nei den kiniou, maka nejikia ka mia kiniou nesen venia naruei. Kiniou nojotano ea im̃auano nei kirisiou ruei, mia maka bunu ve kiaku moroano ka nava noim̃auka tiniavio bereio, a kiniou maka nosidom natan ea yimo nalo kam̃a noiniogiog sinaniano den tomu nalo bunu. ");
INSERT INTO bki_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mo bo ga, kiaku m̃arabo naio tibe nei. Mia note vatove kija bereio tomu nalo kialo jabue nalo, mia asaaro ka kiniou-o mia monoka avitikar vatitig kiniou ka bogo na ver toro na toru rivukular kiniou den im̃auano nei.’ ");
INSERT INTO bki_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Naruei naio ba bio nalo napano kialo jabue jua toro na toru nei, nalo abinimei abeve terakurano eaio, ana naio berinavo ‘?Mo, jau komila jabue ea venia, a bokar vio?’ ");
INSERT INTO bki_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ana naio berdop̃e, ber ‘Titikivaka basidobidobi duelimo toromomou takurano 100.’ Ana toro neibano berkanio, berinavo ‘Mo, mia kito juo rete rivatove ga. Ninei be kanamo jabue nene, jau kototano ana koyolkon bulag sop̃elia nana beamu, mia kovivitauia kar ve duelimo va limo 50 ga.’ ");
INSERT INTO bki_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Mia naio bano, ana dolu binimei, ana naio bika denio, berinavo ‘?Koig a jau, kanamo jabue venia?’ Ana naio berdop̃e, ber ‘Bake na uiti tormomou takurano 100 ga.’ Ana naio berkanio, berinavo ‘Mo, mia kito ve juo rete rivatove ga. Ninei be kanamo jabue nene, jau kototano, ana koyolkon bulag sop̃elia nana beamu, ana kovivitauia kar ve duelimo va arolu 80 ga.’ Naruei naio mila jibe na-o mila nonovlo abiniu. ");
INSERT INTO bki_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ana iorou kanio, ana toro na toru nei naio bitilubar vite nei, ana naio ber ka kanano toro nam̃a jenjen kanano puruveru nalo beamu, naio berinavo ‘Riano ga, jau kobina vatitigio ka kiniou, ana namial jibe kanamo masouano tenia, jau kobe pariparimo kija ga na.’ ” Naruei Yesu berinavo “Kamiu kumial kulorinio nalo na yetemeriba nei, bogo nam̃a amim̃au bija puruveru, mia abe masou ka bo, nalo amijikia bajago na ala bilbilu vija tomu nalo, ka mia tomu nalo nene ala rivu kalo iorou bereio. Mia kiniou nemial ka napano keneriku nalo na miamoiano, va telabo nalo maka ave masou batitig rivu ka aim̃au vija puruveru napano Atua jian banlo. ");
INSERT INTO bki_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Neberenio batitig ban kamiu, neberinavo, Puruveru naio be tena yetemeriba nei ga, mia verenio mijikia riijaiso ka kove bilbilu rivu vija Atua, bo ka koim̃au kanio. Ver jau koim̃au rivu vija puruveru ea m̃arabo na memedu nene, mia iorou kanio ana Atua naio risaaro ka mia rivurso kavan ea vio na maka puruveru toaio, naina naruei be kanamo vonuo na mave. ");
INSERT INTO bki_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Toro na bar ka naio batitig bo ea im̃auano na kiritavaso ga, mia kito ramijikia ravarkar tiniedo ea naio ka mia naio rivar naio ka im̃auano na toru bunu. Mia toro na mim̃au maka rimemedu ea vite na telisu, mia naio rim̃au rivova lie vo ea vite na toru. ");
INSERT INTO bki_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ver kamiu kuvar vatitig re kamiu ka im̃auano nalo na puruveru na yetemeriba nei, mia kei bereio rivar Atua kanano tonovo nalo tua jumemiu ka ve kenemiu? ");
INSERT INTO bki_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A ver kamiu maka kuvijikia kuvim̃au rimemedu rivija vite nalo nam̃a Atua mijamo ka ban kamiu ka bogo bulati ga ea yetemeriba nei, mia kei bereio rijamo ka mauo novo nalo napano ajua vio mave ave kenemiu dam̃ariga?” ");
INSERT INTO bki_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mia Yesu ber bunu, berinavo “Bereio, ver toro na im̃auano tai, naio rim̃au dede ga ea tubo ve juo ve vaarakurano. Ver tibe na, mia naio tinien tii tinene, mia riilkue ka dolu nene, p̃eli na mia rudu tinene, mia tuvan dolu nene. Kamiu maka kuvijikia ka kuvila ka napano kamiu kube tomu nam̃a amim̃au Atua kanano, a kube tomu na puruveru ka bogo nene bunu.” ");
INSERT INTO bki_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ana na ea bogo na, Varisis nalo bunu aju kiano vo, ajum̃a amiagago ka iliano nalo nei. Mia nalo abe tomu nam̃a tiniel jii m̃elea puruveru toru bogo nonovio, naruei nalo abital lelan ga m̃arabo novo nalo na im̃auano bija puruveru napano Yesu berial ban kiano naiagagoano nalo. ");
INSERT INTO bki_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ana Yesu mil banlo berinavo “Kamiu tiniemiujii ka kuvila ka napano mia tomu nalo aial kamiu tibe ka tomu na memedu nalo, mia Atua biti dulu venia napano joa kenemiu iviso. Vite miroano napano m̃a tomu nalo amiaia, aberinavo naio bo, mia ea Atua kiano vitiiano tenalo na abova ga.” ");
INSERT INTO bki_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Iliano dolu tai napano Yesu berenio, naio berinavo “Beamu, Niosi Moruo jo, napano niosi nalo na Mosis kanano bija niosi nalo na naverialiano nalo kanalo juaio, bano-o binimei bokar bogo na Jone Baruei. Jone mim̃au bano-o bisi ana vonganei Ioluano Vou na bo na Atua kanano navenatuboiano naio binimei, naruei ajum̃a amioliolu ka janea vio reraio, mia tomu nam̃a ajidom ka ava jouro eaio na aju amila vio jikili ka ajogkario. ");
INSERT INTO bki_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mia nina maka rila ka tuboiano na Atua kanano napano joa Niosi Moruo naio bova ruei. P̃eli vio mave a yetemeriba nei nalo ava kovio ga, mia kiri m̃ariliano na tuboiano nei maka rijikia riva kovio bogo tai ka tumolu tu re.” ");
INSERT INTO bki_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Iliano dolu tai napano Yesu berenio, naio berinavo “Ver toro tai riilalar koano, ana naio riva rivuru tira dolu, mia Atua mialio ka toro nei naio jo mila siakaiano bija tira dolu nei. Be verare ga bunu ka ver toro tai soro ka tira tai napano koano na beamu miilalar naio ruei: toro nene bunu mila siakaiano.” ");
INSERT INTO bki_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu ber jamerijiano nei bunu, napano naio ber jibe nei, berinavo “Toro tai, jum̃ano bujo toru laka ka vite na bo nalo miroano, naio miyovovua naio bo laka bogo nonovio, a legiano nonovio amim̃auka sano burum̃ara sinaniano novo nalo. ");
INSERT INTO bki_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Toro dolu tai naio bunu jo, napano m̃a bogo nonovio amidudu naio binimei amidu naio jo tavio ea burusio na burum̃ara yimo na toro nei kunuano napano be kiano saba telabo. Toro nei, naio be toro tai na maka ve kiano saba tai, naio be toro tai nam̃a jo miogiog sinaniano, niabene nalo vio bujo ka meniko, a siano be Lasaros. ");
INSERT INTO bki_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Amidu naio joa vio na ka p̃eli mia naio mijikia riniog sinaniano nalo nei torogio nam̃a toro na toru nei jen digio ju, mia makanio. Naio jo miog kuleio ga jibe na, naliko kuli nalo napano abinimei amiom kanano meniko nalo. ");
INSERT INTO bki_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Milala jibe na bano-o na tete nei naio m̃aro, ana na nailiano nalo abinimei amidular naio, aba amidu jo tivelinio na Epraamo, ea vio mave. Ana maka vesiou ana na toro na toru bunu m̃aro, ana ajivinio. ");
INSERT INTO bki_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mia abuku deven naio ban ea sebi, napano mijog naio bova-o mia bova laka, mia iorou ana naio jirarag bavin, mial koalabo laka, naio mial Epraamo naio jo, a mial ka napano Lasaros jotano naljuo naio, abe juo ajum̃a ajinan. ");
INSERT INTO bki_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ana naio bio banlo, berinavo ‘Aue-e, karam̃aku Epraamo, kovijuku bo tiniem riia kiniou liki, jau keiila Lasaros rimei rudu juluvati m̃arjukjum̃ano titi ka kiri uei tai, ka titi ka minaku. Bior vonganei sebi jijen kiniou mia nomijogio bova toru nei.’ ");
INSERT INTO bki_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mia Epraamo berdop̃eio, berinavo ‘Keneriku, jau kosidomial bereio meuliano novo nanua beamu. Ka bogo na, jau kobokar kanamo vite nonovio napano jau kojidom m̃elea bo kaso, mia kiri tavaliki Lasaros nei, ea kiano meuliano re nua, vite nonovio maka tai rimelumu van naio. Vonganei, naio mije jogvuiano ea vio nei, ana jau komijog bova toru liki ea vio na. ");
INSERT INTO bki_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mia be vite tai ga, naio maka rijikia riviedu ka riijaso, bior Atua mila burum̃ara vio kiri bululuo tai napano jo iviso bure ka kito juo, ka rila ka toro rijikia re taluvo ea vio nei ka riviedu rialso, a maka rijikia taluvo ea vio na jau kojoaio ka rimei ea vio nei.’ ");
INSERT INTO bki_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Mia toro nei bika bereio, berinavo ‘Teta, aver tibe na, kiniou nabika jikili banso ka keiila Lasaros rivatove bereio ea karam̃aku kunuano, ");
INSERT INTO bki_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bior kuruaku nalo jimo aju keano vo. Bo kanio Lasaros riva ridu tiniemaiano vanlo, ver p̃eli mia nalo bunu amei ajoru ea jogvaiano nei na.’ ");
INSERT INTO bki_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mia Epraamo berdop̃e, berinavo ‘?Mia bior vaio ana monoka Lasaros naio rivano? Nalo ajum̃a abar Niosi Lu ruei, napano vivitauiano lu na Mosis kiano bija naverialiano nalo juaio ruei. Bo ka avuluku nina, ka mia aleal vite nonovio juaio.’ ");
INSERT INTO bki_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Mia toro nei naio jo jikili kia navo, naio berinavo ‘Teta Epraamo, p̃eli mia maka ajikia ala nina na? Mia ver toro tai rimei bereio ea nam̃ariano, river vite nonovio kalo, mia monoka aviliglo kanio na.’ ");
INSERT INTO bki_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ana Epraamo berdop̃e, berinavo ‘A verenio nalo na maka asidom ajog vaio napano m̃a Niosi Lu berenio, maka bunu ve titai bereio ka napano rijikia rilalo amoneaio. P̃eli toro tai rimei bereio ea nam̃ariano, river vite nonovio nalo vanlo, p̃eli na venia, mia asidom re ka amoneaio ga na.’ ” ");
INSERT INTO bki_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ana Yesu ber ka kiano naiagagoano nalo, naio berinavo “Mia jukujukuano nalo amijikia amei bogo nonovio ga, mia toro napano mila vite tai napano m̃a buru jukujukuano jo binimei vaataro, mia rivova laka vanio. ");
INSERT INTO bki_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ver aiorikar puruveru tai toa burujono ana avuku naio riva ea buluniogovu, nina na be vironiano tai napano melala ga. Mia toro nam̃a mila kanaku tete nalo nei tai juvan kiniou, mijoru ea kariano ana maka bunu tu sikili ea kiniou, mia toro nene naio rivar vironiano tai napano kirisikili laka riva lie vo tovulu ninei. ");
INSERT INTO bki_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ver tibe na, monoka kuvitikar vatitig kenemiu meuliano nalo bogo nonovio, ka mia m̃a kala re jukujukuano rimaluvo ka kiamo bilbilu nalo.” Ana Yesu berenio, berinavo “Ver jau keial ka napano kuruamo naio jo mijoru ea kariano, monoka keil van naio ka kovururirio, mo ver naio rivilig naio, monoka jau koviekokoa naio. ");
INSERT INTO bki_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A ver naio rila rivova vanso ve va aluo ka legiano ve takurano ga, a bogo nonovio, naio mila kirivova karina naio ber vonga berinavo ‘Aire koig, aua namila bulagso toru laka. Naber bo ka jau, koviekokoa kiniou,’ mia jau kala tum̃abe? Monoka jau koviekokoa naio ve va aluo nei nonovio riviniu.” ");
INSERT INTO bki_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ana atevi nalo abika den Yesu, aberinavo “Tubo, kumemi numisidom ka jau kala kenememi viekouoiano rimei sikili lie vo.” ");
INSERT INTO bki_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Naruei naio berdop̃e, berinavo “Ver kamiu kuvika kiniou ve telisu ga, tavukia kurukuti m̃arabako, mia ver kenemiu viekouoiano nene naio sikili rivu, ana mia kumijikia kuver ka burupati burujou yako kuverinavo ‘Jau kataluvo den jelemo na vija kanamo pati nalo, jau kava kotu koiluo ea tinia tei iviso,’ ana mia naio rimonea kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ana Yesu berinavo “Ver kamiu tai naio ve toro na toru tai, a kanano toro tai tom̃a rila kiano im̃auano. P̃eli naio riva rim̃au ea tiniavio, p̃eli na rivitikar kiano temeul nalo, p̃eli na venia, ana verenio kijev bogo na naio rimei bereio ea im̃auano, mia toro na toru nei naio river venia kanio? Maka rijikia river kanio riverinavo ‘Mo, jau komei kototano vija kiniou, kito ve juo rosinan,’ bior naio be kiano toro na im̃auano ga. ");
INSERT INTO bki_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mia toro na toru monoka river kanio ga riverinavo ‘Mo, mia kava kovorosebi beamu vo. Verenio sinaniano rimenoko, ana kava koyovovua so rivu, ana kavar saku rimei ka nesenio, a nomunuio, bisi, ana mo jau komijikia koviovio samo.’ ");
INSERT INTO bki_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mia bogo napano toro na im̃auano nei mila nonovio vite nalo nam̃a toro na toru ber ka naio, mia toro na toru maka rijikia river burum̃ara siva tai vanio, bior nina be kiano im̃auano ga. ");
INSERT INTO bki_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mia kam bunu monoka tibe na. Verenio kamiu kuvila vatitig nonovio im̃auano napano Atua ber ka kamiu, rivano-o riviniu, mia kuver ga tibe nei, kuverinavo ‘Aa, nina maka ve titenia na. Kito rala ga venia napano memedu ka kito ralaio, tavukia Atua kiano tomu na im̃auano nalo ga.’ ” ");
INSERT INTO bki_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ana ka bogo na, Yesu nalo aju amiel kia ga vo ka avavin Yerusalemo, ana kialo m̃arabo jel bure tanobuku juo nei Sameria bija Kalele. ");
INSERT INTO bki_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naruei nalo amiel bano-o, vaataro ka ayotuba ea m̃arkomeli tai, abitavo bija taara tai na tomu na burumieni, nalo duelimo, napano ajujum̃a ea ikim̃arabo. ");
INSERT INTO bki_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Mia bogo napano amial Yesu, abio jouo banio, aberinavo “Yesu, Tubo, nuber bo kaso tiniem riia kumemi.” ");
INSERT INTO bki_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ana bogo napano Yesu mijogio, naio ber kalo berinavo “Kamiu kuva kuvar laka ea kulo lu nalo beamu vo, ka avitii veve niabemiu nalo ka aver niabemiu nalo ameravo ruei.” Naruei nalo abano, ana bogo napano aju amiel abano, amiilo ka mokotenalo nalo aju abinimei meravo. ");
INSERT INTO bki_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Naruei nalo tai, bogo napano mial ka naio binimei bo ruei jibe na, naio barp̃ilig binimei, miaia Atua laka, ");
INSERT INTO bki_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","binimei mijorua tano ea Yesu jaano, ber siva kanio. Toro na, naio maka ve Ju tai memedu, mia naio be yati na Ju togio na Samaria. Mia nalo dolu na, nalo abe Ju memedu, mia nalo maka amei bereio. ");
INSERT INTO bki_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ana na Yesu berinavo “Nalo napano niabelo meravo ruei, nalo duelimo, mia nalo kover dolu nene nalo be? ");
INSERT INTO bki_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Naina binimei bereio, naio be toro na vio dolu ga, mia ka venia ana naio ga takurano binimei bere ka rivamenea Atua, ana nalo dolu nalo maka amei bereio?” ");
INSERT INTO bki_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Naruei Yesu ber kanio berinavo “Koig, jau kotumolu keiel kava vonuo. Kiamo viekouoiano milarurso ruei.” ");
INSERT INTO bki_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ana iorou, kulo Varisis nalo abinimei abika den Yesu, aberinavo “Navenatuboiano na Atua kiano nam̃a jau kojom̃a koberii vurua na mia kumemi nuvialio nagi?” Ana na Yesu berdop̃e, berinavo “Atua kiano navenatuboiano naio maka rijikia rimei tibe ka titai napano toro mijikia rialio ka mirano. ");
INSERT INTO bki_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Naio maka ve titai napano mia averinavo ‘O naio naruei, jau komial naio jo binimei kia,’ p̃eli na averinavo ‘Naio nei jo binimei ruei.’ !Kamiu maka kuvitilubario, mia Atua kiano navenatuboiano naio ju iviso ka kamiu ruei!” ");
INSERT INTO bki_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Naruei Yesu mil ban kiano naiagagoano nalo, naio jukunu banlo ber mia tum̃abe ka legiano na maaro nalo napano aju abinimei. Naio berenio “Iorou kanio ana mia kamiu kuvilavio sikili ve toru ka kuvial bogo na mia kiniou Kulorinio Kenerinio noyotuba ea yetemeriba nei, mia nina maka ve kenemiu ka kuvialio. ");
INSERT INTO bki_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mia tomu nalo atum̃a averver averinavo ‘Naio nei!’ p̃eli na ‘Naio yako!,’ mia kamiu kuvan re rivijalo, bior maka kiniou navo. ");
INSERT INTO bki_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mia bogo na kiniou Kulorinio Kenerinio nemei bere be riano rimonloglog legiano nene, mia aviniu avitilubario, mia kiniou nemei tavukia vio bijiio tai napano rila niogovu rimerera ea vio tivelinio riva rivokar tivelinio dolu nene. ");
INSERT INTO bki_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mia maka ve bogo na vite nene vo, bior beamu ka nina, mia kiniou Kulorinio Kenerinio, tom na vonganei mia monoka ala kiki kiniou ka saba vetelabo, mia monoka avukular kiniou. ");
INSERT INTO bki_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Rivano-o rivokar bogo na mia kiniou Kulorinio Kenerinio nemei bereio, mia tomu nalo atu vatitigio re rivu, rivare ga ka nanua amila ea bogo na tormoruo Noa kiano bogo. ");
INSERT INTO bki_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ka bogo nene, tomu nalo ajidel ka m̃a ajinan, a ajum̃a amunu vite nalo, ajum̃a amila soriano jibe na ga, binimei bokar bogo na Noa ba joomo ea kiano burum̃ara uako nanua naio mim̃aukanio. Naruei burum̃ara ueimia binimei burubulag nonovio kialo meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A ea bogo na Lot kiano jibe na ga bunu. Tomu nalo ajum̃a ajinan, ajum̃a amunu vite nalo, ajum̃a aban ea yimo na ṽilṽiliano a amila bijii puruveru, ajum̃a amim̃auka tiniavio, ajum̃a amim̃auka yimo, amila jibe na banbano-o, mia maka bunu tinielrimaio ka titai leleio. ");
INSERT INTO bki_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mia monloglog legiano napano Lot jumolu den kialo vio, mia sebi bija vovosebi na sebi jinano ajibirbil abavatove ea vio yauo, jijen nonovlo abiniu abava kovio. ");
INSERT INTO bki_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mia kiniou neber ka kamiu ka mia bogo napano mia kiniou Kulorinio Kenerinio nemei, mia tomu asidomial re titai, mia asidomialo ga, mia nalo aiilo va ka burum̃ara vite nalo na jibe nei amalmaluvo ea kialo meuliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ea bogo na, ver toro tai tom̃a rivonvon ea kunuano mave ea ino, mia naio rial tenei naio to rimei, mia ver naio rivatove, mia maka rivu ka rilavon ka rivar kiano saba joomo ea kunuano, mia naio monoka rivan ga tibe na. Mia toro nam̃a mim̃au ea tiniavio, naio bunu maka rivu ka rimei bere vonuo, mia naio monoka rivan ga tibe na. ");
INSERT INTO bki_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kam tiniemiu ribobogia re Lot koano, napano jiraragodi, mia naio binimei be puruveru ju. ");
INSERT INTO bki_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Toro nam̃a jidom rilarur kiano meuliano ga, mia naio rila luvuio, mia nana m̃a mijamo ka kiano meuliano ba kovio, mia rilarur naio bereio. ");
INSERT INTO bki_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kiniou neber ka kamiu ka ea bogo na, p̃eli ka bogiano napano mia toro tai naio koano amon ea m̃alo jogu, mia amei avurular tinene ga, mia atuvan tinene tobo. ");
INSERT INTO bki_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","P̃eli na tira ve juo atu vio takurano avijii salo baba, mia ve takurano ga rivano, mia tinene naio tobo. ");
INSERT INTO bki_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","P̃eli na tomu ve juo atu aim̃au biju ea tiniavio, tinene tuvan vio rivan mia tinene naio sikili tumomou tu.” ");
INSERT INTO bki_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Naruei kiano naiagagoano nalo abika denio aberinavo “?Ana Tubo, vite nalo nene mia ayotuba ea vio be?” Ana naio berdop̃elo, berinavo “Ea bogo nene, mia tavukia napano ver tena m̃aro tai jo kovio tai. Ea vio na naruei, menu nalo nam̃a ajenjen tena m̃aro, mia nalo amei kanio, monoka nalo ve miroano ea vio nene. Ea vio na vabe napano kariano joa, vio na naruei ve natibureano eaio.” ");
INSERT INTO bki_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ana Yesu jii jamerijiano dolu banlo, ka tunukakarlo ka m̃a tinielo veve juo re bereio ea kanalo volkouano, mia atu sikili dam̃ariga eaio, abolkouo rivano-o mia avokar verdop̃eiano eaio. ");
INSERT INTO bki_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kiano jamerijiano nei, naio ban jibe nei, berinavo “Be komeli tai, tubo nene naio be toro kouo tai, be toro tai nam̃a maka rialerinio ea Atua leleio, maka rimerou kanio, a maka tovon tomu nalo bunu. ");
INSERT INTO bki_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ana taanou tai bunu joa vio na, napano toro tai jom̃a mila bulag kiano saba nalo bogo nonovio ga, ana taanou nei naio jo ba jo jegi ban kanano tubo, jom̃a mila kiano veriiano ka toro neibano, berinavo ‘Aiou, jau monoka kala titai ka tete na, naio jom̃a mila kiki m̃elea kiniou mia.’ ");
INSERT INTO bki_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mia tubo nei maka tinien riia tira nei, naio miovo ka ril van tete neibano. Mia naio mila jibe na banbano-o, mia tira nei naio jom̃a monmon ga ba jegi ban kanano yubo. “Ana iorou kanio ana tubo nene berenio ‘Kiniou nebe toro tai nam̃a maka nosidomial ka nala vaio nam̃a Atua p̃eli toro dolu ber ka kiniou ka bo ka nalaio. ");
INSERT INTO bki_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Mia tira nei naio jom̃a binimei jegi vururu ban kiniou mia maka nosidom nala tena m̃a jom̃a berenio. Mia naio jom̃a binimei bika jibe na, mila kiki tanea kiniou toru laka, p̃eli mia nala ga venia nam̃a naio jom̃a bikanio. Ver p̃eli mia tinieku rim̃aro ka nojog kiano tegiano.’ ” ");
INSERT INTO bki_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ana Yesu mil ban nalo nam̃a ajum̃a amije tilinielo ka jamerijiano nei, ana naio berinavo “?Kamiu kuviagago vatitig ka toyovo nei kiano iliano nam̃a berenio? Bior tira nei jegi va telabo banio, mo mia naio monoka sidomii vite nam̃a tira na naio jom̃a bikanio. ");
INSERT INTO bki_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Mia tum̃abe ka Atua na mave? ?Bogo na naio mijog ka kiano tomu nalo nam̃a bijauia bulaglo, ajum̃a ajegi ban legiano a bogiano, mia naio rijikia to vesiou tibe na rivano-o mia rila re titai vanlo? ");
INSERT INTO bki_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Makanio, mia neber ka kamiu ka ver naio rijog ka m̃a kamiu kumitum̃a kubolkouo jikili dam̃ariga banio, mia naio tumolu sop̃eli ga tulaka ka rijai kamiu. ?Mia nejidom nevika kamiu bunu, ka ver bogo na mia kiniou Kulorinio Kenerinio nemei bereio ea yetemeriba nei, mia nemijikia neial ka tomu vetelabo atu sikili ea kiniou tibe na, p̃eli na mia ve re tai kovio ga?” ");
INSERT INTO bki_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bogo na Yesu jo bija tomu nalo, naio bitilubar ka napano nalo tealo ajum̃a abe m̃arou toru laka, aju aberiam̃a kialo meuliano memedu bo ruei, mia ajum̃a abitii saia tomu dolu nalo, amialo jibe ka maka avu tibe ka nalo. Naruei naio berii tomu nalo jibe nei, jii jamerijiano tai, berinavo ");
INSERT INTO bki_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tom juo, aba joomo ea Atua kunuano monloglog bogo na volkouano. Nalo tinene, naio be Varisis, mia tinene, naio mila im̃auano tai napano tomu nalo maka tiniel tii naio riviorio, naio be toro na takis. ");
INSERT INTO bki_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mia bogo na Varisis naio jo jumolu ka rivolkouo, naio ber jibe nei, berinavo ‘Atua o, kiniou neber burum̃ara sivaiano toru laka nei banso, napano kanaku meuliano naio bo lie jovulu nalo dolu nei kanalo. Nemiaiaso napano kiniou maka natavukia tomu na vinauano nalo, p̃eli tomu na amijukubin toro, p̃eli tomu nam̃a amila siakaiano, p̃eli tomu na takis jibe ka ninei jumolu ju nei. ");
INSERT INTO bki_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Makanio, mia kiniou nojom̃a nomila bo laka dam̃ariga, bior kiniou nomondulu ka nojom̃a nobolkouo banso ea legiano juo ka sude takurano, a ea vite nonovio nam̃a kiniou nabokar ka jum̃aku, verver novokar ve duelimo mia monoka nodu ve takurano vanso dam̃ariga. Vite nalo na naruei nam̃a kiniou nojom̃a namilaio ana mila kiniou nobo laka ea miramo.’ ");
INSERT INTO bki_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mia toro na takis naio jo mijog bova bior kiano kariano tealo nam̃a milaio, mia niabene buru vurebure jibe Atua bitii kiano meuliano maka rimemedu leleio. Naruei naio niabene p̃ili ka riva vaataro keanio, naio jumolu ju koalabo ga, mia maka sidom sirarago rivavin mave, naio jurubanini naio jom̃a mijubaluba bairene, naio jegi naio berinavo ‘!Aiou Atua, jau kala lup̃ilup̃i kiniou, a tiniem riia kiniou, kiniou toro na kariano.’ ");
INSERT INTO bki_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Mo kamiu kumisidomii von: mia Atua naio saaro ka tomjuo nei na vabe kiano volkouano? Nao-o, toro napano bitilubar kiano kariano, naio mijog bova biorio, Atua mijelar kiano kariano. Mia dolu nene, naio ban bere vonuo napano kanano meuliano jo jibe ka ga bogo na naio binimei. Toro nam̃a jo bavavin ea naio, mia Atua rudu naio to yetano, mia toro nam̃a jo midu naio jo yetano, mia Atua rivitiri lario.” ");
INSERT INTO bki_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ana ka bogo na, nena nalo tai abar kenerilo solbouo nalo abinimei ea Yesu, ajidom naio tokol lo, rilivu kalo. Mia bogo na naiagagoano nalo amileal, aberburelo, aber avatavio bereio. ");
INSERT INTO bki_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mia Yesu bio ban tire nalo, ber amei bo ka ga aialio, a naio ber ka naiagagoano nalo, berinavo “Kamiu kuverbure re kiritete nalo na, kuvijamo kalo amei aial kiniou, bior kiritete nalo na, tomu nalo napano ajavukia nalo, nalo ga naruei aju aba jouro ruei ea navenatuboiano na Atua kanano. ");
INSERT INTO bki_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kiniou neber be riano ban kamiu, ka toro na ver sidom navenatuboiano na Atua kanano, naio monoka rila naio tibe ka kiritete nalo nei, ver p̃eli, naio maka rijikia riva jouro eaio.” ");
INSERT INTO bki_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Avona bisi, ana tubo tai binimei bika Yesu, berinavo “Naverloglogiano novo, neber bo kaso, jau koverial van kiniou ka monoka nala venia ka mia nemijikia novokar meuliano na maka rijikia ribisi.” ");
INSERT INTO bki_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ana Yesu berdop̃e, ber “!Ei! ?Jau komijikia venia, ana kobio kiniou kober kiniou nobo? Maka ve toro dolu tai na rivu ve riano, mia Atua ga takurano. ");
INSERT INTO bki_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mia jau kobika kober jum̃abe ka toro tai na jibe ka jau mijikia rimei rivu ea Atua mirano. Mo, p̃eli jau komijikia batitig tuboiano nene nalo ruei nam̃a aber ka: Jau kala re siakaiano, jau koue tam̃aria re toro, jau kovina re, jau kala sibi re, jau kotovon karam̃amo naio koniomo ga.” ");
INSERT INTO bki_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ana tete nei naio berdop̃e ber “Nao, kiniou nomijikia nono tuboiano nalo nam̃a jau kober kiana, mia nomijikia na ver ka jau ka kiniou nojom̃a nabokar batitiglo jikar ea bogo na kiniou nobe m̃eaku kia ga vo. Binimei bokar vonganei, maka nalabelea tai.” ");
INSERT INTO bki_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mo bogo napano Yesu mijog ka napano naio ber jibe na, naio berenio “Kirinovo, mia tivelinio na jau, vite tai ju keano vo. Jau monoka kava koṽiliṽili nono ka kanamo saba nalo na miroano na, mia jau kavar puruveru nene, kavano katan ka van talim̃asa nalo. Ver jau kala tibe na, mia ve kanamo vite novo nalo ve miroano ea vio mave. Mo, jau kava kalaio, avona bisi ana komei katakisor kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mia bogo napano toro nei mijog iliano nei, naio mijog kiano iviso jegi toru laka, kiano jidomiano kiri temi m̃ele, bior naio be toro na jum̃ano bujo ka saba toru laka. ");
INSERT INTO bki_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Naruei Yesu bitii toro na toru nei bano-o, kar na naio berinavo “Ver toro tai na kiano saba toru, ver naio sidom riva jouro ea Atua kiano navenatuboiano, vite na kirisikili kija na. ");
INSERT INTO bki_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nao-o, kiniou neber ka kamiu, ver kamele tai riovodulu ea bulumirano nitil tai, nina be kirisikili laka, mia ver toro tai na be kiano saba toru mia naio sidom ka riva jouro ea Atua kiano navenatuboiano, nina naio kirisikili lie vo ka nina.” ");
INSERT INTO bki_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mia nalo napano amijog iliano na, nalo abamenea naio kanio, aberinavo “!Tomnei! Ver tibe na, mia kei naio mijikia rijev meuliano?” ");
INSERT INTO bki_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mia Yesu naio berdop̃e, berinavo “Nao-o, toro maka rijikia rila naio rijev meuliano, mia venia nam̃a toro maka rijikia rilaio, mia Atua naio mijikia rilaio rivu ga.” ");
INSERT INTO bki_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ana Pitere naio bika, berinavo “?Ana mia tum̃abe ka kumemi? Kumemi numituvan kenememi vonuo nalo ruei, ana kumemi nubinimei numitakisorso.” ");
INSERT INTO bki_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mia Yesu naio ber ka kiano naiagagoano nalo, naio berinavo “Kamiu kuvisidomii m̃elea re tivelinio na. Ka toro kei napano ver tuvan kiano vonuo, p̃eli koano, p̃eli karam̃ano a kenieno, p̃eli na kenerinio nalo, mia ver naio tuvan vite nalo nonovio na rivior im̃auano na Atua kiano navenatuboiano, ");
INSERT INTO bki_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mia naio rijev meran bere kiano saba nalo na jibe nei ve miroano lie vo. Nina ea bogo na naruei, a iorou ka bunu ea bogo na ju binimei, mia naio rivokar meuliano na maka rijikia ribisi.” ");
INSERT INTO bki_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Mia bogo na ajum̃a amiel abano, ana Yesu bio kiano duelimo ba juo 12 abinimei kean naio, naruei naio ber kalo berinavo “Kamiu kuviagago vatitig rivu. Vonganei kito roju rabavin Yerusalemo kia nei, mia bogo na kito rovoru ea vio na, vite nonovio nanua nailiano nalo abivitauiaio nua ruei ea tivelinio na Kulorinio Kenerinio, mia kamiu kuvial amalmaluvo takiio. ");
INSERT INTO bki_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“Mia kamiu kuvial ka napano adu naio toa kulo Romo nalo jum̃alo, ka mia aserei niadua rivanio, ala kiki naio, a avule titia naio, ");
INSERT INTO bki_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","a avitiv naio, rivano-o mia auebin naio rim̃aro. Mia ka bogoti ve tolu nene, ana mia naio tumolu rimeul bereio.” ");
INSERT INTO bki_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Be kurano ka na Yesu berial vite nonovio meravo banlo jibe na, mia maka lele ajoglubarbar vatitigio rivu. Naio jibe ka napano amilavan iliano nei kalo, mila ana maka avokar batitig nioti na iliano nene. ");
INSERT INTO bki_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mia Yesu nalo aju amiel abano, abinimei vaataro ka komeli na vio Jeriko, mia merebono tai jom̃a jotano ea ikim̃arabo, naio jom̃a miogiog sinaniano den tomu nalo nam̃a ajeljel ea m̃arabo nei. ");
INSERT INTO bki_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Naruei merebono nei naio mijog ka Yesu nalo aju abinimei, naliko tiniobi nalo napano ajum̃a amiel bijaio, ana naio bika berinavo “Nalo na vio be na, ajum̃a amiel ka ava be?” ");
INSERT INTO bki_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naruei nalo aberdop̃e aberinavo “!E, abe Yesu na vio Nasarete ga, naio miel binimei jel kean kito ga!” ");
INSERT INTO bki_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ana toro nei bio jouo, jegi ban Yesu berinavo “!Yesu, jau Teviti kiano yati, kiniou nojidom ka jau tiniem riia kiniou!” ");
INSERT INTO bki_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mia nalo nam̃a aju amiel jukamu ka Yesu, amijog ka m̃a naio bio jibe na, ana aberbureio, aber naio rimelumu ga. Mia tete nei naio maka sidom rijoglo, mia bio bereio, jouo lie, berenio “!Yesu, jau Teviti kiano yati, neber bo kaso, tiniem riia kiniou!” ");
INSERT INTO bki_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Mia Yesu miel bano, mebi loglog vio nene, ana ber avuru toro nene rimei vaataro kanio. Ana aburio binimei, ana Yesu bika denio, berinavo ");
INSERT INTO bki_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Jau kojidom ka mia kiniou nala vaio kaso?” Ana naio berdop̃e berinavo “Aiou, Tubo, kiniou nojidom ka miraku rivu, ka nejikia neial vite.” ");
INSERT INTO bki_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ana Yesu berinavo “Mo, vonganei kiniou nesian kiamo siraragiano vanso tibe ka na jau kobikanio. Kiamo viekouoiano milaso kovu bereio.” ");
INSERT INTO bki_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mia monloglog bogo na, toro nene mirano binimei bo, ana naio jom̃a miel naliko Yesu, naio jom̃a miaia Atua toru laka. Mia tomu nalo bunu napano amial vite nei, amial bo laka, ajum̃a abamenea Atua siano biorio. ");
INSERT INTO bki_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mia Yesu nalo abinimei jouro ea komeli na vio Jeriko, ajum̃a amiel aban ka aiovodulio ga. ");
INSERT INTO bki_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mia ea vio na, be toro tai jo, siano Sakias. Naio be toro na toru ka nalo na takis ea tanobuku na toru na vio nei, mia bior naio jom̃a mim̃au bova, jom̃a mijukubin tomu nalo ka kialo puruveru na takis nene, mila jum̃ano bujo kanio, kiano saba nalo miroano. ");
INSERT INTO bki_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Mia naio bunu binimei ka bogo nei, jidom rial kija Yesu ka naio be toro na jum̃abe, mia tomu kinkin telabo aju vaataro ka Yesu, aju kovio amila vio telisu laka, mila naio maka rijikia rial vatitigio, bior naio be toro na bulati ga tai. ");
INSERT INTO bki_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mia mial bova ga, ana jikiti jukamu ka Yesu nalo, ba bokar buruviove tai, jakiio bavin mave joa jaati tai, jororea ka mia Yesu nalo aiel amei, ka mia naio mijikia rial vatitigio. ");
INSERT INTO bki_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mia bogo na Yesu binimei bokar buruviove nei, Sakias miilo ka napano Yesu jirarag bavin, mialio, mil banio berinavo “Sakias, jau katabulu sop̃eli. Kiniou nomijoglubar ea kiniou ka banei monoka noto kija ea kiamo vonuo beamu vo.” ");
INSERT INTO bki_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mia Sakias mijogio, jumolu jabulu sop̃eli batove, naruei buru Yesu ba vonuo ea kunuano, bija burum̃ara saariano tai. ");
INSERT INTO bki_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Naruei bogo na tomu nalo amial tenei, nalo telabo maka asaaro, amil mum̃iio tertelisu, a berinavo “Toro na Sakias na, naio be toro tai nam̃a mim̃au kirivova, naio jom̃a mijukubin tomu nalo bogo nonovio ga, mia kar vaio ana Yesu jidom riva to naljuo ea kiano vonuo?” ");
INSERT INTO bki_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mia bogo na aju joomo kario, ana Sakias mijog lubar ka monoka naio rivilig naio, riyelar kiano meuliano, naruei naio jumolu berial ea Tubo mirano, naio ber “Tubo, vonganei kiniou nomijamo ka kiaku saba torogio ban tomu na abe talim̃asa, maka ve kanalo titai. A venia nam̃a namila sibilili toro kanio, nebina kalo, mia navar meran bereio vokar ve va veri tukario.” ");
INSERT INTO bki_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mia Yesu mijog bo toru laka ka venia napano Sakias mijue bulagio banio, ana berinavo “Kiniou nemial jibe ka banei ioruriano na Atua kiano naio binimei bokar m̃aratavo nei memedu. Tete na naio milaluvu m̃arabo na kiano meuliano, mia naio bunu naio be Epraamo kiano bajulukuti memedu, naio be toro Ju riano, ");
INSERT INTO bki_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","mia kiniou Kulorinio Kenerinio nebinimei ea yetemeriba nei ka nesirago nalo nam̃a amilaluvu m̃arabo jibe toro nei, a ka nalarurlo.” ");
INSERT INTO bki_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mo tomu nalo ajum̃a amije tilinielo ka Yesu kiano iliano nalo nei, naruei naio mil banlo ba ber jamerijiano tai kalo. Naio mial bo ka riverlogloglo ka jamerijiano nei, bior naio mijikia ka tomu nalo ajum̃a ajidom aber bogo na naio riva rivoru Yerusalemo, mia naio rila Atua kiano navenatuboiano riyotuba kalo ve vaarakurano ga ruei. Mia vonganei aju abinimei vaataro ka Yerusalemo ruei, ana Yesu jidom riverlogloglo ka mia naio monoka tuvanlo beamu vo, karina mia naio rimei bereio. ");
INSERT INTO bki_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naio ber kalo jibe nei berinavo “Be toro na toru tai, aber ka naio ka rieli riva koalabo ea vio na parinio tubo na toru joaio, ka avitirilar naio ka rimei rive parinio tubo ea tanobuku na kiano, karina, mia mijikia rimei bereio rive tubo ea kiano vio. ");
INSERT INTO bki_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mia beamu ka bogo na maka rivan vo, naio bio kiano tomu nalo, nalo duelimo, mia mije puruveru banlo abeve terakurano. Ana naio ber kalo berinavo monoka aim̃au rivija puruveru nei o-o mia bogo na naio rimei bereio. ");
INSERT INTO bki_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mia tomu nalo na tanobuku nei amiolu titig toro na toru nei, mia bogo na naio ban kario, ana aberiio aberinavo maka bunu asidom naio ka rimei rive parinio tubo kalo. Naruei amiila toru ba ban parinio tubo na toru, aber ‘Kumemi maka nuvisidom nuvial kema na rimei ka rive parinio tubo ka kumemi, kumemi maka lele garuei nuvisidom jau kodu burum̃ara sio na vanio.’ ");
INSERT INTO bki_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mia parinio tubo na toru nei naio mila ga, ana toro na toru nei binimei bereio ka rive tubo ea kiano tanobuku. Naruei naio binimei bio kiano tomu nalo nei napano naio bar puruveru banlo beamu ruei, naio jidom ka rial ka amim̃au eaio abokar puruveru vio bereio. ");
INSERT INTO bki_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ana toro na jukamu binimei jikili jukamu ea toro nei mirano, berinavo ‘Tubo, kanamo puruveru takurano ga naio nei, kiniou nomim̃au bija bano naio milelar duelimo bereio judu kanio.’ ");
INSERT INTO bki_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ana na toro na toru nei naio mial kanano toro nei mim̃au bo, ana naio berkanio berinavo ‘!Bo mia bo, komim̃au bo laka. Mia bior jau kobitikar batitig im̃auano telisu na nomidu joa jum̃amo na, vonganei nodu burum̃ara im̃auano tai vanso, nebitiri larso ka kovitikar kanaku komeli duelimo na tortoru.’ ");
INSERT INTO bki_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Bisi, ana naliano ka binimei, naio berinavo ‘Tubo, puruveru takurano nua komidu ban kiniou, nomim̃au eaio bano-o nemijev jumo bereio judu kanio.’ ");
INSERT INTO bki_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ana na toro na toru berkanio, ber ‘Kobo, jau bunu komim̃au bo, mo mia kiniou nevitiri larso ka mia kovitikar kanaku komeli jumo na tortoru.’ ");
INSERT INTO bki_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Avona bisi ana na maariano nene naio binimei, berinavo ‘Tubo, kanamo puruveru na komidu ban kiniou, nomijuvulukoio batitig ka niakulm̃arauo tai, nomidu van batitigio jo, naio nei nomidu ber binimei ka nodu vanso. ");
INSERT INTO bki_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kiniou nojo nomialso jibe ka kobe toro tai na komijikia kavar bulag vite na toro dolu mije batitigio jo ve kanamo, a komijikia kejinan ea tiniavio na maka komebijaio. Kiamo bajago kirisikili kija jibe na, mila na kiniou nomerou kaso, tenene na maka nala titai ka kanamo puruveru nene, nomidukar batitigio jo bo ga.’ ");
INSERT INTO bki_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ana toro na toru nei tinien jerio, naio berinavo ‘Kaleliki, jau kober niegeniege kiniou kirivova tenia navo, napano kober nobe toro kouo tai jibe na. Mia bo ga, mo kanamo iliano na mia serso bereio. ");
INSERT INTO bki_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Ver kiniou nobe toro na jibe na, bior vaio ana komidukar kurano ka kanaku puruveru jibe na? Bo laka ka ver jau kodu riva toa yimo na puruveru, ka ver nemei bereio, ana nemijikia navar bulagio rivija boboti napano naio miin bulagio.’ ");
INSERT INTO bki_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ana na toro na toru nei naio ber ka nalo dolu na ajikili aju vaataro, berinavo ‘Kuvidular puruveru na den jum̃ano, kuvidu van nana mileal duelimo.’ ");
INSERT INTO bki_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ana nalo aber ka toro na toru nei, aber ‘!Ana Tubo, naio bar miroano kiana, kiano duelimo ruei!’ ");
INSERT INTO bki_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Mia toro na toru ber kalo, berinavo ‘Nao-o, jibe na naruei. Nana be kiano saba telabo ruei, mia naio rivar ta bunu bereio, mia nana maka kiano titai mia naio rilaluvu venia napano be kanano telisu mugaruei. ");
INSERT INTO bki_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mia tivelinio ka kiaku uolu nalo nei, napano maka asidom neve tubo kalo, nejidom ka kuva kuvurulo amei ea vio nei, kuvuebinvinlo am̃arm̃aro kamu ea miraku.’ ” Naruei Yesu kiano jamerijiano naio biniu ea vio na. ");
INSERT INTO bki_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iorou ka napano Yesu ber iliano nei bisi ana naio jumolu, miel jukamu bano, burum̃arabo kalo abavin Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mia nalo abinimei vaataro ka komeli juo na tertelisu nei Betevas bija Betani, ea tivelinio ka Burusuku na Buruolivi nalo. Ana Yesu mil ban kiano naiagagoano juo, berinavo ");
INSERT INTO bki_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kuve juo kuviel kuvan ea komeli na telisu yako jo beamu vo. Mia bogo na ver kuva jouro eaio, mia kuvial togki tai amiorkar ju. Togki nene be m̃eaku ga, maka ala kor taakano vo, mia kuvijubarlar sano teli ana mo kuvuru kumei bere ea vio nei. ");
INSERT INTO bki_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mia ver avika den kam juo averinavo ‘?Ai, kumitu kumijubarlar sano teli ka venia?’ Ana mia kamiu kuverdop̃elo kuverinavo ‘Tubo jidom temeul nei ka rila kiano im̃auano tai.’ ” ");
INSERT INTO bki_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yesu ber jibe na kalo, naruei miilalo abano, mia nalo amial jibe ka ga napano naio ber kalo. ");
INSERT INTO bki_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ana na nalo aba ajum̃a amijubar bulag temeul nei sano teli, mia bogo nam̃a ajum̃a amilaiio, ana sano taanou nalo abika aberinavo “?Ai, kumijubarlar sano teli ka venia a?” ");
INSERT INTO bki_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naruei nalo aberdop̃elo, aberinavo “Makanio, Tubo naio jidom temeul nei ka rila kiano im̃auano tai beamu vo.” ");
INSERT INTO bki_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ana nalo amijamo kanio, ana na nalo aburu togki nene binimei ban Yesu, mia abisii bulag m̃alo kulukoti nalo mave ea taakano, ana na amidular Yesu bavin jotano mave eaio. ");
INSERT INTO bki_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ana Yesu midu togki nene, jom̃a miel bano, mia bogo na naio jo bano, mia tomu nalo abisii m̃alo kulukoti nalo ea m̃arabo, kanio mia Yesu kiano togki mijikia riel mave ealo. ");
INSERT INTO bki_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Naruei nalo amiel ea Burusuku na Buruolivi nalo, bano-o abinimei aboru ea vio na m̃arabo mialolo batove ka rivatove Yerusalemo. Mia bogo na burum̃ara tiniobi na naiagagoano nalo miroano amial ka Yesu jo miel binimei vaataro ka vio Yerusalemo, mia ajidomial bereio burum̃ara im̃auano nalo bija kijokijo nalo nam̃a naio milaiio, mia amial jibe ka napano kialo burum̃ara parinio tubo vou tai naio jo binimei, mila na ajaaro toru kanio, aju abamenea Atua biorio. ");
INSERT INTO bki_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ajum̃a abiovio, aberinavo “!Atua loa laka, keilivu ka parinio tubo nei binimei ea siamo! Burum̃ara merivuiano ea vio mave, kamiu na ea vio na mave kuvitirilar Atua siano, kiano mermerano bo mia bo!” ");
INSERT INTO bki_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mia ka bogo na, Varisis tealo aju iviso ka tiniobi nalo nei, mia maka lele asaaro ka na abitirilar Yesu jibe na, ana na aberii kanio, aberinavo “!Naverloglogiano, koverbure kanamo naiagagoano nalo na ka auetuba kavuru kaso re tibe na!” ");
INSERT INTO bki_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mia Yesu berdop̃e banlo, berinavo “!Ee, vede ga. Ver nalo aviovio tibe na re, p̃eli mia puruveru rera ga nei monoka nalo aviovio.” ");
INSERT INTO bki_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Mia Yesu binimei vaataro ka rivokar burum̃ara komeli nei Yerusalemo, mia naio jirarag ba jouro eaio, tinien miiaio, ana jikar ka jogumirano jibirbil biorio. ");
INSERT INTO bki_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mila jibe na ana naio mil ban memedu, berinavo “Kiniou nomijog bova toru kaso. Ver jau kovitilubar ga venia miyotuba ea kiamo vio banei nei! Atua jo mila kiamo m̃arabo novo tai ka kojev tum̃aro eaio, mia jau maka kovitilubario. ");
INSERT INTO bki_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mia monoka nover ka jau ka mia bogo tai rimei easo napano mia kanamo uolu nalo ve miroano laka amei kaso. Mia aseliviv easo atukoso, a mia ayuku bijii borotano rimei vio takurano, ve kialo m̃arabo ka mia amijikia avavin ea kanamo burum̃ara tagvoru nalo. ");
INSERT INTO bki_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mia amei jouro, aue vatitigso. Mia auebinvin kenerimo nalo, a mia ala bulag nonovio kunuamo nalo, avar bulag kiamo burukis nonovio avatove mia riviniu. Vironiano na jibe na mia rimei easo bior ka napano jau maka kosidom kovitilubar ka banei be kanamo bogo memedu ka napano Atua maluvo ka rilarurso.” ");
INSERT INTO bki_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Naruei Yesu miel ba jouro ea komeli, mijaka ban ea Atua Sop̃i kunuano lu, ana mial nalo nam̃a aju amim̃au bior veru ea vio na. Naruei naio mijil dedade ealo, berinavo ");
INSERT INTO bki_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Atua ber ea kiano Iliano Lu, naio berinavo ‘Kunuaku Lu naio be yimo na volkouano,’ mia kamiu kubiliglar yimo nene ruei, binimei jibe ka buluvae tai na tom na vinauano nalo kunualo.” ");
INSERT INTO bki_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ana ka bogo na Yesu jom̃a bava joomo ea Yimo Lu legiano nonovio, naio jom̃a berloglog tomu nalo, mia tomu na tortoru ka kulo lu nalo naliko naverloglogiano na tuboiano nalo bija tomu nalo kialo tomu na tortoru maka lele asaro kanio. Ajum̃a ajiravo kavuru m̃arabo ka amijikia ala titai ka rila Yesu monoka rim̃aro. ");
INSERT INTO bki_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mia bede ga, abitilubar ka maka ajikia aleal m̃arabo tai, bior tomu nalo nam̃a ajum̃a amije tilinielo ka kiano verloglogiano, tiniel jii kiano iliano nalo toru laka, ajidom naio julaka ga. ");
INSERT INTO bki_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mia ka legiano dolu bereio, ana Yesu ban bere joomo ea Yimo Lu na Atua Kunuano yako Yerusalemo, naio jom̃a berloglog tomu nalo a jom̃a mioliolu ka Ioluano Vou na bo banlo. Ana tomu na tortoru na kulo lu nalo bija naverloglogiano na tuboiano nalo bija navurim̃araboiano dolu nalo abinimei eaio, abika denio aberinavo ");
INSERT INTO bki_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“?Jau kover von ka kumemi, ka nam̃a jau kojom̃a komila jibe na ea vio nei ea kei siano? ?A kei ber kaso ka jau kala tibe na?” ");
INSERT INTO bki_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ana Yesu berdop̃elo, berinavo “Mo, mia kiniou bunu nevika vikadeniano tai den kamiu beamu vo. Kiaku vikadeniano jibe nei, ber ");
INSERT INTO bki_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","?Varueiano nam̃a Jone jom̃a mila nua ban tomu nalo, naio be vite tai napano Atua berkanio ka m̃a naio rilaio, p̃eli na Jone ga naio jidom ka rilaio? Kamiu kuver von nina.” ");
INSERT INTO bki_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mia Yesu kiano vikadeniano nei mila amil toru banlo, ajum̃a aberinavo “?Mia kito rover tum̃abe ka naio? !Kito rovitikario vatitig rivu! Ver kito roverinavo varueiano na Atua ber ka Jone, mia tete na naio monoka rivika bere den kito riverinavo bior vaio ana maka romonea Jone. ");
INSERT INTO bki_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mia bunu, ver kito rover Jone ga jidomii ka rilaio, mia tomu nalo tinielser kito, mia atuba kito, bior nalo aju amonea Jone jikili ruei ka napano naio be Atua kiano nailiano riano tai.” ");
INSERT INTO bki_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ana jidomiano na mila ana aberdop̃e ban Yesu aberenio nalo maka ajikiaio ga. ");
INSERT INTO bki_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mia Yesu ber kalo, berinavo “Tibe na, mia kiniou bunu, maka nejikia never ka kamiu ka kei naruei naio ber ka kiniou ka nala im̃auano nalo nei.” ");
INSERT INTO bki_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ana Yesu ber jamerijiano tai ban tomu nalo na ka bogo na, berinavo “Toro na toru tai, bija kiano jiotilikrevi tai. Bogo tai naio jidom riel rivan ea buruvenuo dolu tai, napano jo vaatarobe laka, ana juvan kiano jiotilikrevi nei ban tomu dolu nalo ka mia amei aim̃au eaio, ka mia avulu vanio. ");
INSERT INTO bki_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ana toro na toru nei naio ba jo-o, avona bitilubar ka be bogo na m̃arkrevi meruo naruei. Jibena miila kiano toro tai ka ban bereio ea nalo napano ajua kiano jiotilikrevi nei, ka rivar puruveru na m̃arkrevi nei togio napano monoka avulu vanio. Ana toro nei bano, mia bogo na naio miyotuba kalo, nalo maka asidom avuluio, mia amue naio ga o-o bisi ana na amiila naio ban bereio jum̃ano ravavo ga jibe na. ");
INSERT INTO bki_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ana toro na toru nei miila kiano toro dolu tai bano, mia abitivi naio bunu, amila lelan toru laka, ana amijil deven naio ban bereio jum̃ano yauo ga jibe na. ");
INSERT INTO bki_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mo varolu nene, toro na toru nei miila kiano toro dolu bereio, mia naio bunu, amueio-o bar ja, ea naio toru laka, ana abukulario den jiosi. ");
INSERT INTO bki_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Mo toro na toru na jiosi nei naio mial bajago na kirivova nei, mia naio maka bunu rijikia naruei, berinavo ‘!Aiou! ?Bo ka mia nala tum̃abe naruei? P̃eli vonganei, monoka neiila ga keneriku rivano. Naio be keneriku takurano ga, tinieku jii m̃elea naio, mia ver naio rivan mia nalo monoka avitilubar avijuku rivu ka naio.’ ");
INSERT INTO bki_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Naruei miila naio bano, mia bogo na tomu nalo amialio, nalo ajidomii kirivova kanio. Aberiio ealo, aberinavo ‘Naina be toro na toru kenerinio na. Toro na naruei, napano ver toro na toru na riva kovio, mia naio naruei rivar kiano borotano nene tibe kiano jajum̃ano ve kiano. Bo ka kito rouebin naio rim̃aro, kanio mia kito ga romijikia ravakar borotano nei rive kiado.’ ");
INSERT INTO bki_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Naruei nalo ajumolu abokario, abukulario batove den jiosi nene, amuebinio.” Ana Yesu berinavo “Tukunu nei naio bisi ea vio na, mia bo ka kamiu kuvisidomii vonio. Bogo na toro na toru rijog tenei, mia naio rimei rila tum̃abe ka nalo nei? ");
INSERT INTO bki_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Neber ka kamiu neber tomu kirivova nei, mia naio rimei ruelo, am̃arm̃aro ea bajago kouo tai, a mia naio rudu kiano jiosi nei toa tomu dolu na bo nalo jum̃alo.” Ana bogo na amijog Yesu naio ber jibe nei, amijog lubar ka iliano nei be ilivaniano tai, ber jibe ka kulo Ju maka asidom naio napano be Atua kenerinio, ana mia Atua rivuru tomu nalo na maka ave kulo Ju adu jelelo. Ana vite nei nalo maka asidom ajogio, naruei nalo amil jikili aberinavo “Vite na jau kojom̃a koberiio na, Atua maka lele rijamo ka mia riyotuba tibe na.” ");
INSERT INTO bki_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mia Yesu bitikarlo, bika ber “Kamiu maka kumisidom, ana bior vaio ana abivitauia iliano lu nei napano naio ber jibe nei, berinavo ‘Puruveru na, tomu nalo napano amim̃auka yimo aber naio bova, mia abuku ban ruei, mia vonganei, puruveru nene naio binimei be puruveru na kirinovo tai ea sudu na yimo, ka rudukar yimo sikili.’ ");
INSERT INTO bki_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Tomu nonovio na mia ava aserbap̃e ea puruveru nei mia ajoru napano mia puruveru nene rila kokorov mokotenalo. Mia ver riva rivokar bogo na puruveru nei rijoru, toro kei napano puruveru mon kakario mia rila kitkitio rivova, naio riva kovio.” ");
INSERT INTO bki_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ana naverloglogiano na tuboiano nalo bija tomu na tortoru na kulo lu nalo, abitilubar ka Yesu kiano jamerijiano nei jilogloglo memedu, naruei nalo tiniel jerio lie vo, ajumolu ajidom avokar naio rimemedu ea bogo nei garuei. Ajidom toru ka ala titai kanio, mia amila dede ga, bior amial ka tomu nalo ajum̃a tiniel jii naio ga. ");
INSERT INTO bki_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jibe na naruei ana bogo nono ga ajum̃a abitivitiio, a nalo tealo ajum̃a ajivanlo ga aba vaataro kanio, abar kokoalo ga amilalo jibe amonea naio bo, mia tena ajum̃a amilaio, ajum̃a abarkakar kiano iliano nonovio ga. Kialo jidomiano, ka ajidom aleal iliano na naio riverenio, ana amijikia ala veriiano van toro na toru na vio Romo nene Pailat, ka naio mijikia sian vironiano tai vanio tibe ka na ajidomio. ");
INSERT INTO bki_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ana nalo nam̃a ajum̃a abar kokoalo ka napano abinimei vaataro ka Yesu, bogo tai ana abika vikadeniano tai denio, ajidom ajukubinio. Aberinavo “Naverloglogiano, kumemi nubitilubar ka kiamo iliano a kiamo verloglogiano be riano a memedu. A kumemi nubitilubar ka jau maka ketibure tomu nalo aveve dolu, mia komialo abe veverare ga kojom̃a koberial Atua kiano m̃arabo na memedu ka tomu nalo nonovio. ");
INSERT INTO bki_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ana numisidom nuvika denso tibe nei ka: ?Kiado tuboiano naio ber jum̃abe? ?Naio ber memedu ka kito kulo Ju nalo rovulu takis van parinio tubo na Romo na Sisa, p̃eli na ber maka rimemedu?” ");
INSERT INTO bki_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mia Yesu bitilubar ka ajidom ajukujuku naio, naruei naio ber kalo, berinavo ");
INSERT INTO bki_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kuvidu puruveru sesa nene tai rimei van kiniou. ?Kuvial von kei mirano na joaio? ?A sio nei ajiri joaio, be kei siano?” Nalo aberinavo “Sisa mirano na, a siano na bunu.” ");
INSERT INTO bki_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ana naio ber kalo, ber “Mo, tena be Sisa kanano, kamiu kuvidu van Sisa. A tena be Atua kanano, kamiu kuvidu van Atua.” ");
INSERT INTO bki_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nalo nei ajidom toru ka avokar vatitig kija Yesu ea tomu nalo miralo ka kiano iliano tai, ana mia bogo nam̃a amijog kiano verdop̃eiano nei, amiilo toru kanio, amial ka naio bokar tanealo, ana nalo aju buru ga, maka bunu ajikia aver bereio titai. ");
INSERT INTO bki_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mia iorou ka naina, Satusis nalo tealo abinimei ea Yesu, ka ajidom avika denio ka tivelinio na vite tai nam̃a abiekar kouo eaio, aber tomu nalo na am̃arm̃aro, maka bunu ajikia ameul bereio ea bogo na maaro. ");
INSERT INTO bki_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Naruei nalo abika denio, aberinavo “Naverloglogiano, kumemi numisidom nuvikaso, ka jum̃abe ka iliano tai nam̃a tormoruo Mosis re nua naio bivitauiaio be kiado. Naio berinavo, ver toro tai rim̃aro den koano, napano maka ve kenerilo tai vo, mia monoka nana lian ka naio rivuru taanou nene ve koano, ka mia rila ka tira nei mijikia rivar tete, ka mia rudu kuruano napano naio m̃aro siano, ka mia siano rimeul to. ");
INSERT INTO bki_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mo, ka bogo tai, be kurualo aluo. Motoru kalo buru tira tai be koano, mia m̃aro den koano napano naljuo maka avar kenerilo tai vo. ");
INSERT INTO bki_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ana maratoru naio kija buru tira nene, karina naio bunu m̃aro denio, ");
INSERT INTO bki_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","karina baratoru, naio bunu milaio, bano-o bokar kurualo aluo nene, nalo abiniu amila jibe na ga, napano maka ve kenerilo tai leleio. ");
INSERT INTO bki_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ana iorou ka koano nalo nao-o abiniu, tira nene bunu m̃aro. ");
INSERT INTO bki_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mo jau kover von vite na. Ea bogo na maaro, ka bogo nam̃a ajum̃a aberveriio vurua na aber mia tomu nalo atumormolu bereio, mia tira nei naio ve kei koano, bior naio joro ka kurualo aluo nei abiniu ruei?” ");
INSERT INTO bki_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Naruei na Yesu berdop̃elo berenio berinavo “Ea yetemeriba nei ga tomu nalo ajum̃a ajorjoro, ");
INSERT INTO bki_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","mia nalo napano Atua ber ka amijikia ameul bereio ea nam̃ariano, ka ava jouro ea kiano vio, mia maka bunu ajikia alaio. Ka bogo na, maka bunu asorsoro kalo, ");
INSERT INTO bki_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","mia maka bunu ajikia am̃arm̃aro, bior mia amei atavukia nailiano nalo. Mia Atua rivuru meul ealo bereio den nam̃ariano, naruei amei ave kenerinio nalo riano. ");
INSERT INTO bki_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Mia ka tivelinio ka na meul bereio na, Mosis bunu beriio nua ruei, naina jakii tukunu na buruiesi tai napano sebi jom̃a bovago eaio. Ea vio na romial ka Mosis naio jom̃a bio Atua Sop̃i ber naio be Atua na Epraamo kanano, a Atua na Aisak kanano a Atua na Yakovo kanano. ");
INSERT INTO bki_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ana bogo na Mosis naio ber iliano na, tom tolu nei am̃aro ea yetemeriba nei nua bogo be ruei, jibe na am̃aro ea yetemeriba nei, mia aju ameul ea Atua kiano vo. Atua naio maka ve Atua na tomu na am̃aro ga, mia naio jidom ka tomu nalo na aju bija naio nalo abe tomu na ameul. Ea Atua kiano vitiiano, tomu nalo nam̃a am̃aro ruei ea yetemeriba nei, nalo ameul kia ga vo aju.” ");
INSERT INTO bki_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ana naverloglogiano na tuboiano nalo, nalo ajum̃a amiagago ka Yesu kiano verdop̃eiano ban Satusis nalo, ana amial ka naio be masou bo laka, ana aber “Naverloglogiano, kanamo verdop̃eiano naio bo mia bo.” ");
INSERT INTO bki_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aber jibe na bior Yesu kiano iliano nei mila Satusis nalo amerou ka avika vite tai den naio bereio. ");
INSERT INTO bki_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Naruei Yesu mil ba lie banlo, bika vite denlo, berinavo “Bior vaio ana nalo ajum̃a aberloglog kamiu, aberinavo Naverikariano naio monoka riyotuba ea tormoruo Parinio Tubo Teviti nene kiano yati, napano nua naio be Parinio tubo beamu? ");
INSERT INTO bki_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kiniou nebika naina, bior beamu, Teviti naio bivitauia niosi na Iouano kanano, berinavo ‘Atua Sop̃i naio ber ka kiaku Tubo, naio berinavo “Jau kototano ea vameruo na kanaku, ");
INSERT INTO bki_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jau koto rorea rivano-o, mia kiniou nala kanamo uolu nalo amei tibe ka yebe tai nam̃a kobijankon jaamo eaio.” ’ ");
INSERT INTO bki_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Ea vio na romial ka napano Teviti naio jom̃a bio Naverikariano ka kiano Tubo mugaruei. ?Mo bior Teviti naio ber jibe na, mo jum̃abe ana ajum̃a aberenio mia Naverikariano naio riyotuba ea Teviti, rive kiano yati tai ga?” Mia ea bogo tai bereio, amiilo toru ka Yesu kiano iliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ana tiniobi nalo aju amiagago ka kia ga vo, ana Yesu berial iliano tai, napano be kanano naiagagoano ga nalo kialo. ");
INSERT INTO bki_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Naio berinavo “Kamiu kuvitikar kamiu ka naverloglogiano na tuboiano nalo na nam̃a abarvar kalo m̃ele ka m̃alo burutili kulu-m̃arauo nalo na, a verenio nalo amieliel ea vioruru nalo, ajidom ka tomu nalo monoka avatove kalo, avio vatitiglo averinavo ‘!Aiou, naverloglogiano novo, kavijo bo!’ A ea bogo na jokoluolu p̃eli joomo ea yimo na volkouano nalo bunu, nalo ajidom ka dam̃ariga atutano ea vio na tomu na tortoru nalo kanalo ga. ?Kamiu kubitilubar ruei, a? ");
INSERT INTO bki_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mia ajum̃a aburu kialo volkouano nalo kiri p̃etep̃eteli laka, mia ajum̃a amila sibi ga, bior ka bogo nene ga, nalo ajum̃a amijukubin taanou nalo, amila bulaglo. Naruei bior kialo bajago nalo na, mia kialo vironiano sikili lie vo.” ");
INSERT INTO bki_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Naruei bogo napano Yesu nalo ajua Yimo Lu na Atua Kunuano, ana amial ka napano tomu tealo abinimei ka mia avuku kialo ijaiano ea basaro na Yimo Lu. Naruei Yesu bitiio, ana naio mial ka nasanibaiano nalo abinimei abuku kialo ijaiano novo nalo, ");
INSERT INTO bki_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ana na iorou kanio, naio mial bunu taanou tai, napano naio be talim̃asa ga, mia naio binimei buku kiri veru sesa juo ga. ");
INSERT INTO bki_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Naruei naio berii tira nei banlo, naio berinavo “?Kamiu kumial taanou na, napano naio buku kiri veru sesa juo na? Kiniou neber riano ban kamiu, ka naio jian loa jovulu nonovio ijaiano dolu nalo na nasanibaiano nalo na kanalo. ");
INSERT INTO bki_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nalo be kialo burum̃ara veru nalo, mia amije bena ga togio, mia taanou na, veru telisu nei naio bokario ka rijekar kiano meouliano, naio jian nonovio ban Atua.” ");
INSERT INTO bki_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Karina iorou ka naina, tomu tealo ajum̃a aberii Yimo Lu, aberinavo naio kirinovo tai mia, bija sano veru maraiu nene nalo, a tonovo nalo napano m̃a tomu nalo abario kam̃a miyovovua tanobuku nene. Ana Yesu mijog tukunu nalo na jibe nei, ana berinavo ");
INSERT INTO bki_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“?Kamiu kumitum̃a kumial vite nalo na kuber bo? Neber ka kamiu mia iorou ka bogo tai na jo binimei, mia ve re bunu puruveru tai totano vatitig ea jeleigio, bior mia tomu nalo tai amei aue bulag searia yimo na riviniu.” ");
INSERT INTO bki_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mia bogo na nalo amijog ka Yesu ber jibe na, abika denio, aberinavo “?Ana Naverloglogiano, mia aue bulag Yimo Lu nene nagi, a mia kumemi nuvijikia nuvial kijokijo venia naruei naio verial ka vaataro ka vite nalo nene amalmaluvo?” ");
INSERT INTO bki_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ana na naio ber kalo, berinavo “Bo ka kamiu kuvitikar vatitig kamiu rivu, ka mia ve re toro tai rimei rila sibilili kamiu, bior mia tomu ve telabo napano mia adu siaku, mia nalo amei averinavo ‘!Kiniou nebe Naverikariano nei!,’ p̃eli averinavo ‘!Naina naruei, bogo nene naruei!’ mia maka rivu ka kuvitakisorlo. ");
INSERT INTO bki_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ana ver ka bogo na, mia kamiu kuvijog uetubaiano na mira, a jaleleano nalo aju vaataro, mia kumemebiju m̃ele re. Vite nalo na monoka amalmaluvo beamu, mia naina maka ve bogo na maaro nene navo.” ");
INSERT INTO bki_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ana naio ber bunu kalo, berinavo “A parinio tubo nalo, mia ala mira kanio parinio tubo dolu nalo, a venuo nalo atumolu ka venuo dolu nalo. ");
INSERT INTO bki_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mia m̃ii ve toru, mia reraio ea yetemeriba nei mia ve burum̃ara vituiano a mieiano kouo nalo, a rivija naina mia ve vite na memebijuiano ave burum̃ara kijokijo nalo ea bulu niogovu yauo mave. ");
INSERT INTO bki_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mia bogo na ve re vite nalo nei vo, mia tomu nalo ala kiki kamiu ve toru laka. Mia nalo amei avokakar kamiu sikili, avar niajebijo rivan kamiu, ana iorou kanio mia adu kamiu kuvitua jum̃ano navurim̃araboiano na yimo na volkouano nalo, p̃eli na avuku kamiu kuva kuvitua yimo na tetavokoiano, p̃eli ala kamiu kuvitumolu kuvitua mirano kialo parinio tubo nalo p̃eli na kialo navurim̃araboiano nalo. Vite va nalo na mia kuvarilo bior kubokar siaku jikili. ");
INSERT INTO bki_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka bogo na mia sikili laka rivan kamiu, mia rive kenemiu bogo na kuvijikia kuverial Ioluano Vou na bo vanlo. ");
INSERT INTO bki_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Mia vonganei, bogo na vite nalo nei maka vo, kamiu kuvisidom m̃elea re ka mia kuver venia ka bogo na, ");
INSERT INTO bki_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bior rimonloglog bogo nene ga, mia kiniou nesian iliano na masouano rivan kamiu. Mia bogo na kuver iliano nalo nei ka kenemiu uolu nalo, mia tovulo, mia ajikia re ka atup̃edop̃e bereio kenemiu iliano nene. ");
INSERT INTO bki_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ka bogo na, mia nalo na ga napano m̃a kumitum̃a kubiolo ka teta p̃eli kuruemiu p̃eli tumano p̃eli bilbilu, nalo na jibe na naruei napano mia amijikia avuru bulag kamiu kuvano, adu kamiu kuvitua tomu na tortoru nalo jum̃alo, ka mia ala tanea kamiu rivano-o mia m̃a auebinvin kamiu tealo am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mia tomu nalo tiniel ser kamiu laka, mia nalo asian liliu iliano rivan kamiu napano siaku joa kamiu. ");
INSERT INTO bki_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","“Mia kiniou neber ka kamiu ka mia vijumiu tai riva kovio deio. ");
INSERT INTO bki_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mia kamiu kuvitu sikili rivano-o kuvitovulu juluvati na bogokouo nene, ana ea m̃arabo na naruei mia kamiu kuvokar meuliano riano na kenemiu.” ");
INSERT INTO bki_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mia ea tivelinio na burum̃ara bogokouo nei mia rimei, Yesu ber kalo bereio, ber “Telikiti na ver kuvial taara na tomu na mira atu selivivko burum̃ara bulukomeli na vio Yerusalemo, mia kuvijikia ka bogo na burum̃ara sano labulagiano nene naio jo binimei vaataro. ");
INSERT INTO bki_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mia bogo na kuvial vite nei, kamiu na kuvitua vio Yutea, bo ka kuvuro, kuva kuvitivan kamiu ea suku nalo, mia ver kamiu na kuvitu jouro Yerusalemo, bo ka kumolmoluo kuvuro kilkil, p̃eli na kamiu na kuvitu mave nei, maka rivu ka kuvilavio ka kuvatove vonuo bereio. ");
INSERT INTO bki_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nina bior ka bogo na, naio be burum̃ara legiano na lameraniano na Atua kiano siniabu, tavukia na vivitauiano re nua nalo aberkakario. ");
INSERT INTO bki_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka bogo na bunu, mia ve kirivova laka rivan tire nalo na be m̃abolo, rivija bunu nalo nam̃a ajum̃a amije yu ban kenerilo solbouo nalo. Ka bogo na, mia ve burum̃ara najogvaiano ea kiado venuo nei, a burum̃ara siniabu rimei ea kiado tomu nalo nene. ");
INSERT INTO bki_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mia iobogu na mira rila vinvin ve telabo atibirbil, mia m̃arimieni riorkar ve miroano jum̃alo, avurulo ava aim̃au kurano ga ea taara dolu nalo. Mia kulo dolu nalo avie niegeniege kitkit lelan komeli lu na kito kulo Ju kiado Yerusalemo nei, mia ave tubo eaio rivano-o rivokar bogo na Atua jekar ka ve kialo bisi.” ");
INSERT INTO bki_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ana na Yesu berii legiano na maaro, naio berinavo “Ka bogo na, mia amijikia aial kijokijo ea m̃erenio a ea siberio a ea m̃arvitano nalo. Ea yetemeriba nei, mia taara na tomu nalo mia niukniuku rivielo ve toru laka, asidom bijobijon ve toru, mia bogo na aial tei tumolu ve toru to rivavauro, mia nalo ajikia re ka mia tum̃abe kalo. ");
INSERT INTO bki_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Telikiti na nalo abitilubarbar ka venia napano m̃a jo binimei ea yetemeriba nei, a napano vite na tortoru nalo na bul niogovu yauo amikulkulu janea vio, mia nalo amemebiju ve toru, meribobogo am̃arm̃ariulu rivior meroano. ");
INSERT INTO bki_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mia ala tibe na rivano-o, ana iorou kanio ana mia aial kiniou Kulorinio Kenerinio noyotuba ea melijo vija kanaku burum̃ara moroano a vija kanaku burum̃ara miamoiano. ");
INSERT INTO bki_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Ana ea tivelinio na kamiu, ver bogo na kuvial vite nalo nei atikar kam̃a amalmaluvo tibe na, mia kamiu kumerou re. Mia niukniuku rivie re kamiu, mia kamiu kuvitumolu kuvar bulag pariparimiu kuvisirarag mave, bior vite nalo na nioti nene ber kenemiu toro na laruriano naio jo binimei, vaataro ka riyotuba.” ");
INSERT INTO bki_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ana na Yesu ber jamerijiano tai banlo ea tivelinio na bogokouo na jo binimei keano vo, naio berinavo “Kamiu kuvisidomii von burubilivo na, p̃eli na buruiesi dolu nalo na jibe na. ");
INSERT INTO bki_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Telikiti na kumial jaati nalo abinimei amemeaio, a abinimei amelokloko, a sidiati nalo abarboṽelo, ana na kamiu kumijikia ka be bogo na vio bitunu jo binimei vaataro. ");
INSERT INTO bki_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jibe na bo ka na ver kamiu kuvial kijokijo nalo nei, ajum̃a amalmaluvo jibe na javukia nam̃a kiniou naber ka kamiu ruei, mia kamiu kuvijikia ka navenatuboiano na Atua kanano naio jo binimei vaataro kean kamiu. ");
INSERT INTO bki_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Riano neber ka kamiu, mia vite nonovio na monoka ayotuba tibe na rivano-o, mia iorou kanio ana taara na tomu na ameul ea bogo na ava kovio ea yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mia vio yauo rivija yetemeriba nei nalo ve juo bunu ava kovio, mia kanaku iliano nalo maka ajikia ava kovio bogo tai.” ");
INSERT INTO bki_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Naruei Yesu midu iliano na banlo ka bogo na, iliderevijoiano banlo, naio berinavo “Mo ea tivelinio na kamiu, kamiu kuvitii vatitig kamiu. Maka rivu ka kenemiu meuliano tanea vio, p̃eli na kumunu m̃elea m̃arjum̃elm̃elu p̃eli na vite nalo na jibe na, a maka rivu ka kenemiu jidomiano to tulaka ea vite nalo na yetemeriba nei ga. Aver p̃eli, mia kuvitum̃a kuvila tibe na rivano-o mia kuviilo ka burum̃ara legiano na maaro riyotuba ka kamiu vaarakurano ga tavukia viobijiio. ");
INSERT INTO bki_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nao, mia tomu nalo tanea vio reraio ea yetemeriba nei, mia atu asidomialio re, atu avitilubario re, mia legiano nei rivokarlo tibe ka na menu miilo ka buruniavo julubinio m̃aro garuei. ");
INSERT INTO bki_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mia monoka kamiu kuvitu derevijo dam̃ariga, monoka kuvitu kubolkouo ka kuvijikia kuvitu sikili ka kuvilarur kamiu ea vite nalo na mia ayotuba, rila ka mia kamiu kuvijikia kuva kuvitumolu kuvitu ea kiniou Kulorinio Kenerinio miraku.” ");
INSERT INTO bki_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ana na Yesu jom̃a berlogloglo jibe na ea Yimo Lu ka legiano nalo, mia ka bogiano naio jo batavio den komeli, ba joa Suku na Buruolivi Nalo. ");
INSERT INTO bki_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mia kavijova nalo, ana tomu nalo ajumolu sop̃eli, aban bereio ea Yimo Lu ka ajog kiano iliano nalo. ");
INSERT INTO bki_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na karina, bogo binimei vaataro ka nam̃a yuka nonovio, amila kialo jokoluolu juo na tortoru, jibe ka jokoluolu na najenjeniano na beskit napano maka isi toaio, bija jokoluolu na nasidomialiano na ioruriano. ");
INSERT INTO bki_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ana ka bogo na, tomu na tortoru na kulo lu nalo bija naverloglogiano na tuboiano nalo, ajum̃a amila vio ka auebin Yesu keano vo, mia maka ajikia aleal m̃arabo tai, bior amerou ka ver alaio, p̃eli mia tomu nalo ajikia ala titai kalo. ");
INSERT INTO bki_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mia monloglog bogo na ga, sim̃aro binimei ba joomo ea Jutas na vio Kariot kiano iviso, napano naio be na duelimo ba juo tai. ");
INSERT INTO bki_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ana na maka vesiou, ana naio jumolu, bano ba miyotuba ka nalo napano tortoru ka kulo lu nalo bija tomu na tortoru na kialo menumia nalo, berial kiano jidomiano, ana na nalo aberii m̃arabo na vabe napano bo ka mia naio mijikia tiveluku ka Yesu selia rivanlo. ");
INSERT INTO bki_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ana na Jutas kiano jidomiano milalo amijog bova toru laka, mia nalo amial bo ka aje veru tai rivan naio riviorio. ");
INSERT INTO bki_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mia Jutas jaaro kanio, mia jikar ea bogo na, julaka ga naio jom̃a jiravo ka vulu kiano bogo ka ver bogo tai napano ver ve re bunu tomu nalo tai eaio, ana na mia mijikia tiveluku ka Yesu rivanlo. ");
INSERT INTO bki_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Naruei abinimei monloglog legiano na beamu na jokoluolu na najenjeniano na beskit napano maka isi toaio, napano naio be bunu legiano napano monoka ala sida na nunu sesa nalo ka sidomialiano na ioruriano. ");
INSERT INTO bki_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Naruei Yesu ber ka Pitere bija Jone, berinavo “Neiila kamjuo ka kuva kuvila vatitig vite nalo na sado sinaniano na jokoluolu nene.” ");
INSERT INTO bki_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ana na naljuo nei abika denio aberinavo “?Ana jau kojidom ka nuvila vatitigio to be?” ");
INSERT INTO bki_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ana na Yesu berinavo “Kuve juo kuva kuvokar m̃aratavo na toru na vio Yerusalemo, mia bogo na ver kuva joomo von kiaga eaio, mia kuvial toro tai napano midu burum̃ara bauei tai na rimei rivetavo ka kamiu. Mia kuvitakisorio kuva a mia naio rivuru kamiu kuvan ea yimo tai. ");
INSERT INTO bki_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mia bogo na ver kuva joomo ea yimo nene, mia kuvil rivan toro nene kuverinavo ‘Kiado naverloglogiano naio bika berinavo, Kumemi valauo nalo, kenememi vajoomo naio be, ka nuvijikia nuvisen sinaniano na sidomkariano na ioruriano eaio?’ ");
INSERT INTO bki_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kuvil tibe na rivanio, naruei mia naio siloglog ka kamiu ka burum̃ara vajoomo tai mave, napano vite nonovio juaio ruei, ana na mo kuvila vatitig vite nonovio na sinaniano nei ea vio nene.” ");
INSERT INTO bki_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mia Yesu ber jibe na ka naiagagoano juo nei bisi, ana na abano, mia amial ka vite nonovio miyotuba jibe ka ga napano naio beriio kalo jukamu. Jibe na naruei, ana na amila vatitig sinaniano na maaro na Yesu sano. ");
INSERT INTO bki_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Karina Yesu nalo abinimei mave ea vio nene, ana bogo na sinaniano, Yesu ba jotano ea vio na sinaniano, mia atevi nalo abinimei ajutano naliko. ");
INSERT INTO bki_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ana na Yesu mil banlo, naio berinavo “Bogo jiou ruei, kiniou najom̃a nojidomii sado sinaniano na sidomkariano na ioruriano nene. Ninei naruei saku sinaniano na maaro, napano kito ga rosinan vio takurano, ana iorou kanio ana mo nemijikia navan ea kanaku bogokouo. ");
INSERT INTO bki_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kiniou neber ka kamiu ka joko nei nioti nene berii ioruriano. Mia kiniou nesen re bunu bereio, rivanvano-o rivokar bogo na kiaku ioruriano rimei ea yetemeriba nei, ea bogo napano mia Atua kiano navenatuboiano rimei.” ");
INSERT INTO bki_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Naruei naio midu baja tai, bolkouo ber siva ban Atua biorio, avona bisi ana ber kalo, berinavo “Kamiu kuviyon burevure tanea kamiu, kamiu ga kumunio. ");
INSERT INTO bki_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nina bior jikar vonganei, mia kiniou nomunu re bunu m̃arjum̃elm̃elu rivano-o rivokar bogo na mia Atua kiano navenatuboiano naio rimei.” ");
INSERT INTO bki_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Naruei naio mije salo niajoko, naio bolkouo ber siva ban Atua kanio, avona bisi ana burekokorovio janealo, berenio “Ninei be mokotenaku, napano namijamo ka bior kamiu, mo mia monoka kamiu bunu kuvitu kuvila tibe na, tibe ka kenemiu buruka ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ana iorou kanio, bogo napano ajinan bisi, naio mila jibe na bereio javukia napano mila ka niajoko jukamu, naio midu baja namuniano tai, berenio “Baja nei naio be kijokijo na kiaku burukija napano mia riou ka kamiu, ka vitirilar Atua kiano virakariano vija kamiu. ");
INSERT INTO bki_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mia be titai bova, toro na mia tiveluku ka kiniou, naio be kito tai ga napano rojinan vio takurano nei ruei. ");
INSERT INTO bki_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mia kiniou Kulorinio Kenerinio monoka nam̃aro tibe ka nam̃a aberkario nua ruei, mia toro napano mia tiveluku ka kiniou, tiniek miia naio, mia rivova lie vo van naio!” ");
INSERT INTO bki_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mia bogo napano amijogio, ana na nalo ajum̃a abivika denlo amilavon ka alealio na vabe kalo napano jo jidomii ka mia rila tibe na, mia maka avokario. ");
INSERT INTO bki_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ana ka bogo na, siniabu jumolu bure naiagagoano nalo, ber mia kei kalo napano mia nalo asirarag kanio ka naio loalo lie, rive kialo navurim̃araboiano. ");
INSERT INTO bki_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Mia Yesu mijogio ana na naio berenio berinavo “Kito romijikia ruei tomu na tortoru nalo na yetemeriba nei kialo bajago, Parinio tubo nalo abe tubo ka kialo tomu nalo, a navurim̃araboiano nalo, tomu nalo monoka atovonlo, adu sio na loa laka rivanlo, abiolo aberinavo toro na bitikarlo. ");
INSERT INTO bki_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mia kamiu kiaku naiagagoano nalo, monoka kuvila re kamiu tibe ka tomu na tortoru nalo nei. Naio be kenemiu napano p̃eli mia averinavo naio be toro na toru, mia monoka naio rimei tibe ka kenemiu toro na kiritelisu tai, tibe kanio napano naio moluo iorou. Kamiu tai napano ver sidom ka naio rimei rive kenemiu navurim̃araboiano, naio monoka rimei tibe ka toro na mia m̃a riijaja kamiu. ");
INSERT INTO bki_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ka bogo na sinaniano, toro tai jotano ana toro dolu bar sano sinaniano binimei banio. Naruei naljuo nei, na vabe nene napano amial jibe ka naio toru lie loa tinene? Kamiu kumijikia, mia kiniou maka netibe ka naio, mia kiniou nebinimei ea yetemeriba nei jibe ka naio nam̃a mila im̃auano, miija kulo dolu nalo, bijuku bo kalo.” ");
INSERT INTO bki_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ana na Yesu ber kalo, berinavo “Kamiu na, nemial kumitibe ka kiaku ikurukariano na bo nalo ea bogokouo nalo nam̃a nabokario, binimei bokar banei. ");
INSERT INTO bki_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mia jibe kanio napano teta naio bitirilar kiniou ka neve tubo ea kiano vio, mia kiniou bunu neber ka kamiu neber nevitiri bulag kamiu kumei kuve m̃artubo nalo ea kiaku vio nalo nei. ");
INSERT INTO bki_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tibe na, ana na mia kamiu naruei kuvijikia kuvitutano rivija kiniou bereio, mia kito resinan vio takurano jouro ea kanaku navenatuboiano, ana mia kamiu kuvitutano ea vio na mave loa laka bunu ka mia kuve tubo ka bajulukuti duelimo ba juo na Israel nalo.” ");
INSERT INTO bki_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Naruei Yesu mil ban Saimon Pitere, berinavo “O Saimon, jau monoka kovitikar vatitigso rivu. Sim̃aro tinien jer kamiu ruei, naio jidom toru ka rila bulag kamiu, mia Atua mijamo ka ruei ka mia naio mijikia tokol von kamiu ve telisu, a mijikia tiburelar nana naio bo a nana naio bova. ");
INSERT INTO bki_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mia kiniou nobolkouo kaso ruei, a noju jikili dam̃ariga ea kanaku volkouano ka ver jau kotum̃abe, ana na mia kanamo viekouoiano rijoru nonovio denso re. Ana verenio jau komei kovu bereio, komei bereio, mia jau monoka komei kove toro tai na mia kala kuruamo nalo atumolu atu sikili lie dam̃ariga.” ");
INSERT INTO bki_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mia Pitere naio berdop̃e Yesu berinavo “Tubo, verenio avukuso kavan ea yimo na lakoiano, mia kiniou neviedu rivijaso rivu ga. P̃eli mia ala kikiso mia kam̃aro kario, mia kiniou najaaro ga ka kito ve juo.” ");
INSERT INTO bki_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ana na Yesu berkanio, berinavo “Pitere, kiniou neber telerinio ka jau, ka bogiano nei ga, mia tormano tokoko-reko re vo, mia jau kavarbonbonua kiniou ve varolu, koverinavo jau maka kejikia kiniou leleio.” ");
INSERT INTO bki_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ana na Yesu bika denlo, naio berinavo “Kamiu kuvisidomii von nanua, ka bogo nam̃a nemiila kamiu kubano m̃a kubioliolu janea vio nalo. Kiniou neber ka kamiu ka mia kuvar re kenemiu saba nalo tealo vija kamiu, jibe ka siveu na veru, p̃eli na basaro, p̃eli na kulubue dolu na jaamiu, p̃eli na vite nalo na jibe na. ?Mia jum̃abe, kamiu kumial ka jumemiu bulati ka vite nalo tai?” Naruei nalo aberdop̃e aberinavo “Tubo, maka jumememi ve bulati ka titai.” ");
INSERT INTO bki_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ana na Yesu ber kalo berinavo “Nao, naina naruei. Mia vonganei, kito rojua bogo dolu tenia nei. Vonganei, verenio nana be kiano siveu na veru, p̃eli na kiano basaro, mia monoka naio rivar vija naio rivano. Toro na ver maka kiano iobogu na mira tai, bo ka naio riṽiliṽililar kanio m̃ano saluvoiano, mia naio rivar veru nene rivan rivulu ka kiano iobogu na mira tai. ");
INSERT INTO bki_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kiniou neber naio nei ka kamiu, bior vivitauiano lu nalo re nua nam̃a aberii kiniou, ajum̃a amalmaluvo abe riano naruei, ban bokar iliano nam̃a Aisea naio berenio, napano berinavo ‘Amila ka naio jibe ka naio bunu be toro va tai na lakokoroviano na tuboiano.’ ” ");
INSERT INTO bki_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mia naiagagoano nalo ajum̃a ajidomii ga iliano na iobogu na mira nei, naruei nalo aberinavo “Tubo, kejiio, ninei be kiado iobogu na mira juo nei.” Mia Yesu mial ka napano maka ajikia dulu kiano iliano nei, ana na naio berinavo “E abe, roberii vite na bare naruei.” ");
INSERT INTO bki_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Mia Yesu nalo ajuvan vio nei mave, mia jibe ka napano naio jom̃a milaio, naio miel bavin bokar Suku na Buruolivi Nalo, naio naliko kiano naiagagoano nalo. ");
INSERT INTO bki_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mia bogo napano aba aboru ea vio napano Yesu jo ban eaio, amijilimebi eaio, naruei naio ber kalo berinavo “Kamiu monoka kubolkouo tulaka ka mia jukuano nalo ala re kamiu kuvijoru.” ");
INSERT INTO bki_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Naio ber jibe na kalo, bisi ana na naio juvanlo, ba lie denlo telisu ga, naruei minie ka sudu jaano ana bolkouo ban Atua. ");
INSERT INTO bki_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naio bolkouo jibe nei, berenio “Aiou Teta o-o, ver jau komijikia kala mia rivu ga, jau kodular baja na jogvaiano nei kanaku, ka nomunu re. Mia jau kala re kanaku sidomiano, mia kala ga kiamo.” ");
INSERT INTO bki_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ana ka bogo nei Yesu mijog temiano toru ea naio, naruei amial nailiano tai jaluvo ea vio mave binimei yetano, binimei miija Yesu ka naio ve p̃irinio sikili bereio. ");
INSERT INTO bki_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mia Yesu jo mijog bova toru, jiniomo de sano titi, mia bolkouo jikili lie vo banbano-o mia sano minonoano nalo aju abadigdig jibe ka burukija bavatove ea borotano. ");
INSERT INTO bki_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mia bogo na naio bolkouo bisi, ana na jumolu bereio, ban bereio ea naiagagoano nalo, mia mial tinieiiano na monmeliano muelo ruei, aju amonmelio ga. ");
INSERT INTO bki_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naruei mila bovonlo, berinavo “Ai, jum̃abe ana na kamiu kumitu kumonmelio? Bo kanio kuvitumolu kuvila tibe ka na kiniou naber ka kamiu ruei. Monoka kubolkouo ka mia jukujukuano nalo amei re ka ala kuvijoru.” ");
INSERT INTO bki_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mia bogo na Yesu jom̃a mil banlo kia ga vo, amial burum̃ara taara na tomu nalo amiyoyotuba kalo, amial ka napano toro tai jukamu kalo abinimei vaataro, nina naio napano beamu, naio be nalo tai, be Jutas. Ana na Jutas binimei vaataro ka Yesu, bokario ana miomiom babibiniono. ");
INSERT INTO bki_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mia Yesu mil jukamu banio, berinavo “Jutas, ka vai na koniom kukulnioku jibe na mia naio bo ga, mia ka vaio ana jau kojidom kovulvulu ka kiniou Kulorinio Kenerinio ea m̃arabo na jibe na?” ");
INSERT INTO bki_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mia bogo na nalo na Yesu kiano napano ajikil aju vaataro ka naio abitilubar venia nei Jutas nalo ajidom alaio, abika den Yesu, aberinavo “?Tubo, jum̃abe, mia kito retelo ka kiado iobogu na mira?” ");
INSERT INTO bki_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mia Yesu naio maka riverdop̃elo vo mia naiagagoano nalo tai naio jumolu, burular kiano iobogu na mira, miven ea nalo tai, napano naio be toro tai na parinio toro lu kanano, mia naio jetitire ea ga meriniano ana jelar tiliniene vameruo. ");
INSERT INTO bki_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mia Yesu mil banio, berinavo “!Ee, to to to! Kito rola re bunu tibe na kalo.” Ana na naio mijiou jokol jeleig burutiliniene toro nei, mia mila vatitigio bereio bo. ");
INSERT INTO bki_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Naruei naio bitikar tomu na tortoru na kulo lu nalo naliko tomu na tortoru na menumia nalo na Atua kiano yimo, bija navurim̃araboiano na kulo Ju nalo kialo, napano abinimei ka naio, naio mil banlo berinavo “?Jum̃abe ana na kubar iobogu bija kenemiu nia nalo jibe na? ?P̃eli kumitu kumisidom kuberiam̃a kiniou nebe toro na p̃irinio jikili ka m̃a bina p̃eli nam̃a muemue toro? ");
INSERT INTO bki_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nanua, legiano telabo ga, kiniou nojo bija kamiu ea Yimo Lu banbano-o, mia bior vaio ana maka kumei vaataro ka kiniou ka kuvokar kiniou ea bogo nalo na ruei? Mia nemial jibe ka kamiu kube tomu na melijokouo, napano kubinimei bija moroano dolu nalo na melijokouo, a vonganei be kenemiu aura memedu.” Mo abinimei abokar Yesu, aburio bano. ");
INSERT INTO bki_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bogo na abokar Yesu, aburio ban bereio naliko, abano aba jouro ea burusio na parinio toro lu kanano. Mia Pitere bunu jom̃a jakisosor vavanlo ga ka bogo nei, naio maka riva vaataro keanlo. ");
INSERT INTO bki_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mia bogo na abinimei jouro ea burusio nei, tealo aba ajovokar sebi bilvili ka atuṽalo eaio, mia Pitere bunu ba jotano naliko. ");
INSERT INTO bki_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Naruei aju ana jegliiano na sebi mereralii Pitere mirano, ana na niatira tai nam̃a mim̃au napano jo bijalo, naio bitilubario, ana berenio “!Ai, kamiu kuvialio! Kema na, naio bunu be nalo tai nam̃a bogo nonovio ajakisosor tete na.” ");
INSERT INTO bki_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mia Pitere barbonbonua, berinavo “!Ee maka! Kuvivinieku!, kiniou neber vatitig kaso, maka nejikia kema na!” ");
INSERT INTO bki_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Karina maka vesiou ga, nalo tai mial Pitere, bitilubario, ber “Ai, jau bunu, kobe nalo tai na.” Mia Pitere berdop̃e berinavo “Ai kema, abe makanio.” ");
INSERT INTO bki_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mo aju jibe na bano-o, na aura takurano barlaka bereio, dolu binimei berial bereio, ber m̃elea banlo, berinavo “Kiniou neber vatitig ka kamiu, kema na, naio naliko tete re Kalele na jukamu ruei. !Kuvial, naio bunu be toro Kalele memedu ga ruei!” ");
INSERT INTO bki_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mia Pitere berdop̃e mila sibi bereio berinavo “Kema, abe kiniou maka nejikia tena m̃a kojom̃a koberenio na koig.” Ana monloglog bogo nam̃a Pitere jom̃a ber iliano nei kia ga vo, tu jokokoreko. ");
INSERT INTO bki_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mia bogo na tu jokokoreko, ana Tubo p̃ilig parinio binimei, bitikar Pitere, naio bitii kilkil eaio. Naruei Pitere jidomial bereio Tubo kiano iliano nanua berial kanio nua ruei, napano berenio berinavo “Riano kiniou neber kaso, ka bogiano na legiano nene ga, bogo na tu tokokoreko re vo, mia jau kavarbonbonua kiniou ve varolu ruei, kover jau maka kejikia kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Mia Pitere naio mijog kirivova toru laka, naio batavio, jegi-i o-o mia jegi. ");
INSERT INTO bki_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mo nalo napano ajum̃a abokakar Yesu ea bogo na, amila kikii naio, a amil vulevulei eaio, ajukukikio, ");
INSERT INTO bki_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ban amiorko mirano ka mia naio rijikia re rial vite, mia bogo nam̃a ajum̃a amijuba biliviligio, amiyotel eaio abika denio aberinavo “Ei, aber jau kobe naverialiano tai, bo ga, jau kabagbag von ka kenia na jom̃a mijubaso vonga na.” ");
INSERT INTO bki_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mia amila jibe na ka banbano-o, amil niegeniege toru laka. ");
INSERT INTO bki_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aju jibe na banbano-o m̃erenio bavin garuei, ana na navurim̃ara-boiano na kulo Ju nalo, jibe ka kulo lu na tortoru nalo bija naverloglogiano na tuboiano nalo, abinimei vio takurano ea kialo komeli na toru neibano. Bogo na abinimei vio takurano bisi, ana na aburu Yesu ba jikili ju jukamu ea miralo. ");
INSERT INTO bki_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Naruei amil banio abika denio aberinavo “Verenio jau kobe Naverikariano be riano, nam̃a kulo Ju nalo ajum̃a amial aber mia monoka rimei, mo, numisidom ka jau koverial ka kumemi vonganei.” Mia Yesu berdop̃e banlo, berinavo “Kiniou nemijikia neverial ka kamiu, mia ver neverenio, mia p̃eli kuvisaaro re ka kumonmoneaio. ");
INSERT INTO bki_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mia kiniou nejidom ka nevika vite tai den kamiu bunu, mia ver nevikanio, p̃eli mia kamiu kuverdop̃e kulu re ga na. ");
INSERT INTO bki_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mia be titai nana kiniou najaaro ka nejidom never ka kamiu naio ber jibe nei, ber ‘Jikar vonganei, mia tibe ka ga napano Iliano Lu berenio ruei, napano berinavo mia Kulorinio Kenerinio riva totano mave tivelinio vameruo ka Atua na moroano toru.’ ” ");
INSERT INTO bki_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mia bogo na amijog iliano nei, abika denio, aberinavo “!Tomnei, venia na jibe na! ?Jau kojo kober jau naruei kobe Atua kenerinio memedu?” Ana na Yesu berdop̃elo bere “Verver kuvisidom kuver tibe na, mia tibe na ga naruei.” ");
INSERT INTO bki_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mia bogo na amial Yesu jom̃a mijamo ka ber naio be Atua kenerinio, tiniel kirimimi, aber jibe nei aber “Kema na mil jibe na, kito robitilubar vatitig ka burum̃ara tokoriano joa naio ruei. Mia kito resiravo re bunu toro dolu ka rila veriiano na naio bereio, naio kiano iliano ga jibure naio bereio ruei.” ");
INSERT INTO bki_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ana na nalo na komeli na kulo Ju nalo amijog Yesu kiano iliano bisi, ana ajumormolu, amioburovuronlo ba vio takurano ea burum̃ara taara tai, naruei aburu Yesu ba jumolu jukamu ea Pailat mirano ea kiano vio na tibureiano. ");
INSERT INTO bki_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Naruei amila veriiano ban Pailat, aber bulavulag vite telabo banio, tivelinio ka Yesu. Nalo aberenio aberinavo “Kema na, jom̃a mila bulag tomu na kenememi venuo kialo jidomiano, naio jom̃a berburelo ka avulu re bunu takis van kiamo boru parinio tubo Sisa na Romo, a naio jom̃a miaia naio toru ber naio bar sio na Naverikariano, jibe ka naio be kenememi parinio tubo na toru. Vite nalo na naruei, kumemi numialio ka mirememi memedu.” ");
INSERT INTO bki_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Telikiti na Pailat mijog kialo veriiano nei, naruei naio bika den Yesu, berinavo “Mo, jau kija kover kanamo vonio. ?Be riano ka jau kobe parinio tubo ka kulo Ju nalo p̃eli na makanio?” Ana Yesu berdop̃e, berinavo “Naina naruei jau kojom̃a koberver kiana.” ");
INSERT INTO bki_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mia bogo na Pailat mijog venia napano Yesu berenio, naio maka rial ka naio mila tena bova tai, ana ber ka tomu nalo kialo tomu na tortoru nalo, berinavo “Kema na, ea kanaku vitiiano, naio memedu ga, naio maka rila kor leleio tuboiano tai.” ");
INSERT INTO bki_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mia nalo maka asidom ka ajog Pailat kiano iliano, mia amila jibe ka tena sop̃eli ga tai, ajikili lie vo kanio, aberinavo “P̃eli ga, tete na naio kirivova ga. Naio jom̃a julu vilivilig kenememi tomu nalo kialo jidomiano, a jom̃a mioliolu banlo ea vio nonovio, jikar jo Kalele, binimei midu nonovio Yutea, binimei bokar bulukomeli na toru nei ruei.” ");
INSERT INTO bki_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mia bogo nam̃a Pailat mijog aber Yesu jikar kiano im̃auano yako Kalele, ana bikanio berinavo naio be tete re Kalele memedu p̃eli na makanio. ");
INSERT INTO bki_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pailat bikanio jibe na bior naio maka m̃a to riadu ka tanobuku na Kalele, mia parinio tubo dolu nei Erot naio be toro na toru ka vio na, mila na ka bogo napano aberial ka Pailat ka Yesu naio be toro Kalele, naio berial ber mia monoka avuru naio riva van parinio tubo Erot ka naio rivitii veve vonio bior kiano tanobuku memedu. Ana ka bogo na, Erot bunu binimei miadu ka Yerusalemo ruei, tenene na aburu Yesu ba ban naio. ");
INSERT INTO bki_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mia bogo na parinio tubo Erot bitilubar ka Yesu nene, naio jaaro, bior naio mijog sano tukunu mugaruei, mila na kirisiou ruei naio jidom rialio kija, mila na naio jidom ka vonganei naruei na, p̃eli mia rial Yesu rila kiano kijokijo tai rivanio. ");
INSERT INTO bki_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Naruei naio milavon ka tukunu vija Yesu, bivivika vite telabo denio, mia Yesu maka riverp̃e titai vanio, naio juburu ga jibe na ju, maka lele ril. ");
INSERT INTO bki_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Naruei ka bogo na, kulo lu na tortoru nalo bija naverloglogiano na tuboiano, nalo bunu ajikil aju vaataro ajum̃a amil kilkil ajaam̃i ka m̃a aber bulavulag vite nalo na tivelinio ka Yesu. ");
INSERT INTO bki_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mia vite nalo nei naruei mila Erot naliko kiano tomu na mira nalo maka asaaro ka Yesu, ana amila kikio naio, amiyotel searia naio. Karina, amiya tubo nalo m̃alo kulum̃arauo nalo tai eaio, ka amijikia avital eaio, naruei amila banbano-o, karina Erot miila naio ban bere ea Pailat bitii bereio. ");
INSERT INTO bki_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Beamu ka vite nalo na, tomu juo na Pailat naljuo Erot abe bilbilu va kalo, mia monloglog bogo na amim̃au biju jibe nei bereio ka tibureiano na Yesu, burulo abinimei abe bilbilu bo bereio. ");
INSERT INTO bki_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mia abinimei bere ea Pailat kiano vio, ana naio bio tomu na tortoru na kulo lu nalo bija tubo nalo bija tomu nalo ka amei aialio. ");
INSERT INTO bki_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Telikiti na nalo abinimei joomo, naio mil banlo, berinavo “Nanua na, kamiu na kuburu toro na binimei jikili jua miraku, kuberial ka naio jom̃a bilivilig niegeniege m̃elea kenemiu tomu nalo kialo jidomiano nalo. Mia kiniou nebika vite nalo denio, jibe ka nam̃a kumijogio, mia maka neial ka naio mila vite nalo nam̃a kumitum̃a kuberenio na, nemial jibe ka naio memedu ga. ");
INSERT INTO bki_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naruei nemiila naio ba mial Erot ka rivitiio, mia Erot maka rileal titaio, naruei miila binimei ea kiniou bereio. Mo, kiaku tibureiano jibe nei, ber naio maka rila titai napano naio monoka rim̃aro riviorio. ");
INSERT INTO bki_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mia kiniou nala tibe na ga van naio: mia nala avitiv naio, karina mo atuvan naio rivano, rijikia rivan bereio ea kiano vio.” ");
INSERT INTO bki_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ana na bior bogo na be bogo na kulo Ju nalo kialo jokoluolu na toru, ajum̃a ajidom aber jibe ka nam̃a Pailat jom̃a milala vururu, mia monoka tuvanlar Ju nalo tai nam̃a amiadikakario jua kiano tetavokoiano. ");
INSERT INTO bki_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","19","Ana ka bogo na, nalo tai nam̃a Pailat miadikario, naio kema nei Barabas, napano nanua beamu naio buru tomu dolu nalo amila baravo tai yako Yerusalemo, napano amuebinvin kulo Romo kialo tomu na mira nalo am̃arm̃aro, mila na Pailat miadikario joa kiano tetavokoiano. Mia bogo na amial ka Pailat jidom ka tuvan Yesu rivan bereio tibe na ga, amiaga m̃erere banio, aberinavo “Ei, maka, makanio! Kumemi numisidom kesilar Barabas rimei bereio rivan kumemi. Mia toro na, kumemi nuber kaso ka numisidom jau kodular kiano meuliano ga.” ");
INSERT INTO bki_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mia Pailat maka sidom, naio jidom ka Yesu taluvo ga tibe na bereio, naruei naio milavon ka ril, ber banlo. ");
INSERT INTO bki_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mia abuku deven ga kiano iliano, abiovio kanio, aberinavo “!Kotukukar, kotukukar toa m̃akolkolo!” ");
INSERT INTO bki_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naruei Pailat mil banlo varolu nene, berinavo “?Ana kar venia, naio mila venia napano kirivova? Kiniou nemial vite nonovio ruei, maka neleal vovaiano tai toa nai na memedu ka mia naio rim̃aro riviorio. Mia kiniou nala avitivio ga, karina mia notuvan naio riva vonuo bereio.” ");
INSERT INTO bki_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mia nalo ajuve Pailat kiano iliano bereio, amiaga jouo lie jibe na bereio banio, ajaam̃i lie, aber monoka Yesu rivan ea m̃akolkolo, mia nalo amila jibe na banbano-o na ajovulu naio. ");
INSERT INTO bki_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Karina Pailat mila kiano tibureiano, berial ber naio mijamo ka kialo vikaniano. ");
INSERT INTO bki_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Naio napano m̃a joa nalakoiano bior bajago nam̃a mila mira a bajago nam̃a mue toro, Pailat mijamo ka naio batavio bereio ba banlo jibe ka nam̃a abikanio. Mia tivelinio ka Yesu, naio berial ka mia kiano tomu na mira nalo ala van naio tibe ka ga na kulo Ju nalo ajidomio. ");
INSERT INTO bki_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ana na aburu Yesu, amiel ban ea vio na atukukakar naio toa m̃akolkolo. Bogo na ajum̃a abano, amial toro na ba yeturu karina jo miel binimei vonuo bereio, nina be Saimon na nanua beamu be toro na vio Saireni, naruei ajutua naio ka rudu Yesu kiano m̃akolkolo, mia amidu joa burusovonano, miel jakisor Yesu bano. ");
INSERT INTO bki_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Amiel jibe na bano, a ka bogo na vio bujo ka kulo dolu nalo bunu ajum̃a ajakisor Yesu, na nalo telabo be tire nalo, napano ajum̃a amiel bija burum̃ara tegiano bija burum̃ara tinieiiano. ");
INSERT INTO bki_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mia Yesu jom̃a miagago ka kialo iliano na jogvaiano nei, karina naio barp̃ilig parinio, jiraragidilo, mil banlo, berinavo “Tire re Yerusalemo nalo-o, kuvitig re bunu kiniou tibe na. Ver kuvisidom kuvitig, mia kuvitig kamiu ga, a kenerimiu nalo bunu. ");
INSERT INTO bki_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kiniou neber jibe na ka kamiu, bior bogo na jikili tai mia rimei, ana na mia nalo na mia atua naio mia aver tibe nei averinavo ‘!Ver tire nalo ve re kenerilo ga! Mia rivu lie vo ver avar re tete ka mia m̃a rimunu yu ealo, bior bogo nei mia sikili laka van kito rivija kanado solbouo nalo.’ ");
INSERT INTO bki_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","“Ana mia bogo na rimei rivova laka vanlo, rivan rivan mia atumolu ateg van burusuku nalo vija suku nalo, aver ‘Aiou, kuvitibirbilko kumemi, kuvituba kitkit kumemi, kuvitivinko kumemi.’ ");
INSERT INTO bki_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kamiu monoka kuvitikar rivu, bior vonganei buruiesi memeai kia ga vo ajum̃a amila kilkil ea kiniou ruei, mia iorou ka bogo na buruiesi rimei rijel bisi, mia amijikia ala rivova laka lie vo van kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ana na ka bogo nei, ajum̃a aburukakar tomu juo nam̃a amila kokorovio tuboiano, naruei aburulo naliko Yesu, ka auebinvinlo vijaio. ");
INSERT INTO bki_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Naruei amiel banbano-o, abokar kanano vio, vio tai nam̃a abio ka Bordada na Kulorinio. Ana amidu Yesu ajuku kakario joa m̃akolkolo, abitiri lario jumolu ju iviso, mia ajuku kakario tomu na bova juo neibano, abitiri bulaglo tinene jua Yesu jum̃ano meruo, a tinene jua jum̃ano mali. ");
INSERT INTO bki_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jibe na naruei ana na Yesu jom̃a jaklele ea m̃akolkolo, naruei naio mil ban Atua, berinavo “Aiou Teta, jau koviekokoa nalo nei. Nalo maka avitilubar vatitig vite nei m̃a ajum̃a amilaio nei.” Ana na iorou kanio, ana tomu na mira nalo aju jibe na ajum̃a amila jibe ka nam̃a amiere m̃abujo, ka aleal ka kei kalo na mia rivar Yesu m̃ano kulum̃arauo tai, a kei rivar tai. ");
INSERT INTO bki_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mia kulo dolu nalo ajikil aju ga koalabo, aju ga m̃a abitivitiio, mia kialo natukamuano nalo ajum̃a amil bova ka Yesu, ajum̃a amiyotel va eaio, aberenio “Kumialio kema na! Tomu nalo ajum̃a aber naio milarur tomu dolu nalo miroano ruei, mia vonganei jum̃abe naruei? Aber naio be Atua kiano Naverikariano, p̃eli na naio be toro novo tai napano Atua miilaio binimei. Aver tibe na p̃eli bo ka rilarur kija naio bereio!” ");
INSERT INTO bki_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mia na mira nalo ajum̃a amil niegeniege naio bunu, abinimei amiyuku m̃arjum̃elm̃elu na mijea ban naio ka rimunuio, ");
INSERT INTO bki_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aberinavo “!A verenio jau kobe parinio tubo ka kulo Ju riano, javukia nam̃a aju aberenio, bo ka jau kalarurso vonganei.” ");
INSERT INTO bki_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mia ka bogo na abivitauia tiniemaiano tai, ajuku jo mave ea m̃akolkolo mave ka Yesu parinio, na naio berinavo “Kulo Ju kialo Parinio Tubo.” ");
INSERT INTO bki_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ana na ka bogo nei, naljuo napano ajaklele ea m̃akolkolo bija Yesu amil banio na. Tinene mil kirivova banio, javukia nalo dolu nalo, naio berinavo “?Mia jau kobe Naverikariano, p̃eli na makanio? Bo jau kala sop̃eli, kalarur kito!” ");
INSERT INTO bki_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mia tinene mil banio berbureio, ber “Kaleliki, vonganei be kiado bogo na maariano naruei, mia jau maka kotovon Atua vo. Kito tolu nei tibureiano na amije ban kito be takurano ga, ");
INSERT INTO bki_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","mia tivelinio ka kito juo, memedu ga ka torokoriano nam̃a romilaio, mia tivelinio ka naio, naio maka rila titai leleio.” ");
INSERT INTO bki_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ana na mil ban Yesu, bika denio, berinavo “Yesu, bogo na ver komei kove barago, komei bereio, aiou kovijuku rivu, jau tiniemo ribobogia re kiniou.” ");
INSERT INTO bki_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ana na Yesu berdop̃e banio, berinavo “Kiniou neberkar banso, neber ea legiano na banei ga, mia jau koto vija kiniou ea kiado vio vuiano.” ");
INSERT INTO bki_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mia vonganei, rimei rivokar leri, ana tikar ea bogo na m̃erenio maka bunu merera, mila na melijokouo jovuko reraio vio nonovio garuei, naio jo jibe na bano-o bokar m̃erenio tolu niogoravo. ");
INSERT INTO bki_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ana iorou kanio, ana jagidago napano ajelanio jo joomo ea Atua Kunuano Lu, nam̃a joko vio lu na be lu laka, naio burup̃e mielibievi niati juo. ");
INSERT INTO bki_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mia ea bogo na, Yesu miaga maariano, ber “Teta, kiniou nomidu niunuku joa jum̃amo.” Mia naio miaga jibe na bisi, ana burum̃aria kanano jegi naruei, naio m̃aro. ");
INSERT INTO bki_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ana bogo na toro na toru na mira naio mial vite nei, miolua Atua siano, berinavo “!Riano ga na, kema na naio be toro tai na memedu ga!” ");
INSERT INTO bki_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mia tiniobi na toru napano abinimei vio takurano ea vio nei, nalo bunu amial vite nalo nei napano m̃a amila ka Yesu, tiniel miia naio toru laka na. Avona bisi, ana na abanvan bereio, amiel bija burum̃ara jogvaiano, abano bere ea kialo vonuo nalo. ");
INSERT INTO bki_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mia taara dolu na tomu nalo ajua vio nei ka bogo nene bunu, ajikili aju koalabo kija ga, ajum̃a abitivitii vite nalo. Nina be Yesu kiano bilbilu nalo, naliko tire nalo nanua abinimei ea vio Kalele, ajum̃a ajakilili Yesu banbano-o bokar vio nei, mia nalo bunu amial Yesu kiano m̃ariano. ");
INSERT INTO bki_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Naruei toro tai na komeli na kulo Ju nalo kialo na Arimatea, mia siano be Yoseve. Naio be toro na toru tai na komeli na toru na vio Yerusalemo, be toro na memedu tai napano kiano bajago kirinovo laka. ");
INSERT INTO bki_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Naio tai napano jidom toru ka Atua kiano Navenatuboiano rimei, mia beamu ka napano aber ka mia ala vaio ka Yesu, naio takurano kiano jidomiano maka tibe na, naio milavon ka riverburelo ka ala re rivova kanio. ");
INSERT INTO bki_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Mia bogo na mijogial ka aber Yesu m̃aro ruei, naio ba jikil jukamu ea Pailat mirano, naio bika denio ka ver mijikia rudu Yesu mokotenano. ");
INSERT INTO bki_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ana na Pailat mijamo ka banio, naruei naio ba midular Yesu mokotenano ea m̃akolkolo, naio mijuvuluko ka kulum̃arauo, ana midu ba midu vatitig joa buluvae vou tai napano aje vonga, napano maka adu toro tai rimoneaio vo. ");
INSERT INTO bki_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Naruei legiano na Yesu kiano m̃ariano, naio be Vraire, jibe ka bogo na amiomon vite rorea Legiano Lu. Mia vonganei m̃erenio jo mialolo batove, vaataro ka Legiano Lu tikario, nina monloglog bogo na m̃erenio javin. ");
INSERT INTO bki_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Naruei tire nalo nanua m̃a ajakisor Yesu, jikar Kalele binimei boru ea kiano m̃akolkolo, mia vonganei bogo na amidu mokotenano binimei, ajakisorio bereio. Ajakisor binimei boru ea pakeltavo naruei, amial vio na amidu mokotenano jo mon joomo ea buluvae. ");
INSERT INTO bki_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nalo amialio avona bisi, ana aban bere vonuo ka ala vatitig sano bonotanunu vija pomat. Nalo aboru vonuo ruei, avona bisi ana Legiano Lu jikar naruei, mila na maka bunu ve bogo tai ka avan bereio ka ayovovua Yesu niabene. Mila na nalo aju ga vonuo jibe na, jibe ka nam̃a tuboiano berenio ber monoka nalo ala ea Legiano Lu. ");
INSERT INTO bki_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Legiano Lu barlaka ban kario, ana na viomijeni kanio, naio be legiano na be moti na sude dolu. Mia viomijeni mermeravo kia ga vo, ana na tire nalo nei tealo abar bonotanunu bija pomat nalo na amim̃auka batitiglo ruei, amiel aban bereio ea buluvae ka ayovovua vatitig Yesu niabeno. ");
INSERT INTO bki_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Naruei bogo na abinimei aboru ea vio nene, amial ka burum̃ara puruveru na ajubonko kar ka buluvae, ajubon lario ruei, ");
INSERT INTO bki_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ana na nalo aba joomo, mia amiilo ka napano Yesu mokotenano bakovio tai ruei. ");
INSERT INTO bki_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mia ajikili aju ajidomii dede toru laka-o, mia amiilo ka vaarakurano ga tom juo ajikili aju bijalo. Tom juo nei, m̃alo kulum̃arauo miuvu mia miuvu batitigio bo. ");
INSERT INTO bki_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mila na tire nalo nei amerou ka avitikarlo, naruei aminie ka sudu jaalo, ajak banini tano kamu kalo. Ana naljuo amil banlo, aberinavo “Oi, tire nalo, kamiu maka kuvijikia kuvial toro na meul ea vio na m̃ariano. ");
INSERT INTO bki_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Naio maka toa vio na, Atua bitirilar naio ruei. Kamiu kuvisidomii von bereio, venia naio berial ka kamiu ka bogo na naio jo kamliko nua yako Kalele, maka kumei nei vo. ");
INSERT INTO bki_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Naio ber jibe nei berinavo, jibe ka naio be Kulorinio Kenerinio, mia monoka ajamo ka naio rivan ea tomu na bova jum̃alo, ka mia atukukakar naio toa m̃akolkolo, mia ka bogoti ve tolu nene, mia naio tumolu rimeul bereio. Naina naruei be iliano nanua m̃a naio berenio ka kamiu ruei.” ");
INSERT INTO bki_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mia tire nalo amijog ninei, mila na tiniel maio ka bereio Yesu kiano verikariano, nanua naio ber batitigio bo banlo berinavo mia naio mijikia rimeul bereio. ");
INSERT INTO bki_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tiniel maio ka bereio, ana na ajuvan vio nei, aban bere amial atevi duelimo ba tai bija nalo dolu nalo. Mia vite nalo nam̃a amial ea buluvae, aberiio meravo vatitig bo banlo, ");
INSERT INTO bki_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","mia nalo nei maka amoneaio, amial jibe ka tire nalo nei ajum̃a ajukunu vovu ga. Mia tire nalo na amial vite nalo nei, sialo ajibe nei, Mere re Maktala, Joana, Mere na Yemesi kenieno, bija tire nalo dolu bereio. ");
INSERT INTO bki_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mia Pitere, naio takurano jidom rileal ka tenei naio be riano p̃eli na makanio, naruei naio jumolu, jikiti bano-o jidom rial vonio vajoomo na buluvae nene. Naio binimei boru ea vio nei, monkorkor ba joomo, mia mial Yesu m̃ano kulum̃arauo nalo aju keano ga, mia mokotenano ba kovio tai ruei. Ana na naio batavio bereio miel ba vonuo, naio jo jidomii toru laka ber vite nei naio jum̃abe nei, p̃eli na nioti nene venia. ");
INSERT INTO bki_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana iorou ka ninei bereio, ka legiano nene ga, tom juo kalo ajuvan vio Yerusalemo ka avan ea komeli na telisu tai, siano Emeas. M̃arabo na ban ea vio na maka ve tebievi laka, naio jibe ka sadu duelimo titai, ");
INSERT INTO bki_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ana bogo nam̃a amiel abano, ajukunu toru ka vite nalo na abarlaka ruei. ");
INSERT INTO bki_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ajukunu abano-o, ana na Yesu miel binimei iorou kalo, jo miel nalikolo abano. ");
INSERT INTO bki_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amial naio jom̃a miel bijalo, amialio jibe ka valauo tai ga, bior miralo maka ajikia avitilubar naio. ");
INSERT INTO bki_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ana na Yesu bika denlo, berinavo “?Kube juo kumitum̃a kumiel jibe na, kumitukunu ka venia?” Mia bogo na bika jibe na, amebi ajikili aju ga jibe na, miralo bova kanio. ");
INSERT INTO bki_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Naruei nalo tinene, siano Kleopas, berdop̃e ban Yesu, berinavo “Tomu nalo telabo na vio reraio ajum̃a amiadu ka Yerusalemo ka bogo na, mia p̃eli jau takurano maka kojog burum̃ara vite nalo na amalmaluvo vonganei yako, a?” ");
INSERT INTO bki_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ana Yesu bika ber “?Ana vite venia nalo nam̃a jau kojom̃a koberenio na?” Nalo aberdop̃e, aberinavo “Tenei be tivelinio na tete re Nasarete nei, Yesu. Naio binimei, be naverialiano tai, naio mim̃auka kijokijo telabo ea burum̃ara moroano na kiano, mioliolu berloglog tomu nalo bo laka, mila ajidom naio toru laka, ba bokar bunu ka nam̃a Atua Sop̃i berial ber naio jaaro toru laka ka naio. ");
INSERT INTO bki_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mia karina, nanua viomijeni niovo ga, kulo lu na tortoru bija kiado natukamuano nalo, tiniel jer naio, aburu naio jel ea burum̃ara komeli nalo banbano-o na ajibure naio aber monoka mia rim̃aro, ana aban ajukakar naio joa m̃akolkolo ana m̃aro. ");
INSERT INTO bki_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nanua beamu, kenememi jidomiano joa naio ka mia naio naruei mia rilarur kito kulo Israel, ka mia naio rivuru bulag kito den kulo Romo nalo kialo moroano, mia vonganei vite nonovio ba bova bereio ruei. Naio buro den kumemi banei be kiano bogoti tolu nei naruei. ");
INSERT INTO bki_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Mia be vite tai bereio mila kumemi numiilo m̃ele kanio, mila numitum̃a numisidom bijovijonio ka kia nei vo. Banei ga napano tu tokokoreko ve vaarakurano kia ga vo, kenememi tire nalo tealo ajevijo aban bereio ea buluvae ea vio na amidu Yesu mokotenano mon eaio, aban ka ayovovuaio vatitig rivu. ");
INSERT INTO bki_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mia bogo na aboru ea vio nene, amial ka mokotenano maka bunu toa vio na jo mon eaio, naruei ajikiti abinimei bere ea kumemi, mia maka nina ga, mia aberialio ka amial bunu nailiano naljuo, napano aberial aberinavo Yesu meul bereio ruei. ");
INSERT INTO bki_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ana kumemi tealo ajidom aialio vatitig, naruei aban ea buluvae, amialio javukia napano tire nalo nei aberenio, maka lele aial naio.” ");
INSERT INTO bki_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Naina naruei be iliano napano tom juo neibano aberiio ka Yesu, bogo na ajikili ajua m̃arabo. Naruei naio bunu mil ber kalo, berinavo “Tomnei, kamiu kube bulubau nalo ga. Naverialiano nalo aberial batitig bo vite nalo na kirisiou ruei, mia jum̃abe maka kumonmoneaio vo? ");
INSERT INTO bki_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","P̃eli na kamiu kumijikia ruei, napano mia Atua rivitirilar kiano Naverikariano naio ve toro na toru ea yetemeriba nei. Mia kamiu maka kuvitilubar ka Iliano Lu nalo aju aber mia ala Naverikariano rojog rivova, ala bulag naio beamu, karina mia Atua mijikia vitirilar naio, rivokar kiano burum̃ara mermerano.” ");
INSERT INTO bki_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Naruei Yesu jo jukunu banlo jibe na naruei, berlogloglo ba lie vo. Naio jikar ea Mosis kiano niosi nalo, binimei bokar Naverialiano nalo kialo niosi nalo, naio jom̃a ber bisivisii meravo banlo jum̃abe napano iliano moruo nei jom̃a jiloglog naio ga, p̃eli na ajum̃a aberii dam̃ariga naio. ");
INSERT INTO bki_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Naruei abe tolu amiel aban bereio, mia maka vesiou ana abinimei vaataro ka komeli na tom juo nei aban kalo. Mia nalo amial jibe ka Yesu miel ka riel rijaka, ");
INSERT INTO bki_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mia ajikili kanio ka naio to vijalo beamu vo. Amil banio, aberinavo “Koig vonganei, m̃erenio jo mialolo batove keano, vaataro ka vio rimelijo naruei. Jau komei koto kija vija kumemi beamu, romon ea vio nei ga vo.” Ana na Yesu ba jo naliko ea kialo vio. ");
INSERT INTO bki_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aju bano na monloglog bogo na sinaniano, mo nalo abinimei ajutano vio takurano ea vio na sinaniano. Naruei be bogo na abolkouo ka sinaniano, mia Yesu ga naio jumolu midu salo niajoko, naio bolkouo ban Atua ber siva kanio, naio burekokorovio bar janealo. ");
INSERT INTO bki_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mia bogo na naio mila jibe na, memedu ka bogo na naruei ana miralo jibe ka betavo, abitilubar ka naina jo naliko na, be Yesu nene na. Ana aju amial naio, mia bogo bulati ga, mia naio jaluvo ba kovio denlo bereio. ");
INSERT INTO bki_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Naruei abe juo ajum̃a aberveriio, aberinavo “Ajerei, robe juo garuei maka rovitilubario, mia naio be kiado Tubo nam̃ariga neibano. Mia riano ga, bior bogo nam̃a roju rojukunu bija naio rojakii m̃arabo robinimei, napano naio jom̃a ber bisivisii Iliano Lu nalo ban kito, kiano iliano nalo ajese laka, ajibe ka sebi jo bovago joomo ea kiado iviso.” ");
INSERT INTO bki_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mia bogo na amijikia ka amial Yesu mirano ruei, maka bunu amonmelio, mia ajumolu sop̃eli, amiel ea burum̃ara miamo aban bereio Yerusalemo ka averialio ka nalo dolu nalo. Mia nalo aba amaluvo ka duelimo ba tai napano aju abior vio takurano kia ga vo naliko dolu nalo, ");
INSERT INTO bki_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mia naljuo maka ail vanlo vo, mia nalo aberial kanalo jukamu aberinavo “!Ai, tom juo, abe bogo na ga kubano, titai miyotuba ea vio nei! Iliano napano tire nalo aber beamu, naio be riano ga. Kiado Tubo naio jumolu den nam̃ariano ruei, Pitere nei mialio ka mirano memedu.” ");
INSERT INTO bki_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ana na naljuo nei bunu ajusolio kialo iliano, nalo aberii jum̃abe ka Yesu miyotuba ka naljuo ea m̃arabo, a ka napano maka avitilubar naio, banbano-o bokar ga bogo napano jan ka joko janealo. ");
INSERT INTO bki_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mia bogo nam̃a naljuo nei ajum̃a ajukunu banlo ka vite nalo nei kia ga vo, amiilo va ka napano Yesu jikili ju iviso kalo garuei, naio ber kalo berinavo “Tum̃aro rito vija kamiu.” ");
INSERT INTO bki_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yesu binimei ealo jibe na, mila na ajidomii aberinavo naio be sim̃aro tai, mila na amerou toru laka. ");
INSERT INTO bki_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mia Yesu bitilubar ka amerou kanio, ana naio bika denlo berinavo “!Ai, ka venia kamiu kuvisidomii m̃elea jibe na? Kenemiu iviso veve juo re bunu! ");
INSERT INTO bki_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kuvial vonio jum̃aku vija jaaku, jeleig venia nalo nei jualo! Kam kuvialio, ninei be kiniou ga nei! Kumei kuvitokol veve niabeku torogio nalo nei, bior vite na jibe ka sim̃aro maka ve buruiu, a maka ve niamoiou tibe ka mokotenaku nei.” ");
INSERT INTO bki_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ana naio jom̃a mil banlo jibe na, naio jiloglog jum̃ano bija jaano kalo ka ajikia avitii vevelo. ");
INSERT INTO bki_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ana ka bogo na, naiagagoano nalo, kialo jidomiano jom̃a mim̃au toru jibe na, napano ajaaro toru ka amial aberii Yesu, mia ajidom deio kia ga bunu. Ana Yesu mil bereio, bika denlo berinavo “Ei kamiu kuburosebi ruei?” ");
INSERT INTO bki_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mia nalo amijege niado menoko ju ruei, ana na amidu niatai ban Yesu, ");
INSERT INTO bki_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mia naio midu denlo, naruei kamu ka miralo naio jenio. ");
INSERT INTO bki_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Karina na, Yesu mil banlo, berinavo “Bogo na nanua m̃a nojo kitoliko nua, kiniou nojom̃a neberii iliano miroano ea yati na nonovio na Navivitauiano Lu nalo ban kamiu ruei. Kiniou nobar iliano nalo na ea niosi na Mosis kiano, ea naverialiano nalo kialo niosi nalo, a ea niosi na Iouano lu nalo, naruei kiniou neberial ka iliano nalo na naruei, aberii kiniou ga, mia amei ave riano rivesiou re ga na. Tenene na kiniou neber jibe na ka kamiu, mia vonganei naruei kumial vite nonovio nalo na abinimei be riano ruei ea miremiu nalo.” ");
INSERT INTO bki_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Naruei Yesu jom̃a berlogloglo ba lie vo, mila kialo jidomiano nalo ba toru laka bereio joomo ea Vivitauiano Lu nalo nei, naruei vite nalo nonovio binimei meravo bo kalo. ");
INSERT INTO bki_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Naio ber kalo berinavo “Nina naruei, iliano nalo nei aberii jibe na naruei, ka Naverikariano, mia am̃ele naio rijalele rivano-o mia rim̃aro, mia sano bogoti tolu nene, mia naio tumolu den nam̃ariano rimeul bereio. ");
INSERT INTO bki_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ana iorou kanio, ea siano ga, mia kiano tomu nalo mia atikar to yako Yerusalemo, mia avan ea yetemeriba vodolu, avan aioliolu van taara nonovio na tomu nalo, averial vanlo ka monoka aviliglo ka mia amijikia ajev viekokoano ka kialo vovaiano nalo. ");
INSERT INTO bki_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Naruei kamiu napano m̃a kumial vite nonovio nalo na ka miremiu, kamiu nene naruei kuva kuverialio van tomu dolu nalo ka vite nalo nene be riano. ");
INSERT INTO bki_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Im̃auano nei, naio be im̃auano tai na kirisikili laka, mia kiniou nodu moroano tai toa kamiu ka mia rijai kamiu kuvituvulio. Moroano nei, Teta kiano verikariano naio jo, ka mia naio riila lario sel mave tiniabene rimei rivujo loa ea kamiu, tenene na kiniou nejidom never ka kamiu, ka kamiu kuviel dedade re den komeli nei vo, mia monoka kuvitu rorea ea vio nei beamu vo-oa, ka kuvokario.” ");
INSERT INTO bki_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bogo na ka mia Yesu jidom ka tuvanlo, jukamu kalo abatove ea komeli sesa na Betani. Abinimei abokar vio nene, ajum̃a jibe na, banbano-o na Yesu jumolu jian jum̃ano loalo, milivu kalo. ");
INSERT INTO bki_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Naio jom̃a mioa vatitiglo banbano-o, jo jikar juvanlo bavin mave tiniabene bereio. ");
INSERT INTO bki_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Naruei naiagagoano nalo amial kialo Tubo naio buro denlo bereio, ana na nalo aminie ka sudu jaalo abatove amilotu ka naio, karina aban bere Yerusalemo, napano ajaaro mia ajaaro. ");
INSERT INTO bki_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mia ajua vio na banbano-o ana dam̃ariga ea bogo nalo na volkouano nalo ajum̃a aban ea Atua Kunuano Lu amiaiaio naio. Naina naruei be Lilianiano Vou na Yesu Kristo napano kiniou Luka nebivitauia, maaro ea vio na. ");
INSERT INTO bki_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Beamu beamu, ea burupati, naio nam̃a abio ka Parinio Bajago na Atua kiano bajago naio jo, naio jo bija Atua, a naio, naio be Atua. ");
INSERT INTO bki_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ea bogo na tiiano na vite nonovio, naio bija Atua ruei, ");
INSERT INTO bki_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","naio mim̃auka im̃auano na rim̃auka vite nonovio, maka ve vite tai na naio maka rim̃aukanio. ");
INSERT INTO bki_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Meuliano na be riano maluvo den naio ga, naruei meuliano nei binimei jibe ka yulu na taara nonovio na tomu nalo. ");
INSERT INTO bki_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Naio binimei jibe ka yulu nam̃a mereralii nalo na ajua melijokouo, ana melijokouo neibano naio maka rijikia tovulio. ");
INSERT INTO bki_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Karina, Atua naio miila kanano toro tai binimei ea yetemeriba nei, naina be Jone. ");
INSERT INTO bki_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naio binimei jibe nailiano tai, ka riverial riverinavo toro na yulu nene naio jo binimei, ka rijai tomu nalo nonovio ka ajikia amonea ka toro na naio be Atua kanano yulu. ");
INSERT INTO bki_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jibe na, Jone naio maka rive yulu nene navo, mia naio be toro na verialiano ga. ");
INSERT INTO bki_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mia iorou kanio, toro na yulu nene naio binimei miyotuba ea yetemeriba nei. Naio be yulu napano be riano, napano naio bo laka, naruei binimei ka rudu kanano yulu toa tomu nalo nonovio kanalo meuliano. ");
INSERT INTO bki_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Toro na yulu, naio naruei napano jii yetemeriba nei, mia bogo na binimei eaio, ana tomu nalo na yetemeriba nei maka avitilubario. ");
INSERT INTO bki_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Naio binimei be moti ea kanano tomu nalo kanalo vonuo, mia nalo na ea kanano torogio nei maka asidom naio ga. ");
INSERT INTO bki_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mia tealo ajaaro kanio, amoneaio, naruei ea nalo na abiniu, naio mijamo kalo ka amijikia amei ave Atua kenerinio nalo. ");
INSERT INTO bki_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naio milalo amiyotuba valuo bereio, napano maka tibe ka napano kiritete nalo amiyotuba jakii yati na burukija, p̃eli na jidomiano na tira bija sum̃ano kialo, p̃eli na toro kanano jidomiano, mia amiyotuba bereio jakii jidomiano na Atua kanano. ");
INSERT INTO bki_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tibe na, Parinio Bajago na Atua kiano naio binimei be toro riano, naio binimei jo iviso ka kito, naruei kito romial kanano meuliano na bo nene, naio bujo laka ea bajago na tiniememiano a bajago na ilirianiano. Naio be novo na bo laka be motoru na Karam̃ado kenerinio, naruei kumemi numial kanano burum̃ara mermerano nene, napano be kanano, naio ga takurano. ");
INSERT INTO bki_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mia bogo nam̃a Jone Baruei berii naio nua, naio berinavo “Naina nam̃a kiniou nojom̃a neberii ban kamiu, neber mia naio rimei iorou ka kiniou, naio loa laka, mia kiniou yetano ga, bior ka napano naio meul beamu laka garuei, mia kiniou nebe na vonganei ga.” ");
INSERT INTO bki_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naio bujo ka bajago novnovo nalo, mia bogo nonovio naio jo mila bo toru ban kito, kiano burum̃ara tiniememiano mila kito romijog bo toru bogo nonovio. ");
INSERT INTO bki_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Beamu, Atua bitirilar tormoruo Mosis, ka naio du ga kanano tuboiano binimei ban kanano tomu nalo, mia Yesu Kristo, Atua bitirilar naio ka naio naruei bar bajago na tiniememiano a iliano na ilirianiano binimei ea yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kito kulorinio, maka kito tai napano naio mijikia Atua, a rialio ka mirano, mia toro napano naio jo dam̃ariga ea Atua kanano jidomiano, naljuo aju vio takurano bogo nonovio, naio naruei binimei mila kito remijikia Atua bija kanano bajago novo nalo. ");
INSERT INTO bki_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ana bogo na Jone Baruei naio jom̃a mioliolu banbano-o na, navurim̃araboiano na kulo Ju nalo na vio Yerusalemo aju ajidomii toru aberinavo naio mim̃au jum̃abe na, p̃eli vede naio be Naverikariano, p̃eli naio be kei. Naruei nalo amiila kulo Lu tealo bija tomu na tortoru na yati lu na Livai, naruei nalo abinimei abika denio aberinavo “Jau kobe kei?” ");
INSERT INTO bki_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Naruei telikiti na abikanio, naio ber bulag batitig vite nonovio banlo, naio berdop̃elo berinavo “Makanio, kiniou maka neve Naverikariano nene.” ");
INSERT INTO bki_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ana nalo aberinavo “?Ver tibe na, jau kobe tormoruo Elaija re nua, naruei jau komeul bereio, p̃eli? Nina bior Iliano Lu berenio mia naio monoka rimei bereio beamu ka Naverikariano.” Mia naio berdop̃e bereio, berinavo “Makanio, kiniou maka neve toro nene.” Naruei nalo aberinavo “?Mo, mia vede jau kobe naverialiano nanua m̃a Mosis naio berkario ruei?” Ana bereio naio berdop̃e, berinavo “Makanio.” ");
INSERT INTO bki_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Naruei abika bereio denio aberinavo “?Ana jau kobe kei bere na? Jau monoka kover titai van kumemi ka numijikia nuvan bere nuverialio van nalo napano amiila kumemi nubinimei. Jau kover vatitig ga van kumemi, koverinavo, jau kobe kenia.” ");
INSERT INTO bki_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ana kanano verdop̃eiano na ea bogo nei, naio jibe nei berinavo “Kiniou nebe niono kurano ga ea vio yauo, nam̃a Naverialiano Aisea beriio nua ruei. Kiniou nebe niono napano binimei ka riverial riverinavo ‘Kuvila vatitig rivu m̃arabo nalo na Tubo kanano ea kenemiu meuliano nalo.’ ” ");
INSERT INTO bki_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nalo tai kalo napano ajua bogo na, nalo abe Varisis, ");
INSERT INTO bki_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","naruei nalo abika bere denio, aberinavo “Kumemi numijog jau kober ruei ka jau, maka kove Naverikariano, a maka kove Elaija, a maka kove naverialiano nam̃a Mosis berenio. ?Ver tibe na bior venia ana jau koberenio kobare ka kojom̃a kabaruei m̃ele ea tomu nalo janea vio jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ana Jone berdop̃e banlo, berinavo “Kiniou, varueiano na kiniou nojo namilaiio ban nalo na, naio ea uei ga. Mia toro dolu tai mia naio rimei rudu jeleku, napano naio jo iviso ka kito ruei, mia kamiu maka kuvijikia naio vo. ");
INSERT INTO bki_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Naio loa lie laka ka kiniou, jibe ka napano kiniou maka navare ka nava vaataro ka naio, neiel vijaio, p̃eli neivelar kanano kulubuei.” ");
INSERT INTO bki_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Naruei vio nei naruei napano nalo abano ka aial Jone ea, naina ea tanobuku na vaataro ka komeli na Betani, ea m̃arauei na Yortano tivelinio bano, nina ea vio nam̃a Jone naio jom̃a baruei ea tomu nalo. ");
INSERT INTO bki_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ana legiano dolu nene, Yesu naio miel ba miyotuba ka Jone Baruei bija kumemi naiagagoano nalo kiano ea vio nam̃a numituaio. Ana bogo na Jone mial Yesu, naio berial ka kumemi, naio berinavo “!Mm, kamiu kuvial toro yako naio jom̃a miel binimei kiana! Naio, jibe nunu solbouo na Atua kanano, napano mia naio rivar bulag vironiano na kariano nalo na tomu nalo na yetemeriba nei kialo. ");
INSERT INTO bki_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Naio nam̃a kiniou nojom̃a neberiio ban kamiu nua ruei, neberinavo: Iorou ka kiniou, mia toro na toru tai rimei napano mia tukamu ka kiniou, naio loa laka lie vo bior naio jo jukamu ka kiniou. ");
INSERT INTO bki_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kiniou neber iliano nei beamu, maka nejikia ka mia ve kei, maka nejikia ka naio be kanaku tumano ga na, mia kiniou nemijikia ga ka monoka navaruei ea kito kulo Israel, ka rila ka mia romijikia rovitilubar kiado toro na toru nei.” ");
INSERT INTO bki_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Ana Jone naio ber bisivisii vatitigio ban kumemi jum̃abe ka na naio mijikia ka Yesu naio be Naverikariano. Naio berinavo “Jibe ka nam̃a neber beamu ruei, maka nejikia naio be kei, mia maka vesiou ga, ana Atua mil ban kiniou, naio ber jibe nei, berinavo ver bogo na jau keial kanaku Niununo Lu naio rivatove totano ea toro tai, naina naruei mia naio rivaruei ea tomu nalo ea kanaku Niununo. “Naio ber jibe na ka kiniou, ana bogo na namial Yesu nene, namial napano Niununo juvan vio mave, batove ea naio javukia vaama tai, binimei bujo joa naio. ");
INSERT INTO bki_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bior vite na naruei napano namialio, nemijikia neverialio vatitigio van kamiu, ka be riano ga, toro na naio be Atua Kenerinio memedu.” ");
INSERT INTO bki_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ana ea legiano dolu nene bereio, ana Jone Baruei naio jo keano ea vio nei vo, naio jom̃a jukunu bija kumemi liko Adru, napano ea bogo nene kumemi nube kanano naiagagoano. ");
INSERT INTO bki_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ana numial Yesu jo miel binimei barlaka jel vaataro ka kumemi. Ana Jone berial ban kumemi, berinavo “!Tom juo, kuvial toro yako, naio jibe ka kirikiti nunu na telisu na sida na Atua kanano na!” ");
INSERT INTO bki_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kumemi juo numijog Jone naio ber jibe na, naruei vaarakurano ga nube juo numitumolu, nubano numitakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ana Yesu barp̃ilig naio ka kumemi, berinavo “Tomu juo, kiniou namial jibe ka kam juo kumisidom titai kovio.” Ana nuberdop̃e naio, nubio naio jibe ka kenememi naverloglogiano, ana nuberinavo “?Rapai, jau kobinimei ea vio nei, vio na vabe jau kojom̃a komon eaio?” ");
INSERT INTO bki_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ana naio berinavo “Mo, kamiu kumei, rava kuvialio.” Ana numiel nuba nubokar vio nam̃a Yesu joaio ka bogo na, a jikar ea titai jibe ka m̃erenio veri niogoravo, numitu bija naio, numitukunu banbano-o bokar vio melijo nonovio. ");
INSERT INTO bki_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ana Andru nene napano kumemi juo numijog Jone berii Yesu numitumolu numitakisor naio jibe na, naio be Andru napano naio be Saimon Pitere kuruano na telisu. ");
INSERT INTO bki_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ana Andru nene naio ka takisor Yesu garuei, mia naio ban sop̃eli ka kuruano nei beamu vo, ana bogo na naio mileal naio berii banio, berial Naverikariano, napano kulo Ju nalo abio ea iliano na Ipru aberinavo Misaea, a kulo Kris nalo abio ea iliano na Kris aberenio Kristo. Naio berial kanio, berinavo “Kuruaku, Naverikariano m̃a na, kumemi numileal naio ruei.” ");
INSERT INTO bki_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Berial ka kuruano nei, ana buru binimei ea Yesu. Ana bogo na Yesu mialio, naio berinavo “?O, jau na naruei kobe tormoruo Jone kenerinio dolu nene, siamo Saimon? Mo vonganei kiniou nesisiaso bereio, never siamo Kevas.” Sio nei bunu naio be iliano na Ipru, napano naio ber puruveru, napano ea iliano na vio Kris aberenio Pitere. ");
INSERT INTO bki_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ana ea legiano dolu tai bereio, Yesu jidom rudu kanano m̃arabo bereio, naio jidom rivarkor vio, rivan bere ea kanano tanobuku na vio Kalele. Nubano jibe nei, ana Yesu mial toro tai bereio, berkanio berinavo “Jau komei katakisor kiniou.” Toro nene siano Vilip, ");
INSERT INTO bki_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","napano naio bunu ea komeli na Andru naio Pitere kanalo nei Betsaeta. ");
INSERT INTO bki_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ana maka ve sio, Vilip naio ba jirag kanano bilbilu tai, siano Nataniel, naio ba berkanio, berinavo “Toro na toru nam̃a tormoruo Mosis naliko naverialiano nalo abivitau kakario, aberialio nuanua ruei, naio miyotuba iviso bure kito ruei. Kumemi numileal naio ruei, be toro Nasarete tai, kenerinio tormoruo tai siano Yoseve, ana toro nene, naio siano Yesu.” ");
INSERT INTO bki_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mia bogo na Nataniel mijog ka Yesu naio be na komeli na telisu nei, naio bika berinavo “Ana jum̃abe? Tonovo na toru tai na jibe na naio maka rijikia riyotuba ea komeli na telisu na Nasarete nei!” Ana Vilip berdop̃e, berinavo “Ai, abe jau keil re tibe na, jau komei ga keial naio beamu vo.” ");
INSERT INTO bki_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ana naljuo aban bereio ea Yesu, mia bogo na amiel abinimei vaataro kanio, Yesu mial Nataniel, beriio, berinavo “Lerinio, kiniou namial toro na jibe toro novo na Israel tai memedu na, toro tai napano maka ve sibiano ea naio leleio.” ");
INSERT INTO bki_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mia Nataniel mijog Yesu berii naio jibe na, naio bika berinavo “?Ana jum̃abe jau komijikia ka kiniou nebe toro na jibe na?” Mia Yesu berdop̃e naio berinavo “Bogo na Vilip maka riviedu kaso vo, bogo na jau takurano kojo komijilimebi yetano ea vamelu na buruviki, kiniou namialso ruei kiana.” ");
INSERT INTO bki_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mia Nataniel miilo va ka Yesu kiano jikiaiano, berinavo “!Naverloglogiano, jau kobe Atua kenerinio riano! !Jau kobe parinio tubo na Israel memedu kia na!” ");
INSERT INTO bki_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ana Yesu ber banio, berinavo “!Kiniou neber iliano tai na telisu banso, ka kiniou namialso ea buruviki na, mia vaarakurano ga jau komonea kiniou jikili! Nina naio bo laka, mia neberkar banso ka mia jau kaial vite na iloiano ve telabo bereio, napano nalo tortoru lie todovulu ninei na jau komialio navo. ");
INSERT INTO bki_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nao, kiniou neber memedu, ka mia kamiu kuvial ka vio mave naio rivetavo to, vija nailiano nalo na vio mave na atu amei yetano ea kiniou atu avavin mave bereio, atu avatove bereio avavin tibe na. Vite kinkin nalo na tibe na ana mia kamiu kuvijikia kuvialio bior ka kiniou nebe Kulorinio Kenerinio, jibe napano kiniou tena vio mave, a nebinimei nebe kulorinio riano.” ");
INSERT INTO bki_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mia Yesu nalo abinimei aboru ea tanobuku na Kalele ruei, ana ea legiano tolu nene, jokoluolu na soriano tai ea komeli na Kana. Mia Yesu kenieno naio ba miyotuba ea jokoluolu nene ruei, ");
INSERT INTO bki_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ana iorou kanio amiila toru binimei ka Yesu naliko kanano naiagagoano nalo, abiolo bunu ka amei eaio. ");
INSERT INTO bki_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mia Yesu nalo abano amiyotuba ea jokoluolu, aju naliko tomu nalo banbano-o, mia vite tai bova, uei na amunu ea jokoluolu nei naio biniu sop̃eli. Ana Yesu kenieno binimei berialio ban Yesu, naio berinavo “Munuiano na toro na toru na jokoluolu mila batitigio, amunu koko kanio, biniu ruei vio be teau, amila de batitigio garuei.” ");
INSERT INTO bki_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ana Yesu berdop̃e, mil banio berinavo “?Tiramoruo, venia na im̃auano na naio joa kiniou? Jau kodu re toa jum̃aku, bior kanaku bogo na nala vite nalo na jibe na, naio maka vo.” ");
INSERT INTO bki_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kenieno naio mijog venia napano Yesu berenio, mia naio ber ka tomu na im̃auano na jokoluolu nei, berinavo “Venia na mia naio river ka kamiu ka kuvilaio, mia kamiu kuvil re, kuvilaiio ga.” ");
INSERT INTO bki_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ana Yesu mial burum̃ara basi-dobidobi na uei tai aju vaataro, nam̃a kulo Ju nalo abar ka m̃a ajekon ka vite nalo jibe ka na kanalo nalotuano naio berenio. Burum̃ara basidobidobi nalo nei amim̃auka ea puruveru, abe verare ka sadu toromomou takurano janealo, basidobidobi nene nalo biniu be ari. ");
INSERT INTO bki_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ana naio ber kalo berinavo “Kamiu kuva kuviov uei, ana kuvar kumei kuvioionio rivan ea basidobidobi nalo nei rivano-o avuvujo magmago.” Naruei nalo amila banbano-o na amisono batitiglo abujovujo. ");
INSERT INTO bki_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ana Yesu naio berenio berinavo “Mo, vonganei kuviov ve telisu eaio, ana kuvar va van toro na toru na jokoluolu nei ka naio rijikia rimunu vonvonio.” Naruei nalo abiovio, abar ba ban naio. ");
INSERT INTO bki_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Naruei toro na toru nei naio munu vonvonio, mijog jibe ka binimei be m̃arjum̃elm̃elu ruei, mia naio miilo toru kanio, naio maka rijikia ka amileal munuiano nei ea vio na vabe. Mia nalo ga napano abiovio, amijikia, mia maka aver kanio, mia naio bio toro na joro vonga binimei mial naio. ");
INSERT INTO bki_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Toro nene naio binimei, ana toro na toru nei berkanio, berinavo “Ea jokoluolu dolu nalo, ajum̃a abiov m̃arjum̃elm̃elu nana bo naio binimei jukamu, mia bogo na tomu nalo amunu kija banbano-o, karina abiov vonga m̃arjum̃elm̃elu na maka rivu laka binimei iorou. Mia ea jokoluolu nei ajum̃a amunu uei banbano-o, karina jau kobiov vonga m̃aku m̃arjum̃elm̃elu napano naio bo laka, naio binimei maariano garuei. Ka venia komila jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Vite nei nam̃a Yesu naio mila ea bulukomeli na Kenan ea vio Kalele, naio jibe ka burum̃ara vremesiano tai, be kiano vremesiano na be moti napano milaio. Naio mila jibe ka na naio jo jikar jo jiloglog kanano moroano na vio mave, mia bogo na naiagagoano nalo amialio, kanalo moneano na ea naio, ka naio be Naverikariano na be riano, binimei bavin lie vo. ");
INSERT INTO bki_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bisi naruei ana nalo abiniu aban bere ea Kapeneam bereio, nina be Yesu, kenieno, a kuruano nalo, bija kanano naiagagoano nalo, abinimei abokar vio nei ana aju kija jibe na ba bokar legiano nalo tai. ");
INSERT INTO bki_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mia bogo tai, vaataro ka bogo na kulo Ju nalo ala kanalo jokoluolu na toru, Jukoluolu na Sidomkariano na Ioruriano. Ana kanalo bajago tai, ber yuka nonovio nalo nonovio monoka ala vonio ka avavin Yerusalemo monloglog bogo ka ala jokoluolu nei, ka sidomkariano na korobilo nalo ajaluvo den Ijivi, ana ka bogo nei, Yesu bunu naio bavin. ");
INSERT INTO bki_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naio ba bokar vio nene, ana ba miyotuba ea Atua kanano Yimo Lu, mia naio mial ka napano nalo telabo aju napano ajum̃a ap̃ilṽili ka buluku, nunu, bija menu nalo, mia naio mial nalo nam̃a amijebukua veru dolu nalo binimei be veru na memedu na Atua kanano Yimo Lu. Im̃auano nalo nene abe im̃auano na bo tai, bior abe im̃auano na ap̃ilṽili ka vite na tomu nalo monoka avulu ka ala sida kanio, mia titai bova, nalo aju amijukubin tomu nalo toru, mia mave kanio, nalo aju amilaio jouro ea burusio na vio lu. ");
INSERT INTO bki_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ana Yesu naio mial ka nam̃a amila niegeniege dolu ga yimo lu nene jibe na, naruei naio tinien mimi, bar teli nalo, buru vuronlo jibe na, ana banku kalo. Naio ba jibe na, naio ba mijil dedade ealo bija kanalo nunu a buluku nalo abava tavio den Atua kanano Yimo Lu, mia ea tivelinio na nalo nam̃a aju amijebukua veru, naio ba miyon bulag kanalo basaro na puruveru nalo, naio bilig bulag kialo barobaro nalo bijaio. ");
INSERT INTO bki_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nalo nam̃a aju ap̃ilṽili ka menu nalo, naio mil banlo berinavo “!A, kuvar bulag kenemiu saba nalo na ea vio na! !Kamiu kuvila re karam̃aku kunuano nei rimei ve kenemiu yimo tai na kuvokar veru eaio tibe na!” ");
INSERT INTO bki_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ana bogo na kanano naiagagoano nalo amial Yesu naio mijil dedade ealo jibe na, mila na nalo tiniel maio ka vivitauiano lu tai bereio, jibe ka na naio berii Naverikariano beamu ruei, napano berenio berinavo “Kanaku jidomiano temi laka ea kanamo yimo lu, naio jibe ka sebi tai bovago ea kanaku iviso.” ");
INSERT INTO bki_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mia ka tenei, tomu na tortoru na kulo Ju nalo, nalo bunu amial venia napano Yesu milaio, naruei nalo abika denio, aberinavo “Venia napano jau komilaio vonga na, naio be burum̃ara vite tai. ?Mia jau na komijikia kala vremesiano na vabe ea mirememi, ka rila kumemi nuvijikia nuvial ka naio rimemedu ka jau kala tibe na?” ");
INSERT INTO bki_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ana Yesu berdop̃e banlo, naio berinavo “Mo, kanaku vremesiano naio jibe nei: kamiu kuvue bulag Yimo Lu na, avona iorou kanio, ea legiano ve tolu ga, mia kiniou nevitiri lario bereio.” ");
INSERT INTO bki_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ana nalo aberinavo “Nalo nam̃a amim̃auka yimo na, amim̃auka ba bokar yuka duelimo va veri ba ari 46, mia jum̃abe ana jau kober jibe na, kober komijikia kovitiri lario bereio ka legiano ve tolu ga? !Maka leleio rijikia tibe na!” ");
INSERT INTO bki_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nalo amil jibe na, a nina bior nalo maka ajikia vatitig rivu venia nam̃a Yesu naio berii ea bogo na. Nalo maka avitilubar ka bogo na naio jom̃a berii Atua kunuano na, nioti nene jibe ka mokotenano. ");
INSERT INTO bki_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ana iorou laka garuei, iorou ka na naio jumolu bere den m̃ariano, kanano naiagagoano nalo ajidomialio bereio ka naio ber iliano nei banlo, ana mila na amonea lie vivitauiano lu nalo bija Yesu kanano iliano nalo banlo. ");
INSERT INTO bki_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Naruei Yesu nalo ajua jokoluolu na ea Yerusalemo banbano-o na, naio jom̃a mila vremesiano telabo, mia bogo na tomu nalo amialio, nalo telabo amoneaio ka naio be Naveri-kariano. ");
INSERT INTO bki_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mia Yesu maka to rijamo ka naio laka vanlo, naio maka to rivarkar tiniene m̃ele ealo, bior naio mijikia batitiglo. ");
INSERT INTO bki_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Toro dolu tai rijikia re river titai van Yesu ea tivelinio na toro kanano bajago, bior naio mijikia vatitigio ruei, naio mijikia vite nonovio napano aju joomo ea toro kanano jidomiano. ");
INSERT INTO bki_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ana ka bogo tai bereio, ka bogiano tai, kulo Israel nalo kanalo navurim̃araboiano tai naio binimei ka jidom rial Yesu. Toro nene naio be Varisis nalo tai, siano Nikotimas. Mia naio binimei, naio mil bija Yesu naio berinavo “Naverloglogiano, kumemi numialso, nubitilubar ka jau kobe naverloglogiano tai napano jau kobinimei ea Atua, bior maka ve toro tai napano mijikia rila kijokijo nam̃a jau kojom̃a komilaio, ver Atua to re vija.” ");
INSERT INTO bki_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ana Yesu berdop̃e banio, berinavo “Ee, burutomoluo nalo na bo, a monokanio never ve riano bo vanso, toro na maka sidom rimoluo bereio ve terivou, mia Atua naio maka rijikia rive tubo ea kiano meuliano.” ");
INSERT INTO bki_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mia Nikotimas naio miilo ka iliano nei, ana berinavo “!Tomnei! ?Mia toro na be tormoruo ruei naio mijikia rimoluo bere tum̃abe? Kiniou maka ve tinieku ka mia naio mijikia riva joomo bereio ea kenieno mabono, ka mia naio rimoluo ve vaarakurano bereio.” ");
INSERT INTO bki_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ana Yesu berdop̃e berinavo “Kiniou neber riano banso, ka toro monoka riyotuba ea uei, a monoka riyotuba ea Niununo. Ver p̃eli, mia naio maka rijikia riva jouro ea Atua kanano navenatuboiano. ");
INSERT INTO bki_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Toro naio mijikia rivar bereio toro ga, mia Atua kanano Niununo naio mijikia rivar bereio niununo vou ea toro kanano meuliano. ");
INSERT INTO bki_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Naina naruei be yotubaiano valuo nam̃a kiniou nojo neber kaso. Tibe na, jau keiilo re bunu ka kiniou neber kaso ka jau monoka komoluo bereio. ");
INSERT INTO bki_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Kosidomii von jegi. Jeg naio jom̃a miuvuvu, naio jo janea vio jibe ka ga na naio jidom, p̃eli na kito roju romijogio, mia kito maka rejikia ka naio jo binimei jum̃abe, p̃eli na naio jo ba be. Mia m̃arabo na Niununo naio rim̃au ea toro kanano meuliano jibe na naruei, naio jibe ka jegi.” ");
INSERT INTO bki_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mia Nikotimas naio jidomii bijon iliano nei toru laka, ana bika berinavo “?Tomnei, mia vite na naio mia tum̃abe na?” ");
INSERT INTO bki_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ana Yesu berdop̃e banio, berinavo “Jau kobe naverloglogiano na toru tai na kulo Israel kialo ruei, mia kiniou nemial jibe ka vite nalo nam̃a kiniou nojom̃a neber bisivisiio banso na, jau maka lele kejikia vo, a! ");
INSERT INTO bki_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kaiagago rivu! Javukia nam̃a naverialiano nalo amilaiio beamu ruei, kiniou nojom̃a neberial ga venia na m̃a kiniou nemijikiaio, p̃eli na venia na m̃a kiniou namialio, mia tibe na dam̃ariga, kamiu tomu nalo na vio Israel kamiu maka kuvisidom kuvisov kenememi iliano nalo. ");
INSERT INTO bki_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kiniou nojo neberii saba nalo na yetemeriba nei ban kamiu, mia maka kuvisidom kumonmoneaio, mia ver neverii saba nalo na vio mave, mia kamiu kuvijikia kumonmoneaio tum̃abe? Kiniou namial ka mia ve deio ga. ");
INSERT INTO bki_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mia kiniou Kulorinio Kenerinio, kiniou ve takurano ga nemijikia neverloglog kamiu ka na vio mave, bior ka napano maka ve toro dolu tai riva rial vio nene, mia kiniou ga Kulorinio Kenerinio najaluvo den naio nebinimei yetano ruei, a iorou, mia navan bere eaio. ");
INSERT INTO bki_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Beamu beamu tormoruo Mosis nalo ajua vio yauo, maro nalo ajum̃a ajer binvinlo, mia naio bitirilar iesi tai, midu butoto maro jo mave, ana kei kalo napano maro jerlo, mia ver sirarago ga vitikar maro na jo mave, mia Atua rilarurlo. Ana ea m̃arabo nene kia ga, mia monoka adu kiniou Kulorinio Kenerinio bunu noto mave ea iesi tai. ");
INSERT INTO bki_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Naruei toro kei na rimonea kiniou, mia naio rivokar meuliano vou nei napano naio maka ve jukuti nene.” ");
INSERT INTO bki_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yesu ber jibe na bior Atua tinien jii tomu nalo na yetemeriba nei toru laka, naruei naio mijamo ka kenerinio na kirinovo laka, napano naio ga takurano be kanano, binimei m̃aro kar kito, naruei toro kei napano rimonea naio, mia maka rijikia riva kovio, mia rivokar meuliano na bo nei napano maka rijikia ribisi bogo tai. ");
INSERT INTO bki_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","?Ana bior vaio Atua miila kenerinio nei binimei yetano ea yetemeriba nei? Maka riilaio rimei ka tibure tomu nalo na yetemeriba nei, mia miilaio binimei ka rijamo ka kanano meuliano ka rilarur kito. ");
INSERT INTO bki_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Toro kei napano rimonea kenerinio nei ve riano, mia Atua tibure re naio, mia toro na maka rimoneaio, vironiano joa naio ruei, bior naio maka rimonea Atua kenerinio. ");
INSERT INTO bki_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","?Ana vironiano nei napano mia Atua naio monoka rilaio, burupati nene be venia? Naina bior napano naio miila kanano yulu binimei ea yetemeriba nei, mia tomu nalo ajum̃a amila kikiio ga banbano-o na, maka asaaro kanio, mia ajidom ga bajago na bova tena melijokouo. ");
INSERT INTO bki_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mia nalo nonovio nam̃a aju amila bova jibe na, jibe ka napano maka asidom yulu nei leleio, a maka asidom amei vaataro kanio, bior amerou ka aberinavo vede mia naio rila kanalo vovaiano nalo ayoyotuba ea vio medave, naruei tomu nalo ajikia avitilubario. ");
INSERT INTO bki_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mia nalo nam̃a amim̃au ea bajago na bo a memedu, nalo maka amerou ka toro na yulu nei, a nalo abinimei vaataro kanio. Nalo ajaaro kanio, bior yulu nene naio rila meravo vatitig ka vite nalo nam̃a amilaio, nalo amim̃auka amonmonea ga jidomiano na Atua kanano.” ");
INSERT INTO bki_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ana iorou ka vite nalo nei, Yesu buru kanano naiagagoano nalo ajuvan vio Yerusalemo abatavio ea tanobuku na vio Yutea. Nalo aju jibe na, naruei ajum̃a abaruei ea tomu nalo. ");
INSERT INTO bki_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ana ka bogo nene nei ga Jone Baruei bunu naio joa vio dolu tai, siano Aenon, vaataro ka vio na Salim. Naio binimei ea vio na bior uei tai joaio, mia tomu nalo na aju abinimei ka naio, naio jom̃a baruei ealo ea marauei nene. ");
INSERT INTO bki_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nina ea bogo na nalo maka avokar naio, a maka avuku naio riva joomo ea yimo na lakoiano vo. ");
INSERT INTO bki_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Naruei ka bogo na Jone kanano naiagagoano nalo amila iliano tai bija toro Ju dolu tai, ea tivelinio ka m̃arabo na sekon vite nalo jibe ka kanalo nalotuano berenio, ana ea tivelinio na bunu varueiano nalo napano Jone bija Yesu kialo. ");
INSERT INTO bki_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aberii banbano-o karina abinimei amial Jone, abika denio, aberinavo “Naverloglogiano, kumemi numisidom nuvika denso ea tivelinio na toro na Yesu napano beamu, bogo na kito rojua marauei na Yortano tivelinio bano, naio binimei mialso, naruei jau koberial saba telaboiio naio. Vonganei, naio bunu binimei jo baruei ea tomu nalo, mila abiniu aju ajuvarvan kito aban ea naio ga, vio bujo mia vio bujo.” ");
INSERT INTO bki_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ana bogo nam̃a aber jibe na ka Jone, naio maka rijoku, maka rijog rivova, mia naio jaaro ga, berinavo “Kito tomu nalo nonovio monoka roim̃auka ga venia napano Atua naio midu jua jum̃ado. ");
INSERT INTO bki_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Javukia napano kamiu kumijikia batitigio ruei, nam̃a kiniou nojom̃a neberial julaka ga, ka kanaku im̃auano, kiniou maka neve Naverikariano, mia nebinimei beamu ka naio ga, ka neverial ka naio jo binimei ruei. ");
INSERT INTO bki_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ana vonganei jibe ka nam̃a kamiu kuberialio ban kiniou, naio binimei jo mila kanano im̃auano ruei, ana vite nei najaaro kanio, namialio bo laka. “Naio jibe ka bogo na soriano, napano naio jibe nei. Ver toro na naio soro, kanano bilbilu tai, naio riija naio ve toru ka aiomon saba nonovio na jokoluolu, mia karina, ea legiano nene, bogo na avuru tira rimei, tira nei naio maka riva totano vija naio mia naio ba jotano bija koano ga. Mia naio maka rijog vova, kanano saariano naio bare ka toro na soriano kanano. A vonganei kiniou bunu najaaro jibe na, napano kanaku naiagagoano nalo aju ajakisor Yesu. ");
INSERT INTO bki_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nina bior Tubo Naverikariano naio monoka to rimei ve toru lie tibe na tulaka, kiniou monoka nomei nove telisu lie vo.” ");
INSERT INTO bki_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ana Jone Baruei naio berii Naverikariano, berinavo “Naio be na vio mave, naruei naio mave loa vite nonovio. Kito romiyotuba ea vio yetano nei, kito robe na yetemeriba nei ga ana romijikia roverii vite nalo na vio nei ga. Mia naio, jibe ka nam̃a kiniou neberenio, naio jaluvo ea vio mave binimei yetano, naio loa lie ka tomu nonovio, ");
INSERT INTO bki_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","napano naio binimei jom̃a berial vite nalo nam̃a naio mialio beamu ea vio mave, a vite nalo nam̃a naio mijogio. Naio berial vite nalo na, mia tomu nalo maka asidom kanano iliano, maka amoneaio. ");
INSERT INTO bki_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Telabo na maka amoneaio, mia kito nam̃a kito romoneaio, kanado moneano naio jekar batitigio ka Atua, kanano iliano nalo be riano, a amemedu batitigio bo ga. ");
INSERT INTO bki_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kanano iliano nene nalo, naio miila Naverikariano naio binimei berial ban kito ruei, ana romijikia ka iliano nalo nei abe riano. Nina bior bogo na Naverikariano binimei, kito romial ka napano naio mil ea moroano na Niununo na Atua kanano, bior Atua jian kanano Niununo banio, maka ve torogio ga, mia momonio garuei. ");
INSERT INTO bki_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Karam̃ano Atua nene naio tinien jii kenerinio nene nei naio toru laka, naruei naio bar vite nonovio jua jum̃ano. ");
INSERT INTO bki_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Tibe na, kito napano romonea naio, robokar ruei meuliano nei napano naio to tobo to. Mia toro napano maka m̃a rimonmonea naio, mia naio rijikia re rial meuliano nei bogo tai, mia Atua kanano tiniemimiano ve toru toa naio.” ");
INSERT INTO bki_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ana ka bogo na, iliano jo jeliviv, ber Yesu jom̃a buru naiagagoano telabo abinimei ajakisor naio, a jom̃a baruei ealo. A maka ve Yesu nam̃a naio baruei ealo, mia kumemi kanano naiagagoano nalo ga numitum̃a numilaio, mia tomu nalo amialio ka nalo napano Yesu kanano aju abinimei miroano, jovulu Jone Baruei kanano. Naruei nalo ajum̃a aberver iliano nei ba janea vio jibe na, ba bokar Varisis nalo, mia bogo na Yesu mijogio ka nalo bunu amijikia vite nei a mila nalo amijog bova biorio, ");
INSERT INTO bki_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","naio mial bo ka tuvan vio Yutea, naio rivatove bereio Kalele. Naruei kumemi numituvan vio nei, nubano jibe na, ");
INSERT INTO bki_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","mia Atua jiloglog ka kenememi m̃arabo monoka va sel ea tanobuku na Sameria. ");
INSERT INTO bki_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Naruei kumemi numitu numiel nubano, numalmaluvo ea komeli na vio na tai, siano Saika. Vaataro ka komeli nene, be bulukuei tai jo, napano jikar nuanua ruei, jo binimei jibe na, abio ka Yakovo m̃ano uei. Borotano nene, beamu be tormoruo Yakovo kanano, ana iorou kanio ana mijamo ka ban kenerinio Yoseve. Naruei kumemi liko Yesu numiel nubinimei nuboru ea uei nene, be bogo niogoravo memedu, naruei Yesu mijog tinien maro laka bior burutili ieliano ea burutinianio na jikili, ana naio ba jotano mave ea tagvoru na bulukuei nene. ");
INSERT INTO bki_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Numitua uei nene bano-o, bisi ana na kumemi naiagagoano nalo numitumolu nubano ea komeli ka nuvulu simemi sinaniano, mia Yesu naio ga takurano jo mijilimebi. Mo iorou kanio tira re Sameria tai naio miel binimei ka jidom riviov uei. Naio binimei ana Yesu bika denio berenio “?Aiou, jau komijikia koviov m̃aku uei tai?” ");
INSERT INTO bki_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ana tira nene, naio maka rijikia Yesu, mia bitilubar ka naio be toro Ju tai, mia miilo toru laka ka napano naio mil batitigio bo ban naio jibe na, bior ka bogo na, kulo Ju nalo bija kulo Sameria nalo abe bilbilu va maka avior kalo. Ana tira nei naio bika den Yesu, naio berinavo “?Jum̃abe na jau, kobe toro Ju, komil ban kiniou tira na Sameria, na jau kobika uei den kiniou?” ");
INSERT INTO bki_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Naruei ana Yesu naio berdop̃e berinavo “!Tira, verver jau komijikia ga ijaiano na bo napano Atua naio jidom sian vanso! !Verver jau komijikia ga ka kiniou nebe kei nei ga nam̃a nebika uei denso! Ver tibe na, vede maka ve kiniou na nebika uei denso, ana mia jau kovika uei den kiniou. Mia bogo na ver jau kovika uei den kiniou, nemijikia nesian uei na be uei na ridu meuliano vanso.” ");
INSERT INTO bki_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naruei tira nei naio mijog vite na, naio bika den Yesu, berinavo “Toro na toru, jau maka ve kanamo titai ka jau koviov ka uei nene, mia bulukuei nene naio bululuo batove laka. Tibe na, uei na meuliano nam̃a jau kojom̃a koberenio na, mia jau koviovio tum̃abe, p̃eli na mia jau koviovio ea vio be? ");
INSERT INTO bki_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mia jau kojom̃a kober uei na dolu na, mia ninei jo nei naio be uei na bo tai. Korobido tormoruo nanua na Yakovo, naio kanano uei nei. Naio munu bano-o, naliko kenerinio nalo, bija kanalo temeul nalo, naruei amila lilian binimei binimei bokar banei. ?Jau kober jau kobo loa tormoruo Yakovo ana komijikia kala uei tai na bo loa ninei?” ");
INSERT INTO bki_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ana na Yesu berdop̃e banio berinavo “Nao, uei nei naio bo, ana mia bogo na kito romunuio, mia maka vesiou ana midoujer kito bereio. ");
INSERT INTO bki_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mia toro na naio rimunu uei nei napano nemijikia nesianio vanio, karina mia naio maka rijikia midouser naio bereio. Mia uei napano naio rimunuio, mia rimei tibe ka burupati uei bereio joomo ea kiano iviso, ve uei na meuliano napano maka ve togio eaio, naio jom̃a mieraro den naio dam̃ariga, maka rijikia tabo bogo tai.” ");
INSERT INTO bki_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mia tira nei, naio maka rijikia vatitig vo Yesu kanano iliano, naruei naio berinavo “Toro na toru, ver tibe na, bo ka jau kodu uei na ve telisu van kiniou ka nomunuio, mia nomidou re bunu, ka mia nemei re bunu noviov uei tulaka ea vio nei.” ");
INSERT INTO bki_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ana Yesu jidom ka tira nei naio jikia ka naio be kei, a berkanio, berinavo “Kiniou never titai ka jau beamu vo. Jau kavan bereio, jau kovio koamo kovuru naio rimei bere ea vio nei.” ");
INSERT INTO bki_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ana tira nei berinavo “Ee, maka ve koaku tai!” Ana Yesu berkanio, berinavo “Rian ga na, jau kober memedu na, ka jau maka ve koamo tai. ");
INSERT INTO bki_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nina bior ka tomu nalo na kojoru kalo beamu ruei napano abiniu abokar jimo, mia vonganei kojo bija toro tai bereio napano maka kosoro kanio. Jibe na na kanamo iliano be riano na, jau maka ve koamo tai.” ");
INSERT INTO bki_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mia tira nei naio miilo toru laka ka napano Yesu mijikia batitig kiano meuliano jibe na, ana berinavo “Rian ga na, toro na toru. Vonganei kiniou nemijikia naruei, ka jau kobe naverialiano tai. ");
INSERT INTO bki_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naio bo laka kiana, mia p̃eli jau kobe kulo Ju nalo kanalo naverialiano ga na. Mia kumemi kulo Sameria, kenememi vio lu naio napano be burum̃ara burusuku yako Kerasim, napano korobimemi nalo amila lotuano na Atua eaio nua ruei, binimei bokar banei. Mia kamiu kulo Ju nalo, kumitu kumisikili ka kenemiu burum̃ara komeli lu na Yerusalemo, naio ga takurano be vio na memedu ka m̃a amila lotuano ban Atua. Tibe na, kei naio memedu, kamiu p̃eli na kumemi? Kover vonio!” ");
INSERT INTO bki_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Mia Yesu jaaro ka rivuriri tira nei kanano jidomiano ea tivelinio na bajago na memedu na amila lotuano ban Atua, ana berkanio, berinavo “Nao kuvivinieku, jau kober be riano na, kiado lotuano kito juo naio maka rive verare. Mia nina maka rivior vio na amila lotuano ave juo, mia bior vite napano jibe na: Kamiu na ea vio na, kamiu kumitum̃a kumila lotuano, mia kamiu maka kuvijikia batitigio naio napano kamiu kumilotu banio, mia kumemi kulo Ju, Atua naio bijauialar kumemi ka toro na rilarur tomu nalo naio miyotuba ea kenememi torogio. Naruei kumemi numijikia batitig kenememi Atua nei napano m̃a kumemi numitum̃a numilotu kanio. “Mia kiniou nemijikia never kaso ka mia tibe na re tulaka. Mia jau monoka komonea kiniou, napano neber kaso vonganei ka bogo tai jo binimei napano mia lotuano vou tai tikario, napano ve kanado roviniu. Toro Ju p̃eli na toro Sameria, mia residomial re bunu ka vio na memedu ka rolotu ka Atua naio be suku na, p̃eli na komeli na Yerusalemo, p̃eli na vio be bereio. ");
INSERT INTO bki_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mia burum̃ara vite na mia residom, naio jibe nei, ber bogo na kolotu ka Atua, mia monoka kotuvan Niununo Lu rim̃au ea niunumo, a monoka kolotu ka naio ve riano, memedu ka kiano ilirianiano. “Nina napano Atua Teta naio jidomio, ana vonganei ruei a ea bogo na jo binimei, mia naio rivitikar kanano taara na lotuano riano, napano amijikia alotu ka naio ea bajago novo na jibe na. ");
INSERT INTO bki_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Atua naio be niununo, naruei toro na jidom rilotu kanio monoka rilotu ka naio ea kanano iviso, a vite nei naio monoka rive riano ea kanano meuliano.” ");
INSERT INTO bki_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ana tira nei, naio jo monea ka mia Naverikariano naio rimei, naio napano iliano na vio Kris naio ber Kristo, naruei naio ber ka Yesu, berinavo “Vite nalo nei na jau kojom̃a koberenio, vede abe riano, mia kiniou nomonea ka Naverikariano napano mia naio rimei, mia naio naruei riverial vite nonovio ve riano vatitigio van kumemi.” ");
INSERT INTO bki_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Naruei Yesu ber iliano telisu nei ga banio, berinavo “Naio nam̃a jau kojom̃a koberenio, kiniou nene nei ga nei, nam̃a nojo nojukunu bijaso vonganei.” ");
INSERT INTO bki_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naio berial naio ban tira nei jibe na bisi, ana naiagagoano nalo abinimei aboru ea vio nene bereio. Naruei amialio ka napano Yesu jom̃a jukunu bija tira nei, jibe ka naljuo nei ga, naruei nalo amiilo kanio. Nalo amiilo, mia nalo aju buru ga, maka ve nalo tai kalo napano naio rivika den tira nei ka naio jidom venia, p̃eli na rivika den Yesu river naljuo ajum̃a ajukunu ka venia. ");
INSERT INTO bki_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mo tira nei jumolu, mebi ka m̃ano bauei jo bo, naruei naio miel ban bere vonuo ea komeli. Ana bogo napano boru vonuo, naio ba berialio ka tomu nalo, berinavo ");
INSERT INTO bki_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Valauo Ju tai naio jo rove yako ea bulukuei, naio jukunu ban kiniou, naio mijikia vite nonovio ea kanaku meuliano. Kiniou namial naio jibe ka Naverikariano garuei memedu, p̃eli na? Kamiu kumei, ravatove reialio.” ");
INSERT INTO bki_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Naruei nalo ajumolu ajaluvo abatove ka ajidom aial Yesu nene. ");
INSERT INTO bki_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mia bogo na aju amiel abinimei maka ayotuba vo, ana naiagagoano nalo abar bulag salo sinaniano napano aba abuluio, aberii ka Yesu aberinavo “Naverloglogiano, komei kesinan.” ");
INSERT INTO bki_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mia Yesu naio maka rimei, mia abio bereio bano-o, karina Yesu berinavo “Kamiu kuvisinan, kiniou be saku sinaniano dolu tai naio jo napano kamiu maka kuvijikiaio.” ");
INSERT INTO bki_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Naiagagoano nalo amijogio nina, naruei nalo amil banlo, aberinavo “?Ana kenia naio bar sano sinaniano nene binimei? !Kito maka reial toro tai leleio!” ");
INSERT INTO bki_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ana na Yesu ber kalo, berinavo “Makanio, sinaniano na kiniou nojo neberenio na naio dolu kiana. Saku sinaniano, naio be im̃auano na jogkariano na tinieiiano na naio nam̃a miila kiniou nebinimei yetano nei, a kiniou monoka noim̃au ka nonovio riviniu rivanvano-o na ribisi. ");
INSERT INTO bki_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Bogo nam̃a kito romebija tiniavio, rojum̃a rober bogo nonovio jibe nei, roberinavo: Siberio veri ju, ka sinaniano rimeruo. Mia vonganei ea Atua kanano tiniavio, tomu nalo aju ruei ka ajog Atua kiano iliano, jibe sinaniano nalo na amermeruo ruei. Kiniou nojidom ka kamiu kuvila vonio ka kuvetavo ea miremiu, ka kuvisirarago vatitig tanea vio, ana mia kuvijikia kuvial sinaniano nalo ameruo bo ruei, vonganei be bogo na ava avario rimei. ");
INSERT INTO bki_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","Mia nalo nam̃a ava avario, mia nalo asaaro ve toru laka bior kanalo vuliano telisu naio jo ruei, ana bogo na avar sinaniano nene rimei vonuo na meuliano na maka ve togio nene, toro na toru na mebija, mia naio bunu saaro ve toru. Naio jibe ka ga iliano napano ber jibe nei, berinavo ‘Toro tai naio ba mebijo, mia toro dolu naio ba bario, mia burum̃ara saariano be tena nalo nonovio.’ ");
INSERT INTO bki_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jibe na, kiniou nojom̃a nemiila kamiu ka kuva kuvuru tomu nalo napano kulo dolu nalo amila burum̃ara im̃auano kalo ruei, mia vonganei kam nonovio kuvije buron kamiu ea jogvuiano na im̃auano nene.” ");
INSERT INTO bki_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mia bogo napano kulo Sameria napano ea komeli nei amijog tira nei naio berii jum̃abe ka na Yesu mijikia vite nonovio ea kanano meuliano, nalo amiilo toru, naruei mila nalo telabo amonea Yesu. ");
INSERT INTO bki_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ana bogo na abinimei ka aial naio, aju ajukunu bija naio banbano-o, karina abika naio ka nuva vonuo, nuvitu kija vijalo. Naruei nuba numitu bijalo ba bokar bogoti juo, ");
INSERT INTO bki_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","mia nalo telabo lie amonea naio bior kanano iliano novo nalo. ");
INSERT INTO bki_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aber ka bunu tira nei, aberinavo “Beamu, kumemi numijog venia ga napano jau kober ka kumemi, maka nuvijikia, mia vonganei, kumemi numijog kanano iliano memedu ga, kumemi numijikia ka be riano ga, kanado toro na toru nei, naio be Ioruriano na yetemeriba.” ");
INSERT INTO bki_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mia bogoti juo nei barlaka bisi ana kumemi liko Yesu numituvan vio nei nubano, numidu bere kenememi m̃arabo ka nuvatove ea tanobuku na Kalele. ");
INSERT INTO bki_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu jidom rivan bereio ea kiano vio Kalele, bior naio mial tomu dolu na vio dolu aberverii naio, ajirag naio laka janea vio. Nina jakii kiano iliano tai, napano berinavo “Tomu dolu nalo tiniel jii ka aiagago vatitig ka naverialiano, mia tomu na kanano vio nalo makanio, ajidom naio be iakurano.” ");
INSERT INTO bki_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mia bogo na nubinimei numiyotuba ea vio Kalele, tomu nalo na kiano vio ajaaro toru ka ala vorvoruano ka naio. Naina bior beamu, nalo telabo bunu aju ajua jokoluolu na Yerusalemo, ana amial ruei vijuku m̃eteiano na Yesu mila ea Atua Kunuano Lu ka bogo na, ana amialio ka naina bo laka. ");
INSERT INTO bki_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Naruei naio jom̃a miel ea vio nalo na Kalele binimei bokar bereio komeli na Kenan, nanua naio bilig uei binimei be m̃arjum̃elm̃elu. Ana ka bogo na, tubo na toru tai na komeli dolu na Kapeneam naio joa vio na, mia naio jom̃a mijog bova bior kenerinio tete sum̃ano naio mie toru laka vaataro ka ga rim̃aro. ");
INSERT INTO bki_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mia bogo na naio mijog ajum̃a aberii ka Yesu naio juvan vio Yutea binimei Kalele bereio ruei, naio ba mileal naio. Naruei naio mial Yesu, jegi banio ka riva vonuo rieliel ka kenerinio nene. ");
INSERT INTO bki_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ana na Yesu ber kanio berinavo “Vede jau bunu jau kojibe ka tomu dolu nalo. Bogo nonovio ga ajidom vremesiano ninio nalo, mia ver noim̃au kanio, mia amonea kiniou kanio. Mia bogo napano maka bunu atu aialio, nalo maka asaaro ka amonmonea kiniou.” ");
INSERT INTO bki_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mia tubo na toru nei naio jikili kanio, berinavo “Toro na toru, neber bo kaso jau komei sop̃eli, ver p̃eli mia keneriku nene naio rivakovio.” ");
INSERT INTO bki_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mia Yesu naio jidom ka tubo nei monea kanano iliano ga, naio berinavo “Makanio, mia jau ga ve takurano kavano. Kiniou neber kaso neberinavo kenerimo nene mia naio rim̃aro re na, naio rimeul rivu ga.” Naruei toro nei monea iliano napano Yesu berkanio, ana na juvan vio ka riva vonuo bereio. ");
INSERT INTO bki_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ana na viobijeni kanio, bogo na naio jom̃a miel ban bere ka rivano, naio bitavo bija kanano tomu nalo, napano ajum̃a amiel bior naio. Mia nalo aberial banio, aberinavo “Kenerimo naio mijog bo ruei jo.” ");
INSERT INTO bki_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Naruei naio bika denlo, berinavo “Kamiu kuvisidomii vatitigio: bogo na vabe naruei na kamiu kumialio jikar ka binimei bo bereio?” Nalo aberdop̃e aberinavo “Kumemi numialio jibe ka niabene binimei menini bo ea niogoravo naniovo, jibe ka m̃erenio takurano.” ");
INSERT INTO bki_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mia tete nei karam̃ano naio mijogio jibe na, naio mijikia ka nina naruei bogo memedu ga ka napano Yesu ber kanio berinavo “Kenerimo naio rim̃aro re, naio rimeul rivu ga to.” Naruei vite na mila karam̃ano, bija nalo nonovio ea kanano m̃aratavo, amonmonea Yesu. ");
INSERT INTO bki_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Naruei ielieliano na tete nei, Yesu mila iorou ka napano naio jaluvo den vio Yutea binimei, a naio naruei be kiano vremesiano valuo nene ea tanobuku na vio Kalele. ");
INSERT INTO bki_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ana Yesu naio jo Kalele kirisiou kija banbano-o na bokar bogo na kulo Ju nalo kanalo jokoluolu dolu mave yako Yerusalemo. Naruei Yesu nalo aban bere mave ea jokoluolu nene. ");
INSERT INTO bki_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ajua vio Yerusalemo jibe na na ea legiano tai ana Yesu miel ba batove vaataro ka burum̃ara m̃aratavo na komeli nei napano abio ka M̃aratavo na Nunu, ana nalo aban ea vio tai napano be uei na m̃a amijeljelioa naio joaio, napano ea kialo iliano, abio ka Betsata. Naruei jeliviv ea bauei nei, be m̃arsup̃iki jimo nene ju, napano amim̃au kalo ea puruveru. ");
INSERT INTO bki_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mo bogo nonovio ga be tomu na mieiano nalo, be merebono nalo, be jaba nalo, a be nalo na niabele m̃arm̃aro, nalo na jibe na nalo miroano laka aju abinimei amonea m̃arsup̃iki nalo nei. Abinimei jibe na, bior uei nei, naio miyukulkulu be ve vaarakurano ga, ");
INSERT INTO bki_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","jibe ka Atua kanano nailiano naio binimei milaio, mo ver nalo amial jibe na, namieiano kei napano naio ba bokar uei nei jukamu, mia mieiano vaio nam̃a joa naio mia ribisi denio vaarakurano ga. ");
INSERT INTO bki_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jibe na, tomu na mieiano nalo aju abinimei ea vio nei, mia ka bogo nene nalo nene tai be toro tai napano niabene nalo biniu m̃arm̃aro bokar yuka duelimo va rolu ba arolu 38 ruei. ");
INSERT INTO bki_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ana bogo na Yesu binimei, naio mial toro nene, mia mijikia toro nei naio jo mon bior mieiano nei bogo jiou ruei jibe na, ana naio bika denio berinavo “?Koig liki, jau kojidom ka niabemo rimei rivu, ina?” ");
INSERT INTO bki_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ana na toro na mieiano naio berdop̃e berinavo “Toro na toru, kiniou nojidom toru kiana, mia bogo nonovio, ver uei naio miyukulkulu, mia maka toro tai ka rudu kiniou navatove tii kiniou notoa ea. Ana bogo na kiniou takurano nemiel vonvon nabatove mia toro dolu naio binimei batove bokar uei nene jukamu ka kiniou.” ");
INSERT INTO bki_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ana Yesu mil memedu ban toro nei naio berinavo “Mo, jau kotumolu, jau kavar m̃amo yebe, koiel kavano.” ");
INSERT INTO bki_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Naruei ea Yesu kanano iliano nei, toro nei niabene nalo na abova abinimei abo nonovio, ana naio jumolu bar m̃ano yebe, jumolu miel ba vonuo. Ana ka legiano nei na vite nei miyotuba eaio, naio be Legiano Lu tai na kulo Ju nalo kanalo, ");
INSERT INTO bki_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","mila na ka bogo na tomu na tortoru na kulo Ju nalo amial ka kema nei naio jo miel bija m̃ano yebe, ana amil banio biorio, aberbureio, aberinavo “!Ai, abe banei be Legiano Lu kiana! Jau kojo komidu m̃amo yebe jibe na, jau komila korov kiado tuboiano kulo kito Ju nalo.” ");
INSERT INTO bki_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mia naio berdop̃e banlo, naio berinavo “Kiniou niabeku nalo burukokorovio, mia toro nene binimei mieliel ka kiniou, berii ka kiniou berinavo nodu m̃aku jogu navano.” ");
INSERT INTO bki_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mia nalo ajidom ajikia vatitig lie vo, nalo abika denio, aberinavo “?Ana kenia na? ?Naio be kenia napano naio ber kaso ka jau kala tibe na?” ");
INSERT INTO bki_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mia kema nei naio maka rijikia riverenio, bior napano naio maka rijikia ka be Yesu napano mieliel ka naio, mia maka bunu rijikia rial naio bior napano be burum̃ara tiniobi na jo, mia Yesu jo miel bure tomu nalo nene, naio jaluvo den vio nei ruei. ");
INSERT INTO bki_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ana iorou kanio maka vesiou, ana Yesu mial toro nene bereio joomo ea Yimo Lu, ana berkanio berinavo “Vonganei na jau kobinimei kobo ruei, bo ka jau kovitikar vatitigso. Jau kotuvan nonovio kanamo kariano nalo, ver maka vede titai naio riva rivova lie kaso tovulu napano beamu.” ");
INSERT INTO bki_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana ka bogo na kema nei naio mijikia ka be Yesu nei napano mieliel ka naio, naruei naio ba berialio ka tomu na tortoru na kulo Ju nalo kialo. ");
INSERT INTO bki_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mia bogo na nalo amijogio ka be Yesu napano naio mieliel ka toro nei, tiniel jer naio, nalo maka asaaro ka na naio mila tenei ka Legiano Lu, naruei nalo ajikar ka amila baravo abilvili ea naio. ");
INSERT INTO bki_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ana na Yesu berdop̃elo, naio berinavo “Karam̃aku, naio jom̃a mim̃auka kanano im̃auano nalo na bo ea bogo ninio, ba bokar bunu Legiano Lu nalo, mia kiniou bunu monoka noto nala tibe na ga napano naio milaio.” ");
INSERT INTO bki_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jibe na ga ka bogo na, navurim̃ara-boiano na kulo Ju nalo ajum̃a abitii Yesu ruei aber naio be toro nam̃a mila bulag tolu na Legiano Lu. Mia vonganei mave ka naio, nalo amijog ka napano naio jom̃a bio Atua be karam̃ano memedu, nalo amialio jibe ka naio jom̃a mila naio be verare bija Atua. Naruei vite nalo nei mila ana abinimei abitunu lie vo, ajidom toru laka ka auebinio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ana Yesu ber kalo, naio berinavo “Kiniou neber be riano ka kamiu, ka kiniou Atua kenerinio, kiniou maka nejikia nela titai kiniou ga ve takurano, mia venia ga napano nemial Karam̃aku milaio, naina naruei kiniou bunu nemilaio jibe na. ");
INSERT INTO bki_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Atua teta naio tinien jii m̃elea kiniou kenerinio, ana jom̃a jiloglog kiniou ka vite nonovio napano naio jidom ka mia nalaio. Abe im̃auano dolu nalo ju kiano vo napano nalo tortoru lie vo, napano mia karam̃aku sian van kiniou ka mia noim̃auka iorou, a bogo napano mia noim̃aukanio, mia kamiu kuviilo ve toru kanio. ");
INSERT INTO bki_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A bunu, tibe ka napano Teta naio bitiri bulag bereio nalo napano m̃a am̃arm̃aro naio jian bere kialo meuliano banlo, mia kiniou Kenerinio bunu nemijikia nesian meuliano van toro kei nam̃a nojidom nesian vanio. ");
INSERT INTO bki_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mia Teta, maka ve naio ga nam̃a mila tibureiano, mia im̃auano na bunu naio midu joa jum̃aku, ");
INSERT INTO bki_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ka rila na tomu nonovio monoka avatove ka kiniou, tibe ka nam̃a abatove ka Karam̃aku. Tibe na, toro nam̃a naio maka to rivatove rivu ka kiniou Kenerinio, jibe ka naio maka to rivatove rivu ka toro na toru napano miila kiniou nabatove.” ");
INSERT INTO bki_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ana Yesu mil lie vo, naio berinavo “Kamiu kuviagago vatitigio. Toro kei nam̃a monmonea kanaku iliano, a naio monea nana naio miila kiniou nabatove, ea bogo nei memedu mia naio rivokar meuliano. Naio maka totano yetano ka tibureiano tai leleio, bior naio jumolu den bajago na m̃ariano, ba bokar kiano meuliano vou ruei. ");
INSERT INTO bki_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“A kiniou neber ilirianiano nei bunu ban kamiu, ka bogo na jo binimei vonganei napano nalo nam̃a Atua mial ka am̃arm̃aro den bajago va, mia nalo ajog jooku kiniou Atua kenerinio, mia nalo na ajogkario, mia avokar meuliano. ");
INSERT INTO bki_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kiaku Teta, meuliano na be riano joa naio ga, naruei naio mijamo ka meuliano nei na joa kiniou, ");
INSERT INTO bki_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","mia naio mijamo ka bunu ka kiniou Kulorinio Kenerinio, mia nala im̃auano nalo na tibureiano. ");
INSERT INTO bki_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Vite nalo nei, nalo maka ve tena kamiu kuviilo kalo, mia naio monoka tibe ga na ea bogo napano kiniou nojo noberenio ka naio jo binimei. Mia nalo nam̃a amonmelio ea borotano mia ajog jooku naio rivio, ");
INSERT INTO bki_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","naruei mia ana kialo tumoliano bereio ka aje meuliano, ana tomu nalo na aim̃au bova, kialo tumoliano ka avokar tibureano.” ");
INSERT INTO bki_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ana Yesu mil lie vo, naio mil memedu ban tomu na tortoru na kulo Ju nalo napano maka asidom amonea naio, naio berii vite nalo na m̃a ajiloglog naio ka naio be riano. Naio berenio berinavo “Ea tivelinio na tibureiano, napano mia kiniou nala, mia kiniou nala re tibe ka kanaku jidomiano kiniou ve takurano ga, mia nala ea ga venia napano nomijog Teta berenio. Tibe na, mia kanaku tibureano naio memedu ga, bior napano maka nala ka kanaku jidomiano, mia nemila ea Teta kiano na naio juvan kiniou nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naruei nemil jibe na ban kamiu, nemijikia ka nojo neberii kiniou bereio, ana vede nalo tai amial ka maka rimemedu ka neil tibe na, nalo maka ajikia amonea iliano na jibe na. ");
INSERT INTO bki_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mia naio bo ga na, naio maka ve titenia, bior napano be vite dolu nalo na m̃a amija kanaku iliano amijikia atumolu atu. “Na be moti nene, naio be toro tai napano naio berial vite ninio ban kiniou napano abe riano laka. ");
INSERT INTO bki_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ninei be Jone Baruei nei, napano beamu, kamiu kumituvan iliano ba banio, kamiu kubika jum̃abe ka kiniou eaio, naruei naio berial vite nonovio be riano bo ban kamiu. ");
INSERT INTO bki_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mia maka rivu ka kamiu ve tiniemiu ka iliano na toro tai jibe na Jone mila kanaku iliano tumolu tibe na. Mia kiniou nejidom kamiu kuvisidomii vatitig rivu bereio ea venia napano Jone berial ban kamiu ea tivelinio na kiniou, bior nojo namila vio ka najai kamiu ka kuvijikia kuvokar ioruriano. ");
INSERT INTO bki_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Kiniou neber Jone nene ka kamiu, bior naio javukia yulu tai napano mereralii batitig kenemiu jidomiano, napano kumisaaro telisu ka naio. ");
INSERT INTO bki_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Mia vite dolu na m̃a miija kanaku iliano, be toru lie ea vite nalo na m̃a Jone beriio. Vite nei naio be kijokijo nalo napano Teta naio mijamo ka ban kiniou ka neim̃aukanio ea miremiu. Im̃auano nalo na tomormoruo nei na m̃a kiniou nojo namilaiio amiija kanaku iliano nei toru ka be riano ka napano Teta nei naruei naio miila kiniou nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Mia mave ka vite juo nei, dolu nene naio jo, naina be Karam̃aku napano miila kiniou nebinimei. Kamiu maka lele kuvijog joono a maka lele kuvial mirano, mia naio bunu, kanano iliano nalo amiija toru ka kanaku iliano, na aberial kiniou. ");
INSERT INTO bki_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mia kamiu kumila napano maka ve jeleigio ka iliano nei ea kenemiu meuliano, bior napano kamiu maka kuvisidom kumonea naio napano miila kiniou nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bogo telabo kamiu kumitum̃a kubitii vatitig Vivitauiano Lu nalo, bior kumitum̃a be tiniemiu ka mia kuvileal kenemiu meuliano napano maka ve jukuti nene, ana Vivitauiano Lu nalo nei naruei napano aberial kiniou. ");
INSERT INTO bki_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Aber ka kiniou ga nebe burupati na meuliano nene, mia kamiu maka kuvisidom kumei kuvokar meuliano nene ea kiniou.” ");
INSERT INTO bki_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Naruei Yesu mial kialo veribinio, mil jibe nei berinavo “Vite nalo na m̃a kiniou nojo nemila, maka noto nala rivior ka nejidom kamiu kuvitirilar siaku, makanio. Kiniou maka nesidomial naina, ");
INSERT INTO bki_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mia be vite tai na bova, kiniou nemijikia batitig kamiu ruei, naruei nemijikia ka kamiu maka tiniemiu tii Atua leleio. ");
INSERT INTO bki_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Bogo na m̃a kiniou nomiyotuba ka kamiu, nebinimei ea karam̃aku siano, mia kamiu maka kuvisaaro ka kiniou. Mia ver bogo tai toro dolu tai rimei, napano rimei ea naio ga ve takurano siano, a vede mia kamiu kuvisaaro kanio ga. ");
INSERT INTO bki_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kiniou tinieku miia kamiu toru laka, mia namial jibe kiride ka kuvijikia kuvokar moneano riano bogo tai. Naina bior napano dam̃ariga, kamiu kumitu tiniemiu jii ka kuvidular siemiu rivavin. Kamiu maka kuvitu kuvisidom ka kuvijebukua kenemiu bajago leleio, ka kuvila vite nalo napano iorou mia Atua naio mijikia rivitiri bulag kamiu riviorio. ");
INSERT INTO bki_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Kiniou neber iliano nalo nei ban kamiu, p̃eli kumitu kumisidom kuberinavo ‘Uerei, kema na tinien jer kito, p̃eli ea bogo na tibureiano mia naio naruei napano mia riverial kanado torokoriano nalo van Teta Atua ea vio mave.’ “Mia makanio, ve re kiniou na mia nala tibe na, mia ve dolu tai na mia naio rilaio. Dolu nene, nina be tormoruo Mosis, napano m̃a kumitu kubarkar tiniemiu ea naio ka mia naio river iliano na mia rijai kamiu, mia kiniou neber vatitig ban kamiu, naio naruei napano mia river bulag vovaiano nalo na kenemiu na. ");
INSERT INTO bki_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kamiu kumitum̃a kuberinavo kumitu kumonea jikili tormoruo Mosis kanano iliano nalo nei, mia ver tibe na bior vaio ana kamiu maka kumonea kiniou bunu, bior napano tormoruo na dam̃ariga naio bivitauii kiniou ga. ");
INSERT INTO bki_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mia vonganei kiniou nemial jibe ka napano kamiu maka kumonea vivitauiano na kanano, mia ka tenei, kamiu kuvijikia dulu re ka kumonea kanaku iliano nalo bunu.” ");
INSERT INTO bki_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iorou ka naina, kumemi liko Yesu numidu uako numituvan kanano tanobuku bereio, nubar kor burum̃ara ueiyabo nei Kalele, napano tealo abio ka ueiyabo na Taiperias. ");
INSERT INTO bki_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mia bogo na tomu nalo amial ka numitu nubano jibe na ea tivelinio, ajumolu ajakisor kumemi. Ajidom avan vija Yesu bior nalo aju amial burutomoluo na ielieliano na naio jom̃a mila ea nalo napano m̃a abokar mieiano nalo. ");
INSERT INTO bki_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ana nubano nubokar tivelinio nene, numiel nubavin ea suku tai napano joa vio na, numiel nubanbano-o na numebi. ");
INSERT INTO bki_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","5","Ana Yesu naio jotano jo jirarag ba laka, naio mial burum̃ara tiniobi napano nalo aju amiel abinimei ka naio. Naio bitilubar ka nalo telabo abe tomu na vio kinkin napano ajum̃a amiel vei ka ava Yerusalemo. Nalo aju abano bior burum̃ara jokoluolu na kulo Ju nalo kanalo, Jokoluolu na Nasidomkariano na Ioruriano, napano mia ala rivesiou re. Naruei bogo na Yesu naio mial nalo ka aju abinimei, naio bika vite tai den Vilip, naio berinavo “Vilip, nalo na aju jijerlo toru laka liki kiana. ?Mia kito rovulu salo joko tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Vikadeniano nei Yesu kanano, naio be tena rilavon kija Vilip ga, bior Yesu naio mijikia ruei vite napano mia naio rilaio van tomu nalo nei. ");
INSERT INTO bki_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ana Vilip naio berdop̃e, berenio ga berinavo “Ver kiniou noim̃au yuka ve takurano, mia maka nejikia neleal puruveru rivare ka novulu ka sinaniano na nalo aviniu ajevio ve tertelisu!” ");
INSERT INTO bki_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naruei naiagagoano dolu nene, be Adru, napano be Saimon Pitere kuruano napano teliki, naio berial ban Yesu, berinavo ");
INSERT INTO bki_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tubo, kiniou nemileal m̃eaku tai jo nei, naio bar joko sesa jimo 5 bija niado momaio juo 2. Ninei naio telisu ga mia tomu nalo miroano laka.” ");
INSERT INTO bki_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mia Yesu naio berinavo “Makanio, naio bo ga na. Kuver ka tiniobi nalo ka atutano yetano beamu vo.” Naruei nuber kanilo, ka nalo atutano ea m̃ajumunei, ana naruei numial tomu nalo nene bokar menu jumo 5,000 titai jibe na. ");
INSERT INTO bki_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Naruei Yesu naio bar joko jimo nene ana bolkouo, ber siva biorio. Avona bisi ana jikar ka m̃a burekokorovio a jijian bulag ban nalo napano ajum̃a ajutano, naio mila jibe na ga bunu bija niado, jijianio ban nalo nonovio jibe ka na nalo tiniel jii ka asenio. ");
INSERT INTO bki_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Naruei nalo ajenio banbano-o na mabolo jouo, ana Yesu ber ka kumemi, naio berinavo “Sinaniano torogio na be va ju, kito ralaluvu re, ana bo ka kuvar bijiio riva vio takurano.” ");
INSERT INTO bki_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Naruei kumemi nubano nubar niati joko jimo nei binimei, napano nalo ajen digio ju, naruei numisonlo ban ea basaro banbano bokar basaro duelimo ba juo 12 garuei. ");
INSERT INTO bki_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mo bogo na tomu nalo abitilubar burum̃ara burutomoluo napano Yesu milaio, ajum̃a aber jibe nei kalo aberinavo “Kiado burum̃ara naverialiano na m̃a korobido nalo aberkario ka mia naio rimei riyotuba ea yetemeriba nei, tete na naruei naio be naverialiano nene memedu kiana.” ");
INSERT INTO bki_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Naruei nalo aju ajidomii ka ava avokar Yesu, ajidom atutuaio ka avitirilar naio rimei rive kanalo parinio Tubo, mia bogo napano naio mijog lubar ea naio venia napano ajidomii ka alaio, naio jaluvo denlo, miel naio takurano ga ba bavin lie vo ea burusuku nalo nei. ");
INSERT INTO bki_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Naruei kumemi naiagagoano nalo numial ka napano m̃erenio jo batove, numial bo ka nuvan bereio, naruei nubatove ea tivelinio na ueiyabo. ");
INSERT INTO bki_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nubatove mia maka bunu nuvial Yesu riyotuba bereio ka kumemi, mia bior napano vio bobogio ruei, numidu kenememi uako, numituvan vio bereio nubeluo ka nuvavin ea ueiyabo ka nuvarkor bereio nuvan ea vio Kapeneam. ");
INSERT INTO bki_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Naruei numitu nubano jibe na, kiri jegi tai binimei jo miuvuvu kija, naio mila na tei jikar ka bieveluo laka. ");
INSERT INTO bki_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mia bogo napano nubeluo koalabo kija ruei, jibe sudu jimo, numiilo ka napano Yesu naio jom̃a miel mave ea niunuku uei jo binimei vaataro. Naruei numerou kanio toru laka, ");
INSERT INTO bki_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","mia naio mil ban kumemi berinavo “!Oi, kamiu kumerou re! Kiniou ga nei.” ");
INSERT INTO bki_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ana numijog bo bereio, mia nuburu naio bavin ea uako, mia vaarakurano numial ka kenememi uako naio jologlog vio na numisidom ka nuvan ea ruei. ");
INSERT INTO bki_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Naruei ea kavijo, nalo na laka yako ea ueiyabo nei tivelinio, napano Yesu baganlo vonga, nalo aju ajidom toru ka Yesu naio jo jum̃abe. Nalo aju ajidom jibe na bior bogo napano kumemi liko Yesu nubinimei ealo, numidu uako takurano ga, mia nalo amial ka napano kumemi numidu uako nene nubano bere ruei, mia Yesu naio maka rivan vija kumemi, naio takurano jobo. Mia vonganei nalo maka bunu ajikia aleal naio ealo, ");
INSERT INTO bki_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","mo nalo abano abar uako dolu nalo tai, nalo abarkor ea vio Kapeneam ka asirav kumemi. Uako dolu nalo nei, maka ave kanalo, mia be kulo Taiperias nalo kanalo napano nalo abinimei aborvoru ealo, abano vauro ea vio na ga m̃a Yesu bolkouo ka joko eaio, naio mila binimei bare ka nalo asenio. ");
INSERT INTO bki_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Naruei tomu nalo nei abinimei aboru Kapeneam, ana abavauro, naruei nalo ajiravo Yesu. Mia bogo na amilealio, abika denio, aberinavo “?Naverloglogiano, jau kobinimei bere koboru ea vio nei ka bogo na vabe?” ");
INSERT INTO bki_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mia Yesu naio mijikia venia napano ajidom aial naio bereio riviorio, ana naio berdop̃e banlo, berinavo “Ver kamiu kubinimei kumisirav kavulu kiniou bereio bior kumial kanaku burutomoluo nalo ana kubitilubar ka kiniou kiniou kei, naina naio bo na. Mia kiniou nemial jibe ka kamiu kumitu kumisidomial ga ka naniovo kiniou nabagan vatitig kamiu, kumisinan banbano-o mabomiu nalo abujovujo vatitigio bo, tenene na kamiu kumisidom ka mia tibe na bereio banei, p̃eli makanio? ");
INSERT INTO bki_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mo, kanaku ilirianiano van kamiu naio jibe nei: kamiu kuvitum̃a kuvisidomii m̃ele re rivior sinaniano ga napano naio be tena bogo bulati ga naio joono bereio. Mia bo kanio kuvim̃au sikili rivior sinaniano nei na m̃a naio mijikia to dam̃ariga to, naio mijikia to to riva rivokar bogo na meuliano nei napano naio maka ve jukuti nene. Be riano, mia kiniou Kulorinio Kenerinio nemijikia nesian meuliano nene van kamiu, bior ka napano teta Atua naio jekarlar kiniou takurano ga ka nela tibe na.” ");
INSERT INTO bki_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naruei nalo abika denio, aberi-navo “Ana ver kumemi nuvisidom ka kumemi nuvila vite nalo nam̃a Atua naio jidomio, mia monoka nuvim̃auka tum̃abe?” ");
INSERT INTO bki_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ana Yesu berdop̃e banlo berinavo “Burum̃ara vite napano Atua jidom ka kuvim̃au kanio, naio jibe nei: kamiu kumonea rive riano ea kiniou napano Atua miila kiniou nebinimei ea yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ana nalo abika bereio, aberinavo “?Ana jau, venia naruei be kanamo burutomoluo napano ver kumemi nuvialio, mia kumemi nuvijikia nuvimoneaso? ?Mia jau kala im̃auano vabe na bo van kumemi? ");
INSERT INTO bki_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kumemi nubika jibe na bior ka napano numitu numisidomial kanado tormoruo nalo na beamu, nanua na ajua vio yauo. Aju jibe na, mia Mosis mila burutomoluo tai na bo banlo, napano dam̃ariga nalo aju abar joko na abio ka mana, mia nalo ajenio, maka lele siserlo. Vite na naio joa niosi lu, a naio berenio berinavo ‘Dam̃ariga naio baganlo ka joko na vio mave!’ ” ");
INSERT INTO bki_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ana Yesu berdop̃elo bereio, berinavo “Nao, vite na naio joa niosi lu, mia joko napano Mosis bario, naio maka ve joko na vio mave. Joko na vio mave napano be riano, karam̃aku ga naio mijikia sianio. ");
INSERT INTO bki_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Atua kanano joko be kiniou napano najaluvo ea vio mave nebinimei yetano, ka nesian meuliano vou rivan tomu na yetemeriba nalo.” ");
INSERT INTO bki_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ana nalo aberdop̃e, aberinavo “Tubo, naina naruei be joko nam̃a kumemi numisidom tulaka.” ");
INSERT INTO bki_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ana Yesu berial banlo, naio berinavo “Kiniou, kiniou nebe joko na meuliano. Toro kei napano naio rimei ea kiniou, naio maka lele rijikia siser naio bereio, mia toro kei napano naio rimonea kiniou, naio maka lele rijikia midou ser naio bereio. ");
INSERT INTO bki_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Be vite takurano ga naio bova, jibe ka napano neber ka kamiu ruei, napano kamiu kumial kiniou bija kanaku burutomoluo nalo ka miremiu ruei, mia kamiu maka kuvisidom kumonea kiniou. ");
INSERT INTO bki_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ana mia monoka tomu tai napano mia amonea kiniou, bior nalo nonovio napano teta mudulo ajua jum̃aku, mia monoka amei ea kiniou, mia nalo nonovio napano mia amei ka kiniou, ve re tai kalo napano mia novukulario bereio, mia novokar vatitiglo aviniu ave kanaku. ");
INSERT INTO bki_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Kiniou najaluvo ea vio mave nabatove yetano ea yetemeriba nei, maka ka mia nala kanaku jidomiano, mia ka nala jidomiano na kanano napano naio miila kiniou nabatove. ");
INSERT INTO bki_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mo kanano jidomiano naio jibe nei, ka nalo napano naio mudulo ajua jum̃aku, mia kiniou nalaluvu re nalo tai kalo, naio jidom ka ea legiano na maaro mia kiniou nevitiri bulag nonovlo bereio. ");
INSERT INTO bki_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Karam̃aku naio jidom toru ka tibe nei naruei, ka nalo nonovio napano m̃a amial kiniou, ana amonea kiniou, mia nalo avokar meuliano nei napano naio maka ve jukuti nene, a naio jidom toru bunu ka ea legiano na maaro, ka mia kiniou naruei nevitiri bulaglo bereio.” ");
INSERT INTO bki_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Naruei bogo na kulo Ju nalo kanalo tomu na tortoru aju amiagago ka Yesu kanano iliano nalo nei, nalo maka asaaro leleio, naruei ajum̃a amil mum̃i kanio. Be kanano iliano tai napano nalo maka asidom ajogio, naina be iliano napano naio berial ber naio be joko napano naio jaluvo ea vio mave batove ea yetemeriba nei. ");
INSERT INTO bki_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nalo aberii ealo aberinavo “?Jum̃abe ana toro na naio jom̃a berial ban kito ber naio jaluvo ea vio mave tiniabene naio binimei ea kito? Naio maka ve toro kokouro tenia na, kito romijikia batitig naio ruei, bija kenieno a karam̃ano bunu. Naio be tormoruo Yoseve ga kenerinio na, Yesu.” ");
INSERT INTO bki_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ana Yesu berdop̃e banlo naio berinavo “!Oi, ilimum̃iano ea kiniou naio bare, kamiu kuviagago vatitigio beamu vo! ");
INSERT INTO bki_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Toro kei napano naio binimei monea kiniou vonganei, mia ea legiano na maaro kiniou nevitiri lar naio rimeul bereio. Mia Teta napano miila kiniou nebinimei, ver naio rivuru re toro na rimei ea kiniou, mia naio maka rijikia rimei. ");
INSERT INTO bki_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Niosi na naverialiano Aisea kanano naio berial iliano tai, naio berinavo ‘Nalo nonovio, mia Atua ga naio riverlogloglo,’ ana mia never nalo nam̃a ajog batitigio iliano na Teta Atua kanano, nam̃a naio berloglog batitiglo kanio, nalo naruei mia amei ea kiniou. ");
INSERT INTO bki_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ana nalo na jibe na, mia ve re tai kalo napano aial Teta Atua, bior be toro takurano ga mial naio, nina be kiniou napano nejaluvo denio nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Nao, kiniou nojom̃a neber be riano laka ban kamiu, ka tomu nalo nonovio napano amonea kiniou, aju jouro ea meuliano ruei, na maka jikia bisi, ");
INSERT INTO bki_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","bior kiniou, kiniou nebe joko na meuliano. ");
INSERT INTO bki_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Joko nei naio maka rive verare ka joko na mana napano kulo moruo nalo ajenio ea vio yauo. Nalo ajen banbano-o na, karina maka ve nalo tai kalo napano naio rimeul tobo to, nalo abiniu ajum̃a am̃arm̃aro jibe na ga. ");
INSERT INTO bki_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mia ver joko tai to, ana toro napano tom̃a senio mia naio rijikia re rim̃aro bogo tai, naina naruei kito rejisia ka joko na vio mave memedu. ");
INSERT INTO bki_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mo, kiniou naruei, kiniou nebe joko napano meul mugaruei, napano jaluvo ea vio mave binimei ea yetemeriba nei, ka toro na naio senio, naio meul tobo to. Joko nene naruei be mokotenaku, napano kiniou nemijamo ka bior yetemeriba vodolu nei, nejian bior meuliano na kanano tomu nalo.” ");
INSERT INTO bki_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Naruei Yesu kanano iliano nalo nei kirisikili laka ka tomu na tortoru na kulo Ju nalo kialo nei ajikia batitigio rivu, naruei ajum̃a abivika aberenio “Venia na? Toro na naio ber ka mia naio sian niamoiano van kito ka kito resenio, p̃eli na naio jom̃a ber venia?” ");
INSERT INTO bki_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Naruei Yesu naio ber bisivisii meravo banlo ea tivelinio na nioti na kanano m̃ariano, naio berinavo “Kiniou neber riano ban kamiu, neber kamiu monoka kuvisen niamoiano na kiniou Kulorinio Kenerinio, a kamiu monoka kumunu kanaku burukija. Ver p̃eli, mia kanaku meuliano naio maka rijikia toa kamiu. ");
INSERT INTO bki_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mia naio napano m̃a jen niamonioku, a naio munu kanaku burukija, naio bokar meuliano napano maka ve jukuti nene, mo mia kiniou nevitirilar naio bereio ea legiano na maaro, nala naio rimeul bereio. ");
INSERT INTO bki_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nina bior niamonioku, naio be sinaniano dolu tai, a kanaku burukija, naio be munuiano dolu tai laka. ");
INSERT INTO bki_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Naio napano m̃a jen niamonioku, a naio munu kanaku burukija, kanano meuliano momou joa kiniou, a kanaku meuliano momou joa naio. ");
INSERT INTO bki_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Karam̃aku na be burupati na meuliano, ana naio miila kiniou nebinimei, mia kiniou nojo nomeul ea kanano meuliano napano joa kiniou, naruei naio napano m̃a jen niamonioku, mia naio rimeul ea kanaku meuliano napano joaio. ");
INSERT INTO bki_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Naina naruei kiniou nojom̃a neber ea kanaku iliano ea tivelinio na joko nei napano jaluvo ea vio mave naio batove. Joko nei naio maka tibe ka joko nei nanua m̃a korobido moruo nalo m̃a ajenio mia nalo ajum̃a am̃aro jibe na ga. Naio be joko napano toro kei napano ver naio senio, mia naio mijikia rimeul to tobo to.” ");
INSERT INTO bki_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iliano nalo nei naruei Yesu jo berloglog kalo joomo ea yimo na volkouano na vio Kapeneam. ");
INSERT INTO bki_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mia bogo na, Yesu naio ber iliano nalo nei, kumemi kanano naiagagoano nalo telabo ajidomii naio bereio, aberinavo “Kanano verloglogiano nalo nei kirisikili kiana. ?Kei bereio naio mijikia rijoglubarbar vatitigio?” ");
INSERT INTO bki_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mia Yesu naio mijog lubar ea naio ka kanano naiagagoano tealo ajum̃a amil mum̃i ka naio tertelisu jibe na, ana naio bika denlo, naio berinavo “?Jum̃abe, kamiu maka kuvisaaro ka kanaku iliano telisu nei, mila kamiu kumisidom kuvituvan kiniou bereio? ");
INSERT INTO bki_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ver tibe na, maka nejikia kamiu naruei. Ver bogo tai, kamiu kuvial kiniou Kulorinio Kenerinio notuvan kamiu, navan bere ea kanaku vio mave, mia tum̃abe naruei? P̃eli mia tiniemiu bobogia kiniou naruei! ");
INSERT INTO bki_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kanaku iliano nalo nei abe m̃arabo na Niununo, abe m̃arabo na meuliano. Kulorinio naio mijikia rivar bere kulorinio, mia kulorinio naio maka rijikia sian meuliano riano nei van kulorinio dolu. Vite na Niununo na Atua kanano ga naio mijikia sianio. ");
INSERT INTO bki_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mia nebitilubar ka kamiu tealo kumonea ruei, mia tealo makanio.” Yesu naio ber nina, bior ka napano beamu ruei, naio mijikia kulo be nalo nam̃a maka amonea naio, ba bokar napano naio mijikia kei kalo napano mia naio tiveluku kanio. ");
INSERT INTO bki_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ana Yesu ber kalo bunu, naio berinavo “Tealo mia amonea, a tealo mia amonea re, naina naruei kiniou neber batitigio ban kamiu iliano nei naruei, ka maka toro tai rijikia rimei ea kiniou, ver karam̃aku maka rijamo ka naio rimei.” ");
INSERT INTO bki_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Naruei ea bogo nei, kumemi tealo kanano naiagagoano nalo amial jibe Yesu kanano verloglogiano nalo nei, abinimei jikili lie vo, naruei amialio ka be de ga, ana nalo aban bereio, maka bunu atu atakilili kumemi. ");
INSERT INTO bki_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ana bogo napano Yesu naio mial ka napano tomu tealo ajuvan naio bereio, naio mil ban kumemi kanano naiagagoano duelimo ba juo 12 nei, naio bika berinavo “?Ana jum̃abe ka kamiu? ?P̃eli kamiu bunu tiniemiu jii ka kuvan bere vija nalo na?” ");
INSERT INTO bki_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ana Saimon Pitere naio berdop̃e, berkar jikili ban Yesu, berinavo “Tubo, ver kumemi nuvituvanso, mia kumemi nuva nuvitakisor kei bereio? Jau takurano ga napano ioluano na meuliano na joaso, ");
INSERT INTO bki_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","jau ga takurano napano vonganei kumemi numonmoneaso, a kumemi numijikia ruei ka jau kobe Naverikariano Lu napano Atua juvanso kobinimei ka kolarur kumemi.” ");
INSERT INTO bki_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ana Yesu berdop̃e, naio berinavo “Nao, kiniou nebijauia bulag kamiu duelimo ba juo 12 na be kanaku, ka kamiu kumonea kiniou tibe na, mia iviso bure kamiu, kamiu tai naio be sim̃aro memedu.” ");
INSERT INTO bki_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mia Yesu naio maka riverial kumemi tai siano ka bogo na, mia iorou kanio ana nubitilubar ka ea kanano iliano nalo nei, naio jom̃a ber Jutas, tormoruo Saimon re Kariot kenerinio, napano naio be tai ka kumemi duelimo ba juo 12, mia naio maka ritovonio, naio jiveluku ka kanano Tubo novo nei. ");
INSERT INTO bki_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Iorou ka naina Yesu naio jom̃a miel jeliviv, jom̃a ban ea ga vio na be kiano tanobuku ga nei Kalele. Naio maka bunu tom̃a rivavin ea vio nalo na tanobuku na vio Yutea, bior navurim̃araboiano na kulo Ju na vio na nalo ajum̃a ajirarag ka naio ruei, ka ajidom ka ala bin naio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mia bogo tai, be vaataro ka bogo na burum̃ara jokoluolu tai na kulo Ju nalo kialo bereio, napano be Jokoluolu na Yimo Tobobo. Mia jibe ka ga bogo nonovio, nalo miroano tiniel jii ka avavin Yerusalemo kanio. ");
INSERT INTO bki_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Mia ka bogo na, Yesu kuruano nalo amil banio, aberinavo “Ei, jau kojo bogo jiou ea vio nei ruei, bo ka jau kalavon ka kavavin Yutea, ka kanamo naiagagoano nalo na yako nalo kija amijikia aial kijokijo nalo nam̃a jau kojom̃a komilaio. ");
INSERT INTO bki_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jau kojidom ka tomu nalo ajikia vatitigso, a kojom̃a komim̃au lukuluku ga. Ver be riano ka nam̃a jau komila burum̃ara burutomoluo nalo nei, bo kanio kava koyotuba ea yetemeriba mirano.” ");
INSERT INTO bki_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mia nalo nei kialo iliano nei jibe ka amiyotel ea ga Yesu, bior nalo abe kuruano memedu, mia nalo maka amonea naio. ");
INSERT INTO bki_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mia Yesu berdop̃elo, naio berinavo “Kamiu kumijikia kuvila kenemiu vite nalo ea bogo na vabe ga napano kamiu tiniemiu jii ka kuvilaio, mia kiaku burum̃ara bogo naio maka rimei vo. ");
INSERT INTO bki_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kamiu kumijikia kuvila kenemiu im̃auano nalo rivu ga, tomu nalo maka ajikia aserm̃i ka kamiu riviorio, mia bogo na kiniou nemila kiaku im̃auano, neberial ka kialo bajago va nalo na yetemeriba nei maka rimemedu, mia nalo ajerm̃i ka kiniou toru laka. ");
INSERT INTO bki_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tibe na mia kamiu ga kuvavin Yerusalemo, kiniou notobo nei ga beamu vo. Kiniou maka nejikia nava noyotuba ea mirano tomu nalo na jokoluolu nei, bior kiaku bogo jo binimei, mia maka rimei nonovio vo.” ");
INSERT INTO bki_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Naio ber iliano nei banlo, avona iorou kanio ana nalo abano ana naio jobo. ");
INSERT INTO bki_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu jobo jibe na, mia maka vesiou ga, naio bunu bavin Yerusalemo, mia maka tibe ka na tomu nalo amijikia aial naio, mia naio milavan naio. ");
INSERT INTO bki_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Naruei tomu na tortoru na kulo Ju nalo, ajum̃a ajidomiio ruei ka p̃eli mia naio rimei ea jokoluolu, naruei nalo ajum̃a ajiravo naio janea vio, abivika aber naio jo be. ");
INSERT INTO bki_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A tomu nalo bunu, bogo nonovio ajum̃a aberverii naio, napano nalo tealo ajum̃a aber naio be toro na bo tai, a tealo aber naio kirivova, naio jom̃a mila niegeniege m̃elea tomu nalo kialo jidomiano. ");
INSERT INTO bki_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ajum̃a aberverii Yesu jibe na, mia maka atum̃a averial naio ea vio medave, bior amerou ka ver kialo tomu na tortoru ajogio, mia ala titai kalo. ");
INSERT INTO bki_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mo nalo ajua jokoluolu banbano-o na, legiano tealo barlaka ruei, mia Yesu naio mial bo ka riva rivavin ea Atua Kunuano Lu ka riverloglog tomu nalo bereio. ");
INSERT INTO bki_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mia bogo na tomu na tortoru na kulo Ju nalo kialo amijog kiano verloglogiano novo nei, amiilo toru laka, aberinavo “Jum̃abe ana tete nei naio mijikia vatitig Atua kiano iliano jibe na? Naio maka rivan ea yimo na verloglogiano leleio, mia kiano verloglogiano kirinovo-o mia!” ");
INSERT INTO bki_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ana jibe na Yesu naio berial banlo, berinavo “Venia nam̃a nojom̃a nejiloglog ban kamiu, maka ve kiaku, mia be Teta na naio miila kiniou nebinimei ea yetemeriba nei kiano. ");
INSERT INTO bki_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ver toro tai saaro ka rila ga Teta kiano jidomiano, mia naio rila toro nene mijikia rivitii vatitig kanaku verloglogiano nalo. Mia toro nene naio mijikia rivitilubar ka kiniou maka noto neverloglog tomu nalo selia ga siaku, mia mijikia rivitilubar ka verloglogiano nalo nei, be riano laka ka amaluvo ea Atua. ");
INSERT INTO bki_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ver kito reial toro tai tom̃a rila iliano ea siano bereio, kito romijikia ka naio jom̃a midular naio ga rivavin. Mia ver toro na m̃a mil, midular kiano toro na toru siano napano miila naio binimei, romijikia ka naio be riano ga, naio maka tom̃a rilasibi. ");
INSERT INTO bki_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Toro tai na mila jibe nei be Mosis. Atua jian kiano tuboiano banio, naruei naio binimei jian ban kamiu, ana kamiu kumitum̃a kumila kokorovio ruei. Mia jum̃abe na kamiu kumisidom kuvuebin kiniou nam̃aro, bior kuberinavo namila korov tuboiano? Naio memedu jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Naruei tomu nalo aberdop̃e aberinavo “Jerei, vonganei kojom̃a komil vovu jibe ka sim̃aro tai joaso! Kei jidom rueso? Koverial vonio!” ");
INSERT INTO bki_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ana Yesu berdop̃e, berinavo “Nanua beamu nebinimei ea vio nei, nemila burum̃ara burutomoluo tai ea miremiu, nemieliel ka toro na be javuluku. Mia bogo na kumialio, maka kumisaaro kanio, kuberinavo kiniou nomim̃au bova ga ka napano nemila ea Legiano Lu. ");
INSERT INTO bki_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mo bo ka kamiu kuvilavon ka tiniemiu rimaio bunu ka bajago na pakuveu, javukia tormoruo Mosis naliko tormoruo dolu nalo na beamu ka naio, jibe ka Epraamo nalo, ajian ban kito. Naio bunu be im̃auano tai kiana, mia ver legiano na ala rijoru ea Legiano Lu, kamiu maka kuvisidomialio, na kumitum̃a kumila ga. ");
INSERT INTO bki_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kamiu kumitum̃a kuber maka kuvisidom kuvila korov Mosis kiano tuboiano, mia dam̃ariga kumijamo ka ala im̃auano na pakuveu ka Legiano Lu nei, naio bo ga na. Mo ver kamiu kumijamo ka nina, ana bior vaio ana kamiu tiniemiu mimi m̃ele jibe na ban kiniou bior kiri im̃auano sesa novo na kanaku na takurano ga nei, napano namila batitig kiri tavaliki nei niabeno bo bereio ea Legiano Lu? ");
INSERT INTO bki_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kiniou nemial jibe ka kamiu kumitum̃a kubitii vite nalo na jibe nei ea kulukuti ga, mia bo laka ka kuve masou kija, kuvilavonio ka kuvisidomii rivu vite nalo riva rivokar niamoiou.” ");
INSERT INTO bki_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ana ka bogo na tomu telabo na Yerusalemo amial ka napano Yesu jom̃a berloglog joomo ea Yimo Lu, mia nalo amiilo, aberinavo “Ierinio ga na! Toro nene kia ga nei navo, napano tomu na tortoru ajum̃a aber ajidom ka auebinio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Be naina jom̃a berial kiano iliano jibe na ga, naruei nalo maka bunu alavon ka ala titai ka leleio. Kito maka rejikia, p̃eli maka asidom ail vanio bior napano abitilubar batitigio ruei ka be riano ka toro nei, naio be kiado Naverikariano memedu. ");
INSERT INTO bki_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mia makanio, maka rejikia ka reverenio aver naio nina ga, bior napano kiado moneano tai ruei, ka Naverikariano, bogo na ver naio riyotuba, mia maka ve toro tai rijikia river naio joa vio be na binimei na. Mia toro nei Yesu, kito nonovio romijikia kiano vonuo ruei.” Nalo aber jibe nei, aber p̃eli Yesu abario jo Nasarete, mia makanio, naio abario jo Betleem. ");
INSERT INTO bki_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mo bior nalo ajum̃a aber jibe na, Yesu jaam̃i ka berlogloglo joomo ea Yimo Lu, naio berial iliano nei banlo, berinavo “Kamiu kuberiam̃a kumijikia kiniou, a kuberiam̃a kumijikia vio napano nebinimei eaio, mia nemial jibe ka maka kuvijikia batitigio rivu. Nebinimei ea vio nei, maka ea kiaku jidomiano, mia toro dolu tai miila kiniou nebinimei, napano naio be burupati na ilirianiano. Mia jibe ka maka kuvijikia kiniou, mia maka kuvijikia naio bunu. ");
INSERT INTO bki_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mia naio, kiniou naruei napano nemijikia naio batitigio bo, bior ka napano naio naruei miila kiniou nebinimei ea yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mia Yesu kiano iliano nalo na jibe nei mila ajikili lie vo ka monoka avokakar naio, ana maka ve toro tai leleio ka napano mijikia tokolio, bior ka napano kiano bogo maka rimei vo. ");
INSERT INTO bki_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ajidom aue naio, mia tomu nalo miroano laka amonea naio ruei, bior burutomoluo nalo napano jom̃a milaio. Aber jibe nei aberinavo “Ana mia Naverikariano na vabe napano mijikia rimei rila burutomoluo venia bereio tovulu naio? Makanio, tete nei naio be kiado Naverikariano memedu kiana.” ");
INSERT INTO bki_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mia Varisis tealo ajum̃a amiagago ka tomu nalo nam̃a amijakar Yesu ka kialo iliano nalo, mia amila sop̃eli, aba amil bija kulo lu na tortoru nalo, naruei abiorkar ka monoka ala titai ka Yesu vonganei ga. Ana amiila kialo kukuano nalo, ka ava asirago buluvio ka avokar Yesu, ka avuru naio rimei bere vanlo. ");
INSERT INTO bki_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ana Yesu berial, berinavo “Mia kiniou nemijikia noto vija kamiu bogo ve telisu ga bereio, karina navan bereio ea naio napano miila kiniou nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bogo napano navan bisi, mia kuvila von ka kuvisirag kiniou rivanvano-o, mia maka kuvijikia kuvileal kiniou. Vio napano mia nava notoaio, mia maka kuvijikia kumei eaio.” ");
INSERT INTO bki_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mo bogo napano tomu na tortoru na kulo Ju nalo kialo amijog iliano nei, abitovitonu eaio, ajum̃a aber kalo, aberinavo “Kema na jo ber vio be na, ka mia naio rivan ea karina mia kito rejikia re releal naio bereio eaio? P̃eli naio jidom rivan ea vio dolu nalo na yetemeriba napano kuruado Ju aburo aban ea ka bogo na burum̃ara vurubureiano, tenene na naio jidom riva riverlogloglo kija koviobo? ");
INSERT INTO bki_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mia naio ber venia na, ber mia kito resirag naio rivano-o mia kito releal re naio. Mia tum̃abe ea kiano iliano napano berinavo naio to rivan ea vio tai napano kito rejikia re ratakisorio, maka rejikia ravan eaio?” Mia ka bogo na, kukuano nalo maka avokar Yesu vo. ");
INSERT INTO bki_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Naruei amila jokoluolu nene bano-o, na binimei bokar legiano maariano nene, napano jibe ka legiano na toru nene. Mia bogo napano aju vio takurano, Yesu jumolu bio jikili jibe nei, naio berial berinavo “Kamiu kei na midou jer, bo naio rimei ea kiniou, rimunu uei na meuliano. ");
INSERT INTO bki_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Toro nam̃a monea kiniou, mia rivu laka vanio, tibe ka nam̃a Vivitauiano Lu naio berenio, napano berinavo ‘Toro na jibe na, mia tiniene rivujo ka uei na meuliano, rivano-o rio magmago lou ea naio bereio tibe ka uei nam̃a mieraro.’ ” ");
INSERT INTO bki_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mia Yesu kiano iliano nei, naio jijamerji ka Niununo Lu, bior ka napano naio mijikia ka iorou, nalo na m̃a amonea naio, mia avokar Niununo Lu. Mia ka bogo na, Niununo Lu naio maka rimei vo, bior ka napano Yesu naio jo kia navo ea yetemeriba nei, naio maka riva totano ea kiano vio lu na mave vo. ");
INSERT INTO bki_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mia bogo napano tomu nalo amijog Yesu bio jibe na, kialo jidomiano nalo ba beve dolu. Nalo tealo aberinavo “Toro na, naio be naverialiano jibe Mosis nam̃a kito romoneaio ka mia naio rimei.” ");
INSERT INTO bki_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tealo abeinavo “Nina, jibe na kovio, p̃eli na ver maka naio be kiado Naverikariano garuei.” Mia nalo tealo aberdop̃e, aberinavo “Makanio, maka iliano tai napano river Naverikariano mia rive toro Kalele tibe ka tete na. ");
INSERT INTO bki_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kiado Vivitauiano Lu ajum̃a aber ga mia Naverikariano mia naio riyotuba ea Parinio Tubo Teviti kiano yati, mia naio rive toro re Betleem.” ");
INSERT INTO bki_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mia jidomiano telabo ka naio jibe na banbano-o, mila na tomu nalo aburuburevurelo bior Yesu. ");
INSERT INTO bki_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mo tealo nalo maka lele asaaro ka naio, amial bo ka avuku naio rivan ea nalakoiano, mia iorou kanio maka tai kalo napano ava vaataro kanio ka avokario. ");
INSERT INTO bki_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mia iorou ka vite nalo na, kukuano nalo na Yimo Lu aban bereio ea kulo lu na tortoru bija Varisis nalo, ka asian veriiano rivanlo. Ana bogo napano amiyotuba ea miralo, tomu na tomormoruo nei maka aial Yesu, ana amil banlo, aberinavo “?Ana toro nene naio be napano numiila kamiu kanio? ?Bior vaio ana kamiu maka kuvuru naio rimei?” ");
INSERT INTO bki_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Naruei kukuano nalo nei aberdop̃e, aberinavo “Kumemi numiagago ka kiano iliano nalo abo mia abo, maka ve toro dolu tai napano mijikia riverloglog kito rivu tibe ka naio.” ");
INSERT INTO bki_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mia verdop̃eiano nei mila Varisis nalo amiilo kanio, aberinavo “!Tomnei, vonganei kamiu bunu, kema na buru kenemiu jidomiano ba be vovu! ");
INSERT INTO bki_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kamiu kumijamo ka naio milasibilili kamiu, mia jum̃abe, kamiu kumial ea kumemi tomu na tortoru p̃eli na ea kumemi Varisis, be tai napano amonea naio? Makanio. ");
INSERT INTO bki_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nalo ga nam̃a amoneaio, nina be taara kirivova dedade nalo na, mia nalo na maka ajikia vite. Maka ajikia batitig kiado tuboiano rivu, Atua berkar iliano va ka kialo vironiano ruei.” ");
INSERT INTO bki_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ajum̃a amil jikili jibe na, mia nalo tai milavio jikili ka rila kialo iliano rivatove bereio. Nina be Nikotimas, napano nua beamu ea bogiano tai, naio ba jukunu bija Yesu. ");
INSERT INTO bki_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Naio ber kalo, berinavo “Kito rojum̃a romil ea toro na jibe na, javukia napano rojum̃a rejibure naio ruei. Mia kiado tuboiano berbure nina, naio ber ver kito rosidom reil van toro tai, kito monoka rotutano ea komeli kitoliko, monoka rodu bogo rivanio ka naio riverial kiano jidomiano van kito, ka kito monoka rovika vikadeniano nalo ka releal ka be riano naio mila jibe na p̃eli na jum̃abe. Nina naruei m̃arabo na ala im̃auano memedu.” ");
INSERT INTO bki_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mia maka asidom aiagago ka kiano iliano nei, bior amial ka napano naio mikurukar Yesu. Amil banio, aberinavo “!Tomnei, jau kojom̃a komil jibe na jau bunu kobe toro Kalele tai bereio! Kosidomii vatitig rivu ka venia napano Iliano Lu berenio. Maka leleio ve iliano tai napano riverial ka mia naverialiano vou tai naio tumolu rove yako Kalele rimei mave ea vio nei.” ");
INSERT INTO bki_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Naruei kialo iliano nalo ba birankakario ea vio na ga, karina nalo abeve terakurano abanvan bereio ea kialo vonuo nalo. ");
INSERT INTO bki_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Naruei Yesu juvan Yimo Lu, naio miel ban bereio ea Suku Na Buruolivi. ");
INSERT INTO bki_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Naio mon ea vio na-o viomijeni kon naio, ana kavijo naio ban bereio ea Yimo Lu na Atua Kunuano. Bogo napano tomu nalo amial naio, nalo telabo abinimei eaio, naruei naio jotano jom̃a berlogloglo. ");
INSERT INTO bki_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mia maka vesiou, naverloglogiano na tuboiano bija Varisis nalo, aburu tira tai binimei eaio, amila naio jumolu jua mirano na tomu nalo. Tira nene, aju abokar naio jibe na bior aberenio naio mila siakaiano bija toro tai, mia nalo tai amial, aberialio. ");
INSERT INTO bki_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ana amila naio jumolu ju jibe na, amil ban Yesu, aberinavo “Naverloglogiano, tira nei amileal naio jom̃a mila siakaiano. ");
INSERT INTO bki_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mia jibe ka napano Mosis kiano tuboiano berenio ea tivelinio na kariano nei, vonganei naruei kumemi monoka nuvitubabinio ga rim̃aro. Mia tuboiano na Romo berenio be lu ka nuvitubabin toro. ?Mia jum̃abe ka jau, kiamo jidomiano jum̃abe?” ");
INSERT INTO bki_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Naruei vikadeniano nei, maka avika masosoua den Yesu, mia ajum̃a aburu vonvonio, ka naio river belbeleia titai napano mia iorou kanio ana amijikia atibure naio riviorio. Mia Yesu naio maka riverdop̃e, naio maka river vite tai, mia jurubanini ga, bitiri m̃artukuji na jum̃ano naio bivitauia iliano tai ea borotano. ");
INSERT INTO bki_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ana ajum̃a abivika denio jum̃abe ka tira neibano, ana Yesu barlar naio bereio, mil banlo, berinavo “Mo, ver kamiu tai napano maka lele ve kariano tai toa kiano meuliano, mia naina rivuku puruveru na tukamu, tuba tira nei.” ");
INSERT INTO bki_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Vaarakurano bereio, naio jurubanini batove, bivitauia iliano dolu tai ea borotano. ");
INSERT INTO bki_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mia bogo napano amijog venia napano Yesu ber kalo, ajikar ka abeve terakurano abanvan bereio. Na naio jukamu, be kialo tormoruo tai, mia iorou ka naio, nalo dolu bunu aburu dedade ealo beve terakurano, o-oa ka tira nei ga jumolu ju ea Yesu mirano. ");
INSERT INTO bki_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mia Yesu bitikar naio bavin, naio bika berinavo “?Tira, nalo napano aju be? ?Maka bunu nalo tai sidom tibureso?” ");
INSERT INTO bki_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ana tira neibano naio berdop̃e, berinavo “Tubo, maka bunu toro tai.” Mia Yesu berenio berinavo “Bo ga, mia kiniou bunu natiibureso re. Jau komijikia kava vonuo bereio ga, mia kola re bunu kariano bereio.” ");
INSERT INTO bki_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mo iorou kanio ana na Yesu mil banlo bereio, naio berinavo “Kiniou nebe yulu na yetemeriba, toro kei napano takisor kiniou, mia naio riel re bunu ea melijokouo, ana mia yulu na meuliano toa naio.” ");
INSERT INTO bki_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mia Varisis nalo tealo napano aju kia navo abukular kiano iliano bereio, aberinavo “Jau kober jibe na, jau ga bereio komiija kanamo iliano, jau kojom̃a komidular jau bereio bavin. Tibe na, kumemi maka nuvijikia numoneaso, kanamo iliano maka ve riano ga.” ");
INSERT INTO bki_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ana na Yesu berinavo “P̃eli namila jibe na kovio, mia kiaku iliano nonovio p̃eli kiaku verloglogiano abe riano laka. Kiniou nemijikia nonovio vite na tivelinio ea kiniou, ka kiniou nojo be na nebinimei ea vio nei, p̃eli na nojo nei ka mia nava be bereio, mia kamiu maka kumijikia lele tivelinio na kiniou. ");
INSERT INTO bki_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kumitum̃a kumitibure kiniou ea jidomiano na toro, mia kiniou maka netibure toro leleio. ");
INSERT INTO bki_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mia ver bogo tai netibure tomu nalo, mia kiaku tibureiano naio rimemedu ga, bior napano kiniou re ve takurano nalaio, mia kumemi juo naina napano miila kiniou nebinimei, kumemijuo nuvila buronio. ");
INSERT INTO bki_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","“Mo ea kenemiu tuboiano, abivitauia jibe nei berinavo ver ve tomu ve juo aikurukar iliano tai, mia kamiu kumoneaio, ");
INSERT INTO bki_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","naruei mia monoka tibe na bunu ea kumemi juo Teta. Kiniou neber kiniou nebe riano, a naio mikurukar kiniou, mila na vonganei kamiu monoka kumonea kiniou.” ");
INSERT INTO bki_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nalo amijog iliano nei, naruei abika denio, aberinavo “Jau kojom̃a kober karam̃amo na, mia naio jo be vonganei?” Ana na Yesu berdop̃e, naio berinavo “Kamiu maka kuvijikia naio, jibe ga napano maka kuvijikia kiniou. Ver kumijikia batitig kiniou rivu, mia rila kamiu kuvijikia vatitig naio bunu rivu, a maka kuvijikia kuvika vikadeniano tibe na, ana makanio.” ");
INSERT INTO bki_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iliano nalo nei, Yesu berlogloglo ea Yimo Lu, nina ea tivelinio na naio, vio be na mia avar vatitig kiano ijaiano na veru nalo napano ajuvan ban Atua. Ana ea bogo nei, maka ajikia avakar naio, bior maka kiano bogo vo. ");
INSERT INTO bki_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ana Yesu berial bunu jibe na banlo, naio berinavo “Kiniou nava kovio den kamiu naruei. Bogo na ver nava kovio varlaka, mia kamiu kuvisirago kiniou, rivano-o mia kuvial re kiniou, mia kum̃arm̃aro vija kenemiu kariano nalo. Kiniou navan ea vio tai napano mia maka kuvijikia kumei eaio.” ");
INSERT INTO bki_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Telikiti napano tomu na tortoru na kulo Ju nalo amijog iliano nei, abika aberinavo “?Kema na naio jidom rila venia? Naio ber mia naio rivan ea vio tai na kito maka rejikia ka ravan eaio, p̃eli na naio ber mia rila kuku naio rim̃aro bereio bo?” ");
INSERT INTO bki_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ana na Yesu berenio berinavo “Kenemiu jidomiano a kiaku jidomiano abe dolu laka. Kamiu kube na vio yetano nei ga, mia kiniou nebe na vio mave, kamiu kube na yetemeriba, kiniou maka neve kiano. ");
INSERT INTO bki_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ana jibe ka napano kiniou neber ruei, mia kum̃arm̃aro ga rivija kenemiu kariano nalo. Ver kumonea re kiniou ka kiniou nebe naio napano jo jobo jo, mia monoka tibe na ga.” ");
INSERT INTO bki_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ana nalo abika, aberinavo “Abe jau kover vonio bereio, ka jau kobe kei.” Ana na Yesu buku bere iliano banlo, naio berinavo “Kiniou nebe naio ga napano nanua jikar beamu ruei binimei bokar vonganei, kiniou nojo neber kiniou nebe naio ga. ");
INSERT INTO bki_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Naina ga kiniou nojom̃a neber tivelinio na kiniou. A tivelinio na ea kamiu, ve vite miroano napano nemijikia neverenio, mia p̃eli ver neverenio, a be iliano na tibureiano nonovio. Ana vite nalo napano nojom̃a neberial ea yetemeriba nei, naio be iliano nalo ga napano nomijog den naio napano miila kiniou, bior dam̃ariga, kiano iliano nalo amemedu laka.” ");
INSERT INTO bki_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu bisi meravo ga jibe nei, berii karam̃ano na mave banlo, mia maka ajikia leleio. ");
INSERT INTO bki_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Naio mil bereio banlo, naio berinavo “Telikiti napano kuvitelan kiniou Kulorinio Kenerinio mave ea iesi m̃akolkolo bisi, mia kamiu kumijikia ka kiniou nebe kenemiu Naverikariano. Mia kamiu kuvitilubar ka napano vite nonovio nam̃a namilalo, maka nala kiniou ga ve takurano, mia dam̃ariga neber ga venia nam̃a Teta naio berloglog ka kiniou. ");
INSERT INTO bki_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Naio naruei napano miila kiniou nebinimei, a naio jo bija kiniou vonganei. Naio maka leleio tuvan kiniou bogo tai, bior dam̃ariga nojom̃a namila vite nonovio jibe ka ga nam̃a naio jaaro kanio.” ");
INSERT INTO bki_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesu naio jom̃a mil jibe na, kiano iliano nalo aburu kulo Ju telabo amonea naio. ");
INSERT INTO bki_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu mil ban nalo na amonea dovorovo ea naio, naio berinavo “Ver kamiu kuvokar sikili kiaku iliano, kuvitum̃a kuviduio, kamiu kuve kiaku naiagagoano riano nalo. ");
INSERT INTO bki_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mia kamiu kuvijikia ilirianiano, naruei mia ilirianiano rila m̃arimieni nalo atibirbili den kamiu.” ");
INSERT INTO bki_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nalo aberdop̃e banio, aberinavo “Ai, abe kumemi nube tormoruo Epraamo kiano yati nalo, maka numitum̃a numim̃au kurano ea toro na toru dolu tai. ?Mia jum̃abe ana jau koberinavo mia m̃arimieni nalo atibirbili den kumemi?” ");
INSERT INTO bki_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu berdop̃elo, naio berinavo “Kiniou neber riano ban kamiu, tomu nonovio napano m̃a amila kariano, nalo abe tomu nam̃a aju amim̃au kurano bior kariano, m̃arimieni na kariano miadikarlo jikili. ");
INSERT INTO bki_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kamiu kumitum̃a kumim̃au kurano ga bior toro na toru na kariano kanano, mia kamiu maka kuve kiano m̃aratavo. Mia kiniou, notobo rivija karam̃aku, bior kiniou nebe kiano m̃aratavo memedu. ");
INSERT INTO bki_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kiniou nebe tete na mave, mia ver novulu bulag kamiu, mia kamiu bunu kumijikia kuvitu dam̃ariga vija kiniou ea vonuo na mave.” ");
INSERT INTO bki_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ana Yesu ber bunu ka tomu nalo, naio berinavo “Kiniou nemijikia vatitig ka napano kamiu kube tormoruo Epraamo kanano yati nalo memedu, ana Epraamo kanano yati nalo nei naruei napano bo ka ver asaaro ka kiniou. Mia makanio, kamiu tealo kube yati nene nalo naruei napano kiaku iliano maka totano batitig rivu ea kenemiu iviso, naruei kumisidom toru ka kuvue bin kiniou nam̃aro. ");
INSERT INTO bki_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Bo ka kamiu kumonea kiaku iliano nalo, bior kiniou nojom̃a neberial ga venia napano kiniou nemial bogo napano nojo bija Teta, mia kamiu kumitum̃a kumila ga venia nam̃a kumijog karamemiu naio berenio.” ");
INSERT INTO bki_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mia aberdop̃e, aberinavo “Riano ga, bior karamememi tormoruo buo Epraamo re nua nua laka.” Ana na Yesu berinavo “Maka leleio! Ver kamiu kube tormoruo Epraamo kenerinio riano, mia bo ka kamiu kija kuvitum̃a kuvila von ka kuvila vite nalo avu tibe ka nam̃a naio milaio. ");
INSERT INTO bki_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ana makanio, kamiu kumitum̃a kumila vite kirivova laka. Jibe kiniou, nebe toro tai nam̃a nojom̃a neberial ga ilirianiano nalo napano nomijog Atua naio ber ka kiniou, mia kamiu kumitum̃a kumisidom kuvuebin kiniou nam̃aro. ?P̃eli kamiu kuberiam̃a bajago na naruei napano kenemiu tormoruo Epraamo tinien jii ka kuvilaio? ");
INSERT INTO bki_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Makanio, kiniou nemial jibe ka maka naina, mia be karamemiu dolu tai napano naio jo, kamiu kumim̃au kiano.” Mia nalo aberinavo “!Jerei, venia na! !Kojidom kala kumemi nuve tete na m̃arabo nalo, kumemi maka nuvijikia karamememi! Karamememi takurano riano ga naio jo, naina be Atua.” ");
INSERT INTO bki_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ana na Yesu berinavo “Ver iliano na be riano, ka Atua naio be karamemiu, mia kamiu monoka tiniemiu tii kiniou ve toru mia, bior ka kiniou najaluvo den naio nebinimei ea vio nei. Kiniou maka nemei tibe ka napano kiniou ga, mia naio naruei miila kiniou nebinimei. ");
INSERT INTO bki_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kiniou nojom̃a neberii vite nalo na ban kamiu banbano-o kiride ga, mia dam̃ariga kamiu maka kumijikia leleio. Kiniou maka nejikia den kamiu, bior vaio ana maka kuvisidom ka kuvokar vatitig rivu kiaku iliano na? ");
INSERT INTO bki_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kamiu, karamemiu Sim̃aro, a kamiu tiniemiu jii ka m̃a kuvila tena bova tibe ka ga napano naio jidomio. Jikar nua ea tikariano binimei, naio be toro nam̃a muebin toro m̃aro a naio maka tinien tii ilirianiano, naio maka tumolu tua tivelinio ka naio leleio. Bajago na memedu na kiano, naio mil dam̃ariga ea burum̃ara kenieno sibiano nei, bior naio be burupati na sibiano nalo nonovio, naio be teta na bajago na sibiano. ");
INSERT INTO bki_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naio jibe nei, mia bogo napano kiniou nebinimei, neberial ilirianiano novo nalo ban kamiu, mia karina kamiu maka kuvisidom kumonea kiniou bereio. ");
INSERT INTO bki_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mia kamiu kei na naio mijikia riverial kiaku beleano tai? ?Mia ver kumial ka nemil be riano, bior vaio ana maka kumonea kiniou? ");
INSERT INTO bki_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","“Toro na be Atua kanano, naio jo miagago vatitig ka Atua kiano iliano. Mia kamiu na ver kamiu maka kuvisidom ka kuvijog kiano iliano nalo, nemijikia ka nina bior kamiu maka kuve kiano leleio.” ");
INSERT INTO bki_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mia Yesu kiano ilisikiliano nalo nei mila tomu na tortoru na Ju nalo amijog bova, ana nalo abika denio, aberinavo “Kumemi numijog aber jau maka kove Ju rimemedu na, jau kobe niabe leri na Sameria ga tai. Ana kumemi numial napano sim̃aro tai joaso, naio jom̃a milaso kobe kodovo kija. ?Iliano nalo na abe riano, p̃eli na makanio?” ");
INSERT INTO bki_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ana na Yesu berdop̃elo, naio berinavo “Makanio, maka ve sim̃aro tai toa kiniou. Vite nalo nam̃a nojom̃a nemilaio, nemila ka karam̃aku siano rivavin. Vite nalo nam̃a kamiu kumilaio ka kiniou, kumila ka siaku vatove. ");
INSERT INTO bki_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nina maka ve titai ea kiniou, bior ka napano kiniou maka noto noim̃au ka nala siaku rivavin. Mia be toro na toru jo napano naio jidom ka tom nalo bo ka atovon kiniou, mia naio ga ve takurano tibure vite nonovio ea tivelinio na. ");
INSERT INTO bki_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mia be iliano tai napano be riano napano nemijikia never ka kamiu jibe nei, ka ver kamiu tai rivokar kiaku iliano sikili, naio rudukario, mia naio maka rijikia rial nam̃ariano bogo tai.” ");
INSERT INTO bki_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ana Ju nalo amijog iliano nei, aber ka naio, aberinavo “Vonganei numijikia batitig ka Sim̃aro joaso ruei. Jau kober toro napano tovonso mia naio maka rijikia rim̃aro, mia ve re toro tai napano mia maka rim̃aro bogo tai. Tormoruo Epraamo naio meul banbano-o karina naio m̃aro, a naverialiano nalo bunu amim̃au banbano-o karina am̃arm̃aro. ");
INSERT INTO bki_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?P̃eli na jau komialso jau loa laka ka kiado tormoruo lu nalo a? ?Jau koberiam̃a jau kobe kei bereio, m?” ");
INSERT INTO bki_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ana na Yesu berdop̃e, naio berinavo “Ver kiniou neverial ka kamiu, p̃eli kumial jibe na ka napano nomidular siaku bavin bereio, mia kamiu kuvial rivova. Toro dolu tai ga napano m̃a jo mila siaku bavin, nina naio napano m̃a kuber naio be kenemiu Atua, naina be karam̃aku. ");
INSERT INTO bki_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Naio, kamiu maka kuvijikiaio, mia kiniou nemijikia batitig naio. Kiniou maka nala sibi tibe ka kamiu, neber vatitigio ga na, ka kiniou nemijikia batitig naio bo, a kiano iliano nonovio, nemije batitig bo monea kiaku meuliano. ");
INSERT INTO bki_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nemijikia never bunu ka korobimiu tormoruo Epraamo, naio tai napano jidom toru ka rial kiaku bogo nei. Naio jidom rial ka kiniou noyotuba ea kiano torogio, nemei nala kiaku im̃auano nei, a bogo na naio rialio bisi, mia naio saaro mia saaro.” ");
INSERT INTO bki_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ana Ju nalo abika naio aberinavo “Jau maka kove tormoruo tai tibe naio vo, kanamo yuka maka rivokar duelimo va limo 50 vo. ?Ana na jum̃abe ana jau kojom̃a kober jau komijikia tormoruo Epraamo re nua nene? ?Jau komial kovio tai?” ");
INSERT INTO bki_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ana Yesu naio berdop̃elo, naio berinavo “Kiniou neber riano ban kamiu, ka tormoruo Epraamo re nua nei, kiniou nojukamu laka ka naio. Bogo na naio maka vo, mia kiniou nebe naio napano jo beamu ruei.” ");
INSERT INTO bki_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ana telikiti napano kulo Ju nalo amijog ka napano Yesu jom̃a ber kiri iliano telisu neibano, napano naio jibe ka Atua siano lu tai, ana amijikia ka naio jo ber naio be Atua, mia nalo tiniel mimi toru. Naruei ajirag puruveru ka atuba Yesu rim̃aro, mia naio juvan naio bena ga denlo, juvan Yimo Lu ba tavio bereio bano. ");
INSERT INTO bki_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ana kumemi naiagagoano nalo kumemi liko Yesu numiel nubano, naruei bogo na numitum̃a numiel nuban jibe na, numial toro tai napano bogo na naio miyotuba, naio be merebono. ");
INSERT INTO bki_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mia nubika den Yesu, nuberinavo “?Naverloglogiano, venia mila kema na? ?P̃eli mauo na kiano kariano ga, p̃eli na mauo na kenieno naio karam̃ano kialo, mila naio be merebono jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ana Yesu berdop̃e naio berinavo “P̃eli ga, naio maka ve kiano kariano, a maka ve kariano na kiano tormoruo juo kialo, mia naio miyotuba jibena ka rila ga ka mia tomu nalo amijikia aial moroano na Atua kiano rim̃au ea kiano meuliano. ");
INSERT INTO bki_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jibe na, mia nalarur naio vonganei, bior bogo napano viomijeni kia ga vo, kito monoka roim̃au sikili, monoka roim̃auka naio napano miila kiniou nebinimei ka kiano im̃auano nalo. Melijokouo jo binimei, napano kito maka bunu rejikia roim̃au eaio. ");
INSERT INTO bki_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mia vonganei, kiniou nojo yetano ea vio nei, kiniou nebe yulu na yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu naio ber jibe na bisi, ana naio buvulei ea bulukievi na borotano, naio monkorkor batove mila kitkiti titinio melmeloko jibe bulukinia, karina naio bijan ea toro neibano mirano be juo. ");
INSERT INTO bki_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ana naio mil banio, naio berinavo “Mo, jau kavano, kavatove ea bulukuei na Sailomo, kesekon batitig bereio miramo.” Uei napano Yesu berkanio, siano naio berenio “uei na riila rivano.” Ana toro nene naio batove, mila jibe na, mia mirano abinimei abo. Ana naio binimei bereio kean kumemi bija Yesu, napano naio mijikia bitilubar vite nonovio bo. ");
INSERT INTO bki_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ana iorou, nalo na vaataro ka toro nei, bija nalo nanua beamu amial naio jom̃a miogiog, amial naio bereio, mia aberenio aberinavo “?Merebono m̃a na naina p̃eli, napano beamu jom̃a miogiog sano janea vio dam̃ariga na, p̃eli na maka ve naio?” ");
INSERT INTO bki_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mia nalo tealo aberinavo “Nao, naio ga na,” a tealo aber “Ee, toro dolu ga na napano midu mirano,” mia toro nene naio ga berial meravo banlo, berinavo “Kiniou nene nei.” ");
INSERT INTO bki_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mia bogo napano berial naio banlo jibe na, ana abika denio, aberinavo “Jum̃abe ana miramo bo bereio jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mia naio berdop̃elo, berinavo “Toro m̃a na Yesu, naio naruei mim̃aukanio. Naio mila kitkiti bulukinia telisu ea titinio, naio miaia jeleig miraku, ana naio berenio navatove ea uei na Sailomo, nesekonio bulag den miraku bereio. Mia nemila ga jibe na, nabatove, nejekon miraku, namial jibe ka tinia miraku bo naruei.” ");
INSERT INTO bki_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ana nalo abika Yesu denio, aberinavo “?Mia toro nene naio jo be vonganei?” Naio berdop̃elo berinavo “Maka nejikia, maka bunu naialio.” ");
INSERT INTO bki_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ana iorou, aburu toro neibano beamu mirano bono ba ban Varisis nalo ka amijikia aialio. ");
INSERT INTO bki_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aburu naio ba jibe na bior napano legiano napano Yesu milarur toro neibano mirano eaio, naio be Legiano Lu tai, mia nalo aberinavo p̃eli Yesu mila im̃auano tai napano tuboiano na legiano nei naio berbureio. ");
INSERT INTO bki_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Telikiti napano abinimei aberial ka Varisis nalo, abika den toro nene, aberinavo “Mo, jau kija kala vonio ka kover jum̃abe ana miramo binimei bo.” Ana naio ber ga jibe nei, naio berinavo “Maka, toro nene bijan bulukinia melmeloko telisu ea miraku, avona bisi ana nabano nejekon bulagio bereio ga, ana kiniou nemijikia nemial vite nonovio bo.” ");
INSERT INTO bki_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Telikiti na Varisis nalo amijogio, tealo aberinavo “Toro nam̃a mila tena, naio mila jibe na naio maka rialerinio ea tuboiano na Legiano Lu. Jibe na naio maka taluvo den Atua rimei.” Mia tealo dolu aberenio aberinavo “P̃eli ga, ver be riano ka naio be toro va tai napano mila korov tuboiano, jum̃abe ana naio mijikia mila burutomoluo novo nalo jibe na?” Ana nalo aberii jibe na bano-o, mila na ajua jidomiano juo biorio. ");
INSERT INTO bki_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ana nalo abika bereio den toro nei napano beamu naio mirano miunu, aberinavo “?Ana jau, jau na naruei napano naio mim̃auka miramo, mia jau kover venia tivelinio ea toro neibano?” Naruei naio berdop̃e memedu ga banlo, berinavo “Naio be naverialiano riano tai.” ");
INSERT INTO bki_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Naio ber jibe na, mia tomu nalo na tortoru na Ju nalo maka amonmonea veriiano na, maka amonmonea ka beamu toro na mirano bono, vonganei naio mijikia jirarag. Karina abio karam̃ano a kenieno abe juo ka amei aialo. ");
INSERT INTO bki_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Telikiti naljuo abinimei, abika denlo, aberinavo “Kuvitii vatitig toro na vonio. ?Nina be kenerimiu memedu, napano aberinavo naio miyotuba naio be merebono, p̃eli na maka ve naio? ?A ver be naio, jum̃abe ana mirano binimei bo bereio jibe na?” ");
INSERT INTO bki_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Naruei aberdop̃e, aberinavo “Kumemi numijikia ka naio be kenerimemi, numijikia ka bogo napano nubario binimei bokar vonganei, naio be merebono batitigio. ");
INSERT INTO bki_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mia kumemi maka nuvijikia jum̃abe ana naio mijikia mial vite nalo vonganei, kumemi maka numijikia keinia napano mila mirano binimei bo bereio jibe na. Mia bo ka kamiu ga kuvika vonio, naio maka ve tete na, naio mijikia mil.” ");
INSERT INTO bki_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tom juo na amil jibe na, ajuvan kija ga kialo jidomiano, bior ka napano tomu na tortoru na kulo Ju nalo aberiio ruei aberial ka toro kei napano naio rimonea ka Yesu be Naverikariano, mia avukular naio tusolo re bunu ea Atua kunuano lu. ");
INSERT INTO bki_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aberial jibe na, na tomjuo nei amerou, mila aberinavo maka ajikia ga, aberinavo “Bo ka kamiu kuvika naio ga, naio maka ve tete na.” ");
INSERT INTO bki_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ana vaarakurano bereio, abio bere merebono nei nua naio binimei joomo keanlo. Naio ba joomo naruei amil jikili banio, aberinavo “Jau kover Atua na mave siano, jau koverial vite nonovio na be riano ga van kumemi, bior vonganei kumemi numileal ruei ka kema na naio be toro kirivova na lakoroviano na tuboiano.” ");
INSERT INTO bki_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ana toro nei naio berdop̃elo, naio berinavo “Naio be toro na bo p̃eli maka ve toro na bo, kiniou maka nejikia. Vite takurano ga na kiniou nemijikia, jibe ka. Nua beamu, miraku bono batitigio, mia vonganei kiniou nemijikia nemial vatitig vite nonovio.” ");
INSERT INTO bki_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mo nalo abika aberinavo “?Mia ver tibe na, naio mim̃au kaso jum̃abe? ?Naio mila batitig miramo jum̃abe?” ");
INSERT INTO bki_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ana toro nei berdop̃e, berinavo “Kiniou neber bisivisii vatitig bo vite nonovio ban kamiu vaarakurano ruei, mia kamiu maka kuvisidom kuvijogio, ana vonganei kumisidom kuvijogio bereio. ?Kar venia? ?P̃eli tiniemiu jii ka kamiu bunu kumei kuve kiano naiagagoano nalo na?” ");
INSERT INTO bki_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Naio ber jibe na, jibe ka naio miyotel ealo kija telisu, mia nalo tiniel jer m̃elea naio, amil jikili banio, aberinavo “!A! Jau ga kove kiano naiagagoano, kumemi nube naiagagoano nalo na tormoruo lu Mosis kiano. ");
INSERT INTO bki_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mosis nei, kumemi numijikia batitigio bo ka be riano ka Atua berial kiano iliano nalo banio, mia tivelinio ka toro dolu na, kumemi maka nuvijikia naio, ka naio be toro na vio be p̃eli na naio binimei jum̃abe.” ");
INSERT INTO bki_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naruei toro nei naio berdop̃e, naio berinavo “!Tomnei, kiniou nemiilo va ka kamiu ka napano maka kuvijikia naio! Naio jom̃a mila burum̃ara im̃auano nalo jibe na, banbano-o na naio mila batitig miraku, mia kamiu maka kuvijikia ka naio be kei p̃eli na naio be toro re be. ");
INSERT INTO bki_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kito romijikia ka ver toro va naio rivio van Atua, mia Atua maka rijikia riagago kanio, mia ver toro na be toro nam̃a milotu ka naio a napano jom̃a mijogkario, ver naio rivio naio, mia naio riagago kanio. ");
INSERT INTO bki_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mia toro nene, Atua jom̃a miagago ka naio, bior jikar ea tikariano na yetemeriba nei binimei bokar vonganei, maka lele aial toro tai rilarur bereio toro napano naio miyotuba mirano bono. ");
INSERT INTO bki_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kema na naio monoka jaluvo ea Atua ga binimei ea vio nei, ver p̃eli naio rijikia re rila vite tai leleio tibe na.” ");
INSERT INTO bki_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mia maka lele asaaro ka napano toro nei mil banlo jibe nei, aberinavo “Tomnei, jau, jau toro kiriniagiago laka. Jau komiyotuba bija bajago na kariano ga, binimei bokar vonganei. ?Mia jau kobe kei koberiam̃a komijikia koverloglog kumemi bereio, ee kamali?” Amil niegeniege naio banbano-o na, amijil lar naio batavio bereio. ");
INSERT INTO bki_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mia maka vesiou Yesu naio mijog ka napano amijil lar tete nei jibe na, mia ba milealio, bika denio, berinavo “?Jum̃abe? ?Vonganei jau komonea Kulorinio Kenerinio ruei p̃eli makan vo?” ");
INSERT INTO bki_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mia toro nei naio bika den Yesu, naio berinavo “?Ana naina kober na, naio be kei? Ver jau komijikia koverialio ka kiniou, mia nemijikia nomonea naio ga.” ");
INSERT INTO bki_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ana Yesu berdop̃e, naio berinavo “Jau komial naio ruei, jau komial naio vonganei. Kiniou ga nene nei, nam̃a nojo nemil bijaso nei.” ");
INSERT INTO bki_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ana naio berdop̃e, berinavo “Aiou Tubo, ver tibe na, kiniou nomoneaso vodolu.” Ana toro nei jidel dolu ka miaia Yesu. ");
INSERT INTO bki_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ana na Yesu mil, berinavo “Kiniou nebinimei ea yetemeriba nei ka nevitii tomu nalo, ka rila meravo ka tomu nalo nam̃a abe merebono, amijikia aial vite, a ka tomu nalo nam̃a aberiam̃a amijikia amial vite, ajikia ka abe merebono ga.” ");
INSERT INTO bki_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mia Varisis tealo aju vaataro ga, amijog iliano nei, abika den naio aber “?Ana jau kober kumemi bunu nube merebono a?” ");
INSERT INTO bki_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ana Yesu berdop̃e, berinavo “Ver ve riano ka kamiu kuve merebono naio bo ga, kamiu kuvijikia re kuvar vironiano riviorio. Mia bogo napano kumitum̃a kuberinavo kamiu kumijikia kumial batitigio vite nonovio, burum̃ara beleano na joa kamiu ruei.” ");
INSERT INTO bki_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ana Yesu naio mil lie vo, naio berii jamerijiano tai banlo, ka tivelinio na burusio na nunu, napano ajum̃a amim̃au vei ka napano mia nunu na tomu ve telabo kialo amijikia atu amon jouro eaio. Naio berenio jibe nei, berinavo “Kiniou neber be riano ka kamiu, ka toro nam̃a maka selia morouo ka riva jouro ea burusio na nunu nalo, mia naio mijaloa burusio, toro na jibe na naio be toro va na vinauano ga. ");
INSERT INTO bki_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mia naio napano m̃a jeljel ea morouo nam̃ariga memedu, naio naruei be toro na be riano na bitikar nunu. ");
INSERT INTO bki_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ver adu toro tai to ka m̃a riviti kuku ka morouo, mia bogo na toro na bitikar nunu rimei, mia morouo mijikia rivetavo ga ka naio, mia bogo napano naio ba jouro, nunu nonovio abiniu amijog joono, mia naio bio nalo na ga abe kiano sialo, mia nalo nei ga ajumolu, naruei naio jukamu kalo abava tavio. ");
INSERT INTO bki_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Telikiti napano naio jukamu kalo abatavio bisi, naio miel jukamu kalo, ana nalo amiel iorou ka naio abano, bior ka napano amijikia vatitig joa na joono. ");
INSERT INTO bki_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nalo maka ajikia ala tibe na ka valauo tai, mia nalo amerou ga kanio, bior napano amijog lubar dede joa na toro dolu joono.” ");
INSERT INTO bki_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jamerijiano nei Yesu ber kalo, mia maka ajikia yati nene. ");
INSERT INTO bki_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jibe na, mia Yesu mil lie vo banlo ea tivelinio na burusio na nunu, naio berinavo “Kiniou neber riano ka kamiu, ka morouo na burusio na nunu nalo, kiniou nene nei. ");
INSERT INTO bki_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kulo dolu nam̃a abinimei jukamu ka kiniou, nam̃a amila sibi aber mia avitikar vatitig nunu nalo, abe tomu kirivova na vinauano ga, a bogo nam̃a aba amiyotuba ka nunu nalo, nunu nalo maka ajogilo. ");
INSERT INTO bki_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kiniou ga nebe morouo na burusio, toro na rimei selia kiniou ga, mia kiniou nevitikar vatitig kiano meuliano. Mia naio mijikia rivatavio ka sirago sano sinaniano, karina mijikia rimei rimon jouro ka bogiano, naio mijikia rimei rivan tibe na rivu ga. ");
INSERT INTO bki_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Toro na vinauano naio binimei ka rivuru bulag bena nunu, p̃eli na rue binvinlo am̃arm̃aro, p̃eli na ka rila lelanlo ve toru ga, mia kiniou nebinimei ka ajikia avokar meuliano, ka amijikia asaaro ka meuliano tai napano rivu laka rivanlo.” ");
INSERT INTO bki_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","A Yesu ber bunu, naio berinavo “Kiniou nebe toro na vitikariano na bo na nunu nalo. Toro na bitikar batitig nunu nalo, naio monoka saaro ka rijamo ka kiano meuliano ka rilarur nunu nalo kialo meuliano. ");
INSERT INTO bki_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ver toro na im̃auano ga tai, naio maka rijikia rivitikar rivu nunu nalo tibe na, naio maka tinien tiilo tibe na, bior maka ave kiano nunu nalo. Ver bogo tai naio rial burum̃ara kuli deden amei rivior nunu nalo nei, mia naio rimerou ga, naio tumolu rivuro, naio tuvan nunu nalo atubo ga, naruei mia kuli deden nalo nene abinimei ajer lo ana amlabulag lo, ana amjilo aburo aba dedade. ");
INSERT INTO bki_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Toro nei buro den nunu nalo jibe na, bior naio be toro tai napano mim̃auka kiano veru ga, mia naio maka rialerinio ea nunu nalo leleio. ");
INSERT INTO bki_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Mia kiniou, nebe toro na nabitikar batitig bo kiaku nunu nalo. Kiniou nemijikia batitig bo nalo napano abe kiaku, a nalo bunu amijikia batitig kiniou bo. ");
INSERT INTO bki_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kumemi numijikia batitig kumemi javukia napano kumemi juo Teta numisidom batitig kumemi juo bo. A kiniou tinieku jii kiaku nunu nalo bare ka najamo ka kiaku meuliano riviorlo. ");
INSERT INTO bki_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A kiaku nunu dolu nalo miroano napano aju bunu, napano maka amei atu jouro ea kiaku burusio nei vo, naruei kiniou monoka novio nalo bunu, mia bogo na ajog jooku, mia amei. Mia kiniou nala tibe na-o mia kiaku nunu aviniu amei ave burukuti ve takurano ga vija kiniou, kialo toro na vitikariano na toru nene. ");
INSERT INTO bki_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Rivano-o mia kiniou najamo ka kiaku meuliano riviorlo, naruei mia karam̃aku naio saaro ve toru ka kiniou kanio. Mia nemijikia never bunu ka kiaku meuliano nei napano ver nesian rivano, mia nodu bereio. ");
INSERT INTO bki_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Vere toro dolu tai napano mia rudular kiaku meuliano nei den kiniou, mia kiniou ga takurano nemijamo kanio. Be kiaku ga nesian rivano, a be kiaku ga ka mia nodu bere rimei. Ka noim̃au tibe na, Teta ga mije monea kiniou.” ");
INSERT INTO bki_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ana bogo tai bereio, Yesu kiano iliano na jibe nei mila na kulo Ju nalo aburuburelo ea jidomiano juo bereio. ");
INSERT INTO bki_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Telabo kalo aberinavo “Sim̃aroba ga joa naio, kema na miavovu tanea na! Kuviagago ka re naio!” ");
INSERT INTO bki_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","A tivelinio dolu aberinavo “Makanio, kiano iliano na bo nalo na maka ave iliano na toro napano sim̃aroba toa naio. ?A mia tum̃abe, mia sim̃aroba naio mijikia rilarur merebono binimei rivu bereio jibe ka napano naio mila ruei na?” ");
INSERT INTO bki_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ana ea bogo na be bogo na jokoluolu na toru bereio, mave yako Yerusalemo. Jokoluolu nei abio ka Jokoluolu na Aioko Vatitig Atua Kunuano Lu, a ajum̃a amilaio ea bogo na niavo. ");
INSERT INTO bki_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu bunu ba joa jokoluolu nene, ana bogo tai miel ban ea burum̃ara m̃arsup̃iki nei nam̃a abio ka Solomon kiano M̃arsup̃iki. ");
INSERT INTO bki_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Naruei tomu na tortoru nalo na kulo Ju napano aju, abinimei amivonlo jeliviv ea naio, abika jikili denio, aberinavo “Bogo jiou ruei kumemi numisidom nuvijikia vatitigso ka jau kobe kei, mia jau komila lukuaso ka kumemi mia! Ver jau kobe kenememi Naverikariano riano, kumemi numisidom ka jau monoka koverial vatitig rimeravo rivu van kumemi vonganei.” ");
INSERT INTO bki_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ana Yesu berdop̃e, naio berinavo “?Ana kiniou neber batitig bo ban kamiu ruei, p̃eli na makanio? Kiniou neber ka kamiu ruei mia maka kumonea ga. A burum̃ara im̃auano nalo napano m̃a nemilaio ea karam̃aku siano, jibe ka napano kamiu kumitum̃a kumialio ruei, nalo bunu abisikon kiniou jo medave bo ka kamiu, ");
INSERT INTO bki_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mia naina bunu kamiu maka kumoneaio. P̃eli nina bior kamiu maka kuve burukuti na kiaku nunu nalo. ");
INSERT INTO bki_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kiaku nunu nalo amijog lubar jooa na jooku, a kiniou nemijikia batitiglo abiniu, a nalo ajum̃a ajakisor kiniou. ");
INSERT INTO bki_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kiniou nojom̃a nejian meuliano nei napano maka ve jukuti nene banlo, ka mia ava kovio deio, a ve re toro tai napano mijikia rivuru bulaglo den jum̃aku. ");
INSERT INTO bki_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nina bior napano karam̃aku naruei napano naio jianilo ban kiniou, a naio jikili lie jovulu tomu dolu nalo nonovio, mia maka ve toro tai napano rijikia rivuru bulagio nunu nalo nei den jum̃ano. ");
INSERT INTO bki_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nao-o, kiniou bija Teta kumemi juo nube takurano.” ");
INSERT INTO bki_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mia bogo napano Yesu ber iliano nei bisi, ana tomu na tortoru na kulo Ju nalo tiniel jer naio bereio, abar puruveru ninio ga ajidom atuba ka naio rim̃aro. ");
INSERT INTO bki_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu mialio, ana mil banlo, bika ber “?Kiniou namila burum̃ara im̃auano telabo na bo na Teta naio jidomio ka nala ea miremiu ruei, ana kamiu kumisidom kuvituba kiniou tibe na bior na vabe kalo?” ");
INSERT INTO bki_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ana nalo aberdop̃e, aberinavo “Maka, kumemi nuvisidom nuvitubaso, maka rivior im̃auano na bo tai, mia bior napano jau kojom̃a komila niegeniege laka ka Atua siano lu, ka napano jau, kobe toro ga, mia dam̃ariga kojom̃a komila von ka kalaso kotibe ka Atua garuei.” ");
INSERT INTO bki_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ana Yesu berdop̃e, naio berinavo “Ea kiado Niosi Lu, Atua kiano iliano tai joa Niosi na Iouano, napano naio mil ban kulo Israel, naio berii jum̃abe abe kenerinio, ana naio mil jibe na banlo, naio berinavo ‘Kamiu kumitibe ka atua nalo ga.’ ");
INSERT INTO bki_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Tibe na, ea vio nei kito romial napano nalo napano Atua kiano iliano nene ban ealo, abe kulorinio ga nalo, mia iliano nei berinavo nalo abe atua nalo, a iliano nene naio be kiado vivitauiano lu tai, naio monoka ve riano ga. ");
INSERT INTO bki_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Atua naio berii kiano tomu nalo jibe nei ruei, ana mia jum̃abe ka kiniou, napano kiniou ga takurano naio mioa kiniou miila kiniou nebinimei ea yetemeriba nei? Memedu ga ka neverenio ka naio be Atua karam̃aku, a kiniou nebe kenerinio, a mia kamiu kuber maka rivu ka naber jibe nei. Mia kamiu kuber nojom̃a namila niege Atua siano lu, mia maka tibe na. ");
INSERT INTO bki_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ver be riano ka kiniou nojom̃a nomim̃au maka ve karam̃aku kiano, mo, kamiu kumonea re ana bo ga. ");
INSERT INTO bki_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mia ver kiniou notom̃a nala kiano im̃auano nalo, p̃eli mia kumonea kiniou p̃eli na kamiu kumonea re kiniou, mia kamiu monoka kumonea kiaku burutomoluo nalo, ka abe Atua kiano burutomoluo riano. Ver tibe na, mia kamiu kuvijikia kuvitilubar ka Teta naio joa kiniou be riano, a kiniou nojoa naio.” ");
INSERT INTO bki_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu naio ber jibe na kalo, mia kialo jidomiano nalo kirisikili bare dam̃ariga. Amila von ka avokar sikili naio bereio, mia amiilo ka napano naio jaluvo iviso denlo bano. ");
INSERT INTO bki_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Naruei Yesu naio jaluvo Yerusalemo, barkor uei na Yortano nei ba tivelinio ea vio nanua Jone Baruei naio baruei ea tomu nalo. Naruei Yesu joa vio na kirisiou kija, ");
INSERT INTO bki_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","mia tomu nalo ajum̃a abinimei ka naio dam̃ariga. Abinimei, aberii Yesu aberinavo “Jone nanua na naio maka rila burutomoluo tavukia nam̃a kema nei naio jom̃a milaio, mia naio jom̃a berial vite telabo ea tivelinio na naio, naruei kito rojum̃a romial ka mirado ka napano vite nonovio napano naio berenio na ajum̃a abinimei be riano ga.” ");
INSERT INTO bki_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Naruei kialo jidomiano jibe na mila napano nalo telabo ea vio nei amonea Yesu. ");
INSERT INTO bki_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mia bogo napano Yesu naio jo laka kia ga vo, mieiano na jikili tai binimei bokar kiano bilbilu tai, napano naio be Lasaros. Naina be Lasaros napano kuviviniene juo be Mere naio Marita, a nalo tolu nei tena komeli na telisu na Betani vaataro ka Yerusalemo. ");
INSERT INTO bki_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","A Mere nei bunu napano iorou, naio miyon bonotanunu ea Yesu, naio miolkon jaano nalo ka vijinio. ");
INSERT INTO bki_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mia bogo napano kuviviniene juo nei amial ka kum̃anelo na m̃aro naio mie toru jibe na, amiila toru ka Yesu, aberinavo “Tubo, kiamo bilbilu m̃a na jau tiniemo eaio, naio mie laka.” ");
INSERT INTO bki_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ana bogo na iliano nei binimei bokar Yesu, naio maka rivano, mia naio ber ga, berinavo “Kiano mieiano na maka ve tena m̃ariano, mia mieiano na naio jibe Atua kiano m̃arabo tai ga, ka naio riverial kiano mermerano, a ka riverial kiano burum̃ara moroano na jian ban kiniou Atua Kenerinio.” Yesu naio ber iliano na, jibe na ka naio mijikia vite na mia naio rilaio. ");
INSERT INTO bki_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu tinien jii Marita toru laka bija kulueno na telisu a kum̃anelo nei, a naio mijog bova toru kalo, mia maka rimonloglog bogo na tenei vo. ");
INSERT INTO bki_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jibe na, mia naio maka rivan vo, naio jo bere legiano juo ea vio nei ea marauei na Yortano tivelinio bano. ");
INSERT INTO bki_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Naio jo bere bogoti juo jibe na, bisi ana naio ber ka kumemi kiano naiagagoano nalo, naio berinavo “Kito m̃a, ravarkor ravan bere ea tanobuku na Yortano.” ");
INSERT INTO bki_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mia kumemi numitu tiniememi maio ka kia ga vo nanua tom na tortoru na kulo Ju nalo na ea tanobuku nei tiniel jer m̃elea Yesu, mila na numerou ka nuvan bereio. Naruei nubika den Yesu, nuberinavo “?Naverloglogiano, jum̃abe? Vonganei ga napano kito roju yako, kulo Ju nalo amila vio toru laka ka ajidom atubabinso kam̃aro, mia vonganei ana jau koberinavo mia kito ravan bereio.” ");
INSERT INTO bki_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ana Yesu naio ber ka kumemi naio berinavo “Kiaku verdop̃eiano ban kamiu naio jibe nei: Ea legiano, ea aura duelimo ba juo nene, burum̃ara inio mereralii vio, mila na toro mijikia miel bo, maka tom̃a rijorjoru taatei. ");
INSERT INTO bki_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mia toro napano mila von ka riel ea melijokouo bogiano, mia naio to rijorjoru, bior napano inio nene maka bunu mereralii kiano m̃arabo.” ");
INSERT INTO bki_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu naio ber iliano nei ban kumemi, berial ka naio mijikia riel rivu ga, maka jikia vite tai na bova eaio, vano-o vokar bogo na Atua berkar ruei ka mia ajikia auebinio. Naruei naio jusol bereio, berinavo “Kiado bilbilu neibano naio monmelio ruei. Vonganei, kito ravan ka novio bonio.” ");
INSERT INTO bki_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mia kumemi naiagagoano nalo maka nuvijikia lubar nioti na iliano nei, naruei nuberinavo “Tubo, ver naio monmelio ga, nina bo ga na, mia naio rijog rivu bereio ga.” ");
INSERT INTO bki_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nuber jibe na bior ka napano numitu nuberiam̃a Yesu naio ber ka Lasaros naio mijilimebi ga, mia Yesu naio ber Lasaros kiano m̃ariano. ");
INSERT INTO bki_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Naruei Yesu berial meravo ban kumemi, naio berinavo “Lasaros naio m̃aro ruei, ");
INSERT INTO bki_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","bior bogo na naio mie, maka noto vijalo. Mia jibe na kiniou nemial mia rivu ga, p̃eli rivu lie van kamiu, bior kiano m̃ariano na mia rimei tibe ka kenemiu buluvio tai, ka kuvijikia kumonea kiniou ve riano. Mo, kito ravan eaio.” ");
INSERT INTO bki_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mia kumemi naiagagoano nalo numitum̃a numerou ka nuvano, naruei Tomas m̃a na abio naio ka Tomas Savoro, naio ber ka kumemi, naio berinavo “Kamiu kuvitumolu, kito roviniu ravano, kiado Tubo naio jidom riva rim̃aro tibe na, bo ka kito roviniu ravano, ram̃aro vaarakurano kitoliko naio.” ");
INSERT INTO bki_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Naruei kumemi nubiniu numiel nubano, nubano numiyotuba ea komeli telisu na Betani. Ana aberial ban Yesu ka amidu Lasaros taati monea buluvae bogoti ver barlaka ruei. ");
INSERT INTO bki_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mia komeli nei Betani naio jo vaataro ga ka komeli labo nei Yerusalemo, titai jibe ka kilometa tolu ga, ");
INSERT INTO bki_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","mila na kulo Ju nalo na Yerusalemo nalo telabo, bogo na amijog m̃ariano nei, tiniel miia Marita naljuo Mere toru, naruei abinimei ka ateg naio vijalo. ");
INSERT INTO bki_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mia Marita naio jo naliko, ana amiila toru binimei ban naio aber Yesu binimei joa m̃arabo ruei, naruei naio jumolu ban ka rivan jum̃ano naljuo naio. Mia kuluene neibano telisu Mere naio jo joomo ga ea yimo, a naio maka rivatavio. ");
INSERT INTO bki_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mo Marita, naio binimei mial Yesu, naio berkanio, berinavo “!Kanaku Tubo liki, ver jau komei ea vio nei ga, mia kum̃anememi riva kovio re na! ");
INSERT INTO bki_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mia kiniou nomonea ka be kurano ka napano naio m̃aro, mia venia na ver jau kovika den Atua, mia naio rijamo ka ga vanso.” ");
INSERT INTO bki_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ana Yesu berkanio, berinavo “Marita, mia kum̃anemo naio tumolu rimeul bereio na.” ");
INSERT INTO bki_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Naruei Marita berdop̃eio berinavo “Ee, kiniou nemijikia nina, nemijikia ka mia rimeul bereio ea burum̃ara tumoluano bereio ea legiano na maaro.” ");
INSERT INTO bki_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ana Yesu berial iliano nei kanio, naio berinavo “Kiniou nebe m̃arabo na tumoluano bereio, kiniou nebe burupati na meuliano. Toro na rimonea kiniou, buriakurano naio monoka rim̃aro ea yetemeriba nei, mia naio rimeul bereio. ");
INSERT INTO bki_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Toro napano rivokar meuliano nei, a viekouoiano ea kiniou toa naio, naio mia rivokar re m̃ariano bogo tai. ?Marita, jau komonea jibe na a?” ");
INSERT INTO bki_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ana naio berdop̃e, berinavo “Aiou, Tubo, nomonea. Kiniou nomoneaso, ka jau kobe Naverikariano, jau kobe Atua kenerinio, jau kobe naio nam̃a aber jikar beamu ruei ka mia rimei rilarur tomu nalo na yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Telikiti na Marita ber jibe nei ka Yesu avona bisi, ana naio milivi joomo bereio, ban ka kuluene nei Mere, mijuvaluva banio, berinavo “Naverloglogiano nene, naio binimei ruei, naio joa m̃arabo yako, naio jidom rialso beamu vo.” ");
INSERT INTO bki_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mere mijogio, naruei jumolu vaarakurano, jidom ka rivatove ka rial Yesu, ");
INSERT INTO bki_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","nina rove ea m̃arabo napano Marita mial naio ruei eaio, bior ka napano naio maka rimei jouro ea komeli vo. ");
INSERT INTO bki_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mia kulo Ju nalo napano aju bija Mere joomo amial ka naio jumolu sop̃eli jibe na batavio, naruei be tinielo ka naio jidom riva teg bereio ea buluvae, naruei nalo bunu ajumolu ajakisorio. ");
INSERT INTO bki_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ana Mere naio miel binimei bokar vio na Yesu joaio. Ana bitikario, binimei vaataro kanio, buku naio mijoru ea jaano, jegi banio, berinavo “!Tubo, ver jau komei ea vio nei ga, mia kum̃aneku riva kovio re na!” ");
INSERT INTO bki_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mia naio jom̃a jegi jibe na, a kulo Ju dolu nalo napano m̃a ajakisorio, nalo bunu abinimei ajum̃a ajegi. Mia telikiti napano Yesu naio mial Mere nalo kialo burum̃ara jogvaiano nei, naio bunu mijog bova, mijog tenei jibe ka temi laka ea kiano iviso, ");
INSERT INTO bki_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ana naio bika denlo, berinavo “?Kamiu kumidu naio mon be?” Ana nalo aberinavo “Tubo, jau komei rava raialio.” ");
INSERT INTO bki_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mia Yesu mijogio jibe na, mila jogumirano jibirbili. ");
INSERT INTO bki_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mia nalo amial ka naio jegi jibe na, tealo aberinavo “!Ierinio, naio tinien jii tanea kiano bilbilu nei, naruei naio tinien miiaio mia tinienmiiaio!” ");
INSERT INTO bki_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mia tealo dolu nalo, aju abivika denlo, aberinavo “Toro na naruei nanua beamu naio mila na merebono mirano binimei bo bereio. P̃eli verenio naio sidom, naio mijikia rila ka napano kiano bilbilu naio maka rijikia rivakovio ga p̃eli?” ");
INSERT INTO bki_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mia Yesu naio miel ban bija burum̃ara jogvaiano nei, naliko Mere nalo aba amiyotuba ea buluvae napano Lasaros taati mon eaio. Bulukuveru nei naio be buluvae tai, napano amidu burum̃ara puruveru tai joko buluku tavo nene. ");
INSERT INTO bki_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ana Yesu naio berinavo atubonlar puruveru na toru nei. Mia Marita naio mijog Yesu ber atubonlar puruveru, mia naio jidom riverbureio, ber kanio, berinavo “Tubo, maka rivu ka rala tibe na, bior naio m̃aro bogoti ver barlaka ruei, mia bonoti rivova laka na.” ");
INSERT INTO bki_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ana Yesu berdop̃e banio, berinavo “?Ee, jau maka koto tiniemo rimaio vo ka kiaku iliano nei napano neber ka jau ruei? Kiniou neber ka ver jau komonea ga, mia keial moroano na Atua kiano naio rim̃au.” ");
INSERT INTO bki_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ana ajidel ka ga, ajubonlar burum̃ara puruveru nei, bisi ana na Yesu naio jirarag bavin mave, naio bolkouo, berinavo “Teta, kiniou neber siva toru banso ka napano jau kajaaro ka m̃a komijog kanaku valeiano nei. ");
INSERT INTO bki_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kiniou nemijikia ka venia napano ver kiniou nesidom nevika denso, mia jau kojogio ga. A vite nei mia kiniou nevika denso vonganei, nebika ea tomu nalo nei ajumol aju miralo, ka nalo bunu ajikia ajogio. Naruei ver aial ka napano mia jau koverdop̃e rivan kiniou tibe ka na nobikanio, mia rijikia riijailo ka amonea ka be riano ka napano jau naruei komiila kiniou nebinimei ea yetemeriba nei.” ");
INSERT INTO bki_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mia telikiti napano Yesu bolkouo bisi jibe na, ana naio bio jikili jibe na ba ban naio berinavo “Lasaros, jau kotumolu komei tavio.” ");
INSERT INTO bki_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Naruei amiilo ka napano toro na m̃aro nei naio jumolu miel binimei tavio, bija kulum̃arauo napano abiviko ka naio, napano m̃a ajum̃a ajarakii lele gorogoro ea jum̃ano a jaano a parinio kia ga vo. Naruei Yesu naio ber kalo berinavo “Mo, kamiu kuvijubar bulag kulum̃arauo nalo nei denio, ka mia mijikia riel rivu bereio.” Ana nalo amilaio, naruei Lasaros naio meul bo naio jo naliko bereio. ");
INSERT INTO bki_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mia kulo Ju nalo telabo napano ajakisor Mere abinimei ea bulukuti puruveru nei, telikiti napano amial ka napano Yesu naio mila Lasaros meul bereio jibe na, amonea batitig naio bo. ");
INSERT INTO bki_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mia nalo tealo maka amoneaio, aban bereio, aba amial Varisis nalo, aberial kalo ka venia napano Yesu milaio. ");
INSERT INTO bki_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ana telikiti na amijogio, maka lele asaaro kanio, naruei nalo bija tomu na tortoru na kulo lu nalo, abio nalo dolu na burum̃ara komeli na kulo Ju abinimei vio takurano. Naruei telikiti napano abinimei vio takurano bisi, aberial kalo aberinavo “?Mia kito rala venia ka toro nei naruei? Naio jom̃a mim̃auka burutomoluo na tortoru telabo janea vio ea kiado tomu nalo miralo. ");
INSERT INTO bki_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ver kito roverbure re naio,