﻿USE sofia;
DROP TABLE IF EXISTS sofia.bkd_vpl;
CREATE TABLE bkd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bkd_vpl WRITE;
INSERT INTO bkd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iyan haini mga gin-apuan hi Jesu Cristo. Si Jesus kaliwat hi David sa kaliwat daan hi Abraham. ");
INSERT INTO bkd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham amay hi Isaac. Si Isaac amay hi Jacob. Si Jacob amay hi Juda daw hu mga suled din. ");
INSERT INTO bkd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda amay hi Fares daw hi Zara ha iyan inay dan si Tamar. Si Fares amay hi Esrom. Si Esrom amay hi Aram. ");
INSERT INTO bkd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram amay hi Aminadab. Si Aminadab amay hi Naason. Si Naason amay hi Salmon. ");
INSERT INTO bkd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon amay hi Boez daw sa inay hi Boez iyan si Rahab. Si Boez amay hi Obed daw sa inay hi Obed iyan si Rut. Si Obed amay hi Jese. ");
INSERT INTO bkd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jese amay hi Harì David. Si David amay hi Salomon daw sa inay hi Salomon iyan sa asawa su anay hi Urias. ");
INSERT INTO bkd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Salomon amay hi Roboam. Si Roboam amay hi Abias. Si Abias amay hi Asa. ");
INSERT INTO bkd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa amay hi Josafat. Si Josafat amay hi Joram. Si Joram amay hi Usias. ");
INSERT INTO bkd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias amay hi Jotam. Si Jotam amay hi Acaz. Si Acaz amay hi Esekias. ");
INSERT INTO bkd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esekias amay hi Manases. Si Manases amay hi Amon. Si Amon amay hi Josias. ");
INSERT INTO bkd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias amay hi Jeconias daw hu mga suled din ha maama. Duun taena ha panahun inuwit sa mga kaliwatan hi Israel payanaen diyà ta Babilonia. ");
INSERT INTO bkd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Su diyà en sidan ta Babilonia namatà pa gayed sidan. Si Jeconias amay hi Salatiel. Si Salatiel amay hi Zorobabel. ");
INSERT INTO bkd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Zorobabel amay hi Abiud. Si Abiud amay hi Eliakim. Si Eliakim amay hi Asor. ");
INSERT INTO bkd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor amay hi Sadoc. Si Sadoc amay hi Akim. Si Akim amay hi Eliud. ");
INSERT INTO bkd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud amay hi Eleasar. Si Eleasar amay hi Matan. Si Matan amay hi Jacob. ");
INSERT INTO bkd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob amay hi Jose ha iyan asawa hi Maria ha inay hi Jesus. Si Jesus iyan tagngaranan ki Cristo. ");
INSERT INTO bkd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sampulù daw haepat ha kaliwatan sugud diyà ki Abraham payanaen en diyà ki David. Sugud daan diyà ki David payanaen hu pag-uwit kandan diyà ta Babilonia sampulù daan daw haepat ha kaliwatan. Sugud taena payanaen hu kabataa ki Jesu Cristo sampulù pa daan daw haepat ha kaliwatan. ");
INSERT INTO bkd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iyan haini tultulanen mahitenged hu kabataa ki Jesu Cristo. Sa inay din ha si Maria su makagunan en ki Jose na su hurà pa sidan makag-asawa agkabedes en haena pinaagi hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tumenged ta matareng ha etaw si Jose daw harì din agkabayaan ha magayhaan si Maria nahenhenaan din ha magsuwayà sidan ha harì matun-an hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ba su taghenhenaayen hi Jose haena huminiwal diyà ta kandin sa balinsuguen hu Dios pinaagi hu damugu ha tagyanaen “Jose sa kaliwat hi David, harì ka tagduwa-duwa hu pagpangasawa ki Maria ta sa igkabedes din pinaagi dà hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Saena ku ibatà asem maama gayed daw sa ingaran nu duun iyan si Jesus ta sa mga etaw ha agsunud kandin aglibriyen din duun hu mga salà dan.” ");
INSERT INTO bkd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nahitabù haena ta daw matuman sa lalang hu Dios pinaagi hu propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Amin asem mabedes ha laga ha sa batà din maama daw sa ingaran duun Emanuel” ha sa kahulugan taena “Uminamul en kanuy sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Su mapukaw si Jose binuhat din sa inikagi taena ha balinsuguen hu Dios. Inasawa din si Maria ");
INSERT INTO bkd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ba hurà gayed bul-ug mag-ubay duun ku asawa din su hurà pa haena magbatà. Su mauma sa panahun ha magbatà en si Maria su batà pigngaranan dayun hi Jose ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Jesus diyà imbatà ta Betlehem ha sakup ta Judea su panahun ha iyan pa harì diyà si Herodes. Hurà tungkay kalugay nakauma diyà ta Jerusalem sa mga etaw ha mga matatau ha napuun diyà ta sinibwalan. ");
INSERT INTO bkd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nanginginsà sidan hu “Hindu haena imbatà sa Harì hu mga Judio? Ta naahà day sa bituen diyà ta sinibwalan ha iyan timaan hu kabataa kandin aman duminini kay hu pagsimba kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Su mapaliman haena hi Harì Herodes daw hu mga taga-Jerusalem tungkay gayed sidan nasamuk. ");
INSERT INTO bkd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aman inamul din dayun sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan daw insai sidan ku hindu igbatà sa Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tuminubag sidan hu “Diyà ta Betlehem ha sakup ta Judea ta iyan haini insulat hu propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sinyu sa mga taga-Betlehem ha sakup ta Judea, mabantug gayed sa banuwa nuy labaw hu alan ha mga banuwa diyan, ta sa magharì hu mga etaw ku ha mga kaliwatan hi Israel diyan ta inyu agkapuun.’” ");
INSERT INTO bkd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Dayun su mga matatau ha mga etaw pinaelegan hi Harì Herodes daw su iyan dà sidan ininsaan din ku kan-u dan naahà su bituen. ");
INSERT INTO bkd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Su matun-an din haena sinugù din dayun sidan ha dumiyà ta Betlehem daw ikagiyi hu “Siguruwa nuy gayed pan-ahaa su batà. Ku maahà nuy haena ikagiyi a dà inyu ta daw makasimba a daan kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Su maikagi haena ku harì duminayun su mga matatau ha mga etaw. Su diyà en sidan ta dalan naisab dan dà naahà su bituen ha diyà napuun ta sinibwalan aman tungkay gayed sidan nangalipay. Linupug dan su bituen taman ha tuminaleen haena tenged ku balay ha duun su batà. ");
INSERT INTO bkd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dayun sumineled sidan duun ku balay. Su maahà dan su batà daw sa inay din ha si Maria luminuhud sidan daw suminimba taena ha batà. Dayun in-ila dan kandin sa uwiten dan ha bulawan daw mga mahalen ha insenso daw mira. ");
INSERT INTO bkd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ba su ag-ulì en sidan inikagiyan sidan hu Dios pinaagi hu damugu ha harì en sidan lumikù diyà ki Herodes, aman duun en sidan uminagi hu lain ha dalan. ");
INSERT INTO bkd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Su maipus en su mga matatau ha mga etaw huminiwal en paman diyà ki Jose sa balinsuguen hu Dios pinaagi hu damugu ha tagyanaen “Bangun kad, dumaha su batà daw sa inay din daw pulaguy kaw diyà ta Ehipto. Daw kaw en awà diyà ku ikagiyan kud inyu ta agpan-ahaen en iman hi Herodes hayana sa batà ta aghimatayan din.” ");
INSERT INTO bkd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aman migbangun si Jose daw dinuma din su batà daw sa inay taena dayun huminipanaw sidan payanaen ta Ehipto bisan ku daleman. ");
INSERT INTO bkd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Diyà sidan migtimà hangtud ha minatay si Herodes. Nahitabù haena ta daw matuman sa inikagi hu Dios pinaagi hu propita ha tagyanaen “Impalikù ku sa Batà ku ha diyà napuun ta Ehipto.” ");
INSERT INTO bkd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Su matun-an hi Herodes ha bà dà binidui ku mga matatau ha mga etaw napauk-pauk gayed haena. Aman insugù din dayun ha panhimatayan sa alan ha mga batà ha maama diyà ta Betlehem daw duun hu mga ubayà din ha banuwa sugud hu daw pa imbatà payanaen hu daruwa en sa tuig din, ta daruwa en daan ha tuig su maahà taena ha mga matatau ha mga etaw su bituen. ");
INSERT INTO bkd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pinaagi taena natuman sa inikagi hi Jeremias sa propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Amin mapaliman ha magulub diyà ta Rama tumenged hu ulahù hi Rakel ta sa mga batà din pinanhimatayan na hurà en pakapalipay kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Su matay en si Herodes ha diyà pa si Jose ta Ehipto huminiwal dà paman sa balinsuguen hu Dios diyà ta kandin pinaagi hu damugu ha tagyanaen “Bangun kad, dumaha su batà daw sa inay din daw likù kaw en diyà ta bugtà ta Israel ta minatay en su aghimatay tayana ha batà.” ");
INSERT INTO bkd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aman migbangun si Jose daw dinuma din su batà daw sa inay taena dayun namanlikù sidan diyà ta bugtà ta Israel. ");
INSERT INTO bkd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ba su matun-an hi Jose ha iyan nakailis si Arkelao ki Amay din ha harì diyà ta probincia ta Judea nahaldek haena hu pagdiyà. Aman impadamugu kandin hu Dios ha dumayun sidan diyà ta probincia ta Galilea, ");
INSERT INTO bkd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","dayun diyà en sidan migtimà ta banuwa ha tagngaranan ta Nazaret. Pinaagi taena natuman sa inikagi hu mga propita ha si Jesus ngaranan ha taga-Nazaret. ");
INSERT INTO bkd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Duun taena ha panahun amin etaw ha tagngaranan ki Juan ha Bautista ha nanunultul duun hu pinakabulung-bulung ha lugar diyà ta Judea ");
INSERT INTO bkd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ha tagyanaen “Hinulsuli sa mga salà nuy ta madani en sa pagharì hu Dios kanuy.” ");
INSERT INTO bkd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan iyan su tagsubayen hi Isaias sa propita ha tagyanaen “Amin etaw ha magkulahiay duun hu pinakabulung-bulung ha lugar ha magyanaen ‘Andama sa ag-agiyan hu Ginuu daw tul-ida sa dalan.’” ");
INSERT INTO bkd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa pinaksuy hi Juan bulbul hu kamilyo daw anis daan sa bakes din. Sa kalan-enen din talangas daw degà. ");
INSERT INTO bkd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Madakel ha mga etaw sa namandiyà ta kandin ha nangapuun diyà ta Jerusalem daw duun hu alan ha mga banuwa diyà ta probincia ta Judea daw duun hu ubay ta Wahig ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Insugid dan sa mga salà dan aman pigbautismuwan sidan hi Juan diyà ta Wahig ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ba su maahà hi Juan sa madakel ha mga Fariseo daw mga Saduceo ha tagpabautismu kandin inikagiyan din sidan hu “Sinyu sa mga bunsalagan, sin-u sa mig-ikagi inyu ha dumini kaw ta kanak? Abi nuy gid ha mapulaguyan nuy sa silut inyu hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ku laus ha mighinulsul kaw en hu mga salà nuy ipaahà nuy haena pinaagi hu maayad ha buhat. ");
INSERT INTO bkd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Harì kaw magsalig ha mga kaliwatan kaw hi Abraham ta ikagiyen ku inyu ha mahimu hu Dios buhata haini sa mga batu ha kaliwatan daan hi Abraham. ");
INSERT INTO bkd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sa tagpamilay andam en hu pagpilay hu mga kayu. Sa kayu ha madaet sa bunga din agpilayen daw bigsuli. ");
INSERT INTO bkd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Diyà a ta wahig agpamautismu inyu ha iyan timaan ha nahinulsulan nuy en sa mga salà nuy. Ba amin pa makadini ha labaw dì kanak ta bisan sa pag-uwit hu sapatus din kenà a gayed angayan duun. Sa kandin ha igbautismu iyan sa paulinan kaw kandin hu Balaan ha Ispiritu daw masunug sa madaet diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Agkailing haena hu taggunas ha sa malinggas iyan din igtagù duun hu bugawan, ba sa ukap agbigsulan ha harì en mapedengan.” ");
INSERT INTO bkd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Su kamulu pa tagpamautismu si Juan diyà ta Jordan nakauma si Jesus diyà ta kandin ha diyà napuun ta Galilea ta tagpabautismu daan. ");
INSERT INTO bkd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ba harì ngaay agkabayà si Juan aman minikagi hu “Harì mahimu ha bautismuwan ku ikaw ta iyan a ngaay angayan ha bautismuwan nu.” ");
INSERT INTO bkd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ba tuminubag si Jesus ha “Buhata haini ta kinahanglan ha matuman sa alan ha agkabayaan hu Dios.” Aman binautismuwan haena hi Juan. ");
INSERT INTO bkd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Su mabautismuwan en si Jesus guminaun haena. Dayun sagunà napuwaan sa langit daw naahà din sa Balaan ha Ispiritu ha sinugù hu Dios ha agkailing hu salapati ha migbulus diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Amin lageng ha napuun diyà ta langit ha tagyanaen “Iyan en haini pinalanggà ku ha Batà ha tigkabayà-bayà ku.” ");
INSERT INTO bkd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Inuwit si Jesus hu Balaan ha Ispiritu duun hu pinakabulung-bulung ha lugar ta daw masulayan hi Satanas. ");
INSERT INTO bkd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Suminalang si Jesus hu pagkaen seled hu kapatan ha aldaw daw daleman, aman su maiwas haena tungkay gayed nauhul. ");
INSERT INTO bkd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Dayun si Jesus inubayan hu Manunulay daw ikagiyi ha “Ku Batà ka hu Dios ikagiyi haini sa mga batu ha mabuhat ha supas.” ");
INSERT INTO bkd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ba tuminubag si Jesus hu “Sa lalang hu Dios nakasulat en ha tagyanaen ‘Kenà iyan dà igkauyag hu etaw sa kalan-enen ta sa lalang hu Dios iyan tag-ila hu kinabuhì.’” ");
INSERT INTO bkd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Dayun si Jesus dinuma hi Satanas duun hu kinatangkawan ha atep taena ha Timplo diyà ta Jerusalem ");
INSERT INTO bkd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","daw ikagiyi ha “Ku Batà ka hu Dios sabay ka duun taini ta sa insulat ha lalang hu Dios tagyanaen ‘Suguen hu Dios sa mga balinsuguen din hu pagbantay ikaw daw tamuken ka kandan ta daw harì ka mabugel.’” ");
INSERT INTO bkd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ba tuminubag si Jesus hu “Sa lalang hu Dios nakasulat en ha tagyanaen ‘Harì agsulaya sa Dios ha Magbabayà hu alan.’” ");
INSERT INTO bkd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aman dinuma en paman si Jesus hi Satanas duun hu matangkaw tungkay ha bubungan daw ipaahà kandin sa kadagway hu alan ha mga ginharian ta kalibutan, ");
INSERT INTO bkd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","dayun inikagiyan din si Jesus hu “Saini ha agkaahà nu iman ig-ila ku ikaw ku lumuhud ka daw sumimba ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ba si Jesus tuminubag hu “Awà ka dini ta kanak, Satanas, ta sa lalang hu Dios nakasulat en ha tagyanaen ‘Iyan dà sa Dios ha Magbabayà hu alan angayan ha simbahen daw alagaran.’” ");
INSERT INTO bkd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aman uminawà si Satanas diyà ta kandin, dayun nakauma sa mga balinsuguen hu Dios diyà ki Jesus hu pag-alima kandin. ");
INSERT INTO bkd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Su mapaliman hi Jesus ha si Juan ha Bautista napurisu en luminikù haena diyà ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Suminagad diyà ta Nazaret daw migtimà diyà ta Capernaum ha kilid hu danaw, saena ha lugar tagngaranan hu Zebulon daw Neftali. ");
INSERT INTO bkd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nahitabù haena ta daw matuman sa inikagi hi Isaias sa propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sa bugtà ta Zebulon daw ta Neftali payanaen en ta dagat layun ta Jordan iyan sa Galilea ha tagtimaan hu kenà mga Judio. ");
INSERT INTO bkd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Duun pa sidan tagtimà hu kasukileman ha bugtà hu kamatayen ba naahà dan sa tungkay masiga ha nakailaw kandan.” ");
INSERT INTO bkd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Sugud taena ha panahun nanunultul si Jesus hu kagi din “Hinulsuli sa mga salà nuy ta madani en sa pagharì hu Dios inyu.” ");
INSERT INTO bkd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Su taghiphipanaw si Jesus duun hu kilid taena ha Danaw ta Galilea naahà din si Simon ha tagngaranan daan ki Pedro daw sa suled din ha si Andres. Tagpamaling sidan duun taena ha danaw ta mamamaling man sidan. ");
INSERT INTO bkd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Inikagiyan sidan hi Jesus ha “Dumuma kaw kanak ta agbuhaten ku inyu ha mamamaling hu mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aman sagunà dan inawaan su mga baling daw duma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Su malugay-lugay naahà hi Jesus sa mga migsuled daan ha iyan si Santiago daw si Juan sa mga batà hi Zebedeo ha tagpamandayan dan su kandan ha baling duma ki Amay dan duun ku barutu. Aman inumaw sidan hi Jesus ");
INSERT INTO bkd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","dayun sagunà dan inawaan si Amay dan duun ku barutu daw duma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nalekep hi Jesus sa alan ha banuwa ha sakup ta Galilea. Duun hu mga simbahan hu mga Judio migtudlù si Jesus hu Maayad ha Tultulanen mahitenged hu pagharì hu Dios daw naulian din daan sa alan ha mga dalu hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sa tultulanen mahitenged kandin nakalekep diyà ta probincia ta Siria, aman pinan-uwit dan diyà ta kandin sa mga etaw ha agkangadaluwan hu hurà mag-iling ha dalu daw sa agkangasakitan. Sa duma kandan agkangabidbid daw amin mga minatay en sa dibaluy ha lawa din daw sa duma pinan-ulinan en hu mga busaw. Ba alan sidan naulian hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Madakel tungkay sa namanduma kandin ha nangapuun diyà ta Jerusalem daw duun hu mga probincia ta Galilea daw ta Judea daw duun taena ha lugar ta Decapolis daw hu duma ha mga banuwa diyà ta layun ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Su maahà hi Jesus sa madakel ha mga etaw tuminakedeg haena duun hu bubungan daw pinuu. Nangaamul-amul diyà ta kandin sa mga sumusunud din ");
INSERT INTO bkd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","dayun nanudlù kandan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Malipayen gayed sa nakatuen ha ku harì buligan hu Dios hurà dan mahimu, ta agharian sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Malipayen gayed sa tagmagul-anen tumenged hu mga salà dan ta aglipayen sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Malipayen gayed sa mga tagpaubus ta maangken dan sa panalangin ha insaad hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Malipayen gayed sa tungkay agkangabayà hu pagbuhat hu matareng, ta agbuligan din sidan. ");
INSERT INTO bkd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Malipayen gayed sa mga mahid-uwen hu duma dan ta mahid-uwan daan sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Malipayen gayed sa mahimpit sa henà-henà dan ta maahà dan sa Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Malipayen gayed sa mga tagbuhat hu kalinaw ta makilala sidan ha batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Malipayen gayed sa tagpasipalahan tumenged hu pagbuhat dan hu matareng ta agharian sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Malipayen kaw gayed ku tameyesen kaw daw ku pasipalahan kaw hu mga etaw daw ku daet-daeten kaw pinaagi hu mga bidù tumenged hu pagsunud nuy kanak. ");
INSERT INTO bkd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ikalipay nuy gayed haena ta adagi tungkay sa igbales inyu hu Dios diyà ta langit, ta iyan daan haena binuhat dan duun hu mga propita. ");
INSERT INTO bkd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Iyan kaw asin dini ta kalibutan. Ba ku maawà en sa kapait hu asin in-inuwen pa paglikù hu nanam taena? Hurà din en gayed pulus daw bà dà paman iglambeg diyà ta guwà dayun gik-an hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Iyan kaw daan sulù dini ta kalibutan. Sa banuwa ha duun pakaluntud hu buntud agkaahà hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hurà etaw ha tagtutud hu sulù ha bà din dà agpalangkebi hu bakag, ba saena iluntud din gayed duun hu ugsakà ha matangkaw daw mailawan sa seled taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aman ipasiga gayed sa sulù nuy ta daw maahà hu mga etaw ha maayad sa mga buhat nuy dayun madayè dan sa Dios ha Amay nuy diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Harì kaw maghenà-henà ha sa pagdini ku ta kalibutan iyan sa pag-awà hu Kasuguan daw hu lalang hu Dios pinaagi hu mga propita, ta sa pagdini ku iyan sa pagtuman taena. ");
INSERT INTO bkd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Laus gayed sa ag-ikagiyen ku inyu ha ku duduun pa sa langit daw sa kalibutan harì gayed mahimu ha maalatan hu bisan atiyuay sa Kasuguan hangtud ha matuman haena. ");
INSERT INTO bkd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bisan sin-u sa makasupak hu tungkay atiyuay duun hu Kasuguan daw magtudlù ha harì en haena tumanen, saini ha etaw harì tagharian hu Dios diyà ta langit. Ba bisan sin-u sa magtuman hu Kasuguan daw magtudlù ha tumanen gayed haena, saini ha etaw tagharian gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ikagiyen ku inyu ha sa Dios iyan din dà tagharian sa matareng gayed dì taena ha mga manunudlù hu Kasuguan daw mga Fariseo. ");
INSERT INTO bkd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Natun-an nuy en sa kasuguan duun hu mga gin-apuan nuy ha tagyanaen ‘Harì kaw mangimatay ta ku buhaten nuy haena mahukuman kaw hu silut.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ba ikagiyen ku inyu ha bisan sin-u sa bà din dà agkapauki sa duma din mahukuman en daan haena hu silut. Sa tagpaamaniyan din sa duma din makapanubag duun hu alan ha mga labaw ha punuan. Daw bisan sin-u sa mag-ikagi duun hu duma din ha ‘Buang-buang ka’ saena ha tag-ikagi taghipanaw duun hu dalan payanaen ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aman ku taghalad kaw duun hu Dios daw mahenhenaan nuy ha amin diay nabuhat nuy ha igkapauki inyu hu duma nuy, ");
INSERT INTO bkd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","awaan nuy haena sa ighalad nuy daw pan-ahaa su etaw ha agkapauk inyu daw makaghusayà kaw. Ku mapengahan haena human nuy dayuna sa paghalad duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ku isumbung kaw hu duma nuy agpasa nuy husaya ha harì pa makauma duun hu taghusay, ta ku makauma kaw en duun itugyan kaw hu maghuhukum daw ipapurisu kaw gayed kandin. ");
INSERT INTO bkd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Laus gayed sa ag-ikagiyen ku inyu ha daw kaw en makaguwà diyà ta purisuwan ku mabayaran nuy en sa alan ha mga salà nuy. ");
INSERT INTO bkd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Natun-an nuy en daan sa kasuguan su anay ha tagyanaen ‘Harì kaw manapaw.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ba ikagiyen ku inyu ha bisan bà dà kaayati hu maama sa bisan sin-u ha bahi saena ha maama nakapanapaw en. ");
INSERT INTO bkd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ku iyan igpakasalà nuy sa kawanan ha mata nuy lugita haena daw ilambeg, ta maayad pa ha sabuwa dà sa mata nuy dì sa daruwa ba makaagbul kaw diyà ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Daw ku iyan daan igpakasalà nuy sa kawanan ha alima nuy tampeda haena daw ilambeg, ta maayad pa ha sabuwa dà sa alima nuy dì sa daruwa ba makaagbul kaw diyà ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Inikagi daan su anay ha ‘Ku amin maama ha endaan din sa asawa din ilahan din haena hu kasulatan hu pag-endaay.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ba ikagiyen ku inyu ha ku endaan hu maama sa asawa din ha hurà makasalà, saena ha maama nakasalà ta agbuhaten din ha mananapaw su bahi ku isab dà magpaasawa, daw saena ha mangasawa ku bahi ha inendaan makapanapaw daan. ");
INSERT INTO bkd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Natun-an nuy en daan sa kasuguan duun hu mga gin-apuan nuy ha tagyanaen ‘Ku manumpà kaw duun hu Dios kinahanglan ha tumanen nuy gayed haena.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ba ikagiyen ku inyu ha harì kaw gayed manumpà pinaagi hu langit ta iyan haena trono hu Dios ");
INSERT INTO bkd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","daw bisan daan sa kalibutan ta iyan haini gik-ayà din. Daw harì nuy daan ipanumpà sa Jerusalem ta iyan haena banuwa hu gamhanan ha Harì. ");
INSERT INTO bkd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bisan pa daan sa buhuk ta ulu nuy harì mahimu ha ipanumpà ta hurà makapaputì hu bisan nangkalegas dà ha buhuk nuy. ");
INSERT INTO bkd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ku mag-ikagi kaw sa ‘Hee’ na ‘Hee’ gayed daw sa ‘Harì’ na ‘Harì’ gayed daan, ta ku isaban nuy pa haena hu duma ha mga lalang diyà en haena agkapuun ki Satanas. ");
INSERT INTO bkd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Natun-an nuy en daan sa kasuguan ha tagyanaen ‘Ku amin etaw ha matumlak din sa mata hu duma din tumlaken daan sa kandin ha mata, daw ku masipù din sa ngipen hu duma din sipuen daan sa kandin ha ngipen.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ba ikagiyen ku inyu ha harì nuy gayed sukulan sa tagpasipala inyu. Ku amin etaw ha laparuwen din sa kawanan ha pipi nuy ipalaparu daan sa dibaluy. ");
INSERT INTO bkd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Daw ku amin etaw ha isumbung kaw kandin ta daw matimù din sa pinaksuy nuy, iila en haena kandin daw isabi pa hu kamisita. ");
INSERT INTO bkd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ku amin etaw ha magpeges inyu hu pag-uwit hu mga butang din hu nangkakilomitro buligi haena taman hu daruwa ha kilomitro. ");
INSERT INTO bkd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ku amin manayù diyan ta inyu ilahi nuy daw ku amin agsambay sambayi nuy. ");
INSERT INTO bkd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Natun-an nuy en daan sa kasuguan su anay ha tagyanaen ‘Palanggaa gayed sa duma nuy ba magdumut kaw hu kuntra nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ba ikagiyen ku inyu ha palanggaa sa mga kuntra nuy daw iampù nuy haena sa tagpasipala inyu ");
INSERT INTO bkd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ta iyan haini timaan ha batà kaw gayed hu Amay nuy diyà ta langit. Saena agpanalanginan din sa etaw ha matareng daw sa kenà, iling hu mga pamulahen ha alan din agpaudanan daw agpasildahan. ");
INSERT INTO bkd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Harì nuy aghenhenaa ha balesan kaw hu Dios ku iyan dà palanggaen nuy sa tagpalanggà daan inyu, ta bisan sa mga limbungan ha manunukut hu buhis tagbuhaten dan daan haena. ");
INSERT INTO bkd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Daw ku iyan dà pagsimahen nuy sa daan nuy en amigu inu man sa igkadayè inyu? Ta bisan sa mga etaw ha hurà makakilala hu Dios tagbuhaten dan daan haena. ");
INSERT INTO bkd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Aman magmahimpit kaw iling hu Amay nuy diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Andama nuy sa pagbuhat hu matareng ha harì nuy bà dà makapaaluahà hu mga etaw, ta ku iyan hayana harì kaw balesan hu Amay nuy diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Aman ku tag-ila kaw duun hu taglised harì nuy haena tigpaaluahà hu mga etaw bisan duun hu mga simbahan daw duun hu mga dalan, ta sa iling taena bà dà tagpasibù-sibù ta daw madayè sidan. Laus gayed sa ag-ikagiyen ku inyu ha nadawat dan en sa bales kandan. ");
INSERT INTO bkd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ba ku buligan nuy sa taglised kinahanglan ha harì maahà hu bisan sin-u ");
INSERT INTO bkd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta daw harì matun-an hu mga etaw. Dayun sa Dios ha Amay nuy ha pakaahà hu alan iyan en magbales inyu. ");
INSERT INTO bkd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ku mag-ampù kaw harì nuy haena buhaten ha bà dà pagpaaluahà hu mga etaw iling hu duma ha bà dà tagpasibù-sibù ha tungkay agkangabayà ku maahà ku tag-ampù duun hu mga simbahan daw bisan duun hu mga dalan. Laus gayed sa tag-ikagiyen ku inyu ha nadawat dan en sa bales kandan. ");
INSERT INTO bkd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ku mag-ampù kaw dumuun kaw hu lugar ha hurà makaahà inyu daw mag-ampù kaw duun hu Dios ha Amay nuy ha harì nuy agkaahà. Dayun sa Dios ha pakaahà hu alan iyan en magbales inyu. ");
INSERT INTO bkd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Daw ku mag-ampù kaw harì nuy en sublì-sublien sa mga lalang iling hu etaw ha hurà pa makakilala hu Dios ta abi dan ha pinaagi hu pagsublì-sublì taena mapaliman sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Harì nuy sidan ilingan ta sa Amay nuy natun-an din en sa kinahanglanen nuy bisan su hurà kaw pa mag-ampù. ");
INSERT INTO bkd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Iyan haini paagi hu pag-ampù ‘Amay day diyan ta langit, tahuren gayed sa ngaran nu. ");
INSERT INTO bkd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Harii kay ikaw daw sa pagbayà nu iyan matuman dini ta kalibutan iling daan diyan ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ilahi kay iman hu kalan-enen. ");
INSERT INTO bkd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasayluwa kay hu mga salà day ta pinasaylu day daan sa nakasalà dini ta kanay. ");
INSERT INTO bkd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ipadiyù kay ikaw hu panulay daw buligi kay ikaw ta daw harì kay madaeg hi Satanas.’ ");
INSERT INTO bkd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ku mapasaylu nuy sa etaw ha nakasalà diyan ta inyu pasayluwen kaw daan gayed hu Amay nuy diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ba ku harì nuy mapasaylu sa duma nuy harì kaw daan pasayluwen hu Dios ha Amay nuy. ");
INSERT INTO bkd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ku sumalang kaw hu pagkaen harì kaw tagsamed-engà iling hu mga etaw ha bà dà tagpasibù-sibù, ta tagbuhaten dan haena hu bà dà pagpaahà ha tagsalang sidan hu pagkaen. Laus gayed sa tag-ikagiyen ku inyu ha nadawat dan en sa bales kandan. ");
INSERT INTO bkd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ba ku sumalang kaw hu pagkaen manuwat kaw daw pangulam-us kaw ");
INSERT INTO bkd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ta daw harì matun-an hu duma ha tagsalang kaw hu pagkaen ta iyan dà nakatuen taena sa Dios ha Amay nuy ha harì nuy agkaahà. Dayun sa Dios ha Amay nuy ha pakaahà hu alan iyan en magbales inyu. ");
INSERT INTO bkd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Harì nuy dini dà ag-amul-amula sa katigayunan nuy ta kalibutan ta bà dà haena ketketa daw tangisa daw takawa. ");
INSERT INTO bkd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ba amul-amula sa mga katigayunan nuy diyà ta langit ta harì haena maketket daw harì tangisen daw harì daan haena matakaw. ");
INSERT INTO bkd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta ku hindu duun makaugsak sa katigayunan nuy duun en daan taena sa henà-henà nuy. ");
INSERT INTO bkd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sa mata iyan sulù hu lawa. Ku maayad sa mata nuy duun kaw gayed taghipanaw hu mapawà, ");
INSERT INTO bkd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ba ku peyeng kaw duun kaw taghipanaw hu kasukileman. Aman ku madaet sa henà-henà nuy tungkay en daan madaet sa tagbuhaten nuy. ");
INSERT INTO bkd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Harì gayed mabaluy ha sa etaw daruwa sa agalen din ta palanggaen din sa sabuwa ba sa sabuwa kuntrahen din, alimahan din sa sabuwa ba sa sabuwa ipatayà din. Sa etaw ha iyan din dà minahal sa katigayunan din harì gayed mahimu ha mahalen din daan sa Dios. ");
INSERT INTO bkd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Aman ikagiyen ku inyu ha harì kaw masamuk ku inu sa agkan-en daw sa ag-inumen nuy daw sa agbistiyen nuy. Kenà ba mahinengdanen pa sa kinabuhì nuy dì hu pagkaen? Daw kenà ba mahinengdanen pa sa lawa nuy dì hu bisti? ");
INSERT INTO bkd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Henhenaa nuy sa mga tagbis ha taglayang. Harì sidan tagpamula daw hurà dan daan bugawan ba igpakaen sidan hu Amay nuy ha diyà ta langit. Kenà ba mahal kaw pa dì hu mga tagbis? ");
INSERT INTO bkd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bisan ku agkatungkayan nuy en agkanugunan sa kinabuhì nuy ba saena harì nuy en gayed masumpayan. ");
INSERT INTO bkd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Daw imbà kaw agkasamuk ku inu sa bistiyen nuy? Henhenaa nuy sa mga bulak ku agkainu-inu sa pagtubù dan. Harì sidan tagpanahì hu pinaksuy dan. ");
INSERT INTO bkd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ba ikagiyen ku inyu ha bisan si Harì Salomon su anay sa sapian hurà makagbisti hu iling kadagway taini ha mga bulak. ");
INSERT INTO bkd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ku madagway sa kabuhata hu Dios hu mga sagbet ha laus dà agkangagangu daw bigsuli iyan kaw pa kan harì mailahan hu bisti. Imbà man kaatiyuay tungkay sa pagsalig nuy hu Dios? ");
INSERT INTO bkd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Aman harì kaw gayed masamuk hu kagi nuy ‘Inu gid sa agkan-en daw sa ag-inumen day daw sa agbistiyen day?’ ");
INSERT INTO bkd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta iyan dà agkasamuk sa mga etaw ha hurà pa makakilala hu Dios. Sa Amay nuy diyà ta langit natun-an din ha agkinahanglanen nuy gayed haena. ");
INSERT INTO bkd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Una hu alan ipagharì nuy sa Dios diyan ta inyu daw buhaten nuy sa matareng dayun iila din gayed inyu sa alan ha agkinahanglanen nuy. ");
INSERT INTO bkd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aman harì kaw agkasamuk ku inu sa maul-ulahan ku malugay ta ku makauma asem haena human nuy en henhenaa. Harì nuy enà iisab haena hu kasamukan nuy iman. ");
INSERT INTO bkd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Harì nuy aghukumi sa duma ha mga etaw ta daw harì kaw daan hukuman hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta ku inu sa ighukum nuy hu duma nuy iyan en daan haena ighukum inyu hu Dios, daw sa kabegat hu ighukum nuy iyan en daan haena kabegat hu ighukum inyu hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Imbà nuy man tag-ahaaya sa puling hu duma nuy? Hurà nuy ba diay katun-i ha sa inyu ha puling iling kaadagi hu batang? ");
INSERT INTO bkd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Imbà kaw tag-ikagi ha ag-awaen nuy haena sa atiyuay ha puling hu duma nuy ha sa inyu ha puling bà daan su batang? ");
INSERT INTO bkd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sinyu sa tagpasibù-sibù, unahen nuy gayed awaen sa puling nuy ha bà su batang na ku makaindan kaw en human nuy dayun awaa sa nakapuling duun hu duma nuy. ");
INSERT INTO bkd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Harì nuy iila duun hu mga asu sa mga butang hu Dios ta bà kaw dà taena kagata, daw harì nuy daan iglambeg sa mahalen ha perlas duun hu mga babuy ta bà dan dà haena takunai. ");
INSERT INTO bkd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Panayù kaw duun hu Dios ta ilahan kaw gayed kandin, pan-ahà kaw daw makaahà kaw, pangumaw kaw daw puwaan kaw kandin. ");
INSERT INTO bkd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta bisan sin-u sa agpanayù ag-ilahan daw saena ha agpan-ahà makaahà daw sa agpangumaw agpuwaan. ");
INSERT INTO bkd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ku amin inyu agpanayù sa batà nuy hu supas ag-ilahan nuy ba diay hu batu? ");
INSERT INTO bkd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Daw ku manayù hu sedà bunsalagan ba diay sa ig-ila nuy? ");
INSERT INTO bkd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ku sinyu sa mga etaw ha makasasalà agkatuen kaw tag-ila hu maayad duun hu mga batà nuy, labaw pa gayed sa Amay nuy diyà ta langit ta ku manayù kaw ilahan kaw gayed kandin hu mga maayad ha agpanayuen nuy. ");
INSERT INTO bkd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ku inu sa agkabayaan nuy ha buhaten diyan ta inyu hu mga duma nuy iyan daan haena buhaten nuy diyà ta kandan, ta iyan haena Kasuguan daw lalang hu Dios pinaagi hu mga propita. ");
INSERT INTO bkd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Duun kaw agi hu malig-et ha pultahan ta maluag sa pultahan daw malumu sa dalan payanaen diyà ta Inferno aman madakel sa duun tag-agi. ");
INSERT INTO bkd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Malig-et sa pultahan daw malegen sa dalan payanaen hu kinabuhì ha hurà din katapusan aman atiyuay dà sa pakatulen duun. ");
INSERT INTO bkd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-andam kaw hu mga manunudlù ha biduen ta saena dumiyan ta inyu ha bà su mga tumutuu ba sa mga tigtudlù dan makadaet inyu. ");
INSERT INTO bkd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Makilala nuy sidan ha biduen pinaagi hu tagbuhaten dan. Harì kuy makapanimù hu libas daw hu bugkà duun hu sampinit. ");
INSERT INTO bkd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Iling taena ha sa maayad ha kayu pulus dà gayed maayad sa bunga din, ba sa madaet ha kayu madaet en daan sa mga bunga din. ");
INSERT INTO bkd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sa kayu ha madaet sa bunga din bà dà haena pilaya daw bigsuli. ");
INSERT INTO bkd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aman sa etaw makilala nuy pinaagi hu tagbuhaten din. ");
INSERT INTO bkd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Amin mga etaw ha tag-ikagi hu Ginuu a kandan ba hurà sidan makalagkes duun hu tagharian hu Dios, ta iyan dà pakaseled duun taena sa tagtuman hu agkabayaan hu Amay ku diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Duun asem hu Aldaw hu Paghukum madakel sa mag-ikagi hu ‘Ginuu, pinaagi hu ngaran nu insaysay day sa impaikagi nu daw pigbugaw day sa mga busaw daw madakel pa gayed ha mga belenganen sa nabuhat day.’ ");
INSERT INTO bkd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba bà ku dà sidan ikagiyi hu ‘Harì ku inyu agkakilala aman paman-awà kaw dini ta kanak sinyu sa mga madaet sa buhat din.’ ");
INSERT INTO bkd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bisan sin-u sa tagpaliliman hu lalang ku daw magtuman daan taena agkailing hu etaw ha migbalay hu tungkay malig-en. ");
INSERT INTO bkd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Su mamagyu daw mamahà hurà gayed haena kapilay sa balay ta tungkay nalig-enan. ");
INSERT INTO bkd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ba saena ha tagpaliliman hu lalang ku ba harì tagtuman agkailing hu etaw ha bà dà miglawig. ");
INSERT INTO bkd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Su mamagyu daw mamahà napilay haena daw nakagas.” ");
INSERT INTO bkd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Su makapenga si Jesus magtudlù saena ha mga etaw nangabeleng ");
INSERT INTO bkd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta sa kandin ha pagtudlù amin duun gahem dì ku mga manunudlù hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Su tumubang en si Jesus duun ku bubungan madakel tungkay sa namanduma kandin. ");
INSERT INTO bkd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Amin daan sanglahen ha luminuhud diyà ta kandin daw hangyù hu “Ginuu, ku mabayà ka ngaay bulungen a ikaw taini ha mahugaw ha dalu ku.” ");
INSERT INTO bkd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dinampà hi Jesus su sanglahen daw ikagiyi hu “Agkabayà a aman maulian ka.” Sagunà haena naulian. ");
INSERT INTO bkd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Dayun inikagiyan hi Jesus hu “Harì ka manunultul hu bisan sin-u ba dumuun ka taena ha sinaligan hu paghalad ta daw masusi din ha naulian kad en. Maghalad ka sumalà hu Kasuguan hi Moises ta daw malimpyuwan ka daw matun-an hu mga etaw ha naulian kad en.” ");
INSERT INTO bkd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Su diyà en si Jesus ta Capernaum amin diyà kapitan hu sundalu ta Roma ha tuminalagbù ki Jesus daw hangyù hu ");
INSERT INTO bkd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ginuu, agkatungkayan hu dalu sa suluguen ku diyà ta balay na harì en pakakayug-kayug daw agkasakitan gayed.” ");
INSERT INTO bkd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tuminubag si Jesus hu “Ahaen ku iman haena ta daw maulian.” ");
INSERT INTO bkd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ba saena ha kapitan tuminubag hu “Ginuu, agkagayhà a ku dumiyà ka ta balay ku aman bà nu dà ikagiya ha maulian en haena sa suluguen ku. ");
INSERT INTO bkd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Natun-an ku ha mahimu nu haini ta siak suluguen a daan hu agalen ku ha sundalu daw amin daan mga sundalu ha sakup ku. Ku ipahipanaw ku sidan agtuu gayed. Bisan inu sa igsugù ku hu suluguen ku agbuhaten din daan haena.” ");
INSERT INTO bkd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Su mapaliman haena hi Jesus nabeleng gayed daw inikagiyan din su mga etaw ha namanduma kandin hu “Laus gayed sa ag-ikagiyen ku inyu ha hurà ku pa gayed naahà duun hu mga kaliwatan hi Israel ha agkailing taini sa pagtuu din. ");
INSERT INTO bkd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ikagiyen ku inyu ha amin asem madakel ha mga etaw iling kandin ha kenà Judio ha maamul-amul daw makigsalu diyà ki Abraham daw ki Isaac daw ki Jacob duun hu tagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ba sa mga Judio ha iyan ngaay pigtaganahan taena ha tagharian hu Dios ilambeg paman duun hu kasukileman diyà ta guwà ha duun sidan makag-ulahuay hu kalugul daw magkakangget sa mga ngipen dan hu kasakitan.” ");
INSERT INTO bkd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dayun inikagiyan hi Jesus haena sa kapitan ha “Umulì kad en ta saena ha suluguen nu ha agkadaluwan maulian en tumenged hu pagtuu nu.” Aman sagunà dayun haena naulian. ");
INSERT INTO bkd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Su sumeled en si Jesus diyà ta balay hi Pedro naahà din sa ugang ha bahi hi Pedro ha harì en pakabangun ta agkagenaw. ");
INSERT INTO bkd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inibitan hi Jesus sa alima taena aman sagunà naulian. Dayun migbangun haena daw sinugbahan din say Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Su madani en agpanukilem pinan-uwit hu mga etaw diyà ki Jesus sa mga pinan-ulinan en hu busaw, aman pinamugaw din sa mga busaw pinaagi hu mga lalang din daw naulian daan sa alan ha agkangadaluwan. ");
INSERT INTO bkd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nabuhat din haena ta daw matuman sa inikagi hi Isaias sa propita ha tagyanaen “Inawà din sa mga kaluyahen taw daw inuwit din sa mga dalu taw.” ");
INSERT INTO bkd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Su maahà hi Jesus sa madakel ha mga etaw ha nangaamul-amul diyà ta kandin inikagiyan din sa mga tinun-an din ha lumayun sidan duun taena ha danaw. ");
INSERT INTO bkd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Amin manunudlù hu Kasuguan ha uminubay diyà ki Jesus ha minikagi hu “Manunudlù, agduma a ikaw bisan hindu ka duun agpayanaen.” ");
INSERT INTO bkd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ba tuminubag si Jesus hu “Sa laku amin din tagtimaan daw sa mga tagbis amin dan daan mga dalagpuay, ba siak sa Suled hu Kaet-etawan hurà ku himlayà.” ");
INSERT INTO bkd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Amin pa daan sumusunud hi Jesus ha minikagi hu “Ginuu, harì a pa makaduma ikaw iman ta iglebeng ku pa si Amay.” ");
INSERT INTO bkd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ba inikagiyan haena hi Jesus ha “Dumuma kad kanak ta su mga etaw ha hurà dan pa kinabuhì iyan en maglebeng hu mga minatay.” ");
INSERT INTO bkd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Si Jesus luminulan hu barutu daw sa mga tinun-an din luminulan daan. ");
INSERT INTO bkd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Su taglulan en sidan tigkan namagyu aman nataguan hu wahig haena sa barutu. Ba si Jesus tagtiduga hu kandin. ");
INSERT INTO bkd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aman pinukaw ku mga tinun-an din daw ikagiyi hu “Ginuu, luwasa kay ikaw ta agkalened kuy en.” ");
INSERT INTO bkd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ba inikagiyan sidan hi Jesus hu “Imbà kaw man agkangahaldek? Harì kaw ba diay agsalig kanak?” Dayun migbangun si Jesus daw baldenga sa kalamag daw mga baled aman sagunà migleneng. ");
INSERT INTO bkd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Sa mga tinun-an hi Jesus tungkay gayed nangabeleng ha tagyanaen “Inu gid haini ha etawa ha bisan sa kalamag daw mga baled agtuu kandin?” ");
INSERT INTO bkd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Su makalayun en si Jesus daw sa mga tinun-an din diyà ta ubay ta Gadara amin diyà daruwa ha etaw ha nangapuun duun hu panlebengà ha inulinan en hu mga busaw. Mga mabis-ay gayed sidan aman harì pakaagi sa mga etaw duun taena. Ba su masal-aw dan si Jesus ");
INSERT INTO bkd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","nakapangulahì sidan ha tagyanaen “Inu sa labet nu kanay sikaw sa Batà hu Dios? Agpasipalahan kay ba ikaw iman bisan ku kenà pa haini panahun?” ");
INSERT INTO bkd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ubay diyà ta kandan sa madakel tungkay ha mga babuy ha tagpanuwalà ");
INSERT INTO bkd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","aman pinagayukan hu mga busaw si Jesus hu kagi dan “Ku agbugawen kay ikaw diyà kay ipaulì tayaa ha mga babuy.” ");
INSERT INTO bkd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Inikagiyan sidan hi Jesus hu “Pamandiyà kaw en.” Aman sagunà guminuwà su mga busaw duun ku daruwa ha etaw daw namanagù duun ku mga babuy. Namamulaguy su mga babuy diyà ta alug daw nangakasabay sidan duun ku danaw dayun nangamatay. ");
INSERT INTO bkd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Su mga etaw ha tagbantay ku mga babuy namamulaguy daan payanaen diyà ta banuwa daw intultul dan sa nahitabù ku mga babuy daw ku nainu-inu sa ingkaulii taena ha inulinan hu mga busaw. ");
INSERT INTO bkd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dayun inelegan si Jesus hu mga etaw. Su maahà dan haena pinagayukan dan ha umawà gayed duun taena ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Luminulan si Jesus duun hu barutu daw uminulì duun hu banuwa din diyà ta layun. ");
INSERT INTO bkd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amin mga etaw ha taglanting hu minatay en sa dibaluy ha lawa din daw inuwit dan haena diyà ki Jesus. Su matun-an hi Jesus ha adagi gayed sa pagsalig kandin taena ha mga etaw inikagiyan din su agkadaluwan hu “Magmalipayen ka ta napasaylu en sa mga salà nu.” ");
INSERT INTO bkd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Amin daan diyà mga manunudlù hu Kasuguan ha nakahenà-henà hu “Saini ha etawa tagtameyes gayed hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ba saena ha mga henà-henà dan natun-an hi Jesus aman inikagiyan din sidan hu “Imbà kaw taghenà-henaay hu madaet iling tayan? ");
INSERT INTO bkd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Inu diay sa malumu ha ikagiyen duun taini ha agkadaluwan? Iyan ba sa ‘Napasaylu en sa mga salà nu’ daw ku iyan ba sa ‘Bangun ka daw hipanaw kad en’? ");
INSERT INTO bkd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ba iman igpaahà ku inyu ha siak sa Suled hu Kaet-etawan amin ku kagahem dini ta kalibutan hu pagpasaylu hu mga salà.” Aman inikagiyan din su etaw ha minatay en sa dibaluy ha lawa din hu “Bangun kad, luluna sa banig nu daw ulì kad en.” ");
INSERT INTO bkd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sagunà haena minangun daw ulì. ");
INSERT INTO bkd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Su maahà haena hu mga etaw tungkay sidan nangabeleng daw dinayè dan sa Dios tumenged ta in-ila din ki Jesus sa kagahem ha iling taena. ");
INSERT INTO bkd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Su dumayun si Jesus naahà din sa tagpinuu ha tagpanukut hu buhis ha tagngaranan ki Mateo. Inikagiyan din haena ha “Dumuma ka kanak” aman huminitindeg si Mateo daw duma kandin. ");
INSERT INTO bkd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Su tagkaen si Jesus diyà ta balay hi Mateo madakel ha mga manunukut hu buhis daw mga masinupaken sa nakigsalu kandin daw hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Su maahà haena hu mga Fariseo nanginginsà sidan duun hu mga tinun-an hi Jesus hu “Imbà sa Manunudlù nuy pakigsalu ku mga limbungan ha manunukut hu buhis daw hu mga masinupaken?” ");
INSERT INTO bkd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Su mapaliman haena hi Jesus uminikagi hu “Sa harì agkadaluwan harì daan tagpabulung, ba sa agkadaluwan tagkinahanglan hu mamumulung. ");
INSERT INTO bkd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Susiyen nuy ku inu sa kahulugan hu lalang hu Dios ha tagyanaen ‘Magmahid-uwen kaw hu mga duma nuy ta iyan haini tungkay ku agkabayaan dì hu mga halad nuy.’ Ta sa pagdini ku kenà para hu mga matareng en ba sa tuyù ku iyan sa mga makasasalà.” ");
INSERT INTO bkd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Amin mga sumusunud hi Juan ha Bautista ha duminiyà ki Jesus daw panginginsà hu “Imbà sikay daw sa mga Fariseo tagsalang hu pagkaen ba sa ikaw ha mga tinun-an harì gayed tagsalang?” ");
INSERT INTO bkd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tuminubag si Jesus hu “Mabaluy ba diay ku amin kaamulan ha sa mga inimbita maglugul ku diyà pa ta kandan sa agpangasawa? Harì gayed haena mabaluy. Ba mauma sa panahun ha ipaawà en diyà ta kandan su agpangasawa daw human sidan agsalang hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Hurà etaw ha agtapikan din hu bag-u pa sa daan en ha pinaksuy ta su bag-u ha manggad bà dà aglegkè daw su daan ha pinaksuy bà dà daan agkahigbit. ");
INSERT INTO bkd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iling daan hu talaguay ha anis, ku daan en haena harì mabaluy ha taguan hu bag-u pa ha binu ta bà dà magbutu daw kahudhud su binu. Kinahanglan gayed ha sa bag-u pa ha binu duun dà daan itagù hu bag-u pa ha talaguay.” ");
INSERT INTO bkd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Su kamulu pa tag-ikagi si Jesus amin punuan ha nakauma daw luminuhud diyà ta kandin. Dayun minagayuk ki Jesus hu kagi din “Daw pa minatay su laga-laga ku, ba ku dumiyà ka daw dampaen nu haena mabanhaw dà gayed.” ");
INSERT INTO bkd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aman si Jesus daw sa mga tinun-an din duminuma ku punuan. ");
INSERT INTO bkd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Su diyà pa sidan ta dalan amin bahi ha sampulù en daw daruwa ha tuig sa kahudhud din. Saena uminubay diyà ta talikudan hi Jesus daw ibiti sa sagayadan hu pinaksuy taena ");
INSERT INTO bkd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ta nahenhenaan ku bahi ha “Bisan ku bà a dà makaibit duun hu pinaksuy hi Jesus maulian a gayed.” ");
INSERT INTO bkd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Su lumingì si Jesus naahà din haena aman inikagiyan din hu “Pandayai sa gahinawa nu ta sa ingkaulii nu iyan sa pagsalig nu kanak.” Sagunà naulian su bahi. ");
INSERT INTO bkd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Su sumeled en si Jesus duun hu balay ku punuan naahà din sa tagpamulalà daw sa madakel ha mga etaw ha ben kagulub en. ");
INSERT INTO bkd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dayun inikagiyan din su mga etaw hu “Paman-awà kaw dini ta saini ha batà hurà patay ba bà dà tagtiduga.” Ba bà dan dà agkapatawahi si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Su maman-awà en su mga etaw sumineled si Jesus daw ibiti sa alima ku batà aman nakabangun haena. ");
INSERT INTO bkd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Saini ha tultulanen nakalekep duun hu alan ha mga banuwa diyà. ");
INSERT INTO bkd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Su dumayun si Jesus amin daruwa ha buta ha luminupug kandin daw pangumaw hu “Sikaw sa Kaliwat hi David, kahid-uwi kay gayed ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Su sumeled en haena duun hu balay uminubay diyà ta kandin su daruwa ha buta, aman ininsaan sidan hi Jesus hu “Agtuu kaw ba ha mahimu ku ha maulian kaw?” Tuminubag sidan hu “Hee, Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dayun dinampà hi Jesus sa mga mata dan daw ikagi ha “Sumalà hu pagtuu nuy maulian kaw en.” ");
INSERT INTO bkd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Sagunà sidan nakaindan. Ba binalaudan sidan hi Jesus hu “Harì kaw gayed manunultul hu bisan sin-u mahitenged hu nahitabù inyu.” ");
INSERT INTO bkd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ba su humipanaw en sidan bà dà sidan nasì nanunultul mahitenged ki Jesus, aman saena nakalekep duun hu alan ha mga banuwa diyà. ");
INSERT INTO bkd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Su maipus en su nakaindan ha mga buta amin daan etaw ha naemaw tumenged ta inulinan hu busaw saena inuwit hu mga etaw diyà ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Su bugawen hi Jesus su busaw sagunà nakaikagi su emaw. Sa mga etaw diyà tungkay nangabeleng hu kagi dan “Dini ta bugtà ta Israel daw pa gayed nahitabù sa iling taini.” ");
INSERT INTO bkd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ba sa mga Fariseo minikagi hu “Agkabugaw din sa mga busaw pinaagi hu gahem taena ha agalen hu mga busaw.” ");
INSERT INTO bkd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nalekep hi Jesus sa alan ha banuwa daw migtudlù duun hu mga simbahan hu Maayad ha Tultulanen mahitenged hu pagharì hu Dios daw naulian din daan sa alan ha mga dalu hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Su maahà din sa kaet-etawan nahid-uwan din gayed sidan ta agkailing sidan hu mga karniro ha agkangasamuk daw tagkangalaag ta hurà duun magbalantay. ");
INSERT INTO bkd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dayun inikagiyan hi Jesus sa mga tinun-an din hu “Maluag gayed sa legtayen daw napanday en nahinug ba atiyuay dà sa agpamanlegtay duun. ");
INSERT INTO bkd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aman humangyù kaw duun hu Dios ha suguen din sa mamanlegtay taini ha uma din.” ");
INSERT INTO bkd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Inamul-amul hi Jesus su sampulù daw daruwa ha tinun-an din, dayun pinagaheman din sidan ta daw mabugaw dan sa mga busaw ha uminulin duun hu mga etaw daw maulian dan daan sa bisan inu ha dalu. ");
INSERT INTO bkd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iyan haini ngaran taena ha sampulù daw daruwa ha apostoles ha sinugù hi Jesus, si Simon ha tagngaranan daan ki Pedro daw si Andres sa suled din, si Santiago daw si Juan sa mga batà hi Zebedeo, ");
INSERT INTO bkd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe daw si Bartolome, si Tomas daw si Mateo sa manunukut hu buhis, si Santiago sa batà hi Alfeo daw si Tadeo, ");
INSERT INTO bkd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon sa sakup hu Cananiyo daw si Judas Iscariote ha iyan miglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Saena ha sampulù daw daruwa sinugù hi Jesus daw tinugun sidan hu kagi din “Harì kaw dumuun hu kenà mga Judio daw hu bisan hindu ha banuwa diyà ta Samaria, ");
INSERT INTO bkd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ba duun kaw dà payanaen hu mga kaliwatan hi Israel ta nailing en sidan hu mga karniro ha nangalaag. ");
INSERT INTO bkd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ku tagdiyà kaw en itultul nuy kandan ha madani en sa pagharì hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Maulian nuy sa agkangadaluwan daw banhawen nuy sa minatay en. Maulian nuy daan sa mga sanglahen daw bugawen nuy sa mga busaw ha uminulin duun hu mga etaw. Harì kaw manayù hu bayad duun hu mga etaw ha pigbuligan nuy ta sa gahem ha in-ila ku inyu hurà din bayad. ");
INSERT INTO bkd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Harì kaw daan mag-uwit hu salapì, ");
INSERT INTO bkd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","hu lutù daw hu ilisan nuy, hu sapatus nuy daw hu sugkud, ta sa tagtalabahu angayan ha ilahan gayed hu mga kinahanglanen din. ");
INSERT INTO bkd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Bisan hindu ha banuwa ha mauma nuy pan-ahaen nuy sa etaw ha agdawat inyu daw diyà kaw en magtimà hangtud ha umawà kaw duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ku agseled kaw en duun hu balay ikagiyan nuy sidan ha ‘Magmalinawen kaw gayed alan.’ ");
INSERT INTO bkd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Saena ha dumawat inyu malinawen gayed sa pagtimà dan. Ba ku harì kaw kandan dawaten hurà pulus ku umikagi kaw ha magmalinawen gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ku makauma kaw duun hu banuwa ba hurà en dumawat inyu daw harì daan sidan magpaliliman hu tigtultul nuy, awai haena ha balay daw ku banuwa. Ba pugpuga nuy sa aliyabuk diyan ta paa nuy ta iyan haena timaan ha silutan gayed sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Laus gayed sa ag-ikagiyen ku inyu ha asem ku Aldaw hu Paghukum mahagkap dà sa isilut hu Dios taena ha mga etaw diyà ta Sodoma daw ta Gomora dì hu mga etaw duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Agkailing kaw hu mga karniro daw agsuguen ku inyu duun hu mga etaw ha agkailing hu asu ha agpamangagat. Aman mag-andam kaw ba kinahanglan daan ha harì nuy mapasipalahan sa bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Magbantay kaw ta itugyan kaw asem duun hu maghukum inyu daw lagkutan kaw pa gayed kandan duun hu mga simbahan. ");
INSERT INTO bkd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ipaatubang kaw daan kandan duun hu mga gubernador daw mga harì tumenged hu pagtuu nuy kanak, ba iyan haena paagi ha matultul a inyu diyà ta kandan daw duun hu kenà mga Judio. ");
INSERT INTO bkd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ku dakepen kaw kandan harì kaw agkasamuk ku inu sa ipanubag nuy. Duun taena ha panahun sa Dios iyan magtudlù inyu ");
INSERT INTO bkd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ta sa ag-ikagiyen nuy kenà inyu ha lalang ba kandin en hu Balaan ha Ispiritu ha sinugù hu Dios ha Amay nuy. ");
INSERT INTO bkd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Duun taena ha panahun itugyan hu etaw sa suled din ta daw mapatay daw itugyan daan hu amay sa batà din. Sa mga batà sumukul hu mga laas dan daw pahimatayan dan daan. ");
INSERT INTO bkd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kuntrahen kaw hu kaet-etawan tumenged kanak, ba sa harì umendà hu pagtuu hangtud hu katapusan mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ku pasipalahan kaw kandan duun hu sabuwa ha banuwa pulaguy kaw duun hu lain. Laus gayed sa ag-ikagiyen ku inyu ha harì nuy pa makalekep sa Maayad ha Tultulanen diyà ta Israel lumikù ad en siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sa tagpatudlù kenà labaw dì hu tagtudlù kandin daw sa suluguen kenà labaw dì hu agalen din. ");
INSERT INTO bkd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ikalipay gayed hu tinudluan ku mailing daan hu tagtudlù kandin, daw ikalipay daan hu suluguen ku mailing hu agalen din. Ku pigngaranan a hu mga etaw ha Yawà ayuwà pa madaet sa ingaran dan inyu sinyu sa mga sakup ku. ");
INSERT INTO bkd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Harì kaw gayed mahaldek taena ha mga etaw. Sa alan ha inlilung iman makahiwal dà asem ku malugay, daw sa harì iman tag-ikagiyen mapaliman dà asem ku malugay. ");
INSERT INTO bkd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sa mga lalang ku ha iyan kaw dà nakapaliman duun ipanunultul nuy gayed duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Harì nuy agkahaldeki sa iyan din dà agkapatay sa lawa nuy ba harì din mapatay sa gimukud nuy. Ba iyan nuy kahaldeki sa Dios ha makapaagbul hu lawa nuy daw hu gimukud nuy diyà ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Henhenaa nuy ha bisan sa mga atiyuay ha tagbis harì agpatay ku harì igtugut hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Aman harì kaw agkasamuk ta mahal kaw pa dì hu mga tagbis, ta bisan sa buhuk nuy naiyap en hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Bisan sin-u haena sa ag-angken kanak duun hu mga etaw angkenen ku daan duun hu Amay ku diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ba sa tag-ikagi duun hu mga etaw ha harì a kandin agkakilala harì ku daan haena kilalahen duun hu Amay ku diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Harì nuy aghenhenaa ha sa pagdini ku ta kalibutan makaila inyu hu maayad ha pagdapità. Hurà a dini ta daw magmalinawen kaw ba sa pagdini ku makaila inyu hu kagubut. ");
INSERT INTO bkd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tumenged kanak sabaen hu batà ha maama sa amay din. Sabaen daan hu batà ha bahi sa inay din daw sabaen hu lagambay sa ugang din. ");
INSERT INTO bkd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta sa kuntra hu etaw duun dà agkapuun hu pamilya din. ");
INSERT INTO bkd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Bisan sin-u sa tungkay din palanggà sa mga laas din daw sa mga batà din dì kanak kenà angayan ha sumusunud ku. ");
INSERT INTO bkd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Bisan sin-u haena sa harì agkabayà tag-antus hu alan ha mga malegen bisan duun hu kamatayen saena kenà angayan ha sumusunud ku. ");
INSERT INTO bkd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak bisan duun hu kamatayen mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Bisan sin-u sa agdawat inyu agdawat daan kanak, daw saena ha agdawat kanak agdawat daan hu Dios ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bisan sin-u sa dumawat hu etaw ha tagsaysay hu igpaikagi hu Dios daw hu matareng ha etaw saena mailahan hu bales iling hu madawat taena ha dinawat din. ");
INSERT INTO bkd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Daw bisan sin-u sa makapainum hu bisan nangkatasa dà ha wahig duun hu pinakahudiyanan en ha sumusunud ku, balesan gayed haena hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Su makapenga en si Jesus hu mga panugun din duun taena ha sampulù daw daruwa ha tinun-an din duminuun dayun hu nakag-uubayà ha banuwa daw panudlù. ");
INSERT INTO bkd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Su diyà en ta purisuwan si Juan ha Bautista napaliman din sa mga binuhat hi Cristo, aman sinugù din sa mga sumusunud din ");
INSERT INTO bkd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ha insaan dan si Jesus hu “Iyan kad ba haena sa intagnà ha makauma dini ta kalibutan daw ku amin pa ba lain ha pagsalapen day?” ");
INSERT INTO bkd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tuminubag si Jesus hu “Likù kaw diyà ki Juan daw tultuli nuy hu napaliman nuy daw hu naahà nuy ha binuhat ku. ");
INSERT INTO bkd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Saena iyan sa nakaindan sa mga buta daw nakahipanaw sa mga pigket, nangaulian sa mga sanglahen daw nakapaliman daan sa mga bengel. Amin en daan nabanhaw ha minatay daw sa Maayad ha Tultulanen insangyaw en daan duun hu mga makaluluuy ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Malipayen gayed sa etaw ha harì tagduwa-duwa hu pagsalig din kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Su tag-ulì en haena sa mga sumusunud hi Juan inikagiyan hi Jesus sa mga kaet-etawan hu “Inu sa tuyù nuy su dumiyà kaw ki Juan duun taena ha pinakabulung-bulung ha lugar? Duminiyà kaw ba hu pag-ahà hu etaw ha agkailing hu salaysay ha ku agkalamagen agkahuyung dà? ");
INSERT INTO bkd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Duminiyà kaw ba daan ta daw maahà nuy sa tungkay madagway ha pinaksuy din? Hurà gayed ta sa etaw ha tagpinaksuy hu madagway duun taw dà agkaahà hu mga balay hu harì. ");
INSERT INTO bkd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kenà ba iyan man inahà nuy diyà sa propita? Laus gayed ha propita si Juan daw labaw pa haena ");
INSERT INTO bkd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ta iyan en su sinubay duun hu insulat ha lalang hu Dios ha tagyanaen ‘Igpauna ku dì ikaw ta daw makapangandam hu ag-agiyan nu.’ ");
INSERT INTO bkd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Laus gayed sa tag-ikagiyen ku inyu ha duun taini ha kalibutan hurà en labaw dì ki Juan ha Bautista, ba bisan sa kinaatiyuayan ha tagharian hu Dios labaw pa daan dì ki Juan. ");
INSERT INTO bkd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sugud dà duun hu pagtudlù hi Juan ha Bautista sa mga etaw tagsalapà gayed ha magharì en kandan sa Dios, aman sa duma agpegesen dan ngaay haena ha magharì en. ");
INSERT INTO bkd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta sa pagharì hu Dios inikagi en hu mga propita daw bisan duun hu Kasuguan payanaen ki Juan. ");
INSERT INTO bkd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Maayad ku tuuwan nuy gayed ha si Juan iyan katumanan hu tagnà ha makauna si Elias dini dì hu Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Henhenaa nuy gayed sa napaliman nuy ha inikagi ku. ");
INSERT INTO bkd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Inu man sa agpailingan ku inyu? Agkailing kaw hu mga batà ha tag-alù-alù duun hu baligyaanan ha tag-ikagi duun hu mga duma dan hu ‘Tagkanta kay ba bà su hurà nuy duun labet. Taglugul kay ba harì kaw tag-agalà hu inyu.’ ");
INSERT INTO bkd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Su makauma si Juan sa tagsalang hu pagkaen daw hurà inum hu binu inikagi nuy ha bà dà haena agkalibeg. ");
INSERT INTO bkd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Siak sa Suled hu Kaet-etawan sa harì tagsalang hu pagkaen daw pag-inum kagi nuy paman ‘Ahà kaw tayana ha agapan daw beleng-beleng, sa mga amigu din mga limbungan ha mga manunukut hu buhis daw mga masinupaken.’ Ba pinaagi hu maayad ha bunga hu mga buhat day napamatud-an ha hustu gayed sa mga paagi hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hinukuman hi Jesus sa tagtimà duun hu mga banuwa ha pigpaahaan din hu mga belenganen ta hurà sidan maghinulsul. Inikagiyan din sidan hu ");
INSERT INTO bkd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Sinyu sa taga-Corazin daw taga-Betsaida, kahid-u nuy gayed ta sa mga belenganen ha binuhat ku diyan ta inyu, ku naahà pa ngaay hu kenà mga Judio diyà ta Tiro daw ta Sidon maghinulsul gayed sidan daw magbasul hu mga salà dan. ");
INSERT INTO bkd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba ikagiyen ku inyu ha asem ku Aldaw hu Paghukum mahagkap dà sa isilut hu Dios taena ha mga etaw diyà ta Tiro daw ta Sidon dì hu inyu. ");
INSERT INTO bkd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Daw sinyu daan sa taga-Capernaum, kagi nuy ha iyan kaw en mga matangkaw ha etaw ba ilambeg kaw asem diyà ta Kamatayan, ta sa mga belenganen ha naahà nuy ku iyan pa ngaay nakaahà duun sa mga etaw diyà ta Sodoma harì ngaay haena bigsulan na duduun pa gan haena. ");
INSERT INTO bkd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ba ikagiyen ku inyu ha asem ku Aldaw hu Paghukum mahagkap dà sa isilut hu Dios taena ha mga etaw diyà ta Sodoma dì hu inyu.” ");
INSERT INTO bkd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Duun taena ha panahun mig-ampù si Jesus hu “Amay ku ha Magbabayà hu alan diyan ta langit daw dini ta kalibutan, adagi sa pagpasalamat ku ikaw ta sa inlilung duun hu mga matatau daw nangakatunghà ha mga etaw impadayag nud en duun hu mga etaw ha harì pa agpakatuen iling hu mga batà. ");
INSERT INTO bkd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aman Amay ku, tagpasalamat a gayed diyan ta ikaw hu kabuhata nu duun tumenged ta iyan haena agkabayà-bayaan nu.” ");
INSERT INTO bkd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dayun minikagi si Jesus duun hu mga etaw ha “Insalig en kanak hu Dios ha Amay ku sa alan. Iyan dà haena nakakilala kanak daw iyan a dà daan nakakilala kandin daw iyan dà daan sa mga etaw ha agkabayaan ku ha makakilala kandin. ");
INSERT INTO bkd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Sinyu sa agkapedaan daw agkabegat-begatan, dumini kaw ta kanak ta igpahimlay ku inyu. ");
INSERT INTO bkd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Buhaten nuy sa igsugù ku inyu daw magtuen kaw dini ta kanak ta daw makahimlay kaw, ta maluluy-en daw tagpaubus a. ");
INSERT INTO bkd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa igsugù ku inyu mahagkap dà tungkay daw kenà malegen ha agbuhaten.” ");
INSERT INTO bkd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Amin aldaw hu Sabado ha nakaagi say Jesus duun hu uma. Tumenged ta agkangauhul en sa mga tinun-an din namanimù sidan hu bunga taena ha mga pamulahen duun daw kinaen dan. ");
INSERT INTO bkd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ba su maahà haena hu mga Fariseo inikagiyan dan si Jesus hu “Ahaa sa mga tinun-an nu ta nasupak dan gayed sa Kasuguan mahitenged hu Aldaw hu Paghimlay.” ");
INSERT INTO bkd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ba tuminubag si Jesus ha “Hurà nuy ba diay kabasa haena sa binuhat hi David su mangauhul sidan hu mga duma din? ");
INSERT INTO bkd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sumineled haena duun ku Tabernaculo daw kan-a su supas ha inhalad duun hu Dios dayun inilahan din su mga duma din bisan ku para dà ngaay haena hu mga sinaligan hu paghalad. ");
INSERT INTO bkd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Daw hurà nuy pa ba diay daan kabasa duun hu Kasuguan ha sa mga sinaligan hu paghalad duun hu Timplo harì daan sidan taghimlay duun hu Aldaw hu Paghimlay? Ba hurà sidan makasalà. ");
INSERT INTO bkd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ikagiyen ku inyu ha amin nakadini ta inyu ha labaw pa dì hu Timplo. ");
INSERT INTO bkd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sa lalang hu Dios tagyanaen ‘Magmahid-uwen kaw hu mga duma nuy ta iyan haini tungkayan ku agkabayaan dì hu mga halad nuy.’ Ku natun-an nuy pa ngaay haena harì kaw ngaay maghukum hu mga etaw ha hurà din salà. ");
INSERT INTO bkd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ta siak sa Suled hu Kaet-etawan iyan a tagbayà hu Aldaw hu Paghimlay.” ");
INSERT INTO bkd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Duminayun si Jesus diyà ta simbahan ");
INSERT INTO bkd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","daw amin daan etaw diyà ha kimay. Diyà daan sa mga etaw ha tagpan-ahà hu katarengan ta daw makasumbung dan si Jesus aman ininsaan dan hu “Igtugut ba hu Kasuguan ha mamulung kuy hu agkadaluwan ku Aldaw hu Paghimlay?” ");
INSERT INTO bkd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Si Jesus tuminubag ha “Ku amin nuy karniro ha mahulug duun hu bangbang ku Aldaw hu Paghimlay saena butwaen nuy gayed dì ba? ");
INSERT INTO bkd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mahal pa gayed sa etaw dì hu karniro, aman ku agbulig kuy hu etaw duun hu Aldaw hu Paghimlay saena harì pakasupak hu Kasuguan.” ");
INSERT INTO bkd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dayun inikagiyan din haena sa kimay ha “Bunhata sa alima nu.” Aman binunhat din haena dayun sagunà naulian. ");
INSERT INTO bkd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Su mga Fariseo namangguwà daw miglalang-lalang sidan ku in-inuwen dan sa kahimatayi ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tumenged ta natun-an hi Jesus sa agbuhaten hu mga Fariseo minawà haena diyà. Madakel ha mga etaw sa namanduma kandin daw naulian din sa alan ha agkangadaluwan, ");
INSERT INTO bkd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ba binalaudan sidan hi Jesus ha harì dan gayed haena ikagiyen ku sin-u. ");
INSERT INTO bkd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nahitabù haena ta daw matuman sa lalang hu Dios pinaagi ki Isaias sa propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iyan haini suluguen ha pinilì ku daw tungkay ku gayed palanggà ha tigkabayà-bayà ku. Paulinan ku haini hu Balaan ha Ispiritu daw isangyaw din sa matareng ha paghukum ku duun hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Harì haini makigsawalà ba manayù-nayù sa pag-ikagi din, daw harì daan bà dà tagpapalpaliman hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Harì din bà dà agbalia sa sedsed ha nabalukù daw harì din daan bà dà agpedengi sa sulù ha tagpedek-pedek en, ba agbuligan din haena sa maluya sa pagsalig din duun hu Dios ta daw harì sidan bà dà kalaag. Harì din haena ag-endaan pagbuhat hangtud ha sa pagkamatareng makalekep en duun hu bisan hindu. ");
INSERT INTO bkd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iyan haini paghinamen hu alan ha kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Amin etaw ha nabuta daw naemaw tumenged ta inulinan hu busaw saena inuwit hu mga etaw diyà ki Jesus. Naulian din haena aman sagunà nakaindan daw nakaikagi. ");
INSERT INTO bkd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sa alan ha mga etaw ha nakaahà taena tungkay nangabeleng daw nakaikagi sidan hu “Iyan en gid haini su Mesiyas ha intagnà ha Kaliwat hi David.” ");
INSERT INTO bkd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ba su mapaliman haena hu mga Fariseo minikagi sidan hu “Sa gahem taini ha etaw hu pagbugaw hu busaw diyà dà napuun ki Beelsebul sa agalen hu mga busaw.” ");
INSERT INTO bkd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Natun-an hi Jesus sa henà-henà dan aman inikagiyan din sidan hu “Sa ginharian ha tagsasabà sa mga etaw duun agkabengkag gayed, daw sa pamilya daw ku banuwa ba ha magsasabà mabengkag daan haena. ");
INSERT INTO bkd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aman ku sabaen hi Satanas sa mga sakup din sa ginharian din mabengkag gayed. ");
INSERT INTO bkd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ku laus pa ngaay sa inikagi nuy ha sa gahem ku hu pagbugaw taena ha mga busaw in-ila kanak hi Beelsebul, sin-u diay sa mig-ila hu gahem taena ha mga duma nuy ha tagpamugaw daan hu mga busaw? Pinaagi hu mga buhat dan natun-an taw ha sayep sa tag-ikagiyen nuy. ");
INSERT INTO bkd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Saini ha gahem ku duun gayed napuun hu Balaan ha Ispiritu. Iyan haena igkatun-i taw ha iman tagharì en sa Dios dini ta kanuy. ");
INSERT INTO bkd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Henhenaa nuy ha hurà bisan sin-u ha makaseled duun hu balay hu mabis-ay ha etaw hu pag-agaw hu mga butang din ku harì din unahen bakusen su mabis-ay ha etaw daw human din katimù sa mga butang duun taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Bisan sin-u sa kenà ku duma iyan gayed agsupak kanak, daw saena ha harì agbulig kanak iyan ag-abug hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aman ag-ikagiyen ku inyu ha mabaluy pa ha mapasaylu sa alan ha mga salà hu etaw bisan sa pagtameyes hu duma, ba sa pagtameyes hu Balaan ha Ispiritu harì gayed mapasaylu. ");
INSERT INTO bkd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bisan sin-u haena sa magtameyes kanak siak sa Suled hu Kaet-etawan mabaluy pa ha pasayluwen, ba sa magtameyes hu Balaan ha Ispiritu harì en gayed mapasaylu iman daw hangtud hu hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Sa maayad ha kayu pulus dà gayed maayad sa bunga din, ba sa madaet ha kayu madaet en daan sa bunga din. Agkakilala taw sa kayu pinaagi hu bunga din. ");
INSERT INTO bkd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sinyu sa mga bunsalagan, in-inuwen nuy pag-ikagi hu maayad ha mga madaet kaw man? Ta ku inu sa duun hu henà-henà hu etaw iyan daan haena agkaikagi din. ");
INSERT INTO bkd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sa maayad ha etaw maayad daan sa agkaikagi din, ba sa madaet ha etaw madaet daan sa pag-ikagi din. ");
INSERT INTO bkd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ikagiyen ku inyu ha asem ku Aldaw hu Paghukum sa kada sabuwa inyu agpanubag duun hu Dios mahitenged taena ha nangaikagi nuy ha hurà din pulus, ");
INSERT INTO bkd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ta sa alan ha mga naikagi nuy iyan dà maghukum inyu ku silutan kaw ba daw ku harì.” ");
INSERT INTO bkd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Amin mga manunudlù hu Kasuguan daw mga Fariseo ha minikagi diyà ki Jesus hu “Manunudlù, ipaahà kay ikaw hu timaan ha belenganen.” ");
INSERT INTO bkd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ba tuminubag si Jesus hu “Sa mga etaw iman ha madaet sa mga buhat dan daw nakadiyù en duun hu Dios iyan tagpan-ahà hu mga belenganen. Ba iyan dà makapaahà ku inyu ha timaan sa naul-ulahan hi Jonas ha propita ");
INSERT INTO bkd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ta si Jonas linam-ed hu adagi ha sedà ba duun hu tatulu ha aldaw imbula dà. Siak sa Suled hu Kaet-etawan makaduun a daan hu alima hu kamatayen ba sugud taena payanaen hu tatulu ha aldaw mabanhaw a dà. ");
INSERT INTO bkd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Asem ku Aldaw hu Paghukum hukuman kaw hu silut taena ha mga taga-Ninive ta mighinulsul sidan hu mga salà dan su mapaliman dan sa intultul hi Jonas. Ba iman dini en sa labaw pa dì ki Jonas ba harì nuy agdawaten. ");
INSERT INTO bkd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hukuman kaw daan asem hu silut taena ha rayna ta Sheba ta saena madiyù sa hinipanawan din hu pagpaliliman hu katudluanan hi Harì Salomon. Ba iman dini en sa matatau pa dì ki Salomon ba harì nuy agtuuwan. ");
INSERT INTO bkd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ku umawà en sa busaw duun hu etaw ha inulinan din aghipanaw haena ta agpan-ahà hu agtimaan din. Ba ku harì en makaahà ");
INSERT INTO bkd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","agkahenhenaan din ha lumikù dà duun taena ha pigtimaan din su anay. Ku maahà din dà haena ha hurà en duun tagtimà daw limpyu en ");
INSERT INTO bkd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","agpangembang su busaw hu pitu ha duma din ha ayuwà pa madaet dì kandin daw ulinan dan dà paman haena sa etaw. Aman ayuwà pa malegen sa kahimtang taena ha etaw dì su anay. Iyan daan haena maul-ulahan hu madaet ha mga etaw iman.” ");
INSERT INTO bkd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Su kamulu pa si Jesus tag-ikagi duun taena ha madakel ha mga etaw nakauma si Inay din daw sa mga suled din ta amin dan ag-ikagiyen kandin, ba diyà dà sidan tagtiyadeg ta guwà. ");
INSERT INTO bkd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Amin etaw ha uminikagi diyà ki Jesus hu “Si Inay nu daw sa mga suled nu diyà tagtiyadeg ta guwà ta amin dan kun ag-ikagiyen ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ba si Jesus tuminubag hu “Iman ikagiyen ku inyu ku sin-u sa inay ku daw sa mga suled ku.” ");
INSERT INTO bkd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dayun intuen din sa mga sumusunud din daw ikagi hu “Taini en sa inay ku daw sa mga suled ku ");
INSERT INTO bkd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ta bisan sin-u sa tagtuman hu agkabayaan hu Amay ku diyà ta langit iyan en haena inay ku daw mga suled ku.” ");
INSERT INTO bkd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Duun taena ha aldaw uminawà si Jesus diyà ta balay daw pinuu duun hu kilid ku danaw. ");
INSERT INTO bkd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tumenged ta madakel tungkay sa mga etaw ha nangaamul-amul diyà ta kandin mininuu haena duun hu barutu na sa mga etaw diyà dà ta gaun hu pagpaliliman kandin. ");
INSERT INTO bkd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Dayun madakel sa mga intudlù din kandan pinaagi hu mga pananglitan ha tagyanaen “Amin etaw ha duminiyà ta uma hu pagpamegas. ");
INSERT INTO bkd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Su isawed din haena sa binhì amin diyà dà nakatanà ta dalan aman pinanukà hu mga tagbis. ");
INSERT INTO bkd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Amin daan binhì ha duun dà nakatanà hu batuwen. Saena laus dà lumineteb ta atiyuay dà sa pisà duun, ");
INSERT INTO bkd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ba su sildahan hu tungkay mapasù sagunà dà haena nangagangu ta hurà man panggamut. ");
INSERT INTO bkd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Amin daan binhì ha duun nakatanà hu sampiniten. Tuminubù daan haena ba naenep dà hu mga sampinit. ");
INSERT INTO bkd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ba amin binhì ha duun nakatanà hu balumbun ha bugtà. Saena tuminubù daan daw namunga gayed, sa duma duun tignanggatus sa bunga din daw sa duma daan namunga hu tigkaeneman na amin daan namunga hu tigkatluan. ");
INSERT INTO bkd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Uminubay diyà ki Jesus sa mga tinun-an din daw panginginsà hu “Imbà mga pananglitan sa taggamiten nu ku tagtudlù ka hu mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tuminubag si Jesus hu “Sa inlilung su anay mahitenged hu pagharì hu Dios impadayag en inyu, ba saena hurà katun-i hu duma ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa etaw ha amin en kandin mailahan hu tungkay pa gayed madakel dì hu kinahanglanen din, ba saena ha hurà din en hu kandin bisan su iyan-iyan din dà timuen pa gayed diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iyan haini hinengdan ha mga pananglitan sa taggamiten ku ta ‘Tag-ahà sidan ba harì pakaindan, daw tagpaliliman daan sidan ba harì pakasabut.’ ");
INSERT INTO bkd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natuman diyà ta kandan sa inikagi hi Isaias sa propita ha tagyanaen ‘Sigi dà sidan tagpalilimanà ba harì sidan pakasabut daw sigi dà sidan tag-ahaay ba harì sidan pakaindan, ");
INSERT INTO bkd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ta inipelan dan sa mga talinga dan daw taglipedengà sidan daw tungkay gayed madesen sa henà-henà dan. Ta ku pakaindan pa daw pakasabut ngaay sidan maghinulsul gayed hu mga salà dan daw luwasen sidan hu Dios.’ ");
INSERT INTO bkd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ba malipayen kaw gayed ta nakaindan kaw daw nakapaliman kaw daan. ");
INSERT INTO bkd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Laus gayed sa ag-ikagiyen ku inyu ha madakel ngaay sa mga propita daw matareng ha etaw su anay ha agkabayà tungkay ag-ahà hu naahà nuy iman daw agpaliliman ngaay daan hu napaliman nuy iman, ba hurà dan en gayed haena kahimu. ");
INSERT INTO bkd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Magpaliliman kaw en ta ag-ikagiyen ku inyu sa kahulugan taena ha pananglitan mahitenged hu namegas. ");
INSERT INTO bkd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ku amin mga etaw ha nakapaliman mahitenged hu pagharì hu Dios ba hurà makasabut taena, agkailing sidan hu binhì ha diyà dà nakatanà ta dalan ta sagunà pakauma si Satanas daw agawen din sa napaliman dan. ");
INSERT INTO bkd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Su binhì ha duun dà nakatanà hu batuwen iyan su mga etaw ha nakapaliman hu lalang hu Dios daw sagunà duminawat taena ha malipayen. ");
INSERT INTO bkd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ba tumenged ta harì agpanggamut sa pagtuu dan saena harì en agkalugay. Ku makauma sa malegen ha alantusen daw pasipalahan sidan tumenged hu pagdawat dan hu lalang hu Dios sagunà dà sidan ag-endà hu pagtuu. ");
INSERT INTO bkd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Su binhì ha duun nakatanà ku sampiniten iyan su mga etaw ha nakapaliman en hu lalang hu Dios. Ba tumenged hu mga kasamukan dan dini ta kalibutan daw hu kabayà dan ha magsapian sidan sa lalang hu Dios agkalipatan dan dà aman harì en haena agpamunga diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ba su binhì ha duun nakatanà hu balumbun ha bugtà iyan su mga etaw ha nakapaliman hu lalang hu Dios daw nakasabut taena aman agpamunga. Sa duma agpamunga hu madakel daw sa duma tumanan dà sa bunga dan, sa duma atiyù dà daan sa bunga dan.” ");
INSERT INTO bkd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Amin pa pananglitan ha inikagi hi Jesus ha tagyanaen “Sa pagharì hu Dios agkailing hu etaw ha namegas hu maayad ha binhì duun hu uma din. ");
INSERT INTO bkd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ba su tagtiduga en haena su daleman nakauma daan sa kuntra din dayun migsawed hu mga lisu hu hilamunen duun taena ha uma daw awà. ");
INSERT INTO bkd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aman su mamunga en su impamegas ha binhì nakaamul daan duun sa hilamunen. ");
INSERT INTO bkd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Su mga suluguen taena ha etaw duminiyà ta kandin daw uminikagi hu ‘Maayad sa impamegas ha binhì duun taini ha uma nu. Hindu gid hayana napuun sa mga hilamunen?’ ");
INSERT INTO bkd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Saena ha etaw tuminubag hu ‘Sa kuntra ku migsawed tayana.’ “Aman minikagi sa mga suluguen din hu ‘Agkabayà ka ba ha baduten day en hayana sa mga hilamunen?’ ");
INSERT INTO bkd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ba saena ha etaw tuminubag hu ‘Harì nuy pa enà ta makalagkes kan sa pamulahen taw. ");
INSERT INTO bkd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ipatayà en enà taman hu tilegtay. Asem ku tilegtay ikagiyan ku sa agpamanlegtay ha unahen dan amulen sa mga hilamunen daw bigsuli daw human su impamegas daw itagù duun hu bugawan.’” ");
INSERT INTO bkd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Amin pa pananglitan ha inikagi hi Jesus ha tagyanaen “Sa pag-adagi hu tagharian hu Dios agkailing hu lisu ha impamegas duun hu uma. ");
INSERT INTO bkd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bisan ku atiyuay gayed tungkay ha lisu ba ku tumubù en haena mabuhat ha tungkay kinaadagiyan ha pamulahen daw sa mga panga din mabuhat ha dalagpuay daw salagà hu mga tagbis.” ");
INSERT INTO bkd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Amin pa lain ha pananglitan ha inikagi hi Jesus ha tagyanaen “Sa tagharian hu Dios agkailing daan hu igpatulin ha iglamud duun hu madakel ha harina dayun su harina agtulin.” ");
INSERT INTO bkd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Inikagi haena hi Jesus duun hu mga etaw pinaagi hu mga pananglitan. Sa alan ha inikagi hi Jesus kandan pinaagi dà gayed hu mga pananglitan. ");
INSERT INTO bkd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aman natuman sa inikagi hu propita ha tagyanaen “Mga pananglitan sa aggamiten ku ku tag-ikagi a duun hu mga etaw. Igtultul ku kandan haena sa inlilung sugud dà hu katanghagaa ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Su umawà si Jesus duun ku madakel ha mga etaw sumineled haena diyà ta balay. Dayun uminubay diyà ta kandin su mga tinun-an din ha minikagi hu “Saysaya kanay sa kahulugan taena ha pananglitan nu mahitenged hu hilamunen duun hu uma.” ");
INSERT INTO bkd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tuminubag si Jesus hu “Siak sa Suled hu Kaet-etawan iyan a su namegas hu maayad ha binhì. ");
INSERT INTO bkd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Saena ha uma iyan sa kalibutan daw su maayad ha binhì iyan sa mga tagharian hu Dios. Saena ha mga hilamunen iyan sa mga sakup hi Satanas ");
INSERT INTO bkd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","daw su kuntra ku ha migsawed ku lisu taena ha hilamunen iyan si Satanas. Sa tilegtay iyan sa katapusan hu panahun daw sa agpamanlegtay iyan sa mga balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Iling hu hilamunen ha agsakemen daw bigsuli iyan daan haena maul-ulahan hu katapusan hu panahun. ");
INSERT INTO bkd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Siak sa Suled hu Kaet-etawan agsuguen ku sa mga balinsuguen hu Dios ha amul-amulen dan sa mga etaw ha migbuhat hu madaet daw su mga etaw ha iyan igpakasalà hu mga duma dan ");
INSERT INTO bkd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","daw ipanlambeg sidan diyà ta Inferno ha duun sidan makag-ulahuay hu kalugul daw magkakangget sa mga ngipen dan hu kasakitan. ");
INSERT INTO bkd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dayun sa mga matareng ha etaw mailing hu aldaw ha magpangaluanlag duun hu tagharian hu Dios ha Amay dan. Henhenaa nuy gayed sa napaliman nuy ha inikagi ku. ");
INSERT INTO bkd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Sa tagharian hu Dios agkailing hu bulawan ha nakalebeng duun hu uma. Amin etaw ha nakaahà duun aman tungkay gayed nalipay. Ba bà din dà haena tinambuni daw pauulì. Dayun impamaligyà din sa alan ha mga butang din daw palilikù hu pagpalit taena ha uma. ");
INSERT INTO bkd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Sa tagharian hu Dios agkailing daan taena ha agpanapì pinaagi hu pagpamalit hu perlas. ");
INSERT INTO bkd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Su makaahà haena hu tungkay madagway ha perlas imbaligyà din sa alan ha mga butang din daw palita haena sa madagway ha perlas. ");
INSERT INTO bkd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Sa tagharian hu Dios agkailing daan hu baling ha inlabya duun hu danaw. Ku mataguan en haena hu migkalain-lain ha sedà ");
INSERT INTO bkd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","guyuden haena hu mamamaling diyà ta gaun. Dayun pamilien dan sa maayad duun daw itagù duun hu talaguay, ba sa mga madaet duun bà dan dà iglambeg. ");
INSERT INTO bkd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iyan daan haena maul-ulahan asem duun hu katapusan hu panahun. Igtapid hu mga balinsuguen hu Dios sa madaet ha etaw duun taena ha matareng ");
INSERT INTO bkd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","daw ipanlambeg sa madaet diyà ta Inferno ha duun sidan makag-ulahuay hu kalugul daw magkakangget sa mga ngipen dan hu kasakitan.” ");
INSERT INTO bkd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dayun ininsaan sidan hi Jesus hu “Nasabut nuy ba sa tag-ikagiyen ku?” Tuminubag sidan hu “Hee.” ");
INSERT INTO bkd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Inikagiyan din sidan hu “Sa manunudlù hu Kasuguan ha tinudluan mahitenged hu tagharian hu Dios agkailing hu etaw ha madakel tungkay sa mga butang din diyà ta balay din, daw saena ha mga butang kenà alan dà karaan ba amin daan duun mga bag-u.” ");
INSERT INTO bkd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Su mapengahan hi Jesus ikagiya sa mga pananglitan luminikù duun hu kandin ha banuwa daw migtudlù duun hu simbahan. Ba sa nakapaliman kandin tungkay nangabeleng hu kagi dan “Sin-u gid sa migtudlù kandin daw imbà pakahimu hu mga belenganen? ");
INSERT INTO bkd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kenà ba batà man hayana hu panday daw sa inay din iyan man si Maria, sa mga suled din iyan si Santiago daw si Jose, si Simon daw si Judas, ");
INSERT INTO bkd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","daw dini dà daan tagtimà sa mga atebay din? Imbà din agkahimu sa mga belenganen?” ");
INSERT INTO bkd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tumenged taena hurà dan dawata sa intudlù din. Inikagiyan sidan hi Jesus hu “Sa propita agtahuran duun hu bisan hindu ha lugar dì hu kandin ha banuwa daw duun hu balay din.” ");
INSERT INTO bkd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tumenged ta harì en daan sidan agtuu kandin atiyuay dà sa impaahà din kandan ha mga belenganen. ");
INSERT INTO bkd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Duun taena ha panahun napaliman hi Harì Herodes sa mga tultulanen mahitenged ki Jesus, ");
INSERT INTO bkd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aman inikagiyan din sa mga sinaligan din hu “Iyan haena si Juan ha Bautista ha nabanhaw aman agkahimu din sa mga belenganen.” ");
INSERT INTO bkd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Si Herodes iyan migsugù ha dakepen si Juan daw bakusa diyà ta purisuwan. Binuhat din haena tumenged ta inasawa hi Herodes si Herodias sa asawa daan hu suled din ha si Felipe ");
INSERT INTO bkd_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ba inikagiyan hi Juan si Herodes hu “Nasupak nu gayed sa Kasuguan tumenged ta inasawa nu sa asawa hu suled nu.” ");
INSERT INTO bkd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Aghimatayan ngaay hi Herodes si Juan ba agkahaldek daan hu mga Judio ta tinuuwan dan si Juan ha propita gayed. ");
INSERT INTO bkd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Su aldaw ha agsaulugen hi Herodes sa kabataa kandin suminayaw sa laga hi Herodias duun hu atubangan taena ha nangaamul-amul diyà. Tumenged ta tungkay gayed haena nabayà-bayaan hi Herodes ");
INSERT INTO bkd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","impanumpà din ha iila din sa bisan inu ha panayuen taena ha suminayaw. ");
INSERT INTO bkd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tinudluan hi Herodias su laga din aman uminikagi haena hu “Iila nu iman kanak sa ulu hi Juan ha Bautista ha iugsak duun hu lampay.” ");
INSERT INTO bkd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tungkay gayed ngaay naguul su harì ba tumenged hu panumpà din duun hu atubangan taena ha inimbita din insugù din ha buhaten haena sa pinanayù ku laga. ");
INSERT INTO bkd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aman pinungulan si Juan diyà ta purisuwan ");
INSERT INTO bkd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","daw iugsak sa ulu din duun hu lampay. Dayun indawag duun ku laga aman inuwit din haena diyà ki Inay din. ");
INSERT INTO bkd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sa lawa hi Juan tinimù hu mga sumusunud din diyà ta purisuwan daw ilebeng. Dayun duminiyà sidan ki Jesus daw itultul haena. ");
INSERT INTO bkd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Su mapaliman hi Jesus sa tultul mahitenged hu kamatayen hi Juan luminulan haena duun hu barutu ha iyan dà sidan hu mga tinun-an din daw duun hu pinakabulung-bulung ha lugar. Ba su mapaliman hu mga etaw ha tagtimà duun taena ha mga banuwa namanlupug sidan ki Jesus ba diyà sidan uminagi ta gaun. ");
INSERT INTO bkd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Su kumawas en si Jesus duun ku barutu naahà din sa madakel tungkay ha mga etaw aman nahid-uwan din gayed sidan dayun naulian din sa agkangadaluwan. ");
INSERT INTO bkd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Su panday en agkahapun inikagiyan si Jesus hu mga tinun-an din hu “Agkahapun en daw pinakabulung-bulung haini ha lugar. Sugua nud en sa mga etaw ha mamanduun sidan hu mga banuwa ta daw makapalit sidan hu agkan-en dan.” ");
INSERT INTO bkd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ba si Jesus tuminubag hu “Kenà en kinahanglan ha maman-ulì sidan. Iyan kaw en mag-ila kandan hu pagkaen.” ");
INSERT INTO bkd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Minikagi sidan hu “Amin dini pagkaen ba lalima dà ha buuk ha supas daw daruwa dà daan ha buuk ha sedà.” ");
INSERT INTO bkd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Inikagiyan sidan hi Jesus ha “Uwita dini ta kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dayun impapinuu din su mga etaw ta saena sagbeten ha bugtà. Tinimù din su lalima ha supas daw su daruwa ha sedà dayun huminangad diyà ta langit daw ampui haena. Su makapenga en mag-ampù pinangebing din su supas daw sugua su mga tinun-an din ha ipakaen haena hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Su mangabuhì en sidan pinangamul hu mga tinun-an su nasamà duun, saena sampulù pa daw daruwa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lalima ha libu sa kadakelen hu mga maama ha nangakakaen daw amin pa mga bahi daw mga batà. ");
INSERT INTO bkd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Impalulan hi Jesus sa mga tinun-an din duun hu barutu ta daw makauna en sidan diyà ta layun ku danaw. Dayun impaulì din su mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Su maipus en sidan si Jesus duminuun hu buntud daw mig-ampù ha sabubuwa dà. Su agpanukilem en didiyà pa si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ba su barutu ha taglulanan hu mga tinun-an din diyà en ta taliwarà taena ha danaw daw saena tagkakiling-kiling en tumenged hu adagi ha baled ta natalagbù dan sa kalamag. ");
INSERT INTO bkd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Su madani en agkaaldaw si Jesus luminupug kandan sa huminipanaw duun taena ha wahig ta ag-amul diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Su maahà hu mga tinun-an haena sa bayà-bayà en taghipanaw diyà ta wahig tungkay gayed sidan nangahaldek, aman nakapangulahì sidan hu “Kalag en hayana.” ");
INSERT INTO bkd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ba inikagiyan sidan hi Jesus hu “Pandayai nuy sa gahinawa nuy daw harì kaw agkangahaldek ta iyan a haini.” ");
INSERT INTO bkd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dayun minikagi si Pedro hu “Ginuu, ku laus ha iyan ka hayan ipadiyan a daan.” ");
INSERT INTO bkd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tuminubag si Jesus ha “Dumini kad en.” Aman uminawà si Pedro duun taena ha barutu daw hipanaw diyà ta wahig payanaen ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ba su magedam din sa maseleg ha kalamag nahaldek haena. Aman agkalened en ngaay ba nakapangulahì hu “Ginuu, buligi a.” ");
INSERT INTO bkd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sagunà haena inibitan hi Jesus daw ikagiyi hu “Imbà ka man tagduwa-duwa? Harì ka ba diay agsalig kanak?” ");
INSERT INTO bkd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Su lumulan en sidan duun ku barutu uminendà daan sa kalamag. ");
INSERT INTO bkd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dayun sa mga tinun-an din duun ku barutu suminimba ki Jesus hu kagi dan “Batà ka gayed hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Su makalayun en si Jesus daw sa mga tinun-an din diyà ta Genesaret ");
INSERT INTO bkd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","nakilala si Jesus hu mga etaw diyà, aman pinaelegan dan sa mga agkangadaluwan duun hu ubayà dan ha mga banuwa. Pinan-uwit haena diyà ki Jesus ");
INSERT INTO bkd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","daw pinagayukan dan si Jesus ha su agkangadaluwan makaibit ngaay duun hu sagayadan hu pinaksuy din. Sa alan ha nakaibit duun nangaulian gayed. ");
INSERT INTO bkd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Amin mga Fariseo daw mga manunudlù hu Kasuguan ha nangapuun ta Jerusalem ha namandiyà ki Jesus daw ikagiyi hu ");
INSERT INTO bkd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Imbà supaka hu mga tinun-an nu sa tulumanen ha imbilin kanuy hu mga gin-apuan taw? Ta harì en sidan agpamangenaw ta alima dan ku agkaen.” ");
INSERT INTO bkd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ba si Jesus tuminubag hu “Imbà nuy daan supaka sa Kasuguan hu Dios ta daw iyan nuy dà matuman sa inyu ha tulumanen? ");
INSERT INTO bkd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta inikagi hu Dios ha ‘Tahura sa mga laas nuy’ daw ‘Saena ha tagtameyes hu mga laas din kinahanglan ha himatayan.’ ");
INSERT INTO bkd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ba kagi nuy ha agkabaluy ha bà nuy dà ikagiyi sa mga laas nuy hu ‘Taini ngaay sa igbulig ku inyu ba ighalad ku duun hu Dios’ aman harì kaw pakabulig hu mga laas nuy. ");
INSERT INTO bkd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Saena ha binuhat nuy kenà gayed pagtahud hu mga laas. Aman tumenged taena ha tulumanen nuy binuhat nuy ha hurà pulus hu Kasuguan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bà kaw dà gayed tagpasibù-sibù. Laus gayed sa intagnà hi Isaias mahitenged inyu ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Saini ha mga etaw tag-ikagi ha tagtahuran a kandan ba sa henà-henà dan hurà dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sa pagsimba dan kanak hurà din pulus daw sa katudluanan dan bà dà mga tulumanen ha binuhat hu etaw.’” ");
INSERT INTO bkd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Inamul-amul hi Jesus sa mga etaw daw ikagiyi sidan hu “Magpaliliman kaw gayed daw sabuta nuy haini. ");
INSERT INTO bkd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sa igpakasalà hu etaw kenà iyan sa agkangakaen din ba iyan sa mga madaet ha lalang ha agkapuun duun hu bàbà din.” ");
INSERT INTO bkd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dayun uminubay diyà ta kandin sa mga tinun-an din hu kagi dan “Hurà nu ba katun-i ha nangasilag su mga Fariseo taena ha inikagi nu?” ");
INSERT INTO bkd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ba si Jesus tuminubag hu “Aghilamunen sa agtubù ha hurà ipamula hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bay-ani nuy sa mga Fariseo ta agkailing sidan hu buta ha tagkipit daan hu duma din ha buta na bà dà sidan agkangahulug duun hu bangbang.” ");
INSERT INTO bkd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Minikagi si Pedro diyà ki Jesus hu “Saysaya nu kanay haena sa pananglitan nu.” ");
INSERT INTO bkd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Inikagiyan sidan hi Jesus ha “Hurà kaw pa ba diay daan makasabut? ");
INSERT INTO bkd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Harì nuy ba diay agkatun-an ha sa agkangakaen hu etaw bà dà agsagad diyà ta getek din dayun agkaawà dà haena? ");
INSERT INTO bkd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ba sa agkaikagi hu etaw diyà gayed agkapuun ta gahinawa din daw iyan haena igpakasalà din. ");
INSERT INTO bkd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta duun hu gahinawa agkapuun sa madaet ha henà-henà, sa pagpangimatay daw sa pagpanapaw, sa pagbuhat hu malaw-ay daw sa pagpanakaw, sa pagbutang-butang daw sa pagdaet hu dengeg. ");
INSERT INTO bkd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iyan haena igpakasalà hu etaw, ba saena ha tulumanen hu pagpangenaw ta alima daw human kaen kenà iyan igpakasalà hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Uminawà diyà si Jesus daw duminuun hu lugar ha ubay ta Tiro daw ta Sidon. ");
INSERT INTO bkd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amin diyà bahi ha sa mga kapuun din su anay taga-Canaan ha duminiyà ki Jesus daw hangyù hu “Ginuu ha Kaliwat hi David, kahid-uwi a ikaw. Agkatungkayan sa laga-laga ku ta inulinan hu busaw.” ");
INSERT INTO bkd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ba si Jesus hurà en magtubag. Aman sa mga tinun-an din pinagayukan dan si Jesus hu “Ipaawà hayana sa taglupugà kanuy ha bahi ta pinakauleg.” ");
INSERT INTO bkd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Inikagiyan hi Jesus su bahi ha “Iyan dà pinaelegan kanak hu Dios sa mga kaliwatan hi Israel ta agkailing sidan hu nangalaag ha mga karniro.” ");
INSERT INTO bkd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ba saena ha bahi bà dà luminuhud duun hu atubangan hi Jesus ha tagyanaen “Ginuu, buligi a gayed ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Minikagi si Jesus hu “Kenà maayad ku agawen sa tagkan-en hu batà daw ipakaen hu mga asu.” ");
INSERT INTO bkd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tuminubag su bahi ha “Ginuu, laus gayed hayana ba bisan sa mga asu pakakaen daan hu mumu duun hu lamisa taena ha agalen dan.” ");
INSERT INTO bkd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Inikagiyan hi Jesus su bahi ha “Tungkay gayed adagi sa pagtuu nu aman sa agpanayuen nu kanak buhaten ku.” Sagunà naulian su laga-laga ku bahi. ");
INSERT INTO bkd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Minawà si Jesus diyà daw duun minagi ku kilid taena ha Danaw ta Galilea. Dayun duminuun hu buntud daw pinuu. ");
INSERT INTO bkd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Namandiyà daan ta kandin sa madakel tungkay ha mga etaw ha tag-uuwit hu mga pigket daw mga buta, mga piang daw mga emaw daw amin pa daan madakel gayed ha agkangadaluwan. Impan-ugsak dan haena duun hu atubangan hi Jesus dayun nangaulian sidan. ");
INSERT INTO bkd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Su maahà haena hu mga etaw tungkay sidan nangabeleng ta pakaikagi en su emaw daw pakahipanaw en daan su pigket, pakaindan en su buta daw naulian daan su piang. Aman dinayè dan sa Dios ha iyan Dios hu kaliwatan hi Israel. ");
INSERT INTO bkd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Inamul hi Jesus sa mga tinun-an din daw ikagiyi sidan hu “Agkahid-uwan ku haini sa mga etaw ta tatulu en ha aldaw sa pagduma-dumahà dan kanuy daw hurà dan en gayed agkakaen. Harì ku agkabayaan ha ipaulì ku sidan ha hurà dan makaen ta kan ku tasien sidan diyà ta dalan.” ");
INSERT INTO bkd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ba tuminubag su mga tinun-an din hu “Hindu kay duun makatimù hu igpakaen kandan ta pinakabulung-bulung haini ha lugar daw madakel tungkay sidan?” ");
INSERT INTO bkd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ininsaan sidan hi Jesus hu “Pila ha buuk sa supas nuy?” Tuminubag sidan hu “Pitu dà ha buuk daw amin daan atitiyuay ha sedà ha pila dà daan ha buuk.” ");
INSERT INTO bkd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Impapinuu hi Jesus sa mga etaw diyà ta bugtà. ");
INSERT INTO bkd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tinimù din su pitu ha supas daw su sedà dayun ampui haena. Su makapenga en mag-ampù pinangebing din daw sugua su mga tinun-an din ha ipakaen haena hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Su mangabuhì en sidan pinangamul hu mga tinun-an su nasamà duun, saena pitu pa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Haepat ha libu sa kadakelen hu mga maama ha nangakakaen daw amin pa mga bahi daw mga batà. ");
INSERT INTO bkd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Su ipaulì hi Jesus su mga etaw luminulan hu kandin duun hu barutu payanaen diyà ta Magadan. ");
INSERT INTO bkd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Amin mga Fariseo daw Saduceo ha duminiyà ki Jesus hu pagsulay kandin, aman hinangyù dan si Jesus ha ipaahà din kandan sa belenganen ha iyan timaan ha sinugù haena hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ba si Jesus tuminubag ha “Ku mapawà sa langit ku daleman pakaikagi kaw hu ‘Agsilda asem.’ ");
INSERT INTO bkd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ku agdaklep ku maselem pakaikagi kaw daan hu ‘Ag-udan.’ Natun-an nuy sa mga timaan hu panahun, ba imbà nuy harì agkatun-i sa timaan hu agkaula-ula iman? ");
INSERT INTO bkd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sa mga etaw iman ha madaet sa mga buhat dan daw nakadiyù en duun hu Dios iyan tagpan-ahà hu mga belenganen, ba iyan dà makapaahà ku inyu ha timaan sa naul-ulahan hi Jonas ha propita.” Dayun inawaan sidan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Su lumayun en say Jesus duun ku danaw nalipat sa mga tinun-an din pag-uwit hu supas. ");
INSERT INTO bkd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Inikagiyan sidan hi Jesus hu “Magbantay kaw hu igpatulin taena ha mga Fariseo daw Saduceo.” ");
INSERT INTO bkd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aman miglalang-lalang sa mga tinun-an din hu “Iyan gid ta hurà kuy makauwit hu supas.” ");
INSERT INTO bkd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ba saena natun-an hi Jesus aman inikagiyan din sidan hu “Imbà kaw tag-ikagi ha hurà kaw makag-uwit hu supas? Harì kaw ba diay agsalig kanak? ");
INSERT INTO bkd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Harì kaw pa ba diay pakasabut? Nalipatan nuy en ba diay haena sa lalima ha libu ha mga etaw ha impakaen ku hu lalima dà ha buuk ha supas? Pila man ha ambung sa nasamà duun? ");
INSERT INTO bkd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Daw nalipatan nuy en ba daan haena sa haepat ha libu ha mga etaw ha impakaen ku hu pitu dà ha buuk ha supas? Pila man daan ha ambung sa nasamà duun? ");
INSERT INTO bkd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Imbà nuy harì agkasabut ha kenà supas sa tagsubayen ku? Ba magbantay kaw hu igpatulin taena ha mga Fariseo daw Saduceo.” ");
INSERT INTO bkd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dayun human natun-i ku mga tinun-an hi Jesus ha kenà diay iyan bantayan dan sa igpatulin duun hu supas ba iyan sa mga katudluanan hu mga Fariseo daw Saduceo. ");
INSERT INTO bkd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Su makauma say Jesus duun hu lugar ha ubay ta Cesarea Filipos ininsaan din sa mga tinun-an din hu “Siak sa Suled hu Kaet-etawan, sin-u a man duun hu pag-ikagi hu mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tuminubag sidan hu “Sa duma tag-ikagi ha iyan ka kun si Juan ha Bautista daw sa duma tag-ikagi daan ha iyan ka kun si Elias. Sa duma tag-ikagi ha iyan ka kun si Jeremias daw ku iyan ka ba sa sabuwa duun hu mga propita.” ");
INSERT INTO bkd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ininsaan sidan hi Jesus hu “Sinyu, sin-u a man duun hu henà-henà nuy?” ");
INSERT INTO bkd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tuminubag si Simon Pedro hu “Iyan ka su Mesiyas sa Batà hu bubuhay ha Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Inikagiyan haena hi Jesus hu “Simon ha batà hi Juan, napanalanginan ka ta sa ingkatun-i nu tayana kenà pinaagi hu etaw dà ta impadayag ikaw hu Amay ku diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ikagiyen ku ikaw ha iman sa ngaran nu iyan si Pedro ha tagkahulugan hu Batu. Saena ha inikagi nu mahitenged kanak iyan daan batu ha malig-en ha duun taena agtukura sa alan ha tumuu kanak daw saena harì en gayed madaeg bisan pa hu kamatayen. ");
INSERT INTO bkd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iman igsalig ku ikaw sa yawi ta daw mapuwaan nu sa henà-henà hu etaw ha agharian hu Dios. Saena ha igbaldeng nu dini ta kalibutan imbaldeng en hu Dios diyà ta langit, daw sa igtugut nu dini ta kalibutan intugut en hu Dios diyà ta langit.” ");
INSERT INTO bkd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dayun binalaudan hi Jesus sa mga tinun-an din ha harì gayed manunultul ha si Jesus iyan en su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Sugud taena sinaysay hi Jesus duun hu mga tinun-an din ha kinahanglan ha dumiyà gayed ta Jerusalem daw mag-antus hu madakel ha mga pasipala hu mga magulang daw hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan, daw pahimatayan dan gayed ba duun hu ikatulu ha aldaw mabanhaw dà. ");
INSERT INTO bkd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Inubayan hi Pedro si Jesus daw baldenga hu kagi din “Ginuu, harì hayan mahitabù ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ba sumininalu si Jesus diyà ki Pedro daw ikagi hu “Awà ka dini ta kanak, Satanas. Agkaelangan a ikaw ta sa henà-henà nu kenà kandin hu Dios ba kandin dà hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dayun inikagiyan hi Jesus sa mga tinun-an din hu “Bisan sin-u sa agkabayà agsunud kanak kinahanglan ha lipatan din gayed sa kandin ha agkabayaan daw antusen din sa alan ha mga malegen bisan duun hu kamatayen ta daw makasunud kanak. ");
INSERT INTO bkd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak bisan duun hu kamatayen mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inu man sa pulus hu etaw ku maangken din sa tibuuk ha kalibutan ba malaag sa kinabuhì din? Hurà gayed pakapalit hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Siak sa Suled hu Kaet-etawan aglikù a dà dini ku malugay duma hu mga balinsuguen hu Dios daw magpangaluanlag a iling hu Dios ha Amay ku. Duun asem taena balesan din sa kada sabuwa sumalà hu mga binuhat dan. ");
INSERT INTO bkd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Laus gayed sa ag-ikagiyen ku inyu ha amin inyu tagtiyadeg dini iman ha harì pa matay na maahà ad en inyu ha Harì.” ");
INSERT INTO bkd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Su maiwas en sa haenem ha aldaw dinuma hi Jesus si Pedro, si Santiago daw sa suled hi Santiago ha si Juan duun hu matangkaw ha bubungan ha iyan dà sidan. ");
INSERT INTO bkd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Duun hu atubangan dan tigkan nahalin si Jesus. Sa weleng din tagpangaluanlag iling hu aldaw daw sa pinaksuy din ben kaputì en gayed. ");
INSERT INTO bkd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tigkan daan nakahiwal diyà ta kandan si Moises daw si Elias ha nakiglalang ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dayun minikagi si Pedro diyà ki Jesus hu “Ginuu, maayad ta dini kay. Ku mabayà ka buhatan ku iman inyu hu tatulu ha lawig ta daw matukid kaw ki Moises daw ki Elias.” ");
INSERT INTO bkd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Su tag-ikagi pa si Pedro amin tagpangaluanlag ha gabun ha nakabungkus kandan, daw amin lageng ha napuun duun ku gabun ha tagyanaen “Iyan en haini pinalanggà ku ha Batà ha tigkabayà-bayà ku. Magpaliliman kaw kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Su mapaliman haena ku mga tinun-an nangahaldekan gayed sidan aman nangakaeb-eb sidan. ");
INSERT INTO bkd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ba inubayan sidan hi Jesus daw pan-ibiti sidan dayun ikagiyi hu “Bangun kaw daw harì kaw agkangahaldek.” ");
INSERT INTO bkd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Su humangad sidan iyan dan dà naahà si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Su tagtubang en sidan diyà ta alug binalaudan sidan hi Jesus hu “Harì nuy itultul haena sa naahà nuy hangtud ha mabanhaw a sa Suled hu Kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nanginginsà sa mga tinun-an diyà ta kandin hu “Imbà sa mga manunudlù hu Kasuguan tag-ikagi ha kinahanglan ha si Elias makauna gayed dini dì hu Mesiyas?” ");
INSERT INTO bkd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Si Jesus tuminubag hu “Laus gayed ha mauna dini si Elias daw mapamandayan din sa alan. ");
INSERT INTO bkd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ba ikagiyen ku inyu ha nakadini en si Elias ba hurà kakilala hu mga etaw aman bà dan dà pinasipalahi sumalà hu agkabayaan dan. Iling taena ipaantus a daan kandan siak sa Suled hu Kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dayun human nasabut hu mga tinun-an din ha iyan din tagsubayen si Juan ha Bautista. ");
INSERT INTO bkd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Su makauma si Jesus daw su tatulu ha tinun-an din duun hu mga etaw amin daan etaw ha luminuhud duun hu atubangan din ");
INSERT INTO bkd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ha minikagi hu “Ginuu, kahid-uwi sa batà ku ha maama ta agkabidbid daw tag-antus gayed. Kapila en makaagbul duun hu hapuy daw duun hu wahig. ");
INSERT INTO bkd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inuwit kud en duun hu mga tinun-an nu ba hurà dan gayed kaulii.” ");
INSERT INTO bkd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Minikagi si Jesus hu “Sinyu ha mga etaw sa harì agtuu daw suminuway duun hu pagkamatareng, nalugay en sa pagduma-dumahà taw. Inu pa diay kalugay sa pag-angat ku ha tumuu kaw kanak? Uwita dini hayana sa batà.” ");
INSERT INTO bkd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Binaldeng hi Jesus su busaw ha uminulin taena ha batà aman sagunà guminuwà su busaw dayun naulian su batà. ");
INSERT INTO bkd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Duminiyà ki Jesus sa mga tinun-an din ha iyan dà sidan daw ininsaan dan hu “Imbà day hurà kabugaw su busaw ha uminulin ku batà?” ");
INSERT INTO bkd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tuminubag si Jesus ha “Hurà nuy haena kabugaw ta kulang gayed sa pagtuu nuy. Laus gayed sa ag-ikagiyen ku inyu ha ku sa pagtuu nuy iling dà kaatiyù hu lisu hu mustasa mahimu en ha suguen nuy hayana sa bubungan ha humalin diyà ta alug na makahalin gayed. Hurà gayed harì nuy mahimu. ");
INSERT INTO bkd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ba saena ha kalasi hu busaw mabugaw pinaagi dà gayed hu harì agkaelangan ha pag-ampù.” ");
INSERT INTO bkd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Su panahun ha naamul si Jesus daw sa mga tinun-an din diyà ta Galilea inikagiyan sidan hi Jesus hu “Siak sa Suled hu Kaet-etawan laus ad en itugyan duun hu aghimatay kanak ba duun hu ikatulu ha aldaw mabanhaw a dà.” Tumenged taena nangaguul sa mga tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Su makauma en si Jesus daw sa mga tinun-an din diyà ta Capernaum ininsaan si Pedro hu mga manunukut hu buhis ta Timplo hu “Tagbayad ba sa Manunudlù nuy hu buhis taena ha Timplo?” ");
INSERT INTO bkd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tuminubag si Pedro hu “Hee”. Su makaseled en si Pedro diyà ta balay sagunà ininsaan hi Jesus hu “Simon, inu sa kahenhenaa nu taini? Sin-u ba sa tagbayad hu buhis duun hu mga harì dini ta kalibutan? Iyan ba sa mga sakup din daw ku iyan ba sa mga langyaw?” ");
INSERT INTO bkd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tuminubag si Pedro hu “Iyan sa mga langyaw.” Si Jesus minikagi ha “Ku iyan hayan harì ngaay magbayad hu buhis sa mga sakup hu harì. ");
INSERT INTO bkd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ba para ha harì ki mapaukan taena ha mga manunukut hu buhis pamanuwit ka diyà tayà ha danaw. Sa una ha sumambat ikaw timuen nu sa salapì diyà ta bàbà din ta tumanan en haena ha ibayad ta hu buhis ta Timplo.” ");
INSERT INTO bkd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Duun taena ha panahun duminiyà ki Jesus sa mga tinun-an din daw ininsaan dan hu “Sin-u sa labaw duun hu tagharian hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Inumaw hi Jesus sa sabuwa ha atiyuay ha batà daw ipaatubang din duun hu mga tinun-an din ");
INSERT INTO bkd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","daw ikagi hu “Laus gayed sa ag-ikagiyen ku inyu ha harì kaw gayed maharian hu Dios ku harì kaw maghinulsul daw harì kaw daan mailing hu mga atiyuay ha mga batà. ");
INSERT INTO bkd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bisan sin-u sa magpaubus iling taini ha atiyuay ha batà iyan labaw duun hu tagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Daw bisan sin-u haena sa agdawat hu batà iling taini tumenged kanak agdawat daan kanak. ");
INSERT INTO bkd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Bisan sin-u haena sa iyan agkahimu ha igpakasalà hu nakatuu en kanak maayad pa ngaay ku ihiket sa lieg din duun hu adagi ha batu daw leneda diyà ta dagat. ");
INSERT INTO bkd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pinakahaluhid-u gayed sa kaet-etawan tumenged hu panulay ha igpakasalà dan. Iyan en haena bagad dini ta kalibutan ba kahid-u gayed taena ha iyan agkahimu ha panulay. ");
INSERT INTO bkd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ku iyan igpakasalà nuy sa alima nuy daw sa paa nuy tampeda en haena daw ilambeg. Maayad pa ku pungkul kaw ba amin nuy kinabuhì ha hurà din katapusan dì sa daruwa sa alima nuy daw sa paa nuy ba ilambeg kaw diyà ta Inferno ha duun sa hapuy ha harì en agkapedengan. ");
INSERT INTO bkd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Daw ku iyan daan igpakasalà nuy sa sabuwa ha mata nuy lugita en haena daw ilambeg. Maayad pa ha sabuwa dà sa mata nuy ba amin nuy kinabuhì ha hurà din katapusan dì sa daruwa ba ilambeg kaw diyà ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mag-andam kaw ha harì nuy maminusan haena sa agkailing hu atiyuay ha mga batà, ta ikagiyen ku inyu ha sa balinsuguen hu Dios ha tagbantay kandan harì gayed agsuway duun hu atubangan hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Siak sa Suled hu Kaet-etawan duminini a ta kalibutan hu pagpan-ahà daw hu pagluwas taena ha nangalaag. ");
INSERT INTO bkd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Inu man sa henà-henà nuy? Ku amin etaw ha amin din nanggatus ha mga karniro daw nalaag sa sabuwa duun, inu gid sa buhaten din? Sa buhaten din iyan sa awaan din su kasiyaman daw siyam duun hu balalayan daw pan-ahaa su sabuwa ha nalaag. ");
INSERT INTO bkd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Laus gayed sa ag-ikagiyen ku inyu ha ku matulen din en haena sa sabuwa adagi pa gayed sa kalipay din duun dì taena ha kasiyaman daw siyam ha hurà kalaag. ");
INSERT INTO bkd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iling daan hu Amay taw diyà ta langit ha harì agkabayà ha amin malaag duun hu mga batà din. ");
INSERT INTO bkd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ku amin nu duma ha nakasalà diyan ta ikaw elegan nu haena daw ikagiyi hu salà din ha iyan kaw dà. Ku pagpalimanan ka kandin makag-uliay kaw hu maayad ha pagdapità. ");
INSERT INTO bkd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ba ku harì ka kandin palimanan tumimù ka hu sabuwa daw ku daruwa ba ha makapanistigus taena ha inikagi nu diyà ta kandin, ta ku amin sumbung kinahanglan gayed ha amin daruwa daw ku tatulu ha makapanistigus taena. ");
INSERT INTO bkd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ku harì pa gayed magpaliliman isumbung haena duun hu tagkaamul-amul ha mga tumutuu ha duma nu. Ku harì pa gayed magpaliliman isipen nuy en haena ha hurà makakilala hu Dios daw iling hu limbungan. ");
INSERT INTO bkd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Laus gayed sa ag-ikagiyen ku inyu ha sa igbaldeng nuy dini ta kalibutan imbaldeng en hu Dios diyà ta langit, daw sa igtugut nuy dini ta kalibutan intugut en hu Dios diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Amin ku pa ag-ikagiyen ha ku amin daruwa inyu ha makag-uyun hu agpanayuen nuy duun hu Amay ku diyà ta langit saena iila din gayed. ");
INSERT INTO bkd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta ku amin bisan daruwa dà daw ku tatulu ba ha mag-amul-amul hu pagsimba kanak diyà a daan duma kandan.” ");
INSERT INTO bkd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Duminiyà si Pedro ki Jesus daw nanginginsà hu “Ginuu, kapila ku ba pasayluwa sa duma ku ha sigi dà pakasalà dini ta kanak? Taman ba hu kapitu?” ");
INSERT INTO bkd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tuminubag si Jesus hu “Ikagiyen ku ikaw ha kenà bà dà kapitu ba pitu ha kapituwan. ");
INSERT INTO bkd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Sa pagharì hu Dios agkailing hu harì ha nakahenà-henà ha husayen din sa mga utang hu mga suluguen din diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aman pinaelegan din su sabuwa ha nakautang hu sampulù ha libu. ");
INSERT INTO bkd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tumenged ta harì gayed pakabayad insugù ku harì ha ibaligyà haena sa nakautang daw sa pamilya din daw sa mga butang din ta daw mabayaran sa utang din. ");
INSERT INTO bkd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ba su suluguen luminuhud duun hu atubangan taena ha harì daw pagayuk hu kagi din ‘Ilahi a enà ikaw hu panahun ta agpan-ahà a pa hu igbayad ku ikaw.’ ");
INSERT INTO bkd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nahid-uwan haena ku harì aman pinanas din sa mga utang taena daw ipaulì. ");
INSERT INTO bkd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ba su tag-ulì en haena nasal-aw din su duma din ha suluguen ha nakautang daan diyà ta kandin hu pila dà ha salapì. Pinekel din dayun su suluguen daw ikagiyi hu ‘Bayari en su utang nu kanak.’ ");
INSERT INTO bkd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Luminuhud daan haena diyà ta kandin daw pagayuk hu ‘Ilahi a enà ikaw hu panahun ta agpan-ahà a pa hu igbayad ku ikaw.’ ");
INSERT INTO bkd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ba hurà din gayed haena kahid-uwi daw bà din dà paman impapurisu taman ha makabayad. ");
INSERT INTO bkd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Su maahà haena hu mga duma din ha suluguen nangapauk gayed sidan aman insumbung dan duun ku harì. ");
INSERT INTO bkd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Dayun pinaelegan ku harì su suluguen din daw ikagiyi hu ‘Madaet ka gayed ha suluguen ta pinanas kud sa ikaw ha mga utang dini ta kanak ta migpagayuk ka. ");
INSERT INTO bkd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Imbà nu hurà kahid-uwi su duma nu ha nakautang diyan ta ikaw iling hu kahid-uwi ku ikaw?’ ");
INSERT INTO bkd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Napauk gayed tungkay haena sa harì aman impapurisu din haena sa suluguen taman ha maaminan din mabayaran sa utang din. ");
INSERT INTO bkd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Iling daan taena sa buhaten diyan ta inyu hu Amay ku diyà ta langit ku harì nuy gayed pasayluwen sa duma nuy.” ");
INSERT INTO bkd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Su makapenga si Jesus magtudlù uminawà diyà ta Galilea daw likù ta Judea layun ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Madakel daan sa agkangadaluwan ha namanduma kandin daw nangaulian din sidan diyà. ");
INSERT INTO bkd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Amin daan mga Fariseo ha duminiyà ki Jesus hu pagsulay kandin aman ininsaan dan hu “Intugut ba hu Kasuguan taw ha endaan hu maama sa asawa din bisan ku hurà hinengdan?” ");
INSERT INTO bkd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tuminubag si Jesus ha “Hurà nuy ba diay kabasa sa lalang hu Dios ha tagyanaen ‘Su tanghagaen hu Dios sa alan binuhat din sa maama daw sa bahi’? ");
INSERT INTO bkd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Daw tagyanaen daan ‘Iyan haini hinengdan ha ag-awaan hu maama sa mga laas din daw duun en ag-amul hu asawa din ta nasabuwa en sidan sa daruwa ha etaw.’ ");
INSERT INTO bkd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pinaagi taena kenà en sidan daruwa ba sabuwa dà. Aman sa sinabuwa en hu Dios harì gayed mabaluy ha ipagsuwayà hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ba su mga Fariseo uminikagi hu “Imbà isugù hi Moises ha sa maama ku agkabayaan din en ag-endai sa asawa din ilahan din haena hu kasulatan hu pag-endaay dayun human din ipahipanaw?” ");
INSERT INTO bkd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tuminubag si Jesus hu “Intugut hi Moises sa pag-endaay ta madesen gayed sa henà-henà nuy, ba su tanghagaen hu Dios sa alan hurà din itugut sa pag-endaay hu mig-asawa. ");
INSERT INTO bkd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ikagiyen ku inyu ha saena ha ag-endaan din sa asawa din ha hurà makasalà na ku mangasawa hu lain ha bahi makapanapaw.” ");
INSERT INTO bkd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Uminikagi sa mga tinun-an hi Jesus diyà ta kandin ha “Ku iyan diay hayana maayad pa hu maama ku harì en mangasawa.” ");
INSERT INTO bkd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ba si Jesus tuminubag hu “Harì hayan agkadawat hu alan ta iyan dà haena sa daan en pinilì hu Dios ha harì mangasawa. ");
INSERT INTO bkd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Amin mga katarengan ha sa maama harì agpangasawa, sa duma kandin en ha pagkaetaw sa harì agpangasawa, sa duma daan harì en agkabaluy agpangasawa, daw sa duma harì en agpangasawa ta daw harì maelangan sa pagsangyaw din mahitenged hu pagharì hu Dios. Saena ha napilì hu Dios ha harì en mangasawa kinahanglan ha dawaten din haini.” ");
INSERT INTO bkd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Amin mga atiyuay ha mga batà ha inuwit diyà ki Jesus ta daw madampà din daw maampuan sidan. Saena ha mig-uwit kandan binaldeng hu mga tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ba uminikagi si Jesus hu “Ipaubay dini ta kanak sa mga batà daw harì nuy sidan agbaldenga, ta sa mga etaw ha iling taini ha mga batà iyan tagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Su madampà din sidan daw ampui uminawà si Jesus diyà. ");
INSERT INTO bkd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Amin etaw ha duminiyà ki Jesus daw nanginginsà hu “Manunudlù, inu man sa maayad ha buhaten ku ta daw mailahan a hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tuminubag si Jesus hu “Imbà nu ig-insà ku inu sa maayad? Iyan dà sa Dios maayad. Ku agkabayà ka hu kinabuhì ha hurà din katapusan kinahanglan ha tumanen nu sa Kasuguan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Saena ha etaw tuminubag hu “Inu man ha sugù duun taena ha Kasuguan?” Minikagi si Jesus hu “Harì ka mangimatay daw harì ka manapaw, harì ka daan manakaw daw harì ka magbutang-butang, ");
INSERT INTO bkd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tahura daan sa mga laas nu daw palanggaa sa mga duma nu iling hu pagpalanggà nu hu kaugalingen nu.” ");
INSERT INTO bkd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ba tuminubag haena sa etaw hu “Binuhat kud en hayana. Inu pa sa hurà ku kabuhat?” ");
INSERT INTO bkd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Minikagi si Jesus ha “Ku agkabayà ka ha mahimpit ka gayed ipamaligyà sa alan ha mga butang nu dayun sa halin taena ipan-ila duun hu mga makaluluuy ta daw magsapian ka diyà ta langit. Ku mapengahan nu haini lumikù ka dini daw sunud ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Su mapaliman ku etaw su inikagi hi Jesus huminipanaw haena ha naguul gayed ta madakel tungkay sa mga katigayunan din. ");
INSERT INTO bkd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dayun inikagiyan hi Jesus sa mga tinun-an din hu “Laus gayed sa ag-ikagiyen ku inyu ha malegen tungkay ha maharian hu Dios sa etaw ha sapian. ");
INSERT INTO bkd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ikagiyen ku inyu ha malumu pa hu kamilyo sa paglusut duun hu pusu hu dagum dì hu sapian ha maharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Su mapaliman haena hu mga tinun-an tungkay gayed sidan nangabeleng daw nanginginsà sidan hu “Sin-u dà diay sa mailahan hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Uminahà diyà ta kandan si Jesus daw kagi din “Saena harì gayed agkabaluy hu etaw ba sa alan agkahimu hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dayun minikagi si Pedro hu “Inawaan day sa alan ta daw makasunud kay ikaw. Inu man sa igbales nu kanay?” ");
INSERT INTO bkd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha umuma sa panahun ha bag-uwen sa alan daw siak sa Suled hu Kaet-etawan minuu a duun hu trono. Sinyu sa sampulù daw daruwa ha mga tinun-an makapinuu kaw daan duun hu mga trono daw pagharian nuy haena sa sampulù daw daruwa ha kaliwatan hi Israel. ");
INSERT INTO bkd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sa alan ha inawaan dan sa mga bugtà dan daw sa balay dan, sa mga suled dan, sa mga laas dan daw sa mga batà dan tumenged hu pagsunud kanak, bisan iman ha panahun makadawat en gayed sidan hu madakel pa dì taena ha inawaan dan daw maangken dan daan sa kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Madakel iman ha mga etaw sa tagkauna ba iyan diay mahudiyan, daw amin daan etaw ha hudiyan iman ba iyan diay mauna. ");
INSERT INTO bkd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Sa pagharì hu Dios agkailing hu etaw ha suminelem nan-ahà hu agsuhulan din ha magtalabahu duun hu uma din. ");
INSERT INTO bkd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Su mga etaw ha naahà din pigsabutan dan ha agsuhulan din sidan hu tigsabuwa ha salapì ta iyan haena naanadan ha suhul hu sabuwa ha etaw kada aldaw, dayun impatalabahu din sidan. ");
INSERT INTO bkd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Su agliwaraan en sa seselem nan-ahà dà paman haena hu mga etaw ha bà dà tagtimaay diyà ta baligyaanan. ");
INSERT INTO bkd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Inikagiyan din sidan hu ‘Magtalabahu kaw daan duun hu uma ku ta agsuhulan ku inyu hu tumanan ha suhul nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aman saena ha mga etaw migtalabahu dayun. “Amin pa daan impatalabahu din su agkaugtu en daw su agkabalalay en sa aldaw. ");
INSERT INTO bkd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Su agsalep en sa aldaw minisab pa gayed nan-ahà hu mga etaw ha bà dà tagtimaay. Aman ininsaan din hu ‘Imbà kaw bà dà tag-aldaw tagtimaay?’ ");
INSERT INTO bkd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Tuminubag sidan ha ‘Hurà man tagpatalabahu kanay.’ “Aman inikagiyan din sidan hu ‘Diyà kaw ta uma ku daw magtalabahu kaw.’ ");
INSERT INTO bkd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Su agpanukilem en inikagiyan din su sinaligan din hu ‘Amul-amulen sa mga etaw ha migtalabahu daw iyan nu unahan suhulan su nahudiyan.’ ");
INSERT INTO bkd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Saena ha daw en migtalabahu su sumalep en sa aldaw nasuhulan hu tignangkabuuk ha salapì. ");
INSERT INTO bkd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aman saena ha suminelem dà migtalabahu nakahenà-henà ha adagi gayed sa kandan ha suhul dì su nahudiyan, ba tigsabuwa dà daan ha salapì sa insuhul kandan. ");
INSERT INTO bkd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Su matimù dan en haena sa salapì migtamudmud su nauna duun ku agpanuhul ");
INSERT INTO bkd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","hu kagi dan ‘Saena ha nahudiyan nangkauras dà sa pagtalabahu dan, ba sikay sa nangauna minaldaw kay magtalabahu daw napasù-pasuan kay pa gayed na impag-iling nu dà sa insuhul nu kanay.’ ");
INSERT INTO bkd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ba saena ha tagpanuhul minikagi ha ‘Hurà ku inyu limbungi ta sa nauyunan taw ha suhulan ku inyu hu tignangkabuuk ha salapì in-ila ku inyu. ");
INSERT INTO bkd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Timua nuy en haini daw ulì kaw en. Iyan en pagbayà ku ha sa nahudiyan ilahan ku daan iling hu insuhul ku inyu. ");
INSERT INTO bkd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kenà ba iyan a man tagbayà hu salapì ku? Imbà kaw agkasina ta kalalagan a?’ ");
INSERT INTO bkd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Aman sa etaw ha tagkahudiyan iyan diay mauna, daw madakel sa tagkauna iman ha iyan man diay mahudiyan.” ");
INSERT INTO bkd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Su tagdiyà si Jesus ta Jerusalem tinabis din sa mga tinun-an din daw ikagiyi sidan hu ");
INSERT INTO bkd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tagdiyà kuy en iman ta Jerusalem. Siak sa Suled hu Kaet-etawan itugyan a duun hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan. Hukuman a kandan hu kamatayen ");
INSERT INTO bkd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","daw itugyan a daan kandan duun hu mga etaw ha kenà Judio ha iyan magtameyes daw maglagkut kanak. Dayun ilansang a kandan duun hu krus ba duun hu ikatulu ha aldaw mabanhaw a dà.” ");
INSERT INTO bkd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sa asawa hi Zebedeo duma hu daruwa ha mga batà din ha tinun-an duminiyà ki Jesus daw luminuhud duun hu atubangan din ta amin din aghangyuen. ");
INSERT INTO bkd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aman ininsaan hi Jesus hu “Inu man sa agkabayaan nu?” Tuminubag haena hu “Sa aghangyuen ku ikaw iyan sa ku magharì ka asem saini ha mga batà ku iyan ipapinuu duun hu abay nu, sa sabuwa diyan ta kawanan daw sa sabuwa diyan ta gibang nu.” ");
INSERT INTO bkd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ba inikagiyan hi Jesus su daruwa hu “Harì nuy gayed agkatun-an sa taghangyuen nuy. Maantus nuy ba sa mga melegen ha maul-ulahan ha madani en makauma dini ta kanak?” Tuminubag sidan hu “Hee, maantus day.” ");
INSERT INTO bkd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Inikagiyan sidan hi Jesus hu “Maagiyan nuy gayed sa malegen ha maul-ulahan iling hu kanak, ba kenà a iyan tagbayà ku sin-u sa makapinuu dini ta kawanan ku daw ta gibang ku ta iyan tagbayà taena sa Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Su mapaliman haena ku sampulù ha mga duma dan ha tinun-an napaukan dan gayed su daruwa ha migsuled. ");
INSERT INTO bkd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Inamul hi Jesus su mga tinun-an din daw ikagiyi hu “Natun-an nuy en ha sa mga punuan hu kenà mga Judio iyan tagbayà hu mga sakup dan daw sa mga sinaligan dan iyan tagsugù hu mga ginsakupan dan. ");
INSERT INTO bkd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ba saena harì mahimu diyan ta inyu ta ku amin inyu agkabayà ha iyan labaw kinahanglan ha iyan mabuhat ha suluguen nuy, ");
INSERT INTO bkd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","daw ku amin inyu agkabayà gayed ha iyan tungkay labaw kinahanglan ha iyan daan ulipen hu alan. ");
INSERT INTO bkd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bisan siak sa Suled hu Kaet-etawan kenà ku iyan indini ta kalibutan ta daw mabuligan a hu mga etaw, ba sa pagdini ku iyan sa pagbulig daw sa pagpakamatay ta daw malibri sa kaet-etawan ha naulipen hu salà.” ");
INSERT INTO bkd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Su tag-awà en si Jesus daw sa mga tinun-an din diyà ta Jerico madakel gayed sa mga etaw ha namanduma kandan. ");
INSERT INTO bkd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amin daan daruwa ha buta ha tagpinuu diyà ta kilid ta dalan. Su mapaliman dan ha aglabay en si Jesus diyà ta kandan nangulahì sidan hu “Ginuu ha Kaliwat hi David, kahid-uwi kay ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Binaldeng sidan hu mga etaw ta igpahagteng dan ngaay, ba bà dà nasì kadaging sa pangulahì dan ha tagyanaen “Ginuu ha Kaliwat hi David, kahid-uwi kay man ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aman tuminaleen si Jesus daw umawa su mga buta ha kagi din “Inu man sa agkabayaan nuy ha buhaten ku diyan ta inyu?” ");
INSERT INTO bkd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tuminubag sidan hu “Ginuu, makaindan kay ngaay.” ");
INSERT INTO bkd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nahid-uwan gayed sidan hi Jesus aman dinampà din sa mga mata dan. Sagunà sidan nakaindan daw pamanduma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nakauma si Jesus daw sa mga tinun-an din diyà ta Betpage diyà ta Buntud ta Olibo saena ubay en diyà ta Jerusalem. Sinugù hi Jesus sa daruwa ha tinun-an din ");
INSERT INTO bkd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ha tagyanaen “Umuna kaw en diyà tayà ha banuwa. Ku makauma kaw diyà maahà nuy sa intagkes ha asno daw amin din nati. Hukada nuy haena daw tuyuka dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ku amin manginginsà inyu hu ‘Imbà nuy hayana agtimua?’ ikagiya nuy ha ‘Agkinahanglanen haini hu Ginuu’ dayun sagunà din haena itugut inyu.” ");
INSERT INTO bkd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nahitabù haena ta daw matuman sa lalang hu Dios pinaagi hu propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tultuli nuy sa mga taga-Jerusalem hu ‘Sa Harì nuy pakauma en saena maluluy-en daw taglulan duun hu nati hu asno.’” ");
INSERT INTO bkd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huminipanaw haena sa mga tinun-an hi Jesus daw buhata su insugù kandan. ");
INSERT INTO bkd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tinuyuk dan su asno daw sa nati din daw binalhenan dan haena hu mga bisti dan dayun luminulan si Jesus duun. ");
INSERT INTO bkd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Madakel ha mga etaw sa migbuklad hu mga bisti dan daw mga palwa duun ku dalan ha ag-agiyan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sa madakel ha mga etaw ha nakalibut diyà ki Jesus nangulahì ha tagyanaen “Dayeen gayed sa Kaliwat hi David. Panalanginan haini sa nakauma ha sinugù hu Dios. Dayeen gayed sa Dios ha diyà ta langit.” ");
INSERT INTO bkd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Su makauma en si Jesus diyà ta Jerusalem nabibu sa kaet-etawan daw migpainsaay sidan hu “Sin-u man hayana?” ");
INSERT INTO bkd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tuminubag haena sa namanduma ki Jesus hu “Iyan en haini si Jesus ha propita ha diyà napuun ta Nazaret ha sakup ta Galilea.” ");
INSERT INTO bkd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sumineled si Jesus diyà ta Timplo daw pan-abuga sa mga tagbabaligyà daw sa tagpamalit duun. Pinamantang din sa mga lamisahan taena ha tagpamaylu hu salapì daw sa mga pinun-ayà hu tagbabaligyà hu mga salapati ");
INSERT INTO bkd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","daw ikagiyi sidan hu “Nakasulat en sa lalang hu Dios ha tagyanaen ‘Sa Timplo ku iyan alampuanan.’ Ba saini binuhat nuy ha kampo hu mga tulisan.” ");
INSERT INTO bkd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Duun taena ha Timplo namandiyà ki Jesus sa mga buta daw sa mga piang aman nangaulian din sidan. ");
INSERT INTO bkd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ba sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan su maahà dan sa belenganen ha binuhat hi Jesus daw su mapaliman dan sa mga batà duun hu Timplo ha tagkulahiay hu “Dayeen sa Kaliwat hi David” nangapauk-pauk gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ininsaan dan si Jesus hu “Agkapaliman nu ba haena sa tag-ikagiyen dan?” Tuminubag si Jesus hu “Agkapaliman ku man. Hurà nuy ba diay kabasa haena sa lalang hu Dios ha tagyanaen ‘Intudlù hu Dios sa hustu ha pagdayè kandin duun hu mga batà.’” ");
INSERT INTO bkd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dayun inawaan sidan hi Jesus diyà ta Jerusalem daw diyà dà tuminiduga ta Betania. ");
INSERT INTO bkd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Su maselem pa tungkay luminikù dà si Jesus diyà ta Jerusalem. Su diyà pa ta dalan agkauhul gayed. ");
INSERT INTO bkd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Naahà din sa kayu ha igira aman duminuun taena ba hurà din naahà ha bunga. Dayun inikagiyan hi Jesus su kayu hu “Harì kad en gayed mamunga.” Saena sagunà nagangu. ");
INSERT INTO bkd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Su maahà haena hu mga tinun-an hi Jesus tungkay gayed sidan nangabeleng aman minikagi sidan hu “Imbà gid sagunà dà kagangu su kayu?” ");
INSERT INTO bkd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tuminubag si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha ku amin nuy pagsalig duun hu Dios daw harì kaw gayed magduwa-duwa mabaluy nuy gayed daan haini sa binuhat ku duun taini ha kayu ha igira. Daw kenà haini iyan dà ta bisan pa ku ikagiyan nuy hayana sa bubungan hu ‘Agbul ka diyà ta dagat’ saena matuman gayed. ");
INSERT INTO bkd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ku sumalig kaw hu Dios madawat nuy sa bisan inu ha agpanayuen nuy pinaagi hu pag-ampù.” ");
INSERT INTO bkd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sumineled si Jesus diyà ta Timplo daw su tagpanudlù en duminiyà ta kandin sa mga labaw ha sinaligan hu paghalad daw sa mga magulang. Ininsaan dan haena hu “Inu sa katenged nu daw sin-u sa mig-ila ikaw hu kagahem hu pagbuhat taena?” ");
INSERT INTO bkd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ba tinubag sidan hi Jesus hu “Ag-insaan ku daan inyu. Ku matubag nuy haini ikagiyen ku inyu sa katenged ku hu pagbuhat taena. ");
INSERT INTO bkd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Sin-u man sa mig-ila ki Juan ha Bautista hu kagahem hu pagbautismu? Iyan ba sa Dios daw ku etaw dà ba?” Miglalang-lalang sidan ha “Ku kagi taw iman ha iyan sa Dios insaan kuy kandin ku imbà hurà taw tuuwi si Juan. ");
INSERT INTO bkd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ba ku ikagiyen taw daan ha etaw dà mapaukan kuy hu mga etaw ha tuminuu gayed ha propita si Juan.” ");
INSERT INTO bkd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aman iyan dà tubag dan diyà ki Jesus sa “Hanaw ta.” Inikagiyan sidan hi Jesus ha “Ku iyan hayana harì ku daan inyu ag-ikagiyen ku sin-u sa mig-ila kanak hu kagahem hu pagbuhat taena. ");
INSERT INTO bkd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Inu man sa kahenhenaa nuy taini? Amin etaw ha daruwa sa malmalaki din. Sinugù din haena sa magulang hu kagi din ‘Magtalabahu ka iman diyà ta uma.’ ");
INSERT INTO bkd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ba bà dà haena tuminubag sa batà hu ‘Harì a agkabayà.’ Ba su malugay-lugay nahalin dà sa henà-henà din aman duminiyà dà ta uma. ");
INSERT INTO bkd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Dayun si Amay din duminuun daan ku sabuwa ha batà din daw sugua haena diyà ta uma. Minikagi haena hu ‘Hee, dumiyà a’ ba hurà haena diyà ta uma. ");
INSERT INTO bkd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Sin-u man duun taena ha mga batà sa nakatuman hu insugù hu amay dan?” Tuminubag sidan hu “Iyan haena sa magulang.” Inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha saena ha limbungan ha manunukut hu buhis daw su madaet ha mga bahi iyan mangauna dì inyu ha pagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta nakadini si Juan ha Bautista hu pagpaahà inyu hu paagi ha mabuhat kaw ha matareng ba hurà nuy tuuwi. Ba saena ha mga limbungan daw sa madaet ha mga bahi tuminuu kandin. Bisan su maahà nuy en ha namanuu sidan ba hurà kaw gihapun tuu daw hurà kaw daan maghinulsul hu mga salà nuy. ");
INSERT INTO bkd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Palilimani nuy haini sa pananglitan. Amin etaw ha amin din uma ha pinamulahan hu paras. Linibut din haena hu alad daw migbangbang hu pangemesà hu mga bunga din daw miglawig daan hu timaay taena ha mga tag-alima duun. Dayun pinaalimahan din haena daw pahiphipanaw duun hu madiyù ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Su bungahan en su paras sinugù din sa mga suluguen din duun ku mga sinaligan din ha tag-alima hu parasan ta daw matimù taena sa kandin ha bahin. ");
INSERT INTO bkd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ba su mga sinugù din bà dà pinan-ibiti ku mga sinaligan, sa sabuwa binunalan dan, sa sabuwa hinimatayan dan daw sa sabuwa binatu dan hangtud ha matay. ");
INSERT INTO bkd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dayun impalupug ku tag-iya ku uma sa madakel pa ha suluguen dì su nauna ba iyan gihapun haena binuhat kandan. ");
INSERT INTO bkd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Sa katapusan iyan din en paman sinugù su batà din ta sa henà-henà din ‘Tahuran dan gayed haini tumenged ta batà ku.’ ");
INSERT INTO bkd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ba su maahà haena ku mga sinaligan miglalang-lalang sidan hu ‘Iyan en haini batà hu tag-iya. Himatayan taw ta daw maangken taw en haini sa parasan.’ ");
INSERT INTO bkd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aman inuwit dan diyà ta guwà taena ha parasan daw himatayi. ");
INSERT INTO bkd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ku makauma sa tag-iya taena ha parasan inu man sa buhaten din duun ku mga sinaligan din?” ");
INSERT INTO bkd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tuminubag sidan hu “Panhimatayan din gayed sidan dayun su parasan paalimahan din hu lain ha iyan mag-ila kandin hu bahin hu bunga taena.” ");
INSERT INTO bkd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Inikagiyan sidan hi Jesus ha “Hurà nuy ba kabasa sa lalang hu Dios ha tagyanaen ‘Sa batu ha bà dà inlambeg ta abi hu mga tagbalay ha hurà din pulus iyan man diay mahinengdanen ta iyan pakapalig-en hu balay. Belenganen gayed haena ta iyan sa Dios migbuhat duun.’ ");
INSERT INTO bkd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Aman ikagiyen ku inyu ha kenà kaw iyan pagharian hu Dios ta iyan dà sa mga etaw ha tagtuman hu agkabayaan din. ");
INSERT INTO bkd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Saena ha makadaghà duun taini ha batu magebà gayed, daw saena daan ha mahulugan taini ha batu mabekbek gayed.” ");
INSERT INTO bkd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Su mapaliman hu mga Fariseo daw hu mga labaw ha mga sinaligan hu paghalad haena sa mga pananglitan hi Jesus natun-an dan ha iyan en sidan tagsubayen din. ");
INSERT INTO bkd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aman nan-ahà sidan hu paagi ha madakep dan si Jesus, ba nahaldek sidan hu mga etaw ta si Jesus nakilala dan en ha propita. ");
INSERT INTO bkd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Si Jesus duminayun minikagi duun hu mga etaw pinaagi hu mga pananglitan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Sa tagharian hu Dios agkailing hu harì ha nangandam hu kaamulan ta sa batà din agpangasawa. ");
INSERT INTO bkd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pinaelegan din sa mga inimbita ha dumiyà en sidan ba namalibad haena. ");
INSERT INTO bkd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Dayun pinaisaban din dà sidan pinaelegan hu lain ha mga suluguen hu kagi din ‘Ikagiyi su mga inimbita ha nalapà en su mga baka daw su impalambù ha mga nati daw linamisa en daan sa pagkaen. Ipaagpas en sidan ipadini.’ ");
INSERT INTO bkd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ba saena ha pinan-elegan hurà en magsima ba bà dà duminayun hu kandan ha mga buluhaten, sa sabuwa duminuun ku uma din daw sa sabuwa duminuun hu patigayun din. ");
INSERT INTO bkd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sa duma kandan bà dan dà pinan-ibiti su mga suluguen ku harì daw pagagayhai dayun panhimatayi. ");
INSERT INTO bkd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Su matun-an haena ku harì tungkay gayed napauk, aman pinaelegan din hu mga sundalu haena sa nangimatay ku mga suluguen din daw mahimatayan daan sidan dayun pigbigsulan dan daan haena sa banuwa. ");
INSERT INTO bkd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Inikagiyan din sa duma ha mga suluguen din hu ‘Napengahan en sa lamisa ba saena ha pinan-imbita ku kenà angayan ha dumini. ");
INSERT INTO bkd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aman pamanduun kaw hu mga dalan daw pan-imbitaha sa bisan sin-u ha maahà nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dayun namanhipanaw su mga suluguen daw pan-imbita hu bisan sin-u ha naahà dan sa maayad daw sa madaet, aman napanday gayed napunù su balay ku harì. ");
INSERT INTO bkd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ba su makaseled su harì ta ag-ahaen din sa mga etaw naahà din su maama ha hurà magpinaksuy para hu kaamulan. ");
INSERT INTO bkd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Inikagiyan din haena hu ‘Imbà ka makaseled dini ha sa bisti nu kenà man para hu kaamulan?’ Saena ha etaw hurà gayed makatubag. ");
INSERT INTO bkd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Dayun inikagiyan ku harì sa mga sinaligan din hu ‘Bakusa haini daw ilambeg duun hu kasukileman diyà ta guwà ha duun makag-ulahuay hu kalugul daw magkangget sa mga ngipen din hu kasakitan.’ ");
INSERT INTO bkd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Madakel sa inimbita hu Dios ba atiyuay dà sa pinilì.” ");
INSERT INTO bkd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Naman-awà su mga Fariseo daw miglalang-lalang ku in-inuwen dan ta daw amin maikagi hi Jesus ha ikasumbung dan kandin. ");
INSERT INTO bkd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aman sinugù dan diyà ki Jesus sa mga sakup dan daw sa mga sakup hi Herodes. Dayun saena sidan uminikagi diyà ki Jesus hu “Manunudlù, natun-an day ha matareng ka gayed daw iyan nu dà tigtudlù sa kamatuuran mahitenged hu Dios. Harì ka agkauwit hu mga henà-henà hu mga etaw ta hurà nu kandan igpalabi. ");
INSERT INTO bkd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aman ikagiyi kay ikaw ku igtugut ba hu Kasuguan taw ha magbayad kuy hu buhis diyà ki Cesar.” ");
INSERT INTO bkd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ba natun-an hi Jesus ha madaet sa tuyù dan aman inikagiyan din sidan hu “Sinyu sa bà dà tagpasibù-sibù, imbà a inyu tagsulay-sulaya? ");
INSERT INTO bkd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ipaahà kanak sa salapì ha igbayad nuy hu buhis.” Inuwit dan su salapì ");
INSERT INTO bkd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","dayun ininsaan sidan hi Jesus hu “Sin-u ha weleng daw ngaran sa nakaugsak duun taini ha salapì?” ");
INSERT INTO bkd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tuminubag sidan hu “Iyan si Cesar sa Harì ta Roma.” Dayun inikagiyan sidan hi Jesus ha “Ku kandin diay haini kinahanglan ha iila nuy diyà ki Cesar sa buhis daw iila nuy daan duun hu Dios sa kandin ha bahin.” ");
INSERT INTO bkd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Su mapaliman dan haena tungkay sidan nangabeleng dayun inawaan sidan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Duun taena ha aldaw amin mga Saduceo ha duminiyà ki Jesus. Saini ha mga etawa harì agtuu ha mabanhaw sa etaw, ");
INSERT INTO bkd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","aman inikagiyan dan si Jesus hu “Manunudlù, sa Kasuguan hi Moises tagyanaen ‘Ku matay sa maama ba hurà pa sidan pamatà ki Asawa din kinahanglan ha sa suled taena ha maama asawahen din su bahi ha nabalu ta daw ku magbatà sidan kaliwat pa haena ku suled din ha minatay.’ ");
INSERT INTO bkd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Su anay amin dini pitu ha migsusuled ha pulus maama. Sa kamagulangan kandan nangasawa ba hurà pa sidan pamatà na minatay en. Aman inasawa ku manghud din su bahi ha nabalu ");
INSERT INTO bkd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ba saena ha maama hurà en daan sidan pamatà na minatay en daan hangtud ha su migsusuled alan nakaasawa ku bahi ba alan daan minatay. ");
INSERT INTO bkd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dayun minatay daan su bahi. ");
INSERT INTO bkd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ku mabanhaw asem sa nangamatay sin-u man sa laus ha asawa ku bahi sa pulus man nakaasawa kandin su pitu ha migsusuled?” ");
INSERT INTO bkd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ba inikagiyan sidan hi Jesus hu “Maal en sa tag-ikagiyen nuy tumenged ta hurà nuy katun-i sa insulat ha lalang hu Dios daw sa pagkagamhanan din. ");
INSERT INTO bkd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asem ku mabanhaw en sa mga nangamatay agkailing sidan hu mga balinsuguen hu Dios diyà ta langit ha harì en agpangasawa. ");
INSERT INTO bkd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mahitenged hu pagkabanhaw taena ha mga minatay hurà nuy ba diay kabasa sa lalang hu Dios ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iyan a Dios ha tagsimbahen hi Abraham daw hi Isaac daw hi Jacob.’ Kenà haena Dios hu mga minatay ba Dios hu mga bubuhay.” ");
INSERT INTO bkd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Su mapaliman haena hu mga etaw nangabeleng gayed sidan hu katudluanan din. ");
INSERT INTO bkd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Su matun-an hu mga Fariseo ha hurà en makatubag ki Jesus sa mga Saduceo sagunà sidan mig-amul-amul. ");
INSERT INTO bkd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Amin kandan sabuwa ha manunudlù hu Kasuguan ha nanginginsà daan ki Jesus hu pagsulay kandin ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Manunudlù, inu man sa labaw gayed duun hu alan ha Kasuguan?” ");
INSERT INTO bkd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tuminubag si Jesus hu “‘Palanggaa nuy gayed sa Dios ha Magbabayà nuy’ ");
INSERT INTO bkd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ta iyan haena tungkay labaw daw nauna ha sugù duun hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sa ikaduwa ha labaw ha sugù iyan sa ‘Palanggaa sa mga duma nuy iling hu pagpalanggà nuy hu kaugalingen nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sa Kasuguan daw sa lalang hu Dios pinaagi hu mga propita matuman en ku buhaten nuy haini sa daruwa ha sugù.” ");
INSERT INTO bkd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Su tag-amul-amul sa mga Fariseo ininsaan sidan hi Jesus hu ");
INSERT INTO bkd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Inu sa kahenhenaa nuy hu Mesiyas? Sin-u man haena ha kaliwat?” Tuminubag sidan hu “Saena kaliwat hi David.” ");
INSERT INTO bkd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Inikagiyan sidan hi Jesus ha “Ku iyan hayana imbà man makaikagi si David su ulinan hu Balaan ha Ispiritu ha Ginuu din sa Mesiyas? Ta tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Inikagiyan hu Dios sa Ginuu ku ha “Dini ka pinuu ta kawanan ku hangtud ha madaeg ku sa mga kuntra nu.”’ ");
INSERT INTO bkd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ku inikagi hi David ha Ginuu din su Mesiyas, imbà kabuhat din dà paman haena ha kaliwat?” ");
INSERT INTO bkd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hurà en gayed agpakatubag ki Jesus daw sugud taena ha aldaw hurà en uminamel hu pagpanginginsà kandin. ");
INSERT INTO bkd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Inikagiyan hi Jesus sa mga etaw daw sa mga tinun-an din hu ");
INSERT INTO bkd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sa mga manunudlù hu Kasuguan daw sa mga Fariseo iyan sinaligan ha magtudlù hu Kasuguan hi Moises. ");
INSERT INTO bkd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aman kinahanglan ha palilimanan nuy daw tumanen nuy sa alan ha igsugù dan inyu. Ba harì nuy ilingan sa mga buhat dan ta harì dan tagbuhaten sa tigtudlù dan inyu. ");
INSERT INTO bkd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mabegat gayed sa mga tulumanen ha igpabuhat dan hu mga etaw ba bisan ganì sidan harì dan daan agkatuman haena. ");
INSERT INTO bkd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tagbuhaten dan sa alan hu pagpaaluahà hu mga etaw. Impamedbed dan sa lalang hu Dios diyà ta tangad dan daw ta alima dan daw tagmagayad daan sidan hu pinaksuy. ");
INSERT INTO bkd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ku duun sidan hu taggastu agkabayaan dan ha iyan sidan una igpakaen, daw ku diyà sidan ta simbahan iyan dan daan agkabayaan sa madagway ha pinun-ayà. ");
INSERT INTO bkd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Agkalipay daan sidan ku tahuran hu mga etaw duun hu baligyaanan daw ikagiyen sidan ha Manunudlù. ");
INSERT INTO bkd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ba harì nuy tugutan sa mga etaw ha umawen kaw kandan ha Manunudlù ta migsusuled kaw dà daw iyan a dà Manunudlù nuy. ");
INSERT INTO bkd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Daw harì nuy daan ngaranan sa bisan sin-u dini ta kalibutan ha Amay nuy ta sabuwa dà sa Amay nuy ha iyan sa Dios diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Daw harì nuy daan igtugut ha umawen kaw hu Ginuu ta iyan a dà Ginuu siak sa Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Saena ha labaw inyu iyan mabuhat ha suluguen nuy ");
INSERT INTO bkd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ta bisan sin-u sa tagpalabaw-labaw igpaubus ba saena ha tagpaubus igpatangkaw. ");
INSERT INTO bkd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Harì kaw agkabayà ha maharian kaw hu Dios daw saena ha agkabayà ngaay agbaldengen nuy. ");
INSERT INTO bkd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Aglupigan nuy sa mga balu ha bahi daw ag-agawen nuy Baligyaanan sa mga katigayunan dan dayun agtambunan nuy sa madaet ha mga buhat nuy pinaagi hu pag-ampù ha malugayad. Tumenged taini adagi gayed sa silut inyu. ");
INSERT INTO bkd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Madiyù gayed sa napayanan-an nuy ta bà nuy en nangalayun sa dagat hu pagkabig hu sabuwa ha etaw, ba sa intudlù nuy taena ha kinabig nuy nakapadaet kandin ha iyan ipaka-Inferno din. ");
INSERT INTO bkd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kahid-u nuy gayed ta agkailing kaw hu buta ha tagkipit hu buta daan. Tag-ikagi kaw ha ‘Ku ipanumpà hu etaw sa Timplo mahimu haena ha harì din tumanen, ba ku iyan din ipanumpà sa bulawan duun taena ha Timplo tumanen din gayed haena.’ ");
INSERT INTO bkd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mga buang-buang kaw gayed daw mga buta. Hindu man dapit sa mahal? Iyan ba su bulawan daw ku iyan ba sa Timplo? ");
INSERT INTO bkd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tag-ikagi kaw daan ha ‘Ku ipanumpà hu etaw sa halaran mahimu haena ha harì din tumanen, ba ku iyan din ipanumpà sa inhalad tumanen din gayed haena.’ ");
INSERT INTO bkd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mga buta kaw gayed. Hindu man dapit sa labaw? Iyan ba sa halad daw ku iyan ba sa halaran? ");
INSERT INTO bkd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aman sa etaw ha igpanumpà din sa halaran sa alan ha nakaugsak duun taena nakalagkes en hu impanumpà din. ");
INSERT INTO bkd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Daw ku amin etaw ha igpanumpà din sa Timplo kenà haena iyan dà ta nakalagkes en daan sa Dios ha tagtimà duun. ");
INSERT INTO bkd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daw ku amin etaw ha iyan din igpanumpà sa langit nakalagkes en daan sa trono daw sa Dios ha tagpinuu duun. ");
INSERT INTO bkd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Ig-ulì nuy duun hu Dios sa ikasampulù hu bisan mga atiyuay ha pamulahen nuy ba iyan nuy agbay-anan sa labaw duun hu Kasuguan ha iling hu pagkamatareng daw hu pagkamahid-uwen hu duma nuy daw hu pagkakasaligan. Kinahanglan ha iila nuy sa mga ikasampulù ba buhaten nuy gayed daan sa duma ha kasuguan. ");
INSERT INTO bkd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Iling kaw hu buta ha tagkipit hu duma din ha buta. Bà su ag-awaen nuy sa langaw duun hu baung ha ag-inuman nuy ba aglam-eden nuy sa kabayu. ");
INSERT INTO bkd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Agkailing kaw hu baung daw lampay ha hinenawan sa guwà ba mahugaw sa seled, ta tagtuman kaw gayed hu mga tulumanen ba sa henà-henà nuy madaet ta limbungan daw agapan kaw. ");
INSERT INTO bkd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sinyu sa mga Fariseo, bà kaw su buta. Kinahanglan ha unahen nuy henawan sa seled taena ha baung daw lampay dayun malimpyuwan daan sa guwà. ");
INSERT INTO bkd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Iling kaw hu madagway ha lungun ha pigpintalan hu maputì sa guwà ba diyà ta seled mga tul-an daw mga sagu hu etaw. ");
INSERT INTO bkd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Iling kaw taena ta ku tag-ahaen kaw hu etaw bà kaw su matareng ba sa henà-henà nuy bà dà tagpasibù-sibù daw masinupaken gayed. ");
INSERT INTO bkd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan daw mga Fariseo ha bà dà tagpasibù-sibù. Tagbuhat kaw hu mga madagway ha lebeng para hu mga propita daw agdayan-dayanan nuy sa mga lebeng hu mga matareng ha etaw ");
INSERT INTO bkd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","daw kagi nuy ‘Ku duduun kay en ngaay su panahun hu mga gin-apuan day harì day gayed mabuhat sa iling taena ha pinanhimatayan dan sa mga propita.’ ");
INSERT INTO bkd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pinaagi hu tag-ikagiyen nuy pakapaahà gayed ha mga kaliwatan kaw taena ha mga etaw ha mighimatay hu mga propita. ");
INSERT INTO bkd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aman dayuna nuy en sa mga buhat ha madaet ta hurà haena kapenga hu mga gin-apuan nuy. ");
INSERT INTO bkd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Iling kaw gayed hu mga bunsalagan. In-inuwen nuy gid ha harì kaw makaagbul diyà ta Inferno? ");
INSERT INTO bkd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Agsuguen ku sa mga tagsaysay hu igpaikagi hu Dios daw sa mga matatau ha etaw daw mga manunudlù. Sa duma kandan himatayan nuy daw ilansang nuy duun hu krus, sa duma lagkutan nuy duun hu mga simbahan daw aglasayen nuy sidan bisan hindu sidan agpayanaen. ");
INSERT INTO bkd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tumenged taena silutan kaw gayed hu Dios ta pighimatayan nuy sa mga etaw ha matareng sugud ki Abel payanaen en ki Zacarias sa batà hi Barakias ha duun nuy dà pighimatayi hu pigtaliwaraan ku Timplo daw ku halaran. ");
INSERT INTO bkd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Laus gayed sa ag-ikagiyen ku inyu ha sinyu sa mga etaw iman silutan kaw gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Sinyu sa mga taga-Jerusalem ha agpangimatay hu mga propita daw tagbatu daan hu mga etaw ha agsuguen diyan, agtanulen ku ngaay inyu iling hu manuk ha ag-amulen din sa mga piyak din diyà ta pakpak din ba harì kaw man agkabayà. ");
INSERT INTO bkd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aman awaan hu Dios sa banuwa nuy daw mabuhat haena ha pinakabulung-bulung ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Daw ikagiyen ku inyu ha sugud iman harì ad inyu maahà hangtud asem ha makaikagi kaw en hu ‘Panalanginan gayed haini sa pakauma ha sinugù hu Dios.’” ");
INSERT INTO bkd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Su gumuwà en si Jesus duun taena ha Timplo impaahà kandin hu mga tinun-an sa mga balay diyà ta lagidlidan taena ha Timplo. ");
INSERT INTO bkd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ba inikagiyan sidan hi Jesus ha “Sulsuliya nuy haini ta laus gayed sa ag-ikagiyen ku inyu ha sa imbalay taini ha mga batu hurà gayed duun sabuwa ha harì matempag.” ");
INSERT INTO bkd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Su tagpinuu si Jesus diyà ta Buntud ta Olibo uminubay diyà ta kandin sa mga tinun-an din ha iyan dà sidan daw nanginginsà hu “Ikagiyi kay ku kan-u haena agkatuman daw inu sa mga timaan hu paglikù nu daw hu katapusan hu panahun.” ");
INSERT INTO bkd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tuminubag si Jesus hu “Magbantay kaw ta daw harì kaw malimbungan hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta madakel asem sa makadini daw mag-ikagi hu ‘Iyan a su Mesiyas’ dayun madakel gayed ha mga etaw sa malimbungan dan. ");
INSERT INTO bkd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mapaliman nuy asem sa mga gira daw sa mga agpakauma ha gira ba harì kaw agkasamuk. Kinahanglan ha mahitabù haena ba kenà pa iyan katapusan hu panahun. ");
INSERT INTO bkd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta magsasabà sa mga nasud daw sa mga ginharian, makauma sa kauhul daw maglinug daan duun hu migkalain-lain ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Saini ha mga hitabù puunaan pa hu mga kasakitan. ");
INSERT INTO bkd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Dayun kuntrahen kaw hu alan ha kaet-etawan tumenged kanak daw itugyan kaw duun hu magpasipala inyu daw maghimatay inyu. ");
INSERT INTO bkd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Duun asem taena ha panahun madakel gayed sa umendà hu pagtuu daw magpalimbung-limbungà sidan daw magpakuntra-kuntrahà sidan. ");
INSERT INTO bkd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Makahiwal daan sa mga biduen ha manunudlù ha maglimbung hu madakel ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tumenged ta makalekep sa madaet duun hu kaet-etawan maawà daan sa gagaw hu mga etaw duun hu mga duma dan. ");
INSERT INTO bkd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ba sa harì umendà hu pagtuu hangtud hu katapusan mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sa Maayad ha Tultulanen mahitenged hu pagharì hu Dios kinahanglan ha isangyaw duun hu alan ha kaet-etawan dini ta kalibutan dayun makauma sa katapusan hu panahun. ");
INSERT INTO bkd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Maahà nuy daan asem sa mahugaw gayed ha humitindeg duun hu balaan ha lugar sumalà hu intagnà hi Daniel sa propita. Saena ha pakabasa taini sabuten din gayed. ");
INSERT INTO bkd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Duun asem taena ha panahun sa mga etaw diyà ta Judea mamamulaguy duun hu bubungan. ");
INSERT INTO bkd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sa mga etaw diyà ta atep hu balay dan harì en lumugnà hu pagtimù hu mga butang dan. ");
INSERT INTO bkd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sa diyà ta uma harì en daan umulì hu pagtimù hu ig-apid ha pinaksuy dan. ");
INSERT INTO bkd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pinakahaluhid-u gayed sa agkangabedes daw saena ha amin din pa igpasusu duun taena ha panahun. ");
INSERT INTO bkd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mag-ampù kaw ha harì haena makatagaed hu lendeng daw hu Aldaw hu Paghimlay ");
INSERT INTO bkd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ta saena ha mga pinakahaluhaldek ha kasamukan labaw pa dì hu nangahitabù en sugud dà su tanghagaen hu Dios sa kalibutan daw hurà en daan isab mahitabù ha iling taena. ");
INSERT INTO bkd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ku harì pababaan hu Dios haena ha panahun maamin matay sa mga etaw. Ba tumenged hu mga pinilì din pababaan din dà haena. ");
INSERT INTO bkd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Duun taena ha panahun ku amin umikagi diyan ta inyu hu ‘Ahà kaw, taini en su Mesiyas’ daw ‘Diyà en’ harì kaw gayed taena agtuu. ");
INSERT INTO bkd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta makauma sa mga biduen ha mag-ikagi hu ‘Iyan ad en su Mesiyas’ daw ‘Iyan ad propita’ daw magpaahà daan sidan hu mga timaan daw belenganen ta daw bisan sa mga pinilì hu Dios ku mahimu malimbungan dan pa gayed. ");
INSERT INTO bkd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Timan-an nuy ta daan kud en haini ag-ikagiyen inyu. ");
INSERT INTO bkd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aman ku amin umikagi inyu hu ‘Ahà kaw, duun en haena hu lugar ha pinakabulung-bulung’ harì kaw gayed dumiyà, daw ku amin daan mag-ikagi hu ‘Dini en haena agseled’ harì kaw daan tumuu taena. ");
INSERT INTO bkd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta siak sa Suled hu Kaet-etawan sa paglikù ku agkailing hu kilat ha pakailaw ta tibuuk ha kalibutan daw agkaahà hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ku hindu duun sa mga minatay duun daan tag-amul-amul sa mga wakwak. ");
INSERT INTO bkd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ku maiwas en haena sa pinakahaluhaldek ha kasamukan sagunà sumukilem sa aldaw daw harì en daan umanlag sa bulan, mangahulug daan sa mga bituen ta agkahuyung sa kalangitan. ");
INSERT INTO bkd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Duun asem taena maahà diyà ta langit sa timaan ha pakauma ad en siak sa Suled hu Kaet-etawan daw maglugul sa alan ha kaet-etawan dini ta kalibutan. Maahà a ha magbulus diyà tayà ha gabunan ha magpangaluanlag daw maahà daan sa pagkagamhanan ku. ");
INSERT INTO bkd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mapaliman sa lageng hu trumpita daw suguen ku sa mga balinsuguen hu Dios ha amulen dan sa mga pinilì ku ha dini agkangapuun ta tibuuk ha kalibutan. ");
INSERT INTO bkd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Timan-i nuy haini sa igtudlù ku inyu mahitenged hu kayu ha igira. Ku manalingsing en haena daw lumabung en matun-an nuy ha madani en sa gulabung. ");
INSERT INTO bkd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iling daan taena ku maahà nuy asem ha matuman en sa alan ha inikagi ku inyu matun-an nuy ha madani ad en aglikù. ");
INSERT INTO bkd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Laus gayed sa ag-ikagiyen ku inyu ha harì pa alan matay sa mga etaw maamin en haena matuman. ");
INSERT INTO bkd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mahanaw pa sa langit daw sa kalibutan ba sa mga lalang ku harì gayed mahanaw. ");
INSERT INTO bkd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hurà nakatuen hu panahun ku kan-u haena agkahitabù bisan pa sa mga balinsuguen ta langit daw siak, ta iyan dà gayed sa Dios ha Amay ku nakatuen taena. ");
INSERT INTO bkd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Sa paglikù ku asem mailing hu panahun hi Noe ");
INSERT INTO bkd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ha su hurà pa lenepi sa tibuuk ha kalibutan sa mga etaw bà dà tagkaenà daw tag-inumà daw namangasawa hangtud en ha sumineled si Noe duun ku arka. ");
INSERT INTO bkd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hurà gayed sidan tuu ha aglenepan sa tibuuk ha kalibutan hangtud ha nangalemes sidan. Iling daan taena sa paglikù ku siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Duun asem taena ku amin daruwa ha maama diyà ta uma sa sabuwa matimù ba sa sabuwa makatabun. ");
INSERT INTO bkd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ku amin daruwa ha bahi ha tagpanggaling, sa sabuwa matimù ba sa sabuwa makatabun. ");
INSERT INTO bkd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aman magbantay kaw gayed ta harì nuy agkatun-an sa panahun ku kan-u a makalikù siak sa Ginuu nuy. ");
INSERT INTO bkd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ba henhenaa nuy haini ha ku agkatun-an pa ngaay hu tagibalay ku kan-u makauma sa takaw magbantay gayed ta daw harì makaseled su takaw. ");
INSERT INTO bkd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aman kinahanglan gayed ha magpangandam kaw ta siak sa Suled hu Kaet-etawan makauma a dini hu panahun ha harì nuy tagsalapen. ");
INSERT INTO bkd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sa suluguen ha kasaligan iyan ipagbayà hu agalen din hu pagpakaen taena ha mga duma din ha suluguen duun hu hustu ha panahun. ");
INSERT INTO bkd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ku makaulì sa agalen din malipayen gayed haena sa suluguen ha migtuman hu alan ha insugù kandin. ");
INSERT INTO bkd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Laus gayed sa ag-ikagiyen ku inyu ha su agalen igsalig din sa alan ha mga butang din duun ku kasaligan ha suluguen. ");
INSERT INTO bkd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ba ku madaet sa suluguen iyan dà henà-henà din sa ‘Malugay pa ag-ulì su agalen ku’ ");
INSERT INTO bkd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aman bà din dà paman agpamunali sa mga duma din daw bà dà daan magkaenà daw mag-inumà duma hu mga beleng-beleng. ");
INSERT INTO bkd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ku tigkan makauma su agalen din duun hu panahun ha harì din tagsalapen ");
INSERT INTO bkd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","saena ha suluguen himatayan gayed ku agalen din daw ipaamul duun taena ha mga etaw ha bà dà tagpasibù-sibù. Duun taena ha lugar makag-ulahuay sidan hu kalugul daw magkakangget sa mga ngipen dan hu kasakitan. ");
INSERT INTO bkd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Duun taena ha panahun sa tagharian hu Dios agkailing hu sampulù ha mga laga ha natukid hu mga sulù ta tag-angat hu agpangasawa. ");
INSERT INTO bkd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Sa lalima kandan buang-buang daw sa lalima mga matatau. ");
INSERT INTO bkd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Saena ha mga buang-buang amin dan sulù ba hurà dan pasubrahi sa tubil din. ");
INSERT INTO bkd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ba saena ha mga matatau amin dan sulù daw amin pa gayed igtutubil dan ha duun hu butilya. ");
INSERT INTO bkd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tumenged ta nalugay nakauma su agpangasawa nakatiduga sidan. ");
INSERT INTO bkd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ba su maliwarà en sa daleman amin migkulahì hu ‘Nakauma en sa agpangasawa. Dalì kaw en daw talagbua nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Dayun napukaw su mga laga daw susiya sa mga sulù dan. ");
INSERT INTO bkd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Su mga buang-buang ha mga laga minikagi duun ku mga matatau hu ‘Ilahi kay hu igtubil day ta agkapedengan en sa kanay ha sulù.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ba su mga matatau tuminubag hu ‘Harì mahimu ta tumanan day dà haini. Bà kaw en diyà ta tindahan daw palit.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Su taghipanaw pa haena sa mga buang-buang ha mga laga ta agpalit hu igtubil dan nakauma en haena sa agpangasawa. Su mga laga ha matatau tuminalagbù ku agpangasawa daw pamaneled duun ku balay ha agkaamulanan dayun sinirahan haena. ");
INSERT INTO bkd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Su malugay-lugay nakalikù en su duma ha mga laga daw pamangumaw hu ‘Ginuu, puwai kay man.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ba saena ha agpangasawa tuminubag hu ‘Laus gayed sa ag-ikagiyen ku inyu ha harì ku inyu agkakilala.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Aman” kagi hi Jesus “pangandam kaw gayed ta harì nuy agkatun-an ku kan-u a aglikù. ");
INSERT INTO bkd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Sa tagharian hu Dios agkailing daan hu etaw ha aghipanaw aman inamul din sa mga sinaligan din ta igpiyal kandan sa mga salapì din. ");
INSERT INTO bkd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sinaad din kandan su salapì sumalà hu mahimu dan ha pagpatigayun, sa sabuwa inilahan din hu lalima ha libu daw sa sabuwa daruwa daan ha libu daw sa sabuwa nangkalibu dà. Dayun huminipanaw su etaw. ");
INSERT INTO bkd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Su sinaligan ha inilahan hu lalima ha libu sagunà din dà haena impatigayun aman nakaganansiya hu lalima daan ha libu. ");
INSERT INTO bkd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Saena ha inilahan hu daruwa ha libu nakaganansiya daan hu daruwa ha libu. ");
INSERT INTO bkd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ba saena ha inilahan hu nangkalibu bà din dà inlebeng su salapì ku agalen din. ");
INSERT INTO bkd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Su malugay en uminulì haena sa agalen ku mga sinaligan hu pagsusi hu mga salapì din. ");
INSERT INTO bkd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Saena ha sinaligan ha inilahan hu lalima ha libu inuwit din su in-ila kandin ha salapì lagkes en sa ganansiya daw uminikagi hu ‘Inilahan a ikaw hu lalima ha libu na saena impatigayun ku. Ahaa nu, taini daan sa lalima ha libu ha ganansiya din.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Inikagiyan haena ku agalen din hu ‘Maayad gayed tungkay sa binuhat nu. Tumenged ta kasaligan ka hu atiyuay dà ipiyal ku ikaw sa madakel pa. Sumeled ka dini ta daw makalagkes ka hu kalipay ku.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nakauma daan haena sa sinaligan ha inilahan din hu daruwa ha libu daw minikagi daan hu ‘Inilahan a ikaw hu daruwa ha libu. Ahaa nu, taini sa ganansiya din ha daruwa daan ha libu.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Inikagiyan daan taena ha agalen hu ‘Maayad gayed tungkay sa binuhat nu. Tumenged ta kasaligan ka hu atiyuay dà ipiyal ku ikaw sa madakel pa. Sumeled ka dini ta daw makalagkes ka hu kalipay ku.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Dayun nakauma daan su sinaligan ha inilahan hu nangkalibu saena minikagi hu ‘Natun-an ku ha manlulupig ka ha etaw ta aglegtayen nu sa kenà ikaw ha insawed daw agtimuen nu daan sa kenà ikaw ha inukapan. ");
INSERT INTO bkd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tumenged ta nahaldek a ikaw bà ku dà inlebeng su salapì nu. Ahaa nu, taini dà su nangkalibu.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ba inikagiyan taena ha agalen din ha ‘Buang-buang ka gayed daw pugulen ha sinaligan. Natun-an nud man diay ha aglegtayen ku sa kenà kanak ha insawed daw agtimuen ku daan sa kenà kanak ha inukapan. ");
INSERT INTO bkd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maayad ngaay ku imbangku nu hayana sa salapì ku ta daw maisaban ku lumikù a.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Aman inikagiyan din su lain ha suluguen din hu ‘Timua nu hayana sa nangkalibu diyà ta kandin daw iila duun taena ha nakatimù hu sampulù ha libu. ");
INSERT INTO bkd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta sa etaw ha amin en kandin mailahan hu tungkay pa gayed madakel dì hu kinahanglanen din, ba saena ha hurà din en hu kandin bisan su iyan-iyan din dà timuen pa gayed haena diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Daw ilambeg nu su suluguen ha hurà din pulus duun hu kasukileman diyà ta guwà ha duun makag-ulahuay hu kalugul daw magkangget sa mga ngipen din hu kasakitan.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Siak sa Suled hu Kaet-etawan ku lumikù a dini ha tagpangaluanlag duma hu alan ha mga balinsuguen hu Dios minuu a duun hu trono. ");
INSERT INTO bkd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Umatubang kanak sa alan ha kaet-etawan daw bahinen ku sidan iling hu magbalantay hu karniro ha igtapid din sa kambing duun hu karniro, ");
INSERT INTO bkd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sa mga karniro dini dapit ta kawanan ba sa mga kambing dini ta gibang. ");
INSERT INTO bkd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Dayun siak sa Harì umikagi a duun hu mga etaw dini dapit ta kawanan ku hu ‘Sinyu sa napanalanginan hu Dios ha Amay ku, dini kaw daw dawata en sa pagharì ku inyu ha inandam kud en inyu sugud dà su tanghagaen sa kalibutan. ");
INSERT INTO bkd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta su mauhul a impakaen a inyu daw su malauwan a impainum a daan inyu. Su langyaw a diyan impaseled a inyu duun hu balay nuy ");
INSERT INTO bkd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","daw su tagkinahanglan a hu pinaksuy inilahan a inyu. Su madaluwan a pigtanul a inyu daw su mapurisu a pigbisitahan a inyu.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Dayun manginginsà su mga etaw ha matareng hu ‘Ginuu, kan-u day ikaw naahà ha nauhul daw ku nalauwan ba na impakaen day ikaw daw impainum day ikaw? ");
INSERT INTO bkd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kan-u day ikaw impaseled duun hu balay day ta langyaw ka daw ku kan-u day daan ikaw inilahi hu pinaksuy ta migkinahanglan ka? ");
INSERT INTO bkd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kan-u day ikaw pigbisitahi ta nadaluwan ka daw ku napurisu ba?’ ");
INSERT INTO bkd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Duun taena siak sa Harì tumubag a hu ‘Laus gayed sa ag-ikagiyen ku inyu ha bisan inu sa binuhat nuy taena ha kinaminusan en gayed ha suled ku binuhat nuy en daan haena dini ta kanak.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Dayun ikagiyan ku daan sa mga etaw ha dini dapit ta gibang ku hu ‘Sinyu sa hinukuman en hu Dios, paman-awà kaw dini daw duun kaw hu hapuy ha harì en gayed agkapedengan ha intagana ki Satanas daw hu mga ginsakupan din. ");
INSERT INTO bkd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta nauhul a ba hurà a inyu ipakaen daw nalauwan a ba hurà a inyu ipainum. ");
INSERT INTO bkd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Langyaw a diyan ta inyu ba hurà a inyu ipaseled duun hu balay nuy. Migkinahanglan a hu pinaksuy ba hurà a inyu ilahi. Nadaluwan a daw napurisu a ba hurà a inyu bisitahi.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Dayun manginginsà sidan kanak hu ‘Ginuu, kan-u day ikaw naahà ha nauhul ka daw ku nalauwan ba daw ku langyaw ka dini ta kanay daw ku migkinahanglan ka hu pinaksuy daw ku nadaluwan ka ba daw ku napurisu ka daan ha hurà day ikaw buligi?’ ");
INSERT INTO bkd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Duun taena siak sa Harì tumubag a hu ‘Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u haena sa hurà nuy buligi duun taena ha kinaminusan gayed ha suled ku iyan ad en hurà nuy kabuligi.’ ");
INSERT INTO bkd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Dayun saena ha mga etaw ilambeg diyà ta Inferno daw silutan hu hurà din katapusan, ba sa matareng mailahan hu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Su makapenga en si Jesus magtudlù inikagiyan din sa mga tinun-an din hu ");
INSERT INTO bkd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Natun-an nuy ha makaduwa iman iyan en pagsaulug hu Aldaw hu Paglabay daw siak sa Suled hu Kaet-etawan itugyan a duun hu mga etaw ta daw makalansang a kandan duun hu krus.” ");
INSERT INTO bkd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mig-amul-amul sa mga labaw ha sinaligan hu paghalad daw sa mga magulang duun hu balay hi Caifas sa tungkay labaw ha sinaligan hu paghalad ");
INSERT INTO bkd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","daw miglalang-lalang sidan ku in-inuwen dan sa pagdakep ki Jesus ha harì matun-an hu mga etaw ta daw mapatay dan. ");
INSERT INTO bkd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba minikagi sidan hu “Harì taw dakepen duun hu pagsaulug ta kan ku magubut sa mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Su tagkaen si Jesus diyà ta Betania duun hu balay hi Simon ha sanglahen su anay amin bahi ha uminubay diyà ki Jesus. Saena ha bahi tag-uwit hu pahumut ha tungkay mahal ha intagù duun hu butilya ha alabastro dayun inhudhud din haena diyà ta ulu hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ba su maahà hu mga tinun-an din napauk gayed sidan ha tagyanaen “Imbà din bà dà kalkali hayana sa pahumut? ");
INSERT INTO bkd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maayad pa ngaay ku imbaligyà hayana hu tungkay mahal daw sa halin din in-ila duun hu mga makaluluuy.” ");
INSERT INTO bkd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ba natun-an hi Jesus sa tagsubayen dan aman inikagiyan din sidan hu “Imbà nuy agsamuka haini sa bahi? Sa binuhat din dini ta kanak madagway tungkay. ");
INSERT INTO bkd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sa mga makaluluuy sigi dà diyan ta inyu ba siak harì ad en maglugay dini ta inyu. ");
INSERT INTO bkd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Binuhat din haini dini ta kanak hu pagpangandam hu kalebenga kanak. ");
INSERT INTO bkd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Laus gayed sa ag-ikagiyen ku inyu ha bisan hindu asem duun isangyaw sa Maayad ha Tultulanen dini ta tibuuk ha kalibutan sa binuhat taini ha bahi harì gayed malipatan daw itultul daan.” ");
INSERT INTO bkd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Si Judas Iscariote sa sabuwa duun hu sampulù daw daruwa ha tinun-an duminuun hu mga labaw ha sinaligan hu paghalad ");
INSERT INTO bkd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","daw nanginginsà hu “Pila sa isuhul nuy kanak ku itugyan ku diyan ta inyu si Jesus?” Sagunà dan haena inilahan hu trayinta ha salapì. ");
INSERT INTO bkd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sugud taena nan-ahà si Judas hu paagi ha makatugyan din si Jesus diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Su mauma en sa panahun ha agsaulugen sa Pagkaen hu Supas ha Hurà Duun Igpatulin nanginginsà sa mga tinun-an diyà ki Jesus hu “Hindu sa agkabayaan nu ha elegan day hu pagpangandam hu igpanihapun taw hu pagsaulug?” ");
INSERT INTO bkd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tuminubag si Jesus ha “Dumuun kaw hu sabuwa ha etaw diyà ta banuwa daw ikagiyi nuy hu ‘Sa Manunudlù tag-ikagi ha ubay en sa natugun ha panahun ha matay aman agpanihapun haena duma hu mga tinun-an din diyà ta balay nu hu pagsaulug.’” ");
INSERT INTO bkd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Binuhat hu mga tinun-an sa insugù kandan hi Jesus dayun nangandam sidan hu pagkaen taena ha pagsaulug. ");
INSERT INTO bkd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Su daleman en mininuu si Jesus daw sa mga tinun-an din hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Su kamulu pa sidan tagkaen inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha sa sabuwa inyu iyan maglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nangaguul gayed su mga tinun-an din aman sa kada sabuwa kandan nanginginsà hu “Ginuu, iyan a ba?” ");
INSERT INTO bkd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tuminubag si Jesus hu “Iyan sa sabuwa diyan ta inyu ha nakigsalu kanak. ");
INSERT INTO bkd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Siak sa Suled hu Kaet-etawan matay a gayed sumalà hu insulat ha lalang hu Dios mahitenged kanak. Ba kahid-u gayed hu etaw ha maglimbung kanak. Maayad pa ngaay ku hurà en haena ibatà.” ");
INSERT INTO bkd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dayun minikagi si Judas sa miglimbung kandin hu “Manunudlù, iyan a ba?” Tuminubag si Jesus hu “Sa inikagi nu na iyan en.” ");
INSERT INTO bkd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Su kamulu pa sidan tagkaen tuminimù si Jesus hu supas daw ampui. Dayun pinangebing din haena daw ipan-ila duun hu mga tinun-an din ha tagyanaen “Timua nuy haini daw kan-a ta iyan en haini lawa ku.” ");
INSERT INTO bkd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dayun tinimù din sa tasa daw ampui daan haena. In-ila din diyà ta kandan hu kagi din “Alan kaw inum duun ");
INSERT INTO bkd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ta iyan en haini langesa ku ha igpamalas hu mga salà hu kaet-etawan ha iyan timaan hu bag-u ha kasabutan hu Dios daw hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ikagiyen ku inyu ha daw ad en asem isab ag-inum hu bag-u ha binu duma inyu ku magharì en sa Dios ha Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Su makagkanta en sidan hu pagdayè hu Dios duminiyà sidan ta Buntud ta Olibo. ");
INSERT INTO bkd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Inikagiyan hi Jesus su mga tinun-an din hu “Alan kaw sumuway kanak taini ha daleman ta sa insulat ha lalang hu Dios tagyanaen ‘Aghimatayan ku sa magbalantay daw makagsusuwayà sa mga karniro.’ ");
INSERT INTO bkd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ba ku mabanhaw ad umuna a inyu diyà ta Galilea.” ");
INSERT INTO bkd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Minikagi si Pedro hu “Bisan ku sumuway ikaw sa duma ba harì a gayed hu kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ba inikagiyan hi Jesus hu “Laus gayed sa ag-ikagiyen ku ikaw ha taini ha daleman sa harì pa managauk sa manuk katatulu kad en makaikagi ha harì a ikaw agkakilala.” ");
INSERT INTO bkd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tuminubag si Pedro hu “Bisan pa ku himatayan a duma ikaw ba harì ku gayed hayana ikagiyen.” Iyan daan haena inikagi hu alan ha mga tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Si Jesus daw sa mga tinun-an din duminuun hu lugar ha tagngaranan ta Getsemane daw inikagiyan din sidan hu “Dini kaw dà taini magpinuu ta agdayun a diyà ta unahan hu pag-ampù.” ");
INSERT INTO bkd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Dinuma din si Pedro daw sa daruwa ha batà hi Zebedeo. Suminakit gayed sa gahinawa din hu kalugul ");
INSERT INTO bkd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","aman inikagiyan din sidan hu “Miglabay gayed kasakit sa gahinawa ku ha bà su agkabugtù en. Dini kaw dà daw magbantay kaw duma kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Su makadiyà en si Jesus ta unahan luminuhud daw dunghuy diyà ta bugtà ha mig-ampù ha tagyanaen “Amay ku, ku mabaluy ngaay harì a ikaw ipaagi duun taini ha mga alantusen. Ba iyan sa ikaw ha pagbayà matuman kenà iyan sa kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Dayun linikuan hi Jesus su tatulu ha tinun-an din ba naahà din ha tagtidugahà en sidan. Aman inikagiyan din si Pedro hu “Imbà kaw harì pakagbantay bisan ngaay nangkauras dà? ");
INSERT INTO bkd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Magbantay kaw gayed daw mag-ampù ta daw harì kaw madaeg hu panulay. Agkabayà ngaay sa henà-henà nuy ba maluya kaw.” ");
INSERT INTO bkd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Luminikù dà paman si Jesus daw mig-ampù ha tagyanaen “Amay ku, ku mabaluy ngaay harì a ikaw ipaagi duun taini ha mga alantusen. Ba iyan sa ikaw ha pagbayà matuman kenà iyan sa kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Su likuan din dà su mga tinun-an din naahà din ha tagtidugahà gihapun ta harì gayed sidan pakaantus. ");
INSERT INTO bkd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aman inawaan din sidan daw luminikù en paman hu ikatulu ha mig-ampù iling ku nauna. ");
INSERT INTO bkd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dayun linikuan din dà paman sa mga tinun-an din daw ikagiyi sidan hu “Tagtidugahà kaw pa ba diay? Ahaa nuy, iyan en haini panahun ha siak sa Suled hu Kaet-etawan itugyan ad en duun hu mga makasasalà ha etaw. ");
INSERT INTO bkd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangun kaw ta aghipanaw kuy en. Ahaa nuy, taini en sa etaw ha taglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Su kamulu pa tag-ikagi si Jesus nakauma en sa sabuwa duun taena ha sampulù daw daruwa ha tinun-an ha iyan si Judas duma hu madakel ha mga etaw ha tag-uuwit hu mga ispada daw mga bunal ta sinugù sidan hu mga labaw ha sinaligan hu paghalad daw hu mga magulang. ");
INSERT INTO bkd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Amin timaan ha inikagi kandan hi Judas ha tagyanaen “Sa hadekan ku iyan en haena aman dakepen nuy dayun.” ");
INSERT INTO bkd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sagunà inubayan hi Judas si Jesus daw ikagiyi hu “Manunudlù” dayun hinadekan din. ");
INSERT INTO bkd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tuminubag si Jesus hu “Agpasa en sa agbuhaten nu.” Dayun si Jesus dinakep ku mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ba sa sabuwa duun hu mga tinun-an hi Jesus duminagtù hu ispada din daw tigbasa sa suluguen hu tungkay labaw ha sinaligan hu paghalad aman nalapungan haena. ");
INSERT INTO bkd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ba inikagiyan hi Jesus su tinun-an ha “Isakeb hayana sa ispada nu ta sa tag-ibit hu ispada ispada daan sa igpatay din. ");
INSERT INTO bkd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Hurà nu ba katun-i ha ku magpabulig a hu Dios ha Amay ku sagunà din dà ipadini sa libu-libuwen ha mga balinsuguen din? ");
INSERT INTO bkd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ba ku buhaten ku haena harì gayed matuman sa insulat ha lalang hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dayun inikagiyan hi Jesus su mga etaw hu “Pangulu a ba hu mga tulisan imbà kaw tag-uuwit hu mga ispada daw mga bunal hu pagdakep kanak? Aldaw-aldaw migpinuu a diyà ta Timplo daw nanudlù, imbà a hurà inyu dakepa diyà? ");
INSERT INTO bkd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ba saena nahitabù ta daw matuman sa insulat hu mga propita.” Dayun inawaan si Jesus hu mga tinun-an din ta nangakapulaguy sidan. ");
INSERT INTO bkd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Inuwit si Jesus ku mga etaw ha migdakep kandin diyà ta balay hi Caifas sa tungkay labaw ha sinaligan hu paghalad ta diyà en tag-amul-amul sa mga manunudlù hu Kasuguan daw sa mga magulang. ");
INSERT INTO bkd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Si Pedro taglupug daan kandan ba madiyù dà daw diyà dà nataman ta lama. Uminamul haena duun hu mga bantay ha tagpinuu diyà ta ag-ahaen din ku inu sa maul-ulahan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sa mga labaw ha sinaligan hu paghalad daw sa alan ha duma dan ha mga labaw ha punuan hu mga Judio nan-ahà gayed hu mga bidù ha katarengan ta daw mahimatayan dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ba hurà dan gayed agkaahà ha katarengan bisan ku madakel en sa nanistigus. Su malugay-lugay amin daruwa ha ");
INSERT INTO bkd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","minikagi hu “Sayana ha etaw agkagasen din kun haini sa Timplo hu Dios ba duun hu tatulu ha aldaw agbalayen din dà.” ");
INSERT INTO bkd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dayun huminitindeg su tungkay labaw ha sinaligan hu paghalad daw insai si Jesus hu “Inu sa makatubag nu taini ha sumbung dan ikaw?” ");
INSERT INTO bkd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ba si Jesus hurà en magtubag. Minikagi dà paman su tungkay labaw ha sinaligan hu paghalad ha “Duun hu atubangan hu Dios ha bubuhay ipanumpà nu daw ikagiyi kay ku iyan kad ba su Mesiyas ha Batà hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tuminubag si Jesus hu “Iyan ad en su inikagi nu. Ba ikagiyen ku inyu ha siak sa Suled hu Kaet-etawan maahà a asem inyu ha minuu a duun hu kawanan taena ha gamhanan ha Dios daw maahà a daan inyu ha makabulus diyà tayà ha gabunan.” ");
INSERT INTO bkd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Su mapaliman haena hu tungkay labaw ha sinaligan hu paghalad pigyahà din su pinaksuy din ta tungkay napauk ha tagyanaen “Hurà en kinahanglan ha amin pa manistigus ta napaliman taw en sa lalang din ha pigtameyes din gayed sa Dios. ");
INSERT INTO bkd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Inu man sa inyu ha henà-henà?” Tuminubag sa mga etaw hu “Angayan hayan ha silutan hu kamatayen.” ");
INSERT INTO bkd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dayun inileban dan sa weleng hi Jesus daw sinumbag dan. Sa duma miglaparu kandin ");
INSERT INTO bkd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","daw minikagi hu “Sikaw sa Mesiyas, tagnai ku sin-u kanay sa miglaparu ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Su tagpinuu si Pedro diyà ta lama amin bahi ha suluguen ha uminubay diyà ta kandin daw ikagiyi hu “Iyan ka man diay duma hi Jesus ha taga-Galilea.” ");
INSERT INTO bkd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ba duun hu atubangan taena ha mga etaw miglimud si Pedro hu “Harì ku agkatun-an ku inu sa tagsubayen nu.” ");
INSERT INTO bkd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dayun guminuwà si Pedro payanaen diyà ta pultahan. Amin lain en paman ha bahi ha nakaahà kandin daw minikagi duun hu mga etaw diyà hu “Iyan haini duma hi Jesus ha taga-Nazaret.” ");
INSERT INTO bkd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ba si Pedro miglimud en paman daw nanumpà hu kagi din “Harì ku agkakilala ku sin-u hayana.” ");
INSERT INTO bkd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Su malugay-lugay inikagiyan si Pedro ku mga etaw ha tagtiyadeg diyà ha “Duma ka gayed tayaa ta agkatun-an ta duun hu inikagiyan nu.” ");
INSERT INTO bkd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nanumpà gayed si Pedro hu kagi din “Harì ku agkakilala ku sin-u hayana.” Dayun tuminagauk sa manuk. ");
INSERT INTO bkd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Sagunà nahenhenaan hi Pedro sa inikagi hi Jesus kandin ha “Ku harì pa managauk sa manuk katatulu kad en makaikagi ha harì a ikaw agkakilala.” Aman guminuwà si Pedro daw mag-agalaay. ");
INSERT INTO bkd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Su maselem en sa alan ha mga labaw ha sinaligan hu paghalad daw sa mga magulang miglalang-lalang daw mig-uyun ha himatayan dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aman binakus dan haena daw itugyan diyà ki Pilato ha gubernador. ");
INSERT INTO bkd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Su matun-an hi Judas ha si Jesus hinukuman en hu kamatayen nakagbasul gayed haena hu paglimbung din. Aman luminikù duun hu mga labaw ha sinaligan hu paghalad daw mga magulang ta iglikù din ngaay haena sa trayinta ha salapì ");
INSERT INTO bkd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","daw minikagi hu “Nakasalà a gayed ta piglimbungan ku sa etaw ha hurà din salà.” Ba saena ha mga punuan tuminubag ha “Hurà day en labet ta ikaw dà hayana ha kasamuk.” ");
INSERT INTO bkd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aman inlambeg hi Judas su salapì diyà ta Timplo daw awà diyà dayun mighiket. ");
INSERT INTO bkd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Su matimù hu mga labaw ha sinaligan hu paghalad su salapì minikagi sidan hu “Masupak taw sa Kasuguan ku saini ha salapì iugsak taw duun hu talaguay hu salapì dini ta Timplo ta saini imbayad en para hu paghimatay hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aman nauyunan dan ha saena ha salapì ipalit dan hu bugtà taena ha mamumuhat hu tadyaw ta agbuhaten ha panlebengà hu mga langyaw. ");
INSERT INTO bkd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iyan haena hinengdan ha pigngaranan hu Bugtà ha Pigbayaran hu Langesa hangtud iman ha panahun. ");
INSERT INTO bkd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aman natuman sa lalang hu Dios ha impaikagi din ki Jeremias sa propita ha tagyanaen “Tinimù dan su trayinta ha salapì ta iyan haena nauyunan hu mga kaliwatan hi Israel ");
INSERT INTO bkd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","daw impalit dan hu bugtà taena ha mamumuhat hu tadyaw.” ");
INSERT INTO bkd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Su diyà en si Jesus ta atubangan ku gubernador ininsaan din si Jesus hu “Iyan ka ba Harì hu mga Judio?” Tuminubag si Jesus hu “Iyan ad en su inikagi nu.” ");
INSERT INTO bkd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Su magsumbung sa mga labaw ha sinaligan hu paghalad daw sa mga magulang diyà ki Pilato hurà en magtubag si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dayun inikagiyan haena hi Pilato hu “Harì nu ba agkapaliman sa alan ha mga sumbung dan mahitenged ikaw?” ");
INSERT INTO bkd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ba hurà en gayed magtubag si Jesus aman su gubernador tungkay gayed nabeleng. ");
INSERT INTO bkd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ku agsaulugen sa Aldaw hu Paglabay iyan naanadan hu gubernador sa amin sabuwa ha purisu ha aglibriyen din sumalà hu agpanayuen hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Duun taena ha panahun amin nabantug ha purisu ha tagngaranan ki Barabas. ");
INSERT INTO bkd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aman su maamul-amul en sa mga etaw ininsaan sidan hi Pilato hu “Sin-u sa agkabayaan nuy ha libriyen ku? Iyan ba si Barabas daw ku iyan ba si Jesus sa tagngaranan daan ki Cristo?” ");
INSERT INTO bkd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Natun-an hi Pilato ha si Jesus intugyan hu mga punuan diyà ta kandin tumenged hu kasina dan kandin. ");
INSERT INTO bkd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Su duun en si Pilato taena ha pinun-ayà hu maghuhukum nakauma daan sa sulat hu asawa din ha tagyanaen “Harì ka maglabet-labet taini ha etaw ha hurà din salà ta ganina ha daleman mig-antus a hu damugu ku mahitenged kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ba pigdasig sa mga kaet-etawan taena ha mga labaw ha sinaligan hu paghalad daw mga magulang ha iyan dan panayuen si Barabas ha libriyen daw himatayan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Minisab nanginginsà su gubernador hu “Sin-u duun taini ha daruwa sa agkabayaan nuy ha libriyen ku?” Sa mga etaw tuminubag hu “Iyan si Barabas.” ");
INSERT INTO bkd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nanginginsà dà paman si Pilato hu “In-inuwen ku diay si Jesus sa tagngaranan daan ki Cristo?” Alan sidan tuminubag hu “Ilansang hayana duun hu krus.” ");
INSERT INTO bkd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ba minikagi si Pilato hu “Imbà nuy igpalansang hayana? Inu diay sa nabuhat din ha madaet?” Ba bà dà nasì uminiseg sa kulahì hu mga etaw ha “Ilansang hayana.” ");
INSERT INTO bkd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Su matun-an hi Pilato ha hurà en pulus hu pag-ikagiyà din ta agkagubut en sa mga etaw tuminimù haena hu wahig daw henawi sa alima din duun hu atubangan taena ha mga etaw hu kagi din “Inyu en haini ha salà aman sa langesa taini ha etaw diyan en ta alima nuy ta nangenaw ad en hu kanak.” ");
INSERT INTO bkd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tuminubag sa alan ha mga etaw hu “Iyan kay en agpanubag tayana daw sa mga kaliwatan day.” ");
INSERT INTO bkd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dayun impaguwà hi Pilato si Barabas. Ba si Jesus pinalagkutan din daw itugyan duun hu mga etaw ta daw makalansang dan duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Impaseled si Jesus hu mga sundalu duun ku balay hi Pilato dayun inamul-amulan haena hu kasundaluwan. ");
INSERT INTO bkd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linebasan dan si Jesus daw pinaksuyi hu maligà ha manggad. ");
INSERT INTO bkd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tuminimù daan sidan hu gawed ha dugiyen ha binangkulà daw insuup dan diyà ta ulu hi Jesus. Dayun impabalabad dan sa kawanan ha alima din hu sugkud daw luminuhud sidan diyà ta kandin hu pagtameyes kandin ha naman-ikagi hu “Mabuhì sa Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Inileban dan si Jesus daw binunalan dan sa ulu din ku sugkud din. ");
INSERT INTO bkd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Su mapengahan dan en sa pagtameyes ki Jesus inawà dan dà su maligà ha manggad daw ilikù diyà ta kandin su pinaksuy din. Dayun inuwit dan si Jesus duun hu lugar ha duun dan iglansang hu krus. ");
INSERT INTO bkd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Su diyà en sidan ta dalan nasal-aw dan sa etaw ha taga-Cirene ha tagngaranan ki Simon, dayun pineges dan ha tiangen din su krus hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nakauma sidan duun hu lugar ha tagngaranan hu Golgota ha sa kahulugan taena Tul-an hu Ulu hu Etaw. ");
INSERT INTO bkd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Diyà igpainum dan ngaay si Jesus hu binu ha inamulan hu bulung ha mapait, ba su mananam din haena hurà din en inuma. ");
INSERT INTO bkd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Su ilansang dan en si Jesus duun hu krus binahin taena ha mga sundalu sa pinaksuy din pinaagi hu ripa. ");
INSERT INTO bkd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dayun mininuu sidan daw binantayan dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa sampaw ta ulu din sinulatan hu sumbung mahitenged kandin ha tagyanaen “Iyan haini si Jesus ha Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Inlansang daan sa daruwa ha tulisan duma ki Jesus, sa sabuwa diyà dapit ta kawanan din daw sa sabuwa diyà ta gibang din. ");
INSERT INTO bkd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sa mga etaw ha agpamanagad tagkuyeng-kuyengà hu pagtameyes ki Jesus ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Kagi nu man ha agkagasen nu sa Timplo ta agbalayen nu dà duun hu tatulu ha aldaw. Ku laus ka ha Batà hu Dios libriya sa kaugalingen nu daw lugnà ka duun tayan ha krus.” ");
INSERT INTO bkd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iling daan taena sa pagtameyes hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan daw mga magulang hu kagi dan ");
INSERT INTO bkd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Aglibriyen din man gid sa duma ha mga etaw ba sa kandin ha kaugalingen harì din agkalibri. Ahaen taw hayana sa Harì hu mga kaliwatan hi Israel ku lumugnà ba iman duun tayan ha krus daw makatuu kuy kandin. ");
INSERT INTO bkd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iyan man kun hayan Batà hu Dios daw tagsalig duun hu Amay din. Aman ku agkabayaan hu Dios ipalibri en kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Saena ha mga tulisan ha inlansang duma kandin migtameyes en daan kandin. ");
INSERT INTO bkd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Su maugtu en sa aldaw suminukilem sa tibuuk ha kalibutan hu tatulu ha uras. ");
INSERT INTO bkd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Su agkabalalay en sa aldaw nangulahì si Jesus hu madaging ha tagyanaen “Eli, Eli, lama sabaktani?” ha tagkahulugan hu “Dios ku, imbà a ikaw bay-ani?” ");
INSERT INTO bkd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Su mapaliman haena hu duma ha mga etaw ha tagtiyadeg diyà ta ubay din minikagi sidan hu “Tag-umawen din gid si Elias sa propita.” ");
INSERT INTO bkd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa sabuwa kandan sagunà tuminimù hu manggad ha inteleb duun hu sukà daw ibedbed duun hu panga dayun insungit din ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ba sa duma ha mga etaw minikagi hu “Bay-ani hayan ta ag-ahaen taw pa ku makahiwal ba si Elias hu paglibri kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Uminisab nangulahì si Jesus dayun nabugtù sa gahinawa din. ");
INSERT INTO bkd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Su makepal ha manggad ha in-elang diyà ta Timplo sagunà naliwarà nayahà sugud ta sampaw payanaen ta sagayadan taena. Miglinug daan daw nangabengkag sa mga adagi ha batu. ");
INSERT INTO bkd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sa mga liyang ha panlebengà nangapuwaan daw amin nangabanhaw ha mga etaw hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Su mabanhaw en si Jesus su mga etaw ha nangabanhaw daan namandiyà ta Jerusalem daw madakel sa nakaahà kandan diyà. ");
INSERT INTO bkd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Su mga sundalu daw sa kapitan dan ha migbantay ki Jesus nangahaldek gayed su magedam dan sa linug daw su maahà dan sa duma pa ha nahitabù daw nakaikagi sidan hu “Laus gayed ha Batà haini hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Madakel sa mga bahi ha tagbantay ki Jesus ba diyà dà sidan ta madiyù. Duminuma sidan ki Jesus ha nangapuun ta Galilea hu pag-alima kandin. ");
INSERT INTO bkd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sa duma kandan iyan si Maria Magdalena daw si Maria ha inay hi Santiago daw hi Jose daw sa asawa hi Zebedeo. ");
INSERT INTO bkd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Su mahapun en duminiyà ki Pilato sa sabuwa ha sumusunud hi Jesus ha iyan si Jose sa sapian ha taga-Arimatea daw panayua sa lawa hi Jesus. Insugù hi Pilato ha saena iila kandin ta daw makalebeng din. ");
INSERT INTO bkd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aman tinimù hi Jose sa lawa hi Jesus daw bungkusi hu bag-u daw maputì ha manggad ");
INSERT INTO bkd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","daw itagù din duun hu bag-u din pa pinabangbangi ha dampiyas. Inipelan din haena hu adagi ha batu dayun minipanaw. ");
INSERT INTO bkd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena daw su sabuwa ha Maria tagpinuuwà sidan atbang taena ha lebeng. ");
INSERT INTO bkd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Su maisab ha aldaw daw Aldaw en hu Paghimlay namandiyà ki Pilato sa mga labaw ha sinaligan hu paghalad daw sa mga Fariseo ");
INSERT INTO bkd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hu kagi dan “Natiman-an day sa inikagi taena ha limbungan su bubuhay pa ha mabanhaw dà kun ku maiwas sa tatulu ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aman palig-eni nu haena sa lebeng din taman hu tatulu ha aldaw ta daw harì matakaw sa lawa din hu mga tinun-an din, ta kan ku ikagiyan dan sa mga etaw ha nabanhaw dà daw dayunan dan limbungan sa mga etaw labaw pa dì su anay.” ");
INSERT INTO bkd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tuminubag si Pilato ha “Dumaha nuy sa mga sundalu daw lig-eni gayed su lebeng.” ");
INSERT INTO bkd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aman inelegan dan haena sa lebeng daw lig-eni pinaagi hu pag-ugsak hu timaan duun ku batu daw pinabantayan hu mga sundalu. ");
INSERT INTO bkd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Su maiwas en sa Aldaw hu Paghimlay daw kaaldawen en hu Dominggo si Maria Magdalena daw sa sabuwa ha Maria duminuun ku piglebengan ki Jesus ta ag-ahaen dan haena. ");
INSERT INTO bkd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tigkan miglinug hu tungkay mabis-ay ta amin migbulus ha balinsuguen hu Dios ha mig-awà ku batu ha in-ipel ku lebeng hi Jesus daw pinuu duun. ");
INSERT INTO bkd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Sa kadagway taena ha balinsuguen tagpangaluanlag iling hu kilat daw sa pinaksuy din tungkay maputì. ");
INSERT INTO bkd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sa mga sundalu ha tagbantay ku lebeng pighugdunan hu kahaldek dan daw nangailing sidan hu minatay. ");
INSERT INTO bkd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ba inikagiyan ku balinsuguen haena sa mga bahi hu “Harì kaw agkangahaldek ta natun-an ku ha tagpan-ahaen nuy si Jesus sa inlansang duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hurà en dini ta nabanhaw en sumalà hu inikagi din inyu. Ahaa nuy haini sa naugsakan din. ");
INSERT INTO bkd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aman agpasa nuy elegi sa mga tinun-an din daw ikagiyi sidan ha nabanhaw en si Jesus ba ag-una en kandan diyà ta Galilea. Maahà nuy haena diyà. Timan-i nuy haini sa inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Su mga bahi nangahaldek ba adagi daan sa kalipay dan, aman inawaan dan su lebeng daw pulalaguy ta agtultulan dan sa mga tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Su diyà pa sidan ta dalan tigkan huminiwal si Jesus diyà ta kandan daw inikagiyan din sidan hu “Magmalinawen kaw.” Inubayan ku mga bahi daw inibitan dan sa paa din hu pagsimba kandin. ");
INSERT INTO bkd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dayun inikagiyan sidan hi Jesus hu “Harì kaw agkahaldek. Ikagiyi nuy sa mga suled ku ha dumiyà sidan ta Galilea ta maahà a kandan diyà.” ");
INSERT INTO bkd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Su humipanaw en su mga bahi sa duma ha mga bantay duminiyà ta Jerusalem daw nanunultul hu nahitabù duun ku mga labaw ha sinaligan hu paghalad. ");
INSERT INTO bkd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Su maglalang-lalang su mga labaw ha sinaligan hu paghalad daw sa mga magulang mig-uyun sidan ha ilaban dan hu madakel ha salapì su mga sundalu ");
INSERT INTO bkd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","daw inikagiyan dan ha “Tultulan nuy sa mga etaw ha su daleman en nakatiduga kaw aman tinakaw hu mga tinun-an hi Jesus sa lawa din. ");
INSERT INTO bkd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Daw harì kaw agkasamuk ku mapaliman haena hu gubernador ta iyan kay en ag-ikagi kandin.” ");
INSERT INTO bkd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aman dinawat ku mga sundalu su salapì daw tinuman dan sa inikagi kandan. Bisan iman iyan pa haini tagtuuwan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Su sampulù daw sabuwa ha tinun-an hi Jesus duminiyà ta Galilea duun taena ha bubungan ha inikagi din ha elegan dan. ");
INSERT INTO bkd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Su maahà dan en si Jesus sinimba dan ba amin kandan tagduwa-duwa. ");
INSERT INTO bkd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dayun uminubay si Jesus diyà ta kandan daw minikagi hu “In-ila kanak sa kagahem hu pagharì diyà ta langit daw dini ta kalibutan. ");
INSERT INTO bkd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aman hipanaw kaw duun hu bisan hindu daw tultuli nuy sa mga etaw duun hu alan ha mga nasud ta daw mabuhat sidan ha sumusunud ku. Bautismuwi nuy sidan pinaagi hu ngaran hu Dios ha Amay daw hu ngaran ku siak sa Batà din daw hu ngaran hu Balaan ha Ispiritu, ");
INSERT INTO bkd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","daw tudluan nuy daan sidan hu pagtuman taena ha insugù ku inyu. Harì nuy aglipati ha sigi a magduma inyu hangtud hu katapusan hu panahun.”");
INSERT INTO bkd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iyan haini puunaan hu Maayad ha Tultulanen mahitenged ki Jesu Cristo sa Batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Insulat hu propita ha si Isaias sa inikagi hu Dios su anay diyà ki Jesus ha tagyanaen “Amin ku igpauna dì ikaw ta daw makapangandam hu ag-agiyan nu. ");
INSERT INTO bkd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Saena magkulahiay duun hu pinakabulung-bulung ha lugar ha magyanaen ‘Andama sa ag-agiyan hu Ginuu daw tul-ida sa dalan.’” ");
INSERT INTO bkd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aman nakauma si Juan ha Bautista duun taena ha pinakabulung-bulung ha lugar daw tagpanunultul ha tagyanaen “Maghinulsul kaw ta daw mapasaylu sa mga salà nuy daw magpabautismu kaw.” ");
INSERT INTO bkd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Madakel ha mga etaw sa namandiyà ta kandin ha nangapuun ta Jerusalem daw duun hu mga banuwa ha sakup ta Judea. Insugid dan sa mga salà dan aman pigbautismuwan sidan hi Juan diyà ta Wahig ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sa pinaksuy hi Juan bulbul hu kamilyo daw anis daan sa bakes din. Sa kalan-enen din talangas daw degà. ");
INSERT INTO bkd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iyan haini tultulanen din ha tagyanaen “Amin pa makadini ha labaw dì kanak ta bisan sa paghukad hu sapatus din kenà a gayed angayan duun. ");
INSERT INTO bkd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Diyà a ta wahig agpamautismu inyu ba sa kandin ha igbautismu iyan sa paulinan kaw kandin hu Balaan ha Ispiritu.” ");
INSERT INTO bkd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Duun taena ha panahun nakauma si Jesus sa napuun diyà ta Nazaret ha sakup ta Galilea dayun binautismuwan hi Juan diyà ta Wahig ta Jordan. ");
INSERT INTO bkd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Su taggaun pa si Jesus duun ku wahig naahà din ha napuwaan sa langit daw migbulus diyà ta kandin sa Balaan ha Ispiritu ha agkailing hu salapati. ");
INSERT INTO bkd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Amin lageng ha napuun diyà ta langit ha tagyanaen “Iyan ka gayed pinalanggà ku ha Batà ha tigkabayà-bayà ku.” ");
INSERT INTO bkd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dayun inuwit si Jesus hu Balaan ha Ispiritu duun hu pinakabulung-bulung ha lugar ");
INSERT INTO bkd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","daw pigsulayan hi Satanas seled hu kapatan ha aldaw. Amin daan diyà mga mananap ha agpamangagat hu etaw, ba sa mga balinsuguen hu Dios iyan mig-alima kandin. ");
INSERT INTO bkd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Su mapurisu en si Juan luminikù si Jesus diyà ta probincia ta Galilea daw migsangyaw hu Maayad ha Tultulanen ha napuun duun hu Dios ");
INSERT INTO bkd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ha tagyanaen “Iyan en haini panahun ha madani en sa pagharì hu Dios aman maghinulsul kaw daw tuuwi sa Maayad ha Tultulanen.” ");
INSERT INTO bkd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Su taghiphipanaw si Jesus duun hu kilid taena ha Danaw ta Galilea naahà din si Simon daw sa suled din ha si Andres ha tagpamaling duun taena ha danaw ta mamamaling man sidan. ");
INSERT INTO bkd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Inikagiyan sidan hi Jesus ha “Dumuma kaw kanak ta agbuhaten ku inyu ha mamamaling hu mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sagunà dan inawaan su baling dan daw duma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Su malugay-lugay naahà hi Jesus su mga migsuled daan ha iyan si Santiago daw si Juan sa mga batà hi Zebedeo ha tagpamandayan dan su mga baling dan duun ku barutu. ");
INSERT INTO bkd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aman inumaw sidan hi Jesus dayun inawaan dan si Amay dan ha si Zebedeo duun ku barutu duma hu mga sinuhulan dan daw duminuma sidan ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Namandiyà si Jesus daw sa mga tinun-an din ta Capernaum. Su Sabado ha iyan Aldaw hu Paghimlay sumineled si Jesus duun ku simbahan hu mga Judio daw panudlù. ");
INSERT INTO bkd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sa mga etaw diyà nangabeleng ta sa kandin ha pagtudlù amin duun gahem dì ku mga manunudlù hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Diyà ta simbahan amin etaw ha inulinan hu busaw ");
INSERT INTO bkd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ha tagkulahiay ha tagyanaen “Jesus ha taga-Nazaret, inu sa labet nu kanay? Duminini ka ba hu pagsilut kanay? Agkakilala ku ikaw ha sinugù ka hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ba binaldeng haena hi Jesus hu kagi din “Hagteng ka daw awà ka diyan tayan.” ");
INSERT INTO bkd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pinaagi hu gahem ku busaw nabidbid su etaw ha nakapangulahì dayun guminuwà su busaw. ");
INSERT INTO bkd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa alan ha mga etaw diyà nangabeleng gayed daw migpainsaay hu “Bag-u ba gid haini ha katudluanan? Ta saini ha etaw amin din gahem ha bisan sa mga busaw agtuu kandin.” ");
INSERT INTO bkd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sagunà nakalekep sa tultul mahitenged ki Jesus duun hu alan ha mga banuwa ha sakup ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sagunà uminawà si Jesus diyà ta simbahan daw duminiyà ta balay hi Simon daw hi Andres duma ki Santiago daw ki Juan. ");
INSERT INTO bkd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sa ugang ha bahi hi Simon harì en pakabangun ta agkagenaw daw tinultulan dan si Jesus taena. ");
INSERT INTO bkd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aman inubayan din haena daw ibiti sa alima din daw ipabangun. Sagunà haena naulian aman sinugbahan din dayun say Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Su madani en agpanukilem pinan-uwit hu mga etaw diyà ki Jesus sa alan ha agkangadaluwan daw sa pinan-ulinan en hu busaw. ");
INSERT INTO bkd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa mga etaw duun taena ha banuwa nangaamul-amul duun hu atbang taena ha balay ");
INSERT INTO bkd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","dayun naulian hi Jesus sa madakel ha hurà mag-iling sa dalu dan. Pinamugaw din daan sa mga busaw ba binaldeng din sidan ha harì mag-ikagiyà ta nakakilala en sidan kandin. ");
INSERT INTO bkd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Su madani en agkaaldaw si Jesus duminuun hu pinakabulung-bulung ha lugar daw mig-ampù diyà, ");
INSERT INTO bkd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","aman pinan-ahà haena hi Simon daw hu mga duma din. ");
INSERT INTO bkd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Su maahà dan en si Jesus inikagiyan dan hu “Madakel sa tagpan-ahà ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ba si Jesus tuminubag ha “Dumuun kuy hu lain ha mga banuwa ha ubay dini ta daw makagtultul a daan diyà, ta iyan haini indini ku ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aman nalekep hi Jesus sa alan ha mga banuwa ha sakup ta Galilea ha migtudlù duun hu mga simbahan hu mga Judio daw pinamugaw din daan sa mga busaw. ");
INSERT INTO bkd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Amin sanglahen ha luminuhud diyà ki Jesus daw hangyù ha “Ku mabayà ka ngaay bulungen a ikaw taini ha mahugaw ha dalu ku.” ");
INSERT INTO bkd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nahid-uwan haena hi Jesus aman dinampà din su sanglahen daw ikagiyi hu “Agkabayà a aman maulian ka.” ");
INSERT INTO bkd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sagunà haena naulian. ");
INSERT INTO bkd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dayun impahipanaw haena hi Jesus daw binalaudan din hu ");
INSERT INTO bkd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Harì ka manunultul hu bisan sin-u ba dumuun ka taena ha sinaligan hu paghalad ta daw masusi din ha naulian kad. Maghalad ka sumalà hu Kasuguan hi Moises ta daw malimpyuwan ka daw matun-an hu mga etaw ha naulian kad en.” ");
INSERT INTO bkd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ba su makahipanaw en su etaw bà dà nasì nanunultul duun hu bisan hindu. Aman si Jesus harì en paman pakaduun hu mga banuwa ba duun dà tagtimaay hu pinakabulung-bulung ha mga lugar. Ba bisan taena inelegan si Jesus hu mga etaw ha nangapuun duun hu bisan hindu. ");
INSERT INTO bkd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Su pila en ha aldaw ha makalikù si Jesus diyà ta Capernaum napaliman hu mga etaw ha nakaulì en si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aman inamul-amulan haena hu mga etaw na harì en sidan agkaaul bisan ta pultahan, dayun tinultulan sidan hi Jesus hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nakadiyà daan sa haepat ha mga etaw ha taglanting hu minatay en sa dibaluy ha lawa din. ");
INSERT INTO bkd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Harì sidan pakaubay diyà ki Jesus ta madakel tungkay sa mga etaw aman namanahik sidan diyà ta atep daw pusuwi sa tenged hi Jesus, dayun hinawil dan duun su agkadaluwan ha taghidegaay duun hu banig. ");
INSERT INTO bkd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Su matun-an hi Jesus ha adagi gayed sa pagsalig dan inikagiyan din su agkadaluwan hu “Napasaylu en sa mga salà nu.” ");
INSERT INTO bkd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amin daan tagpinuu diyà ha mga manunudlù hu Kasuguan ha nakahenà-henà hu ");
INSERT INTO bkd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Imbà iyan din hayan ikagiya? Tagtameyesen din sa Dios ta iyan dà gayed sa Dios makapasaylu hu mga salà.” ");
INSERT INTO bkd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ba sa mga henà-henà dan sagunà natun-an hi Jesus aman inikagiyan din sidan hu “Imbà kaw taghenà-henaay hu iling tayan? ");
INSERT INTO bkd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Inu diay sa malumu ha ikagiyen duun taini ha agkadaluwan? Iyan ba sa ‘Napasaylu en sa mga salà nu’ daw ku iyan ba sa ‘Bangun kad, luluna sa banig nu daw hipanaw kad en’? ");
INSERT INTO bkd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba iman igpaahà ku inyu ha siak sa Suled hu Kaet-etawan amin ku kagahem dini ta kalibutan hu pagpasaylu hu mga salà.” Aman inikagiyan din su etaw ha minatay en sa dibaluy ha lawa din hu ");
INSERT INTO bkd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Bangun kad, luluna su banig nu daw ulì kad en.” ");
INSERT INTO bkd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sagunà haena minangun daw uwita su banig din dayun awà diyà ta kandan. Sa alan ha mga etaw nangabeleng daw dinayè dan daan sa Dios hu kagi dan “Hurà kuy pa gayed makaahà hu agkailing taini.” ");
INSERT INTO bkd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Si Jesus duminuun dà paman hu kilid taena ha danaw. Madakel gayed ha mga etaw sa duminiyà ta kandin aman nanudlù dayun haena. ");
INSERT INTO bkd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Su taghipanaw si Jesus naahà din sa tagpinuu ha tagpanukut hu buhis ha tagngaranan ki Levi sa batà hi Alfeo. Inikagiyan din haena ha “Dumuma ka kanak” aman huminitindeg si Levi daw duma kandin. ");
INSERT INTO bkd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Su tagkaen si Jesus diyà ta balay hi Levi madakel ha mga manunukut hu buhis daw mga masinupaken sa nakigsalu kandin daw hu mga tinun-an din ta madakel sa namanlupug kandin. ");
INSERT INTO bkd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Su maahà hu mga manunudlù hu Kasuguan ha sakup hu mga Fariseo ha si Jesus nakigsalu hu mga masinupaken daw hu mga manunukut hu buhis, ininsaan dan su mga tinun-an hu “Imbà hayana pakigsalu hu mga limbungan ha manunukut hu buhis daw hu mga masinupaken?” ");
INSERT INTO bkd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Su mapaliman haena hi Jesus uminikagi hu “Sa harì agkadaluwan harì daan tagpabulung, ba sa agkadaluwan tagkinahanglan hu mamumulung. Sa pagdini ku kenà para hu mga matareng en ba sa tuyù ku iyan sa mga makasasalà.” ");
INSERT INTO bkd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Amin panahun ha sa mga sumusunud hi Juan ha Bautista daw sa mga Fariseo suminalang hu pagkaen. Amin mga etaw ha duminiyà ki Jesus daw nanginginsà hu “Imbà tagsalang hu pagkaen sa mga sumusunud hi Juan daw sa mga sumusunud hu mga Fariseo ba sa ikaw ha mga tinun-an harì gayed tagsalang?” ");
INSERT INTO bkd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tuminubag si Jesus hu “Mabaluy ba diay ku amin kaamulan ha sa mga inimbita harì kumaen ku diyà pa ta kandan sa agpangasawa? Harì gayed haena mabaluy. ");
INSERT INTO bkd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ba mauma sa panahun ha ipaawà en diyà ta kandan su agpangasawa daw human sidan agsalang hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Hurà etaw ha agtapikan din hu bag-u ha manggad sa daan en ha pinaksuy, ta ku buhaten din haena su bag-u ha manggad bà dà aglegkè daw su daan ha pinaksuy bà dà daan agkahigbit. ");
INSERT INTO bkd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iling daan ha hurà etaw ha itagù din sa bag-u pa ha binu duun hu daan en ha talaguay ha anis, ta ku buhaten din haena bà dà magbutu daw kahudhud su binu. Kinahanglan gayed ha sa bag-u pa ha binu duun dà daan itagù hu bag-u pa ha talaguay.” ");
INSERT INTO bkd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Amin aldaw hu Sabado ha nakaagi say Jesus duun hu uma. Su taghipanaw sidan namanimù sa mga tinun-an din hu mga bunga taena ha mga pamulahen duun. ");
INSERT INTO bkd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Inikagiyan hu mga Fariseo si Jesus hu “Ahaa nu, imbà supaka hu mga tinun-an nu sa Kasuguan mahitenged hu Aldaw hu Paghimlay?” ");
INSERT INTO bkd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ba tuminubag si Jesus ha “Hurà nuy ba diay kabasa haena sa binuhat hi David su panahun ha si Abiatar iyan pa tungkay labaw ha sinaligan hu paghalad? Su mangauhul si David daw sa mga duma din sumineled si David duun ku Tabernaculo daw kan-a su supas ha inhalad duun hu Dios dayun inilahan din su mga duma din bisan ku para dà ngaay haena hu mga sinaligan hu paghalad.” ");
INSERT INTO bkd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Dayun inikagiyan sidan hi Jesus hu “Mahinengdanen gayed sa etaw dì hu Kasuguan ta sa Aldaw hu Paghimlay intagana hu Dios ha makapaayad hu etaw. ");
INSERT INTO bkd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aman siak sa Suled hu Kaet-etawan iyan a tagbayà bisan hu Aldaw hu Paghimlay.” ");
INSERT INTO bkd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sumineled en paman si Jesus duun hu simbahan hu mga Judio daw amin daan etaw diyà ha nakimay. ");
INSERT INTO bkd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sa duma ha mga etaw tagpan-ahà hu katarengan ta daw makasumbung dan si Jesus aman binantayan dan ku bulungen din ba haena duun hu Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Inikagiyan hi Jesus su kimay ha “Dumini ka ta atubangan hu alan.” ");
INSERT INTO bkd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dayun ininsaan din daan sa mga etaw hu “Inu sa intugut hu Kasuguan ha buhaten taw duun hu Aldaw hu Paghimlay? Iyan ba sa pagbuhat hu maayad daw ku iyan ba sa madaet? Iyan ba sa pagluwas hu etaw daw ku iyan ba sa pagdaet kandin?” Ba hurà gayed sidan magtubag. ");
INSERT INTO bkd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mighelaw-helaw diyà ta kandan si Jesus ha napauk, ba naguul daan tumenged ta madesen sa henà-henà dan. Dayun inikagiyan din su etaw ha nakimay ha “Bunhata sa alima nu.” Aman binunhat din haena dayun sagunà naulian. ");
INSERT INTO bkd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Su mga Fariseo namangguwà daw miglalang-lalang sidan hu mga sakup hi Herodes ku in-inuwen dan sa kahimatayi ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Uminawà si Jesus diyà duma hu mga tinun-an din dayun duminuun sidan ku danaw. Namanduma kandan sa madakel tungkay ha mga etaw ha nangapuun diyà ta probincia ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Su mapaliman hu mga etaw sa mga binuhat hi Jesus madakel sa duminiyà ta kandin ha nangapuun ta probincia ta Judea daw ta Jerusalem daw duun hu mga banuwa ha sakup ta Idumea daw layun ta Jordan daw hu mga banuwa ha ubayà ta Tiro daw ta Sidon. ");
INSERT INTO bkd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tumenged ta madakel tungkay sa mga etaw sinugù hi Jesus su mga tinun-an din ha mag-andam hu barutu ha aglulanan din ta daw harì malipit hu mga etaw, ");
INSERT INTO bkd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ta madakel sa nangaulian din ha nangadaluwan aman sa duma ha tagdadalu agliet gayed ta ag-ibit ngaay kandin. ");
INSERT INTO bkd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Su maahà haena hu mga etaw ha inulinan hu busaw namanluhud sidan duun hu atubangan din daw namangulahì hu “Iyan ka gayed Batà hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ba binalaudan sidan hi Jesus ha harì dan ikagiyen ku sin-u. ");
INSERT INTO bkd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Duminuun si Jesus hu buntud daw inamul-amul din sa mga etaw ha agkabayaan din. ");
INSERT INTO bkd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dayun pinilì din su sampulù daw daruwa ha pigngaranan din hu mga apostoles ta daw makigduma-duma kandin daw masugù din hu pagpanunultul ");
INSERT INTO bkd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","daw magaheman daan hu pagbugaw hu mga busaw ha uminulin duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iyan haini su sampulù daw daruwa ha pinilì din, si Simon ha pigngaranan din ki Pedro, ");
INSERT INTO bkd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago daw si Juan sa pigdagnayan din hu Boarneges ha tagkahulugan hu Mga Etaw ha Agkailing hu Lugung, saini ha daruwa mga batà hi Zebedeo. ");
INSERT INTO bkd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pinilì daan hi Jesus si Andres daw si Felipe, si Bartolome daw si Mateo, si Tomas daw si Santiago sa batà hi Alfeo, si Tadeo daw si Simon sa sakup hu Cananiyo ");
INSERT INTO bkd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","daw si Judas Iscariote ha iyan miglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Sumineled si Jesus duun hu balay daw madakel en paman ha mga etaw sa nangaamul-amul diyà ta kandin, aman hurà en panahun hi Jesus daw hu mga tinun-an din hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Su mapaliman haena hu mga kadumahan din inelegan dan ta agtimuen dan ngaay, ta sa mga etaw tag-ikagiyà ha agkalibeg en si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Amin mga manunudlù hu Kasuguan ha nangapuun diyà ta Jerusalem ha tagyanaen “Inulinan haini hi Beelsebul sa agalen hu mga busaw aman agkabugaw din sa mga busaw.” ");
INSERT INTO bkd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Inamul-amul hi Jesus sa mga etaw daw ikagiyi pinaagi hu mga pananglitan ha tagyanaen “In-inuwen man hu pagbugaw hi Satanas hu duma din ha busaw? ");
INSERT INTO bkd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ku amin ginharian ha tagsasabà sa mga etaw duun agkabengkag gayed, ");
INSERT INTO bkd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","daw ku amin pamilya ha magsasabà mabengkag daan haena. ");
INSERT INTO bkd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aman ku sabaen hi Satanas sa mga sakup din sa ginharian din mabengkag gayed daw mahanaw. ");
INSERT INTO bkd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Henhenaa nuy ha hurà bisan sin-u ha makaseled duun hu balay hu mabis-ay ha etaw hu pag-agaw hu mga butang din ku harì din unahen bakusen su mabis-ay ha etaw daw human din katimù sa mga butang duun taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Laus gayed sa ag-ikagiyen ku inyu ha mabaluy pa ha pasayluwen sa alan ha mga salà hu etaw bisan sa pagtameyes hu duma, ");
INSERT INTO bkd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ba saena ha tagtameyes hu Balaan ha Ispiritu harì gayed mapasaylu hu hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Inikagi din haena ta sa duma ha etaw tag-ikagi ha si Jesus inulinan hu busaw. ");
INSERT INTO bkd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nakauma si Inay hi Jesus daw sa mga suled din. Diyà dà sidan tagtiyadeg ta guwà daw pinaelegan dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Madakel ha mga etaw sa tagpinuu ha nakalibut diyà ki Jesus, aman inikagiyan dan haena hu “Si Inay nu daw sa mga suled nu diyà ta guwà ta amin dan kun tuyù ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ba si Jesus tuminubag hu “Iman ikagiyen ku inyu ku sin-u sa inay ku daw sa mga suled ku.” ");
INSERT INTO bkd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Dayun uminahà haena duun hu mga etaw ha nakalibut diyà ta kandin daw ikagi hu “Taini en sa inay ku daw sa mga suled ku, ");
INSERT INTO bkd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ta bisan sin-u sa tagtuman hu agkabayaan hu Dios iyan en haena inay ku daw mga suled ku.” ");
INSERT INTO bkd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Amin panahun ha si Jesus migtudlù en paman duun hu kilid taena ha danaw. Tumenged ta madakel tungkay ha mga etaw sa nangaamul-amul diyà ta kandin mininuu haena duun hu barutu na sa mga etaw diyà dà ta gaun hu pagpaliliman kandin. ");
INSERT INTO bkd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dayun madakel sa mga intudlù din kandan pinaagi hu mga pananglitan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Magpaliliman kaw kanak. Amin etaw ha duminiyà ta uma hu pagpamegas. ");
INSERT INTO bkd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Su isawed din haena sa binhì amin diyà dà nakatanà ta dalan aman pinanukà hu mga tagbis. ");
INSERT INTO bkd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Amin daan binhì ha duun nakatanà hu batuwen. Saena laus dà lumineteb ta atiyuay dà sa pisà duun, ");
INSERT INTO bkd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ba su sildahan hu tungkay mapasù sagunà dà haena nangagangu ta hurà man panggamut. ");
INSERT INTO bkd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amin daan binhì ha duun nakatanà hu sampiniten. Tuminubù daan haena ba naenep dà hu mga sampinit aman hurà pamunga. ");
INSERT INTO bkd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ba amin binhì ha duun nakatanà hu balumbun ha bugtà. Saena tuminubù daan daw namunga gayed, sa duma duun tigkatluan sa bunga din daw amin daan namunga hu tigkaeneman daw amin daan namunga hu tignanggatus.” ");
INSERT INTO bkd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dayun si Jesus minikagi pa hu “Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Su maman-awà en diyà sa mga etaw sa mga tinun-an hi Jesus daw sa duma ha mga etaw nanginginsà diyà ta kandin mahitenged taena ha mga pananglitan. ");
INSERT INTO bkd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Inikagiyan din sidan hu “Sa inlilung su anay mahitenged hu pagharì hu Dios impadayag en inyu. Ba sa duma ha mga etaw tinudluan ku pinaagi hu mga pananglitan ");
INSERT INTO bkd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta daw ‘Mag-ahà sidan ba harì makaindan daw magpaliliman daan sidan ba harì makasabut, ta ku pakaindan pa daw pakasabut ngaay sidan maghinulsul gayed hu mga salà dan daw pasayluwen sidan hu Dios.’” ");
INSERT INTO bkd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Inikagiyan hi Jesus sa mga tinun-an din ha “Hurà nuy ba diay kasabut haena sa pananglitan? In-inuwen nuy sa pagpakasabut hu duma ha mga pananglitan? ");
INSERT INTO bkd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Saena ha insawed ha binhì hu namegas iyan sa lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Su binhì ha diyà dà nakatanà ta dalan iyan su mga etaw ha nakapaliman hu lalang hu Dios ba sagunà pakauma si Satanas daw agawen din sa napaliman dan. ");
INSERT INTO bkd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Su binhì ha duun dà nakatanà hu batuwen iyan su mga etaw ha nakapaliman hu lalang hu Dios daw sagunà duminawat taena ha malipayen. ");
INSERT INTO bkd_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ba tumenged ta harì agpanggamut sa pagtuu dan saena harì en agkalugay. Ku makauma sa malegen ha alantusen daw pasipalahan sidan tumenged hu pagdawat dan hu lalang hu Dios sagunà dà sidan ag-endà hu pagtuu. ");
INSERT INTO bkd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Su binhì ha duun nakatanà ku sampiniten iyan su mga etaw ha nakapaliman en hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ba tumenged hu mga kasamukan dan dini ta kalibutan daw hu kabayà dan ha magsapian sidan daw hu kaayat hu madakel ha mga butang, sa lalang hu Dios agkalipatan dan dà aman harì en haena agpamunga diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ba su binhì ha duun nakatanà hu balumbun ha bugtà iyan su mga etaw ha nakapaliman hu lalang hu Dios daw nakasabut taena aman agpamunga. Sa duma agpamunga hu madakel daw sa duma tumanan dà sa bunga dan, sa duma atiyù dà daan sa bunga dan.” ");
INSERT INTO bkd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Uminikagi si Jesus ha “Hurà etaw ha tagtutud hu sulù ha bà din dà agpalangkebi hu bakag daw ku bà din dà ba daan igpadidalem duun hu katri, ba saena iluntud din gayed duun hu ugsakà ha matangkaw. ");
INSERT INTO bkd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sa alan ha iglilung iman makahiwal dà asem ku malugay daw sa harì iman tag-ikagiyen mapaliman dà asem ku malugay. ");
INSERT INTO bkd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Daw inikagiyan daan sidan hi Jesus hu “Panday kaw gayed magpaliliman, ta ku inu kadakel sa ig-ila nuy iyan daan haena kadakel hu ig-ila inyu hu Dios daw labaw pa sa iila din dì hu kinahanglanen nuy. ");
INSERT INTO bkd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa etaw ha amin en kandin mailahan hu tungkay pa gayed madakel, ba saena ha hurà din en hu kandin bisan su iyan-iyan din dà agtimuen pa gayed haena diyà ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Si Jesus uminikagi hu “Sa pagharì hu Dios agkailing taini. Amin etaw ha namegas hu binhì duun hu uma din. ");
INSERT INTO bkd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bisan daleman daw ku aldaw, ku tagtiduga su etaw daw ku pupukaw ba su binhì din agtubù gayed bisan ku harì din agkatun-an ku agkainu-inu ha paagi, ");
INSERT INTO bkd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ta agtubù haena hu kandin dà. Una lumeteb haena dayun mandahun human agpamunga. ");
INSERT INTO bkd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ku mahinug en haena legtayen hu tag-iya duun.” ");
INSERT INTO bkd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Si Jesus minikagi hu “Inu pa sa agpailingan ku hu pagharì hu Dios? ");
INSERT INTO bkd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Agkailing haena hu atiyuay gayed tungkay ha lisu ha impamegas. ");
INSERT INTO bkd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ba ku tumubù en mabuhat ha tungkay kinaadagiyan ha pamulahen daw sa mga panga din mabuhat ha salagà hu mga tagbis.” ");
INSERT INTO bkd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pinaagi hu madakel ha mga pananglitan sa lalang hu Dios inikagi hi Jesus diyà ta kandan sumalà hu agkasabut dan. ");
INSERT INTO bkd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sa alan ha inikagi din kandan pinaagi dà gayed hu mga pananglitan. Ba ku iyan dà sidan hu mga tinun-an din igsaysay din kandan sa kahulugan taena. ");
INSERT INTO bkd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Su mahapun en inikagiyan hi Jesus sa mga tinun-an din ha “Lumayun kuy duun taini ha danaw.” ");
INSERT INTO bkd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aman inawaan dan sa madakel ha mga etaw dayun impalulan hu mga tinun-an si Jesus duun ku barutu. Amin pa daan mga barutu ha namanduma kandan. ");
INSERT INTO bkd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Su taglulan en sidan tigkan namagyu aman nataguan hu wahig haena sa barutu na apit en sidan agkalened. ");
INSERT INTO bkd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ba si Jesus tagtidugahà duun hu alunà diyà ta pulù taena ha barutu. Aman pinukaw hu mga tinun-an din hu kagi dan “Manunudlù, harì ka ba agkasamuk ku mangalemes kuy?” ");
INSERT INTO bkd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Migbangun si Jesus daw baldenga sa kalamag daw mga baled aman sagunà migleneng. ");
INSERT INTO bkd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Inikagiyan din su mga tinun-an din hu “Imbà kaw man agkangahaldek? Harì kaw ba diay agsalig kanak?” ");
INSERT INTO bkd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sa mga tinun-an tungkay gayed nangahaldek daw migpainsaay hu “Inu gid haini ha etawa ha bisan sa kalamag daw mga baled agtuu kandin?” ");
INSERT INTO bkd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Si Jesus daw sa mga tinun-an din nakalayun duun ku danaw ha ubay diyà ta Gadara. ");
INSERT INTO bkd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Su kumawas en si Jesus sinal-aw hu etaw ha inulinan hu busaw ha duun napuun hu panlebengà. ");
INSERT INTO bkd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Duun haena tagtimà hu mga lebeng daw hurà bisan sin-u ha pakabakus kandin bisan pa ku kadinahan, ");
INSERT INTO bkd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ta kapila en bakusa sa mga paa daw sa mga alima din ba bà din dà agpamugtua sa kadina. Hurà gayed bisan sin-u ha pakaegen kandin. ");
INSERT INTO bkd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aldaw daw ku daleman taghipanawà diyà ta panlebengà daw diyà ta bubungan sa tagkulahiay daw tagbugelaen din sa lawa din hu mga batu. ");
INSERT INTO bkd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Su matan-aw din si Jesus minulalaguy haena diyà ta kandin daw luhud duun hu atubangan din. ");
INSERT INTO bkd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nangulahì gayed ha tagyanaen “Jesus sa Batà hu Dios ha iyan Magbabayà hu alan, inu sa labet nu kanak? Aghangyuen ku ikaw ha harì a ikaw pasipalahan.” ");
INSERT INTO bkd_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Naikagi din haena ta ag-ikagiyan hi Jesus ha umawà su busaw. ");
INSERT INTO bkd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dayun ininsaan hi Jesus hu “Sin-u sa ngaran nu?” Tuminubag haena hu “Sa ngaran ku Libu-libuwen tumenged ta madakel kay.” ");
INSERT INTO bkd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Su busaw tagpagayukà diyà ki Jesus ha harì sidan bugawen duun taena ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ubay diyà ta kandan sa balalayan ha amin duun madakel tungkay ha mga babuy ha tagpanuwal. ");
INSERT INTO bkd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pinagayukan hu mga busaw si Jesus ha ipaulì sidan duun ku mga babuy. ");
INSERT INTO bkd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tinugutan din en daan sidan, aman guminuwà su mga busaw duun ku etaw daw namanagù duun ku daruwa ha libu ha mga babuy. Namamulaguy su mga babuy diyà ta alug daw nangakasabay sidan duun ku danaw dayun nangalemes. ");
INSERT INTO bkd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Su mga etaw ha tagbantay ku mga babuy namamulaguy daan payanaen diyà ta banuwa daw duun hu ubayà ha mga lugar daw intultul dan su nahitabù, aman namandiyà sa mga etaw ta ag-ahaen dan su nahitabù. ");
INSERT INTO bkd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Su makauma sidan diyà ki Jesus naahà dan su etaw ha inulinan hu mga busaw su anay ha tagpinuuwà diyà ba maayad en sa henà-henà din daw migpinaksuy en, aman su mga etaw nangahaldek gayed. ");
INSERT INTO bkd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Su nakaahà taena nanunultul dayun ku nainu-inu sa ingkaulii taena ha inulinan hu mga busaw daw sa nahitabù ku mga babuy. ");
INSERT INTO bkd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aman hinangyù hu mga etaw si Jesus ha umawà gayed duun taena ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Su taglulan en si Jesus duun ku barutu huminangyù kandin su naulian ha agduma ngaay. ");
INSERT INTO bkd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ba bà dà inikagiyi hi Jesus ha “Umulì kad duun hu mga kadumahan nu daw itultul sa binuhat hu Dios daw sa kahid-uwi din ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aman huminipanaw su naulian daw panunultul duun hu mga banuwa ta Decapolis ku inu kaadagi sa binuhat kandin hi Jesus. Sa alan ha nakapaliman kandin nangabeleng gayed. ");
INSERT INTO bkd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Su makalikù en si Jesus diyà ta layun inamul-amulan dà paman hu madakel tungkay ha mga etaw. Su diyà pa ta kilid ta danaw ");
INSERT INTO bkd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","amin sabuwa ha punuan duun hu simbahan hu mga Judio ha nakauma ha tagngaranan ki Jairo. Su maahà din si Jesus luminuhud diyà ta atubangan din ");
INSERT INTO bkd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","daw minagayuk ha tagyanaen “Sa laga-laga ku agpatay en aman dumiyà ka daw dampaa ta daw maulian.” ");
INSERT INTO bkd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dayun duminuma kandin si Jesus. Namanduma daan su madakel tungkay ha mga etaw na agkangalipit en sidan. ");
INSERT INTO bkd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amin daan bahi diyà ha sampulù en daw daruwa ha tuig sa kahudhud din. ");
INSERT INTO bkd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naamin en sa salapì din pagbayad hu mga tagpamulung ba bà dà nasì tag-iseg sa dalu din. ");
INSERT INTO bkd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Su mapaliman din sa tultulanen mahitenged ki Jesus uminubay haena diyà ta talikudan din daw ibiti sa pinaksuy taena ");
INSERT INTO bkd_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ta nahenhenaan ku bahi hu “Bisan ku bà a dà makaibit duun hu pinaksuy hi Jesus maulian a gayed.” ");
INSERT INTO bkd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Su maibitan din en sa pinaksuy hi Jesus sagunà uminendà sa kahudhud din daw nagedam din ha naulian en. ");
INSERT INTO bkd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sagunà natun-an hi Jesus ha amin naulian pinaagi hu gahem din, aman sumininalu duun hu mga etaw daw panginginsà hu “Sin-u sa uminibit hu pinaksuy ku?” ");
INSERT INTO bkd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tuminubag sa mga tinun-an din hu “Madakel man ha mga etaw sa agpakalipit ikaw. Imbà ka agpanginginsà ku sin-u sa uminibit ikaw?” ");
INSERT INTO bkd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ba mighelaw-helaw si Jesus ku sin-u sa migbuhat taena. ");
INSERT INTO bkd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Su matun-an ku bahi sa nahitabù kandin luminuhud duun hu atubangan hi Jesus ha taghugdunan hu kahaldek din dayun intultul din sa alan. ");
INSERT INTO bkd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Inikagiyan haena hi Jesus hu “Sa ingkaulii nu iyan sa pagsalig nu kanak. Ulì ka ha malinawen ta naulian kad en hu dalu nu.” ");
INSERT INTO bkd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Su kamulu pa si Jesus tag-ikagi nakauma sa mga etaw ha napuun ta balay hi Jairo su punuan taena ha simbahan ha tagyanaen “Su laga-laga nu minatay en aman harì nud en agsamuka sa Manunudlù.” ");
INSERT INTO bkd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ba saena hurà en bali-baliya hi Jesus ta inikagiyan din en su punuan hu “Harì ka agkasamuk ba bà ka dà salig kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iyan din dà dinuma si Pedro, si Santiago daw sa suled taena ha si Juan. ");
INSERT INTO bkd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Su makauma en sidan diyà ta balay taena ha punuan naahà din sa agkangasamuk daw tag-agalaay hu madaging. ");
INSERT INTO bkd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sumineled si Jesus duun taena ha balay daw uminikagi hu “Imbà kaw agkangasamuk daw tag-agalaay? Saini ha batà hurà patay ba bà dà tagtiduga.” ");
INSERT INTO bkd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ba bà dan dà agkapatawahi si Jesus. Su ipaguwà sidan hi Jesus duun taena ha balay dinuma din sa mga laas taena ha batà daw su tatulu ha tinun-an din, daw sumineled sidan duun ku inugsakan taena ha batà. ");
INSERT INTO bkd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Su makaseled sidan inibitan hi Jesus sa alima ku batà daw ikagiyi hu “Tabita kumi” ha tagkahulugan hu “Sikaw sa batà, bangun kad.” ");
INSERT INTO bkd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Sagunà minangun su batà daw maghiphipanaw, sampulù en daw daruwa sa tuig taena. Duun taena nangabeleng gayed sidan ");
INSERT INTO bkd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ba binalaudan sidan hi Jesus ha harì dan haena itultul duun hu bisan sin-u. Dayun suminugù si Jesus ha ilahan dan su batà hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Si Jesus uminawà diyà daw likù duun hu kandin ha banuwa duma hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Su aldaw hu Sabado migtudlù haena diyà ta simbahan ba nangabeleng sa madakel ha mga etaw ha nakapaliman kandin. Nanginginsà sidan hu “Sin-u gid sa migtudlù kandin daw imbà pakahimu hu mga belenganen? ");
INSERT INTO bkd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kenà ba batà hayana hu panday daw sa inay din iyan man si Maria, sa mga suled din iyan si Santiago daw si Jose, si Judas daw si Simon, daw dini dà daan tagtimà sa mga atebay din?” Tumenged taena hurà dan dawata sa intudlù din. ");
INSERT INTO bkd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Inikagiyan sidan hi Jesus hu “Sa propita agtahuran duun hu bisan hindu ha lugar dì hu kandin ha banuwa daw hu mga kadumahan din.” ");
INSERT INTO bkd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Hurà magpaahà diyà hu mga belenganen ba amin pila dà ha etaw ha agkangadaluwan sa nangaulian su dampaen din sidan. ");
INSERT INTO bkd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nabeleng gayed si Jesus ta harì sidan agtuu. Duminuun si Jesus hu duma ha mga banuwa daw migtudlù diyà. ");
INSERT INTO bkd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Inamul din su sampulù daw daruwa ha tinun-an din, dayun sinugù din sidan hu tigdaruwa daw pinagaheman din sidan hu pagbugaw hu mga busaw ha uminulin duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iyan haini panugun din kandan ha tagyanaen “Ku humipanaw kaw iyan nuy dà uwiten sa sugkud daw harì kaw mag-uwit hu lutù nuy daw hu salapì. ");
INSERT INTO bkd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mabaluy ha magsapatus kaw ba harì kaw mag-uwit hu ilisan nuy. ");
INSERT INTO bkd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bisan sin-u ha tagibalay sa magpaseled inyu duun kaw en magtimà taman ha umawà kaw duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ku makauma kaw duun hu banuwa ba hurà en dumawat inyu daw harì daan sidan magpaliliman inyu awai haena, ba pugpuga nuy sa aliyabuk diyan ta paa nuy ta iyan haena timaan ha silutan gayed sidan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aman namanhipanaw su mga tinun-an hi Jesus daw nanunultul ha kinahanglan gayed ha maghinulsul sa mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Binugaw dan daan sa mga busaw daw hinaplasan dan hu lana sa agkangadaluwan dayun nangaulian. ");
INSERT INTO bkd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Napaliman hi Harì Herodes sa mga tultulanen mahitenged ki Jesus ta nabantug haena duun hu bisan hindu. Sa duma ha mga etaw tag-ikagi hu “Iyan kun haena si Juan ha Bautista ha nabanhaw aman agkahimu din sa mga belenganen.” ");
INSERT INTO bkd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sa duma tag-ikagi daan hu “Iyan si Elias sa propita.” Daw sa duma tag-ikagi hu “Propita haena iling hu sabuwa duun hu nangauna ha mga propita.” ");
INSERT INTO bkd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ba su mapaliman haena hi Herodes uminikagi hu “Nabanhaw gid si Juan sa pinapungulan ku.” ");
INSERT INTO bkd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Si Herodes iyan migsugù su anay ha dakepen si Juan daw bakusa diyà ta purisuwan. Binuhat din haena tumenged ta inasawa hi Herodes si Herodias sa asawa daan hu suled din ha si Felipe ");
INSERT INTO bkd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ba inikagiyan hi Juan si Herodes hu “Nasupak nu gayed sa Kasuguan tumenged ta inasawa nu sa asawa hu suled nu.” ");
INSERT INTO bkd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aman migdumut ki Juan su asawa hi Herodes ha si Herodias daw agkabayaan din en haena agpahimatayi. Ba hurà din haena kahimu ");
INSERT INTO bkd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","tumenged ta si Herodes agkahaldek ki Juan daw pinabantayan din haena ta natun-an din ha matareng si Juan daw suluguen hu Dios. Su mapaliman hi Herodes si Juan nalibeg sa henà-henà din ba agkabayaan din daan tagpalilimani. ");
INSERT INTO bkd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Su aldaw ha agsaulugen hi Harì Herodes sa kabataa kandin ginastuwan din sa mga sinaligan din daw sa mga kapitan hu mga kasundaluwan daw sa tinahud ha mga etaw diyà ta Galilea. Duun taena human nakaahà su asawa din ha iyan si Herodias hu paagi ha mapatay din si Juan. ");
INSERT INTO bkd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Su sumayaw su laga din duun hu atubangan taena ha nangaamul-amul diyà tungkay gayed nabayà-bayaan hi Herodes daw hu mga pinan-imbita din. Aman inikagiyan ku harì su laga hu “Bisan inu sa panayuen nu iila ku gayed ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Daw nanumpà daan hu “Bisan inu sa panayuen nu bisan ku iyan pa sa liwarà taini ha ginharian ku iila ku gayed ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dayun su laga duminiyà ki Inay din daw insai hu “Inu gid sa panayuen ku?” Tuminubag si Inay din hu “Panayua nu sa ulu hi Juan ha Bautista.” ");
INSERT INTO bkd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aman sagunà luminikù su laga duun ku harì daw panayù ha tagyanaen “Agkabayaan ku ha iila nu iman kanak sa ulu hi Juan ha Bautista ha iugsak duun hu lampay.” ");
INSERT INTO bkd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tungkay gayed ngaay naguul su harì, ba tumenged hu panumpà din duun hu atubangan taena ha inimbita din harì din en gayed haena mabalibaran. ");
INSERT INTO bkd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aman sagunà din sinugù sa sabuwa ha sundalu hu pagtimù hu ulu hi Juan. Pinungulan taena ha sundalu si Juan diyà ta purisuwan ");
INSERT INTO bkd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","daw iugsak sa ulu din duun hu lampay. Dayun indawag duun ku laga aman inuwit din haena diyà ki Inay din. ");
INSERT INTO bkd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Su mapaliman haena hu mga sumusunud hi Juan tinimù dan sa lawa din diyà ta purisuwan daw ilebeng. ");
INSERT INTO bkd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Su maisab maamul-amul sa mga apostoles ha sinugù hi Jesus intultul dan diyà ta kandin sa alan ha nangabuhat dan daw sa intudlù dan. ");
INSERT INTO bkd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Madakel tungkay sa mga etaw ha agpamandiyà ta kandan aman si Jesus daw sa mga tinun-an din hurà dan panahun hu pagkaen. Dayun inikagiyan din sidan ha “Dumuun kuy hu pinakabulung-bulung ha lugar ha iyan kuy dà ta daw makahimlay kuy.” ");
INSERT INTO bkd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Namanlulan sidan hu barutu payanaen duun hu pinakabulung-bulung ha lugar ha iyan dà sidan. ");
INSERT INTO bkd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ba madakel ha mga etaw sa nakaahà su umawà sidan daw nakakilala daan kandan aman su mga etaw ha napuun duun hu migkalain-lain ha banuwa namamulaguy daw una sidan duun ku agpayanan-an hay Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Su kumawas en si Jesus duun ku barutu naahà din sa madakel tungkay ha mga etaw aman nahid-uwan din gayed sidan ta agkailing sidan hu mga karniro ha hurà duun magbalantay. Dayun tinudluan din sidan hu madakel ha mga katudluanan. ");
INSERT INTO bkd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Su panday en agkahapun inikagiyan si Jesus hu mga tinun-an din hu “Agkahapun en daw pinakabulung-bulung haini ha lugar. ");
INSERT INTO bkd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sugua nud en sa mga etaw ha mamanduun sidan hu ubayà ha mga banuwa ta daw makapalit sidan hu agkan-en dan.” ");
INSERT INTO bkd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ba bà dà inikagiyi hi Jesus su mga tinun-an din hu “Iyan kaw en mag-ila kandan hu pagkaen.” Tuminubag daan sidan hu “Igpapalit kay ba ikaw hu supas ha igpakaen kandan ha bali hu pila ha gatus?” ");
INSERT INTO bkd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Inikagiyan sidan hi Jesus ha “Susiya nuy ku pila ha buuk sa supas.” Su masusi dan en haena minikagi sidan hu “Lalima dà ha buuk ha supas daw daruwa dà daan ha buuk sa sedà.” ");
INSERT INTO bkd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dayun impapinuu din sidan ha pigpunduk-punduk ta saena sagbeten ha bugtà. ");
INSERT INTO bkd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aman mininuu sidan ha migpunduk-punduk, sa duma tignanggatus daw sa duma tigkalimahan. ");
INSERT INTO bkd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tinimù hi Jesus su lalima ha supas daw su daruwa ha sedà dayun huminangad diyà ta langit daw ampui haena. Su makapenga en mag-ampù pinangebing din su supas daw sugua su mga tinun-an din ha ipakaen haena hu mga etaw. Iling daan ku daruwa ha sedà. ");
INSERT INTO bkd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Su mangabuhì en sidan ");
INSERT INTO bkd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","pinangamul hu mga tinun-an su nasamà taena ha supas daw sedà, saena sampulù pa daw daruwa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lalima ha libu sa kadakelen hu mga maama ha nangakakaen taena ha supas. ");
INSERT INTO bkd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sagunà impalulan hi Jesus sa mga tinun-an din duun hu barutu ta daw makauna en sidan diyà ta Betsaida ha layun taena ha danaw, dayun impaulì din su mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Su maipus en sidan si Jesus duminuun hu buntud hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Su agpanukilem en su barutu ha taglulanan hu mga tinun-an din diyà en ta taliwarà taena ha danaw, ba si Jesus sabubuwa dà duun ku buntud. ");
INSERT INTO bkd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naahà hi Jesus ha taglised gayed su mga tinun-an din hu pagbegsay ta agkatalagbù dan sa kalamag. Su madani en agkaaldaw si Jesus luminupug kandan sa taghipanaw duun taena ha wahig. Aglabayan din en ngaay sidan ");
INSERT INTO bkd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","ba su maahà hu mga tinun-an haena sa bayà-bayà en taghipanaw diyà ta wahig tungkay gayed sidan nangahaldek, aman nakapangulahì sidan ta abi dan ha kalag haena. Ba inikagiyan sidan hi Jesus hu “Pandayai nuy sa gahinawa nuy daw harì kaw agkangahaldek ta iyan a haini.” ");
INSERT INTO bkd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dayun luminulan si Jesus duun ku barutu daw uminendà daan sa kalamag. Nangabeleng gayed sidan ");
INSERT INTO bkd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ta hurà dan kasabut sa belenganen mahitenged hu pagpakaen hu lalima dà ha buuk ha supas taena ha lalima ha libu ha mga etaw ta sa mga henà-henà dan madesen gayed. ");
INSERT INTO bkd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Su makalayun en si Jesus daw sa mga tinun-an din diyà ta Genesaret inhiket dan su barutu. ");
INSERT INTO bkd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Su pagkawas dan duun ku barutu nakilala si Jesus hu mga etaw diyà. ");
INSERT INTO bkd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aman pinan-elegan dan sa mga agkangadaluwan duun hu ubayà dan ha mga banuwa. Bisan hindu duun si Jesus ku agkapaliman dan agpanlantingen dan sa agkangadaluwan daw uwita diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Bisan hindu duun si Jesus agpakapayanaen bisan duun hu plasa agpaman-uwitan dan hu agkangadaluwan. Pinagayukan dan si Jesus ha su agkangadaluwan makaibit ngaay duun hu sagayadan hu pinaksuy din. Sa alan ha nakaibit duun nangaulian gayed. ");
INSERT INTO bkd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sa mga Fariseo daw sa duma ha mga manunudlù hu Kasuguan ha nangapuun ta Jerusalem mig-amul-amul diyà ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naahà dan sa mga tinun-an hi Jesus ha namangaen ba hurà pamangenaw ta mga alima dan. ");
INSERT INTO bkd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sa mga Fariseo daw sa alan ha mga Judio harì gayed agkaen ku harì pa sidan makapangenaw ta alima dan sumalà hu tulumanen dan ha imbilin hu mga gin-apuan dan. ");
INSERT INTO bkd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Bisan ku agkapuun sidan duun hu baligyaanan harì daan sidan agkaen ku harì pa makapangenaw, daw madakel pa gayed ha mga tulumanen sa tagtumanen dan iling hu paghenaw hu mga tasa daw kaldiru daw hu mga talaguay ha tumbaga. ");
INSERT INTO bkd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Aman su mga Fariseo daw sa mga manunudlù hu Kasuguan nanginginsà diyà ki Jesus hu “Imbà supaka hu mga tinun-an nu sa tulumanen ha imbilin kanuy hu mga gin-apuan taw? Ta harì en sidan agpangenaw ta alima dan ku agkaen.” ");
INSERT INTO bkd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ba si Jesus tuminubag hu “Sinyu bà kaw dà gayed tagpasibù-sibù. Laus gayed sa insulat hi Isaias mahitenged inyu ha tagyanaen ‘Saini ha mga etaw tag-ikagi ha tagtahuran a kandan ba sa henà-henà dan hurà dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sa pagsimba dan kanak hurà din pulus daw sa katudluanan dan bà dà tulumanen ha binuhat hu etaw.’ ");
INSERT INTO bkd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Insalikway nuy sa Kasuguan hu Dios daw iyan nuy dà agpangesegan sa mga tulumanen ha kandin dà hu mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Daw inikagiyan pa sidan hi Jesus hu “Harì nuy tagbali-baliyen sa Kasuguan hu Dios ta daw iyan nuy dà matuman sa inyu ha mga tulumanen. ");
INSERT INTO bkd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta si Moises minikagi hu ‘Tahura sa mga laas nuy’ daw ‘Saena ha tagtameyes hu mga laas din kinahanglan ha himatayan.’ ");
INSERT INTO bkd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ba kagi nuy ha agkabaluy ha bà nuy dà ikagiyi sa mga laas nuy hu ‘Taini ngaay sa igbulig ku inyu ba ighalad ku duun hu Dios’ ");
INSERT INTO bkd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","aman harì kaw pakabulig hu mga laas nuy. ");
INSERT INTO bkd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Saena ha binuhat nuy kenà gayed pagtahud hu mga laas. Aman tumenged taena ha mga tulumanen ha igbilin nuy binuhat nuy ha hurà pulus hu Kasuguan hu Dios, daw madakel pa sa tagbuhaten nuy ha agkailing taena.” ");
INSERT INTO bkd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Inamul-amul dà paman hi Jesus sa mga etaw daw ikagiyi sidan hu “Magpaliliman kaw kanak daw sabuta nuy haini. ");
INSERT INTO bkd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Sa igpakasalà hu etaw kenà iyan sa agkangakaen din ba iyan sa agkapuun duun hu gahinawa din. ");
INSERT INTO bkd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Su umawà en si Jesus duun ku mga etaw duminuun hu balay, dayun ininsaan hu mga tinun-an din ku inu sa kahulugan taena. ");
INSERT INTO bkd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Inikagiyan din sidan ha “Hurà kaw ba diay daan makasabut ha sa igpakasalà hu etaw kenà iyan sa agkangakaen din? ");
INSERT INTO bkd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta sa agkangakaen hu etaw harì pakadiyà ta gahinawa din ba diyà dà ta getek din dayun agkaawà dà haena.” Pinaagi taena impadayag hi Jesus ha maayad gayed sa alan ha kalan-enen. ");
INSERT INTO bkd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Dayun inikagiyan din sidan hu “Sa agkapuun duun hu gahinawa hu etaw iyan igpakasalà din. ");
INSERT INTO bkd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta duun hu gahinawa agkapuun sa madaet ha henà-henà, sa pagbuhat hu malaw-ay daw sa pagpanakaw, sa pagpangimatay daw sa pagpanapaw, ");
INSERT INTO bkd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sa pagkaagapan daw sa madaet ha henà-henà duun hu duma, sa paglimbung daw sa pagbuhat hu pinakagalugayhà, sa kasina daw sa pagdaet hu dengeg, sa pagkagalbuwen daw sa pagbinuang. ");
INSERT INTO bkd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Alan haini duun agkangapuun hu gahinawa hu etaw ha igpakasalà din.” ");
INSERT INTO bkd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Uminawà diyà si Jesus daw duminuun hu lugar ha ubay ta Tiro daw ta Sidon dayun sumineled duun hu balay. Harì din ngaay agkabayaan ha matun-an hu mga etaw ha didiyà ba hurà gayed makaheles. ");
INSERT INTO bkd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Amin diyà bahi ha sa laga-laga din inulinan hu busaw. Su mapaliman din sa mahitenged ki Jesus inelegan din daw luhud duun hu atubangan taena. ");
INSERT INTO bkd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Su bahi Griego ha etaw ha imbatà diyà ta Fenice ha sakup ta Siria. Pinagayukan din si Jesus ha bugawen taena su busaw duun ku laga-laga. ");
INSERT INTO bkd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ba uminikagi si Jesus hu “Iyan igpauna igpakaen sa mga batà ta kenà maayad ku agawen sa tagkan-en hu batà daw ipakaen hu mga asu.” ");
INSERT INTO bkd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tuminubag su bahi ha “Ginuu, laus gayed hayana. Ba bisan sa mga asu pakakaen daan hu mumu duun hu lamisa taena ha mga batà.” ");
INSERT INTO bkd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Dayun inikagiyan hi Jesus su bahi ha “Tumenged tayana ha inikagi nu umulì kad ta su busaw uminawà en duun ku batà nu.” ");
INSERT INTO bkd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uminulì haena daw naahà din ha su batà din ha taghidegà duun hu katri inawaan en hu busaw. ");
INSERT INTO bkd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Uminawà si Jesus diyà ta Tiro daw diyà uminagi ta Sidon payanaen duun hu Danaw ta Galilea daw taena ha lugar ta Decapolis. ");
INSERT INTO bkd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amin mga etaw ha mig-uwit diyà ta kandin hu sabuwa ha ngulit daw bengel pa gayed daw pinagayukan dan si Jesus ha dampaen din haena ta daw maulian. ");
INSERT INTO bkd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Su ipadiyù hi Jesus haena duun hu mga etaw daw su iyan dà sidan, tinubluk din sa talinga taena ha bengel. Dayun inileban hi Jesus sa tuldù din daw tubluka daan sa dilà taena ha etaw. ");
INSERT INTO bkd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Huminangad si Jesus diyà ta langit daw gahinawa hu madalem dayun minikagi hu “Ipata” ha tagkahulugan hu “Mapuwaan.” ");
INSERT INTO bkd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Sagunà nakapaliman su bengel daw maayad en daan sa pag-ikagi din. ");
INSERT INTO bkd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Binalaudan hi Jesus sa mga etaw ha harì sidan manunultul duun hu bisan sin-u, ba bà dà sidan nasì nanunultul duun hu bisan hindu. ");
INSERT INTO bkd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nangabeleng gayed sa mga etaw ha tagyanaen “Sa alan ha binuhat din maayad gayed ta bisan sa bengel nakapaliman daw sa ngulit nakaikagi daan.” ");
INSERT INTO bkd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Duun taena ha panahun naamul-amul en paman sa madakel tungkay ha mga etaw. Tumenged ta hurà dan en agkakaen inamul hi Jesus sa mga tinun-an din daw ikagiyi sidan hu ");
INSERT INTO bkd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Agkahid-uwan ku haini sa mga etaw ta tatulu en ha aldaw sa pagduma-dumahà dan kanuy daw hurà dan en gayed agkakaen. ");
INSERT INTO bkd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ku ipaulì ku sidan ha hurà dan makaen kan ku tasien sidan diyà ta dalan ta sa duma kandan madiyù sa ag-ulian din.” ");
INSERT INTO bkd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ba su mga tinun-an tuminubag hu “Hindu kuy duun makatimù hu ipakaen kandan ta pinakabulung-bulung haini ha lugar?” ");
INSERT INTO bkd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ininsaan sidan hi Jesus hu “Pila ha buuk sa supas nuy?” Tuminubag sidan hu “Pitu dà ha buuk.” ");
INSERT INTO bkd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Impapinuu hi Jesus sa mga etaw diyà ta bugtà. Tinimù din su pitu ha supas daw ampui haena. Su makapenga en mag-ampù pinangebing din daw sugua su mga tinun-an din ha ipakaen haena hu mga etaw. Aman binuhat dan haena. ");
INSERT INTO bkd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amin daan atiyuay ha sedà ha pila dà ha buuk daw inampuan din daan haena daw ipan-ila duun ku mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Su mangabuhì en sidan pinangamul hu mga tinun-an su nasamà duun, saena pitu pa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Haepat ha libu sa kadakelen taena ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dayun impaulì hi Jesus su mga etaw daw luminulan hu kandin duun hu barutu duma hu mga tinun-an din payanaen diyà ta Dalmanuta. ");
INSERT INTO bkd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Amin mga Fariseo ha duminiyà ki Jesus hu pagpakigsawalà kandin ta agsulayen dan haena, aman hinangyù dan si Jesus ha ipaahà din kandan sa belenganen ha iyan timaan ha sinugù haena hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Miggahinawa si Jesus hu madalem daw ikagi hu “Imbà kaw tagpan-ahà hu belenganen? Laus gayed sa ag-ikagiyen ku inyu ha iman harì kaw gayed makaahà hu belenganen.” ");
INSERT INTO bkd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dayun inawaan din sidan daw likù duun ku barutu daw luminayun haena. ");
INSERT INTO bkd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sa mga tinun-an hi Jesus nalipat hu pag-uwit hu supas ba amin agà nangkabuuk duun ku barutu. ");
INSERT INTO bkd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Inikagiyan sidan hi Jesus hu “Magbantay kaw hu igpatulin taena ha mga Fariseo daw hi Herodes.” ");
INSERT INTO bkd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dayun miglalang-lalang sa mga tinun-an din hu “Iyan gid ta hurà kuy makauwit hu supas.” ");
INSERT INTO bkd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ba saena natun-an hi Jesus aman inikagiyan din sidan hu “Imbà kaw tag-ikagi ha hurà kaw makag-uwit hu supas? Harì kaw pa ba diay pakasabut? Madesen ba diay gayed sa henà-henà nuy? ");
INSERT INTO bkd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imbà kaw harì pakaindan daw pakapaliman sa amin nuy man ngaay mata daw talinga? Agkalipat kaw ba diay? ");
INSERT INTO bkd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pila man ha ambung sa nasamà taena ha lalima ha buuk ha supas ha impakaen ku lalima ha libu ha mga etaw?” Tuminubag sidan hu “Sampulù daw daruwa ha ambung.” ");
INSERT INTO bkd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Daw ininsaan din pa gayed sidan hu “Pila daan ha ambung sa nasamà taena ha pitu ha supas ha impakaen ku haepat ha libu ha mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tuminubag sidan hu “Pitu daan ha ambung.” Inikagiyan din sidan hu “Harì kaw pa ba diay gihapun agpakasabut?” ");
INSERT INTO bkd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Duminiyà say Jesus ta Betsaida dayun amin buta ha inuwit hu mga etaw diyà ta kandin daw pinagayukan dan ha dampaen din su buta ta daw maulian. ");
INSERT INTO bkd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kinipitan hi Jesus su buta payanaen ta guwà taena ha banuwa. Su maileban din sa mata ku buta daw dampaa haena ininsaan din hu “Amin nu ba agkaahà?” ");
INSERT INTO bkd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mighelaw-helaw su buta daw tuminubag hu “Pakaahà a hu mga etaw ba agkailing sidan hu mga kayu ha taghiphipanaw.” ");
INSERT INTO bkd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Dinampà en paman hi Jesus sa mata ku buta dayun naulian haena daw panday en nakaindan. ");
INSERT INTO bkd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Impaulì hi Jesus daw ikagiyi ha harì en lumikù diyà ta banuwa. ");
INSERT INTO bkd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Si Jesus daw sa mga tinun-an din duminayun duun hu mga banuwa ha ubay ta Cesarea Filipos. Su taghipanaw sidan ininsaan din sidan hu “Sin-u a man duun hu pag-ikagi hu mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tuminubag sidan hu “Sa duma tag-ikagi ha iyan ka kun si Juan ha Bautista, sa duma tag-ikagi daan ha iyan ka kun si Elias, sa duma tag-ikagi ha sabuwa ka kun duun hu mga propita.” ");
INSERT INTO bkd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dayun ininsaan sidan hi Jesus hu “Sinyu, sin-u a man duun hu henà-henà nuy?” Tuminubag si Pedro hu “Iyan ka su Mesiyas.” ");
INSERT INTO bkd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Binalaudan hi Jesus su mga tinun-an din ha harì gayed sidan manunultul duun hu bisan sin-u mahitenged kandin. ");
INSERT INTO bkd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tinudluan hi Jesus sa mga tinun-an din ha kinahanglan ha sa Suled hu Kaet-etawan mag-antus hu madakel ha mga pasipala daw pagtameyesen hu mga magulang daw hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan, daw kinahanglan daan ha pahimatayan dan gayed ba duun hu ikatulu ha aldaw mabanhaw dà. ");
INSERT INTO bkd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mapayag gayed sa pag-ikagi din kandan mahitenged taena, aman inubayan hi Pedro daw baldenga. ");
INSERT INTO bkd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ba uminahà si Jesus duun hu mga tinun-an din, dayun binaldeng din si Pedro ha tagyanaen “Awà ka dini ta kanak, Satanas, ta sa henà-henà nu kenà kandin hu Dios ba kandin dà hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dayun inamul-amul hi Jesus sa mga etaw duma hu mga tinun-an din daw inikagiyan din sidan hu “Bisan sin-u sa agkabayà agsunud kanak kinahanglan ha lipatan din gayed sa kandin ha agkabayaan daw antusen din sa alan ha mga malegen bisan duun hu kamatayen ta daw makasunud kanak. ");
INSERT INTO bkd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak daw tagsangyaw hu Maayad ha Tultulanen bisan duun hu kamatayen mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inu man sa pulus hu etaw ku maangken din sa tibuuk ha kalibutan ba malaag sa kinabuhì din? ");
INSERT INTO bkd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hurà gayed pakapalit hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Duun taini ha panahun nakadiyù en sa etaw duun hu Dios daw tagbuhat en sidan hu mga madaet. Bisan sin-u haena sa ikagayhà din sa pagsunud kanak daw sa mga lalang ku siak sa Suled hu Kaet-etawan ikagayhà ku daan asem haena ku lumikù a dini ha magpangaluanlag iling hu Dios ha Amay ku daw hu mga balinsuguen din.” ");
INSERT INTO bkd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Dayun inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha amin tagtiyadeg inyu dini iman ha harì pa matay na maahà dan en sa gamhanan ha pagharì hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Su maiwas en sa haenem ha aldaw dinuma hi Jesus si Pedro, si Santiago, daw si Juan duun hu matangkaw ha bubungan ha iyan dà sidan. Duun hu atubangan dan tigkan nahalin si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sa pinaksuy din tagpangaluanlag ha hurà en gayed agkailingan taena hu kaputì. ");
INSERT INTO bkd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tigkan daan nakahiwal diyà ta kandan si Elias daw si Moises ha nakiglalang ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dayun minikagi si Pedro diyà ki Jesus hu “Manunudlù, maayad ta dini kay. Buhatan day iman inyu hu tatulu ha lawig ta daw matukid kaw ki Moises daw ki Elias.” ");
INSERT INTO bkd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ba hurà katun-i hi Pedro ku inu sa tag-ikagiyen din ta tungkay gayed sidan nangahaldekan. ");
INSERT INTO bkd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dayun amin gabun ha nakabungkus kandan daw amin lageng ha napuun duun ku gabun ha tagyanaen “Iyan en haini Batà ku ha pinalanggà aman magpaliliman kaw kandin.” ");
INSERT INTO bkd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Su maghelaw-helaw sidan iyan dan dà naahà si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Su tagtubang en sidan diyà ta alug binalaudan sidan hi Jesus ha harì dan itultul haena sa naahà dan duun hu bisan sin-u hangtud ha mabanhaw sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pigtiman-an dan gayed haena daw miglalang-lalang sidan ku inu sa kahulugan taena ha pagkabanhaw hu minatay. ");
INSERT INTO bkd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ininsaan dan si Jesus hu “Imbà sa mga manunudlù hu Kasuguan tag-ikagi ha kinahanglan ha si Elias makauna gayed dini dì hu Mesiyas?” ");
INSERT INTO bkd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Si Jesus tuminubag hu “Laus gayed ha mauna dini si Elias ta daw mapamandayan din sa alan. Hurà nuy ba diay katun-i sa insulat ha lalang hu Dios ha tagyanaen ‘Sa Suled hu Kaet-etawan kinahanglan gayed ha mag-antus hu madakel ha mga pasipala daw pagtameyes.’ ");
INSERT INTO bkd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba ikagiyen ku inyu ha nakadini en si Elias daw pinasipalahan dan haena sumalà hu agkabayaan dan, ta iyan en haena intagnà duun hu insulat ha lalang hu Dios mahitenged kandin.” ");
INSERT INTO bkd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Su makauma say Jesus duun hu duma ha mga tinun-an naahà dan sa madakel tungkay ha mga etaw ha nakalibut ku mga tinun-an daw sa mga manunudlù hu Kasuguan ha nakigsawalà kandan. ");
INSERT INTO bkd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Su maahà hu mga etaw si Jesus nangabeleng gayed sidan aman inagpas dan haena sinal-aw hu pagdawat kandin. ");
INSERT INTO bkd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dayun ininsaan hi Jesus su mga tinun-an din hu “Inu man sa pigsawalaan nuy taena ha mga manunudlù hu Kasuguan?” ");
INSERT INTO bkd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Amin etaw ha tuminubag kandin ha tagyanaen “Manunudlù, inuwit ku su batà ku dini ta ikaw ta inulinan hu busaw ha pakaemaw. ");
INSERT INTO bkd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kada dumiyà sa busaw ta kandin agpakadaghà haini diyà ta bugtà. Tagbulà-bulà sa bàbà din daw tagkangget daan sa mga ngipen din daw agkabidbid. Hinangyù kud sa mga tinun-an nu ha ipaguwà dan su busaw ba hurà dan gayed kahimu.” ");
INSERT INTO bkd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Minikagi si Jesus hu “Sinyu ha mga etaw sa harì agtuu, nalugay en sa pagduma-dumahà taw. Inu pa diay kalugay sa pag-angat ku ha tumuu kaw en kanak? Uwita dini hayana sa batà.” ");
INSERT INTO bkd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aman inuwit dan haena. Su maahà ku busaw si Jesus sagunà din pinasipalahan su batà aman nabidbid daw nakadaghà diyà ta bugtà dayun naligid-ligid ha tagbulà-bulà sa bàbà din. ");
INSERT INTO bkd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ininsaan hi Jesus su amay taena hu “Kan-u dà haini migsugud?” Tuminubag haena ha “Sugud dà hayana su atiyuay pa. ");
INSERT INTO bkd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kapila en hayana ipaagbul hu busaw duun hu hapuy daw duun hu wahig ta daw mapatay din. Ba ku mabaluy nu ngaay kahid-uwi kay daw buligi kay ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Si Jesus minikagi ha “Sumalà ikaw ta sa alan agkahimu hu etaw ha amin din gayed pagtuu.” ");
INSERT INTO bkd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sagunà migpakiluuy su amay taena ha batà hu kagi din “Agtuu a gayed aman buligi a ikaw ha maisaban sa pagtuu ku.” ");
INSERT INTO bkd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Su maahà hi Jesus ha ag-agpas en diyà ta kandan sa madakel tungkay ha mga etaw binaldeng din su busaw ha tagyanaen “Sikaw sa pakaemaw daw pakabengel ha busaw, awà ka diyan daw harì kad en aglikù.” ");
INSERT INTO bkd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nakapangulahì haena sa busaw daw nabidbid daan su batà dayun guminuwà su busaw diyà ta kandin. Su batà bà su minatay en aman abi hu mga etaw ha minatay en labi. ");
INSERT INTO bkd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ba inibitan hi Jesus sa alima taena daw banguna aman nakahitindeg. ");
INSERT INTO bkd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Su makaseled si Jesus duun hu balay ha iyan dà sidan hu mga tinun-an din ininsaan dan haena hu “Imbà day hurà kabugaw su busaw ha uminulin ku batà?” ");
INSERT INTO bkd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tuminubag si Jesus hu “Saena ha kalasi hu busaw mabugaw pinaagi dà gayed hu pag-ampù.” ");
INSERT INTO bkd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Si Jesus daw sa mga tinun-an din duminayun daw diyà sidan nakaagi ta probincia ta Galilea. Harì agkabayaan hi Jesus ha matun-an hu mga etaw ku hindu sidan ");
INSERT INTO bkd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tumenged ta agtudluan din sa mga tinun-an din. Inikagiyan din sidan hu “Siak sa Suled hu Kaet-etawan laus ad en itugyan duun hu aghimatay kanak ba duun hu ikatulu ha aldaw mabanhaw a dà.” ");
INSERT INTO bkd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ba hurà dan kasabut sa kahulugan taena ha inikagi din daw nahaldek daan sidan hu pagpanginginsà kandin mahitenged taena. ");
INSERT INTO bkd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nakauma si Jesus daw sa mga tinun-an din diyà ta Capernaum. Su makaseled en sidan duun hu balay ininsaan hi Jesus su mga tinun-an din hu “Inu man sa pigsawalaan nuy diyà ta dalan?” ");
INSERT INTO bkd_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba hurà en sidan magtubag ta iyan dan pigsawalaan ku sin-u sa labaw kandan. ");
INSERT INTO bkd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mininuu si Jesus daw umawa su sampulù daw daruwa ha tinun-an din daw ikagiyi sidan hu “Bisan sin-u sa agkabayà ha iyan mauna kinahanglan ha magpahudiyan daw suluguen hu alan.” ");
INSERT INTO bkd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dayun tinimù hi Jesus sa sabuwa ha atiyuay ha batà daw gibaha duun hu atubangan ku mga tinun-an din daw ikagiyi sidan hu ");
INSERT INTO bkd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Bisan sin-u sa agdawat hu batà iling taini tumenged kanak agdawat daan kanak, daw saena ha agdawat kanak agdawat daan hu migsugù kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Minikagi si Juan diyà ki Jesus hu “Manunudlù, amin day naahà ha etaw ha migbugaw daan hu mga busaw pinaagi hu ngaran nu aman binaldeng day haena ta kenà taw man duma.” ");
INSERT INTO bkd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ba tuminubag si Jesus hu “Harì nuy haena agbaldenga ta hurà bisan sin-u ha tagbuhat hu belenganen pinaagi hu ngaran ku ha makahimu daan hu pagtameyes kanak. ");
INSERT INTO bkd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta sa etaw ha harì agsupak kanuy duma taw daan. ");
INSERT INTO bkd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa makapainum hu bisan nangkatasa dà ha wahig diyan ta inyu tumenged ta sumusunud kaw kanak balesan gayed haena hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Bisan sin-u haena sa iyan agkahimu ha igpakasalà hu nakatuu en kanak maayad pa ngaay ku ihiket sa lieg din duun hu adagi ha batu daw leneda diyà ta dagat. ");
INSERT INTO bkd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ku iyan igpakasalà nuy sa alima nuy tampeda en haena. Maayad pa ku pungkul kaw ba amin nuy kinabuhì ha hurà din katapusan dì sa daruwa sa alima nuy ba ilambeg kaw diyà ta Inferno ");
INSERT INTO bkd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ha duun sa uled ha harì gayed agpatay daw sa hapuy ha harì en agkapedengan. ");
INSERT INTO bkd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Daw ku iyan igpakasalà nuy sa paa nuy tampeda en haena. Maayad pa ku pungkul kaw ba amin nuy kinabuhì ha hurà din katapusan dì sa daruwa sa paa nuy ba ilambeg kaw diyà ta Inferno ");
INSERT INTO bkd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ha duun sa uled ha harì gayed agpatay daw sa hapuy ha harì en agkapedengan. ");
INSERT INTO bkd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Daw ku iyan daan igpakasalà nuy sa sabuwa ha mata nuy lugita en haena. Maayad pa ha sabuwa dà sa mata nuy ba pagharian kaw hu Dios dì sa daruwa sa mata nuy ba ilambeg kaw diyà ta Inferno ");
INSERT INTO bkd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ha duun sa uled ha harì gayed agpatay daw sa hapuy ha harì en agkapedengan. ");
INSERT INTO bkd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sa alan ha mga etaw sulayan gayed pinaagi hu hapuy iling hu halad ha ag-asinan. ");
INSERT INTO bkd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sa asin maayad, ba ku maawà en sa kapait din hurà din en gayed nanam. Aman siguruwi sa pagdapità hu kada sabuwa inyu ha malinawen gayed.” ");
INSERT INTO bkd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Uminawà diyà si Jesus daw duminayun ta probincia ta Judea daw layun ta Jordan. Inamul-amulan dà paman hu madakel ha mga etaw daw tinudluan din sidan sumalà hu naanadan din. ");
INSERT INTO bkd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Amin daan mga Fariseo ha duminiyà ki Jesus hu pagsulay kandin aman ininsaan dan hu “Intugut ba hu Kasuguan taw ha endaan hu maama sa asawa din?” ");
INSERT INTO bkd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tuminubag si Jesus hu “Inu man sa insugù inyu hi Moises?” ");
INSERT INTO bkd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Uminikagi sidan hu “Intugut hi Moises ha sa maama ku agkabayaan din en ag-endai sa asawa din ilahan din haena hu kasulatan hu pag-endaay dayun human din ipahipanaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ba tuminubag si Jesus hu “Intugut hi Moises sa pag-endaay ta madesen gayed sa henà-henà nuy. ");
INSERT INTO bkd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ba su tanghagaen hu Dios sa alan binuhat din sa maama daw sa bahi. ");
INSERT INTO bkd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iyan haini hinengdan ha ag-awaan hu maama sa mga laas din daw duun en ag-amul hu asawa din ");
INSERT INTO bkd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta nasabuwa en sidan sa daruwa ha etaw. Pinaagi taena kenà en sidan daruwa ba sabuwa dà. ");
INSERT INTO bkd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aman sa sinabuwa en hu Dios harì gayed mabaluy ha ipagsuwayà hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Su makaseled sidan duun hu balay ininsaan si Jesus hu mga tinun-an din mahitenged taena. ");
INSERT INTO bkd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Inikagiyan din sidan hu “Saena ha ag-endaan din sa asawa din daw mangasawa hu lain ha bahi makapanapaw. ");
INSERT INTO bkd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iling daan taena sa bahi ha ag-endaan din sa asawa din daw paasawa hu lain ha maama nakapanapaw daan.” ");
INSERT INTO bkd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Amin mga etaw diyà ha mig-uwit hu mga atiyuay pa ha mga batà ta daw madampà hi Jesus, ba binaldeng sidan hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Su matun-an haena hi Jesus napauk gayed daw inikagiyan din sidan hu “Ipaubay dini ta kanak sa mga batà daw harì nuy sidan agbaldenga, ta sa mga etaw ha iling taini ha mga batà iyan tagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Laus gayed sa ag-ikagiyen ku inyu ha sa harì agkabayà ha pagharian hu Dios iling hu pagtuu taini ha batà saena harì pagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dayun sinapipi din su mga batà daw dinampà din sidan daw pigpanalanginan din. ");
INSERT INTO bkd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Su aghipanaw en si Jesus amin etaw ha minulalaguy diyà ta kandin daw luhud duun hu atubangan din. Nanginginsà haena hu “Maayad ha Manunudlù, inu man sa kinahanglan ha buhaten ku ta daw mailahan a hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tuminubag si Jesus hu “Imbà a ikaw umawa ha maayad? Hurà gayed maayad ba iyan dà sa Dios. ");
INSERT INTO bkd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Natun-an nud sa Kasuguan ha tagyanaen ‘Harì ka mangimatay daw harì ka manapaw, harì ka daan manakaw daw harì ka magbutang-butang, harì ka daan manlimbung daw tahura sa mga laas nu.’” ");
INSERT INTO bkd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ba minikagi haena sa etaw hu “Manunudlù, binuhat kud en hayana sugud dà su atiyuay a pa.” ");
INSERT INTO bkd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Uminahà si Jesus diyà ta kandin ta agkahid-uwan din haena. Inikagiyan din hu “Amin pa gayed sabuwa ha hurà nu kabuhat. Ipamaligyà sa alan ha mga butang nu dayun sa halin taena ipan-ila duun hu mga makaluluuy ta daw magsapian ka diyà ta langit. Ku mapengahan nu haini lumikù ka dini daw sunud ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Su mapaliman ku etaw su inikagi hi Jesus linuyahan haena. Dayun huminipanaw ha naguul gayed ta madakel tungkay sa mga katigayunan din. ");
INSERT INTO bkd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mighelaw-helaw si Jesus daw ikagiyi sa mga tinun-an din hu “Malegen tungkay ha maharian hu Dios sa etaw ha sapian.” ");
INSERT INTO bkd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sa mga tinun-an nangabeleng gayed taena ha inikagi din. Ba si Jesus uminikagi dà paman hu “Malegen gayed tungkay ha maharian hu Dios sa etaw ha agsalig hu mga katigayunan din. ");
INSERT INTO bkd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Malumu pa hu kamilyo sa paglusut duun hu pusu hu dagum dì hu sapian ha maharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ayuwà pa nangabeleng sa mga tinun-an din aman migpainsaay sidan hu “Sin-u dà diay sa mailahan hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Uminahà diyà ta kandan si Jesus daw kagi din “Saena harì gayed agkabaluy hu etaw ba sa alan agkahimu hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dayun minikagi si Pedro hu “Inawaan day sa alan ta daw makasunud kay ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Si Jesus tuminubag hu “Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa inawaan din sa mga bugtà din daw sa balay din, sa mga suled din, sa mga laas din daw sa mga batà din tumenged kanak daw hu pagsangyaw hu Maayad ha Tultulanen, ");
INSERT INTO bkd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bisan iman ha panahun makadawat en gayed hu madakel pa ha mga bugtà daw balay, mga suled, mga laas daw mga batà dì taena ha inawaan din, daw amin din daan kinabuhì ha hurà din katapusan ba makaagi daan hu mga pasipala. ");
INSERT INTO bkd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Madakel iman ha mga etaw sa tagkauna ba iyan diay mahudiyan, daw amin daan etaw ha hudiyan iman ba iyan diay mauna.” ");
INSERT INTO bkd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Su diyà en say Jesus ta dalan payanaen ta Jerusalem uminuna si Jesus, aman sa mga tinun-an din nangabeleng daw sa duma ha mga etaw ha taglupug kandan nangahaldek daan. Tinabis dà paman hi Jesus su sampulù daw daruwa ha tinun-an din daw ikagiyi hu maul-ulahan din ");
INSERT INTO bkd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ha tagyanaen “Tagdiyà kuy en iman ta Jerusalem. Siak sa Suled hu Kaet-etawan itugyan a duun hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan. Hukuman a kandan hu kamatayen daw itugyan a daan kandan duun hu mga etaw ha kenà Judio ");
INSERT INTO bkd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ha iyan magtameyes kanak. Ileban a daan kandan daw lagkutan a, dayun himatayan a kandan ba duun hu ikatulu ha aldaw mabanhaw a dà.” ");
INSERT INTO bkd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Si Santiago daw si Juan sa mga batà hi Zebedeo duminiyà ki Jesus daw ikagi hu “Manunudlù, amin day ngaay aghangyuen diyan ta ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ininsaan sidan hi Jesus hu “Inu man sa agkabayaan nuy ha buhaten ku diyan ta inyu?” ");
INSERT INTO bkd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tuminubag sidan hu “Sa aghangyuen day ikaw iyan sa ku magharì ka asem iyan kay ipapinuu duun hu abay nu, sa sabuwa diyan ta kawanan nu daw sa sabuwa diyan ta gibang nu.” ");
INSERT INTO bkd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ba inikagiyan sidan hi Jesus hu “Harì nuy gayed agkatun-an sa taghangyuen nuy. Maantus nuy ba sa mga malegen ha maul-ulahan ha madani en makauma dini ta kanak?” ");
INSERT INTO bkd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tuminubag sidan hu “Hee, maantus day.” Inikagiyan sidan hi Jesus hu “Maagiyan nuy gayed sa malegen ha maul-ulahan iling hu kanak ");
INSERT INTO bkd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ba kenà a iyan tagbayà ku sin-u sa makapinuu dini ta kawanan ku daw ta gibang ku ta iyan tagbayà taena sa Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Su mapaliman haena ku sampulù ha mga duma dan ha tinun-an napaukan dan gayed si Santiago daw si Juan. ");
INSERT INTO bkd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dayun inamul hi Jesus su mga tinun-an din daw ikagiyi hu “Natun-an nuy en ha sa mga punuan hu kenà mga Judio iyan tagbayà hu mga sakup dan daw sa mga sinaligan dan iyan tagsugù hu mga ginsakupan dan. ");
INSERT INTO bkd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ba saena harì mahimu diyan ta inyu ta ku amin inyu agkabayà ha iyan labaw kinahanglan ha iyan mabuhat ha suluguen nuy, ");
INSERT INTO bkd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","daw ku amin inyu agkabayà gayed ha iyan tungkay labaw kinahanglan ha iyan daan ulipen hu alan. ");
INSERT INTO bkd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bisan siak sa Suled hu Kaet-etawan kenà ku iyan indini ta kalibutan ta daw mabuligan a hu mga etaw, ba sa pagdini ku iyan sa pagbulig daw sa pagpakamatay ta daw malibri sa kaet-etawan ha naulipen hu salà.” ");
INSERT INTO bkd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nakauma say Jesus diyà ta Jerico. Su dumayun en si Jesus duma hu mga tinun-an din daw hu madakel tungkay ha mga etaw amin buta ha tagpinuu diyà ta kilid ta dalan ha tagpakilimus ha iyan si Bartimeo ha batà hi Timeo. ");
INSERT INTO bkd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Su mapaliman din ha si Jesus sa taga-Nazaret aglabay en diyà ta kandin nangulahì haena hu “Jesus ha Kaliwat hi David, kahid-uwi a ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Binaldeng haena hu mga etaw ta igpahagteng dan ngaay, ba bà dà nasì kadaging sa pangulahì din ha tagyanaen “Sikaw sa Kaliwat hi David, kahid-uwi a man ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aman tuminaleen en si Jesus daw ipaumaw su buta. Inumaw dan haena daw ikagiyi hu “Pandayai nu sa gahinawa nu. Hitindeg ka ta inumaw ka hi Jesus.” ");
INSERT INTO bkd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dayun inawà din su in-apid ha pinaksuy din daw agpas diyà ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ininsaan hi Jesus su buta hu “Inu man sa agkabayaan nu ha buhaten ku diyan ta ikaw?” Su buta tuminubag hu “Manunudlù, makaindan a ngaay.” ");
INSERT INTO bkd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Inikagiyan haena hi Jesus hu “Hipanaw ka ta sa ingkaulii nu iyan sa pagsalig nu kanak.” Sagunà nakaindan su buta daw duma ki Jesus diyà ta dalan. ");
INSERT INTO bkd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nakauma en si Jesus daw sa mga tinun-an din diyà ta Betpage daw ta Betania diyà ta Buntud ta Olibo saena ubay en diyà ta Jerusalem. Dayun sinugù hi Jesus sa daruwa ha tinun-an din ");
INSERT INTO bkd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ha tagyanaen “Umuna kaw en diyà tayà ha banuwa. Ku makauma kaw diyà maahà nuy sa intagkes ha nati hu asno ha harì pa gayed agkalulanan. Hukada nuy haena daw tuyuka dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ku amin manginginsà inyu hu ‘Imbà nuy hayana agtimua?’ ikagiyi nuy hu ‘Agkinahanglanen haini hu Ginuu ba laus din dà daan ig-ulì.’” ");
INSERT INTO bkd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aman huminipanaw haena su mga sinugù dayun naahà dan sa nati hu asno ha intagkes duun hu pultahan. Su aghukaden dan en haena ");
INSERT INTO bkd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","amin tagtiyadeg diyà ha minikagi hu “Inu hayana sa agbuhaten nuy? Imbà nuy aghukada sa hiket tayana ha nati hu asno?” ");
INSERT INTO bkd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tinubag dan haena sumalà hu inikagi kandan hi Jesus aman intugut haena kandan. ");
INSERT INTO bkd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tinuyuk dan su nati hu asno diyà ki Jesus daw binalhenan dan haena hu mga bisti dan dayun luminulan si Jesus duun. ");
INSERT INTO bkd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Madakel ha mga etaw sa migbuklad hu mga bisti dan duun ku dalan ha ag-agiyan hi Jesus daw sa duma migbuklad hu mga palwa ha natimù dan duun hu mga uma. ");
INSERT INTO bkd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sa madakel ha mga etaw ha nakalibut diyà ki Jesus nangulahì ha tagyanaen “Dayeen gayed sa Dios. Panalanginan haini sa nakauma ha sinugù hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Panalanginan sa Harì ha Kaliwat hi David ha nakauma iman dini. Dayeen gayed sa Dios ha diyà ta langit.” ");
INSERT INTO bkd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Su makauma si Jesus diyà ta Jerusalem sumineled haena diyà ta Timplo. Inahà din sa alan diyà, ba tumenged ta agkahapun en luminikù dà diyà ta Betania duma taena ha sampulù daw daruwa ha tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Su maisab ha aldaw ha taghipanaw say Jesus sa napuun diyà ta Betania agkauhul gayed si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Diyà ta kadiyuan naahà din sa kayu ha igira ha malabung gayed aman inahà din ku amin ba taena bunga. Ba su makaubay en hurà din naahà ha bunga ta kenà pa haena tingpamunga. ");
INSERT INTO bkd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dayun inikagiyan hi Jesus su kayu ha “Sugud iman hurà en gayed makakaen hu bunga nu.” Saena napaliman daan hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Su makauma say Jesus diyà ta Jerusalem sumineled haena diyà ta Timplo daw pan-abuga sa mga tagbabaligyà daw sa tagpamalit duun. Pinamantang din sa mga lamisahan taena ha tagpamaylu hu salapì daw sa mga pinun-ayà hu tagbabaligyà hu mga salapati, ");
INSERT INTO bkd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","daw hurà din gayed tinugutan ha mag-uwit hu bisan inu duun taena ha Timplo. ");
INSERT INTO bkd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dayun tinudluan din sidan ha tagyanaen “Hurà ba nakasulat ha lalang hu Dios ha tagyanaen ‘Sa Timplo ku iyan alampuanan hu kaet-etawan ha nangapuun duun hu bisan hindu.’ Ba saini binuhat nuy ha kampo hu mga tulisan.” ");
INSERT INTO bkd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Su mapaliman haena hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan nan-ahà sidan hu paagi ha mapatay dan si Jesus ta agkahaldekan dan haena tumenged ta nangabeleng gayed sa kaet-etawan hu katudluanan din. ");
INSERT INTO bkd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Su agkahapun en uminawà say Jesus diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Su maselem en ha taghipanaw say Jesus diyà ta dalan naahà dan su kayu ha igira ha nagangu en bisan sa gamut din. ");
INSERT INTO bkd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nahenhenaan hi Pedro haena aman inikagiyan din si Jesus hu “Manunudlù, ahaa nu hayana sa kayu ha tinungayawan nu ta nagangu en labi.” ");
INSERT INTO bkd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Si Jesus tuminubag hu “Salig kaw duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa umikagi tayana ha bubungan hu ‘Agbul ka diyà ta dagat’ daw harì magduwa-duwa saena mahimu gayed. ");
INSERT INTO bkd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aman ag-ikagiyen ku inyu ha ku manayù kaw duun hu Dios tuuwi haena ha madawat nuy ta ig-ila din gayed inyu. ");
INSERT INTO bkd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ku mag-ampù kaw daw amin nakasalà diyan ta inyu pasayluwen nuy haena ta daw mapasaylu daan hu Amay nuy diyà ta langit sa inyu ha mga salà.” ");
INSERT INTO bkd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ba ku harì nuy pasayluwen harì daan pasayluwen hu Dios ha Amay nuy sa inyu ha mga salà. ");
INSERT INTO bkd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nakauma dà paman say Jesus diyà ta Jerusalem. Su taghiphipanaw si Jesus diyà ta Timplo duminiyà ta kandin sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan daw sa mga magulang. ");
INSERT INTO bkd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ininsaan dan si Jesus hu “Inu sa katenged nu daw sin-u sa mig-ila ikaw hu kagahem hu pagbuhat taena?” ");
INSERT INTO bkd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ba tinubag sidan hi Jesus hu “Ag-insaan ku daan inyu. Ku matubag nuy haini ikagiyen ku inyu sa katenged ku hu pagbuhat taena. ");
INSERT INTO bkd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sin-u man sa mig-ila ki Juan ha Bautista hu kagahem hu pagbautismu? Iyan ba sa Dios daw ku etaw dà ba?” ");
INSERT INTO bkd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Miglalang-lalang sidan ha “Ku kagi taw iman ha iyan sa Dios insaan kuy kandin ku imbà hurà taw tuuwi si Juan. ");
INSERT INTO bkd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ba ku ikagiyen taw daan ha etaw dà mapaukan kuy hu mga etaw ha tuminuu gayed ha propita si Juan.” ");
INSERT INTO bkd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aman iyan dà tubag dan diyà ki Jesus sa “Hanaw ta.” Inikagiyan sidan hi Jesus ha “Ku iyan hayana harì ku daan inyu ag-ikagiyen ku sin-u sa mig-ila kanak hu kagahem hu pagbuhat taena.” ");
INSERT INTO bkd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Minikagi si Jesus pinaagi hu mga pananglitan ha tagyanaen “Amin etaw ha amin din uma ha pinamulahan din hu paras. Linibut din haena hu alad daw migbangbang hu pangemesà hu mga bunga daw miglawig daan hu timaay taena ha mga tag-alima duun. Dayun pinaalimahan din haena daw pahiphipanaw duun hu madiyù ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Su bungahan en su paras sinugù din sa sabuwa ha suluguen din duun ku mga sinaligan din ha tag-alima hu parasan ta daw matimù taena sa kandin ha bahin. ");
INSERT INTO bkd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ba su sinugù din bà dà dinakep ku mga sinaligan daw pagbunalai dayun impaulì ha hurà din uwiten. ");
INSERT INTO bkd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aman sinugù dà paman sa lain ha suluguen ba bà dan dà daan binunali sa ulu taena daw pagagayhai. ");
INSERT INTO bkd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dayun impalupug ku tag-iya ku uma sa ikatulu ha suluguen ba bà dan dà daan haena hinimatayi. Amin pa gayed madakel ha sinugù din, sa duma duun binunalan dan daw sa duma hinimatayan dan. ");
INSERT INTO bkd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Sa nasamà ha agkasugù iyan dà su pinalanggà din ha batà. Aman sinugù din haena diyà ta nakahenà-henà hu ‘Tahuran dan gayed haini tumenged ta batà ku.’ ");
INSERT INTO bkd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ba su maahà haena ku mga sinaligan miglalang-lalang sidan hu ‘Iyan en haini batà hu tag-iya. Himatayan taw ta daw maangken taw en haini sa parasan dan.’ ");
INSERT INTO bkd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aman inuwit dan daw himatayi dayun inlambeg dan diyà ta guwà taena ha parasan. ");
INSERT INTO bkd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Inu man sa buhaten taena ha tag-iya duun ku mga sinaligan din? Elegan din gayed sidan daw panhimatayi daan dayun su parasan paalimahan din hu lain ha mga sinaligan. ");
INSERT INTO bkd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Hurà nuy ba kabasa sa lalang hu Dios ha tagyanaen ‘Sa batu ha bà dà inlambeg ta abi hu mga tagbalay ha hurà din pulus iyan diay mahinengdanen ta iyan man pakapalig-en hu balay. ");
INSERT INTO bkd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Belenganen gayed haena ta iyan sa Dios migbuhat duun.’” ");
INSERT INTO bkd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dayun nan-ahà sa mga punuan hu paagi hu pagdakep ki Jesus ta natun-an dan ha iyan en sidan tagsubayen ku pananglitan. Ba nahaldek daan sidan hu kaet-etawan aman inawaan dan haena. ");
INSERT INTO bkd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Amin mga Fariseo daw mga sakup hi Herodes ha sinugù diyà ki Jesus hu pagpanginginsà kandin ta daw amin maikagi hi Jesus ha ikasumbung dan kandin. ");
INSERT INTO bkd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Su makauma su mga sinugù inikagiyan dan si Jesus hu “Manunudlù, natun-an day ha matareng ka gayed. Harì ka agkauwit hu mga henà-henà hu mga etaw ta hurà nu kandan igpalabi daw iyan nu dà tigtudlù sa kamatuuran mahitenged hu Dios. Aman ikagiyi kay ikaw ku igtugut ba hu Kasuguan taw ha magbayad kuy hu buhis diyà ki Cesar.” ");
INSERT INTO bkd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ba natun-an hi Jesus ha bà dà sidan tagpasibù-sibù aman inikagiyan din sidan hu “Imbà a inyu tagsulay-sulaya? Ipaahà kanak sa salapì ha igbayad nuy hu buhis.” ");
INSERT INTO bkd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inuwit dan su salapì dayun ininsaan sidan hi Jesus hu “Sin-u ha weleng daw ngaran sa nakaugsak duun taini ha salapì?” Tuminubag sidan hu “Iyan si Cesar sa Harì ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Inikagiyan sidan hi Jesus ha “Ku kandin diay haini kinahanglan ha iila nuy diyà ki Cesar sa buhis daw iila nuy daan duun hu Dios sa kandin ha bahin.” Su mapaliman dan haena tungkay sidan nangabeleng. ");
INSERT INTO bkd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Amin mga Saduceo ha duminiyà ki Jesus. Saini ha mga etawa harì agtuu ha mabanhaw sa etaw aman inikagiyan dan si Jesus hu ");
INSERT INTO bkd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Manunudlù, sa Kasuguan hi Moises tagyanaen ‘Ku matay sa maama ba hurà pa sidan pamatà ki Asawa din kinahanglan ha sa suled taena ha maama asawahen din su bahi ha nabalu ta daw ku magbatà sidan kaliwat pa haena ku suled din ha minatay.’ ");
INSERT INTO bkd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Su anay amin dini pitu ha migsusuled ha pulus maama. Sa kamagulangan kandan nangasawa ba hurà pa sidan pamatà na minatay en. ");
INSERT INTO bkd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Aman inasawa ku manghud din su bahi ha nabalu. Ba saena ha maama hurà en daan sidan pamatà na minatay en daan hangtud ha su migsusuled alan nakaasawa ku bahi ba alan daan minatay. Dayun minatay daan su bahi. ");
INSERT INTO bkd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ku mabanhaw asem sa nangamatay sin-u man sa laus ha asawa ku bahi sa pulus en man nakaasawa kandin su pitu ha migsusuled?” ");
INSERT INTO bkd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ba inikagiyan sidan hi Jesus hu “Maal en sa tag-ikagiyen nuy tumenged ta hurà nuy katun-i sa insulat ha lalang hu Dios daw sa pagkagamhanan din. ");
INSERT INTO bkd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Asem ku mabanhaw en sa mga nangamatay agkailing sidan hu mga balinsuguen hu Dios diyà ta langit ha harì en agpangasawa. ");
INSERT INTO bkd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mahitenged hu pagkabanhaw taena ha mga minatay hurà nuy ba diay kabasa sa insulat hi Moises ha inikagi kandin hu Dios duun taena ha tagkalegdeg ha sampinit ha tagyanaen ‘Iyan a Dios ha tagsimbahen hi Abraham daw hi Isaac daw hi Jacob.’ ");
INSERT INTO bkd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kenà haena Dios hu mga minatay ba Dios hu mga bubuhay, aman maal en gayed sa tag-ikagiyen nuy.” ");
INSERT INTO bkd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Amin manunudlù hu Kasuguan ha nakapaliman ha tagsawalà si Jesus daw sa mga Saduceo. Su matun-an din ha maayad sa intubag hi Jesus diyà ta kandan nanginginsà daan haena hu “Inu man sa labaw gayed duun hu alan ha Kasuguan?” ");
INSERT INTO bkd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Si Jesus tuminubag hu “Sa labaw ha sugù iyan haini ‘Sinyu sa mga kaliwatan hi Israel, magpaliliman kaw. Sabuwa dà gayed sa Magbabayà ha iyan Dios taw ");
INSERT INTO bkd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","aman palanggaa nuy gayed sa Dios ha Magbabayà nuy.’ ");
INSERT INTO bkd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sa ikaduwa iyan haini ‘Palanggaa sa mga duma nuy iling hu pagpalanggà nuy hu kaugalingen nuy.’ Hurà en gayed labaw pa ha sugù dì taini.” ");
INSERT INTO bkd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Su manunudlù hu Kasuguan tuminubag hu “Laus gayed sa inikagi nu ha sabuwa dà sa Magbabayà ha iyan Dios taw daw hurà en gayed lain. ");
INSERT INTO bkd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sa pagpalanggà taw hu Dios daw sa pagpalanggà taw hu mga duma taw iling hu pagpalanggà taw hu kaugalingen taw labaw pa dì hu nasunug ha mananap ha inhalad daw hu duma pa.” ");
INSERT INTO bkd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Su mapaliman hi Jesus ha maayad gayed sa tubag din inikagiyan din haena hu “Apit kad en tagharii hu Dios.” Sugud taena hurà en kandan uminamel hu pagpanginginsà kandin. ");
INSERT INTO bkd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Su tagtudlù pa si Jesus duun ku Timplo nanginginsà hu “Imbà agkaikagi hu mga manunudlù hu Kasuguan ha su Mesiyas iyan kaliwat hi David? ");
INSERT INTO bkd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ta si David su ulinan hu Balaan ha Ispiritu nakaikagi ha tagyanaen ‘Inikagiyan hu Dios sa Ginuu ku ha “Dini ka pinuu ta kawanan ku hangtud ha madaeg ku sa mga kuntra nu.”’ ");
INSERT INTO bkd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ku inikagi haena hi David ha Ginuu din su Mesiyas, imbà kabuhat din dà paman haena ha kaliwat?” Sa madakel ha mga etaw malipayen gayed hu pagpaliliman kandin. ");
INSERT INTO bkd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Migtudlù si Jesus ha tagyanaen “Magbantay kaw taena ha mga manunudlù hu Kasuguan. Tagpaaluahà sidan pinaagi hu mga pinaksuy dan ha magayad daw agkalipay sidan ku tahuran hu mga etaw duun hu baligyaanan. ");
INSERT INTO bkd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ku diyà sidan ta simbahan iyan dan agkabayaan sa madagway ha pinun-ayà, daw ku duun sidan hu taggastu agkabayaan dan daan ha iyan sidan una igpakaen. ");
INSERT INTO bkd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Aglupigan dan daan sa mga balu ha bahi daw ag-agawen dan sa mga katigayunan taena, dayun agtambunan dan sa madaet ha mga buhat dan pinaagi hu pag-ampù ha malugayad. Tumenged taini adagi gayed sa silut kandan.” ");
INSERT INTO bkd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Su tagpinuu si Jesus atbang taena ha talaguay hu halad ha salapì diyà ta Timplo pigbantayan din sa kaet-etawan ha mighalad duun. Amin madakel ha mga sapian ha mighalad hu madakel ha salapì. ");
INSERT INTO bkd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ba amin daan naahà din ha balu ha bahi ha makaluluuy saena mighulug hu halad din ba daruwa dà ha sintabos. ");
INSERT INTO bkd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Inamul hi Jesus sa mga tinun-an din daw ikagiyi sidan hu “Laus gayed sa ag-ikagiyen ku inyu ha sa in-ila taini ha balu ha bahi labaw pa dì hu inhalad taena ha duma. ");
INSERT INTO bkd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta sa inhalad dan subra dà hu mga katigayunan dan, ba saini ha balu bisan ku tungkay makaluluuy ba in-ila din sa iyan-iyan dà ha salapì din.” ");
INSERT INTO bkd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Su gumuwà en si Jesus duun taena ha Timplo inikagiyan hu sabuwa ha tinun-an din hu “Manunudlù, ahaa nu haini sa Timplo ha binuhat pinaagi hu mga madagway ha batu daw madagway daan sa mga balay dini ta lagidlidan din.” ");
INSERT INTO bkd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ba tuminubag si Jesus ha “Sulsuliya nuy haini daw timan-i nuy ha sa imbalay taini ha mga batu hurà gayed duun sabuwa ha harì matempag.” ");
INSERT INTO bkd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Su tagpinuu si Jesus diyà ta Buntud ta Olibo ha atbang taena ha Timplo uminubay diyà ta kandin si Pedro daw si Santiago, si Juan daw si Andres ha iyan dà sidan, daw nanginginsà sidan hu ");
INSERT INTO bkd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ikagiyi kay ku kan-u haena agkatuman daw inu sa mga timaan ha madani en haena matuman.” ");
INSERT INTO bkd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Inikagiyan sidan hi Jesus hu “Magbantay kaw ta daw harì kaw malimbungan hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Madakel asem sa makadini daw mag-ikagi hu ‘Iyan a su Mesiyas’ dayun madakel gayed ha mga etaw sa malimbungan dan. ");
INSERT INTO bkd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ku mapaliman nuy asem sa mga gira daw sa mga agpakauma ha gira harì kaw agkasamuk. Kinahanglan ha mahitabù haena ba kenà pa iyan katapusan hu panahun. ");
INSERT INTO bkd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta magsasabà sa mga nasud daw sa mga ginharian, maglinug hu mabis-ay duun hu migkalain-lain ha lugar daw makauma daan sa kauhul. Saini ha mga hitabù puunaan pa hu mga kasakitan. Panga hu Kayu ha Igira ");
INSERT INTO bkd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Aman kinahanglan ha magbantay kaw gayed ta itugyan kaw asem duun hu maghukum inyu daw lagkutan kaw pa gayed duun hu mga simbahan. Ipaatubang kaw daan kandan duun hu mga gubernador daw mga harì tumenged hu pagtuu nuy kanak, ba iyan haena paagi ha matultul a inyu diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sa Maayad ha Tultulanen kinahanglan ha isangyaw duun hu alan ha kaet-etawan dini ta kalibutan dayun makauma sa katapusan hu panahun. ");
INSERT INTO bkd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ku dakepen kaw daw ipaatubang kaw duun hu hukmanan harì kaw agkasamuk ku inu sa ipanubag nuy. Duun taena ha panahun sa Dios iyan magtudlù inyu ta sa ag-ikagiyen nuy kenà inyu ha lalang ba kandin en hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Duun taena ha panahun itugyan hu etaw sa suled din ta daw mapatay daw itugyan daan hu amay sa batà din. Sa mga batà sumukul hu mga laas dan daw pahimatayan dan daan. ");
INSERT INTO bkd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kuntrahen kaw hu alan ha kaet-etawan tumenged kanak ba sa harì umendà hu pagtuu hangtud hu katapusan mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Maahà nuy daan asem sa mahugaw gayed ha humitindeg duun hu balaan ha lugar. Saena ha pakabasa taini ha tagnà sabuten din gayed. Duun asem taena ha panahun sa mga etaw diyà ta Judea mamamulaguy duun hu bubungan. ");
INSERT INTO bkd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sa diyà ta atep hu balay dan harì en lumugnà pa hu pagtimù hu mga butang dan. ");
INSERT INTO bkd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sa diyà ta uma harì en daan umulì hu pagtimù hu ig-apid dan ha pinaksuy. ");
INSERT INTO bkd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pinakahaluhid-u gayed sa agkangabedes daw saena ha amin din pa igpasusu duun taena ha panahun. ");
INSERT INTO bkd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mag-ampù kaw ha harì haena makatagaed hu lendeng ");
INSERT INTO bkd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ta saena ha mga pinakahaluhaldek ha kasamukan labaw pa dì hu nangahitabù en sugud dà su tanghagaen hu Dios sa kalibutan daw hurà en daan isab mahitabù ha iling taena. ");
INSERT INTO bkd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ku harì pababaan hu Dios haena ha panahun maamin matay sa mga etaw. Ba tumenged hu mga pinilì din pababaan din dà haena. ");
INSERT INTO bkd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Duun taena ha panahun ku amin umikagi diyan ta inyu hu ‘Ahà kaw, taini en su Mesiyas’ daw ‘Diyà en’ harì kaw gayed taena agtuu. ");
INSERT INTO bkd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta makauma sa mga biduen ha mag-ikagi hu ‘Iyan ad en su Mesiyas’ daw ‘Iyan ad propita’ daw magpaahà daan sidan hu mga timaan daw belenganen ta daw bisan sa mga pinilì hu Dios ku mahimu malimbungan dan pa gayed. ");
INSERT INTO bkd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aman magbantay kaw gayed ta daan kud en haini inikagi inyu. ");
INSERT INTO bkd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ku maiwas en haena sa pinakahaluhaldek ha kasamukan sumukilem sa aldaw daw harì en daan umanlag sa bulan, ");
INSERT INTO bkd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mangahulug daan sa mga bituen ta agkahuyung sa kalangitan. ");
INSERT INTO bkd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Duun asem taena siak sa Suled hu Kaet-etawan maahà a ha magbulus diyà tayà ha gabunan ha magpangaluanlag daw maahà daan sa pagkagamhanan ku. ");
INSERT INTO bkd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Suguen ku sa mga balinsuguen hu Dios ha amulen dan sa mga pinilì ku ha dini agkangapuun ta tibuuk ha kalibutan. ");
INSERT INTO bkd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Timan-i nuy haini sa igtudlù ku inyu mahitenged hu kayu ha igira. Ku manalingsing en haena daw lumabung en matun-an nuy ha madani en sa gulabung. ");
INSERT INTO bkd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iling daan taena ku maahà nuy asem ha matuman en sa alan ha inikagi ku inyu matun-an nuy daan ha madani ad en aglikù. ");
INSERT INTO bkd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Laus gayed sa ag-ikagiyen ku inyu ha harì pa alan matay sa mga etaw maamin en haena matuman. ");
INSERT INTO bkd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mahanaw pa sa langit daw sa kalibutan ba sa mga lalang ku harì gayed mahanaw. ");
INSERT INTO bkd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hurà nakatuen hu panahun ku kan-u haena agkahitabù bisan pa sa mga balinsuguen ta langit daw siak, ta iyan dà gayed sa Dios ha Amay ku nakatuen taena. ");
INSERT INTO bkd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Aman magbantay kaw gayed ta harì nuy agkatun-an sa panahun ku kan-u a aglikù. ");
INSERT INTO bkd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Iling hu sabuwa ha etaw ha aghipanaw duun hu madiyù. Inilahan din hu buluhaten sa mga sinaligan din daw sa sabuwa kandan iyan sinaligan ha magbantay duun hu pultahan. ");
INSERT INTO bkd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Aman magbantay kaw ta harì nuy agkatun-an ku kan-u makaulì sa agalen nuy, ku daleman ba daw ku liwarà ba sa daleman, ku kaaldawen ba daw ku maselem en ba. ");
INSERT INTO bkd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ku tigkan haena makauma kinahanglan ha hurà inyu tagtiduga. ");
INSERT INTO bkd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa inikagi ku inyu tag-ikagiyen ku daan duun hu alan ha ‘Magbantay kaw gayed.’” ");
INSERT INTO bkd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Su daruwa dà paman ha aldaw na iyan en sa pagsaulug hu Aldaw hu Paglabay daw hu Pagkaen hu Supas ha Hurà Duun Igpatulin, sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan nan-ahà hu paagi hu pagdakep ki Jesus ha harì matun-an hu mga etaw ta daw mapatay dan. Ba minikagi sidan hu ");
INSERT INTO bkd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Harì taw dakepen duun hu pagsaulug ta kan ku magubut sa mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Su tagkaen si Jesus diyà ta Betania duun hu balay hi Simon ha sanglahen su anay amin bahi ha uminubay diyà ki Jesus. Saena ha bahi tag-uwit hu pahumut ha tungkay mahal ha tagngaranan hu nardo daw intagù duun hu butilya ha alabastro. Ginebà din sa tangeb taena daw ihudhud diyà ta ulu hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Amin mga etaw diyà ha nangapauk ha tagyanaen “Imbà din bà dà kalkali hayana sa pahumut? ");
INSERT INTO bkd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maayad pa ngaay ku imbaligyà hayana hu pila ha gatus daw sa halin din in-ila duun hu mga makaluluuy.” Aman tungkay dan napaukan su bahi. ");
INSERT INTO bkd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ba inikagiyan sidan hi Jesus hu “Bay-ani nuy en hayana. Imbà nuy agsamuka ta sa binuhat din dini ta kanak madagway tungkay. ");
INSERT INTO bkd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sa mga makaluluuy sigi dà diyan ta inyu daw agkabuligan nuy sidan hu bisan inu ha panahun, ba siak harì ad en maglugay dini ta inyu. ");
INSERT INTO bkd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Binuhat din dini ta kanak sa agkabaug din hu pagpangandam hu kalebenga kanak. ");
INSERT INTO bkd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Laus gayed sa ag-ikagiyen ku inyu ha bisan hindu asem duun isangyaw sa Maayad ha Tultulanen dini ta tibuuk ha kalibutan, sa binuhat taini ha bahi harì gayed malipatan daw itultul daan.” ");
INSERT INTO bkd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Si Judas Iscariote sa sabuwa duun ku sampulù daw daruwa ha tinun-an hi Jesus duminuun hu mga labaw ha sinaligan hu paghalad ta daw itugyan din si Jesus diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Su mapaliman dan haena nangabayà-bayà gayed sidan daw sinaaran dan si Judas ha ag-ilahan dan hu salapì. Aman nan-ahà dayun si Judas hu paagi ha makatugyan din si Jesus diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Su mauma en sa panahun ha agsaulugen sa Pagkaen hu Supas ha Hurà Duun Igpatulin ha iyan daan panahun hu paghalad hu nati hu karniro hu pagsaulug taena ha Aldaw hu Paglabay, nanginginsà sa mga tinun-an diyà ki Jesus hu “Hindu sa agkabayaan nu ha elegan day hu pagpangandam hu igpanihapun taw hu pagsaulug?” ");
INSERT INTO bkd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sinugù din su daruwa kandan ha “Dumiyà kaw ta banuwa daw ku masal-aw nuy sa etaw ha tag-uwit hu bangà ha tinaguan hu wahig lumupug kaw kandin ");
INSERT INTO bkd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","duun hu balay ha agseledan din. Dayun ikagiyi sa tagibalay hu ‘Sa Manunudlù agpanginginsà ku hindu duun tag-amul-amul hu pagpakigsalu hu mga tinun-an din ta tagsaulug.’ ");
INSERT INTO bkd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipaahà din dayun inyu sa maluag ha kwarto diyà ta latun taena ha balay din ha inandaman en hu mga galamiten hu pagkaen na duun kaw taena pangandam para kanuy.” ");
INSERT INTO bkd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Duminiyà su mga tinun-an ta banuwa daw natuman gayed sa alan ha inikagi hi Jesus. Aman nangandam sidan hu pagkaen taena ha pagsaulug. ");
INSERT INTO bkd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Su daleman en nakauma si Jesus duma hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Su kamulu pa sidan tagkaen inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha sa sabuwa inyu iman ha nakigsalu kanak iyan maglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nangaguul su mga tinun-an din aman sa kada sabuwa kandan nanginginsà hu “Iyan a ba?” ");
INSERT INTO bkd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tuminubag si Jesus hu “Iyan sa sabuwa diyan ta inyu ha tagsalu en kanak iman. ");
INSERT INTO bkd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Siak sa Suled hu Kaet-etawan matay a gayed sumalà hu insulat ha lalang hu Dios mahitenged kanak, ba kahid-u gayed hu etaw ha maglimbung kanak. Maayad pa ngaay ku hurà en haena ibatà.” ");
INSERT INTO bkd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Su kamulu pa sidan tagkaen tuminimù si Jesus hu supas daw ampui din. Dayun pinangebing din haena daw ipan-ila duun hu mga tinun-an din ha tagyanaen “Timua nuy haini ta iyan en haini lawa ku.” ");
INSERT INTO bkd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dayun tinimù din sa tasa daw ampui daan haena. In-ila din kandan daw alan sidan umininum duun. ");
INSERT INTO bkd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Inikagiyan sidan hi Jesus hu “Iyan en haini langesa ku ha igpamalas hu mga salà hu kaet-etawan ha iyan timaan hu bag-u ha kasabutan hu Dios daw hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Laus gayed sa ag-ikagiyen ku inyu ha daw ad en asem isab ag-inum hu bag-u ha binu ku magharì en sa Dios ha Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Su makagkanta en sidan hu pagdayè hu Dios duminiyà sidan ta Buntud ta Olibo. ");
INSERT INTO bkd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Inikagiyan hi Jesus su mga tinun-an din hu “Alan kaw gayed sumuway kanak ta sa insulat ha lalang hu Dios tagyanaen ‘Aghimatayan ku sa magbalantay daw makagsusuwayà sa mga karniro.’ ");
INSERT INTO bkd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ba ku mabanhaw ad umuna a inyu diyà ta Galilea.” ");
INSERT INTO bkd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Minikagi si Pedro hu “Bisan ku sumuway ikaw sa duma ba harì a gayed hu kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ba inikagiyan hi Jesus hu “Laus gayed sa ag-ikagiyen ku ikaw ha taini ha daleman sa harì pa managauk sa manuk hu kadaruwa katatulu kad en makaikagi ha harì a ikaw agkakilala.” ");
INSERT INTO bkd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tuminubag si Pedro hu “Bisan pa ku himatayan a duma ikaw ba harì ku gayed hayana ikagiyen.” Iyan daan haena inikagi hu alan ha mga tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Si Jesus daw sa mga tinun-an din duminuun hu lugar ha tagngaranan ta Getsemane daw inikagiyan din sidan hu “Dini kaw dà taini magpinuu ta agdayun a diyà ta unahan hu pag-ampù.” ");
INSERT INTO bkd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Dinuma din si Pedro, si Santiago daw si Juan. Suminakit gayed sa gahinawa din hu kalugul ");
INSERT INTO bkd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","aman inikagiyan din sidan hu “Miglabay gayed kasakit sa gahinawa ku ha bà su agkabugtù en. Dini kaw dà daw magbantay kaw.” ");
INSERT INTO bkd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Su makadiyà en si Jesus ta unahan luminuhud daw dunghuy diyà ta bugtà ha mig-ampù ha tagyanaen “Amay ku, agkahimu nu sa alan. Ku mabaluy ngaay harì a ikaw ipaagi duun taini ha mga alantusen. Ba iyan sa ikaw ha pagbayà matuman kenà iyan sa kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Dayun linikuan hi Jesus su tatulu ha mga tinun-an din ba naahà din ha tagtidugahà en sidan. Aman inikagiyan din si Pedro hu “Simon, tagtiduga kad en ba? Imbà kaw harì pakagbantay bisan ngaay nangkauras dà? ");
INSERT INTO bkd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Magbantay kaw gayed daw mag-ampù ta daw harì kaw madaeg hu panulay. Agkabayà ngaay sa henà-henà nuy ba maluya kaw.” ");
INSERT INTO bkd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Luminikù dà paman si Jesus daw mig-ampù iling ku nauna. ");
INSERT INTO bkd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Su lumikù dà duun ku mga tinun-an din naahà din ha tagtidugahà gihapun ta harì gayed sidan pakaantus. Hurà dan en agpakatubag kandin. ");
INSERT INTO bkd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Duun hu ikatulu ha paglikù din diyà ta kandan inikagiyan din sidan hu “Tagtidugahà kaw pa ba diay? Pukaw kaw en ta iyan en haini panahun ha siak sa Suled hu Kaet-etawan itugyan ad en duun hu mga makasasalà ha etaw. ");
INSERT INTO bkd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangun kaw ta aghipanaw kuy en. Ahaa nuy, taini en sa etaw ha taglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Su kamulu pa si Jesus tag-ikagi nakauma en sa sabuwa duun taena ha sampulù daw daruwa ha tinun-an din ha iyan si Judas duma hu madakel ha mga etaw ha tag-uuwit hu mga ispada daw mga bunal ta sinugù sidan hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan daw hu mga magulang. ");
INSERT INTO bkd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Amin timaan ha inikagi kandan hi Judas ha tagyanaen “Sa hadekan ku iyan en haena aman dakepen nuy dayun daw uwiten nuy ha pabantayan gayed.” ");
INSERT INTO bkd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Su makauma sidan inubayan sagunà hi Judas si Jesus daw ikagiyi hu “Manunudlù” dayun hinadekan din. ");
INSERT INTO bkd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sagunà dan dinakep si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sa sabuwa ha tagtiyadeg diyà ta ubay dan duminagtù hu ispada din daw tigbasa sa suluguen hu tungkay labaw ha sinaligan hu paghalad aman nalapungan haena. ");
INSERT INTO bkd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dayun inikagiyan hi Jesus su mga etaw hu “Pangulu a ba hu mga tulisan imbà kaw tag-uuwit hu mga ispada daw mga bunal hu pagdakep kanak? ");
INSERT INTO bkd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aldaw-aldaw nanudlù a inyu diyà ta Timplo ba hurà a inyu dakepa. Ba saena nahitabù ta daw matuman sa insulat ha lalang hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dayun inawaan si Jesus hu mga tinun-an din ta nangakapulaguy sidan. ");
INSERT INTO bkd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amin daan malaki ha luminupug kandan ha bà dà mig-ambal. Aman dinakep dan haena ");
INSERT INTO bkd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ba nakapulaguy ha hurà din en pinaksuy ta nakabilin dà su ambal din. ");
INSERT INTO bkd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Inuwit si Jesus ku mga etaw diyà ta balay taena ha tungkay labaw ha sinaligan hu paghalad ta diyà en tag-amul-amul sa mga labaw ha sinaligan hu paghalad daw sa mga magulang daw sa mga manunudlù hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Si Pedro taglupug daan kandan ba madiyù dà daw diyà dà nataman ta lama. Uminamul haena duun hu mga bantay ha tagpinuu diyà ha taghidadang duun hu hapuy. ");
INSERT INTO bkd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sa mga labaw ha sinaligan hu paghalad daw sa alan ha duma dan ha mga labaw ha punuan hu mga Judio nan-ahà gayed hu mga katarengan ta daw mahimatayan dan si Jesus, ba hurà dan gayed agkaahà. ");
INSERT INTO bkd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Madakel daan sa nanistigus hu bidù ba hurà mag-iling sa katarengan dan. ");
INSERT INTO bkd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dayun amin mga etaw ha huminitindeg daw nanistigus hu mga bidù ha kagi dan ");
INSERT INTO bkd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Napaliman day haini ha tagyanaen ‘Agkagasen ku haini sa Timplo ha binalay hu etaw, ba duun hu tatulu ha aldaw agbalayen ku dà sa lain ha timplo ha kenà en binuhat hu etaw.’” ");
INSERT INTO bkd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ba hurà makag-iling sa katarengan dan. ");
INSERT INTO bkd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dayun huminitindeg su tungkay labaw ha sinaligan hu paghalad daw insai si Jesus hu “Inu sa makatubag nu taini ha sumbung dan ikaw?” ");
INSERT INTO bkd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ba si Jesus hurà en magtubag. Minikagi dà paman su tungkay labaw ha sinaligan hu paghalad hu “Iyan kad ba su Mesiyas ha Batà hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tuminubag si Jesus hu “Iyan ad en daw ikagiyen ku inyu ha siak sa Suled hu Kaet-etawan maahà a asem inyu ha minuu a duun hu kawanan taena ha gamhanan ha Dios daw maahà a daan inyu ha makabulus diyà tayà ha gabunan.” ");
INSERT INTO bkd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Su mapaliman haena hu tungkay labaw ha sinaligan hu paghalad pigyahà din su pinaksuy din ta tungkay napauk ha tagyanaen “Hurà en kinahanglan ha amin pa manistigus ");
INSERT INTO bkd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ta napaliman taw en sa lalang din ha pigtameyes din gayed sa Dios. Inu man sa inyu ha henà-henà?” Nasabuwa sa henà-henà dan ha angayan ha silutan gayed si Jesus hu kamatayen. ");
INSERT INTO bkd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dayun sa duma kandan uminileb diyà ki Jesus daw dinap-en dan sa mata din daw sumbaga hu kagi dan “Tagnai ku sin-u kanay sa migsumbag ikaw.” Dayun tinimù si Jesus ku mga bantay daw bunali. ");
INSERT INTO bkd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Su diyà pa si Pedro ta lama taena ha balay nakauma su bahi ha suluguen ku tungkay labaw ha sinaligan hu paghalad. ");
INSERT INTO bkd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Su maahà din si Pedro ha taghidadang pigtengtengan din haena daw ikagiyi hu “Iyan ka man diay duma hi Jesus ha taga-Nazaret.” ");
INSERT INTO bkd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ba miglimud si Pedro ha tagyanaen “Harì ku agkatun-an ku inu sa tagsubayen nu.” Dayun guminuwà si Pedro payanaen diyà ta dalan na tuminagauk daan sa manuk. ");
INSERT INTO bkd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Su maahà haena ku suluguen ha bahi inikagiyan din en paman su mga etaw diyà hu “Iyan haini duma tayà ha etaw.” ");
INSERT INTO bkd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ba miglimud en paman si Pedro. Su malugay-lugay inikagiyan si Pedro ku mga etaw ha tagtiyadeg diyà ha “Duma ka gayed tayaa ta taga-Galilea ka man daan.” ");
INSERT INTO bkd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba nanumpà gayed si Pedro hu kagi din “Harì ku agkakilala ku sin-u hayana sa etaw ha tagsubayen nuy.” ");
INSERT INTO bkd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dayun uminisab tuminagauk sa manuk. Sagunà nahenhenaan hi Pedro sa inikagi hi Jesus kandin ha “Ku harì pa managauk sa manuk hu kadaruwa katatulu kad en makaikagi ha harì a ikaw agkakilala.” Aman mig-agalaay si Pedro. ");
INSERT INTO bkd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Su maselem en sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan, sa mga magulang daw sa alan ha duma dan ha mga labaw ha punuan hu mga Judio miglalang-lalang ku in-inuwen dan si Jesus. Dayun binakus dan haena daw itugyan diyà ki Pilato. ");
INSERT INTO bkd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ininsaan hi Pilato si Jesus hu “Iyan ka ba Harì hu mga Judio?” Si Jesus tuminubag hu “Iyan ad en su inikagi nu.” ");
INSERT INTO bkd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sa mga labaw ha sinaligan hu paghalad migsumbung hu madakel gayed mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aman inisaban ininsaan hi Pilato si Jesus ha “Hurà nu ba katarengan hu mga sumbung dan? Palilimani nu sa madakel ha sumbung dan mahitenged ikaw.” ");
INSERT INTO bkd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ba hurà en gayed tubag si Jesus aman tungkay nabeleng si Pilato. ");
INSERT INTO bkd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ku agsaulugen sa Aldaw hu Paglabay iyan naanadan hi Pilato sa amin sabuwa ha purisu ha aglibriyen din sumalà hu agpanayuen hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Duun taena ha panahun amin nangapurisu tumenged hu pagsupak dan hu gubernu. Sa sabuwa kandan iyan si Barabas ha nakapatay su panahun ha samuken dan sa banuwa. ");
INSERT INTO bkd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Su maamul-amul en sa mga etaw hinangyù dan si Pilato ha buhaten din sa naanadan din hu paglibri hu sabuwa ha purisu. ");
INSERT INTO bkd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nanginginsà si Pilato hu “Agkabayaan nuy ba ha libriyen ku haini sa Harì hu mga Judio?” ");
INSERT INTO bkd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ta natun-an hi Pilato ha si Jesus intugyan hu mga labaw ha sinaligan hu paghalad tumenged hu kasina dan kandin. ");
INSERT INTO bkd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ba pigdasig sa kaet-etawan taena ha mga labaw ha sinaligan hu paghalad ha iyan dan panayuen si Barabas ha libriyen. ");
INSERT INTO bkd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ininsaan hi Pilato su mga etaw hu “In-inuwen ku diay sa tagngaranan nuy ha Harì hu mga Judio?” ");
INSERT INTO bkd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Alan sidan nangulahì hu “Ilansang hayana duun hu krus.” ");
INSERT INTO bkd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ba minikagi si Pilato hu “Imbà nuy igpalansang hayana? Inu diay sa nabuhat din ha madaet?” Ba bà dà nasì uminiseg sa kulahì hu mga etaw ha “Ilansang hayana.” ");
INSERT INTO bkd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tumenged ta agkabayaan hi Pilato ha mabayà-bayà su mga etaw impaguwà din si Barabas. Dayun pinalagkutan din si Jesus daw itugyan duun hu mga etaw ta daw makalansang dan duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Impaseled si Jesus hu mga sundalu duun ku balay hi Pilato dayun inamul-amulan haena hu mga kasundaluwan. ");
INSERT INTO bkd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pininaksuyan dan si Jesus hu maligà ha manggad. Tuminimù daan sidan hu gawed ha dugiyen ha binangkulà daw insuup dan diyà ta ulu hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dayun nangulahì sidan hu “Mabuhì sa Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sigi dan dà tagbunalai sa ulu hi Jesus hu kayu daw inileban dan daan haena. Migluhud-luhud sidan diyà ta kandin ha tagpasibù-sibù ha agtahuran dan haena. ");
INSERT INTO bkd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Su mapengahan dan en sa pagtameyes ki Jesus inawà dan dà su maligà ha manggad daw ilikù diyà ta kandin su pinaksuy din. Dayun inuwit dan si Jesus duun hu lugar ha duun dan iglansang hu krus. ");
INSERT INTO bkd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Amin etaw ha taga-Cirene ha tagngaranan ki Simon ha amay hi Alejandro daw hi Rufo. Nasal-aw dan haena ha tagdiyà ngaay ta banuwa, dayun pineges dan ha tiangen din su krus hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inuwit dan si Jesus duun hu lugar ha tagngaranan hu Golgota ha sa kahulugan taena Tul-an hu Ulu hu Etaw. ");
INSERT INTO bkd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Diyà igpainum dan ngaay si Jesus hu binu ha inamulan hu bulung ha mira ba hurà din haena inuma. ");
INSERT INTO bkd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dayun inlansang dan si Jesus duun hu krus. Binahin taena ha mga sundalu sa pinaksuy din pinaagi hu ripa ta daw matun-an dan ku inu sa timuen hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Agliwaraan en sa seselem su ilansang dan si Jesus duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Insulat sa sumbung mahitenged kandin ha tagyanaen “Iyan haini Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Inlansang dan daan su daruwa ha tulisan duma ki Jesus, sa sabuwa diyà dapit ta kawanan din daw sa sabuwa diyà ta gibang din. ");
INSERT INTO bkd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pinaagi taena natuman gayed sa insulat ha lalang hu Dios ha tagyanaen “Inisip haena ha duma hu mga etaw ha masinupaken.” ");
INSERT INTO bkd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa mga etaw ha agpamanagad tagkuyeng-kuyengà hu pagtameyes ki Jesus ha tagyanaen “Kagi nu man ha agkagasen nu sa Timplo ta agbalayen nu dà duun hu tatulu ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Libriya sa kaugalingen nu daw lugnà ka duun tayan ha krus.” ");
INSERT INTO bkd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iling daan taena sa pagtameyes hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan hu kagi dan “Aglibriyen din man gid sa duma ha mga etaw ba sa kandin ha kaugalingen harì din agkalibri. ");
INSERT INTO bkd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ahaen taw hayana sa Mesiyas ha iyan Harì hu mga kaliwatan hi Israel ku lumugnà ba iman duun tayan ha krus ta daw makatuu kuy kandin.” Saena ha mga tulisan ha inlansang duma kandin migtameyes en daan kandin. ");
INSERT INTO bkd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Su maugtu en sa aldaw suminukilem sa tibuuk ha kalibutan hu tatulu ha uras. ");
INSERT INTO bkd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Su agkabalalay en sa aldaw nangulahì si Jesus hu madaging ha tagyanaen “Eli, Eli, lama sabaktani?” ha tagkahulugan hu “Dios ku, imbà a ikaw bay-ani?” ");
INSERT INTO bkd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Su mapaliman haena hu duma ha mga etaw ha tagtiyadeg diyà ta ubay din minikagi sidan hu “Tag-umawen din gid si Elias sa propita.” ");
INSERT INTO bkd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sa sabuwa kandan tuminimù hu manggad ha inteleb duun hu sukà daw ibedbed duun hu panga, dayun insungit din ki Jesus daw minikagi hu “Bay-ani hayan ta ag-ahaen taw pa ku makahiwal ba si Elias hu pagpalugnà kandin.” ");
INSERT INTO bkd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nangulahì si Jesus dayun nabugtuan. ");
INSERT INTO bkd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Su makepal ha manggad ha in-elang diyà ta Timplo sagunà naliwarà nayahà sugud ta sampaw payanaen en ta sagayadan taena. ");
INSERT INTO bkd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Su maahà ku kapitan ha tagtiyadeg duun hu ubay taena ha krus sa kapatay hi Jesus nakaikagi haena hu “Laus gayed ha Batà haini hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amin daan mga bahi ha tagbantay ki Jesus ba diyà dà sidan ta madiyù, sa duma kandan iyan si Maria Magdalena, si Salome daw si Maria sa inay hi Santiago daw hi Jose. ");
INSERT INTO bkd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Duminuma sidan ki Jesus diyà ta Galilea hu pag-alima kandin. Diyà daan sa madakel pa ha mga bahi ha duminuma kandin payanaen ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hapun haena hu Biernes na ku sumalep en sa aldaw agsugud en sa Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Amin etaw ha tagngaranan ki Jose ha taga-Arimatea ha tinahud hu alan ha mga labaw ha punuan hu mga Judio daw tagsalap daan hu pagharì hu Dios. Saena namalaw gayed hu pagdiyà ki Pilato daw panayua sa lawa hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Migduwa-duwa si Pilato ku minatay en ba si Jesus aman inumaw din su kapitan hu mga sundalu daw insai ku minatay en ba si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Su matun-an din ha minatay en in-ila din sa lawa hi Jesus diyà ki Jose. ");
INSERT INTO bkd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aman tinimù din haena daw bungkusi hu maputì ha manggad ha pinalit din daw itagù duun hu binangbangan ha dampiyas. Dayun inipelan din haena hu adagi ha batu. ");
INSERT INTO bkd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria Magdalena daw sa sabuwa ha Maria ha inay hi Jose nakaahà ku hindu inlebeng si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Su maiwas en sa Aldaw hu Paghimlay daw suminibwal en sa aldaw duun hu Dominggo, si Maria Magdalena, si Salome, daw si Maria sa inay hi Santiago duminuun ku piglebengan ki Jesus sa tag-uuwit hu pahumut ha pinalit dan ta ighaplas dan haena hu lawa hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Su tagdiyà en sidan migpainsaay sidan ha tagyanaen “Sin-u sa umawà taena ha in-ipel ha batu duun ku lebeng?” Ba su makauma sidan duun ku lebeng naahà dan ha naawà en su adagi ha batu. ");
INSERT INTO bkd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Su sumeled sidan duun naahà dan sa maama ha tagpinuu diyà dapit ta kawanan ha sa pinaksuy din tungkay maputì aman nangahaldek gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ba inikagiyan sidan taena ha “Harì kaw agkangahaldek. Tagpan-ahaen nuy si Jesus ha taga-Nazaret sa inlansang duun hu krus ba hurà en dini ta nabanhaw en. Ahaa nuy haini sa naugsakan din. ");
INSERT INTO bkd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Aman agpasa nuy elegi sa mga tinun-an din labi en si Pedro daw ikagiyi sidan ha si Jesus ag-una kandan diyà ta Galilea. Maahà nuy haena diyà sumalà hu inikagi din inyu.” ");
INSERT INTO bkd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Su mga bahi pighugdunan hu kahaldek daw nangabeleng aman guminuwà sidan duun ku lebeng daw pulalaguy. Harì sidan agpakaikagi diyà ta dalan ta agkangahaldek sidan. ");
INSERT INTO bkd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Su mabanhaw en si Jesus hu kaaldawen hu Dominggo iyan una ha pigpaahaan din diyà si Maria Magdalena su naulian din ha inulinan su anay hu pitu ha busaw. ");
INSERT INTO bkd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dayun inelegan hi Maria sa mga duma din ha nakigduma-duma daan ki Jesus daw tultuli sidan sa tag-agalaay hu paglugul. ");
INSERT INTO bkd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Su mapaliman dan ha nabanhaw en si Jesus daw naahà haena hi Maria hurà sidan tuu. ");
INSERT INTO bkd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Su maiwas haena migpaahà dà si Jesus duun hu daruwa ha taghipanaw payanaen duun hu sabuwa ha banuwa ba hurà dan kakilala si Jesus. ");
INSERT INTO bkd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Su makilala dan en haena tinultulan dan sa mga duma dan ba hurà daan sidan tuu. ");
INSERT INTO bkd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Migpaahà si Jesus duun ku sampulù daw sabuwa ha tinun-an su tagkaen sidan. Sinaway din sidan ta harì sidan agtuu daw madesen gayed sa henà-henà dan ta hurà dan tuuwi sa nakaahà kandin ha nabanhaw. ");
INSERT INTO bkd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Inikagiyan din sidan hu “Hipanaw kaw dini ta tibuuk ha kalibutan daw isangyaw nuy sa Maayad ha Tultulanen duun hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bisan sin-u sa tumuu daw magpabautismu maluwas, ba sa harì tumuu agsilutan gayed. ");
INSERT INTO bkd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Saena ha agtuu magaheman ta daw makabuhat sidan hu mga belenganen. Pinaagi hu ngaran ku makabugaw sidan hu mga busaw daw makaikagi daan sidan hu harì agkasabut ha inikagiyan. ");
INSERT INTO bkd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ku makaibit sidan hu bunsalagan daw ku makainum sidan hu hilu harì sidan mainu, daw ku dampaen dan sa agkangadaluwan mangaulian daan.” ");
INSERT INTO bkd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Su maiwas haena ikagiya hi Jesus luminigtu diyà ta langit daw pinuu duun hu kawanan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dayun namanhipanaw sa mga tinun-an din daw nanunultul duun hu bisan hindu. Sa Dios migbulig kandan daw pinaagi hu mga belenganen nakapaahà dan ha laus gayed sa lalang ha intultul dan.");
INSERT INTO bkd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Minahal ha Teofilo, madakel en sa migsulat hu naul-ulahan su anay dini ta kanuy daw sa insulat dan iyan sa inikagi kandan hu mga etaw ha nakaahà taena ha iyan daan migsangyaw duun hu kaet-etawan. Tumenged ta sinusi ku gayed sa alan sugud su anay nahenhenaan ku ha maayad ku ipanday ku isulat haini ");
INSERT INTO bkd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta daw matun-an nu gayed sa kamatuuran ha intudlù inyu. ");
INSERT INTO bkd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Duun taena ha panahun ha si Herodes iyan harì diyà ta Judea amin sinaligan hu paghalad ha tagngaranan ki Zacarias saena kaliwat hi Abias sa sinaligan daan hu paghalad. Sa asawa hi Zacarias iyan si Elisabet ha kaliwat daan hi Aaron. ");
INSERT INTO bkd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Si Zacarias daw si Elisabet inisip hu Dios ha matareng daw tinuman dan gayed sa alan ha Kasuguan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba hurà dan gayed batà ta si Elisabet harì agpamatà daw mga laas en daan sidan. ");
INSERT INTO bkd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kandan en ha panahun ki Zacarias daw hu mga duma din ha sinaligan hu paghalad sa pag-alagad hu Dios duun hu Timplo. ");
INSERT INTO bkd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sumalà hu batasan hu mga sinaligan hu paghalad iyan dan naripahan si Zacarias ha sumeled duun ku Timplo hu pagsunug hu insenso. ");
INSERT INTO bkd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Su panahun hu pagsunug taena ha insenso madakel daan sa mga etaw diyà ta guwà ha tag-ampù. ");
INSERT INTO bkd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Dayun amin balinsuguen hu Dios ha nakahiwal diyà ki Zacarias ha tuminiyadeg duun hu kawanan ku halaran ha kamulu daan tagkasunug sa insenso duun. ");
INSERT INTO bkd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Su maahà haena hi Zacarias nakignat gayed daw nahaldek. ");
INSERT INTO bkd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ba inikagiyan ku balinsuguen hu Dios hu “Zacarias, harì ka agkahaldek ta sa pag-ampù nu napaliman hu Dios aman sa asawa nu ha si Elisabet magbatà hu maama daw sa ingaran nu asem taena iyan si Juan. ");
INSERT INTO bkd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Makapalipay haena ikaw daw malipay daan sa kaet-etawan ku ibatà asem haena ");
INSERT INTO bkd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ta bantugan gayed ha batà duun hu atubangan hu Dios. Harì haena uminum hu binu daw bisan inu ha inumen daw ulinan hu Balaan ha Ispiritu sugud hu kabataa taena. ");
INSERT INTO bkd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pinaagi kandin madakel ha mga kaliwatan hi Israel sa lumikù duun hu Dios ha iyan Magbabayà dan. ");
INSERT INTO bkd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iyan haena agkauna dì hu Ginuu daw sa gahem din iling ki Elias ha propita ta daw makag-uliay sa maayad ha pagdapità hu mga batà duun hu mga laas dan, daw sa mga etaw ha masinupaken makaghinulsul daan dayun makalikù duun hu maayad ha panghenà-henà. Iyan haena makapangandam hu kaet-etawan hu pagpakauma hu Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nakaikagi si Zacarias hu “Inu sa ipakatuu ku tayana ha magulang kay en man ki Asawa ku?” ");
INSERT INTO bkd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tuminubag su balinsuguen hu Dios ha “Iyan a si Gabriel ha sinaligan hu Dios diyà ta langit. Sinugù a kandin dini ta daw matultulan ku ikaw taini ha maayad ha tultulanen. ");
INSERT INTO bkd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ba tumenged ta harì ka man agtuu hu inikagi ku ikaw sugud iman maemaw ka taman ha matuman en haena.” ");
INSERT INTO bkd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Agkangabeleng sa mga etaw ha tag-angat diyà ta guwà ku imbà agkalugay si Zacarias diyà ta seled. ");
INSERT INTO bkd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Su gumuwà en si Zacarias harì en pakaikagi diyà ta kandan. Natun-an dan dayun ha amin din naahà diyà ta seled taena ha Timplo ta bà dà paman pakagsingyas kandan. ");
INSERT INTO bkd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Su maiwas en sa kandan ha panahun hu pag-alagad uminulì dayun si Zacarias. ");
INSERT INTO bkd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hurà kalugay nabedes si Elisabet sa asawa din daw hurà magguwà-guwà diyà ta balay dan seled hu lalima ha bulan. ");
INSERT INTO bkd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nakahenà-henà si Elisabet hu “Binuligan a gayed hu Dios ta human ad en magbatà na harì ad en magayhà hu mga duma ku.” ");
INSERT INTO bkd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Su haenem en ha bulan sa tigkabedes hi Elisabet sinugù hu Dios sa balinsuguen din ha si Gabriel diyà ta Nazaret ha sakup ta Galilea ");
INSERT INTO bkd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ta pinaikagiyan duun sa sabuwa ha laga ha si Maria sa kinagunan en ki Jose ha kaliwat hi David. ");
INSERT INTO bkd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Su makauma en sa balinsuguen diyà ki Maria inikagiyan din haena hu “Maria, napanalanginan ka gayed hu Dios. Sa Dios duma ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Su mapaliman haena hi Maria tungkay gayed nasamuk daw pighenhenaay din ku inu sa kahulugan taena. ");
INSERT INTO bkd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ba inikagiyan ku balinsuguen hu “Maria, harì ka agkasamuk ta napanalanginan ka gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mabedes ka asem daw magbatà ka hu maama, daw sa ingaran nu duun iyan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mabantug gayed daw ngaranan haena ha Batà hu Dios sa Magbabayà hu alan. Ipagharì hu Dios iling hu gin-apuan din ha si David ");
INSERT INTO bkd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","daw sa pagharì din duun hu mga kaliwatan hi Jacob hurà din gayed katapusan.” ");
INSERT INTO bkd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tuminubag si Maria hu “In-inuwen man hayana sa hurà a pa man makakilala hu maama?” ");
INSERT INTO bkd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ba inikagiyan hu balinsuguen hu “Mabedes ka pinaagi hu Balaan ha Ispiritu daw sa gahem hu Dios ha Magbabayà hu alan iyan mag-ulin ikaw. Iyan haini hinengdan ha sa batà nu asem ngaranan ha balaan ha Batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bisan sa idang nu ha si Elisabet ha laas en daw harì agpamatà ba haenem en iman ha bulan sa tigkabedes din. ");
INSERT INTO bkd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta hurà gayed harì mahimu hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nakaikagi si Maria ha “Suluguen a hu Dios aman sa inikagi nu matuman gayed.” Dayun uminawà su balinsuguen hu Dios diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Duun taena ha panahun uminagpas si Maria duminuun hu buntud ha sakup ta Judea. ");
INSERT INTO bkd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Su makauma diyà ta balay hay Zacarias inumaw din si Elisabet. ");
INSERT INTO bkd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Su mapaliman hi Elisabet sa lageng hi Maria sagunà kuminayug-kayug sa batà diyà ta getek hi Elisabet. Inulinan si Elisabet hu Balaan ha Ispiritu ");
INSERT INTO bkd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","dayun minikagi ha “Hurà en gayed bahi ha mailing ikaw ta pigpanalanginan ka hu Dios daw mapanalanginan daan sa batà nu asem. ");
INSERT INTO bkd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pigpanalanginan a daan hu Dios ta sa inay hu Ginuu ku duminini gayed ta kanak. ");
INSERT INTO bkd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Su mapaliman ku gan sa lageng nu sagunà kuminayug-kayug sa batà dini ta getek ku tumenged hu kalipay din. ");
INSERT INTO bkd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pigpanalanginan ka gayed ta tinuuwan nu ha matuman sa impadayag hu Dios diyan ta ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Minikagi si Maria ha tagyanaen “Dayeen ku gayed sa Dios ");
INSERT INTO bkd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ha Manluluwas ku daw iyan tigkabayà-bayà ku ");
INSERT INTO bkd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ta bisan pa ku tungkay ubus sa kahimtang ku iman ba hurà a kandin kalipati. Sugud iman makaikagi sa kaet-etawan ha iyan a bahi ha pigpanalanginan hu Dios ");
INSERT INTO bkd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ta mga belenganen sa binuhat din kanak. Balaan gayed sa ngaran din. ");
INSERT INTO bkd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Amin din kahid-u hu alan ha tagtahud kandin sugud dà hu nauna ha etaw bisan iman. ");
INSERT INTO bkd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impadayag hu Dios sa pagkagamhanan din ta sinamuk din sa henà-henà hu galbuwen ha etaw. ");
INSERT INTO bkd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Impaus-us din daan sa bantugan ha harì ba saena ha ubus sa kahimtang din impatangkaw din. ");
INSERT INTO bkd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sa tagkinahanglan inilahan din ba sa sapian hurà din en ilahi. ");
INSERT INTO bkd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Binuligan din sa mga kaliwatan hi Israel ta nahenhenaan din sa insaad din duun hu mga kaliwatan hi Abraham ha agkahid-uwan din sidan hu hurà din katapusan. Inikagi din en haini duun hu mga gin-apuan taw.” ");
INSERT INTO bkd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Si Maria migtimà diyà ki Elisabet duun hu tatulu ha bulan daw human ulì. ");
INSERT INTO bkd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Su magbatà en si Elisabet maama sa batà din. ");
INSERT INTO bkd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sa kahid-u hu Dios diyà ki Elisabet napaliman hu mga kadumahan daw mga silingan din aman nakalagkes sidan hu kalipay din. ");
INSERT INTO bkd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Su mauma en sa ikawalu ha aldaw pigpasirkunsidahan dan su batà. Sa agkabayaan ngaay hu mga etaw ha ingaran taena ha batà iyan si Zacarias ta iyan haena ngaran hi Amay din, ");
INSERT INTO bkd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ba si Elisabet hurà kabayà ta sa igngaran din duun iyan si Juan. ");
INSERT INTO bkd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ba tinubag dan ha “Hurà nu man kadumahan ha iyan hayana ngaran din.” ");
INSERT INTO bkd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dayun migsingyas sidan diyà ki Zacarias ku inu sa kandin ha igngaran taena ha batà. ");
INSERT INTO bkd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aman migsingyas daan haena ha ilahan hu agsulatan din, dayun insulat din ha “Iyan ngaran taena si Juan.” Nangabeleng gayed sa alan ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sagunà dayun nakaikagi si Zacarias aman dinayè dan gayed sa Dios. ");
INSERT INTO bkd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nangabeleng gayed su mga silingan din daw saini ha tultulanen nakalekep duun hu kaet-etawan duun hu mga buntud ha sakup ta Judea. ");
INSERT INTO bkd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sa alan ha nakapaliman taena mighenhenaay ku inu sa mapayanan-an taena ha batà ta ginaheman gayed haena hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Zacarias inulinan hu Balaan ha Ispiritu dayun minikagi ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayeen gayed sa Dios ha Magbabayà taw sikuy sa mga kaliwatan hi Israel ta duminini ta kanuy hu paglibri kanuy. ");
INSERT INTO bkd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Agsuguen din dini ta kanuy sa Manluluwas ha kaliwat hi David sa suluguen din ");
INSERT INTO bkd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ta iyan haena inikagi kanuy hu Dios pinaagi hu mga propita din. ");
INSERT INTO bkd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Agbuligan kuy kandin ta daw harì kuy madaeg hu mga kuntra taw. ");
INSERT INTO bkd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Agkahid-uwan din sa mga gin-apuan taw daw harì haena agkalipat hu kasabutan dan. ");
INSERT INTO bkd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sa impanumpà hu Dios diyà ki Abraham ha gin-apuan taw iyan ");
INSERT INTO bkd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","sa sikuy sa mga kaliwatan din libriyen kuy kandin ta daw harì kuy madaeg hu mga kuntra taw daw harì kuy daan mahaldek hu pag-alagad kandin ");
INSERT INTO bkd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tumenged ta mahimpit daw matareng kuy duun hu atubangan din iman ha bubuhay kuy pa.” Dayun inikagiyan hi Zacarias su batà din hu ");
INSERT INTO bkd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ngaranan ka gayed asem ha propita hu Dios ha Magbabayà hu alan ta iyan ka igpauna dì hu Ginuu hu pagpangandam hu ag-agiyan din. ");
INSERT INTO bkd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ikagiyan nu sa kaet-etawan ha pinaagi hu pagpasaylu hu mga salà dan maluwas sidan ");
INSERT INTO bkd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","tumenged ta maluluy-en sa Dios. Saena makailaw hu henà-henà hu mga etaw ha duun tagtimà hu kasukileman hu kamatayen daw iyan daan haena panulù duun hu kalinaw.” ");
INSERT INTO bkd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uminadagi daw matatau gayed su batà hi Zacarias. Su makagulang en haena duun migtimà hu pinakabulung-bulung ha lugar hangtud ha mauma sa panahun ha matudluan din en sa mga duma din ha kaliwatan hi Israel. ");
INSERT INTO bkd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Duun taena ha panahun ha iyan si Cesar Agusto Harì ta Roma migsugù haena ha listahen sa mga ngaran hu alan ha mga ginsakupan din. ");
INSERT INTO bkd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyan haini una ha pagpanlista daw iyan si Cirenio gubernador diyà ta Siria. ");
INSERT INTO bkd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aman sa alan ha mga etaw duminuun hu banuwa hu mga gin-apuan dan hu pagpalista. ");
INSERT INTO bkd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Si Jose sa diyà napuun ta Nazaret ha sakup ta Galilea duminiyà daan ta Betlehem ha sakup ta Judea ta sa Betlehem iyan banuwa ha duun imbatà si David sa gin-apuan din. ");
INSERT INTO bkd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Dinuma din si Maria sa tag-asawahen din ha tagkabedes en. ");
INSERT INTO bkd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Su diyà en sidan ta Betlehem iyan en daan haena panahun ha magbatà si Maria. ");
INSERT INTO bkd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aman migbatà haena hu maama ha iyan kamagulangan ha batà din. Binungkusan din haena hu manggad daw iugsak duun hu balahugà hu mananap ta hurà en sidan makaseled duun hu balay ha hulabungà. ");
INSERT INTO bkd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Amin mga magbalantay hu mga karniro ha tagbantay su daleman duun hu panabtabà ha ubay diyà ta Betlehem. ");
INSERT INTO bkd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nakahiwal diyà ta kandan sa balinsuguen hu Dios daw nailawan sidan hu anlag hu Dios aman nangahaldekan gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ba inikagiyan sidan taena ha balinsuguen hu Dios hu “Harì kaw agkangahaldek ta duminini a hu pagsangyaw inyu hu maayad ha tultulanen ha makapalipay hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Diyà iman ta Betlehem sa banuwa hi David imbatà en sa Manluluwas hu kaet-etawan ha iyan si Cristo ha Ginuu. ");
INSERT INTO bkd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sa timaan ha iyan en haini ta maahà nuy su batà ha binungkusan hu manggad daw in-ugsak duun hu balahugà hu mananap.” ");
INSERT INTO bkd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tigkan daan nakahiwal sa madakel ha mga balinsuguen ha tagdayè hu Dios ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dayeen gayed sa Dios diyà ta langit daw magmalinawen sa mga etaw ha pakapalipay hu Dios dini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Su lumikù en diyà ta langit sa mga balinsuguen su mga magbalantay hu mga karniro miglalang-lalang hu kagi dan “Dumiyà kuy ta Betlehem ta daw maahà taw haena sa impadayag kanuy hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aman uminagpas sidan hu paghipanaw daw naahà dan si Maria daw si Jose daw su batà ha in-ugsak duun hu balahugà. ");
INSERT INTO bkd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Su maahà dan haena inikagi dan dayun sa intultul kandan hu balinsuguen mahitenged taena ha batà. ");
INSERT INTO bkd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nangabeleng sa mga etaw ha nakapaliman taena ha inikagi hu mga magbalantay hu karniro. ");
INSERT INTO bkd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ba si Maria taghenhenaay gayed taena ha naul-ulahan. ");
INSERT INTO bkd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Naman-ulì su mga magbalantay hu karniro ha tagdayè hu Dios ta sa inikagi kandan hu balinsuguen natuman gayed. ");
INSERT INTO bkd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Su makauma sa ikawalu ha aldaw pigpasirkunsidahan su batà dayun pigngaranan haena hu Jesus ta iyan haena ngaran ha in-ila hu balinsuguen hu Dios su hurà pa kabedes si Maria. ");
INSERT INTO bkd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Su mauma sa panahun ha si Jose daw si Maria tagtuman hu tulumanen hu paglimpyu sumalà hu Kasuguan hi Moises inuwit dan si Jesus diyà ta Jerusalem daw ihalad duun hu Dios, ");
INSERT INTO bkd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ta nakasulat en duun hu Kasuguan hu Dios ha tagyanaen “Ku maama sa kamagulangan ha batà kinahanglan gayed ha ihalad duun hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Amin daan inhalad hi Jose daw hi Maria ta nakasulat en duun hu Kasuguan hu Dios ha tagyanaen “Kinahanglan ha amin daruwa ha limuken daw ku salapati ba sa ihalad.” ");
INSERT INTO bkd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amin etaw diyà ta Jerusalem ha tagngaranan ki Simeon saena matareng daw masinimbahen daw tag-angatà hu paglibriya hu mga kaliwatan hi Israel. Inulinan haena hu Balaan ha Ispiritu ");
INSERT INTO bkd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","aman impadayag kandin ha daw en haena patay ku maahà din en sa Mesiyas ha sinugù hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Su uwiten hi Maria daw hi Jose si Jesus diyà ta Timplo hu pagtuman hu tulumanen dan didiyà en daan si Simeon ta impadiyà haena hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Su maahà en hi Simeon su batà sinapnay din haena daw dayea sa Dios ");
INSERT INTO bkd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ha tagyanaen “Dios ha Magbabayà hu alan, tinuman nu gayed sa insaad nu kanak. Iman malinawen en sa henà-henà ku aman timuen ad ikaw, ");
INSERT INTO bkd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ta naahà kud en sa impadini nu ha Manluluwas ");
INSERT INTO bkd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ha pig-andam nu ta daw malibri sa alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iyan haini makailaw hu henà-henà hu kenà mga Judio ta daw matulen dan sa kamatuuran, daw pinaagi kandin sikay sa mga kaliwatan hi Israel madayè daan hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Si Jose daw si Maria nabeleng taena ha inikagi hi Simeon mahitenged ku batà dan. ");
INSERT INTO bkd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dayun inampuan sidan hi Simeon daw ikagiyi si Maria hu “Saini ha batà nu pinilì hu Dios daw iyan haini hinengdan ha sa kaliwatan hi Israel amin duun maluwas daw sa duma masilutan daan. Amin mga timaan ha saini sinugù hu Dios ba tameyesen hu madakel ha mga etaw ");
INSERT INTO bkd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ta pinaagi kandin madayag sa mga madaet ha henà-henà dan. Maglugul ka gayed mahitenged kandin ta saini kuntrahen hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Amin daan bahi ha pakasaysay hu igpaikagi hu Dios ha tagngaranan ki Ana sa batà hi Panuel ha kaliwat hi Aser. Saena pitu dà ha tuig nabalu en na iman laas en ta kawaluwan en daw haepat sa tuig din. Aldaw daw ku daleman diyà dà haena tagtimaay ta Timplo hu pagsimba daw amin daan panahun ha agsalang hu pagkaen ta daw harì maelangan sa pag-ampù din. ");
INSERT INTO bkd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Su diyà pa say Jose duminiyà si Ana ta kandan. Pigpasalamatan din sa Dios mahitenged taena ha batà dayun impadayag din duun hu mga etaw ha nakauma en sa makalibri hu mga kaliwatan hi Israel ha tagsalapen dan. ");
INSERT INTO bkd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Su matuman en hi Jose daw hi Maria sa alan sumalà hu Kasuguan hu Dios, uminulì sidan duun hu banuwa dan ta Nazaret ha sakup ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uminadagi daw mabis-ay si Jesus, matatau daan tungkay daw pigpanalanginan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kada tuig agdiyà sa mga laas hi Jesus ta Jerusalem hu pagsaulug taena ha Aldaw hu Paglabay. ");
INSERT INTO bkd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Su sampulù en daw daruwa sa tuig hi Jesus alan sidan duminiyà ta Jerusalem sumalà hu naanadan dan. ");
INSERT INTO bkd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Su maiwas en sa pagsaulug naman-ulì su mga laas hi Jesus ba hurà dan katun-i ha si Jesus migpatabun diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tumenged ta madakel sidan sa taghipanaw abi dan ha nakaduma en si Jesus kandan. Ba su nangkaaldaw en sa kahipanaw dan pinan-ahà dan si Jesus duun hu mga kadumahan daw mga amigu dan. ");
INSERT INTO bkd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba hurà dan gayed katulen aman luminikù sidan diyà ta Jerusalem hu pagpan-ahà kandin. ");
INSERT INTO bkd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Su ikatulu en ha aldaw human dan naahà si Jesus ha tagpinuuwà diyà ta Timplo duma hu mga manunudlù ta tagpalilimanà daw tagpanginginsaay kandan. ");
INSERT INTO bkd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sa alan ha nakapaliman kandin nangabeleng gayed hu pagsabut hi Jesus daw hu pagpanubag din. ");
INSERT INTO bkd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Su maahà en haena hi Jose daw hi Maria nangabeleng gayed sidan. Aman inikagiyan hi Maria hu “Imbà nu buhata haini dini ta kanay ta sikay ki Jose nasamukan gayed hu pagpan-ahaay ikaw?” ");
INSERT INTO bkd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ba tuminubag si Jesus hu “Imbà a inyu tagpan-ahaaya? Hurà nuy ba diay katun-i ha kinahanglan ha dini a gayed taini ha balay hu Amay ku?” ");
INSERT INTO bkd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ba hurà dan kasabut sa kahulugan taena ha inikagi hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dayun duminuma si Jesus diyà ta Nazaret daw migmatinumanen gayed kandan, ba taghenhenaayen gayed haena hi Maria. ");
INSERT INTO bkd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mig-iseg gayed sa katatau hi Jesus daw uminadagi daan ha nakapalipay hu Dios daw hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Su sampulù en daw lalima ha tuig sa pagkaharì hi Tiberio Cesar diyà ta Roma, si Poncio Pilato iyan daan gubernador diyà ta Judea daw si Herodes iyan harì diyà ta Galilea. Sa suled din ha si Felipe iyan daan harì diyà ta Iturea daw ta Triconitis, daw si Lisanias iyan harì diyà ta Abilene. ");
INSERT INTO bkd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Duun taena ha panahun si Anas daw si Caifas iyan mga tungkay labaw ha sinaligan hu paghalad. Su duun si Juan ha batà hi Zacarias taena ha pinakabulung-bulung ha lugar napaliman din sa lalang hu Dios ");
INSERT INTO bkd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","aman huminipanaw payanaen duun hu mga banuwa ubay diyà ta Wahig ta Jordan. Iyan haini intultul din sa “Maghinulsul kaw ta daw mapasaylu sa mga salà nuy daw magpabautismu kaw.” ");
INSERT INTO bkd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iyan en haena lalang hu Dios ha insulat hi Isaias sa propita ha tagyanaen “Amin etaw ha magkulahiay duun hu pinakabulung-bulung ha lugar ha magyanaen ‘Andama sa ag-agiyan hu Ginuu daw tul-ida nuy sa dalan. ");
INSERT INTO bkd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambuni sa alan ha mga dal-ug daw sa mga bubungan pataga nuy. Tul-ida sa balikungan daw sa mga madaet ha dalan pandayai nuy. ");
INSERT INTO bkd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dayun maahà hu kaet-etawan sa Manluluwas ha sinugù hu Dios.’” ");
INSERT INTO bkd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Su maahà hi Juan sa mga kaet-etawan ha tagpabautismu kandin inikagiyan din sidan hu “Sinyu sa mga bunsalagan, sin-u sa mig-ikagi inyu ha dumini kaw ta kanak? Abi nuy gid ha mapulaguyan nuy sa silut inyu hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ku laus ha mighinulsul kaw en hu mga salà nuy ipaahà nuy haena pinaagi hu maayad ha buhat. Harì kaw magsalig ha mga kaliwatan kaw hi Abraham ta ikagiyen ku inyu ha mahimu hu Dios buhata haini sa mga batu ha kaliwatan daan hi Abraham. ");
INSERT INTO bkd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sa tagpamilay andam en hu pagpilay hu mga kayu. Sa kayu ha madaet sa bunga din agpilayen daw bigsuli.” ");
INSERT INTO bkd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ba sa kaet-etawan nanginginsà ki Juan hu “Inu man sa kinahanglan ha buhaten day ta daw mapulaguyan day sa kapauk hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tinubag sidan hi Juan hu “Sa daruwa sa pinaksuy din kinahanglan ha iila din sa sabuwa duun hu hurà din daw saena ha amin din pagkaen mag-ila daan.” ");
INSERT INTO bkd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sa mga manunukut hu buhis duminiyà ki Juan ta tagpabautismu daan aman nanginginsà sidan hu “Manunudlù, inu man sa kinahanglan ha buhaten day?” ");
INSERT INTO bkd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Inikagiyan din sidan ha “Ku manukut kaw hu buhis harì kaw manlimbung.” ");
INSERT INTO bkd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Dayun amin daan mga sundalu ha nanginginsà kandin hu “Inu man sa kanay ha buhaten?” Inikagiyan din daan sidan hu “Harì kaw manalapì pinaagi hu pagpanhulgà daw hu pagbutang-butang daw kinahanglan ha ikalipay nuy en gayed sa suhul nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Su mapaliman haena hu mga etaw pighenhenaay dan dayun si Juan ku iyan en ba su Mesiyas ha tagsalapen dan. ");
INSERT INTO bkd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ba inikagiyan sidan hi Juan hu “Diyà a ta wahig agpamautismu inyu ba amin pa makadini ha labaw dì kanak ta bisan sa paghukad hu sapatus din kenà a gayed angayan duun. Sa kandin ha igbautismu iyan sa paulinan kaw kandin hu Balaan ha Ispiritu daw masunug sa madaet diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Agkailing haena hu taggunas ha sa malinggas iyan din igtagù duun hu bugawan ba sa ukap agbigsulan ha harì en mapedengan.” ");
INSERT INTO bkd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Amin daan duma ha mga paagi hu pagtudlù hi Juan hu Maayad ha Tultulanen duun hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Duun taena ha panahun binaldeng hi Juan si Harì Herodes ta inasawa din si Herodias sa asawa hu suled din daw amin pa duma ha madaet ha buhat hi Herodes. ");
INSERT INTO bkd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ba kenà haena iyan dà ta impapurisu din pa gayed si Juan. ");
INSERT INTO bkd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Su tagbautismuwan hi Juan sa mga etaw binautismuwan din daan si Jesus. Su tag-ampù pa si Jesus napuwaan sa langit ");
INSERT INTO bkd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","daw migbulus diyà ta kandin sa Balaan ha Ispiritu ha agkailing hu salapati. Amin lageng ha napuun diyà ta langit ha tagyanaen “Iyan en haini pinalanggà ku ha Batà ha tigkabayà-bayà ku.” ");
INSERT INTO bkd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Su katluan en sa tuig hi Jesus suminugud haena hu pagtudlù. Sumalà hu paghenà-henà hu mga etaw si Jesus iyan batà hi Jose. Si Jose batà hi Heli. ");
INSERT INTO bkd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli batà hi Matat. Si Matat batà hi Levi. Si Levi batà hi Melki. Si Melki batà hi Jana. Si Jana batà hi Jose. ");
INSERT INTO bkd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose batà hi Matatias. Si Matatias batà hi Amos. ");
INSERT INTO bkd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Amos batà hi Nahum. Si Nahum batà hi Esli. Si Esli batà hi Nagai. Si Nagai batà hi Maat. Si Maat batà hi Matatias. Si Matatias batà hi Semein. Si Semein batà hi Josec. Si Josec batà hi Joda. ");
INSERT INTO bkd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Joda batà hi Joanan. Si Joanan batà hi Resa. Si Resa batà hi Zorobabel. Si Zorobabel batà hi Salatiel. Si Salatiel batà hi Neri. ");
INSERT INTO bkd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri batà hi Melki. Si Melki batà hi Adi. Si Adi batà hi Cosam. Si Cosam batà hi Elmadam. Si Elmadam batà hi Er. ");
INSERT INTO bkd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er batà hi Josue. Si Josue batà hi Eliezer. Si Eliezer batà hi Jorim. Si Jorim batà hi Matat. Si Matat batà hi Levi. ");
INSERT INTO bkd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi batà hi Simeon. Si Simeon batà hi Juda. Si Juda batà hi Jose. Si Jose batà hi Jonam. Si Jonam batà hi Eliakim. ");
INSERT INTO bkd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliakim batà hi Melea. Si Melea batà hi Mena. Si Mena batà hi Matata. Si Matata batà hi Natan. Si Natan batà hi David. ");
INSERT INTO bkd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David batà hi Jese. Si Jese batà hi Obed. Si Obed batà hi Boez. Si Boez batà hi Salmon. Si Salmon batà hi Naason. ");
INSERT INTO bkd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason batà hi Aminadab. Si Aminadab batà hi Admin. Si Admin batà hi Arni. Si Arni batà hi Esrom. Si Esrom batà hi Fares. Si Fares batà hi Juda. ");
INSERT INTO bkd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda batà hi Jacob. Si Jacob batà hi Isaac. Si Isaac batà hi Abraham. Si Abraham batà hi Tara. Si Tara batà hi Nahor. ");
INSERT INTO bkd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor batà hi Serug. Si Serug batà hi Reu. Si Reu batà hi Peleg. Si Peleg batà hi Eber. Si Eber batà hi Sela. ");
INSERT INTO bkd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sela batà hi Cainan. Si Cainan batà hi Arfacad. Si Arfacad batà hi Sem. Si Sem batà hi Noe. Si Noe batà hi Lamec. ");
INSERT INTO bkd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec batà hi Matusela. Si Matusela batà hi Enoc. Si Enoc batà hi Jared. Si Jared batà hi Maleleel. Si Maleleel batà hi Cainan. ");
INSERT INTO bkd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan batà hi Enos. Si Enos batà hi Set. Si Set batà hi Adan. Si Adan iyan binuhat hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Uminawà si Jesus diyà ta Jordan ha inulinan en hu Balaan ha Ispiritu daw inuwit haena hu Balaan ha Ispiritu duun hu pinakabulung-bulung ha lugar ");
INSERT INTO bkd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ha duun daan sinulay hi Satanas seled hu kapatan ha aldaw. Duun taena ha panahun suminalang si Jesus hu pagkaen aman su maiwas en haena tungkay gayed nauhul. ");
INSERT INTO bkd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Inikagiyan hi Satanas ha “Ku Batà ka hu Dios ikagiyi haini sa mga batu ha mabuhat ha supas.” ");
INSERT INTO bkd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ba tuminubag si Jesus hu “Sa lalang hu Dios nakasulat en ha tagyanaen ‘Kenà iyan dà igkauyag hu etaw sa kalan-enen.’” ");
INSERT INTO bkd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dinuma si Jesus hi Satanas duun hu bubungan dayun tigkan din impaahà ki Jesus sa alan ha mga ginharian ta kalibutan ");
INSERT INTO bkd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","daw inikagiyan din si Jesus ha “Ku simbahen a ikaw saini ha agkaahà nu ig-ila ku ikaw ta daw pagharian nu, ta saini in-ila kanak ta daw makaila ku hu bisan sin-u ha agpilien ku.” ");
INSERT INTO bkd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ba si Jesus tuminubag hu “Sa lalang hu Dios nakasulat en ha tagyanaen ‘Iyan dà sa Dios ha Magbabayà hu alan angayan ha simbahen daw alagaran.’” ");
INSERT INTO bkd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dayun si Jesus dinuma en paman hi Satanas duun hu kinatangkawan ha atep taena ha Timplo diyà ta Jerusalem daw ikagiyi ha “Ku Batà ka hu Dios sabay ka duun taini ");
INSERT INTO bkd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ta sa insulat ha lalang hu Dios tagyanaen ‘Suguen hu Dios sa mga balinsuguen hu pagbantay ikaw ");
INSERT INTO bkd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","daw tamuken ka kandan ta daw harì ka mabugel.’” ");
INSERT INTO bkd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ba tuminubag si Jesus hu “Sa lalang hu Dios nakasulat en ha tagyanaen ‘Harì agsulaya sa Dios ha Magbabayà hu alan.’” ");
INSERT INTO bkd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Su mapengahan en hi Satanas buhata sa alan ha paagi din hu pagsulay inawaan din si Jesus hu mababà ha panahun. ");
INSERT INTO bkd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Luminikù si Jesus diyà ta probincia ta Galilea ha ginaheman hu Balaan ha Ispiritu daw sa tultulanen mahitenged kandin nakalekep duun hu alan ha mga banuwa diyà. ");
INSERT INTO bkd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Migtudlù haena duun hu mga simbahan hu mga Judio daw dinayè hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Duminiyà si Jesus ta Nazaret ha duun daan mig-adagi. Sumalà hu batasan din ku Sabado ha iyan Aldaw hu Paghimlay duminuun haena hu simbahan hu mga Judio. Dayun huminitindeg hu pagbasa hu lalang hu Dios ");
INSERT INTO bkd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","aman in-ila kandin sa balasahen ha insulat hi Isaias sa propita. Binekal din haena duun hu agkabayaan din agbasaha ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sa Balaan ha Ispiritu ha sinugù hu Dios uminulin dini ta kanak tumenged ta pinilì a kandin ha magsangyaw hu Maayad ha Tultulanen duun hu mga makaluluuy. Impadini a kandin ta daw matultulan ku sa mga purisu ha malibri sidan daw sa mga buta makaindan, mabuligan ku daan sa agdaeg-daegen ");
INSERT INTO bkd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","daw tultulan ku daan sidan ha makauma sa panahun ha luwasen hu Dios sa kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Su makapenga si Jesus magbasa inlikù din su balasahen duun ku mig-ila kandin dayun mininuu hu pagtudlù. Sa mga etaw uminahà diyà ta kandin ");
INSERT INTO bkd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","aman inikagiyan din sidan hu “Iman taini ha aldaw saini ha lalang hu Dios ha pigbasa ku natuman en.” ");
INSERT INTO bkd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Sa alan ha nakapaliman kandin migdayè kandin daw nabeleng daan sidan hu maayad ha lalang hi Jesus aman nanginginsà sidan hu “Kenà ba batà dà man hayana hi Jose?” ");
INSERT INTO bkd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ba inikagiyan sidan hi Jesus hu “Amin duma inyu ha nakahenà-henà hu ‘Mananambal, unaha bulunga sa ikaw ha dalu. Buhata daan duun taini ha banuwa nu sa napaliman day ha binuhat nu diyà ta Capernaum.’” ");
INSERT INTO bkd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Minikagi pa si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha sa propita harì agdawaten duun hu kandin ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ikagiyen ku inyu ha su anay ha panahun pa hi Elias sa propita nakauma sa kauhul tumenged ta hurà udan hu tatulu ha tuig daw tengà. Madakel ha mga Judio ha mga balu ha bahi sa miglised, ");
INSERT INTO bkd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ba si Elias hurà ipadiyà hu Dios ta kandan ta duun dà taena ha balu ha bahi ha kenà Judio diyà ta Sarepta ha sakup ta Sidon. ");
INSERT INTO bkd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Daw su anay ha panahun pa hi Eliseo sa propita daan madakel gayed sa mga Judio ha mga sanglahen, ba duun taena iyan dà naulian si Naaman sa kenà Judio ha taga-Siria.” ");
INSERT INTO bkd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Su mapaliman haena hu mga etaw diyà ta simbahan tungkay gayed sidan nangapauk. ");
INSERT INTO bkd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aman huminitindeg sidan daw abuga si Jesus duun taena ha banuwa, dayun ginuyud dan haena duun ku dalama ta agkabayaan dan en ngaay aghuluga. ");
INSERT INTO bkd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba si Jesus luminubuk duun ku mga etaw dayun hipanaw. ");
INSERT INTO bkd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Duminiyà si Jesus ta Capernaum ha sakup ta Galilea daw nanudlù diyà su Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sa kaet-etawan nangabeleng gayed ta sa pagtudlù hi Jesus amin duun gahem. ");
INSERT INTO bkd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Diyà ta simbahan amin etaw ha inulinan hu busaw ha tagkulahiay hu kagi din ");
INSERT INTO bkd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus ha taga-Nazaret, inu sa labet nu kanay? Duminini ka ba hu pagsilut kanay? Agkakilala ku ikaw ha sinugù ka hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ba binaldeng haena hi Jesus hu kagi din “Hagteng ka daw awà ka diyan tayan.” Pinaagi hu gahem ku busaw nabantang su etaw duun hu atubangan dan dayun guminuwà su busaw, ba su etaw hurà kabugel. ");
INSERT INTO bkd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Sa alan ha mga etaw diyà nangabeleng gayed daw miglalang-lalang hu kagi dan “Inu gid haini ha katudluanan? Ta saini ha etaw amin din gahem ha bisan sa mga busaw agkabugaw din.” ");
INSERT INTO bkd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sa tultulanen mahitenged ki Jesus nakalekep duun hu alan ha ubayà ha mga banuwa diyà. ");
INSERT INTO bkd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Uminawà si Jesus diyà ta simbahan daw duminiyà ta balay hi Simon. Agkagenaw sa ugang ha bahi hi Simon daw hinangyù dan si Jesus ha buligan din haena, ");
INSERT INTO bkd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","aman inubayan din dayun naulian. Sagunà haena migbangun daw sugbahi say Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Su madani en agpanukilem pinan-uwit hu mga etaw diyà ki Jesus sa mga etaw ha hurà mag-iling sa dalu dan, dayun dinampà sidan hi Jesus aman alan sidan naulian. ");
INSERT INTO bkd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Amin daan madakel ha mga busaw ha namangguwà duun hu mga etaw ha tagkulahiay hu kagi dan “Iyan ka gayed Batà hu Dios.” Ba binaldeng sidan hi Jesus ha harì mag-ikagiyà ta nakilala dan en ha si Jesus iyan su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Su maselem en huminipanaw si Jesus payanaen duun hu pinakabulung-bulung ha lugar aman pinan-ahà haena hu mga etaw. Su maahà dan en si Jesus pighawidan dan diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ba inikagiyan din sidan hu “Kinahanglan gayed ha sa Maayad ha Tultulanen mahitenged hu pagharì hu Dios isangyaw ku daan duun hu duma ha mga banuwa ta iyan haini indini ku ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aman nanudlù haena duun hu mga simbahan hu mga Judio diyà ta Judea. ");
INSERT INTO bkd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Amin aldaw ha diyà si Jesus tagtiyadeg ta kilid taena ha Danaw ta Genesaret ha inamul-amulan hu madakel tungkay ha mga etaw ha agkabayà agpaliliman hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naahà din diyà ta kilid ta danaw sa daruwa ha barutu ba kuminawas en sa taglulan duun ta aghenawan dan en sa mga baling dan. ");
INSERT INTO bkd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aman luminulan si Jesus duun taena ha barutu hi Simon daw ikagiyi din haena ha iiseg su barutu diyà ta wahig. Dayun mininuu duun daw panudlù hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Su makapenga si Jesus mag-ikagi sinugù din dayun si Simon hu “Idusù haini sa barutu diyà tayà ha madalem daw ilabya sa baling nuy ta daw makatimù kaw hu sedà.” ");
INSERT INTO bkd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ba si Simon tuminubag ha “Luminam-ag kay en gan hu pagpamaling ba hurà kay gayed makatimù. Ba tumenged ta insugù nu haini buhaten day gayed.” ");
INSERT INTO bkd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Su ilabya dan en sa mga baling nakatimù sidan hu madakel tungkay ha sedà aman apit en agkayahà sa mga baling dan. ");
INSERT INTO bkd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kinapayan dan su mga duma dan duun ku sabuwa ha barutu ta daw mabuligan sidan. Dayun su daruwa ha barutu napunù-punù gayed hu mga sedà na apit en daan haena agkalened. ");
INSERT INTO bkd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Su maahà hi Simon Pedro su nahitabù luminuhud diyà ta atubangan hi Jesus daw ikagi hu “Awà ka dini ta kanak, Ginuu, ta makasasalà a gayed.” ");
INSERT INTO bkd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Naikagi haena hi Simon ta nangabeleng gayed sidan taena ha madakel tungkay ha mga sedà ha natimù dan. ");
INSERT INTO bkd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iling daan ha nangabeleng si Santiago daw si Juan sa mga batà hi Zebedeo ha mga duma hi Simon. Dayun inikagiyan hi Jesus si Simon hu “Harì ka agkasamuk ta sugud iman mamamaling kad hu mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aman su guyuden dan en su barutu dan diyà ta gaun inawaan dan sa alan daw pamanduma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Su duun si Jesus hu sabuwa ha banuwa amin diyà etaw ha sanglahen. Su maahà din si Jesus luminuhud dayun diyà ta kandin daw hangyù hu “Ginuu, ku mabayà ka ngaay bulungen a ikaw taini ha mahugaw ha dalu ku.” ");
INSERT INTO bkd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dinampà hi Jesus su sanglahen daw ikagiyi hu “Agkabayà a aman maulian kad.” Sagunà haena naulian. ");
INSERT INTO bkd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dayun binalaudan hi Jesus hu “Harì ka manunultul hu bisan sin-u ba dumuun ka taena ha sinaligan hu paghalad ta daw masusi din ha naulian kad en. Maghalad ka sumalà hu Kasuguan hi Moises ta daw malimpyuwan ka daw matun-an hu mga etaw ha naulian kad en.” ");
INSERT INTO bkd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ba sa tultulanen mahitenged ki Jesus bà dà nasì nakalekep duun hu madiyù ha mga banuwa, aman madakel tungkay ha mga etaw sa nangaamul-amul diyà ta kandin ta daw mapaliman dan sa tigtudlù din daw maulian daan sa mga dalu dan. ");
INSERT INTO bkd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ba mahies ag-awà si Jesus duun hu mga etaw ta agduun haena hu pinakabulung-bulung ha lugar hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amin aldaw ha su tagpanudlù si Jesus amin daan tagpinuu ha mga Fariseo daw mga manunudlù hu Kasuguan ha napuun duun hu alan ha mga banuwa ha sakup ta Galilea daw ta Judea daw diyà daan ta Jerusalem. Si Jesus ginaheman hu Dios ta daw maulian din sa agkangadaluwan. ");
INSERT INTO bkd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Amin mga etaw ha nakauma ha taglanting hu minatay en sa dibaluy ha lawa din. Agkabayaan dan ngaay ag-uwita haena diyà ta seled ta balay duun hu atubangan hi Jesus ");
INSERT INTO bkd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ba tumenged ta madakel tungkay sa mga etaw hurà sidan makaseled. Aman namanahik sidan diyà ta atep daw pusuwi sa tenged hi Jesus dayun hinawil dan daan su agkadaluwan duun hu atubangan hi Jesus sa nalibutan hu madakel tungkay ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Su matun-an hi Jesus ha adagi gayed sa pagsalig dan inikagiyan din su agkadaluwan hu “Napasaylu en sa mga salà nu.” ");
INSERT INTO bkd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sa mga manunudlù hu Kasuguan daw sa mga Fariseo nakahenà-henà hu “Sin-u man haini sa tagtameyes hu Dios? Ta iyan dà gayed sa Dios makapasaylu hu salà.” ");
INSERT INTO bkd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ba sa mga henà-henà dan natun-an hi Jesus aman inikagiyan din sidan hu “Imbà kaw taghenà-henaay hu iling tayan? ");
INSERT INTO bkd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Inu diay sa malumu ha ikagiyen duun taini ha agkadaluwan? Iyan ba sa ‘Napasaylu en sa mga salà nu’ daw ku iyan ba sa ‘Bangun kad en daw hipanaw’? ");
INSERT INTO bkd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ba iman igpaahà ku inyu ha siak sa Suled hu Kaet-etawan amin ku kagahem dini ta kalibutan hu pagpasaylu hu mga salà.” Aman inikagiyan din su etaw ha minatay en sa dibaluy ha lawa din hu “Bangun kad, luluna sa banig nu daw ulì kad en.” ");
INSERT INTO bkd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Sagunà haena minangun daw uwita su banig din dayun ulì ha tagdayè hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sa alan ha mga etaw nangabeleng daw dinayè dan daan sa Dios hu kagi dan “Belenganen gayed sa naahà taw iman.” ");
INSERT INTO bkd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Su maiwas en haena huminipanaw si Jesus, dayun naahà din sa tagpinuu ha tagpanukut hu buhis ha tagngaranan ki Levi. Inikagiyan din haena ha “Dumuma ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aman huminitindeg si Levi daw inawaan din sa alan dayun duma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Miggastu si Levi diyà ta balay din para ki Jesus. Madakel ha mga manunukut hu buhis daw duma pa ha mga etaw sa nakigsalu kandan. ");
INSERT INTO bkd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ba sa mga Fariseo daw sa mga sakup dan ha manunudlù hu Kasuguan migtamudmud duun hu mga tinun-an hi Jesus ha tagyanaen “Imbà kaw pakigsalu hu mga limbungan ha mga manunukut hu buhis daw hu mga masinupaken?” ");
INSERT INTO bkd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ba tuminubag si Jesus hu “Sa harì agkadaluwan harì daan tagpabulung, ba sa agkadaluwan tagkinahanglan hu mamumulung. ");
INSERT INTO bkd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sa pagdini ku kenà para hu mga matareng en ba sa tuyù ku iyan sa mga makasasalà ta daw maghinulsul sidan.” ");
INSERT INTO bkd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amin mga etaw ha minikagi diyà ki Jesus hu “Sa mga sumusunud hi Juan ha Bautista daw sa mga sumusunud hu mga Fariseo mahies tagsalang hu pagkaen ta daw harì maelangan sa pag-ampù dan, ba sa ikaw ha mga tinun-an harì gayed tagsalang.” ");
INSERT INTO bkd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ba tuminubag si Jesus hu “Mabaluy ba diay ku amin kaamulan ha sa mga inimbita harì kumaen ku diyà pa ta kandan sa agpangasawa? Harì gayed haena mabaluy. ");
INSERT INTO bkd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ba mauma sa panahun ha ipaawà en diyà ta kandan su agpangasawa daw human sidan agsalang hu pagkaen.” ");
INSERT INTO bkd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amin pa pananglitan ha inikagi hi Jesus kandan ha tagyanaen “Hurà etaw ha agtapikan din hu bag-u ha manggad sa daan en ha pinaksuy, ta ku buhaten din haena mahigbit sa bag-u ha manggad daw nangkalain ha pag-ahaen ku makaamul duun hu daan en. ");
INSERT INTO bkd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iling daan ha hurà etaw ha itagù din sa bag-u pa ha binu duun hu daan en ha talaguay ha anis, ta ku buhaten din haena bà dà magbutu daw kahudhud su binu. ");
INSERT INTO bkd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kinahanglan gayed ha sa bag-u pa ha binu duun dà daan itagù hu bag-u pa ha talaguay. ");
INSERT INTO bkd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sa mga etaw ha naanad en pag-inum hu daan ha binu harì agkabayà ag-inum hu bag-u ta maayad kun sa daan en dì hu bag-u pa.” ");
INSERT INTO bkd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Amin aldaw hu Sabado ha nakaagi say Jesus duun hu uma. Su taghipanaw sidan namanimù sa mga tinun-an din hu bunga taena ha mga pamulahen duun daw kinaen dan. ");
INSERT INTO bkd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba amin mga Fariseo diyà ha nanginginsà hu “Imbà nuy supaka sa Kasuguan mahitenged hu Aldaw hu Paghimlay?” ");
INSERT INTO bkd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ba tuminubag si Jesus ha “Hurà nuy ba diay kabasa haena sa binuhat hi David su mangauhul sidan hu mga duma din? ");
INSERT INTO bkd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sumineled haena duun ku Tabernaculo daw kan-a su supas ha inhalad duun hu Dios dayun inilahan din su mga duma din bisan ku para dà ngaay haena hu mga sinaligan hu paghalad.” ");
INSERT INTO bkd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Dayun inikagiyan sidan hi Jesus hu “Siak sa Suled hu Kaet-etawan iyan a tagbayà hu Aldaw hu Paghimlay.” ");
INSERT INTO bkd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Duun hu lain en paman ha Sabado sumineled si Jesus duun hu simbahan hu mga Judio daw panudlù diyà. Amin daan etaw diyà ha kimay sa kawanan ha alima din. ");
INSERT INTO bkd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sa mga manunudlù hu Kasuguan daw sa mga Fariseo tagpan-ahà hu katarengan ta daw makasumbung dan si Jesus aman binantayan dan ku bulungen din ba haena duun hu Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ba natun-an hi Jesus sa henà-henà dan aman inikagiyan din su etaw ha nakimay hu “Hitindeg ka duun hu atubangan hu mga etaw.” Aman huminitindeg su kimay. ");
INSERT INTO bkd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dayun ininsaan sidan hi Jesus hu “Inu sa intugut hu Kasuguan ha buhaten taw duun hu Aldaw hu Paghimlay? Iyan ba sa pagbuhat hu maayad daw ku iyan ba sa madaet? Iyan ba sa pagluwas hu etaw daw ku iyan ba sa pagdaet kandin?” ");
INSERT INTO bkd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pig-ahà sidan hi Jesus daw ikagiyi su kimay ha “Bunhata sa alima nu.” Su bunhaten din haena sagunà naulian. ");
INSERT INTO bkd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba su mga Fariseo nangapauk gayed aman miglalang-lalang sidan ku inu sa buhaten dan ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Duun taena ha panahun duminuun si Jesus hu buntud daw luminam-ag mag-ampù duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Su maselem en inamul-amul din sa mga sumusunud din, dayun pinilì din sa sampulù daw daruwa daw pigngaranan din sidan ha mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saena iyan si Simon ha pigngaranan din ki Pedro daw si Andres sa suled din, si Santiago daw si Juan, si Felipe daw si Bartolome, ");
INSERT INTO bkd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo daw si Tomas, si Santiago sa batà hi Alfeo daw si Simon ha tagngaranan hu Patriyota, ");
INSERT INTO bkd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas sa batà hi Santiago daw si Judas Iscariote ha iyan miglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tuminubang si Jesus daw sa mga sumusunud din payanaen duun hu patag. Diyà daan sa madakel tungkay ha mga sumusunud din daw amin daan mga etaw ha nangapuun diyà ta Jerusalem daw duun hu alan ha mga banuwa ha sakup ta Judea daw hu mga banuwa ha kilid ta dagat ha ubayà ta Tiro daw ta Sidon. ");
INSERT INTO bkd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Saena ha mga etaw duminiyà ki Jesus hu pagpaliliman kandin daw hu pagpabulung hu mga dalu dan daw amin daan pigpasipalahan hu mga busaw ha naulian. ");
INSERT INTO bkd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sa agkangadaluwan agkabayà gayed ag-ibit kandin ta amin din gahem daw nangaulian din sa alan ha mga dalu dan. ");
INSERT INTO bkd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sumininalu si Jesus duun hu mga sumusunud din daw ikagi hu “Sinyu sa makaluluuy iman, malipayen kaw gayed ta agharian kaw hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Sinyu sa agkangauhul iman, malipayen kaw gayed ta mangabuhì kaw dà. “Sinyu sa taglugul iman, malipayen kaw dà asem. ");
INSERT INTO bkd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Malipayen kaw gayed ku kuntrahen kaw hu mga etaw daw harì kaw en kandan pagsimahen, ku sulaen kaw daan daw tameyesen kaw tumenged kanak siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ikalipay nuy gayed haena ta adagi tungkay sa igbales inyu hu Dios diyà ta langit, ta iyan daan haena binuhat dan duun hu mga propita. ");
INSERT INTO bkd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Sinyu sa mga sapian iman, kahid-u nuy gayed ta natimù nuy en sa pakapalipay inyu. ");
INSERT INTO bkd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Sinyu sa nangabuhì iman, kahid-u nuy gayed ta mauhul kaw dà asem. “Sinyu sa tagpatawahà iman, kahid-u nuy gayed ta maglugul kaw dà asem. ");
INSERT INTO bkd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kahid-u nuy gayed sinyu sa tagdayeen iman hu mga etaw ta iyan haena binuhat hu mga gin-apuan dan duun hu biduen ha mga propita. ");
INSERT INTO bkd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Sinyu sa tagpaliliman kanak, ikagiyen ku inyu ha palanggaa nuy sa mga kuntra nuy daw buhati hu maayad haena sa tagdumut inyu. ");
INSERT INTO bkd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ampui nuy haena sa tagtungayaw daw sa tagpasipala inyu ha mapanalanginan sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ku amin etaw ha laparuwen din sa dibaluy ha pipi nuy ipalaparu daan sa dibaluy. Ku amin etaw ha ag-agaw hu pinaksuy nuy iila en daan kandin sa kamasita nuy. ");
INSERT INTO bkd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ku amin manayù diyan ta inyu ilahi nuy, daw ku amin tumimù hu mga butang nuy harì nuy en haena bawien diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ku inu sa agkabayaan nuy ha buhaten diyan ta inyu hu mga duma nuy iyan daan haena buhaten nuy diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ku iyan dà palanggaen nuy sa daan en tagpalanggà inyu hurà taena pulus ta bisan sa mga makasasalà tagbuhaten dan daan haena. ");
INSERT INTO bkd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Daw ku iyan dà buhatan nuy hu maayad sa tagbuhat daan hu maayad diyan ta inyu hurà taena pulus ta bisan sa mga makasasalà tagbuhaten dan daan haena. ");
INSERT INTO bkd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ku iyan nuy dà daan sambayan sa natun-an nuy en ha makailis dà saena hurà din pulus, ta bisan sa mga makasasalà agsambayan dan daan sa makasasalà ta natun-an dan ha makailis daan haena. ");
INSERT INTO bkd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ba ikagiyen ku inyu ha palanggaa nuy sa mga kuntra nuy daw buhati sidan hu maayad. Sambayi daan sidan ha harì kaw en magsalap hu ilis. Ku buhaten nuy haena adagi gayed sa bales inyu daw iyan haena timaan ha batà kaw gayed hu Dios ha Magbabayà hu alan, ta sa Dios maluluy-en bisan duun hu mga madaet ha mga etaw daw hu harì tagpasalamat diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kahid-uwi nuy sa bisan sin-u iling hu Dios ha Amay nuy ha nahid-u daan hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Harì nuy aghukumi sa duma ha mga etaw daw harì kaw daan hukuman hu Dios. Pasayluwa nuy haena sa nakasalà diyan ta inyu daw pasayluwen kaw daan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mag-ila kaw daw ilahan kaw daan hu Dios, ta ku inu kadakel sa ig-ila nuy iyan daan haena kadakel hu ig-ila din inyu daw labaw pa iman sa iila din dì hu kinahanglanen nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Inikagiyan daan sidan hi Jesus taini ha pananglitan ha tagyanaen “Harì gayed mabaluy ha kipitan hu etaw ha buta sa duma din ha buta daan, ta ku buhaten din haena mangahulug gayed sidan duun hu bangbang. ");
INSERT INTO bkd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sa tagpatudlù kenà labaw dì hu tagtudlù kandin ba ku makapenga en sa tagtudluan mailing dà daan haena hu migtudlù kandin. ");
INSERT INTO bkd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Imbà nuy man tag-ahaaya sa puling hu duma nuy? Hurà nuy ba diay katun-i ha sa inyu ha puling iling kaadagi hu batang? ");
INSERT INTO bkd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Imbà kaw tag-ikagi ha ag-awaen nuy haena sa atiyuay ha puling hu duma nuy ha sa inyu ha puling bà daan su batang? Sinyu sa tagpasibù-sibù, unahen nuy gayed awaen sa puling nuy ha bà su batang na ku makaindan kaw en human nuy dayun awaa sa nakapuling duun hu duma nuy. ");
INSERT INTO bkd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Sa maayad ha kayu pulus dà gayed maayad sa bunga din, ba sa madaet ha kayu madaet en daan sa bunga din. ");
INSERT INTO bkd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Agkakilala taw sa kayu pinaagi hu bunga din ta harì kuy makapanimù hu libas daw hu bugkà duun hu sampinit. ");
INSERT INTO bkd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sa maayad ha etaw maayad daan sa agkaikagi din tumenged ta maayad sa henà-henà din, ba sa madaet ha etaw madaet daan sa agkaikagi din tumenged ta madaet sa henà-henà din. Ta ku inu sa duun hu henà-henà hu etaw iyan daan haena agkaikagi din. ");
INSERT INTO bkd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Imbà a inyu tagngarani ha Ginuu nuy ba harì kaw agtuu hu igsugù ku inyu? ");
INSERT INTO bkd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ikagiyen ku inyu ku inu sa agkailingan hu etaw ha tagpaliliman hu lalang ku daw magtuman daan taena. ");
INSERT INTO bkd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Agkailing haena hu etaw ha migbalay ha migbangbang hu tungkay madalem dayun impas-ek din su tukud daw siela hu mga batu. Su mamahà naagiyan haena hu wahig ba hurà gayed kakayug su balay ta tungkay nalig-enan. ");
INSERT INTO bkd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ba saena ha tagpaliliman hu lalang ku ba harì tagtuman agkailing hu etaw ha bà dà miglawig. Su mamahà sagunà dà haena napilay daw nakagas.” ");
INSERT INTO bkd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Su makapenga si Jesus mag-ikagi duun hu mga etaw duminiyà dayun ta Capernaum. ");
INSERT INTO bkd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Amin diyà kapitan hu sundalu ta Roma na amin din minahal ha suluguen ha apit en gayed agpatay hu dalu. ");
INSERT INTO bkd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Su mapaliman ku kapitan sa mahitenged ki Jesus pinasuguan din haena hu mga magulang ha Judio ta daw mahangyù dan ha bulungen din haena sa suluguen. ");
INSERT INTO bkd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Su makauma sidan diyà ki Jesus pinagayukan dan haena hu kagi dan “Saini ha kapitan hu sundalu angayan ha buligan nu ");
INSERT INTO bkd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ta palanggà kuy kandin sikuy sa mga Judio daw binuhatan kuy hu simbahan.” ");
INSERT INTO bkd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aman duminuma si Jesus kandan. Ba su ubay en sidan diyà ta balay amin impasal-aw kandan ku kapitan ta daw maikagiyan si Jesus hu “Ginuu, bay-an kad agdayun ta agkagayhà a ku dumini ka ta balay ku ");
INSERT INTO bkd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","daw kenà a daan angayan hu pagdiyan ta ikaw. Ba bà nu dà ikagiya ha maulian en haini sa suluguen ku. ");
INSERT INTO bkd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Natun-an ku ha mahimu nu haini ta siak suluguen a daan hu agalen ku ha sundalu daw amin daan mga sundalu ha sakup ku. Ku ipahipanaw ku sidan agtuu gayed sidan. Bisan inu sa igsugù ku hu suluguen ku agbuhaten din daan haena.” ");
INSERT INTO bkd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Su mapaliman haena hi Jesus nabeleng gayed dayun sumininalu duun hu mga kaet-etawan ha namanduma kandin daw migyanaen “Ikagiyen ku inyu ha hurà ku pa gayed naahà duun hu mga kaliwatan hi Israel ha agkailing taini sa pagtuu din.” ");
INSERT INTO bkd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Su makalikù en haena sa mga sinugù diyà ta balay naahà dan ha naulian en su suluguen. ");
INSERT INTO bkd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hurà kalugay duminuun si Jesus hu banuwa ha tagngaranan ta Nain daw namanduma daan sa mga tinun-an din daw sa madakel ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Su ubay en sidan ta pultahan ta kutà taena ha banuwa amin dan naahà ha taglanting hu minatay. Saena ha minatay maama ha sabubuwa dà ha batà hu bahi ha balu, daw madakel ha mga etaw duun taena ha banuwa sa namanduma kandin. ");
INSERT INTO bkd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Su maahà hi Jesus su bahi ha balu nahid-uwan din aman inikagiyan din hu “Harì ka tag-agalà.” ");
INSERT INTO bkd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dayun inubayan din haena sa lungun daw ibiti aman nakataleen su taglanting duun. Minikagi si Jesus hu “Bangun kad.” ");
INSERT INTO bkd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Migbangun haena sa minatay ha tag-ikagi en, dayun indiyà hi Jesus ki Inay din. ");
INSERT INTO bkd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sa alan ha mga etaw nangahaldek daw dinayè dan sa Dios ha tagyanaen “Sa labaw ha propita nakauma dini ta kanuy daw duminini sa Dios hu pagbulig hu mga etaw din.” ");
INSERT INTO bkd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Saena ha tultulanen mahitenged ki Jesus nakalekep duun hu alan ha mga banuwa diyà ta Judea daw hu ubayà taena. ");
INSERT INTO bkd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Tinultulan si Juan ha Bautista hu mga sumusunud din mahitenged hu alan ha binuhat hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aman inumaw hi Juan sa daruwa ha sumusunud din daw sugua diyà ki Jesus ha insaan dan hu “Iyan kad ba haena su intagnà ha makauma dini ta kalibutan daw ku amin pa ba lain ha pagsalapen day?” ");
INSERT INTO bkd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aman su makadiyà en sidan ki Jesus minikagi sidan hu “Impadini kay hi Juan hu pag-insà ku iyan kad ba haena su intagnà ha makauma dini ta kalibutan daw ku amin pa ba lain ha pagsalapen day.” ");
INSERT INTO bkd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Duun taena ha panahun naulian hi Jesus sa madakel ha mga etaw ha amin dan mga dalu daw binugaw din sa mga busaw ha uminulin duun hu mga etaw daw amin daan mga buta ha nakaindan. ");
INSERT INTO bkd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Aman tinubag sidan hi Jesus hu “Likù kaw diyà ki Juan daw tultuli hu napaliman nuy daw hu naahà nuy ha binuhat ku. Saena iyan sa nakaindan sa mga buta daw nakahipanaw sa mga pigket, nangaulian sa mga sanglahen daw nakapaliman en daan sa mga bengel. Amin en daan nabanhaw ha minatay daw sa Maayad ha Tultulanen insangyaw en daan duun hu mga makaluluuy ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Malipayen gayed sa etaw ha harì tagduwa-duwa hu pagsalig din kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Su umulì en haena sa mga sumusunud hi Juan inikagiyan hi Jesus sa mga kaet-etawan hu “Inu sa tuyù nuy su dumiyà kaw ki Juan duun taena ha pinakabulung-bulung ha lugar? Duminiyà kaw ba hu pag-ahà hu etaw ha agkailing hu salaysay ha ku agkalamagen agkahuyung dà? ");
INSERT INTO bkd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Duminiyà kaw ba daan ta daw maahà nuy sa tungkay madagway ha pinaksuy din? Hurà gayed ta sa etaw ha tagpinaksuy hu madagway daw mahayahay sa pagtimà din duun taw dà agkaahà hu mga balay hu harì. ");
INSERT INTO bkd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kenà ba iyan man inahà nuy diyà sa propita? Laus gayed ha propita si Juan daw labaw pa haena ");
INSERT INTO bkd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ta iyan en su sinubay duun hu insulat ha lalang hu Dios ha tagyanaen ‘Igpauna ku dì ikaw ta daw makapangandam hu ag-agiyan nu.’ ");
INSERT INTO bkd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ikagiyen ku inyu ha duun taini ha kalibutan hurà en labaw dì ki Juan, ba bisan sa kinaminusan ha tagharian hu Dios labaw pa daan dì ki Juan.” ");
INSERT INTO bkd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Su mapaliman haena hu mga etaw alan sidan bisan sa mga manunukut hu buhis ha nabautismuwan en hi Juan nakakilala ha hustu gayed sa mga paagi hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ba sa mga Fariseo daw sa mga manunudlù hu Kasuguan hurà dan dawata sa katuyuan kandan hu Dios aman hurà daan sidan kabautismuwi su anay hi Juan. ");
INSERT INTO bkd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Dayun minikagi si Jesus hu “Inu man sa agpailingan ku inyu? ");
INSERT INTO bkd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Agkailing kaw hu mga batà ha tag-alù-alù duun hu baligyaanan ha tag-ikagi duun hu mga duma dan hu ‘Tagkanta kay ba bà su hurà nuy duun labet. Taglugul kay ba harì kaw tag-agalà hu inyu.’ ");
INSERT INTO bkd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Su makauma si Juan ha Bautista sa tagsalang hu pagkaen daw hurà inum hu binu inikagi nuy ha bà dà haena agkalibeg. ");
INSERT INTO bkd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Siak sa Suled hu Kaet-etawan sa harì tagsalang hu pagkaen daw pag-inum kagi nuy paman ‘Ahà kaw tayana ha agapan daw beleng-beleng, sa mga amigu din mga limbungan ha mga manunukut hu buhis daw mga masinupaken.’ ");
INSERT INTO bkd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ba saena ha duminawat hu katudluanan ku daw hu ki Juan nakakilala ha hustu gayed sa mga paagi hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amin Fariseo ha mig-imbita ki Jesus hu pagkaen diyà ta balay din aman duminiyà si Jesus ta kandin daw kaen. ");
INSERT INTO bkd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Amin bahi duun taena ha banuwa ha makasasalà gayed. Su mapaliman din ha si Jesus tagkaen duun hu balay taena ha Fariseo duminiyà daan haena ha tag-uwit hu pahumut ha intagù duun hu butilya ha alabastro. ");
INSERT INTO bkd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Luminuhud su bahi ha tag-agalà diyà ki Jesus aman nalemeg sa paa hi Jesus hu mga luhà din. Tinarapuwan din sa paa hi Jesus ta buhuk din daw hadeki dayun hudhudi hu pahumut. ");
INSERT INTO bkd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Su maahà haena ku Fariseo ha mig-imbita ki Jesus nakahenà-henà haena ha “Ku laus pa haini ha propita matun-an din en ngaay ha makasasalà gayed haini sa bahi ha mig-ibit kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ba inikagiyan haena hi Jesus hu “Simon, amin ku ag-ikagiyen ikaw.” Tuminubag si Simon hu “Manunudlù, inu man?” ");
INSERT INTO bkd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Minikagi si Jesus hu “Amin daruwa ha etaw ha suminambay hu salapì duun hu sapian ha etaw, sa sabuwa suminambay hu lalima ha gatus daw sa sabuwa kalimahan dà. ");
INSERT INTO bkd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hurà sidan makailis aman bà din en haena linipati en. Sin-u man kandan sa adagi gayed sa pagpalanggà din ku sapian?” ");
INSERT INTO bkd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tuminubag si Simon hu “Iyan gid haena sa adagi sa sambay din ha linipatan.” Tuminubag daan si Jesus hu “Laus hayan.” ");
INSERT INTO bkd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dayun uminahà si Jesus duun ku bahi daw ikagiyi si Simon hu “Naahà nu ba haini sa bahi? Sumineled a dini ta balay nu ba hurà nu buhata sa sumalà ha naanadan taw. Hurà a ikaw ilahi hu wahig ha ighenaw ku ta paa ku, ba saini ha bahi hinenawan din sa paa ku hu luhà din daw tinarapuwan din ta buhuk din. ");
INSERT INTO bkd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hurà a ikaw tahuri ta hurà ka hadek kanak sumalà hu naanadan taw, ba saini ha bahi su pagseled din dini pighadekan din sa paa ku. ");
INSERT INTO bkd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hurà nu daan lanahi sa ulu ku, ba saini ha bahi inugsakan din hu pahumut sa paa ku. ");
INSERT INTO bkd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aman ikagiyen ku ikaw ha pinasaylu en sa madakel ha mga salà din ta adagi sa pagpalanggà din kanak. Ba saena ha atiyuay dà sa mga salà din ha napasaylu atiyuay dà daan sa pagpalanggà din.” ");
INSERT INTO bkd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dayun inikagiyan hi Jesus haena sa bahi hu “Pinasaylu en sa mga salà nu.” ");
INSERT INTO bkd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sa duma ha tuminampu duun ku miggastu nakahenà-henà hu “Inu gid haini ha etawa sa pakapasaylu hu salà?” ");
INSERT INTO bkd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ba inikagiyan hi Jesus su bahi hu “Sa ingkaluwas nu iyan sa pagsalig nu kanak aman ulì kad ha malinawen.” ");
INSERT INTO bkd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Su maiwas haena duminuun si Jesus hu migkalain-lain ha banuwa daw migsangyaw hu Maayad ha Tultulanen mahitenged hu pagharì hu Dios. Namanduma kandin sa sampulù daw daruwa ha tinun-an din ");
INSERT INTO bkd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","daw amin daan mga bahi ha nangadaluwan daw inulinan hu busaw su anay ha nangaulian en. Iyan haena sidan si Maria sa tagngaranan ki Magdalena ha iyan su ginuwaan hu pitu ha busaw, ");
INSERT INTO bkd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","si Juana sa asawa hi Cusa ha iyan sinaligan hi Herodes, si Susana daw amin pa gayed madakel ha mga bahi. Minulig sidan ki Jesus daw hu mga tinun-an din pinaagi hu pag-ila hu mga kinahanglanen dan. ");
INSERT INTO bkd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Su tagkaamul-amul sa madakel ha mga etaw ha nangapuun duun hu migkalain-lain ha banuwa minikagi si Jesus taini ha pananglitan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amin etaw ha duminiyà ta uma hu pagpamegas. Su isawed din haena sa binhì amin diyà dà nakatanà ta dalan aman nangagik-an daw pinanukà hu mga tagbis. ");
INSERT INTO bkd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amin daan binhì ha duun dà nakatanà hu batuwen. Su tumubù haena sagunà dà nangagangu ta mamada sa bugtà duun. ");
INSERT INTO bkd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amin daan binhì ha duun nakatanà hu sampiniten. Tuminubù daan haena ba naenep dà hu mga sampinit. ");
INSERT INTO bkd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ba amin binhì ha duun nakatanà hu balumbun ha bugtà. Saena tuminubù daan daw namunga gayed hu tignanggatus.” Dayun minikagi si Jesus hu “Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nanginginsà sa mga tinun-an hi Jesus ku inu sa kahulugan taena ha pananglitan. ");
INSERT INTO bkd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dayun tuminubag haena hu “Sa inlilung su anay mahitenged hu pagharì hu Dios impadayag en inyu. Ba sa duma ha mga etaw inikagiyan ku pinaagi hu mga pananglitan ta daw ‘Bisan ku mag-ahà sidan ba harì makaindan, daw magpaliliman daan sidan ba harì makasabut.’ ");
INSERT INTO bkd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Iyan haini kahulugan taena ha pananglitan mahitenged hu namegas. Saena ha insawed ha binhì iyan sa lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Su binhì ha diyà dà nakatanà ta dalan iyan su mga etaw ha nakapaliman hu lalang hu Dios ba sagunà pakauma si Satanas daw agawen din sa napaliman dan ta daw harì sidan makatuu daw harì maluwas. ");
INSERT INTO bkd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Su binhì ha duun dà nakatanà hu batuwen iyan su mga etaw ha nakapaliman hu lalang hu Dios daw sagunà duminawat taena ha malipayen ba harì agpanggamut sa pagtuu dan. Tuminuu hu mabàbà dà ha panahun ba ku makauma sa pagsulay ag-endà dà sidan hu pagtuu. ");
INSERT INTO bkd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Su binhì ha duun nakatanà ku sampiniten iyan su mga etaw ha nakapaliman en hu lalang hu Dios. Ba tumenged hu mga kasamukan dan daw hu kabayà dan ha magsapian sidan daw hu mga kalipayan dini ha kalibutan, sa lalang hu Dios agkalipatan dan dà aman sa bunga dan agkangapudu dà. ");
INSERT INTO bkd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ba su binhì ha duun nakatanà hu balumbun ha bugtà iyan su etaw ha nakapaliman hu lalang hu Dios daw duminawat gayed ha migpadayun hu pagtuman taena daw pinaagi hu pagkamainantusen dan mamunga gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hurà etaw ha tagtutud hu sulù ha bà din dà agpalangkebi hu bakag daw ku bà din dà ba daan igpadidalem duun hu katri, ba saena iluntud din gayed duun hu ugsakà ha matangkaw ta daw mailawan sa seled taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Sa alan ha iglilung iman makahiwal dà asem ku malugay daw sa harì iman tag-ikagiyen mapaliman dà asem ku malugay. ");
INSERT INTO bkd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aman panday kaw gayed magpaliliman ta sa etaw ha amin en kandin mailahan hu tungkay pa gayed madakel, ba saena ha hurà din en hu kandin bisan su iyan-iyan din dà agtimuen pa gayed haena diyà ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nakauma sa inay hi Jesus daw sa mga suled din ha maama ta agkabayà pakig-ahà kandin, ba hurà sidan makaubay diyà ta kandin tumenged ta madakel tungkay sa mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Amin etaw ha uminikagi diyà ki Jesus hu “Si Inay nu daw sa mga suled nu diyà tagtiyadeg ta guwà ta agkabayà kun sidan pakig-ahà ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba si Jesus tuminubag hu “Bisan sin-u sa tagpaliliman hu lalang hu Dios daw tagtuman daan taena iyan en haena inay ku daw mga suled ku.” ");
INSERT INTO bkd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Amin aldaw ha inikagiyan hi Jesus sa mga tinun-an din ha “Lumayun kuy duun taini ha danaw.” Aman luminulan sidan hu barutu daw pamanlayun. ");
INSERT INTO bkd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Su taglulan en sidan nakatiduga si Jesus. Dayun namagyu aman nataguan hu wahig su barutu na apit en sidan agkalened. ");
INSERT INTO bkd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aman pinukaw hu mga tinun-an si Jesus hu kagi dan “Ginuu, agkalened kuy en.” Migbangun si Jesus daw baldenga sa kalamag daw adagi ha mga baled aman sagunà migleneng. ");
INSERT INTO bkd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Inikagiyan din su mga tinun-an din hu “Hindu en diay sa pagsalig nuy kanak?” Sa mga tinun-an hi Jesus tungkay gayed nangahaldek daw nangabeleng aman migpainsaay sidan hu “Inu gid haini ha etawa ha bisan sa kalamag daw mga baled agtuu kandin?” ");
INSERT INTO bkd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Si Jesus daw sa mga tinun-an din duminiyà ta ubay ta Gadara layun ta probincia ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Amin etaw ha taga-Gadara ha inulinan hu mga busaw. Su anay tagbakusaen haena hu kadina daw bantayi, ba bà dà agpamugtua taena dayun inuwit hu busaw duun hu pinakabulung-bulung ha lugar. Nalugay en ha duun dà tagtimà hu panlebengà ha harì en daan tagpinaksuy. Su pagkawas hay Jesus sinal-aw dayun sidan ku etaw ha inulinan hu busaw. Su maahà din si Jesus nakapangulahì haena dayun nakadaghà diyà ta bugtà diyà ta atubangan hi Jesus daw nangulahì ha tagyanaen “Jesus ha Batà hu Dios ha Magbabayà hu alan, inu sa labet nu kanak? Aghangyuen ku ikaw ha harì a ikaw pasipalahan.” Lukas 8:27-29 Naikagi din haena ta inikagiyan hi Jesus ha umawà su busaw. ");
INSERT INTO bkd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ininsaan haena hi Jesus hu “Sin-u sa ngaran nu?” Tuminubag hu “Libu-libuwen” tumenged ta madakel en sa busaw ha uminulin kandin. ");
INSERT INTO bkd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dayun su mga busaw tagpagayukà diyà ki Jesus ha harì sidan ilambeg duun ku bitu ha tungkay gayed madalem. ");
INSERT INTO bkd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ubay diyà ta kandan sa balalayan ha amin duun madakel tungkay ha mga babuy ha tagpanuwalà. Pinagayukan ku mga busaw si Jesus ha ipaulì sidan duun ku mga babuy. Tinugutan din en daan sidan ");
INSERT INTO bkd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","aman guminuwà su mga busaw duun ku etaw daw namanagù duun ku mga babuy. Namamulaguy su mga babuy diyà ta alug daw nangakasabay sidan duun ku danaw dayun nangalemes. ");
INSERT INTO bkd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Su mga etaw ha tagbantay ku mga babuy nakaahà taena ha naul-ulahan aman namamulaguy sidan payanaen diyà ta banuwa daw duun hu ubayà ha mga lugar daw intultul dan su nahitabù. ");
INSERT INTO bkd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dayun namandiyà sa mga etaw ta ag-ahaen dan su nahitabù. Su makauma sidan diyà ki Jesus naahà dan su etaw ha inulinan hu mga busaw su anay ha tagpinuuwà diyà ta atubangan hi Jesus ha maayad en sa henà-henà din daw migpinaksuy en, aman su mga etaw nangahaldek gayed. ");
INSERT INTO bkd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Su nakaahà taena nanunultul dayun ku nainu-inu sa kaulii taena ha inulinan hu mga busaw. ");
INSERT INTO bkd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ba su mga etaw ha nangapuun duun hu mga banuwa ha ubay ta Gadara huminangyù ki Jesus ha umawà si Jesus diyà ta kandan ta agkahaldekan gayed sidan. Aman luminulan si Jesus hu barutu ta ag-awà diyà. ");
INSERT INTO bkd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Su aglulan en si Jesus ku barutu huminangyù su naulian ha agduma ngaay. Ba bà dà inikagiyi hi Jesus ha ");
INSERT INTO bkd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Umulì kad daw itultul sa binuhat hu Dios ikaw.” Aman huminipanaw su naulian daw linekep din su banuwa hu pagpanunultul ku inu kaadagi sa binuhat kandin hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Su makalikù si Jesus diyà ta layun madakel ha mga etaw sa tag-angat diyà ha migdawat kandin. ");
INSERT INTO bkd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Amin daan punuan duun hu simbahan hu mga Judio ha nakauma ha tagngaranan ki Jairo. Luminuhud haena diyà ta atubangan hi Jesus dayun minagayuk ha dumiyà si Jesus ta balay din ");
INSERT INTO bkd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ta agpatay en su sabubuwa dà ha laga-laga din ha sampulù en daw daruwa sa tuig taena. Su taghipanaw en si Jesus naamul-amulan hu madakel tungkay ha mga etaw ha agpakalipit kandin. ");
INSERT INTO bkd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Amin daan bahi diyà ha sampulù en daw daruwa ha tuig sa kahudhud din. Naamin en sa salapì din pagbayad hu tagpamulung ba hurà gayed kaulii. ");
INSERT INTO bkd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uminubay haena diyà ta talikudan hi Jesus daw ibiti sa sagayadan hu pinaksuy taena dayun sagunà naulian. ");
INSERT INTO bkd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nanginginsà si Jesus hu “Sin-u sa uminibit hu pinaksuy ku?” Namalibad sa mga etaw aman minikagi si Pedro hu “Ginuu, madakel man ha mga etaw sa agpakalipit ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ba tuminubag si Jesus hu “Amin gayed uminibit kanak ta nagedam ku ha amin naulian pinaagi hu gahem ku.” ");
INSERT INTO bkd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Su matun-an ku bahi ha natun-an diay hi Jesus hinugdunan haena hu kahaldek din daw luhud diyà ki Jesus. Duun hu atubangan taena ha mga etaw inikagi din sa hinengdan imbà din ibiti sa pinaksuy hi Jesus daw sa ingkaulii din. ");
INSERT INTO bkd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dayun inikagiyan hi Jesus hu “Sa ingkaulii nu iyan sa pagsalig nu kanak. Ulì ka ha malinawen.” ");
INSERT INTO bkd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Su kamulu pa si Jesus tag-ikagi nakauma sa mga etaw ha napuun ta balay hi Jairo su punuan taena ha simbahan ha tagyanaen “Su laga-laga nu minatay en aman harì nud en agsamuka sa Manunudlù.” ");
INSERT INTO bkd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ba su mapaliman haena hi Jesus inikagiyan din si Jairo hu “Harì ka agkasamuk ba bà ka dà salig kanak daw maulian su batà nu.” ");
INSERT INTO bkd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Su makauma en sidan diyà ta balay hi Jairo iyan dà dinuma hi Jesus diyà ta seled si Pedro daw si Juan, si Santiago daw sa mga laas taena ha batà. ");
INSERT INTO bkd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sa alan ha mga etaw diyà tag-agalaay ta taglulugul sidan, ba inikagiyan sidan hi Jesus hu “Harì kaw tag-agalaay ta saini ha batà hurà patay ba bà dà tagtiduga.” ");
INSERT INTO bkd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bà dan dà agkapatawahi si Jesus ta natun-an dan ha minatay en gayed su batà. ");
INSERT INTO bkd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ba inibitan hi Jesus sa alima ku batà daw ikagiyi hu “Sikaw sa batà, bangun kad.” ");
INSERT INTO bkd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Sagunà haena nakagahinawa daw minangun. Dayun suminugù si Jesus ha ilahan haena hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Su mga laas ku laga-laga tungkay gayed nangabeleng, ba binalaudan sidan hi Jesus ha harì dan itultul duun hu bisan sin-u haena sa nahitabù. ");
INSERT INTO bkd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Amin panahun ha inamul-amul hi Jesus su sampulù daw daruwa ha tinun-an din dayun sinugù din sidan hu pagpanunultul mahitenged hu pagharì hu Dios daw pinagaheman din sidan ta daw maulian dan sa agkangadaluwan daw mabugaw dan sa mga busaw ha uminulin duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Inikagiyan din sidan ha “Ku humipanaw kaw harì kaw mag-uwit hu bisan inu iling hu sugkud daw hu lutù nuy, hu salapì daw hu ilisan nuy. ");
INSERT INTO bkd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bisan sin-u ha tagibalay sa magpaseled inyu duun kaw en magtimà taman ha umawà kaw duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ku makaduun kaw hu banuwa ba hurà en dumawat inyu awai haena, ba pugpuga nuy sa aliyabuk diyan ta paa nuy ta iyan haena timaan ha silutan gayed sidan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aman namanhipanaw su mga tinun-an hi Jesus daw pamanduun hu migkalain-lain ha banuwa ha migsangyaw hu Maayad ha Tultulanen daw naulian dan daan sa agkangadaluwan duun hu bisan hindu. ");
INSERT INTO bkd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Su mapaliman hi Herodes ha harì ta Galilea sa mga nahitabù nalibeg gayed ku sin-u si Jesus, ta sa duma tag-ikagi ha iyan kun haena si Juan ha Bautista ha nabanhaw, ");
INSERT INTO bkd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","sa duma tag-ikagi ha iyan en kun haena si Elias ha nakahiwal daw sa duma tag-ikagi ha nabanhaw sa sabuwa duun taena ha mga propita su anay. ");
INSERT INTO bkd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ba uminikagi si Herodes hu “Pinapungulan kud en si Juan. Sin-u man gid haini sa tagsubayen hu mga etaw?” Aman agkabayaan din gayed ag-ahaa si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Su makalikù en haena sa mga apostoles ha sinugù hi Jesus intultul dan diyà ta kandin sa alan ha nangabuhat dan. Dayun dinuma sidan hi Jesus ha iyan dà sidan payanaen duun ku banuwa ha tagngaranan ta Betsaida. ");
INSERT INTO bkd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Su matun-an haena hu kaet-etawan namanlupug sidan. Nahid-uwan sidan hi Jesus aman tinultulan din sidan mahitenged hu pagharì hu Dios daw naulian din daan sa agkangadaluwan. ");
INSERT INTO bkd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Su panday en agkahapun inikagiyan si Jesus hu mga tinun-an din ha “Sugua nud en sa mga etaw ha mamanduun sidan hu ubayà ha mga banuwa ta daw makapan-ahà sidan hu agkan-en dan daw hu matidugahan dan ta pinakabulung-bulung haini ha lugar.” ");
INSERT INTO bkd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ba tuminubag si Jesus hu “Iyan kaw en mag-ila kandan hu pagkaen.” Uminikagi sidan hu “Amin dini pagkaen ba lalima dà ha buuk ha supas daw daruwa dà daan ha buuk ha sedà. Agkabayà ka ba ha mamalit kay pa hu igpakaen taini ha mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ta lalima ha libu sa kadakelen hu mga maama. Ba inikagiyan hi Jesus sa mga tinun-an din hu “Ipapinuu sa mga etaw hu tigkalimahan.” ");
INSERT INTO bkd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aman binuhat dan su insugù hi Jesus daw namaminuu su mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tinimù hi Jesus su lalima ha supas daw su daruwa ha sedà dayun huminangad diyà ta langit daw ampui haena. Su makapenga en mag-ampù pinangebing din su supas daw su sedà daw sugua su mga tinun-an din ha ipakaen haena hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Su mangabuhì en sidan pinangamul hu mga tinun-an su nasamà duun, saena sampulù pa daw daruwa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Amin panahun ha mig-ampù si Jesus ha iyan dà. Sa mga tinun-an din uminubay diyà ta kandin aman ininsaan din sidan hu “Sin-u a man duun hu pag-ikagi hu mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tuminubag sidan hu “Sa duma tag-ikagi ha iyan ka kun si Juan ha Bautista daw sa duma tag-ikagi daan ha iyan ka kun si Elias, sa duma tag-ikagi ha sabuwa ka duun hu mga propita su anay ha nabanhaw.” ");
INSERT INTO bkd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dayun ininsaan sidan hi Jesus hu “Sinyu, sin-u a man duun hu henà-henà nuy?” Tuminubag si Pedro hu “Iyan ka su Mesiyas ha sinugù hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Binalaudan hi Jesus su mga tinun-an din ha harì gayed sidan manunultul ha si Jesus iyan en su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Minikagi daan si Jesus hu “Kinahanglan ha siak sa Suled hu Kaet-etawan mag-antus a hu madakel ha mga pasipala daw pagtameyesen a hu mga magulang daw hu mga labaw ha sinaligan hu paghalad daw hu mga manunudlù hu Kasuguan. Daw kinahanglan daan ha pahimatayan a kandan ba duun hu ikatulu ha aldaw mabanhaw a dà.” ");
INSERT INTO bkd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dayun minikagi si Jesus duun hu kaet-etawan hu “Bisan sin-u sa agkabayà agsunud kanak kinahanglan ha lipatan din gayed sa kandin ha agkabayaan daw aldaw-aldaw antusen din sa alan ha mga malegen bisan duun hu kamatayen ta daw makasunud kanak. ");
INSERT INTO bkd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak bisan duun hu kamatayen mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Inu man sa pulus hu etaw ku maangken din sa tibuuk ha kalibutan ba malaag sa kinabuhì din? ");
INSERT INTO bkd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bisan sin-u haena sa ikagayhà din sa pagsunud kanak daw sa mga lalang ku siak sa Suled hu Kaet-etawan ikagayhà ku daan asem haena ku lumikù a dini ha magpangaluanlag iling hu Dios ha Amay ku daw hu mga balinsuguen din. ");
INSERT INTO bkd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Laus gayed sa ag-ikagiyen ku inyu ha amin inyu tagtiyadeg dini iman ha harì pa matay na maahà dan en sa pagharì hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Su nangkasimana en sa kaikagiya hi Jesus taena dinuma din si Pedro, si Juan daw si Santiago duun hu bubungan hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Su kamulu pa si Jesus tag-ampù tigkan haena nahalin daw sa pinaksuy din tagpangaluanlag ha ben kaputì en gayed. ");
INSERT INTO bkd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tigkan daan nakahiwal sa daruwa ha etaw ha iyan si Moises daw si Elias ");
INSERT INTO bkd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ha tagpangaluanlag daan daw nakiglalang ki Jesus. Sa piglalangan dan iyan sa kamatayen hi Jesus ha madani en matuman diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si Pedro daw sa mga duma din agpandayen agtidugahen ba naahà dan sa pagpangaluanlag hi Jesus daw hu mga duma din. ");
INSERT INTO bkd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Su ag-awà en su daruwa diyà ki Jesus inikagiyan dayun hi Pedro si Jesus hu “Ginuu, maayad ta dini kay. Buhatan day inyu hu tatulu ha lawig ta daw matukid kaw ki Moises daw ki Elias.” Ba hurà katun-i hi Pedro ku inu sa tag-ikagiyen din. ");
INSERT INTO bkd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Su tag-ikagi pa si Pedro amin gabun ha nakabungkus kandan aman nangahaldek gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dayun amin lageng ha napuun duun ku gabun ha tagyanaen “Iyan en haini Batà ku ha pinilì ku aman magpaliliman kaw kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Su maiwas haena sa lageng iyan dà naahà dan si Jesus. Duun taena ha panahun hurà gayed itultul hu mga tinun-an su naahà dan. ");
INSERT INTO bkd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Su maisab ha aldaw ha tumubang si Jesus daw sa tatulu ha tinun-an din duun taena ha bubungan sinal-aw sidan hu madakel tungkay ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Amin diyà etaw ha nangumaw hu “Ginuu, kahid-uwi sa batà ku ha maama ta sabubuwa dà haini. ");
INSERT INTO bkd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ku ag-ulinan haini hu busaw agpakakulahì daw agkabidbid ha tagbulà-bulà sa bàbà din. Malagdà dà ag-awà diyà ta kandin sa busaw daw agpakadaet haena kandin. ");
INSERT INTO bkd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hinangyù kud sa mga tinun-an nu ha ipaguwà dan su busaw ba hurà dan gayed kahimu.” ");
INSERT INTO bkd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Minikagi si Jesus hu “Sinyu ha mga etaw sa harì agtuu daw suminuway duun hu pagkamatareng, nalugay en sa pagduma-dumahà taw. Inu pa diay kalugay sa pag-angat ku ha tumuu kaw kanak?” Dayun inikagiyan din su amay ha “Uwita dini sa batà nu.” ");
INSERT INTO bkd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Su tagdiyà en su batà tigkan inulinan hu busaw aman nakadaghà diyà ta bugtà daw nabidbid. Ba binaldeng hi Jesus haena sa busaw daw naulian su batà dayun indiyà hi Jesus ki Amay din. ");
INSERT INTO bkd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nangabeleng sa alan ha mga etaw hu pagkagamhanan hu Dios. Su kamulu pa sa mga etaw agkabeleng hu binuhat hi Jesus inikagiyan din sa mga tinun-an hu ");
INSERT INTO bkd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Palilimani nuy gayed haini sa ag-ikagiyen ku iman inyu ha siak sa Suled hu Kaet-etawan laus ad en itugyan duun hu aghimatay kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba hurà dan katun-i sa kahulugan taena ha inikagi din ta inheles haena kandan ta daw harì dan pa masabut, daw nahaldek daan sidan hu pagpanginginsà ki Jesus mahitenged taena. ");
INSERT INTO bkd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Migsawalà sa mga tinun-an hi Jesus ku sin-u sa labaw kandan. ");
INSERT INTO bkd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ba natun-an hi Jesus sa henà-henà dan aman tinimù din sa sabuwa ha atiyuay ha batà daw ipaabay kandin. ");
INSERT INTO bkd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Dayun inikagiyan din sidan hu “Bisan sin-u sa agdawat taini ha batà tumenged kanak agdawat daan kanak, daw saena ha agdawat kanak agdawat daan hu Dios ha migsugù kanak. Ta saena ha kinaminusan diyan ta inyu iyan labaw hu alan.” ");
INSERT INTO bkd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Minikagi si Juan hu “Ginuu, amin day naahà ha etaw ha migbugaw daan hu mga busaw pinaagi hu ngaran nu aman binaldeng day haena ta kenà taw man duma.” ");
INSERT INTO bkd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ba tuminubag si Jesus hu “Harì nuy haena agbaldenga ta sa etaw ha harì agsupak kanuy duma taw daan.” ");
INSERT INTO bkd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Su madani en si Jesus aglikù diyà ta langit nahenhenaan din ha dumiyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Amin din impauna duun hu sabuwa ha banuwa diyà ta Samaria ta daw maandam sa kinahanglanen din. ");
INSERT INTO bkd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ba sa mga etaw duun taena ha banuwa harì agkabayà ha umagi si Jesus diyà ta kandan ta natun-an dan en ha saena Judio ha tagdiyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Su matun-an haena hu mga tinun-an din ha si Santiago daw si Juan inikagiyan dan si Jesus hu “Ginuu, agkabayà ka ba ha ipabulus day sa hapuy ta daw mangasunug sidan?” ");
INSERT INTO bkd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ba si Jesus sumininalu diyà ta kandan daw baldenga sidan, ");
INSERT INTO bkd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","dayun duminuun say Jesus hu lain ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Su taghipanaw en si Jesus diyà ta dalan amin etaw ha minikagi diyà ta kandin hu “Agduma a ikaw bisan hindu ka duun agpayanaen.” ");
INSERT INTO bkd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ba tuminubag si Jesus hu “Sa laku amin din tagtimaan daw sa mga tagbis amin dan daan mga dalagpuay, ba siak sa Suled hu Kaet-etawan hurà ku himlayà.” ");
INSERT INTO bkd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Amin pa sabuwa ha etaw ha inikagiyan hi Jesus ha “Dumuma ka kanak.” Ba tuminubag haena hu “Ginuu, harì a pa makaduma ikaw iman ta iglebeng ku pa si Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Inikagiyan haena hi Jesus ha “Su mga etaw ha hurà dan pa kinabuhì iyan en maglebeng hu mga minatay, ba sikaw hipanaw ka daw isangyaw nu sa mahitenged hu pagharì hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Amin pa daan etaw ha minikagi hu “Ginuu, agduma a ikaw ba agpanamilit a pa enà duun hu pamilya ku.” ");
INSERT INTO bkd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Si Jesus tuminubag ha “Hurà gayed pulus hu etaw ha tagharian hu Dios ku agkailing taena ha tag-ibit en hu daru ba taglingiay pa diyà ta kahudiyanan.” ");
INSERT INTO bkd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Su maiwas en haena pinilì hi Jesus su kapituwan daw daruwa ha sumusunud din daw sinugù din sidan ha tigdaruwa ha dumuun hu alan ha mga banuwa ha ag-elegan din daan. ");
INSERT INTO bkd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dayun inikagiyan din sidan hu “Maluag gayed sa legtayen daw napanday en nahinug ba atiyuay dà sa agpamanlegtay duun. Aman humangyù kaw duun hu Dios ha suguen din sa mga mamanlegtay taini ha uma din. ");
INSERT INTO bkd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hipanaw kaw daw henhenaa nuy ha agkailing kaw hu mga nati hu karniro ha agsuguen ku duun hu mga etaw ha agkailing hu asu ha agpamangagat. ");
INSERT INTO bkd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Harì kaw mag-uwit hu salapì daw hu lutù nuy daw hu sapatus nuy. Harì kaw daan tagyawatà tumenged hu mga agkasal-aw nuy dini ta dalan. ");
INSERT INTO bkd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bisan sin-u ha tagibalay sa magpaseled inyu ikagiyi sidan hu ‘Magmalinawen kaw gayed alan.’ ");
INSERT INTO bkd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saena ha dumawat inyu malinawen gayed sa pagtimà dan, ba ku harì kaw kandan dawaten hurà pulus ku umikagi kaw ha malinawen gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Harì kaw taghalin-halin hu tagtimaan nuy ba duun kaw en magtimà hu balay ha maseledan nuy. Bisan inu sa ipakaen dan inyu kan-en nuy ta sa tagtalabahu angayan ha suhulan. ");
INSERT INTO bkd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bisan hindu kaw duun makapayanaen ha dawaten kaw kandan bisan inu sa ig-ila dan ha makaen kan-en nuy daan. ");
INSERT INTO bkd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Maulian nuy sa agkangadaluwan duun taena ha banuwa daw tultuli sidan ha sa pagharì hu Dios ubay en diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ku makaduun kaw hu banuwa ba hurà en dumawat inyu hipanaw kaw duun hu mga dalan dan daw ikagiyi sidan hu ");
INSERT INTO bkd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Bisan sa aliyabuk dini ta paa day agpugpugen day ta iyan haini timaan ha saini ha banuwa nuy silutan gayed hu Dios. Ba laus gayed ha sa pagharì hu Dios ubay en.’ ");
INSERT INTO bkd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ikagiyen ku inyu ha asem ku Aldaw hu Paghukum mahagkap dà sa isilut hu Dios taena ha mga etaw diyà ta Sodoma dì hu mga etaw iman duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Sinyu sa taga-Corazin daw taga-Betsaida, kahid-u nuy gayed ta sa mga belenganen ha binuhat ku diyan ta inyu ku naahà pa ngaay hu kenà mga Judio diyà ta Tiro daw ta Sidon maghinulsul gayed sidan daw magbasul hu mga salà dan. ");
INSERT INTO bkd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ba asem ku Aldaw hu Paghukum mahagkap dà sa isilut hu Dios taena ha mga etaw diyà ta Tiro daw ta Sidon dì hu inyu. ");
INSERT INTO bkd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Daw sinyu daan sa taga-Capernaum, kagi nuy ha iyan kaw en mga matangkaw ha etaw ba ilambeg kaw asem diyà ta Kamatayan.” ");
INSERT INTO bkd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dayun si Jesus minikagi duun hu mga sinugù din hu “Bisan sin-u sa magpaliliman inyu magpaliliman daan kanak. Saena ha harì agdawat inyu harì daan agdawat kanak, daw sa harì agdawat kanak harì daan agdawat hu Dios ha migsugù kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Su makalikù haena sa kapituwan daw daruwa malipayen gayed sidan ha tagyanaen “Ginuu, bisan sa mga busaw tuminuu kanay su bugawen day pinaagi hu ngaran nu.” ");
INSERT INTO bkd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tuminubag si Jesus hu “Naahà ku ha nahulug si Satanas iling hu kilat. ");
INSERT INTO bkd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ginaheman kud inyu ha bisan ku makagiek kaw hu bunsalagan daw banayaw ba harì kaw makagat. Madaeg nuy daan sa gahem hi Satanas daw hurà gayed makapasipala inyu. ");
INSERT INTO bkd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba harì nuy iyan ikabayà-bayà ha tuminuu inyu sa mga busaw, ba iyan nuy ikabayà-bayà ta nakasulat en sa ngaran nuy diyà ta langit.” ");
INSERT INTO bkd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Duun taena ha panahun si Jesus nalipay gayed pinaagi hu Balaan ha Ispiritu daw mig-ampù hu “Amay ku ha Magbabayà hu alan diyan ta langit daw dini ta kalibutan, adagi sa pagpasalamat ku ikaw ta sa inlilung duun hu mga matatau daw hu nangakatunghà ha mga etaw impadayag nud en duun hu mga etaw ha harì pa agkatuen iling hu mga batà. Aman Amay ku, tagpasalamat a gayed diyan ta ikaw hu kabuhata nu duun tumenged ta iyan haena agkabayà-bayaan nu.” ");
INSERT INTO bkd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Minikagi si Jesus duun hu mga etaw hu “Insalig en kanak hu Dios ha Amay ku sa alan. Iyan dà haena nakakilala kanak daw iyan a dà daan nakakilala kandin daw iyan dà daan sa mga etaw ha agkabayaan ku ha makakilala kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dayun sumininalu si Jesus duun ku mga tinun-an din ha iyan dà sidan daw ikagiyi hu “Malipayen kaw gayed ta naahà nuy sa binuhat ku. ");
INSERT INTO bkd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ta ikagiyen ku inyu ha madakel ngaay sa mga propita daw mga harì ha agkabayà tungkay ag-ahà hu naahà nuy iman daw agpaliliman ngaay daan hu napaliman nuy iman, ba hurà dan en gayed haena kahimu.” ");
INSERT INTO bkd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Amin sabuwa ha manunudlù hu Kasuguan ha duminiyà ki Jesus hu pagsulay kandin aman nanginginsà hu “Manunudlù, inu man sa kinahanglan ha buhaten ku ta daw mailahan a hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tuminubag si Jesus hu “Inu sa ikaw ha kasabuta hu nakasulat duun hu Kasuguan?” ");
INSERT INTO bkd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Minikagi su etaw hu “Palanggaa gayed sa Dios ha Magbabayà nuy daw palanggaa daan sa mga duma nuy iling hu pagpalanggà nuy hu kaugalingen nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Dayun minikagi si Jesus hu “Laus hayan aman buhata haini daw amin nu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ba saena ha manunudlù hu Kasuguan agkabayà tagpaahà ha matareng hu kandin aman ininsaan din si Jesus hu “Sin-u man sa mga duma ku ha palanggaen ku?” ");
INSERT INTO bkd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tuminubag si Jesus pinaagi hu pananglitan ha tagyanaen “Amin Judio ha napuun diyà ta Jerusalem ha tagdiyà ta Jerico ba tinulis haena. Linebasan dan daw pigbunalaan dayun inawaan dan su apit en agpatay. ");
INSERT INTO bkd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Amin sinaligan hu paghalad ha nakaagi duun taena ha dalan, ba su maahà din su tinulis bà dà haena luminidas. ");
INSERT INTO bkd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nakauma daan sa kaliwat hi Levi ha magbubulig hu mga sinaligan hu paghalad, ba su maahà din haena iling daan ha bà dà luminidas. ");
INSERT INTO bkd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ba amin taga-Samaria ha nakauma duun taena ha tinulis. Su maahà din haena bisan ku kenà Judio hu kandin ba nahid-uwan din su tinulis. ");
INSERT INTO bkd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aman inubayan din daw bulunga haena hu lana daw binu, dayun impalulan duun ku kabayu din daw uwita duun hu balay ha hulabungà daw alimahi duun. ");
INSERT INTO bkd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Su maisab ha aldaw inikagiyan din haena sa tag-iya hu balay hu ‘Taini sa salapì. Tanula haini sa etaw. Ku kulang pa haini sa salapì ku ag-isaban ku dà asem ku makalikù a.’” ");
INSERT INTO bkd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dayun ininsaan hi Jesus su manunudlù hu Kasuguan hu “Hindu man sa laus ha duma taena ha Judio ha tinulis?” ");
INSERT INTO bkd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tuminubag haena hu “Iyan su nahid-u kandin.” Aman minikagi si Jesus hu “Laus hayan aman buhata nu haini.” ");
INSERT INTO bkd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Su taghipanaw si Jesus daw sa mga tinun-an din nakauma sidan duun hu sabuwa ha banuwa. Amin diyà bahi ha tagngaranan ki Marta ha migdawat kandan diyà ta balay din. ");
INSERT INTO bkd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Amin din daan suled ha iyan si Maria ha mininuu duun hu atubangan hi Jesus daw magpaliliman hu intudlù din. ");
INSERT INTO bkd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ba si Marta agkapulikì hu pagsugba aman inubayan din si Jesus daw ikagiyi hu “Ginuu, harì ka ba diay agkahid-u kanak sa iyan a dà tagtalabahu? Ikagiyi si Maria ha buligan a kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ba si Jesus tuminubag hu “Marta, imbà nu agkasamuki sa madakel ha talabahu? ");
INSERT INTO bkd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sabuwa dà gayed sa mahinengdanen na saini iyan sa pinilì hi Maria ha harì en gayed maagaw diyà ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Amin aldaw ha mig-ampù si Jesus duun hu sabuwa ha lugar. Su makapenga en haena inikagiyan hu sabuwa ha tinun-an din hu “Ginuu, tudlui kay hu pag-ampù iling ki Juan ha Bautista ha tinudluan din sa mga sumusunud din.” ");
INSERT INTO bkd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aman minikagi si Jesus ha “Ku mag-ampù kaw ilingen nuy taini ‘Amay day, tahuren gayed sa ngaran nu. Harii kay ikaw ");
INSERT INTO bkd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","daw aldaw-aldaw ilahi kay hu kalan-enen. ");
INSERT INTO bkd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pasayluwa kay hu mga salà day ta pinasaylu day daan sa nakasalà dini ta kanay, daw ipadiyù kay ikaw hu panulay.’” ");
INSERT INTO bkd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dayun inikagiyan sidan hi Jesus hu “Pananglitan amin mamukaw duun hu amigu din ku liwarà en sa daleman daw ikagi hu ‘Ipasambay a hu tatulu ha buuk ha supas ");
INSERT INTO bkd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ta amin ku manahu ha daw pa nakauma na hurà ku igpakaen kandin.’ ");
INSERT INTO bkd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Ba tuminubag haena hu ‘Harì a ikaw agsamuka ta nasirahan en sa balay daw tuminiduga en daan sa mga batà ku aman harì ad en makabangun hu pag-ila ikaw.’ ");
INSERT INTO bkd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ikagiyen ku inyu ha bisan harì en ngaay haena agbangun ba ku sigi dà tagpangumawà su amigu din makabangun gayed haena daw ilahi su agpanayù hu agkinahanglanen din. ");
INSERT INTO bkd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aman ikagiyen ku inyu ha panayù kaw duun hu Dios ta ilahan kaw gayed kandin, pan-ahà kaw daw makaahà kaw, pangumaw kaw daw puwaan kaw kandin. ");
INSERT INTO bkd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta bisan sin-u sa agpanayù ag-ilahan daw saena ha agpan-ahà makaahà daw sa agpangumaw agpuwaan. ");
INSERT INTO bkd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ku amin inyu agpanayù sa batà nuy hu supas ag-ilahan nuy ba diay hu batu? Daw ku manayù hu sedà bunsalagan ba diay sa ig-ila nuy? ");
INSERT INTO bkd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Daw ku manayù hu impis banayaw ba sa ig-ila nuy? ");
INSERT INTO bkd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ku sinyu sa mga etaw ha makasasalà agkatuen kaw tag-ila hu maayad duun hu mga batà nuy, labaw pa gayed sa Amay nuy diyà ta langit ta ku panayuen nuy ha ulinan kaw hu Balaan ha Ispiritu saena ig-ila din gayed.” ");
INSERT INTO bkd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Amin panahun ha binugaw hi Jesus sa busaw ha pakapaemaw hu etaw. Su umawà en haena sa busaw nakaikagi dayun su etaw aman nangabeleng sa kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ba sa duma minikagi hu “Agkabugaw din sa mga busaw pinaagi hu gahem hi Beelsebul sa agalen hu mga busaw.” ");
INSERT INTO bkd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sa duma ha mga etaw agsulayen dan ngaay si Jesus aman hinangyù dan ha ipaahà din kandan sa belenganen ha iyan timaan ha sinugù haena hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ba natun-an hi Jesus sa henà-henà dan aman inikagiyan din sidan hu “Sa ginharian ha tagsasabà sa mga etaw duun agkabengkag gayed, daw sa pamilya ha magsasabà mabengkag daan haena. ");
INSERT INTO bkd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aman ku sabaen hi Satanas sa mga sakup din sa ginharian din mabengkag gayed. Kagi nuy ha sa gahem ku hu pagbugaw taena ha mga busaw in-ila kanak hi Beelsebul. ");
INSERT INTO bkd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ku iyan haena sin-u diay sa mig-ila hu gahem taena ha mga duma nuy ha tagpamugaw daan hu mga busaw? Pinaagi hu mga buhat dan natun-an taw ha sayep sa tag-ikagiyen nuy. ");
INSERT INTO bkd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Saini ha gahem ku duun gayed napuun hu Dios. Iyan haini ikatun-i taw ha iman tagharì en sa Dios dini ta kanuy. ");
INSERT INTO bkd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ku amin etaw ha mabalaw ha nasangkap hu hinagiban daw bantayan din sa balay din harì gayed maagaw sa mga butang din. ");
INSERT INTO bkd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ba ku maumahan haena hu mabis-ay pa dì kandin daw sabaa maagaw sa tagsaligan din ha mga hinagiban daw sa mga butang din bahin-bahinen ku nakaagaw duun. ");
INSERT INTO bkd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Bisan sin-u sa kenà ku duma iyan gayed agsupak kanak, daw saena ha harì agbulig kanak iyan ag-abug hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ku umawà en sa busaw duun hu etaw ha inulinan din aghipanaw haena ta agpan-ahà hu agtimaan din. Ba ku harì en makaahà agkahenhenaan din ha lumikù dà duun taena ha pigtimaan din su anay. ");
INSERT INTO bkd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ku maahà din dà haena ha limpyu en ");
INSERT INTO bkd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","agpangembang su busaw hu pitu ha duma din ha ayuwà pa madaet dì kandin daw ulinan dan dà paman haena sa etaw. Aman ayuwà pa malegen sa kahimtang taena ha etaw dì su anay.” ");
INSERT INTO bkd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Su tag-ikagi pa si Jesus duun hu mga etaw amin bahi ha minikagi hu “Malipayen gayed haena sa bahi ha iyan migbatà ikaw daw mig-alima ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ba tuminubag si Jesus ha “Tungkay pa gayed adagi sa kalipay taena ha tagpaliliman hu lalang hu Dios daw tagtuman daan taena.” ");
INSERT INTO bkd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Su tagdakel en sa mga etaw ha duminiyà ki Jesus inikagiyan din sidan hu “Sa mga etaw iman ha madaet sa mga buhat dan daw nakadiyù en duun hu Dios tagpan-ahà hu mga belenganen. Ba iyan dà makapaahà ku inyu ha timaan sa naul-ulahan su anay hi Jonas ha propita, ");
INSERT INTO bkd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ta sa naul-ulahan hi Jonas iyan nabuhat ha timaan duun hu mga taga-Ninive. Iling daan ha sa maul-ulahan ku asem siak sa Suled hu Kaet-etawan iyan mabuhat ha timaan diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Asem ku Aldaw hu Paghukum hukuman kaw hu silut taena ha rayna ta Sheba ta saena madiyù sa hinipanawan din hu pagpaliliman hu katudluanan hi Harì Salomon. Ba iman dini en sa matatau pa dì ki Salomon ba harì nuy agdawaten. ");
INSERT INTO bkd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Daw hukuman kaw daan asem hu silut taena ha mga taga-Ninive ta mighinulsul sidan hu mga salà dan su mapaliman dan sa intultul hi Jonas. Ba iman dini en sa labaw pa dì ki Jonas ba harì nuy agtuuwan. ");
INSERT INTO bkd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hurà etaw ha tagtutud hu sulù ha bà din dà igheles daw agpalangkebi hu bakag, ba saena iluntud din gayed duun hu ugsakà ha matangkaw ta daw mailawan sa seled taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sa mata iyan sulù hu lawa nuy. Ku maayad sa mata nuy duun kaw gayed taghipanaw hu mapawà, ba ku peyeng kaw duun kaw taghipanaw hu kasukileman. ");
INSERT INTO bkd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aman magbantay kaw ha sa maayad diyan ta inyu harì madaeg hu madaet, ");
INSERT INTO bkd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ta ku sa henà-henà nuy pulus gayed maayad sa taghipanawan nuy daan iyan sa kapawaan ta agkailing haena hu sulù ha tag-anlag diyan ta inyu.” ");
INSERT INTO bkd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Su makapenga si Jesus mag-ikagi inimbita hu sabuwa ha Fariseo hu pagkaen diyà ta balay din aman duminuma si Jesus daw pinuu ta agkaen. ");
INSERT INTO bkd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ba nabeleng gayed su Fariseo ta hurà pangenaw si Jesus ta alima din daw human kaen. ");
INSERT INTO bkd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Dayun minikagi si Jesus hu “Sinyu sa mga Fariseo, agkailing kaw hu baung daw lampay ha hinenawan sa guwà ba mahugaw sa seled, ta tagtuman kaw gayed hu mga tulumanen ba sa henà-henà nuy madaet ta limbungan daw agapan kaw. ");
INSERT INTO bkd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mga buang-buang kaw gayed. Kenà iyan dà agkaahà hu Dios sa lawa nuy ta natun-an din daan sa henà-henà nuy. ");
INSERT INTO bkd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sumalà hu mahimu nuy ilahi nuy sa mga makaluluuy ha etaw dayun malimpyu kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kahid-u nuy gayed sinyu sa mga Fariseo, ta ig-ulì nuy duun hu Dios sa ikasampulù hu bisan mga atiyuay ha pamulahen nuy ba iyan nuy agbay-anan sa labaw pa ha iling hu pagkamatareng daw hu pagpalanggà nuy hu Dios. Kinahanglan ha iila nuy sa ikasampulù ba buhaten nuy gayed daan sa duma ha kasuguan. ");
INSERT INTO bkd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kahid-u nuy gayed sinyu sa mga Fariseo, ta ku diyà kaw ta simbahan iyan nuy agkabayaan sa madagway ha pinun-ayà daw agkalipay kaw daan ku tahuran kaw hu mga etaw duun hu baligyaanan. ");
INSERT INTO bkd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kahid-u nuy gayed ta iling kaw hu lebeng ha hurà katun-i aman sigi en tagkagik-an hu mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Amin manunudlù hu Kasuguan ha uminikagi diyà ki Jesus hu “Manunudlù, pigpagagayhaan kay gayed ikaw taena ha inikagi nu.” ");
INSERT INTO bkd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ba tuminubag si Jesus hu “Kahid-u nuy daan sinyu sa mga manunudlù hu Kasuguan, ta mabegat gayed sa mga tulumanen ha igpabuhat nuy hu mga etaw ba sinyu harì nuy man daan agkatuman haena. ");
INSERT INTO bkd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kahid-u nuy gayed ta tagbuhat kaw hu mga madagway ha lebeng para hu mga propita ha pinanhimatayan hu mga gin-apuan nuy. ");
INSERT INTO bkd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aman laus diay ha nabayà-bayaan nuy sa binuhat hu mga gin-apuan nuy ta pinanhimatayan dan sa mga propita ba iyan kaw migbuhat hu madagway ha lebeng. ");
INSERT INTO bkd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tumenged taena sa Dios mig-ikagi hu ‘Agsuguen ku sa mga propita daw mga apostoles ba himatayan dan sa duma taena daw sa duma pasipalahan dan.’ ");
INSERT INTO bkd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aman makapanubag kaw gayed hu Dios tumenged taena ha kamatayen hu alan ha mga propita sugud dà su tanghagaen sa kalibutan ");
INSERT INTO bkd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","sugud ki Abel payanaen en ki Zacarias ha duun dà pighimatayi hu pigtaliwaraan ku Timplo daw ku halaran. Ikagiyen ku inyu ha manubag kaw gayed taena. ");
INSERT INTO bkd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kahid-u nuy gayed sinyu sa mga manunudlù hu Kasuguan, ta harì kaw agkabayà ha matun-an nuy sa kamatuuran daw agbaldengen nuy haena sa tagtuen ngaay.” ");
INSERT INTO bkd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Su umawà en si Jesus duun taena ha balay su mga manunudlù hu Kasuguan daw sa mga Fariseo nakigsawalà gayed kandin daw nanginginsà sidan ");
INSERT INTO bkd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ta tag-angat sidan ku amin din maikagi ha makasumbung dan. ");
INSERT INTO bkd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Su maamul-amul sa libu-libuwen ha mga etaw ha pakaggik-ayà en sidan uminikagi si Jesus duun hu mga tinun-an din hu “Bantayi nuy ha harì kaw malimbungan hu mga Fariseo ha tagpasibù-sibù. ");
INSERT INTO bkd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sa alan ha inlilung iman makahiwal dà asem ku malugay daw sa harì iman tag-ikagiyen mapaliman dà asem ku malugay. ");
INSERT INTO bkd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa mga lalang ha iyan kaw dà duun tag-ikagi ipanunultul dà asem ku malugay duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mga suled ku, ikagiyen ku inyu ha harì nuy agkahaldeki sa iyan din dà agkapatay sa lawa nuy ba hurà din en duma pa ha agkabuhat inyu. ");
INSERT INTO bkd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ba iyan nuy kahaldeki sa Dios ha makapatay hu lawa nuy daw makapaagbul pa inyu diyà ta Inferno. ");
INSERT INTO bkd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Henhenaa nuy ha bisan sa mga atiyuay ha tagbis harì agkalipatan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Aman harì kaw agkasamuk ta mahal kaw pa dì hu mga tagbis, ta bisan sa buhuk nuy naiyap en hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ikagiyen ku inyu ha bisan sin-u haena sa ag-angken kanak duun hu mga etaw siak sa Suled hu Kaet-etawan angkenen ku daan duun hu mga balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ba sa tag-ikagi duun hu mga etaw ha harì a kandin agkakilala harì ku daan haena kilalahen duun hu mga balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bisan sin-u haena sa magtameyes kanak siak sa Suled hu Kaet-etawan mabaluy pa ha pasayluwen, ba sa magtameyes hu Balaan ha Ispiritu harì gayed mapasaylu. ");
INSERT INTO bkd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ku uwiten kaw duun hu mga simbahan ta aghukuman kaw kandan daw ipaatubang kaw kandan duun hu mga punuan, harì kaw agkasamuk ku in-inuwen nuy pagpangatarengan daw ku inu sa ipanubag nuy ");
INSERT INTO bkd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ta duun taena ha panahun sa Balaan ha Ispiritu iyan en magtudlù inyu.” ");
INSERT INTO bkd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Amin sabuwa duun hu naamul-amul ha mga etaw ha minikagi hu “Manunudlù, ikagiyi sa suled ku ha bahinan a kandin hu mga kabilin hu amay day.” ");
INSERT INTO bkd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ba tinubag haena hi Jesus ha “Hurà ku labet tayana ta kenà a iyan taghusay inyu.” ");
INSERT INTO bkd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dayun inikagiyan din su mga etaw hu “Bantayi nuy ha harì kaw maayat ta sa maayad ha pagtimà harì duun agkapuun hu madakel ha mga butang.” ");
INSERT INTO bkd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Daw inikagiyan sidan hi Jesus taini ha pananglitan ha tagyanaen “Amin sapian ha etaw ha madakel tungkay sa nalegtay din. ");
INSERT INTO bkd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aman mighenà-henaay haena hu ‘Inu gid sa buhaten ku ta hurà kud en ag-ugsakan taini ha nalegtay ku?’ ");
INSERT INTO bkd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Dayun minikagi haena hu ‘Ay, iyan diay haini buhaten ku. Kagasen ku sa mga bugawan ku daw magbuhat a hu adagi pa dì ku nauna ta ag-ugsakan ku taini ha nalegtay ku daw hu mga butang ku. ");
INSERT INTO bkd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iman malipayen ad gayed ta saini ha mga butang ku tumanan en hu pila ha tuig aman humimlay ad iman pagtalabahu daw bà a dà paman magkaenà daw mag-inumà dayun buhaten ku sa alan ha ikalipay ku.’ ");
INSERT INTO bkd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ba saena inikagiyan hu Dios ha ‘Buang-buang ka gayed ta iman ku daleman matay kad en. Hurà nud mapulusan hu mga butang nu na bà dà paman haena panimua hu lain ha mga etaw.’ ");
INSERT INTO bkd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Iyan haena agkapayanan-an hu etaw ha bà din dà ag-amul-amula sa mga katigayunan din ta daw magsapian ba kenà haena sapian duun hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Inikagiyan hi Jesus sa mga sumusunud din hu “Harì kaw masamuk ku inu sa agkan-en nuy daw sa agbistiyen nuy ");
INSERT INTO bkd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ta mahinengdanen pa sa kinabuhì nuy dì hu pagkaen daw mahinengdanen daan sa lawa nuy dì hu bisti. ");
INSERT INTO bkd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Henhenaa nuy sa mga tagbis. Harì sidan tagpamula daw hurà dan daan bugawan ba igpakaen sidan hu Dios. Kenà ba mahal kaw pa dì hu mga tagbis? ");
INSERT INTO bkd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bisan ku agkatungkayan nuy en agkanugunan sa kinabuhì nuy ba saena harì nuy en gayed masumpayan. ");
INSERT INTO bkd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ku harì nuy man ganì agkabaluy haena imbà kaw man tagkasamukà? ");
INSERT INTO bkd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Henhenaa nuy sa mga bulak ku agkainu-inu sa pagtubù dan. Harì sidan tagpanahì hu pinaksuy dan. Ba ikagiyen ku inyu ha bisan si Harì Salomon su anay sa sapian hurà makagbisti hu iling kadagway taini ha mga bulak. ");
INSERT INTO bkd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ku madagway sa kabuhata hu Dios hu mga sagbet ha laus dà agkangagangu daw bigsuli iyan kaw pa kan harì mailahan hu bisti. Imbà man kaatiyuay tungkay sa pagsalig nuy hu Dios? ");
INSERT INTO bkd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aman harì kaw gayed masamuk ku inu sa agkan-en daw sa ag-inumen nuy ");
INSERT INTO bkd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ta iyan dà agkasamuk sa mga etaw ha hurà pa makakilala hu Dios. Sa Amay nuy natun-an din ha agkinahanglanen nuy gayed haena. ");
INSERT INTO bkd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ipagharì nuy sa Dios diyan ta inyu dayun iila din gayed inyu sa alan ha agkinahanglanen nuy. ");
INSERT INTO bkd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sinyu sa sumusunud ku, bisan ku atiyuay kaw dà ba harì kaw agkasamuk ta igkabayà-bayà haini hu Dios ha pagharian kaw kandin. ");
INSERT INTO bkd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ipamaligyà nuy sa mga butang nuy daw sa halin taena ipan-ila duun hu mga makaluluuy ta daw amin nuy mga katigayunan diyà ta langit ha harì matakaw daw harì agkadaetan daw harì daan maketket. ");
INSERT INTO bkd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta ku hindu duun makaugsak sa katigayunan nuy duun en daan taena sa henà-henà nuy. ");
INSERT INTO bkd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Magpangandam kaw iling hu mga suluguen ha tagsalap ha makaulì sa agalen dan ha duminuun hu kaamulan ta saena sidan tagsulù daw harì tagtiduga ta daw ku makauma en sa agalen dan sagunà dan dà haena mapuwaan. ");
INSERT INTO bkd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Malipayen gayed su mga suluguen ha tagbantay ku makauma sa agalen dan. Laus gayed sa ag-ikagiyen ku inyu ha su agalen iyan magtangel ku mga suluguen din. ");
INSERT INTO bkd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Malipayen gayed su mga suluguen ha tagsalap ku makauma sa agalen dan bisan ku luminam-ag sidan hu pagbantay. ");
INSERT INTO bkd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ba henhenaa nuy haini ha ku agkatun-an pa ngaay hu tagibalay ku kan-u makauma sa takaw harì gayed haena tumiduga ta daw harì maelegan hu takaw. ");
INSERT INTO bkd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aman kinahanglan gayed ha magpangandam kaw ta siak sa Suled hu Kaet-etawan makauma a dini hu panahun ha harì nuy tagsalapen.” ");
INSERT INTO bkd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nanginginsà si Pedro hu “Ginuu, iyan kay dà ba tag-ikagiyan nu hu pananglitan daw ku para ba haini hu alan?” ");
INSERT INTO bkd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tuminubag si Jesus hu “Sa suluguen ha kasaligan iyan ipagbayà hu agalen din hu pagpakaen taena ha mga duma din ha suluguen duun hu hustu ha panahun. ");
INSERT INTO bkd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ku makaulì sa agalen din malipayen gayed haena sa suluguen ha migtuman hu alan ha insugù kandin. ");
INSERT INTO bkd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Laus gayed sa ag-ikagiyen ku inyu ha su agalen igsalig din sa alan ha mga butang din duun ku kasaligan ha suluguen. ");
INSERT INTO bkd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ba ku madaet sa suluguen iyan dà henà-henà din ha ‘Malugay pa ag-ulì su agalen ku’ aman bà din dà paman agpamunali sa mga duma din ha mga suluguen sa mga maama daw sa mga bahi. Bà dà daan magkaenà daw magpasibelengà. ");
INSERT INTO bkd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ku tigkan makauma su agalen din duun hu panahun ha harì din tagsalapen saena ha suluguen himatayan gayed ku agalen din daw ipaamul haena duun hu mga etaw ha harì agtuu hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Saena ha suluguen ha natun-an din en sa igpabuhat kandin hu agalen din ba hurà din buhata silutan gayed hu madakel ha bunal. ");
INSERT INTO bkd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ba sa suluguen ha nakasalà ta hurà din haena katun-i atiyuay dà ha bunal sa silut din. Sa etaw ha madakel sa insalig kandin madakel daan sa tagsalapen diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Duminini a iling hu hapuy ha makapasamuk hu mga etaw. Maayad ngaay ku saena ha hapuy tagkalegdeg en. ");
INSERT INTO bkd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amin pa mga alantusen ha tagsalapen ku aman taglugul a iman taman ha matuman en haena. ");
INSERT INTO bkd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Harì nuy aghenhenaa ha sa pagdini ku ta kalibutan makaila inyu hu maayad ha pagdapità, ta ikagiyen ku inyu ha saini makaila inyu hu kagubut. ");
INSERT INTO bkd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sugud iman ku amin lalima ha etaw duun hu nangkapamilya saena mabahin ta sa tatulu makigsabà hu daruwa daw su daruwa sumukul daan hu tatulu. ");
INSERT INTO bkd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sa amay makigsabà hu batà din ha maama daw sa batà din ha maama sumukul daan kandin. Sa inay makigsabà hu batà din ha bahi daw sa batà din ha bahi sumukul daan kandin. Iling hu ugang ha bahi magsabà sidan hu lagambay din.” ");
INSERT INTO bkd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Inikagiyan hi Jesus sa kaet-etawan ha “Ku agdaklep pakaikagi kaw dayun hu ‘Ag-udan’ saena laus gayed. ");
INSERT INTO bkd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ba ku hurà en bul-ug gabun ta langit pakaikagi kaw hu ‘Aggulabung’ saena laus daan. ");
INSERT INTO bkd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Sinyu sa mga tagpasibù-sibù, natun-an nuy sa mga timaan hu panahun ba imbà nuy harì agkatun-i sa timaan hu agkaula-ula iman? ");
INSERT INTO bkd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Imbà kaw harì pakatuen tagbuhat hu maayad? ");
INSERT INTO bkd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ku isumbung kaw hu duma nuy sulaya nuy husaya ku harì kaw pa makauma duun hu taghusay, ta ku makauma kaw en duun itugyan kaw hu maghuhukum daw ipapurisu kaw gayed kandin. ");
INSERT INTO bkd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ikagiyen ku inyu ha daw kaw en makaguwà diyà ta purisuwan ku mabayaran nuy en sa alan ha mga salà nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Duun taena ha panahun amin mga etaw ha nanunultul diyà ki Jesus hu nahitabù duun hu mga taga-Galilea ha pinahimatayan hi Pilato su kamulu pa ngaay sidan taghalad. ");
INSERT INTO bkd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ba tuminubag si Jesus hu “Abi nuy gid ha adagi gayed sa salà dan dì hu mga kadumahan dan ha taga-Galilea tumenged hu naul-ulahan dan. ");
INSERT INTO bkd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ba saena kenà laus ta ikagiyen ku inyu ha ku harì kaw maghinulsul mangamatay kaw daan iling kandan. ");
INSERT INTO bkd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Henhenaa nuy daan su sampulù daw walu ha etaw ha napilayan hu matangkaw ha balay diyà ta Siloe. Abi nuy gid ha makasasalà sidan dì hu duma ha mga etaw ha tagtimà diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ba saena kenà laus ta ikagiyen ku inyu ha ku harì kaw maghinulsul mangamatay kaw daan iling kandan.” ");
INSERT INTO bkd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Minikagi si Jesus hu sabuwa ha pananglitan ha tagyanaen “Amin etaw ha namula hu kayu ha igira. Su tingpamunga en inelegan din haena daw ahaa ku amin din en bunga ba hurà man diay pamunga. ");
INSERT INTO bkd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aman inikagiyan din sa tag-alima taena ha mga kayu hu ‘Ahaa haini sa impamula ku ha kayu ta ikatulu en iman ha tuig ha hurà pamunga. Maayad pa ha pilayen nud ta bà dà haini pakahanung hu duma ha pamulahen.’ ");
INSERT INTO bkd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ba huminangyù su sinaligan hu ‘Angatan ta enà sa nangkatuig ta aghilamunan ku pa haini daw ag-abunuhan ku pa daan. ");
INSERT INTO bkd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ku mamunga en asem ku sunud ha tuig maayad gayed, ba ku harì en human ku pilaya.’” ");
INSERT INTO bkd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Amin aldaw hu Sabado ha tagpanudlù si Jesus duun hu sabuwa ha simbahan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Amin daan bahi diyà ha inulinan hu busaw hu sampulù en daw walu ha tuig aman nabalukù en. ");
INSERT INTO bkd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ba su maahà hi Jesus su bahi inikagiyan din haena hu “Maulian kad en hu dalu nu.” ");
INSERT INTO bkd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dayun dinampà din daw sagunà natul-idan aman pigdayè ku bahi sa Dios. ");
INSERT INTO bkd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ba sa punuan duun taena ha simbahan napauk gayed ta namulung si Jesus duun hu Aldaw hu Paghimlay, aman inikagiyan din sa mga etaw hu “Haenem ha aldaw sa intugut hu etaw ha magtalabahu. Dumini kaw taini ha mga aldaw hu pagpabulung kenà duun hu Aldaw hu Paghimlay.” ");
INSERT INTO bkd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tuminubag si Jesus hu “Sinyu sa mga tagpasibù-sibù, ku amin inyu magtagkes hu baka daw kabayu harì nuy ba haena hukaden daw ipainum diyà ta wahig duun hu Aldaw hu Paghimlay? ");
INSERT INTO bkd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Saini ha bahi ha kaliwat hi Abraham binakus hi Satanas seled hu sampulù en daw walu ha tuig, aman harì ba diay mahimu ha hukaden haini duun hu Aldaw hu Paghimlay?” ");
INSERT INTO bkd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Su maikagi haena hi Jesus nagayhaan su mga pakigkuntra kandin, ba sa duma ha mga etaw nangabayà-bayà taena ha belenganen ha binuhat hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Minikagi si Jesus hu “Inu sa agpailingan ku hu pag-adagi hu tagharian hu Dios? ");
INSERT INTO bkd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Agkailing haena hu atiyuay gayed tungkay ha lisu ha impamegas duun hu uma. Tuminubù haena dayun nabuhat ha kayu daw sa mga panga din nabuhat ha salagà hu mga tagbis.” ");
INSERT INTO bkd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Minikagi pa daan si Jesus hu “Inu pa sa agpailingan ku hu tagharian hu Dios? ");
INSERT INTO bkd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Agkailing haena hu igpatulin ha iglamud duun hu madakel ha harina dayun su harina agtulin.” ");
INSERT INTO bkd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Duminayun si Jesus hu paghipanaw payanaen ta Jerusalem, ba su diyà pa ta dalan huminapit duun hu mga banuwa ta migtudlù. ");
INSERT INTO bkd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Amin nanginginsà kandin hu “Ginuu, atiyuay dà ba sa mailahan hu kinabuhì ha hurà din katapusan?” Tinubag haena hi Jesus hu ");
INSERT INTO bkd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Paniguruwi nuy sa pag-agi duun hu malig-et ha pultahan ta ikagiyen ku inyu ha madakel ngaay sa ag-agi duun ba harì pakahimu. ");
INSERT INTO bkd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amin panahun ha sa tag-iya taena ha balay sirahan din dayun magpangumawà kaw diyà ta guwà hu ‘Ginuu, puwai kay man ikaw.’ “Ba umikagi haena hu ‘Harì ku inyu agkakilala daw harì ku daan agkatun-an ku hindu kaw duun nangapuun.’ ");
INSERT INTO bkd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Dayun tumubag kaw hu ‘Agkakilala kay ikaw ta migsalu kuy daw tinudluan kay ikaw.’ ");
INSERT INTO bkd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ba ikagiyan kaw kandin hu ‘Harì ku gayed inyu agkakilala daw harì ku daan agkatun-an ku hindu kaw duun nangapuun. Aman awà kaw dini ta kanak sinyu sa alan ha mga madaet sa buhat dan.’ ");
INSERT INTO bkd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Duun taena ku maahà nuy diyà ta seled sa mga gin-apuan nuy ha si Abraham daw si Isaac, si Jacob daw sa mga propita makag-ulahuay kaw daw magkakangget sa mga ngipen nuy hu kalugul ta abugen kaw diyà ta guwà. ");
INSERT INTO bkd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mangaamul-amul sa mga etaw ha mapuun dini ta tibuuk ha kalibutan ha makigsalu kandan duun taena ha kaamulan duun hu tagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Laus gayed ha madakel iman ha mga etaw sa tagkahudiyan ba iyan diay mauna, daw amin daan etaw ha tagkauna iman ba iyan diay mahudiyan.” ");
INSERT INTO bkd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Duun taena ha panahun amin mga Fariseo ha duminiyà ki Jesus ha minikagi ha “Umawà ka dini ta aghimatayan ka hi Herodes.” ");
INSERT INTO bkd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ba tuminubag si Jesus hu “Ikagiyi si Herodes sa mangingilad ha agbulungen ku pa sa mga dalu daw agbugawen ku pa sa mga busaw ha uminulin hu mga etaw ta tatulu pa iman ha aldaw daw human ku haini kapengahi. ");
INSERT INTO bkd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aman agdayunen ku pa haini duun hu tatulu ha aldaw ta sa propita diyà dà agpatay ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Sinyu sa mga taga-Jerusalem ha agpangimatay hu mga propita daw tagbatu daan hu mga etaw ha agsuguen diyan, agtanulen ku ngaay inyu iling hu manuk ha ag-amulen din sa mga piyak din diyà ta pakpak din ba harì kaw man agkabayà. ");
INSERT INTO bkd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aman awaan hu Dios sa banuwa nuy, daw ikagiyen ku inyu ha harì ad inyu maahà hangtud asem ha makaikagi kaw en hu ‘Panalanginan gayed haini sa pakauma ha sinugù hu Dios.’” ");
INSERT INTO bkd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Amin aldaw hu Sabado ha su kumaen si Jesus duun hu balay ku nabantug ha Fariseo pigbantayan dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Duminiyà ta kandin sa etaw ha agpangubuk ");
INSERT INTO bkd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","aman ininsaan hi Jesus su mga manunudlù hu Kasuguan daw sa mga Fariseo hu “Intugut ba hu Kasuguan ha mamulung kuy hu agkadaluwan ku Aldaw hu Paghimlay?” ");
INSERT INTO bkd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba hurà gayed sidan magtubag. Aman inibitan hi Jesus su agkadaluwan dayun naulian haena daw impaulì din. ");
INSERT INTO bkd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Inikagiyan din su mga etaw ha “Ku amin nuy kabayu daw ku baka ba ha mahulug duun hu atabay ku Aldaw hu Paghimlay saena butwaen nuy gayed sagunà dì ba?” ");
INSERT INTO bkd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba hurà en sidan makatubag. ");
INSERT INTO bkd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Su maahà hi Jesus ha sa mga inimbita agpamilì hu madagway ha pinun-ayà inikagiyan din sidan taini ha pananglitan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ku imbitahen kaw duun hu kaamulan harì kaw duun agpinuu hu madagway ha pinun-ayà ta kan ku amin inimbita ha labaw pa dì inyu ");
INSERT INTO bkd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","daw ipahalin kaw ku mig-imbita inyu duun hu kenà maayad ha pinun-ayà dayun magayhaan kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ba ku imbitahen kaw duun kaw pinuu hu kenà maayad ha pinun-ayà daw angatan nuy ha su mig-imbita inyu umikagi hu ‘Halin kaw duun taini ha madagway ha pinun-ayà’ dayun madayè kaw hu duma ha inimbita duun hu kaamulan. ");
INSERT INTO bkd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta bisan sin-u sa tagpalabaw-labaw igpaubus ba saena ha tagpaubus igpatangkaw.” ");
INSERT INTO bkd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dayun inikagiyan hi Jesus su mig-imbita kandin ha “Ku maggastu ka harì nu iyan dà imbitahen sa mga amigu daw sa mga kadumahan nu daw sa mga silingan nu ha sapian ta maimbita ka daan kandan daw makabales sidan ikaw. ");
INSERT INTO bkd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ba ku maggastu ka iyan nu imbitahen sa makaluluuy daw sa kimay, sa pigket daw sa mga buta, ");
INSERT INTO bkd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ta ku buhaten nu haena malipayen ka gayed. Bisan ku harì sidan makabales ikaw ba sa Dios iyan magbales ikaw ku banhawen sa mga matareng.” ");
INSERT INTO bkd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Su mapaliman haena hu sabuwa ha etaw ha tagpinuu diyà ta ubay hi Jesus inikagiyan din si Jesus hu “Malipayen gayed sa etaw ha makaamul duun taena ha kaamulan duun hu tagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Inikagi hi Jesus haini sa pananglitan ha tagyanaen “Amin etaw ha miggastu ha nangimbita hu madakel ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Su mauma en sa kaamulan pinaelegan din su mga inimbita daw ikagiyi ha ‘Dumini kaw en ta napengahan en sa lamisa.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ba amin dan mga balibalan. Sa sabuwa minikagi hu ‘Bà ad ikaw pasayluwa ta daw a pa nakapalit hu uma aman kinahanglan ha elegan ku pa haena ta ag-ahaen ku.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Minikagi daan sa sabuwa hu ‘Pasayluwa a ta daw a pa nakapalit hu sampulù ha baka na igsulay ku pa igdaru.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Sa sabuwa minikagi hu ‘Harì a makadiyan ta kalibag-u a pa.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Aman uminulì su sinugù daw ikagiyi su agalen din. Dayun napauk su nangimbita aman sinugù din dà paman su suluguen din hu kagi din ‘Agpas ka daw imbitaha sa bisan sin-u ha etaw duun hu mga dalan, sa mga makaluluuy daw sa kimay, sa mga buta daw sa pigket.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Su makalikù su suluguen inikagiyan din su agalen din hu ‘Binuhat kud sa insugù nu ba hurà pa kapunù sa balay.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Dayun inikagiyan taena ha agalen su suluguen din hu ‘Elegi sa diyà ta kadiyuan daw hangyua sidan ha dumini ta daw mapanday mapunù haini sa balay ku. ");
INSERT INTO bkd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ikagiyen ku inyu ha hurà gayed bisan sabuwa duun ku tinaganahan hu gastu taini ha kaamulan ha makakaen.’” ");
INSERT INTO bkd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Duminayun si Jesus hu paghipanaw daw madakel tungkay ha mga etaw sa namanduma kandin. Sumininalu si Jesus diyà ta kandan hu kagi din ");
INSERT INTO bkd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bisan sin-u sa tungkay din palanggà sa mga laas din daw sa asawa din, sa mga batà din daw sa mga suled din daw bisan sa kaugalingen din dì kanak, harì mabaluy ha sumusunud ku. ");
INSERT INTO bkd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bisan sin-u haena sa harì agkabayà tag-antus hu alan ha mga malegen bisan duun hu kamatayen tumenged hu pagsunud kanak saena harì gayed mabaluy ha sumusunud ku. ");
INSERT INTO bkd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ku amin agkabayà tagbalay hu adagi ha balay harì din ba unahen haena kwintahen ku tumanan ba sa salapì din hangtud ha mapengahan haena sa balay? ");
INSERT INTO bkd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta ku bà din dà makapas-ek sa tukud ha harì en mapengahan, sa alan ha makaahà taena makapatawa ");
INSERT INTO bkd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","daw mag-ikagi hu ‘Saini ha etaw migbalay ngaay ba hurà din en kapengahi.’ ");
INSERT INTO bkd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Iling daan hu harì ha pakigsabà hu lain ha harì, harì din ba unahen henhenaen ku makadaeg ba haena sa sampulù ha libu ha mga sundalu din hu kaluwaan ha libu ha sundalu hu pakigsabà kandin? ");
INSERT INTO bkd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ku matun-an din ha harì gayed makadaeg maayad pa ku pasuguan din haena sa pakigsabà kandin ta daw mahusay sidan. ");
INSERT INTO bkd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iling daan taena ha harì gayed mabaluy ha sumusunud ku sa bisan sin-u inyu ku harì nuy awaan sa alan. ");
INSERT INTO bkd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sa asin maayad ba ku maawà en sa kapait din in-inuwen pa paglikù hu nanam taena? ");
INSERT INTO bkd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Harì en daan haena mabaluy ha abunu ba bà dà paman iglambeg. “Henhenaa nuy gayed sa napaliman nuy ha inikagi ku.” ");
INSERT INTO bkd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amin mga manunukut hu buhis daw mga masinupaken ha nangaamul-amul diyà ki Jesus hu pagpaliliman kandin. ");
INSERT INTO bkd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ba sa mga Fariseo daw sa mga manunudlù hu Kasuguan migtamudmud hu kagi dan “Saini ha etawa nakigduma-duma hu mga makasasalà daw nakigsalu kandan.” ");
INSERT INTO bkd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Dayun inikagiyan sidan hi Jesus taini ha pananglitan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ku amin inyu amin din nanggatus ha mga karniro daw nalaag sa sabuwa duun harì din ba awaan su kasiyaman daw siyam duun hu panabtabà daw pan-ahaa su sabuwa ha nalaag? ");
INSERT INTO bkd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ku matulen din en haena tungkay gayed malipay daw sapipiyen din haena. ");
INSERT INTO bkd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ku makaulì amulen din sa mga amigu din daw sa mga silingan din daw ikagiyi sidan hu ‘Magmalipayen kuy iman ta nalaag sa karniro ku ba naahà ku dà.’ ");
INSERT INTO bkd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ikagiyen ku inyu ha iling daan taena kaadagi sa kalipay diyà ta langit ku amin sabuwa ha makasasalà ha maghinulsul dì taena ha kasiyaman daw siyam ha mga tagpasibù-sibù ha matareng en daw taghenà-henà ha harì en tagkinahanglan ha maghinulsul. ");
INSERT INTO bkd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ku amin bahi ha amin din sampulù ha salapì daw kalaag sa sabuwa harì ba magtutud haena hu sulù daw silhigi sa balay din hu pagpan-ahà taena ha salapì din ha nalaag? ");
INSERT INTO bkd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ku matulen din haena amulen din sa mga amigu din daw sa mga silingan din daw ikagiyi sidan hu ‘Magmalipayen kuy iman ta naahà kud su sabuwa ha salapì ku ha nalaag.’ ");
INSERT INTO bkd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ikagiyen ku inyu ha adagi daan sa kalipay hu mga balinsuguen hu Dios tumenged hu sabuwa ha makasasalà ha maghinulsul.” ");
INSERT INTO bkd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Si Jesus minikagi hu pananglitan ha tagyanaen “Amin etaw ha amin din daruwa ha batà ha maama. ");
INSERT INTO bkd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Saena ha manghud huminangyù diyà ki Amay din hu ‘Iila en iman kanak sa bahin ku duun hu mga butang nu.’ Aman binahin din sa mga butang din taena ha daruwa. ");
INSERT INTO bkd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Su pila en ha aldaw tinimù ku manghud sa alan ha bahin din daw pahiphipanaw duun hu madiyù ha banuwa dayun gastuwa sa salapì din duun hu maal en ha mga buhat. ");
INSERT INTO bkd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Su maamin en su salapì din nakauma sa adagi ha kauhul duun taena ha banuwa daw miglised gayed haena sa manghud. ");
INSERT INTO bkd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Dayun huminangyù hu talabahu duun hu sabuwa ha sakup taena ha lugar na sa impatalabahu kandin iyan sa pagpamahug hu babuy diyà ta unayan. ");
INSERT INTO bkd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Agkabayà ngaay haena ha makakaen hu bahug ku mga babuy ta hurà mig-ila kandin hu bisan inu ha agkakaen. ");
INSERT INTO bkd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aman nahenhenaan din ha ‘Sa mga suluguen hu amay ku harì pakaamin hu pagkaen dan ba siak agpatay ad en hu kauhul. ");
INSERT INTO bkd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Maayad pa ha umulì a diyà ki Amay daw ikagiyan ku hu “Amay, nakasalà a gayed duun hu Dios daw diyan ta ikaw. ");
INSERT INTO bkd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kenà ad en angayan ha isipen pa ha batà nu ba buhata ad ikaw ha sabuwa duun hu mga suluguen nu.”’ ");
INSERT INTO bkd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aman uminawà haena diyà daw pauulì diyà ki Amay din. Lucas 15:16 “Su madiyù pa diyà ta balay dan natan-aw en hi Amay din. Saena nahid-uwan gayed hi Amay din aman minulalaguy sa suminal-aw ku batà din dayun kinepkepan din haena daw hadeki. ");
INSERT INTO bkd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ba su batà din minikagi hu ‘Amay, nakasalà a gayed duun hu Dios daw diyan ta ikaw. Kenà ad en angayan ha isipen pa ha batà nu.’ ");
INSERT INTO bkd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ba si Amay din nangumaw hu mga suluguen din daw ikagiyi sidan hu ‘Agpas kaw daw uwita dini sa madagway ha pinaksuy daw pinaksuyi haini, suupi nuy hu sising daw sapatusi daan. ");
INSERT INTO bkd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iyawa nuy su impalambù ha nati hu baka ta taggastu a hu pagsaulug, ");
INSERT INTO bkd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ta saini ha batà ku iling hu minatay en ba iman nabanhaw dà daw nalaag en ba iman nakaulì dà.’ Aman migsaulug sidan. ");
INSERT INTO bkd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Su tag-ulì en haena sa magulang ha batà din ha napuun diyà ta uma nakapaliman hu sunata hu tagsayaw su makaubay en diyà ta balay dan. ");
INSERT INTO bkd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aman inumaw din sa sabuwa ha suluguen dan daw insai ku imbà agkabibu sidan. ");
INSERT INTO bkd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tuminubag haena sa suluguen hu ‘Nakaulì su manghud nu aman mig-iyaw si Amay nu hu malambù ha nati hu baka hu pagsaulug ta nabayà-bayà gayed tumenged ta sa suled nu nakaulì ha bubuhay pa daw hurà nahitabù kandin.’ ");
INSERT INTO bkd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Su mapaliman haena ku magulang ha batà tungkay gayed napauk daw hurà en seled. Aman inelegan hu amay din daw pagayuki ha sumeled en. ");
INSERT INTO bkd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ba bà dà tuminubag ki Amay din hu ‘Henhenaa nu ha nalugay en sa pagtalabahu ku dini ta ikaw daw tinuman ku gayed sa alan ha insugù nu. Ba hurà a gayed ikaw ilahi hu bisan nati dà ngaay hu kambing ta daw makagsaulug a duma hu mga amigu ku. ");
INSERT INTO bkd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ba su batà nu ha bà dà miggastuwà hu salapì nu duun hu mga madaet ha bahi pag-ulì din iniyawan nu pa hu impalambù ha nati hu baka.’ ");
INSERT INTO bkd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ba tuminubag si Amay din hu ‘Sigi ka dà dini ta kanak daw sa alan ha mga butang ku ikaw daan. ");
INSERT INTO bkd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Angayan ha malipay ki ta saini ha manghud nu iling hu minatay en ba iman nabanhaw dà daw nalaag en ba iman nakaulì dà.’” ");
INSERT INTO bkd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Inikagiyan hi Jesus sa mga sumusunud din taini ha pananglitan ha tagyanaen “Amin etaw ha sapian ha amin din sinaligan hu mga butang din, ba amin migsumbung diyà ta kandin ha pinanggastu ku sinaligan sa salapì ha insalig kandin. ");
INSERT INTO bkd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aman impaumaw haena daw ikagiyi hu ‘Laus ba sa napaliman ku mahitenged ikaw? Iman ipaahà nu kanak sa listahan hu kabuhata nu hu mga insalig ku ikaw ta iman kenà kud en iyan ikaw agsaligan.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Dayun su sinaligan nakahenà-henà hu ‘Inu gid sa buhaten ku ta ag-awaen ad en taini ha agalen ku? Harì a makabaug magdaru daw agkagayhà a daan tagpakilimus. ");
INSERT INTO bkd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay, iyan diay haini buhaten ku ta daw amin ku matimaan ku hurà kud asem talabahu.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Aman inumaw din sa kada sabuwa ha nakautang duun ku agalen din. Dayun ininsaan din su sabuwa hu ‘Pila sa utang nu duun hu agalen ku?’ ");
INSERT INTO bkd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Tuminubag haena hu ‘Nanggatus ha lata ha lana.’ “Aman inikagiyan din hu ‘Taini su listahan hu mga utang nu. Agpas ka daw isulat sa kalimahan dà ha lata.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Dayun ininsaan din daan su ikaduwa hu ‘Pila sa ikaw ha nautang?’ “Tuminubag daan haena hu ‘Nanggatus ha saku ha trigo.’ “Aman inikagiyan din hu ‘Isulat nu ha kawaluwan dà ha saku sa utang nu.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ba su matun-an haena ku agalen din nakaikagi dayun ha matatau gayed manlimbung su sinaligan din. Ta sa mga etaw ha iyan dan dà taghenhenaen sa mga butang dini ta kalibutan daan en tagpanagana hu kinahanglanen dan asem labaw pa dì hu sumusunud hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ikagiyen ku inyu ha gamita nuy sa mga butang nuy hu pagbulig taena ha taglised ta daw asem ku malugay ha harì nuy en magamit sa mga butang nuy amin gihapun bales inyu diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Saena ha agkasaligan hu atiyuay ha mga butang agkasaligan daan hu madakel, ba sa agpanlimbung hu atiyuay ha mga butang manlimbung gayed daan hu mga butang ha madakel. ");
INSERT INTO bkd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aman ku harì kaw agkasaligan hu mga butang duun taini ha kalibutan harì daan isalig hu Dios inyu sa laus ha katigayunan diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Daw ku harì kaw masaligan hu pagtanul taena ha mga butang hu lain en ha etaw harì kaw daan ilahan hu mga butang. ");
INSERT INTO bkd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Harì gayed mabaluy ha sa etaw daruwa sa agalen din ta palanggaen din sa sabuwa ba sa sabuwa kuntrahen din, alimahan din sa sabuwa ba sa sabuwa ipatayà din. Sa etaw ha iyan din dà minahal sa katigayunan din harì gayed mahimu ha mahalen din daan sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sa mga Fariseo ha balimbayaan hu salapì bà dà migpatawahà su mapaliman dan haena sa inikagi hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ba inikagiyan sidan hi Jesus hu “Tagpabantug kaw ngaay hu mga etaw ba natun-an hu Dios sa mga henà-henà nuy. Sa tagtuuwan hu mga etaw ha iyan mapuslanen dini ta kalibutan saena agtambagan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sa Kasuguan daw sa lalang hu Dios pinaagi hu mga propita duun dà nataman hu pagpakauma hi Juan ha Bautista. Sugud taena tigsangyaw sa Maayad ha Tultulanen mahitenged hu pagharì hu Dios daw agpegesen ngaay hu mga etaw ha magharì en haena. ");
INSERT INTO bkd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Malumu pa ha mahanaw sa langit daw sa kalibutan dì hu Kasuguan ha maalatan hu bisan atiyuay. ");
INSERT INTO bkd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Saena ha ag-endaan din sa asawa din daw mangasawa hu lain ha bahi makapanapaw, daw sa umasawa ku bahi ha inendaan makapanapaw daan. ");
INSERT INTO bkd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Amin etaw ha sapian tungkay ha migpinaksuy hu tungkay mahal daw aldaw-aldaw hayahay gayed sa pagtimà din. ");
INSERT INTO bkd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ba diyà ta pultahan taena ha balay din amin duun etaw ha makaluluuy gayed tungkay ha tagngaranan ki Lazaro. Nalekep sa lawa hi Lazaro hu kaluli ");
INSERT INTO bkd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","daw agkabayà gayed ngaay ha makakaen hu bisan mga mumu dà duun hu lamisa taena ha sapian. Su tagtimaay haena diyà ta guwà inamul-amulan hu mga asu daw dilai sa mga kaluli din. ");
INSERT INTO bkd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Hurà kalugay minatay su makaluluuy ba inuwit haena hu mga balinsuguen hu Dios diyà ki Abraham. Dayun minatay daan su sapian daw inlebeng. ");
INSERT INTO bkd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Diyà ta Kamatayan tag-antus haena hu tungkay masakit. Huminangad haena daw naahà din si Abraham diyà ta kadiyuan daw si Lazaro sa diyà daan ta ubay din. ");
INSERT INTO bkd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Aman nangumaw haena hu ‘Apù ku ha Abraham, kahid-uwi a ikaw daw sugua si Lazaro ha teleben din sa tuldù din duun hu wahig daw ipatulù dini ta bàbà ku ta tag-antus a gayed dini taini ha hapuy.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ba tuminubag si Abraham hu ‘Apù, henhenaa nu ha su diyà ka pa ta kalibutan hayahay gayed sa pagtimà nu ba si Lazaro mig-antus. Iman si Lazaro malipayen hu kandin ba sikaw tag-antus ka. ");
INSERT INTO bkd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Daw kenà hayan iyan dà ta amin pa nakaelang kanuy ha hurà taw duun ig-agi.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Su sapian bà dà paman nakaikagi ha ‘Ku iyan diay hayana hangyuen ku ikaw, Apù, ha suguen nu si Lazaro duun hu balay hi Amay ku ");
INSERT INTO bkd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ta amin ku pa lalima ha suled daw patultuli sidan kandin ta daw harì sidan makalupug kanak duun taini ha banuwa hu kasakitan.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ba uminikagi si Abraham hu ‘Kenà en kinahanglan ta amin en diyà lalang hu Dios ha insulat hi Moises daw hu mga propita. Iyan en haena palilimanan dan.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ba tuminubag su sapian hu ‘Apù ku ha Abraham, harì sidan magpaliliman taena ba ku amin ngaay mabanhaw daw dumiyà ta kandan maghinulsul gayed sidan.’ ");
INSERT INTO bkd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Uminikagi si Abraham ha ‘Ku harì sidan magpaliliman hu lalang hu Dios ha insulat hi Moises daw hu mga propita harì gayed daan sidan tumuu bisan pa ku amin dumiyà ha minatay en ba nabanhaw dà.’” ");
INSERT INTO bkd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Inikagiyan hi Jesus sa mga sumusunud din hu “Sa panulay ha igpakasalà hu etaw iyan en haena bagad dini ta kalibutan, ba kahid-u gayed taena ha iyan agkahimu ha panulay. ");
INSERT INTO bkd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maayad pa ngaay ku ihiket en sa lieg din duun hu adagi ha batu daw leneda diyà ta dagat dì sa mahimu haena ha iyan igpakasalà hu duma ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aman magbantay kaw gayed. “Ku amin nuy duma ha nakasalà baldenga haena na ku maghinulsul pasayluwa nuy. ");
INSERT INTO bkd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bisan ku kapitu en makasalà duun hu nangkaaldaw ba pasayluwen nuy gihapun ku manayù hu pasaylu.” ");
INSERT INTO bkd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Uminikagi su mga apostoles hu “Ginuu, isabi sa pagtuu day.” ");
INSERT INTO bkd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ba inikagiyan sidan hi Jesus ha “Ku sa pagtuu nuy iling dà kaatiyù hu lisu hu mustasa mahimu en ha suguen nuy hayana sa adagi ha kayu ha humalin diyà ta dagat na makahalin gayed. ");
INSERT INTO bkd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ku amin etaw ha amin din suluguen ha migdaru daw ku tag-alima ba hu karniro harì mabaluy ha ku makaulì bà dà haena ipakaen hu agalen din. ");
INSERT INTO bkd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta saena ikagiyan hu agalen din ha ‘Mag-ilis ka daw sugbahi a. Ku makapenga a kumaen human ka daan kaen.’ ");
INSERT INTO bkd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Daw saena kenà en kinahanglan ha dayeen pa hu agalen din ta bà dà haena migtuman hu talabahu din. ");
INSERT INTO bkd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iling daan inyu ku mapengahan nuy sa impabuhat hu Dios inyu harì kaw tagpabantug ba henhenaen nuy ha bà kaw dà suluguen hu Dios ha migtuman hu katengdanan nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Su taghipanaw en si Jesus payanaen diyà ta Jerusalem diyà nakaagi ta dulunà ta mga probincia ta Samaria daw ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Su makauma haena duun hu sabuwa ha banuwa sinal-aw hu sampulù ha mga sanglahen, ba migpadiyù dà sidan ");
INSERT INTO bkd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","daw nangumaw sidan ha tagyanaen “Jesus ha Ginuu, kahid-uwi kay man ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Su maahà sidan hi Jesus inikagiyan din sidan ha “Dumuun kaw taena ha mga sinaligan hu paghalad ta daw maahà kaw kandan.” Su daw pa sidan tagdiyà nangaulian en sidan. ");
INSERT INTO bkd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sa sabuwa kandan su maahà din ha naulian en luminikù dà diyà ki Jesus daw kuminulahì ha tagdayè hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Luminuhud haena duun hu atubangan hi Jesus daw migpasalamat. Saena ha etaw kenà Judio ba taga-Samaria. ");
INSERT INTO bkd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ininsaan haena hi Jesus hu “Dì ba sampulù kaw man sa nangaulian? Hindu en diay su siyam ha mga duma nu? ");
INSERT INTO bkd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Imbà iyan ka dà sa kenà Judio nakalikù dini hu pagdayè hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dayun inikagiyan haena hi Jesus hu “Hipanaw kad ta sa ingkaulii nu iyan sa pagsalig nu kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amin panahun ha ininsaan hu mga Fariseo si Jesus ku kan-u agkatuman sa pagharì hu Dios duun hu kaet-etawan. Tuminubag si Jesus hu “Sa pagharì hu Dios harì ta agkaahà ");
INSERT INTO bkd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","daw harì haena mabaluy ha magyanaen sa mga etaw hu ‘Taini en’ daw ‘Diyà en’ ta sa pagharì hu Dios duun dà hu gahinawa hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dayun inikagiyan hi Jesus sa mga tinun-an din hu “Makauma sa panahun ha agkabayà kaw gayed ku lumikù a dini siak sa Suled hu Kaet-etawan ba harì pa haena matuman. ");
INSERT INTO bkd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Amin asem mag-ikagi hu ‘Diyà en’ daw ‘Taini dà’ ba harì kaw agsunud kandan. ");
INSERT INTO bkd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta siak sa Suled hu Kaet-etawan sa paglikù ku agkailing hu kilat ha pakailaw ta tibuuk ha kalibutan daw agkaahà hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ba sa harì pa haena makauma amin pa madakel ha mga alantusen ku daw pagtameyesen a hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Sa paglikù ku asem siak sa Suled hu Kaet-etawan mailing hu panahun hi Noe ");
INSERT INTO bkd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ha sa mga etaw bà dà tagkaenà daw tag-inumà daw namangasawa hangtud en ha sumineled si Noe duun ku arka. Dayun piglenepan sa tibuuk ha kalibutan aman alan sidan nangalemes. ");
INSERT INTO bkd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Iling daan hu panahun hi Lot ha sa mga etaw migkaenà daw mig-inumà, namalit daw migbabaligyà, namamula daw migbabalay. ");
INSERT INTO bkd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ba su umawà en si Lot diyà ta Sodoma sa alan ha mga etaw nahulugan hu hapuy daw asupri aman nangamatay sidan. ");
INSERT INTO bkd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Iling taena sa paglikù ku siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Duun asem taena ha panahun sa mga etaw diyà ta atep ta balay dan harì en lumugnà hu pagtimù hu mga butang dan, daw sa diyà ta uma harì en daan umulì. ");
INSERT INTO bkd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Henhenaa nuy sa asawa hi Lot sa luminingì. ");
INSERT INTO bkd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak bisan duun hu kamatayen mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ikagiyen ku inyu ha duun asem taena ha panahun ku amin daruwa ha taghumbà matimù sa sabuwa ba sa sabuwa makatabun. ");
INSERT INTO bkd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Iling daan hu daruwa ha bahi ha tagpanggaling matimù sa sabuwa ba sa sabuwa makatabun. ");
INSERT INTO bkd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ku amin daruwa ha maama diyà ta uma sa sabuwa matimù ba sa sabuwa makatabun.” ");
INSERT INTO bkd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ininsaan dan si Jesus hu “Ginuu, hindu haini agkahitabù?” Tuminubag si Jesus ha “Ku hindu duun sa mga minatay duun daan tag-amul-amul sa mga wakwak.” ");
INSERT INTO bkd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Inikagiyan hi Jesus sa mga tinun-an din taini ha pananglitan ta daw matun-an dan ha kinahanglan gayed ha harì sidan magluya hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Duun hu sabuwa ha banuwa amin maghuhukum ha hurà din kahaldek hu Dios daw hurà din daan agtahuran ha etaw. ");
INSERT INTO bkd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amin daan diyà balu ha bahi ha taglikù-likù diyà ta kandin hu paghangyù ha ‘Buligi a ikaw ta amin agsabà kanak.’ ");
INSERT INTO bkd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Su anay saena ha maghuhukum hurà gayed magpaliliman. Ba su malugay en nakahenà-henà hu ‘Bisan pa ku harì a agkahaldek hu Dios daw hurà ku daan agtahuran ha etaw ");
INSERT INTO bkd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ba tumenged ta saini ha balu ha bahi sigi dà tagsamuk-samuk kanak buligan kud en ta daw harì makaglikù-likù dini.’” ");
INSERT INTO bkd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Dayun uminikagi si Jesus hu “Henhenaa nuy sa inikagi taena ha maghuhukum bisan ku kenà haena matareng ha etaw. ");
INSERT INTO bkd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Harì ba buligan gayed hu Dios sa mga pinilì din ha sigi dà tag-ampù aldaw daw ku daleman? Magyawatà ba haena hu pagbulig din? ");
INSERT INTO bkd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ikagiyen ku inyu ha sagunà din dà gayed sidan buligan. Ba asem ku lumikù a dini ta kalibutan siak sa Suled hu Kaet-etawan amin pa ba gid sumalig kanak?” ");
INSERT INTO bkd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Inikagi pa hi Jesus haini ha pananglitan taena ha mga etaw ha tagsalig hu pagkamatareng dan ba agpakaminus hu duma ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Amin daruwa ha etaw ha duminuun ku Timplo hu pag-ampù, sa sabuwa Fariseo daw sa sabuwa manunukut hu buhis. ");
INSERT INTO bkd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Saena ha Fariseo mig-ampù ha tagyanaen ‘Dios ha Magbabayà hu alan, tagpasalamatan ku ikaw ta harì a agkailing hu duma ha mga etaw ha agpanlimbung daw kenà matareng daw mananapaw, daw kenà a daan iling taini ha manunukut hu buhis. ");
INSERT INTO bkd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kadaruwa a salang hu pagkaen duun hu nangkasimana daw ig-ila ku daan sa ikasampulù hu alan ha agkatimù ku.’ ");
INSERT INTO bkd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ba su manunukut hu buhis diyà dà tuminiyadeg ta suyuk. Duminunghuy ta agkaguul gayed hu mga salà din daw mig-ampù ha tagyanaen ‘Dios ha Magbabayà hu alan, kahid-uwi a ikaw sa makasasalà.’ ");
INSERT INTO bkd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ikagiyen ku inyu ha saini uminulì ha napasaylu en sa mga salà din dì taena ha Fariseo. Ta bisan sin-u sa tagpalabaw-labaw igpaubus ba saena ha tagpaubus igpatangkaw.” ");
INSERT INTO bkd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amin mga etaw diyà ha mig-uwit hu tungkay pa atiyuay ha mga batà ta daw madampà hi Jesus. Su maahà haena hu mga tinun-an din binaldeng dan sidan. ");
INSERT INTO bkd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ba si Jesus minikagi hu “Ipaubay dini ta kanak sa mga batà daw harì nuy sidan agbaldenga, ta sa mga etaw ha iling taini ha mga batà iyan tagharian hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Laus gayed sa ag-ikagiyen ku inyu ha sa harì agkabayà ha pagharian hu Dios iling hu pagtuu taini ha batà saena harì pagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Amin punuan hu mga Judio ha nanginginsà ki Jesus hu “Maayad ha Manunudlù, inu man sa kinahanglan ha buhaten ku ta daw mailahan a hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tuminubag si Jesus hu “Imbà a ikaw umawa ha maayad? Hurà gayed maayad ba iyan dà sa Dios. ");
INSERT INTO bkd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Natun-an nud sa Kasuguan hu Dios ha tagyanaen ‘Harì ka manapaw daw harì ka mangimatay, harì ka daan manakaw daw harì ka magbutang-butang daw tahura daan sa mga laas nu.’” ");
INSERT INTO bkd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Minikagi haena sa etaw hu “Binuhat kud en hayana sugud dà su atiyuay a pa.” ");
INSERT INTO bkd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Su mapaliman haena hi Jesus inikagiyan din hu “Amin pa gayed sabuwa ha hurà nu kabuhat. Ipamaligyà sa alan ha mga butang nu dayun sa halin taena ipan-ila duun hu mga makaluluuy ta daw magsapian ka diyà ta langit. Ku mapengahan nu haini lumikù ka dini daw sunud ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Su mapaliman ku punuan su inikagi hi Jesus naguul gayed haena ta madakel tungkay sa mga katigayunan din. ");
INSERT INTO bkd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Uminahà si Jesus diyà ta kandin daw ikagi hu “Malegen tungkay ha maharian hu Dios sa etaw ha sapian. ");
INSERT INTO bkd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Malumu pa hu kamilyo sa paglusut duun hu pusu hu dagum dì hu sapian ha maharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Su mapaliman haena hu mga etaw nanginginsà sidan hu “Sin-u dà diay sa mailahan hu kinabuhì ha hurà din katapusan?” ");
INSERT INTO bkd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tuminubag si Jesus hu “Sa harì agkabaluy hu etaw agkahimu hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Minikagi si Pedro diyà ki Jesus hu “Inawaan day sa alan ta daw makasunud kay ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa inawaan din sa balay din, sa asawa din daw sa mga suled din, sa mga laas din daw sa mga batà din tumenged ta tagharian hu Dios, ");
INSERT INTO bkd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bisan iman ha panahun makadawat en gayed hu madakel pa dì taena ha inawaan din daw amin din daan kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tinabis hi Jesus sa mga tinun-an din daw ikagiyi hu “Tagdiyà kuy en iman ta Jerusalem daw diyà matuman sa alan ha insulat hu mga propita ha maul-ulahan ku siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Itugyan a duun hu kenà mga Judio ha magtameyes kanak. Pagagayhaan a daw ileban a daan kandan, ");
INSERT INTO bkd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","lagkutan a dayun himatayan a kandan. Ba duun hu ikatulu ha aldaw mabanhaw a dà.” ");
INSERT INTO bkd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hurà gayed kasabut hu mga tinun-an din haena sa inikagi hi Jesus ta sa kahulugan taena nakalilung diyà ta kandan aman hurà dan katun-i ku inu sa tagsubayen din. ");
INSERT INTO bkd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Su ubay en si Jesus diyà ta Jerico amin buta ha tagpinuu diyà ta kilid ta dalan ha tagpakilimus. ");
INSERT INTO bkd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Su mapaliman din sa madakel ha mga etaw ha aglabay diyà ta kandin nanginginsà haena ku inu sa magulub. ");
INSERT INTO bkd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inikagiyan dan hu “Ag-agi en dini si Jesus ha taga-Nazaret.” ");
INSERT INTO bkd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aman nangulahì su buta hu “Jesus ha Kaliwat hi David, kahid-uwi a ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Binaldeng taena ha tag-una ta igpahagteng dan ngaay, ba bà dà nasì kadaging sa pangulahì din ha tagyanaen “Sikaw sa Kaliwat hi David, kahid-uwi a man ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aman tuminaleen en si Jesus daw sugù ha uwiten su buta diyà ta kandin. Su makaubay en su buta diyà ki Jesus ininsaan din haena hu ");
INSERT INTO bkd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Inu man sa agkabayaan nu ha buhaten ku diyan ta ikaw?” Tuminubag su buta hu “Ginuu, makaindan a ngaay.” ");
INSERT INTO bkd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Minikagi si Jesus diyà ta kandin hu “Makaindan kad ta sa ingkaulii nu iyan sa pagsalig nu kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aman sagunà nakaindan daw duma ki Jesus ha tagdayè hu Dios. Su maahà haena hu mga etaw dinayè dan daan sa Dios. ");
INSERT INTO bkd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Su taghipanaw si Jesus nakaagi diyà ta Jerico. ");
INSERT INTO bkd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Amin sapian diyà ha agalen hu mga manunukut hu buhis ha tagngaranan ki Zakeos. ");
INSERT INTO bkd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Agkabayaan din gayed ag-ahaa ku agkainu-inu si Jesus ba harì din agkahimu ta madakel tungkay sa mga etaw daw mababà haena hu kandin. ");
INSERT INTO bkd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aman minulalaguy diyà ta unahan daw pamanahik duun hu kayu ha sikamoro ta daw maahà din si Jesus ta duun taena ag-agi. ");
INSERT INTO bkd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Su makauma si Jesus diyà ta kandin huminangad haena daw ikagiyi hu “Zakeos, agpas ka lugnà ta agdiyà a iman ta balay nu.” ");
INSERT INTO bkd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aman sagunà si Zakeos luminugnà daw malipayen ha duminawat ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa alan ha mga etaw ha nakaahà taena migtamudmud ha tagyanaen “Imbà haini seled duun hu balay hu makasasalà?” ");
INSERT INTO bkd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ba huminitindeg si Zakeos daw uminikagi hu “Ginuu, sa liwarà hu mga katigayunan ku ipan-ila ku iman duun hu mga makaluluuy, daw sa etaw ha nalimbungan ku su anay hu sabuwa ilikù ku haena diyà ta kandin ha haepat en.” ");
INSERT INTO bkd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Inikagiyan haena hi Jesus hu “Iman ha aldaw sikaw daw sa pamilya nu maluwas en ta iyan kaw laus ha mga kaliwat hi Abraham. ");
INSERT INTO bkd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta siak sa Suled hu Kaet-etawan Lucas 19:4-5 duminini a ta kalibutan hu pagpan-ahà taena ha nangalaag daw hu pagluwas kandan.” ");
INSERT INTO bkd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Su tagpaliliman pa sa mga etaw inikagiyan sidan hi Jesus taini ha pananglitan ta duun taena ubay en sidan diyà ta Jerusalem daw abi dan ha sagunà en magharì sa Dios. ");
INSERT INTO bkd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Minikagi si Jesus hu “Amin harianen ha etaw ha duminuun hu madiyù ha banuwa ta daw mailahan diyà hu gahem hu pagkaharì. ");
INSERT INTO bkd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Su hurà pa haena hipanaw inamul-amul din sa sampulù ha sinaligan din daw ilahi hu tigsampulù ha salapì. Inikagiyan din sidan ha ‘Ipatigayun nuy haini taman ha makaulì a.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ba amin mga sakup din ha agsabà kandin aman su humipanaw haena pinalupugan dan hu mga sinugù sa tag-ila kandin hu gahem hu pagkaharì ta daw maikagiyan ha harì dan haena agkabayaan sa etaw ku iyan magharì kandan. ");
INSERT INTO bkd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ba bisan pa taena su etaw nailahan gayed hu gahem hu pagkaharì dayun uminulì. “Su makaulì en haena impaatubang din sa pigpan-ilahan din hu salapì ta daw masusi din ku pila en sa ganansiya. ");
INSERT INTO bkd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Su sabuwa uminubay diyà ta kandin daw ikagi ha ‘Su in-ila nu kanak ha sampulù ha salapì nakaganansiya hu nanggatus.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Inikagiyan din haena hu ‘Maayad gayed tungkay sa binuhat nu. Tumenged ta kasaligan ka hu atiyuay dà ha salapì buhaten ku ikaw ha pangulu hu sampulù ha banuwa.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Uminubay daan su ikaduwa ha kagi din ‘Su in-ila nu kanak ha sampulù ha salapì nakaganansiya hu kalimahan.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Inikagiyan taena ha harì hu ‘Iyan ka daan pangulu hu lalima ha banuwa.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Dayun uminubay daan diyà ta kandin su sabuwa ha kagi din ‘Taini dà su salapì nu ta bà ku dà binungkusi hu panyù daw iheles. ");
INSERT INTO bkd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nahaldek a ikaw tumenged ta manlulupig ka ha etaw ta agtimuen nu sa kenà ikaw daw aglegtayen nu daan sa kenà ikaw ha insawed.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Inikagiyan din haena ha ‘Buang-buang ka gayed ha sinaligan. Iman sa lalang nu iyan maghukum ikaw hu silut ta natun-an nud man diay ha manlulupig a ha etaw ta agtimuen ku sa kenà kanak daw aglegtayen ku daan sa kenà kanak ha insawed. ");
INSERT INTO bkd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Imbà nu man hurà ibangku hayana sa salapì ku ta daw maisaban ku lumikù a?’ ");
INSERT INTO bkd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Dayun inikagiyan din haena sa tagtiyadeg diyà ta ubay din hu ‘Timua nu hayana sa salapì diyan ta kandin daw iila duun taena ha nakatimù hu nanggatus.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ba uminikagi sidan hu ‘Madakel en man sa kandin ha salapì.’ ");
INSERT INTO bkd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Tuminubag haena hu ‘Ikagiyen ku inyu ha sa etaw ha amin en kandin mailahan hu tungkay pa gayed madakel, ba saena ha hurà din en hu kandin bisan su iyan-iyan din dà timuen pa gayed haena diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ba sa mga sakup ku ha migsabà kanak daw harì agkabayà ha iyan a magharì kandan uwita dini ta atubangan ku daw panhimatayi.’” ");
INSERT INTO bkd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Su makapenga si Jesus mag-ikagi duminayun hu paghipanaw payanaen ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Su ubay en diyà ta Betpage daw ta Betania diyà ta Buntud ta Olibo sinugù hi Jesus sa daruwa ha tinun-an din ");
INSERT INTO bkd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ha tagyanaen “Umuna kaw en diyà tayà ha banuwa. Ku makauma kaw diyà maahà nuy sa intagkes ha nati hu asno ha harì pa gayed agkalulanan. Hukada nuy daw tuyuka dini. ");
INSERT INTO bkd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ku amin manginginsà inyu hu ‘Imbà nuy hayana agtimua?’ ikagiya nuy ha ‘Agkinahanglanen haini hu Ginuu.’” ");
INSERT INTO bkd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dayun huminipanaw haena sa sinugù daw natuman gayed sa alan ha inikagi hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Su taghukaden dan en sa hiket taena ha nati hu asno nanginginsà su tag-iya hu “Imbà nuy aghukada sa hiket tayan ha nati hu asno?” ");
INSERT INTO bkd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ba tuminubag sidan hu “Agkinahanglanen haini hu Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tinuyuk dan su nati hu asno diyà ki Jesus daw binalhenan dan haena hu mga bisti dan dayun impalulan dan si Jesus duun. ");
INSERT INTO bkd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Su tagdiyà en si Jesus ta Jerusalem binukladan hu mga etaw hu mga bisti dan sa dalan ha ag-agiyan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Su tagtubang en say Jesus diyà ta Buntud ta Olibo sa mga etaw ha sumusunud din nangalipay, aman nangulahì sidan hu pagdayè hu Dios tumenged hu mga belenganen ha naahà dan ha binuhat hi Jesus hu kagi dan ");
INSERT INTO bkd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Panalanginan gayed sa Harì ha nakauma ha sinugù hu Dios. Malinawen iman sa pagdapità hu Dios daw hu mga etaw aman dayeen gayed sa Dios diyà ta langit.” ");
INSERT INTO bkd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Amin diyà duma ha mga Fariseo ha minikagi diyà ki Jesus hu “Manunudlù, baldenga hayan sa mga sumusunud nu.” ");
INSERT INTO bkd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ba tinubag sidan hi Jesus hu “Ikagiyen ku inyu ha ku harì mag-ikagi sa mga etaw iyan en haini sa mga batu magdayè kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Su matan-aw hi Jesus sa banuwa ta Jerusalem inagalaan din haena ");
INSERT INTO bkd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ha tagyanaen “Maayad ngaay ku matun-an nuy sa paagi ha magmalinawen kaw ba iman nakalilung haena inyu. ");
INSERT INTO bkd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Makauma sa panahun ha libutan kaw hu mga kuntra nuy daw hurà en inyu makapulaguy. ");
INSERT INTO bkd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Panhimatayan kaw kandan daw sa mga batà nuy daw pandaeten dan sa alan ha mga balay nuy tumenged ta hurà nuy kakilala sa Ginuu ha migdini hu pagluwas inyu.” ");
INSERT INTO bkd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sumineled si Jesus diyà ta Timplo daw pan-abuga sa mga tagbabaligyà diyà. ");
INSERT INTO bkd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Inikagiyan din sidan hu “Nakasulat en sa lalang hu Dios ha tagyanaen ‘Sa Timplo ku iyan alampuanan.’ Ba saini binuhat nuy ha kampo hu mga tulisan.” ");
INSERT INTO bkd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Si Jesus aldaw-aldaw migtudlù duun hu Timplo. Ba sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan daw sa duma ha mga punuan nan-ahà hu paagi ha mapatay dan si Jesus, ");
INSERT INTO bkd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ba harì dan pa haena agkahimu ta sa mga etaw agkabayà-bayà gayed tagpaliliman hu pagtudlù din. ");
INSERT INTO bkd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Amin aldaw ha su tagpanudlù si Jesus diyà ta Timplo mahitenged hu Maayad ha Tultulanen sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan duma hu mga magulang duminiyà ta kandin ");
INSERT INTO bkd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","daw panginginsà hu “Inu sa katenged nu daw sin-u sa mig-ila ikaw hu kagahem hu pagbuhat taena?” ");
INSERT INTO bkd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ba tinubag sidan hi Jesus hu “Ag-insaan ku daan inyu. ");
INSERT INTO bkd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Sin-u man sa mig-ila ki Juan ha Bautista hu kagahem hu pagbautismu? Iyan ba sa Dios daw ku etaw dà ba?” ");
INSERT INTO bkd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Miglalang-lalang sidan ha “Ku kagi taw iman ha iyan sa Dios insaan kuy kandin ku imbà hurà taw tuuwi si Juan. ");
INSERT INTO bkd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ba ku ikagiyen taw daan ha etaw dà batuwen kuy taini ha mga etaw ta tuminuu gayed sidan ha propita si Juan.” ");
INSERT INTO bkd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aman iyan dà tubag dan diyà ki Jesus sa “Hanaw ta ku hindu napuun sa kagahem din.” ");
INSERT INTO bkd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Minikagi si Jesus ha “Ku iyan hayana harì ku daan inyu ag-ikagiyen ku sin-u sa mig-ila kanak hu kagahem hu pagbuhat taena.” ");
INSERT INTO bkd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Inikagiyan hi Jesus sa mga etaw taini ha pananglitan ha tagyanaen “Amin etaw ha amin din uma ha pinamulahan hu paras dayun pinaalimahan din hu mga sinaligan daw pahiphipanaw duun hu madiyù ha banuwa hu nalugay ha panahun. ");
INSERT INTO bkd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Su bungahan en su paras sinugù din sa sabuwa ha suluguen duun ku mga sinaligan din ha tag-alima hu parasan ta daw matimù taena sa kandin ha bahin. Ba su sinugù din bà dà binunali ku mga sinaligan daw ipaulì ha hurà din uwiten. ");
INSERT INTO bkd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aman sinugù din dà paman sa lain ha suluguen ba bà dan dà daan haena binunali daw pagagayhai dayun ipaulì ha hurà din uwiten. ");
INSERT INTO bkd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Impalupug ku tag-iya ku uma sa ikatulu ha suluguen ba bà dan dà daan haena binugel daw abuga diyà ta guwà. ");
INSERT INTO bkd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Dayun su tag-iya ku parasan nakahenà-henà hu ‘Inu gid sa buhaten ku? Ay, iyan en diay haini. Suguen ku sa pinalanggà ku ha batà ta tahuran dan gayed haini.’ ");
INSERT INTO bkd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ba su maahà haena ku mga sinaligan miglalang-lalang sidan hu kagi dan ‘Iyan en haini batà hu tag-iya. Himatayan taw ta daw maangken taw en haini sa parasan.’ ");
INSERT INTO bkd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aman inabug dan diyà ta guwà daw himatayi. “Inu man sa buhaten taena ha tag-iya duun ku mga sinaligan din? ");
INSERT INTO bkd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Elegan din gayed sidan daw panhimatayi daan dayun su parasan paalimahan din hu lain ha mga sinaligan.” Su mapaliman haena hu mga etaw minikagi sidan hu “Harì ngaay hayana mahitabù.” ");
INSERT INTO bkd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ba uminahà si Jesus diyà ta kandan daw nanginginsà ha “Ku iyan hayan inu diay sa kahulugan hu insulat ha lalang hu Dios ha tagyanaen ‘Sa batu ha bà dà inlambeg ta abi hu mga tagbalay ha hurà din pulus iyan man diay mahinengdanen ta iyan pakapalig-en hu balay.’ ");
INSERT INTO bkd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Saena ha makadaghà duun taini ha batu magebà gayed, daw saena daan ha mahulugan taini ha batu mabekbek gayed.” ");
INSERT INTO bkd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sa mga manunudlù hu Kasuguan daw sa mga labaw ha sinaligan hu paghalad nan-ahà hu paagi ha madakep dan en gayed si Jesus ta natun-an dan ha iyan sidan tagsubayen ku pananglitan din, ba nahaldek daan sidan hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Binantayan dan haena daw amin daan sinaligan ha iyan maniid hu pagpanginginsà ki Jesus ta tag-angat sidan ha amin din maikagi ha ikasumbung dan kandin ta daw makatugyan dan en si Jesus duun hu gubernador. ");
INSERT INTO bkd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aman inikagiyan ku tagpaniid si Jesus hu “Manunudlù, natun-an day ha laus sa alan ha tag-ikagiyen nu. Hurà nu daan igpalabi daw iyan nu dà tigtudlù sa kamatuuran mahitenged hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aman ikagiyi kay ikaw ku igtugut ba hu Kasuguan taw ha magbayad kuy hu buhis diyà ki Cesar.” ");
INSERT INTO bkd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ba natun-an hi Jesus ha bà dan dà aglimbungi aman inikagiyan din sidan hu ");
INSERT INTO bkd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ipaahà kanak sa salapì ha igbayad nuy hu buhis. Sin-u ha weleng daw ngaran sa nakaugsak duun taini ha salapì?” Tuminubag sidan hu “Iyan si Cesar sa Harì ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dayun inikagiyan sidan hi Jesus ha “Ku kandin diay haini kinahanglan ha iila nuy diyà ki Cesar sa buhis daw iila nuy daan duun hu Dios sa kandin ha bahin.” ");
INSERT INTO bkd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Saena ha tagpaniid ki Jesus hurà gayed makaahà hu katarengan ha makasumbung dan tumenged hu inikagi din duun hu kaet-etawan. Nangabeleng sidan hu mga tubag hi Jesus aman bà dà sidan nakaghagteng. ");
INSERT INTO bkd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amin mga Saduceo ha duminiyà ki Jesus. Saini ha mga etawa harì agtuu ha mabanhaw sa etaw ");
INSERT INTO bkd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","aman inikagiyan dan si Jesus hu “Manunudlù, sa Kasuguan hi Moises tagyanaen ‘Ku matay sa maama ba hurà pa sidan pamatà ki Asawa din kinahanglan ha sa suled taena ha maama asawahen din su bahi ha nabalu ta daw ku magbatà sidan kaliwat pa haena ku suled din ha minatay.’ ");
INSERT INTO bkd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Su anay amin dini pitu ha migsusuled ha pulus maama. Sa kamagulangan kandan nangasawa ba hurà pa sidan pamatà na minatay en. ");
INSERT INTO bkd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Aman inasawa ku manghud din su bahi ha nabalu ba saena ha maama hurà en daan sidan pamatà na minatay en daan hangtud ha su migsusuled alan nakaasawa ku bahi ba alan daan minatay. ");
INSERT INTO bkd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dayun minatay daan su bahi. ");
INSERT INTO bkd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ku mabanhaw asem sa nangamatay sin-u man sa laus ha asawa ku bahi sa pulus en man nakaasawa kandin su pitu ha migsusuled?” ");
INSERT INTO bkd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ba inikagiyan sidan hi Jesus hu “Sa mga etaw iman taini ha panahun tagpangasawa daw tagpaasawa, ");
INSERT INTO bkd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ba saena ha ag-isipen hu Dios ha angayan ha mabanhaw asem daw magtimà diyà ta langit harì en tag-aasawa ");
INSERT INTO bkd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ta mailing en sidan hu mga balinsuguen hu Dios daw mga batà en daan sidan hu Dios ha nabanhaw aman harì en sidan matay. ");
INSERT INTO bkd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mahitenged hu pagkabanhaw taena ha mga minatay bisan ganì si Moises migsulat hu inikagi kandin hu Dios duun ku tagkalegdeg ha sampinit ha tagyanaen ‘Iyan a Dios ha tagsimbahen hi Abraham daw hi Isaac daw hi Jacob.’ ");
INSERT INTO bkd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kenà haena Dios hu mga minatay ba Dios hu mga bubuhay ta duun hu Dios bubuhay sa alan.” ");
INSERT INTO bkd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Amin mga manunudlù hu Kasuguan ha minikagi hu “Manunudlù, maayad gayed sa tubag nu.” ");
INSERT INTO bkd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Inikagi dan haena ta hurà en kandan nakaamel hu pagpanginginsà kandin. ");
INSERT INTO bkd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ininsaan hi Jesus su mga manunudlù hu Kasuguan hu “Imbà agkaikagi hu mga etaw ha su Mesiyas iyan kaliwat hi David? ");
INSERT INTO bkd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ta si David migsulat duun hu mga Salmo ha tagyanaen ‘Inikagiyan hu Dios sa Ginuu ku ha “Dini ka pinuu ta kawanan ku ");
INSERT INTO bkd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hangtud ha madaeg ku sa mga kuntra nu.”’ ");
INSERT INTO bkd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ku inikagi hi David ha Ginuu din su Mesiyas, imbà kabuhat din dà paman haena ha kaliwat?” ");
INSERT INTO bkd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Su tagpaliliman pa sa mga etaw inikagiyan hi Jesus sa mga tinun-an din hu ");
INSERT INTO bkd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Magbantay kaw taena ha mga manunudlù hu Kasuguan. Tagpaaluahà sidan pinaagi hu mga pinaksuy dan ha magayad daw agkalipay sidan ku tahuran hu mga etaw duun hu baligyaanan. Ku diyà sidan ta simbahan iyan dan agkabayaan sa madagway ha pinun-ayà, daw ku duun sidan hu taggastu agkabayaan dan daan ha iyan sidan una igpakaen. ");
INSERT INTO bkd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aglupigan dan daan sa mga balu ha bahi daw ag-agawen dan sa mga katigayunan taena, dayun agtambunan dan sa madaet ha mga buhat dan pinaagi hu pag-ampù ha malugayad. Tumenged taini adagi gayed sa silut kandan.” ");
INSERT INTO bkd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Su diyà si Jesus ta Timplo naahà din sa mga sapian ha mighulug hu halad dan ha salapì duun hu talaguay diyà. ");
INSERT INTO bkd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Amin daan naahà din ha balu ha bahi ha makaluluuy saena mighulug hu halad din ba daruwa dà ha sintabos. ");
INSERT INTO bkd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Minikagi si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha sa in-ila taini ha balu ha bahi labaw pa dì hu inhalad taena ha duma. ");
INSERT INTO bkd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta sa inhalad dan subra dà hu mga katigayunan dan ba saini ha balu bisan ku tungkay makaluluuy ba in-ila din sa iyan-iyan dà ha salapì din.” ");
INSERT INTO bkd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Amin mga duma hi Jesus ha migdayè hu mga dayan-dayan ku Timplo ta binuhat haena pinaagi hu mga mahalen ha batu daw duma pa ha mga dayan-dayan ha inhalad hu mga etaw duun hu Dios. Ba inikagiyan sidan hi Jesus hu ");
INSERT INTO bkd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Makauma gayed sa panahun ha sa agkaahà nuy iman duun taini mangadaet ta sa imbalay taini ha mga batu hurà gayed duun sabuwa ha harì matempag.” ");
INSERT INTO bkd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ininsaan dan haena hu “Manunudlù, kan-u haena agkatuman daw inu sa mga timaan ha madani en haena matuman?” ");
INSERT INTO bkd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tuminubag si Jesus hu “Magbantay kaw ta daw harì kaw malimbungan hu bisan sin-u ta madakel asem sa makadini ha mag-ikagi hu ‘Iyan a su Mesiyas’ daw mag-ikagi daan ha ‘Ubay en sa katapusan hu panahun.’ Ba harì kaw gayed agsunud kandan. ");
INSERT INTO bkd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ku mapaliman nuy asem sa mga gira daw sa mga kagubut harì kaw agkahaldek. Kinahanglan ha mahitabù haena ba kenà pa iyan katapusan hu panahun.” ");
INSERT INTO bkd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dayun minikagi si Jesus diyà ta kandan hu “Magsasabà sa mga nasud daw sa mga ginharian. ");
INSERT INTO bkd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Maglinug hu mabis-ay daw makauma daan sa kauhul daw sa mga dalu ha pakapatay duun hu migkalain-lain ha lugar, daw amin daan maahà diyà ta langit ha pinakahaluhaldek ha mga timaan. ");
INSERT INTO bkd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ba sa harì pa haena mahitabù dakepen kaw daw pasipalahan kaw. Itugyan kaw daan kandan duun hu maghukum inyu duun hu mga simbahan daw mapurisu kaw. Ipaatubang kaw daan duun hu mga harì daw hu mga gubernador tumenged hu pagtuu nuy kanak. ");
INSERT INTO bkd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ba iyan haena paagi ha matultul a inyu diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Harì kaw agkasamuk ku in-inuwen nuy pagpangatarengan ");
INSERT INTO bkd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ta agtudluan ku asem inyu hu ipanubag nuy daw ag-ilahan ku inyu hu katatau ta daw harì kaw madaeg hu mga kuntra nuy. ");
INSERT INTO bkd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bisan sa mga laas nuy daw sa mga suled nuy, sa mga kadumahan nuy daw sa mga amigu nuy itugyan kaw kandan daw sa duma daan inyu himatayan dan. ");
INSERT INTO bkd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kuntrahen kaw hu kaet-etawan tumenged kanak. ");
INSERT INTO bkd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bisan pa ku mahitabù haena ba hurà gayed maalat ha bisan nangkalegas ha buhuk diyan ta ulu nuy. ");
INSERT INTO bkd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ku harì kaw umendà hu pagtuu nuy mailahan kaw hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ku maahà nuy asem ha sa Jerusalem paglibutan en hu mga sundalu matun-an nuy dayun ha laus en haena madaetan. ");
INSERT INTO bkd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Duun asem taena ha panahun sa mga etaw diyà ta Judea mamamulaguy duun hu bubungan, sa mga etaw dini ta Jerusalem gumuwà duun taini daw saena ha duun hu ubayà ha mga banuwa harì sumeled dini ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta iyan en haini panahun ha silutan hu Dios sa mga kaet-etawan ta daw matuman sa insulat ha lalang din. ");
INSERT INTO bkd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pinakahaluhid-u gayed sa mga agkangabedes daw saena ha amin din pa igpasusu duun taena ha panahun. Malegen gayed sa alantusen ta sa silut hu Dios makauma duun hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sa duma mangamatay pinaagi hu magalang daw sa duma mabihag duun hu mga madiyù ha nasud. Sa Jerusalem takunaan hu kenà mga Judio taman ha mauma sa panahun ha matuman sa tagnà mahitenged kandan. ");
INSERT INTO bkd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Amin asem mga timaan ha belenganen duun hu aldaw daw hu bulan daw hu mga bituen. Mangahaldek gayed sa kaet-etawan dini ta kalibutan ta mapaliman dan sa dagulus ta dagat daw hu mga baled. ");
INSERT INTO bkd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sa mga etaw luyahan gayed hu kahaldek dan ku inu sa mahitabù ta kalibutan ta mahuyung sa kalangitan. ");
INSERT INTO bkd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Duun asem taena siak sa Suled hu Kaet-etawan maahà a ha magbulus diyà tayà ha gabunan ha magpangaluanlag daw maahà daan sa pagkagamhanan ku. ");
INSERT INTO bkd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ku magsugud en asem haena harì kaw agkahaldek ta ubay en sa paglibri inyu hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dayun inikagiyan sidan hi Jesus taini ha pananglitan ha tagyanaen “Ahaa nuy sa mga kayu iling hu igira. ");
INSERT INTO bkd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ku lumabung en haena agkatun-an nuy ha madani en sa gulabung. ");
INSERT INTO bkd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iling daan taena ku maahà nuy asem ha matuman en sa alan ha inikagi ku inyu matun-an nuy ha ubay en sa pagharì hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Laus gayed sa ag-ikagiyen ku inyu ha harì pa alan matay sa mga etaw maamin en haena matuman. ");
INSERT INTO bkd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mahanaw pa sa langit daw sa kalibutan ba sa mga lalang ku harì gayed mahanaw. ");
INSERT INTO bkd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Magbantay kaw gayed ha harì kaw bà dà kasamuk hu pagtimà nuy duun taini ha kalibutan daw harì kaw bà dà magpasibelengà ta tigkan makauma sa Aldaw hu Paghukum iling hu lit-ag. ");
INSERT INTO bkd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Saena makauma gayed duun hu alan ha kaet-etawan ha tagtimà dini ta kalibutan. ");
INSERT INTO bkd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aman magbantay kaw gayed daw sigi kaw dà mag-ampù ta daw harì kaw luyahan ku makauma en sa mga hitabù daw harì kaw magayhaan duun hu atubangan ku siak sa Suled hu Kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Aldaw-aldaw nanudlù si Jesus duun ku Timplo. Ku daleman agdiyà ta Buntud ta Olibo hu pagtiduga ");
INSERT INTO bkd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","daw agselem dà sa mga etaw agdiyà ta Timplo hu pagpaliliman kandin. ");
INSERT INTO bkd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Su ubay en sa panahun ha agsaulugen sa Pagkaen hu Supas ha Hurà duun Igpatulin daw Aldaw daan hu Paglabay ");
INSERT INTO bkd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan nan-ahà hu paagi ha mapatay dan si Jesus ta agkahaldek sidan hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dayun si Judas ha tagngaranan daan ki Iscariote ha sabuwa duun ku sampulù daw daruwa ha mga tinun-an hi Jesus inulinan hi Satanas. ");
INSERT INTO bkd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Aman duminuun hu mga labaw ha sinaligan hu paghalad daw hu mga kapitan hu bantay taena ha Timplo daw nakiglalang ku in-inuwen din paglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nangabayà-bayà gayed sidan daw migsasabut ha ag-ilahan dan si Judas hu salapì. ");
INSERT INTO bkd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Uminuyun daan si Judas dayun nan-ahà hu paagi ha makatugyan din si Jesus diyà ta kandan ha harì matun-an hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nakauma sa panahun ha agsaulugen sa Pagkaen hu Supas ha Hurà Duun Igpatulin ha iyan daan panahun hu paghalad hu nati ha karniro hu pagsaulug taena ha Aldaw hu Paglabay. ");
INSERT INTO bkd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aman si Pedro daw si Juan sinugù hi Jesus hu kagi din “Dumiyà kaw daw andama sa igpanihapun taw hu pagsaulug hu Aldaw hu Paglabay.” ");
INSERT INTO bkd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nanginginsà sidan ki Jesus hu “Hindu sa agkabayaan nu ha elegan day hu pagpangandam taena?” ");
INSERT INTO bkd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tuminubag si Jesus ha “Dumiyà kaw ta banuwa daw ku masal-aw nuy sa etaw ha tag-uwit hu bangà ha tinaguan hu wahig, lumupug kaw kandin duun hu balay ha agseledan din. ");
INSERT INTO bkd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Dayun ikagiyi sa tagibalay hu ‘Sa Manunudlù agpanginginsà ku hindu duun tag-amul-amul hu pagpakigsalu hu mga tinun-an din ta tagsaulug.’ ");
INSERT INTO bkd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ipaahà din dayun inyu sa maluag ha kwarto diyà ta latun taena ha balay din ha inandaman en hu mga galamiten hu pagkaen na duun kaw taena pangandam.” ");
INSERT INTO bkd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Duminiyà haena sa mga tinun-an daw natuman gayed sa alan ha inikagi hi Jesus. Aman nangandam sidan hu pagkaen taena ha pagsaulug. ");
INSERT INTO bkd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Su mapengahan en haena mininuu si Jesus daw sa mga tinun-an din hu pagkaen. ");
INSERT INTO bkd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dayun inikagiyan sidan hi Jesus hu “Agkabayà a gayed pakigsalu inyu taini ha pagsaulug sa harì a pa mag-antus ");
INSERT INTO bkd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ta ikagiyen ku inyu ha daw ad en asem isab agkaen taini ku buhaten dà duun hu tagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tuminimù si Jesus hu tasa daw ampui dayun inikagiyan din sidan hu “Bahina nuy haini ");
INSERT INTO bkd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ta ikagiyen ku inyu ha daw ad en asem isab ag-inum hu binu ku magharì en sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tinimù din su supas daw ampui, dayun pinangebing din haena daw ipan-ila kandan ha tagyanaen “Iyan en haini lawa ku ha ighalad para inyu. Kan-a nuy haini daw sigi nuy dà pagbuhaten hu paghenà-henà kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Su makapenga sidan kumaen in-ila din kandan su tasa daw ikagi hu “Iyan en haini langesa ku ha igpamalas hu mga salà nuy ha iyan timaan hu bag-u ha kasabutan hu Dios daw hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Sa etaw ha maglimbung kanak dini en iman ta kanuy. ");
INSERT INTO bkd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Siak sa Suled hu Kaet-etawan matay a gayed sumalà hu katuyuan hu Dios ba kahid-u gayed hu etaw ha maglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dayun migpainsaay sidan ku sin-u kandan sa maglimbung kandin. ");
INSERT INTO bkd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Migsawalà su mga tinun-an hi Jesus ku sin-u kandan sa labaw. ");
INSERT INTO bkd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ba inikagiyan sidan hi Jesus hu “Natun-an nuy en ha sa mga harì hu kenà mga Judio iyan tagbayà hu mga sakup dan, daw sa mga pangulu agkabayà ku dayeen ha iyan nakabulig hu mga sakup dan. ");
INSERT INTO bkd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ba saena harì mahimu diyan ta inyu ta kinahanglan ha sa labaw inyu iyan sa iling hu kinamanghuran daw sa agkabayà ha mabuhat ha agalen iyan sa iling hu suluguen hu alan. ");
INSERT INTO bkd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sin-u man sa labaw? Iyan ba sa bà dà agpinuu daw kaen daw ku iyan ba sa tagtangel? Iyan gayed sa agpinuu daw kaen. Ba siak iling a hu suluguen nuy. ");
INSERT INTO bkd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iyan kaw gayed mga duma ku duun hu alan ha mga alantusen. ");
INSERT INTO bkd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aman iling ha sinaligan a hu Dios ha Amay ku hu pagharì agsaligan ku daan inyu hu pagharì. ");
INSERT INTO bkd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ku magharì a asem makigsalu kaw kanak daw paharian ku inyu sa sampulù daw daruwa ha kaliwatan hi Israel.” ");
INSERT INTO bkd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Si Simon Pedro inikagiyan hi Jesus hu “Magpaliliman ka, Simon. Tinugutan en hu Dios si Satanas ha sulayen kaw kandin ta daw maahà ku iling dà ba hu ukap sa pagtuu nuy. ");
INSERT INTO bkd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ba inampuan ku ikaw, Pedro, ha sa pagsalig nu harì maawà. Ku maglig-en en sa pagtuu nu ipalig-en daan sa pagtuu hu mga duma nu.” ");
INSERT INTO bkd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dayun tuminubag si Pedro hu “Ginuu, andam ad en hu pagduma ikaw diyà ta purisuwan daw bisan pa duun hu kamatayen.” ");
INSERT INTO bkd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ba tinubag hi Jesus hu “Pedro, ikagiyen ku ikaw ha kanina ku harì pa managauk sa manuk katatulu kad en makaikagi ha harì a ikaw agkakilala.” ");
INSERT INTO bkd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ininsaan hi Jesus sa mga tinun-an din ha “Su suguen ku inyu su anay kaw humipanaw ha harì kaw mag-uwit hu salapì, hu lutù daw hu mga ilisan nuy na miglised kaw ba?” Tuminubag sidan ha “Hurà.” ");
INSERT INTO bkd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Inikagiyan sidan hi Jesus hu “Iman ha panahun ku amin nuy salapì daw ilisan uwita nuy haena, daw ku hurà nuy ispada ibaligyà sa duma ha bisti nuy daw palit kaw hu ispada. ");
INSERT INTO bkd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta ikagiyen ku inyu ha matuman gayed sa insulat ha lalang hu Dios ha tagyanaen ‘Ag-isipen haena ha masinupaken daan.’ Sa alan ha intagnà mahitenged kanak tagkatuman en.” ");
INSERT INTO bkd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Uminikagi su mga tinun-an din hu “Ginuu, taini en su daruwa ha ispada.” Tuminubag daan si Jesus ha “Hustu en hayan.” ");
INSERT INTO bkd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Duminiyà si Jesus ta Buntud ta Olibo ta iyan din haena naanadan daw luminupug kandin sa mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Su makauma sidan diyà minikagi si Jesus hu “Mag-ampù kaw ta daw harì kaw madaeg hu panulay.” ");
INSERT INTO bkd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dayun si Jesus migpadiyù-diyù ta kandan daw luhud ha mig-ampù hu kagi din ");
INSERT INTO bkd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amay ku, ku mabayà ka harì a ikaw ipaagi duun taini ha mga alantusen. Ba iyan sa ikaw ha pagbayà matuman kenà iyan sa kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nakauma diyà ta kandin sa balinsuguen hu Dios ha napuun ta langit ha iyan migpabis-ay kandin. ");
INSERT INTO bkd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Miglugul gayed si Jesus aman ayuwà pa naniguru hu pag-ampù ha namanulù diyà ta bugtà sa ating din ha iling hu langesa. ");
INSERT INTO bkd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Su makapenga mag-ampù linikuan din sa mga tinun-an din ba naahà din ha tagtidugahà en sidan tumenged hu kalugul dan. ");
INSERT INTO bkd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Inikagiyan din sidan hu “Imbà kaw tagtidugahà? Bangun kaw daw mag-ampù ta daw harì kaw madaeg hu panulay.” ");
INSERT INTO bkd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Su kamulu pa si Jesus tag-ikagi nakauma en sa mga etaw ha sa tag-una duun iyan si Judas sa sabuwa duun taena ha sampulù daw daruwa ha tinun-an hi Jesus. Inubayan din dayun si Jesus hu paghadek kandin, ");
INSERT INTO bkd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ba inikagiyan hi Jesus ha “Judas, pinaagi ba diay hu paghadek sa paglimbung nu hu Suled hu Kaet-etawan?” ");
INSERT INTO bkd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Su matun-an hu mga tinun-an din ku inu sa maula-ula uminikagi sidan hu “Ginuu, sumukul kay ba kandan pinaagi taini ha ispada day?” ");
INSERT INTO bkd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dayun sa sabuwa kandan tuminigbas hu suluguen ku tungkay labaw ha sinaligan hu paghalad aman nalapung sa kawanan ha talinga din. ");
INSERT INTO bkd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ba si Jesus minikagi hu “Endai en hayan.” Dinampà din dayun sa talinga taena ha suluguen aman naulian. ");
INSERT INTO bkd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Inikagiyan hi Jesus su mga labaw ha sinaligan hu paghalad daw su mga kapitan hu mga bantay taena ha Timplo daw su mga magulang hu “Pangulu a ba hu mga tulisan imbà kaw tag-uuwit hu mga ispada daw mga bunal hu pagdakep kanak? ");
INSERT INTO bkd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aldaw-aldaw diyà a ta Timplo daw nanudlù ba hurà a inyu dakepa. Ba iyan en iman haini natugun ha panahun ha maahà sa gahem hi Satanas.” ");
INSERT INTO bkd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dinakep dan si Jesus daw uwita duun hu balay ku tungkay labaw ha sinaligan hu paghalad. Si Pedro taglupug kandan ba madiyù dà. ");
INSERT INTO bkd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Su magtim-un sa mga etaw diyà ta taliwarà ta lama taena ha balay ta aghidadang sidan uminamul kandan si Pedro. ");
INSERT INTO bkd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Amin suluguen ha bahi ha nakaahà ki Pedro sa taghidadang. Pigtengtengan din dayun minikagi hu “Taini sa duma tayà ha dinakep.” ");
INSERT INTO bkd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ba miglimud si Pedro hu kagi din “Harì ku agkakilala ku sin-u hayana.” ");
INSERT INTO bkd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hurà kalugay naahà si Pedro hu lain ha etaw dayun minikagi ha “Duma ka daan kandin.” Ba si Pedro tuminubag hu “Kenà a.” ");
INSERT INTO bkd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Su maiwas sa nangkauras amin en paman lain ha etaw ha tagyanaen “Duma gayed haini tayaa ta taga-Galilea man daan.” ");
INSERT INTO bkd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Si Pedro tuminubag gihapun hu “Harì ku agkatun-an ku inu sa tagsubayen nu.” Ba su kamulu pa tag-ikagi tuminagauk en sa manuk. ");
INSERT INTO bkd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Luminingì si Jesus daw ahà diyà ki Pedro. Dayun nahenhenaan hi Pedro sa inikagi hi Jesus kandin ha “Ku harì pa kanina managauk sa manuk katatulu kad en makaikagi ha harì a ikaw agkakilala.” ");
INSERT INTO bkd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aman guminuwà si Pedro daw mag-agalaay. ");
INSERT INTO bkd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Saena ha mga etaw ha tagbantay ki Jesus migtameyes daw migbunal daan kandin. ");
INSERT INTO bkd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Binedbed dan sa mata din daw ikagiyi hu “Tagnai ku sin-u kanay sa migsumbag ikaw.” ");
INSERT INTO bkd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Madakel pa gayed sa mga madaet ha pinan-ikagi dan ki Jesus ta daw magayhaan haena. ");
INSERT INTO bkd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Su maselem en sa alan ha mga labaw ha punuan hu mga Judio ha iyan sa mga magulang, sa mga labaw ha sinaligan hu paghalad daw sa mga manunudlù hu Kasuguan mig-amul-amul dayun impaatubang diyà ta kandan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ininsaan dan haena hu “Ikagiyi kay ku iyan kad ba su Mesiyas.” Tuminubag si Jesus hu “Bisan ku ikagiyan ku inyu ba harì kaw gayed tumuu kanak ");
INSERT INTO bkd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","daw ku manginginsà a diyan ta inyu harì kaw daan makatubag. ");
INSERT INTO bkd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ba harì malugay siak sa Suled hu Kaet-etawan minuu a duun hu kawanan taena ha gamhanan ha Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nanginginsà sidan hu “Iyan kad en ba Batà hu Dios?” Tuminubag si Jesus hu “Iyan ad en su inikagi nuy.” ");
INSERT INTO bkd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Dayun minikagi sidan hu “Napaliman taw en sa inikagi din aman hurà en kinahanglan ha amin pa manistigus.” ");
INSERT INTO bkd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Inuwit si Jesus hu alan ha mga labaw ha punuan diyà ki Pilato. ");
INSERT INTO bkd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Insumbung dan haena hu kagi dan “Binistiga day en haini sa etaw aman natun-an day ha migtudlù hu pagsupak hu gubernu ta harì din agtugutan sa mga etaw ha magbayad hu buhis diyà ki Cesar daw kagi din pa daan ha iyan en su Mesiyas ha Harì.” ");
INSERT INTO bkd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aman ininsaan haena hi Pilato hu “Iyan ka ba Harì hu mga Judio?” Tuminubag si Jesus hu “Iyan ad en su inikagi nu.” ");
INSERT INTO bkd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Inikagiyan dayun hi Pilato sa mga labaw ha sinaligan hu paghalad daw sa kaet-etawan ha “Hurà ku naahà ha salà taini ha etaw.” ");
INSERT INTO bkd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba bà dà sidan nasì nangatarengan ha tagyanaen “Iyan haini migsinamuk duun hu mga etaw pinaagi hu pagtudlù din kandan sugud ta Galilea dayun duun hu mga banuwa ta Judea daw bisan iman dini ta Jerusalem.” ");
INSERT INTO bkd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Su mapaliman haena hi Pilato nanginginsà ku taga-Galilea si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Su matun-an din ha si Jesus sakup diay hi Herodes impauwit din diyà ki Herodes ta diyà daan ta Jerusalem taena ha panahun. ");
INSERT INTO bkd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Su maahà hi Herodes si Jesus nalipay gayed ta nalugay en ha agkabayaan din haena ag-ahaa. Napaliman din sa binuhat hi Jesus aman agkabayà daan ag-ahà hu belenganen. ");
INSERT INTO bkd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Siniguru din haena bistigaha ba hurà en gayed magtubag si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Saena ha mga labaw ha sinaligan hu paghalad daw sa manunudlù hu Kasuguan tagtiyadeg diyà ha tagsumbung kandin ha agkangapauk daan. ");
INSERT INTO bkd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dayun si Herodes daw sa mga sundalu din migtameyes en daan ki Jesus daw pinagagayhaan dan. Pininaksuyan dan hu bisti hu harì daw ipalikù diyà ki Pilato. ");
INSERT INTO bkd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Duun taena ha aldaw nakag-amigu en si Herodes daw si Pilato ta su anay migkuntra sidan. ");
INSERT INTO bkd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Inamul-amul hi Pilato sa mga labaw ha sinaligan hu paghalad daw sa duma ha mga punuan daw sa kaet-etawan ");
INSERT INTO bkd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","daw inikagiyan din sidan hu “Inuwit nuy haini sa etaw dini ta kanak ha kagi nuy ha agdasigen din sa mga etaw hu pagsupak hu gubernu. Binistiga ku haini duun hu atubangan nuy ba hurà ku naahà ha salà din, ");
INSERT INTO bkd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","daw inlikù dà haini hi Herodes dini ta kanak ta hurà din daan naahà ha salà din ha angayan ha hukuman hu kamatayen. ");
INSERT INTO bkd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aman agpalagkutan ku iman daw ipaguwà.” ");
INSERT INTO bkd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Inikagi haena hi Pilato ta sa naanadan ku agsaulugen sa Aldaw hu Paglabay iyan sa amin din aglibriyen ha sabuwa ha purisu. ");
INSERT INTO bkd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ba nangulahì sa mga etaw hu kagi dan “Pahimatayi hayana ha etaw daw iyan ipaguwà si Barabas.” ");
INSERT INTO bkd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabas napurisu ta sabuwa haena duun hu migbuhat hu kagubut diyà ta banuwa dayun nakapatay. ");
INSERT INTO bkd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Iyan ngaay aglibriyen hi Pilato si Jesus aman ininsaan din dà sa mga etaw ku inu sa kandan ha agkabayaan. ");
INSERT INTO bkd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ba bà dà sidan nasì migkulahiay ha tagyanaen “Ilansang hayana duun hu krus.” ");
INSERT INTO bkd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Dayun ininsaan din sidan hu ikatulu ha “Imbà nuy igpalansang hayana? Inu diay sa nabuhat din ha madaet? Ta hurà ku gayed naahà ha salà din ha angayan ha silutan hu kamatayen. Aman bà ku dà hayana agpalagkuti daw ipaguwà.” ");
INSERT INTO bkd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ba bà dà nasì migkulahiay sa mga etaw ha ilansang gayed si Jesus duun hu krus hangtud ha nakaghagteng si Pilato. ");
INSERT INTO bkd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aman in-ila din kandan sa pinanayù dan. ");
INSERT INTO bkd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Impaguwà hi Pilato si Barabas sa napurisu ta migbuhat hu kagubut diyà ta banuwa daw nakapatay, dayun si Jesus intugyan din duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Su tag-uwiten dan en si Jesus diyà ta guwà taena ha banuwa nasal-aw dan sa etaw ha taga-Cirene ha tagngaranan ki Simon, dayun pineges dan ha tiangen din su krus daw lupug ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Madakel ha mga etaw sa namanduma kandan daw amin daan mga bahi ha tag-agalà hu paglugul tumenged kandin. ");
INSERT INTO bkd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ba si Jesus luminingì diyà ta kandan daw minikagi hu “Sinyu sa mga bahi diyan ta Jerusalem, harì a inyu ag-agalai ba iyan nuy agalaan sa inyu ha kaugalingen daw sa mga batà nuy. ");
INSERT INTO bkd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta makauma sa adagi ha kasamuk ha makaikagi kaw hu ‘Maayad pa haena sa bahi ha hurà din batà ha tag-alimahan.’ ");
INSERT INTO bkd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Duun asem taena ha panahun ikagiyan hu mga etaw sa mga bubungan hu ‘Kalunawi kay en.’ ");
INSERT INTO bkd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ku binuhat dan haini dini ta kanak ha hurà ku salà iyan kaw pa kan harì dan buhatan taini.” ");
INSERT INTO bkd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Amin daan daruwa ha masinupaken ha inuwit dan ta daw mahimatayan duma ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Su makauma sidan duun hu lugar ha tagngaranan hu Tul-an hu Ulu hu Etaw inlansang dan si Jesus duun hu krus duma hu daruwa ha masinupaken, sa sabuwa diyà dapit ta kawanan din daw sa sabuwa diyà ta gibang din. ");
INSERT INTO bkd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dayun mig-ampù si Jesus hu kagi din “Amay ku, pasayluwa sidan ta hurà dan katun-i sa tagbuhaten dan.” Binahin taena ha mga sundalu sa pinaksuy hi Jesus pinaagi hu ripa. ");
INSERT INTO bkd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Madakel ha mga etaw sa tag-ahà ki Jesus ba sa mga punuan migtameyes kandin hu kagi dan “Aglibriyen din man gid sa duma ha mga etaw aman ahaen taw ku malibri din ba sa kaugalingen din ta iyan en man gid su Mesiyas sa Harì ha pinilì hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Su mga sundalu migtameyes daan kandin. Impainum dan haena hu sukà ");
INSERT INTO bkd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","daw ikagiyi ha “Ku Harì ka man hu mga Judio libriya sa kaugalingen nu.” ");
INSERT INTO bkd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sa sampaw ta ulu hi Jesus sinulatan hu “Iyan haini Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Su sabuwa duun taena ha masinupaken ha inlansang duma kandin migtameyes daan ha tagyanaen “Kenà ka ba iyan su Mesiyas? Aman libriya en sa kaugalingen nu daw sikay.” ");
INSERT INTO bkd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ba binaldeng haena ku duma din ha masinupaken hu “Harì ka ba diay agkahaldek hu Dios sa alan kuy man hinukuman hu kamatayen? ");
INSERT INTO bkd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Sikit sa daruwa angayan ha silutan ta laus ha nakasalà ki ba hurà gayed salà taini ha duma ta.” ");
INSERT INTO bkd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dayun inikagiyan din si Jesus hu “Ginuu, henhenaa a ikaw asem ku magharì ka.” ");
INSERT INTO bkd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tuminubag si Jesus hu “Laus gayed sa ag-ikagiyen ku ikaw ha iman taini ha aldaw makagduma-duma kid en duun hu madagway ha banuwa hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Su maugtu en sa aldaw suminukilem sa tibuuk ha kalibutan hu tatulu ha uras ");
INSERT INTO bkd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ta hurà en siga sa aldaw. Su makepal ha manggad ha in-elang diyà ta Timplo naliwarà nayahà. ");
INSERT INTO bkd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nangulahì si Jesus hu “Amay ku, igtugyan ku ikaw sa ispiritu ku.” Su maikagi din haena nabugtuan dayun. ");
INSERT INTO bkd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Su maahà ku kapitan hu mga sundalu sa nahitabù dinayè din sa Dios hu kagi din “Laus gayed ha saini ha etaw hurà din salà.” ");
INSERT INTO bkd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sa nangaamul-amul diyà su maahà dan sa naul-ulahan naman-ulì sidan ha miglugul. ");
INSERT INTO bkd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sa mga kadumahan hi Jesus daw su mga bahi ha duminuma kandin ha diyà napuun ta Galilea nakaahà daan taini ha mga hitabù, ba diyà dà sidan ta madiyù. ");
INSERT INTO bkd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Amin etaw ha tagngaranan ki Jose ha taga-Arimatea ha sakup ta Judea. Saena matareng gayed ha etaw ha tagsalap hu pagharì hu Dios daw sabuwa daan duun taena ha labaw ha punuan ba hurà hu kandin uyun ha himatayan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Duminiyà haena ki Pilato daw panayua sa lawa hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dayun tinimù din haena daw bungkusi hu maputì ha manggad daw itagù duun hu bag-u din pa binangbangi ha dampiyas. ");
INSERT INTO bkd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hapun haena hu Biernes na ku sumalep sa aldaw agsugud en sa Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sa mga bahi ha namanduma ki Jesus ha napuun diyà ta Galilea luminupug ki Jose aman naahà dan sa lebeng daw ku pig-inu-inu sa kalebenga ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dayun naman-ulì sidan daw nangandam hu mga kalasi hu mga pahumut para hu lawa hi Jesus. Ba duun hu Aldaw hu Paghimlay huminimlay sidan sumalà hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Su kaaldawen en hu Dominggo sa mga bahi ha tag-uwit hu pig-andam dan ha mga pahumut duminuun ku piglebengan ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Su makauma sidan duun ku lebeng naahà dan ha naawà en su batu ha in-ipel duun. ");
INSERT INTO bkd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ba su sumeled sidan hurà dan kaahà sa lawa hi Jesus ");
INSERT INTO bkd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","aman nangalibeg sidan ku inu sa nahitabù. Dayun tigkan nakahiwal diyà ta kandan sa daruwa ha maama ha tagpinaksuy hu tagpangaluanlag. ");
INSERT INTO bkd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Saena ha mga bahi luminuhud ha nakadunghuy ta nangahaldek, ba inikagiyan sidan ku mga maama hu “Imbà nuy duun taini ha lebeng agpan-ahaa sa bubuhay ha etaw? ");
INSERT INTO bkd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Saena hurà en dini ta nabanhaw en. Henhenaa nuy haena sa inikagi din inyu su diyà kaw pa ta Galilea ");
INSERT INTO bkd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ha kinahanglan ha sa Suled hu Lucas 24:1-2 Kaet-etawan itugyan duun hu mga makasasalà ha etaw daw ilansang duun hu krus ba duun hu ikatulu ha aldaw mabanhaw dà.” ");
INSERT INTO bkd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Dayun nahenhenaan dan haena sa mga lalang hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Su lumikù sidan tinultulan dan su sampulù daw sabuwa ha apostoles daw sa duma pa ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Saini ha mga bahi ha nanunultul duun hu mga apostoles iyan si Maria Magdalena daw si Juana, si Maria ha inay hi Santiago daw amin pa duma ha mga bahi. ");
INSERT INTO bkd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ba hurà tuu su mga apostoles ta bà su kenà laus ha tultul. ");
INSERT INTO bkd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ba si Pedro minulalaguy dayun payanaen duun ku lebeng. Sinil-ip din su lebeng ba iyan din dà naahà su maputì ha manggad ha nakaugsak. Dayun minulì ha nabeleng gayed taena ha nahitabù. ");
INSERT INTO bkd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Duun taena ha aldaw amin daruwa ha sumusunud hi Jesus ha napuun ta Jerusalem daw tagdiyà ta banuwa ta Emaus, sampulù daw tatulu ha kilomitro sa pig-elangan taini. ");
INSERT INTO bkd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Su taghipanaw sidan tagsubayen dan su nahitabù. ");
INSERT INTO bkd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tigkan nakaduma kandan si Jesus ");
INSERT INTO bkd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ba hurà magpakilala kandan. ");
INSERT INTO bkd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ininsaan sidan hi Jesus hu “Inu sa tagsubayen nuy?” Tuminaleen sidan sa tagmaleleng. ");
INSERT INTO bkd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sa sabuwa kandan ha si Cleopas tuminubag hu “Sabubuwa ka dà gid ha nakadini ta Jerusalem ha hurà makatuen hu naul-ulahan iman dini.” ");
INSERT INTO bkd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nanginginsà si Jesus hu “Inu man diay sa nahitabù?” Saena inikagiyan dan hu “Mahitenged ki Jesus ha taga-Nazaret sa sabuwa ha propita daw tinuuwan hu mga etaw tumenged hu belenganen ha binuhat din daw hu mga pagtudlù din ha amin duun gahem. ");
INSERT INTO bkd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ba intugyan hu mga labaw ha sinaligan hu paghalad daw hu duma ha mga punuan taw ta daw mahukuman hu kamatayen dayun inlansang duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Taghinam kay en ngaay ha iyan en haena maglibri hu mga kaliwatan hi Israel ba iman ikatulu en ha aldaw hu kahitabù taena. ");
INSERT INTO bkd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nangabeleng kay daan ta amin day mga duma ha bahi ha duminuun ku lebeng din ganin ha kaaldawen ");
INSERT INTO bkd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ba hurà dan kaahà sa lawa din. Aman luminikù sidan dini ta kanay daw tultuli kay kandan ha amin mga balinsuguen hu Dios ha nakahiwal diyà ta kandan daw mig-ikagi ha nabanhaw en si Jesus. ");
INSERT INTO bkd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Amin day pa gayed mga duma ha duminuun ku lebeng daw naahà dan ha laus gayed sa inikagi ku mga bahi ta hurà dan kaahà sa lawa hi Jesus.” ");
INSERT INTO bkd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dayun inikagiyan sidan hi Jesus hu “Mga buang-buang kaw ha mga etaw, imbà kaw harì agtuu taena ha inikagi su anay hu mga propita? ");
INSERT INTO bkd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kenà ba kinahanglan ha su Mesiyas makaagi hu mga alantusen daw human magharì?” ");
INSERT INTO bkd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dayun insaysay hi Jesus diyà ta kandan sa mahitenged hu kaugalingen din ha nakasulat duun hu lalang hu Dios pinaagi ki Moises daw hu alan ha mga propita. ");
INSERT INTO bkd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Su makauma sidan duun ku banuwa ha agpayanan-an dan agdayun ngaay si Jesus, ");
INSERT INTO bkd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ba hinawidan dan haena hu kagi dan “Dini ka dà magtimà ta kanay ta agkadaleman en.” Aman diyà dà si Jesus migtimà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Su agkaen en sidan tinimù din su supas daw ampui dayun pinangebing din haena daw ipan-ila kandan. ");
INSERT INTO bkd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Dayun human dan nakilala si Jesus ba tigkan dan dà nahanaw. ");
INSERT INTO bkd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Migpainsaay sidan hu “Iyan gid diay gan tungkay ta igkabayà-bayà su tagtudluan ki kandin hu insulat ha lalang hu Dios su diyà kuy pa ta dalan.” ");
INSERT INTO bkd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sagunà sidan luminikù diyà ta Jerusalem daw elegi su tag-amul-amulan ku mga apostoles daw hu mga duma dan. ");
INSERT INTO bkd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Saena ha mig-amul-amul naman-ikagi hu “Laus gayed ha nabanhaw sa Ginuu ta migpaahà haena diyà ki Simon.” ");
INSERT INTO bkd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dayun su daruwa ha etaw nanunultul daan hu nahitabù diyà ta dalan daw hu pagkakilala dan ki Jesus su pangebingen din en su supas. ");
INSERT INTO bkd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Su kamulu pa tag-ikagi sa mga apostoles migpaahà si Jesus diyà ta taliwarà dan daw ikagi hu “Magmalinawen kaw.” ");
INSERT INTO bkd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nakignat sidan daw nangahaldek ta abi dan ha kalag haena. ");
INSERT INTO bkd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ba inikagiyan sidan hi Jesus hu “Imbà kaw agkasamuk daw imbà kaw tagduwa-duwa mahitenged kanak? ");
INSERT INTO bkd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iyan ad en haini. Ahaa sa alima ku daw sa paa ku. Ibiti a inyu ta sa kalag hurà din lawa ha iling iman kanak.” ");
INSERT INTO bkd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Su maikagi din haena impaahà din kandan sa alima din daw sa paa din. ");
INSERT INTO bkd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nangabayà-bayà sidan daw nangabeleng ba tagduwa-duwa pa sidan ku iyan en ba gayed haena, aman nanginginsà si Jesus hu “Amin nuy ba agkakaen dini?” ");
INSERT INTO bkd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inilahan dan haena hu inanag ha sedà ");
INSERT INTO bkd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","dayun kinaen din duun hu atubangan dan. ");
INSERT INTO bkd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Inikagiyan din sidan hu “Iyan en haini inikagi ku inyu su anay ha tagduma-dumahà kuy sa kinahanglan ha matuman gayed sa alan ha nakasulat mahitenged kanak duun hu Kasuguan hi Moises daw hu mga insulat hu propita daw duun hu mga Salmo.” ");
INSERT INTO bkd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dayun impasabut din kandan sa alan ha insulat ha lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Minikagi haena hu “Sa insulat ha lalang hu Dios tagyanaen ‘Su Mesiyas kinahanglan ha makaagi hu mga alantusen daw matay gayed ba duun hu ikatulu ha aldaw mabanhaw dà.’ ");
INSERT INTO bkd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aman agsuguen ku inyu ha isangyaw nuy duun hu kaet-etawan sugud ta Jerusalem payanaen hu alan ha mga nasud ha ku maghinulsul sidan mapasaylu gayed sa mga salà dan. ");
INSERT INTO bkd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iyan kaw iman mga tistigus taena ha katumanan hu mga tagnà. ");
INSERT INTO bkd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ba magtimà kaw pa enà dini ta Jerusalem daw angati nuy sa Balaan ha Ispiritu ha insaad hu Dios ta agsuguen ku haena diyan ta inyu daw gaheman kaw kandin.” ");
INSERT INTO bkd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Su mauma en hi Jesus su mga apostoles din diyà ta Betania imbayaw din sa mga alima din daw panalangini sidan. ");
INSERT INTO bkd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Su kamulu din pa sidan tagpanalangini nabatun haena payanaen diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Dayun suminimba kandin su mga apostoles daw likù diyà ta Jerusalem ha malipayen gayed. ");
INSERT INTO bkd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Aldaw-aldaw agdiyà sidan ta Timplo hu pagdayè hu Dios.");
INSERT INTO bkd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Su hurà pa tanghagaa sa bisan inu duduun en haena sa tagngaranan hu Lalang, daw sa Lalang iyan duma hu Dios ha iling din dà daan. ");
INSERT INTO bkd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Su hurà pa tanghagaa sa bisan inu sa Lalang duduun en duma hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pinaagi kandin tinanghagà sa alan daw hurà en gayed natanghagà ha kenà pinaagi kandin. ");
INSERT INTO bkd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sa Lalang iyan tag-ila hu kinabuhì daw saena ha kinabuhì iyan sulù ha pakailaw hu henà-henà hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Saena ha sulù iyan ilaw duun hu masukilem daw harì en gayed mapedengan. ");
INSERT INTO bkd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Amin etaw ha sinugù hu Dios ha tagngaranan ki Juan ha Bautista. ");
INSERT INTO bkd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Sinugù haena hu pagpanunultul mahitenged taena ha sulù ta daw makatuu sa kaet-etawan pinaagi kandin. ");
INSERT INTO bkd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Si Juan kenà iyan sulù ba bà dà sinugù hu pagpanunultul mahitenged ku sulù. ");
INSERT INTO bkd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sa sulù ha pakailaw hu henà-henà hu kaet-etawan agpakauma en dini ta kalibutan. ");
INSERT INTO bkd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Iman nakauma en gayed dini ta kalibutan. Ba bisan ku tinanghagà sa kalibutan pinaagi kandin saena hurà kakilala hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Duminuun hu kaugalingen din ha lugar ba hurà dawata hu mga duma din. ");
INSERT INTO bkd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ba sa alan ha nakadawat kandin daw nakatuu daan inilahan din hu katenged ha mabuhat ha mga batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Sa ingkabuhat dan ha mga batà hu Dios harì agkailing hu kalibutanen ha paagi daw kenà daan tumenged hu pagbayà hu etaw ta pinaagi gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Saena ha Lalang migpakaetaw daw uminamul kanuy hu mababà ha panahun. Naahà day sa pagkagamhanan ha in-ila kandin hu Dios ha Amay din tumenged ta iyan bugtung ha Batà din. Saena maluluy-en gayed daw natun-an taw en diyà ta kandin sa kamatuuran. ");
INSERT INTO bkd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iyan haini intultul hi Juan duun hu kaet-etawan su umikagi hu madaging ha tagyanaen “Iyan en haini su tagsubayen ku ha ‘Amin pa makadini ha labaw dì kanak ta duduun en su hurà a pa ibatà.’” ");
INSERT INTO bkd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tumenged ta maluluy-en gayed harì agkapangkus sa pag-ila din kanuy hu mga panalangin. ");
INSERT INTO bkd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pinaagi ki Moises in-ila hu Dios sa Kasuguan, ba pinaagi ki Jesu Cristo inilahan kuy kandin hu grasya daw natun-an taw daan diyà ta kandin sa kamatuuran. ");
INSERT INTO bkd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hurà gayed etaw ha nakaahà hu Dios, ba sa bugtung ha Batà din ha dayun dà tagduma kandin iyan migpakilala kanuy hu Amay din. ");
INSERT INTO bkd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iyan haini intultul hi Juan su suguen hu mga punuan ta Jerusalem sa mga sinaligan hu paghalad daw sa mga kaliwat hi Levi ha mga magbubulig dan ha dumiyà ki Juan ta daw mainsaan dan ku sin-u. ");
INSERT INTO bkd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Inikagi kandan hi Juan sa laus ha “Kenà a iyan su Mesiyas.” ");
INSERT INTO bkd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aman nanginginsà sidan hu “Sin-u ka diay? Iyan kad en ba si Elias ha propita?” Ba tuminubag si Juan hu “Kenà a iyan.” Minisab sidan nanginginsà hu “Iyan kad en ba su tagsalapen day ha Propita?” Tuminubag gihapun si Juan hu “Kenà a daan iyan.” ");
INSERT INTO bkd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aman minikagi sidan hu “Ikagiyi kay ku sin-u ka ta kinahanglan ha amin day makatultul taena ha migsugù kanay. Inu sa maikagi nu mahitenged hu kaugalingen nu?” ");
INSERT INTO bkd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tuminubag si Juan hu “Iyan a su intagnà hi Isaias ha magkulahiay duun hu pinakabulung-bulung ha lugar ha magyanaen ‘Tul-ida sa dalan ha ag-agiyan hu Ginuu.’” ");
INSERT INTO bkd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Saena ha mga sinugù hu mga Fariseo ");
INSERT INTO bkd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","nanginginsà ha “Ku kenà ka iyan su Mesiyas daw ku kenà ka daan iyan si Elias daw saena ha tagsalapen day ha Propita, imbà nu agpamautismuwi sa mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ba tuminubag si Juan hu “Diyà a ta wahig agpamautismu ba amin diyan ta inyu ha hurà nuy pa kakilala. ");
INSERT INTO bkd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Saena hudiyan dì kanak ba iyan labaw ta bisan sa paghukad hu sapatus din kenà a gayed angayan duun.” ");
INSERT INTO bkd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nahitabù haena diyà ta Betania ha layun ta Jordan ha duun namautismu si Juan. ");
INSERT INTO bkd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Su maisab ha aldaw naahà hi Juan si Jesus ha tagdiyà ta kandin. Dayun uminikagi si Juan hu “Taini en sa Nati ha Karniro ha sinugù hu Dios ta daw makapalas hu salà hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iyan haini tagsubayen ku ha ‘Amin pa makadini ha labaw dì kanak ta duduun en su hurà a pa ibatà.’ ");
INSERT INTO bkd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Su anay hurà ku kakilala haini, ba migpamautismu a ta daw ku makauma en makilala gayed hu kaliwatan hi Israel.” ");
INSERT INTO bkd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Dayun iyan haini intultul hi Juan ha tagyanaen “Naahà ku sa Balaan ha Ispiritu ha agkailing hu salapati ha migbulus daw hurà en awà diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Saini hurà ku ngaay kakilala ba sa Dios ha iyan migsugù kanak hu pagpamautismu daan en minikagi kanak ha ‘Ku maahà nu sa etaw ha agbulusan hu Balaan ha Ispiritu ha harì en umawà diyà ta kandin iyan en su tagpamautismu pinaagi hu pagpaulin hu Balaan ha Ispiritu.’ ");
INSERT INTO bkd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iman naahà kud en daw maikagi kud en inyu ha iyan gayed haini Batà hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Su maisab ha aldaw diyà en paman si Juan duma hu daruwa ha mga sumusunud din. ");
INSERT INTO bkd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Su maahà din si Jesus sa aglabay diyà ta kandan inikagiyan din su daruwa hu “Taini en su Nati ha Karniro ha sinugù hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Su mapaliman ku daruwa ha sumusunud sa inikagi din luminupug dayun sidan ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Su lumingì si Jesus naahà din su taglupug kandin aman ininsaan din sidan hu “Inu sa agkabayaan nuy?” Tuminubag sidan hu “Hindu ka tagtimà, Rabi?” ha sa kahulugan taena Manunudlù. ");
INSERT INTO bkd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tuminubag si Jesus ha “Dumuma kaw kanak ta daw nuy maahà.” Aman duminuma sidan ki Jesus daw naahà dan labi. Agkahapun en duun taena ba hurà en sidan suway hangtud ha masukilem en. ");
INSERT INTO bkd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Sa sabuwa kandan ha nakapaliman hu inikagi hi Juan ha luminupug ki Jesus iyan si Andres ha suled hi Simon Pedro. ");
INSERT INTO bkd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inelegan din sagunà si Simon daw ikagiyi hu “Naahà day en sa Mesiyas” ha tagngaranan daan ki Cristo. ");
INSERT INTO bkd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dayun dinuma din si Simon diyà ki Jesus. Su maahà hi Jesus si Simon inikagiyan din hu “Sa ngaran nu iyan si Simon ha batà hi Juan, ba sa igngaran ku iman ikaw iyan en si Cefas” ha Pedro daan ha sa kahulugan din Batu. ");
INSERT INTO bkd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Su maisab ha aldaw nahenhenaan hi Jesus ha dumiyà ta probincia ta Galilea. Inelegan din si Felipe daw ikagiyi ha “Dumuma ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Felipe taga-Betsaida ha tagtimaan daan hi Andres daw hi Pedro. ");
INSERT INTO bkd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aman sagunà inelegan hi Felipe si Natanael daw ikagiyi hu “Naahà day en haena sa etaw ha sinubay hu mga propita daw sa sinubay daan hi Moises duun hu Kasuguan. Iyan haena si Jesus sa batà hi Jose ha taga-Nazaret.” ");
INSERT INTO bkd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ba si Natanael nakaikagi hu “Amin ba diay mapuslanen ha etaw diyà ta Nazaret?” Tuminubag si Felipe ha “Dumiyà ki ta daw maahà nu.” ");
INSERT INTO bkd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Su maahà hi Jesus si Natanael ha tagdiyà en ta kandin uminikagi dayun hu “Iyan gayed hayana kaliwat hi Israel ta agkaahà ku ha hurà gayed limbung diyà ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ba nanginginsà si Natanael hu “Imbà a man ikaw agkakilala?” Tuminubag si Jesus ha “Su hurà ka pa elegi hi Felipe naahà kud en ikaw duun hu sileb taena ha kayu ha igira.” ");
INSERT INTO bkd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Dayun uminikagi si Natanael hu “Manunudlù, iyan ka gayed Batà hu Dios. Iyan ka haena sa tagsalapen day ha magharì hu mga kaliwatan hi Israel.” ");
INSERT INTO bkd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Minikagi si Jesus hu “Nakatuu ka ba ta inikagi ku ha naahà ku ikaw duun hu sileb taena ha kayu? Ba amin pa tungkay belenganen ha maahà nu asem ku malugay.” ");
INSERT INTO bkd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Inikagiyan din daan sidan hu “Laus gayed sa ag-ikagiyen ku inyu ha maahà nuy sa langit ha mapuwaan daw sa mga balinsuguen hu Dios ha magdini-dini ta kanak siak sa Suled hu Kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Su maiwas en sa daruwa ha aldaw amin kaamulan diyà ta Cana ha sakup ta Galilea. Tuminampu sa inay hi Jesus ");
INSERT INTO bkd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","daw inimbita daan si Jesus daw sa mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Su maamin en sa binu inikagiyan si Jesus hi Inay din hu “Naamin en sa binu.” ");
INSERT INTO bkd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ba tuminubag si Jesus ha “Hurà kinahanglan ha suguen a ikaw ta kenà pa haini panahun ha maahà sa gahem ku hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inikagiyan hi Inay din sa mga suluguen ha “Buhata nuy sa sumalà ha igsugù din inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Diyà ta ubay dan amin haenem ha tadyaw ha talaguay hu wahig ha iyan taggamiten hu mga Judio ku agtumanen dan sa tulumanen hu paglimpyu. Sa kada sabuwa taena ha tadyaw agkataguan hu katluan ha galun ha wahig. ");
INSERT INTO bkd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Inikagiyan hi Jesus sa mga suluguen hu “Pamunua hu wahig haini sa tadyaw.” Aman pinamunù dan. ");
INSERT INTO bkd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Dayun minikagi si Jesus diyà ta kandan hu “Saluk kaw duun daw uwita diyà tayà ha tagbayà hu kaamulan.” Aman tuminuu sidan. ");
INSERT INTO bkd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pigkinanaman ku tagbayà hu kaamulan su wahig ha nabuhat en ha binu. Hurà din katun-i ku hindu haena napuun ba natun-an ku mga suluguen ha migsaluk duun. Dayun inumaw din haena sa agpangasawa ");
INSERT INTO bkd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","daw ikagiyi hu “Sa duma ha mga etaw iyan dan ig-una igpainum sa maemis ha binu. Ku madalem en sa nainum hu mga etaw human dan igpainum sa kenà ayuwà maayad. Ba sikaw hinudiyan nu haini sa binu ha tungkay maemis.” ");
INSERT INTO bkd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Saena ha binuhat hi Jesus diyà ta Cana ha sakup ta Galilea iyan nauna ha belenganen ha binuhat din. Pinaagi taena nakapaahà din sa pagkagamhanan din aman nakatuu kandin sa mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Su maiwas en haena duminiyà si Jesus ta Capernaum duma ki Inay din, hu mga suled din daw hu mga tinun-an din, daw migtimà sidan diyà hu pila ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Su madani en agsaulugen hu mga Judio sa Aldaw hu Paglabay duminiyà si Jesus ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diyà ta Timplo naahà din sa mga tagbabaligyà hu mga baka, mga karniro daw mga salapati, daw naahà din daan sa tagpinuu abay hu lamisahan ha tagpamaylu hu mga salapì. ");
INSERT INTO bkd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aman binuhat din sa lagkut ha pisì daw pan-abuga sa mga etaw duma hu mga karniro daw mga baka dan. Insawed din sa mga salapì ku tagpamaylu dayun pinamantang din sa mga lamisahan dan. ");
INSERT INTO bkd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Inikagiyan din su tagbabaligyà hu salapati hu “Awaa nuy hayan. Harì nuy agbuhata ha baligyaanan haini sa balay hu Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nahenhenaan dayun hu mga tinun-an din sa insulat duun hu lalang hu Dios ha tagyanaen “Dios ha Magbabayà hu alan, masakit gayed tungkay sa gahinawa ku tumenged taini ha balay nu ta agkanugunan ku gayed.” ");
INSERT INTO bkd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Dayun sa mga punuan hu mga Judio nanginginsà diyà ki Jesus hu “Amin ba belenganen ha makapaahà nu kanay ta daw day matun-an ha amin nu katenged hu pagbuhat taena?” ");
INSERT INTO bkd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tuminubag si Jesus hu “Kagasa nuy haini sa timplo ta agbalayen ku dà duun hu tatulu ha aldaw.” ");
INSERT INTO bkd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Minikagi sidan hu “Kapatan daw haenem ha tuig sa kabalaya taini ha Timplo na agbalayen nu ba hu tatulu dà ha aldaw?” ");
INSERT INTO bkd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ba sa timplo ha sinubay hi Jesus iyan sa lawa din. ");
INSERT INTO bkd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Su mabanhaw en si Jesus nahenhenaan hu mga tinun-an din haena sa inikagi din daw tinuuwan dan daan sa insulat ha lalang hu Dios ha inikagi din mahitenged hu pagkabanhaw din. ");
INSERT INTO bkd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Su diyà pa si Jesus ta Jerusalem su panahun hu pagsaulug hu Aldaw hu Paglabay madakel tungkay sa nakatuu kandin ta naahà dan sa mga belenganen ha binuhat din. ");
INSERT INTO bkd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ba si Jesus hurà kabenali hu pagtuu dan kandin ta natun-an din en ku inu sidan. ");
INSERT INTO bkd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hurà en kinahanglan ha tultulan pa si Jesus mahitenged hu mga etaw ta daan din en natun-an ku inu sa duun hu mga henà-henà dan. ");
INSERT INTO bkd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Amin sakup hu mga Fariseo ha tagngaranan ki Nicodemo ha sabuwa duun taena ha mga labaw ha punuan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Su masukilem en duminiyà haena ki Jesus daw ikagiyi hu “Manunudlù, natun-an day ha iyan ka manunudlù ha sinugù hu Dios ta sa mga belenganen ha tagbuhaten nu iyan dà pakahimu duun sa etaw ha tagdumahan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tuminubag si Jesus hu “Laus gayed sa ag-ikagiyen ku ikaw ha sa etaw ku harì iisab ibatà harì gayed maharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Dayun nanginginsà si Nicodemo hu “In-inuwen pa hu magulang en ha iisab dà ibatà sa harì en man makalikù diyà ta getek hi Inay din?” ");
INSERT INTO bkd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tuminubag si Jesus hu “Laus gayed sa tag-ikagiyen ku ikaw ha iyan dà maharian hu Dios sa etaw ha ibatà pinaagi hu wahig daw pinaagi hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa igbatà pinaagi hu etaw na etaw dà daan, ba sa igbatà pinaagi hu Balaan ha Ispiritu amin din en kinaiya ha iling hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Harì ka mabeleng taena ha inikagi ku ikaw ha ‘Kinahanglan ha iisab kaw dà ibatà.’ ");
INSERT INTO bkd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sa kalamag duun agpayanaen hu bisan hindu daw agkatun-an taw ku hindu duun ta agkapaliman taw, ba harì taw agkatun-an ku hindu napuun daw ku hindu duun agpayanaen. Iling daan sa gahem hu Balaan ha Ispiritu duun hu etaw ha ibatà pinaagi kandin ta harì haena agkasabut hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nanginginsà si Nicodemo hu “In-inuwen man hayana?” ");
INSERT INTO bkd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tuminubag si Jesus hu “Matatau ka ha manunudlù duun hu mga kaliwatan hi Israel, imbà nu man harì agkasabut sa tag-ikagiyen ku? ");
INSERT INTO bkd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Laus gayed sa ag-ikagiyen ku ha sa intudlù day iyan sa natun-an day daw sa tagsubayen day iyan sa naahà day ba harì nuy agdawaten. ");
INSERT INTO bkd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ku harì kaw agtuu ku ikagiyen ku inyu sa mga hitabù dini ta kalibutan in-inuwen nuy pagtuu ku ikagiyen ku inyu sa diyà ta langit? ");
INSERT INTO bkd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Amin ba nakadiyà ta langit daw luminugnà dini hu pagpanunultul hu naahà din diyà? Hurà gayed, ba siak sa Suled hu Kaet-etawan diyà a napuun. ");
INSERT INTO bkd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Su duun pa si Moises hu pinakabulung-bulung ha lugar intaud din sa bunsalagan ha binuhat hu galang duun hu kayu daw ipatangkaw ta daw sa etaw ha umahà taena harì gayed matay. Iling daan taena ha sa Suled hu Kaet-etawan kinahanglan ha itaud duun hu kayu daw ipatangkaw ");
INSERT INTO bkd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ta daw sa alan ha tumuu kandin mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Palanggà gayed hu Dios sa alan ha kaet-etawan aman in-ila din sa bugtung ha Batà din ta daw sa alan ha tumuu taena harì en masilutan ba mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta hurà sugua hu Dios sa Batà din dini ta kalibutan hu paghukum hu silut duun hu kaet-etawan, ba impadini din haena ta daw maluwas sa mga etaw pinaagi kandin. ");
INSERT INTO bkd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bisan sin-u sa tumuu taena harì en mahukuman hu silut, ba saena ha harì tumuu daan en nahukuman ta hurà tuu hu bugtung ha Batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyan haini hinengdan ha aghukuman sa mga etaw. Su makauma dini ta kalibutan sa sulù iyan dan impalabi sa masukilem ta madaet gayed sa mga buhat dan. ");
INSERT INTO bkd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bisan sin-u sa tagbuhat hu madaet agtambag hu mapawà daw tagpadiyù duun ta agkahaldek ha matun-an sa mga buhat din ha madaet. ");
INSERT INTO bkd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ba saena ha tagsunud hu kamatuuran duun gayed hu mapawà aman agkatun-an sa buhat din ha ginaheman gayed hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Su maiwas en haena si Jesus daw sa mga tinun-an din duminiyà ta probincia ta Judea. Migtimà sidan diyà hu pila ha aldaw daw namautismu sidan hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ba diyà ta Enon ha ubay ta Salim ha amin duun madalem ha wahig namautismu daan si Juan hu mga etaw ha agpangakauma. ");
INSERT INTO bkd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Duun taena ha panahun si Juan hurà pa kapurisu. ");
INSERT INTO bkd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aman amin mga sumusunud hi Juan ha nakigsawalà hu sabuwa ha Judio mahitenged hu tulumanen hu paglimpyu. ");
INSERT INTO bkd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Duminiyà sidan ki Juan daw ikagiyi hu “Manunudlù, natiman-an nu ba haena sa tagsubayen nu ha duma nu su diyà ka pa ta layun ta Jordan? Iman tagpamautismu en daan daw madakel sa mga etaw ha agdiyà ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ba tuminubag si Juan ha “Hurà gayed mahimu hu etaw ku harì gaheman hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Natun-an nuy en sa inikagi ku ha kenà a iyan su Mesiyas ba sinugù a hu Dios ha umuna dì kandin. ");
INSERT INTO bkd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sa agpangasawa iyan gayed pakaangken hu ag-asawahen din. Sa amigu din tag-angat kandin daw agkabayà-bayà ku mapaliman din sa lageng taena ha agpangasawa ha amigu din. Iling daan taena sa kalipay ku iman. ");
INSERT INTO bkd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kinahanglan ha iyan iman haena mabantug ba siak ipaus-us a.” ");
INSERT INTO bkd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sa diyà napuun ta langit iyan labaw hu alan, ta sa etaw ha dini dà ta kalibutan kalibutanen dà sa tagsubayen din. Ba saena ha diyà napuun ta langit iyan labaw hu alan. ");
INSERT INTO bkd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tigtultul din sa naahà daw sa napaliman din diyà ta langit ba atiyuay dà sa agdawat hu mga lalang din. ");
INSERT INTO bkd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ba bisan sin-u sa agdawat taena makatuen gayed ha kamatuuran sa lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta saena ha sinugù hu Dios tag-ikagi hu lalang hu Dios ta agpaulinan gayed hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pinalanggà hu Dios ha Amay sa Batà din daw iyan sinaligan ha magharì hu alan. ");
INSERT INTO bkd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bisan sin-u sa tumuu hu Batà hu Dios amin din kinabuhì ha hurà din katapusan, ba saena ha harì tumuu kandin hurà din kinabuhì ta agsilutan hu Dios hu hinangturan. ");
INSERT INTO bkd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Napaliman hu mga Fariseo ha madakel sa sumusunud hi Jesus daw sa nabautismuwan din dì ki Juan, ba kenà iyan si Jesus migpamautismu ta iyan dà sa mga tinun-an din. Su matun-an hi Jesus ha napaliman haena hu mga Fariseo sagunà uminawà ta Judea daw likù diyà ta probincia ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ba diyà si Jesus pakaagi ta probincia ta Samaria. ");
INSERT INTO bkd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aman nakauma hu banuwa ha sakup ta Samaria ha tagngaranan ta Sicar ha ubay duun hu bugtà ha imbilin hi Jacob duun hu batà din ha si Jose. ");
INSERT INTO bkd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Duun taena sa atabay ha binangbang hi Jacob, aman mighimlay si Jesus ta agkapedaan en daw agkaugtu en daan. ");
INSERT INTO bkd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Sa mga tinun-an din duminiyà ta banuwa ta agpamalit hu agkan-en dan. Amin bahi ha taga-Samaria ha duminiyà ta agsag-eb aman inikagiyan hi Jesus hu “Ipainum a.” ");
INSERT INTO bkd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tuminubag su bahi ha “Judio ka man na taga-Samaria a daan. Imbà ka agpanayù hu wahig dini ta kanak?” Naikagi din haena ta sa mga Judio hurà dan maayad ha pakigdapità hu mga taga-Samaria. ");
INSERT INTO bkd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ba tuminubag si Jesus ha “Ku natun-an nu pa ngaay sa pakaila hu Dios daw ku sin-u a sa tagpanayù diyan ta ikaw hu wahig, iyan ka pa ngaay manayù dini ta kanak daw ilahan ku pa ikaw hu wahig ha makaila hu kinabuhì.” ");
INSERT INTO bkd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Minikagi haena sa bahi ha “Hurà nu igsaluk daw madalem haini sa atabay. Hindu ka man makatimù hu wahig ha pakaila hu kinabuhì? ");
INSERT INTO bkd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Labaw ka pa ba diay dì ki Jacob sa gin-apuan taw ha migbangbang taini ha atabay daw iyan haini inumà din daw inumà daan hu mga batà din daw hu mga mananap din?” ");
INSERT INTO bkd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ba si Jesus tuminubag hu “Bisan sin-u sa ag-inum taini ha wahig agkalauwan dà, ");
INSERT INTO bkd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ba saena ha uminum hu wahig ha ig-ila ku harì en gayed malauwan. Ta sa wahig ha ig-ila ku iyan mahimu ha tuburan ha makaila kandin hu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Minikagi haena sa bahi hu “Ipainum a hu wahig ha tagsubayen nu ta daw harì ad en malauwan daw harì ad en makagsag-ebà dini.” ");
INSERT INTO bkd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aman inikagiyan haena hi Jesus hu “Elegi sa asawa nu daw likù kaw dini.” ");
INSERT INTO bkd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ba tuminubag su bahi ha “Hurà ku man asawa.” Minikagi si Jesus hu “Laus hayana sa inikagi nu ha hurà nu asawa ");
INSERT INTO bkd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta lalima en sa nakaasawa ikaw daw sa maama ha amulà nu iman kenà nu man asawa.” ");
INSERT INTO bkd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nakaikagi su bahi ha “Iyan kad en gayed su propita. ");
INSERT INTO bkd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sa mga gin-apuan day duun sidan tagsimba taini ha bubungan, ba sinyu sa mga Judio tigtudlù nuy ha kinahanglan ha diyà kaw dà gayed magsimba ta Jerusalem.” ");
INSERT INTO bkd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ba tuminubag si Jesus ha “Tuuwi a ha makauma sa panahun ha kenà kuy duun dà taini ha bubungan daw diyà dà ta Jerusalem magsimba hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hurà nuy katun-i ku sin-u sa tagsimbahen nuy, ba sikay sa mga Judio natun-an day ta dini ta kanay agkapuun sa makaluwas hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iyan en iman haini panahun ha sa mga etaw magsimba hu Dios pinaagi hu Balaan ha Ispiritu sumalà hu kamatuuran, ta iyan haini laus ha pagsimba ha agkabayaan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Sa Dios na Ispiritu aman sa agsimba kandin kinahanglan ha sumimba gayed pinaagi hu Balaan ha Ispiritu sumalà hu kamatuuran.” ");
INSERT INTO bkd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tuminubag su bahi hu “Natun-an ku ha makauma ku malugay sa Mesiyas ha tagngaranan daan ki Cristo. Ku makauma en haena isaysay din kanuy sa alan.” ");
INSERT INTO bkd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Dayun minikagi si Jesus hu “Siak sa pakiglalang ikaw iyan ad en.” ");
INSERT INTO bkd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Duun daan taena nakauma sa mga tinun-an hi Jesus daw nangabeleng gayed sidan ku imbà pakiglalang si Jesus taena ha bahi. Ba hurà kandan nanginginsà taena ha bahi ku inu sa agkabayaan din daw hurà dan en daan insai si Jesus ku imbà pakiglalang kandin. ");
INSERT INTO bkd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Inawaan ku bahi su bangà din daw likù diyà ta banuwa daw ikagiyi sa mga etaw diyà hu ");
INSERT INTO bkd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Naahà kud labi su etaw ha natun-an din sa alan ha mga binuhat ku, aman diyà kuy en ta daw maahà nuy. Iyan en gid haena su Mesiyas?” ");
INSERT INTO bkd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aman sagunà sidan namandiyà ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Duun ku atabay inikagiyan si Jesus hu mga tinun-an din hu “Manunudlù, kaen kad en.” ");
INSERT INTO bkd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ba tuminubag si Jesus hu “Amin ku kalan-enen ha hurà nuy katun-i.” ");
INSERT INTO bkd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aman migpainsaay sa mga tinun-an din hu “Amin gid mig-ila kandin hu kalan-enen.” ");
INSERT INTO bkd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ba inikagiyan sidan hi Jesus hu “Sa pagkaen ku iyan sa pagtuman hu agkabayaan taena ha migsugù kanak daw sa pagpenga hu alan ha igpabuhat din kanak. ");
INSERT INTO bkd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Natun-an nuy en sa lalang ha tagyanaen ‘Haepat pa ha bulan iman daw human sa tilegtay.’ Ba ikagiyen ku inyu ha tilegtay en iman ta ahaa nuy hayà sa mga etaw ha tagdini ta kanuy. Iling sidan hu impamegas ha tumanan en aglegtayen. ");
INSERT INTO bkd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Saena ha aglegtay agsuhulan hu Dios daw saena ha mga etaw ha malegtay dan ilahan hu kinabuhì ha hurà din katapusan, aman malipayen gayed haena sa tagpamegas daw sa agpamanlegtay. ");
INSERT INTO bkd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Laus gayed sa lalang ha tagyanaen ‘Agpamegas sa sabuwa na sa sabuwa iyan aglegtay.’ ");
INSERT INTO bkd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Sinugù ku inyu ha lumegtay kaw duun hu bugtà ha kenà kaw iyan namegas duun. Lain en sa namegas ba iyan kaw gayed matigayun.” ");
INSERT INTO bkd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Madakel ha mga taga-Samaria duun taena ha banuwa sa nakatuu ki Jesus pinaagi hu inikagi ku bahi ha “Natun-an hi Jesus sa alan ha mga binuhat ku.” ");
INSERT INTO bkd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hinangyù dan si Jesus ha humapit diyà ta kandan aman migtimà si Jesus diyà hu daruwa ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Amin pa madakel ha nakatuu kandin tumenged hu intudlù din kandan. ");
INSERT INTO bkd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Inikagiyan dan haena sa bahi hu “Sa igpakatuu day kenà iyan dà sa intultul nu kanay ba napaliman day gayed sa lalang din daw natun-an day ha iyan en gayed Manluluwas hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Su maiwas en sa daruwa ha aldaw duminayun si Jesus diyà ta probincia ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Naikagi en hi Jesus ha sa propita harì matahuran hu mga etaw duun hu kandin dà ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Su makauma si Jesus diyà ta Galilea nalipay gayed sa mga etaw hu pagdawat kandin ta nakatampu sidan hu pagsaulug diyà ta Jerusalem daw naahà dan sa alan ha binuhat din diyà. ");
INSERT INTO bkd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Luminikù dà si Jesus diyà ta Cana ha sakup ta Galilea ha duun migbuhat hu binu. Diyà ta Capernaum amin opisyal ha sa batà din ha maama agkatungkayan hu dalu. ");
INSERT INTO bkd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Su mapaliman ku opisyal ha nakauma si Jesus diyà ta Galilea sa napuun ta Judea inelegan din si Jesus daw hangyua ha dumiyà ta Capernaum ta daw mabulung din su batà ha apit en agpatay. ");
INSERT INTO bkd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ba inikagiyan haena hi Jesus hu “Imbà kaw daw dà agtuu kanak ku makaahà kaw dà hu mga belenganen?” ");
INSERT INTO bkd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Su opisyal minagayuk gayed ha “Dumuma ka kanak ta daw harì matay su batà ku.” ");
INSERT INTO bkd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ba bà dà inikagiyi hi Jesus ha “Umulì kad ta naulian en su batà nu.” Tuminuu haena hu inikagi hi Jesus aman sagunà minipanaw. ");
INSERT INTO bkd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Su diyà pa ta dalan tinalagbù en hu mga suluguen din ha migtultul kandin ha naulian en su batà din. ");
INSERT INTO bkd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Su iinsà din ku kan-u naulii su batà tuminubag sidan hu “Daw gabì ha agkapulid sa aldaw.” ");
INSERT INTO bkd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Dayun nahenà-henà ku amay ha iyan haena uras ha minikagi si Jesus diyà ta kandin hu “Naulian en su batà nu.” Aman nakatuu haena sa opisyal daw sa pamilya din. ");
INSERT INTO bkd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ikaduwa haena ha belenganen ha nabuhat hi Jesus sugud hu paglikù din diyà ta Galilea ha napuun ta Judea. ");
INSERT INTO bkd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Su maiwas en haena duminiyà si Jesus ta Jerusalem ta amin agsaulugen hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Diyà ta Jerusalem amin linaw ha ubay duun hu pultahan ha tagngaranan hu Pultahan hu mga Karniro. Sa ngaran taena ha linaw duun hu Hebreo ha inikagiyan iyan sa Betsata. Duun hu kilid taena ha linaw amin duun lalima ha sihungà. ");
INSERT INTO bkd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Madakel ha mga daluwanen sa duun dà taena taghidegà, sa mga buta, sa mga minatay en sa dibaluy ha lawa dan daw sa mga pigket. Tag-angatà sidan ku makabug haena sa wahig ");
INSERT INTO bkd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ta napaliman dan ha amin panahun ha agbulus sa balinsuguen hu Dios duun ku linaw ta agkabugen din. Sa agkauna pakaagbul diyà ta wahig maulian hu sumalà ha dalu din. ");
INSERT INTO bkd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Amin etaw diyà ha katluan en daw walu ha tuig sa kadaluwi din. ");
INSERT INTO bkd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Su maahà hi Jesus ha taghidegaay haena diyà daw su matun-an din ha nalugay en sa kadaluwi taena, ininsaan din hu “Agkabayà ka ba ku maulian ka?” ");
INSERT INTO bkd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tuminubag su etaw ha “Hurà ku man duma ha makauwit kanak duun tayan ha wahig ku agkakabug en. Ku agduun ad en ngaay agkaunahan a.” ");
INSERT INTO bkd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Dayun inikagiyan hi Jesus hu “Bangun kad, luluna sa banig nu daw hipanaw kad en.” ");
INSERT INTO bkd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Sagunà naulian su etaw daw uwita sa banig din dayun hipanaw. Ba aldaw haena hu Sabado ");
INSERT INTO bkd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","aman inikagiyan hu mga punuan hu Judio su etaw ha naulian hu “Aldaw haini hu Paghimlay aman harì igtugut duun hu Kasuguan sa pag-uwit hu banig.” ");
INSERT INTO bkd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ba tuminubag haena ha “Su etaw ha nakaulì kanak iyan migsugù ha lulunen ku haini sa banig ku daw hipanaw.” ");
INSERT INTO bkd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aman ininsaan dan haena hu “Sin-u ha etaw sa migsugù ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ba hurà din kakilala ku sin-u haena ta luminubuk si Jesus duun hu madakel ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Su malugay-lugay en naahà hi Jesus haena sa naulian duun hu Timplo, dayun inikagiyan din hu “Naulian kad en iman aman endai nud sa mga buhat ha madaet ta daw harì kad en madaluwan hu ayuwà pa malegen.” ");
INSERT INTO bkd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Saena ha etaw luminikù duun hu mga punuan hu mga Judio daw ikagiyi sidan hu “Iyan diay si Jesus migbulung kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pigpasipalahan si Jesus hu mga punuan hu mga Judio ta agpamulung duun hu Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ba inikagiyan sidan hi Jesus hu “Sa Dios ha Amay ku harì gayed taghimlay hu mga buluhaten din daw kinahanglan ha maniguru a daan magtalabahu.” ");
INSERT INTO bkd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tumenged taena su mga punuan naniguru gayed ha mapatay dan si Jesus, ta kenà iyan dà sa pagsupak din hu Kasuguan mahitenged hu Aldaw hu Paghimlay ba tag-ikagiyen din daan ha Amay din sa Dios daw inisip din sa kaugalingen din ha Dios en daan. ");
INSERT INTO bkd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha siak sa Batà hu Dios hurà ku gayed mahimu hu kanak dà ha gahem. Iyan dà agkabuhat ku sa naahà ku ha binuhat hu Amay ku, aman sa tagbuhaten din iyan daan agbuhaten ku. ");
INSERT INTO bkd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Adagi tungkay sa pagpalanggà kanak hu Amay ku daw igpaahà din kanak sa alan ha tagbuhaten din. Ba labaw pa dì taini sa igpabuhat din asem kanak ha mabelengan nuy gayed. ");
INSERT INTO bkd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Agkabanhaw hu Amay ku sa mga minatay en. Iling daan kanak makaila a hu kinabuhì duun hu bisan sin-u ha agkabayaan ku ag-ilahi. ");
INSERT INTO bkd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sa Amay ku kenà iyan Maghuhukum hu kaet-etawan ta in-ila din kanak sa katenged hu paghukum ");
INSERT INTO bkd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ta daw matahuran a kandan iling hu katahura dan kandin. Bisan sin-u sa harì magtahud kanak harì daan tagtahud hu Amay ku ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Laus gayed sa ag-ikagiyen ku ha bisan sin-u sa magpaliliman kanak daw tumuu hu Dios ha migsugù kanak amin din kinabuhì ha hurà din katapusan. Harì en haena masilutan ta nakalikay en duun hu kamatayen daw amin din en kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Laus gayed sa ag-ikagiyen ku inyu ha makauma sa panahun ha mapaliman hu mga minatay en sa lageng ku siak sa Batà hu Dios, daw sa agpaliliman mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sa Dios ha Amay ku iyan tag-ila hu kinabuhì. Iling kanak mahimu din daan ha makaila a hu kinabuhì ha hurà din katapusan, ");
INSERT INTO bkd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","daw tumenged ta Suled a hu Kaet-etawan in-ila kanak hu Amay ku sa katenged ha mahukuman ku sa kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Harì kaw mabeleng taini ta makauma sa aldaw ha mapaliman hu alan ha mga minatay en sa lageng ku ");
INSERT INTO bkd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","dayun mangabanhaw sidan. Saena ha migbuhat hu maayad mailahan hu kinabuhì ha hurà din katapusan, ba saena ha migbuhat hu madaet mabanhaw daan ba agkasilutan. ");
INSERT INTO bkd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Hurà ku mahimu hu kanak dà ha gahem. Sa paghukum ku pinaagi gayed hu ag-ikagiyen kanak hu Dios ha Amay ku, aman matareng haini ta kenà ku iyan agsunuren sa kanak ha agkabayaan ba iyan sa agkabayaan hu Amay ku ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ku iyan a dà manistigus hu kanak ha kaugalingen saini kenà malig-en. ");
INSERT INTO bkd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ba amin lain ha agpanistigus mahitenged kanak daw natun-an ku ha sa tag-ikagiyen din kasaligan gayed. ");
INSERT INTO bkd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Nanginginsà kaw en daan ki Juan ha Bautista mahitenged kanak daw inikagiyan kaw en kandin hu kamatuuran. ");
INSERT INTO bkd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kenà en ngaay kinahanglan ha amin pa etaw ha manistigus mahitenged kanak, ba ipahenà-henà ku inyu sa inikagi hi Juan ta daw maluwas kaw. ");
INSERT INTO bkd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan iyan sulù ha tungkay masiga daw nabayà-bayà kaw ta nailawan kaw kandin hu mababà ha panahun. ");
INSERT INTO bkd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ba amin makapanistigus kanak ha labaw pa dì ki Juan ta sa tagbuhaten ku ha impabuhat kanak hu Dios ha Amay ku iyan en tistigus ha sinugù a gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Daw sa Dios ha Amay ku iyan tistigus mahitenged kanak. Hurà nuy pa kapaliman sa Dios daw hurà nuy pa daan kaahà ");
INSERT INTO bkd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","daw hurà nuy pa kadawat sa lalang din ta hurà kaw tuu kanak siak sa sinugù din. ");
INSERT INTO bkd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tagtuen kaw gayed hu lalang hu Dios ta kagi nuy ha iyan haena makaila inyu hu kinabuhì ha hurà din katapusan. Ba saena ha lalang din iyan daan makapanistigus mahitenged kanak, ");
INSERT INTO bkd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ba hurà a inyu tuuwi ta daw amin nuy ngaay kinabuhì. ");
INSERT INTO bkd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kenà ku iyan tagpan-ahaen ha madayè a hu mga etaw ");
INSERT INTO bkd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ta natun-an kud ku inu kaw. Natun-an ku ha hurà nuy pagpalanggà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sinugù a dini hu Dios ha Amay ku ba hurà a inyu dawata. Ba ku amin makadini hu kandin dà ha pagbayà iyan gayed dawaten nuy. ");
INSERT INTO bkd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","In-inuwen nuy pagtuu kanak ku iyan dà tagpan-ahaen nuy sa pagdayè inyu hu mga etaw ba harì nuy agkabayaan ha madayè kaw hu laus ha Dios? ");
INSERT INTO bkd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Harì nuy henhenaen ha iyan a magsumbung inyu ta si Moises ha iyan tagsaligan nuy iyan dà magsumbung inyu duun hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ku laus ngaay sa pagtuu nuy ki Moises tuuwan a daan inyu ta sa insulat hi Moises mahitenged man kanak. ");
INSERT INTO bkd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ba tumenged ta hurà kaw tuu hu insulat hi Moises in-inuwen nuy man pagpakatuu hu tag-ikagiyen ku?” ");
INSERT INTO bkd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Su maiwas haena luminayun si Jesus duun hu Danaw ta Galilea ha tagngaranan daan ta Tiberiades. ");
INSERT INTO bkd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tungkay madakel sa mga etaw ha namanlupug kandin ta naahà dan sa mga belenganen ha binuhat din tumenged ta naulian din sa nangadaluwan. ");
INSERT INTO bkd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Dayun duminuun si Jesus hu buntud daw pinuu duma hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Madani en taena agsaulugen hu mga Judio sa Aldaw hu Paglabay. ");
INSERT INTO bkd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Su maghelaw-helaw si Jesus naahà din sa kaet-etawan ha tagdiyà ta kandan aman ininsaan din si Felipe hu “Hindu kuy gid makatimù hu igpakaen taw tayana ha mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Natun-an en hi Jesus ku inu sa buhaten din ba ininsaan din si Felipe ta agsulayen din haena. ");
INSERT INTO bkd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ba tuminubag si Felipe hu “Bisan pa pila ha gatus sa ipalit taw hu supas daw ilahan taw sidan hu tig-atiyù ba harì pa gayed sidan tukidan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Minikagi daan sa sabuwa ha tinun-an hi Jesus ha si Andres sa suled hi Simon Pedro hu ");
INSERT INTO bkd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Amin malmalaki dini ha amin din supas ha lalima ha buuk daw daruwa daan ha buuk ha sedà, ba saini harì gayed tumukid ta madakel tungkay sa mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Inikagiyan hi Jesus sa mga tinun-an din hu “Ipapinuu nuy sa mga etaw.” Saena sagbeten ha bugtà aman alan sidan mininuu, lalima ha libu sa kadakelen hu mga maama. ");
INSERT INTO bkd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Dayun tinimù hi Jesus sa supas daw ampui haena. Su makapenga en mag-ampù impakaen din sa mga etaw sumalà hu agkaamin dan. Iling daan ku sedà. ");
INSERT INTO bkd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Su mangabuhì en sidan inikagiyan hi Jesus sa mga tinun-an din hu “Amul-amula nuy sa nasamà ta daw harì makalkalan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aman pinangamul dan su nasamà taena ha lalima ha buuk ha supas, saena sampulù pa daw daruwa ha ambung. ");
INSERT INTO bkd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Su maahà hu mga etaw haena sa belenganen ha binuhat hi Jesus minikagi sidan hu “Iyan en gayed hayan su tagsalapen taw ha Propita ha igpadini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Natun-an hi Jesus ha agpegesen dan ngaay ha magharì en kandan, aman bà dà uminawà daw duun hu buntud ha sabubuwa dà. ");
INSERT INTO bkd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Su madani en agkadaleman duminiyà sa mga tinun-an hi Jesus ta danaw. ");
INSERT INTO bkd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Su masukilem en hurà pa gayed makalikù si Jesus diyà ta kandan, aman namanlulan sidan duun hu barutu ta aglayun sidan diyà ta Capernaum. ");
INSERT INTO bkd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Duun taena maseleg gayed sa kalamag daw adagi daan sa mga baled. ");
INSERT INTO bkd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Su diyà en sidan ta taliwarà taena ha danaw naahà dan si Jesus sa tagdiyà ta kandan ha bayà-bayà en taghipanaw duun taena ha wahig, aman tungkay sidan nangahaldek. ");
INSERT INTO bkd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ba inikagiyan sidan hi Jesus hu “Harì kaw agkahaldek ta iyan a.” ");
INSERT INTO bkd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Dayun malipayen sidan ha impalulan dan si Jesus duun ku barutu daw sagunà sidan nakauma duun hu agpayanan-an dan. ");
INSERT INTO bkd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Su maisab en ha aldaw sa mga kaet-etawan diyà pa ta layun. Natun-an dan ha sabuwa dà sa barutu diyà ha piglulanan hu mga tinun-an hi Jesus daw hurà duun si Jesus ta su lumayun sa mga tinun-an iyan dà man sidan. ");
INSERT INTO bkd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ubay hu lugar ha duun nakakaen sa mga etaw hu supas ha pig-ampuan hi Jesus nakauma duun sa mga barutu ha napuun diyà ta Tiberias. ");
INSERT INTO bkd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Su matun-an hu mga etaw ha hurà en diyà si Jesus daw sa mga tinun-an din namanlulan sidan taena ha barutu ta agpan-ahaen dan si Jesus diyà ta Capernaum. ");
INSERT INTO bkd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Su maahà en hu mga etaw si Jesus diyà ta layun ininsaan dan hu “Manunudlù, kan-u ka pa nakauma dini?” ");
INSERT INTO bkd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tuminubag si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha sa tigpan-ahaa nuy kanak iyan dà ta nabuhì kaw hu supas ha nakaen nuy gabì, ba hurà nuy kasabut sa mga belenganen ha nabuhat ku. ");
INSERT INTO bkd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Harì nuy agsiguruwi sa kalan-enen ha sagunà dà agkadaet ba maniguru kaw ta daw matimù nuy sa kalan-enen ha makaila hu kinabuhì ha hurà din katapusan. Siak sa Suled hu Kaet-etawan iyan a inilahan hu Dios ha Amay ku hu gahem ha makaila taena inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dayun ininsaan hu mga etaw hu “Inu man sa kinahanglan ha buhaten day ta daw matuman day sa agkabayaan hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tuminubag si Jesus hu “Sa agkabayaan hu Dios iyan sa tumuu kaw kanak sa sinugù din.” ");
INSERT INTO bkd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aman nanginginsà sa mga etaw hu “Inu sa belenganen ha makapaahà nu kanay ta daw kay makatuu ikaw? ");
INSERT INTO bkd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Sa mga gin-apuan taw su duun pa sidan ku pinakabulung-bulung ha lugar mana dà sa tagkan-en dan, ta amin insulat ha lalang hu Dios ha tagyanaen ‘Diyà napuun ta langit sa kalan-enen ha in-ila kandan hu Dios.’” ");
INSERT INTO bkd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Minikagi si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha kenà iyan si Moises mig-ila ku kalan-enen ha diyà napuun ta langit, ba sa Dios ha Amay ku iyan makaila inyu hu laus ha kalan-enen. ");
INSERT INTO bkd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta sa kalan-enen ha ig-ila hu Dios iyan sa agkapuun diyà ta langit ha iyan pakaila duun hu kaet-etawan hu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Minikagi sidan ki Jesus hu “Sigi kay dà ilahan taena ha pagkaen.” ");
INSERT INTO bkd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ba tuminubag si Jesus hu “Iyan ad kalan-enen ha pakaila hu kinabuhì ha hurà din katapusan. Saena ha dumini ta kanak harì en gayed mauhul daw saena ha tumuu kanak harì en gayed malauwan. ");
INSERT INTO bkd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ba inikagi kud inyu ha bisan ku naahà nuy en sa mga belenganen ha binuhat ku ba harì kaw gayed agtuu. ");
INSERT INTO bkd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sa alan ha mga etaw ha in-ila kanak hu Dios ha Amay ku agdini ta kanak, daw saena ha agdini ta kanak harì ku gayed agbugawen. ");
INSERT INTO bkd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta sa pagdini ku ta kalibutan kenà iyan sa pagbuhat hu kanak ha agkabayaan, ba iyan sa pagtuman taena ha pagbayà hu Dios ha Amay ku ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Daw sa agkabayaan hu Amay ku iyan sa hurà gayed bisan sabuwa ha malaag duun hu mga etaw ha in-ila din kanak ta agbanhawen ku dà sidan duun hu hudiyan ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sa agkabayaan hu Amay ku iyan sa alan ha nakakilala daw nakatuu kanak sa Batà din mailahan hu kinabuhì ha hurà din katapusan, aman agbanhawen ku sidan duun hu hudiyan ha aldaw.” ");
INSERT INTO bkd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Dayun migtamudmud sa mga etaw ku inikagi hi Jesus ha iyan kalan-enen ha napuun diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Minikagi sidan hu “Kenà ba iyan haini si Jesus ha batà hi Jose? Daw agkakilala day dà daan sa amay din daw sa inay din. Imbà tag-ikagiyà ha diyà napuun ta langit?” ");
INSERT INTO bkd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Natun-an haena hi Jesus aman inikagiyan din sidan hu “Imbà kaw tagtamudmud? ");
INSERT INTO bkd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hurà bisan sin-u ha makadini ta kanak ku harì uwiten hu Amay ku. Sa dumini ta kanak agbanhawen ku duun hu hudiyan ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Amin insulat hu mga propita ha tagyanaen ‘Tudluan hu Dios sa alan ha kaet-etawan.’ Aman bisan sin-u sa magpaliliman hu Amay ku ha tinudluan din dumini gayed ta kanak. ");
INSERT INTO bkd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hurà nakaahà hu Dios ha Amay ku ba iyan a dà ta diyà a napuun ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Laus gayed sa tag-ikagiyen ku ha sa etaw ha tumuu kanak amin din kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iyan a kalan-enen ha makaila hu kinabuhì. ");
INSERT INTO bkd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Duun hu pinakabulung-bulung ha lugar sa kalan-enen ha tagngaranan hu mana iyan pagkaen hu mga gin-apuan nuy, ba nangamatay dà sidan. ");
INSERT INTO bkd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ba sa kalan-enen ha diyà napuun ta langit bisan sin-u sa kumaen taena amin din gayed kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iyan a kalan-enen ha diyà napuun ta langit ha makaila hu kinabuhì. Sa kumaen taena amin din gayed kinabuhì ha hurà din katapusan. Sa kalan-enen ha ig-ila ku iyan en sa lawa ku ta daw sa kaet-etawan mahimu ha amin dan kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dayun migsawalà sa mga etaw ha tagyanaen “In-inuwen taini ha etaw sa pag-ila kanuy hu lawa din ta daw makaen taw?” ");
INSERT INTO bkd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ba inikagiyan sidan hi Jesus hu “Laus gayed sa tag-ikagiyen ku inyu ha siak sa Suled hu Kaet-etawan ku harì kaw kumaen hu lawa ku daw harì kaw uminum hu langesa ku hurà nuy kinabuhì. ");
INSERT INTO bkd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ba bisan sin-u sa kumaen hu lawa ku daw uminum hu langesa ku amin din kinabuhì ha hurà din katapusan ta agbanhawen ku duun hu hudiyan ha aldaw, ");
INSERT INTO bkd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ta sa lawa ku daw sa langesa ku iyan gayed kalan-enen ha pakaila hu kinabuhì. ");
INSERT INTO bkd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Bisan sin-u sa kumaen hu lawa ku daw uminum hu langesa ku harì en makasuway kanak daw siak harì ad en sumuway kandin. ");
INSERT INTO bkd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Sa Amay ku ha migsugù kanak iyan tag-ila hu kinabuhì aman tumenged taena amin ku kinabuhì. Iling daan ha sa kumaen kanak mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Sa kalan-enen ha diyà napuun ta langit kenà iling hu mana ha nakaen hu mga gin-apuan taw ta minatay dà sidan. Ba bisan sin-u sa kumaen hu laus ha kalan-enen amin din gayed kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyan haena intudlù hi Jesus duun hu simbahan hu mga Judio diyà ta Capernaum. ");
INSERT INTO bkd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Su mapaliman haena hu mga sumusunud hi Jesus madakel kandan sa tag-ikagi hu “Malegen taw gayed madawat sa intudlù din. Sin-u gid sa tumuu duun?” ");
INSERT INTO bkd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ba natun-an hi Jesus ha sa mga duma ha sumusunud din tagtamudmud mahitenged hu tigtudlù din, aman inikagiyan din sidan hu “Agtambagan nuy ba diay sa inikagi ku? ");
INSERT INTO bkd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Inu man sa henà-henà nuy ku siak sa Suled hu Kaet-etawan maahà nuy ha batunen ad payanaen diyà ta langit ha iyan napun-an ku? ");
INSERT INTO bkd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Iyan dà sa Balaan ha Ispiritu tag-ila hu kinabuhì ha hurà din katapusan ta harì gayed haena mahimu hu etaw dà. Sa mga lalang ha inikagi ku inyu duun alan napuun hu Balaan ha Ispiritu aman iyan pakaila hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ba amin pa duma inyu ha harì agtuu kanak.” Saena inikagi hi Jesus ta daan din en natun-an ku sin-u sa harì agtuu kandin daw ku sin-u daan sa maglimbung kandin. ");
INSERT INTO bkd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Duminayun si Jesus hu pag-ikagi “Iyan haena hinengdan ha inikagiyan ku inyu ha hurà bisan sin-u ha makadini ta kanak ku harì uwiten hu Dios ha Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Sugud taena madakel sa mga sumusunud din ha suminuway dà daw hurà en isab duma kandin. ");
INSERT INTO bkd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ininsaan hi Jesus su sampulù daw daruwa ha tinun-an din hu “Agkabayà kaw en ba daan agsuway kanak?” ");
INSERT INTO bkd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ba tuminubag si Simon Pedro hu “Ginuu, hurà en lain ha maelegan day ta iyan ka dà tagtudlù hu paagi duun hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iman agtuu kay ikaw ta natun-an day ha iyan ka su sinugù hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Dayun tuminubag si Jesus hu “Pinilì ku inyu sa sampulù daw daruwa ba sa sabuwa inyu sakup en hi Satanas.” ");
INSERT INTO bkd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iyan tagsubayen din si Judas ha batà hi Simon Iscariote ta bisan ku sabuwa daan ha tinun-an ba iyan gayed maglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Su maiwas haena duminayun si Jesus duun hu mga banuwa ha sakup ta Galilea. Tinuyù din gayed ha makadiyù diyà ta probincia ta Judea ta natun-an din ha aghimatayan diyà hu mga punuan hu Judio. ");
INSERT INTO bkd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ba su dani en agsaulugen sa Panahun hu Mga Lawig ");
INSERT INTO bkd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","minikagi sa mga suled hi Jesus diyà ta kandin ha “Dumuun ka taena ha agsaulugen diyà ta Judea ta daw maahà hu mga sumusunud nu sa mga belenganen ha tagbuhaten nu. ");
INSERT INTO bkd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta sa etaw ha agkabayà ku mabantug harì din gayed igheles sa mga buhat din. Tumenged ta tagbuhat ka hu mga belenganen maayad ha ipaahà nu haena duun hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Inikagi dan haena ki Jesus ta harì dan agtuuwan bisan ku tungkay dan en ha suled. ");
INSERT INTO bkd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aman tinubag sidan hi Jesus hu “Kenà pa haini iyan natugun ha panahun ha magpakilala a hu mga etaw. Bisan inu dà ha panahun agkabaluy en ha buhaten nuy sa agkabayaan nuy ");
INSERT INTO bkd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ta harì kaw man agkuntrahen hu mga etaw dini ta kalibutan. Ba siak tumenged hu tigtudlù ku agkatun-an dan ha madaet sa tagbuhaten dan aman agkuntrahen a kandan. ");
INSERT INTO bkd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Una kaw en duun taena ha agsaulugen ta kenà pa haini panahun ha dumiyà a.” ");
INSERT INTO bkd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aman diyà dà migtimà si Jesus ta Galilea. ");
INSERT INTO bkd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ba su humipanaw en su mga suled din luminupug dà si Jesus kandan, ba hurà duma hu mga etaw ta daw harì dan matun-an. ");
INSERT INTO bkd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Duun taena ha agsaulugen pinan-ahà si Jesus hu mga punuan hu Judio aman in-insà dan ku hindu en duun. ");
INSERT INTO bkd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tagsubayen si Jesus hu mga etaw ha nangaamul-amul diyà. Sa duma kandan tag-ikagi hu “Maayad haena ha etaw” ba sa duma tag-ikagi daan hu “Kenà haena maayad ta bà din dà aglimbungi sa mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ba bà dà sidan tagmuya-muya ta agkangahaldek sidan hu mga punuan hu Judio. ");
INSERT INTO bkd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Su agliwaraan en sa pagsaulug duminuun si Jesus taena ha Timplo dayun nanudlù. ");
INSERT INTO bkd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sa mga punuan hu Judio tungkay nabeleng daw mig-ikagi sidan hu “Hindu gid napuun sa natun-an taini ha etawa ha kenà man daan matangkaw sa natunghaan din?” ");
INSERT INTO bkd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aman tuminubag si Jesus hu “Sa tigtudlù ku kenà kanak dà ha henà-henà ba duun gayed napuun hu Dios ha iyan migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bisan sin-u sa agkabayà tagtuman taena ha agkabayaan hu Dios matun-an din gayed ku sa tigtudlù ku kanak dà ba daw ku duun ba napuun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sa etaw ha kandin dà ha henà-henà sa tigtudlù din agkabayà ha dayeen hu mga etaw, ba sa etaw ha agkabayà ha iyan dayeen sa migsugù kandin saena agkasaligan sa tigtudlù din ta hurà duun bidù. ");
INSERT INTO bkd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Si Moises mig-ila inyu hu Kasuguan ba hurà bisan sabuwa inyu ha tagtuman taena. Ta ku tagtuman kaw pa hu Kasuguan harì nuy ngaay mahenhenaan ha himatayan a inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tuminubag haena sa mga etaw hu “Agkalibeg ka man gid. Sin-u sa taghenà-henà hu paghimatay ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ba inikagiyan sidan hi Jesus ha “Su anay nangabeleng kaw tumenged hu sabuwa ha belenganen ha binuhat ku. ");
INSERT INTO bkd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Si Moises migsugù inyu ha sirkunsidahan gayed sa mga batà nuy ha maama, ba saena ha tulumanen kenà diyà napuun ki Moises ta daan dà haena duun hu mga gin-apuan nuy. Tagbuhaten nuy haena bisan duun hu Aldaw hu Paghimlay. ");
INSERT INTO bkd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ku nabaluy nuy haena buhata duun hu Aldaw hu Paghimlay ta daw harì masupak sa Kasuguan hi Moises, imbà a inyu agkapauki ta pigbulung ku haena sa etaw duun hu Aldaw hu Paghimlay? ");
INSERT INTO bkd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Harì kaw mag-ikagiyà ha madaet sa buhat hu etaw ku harì nuy pa masusi. Henhenaen nuy enà daw iyan nuy maikagi sa laus mahitenged kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Su mapaliman hu mga taga-Jerusalem haena sa inikagi hi Jesus sa duma kandan minikagi hu “Kenà ba iyan haini su etaw ha tagpan-ahaen hu mga punuan ta aghimatayan dan? ");
INSERT INTO bkd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ahaa nuy ta kamulu en tagpanudlù duun hu mga etaw daw harì man agbaldengen hu mga punuan. Iyan ta ku natun-an dan en ha iyan haini su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ba sa laus ha Mesiyas harì taw agkatun-an ku hindu agkapuun, ba saini natun-an taw dà sa kapuun din.” ");
INSERT INTO bkd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aman su tagpanudlù pa si Jesus duun hu Timplo minikagi hu “Nakilala ad gayed inyu daw natun-an nuy en ku hindu a napuun. Hurà a dini hu kanak dà ha pagbayà ta sa migsugù kanak iyan sa laus ha Dios daw harì nuy haena agkakilala. ");
INSERT INTO bkd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ba siak nakilala ku ta diyà a napuun ta kandin daw iyan daan migsugù kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Agdakepen dan en ngaay si Jesus ba harì dan agkahimu ta kenà pa haena iyan natugun ha panahun. ");
INSERT INTO bkd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Madakel ha mga etaw sa tuminuu kandin daw kagi dan “Iyan en gayed haini su Mesiyas ta hurà en makahimu hu labaw pa ha mga belenganen dì kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Amin mga Fariseo ha nakapaliman hu muya-muya mahitenged ki Jesus aman sa mga Fariseo daw sa mga labaw ha sinaligan hu paghalad migsugù hu mga bantay taena ha Timplo ha dakepen dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ba minikagi si Jesus hu “Harì en tungkay malugay ag-awaan kud inyu ta ag-ulì ad en duun hu migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pan-ahaen a inyu ba harì ad en inyu matulen ta harì kaw makaduun hu agpayanan-an ku.” ");
INSERT INTO bkd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Migpainsaay sa mga punuan hu Judio ha “Hindu gid diay duun agpayanaen imbà taw harì agkatulen? Iyan ta ku agduun hu mga Griego ha mga etaw ha diyà daan tagtimà sa mga duma taw ha Judio ta agtudluan din daan sidan. ");
INSERT INTO bkd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Inu gid sa kahulugan taena ha inikagi din ha bisan ku pan-ahaen taw ba harì taw en gayed matulen daw harì kuy en makaduun hu agpayanan-an din?” ");
INSERT INTO bkd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Su katapusan ha aldaw hu pagsaulug ha iyan tungkay mahal huminitindeg si Jesus daw ikagi hu “Bisan sin-u sa agkalauwan dumini ta kanak ta igpainum ku. ");
INSERT INTO bkd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sa insulat ha lalang hu Dios tagyanaen ‘Sa wahig ha pakaila hu kinabuhì agtugà duun hu bisan sin-u ha agtuu kanak.’” ");
INSERT INTO bkd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ta sa wahig ha sinubay din iyan sa Balaan ha Ispiritu ha agkadawat hu bisan sin-u ha tumuu ki Jesus. Ba duun taena ha panahun hurà pa iila sa Balaan ha Ispiritu ta hurà pa ligtu si Jesus diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Su mapaliman hu mga etaw sa inikagi hi Jesus sa duma kandan minikagi hu “Laus gayed ha iyan en haena su tagsalapen taw ha Propita.” ");
INSERT INTO bkd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sa duma minikagi hu “Iyan en haena su Mesiyas.” Ba sa duma minikagi daan hu “Kenà ta harì mahimu ha diyà kapuun sa Mesiyas ta Galilea ");
INSERT INTO bkd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ta sa insulat ha lalang hu Dios tagyanaen ha sa Mesiyas kaliwat hi Harì David daw diyà gayed ibatà ta Betlehem ha iyan banuwa hi David.” ");
INSERT INTO bkd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aman hurà makag-iling sa henà-henà hu mga etaw mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sa duma kandan agkabayà en ngaay ha dakepen si Jesus ba harì dan haena agkahimu. ");
INSERT INTO bkd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Su makalikù en sa mga bantay ha agdakep ngaay ki Jesus ininsaan sidan hu mga Fariseo daw hu mga labaw ha sinaligan hu paghalad hu “Imbà nuy hurà kadakep si Jesus?” ");
INSERT INTO bkd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ba tuminubag sidan ha “Hurà gayed etaw ha makagtudlù iling kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Inikagiyan sidan hu mga Fariseo hu “Nalimbungan kaw en ba daan kandin? ");
INSERT INTO bkd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Hurà gayed sabuwa ha punuan daw Fariseo ha tuminuu kandin. ");
INSERT INTO bkd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Saini ha kaet-etawan hurà dan katun-i sa Kasuguan aman silutan gayed sidan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dayun si Nicodemo sa sabuwa ha Fariseo ha nakiglalang ki Jesus su anay nanginginsà hu ");
INSERT INTO bkd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Igtugut ba hu Kasuguan taw ha hukuman sa etaw hu silut ku harì pa makapangatarengan ta daw matun-an taw sa binuhat din?” ");
INSERT INTO bkd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ba tuminubag sa mga duma din ha Fariseo hu “Taga-Galilea ka ba diay daan? Susiya nu sa lalang hu Dios ta daw matun-an nu ha hurà propita ha diyà agkapuun ta Galilea.” ");
INSERT INTO bkd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dayun naman-ulì sidan alan duun hu mga balay dan. ");
INSERT INTO bkd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Si Jesus duminiyà ta Buntud ta Olibo. ");
INSERT INTO bkd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Su maselem en luminikù dà diyà ta Timplo. Madakel sa mga etaw ha nangaamul-amul diyà ta kandin aman mininuu daw migtudlù. ");
INSERT INTO bkd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Amin bahi ha pigdakep ta nanapaw dayun inuwit hu mga manunudlù hu Kasuguan daw hu mga Fariseo. Impaatubang dan duun hu mga etaw ");
INSERT INTO bkd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","daw inikagiyan dan si Jesus hu “Manunudlù, saini ha bahi nadakep su kamulu pa tagpanapaw. ");
INSERT INTO bkd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Duun hu Kasuguan insulat hi Moises ha sa iling taini agbatuwen taman ha matay. Inu sa ikaw ha kahukumi duun?” ");
INSERT INTO bkd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ininsaan dan si Jesus taena hu pagsulay kandin ta daw amin dan katarengan ha ikasumbung dan mahitenged kandin. Ba si Jesus bà dà duminunghuy daw isulat sa tuldù din duun hu aliyabuk. ");
INSERT INTO bkd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tumenged ta sigi dà sidan tagpanginginsaay ki Jesus saena uminahà diyà ta kandan daw ikagiyi sidan ha “Ku sin-u inyu sa hurà gayed makasalà iyan umuna magbatu kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Dayun minisab dà duminunghuy daw magsulat duun hu aliyabuk. ");
INSERT INTO bkd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Su mapaliman dan haena sa inikagi hi Jesus uminawà sa tigsabuwa kandan, sa mga magulang iyan uminuna dayun namanlupug sa duma hangtud ha iyan dà nabilin su bahi diyà ta atubangan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Uminahà si Jesus duun taena ha bahi daw ininsaan din hu “Hindu en diay su migsumbung ikaw? Hurà en ba diay nabilin kandan hu paghimatay ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tuminubag haena sa bahi ha “Hurà en.” Dayun minikagi si Jesus hu “Harì ku daan ikaw mahukuman hu silut. Aman umulì kad en daw harì kad isab magbuhat hu madaet.” ");
INSERT INTO bkd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Su magtudlù en paman si Jesus duun taena ha mga etaw minikagi haena hu “Iyan a sulù ha pakailaw hu henà-henà hu kaet-etawan. Bisan sin-u sa agsunud kanak harì gayed duun taghipanaw hu kasukileman ta amin din sulù ha tag-ila hu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sa mga Fariseo tuminubag hu “Tagpanistigus ka mahitenged hu kaugalingen nu aman kenà haini malig-en.” ");
INSERT INTO bkd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ba tuminubag si Jesus hu “Bisan ku iyan a manistigus mahitenged hu kaugalingen ku ba malig-en gayed ta natun-an ku ku hindu a napuun daw ku hindu a agpayanaen. Ba sinyu harì nuy agkatun-an ku hindu a napuun daw ku hindu a agpayanaen. ");
INSERT INTO bkd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ku taghukum kaw hu etaw saena pinaagi dà hu kalibutanen ha henà-henà, ba siak harì a taghukum hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ba ku taghukum a pa ngaay matareng gayed haini ta kenà kanak dà ha paghukum ba kandin hu Amay ku ha iyan migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nakasulat duun hu Kasuguan nuy sa tagyanaen ‘Malig-en gayed sa pagpanistigus hu daruwa ha etaw.’ ");
INSERT INTO bkd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Siak iyan ad en makapanistigus mahitenged hu kaugalingen ku, daw sa sabuwa ha makapanistigus mahitenged kanak iyan sa Amay ku ha migsugù kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dayun nanginginsà kandin sa mga Fariseo hu “Hindu diay duun sa amay nu?” Tuminubag si Jesus hu “Harì nuy agkakilala ku sin-u a daw ku sin-u sa Amay ku, ta ku agkatun-an nuy pa ngaay ku sin-u a matun-an nuy en daan ku sin-u sa Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Inikagi haena hi Jesus su tagtudlù pa duun hu kwarto ta Timplo ha duun sa talaguay hu salapì ha ighalad. Ba hurà pa kadakep si Jesus ta kenà pa haena iyan natugun ha panahun. ");
INSERT INTO bkd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Inikagiyan en paman sidan hi Jesus hu “Harì tungkay malugay ag-awaan kud inyu. Pan-ahaen a inyu daw matay kaw en duun hu mga salà nuy ba harì kaw en makaduun hu agpayanan-an ku.” ");
INSERT INTO bkd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aman migpainsaay haena sa mga punuan hu Judio ha “Iyan ta gid ku taghiket ta imbà man tag-ikagi ha harì kuy makaduun hu agpayanan-an din?” ");
INSERT INTO bkd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ba inikagiyan sidan hi Jesus hu “Dini kaw dà napuun ta kalibutan ba siak diyà a napuun ta langit. ");
INSERT INTO bkd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inikagiyan kud en inyu ha matay kaw en duun hu mga salà nuy ku harì kaw tumuu ha iyan ad su duduun en su anay.” ");
INSERT INTO bkd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Dayun ininsaan dan si Jesus hu “Sin-u ka diay?” Aman tuminubag haena hu “Iyan ad en sa sigi ku inyu tag-ikagiyaen sugud dà su anay. ");
INSERT INTO bkd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Madakel pa ngaay sa ikahukum ku inyu ba iyan dà ag-ikagiyen ku sa napaliman ku duun hu migsugù kanak ha agkasaligan gayed.” ");
INSERT INTO bkd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hurà makasabut sa mga etaw ha sa tagsubayen hi Jesus iyan sa Dios ha Amay din. ");
INSERT INTO bkd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Aman inikagiyan sidan hi Jesus hu “Siak sa Suled hu Kaet-etawan ku itaud a duun hu kayu daw ipatangkaw human nuy en kakilala ku sin-u a, daw matun-an nuy en ha hurà ku gayed mahimu hu kanak dà ha gahem ba sa tag-ikagiyen ku iyan gayed su intudlù kanak hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sa Amay ku ha migsugù kanak tagduma-duma gayed kanak. Harì a kandin igpatayà ta sigi ku tagbuhaten sa agkabayà-bayaan din.” ");
INSERT INTO bkd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Su mapaliman dan sa inikagi hi Jesus madakel sa tuminuu kandin. ");
INSERT INTO bkd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Inikagiyan hi Jesus sa mga Judio ha tuminuu kandin ha “Ku padayunen nuy sa intudlù ku inyu iyan kaw en laus ha mga sumusunud ku. ");
INSERT INTO bkd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Dayun matun-an nuy sa kamatuuran daw pinaagi taena malibri kaw duun hu pagkaulipen nuy.” ");
INSERT INTO bkd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tuminubag sidan hu “Iyan kay mga kaliwat hi Abraham daw hurà kay kaulipen hu bisan sin-u. Imbà nu ikagiya ha malibri kay hu pagkaulipen day?” ");
INSERT INTO bkd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ba inikagiyan sidan hi Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa makasasalà ulipen haena hu salà. ");
INSERT INTO bkd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sa ulipen kenà duma hu pamilya ba sa batà kandin gayed hu amay din. ");
INSERT INTO bkd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aman ku libriyen ku inyu siak sa Batà hu Dios harì kaw en maulipen hu salà. ");
INSERT INTO bkd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Natun-an ku ha mga kaliwatan kaw hi Abraham ba bà a dà paman inyu aghimatayi ta harì nuy agdawaten sa tigtudlù ku. ");
INSERT INTO bkd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Sa impaahà kanak hu Amay ku iyan tag-ikagiyen ku, ba sinyu iyan nuy tagbuhaten sa inikagi inyu hu amay nuy.” ");
INSERT INTO bkd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tuminubag sidan hu “Sa gin-apuan day iyan si Abraham.” Ba inikagiyan sidan hi Jesus ha “Ku laus kaw pa ha mga kaliwatan hi Abraham buhaten nuy ngaay sa binuhat hi Abraham. ");
INSERT INTO bkd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sa tagbuhaten ku iyan dà sa pagtudlù inyu hu kamatuuran ha inikagi kanak hu Dios ba bà a dà paman inyu aghimatayi. Si Abraham hurà magbuhat hu iling taena. ");
INSERT INTO bkd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ba sa tagbuhaten nuy iman iyan sa binuhat hu amay nuy.” Tuminubag sidan hu “Iyan gayed Amay day sa Dios daw laus kay ha mga batà din.” ");
INSERT INTO bkd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ba inikagiyan sidan hi Jesus ha “Ku iyan pa amay nuy sa Dios palanggaen a ngaay inyu ta diyà a napuun ta kandin daw sa pagdini ku kenà kanak dà ha pagbayà ba sinugù a kandin. ");
INSERT INTO bkd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Harì nuy agkasabut sa tag-ikagiyen ku inyu ta harì kaw tagpaliliman hu tigtudlù ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sa amay nuy iyan si Satanas aman agkabayaan nuy agtumana sa kandin ha pagbayà. Sugud dà su anay talamunù en si Satanas. Hurà din labet hu kamatuuran daw pulus en bidù sa tagsubayen din. Iyan en kinaiya din sa biduen daw diyà agkapuun ta kandin sa alan ha mga bidù. ");
INSERT INTO bkd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ba sa kanak ha tag-ikagiyen inyu kamatuuran gayed aman harì kaw agtuu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sin-u inyu sa makapamatuud hu nabuhat ku ha madaet? Hurà gayed. Iman ta laus sa tag-ikagiyen ku inyu imbà kaw harì agtuu kanak? ");
INSERT INTO bkd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sa etaw ha batà hu Dios magpaliliman gayed hu lalang din. Ba sinyu kenà kaw kandin mga batà aman iyan hinengdan ha harì kaw tagpaliliman.” ");
INSERT INTO bkd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Inikagiyan hu mga Judio si Jesus hu “Laus gayed sa inikagi day ha taga-Samaria ka daw agkalibeg ka daan.” ");
INSERT INTO bkd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ba si Jesus tuminubag hu “Imbà a inyu tagtameyesa sa kenà a man libeg daw bà ku dà tagdayea sa Dios ha Amay ku? ");
INSERT INTO bkd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Harì a agkabayà ha dayeen a hu bisan sin-u ba agkabayaan hu Dios ha dayeen a hu mga etaw daw igpaahà din ha sa tag-ikagiyen ku kamatuuran gayed. ");
INSERT INTO bkd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Laus gayed sa ag-ikagiyen ku ha bisan sin-u sa magtuman hu tigtudlù ku harì en gayed matay.” ");
INSERT INTO bkd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Su maikagi hi Jesus haena minikagi sidan hu “Iman agkatun-an day en gayed ha libeg ka labi. Si Abraham daw sa alan ha mga propita nangamatay en sidan. Imbà nu agkaikagi ha bisan sin-u sa magtuman hu tigtudlù nu harì en gayed matay? ");
INSERT INTO bkd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Labaw ka pa ba diay dì hu gin-apuan day ha si Abraham? Ta si Abraham daw sa mga propita nangamatay en sidan. Sin-u ka diay?” ");
INSERT INTO bkd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tuminubag si Jesus ha “Ku dayeen ku sa kaugalingen ku hurà din pulus, ba sa tagdayè kanak iyan sa Dios ha Amay ku ha tag-angkenen nuy daan ha Dios nuy. ");
INSERT INTO bkd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Harì nuy agkakilala ba siak agkakilala ku gayed. Ku naikagi ku pa ngaay ha harì ku haena agkakilala iling a dà inyu ha biduen. Ba saena nakilala ku gayed aman tagtuman a hu mga lalang din. ");
INSERT INTO bkd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Su gin-apuan nuy ha si Abraham nalipay gayed su matun-an din ha dumini a ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ba minikagi su mga Judio hu “Imbà nu kaahà si Abraham sa hurà ka pa man magkalimahan ha tuig?” ");
INSERT INTO bkd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tuminubag si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha su hurà pa ibatà si Abraham duduun ad en.” ");
INSERT INTO bkd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Su mapaliman dan haena nangamul sidan hu batu ta agbatuwen dan ngaay, ba luminubuk si Jesus duun hu mga etaw daw awà diyà ta Timplo. ");
INSERT INTO bkd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Su taghipanaw en si Jesus naahà din sa etaw ha daan en buta su ibatà. ");
INSERT INTO bkd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ininsaan si Jesus hu mga tinun-an din hu “Manunudlù, sin-u haini ha salà ta imbà man daan en buta su ibatà? Kandin ba hu mga laas din daw ku kandin en ba ha salà?” ");
INSERT INTO bkd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ba si Jesus tuminubag hu “Sa ingkabuta din kenà tumenged ta amin din salà daw ku nakasalà ba sa mga laas din, ba iyan ingkayanaen din ta daw maahà sa gahem hu Dios pinaagi kandin. ");
INSERT INTO bkd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ku aldaw pa kinahanglan ha buhaten taw sa mga buluhaten hu Dios ha migsugù kanak dini, ta ku daleman en harì kuy en makagtalabahu. ");
INSERT INTO bkd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ku dini a pa ta kalibutan iyan a sulù ha makailaw hu henà-henà hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Su maikagi hi Jesus haena uminileb diyà ta bugtà daw timua sa pisà ha nalemeg hu ileb din daw ipahid duun hu mata taena ha nabuta. ");
INSERT INTO bkd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Dayun inikagiyan din hu “Pangulam-us ka diyà ta Linaw ta Siloe” ha sa kahulugan taena Sinugù. Aman duminiyà haena sa buta daw pangulam-us dayun likù ha pakaindan en. ");
INSERT INTO bkd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sa mga silingan din daw sa mga etaw ha nakakilala kandin ha tagpakilimus nanginginsà hu “Kenà ba iyan hayana su etaw ha iyan dà buhat din su anay sa pagpinuuwà daw magpakilimus?” ");
INSERT INTO bkd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sa duma kandan tuminubag hu “Iyan en labi” ba sa duma minikagi daan hu “Kenà man gid ta bà su bà dà agkailing kandin.” Ba uminikagi su nakaindan en hu “Iyan ad en su buta.” ");
INSERT INTO bkd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dayun ininsaan hu mga etaw hu “Nainu-inu sa impakaindan nu?” ");
INSERT INTO bkd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tuminubag haena hu “Saena ha tagngaranan ki Jesus uminileb diyà ta bugtà daw ipahid sa pisà ha nalemeg hu ileb din dini ta mata ku. Dayun inikagiyan a kandin ha mangulam-us a diyà ta Linaw ta Siloe. Aman duminuun a daw pangulam-us dayun sagunà a nakaindan.” ");
INSERT INTO bkd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nanginginsà sidan hu “Hindu en man haena?” Su nakaindan tuminubag hu “Hanaw ta gid ku hindu en.” ");
INSERT INTO bkd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Inuwit ku mga etaw su nakaindan en duun hu mga Fariseo. ");
INSERT INTO bkd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Duun hu aldaw hu Sabado haena sa pagpamulung hi Jesus pinaagi hu pisà ha nalemeg hu ileb din. ");
INSERT INTO bkd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aman ininsaan en paman ku mga Fariseo su nakaindan hu “Nainu-inu sa impakaindan nu?” Tuminubag haena hu “Inugsakan hi Jesus hu pisà sa mata ku daw nangulam-us a aman sagunà a nakaindan.” ");
INSERT INTO bkd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sa duma ha mga Fariseo minikagi hu “Harì mahimu ha sinugù hu Dios sa agpamulung duun hu Aldaw hu Paghimlay ta saini supak hu Kasuguan.” Ba sa duma tuminubag daan ha “Ku masinupaken pa ha etaw harì din ngaay mabuhat sa mga belenganen ha iling taena.” Aman hurà makag-iling sa mga henà-henà dan. ");
INSERT INTO bkd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Dayun inisaban dan ininsaan su nakaindan hu “Inu sa maikagi nu mahitenged taena ha migbulung hu mata nu?” Tuminubag haena hu “Iyan en gayed haena propita.” ");
INSERT INTO bkd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sa mga punuan hu Judio harì en paman agtuu ha su etaw laus gayed ha buta su anay ba nakaindan en, aman pinaelegan dan sa mga laas din ");
INSERT INTO bkd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","daw insai hu “Inyu ba haini ha batà? Laus ba ha daan en haini buta su ibatà? Imbà man pakaindan en iman?” ");
INSERT INTO bkd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tuminubag sa mga laas din hu “Agkakilala day haini ha iyan gayed su batà day daw laus ha daan en haini buta su ibatà. ");
INSERT INTO bkd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ba hurà day katun-i ku nainu-inu sa pagpakaindan din daw ku sin-u sa migbulung kandin. Iyan nuy en insaan ta magulang en daan daw iyan en makaikagi inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iyan haena inikagi hu mga laas din ta agkahaldek sidan hu mga punuan hu Judio tumenged ta nauyunan en ku mga punuan ha bisan sin-u sa umikagi ha si Jesus iyan su Mesiyas harì gayed ipaseled duun hu simbahan. ");
INSERT INTO bkd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aman bà dà minikagi sa mga laas din hu “Iyan nuy en insaan ta magulang en daan.” ");
INSERT INTO bkd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Inisab en paman inumaw ku mga punuan su nakaindan daw ikagiyi hu “Isaad nu duun hu Dios ha harì ka gayed magbidù ta natun-an day en ha sa migbulung ikaw masinupaken ha etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ba su nakaindan minikagi hu “Harì ku agkatun-an ku masinupaken ba haena daw ku kenà. Iyan dà agkatun-an ku ha su anay buta a ba iman pakaindan ad en.” ");
INSERT INTO bkd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Dayun uminisab nanginginsà su mga punuan hu “Pig-inu-inu din hu pagbulung sa mata nu?” ");
INSERT INTO bkd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ba saena tuminubag hu “Inikagiyan kud gan inyu ba harì kaw tagpaliliman. Imbà nuy igpasublì dà kanak? Agkabayà kaw en ba daan agsunud kandin?” ");
INSERT INTO bkd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dayun tinameyes dan su etaw daw ikagiyi hu “Iyan ka dà sumusunud din ba sikay mga sumusunud kay hi Moises. ");
INSERT INTO bkd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Natun-an day ha su anay migpakiglalang sa Dios ki Moises, ba saena ha migbulung ikaw hurà day katun-i ku hindu duun napuun.” ");
INSERT INTO bkd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tuminubag haena sa etaw hu “Agkabelengan ku gayed sa inikagi nuy. Harì nuy agkatun-an ku hindu haena napuun ba iyan migbulung hu mata ku. ");
INSERT INTO bkd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Natun-an taw en ha harì agpalilimanan hu Dios sa masinupaken ha etaw, ba saena ha tagsimba hu Dios daw tagtuman hu agkabayaan din iyan agpalilimanan din. ");
INSERT INTO bkd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Sugud dà hu katanghagaa ta kalibutan daw taw pa iman napaliman ha amin nakaulì hu mata hu daan en buta su ibatà. ");
INSERT INTO bkd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ku hurà pa haena sugua hu Dios harì din ngaay mahimu.” ");
INSERT INTO bkd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tuminubag haena sa mga punuan hu “Agtudluan kay ba daan ikaw sikaw sa masinupaken sugud dà su ibatà?” Dayun inikagiyan dan haena ha harì en gayed mahimu ha sumeled pa duun hu simbahan. ");
INSERT INTO bkd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Su mapaliman hi Jesus ha su pigbulung din harì en igpaseled duun hu simbahan pinan-ahà din dayun haena. Su maahà din en ininsaan din hu “Agtuuwan nu ba sa Suled hu Kaet-etawan?” ");
INSERT INTO bkd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tuminubag su etaw hu “Ikagiyi a ikaw ku sin-u haena ta daw makatuu a kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Inikagiyan hi Jesus hu “Naahà nud en ta saini ha pakiglalang iman ikaw iyan en.” ");
INSERT INTO bkd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dayun tuminubag su etaw ha “Ginuu, agtuu a gayed ikaw” daw sagunà haena suminimba ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Minikagi si Jesus hu “Sa pagdini ku ta kalibutan iyan sa paghukum hu mga etaw ta daw saena ha agkailing hu buta makaindan ba sa tag-ikagi ha pakaindan en buta diay.” ");
INSERT INTO bkd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amin mga Fariseo ha nakapaliman hu inikagi din aman nanginginsà ha “Buta kay ba diay?” ");
INSERT INTO bkd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tuminubag si Jesus ha “Ku buta kaw pa hurà nuy ngaay salà, ba iman ta kagi nuy ha pakaindan kaw en tagpamatuud haini ha makasasalà kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Laus gayed sa ag-ikagiyen ku inyu ha sa etaw ku harì duun umagi hu pultahan ku sumeled duun hu alad hu karniro, saena ha etawa takaw. ");
INSERT INTO bkd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ba sa etaw ha duun tag-agi hu pultahan iyan sa magbalantay hu mga karniro. ");
INSERT INTO bkd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Saena igpaseled hu bantay hu pultahan daw agpalilimanan hu mga karniro sa lageng din. Umawen din sa mga ngaran taena ha mga karniro daw igpaguwà din sidan. ");
INSERT INTO bkd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ku humipanaw en sidan diyà ta guwà iyan tag-una sa magbalantay daw sa mga karniro aglupug kandin ta agkakilala dan en sa lageng taena. ");
INSERT INTO bkd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Harì gayed sidan lumupug hu lain ha etaw ta bà dan dà haena agpulaguyi tumenged ta harì dan agkakilala.” ");
INSERT INTO bkd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iyan haini pananglitan ha inikagi kandan hi Jesus ba hurà dan katun-i ku inu sa kahulugan taena. ");
INSERT INTO bkd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aman minikagi en paman si Jesus hu “Laus gayed sa ag-ikagiyen ku inyu ha iyan a su pultahan hu alad hu mga Juan 10:14 karniro. ");
INSERT INTO bkd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amin nauna dì kanak ba mga takaw sidan aman sa mga karniro hurà magpaliliman kandan. ");
INSERT INTO bkd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iyan a gayed pultahan daw bisan sin-u sa umagi dini ta kanak maluwas gayed. Sumeled daw gumuwà sidan hu pagpanabtab. ");
INSERT INTO bkd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sa takaw agseled duun hu alad ta agpanakaw daw agpangimatay daw agpandaet. Ba siak duminini a ta daw mailahan ku inyu hu kinabuhì ha hurà din katapusan daw hu kinabuhì daan iman ha madagway gayed tungkay. ");
INSERT INTO bkd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iyan a maayad ha magbalantay hu mga karniro. Sa maayad ha magbalantay andam en bisan ku matay tumenged hu mga karniro din. ");
INSERT INTO bkd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sa tagbantay ha bà dà sinuhuli kenà iyan tag-iya hu mga karniro. Aman ku makaahà hu agpamangaen hu mga karniro bà din dà agpulaguyi haena sa mga karniro. Dayun su agpamangaen hu mga karniro ipagsusuwayà din sa mga karniro. ");
INSERT INTO bkd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Saena ha bà dà sinuhuli agpulaguy ta harì din man agkanugunan sa mga karniro. ");
INSERT INTO bkd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iyan a gayed maayad ha magbalantay hu mga karniro. Nakilala ku sa kanak ha mga karniro daw nakilala a daan kandan ");
INSERT INTO bkd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","iling ha nakilala a hu Dios ha Amay ku daw nakilala ku daan haena. Andam a daan bisan ku matay a tumenged hu mga karniro ku. ");
INSERT INTO bkd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Amin ku pa mga karniro ha hurà pa makaseled duun hu alad. Kinahanglan ha igpaseled ku pa daan sidan. Magpaliliman daan sidan kanak dayun makag-amulà dà sidan daw sabuwa a dà sa magbalantay dan. ");
INSERT INTO bkd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Iyan haini igpalanggaa kanak hu Amay ku ta andam a bisan ku matay a tumenged kandan. Ba ku matay a mabanhaw a dà. ");
INSERT INTO bkd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hurà gayed makapatay kanak ba ku matay a kanak en ha pagbayà. Amin ku katenged hu pagpakamatay daw amin ku daan gahem ha mabanhaw a dà ta iyan haini insugù kanak hu Dios ha Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Su mapaliman hu mga Judio sa inikagi hi Jesus hurà makag-iling sa henà-henà dan. ");
INSERT INTO bkd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Madakel kandan sa tag-ikagi hu “Agkalibeg en gayed hayana. Imbà kuy tagpaliliman kandin?” ");
INSERT INTO bkd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ba sa duma minikagi ha “Ku agkalibeg pa hayana harì din ngaay maikagi haena, daw sa agkalibeg harì daan makaulì hu buta.” ");
INSERT INTO bkd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Panahun haena ha agsaulugen diyà ta Jerusalem sa Paglimpyu hu Timplo. Duun taena ha panahun matinù gayed. ");
INSERT INTO bkd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Mighiphipanaw si Jesus duun taena ha Sihungà hi Salomon diyà ta Timplo. ");
INSERT INTO bkd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Inamul-amulan hu mga Judio daw ikagiyi hu “Imbà nu harì ag-ikagiya kanay ku sin-u ka? Ikagiyi kay en ikaw ku iyan kad ba su Mesiyas.” ");
INSERT INTO bkd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tuminubag si Jesus hu “Inikagiyan kud en inyu ba hurà kaw tuu kanak. Sa mga belenganen ha binuhat ku ha insugù hu Dios ha Amay ku iyan migpakilala ku sin-u a ");
INSERT INTO bkd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ba harì kaw gayed agtuu tumenged ta kenà ku inyu mga karniro. ");
INSERT INTO bkd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sa kanak ha karniro tagpaliliman hu lageng ku. Agkakilala ku sidan daw aglupug sidan kanak. ");
INSERT INTO bkd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ilahan ku daan sidan hu kinabuhì ha hurà din katapusan daw harì en gayed sidan malaag ta hurà en bisan sin-u ha makaagaw kandan dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sa Dios ha Amay ku ha iyan mig-ila kanak hu mga karniro iyan gayed labaw hu alan, aman hurà en makaagaw kandan diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Siak daw sa Amay ku sabuwa kay dà.” ");
INSERT INTO bkd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Su mapaliman haena hu mga Judio nangamul en paman sidan hu mga batu ta agbatuwen dan ngaay. ");
INSERT INTO bkd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ba inikagiyan sidan hi Jesus hu “Madakel en sa impaahà ku inyu ha mga belenganen ha impabuhat kanak hu Dios ha Amay ku. Inu man sa igbatuwa nuy kanak?” ");
INSERT INTO bkd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tuminubag sidan hu “Kenà day iyan igbatuwa ikaw sa mga belenganen ha binuhat nu ba tumenged ta tagtameyesen nu sa Dios, ta imbà ka tag-ikagiyà ha sabuwa kaw dà hu Dios ha etaw ka dà man hu ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Inikagiyan sidan hi Jesus ha “Hurà ba makasulat en duun hu Kasuguan nuy sa lalang hu Dios ha tagyanaen ‘Iyan kaw mga magbabayà’? ");
INSERT INTO bkd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Natun-an taw ha harì gayed mahimu ha mabalhin sa insulat ha lalang hu Dios. Ku pigngaranan din sa mga gin-apuan taw ha iyan inilahan hu lalang din ha ‘mga magbabayà,’ ");
INSERT INTO bkd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","imbà nuy agkaikagi ha tagtameyesen ku sa Dios ku ikagiyen ku ha Batà a kandin sa labaw a pa man dì kandan ta pinilì a hu Dios ha impadini ta kalibutan? ");
INSERT INTO bkd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Harì kaw tumuu kanak ku kenà ku iyan tagbuhaten sa insugù kanak hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ba tumenged ta iyan haena tagbuhaten ku, bisan ku harì kaw tumuu kanak ba tuuwan nuy ngaay sa mga belenganen ta daw matun-an nuy gayed ha sa Dios ha Amay ku dini ta kanak daw diyà a daan ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tumenged taena agdakepen dan en paman ngaay si Jesus ba uminawà haena diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dayun luminayun si Jesus diyà ta Jordan daw duun migtimà hu lugar ha duun namautismu si Juan su anay. ");
INSERT INTO bkd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Madakel sa mga etaw ha duminiyà ki Jesus ta nahenà-henà dan ha “Bisan ku hurà belenganen ha nabuhat hi Juan su anay ba sa alan ha inikagi din mahitenged ki Jesus laus gayed.” ");
INSERT INTO bkd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Duun taena ha lugar madakel sa mga etaw ha tuminuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Amin etaw ha agkatungkayan hu dalu ha tagngaranan ki Lazaro. Saena diyà tagtimà ta Betania daw sa atebay din ha si Maria daw si Marta diyà daan tagtimà. ");
INSERT INTO bkd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Saini ha Maria ha agkadaluwan sa suled din ha maama iyan su bahi ha mighudhud hu pahumut duun hu paa hi Jesus daw tarapuwi ta buhuk din. ");
INSERT INTO bkd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pinaelegan ku daruwa ha bahi si Jesus daw ikagiyi hu “Ginuu, agkatungkayan hu dalu sa palanggà nu ha amigu.” ");
INSERT INTO bkd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Su mapaliman haena hi Jesus bà dà minikagi hu “Harì din iyan ipatay sa dalu ba iyan igkadaluwi din ta daw madayè sa Dios ha Amay ku daw madayè a daan sa Batà din pinaagi taena.” ");
INSERT INTO bkd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pinalanggà hi Jesus si Marta daw sa suled din daw si Lazaro, ");
INSERT INTO bkd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ba su mapaliman din ha agkatungkayan hu dalu si Lazaro hurà pa haena sagunà diyà ta mig-angat pa hu daruwa ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Su maiwas haena inikagiyan din sa mga tinun-an din ha “Dumiyà kuy ta Judea.” ");
INSERT INTO bkd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ba tuminubag sa mga tinun-an din hu “Manunudlù, imbà ka aglikù diyà sa bag-u pa ha agbatuwen kad ngaay hu mga Judio?” ");
INSERT INTO bkd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Inikagiyan sidan hi Jesus hu “Sampulù daw daruwa ha uras sa nangkaaldaw. Bisan sin-u sa taghipanaw ku aldaw harì gayed pakasipà ta mapawà, ");
INSERT INTO bkd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ba saena ha taghipanaw ku daleman pakasipà gayed ta masukilem man.” ");
INSERT INTO bkd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Daw minikagi pa daan ha “Tuminiduga en sa amigu taw ha si Lazaro ba dumiyà kuy ta agpukawen ku.” ");
INSERT INTO bkd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tuminubag haena sa mga tinun-an din hu “Ginuu, ku nakatiduga en saena agkaulian en.” ");
INSERT INTO bkd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ba iyan ngaay kahulugan hu inikagi hi Jesus sa minatay en si Lazaro ba abi dan ha bà dà tagtiduga. ");
INSERT INTO bkd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Aman ben paman sidan inikagiyi en hu “Minatay en si Lazaro, ");
INSERT INTO bkd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ba maayad ha hurà a diyà su matay ta daw makatuu kaw gayed kanak. Diyà kuy en.” ");
INSERT INTO bkd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Dayun si Tomas ha tagngaranan dan hu Saleping minikagi duun ku duma din ha mga tinun-an ha “Dumiyà kuy en ta daw mangamatay kuy daan duma hu Manunudlù taw.” ");
INSERT INTO bkd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Su makauma si Jesus diyà ta Betania haepat en ha aldaw sa kalebenga ki Lazaro. ");
INSERT INTO bkd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Sa banuwa ta Betania ubay dà diyà ta Jerusalem ta mga tatulu dà ha kilomitro sa pig-elangan din, ");
INSERT INTO bkd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","aman si Marta daw si Maria inelegan hu mga taga-Jerusalem hu paglipay kandan ta minatay sa suled dan. ");
INSERT INTO bkd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Su mapaliman hi Marta ha tagdiyà en si Jesus sagunà haena tuminalagbù, ba si Maria diyà dà ta balay dan. ");
INSERT INTO bkd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dayun inikagiyan hi Marta si Jesus hu “Ginuu, ku dini ka pa ngaay harì gayed matay sa suled ku. ");
INSERT INTO bkd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ba natun-an ku ha bisan iman ku amin nu agpanayuen duun hu Dios ig-ila din ikaw.” ");
INSERT INTO bkd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tuminubag si Jesus hu “Mabanhaw dà sa suled nu.” ");
INSERT INTO bkd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Minikagi si Marta hu “Natun-an ku ha mabanhaw dà haena ku malugay.” ");
INSERT INTO bkd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ba si Jesus minikagi hu “Iyan a pakabanhaw daw iyan a daan pakaila hu kinabuhì. Ku amin agtuu kanak, bisan ku matay ba mabanhaw dà ");
INSERT INTO bkd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ta saena ha agtuu kanak amin din kinabuhì daw harì en gayed matay. Agtuu ka ba daan taena?” ");
INSERT INTO bkd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tuminubag si Marta hu “Hee, Ginuu, agtuu a ha iyan ka su Mesiyas ha Batà hu Dios ha intagnà ha dumini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Su maikagi haena hi Marta luminikù diyà ta balay dan daw muymuyahi si Maria hu kagi din “Tagdini en labi sa Manunudlù na dumiyà ka kun ta kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Su mapaliman haena hi Maria sagunà tuminalagbù ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hurà pa si Jesus makauma diyà ta banuwa ta duun pa hu tinalagbuan dan ki Marta. ");
INSERT INTO bkd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sa mga etaw diyà ta balay hi Maria ha taglipay kandin naahà dan si Maria ha tigkan huminitindeg daw hipanaw, aman linupug dan ta abi dan ha bà dà ag-agalà duun ku lebeng hi Lazaro. ");
INSERT INTO bkd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Su makauma si Maria diyà ki Jesus sagunà luminuhud duun hu atubangan din ha minikagi hu “Ginuu, ku dini ka pa gabia harì ngaay matay sa suled ku.” ");
INSERT INTO bkd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Su maahà hi Jesus si Maria daw sa mga Judio ha duminuma kandin ha tag-agalà suminakit daan sa gahinawa din, ");
INSERT INTO bkd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","aman ininsaan din sidan hu “Hindu duun inlebeng si Lazaro?” Tuminubag sidan hu “Diyà kuy ta daw maahà nu.” ");
INSERT INTO bkd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dayun namanulù sa luhà hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aman minikagi sa mga Judio hu “Ahaa nuy ku inu kaadagi sa pagpalanggà din ki Lazaro.” ");
INSERT INTO bkd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ba sa duma minikagi hu “Imbà din hurà kaulii si Lazaro na su buta naulian din man?” ");
INSERT INTO bkd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Su tagduun en si Jesus ku linebengan ki Lazaro suminakit en paman sa gahinawa din. Sabuwa ha bangbang su lebeng daw inipelan hu batu ");
INSERT INTO bkd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","aman suminugù si Jesus hu “Awaa nuy haini sa batu.” Ba si Marta sa suled hi Lazaro minikagi hu “Ginuu, mahudù en iman hayana ta haepat en ha aldaw sa kalebenga kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Dayun tuminubag si Jesus hu “Dì ba inikagi kud ikaw ha ku tumuu ka maahà nu sa pagkagamhanan hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aman inawà dan su batu ha in-ipel ku lebeng. Dayun huminangad si Jesus diyà ta langit sa mig-ampù hu “Amay ku, tagpasalamat a ikaw ta migpaliliman ka kanak. ");
INSERT INTO bkd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Natun-an ku ha dayun ka dà tagpaliliman kanak, ba tumenged taini ha mga etaw ha tagtiyadeg dini inikagi ku haini ta daw makatuu sidan ha sinugù a gayed ikaw dini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Su makapenga en haena mag-ampù uminikagi hu madaging hu “Lazaro, guwà ka duun tayan.” ");
INSERT INTO bkd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Sagunà guminuwà si Lazaro ha nabungkusan pa sa lawa din hu maputì ha manggad daw nabungkusan daan sa weleng din hu panyù. Aman inikagiyan sidan hi Jesus hu “Badbadi nuy hayana ta daw makaawà.” ");
INSERT INTO bkd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Madakel sa mga Judio ha namisita ki Maria sa nakatuu gayed ki Jesus su maahà dan sa binuhat din. ");
INSERT INTO bkd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ba sa duma kandan migsumbung hu binuhat hi Jesus duun hu mga Fariseo. ");
INSERT INTO bkd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aman sa mga labaw ha sinaligan hu paghalad daw sa mga Fariseo inamul-amul dan sa alan ha duma dan ha mga labaw ha punuan hu mga Judio. Miglalang-lalang sidan hu kagi dan “In-inuwen taw haena sa etaw ha madakel en sa nabuhat din ha belenganen? ");
INSERT INTO bkd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ku ipatayà taw iman haena madakel gayed sa tumuu kandin daw elegan kuy hu mga sundalu ta Roma. Kagasen dan haini sa Timplo daw daetan dan haini sa nasud taw.” ");
INSERT INTO bkd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ba si Caifas ha iyan tungkay labaw ha sinaligan hu paghalad duun taena ha tuiga minikagi ha “Buang-buang kaw pa gayed. ");
INSERT INTO bkd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Harì nuy ba diay agkatun-an ha maayad pa ku sabuwa dà sa matay para hu alan ha mga etaw dì ku madaetan pa haini sa nasud taw?” ");
INSERT INTO bkd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Saena ha naikagi din kenà kandin dà ha henà-henà, ba tumenged ta iyan tungkay labaw ha sinaligan hu paghalad pakatagnà daan ha si Jesus matay para hu alan ha mga Judio. ");
INSERT INTO bkd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Daw kenà para dà hu mga Judio ba para daan hu alan ha mga etaw hu Dios ha nakagsusuwayà dini ta kalibutan ta daw makag-amulà dà sidan ku malugay. ");
INSERT INTO bkd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sugud taena ha aldaw sa mga labaw ha punuan hu mga Judio nan-ahà hu paagi ha mapatay dan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aman si Jesus daw sa mga tinun-an din harì en pakahipanaw duun hu kadakelan diyà ta probincia ta Judea. Ba namandiyà sidan ta banuwa ta Efraim ha ubay duun hu pinakabulung-bulung ha lugar daw diyà sidan migtimà. ");
INSERT INTO bkd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Su madani en agsaulugen sa Aldaw hu Paglabay madakel ha mga etaw sa duminiyà ta Jerusalem ha nangapuun duun hu migkalain-lain ha banuwa ta agtumanen dan diyà sa tulumanen hu paglimpyu. ");
INSERT INTO bkd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Su mangaamul-amul sidan duun hu Timplo pigpan-ahà dan si Jesus daw migpainsaay sidan hu “Inu sa henà-henà nuy? Tumampu ba gid haena hu pagsaulug daw ku harì?” ");
INSERT INTO bkd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ba sa mga labaw ha sinaligan hu paghalad daw sa mga Fariseo daan en mig-ikagi ha ku sin-u sa makatuen ku hindu duun si Jesus kinahanglan gayed ha magsumbung ta agdakepen dan haena. ");
INSERT INTO bkd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Su haenem pa ha aldaw daw human agsauluga sa Aldaw hu Paglabay duminiyà si Jesus ta Betania ha tagtimaan hi Lazaro sa pigbanhaw din. ");
INSERT INTO bkd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Su makauma haena diyà impapanihapun dan. Si Lazaro suminalu ki Jesus daw si Marta iyan migtangel. ");
INSERT INTO bkd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria tuminimù hu nangkabutilya ha mahalen gayed ha lana ha tagngaranan hu nardo, dayun inhudhud din haena diyà ta paa hi Jesus daw tarapuwi ta buhuk din. Nakaheet gayed diyà ta balay sa nadeg taena ha tungkay mahumut. ");
INSERT INTO bkd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ba sa sabuwa ha tinun-an hi Jesus ha iyan si Judas Iscariote sa iyan daan maglimbung kandin minikagi hu ");
INSERT INTO bkd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Imbà hurà ibaligyà hayana sa pahumut hu pila ha gatus daw sa halin din iila ngaay duun hu mga makaluluuy?” ");
INSERT INTO bkd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Naikagi din haena kenà tumenged ta agkahid-uwan din sa mga makaluluuy ba tumenged ta takaw haena, ta si Judas iyan tag-ibit hu salapì dan daw agtakawen din sa duma duun. ");
INSERT INTO bkd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ba minikagi si Jesus hu “Bay-ani nuy en hayana ta saini ha pahumut din iyan en pag-andam hu kalebenga kanak. ");
INSERT INTO bkd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sa mga makaluluuy sigi dà diyan ta inyu ba siak harì ad en maglugay dini ta inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Su mapaliman hu madakel ha mga Judio ha si Jesus diyà ta Betania namandiyà dayun sidan. Ba sa tuyù dan kenà iyan dà si Jesus ba agsusiyen dan ku laus ba ha nabanhaw si Lazaro. ");
INSERT INTO bkd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Aman pighenà-henà hu mga labaw ha sinaligan hu paghalad ha aghimatayan dan daan si Lazaro ");
INSERT INTO bkd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta tumenged kandin madakel ha mga Judio sa nakabig diyà ki Jesus daw tuminuu. ");
INSERT INTO bkd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Su maisab ha aldaw sa madakel tungkay ha mga etaw ha agtampu hu pagsaulug nakapaliman ha agdiyà daan si Jesus ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Aman tuminalagbù sidan kandin daw mig-uwit sidan hu mga palwa hu pagdayè kandin daw namangulahì sidan hu “Dayeen gayed sa Dios. Panalanginan haini sa nakauma ha sinugù hu Dios. Panalanginan sa Harì hu mga kaliwatan hi Israel.” ");
INSERT INTO bkd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Amin nati hu asno ha piglulanan hi Jesus, ta sa insulat ha lalang hu Dios tagyanaen ");
INSERT INTO bkd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sinyu sa mga taga-Jerusalem, harì kaw mahaldek ta sa Harì nuy pakauma en ha taglulan duun hu nati hu asno.” ");
INSERT INTO bkd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Duun taena ha panahun hurà katun-i hu mga tinun-an din sa kahulugan taena ha tagnà. Ba su lumikù en si Jesus diyà ta langit human dan natun-i ha saena ha insulat mahitenged man diay kandin daw natuman haena diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Sa intalagbua ki Jesus hu madakel tungkay ha mga etaw iyan ta napaliman dan sa tultul hu mga etaw ha nakaduma kandin su banhawen din si Lazaro. ");
INSERT INTO bkd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aman nakaikagi sa mga Fariseo ha “Hurà taw en gayed mahimu ta ahà kaw, madakel gayed sa agsunud kandin.” ");
INSERT INTO bkd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amin mga etaw ha Griego ha namandiyà daan ta Jerusalem hu pagsimba taena ha pagsaulug. ");
INSERT INTO bkd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hinangyù dan si Felipe sa taga-Betsaida ha sakup ta Galilea hu kagi dan “Agkabayà kay pakiglalang ki Jesus.” ");
INSERT INTO bkd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aman inikagiyan hi Felipe si Andres dayun migduma-duma sidan daw ikagiyi si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tuminubag si Jesus hu “Iyan en haini natugun ha panahun ha dayeen a siak sa Suled hu Kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Laus gayed sa ag-ikagiyen ku inyu ha ku harì makapamula sa binhì dini ta bugtà harì gayed mamunga, ba ku ipamegas tumubù gayed haena daw mamunga hu madakel. ");
INSERT INTO bkd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Bisan sin-u sa agkanugun hu kinabuhì din matay dà gihapun, ba saena ha tagsunud kanak bisan duun hu kamatayen amin din kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bisan sin-u sa agkabayà ha mahimu ha suluguen ku kinahanglan ha lumupug kanak daw bisan ku hindu a, duun en daan haena. Sa magtuman hu mga sugù ku madayè gayed hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Iman masakit tungkay sa gahinawa ku, ba harì mahimu ha hangyuen ku sa Dios ha Amay ku ha harì a kandin ipaagi duun hu tagsalapen ku ha tungkay malegen ta iyan indini ku ta kalibutan ta daw matuman haena.” ");
INSERT INTO bkd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aman mig-ampù si Jesus hu “Amay ku, buhata sa madayè ka pinaagi kanak.” Dayun amin lageng ha napuun diyà ta langit ha tagyanaen “Nadayè ad en pinaagi ikaw ba madayè a pa gayed hu agbuhaten nu.” ");
INSERT INTO bkd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Saena ha lageng napaliman hu madakel ha mga etaw daw nakaikagi sidan ha “Lugung gid haena” na sa duma daan minikagi hu “Nakiglalang kandin sa balinsuguen hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Inikagiyan sidan hi Jesus hu “Saena ha lageng impapaliman inyu ta daw matun-an nuy ");
INSERT INTO bkd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ha iyan en iman panahun ha sa Dios maghukum hu silut taena ha harì agtuu kanak, ta si Satanas ha iyan harì dini ta kalibutan madaeg. ");
INSERT INTO bkd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ba siak ku itaud a duun hu kayu daw ipatangkaw sa kaet-etawan duun hu bisan hindu makadini ta kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Inikagi hi Jesus haena ta daw makapadayag ku agkainu-inu sa kamatayen din. ");
INSERT INTO bkd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Su mga etaw uminikagi hu “Natun-an taw pinaagi hu Kasuguan taw ha harì gayed matay su Mesiyas, aman imbà nu kaikagi ha kinahanglan ha itaud sa Suled hu Kaet-etawan duun hu kayu daw ipatangkaw? Sin-u haini sa Suled hu Kaet-etawan?” ");
INSERT INTO bkd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Dayun tuminubag si Jesus hu “Iyan ad sulù ha makailaw hu henà-henà nuy ba laus kud en inyu ag-awaan. Aman hipanaw kaw ta aldaw pa daw harì kaw madalemanan ta saena ha agkadalemanan agkalaag. ");
INSERT INTO bkd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iman ta dini a pa ta inyu tuu kaw en kanak ta daw mailawan sa henà-henà nuy.” Su maikagi haena hi Jesus inawaan din sa madakel ha mga etaw daw duminuun hu lugar ha harì dan duun matulen. ");
INSERT INTO bkd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bisan pa ku madakel gayed sa binuhat hi Jesus ha belenganen ba hurà sidan tuu kandin. ");
INSERT INTO bkd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iyan haini katumanan hu inikagi hi Isaias sa propita ha tagyanaen “Dios ha Magbabayà hu alan, atiyuay dà gayed sa tuminuu hu intultul day daw atiyuay dà sa nakatuen hu gahem nu ha impaahà nu kandan.” ");
INSERT INTO bkd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iyan haini hinengdan ha hurà sidan makatuu ta sa inikagi hi Isaias tagyanaen ");
INSERT INTO bkd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binuhat sidan hu Dios ha buta ta daw harì sidan makaindan. Impadesen din daan sa henà-henà dan ta daw harì sidan makasabut daw harì daan makaghinulsul ta daw maluwas ku ngaay.” ");
INSERT INTO bkd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Naikagi haena hi Isaias ta naahà din en sa pagkagamhanan hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Bisan pa taena amin gihapun mga punuan hu Judio ha nakatuu ki Jesus. Ba bà dan dà inheles ta agkangahaldek sidan hu mga Fariseo ku harì sidan ipaseled duun hu simbahan, ");
INSERT INTO bkd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ta iyan en impalabi ku mga punuan sa pagdayè kandan hu mga etaw dì hu pagdayè kandan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Dayun minikagi si Jesus hu “Sa agtuu kanak agtuu en daan hu Dios ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ku agkaahà a hu etaw agkaahà din en daan sa Dios ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iyan a sulù ha nakadini ta kalibutan ta daw sa alan ha tumuu kanak harì en maghipanaw duun hu masukilem. ");
INSERT INTO bkd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ku amin etaw ha nakapaliman hu lalang ku ba harì magtuman taena harì ku pa iman haena mahukuman, ta sa pagdini ku iman ta kalibutan kenà pa iyan sa paghukum ba iyan sa pagluwas hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bisan sin-u sa harì agdawat kanak daw harì agtuman hu mga lalang ku mahukuman duun hu katapusan ha aldaw. Sa ihukum kandin iyan sa mga lalang ku ha hurà din tumana. ");
INSERT INTO bkd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta sa tag-ikagiyen ku kenà kanak ha henà-henà ba iyan sa igpaikagi kanak hu Dios ha Amay ku ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Natun-an ku ha sa lalang din makaila hu kinabuhì ha hurà din katapusan. Aman sa tag-ikagiyen ku iyan sa igpaikagi kanak hu Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Su harì pa agsaulugen sa Aldaw hu Paglabay natun-an hi Jesus ha madani en sa natugun ha panahun ha ag-awà dini ta kalibutan ta ag-ulì en duun hu Dios ha Amay din. Pinalanggà din sa mga sumusunud din aman iman igpaahà din ku inu kaadagi sa pagpalanggà din kandan. ");
INSERT INTO bkd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Agpanihapun sidan ba si Judas Iscariote ha batà hi Simon daan en inulinan hi Satanas ha iyan maglimbung ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Natun-an hi Jesus ha iyan impagharì hu Dios ha Amay din hu alan daw natun-an din daan ha duun napuun hu Dios daw diyà dà daan ag-ulì ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aman huminitindeg si Jesus daw lebasa su pinaksuy din daw itabed sa tualya diyà ta bahagan din. ");
INSERT INTO bkd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dayun hinudhudan din hu wahig sa palanggana daw pangenawi sa mga paa hu mga tinun-an din daw tarapuwi taena ha tualya. ");
INSERT INTO bkd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Su mauma din en si Simon Pedro saena minikagi diyà ta kandin hu “Ginuu, aghenawan nu ba daan sa paa ku?” ");
INSERT INTO bkd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tuminubag si Jesus hu “Harì nu pa iman agkasabut sa tagbuhaten ku ba masabut nu dà asem ku malugay.” ");
INSERT INTO bkd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Minikagi si Pedro hu “Harì mahimu ha iyan ka maghenaw ta paa ku.” Ba inikagiyan hi Jesus ha “Ku harì ku mahenawan sa paa nu kenà kud en ikaw sumusunud.” ");
INSERT INTO bkd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aman minikagi si Simon Pedro hu “Ginuu, ku iyan diay hayana ilagkes nud en daan sa alima ku daw sa ulu ku.” ");
INSERT INTO bkd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tuminubag si Jesus hu “Saena ha nakaglanguy en kinahanglan ha iyan dà henawan sa paa din ta limpyu en sa lawa din. Nalimpyuwan kaw en ba amin sabuwa inyu ha mahugaw pa.” ");
INSERT INTO bkd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Inikagi hi Jesus ha mahugaw pa sa sabuwa kandan ta natun-an din en ku sin-u sa maglimbung kandin. ");
INSERT INTO bkd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Su makapenga en si Jesus mangenaw hu mga paa ku mga tinun-an din migpinaksuy dà daw likù diyà ta lamisahan. Dayun ininsaan din sidan hu “Agkatun-an nuy ba sa kahulugan taena ha binuhat ku inyu? ");
INSERT INTO bkd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iyan nuy tig-umaw kanak sa Manunudlù daw Ginuu na laus gayed hayana. ");
INSERT INTO bkd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Iman ta siak sa Ginuu daw Manunudlù nuy migpaubus a hu kaugalingen ku ta hinenawan ku sa mga paa nuy, kinahanglan ha magpahenaw-henawà kaw daan. ");
INSERT INTO bkd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta saena binuhat ku diyan ta inyu ta daw mailingan nuy. ");
INSERT INTO bkd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Laus gayed sa ag-ikagiyen ku inyu ha sa suluguen kenà labaw dì hu agalen din daw sa sinugù kenà daan labaw dì hu migsugù kandin. ");
INSERT INTO bkd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Iman ta natun-an nuy en sa intudlù ku inyu malipayen kaw en gayed ku tumanen nuy haena. ");
INSERT INTO bkd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Sa inikagi ku kenà mahitenged hu alan inyu ta natun-an kud sa mga henà-henà taena ha mga pinilì ku. Ba amin sabuwa inyu ha maglimbung kanak ta daw matuman sa lalang hu Dios ha tagyanaen ‘Sa etaw ha makigsalu kanak iyan daan magkuntra kanak.’ ");
INSERT INTO bkd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Saena daan kud en inyu ag-ikagiyen ta daw ku matuman haena makatuu kaw gayed ha iyan ad su duduun en su anay. ");
INSERT INTO bkd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Laus gayed sa ag-ikagiyen ku ha bisan sin-u sa agdawat taena ha agsuguen ku agdawat daan kanak, daw saena ha agdawat kanak agdawat daan hu Amay ku ha migsugù kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Su maikagi haena hi Jesus tungkay suminakit sa gahinawa din dayun inikagiyan din sa mga tinun-an din hu “Laus gayed sa tag-ikagiyen ku ha sa sabuwa inyu iyan maglimbung kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Migpaahà-ahaay sa mga tinun-an ta hurà dan katun-i ku sin-u sa tig-iling din. ");
INSERT INTO bkd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","24","Si Simon Pedro migsingyas duun ku abay hi Jesus ha iyan sa pinalanggà din ha tinun-an hu “Insai nu ku sin-u sa tig-iling din.” ");
INSERT INTO bkd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aman uminubay haena diyà ki Jesus daw insai hu “Ginuu, sin-u kanay sa maglimbung ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Minikagi si Jesus hu “Idèdè ku haini sa supas daw ku sin-u sa ilahan ku duun iyan en haena.” Dayun in-ila din su supas diyà ki Judas ha batà hi Simon Iscariote. ");
INSERT INTO bkd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Su makaen en haena hi Judas sagunà ginaheman hi Satanas. Inikagiyan dayun hi Jesus ha “Ku inu sa agbuhaten nu agpasa nud en.” ");
INSERT INTO bkd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hurà gayed katun-i hu mga tinun-an hi Jesus ku imbà haena ikagiya hi Jesus diyà ki Judas. ");
INSERT INTO bkd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tumenged ta iyan si Judas tag-ibit hu salapì dan abi hu duma kandan ha bà dà igpapalit hi Jesus hu agkinahanglanen dan taena ha pagsaulug daw ku amin ba daan agpailahan hi Jesus ha mga makaluluuy. ");
INSERT INTO bkd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Su makaen en haena hi Judas sagunà guminuwà daw agkadaleman en haena. ");
INSERT INTO bkd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Su makaguwà en si Judas inikagiyan hi Jesus sa mga tinun-an din hu “Harì en malugay siak sa Suled hu Kaet-etawan madayè a daw pinaagi kanak madayè daan sa Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ku pinaagi kanak madayè sa Dios ha Amay ku madayè a daan kandin hu harì en malugay. ");
INSERT INTO bkd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mga pinalanggà ku, harì en malugay sa pagduma-dumahà taw. Pan-ahaen a inyu ba ikagiyen ku inyu iman sa inikagi kud en duun hu punuan hu mga Judio ha harì kaw makaduun hu agpayanan-an ku. ");
INSERT INTO bkd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Amin ku bag-u ha kasuguan inyu ha iyan sa magpinalanggaay kaw. Iling hu kanak ha pagpalanggà inyu kinahanglan ha magpinalanggaay kaw daan. ");
INSERT INTO bkd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ku buhaten nuy haini matun-an hu mga etaw ha mga sumusunud kaw kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nanginginsà si Simon Pedro hu “Ginuu, hindu ka duun agpayanaen?” Tuminubag si Jesus hu “Harì kaw pa iman makaduun hu agpayanan-an ku ba makalupug kaw dà kanak ku malugay.” ");
INSERT INTO bkd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Minikagi si Pedro hu “Ginuu, imbà a harì makaduma ikaw? Ta bisan pa ku himatayan a harì ku gayed ikaw awaan.” ");
INSERT INTO bkd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Dayun tuminubag si Jesus hu “Laus ba ha harì a ikaw ag-awaan bisan pa ku himatayan ka? Laus gayed sa ag-ikagiyen ku ikaw ha kanina ku harì pa managauk sa manuk katatulu kad en makaikagi ha harì a ikaw agkakilala. ");
INSERT INTO bkd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Harì kaw gayed masamuk ba salig kaw duun hu Dios daw salig kaw daan kanak. ");
INSERT INTO bkd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Maluag sa tagtimaan hu Dios ha Amay ku. Ag-una a diyà ta ag-andamen ku sa agtimaan nuy. Harì ku haena maikagi inyu ku kenà pa laus. ");
INSERT INTO bkd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ku mapengahan kud haena aglikù a dà dini daw agdumahen ku inyu duun hu tagtimaan ku ta daw bisan hindu a, duun kaw en daan. ");
INSERT INTO bkd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Natun-an nuy en sa dalan duun taena ha agpayanan-an ku.” ");
INSERT INTO bkd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ba si Tomas minikagi diyà ta kandin hu “Ginuu, harì day agkatun-an ku hindu ka agpayanaen aman in-inuwen man ha matulen day sa dalan payanaen duun taena?” ");
INSERT INTO bkd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tuminubag si Jesus hu “Iyan a dalan daw iyan a kamatuuran daw iyan a tag-ila hu kinabuhì. Hurà makaduun hu Amay ku ku kenà pinaagi kanak. ");
INSERT INTO bkd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ku nakilala a pa inyu nakilala nuy ngaay daan sa Amay ku. Ba iman nakilala nuy daw naahà nuy en.” ");
INSERT INTO bkd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Minikagi si Felipe hu “Ginuu, ipaahà nu kanay sa Dios ha Amay nu. Iyan dà haini agkinahanglanen day.” ");
INSERT INTO bkd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tuminubag si Jesus hu “Nalugay en sa pagduma-dumahà ku inyu na hurà nuy pa ba diay kakilala ku sin-u a? Bisan sin-u sa nakaahà kanak nakaahà en daan hu Amay ku, aman imbà nu kaikagi pa ha ag-ahaen nu sa Amay ku? ");
INSERT INTO bkd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Harì ka ba diay agtuu ha sa Amay ku dini ta kanak daw diyà a daan ta kandin? Bisan sa mga lalang ku inyu kenà duun dà napuun hu kanak ha henà-henà ta sa Amay ku ha dini tagtimà ta kanak iyan migbayà taena. ");
INSERT INTO bkd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Aman tuu kaw hu tag-ikagiyen ku ha siak daw sa Amay ku sabuwa kay dà. Ku harì kaw agtuu hu inikagi ku tuu kaw tumenged hu mga buhat ku. ");
INSERT INTO bkd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Laus gayed sa ag-ikagiyen ku inyu ha bisan sin-u sa tumuu kanak makahimu daan hu binuhat ku, daw labaw pa sa mabuhat din tumenged ta ag-ulì ad en duun hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bisan inu sa panayuen nuy pinaagi kanak ig-ila ku gayed haena ta daw madayè sa Dios ha Amay ku tumenged kanak. ");
INSERT INTO bkd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Makapanayù kaw hu bisan inu pinaagi kanak ta ig-ila ku gayed. ");
INSERT INTO bkd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ku pinalanggà a inyu tumanen nuy sa mga sugù ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Daw agpanayuen ku duun hu Amay ku ha ipadini din ta inyu sa igpasuhì kanak ha iyan Magbubulig ha harì en gayed sumuway inyu ");
INSERT INTO bkd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","daw magtudlù daan haena inyu hu kamatuuran. Harì haena madawat hu mga etaw ha harì agtuu kanak ta harì dan haena agkaahà daw harì dan daan agkakilala. Ba sinyu makilala nuy gayed ta diyan ta inyu magtimà daw makigsabuwa en inyu. ");
INSERT INTO bkd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Harì ku gayed inyu ipatayà ta igpadini ku sa Magbubulig inyu. ");
INSERT INTO bkd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Harì en malugay harì ad maahà hu mga etaw ha hurà tuu kanak ba sinyu maahà a dà inyu. Tumenged ta sa kinabuhì ku hurà din katapusan amin nuy daan kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Duun asem taena ha aldaw matun-an nuy ha siak daw sa Dios ha Amay ku sabuwa kay dà, daw siak daw sinyu sabuwa kuy dà daan. ");
INSERT INTO bkd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bisan sin-u sa magpaliliman hu mga kasuguan ku daw magtuman taena palanggà a kandin. Saena ha tagpalanggà kanak palanggà daan hu Amay ku daw palanggà ku daan daw igpakilala ku kandin ku sin-u a.” ");
INSERT INTO bkd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Dayun nanginginsà si Judas ba kenà iyan si Judas Iscariote hu “Ginuu, imbà nu tuyua ha iyan kay dà impakilala nu hu kaugalingen nu daw hurà nu sa mga etaw ha harì agtuu ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tuminubag si Jesus hu “Bisan sin-u sa tagpalanggà kanak tagtuman hu tigtudlù ku. Palanggaen haena hu Amay ku ta siak daw sa Amay ku diyà kay en tagtimà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ba saena ha kenà a kandin palanggà harì gayed tagtuman hu tigtudlù ku. Sa lalang ku ha napaliman nuy hurà dini dà kapuun ta henà-henà ku ba duun napuun hu Amay ku ha iyan migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tag-ikagiyen ku haini iman ta dini a pa ta inyu. ");
INSERT INTO bkd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ba sa Balaan ha Ispiritu ha iyan Magbubulig ha ipadini hu Amay ku ta inyu hu pagpasuhì kanak iyan magtudlù inyu hu alan daw ipahenà-henà din daan inyu sa alan ha mga lalang ku. ");
INSERT INTO bkd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Igbilin ku sa kalinaw duun hu henà-henà nuy, sa kalinaw ha dini ta kanak iyan igbilin ku inyu. Sa mga etaw ha harì agtuu kanak hurà dan kalinaw ha iling taena. Aman harì kaw masamuk daw harì kaw en mahaldek. ");
INSERT INTO bkd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Napaliman nuy sa inikagi ku ha ag-awaan ku inyu ba aglikù a dà dini ta inyu. Ku palanggà a inyu mabayà-bayà kaw gayed ta ag-ulì a duun hu Amay ku ha iyan labaw dì kanak. ");
INSERT INTO bkd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Daan kud en haena inikagi ta daw ku matuman en asem makatuu kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iyan dà haena ag-ikagiyen ku inyu ta madani en pakauma si Satanas sa tagharì hu mga etaw ha harì agtuu kanak. Labaw a dì kandin ");
INSERT INTO bkd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ba kinahanglan ha matun-an hu kaet-etawan ha palanggà ku sa Dios ha Amay ku daw buhaten ku sa alan ha insugù din kanak. Diyà kuy en. ");
INSERT INTO bkd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Iyan a puun hu pamulahen daw sa Dios ha Amay ku iyan tag-alima duun. ");
INSERT INTO bkd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Sa mga panga ha harì mamunga awaen din, ba sa mga panga ha agpamunga limpyuwan din ta daw mamunga hu madakel. ");
INSERT INTO bkd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Limpyu kaw en tumenged hu mga lalang ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ku harì kaw sumuway kanak harì a daan sumuway inyu. Hurà gayed panga ha makapamunga ku maawà duun hu puun din. Iling daan inyu harì kaw mamunga ku maawà kaw dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iyan a puun hu pamulahen daw iyan kaw daan mga panga. Saena ha harì umawà dini ta kanak daw harì ku daan awaan mamunga hu madakel, ba sa sumuway kanak hurà din en gayed mahimu. ");
INSERT INTO bkd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Bisan sin-u sa sumuway kanak agkailing hu panga ha inlambeg ha ku mangagangu en amul-amulen daw iagbul duun hu hapuy. ");
INSERT INTO bkd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ku harì kaw sumuway kanak daw magpabilin kaw duun hu mga lalang ku sa bisan inu ha agpanayuen nuy ig-ila ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ku mamunga kaw hu madakel madayè gayed sa Dios ha Amay ku daw iyan makapamatuud ha sumusunud kaw kanak. ");
INSERT INTO bkd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Sa pagpalanggà ku inyu agkailing hu pagpalanggà kanak hu Amay ku. Magpabilin kaw duun hu pagpalanggà ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ku tumanen nuy sa mga sugù ku inyu harì kaw maawà duun hu pagpalanggà ku inyu. Iling hu pagtuman ku hu insugù kanak hu Dios ha Amay ku ha hurà a daan kaawà duun hu pagpalanggà din kanak. ");
INSERT INTO bkd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Inikagi ku haini inyu ta daw sa kalipay ku makadiyan ta inyu daw malipayen kaw daan gayed. ");
INSERT INTO bkd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Iyan haini sugù ku inyu sa kinahanglan ha magpinalanggaay kaw iling hu pagpalanggà ku inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ku amin etaw ha tagpakamatay para hu amigu din iyan haena timaan ha adagi tungkay sa pagpalanggà din duun. Hurà en gayed pagpalanggà ha labaw pa taena. ");
INSERT INTO bkd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ku buhaten nuy sa mga insugù ku inyu iyan kaw gayed mga amigu ku. ");
INSERT INTO bkd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Harì ku inyu tagngaranan ha mga suluguen ta sa suluguen harì din agkatun-an ku inu sa tagbuhaten hu agalen din. Ba tagngaranan ku inyu ha mga amigu ku ta sa alan ha inikagi kanak hu Amay ku impadayag ku daan diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kenà kaw iyan migpilì kanak ba iyan a migpilì inyu ta daw mamunga kaw hu madakel daw sa bunga nuy harì maamin. Bisan inu sa panayuen nuy duun hu Dios ha Amay ku pinaagi kanak saena ig-ila din inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iyan haini igsugù ku inyu sa kinahanglan ha magpinalanggaay kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ku kuntrahen kaw hu mga etaw ha harì agtuu kanak henhenaen nuy ha iyan a kandan inuna kinuntra. ");
INSERT INTO bkd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ku duma kaw pa ngaay kandan harì kaw kandan kuntrahen. Ba kenà kaw kandan mga duma ta pinilì ku inyu aman agkuntrahen kaw gayed kandan. ");
INSERT INTO bkd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Timan-i nuy sa inikagi kud en inyu ha sa suluguen kenà labaw dì hu agalen. Ku pinasipalahan a kandan pasipalahan kaw daan kandan. Ku tinuman dan sa intudlù ku kandan tumanen dan daan sa inyu. ");
INSERT INTO bkd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pasipalahan kaw gayed kandan tumenged ta mga etaw ku inyu daw hurà dan kakilala sa Amay ku ha migsugù kanak. ");
INSERT INTO bkd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ku hurà a ngaay makadini ta kalibutan daw makagtudlù kandan harì ngaay sidan mag-isip ha mga makasasalà sidan, ba iman hurà dan en balibalan. ");
INSERT INTO bkd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bisan sin-u sa agkuntra kanak agkuntrahen din daan sa Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Harì ngaay sidan mag-isip ha mga makasasalà sidan ku hurà dan pa kaahà sa mga binuhat ku ha belenganen ha hurà kahimu hu bisan sin-u. Ba bisan ku naahà dan en haena kinuntra a gihapun kandan daw sa Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba iyan haena katumanan hu insulat duun hu Kasuguan dan ha tagyanaen ‘Bisan ku hurà dan gayed katarengan ha igkuntraha dan kanak ba kinuntra a gihapun kandan.’ ");
INSERT INTO bkd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Agsuguen ku dini ta inyu sa Magbubulig ha duun agkapuun hu Amay ku ha iyan sa Balaan ha Ispiritu. Saena magpadayag daan hu kamatuuran mahitenged hu Dios ha Amay ku daw manistigus daan mahitenged kanak. ");
INSERT INTO bkd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Daw sinyu makapanistigus kaw en daan mahitenged kanak ta sugud dà su anay migduma-duma kuy en. ");
INSERT INTO bkd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Inikagi ku haena diyan ta inyu ta daw harì kaw makaendà hu pagtuu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta awaen asem sa katenged nuy hu pagseled duun hu mga simbahan daw makauma daan sa panahun ha abi hu maghimatay inyu ha malipay sa Dios taena. ");
INSERT INTO bkd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Agbuhaten dan haena ta siak daw sa Amay ku hurà dan kakilala. ");
INSERT INTO bkd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aman daan kud en inyu ag-ikagiyan ta daw ku makauma asem sa panahun ha buhaten dan haena mahenhenaan nuy en sa inikagi ku iman inyu. Su anay ha bag-u kuy pa makagduma-duma hurà ku haena ikagiya inyu ta diyan a paman ta inyu. ");
INSERT INTO bkd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Iman ag-ulì ad en duun hu Amay ku ha migsugù kanak ba hurà en inyu tagpanginginsà ku hindu a agpayanaen. ");
INSERT INTO bkd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Agkasamuk kaw gayed iman tumenged hu inikagi ku inyu, ");
INSERT INTO bkd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ba laus gayed sa ag-ikagiyen ku inyu ha sa pag-awà ku dini makapaayad inyu. Ta ku harì a umawà dini harì dumini ta inyu sa Magbubulig, ba ku umawà a suguen ku haena diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ku makauma haena dini ipasabut din duun hu kaet-etawan ha mga makasasalà sidan daw ipadayag din sa paagi ha mahimu sidan ha matareng daw igtudlù din daan ha sa mga makasasalà agsilutan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Igpasabut din ha makasasalà sidan ta harì sidan agtuu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Igpadayag din sa paagi ha mahimu sidan ha matareng ta siak ag-ulì ad en duun hu Amay ku daw harì ad inyu maahà. ");
INSERT INTO bkd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Igtudlù din ha sa mga makasasalà silutan gayed hu Dios ta si Satanas sa tagharì hu harì agtuu kanak pighukuman en hu silut. ");
INSERT INTO bkd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Madakel pa ngaay sa ag-ikagiyen ku inyu ba iman harì nuy pa haena maantus. ");
INSERT INTO bkd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ba ku makauma en sa Balaan ha Ispiritu ha iyan magpadayag hu kamatuuran itudlù din sa kamatuuran inyu. Sa ag-ikagiyen din kenà kandin dà ha henà-henà ba iyan dà sa napaliman din duun hu Dios, daw ag-ikagiyen din daan inyu sa maul-ulahan ku malugay. ");
INSERT INTO bkd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Dayeen a kandin ta igpadayag din inyu sa mga intudlù ku. ");
INSERT INTO bkd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inikagi ku ha igpadayag din inyu sa mga intudlù ku ta sa tag-ikagiyen hu Amay ku iyan daan tag-ikagiyen ku. ");
INSERT INTO bkd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Harì en malugay harì ad en inyu maahà daw harì en daan malugay maahà a dà inyu.” ");
INSERT INTO bkd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Sa duma ha mga tinun-an hi Jesus migpainsaay hu “Inu gid sa kahulugan taena ha inikagi din ha harì en malugay harì taw en maahà ba harì en daan malugay maahà taw dà? Daw inu gid daan sa kahulugan hu tag-ikagiyen din ha ag-ulì duun hu Amay din?” ");
INSERT INTO bkd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sigi dà sidan tagpainsaay hu “Inu gid sa kahulugan hu inikagi din ha ‘harì en malugay’? Harì taw gayed agkasabut sa tag-ikagiyen din.” ");
INSERT INTO bkd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Natun-an hi Jesus ha amin dan ngaay ig-insà kandin aman inikagiyan din sidan hu “Tagpainsaay kaw ku inu sa kahulugan taena ha inikagi ku ha ‘harì en malugay harì ad en inyu maahà ba harì en daan malugay maahà a dà inyu.’ ");
INSERT INTO bkd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Laus gayed sa ag-ikagiyen ku ha sa mga etaw ha harì agtuu kanak malipay hu maul-ulahan ku ba sinyu maglugul kaw. Ba saena ha kalugul nuy mailisan dà hu adagi ha kalipay. ");
INSERT INTO bkd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ku tagbatà sa bahi tag-antus hu kasakit, ba ku pakabatà en agkalipatan din dà sa masakit tumenged hu kalipay din taena ha batà. ");
INSERT INTO bkd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iling daan taena ha ku harì ad en inyu maahà maglugul kaw gayed, ba ku isab kuy makag-ahaay adagi gayed sa kalipay nuy daw saena harì gayed maagaw diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Duun asem taena ha panahun kenà en kinahanglan ha dini kaw pa ta kanak panayù hu bisan inu. Laus gayed sa tag-ikagiyen ku ha bisan inu sa panayuen nuy duun hu Dios ha Amay ku pinaagi kanak ig-ila din gayed inyu. ");
INSERT INTO bkd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hurà kaw pa makapanayù pinaagi kanak, ba iman manayù kaw en ta ilahan kaw kandin daw malipayen kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Sa pagtudlù ku inyu iman pinaagi dà hu mga pananglitan, ba makauma sa panahun ha harì ad en gumamit hu mga pananglitan ta mapayag en sa pag-ikagi ku mahitenged hu Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Duun asem taena ha panahun iyan kaw en manayù duun hu Amay ku pinaagi kanak. Kenà en kinahanglan ha iyan a pa ");
INSERT INTO bkd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ta palanggà kaw daan kandin tumenged ta palanggà a inyu daw tuminuu kaw ha diyà a napuun ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Duminini a ta kalibutan ba duun a napuun hu Dios ha Amay ku. Iman ag-awaan ku haini sa kalibutan ta ag-ulì a duun hu Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Minikagi sa mga tinun-an din ha “Tungkay gayed mapayag sa pag-ikagi nu iman ta kenà en mga pananglitan. ");
INSERT INTO bkd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Natun-an day en iman ha natun-an nud sa alan daw hurà en kinahanglan ha amin pa manginginsà ikaw ta daan nud natun-an sa mga ig-insà day ngaay. Aman agtuuwan day en ha duun ka gayed napuun hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ba si Jesus tuminubag hu “Agtuu kaw ba gayed? ");
INSERT INTO bkd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Madani en sa panahun ha makagsusuwayà kaw ta ag-awaan a inyu daw kada sabuwa inyu umulì duun hu kandin ha balay. Bisan pa taena amin ku gihapun duma ha iyan sa Dios ha Amay ku. ");
INSERT INTO bkd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Inikagi ku haena inyu ta daw malinawen sa henà-henà nuy pinaagi hu pagkasabuwa taw. Dini ta kalibutan madakel gayed sa kasamukan nuy ba pandayai sa gahinawa nuy ta nadaeg kud en sa alan ha amin din gahem dini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Su makapenga mikagi si Jesus huminangad haena diyà ta langit daw mig-ampù ha tagyanaen “Amay ku, iyan en haini su natugun ha panahun. Dayeen a sa Batà nu ta daw madayè ku daan ikaw ");
INSERT INTO bkd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ta in-ila nud en kanak sa kagahem ha mailahan ku hu kinabuhì ha hurà din katapusan sa kaet-etawan ha in-ila nu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iyan haini paagi ha madawat dan sa kinabuhì ha hurà din katapusan, sa pagkilala dan ikaw sa laus daw sabubuwa dà ha Dios daw sa pagkilala dan daan kanak ha iyan a si Jesu Cristo sa sinugù nu. ");
INSERT INTO bkd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Dini ta kalibutan dinayè ku ikaw ta napengahan kud sa impabuhat nu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Iman, Amay ku, ilikù dini ta kanak sa pagkagamhanan ku su diyan a pa ta ikaw su hurà pa daan tanghagaa sa kalibutan. ");
INSERT INTO bkd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Saena ha mga etaw ha in-ila nu kanak dini ta kalibutan impakilala kud kandan ku sin-u ka. Daan en sidan ikaw ha mga etaw ba in-ila nu sidan kanak daw tinuman dan en sa lalang nu. ");
INSERT INTO bkd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Iman natun-an dan en ha sa binuhat ku diyan gayed napuun ta ikaw ");
INSERT INTO bkd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ta intudlù kud en kandan sa insugù nu kanak daw dinawat dan en haena. Nasiguru dan ha diyan a gayed napuun ta ikaw daw tuminuu sidan ha sinugù a ikaw. ");
INSERT INTO bkd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Aman tig-ampù ku sidan. Kenà ku iyan tig-ampù sa etaw ha harì agtuu ba iyan sa mga etaw ha in-ila nu kanak ta ikaw en sidan. ");
INSERT INTO bkd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Sa kanak ha mga etaw alan en ikaw daw sa ikaw kanak en daan, daw pinaagi kandan agkadayè a. ");
INSERT INTO bkd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iman ag-awà ad dini ta kalibutan daw ag-ulì ad en diyan ta ikaw, ba sa mga etaw ta dini pa ta kalibutan. Balaan ha Amay ku, pinaagi hu ngaran nu bantayi nu haena sa in-ila nu kanak ha mga etaw ta daw masabuwa sidan iling hu pagkasabuwa ta. ");
INSERT INTO bkd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Su duma a pa kandan pigbantayan ku sidan pinaagi hu gahem ha in-ila nu kanak. Hurà malaag kandan ba iyan dà sa intagnà en ha maglimbung kanak ta daw matuman sa insulat ha lalang nu. ");
INSERT INTO bkd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Laus ad ag-ulì diyan ta ikaw ba ig-ampù ku sidan iman ha dini a pa ta kalibutan ta daw sa kalipay dan mailing hu kanak ha kalipay. ");
INSERT INTO bkd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Saena ha lalang nu intudlù kud en kandan. Ba tagkuntrahen sidan hu mga etaw ha harì agtuu kanak ta sa migtuu kanak kenà en sakup ta kalibutan iling ha kenà a daan sakup ta kalibutan. ");
INSERT INTO bkd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kenà ku iyan tig-ampù ha awaen nu sidan dini ta kalibutan ba iyan ku tig-ampù ha bantayan nu sidan ta daw harì madaeg hi Satanas. ");
INSERT INTO bkd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kenà en sidan sakup ta kalibutan iling ha kenà a daan sakup ta kalibutan. ");
INSERT INTO bkd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Buhata nu sidan ha mahimpit pinaagi hu pagpakatuen dan hu kamatuuran ha iyan sa lalang nu. ");
INSERT INTO bkd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Iling ha sinugù a ikaw dini ta kalibutan agsuguen ku daan sidan hu pagsangyaw hu lalang nu duun hu alan ha kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tumenged kandan ighalad ku ikaw sa kaugalingen ku ta daw sa kaugalingen dan ihalad dan daan ikaw. ");
INSERT INTO bkd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kenà ku iyan dà tig-ampù diyan ta ikaw sa mga etaw ha nakatuu en kanak ba alan en daan sa tumuu kanak asem ku malugay pinaagi hu pagpanunultul mahitenged kanak. ");
INSERT INTO bkd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Amay ku, tig-ampù ku haena ta daw masabuwa dà sidan iling ha nasabuwa ki daan. Masabuwa sidan dini ta kanit ta daw makatuu sa kaet-etawan ha sinugù a gayed ikaw. ");
INSERT INTO bkd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Sa gahem ha in-ila nu kanak ig-ila ku daan diyà ta kandan ta daw masabuwa sidan iling hu pagkasabuwa ta. ");
INSERT INTO bkd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Sidan daw siak sabuwa kay dà ta siak daw sikaw sabuwa ki dà daan. Magsabuwa sidan ta daw matun-an hu kaet-etawan ha sinugù a gayed ikaw daw palanggà nu daan sidan iling hu pagpalanggà nu kanak. ");
INSERT INTO bkd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amay ku, sa mga etaw ha in-ila nu kanak agkabayaan ku daan ha makaamul sidan duun hu tagtimaan ku daw maahà dan sa pagkagamhanan ha in-ila nu kanak tumenged ta pinalanggà a ikaw bisan su hurà pa tanghagaa sa kalibutan. ");
INSERT INTO bkd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Matareng ha Amay ku, saena ha harì agtuu kanak hurà dan kakilala ku sin-u ka, ba siak nakilala kud en ikaw daw natun-an hu mga etaw ta ha sinugù a ikaw dini. ");
INSERT INTO bkd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impakilala kud ikaw diyà ta kandan daw agdayunen ku pa haena ta daw sa pagpalanggà nu kanak iyan daan pagpinalanggaay dan daw sabuwa a daan kandan.” ");
INSERT INTO bkd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Su makapenga si Jesus mag-ampù uminawà diyà duma hu mga tinun-an din daw lapas sidan duun hu Sapà ta Kidron. Diyà ta layun amin pinamulahan hu mga kayu ha olibo dayun duminiyà sidan. ");
INSERT INTO bkd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Si Judas ha iyan maglimbung ki Jesus natulen din en haena ta mahies sidan mag-amul-amul duun. ");
INSERT INTO bkd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aman inuwit hi Judas diyà sa mga sundalu daw sa mga bantay hu Timplo ha sinugù hu labaw ha mga sinaligan hu paghalad daw hu mga Fariseo ha tag-uuwit hu mga sulù daw hinagiban. ");
INSERT INTO bkd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ba natun-an en hi Jesus sa maul-ulahan din aman tinalagbù din sidan daw insai hu “Sin-u sa tagpan-ahaen nuy?” ");
INSERT INTO bkd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tuminubag sidan hu “Iyan si Jesus ha taga-Nazaret.” Inikagiyan sidan hi Jesus hu “Iyan ad en su tagpan-ahaen nuy.” Si Judas ha iyan taglimbung kandin duma en daan kandan. ");
INSERT INTO bkd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Su maikagi hi Jesus ha “Iyan ad en” nangakaundud daw nangabantang su agdakep kandin. ");
INSERT INTO bkd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aman inisaban sidan ininsaan hi Jesus hu “Sin-u man diay sa tagpan-ahaen nuy?” Tuminubag gihapun sidan hu “Iyan labi si Jesus ha taga-Nazaret.” ");
INSERT INTO bkd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Minikagi si Jesus hu “Inikagiyan kud inyu ha iyan ad en. Ku iyan ad tagpan-ahaen nuy harì nuy ilagkes sa mga duma ku.” ");
INSERT INTO bkd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Inikagi din haena ta daw matuman sa in-ampù din ha hurà bisan sabuwa ha malaag duun hu mga etaw ha in-ila kandin hu Dios ha Amay din. ");
INSERT INTO bkd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dayun si Simon Pedro duminagtù hu ispada din daw tigbasa sa suluguen hu tungkay labaw ha sinaligan hu paghalad, aman nalapung sa kawanan ha talinga ku suluguen ha tagngaranan ki Malco. ");
INSERT INTO bkd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ba inikagiyan hi Jesus si Pedro hu “Isakeb hayan sa ispada nu ta kinahanglan ha dawaten ku sa igpaantus kanak hu Amay ku.” ");
INSERT INTO bkd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dinakep si Jesus hu mga sundalu duma hu kapitan daw mga bantay. Binakus dan ");
INSERT INTO bkd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","daw uwita diyà ki Anas ha ugang hi Caifas sa tungkay labaw ha sinaligan hu paghalad duun taena ha tuiga. ");
INSERT INTO bkd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Caifas iyan mig-ikagi su anay duun hu mga punuan hu mga Judio ha maayad pa ha sabuwa dà sa matay para hu alan. ");
INSERT INTO bkd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro daw sa duma din ha tinun-an luminupug ki Jesus. Tumenged ta sa duma din nakilala hu tungkay labaw ha sinaligan hu paghalad nakaduma haena ki Jesus duun ku balay hu tungkay labaw ha sinaligan hu paghalad. ");
INSERT INTO bkd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ba si Pedro diyà dà nataman ta pultahan. Su tinun-an ha nakilala hu tungkay labaw ha sinaligan hu paghalad nakiglalang duun ku bahi ha tagbantay diyà ta pultahan dayun impaseled din daan si Pedro. ");
INSERT INTO bkd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Su bahi nanginginsà diyà ki Pedro hu “Tinun-an ka ba daan tayana ha etaw?” Ba si Pedro tuminubag hu “Kenà a.” ");
INSERT INTO bkd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tungkay matinù duun taena ha panahun aman sa mga suluguen daw sa mga bantay hu Timplo migtim-un daw pamanhidadang sidan. Uminamul si Pedro kandan ta aghidadang daan. ");
INSERT INTO bkd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Duun taena ha balay binistiga si Jesus hu nauna ha tungkay labaw ha sinaligan hu paghalad mahitenged hu mga tinun-an din daw hu katudluanan din. ");
INSERT INTO bkd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tuminubag si Jesus hu “Impapaliman ku hu kaet-etawan sa katudluanan ku ta duun a man ganì migtudlù hu mga simbahan daw hu Timplo ha duun daan tagkaamul-amul sa kaet-etawan aman hurà gayed nakaheles ha mga lalang ku. ");
INSERT INTO bkd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Imbà a inyu tagbistigaha? Iyan nuy ngaay insaan sa nakapaliman kanak ta natun-an dan sa mga intudlù ku.” ");
INSERT INTO bkd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Su maikagi haena hi Jesus sagunà linaparu hu sabuwa ha bantay daw ikagiyi hu “Imbà ka tagtubag-tubag hu iling tayan duun hu tungkay labaw ha sinaligan hu paghalad?” ");
INSERT INTO bkd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ba tuminubag si Jesus ha “Ku nasayep man ugaling sa inikagi ku ikagiyi sa mga etaw dini ku inu sa nasayep duun. Ba ku hurà imbà a man ikaw laparuwa?” ");
INSERT INTO bkd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dayun si Jesus sa binakus en impauwit hi Anas diyà ki Caifas ha iyan tungkay labaw ha sinaligan hu paghalad duun taena ha tuiga. ");
INSERT INTO bkd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Su taghidadang pa si Simon Pedro diyà ta guwà ininsaan hu mga etaw hu “Tinun-an kad ba daan tayana ha etaw?” Ba si Pedro miglimud hu “Kenà a man.” ");
INSERT INTO bkd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Amin suluguen hu tungkay labaw ha sinaligan hu paghalad daw suled taena ha tinigbas hi Pedro ha minikagi diyà ki Pedro hu “Bà su naahà ku gan ikaw duun hu pigdakepan taena ha etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ba miglimud en paman si Pedro dayun tuminagauk sa manuk. ");
INSERT INTO bkd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Su maselem pa si Jesus inuwit en ku mga punuan hu Judio duun ku balay hu gubernador sa napuun ta balay hi Caifas. Ba sa mga punuan diyà dà nataman ta guwà taena ha balay ta daw harì dan malapas sa tulumanen hu mga Judio hu pagsaulug taena ha Aldaw hu Paglabay. ");
INSERT INTO bkd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tumenged taena guminuwà si Pilato daw insai sidan hu “Inu man sa salà taini ha igsumbung nuy?” ");
INSERT INTO bkd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tuminubag sidan hu “Masinupaken haini ha etaw aman igpaatubang day ikaw.” ");
INSERT INTO bkd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Saena ha mga punuan hu Judio bà dà inikagiyi hi Pilato ha “Uwita nuy dà diyan daw iyan kaw en maghukum kandin sumalà hu inyu ha Kasuguan.” Ba tuminubag sidan ha “Hurà itugut kanay ha hukuman day sa etaw hu kamatayen.” ");
INSERT INTO bkd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nahitabù haena ta daw matuman sa inikagi su anay hi Jesus ku agkainu-inu sa kamatayen din. ");
INSERT INTO bkd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sumineled si Pilato diyà ta balay din daw ipaatubang kandin si Jesus dayun ininsaan din hu “Iyan ka ba Harì hu mga Judio?” ");
INSERT INTO bkd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Si Jesus tuminubag hu “Sayan ha inikagi nu ikaw en ba ha henà-henà daw ku tinultulan ka ba hu mga etaw mahitenged kanak?” ");
INSERT INTO bkd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Minikagi si Pilato ha “Judio a ba daan? Iyan sa mga duma nu ha Judio daw sa mga labaw ha sinaligan hu paghalad migtugyan ikaw dini ta kanak. Inu man sa salà nu?” ");
INSERT INTO bkd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tuminubag si Jesus hu “Sa pagkaharì ku kenà dini ta kalibutan. Ku harì a pa ngaay dini suminukul en gan sa mga suluguen ku ta daw harì a madakep taini ha mga Judio. Ba sa pagkaharì ku kenà dini dà ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Minikagi si Pilato ha “Ku iyan hayan harì ka gayed diay.” Si Jesus tuminubag hu “Laus sa inikagi nu ta siak Harì a gayed. Iyan hayana indini ku ta kalibutan ha migpakaetaw a ta daw matun-an hu kaet-etawan sa kamatuuran. Bisan sin-u sa agkabayà ha makatuen hu kamatuuran tagpaliliman kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ba minikagi si Pilato hu “Inu en paman hayana ha kamatuuran?” Dayun sagunà guminuwà si Pilato daw inikagiyan din sa mga Judio ha “Hurà ku naahà ha salà din ha angayan ha hukuman. ");
INSERT INTO bkd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ba sumalà hu inyu ha naanadan ku agsaulugen sa Aldaw hu Paglabay amin purisu ha aglibriyen ku. Agkabayaan nuy ba ha ipaguwà ku haini sa Harì hu mga Judio?” ");
INSERT INTO bkd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ba tuminubag sidan hu madaging hu “Harì day hayana agkabayaan ba sa ipaguwà nu iyan si Barabas.” Si Barabas sabuwa ha tulisan. ");
INSERT INTO bkd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Insugù hi Pilato ha lagkutan si Jesus ");
INSERT INTO bkd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","daw tuminimù sa mga sundalu hu gawed ha dugiyen dayun binangkulà haena daw isuup diyà ta ulu din. Pininaksuyan dan daan si Jesus hu maligà ha manggad ");
INSERT INTO bkd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","daw sigi dan inubayi daw ikagiyi hu “Mabuhì sa Harì hu mga Judio” dayun pigsumbag dan. ");
INSERT INTO bkd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Minisab guminuwà si Pilato daw ikagiyi sa mga Judio hu “Ahaa nuy, igpaatubang ku inyu haini sa etaw ta daw matun-an nuy ha hurà ku naahà ha salà din.” ");
INSERT INTO bkd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Su gumuwà si Jesus ha nasuupan en sa ulu din hu dugi daw pininaksuyan en daan hu maligà ha manggad minikagi si Pilato diyà ta kandan hu “Taini dà su etaw.” ");
INSERT INTO bkd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Su maahà si Jesus hu mga labaw ha sinaligan hu paghalad daw hu mga bantay taena ha Timplo namangulahì sidan hu “Ilansang hayan duun hu krus.” Ba inikagiyan sidan hi Pilato hu “Iyan kaw en maglansang kandin ta hurà ku naahà ha salà din.” ");
INSERT INTO bkd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Saena ha mga etaw minikagi ha “Sumalà hu kanay ha Kasuguan kinahanglan ha himatayan hayana ta tag-ikagiyà ha Batà kun hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Su mapaliman haena hi Pilato tungkay gayed nahaldek ");
INSERT INTO bkd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","aman sumineled diyà ta balay din. Dayun ininsaan din si Jesus hu “Hindu ka man diay napuun?” Ba hurà en tubag si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Inikagiyan haena hi Pilato hu “Imbà ka harì tagtubag kanak? Hurà nu ba diay katun-i ha amin ku kagahem hu paglibri ikaw daw hu pagpalansang ikaw duun hu krus?” ");
INSERT INTO bkd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tuminubag si Jesus ha “Hurà nu kagahem mahitenged kanak ku hurà ka pa ilahi hu Dios taena. Aman sa etaw ha mig-uwit kanak dini ta ikaw adagi gayed sa kandin ha salà dì hu ikaw.” ");
INSERT INTO bkd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Sugud taena agkabayaan en ngaay hi Pilato aglibriya si Jesus. Ba sa mga Judio dayun dà tagkulahiay ha “Ku libriyen nu hayana kenà kad en amigu hi Cesar sa Harì ta Roma, ta bisan sin-u sa iling tayan ha tagpaharì-harì agpakasupak ki Cesar.” ");
INSERT INTO bkd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Su mapaliman haena hi Pilato inuwit din si Jesus duun hu lugar ha tagngaranan hu Sinaegan hu Batu ha duun hu Hebreo ha inikagiyan saena Gabata. Dayun mininuu si Pilato duun taena ha pinun-ayà hu maghuhukum. ");
INSERT INTO bkd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Duun taena agkaugtu en sa aldaw. Tagpangandam en sidan ta ku maisab ha aldaw human en agsaulugen sa Aldaw hu Paglabay. Minikagi si Pilato hu “Taini en sa Harì nuy.” ");
INSERT INTO bkd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ba sa kaet-etawan namangulahì hu “Pahimatayi hayana. Ilansang en duun hu krus.” Minikagi si Pilato hu “Imbà nuy igpalansang duun hu krus sa Harì nuy?” Tuminubag sa mga labaw ha sinaligan hu paghalad hu “Iyan dà Harì day si Cesar.” ");
INSERT INTO bkd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dayun intugyan hi Pilato si Jesus diyà ta kandan ta daw makalansang dan duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tinimù hu mga sundalu si Jesus daw ipaguwà diyà ta banuwa ha tagtiang hu krus ha aglansangan kandin duun hu lugar ha tagngaranan hu Tul-an hu Ulu hu Etaw ha duun hu Hebreo ha inikagiyan saena Golgota. ");
INSERT INTO bkd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Duun taena inlansang dan si Jesus duun hu krus daw amin pa daan daruwa ha inlansang dan duma kandin, sa sabuwa diyà ta gibang din daw sa sabuwa diyà ta kawanan din. ");
INSERT INTO bkd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Sa sampaw ta ulu hi Jesus pinasulatan hi Pilato hu “Si Jesus ha taga-Nazaret sa Harì hu mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sa piglansangan ki Jesus ubay dà diyà ta Jerusalem aman madakel ha mga Judio sa nakabasa duun. Saena insulat duun hu tatulu ha inikagiyan ha iyan sa Hebreo, sa Latin daw sa Griego. ");
INSERT INTO bkd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Minikagi sa mga labaw ha sinaligan hu paghalad diyà ki Pilato hu “Harì nu hayan iyan isulat sa ‘Harì hu mga Judio’ ba iyan nu sa ‘Inikagi taini ha iyan Harì hu mga Judio.’” ");
INSERT INTO bkd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ba si Pilato tuminubag hu “Sa insulat ku iyan en daw harì en gayed mailisan.” ");
INSERT INTO bkd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Su makalansang en si Jesus tinimù hu mga sundalu sa pinaksuy din daw bahina hu haepat. Tinimù dan daan su pinaksuy din ha hurà duun tinahian ");
INSERT INTO bkd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","dayun naman-ikagi sidan hu “Harì taw haini yahà-yahaen ba magripa kuy ta daw matun-an taw ku sin-u kanuy sa makatimù duun.” Nabuhat dan haena ta daw matuman sa insulat ha lalang hu Dios ha tagyanaen “Sinaad-saad dan sa pinaksuy ku daw pigripahan dan sa duma duun.” Aman iyan haena binuhat ku mga sundalu. ");
INSERT INTO bkd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Duun hu ubay ku krus ha piglansangan ki Jesus diyà tagtiyadeg si Inay din daw sa suled hi Inay din, si Maria ha asawa hi Clopas daw si Maria Magdalena. ");
INSERT INTO bkd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Su maahà hi Jesus si Inay din daw su tinun-an ha palanggà din inikagiyan din si Inay din hu “Inay, iyan en hayana batà nu.” ");
INSERT INTO bkd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Daw inikagiyan din daan haena sa tinun-an hu “Iyan en hayana inay nu.” Sugud taena migtimà sa inay hi Jesus duun ku balay taena ha palanggà din ha tinun-an. ");
INSERT INTO bkd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Su malugay-lugay natun-an hi Jesus ha napengahan din en sa alan ha igpabuhat kandin hu Dios, aman uminikagi hu “Agkalauwan a” ta daw matuman sa insulat ha lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Amin garapun diyà ha tinaguan hu sukà. Aman sa mga sundalu tuminimù hu manggad daw iteleb duun hu sukà dayun imbedbed duun hu panga hu isupo daw isungit ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Su mananam din haena minikagi hu “Napengahan kud sa buluhaten ku.” Nakalengay-lengay haena dayun nabugtù sa gahinawa din. ");
INSERT INTO bkd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Su agkahapun en sa mga punuan hu Judio huminangyù diyà ki Pilato ha pamalien dan en sa mga paa taena ha impanlansang duun hu krus ta daw mangamatay en sidan. Binuhat dan haena ta daw maawà dà su impanlansang duun hu krus ha harì pa mauma sa Aldaw hu Paghimlay ta iyan tungkay mahal. ");
INSERT INTO bkd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aman inelegan ku mga sundalu su impanlansang duma ki Jesus daw pamalia sa mga paa dan. ");
INSERT INTO bkd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ba su makauma sidan diyà ki Jesus naahà dan ha minatay en haena aman hurà dan en pamalia sa mga paa din. ");
INSERT INTO bkd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ba amin sabuwa ha sundalu ha dinughang din hu bangkaw sa kilid hi Jesus, aman sagunà tuminulù duun sa langesa daw sa wahig. ");
INSERT INTO bkd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Siak sa nakaahà taena makapanistigus a ha laus gayed haena. Natun-an ku ha kamatuuran sa tag-ikagiyen ku aman insulat ku haini ta daw makatuu kaw daan. ");
INSERT INTO bkd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nahitabù haena ta daw matuman sa insulat ha lalang hu Dios ha tagyanaen “Hurà bisan sabuwa ha mabalì duun hu mga tul-an din.” ");
INSERT INTO bkd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Daw amin pa daan insulat ha lalang hu Dios ha tagyanaen “Tagtengtengan dan haena sa etaw ha dinughang dan.” ");
INSERT INTO bkd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Amin etaw ha tagngaranan ki Jose ha taga-Arimatea ha duminiyà ki Pilato daw panayua sa lawa hi Jesus. Saena in-ila hi Pilato kandin aman duminuun si Jose hu krus daw timua sa lawa hi Jesus. Si Jose sumusunud hi Jesus ba inheles din sa pagtuu din su anay ta agkahaldek hu mga punuan hu Judio. ");
INSERT INTO bkd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Si Nicodemo sa migpakig-ahà daan ki Jesus duun hu daleman su anay duminuma ki Jose ha tag-uwit hu madakel tungkay ha pahumut ha mira ha inamulan hu aloe. ");
INSERT INTO bkd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Binungkusan ku daruwa sa lawa hi Jesus hu maputì ha manggad daw inapidan dan hu pahumut sumalà hu tulumanen hu mga Judio ku taglebeng. ");
INSERT INTO bkd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Duun hu ubay ku piglansangan ki Jesus amin mga pamulahen ha kayu daw amin daan duun bangbang ha hurà pa gayed kalebengi. ");
INSERT INTO bkd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Saena ha bangbang ubay dà duun hu piglansangan ki Jesus daw agkaana-ana en sidan ta madani en sa pagsaulug, aman duun dan dà inlebeng sa lawa hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Su kaaldawen hu Dominggo si Maria Magdalena duminuun taena ha piglebengan ki Jesus. Ba naahà din ha naawà en su batu ha in-ipel taena ha lebeng. ");
INSERT INTO bkd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aman minulalaguy payanaen diyà ki Simon Pedro daw taena ha pinalanggà hi Jesus ha tinun-an daw inikagiyan din sidan hu “Inawà dan en sa lawa hi Jesus duun hu piglebengan kandin daw hurà day katun-i ku hindu dan en duun in-ugsak.” ");
INSERT INTO bkd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aman uminagpas si Pedro daw saena ha duma din duun ku lebeng. ");
INSERT INTO bkd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Miglumbà sidan sa daruwa ba saena ha duma hi Pedro nauna duun ku lebeng. ");
INSERT INTO bkd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Dayun sinil-ip din su lebeng daw naahà din su maputì ha mga manggad ha nakaugsak duun, ba hurà en seled su tinun-an. ");
INSERT INTO bkd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pagpakauma hi Simon Pedro sa nahudiyan sagunà haena sumineled. Naahà din su maputì ha manggad ha nakaugsak duun ");
INSERT INTO bkd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","daw sa panyù ha imbungkus ta ulu hi Jesus. Saena ha panyù napanday nalupì ha hurà makaamul duun hu duma ha mga manggad. ");
INSERT INTO bkd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dayun sumineled daan haena sa duma hi Pedro ha nauna dì kandin diyà ta lebeng daw naahà din sa alan aman nakatuu ha nabanhaw si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Duun taena ha panahun hurà dan pa gayed kasabut sa insulat ha lalang hu Dios ha tagyanaen ha kinahanglan ha mabanhaw si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dayun naman-ulì su mga tinun-an. ");
INSERT INTO bkd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Diyà ta guwà taena ha lebeng si Maria tag-agalaay. Sinil-ip din daan su lebeng ");
INSERT INTO bkd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","daw naahà din sa daruwa ha balinsuguen hu Dios ha tungkay maputì sa bisti dan. Sa sabuwa diyà tagpinuu hu ulunan taena ha naugsakan hu lawa hi Jesus daw sa sabuwa diyà ta sikwayan din. ");
INSERT INTO bkd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Su mga balinsuguen hu Dios minikagi hu “Imbà ka tag-agalaay?” Tuminubag si Maria hu “Tinimù dan sa lawa hu Ginuu ku daw harì ku agkatun-an ku hindu dan en duun in-ugsak.” ");
INSERT INTO bkd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dayun luminingì si Maria na amin din naahà ha tagtiyadeg diyà ta talikudan din ba hurà din kakilala ha iyan en man diay haena si Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Saena nanginginsà diyà ta kandin hu “Imbà ka tag-agalaay? Sin-u sa tagpan-ahaen nu?” Abi hi Maria ha iyan haena su tag-alima hu mga pamulahen ha kayu aman tinubag din ha “Ku iyan ka migtimù hu lawa hi Jesus ikagiya nu kanak ku hindu nu duun in-ugsak ta agtimuen ku dà.” ");
INSERT INTO bkd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ba minikagi si Jesus diyà ta kandin hu “Maria.” Sagunà nakasinalu si Maria diyà ki Jesus daw ikagiyi hu madaging hu “Raboni” saini inikagiyan ha Hebreo ha tagkahulugan hu Manunudlù. ");
INSERT INTO bkd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ba si Maria inikagiyan hi Jesus ha “Butawani a ikaw ta hurà a pa makaulì duun hu Amay ku. Elegi nu sa mga tinun-an ku daw ikagiyi sidan ha ag-ulì a duun hu Dios ha Amay ku ha iyan Amay nuy daw Magbabayà nuy daan.” ");
INSERT INTO bkd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aman inelegan hi Maria Magdalena su mga tinun-an hi Jesus daw ikagiyi sidan hu “Naahà ku sa Ginuu.” Dayun intultul din sa inikagi hi Jesus diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Su daleman en hu Dominggo nangaamul-amul sa mga tinun-an hi Jesus duun hu sabuwa ha balay ha pigsirahan dan ta agkangahaldek sidan hu mga punuan hu Judio. Migpaahà si Jesus diyà ta taliwarà dan daw ikagiyi sidan hu “Magmalinawen kaw.” ");
INSERT INTO bkd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Su maikagi din haena impaahà din kandan sa alima din daw sa kilid din. Aman tungkay gayed nangalipay sa mga tinun-an din ta naahà dan en sa Ginuu. ");
INSERT INTO bkd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Dayun inikagiyan sidan hi Jesus hu “Magmalinawen kaw en. Iling ha sinugù a hu Dios ha Amay ku agsuguen ku daan inyu hu pagpanunultul mahitenged kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Daw inikagiyan din pa daan sidan hu “Dawata nuy sa Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Bisan sin-u sa pasayluwen nuy pasayluwen daan hu Dios, ba sa harì nuy pasayluwen harì din en daan pasayluwen.” ");
INSERT INTO bkd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sa sabuwa ha tinun-an hi Jesus ha iyan si Tomas sa tagngaranan hu Saleping hurà diyà su magpaahà si Jesus kandan. ");
INSERT INTO bkd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Su matultulan hu mga tinun-an ha duma din ha naahà dan en sa Ginuu minikagi si Tomas hu “Harì a gayed makatuu ha nabanhaw haena ku harì ku matubluk sa alima din ha naagiyan hu lansang daw sa kilid din ha pigdughang.” ");
INSERT INTO bkd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Su nangkasimana en naisab dà nangaamul-amul sa mga tinun-an hi Jesus duun ku balay ha pig-amul-amulan dan su anay daw human en nakatampu kandan si Tomas. Bisan ku nasirahan haena sa balay ba migpaahà si Jesus diyà ta taliwarà dan daw ikagiyi sidan hu “Magmalinawen kaw.” ");
INSERT INTO bkd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dayun inikagiyan din daan si Tomas hu “Ahaa daw tubluka nu sa alima ku daw tubluka nu daan sa kilid ku. Endai nud en sa pagduwa-duwa daw tuu kad en iman kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Dayun nakaikagi si Tomas hu “Ginuu daw Dios ku.” ");
INSERT INTO bkd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ba inikagiyan haena hi Jesus hu “Nakatuu ka gayed ta naahà a ikaw, ba malipayen gayed sa etaw ha tuminuu kanak bisan hurà a kandin kaahà.” ");
INSERT INTO bkd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Madakel pa ha mga belenganen sa naahà hu mga tinun-an hi Jesus ba hurà en isulat duun taini ha libru. ");
INSERT INTO bkd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ba insulat haini ta daw makatuu kaw ha si Jesus iyan su Mesiyas ha Batà hu Dios, daw pinaagi hu pagtuu nuy kandin mailahan kaw gayed hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Su maiwas en haena mig-isab pa gayed migpaahà si Jesus duun hu mga tinun-an din diyà ta Danaw ta Tiberias. Iyan haini naul-ulahan. ");
INSERT INTO bkd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Naamul diyà si Simon Pedro daw si Tomas ha tagngaranan hu Saleping, si Natanael ha taga-Cana ha sakup ta Galilea daw sa daruwa ha batà hi Zebedeo, daw amin pa daan daruwa ha tinun-an hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Si Simon Pedro uminikagi duun hu mga duma din hu “Agpamaling a.” Aman saena ha mga duma din minikagi daan hu “Agduma kay ikaw.” Dayun namanlulan sidan duun hu barutu daw pamaling, ba bisan ku luminam-ag sidan hurà gayed sidan makatimù. ");
INSERT INTO bkd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Su maselem en si Jesus tagtiyadeg diyà ta kilid taena ha danaw ba hurà kakilala hu mga tinun-an din. ");
INSERT INTO bkd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dayun ininsaan sidan hi Jesus hu “Nakatimù kaw ba?” Tuminubag sidan ha “Hurà kay gayed.” ");
INSERT INTO bkd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Sinugù sidan hi Jesus hu “Ilabya dà sa baling nuy diyan ta kawanan dapit ta daw makatimù kaw.” Dayun binuhat dan haena. Ba su butwaen dan su baling harì dan en agkahenat ta madakel tungkay sa nakatagù duun ha sedà. ");
INSERT INTO bkd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Dayun su tinun-an ha pinalanggà hi Jesus minikagi diyà ki Pedro hu “Ay, iyan man diay hayana sa Ginuu taw.” Su mapaliman haena hi Simon Pedro sagunà migpinaksuy ta miglebas haena, dayun uminagbul diyà ta wahig payanaen diyà ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sa mga duma din ha tinun-an ha taglulan duun ku barutu luminupug kandin ha tagguyud en ku baling ha napunù-punù hu sedà. Ubay dà sidan diyà ta kilid, mga nanggatus dà ha mitros sa pig-elangan dan. ");
INSERT INTO bkd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Su makagaun en sidan naahà dan sa supas daw sa baga ha amin en duun sedà ha inanag. ");
INSERT INTO bkd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Inikagiyan sidan hi Jesus ha “Uwita en dini sa natimù nuy ha mga sedà.” ");
INSERT INTO bkd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aman duminuun si Simon Pedro ku barutu daw guyuda su baling ha napunù hu mga adagi ha sedà, sa kadakelen taena 153. Bisan ku madakel tungkay sa sedà ha natimù dan ba hurà gayed kayahà su baling dan. ");
INSERT INTO bkd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dayun inikagiyan sidan hi Jesus hu “Pamangaen kuy en.” Hurà sidan makaamel hu pagpanginginsà kandin ku sin-u ta natun-an dan ha iyan en sa Ginuu. ");
INSERT INTO bkd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tinimù hi Jesus su supas daw su nalutù ha sedà daw saada kandan. ");
INSERT INTO bkd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Saena ikatulu en ha pagpaahà hi Jesus duun hu mga tinun-an din sugud hu pagkabanhaw din. ");
INSERT INTO bkd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Su makapenga en kumaen si Jesus daw sa mga tinun-an din ininsaan din si Simon Pedro hu “Simon ha batà hi Juan, labaw ba sa pagpalanggà nu kanak dì taini ha mga duma nu?” Tuminubag si Pedro hu “Ginuu, natun-an nu ha palanggà ku ikaw.” Aman inikagiyan hi Jesus hu “Alimahi nu sa mga nati ku ha karniro.” ");
INSERT INTO bkd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dayun minisab minikagi si Jesus diyà ta kandin hu “Simon ha batà hi Juan, palanggà a ba ikaw?” Tuminubag si Pedro hu “Hee, Ginuu, natun-an nu ha palanggà ku ikaw.” Aman inikagiyan hi Jesus hu “Alimahi nu sa mga karniro ku.” ");
INSERT INTO bkd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Duun hu ikatulu ininsaan dà paman hi Jesus hu “Simon ha batà hi Juan, palanggà a ba gayed ikaw?” Suminakit sa gahinawa hi Pedro ta katulu en insai ku palanggà din ba si Jesus. Ba tuminubag gihapun hu “Ginuu, natun-an nud sa alan aman natun-an nu ha palanggà ku gayed ikaw.” Dayun inikagiyan hi Jesus si Pedro hu “Alimahi nu sa mga karniro ku. ");
INSERT INTO bkd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Laus gayed sa ag-ikagiyen ku ha su batan-en ka pa pakabaluy kad en tagpinaksuy hu kaugalingen nu daw bisan hindu ka duun agpayanaen agkabaluy nu. Ba ku malaas ka asem makapangindedepa ka daw lain en sa magpinaksuy ikaw daw uwiten ka duun hu agtambagan nu ha lugar.” ");
INSERT INTO bkd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sa pag-ikagi hi Jesus saena mahitenged hu kamatayen hi Pedro ha makadayè hu Dios. Dayun inikagiyan hi Jesus si Pedro ha “Sunud ka kanak hangtud en hu kamatayen nu.” ");
INSERT INTO bkd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Luminingì si Pedro daw naahà din ha taglupug kandan su tinun-an ha palanggà hi Jesus daw iyan abay din su anay duun hu pagpanihapun dan daw iyan daan nanginginsà hu “Ginuu, sin-u kanay sa maglimbung ikaw?” ");
INSERT INTO bkd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aman ininsaan hi Pedro si Jesus hu “Ginuu, inu gid sa maul-ulahan tayana ku malugay?” ");
INSERT INTO bkd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ba si Jesus tuminubag ha “Ku iyan ku pagbayà sa bubuhay pa hayana ku lumikù a dini ta kalibutan hurà nu duun labet. Bà ka dà sunud kanak.” ");
INSERT INTO bkd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tumenged taini ha inikagi hi Jesus nakalekep sa tultul duun hu alan ha mga sumusunud din ha su palanggà din ha tinun-an harì en matay. Ba kenà iyan inikagi hi Jesus ha harì en matay ta iyan inikagi din sa “Ku iyan ku pagbayà ha bubuhay pa hayana ku lumikù a dini ta kalibutan hurà nu duun labet.” ");
INSERT INTO bkd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iyan a su tinun-an ha tagsubayen hi Jesus daw iyan a daan migsulat taini. Natun-an day ha laus gayed haini ta naahà day gayed. ");
INSERT INTO bkd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Madakel pa sa binuhat hi Jesus na ku iamin haena isulat harì maaul dini ta kalibutan sa mga libru ha masulatan duun.");
INSERT INTO bkd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Suled ku ha Teofilo, duun hu nauna ha balasahen insulat ku sa alan ha binuhat daw intudlù hi Jesus ");
INSERT INTO bkd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","payanaen en hu pagligtu din diyà ta langit. Seled hu kapatan ha aldaw hu pagkabanhaw din madakel sa mga paagi ha impaahà din duun hu mga apostoles ha nabanhaw gayed daw tinudluan din daan sidan mahitenged hu pagharì hu Dios. Su hurà pa haena ligtu diyà ta langit, pinaagi hu Balaan ha Ispiritu tinudluan din su mga pinilì din ha mga apostoles hu igpabuhat din kandan. ");
INSERT INTO bkd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Amin aldaw ha naamul sa mga apostoles duma ki Jesus aman inikagiyan din sidan hu “Magtimà kaw pa enà dini ta Jerusalem daw angatan nuy sa insaad hu Dios ha Amay taw ha inikagi ku inyu su anay. ");
INSERT INTO bkd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Duun hu panahun hi Juan diyà haena agpamautismu ta wahig ba harì malugay sa igbautismu inyu iyan sa paulinan kaw hu Balaan ha Ispiritu.” ");
INSERT INTO bkd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Amin panahun ha naamul en paman sa mga apostoles duma ki Jesus aman ininsaan dan haena hu “Ginuu, iyan en ba haini panahun ha ilikù nu dini ta kanay sa katenged hu pagharì duun taini ha nasud day sikay sa mga kaliwat hi Israel?” ");
INSERT INTO bkd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ba tuminubag si Jesus hu “Harì mabaluy ha matun-an nuy ku kan-u haena katuman ta iyan dà sa Dios ha Amay taw migtugun hu panahun. ");
INSERT INTO bkd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ba gaheman kaw hu Dios ku maulinan kaw en hu Balaan ha Ispiritu daw iyan kaw gayed makapanunultul mahitenged kanak dini ta Jerusalem daw duun hu alan ha banuwa diyà ta Judea daw ta Samaria daw dini ta tibuuk ha kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Su maikagi din en haena sagunà luminigtu diyà ta langit. Su tag-ahaen dan haena tigkan dan nahanaw duun hu gabunan. ");
INSERT INTO bkd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Su kamulu dan pa tagtengtengi tigkan daan nakahitindeg diyà ta ubay dan sa daruwa ha maama ha maputì sa bisti dan ");
INSERT INTO bkd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","daw minikagi hu “Sinyu sa mga taga-Galilea, imbà kaw taghangadà diyà ta langit? Si Jesus ha luminigtu diyà ta langit aglikù dà asem dini ku malugay iling ha naahà nuy iman diyà tayà ha gabunan.” ");
INSERT INTO bkd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Namanlikù sa mga apostoles diyà ta Jerusalem ha napuun ta Buntud ta Olibo na mga nangkakilometro dà sa pig-elangan taena. ");
INSERT INTO bkd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Su makauma sidan diyà namanlatun sidan payanaen duun ku kwarto diyà ta sampaw taena ha balay ha taghulabungan dan. Iyan haena si Pedro daw si Juan, si Santiago daw si Andres, si Felipe daw si Tomas, si Bartolome daw si Mateo, si Santiago ha batà hi Alfeo, si Simon sa Patriyota daw si Judas ha batà hi Santiago. ");
INSERT INTO bkd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sigi sidan tag-amul-amul hu pag-ampù duma hu mga bahi daw hi Maria sa inay hi Jesus daw sa duma pa ha suled hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Amin aldaw ha naamul-amul sa nanggatus daw kaluwaan ha tumutuu. Dayun huminitindeg si Pedro duun hu atubangan dan daw ikagi hu ");
INSERT INTO bkd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mga suled, kinahanglan gayed ha matuman sa insulat ha lalang hu Dios ha inikagi hi David gaun su ulinan hu Balaan ha Ispiritu mahitenged ki Judas sa panulù hu kadakepa ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ta saena duma day su anay ha pinilì ha apostol. ");
INSERT INTO bkd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Amin bugtà ha napalit ku insuhul ki Judas hu paglimbung din ki Jesus. Duun taena ha bugtà nakadaghà sa lawa hi Judas aman migbutu sa getek din daw nakayat sa bituka din. ");
INSERT INTO bkd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Su matun-an haena hu mga etaw diyà ta Jerusalem pigngaranan dan su bugtà hu Akeldama ha tagkahulugan hu Bugtà ha Pigbayaran hu Langesa. ");
INSERT INTO bkd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nakasulat haini duun hu balasahen hu mga Salmo ha tagyanaen ‘Mabuhat haini ha pinakabulung-bulung ha lugar ha hurà en magtimà duun.’ Daw inikagi daan ha ‘Sa katengdanan din iila duun hu lain ha etaw.’ ");
INSERT INTO bkd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Aman kinahanglan ha ilisan si Judas hu etaw ha nakaduma-duma kanuy sugud hu pagpamautismu hi Juan daw payanaen en hu pagligtu hi Jesus ha Ginuu taw diyà ta langit, ta kinahanglan ha makapanunultul daan haini mahitenged hu pagkabanhaw hi Jesus.” ");
INSERT INTO bkd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aman pigpilian dan su daruwa ha etaw ha iyan si Matias daw si Jose ha tagngaranan ki Barsabas ha pigdagnayan daan ki Justo. ");
INSERT INTO bkd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dayun mig-ampù sa mga tumutuu ha tagyanaen “Dios ha Magbabayà hu alan, natun-an nu sa henà-henà hu alan ha mga etaw. Iman ipaahà kanay ku sin-u duun taini ha daruwa sa pinilì nu ");
INSERT INTO bkd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ha iyan makailis ki Judas ha apostol ta inawaan din haena sa katengdanan daw duminuun hu kandin ha banuwa.” ");
INSERT INTO bkd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dayun pigripa dan haena aman si Matias iyan napilì ha ig-isab duun taena ha sampulù daw sabuwa ha apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Su mauma sa aldaw ha agsaulugen sa Pentecostes sa alan ha mga tumutuu mig-amul-amul duun hu sabuwa ha balay. ");
INSERT INTO bkd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tigkan nakauma sa daheneg ha napuun ta langit iling hu maseleg ha kalamag duun ku balay ha duun sidan mig-amul-amul. ");
INSERT INTO bkd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Amin dan naahà ha tagkalegdeg ha kuminunsad duun hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Dayun inulinan sidan hu Balaan ha Ispiritu daw nakaikagi sidan hu migkalain-lain ha inikagiyan sumalà hu hinimu hu Balaan ha Ispiritu kandan. ");
INSERT INTO bkd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Amin daan mga masinimbahen ha Judio ha napuun duun hu migkalain-lain ha nasud dini ta kalibutan ha diyà tagtimà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Su mapaliman dan sa magulub madakel kandan sa uminubay duun daw nangabeleng gayed ta sa kada sabuwa kandan nakapaliman hu kandin ha inikagiyan. ");
INSERT INTO bkd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Aman nakaikagi sidan hu “Dì ba alan man haini sidan taga-Galilea? ");
INSERT INTO bkd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Imbà man agkapaliman taw sa inikagiyan hu kada sabuwa kanuy? ");
INSERT INTO bkd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sa duma kanuy mga taga-Partia, mga taga-Media daw mga taga-Elam. Sa duma mga taga-Mesopotamia, mga taga-Judea daw mga taga-Capadocia, mga taga-Ponto daw mga taga-Asia. ");
INSERT INTO bkd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Sa duma mga taga-Frigia daw mga taga-Pamfilia, mga taga-Ehipto daw duun nangapuun hu mga banuwa diyà ta Libya ha ubay ta Cirene. Sa duma mga langyaw ha sakup ta Roma ha sa duma mga Judio daw sa duma daan mga kinabig duun hu tinuuwan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Sa duma mga taga-Creta daw mga taga-Arabia. Ba napaliman taw alan duun hu kanuy ha mga inikagiyan sa inikagi dan mahitenged hu belenganen ha binuhat hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aman nangabeleng gayed sa alan ha mga etaw daw migpainsaay ku inu haena sa naula-ula kandan. ");
INSERT INTO bkd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ba sa duma bà dà migtameyes kandan ha tagyanaen “Bà dà sidan agkangabeleng ta nakainum gid.” ");
INSERT INTO bkd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Huminitindeg si Pedro duma hu sampulù daw sabuwa ha apostoles daw minikagi hu madaging ha tagyanaen “Sinyu sa duma ku ha Judio daw sa alan ha tagtimà iman dini ta Jerusalem, magpaliliman kaw ta daw matun-an nuy ku inu haini sa naula-ula kanay. ");
INSERT INTO bkd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abi nuy gid ha saini ha mga duma ku bà dà nakainum, ba harì haini mahimu ta seselem pa. ");
INSERT INTO bkd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Saini ha naula-ula iman iyan en su lalang hu Dios ha inikagi hi Joel sa propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Duun hu hudiyan ha panahun igpaulin ku sa Balaan ha Ispiritu duun hu kaet-etawan. Sa mga batà nuy ha maama daw mga bahi makasaysay hu igpaikagi ku, sa mga manguhed ha etaw makaahà hu panan-awen daw sa magulang magpandamugu daan. ");
INSERT INTO bkd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Duun asem taena bisan sa mga suluguen ku ha maama daw mga bahi paulinan ku daan hu Balaan ha Ispiritu ta daw makasaysay sidan hu igpaikagi ku. ");
INSERT INTO bkd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ipaahà ku sa mga belenganen diyà ta langit daw sa mga timaan dini ta kalibutan ha iyan sa langesa, sa hapuy daw sa malabung ha ebel. ");
INSERT INTO bkd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sumukilem sa aldaw daw sa bulan mailing hu langesa dayun makauma sa paghukum hu Dios hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Duun asem taena ha panahun sa alan ha magpabulig hu Ginuu maluwas.’ ");
INSERT INTO bkd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Sinyu sa mga duma ku ha kaliwat hi Israel, palilimani nuy haini sa ag-ikagiyen ku ha si Jesus sa taga-Nazaret sinugù hu Dios. Sa timaan taena iyan sa pagkagamhanan din daw sa mga belenganen ha impabuhat kandin hu Dios. Natun-an nuy en haini ta nahitabù en diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Daan en intagana hu Dios ha si Jesus itugyan diyan ta inyu daw ipalansang nuy duun hu krus taena ha mga etaw ha masinupaken. ");
INSERT INTO bkd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ba binanhaw hu Dios ta harì gayed mabaluy ha madaeg haena hu kamatayen. ");
INSERT INTO bkd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Si David migtagnà daan su anay mahitenged kandin ha tagyanaen ‘Sigi dà tagduma-duma kanak sa Dios daw harì a kandin ag-awaan aman malinawen a. ");
INSERT INTO bkd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pinaagi taena malipayen a gayed daw tagdayè a hu Dios. Igsalig ku daan kandin sa lawa ku ");
INSERT INTO bkd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ta natun-an ku ha harì a kandin itugyan diyà ta Kamatayan daw harì din daan itugut ha maledak haini sa lawa ku siak sa sinugù din. ");
INSERT INTO bkd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Intuen din kanak sa dalan payanaen duun hu kinabuhì ha hurà din katapusan daw malipayen a gayed ta sigi dà dini ta kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Mga suled, natun-an taw ha sa bantugan ha gin-apuan taw ha si David nalugay en sa kapatay din daw agkatulen taw pa iman sa lebeng din. ");
INSERT INTO bkd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Propita haena aman natun-an din sa impanumpà hu Dios kandin ha duun hu kaliwat din amin humiwal ha magharì iling kandin. ");
INSERT INTO bkd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Intagnà din daan sa pagkabanhaw hu Mesiyas ha harì itugyan diyà ta Kamatayan daw harì daan itugut ha maledak sa lawa din. ");
INSERT INTO bkd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Su pigtagnà hi David iyan si Jesus sa pigbanhaw hu Dios daw alan kay makapanistigus ha laus gayed haini ta naahà day. ");
INSERT INTO bkd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Impatangkaw haena hu Dios daw diyà impapinuu ta kawanan din. Inilahan din daan hu katenged hu pagsugù dini hu Balaan ha Ispiritu sa insaad din. Aman sa naahà nuy daw sa napaliman nuy iman iyan en pagpaulin din hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kenà iyan si David luminigtu diyà ta langit ba migtagnà haena hu ‘Inikagiyan hu Dios sa Ginuu ku ha “Dini ka pinuu ta kawanan ku ");
INSERT INTO bkd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hangtud ha madaeg ku sa mga kuntra nu.”’ ");
INSERT INTO bkd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Aman kinahanglan ha sikuy sa alan ha mga kaliwat hi Israel, matun-an taw gayed ha si Jesus sa impalansang nuy duun hu krus binuhat hu Dios ha iyan Ginuu taw daw Mesiyas.” ");
INSERT INTO bkd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Su mapaliman haena hu kaet-etawan suminakit sa gahinawa dan aman ininsaan dan si Pedro daw sa duma ha mga apostoles hu “Mga suled, inu man sa buhaten day?” ");
INSERT INTO bkd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tuminubag si Pedro hu “Alan kaw maghinulsul ta daw mapasaylu sa mga salà nuy daw magpabautismu kaw duun hu ngaran hi Jesu Cristo. Dayun maulinan kaw hu Balaan ha Ispiritu ");
INSERT INTO bkd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ta iyan haena insaad hu Dios ha Magbabayà taw ha ig-ila din inyu daw hu mga kaliwatan nuy daw bisan hu alan ha mga etaw duun hu madiyù ha aghimuwen hu Dios ha tumuu kandin.” ");
INSERT INTO bkd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Madakel pa gayed sa inikagi hi Pedro hu paghangyù kandan ha tagyanaen “Endai nuy sa madaet ha buhat hu kaet-etawan iman ta saena agsilutan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Madakel sa tuminuu hu inikagi hi Pedro aman binautismuwan sidan. Mga tatulu ha libu sa nakatuu ha nakaisab kandan taena ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sigi dà gayed mig-amul-amul sa mga tumutuu hu pagpaliliman taena ha intudlù kandan hu mga apostoles daw hu pagkaen, hu paghenà-henà taena ha kamatayen hi Jesus daw hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Madakel sa belenganen daw timaan ha impaahà hu mga apostoles aman nangabeleng gayed sa mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Duun taena ha panahun nasabuwa sa alan ha mga tumutuu daw migpaila-ilahà sidan hu mga butang dan. ");
INSERT INTO bkd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Impamaligyà dan daan sa mga katigayunan dan dayun sa halin taena binahin-bahin sumalà hu kinahanglanen hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Aldaw-aldaw tag-amul-amul sidan diyà ta Timplo daw agduun daan sidan hu mga balay dan hu pagkaen ha tungkay gayed sidan malipayen ");
INSERT INTO bkd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ha tagdayè hu Dios, daw tinahud daan sidan hu alan ha mga etaw. Kada aldaw amin pakaisab kandan ha agluwasen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Amin panahun ha su agkabalalay en sa aldaw si Pedro daw si Juan duminiyà ta Timplo ta iyan haena panahun hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Duun taena ha pultahan hu Timplo ha tagngaranan hu Madagway ha Pultahan amin etaw ha daan en pigket su ibatà. Kada aldaw ag-uwiten diyà ta daw magpakilimus duun hu mga etaw ha agseled ta Timplo. ");
INSERT INTO bkd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Su maahà din si Pedro daw si Juan sa agseled en diyà ta Timplo pinanayuan din sidan hu limus. ");
INSERT INTO bkd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Uminahà si Pedro daw si Juan diyà ta kandin daw inikagiyan hi Pedro hu “Ahà ka dini ta kanay.” ");
INSERT INTO bkd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aman uminahà haena diyà ta kandan ta tagsalap ku ilahan. ");
INSERT INTO bkd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ba inikagiyan haena hi Pedro ha “Hurà day salapì ba ku inu sa dini ta kanay iila day ikaw. Aman pinaagi hu ngaran hi Jesu Cristo ha taga-Nazaret hipanaw ka.” ");
INSERT INTO bkd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dayun inibitan hi Pedro sa kawanan ha alima taena daw ipahitindeg. Sagunà naulian sa paa din ");
INSERT INTO bkd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","daw huminitindeg dayun hipanaw. Sumineled diyà ta Timplo duma kandan ha taghiphipanaw daw taglaksu-laksu ha tagdayè hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Su maahà hu mga etaw haena sa taghiphipanaw ha tagdayè hu Dios ");
INSERT INTO bkd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nakilala dan ha iyan en haena su tagpinuuwà daw tagpakilimus duun ku Madagway ha Pultahan ta Timplo, aman nangabeleng gayed sidan hu nahitabù taena. ");
INSERT INTO bkd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Su diyà en si Pedro daw si Juan ta sihungà ha tagngaranan hu Sihungà hi Salomon daw tagpangibità pa diyà ta kandan su naulian ha pigket, inamul-amulan sidan hu mga etaw ha agkangabeleng gayed. ");
INSERT INTO bkd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Su maahà hi Pedro su mga etaw inikagiyan din hu “Sinyu sa mga duma ku ha kaliwat hi Israel, imbà nuy haini agkabelengi daw imbà kaw tag-ahaay dini ta kanay? Abi nuy gid ha pinaagi hu kanay ha pagkamatareng daw gahem sa impakahipanaw taini. ");
INSERT INTO bkd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Sa Dios ha iyan tagsimbahen hi Abraham, hi Isaac daw hi Jacob sa mga gin-apuan taw migdayè ki Jesus ha sinugù din. Intugyan nuy si Jesus duun hu mga punuan daw pigtameyes nuy daan duun hu atubangan hi Pilato bisan su igpaawà en ngaay haena hi Pilato. ");
INSERT INTO bkd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hurà nuy kabayai ha libriyen haena sa balaan daw matareng ba iyan nuy pinanayù ha ipaawà sa sabuwa ha talamunù. ");
INSERT INTO bkd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinahimatayan nuy sa tag-ila hu kinabuhì ba binanhaw dà haena hu Dios daw naahà day. ");
INSERT INTO bkd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pinaagi hu ngaran hi Jesus daw hu pagsalig kandin iyan impakahipanaw taini ha etaw ha nakilala nuy en daw naahà nuy iman. ");
INSERT INTO bkd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Iman mga suled, natun-an ku ha saena binuhat nuy duma hu mga punuan ta hurà nuy kakilala ku sin-u si Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ba pinaagi taena tinuman hu Dios sa inikagi hu mga propita din ha su Mesiyas ha sinugù din kinahanglan gayed ha mag-antus. ");
INSERT INTO bkd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Aman maghinulsul kaw gayed daw likù kaw duun hu Dios ta daw mapasaylu sa mga salà nuy daw sa kalinaw ha napuun duun hu Dios makadiyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Amin asem panahun ha ipalikù din si Jesus ha iyan su Mesiyas sa pinilì din ha magharì kanuy. ");
INSERT INTO bkd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ba saena diyà pa iman ta langit taman ha bag-uwen hu Dios sa alan sumalà hu inikagi hu mga propita. ");
INSERT INTO bkd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ta inikagi hi Moises ha ‘Sa Dios ha Magbabayà hu alan magsugù diyan ta inyu hu propita ha duma nuy dà daan ha Judio iling hu pagsugua din kanak diyan ta inyu. Kinahanglan ha magpaliliman kaw gayed hu alan ha ag-ikagiyen din inyu. ");
INSERT INTO bkd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sa harì magpaliliman kandin hurà makalagkes duun hu mga etaw hu Dios.’ ");
INSERT INTO bkd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Sa alan ha mga propita sugud dà ki Samuel migtagnà daan hu naul-ulahan en iman. ");
INSERT INTO bkd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iyan kuy sa nakaangken hu insaad hu mga propita daw hu kasabutan hu Dios daw hu mga gin-apuan taw ta inikagi din diyà ki Abraham ha tagyanaen ‘Pinaagi hu mga kaliwatan nuy mapanalanginan sa alan ha kaet-etawan dini ta kalibutan.’ ");
INSERT INTO bkd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aman iyan kuy nauna ha pinaelegan hu Dios ki Jesus ta daw mapanalanginan kuy pinaagi hu pag-endà taw hu madaet ha mga buhat.” ");
INSERT INTO bkd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Su kamulu pa si Pedro daw si Juan tag-ikagi duun hu mga etaw nakauma diyà ta kandan sa mga sinaligan hu paghalad, sa kapitan hu mga bantay taena ha Timplo daw sa mga Saduceo. ");
INSERT INTO bkd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nangapauk sidan tumenged hu pagtudlù taena ha mga apostoles duun hu kaet-etawan ha sa nangamatay ha etaw mabanhaw dà ta nabanhaw daan si Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aman dinakep dan si Pedro daw si Juan daw purisuwa hu nangkadaleman ta agkahapun en haena. ");
INSERT INTO bkd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ba sa madakel ha nakapaliman tuminuu, lalima ha libu sa kadakelen hu mga maama. ");
INSERT INTO bkd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Su maselem en mig-amul-amul diyà ta Jerusalem sa mga punuan, sa mga magulang daw sa mga manunudlù hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Duun en daan si Anas sa tungkay labaw ha sinaligan hu paghalad, si Caifas daw si Juan, si Alejandro daw sa duma ha mga kadumahan hi Anas. ");
INSERT INTO bkd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Impaatubang dan si Pedro daw si Juan daw insai ku sin-u sa mig-ila kandan hu gahem hu pagbulung taena ha pigket. ");
INSERT INTO bkd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dayun si Pedro sa inulinan hu Balaan ha Ispiritu uminikagi diyà ta kandan hu “Sinyu sa mga punuan daw mga magulang, ");
INSERT INTO bkd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ku insaan kay iman inyu hu maayad ha binuhat day duun taini ha pigket daw ku inu ha gahem sa ingkaulii din, ");
INSERT INTO bkd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","kinahanglan ha matun-an nuy daw hu alan ha kaliwat hi Israel ha pinaagi hu ngaran hi Jesu Cristo ha taga-Nazaret sa impalansang nuy duun hu krus ba pigbanhaw dà hu Dios iyan ingkaulii taini ha tag-ahaen nuy iman. ");
INSERT INTO bkd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus iyan su batu ha bà dà inlambeg ta abi hu mga tagbalay ha hurà din pulus ba iyan man diay pakapalig-en hu balay. ");
INSERT INTO bkd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Iyan dà si Jesus makaluwas hu kaet-etawan ta hurà en gayed lain ha Manluluwas ha sinugù hu Dios dini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Su maahà hu mga punuan ha si Pedro daw si Juan harì gayed agkahaldek hu pag-ikagi nangabeleng sidan ta natun-an dan ha hurà haena makatunghà. Ba nahenhenaan dan ha nakagduma-duma haena ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tumenged ta naahà dan en su naulian ha taghitindeg daan duma ki Pedro daw ki Juan hurà dan en gayed agkaikagi. ");
INSERT INTO bkd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aman impaguwà sidan dayun su mga labaw ha punuan hu mga Judio miglalang-lalang ");
INSERT INTO bkd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","hu kagi dan “In-inuwen taw man iman haini ha mga etaw? Natun-an en hu alan ha tagtimà dini ta Jerusalem sa binuhat dan ha belenganen aman harì taw en haini makalimud. ");
INSERT INTO bkd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ba sa buhaten taw iman balaudan taw sidan ha harì dan en itudlù sa mahitenged ki Jesus ta daw harì en makalekep duun hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aman impaumaw dan dà si Pedro daw si Juan daw balaudi ha harì en sidan magsangyaw daw magtudlù mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ba si Pedro daw si Juan tuminubag hu “Henhenaa nuy ku hindu sa maayad. Iyan day ba tumanen sa inyu ha sugù daw ku iyan day ba sa sugù hu Dios? ");
INSERT INTO bkd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Harì gayed mabaluy ha umendà kay hu pagpanunultul mahitenged hu naahà day daw hu napaliman day.” ");
INSERT INTO bkd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pighulgà pa gayed si Pedro daw si Juan daw human ipaguwà. Hurà sidan kasiluti ku mga punuan ta sa mga etaw tagdayè hu Dios tumenged hu nahitabù. ");
INSERT INTO bkd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ta su etaw ha naulian subra en ha kapatan sa tuig din. ");
INSERT INTO bkd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Su ipaguwà en si Pedro daw si Juan duminuun sidan hu duma dan ha mga tumutuu daw intultul dan sa imbalaud kandan ku mga labaw ha sinaligan hu paghalad daw hu mga magulang. ");
INSERT INTO bkd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Su mapaliman hu mga tumutuu sa intultul dan alan sidan mig-ampù ha tagyanaen “Dios ha Magbabayà hu alan, iyan ka migtanghagà ta langit daw ta kalibutan, ta dagat daw sa alan ha duun taena. ");
INSERT INTO bkd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Pinaagi hu Balaan ha Ispiritu impaikagi nu sa gin-apuan day ha si David sa suluguen nu ha tagyanaen ‘Imbà agkangapauk sa kenà mga Judio daw imbà taghenhenaaya hu kaet-etawan sa hurà din pulus? ");
INSERT INTO bkd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sa mga harì duun taini ha kalibutan tagpangandam en hu sabà daw sa mga punuan mig-amul-amul daan hu pagpakigsabà hu Dios daw taena ha pinilì din hu pagharì.’ ");
INSERT INTO bkd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Saini natuman gayed ta dini ta Jerusalem si Herodes daw si Poncio Pilato daw sa duma ha mga Judio daw sa kenà mga Judio mig-uyun sidan hu paghimatay ki Jesus sa sinugù nu daw pinilì nu ha magharì. ");
INSERT INTO bkd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Binuhat dan sa daan nud en nahenà-henà ha mahitabù. ");
INSERT INTO bkd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iman Dios ha Magbabayà hu alan, napaliman nu sa mga hulgà dan kanay ba himuwa kay ha makapanunultul gayed hu lalang nu ha hurà day kahaldek. ");
INSERT INTO bkd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipaahà sa gahem nu ta daw mangaulian sa agkangadaluwan daw pinaagi hu ngaran hi Jesus sa sinugù nu makapaahà kay daan hu mga timaan daw belenganen.” ");
INSERT INTO bkd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Su makapenga sidan mag-ampù nahuyung su balay ha pig-amul-amulan dan. Dayun inulinan sidan hu Balaan ha Ispiritu aman hurà dan en gayed kahaldek hu pagpanunultul hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Duun taena ha panahun sa alan ha mga tumutuu migsabuwa gayed. Hurà kandan mighenà-henà ha kandin dà sa mga butang din ta pigsabuwahan dan gayed sa alan ha mga katigayunan dan. ");
INSERT INTO bkd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Amin gayed gahem duun hu pagpanunultul hu mga apostoles mahitenged hu pagkabanhaw hi Jesus ha Ginuu aman adagi sa panalangin kandan. ");
INSERT INTO bkd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Hurà kandan miglised ta sa alan ha amin din bugtà daw mga balay imbaligyà dan sa duma taena daw sa halin din ");
INSERT INTO bkd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","inamul dan duun hu mga apostoles. Dayun binahin-bahin sumalà hu kinahanglanen hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sa sabuwa kandan iyan sa kaliwat hi Levi ha taga-Cipro ha tagngaranan ki Jose ba pigdagnayan hu mga apostoles ki Bernabe ta sa kahulugan taena Tigdasig. ");
INSERT INTO bkd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Migbaligyà haena hu sabuwa ha bugtà din dayun inuwit din sa halin duun hu mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amin daan etaw ha tagngaranan ki Ananias daw sa asawa din iyan si Safira ha migbaligyà hu bugtà dan. ");
INSERT INTO bkd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Sa halin taena inalatan hi Ananias daw mig-uyun daan sa asawa din dayun sa samà inuwit din duun hu mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ba minikagi si Pedro hu “Ananias, inulinan kad gayed hi Satanas aman pigbiduan nu sa Balaan ha Ispiritu. Imbà nu man alati su salapì ha halin hu bugtà? ");
INSERT INTO bkd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Saena ha bugtà ikaw gayed su hurà nu pa ibaligyà daw bisan su ibaligyà nud en iyan ka gihapun tagbayà ku inu sa buhaten nu hu halin din. Imbà nu man kahenhenai sa pagbuhat hu madaet? Ta sa piglimbungan nu kenà iyan dà sa etaw ba iyan sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Su mapaliman haena hi Ananias sagunà nabantang dayun minatay. Sa alan ha nakapaliman taena ha naul-ulahan nahaldek gayed. ");
INSERT INTO bkd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dayun su minatay inelegan hu mga manguhed ha etaw daw bungkusi hu manggad daw ilebeng. ");
INSERT INTO bkd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Su mga tatulu en ha uras sumineled daan si Asawa din ba hurà din katun-i sa nahitabù. ");
INSERT INTO bkd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aman ininsaan hi Pedro hu “Iyan dà ba haini halin ku bugtà ha imbaligyà nuy?” Tuminubag haena hu “Iyan dà hayana.” ");
INSERT INTO bkd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Inikagiyan haena hi Pedro hu “Imbà kaw man mag-uyun ha sulayen nuy sa Balaan ha Ispiritu ha sinugù hu Dios? Ahaa nu, ta taglikù en sa miglebeng ku asawa nu na iyan kad en paman kandan iman iglebeng.” ");
INSERT INTO bkd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sagunà daan nabantang si Safira duun hu atubangan din dayun minatay. Su pagseled ku mga manguhed ha etaw naahà dan haena ha minatay en daan aman inlebeng dan abay ku asawa din. ");
INSERT INTO bkd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tumenged taena sa alan ha mga tumutuu daw sa nakapaliman hu naul-ulahan nangahaldek gayed. ");
INSERT INTO bkd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Madakel gayed ha mga belenganen daw mga timaan sa impaahà hu mga apostoles duun hu atubangan hu mga etaw. Sa mga tumutuu sigi tag-amul-amul duun taena ha Sihungà hi Salomon diyà ta Timplo. ");
INSERT INTO bkd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ba bisan ku tinahud sidan hu mga etaw hurà bisan sabuwa ha uminamul kandan ta agkangahaldek sidan. ");
INSERT INTO bkd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Duun taena madakel gayed ha mga maama daw mga bahi sa nakaisab kandan ha tuminuu hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tumenged hu binuhat ku mga apostoles pinan-uwit duun hu mga dalan sa mga agkangadaluwan ha impamahidegà duun hu duyanan daw mga banig, ta sa henà-henà dan ha ku makaagi si Pedro diyà ta kandan bisan ku alung din dà sa makalambung kandan maulian en sidan. ");
INSERT INTO bkd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pinan-uwit daan hu mga etaw ha tagtimà duun hu mga banuwa ha ubayà ta Jerusalem sa mga agkangadaluwan daw sa pigpasipalahan hu mga busaw, saena alan nangaulian. ");
INSERT INTO bkd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Duun taena ha panahun sa tungkay labaw ha sinaligan hu paghalad daw sa sakup hu mga Saduceo ha mga duma din agkangasina gayed ");
INSERT INTO bkd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","aman dinakep dan sa mga apostoles daw purisuwa. ");
INSERT INTO bkd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ba su daleman nakauma duun ku mga apostoles sa balinsuguen hu Dios. Dayun pinuwaan din sa purisuwan daw ipaguwà sidan ha migyanaen ");
INSERT INTO bkd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Diyà kaw ta Timplo daw tudlui sa mga etaw mahitenged hu bag-u ha kinabuhì.” ");
INSERT INTO bkd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Su maselem en duminiyà sidan ta Timplo daw panudlù. Duun daan taena ha aldawa inamul ku tungkay labaw ha sinaligan hu paghalad daw ku mga duma din sa alan ha mga labaw ha punuan hu mga Judio. Dayun impatimù dan hu mga bantay su mga apostoles diyà ta purisuwan. ");
INSERT INTO bkd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ba su makauma sidan diyà hurà dan en kaahà su mga apostoles. Aman luminikù sidan daw panunultul ha ");
INSERT INTO bkd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Su makauma kay diyà ta purisuwan sinirahan haena daw sa mga bantay na diyà ta pultahan. Ba su puwaan day hurà en etaw diyà ta seled.” ");
INSERT INTO bkd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Su mapaliman haena hu kapitan hu mga bantay taena ha Timplo daw hu mga labaw ha sinaligan hu paghalad nabeleng sidan ku hindu en duun sa mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ba amin nakauma ha nanunultul diyà ta kandan hu kagi din “Saena ha mga etaw ha pinurisu nuy diyà en ta Timplo ha tagpanudlù hu kaet-etawan.” ");
INSERT INTO bkd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aman su kapitan hu mga bantay daw sa mga sakup din inelegan dan su mga apostoles daw uwita duun hu mga punuan. Ba hurà dan pegesa ta agkahaldek sidan ku batuwen sidan hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Impaatubang su mga apostoles duun ku mga labaw ha punuan. Dayun ininsaan sidan ku tungkay labaw ha sinaligan hu paghalad hu kagi din ");
INSERT INTO bkd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hurà day ba inyu balaudi ha harì nuy en itudlù sa pagtuu nuy taena ha etaw? Ba iman inlekep nuy en dini ta Jerusalem daw igbasul nuy kanay sa pagpatay taena.” ");
INSERT INTO bkd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ba si Pedro daw sa duma din ha mga apostoles tuminubag hu “Kinahanglan ha iyan day gayed tumanen sa sugù hu Dios dì hu etaw. ");
INSERT INTO bkd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sa Dios ha tagsimbahen hu mga gin-apuan taw iyan migbanhaw ki Jesus sa hinimatayan nuy pinaagi hu kalansanga kandin duun hu krus. ");
INSERT INTO bkd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Iman impatangkaw haena hu Dios daw duun impapinuu hu kawanan din isip ha Harì daw Manluluwas taw ta daw ku maghinulsul kuy sikuy sa mga kaliwat hi Israel pasayluwen kuy kandin. ");
INSERT INTO bkd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Makapanistigus kay gayed mahitenged hu pagkabanhaw hi Jesus ta naahà day haini, daw sa Balaan ha Ispiritu ha impaulin hu Dios duun hu mga matinumanen kandin makapanistigus gayed daan.” ");
INSERT INTO bkd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Su mapaliman haena ku mga labaw ha punuan nangapauk gayed sidan, aman agkabayaan dan en aghimatayi su mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ba amin dan duma ha Fariseo ha tagngaranan ki Gamaliel ha manunudlù daan hu Kasuguan daw tinahud hu mga etaw. Saena huminitindeg daw ikagi ha ipaguwà enà su mga apostoles hu nangkaatiyù. ");
INSERT INTO bkd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Dayun inikagiyan din su mga duma din hu “Sinyu sa mga duma ku ha kaliwat hi Israel, hinay-hinayen nuy sa agkabayaan nuy agbuhata duun taini ha mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Su anay amin etaw ha tagngaranan ki Teudas ha nakadini sa migpaad-adagi aman migpasakup kandin sa haepat ha gatus ha mga etaw. Ba hinimatayan haena daw sa mga sakup din nakagsusuwayà aman nangahanaw sa buluhaten dan. ");
INSERT INTO bkd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Daw amin pa daan taga-Galilea ha iyan si Judas ha nakadini su panahun hu pag-iyap hu mga etaw na amin daan migpasakup kandin. Ba saena hinimatayan daan daw nakagsusuwayà sa mga sakup din. ");
INSERT INTO bkd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Aman ikagiyen ku inyu ha harì taw pasipalahan haini sa mga etaw ba ipatayà taw en. Ta ku sa tagbuhaten dan kandin dà hu etaw mahanaw dà daan haini, ");
INSERT INTO bkd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ba ku kandin hu Dios harì taw gayed haini mabaldeng ta kan ku bà taw dà paman kasabà sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Aman tuminuu sidan ki Gamaliel. Su ipaisab dan ipaatubang diyà ta kandan su mga apostoles daw palagkuti binalaudan dan ha harì en sidan manunultul mahitenged ki Jesus dayun impaguwà sidan. ");
INSERT INTO bkd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Inawaan su mga labaw ha punuan ku mga apostoles ha malipayen ta naisip sidan ha angayan ha pagagayhaan tumenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aldaw-aldaw diyà ta Timplo daw duun hu mga balay migpadayun sidan hu pagsangyaw daw hu pagpanudlù ha si Jesus iyan su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Su panahun ha migdakel en sa mga tumutuu sa mga Judio ha Griego sa kandan ha inikagiyan migtamudmud taena ha mga Judio ha Hebreo sa kandan ha inikagiyan tumenged ta sa sakup dan ha bahi ha balu harì agkailahan hu pagpan-ila kada aldaw. ");
INSERT INTO bkd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aman inamul ku sampulù daw daruwa ha apostoles sa alan ha mga tumutuu daw ikagiyi hu “Harì mabaluy ha endaan day sa pagtudlù hu lalang hu Dios daw iyan day buhaten sa pagpan-ila iman hu mga kinahanglanen nuy. ");
INSERT INTO bkd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aman mga suled, magpilì kaw hu pitu ha etaw diyan ta inyu ha nakilala ha maalam daw inulinan gayed hu Balaan ha Ispiritu. Iyan taw sidan agsaligan taini ha pagpan-ila ");
INSERT INTO bkd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ta daw sikay sa mga apostoles iyan dà mapaniguruwan day pagbuhat sa pag-ampù daw sa pagtudlù hu lalang hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Su mapaliman haena hu mga tumutuu tungkay gayed sidan nangabayà-bayà. Aman pinilì dan si Esteban sa mabis-ay gayed sa pagtuu din daw inulinan daan hu Balaan ha Ispiritu, daw pinilì dan daan si Felipe daw si Procoro, si Nicanor daw si Timon, si Parmenas daw si Nicolas sa taga-Antiokia ha nakabig duun hu tinuuwan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Impaatubang su nangapilì duun hu mga apostoles daw pinagaheman sidan pinaagi hu pagdampà kandan taena ha mga apostoles dayun inampuan dan sidan. ");
INSERT INTO bkd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aman nakalekep sa lalang hu Dios daw migdakel gayed sa mga tumutuu diyà ta Jerusalem daw madakel daan sa mga sinaligan hu paghalad ha tuminuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Si Esteban pigpanalanginan hu Dios daw ginaheman gayed hu Balaan ha Ispiritu aman madakel ha mga belenganen daw timaan sa impaahà din duun hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ba amin daan nakigsawalà ki Esteban ha mga sakup taena ha simbahan hu mga Judio ha pigngaranan hu Simbahan hu Nalibri ha Ulipen. Saini sidan diyà nangapuun ta Cirene daw ta Alejandria daw sa duma daan duun hu mga probincia ta Cilicia daw ta Asia. ");
INSERT INTO bkd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ba hurà dan kadaeg si Esteban ta sa Balaan ha Ispiritu iyan migtudlù kandin hu ag-ikagiyen din. ");
INSERT INTO bkd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aman hinunghungan dan sa duma ha mga etaw hu kagi dan “Napaliman day hayana ha pigtameyes din si Moises daw sa Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pigdasig dan daan sa kaet-etawan daw sa mga magulang daw sa mga manunudlù hu Kasuguan aman dinakep si Esteban daw ipaatubang duun hu alan ha mga labaw ha punuan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Impaatubang dan daan haena sa mga biduen ha tistigus ha tagyanaen “Saini ha etaw sigi dà gayed tagtameyes taini ha Timplo daw hu Kasuguan ");
INSERT INTO bkd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ta napaliman day haini ha migyanaen ha agkagasen kun hi Jesus ha taga-Nazaret haini sa Timplo daw agbalhinen din sa mga tulumanen ha imbilin kanuy hi Moises.” ");
INSERT INTO bkd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Sa alan ha mga labaw ha punuan ha naamul-amul diyà migtengteng ki Esteban na naahà dan sa weleng din ha agkailing hu balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sa tungkay labaw ha sinaligan hu paghalad nanginginsà ki Esteban hu “Laus ba haini sa mga sumbung dan ikaw?” ");
INSERT INTO bkd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tuminubag haena hu “Mga suled ku daw sinyu sa mga magulang, palilimani a inyu. Su anay sa gamhanan ha Dios migpaahà ki Abraham sa gin-apuan taw su diyà pa haena ta Mesopotamia ha hurà pa magtimà diyà ta Haran ");
INSERT INTO bkd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","daw inikagiyan haena hu ‘Awai nu haini sa nasud nu daw sa alan ha mga kadumahan nu daw dumuun ka hu bugtà ha igpaahà ku ikaw.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Aman inawaan din sa Caldea daw diyà en migtimà ta Haran. Ba su matay en sa amay din impahalin dà hu Dios si Abraham duun taini ha bugtà ha iyan en iman sa tagtimaan taw. ");
INSERT INTO bkd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Duun taena ha panahun hurà pa kailahi si Abraham hu bisan atiyuay dà ha bugtà ba saena insaad hu Dios ha ig-ila kandin ta daw mabuhat din ha kabilin duun hu mga kaliwatan din bisan ku hurà din pa batà. ");
INSERT INTO bkd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iyan haini inikagi kandin hu Dios ha ‘Sa mga kaliwatan nu mabuhat ha langyaw duun hu lain en ha nasud daw mabuhat sidan ha mga ulipen daw daeg-daegen gayed sidan seled hu haepat ha gatus ha tuig. ");
INSERT INTO bkd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ba silutan ku gihapun haena sa magdaeg-daeg kandan. Ku maiwas haini umawà sidan duun taena ha nasud daw dumini sidan taini ha lugar hu pagsimba kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Duun taena inikagiyan hu Dios si Abraham ha sirkunsidahan sa mga batà dan ha maama ha iyan timaan hu kasabutan dan hu Dios. Aman su ibatà en si Isaac sinirkunsidahan haena hi Abraham duun hu ikawalu ha aldaw. Binuhat daan haena hi Isaac duun hu batà din ha iyan si Jacob, daw binuhat daan haena hi Jacob duun hu sampulù daw daruwa ha batà din ha iyan mga gin-apuan taw. ");
INSERT INTO bkd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Duun taena ha panahun si Jose sa sabuwa ha batà hi Jacob imbaligyà hu mga magulang din diyà ta Ehipto tumenged hu kasina dan kandin. Ba pigdumahan gayed hu Dios si Jose ");
INSERT INTO bkd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","daw binuligan hu alan ha mga kasamukan din. Inilahan din si Jose hu kaalam daw hinimu din haena ha makapabayà-bayà ki Faraon sa Harì ta Ehipto. Aman binuhat hi Faraon ha gubernador si Jose diyà ta Ehipto daw sinaligan daan hu alan ha mga butang din. ");
INSERT INTO bkd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Dayun nakauma sa adagi ha kauhul diyà ta Ehipto daw ta Canaan aman miglised gayed sa mga etaw daw hurà en daan agkakaen ku mga gin-apuan taw. ");
INSERT INTO bkd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Su mapaliman hi Jacob ha amin pagkaen diyà ta Ehipto impadiyà din sa mga batà din ha iyan su mga gin-apuan taw. ");
INSERT INTO bkd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Su ikaduwa en ha pagdiyà dan ta Ehipto si Jose migpakilala duun ku mga suled din aman natun-an hu Harì ta Ehipto ku sin-u sa mga kadumahan hi Jose. ");
INSERT INTO bkd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dayun pinaelegan hi Jose sa amay din ha si Jacob daw sa alan ha mga kadumahan dan, kapituwan daw lalima sidan alan. ");
INSERT INTO bkd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aman say Jacob namandiyà ta Ehipto daw diyà en sidan nangamatay. ");
INSERT INTO bkd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ba sa mga tul-an dan inlikù dà diyà ta Sikem daw duun in-ugsak hu lebeng ha pinalit hi Abraham su anay duun hu mga batà hi Hamor. ");
INSERT INTO bkd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Su ubay en sa panahun ha matuman sa insaad hu Dios diyà ki Abraham migdakelà en sa mga gin-apuan taw diyà ta Ehipto. ");
INSERT INTO bkd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nakauma sa panahun ha nailisan sa Harì ta Ehipto ha hurà din en katun-i sa mahitenged ki Jose. ");
INSERT INTO bkd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pinasipalahan din sa mga gin-apuan taw daw dinaeg-daeg din sidan daw pineges sidan ha ipanlambeg sa mga batà dan diyà ta madiyù ta daw mangamatay. ");
INSERT INTO bkd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Duun taena ha panahun imbatà daan sa madagway ha batà ha iyan si Moises ha igkabayà-bayà hu Dios. Seled hu tatulu ha bulan inheles haena duun hu balay hu mga laas din. ");
INSERT INTO bkd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ba su ipadiyù en si Moises tinimù haena ku batà ha bahi ku Harì ta Ehipto dayun inalimahan din isip ha kandin en ha batà. ");
INSERT INTO bkd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Si Moises tinudluan hu alan ha kaalam diyà ta Ehipto aman nabantug haena ha matatau duun hu pag-ikagi daw hu mga buhat din. ");
INSERT INTO bkd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Su kapatan en ha tuig si Moises nahenhenaan din ha bisitahan din sa mga duma din ha mga kaliwat hi Israel. ");
INSERT INTO bkd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ba su makauma diyà naahà din ha pinasipalahan sa sabuwa ha duma din aman binuligan din haena daw himatayi su taga-Ehipto. ");
INSERT INTO bkd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Abi din ha natun-an en hu mga duma din ha aglibriyen sidan hu Dios pinaagi kandin ba hurà dan haena katun-i. ");
INSERT INTO bkd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Su maisab ha aldaw naumahan din sa daruwa ha tagsabà. Aghusayen din ngaay sidan aman inikagiyan din hu ‘Imbà kaw tagsabà sa migsuled dà ha kaliwat hi Israel?’ ");
INSERT INTO bkd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ba si Moises bà dà intulud ku tagsabà daw inikagiyan hu ‘Sin-u sa migbuhat ikaw ha pangulu daw maghuhukum day? ");
INSERT INTO bkd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aghimatayan a gid daan ikaw iling taena ha hinimatayan nu gabì ha taga-Ehipto.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Su mapaliman haena hi Moises minulaguy payanaen diyà ta Midian daw diyà en migtimà isip ha langyaw. Duun taena ha lugar imbatà sa daruwa ha batà din ha maama. ");
INSERT INTO bkd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Su maiwas en sa kapatan ha tuig, duun hu pinakabulung-bulung ha lugar ubay ta Bubungan ta Sinai nakahiwal diyà ki Moises sa balinsuguen hu Dios ha duun hu tagkalegdeg ha sampinit. ");
INSERT INTO bkd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Su maahà haena hi Moises nabeleng gayed. Su ubayan din ta daw masuli-suli din napaliman din sa lageng hu Dios ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iyan a sa Dios ha tagsimbahen hu mga gin-apuan nu ha si Abraham, si Isaac daw si Jacob.’ Aman hinugdunan si Moises daw nahaldek hu pag-ahà taena. ");
INSERT INTO bkd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Dayun inikagiyan haena hu Dios hu ‘Awaa sa sapatus nu ta saini ha bugtà ha taghitindegan nu na balaan. ");
INSERT INTO bkd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naahà ku gayed ha dinaeg-daeg sa pinilì ku ha mga etaw diyà ta Ehipto daw napaliman ku sa agelè dan aman duminini a hu paglibri kandan. Iman agsuguen ku ikaw diyà ta Ehipto.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Si Moises iyan su insalikway su anay hu mga duma din ha kaliwat hi Israel ta inikagiyan dan hu ‘Sin-u sa migbuhat ikaw ha pangulu daw maghuhukum day?’ Iyan sinugù hu Dios ha mangulu hu mga etaw ta daw malibri sidan pinaagi hu pagbulig taena ha balinsuguen hu Dios ha huminiwal duun ku sampinit ha tagkalegdeg. ");
INSERT INTO bkd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Su pangagalenan din en sa mga gin-apuan taw diyà ta Ehipto madakel ha mga belenganen daw timaan sa impaahà din diyà ta Ehipto daw duun taena ha Maligà ha Dagat daw duun hu pinakabulung-bulung ha lugar seled hu kapatan ha tuig. ");
INSERT INTO bkd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Iyan si Moises su mig-ikagi duun hu mga kaliwatan hi Israel hu ‘Amin sabuwa ha propita ha humiwal duun hu mga kaliwatan nuy ha suguen hu Dios iling hu pagsugua din kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iyan daan si Moises su nakiglalang hu balinsuguen hu Dios diyà ta Bubungan ta Sinai su panahun ha sa mga kaliwatan hi Israel duun pa taena ha pinakabulung-bulung ha lugar, daw inilahan haena hu insulat ha lalang hu Dios ha tag-ila hu kinabuhì daw imbilin din haena kanuy. ");
INSERT INTO bkd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ba hurà haena tuuwi hu mga gin-apuan taw ta insalikway dan daw nahenhenaan dan ha lumikù dà sidan diyà ta Ehipto. ");
INSERT INTO bkd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aman su diyà pa si Moises ta bubungan inikagiyan dan si Aaron ha ‘Buhati kay ikaw hu mga diyus-diyus ha iyan day sunuren ta si Moises sa nangagalen kanay diyà ta Ehipto na hanaw ta ku nainu-inu en.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Duun taena migbuhat sidan hu larawan ha agkailing hu nati hu baka. Dayun duun sidan mighalad daw tumenged taena ha binuhat dan migsaulug sidan. ");
INSERT INTO bkd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ba inawaan sidan hu Dios daw impatayà sidan hu pagsimba hu bisan inu ha diyà ta kalangitan. Nakasulat en haena hu mga propita ha tagyanaen ‘Sinyu sa mga kaliwat hi Israel, kenà a iyan hinalaran nuy hu mananap seled hu kapatan ha tuig duun hu pinakabulung-bulung ha lugar. ");
INSERT INTO bkd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta sa pig-uwit-uwit nuy iyan su balay-balay taena ha diyus-diyus ha si Moloc daw sa larawan hu bituen ha si Refan. Binuhat nuy haena dayun iyan nuy sinimba aman ipauwit ku inyu duun hu madiyù ha lugar labay pa ta Babilonia.’ ");
INSERT INTO bkd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Su duun pa sa mga gin-apuan taw ku pinakabulung-bulung ha lugar migbuhat sidan hu Tabernaculo ha iyan tagtimaan hu Dios sumalà hu impaahà din diyà ki Moises. ");
INSERT INTO bkd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Su mailisan en si Moises ki Josue pig-uwit-uwit dan haena sa Tabernaculo duun ku bugtà ha naagaw dan duun hu mga etaw ha binugaw hu Dios. Su Tabernaculo duun dà taman hu pagharì hi David. ");
INSERT INTO bkd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nabayà-bayaan gayed hu Dios si David daw huminangyù haena ha tagbalay ngaay hu madagway ha agpatimaan din hu Dios ha tagsimbahen hu mga kaliwatan hi Jacob. ");
INSERT INTO bkd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ba saena hurà itugut hu Dios ki David ta iyan en su batà din ha si Salomon intagana ha magbalay taena. ");
INSERT INTO bkd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ba bisan pa taena sa Dios ha Magbabayà hu alan harì tagtimà duun hu balay ha binuhat hu etaw dà ta inikagi en hu propita ha ");
INSERT INTO bkd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Sa langit iyan trono ku daw sa bugtà iyan gik-ayà ku. Inu paman ha balay sa agbalayen nuy ha agpatimaan nuy kanak? ");
INSERT INTO bkd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kenà a ba diay iyan migbuhat hu alan?’ ");
INSERT INTO bkd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Sinyu sa harì tagpaliliman hu Dios daw mga masinupaken, sigi kaw dà gayed agsukul hu Balaan ha Ispiritu. Agkailing kaw taena ha mga gin-apuan nuy. ");
INSERT INTO bkd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amin ba propita ha hurà pasipalahi hu mga gin-apuan nuy? Bisan sa migtagnà hu pagpakauma hi Jesus ha matareng gayed pighimatayan dan. Iman impadakep nuy daan haena daw pinahimatayan nuy. ");
INSERT INTO bkd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iyan kaw daan inilahan hu Kasuguan hu Dios pinaagi hu mga balinsuguen din, ba hurà nuy haena tumana.” ");
INSERT INTO bkd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Su mapaliman haena ku mga punuan hu mga Judio nangapauk gayed sidan ha migkakangget sa mga ngipen dan. ");
INSERT INTO bkd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ba si Esteban sa inulinan hu Balaan ha Ispiritu huminangad diyà ta langit daw naahà din sa pagpangaluanlag hu Dios daw naahà din daan si Jesus sa tagtiyadeg duun hu kawanan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Dayun minikagi si Esteban hu “Ahaa nuy. Agkaahà ku ha napuwaan sa langit daw sa Suled hu Kaet-etawan tagtiyadeg duun hu kawanan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ba dinap-en ku mga punuan sa mga talinga dan daw pamangulahì. Dayun migdengan sidan hu pagdakep kandin ");
INSERT INTO bkd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","daw guyuda diyà ta guwà taena ha banuwa daw batuwa. Linebas dan sa pinaksuy dan daw pabantayi hu etaw ha tagngaranan ki Saulo. ");
INSERT INTO bkd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Su tagbatuwen dan en si Esteban mig-ampù haena ha tagyanaen “Jesus ha Ginuu ku, dawata nu sa ispiritu ku.” ");
INSERT INTO bkd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dayun luminuhud daw minikagi hu madaging ha “Ginuu, harì nu ag-isipa ha salà dan haini.” Su maikagi din en haena minatay dayun. ");
INSERT INTO bkd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Si Saulo nabayà-bayà gayed hu kahimatayi ki Esteban. Duun taena ha aldaw migsugud sa kapasipalahi hu mga tumutuu diyà ta Jerusalem aman nakagsusuwayà sidan duun hu mga banuwa diyà ta Judea daw ta Samaria. Iyan dà hurà makapulaguy sa mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Si Esteban inlebeng hu mga etaw ha masinimbahen hu Dios daw miglugul gayed sidan mahitenged kandin. ");
INSERT INTO bkd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ba si Saulo pinasipalahan din gayed sa mga tumutuu. Pinanlatunan din sa kada balay daw pandakepa sa mga maama daw sa mga bahi dayun impapurisu din sidan. ");
INSERT INTO bkd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Su mga tumutuu ha nakagsusuwayà nanunultul hu lalang hu Dios bisan hindu duun ha napayanan-an dan. ");
INSERT INTO bkd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe duminuun hu banuwa ha sakup ta Samaria daw migsangyaw ha si Jesus iyan su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Migpaliliman gayed sa kaet-etawan ki Felipe ta naahà dan sa mga belenganen ha binuhat din. ");
INSERT INTO bkd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Madakel sa mga pigket daw sa mga minatay en sa dibaluy ha lawa dan ha nangaulian. Nakapangulahì daan sa mga busaw su bugawen din en duun hu mga etaw ha inulinan dan. ");
INSERT INTO bkd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tumenged taena malipayen gayed sa mga etaw diyà. ");
INSERT INTO bkd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Duun taena ha banuwa amin salamangkiro ha tagngaranan ki Simon ha nabelengan gayed hu mga taga-Samaria. Tagpagalbu haena ha bantugan kun ha etaw ");
INSERT INTO bkd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","aman migpaliliman kandin sa alan ha mga etaw sa matangkaw daw sa ubus sa kahimtang din ha tagyanaen “Sa gahem taini ha etaw duun gayed napuun hu gamhanan ha Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Migsunud sidan kandin tumenged ta nalugay en sa kaahà dan hu mga belenganen ha binuhat din pinaagi hu salamangka. ");
INSERT INTO bkd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ba su makatuu en sidan hu Maayad ha Tultulanen ha insangyaw kandan hi Felipe mahitenged hu pagharì hu Dios daw ki Jesu Cristo binautismuwan sidan, sa maama daw sa mga bahi. ");
INSERT INTO bkd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Bisan si Simon tuminuu aman binautismuwan daan. Migduma en ki Felipe bisan hindu duun daw nabeleng gayed hu mga timaan daw belenganen ha naahà din. ");
INSERT INTO bkd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Su mapaliman hu mga apostoles diyà ta Jerusalem ha tuminuu hu lalang hu Dios sa mga taga-Samaria impadiyà dan si Pedro daw si Juan. ");
INSERT INTO bkd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Su makauma sidan diyà in-ampù dan ha sa mga tumutuu diyà ta Samaria ulinan hu Balaan ha Ispiritu ");
INSERT INTO bkd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ta bà dà sidan nabautismuwi hu ngaran hi Jesus ha Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Aman dinampà hu mga apostoles su mga tumutuu dayun inulinan sidan hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Su maahà hi Simon ha inulinan sidan hu Balaan ha Ispiritu pinaagi hu pagdampà kandan hu mga apostoles tag-ila ngaay haena hu salapì daw minikagi hu ");
INSERT INTO bkd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ilahi a daan hu gahem nuy ta daw kada amin ku dampaen ulinan daan hu Balaan ha Ispiritu.” ");
INSERT INTO bkd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ba inikagiyan hi Pedro hu “Masilutan ka gayed daw sa salapì nu makalkalan ta abi nu gid ha agkapalit sa gahem ha ig-ila hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hurà nu labet hu buluhaten day ta natun-an hu Dios ha kenà matareng sa henà-henà nu. ");
INSERT INTO bkd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Aman hinulsuli nu hayan daw mag-ampù ka duun hu Ginuu ha pasayluwen din sa madaet ha tuyù nu ");
INSERT INTO bkd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ta naahà ku ha agkasina ka daw naulipen ka gayed hu salà.” ");
INSERT INTO bkd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Dayun tuminubag si Simon hu “Ampui a inyu duun hu Ginuu ta daw harì matuman sa inikagi nu mahitenged kanak.” ");
INSERT INTO bkd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Su makapenga sidan manunultul hu lalang hu Dios luminikù si Pedro daw si Juan diyà ta Jerusalem daw migsangyaw hu Maayad ha Tultulanen duun hu naagiyan dan ha mga banuwa diyà ta Samaria. ");
INSERT INTO bkd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amin balinsuguen hu Dios ha minikagi diyà ki Felipe ha tagyanaen “Dumuun ka taena ha dalan ta Jerusalem ha pakapayanaen ta Gaza, saini pinakabulung-bulung ha lugar.” ");
INSERT INTO bkd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aman duminiyà si Felipe. Su diyà en haena ta dalan naahà din sa sabuwa ha opisyal ha taga-Etiopia ha iyan sinaligan hu alan ha mga butang hu rayna ha si Candace. Suminimba su opisyal diyà ta Jerusalem ");
INSERT INTO bkd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","daw duun taena ha panahun tag-ulì en ha taglulan hu kalesa daw tagbasa hu insulat hi Isaias sa propita. ");
INSERT INTO bkd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dayun inikagiyan hu Balaan ha Ispiritu si Felipe ha “Ubay ka diyà tayà ha kalesa.” ");
INSERT INTO bkd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aman uminagpas uminubay si Felipe daw napaliman din ha tagbasa haena sa opisyal ku insulat hi Isaias sa propita. Dayun ininsaan din haena hu “Agkasabut nu ba hayana sa tagbasahen nu?” ");
INSERT INTO bkd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tuminubag su opisyal hu “Harì ta hurà man tagtudlù kanak.” Aman hinangyù din si Felipe ha lumulan daan duun ku kalesa. ");
INSERT INTO bkd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sa lalang hu Dios ha tagbasahen ku opisyal iyan haini “Iling haena hu karniro ha harì ag-iyagak ku ag-iyawen daw iling daan hu nati hu karniro ha mahagteng ku agtabulugen. ");
INSERT INTO bkd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pinagagayhaan haena daw sinilutan bisan ku hurà din salà. Hurà gayed masaysay ha kaliwat din daw laus dan dà haena inawà dini ta kalibutan.” ");
INSERT INTO bkd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nanginginsà su opisyal diyà ki Felipe hu “Sin-u man sa tagsubayen taini ha propita? Iyan ba sa kaugalingen din daw ku lain en ba ha etaw?” ");
INSERT INTO bkd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dayun insaysay kandin hi Felipe sa Maayad ha Tultulanen mahitenged ki Jesus sugud duun taena ha bahin hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hurà kalugay nakauma sidan duun hu wahig aman minikagi su opisyal hu “Taini en sa wahig. Harì ba mabaluy ha bautismuwan ad iman ikaw?” ");
INSERT INTO bkd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Tuminubag si Felipe ha “Ku laus gayed sa pagtuu nu mabaluy hayan.” Minikagi su opisyal ha “Tuminuu a gayed ha si Jesu Cristo Batà hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Impataleen ku opisyal su kalesa dayun duminiyà sidan ta wahig daw bautismuwi haena hi Felipe. ");
INSERT INTO bkd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Su makagaun en sidan tinimù si Felipe hu Balaan ha Ispiritu aman hurà en kaahà ku opisyal. Ba duminayun su opisyal ha malipayen gayed. ");
INSERT INTO bkd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Si Felipe diyà en hu kandin naahà ta Asoto sa tagsangyaw hu Maayad ha Tultulanen duun hu alan ha mga banuwa taman ha nakauma haena diyà ta Cesarea. ");
INSERT INTO bkd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Duun taena ha panahun si Saulo sigi agpanhulgà ha aghimatayan din sa mga tuminuu hu Ginuu. Duminuun haena hu tungkay labaw ha sinaligan hu paghalad ");
INSERT INTO bkd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","daw nanayù hu sulat payanaen hu mga simbahan hu mga Judio diyà ta Damasco ta daw matugutan hu pagdakep taena ha masapenan din ha tagsunud hu tinuuwan mahitenged ki Jesus daw bakusen din dayun ipapurisu sidan diyà ta Jerusalem sa mga maama daw sa mga bahi. ");
INSERT INTO bkd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ba su ubay en si Saulo diyà ta Damasco tigkan nakabulus diyà ta kandin sa masiga. ");
INSERT INTO bkd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aman naligid haena diyà ta bugtà dayun napaliman din sa lageng ha tagyanaen “Saulo, imbà a man ikaw tagpasipalahi?” ");
INSERT INTO bkd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tuminubag si Saulo hu “Sin-u ka man, Ginuu?” Uminikagi haena hu “Iyan a si Jesus sa tagpasipalahan nu. ");
INSERT INTO bkd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bangun ka daw diyà ka tayà ha banuwa ta amin diyà magtudlù ikaw hu kinahanglan ha buhaten nu.” ");
INSERT INTO bkd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Su mga duma hi Saulo bà su nangaemaw ta amin dan napaliman ba hurà dan agkaahà. ");
INSERT INTO bkd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Minangun si Saulo ba su paggimata din harì en pakaindan aman kinipitan dan payanaen diyà ta Damasco. ");
INSERT INTO bkd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tatulu ha aldaw ha si Saulo harì pakaindan aman hurà haena kaen daw hurà daan inum. ");
INSERT INTO bkd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Diyà ta Damasco amin tumutuu ha tagngaranan ki Ananias. Inikagiyan haena hu Ginuu pinaagi hu panan-awen ha tagyanaen “Ananias.” Tuminubag hu “Taini a, Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Inikagiyan haena hu Ginuu ha “Dumiyà ka ta balay hi Judas duun hu dalan ha tagngaranan ta Matul-id daw pan-ahaa sa etaw ha taga-Tarso ha tagngaranan ki Saulo ta tag-ampuay iman haena diyà. ");
INSERT INTO bkd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Pinaagi hu panan-awen naahà ka kandin ha duminiyà ka daw inibitan nu ta daw makaindan.” ");
INSERT INTO bkd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ba si Ananias tuminubag hu “Ginuu, napaliman kud en duun hu madakel ha mga etaw sa madaet ha tultul mahitenged kandin ta pigpasipalahan din sa mga tuminuu ikaw diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Daw sa pagdini din iman iyan sa pagdakep hu mga tuminuu ikaw ta inilahan haena hu katenged hu mga labaw ha sinaligan hu paghalad.” ");
INSERT INTO bkd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ba inikagiyan hu Ginuu si Ananias ha “Dumiyà ka ta pinilì ku haena hu pagpanunultul mahitenged kanak duun hu mga etaw ha kenà Judio daw hu mga harì daw hu mga kaliwatan hi Israel. ");
INSERT INTO bkd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Igpaahà ku kandin ku inu gayed kaadagi sa mga alantusen din tumenged hu pagsunud din kanak.” ");
INSERT INTO bkd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aman si Ananias duminuun taena ha balay. Su makaseled en dinampà din si Saulo daw ikagiyi ha “Suled ku ha Saulo, si Jesus ha Ginuu ha natalagbù nu diyà ta dalan su tagdini ka sinugù a kandin dini ta daw makaindan ka daw ulinan ka hu Balaan ha Ispiritu.” ");
INSERT INTO bkd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sagunà nangaawà diyà ta mata din sa bà su hun-ap aman nakaindan dà paman haena dayun binautismuwan. ");
INSERT INTO bkd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Su pagkaiwas taena kuminaen si Saulo daw nakabis-ay. Duun hu pila ha aldaw migtimà si Saulo duma hu mga tumutuu diyà ta Damasco. ");
INSERT INTO bkd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dayun migtudlù duun hu mga simbahan ha si Jesus Batà hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sa alan ha nakapaliman kandin nangabeleng gayed daw kagi dan “Kenà ba iyan haini su etaw ha nangimatay hu mga tumutuu ki Jesus diyà ta Jerusalem? Daw kenà ba iyan din indini iman sa pagdakep daw pagbakus hu mga tumutuu ta daw ipaatubang duun hu mga labaw ha sinaligan hu paghalad?” ");
INSERT INTO bkd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ba duun taena mig-iseg sa gahem hu pagtudlù hi Saulo aman sa katarengan din ha si Jesus iyan su Mesiyas harì gayed agkatubag hu mga Judio ha tagtimà diyà ta Damasco. ");
INSERT INTO bkd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Su malugay en saena ha mga Judio miglalang-lalang ha himatayan dan si Saulo ");
INSERT INTO bkd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ba natun-an daan haena hi Saulo. Sa mga pultahan taena ha banuwa pinabantayan dan gayed aldaw daw ku daleman ta daw mapatay dan si Saulo ku umagi. ");
INSERT INTO bkd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ba su daleman inuwit hu mga tumutuu si Saulo duun hu kutà taena ha banuwa. Dayun intagù dan haena duun hu ambung daw hawila diyà ta guwà ta daw malibri. ");
INSERT INTO bkd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Su makauma en si Saulo diyà ta Jerusalem agkabayà ngaay ag-amul duun hu mga tumutuu ba agkangahaldek sidan kandin ta abi dan ha bà dà haena tagpasibù-sibù ha tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ba dinumahan hi Bernabe si Saulo duun hu mga apostoles daw tinultulan din sidan hu naul-ulahan hi Saulo diyà ta dalan ha naahà din sa Ginuu daw sa pakiglalang hu Ginuu kandin daw sa kabalaw din hu pagtudlù mahitenged ki Jesus diyà ta Damasco. ");
INSERT INTO bkd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aman nakigduma-duma en dayun si Saulo hu mga tumutuu diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Hurà din gayed kahaldek hu pagpanunultul mahitenged hu Ginuu. Nakigsawalà daan taena ha mga Judio ha Griego sa inikagiyan dan aman agkabayaan dan en ngaay haena aghimatayi. ");
INSERT INTO bkd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Su matun-an haena hu mga tumutuu inuwit dan si Saulo diyà ta Cesarea daw ipaulì diyà ta Tarso. ");
INSERT INTO bkd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Duun taena ha panahun malinawen sa pagtimà hu mga tumutuu duun hu mga probincia ta Judea, ta Galilea daw ta Samaria. Miglig-en sa pagtuu dan daw pinaagi hu pagbulig kandan hu Balaan ha Ispiritu migdakel gayed sidan daw migmatinahuren daan sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pig-eleg-elegan hi Pedro sa migkalain-lain ha banuwa hu pagbisita hu mga tumutuu diyà. Su makauma diyà ta Lida ");
INSERT INTO bkd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","naahà din sa etaw ha tagngaranan ki Eneas ha minatay en sa dibaluy ha lawa din daw bà dà taghidegaay seled hu walu en ha tuig. ");
INSERT INTO bkd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Inikagiyan haena hi Pedro hu “Eneas, bangun kad en daw luluna sa banig nu ta maulian ka hi Jesu Cristo.” Sagunà haena migbangun. ");
INSERT INTO bkd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Sa mga etaw diyà ta Lida daw ta Saron nakaahà taena ha naulian aman nakabig sidan duun hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Diyà ta Jope amin bahi ha tumutuu ha tagngaranan ki Tabita, Dorcas haini duun hu Griego ha inikagiyan ha tagkahulugan hu Madagway. Sigi dà gayed maayad sa mga buhat din daw agbuligan din daan sa taglised. ");
INSERT INTO bkd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ba duun taena ha panahun si Dorcas nadaluwan dayun minatay. Su mapengahan en ilisi duun dan in-ugsak sa lawa din hu kwarto diyà ta latun taena ha balay. ");
INSERT INTO bkd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Su mapaliman hu mga tumutuu ha si Pedro diyà ta Lida sa ubayà dan ha banuwa pinaelegan dan haena hu daruwa ha etaw daw ikagiyi ha “Umagpas ka diyà ta Jope.” ");
INSERT INTO bkd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aman si Pedro duminuma kandan. Su makauma en sidan diyà dinuma dan haena diyà ta latun. Dayun piglilibutan si Pedro hu mga bahi ha balu ha tag-aagalà daw impaahà dan kandin sa mga pinaksuy ha binuhat kandan hi Dorcas su bubuhay pa. ");
INSERT INTO bkd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ba impaguwà sidan hi Pedro dayun luminuhud haena hu pag-ampù. Sumininalu duun ku minatay daw ikagi hu “Tabita, bangun ka.” Guminimata si Dorcas na su maahà din si Pedro mininuu dayun. ");
INSERT INTO bkd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Aman inibitan hi Pedro sa alima din daw ipahitindeg. Inumaw hi Pedro su mga balu ha bahi daw sa duma ha mga tumutuu daw impaahà din kandan si Dorcas sa nabanhaw en. ");
INSERT INTO bkd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Saena ha tultulanen nakalekep diyà ta Jope aman madakel sa tuminuu hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nalugay pa si Pedro diyà ta Jope daw duun migtimà hu balay taena ha etaw ha tagngaranan ki Simon ha mamumuhatà hu bisan inu pinaagi hu anis. ");
INSERT INTO bkd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Diyà ta Cesarea amin etaw ha tagngaranan ki Cornelio ha kapitan hu sundalu ha tagngaranan hu Punduk hu Mga Yaga-Italia. ");
INSERT INTO bkd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Saini bisan ku kenà Judio ba masinimbahen daw matinahuren gayed hu Dios duma hu pamilya din. Kalalagan daan duun hu taglised daw sigi daan tag-ampù duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Amin panahun ha su agkabalalay en sa aldaw amin din panan-awen ha tagdiyà ta kandin sa balinsuguen hu Dios ha minikagi hu “Cornelio.” ");
INSERT INTO bkd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Inahà din haena ba agkahaldekan duun dayun ininsaan din hu “Ginuu, inu man?” Tuminubag su balinsuguen hu “Sa pag-ampù nu daw sa pagbulig nu hu taglised harì agkalipatan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Aman paelegi nu diyà ta Jope si Simon ha tagngaranan daan ki Pedro ");
INSERT INTO bkd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ha diyà tagtimà ta ubay ta dagat duun hu balay hi Simon ha mamumuhatà hu bisan inu pinaagi hu anis.” ");
INSERT INTO bkd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Su umawà en su balinsuguen hu Dios inumaw hi Cornelio sa daruwa ha suluguen din daw su sinaligan din ha sundalu ha masinimbahen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Dayun inikagi din kandan su naahà din daw impadiyà din sidan ta Jope. ");
INSERT INTO bkd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Su maugtu en duun hu isab ha aldaw ha ubay en su mga sinugù hi Cornelio diyà ta banuwa si Pedro duminuun hu atep ku balay hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nagedam din ha agkauhul aman agkabayà ngaay agkaen. Su kamulu pa agsugbaha sa agkan-en dan amin din naahà ha panan-awen ");
INSERT INTO bkd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ha iyan sa napuwaan sa langit daw tagpakabulus sa agkailing hu maluag ha habel ha pinanhiketan sa mga suyuk din. ");
INSERT INTO bkd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sa taglulan taena iyan sa alan ha kalasi hu mananap daw hu bunsalagan daw hu mga tagbis. ");
INSERT INTO bkd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dayun napaliman din sa lageng ha tagyanaen “Pedro, hitindeg ka daw mag-iyaw ka taini ta daw makakaen ka.” ");
INSERT INTO bkd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ba tuminubag si Pedro hu “Harì a, Ginuu, ta hurà a pa makakaen hu mahugaw ha harì igtugut hu Kasuguan.” ");
INSERT INTO bkd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Napaliman din dà paman haena sa lageng ha tagyanaen “Harì nu ag-ikagiya ha mahugaw sa binuhat en hu Dios ha maayad.” ");
INSERT INTO bkd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Katatulu din haena kapaliman dayun su naahà din tigkan nakaligtu diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Su kamulu din pa taghenhenaaya ku inu sa kahulugan taena ha naahà din ha panan-awen nakauma daan su mga sinugù hi Cornelio diyà ta banuwa daw in-insà dan ku hindu sa balay hi Simon. Su diyà en sidan ta pultahan ku balay din ");
INSERT INTO bkd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nanginginsà sidan ku diyà ba tagtimà si Simon ha tagngaranan daan ki Pedro. ");
INSERT INTO bkd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Su kamulu pa taghenhenaay si Pedro taena ha naahà din inikagiyan hu Balaan ha Ispiritu hu “Amin tatulu ha etaw ha tagpan-ahà ikaw. ");
INSERT INTO bkd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lugnà ka daw harì ka tagduwa-duwa hu pagduma kandan ta iyan a migsugù kandan.” ");
INSERT INTO bkd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Aman luminugnà si Pedro daw ikagiyi su mga etaw hu “Iyan a su tagpan-ahaen nuy. Inu sa tuyù nuy?” ");
INSERT INTO bkd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tuminubag sidan hu “Sinugù kay dini hu kapitan hu sundalu ha si Cornelio sa matareng daw masinimbahen hu Dios daw tinahud daan hu alan ha mga Judio. Inikagiyan haena hu balinsuguen hu Dios ha paelegan ka kandin ta daw mapalimanan din sa ag-ikagiyen nu.” ");
INSERT INTO bkd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Aman su mga sinugù impadayun hi Pedro diyà ta seled ta balay. Su maisab ha aldaw duminuma si Pedro kandan daw amin daan mga tumutuu ha taga-Jope ha duminuma kandin. ");
INSERT INTO bkd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nakauma sidan diyà ta Cesarea duun hu ikaduwa ha aldaw. Si Cornelio tagsalapà en daan kandan aman inamul din sa alan ha mga kadumahan din daw sa mga amigu din. ");
INSERT INTO bkd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Su agseled en si Pedro duun ku balay sinal-aw hi Cornelio daw luhud hu pagsimba kandin. ");
INSERT INTO bkd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ba impahitindeg hi Pedro si Cornelio daw ikagiyi hu “Hitindeg ka ta etaw a dà daan.” ");
INSERT INTO bkd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Su taglalang-lalang sidan payanaen diyà ta seled naahà hi Pedro ha nangaamul-amul sa mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Inikagiyan din sidan hu “Natun-an nuy en ha sikay sa mga Judio hurà kay tuguti ha makiglabet-labet hu kenà mga Judio bisan sa pagpamisita kandan. Ba impadayag kanak hu Dios ha hurà ku gayed isipen ha mahugaw ha etaw. ");
INSERT INTO bkd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Aman su paelegan a inyu hurà a gayed magduwa-duwa hu pagdini. Ag-insaan ku iman ikaw ku imbà a ikaw ipadini.” ");
INSERT INTO bkd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tuminubag si Cornelio hu “Haepat en iman ha aldaw su mag-ampù a dini ta balay ha agkabalalay en sa aldaw duun taena iling iman, tigkan nakauma dini ta kanak sa etaw ha tagpangaluanlag sa bisti din. ");
INSERT INTO bkd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Inikagiyan a kandin hu ‘Cornelio, napaliman hu Dios sa pag-ampù nu daw harì din daan agkalipatan sa pagbulig nu hu mga taglised. ");
INSERT INTO bkd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Aman paelegi nu diyà ta Jope si Simon ha tagngaranan daan ki Pedro ha diyà tagtimà ta ubay ta dagat duun hu balay hi Simon ha mamumuhatà hu bisan inu pinaagi hu anis.’ ");
INSERT INTO bkd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aman sagunà ku ikaw pinaelegan na maayad gayed ta duminini ka. Iman naamul-amul kay dini ta agpaliliman kay hu insugù ikaw hu Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Duun taena minikagi si Pedro hu “Laus gayed ha hurà etaw ha igpalabi hu Dios ");
INSERT INTO bkd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ta bisan sin-u ha etaw dini ta kalibutan ku magmatinahuren hu Dios daw magbuhat hu matareng agdawaten din. ");
INSERT INTO bkd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sa Maayad ha Tultulanen ha insangyaw kanay sikay sa mga kaliwatan hi Israel iyan haini sa magmalinawen kuy pinaagi ki Jesu Cristo sa Ginuu hu alan. ");
INSERT INTO bkd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Su maiwas sa pagtudlù hi Juan mahitenged hu bautismu natun-an nuy en sa nahitabù diyà ta Judea sugud diyà ta Galilea ");
INSERT INTO bkd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ha pigpaulinan hu Dios si Jesus ha taga-Nazaret hu Balaan ha Ispiritu daw ginaheman din. Aman migduun-duun si Jesus hu mga banuwa daw binuligan din sa taglised daw naulian din daan sa pinasipalahan hi Satanas ta sa Dios tagduma gayed kandin. ");
INSERT INTO bkd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Makapanistigus kay gayed taini ta naahà day sa alan ha binuhat din diyà ta Jerusalem daw hu mga banuwa diyà ta Judea. Hinimatayan dan haena pinaagi hu paglansanga kandin duun hu krus, ");
INSERT INTO bkd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ba su ikatulu ha aldaw binanhaw dà haena hu Dios daw impaahà din kanay. ");
INSERT INTO bkd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hurà haena kaahà hu alan ha mga etaw ba iyan kay dà sa mga pinilì hu Dios hu pagtistigus taena ta nakigsalu kay kandin su mabanhaw en. ");
INSERT INTO bkd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Daw sinugù kay kandin ha sangyawan day sa mga etaw ha si Jesus iyan gayed pinilì hu Dios ha Maghuhukum hu kaet-etawan sa mga bubuhay daw sa mga minatay en. ");
INSERT INTO bkd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Inikagi en hu alan ha mga propita ha bisan sin-u sa tumuu kandin mapasaylu sa mga salà dan pinaagi hu ngaran hi Jesus.” ");
INSERT INTO bkd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Su kamulu pa si Pedro tag-ikagi sa alan ha tagpaliliman kandin inulinan en hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Su mga tumutuu ha mga Judio ha duminuma ki Pedro nangabeleng gayed ta bisan sa kenà mga Judio pinaulinan daan hu Dios hu Balaan ha Ispiritu ");
INSERT INTO bkd_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ta napaliman dan haena ha nangakaikagi hu harì dan agkasabut ha mga inikagiyan daw migdayè sidan hu Dios. Dayun inikagiyan hi Pedro su mga duma din hu ");
INSERT INTO bkd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Harì ba diay mabaluy ha bautismuwan haini sa kenà mga Judio ha inulinan hu Balaan ha Ispiritu iling kanuy?” ");
INSERT INTO bkd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Aman inikagiyan hi Pedro sa mga kenà Judio ha magpabautismu gayed pinaagi hu ngaran hi Jesu Cristo. Dayun hinangyù dan si Pedro ha magtimà pa diyà ta kandan hu pila ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sa mga apostoles daw sa duma ha mga tumutuu diyà ta Judea nakapaliman ha sa kenà mga Judio tuminuu daan hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Aman su makalikù si Pedro diyà ta Jerusalem amin mga tumutuu ha Judio ha nakigsawalà kandin ");
INSERT INTO bkd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","hu kagi dan “Imbà ka diyà ta balay taena ha kenà Judio daw makigsalu kandan?” ");
INSERT INTO bkd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aman sinaysay gayed hi Pedro kandan sa alan ha naul-ulahan hu kagi din ");
INSERT INTO bkd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Su tag-ampù a diyà ta Jope amin ku panan-awen ha tagpakabulus dini ta kanak ha agkailing hu maluag ha habel ha pinanhiketan sa mga suyuk din. ");
INSERT INTO bkd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Su sulsuliyen ku haena naahà ku duun sa alan ha kalasi hu mga mananap daw hu mga bunsalagan daw hu mga tagbis. ");
INSERT INTO bkd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dayun napaliman ku sa lageng ha tagyanaen ‘Pedro, hitindeg ka daw mag-iyaw ka taini ta daw makakaen ka.’ ");
INSERT INTO bkd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ba tuminubag a hu ‘Harì a, Ginuu, ta hurà a pa makakaen hu mahugaw ha harì igtugut hu Kasuguan.’ ");
INSERT INTO bkd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Dayun napaliman ku dà paman haena sa lageng ha tagyanaen ‘Harì nu ag-ikagiya ha mahugaw sa binuhat en hu Dios ha maayad.’ ");
INSERT INTO bkd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katatulu ku kapaliman haena dayun su naahà ku tigkan nakaligtu diyà ta langit. ");
INSERT INTO bkd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sagunà daan nakauma duun ku balay ha tagtimaan ku sa tatulu ha etaw ha napuun ta Cesarea ha impaeleg kanak. ");
INSERT INTO bkd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Inikagiyan a daan hu Balaan ha Ispiritu ha harì a magduwa-duwa hu pagduma kandan. Haenem ha mga tumutuu sa duminuma kanak diyà ta Cesarea daw sumineled kay diyà ta balay hi Cornelio. ");
INSERT INTO bkd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Inikagiyan kay daan hi Cornelio ha migpaahà kandin sa balinsuguen hu Dios diyà ta balay din ha tagyanaen ‘Paelegi nu si Simon ha tagngaranan daan ki Pedro diyà ta Jope ");
INSERT INTO bkd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ta itultul din ikaw sa paagi ha maluwas ka daw sa pamilya nu.’ ");
INSERT INTO bkd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Su tag-ikagi ad en diyà ta kandan tigkan sidan inulinan hu Balaan ha Ispiritu iling daan kanuy su anay. ");
INSERT INTO bkd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nahenhenaan ku dayun sa lalang hu Dios ha tagyanaen ‘Si Juan diyà namautismu ta wahig ba sa igbautismu ku iyan sa paulinan kaw hu Balaan ha Ispiritu.’ ");
INSERT INTO bkd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Aman ku iyan sa Dios migpaulin kandan hu Balaan ha Ispiritu iling daan kanuy su anay kuy makatuu ki Jesu Cristo ha Ginuu, sin-u a man ha magbaldeng hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Su mapaliman dan haena nakaghagteng sidan dayun dinayè dan sa Dios hu kagi dan “Intugut diay daan hu Dios ha sa kenà mga Judio makaghinulsul daw mailahan hu kinabuhì ha hurà din katapusan.” ");
INSERT INTO bkd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Su pasipalahan sa mga tumutuu sugud hu kahimatayi ki Esteban nakagsusuwayà sidan. Sa duma kandan nakapulaguy payanaen duun hu nasud ta Fenicia daw duun hu pulù ta Cipro daw banuwa ta Antiokia. Nanunultul sidan hu lalang hu Dios ba duun dà hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ba su makauma diyà ta Antiokia sa duma ha mga tumutuu ha napuun diyà ta Cipro daw Cirene tinultulan dan daan sa mga etaw ha kenà Judio mahitenged ki Jesus ha Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tumenged ta pigpanalanginan hu Dios sa pagpanunultul dan madakel gayed ha mga etaw sa nakabig duun hu pagtuu hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Saena ha tultulanen napaliman hu mga tumutuu diyà ta Jerusalem aman impadiyà dan si Bernabe ta Antiokia. ");
INSERT INTO bkd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Su makauma haena diyà naahà din sa pagpanalangin hu Dios kandan aman nabayà-bayà gayed. Pigdasig din ha maniguru gayed sidan daw harì umendà hu pagtuu duun hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Saini si Bernabe maayad ha etaw daw mabis-ay sa pagtuu din tumenged ta inulinan hu Balaan ha Ispiritu. Aman madakel gayed ha mga etaw sa nakaisab kandan duun hu pagtuu hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Dayun duminiyà si Bernabe ta Tarso hu pagpan-ahà ki Saulo. ");
INSERT INTO bkd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Su maahà din haena dinuma din diyà ta Antiokia. Nangkatuig sa pagpakig-amul-amul dan hu mga tumutuu diyà daw tinudluan dan sa madakel tungkay ha mga etaw. Diyà ta Antiokia napuunaan sa kangarani hu mga tumutuu ha Cristohanen. ");
INSERT INTO bkd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Duun taena ha panahun amin mga etaw ha pakasaysay hu igpaikagi hu Dios saena nakauma diyà ta Antiokia ha napuun ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sa sabuwa kandan ha iyan si Agabo sa inulinan hu Balaan ha Ispiritu huminitindeg daw ikagiyi sa mga tumutuu ha pakauma sa adagi ha kauhul dini ta tibuuk ha kalibutan. Saena natuman gayed su pagharì en hi Claudio. ");
INSERT INTO bkd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aman sa mga tumutuu diyà ta Antiokia mig-uyun ha buligan dan sa mga suled dan hu pagtuu ha diyà tagtimà ta probincia ta Judea sumalà hu mabaug hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Binuhat dan haena daw sugua si Bernabe daw si Saulo hu pag-uwit taena duun hu mga pangulu hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Duun taena ha panahun impadakep hi Harì Herodes sa duma ha tumutuu ta agpasipalahan din. ");
INSERT INTO bkd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pinapungulan din si Santiago sa suled hi Juan pinaagi hu ispada. ");
INSERT INTO bkd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Su matun-an hi Herodes ha saena nabayà-bayaan hu mga Judio impadakep din daan si Pedro. Panahun haena ha agsaulugen dan sa Pagkaen hu Supas ha Hurà Duun Igpatulin. ");
INSERT INTO bkd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Su madakep en si Pedro impapurisu din daw pinabantayan hu haepat ha punduk hu mga sundalu ha tighaepat sa kada punduk duun, ta sa henà-henà din ha ku maiwas sa pagsaulug hu Aldaw hu Paglabay agbistigahen si Pedro duun hu atubangan hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aman binantayan gayed haena diyà ta purisuwan. Ba sa mga tumutuu naniguru gayed hu pag-ampù duun hu Dios mahitenged kandin. ");
INSERT INTO bkd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Duun hu daleman taena ha aldaw sa harì pa igpaatubang si Pedro hi Herodes duun hu kaet-etawan, diyà ta purisuwan tagtidugahà si Pedro sa pinusasan ha pigpataliwaraan hu daruwa ha sundalu daw amin pa gayed mga bantay diyà ta pultahan. ");
INSERT INTO bkd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ba tigkan nakauma sa balinsuguen hu Dios ha nakailaw diyà ta seled taena ha purisuwan. Inibitan din si Pedro daw pukawa dayun inikagiyan din hu “Agpas ka bangun.” Sagunà nangatangtang su pusas diyà ta alima hi Pedro. ");
INSERT INTO bkd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Dayun inikagiyan ku balinsuguen hu “Magpinaksuy ka daw magsapatus.” Aman tinuman haena hi Pedro. Dayun inikagi en paman ku balinsuguen ha “Mag-ambal ka daw lupug ka kanak.” ");
INSERT INTO bkd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Aman luminupug kandin si Pedro ba abi din ha bà dà tagdamugu ha agbuligan hu balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Su makalabay en sidan duun ku nauna daw ikaduwa ha tagbantay nakauma sidan duun hu puthaw ha pultahan payanaen ta banuwa ha sinirahan. Ba tigkan haena napuwaan aman nakaagi sidan duun. Su makadiyù-diyù en sidan tigkan din nahanaw su balinsuguen hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Dayun nakatanud si Pedro daw nakaikagi hu “Laus diay ha migsugù sa Dios hu balinsuguen din dini ta kanak ta daw malibri a duun hu mahitabù ha tagsalapen hu mga Judio daw duun hu madaet ha agbuhaten ngaay kanak hi Herodes.” ");
INSERT INTO bkd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Aman duminayun haena diyà ta balay hi Maria sa inay hi Juan ha tagngaranan daan ki Marcos ha duun mig-amul-amul sa madakel ha mga tumutuu hu pag-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Su mangumaw si Pedro diyà ta guwà su suluguen ha tagngaranan ki Roda tuminalagbù kandin. ");
INSERT INTO bkd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ba su makilala din ha iyan diay si Pedro hurà din en kapuwai sa pultahan tumenged hu kabayà-bayà din ba bà dà minulaguy diyà ta seled daw tultula ha si Pedro didiyà en ta guwà. ");
INSERT INTO bkd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ba bà dan dà inikagiyi hu “Agkalibeg ka gid.” Ba tuminubag haena hu “Iyan labi si Pedro.” Aman minikagi sidan hu “Kalag din dà haena.” ");
INSERT INTO bkd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ba si Pedro sigi pa gayed tagpangumawà. Ben pinuwai dan en su pultahan dayun naahà dan si Pedro aman nangabeleng gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Siningyasan sidan hi Pedro ha maghagteng sidan dayun inikagi din kandan ku pig-inu-inu hu Dios sa pagpaguwà kandin diyà ta purisuwan, daw inikagiyan din sidan ha tultulen dan haena diyà ki Santiago daw duun hu mga suled dan hu pagtuu. Dayun uminawà si Pedro diyà ta kandan daw duminuun hu lain ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Su maselem en adagi gayed sa kasamuk hu mga sundalu ku nainu-inu si Pedro. ");
INSERT INTO bkd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Aman impapan-ahà hi Herodes ba hurà dan en katulen si Pedro. Dayun impabistiga din su mga bantay daw pahimatayi. Su maiwas haena uminawà si Herodes diyà ta Judea daw diyà en migtimà ta Cesarea. ");
INSERT INTO bkd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Duun taena ha panahun napaukan gayed hi Herodes sa mga etaw diyà ta Tiro daw ta Sidon, aman migdengan sidan hu pagdiyà hu pagpakighusay kandin ta sa pagkaen dan duun agkatimù hu bugtà ha sakup hu ginharian hi Herodes. Hinangyù dan ha mulig kandan si Blasto sa sinaligan hu balay taena ha harì. ");
INSERT INTO bkd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Su mauma sa aldaw ha iyan natugun ha maghusayà sidan migbisti si Herodes hu harianen ha bisti daw migpinuu duun hu trono din daw minikagi duun hu atubangan dan. ");
INSERT INTO bkd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dayun namangulahì sa mga etaw hu kagi dan “Sayana ha tag-ikagi kenà etaw dà ba diyus en.” ");
INSERT INTO bkd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Sagunà sinilutan hu balinsuguen hu Dios si Herodes pinaagi hu dalu tumenged ta dinawat din sa pagdayè ha para dà ngaay hu Dios. Dayun inuledan sa lawa din daw minatay haena. ");
INSERT INTO bkd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sa lalang hu Dios nakalekep gayed daw migdakel sa mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Su mapengahan hi Bernabe daw hi Saulo sa buluhaten dan diyà ta Jerusalem luminikù sidan diyà ta Antiokia daw dinuma dan si Juan ha tagngaranan daan ki Marcos. ");
INSERT INTO bkd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Duun hu tagkaamul-amul ha mga tumutuu diyà ta Antiokia amin mga etaw ha pakasaysay hu igpaikagi hu Dios daw saena manunudlù daan ha iyan si Bernabe, si Saulo daw si Simeon ha tagngaranan daan ki Niger, si Lucio ha taga-Cirene daw si Manaen sa duun en mig-adagi hu pamilya hu amay hi Harì Herodes. ");
INSERT INTO bkd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Amin aldaw ha suminalang sidan hu pagkaen ta daw harì maelangan sa pagsimba dan hu Dios. Inikagiyan sidan hu Balaan ha Ispiritu hu “Pilia nuy si Bernabe daw si Saulo ta amin buluhaten ha intagana ku kandan.” ");
INSERT INTO bkd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Su maiwas en sa pag-ampù dan daw sa pagsalang dan hu pagkaen pinagaheman si Bernabe daw si Saulo pinaagi hu pagdampà dan kandan dayun impahipanaw sidan. ");
INSERT INTO bkd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Impahipanaw hu Balaan ha Ispiritu si Bernabe daw si Saulo daw dinuma dan si Juan ha tagngaranan daan ki Marcos ta daw makabulig kandan. Aman duminiyà sidan ta Seleucia daw lulan hu barko payanaen ta pulù ta Cipro. Su makauma sidan diyà ta Salamina intultul dan sa lalang hu Dios duun hu mga simbahan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Su diyà en sidan ta Papos ha dibaluy taena ha pulù natalagbù dan sa salamangkiro ha Judio ha tagngaranan ki Bar-Jesus ha tagpasibù-sibù ha pakasaysay hu igpaikagi hu Dios, ");
INSERT INTO bkd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","saena sinaligan daan ku matatau ha gubernador diyà ha iyan si Sergio Paulo. Pinaelegan ku gubernador si Bernabe daw si Saulo ta agkabayà agpaliliman hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ba si Bar-Jesus ha tagngaranan daan ki Elimas ha tagkahulugan hu Salamangkiro suminupak kandan daw nan-ahà hu paagi ha harì makatuu su gubernador. ");
INSERT INTO bkd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ba si Saulo ha pigngaranan daan ki Pablo ha inulinan hu Balaan ha Ispiritu migtengteng diyà ta kandin ");
INSERT INTO bkd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","daw ikagi hu “Sikaw sa agkailing ki Satanas, agsupak ka gayed hu alan ha matareng daw mangingilad ka gayed ta agbuhaten nu ha bidù sa lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iman silutan ka hu Dios daw mabuta ka hu malugayad ha panahun.” Sagunà nabuta si Elimas aman nakadugung-dugung hu pagpan-ahà hu makakipit kandin. ");
INSERT INTO bkd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Su maahà ku gubernador sa nahitabù nakatuu haena ta nabeleng gayed hu katudluanan mahitenged hu Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Si Pablo daw sa mga duma din uminawà diyà ta Papos daw lulan hu barko payanaen ta Perga ha sakup ta Pamfilia. Su makauma sidan diyà inawaan sidan hi Juan Marcos ta uminulì en haena diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ba say Pablo duminayun diyà ta Antiokia ha sakup ta Pisidia. Su aldaw hu Sabado sumineled sidan duun hu simbahan hu mga Judio daw pinuu. ");
INSERT INTO bkd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Su mapengahan sa pagbasa hu Kasuguan daw hu mga insulat hu propita huminangyù sa mga punuan taena ha simbahan diyà kay Pablo hu kagi dan “Mga suled, amin nuy ba maikagi ha salambagan duun hu mga etaw?” ");
INSERT INTO bkd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aman si Pablo huminitindeg daw singyasi sa mga etaw ha maghagteng dayun minikagi hu “Mga suled ku ha kaliwat hi Israel daw sinyu daan sa alan ha masinimbahen hu Dios, palilimani a inyu. ");
INSERT INTO bkd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Sa Dios taw sikuy sa mga Judio iyan migpilì hu mga gin-apuan taw su anay daw pigpanalanginan din sidan aman migdakel sidan su panahun ha langyaw sidan diyà ta Ehipto. Pinaagi hu pagkagamhanan hu Dios pigpangagalenan din sidan diyà ");
INSERT INTO bkd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","daw duun hu kapatan ha tuig inantus din sa pagkamasinupaken dan duun taena ha pinakabulung-bulung ha lugar. ");
INSERT INTO bkd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pinaagi hu gahem hu Dios nadaeg dan su pitu ha ginharian diyà ta Canaan daw in-ila hu Dios kandan haena sa bugtà dan ha mahimu ha kabilin duun hu mga kaliwatan hi Israel. Nahitabù haena seled hu 450 ha tuig. ");
INSERT INTO bkd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Su maiwas haena amin pinilì hu Dios ha mga pangulu dan taman su mauma sa panahun ha iyan si Samuel propita. ");
INSERT INTO bkd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Duun taena ha panahun sa kaet-etawan nanayù duun hu Dios hu harì dan aman in-ila kandan si Saulo sa batà hi Cis ha kaliwat hi Benjamin. Saena migharì hu kapatan ha tuig. ");
INSERT INTO bkd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Su awaen en hu Dios si Saulo hu pagkaharì pinilì din si David ha iyan en paman magharì kandan. Sa Dios minikagi mahitenged kandin hu ‘Si David sa batà hi Jese nabayà-bayaan ku ta matinumanen gayed kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Si David iyan gin-apuan hi Jesus sa Manluluwas ha impadini hu Dios ta kanuy sikuy sa mga kaliwat hi Israel ta iyan haena insaad din kanuy. ");
INSERT INTO bkd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Su hurà pa si Jesus magsugud hu buluhaten din si Juan ha Bautista migtudlù en ha kinahanglan ha maghinulsul kuy daw magpabautismu kuy sikuy sa mga kaliwat hi Israel. ");
INSERT INTO bkd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Su agkapengahan en sa buluhaten hi Juan inikagiyan din sa mga etaw hu ‘Abi nuy gid ha iyan ad su tagsalapen nuy. Ba kenà a iyan ta amin pakadini ha labaw dì kanak ta bisan sa paghukad hu sapatus din kenà a gayed angayan duun.’ ");
INSERT INTO bkd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mga suled ku ha kaliwat hi Abraham daw sinyu daan sa alan ha matinahuren hu Dios, iyan kuy pinauwitan hu Maayad ha Tultulanen mahitenged hu igkaluwas taw. ");
INSERT INTO bkd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ba sa mga Judio diyà ta Jerusalem daw sa mga punuan hurà dan kakilala si Jesus ha iyan diay sinugù hu Dios, ba pinaagi hu kahukumi dan kandin hu kamatayen natuman dan sa insulat hu mga propita ha tagbasahen kada Sabado. ");
INSERT INTO bkd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Bisan pa ku hurà dan naahà ha salà taena ha angayan hu kamatayen ba hinangyù dan diyà ki Pilato ha pahimatayan din. ");
INSERT INTO bkd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Su matuman dan en sa alan ha inikagi hu propita mahitenged kandin inawà dan haena duun hu krus daw ilebeng. ");
INSERT INTO bkd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ba binanhaw haena hu Dios ");
INSERT INTO bkd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","daw duun hu pila ha aldaw migpaahà taena ha namanduma kandin su anay ha napuun ta Galilea payanaen ta Jerusalem. Iyan daan sidan pakapanistigus iman mahitenged kandin duun hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Aman nakadini kay iman hu pagsangyaw inyu hu Maayad ha Tultulanen ha sa insaad hu Dios duun hu mga gin-apuan taw su anay ");
INSERT INTO bkd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tinuman din en para kanuy sikuy sa mga kaliwat dan pinaagi hu pagkabanhaw hi Jesus. Insulat daan haini duun hu ikaduwa ha Salmo ha tagyanaen ‘Batà ku ikaw na iman taini ha aldaw igpaahà ku ha iyan a Amay nu.’ ");
INSERT INTO bkd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Daw mahitenged hu pagkabanhaw din ha harì en isab matay tagyanaen daan ‘Panalanginan ku gayed iman inyu sumalà hu insaad ku diyà ki David.’ ");
INSERT INTO bkd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Duun daan hu lain ha Salmo tagyanaen si David ‘Harì nu itugut ha maledak haini sa lawa ku siak sa sinugù nu.’ ");
INSERT INTO bkd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Natun-an taw ha si David sa migmatinumanen hu Dios minatay daw inlebeng duma hu mga gin-apuan din daw naledak sa lawa din. ");
INSERT INTO bkd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ba si Jesus sa binanhaw hu Dios hurà kaledak. ");
INSERT INTO bkd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Aman mga suled, agkabayaan day ha matun-an nuy ha pinaagi ki Jesus igtultul iman inyu sa ikapasaylu hu mga salà nuy. ");
INSERT INTO bkd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kenà pinaagi hu pagtuman hu Kasuguan hi Moises ha malibri kuy hu mga salà taw ba pinaagi dà hu pagtuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Aman mag-andam kaw ha harì mahitabù diyan ta inyu sa lalang hu Dios ha insulat hu mga propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sinyu sa tagtameyes, mabeleng kaw gayed hu tagbuhaten ku. Ba harì nuy haini agtuuwan bisan ku ag-ikagiyen en inyu aman mangamatay kaw.’” ");
INSERT INTO bkd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Su agguwà en si Pablo daw si Bernabe duun taena ha simbahan hinangyù sidan hu mga etaw ha lumikù dà sidan duun hu isab ha Sabado ta daw isab dà sidan makapanudlù. ");
INSERT INTO bkd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Su mapengahan en sa pag-amul-amul dan diyà ta simbahan duminuma ki Pablo daw ki Bernabe sa madakel ha mga Judio daw sa kenà mga Judio ha masinimbahen hu Dios ha nakabig duun hu tinuuwan dan. Pigdasig hay Pablo ha harì sidan umendà hu pagsalig duun hu grasya hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Su maisab ha Sabado madakel gayed tungkay sa nangaamul-amul duun taena ha simbahan hu pagpaliliman hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ba su maahà haena hu mga Judio nasina sidan aman sinupak dan sa inikagi hi Pablo daw pigtameyes dan daan. ");
INSERT INTO bkd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ba si Pablo daw si Bernabe hurà gayed kahaldek aman minikagi sidan hu “Kinahanglan gayed ha sinyu sa mga Judio iyan kaw unahan tultulan hu lalang hu Dios. Ba tumenged ta hurà nuy dawata inisip nuy ha kenà kaw angayan hu kinabuhì ha hurà din katapusan. Aman agduun kay iman hu mga etaw ha kenà Judio ");
INSERT INTO bkd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ta iyan haini inikagi kanay hu Dios ‘Pinilì ku inyu ha sulù ha makailaw duun hu mga etaw ha kenà Judio ta daw pinaagi hu pagpanunultul nuy maluwas sa kaet-etawan dini ta tibuuk ha kalibutan.’” ");
INSERT INTO bkd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Su mapaliman haena hu kenà mga Judio nangalipay gayed sidan daw dinayè dan sa lalang hu Dios. Dayun tuminuu haena sa daan en pinilì ha mailahan hu kinabuhì ha hurà din katapusan. ");
INSERT INTO bkd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sa lalang hu Dios nakalekep duun taena ha mga banuwa. ");
INSERT INTO bkd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ba sa mga tinahud daw masinimbahen ha mga bahi daw daan sa mga tinahud ha mga maama duun taena ha banuwa pigdasig hu mga Judio diyà ha pasipalahan dan si Pablo daw si Bernabe, aman binugaw dan say Pablo diyà. ");
INSERT INTO bkd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Su umawà en say Pablo pinugpug dan sa aliyabuk diyà ta paa dan ha iyan timaan ha silutan gayed haena hu Dios, dayun duminiyà sidan ta Iconio. ");
INSERT INTO bkd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Sa mga tumutuu diyà ta Antiokia nangabayà-bayà gayed daw inulinan daan sidan hu Balaan ha Ispiritu. ");
INSERT INTO bkd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Diyà ta Iconio si Pablo daw si Bernabe sumineled duun hu simbahan hu mga Judio daw migtudlù aman madakel gayed ha mga Judio daw kenà mga Judio sa tuminuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ba sa mga Judio ha hurà tuu pigdasig dan sa kenà mga Judio ha paukan dan sa mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Migtimà si Pablo daw si Bernabe diyà hu malugayad ha panahun daw hurà dan daan kahaldek hu pagpanunultul hu lalang hu Dios. Ginaheman sidan hu Dios ta daw makabuhat sidan hu mga belenganen ha iyan timaan ha laus gayed sa intultul dan mahitenged hu grasya din. ");
INSERT INTO bkd_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nabahin sa mga etaw duun taena ha banuwa, sa duma kandan tuminuu hu mga Judio daw sa duma tuminuu daan hu mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dayun mig-uyun sa mga Judio daw sa kenà mga Judio duma hu mga punuan ha pasipalahan dan si Pablo daw si Bernabe daw batuwen dan sidan taman ha matay. ");
INSERT INTO bkd_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ba su mapaliman haena hi Pablo daw hi Bernabe minulaguy sidan diyà ta Listra daw ta Derbe ha sakup ta Liconia. Duminuun sidan hu ubayà ha mga banuwa ");
INSERT INTO bkd_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","daw migdayun sidan hu pagsangyaw hu Maayad ha Tultulanen mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Diyà ta Listra amin tagpinuuwà ha etaw ha daan en pigket su ibatà ha hurà en gayed makahipanaw, ");
INSERT INTO bkd_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","saena migpaliliman gayed hu pagpanunultul hi Pablo. Dayun inahà haena hi Pablo daw natun-an din ha amin gayed pagtuu taena ha etaw ta daw maulian. ");
INSERT INTO bkd_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Aman inikagiyan din hu “Hitindeg ka.” Sagunà huminitindeg daw maghiphipanaw. ");
INSERT INTO bkd_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ba su maahà hu kaet-etawan sa binuhat hi Pablo nangulahì sidan duun hu Licaonian ha inikagiyan hu “Sa mga diyus duminini ta kanuy ha agkailing hu etaw.” ");
INSERT INTO bkd_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pigngaranan dan si Bernabe ki Zeus daw si Pablo pigngaranan dan daan ki Hermes ta iyan tagsangyaw. ");
INSERT INTO bkd_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Diyà ta guwà taena ha banuwa duun sa simbahan dan ha duun tagsimbaha si Zeus. Aman su sinaligan hu paghalad ki Zeus mig-uwit hu mga turu ha baka ha sinalayan hu mga bulak diyà ta pultahan taena ha banuwa ta sa mga etaw agkabayà taghalad duun ku mga apostoles. ");
INSERT INTO bkd_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ba su mapaliman haena hi Bernabe daw hi Pablo pigyahà dan sa mga bisti dan tumenged ta napauk sidan, dayun minulaguy duun ku mga etaw daw kinulahì dan ha ");
INSERT INTO bkd_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Imbà nuy tagbuhata haini? Mig-iling kuy dà ha etaw. Duminini kay ta daw masangyawan day inyu hu Maayad ha Tultulanen ta daw maendaan nuy sa hurà din pulus ha tinumanan daw tuuwan nuy sa bubuhay ha Dios ha iyan migtanghagà ta langit daw ta kalibutan, ta dagat daw sa alan ha duun taena. ");
INSERT INTO bkd_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Su anay impatayà hu Dios sa kaet-etawan pagbuhat hu bisan inu ha agkabayaan dan. ");
INSERT INTO bkd_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ba amin daan paagi ha makilala taw haena ta pinandayaan kuy kandin daw pinaudanan kuy kandin daw bungahan daan sa pamulahen taw aman mangabayà-bayà kuy ta amin taw kalan-enen.” ");
INSERT INTO bkd_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Bisan pa taena ha inikagi hi Pablo apit din en harì agkabaldeng sa mga etaw hu paghalad diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Amin daan mga Judio ha napuun ta Antiokia daw ta Iconio ha nakauma diyà ta kandan aman pigdasig dan sa mga etaw ha paukan dan si Pablo. Dayun pigbatu dan si Pablo daw guyuda diyà ta guwà taena ha banuwa ta abi dan ha minatay en. ");
INSERT INTO bkd_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ba su taglilibutan haena hu mga tumutuu migbangun dà si Pablo daw likù diyà ta banuwa. Su maisab ha aldaw duminayun sidan ki Bernabe diyà ta Derbe. ");
INSERT INTO bkd_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Su makasangyaw en hi Pablo daw hi Bernabe sa Maayad ha Tultulanen diyà ta Derbe madakel gayed sa tuminuu ki Jesus. Dayun luminikù sidan diyà ta Listra, ta Iconio daw ta Antiokia ha sakup ta Pisidia. ");
INSERT INTO bkd_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pigdasig dan sa mga tumutuu diyà ha harì umendà hu pagtuu ba maniguru gayed. Inikagiyan dan sidan hu “Sikuy sa mga tumutuu madakel sa maagiyan taw ha alantusen daw human taw kauma sa tagharian hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Su mapilì dan en sa mga pangulu duun hu mga punduk hu tagkaamul-amul ha mga tumutuu diyà suminalang sidan hu pagkaen ta daw harì maelangan sa pag-ampù dan. Dayun insalig dan sidan duun hu Dios ha iyan pigtuuwan dan. ");
INSERT INTO bkd_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","25","Si Pablo daw si Bernabe uminagi diyà ta probincia ta Pisidia dayun nakauma sidan diyà ta Perga ha sakup ta Pamfilia. Su makapanunultul en sidan diyà hu lalang hu Dios duminayun sidan diyà ta Atalia. ");
INSERT INTO bkd_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Diyà ta Atalia luminulan sidan hu barko daw likù ta Antiokia ha duun sidan su anay inampui hu mga tumutuu ha buligan sidan hu Dios duun hu buluhaten ha insugù din kandan ha iman napengahan dan en. ");
INSERT INTO bkd_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Su makauma sidan diyà inamul dan sa alan ha mga tumutuu daw tultuli hu alan ha binuhat hu Dios pinaagi kandan daw ku inu sa paagi ha binuhat din ta daw makatuu sa kenà mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Migtimà sidan diyà hu malugayad ha panahun duma hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Amin mga etaw ha duminiyà daan ta Antiokia ha napuun ta Judea ha sa intudlù dan duun hu mga tumutuu iyan sa “Ku harì kaw masirkunsidahan sumalà hu Kasuguan hi Moises harì kaw gayed maluwas.” ");
INSERT INTO bkd_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aman si Pablo daw si Bernabe nakigsawalà gayed taena ha mga etaw. Su harì en sidan agkahusay pinilì si Pablo daw si Bernabe daw sa duma ha mga tumutuu ha dumiyà ta Jerusalem duun hu mga apostoles daw hu mga pangulu hu mga tumutuu diyà mahitenged taena ha pigsawalaan dan. ");
INSERT INTO bkd_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Dayun impahipanaw sidan hu mga tumutuu. Duun sidan nakaagi hu mga probincia ta Fenicia daw ta Samaria daw intultul dan ku nainu-inu sa pagpakatuu hu kenà mga Judio. Aman adagi gayed sa kalipay hu alan ha mga tumutuu diyà. ");
INSERT INTO bkd_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Su makauma en sidan diyà ta Jerusalem dinawat sidan hu mga tumutuu daw hu mga apostoles daw hu mga pangulu hu mga tumutuu. Dayun intultul dan sa alan ha binuhat hu Dios pinaagi kandan. ");
INSERT INTO bkd_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ba amin daan mga tumutuu ha sakup hu mga Fariseo ha huminitindeg daw ikagi hu “Kinahanglan gayed ha sirkunsidahan sa kenà mga Judio ha tuminuu daw tumanen dan gayed sa Kasuguan hi Moises.” ");
INSERT INTO bkd_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Mig-amul-amul sa mga apostoles daw sa mga pangulu hu tumutuu hu pagsusi taena. ");
INSERT INTO bkd_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Su mapengahan sa malugayad ha paglalang-lalang huminitindeg si Pedro daw ikagi hu “Mga suled, natun-an nuy en ha su anay iyan a pinilì hu Dios hu pagsangyaw hu Maayad ha Tultulanen duun hu kenà mga Judio ta daw makatuu sidan. ");
INSERT INTO bkd_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Sa Dios ha nakatuen hu henà-henà hu etaw impaahà din ha dinawat din sidan pinaagi hu pagpaulin kandan hu Balaan ha Ispiritu iling hu binuhat din dini ta kanuy su anay. ");
INSERT INTO bkd_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hurà din isipa ha lain en dì kanuy sa kenà mga Judio ta linimpyuwan din en sa mga henà-henà dan pinaagi hu pagtuu dan. ");
INSERT INTO bkd_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Imbà nuy harì agdawata sa paagi hu Dios? Imbà nuy agpegesa sa mga tumutuu hu pagtuman taena ha Kasuguan ha bisan sa mga gin-apuan taw daw sikuy iman harì pakatuman taena? ");
INSERT INTO bkd_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tagtuu kuy ha pinaagi dà gayed hu grasya hi Jesus ha Ginuu naluwas kuy. Iling daan kanuy sa kenà mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nakahagteng sa alan ha naamul-amul su tagpaliliman sidan hu tultulanen hi Bernabe daw hi Pablo mahitenged hu mga timaan daw belenganen ha impaahà hu Dios pinaagi kandan duun hu kenà mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Su makapenga en sidan umikagi si Santiago uminikagi daan hu “Mga suled, palilimani a inyu. ");
INSERT INTO bkd_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Inikagi en kanuy hi Simon Pedro ku pig-inu-inu hu Dios ha makatuu sa kenà mga Judio ta daw amin daan diyà ta kandan makasunud hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nakasulat en haini hu mga propita ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ku maiwas haini aglikù a diyan ta inyu daw agbalayen ku dà sa napilay ha balay hi David ta dayunen ku sa pagharì din. ");
INSERT INTO bkd_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Aman sa alan ha kaet-etawan bisan sa kenà mga Judio ha aghimuwen ku daan ha tumutuu mabayà hu pagsunud kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Saini ha inikagi hu Dios ha agbuhaten din impadayag din en su anay. ");
INSERT INTO bkd_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Aman sa kanak ha henà-henà iyan sa harì taw samuken sa kenà mga Judio ha nakabig duun hu pagtuu hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ba sulatan taw sidan ha harì sidan kumaen hu inhalad duun hu mga diyus-diyus daw hu langesa daw hu mananap ha bà dà pinekel ha hurà kaawà sa langesa din, daw harì daan sidan magbuhat hu malaw-ay. ");
INSERT INTO bkd_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ta sugud dà su anay iyan en haini Kasuguan hi Moises ha tagbasahen daw tigtudlù duun hu mga simbahan kada Sabado.” ");
INSERT INTO bkd_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Sa mga apostoles daw sa mga tumutuu duma hu mga pangulu dan mig-uyun ha tagpilì sidan diyà ta kandan hu igpaduma ki Pablo daw ki Bernabe diyà ta Antiokia. Aman impadiyà dan si Judas ha tagngaranan daan ki Barsabas daw si Silas sa tinahud daan hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Impauwit sidan hu sulat ha tagyanaen “Iyan kay sa mga apostoles daw mga pangulu hu tumutuu dini sa migsulat taini. Kamusta kaw sinyu sa mga suled day duun hu pagtuu ha kenà mga Judio diyan ta Antiokia daw duun hu mga probincia ta Siria daw ta Cilicia. ");
INSERT INTO bkd_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Napaliman day ha amin duminiyan ha mga Judio ha napuun dini ta Jerusalem ha migsamuk inyu pinaagi hu pagtudlù dan daw nalibeg sa henà-henà nuy, ba hurà day sidan sugua. ");
INSERT INTO bkd_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Aman miglalang-lalang kay daw migpilì kay hu agsuguen day diyan ta inyu ha igpaduma hu minahal taw ha mga suled ha si Bernabe daw si Pablo, ");
INSERT INTO bkd_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","saini ha mga etaw harì dan agkanugunan sa kinabuhì dan duun hu pagpanunultul mahitenged ki Jesu Cristo ha Ginuu taw. ");
INSERT INTO bkd_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aman impadiyan day si Judas daw si Silas ta daw itultul dan pa gayed haini diyan ta inyu. ");
INSERT INTO bkd_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Sikay daw sa Balaan ha Ispiritu mig-uyun ha harì kay mameges inyu hu pagtuman taena ha tulumanen hu mga Judio. Ba iyan haini kinahanglan ha buhaten nuy ");
INSERT INTO bkd_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ha harì kaw kumaen hu inhalad duun hu mga diyus-diyus daw hu langesa daw hu mananap ha bà dà pinekel ha hurà kaawà sa langesa din, daw harì kaw daan magbuhat hu malaw-ay. Ku tumanen nuy gayed haini mag-uswag kaw. Iyan dà haini.” ");
INSERT INTO bkd_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Impahipanaw dayun su pinilì dan payanaen ta Antiokia. Su makauma sidan diyà inamul dan sa alan ha mga tumutuu dayun in-ila dan su sulat. ");
INSERT INTO bkd_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Su mabasa en hu mga tumutuu su sulat nangabayà-bayà gayed sidan taena ha mga salambagan kandan. ");
INSERT INTO bkd_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tumenged ta si Judas daw si Silas pakasaysay hu igpaikagi hu Dios migwali sidan hu pagpalig-en hu pagtuu hu mga etaw diyà. ");
INSERT INTO bkd_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Su maiwas en sa pila ha aldaw hu pagtimà dan diyà impalikù dà sidan hu mga tumutuu duun hu migsugù kandan diyà ta Jerusalem. Su aghipanaw en sidan inikagiyan sidan hu “Panalanginan kaw hu Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ba pinilì hi Silas ha magpabilin dà diyà. ");
INSERT INTO bkd_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Si Pablo daw si Bernabe diyà dà daan ta Antiokia dayun nanudlù daw nanunultul sidan hu lalang hu Dios duma hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Su pila en ha aldaw inikagiyan hi Pablo si Bernabe hu “Likuan ta su mga banuwa ha pigsangyawan ta hu lalang hu Dios su anay ta daw masusi ta ku agkainu-inu en iman sa pagtuu dan.” ");
INSERT INTO bkd_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Agkabayaan ngaay agdumaha hi Bernabe si Juan ha tagngaranan daan ki Marcos. ");
INSERT INTO bkd_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ba si Pablo harì agkabayà ha dumuma haena kandan ta su anay ha diyà pa sidan ta Pamfilia uminendà haena hu pagbulig kandan daw ulì. ");
INSERT INTO bkd_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Aman nakagsawalà sidan daw tumenged taena migsuwayà sidan. Dinuma hi Bernabe si Juan ha tagngaranan daan ki Marcos daw lulan hu barko payanaen ta Cipro. ");
INSERT INTO bkd_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pinilì hi Pablo si Silas ha dumuma kandin dayun huminipanaw sidan ha inampuan hu mga tumutuu ha buligan sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Duminuun sidan hu mga banuwa ha sakup ta Siria daw Cilicia daw piglig-en hi Pablo sa pagtuu hu mga tumutuu diyà. ");
INSERT INTO bkd_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nakauma say Pablo diyà ta Derbe daw ta Listra. Amin diyà tuminuu ki Jesus ha tagngaranan ki Timoteo ha sa inay din tumutuu ha Judio ba sa amay din Griego. ");
INSERT INTO bkd_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sa alan ha mga tumutuu diyà ta Listra daw ta Iconio nakadayè ki Timoteo. ");
INSERT INTO bkd_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Tumenged ta agkabayaan haena hi Pablo agdumaha pigpasirkunsidahan din ta natun-an hu mga Judio diyà ha Griego sa amay din. ");
INSERT INTO bkd_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Duun hu mga banuwa ha agkangaagiyan dan intultul dan duun hu mga tumutuu sa angayan ha tumanen sumalà hu nauyunan hu mga apostoles daw hu mga pangulu hu tumutuu diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tumenged taena nalig-enan sa mga tumutuu duun hu pagtuu dan daw migdakel sidan ta kada aldaw agkaisaban sidan sa mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tumenged ta binaldeng say Pablo hu Balaan ha Ispiritu hu pagpanunultul hu lalang hu Dios diyà ta probincia ta Asia, duun sidan nakaagi hu mga banuwa ha sakup ta Frigia daw Galacia. ");
INSERT INTO bkd_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Su makauma sidan hu dulunà ta Misia agdayun en ngaay sidan diyà ta probincia ta Bitinia ba hurà daan sidan tuguti hu Balaan ha Ispiritu ha sinugù hi Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Aman diyà sidan mig-agi ta Misia payanaen ta Troas. ");
INSERT INTO bkd_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Su daleman en amin panan-awen hi Pablo saena etaw ha taga-Macedonia daw huminangyù diyà ta kandin ha tagyanaen “Dini kaw ta Macedonia daw buligi kay.” ");
INSERT INTO bkd_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Su maahà hi Pablo haena nan-ahà kay dayun hu paagi ha makadiyà kay ta Macedonia ta natun-an day ha agsuguen kay hu Dios hu pagsangyaw hu Maayad ha Tultulanen duun hu mga etaw diyà. ");
INSERT INTO bkd_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Diyà ta Troas luminulan kay hu barko payanaen ta Samotracia. Su maisab ha aldaw duminayun kay diyà ta Neapolis. ");
INSERT INTO bkd_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Diyà bà kay dà huminipanaw payanaen ta Filipos sa sabuwa duun hu mga kinaadagiyan ha banuwa diyà ta Macedonia daw taga-Roma sa kadakelà ha mga etaw diyà. Migtimà kay diyà hu pila ha aldaw. ");
INSERT INTO bkd_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Su aldaw hu Sabado guminuwà kay duun taena ha banuwa daw duminiyà kay ta kilid hu wahig ta nahenà-henà day ha diyà sa alampuanan hu mga Judio. Dayun mininuu kay diyà daw tultuli hu lalang hu Dios sa mga bahi ha tag-amul-amul diyà. ");
INSERT INTO bkd_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Sa sabuwa kandan iyan si Lidia ha diyà tagtimà ta Tiatira ha tagpamaligyà hu mahalen ha manggad. Saena masinimbahen hu Dios daw hinimu hu Dios ha dumawat hu tag-ikagiyen hi Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aman binautismuwan haena duma hu pamilya din dayun huminangyù kanay ha tagyanaen “Ku isipen nuy ha laus a ha tumutuu hu Ginuu diyà kaw magtimà ta balay ku.” Aman pineges kay gayed kandin. ");
INSERT INTO bkd_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Amin panahun ha su tagduun kay hu alampuanan hu mga Judio nasal-aw day sa bahi ha ulipen ha inulinan hu busaw aman tagpanagnà haena daw iyan igpakasalapì hu mga agalen din. ");
INSERT INTO bkd_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Saena miglupug-lupug kanay daw migkulahiay ha tagyanaen “Saini ha mga etaw suluguen hu Dios ha Magbabayà hu alan daw tagpanunultul sidan hu paagi ha maluwas kaw.” ");
INSERT INTO bkd_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pila gayed ha aldaw sa kabuhata din taena. Hurà makaantus si Pablo aman luminingì taena ha bahi daw ikagiyi su busaw hu “Pinaagi hu ngaran hi Jesu Cristo agsuguen ku ikaw ha umawà ka diyan ta kandin.” Sagunà uminawà su busaw. ");
INSERT INTO bkd_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ba su matun-an hu mga agalen din ha harì en sidan makasalapì pinaagi kandin dinakep dan si Pablo daw si Silas daw pangguyuda duun hu hukmanan. ");
INSERT INTO bkd_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Su ipaatubang en si Pablo daw si Silas duun hu mga opisyal insumbung dan ha kagi dan “Saini mga Judio ha migsamuk-samuk dini ta banuwa taw ");
INSERT INTO bkd_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ta migtudlù sidan hu mga tulumanen ha supak hu balaud ta Roma aman sikuy sa mga taga-Roma harì taw madawat sa tigtudlù dan.” ");
INSERT INTO bkd_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nangapauk daan sa kaet-etawan diyà dayun pinanlebasan si Pablo daw si Silas hu mga opisyal daw pabunali. ");
INSERT INTO bkd_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Su mapengahan en sidan pagbunalai impapurisu dan sidan daw inikagiyan su bantay ha siguruwan din sidan bantayan. ");
INSERT INTO bkd_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aman intagù din sidan diyà ta taliwarà ta purisuwan daw ligpiti sa mga paa dan hu tinagedan ha kayu. ");
INSERT INTO bkd_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ba su maliwarà en sa daleman si Pablo daw si Silas mig-ampù daw migkanta hu pagdayè hu Dios, daw migpaliliman kandan sa duma dan ha mga purisu. ");
INSERT INTO bkd_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Tigkan miglinug hu mabis-ay aman nahuyung su purisuwan. Sagunà napuwaan sa alan ha mga pultahan daw nangatangtang daan sa mga pusas hu mga purisu. ");
INSERT INTO bkd_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Su mapukaw su bantay naahà din ha napuwaan en sa purisuwan, aman dinagtù din su ispada din ta agdughangen din en ngaay sa lawa din ta abi din ha nakaawà en sa mga purisu. ");
INSERT INTO bkd_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ba kinulahì hi Pablo ha tagyanaen “Harì nu agdughanga sa lawa nu ta dini kay dà alan ta seled.” ");
INSERT INTO bkd_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Su bantay nanayù hu sulù daw agpas diyà ta seled. Luminuhud haena ha taghugdunan duun hu atubangan hi Pablo daw hi Silas. ");
INSERT INTO bkd_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Inuwit din sidan diyà ta guwà daw pan-insai hu “Inu man sa buhaten ku ta daw maluwas a?” ");
INSERT INTO bkd_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Inikagiyan dan haena ha “Tumuu ka ki Jesus ha Ginuu ta daw maluwas ka daw sa pamilya nu.” ");
INSERT INTO bkd_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dayun tinultulan dan hu lalang hu Dios sa alan ha mga etaw diyà ta balay. ");
INSERT INTO bkd_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Su liwarà pa sa daleman binulung taena ha bantay sa mga adul hi Pablo daw hi Silas. Pagkaiwas taena binautismuwan su bantay daw sa pamilya din. ");
INSERT INTO bkd_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dayun impaseled din diyà ta balay din su mga apostoles daw ipakaen sidan. Nalipay su bantay duma hu pamilya din ta nakatuu sidan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Su maselem en migsugù sa mga opisyal hu sinaligan dan ha ipaguwà en diyà ta purisuwan si Pablo daw si Silas. ");
INSERT INTO bkd_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Aman inikagiyan say Pablo hu bantay hu “Sa mga opisyal migsugù ha ipaguwà kaw aman hipanaw kaw en ha malinawen.” ");
INSERT INTO bkd_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ba inikagiyan hi Pablo su mga sinaligan hu “Sikay sa sakup ta Roma binunalan kay duun hu atubangan hu kaet-etawan daw purisuwa bisan ku hurà kay pa kabistiga ba iman tigkan kay paman igpaguwà. Sayana harì mabaluy ta kinahanglan ha su mga opisyal iyan dumini hu pagpaguwà kanay.” ");
INSERT INTO bkd_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Tinultulan su mga opisyal ku sinaligan dan hu inikagi hi Pablo. Su mapaliman dan en ha si Pablo daw si Silas sakup diay ta Roma nangahaldek gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Aman su mga opisyal duminiyà ta purisuwan daw panayù hu pasaylu. Dayun impaguwà sidan diyà ta purisuwan daw hangyua ha umawà en sidan duun taena ha banuwa. ");
INSERT INTO bkd_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Duminiyà dayun si Pablo daw si Silas ta balay hi Lidia daw dasiga sa mga tumutuu ha naamul diyà, dayun huminipanaw sidan. ");
INSERT INTO bkd_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Su makaagi si Pablo daw si Silas ta Amfipolis daw ta Apolonia nakauma sidan diyà ta Tesalonica ha amin duun simbahan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","3","Sumalà hu naanadan hi Pablo sumineled duun taena ha simbahan. Kada Sabado seled hu tatulu ha simana nakiglalang kandan daw pinamatud-an din pinaagi hu insulat ha lalang hu Dios ha su Mesiyas kinahanglan ha mag-antus gayed dayun himatayan ba mabanhaw dà. Inikagiyan sidan hi Pablo hu “Si Jesus ha iyan intultul ku diyan ta inyu iyan su Mesiyas.” ");
INSERT INTO bkd_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Aman sa duma ha mga Judio nakabig pinaagi hu inikagi hi Pablo dayun suminunud sidan ki Pablo daw ki Silas. Amin daan tuminuu ha kenà mga Judio ha mga tinahud ha bahi daw mga maama ha masinimbahen gayed hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ba nasina sa mga Judio aman inamul dan sa mga buguy ta daw makagbuligà sidan hu pagsamuk ta banuwa. Sinulung dan sa balay hi Jason ta agpan-ahaen dan si Pablo daw si Silas ta daw ipaatubang dan duun hu kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ba hurà dan haena kaahà aman dinakep dan si Jason daw sa duma ha mga tumutuu daw isumbung duun hu mga opisyal taena ha banuwa daw nangulahì sidan hu “Saini ha mga etaw migsamuk-samuk duun hu bisan hindu daw iman nakadini en sidan ta kanuy, ");
INSERT INTO bkd_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","daw saini si Jason iyan migpaseled kay Pablo diyà ta balay din. Alan en sidan suminupak hu balaud hi Cesar sa Harì taw ta inikagi dan ha amin kun lain ha Harì ha tagngaranan ki Jesus.” ");
INSERT INTO bkd_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Su mapaliman haena hu mga etaw daw hu mga punuan taena ha banuwa nasamuk gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Dayun impaila dan si Jason daw sa duma din hu piyansa daw human sidan ipaguwà. ");
INSERT INTO bkd_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Su daleman en si Pablo daw si Silas impahipanaw hu mga tumutuu payanaen diyà ta Berea. Su makauma sidan diyà sumineled sidan duun hu simbahan hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Matareng gayed sa mga Judio diyà dì hu mga Judio diyà ta Tesalonica ta agkabayaan dan gayed agpalilimani sa lalang hu Dios. Kada aldaw tagsusi sidan hu insulat ha lalang hu Dios ta daw matun-an dan ku laus ba gayed sa tigtudlù hi Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Aman madakel gayed ha mga Judio sa tuminuu bisan sa kenà mga Judio ha tinahud ha bahi daw madakel daan ha mga maama ha kenà Judio. ");
INSERT INTO bkd_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Su matun-an hu mga Judio diyà ta Tesalonica ha si Pablo tagsangyaw hu lalang hu Dios diyà ta Berea namandiyà daan sidan daw dasiga sa mga etaw ha paukan dan si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aman sagunà impadiyà hu mga tumutuu si Pablo ta dagat. Ba si Silas daw si Timoteo migpabilin ta Berea. ");
INSERT INTO bkd_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Su mga etaw ha nanulud ki Pablo diyà en nataman ta Atenas, dayun luminikù sidan daw ikagiyi si Silas daw si Timoteo ha umagpas dà lumupug ki Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Su tag-angatà pa si Pablo ki Silas daw ki Timoteo diyà ta Atenas naguul gayed haena su maahà din ha madakel sa mga larawan diyà ta banuwa. ");
INSERT INTO bkd_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Aman sumineled duun hu simbahan hu mga Judio daw nakiglalang kandan duma hu alan ha kenà mga Judio ha masinimbahen hu Dios. Bisan duun hu baligyaanan aldaw-aldaw nakiglalang si Pablo hu mga etaw ha naahà din diyà. ");
INSERT INTO bkd_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Amin mga manunudlù hu tinumanan hi Epicurio daw hu mga Estoico ha nakigsawalà kandin. Sa duma nanginginsà hu “Inu gid sa tag-ikagiyen taini ha pinakauleg?” Sa duma tagyanaen “Saini bà su tagpanunultul hu langyaw ha diyus-diyus.” Inikagi dan haena ta sa insangyaw hi Pablo iyan sa mahitenged ki Jesus daw sa pagkabanhaw din. ");
INSERT INTO bkd_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Aman inuwit dan si Pablo duun hu mga punuan ha mig-amul-amul ha tagngaranan hu Areopago daw bistigaha hu kagi dan “Mabaluy ba ha matun-an day haini sa bag-u ha tinumanan ha tigtudlù nu? ");
INSERT INTO bkd_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ta napaliman day diyan ta ikaw sa bag-u ha tultulanen daw agkabayà kay ku matun-an day sa kahulugan taena.” ");
INSERT INTO bkd_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sa mga taga-Atenas daw sa mga langyaw ha diyà en tagtimà iyan dà tagbuhaten dan sa pagpanunultul daw sa pagpaliliman hu bag-u ha tultulanen. ");
INSERT INTO bkd_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Duun hu atubangan taena ha mga punuan huminitindeg si Pablo daw ikagi hu “Sinyu sa mga taga-Atenas, natun-an ku ha masinimbahen kaw gayed. ");
INSERT INTO bkd_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ta su magpasiyu a dini ta banuwa nangaahà ku sa mga tagsimbahen nuy daw naahà ku sa halaran ha sinulatan ha tagyanaen ‘Kandin haini hu harì agkakilala ha diyus.’ Saini ha tagsimbahen nuy ba harì nuy agkakilala iyan en sa tigtultul ku iman. ");
INSERT INTO bkd_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Iyan haini Dios ha migtanghagà ta kalibutan daw hu alan ha tagtimà duun daw Magbabayà daan ta langit daw ta kalibutan. Aman hurà haini duun dà magtimà hu simbahan ha binuhat hu etaw ");
INSERT INTO bkd_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","daw harì en daan kapagbuligan hu etaw ta iyan en mig-ila hu alan bisan sa gahinawa hu etaw. ");
INSERT INTO bkd_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iyan migbuhat hu nauna ha etaw ha nahimu ha puunaan hu alan ha mga kaet-etawan dini ta tibuuk ha kalibutan, daw daan din en natugun sa panahun ha matukud sa migkalain-lain ha ginharian daw sa mga dulunà taena. ");
INSERT INTO bkd_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Binuhat din haena ta daw pan-ahaen hu mga etaw sa Dios dayun matulen dan. Ba ubay dà sa Dios dini ta kanuy ");
INSERT INTO bkd_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ta ‘Sa kinabuhì taw, sa henà-henà taw daw sa alan na pinaagi gayed kandin.’ Daw amin matatau diyan ta inyu ha tagyanaen ‘Iyan kuy gayed mga batà din.’ ");
INSERT INTO bkd_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tumenged ta batà kuy hu Dios harì taw henhenaen ha sa Dios iling dà hu larawan ha bulawan daw salapì daw batu ha binuhat hu mga matatau ha etaw. ");
INSERT INTO bkd_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Su anay inantus hu Dios sa mga madaet ha buhat hu etaw tumenged ta hurà dan pa haena kakilala. Ba iman sinugù din sa alan ha maghinulsul gayed ");
INSERT INTO bkd_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ta natugun din en sa aldaw ha sa kaet-etawan hukuman taena ha pinilì din pinaagi hu matareng ha paghukum. Saini namatud-an gayed ha laus pinaagi hu pagbanhaw din taena.” ");
INSERT INTO bkd_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Su mapaliman dan haena sa inikagi hi Pablo mahitenged hu pagkabanhaw sa duma kandan bà dà migtameyes. Ba sa duma migyanaen “Agkabayà kay dà agpaliliman ikaw aman likù ka asem dini.” ");
INSERT INTO bkd_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dayun minawà si Pablo diyà ta kandan. ");
INSERT INTO bkd_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amin tuminuu ha mga etaw ha suminunud kandin, sa duma kandan iyan si Dionisio sa sabuwa duun taena ha punuan daw amin daan bahi ha tagngaranan ki Damaris daw amin pa duma. ");
INSERT INTO bkd_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Su maiwas haena uminawà si Pablo diyà ta Atenas dayun duminiyà ta Corinto. ");
INSERT INTO bkd_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Diyà nakilala din sa sabuwa ha Judio ha taga-Ponto ha tagngaranan ki Akila. Bag-u pa sidan nakauma ki Asawa din ha si Priscila sa nangapuun ta probincia ta Italia ta insugù hi Claudio ha sa alan ha mga Judio umawà diyà ta Roma. Aman nakig-ahà si Pablo kandan. ");
INSERT INTO bkd_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Tumenged ta iling kandan sa pangabuhì hi Pablo ha iyan sa pagpamuhat hu tulda, diyà haena migtimà ta kandan daw migtalabahu duma kandan. ");
INSERT INTO bkd_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kada Sabado nakiglalang si Pablo diyà ta simbahan ta daw makabig sa mga Judio daw sa kenà mga Judio duun hu pagtuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Su makagapen en si Silas daw si Timoteo sa nangapuun ta Macedonia iyan dà binuhat hi Pablo sa pagpanunultul hu lalang hu Dios ta daw sa mga Judio tumuu gayed ha si Jesus iyan su Mesiyas. ");
INSERT INTO bkd_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ba suminupak ki Pablo sa mga Judio daw pigtameyes dan haena. Aman inyabyab din sa aliyabuk duun hu bisti din ha iyan timaan ha ag-awaan din en sidan, dayun inikagiyan din sidan ha “Hurà kud labet ku silutan kaw hu Dios. Sugud iman agduun ad hu kenà mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Aman inawaan sidan hi Pablo dayun diyà migtimà ta balay hi Titio Justo sa kenà Judio ba masinimbahen hu Dios. Sa balay din diyà dà ta kilid ta simbahan. ");
INSERT INTO bkd_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Si Crispo sa punuan duun taena ha simbahan tuminuu daan hu Ginuu duma hu pamilya din. Madakel pa gayed sa taga-Corinto ha migpaliliman ki Pablo daw tuminuu ki Jesus dayun binautismuwan. ");
INSERT INTO bkd_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Amin daleman ha inikagiyan hu Ginuu si Pablo pinaagi hu panan-awen hu “Harì ka agkahaldek ba dayuna sa pagpanunultul nu ");
INSERT INTO bkd_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ta tagdumahan ku ikaw. Hurà gayed makapasipala ikaw ta duun taini ha banuwa madakel pa sa tumuu kanak.” ");
INSERT INTO bkd_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Aman si Pablo migtimà diyà ta Corinto hu nangkatuig daw tengà hu pagtudlù hu lalang hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ba su iyan en paman gubernador ta Acaya si Galio sa mga Judio migsabuwa hu pagdakep ki Pablo daw inuwit dan haena duun hu hukmanan ");
INSERT INTO bkd_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","hu kagi dan “Saini migkabig hu mga etaw hu pagsimba hu Dios duun hu paagi ha supak hu balaud taw.” ");
INSERT INTO bkd_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Su agtubag en ngaay si Pablo inikagiyan hi Galio sa mga Judio ha “Ku saini ha etaw amin din nabuhat ha adagi ha salà magpaliliman a ngaay inyu. ");
INSERT INTO bkd_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ba tumenged ta mga lalang dà man daw mga ngaran hu kapuun nuy daw hu inyu ha Kasuguan iyan kaw en maghusay ta hurà ku duun labet.” ");
INSERT INTO bkd_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Aman impaawà din sidan duun taena ha hukmanan. ");
INSERT INTO bkd_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Dayun dinakep dan si Sostenes sa punuan duun taena ha simbahan daw pagbunalai duun hu atubangan ku hukmanan. Ba si Galio hurà en maglabet-labet kandan. ");
INSERT INTO bkd_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Si Pablo migtimà pa diyà ta Corinto hu pila ha aldaw. Dayun inawaan din sa mga tumutuu diyà daw lulan hu barko payanaen diyà ta probincia ta Siria duma ki Priscila daw ki Akila. Su makauma sidan diyà ta Cencrea migpatabulug si Pablo ha iyan timaan ha natuman din en sa panaad din duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Su makauma sidan diyà ta Efeso inawaan din si Priscila daw si Akila. Sumineled si Pablo duun hu simbahan hu mga Judio daw nakiglalang kandan. ");
INSERT INTO bkd_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Hinawidan dan si Pablo diyà ba hurà en haena kabayà. ");
INSERT INTO bkd_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bà dà uminikagi su aghipanaw en ha “Ku iyan pagbayà hu Dios aglikù a dà dini ta inyu.” Aman uminawà ta Efeso daw luminulan dayun hu barko. ");
INSERT INTO bkd_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Su makauma si Pablo diyà ta Cesarea duminayun haena diyà ta Jerusalem daw nakig-ahà hu mga tumutuu diyà dayun luminikù diyà ta Antiokia. ");
INSERT INTO bkd_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Su malugay-lugay hu pagtimà din diyà huminipanaw dà paman payanaen duun hu mga banuwa ha sakup ta Galacia daw ta Frigia ta daw malig-enan din sa pagtuu hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Duun daan taena ha panahun amin Judio ha taga-Alejandria ha tagngaranan ki Apolos sa nakauma diyà ta Efeso. Matatau haena daw natun-an din gayed sa insulat ha lalang hu Dios ");
INSERT INTO bkd_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","daw natudluan daan hu tinuuwan mahitenged hu Ginuu. Madasigen gayed hu pagpanudlù daw hustu sa pagsaysay din mahitenged ki Jesus bisan ku iyan din dà natun-an sa pagbautismu hi Juan. ");
INSERT INTO bkd_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Su magtudlù haena duun hu simbahan hu mga Judio hurà din gayed kahaldek. Ba su mapaliman haena hi Priscila daw hi Akila dinuma dan haena diyà ta balay dan daw tudlui hu hurà din pa katun-i ha insulat ha lalang hu Dios mahitenged ki Jesus ta daw mahustu gayed sa pagtudlù din. ");
INSERT INTO bkd_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Agkabayà gayed si Apolos agdiyà ta Acaya aman sa mga tumutuu diyà ta Efeso migdasig kandin dayun sinulatan dan sa mga tumutuu diyà ta Acaya ha dawaten dan si Apolos. Su makauma si Apolos diyà sa pagtudlù din nakabulig gayed hu mga nakatuu ki Jesus pinaagi hu grasya hu Dios ");
INSERT INTO bkd_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ta pinaagi hu insulat ha lalang hu Dios napamatud-an ha si Jesus iyan su Mesiyas. Aman nadaeg din sa mga Judio ha nakigsawalà kandin duun hu atubangan hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Su diyà en si Apolos ta Corinto si Pablo huminipanaw diyà ta bubungan dayun nakauma ta Efeso. Naahà din diyà sa duma ha mga tumutuu ");
INSERT INTO bkd_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","daw ininsaan din sidan ha “Su tumuu kaw ki Jesus inulinan kaw ba hu Balaan ha Ispiritu?” Tuminubag sidan ha “Hurà ta hurà day katun-i ha amin man diay Balaan ha Ispiritu.” ");
INSERT INTO bkd_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Aman ininsaan din sidan hu “Inu man diay sa katudluanan hu pagbautismu inyu?” Tuminubag sidan hu “Ki Juan ha katudluanan hu pagbautismu.” ");
INSERT INTO bkd_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Dayun inikagiyan sidan hi Pablo hu “Sa intudlù hi Juan iyan sa maghinulsul sa etaw dayun mabautismuwan, daw tinudluan din daan sa kaet-etawan ha tumuu sidan taena ha makauma ha hudiyan dì kandin ha iyan si Jesus.” ");
INSERT INTO bkd_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Su matun-an dan haena binautismuwan sidan tumenged hu pagtuu dan ki Jesus ha Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Dinampà sidan hi Pablo dayun inulinan sidan hu Balaan ha Ispiritu. Nakaikagi sidan hu harì dan agkasabut ha mga inikagiyan daw insaysay dan daan sa igpaikagi hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Sampulù daw daruwa sidan alan. ");
INSERT INTO bkd_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tatulu ha bulan sa pagtudlù hi Pablo hu mga etaw duun taena ha simbahan hu mga Judio daw hurà din daan gayed kahaldek hu pagdasig kandan mahitenged hu pagharì hu Dios ta daw makabig sidan. ");
INSERT INTO bkd_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ba sa duma ha mga etaw hurà gayed tuu ta madesen sa henà-henà dan daw bà dan dà pigtameyes duun hu atubangan hu mga etaw sa tinuuwan mahitenged ki Jesus. Aman uminawà si Pablo diyà ta kandan. Dinuma din sa mga tumutuu dayun aldaw-aldaw miglalang-lalang sidan duun hu iskwilahan ha binalay hi Tirano. ");
INSERT INTO bkd_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iyan haena binuhat dan duun hu daruwa ha tuig. Aman pinaagi taena sa lalang hu Dios napaliman hu alan ha mga etaw ha tagtimà ta probincia ta Asia sa mga Judio daw sa kenà. ");
INSERT INTO bkd_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Madakel gayed ha belenganen sa binuhat hi Pablo ta ginaheman hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bisan sa manggad ha pakaugsak diyà ta lawa hi Pablo ku ag-uwiten duun hu agkadaluwan daw duun hu pinasipalahan hu busaw agkaulian haena. ");
INSERT INTO bkd_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Amin mga Judio ha tagduun-duun hu mga banuwa ta agpamugaw daan hu mga busaw. Sinulay dan sa pagbugaw hu busaw pinaagi hu ngaran hi Jesus ha Ginuu hu kagi dan “Umawà ka duun taini pinaagi hu ngaran hi Jesus ha intultul hi Pablo.” ");
INSERT INTO bkd_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sa migbuhat taena iyan su pitu ha batà ha maama hi Esceva sa Judio ha iyan tungkay labaw ha sinaligan hu paghalad. ");
INSERT INTO bkd_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ba su busaw tuminubag hu “Nakilala ku si Jesus daw si Pablo, ba sinyu sin-u kaw man?” ");
INSERT INTO bkd_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dayun linaksuwan sidan ku etaw ha inulinan hu busaw daw nadaeg sidan. Aman nakapulaguy sidan duun ku balay sa nangaadulan daw nangalebasan. ");
INSERT INTO bkd_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Su mapaliman haena hu mga Judio daw hu kenà ha tagtimà diyà ta Efeso nangahaldek gayed sidan daw nadayè gayed si Jesus ha Ginuu. ");
INSERT INTO bkd_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Madakel sa tuminuu ha migsugid hu mga madaet ha buhat dan. ");
INSERT INTO bkd_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Amin daan diyà mga salamangkiro ha tuminuu aman inamul dan sa mga librito dan daw bigsuli duun hu atubangan hu kaet-etawan. Sa bali taena ha mga librito kalimahan ha libu ha salapì. ");
INSERT INTO bkd_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pinaagi taena nakalekep sa lalang hu Dios daw migdakelà gayed sa nangakatuu. ");
INSERT INTO bkd_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Su maiwas haena nakahenà-henà si Pablo ha umagi diyà ta Macedonia daw ta Acaya daw dayun diyà ta Jerusalem. Uminikagi pa ha “Ku maiwas haena agdiyà a pa daan ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Impauna din diyà ta probincia ta Macedonia sa daruwa ha sinaligan din ha iyan si Timoteo daw si Erasto ta si Pablo diyà pa hu kandin ta probincia ta Asia. ");
INSERT INTO bkd_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Duun taena ha panahun amin kasamuk diyà ta Efeso tumenged hu tinuuwan mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Amin mananalsal ha tagngaranan ki Demetrio ha namuhat hu larawan taena ha simbahan hu diyus-diyus dan ha bahi ha iyan si Artemisa. Pinaagi taena migsapian gayed sidan duma hu mga sakup din ha mananalsal. ");
INSERT INTO bkd_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Inamul din sa mga sakup din daw sa duma ha mananalsal daw ikagiyi sidan hu “Mga suled, natun-an nuy en ha migsapian kuy taini ha patigayun taw. ");
INSERT INTO bkd_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ba agkatun-an nuy en daan ha madakel en ha mga etaw sa nakabig hi Pablo dini ta Efeso daw apit en pakalekep duun hu mga banuwa ha sakup ta Asia tumenged ta tigtudlù din ha sa diyus-diyus ha binuhat hu etaw kenà laus ha Dios. ");
INSERT INTO bkd_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Aman pinaagi taini tameyesen dan gayed sa patigayun taw. Maikagi dan daan ha hurà en pulus taini ha simbahan hi Artemisa sa diyus taw ha iyan sinimba hu kaet-etawan dini ta Asia daw duun hu bisan hindu daw maawà daan sa pagkabantugan din.” ");
INSERT INTO bkd_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Su mapaliman haena hu mga mananalsal nangapauk gayed sidan daw namangulahì ha tagyanaen “Bantugan gayed si Artemisa sa diyus hu taga-Efeso.” ");
INSERT INTO bkd_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Aman amin kagubut ha nakalekep taena ha banuwa. Dayun migdengan sidan hu pagdakep ki Gayo daw ki Aristarco sa taga-Macedonia ha mga duma hi Pablo hu paghipanaw din daw pinangguyud dan sidan duun hu tigumanan. ");
INSERT INTO bkd_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Agkabayà ngaay si Pablo agpangatubang duun taena ha kaet-etawan ba binaldeng hu mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Amin din daan mga amigu ha opisyal diyà ta Asia ha migpasugù diyà ta kandin hu paghangyù ha harì dumuun ku tigumanan. ");
INSERT INTO bkd_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Sa mga etaw diyà ta tigumanan nangalibeg gayed ta hurà en mag-iling sa ingkulahì dan. Sa kadakelà kandan hurà man ganì makatuen ku imbà sidan kaamul-amul diyà. ");
INSERT INTO bkd_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Amin mga Judio ha migsugù ki Alejandro ha iyan mangatubang hu kaet-etawan hu pagpangatarengan mahitenged kandan. Dayun migsingyas haena ta daw humagteng sidan. ");
INSERT INTO bkd_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ba su matun-an dan ha si Alejandro Judio diay namangulahì sidan seled hu daruwa ha uras ha tagyanaen “Bantugan gayed si Artemisa sa diyus hu taga-Efeso.” ");
INSERT INTO bkd_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Impahagteng sidan hu sekretaryo taena ha banuwa daw minikagi hu “Mga suled ku dini ta Efeso, hurà ba diay katun-i hu alan ha sikuy sa mga taga-Efeso iyan sinaligan ha magbantay taini ha simbahan hu bantugan ha diyus taw ha si Artemisa daw hu larawan ha batu ha napuun diyà ta langit? ");
INSERT INTO bkd_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tumenged ta hurà man gayed makaikagi ha saini kenà laus kinahanglan ha humagteng kaw daw harì kaw tagbuhat hu kagubut, ");
INSERT INTO bkd_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ta insumbung nuy haini sa mga etaw ha hurà magtameyes ki Artemisa daw hurà panakaw diyà ta simbahan. ");
INSERT INTO bkd_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ku amin igsumbung hi Demetrio daw hu duma din ha mananalsal amin taw maghuhukum daw amin daan panahun hu paghusay na duun sidan magsumbung. ");
INSERT INTO bkd_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ku amin pa duma ha agkabayaan nuy ha mahusay angati nuy sa naanadan ha pag-amul-amul. ");
INSERT INTO bkd_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ta mabaluy kuy ha isumbung iman tumenged ta binuhat taw sa kagubut ha hurà taw duun katarengan.” ");
INSERT INTO bkd_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Su maikagi din haena impaulì din sa kaet-etawan. ");
INSERT INTO bkd_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Su maiwas en sa kagubut inamul hi Pablo sa mga tumutuu daw dasiga sidan daw human duminayun diyà ta Macedonia. ");
INSERT INTO bkd_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Su makaagi si Pablo duun hu mga banuwa diyà pigdasig din sa mga tumutuu duun. Dayun duminiyà ta Acaya ha tagngaranan daan ta Grecia ");
INSERT INTO bkd_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","daw migtimà diyà hu tatulu ha bulan. Su aglulan en ngaay haena hu barko payanaen ta probincia ta Siria natun-an din ha agdakepen hu mga Judio aman nahenhenaan din ha diyà dà agi ta Macedonia. ");
INSERT INTO bkd_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Dayun duminuma kandin si Sopater ha taga-Berea sa batà hi Piro, si Aristarco daw si Segundo sa mga taga-Tesalonica, si Gayo ha taga-Derbe daw si Timoteo, si Tikico daw si Trofimo sa mga taga-Asia. ");
INSERT INTO bkd_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","6","Su makauma kay diyà ta Filipos impauna day diyà ta Troas sa mga duma day ta daw diyà en sidan mag-angat. Su maiwas en sa pagsaulug hu Pagkaen hu Supas ha Hurà Duun Igpatulin luminulan kay hu barko. Dayun nagapenan day sidan diyà ta Troas su makalima en ha aldaw daw migtimà kay diyà hu nangkasimana. ");
INSERT INTO bkd_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Su sumalep en sa aldaw duun hu Sabado naamul-amul kay sa alan ha mga tumutuu hu pagkaen daw hu paghenà-henà taena ha kamatayen hi Jesus. Si Pablo migwali taman hu liwarà sa daleman ta ku maselem agdayun dà haena aghipanaw. ");
INSERT INTO bkd_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Diyà ta latun taena ha balay ha duun kay mig-amul-amul inugsakan hu madakel ha mga sulù. ");
INSERT INTO bkd_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Amin malaki ha tagngaranan ki Eutico ha duun mininuu hu bintanà, saena agtidugahen en tungkay ta malugayad sa wali hi Pablo. Su makatiduga en gayed nahulug diyà ta sileb sa duun dà napuun hu ikatulu ha andana. Minatay en haena su maumahan dan diyà ta sileb. ");
INSERT INTO bkd_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ba linugnaan daan haena hi Pablo daw kepkepi, dayun minikagi hu “Harì kaw agkasamuk ta bubuhay.” ");
INSERT INTO bkd_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dayun luminatun dà si Pablo diyà ta sampaw daw kaen sidan. Nakiglalang pa kandan taman ha agkaaldaw en dayun human huminipanaw. ");
INSERT INTO bkd_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Impaulì dan su malaki daw adagi gayed sa kalipay dan ta hurà haena patay. ");
INSERT INTO bkd_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Migsuwayà kay ki Pablo ta diyà hu kandin uminagi ta gaun daw luminulan kay hu kanay payanaen diyà ta Asos ta diyà kay en tagtalagbù. ");
INSERT INTO bkd_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Su makagtalagbù kay en diyà ta Asos luminulan si Pablo duma kanay payanaen ta Mitilene. ");
INSERT INTO bkd_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Su maisab ha aldaw duminayun kay daw diyà kay nakaagi ta pulù ta Kios. Su maisab en paman ha aldaw nakauma kay duun hu pulù ta Samos. Su isab ha aldaw diyà kay en paman ta Mileto ");
INSERT INTO bkd_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ta sa henà-henà hi Pablo ha baklayen day en sa Efeso ta daw harì kay mayawat diyà ta Asia. Ta ag-agpas si Pablo diyà ta Jerusalem ku mabaluy ha harì pa matuman sa Aldaw hu Pentecostes. ");
INSERT INTO bkd_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Su diyà en si Pablo ta Mileto pinaelegan din sa mga pangulu hu tumutuu diyà ta Efeso. ");
INSERT INTO bkd_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Su mangakauma en sidan inikagiyan din hu “Natun-an nuy en sa batasan ku sugud dà su anay ad makauma dini ta Asia. ");
INSERT INTO bkd_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mig-alagad a hu Ginuu ha migpaubus daw usahay agpakaagalà a tumenged inyu. Madakel daan sa mga alantusen ku hu duma ku ha mga Judio ta agpasipalahan a kandan. ");
INSERT INTO bkd_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Natun-an nuy ha intudlù ku gayed inyu sa alan ha makabulig inyu ku tagkaamul-amul kaw daw bisan duun hu mga balay nuy. ");
INSERT INTO bkd_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Inikagiyan ku sa mga Judio daw sa kenà ha maghinulsul sidan duun hu Dios daw tumuu sidan ki Jesu Cristo ha Ginuu taw. ");
INSERT INTO bkd_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Iman kinahanglan ha dumiyà a ta Jerusalem ta iyan hayana agkabayaan hu Balaan ha Ispiritu ha buhaten ku bisan ku hurà ku katun-i ku inu sa maul-ulahan ku diyà. ");
INSERT INTO bkd_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Iyan dà natun-an ku sa kada banuwa ha ag-elegan ku ag-ikagiyan a hu Balaan ha Ispiritu ha purisuwen a duun daw amin mga alantusen ku. ");
INSERT INTO bkd_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ba hurà ku isipa ha mahal sa kinabuhì ku iman ta sa mahinengdanen kanak iyan sa mapengahan ku gayed sa insalig kanak hi Jesus ha Ginuu ha iyan sa pagsangyaw hu Maayad ha Tultulanen mahitenged hu grasya hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Iman natun-an kud ha harì ad en inyu isab maahà sinyu sa tinudluan ku mahitenged hu pagharì hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Aman ikagiyen ku inyu iman ha harì ad en iyan mabasul ku amin inyu harì maluwas ");
INSERT INTO bkd_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ta intudlù kud en inyu sa alan ha agkabayaan hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Aman magbantay kaw gayed duun hu pagtuu nuy daw alimahi sa mga tumutuu ha insalig inyu hu Balaan ha Ispiritu ta naangken sidan hu Dios pinaagi hu uminagas ha langesa hu Batà din. ");
INSERT INTO bkd_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Natun-an ku ha ku maipus a dini amin makadiyan ta inyu ha biduen ha manunudlù daw daeten dan sa pagtuu nuy, ");
INSERT INTO bkd_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","daw diyan dà daan kapuun ta inyu sa magtudlù hu nakasuway duun hu kamatuuran ta daw makabig dan sa mga tumutuu en. ");
INSERT INTO bkd_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Aman magbantay kaw gayed daw timan-i nuy ha aldaw daw ku daleman duun hu tatulu ha tuig sinambagan ku inyu daw inagalaan ku gayed inyu. ");
INSERT INTO bkd_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Iman igsalig ku inyu duun hu Dios ta iyan gayed haena magbulig inyu pinaagi hu grasya din ha intudlù ku daw iyan daan magpalig-en hu pagtuu nuy, daw panalanginan kaw daan kandin iling hu duma ha mga etaw din. ");
INSERT INTO bkd_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kenà ku iyan tuyù sa salapì daw bisti duun hu bisan sin-u. ");
INSERT INTO bkd_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Natun-an nuy en ha naniguru a hu pagtalabahu ta daw matimù ku sa kinahanglanen day hu mga duma ku. ");
INSERT INTO bkd_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Duun hu alan ha binuhat ku impaahà ku inyu ha kinahanglan ha maniguru kuy magtalabahu ta daw mabuligan taw sa taglised, ta henhenaen taw sa inikagi hi Jesus ha Ginuu su magyanaen ‘Malipayen gayed sa tag-ila dì hu ag-ilahan.’” ");
INSERT INTO bkd_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Su maikagi en haena hi Pablo luminuhud sidan alan daw mag-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kinepkepan dan si Pablo ha naman-agalà sidan ");
INSERT INTO bkd_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ta sa nakapaguul kandan iyan sa inikagi din ha harì dan en maisab maahà. Dayun impanulud dan si Pablo duun ku aglulanan din ha barko. ");
INSERT INTO bkd_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Su magsusuwayà kay en taena ha mga tumutuu luminulan kay hu barko payanaen diyà ta pulù ta Cos. Su maisab ha aldaw duminayun kay diyà ta Rodas daw payanaen diyà ta Patara. ");
INSERT INTO bkd_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Diyà day naahà sa barko ha aglayun diyà ta Fenice aman luminulan kay duun. ");
INSERT INTO bkd_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Duun kay uminagi hu dibabà hu pulù ta Cipro. Su makauma kay diyà ta Tiro ha sakup ta Siria kuminawas kay ta duun dà taena ighaw-as sa mga karga hu barko. ");
INSERT INTO bkd_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nakaahà kay diyà hu mga tumutuu aman migtimà kay pa diyà hu nangkasimana. Dayun impadayag hu Balaan ha Ispiritu diyà ta kandan sa mahitabù ki Pablo diyà ta Jerusalem aman inikagiyan dan haena ha harì en dumayun diyà. ");
INSERT INTO bkd_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ba su mauma en sa panahun ha aghipanaw kay en sa alan ha mga tumutuu duma hu mga pamilya dan nanulud kanay diyà ta dagat. Diyà ta baybay taena namanluhud kay daw mig-ampù. ");
INSERT INTO bkd_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nanamilit kay dayun luminulan kay hu kanay duun hu barko daw naman-ulì sidan hu kandan. ");
INSERT INTO bkd_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Su makauma kay diyà ta Tolemaida sa napuun ta Tiro kuminawas kay. Seled hu nangkaaldaw nakig-ahà kay hu mga tumutuu diyà. ");
INSERT INTO bkd_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Su maselem en luminulan kay dà paman hu barko payanaen ta Cesarea. Su makauma kay diyà duun kay migtimà hu balay hi Felipe sa sabuwa duun taena ha pitu ha napilì ha iyan tag-alima hu mga tumutuu diyà ta Jerusalem daw sabuwa daan ha tagpanunultul mahitenged ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Amin din haepat ha laga ha pakasaysay hu igpaikagi hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Su pila kay pa ha aldaw diyà ta kandan, si Agabo sa pakasaysay daan hu igpaikagi hu Dios nakauma ha napuun ta Judea. ");
INSERT INTO bkd_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Dayun tinimù din sa bakes hi Pablo daw bakusa sa kaugalingen din ha alima daw paa daw uminikagi hu “Impadayag kanak hu Balaan ha Ispiritu ha sa tag-iya taini ha bakes bakusen hu mga Judio diyà ta Jerusalem iling taini daw itugyan duun hu kenà mga Judio.” ");
INSERT INTO bkd_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Su mapaliman day haena pinagayukan day si Pablo ha harì en dumiyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ba bà dà tuminubag si Pablo hu “Harì kaw tag-agalaay ta agsakit sa gahinawa ku. Andam ad en ku purisuwen a daw bisan ku himatayan a pa diyà ta Jerusalem tumenged hu pagpanunultul ku mahitenged ki Jesus ha Ginuu.” ");
INSERT INTO bkd_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Harì day en haena agkahawidan aman binay-anan day en daw kagi day “Iyan sa pagbayà hu Ginuu matuman.” ");
INSERT INTO bkd_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Su maiwas haena nanghimes kay daw dayun diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amin daan mga tumutuu ha napuun diyà ta Cesarea ha nanulud kanay payanaen duun hu agtimaan day ha iyan sa balay hi Manason sa taga-Cipro ha sabuwa daan duun hu nauna ha mga tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Su makauma kay en diyà ta Jerusalem nangabayà-bayà gayed sa mga tumutuu hu pagdawat kanay. ");
INSERT INTO bkd_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Su maisab ha aldaw migduma-duma kay ki Pablo hu pagpakig-ahà ki Santiago daw diyà daan naamul-amul sa alan ha pangulu hu tumutuu. ");
INSERT INTO bkd_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Duun taena intultul kandan hi Pablo sa alan ha binuhat hu Dios duun hu kenà mga Judio pinaagi hu pagtudlù din. ");
INSERT INTO bkd_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Su mapaliman dan haena dinayè dan sa Dios daw ikagiyi si Pablo ha “Suled day, natun-an nu ha madakel gayed sa mga Judio ha tuminuu ki Jesus daw migmadasigen daan sidan hu pagtuman hu Kasuguan hi Moises. ");
INSERT INTO bkd_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Napaliman dan ha sa mga Judio duun hu banuwa hu kenà mga Judio tinudluan nu ha harì dan tumanen sa Kasuguan hi Moises ta inikagiyan nu kun sidan ha harì dan pasirkunsidahan sa mga batà dan daw endaan dan sa tulumanen taw. ");
INSERT INTO bkd_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Inu sa buhaten taw iman ta matun-an dan man gayed ha nakadini ka? ");
INSERT INTO bkd_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ba sa maayad ha buhaten nu iyan haini. Amin dini haepat ha etaw ha agkatuman en sa panaad dan duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Duma ka kandan diyà ta Timplo daw buhata daan sa sumalà ha tulumanen hu paglimpyu, daw iyan ka magbayad taena ha ighalad dan duun hu Dios ta daw matabulug sidan ha iyan timaan ha natuman dan en sa panaad dan duun hu Dios. Ku buhaten nu haini matun-an hu alan ha sa tultulanen mahitenged ikaw kenà laus tumenged ta naahà dan ha migtuman ka hu Kasuguan. ");
INSERT INTO bkd_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Sa kenà mga Judio ha tuminuu sinulatan day en hu nauyunan day ha harì dan gayed kan-en haena sa inhalad duun hu mga diyus-diyus daw sa langesa daw sa mananap ha bà dà pinekel ha hurà kaawà sa langesa din daw harì daan sidan magbuhat hu malaw-ay.” ");
INSERT INTO bkd_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Aman su maisab ha aldaw si Pablo duminuma taena ha haepat ha mga etaw daw binuhat din sa sumalà ha tulumanen dan hu paglimpyu. Dayun sumineled sidan diyà ta Timplo daw ikagiyi haena sa sinaligan hu paghalad ku kan-u mapenga sa tulumanen hu paglimpyu ta ku maiwas haena su sinaligan human en makahalad para hu kada sabuwa kandan. ");
INSERT INTO bkd_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Duun hu ikapitu ha aldaw amin mga Judio ha napuun ta Asia ha nakaahà ki Pablo diyà ta Timplo. Dinakep dan si Pablo daw nangumaw sidan duun hu madakel ha mga etaw ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Sinyu sa mga duma day ha kaliwat hi Israel, buligi kay inyu ta iyan en haini su etaw ha migtudlù duun hu bisan hindu ha sa mga Judio daw sa Kasuguan taw daw saini ha balaan ha Timplo hurà din pulus, daw impaseled din duun taini ha Timplo sa kenà mga Judio aman nahugawan dan haini.” ");
INSERT INTO bkd_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Inikagi dan haena ta naahà dan si Trofimo sa taga-Efeso ha nakaduma kandin diyà ta Jerusalem aman abi dan ha impaseled haena hi Pablo diyà ta Timplo. ");
INSERT INTO bkd_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Duun taena nagubut sa banuwa ta Jerusalem daw nangaamul-amul sa mga etaw. Dayun ginuyud dan si Pablo diyà ta guwà taena ha Timplo daw sirahi haena. ");
INSERT INTO bkd_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Su aghimatayan dan en ngaay si Pablo napaliman hu labaw ha kapitan taena ha mga kasundaluwan ta Roma ha nasamuk sa Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Aman uminagpas su kapitan duma hu mga sakup din duun ku nangaamul-amul ha mga etaw. Su maahà sidan hu mga etaw hinimlayan dan pagbunalai si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dayun su kapitan hu sundalu migsugù ha pusasan si Pablo hu daruwa ha pusas daw nanginginsà ku sin-u haena daw inu sa salà din. ");
INSERT INTO bkd_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ba hurà din katun-i sa kamatuuran ta namangulahì sa mga etaw hu hurà mag-iling ha mga tubag. Aman insugù ku kapitan hu sundalu ha uwiten si Pablo duun hu kampo dan. ");
INSERT INTO bkd_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Su makauma en sidan hu pultahan taena ha kampo napagbitbit dan si Pablo ta agdasmagan sidan hu mga etaw ");
INSERT INTO bkd_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ta namanlupug haena ha tagkukulahiay hu “Himatayi hayan.” ");
INSERT INTO bkd_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Su ipaseled en si Pablo duun taena ha kampo uminikagi duun ku labaw ha kapitan hu sundalu hu “Amin ku ngaay ag-ikagiyen ikaw.” Tuminubag haena hu “Pakatuen ka diay tag-ikagi hu Griego ha inikagiyan. ");
INSERT INTO bkd_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kenà ka ba diay iyan haena sa taga-Ehipto ha migbuhat hu kagubut daw nangulu hu haepat ha libu ha mga talamunù duun hu pinakabulung-bulung ha lugar?” ");
INSERT INTO bkd_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Tuminubag si Pablo hu “Kenà a iyan ta Judio a ha taga-Tarso sa bantugan ha banuwa ha sakup ta Cilicia. Hangyuen ku ngaay ikaw ha ipaikagi a duun taini ha mga etaw.” ");
INSERT INTO bkd_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tinugutan taena ha labaw ha kapitan hu sundalu aman huminitindeg si Pablo duun hu hagedan daw migsingyas ta alima din. Su humagteng en sa mga etaw uminikagi si Pablo duun hu Hebreo ha inikagiyan hu ");
INSERT INTO bkd_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Mga suled ku daw sinyu sa mga magulang, palilimani nuy haini sa katarengan ku.” ");
INSERT INTO bkd_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Su mapaliman dan ha Hebreo sa inikagiyan din ayuwà pa sidan nahagteng. Dayun minikagi si Pablo hu ");
INSERT INTO bkd_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Siak sabuwa a ha Judio ha diyà imbatà ta Tarso ha sakup ta Cilicia ba dini a uminadagi ta Jerusalem. Sa manunudlù ku iyan si Gamaliel aman tinudluan a kandin hu alan mahitenged hu Kasuguan hu mga gin-apuan taw, daw madasigen a gayed duun hu Dios iling inyu iman. ");
INSERT INTO bkd_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pinasipalahan ku taman ha matay sa mga suminunud hu tinuuwan mahitenged ki Jesus ta pinandakep ku sa mga maama daw sa mga bahi dayun pamurisuwa. ");
INSERT INTO bkd_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sa tungkay labaw ha sinaligan hu paghalad daw sa alan ha mga labaw ha punuan makapanistigus gayed ha laus haini sa tag-ikagiyen ku. Iyan man ganì sidan mig-ila kanak hu mga sulat duun hu mga duma dan diyà ta Damasco. Aman duminiyà a ta Damasco hu pagpandakep hu mga tumutuu diyà ta igpauwit ku sidan dini ta Jerusalem ta daw masilutan sidan. ");
INSERT INTO bkd_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Su taghipanaw a daw nakaubay ad en diyà ta Damasco ha apit en agkaugtu tigkan nakabulus dini ta kanak sa masiga. ");
INSERT INTO bkd_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naligid a ta bugtà daw napaliman ku sa lageng ha tagyanaen ‘Saulo, imbà a ikaw tagpasipalahi?’ ");
INSERT INTO bkd_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Aman tuminubag a hu ‘Sin-u ka man, Ginuu?’ “Dayun uminikagi haena hu ‘Iyan a si Jesus ha taga-Nazaret sa tagpasipalahan nu.’ ");
INSERT INTO bkd_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Naahà ku mga duma ku sa masiga ba hurà dan agkapaliman ha tag-ikagi dini ta kanak. ");
INSERT INTO bkd_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Duun taena nanginginsà a hu ‘Ginuu, inu man sa buhaten ku?’ “Tuminubag sa Ginuu hu ‘Hitindeg ka daw dayun ka diyà ta Damasco ta diyà ag-ikagiyen sa igpabuhat ikaw hu Dios.’ ");
INSERT INTO bkd_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tumenged ta harì a pakaindan ta agsilangen a taena ha masiga kinipitan a hu mga duma ku payanaen ta Damasco. ");
INSERT INTO bkd_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Amin diyà etaw ha tagngaranan ki Ananias ha matinumanen gayed hu Kasuguan daw nadayè hu alan ha mga Judio ha tagtimà diyà. ");
INSERT INTO bkd_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Uminubay haena dini ta kanak ha migyanaen ‘Suled ku ha Saulo, ahà ka.’ Sagunà a nakaindan aman naahà ku haena. ");
INSERT INTO bkd_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Dayun minikagi haena hu ‘Sa Dios ha tagsimbahen hu mga gin-apuan taw iyan migpilì ikaw ta daw matun-an nu sa agkabayaan din aman naahà nu sa matareng ha sinugù din daw napaliman nu sa inikagi din. ");
INSERT INTO bkd_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Agbuhaten ka kandin ha iyan manunultul duun hu kaet-etawan mahitenged hu naahà nu daw napaliman nu. ");
INSERT INTO bkd_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Iman harì kad tagyawat. Panayù ka hu pasaylu duun hu Dios hu mga salà nu daw magpabautismu kad.’ ");
INSERT INTO bkd_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Su makalikù a dini ta Jerusalem daw mig-ampù a diyà ta Timplo naahà ku sa panan-awen ");
INSERT INTO bkd_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ha sa Ginuu tagyanaen ‘Agpas ka awà diyan ta Jerusalem ta harì sidan agtuu hu pagpanunultul nu mahitenged kanak.’ ");
INSERT INTO bkd_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ba tinubag ku haena hu ‘Ginuu, natun-an dan en ha duun hu alan ha mga simbahan impapurisu ku daw binunalan ku haena sa tuminuu ikaw. ");
INSERT INTO bkd_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Daw su himatayan dan si Esteban sa suluguen nu nabayà-bayà a taena daw iyan a daan migbantay hu mga bisti hu mighimatay kandin.’ ");
INSERT INTO bkd_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ba minikagi sa Ginuu dini ta kanak hu ‘Hipanaw ka ta agsuguen ku ikaw duun hu kenà mga Judio duun hu mga madiyù ha lugar.’” ");
INSERT INTO bkd_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Su maikagi haena hi Pablo hurà en magpaliliman su mga etaw kandin ba nangulahì sidan ha tagyanaen “Himatayi en ta kenà maayad ha mabuhì pa hayana.” ");
INSERT INTO bkd_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Duun taena impanyabyab dan sa mga bisti dan daw impansawed sa aliyabuk ha tagkukulahiay. ");
INSERT INTO bkd_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Aman su labaw ha kapitan hu sundalu migsugù ha uwiten si Pablo diyà ta seled ta kampo daw palagkuti ta daw matun-an ku imbà tagkulahiay sa mga Judio hu kapauk dan kandin. ");
INSERT INTO bkd_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ba su ibangget dan en si Pablo ta aglagkutan en nanginginsà duun hu lain ha kapitan hu mga sundalu ha diyà ta ubay din hu “Iyan ba diay haini balaud nuy sa lagkutan nuy sa duma ha sakup ta Roma bisan ku hurà pa kabistiga?” ");
INSERT INTO bkd_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Su mapaliman haena ku kapitan hu mga sundalu duminuun ku labaw ha kapitan din daw ikagiyi hu “Imbà nu man agpalagkuti haini sa etaw ha sakup ta Roma?” ");
INSERT INTO bkd_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Aman su labaw ha kapitan hu sundalu duminiyà ki Pablo daw insai hu “Laus ba ha sakup ka ta Roma?” Tuminubag si Pablo hu “Hee.” ");
INSERT INTO bkd_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Dayun uminikagi haena sa labaw ha kapitan hu sundalu hu “Siak migbayad a hu adagi ha salapì ta daw mabuhat a ha sakup ta Roma.” Ba si Pablo tuminubag daan hu “Sakup a gayed ta sa laas ku sakup man ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Su mga etaw ha aglagkut ngaay kandin sagunà naman-awà diyà ta kandin. Bisan su labaw ha kapitan hu mga sundalu nahaldek daan ta natun-an din ha si Pablo sakup diay ta Roma sa impabangget din. ");
INSERT INTO bkd_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Agkabayaan gayed taena ha labaw ha kapitan hu sundalu ha matun-an din ku imbà isumbung si Pablo hu mga Judio, aman duun hu isab ha aldaw inamul din sa mga labaw ha sinaligan hu paghalad daw sa alan ha mga labaw ha punuan hu mga Judio. Dayun pinahukadan din si Pablo daw ipaatubang kandan. ");
INSERT INTO bkd_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pigtengtengan hi Pablo sa alan ha mga labaw ha punuan daw ikagi hu “Mga suled, natun-an hu Dios ha sa henà-henà ku hurà gayed duun pagduwa-duwa mahitenged hu pagtuman ku hu insugù din.” ");
INSERT INTO bkd_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Dayun si Ananias ha iyan tungkay labaw ha sinaligan hu paghalad migsugù taena ha taghitindeg diyà ta ubay hi Pablo ha dapien din sa bàbà hi Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Dayun inikagiyan haena hi Pablo hu “Dapien ka daan hu Dios sa bà dà tagpasibù-sibù ha matareng. Iyan ka ngaay tagpinuu diyan hu paghukum kanak sumalà hu Kasuguan ba sinupak nu haini ta igpadapì a ikaw.” ");
INSERT INTO bkd_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Su mga etaw ha ubay diyà ki Pablo uminikagi hu “Imbà nu tagtameyesa sa tungkay labaw ha sinaligan hu paghalad duun hu Dios?” ");
INSERT INTO bkd_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tuminubag si Pablo hu “Mga suled, hurà ku hayana kakilala ha iyan man diay tungkay labaw ha sinaligan hu paghalad, ta sa insulat ha lalang hu Dios tagyanaen ‘Harì nu pagtameyesen sa pangulu nu.’” ");
INSERT INTO bkd_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tumenged ta natun-an hi Pablo ha sa duma kandan mga Saduceo daw sa duma mga Fariseo minikagi haena hu madaging hu “Mga suled, Fariseo a daan daw bisan sa mga gin-apuan ku Fariseo gayed. Sa hinengdan ha agbistigahen a iman iyan sa pagtuu ku ha sa mga nangamatay en mabanhaw dà.” ");
INSERT INTO bkd_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Su maikagi din haena migsawalà sa mga Fariseo daw sa mga Saduceo. Aman nabahin sidan ");
INSERT INTO bkd_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ta sa mga Saduceo harì agtuu ha amin ispiritu daw amin mga balinsuguen hu Dios daw mangabanhaw daan sa nangamatay en, ba sa mga Fariseo agtuu sidan taini. ");
INSERT INTO bkd_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Migpadasangà sidan hu pagsawalà dayun amin mga manunudlù hu Kasuguan ha mga sakup hu Fariseo ha namanhitindeg daw paman-ikagi ha “Hurà day naahà ha salà taini ha etaw. Madaet ba diay ku amin ispiritu daw ku balinsuguen hu Dios ha nakiglalang kandin?” ");
INSERT INTO bkd_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bà dà tungkay mig-iseg sa pagsawalà dan aman sa labaw ha kapitan hu sundalu nahaldek ku paghihigbiten hu mga etaw si Pablo. Sinugù din sa mga sundalu ha agawen dan si Pablo duun taena ha mga etaw daw uwita diyà ta kampo. ");
INSERT INTO bkd_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Su daleman en sa Ginuu migpaahà ki Pablo ha tagyanaen “Pandayai sa gahinawa nu ta iling ha intultul nu sa mahitenged kanak dini ta Jerusalem itultul nu daan haini diyà ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Su maselem en amin subra ha kapatan ha mga Judio ha miglalang-lalang hu kahimatayi ki Pablo daw nanumpà sidan ha harì gayed kumaen daw harì daan uminum ku harì dan mapatay si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Aman duminuun sidan taena ha mga labaw ha sinaligan hu paghalad daw duun hu mga magulang ha tagyanaen “Nanumpà kay en ha harì kay gayed kumaen ku harì day mapatay si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aman iman sinyu daw sa alan ha duma nuy ha mga labaw ha punuan hu mga Judio hangyuen nuy haena sa labaw ha kapitan hu sundalu ha ipauwit din diyan ta inyu si Pablo ta agpandayaan nuy kun haena agbistigahen. Andam kay en paghimatay kandin sa harì pa makauma diyan ta inyu.” ");
INSERT INTO bkd_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ba saena ha lalang-lalang napaliman diay taena ha batà hu suled ha bahi hi Pablo aman duminiyà haena ta kampo daw tultuli si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Dayun inumaw hi Pablo su sabuwa ha kapitan hu sundalu daw ikagiyi ha “Dumaha haini sa malmalaki duun hu labaw ha agalen nuy ta amin din ag-ikagiyen.” ");
INSERT INTO bkd_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Aman inuwit haena duun ku labaw ha kapitan hu sundalu. Inikagiyan din haena sa agalen din hu “Si Pablo sa pinurisu huminangyù kanak ha dumahan ku haini sa malmalaki diyan ta ikaw ta amin din kun ag-ikagiyen.” ");
INSERT INTO bkd_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Inibitan ku labaw ha kapitan hu sundalu sa alima taena ha malmalaki daw migpadiyù sidan duun hu mga etaw daw insai hu “Inu man sa ag-ikagiyen nu?” ");
INSERT INTO bkd_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Uminikagi haena hu “Sa mga labaw ha punuan hu mga Judio mig-uyun ha aghangyuen ka kandan ha ipauwit nu si Pablo diyà ta kandan ta agpandayaan dan kun agbistigahen. ");
INSERT INTO bkd_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ba harì ka agtuu kandan ta amin subra ha kapatan ha mga etaw ha tag-ayan kandin. Nanumpà sidan ha harì gayed kumaen daw harì daan uminum ku harì dan mapatay si Pablo. Iman tag-angat en sidan hu pag-uyun nu.” ");
INSERT INTO bkd_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Inikagiyan ku labaw ha kapitan hu sundalu su malmalaki hu “Harì nu itultul duun hu bisan sin-u ha migsumbung ka dini ta kanak” dayun impaulì din haena. ");
INSERT INTO bkd_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Impaumaw ku labaw ha kapitan hu sundalu sa daruwa ha sinaligan din ha mga kapitan daan hu sundalu daw ikagiyi sidan hu “Andama nuy sa daruwa ha gatus ha mga sundalu ha igpahipanaw payanaen ta Cesarea ku harì pa kan maliwarà sa daleman. Daw dumaha daan sa kapituwan ha taglulan hu kabayu daw daruwa ha gatus ha tag-uwit hu bangkaw. ");
INSERT INTO bkd_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Taganahi daan si Pablo hu kabayu ha aglulanan din daw ihat-un nuy haena diyà ki Felix ha gubernador. Bantayan nuy gayed ha hurà mahitabù kandin.” ");
INSERT INTO bkd_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Dayun migsulat haena ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Iyan a si Claudio Lisias sa migsulat taini diyan ta ikaw sa Halangdun ha Gubernador Felix. Kamusta kad en. ");
INSERT INTO bkd_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Taini sa etaw ha igpauwit ku dini ta ikaw ta dinakep hu mga Judio daw aghimatayan dan en ngaay. Ba su matun-an ku ha sakup diay haini ta Roma piglibri day hu mga sundalu ku. ");
INSERT INTO bkd_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Agkabayà a ha matun-an ku ku inu sa hinengdan ha insumbung dan haini aman impabistiga ku hu mga labaw ha punuan dan. ");
INSERT INTO bkd_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Dayun natun-an ku ha hurà din salà ha angayan ha purisuwen daw himatayan ta sa hinengdan ha insumbung dan iyan sa mahitenged hu Kasuguan dan. ");
INSERT INTO bkd_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Su mapaliman ku ha miglalang-lalang sa mga Judio ha ag-ayanan dan haini ta aghimatayan dan sagunà ku impauwit dini ta ikaw daw inikagiyan ku daan sa migsumbung kandin ha umatubang sidan diyan ta ikaw.” ");
INSERT INTO bkd_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Duun taena ha daleman tinuman hu mga sundalu sa insugù kandan aman inuwit dan si Pablo diyà ta Antipatris. ");
INSERT INTO bkd_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Su maselem en sa mga sundalu ha namanhipanaw luminikù diyà ta kampo, ba su taglulan ku mga kabayu duminayun hu pagduma ki Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Su makauma en sidan diyà ta Cesarea indawag dan su sulat duun ku gubernador daw intugyan dan daan si Pablo kandin. ");
INSERT INTO bkd_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Su mabasa en ku gubernador su sulat nanginginsà ku hindu ha probincia nasakup si Pablo. Su umikagi si Pablo ha sakup ta Cilicia ");
INSERT INTO bkd_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","inikagiyan din haena hu “Daw ku asem ikaw agbistigaha ku makauma en sa migsusumbung ikaw.” Dayun pinabantayan din si Pablo duun hu balay su anay hi Herodes. ");
INSERT INTO bkd_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Su mauma en sa ikalima ha aldaw sa tungkay labaw ha sinaligan hu paghalad ha si Ananias duminiyà ta Cesarea duma hu mga magulang daw hu sabuwa ha abugado ha si Tertulo. Uminatubang sidan hu gubernador daw isumbung si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Impaatubang dan daan si Pablo dayun huminitindeg si Tertulo sa abugado hu migsumbung ha tagyanaen “Halangdun ha Gubernador Felix, adagi gayed sa kabayà-bayà day ta pinaagi hu pagharì nu kanay malinawen gayed sa pagtimà day daw madakel gayed sa binuhat nu ha nakapauswag taini ha probincia. Aman adagi gayed sa pagpasalamat day diyan ta ikaw. ");
INSERT INTO bkd_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Harì ku agkabayaan ha mayawat ka aman aghangyuen ku ikaw ha palilimanan kay ikaw hu mababà ha panahun. ");
INSERT INTO bkd_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Natun-an day ha saini ha etaw samukan gayed ta iyan nakapasamuk hu alan ha mga Judio duun hu agpayanan-an din. Pangulu haini hu mga etaw ha Nazareno ");
INSERT INTO bkd_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","daw maal en daan haini sumineled diyà ta Timplo aman dinakep day. Ba su aghukuman day en ngaay haini pinaagi hu Kasuguan day ");
INSERT INTO bkd_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","nakauma sa labaw ha kapitan hu sundalu ha si Lisias daw inagaw din haini dini ta kanay ");
INSERT INTO bkd_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","daw sinugù kay kandin ha dini kay en mangatubang ta ikaw. Aman ku bistigahen nu haini matun-an nu gayed ha laus haini sa tag-ikagiyen day.” ");
INSERT INTO bkd_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Sa mga duma hi Tertulo ha mga Judio naman-ikagi daan ha laus gayed haena. ");
INSERT INTO bkd_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Su masingyasan hu gubernador si Pablo ta daw makaikagi daan minikagi si Pablo hu “Natun-an ku ha matareng ka daw malugayad en sa pagkagubernador nu duun taini ha probincia aman ikalipay ku iman sa pagpangatarengan duun hu atubangan nu. ");
INSERT INTO bkd_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ku susiyen nu matun-an nu gayed ha sampulù pa daw daruwa ha aldaw sa pagpakadiyà ku ta Jerusalem hu pagsimba. ");
INSERT INTO bkd_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Hurà gayed kaahà hu mga Judio ha nakigsawalà a hu bisan sin-u diyà ta Timplo daw ku pigsamuk ku ba sa mga etaw duun hu mga simbahan daw bisan hindu diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Daw saini sidan harì makapamatuud ha laus haini sa sumbung dan kanak. ");
INSERT INTO bkd_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ba ag-ikagiyen ku ikaw ha sa Dios ha iyan sinimba hu mga gin-apuan day tagsimbahen ku daan ta suminunud a hu tinuuwan mahitenged ki Jesus, ba kagi dan ha saena bidù dà. Ba tinuuwan ku gayed sa Kasuguan daw sa insulat hu mga propita ");
INSERT INTO bkd_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","daw tagsalapen ku iman ha sa alan ha nangamatay en sa matareng daw sa makasasalà mabanhaw dà hu Dios iling ha iyan daan haini tagsalapen taini ha migsusumbung kanak. ");
INSERT INTO bkd_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Aman agpaniguruwan ku gayed iman ha harì a makasalà duun hu Dios daw duun hu mga etaw. ");
INSERT INTO bkd_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Nalugay en sa kaawà ku diyà ta Jerusalem ba luminikù a diyà ta taghat-un a hu salapì ta daw mabuligan sa taglised diyà ha mga Judio daw taghalad a daan duun hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Naahà a kandan su buhaten ku diyà ta Timplo sa pagtuman hu tulumanen day hu paglimpyu, ba hurà mga etaw diyà daw hurà daan kasamuk diyà. ");
INSERT INTO bkd_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ba amin mga Judio ha napuun diyà ta probincia ta Asia ha iyan ngaay iman angayan ha ipaatubang ikaw ku laus ba ha amin ku salà. ");
INSERT INTO bkd_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Daw maayad ngaay ku saini ha migsusumbung kanak ikagiyen dan ikaw ku inu sa naahà dan ha salà ku su bistigahen a hu alan ha mga labaw ha punuan hu mga Judio diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Hurà dan gayed agkaikagi, ba amin sabuwa ha inikagi ku hu madaging duun hu atubangan dan ha migyanaen a ‘Sa hinengdan ha agbistigahen a iman iyan sa pagtuu ku ha sa mga nangamatay en mabanhaw dà.’” ");
INSERT INTO bkd_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Tumenged ta natun-an en daan hi Felix sa tinuuwan mahitenged ki Jesus hinimlayan din haena hu pagbistiga daw minikagi hu “Aghukuman ku asem haini ku makadini sa labaw ha kapitan hu sundalu ha si Lisias.” ");
INSERT INTO bkd_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Dayun sinugù din sa kapitan hu sundalu ha bantayan dan si Pablo, ba tugutan dan sa mga amigu din ha magbisita kandin ta daw mailahan hu mga kinahanglanen din. ");
INSERT INTO bkd_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Su maiwas sa pila ha aldaw nakauma si Felix duma hu asawa din ha si Drusila sa sabuwa ha Judio. Dayun impaatubang din si Pablo diyà ta kandan ta agpaliliman sidan hu tultulanen din mahitenged hu pagtuu din ki Jesu Cristo. ");
INSERT INTO bkd_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ba su tagsaysay en si Pablo mahitenged hu pagkamatareng daw hu pagpugung hu kaugalingen daw sa pakauma ha paghukum hu Dios nahaldek gayed tungkay si Felix. Dayun minikagi ha “Hustu en enà hayana. Umawen ku dà ikaw ku amin ku higayun.” ");
INSERT INTO bkd_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Tagsalap diay haena ha ilahan hi Pablo hu salapì aman mahies haena pakiglalang-lalang ki Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Su maiwas en sa daruwa ha tuig si Felix nailisan hi Porcio Festo. Tumenged ta agkabayà si Felix ha mabayà-bayà gayed sa mga Judio hurà din ipaguwà si Pablo diyà ta purisuwan. ");
INSERT INTO bkd_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Su tatulu en ha aldaw sa pagkagubernador hi Festo diyà ta Judea duminiyà haena ta Jerusalem sa napuun ta Cesarea ");
INSERT INTO bkd_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ha diyà sa mga labaw ha sinaligan hu paghalad daw sa mga punuan hu mga Judio ha migsusumbung ki Pablo diyà ta kandin. ");
INSERT INTO bkd_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Hinangyù dan gayed ha ipauwit din si Pablo diyà ta Jerusalem ta ag-ayanan dan daw himatayi. ");
INSERT INTO bkd_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ba tuminubag si Festo hu “Si Pablo pinandayaan bantayi diyà ta Cesarea ba laus a dà aglikù diyà. ");
INSERT INTO bkd_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Aman ipaduma en kanak sa mga punuan nuy daw ku amin salà taena ha etaw makasumbung dan en.” ");
INSERT INTO bkd_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Su maiwas sa subra ha nangkasimana luminikù si Festo diyà ta Cesarea. Su maisab ha aldaw mininuu duun hu hukmanan daw ipaatubang si Pablo. ");
INSERT INTO bkd_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Su makaatubang en si Pablo linibutan hu mga Judio ha nangapuun diyà ta Jerusalem ha migsusumbung kandin hu mabegat tungkay ha mga salà, ba hurà dan duun mga kamatuuran. ");
INSERT INTO bkd_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Dayun nangatarengan si Pablo ha tagyanaen “Hurà ku kasupak sa Kasuguan hu mga Judio daw hurà a maal en seled diyà ta Timplo daw hurà a daan supak ki Cesar sa Harì ta Roma.” ");
INSERT INTO bkd_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ba tumenged ta agkabayà man si Festo ha mabayà-bayà sa mga Judio ininsaan din si Pablo hu “Kabayà ka ba ku dumiyà ki ta Jerusalem daw diyà ku ikaw hukumi taini ha mga sumbung ikaw?” ");
INSERT INTO bkd_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Si Pablo tuminubag hu “Taini ad iman ta atubangan nu sikaw sa maghuhukum ha sinugù hi Cesar aman kinahanglan ha dini a dà hukumi. Natun-an nud en ha hurà ku nabuhat ha salà duun hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ku amin ku man nabuhat ha angayan ha himatayan a harì a taghangyù ha ilikay a. Ba tumenged ta kenà laus haini sa mga sumbung dan kanak hurà bisan sabuwa ha makabaluy hu pagtugyan kanak diyà ta kandan. Aman aghangyuen ku iman diyan ta ikaw ha iyan en si Cesar magbistiga kanak.” ");
INSERT INTO bkd_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Su makapenga si Festo makiglalang hu mga palagsambag din uminikagi ha “Tumenged ta agkabayaan nu ha iyan si Cesar magbistiga ikaw igpadiyà ku ikaw.” ");
INSERT INTO bkd_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Su pila en ha aldaw nakauma si Harì Agripa daw si Bernice diyà ta Cesarea hu pagtahud ki Festo. ");
INSERT INTO bkd_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Su maiwas en sa pila ha aldaw intultul hi Festo duun ku harì sa mahitenged ki Pablo ha tagyanaen “Amin sabuwa ha purisu dini ha hurà ipaguwà hi Felix. ");
INSERT INTO bkd_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Su makadiyà a ta Jerusalem sa mga labaw ha sinaligan hu paghalad daw sa mga magulang hu mga Judio migsusumbung dini ta kanak daw hinangyù a kandan ha hukuman ku haini sa etaw. ");
INSERT INTO bkd_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ba inikagiyan ku sidan ha sikuy sa mga sakup ta Roma kenà taw batasan ha hukuman taw sa etaw ku harì pa makapangatubang taena ha migsumbung kandin ta daw makapangatarengan. ");
INSERT INTO bkd_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Aman su makadini en sidan ta Cesarea hurà a magyawat ta su isab ha aldaw mininuu a dayun duun hu hukmanan daw ipaatubang kanak haena sa purisu. ");
INSERT INTO bkd_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ba su maman-ikagi haena sa migsusumbung kandin abi ku ha mabegat sa salà taena ha etaw, ba hurà man diay. ");
INSERT INTO bkd_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Iyan dà pigsawalaan dan sa mahitenged hu kandan ha tinuuwan daw sa mahitenged hu etaw ha tagngaranan ki Jesus ha minatay en ba inikagi hi Pablo ha nabanhaw dà. ");
INSERT INTO bkd_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Tumenged ta harì kud haena agkahusay ininsaan ku si Pablo ku mabayà ba ha diyà ta Jerusalem husaya. ");
INSERT INTO bkd_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ba hinangyù din ha iyan en sa Harì ta Roma magbistiga kandin. Aman pinabantayan ku haena ta igpauwit ku diyà ki Cesar.” ");
INSERT INTO bkd_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Dayun uminikagi si Agripa diyà ki Festo hu “Agkabayaan ku agpalilimani sa katarengan din.” Tuminubag si Festo hu “Asem ku maaldaw mapaliman nu.” ");
INSERT INTO bkd_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Su maisab ha aldaw si Agripa daw si Bernice migbisti hu harianen ha bisti dayun sumineled duun taena ha tigumanan duma hu mga labaw ha kapitan hu sundalu daw hu mga tinahud duun taena ha banuwa. Dayun insugù hi Festo ha ipaatubang si Pablo ");
INSERT INTO bkd_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","daw minikagi si Festo hu “Halangdun ha Harì Agripa daw sa alan ha dini iman, taini en su etaw ha hinangyù kanak hu tagkukulahiay ha mga Judio dini ta Cesarea daw diyà ta Jerusalem ha himatayan ku. ");
INSERT INTO bkd_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ba nasusi ku ha hurà taini salà ha angayan hu kamatayen. Tumenged ta huminangyù haini ha iyan en magbistiga kandin sa Harì ta Roma igpauwit ku haini diyà. ");
INSERT INTO bkd_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ba hurà ku agkatun-an ha igsulat duun taena ha Harì taw mahitenged kandin. Aman impaatubang ku haini dini ta inyu labi en ikaw, Harì Agripa, ta daw ku mabistiga taw en haini amin kud makasulat. ");
INSERT INTO bkd_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ta bà su kenà makatarenganen kanak ku ipauwit haini sa purisu duun hu Harì ta Roma ha hurà makasulat ha salà din.” ");
INSERT INTO bkd_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Dayun inikagiyan hi Agripa si Pablo hu “Intugut en ikaw iman ha mangatarengan ka.” Aman migsingyas si Pablo daw pangatarengan ha tagyanaen ");
INSERT INTO bkd_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Harì Agripa, adagi gayed sa kabayà-bayà ku ha makaatubang a iman ikaw daw makapangatarengan a mahitenged hu sumbung kanak hu mga Judio ");
INSERT INTO bkd_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ta natun-an nu man gayed sa alan ha tulumanen hu mga Judio daw sa tagsawalaan dan. Aman aghangyuen ku ikaw ha antusen nu sa pagpaliliman hu ag-ikagiyen ku. ");
INSERT INTO bkd_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Natun-an hu mga Judio ku inu sa batasan ku sugud dà su anay ha atiyuay a pa duun hu kanak ha banuwa daw bisan diyà ta Jerusalem. ");
INSERT INTO bkd_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nalugay en sa kakilala dan kanak daw ku agkabayaan dan ngaay makapanistigus en sidan ha siak na Fariseo a daw tagtumanen ku gayed sa Kasuguan day. ");
INSERT INTO bkd_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Iman impaatubang a dini ta ikaw tumenged hu sumbung kanak ta tinuuwan ku ha matuman asem sa insaad hu Dios duun hu mga gin-apuan day ha mabanhaw sa nangamatay en. ");
INSERT INTO bkd_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Iyan haini taghinamen hu alan ha mga Judio aman tagsimbahen day gayed sa Dios aldaw daw ku daleman. Halangdun ha Harì, tumenged hu pagtuu ku taini insumbung a hu mga Judio. ");
INSERT INTO bkd_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Sinyu sa naamul-amul dini, imbà kaw harì agtuu ha mabanhaw hu Dios sa mga nangamatay en? ");
INSERT INTO bkd_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Su anay abi ku daan ha agkabayaan hu Dios ha buhaten ku sa pagpasipala taena ha mga etaw ha tuminuu ki Jesus ha taga-Nazaret. ");
INSERT INTO bkd_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Iyan haini binuhat ku su anay diyà ta Jerusalem ta sa mga labaw ha sinaligan hu paghalad mig-ila kanak hu katenged ha pamurisuwen ku sa mga tumutuu daw ku amin aghimatayan ag-uyun a daan. ");
INSERT INTO bkd_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kapila ku gayed elegi sa mga simbahan daw siluti sa mga tumutuu diyà daw pigsiguruwan ku ha mangakaendà sidan hu pagtuu dan. Agkangapaukan ku gayed sidan aman pinanlupug ku pa sidan duun hu madiyù ha mga banuwa daw pasipalahi. ");
INSERT INTO bkd_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Duminiyà a daan ta Damasco sa tag-uwit hu mga sulat ha tagpamatuud ha iyan a sinugù hu mga labaw ha sinaligan hu paghalad hu pagdakep hu alan ha mga tumutuu ki Jesus. ");
INSERT INTO bkd_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Halangdun ha Harì, su agkaugtu en ha diyà kay pa ta dalan naahà ku sa masiga ha napuun diyà ta langit daw masiga pa gayed dì hu aldaw. ");
INSERT INTO bkd_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Alan kay nangaligid daw napaliman ku sa lageng duun hu Hebreo ha inikagiyan sa tagyanaen ‘Saulo, imbà a ikaw tagpasipalahi? Kahid-u nu ta hurà pulus tayana ha tagbuhaten nu.’ ");
INSERT INTO bkd_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Tuminubag a hu ‘Sin-u ka man, Ginuu?’ “Dayun uminikagi haena hu ‘Iyan a si Jesus sa tagpasipalahan nu. ");
INSERT INTO bkd_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bangun ka ta nakadini a ta daw mabuhat ka ha suluguen ku daw manunultul ka duun hu kaet-etawan mahitenged hu naahà nu daw hu igpadayag ku pa ikaw. ");
INSERT INTO bkd_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Bantayan ku gayed ikaw ha harì ka pasipalahan hu mga Judio daw hu kenà mga Judio. Agpaelegan ku ikaw sidan ");
INSERT INTO bkd_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ta daw makaindan sidan dayun umawà sidan duun hu kasukileman daw dumuun sidan hu kapawaan. Ta ku umawà sidan duun hu pagbayà hi Satanas daw magpasakup sidan duun hu Dios pinaagi hu pagtuu dan kanak mapasaylu gayed sa mga salà dan daw mabuhat sidan ha mga etaw hu Dios.’ ");
INSERT INTO bkd_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Aman Halangdun ha Harì Agripa, tinuman ku gayed sa impadayag kanak hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Sa una ha tinultulan ku iyan sa mga etaw diyà ta Damasco dayun sa diyà ta Jerusalem daw nalekep ku daan sa alan ha banuwa diyà ta Judea daw nakaduun a daan hu kenà mga Judio. Tinultulan ku sidan ha kinahanglan ha maghinulsul daw tumuu hu Dios dayun ipaahà dan gayed ha laus ha mighinulsul en sidan pinaagi hu maayad ha mga buhat dan. ");
INSERT INTO bkd_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Tumenged taini dinakep a hu mga Judio su duun a hu Timplo daw aghimatayan a ngaay kandan. ");
INSERT INTO bkd_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ba bisan iman taena binuligan a gayed hu Dios aman hurà a endà hu pagpanunultul duun hu kaet-etawan sa ubus sa kahimtang din daw sa matangkaw. Sa tigtultul ku iyan sa sinubay hi Moises daw hu mga propita ");
INSERT INTO bkd_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ha su Mesiyas kinahanglan ha mag-antus gayed daw matay. Ba iyan daan mauna mabanhaw ha harì en isab matay daw iyan manunultul duun hu mga Judio daw hu kenà ta daw mailawan sa henà-henà dan mahitenged hu pagluwas kandan hu Dios.” ");
INSERT INTO bkd_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Su kamulu pa si Pablo tag-ikagi nandasang si Festo ha tagyanaen “Agkalibeg ka gayed, Pablo, tumenged hu miglabay ha katatau nu.” ");
INSERT INTO bkd_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ba tuminubag si Pablo hu “Halangdun ha Festo, harì a agkalibeg ta sa tag-ikagiyen ku kamatuuran gayed. ");
INSERT INTO bkd_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Sikaw Halangdun ha Harì Agripa, natun-an nud en haini. Aman hurà a gayed magduwa-duwa hu pag-ikagi diyan ta ikaw ta saini hurà gayed makaheles ikaw. ");
INSERT INTO bkd_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Halangdun ha Harì Agripa, agtuu ka ba hu inikagi hu mga propita? Natun-an ku ha agtuu ka.” ");
INSERT INTO bkd_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Dayun tuminubag si Agripa hu “Abi nu gid ha laus a dà ikaw makabig duun hu pagtuu ki Cristo.” ");
INSERT INTO bkd_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Ba si Pablo tuminubag hu “Sa tig-ampù ku iman duun hu Dios iyan sa malugay daw ku madalì sikaw daw sa alan ha nakapaliman taini mailing kanak ha nakatuu ba harì mailing kanak ha napurisu.” ");
INSERT INTO bkd_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Dayun su harì, su gubernador daw si Bernice daw sa alan namanhitindeg ta agpaman-ulì en. ");
INSERT INTO bkd_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Su humipanaw en sidan miglalang-lalang sidan ha tagyanaen “Saini ha etawa hurà din gayed nabuhat ha angayan ha purisuwen daw himatayan.” ");
INSERT INTO bkd_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Inikagiyan hi Agripa si Festo hu “Nakaguwà en ngaay haini ku hurà din hangyua ha bistigahen hi Cesar.” ");
INSERT INTO bkd_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Su mauma en sa panahun ha aglulan kay en payanaen diyà ta Roma ha sakup ta Italia intugyan si Pablo daw sa duma ha mga purisu diyà ki Julio sa kapitan taena ha mga sundalu ha tagngaranan hu Punduk hu Harì ta Roma. ");
INSERT INTO bkd_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Luminulan kay hu barko ha napuun ta Adramito payanaen hu mga banuwa ha sakup ta Asia. Duminuma daan kanay si Aristarco sa taga-Tesalonica ha sakup ta Macedonia. ");
INSERT INTO bkd_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Su maisab ha aldaw nakadunggù kay diyà ta Sidon. Agkahid-uwan hi Julio si Pablo aman tinugutan din ha mamisita duun hu mga amigu din ta daw mailahan hu kinahanglanen din. ");
INSERT INTO bkd_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Su dumayun kay en nasal-aw day sa maseleg ha kalamag aman diyà kay uminagi ta dibaluy hu pulù ta Cipro ta hurà duun bagyu. ");
INSERT INTO bkd_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Su malayun day en sa dagat ha atbang hu mga probincia ta Cilicia daw Pamfilia nakadunggù kay diyà ta Mira ha sakup ta Licia. ");
INSERT INTO bkd_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Diyà nakaahà su kapitan hu sundalu hu barko ha napuun ta Alejandria ha tagdiyà ta Italia aman namanlulan kay duun. ");
INSERT INTO bkd_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nalugay kay nakauma diyà ta Nido daw miglised kay gayed tumenged hu maseleg ha kalamag. Namagyu gayed aman duun kay uminagi hu dibaluy hu pulù ta Creta ta hurà duun bagyu daw duminayun kay diyà ta atbang ta Salmon. ");
INSERT INTO bkd_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Migpakilid kay ba nalegenan kay gihapun hangtud en ha nakauma kay duun hu lugar ha tagngaranan hu Maayad ha Dungguanan ha ubay en hu banuwa ta Lasea. ");
INSERT INTO bkd_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nayawat kay gayed hu malugayad ha panahun daw malegen en gayed sa pagdayun day tumenged ta tingbagyu haena. Aman migsambag si Pablo ");
INSERT INTO bkd_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","hu kagi din “Mga amigu, natun-an ku ha ku dumayun kuy malegen gayed sa maul-ulahan taw ta sa mga karga taw mangalaag daw bisan haini sa barko malened daw amin pa gayed kanuy mangamatay.” ");
INSERT INTO bkd_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ba su kapitan hu sundalu hurà magpaliliman ki Pablo ba iyan din tinuuwan sa kapitan taena ha barko daw sa tag-iya duun. ");
INSERT INTO bkd_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Sa dungguanan duun taena ha lugar kenà maayad ha tagtimaan ku madaet sa panahun. Aman sa kadakelà kandan agkabayà ngaay ha dumayun sidan diyà ta Fenice ha sakup ta Creta ta saena maayad ha dungguanan daw harì daan agkauma hu bagyu. ");
INSERT INTO bkd_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Su mahinay en sa kalamag nahenhenaan dan ha dumayun kay en diyà ta Fenice aman binutwà dan su angkla daw duminayun kay ba migpakilid kay duun taena ha pulù ta Creta. ");
INSERT INTO bkd_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Hurà kalugay naumahan kay hu mabis-ay gayed ha bagyu ha napuun ta gaun. ");
INSERT INTO bkd_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Su barko harì en gayed pakasèsè hu bagyu aman impatayà day en ku hindu duun uwita hu kalamag. ");
INSERT INTO bkd_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Dayun nakaubay kay ku atiyuay ha pulù ta Cauda daw mighinay daan sa kalamag, aman ingkarga dan haena sa bangkà ha tagguyuden taena ha barko ba nalegen-legenan gayed sidan. ");
INSERT INTO bkd_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Su makakarga en haena binanggetan dan su barko hu adagi ha pisì ta daw harì mabengkag. Impababà dan su layag taena ha barko ta daw mauwit haena hu kalamag ta agkahaldek sidan ku makasagyad sa barko diyà ta baybay ta nasud ta Libya. ");
INSERT INTO bkd_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Su maisab ha aldaw namis-ay dà paman sa bagyu aman impanlambeg dan sa mga karga diyà ta dagat. ");
INSERT INTO bkd_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Su ikatulu en ha aldaw iyan dan en paman impanlambeg sa mga galamiten taena ha barko. ");
INSERT INTO bkd_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Tumenged hu pila en ha aldaw sa harì day en agkaahà sa siga hu aldaw daw sa mga bituen daw mabis-ay pa gayed sa bagyu ha duminasmag kanay hurà kay en maghinam ha malibri kay pa. ");
INSERT INTO bkd_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Duun taena nalugay en daan ha hurà sidan makakaen aman huminitindeg si Pablo daw ikagi hu “Mga amigu, maayad pa ngaay ku migpaliliman kaw kanak ha harì kuy enà umawà diyà ta Creta ta harì kuy pa ngaay mayanaen. ");
INSERT INTO bkd_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ba iman paniguru kaw daw harì kaw agkahaldek ta malened haini sa barko ba hurà matay kanuy. ");
INSERT INTO bkd_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ta ganina ha daleman sa Dios ha Magbabayà ku daw iyan tag-alagaran ku minikagi kanak pinaagi hu balinsuguen din ");
INSERT INTO bkd_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ha tagyanaen ‘Pablo, harì ka agkahaldek ta kinahanglan ha makapangatubang ka gayed ki Cesar, aman tumenged ikaw saini ha mga duma nu malibri daan.’ ");
INSERT INTO bkd_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Aman mga amigu, harì kaw agkasamuk ta agtuuwan ku gayed ha matuman sa inikagi kanak hu Dios. ");
INSERT INTO bkd_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mauwit kuy hu kalamag ba makasagyad kuy duun hu sabuwa ha pulù.” ");
INSERT INTO bkd_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ikaduwa en ha simana sa kauwit-uwita kanay hu kalamag diyà ta Dagat ta Mediteraneo. Su maliwarà en sa daleman taena pigtagnà-tagnà hu mga suluguen duun hu barko ha ubay kay en duun hu pulù. ");
INSERT INTO bkd_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Aman sinukud dan sa kadalem taena ha wahig na kaluwaan pa ha depa. Duminayun sidan hu atiyuay daw sinukud dan en paman na sampulù dà daw lalima ha depa. ");
INSERT INTO bkd_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Nahaldek sidan ku makasagyad haena sa barko duun hu batu aman linened dan sa haepat ha angkla diyà ta kahudiyanan ta ima dan ngaay ha agkaaldaw en. ");
INSERT INTO bkd_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Agkabayà ngaay ag-awà su mga suluguen duun ku barko aman intuntun dan sa bangkà diyà ta unahan daw sibù kun daan ha agleneden dan su angkla diyà. ");
INSERT INTO bkd_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ba inikagiyan hi Pablo sa mga sundalu daw su kapitan dan ha “Ku awaan kuy iman taini ha mga suluguen hurà gayed malibri kanuy.” ");
INSERT INTO bkd_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Aman tinamped taena ha mga sundalu su hiket ku bangkà daw nangaanud haena. ");
INSERT INTO bkd_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","34","Su madani en agkaaldaw inikagiyan sidan hi Pablo hu “Sampulù en daw haepat ha aldaw sa kasalang nuy hu pagkaen, aman kaen kaw en ta daw makabis-ay kaw ta hurà gayed mainu inyu.” ");
INSERT INTO bkd_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Su maikagi en haena hi Pablo tuminimù hu supas daw ampui haena duun hu atubangan dan. Dayun pinangebing din haena daw kaen. ");
INSERT INTO bkd_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Su maahà dan haena hiningan-an sidan dayun alan sidan namangaen. ");
INSERT INTO bkd_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Sa kadakelen day duun taena ha barko 276. ");
INSERT INTO bkd_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Su makakaen en sidan impanlambeg dan diyà ta dagat sa mga karga ha trigo ta daw humagkap sa barko. ");
INSERT INTO bkd_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Su maselem en harì dan agkakilala su pulù ha naubayan day. Ba naahà dan ha amin duun luuk ha malugayad sa pantad duun aman sa henà-henà dan ha mabaluy ha makadunggù sa barko duun. ");
INSERT INTO bkd_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Pinanamped dan su pisì ha inhiket ku angkla daw inawaan dan haena. Hinukad dan daan su pisì ha imbangget taena ha bansalan ta daw magamit su bansalan hu pagwaling taena ha barko. Dayun intaud dan su layag diyà ta unahan ta daw mauwit haena hu kalamag diyà ta baybay. ");
INSERT INTO bkd_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ba nakasagyad gayed su barko duun hu mababaw. Nakalebeng sa unahan din daw nagebà sa hudiyanan taena tumenged hu mabis-ay ha mga baled. ");
INSERT INTO bkd_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Nahenhenaan ku mga sundalu ha panhimatayan dan en sa mga purisu ta daw harì sidan makaawà. ");
INSERT INTO bkd_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ba agkabayaan ku kapitan ha malibri si Pablo aman hurà din itugut ha panhimatayan sidan. Migsugù haena ha sa pakatuen ag-anunung iyan umuna umagbul daw dumuun taena ha pulù, ");
INSERT INTO bkd_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","sa duma lumupug daan ba gumabay hu tabla daw hu bisan inu duun taena ha nagebà ha barko. Aman pinaagi taena alan kay nakauma duun hu baybay ha hurà nahitabù kanay. ");
INSERT INTO bkd_vpl VALUES ("AC28_1","074_28_1","ACT","28","1",