﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjz_vpl;
CREATE TABLE bjz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjz_vpl WRITE;
INSERT INTO bjz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso da mambube mane nanjogo daiyagha Abraham davareta siroruta furieta, Devit siroruturia, kotú Devit davareta siroruta furia, Iesu Keriso siroruturia-da gaga evere. ");
INSERT INTO bjz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mo Aisak da afa re. Kotú Aisak mo Jekop da afa re. Jekop mo, Juda unda ikoko mendide, númanda afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda mo, Peres ungá Sera ghada afa re. Kotú, Tamar mo ungá unda aya re. Peres mo, Hesron da afa re. Hesron mo, Ram da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram mo, Amminadab da afa re. Kotú, Amminadab Nason da afa re. Nason mo, Salmon da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon mo, Boas da afa re, kotú Boas nue aná Rahap re. Kotú Boas mo, Obet da afa re, kotú Obet da nue aná Rut re. Obet mo, Jesi da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Atá Jesi mo, Kini Devit da afa re. Kotú Devit mo, Solomon da afa re. Solomon da nueda embó sei aná Uria re. ");
INSERT INTO bjz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon mo, Rehoboam da afa re. Kotú Rehoboam mo, Abiya da afa re. Abiya mo, Asa da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mo, Jehosafat da afa re. Kotú Jehosafat mo, Jehoram da afa re. Jehoram mo, Usia da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia mo, Jotam da afa re. Kotú Jotam mo, Ahas da afa re. Ahas mo, Hesekia da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia mo, Manassah da afa re. Kotú Manassah mo, Emon da afa re. Emon mo Josaia da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Atá Josaia mo, Jehoiakin (o Jekonaia reta rosore) unda ikoko mendideda afa re. Númane, Abua Babilon da mene-mene ari kakatomi Israel enembonu susughi ea bua, númanda roo enda anava igiguturia-da rifova siroruturie. ");
INSERT INTO bjz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Avore, númane nandia, roo enda Babilon anava bua igigituturia-va Jehoiakin da mendi Sealtiel siroruturie. Kotú Sealtiel mo, Serubabel da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel mo, Abiud da afa re. Kotú Abiud mo, Eliakim da afa re. Eliakim mo, Asor da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor mo, Sadok da afa re. Kotú Sadok mo, Akim da afa re. Akim mo, Eliut da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut mo, Elieser da afa re, Kotú Elieser mo Matan da afa re. Matan mo, Jekop da afa re. ");
INSERT INTO bjz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Atá Jekop mo, Josep da afa re. Kotú Josep da evetu aná Meri re. God na ututurieta furia embó Iesu, aná Meri na fufirie. ");
INSERT INTO bjz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aghá-gea, Iesu da mambube mane Abraham da rifova reta furia, Devit dava bubua vitiria rifova dano 14 re. Kotú Devit da rifo vareta furia, Babilon enembomi Jiusi enembo susughi ea rururia beago, mambube mane dano 14 re. Kotú dabako aghago unda mambube mane anavareta siroruta furia, Iesu da rifova buburituria, dano 14 re. ");
INSERT INTO bjz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso endava daiyagha fufirieta siroruturia, aná evere. Unda nue Meri, gimasa ragaro Josep du datu didighurieta, ungá furá danode takembambi-da dibeva, Asisi Kakarada anomi Meri tambouvude uria-nu, Josep seibe gerurie. ");
INSERT INTO bjz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Avore, Josep umó embó taubana eini re. Aghá-gea, rourogo, Meri enembo oruabeda dibeva meka gauve-degea rirota, umó Meri kivumi doaita nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Umó aghá nundubutueta, Jojabeeda anerami dirava isagha ea, undú eghá ririe, “Josep, Devit da mendi, imó Meri yagera ari mania oru ata! Anada bee mo, umó God da Asisi Kakarada anomi tambouvude ea vitie. ");
INSERT INTO bjz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Unda mendi fumbaita rouvia-da ragaro Iesu righi!” Anada bee mo, umó donu adua-mi, God unda natofoda ari akokogo nundubea gia doarida emboro ifegaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aghá uria-da bee mo, Jojabeena gaga donu ferovetadava riria-nu furá bee ari-du rea, aghá urie. Aná Gaga mo, evere: ");
INSERT INTO bjz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ariri mose eini jo kombo undiri ambi irirota, tambouvude ea, soká mendinu fumbota, enembo dano unda ragaro Imanuel regegaita rousue. Aná ragaroda bee mo, ‘God namonde danode vitie.’” ");
INSERT INTO bjz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aghá rea sidara urieta, Josep umó eevo kambesi vareta erea, Jojabeeda anera, dirava undú gaga donu riria aghagonu urota, Meri unda evetudu yagera ea bua, unda kambova arie. ");
INSERT INTO bjz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ungá viro ambi irirota, soká mendinu fufirieta, Josep na unda sokáda ragaro Iesu ririkurie. ");
INSERT INTO bjz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Avore, fefera anava embó, ragaro Herot, umó kini ea irieta, Iesu mo Betlehem naa, Judia Frovensi anava fufirie. Fufirieta, beforo gari enembo dumeni eini-eini donu siroraita urari mo, damanava gia tanana egegeta uria enembomi, beina fefera vitari kena reta furia, Jerusalem bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bubua, númanda uriga eghá egeguturie, “Jiusi enemboda kini reka fumbia mo niavo viti? Námane unda damana beina fefera vitari kena gigigutara-gea, undú tumogha baĩ aita reisi-fore.” ");
INSERT INTO bjz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aghá regeguturieta ningia, Kini Herot de kotú Jerusalem enembode dano aná bingá niningigea, mana-mana urota, gaa bee sidara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aghá ea, fristi* maneda kokotofude, Moses da Gaga Irugari Kakatode* dano aghi jufirieta furia, undava danode desuturieta, aná soká niavo sirorasua-du uriga urie. ");
INSERT INTO bjz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aghá uriga urieta, númane mino undú eghá regeguturie, “Umó naa Betlehem, Judia Frovensi rova sirorasue. Anada bee mo, feroveta unda siroraridu gaga eghá gefirie: ");
INSERT INTO bjz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nímane Betlehem naa, Judia Frovensiva vitera enemboda bingá jojabe ea, Judia undida kokotofu dumenida bingá serigaita rouvie. Anada bee mo, nímanda rorova embó eini beforo righari ea, anda natofo Israel enembo kaifa aita rouvie.’” ");
INSERT INTO bjz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aghá rea sidara urieta, Herot na kivumi aghi jufirieta, aná beforo gari enembo undava fufuguturieta, númandava aná damana fefera domi siroruturia-nu tanana urie. ");
INSERT INTO bjz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tanana ea, númane ninenguturota eghá ririe, “Nímane igige, Betlehem naava bubua, aná soká tava ea tatambugea, tutumi kaverea fufuge! Regegadi ningia, amó beago ya, undú tumogha baĩ are!” ");
INSERT INTO bjz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aná kini da gaga donu riria ningia, númane seriguturie. Igiguturota, aná damana beina fefera vitari kena gigiguturia-mi númanda dibe kena aria, aná soká vitiria kambesida itiva tukú urie. ");
INSERT INTO bjz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Númane aná damana rekago gigiguturia aghade, neno gangorogha dano igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Aria, aná soká nue Meri gha vitiria kambova bubua, gangorogha dano aná sokádu númanda tumogha dano baĩ urota, númanda vesa goldi, kotú ika muu eini munode ragaro frankinsensi, kotú ika muu munode eini, ragaro meer reta rousua ananu bua, vesa ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aghá egegea, God donu dira einiva númandu riria-nu nundubuturota, jo ya Herot dava bubambi, emboro einiva kaverea aria, númanda roo endava bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aná beforo gari embobo seriguturia-da ambova, Jojabeeda anerami dirava, Josep du eghá ririe, “Imó erea, inda soká nuegha bua serigea, Isip igige! Bubua, anava iradi-gea, anona rata ningia kaverea furadi! Anada bee mo, Herot na, unda enembo dumeni aná soká tava ea data amburari-du raita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aghá riria-du, Josep tumbade erea, nungarimi unda soká nuegha bua, numonde Roo Enda Isip igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aria, anava irieta, Kini Herot ambubuturie. Jojabee na ferovetadu donu riria aghade, gaa bee urie, “Anona ririeta, anda mendi Isip roo enda vareta furie.” ");
INSERT INTO bjz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aná beforo gari enembo umó kukuviria-nu tanana ea, Kini Herot neno akuago urie-gea, Betlehem naa kotú naa ijoijokoko anada kasava soká vividenu dedegota ambubugari-du ririe. Aná beforo gari enembomi damana nanjigo siroruturieta regeguturia-nu nundubuturota, aná soká mane vivide ghaeko ungaghada vorari kena dano dedegota, ambubugari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kini donu riria-da bee siroruturia aghade, feroveta Jeremaia gaga donu gefiria, aná gaa bee urie. ");
INSERT INTO bjz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aghade, Rama naava Resel jii be fugea rieta niningiguturie. Resel na unda sasingudu jii be fugia rirota, enembomi undú neno jama ututugasue-tago, unda sasingu dano ambubuguturia-du, umó númanda sonemba bari injigha urie.” ");
INSERT INTO bjz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Herot ambubuturia-da ambova, Josep Isip irieta, Jojabeeda anerami dirava isagha ea, undú eghá ririe, “Aná embó inda mendi data amburari-du riria, ambubuta-du, imó erea, inda mendi nuegha bua kaverea, Israel roo endava igige!” ");
INSERT INTO bjz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aghá ririeta ningia, Josep erea, unda mendi nuegha bua, numonde kaverea, Israel roo endava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Anava yaita urota, gaga eini nininguria mo, embó ragaro Arkelaus numamo Herot da kambesi bua, kini ea, Judia Frovensi kaifa eta urie. Ananu niningurie-gea, unda mendi nuegha bua yari oru urie. Tago, dirava isuri gaga dumeni ningia, umó aria, Judia Frovensi serigea, Galili Frovensiva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Númane aria, naa ragaro Nasaret bubua, anava naa dighia vitiria-du, Jojabee na ferovetadava donu riria, aná furia gaa bee urie, “‘Umó aná Nasaret embó re,’ regegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Anada ambova fefera eini, Jon Bafutaito Ari Kato aria, Judia Frovensi anava uvu tefo, kotú enembo irambi kambesiva bubua, unda minono eghá reta urie, ");
INSERT INTO bjz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“God unda Natofo* kaifa ari fefera aná etia utuvako etua-du, neno kaverea, nímanda ari akokogo dodogadi rere!” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","God da feroveta Aisaia seibe unda buka rova Jon du eghá gefirie, “Embó eini uvu tefo, kotú enembo irambi kambesiva avo irirota, ghogho reirie, ‘Jojabeeda emboro simbuge, dambu ae!’” Aisaia na aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon anava irirota mo, umó oka kamero da tamututumi arinu dighia asugeta urie. Kotú, unda abaguva dighari beago aná kamero da andoromi arinu bua fifinembea dighita urie. Aghade umó avo irirota, siside firukadenu bua undita urie. ");
INSERT INTO bjz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anava iriaveta, Frovensi Judia enembo oruaruabe, bogu naa Jerusalem enembo oruabe kotú uvu Jordan kasava vitiria enembo oruabede dano fuava, undava deseta urie. ");
INSERT INTO bjz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jon da gaga niningiguturota, númanda ari akokogo isagha egegutuaveta, Jon na númane Jordan uvuva bafutaito eta urie. ");
INSERT INTO bjz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","9","Aghá urota geruria mo, Moses da Gaga Kaifa kakatode* Sadyusi* enembo oruabede unda bafutaito rorouria kambesiva fufuguturia-du, umó eghá ririe, “Nímane angoghoda fufumbugari re! Nímane jo neno kaverambi irirota furá bafutaito nuenembo egegadora, God ari akokogoda mino utaita rei-nundubutua, jo serigambi aita rosoravore. Nendufako, ‘Anda afa Abraham re,’ rirota, ‘Amó God da neno bari mendi aghago re.’ mania nundubata! God ená singoi rata, Abraham anada sasingu nindari inono re. Unda bouvu serigaita nundubadora mo, neno kaverea, nímanda ari-bari akokogo doa, aito taubana fufugege! ");
INSERT INTO bjz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Oto seibe ika ruruva tafugaita simbugea vitie. Ika domi bee taubana righambi adua mo, umó vegea, ivari tumanadu evirota vitia-va fugota, evaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Avore, nímane avona neno kaverea, unda ari-bari akokogo karigea, aito taubana fugadua-nu anona tefo uvumi bafutaito eta rore. Tago, embó eini anda ambova refia, umó ano tofo re, amó jo umongo irambi re. Anode duroghade anda jo undago irambi re. Nímane unona Asisi Kakaragha ivarighami bafutaito aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Umó enembo iruraita simbugea vitie. Umó faragho genjeguturota, faravada vee simbugea bua, unda koromava ititurota, faragho fugota, tumanadu reivia ivariva evivigaita rousue,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Anada ambova, Iesu unda naa Nasaret Galili Frovensi anavareta furia, uvu ragaro Jordan anava bubua, Jon na umó avo bafutaito ari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Aghá urieta, Jon umó Iesu bureguturota eghá ririe, “Inona amó bafutaito arigo, dodu anona imó bafutaito ari-du ete?” ");
INSERT INTO bjz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ririeta, Iesu mino eghá ririe, “Avotago, do-gea, angá aghá ata-gea, God donu uno rouvia-da bee siroroe!” Aghá ririeta, Jon umó Iesu da uno uria aghagonu aita “avore” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Umó bafutaito urieta, Iesu umó uvuvareta vivitua aghade, uutu ifeguturieta, Asisi Kakarami eto-bato dii ukugo isaghava vorefuria, undava asumbutueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aghá urieta, uutuvareta be fugia eghá ririe, “Ená anda neno bari Mendi re. Unda irari gerurota, anda neno roo gangoromi beda rouvie!” ");
INSERT INTO bjz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aghade Satan na Iesu kuvia gari-du rea, God da Asisimi umó unumbea, enembo irambi, kotú uvu tefo kambesiva arie. ");
INSERT INTO bjz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aria, tumba kotú onembo 40 tama uria-da ambova umó baimana itatama urie. ");
INSERT INTO bjz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aghá ueta, Satan furia Iesu dava eghá ririe. “Imó God da mendi iradora mo, rege, ená singoi farava nindota undadi!” ");
INSERT INTO bjz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aghá ririeta, Iesu mino eghá ririe. “God amindu gaga eghá ririeta, gefirie: ‘Enembo jo undarimi jebuga bee tambua bambi aita rouvie-tago, gaga nanjogo God da bemi riria anami, jebuga tambua baita rouvie.’” ");
INSERT INTO bjz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aghá ririeta, Satan na Iesu unumbea bua aria, bogu naa kakara, Jerusalem bubua aria, God du Tafaroro Ari Kambo* fouva vitia, iti beeva jiria Iesu du eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Imó God da mendi iradora mo, God da Gaganu gaabee urota, ená kambo fouvareta jau ege, gare! Anada bee mo, God da Gaga eini eghá reirie: ‘Imó jau ea voradora mo, God na rata, anera mane númanda ingo beisi ea irirota, númanda ingova desembuturota, inda eka jo singoiva dea borambi aita roravore.’” ");
INSERT INTO bjz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aghá ririeta, Iesu mino undú eghá ririe, “Aná rera, aná gaa bee re, avotago God da Gaga einiva eghá reirie: ‘Mania nímanda Jojabee God kuvia gigigata!’” ");
INSERT INTO bjz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aghá ririeta, umó rekago Iesu bua aria, dafaru iti bee itiva jiria, aná roo enda nanjogoda sevo durogha dano iruguturieta, Iesu gerueta, eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Atá imó andú tumogha dano baĩ adora, ená rei-gerora eini-eini dano, anona indú utaita rore.” ");
INSERT INTO bjz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aghá ririeta, Iesu mino undú eghá ririe. “Satan, amó doa serige! God da Gagava eghá reirie, ‘Nímanda Jojabee God nuenembo tumogha baĩ egege! Kotú unda uno nuenembo egege!’” ");
INSERT INTO bjz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aghá ririeta, Satan umó doa seriguturieta, anera mane furia, Iesu sonembuturie. ");
INSERT INTO bjz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jon bua, diburava gajiturieta ningia, Iesu kaverea Galili arie. ");
INSERT INTO bjz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","14","Feroveta Aisaia sei donu riria-nu bee ari-du rea, Iesu Nasaret doa aria, Kaperneam asumbea vitirie. Bogu naa Kaperneam aná sao Galili kasava Sebulun ungá Naptali undida kambesi rova re. Aisaia da gaga, aná evere: ");
INSERT INTO bjz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Abua Sebulun ungá Naptali ghada roo enda emboro sao diva vitia dano, Israel enemboda gitofomi susughi ea, righia vitie. Uvu Jordan beina fefera vorari kena Galili frovensida enda dano gitofomi númanda tofo rururie. ");
INSERT INTO bjz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Atá aná gitofo bingoiva vitiria-mi, unana jojabe gigituturie, númane avona amburarida utumuva vitiria-dava, rifo atiturie.” ");
INSERT INTO bjz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Fefera aghade Iesu tutuno ea, minono eghá ririe. “God unda natofo* kaifa arida fefera etia, uutuva etua-du neno kaveradi rere!” ");
INSERT INTO bjz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Galili sao jojabe betuva deĩ ea irurota, uvu oka bari kakato Saimon, o Pita reta rosora, unda ikoko Andru gha ungá saova moyuva fugitueta gerurie-gea eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Anda ambova fufuge, anona irugota, moyuvami uvu oka buta rosora aghagonu, enembo unumbea bua, andava furadi-gea, anda ambo nimbi egegoe!” ");
INSERT INTO bjz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aghá ria, jo gaimbo ambi, ungá unda moyuva avo doa erea, Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anavareta irurota geruria mo, Sebedi unda sasingu ungagha, Jems ungá Jon ghade númanda ghaava* moyuva fugaita simbugutueta gerurie-gea, númandu ghogho ririe. ");
INSERT INTO bjz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ghogho riria aghade, gaimbo ambi ungá unda ghaade numamode doa, Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu aria, Galili Frovensi enemboda nghaĩ itari kambova* dano anava iruguturota, God unda natofo* daiyagha kaifa eta rouvia-da Gaga Taubananu minono rirota, kaemi enembo righia damé-damé eaveta, sembago ea irari kotú kae bua irari enembo eaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iesu aghá uua-da bingá aria, Siria Frovinsi va enembo dano ningia fafate urie. Urie-gea, númane erea, enembo avona kosisi sembago bua vitiria-de, mema itatama urota vitiria-de, taimu akokogomi asuguturieta vitiria-de, enembo avona jifeta uria-de, kotú eka ingo takembaride dano bua, Iesu dava fufuguturieta, unona urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galili Frovensi, kotú Dekapolis Frovensi, Jerusalem, Judia Frovensiva kotú uvu Jordan beina fefera vitari kena enembo natofo oruaruabe Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Avore, Iesu aná natofo jede gerurie-gea, umó aria vitia, ooto diva asumbuturie. Aghade, unda ambo nimbi undava desiturieta, ");
INSERT INTO bjz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","umó tutuno ea, númane iruguturota, eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dibe durumugari enembonu God kaifa eta rouvia-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jii rirota vitia enembodu rere, God na númane tavo tatau aita rouvia-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Durumugea vitia enembodu rere. God donu be gajiturota utaita riria-nu ambova baita rousua-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","God da uno egegaita baimana itatama eta rousua enembodu rere. God na númandu taubana jojabe utota bubugaita rousua-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kokomanami mema bouvu utota nundubea gia doadua enembodu rere. Irurari feferava God na númanda dinunu beago, nundubea gia doa sonembaita rouvia-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Neno roo simbugea vitia enembodu rere. Númane ambova God da dibeva jiria, umó dibe mokomi gigigaita rousua-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Siriri utari kakatodu rere, ambova God na númandu, ‘Anda sasingu re,’ raita rouvia-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","God da uno eta rousua enembodava gitofomi mema bouvu ututa rousua-du rere. God na númane kaifa eta rouvia-du, gangoro egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nímane avona amó gaabee egegadora-du, natofomi nímandu tauga kavavana dibe beva regegadua o mema bouvu nímandava utadua o nímanda tamova gaga gavera regegadua-du, gangoro egegadi rere! ");
INSERT INTO bjz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Feroveta seibe nímanda dibe kena fufuguturia-dava beago, mema bouvu dabako aghagonu ututurie. Tago, nímanda mino jojabe uutuva vitia-nu utota baita rosora-du gangoro egegadi rere. ");
INSERT INTO bjz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nímane ená endava vitia enemboda ireri aghago re. Tago, ireri musisi ea, sororo ea ya vivi sidara adua mo, daiyagha ata-gea, unda vivi rekago siroradu? Umó rekago eini-eini dumeniva jijimu ari jo inono irambi re. Amindu fugota, enemboda ekami fatia dasaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Bogu naa ooto itiva dighiaveta, enembo gigigeta rousua aghago, nímane ená endava vitia enemboda unana aghago ea vitera-du, nímandava unana bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aghago, enembo eini avona jo nanefa dungea bua, ovumi afuregambi aita rouvie. Tago, aná nanefa dungea bua, unda nanefa jirari sinakefiva itota, aná kambova enembo nanjogodu unana utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gari dabako aghago, nímanda ari taubana manenu gerurota, Afa uutuva vitia-nu raga regegari-du rirota, do-gea, nímanda unana enemboda dibeva janimboe!” ");
INSERT INTO bjz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Amó, Agho Dari Moses da gefiria, kotú gaga nanjogo feroveta maneda gegembuguturia-nu, jo seghaita furambi re. Tefo, númane donu riria-da bee ata sirorari-du etere. ");
INSERT INTO bjz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Amó nímandu gaa bee rere, uutude endade sidara aita rouvia-da dibeva eini-eini nanjogo Agho Dariva gembari vitia, itoko eini jo sidara ambi aita rouvie, anada bee dano siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enembo eini avona ená agho dari ijoko eini bejuturota, unda komana eini aghá ari-du irugadua mo, uutuva God da natofo* kaifa ariva, umó aná ijoko bee aita rouvie. Tago, umó avona ená agho dari ea gerurota, enembo aghá ari-du irugadua, umó uutuva God da natofo kaifa ariva, jojabe aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Amó nímandu rere, nímanda aito fugari jo Moses da Gaga kaifa ari, kotú Irugari Kakatoda* aito fugari serigambi adua mo, nímane uutuva God da natofo kaifa ariva jo terambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","God na gaga seibe mambube manedu riria-nu, nímane tanana ea vitera, aná evere: ‘Mania enembo eini data amburauveta, atá enembo avona enembo eini data amburadua, aná embó irurea, anada bouvu utota, itatama aita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tago, amó nímandu eghá rere, enembo avona unda jamenade neno akuago adua mo, aná embó irurea, anada bouvu utota, itatama aita rouvie. O avona unda jamenadu tauga kavavana radua, aná embó bua kanisera* maneda dibeva koto aita rousue. O ‘Indava taubana eini tefo re!’ radua mo, aná embó sei aná ari akokogo mino utari kambesi unda ivarida utuvako bee ea vitie. ");
INSERT INTO bjz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Amindu rea, imó avona inda vesa dungari farova itaita urota, inda jamenadu ari akuago eini urera-nu nundubadora mo, ");
INSERT INTO bjz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","inda vesa aná faro dibeva doa, sei kaverea ii, inda jamenadava inda ari akuago isagha ea doa kaverea fu, inda vesa God dava utadi! ");
INSERT INTO bjz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gaga eini mo, inda komanagha besiga ata, imonu koto aita radua mo, koto kambesiva bubambi-da dibe kena emboro rorova irurota, inda komanagha gaga rea simbuge! Aghá ambi adora mo, imó bua irurari katoda ingova utota, unona imó bua dibura kaifa kakatoda ingova utota, bua diburava gajaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Amó nímandu gaa bee rere, imó diburava irirota, irurari katomi guri donu utari-du radua-nu, dano utua sidara adora mo, imó doata kaverea bubaita roravore. ");
INSERT INTO bjz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","God na gaga seibe riria-nu, nímane tanana ea vitera, aná evere: ‘Mania komana einida evetu o embógha viro kombo ata!’ ");
INSERT INTO bjz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tago, amó nímandu eghá rere: enembo avona evetu eini gerurota, muu undadua, aná dara re. Aná embó seibe unda neno roomi komanada evetugha viro kombo etue. ");
INSERT INTO bjz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Amindu inda dibe ingo bee kenami ata, imó ari sembago adora mo, gunjia bua doa fuge! Anada bee mo, inda tamoda fatu eini doadora, aná taubana re. O anami ata, inda tamo dano fugota, ivari akuagova voradua, aná akuago re. ");
INSERT INTO bjz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dabako aghagonu, inda ingo beemi ata, imó ari sembago adora mo, tafugea fuge! Anada bee mo, inda tamoda fatu eini doadora, aná taubana re. O ingo anami ata, inda tamo dano fugota, ivari akuagova voradora, aná akuago re. ");
INSERT INTO bjz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","God na gaga seibe riria-nu, nímane tanana ea vitera, aná evere: enembo eghá reaveta ningita rosoravore, ‘Embó avona, unda evetu doaita nundubadua mo, umó bee dodu unda evetu doaita rouvia-da ingiso gembua evetudu utota bata-gea, ninengota yaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tago, amó nímandu eghá raita rore, ‘Embó avona unda evetu komanada embógha viro kombo kasava ambi irirota, dinunu dumenidu rea, umó doata, rekago vai adua, aná aghá aita rouvia embómi ata, God da dibeva aná evetu viro kombo kasava ari evetu aghago aita rouvie. Dabako aghago aná baitura avonu yagera adua, umó beago, God da dibeva kasava viro kombo ari embó aghago aita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Amó rekago rere, God na gaga seibe mambube manedu riria-nu, nímane tanana ea vitera, aná evere: ‘Mania nímanda be anogha gajiturera-nu, bebejegata! Nímane Jojabeeda ragarova be anogha gajiturera, aná kaifa ea goghó egege!’ ");
INSERT INTO bjz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tago, amó nímandava raita rore. Mania komanami inda gaganu gaabee ari-du rirota, avoda ragarova be anogha gagajegata! Uutuda ragarova jo be anogha gajambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kotú endada ragarova beago mania be anogha gagajegata! Aná God da eka jirari kambesi re. Kotú, mania Jerusalem da ragarova be anogha gagajegata! Aná Kini Jojabeeda bogu naa re. Jo inda tofo irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kotú mania indufa inda beforoda ragarova be anogha gagajegata! Anada bee mo, imó jo ata, fouma eini bondero vitari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Avoreta, tumanadu gaa bee nuenembo rege, enembo imó gaabee egegoe! Amindu ‘Avore’ radora mo, aghá ege! O ‘Tefo’ radora mo, mania aghá ata! Enembo inda gaga gaabee ari-du, avoda ragarova be anogha gajeta rora-da nundubari, aná Satan davareta futa rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","God na gaga seibe riria-nu, nímane tanana ea vitera, aná evere: ‘Avona unda komanada dibe ga soiki adua, mino unda ga soiki ege! Kotú avona unda komanada di data boradua, mino unda dege, boroe!’ ");
INSERT INTO bjz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tago, amó nímandu eghá raita rore. Enembo avona indú sembago adua mo, mania mino ata! Enembo einimi imó ingo bee kena ofova dadua mo, kavere-gea, yoveniva beago dae! ");
INSERT INTO bjz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kotú, enembo eini imó bua ya, koto urota, inda asugari tuvanu baita radua, do-gea etova asugaride dano bae! ");
INSERT INTO bjz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kotú enembo avona unda eini-eini fumbua, roo mendó dabako yari-du radua, fumbua roo mendó ungagha ii! ");
INSERT INTO bjz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kotú enembo indava eini-eini einidu benunu adua, aná utu! Kotú enembo eini avona indava eini-eini donu bua jijimu ea utaita radua mo, do-gea bae! ");
INSERT INTO bjz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","God na gaga seibe riria-nu, nímane tanana ea vitera, aná evere: ‘Inda komana tẽtãnu neno rururota, inda gitofonu injigha ege!’ ");
INSERT INTO bjz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tago, amó nímandu eghá rere. Nímanda gitofo neno rururota, nímandu bouvu mema ututuradua enembodu, benunu egege! ");
INSERT INTO bjz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Aghá egegadora, nímanda Afa, uutuva vitia-mi enembo sembagode taubanadedu fefera utuaveta janimbeta rouvia, kotú boruma beago taubanade sembagodedu utuaveta voreta rouvia, aghagonu urota, unda sasingu bee aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Atá, nímane takesi bari kakatoda eta rousua aghagonu urota, enembo nímane neno rururadua nuenembo neno bubugadora, bee dodu God anada mino eini utadu? ");
INSERT INTO bjz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dabako aghago, nímanda ikoko mendi nuenembo ghanena ea, numonde uumo egegadora, nímane jo Afada Gaga ningambi enemboda aito fugari itoko serigambi egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nímanda Afa uutuva vitia-dava dinunu eini tefo bee tefo re. Amindu rea, nímane beago aghagonu egegadi rere!” ");
INSERT INTO bjz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Atá gia goghó egege! Nímanda ari ivata taubana natofo gigigari-du númanda dibeva egegadora, nímanda Afa uutuva vitia-mi mino eini jo utota bambi egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Amindu nímane makasi enembo avonu kauta kavevera nundubuturota simbugadua mo, mania be koko fugia rata, enembo ningauveta! Enembo dumeni nghaĩ itari kambova o emboro kasava jiria, natofoda dibeva makasi enembodava soro vesa egegeta rousue. Aghá urota, númane komana sonembari gaa regegeta rousue. Tago, númane aghagago enembo re. Natofo númane gerurota, raga regegari-du eta rousue. Avore, enembo númandu raga reta rousua-mi númanda mino bubugeta rousue. Ambova God Afadava mino eini jo bambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Tago, nímane enembo sonembaita regegadora mo, inda kokomana kasavami inda urira gauveta, nenomi vesa egegadi rere. Aghá urota, Afa uutuva vitia-mi gia, mino unona utota baita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Atá, nímane benunu urota mo, mania aghagago eta rousua enembo, aghagonu egegata! Enembomi númane gia, raga regegari-du rea, númane nghaĩ itari kambova, kotú emboro kasava jiria, benunu egegeta rousue. Atá, amó nímandu gaa bee rere, númanda mino aná seibe bua vitie. Ambova Afa uutuva vitia-mi jo mino eini utota bambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tago, nímane benunu egegaita adora mo, igige, inda kambo rova terua bebato gagajege! Nímane Afa jo gambi eta rosoravore. Tago, aghá urota benunu egegadora mo, Afa nímane seibe kivumi gia, inda mino utota, baita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Atá, benunu egeguturota, mania Jiusi enemboda gitofo God gaabee ambi enembo aghagonu egegata! Númanda nundubariva, númanda bee tefo gaga oruaruabe reta rousua-du, kotú númanda benunu yafabe reta rousua-du, númanda ingomi uubu ari god mane númanda benunu niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mania númanego egegata! Anada bee mo, nímane benunu rambi-da dibeva, donu bubugasira, nímanda Afa seibe rei-gerue. ");
INSERT INTO bjz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Atá, benunu aita egegadora mo, benunu eghá egege ‘Afa uutuva vitera, námane inda ragaro kakara urota, righieta rei-erorue. ");
INSERT INTO bjz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Fu, inda natofo* kaifa uradi, namonde irore. Inda uno uutuva siroreta rouvia aghago, eve endava beago siroroe! ");
INSERT INTO bjz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Rifo inono námanda undari bofu! ");
INSERT INTO bjz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Námane enemboda ari akokogo námandava eta rousua-nu, nundubea gia dota rosora aghagonu námanda ari akokogo beago, nundubea gia do! ");
INSERT INTO bjz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Rourogo doadi-gea, kuvia gariva igigare-degea reisi-rere. Kotú námane enembo akokogoda ingova rougea bu!’ ");
INSERT INTO bjz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Enembo eini indú ari akuago ata, unda ari-bari akokogo nundubea gia doadora mo, inda Afa uutuva vitia-mi beago, inda ari-bari akokogo nundubea gia doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tago, imó enemboda ari akokogo jo nundubea gia doambi adora, inda Afa beago, inda ari akokogo jo nundubea gia doambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Imó tama urota, mania aghagago eta rousua enembo, aghagonu ata! Númane bagha dibe ea, tamo jo simbugambi irirota, enembomi númane tama rousua ananu gia raga regegari-du eta rousue. Atá, amó indú gaa bee rere. Númanda mino aná seibe bua vitie. Ambova Afa uutuva vitia-mi mino eini jo utota, bambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tago, imó tama urota mo, dibe be seghea uka righia, fouma gae! ");
INSERT INTO bjz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Aghá adora, imó tama adora-nu avona jo gia tanana ambi aita rouvie. Imó Afa jo gambi eta roravore. Tago, aghá urota tama adora mo, Afa imó seibe kivumi gia, inda mino utota baita roravore.” ");
INSERT INTO bjz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mania gugua-ghayafa eve endava bua kurafu aita egegata! Endava faratetemi eini-eini diaveta, akuago eta rouvie, o boma eta rouvie, o bagia enembomi bejea terua, bagia egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amindu nímanda gugua-ghayafa uutuva kurafu egege! Anava jo faratetemi undambi aita rouvie o boma ea, sembago ambi aita rouvie, kotú bagia enembomi jo bejea terua bagia egegambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Amó aghá rera-da bee mo, nímanda gugua-ghayafa niavo vitia-du gogorego nundubeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Namonde anda dibe aná tamoda nanefa re. Nímanda dibe taubana iradua mo, nímanda tamo dano unanami beda aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Atá, nímanda dibe jo taubana irambi adua, nímanda tamo dano bingoimi beda aita rouvie. Kotú nímandava unana dano sidara adua mo, bingoi bee bingoi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Enembo eini jo babarigari ungaghada buro ambi aita rouvie. Umó eininu neno rururota, eini injigha aita rouvie. O umó einida buronu ea goghó urota, eini injigha aita rouvie. Nímane jo guri baita nundubuturota, God da buro ari inono egegambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Amó nímandu eghá rere. Mania, nímanda irariva, donu undidigaita rosora, kotú nímanda tamova donu asugaita rosora amindu, neno mema egegata! Inda asisida jebuga aná jojabe re, undari-bari aná ijoko re, kotú gari dabako aghagonu inda tamo aná jojabe re, dighari asugari aná ijoko re. ");
INSERT INTO bjz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Aghago, dii manenu nundubea gigige! Númane jo govea o duria ghambea ambi eta rousue. Númane ghununu itari kambesi o koroma tefo re. Tago, nímanda Afa uutuva vitia-mi númane unduta rouvie. Tago, God da neno bari namonde andava aná jojabe re. Dii manedava aná ijoko re. Amindu nímanda irari-du mania mema egegata! ");
INSERT INTO bjz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gigige! Nímanda aghá nundubetora-mi, egegota nímane fefera yafabe iririgadora? ");
INSERT INTO bjz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kotú nímane dodu tamo dighari-asugaridu neno mema roso? Atá taima sigina manenda vitita rousua-nu gigige! Númane jo dighari-asugari baita rea, buro ambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tago, amó nímandu eghá rere. Kini Solomon umó gugua-ghayafa embó akuago eini re. Tago, unda dighari asugarida taubana, jo ená taimava siginago irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aná kirisa oreki vitia, rifode fugota ivariva evaita rouvia-dava God na unda gari taubana ututa rouvie. Tago, God da dibeva nímane aná jojabebei re. Kirisa aná ijoko re. Amindu, nímanda dighari asugari unona utaita rouvie. Aghá-gea, God da kauta kaveveradu gaabee egegadi rere! Dodu nímandava gaabee ari bee ijoko ro? ");
INSERT INTO bjz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amindu mania neno mema urota, eghá regegata! ‘Namonde amó undari donu unda? O namonde amó uvu donu unda? O namonde tamo dighari asugari donu asuga?’ ");
INSERT INTO bjz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jiusi enemboda gitofo God gaabee ambi enembo númanda nundubari aná eini-eini aghagodava itita rousue. Tago, nímane donu bubugasira-nu, nímanda Afa uutuva vitia-mi sei gita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amindu, God da kaifa eta rouvia-da noniva terua iririgaita rirota, unda unonu urota iririgadora, aná eini-eini nanjogo unona nímandu utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amindu, rifodedu mania neno mema egegata! Do-gea, rifodeda mema donu siroradua-du mania oreki neno mema egegata! Rifo inonoda mema siroreta rouvia-du, refodeda mema mania oreki nundubuturota mema egegata!” ");
INSERT INTO bjz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu aghá rea, rekago eghá ririe, “Rourogo, God nímane irurauve-degea rirota, mania komana irurata! ");
INSERT INTO bjz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anada bee mo, nímanda kokomana daiyagha iruraita rosora dabako aghagonu, God Afa nímane iruraita rouvie. Nímane daiyagha komanada ari akuago tava egegadora aghagonu, God na nímandava tava aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kotú imó dodu inda komanada dibeva susundo ijoko gerurota, ika jojabe inda dibeva vitia mo, gambi ro? ");
INSERT INTO bjz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Aghadu, mania enembo taubana gaa rirota, aghagago egeguturota, nímanda komanadu eghá regegata! ‘Arie, mambu, do-gea amó inda dibeva susundo ijoko vitia-nu bua fugore!’ Nímanda dibeva ika jojabe irota, aghá regegadora mo, jo taubana irambi re. Taubana mo, sei nímanda dibeva ika jojabe vitia-nu bua fugea, ambova nímanda komanada dibeva susundo ijoko vitia-nu, isaghava gia goghó urota, bua fugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mania ninodu eini-eini kakarago ututugata! Aghá egegadora mo, umó kaverea, imó gambua kisore-kasore aita rouvie. Aghagonu, eini-eini esiko-esiko naa okadu utadora mo, nundubambi tefo vegi-vaga rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Amó nímandu eghá raita rore. Benunu egege, utota bubugadi! Tava egege, utota bubugadi! Goi-goi dedege, nímandu bebato ifegaita rouvie! ");
INSERT INTO bjz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Anada bee mo, avona benunu ari, aná buta rouvie. Umó avona tava ari, aná tambuta rouvie. Kotú umó avona goi-goi dari, undú bebato ifegeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nímanda eta rosora-nu nundubea gigige! Nímanda mendi undaridu benunu adua mo, singoinu utadora? ");
INSERT INTO bjz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aghago, umó uvu okadu benunu adua mo, undú ningabunu utadora? ");
INSERT INTO bjz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Avore, nímane enembo sembago re-tago, nímane eini-eini esiko-esiko nímanda sasingudu ututa rosoravore. Tago, Afa uutuva vitia umó taubana bee re. Amindu undava benunu eta rousua enembodava, unda vesa taubana manenu ututa rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Agho Dari God na ririeta, Moses gefiria, kotú gaga feroveta mane gefiria-da bee mo evere: enembomi nímandu daiyagha ari-du uno adora aghagonu, númandu aghá egege!” ");
INSERT INTO bjz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Emboro ijokova ya bebato ijokova teradi rere! Anada bee mo, ivari akuago tumanadu reivia-va ya terarida emboro too, aná jojabe re, kotú aná bebato beago jojabe re. Natofo jede anava sumbua teteruguturota, sembago tatambugeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tago, jebuga tumanadu irari tambua barida emboro too aná sokumako re, kotú aná bebato beago sokumako-gea, anava terari fakara re. Enembo orua irambi anava ya jebuga tatambugeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesu na ririe, “Gia goghó urota iririge! Feroveta gavera kakato númane, oka ragaro sifi aghagago eta rousue. Tago, gaa bee re, númane aná nino akokogo aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ikada beenu gerurota, unda ragaro tanana aita rosoravore. Eto-bato aghagonu ika ragaro tofá-tofáda bee jo kuveva gambi aita roravore. O ika ragaro simbia da bee jo siribava gambi aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ika einida bee taubana, undita rosore, eini akuago jo undambi eta rosora aghagonu, aná enembo retora-da aito fugari akuago ra, aĩ, taubana ra, tanana aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Anada bee mo, ika taubana jo bee sembago ambi aita rouvie. Kotú ika sembago jo bee taubana ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ika mane bee jo taubana ambi adua, aná tafugea fugota, ivari tumanadu reivia-va avo evia, sidara aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Amindu rekago rere, aná feroveta gavera kakato aito daiyaghago fufugegadua-nu gerurota, númane daiyaghagoro tanana aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Natofo jede dano avona fefera inono ‘Jojabee, Jojabee,’ regegeta rousua-mi jo God da enembo* tumanadu kaifa eta rouvia kambesiva terambi aita rousue. Tago, umó avona anda Afa uutuva vitia-da uno adua-mi, teraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Afada enembo iruraita rouvia-da feferava, enembo jedemi eghá regegaita rousue, ‘Jojabee, Jojabee, námane inda ragarova minono rirota, taimu sembago mane enemboda tamova tuviturieta isaghava buburiturie. Kotú ari-bari ivatagha urieta siroruturie,’ regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Aghade, amó númandu isaghava raita rore, ‘Amó nímane jo tanana ambi rore. Nímane ari akokogo enembo reta, seserige!’” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Amindu enembo avona anda gaga ningia, ivatava ititigadua, númane aná embó eini neno nundubea goghó urota, unda kambo singoi etova itia aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aghá etueta, boruma jojabe vovorueta, yaura jojabe sumbua kambova fufieta, kotú uria-mi afamegea, roo mandugea vore etie-tago aná kambo jo gofegea jurambi re. Anada bee mo, aná kambo singoi etova itari vita. ");
INSERT INTO bjz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Atá anda gaga ningia, jo ivatava itambi egegadua enembo, númane aná embó eini jo neno nundubea goghó ambi urota, kambo mangosava itia, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Boruma jojabe vovorueta, yaura jojabe sumbua, kambova fufieta, uria-mi afamengea, roo mandugea vore etia, aná kambo fumbieta gofegea jua, ero jojabe retue,” ");
INSERT INTO bjz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu ená gaga mane rea sidara uria aghade, natofo jede avo desea vitiria-mi unda irugari uria-nu niningigea, duduku-dadaka egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Anada bee mo, Iesu umó gaa bee nuenembo anogha irugutuaveta, númane itatama egegeta urie. Jo Moses da Gaga Irugari kakatoda* gaga irugeta rousua aghago, rambi re. ");
INSERT INTO bjz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aghade, Iesu umó ootova reta vorefueta, natofo jede unda ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aghá uua, embó eini tamo betomi gigimbari furia bubua, unda dibe kena koubomi jengirea ririe, “Jojabee, amó tanana rore, ano indava vitia, aná inono bee re. Aghá-gea, imó uno adora, ege-gea, amó jebugore!” ");
INSERT INTO bjz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu, unda ingo sinia, aná embóda tamova, ririkurota ririe, “Amó uno roreta, imó jebuge!” ririe. Aghade, aná embóda tamova beto mane niagha yarigo urie. ");
INSERT INTO bjz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aghá urieta, Iesu na aná embódu eghá ririe, “Anda donu etora, mania enembodu rata! Tago dibe dambu ii, fristidava* bubua, inda tamo irugadi gata, Moses da Agho Dariva jebugetora-da vesa daiyagha dungari-du reiria aghagonu ege, enembo dano imó jebugetora-nu, gigigoe!” ");
INSERT INTO bjz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Fefera aghade, Iesu aria, Kaperneam buburitueta, Rom enemboda mene-mene ari kakatoda beforo righari eini undava furia, memagha sonembari-du benunu urie. ");
INSERT INTO bjz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Jojabee, anda sabua* embó eini kae bua, yavi-yavi ambi, eka ingo takembea, kambova vasia mema jojabe itatama rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aghá ririeta, Iesu undú eghá ririe, “Anona ya, righota jebugaita rouvie.” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aná Rom enemboda mene-mene ari kakatoda beforo righari eghá ririe, “Jojabee, anona imó rata andava furari jo inono irambi re. Amindu, tefo bemi gaga rege-gea, anda sabua embó jebugoe! ");
INSERT INTO bjz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aghá rera-da bee mo, amó anda barirarida tuva vitere. Aghago amó anda mene-mene ari kakatoda beforo righari jojabe re. Mene-mene ari kakato dano anda tuva irita rousue. Aghá-gea, anona, ‘Imó ii!’ rari aná ita rouvie. Kotú ‘Fu!’ rari aná futa rouvie. Kotú anda sabua katodu, ‘Enanu ege!’ rari, aná eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu aghá ningia, umó duduku ea, unda ambova fufuguturia enembodu eghá ririe, “Amó nímandu gaa bee rere, amó namonde anda Israel enembo einidava gaabee ari jojabe eghago jo gambi re. ");
INSERT INTO bjz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Fefera vitari kena, fefera vorari kena, dafaru kena kotú karaje kena enembo dano furá, God unda natofo* tumanadu kaifa eta rouvia-du banau simbugaita rouvia-va Abraham, Aisak, Jekop de dano numonde banauva asusumbegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tago, unda kaifa aita rirota gateguturia enembonu injigha ea isaghava fugota, bingoiva vorea, memagha diitu kirisi-karasa urota, jiiji regeguturota iririgaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aghá rea doa, Iesu kaverea, aná mene-mene ari kakatoda kofiri righaridu ririe, “Kambova ii, inda gaabee etora aghagonu, rei-siroretue.” Iesu aghá ria aghade, aná kofiri righarida sabua embó jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Avore, Iesu aria, Pita da kambova bubua teteruria mo, Pita da imboti tamo veriveri ua-du vasia irieta gia, ");
INSERT INTO bjz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","unda ingo sinia, aná evetuda ingova ririkurieta, aná tamo veriveri tukú urieta, umó erea, Iesu da uno dano simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jama ua-va, enembo taimumi asuguturia mane bua fufuguturieta, Iesu bemi ririeta, aná taimu mane tamova kosuguturie. Kotú kae bua vitiria enembo beago ririeta, númane jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Gaga eini buka Aisaia da rova vitia-da bee isagha ari-du rirota, aghá uria, aná evere: “Namonde anda memade, kotú kae bua vitera-deda bouvu unona fufirie.” ");
INSERT INTO bjz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Enembo natofo jede umó fugea roroguturia-nu gerurie-gea, Iesu unda ambo nimbidu eghá ririe, “Ererege-gea, namonde sao yoveniva rekimbea igigore!” ");
INSERT INTO bjz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aghá ririeta, Moses da Gaga irugari kato* einimi undava furia, eghá ririe, “Irugari kato, imó niavo yadora, amó inda ambova tuvia yaitare.” ");
INSERT INTO bjz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aghá ririeta, Iesu undú eghá ririe, “Ito-goiriva númanda nangu undari too vitie, kotú itiva dii mane númanda mogha vitie-tago, Enemboda Jojabee* umó doda nangu undari kambesi eini tefo re.” ");
INSERT INTO bjz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kotú, ambo nimbi einimi ririe, “Jojabee, anda afa emboko bee re. Umó amburota-gea furugadora mo, amó furá angá deĩ aita rore.” ");
INSERT INTO bjz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aghá ririe-tago, Iesu undú eghá ririe, “Anda ambova tuvia fu! Do-gea, aná amburari enembo nendufako furugoe!” ");
INSERT INTO bjz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu ghaava* vovorueta, unda ambo nimbi numonde vorea siregea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Númane rekimbea aria, sao rorova irueta aghade, yaura yavata gagarua erorurie. Erea, ghaa kofiriva dea bejetueta, Iesu eevo ueta, ");
INSERT INTO bjz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","unda ambo nimbi evurea, undú eghá regeguturie, “Jojabee, námane sonembe! Namonde amó ambubugaita itoko rosore.” ");
INSERT INTO bjz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aghá regeguturieta, Iesu ririe, “Nímane dodu orumi reisi-jajareguto? Nímandava gaabee ari bee ijoko re?” Aghá rirota, umó erea jiria, yaura yavatada torú-torú bureguturieta, binono dogo urie. ");
INSERT INTO bjz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aná embobo bee duduku-dadaka ea, eghá regeguturie, “Ená embó daiyaghagomi retueta, yaura yavatada torú-torú unda gaga ningia, binono etu?” ");
INSERT INTO bjz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Binono urieta, númane rekimbea aria, Galili sao yoveniva Gedara enemboda endava buburiturie. Bubua, ghaa* gaiturieta Iesu ombova vivituria mo, aná bogu naava embobo ungagha taimumi asugea vitiria-mi uje singoi toova reta bubua umó tafirie. Ungá umó, tamo righambi eta uria-du, enembo oru urota, avo jo iru-furu ambi egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iesu gerurota, aghade ungá duduku-dadaka ea, koko-koko regeguturie, “God da Mendi, imó námandu donu aita uno ro? Fefera jo bubambi vitie-tago, imó sei-sei námandu bouvu utaita bubera, aĩ?” ");
INSERT INTO bjz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aná emboboda kasava itoko airogo naa oka mane oruabe undari reisi-nendirie. ");
INSERT INTO bjz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aná taimu manemi Iesu dava benunu egeguturie, “Imó námane tuvota bubari-du radora mo, rege-gea, námane ya oná naa oka maneda tamova teterugore!” aghá regeguturieta, ");
INSERT INTO bjz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu númandu, “Do serige!” ririeta, númane aria, naa okada tamova teteruguturieta, naa oka nanjogo dano sumbua, kokava voraria, saova undidigea ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aghá urieta, aná naa oka kaifa kakatomi, susumbugea aria, bogu naava bububugea, taimu aná embobo ungaghadava asugea vitiria-da gagade, kotú naa oka manedava donu siroruturia-da gagade dano isagha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Aghá regeguturieta, aná bogu naava enembo dano Iesu tambaita igiguturie. Aria tambua gigigea, númanena Iesu aná roo enda doa serigari-du benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu unda ambo nimbide ghaava* vorea kaverea, yoveniva rekimbea, unda irita uria naava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aria, ghaa ga vivitueta, enembo dumenimi embó eini eka ingo takembarinu ghaitova ititurieta vasia irieta bua, Iesu dava fufuguturie. Aná kae bari embóde, unda kokomanade númane daiyagha undú gaabee egegutueta gia doa, Iesu aná embódu eghá ririe. “Anda mendi, ano ea, gangoro adi rere! Inda ari akokogo nundubea gia dotore.” ");
INSERT INTO bjz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aghá rieta, Moses da Gaga Irugari kakato* dumeni anava asusumbea vitiria-mi niningigea, Iesu dava aghá arida ano tefo gaa rea, nenuka eghá regeguturie, “Ená embó God da bingá fara rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Númanda donu nundubutua, Iesu gerurie-gea, númandu ririe, “Nímane daiyagha neno roomi nundubari akokogo reisi-nundubuto? ");
INSERT INTO bjz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Atá nundubea gigige! Niana mo rauko ro? ‘Inda sembago nundubea gia dotore!’ rari mo, rauko ra, aĩ? o ‘Erea deĩ ege!’ rari mo, rauko ra? ");
INSERT INTO bjz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Enanu ata, gigigea, tanana egegaita rosoravore: ari akokogo nundubea gia, doarida ano Enemboda Jojabeedava* vitie.” Aghá rea kaverea, aná embó eka ingo takembaridu eghá ririe, “Erea, inda ghaito borea bua, kambova ii!” ");
INSERT INTO bjz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iesu aghá ririeta, aná embó eka ingo takembaride jebugea, kambova arie. ");
INSERT INTO bjz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aná embó erea, kambova irueta, enembo dano gigigea oru ea, God ano aghagonu enembodava ututuria-du, undú raga regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu aná kambesi doa irurota, dibe fugituria mo, takesi bari embó eini ragaro Matyu unda takesi bari dobova asumbea irieta gia, Iesu aná embódu eghá ririe, “Erea, anda ambova fu!” aghá ririeta, Matyu erea, Iesu da ambova arie. ");
INSERT INTO bjz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Anada ambova, Iesu aria, Matyu da kambova terua, undari dieta, takesi bari enembo dumeni, kotú ari akokogo enembo oruaruabe dano furia, Iesu de unda ambo nimbide dano asusumbea, undari undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aghá ueta, Moses da Gaga Kaifa Ari kakato* gigiguturie-gea, Iesu da ambo nimbidu eghá regeguturie, “Bee dodu nímanda irugari kato takesi bari enembode kotú ari akokogo enembode dano asumbea undari reisi-undi?” ");
INSERT INTO bjz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aghá regeguturieta, Iesu niningurie-gea, númandu eghá ririe, “Avona, ‘Andava kae tefo re,’ radua mo, ingi embó undava jo yambi aita rouvie. Kotú avona, ‘Amó kae bere,’ radua mo, ingi embó undava yaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Avoreta, igige, God da Gaga enanu nundubuturota, bee tanana ea goghó egegadi! ‘Anda uno bee mo, aná komanadu neno mema ari re, jo andú vesa dungari irambi re.’ Anada bee mo, amó enembo akokogodu furere, jo enembo taubana ghogho raita furambi re.” ");
INSERT INTO bjz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Anada ambova, Jon Bafutaito ari katoda ambo nimbi dumenimi furia, Iesu dava uriga egeguturie, “Námane kotú Moses da Gaga Kaifa kakato*, God dava benunu aita rirota, undari tama eta rosore. Tago, inda ambo nimbi daiyagha aghago jo ambi egegeta rousu?” ");
INSERT INTO bjz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aghá regeguturieta, Iesu undufa iruguturota, númandu eghá ririe, “Nundubea gigige! Mendi gimasa evetu yagera aita rouvia-da banauva unda kokomana jo dari sorara urota, tama ambi aita rousue. Tago, fefera furá bubota, ená mendi gimasa data amburadua mo, númane aghade tama egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Eembo boo sei too barugadua mo, jo rekami divegea itia tauta egegambi asire. Anada bee mo, eembo boo reka divegea tauta egegadora mo, tariri ea ghambugota bejea ya, too jojabe aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ari dabako aghago vaini reka jo bua kofiri seiva averegota irambi aita rouvie. Aghá adora mo, vaini rekada anomi ata-gea, aná kofiri bejea, vaini averegea vorea, akuago aita rouvie. Amindu vaini reka aná kofiri rekava averegota, ungá inonova taubana iraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu aghá rieta, Jiusi enemboda beforo righari eini furia, Iesu dava bubua, unda dibe kenava koubumi jengirea, eghá ririe, “Anda ariri ijoko oreki enembo ambueta, imó fu, angá ya, inda ingomi tamova itadi-gea, umó jebugoe!” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aghá ririeta, Iesu unda ambo nimbide dano erea, aná beforo righaride dano igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Númane irueta, evetu eini furia, emboro rorova tafirie. Aná evetu tatangu kae bua gutiturota, ghaeko 12 sidara urie. Aná evetu Iesu da ambo kena aria, ingo sinia, Iesu da tamo asugari sokuada soriva ririkurie. ");
INSERT INTO bjz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aná evetuda nundubariva, “Amó tefo unda tamo asugari sokuava righadora, amó jebugaita rore,” aghá nundubuturie-gea, Iesu da sokuava ririkurie. ");
INSERT INTO bjz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu itatama ea kaverea, aná evetu gia, undú eghá ririe, “Anda ariri, ano urota, gangoro ege! Inda gaabee arimi imó jebugetoravore,” Iesu aghá ria, gaimbo ambi, aná evetu jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Aghá uria-da ambova, Iesu beforo righarida kambo teterurota, veku furari kakatode, kotú enembo oruaruabe yove gaje rieta, dari sorara ueta gerurie-gea, Iesu númandu eghá ririe, “Erea ii, isaghava bububugadi! Ená ariri jo amburambi re. Umó eevo rouvie,” ririe-tago, númane Iesu kuvia gegha regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aghá riria-du, kambo numamomi ririeta, natofo dano aria, isaghava bububuguturieta, Iesu terua aria, aná aririda ingova ririkurieta, jebugea erorurie. ");
INSERT INTO bjz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iesu aghá uria-da bingá sarigea aria, aná frovensiva roo enda avo fafate urie. ");
INSERT INTO bjz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu aná kambesi doa irueta, embobo ungagha dibe soikidemi Iesu da ambova irurota, be koko fugea, eghá regeguturie, “Ariee! Devit da Mendi, námandu neno mema ea, sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aghá regeguta furueta, Iesu aria, kambo eini avo teterurieta, aná embobo ungagha ambova aria teteruguturieta, Iesu ungá undú uriga urie, “Rata jebugarida ano andava vitia, ananu ingá imó gaabee rosora?” ririeta, ungá umó, “Aĩgo, Jojabee, námane gaabee rosore.” ");
INSERT INTO bjz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aghá regeguturia-du, Iesu ingo sinia ungá unda dibe maneva ririkurota, eghá ririe, “Ingá imó daiyagha nundubuturota, gaabee rosora aghagonu nímandava siroroe!” ");
INSERT INTO bjz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aghá ririeta, aná embobo ungaghada dibe ifefegea gerueta, Iesu ininigha ungá undava donu urieta siroruturia-nu, rourogo enembodu rata niningigauva-degea ririe. ");
INSERT INTO bjz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aghá ririe-tago, ungá umó bubua aria, Iesu da donu uria-da bingá isagha urieta, aná roo endava dano aria, fafate urie. ");
INSERT INTO bjz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Avore, ungá umó bubua irueta, embó eini taimu akuagomi asuguturieta, be gunga vitiria-nu bua, Iesu dava fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu taimu tuviturieta buburiturieta, aná embó be gunga ea vitiria-mi be fangea tutuno ea gaga ririe. Aghá urieta, enembo oruaruabe gia, bee duduku-dadaka ea, mana-mana urota, eghá regeguturie, “Eini-eini eghago roo enda Israel enava jo sirorota gigigambi, tutunova reisi-gerore.” ");
INSERT INTO bjz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iesu aghá uria-du, Moses da Gaga Kaifa kakato eghá regeguturie, “Taimu akokogoda barirari Satan na Iesu du ano utuaveta, taimu akokogo tuviaveta isaghava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu Galili Frovensi rova bogu naava kotú naa maneva terua bubua urota, nghaĩ itari kambova*, God Afa unda natofo* daiyagha kaifa eta rouvia-da Gaga Taubananu minono reta urie. Kotú enembo kae dibe eini be eini bua irari eaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aghade, natofo jede undava desuturia-nu gia, neno mema urie. Anada bee mo, eto-bato sifi mane kaifa kato tefo aghago, númane ano tefo sonembadu mana-mana urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aghá-gea, unda ambo nimbidu eghá ririe, “Aayova undari-bari oruaruabe bee etue-tago, undari-bari ghambea buria ari enembo jo orua irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Amindu aayo numamodu benunu egege-gea, undari ghambea buria ari enembo ninengota furoe!” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu unda ambo nimbi 12 aghi urieta, undava fufuguturieta, taimu akokogo tuvari-du, kotú kae dibe eini be eini bubugea irari enembo nanjogo ata jejebugari-du rea, númandu ano ututurie. ");
INSERT INTO bjz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Avore, Iesu da aghi kakato 12 da ragaro mane, aná evere: tutunova aná Andru unda kaka Saimon gha re. (Saimon da ragaro eini Pita reta rosore.) Sebedi da mendi Jems unda ikoko Jon gha re. ");
INSERT INTO bjz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Dumeni aná Filip ungá Bartolomyu gha, Tomas kotú Matyu takesi bari kato einigha re. Alfius da mendi Jems ungá Tadius gha re. ");
INSERT INTO bjz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon da akau unda ragaro eini “Tuvari kato” re. Kotú Keriot embó ragaro Judas, Iesu bua gitofoda ingova ututuria, umó re. ");
INSERT INTO bjz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu unda ambo nimbi bee dano 12 nu ninenguturota, unda nghaĩ itari gaga eghá ririe, “Mania namonde anda gitofodava igigata! Kotú Samaria enemboda bogu naava mania igigata! ");
INSERT INTO bjz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nímane namonde anda natofo Israel enembo dumeni, emboro taubana kasovigea vitia-dava igige! ");
INSERT INTO bjz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Igige, naa maneva deĩ urota, minono eghá regegadi, ‘God unda natofo* kaifa aita rouvia fefera etia utuvako etue.’ ");
INSERT INTO bjz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aghá urota, kae bua vitia enembo egege, jejebugoe! Amburari enembo egege, jebugea eroe! Enembo tamo betomi gigimbea vitia-nu egege, aná beto sidara ae! Kotú taimu akokogo mane tuve, bububugoe! Ená ano andava tefo bubugetoravore, amindu mino tefo enembo sonembadi rere. ");
INSERT INTO bjz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Atá, nímane igiguturota mo, guri dibe eini be eini goldi mi ari, o siliva mi ari o kofa mi ari manenu mania nímanda abagu dighari siriva fendia bua igigata! Kotú etotade, dighari ombari eini kasavade, eka vuside, besiade dano mania bua igigata! Anada bee mo, buro katoda undari enembo sonembaita rouvia-mi sonembasueta sirorasua, aná taubana re. ");
INSERT INTO bjz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Atá, nímane naa eini o bogu naa niavo bububugadora mo, avona nemonde iraita uno adua embónu tava ea, unda kambova irirota, buro egege, sidara adua aghade, bubua igige! ");
INSERT INTO bjz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Atá, nímane ya kambo niavo teterugadora mo, ‘Siriri ari nemonde danode iroe!’ regege! ");
INSERT INTO bjz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aghá benunu egege-gea, aná kambova enembo nímane gangorogha bua kaifa aita regegadua mo, Afada siriri ari do-gea, numonde danode iririgoe! Atá, nímane jo gangorogha bua kaifa ambi egegadua mo, do-gea, Afada siriri ari benunu egegadora-nu, regege, rekago nímandava kaverea furoe! ");
INSERT INTO bjz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Atá, enembo avona nímandu uno ambi ea, kotú nímanda gaga ningari injigha egegadua mo, anada kambo o bogu naa doa seriguturota, nímanda eka ghangadanu avo dodovirea doa igige! ");
INSERT INTO bjz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nímandu gaa bee rere. Irurarida Feferava, Sodom enembo kotú Gomora enembo bouvu baita rousue-tago, aná naava enembo bouvu jojago bee bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Amó nímane, eto-bato sifi nino akokoda rorova irita rouvia, aghagonu enembo akokogoda rorova rei-ninengutore. Amindu, nímane nundubea gia goghó urota, igige! Kotú, nímanda yavi aná dii ragaro ukuda yavigo urota, mania mema enembo einidava ututugata! ");
INSERT INTO bjz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kotú, nímane aná enembode reta kaifa goghó urota, igige! Anada bee mo, nímane nandia, númanda nghaĩ itari kambova* avo nímane fisurea bua, kanisera* maneda ingova utota, koto egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aghade, nímane itota, gavanada babarigarida dibeva, kotú kini maneda dibeva jiria, anda ragarova isaghava regegota, númane Jiusi enemboda gitofode dano anda Gaga Taubana niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Koto feferava donu rasira, kotú daiyagha rasira-du mania oru urota, mana-mana egegata! Asisi Kakarami iruguturota, nímane gaga regegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jo nímane nenukako regegambi aita rosoravore. Nímanda Afada Asisimi ano ututurota, nímanda bemi gaga raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aghade, nímane amó gaabee egegeta rosora-du, enembo oruabe nímane injigha egegaita rousue. Aná rifo furadua mo, enembo erea, númanda ikoko kaka, nanandigea ututugota-gea, data ambubugaita rousue. Enembo númanda sasingu nanandigea ututugota-gea, data ambubugaita rousue. Kotú sasingu beago erea, nue numamo mane nanandigea ututugota-gea, data ambubugaita rousue. Atá avona ano ea, enembodu oru ambi amó gaa bee urota amburadua mo, jebuga tumanadu irari tambua baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Aghá urota, amó gaabee rosora-du, enembo dano nímane injigha egegaita rousue. Tago, avona ano ea, unda gaabee ari amó kena jo doambi aita rouvia, umó fefera ambova jebugaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aghade, nímanda vitera bogu naa vareta dea tuvadua mo, doa ere ii, bogu naa einiva iririgadi! Amó nímandu gaa bee rere. Nímane Israel frovensida bogu naa ijoijokokova jo biruru ea sidara ambi irota-gea, Enemboda Jojabee* kaverea furá bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Namonde tanana rosore, sikuru mendi jo bingáde irambi re. Tago irugari kato aná bingáde re. Dabako aghago sabua* embó jo bingáde irambi re. Tago unda barirari aná bingáde re. ");
INSERT INTO bjz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amindu eini-eini donu irugari katodava siroradua, aghagonu aná sikuru mendidava siroradua, aná mendi gangoro asue. Dabako aghago eini-eini donu unda bariraridava siroradua aghagonu aná sabuadava siroradua, aná sabua embó gangoro asue. Aghá-gea, andú tauga kavavana rirota ‘Belsebul’ regegeta rousua aghagonu, nímandu aghá regegaita rousue, kotú anada itiva gaga akokogo dumeni nímanda tamova regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Avore, mania enembodu oru egegata! Eini-eini nanjogo nungariva vitia, aná dano bubua, isagha aita rouvie. Kotú kivu gaga nanjogo ambova enembo dano niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Amó nenuka nímandu donu rera gaganu, isaghava regege! Kotú nímanda nghaĩmi dumumutami niningigadora-nu bua kaunava jiria, minono regege! ");
INSERT INTO bjz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Atá, inda tamo nuenembo data amburari inono ea vitia enembodu, mania oru egegata! Tago, God tamode asiside data amburari inono vitia-nu, kotú imó ivari tumanadu reivia-va itari inono vitia-nu, unuka undú oru egege! ");
INSERT INTO bjz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Atá, dii buririka nundubadi rere. Guri utua baita rasira mo, toea ingo yoveni aghago utua buririka ungagha dano basiravore. Tago, buririka eini jo tefo jurambi aita adua. Afada unomi ambuta rouvie. Avore, God umó aná buririka neno rururota, númane dano irugari vitie. Tago, unda neno bari númandava ijoko re. Unda neno bari namonde andava aná jojabe re. ");
INSERT INTO bjz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Kotú namonde anda fouma beago, dano irugari vitie. Amindu nímane God gaabee ari enembodu rere. Mania amburari-du oru egegata! ");
INSERT INTO bjz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Atá, enembo avona amó gaabee urota, natofo jededa dibeva unda gaabee arinu ivatava itadua, amó beago umó anda Afa uutuva vitia-da dibeva umó anda ikoko gaa raita rore. ");
INSERT INTO bjz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tago, umó avona enemboda dibeva amó kivu adua, amó beago uutuva anda Afada dibeva umó, aná kivu aita rore. ");
INSERT INTO bjz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Amó endava siriri ari bua furarinu mania nundubata! Amó jo siriri ari bua furambi re. Amó mene-menenu bua futare. ");
INSERT INTO bjz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Anona ata, mendi umó erea, numamogha gitofo urota, ariri umó nuegha gitofo urota, mendiyae erea, nuaviagha gitofo egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aghade, inda gitofo akuago bee inda enembo tofo beeda rova siroraita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Enembo avodava neno bari nue numamodava jojabe ata, andava ijoko adua, númane jo anda tofo ari inono irambi re. Aghagonu, enembo avodava neno bari unda mendi o ariridava jojabe urota, andava ijoko adua, númane beago, jo anda tofo ari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kotú enembo avona, jo númanda ifatara fumbua, anda ambo-ambo urota amburaita simbugadua, umó jo anda tofo ari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Anada bee mo, númanda jebuga taubana endava vitia-nu nundubeta rousua enembomi, ambova jebuga jo tambambi egegaita rousue. Atá, andú rea, númanda jebuga kasovigadua enembo, ambova númane jebuga tumanadu irarinu bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Umó avona nímandu orokaiva rea, ghaito teno fugadua, andú beago aghagonu aita rouvie. Kotú umó avona andú orokaiva rirota, ghaito teno fugadua, umó aghá urota, God Afa amó ninenguturieta furera-du beago, aghagonu aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aghago, umó avona feroveta eini gia, God da aghi aita reifia-nu nundubuturota, orokaiva rirota, ghaito teno fugadua, umó aghá adua-da minonu baita rouvie. Kotú umó avona embó taubanadu orokaiva rirota, ghaito teno fugadua, umó aghá adua-da mino baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kotú amó nímandu gaa bee rere. Umó avona anda embó bingá tefo eini gia, ‘Amó Iesu da ambo nimbi eini sonembaitare.’ rirota, uvu yaura aagha eini rurukea utadua, umó aghá aita rouvia-da mino jo serigambi baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu unda ambo nimbidu, buro daiyagha arida isuri mane ea sidara uria-da ambova, umó erea, anavareta Galili Frovensi naa nanjogova God da Gaganu minono rirota irugaita arie. ");
INSERT INTO bjz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Jon Bafutaito Ari kato, diburava irirota, Keriso da buro uua-da bingá niningurie-gea, unda ambo nimbi uriga egegari-du ninenguturieta, Iesu dava aria bubua, uriga eghá egeguturie, “Jon na embó eini furaita rouvia riria mo, imovia, aĩ? Embó eininu kaifa egegara?” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aghá ririeta, Iesu na númandu mino eghá ririe, “Kaverea ii, nímanda dibemi gera, kotú donu nghaĩmi niningigetora-nu isagha egegadi! ");
INSERT INTO bjz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Enembo dibe soikide unana reisi-gerue, eka takembari jejebugea, yari furari rousue. Tamo betomi gigimbari enembo tamo taubana egegetue. Aghago nghaĩ gagajegari, gaga reisi-niningue. Amburari enembo righieta jebugea ererueta, Gaga Taubana makasi enembodu minono rere. ");
INSERT INTO bjz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Andú jo mana-mana ambi egegadua enembodava, ea simbugari taubana iraita rouvie,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon Bafutaito Ari katoda ambo nimbi doa irua aghade, Iesu na tutuno ea, natofo avo desea vitiria-du, Jon Bafutaito Ari katodu gaga eghá ririe, “Nímane, aná enembo tefo uvu tefo kambesiva donu gigigaita igigeto? Nímane mo, tefo aufogho yaurami righia vuri-vara uua-nu gigigaita igigetora? ");
INSERT INTO bjz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Atá, nímane donu gigigaita igigeto, embó eini asugari taubana asugea vita-nu gigigaita igigetora, aĩ? Tefo, enembo bo-eembo esiko-esiko asugea irita rousua, aná kini maneda kambova tatambugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Atá, nímane donu gigigaita igiguta? Feroveta ra? Avore, aná gaa bee re. Kotú amó nímandu rere, Jon aná feroveta mane nanjogoda itiva re.” ");
INSERT INTO bjz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iesu na feroveta Aisaia na Jon du gaga gefiria-nu nundubuturota, eghá ririe, “‘Amó anda aghi kato sei ninengota ya, inda emboro simbugaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Amó nímandu gaa bee rere. Evevetuda fufumbuguturia enemboda rova, eini jo Jon Bafutaito Ari kato aghago irambi re. Umó embó bingáde, kotú embó jojabe eini re. Tago, amó emboro reka ifegaita rora anava, avona ya God da natofo* kaifa ariva teradua, aná enembo gangoro jojabe egegaita rousue. Jon jo aghá ambi re. ");
INSERT INTO bjz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kotú, Jon Bafutaito Ari katoda feferavareta etia, oreki anada rova, enembo dumenimi God da natofoda beforo ririkigarida kambesi baita rirota, soregami itia bera-bera egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jon jo sirorambi-da feferava, God ambova unda natofo daiyagha kaifa aita rouvia-du, Moses kotú feroveta nanjogo minono regeguta fufugutueta, Jon Bafutaito Ari kato siroruturie. ");
INSERT INTO bjz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tago, númane Elaija kaverea furari gaa regeguturia-nu, gaabee rousua, aĩ? Elaija du reiria, aná Jon re. ");
INSERT INTO bjz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Atá, nímane avona nghaĩde iradua, nghaĩ javea, ningia goghó egege! ");
INSERT INTO bjz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nímane oreki endava sirorea vitera mo, daiyaghago ro? Ananu isuri aita rore. Nímane eto-bato sasingu gurimi utua bari kambesiva asumbea besiga urota, be fugia mino-mino eghá regegeta rousua, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tutunova námane nímandu veku furetore-tago, nímane jo daa didivugambi re. Kotú ambova, námane jii yairi gatetore-tago, nímane jo jii regegambi re.’ ");
INSERT INTO bjz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aghá rera-da bee mo, Jon umó sirorea furia-va, undaride vaini de tama ueta, umó taimu akuagomi asugea irari gaa regegeta utaravore. ");
INSERT INTO bjz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tago, Enemboda Jojabee* etia, undaride vaini de dieta, nímane gia eghá reisi-reravore, ‘Ená embó undaride, kotú vaini deda jinanga kato re. Umó takesi bari kakatode, kotú ari bari akokogo egegari kakatodeda komana re.’ Tago, enembo da aito fufugegadua-nu gerurota tanana egegeta rosore, God da enembo ra, aĩ, Satan da enembo ra?” ");
INSERT INTO bjz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu buro urota, ari ivatagha urieta siroruturia, kotú bemi ririeta siroruturie. Tago, bogu naa oruabe, aná ari ivatagha gerurota, Iesu jo gaabee egegambi númanda ari-bari sembago mane God du isagha ambi egeguturia-du, umó aná bogu naa maneda enemboda dibeva gaa eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“O yove! Korasin kotú Betsaida enembo nímandu rere. Sembago furota, nímane bouvu jojago bee itatama aita rosoravore. Anada bee mo, aná ivata anogha dumeni nímandava rei-sirorutua aghagonu, Tair ungá Saidon ghadava irugasira, númane seibe neno kaverea, númanda ari akokogo vuregea, isagha urota, neno memada vaya boghora asusugea, enda beforova gharasue. ");
INSERT INTO bjz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Gaa bee re, irurarida feferava Tair ungá Saidon ghada enembo mema baita rousue-tago, nímane Korasin kotú Betsaida ghada enembo rera, mema jojago bee bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Atá, Kaponiam enembodu rere. Nímanda nundubariva, nímane righota erea, uutuva yari reisi-nundubutora, aĩ? Tefo, nímane aná kokava fugota voriya, ari bari akokogoda mino utari kambesiva iraita rosoravore. Ená ari-bari ivatagha, kotú anode utata siroruta aghagonu, Sodom naava asira, númane neno kaverea, God gaabee egegasueta, oreki dibe reka iririgasue. ");
INSERT INTO bjz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Gaa bee re, irurarida feferava, Sodom enembo mema ijoko bubugaita rousue-tago, nímane mema jojago bee bubugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aghade, Iesu Afadu raga eghá ririe, “Afa, imó uutu endadeda Jojabee re. Amó indú aiye bee rere. Afa, inona uno urota, enembo beforo garide nundubaridedava inda gaga kivu ea nungiturota, enembo beforo gambi, sasingu maneda nundubarigodava iruguturieta isagha urie. ");
INSERT INTO bjz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Afa, inona uno urota, aghá urieta siroruturie. ");
INSERT INTO bjz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eini-eini nanjogo dano Afa na anda ingova ituturie. Enembo eini avona Afada Mendi jo tanana ambi re, Afa unuka rei-gerue. Kotú dabako aghagonu, enembo eini jo God Afa tanana ambi re-tago, unda Mendimi unuka umó tanana rouvie. Kotú unda Mendida uno rouvia enembodu unona irugota, Afa gigigea tanana aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nímane avona bouvu fufirota, kotú tamo injigha ea vitia enembodu rere, fufuge, andava nangu undidigadi! ");
INSERT INTO bjz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Amó durumuguturota, neno nundubea, andufako raga rambi vitera-du rere. Avore, anda eta rora aghagonu irugota, tanana ea, aghá egegadi rere. Fu, anda ivisava saváda mendóva bubugadi gia, namonde neno feru-feru urota, nangu undidigadi! ");
INSERT INTO bjz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Anada bee mo, anda donu saváda fumbadi rera, aná jo bouvu irambi re, kotú anda indú utaita rera buro, aná fẽko re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anada ambova, Nangu Undari Fefera einiva Iesu na farava govari vitiria aayo rova terua irueta, unda ambo nimbi baimana itatama egeguturie-gea, faravada bee dumeni bua undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aghá egegutueta gia, Moses da Gaga Kaifa ari kakatomi*, Iesu du eghá regeguturie, “Inda ambo nimbi Nangu Undari Feferava aghá urota, agho dari reisi-bejutue.” ");
INSERT INTO bjz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aghá ririeta, Iesu na mino númandu eghá ririe, “Nímane anda ambo nimbidu gaa rera, aĩ? Devit unda kokomanededa baimana itatama ea, donu egeguturia-da gaga irugea gigigambi ra? ");
INSERT INTO bjz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit unda kokomanade, God du Tafaroro Ari Kambova terua, farava ingari kakara, God da ragarova vesa ututuria-nu bua, undidiguturie. Aghá egeguturia-mi Agho Dari bebejeguturie. Fristi mane nenuka aná farava ingari kakara undidigasue. ");
INSERT INTO bjz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moses da Agho Dariva ená gaga eini beago, jo irugea gigigambi-gea reisi-rera? Nangu Undari Feferava fristi* mane God du Tafaroro Ari Kambova* aná feferada agho dari bejeta rouvie-tago, númane jo ari sembago ambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amó nímandu isaghava rere. God du Tafaroro Ari Kamboda durogha ijoko re. Embó nímanda dibeva jiria vitia, aná jojabe re. ");
INSERT INTO bjz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God da Gaga eini evere: ‘Anda uno bee mo, aná komanadu neno mema ea sonembari re, jo andú vesa dungari irambi re.’ Nímane ená gagada bee tanana egegasira mo, nímane dara tefo enemboda dibeva gaa rirota, mema utota itatama egegari-du jo rambi egegasiravore. ");
INSERT INTO bjz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Anada bee mo, Enemboda Jojabee*, umó Nangu Undari Feferada Jojabee re.” ");
INSERT INTO bjz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","10","Aghá rea, Iesu aria, númanda nghaĩ itari kambova teteruria mo, embó eini ingo dimbaride avo asumbea irieta, enembo dumeni Iesu bua, koto asua-da bee tava egeguturota, Iesu du uriga eghá egeguturie, “Namonde anda Agho Dari daiyagha reiri? Nangu Undari Feferava enembo rata jebugari vitia, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aghá ningia, Iesu mino eghá ririe, “Nangu Undari Feferava nímanda oka ragaro sifi mi kotova jua voradua mo, nímane dano ghambugota vitaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nundubadi rere! Oka sifi umó ijoko re-tago, enembo aná jojabe re. Amindu Nangu Undari Feferava imó aito fugari taubana nanjogo egegadora, anami agho dari jo bejambi aita rosoravore,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aghá rea doa, aná embó ingo dimbaridedu eghá ririe, “Inda ingo ruruge!” ririe. Ririeta, aná embó unda ingo ruruguturia aghade, unda ingo taubana dogo ea, unda yoveni aghago urie. ");
INSERT INTO bjz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aghá uria-da ambova, Moses da Gaga Kaifa kakato isaghava bubua aria, Iesu dedegota amburari-du manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Númane manaka gaeguturia-nu tanana ea, Iesu erea, aná kambesi doa irueta, kae bua vitiria enembo oruaruabe unda ambova tuvia irueta, númanda kae mane urieta jejebuguturia aghade, Iesu aná enembodu, rourogo umó avouro isagha egegauve-degea ririe. ");
INSERT INTO bjz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aghá uria-mi Aisaia da gefiria gagada bee siroruturie, aná evere: ");
INSERT INTO bjz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Anda buro kato neno bua gateguturera, aná evere, undú gangoro urota vitere. Anda Asisi undava utota asugota, anda sonemba utaita rora-nu abua-abua nanjogodava minono rata niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Umó jo besiga o koko ininigha rambi aita rouvie. Kotú umó jo isaghava jiria be fakara rirota, neno akuago egegari-du jo rambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","21","Unona enembo ijoijokoko kaifa tavo urota, númandava mema o bouvu eini jo utota jurambi aita rousue. Umó ano urota irirota, gaa beede, ari taubanade, anami ari-bari akokogo afuregota, manjaita rouvie. Aghá ata bee siroradua, abua-abua dano númanda kaifa gigita ari undava utaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Anada ambova, taimumi asuguturieta, dibe soike ea, kotú be gunga ea vitiria embó eininu Iesu dava bua fufuguturie. Aghá urieta, Iesu na urieta, aná embó jebugea, unana gia, gaga rari inono urie. ");
INSERT INTO bjz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aghá urieta, avo desia vitiria enembomi gia, dano bee duduku-dadaka ea, “Devit da Mendi God na utaita riria, umó ra-jogo,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tago, Moses da Gaga Kaifa kakato* aghá niningiguturie-gea, eghá regeguturie, “Ená embódava ano tefo re. Umó ano taimu akokogoda barirari Belsebul (o Satan reta rosora) dava bua, anami taimu akokogo tuviaveta isaghava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Númanda donu nundubutua, Iesu seibe gerurie-gea, númandu eghá ririe, “Gigige! Kini unda kaifa eta rouvia roo enda bejea noni-noni ea, tofo-tofo mene-mene egegadua, o kotú enembo naa rorova o kambo rorova gategea vesó-vesógo adua, gaimbo ambi mino-mino dea, sidara aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aghago, Satan unda enembo bejea, noni-noni ea, tofo-tofo mene-mene egegadua mo, unda natofo kaifa eta rouvia kambesi mo daiyagha jiria iradu? ");
INSERT INTO bjz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Amó aghá rera-da bee mo, amó Belsebul da anomi taimu akokogo tuvota bubari gaa reisi-nundubutoravore. Tago, inda yaveronu gigige! Númane avoda anomi taimu tuviaveta bubuta rousu? Nímanda yaveroda egeguturia-mi, isagha rouvia mo, nímanda reisi-rera, aná gavera re. ");
INSERT INTO bjz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tago, amó taimu God da Asisida anomi tuveta rora-du, nímane tanana egegasiravore, God da natofo* kaifa ari fefera aná seibe etia, nímandava bubua vitie. ");
INSERT INTO bjz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aná rera gagada bee, aná evere: imó embó ano kato einida kambo bejea, unda eini-eini susughi aita nundubadora, sei unda eka ingo bundia itota vasiota-gea ambova unda eini-eini bua yari, aná rauko re. Ari dabako aghago amó Asisi Kakarada anomi, Satan da ano buregea doa reaveta, unda taimu mane fuava bubuta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Umó avona amó sonembambi adua, umó anda gitofo aita rouvie. Kotú umó avona angá danode irambi adua, umó anda noniva bejea airo-airo aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Amindu rere. Avona ari akuago ea, o gaga sembago rea, ambova unda ari-bari akokogo rouvia-nu isagha adua mo, God unda ari-bari akokogo aná nundubea gia doaita rouvie. Atá, avona Asisi Kakarada bingá fara adua mo, God na aná ari akuago jo nanjigo aghade nundubea gia doambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dabako aghago, Enemboda Jojabeeda* bingá avona fara adua, God na unda ari-bari akuago aná nundubea gia doaita rouvie. Atá, avona Asisi Kakarada bingá fara adua mo, God na aná ari akuago jo nanjigo aghade nundubea gia doambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ika taubana maneda bee aita rouvia, aná taubana re. Kotú ika sembagoda bee aita rouvie, aná sembago re. Amindu, ikada bee gerurota, tanana aita rosoravore, taubana ra, aĩ, akuago ra? ");
INSERT INTO bjz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nímane angoghoda fufumbugari re. Nímane gaga taubana eini rari inono irambi re. Anada bee mo, enemboda neno rova domi beda ea iradua, ananu rata isaghava bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Embó taubana, unda neno rova gaga taubana vitia-nu reaveta isaghava bubuta rouvie. Kotú embó sembago unda neno rova gaga sembago vitia-nu reaveta isaghava bubuta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amó nímandu eghá rere. Enembo númanda bemi gaga sara sisigho mane reisi-ria-du irurari feferava númanenu iruraita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Inda gagava gerurota, God na imó iruraita rouvie. Gaga taubana gadua mo, imó taubana gaa raita rouvie. Akuago gadua mo, imó akuago gaa raita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Iesu aghá riria-da ambova, Moses da Gaga Kaifa kakato* dumenide, kotú Gaga Irugari kakato dumenide eghá regeguturie, “Irugari, námanda uno ari-bari ivatagha adi, sirorota gaita uno rosore.” ");
INSERT INTO bjz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aghá regeguturieta, Iesu, númandu eghá ririe, “Deriva urota, God da Gaga ningambi eta rousua enembomi, ivata anogha ata gigigaita uno rousue. Tago, feroveta Jona dava siroruturia aghago, nuenembo irugota gigigaita rosoravore. Ivata eini jo ata, gambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Feroveta Jona onembo bakode, kotú tumba bakode uvu oka jojabeda uro rova vitiria aghago, Enemboda Jojabee* fefera bakode, kotú tumba bakode enda rova iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Irurari feferava, Nineve enembo beago ereregea, nímanda ari akokogo isagha aita rousue. Anada bee mo, númane Jona da minono niningigea númanda ari akokogo doa neno kaveruturie. Atá, amó nímandu eghá raita rore: oreki enava minono reiria embó, aná jojabe re. Jona aná ijoko re. Tago, nímane jo neno kaverambi viteravore. ");
INSERT INTO bjz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Irurari feferava, Siba bogu naada Kotofu Evetu erea, God da dibeva jiria nímanda ari bari akokogo isagha aita rouvie. Umó aná roo airo bee reta Solomon da neno nundubari kotú irugarinu gaita rea furie. Atá oreki nímanda dibeva jiria minono reiria embó, aná Solomon da itiva re. ");
INSERT INTO bjz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Taimu sembago eini embóda tamo rova reta doa, isaghava bubadua mo, umó uvu tefo kambesiva biruru urota, nangu undari kambesi tava aita rouvie. Tava ea tambambi adua, ");
INSERT INTO bjz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","unda kambo seinu nundubuturota, eghá raita rouvie, ‘Amó kaverea, anda kambo seiva yaitare.’ Kaverea yadua mo, aná kambova enembo tefo, yaveve tafoni ea, eini-eini simbugota, tambaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aghá ea, aná taimu umó taimu akokogo ingo yoveni yoveniva unghagha, sembago bee sembago umó vitia-da etova aghagonu bua furá, aná kambova numonde iraita rousue. Aghá adua, aná embóda irari sembago bee sembago aita rouvie. Avore, oreki nímane enda etova vitera enembo sembagodava, aghago siroraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu aná enembo desituria-da dibeva gaga rieta, nuede kotú unda jamenade bubua, isaghava jiria, undava gaga raita benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aghá ueta, embó einimi gerurie-gea, Iesu du eghá ririe, “Inda niede kotú jamena vivide onanu isaghava jijiregea, indú gaga regegaita uno rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu na mino ririe, “Anda ayade, kotú jamenade mo avouvi?” ");
INSERT INTO bjz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iesu na ingomi unda ambo nimbinu iruguturota ririe, “Gigige! Anda aya jamenade, aná evere. ");
INSERT INTO bjz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Avona anda Afa uutuva vitia-da unonu adua, anda aya, anda ikoko mendi kotú anda ariri gharovu, aná númane re.” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aghá rea, fefera anava, Iesu aná kambo doa, bubua aria sao, jojabe betuva, avo asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Asumbuturieta, enembo natofo oruaruabe furia, undava danode ea, kambesi gagajeguturie. Aghá uria-du, ghaa* eini uvuva fẽ ueta gerurie-gea, umó aria vorea, aná ghaa rova asumbuturie. Aghá urieta, natofo dano bubua, uvu betuva jijireguturie. ");
INSERT INTO bjz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Aghá urieta, Iesu umó tutuno ea nghaĩ ititurota, kasia manemi irugeta urie, “Nundubea gigige! Embó eini erea, unda aayova farava vee govaita rea iye. ");
INSERT INTO bjz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iya bubua, tutuno ea, vee gogotea bua ghasio etue. Etueta, vee dumeni begatava vovoregetueta dii manemi etia undidigetue. ");
INSERT INTO bjz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Kotú vee dumeni mo, singoi endava vorea, tutumi batuma-batuma etue-tago, feferami evia, sibí-sibí ea, enda ghandiba bee irambi-gea, riribu gambambi, gharasa etue. ");
INSERT INTO bjz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kotú vee dumeni, aná vive gingideda rova vorea, vivegha danode vitie. Amigha vitieta, vivemi afuregea sidara etue. ");
INSERT INTO bjz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kotú vee dumeni mo, enda taubanava vorea vitia, bee righia mo, dumeni 100, dumeni 60, kotú dumeni 30, aghago righie. ");
INSERT INTO bjz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nímane avona nghaĩde iradora, nghaĩ javea ningia goghó egege!” ");
INSERT INTO bjz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aghá ririeta, Iesu da ambo nimbi furia, undú uriga eghá regeguturie. “Imó bee dodu enembo desetua-du gaga kasia eghá reto?” ");
INSERT INTO bjz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aghá regeguturieta, umó mino eghá ririe. “Afa God daiyagha unda natofo* kaifa eta rouvia-da gaga dumeni kivu uria-da bee nímandava isagha eta rore. Tago, númandava aná gaga tanana arida ano jo utota, sirorambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Anada bee mo, enembo avodava eini-eini oruabe iradua, anada etova oruabe utota bua, undava eini-eini oruaruabe aita rouvie. Tago, enembo avodava itoko iradua, undava aná rougea baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Númandu gaga kasia reta rora-da bee mo, aná evere: ‘Númane gigigeta rousue-tago, jo gambigo eta rousue. Ningita rousue-tago jo niningigambigo eta rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Númandava, aná feroveta Aisaia seibe riria gaga isagha uria, aná evere: ‘Inda natofo dava ii, númandu eghá radi! “Nímane ningari re-tago, ningambigo egegaita rosoravore. Gari re-tago gambigo eta rosoravore. Anada bee mo, ená enemboda neno aná fakara bee re. Gaga númanda nghaĩmi ningita rousue. Tago, dibe afuregea vitie. Jo aghago egegambi iririgasira mo, númane dibemi gia, nghaĩmi ningia, nenomi nundubea, neno kaverea, númanda ari-bari akokogo doa, andava fufugasueta, númane sonembasueta, jejebugasue.” ’ ");
INSERT INTO bjz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tago, anda ambo nimbi, gangoro egegadi rere! Anada bee mo, God Afana nímanda dibede nghaĩde dano ea simbuguturieta, donu eta rora-nu gigigeta rosoravore, kotú minono daiyagha reta rora-nu, niningigeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Atá, amó gaa bee rere, nímanda donu gigigeta rosora ananu, God da yavero nanjogo, feroveta mane nanjogo seibe gigigaita uta fufuguturie-tago, jo gigigambi re. Aghago donu niningigeta rosora-nu, niningigaita uta fufuguturie-tago, jo niningigambi re. ");
INSERT INTO bjz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Avore, nghaĩ javea, ená kasiada bee raitata niningige: ");
INSERT INTO bjz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Vee begatava vorari gaa retora, aná evere: Enembo avona God Afada natofo* kaifa rouvia-da gaganu niningigeta rouvie-tago, anada bee jo tanana ambi egegeta rousue. Ambova Satan mi fuava, neno rova goveaveta, veenu roughea buta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Gari dabako aghago, vee dumeni singoi endava jua vovoregetua-da bee mo, evere: enembo avona God da Gaga niningigea, gangorogha buta rousua, avore. Tago, númanda gaabee ari jo jojabe irambi-gea, fefera tufoko irirota, númane gaabee egegutua-du, dara o bouvu dumeni siroradua mo, riribu gambambi ea, gharasa etue-gea, God Afadu goitu fotaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Vee dumeni vive gingideda rova vovoregetua, anada bee evere. Enembo dumeni God da Gaga niningigeta rousue. Tago, eini-eini oruabe nundubuturota, o endada gugua-ghayafadu muu dirota, anami afuregetueta, bee jo sirorambi re. ");
INSERT INTO bjz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Atá, aná enda taubanava vorea, dumeni bee mane 100, dumeni 60, dumeni 30 ririkuria-nu retora-da bee, aná evere: enembo avona, aná gaga ningia tanana ea bua, ivatava itita rouvia ananu re.” ");
INSERT INTO bjz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Aghá rea, Iesu na kasia eini eghá ririe: “God Afa unda natofo* kaifa rouvia-da gaga, aná embó avona unda aayova vee taubana govetua, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aghá ea, umó iyeta, tumba rorova enembo dano evia tefo egegetueta, unda gitofomi vive vee bua etia, aná faravada gorotova avo govea doa iye. ");
INSERT INTO bjz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aghá etueta, farava vivitua, aná vive beago vitie. ");
INSERT INTO bjz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aghá etueta, unda sabua* buro kakatomi iya gie-gea, etia aayo numamodu eghá retue, ‘Barirari, imó mo, vee taubana nuenembo govetora, aĩ, tefo? Atá ená vive mo, doda reta avo rei-vivitu?’ ");
INSERT INTO bjz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aghá retueta, aná aayo numamomi retue, ‘Gitofomi etue.’ Aghá retueta, unda sabua enembomi regegetue. ‘Gigo! Námane ya sundo egegara, aĩ?’ ");
INSERT INTO bjz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Aghá regegetueta, aayo numamomi eghá retue, ‘Tefo, nímane rourogo vivede faravade dano fisugara-degea, jo sundo egegambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Do-gea, dano vivitigoe! Vitia, bee ata-gea, faraita rousua aghade, anona rata-gea, buro kakatomi taimbea aná vive kisí ea bua ya, ivariva dungiturota, farava farea bua furá, anda kambaruva ititigoe!’” ");
INSERT INTO bjz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","God da enembo daiyagha oruabe egegeta rousua-nu nundubuturota, Iesu na ika ijoko ragaro mastadi da kasia eini eghá ririe, “Ika mastadi da vee jo ika dumenida veego irambi, ijoko bee re. Tago, enembo aná ika mastadi da veenu bua ya, númanda aayova goveaveta, ");
INSERT INTO bjz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ika vitia jojabe ea, fafatu sarigeaveta, dii mane fuava, númanda mogha aná ika fafatuva ititigeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu na rekago kasia eini eghá ririe, “God da enembo daiyagha kaifa uaveta, oruabe eta rouvia, aná eghago re. Evetu eini farava, barirari-du ingi ragaro yisti itoko bua, farava oruabegha bagega ea, davituaveta, farava dano baria jojabe eta rouvia, aghago re.” ");
INSERT INTO bjz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu umó aná gaga nanjogo rirota, kasiami ririeta, sidara urie. Kasia tefo, gaga eini jo rata, natofo jede niningigambi re. ");
INSERT INTO bjz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aghá uria-mi, feroveta eini unda sei riria gagada bee isagha urie. “Númandu rirota, amó kasiami gaga rata niningigaita rousue. Aghá urota, gaga uutu enda sirorambi-va kivu urieta vitiria-nu, rata niningigea, tanana egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Umó aná enembo avo doa aria, kambova teterurieta, unda ambo nimbi terua, undava furia, Iesu du eghá regeguturie. “Iesu, námandu aná aayova viveda kasianu isagha ege-gea, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aghá regeguturieta, mino eghá ririe. “Avona vee taubana govetua, aná Enemboda Jojabee* re. ");
INSERT INTO bjz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aayo mo, ená enda re. Aná vee taubana retora-da bee mo, aná God da kaifa rouvia natofoda* sasingu re. Kotú vive retora, aná gitofoda sasingudu rere. ");
INSERT INTO bjz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aná gitofo embómi vive govetua, aná Satan umó re. Gamo ea bua furari, aná uutu enda manjaita rouvia fefera aghago re. Gamo ea bua furari enembo mo, aná anera mane re. ");
INSERT INTO bjz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Atá, eto-bato vive susia ivariva dungeta rouvia, uutu enda manjaita rouvia feferava aghagonu siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Aghade, Enemboda Jojabee unda anera mane itota furá bubua, vive mane suseta rousua aghagonu, unda kaifa eta rouvia natofoda rova terua, avona unda komana ari-bari akokogo ari-du kuvia gigigeta rousua enembode, kotú ari-bari akokogo eta rousua enembo nanjogode dano bua, ivari bubura mondé-mondé uradua-va avo fufugegota, memagha diitu yavi kirisi-karasa urota, jiiji regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aghade, enembo taubana mane Afa unda natofo kaifa rouvia kambesiva, aná uutuva feferami janimbarigo egegaita rousue. Amindu, nímane avona nghaĩde iradora, nghaĩ javea ningia goghó egege! ");
INSERT INTO bjz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","God unda natofo* kaifa eta rouvia kambesiva ano faghighigha teraita egegeta rousua, eto-bato embó eini gugua-ghayafa aayo einiva nungari vita-nu ininigha baita etua, aghago re. Aná gugua-ghayafa rera, aná embómi tambua, gangorogha bua rekago nungetue. Aghá ea, aná gugua baita rea, unda eini-eini donu vitia-nu taimbea, enembodu utua guri nanjogo bua, aayo numamodava utua, aná gugua-ghayafa nungarivade dano gangorogha umó tofo etue. ");
INSERT INTO bjz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kotú, isuri ari gaga eini, evere: God unda natofo kaifa eta rouvia kambesiva ininigha teraita egegeta rousua, eghago re. Embó einimi guri firu eta rousua-da singoi mino jojabenu tava urota vitie. ");
INSERT INTO bjz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Avore, fefera eini singoi esiko-esiko mino jojabe eini tambua, unda eini-eini donu vitia-nu taimbea, enembodu utua guri dumeni bua, dano aná singoi numamodu utua doa, umó tofo etue.” ");
INSERT INTO bjz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aghá rea doa, Iesu rekago kasia eini eghá ririe. “God da kaifa rouvia natofo* rova terarida gari mo, aná saova ghoto fugea, uvu oka dibe eini be eini berita rousua, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Avore, fefera eini aná ghoto beda etue-gea, aná uvu oka berari kakato iya ghoto ghambugea vitia mangosava itie. Aghá ea, avo asumbea, tutuno ea, uvu oka dorea, tataubana mane kaifetava fefendurota, sembago mane, aná doa fufugegetue. ");
INSERT INTO bjz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Atá ená rera aghagonu, uutu enda manjaita rouvia fefera aghade siroraita rouvie. Anera manemi furá taimbuturota, enembo akokogo rururota, tataubana mane doaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aghá ea, aná enembo akokogo bua, ivari bubura mondé-mondé rouvia-va avo fufugegota, memagha diitu yavi kirisi-karasa urota, jiiji regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Atá, nímane gaga dano tanana egegetora, aĩ, tefo?” Aghá ririeta, aná enembo númane mino ririe, “Námane ningia, tanana egegetore.” ");
INSERT INTO bjz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aghá regeguturia-du Iesu na eghá ririe, “Moses da Gaga Irugari kato* avona, God da natofo kaifa rouvia-va teradua mo, umó kambo numamo eini aghago re. Aná kambo numamo unda eini-eini reka rura-de, gugua-ghayafa sei rura-de dano unda mauvava vitia-nu jijimu eta rouvia aghagonu, unda beforo gari rekade seide dano nundubuturota irugeta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu aná kasia gaga mane rea sidara ea, aná kambesi doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aghá ea furia, unda baboruria naava bubua aria, nghaĩ itari kambova* terua iruguturie. Irugutueta, enembo gia bee duduku-dadaka ea, eghá regeguturie. “Umó ená beforo gari doda bua eghá rouvi? Kotú, ivata eta rouvia-da ano doda bua rouvi? ");
INSERT INTO bjz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Umó mo, kambo itari katoda mendi ra, aĩ? Unda nue aná Meri unda jamena Jems, Josep, Saimon, kotú Judas de ra, aĩ? ");
INSERT INTO bjz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kotú, unda gharototode dano eve namonde vitere. Umó ená naava embó re. Umó ená neno nundubari, kotú ano niavo rururi?” ");
INSERT INTO bjz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aghá rirota, injigha ea, neno akuago egegutueta, Iesu tanana ea, mino númandu eghá ririe, “Natofo jede gogorego feroveta mane kakara egegeta rousue-tago, unda naava totofomi umó jo kakara ambi eta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Númandava gaabee ari tefo-gea, Iesu númandava irirota, ivata anogha oruabe jo ambi re. ");
INSERT INTO bjz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Fefera aghade, Galili Frovensi da kotofuko, Herot umó Iesu da ari-bari donu ua-da bingánu ningia, ");
INSERT INTO bjz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","unda buro kakatodu, eghá ririe, “Ená embó mo, Jon Bafutaito Ari Katona amburari vareta jebugea erora-jogo. Amindu umó ano jojabe bua, ená ari ivata anogha eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Aghá nundubuturia-da bee mo, Herot unda ikoko Filip da evetu, ragaro Herodias, ufuva yagera uria-du Jon Bafutaito ari kato erea, Herot du eghá reta urie, “Imó aná evetu yagera urota, agho dari bejitureravore.” Aghá reta uria-du, Herot na Jon nandia bundia bua aria, diburava gajiturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot neno akuago urota, Jon data amburari-du uno urie. Tago, natofo jededa nundubariva Jon umó feroveta jojabe eini regeguturia-nu ningia, umó natofodu oru urie. ");
INSERT INTO bjz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aghá urota, Herot da sirorari fefera furia buburiturieta, Herodias da aririmi bubua, aná banau uria-va daa unona didivurie. Aghá ueta gia, Herot gangoro urie-gea, ");
INSERT INTO bjz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","be anogha gajiturota, eghá ririe. “Imó eini-eini nanjogodu uno ea radora, amó utaitare.” ");
INSERT INTO bjz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aghá ririeta ningia, Herodias erea, unda ariridu eghá ririe, “Ii, radi-gea, Jon Bafutaito ari katoda beforonu divegea tevova fendia utota, bofu, bare!” Aghá ririeta ningia, unda ariri aria, nueda riria gaga dabako aghago Herot du ririe. ");
INSERT INTO bjz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aghá ririeta ningia, Kini Herot neno mema urie. Tago, esega enembo banauva buburituria-da dibeva be anogha gajituria-nu nundubea, aná aririda uno ea riria aghago sirorari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Aghá ririe-gea, unda buro kakato aria, dibura kambesiva Jon da ukonu diveguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Divegea, Jon da beforo tevova fendia fumbua furia, aná ariridu ututurieta, bua aria, nuedu ututurie. ");
INSERT INTO bjz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aghá urieta, Jon da ambo nimbi aná bingá niningigea furia, Jon da tamo bua aria furuguturie. Furuguturia-da ambova, númane aria, Iesu dava bubua, Iesu dava isuri egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aghá ririeta ningia, Iesu aná kambesi doa serigea, ghaava* vorea, unuka enembo tefo kambesiva arie. Arieta, Iesu da bingá niningiguturie-gea, natofo jede númanda naa mane dodogea ombova, Iesu da ambova ekami igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aria bubua, avo fugea iririgutueta, Iesu aria, ghaa ga vitia geruria mo, natofo jededu neno mema ea, númanda kae enembo urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jama beede unda ambo nimbimi furia, Iesu du eghá regeguturie. “Ená kambesiva enembode kambode tefo re. Kotú jama rouvieta ená natofo ninenge, ya naava undari tava ea, gurimi utua bua undidigoe!” ");
INSERT INTO bjz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aghá regeguturieta, Iesu númandu mino eghá ririe, “Dodu yadu? Undari nímanena ututuge, undidigoe!” ");
INSERT INTO bjz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aghá ririeta, unda ambo nimbi mino eghá regeguturie. “Námandava farava ingari ingo yoveni kotú uvu oka ungaghade nuenembo vitie.” ");
INSERT INTO bjz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aghá regeguturieta, Iesu na eghá ririe, “Bua eve, andava fufuge!” ");
INSERT INTO bjz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anada ambova, Iesu na ririeta, aná natofo yavaira etova asusumbuturieta, umó aná farava ingari ingo yovenide uvu oka ungaghade bua, dibe jará ea uutuva urota, God Afadava “aiye” rirota, aná farava righia ingegebea, unda ambo nimbidu ututurieta bubugea, aná natofodu vesa egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Vesa egeguturieta, bua dirieta inono uria, anada itoto dumeni dodoguturia-nu, Iesu da ambo nimbimi erea bua, kanda jojabebei dano 12 anava fefendiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Avore, embobo dano 5,000 undari undidiguturie-tago, aná evevetu sasingu manede jo irugambi re. ");
INSERT INTO bjz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Undari undidiguturia-da ambova, jo gaimbo ambi, Iesu na tatavami unda ambo nimbi ririeta, ghaava* vorea, yoveniva rekimbea igigutueta, umó aná natofo nineguturieta tará egegutueta gia doa, ");
INSERT INTO bjz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iesu ootova benunu aita unuka yavurie. Aghade, jama ea, fefera vovorurie. ");
INSERT INTO bjz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tago, aná ghaa seibe bubua aria, togho yafabe ea, yavatava dea, toru-tara urota, yaura tariri urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Irieta, rifoda bingoiva Iesu vorea, uvu etova deĩ ea, unda ambo nimbidava arie. ");
INSERT INTO bjz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Irueta gigiguturie-gea, oru ea, eghá regeguturie, “Ariee, ená taimu re!” rirota, koko-koko regeguturota aregea, farara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Oru egegutueta gerurie-gea, Iesu na eghá ririe, “Amó reta! Mania oru egegata! Ano egege!” ");
INSERT INTO bjz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aghá ririeta ningia, Pita na eghá ririe. “Jojabee gaa bee imó iradora mo, rege, amó uvu etova deĩ ea ya, imó tambore!” ");
INSERT INTO bjz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aghá ririeta, Iesu na Pita du, “Vorea fu!” ririeta, Pita ghaa rovareta vorea, uvu etova deĩ ea, Iesu dava arie. ");
INSERT INTO bjz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tago, umó irurota, aná yaura gagarua gerurie-gea, oru ea, uvu rova degimbea vovorurota, Iesu du ririe, “Aee Jojabee, amó sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aghá ririeta, gaimbo ambi Iesu na ingo sinia, Pita da ingova righia ririe, “Indava gaabee ari tefo ra? Dodu neno jabura rio?” ");
INSERT INTO bjz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aghá rea doa, Pita ungá Iesu gha furia, ghaa rova vivitueta, yaura yavatada torú-torú sidara urie. ");
INSERT INTO bjz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aghá urieta, unda ambo nimbi nanjogo aná ghaa rova vitiria-mi “Gaa bee, imó aná God da mendi re.” rirota, undú tumogha baĩ egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ea, númane rekimbea aria, roo enda ijoko Genesaraet anava terua, ghaa gaiturie. Genesaraet rera, aná kambesi gevoto, kotú anada rova naa ijoijokoko dumeni irita urie. ");
INSERT INTO bjz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aghá urieta, aná kambesiva enembo Iesu tanana egeguturie-gea, aghi ititurieta aná roo enda, kasava naa nanjogo dano númanda kae bua vitiria enembo unumbea, Iesu dava bua fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Furia bubua, Iesu “avore” rata, aná kae bua vitiria enembo undava bubua, tefo unda eembo bimbiva sinia righia jejebugari-du rea, benunu egeguturie. Kotú aná aghá egeguturia enembo dano, jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aghade, Moses da Gaga kaifa kakatode*, Irugari kakatodemi, Jerusalem reta furia, Iesu dava danode desea, uriga eghá egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dodu inda ambo nimbi namonde anda mambube maneda evovo donu iruguturia-nu ambo-ambo egegambi irirota, ingo seghambi dongorogha undari bua reisi-undi?” ");
INSERT INTO bjz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aghá regeguturieta, Iesu mino eghá ririe. “Atá, nímane dodu nimambube maneda evovonu gaabee urota, God da Agho Dari bebejegeta roso? ");
INSERT INTO bjz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Atá, niningige! God eghá ririeta, Moses na gefirie, ‘Nie nimamoghadu sabua* urota, númanda gaga ningia ambo-ambo egege!’ kotú gaga eini evere: ‘Avona nue numamodu tauga kavavana radua-nu, dedege, amburoe!’ ");
INSERT INTO bjz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Tago, nímane eghá irugeta rosoravore. ‘Enembo avona nue numamo injigha urota, unda gugua-ghayafa bua, God dava vesa utari gaa rirota, nue numamo jo sonembambi adua mo, aná “Avore” regegeta rosoravore.’ Nímane aghá urota, God da Agho Daridu goitu fotiturota, nimambube maneda tumanadu gaabee egegeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nímane aghagago eta rousua enembo re! Feroveta, Aisaia nímandu nundubuturota, gaa bee gefiria, aná evere. ");
INSERT INTO bjz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ená enembo númanda bemi amó kakara ari gaa reta rousue-tago, númanda neno roo, aná airo bee re. ");
INSERT INTO bjz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Númane andú tumogha baĩ eta rousue. Tago, bee eini tefo re. Amindu avo sonembari eini jo tambambi egegaita rousue. Anada bee mo, númane eto nenomi egeguturota, anda Gaga doa, enemboda irugaride, kotú nundubaridenu anda Gaga aghago rirota irugeta rousue.’” ");
INSERT INTO bjz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aghá rea, Iesu na ririeta, natofo jede danode desiturieta, eghá ririe, “Nghaĩ javea niningigea tanana egege! ");
INSERT INTO bjz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Enembo donu undiaveta, beva reta iiava, urova voreta rouvia-mi jo ata, enemboda neno roo bebeta ambi aita rouvie. Tago, gaga donu enemboda beva reta bubuta rouvia-mi ata, enemboda neno roo bebeta aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aghá ririeta, Iesu da ambo nimbimi furia undava, uriga eghá egeguturie, “Moses da Gaga Kaifa kakato* aná gaga niningigetua-mi, númanda nenova gaitueta itatama akuago rousua, imó gera?” ");
INSERT INTO bjz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aghá regeguturieta, umó mino eghá ririe, “Atá ika mane anda afa uutuva vitia-mi jo govambi uria, dano fisugaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Númane dibe soikide, kotú dibe soikide maneda beforo righari mane re. Atá, embó dibe soikedemi, dibe soikede eininu unumbea yadua, ungá umó kavava juraita rousue. Aghá-gea, númane do-gea avo igigoe!” ");
INSERT INTO bjz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aghá ririeta, Pita na eghá ririe. “Námandu aná kasia gaga retora-da beenu isuri ege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aghá riria-du, Iesu na mino ririe. “Nímane beago, daiyagha mana-mana roso? Nímane jo niningigea nundubambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nímane gigige! Eini-eini domi enemboda beva vorari, aná iiava uro vareta, iiava isaghava bubuta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tago, eini-eini domi, enemboda neno rova reta fuava, beva reta isaghava bubuta rousua-mi eaveta, enemboda neno roo bebeta eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Anada bee mo, ená eini-einimi enemboda neno rova reta fuava bubuaveta, enembo bebeta egegeta rousue: nundubari akokogo, enembo data o righota amburari, komanada evetu o embógha viro kombo kivumi ari, viro kombo tefo-tafo ari, bagia ari, koto feferava gaga gaveranu rirota, osagho fumbari, kotú komanada tamova gavera rari re. ");
INSERT INTO bjz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ená ari-barimi eaveta, enemboda neno roo bebeta egegeta rousue. Tago, ingo seghambi undari bua undadua-mi jo ata, enemboda neno roo bebeta ambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Anada ambova, Iesu unda ambo nimbide aná kambesi doa, gitofoda bogu naa ragaro Tair de, Saidon deda roo endava arie. ");
INSERT INTO bjz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aria buburiturieta, abua Kenan evetu eini aná kambesiva vitiria-mi Iesu da bingá niningurie-gea, furia, Iesu dava jiigha gaagha koko fugia ririe. “Ae, Jojabee, Devit da Mendi andú neno mema ea sonembadi rere! Anda ariri taimu akuagomi asugetueta, mema jojabe itatama eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aghá ririe-tago, Iesu umó aná evetudu gaga mino jo rambi urie. Aghá ueta, unda ambo nimbi furia, undú rea bera-bera urota, eghá regeguturie, “Ená evetu namonde anda ambova jiigha deĩ rouvieta. Ninenge, serigea yae!” ");
INSERT INTO bjz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aghá regeguturieta, Iesu na aná evetudu eghá ririe, “God amó jo abua-abua dumeni sonembari-du ninengota furambi re. Námanda abua Israel enembo emboro taubanadu mana-mana urota vitia-nu sonembari-du rea, amó ninenguturieta furere.” ");
INSERT INTO bjz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aná evetu Iesu da gaga niningurie-tago, unda dibeva koubomi jengirea eghá ririe, “Jojabee amó sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ririeta, Iesu na eghá ririe. “Imó gi, sasingu maneda undari bua ninodu utari, aná jo taubana irambi re.” ririeta, aná evetu umó eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Jojabee, aná gaa bee re, avotago, undari dirota, susundo numamoda farova reta jua voradua, nino manemi undita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aghá ririeta, Iesu na aná evetudu eghá ririe, “Evetu, inda gaabee ari jojabe re. Amindu, inda donu uno etora, indava seibe siroretue,” umó aghá ria, aghade aná evetuda ariri, jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Anada ambova, Iesu aná kambesi doa, Galili Sao kasava gegerea aria, ootova vitia, avo asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aghá urieta, enembo natofo oruabe undava fururota, eka ingo dimbari, dibe soikide, be gungade, kotú dumeni oruabe tigia furia, Iesu da eka tuva ititurieta, Iesu na urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Aghade, natofo jede fufuguturia-mi, aná eka dimbari erea, deĩ uria-de, ingo dimbari ingo ruruguturia-de, be gunga gaga regeguturia-de, kotú dibe soiki roo gia iruruturia-denu gigigea, bee duduku-dadaka egeguturota, Israel enemboda God du raga regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aghade, Iesu umó unda ambo nimbi ririeta furia, danode desiturieta ririe, “Amó ená enembodu neno mema rore. Anada bee mo, númane fefera bakode eve namonde irieta, undari sidara etue. Amó númane undari undambi ninengari injigha rore. Anada bee mo, rourogo, undari tefo ninengota igiguturota, jua erea auve-degea rere.” ");
INSERT INTO bjz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aghá ririeta, Iesu da ambi nimbi erea, eghá regeguturie, “Ená enembode kambode tefo kambesi re. Amindu, namonde amó ená enembo desea vitia-da undari inonova doda bua, ená enembo unduduga?” ");
INSERT INTO bjz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aghá regeguturia-du Iesu na ririe, “Atá nímandava farava ingari nanjogo viti?” ririeta, “Farava ingari ingo yoveni, kotú yoveniva ungagha re, kotú uvu oka ijoijokoko dumenide vitie.” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Aghá regeguturieta ningia, umó ririeta, Iesu aná natofo jede desituria-du ririeta forosegea, endava asusumbuguturieta, umó farava ingari ingo yoveni, kotú ingo yoveniva ungaghanu bua, God du “aiye” rea righia ingegebea, unda ambo nimbidava ututurieta, bua natofo jededu vesa egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Aghá urieta, aná enembo undidigea, inono bee egeguturieta, Iesu da ambo nimbimi kanda dano 7 bua, aná itoto fefendiguturieta beda urie. ");
INSERT INTO bjz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aná undari undidiguturia embobo dano 4,000 re. Aghade, evevetu sasingu manede undidiguturie-tago, númane jo irugambi re. ");
INSERT INTO bjz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Anada ambova, aná enembo nineguturieta igigutueta, umó aria, ghaava* vorea, rekimbea kambesi ragaro Magadan arie. ");
INSERT INTO bjz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Moses Da Gaga Kaifa kakatode*, kotú Sadyusi* enembo dumenide, Iesu kuvia gigigaita rea furia, undava God da ano vitia-mi, ivata anogha eini ata gia, umó avouvi tanana aita benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aghá regeguturieta, Iesu mino eghá ririe, “Avore, fefera iiava vovoruaveta gerurota, nímane eghá reta rosoravore, ‘Uutu arasegetue-gea, rifode taubana ataita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kotú rifogha nímane eghá reta rosoravore, ‘Uutu arasegea kotú yaumo-yaumo rouvie-gea, oreki boruma voraita rouvie.’ reta rosoravore. Aná boruma fefera nanjigo voraita rouvia-nu, nímane tutomi gia, tanana eta rosoravore. Tago, orekida feferava donu rei-sirorutua-da bee, jo gia tanana ambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Deriva urota, God da Gaga ningambi eta rousua enembomi, ivata anogha ata gaita uno rousue. Tago, feroveta Jona dava siroruturia aghago, nuenembo irugota gigigaita rosoravore. Ivata eini jo ata, gigigambi aita rosoravore.” aghá rea, númane doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesu da ambo nimbi rekimbea, sao yoveniva aria aghade, númane neno itia, farava ingari eini jo bua yambi re. ");
INSERT INTO bjz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aghá egeguturieta, Iesu na Moses da Gaga Kaifa Kakato* kotú Sadyusi* enembodeda nundubaride irugaridenu nundubea, númandu kasia gaga eini eghá ririe, “Gia goghó egege! Moses da Gaga Kaifa Kakato kotú Sadyusi enembodedava, farava ingarida yisti du goitu ututuge!” ");
INSERT INTO bjz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aghá ririeta, númane tutuno ea, nenukako mino-mino uriga egeguturota ririe, “Unda eghá retua-da bee mo, aghajora, namonde amó jo farava eini bua furambi etora-du retua-jogo.” ");
INSERT INTO bjz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Númane aghá regegutua, Iesu umó gerurie-gea, númandu eghá ririe, “Nímane dodu farava ingari inono irambi gaa rea, mino-mino manaka reisi-gaito? Nímandava gaa bee ari tefo re! ");
INSERT INTO bjz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Nímanda nundubari aná tufoko re. Amó aná farava ingari ingo yoveni nuenembo 5,000 du vesa utata undidiguta-da itoto kanda nanjogo fefendigutara mo, neno ititigetora-jogo! Kotú, aná farava ingari ingo yoveni etova ungaghanu aná embobo 4,000 du vesa utata undidiguta-da itoto kanda nanjogo fefendigutara mo, neno ititigetora-jogo! ");
INSERT INTO bjz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Amó yisti retora, jo yisti beedu rambi re. Nímane daiyagha gia tanana ambi roso? Nímane, rourogo Moses Da Gaga Kaifa kakato ungá Sadyusi enembodeda gaga niningigara-degea, retore.” ");
INSERT INTO bjz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aghá ririeta, unda ambo nimbi tanana egeguturie, umó jo yisti bee faravadu jijimu eta rouvia-du rambi re. Umó aná Moses da Gaga Kaifa kakatode Sadyusi enembodeda irugeta uria gagadu ririe. ");
INSERT INTO bjz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu aria, bogu naa ragaro Sisaria Filipai da kasava naa einiva bubua, unda ambo nimbidu uriga urie, “Nímane regege, ningore! Natofo jededa regegeta rousua mo, Enemboda Jojabee* avouvi?” ");
INSERT INTO bjz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ririeta, númane mino regeguturie, “Enembo dumeni imó Jon Bafutaito Ari Kato gaa reta rousue, dumeni imó feroveta sei eini, amburari vareta kaverea furari, Elaija ra aĩ, Jeremaia ra, aghá regegeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aghá regeguturia-du, umó númandava uriga eghá urie, “Atá nímane mo, andú daiyagha regegado?” ");
INSERT INTO bjz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aghá ririeta, Saimon Pita na eghá ririe, “God jebuga vitia-da Mendi, kotú God, enemboda ari-bari akokogo nundubea gia doaita rirota, Embó eini utaita riria, imó re.” ");
INSERT INTO bjz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aghá ririeta, Iesu mino undú ririe, “Saimon, Jon da mendi, God imó ea simbugetue. Amó rera-da bee mo, ená jo enembomi indú rambi re. Tago, anda Afa uutuva vitia-mi indú irugutata, tanana ea viteravore. ");
INSERT INTO bjz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amó indú eghá rere. Inda ragaro reka Pita rei-ririkore, aná ragaroda bee, aná singoi re. Aná singoi etova anda ekaresia*, kambo itita rousua aghago, anona ata bariraita rouvie. Kotú anda ekaresia rera, jo amburarimi rarigari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kotú anona God Afada enembo kaifa ari kambesida ki eini indú utaita rore. Imó endava irirota, donu gajadora, Afa uutuva vitia beago, gajaita rouvie. Dabako aghagonu imó endava irirota, donu vuregadora, Afa uutuva beago, vuregaita rouvie.” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Anada ambova, Iesu na unda ambo nimbi bureguturota, God enemboda ari-bari akokogo nundubea gia doaita rea, Embó eini gategea ninenguturia, aná umó-gea, natofodu isagha auve-degea ririe. ");
INSERT INTO bjz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Fefera aghade, Iesu tutuno ea, unda ambo nimbidu isuri gaga eghá reta urie, “Amó Jerusalem bogu naava bubadora, mema bouvu dibe eini be eini itatama aita rore. Babarigaride fristida* kokotofude, kotú Agho Dari irugari kakatodemi* amó injigha egegea bua, dedegota amburaita rore-tago, fefera bakodeda ambova rekago jebugea eraita rore.” ");
INSERT INTO bjz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Aghá ririeta, Pita na umó bua aria, kasava jiria, bureguturota dibe beva gaa ininigha ririe, “Jojabee, mania aghá rata! Aná mania indava sirorauveta!” ");
INSERT INTO bjz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aghá ririeta, Iesu kaverea Pita du ririe, “Satan, amó doa serige! Amó mania buregata! Inda nundubari aná jo God davareta furambi re-tago, enembo davareta etie.” ");
INSERT INTO bjz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Anada ambova Iesu na unda ambo nimbidu eghá ririe, “Nímane avona anda ambo nimbi ea, namonde deĩ aita uno egegadora mo, nímanda uno dodogea, anda uno nuenembo egeguturota, anda ragarova amburaridu jo oru ambi egegaita rosoravore. Aghá egeguturota, namonde danode iru-furu egegaita rosore. ");
INSERT INTO bjz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Anada bee mo, imó avona endava gugua-ghayafa nundubuturota, amburaridu oru ea, andú goitu fotadora, fefera ambova imó amburaita roravore. O imó avona andú amburadora mo, fefera ambova jebuga tumanadu irari baita roravore. ");
INSERT INTO bjz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Avotago embó eini endada gugua-ghayafadu neno rururota, dano righia jiriturota, jebuga tumanadu irarida emboro kasovigea amburadua mo, gigige! Unda gugua-ghayafami jo sonembota, jebuga tumanadu irari jo bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Anada bee mo, Enemboda Jojabee* God Afada duroghade unda Afada anera manede dano kaverea furaita rouvie. Fefera aghade, umó enembo daba-dabada irarinu iruruturota, ari-bari taubanada mino taubananu ututurota, ari-bari akuagoda mino akuagonu utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Amó nímandu gaa bee rere. Enava enembo dumeni vitia, aná jo amburambi iririguturota, Enemboda Jojabee unda kini arida ano bua doa, furota gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Fefera ingo yoveni yoveniva dabako sidara uria-da ambova, Iesu erea, Pita bua, Jems unda ikoko Jon gha bua, nenukako dafaru yafabe einida itiva yayavuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Anava bubua, unda ambo nimbi gigigutueta, Iesu da dibe kaverea feferami janimbarigo urota, unda asugari dighari beago kaverea, saghai forosago ea, unanami janimbarigo urie. ");
INSERT INTO bjz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aghá ueta, unda ambo nimbi bakode gigigutueta, gaimbo ambi Moses ungá Elaija gha Jojabeeda kasava sirorea, Iesu de gaga regegutueta, ");
INSERT INTO bjz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita na erea, Iesu du eghá ririe, “Jojabee, namonde amó eve desea vitera, aná taubana re. Aghá-gea, imó uno adora, amó dobo bakode, eini indú, eini Moses du, kotú eini Elaija du aghá simbugaita rore.” ");
INSERT INTO bjz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita aghá ria, gooso unanaghami vorefuria, númane afureguturieta, gooso rova be fugia eghá ririe, “Ená anda neno bari Mendi re. Undú amó gangoro bee eta roreta, unda gaga donu radua-nu, niningige!” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Avore, Iesu da ambo nimbi aná be niningiguturia aghade, númane oru urota, kukurufa ea, dibe be dano endava tatakembeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aghá urieta, Iesu na furia, númanda tamova righia, “Ererege! Mania oru egegata!” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aghá ririeta, númane dibe jará ea gigiguturia, anava enembo eini tefo re. Tago, Iesu nuenembo gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Anada ambova, númane dafaru vareta vorefurota, Iesu númandu buregari gaga eghá ririe, “Nímane donu gigigetora, mania enembodu regegata! Do-gea, Enemboda Jojabee* amburarivareta jebugea erota, anada ambova regegadora, aná avore.” ");
INSERT INTO bjz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aghá ririeta, Iesu da ambo nimbimi undú uriga urie, “God Embó eini utota furaita rouvie. Tago, bee dodu Moses da Agho Dari irugari kakatomi* ‘Elaija sei furaita rouvie.’ regegeta rosu?” ");
INSERT INTO bjz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aghá regeguturieta, Iesu na mino ririe, “Aná gaa bee re. Elaija na sei furá, aná Embó God na utaita riria-da emboro simbugaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tago, amó nímandu eghá rere, Elaija umó seibe furie-tago, enembo umó jo tanana ambi-gea, númane undava donu aita uno uria aghagonu urota, mema ututurie. Kotú dabako aghagonu Enemboda Jojabeedava beago númanena mema utaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aghá rieta, unda ambo nimbi tanana egeguturie, Iesu umó Jon Bafutaito ari katonu nundubuturota ririe. ");
INSERT INTO bjz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Avore, númane aria, aná natofo desea vitiria-va bububuguturieta, embó einimi furia, Iesu da dibe kena koubumi jengirea eghá ririe, “Jojabee, anda mendidu neno mema ea sonembadi rere! Unda nundubari kasovigeaveta umó jifeta rouvie, kotú mema jojabe itatama eta rouvie. Umó fefera oruabe ivariva juta rouvie, o uvuva juta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amindu umó inda ambo nimbidava bua futare-tago, númanena rata umó jebugari jo inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aghá ririeta, Iesu na mino ririe, “O yove, nímane oreki vitera enembo, aná gaa ningambi deriva egegeta rosoravore. Nímandava gaabee ari tefo re. Amó fefera yafa daiyaghago namonde irirota, nímanda mema bouvu fumba? Avoreta, aná mendi bua, andava fu!” ");
INSERT INTO bjz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aghá rea, taimu aná mendidava asugea vitiria-nu Jojabee na dibe beva rirota tuviturieta buburitueta, jo gaimbo ambi aná mendi jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Anada ambova, Iesu da ambo nimbimi nenuka furia, undú uriga eghá egeguturie, “Námane tuvetora, daiyagha taimu vorambi etu?” ");
INSERT INTO bjz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Aghá regeguturieta, Iesu na mino eghá ririe, “Anada bee mo, nímanda gaabee ari aná bee tefo aghago re. Amó nímandu gaa bee rere. Nímanda gaa bee ari ijokoko, ika ragaro maineda veego iradua mo, nímane aná dafarudu, ‘Enavareta gosá ea ii, onava jiradi,’ radora, aghago aita rouvie. Nímane donu aita nundubasira, aná bee sirorasue.” ");
INSERT INTO bjz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Anada ambova, Iesu da ambo nimbi bubua, Galili Frovensi anava danode desiturieta, Iesu na númandu eghá ririe, “Enemboda Jojabee* enembomi bua, gitofoda ingova utota, númanena umó dedegota ambua, fefera bakode sidara adua-da ambova, God na rata, umó rekago jebugea eraita rouvie,” aghá ririeta, unda ambo nimbi niningigea, neno mema jojabe itatama egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Anada ambova, Iesu unda ambo nimbide aria, Kaperneam buburituria aghade, aná tafaroro kamboda takesi bari kakatomi Pita dava uriga egeguturie, “Inda irugari kato, Tafaroro Kamboda* takesi ututa rouvia?” ");
INSERT INTO bjz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aghá ririeta, Pita na mino ririe. “Aĩ, ututa rouvie,” Aghá rea, Pita kaverea aria, kambo rova teterurieta, Jojabee na seibe jará urota, undava uriga urie, “Saimon, inda nundubari mo doro? Endava kini mane mino o takesi númanda sasingudava buta rousua, aĩ, defosi enembodava buta rousua? Rege, ningore!” ");
INSERT INTO bjz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aghá ririeta, Pita na mino ririe, “Defosi enembodava buta rousue,” ririeta, Iesu na ririe, “Amindu Kini da sasingudava jo bambi egegasue! ");
INSERT INTO bjz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tago, rourogo númane neno akuago auve-degea rereta, ii, saova monga fugea, uvu oka tutunova beradora-da beva, angá anda Tafaroro Kambo mino ari guri* tambaita roravoreta, bua ii, angá anda takesi mino adi!” ");
INSERT INTO bjz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Fefera aghade, Iesu da ambo nimbimi furia, undú uriga egeguturie, “God da kaifa eta rouvia natofoda* rova, beforo righari mo avona adu?” ");
INSERT INTO bjz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Uriga aghá egeguturia-du, Iesu na sasingu mane eininu ririeta furia, númanda rorova jiriturie. ");
INSERT INTO bjz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Urieta, umó eghá ririe, “Amó nímandu gaa bee rere. Nímane neno kaverea, sasingu manego ambi egegadora, nímane jo God da natofo kaifa ari kambesiva teterugambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kotú avona undufako itota vorea, ená sasingu maneda einigo adua, ambova umó God da natofoda rova beforo righari aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kotú enembo avona sasingu mane eghagodu anda ragarova orokaiva rirota, ghaito teno fugadua, aná andú aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Tago enembo avona amó gaa bee eta rousua sasingu maneda rorova eininu kuvirota, ari akuago adua, taubana mo, singoi jojabenu bua, unda ukova dighia fugasueta, uvu kafuruva degimbasue. ");
INSERT INTO bjz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Endava enembodava kuvia gari dibe eini be eini siroreaveta, mema kotú bouvu itatama eta rousua-du ‘Arii’ rere. Aná bouvugo bee re. Tago, aná kuvia gari rera-nu, avona bua furota, unda komana juradua mo, umó mema sembago itatama aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Atá, inda ekami o ingomi ata, imó ari akuago adora mo, tafugea fuge! Aghá ea, imó eka o ingo taukaka irogo ambua, jebuga tumanadu irari tambadora, aná taubana re. Atá, aghá ambi irogo, ari-bari akuagoda mino utari kambesiva ivari tumanadu reivia-va voradora, bouvude kotú mema jojabe itatama aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dabako aghagonu, inda dibemi ata, imó ari akuago adora mo, gunjia fuge! Aghá ea, imó dibe taukaka irogo ambua, jebuga tumanadu irari tambadora, aná taubana re. Atá, aghá ambi irogo, imó ambua, ivari reivia-va voradora, bouvude kotú mema jojabe itatama aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Amó nímandu eghá rere. Mania ená sasingu manedu injigha egegata! Anada bee mo, númanda anera uutuva fefera inono anda Afada dibe kena irita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Atá nímanda einimi oka sifi dano 100 kaifa rourota, dabako baghimbadua, umó daiyagha adu? Umó aná 99 kirisa rova doa, ya aná sifi dabako baghimbetua-nu tava aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Amó nímandu gaa bee rere. Aná sifi tambua, umó aná dabakodu gangoro jojabe aita rouvie. Atá, aná dumeni jo baghimbambi vitia-du gangoro jo aghá bee ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Emboro dabako aghagonu, inda Afa uutuva vitia-mi, sasingu eghago nímanda rorova jiria vitia-da eini ya baghimbauve-degea injigha rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Inda kaka o ikokomi ari akuago adua mo, inukako ii, ingá inda gorotova unda dinunu irugadi umó gae! Umó inda gaga ningadua mo, bego amboda irari rekago kaverea taubana aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Umó inda gaga ningambi adua mo, Agho Dari seiva reiria aghagonu ambo-ambo urota, imó ekaresiada* rova enembo dabako o ungagha bua, undava kaverea igige! Aná gaga rera-da bee aná evere: ‘Koto eta rosora feferava, enembo ungagha o bakodemi osagho fufirota, gaga dabako ananu regegadua, númanda gaganu gaabee egege!’ ");
INSERT INTO bjz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Umó númanda gaga ningambi adua mo, ekaresiadava regege! Ekaresiada gaga beago ningari injigha adua mo, nímanda gitofodu kotú takesi bari kakatodu injigha eta rosora aghagonu undú egege! ");
INSERT INTO bjz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Amó nímandu gaa bee rere. Nímane endava irirota, donu gagajegadora, Afa uutuva vitia beago, gajaita rouvie. Dabako aghagonu nímane endava irirota, donu vuregadora, Afa uutuva beago, vuregaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kotú gaga eini eghá rere, niningige! Imó inda komanagha nundubari dabako ea, eini-eini dodu benunu adora, anda Afa uutuva vitia-mi ingá indú aghagonu utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Anada bee mo, enembo ungagha o bakode anda ragarova danode desadua, amó namonde dano iraitare.” ");
INSERT INTO bjz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Anada ambova Pita furia, Iesu dava uriga urie, “Jojabee, rege ningore! Anda kaka o ikoko einimi fefera oruabe andava ari akuago adua mo, umó fefera 7 dano nundubea gia doara?” ");
INSERT INTO bjz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aghá ririeta, Iesu mino eghá ririe, “Tefo, jo fefera ingo yoveni yoveniva ungagha rambi aita rore, dara indava nanjigo adua, aghade nundubea gia doadi rere. ");
INSERT INTO bjz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Aghá rera-da bee mo, God unda natofo* daiyagha kaifa eta rouvia, aná eto-bato kini eini unda buro kakato undava guri benunu ea bubugetua aghago re. Fefera eini númanda guri bubugetua, nanjigo mino utasua-nu ningaita rea, ghogho retueta undava desetue. ");
INSERT INTO bjz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Buro tutuno ueta, sei kini dava guri* oruaruabe, jo irugari inono irambi-nu bua righia vita embó eininu kini da kaifa kakatomi bua etia, undava teteregetue. ");
INSERT INTO bjz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aná embó, kini da guri mino utari jo inono ambi etua-du, kini na, aná embóda dinunuda mino baita rea, unda kaifa kakatodu eghá retue, ‘Ená embó unda evetu, mendi sasingude, kotú unda gugua-ghayafade dano bua, enembo dumenidava ututuge, anda guri kaverea utota, bare!’ ");
INSERT INTO bjz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aghá retueta, aná embó kini da dibe kena koubomi jengirea ininigha benunu retue, ‘Durumugea, kaifa uu-gea, amó inda gurida mino dano utore.’ ");
INSERT INTO bjz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Aghá retua-du, kini undú neno mema ea, unda guri mino utari aná nundubea gia dotueta, umó iye. ");
INSERT INTO bjz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Umó iye, unda buro komana eini tambua, ukóva righia gitoro-gatoro urota, guri jo oruabe irambi sei undava bia-nu, utari-du retue. ");
INSERT INTO bjz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aghá retueta, unda buro komana unda dibe kena koubomi jengirea retue, ‘Durumugea, kaifa uu-gea, amó inda gurida mino utore.’ ");
INSERT INTO bjz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Aghá retue-tago, umó injigha ea, kini da mene-mene ari kakato retueta, unda buro komana bua iya diburava gajetue. Avore, unda buro komana diburava irirota, guri bia-da mino rekago kaverea utua doa bubasue. ");
INSERT INTO bjz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aghá etueta-gea, aná embóda buro kokomana dumeni mema urota, gajegha iya, kini dava bubua, donu siroretua dano isagha egegetue. ");
INSERT INTO bjz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aghá retueta, kini ningia, aná embó retueta etia terueta, undú eghá retue, ‘Imó embó akuago re. Inda dinunu anona nundubea-gea doari-du ininigha benunu utara-du, amó aghá utare. ");
INSERT INTO bjz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Amó indú neno mema etora aghagonu, imó inda buro komanadu aghá asiravore.’ ");
INSERT INTO bjz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kini neno akuago etue-gea, aná embó diburava irirota, dibura enembo gajari kakatomi tamo mema ututugota, aná embó, guri bia-da mino rekago dano kaverea utua doa bubari-du retue. ");
INSERT INTO bjz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Avore, nímane avona ikoko mendida ari-bari akokogo jo neno roomi nundubea gia doambi adora, anda Afa uutuva vitia-mi indú beago aghá aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu aná gaga rea sidara ea, Galili Frovensi doa aria, Judia Frovensi rova beina fefera vitari kena aria, uvu Jordan rekimbuturie. ");
INSERT INTO bjz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Anava, natofo jede unda ambova arieta, unona númanda rorova kae bua vitiria enembonu urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Moses da Agho Dari kaifa kakato* dumeni Iesu kuvia gaita rea furia, uriga eghá egeguturie, “Namonde anda Agho Darida gaga daiyagha reiri? Embó eini unda unomi nuyae doadua, aná avora? Rege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aghá ririeta, Iesu mino eghá ririe, “Ená gaga nímane irugambi-gea, reisi-rera? ‘… tutunova, God eini-eini ririeta siroruturia-mi, embó ea, kotú evetu urie.’ ");
INSERT INTO bjz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Avore, God embó ea, evetu uubu ea doa, eghá ririe, ‘Embó unda nue numamogha doa, ya evetugha takembea, ungá tamo dabako aita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aghá-gea, númane jo ungagha irambi re-tago dabako re. Amindu, God da bua danode takembuturia-nu, rourogo enembomi righia gategauve-degea rere.” ");
INSERT INTO bjz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aghá ririeta, Moses da Gaga kaifa kakatomi rekago undava uriga egeguturie, “Moses bee dodu, embó eini unda evetu doaita nundubadua mo, umó bee dodu unda evetu doaita rouvia-da ingiso gembua, evetudu utota bata-gea, ninengota yari-du riri?” ");
INSERT INTO bjz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aghá regeguturieta, Iesu na mino númandu eghá ririe, “Nímane iruguturota gigigea tanana ari aná fakara-gea, Moses nímanda evevetu dodogadi rea, avore ari ututurie. Tago, God uutu enda, kotú embó evetugha uubu uria aghade, embó unda evetu doari-du avore ari jo utambi re. ");
INSERT INTO bjz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kotú amó nímandu eghá rere. Embó avona unda evetu komanada embógha viro kombo ambi irirota, dinunu dumenidu rea, umó doa, evetu eini yagera adua, umó God da dibeva komana einida evetugha viro kombo kasava ari aghago aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aghá ririeta, unda ambo nimbimi regeguturie, “Avore, evetu embóghada irarinu nundubuturota, ininigha námandu dibe beva rera-du, taubana mo, námane evevetu yagera egegambi aitare.” ");
INSERT INTO bjz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aghá regeguturieta, Iesu mino eghá ririe “Enembo dano jo anda retora gaga ningia egegari inono irambi re. Tago, God na avodu aghá arida ano utadua-mi egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Embobo evevetu yagera ambi eta rousua-da bee jo dabako irambi re. Dumeni mo, eero siroruturie, dumeni enemboda rarimi eaveta, aghá ea irita rousue. Kotú dumeni mo, God da burodu kotú unda natofo sonembaita rea, evevetu jo yagera ambi egegeta rousue. Embó aghá ari inono iradua, aghá ari-du rere.” ");
INSERT INTO bjz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Enembo dumeni, Iesu na ingo númanda sasinguda tamova isambara urota ea simbugea, benunu ari-du rea, númanda sasingu mane bua, Iesu dava fufuguturieta, unda ambo nimbimi, aná sasingu bua fufuguturia enembodu gaa dibe beva regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tago, Iesu na eghá ririe, “Sasingu mane mania buregata! Do-gea, andava fufugoe! Anada bee mo, avona neno kaverea, ená sasingu manego adua, númane God unda natofo* kaifa ariva teterugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aghá rea, Iesu aná sasingu mane ingomi tamova righia ea simbugea doa, umó anavareta erea arie. ");
INSERT INTO bjz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Avore, embó eini Iesu dava furia, uriga urie, “Irugari, imó embó taubana re. Amó ari-bari daiyagha ara-gea, tumanadu irarida jebuga ba?” ");
INSERT INTO bjz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aghá ririeta, Iesu undú mino eghá ririe, “Imó dodu andú taubanada beedu uriga eto? God Afa unuka taubana re. Atá, imó jebuga tumanadu irari baita uno adora mo, God da Agho Dari nanjogo vitia-nu ambo-ambo ege!” ");
INSERT INTO bjz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Aghá ririeta, aná embómi rekago uriga urie, “Agho Dari niana manenu ambo a?” ririeta Iesu mino ririe, “Mania enembo eini data amburauveta! Mania komana einida evetu o embógha viro kombo ata! Mania bagia ata! Mania enembo einida ragarova gaverami rirota, itia bera-bera ata! Nie nimamoghadu sabua* urota, númanda gaga ningia ambo-ambo ege! Imó indufa neno rei-rurora aghagonu, inda komana beago neno bu!” ");
INSERT INTO bjz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aghá ririeta, aná embó eghá ririe, “Aná dano kaifa eta rore. Kotú anada kasava amó rekago donu a?” ");
INSERT INTO bjz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aghá ririeta, Iesu undú mino ririe, “Imó embó taubana ea, jebuga tambaita uno adora mo, ii, inda gugua-ghayafa dano bua utua, guri bua makasi enembodu vesa adi! Aghá ea, imó fu, anda ambo-ambo adi! Aghá adora mo, fefera ambova inda gugua-ghayafa uutuva baita roravore.” ");
INSERT INTO bjz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aná embó Iesu da gaga ningia, unda gugua-ghayafa oruaruabe-gea, umó neno memagha dano kaverea arie. ");
INSERT INTO bjz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Anada ambova, Iesu na unda ambo nimbidu ririe, “Amó nímandu gaa bee rere: gugua-ghayafade enembomi God Afada natofo* terari, aná fakarago bee re. ");
INSERT INTO bjz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gaga dabako ananu amó rekago rere. Oka kamero nu nundubea gigige! Umó ninongu tova jo terua ya, yoveniva bubambi aita rouvie. Atá, umó avo terari aná rauko bee re. Tago, enembo gugua-ghayafademi God da natofo ari aná fakara bee re.” ");
INSERT INTO bjz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesu da ambo nimbi aghá ningia, númane bee duduku-dadaka egegea, uriga egeguturie, “Atá, aghá radora mo, jebuga avona badu?” ");
INSERT INTO bjz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu númane tatasegea gerurota, eghá ririe, “Enembomi ari jo inono irambi re-tago, God mo, eini-eini nanjogo ari inono bee re.” ");
INSERT INTO bjz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aghá ningia, Pita undú ririe, “Námanda eini-eini dano ambomi utua doa, inda ambo tuvia fufugutare. Amindu námane donu bubuga?” ");
INSERT INTO bjz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aghá ririeta, Iesu númandu ririe, “Amó gaa bee rere: uutu enda reka siroraita rouvia-va Enemboda Jojabee* unda avo asumbari duroghadeva asumbaita rouvia feferava, nímane 12 anda ambo-ambo rosora enembo beago, kotofuda avo asusumbariva asumbea, Israel enemboda abua dano 12 nu iruruturota, kaifa egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kotú enembo avona andú rea, númanda kambo o ikoko mendi o ariri gharovu o nue numamo o sasingu mane o aayo mane dodogadua mo, aghagonu rekago oruaruabe sirorota bua, jebuga tumanadu irari beago, bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tago, oreki kofiri rousua enembo oruabe kaverea furá, ambo egeguturota, ambova reisi-fua enembo oruabe furá ya kofiri egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Anada bee mo, God unda natofo* kaifa eta rouvia, aná eghá re. Enda numamo einimi rifogha erea, buro kakato dumeni mino ata, unda vaini ghavesi govetua aayova buro egegari-du rea, iye. ");
INSERT INTO bjz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Umó, númane aná onembo dabako buro ea buta uria guri* aghagonu mino aita rea, aná buro kakato ninengetueta, unda vaini aayova igigetue. ");
INSERT INTO bjz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Anada ambova, fefera vitia 9 koroki ueta, aayo númamo erea iya, utua bari kambesiva bubia mo, buro kakato dumeni buro ambi tefo jijiregea iririgutueta gie. ");
INSERT INTO bjz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gia, númandu eghá retue, ‘Nímane beago, igige, anda vaini aayova buro egegadi-gea, amó nímanda buro egegaita rora-nu gerurota, mino aghagonu utore!’ ");
INSERT INTO bjz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aghá retueta, aná buro kakato igigetueta, umó onembo 12 koroki ueta, kotú jama 3 koroki ueta, dabako aghagonu etue. ");
INSERT INTO bjz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Fefera 5 koroki ua, aná aayo numamo rekago iya, utua bari kambesiva buro kakato dumeni buro ambi tefo jijiregea iririgutueta gie. Gia, númandu uriga etue, ‘Nímane dodu buro egegambi ená onemboda yafa tefo jijiregea vite?’ ");
INSERT INTO bjz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aghá retueta, númane mino retue, ‘Anada bee mo, enembo avona námane buro ari-du jo mino ambi re.’ Aghá regegetua-du, unona númane beago ya, unda vaini aayova buro egegari-du retue. ");
INSERT INTO bjz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jama etueta, aná aayo númamo unda buroda beforo righari katodu retue, ‘Rege, aná buro kakato furota, númanda guri utadi! Fufugadua mo, buro kakato ambova bera-dava tutuno ea mino ututa ii, tutunova bera-dava sidara adi!’ retueta, aghagonu etue. ");
INSERT INTO bjz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Avore, enembo rifo 5 koroki ueta, buro tutuno etua dano inonova, onembo dabako buro arida gurinu bubugetue. ");
INSERT INTO bjz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aghá etueta, enembo avona sei rifogha tutuno ea buro egegetua, númane mino jojabe baita rousua aghago nundubetue-tago, númane beago dabako aghago bubugetue. ");
INSERT INTO bjz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aghá bubugetue-gea, aná sei rifogha tutuno ea, buro etua enembomi, tutuno ea, aná aayo numamodava yove gaje rirota, mendó gaa eghá regegetue, ");
INSERT INTO bjz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Embobo dumeni fefera tufoko bee buro egegetue. Námane oreki fefera vevera akuagoda rova onembo dabako buro bouvu bee egegetore. Tago, imó númandu guri námandu utora dabako aghagonu utoravore!’ ");
INSERT INTO bjz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aghá retueta, aayo numamomi númanda einidu eghá retue, ‘Anda komana, amó jo imó kuvirambi re. Imó onembo dabako buro adi-gea, guri onembo dabakoda mino aita retora mo, imó “avore” retoravore. Amindu aghá etore. ");
INSERT INTO bjz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Amó barirari re, kotú guri anda tofo-gea, amó donu nundubadora, aghagonu aita rore. Anda uno, enembo avona ambova buro etua-dava guri nímandu utora dabako aghagonu utaita rere. Aghajora, amó kauta kavevera etora-du, imó inda kokomanadu jii dimbera-jogo, gi! Avota inda guri bua ii!’” ");
INSERT INTO bjz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesu unda gaga ambo gajari eghá ririe, “Amindu, ambova reifia enembo ya kofiri urota-gea, oreki kofiri-kofiri rousua enembo kaverea furá, ambo aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Avore, Iesu erea, Jerusalem bogu naava yavurota aghade, unda ambo nimbi 12 nuenembo bua, airo jiria númandu eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ninigige! Namonde amó Jerusalem reisi-vitifore. Yavua bubadora mo, Enembo da Jojabee dubo ata, fristida* kokotofude kotú Moses da Gaga Irugari kakatodemi* umonu bua, data amburari-du regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aghá ea, namonde amó Jiusi enemboda gitofoda ingova utota, umonu kavaga urota, gegha regeguturota fisurea, bua ya, ifatarava dedegota amburaita rouvie. Tago, fefera bakodeda ambova, umó rekago amburarivareta jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Anada ambova, Sebedi da evetu unda sasingu ungaghade furia, Iesu dava bubua, unda dibe kena tumogha baĩ urota, unda uno uria-nu Iesu dava benunu urie. ");
INSERT INTO bjz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aghá ririeta, Iesu na “Inda uno doro?” ririeta, aná evetu eghá ririe, “Andava bee gajadi rere. Inda kini da ano badora aghade, rege, anda sasingu ungagha, eini inda ingo bee kena eini anda kena asusumboe!” ");
INSERT INTO bjz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aghá ririeta, Iesu mino aná evetu unda sasingudedu eghá ririe, “Nímane bee dodu benunu rosora, jo gerurota rambi rosoravore. Afana aagha andú utota bua dirota, mema itatama aita rora, aghagonu nímane itatama ari inono ra?” ririeta, “Námane inono re,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aghá regeguturieta, Iesu mino eghá ririe, “Avore, nímane anda undaita rora aaghava undaita rosoravore-tago, anda ingo bee kena kotú anda kena asumbaita rousua enembo, anona gategari jo inono irambi re. Anda ingo bee kena o anda kena avona asumbaita rousua, aná Afa na undufa simbugea gategota asusumbaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aghá ririeta, Iesu da ambo nimbi dano ingo ungaghami aná bego ambo ghada gaga regeguturia-nu niningigea, neno akuago egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aghá uria-du Iesu na, aná enembo furari-du ririeta furia, undava danode desuturieta, eghá ririe, “Nímane reisi-geroravore, endava abua-abuada kokotofu númanda uno nuenembo egegeta rousue. Númanda tuva vitia enembodava ano tefo re. Númane aná kokotofu rera-da rari ningari re. ");
INSERT INTO bjz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Avotago nímanda rorova jo aghagonu egegambi aita rosoravore. Avona nímanda barirari jojabe aita uno adua mo, umó enembo nanjogoda sabua* aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kotú, enembo avona kofiri righaita uno adua mo, umó nímanda rorova enembodu sabua aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Enemboda Jojabee* aghá urota, enembo nanjogodu sabua ea vitie. Enembomi undú ara-kera ari-du jo furambi re. Unda jebuganu ututurota, enembo nanjogo sonembota, jebuga bubugari-du rea furie.” ");
INSERT INTO bjz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aghá riria-da ambova, Iesu unda ambo nimbide erea, bogu naa ragaro Jeriko doa irueta, natofo jede erea, númanda ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Avore, Iesu aria serigutueta ningia, embobo ungagha dibe soikide mane emboro kasava asumbea vitiria-mi be jojabe koko fugia eghá ririe, “Jojabee, Devit da Mendi, námandu neno mema ea, sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aghá regegutua, aná natofo jede Iesu da ambova aria-mi kaverea, númandu gaa ininigha rea, be doari-du regeguturie-tago, ungá rekago be jojabe koko fugia regeguturie, “Jojabee, Devit da Mendi, námandu neno mema ea, sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aghá regeguturieta, Iesu ningia, tukú ea jiria, númane ghogho ririeta fufuguturieta, númandu uriga urie, “Amó ingá indú donu ari-du uno roso?” ");
INSERT INTO bjz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aghá ririeta, ungá eghá regeguturie, “Jojabee, námane sonembe, dibe ifegota, unana gigigore!” ");
INSERT INTO bjz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aghá regeguturieta, Iesu ungá undú neno mema ea, unda ingomi ungá unda dibeva ririkurieta, jo gaimbo ambi, ungá unda dibe ifefegeguturieta, unana gigiguturota, ungá erea, Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aghá urieta, Iesu unda ambo nimbide furia, bogu naa Jerusalem bubaita igiguturota, naa ijoko eini Betfeij ooto ragaro Olivi vitia anava bubua, unda ambo nimbi ungagha sei ninenguturota, ");
INSERT INTO bjz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","eghá ririe, “Igige, naa eini nímanda dibe kena vitia anava teteruguturota, donki tovea unda mendigha buri ari vitia-nu tambaita rosoravore. Ananu vuregea bua, andava fufuge! ");
INSERT INTO bjz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Atá enembo avona, daiyagha radua mo, undú eghá regege, ‘Jojabee na uno etue.’ aghá radi ningadua mo, gaimbo ambi doata, bua fufugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iesu aghá uria-da bee mo, feroveta einida riria gaganu furá gaa bee ari-du rirota, aghá uria, aná evere: ");
INSERT INTO bjz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion* ootova vitia enembodu eghá radi rere, ‘Nímanda kini oka donki da mendida etova durumugea asumbea, nímandava reifie.’” ");
INSERT INTO bjz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aghá ririeta, Iesu da ambo nimbi aria, unda ungá undú daiyagha isuri uria aghagonu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aghá ea, aná oka donki mendigha bua kaverea furia, númanda etova asugari anada etova beisi urieta, Iesu vitia asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iesu aná oka donki etova asumbea furueta, enembo oruaruabe númanda etova asugari mane kosugea, emborova beisi egegutueta, enembo dumeni aria, ika igi manenu didivegea bua, emborova beisi egegutueta, ");
INSERT INTO bjz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","aná enembo oruaruabe Iesu da dibe kena kotú ambo kena jiria igiguturota, areguturota eghá regeguturie, “Orokaiva! Devit da Mendidu raga regegore! Umó avona Jojabeeda ragarova bubua reifia-du, raga regegore! God du raga regegore! Orokaiva!” ");
INSERT INTO bjz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aghade, Iesu umó Jerusalem bogu naava teterueta, naa duduna egegutueta anava desuturia enembomi eghá regeguturie, “Ená avouvi?” ");
INSERT INTO bjz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aghá regeguturieta, aná aregututa igiguturia enembomi mino eghá regeguturie, “Galili Frovensiva naa Nasaret reta reifia feroveta eini, ragaro Iesu, umó re,” aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu aria, Tafaroro Ari Kamboda* ghouka rova terua, anava vesa dungarida dii oka utua guri buta rousuria enembo tuviturota, guri yayo ari enemboda farode guridenu bua righia saveregea, dii uku utua, guri reisi-rururia enemboda asumbari beago righia savereguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aghá ea númandu eghá ririe, “God da Gaga bukava eghá gembari vitie, ‘Anda Kambo aná benunu ari kambo re. Tago, nímanena egegetueta, anda Kambo aná bagia enemboda nungegi ari kambo aghago ea vitie.’” ");
INSERT INTO bjz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Anada ambova, enembo dibe soikide, kotú eka ingo takembari manedemi furia, Tafaroro Ari Kambo rova Iesu dava desiturieta, unona númane urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Avore, Iesu na Tafaroro Ari Kambo rova ivata anogha uria-nu gerurota, kotú sasingu mane gangoro egegea, Iesu du, “Devit da Mendi du raga regegore!” regegutueta niningigea, fristi* maneda kokotofu, kotú Moses da Agho Dari Irugari kakato* dano neno akokogo egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aghá egegea, Iesu dava uriga egeguturie, “Ená sasingu maneda reisi-ria gaga, imó rei-niningora?” Aghá regeguturieta, umó mino eghá ririe, “Rei-niningore-tago, God da Gaga eghá gefiria mo, nímane jo irugambi ra? ‘Imó sasingu mane kotú soká mane indú emboro taubanava raga regegari-du simbugutureravore.’” ");
INSERT INTO bjz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aghá rea, umó aná enembo avo doa erea bubua, Betani naava evaita arie. ");
INSERT INTO bjz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rifogha Iesu kaverea, Jerusalem bogu naava irurota, baimana itatama urie. ");
INSERT INTO bjz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aghá urota, ika simbia avo emboro kasava jiria irieta gia vorea aria iruruturia mo, bee eini tefo, igi nuenembo irieta gerurie. Amindu aná ikadu eghá ririe, “Imó rekago bee eini jo ambi aita roravore.” Aghá ririeta, aná ika gaimbo ambi gharasa urie. ");
INSERT INTO bjz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aghá ueta, unda ambo nimbi gigigea, bee duduku-dadaka egegea, eghá regeguturie, “Daiyagha aná ika simbia mo, tutomi gharasa etu?” ");
INSERT INTO bjz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aghá regeguturieta, Iesu mino eghá ririe, “Anona nímandu isagha rore: gaabee urota, mana-mana egegambi adora, nímane anda oreki ená ika simbiadu etora aghagonu egegaita rosoravore. Kotú ená nuenembo irambi re. Nímane ená dafarudu eghá regegasira, ‘Sofú ea vorii, karajeva juradi!’ regegasira, aghá asue. ");
INSERT INTO bjz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nímane gaabee egeguturota, dodu benunu egegadora, aná utota bubugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu aria, Tafaroro Ari Kambo* rova terua, enembo irugutua aghade, fristi* maneda kokotofude, kotú Jiusi enemboda babarigaridemi Iesu dava furia, uriga egeguturie, “Avona retueta, imó ená buro ro? Kotú avoda ragarova imó ená buro eta ro?” ");
INSERT INTO bjz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Amó beago nímandu uriga eini aitare. Anda urigada mino regegadora mo, amó avona ririeta, ená buro rora-nu rata niningigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Avota, regege, ningore, Jon Bafutaito Ari Katoda bafutaito arida ano God dava rururia aĩ, endava enembodava rururia, aĩ, avodava rururia-nu regege, ningore!” Iesu aghá ririeta, númane nenukako mino-mino rea niningiguturie, “Namonde ‘God dava’ regegadora, umó eghá raita rouvie, ‘Atá, dodu Jon gaabee egegambi roso?’ ");
INSERT INTO bjz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kotú, namonde amó ‘Endava enembo dava’ regegadora mo, namonde amó aná enembodu oru rosore. Anada bee mo, númane dano, Jon aná feroveta eini gaa regegeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Amindu, númane mana-mana ea, mino eghá regeguturie, “Námane jo tanana irambi re.” Aghá regeguturieta, Iesu na mino eghá ririe, “Nímane aghá regegetora-du, amó avona ririeta, ená buro rora, jo rata nímane niningigambi aita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Atá, ená gaga nundubea gigige! Embó eini unda sasingu ungagha re. Umó sei iya, unda mendi begodu eghá retue, ‘Anda mendi, oreki imó ii, vaini aayova buro adi!’ ");
INSERT INTO bjz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tago, umó sei injigha urota, ‘Amó jo yambi aitare’ retue-tago, ambova umó neno kaverea iye. ");
INSERT INTO bjz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kotú aná embó iya, gaga dabako aghagonu mendi ambodava retueta, mino, ‘Avore, amó aitare,’ retue-tago, umó jo ya buro ambi re. ");
INSERT INTO bjz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Atá, sasingu nianami numamoda uno ambo etu? Regege, ningore!” ririeta, númane, “Aná mendi begomi etue,” regeguturie. Aghá ningia, Iesu númandu eghá ririe, “Amó nímandu gaa bee rere. Takesi bari kakato, kotú evevetu emborova viro urota jijiregari manemi nímane serigea, sei God unda natofo* kaifa eta rouvia-va teraita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Anada bee mo, Jon Bafutaito Ari Kato seibe furia, nímandu ari-bari taubanada emboro iruguturie-tago, nímane umó jo gaabee egegambi re. Tago, takesi bari kakato, kotú evevetu emborova viro urota jijiregari manemi Jon da gaga ambo-ambo egeguturie. Nímane aná gigigutureravore-tago, nímane jo neno kaverea, umó gaabee egegambi ureravore. ");
INSERT INTO bjz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kasia gaga eini raita roreta, niningege! Aayo numamo eini unda endava vaini da ghavesi govea, kara ea ovenembea, vaini bee simbia muu barida oruko simbugea, vaini kaifa ari kakatoda ghagha yafabe eini itia, guri utota baita rea, aná kaifa kakatoda ingova utue. Aghá ea, aná embó erea, roo enda einiva iya asumbetue. ");
INSERT INTO bjz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aná ghavesida vuvuri rugari-da fefera bubieta, aná aayo numamo unda boanda bua furari-du rea, unda sabua* kakato ninengetueta igigetue. ");
INSERT INTO bjz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Iya bububugetueta, aná aayo kaifa kakatomi aayo numamoda sabua kakato nandia, eini dea babaregetue, eini dedegetueta ambue, kotú eini singoimi dedegetue. ");
INSERT INTO bjz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Avore, ambova aná aayo tofo erea, unda sabua kakato itoko oruabe ninengetueta iya bububugetua mo, aná aayo kaifa kakato erea, ari dabako aghagonu egegetue. ");
INSERT INTO bjz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Bee ambova aná embó unda mendimi yari-du rea, ninenguturota eghá nundubetue, ‘Oreki, anda mendimi yaita rouvia-du verua egegadua-jogo.’ ");
INSERT INTO bjz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tago, aná aayo kaifa kakatomi aná embóda mendinu gia, mino-mino eghá regegetue, ‘Oná gimasa aná aayo tofoda mendi enanu etia bubie. Egege, namonde umó dedegota amburota, numamoda eini-eini namonde amó tofo egegore!’ ");
INSERT INTO bjz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aghá regegea, númane aná mendi nandia bua, aayo isaghava fugetueta bubieta dedegetueta ambue. ");
INSERT INTO bjz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Atá nundubea gigige! Aná aayo númamo furadua mo, aná aayo kaifa kakatodu daiyagha adu?” ");
INSERT INTO bjz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aghá ririeta, anava desituria enembo mino eghá regeguturie, “Avore, umó aná aayo kaifa kakato akokogonu data ambubugaita rousue. Anada ambova, unda aayo bua, vaini da bee siroraita rouvia feferava, unda boanda bua kaverea ututugota, umó baita rouvia enembodava utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aghá regeguturieta, Iesu mino eghá ririe, “God da Gaga eghá gefiria mo, nímane jo irugambi ra? ‘Singoi eini kambo itari kakatomi injigha ea doa fugituria-nu Jojabee na bua, unda kambo roro tutumbudu itia simbuguturie. Ená Jojabeeda ari re. Unona ea davirea deghasembuturieta, namonde amó gia duduku-dadaka eta rosore.’ ");
INSERT INTO bjz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aghá-gea, nímandu eghá rere: ambova God da natofo* jo nímane kaifa ambi egegaita rosoravore, kotú nímane jo unda natofoda rova terambi egegaita rosoravore. God na unda uno eta rouvia enembonu gateguturota, númanena unda natofo kaifa egagari-du raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Atá enembo avona aná singoi etova juradua, dea bebejegea, ito-fakono aita rouvie. Avotago, aná singoimi avoda etova juradua, umó fatia betota enda nindaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aghá ririeta niningigea, fristi* maneda kokotofu, kotú Moses da Gaga Kaifa kakatode* tanana egeguturia mo, Iesu númane nundubuturota, aná kasia ririe. ");
INSERT INTO bjz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ananu tanana ea, númane neno akuago egeguturie-gea, Iesu nandia bundaita rea, emboro tava egeguturie-tago, enembo oruaruabe umó aná feroveta gaa regegutua-du, oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu tutuno ea, rekago númandu kasia gaa dumeni rirota, eini eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Enembo God unda natofo* kaifa eta rouvia-va terari, aná eghá re. Kini eini unda mendida evetu yagera arida banau simbugetue. ");
INSERT INTO bjz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Aghá ea, unda banauva furari-du aghi jufiria enembonu rata fufugari-du rea, unda sabua* kakato ninengetueta igigetue. Tago, aná enembo furari injigha egegetue. ");
INSERT INTO bjz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Etua-du, unda sabua kakato dumeni ninenguturota, eghá retue, ‘Númane avona fufugari-du aghi jumbera enembodu, eghá regege, “Amó anda banau simbugetore. Anda oka burumakau anamaka kotú memendi korodugo mane dea burea, eini-eini dano simbugea, sidara etore-gea, yagera ari banauva fufugari-du rere!” ’ ");
INSERT INTO bjz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tago, fufugari-du retua enembo, númane gaa ningambi númanda uno burova seserigetue. Eini aayova iyeta, eini unda gugua-ghayafami guri ata sirorari-du iye. ");
INSERT INTO bjz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aghá egegetueta, dumenimi erea, unda sabua kakato nandia, númandu mema ututuguturota, dedegetueta, ambubugetue. ");
INSERT INTO bjz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Aghá egegetua-du, kini neno bee sembago etue-gea, unda mene-mene ari kakato ninengetueta iya, unda sabua kakato dedegetueta ambubugetua enembonu, detueta ambubugetueta, númanda bogu naa dudungegetueta, evia sidara etue. ");
INSERT INTO bjz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Anada ambova, unda sabua kakatodu retue, ‘Yagera ari banau aná simbugetore. Tago, banauva fufugari-du retora enembo dano akokogo re. Eini jo furá anda banau undari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Amindu igige, emboro jojabeva desea irota enembo nanjogo gigigadora-nu, aghi egege, anda banauva fufugoe!’ ");
INSERT INTO bjz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aghá retua-du, unda buro kakato iya, emborova jijireguturota, númanda gigigetua enembo, taubanade akokogode dano bieta fufugetua-mi, aná yagera ari banauda kambo esega enembomi beda etue. ");
INSERT INTO bjz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aghade, aná kini unda esega enembo ghanena aita rea, etia terua gia tanana etua mo, anava embó eini etia, umó jo yagera ari banauva furarida asugarinu asugambi re. ");
INSERT INTO bjz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aghá gie-gea, undava uriga eghá etue, ‘Mambu, imó daiyagha banauva furarida asugarinu jo asugea, enava furambi eto?’ aghá retue-tago, umó gaga mino donu jo rambi re. ");
INSERT INTO bjz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aghade, Kini unda buro kakatodu retue, ‘Unda eka ingo bundia isaghava fufuge-gea, bingoiva vorea, memagha diitu kirisa-karasa urota, jii rirota iroe!’ ");
INSERT INTO bjz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Anada bee mo, God na enembo oruabe aghi eta rouvie. Tago, dabako ungagha aghago terari-du gategeta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aghá riria-du, Moses da Gaga Kaifa kakato* aria, danode desea, ya Iesu kuvirota, gaga sembago rasueta, umó bua koto arida emboro sirorasua-nu nundubuturota, manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Aghá rea, númanda ambo nimbi dumeni Herot da noni dumenide dano ninenguturieta aria, Iesu du eghá regeguturie, “Irugari kato, námane gigigeta rosore, imó embó taubana bee re. Aghá-gea, imó God da Gaga bee nuenembo irugea goghó eta roravore. Enembo, kokotofu ra, o makasi enembo ra, imó danode inonova buta roravore. ");
INSERT INTO bjz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Amindu, inda nundubari rege, niningigore, namonde anda Agho Darimi reiria mo, daiyagha egega? Namonde anda gitofo Rom enemboda kotofudu takesi mo utara, aĩ, doara? Rege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tago, umó kuvia gaita fufuguturia-nu tanana urie-gea, Iesu númandu eghá ririe, “Nímane aghagago egegeta rosora enembo re. Dodu amó rekukuve? ");
INSERT INTO bjz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takesi ututa rosora-da guri* eini bofu gare!” aghá ririeta, undú guri eini ututurie. ");
INSERT INTO bjz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ututurieta bua gerurota, uriga urie, “Ená guri tamova imumude ragarode avoda ro?” ");
INSERT INTO bjz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aghá ririeta, númane, “Rom enembo da Jojabee Sisar da re,” regeguturieta, umó númandu ririe, “Avorego, Sisar da tofo aná undú ututuge, bae! Kotú, God da tofo aná God du ututuge, bae!” ");
INSERT INTO bjz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aghá ririeta niningigea, númane bee duduku-dadaka egegea, umó doa igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Fefera dabako aghade, Jiusi enemboda dumeni Sadyusi* regegeta rousua-da rari mo, enembo amburarivareta jo jebugea erambi gaa regegeta rousue. Númanena furia, Iesu dava bubua, uriga egeguturie, ");
INSERT INTO bjz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Irugari kato, Moses namonde andú eghá ririe, ‘Embó eini evetu bua, mendi sasingu sirorambi irirota amburadua, unda jamena einimi unda dorunu foite ata, mendi sasingu siroradua mo, aná amburari embóda sasingu asue,’ aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Namonde kiki eini raita roreta, ningi! Sasingu vivide dano 7 sirorea vitirie. Anava begomi evetu bua vitirie-tago, mendi sasingu jo sirorambi doa ambubuturieta aná doru unda ikokomi foite urie. ");
INSERT INTO bjz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ari dabako aghago unda ambodava siroruturie. Aghago unda ambo einidava siroruturie. Kotú aghagonu sirorututa iya, mendi ambo jetukodava beago aghá siroruturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aghá ea sidara uria-da ambova, aná doru beago ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Avore, númane dano 7 aná evetu dabako ananu yagera egeguta-du, ambova jebugea erari feferava mo, umó avoda evetu adu?” ");
INSERT INTO bjz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aghá regeguturieta, Iesu mino eghá ririe, “Nímanda serigari gaa reisi-reravore. Aghá rera-da bee mo, God da Gaga gembari vitia-de God da anode nímane jo gigigambi viteravore. ");
INSERT INTO bjz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amburarivareta jebugea erari feferava, númane anera aghago ea irirota, jo vai ambi kotú yagera ambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tago, enembo amburarivareta jebugea erarida gaga, God unda bemi riria mo, nímane irugea gigigambi ra? ");
INSERT INTO bjz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Niabua mane, Abraham, Aisak kotú Jekop endava irirota, gaabee egegeta uria, kotú oreki gaabee eta rousua-da God, aná amó re.’ God aghá riria-du, namonde amó reisi-gerore, God jo amburari enemboda God irambi re. Reisi-gerore, amburari enembo, jo amburota sidara ambi vitie.” ");
INSERT INTO bjz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aghá ririeta niningigea, natofo jede Iesu da irugaridu bee duduku-dadaka egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu ririeta, Sadyusi* enembo gaa bee sidara uria-nu Moses da Gaga kaifa kakatomi* niningiguturie-gea furia, Iesu dava danode desituturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Númanda rorova Agho Dari irugari kato* einimi erea, Iesu kuvia gaita rea, uriga eini eghá urie, ");
INSERT INTO bjz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Irugari kato, God da Agho Dari rova agho dari jojabe mo, doro?” ");
INSERT INTO bjz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aghá ririeta, Iesu mino eghá ririe, “‘Inda Jojabee God nu, inda neno roode, inda asiside, kotú inda nundubaride dano neno bu!’ ");
INSERT INTO bjz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ená retora, aná Agho Dari bouvu bee kotú jojabe re. ");
INSERT INTO bjz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kotú anada tuva aghago eini evere. ‘Imó indufa neno rei-rurora aghagonu, inda komana beago neno bu!’ ");
INSERT INTO bjz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ená Agho Dari ungagha irugetora, aná Agho Dari nanjogo, kotú feroveta mane gaga nanjogo gefiria-da roro tutumbu re.” ");
INSERT INTO bjz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fefera aghade, Moses da Gaga kaifa kakato* jo tará egegambi danode desea irieta, Iesu númandu uriga urie, ");
INSERT INTO bjz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Regege, ningore, God na embó eini ninengota furari-du riria mo, avoda mendi ro?” aghá ririeta, númane, “Devit da Mendi re,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aghá regeguturieta, Iesu númandu eghá ririe, “Nímanda reisi-rera gaga, kotú Devit da undufa gefiria gaga, jo furá mendó dabako ambi vitie. God da Asisimi Devit sonembetueta, God da utaita rouvia Embónu gaabee urota, undú, ‘Umó anda Jojabee re,’ gefirie. Devit da gefiria gaga, aná evere: ");
INSERT INTO bjz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God, unona anda Jojabeedu ririe, “Fu anda ingo bee kena asumbadi-gea, anona inda gitofo dea bundia bua furá, inda eka tuva itota vavasigoe!” ’ ");
INSERT INTO bjz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Atá, Devit na undú ‘Jojabee’ radua mo, daiyagha umó mo, Devit da mendi gaa reisi-rere?” ");
INSERT INTO bjz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Aghá rea sidara uria-da ambova, enembo eini jo erea, unda gaga riria-da mino regegambi re. Kotú anada ambova enembo dano uriga eini undava ari oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Enembo natofo desuturia-de, kotú unda ambo nimbidedu eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Gaa bee, Moses da Gaga Irugari kakato, kotú unda Gaga kaifa kakato* númane Moses da ragarova unda God dava rururia Gaganu rea isuri egegari-du gateguturieta vitie. ");
INSERT INTO bjz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Amindu númane donu irugadua-nu, niningigea, ambo-ambo egege! Tago, númanda donu eta rousua aghagonu, mania egegata! Anada bee mo, númanda donu regegari aná jo ivatava itambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Númane bouvu jojabe enemboda ivisava itita rousue. Tago, númane jo itoko sonembuturota, aná bouvu fumbambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aghá urota, númane God da Gaga dumeni ingisova gembua, ingova kotú beforo taiva dighia deĩ eta rousue. Aghagonu númane eembo sori yafa beeva tureta rousue. Tago, númane jo God nundubuturota, aghá egegambi re. Enembomi númane gigigea, raga regegari-du rea, aghá egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Aghá urota, nghaĩ itari kambova*, kotú banau feferava enembomi kokotofu enemboda asumbari kambesi taubananu utota asumbaita uno egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aghagonu, utua bari kambesiva bubota, enembomi númandu ‘Irugari kato’ rirota, kakara urota, ari oro rea goghó egeguturota, ghanena ari-du uno egegeta rousue, kotú númandu ‘irugari kato’ rirota, ghanena egegasue. ");
INSERT INTO bjz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tago, enembo nímane ghanena urota, jo ‘irugari kato’ regegambi egegasue. Anada bee mo, nímanda irugari kato dabako re. Atá nímane dano bego ambo re. ");
INSERT INTO bjz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nímanda Afa dabako uutuva vitie. Amindu, mania endava enembo einidu ‘Afa’ regegata! ");
INSERT INTO bjz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kotú dabako aghago, enembo ghanena urota, jo ‘irugari kato’, regegambi asiravore. Anada bee mo, God embó eini gategea ninengota furari-du riria, nímanda irugari kato dabako, umó re. ");
INSERT INTO bjz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Atá, nímanda rorova avona jojabe vitia, umó undufa vorea nímanda sabua* aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ari dabako aghagonu, enembo avona undufako raga radua, ambova God na umó itota voraita rouvie. Atá, enembo avona durumuguturota undufa itota voradua, ambova God na umó righota eraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ariee, dara baita rosoravore! Nímane Moses da Gaga irugari kakato, kotú unda Gaga kaifa kakatodedu* eghá rere: nímane tefo aghagago eta rosora enembo re. Nímane nendufako God da natofo jo ambi viteravore. Kotú rourogo enembo dumenimi God da natofo* kaifa rouvia-va terauve-degea, nímane buregeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ariee, dara baita rosoravore! Moses da Gaga irugari kakato, kotú unda gaga kaifa kakatodedu eghá rere: nímane tefo aghagago eta rosora enembo re. Nímane enembo dabakoda neno righia kaverota, nímanenu ambo-ambo ari-du rea, ano faghighi egegeta rosoravore. Atá, enembo eini avona nímanda ambo-ambo adua, nímanena irugota, umó ya, ari akokogoda mino utari kambesiva terua, nímanda mema itatama egegaita rosora-da itiva, unona akuago bee itatama aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ariee, dara baita rosoravore! Nímane irugari kakato dibe soikide re. Nímane enembodu emboro irugari inono irambi re. Nímane eghá reta rosoravore. Enembo einimi Tafaroro Ari Kamboda* ragarova be gajari mo, aná bee tefo gaa reta rosoravore. Tago, enembo dabako unona Tafaroro Ari Kambo rova auri eini goldi reta rouvia-da ragarova be gajari mo, ‘Unda be gajetua jo ambi adua, umó bouvu baita rouvie!’ reta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nímane beforo dinunu, kotú dibe soikide re. Aná goldi Tafaroro Ari Kambo rova vitia, aná jo kakara irambi re. Tago, Tafaroro Ari Kambo aná kakara bee re. Aghá-gea, Tafaroro Ari Kambomi eaveta, aná auri goldi beago kakara aghago eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nímanda irugari sembago eini mo, eghá reta rosoravore. Enembo einimi Tafaroro Ari Kambova vitia vesa dungari faroda ragarova be gajari mo, aná ‘Bee tefo’ gaa regegeta rosoravore. Kotú, enembo dabako unona vesa faro etova dungeta rousua-da ragarova be gajari mo, ‘Unda be gajetua jo ambi adua, umó bouvu baita rouvie!’ reta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Amó rekago rere. Nímane enembo dibe soikide re. Aná vesa faro etova dungeta rousua, aná jo kakara irambi re. Tago faro, aná kakara bee re. Aghá-gea, vesa dungari faromi eaveta, aná vesa dungeta rousua, kakara aghago eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aghá-gea, enembo avona vesa dungari faroda ragarova be gajadua, umó aná faroda ragarova kotú eini-eini nanjogo aná faroda etova vitia-da ragarova be gajaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aghagonu, enembo eini avona God du Tafaroro Ari Kamboda ragarova be gajadua mo, umó aná Tafaroro Ari Kamboda ragarova, kotú God aná Kambo rova vitia-da ragarova be gajaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kotú ari dabako aghagonu, enembo eini avona uutuda ragarova be gajadua, umó avo asumbari uutuva vitia, kotú God aná avo asumbariva asumbea vitia-da ragarova beago, be gajaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ariee, dara baita rosoravore! Moses da Gaga irugari kakato, kotú unda Gaga kaifa kakatodedu eghá rere: nímane tefo aghagago eta rosora enembo re. Agho Dari reiria aghagonu urota, nímanda aayova vitia-da eini-eini ijoijokoko eto-bato ararugha, dorea, kotú bava aghagonu bua, dibe ingo ungagha itia, anada rova dabako God du ututa rosoravore. Aghá egegeta rosora, aná taubana re. Tago, Agho Darida gaga bouvu bee, jo ambo-ambo ambi egegeta rosoravore. Agho Dari bouvu bee rera mo, enembo nanjogodava vesa inonova ari, kokomanadu neno mema ea sonembari, kotú God da unonu egegari-du reirie. Eini-eini ijoijokoko eta rosoravore. Tago eini-eini jojabebei nímane jo ambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ariee, dara baita rosoravore! Nímane irugari kakato dibe soikide re. Nímane emboro enembodu irugari inono irambi re. Eini-eini ijoijokoko kaifa eta rosoravore. Tago, agho dari bouvube jo kaifa ambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ariee, dara baita rosoravore! Moses da Gaga irugari kakato, kotú unda Gaga kaifa kakatodedu eghá rere: nímane tefo aghagago eta rosora enembo re. Embó eini uvu undari aagha, kotú tevoda tamo isaghavanu seghea, rova jo seghambi eta rouvia aghago, nímanda neno roo daghari arimi kotú kokomanadava neno righambi bubugarimi beda ea vitie. ");
INSERT INTO bjz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Moses da Gaga kaifa kakato, nímane dibe soikide mane re. Sei uvu undari aagha, kotú tevoda roonu seseghege! Aghá egegadora-mi ata, eto tamo beago taubana aita rouvie! ");
INSERT INTO bjz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ariee, dara baita rosoravore! Moses da Gaga irugari kakato, kotú unda Gaga kaifa kakatodedu eghá rere: nímane tefo aghagago eta rosora enembo re. Nímane enembo itari uje segheaveta isaghava saghai eta rouvia, aghago re. Tago, rova amburari enemboda sirurumi beda ea iriaveta, andoro betea eini-eini dano masa eta rouvia, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ariee, dabako aghagonu, nímane gerurota, natofo jede nímane enembo taubana gaa regegeta rousue-tago, nímanda neno rova aná aghagago arimi, kotú ari akokogomi beda ea vitie. ");
INSERT INTO bjz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ariee, dara baita rosoravore! Moses da Gaga irugari kakato, kotú unda Gaga kaifa kakatodedu eghá rere: nímane tefo aghagago eta rosora enembo re. Feroveta mane nímanda mambube manemi dedeguturieta ambubuguturia-da uje mane nímanena itia simbugeta rosoravore, kotú dinunu tefo enemboda uje manenu nímanena simbugeaveta, gari taubana eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aghá egeguturera-da bee mo, nímane eghá reta rosoravore. ‘Namonde anda mambube mane vitiria fefera aghade iririgasira mo, númane feroveta mane dedegeaveta ambubugeta uria aghago, jo ambi egegasire.’ ");
INSERT INTO bjz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tago, nundubea gigige! Embó eini daiyagha nundubeta rouvia, unda imendi beago dabako aghago nundubeta rouvie. Nímane nendufa kukuviguturota viteravore. Nímane ferovetada uje itia simbuguturota reisi-irugutoravore, nimambube mane donu nundubeta egeguturia, kotú egegeta egeguturia, dabako aghagonu egegasiravore. Nimambube mane feroveta dedegeta uria-da imemendi bee, aná nímane re. ");
INSERT INTO bjz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Amindu, nimambube maneda donu egegeta uria, aghagonu egege, ya sidara ae! ");
INSERT INTO bjz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nímane enembo akokogo, angoghoda sasingu re. Nímane daiyagha ea, ari akokogoda mino utaita rouvia kambesi doa seserigado? Nímanena aná kambesi doa serigea yari itoko jo inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amindu, amó feroveta manede, enembo beforo gari kakatode, kotú irugari kakatode nímandava yari-du ninengaita rore. Dumeni nímanena nandia ifatarava dedegaita rosoravore. Dumeni emboro dumeniva dedegadi ambubugaita rousue. Kotú dumeni nandia, nghaĩ itari kambova fisuraita rosoravore, kotú dumeni tuvituradi-gea sumbua ya, naa einivareta furá, einivareta egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Aghá egeguturadi-gea, Abel embó taubana, dinunu tefo derurieta ambubuturia-vareta etia Berekia da mendi Sekaria Tafaroro Ari Kambo kotú vesa dungari faroda gorotova dedeguturieta ambubuturia-da gorotova fufuguturota, God da natofo dinunu tefo enembo nanjogo ená endava dedeguturieta ambubuturia-da mino nímane oreki sirorea vitera enembomi bubugaita rosoravore. Amó nímandu gaa bee rere, jo serigambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ariee, Jerusalem enembo, nímane feroveta mane dedegeaveta ambubugeta rousue. Kotú God na, nímane irugota, jebuga tumanadu irari tatambugadi rea, enembo ninengeaveta futa rousua-nu singoimi dedegeta rosoravore. Amó fefera oruabe nímanda sasingu bua, danode aita rea, eto-bato kokora nuemi memendi bua, fakina tuva danode ea kaifa eta rouvia aghagonu aita urere-tago, nímane injigha egegutureravore. ");
INSERT INTO bjz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Amindu nímanda Tafaroro Ari Kambo* doa serigota, abaya kambo aghago aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Atá, amó nímandu eghá rere: oreki reta yaita rouvia, nímane amó jo rekago gigigambi irogo, ambova amó kaverea fururota gigigea, eghá regegaita rosoravore, ‘Orokaiva orokaiva! Umó avona Jojabeeda ragarova bubua reifia-du, raga regegore!’” ");
INSERT INTO bjz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu erea, God du Tafaroro Ari Kambo* doa irueta, unda ambo nimbi furia, umó tambua, eghá regeguturie, “Ená kambo manenu gia, nundubadi reisi-rere!” ");
INSERT INTO bjz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aghá regeguturieta, umó eghá ririe, “Amó nímandu gaa beenu rere. Ená singoimi ari kambo nanjogo reisi-gerora, anada singoi mane eini jo unda irari kambesiva jirambi aita rouvie. Dano averegea unda unda vovoregaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Anada ambova Iesu ooto Olivi itiva asumbea irieta, unda ambo nimbi nenuka furia undava bubua, eghá regeguturie, “Námandu rege, niningigore! Aná rera mo, nanjigo siroradu? Ivata domi inda kaverea furari fefera, kotú uutu enda tano aita rouvia fefera, irugadu?” ");
INSERT INTO bjz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aghá regeguturieta, Iesu númandu mino eghá ririe, “Dibe be gerurota, kaifa egege, rorogo nímane kuvia gavera rata-gea, ananu gaa bee gaa regegareta! ");
INSERT INTO bjz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anada bee mo, enembo oruabe furá, anda ragarova gavera eghá raita rousue, ‘God na enemboda ari-bari akokogo nundubea gia doaita rea, embó eini utaita riria, aná amó re.’ aghá regeguturota, enembo oruabe dano númanda gaveranu, gaa bee gaa regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nímane, mene-mene utuvako urota, o airo bee urota, kinini gaa niningigaita rosoravore. Tago, rourogo eini-eini aghago manemi ata, inda neno jurauve-degea rere! Anada bee mo, eini-eini aghago mane siroraita rouvie-tago, uutu enda jo aghade tano ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Roo enda dumeni dumenida beforo ririkigari o kini mane ereregea, mino-mino mene-mene egegaita rousue. Aghade baimanade, kotú gino-ginode roo enda dumeniva siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tago, eini-eini donu siroraita rouvia-mi jo tano ambi aita rouvie. Aná mo, eto-bato evevetumi mendi sasingu fumbaita tutuno ea, mema itatama eta rousua, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Fefera aghade, amó gaabee eta rosora-du, abua-abua nanjogomi nímane injigha egeguturota, nímane nandia bundia bua ya, koto ea data amburaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Fefera aghade, amó gaabee rousua enembo oruabe neno kaverea, gaabee injigha urota, mino-mino ari-bari sembago egeguturota, kotú mino-mino injigha egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Feroveta gavera kakato oruabe furá, enembo oruabe kuviraita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aghade ari-bari sembago mane baria, jojabe ata-gea, enembo oruabeda neno bari ya, sidara aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tago, umó avona ano ea, God gaabee urota iradua, fefera banunava God na rata, umó jebugaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","God unda natofo* kaifa aita rouvia-da gaga taubananu minono rirota, ená endava enembo ningia, fafate adua-da ambova, uutu enda tano aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aghá rea, Iesu gaga eini feroveta Daniel riria-nu nundubuturota isuri urie. (Anada beenu irugea tanana egegadi rere, aná evere:) “Ambova eini-eini akuago bee eininu bua furá, God da Kambo roo kambesi kakarava itota jiria, anami bebeta urota gigigadora mo, ");
INSERT INTO bjz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nímane eve frovensi Judia rova vitera enembo oru sumbua igige, oná dafaruva nunungegadi! ");
INSERT INTO bjz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Atá embó avona unda kambo sebova asumbea irota, fefera bubadua, umó jo terua, unda eini-eini kambo rova bambi aita rouvie. Kotú, embó avona aayova buro urota gia, fefera bubadua, umó jo kaverea ya, kambova unda etova asugari eini jo bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Enembo avona unda aayova buro urota gadua, rourogo kaverea naava ya, unda asugari eini bauva-degea rere. ");
INSERT INTO bjz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Arii, amó evevetu tambouvude ea iraita rousua-du, kotú evevetu dumeni sasingu emi gaiturota iraita rousua-du, neno mema rore. Anada bee mo, fefera bubadua evevetu dumeni sasingu bua sumbari ata-bata urota, mema fakara bee itatama egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Inda oru sumbari feferava rourogo uria-gharo feferava kotú Nangu Undari Feferava sirorauve-degea rirota, God dava benunu egegadi rere! ");
INSERT INTO bjz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","God uutu enda uubu uria-vareta etia, oreki vitera-va mema itatama uta refere-tago, aná mema ijoko re. O fefera aghade mema itatama aita rosora, aná bee jojabe re. Anada ambova mema aghago eini rekago jo sirorambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aghá re-tago, fefera veveragha jo yafabe ambi aita rouvie. God da ririeta vitia, aná eghá re. Yafabe irasua mo, natofo eini jo irambi, dano manjasue. Avotago, God unda natofo gateguturia-du rirota, mema furaita rouvia, jo numbobe irambi aita rouvie, ririe. ");
INSERT INTO bjz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Fefera aghade enembo einimi indú gavera rirota, ‘God Embó eini utaita riria, aná evere!’ o ‘Umó overe.’ radua mo, mania umó gaabee ata! ");
INSERT INTO bjz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aghá rera-da bee mo, enembo dumeni furá gavera rirota, ‘Aná Embó God da utaita riria, aná amó re.’ aghá rirota, númane feroveta gavera kakatode dano furá, God da natofo beago kukuvirota, númanda gaveranu gaabee egegari-du rea bera-bera egegaita rousue. Kotú númanda gaga gaabee egegari-du rea, ivata anogha dibe eini be eini egegaita rousue-tago, God da gateguturia natofo jo kuvirota jurambi egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ená gagada bee jo sirorambi irieta, nímandu sei retueta niningigetoravore. Amindu nundubuturota, iririgadi rere! ");
INSERT INTO bjz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Atá gii! Enembo avona, ‘Aná Embó ika tefo uvu tefo kambesiva vitie.’ radua mo, mania avo igigata! Kotú enembomi, ‘Umó eve nungia vitie.’ radua, mania gaabee egegata! ");
INSERT INTO bjz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Anada bee mo, Enemboda Jojabee* jo kivumi furambi aita rouvie. Eto-bato uutuva kirivami fefera vitari kena reta jari ea, fefera vorari kena bubuta rouvia aghagonu, Enemboda Jojabee kaverea fururota, enembo dano gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Amburari eini-eini einida tamo niavo betea masa uradua, dii kasi mane avo danode egegaita rousue.” Iesu aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kotú Iesu eghá ririe, “Fefera aghade, dara retora sidara aita rouvia-da ambova, fefera gotea, bingoi ata, marabe beago gotea, bingoi aita rouvie. Kotú damana mane dorea vovorurota, uutuva eini-eini dano rarovaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Fefera aghade, Enemboda Jojabeeda* ivata uutuva isagha urota, umó anode durogha jojabede uutuva reta gooso etova vovorurota, endava abua-abua dano umó gigigea, jiiji regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aghá urota, tavuya furota, unda anera mane ninengota vorea ya, enda mendóvareta furá mendóva unda gateguturia enembonu bua danode egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Iesu aghá rirota, eghá ririe, “Do-gea, aná ika simbiami nímane irugoe! Ika simbiada fafatu boiri ea, igi fangadua mo, nímane tanana aita rosoravore, ‘Simbiada bee ari oya bubaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aghagonu, aná eini-eini retora-nu gigigadora mo, tanana egegadi rere, fefera utuvako etua-du, bee siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Amó nímandu gaa bee rere. Oreki rei-sirorutua enembo dano, jo ambua sidara ambi, dumeni irota, ená ivata retora, siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Uutude endade dano manjaita rouvie-tago, anda Gaga jo nanjigo aghade manjambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Enemboda Jojabee* fefera domi kaverea furá bubaita rouvia, endava enembo, o uutuva anera mane, kotú God da Mendi beago jo gambi re, God unuka rei-gerue. ");
INSERT INTO bjz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Eto-bato Noa da feferava ari-bari daiyagha siroruturia aghagonu, Enemboda Jojabeeda kaverea furaita rouvia feferava beago, aghá siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Uria bubambi-da dibe kenava enembo boro banau ueta, evevetu yagera ueta, kotú embobodava vai egegutueta, Noa unda ghava teterurie. ");
INSERT INTO bjz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Númane dibe kena donu siroraita rouvia jo gigigambi tamoda unonu gangorogha egegutueta, uria bubua númane bua sivia igigutueta, númane enembo dano uvu undia ambubuguturie. Enembo da Jojabee kaverea furaita rouvia feferava, aghagonu siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Aghade, embobo ungagha aayova iradua, embó eininu rururota, eini doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dabako aghagonu, evevetu ungagha aayova farava dasari katova reisi-dasiturota, eininu rururota, eini doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nímanda Jojabeeda furaita rouvia fefera, nímane jo gambi re. Amindu dibe emboro urota iririge! ");
INSERT INTO bjz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tago, enanu nundubea gigige! Bagia enembo tumba domi embó einida kambo bejaita rirasueta, kambo numamo tanana asua mo, rourogo unda kambo bejauve-degea, dibe emboro asue. ");
INSERT INTO bjz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Amindu rea, nímane beago fefera inono simbuguturota iririge! Anada bee mo, Enemboda Jojabeeda kaverea furaita rouvia fefera aná nímane jo tanana ambi irota, bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Buro kato umó avona gaabee aride kotú nundubari taubanade unda buro ea goghó adua, unda barirarimi rata, umó unda kokomanada rorova beforo righari ea, unona númandu undari unda oyava vesa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Aná buro kato, unda buro ea goghó urota, unda barirari kaverea furá gadua mo, aná buro kato umó taubana tambua, gangoro aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Amó nímandu gaa bee rere. Aná buro katoda barirarimi unda kambova gugua nanjogo utota, umó anada barirari ea, unona kaifa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Tago, aná buro kato embó akuago iradua mo, umó undufako eghá raita rouvie, ‘Anda barirari iya, unda kaverea furari fefera jo utuva ambi re.’ Aghá rea, unda buro kakato dumeni derurota, ya uvu fakara undari kakatode takembea, uumo urota, tutuno ea numonde uvu fakara dirota undari undidigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Umó aghá urota, unda barirari furaita rouvia-da fefera jo gambi kotú jo kaifa ambi irirota, unda barirari nenomi bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bubua, aghá gadua mo, aná buro kato tafugea, ito fakono ea aghagago eta rousua enembode dano fugota, númane anava memagha diitu yavi kirisi-karasa urota, jiiji regegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu rekago eghá ririe, “God fefera anava unda natofo* daiyagha kaifa aita rouvia-da kasia eini raita rore. Fefera eini gimasa eini unda datu ariri yagera aita rea, furueta, mosegamose dano ingo ungagha erea, númanda nanefa bua, aná embó tambua unumbea, banauva teraita rea, igigetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mosegamose dano ingo yoveni númane neno nundubaride re, atá ingo yoveni númane neno jo nundubambi egegetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aná neno nundubambi egegetua-mi, númanda nanefa bubugetue-tago, númanda nanefada uka muu sasaina jo bubugambi igigetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tago, mosegamose ingo yoveni númane neno nundubaride-gea, uka muu númanda kofiriva rurukea bua igigetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iya, aná evetu yagera aita rouvia gimasa jo unda feferava furambi irieta, kaifa rosago, dibe baĩ egegetua-gea, vasia evivigetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Evivigutueta, tumba rorova koko fugia, eghá retue, ‘Evetu yagera aita rouvia gimasa enanu bubieta! Erea, umó tambua unumbea fufuge!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aghá retueta, aná mosegamose dano ereregea, númanda nanefa jará ari-du rea, uiki righie. ");
INSERT INTO bjz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mosegamose ingo yoveni neno nundubambi egegetua-mi númanda kokomana ingo yoveni neno nundubea goghó egegetua-dava uka muudu benunu urota, eghá regegetue, ‘Námanda nanefa sona rouvieta, námandu uka muu dumeni bofu!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Númanda kokomana ingo yoveni neno nundubambi egegetua-da benunu ningia, mino eghá regegetue, ‘Tefo, ená uka muu namonde danode jijimu ari jo inono irambi reta, nímane igige! Tava ea, enembo avona uka muu utua guri rei-rurua-dava gurimi mino ea bubugadi!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aghá regegetueta, númane uka muu bubugaita igigetueta, aná datu ariri yagera aita rouvia gimasa bubie. Bubieta, aná mosegamose simbugea kaifa rosa-mi yagera banauva teterugetueta bebato gajetue. ");
INSERT INTO bjz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Anada ambova aná mosegamose ingo yoveni uka muu tava aita igigetua-mi, kaverea etia regegetue, ‘Jojabee, Jojabee, námandu bebato ifege!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aghá regegetua mo, aná gimasami númandu eghá retue, ‘Amó gaa bee rere. Nímane avouvi, amó jo gambi re.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Amindu, kaifa ea goghó egegadi rere! Anada bee mo, Enemboda Jojabeeda* kaverea furari fefera, nímane jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aghá rea, Iesu rekago eghá ririe, “Gaga retora dabako aghagonu embó eini esega yaita urota, aghi etueta, unda buro kakato etia, danode desetueta, unda eini-eini kaifa egegari-du rea, númandava guri vesa etue. ");
INSERT INTO bjz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Aná embó unda buro kakato bakodeda buroda aito fugarinu gerurota, embó einida vesa, guri dano K900,000 aghago utue. Einida vesa, guri dano K360,000 aghago utue. Kotú einida vesa guri dano K180,000 aghago utua doa, umó esega iye. ");
INSERT INTO bjz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Aná guri K900,000 bia embómi iya, tutuno ea anami buro dumeni etueta, aná guri bia-da etova rekago K900,000 siroretue. ");
INSERT INTO bjz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dabako aghagonu, aná guri K360,000 bia embómi iya, tutuno ea, anami buro dumeni etueta, aná guri bia-da etova rekago K360,000 siroretue. ");
INSERT INTO bjz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tago, aná guri K180,000 bia embó, umó iya, enda ghambea, unda barirarida guri avo uje etue. ");
INSERT INTO bjz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Fefera yafabe serigetueta, númanda barirari kaverea etia, númane guri daiyagha jijimu etua mo, unda boanda ititigetua-nu kuvia gie. ");
INSERT INTO bjz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aná guri K900,000 bia embómi etia, unda bariraridu eghá retue, ‘Jojabee, amó indava guri K900,000 bua, anada etova rekago guri K900,000 etueta siroretue.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Aghá retueta, unda barirarimi undú eghá retue, ‘Taubana bee etoravore. Imó anda buro kato taubana re, buro ea goghó eta roravore. Imó buro ijoko ea goghó etoravore. Amindu, buro jojabe inona kaifa ari-du utaita rore. Fu, teradi-gea, angá danode gangoro urota iririgore!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Anada ambova, aná guri K360,000 bia embó beago etia, unda bariraridu eghá retue, ‘Jojabee, amó indava guri K360,000 bua, anada etova rekago guri K360,000 etueta siroretue.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Aghá retueta, unda barirarimi undú eghá retue, ‘Taubana bee etoravore. Imó anda buro kato taubana, buro ea goghó eta roravore. Imó buro ijoko ea goghó etoravore. Amindu, buro jojabe inona kaifa ari-du utaita rore. Fu, teradi-gea, angá danode gangoro urota iririgore!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Atá, aná guri K180,000 bia embó etia, unda bariraridu eghá retue, ‘Jojabee, amó tanana rore, imó embó fakarago bee re. Enembo dumenida aayo govari, inona iiava buta roravore. ");
INSERT INTO bjz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Amindu, amó oru etore-gea, inda guri bua era, enda rova nungari vitata, bua etere. Inda guri eveta, gii!’ ");
INSERT INTO bjz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aghá retueta, unda barirarimi undú eghá retue. ‘Imó buro kato embó akuago, kotú dogabi re. Imó seibe gari re, enembo dumeni da aayo govari, anona iiava buta rore. ");
INSERT INTO bjz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Amindu imó dodu anda guri bua ya koromava itota, buro urota, amó kaverea furá, inda itasira-da etova dumeni sirorasueta basire? ");
INSERT INTO bjz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ená buro katodava guri rougea bua, buro kato eini sei guri K1,800,000 bua righia vitia-dava, ututuge! retue. ");
INSERT INTO bjz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Enembo avodava eini-eini oruabe iradua, anada etova oruabe utota bua, undava eini-eini oruaruabe aita rouvie. Tago, enembo avodava ijoko iradua, undava aná rougea baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aghá-gea, ená buro katodava taubana eini tefo re. Umonu bua isaghava fufuge-gea, bingoiva vorea, memagha diitu kirisi-karasa urota, jii rirota iroe!’” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Enemboda Jojabee* unda kini da ano bua, anera kakara manede unda duroghade fufugaita rousua feferava, umó unda avo asumbariva asumbaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Asumbea, unona rata, ená endava enembo bubua, unda dibeva desota, unona gateguturota, taubana bua, ingo bee kena itia, akokogo bua, ingo anda kena itaita rouvie. Eto-bato sifi kaifa kato unda sifi mane gategea ingo bee kena itia, gouti mane unda ingo anda kena itita rouvia, aghagonu aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aghá ea, kini mi unda ingo bee kena enembodu eghá raita rouvie, ‘Nímane anda Afami taubana ea simbugetua-du rere. Anda Afana, uutu enda uubu uria feferava, nímane tumanadu kaifa aita rea, kambesi taubana simbuguturia-va fufuge, teterugadi! ");
INSERT INTO bjz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Anada bee mo, amó baimana itatama uua, nímane andú undari ututuaveta undita urere. Kotú amó ukó mosisi kaĩ ueta, andú uvu ututuaveta undita urere. Aghago, nímane jo amó sei gambi re-tago, amó gerurera aghade, andú orokaiva rirota, ghaito teno beisi egegeta ureravore. ");
INSERT INTO bjz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Amó taroba irieta, nímanena boo eembo ututurieta, dighia ombea urere. Amó kae bua iria, nímanena amó kaifa egegutureravore. Amó diburava iria, nímane furera, amó esega ureravore.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aghá rata-gea, aná enembo taubana, dinunu tefo manemi undú eghá raita rousue, ‘Jojabee, nanjigo aghade imó baimana ueta, námane indú undari ututure, o imó ukó mosisi kaĩ ueta, uvu ututure? ");
INSERT INTO bjz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Imó jo sei gambi re-tago, imó gerurera aghade, indú orokaiva rirota, ghaito teno beisi egegari gaa rera? Kotú nanjigo aghade, imó taroba irieta, námanena boo eembo ututurieta, dighia ombea ure? ");
INSERT INTO bjz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Fefera domi imó kae bua irieta, o diburava irieta, námane imó esega egegeta ure?’ ");
INSERT INTO bjz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aghá regegota, kini na númandu eghá raita rouvie, ‘Amó nímandu gaa bee rere, anda ikoko mendi bingá tefo eve desea vitia enembo ijokodu donu egegeta urera, aná andú egegeta ureravore.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aghá rea doa, unda ingo anda kena enembodu eghá raita rouvie, ‘Ari-bari sembago ari kakato, God na seibe simboro uria, aná nímane re. Amó doa, airo igige! God na Satan unda anera manededu ivari tumanadu reivia-nu simbuguturia-va igige, vovoregadi rere! ");
INSERT INTO bjz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Anada bee mo, amó baimana itatama uua, nímane andú undari jo utota undambi re, amó ukó mosisi kaĩ uua, andú uvu jo utota undambi re. ");
INSERT INTO bjz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kotú, nímane sei amó jo gambi re-tago, amó gerurera aghade jo andú orokaiva rirota, ghaito teno beisi egegambi re. Amó taroba iria, nímane jo sonembota, amó dighia ombea ambi re. Kotú amó kae bua iria o diburava iria aghade, nímane jo amó kaifa egegambi re.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aghá rata-gea, númane eghá regegaita rousue, ‘Jojabee, fefera domi, imó baimana o ukó mosisi kaĩ ueta, o taroba irieta, o kae bua irieta, o diburava irieta, námane imó sonembambi egeguture? Kotú, nanjigo aghade jo indú orokaiva rirota, ghaito teno beisi ambi egeguture?’ ");
INSERT INTO bjz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aghá regegota, kini na númandu mino eghá raita rouvie. ‘Amó nímandu gaa bee rere. Anda ikoko mendi bingá tefo eve desea vitia enembo ijokodu donu egegambi urera, aná andava beago jo egegambi egegutureravore.’ ");
INSERT INTO bjz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aghá raita rouvia-da ambova umó aná enembo sembago mane ninengota ya, sembagoda mino baita rousua kambesiva terota, mema jojabe tumanadu itatama egeguturota, enembo taubana, dinunu tefo ya, jebuga tumanadu irari kambesiva teterugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu gaga dano rea sidara uria-da ambova, unda ambo nimbidu ririe, ");
INSERT INTO bjz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nímane reisi-geravore, fefera ungaghada ambova Serigea Yarida Banau* urota, Enemboda Jojabee* kivumi gitofodava utota ifatarava data amburaita rouvie.” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","4","Aghade, fristi* maneda kokotofude, Jiusi enemboda bariraride fristi maneda beforo righari embó ragaro, Kaiafas da kambova danode desea, Iesu nenomi bua data amburari-du manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tago, númane eghá regeguturie, “Namonde amó jo Serigea Yarida Banauda feferava ambi aita rosore. Anada bee mo, enembo oruaruabe desaita rousua-mi neno akuago ea, umó sorea namonde tataya egegauveta!” ");
INSERT INTO bjz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu umó aria, Betani naava bubua, embó ragaro Saimon Refero da kambova terua irieta, ");
INSERT INTO bjz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","evetu einimi uka muu munode mino bee itivanu botoro singoi ragaro arabasta va fendarinu bua furie. Iesu undari dieta, umó terua, aná botoro righia bejea, aná uka muunu Iesu da beforova avereguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aghá urieta, Iesu da ambo nimbi aghá gigigea, neno sembago egeguturie-gea, eghá regeguturie, “Dodu aná uka munode sara-siosa averegetu? ");
INSERT INTO bjz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ená uka muu munodeda mino jojabe-gea, utua guri bua, makasi enembodu ututugasire.” ");
INSERT INTO bjz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Aghá regegutueta Iesu gerurie-gea, númandu eghá ririe, “Nímane dodu ená evetudu bouvu reisi-ututuguto? Umó andava ari taubana bee etue! ");
INSERT INTO bjz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Atá, reisi-gerora, makasi enembo aná nemonde dano, fefera numbo tofo bee iraita rosoravore-tago amó jo namonde tumanadu irambi aita rore. ");
INSERT INTO bjz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Atá, ená uka muu anda tamova averegetua mo, anda tamo furugaita rouvia-du simbugetue. ");
INSERT INTO bjz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Amó nímandu gaa bee rere! Anda Gaga Taubana ya, roo enda niavo niavo ningia fafata egegaita rouvia-va, ená evetu andava donu etua-da kiki anda Gaga Taubanade dano minono regeguturota, ená evetu beago nundubaita rousue!” ");
INSERT INTO bjz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","16","Iesu da ambo nimbi 12 da rova Keriot embó ragaro Judas na erea aria, fristida* kokotofudava bubua uriga urie, “Amó Iesu nímandu kivumi utadora mo, andú donu ututugado?” Aghá ririeta, númane guri siliva dano 30 nu irugea ututurie. Aghá urieta, umó, fefera domi kotú kambesi niavo Iesu bua, númanda ingova utaita rouvia-nu tava urie. ");
INSERT INTO bjz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yisti Tama Arida Banauda* rifo tutunova, unda ambo nimbi furia, undú uriga egeguturie, “Námane kambesi niavo ya, Serigea Yarida Banau simbugota undaita uno ro?” ");
INSERT INTO bjz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aghá regeguturieta, umó mino ririe, “Igige, ená bogu naa rorova igiguturota, embó eini anda isuri aita rora-nu tambua, eghá regege, ‘Irugari kato, unda fefera bubia-du, unda ambo nimbide Serigea Yari Banau inda kambova undidigaita rousue,’ aghá regege!” ");
INSERT INTO bjz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Aghá ririeta, unda ambo nimbi unda riria aghagonu ea, Serigea Yari Banau simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jama urieta, Iesu unda ambo nimbi 12 de aria, aná kambova bubua, Serigea Yari Banau undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aghade numonde undari undidiguturota, umó eghá ririe, “Amó nímandu gaa bee rere. Embó eini nímanda rorova vitia-mi, amó dubo urota, gitofoda ingova utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aghá ririeta, númane neno mema jojabe egeguturie-gea, tutuno ea, uriga ea serigea urota regeguturie, “Jojabee, jo amó irambi ra?” ");
INSERT INTO bjz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aghá regegutueta, Iesu mino ririe, “Avona unda ingomi angá danode aagha dabakova ga degimbea nendera-mi, amó dubo urota, gitofoda ingova utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Enemboda Jojabee* umó donu ari-du gefiria, aghagonu aita rouvie. Tago, umó avona Enemboda Jojabee dari-du kivumi emboro aita rouvia embódu ‘Arii’ rere. Taubana mo, umó jo sirorambi asue.” ");
INSERT INTO bjz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Aghá ririeta, Judas Iesu gitofomi dari-du kivumi bua utaita rouvia embómi ririe, “Jojabee, jo amó irambi ra?” riria mo, Iesu mino, “Eeee, aná imó re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aghá rea, numonde undari undidiguturota, Iesu farava ingari bua, God du aiye rea, righia ingegebea, unda ambo nimbidu ututurota eghá ririe, “Ená anda tamo reta, bua undidige!” ");
INSERT INTO bjz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Anada ambova, vaini aaghava bua, God du aiye rea, unda ambo nimbidu ututurota ririe, “Nímane dano, ená aagha dabakova undidige! ");
INSERT INTO bjz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Anda tatangu enembo oruabedu averegota voraita rouvia-mi God Afa unda natofoda ari-bari akokogo nundubea gia doarida, kotú undava ya bububugarida emboro* reka ifegaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Atá amó nímandu enanu rere, amó vaini ghavesida bee jo rekago undambi irogo, Afa na unda natofo* rata ya, unda kambesiva terota gia, namonde dano vaini rekago undidigaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aghá rea, numonde daa eini divua sidara ea bubua, ooto ragaro Olivi avo rekimbea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Anada ambova, Iesu númandu ririe, “Oreki tumbade nímane dano oru susumbugea, amonu doaita rosoravore. Anada bee, bukava eghá gefirie, ‘God na sifi kaifa kato data amburota-gea, sifi mane gategea gategea, unda unda susumbugaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tago, ambova amó amburarivareta erea, nímane Galili yambi-da dibe kena, sei anona yaita rore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aghá ririeta, Pita na mino ririe, “Númane dano imó doa susumbugaita rousue-tago, amó jo imó doambi aitare.” ");
INSERT INTO bjz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aghá ririeta, Iesu na mino ririe, “Amó indú gaa bee rere. Oreki tumbade kokora be dimbambi irota, imó fefera bakode amó jo gambi gaa rea, kivu aita roravore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tago, Pita kariguturota ririe, “Amó angá dano amburaita asire, imó jo kivu ambi aita rore.” Aghá ririeta, unda ambo nimbi dano Pita da riria aghago regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Anada ambova, Iesu unda ambo nimbide kambesi ragaro Getsemani avo aria bubua, Iesu númandu ririe, “Nímane eve asumbea iririgutu-gea, amó ya onava benunu are.” ");
INSERT INTO bjz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aghá rea, Pita de, Sebedi da sasingu ungaghade dano bua numonde igiguturota, umó tutuno ea unda neno nundubari jujurueta mema jojabe itatama urie. ");
INSERT INTO bjz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Urie-gea, umó númandu eghá ririe, “Amó neno memami sumbua serigetueta amburaita itoko rore. Amindu nímane dibe fakara egege, namonde kaifa egegore!” ");
INSERT INTO bjz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aghá rea itoko gosá ea aria, koubumi jengirea gonea vorea, dibe be endava takembea, benunu eghá urie, “Anda Afa, imó ‘avore’ rari inono asira, ená mema nanjogo andava doa bu! Tago jo anda unonu ambi aita roreta, do-gea, inda unonu siroroe!” ");
INSERT INTO bjz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Anada ambova, umó kaverea aria, unda ambo nimbi bakodedava bubua, númane evivigutueta gerurie-gea, Pita du eghá ririe, “Nímane daiyagha fefera tufoko dibe fakara ea, namonde dano kaifa egegambi roso?” ");
INSERT INTO bjz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Dibe fakara ea, benunu egege, rourogo Satan furá nímane kuvirota, ari akokogo egegara-degea, rere! Nímanda unode nundubaride aná andava vitie. Tago, nímanda tamo firída unomi righieta, nímane jo ano ambi rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aghá rea, umó rekago kaverea aria, benunu urie, “Anda Afa, ená mema andava reifia doadi serigambi adua mo, do-gea inda unonu siroroe!” ");
INSERT INTO bjz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Benunuda ambova, umó rekago kaverea aria mo, unda ambo nimbi dibe bouvu egeguturieta vasia evivigutueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Gia doa, umó fefera bako rekago kaverea aria, benunu dabako ananu ririe. ");
INSERT INTO bjz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Anada ambova, umó kaverea aria, unda ambo nimbidava bubua númandu ririe, “Nímane eviviguturota, nangu undidiguturota vitera? Gigige, Enemboda Jojabee* dubo ea bua, ari-bari akokogo egegari enembodava utari fefera etia utuvako bubie. ");
INSERT INTO bjz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Amindu, ererege, namonde igigore! Gigige, amó dubo ea bua, ari-bari akokogo egegari enembodava utaita rouvia embó enanu bubie.” ");
INSERT INTO bjz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu aghá rieta, unda ambo nimbi 12 da rova, embó eini ragaro Judas buburiturie. Umó fristida* kokotofude, kotú Jiusi enemboda babarigaridemi númanda mene-mene ari kakato dumenide ninenguturieta, kaiyade, gandighade bubugea, Judas da ambo-ambo egeguta aria bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aghade, númane jo furia, utuvako ambi irirota, Judas unda ari-bari daiyagha aita rouvia-nu natofodu eghá ririe, “Embó avonu amó nandia, muno aita rora, aná umó reta, nanandige!” ");
INSERT INTO bjz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aghá rea, numonde aria bubua, Judas dibe dambu aria, Iesu du, “Irugari Kato, tumba taubana! Vitera?” rirota, umó nandia muno urie. ");
INSERT INTO bjz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Urieta, Iesu mino ririe, “Mambu, imó donu aita etera, ananu ege!” ririeta gitofo buburiturota, Iesu nanandiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aghá ueta, Iesu da ambo nimbi einimi unda kaiya bua, fristida beforo righarida buro kato einida nghaĩ vegea kositurieta jujururie. ");
INSERT INTO bjz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Urieta, Iesu undú ririe, “Inda kaiya unda voruva fendi! Anada bee mo, enembo avona kaiya jijimu adua, númane kaiyami gayota ambubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Atá, amó anda Afadava sonembadu benunu asira, aná mene-mene ari anera noni jojabe utasue, imó gambi rora? ");
INSERT INTO bjz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tago, aghá adora mo, Afada uno eghá sirorari-du riria mo, daiyagha sirorea gaa bee adu?” ");
INSERT INTO bjz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Fefera aghade, Iesu aná natofodu ririe, “Nímane dodu vikokode gandighade bua, amó nandaita fufugeto? Amó jo gavana tuvari gaa eini jo rambi re. Atá, amó fefera yafabe namonde God du Tafaroro Ari Kambo* ghokava terua irirota irugeta riara mo, nímane daiyagha amó avo nanandigambi egegeta rosa? ");
INSERT INTO bjz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tago, feroveta maneda donu gefiria-da bee sirorari-du rirota, eghá rei-sirorutue.” Aghá rieta, Iesu da ambo nimbi dano umó doa susumbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Númane avona Iesu nanandiguturia, aná bua aria, fristi* maneda beforo righari embó ragaro Kaiafas da kambova Moses da Gaga Irugari Kakatode* kotú Jiusi enemboda babarigaride dano desea vitiria-va, bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aghade, Pita umó itoko ambo fugea ea jiria uta aria, fristi maneda beforo righarida kambesiva bubua kambo ghouka rova terua aria, mene-mene ari kakatode asumbea, Iesu dava donu siroraita rouvia-nu gaita urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aghade, fristi maneda kokotofude kanisera* manede dano Iesu data amburari-du regeguturota, gaga gaveranu rirota, osagho fufumbugari-du tava egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Aghade enembo oruaruabe gaga gavera manenu rea aregea, farara egeguturie-tago, númane Iesu dava sembago eini jo tatambugambi re. Aghá uua-da ambova, embobo ungaghami bubua furia eghá regeguturie, “Ená embómi God du Tafaroro Ari Kambo* righia bejea fefera bakodeda rova rekago ari umó inono gaa rita.” ");
INSERT INTO bjz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aghá regeguturieta, fristida beforo righari erea jiria, Iesu du uriga urie, “Ená gaga inda tamova reisi-ria-da mino mo, imó jo gaga eini rambi adora? Kotú, ená emboboda regegetua gagada bee mo doro?” ");
INSERT INTO bjz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aghá ririe-tago, Iesu mino donu jo rambi urie. Anada ambova, fristida beforo righarimi undú ririe, “Amó God jebuga tumanadu irarida ragarova indú uriga rore. Imó God da Mendi o God enembo sonembari-du embó eini utaita riria, imó iradora mo, rege námane niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aghá regeguturieta, Iesu mino ririe, “Aĩ, nímanda reisi-rera aghago re-tago, amó nímane nanjogodu eghá rere. Fefera ambova Enemboda Jojabee* God Ano tofoda ingo bee kenava asumbea vitia-mi, uutu vareta gooso etova vovorurota gigigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aghá ririeta, fristida beforo righari ningia, neno akuago uria-gea, unda tamova asugari righia kisorea doa, eghá ririe, “Umó aghá rirota, God fara etue. Amindu, dodu gagada osagho fumbari enembo dumenida gaga niningiga? Gigige! Oreki umó God fara etua, namonde dano niningigetore. ");
INSERT INTO bjz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Amindu, nímane daiyagha reisi-nundubuto?” Aghá ririeta, númane mino regeguturie, “Undufa isagha etua-du, umó amburasue.” ");
INSERT INTO bjz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Anada ambova, númane unda dibe beva visogha ea, ingo safea, umó ofova toka-taka egeguturota eghá regeguturie, “Inda rariva mo, God embó eini utaita riria imó re, reta roravore. Avota, indava ferovetada ano iradua mo, rege niningigore: Imó avona detu?” ");
INSERT INTO bjz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita isaghava kambo kara rova asumbea irieta, Kaiafas da buro ariri eini furia, undú ririe, “Imógha dano Galili embó Iesu de dano vitaravore.” ");
INSERT INTO bjz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aghá ririe-tago, umó númane nanjogoda dibeva kivu urota eghá ririe, “Imó dodu rera, amó jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aghá rea, umó bubua, ghouka bebatova aria jiria irieta, ariri einimi umó gerurie-gea, avo desea vitiria enembodu ririe, “Ená embó Iesu Nasaret embóde danode vita.” ");
INSERT INTO bjz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aghá ririeta, umó rekago kivu urota, tamú-tamú ririe, “God da ragarova amó gaa bee rere. Aná rera embó amó jo gambi re!” ");
INSERT INTO bjz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Anada ambova itoko irirota, enembo avo jijiregea vitiria-mi aria, Pita du regeguturie, “Gaa bee re! Inda gaga rera-da eromi isagha rouvia mo, imó númanda eini re.” ");
INSERT INTO bjz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aghá ririeta, Pita númandu eghá ririe, “Amó gavera radora mo, God na amó data amburaitare! Amó gaa bee rere. Nímanda reisi-rera embó amó itoko jo gambi re.” Aghá ria mo, kokora be difirie. ");
INSERT INTO bjz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aghá ueta, Pita Iesu da riria gaga nundubuturie, “Kokora be dimbambi irota, fefera bakode inona amó kivu aita roravore.” Iesu da riria-nu nundubea, umó isaghava bubua, jiimi neno gagajeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rifo atiturieta, fristi* maneda kokotofude, kotú Jiusi enemboda babarigaride dano furia desea, Iesu data amburari-du manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aghá ea, umó seni mi bundia bua aria, Rom enemboda gavana ragaro Pailat dava ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aghade, Iesu dedegota amburari-du regeguturia-nu gia, aná Iesu dubo ari embó Judas na neno mema jojabe ea, aná guri* dano 30 bua kaverea fristida* beforo righaride Jiusi enemboda babarigaridedu ututurota eghá ririe: ");
INSERT INTO bjz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Amó ari akuago ea dinunu tefo embónu bua, gitofodava ututare.” Aghá ririeta, númane mino regeguturie, “Atá námanena donu egega? Aná inda dara re!” ");
INSERT INTO bjz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aghá regeguturieta, Judas aná guri God du Tafaroro Kamboda rova fugea doa seriguturie. Anada ambova, umó bubua aria, undufako mande ea ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Aghá urieta, fristi maneda kokotofumi aná guri bua, eghá regeguturie, “Ená guri rekago bua, Tafaroro Kamboda* tofo ututugadora mo, namonde anda agho dari bejaita rosore. Anada bee mo, ená tatanguda mino re.” ");
INSERT INTO bjz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Amindu númane nundubari dabako egegea, endami ovu derari kato einidava mino ea, roo eini enembo furugari kambesidu bubugaita regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Amindu rea, anada feferavareta furia oreki aná kambesida ragaro “Tatanguda Enda” reta rousue. ");
INSERT INTO bjz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Aghá egeguturieta, feroveta Jeremaia da donu riria gaada bee siroruturie. Atá umó eghá ririe, “Israel enembomi umonu dubo egegaita riria-da mino guri siliva mi ari dano 30 nu bua, endami ovu derari katodava utua, enda bubuguturie. Jojabeeda andú riria, aghagonu egeguturie.” ");
INSERT INTO bjz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aghade, Iesu bua aria, Rom enemboda gavanada dibeva bubua jijireguturieta, gavanami undú uriga urie, “Imó Jiusi enemboda kini ra?” ririeta, umó mino ririe, “Eẽ, inda rera aghago re,” ");
INSERT INTO bjz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aghá ririeta, fristi* maneda kokotofude, Jiusi enemboda babarigari dumenide dano umonu itia bera-bera egeguturie-tago, umó jo gaga mino eini rambi re. ");
INSERT INTO bjz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Anada ambova, Pailat na undú ririe, “Imó ená itia bera-bera rousua gaga nanjogo mo rei-niningora?” ");
INSERT INTO bjz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aghá ririe-tago, Iesu mino gaga eini itoko jo rambi urieta-gea, gavana mana-mana jojabe urie. ");
INSERT INTO bjz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Serigea Yari Banauva*, gavanada evovo mo, dibura enemboda rorova, enembo eini natofoda uno egegarinu, doaveta bubuta urie. ");
INSERT INTO bjz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Fefera aghade, bingáde embó sembago eini, ragaro Barabas, diburava vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Amindu natofo bubua, danode egeguturieta, Pailat na númandu uriga urie, “Nímandu avonu doata bubadu? Barabas nu, aĩ, Iesu Keriso reta rosora-nu?” ");
INSERT INTO bjz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat aghá riria-da bee mo, umó gerurie, Jiusi enemboda babarigari númane Iesu da bingá niningigea, jii didimbugea, amindu Iesu bua furia, unda ingova ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Avore, Pailat irurari kambesiva asumbea irieta, unda evetu undú gaga eghá ututurieta furie, “Imó aná dinunu tefo embódu donu eini mania ata! Anada bee mo, amó oreki dirava umó gia neno mema jojabe etore.” ");
INSERT INTO bjz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tago, fristida* kokotofude kotú Jiusi enemboda babarigaridemi, natofo daiyagha regegasueta, Pailat na Barabas nu doa, Iesu data amburari-du rasua-nu nundubuturota, aghagonu egegari-du neno evuruturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aghá egegutueta, Pailat natofodu uriga urie, “Ená enembo ungaghada rorova avonu doata bubari-du uno roso?” Ririeta, númane mino “Barabas nu!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Regeguturieta, umó uriga eghá urie, “Atá, amó Iesu aná embó nímane Keriso regegeta rosora-du, daiyagha a?” Ririeta númane dano “Ifatarava dege amburoe!” ");
INSERT INTO bjz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aghá regeguturieta, Pailat uriga urie, “Bee dodu? Kotú umó dinunu donu etu? Regege, ningore!” ririe. Tago númane koko fugia, “Umó ifatarava dege, amburoe!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aghá regegeturia-mi, Pailat na rekago donu ari mana-mana urie. Tago, númane rourogo susughi egegauve-degea, uvu bua, númanda dibeva ingo seseghurota eghá ririe, “Ená embóda amburaita rouvia-va, anda dara tefo re. Aná nímanda dara re.” ");
INSERT INTO bjz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aghá ririeta, natofo dano mino regeguturie, “Do-gea unda amburaita rouvia-da bouvu námandava kotú námanda sasingu manedava voroe!” ");
INSERT INTO bjz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aghá regeguturieta, Pailat númandu Barabas nu dotuturieta furia, isaghava buburiturieta, umó ririeta, unda mene-mene ari kakato dumenimi Iesu bua, embiimi dedeguturie. Aghá egeguturieta, Pailat na Iesu nu bua, ifatarava dedegota amburari-du rirota, mene-mene ari kakato dumenida ingova ututurie. ");
INSERT INTO bjz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gavanada mene-mene ari kakato Iesu ghambugea bua aria, gavana maneda kambo rova teteruguturieta, mene-mene ari kakato dano furia, Iesu fugea roroguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","29","Númane Iesu da asugari righia kokosugea, eembo inimba beenu bua, tumo tano vovogha urieta, kini da kasavago urota, ika fatu gingidemi keifi ea, beforova asuguturie. Aghá ea, ika eini bua, unda ingo beeva itia, kotofu embó kakara arigo egeguturota, unda dibe kena koubomi jengirea, umó kukuvirota, eghá regeguturie, “Orokaiva! Jiusi enemboda kini, buberavore! Orokaiva!” ");
INSERT INTO bjz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aghá rirota, visogha unda tamova egegea, unda ingo beeva ikanu bua, umó beforova dea bua dea bua deta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Númane Iesu kavaga egeguturia-da ambova, aná eembo inimba beenu kosugea rururota, asugari unda tofonu bua asuguturie. Aghá egegea, ifatarava daita rea, ghambugea bua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Numonde bubua igiguturota, Sairini embó ragaro Saimon tambua rea bera-bera egeguturieta, Iesu da ifatara fufirie. ");
INSERT INTO bjz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Fufirieta, numonde aria, kambesi ragaro Golgota avo buburiturie. Golgotada bee mo, amburari enemboda beforo siruru re. ");
INSERT INTO bjz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aria, avo bububugea, númane vaini ingi eini muno sembago kafanida karajegogha bagega arinu ututurie-tago, sosofea gia, undari injigha urie. ");
INSERT INTO bjz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aghá urieta, númane Iesu tautami ifatarava dedegea, unda asugarinu vesa-boanda egegaita rea, kikindo gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Númane avo asumbea, umó kaifa egeguturota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Atá, unda beforo gombu kena mo, númanda umó itia bera-bera egeguturia gaganu eghá gegembuguturie: Ená Iesu, Jiusi Enemboda Kini Re. ");
INSERT INTO bjz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Fefera aghade, bagia kakato ungagha bua furia, eini Iesu da ingo bee kena, eini ingo anda kena ifatarava dedeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Enembo iru-furu urota, beforo biru-biru urota, Iesu gia kuvia gegha regeguturota, yovero regeguturie, “Imó God du Tafaroro Ari Kambo* righia bejea, fefera bakodeda rova righota erea jirari gaa reta ureravota, indufako sonembe! Imó God da mendi iradora mo, ifatarava doa vore!” ");
INSERT INTO bjz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dabako aghagonu regeguturota, fristi* maneda kokotofude, Moses da Gaga Irugari kakatode*, kotú Jiusi enemboda babarigaride dano umó kavaga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kavaga egeguturota, gegha-gegha regeguturie, “Umó enembo dumeninu sonembeta urie-tago, undufa sonembari jo inono irambi re! Namonde amó Jiusi enemboda kini umó re, reta ria amindu, umó ifataravareta voradua, namonde amó umonu gaabee egegaita rosore. ");
INSERT INTO bjz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Umó God gaabee ari gaa reta rouvie. Kotú umó God da Mendi gaa reta ria, amindu do-gea, God undú uno adua mo, furá umó oreki sonemboe!” ");
INSERT INTO bjz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Gaga ningari ero dabako aghagonu, aná ari akokogo enembo ungagha Iesu de dano ifatarava dedeguturia beago, Iesu du jagita gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aghade fefera beforova reta aria, jama 3 koroki uria-va, aná roo enda dano bingoimi afureguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jama 3 koroki ueta, Iesu Jiusi enemboda gaami koko fugia be jojabe ririe, “Eroi, Eroi, rama sabakitani?” Aghá riria-da bee mo, Anda God, anda God, imó dodu amó doto? ririe. ");
INSERT INTO bjz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iesu da koko riria-nu niningigea, enembo dumeni avo jijiregea vitiria-mi jo niningigea goghó ambi egeguturota, eghá regeguturie, “Umó Elaija du ghogho reirie.” ");
INSERT INTO bjz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aghá regeguturieta, númanda rorova embó eini tutomi sumbua aria, eini-eini ofusada mokogonu bua, ika mendóva fakembea doa, vaini kaeededa kofiriva ga degimbea bua, Iesu na undari-du siniturieta vitia unda beva takembuturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aghá urieta, enembo nanjogo avo jijiregea vitiria-mi regeguturie, “Do-gea, namonde gigigore, Elaija furá, umó sonembadua, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Aghade, Iesu rekago koko be jojabe rirota, ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iesu ambubutueta, God du Tafaroro Ari Kambo* bogu naa Jerusalem vitiria-da rova, rourogo enembo ya, Kambesi Kakara Bee anava terua amburauve-degea rea, eembo einimi gajari vitiria, aná rorova kisorea vorefuria, tuva buburiturieta, enda gino-gino ueta, singoi jojabebei sasariguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Aghade enembo kakara oruabeda uje be ifeguturieta, númane amburarivareta jebugea erereguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Númane uje be ifeguturieta ereregea igiguturieta, Iesu eroruria-da ambova, numonde danode aria, Jerusalem bogu naa kakarada rova teterugea enembo oruabedava isagha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mene-mene ari kakatode númanda beforo righaride Iesu kaifa rousuria, aná gino-gino kotú eini-eini nanjogo siroruturia-de dano gigigea, oru egeguturie-gea regeguturie, “Gaa bee re, umó God da mendi re!” ");
INSERT INTO bjz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aghade evevetu oruabe airo jijiregea, Iesu dingera rousurie. Númane Galili reta Iesu da aghi egegaita ambo tuvia fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Númanda rorova Makdala ariri Meri unda akaude, kotú Sebedi nuye, Jems ungá Jon ghada nuede, dano vitirie. (Ená Meri eini rera, umó Jems ungá Joses ghada nue re.) ");
INSERT INTO bjz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jama urieta, Arimatea embó gugua-ghayafade ragaro Josep, sei Iesu da yavero eini uria-mi aria, ");
INSERT INTO bjz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pailat dava bubua, Iesu da tamodu benunu urieta, Pailat na aná tamo Josep du utari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Josep aná tamo bua aria, eembo reka saghai tamo bingorugomi otoo ea, uje reka unda tofo gudoro ufuva ghafiria-da rova itia, singoi jojabe eininu oberea bua aria, singoimi uje be gajea, doa arie. ");
INSERT INTO bjz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aghade, Makdala ariri Meri, unda akau Meri gha ujeda yoveniva asusumbea dingera urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nangu undarida rifo atiturieta, fristida* kokotofude, Moses da Gaga Kaifa Kakatode* Pailat dava aria, ");
INSERT INTO bjz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","eghá regeguturie, “Kotofuko, námane reisi-nundubutore, aná gavera kato umó jebuga irirota, ‘Amó ambua fefera bakodeda ambova rekago eraitare,’ ririe. ");
INSERT INTO bjz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Amindu rege, mene-mene ari kakato ená fefera bakodeda rova unda uje be kaifa ea goghó egegoe! Rourogo unda ambo nimbimi furá unda tamo bagia ea bua ya, enembodu umó amburarivareta jebugea erari gaa regegauveta! Aghá regegadua, aná ambova regegaita rousua-mi ata, dara sembago bee siroraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aghá regeguturieta, Pailat mino ririe, “Mene-mene ari kakato dumeni uje be kaifa egegari-du bua, igige! Nímanda reisi-gerora aghagonu urota, gajea goghó egegadi!” ririe. ");
INSERT INTO bjz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aghá ririeta, númane aria, aná uje be singoimi gajea saro ea goghó egegea, mene-mene ari kakato dumeni uje be kaifa egegari-du doa igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nangu undari feferada ambova, fura einida fefera tutunovada rifo atitueta, Makdala ariri Meri unda akau Meri gha uje gigigaita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aghade, Jojabeeda anera uutuva reta vorea, uje be gajari vitiria singoinu oberea kasava irueta, gino-gino jojabe urieta, umó aná singoi etova asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Unda gari, eto-bato kirivago re. Kotú unda asugarida gari eto-bato goosoda saghaigo re. ");
INSERT INTO bjz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aná mene-mene ari kakato Iesu da uje kaifa rousuria, aghá gigigea, undú oru-oru egegea, eka ingo dadada egegea, sei amburari enembogo eka ingo dagaya urota, dibe gombeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aghá urieta, anerami aná evevetudu ririe, “Mania oru egegata! Amó rei-gerore, Iesu ifatarava dedeguta-nu tava rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tago, umó oreki eve tefo re. Unda riria aghagonu urota, amburarivareta jebugea eretue. Atá fu, unda vasia vita kambesi gigigadi! ");
INSERT INTO bjz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Amindu, tutumi igige, unda ambo nimbidu eghá regegadi: ‘Umó amburarivareta erea, nímanda dibe kena Galili Frovensi reiya-du, umó avo gigigaita rosoravore.’ Avore, gaga donu bua etera-nu dano retueta niningigetoravore.” ");
INSERT INTO bjz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aghá ririeta, aná evevetu ujevareta kaverea, orude kotú gangorogha danode, unda ambo nimbi rata niningigari-du susumbugea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Igigutueta, jo gaimbo ambi, Iesu númane emborova tambua, “Siriri ari nimonde danode iroe!” ririeta, ungá umó aria, unda ekava ririkiguturota, undú tumogha baĩ egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aghá egeguturieta, Iesu númandu ririe, “Mania oru egegata! Igige, anda ambo nimbidu regegadi, Galili ya, amó avo gigigoe!” ");
INSERT INTO bjz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aná evevetu kaverea igigutueta, mene-mene ari kakato dumeni uje kaifa rousuria-mi aria, bogu naava bububugea, fristida* beforo ririkigaridu donu siroruturia-nu isagha urie. ");
INSERT INTO bjz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Aghá egeguturieta, fristida beforo ririkigaride, kotú Jiusi enemboda babarigari dumenide bubua, danode desea, manaka gaegegea, aná mene-mene ari kakatodu guri mino jojabebei ututuguturota, númandu eghá regeguturie, “Nímane eghá regege, ‘Námane tumbade evivigutueta, unda ambo nimbimi etia umó bagia ea bua igigetue.’ ");
INSERT INTO bjz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ambova gavana ená gaga ningadua mo, námanena nghaĩ ititigota, umó gangoro urota, nímane dara eini jo tatambugambi egegasiravore.” ");
INSERT INTO bjz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aghá regeguturieta, mene-mene ari kakato aná guri bubugea, númane donu egegari-du regeguturia aghagonu egeguturie. Atá, ená gaga Jiusi enemboda rorova biruru urota, sirorea jojabe ea oreki vitie. ");
INSERT INTO bjz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iesu da ambo nimbi 11 dano Galili, unda riria doririva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aria, Iesu gigigea, numonde undú tumogha baĩ egeguturie-tago, enembo dumeni mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aghá egegutueta, Iesu aria númane kena utuvako ea, eghá ririe, “God Afana ‘avore’ rari ano uutuva kotú endava vitia dano andú ututurie. ");
INSERT INTO bjz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Amindu igige, naa nanjogova enembo dano regegadi, anda yavero egegota, númane Afa, Mendi, kotú Asisi Kakarada ragarova bafutaito egegadi! ");
INSERT INTO bjz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kotú anda nímandu donu rirera aná iruge, númane gigigea ambo-ambo egegoe! Atá nunundube, amó fefera inono namonde danode iririguturota ya, uutu enda tano arida fefera bubaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","God da Mendi, Iesu Keriso da Bingá Taubana aná tutuno eghá ea furie. ");
INSERT INTO bjz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God da feroveta ragaro Aisaia da seibe unda buka rova gefiria, aghagonu tutuno urie “God na ririe. ‘Amó anda aghi kato sei ninengota ya, indú emboro simbugaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Embó eini uvu tefo, kotú enembo irambi kambesiva irirota, ghogho reirie, ‘Jojabeeda emboro simbuge, dambu ae!’” Aisaia na aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Amindu rea, Jon Bafutaito Ari Kato aria, uvu tefo kotú enembo irambi kambesiva bubua, enembo bafutaito urota, unda minono eghá reta urie, “Neno kaverea, nímanda ari akokogo isagha egeguturadi-gea, nímane bafutaito are! Aghá urota, God na nímanda ari akokogo nundubea gia doaita rouvieta.” Jon na minono aghá reta urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aghá reaveta, frovensi Judia enembo oruaruabe, kotú bogu naa Jerusalem enembode dano ereregea, avoreta fuava danode ea, Jon da gaga niningiguturota, númanda ari akokogo isagha egegutuaveta, Jon na númane Jordan uvuva bafutaito eta urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon anava irirota mo, umó oka kamero da tamo seghanu teindu ea asugeta urie. Kotú, unda abaguva dighari beago aná kamero da andoromi fifinembarinu dighita urie. Aghade umó avo irirota, siside firukadenu bua undita urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Aghade, unda minonova eghá reta urie, “Embó eini anda ambova refia, umó ano tofo re, amó jo umongo irambi re. Anda anode duroghade jo undago irambi re. ");
INSERT INTO bjz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Amindu, nímane anona tefo uvumi bafutaito eta rore. Atá, nímane aná unona Asisi Kakarami bafutaito aita rouvie.” Jon na aghá reta urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Anada ambova, jo gaimbo ambi, Iesu unda naa Nasaret frovensi Galili anavareta furia, uvu ragaro Jordan anava bubua aria vorea jiruturieta, Jon na umó avo bafutaito urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aghá ea, sidara urieta, Iesu umó uvuvareta vivitueta aghade, utu ifeguturieta, Asisi Kakarami eto-bato dii ukugo isaghava vorefuria, undava asumbuturieta, gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aghá urieta, uutuvareta be fugia eghá ririe, “Imó anda neno bari Mendi re. Inda irari gerurota, anda neno roo gangoromi beda rouvie!” ");
INSERT INTO bjz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aghá uria-da ambova, jo gaimbo ambi, Asisi Kakarami Iesu unumbea bua, uvu tefo kotú enembo irambi kambesiva avo arie. ");
INSERT INTO bjz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aria bubua, tumba kotú onembo 40 anava irieta, Satan na undava bubua, unda ano kuvia gaita eta urie. Aghade, Iesu taima okade dano vitiria mo, God da anera dumeni fuava, umó sonembeta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kini Herot na ririeta, Jon Bafutaito Ari Kato nandia bua aria, diburava gajituria-da ambova Iesu kaverea aria, Galili Frovensiva terua, Bingá Taubana God davareta furia, ananu minono raita tutuno urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Unda minono eghá reta urie, “God unda natofo* kaifa arida fefera riria, aná etia utuva etue. Amindu neno kaverea fufuge, God da Gaga Taubana niningigea, gaabee egegadi!” reta urie. ");
INSERT INTO bjz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aghá urota, umó aria, Galili sao jojabe kasava deĩ ea irurota, uvu oka bari kakato ungagha, Saimon unda ikoko Andru gha, ghoto moyuvami uvu oka beberueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aghá-gea, númandu eghá ririe, “Anda ambova fufuge, anona irugota, ghotomi uvu oka buta rosora aghagonu, enembo unumbea bua, andava furadi-gea, anda ambo nimbi egegoe!” ");
INSERT INTO bjz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aghá ria, jo gaimbo ambi, ungá unda ghoto avo doa erea, Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aghá ea, itoko irurota, Sebedi da sasingu gigimasa ungagha Jems ungá Jon gha, númanda ghaava* ghoto too mane gegembugutueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu númane gerurota, jo gaimbo ambi, númane ghogho ririeta ungá erea, ungá unda afade, kotú aná ghaava buro ari embobode avo doa, ungá umó Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu unda ambo nimbide aria, naa eini ragaro Kaperneam avo bubua, Jiusi enemboda Nangu Undari fefera furia buburituria-du, Iesu aria, nghaĩ itari kambo* rova terua, tutuno ea nghaĩ ititurie. ");
INSERT INTO bjz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iesu na nghaĩ ititueta, aná natofo niningigea, duduku-dadaka ea, mana-mana egeguturie. Anada bee mo, Iesu umó gaa bee nuenembo anogha irugutuaveta, númane itatama egegeta urie. Jo Moses da Gaga Irugari kakatoda* gaga irugeta uria aghago, rambi re. ");
INSERT INTO bjz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aghade embó eini taimu akuagomi asuguturieta vitiria-mi, furia, nghaĩ itari kambova terua, Iesu gaga rieta rei-niningurieta taimuda anomi rururieta, ");
INSERT INTO bjz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","aná taimumi asugea vitiria embómi Iesu du be koko fugea eghá ririe, “Nasaret embó Iesu, imó námandava daiyagha ado? Imó námane data amburari-du futara, aĩ, tefo? Imó embó avouvi, amó rei-gerore. God na Embó kakara utaita riria, aná imó re.” ");
INSERT INTO bjz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aghá ririeta, Iesu na mino undú ininigha eghá ririe, “Be do! Aná embóda tamo roo doa fu, isaghava bubadi!” ");
INSERT INTO bjz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aghá ririeta, aná taimu vitiria-mi, isaghava bubaita erorueta, aná embó righia rarovutueta, koko jojabe rieta, aná taimu isaghava bubua seriguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aghá urieta, enembo dano duduku-dadaka ea, mino-mino rea niningiguturie. “Ená doro? Ená irugari reka anogha siroretue. Unda anomi reaveta, taimu akokogo mane enemboda tamo rova irari unda gaga ningia fuava isaghava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aghá urieta, jo gaimbo ambi, Iesu da bingá arieta, Galili Frovensiva enembo dano ningia fafate egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aghá uria-da ambova, Iesu de Jems ungá Jon gha kotú unda ambo nimbi dumenide nghaĩ itari kambo* doa aria, Saimon ungá Andru ghada kambova teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon da imboti kae bua, tamo vevera ua-du vasia vitiria-nu, regeguturieta, Iesu niningurie. ");
INSERT INTO bjz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Umó aghá ningia aria, undava terua, ingova ririkurieta eroruria, unda kae seriguturieta jebuguturie. Jebugea doa, númanda uno dano simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Fefera vorea, jama urieta, avo kae bua desea vitiria enembo dano bua, Iesu dava fufuguturie. Dumeni taimu akokogo manemi asuguturieta vitiria manede dano bua fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaperneam enembo dano furia, kambo bebato kenava jijireguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Danode egeguturieta, Iesu na ririeta, aná enembo avona kae dibe eini be eini bua vitiria, dano jejebuguturota, kotú dumeni taimu akokogo manemi enemboda tamova asusugea vitiria-de dano ririeta bubua seriguturie. Tago, Iesu ininigha, númane gaga eini regegauve-degea bureguturie. Anada bee mo, umó avouvi aná taimu manemi gigigari re. ");
INSERT INTO bjz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rifo tumbava fefera jo vitambi-va, Iesu erea, aná kambo doa, enembo irambi kambesiva benunu aita arie. ");
INSERT INTO bjz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Arieta, Saimon unda kokomana dumenide erea, umonu tava egeguta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Aria tatambugea, eghá regeguturie, “Enembo dano indú tava rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Tefo, namonde naa dumeniva igigore! Amó naa dumeni ená naada kasava vitia, aná maneva minono raita rore. Anada bee mo, amó God daiyagha unda natofo kaifa eta rouvia-da Gaga Taubananu minono raita furere.” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Amindu, númane erea aria, Galili Frovensiva biruru urota, naa nanjogoda nghaĩ itari kambova* terua bubua urota, minono reta urie. Kotú taimu mane, enemboda tamo rova iririgarinu reaveta, kasava voreta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aghá ueta, embó eini tamo betomi gigimbea vitiria-mi, Iesu dava furia, koubomi jengirea benunu urota, eghá ririe. “Amó tanana rore, ano indava vitia, aná inono bee re. Aghá-gea, imó uno adora, ege-gea, amó jebugore!” aghá ririeta, ");
INSERT INTO bjz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu umó aná embódu neno mema urota, unda ingomi sinia, aná embóda tamova ririkurota eghá ririe, “Amó uno roreta, imó jebuge!” ");
INSERT INTO bjz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aghá rieta, aná embóda tamova betomi gigimbea vitiria sidara urieta, umó jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Aghá ea doa, Iesu na tatavami aná embó nineguturota, ");
INSERT INTO bjz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ininigha eghá ririe, “Anda donu etora, mania enembodu rata! Tago, dibe dambu ii, fristidava* bubua, inda tamo irugadi gata, Moses da Agho Dariva bebeta irari doa jegubaria-da vesa daiyagha dungari-du reiria, aghagonu ege-gea, enembo dano imó jebugetora-nu, gigigoe!” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aghá ririe-tago, aná embó umó Iesu da riria aghago jo ambi re. Umó enembo dava dano isagha urieta, niningigea aria, aná naa mane dano fafate urie. Amindu, Iesu aná bogu naava ya terari jo inono irambi eta urie. Umó aria, enembo irambi kambesiva iriaveta, bogu naava enembo iiava undava bububugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aghade fefera dumenida ambova, Iesu rekago kaverea aria, Kaferneam unda irari kambesiva buburiturie. Iesu naava iria-da bingá sarigea aria, fafate urie. ");
INSERT INTO bjz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aghá urieta, enembo dano niningiguturie-gea furia, umó vitiria-va bububuguturie. Enembo fufuguturia-mi kambo bebato kena beda urieta, enembo dumeni ya terari mana-mana egeguturie. Aghade, Iesu na númandu nghaĩ ituturota, minono rieta, ");
INSERT INTO bjz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","enembo ungagha-ungaghami embó eini eka ingo takembarinu fumbua bua, Iesu dava furia bubuguturia mo, ");
INSERT INTO bjz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","kambo enembomi beda urieta, Iesu dava ya teterugari mana-mana egeguturie-gea, aná embó bua ririva vitia, kambo fouva asumbea, kambo fou Iesu da iti kena righia ifegea, aná embó ghaitova vasia vitiria-nu, erimi ghaitova tino ea ituturieta, Iesu dava vovorurie. ");
INSERT INTO bjz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Vovorueta, númane aná embó jebugari-du gaabee egegutueta, Iesu umó gerurie-gea, aná kae bua vitiria embódu eghá ririe, “Anda mendi, inda ari akokogo nundubea gia dotore.” ");
INSERT INTO bjz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesu aghá rieta ningia, Moses da Gaga Irugari kakato* dumeni anava asusumbea vitiria manemi, númanda neno rova eghá nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aná embó mo, daiyagha daiyagha aghá reiri? Umó aná God aghago rirota, God da ragaro fara rouvie. God umó unuka enemboda ari akokogo nundubea gia dota rouvie. Jo embó einimi nundubea gia doambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aghá nundubutueta, Iesu unda asisimi númanda nundubari aná gerurie-gea, númandu eghá ririe, “Nímane daiyagha daiyagha reisi-nundubuto? ");
INSERT INTO bjz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Atá nundubea gigige! Niana mo rauko ro? ‘Inda sembago nundubea gia dotore!’ rari mo, rauko ra, aĩ? o ‘Erea, ghaito borea, deĩ ege!’ rari mo, rauko ra? ");
INSERT INTO bjz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Enanu ata gigigea, tanana egegaita rosoravore: ari akokogo nundubea gia, doarida ano Enemboda Jojabeedava* vitie.” Aghá rea kaverea, aná embó eka ingo takembari-du eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Amó indú rere, ‘Erea, inda ghaito borea bua, kambova ii!’” ");
INSERT INTO bjz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aghá ririeta, aná embó erea, unda ghaito borea bua, unda kambova irueta, enembo dano gigigea, duduku-dadaka egegea, mana-mana egeguturie. Aghade númane, God raga regeguturota, eghá regeguturie, “Namonde amó ivata eghago jo gambi vitara orekimi siroretueta reisi-gerore.” ");
INSERT INTO bjz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu rekago kaverea aria, Galili sao jojabeda betuva buburiturieta, natofo oruabe furia, undava bububuguturieta, tutuno ea iruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aghá ea doa irurota geruria mo, Alfius da mendi Levi unda takesi bari dobova asumbea irieta gia, Iesu na undú eghá ririe, “Erea, anda ambova fu!” ririeta, Levi erea, Iesu da ambova arie. ");
INSERT INTO bjz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Anada ambova, Iesu aria, Levi da kambova terua, undari dieta, takesi bari enembo dumenide, kotú ari akokogo enembo oruaruabede dano furia, Iesu unda ambo nimbide dano asusumbea, undari undidiguturie. Anada bee mo, unda yavero oruabe unda ambova tuvia igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aghá ueta, Moses da Gaga Kaifa ari kakatoda noniva vitiria Irugari kakatomi* gigiguturie-gea, Iesu da ambo nimbidu eghá regeguturie, “Umó, bee dodu nímanda irugari kato takesi bari enembode, kotú ari akokogo enembode dano asumbea undari reisi-neindi?” ");
INSERT INTO bjz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aghá regeguturieta, Iesu umó niningurie-gea, númandu eghá ririe, “Avona, ‘Andava kae tefo re,’ radua mo, ingi embó undava jo yambi aita rouvie. Kotú avona, ‘Amó kae bere,’ radua mo, ingi embó undava yaita rouvie. Amó enembo akokodu furere, jo enembo taubana ghogho raita furambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aghade, Jon da ambo nimbide, kotú Moses da Gaga Kaifa kakatoda* ambo nimbi tama egegutueta gia, enembo dumenimi furia, Iesu dava bubua, rea niningiguturie, “Jon da ambo nimbi, kotú Moses da Gaga kaifa kakatoda ambo nimbide dano, God du tama urota benunu eta rousue. Avotago, inda ambo nimbi daiyagha jo aghago mo, ambi egegeta rousu?” ");
INSERT INTO bjz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aghá regeguturieta, Iesu undufa iruguturota, númandu eghá ririe, “Nundubea gigige! Mendi gimasa evetu yagera aita rouvia-da banauva unda kokomana jo undari tama ambi egegaita rousue. Tago, fefera furá bubota, ená mendi gimasa data amburadua mo, númane fefera anava undari tama egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Atá gitofomi furá, aná embó nanandigea bua data amburadua mo, fefera aghade númane neno mema urota, tutuno ea undú tama egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Eembo-bo sei too barugadua mo, jo rekami divegea itia, tauta egegambi asire. Eembo-bo reka divegea tauta egegadora mo, tariri ea ghambugota bejea ya, too jojabe aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ari dabako aghagonu vaini reka jo bua, kofiri seiva averegota irambi aita rouvie. Aghá adora mo, vaini rekada anomi ata-gea, aná kofiri bejea, vaini rurukota vorea, akuago aita rouvie. Amindu, vaini reka aná kofiri rekava ruruketa rosore,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nangu Undari fefera einiva Iesu unda ambo nimbide farava govari vitiria aayo rova terua rekimbuturota, unda ambo nimbimi tutuno ea, faravada beenu undidigaita bubuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aghá egegutueta, Moses da Gaga Kaifa kakatomi* gigiguturie-gea, Iesu du eghá regeguturie, “Imó rei-gerora! Inda ambo nimbi dodu namonde anda Agho Dari bejiturota, Nangu Undari Feferava aghá rousu?” ");
INSERT INTO bjz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Aghá regeguturieta, Iesu na mino númandu eghá ririe, “Nímane anda ambo nimbidu gaa rera, aĩ? Devit unda kokomanededa baimana itatama ea, donu egeguturia-da gaga irugea gigigambi ra? Devit fristida* beforo righari embó ragaro Abiatar irita uria-da rifova, Devit unda kokomanade, God du Tafaroro Ari Kambova terua, farava ingari kakara, God da ragarova vesa ututuria-nu bua, Devit na undia, unda kokomana dumenidu ututurieta, undidiguturie. Aghá egeguturia-mi Agho Dari bebejeguturie. Fristi mane nenuka aná farava ingari kakara undidigasue. ");
INSERT INTO bjz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Enemboda taubanadu rea, Nangu Undari fefera ituturie. Jo enembonu Nangu Undari feferadu ambi re. ");
INSERT INTO bjz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aghá-gea, Enemboda Jojabee*, umó Nangu Undari Feferada Jojabee re.” ");
INSERT INTO bjz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aghade, Iesu rekago kaverea aria, nghaĩ itari kambova* teteruria mo, embó eini ingo dimbaride avo vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aghade, Moses da Gaga Kaifa kakato, Iesu itia bera-bera aita nundubuturota, umó utuvako kaaka ea gaita egeguturie. Anada bee mo, Nangu Undari feferava aná embó ingo dimbaride rasueta jebugasua mo, númane Iesu bua, koto egegasue. ");
INSERT INTO bjz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kaaka egegutua-du, Iesu aná embó ingo dimbaridedu eghá ririe, “Erea, eve vitifu! Enemboda dibeva jiradi!” ");
INSERT INTO bjz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aghá rea, natofodu uriga eghá urie, “Namonde anda Agho Darimi Nangu Undari feferava, enembo sonembari-du reiria, aĩ? Data amburari-du reiria? Kotú sonembota jebugari-du reiria, aĩ? Númandava mema utari-du reiria? Gigige!” aghá ririeta, númane mino undava gaga donu rari mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Númane aghá urieta, umó neno akuago ea, númanenu tatasegea gia, irurea biruru urota, kotú umó aná enemboda neno rova akuago gerurie-gea, neno mema urota, aná embódu eghá ririe, “Inda ingo ruruge!” aghá ririeta, aná embó unda ingo Iesu dava ruruguturieta, taubana urie. ");
INSERT INTO bjz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aghá urieta gigigea, Moses da Gaga Kaifa kakato* erea aria bubua, Herot da ambo nimbide desea, Iesu dedegota amburari-du manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Iesu unda ambo nimbide dano aná naa doa serigea aria, sao jojabe ragaro Galili anava bububuguturie. Aghade, enembo oruaruabe númanda ambova igiguturie. Atá, númane ená roo endavareta fufuguturie. Galili enembo, Judia enembo, Jerusalem enembo, kotú Idumea roo endava enembo, kotú Jordan uvu betu yoveni fefera vitari kena enembo, kotú Tair Saidon roo endava naa ijoijokokode, bogu naava enembo dano Iesu dava fufuguturie. Anada bee mo, Iesu da donu eta uria, anada bingá niningiguturie-gea, dano yuyumbea, númanda ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aria bubua, kambesi gigimbuturieta jariturie-gea, Iesu unda ambo nimbimi ghaa* eini simbugari-du, ririe. Anada bee mo, rourogo aná enembomi umó mimauve-degea, amindu ririe. ");
INSERT INTO bjz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Anada bee mo, sei kae bubugea vitiria enembo oruaruabe Iesu na ririeta, jejebuguturia-du, enembo kae bua vitiria enembomi unda tamova righaita furia, kambesi gigimbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aghá urota, enembo avodava taimu akokogomi asuguturieta irirota, umó gigiguturia aná, númane taimuda anomi fufugegutueta, unda eka tuva jujuguturota, koko regeguturota, eghá regeguturie, “Imó aná God da Mendi re.” ");
INSERT INTO bjz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aghá regegutueta ningia, Iesu númane rourogo umó avouro ananu isagha egegauve-degea bureguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aghade, Iesu aria dafaruva vitia, embobo avonu-avonu unda uno uria, aná nuenembo ghogho ririeta, undava fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Furia buburiturieta, umó aná embobo dano 12 gategea bua, númandu eghá ririe, “Nímane aná anda ambo nimbi re. Amindu nímane namonde danode deĩ aita rosore. Kotú nímane ya, minono rari-du rirota, ");
INSERT INTO bjz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","taimu akokogo tuvota bubarida anonu utota bua igigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gateguturota, Saimon da ragaro reka “Pita” ririkurie. ");
INSERT INTO bjz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Dumeni mo, Sebedi da sasingu, Jems ungá Jon ghanu gateguturie. Aghá ea doa, númanda ragaro reka aná Boanerjes ririkurie. Anada bee mo, “aná sasingu númane tararago” re. ");
INSERT INTO bjz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kotú embobo dumeni aná evere: Andru, Filip, Bartolomyu, Matyu, Tomas, kotú Alfius da mendi Jems, Tadius, Saimon da akau unda ragaro eini “Tuvari kato” re. ");
INSERT INTO bjz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Keriot embó Judas. Iesu bua gitofoda ingova ututuria, umó re. ");
INSERT INTO bjz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Anada ambova Iesu kambo einiva teterurieta, enembo oruaruabe rekago desuturieta, Iesu unda ambo nimbide asumbea, undari, undidigarida goroto eini jo tambambi re. ");
INSERT INTO bjz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Númane jo undaride uvude undambi iririgutueta, Iesu da jamena ningia, eghá regeguturie, “Umó beforo dinunu etua-jogo,” aghá rea, umó nandia bua igigaita egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aghade, Moses da Gaga Irugari kakato* Jerusalem reta fufuguturia-mi eghá regeguturie, “Aná taimu akokogoda barirari Belsebul (o Satan reta rosora) unona ano Iesu du utuaveta bua, anami taimu akokogo tuviaveta isaghava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aghá regeguturieta, Iesu na númane ghogho ririeta furia bububuguturieta, númandu kasia eini eghá ririe, “Satan daiyagha undufako bua fugadu? Aná tofo umouvego! ");
INSERT INTO bjz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Atá nímane ananu nundubea gigige! Frovensi einida natofo besiga ea, rorova sarigadua, aná frovensida ano righia yause-yause aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ari dabako aghago naa eini, kotú abua eini besiga ea, rorova sarigadua, aná naa kotú abua jo ano ea jiria irambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Atá, nímane amó Satan da anomi taimu bua fugari gaa rirota amindu, amó Satan da eini reisi-reravore. Atá, rata niningigadi! Satan da natofo, númane tofo-tofo besiga ea, rorova sarigadua, númane jo ano ea iririgambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atá, imó embó ano kato einida kambo bejea, unda eini-eini susughi aita nundubadora, sei unda eka ingo bundia itota vasiota-gea, ambova unda eini-eini bua yari, aná rauko re. Ari dabako aghago amó Asisi Kakarada anomi, Satan da ano buregea doa reaveta, unda taimu mane fuava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Amindu rea, Iesu eghá ririe, “Nundubea gigige! Amó gaa bee rere. Avona ari akuago ea, o gaga akuago rea, ambova unda ari-bari akokogo rouvia-nu isagha adua, God unda ari-bari akokogo nundubea gia doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Atá, avona Asisi Kakarada bingá fara adua, God aná ari akuago jo nanjigo aghade nundubea gia doambi aita rouvie, tumanadu aghá iraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu aghá riria-da bee mo, Moses da Gaga irugari kakato sei eghá regeguturie, “Iesu dava taimumi asugea vitie.” ");
INSERT INTO bjz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anada ambova, Iesu unda jamenade kotú unda ayade furia bubua, isaghava jiria, umó furá bubari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Enembo oruaruabe Iesu fugea rorogea asusumbea vitiria-mi, regeguturie, “Nie, inda jamenade isaghava jijiregea irirota, imó ya bubadi gigigaita uno rousue,” ");
INSERT INTO bjz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aghá regeguturieta, umó mino eghá ririe, “Anda ayade, kotú jamenade mo avouvi?” ");
INSERT INTO bjz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aghá rea, aná enembo asusumbea, umó rorogea vitiria ananu, gerurota ririe, “Gigige! Anda ayade jamenade, aná evere. ");
INSERT INTO bjz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Avona God da unonu adua, anda aya, anda ikoko mendi kotú anda ariri gharovu, aná númane re.” ");
INSERT INTO bjz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu aria, Galili sao jojabeda betuva rekago tutuno ea irugaita ueta, enembo oruaruabe furia, undava danode ea, kambesi gagajeguturie. Aghá uria-du, ghaa* eini uvuva fẽ ueta gerurie-gea, umó aria vorea, aná ghaa rova asumbuturie. Aghá urieta, natofo dano bubua, uvu betuva jijireguturie. ");
INSERT INTO bjz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Aghade, Iesu númandu gaga dumeni iruguturota, kasia eini eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nundubea gigige! Embó eini erea, unda aayova farava vee govaita rea iye. ");
INSERT INTO bjz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iya bubua, tutuno ea, vee gogotea bua ghasio etue. Etueta, vee dumeni begatava vovoregetueta, di manemi etia undidigetue. ");
INSERT INTO bjz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Kotú vee dumeni mo, singoi endava vorea, tutumi batuma-batuma etue-tago, enda ghandiba bee irambi-gea, feferami evia, riribu gambambi, sibi-sibi ea, gharasa etue. ");
INSERT INTO bjz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kotú vee dumeni, aná vive gingideda rova vorea, vivegha danode vitie. Amigha vitieta, vivemi afuregea sidara etueta, jo bee ambi etue. ");
INSERT INTO bjz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kotú vee dumeni enda taubanava vorea vivitigetue. Vivitigea, bee ririkigetua mo, dumeni 30, dumeni 60 o dumeni 100 aghago ririkigetue. ");
INSERT INTO bjz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nímane avona nghaĩde iradora, nghaĩ javea ningia goghó egege!” Iesu na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Enembo Iesu doa igigituria-da ambova, Iesu da ambo nimbi 12 de dano númanda kokomana dumenide furia, undava kasiada beedu uriga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Uriga ueta, Iesu númandu ririe, “Nímane anda ambo nimbi-gea, Afa God daiyagha unda natofo* kaifa eta rouvia-da gaga dumeni kivu uria-da bee nímandava isagha eta rore. Kotú, enembo dumenidava gaga dano kasiami irugeta rore. ");
INSERT INTO bjz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Aghá irugeta rora-da bee mo, evere: ‘Dibemi gari re-tago, gambigo egegari-du rea, kotú nghaĩmi ningari re-tago, ningambigo egegari-du rirota, aghá eta rore. Gia tanana urota, gaga niningigasua mo, númane neno kaverea, ari akokogo isagha egegasueta, nundubea gia doasire.’ God da gaga ananu nundubuturota, kasiami irugeta rore.” aghá rea sidara urie. ");
INSERT INTO bjz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Anada ambova, Iesu númandu uriga urie, “Nímane daiyaghami kasiada beedu mana-mana roso? Ambova amó rekago kasia radora, nímane daiyagha gigigado? Atá, kasia retora-da bee isaghava rata niningigadi. ");
INSERT INTO bjz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aná vee aayo govari katomi govetua, aná God da Gaga re. ");
INSERT INTO bjz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Vee dumeni emborova vovoregetua-da bee mo, evere. Enembo avona God da Gaga nininguaveta, Satan fuava, God da Gaga númanda neno rova rougea buta rouvia, ananu re. ");
INSERT INTO bjz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gari dabako aghago, vee dumeni singoi endava jua vovoregetua-da bee mo, evere: enembo avona God da Gaga niningigea, gangorogha buta rousua, aná númane re. ");
INSERT INTO bjz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tago, númanda gaabee ari jo jojabe irambi-gea, fefera tufoko irirota, númane gaabee egegutua-tago, dara o bouvu dumeni siroradua mo, riribu gambambi ea, gharasa ata-gea, God Afadu goitu fotaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Vee dumeni vive gingideda rova vovoregetua, anada bee evere. Enembo dumeni God da Gaga ningita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Tago, ambova númane irirota, eini-eini oruabenu neno nundubuturota, gugua-ghayafadu muu dirota, tamo firída uno ambo-ambo eta rousua-mi, God da Gaga gajituaveta, númanda gaabee arida bee jo sirorambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Avotago, vee dumeni enda taubanava vovoregetua, anada bee, evere: enembo avona God da Gaga ningia bua, kaifa eta rousua-mi, aná dumeni 30, dumeni 60 o dumeni 100 aghago ririkigeta rousue.” kasia riria-da bee Iesu na aghá isuri urieta niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu rekago kasia eini eghá ririe, “Namonde amó nanefa jo ovu rova fendambi eta rosore, o jo ghaito tuva nungambi eta rosore. Namonde amó nanefa jirari sinakefiva itiaveta janimbeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anada bee mo, eini-eini oreki nungia vitia, ambova furá isagha ata gigigari-du rea, nungiturie. Kotú eini-eini oreki kivu etueta vitia, aná ambova isaghava minono rata niningigari-du kivu urie. ");
INSERT INTO bjz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ená gaga retora, nghaĩ javea ningia goghó egege!” ");
INSERT INTO bjz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aghá rirota, umó rekago eghá ririe, “Nímane donu ningadora aná, nundubea goghó egege! Nímanda aito daiyagha komanadava fugadora, God nímandu aito dabako aghago fugiturota, dumeni etova utota bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Anada bee mo, Enembo avodava eini-eini oruabe iradua, anada etova oruabe utota baita rouvie. Tago, enembo avodava itoko iradua, aná rougea baita rouvie” Iesu na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu aghá rirota, kasia eini eghá ririe, “God da natofo* daiyagha oruabe eta rouvia, aná eghá re. Embó eini umó vee gogotea bua, endava ghasio ea dotuturie. ");
INSERT INTO bjz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aghá ea doa, anada ambova tumba onembo umó ya eviradua mo, kotú ya niavo deĩ uradua mo, aná vee batuma ea, vititigeta rouvie. Aná gari daiyagha vitita rouvia, aná umó gambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Endami ano unuka ututuaveta vee batuma ea vitia, bee righia momosa eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Momosa adua, aná embó eghá aita rouvie. Barida fefera bubia-du rea, embó unda buro kakato ninengota ya vikokomi divegea bubugaita rousue. Gari dabako aghagonu, aná enembo dumeni tutuno ea, God da Gaga nininguaveta gaabee ari sirorutuaveta, numane fuava unda sasingu eta rouvie,” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu ika ijoko, unda ragaro mastadi nu nundubuturota, kasia eghá ririe, “God da natofo* daiyagha oruabe eta rouvia, ");
INSERT INTO bjz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","aná ika mastadi da veemi vorea, batuma ea vitita rouvia, aghago re. Mastadi da vee mo, ijoijokoko re. Umó jo ika dumenida veego irambi re. ");
INSERT INTO bjz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tago vurinu, embó einimi bua ya, unda aayova govota vitadua, aná aayova vitia undari dumeni doa serigeta rouvie. Numbobe yavuava fafatu sarigeaveta, utumu siroreaveta dii mane fuava, númanda mogha utumuva gambuta rousue. Gari dabako aghago, God da Natofo tutuno iiava, oruabe eta rousue,” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu aná enemboda beforo gari, kotú neno nundubari gerurota, kasia aghagonu simbugea, númane irugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kasia tefo gaga eini jo rata, natofo jede niningigambi re. Avotago, umó unda ambo nimbide númane nenuka iririguturota, gaga dano isaghava reaveta niningigeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Fefera anada tumbade, Iesu umó ghaava* irirota, unda ambo nimbidu eghá ririe, “Egege, namonde sao yoveniva rekimbea igigore!” ");
INSERT INTO bjz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aghá ririeta, unda ambo nimbi ghaava vorea, aná enembo avo desea vitiria doa, númane ghaa dumenide siregea, sao yoveniva rekimbea aria, ");
INSERT INTO bjz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","rorova buburitueta, yaura yavata akuago bee erorurie. Erea, ghaa dea rosaita itoko ueta, Iesu ghaa ambova guto ga evirota irieta, unda ambo nimbimi evuruturieta, dibe fangiturieta, undú eghá ririe. “Irugari kato, namonde amó ambua sidara egegaita rosore. Eghá ua mo, imó daiyagha nundubambi vasia reve?” ");
INSERT INTO bjz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aghá regeguturieta, umó erea, yaura bureguturota, ininigha be fugia ririe, “Do! Binono ege!” aghá ririeta, yaura yavata tukú ea, binono urie. ");
INSERT INTO bjz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aghá urieta, umó númandu eghá ririe, “Nímane dodu oru egegeto? Nímandava gaabee ari tefo re,” ");
INSERT INTO bjz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aghá ririeta, númane oru ea, mino-mino rea niningiguturie. “Ariee! Ená embó daiyagha ro? Unona retueta, yaura yavata unda gaga ningie. Ari eghago, jo enemboda arigo irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu unda ambo nimbide dano sao jojabe, ragaro Galili, anava rekimbea aria, Gerasa enemboda roo endava, teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Terua, ghaa* ga doa vivitua mo, embó eini taimu akokogomi asuguturieta vitiria, umó uje singoi too ghambari rovareta bubua vorefuria, númane tafirie. ");
INSERT INTO bjz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Aná embó umó kambo tefo re, umó aná uje singoi toova irita urie. Embobo fuava, umó nandia eka ingo seini manemi bundeta urie. Aghá egegeta urie-tago, umó erari seini mane bununu eaveta, enembo umó nandia bundari mana-mana egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tumba onembo umó uje kasava ooto itiva biruru urota, koko rea, singoimi unda tamo vegea isorisori eta urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aghade, umó airo bee jiria, Iesu gerurie-gea, sumbua furia, dibe kena jua, koubomi jengiruturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Aghá ea, aná embó be jojabe koko rirota, eghá ririe, “Iesu, imó God Iti Bee Itivada mendi re. Imó andú donu aita uno ro? God da dibeva indava benunu rore. Andú mema mania utata!” Aghá riria-da bee mo, Iesu sei taimu aná embóda tamo roo doa serigari-du ririe-tago, jo bubambi irieta, ");
INSERT INTO bjz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu undava uriga eghá urie. “Inda ragaro doro? Rege ningore!” ririeta, mino eghá ririe, “Námanda ragaro ‘Oruabe re.’ Anada bee mo, námane oruabe desea vitere. ");
INSERT INTO bjz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Námane benunu rosore. Mania námane ninengota ená kambesi doa, kambesi einiva igigari-du rata!” ");
INSERT INTO bjz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aghade, gudoro jo airo bee irambi, anava naa oka mane oruaruabe 2,000 aghago undari undidigutueta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aná taimu akokogomi, Iesu du benunu eghá egeguturie, “Námane ninenge-gea, ya naa oka maneda tamo rova teterugore!” ");
INSERT INTO bjz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aghá regeguturieta, Iesu “Avore!” ririeta, taimu akokogo mane aná embó doa uvugea bububugea aria, naa oka manedava asusuguturieta, aná naa oka mane dano sumbua, kokava voraria, saova undidigea ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aghá egegutueta gigigea, aná naa oka mane kaifa kakatomi susumbugea aria, aná bogu naava bubua, kotú kasava vitiria naa dumeniva bububugea, númane donu geruria, aná isagha egeguturieta, enembo dano niningiguturie. Niningiguturie-gea, númane erea, aná gaga riria-da beenu niningigaita, kotú gigigaita rea, ");
INSERT INTO bjz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesu dava fufuguturie. Furia bubua, aná taimumi asuguturieta, beforo biruru ea vitiria embó, unda nundubari taubana urieta, umó boo urua asumbea irieta gigiguturie-gea, oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Atá Iesu daiyagha urieta, taimu akokogo aná embó doa vorea aria, naa oka mane dava asusuguturieta vorea, uvuva undia ambubugea sidara uria-nu, aná avona númanda dibemi gigiguturia-mi, isagha egeguturieta, natofo niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Niningigea, Iesu númanda kambesiva vitiria-nu doa serigari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Regeguturieta, Iesu aria, ghaava vovorueta, aná embó taimu akokogoda asusugea vitiria-mi furia, Iesu dava uriga urie, “Amó angá yara?” ");
INSERT INTO bjz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aghá ririeta, Iesu undú eghá ririe, “Tefo, imó jo namonde yambi aita roravore. Imó kaverea, inda enembo totofo dava ii! God indú neno mema urota, imó daiyagha sonembetueta jebugetora, ananu isagha ege, inda kokomana niningigoe!” ");
INSERT INTO bjz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iesu aghá ririeta, aná embó kaverea aria, frovensi Dekafolis anava biruru urota, Iesu undava donu uria-nu, reaveta, enembo dano niningigea duduku-dadaka ea, mana-mana egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu unda ambo nimbide dano kaverea, sao jojabe rekimbea aria, ghaa* ga vitia jijiregutueta enembo oruaruabe furia, umó fugea rorogea jijireguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aghá egeguturieta, nghaĩ itari kamboda* beforo righari eini, ragaro Jairus na furia, Iesu gia, unda eka tuva jua vavosurie. ");
INSERT INTO bjz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Aghá urota, ininigha undava benunu urota, eghá ririe, “Ariee! Anda ariri ijoko kae bua amburaita itoko rouvie. Fu ya, inda ingomi tamova righadi, jebugoe!” ");
INSERT INTO bjz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aghá ririeta, Iesu erea, numonde arie. Enembo oruaruabede dano umó fugea rorogea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Irueta, evetu eini furia, umó rorova tafirie. Aná evetu umó tatangu kae bua, tatangu gutiturota, ghaeko 12 sidara urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Umó ingi embobo dumenidava sonemba baita iru-furu eta urie-tago, númanda ingi ututa uria-mi, umó jo jebugambi re. Umó mema tumanadu itatama urota irita urie. Aghá urota, ingi embobodava yari furari urota, unda guri fugea, sidara urie. Urie-tago, unda kae jo sidara ambi irirota, aria jojabe urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aná evetu Iesu da bingá ningia erea, natofoda rova unda ambova aria, ");
INSERT INTO bjz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","unda tamo asugari sokuava ririkurie. Aghá uria-da bee mo, umó eghá nundubuturie, “Amó tefo, unda tamo asugariva righadora, amó jebugaita rore.” ");
INSERT INTO bjz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aghá nundubea, Iesu da tamo asugariva ririkueta, unda tatangu kae gaimbo ambi tukú ueta, itatama urota, “Amó jebugetore.” ");
INSERT INTO bjz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","nundubutueta, Iesu unda ano avodava rekimbuturia, umó tofo itatama urie. Itatama urota, tutomi enemboda rorova kaverea jiria eghá ririe, “Avona anda tamo asugariva righi?” ");
INSERT INTO bjz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aghá ririeta-gea, unda ambo nimbimi regeguturie, “Imó dodu aghá rere? Namonde amó natofomi fugea rorogetueta reisi-fora mo, avona imó sinia righari-du rere?” ");
INSERT INTO bjz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tago, Iesu umó avona unda tamo asugariva ririkuria-nu, gaita kavere-kavere, urie. ");
INSERT INTO bjz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kaverea gerueta, Iesu na undava daiyagha urieta jebuguturia, ananu nundubuturota, aná evetu umó orugha eka ingo dadada urota, Iesu dava aria bubua, unda eka tuva koubumi jengirea, undava donu siroruturia-nu dano, Iesu du ririeta niningurie. ");
INSERT INTO bjz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aghá ririeta, Iesu undú eghá ririe, “Anda ariri, inda gaabee arimi imó jebugetoravore. Aghá-gea, siriri indava iroe! Ii, jebugea iradi!” ");
INSERT INTO bjz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aghá ria, aghi kakato dumeni Jairus da kambovareta furia bubua, Jairus du eghá regeguturie, “Ariri ambue. Amindu rea, mania ená Irugari kato bua yaita nundubata!” ");
INSERT INTO bjz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aghá ririeta, niningurota, Iesu na Jairus du eghá ririe, “Mania oru ata! Gaabee ege!” ");
INSERT INTO bjz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aghá rirota, rourogo enembo numonde dano yauve-degea bureguturie. Buregea, Iesu na Pita, Jems kotú Jems da ikoko Jon, aghá bua numonde dano igiguturie! ");
INSERT INTO bjz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aria, Jairus da kambova bububuguturia enembomi yove gaje rieta, dari sorara ueta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu aria, aná kambo rova terua, númandu eghá ririe, “Nímane dodu yove gaje regeguturota, dari sorara roso? Ená ariri jo amburambi re, umó evo rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aghá ririeta, númane erea, umó kuvia gegha regeguturia-du, Iesu númane tuviturieta, buburiturieta, aná aririda nue numamo kotú unda ambo nimbi bakode numonde dano aria, aná aririda evari kambesiva teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Terua, Iesu aná ariri ingova righia eghá ririe, “Talita kumi!” anada bee mo, “Anda ariri, eradi rere.” ");
INSERT INTO bjz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aghá ria aghade, aná ariri jebugea erorurie. Aná aririda ghaeko aná 12 re. Aghá-gea, umó iru-furu ueta gia duduku-dadaka ea, mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mana-mana egegutueta, Iesu aná enembo rourogo natofo dumenidu isagha ata niningigauve-degea ininigha bureguturota, aná ariri undari utota undari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu erea, aná naa doa, unda ambo nimbide dano unda naa Nasaret aria bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Bubua irirota, Nangu Undarida feferava erea, nghaĩ itari kambova* aria terua, tutuno ea iruguturie. Irugutueta, enembo unda gaga riria-nu niningigea, duduku-dadaka ea eghá regeguturie. “Gigige, kambo itari kato namonde vitia mo, umó ra? Unda nue aná Meri unda jamena Jems Josep Judas de kotú Saimon re. Aghago unda gharototode dano eve namonde vitere. Númane dano ená naa enembo re. Umó jo embó jojabe eini irambi re. Amindu unda ano kotú neno nundubari niavo rururi? Umó daiyagha-daiyagha neno nundubuturota, ivata anogha dumeni-dumeni etueta siroretueta, reisi-gerore?” aghá rea, neno akokogo ea, umó fara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aghá urieta, Iesu mino númandu eghá ririe, “Ferovetada gaga enembo dano ningia, umó kakara egegeta rousue. Tago, feroveta tofo unda natofo, kotú sasingudemi, umó jo gaabee egeguturota, kakara ambi egegeta rousue. Amó nímanda eini re. Aghá-gea, nímane gari dabako aghago andú eta rosoravore. Amó jo gaabee ambi eta rosoravore,” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Enembo jo gaabee ambi uria amindu, umó ivata bouvu bee, kotú anogha oruago ari jo inono ambi urie. Unda dabako uria aná evere: umó kae bua irari enembo dumenida tamova unda ingomi righia ririeta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Enembo jo umó gaabee ambi egeguturia-du, Iesu duduku ea, mana-mana urota, Nasaret naa doa, naa dumeni, Nasaret da kasava vitia, anava biruru urota, enembo irugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesu unda ambo nimbi 12 nu aghi urieta, undava fufuguturie. Furia bububuguturieta, númane gategea ungagha-ungagha ninenguturie. Ninenguturota, umó taimu akokogo tuvarida ano númandu ututurota, ");
INSERT INTO bjz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","eghá ririe, “Nímane jo tutumi kaverea furambi aita rosoravore. Avotago, nímane eini-eini oruabe jo bua yambi egegaita rosoravore. Undari, guri kotú etota mane mania bua igigata! Nímane besia nuenembo bua igige! ");
INSERT INTO bjz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Nímanda eka andoro kotú nímanda tamo asugari asugea yaita rosoravore. Avotago, mania tamo asugari eini bua igigata. ");
INSERT INTO bjz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ya, naa einiva bubua, kambo niavo teterugota, enembo ‘Orokaiva!’ rirota, ghaito teno fufugegea gangorogha nímane bubugadua mo, aná kambova iririguturota, buro egegadi! Sidara ata, aná naa doa igige! ");
INSERT INTO bjz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kotú, enembo avona jo nímandu ‘Orokaiva!’ rirota, ghaito teno fugambi egegadua mo, aná naa doa seriguturota, nímanda eka ghandada avo dodovire-gea, númane ari akokogo rousua-nu tanana egegaita rousue.” Iesu aghá rea, númane ninenguturieta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Númane aria bubua, enembo neno kaverari-du rirota, minono reta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kotú númane taimu akokogo oruabe tuviturieta, enemboda tamo rovareta fuava isaghava bububugeta urie. Kotú númane ika ragaro olivi da muu sifirieta vitiria-mi, kae bua irari enemboda tamova gharea reaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Númane donu egegeta uria anada bingá, arieta Kini Herot niningurie. Anada bee mo, Iesu da bingá aná naa nanjogova sarigea aria, fafate urieta niningiguturie. Niningigea, enembo dumeni Iesu du eghá regegeta urie. “Jon Bafutaito Ari Kato God na ririeta, amburari vareta jebugea erora-jogo. Amindu umó ano jojabe bua, ená ari ivata anogha eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kotú enembo dumeni eghá regegeta urie, “‘God da feroveta ragaro Elaija rekago kaverea furaita rouvie,’ riria, aghajora, umó ra-jogo,” Kotú dumeni eghá regegeta urie. “Umó God da feroveta eini mambube maneda feferava irita uria ra-jogo,” ");
INSERT INTO bjz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kotú, Kini Herot aná bingá ningia, umó eghá ririe, “Jon Bafutaito Ari Kato anona ririeta, ukó diveguturieta ambubuturia, unona amburarivareta jebugea erea vitie.” ");
INSERT INTO bjz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Anada bee mo, Herot Jon dava eghá urie. Herot na unda ikoko Filip da evetu ragaro Herodias, unda ufuva yagera uria-du, Jon erea, Herot du gaga eghá reta urie. “Imó aná evetu yagera urota, agho dari bejitureravore.” Aghá reta uria-du, Herot na ririeta, unda embobo dumeni aria, Jon nandia bundia bua aria, diburava ituturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Amindu, Herodias umó Jon du neno akuago urota, umó data amburari-du uno urie. Urie-tago, Herot umó fafota urie. Amindu aná evetu Jon dari mana-mana urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mana-mana uria-da bee mo, Herot geruria mo, Jon embó taubana kotú kakarago bee re. Aghá-gea umó Jon du oru urota, umó tavo eta urie. Tavo urota reaveta, Jon fuava undava gaga reaveta ningia gangoro eta urie. Tago, umó mana-mana urota, nundubari jojabe eta urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias Jon daita nundubuturota irieta, Herot da sirorari fefera furia buburiturieta, umó goroto tafirota eghá urie. Herot gavanada kokotofu unda mene-mene ari kakatoda babarigari, kotú frovensi Galili da embobo jojabebei aná frovensiva irita uria-nu, dano aghi jufirieta furia, danode egeguturieta, númandu banau urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Banau ueta, Herodias da ariri aria terua, daa didivueta gia, Herot unda esega enembode dano gangoro egeguturie. Amindu, Herot na aná ariridu eghá ririe, “Inda uno rege, ningore! Imó dodu benunu adora, amó indú utaita rore!” ");
INSERT INTO bjz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aghá rea, be anogha gajiturota eghá ririe, “Imó donu uno adora-nu, rege utaitare! Anda kaifa eta rora roo enda gategota, dibe ungagha ata, dibe eini baita radora, amó utaitare.” ");
INSERT INTO bjz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aghá ririeta ningia aria, nuedava bubua rea niningurie. “Amó donu benunu a?” ririeta, nue mino undú eghá ririe, “Imó Jon Bafutaito Ari Katoda beforonu benunu ege, utoe!” ");
INSERT INTO bjz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aghá ririeta ningia, aná ariri kaverea, bibitami sumbua aria, kini dava bubua, benunu urie. “Jon Bafutaito ari katoda beforonu divegea tevova fendia utota, bofu, bare!” ");
INSERT INTO bjz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aghá ririeta ningia, Kini Herot neno mema urie. Tago, esega enembo banauva buburituria-da dibeva be anogha gajituria-nu nundubea, umó verua ea, aná aririda benunu ningia doari mana-mana urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aghá riria-du, unda mene-mene ari kato einimi, dibura kambesiva Jon da ukó divegea, beforo bua furari-du ninenguturieta arie. ");
INSERT INTO bjz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aria, dibura kambesiva terua, Jon da ukó divegea, beforo tevova fendia bua furia, aná ariridu ututurie. Ututurieta bua aria, nuedava ututurieta rururie. ");
INSERT INTO bjz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aghá egeguturieta, Jon da ambo nimbi aná bingá niningigea doa aria, unda tamo bua furia furuguturie. Jon da amburari aghá uria-nu nundubuturota, Herot na Iesu da bingá ningia, Jon kaverea furari gaa nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aghá egeguturia-da ambova, Iesu da ambo nimbi kaverea furia bubua, númane donu egeguturia-de kotú iruguturia-de dano, Iesu dava isagha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aghá regeguturia-da ambova natofo jede númandava yari furari egegutueta, Iesu unda ambo nimbide dano asumbea, undari undidigarida goroto jo tambambi re. Amindu, Iesu númandava eghá ririe, “Fufuge, namonde itoko airo ya, enembo tefo kambesiva nangu undidigore!” ");
INSERT INTO bjz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aghá rea, ghaava* vorea, enembo tefo kambesiva rekimbea igigutueta, ");
INSERT INTO bjz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","enembo oruabe dibe fugia, númane sao jojabeva rekimbutueta gigiguturota, númane tanana egeguturie. Amindu, númanda naa dano doa, uvu kasava sei susumbugea aria bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu ambova bubua, ghaa ga vitia geruria mo, natofo jededu neno mema urie. Anada bee mo, númane eto-bato oka ragaro sifi, kaifa kato tefo, aghagonunundubea, tutuno ea, irugari dibe eini be eini númandu iruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Irugutueta, jama ueta, unda ambo nimbi 12 furia, undava eghá regeguturie, “Fefera sidara etue. Kotú, ená kambesiva enembode kambode tefo re. ");
INSERT INTO bjz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amindu rea, ená enembo ninenge ya, naa dumeni itoko airo anava guri utua, undari bua undidigoe!” ");
INSERT INTO bjz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aghá regeguturieta, Iesu númandu eghá ririe, “Undari nímanena ututuge, undidigoe!” aghá ririeta, númane mino undú eghá regeguturie, “Imó rei-nundubutora mo, námane ya marabe 8 buro ea barida inono gurimi* farava bua furá utota undidigari-du rirota rera, aĩ?” ");
INSERT INTO bjz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aghá regeguturieta, umó númandava eghá ririe, “Nímandava farava nanjogo ro? Ii, gigigadi!” ririeta, númane aria gia doa kaverea furia, undava regeguturie, “Farava ingari ingo yoveni kotú uvu oka ungagha re,” ");
INSERT INTO bjz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aghá regeguturieta ningia, umó unda ambo nimbidu eghá ririe, “Enembo regege, unda dibe-dibe kirisava asusumboe!” aghá ririeta, númane aria, ");
INSERT INTO bjz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","regeguturieta, aná enembo dibe-dibe sarigea dumeni 100, kotú dumeni 50 aghago asusumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Asusumbuturieta, Iesu aná farava ingari ingo yovenide uvu oka ungaghade bua, dibe jará ea uutuva urota, God Afadava “aiye” rirota, aná farava ingegebea, enembodu vesa egegota undidigari-du rea, unda ambo nimbidu ututurie. Aná uvu oka ungagha beago ingegebea, enembodu vesa urieta undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Vesa egeguturieta, bua dirieta, inono uria-da faravade uvu okadeda itoto dumeni dodoguturia-nu Iesu da ambo nimbimi erea bua, kanda jojabebei dano 12 fefendiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Embobo undari undidiguturia, aná inono 5,000 aghago re. Tago evevetu sasingu manede jo irugambi re. ");
INSERT INTO bjz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Undari undidiguturia-da ambova, jo gaimbo ambi, Iesu tatavami unda ambo nimbi ririeta, ghaava* vorea, yoveniva rekimbea naa ragaro Betsaida igigutueta, umó aná natofo nineguturieta tará egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aghá ea, umó ootova avo benunu aita yavurie. ");
INSERT INTO bjz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aghade, jama ea, fefera vovorurieta, umó unuka aná kambesiva irieta, númane ghaava rekimbea aria, rorova buburitueta, ");
INSERT INTO bjz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","yaura dibe kena furueta ghaa davituria, jo inono ambi urie. Aghá egegutueta, gerurie-gea, rifoda bingoiva Iesu vorea, uvu etova deĩ ea, unda ambo nimbidava arie. Aria, ghaa serigaita ueta, númane dibe fugia gigigea, taimu gaa rea, koko-koko regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Anada bee mo, númane Iesu gerurota, dano orumi jajareguturie. Númane oru egegutua, Iesu gerurie-gea, amindu númandava eghá ririe, “Amó reta! Mania oru egegata! Ano egege!” ");
INSERT INTO bjz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aghá rea, Iesu umó aria, ghaa rova vivitueta, yaurada torú-torú sidara urieta gia, númane neno mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Anada bee mo, númane nendufa egeguturieta, neno fakara urieta, Iesu da ano númandava iruguturota, farava vesa urieta, natofo undidiguturieta, inono uria-da bee, númane jo tanana egegambi re. Aghagonu, umó númandava buburiturieta, yaura tukú ea, binono uria-de dano, númane jo tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aghá egeguturia-da ambova, númane rekimbea aria, roo enda ijoko Genesaraet anava terua, ghaa* gaiturie. Genesaraet rera-va, kambesi gevoto, kotú anada rova naa ijoijokoko dumeni irita urie. ");
INSERT INTO bjz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ghaa ga vivitueta, enembomi dibe fugia, Iesu gia tanana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tanana egeguturie-gea, númane tatavami erea aria, númanda kambesiva naa nanjogova bububugea, kae bua irari enembo bua, ghaitova itia, Iesu naa niavo iria-da bingá niningigea, undava fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Umó niavo irita uria, naa jojabebeide ijoijokokode kotú aayo dobova enembo unda bingá niningigea, kae bua irari enembo utua bari kambesiva bua fufuguturie. Bua furia bubua, Iesu na “avore” rata, aná kae bua vitiria enembo undava bubua, tefo unda eembo soriva sinia righia jejebugari-du, benunu egeguturie. Aghá egeguturia enembo dano, jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Moses da Gaga Kaifa kakatode, kotú Irugari kakato* dumenide, Jerusalem reta furia bubua, Iesu dava danode egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Danode egeguturia aghade, Moses da Gaga Kaifa kakatomi Iesu da ambo nimbi númanda ingo mane jo seseghegambi undari bua undidigutueta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Reisi-gerora? Moses da Gaga Kaifa kakatode kotú Jiusi enembode dano númanda mambube maneda evovomi donu iruguturia, ananu ambo-ambo egeguturota, ingo mane jo seghambi irirota, undari jo bua undidigambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Númane utua bari kambesiva reta kaverea fuava kambova terua, númane ingo seghambi irirota, undari jo undidigambi eta rousue. Númane aghade, mambube maneda nundubari dumeni kaifa urota, rorode, ovude, kotú tevode dano seseghegeta rousue.) ");
INSERT INTO bjz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amindu Moses da Gaga Kaifa kakato, kotú Irugari kakato Iesu du uriga egeguturie, “Dodu inda ambo nimbi namonde anda mambube maneda evovo iruguturia, ananu ambo-ambo ambi ingo dongorogha irirota, undari bua reisi-neindi?” ");
INSERT INTO bjz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aghá regeguturieta, Iesu na mino númandu eghá ririe, “Nímane aghagago ari kakato-gea, God na daiyagha ririeta, Aisaia nímandu gefiria aná gaa bee re: ‘Ená enembo númanda bemi amó kakara ari gaa reta rousue-tago, númanda neno roo, aná airo bee re. ");
INSERT INTO bjz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Númane amó tumogha baĩ eta rousue. Tago, bee eini tefo re. Amindu avo sonembari eini jo tambambi egegaita rousue. Anada bee mo, númane eto nenomi egeguturota, anda Gaga doa, enemboda irugaride, kotú nundubaridenu anda Gaga aghago rirota irugeta rousue.’ God na aná gaga ririeta Aisaia na nímandu rea gefirie. ");
INSERT INTO bjz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nímane aná enemboda nundubarinu iruguturota, God da Agho Dari goitu fotitureravore,” ");
INSERT INTO bjz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aghá rea doa, Iesu na númandu rekago eghá ririe, “Nímane God da Agho Daridu goitu fotiturota, nímanda agho darinu ambo-ambo urota viteravore. ");
INSERT INTO bjz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Amó dodu eghá rera, aná irugota gigigaita rosoravore. God ririeta, Moses na eghá gefirie, ‘Nie nimamoghadu sabua* urota, númanda gaga ningia ambo-ambo ege!’ Aghago ‘… enembo eini avona nue o numamodu tauga kavavana radua mo, dege amburoe!’ ");
INSERT INTO bjz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Tago, nímanda irugeta rosora aná evere: embó eini nue numamoghadu goitu fotiturota, ‘Amó nímane sonembasire-tago, anda gugua-ghayafa ená korban re.’ radua, aná nímane rourogo nue numamogha sonembauve-degea buregeta rosoravore. (Korban da bee, aná eini-eini God dava vesa utari re.) ");
INSERT INTO bjz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aghá urota, nímane God da Gagadu goitu fotiturota, niabua maneda nundubarinu rirota, gaa bee gaa regegeta rosoravore. Kotú, nímane nundubari dumeni aghago irugeta rosoravore,” Iesu na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Anada ambova, Iesu na rekago ririeta, natofo jede desiturieta, eghá ririe, “Nímane dano nghaĩ javea niningiguturota, tanana egegadi rere! Nímane reisi-nundubutora, enembo ingo jo seghambi undari bua undadua, anami unda asisi bebeta adua? ");
INSERT INTO bjz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tefo! Nímane eini-eini donu undadora, anami nímanda neno roo jo bebeta ambi aita rouvie. Tago, gaga donu nímanda bevareta bubaita rouvia-mi nímanda neno roo bebeta aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ananu niningigadi, rere.” ");
INSERT INTO bjz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aghá rea, aná enembo avo doa, Iesu unda ambo nimbide dano kambo rova teteruguturie. Teteruguturia-da ambova, unda ambo nimbimi aná isuri ari gaga riria-da beedu uriga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uriga egeguturieta, Iesu na númandu eghá ririe, “Nímane daiyagha mana-mana roso? Nímane jo niningigea tanana ambi eta rosoravore. Isaghava eini-eini donu undota enemboda urova voradua-mi jo ata, númanda neno roo bebeta ambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Anada bee mo, aná jo ya, unda neno rova terambi aita rouvie. Aná ya urovareta jegha dano voraita rouvie.” Iesu aghá riria-mi, rei-irugutue: undari donu undidigadora, aná taubana re. ");
INSERT INTO bjz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kotú, rekago eghá ririe, “Enemboda neno rovareta bubuta rouvia-mi eaveta, númane bebeta eta rousue. ");
INSERT INTO bjz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Anada bee mo, ená ivata dibe eini be eini enemboda neno rovareta fuava bubuta rousua-mi, enembo bebeta egegeta rousue: nundubari akokogo, viro kombo tefo-tafo ari, bagia ari, enembo data o righota amburari, komanada evetu o embógha viro kombo kivumi ari, ");
INSERT INTO bjz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","daghari ari, jii dimbari, guri baita enembo kuvirari, dita faima ari, mandudu ari, komanada tamova gavera rari, gangoro yavi ari, neno righambi tefo-tafo ari, ");
INSERT INTO bjz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ená ari akokogo nanjogo enemboda neno roo vareta fuava bubuta rousua-mi númane bebeta egegeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Anada ambova, Iesu aná naa doa aria, gitofoda bogu naa ungagha ragaro Tair de Saidon deda roo endava embó einida kambova teterurie. Unda uno uria mo, umó daiyagha ea, nungegimi ya terasua aghago uno urie-tago, umó jo nungia yari inono ambi urie. ");
INSERT INTO bjz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Anava ariri ijokoko taimumi asugea vitiria-da nuemi, Iesu da bingá ningia tutumi erea furia, Iesu da eka tuva jua vavosurie. ");
INSERT INTO bjz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aná evetu aná Grik embóda ariri re. Frovensi Sairofonisia anava siroruturie. Aná evetumi furia, taimu unda ariri ijokokodava asugea vitiria-nu, tuvota isaghava bubari-du rirota, Iesu dava benunu urie. ");
INSERT INTO bjz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aghá urie-tago, Iesu na eghá ririe, “Imó gi, sasingu maneda undari bua ninodu utari, aná jo taubana irambi re. Sasingu mane sei númanda uno undidigea inono asue!” ");
INSERT INTO bjz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aghá ririeta, aná evetu mino eghá ririe, “Ae, Jojabee, aná gaa bee reravore. Tago, sasingu undari undita rousua-da susundo jua vovoreguturarinu, nino mane undidigeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aghá ririeta, Iesu undú mino ririe, “Imó gaa bee reravore. Avoreta kambova ii, gadi! Imó gaga mino taubana retora-du aná taimu akuago aririda tamo rova vita-nu seibe tuvetueta rei-buburitue,” ");
INSERT INTO bjz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aghá ririeta, umó kaverea aria, kambova buburituria mo, taimu akuago unda ariri dava aná vorea arieta, unda ariri vasia irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Anada ambova, Iesu Tair bogu naa doa aria, Saidon bogu naa serigea, Dikafoles Frovensi rekimbea aria, Galili sao jojabe anava buburiturieta, ");
INSERT INTO bjz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","enembo dumeni erea, embó eini nghaĩ gogorede kotú be gungadenu bua furia, Iesu dava bububuguturie. Númane Iesu na unda ingomi aná embóda tamova righari-du benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Benunu aghá egeguturieta, Iesu erea, aná embó bua, ungá unuka airo aria, unda ingo taruadarimi aná embóda nghaĩva sinia ga, unda visoghanu bua, aná embóda avevava daviturie. ");
INSERT INTO bjz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aghá ea, dibe uutuva urota, osio rirota, unda gaami aná embódu “Efata!” ririe. Anada bee mo, “Ifege!” ");
INSERT INTO bjz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aghá ria, aná embóda nghaĩ ifegea, aveva yavi urieta, gaga taubana ririe. ");
INSERT INTO bjz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Aghá urieta, avo desuturia enembomi gia duduku ea, mana-mana egeguturota, eghá regeguturie, “Umó donu eta rouvia-da bee taubana siroreta rouvie. Gigige! Umó etueta, aná embóda nghaĩ ifegea, aveva yavi ea gaga reirie,” Avotago, Iesu na númane isagha auve-degea bureguturie. Tago, númane unda gaga ningambi urota, isagha egeguturieta aria, fafate urie. ");
INSERT INTO bjz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Fefera jo numbo ambi anada ambova enembo dumeni aná oruaruabe furia, danode egeguturie. Aghade, enembo undari donu undidigasua, aná tefo-gea, Iesu unda ambo nimbi ririeta, undava furia, danode egeguturieta eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Amó ená enembodu neno mema rore. Anada bee mo, númane namonde vitago, fefera bakode egegetua-mi, númanda undari aná sidara egegetue. ");
INSERT INTO bjz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Atá, amó númane undurambi ninengota igigadua, dumeni rorova baimanami ambubuguturota yaita rousue. Anada bee mo, enembo dumeni roo airobe reta fufuguta.” ");
INSERT INTO bjz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aghá ririeta, unda ambo nimbi mino eghá regeguturie, “Ená mo, enembode kambode tefo kambesi re. Undari inonova niavo bua, enembo utota undidigari aná jo inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aghá regeguturieta, Iesu na uriga urie, “Atá nímandava farava ingari nanjogo viti?” ririeta, mino eghá regeguturie, “Farava ingo yoveni ingo yoveniva ungagha aghá vitie.” ");
INSERT INTO bjz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aghá ririeta, Iesu aná natofo jede desituria-du ririeta forosegea, endava asusumbuguturieta, umó farava ingari ingo yoveni, kotú ingo yoveniva ungaghanu bua, God du “aiye” rea righia ingegebea, unda ambo nimbidu utua, embobodu vesa egegota undidigari-du ririeta, unda ambo nimbi aghá egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kotú númandava uvu oka ijoijokoko vitiria beago, Iesu na bua, God du “aiye” rea, unda ambo nimbimi faravade dano vesa egegota, natofo undidigari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Aghá egeguturieta, embobo dano undidigea inono egeguturie. Anava embobo desituria dano 4,000 re. Aghade, evevetu sasingu manede undidiguturie-tago, númane jo irugambi re. Aná enembo undidigea, inono bee egeguturieta, Iesu da ambo nimbimi kanda dano 7 bua, undarida itoto fefendiguturieta beda egeguturieta, Iesu aná enembo ninenguturieta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aghá egeguturia-da ambova, númane aria, ghaava* vovoregea, unda ambo nimbide dano kambesi ragaro Dalmanuta rekimbea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Moses Da Gaga Kaifa kakato* Iesu kuvia gigigaita rea furia, ivata anogha eini God da ano vitia-mi irugota, gigigaita benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aghá regeguturieta, Iesu oeno numbobe asegea doa, eghá ririe, “Orekida fefera mo, enembo dodu anona ivata anogha ata gigigaita reisi-ri? Amó nímandu gaa bee raita rore. Natofo oreki sirorea vitera, númandu ivata anogha donu eini jo ata sirorota gigigambi aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aghá rea, númane avo doa, umó kaverea furia, sao yoveniva rekimbaita rekago ghaava* vovorurie. ");
INSERT INTO bjz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aghade, Iesu da ambo nimbi farava ingari neno itia, inonova jo bambi, dabako bua, numonde furia, Iesu de dano ghaava* vovoreguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Vovoregea irurota, Iesu na númandu kasia gaga eini eghá ririe, “Gia goghó egege! Moses da Gaga Kaifa Kakato* kotú Kini Herot da farava ingarida yisti du goitu fofotege!” ");
INSERT INTO bjz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aghá ririeta, númane tutuno ea, nenukako mino-mino uriga egeguturota ririe, “Unda eghá retua-da bee mo, aghajora, namonde amó jo farava eini bua furambi etora-du retua-jogo.” ");
INSERT INTO bjz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Númane aghá regegutua, Iesu umó gerurie-gea, númandu eghá ririe, “Nímane dodu farava ingari inono irambi gaa rea, manaka reisi-gaito? Nímane gambi kotú ningambigo viteravore. Nímane nendufa egegutueta neno fakara ea vitie. ");
INSERT INTO bjz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nímane dibe soiki, nghaĩ gogore ra? Enanu nundubea gigige! ");
INSERT INTO bjz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Amó farava ingari ingo yoveni ananu righia ingegebea, enembo dano 5,000 undutara-da itoto mane bua, kanda nanjogova fefendiguta?” aghá ririeta, númane mino eghá regeguturie, “Námane kanda dano 12 fefendigutare.” ");
INSERT INTO bjz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Kotú amó farava ingari dano ingo yoveni, kotú ingo yoveniva ungagha aghago righia ingegebea, embobo dano 4,000 aghago undutara-da itoto mo, kanda nanjogo fefendiguta?” Iesu aghá rea niningurieta, númane mino eghá regeguturie, “Kanda dano ingo yoveni, ingo yoveniva ungagha fefendigutare.” ");
INSERT INTO bjz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aghá regeguturieta, Iesu mino eghá ririe, “Nímane daiyagha gia tanana ambi roso?” ");
INSERT INTO bjz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Anada ambova númane furia, Betsaida naava bububugea, anava enembo dumenimi embó eini dibe soikidenu bua furia, Iesu dava bubua, unda ingomi aná embónu righota, jebugari-du benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aghá regeguturieta, Iesu aná embó dibe soikide ingova righia bua aria, naa kasava bubua, aná embóda dibeva visogha urie. Kotú, Iesu da ingo mane aná embóda tamova righia, uriga urie, “Imó eini-eini dumeni isaghava rei-gerora?” ");
INSERT INTO bjz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ririeta, aná embó dibe jará ea gia, eghá ririe, “Amó enembo aná rei-gerore-tago, númane aná eto-bato ika manemi deĩda arigo rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aghá riria-du, Iesu unda ingo ungaghami rekago aná embóda dibeva ririkurieta, aná embóda dibe taubana ea goghó urieta, eini-eini dano isaghava gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aghá ea, Iesu na aná embódu eghá ririe, “Mania aná naa rorova kaverea yata! Dambu inda kambova ii!” ");
INSERT INTO bjz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aghá rea doa, Iesu unda ambo nimbide aria, naa dumeni Sisaria Filipai kasava bububugaita igiguturota, emboro rorova unda ambo nimbidu eghá ririe, “Nímane regege, ningore! Enembo andú mo, daiyagha regegeta rousu?” ");
INSERT INTO bjz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aghá ririeta, unda ambo nimbi dumeni mino eghá regeguturie, “‘Imó aná Jon Bafutaito Ari Kato re,’ reta rousue, kotú dumeni mo, ‘Imó aná Elaija gaa,’ reta rousue, kotú dumeni mo, ‘Imó aná feroveta sei eini gaa,’ reta rousue,” ");
INSERT INTO bjz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aghá regeguturia-du, umó númandava uriga eghá urie, “Atá nímane mo, andú daiyagha regegado?” aghá ririeta, Pita eghá ririe, “God, enemboda ari-bari akokogo nundubea gia doaita rirota, Embó eini utaita riria, imó re.” ");
INSERT INTO bjz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aghá ririeta, Iesu númandu eghá ririe, “Amó avouvi, mania enembo avodu radi, ningauveta!” ");
INSERT INTO bjz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aghá riria-da ambova, Iesu tutuno ea, unda ambo nimbi iruguturota eghá ririe, “Enemboda Jojabee* mema bouvu dibe eini be eini itatama aita rouvie. Babarigaride fristida* kokotofude, kotú Agho Dari irugari kakatodemi* umó injigha egegea, bua dedegota amburaita rouvie-tago, fefera bakodeda ambova umó rekago jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu aná gaga riria, númandu isuri ea goghó urie. Urieta, Pita na umó bua aria, kasava jiria, bureguturota dibe beva gaa ininigha ririe. ");
INSERT INTO bjz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Aghá ririeta, Iesu umó kaverea, unda ambo nimbinu tatasegea gerurota, Pita du dibe beeva eghá ririe, “Satan, amó doa serige! Amó mania buregata! Inda nundubari aná jo God davareta furambi re-tago, enembo davareta etie.” ");
INSERT INTO bjz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aghá rea doa, aná desuturia enembode unda ambo nimbidedu eghá ririe. “Andava fufuge! Nímane avona anda ambo nimbi ea, namonde deĩ aita uno egegadora mo, nímanda uno dodogea, anda uno nuenembo egeguturota, anda ragarova amburari-du jo oru ambi egegaita rosoravore. Aghá egeguturota, namonde danode iru-furu egegadi rere. ");
INSERT INTO bjz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Anada bee mo, avona endava gugua-ghayafa nundubuturota, amburari-du oru ea, andú goitu fotadua, fefera ambova umó amburaita rouvie. O avona andú, kotú anda Gaga Taubanadu amburadua mo, fefera ambova jebuga tumanadu irari baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Avotago, embó eini endada gugua-ghayafadu neno rururota, dano righia jiriturota, jebuga tumanadu irarida emboro kasovigea amburadua mo, gigige! ");
INSERT INTO bjz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Unda gugua-ghayafami jo sonembota, jebuga tumanadu irari bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kotú eini mo, avona anda irugaridu meka rei-gerua, kotú oreki ari bari akokogo urota, God jo nundubambi rousua enemboda dibeva Enemboda Jojabeedu meka adua mo, ambova amó God Afada unana rova unda anera kakarade dano vorefuraita rosora feferava, amó aná embódu meka aita rore.” ");
INSERT INTO bjz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aghá rea doa, rekago eghá ririe, “Amó nímandu gaa bee rere. Enembo dumeni enava vitia, jo amburambi iririguturota, God unda natofo* kaifa arida rifo anogha dano furota, númanda dibemi gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aghá rea doa, onembo ingo yoveni yoveniva dabako sidara uria-da ambova, Iesu erea, Pita bua, Jems unda ikoko Jon gha bua, nenukako dafaru yafabe einida itiva yayavuguturie. Anava bubua, unda ambo nimbi gigigutueta, Iesu da gari aná kaverea, eini urie. ");
INSERT INTO bjz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kotú unda asugari dighari dano janimbea saghai urie. Endava enembo avona eini-eini segheaveta, saghai eta rouvia aghagonu irambi re. ");
INSERT INTO bjz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aghade, Iesu da ambo nimbi bakode gigigutueta, Moses ungá Elaija gha isagha ea, Iesu de gaga regegutueta, ");
INSERT INTO bjz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita na bee fangea Iesu du eghá ririe, “Irugari kato, namonde amó eve desea vitera, aná taubana re. Aghá-gea, námane dobo bakode, eini indú, eini Moses du, kotú eini Elaija du aghá simbugaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aghá riria-da bee mo, Pita de Iesu da ambo nimbi ungaghade aná orumi jarea goghó egeguturota, Pita gaga daiyagha riria, umó jo nundubuturota rambi re. ");
INSERT INTO bjz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aghá rieta, goosomi vorefuria, númane afureguturieta, gooso rova be fugia eghá ririe, “Ená anda neno bari mendi re, unda gaga donu radua-nu, niningige!” ");
INSERT INTO bjz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aghá rieta, númane tutumi kaverea, aná kambesi mane gia iruruturia anava, enembo eini jo gambi, Iesu unuka numonde vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aghá ea, númane dafaru vareta vorefurota, Iesu númane bureguturota eghá ririe, “Nímane donu gigigetora, mania enembodu regegata! Do-gea, Enemboda Jojabee* amburarivareta jebugea erota, anada ambova regegadora, aná avore.” ");
INSERT INTO bjz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aghá ririeta, númane unda donu riria aná niningiguturie-tago, númane unuka uriga egeguturie. “Umó aná amburarivareta erari gaga retua-da bee mo, doro?” aghá rea niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kotú Iesu du uriga egeguturie, “God Embó eini utota furaita rouvie. Tago, bee dodu Moses da Agho Dari Irugari kakatomi* ‘Elaija sei furaita rouvie.’ reta rousu?” ");
INSERT INTO bjz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aghá ririeta, mino eghá ririe, “Aná gaa bee re. Elaija na sei furá, aná Embó God na utaita riria-da emboro simbugaita rouvie. Tago, bee dodu Enemboda Jojabee injigha urota, undú mema bouvu utari da gaga gembari viti? ");
INSERT INTO bjz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tago, amó nímandu eghá rere, Elaija umó seibe furie-tago, undú donu gembari vitia-nu urota, númane undava donu aita uno uria aghagonu urota, undú mema ututurie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aghá rea doa, anada ambova númane aria, ambo nimbi dumenidava buburituria mo, enembo oruaruabe kotú Moses da Gaga irugari kakato* dumenide dano furia, Iesu da ambo nimbi dumenide besiga rousuria-va bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aghade, aná enembomi Iesu avo gigiguturia gia, duduku-dadaka egeguturie. Aghá egegea, undava yuyumbea aria, umó ghanena egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Aghá urieta, Iesu unda ambo nimbidava uriga urie. “Nímane ená enembode besiga dodu roso?” ");
INSERT INTO bjz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aghá ririeta, aná enemboda rorova embó einimi eghá ririe, “Irugari, amó anda mendi indava bua etere. Anada bee, taimu unda tamova irirota eaveta, umó gaga jo rambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aná taimu undava asugarimi fugeaveta, umó endava juta rouvie. Aghá urari kusúde beghiride be toova bubua, kotú diitu ghotaka ea, eka ingo dagaya gaeta rouvie. Amindu, inda ambo nimbimi anda mendida tamova vitia taimu tuvota vorari-du benunu etore-tago, númane aghago ari jo inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aghá ririeta, Iesu na unda ambo nimbidu eghá ririe, “Nímandava gaabee ari tefo re. Amó fefera yafa daiyaghago namonde irirota, nímanda mema bouvu fumba? Avota, aná mendi bua, andava fufuge!” ");
INSERT INTO bjz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aghá ririeta, aná mendi bua, undava furueta, aná taimumi Iesu gerurie-gea, aná mendi bua fugiturieta, endava jua, otai-vatai ea, kusúde beghiride be toova buburiturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aghá ueta, Iesu na aná mendida numamodu uriga urie, “Inda mendi dava taimu mo, fefera domi asuguturi?” ririeta, aná mendida numamomi ririe, “Umó sirorea, itoko baria, jojago ueta asuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Asugea, aná taimu umó ená mendi dea amburaita rea bua fugeaveta, ivari etova juta rouvie. Kotú fugeaveta, uvuva degimbeta rouvie. Amindu, imó inono iradora mo, námandu sonembaita roravore,” ");
INSERT INTO bjz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aghá ririeta, Iesu undú mino ririe, “Mania bouvu andu utata! Imó gaabee ege! Enembo avona gaabee adua mo, eini-eini dano inonova ata, taubana aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aghá ririeta niningurie-gea, aná mendida numamo be fangea eghá ririe, “Anda gaabee ari aná itoko re. Tago inona sonembadi-gea, anda gaabee ari ano ae!” ");
INSERT INTO bjz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aghá rieta, enembo oruaruabe furia, danode egeguturieta, Iesu aná taimu tuviturota, dibe beva ririe, “Anona imó enanu rei-tuvitoreta, ená mendi doa serige! Inona ená mendidava asugea irirota, umó righia bee gunga ea, kotú nghaĩ righia gogore ea vitara-du, imó enanu rei-tuvitoreta, rekago mania ená mendidava asugata!” ");
INSERT INTO bjz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aghá ririeta, aná taimu koko rea, aná mendi bua fugiturieta, jua eka ingo dadada ueta, umó furia buburiturie. Buburiturieta, aná mendi eto-bato amburari enembogo urie. Aghá urieta gerurie-gea, enembo dano, “Aee! Ená mendi ambue,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tago, Iesu aná mendi ingova righia ghambuguturieta, erorurie. ");
INSERT INTO bjz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Anada ambova, Iesu unda ambo nimbide aná enembo avo doa, númane aria, kambo rova terua, númane nenuka asusumbea, unda ambo nimbimi undú uriga eghá egeguturie, “Námane tuvetora, daiyagha taimu vorambi etu?” ");
INSERT INTO bjz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aghá regeguturieta, Iesu na númandu eghá ririe, “Taimu dumeni jo tefo regegadi-gea, kasava vorambi aita rouvie. Nímane gaabee urota, benunu egegadora, aná taimu kasava voraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Aghá rea, aná naa doa aria, Galili Frovensi avo bubua, rekimbea irurota, unda amburaita rouvia-da gaganu unda ambo nimbidu isuri uria-du, umó niavo vitiria-nu enembo dumenimi tanana egegasua, umó jo uno ambi re. Isuri urota, eghá ririe, “Enemboda Jojabee* enembomi bua, gitofoda ingova utota, númanena umó dedegota ambua, fefera bakode sidara adua-da ambova, umó rekago amburarivareta jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Aghá ririeta, Iesu da ambo nimbi mana-mana egeguturie. Kotú unda gagada beedu uriga ari númane oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aghá rea doa, numonde Iesu de dano aria, naa ragaro Kaperneam avo bububuguturie. Bubua aria, kambo einida rova teteruguturie. Aghade, Iesu na uriga eghá urie. “Nímane emborova fururota, dodu besiga uta reisi-fa?” ");
INSERT INTO bjz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Aghá riria, númane gaga mino jo regegambi re. Anada bee mo, beforo righari avona asua-du emborova besiga egeguta fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Amindu rea, Iesu asumbea, unda ambo nimbi 12 ririeta furia, undava danode egeguturieta, eghá ririe, “Avona nímanda barirari aita radua embó, umó undufa itota vorea ambo jetugo aghago ea, nímane nanjogoda sabua* embó aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aghá rirota, umó sasingu mane eininu bua, númanda rorova oghimbea, númandu eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Umó avona anda ragarova sasingu mane eghagodu gangorogha ‘orokaiva’ rirota, ghaito teno fugadua, umó andú aita rouvie. Kotú, avona andú ‘orokaiva’ rirota, ghaito teno fugadua, umó jo anuka andú ambi Afa amó nininguturieta furera-du beago, aghagonu aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Aghá ririeta, Jon na eghá ririe, “Irugari kato, embó einimi inda ragarova taimu tuvitueta gia, doari-du buregetore. Anada bee mo, umó jo namonde anda eini irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aghá ririeta, Iesu na mino eghá ririe, “Avotago, ambova mania buregata! Anada bee mo, umó avona anda ragarova taimu tuvaita rouvia, kotú eini-eini dumeni aghago aita rouvia, umó jo tutomi kaverea, angá gitofo ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Númane avona namonde andú gitofo jo ambi adua, aná namonde anda tofo re. ");
INSERT INTO bjz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amó gaa beenu nímandu raita rore. Avona nímandu, ená Kerisoda ambo nimbi re, rirota sonembea nímandu uvu dimbua utadua, umó aghá aita rouvia-da mino jo serigambi baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kotú enembo avona, amó gaabee eta rousua sasingu maneda eininu kuvirota, ari akuago adua, taubana mo, singoi jojabenu unda ukóva dighia fugasueta, uvu kafuruva degimbasue. ");
INSERT INTO bjz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Aghagonu, inda ingomi ata, imó ari akuago adora mo, tafugea fuge! Aghá ea, imó ingo taukaka irogo ambua, jebuga tumanadu irari tambadora, aná taubana re. Atá, aghá ambi irogo, ari-bari akuagoda mino utari kambesiva ivari tumanadu reivia-va voradora, bouvu kotú mema jojabe itatama aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kotú, inda ekami ata, imó ari akuago adora mo, tafugea fuge! Aghá ea, imó eka taukaka irogo ambua, jebuga tumanadu irari tambadora, aná taubana re. Atá, aghá ambi irogo, ari-bari akuagoda mino utari kambesiva ivari tumanadu reivia-va voradora, bouvu kotú mema jojabe itatama aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kotú, inda dibemi ata, imó ari akuago adora mo, gunjia fuge! Aghá ea, imó dibe taukaka irogo ambua, God unda natofo* kaifa aita rouvia kambesiva teradora, aná taubana re. Atá, aghá ambi irogo, imó ambua, ari akuagoda mino utari kambesiva voradora, bouvu kotú mema jojabe itatama aita roravore. ");
INSERT INTO bjz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Anava rifami enembo gambuta rouvia, aná jo gambua doambi aita rouvie, kotú ivarimi enembo evita rouvia aná, nanjigo aghade jo sona ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Anada bee mo, enembo nanjogo dano númanda etova God na ireri rarovarigo aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ireri aná taubana re. Tago, ireri musisi ea sororo ea ya, vivi sidara adua mo, daiyagha ata-gea, unda vivi rekago siroradu? Aghago, enemboda neno bari damé-damé adua, aná akuago re. Amindu nímane mino-mino neno rururota, siriride dano iririge!” ");
INSERT INTO bjz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aghá ea, Iesu aná kambesi doa erea, Judia Frovensi aria, uvu Jordan rekimbuturia-da ambova, natofomi bubua, undava desea irieta, fefera inono unda irugeta uria gaganu númandava iruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aghade, Moses da Gaga Kaifa kakatomi* furia, umó kuvia gaita, eghá regeguturie, “Imó rege, niningigore! Namonde anda Agho Dariva embó unda evetu doarida emboro vitia?” ");
INSERT INTO bjz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aghá regeguturieta, Iesu na númandu, mino eghá ririe, “Atá Moses mo, Agho Dari nimandu doreta ututuri?” ririeta, ");
INSERT INTO bjz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","númane mino undú eghá regeguturie, “Embó avona evetu doaita nundubuturota, unda evetu bee dodu doaita rouvia-da ingiso gembua utota bata, unda evetu ninengota yari-du rasua, Moses beago avore rasue.” ");
INSERT INTO bjz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aghá regeguturieta, Iesu na mino eghá ririe, “Nímane beforode nenode dano fakara bee-gea, Moses aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tago, God da Gaga amindu eghá reirie, ‘Tutunova God endade uutude ea, kotú eini-eini nanjogo uria-da ambova embó ea, kotú evetu urie.’ Gaga aghago eini aná evere: ");
INSERT INTO bjz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘Amindu, embó unda nue numamo doa, ya evetugha takembea, ungá tamo dabako aita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amindu God da bua danode takembadua, rourogo enembomi righia gategauve-degea rere.” ");
INSERT INTO bjz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aghá rea doa, númane aria, kambova bubua terua, unda ambo nimbimi aná gagada beedu Iesu dava uriga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aghá regeguturieta, umó mino númandu eghá ririe, “Embó avona unda evetu doa, evetu reka yagera adua, umó aghá ea, viro kombo kasava ari embó aghago aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aná emboro dabako aghagova evetu avona unda embó doa ya, embó rekadava vai adua, umó aghá adua-mi viro kombo kasava ari evetu aghago aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iesu na ingo beforova ititurota sasingu mane ijoijokokoda tamova isambara ea simbugari-du rea, enembo dumenimi sasingu manenu bua undava fufuguturie. Aghá egeguturia mo, Iesu da ambo nimbimi injigha egeguturie-gea, gaa regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aghá egegutueta, Iesu neno akuago ea, númandu eghá ririe, “Sasingu mane mania buregata! Do-gea, andava fufugoe! Anada bee mo, avona neno kaverea, ená sasingu manego adua, númane God unda natofo* kaifa ariva teterugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Amó nímandu gaa bee rere, enembo avona God da natofo kaifa ari kambesiva teraita nundubuturota, sasingu manego ambi adua, númane jo teterugambi aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aghá rea doa, umó sasingu mane ingomi oghimbea rururota, unda ingo númanda beforova ituturota ea simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Anada ambova, Iesu rekago yaita rea, irueta, embó einimi sumbua furia, unda dibe kena koubomi jengiruturota, eghá uriga urie, “Irugari kato, imó embó taubana re. Amó daiyagha-daiyagha ea, tumanadu irarida jebuga ba?” ");
INSERT INTO bjz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aghá ririeta, Iesu na mino undú eghá ririe, “Imó dodu andú taubana reto? Enembo eini avona jo taubana irambi re-tago, God umó unuka taubana re. ");
INSERT INTO bjz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Atá, Agho Dari dano imó gari re. Amindu mania enembo eini data amburauveta, mania komana einida evetu o embógha kasava viro kombo ata, mania bagia ata, mania osagho fufirota, gavera rata, mania kokomana kukuvirota bagia ata! Nie nimamoghadu sabua* urota, númanda gaga ningia, ambo-ambo ege!” ");
INSERT INTO bjz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aghá ririeta, aná embómi eghá ririe, “Irugari kato, amó sirorea, mendi ijoko vareta furera, ená vitera-va Agho Dari dano kaifa eta rore.” ");
INSERT INTO bjz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aghá ririeta, Iesu kaverea, umó gia neno rururie. Ea doa, eghá ririe, “Imó dabako jo ambi viteravore. Ii, inda eini-eini dano bua utua, guri bua, makasi enembodu vesa ea doa, imó fu, anda ambova deĩ adi! Aghá adora, imó ambova ya gugua-ghayafa uutuva baita roravore,” ");
INSERT INTO bjz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aghá ririeta, aná embóda gugua-ghayafa oruaruabe-gea, umó Iesu da gaga ningia, dibe be enjirogo-enjirogo urota, neno memagha dano kaverea arie. ");
INSERT INTO bjz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aghade, Iesu dibe unda ambo nimbidava urota, eghá ririe. “Enembo gugua-ghayafade furá, God da natofo* ari, aná fakarago bee re.” ");
INSERT INTO bjz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aghá ririeta, unda ambo nimbi unda gaga ningia, duduku-dadaka ea mana-mana egegutueta, Iesu na rekago númandu eghá ririe, “Anda sasingu, God da natofo ari aná fakarago re. ");
INSERT INTO bjz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Atá, oka kamero nu nundubea gigige! Umó ninongu tova jo terua ya, yoveniva bubambi aita rouvie. Atá, umó avo terari, aná rauko bee re. Tago, enembo gugua-ghayafademi God da natofo ari, aná fakara bee re.” ");
INSERT INTO bjz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aghá ririeta, niningigea duduku-dadaka egegea, mana-mana egeguturie-gea, mino-mino uriga egeguturie, “Atá, imó aghá rera mo, jebuga avona badu?” ");
INSERT INTO bjz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aghá regeguturieta, Iesu númane tatasegea gerurota, eghá ririe, “Enembomi ari jo inono irambi re-tago, God mo, eini-eini nanjogo ari inono bee re.” ");
INSERT INTO bjz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aghá ririeta, Pita na Iesu du eghá ririe, “Námanda eini-eini dano ambomi utua doa, inda ambo tuvia fufugutare.” ");
INSERT INTO bjz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ririeta, Iesu mino eghá ririe, “Amó nímandu gaa bee rere. Avona andú, kotú anda Gagadu rea, unda kambo, unda ikoko mendi, unda ariri gharovu, unda nue numamo, unda sasingude, kotú unda enda doadua mo, unda enda, kambo eini-eini, ikoko mendi, ariri gharovu, aya afa oruaruabe rekago ená endava irirota bua, jebuga tumanadu irari beago tambua baita rouvie. Atá, aghade umó andú gaabee eta rouvia-du, umó mema jojabe tambua, itatama aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tago, oreki kofiri rousua enembo oruabe kaverea furá, ambo egeguturota, ambova reisi-fua enembo furá ya, kofiri egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu kofiri jiria, unda ambo nimbi dano unumbea, Jerusalem igiguturota, aná gaga ririeta niningigea, unda ambo nimbi duduku-dadaka egeguturie. Kotú, enembo dumeni nemonde igiguturia, aná oru egeguturie. Aghade, Iesu unda ambo nimbi 12 nu bua airo jiria, undava donu siroraita rouvia-nu tutuno ea iruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iruguturota, eghá ririe, “Niningige! Namonde amó Jerusalem reisi-vitifore. Yavá bubadora mo, Enemboda Jojabee* dubo ata, fristida* kokotofude kotú Moses da Gaga Irugari kakatodemi* umonu bua, data amburari-du regegaita rousue. Aghá ea, namonde amó Jiusi enemboda gitofoda ingova itaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ititigota, umó bua, kuvia gegha rirota, visogha unda tamova ea, ikami dea, umó bua ya dedegota amburaita rouvie. Ambua, fefera bakode sidara ata, anada ambova umó rekago amburarivareta jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aghá iruguturia-da ambova, Sebedi da sasingu, Jems ungá Jon gha furia, undava bubua, eghá regeguturie, “Irugari kato, námanda uno eini, imó námandu adora?” aghá regegeturieta, ");
INSERT INTO bjz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu númandu eghá ririe, “Amó nímandu donu ari-du reisi-rere?” ");
INSERT INTO bjz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aghá ririeta, númane mino undú eghá regeguturie. “Inda kini da anode unana duroghade badora aghade, radi-gea, námane eini inda ingo beekenava, eini anda kenava asusumbore!” ");
INSERT INTO bjz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aghá regeguturieta, Iesu umó daiyagha amburaita rouvia, ananu nundubuturota, númandu eghá ririe, “Nímane bee dodu benunu rosora, jo gerurota rambi rosoravore. Afana aagha andú utota bua dirota, mema itatama aita rora, aghagonu nímane itatama ari inono ra? Amó bafutaito fakarago adora mo, nímane dabako aghagonu bafutaito egegadora? Amó mema daiyagha itatama urota amburaita rora, aghagonu egegadora? Gigige!” ");
INSERT INTO bjz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aghá ririeta, númane mino eghá regeguturie, “Námane inono re.” aghá regeguturieta, Iesu númandu mino eghá ririe, “Avore, nímane anda undaita rora aaghava undaita rosoravore. Kotú, amó daiyagha bafutaito egegota itatama aita rora, mema dabako aghagonu itatama aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tago, anona anda ingo bee kena kotú anda kena asumbaita rousua enembo, gategari jo inono irambi re. Anda ingo bee kena o anda kena avona asumbaita rousua, aná Afa na undufa simbugea gategota asusumbaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aghá ririeta, Iesu da ambo nimbi dano ingo ungaghami aná bego amboghada gaga regeguturia-nu niningigea, Jems ungá Jon ghadu neno akuago egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aghá egeguturieta, Iesu ghogho ririeta, númane furia undava danode egeguturieta, eghá ririe, “Nímane reisi-geroravore, endava abua-abua avodu kotofu gaa regegeta rousua, númanda uno nuenembo egegaita rousue. Númanda tuva vitia enembodava ano tefo re. Númane aná kokotofu rera-da rari ningari re. ");
INSERT INTO bjz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tago, nímanda rorova jo aghagonu egegambi aita rosoravore. Avona nímanda barirari jojabe aita uno adua mo, umó enembo nanjogoda sabua* aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kotú, enembo avona kofiri righaita uno adua mo, umó nímanda rorova enembodu sabua aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Anada bee mo, Enemboda Jojabee* enembo nanjogodu sabua ea vitie. Enembomi undú ara-kera ari-du jo furambi re. Unda jebuganu ututurota, enembo nanjogo sonembota, jebuga bubugari-du rea furie.” ");
INSERT INTO bjz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aghá rea sidara ea doa, anada ambova númane furia, Bogu Naa Jeriko buburiturie. Kotú, anavareta unda ambo nimbide, natofo oruabe nemonde dano igiguturie. Aghade mo, Timeus da mendi dibe soikide, ragaro Bartimeus na emboro kasava asumbea begera urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Atá, umó avo asumbea irirota, Nasaret embó ragaro Iesu furia utuvako ueta ningia, tutuno ea koko rirota eghá ririe, “Iesu, Kini Devit da mendi God na utaita riria, imó re! Amindu, neno mema ea, amó sonembe!” rieta, ");
INSERT INTO bjz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","enembo oruabe umó be doari-du bureguturota regeguturie-tago, umó jo itoko doambi re, umó koko rirota, rekago be jojabe ghogho ririe, “Ariee! Devit da Mendi, andú neno mema ea, sonembe!” ");
INSERT INTO bjz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aghá ririeta ningia, Iesu tukú ea jiria, eghá ririe, “Regege, furota gare!” ririeta, númane aná embó dibe soikidedu be fugia eghá regeguturie, “Neno gangorogha ere! Iesu, imó furadi reirie.” ");
INSERT INTO bjz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aghá regeguturieta, Bartimeus unda sokua kosugea fugea doa, duduku ea erea, Iesu dava furie. ");
INSERT INTO bjz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Furia buburiturieta, Iesu undú eghá ririe, “Amó indú donu ari-du uno ro?” aghá ririeta, aná embó dibe soikidemi mino eghá ririe, “Irugari kato, inona rasueta, anda dibe ifegasueta rifoda unana gasire!” ");
INSERT INTO bjz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aghá ririeta, Iesu mino eghá ririe, “Avota, ii, inda gaabee arimi imó jebugetoravore.” aghá ririeta, aná embóda dibe ifeguturieta, umó erea, Iesu da ambova arie. ");
INSERT INTO bjz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Anada ambova, Iesu unda ambo nimbide dano Jerusalem bubaita igiguturota, anava naa ungagha Betfeij Betani gha ooto ragaro Olivi vitia, anava bubua, unda ambo nimbi ungagha sei ninenguturota, ");
INSERT INTO bjz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","isuri ari gaga eghá ririe, “Igige, nímanda dibe kena naava teteruguturota, oka donki da mendi, avo buri ari vitia-nu gigigaita rosoravore. Enembo eini jo sei aná okada etova asumbea iru-furu ambi re. Ananu vuregea bua kaverea, eve fufuge! ");
INSERT INTO bjz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Atá, enembo avona gia uriga adua mo, eghá regege, ningoe, ‘Jojabee na uno etue. Tago, jo gaimbo ambi rekago bua kaverea furaita rosore.’ aghá regege!” ");
INSERT INTO bjz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aghá ririeta, ungá umó aria, emboro kasava aná donki buri urieta, bebato kena irieta gigiguturie-gea, vureguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vuregutueta, enembo dumeni anava jijiregea vitiria-mi gerurie-gea, uriga egeguturie, “Dodu aná donki rei-vureguto?” ");
INSERT INTO bjz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aghá ririeta, númane mino, Iesu da riria aghagonu ririeta-gea, númane dotuturieta bua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aná donki bua furia, Iesu dava bubua, númanda dighari-ombari etova asugea vitiria-nu kosugea bua, aná oka donki da goituva beisi urieta, Iesu vitia avo asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Aghá ea, Iesu tutuno ea, eka rurugea irueta, natofo jede númanda etova asugari mane kosugea, emborova beisi egegetueta, dumeni ika igi mane didiveguturia-nu bubugea, emborova beisi egegutueta, Iesu anada etova fatia arie. ");
INSERT INTO bjz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Aghade, enembo dumeni dibe kena, kotú dumeni unda ambova jijireguturia-de dano, koko fugia eghá regeguturie, “Orokaiva! Orokaiva! God du raga regegore! Umó avona Jojabeeda ragarova bubua reifia-du, raga regegore! ");
INSERT INTO bjz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Namonde anda Afa, Kini Devit da Mendi eini namonde amó kaifa aita rei-fia, aná umó re. Undú raga regegore! God du raga regegore! Orokaiva, orokaiva!” Aghá rea, naa rorova vuria dasea ueta, Iesu vitia arie. ");
INSERT INTO bjz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aria, Jerusalem bubua, God du Tafaroro Ari Kambo* rova teterurie. Terua, eini-eini dano gia, irurutueta, fefera seibe aria, jama urie. Jama uria-du umó bubua, unda ambo nimbide kaverea, Betani naava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Evia, rifogha Iesu erea, Betani reta kaverea fufuguturota, baimana itatama urie. ");
INSERT INTO bjz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aghade, Iesu dibe fugia yari banunava geruria, ika simbiagonu, unda igimi gajea irieta gerurie-gea, vorea unda beenu utuvako jiria gaita arie. Tago, umó aria ika tuva jiria geruria mo, avo bee eini jo gambi urie. Anava igi nuenembo gerurie. Anada bee mo, aná ikada bee ari oya irambi-gea, amindu tefo gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aghá gerurie-gea, Iesu aná ika simboro urota, eghá rieta, unda ambo nimbi niningiguturie, “Enembo avona jo rekago inda bee bua undidigambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anada ambova númane aria, Jerusalem bubua, Iesu aria, Tafaroro Ari Kamboda* ghouka rova terua, anava vesa dungarida dii oka utua, guri buta rousuria enembo tuviturota, guri yayo ari enemboda farode guridenu righia saveregea, dii uku utua, guri reisi-rururia enemboda asumbari beago righia savereguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kotú, umó jo doata-gea, enembo eini avona eini-eini dumeni bua, Tafaroro Ari Kambo rova terua ya, yoveniva bubambi re. ");
INSERT INTO bjz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aghá ea doa, Iesu na enembo avo iruguturota, eghá ririe, “Nímane gigige! God da Gagava eghá gembari vitie. ‘Anda kambo aná roo endava enembo nanjogoda benunu egegari kambo re.’ Tago, nímanena egegetueta, anda Kambo aná bagia enemboda nungegi ari kambo aghago ea vitie.” ");
INSERT INTO bjz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aghade, fristida* kokotofude kotú Moses da Gaga Irugari kakatode* dano ená gaga niningiguturie-gea, númane Iesu data amburari-du emboro dumeni tava egeguturie. Tago, númane oru egeguturie. Anada bee mo, natofo jede Iesu da irugaridu duduku-dadaka ea mana-mana egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aghade, jama uua, Iesu umó unda ambo nimbide aná bogu naa doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Anada ambova númane rifogha erea deĩ uta aria mo, aná ika simbiago evia gharasa ea irieta gigiguturie. Aná ika daiyagha ufude, kotú riribude dano gharasa urie. ");
INSERT INTO bjz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iesu da ika simboro uria-nu nundubuturota, Pita na Iesu du eghá ririe, “Irugari kato, ená ika inda simboro utara evia, gharasa ea vitieta, gi!” ");
INSERT INTO bjz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aghá ririeta, Iesu na mino eghá ririe, “Inda gaabee ari God dava itadi rere. ");
INSERT INTO bjz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Amó nimandu gaa bee rere. Avona unda gaabee ari God dava ititurota, mana-mana jo ambi ená dafaru sofú ea voriya, karajeva degimbari-du radua, aná aghagonu aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amindu, amó nímandu rata niningigadi rere! Nímane dodu benunu egegadora, nímane baita rora aghagonu gaabee egeguturota, donu benunuva ititigadora, aná utota baita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Amindu imó jiria benunu urota, inda neno akuago kokomana dava aná nundubea gia do! Aghá ege-gea, Afa uutuva vitia-mi inda ari akokogo daiyaghago ro, aná nundubea gia doae!” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aghá rea, rekago kaverea aria, Jerusalem bubua, Iesu unda ambo nimbide aria, God du Tafaroro Ari Kambova* teterugutua mo, fristi* maneda kokotofude, Moses da Gaga Irugari kakatode* kotú Jiusi enemboda babarigaride dano furia, eghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Imó mo, avona retueta ená buro ro? Kotú imó avoda ragarova ená buro eta ro?” ");
INSERT INTO bjz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aghá regeguturieta, Iesu na mino eghá ririe, “Amó nímandu uriga eini aita rore. Anda urigada mino regegadora, amó avona ririeta, ená buro rora, rata niningigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Avota, regege, ningore! Jon Bafutaito Ari Kato, Bafutaito arida ano mo, God dava rururia aĩ, endava enembodava rururia? Ananu rege, ningore!” ");
INSERT INTO bjz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iesu aghá ririeta, númane nenukako mino-mino rea niningiguturie, “Namonde ‘God dava’ regegadora, umó eghá raita rouvie, ‘Atá, dodu Jon gaabee egegambi roso?’ ");
INSERT INTO bjz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kotú, namonde amó ‘Endava enembo dava’ regegadora, namonde dara bubugaita rosore.” Aghá regeguturia-da bee mo, enembo dano nundubeta egeguturie, “Jon aná God da feroveta eini re.” ");
INSERT INTO bjz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Amindu, númane mana-mana ea, mino eghá regeguturie, “Námane jo tanana irambi re.” Aghá regeguturieta, Iesu na mino ririe, “Nímane aghá regegetora-du, amó avona ririeta, ená buro rora, jo rata nímane niningigambi aita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aghá rea doa, Iesu tutuno ea, kasia eini númandava eghá ririe. “Aayo numamo eini unda endava vaini da ghavesi govea, kara ea ovenembea, vaini bee simbia muu barida orukoda too ghambea simbugea, vaini kaifa ari kakatoda ghagha yafabe eini itia, guri utota baita rea, aná kaifa kakatoda ingova utue. Aghá ea, aná embó erea, roo enda einiva iya asumbetue. ");
INSERT INTO bjz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Avore, aná ghavesida vuri rategarida rifo bubieta, aayo numamo unda sabua, buro ari kato eini vaini da bee bua furari-du, ninengetueta iye. ");
INSERT INTO bjz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iya bubia mo, aná aayo kaifa kakatomi erea, aná buro ari kato dedegea tuvetueta kaverea, ingo tefo iye. ");
INSERT INTO bjz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aghá etua-du, aná aayo numamo rekago unda buro ari kato embó eini ninengetueta etia bubia mo, umó beago detue. Ea, beforova dea baghetueta tatangu buburitueta, kuvia gegha regeguturota, tauga kavavana regegetue. ");
INSERT INTO bjz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aghá egegetueta, anada ambova umó rekago unda buro kato eini ninengetueta iya bubieta, númane umó dedegetueta ambue. Aghá egegutueta, anada ambova, aná aayo numamo unda buro kakato dumeni ninengetue. Aghá etueta, dumeni dedegetueta, oru susumbugetue, kotú dumeni dedegetueta ambubugetue. ");
INSERT INTO bjz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aghá ea sidara egegutueta, ambo jetuko aná unda neno bari mendi unda tofo nuenembo jiretue. Avore, unda mendi tofo nu ninenguturota eghá retue, ‘Anda mendimi yaita rouvia-du verua egegaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Aghá rea, itieta iye-tago, aná aayo kaifa ari kakato, númane tofo-tofo eghá regegetue, ‘Oná gimasa etia bubia, aná aayo tofoda mendi re. Egege, namonde umó dedegota amburota, unda eini-eini nanjogo dano namonde anda tofo ae!’ ");
INSERT INTO bjz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aghá regegea, aná mendi aayo rorova nandia dedegetueta ambueta bua ghambugea bubua etia, aayo kasava fugetue. ");
INSERT INTO bjz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Avore, gigige! Atá, aghá egegadua mo, aná aayo numamo mo, daiyagha adu? Umó eghá aita rouvie. Umó furá bubua, aná aayo kaifa ari kakato, data ambubugota, aná aayo bua, enembo dumenida ingova utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aghá rea, tofo undufa iruguturota ririe, “Ená God da Gaga iruguturera, aĩ, tefo? ‘Singoi eini kambo itari kakatomi injigha ea doa fugituria-nu Jojabee na bua, unda kambo roro tutumbudu itia simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ená Jojabeeda ari re. Unona ea davirea deghasembuturieta, namonde amó gia duduku-dadaka eta rosore.’” ");
INSERT INTO bjz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aghá ririeta niningigea, fristida* kokotofude Moses da Gaga irugari kakatode*, kotú Jiusi enemboda babarigaridemi Iesu nandia bundaita egeguturie. Anada bee mo, Iesu númane nundubuturota aná aayoda kasia riria-nu ningia, tanana egeguturie. Aghá tanana ea, umó nandia bundasue-tago, númane enemboda nundubaridu oru egeguturota, umó doa seseriguturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Anada ambova, fristida* kokotofude, Moses da Gaga Irugari kakatode*, kotú Jiusi enemboda kokotofude erea, Moses da Gaga irugari kakato dumenide kotú Herot da noni dumenide dano ninenguturieta, Iesu kuvia gaita igiguturie. Númanda uno mo, Iesu gaga sembago rasueta-gea, bua ya koto egegasue. ");
INSERT INTO bjz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aghá ea furia, Iesu du eghá regeguturie, “Irugari kato, námane gigigeta rosore, imó embó taubana bee re. Aghá-gea, imó God da Gaga bee nuenembo irugea goghó eta roravore. Enembo, kokotofu ra, o makasi enembo ra, danode imó inonova buta roravore. Amindu rege, niningigore! Namonde anda Agho Darimi reiria mo, daiyagha egega? Namonde anda gitofo Rom enemboda kotofudu takesi mo utara, aĩ, doara? Rege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aghá regeguturieta, númane umó kuviraita rea, aghagago egeguturia-nu geruria gia, eghá ririe. “Nímane dodu amó rekukuve? Guri* eini bua fu, gare!” ");
INSERT INTO bjz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aghá ririeta, undú guri eini ututurie. Ututurieta, bua gerurota, uriga urie, “Atá, ená imumude ragarode mo, avoda ro?” aghá ririeta, númane mino eghá regeguturie, “Rom enemboda Jojabee Sisar da re,” ");
INSERT INTO bjz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Avorego, Sisar da tofo aná undú ututuge, bae! Kotú God da tofo aná God du ututuge, bae!” Aghá ririeta, númane ningia, duduku-dadaka ea, mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Avore, aná Jiusi enemboda noni eini, Sadyusi* enemboda rari mo, enembo amburarivareta jo jebugea erambi gaa regegeta rousue. Númanena furia, Iesu dava bubua, uriga egeguturie, ");
INSERT INTO bjz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Irugari kato, Moses na, Agho Dariva namonde andú eghá gefirie. Embó evetu bua, sasingu jo sirorambi doa, amburadua mo, unda doru aná embóda jamena einimi foite ari-du gefirie. Aghá ea, aná doruda sasingu siroradua mo, aná amburari embóda sasingu asue. ");
INSERT INTO bjz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Namonde kiki eini raita roreta, ningi! Sasingu vivide dano 7 sirorea vitirie. Anava begomi evetu bua vitirie-tago, mendi sasingu jo sirorambi doa ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aghá urieta, unda doru aná unda fatirarimi rururie. Tago, mendi sasingu eini jo sirorambi irieta, umó ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aghami-aghami uta aria, ambo jetukomi bua, mendi sasingu jo sirorambi, umó beago ambubuturie. Aghá ea sidara uria-da ambova, aná doru beago ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tago, rege, niningigore! Fefera ambova amburarivareta jebugea eradua mo, aná evetu mo, avoda evetu adu? Anada bee mo, embobo dano 7 evetu dabako ananu yagera egeguturie.” ");
INSERT INTO bjz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aghá regeguturieta, Iesu mino ririe, “Nímane dinunu gaa reisi-reravore. Anada bee mo, nímane God da Gaga gembari vitia-de God da anode jo gigigambi viteravore. ");
INSERT INTO bjz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Atá enembo amburari vareta jebugea erari mo, númane anera aghago ea irirota, jo vai ambi kotú yagera ambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Atá gigige! Ambua jebugea erarida gaga, aná eghá re. Kotú God da Gaga Moses da buka rova vitia mo, nímane iruguturera, aĩ, tefo? Sifá-sifáva ivari gambua bubura ueta, Moses gerua mo, God Moses da nuabua mane seibe sirivu uria-da tamova gaga eghá ririeta niningurie, ‘Niabua mane, Abraham, Aisak kotú Jekop endava irirota, gaabee egegeta uria, kotú oreki gaabee eta rousua-da God, aná amó re.’ God aghá riria-du, namonde amó reisi-gerore, God jo amburari enemboda God irambi re. ");
INSERT INTO bjz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amburari enembo, jo amburota, sidara ambi vitie. Amindu, nímane gavera gaanu gaabee egeguturota, gaa beeda emboro reisi-kasovigutoravore.” ");
INSERT INTO bjz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moses da Gaga Irugari kato* eini furia irieta, Iesu Sadyusi* enembodu gaga mino taubana rieta niningurie-gea, umó Iesu du uriga urie. “God da Agho Dari rova, gaga jojabe mo niavoro?” ");
INSERT INTO bjz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aghá ririeta, Iesu mino eghá ririe, “Gaga jojabe evere: ‘Atá, ená nímane Jiusi enembodu rereta niningige! Jojabee God umó aná jojabe re. ");
INSERT INTO bjz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Inda Jojabee God nu, inda neno roode, inda asiside, inda nundubaride kotú inda anode dano neno bu!’ ");
INSERT INTO bjz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kotú, Agho Dari eini aghago aná evere: ‘Atá, imó indufa neno rei-rurora aghagonu, inda komana beago neno bu!’ Ená Agho Dari ungagha rera, aná jojabebei re. Dumenida bouvu jo ená ungaghade inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aghá ririeta, Moses da Gaga Irugari katomi ririe, “Irugari kato, imó gaga rea goghó etoravore! ‘God umó dabako re, eini umongo tefo re.’ ");
INSERT INTO bjz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Aná gaa bee re. Kotú ‘namonde amó nenode, neno nundubaride kotú anode dano Jojabee God neno rururota, namonde andufa neno reisi-rurora aghagonu, kokomana neno bubugadora,’ aná jojago re. O God dava namonde anda nino oka dea vesa dungota evaita rouvia, aná bee ijoko re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aghá rirota, umó neno nundubuturota riria-du, Iesu undú eghá ririe, “Imó etera, God unda natofo* kaifa eta rouvia-va utuvako etoravore.” Iesu na númanda gagada mino aghá riria-du, enembo dano undava uriga eini ari oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu, umó God du Tafaroro Ari Kamboda* ghoukava terua iruguturota ririe. “God na embó eini ninengota furari-du riria-nu nundubuturota, Moses da Gaga Irugari kakatomi* daiyagha umó mo, Devit da mendi gaa regegeta rousu? ");
INSERT INTO bjz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aná mo, Asisi Kakarami rieta niningurota, Devit umó undufa eghá gefirie. ‘God, unona anda Jojabeedu ririe, “Fu anda ingo bee kena asumbadi-gea, anona inda gitofo dea bundia bua furá, inda eka tuva itota vavasigoe!” ’ Jojabee na aghá riria, ananu reta Devit na gefirie. ");
INSERT INTO bjz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Amindu, Devit umó undufa undú ‘Jojabee’ radua mo, daiyagha umó mo, Devit da mendi gaa reisi-rere?” Enembo natofomi desea, Iesu da irugutua aná gangorogha reisi-niningurie. ");
INSERT INTO bjz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Atá umó, númane nghaĩ ititiguturota eghá ririe, “Moses da Gaga Irugari kakato*, gia goghó egege! Mania Moses da Gaga Irugari kakatoda ambo-ambo egegata! Númane gangorogha asugari-dighari yayafabebei esiko-esikomi asugea ya, utua bari kambesiva bubota, enembomi númane kakara urota, ari oro rea goghó egeguturota, ghanena ari-du uno egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ari dabako aghagonu nghaĩ itari kambova*, kotú banau feferava enembomi kokotofu enemboda asumbari kambesi taubananu utota asumbaita uno egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Númane aghá urota, dodoruda kambode gugua-ghayafade tefo-tafo rururota, God du Tafaroro Ari Kambova terua jiria, enembomi númane raga rari-du rea, benunu numbotofo egegeta rousue. Aghá enembodu, God na fefera ambova mema jojabe kotú bouvu akuago beenu utota baita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aghá rea doa, Iesu aria, God du Tafaroro Ari Kamboda* rova terua aria, vesa utari kibubu irieta gerurie-gea, rekimbea aria, yoveniva asumbuturie. Asumbea gerueta, enembo furia, númanda guri ututurie. Aghá ueta, gugua-ghayafa embobo guri oruabe ituturie. ");
INSERT INTO bjz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Anada rorova doru makasi bee einimi furia, guri* auri kofa mi ari ijoijokoko ungagha kibubuva fefendueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aghá urieta, unda ambo nimbi ghogho ririeta furia, danode urieta-gea, ririe, “Reisi-gerora, aná evetu doru umó makasi re-tago, umó jojabe kibubuva fendie. Enembo eini jo unda utua, aghago utambi re. ");
INSERT INTO bjz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Anada bee mo, enembo dumeni númanda gugua-ghayafava gerurota bubua itie. Tago, ená doru makasi bee re. Undava donu vita, aná dano bua utue. Kotú, undava irasueta, umó ambova jijimu asua katogo, aná dano bua etia utue.” Iesu na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu, God du Tafaroro Ari Kambovareta erea yaita ueta-gea, unda ambo nimbi einimi Iesu du eghá ririe, “Irugari kato, ená God da kambonu gi! Singoi jojabebeimi bua, ená God du Tafaroro Ari Kambo* ititurieta, unda gari taubanago bee rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aghá ririeta, Iesu mino eghá ririe, “Imó ená singoi jojabebeinu gerurota rera? Tago, gitofomi furá aná kambo singoimi itari vitia-nu, susugi egegota, anada singoi mane eini jo unda irari kambesiva jirambi aita rouvie. Dano averegea airo-airo vovoregaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Anada ambova, Iesu ooto ragaro Olivi itiva, God du Tafaroro Ari Kambo* beina yoveniva asumbea irieta, Pita, Jems, Jon, Andru de númane nenukako furia, undava uriga egeguturie, ");
INSERT INTO bjz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Námandu rege, niningigore, ená rera eini-eini fefera nanjigo siroradu? Ivata domi uutu enda tano aita rouvia fefera, irugadu?” ");
INSERT INTO bjz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aghá regeguturieta, Iesu tutuno ea, númandu eghá ririe, “Dibe be gerurota, kaifa egege, rourogo nímane kuvia gavera rata-gea, ananu gaa bee gaa regegareta! ");
INSERT INTO bjz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anada bee mo, enembo oruaruabe furá, nímane kukuvirota, gavera eghá regegaita rousue, ‘Embó eini God utaita riria, aná amó re,’ aghá regeguturota, enembo oruabe dano númanda gaveranu, gaa bee gaa regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kotú, mene-mene utuvako urota, bingá niningigadora, o airo bee urota, kinini niningigadora, mania oru egegata! Eini-eini aghago mane siroraita rouvie-tago, uutu enda jo aghade tano ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Roo enda dumeni dumenida beforo ririkigari o kini mane ereregea, mino-mino mene-mene egegaita rousue. Kotú, gino-ginode, baimanade roo enda dumeniva siroraita rouvie. Aná mo, eto-bato evevetumi mendi sasingu fumbaita tutuno ea, mema itatama eta rousua, aghago re. ");
INSERT INTO bjz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dibe be gerurota, nendufa kaifa urota iririge! Anada bee mo, nímane nandia, númanda nghaĩ itari kambova fisurea, nímane bua, kanisera* maneda ingova utota, koto egegaita rousue. Aghade, nímane itota, gavanada babarigarida dibeva, kotú kini maneda dibeva jiria, anda ragarova isaghava regegota, númane, Jiusi enemboda gitofode dano anda Gaga Taubana niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ená enda jo tutomi manjambi irota, anda Gaga Taubana nímanena regegadi, natofo jede endava vitia dano ningia fafate egegota, anada ambova ená enda manjaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kotú, nímane koto egegaita rosora-da feferava gaga donu raita regegadora-du, mania mema egegata! Anada bee mo, aná gaga raita rosora feferava, Asisi Kakarami sonembea iruguturota regegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Aghade, nímane amó gaabee egegeta rosora-du, enembo oruabe nímane injigha egegaita rousue. Aná fefera furadua mo, enembo erea, númanda ikoko kaka, nanandigea ututugota-gea, data ambubugaita rousue. Enembo númanda sasingu nanandigea ututugota-gea, data ambubugaita rousue. Kotú sasingu beago erea, nue numamo mane nanandigea ututugota-gea, data ambubugaita rousue. Atá avona ano ea, enembodu oru ambi amó gaabee urota amburadua mo, jebuga tumanadu irari tambua baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iesu aghá rea, gaga enada mendó eini eghá ririe, (Anada beenu irugea tanana egegadi rere. Gaga aná evere:) “Ambova eini-eini akuago bee eininu bua furá, God du Tafaroro Ari Kambo roo Kambesi Kakarava itota jiria, anami bebeta urota gigigadora mo, nímane eve Judia Frovensi rova vitera enembo oru sumbua igige, oná dafaruva nunungegadi! ");
INSERT INTO bjz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Atá, embó avona unda kambo sebova asumbea irota, fefera bubadua, umó jo terua, unda eini-eini kambo rova bambi asue. ");
INSERT INTO bjz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kotú embó avona aayova buro urota-gea, fefera bubadua, umó jo kaverea ya, kambova unda etova asugari eini jo bambi asue. ");
INSERT INTO bjz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Arii, amó evevetu tambouvude ea iraita rousua-du, kotú evevetu dumeni sasingu emi gaiturota iraita rousua-du, neno mema rore. Anada bee mo, fefera bubadua, evevetu sasingu mane bua sumbari ata-bata urota, mema fakara bee itatama egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Inda oru sumbari, rourogo uria-gharova sirorauve-degea rirota, God dava benunu egegadi rere! ");
INSERT INTO bjz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Anada bee mo, God enda uubu urieta sirorea rei-fia, ya bubaita rouvia feferava, mema bouvu jo ená fururota, siroreta uria-gha jo inono irambi re, iti bee itiva siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Aghá re-tago, fefera veveragha jo yafabe ambi aita rouvie. God da ririeta vitia, aná eghá re. Yafabe irasua mo, natofo eini jo irambi, dano manjasue. Tago, God unda natofo gateguturia-du rirota, mema furaita rouvia, jo numbobe irambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Fefera aghade, enembo einimi indú gavera rirota, ‘God Embó eini utaita riria, aná evere!’ o ‘Umó overe.’ radua mo, mania umó gaabee ata! ");
INSERT INTO bjz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aghá rera-da bee mo, enembo dumeni furá gavera rirota, ‘Aná Embó God da utaita riria, aná amó re.’ aghá rirota, númane feroveta gavera kakatode dano furá, God da natofo beago kukuvirota, númanda gaveranu gaabee egegari-du rea bera-bera egegaita rousue. Kotú, númanda gaga gaabee egegari-du rea, ivata anogha dibe eini be eini egegaita rousue-tago, God da gateguturia natofo jo kuvirota jurambi egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Atá, dibe gia ambo gia urota, tumanadu kaifa egege! Ená gagada bee jo sirorambi irieta, nímandu sei retueta niningigetoravore. Amindu nundubuturota, iririgadi rere! ");
INSERT INTO bjz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Aná mema dara retora fefera furá sidara adua-da ambova fefera gotea, bingoi ata, marabe beago gotea bingoi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kotú, damana mane dorea vovorurota, uutuva eini-eini dano rarovaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Fefera aghade, Enemboda Jojabee* gooso rova unda ano jojabede duroghade vorefurota, enembomi gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Aghá urota, tavuya furota, unda anera mane ninengota vorea ya, enda mendóvareta furá mendóva unda gateguturia enembonu bua, danode egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Atá, aná ika simbiagomi nímane irugoe! Ika simbiada fafatu boiri ea, igi fangadua mo, nímane tanana aita rosoravore, ‘Ika simbiagoda bee ari oya bubaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aghagonu, aná eini-eini retora-nu gigigadora mo, tanana egegadi rere, fefera etia, utuvako etua-du, bee siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Amó nímandu gaa bee rere. Oreki rei-sirorutua enembo dano, jo ambua sidara ambi, dumeni irota, ená ivata retora, siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Uutude endade dano manjaita rouvie-tago, anda Gaga jo nanjigo aghade manjambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Enemboda Jojabee* fefera domi kaverea furá bubaita rouvia, endava enembo, o uutuva anera mane, kotú God da Mendi beago jo gambi re, God unuka rei-gerue. ");
INSERT INTO bjz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Amindu, dibe gia ambo gia goghó urota iririge! Anada bee mo, Enemboda Jojabee kaverea furaita rouvia-da fefera, nímane jo gambi re. ");
INSERT INTO bjz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Atá, fefera aghade aná eghá aita rouvie. Embó eini esega erea, yaita nundubuturota, unda eini-eininu unda sabua* yarata manemi kaifa ari-du rea doa, yaita yavi urota, bebato kaifa ari embódu eghá ririe. ‘Anda furaita rora-nu dibe emboro ege!’ ");
INSERT INTO bjz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Dibe emboro adi retora-da bee mo, kambo numamoda furaita rouvia fefera, imó jo gambi roravore. Rifogha ra, tumbade ra, aĩ, tumba rorova ra, aĩ, imó jo gambi re. ");
INSERT INTO bjz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Gigige! Nímane eviviguturota, umó kaverea furadua, aná jo taubana irambi re. Amindu kaifa ea goghó egege! ");
INSERT INTO bjz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kotú kambo numamoda, unda bebato kaifa ari embódu riria aghagonu enembo nanjogodu, rere. Kaifa ea goghó egege!” ");
INSERT INTO bjz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Serigea Yarida Banau*, kotú Yisti Tama Arida Banau jo ambi, fefera ungagha dibeva irieta, fristi* maneda kokotofude, Moses da Gaga irugari kakatode* Iesu nenomi nandia data amburari-du manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aghá urota, eghá regeguturie, “Namonde amó jo Serigea Yarida Banauda feferava ambi aita rosore. Anada bee mo, enembo oruaruabe desaita rousua-mi neno akuago ea, umó sorea namonde tataya egegauveta!” ");
INSERT INTO bjz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aghade, Iesu umó aria, Betani naava bubua, embó ragaro Saimon Refero da kambova terua irirota, undari dieta, evetu einimi uka muu munode ragaro nard botoro singoi ragaro arabasta va rurukarinu bua furie. Aná uka muuda muno taubana dogo, jo uvugha bagega irambi-gea, mino bee itiva re. Terua aria, Iesu dava bubua, aná botoro righia bejea, aná uka muunu Iesu da beforova avereguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aghá ueta-gea, enembo dumeni avo vitiria-mi, neno akokogo egegea, eghá regeguturie, “Aná uka munode mo, daiyagha sara-siosa averegetu? ");
INSERT INTO bjz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anami utua mino basira, aná ghaeko dabako buro ea bari gurida* itiva aghagonu bua, makasi enembodu vesa egegasira mo, taubana re,” aghá rirota, aná evetudu dibe beva gaa ininigha regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aghá regegutueta, Iesu umó erea, númandu mino eghá ririe, “Mania ená evetudu dibe beva regegata! Umó andava ari taubana bee etue. ");
INSERT INTO bjz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atá, reisi-gerora, makasi enembo aná nemonde dano, fefera numbotofo bee iraita rosoravore. Amindu númane sonembarida emboro aná iraita rouvie. Tago, amó jo namonde tumanadu irambi aita rore. ");
INSERT INTO bjz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ená evetuda donu etua, aná taubana etue. Anda tamo bua ya, furugaita rouvia-du, ená uka muumi andava averegetue. ");
INSERT INTO bjz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Amó nímandu gaa bee rere! Anda Gaga Taubana ya, roo enda niavo-niavo ningia fafate egegaita rouvia-va, ená evetu andava donu etua-da kiki anda Gaga Taubanade dano minono regeguturota, ená evetu beago nundubaita rousue!” ");
INSERT INTO bjz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aghá ririeta, unda ambo nimbi 12 da rova, Keriot embó ragaro Judas na erea, Iesu nu kuvia bua, fristida* kokotofudedava utaita rea arie. ");
INSERT INTO bjz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aghá ririeta ningia, númane gangoro egeguturota, Judas gurimi mino aita regeguturie. Aghá regeguturieta ningia, Judas tutuno ea, Iesu daiyagha nenomi nandia, Jiusi enemboda babarigaridava utasua-da emboro tava urie. ");
INSERT INTO bjz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yisti Tama Arida Banauda* rifo tutunova, oka sifi memendinu aná Serigea Yarida Banaudu dea bureta egeguturia anava, Iesu da ambo nimbimi undava uriga egeguturie. “Námane kambesi niavo ya, Serigea Yarida Banau simbugota undaita uno ro?” ");
INSERT INTO bjz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ririeta-gea, unda ambo nimbi ungagha ninenguturota, eghá ririe, “Igige, bogu naa Jerusalem teterugea, embó eini ovumi uvu dimbua bua fururota tatambugaita rosoravore. Aná embóda ambova tuvia, igige! ");
INSERT INTO bjz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Umó niavo teradua, kambesi dabako avo teterugea, aná kambo tofodu eghá regege! ‘Irugari kato eghá retue, “Amó kambesi doda terua, anda ambo nimbide dano Serigea Yarida Banau simbugea undidiga?” ’ ");
INSERT INTO bjz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Umó ingá imó bua, kambo tuvareta vitia, kambesi itiva irugadua mo, kambesi taubana avo simbugari vitia-nu gigigaita rosoravore. Namonde anda banau avo simbuge!” ");
INSERT INTO bjz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aghá ririeta niningigea doa, unda ambo nimbi erea aria, Jerusalem teterugea, Iesu da daiyagha riria, aghagonu siroruturieta, ungá Serigea Yarida Banau avo simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Simbuguturieta, jama urieta, Iesu unda ambo nimbi ingo ungaghade, numonde aria teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aria terua asusumbea, undari undidiguturota, Iesu na eghá ririe, “Amó nímandu gaa bee rere. Embó eini nímanda rorova vitia-mi, amó dubo ea, gitofoda ingova utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Aghá ririeta, unda ambo nimbi neno mema egeguturie-gea, tutuno ea, dano Iesu du uriga egeguturie, “Rege ningore! Jo amó irambi ra?” ");
INSERT INTO bjz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Anona aghi jufirieta, anda ambo nimbi 12 ea vitera-da rova embó eini, avona unda ingomi angá danode aagha dabakova ga degimbea nendera-mi, amó dubo ea, gitofoda ingova utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aghadu God da Gagava eghá gembari vitie: Enemboda Jojabee* umó donu ari-du gefiria, aghagonu aita rouvie. Tago, umó avona Enemboda Jojabee dari-du kivumi emboro aita rouvia embódu ‘Arii’ rere. Taubana mo, umó jo sirorambi asue.” ");
INSERT INTO bjz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aghá rea doa, numonde undari undidiguturota, Iesu farava ingari bua, God du aiye rea, righia ingegebea, unda ambo nimbidu ututurota ririe, “Ená anda tamo reta, bubuge!” ");
INSERT INTO bjz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aghá rea doa, Iesu umó vaini aaghava bua, God du aiye rea, unda ambo nimbidu ututurota ririe, “Nímane dano, ená aaghava undidige! ");
INSERT INTO bjz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Anda tatangu enembo oruabedu averegota voraita rouvia-mi God Afa undava ya bububugarida emboro* reka ifegaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amó nímandu gaa bee rere. Amó vaini ghavesida bee jo rekago undambi irogo, God unda natofo* rata ya, unda kambesiva terota-gea, amó vaini aghade undaitare.” ");
INSERT INTO bjz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iesu aghá rea doa, numonde daa eini divua, sidara ea bubua, ooto ragaro Olivi avo rekimbea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Anava irurota, Iesu númandu eghá ririe, “Oreki tumbade nímane dano oru susumbugea, amonu doaita rosoravore. God da Gagava amindu eghá gembari vitie: ‘God na sifi kaifa kato data amburota-gea, sifi mane gategea gategea, unda unda susumbugaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tago, ambova amó amburarivareta erea, nímane Galili yambi-da dibe kena, sei anona yaita rore.” ");
INSERT INTO bjz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aghá ririeta, Pita na mino Iesu du eghá ririe, “Jojabee, inda dumeni imó doa susumbugaita rousue-tago, amó jo imó doambi aitare.” ");
INSERT INTO bjz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aghá ririeta, Iesu umó mino eghá ririe, “Amó indú gaa bee rere. Rifode rifo jo atambi irota, kokora be fefera ungagha dimbambi irota, imó fefera bakode amó jo gambi gaa rea, kivu aita roravore.” ");
INSERT INTO bjz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Aghá ririeta, Pita be faghighi ea, eghá ririe, “Amó angá dano amburaita asire, imó jo kivu ambi aita rore.” Kotú Iesu da ambo nimbi dumeni beago Pita da riria dabako aghago regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aghá regeguturia-da ambova, Iesu unda ambo nimbide aria, kambesi eini ragaro Getsemani avo bubua, númandu eghá ririe, “Nímane eve asusumbea iririgutu-gea, amó ya onava benunu are!” ");
INSERT INTO bjz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aghá rea, umó Pita ungá Jems gha Jon de bua, numonde igiguturota, umó tutuno ea, unda neno nundubari jujurueta mema jojabe itatama urie-gea, ");
INSERT INTO bjz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","númandu eghá ririe, “Amó neno memami sumbua serigetueta amburaita itoko rore. Amindu nímane dibe fakara egege, namonde kaifa egegore!” ");
INSERT INTO bjz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aghá rea doa, itoko gosá ea aria, koubumi jengirea gonea vovorurota, aná memada fefera daiyagha serigasua-du, benunu urie. ");
INSERT INTO bjz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Unda benunuva eghá ririe, “Ariee, Afa, imó aná eini-eini dano ari inono re! Amindu ená mema jojabe andava reifia inona ege, serigoe! Avotago, jo anda unonu ambi aita roreta, do-gea, inda unonu siroroe!” ");
INSERT INTO bjz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Anada ambova, umó kaverea aria, unda ambo nimbi bakodedava bubua, númane evivigutueta gerurie-gea, Pita du eghá ririe, “Saimon, imó mo revera, aĩ, vitera? Imó daiyagha fefera tufoko dibe fakara ea, angá danode kaifa ambi ro? ");
INSERT INTO bjz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Dibe fakara ea, benunu egege, rourogo Satan furá nímane kuvirota, ari akokogo egegara-degea, rere! Nímanda unode nundubaride aná andava vitie. Tago, nímanda tamo firída unomi righieta, nímane jo ano ambi rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aghá rea doa, umó kaverea aria, benunu urota, dabako aghagonu benunu urie. ");
INSERT INTO bjz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aghá rea doa, umó rekago kaverea aria mo, unda ambo nimbi dibe bouvu egeguturieta vasia evivigutueta gerua mo, númane dibe fangea umonu gia, gaa bee sidara urie. ");
INSERT INTO bjz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iesu rekago kaverea aria, benunu ea doa, kotú kaverea furia bubua eghá ririe. “Nímane eviviguturota, nangu undidiguturota vitera? Inono etue! Enemboda Jojabee* dubo ea bua, ari-bari akokogo egegari enembodava utari fefera etia utuvako etue. ");
INSERT INTO bjz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Amindu, ererege, namonde igigore! Gigige, amó dubo ea bua ari-bari akokogo egegari enembodava utaita rouvia embó enanu bubie.” ");
INSERT INTO bjz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu aghá ria mo, unda ambo nimbi 12 da rova, embó eini ragaro Judas umó natofode buburiturie. Fristida kokotofude, Moses da Gaga Irugari kakatode*, kotú Jiusi enemboda babarigaridemi númanda mene-mene ari kakato dumenide ninenguturieta, kaiyade, gandighade bubugea, Judas da ambova aria bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aghade, númane jo furia, utuvako ambi irirota, Judas unda ari-bari daiyagha aita rouvia-nu natofodu eghá ririe, “Embó avonu amó nandia muno aita rora, aná umó reta, nanandigea bua, umó kaifa egeguturota igige!” ");
INSERT INTO bjz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas natofode dano aria bubua, dibe dambu Iesu dava aria eghá ririe, “Irugari kato, vitera!” aghá rirota, Iesu nandia muno urie. ");
INSERT INTO bjz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aghá urieta-gea, gitofomi bubua, Iesu nanandigutueta, ");
INSERT INTO bjz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","embó eini unda kasava jiria vitiria-mi, unda kaiya bua erea, fristida* beforo righarida buro embóda nghaĩ vegea kositurieta, jujururie. ");
INSERT INTO bjz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aghá uria-da ambova, Iesu númandu eghá ririe, “Nímane dodu kaiyade gandighade bua, amó nandaita fufugeto? Amó jo gavana tuvari gaa eini rambi re. ");
INSERT INTO bjz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Atá, amó fefera yafabe namonde God du Tafaroro Ari Kamboda* ghoukava terua irirota irugeta riara mo, daiyagha amó avo nanandigambi egegeta rosa? Avore, God da Gaga donu reiria-da bee sirorari-du rirota, eghá rei-sirorutue.” ");
INSERT INTO bjz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Aghá rieta, unda ambo nimbimi umó avo doa, númane airo susumbuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Aghá egegutueta, mendi gimasa eini eembo evia, Iesu da ambova furueta gerurie-gea, umó nandaita egeguturieta, ");
INSERT INTO bjz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","umó oru sufieta, unda eembo urugea jujururieta, umó taroba sufirie. ");
INSERT INTO bjz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aghá ea doa, Iesu bua aria, fristida* beforo righari katodava buburiturie. Fristida kokotofude, Jiusi enemboda babarigaride, kotú Moses da Gaga Irugari kakatode* dano avo desea iririgutueta, Iesu bua aria teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Atá, Pita, umó itoko ambo fugea jiria irieta, Iesu bua igigitueta, ambova ea jiria uta aria, fristida beforo righarida kambo kasava ghouka rova terua jiria, mene-mene ari kakato dumeni avo ivariva eka ingo mesitueta-gea, umó aria, nemonde asusumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Aghá ueta, fristi maneda kokotofude kanisera* manede dano Iesu data amburari-du regeguturota, osagho fufumbugaridu tava egeguturie-tago, undava akuago eini jo tambambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Enembo oruabe gavera regeguturota, númanda gaga jo bee dabako rambi re. ");
INSERT INTO bjz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anada ambova enembo dumenimi erea, osagho fufirota, Iesu da tamova gavera eghá regeguturie, ");
INSERT INTO bjz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Umó eghá rieta, námane niningigutare, ‘God du Tafaroro Ari Kambo* enemboda ingomi itari vitia, anona dea bejea, fefera bakodeda rova anukako itota jiraita rouvie. Aghade, enembo eini avona jo amó sonembambi aita rouvie,’ aghá ririeta, námane niningigutare,” ");
INSERT INTO bjz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aghá regeguturie-tago, númane gaga nanjogo regeguturia, aná jo gaga dabako aghago jo regegambi re. ");
INSERT INTO bjz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aghá regeguturieta-gea, fristida beforo righari númanda dibeva erea jiria, Iesu du uriga urie, “Ená gaga inda tamova reisi-ria-da mino eini jo rambi adora? Kotú ená emboboda regegetua gagada bee mo doro?” ");
INSERT INTO bjz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aghá ririe-tago, Iesu gaga eini donu jo rambi uria-du, aná fristida beforo righarimi Iesu du rekago uriga eghá urie, “Rege, ningore! Namonde amó God kakara eta rosora-da Mendi, enembo sonembari-du utaita riria mo, imó ra, aĩ?” ");
INSERT INTO bjz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aghá ririeta-gea, Iesu mino eghá ririe, “Nu reravore! Amó re! Fefera ambova Enemboda Jojabee* God Ano tofoda ingo bee kenava asumbea vitia-mi, uutuvareta gooso etova vorefurota gigigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aghá ririeta, fristida beforo righari ningia, neno akuago urie-gea, unda tamova asugari righia kisorea doa, eghá ririe, “Nímane niningigetora? Umó aghá rirota, God fara etue. Dodu gagada osagho fumbari enembo dumenida gaga niningiga? ");
INSERT INTO bjz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Unda ari akuago danonu reisi-niningoravore! Amindu, nímane daiyagha reisi-nundubuto?” Aghá ririeta, númane dano, umó data amburari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aghá regeguturota, eembo eininu bua, unda dibe rafea gagajeguturie. Aghá ea, ingo safea, umó ofova toka-taka egeguturota, eghá regeguturie, “Indava ferovetada ano iradua mo, imó avona detua-nu, rege, niningigore!” Aghá egeguturia-da ambova, God du Tafaroro Ari Kamboda kaifa ari kakato beago, Iesu dedeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ghouka gimanjeva kambo kasava asumbea irieta, fristida* beforo righarida buro ari ariri eini furie. ");
INSERT INTO bjz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aghade, Pita avo ivariva eka ingo mesiturota asumbea irieta, dibe fugia gerurie-gea, eghá ririe, “Imógha dano Nasaret embó Iesu de dano vitaravore.” ");
INSERT INTO bjz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aghá ririeta, Pita na jo umó irambi gaa rea kivu urota, eghá ririe, “Imó dodu rera, amó jo gambi re.” aghá rea doa, umó erea aria, ghouka bebatova jiria irieta, kokora be difirie. ");
INSERT INTO bjz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kokora be difirieta, umó avo jiria irieta, aná aririmi umó rekago gia, enembodu eghá ririe, “Ená embó, aná Iesu da eini re,” ");
INSERT INTO bjz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aghá ririe-tago, umó kivu urieta, enembo avo jijiregea vitiria-mi eghá regeguturie, “Gaa bee re. Imó Galili embó re. Amindu imó aná Iesu da eini re! Jo kivu ari katogo irambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aghá regeguturieta, Pita eghá ririe, “Amó gavera rasira mo, God na amó dasueta amburasire! Amó gaa bee rere. Nímanda reisi-rera embó amó itoko jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aghá rieta-gea, kokora rekago be difirie. Kokora be difieta, Pita umó Iesu da undú donu riria, ananu nundubuturie, “Kokora be fefera ungagha dimbambi irirota, fefera bakode inona amó kivu aita roravore,” Iesu da riria-nu nundubea, Pita neno jujururieta, jiimi neno gagajeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rifo tumba rova fristi* maneda kokotofude, Jiusi enemboda babarigaride, Moses da Gaga Irugari kakatode*, kotú kanisera* manede dano, manaka gaegeguturia-da ambova, Iesu nu seni mi bundia bua aria, Rom enemboda gavana ragaro Pailat dava ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ututuguturieta, Pailat da dibeva jiruturieta, Pailat Iesu du uriga urie, “Imó Jiusi enemboda kini ra?” aghá ririeta, Iesu mino eghá ririe, “Eẽ, inda rera aghago re,” ");
INSERT INTO bjz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Aghá ririeta, fristi maneda kokotofumi umonu itia bera-bera urota, gaga akokogo dumeni dumeni regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Amindu, Pailat na rekago Iesu du uriga eghá urie, “Ená enembo inda tamova itia bera-bera rousua mo, rei-niningora? Imó gaga mino radora?” ");
INSERT INTO bjz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aghá ririe-tago, Iesu rekago gaga eini donu jo rambi urieta-gea, Pailat mana-mana urie. ");
INSERT INTO bjz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Atá, Serigea Yari Banauda* feferava Pailat ghaeko inono eghá eta urie. Natofo jede fuava, dibura ea irari enembo avodu uno ea rari mo, Pailat na doaveta fuava isaghava bubua igigeta urie. ");
INSERT INTO bjz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Avore, Iesu nanandiguturia-da feferava, embó eini ragaro Barabas, unda mambu manede Rom enemboda gavana injigha egeguturota, dea tuvari gaa rea, Rom enembode mene-mene urota, enembo eini dedeguturieta ambubuturie. Amindu rea, umó bua, diburava gagajeguturieta vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pailat unda eta uria-nu nundubuturota irieta, enembo oruabe furia, Pailat dava bubua, avo desea númandu dibura ea irari embó eini doata furia, isaghava bubari-du benunu egeguturieta, ");
INSERT INTO bjz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat mino eghá ririe, “Avoreta, regege, ningore! Nímane avonu uno roso? Nímanda uno mo, Jiusi enemboda kini doata isaghava bubadua? Regege, ningore!” ");
INSERT INTO bjz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aghá riria-da bee mo, umó gerurie, fristi* maneda kokotofu númane Iesu da bingá niningigea, jii didimbugea, amindu Iesu bua furia, unda ingova ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Avore, Pailat, aghá ririeta niningigea, fristida kokotofumi regeguturieta, natofo jede bubua desea vitiria-da neno erorurie. Aghá urieta, númane dano Iesu dotuturota, Barabas nu doata isaghava furia bubari-du regeguturieta, ");
INSERT INTO bjz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat na rekago númandava uriga urie, “Atá ená embó, Jiusi enemboda kini reta rosora mo daiyagha a?” ");
INSERT INTO bjz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aghá ririeta, númane niningigea erea, itata rea, eghá regeguturie, “Umó ifatarava dege, amburoe!” ");
INSERT INTO bjz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aghá regeguturieta, Pailat umó mino eghá ririe, “Bee dodu? Kotú umó dinunu donu etu? Regege, ningore!” aghá ririeta, númane erea, itata rea, sirivo-sata egeguturie, “Umó ifatarava dege, amburoe!” ");
INSERT INTO bjz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aghá regeguturieta, Pailat na aná natofo jede neno taubana ari-du rea, Barabas dotuturieta furia, isaghava buburiturieta, umó ririeta, unda mene-mene ari kakato dumenimi Iesu bua, embiimi dedeguturie. Aghá egeguturieta, Pailat na Iesu nu bua, ifatarava dedegota amburari-du rirota, mene-mene ari kakato dumenida ingova ututurie. ");
INSERT INTO bjz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Aghá urieta, mene-mene ari kakatomi Iesu bua aria, gavanada kambo jojabeda roro rorosinava teteruguturie. (Aná kamboda ragaro Rom enemboda gaami fraetorium regegeta urie.) Anava bubua, ghogho regeguturieta, númanda dumeni dano furia bubua, avo terua danode egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ea, eembo gaduna tamonu bua, tumo tano afuregea, kini da kasavago urota, ika fatu gingidemi keifi ea beforova asuguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aghá ea, tutuno ea umó kuvia gegha regeguturota, eghá regeguturie. “Orokaiva! Jiusi enemboda kini, buberavore! Orokaiva!” ");
INSERT INTO bjz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aghá urota, ika bua beforova derurota visogha dibe beva egeguturota, tumogha baĩ egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kuvia gegha rea sidara egegea, númanda eembo Iesu dava asuguturia-nu, kosugea rururota, eembo unda tofonu bua asuguturie. Aghá ea, umó bua ifatarava daita rea righia ghambugea bua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aghade aria, emboro rorova Sairini embó eini, ragaro Saimon Jerusalem bogu naava teraita irueta tatambugea, Iesu da ifatara fumbari-du rea, bera-bera egeguturieta, Iesu da ifatara unona sonembea fufirie. Saimon rera, umó Aleksander ungá Rufus ghada numamo re. ");
INSERT INTO bjz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aghá ea, númane Iesu bua aria, kambesi ragaro Golgota avo buburiturie. Golgota da bee mo, Amburari Enemboda Beforo Siruru regegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Aria bububugea, anada ambova, umó rourogo tamo vevera itatama auve-degea vaini bua, ingi eini, ragaro meer reta rousua-gha, bagega arinu ututurie. Aghá egeguturie-tago, Iesu undari injigha ea dotuturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Dotuturieta, fefera vitia 9 koroki urieta, númane Iesu bua ifatarava dedeguturie. Ea, unda asugarinu vesa-boanda egegaita rea, kikindo gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aghá ea, umó dodu koto uria-da bee, irugota gigigari-du rea, gembua Iesu da beforo gombu kena dea takembuturie. Aná eghá gegembuguturie, Ená Jiusi enemboda kini re. ");
INSERT INTO bjz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Fefera aghade, bagia kakato ungagha bua furia, eini Iesu da ingo bee kena, eini ingo anda kena ifatarava dedeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aghá egegutueta, God da Gaga donu riria, aná isagha urie. Aná mo evere: “… umó aná ari akuago embó aghago nundubuturota regeguturie.” ");
INSERT INTO bjz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Enembo iru-furu urota, beforo biru-biru urota, Iesu gia kuvia gegha regeguturota, yovero regeguturie, “Yove, yove! Imó God du Tafaroro Ari Kambo* righia bejea, fefera bakodeda rova righota erea jirari gaa reta ureravoreta, ");
INSERT INTO bjz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","indufa sonembea ifatarava doa kaverea vore!” aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aná ari dabako aghagonu fristida* kokotofude, Moses da Gaga Irugari kakatode* beago, númanena Iesu kuvia gegha rirota, eghá regeguturie, “Umó enembo dumeninu sonembeta urie-tago, undufa sonembari jo inono irambi re! ");
INSERT INTO bjz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Unda nundubari mo, God namonde anda ari akokogo nundubea gia doaita rea, embó eini utaita riria, aná umó re, kotú namonde amó Jiusi enemboda kini umó re, reta rouvia amindu, namonde amó umonu gaabee egegari-du rea, ifataravareta vorari-du reisi-rere.” aghá regeguturie. Kotú aná bagia kakato ungagha Iesu de dano ifatarava dedeguturia beago, Iesu fara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","34","Fefera beforova ueta, roo enda dano bingoimi afuregea irieta aria, jama ueta, kambesi rekago ategea unana urie. Jama 3 koroki ueta, Iesu Jiusi enemboda gaami koko fugia be jojabe ririe, “Eroi, Eroi, rama sabakitani? Aghá riria-da bee mo, Anda God, anda God, imó dodu amó doto?” ririe. ");
INSERT INTO bjz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iesu da koko riria-nu niningigea, enembo dumeni avo jijiregea vitiria-mi jo ningia goghó ambi egeguturie-gea, eghá regeguturie, “Niningige! Umó Elaija du ghogho reirie.” ");
INSERT INTO bjz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Anada ambova embó einimi sumbua aria, eini-eini ofusada mokogonu bua, ika mendóva fakembea, vaini kaeededa kofiriva ga degimbea bua, Iesu na undari-du siniturieta vitia, unda beva takembuturieta ririe, “Do-gea, namonde gigigore, Elaija furá, umó sonembadua, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aghá ririeta, Iesu koko jojabe rea, ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ambubuturia aghade, God du Tafaroro Ari Kambo* bogu naa Jerusalem vitiria-da rova, rourogo enembo ya Kambesi Kakara Bee anava terua amburauve-degea, eembo einimi gajari vitiria, aná rorova kisorea vorefuria, tuva buburiturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aghá urieta, mene-mene ari kakatoda beforo righari Iesu da ifatara dibe kena jiria vitiria-mi, Iesu unda daiyagha ambubuturia, aná gerurie-gea, eghá ririe, “Gaa bee re, umó God da Mendi re!” ");
INSERT INTO bjz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iesu ambubuturia aghade, evevetu dumeni airo jijiregea gigiguturie. Anada gorotova Makdala ariri, Meri de, kotú Meri unda akau (Ená Meri rera, umó Jems ijoko, Josep kotú Salome deda nue re.) kotú evevetu dumenide jijiregea vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ená evevetu rera, númane frovensi ragaro Galili anava, Iesu de dano deĩ urota, umó sonembeta egegeturie. Kotú evevetu dumeni avona numonde Iesu de dano furia, Jerusalem bububuguturia-de dano avo jijiregea irirota, Iesu da ambubuturia-nu, gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aghá urieta, evia rifo atadua, aná Nangu Undarida fefera re. Jama uua-du, ");
INSERT INTO bjz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea embó ragaro Josep na aria, Iesu da tamo utota bua ya furugaita rirota, Pailat dava benunu urie. Ená embó Josep rera, umó embó bingáde eini re. Kotú umó aná kanisera* maneda eini re. Aghade umó, God furá unda natofo* kaifa aita rouvia feferadu kaifa urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","Unona aria, Pailat dava bubua, Iesu da tamo bua ya furugaita benunu urieta-gea, Pailat aná gaga ningia duduku urie. Ea, aná mene-mene ari kakatoda beforo righaridu aghi ninenguturieta aria bua furieta, undava uriga urieta, “Seibe ambue,” ririe. Aghá riria-du Pailat na Iesu da tamo Josep du utari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aghá ririeta, Josep aria, eembo saghai tamonu gurimi mino utua bua furia, Iesu da tamo ifataravareta ititurieta vovorurieta bua aria, uje eini gudoro ufuva ghafirieta vitiria-va itia, singoi eininu oberea, anami uje be gajiturie. ");
INSERT INTO bjz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kotú, umó niavo itituria, Makdala ariri Meri de, kotú unda akau Josep da nue Meri de, avo iririguturota, númanena gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nangu Undari fefera sidara uria-da ambova Makdala ariri ragaro Meri de, kotú unda akau Meri de (Aná Jems ungá Salome ghada nue re.) Ungá ingide uka muu munodenu bua, Iesu da tamova gharaita rea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fura Jojabeda rifo atea fefera vitambi irieta, ungá aná uje singoi toova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Igiguturota, emboro rorova mino-mino eghá regeguturie, “Namonde andú avona aná uje beva singoi oberadu?” (Aná singoi aná bouvu bee re.) Aghá regeguturota, dibe fugia gigiguturia mo, aná singoi uje beva gajari vitiria, seibe ifegea irieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aghá gigiguturie-gea aria, anava bubua uje rova terua, anava mendi gimasa eini unda asugari aná saghainu asugea, ingo bee kenava asumbea irieta gigigea, númane duduku-dadaka ea, mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mana-mana egegutueta, unona númandu eghá ririe, “Mania mana-mana egegata! Amó rei-gerore. Nasaret embó Iesu ifatarava dedeguta-du, tava rosoravore. Umó ambua, amburarivareta jebugea eretue. Umó enava tefo re. Kotú gigige! Umó bua futa ituta kambesi, aná evere. ");
INSERT INTO bjz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amindu oreki nímane ená gaganu bua igige! Unda ambo nimbi dumenide Pita de dano regege, niningigoe! ‘Umó nímanda dibe kena Galili reiya-du, unda riria aghagonu, umó avo gigigaita rosoravore.’” ");
INSERT INTO bjz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aghá ririeta, ungá eka ingo dadada urota, aná ujevareta doa bubua susumbuguturie-tago, ungá enembo einidu jo isagha egegambi urie. Anada bee mo, númane oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesu fura jojabeda rifo tumbava erorurie. Umó isagha ambi-da tutunova Makdala ariri, ragaro Meri dava isagha urie. Iesu na taimu akokogo 7 evetu einidava tuviturieta vovoreguturia, aná umó re. ");
INSERT INTO bjz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meri na kaverea aria, Iesu de dano deĩ eta uria enembo, undú neno memade jiide vitiria-dava aria bubua, eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Iesu amburarivareta jebugea eretueta, amó gere!” ririeta, númane niningiguturie. Tago, jo gaabee egegambi urie. ");
INSERT INTO bjz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Anada ambova, Iesu da kokomana ungagha emborova igigutueta, umó dibe kaverea aria, númandava isagha urieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aghá urieta, aná enembo ungagha kaverea furia, númanda kokomana dumenidu regeguturie. Tago, númane jo gaabee egegambi re. ");
INSERT INTO bjz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Anada ambova, Iesu da ambo nimbi dano 11 undari undidigutueta, umó númandava isagha urieta, gigiguturieta, númandu dibe beva ririe. Anada bee mo, Iesu umó amburarivareta eroruria mo, enembo dumenimi gia aria, númandu isagha urie-tago, númane deriva urota, jo gaabee egegambi urie. ");
INSERT INTO bjz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iesu na númane dibe beva ririeta niningiguturia-da ambova, umó eghá ririe, “Anda Gaga Taubananu bua roo enda nanjogova igige! Enembo dano regege, niningigoe! ");
INSERT INTO bjz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Avona gaabee ea, bafutaito egegadua enembomi jebuga tumanadu irari tambua, Afada kambesiva terua tumanadu iraita rouvie. Avotago, avona jo gaabee ambi adua mo, anona itota kambesi akuagova teraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Avotago, gaabee ari enembodu ano utota, eini-eini dumeni ata siroraita rousue. Aghago, númanena anda ragarova taimu akokogo tuvota vorea serigaita rousue. Kotú, Asisi Kakara númandava asugota, neno nundubuturota aveva kaverota gaga tinongu-tanongu regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aghá urota, númane ningabu righadua, kotú kae undadua, jo amburambi aita rousue. Aghade, númanda ingomi kae bua irari enemboda tamova righadua, aná enembo jejebugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aghá riria-da ambova Jojabee Iesu, umó uutuva vitia, God Afada ingo bee kenava asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aghá urieta, unda ambo nimbi aria, roo enda nanjogova deĩ urota, Iesu da gaganu minono regegeta urie. Aghade, Jojabeena númane sonembutueta, ivata anogha dibe eini be eini egegeta uria-nu gigigea, enembo númanda gaga gaabee egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ariee, Tiofilus! Imó bee ghanena rore. Enembo oruabe námanda gorotova eini-eini donu siroruturia, aná gegembuguturie. Númanda nundubari-mi jo gembambi re. Tago, númane aria, avona fururota, eini-eini donu siroruturia-nu dibemi gigigea, kotú irugeta egeguturia-dava, tanana ea, ananu gegembuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Avore, amó beago donu siroruturia-nu tutunovareta kuvia geruta refere-gea, ená gaga simbugea gembua indú utasira, aná taubana re. Ená gaga utaita rora-nu iruguturota, imó donu niningara-da bee tanana ea goghó adi rei-gefere. Yata bua gi! ");
INSERT INTO bjz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kini Herot umó Judia enemboda beforo righari ea, Israel enembo kaifa eta uria aghade, fristi* eini, ragaro Sekaria, vitirie. Umó Aron da mambube Abiya da mambube maneda rorova siroruturie. Kotú unda evetu Elisabet beago, umó nuabua Aron da evetube eini re. ");
INSERT INTO bjz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","God da dibeva ungá unda irari taubana re. Kotú God da Agho Dari gaga donu reiria-nu, aghá egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tago, Sekaria da evetu Elisabet eero-gea, mendi sasingu fumbambi irirota, emboko evetuko egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Fefera eini Abiya undida buro ari fefera buburiturieta, Sekaria God da dibeva buro eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aghá ueta, fristi mane daiyagha egegeta uria aghagonu urota, fristi avona God du Tafaroro Ari Kambova* terua, ooru munodenu bua dungari-du rea kikindo gaegeguturieta, Sekaria da ragaro isagha urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aná ooru munode dungarida fefera buburituria aghade, aná tafaroro aita desuturia enembo isaghava burutugea jijiregea, God du tumogha baĩ urota, benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sekaria na aná ooru munode dungarida faro ingo bee kena jiria irieta, Jojabeeda anerami undava isagha urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aghá ueta, Sekaria gia, orumi ekade ingode dano dadada ueta-gea, ");
INSERT INTO bjz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","anerami undú eghá ririe, “Mania oru ata! God inda benunu ningie. Inda evetu Elisabet mendi fumbaita rouvie. Unda ragaro Jon righadi rere! ");
INSERT INTO bjz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kotú unda siroraita rouvia-mi, ingá imode kotú enembo oruabede dano gangoro egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Anada bee mo, umó Jojabeeda dibeva embó jojabe eini iraita rouvie. Umó vaini de, kotú uvu fakarade undambi aita rouvie. Nueda uro rovareta siroraita rouvia-va Asisi Kakara undava asugea iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Unona minono rirota, Israel enembo niningigea neno kaverota bua, númanda Jojabee God dava furaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kotú umó sei Jojabeeda dibe kena furaita rouvie. Umó eto-bato feroveta sei ragaro Elaijafuria aghagonu, God da Asiside anode bua furaita rouvie. Kotú unona irari-da emboro irugota, sasingu mane nue numamode besiga rousua-nu doa, neno dabako egegaita rousue. Kotú, gogore kakato nghaĩ itota, neno kaverea, irari taubananu nundubaita rousue. Aghá ea, unona Jojabeeda furaita rouvia-da gaga rata, enembo niningigea, neno kaverea, Jojabeeda furaita rouvia feferanu kaifa egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aghá ririeta, Sekaria na aná aneradu eghá ririe, “Amó emboko etore, kotú anda evetu umó mendi sasingu fumbarida ghaeko serigea vitie. Daiyagha andava siroradu?” ");
INSERT INTO bjz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aghá ririeta, aná anerami mino eghá ririe, “Anda ragaro aná Gebriel re. Amó God da dibeva jiria irita rore. Indú gaga taubana rari-du ninengetueta etere. ");
INSERT INTO bjz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tago, imó anda gaga ningia gaabee ambi etora-du, oreki enavareta ya, aná mendi siroraita rouvia feferava, imó aná gunga ea iraita roravore.” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aghá ueta, enembo natofo nanjogo dano, “Sekaria Tafaroro Ari Kambo rova donu urota viti?” rea, mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aghade, umó Tafaroro Ari Kambo rovareta bubua furia númandava be fangea, gaga rari mana-mana ea, ingomi tovoto urie. Aghá ueta gigigea, umó barau geruria-nu tanana egeguturie. Avore, Sekaria gunga ea irirota, ");
INSERT INTO bjz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","unda tafaroro ari fefera sidara urieta, umó kaverea, naava arie. ");
INSERT INTO bjz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aghá uria-da ambova, unda evetu Elisabet tambouvude urie-gea, kambo rova nungia irieta, marabe ingo yoveni sidara urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aghade, Elisabet umó eghá ririe, “Oreki Jojabeena andú ivata jojabe eini etue. Unona sonembetueta, enemboda dibeva anda meka sidara etue.” ");
INSERT INTO bjz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anada ambova, Elisabet umó tambouvude ea irieta, marabe ingo yoveni sidara ea, ingo yoveniva dabako sidara uria-da rova, God na anera ragaro Gebriel nu, ariri mose einidava gaga rari-du ninenguturieta vorea, roo enda Galili anava naa ragaro Nasaret buburiturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Aná aririda ragaro aná Meri re. Meri umó embó eini, ragaro Josep du datu dighari vitiria re. Kotú, embó Josep umó aná Kini Devit da mambube eini re. ");
INSERT INTO bjz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aná anera aria, Meri dava bubua eghá ririe, “Meri, vitera? Jojabee inda irari gia, neno gangoro urota, imó ea simbuguturota, ingá vitie.” ");
INSERT INTO bjz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aghá ririeta, Meri duduku ea, mana-mana urie-gea, “Ená anera mo, ghanena goroto doda etu?” nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tago, anera umó Meri du eghá ririe, “Mania oru ata! God inda irari-du gangoro rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Atá ningi! Imó tambouvude ea, mendi fumbaita rora-da ragaro Iesu righi! ");
INSERT INTO bjz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","God Iti Bee itiva vitia-mi ‘Umó anda mendi re.’ raita rouvie. Aghade, God na nuabua Kini Devit da avo asumbari utota bua, enembo kaifa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Gaa bee, nuabua Jekop da Mambube mane unona tumanadu beforo righaita rouvie. Kotú unda kaifa aita rouvia fefera, jo nanjigo aghade tano ambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aghá riria-du, Meri aná aneradu eghá ririe, “Amó siroruturera kombo undiri ambi vitere. Daiyagha ea, ená ivata andava siroradu?” ");
INSERT INTO bjz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aghá ririeta, anera mino eghá ririe, “Asisi Kakara indava asugea irirota, God Iti Beevami imó afuregaita rouvie. Amindu, aná mendi kakara siroraita rouvia-du, ‘God da Mendi bee re.’ raita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","God na eghago ata sirorari jo fakara irambi re. Inda nomono Elisabet nu nundubadi rere! Umó eero gaa reta rousue. Tago, God na ritata, umó unda evetuko feferava soká baita rouvie. Oreki marabe ingo yoveni sidara ea, ingo yoveni dabako sidara aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aghá ririeta ningia, Meri mino eghá ririe, “Amó Jojabeeda sabua* re. Amindu do-gea, andava inda retora aghagonu siroroe!” aghá ririeta, aná anera ningia doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aghá uria-da ambova, Meri erea, tatavami Judia frovensiva bogu naa eini dafaru kena vitiria-va arie. ");
INSERT INTO bjz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aria, Sekaria da kambova terua, Elisabet tambua, ghanena urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Aghade Elisabet Meri da ghanena niningua, unda uro rova soká yavi-yavi ueta, God da Asisi Kakarami Elisabet da neno rova vovorurieta, be koko fugia eghá ririe, “Evevetu oruabeda rorova, God da ea simbugari indava vitie. Kotú inda fumbaita rora mendi beago, God na ea simbugaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kotú, imó anda Jojabeeda aya re. Andava esega etera, jo aghá ari inono irambi re. Tago, gangoro rore. ");
INSERT INTO bjz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Amó inda ghanena niningua, jo gaimbo ambi soká anda uro rova gangorogha eka ingo ghusu-ghasa etue. ");
INSERT INTO bjz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Imó Jojabeeda donu rita-nu gaabee utara-du, unda ea simbugari indava irota, unda donu indú rita aná sirorea, gaa bee aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aghade, Asisi Kakara mi Meri da neno rova gaitueta, daa didivurota eghá ririe, “Anda neno dano ututurota, Jojabeedu raga rere. ");
INSERT INTO bjz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kotú anda neno roomi God anda Sonemba katodu gangoro rore. ");
INSERT INTO bjz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Anada bee mo, amó unda sabua* tuva bee re. Tago, unona amó nundubetue. Aghá-gea, oreki reta yaita rouvia enembo dano andú, ‘God da ea simbugari Meri dava vitie,’ regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God ano katomi andú ivata jojabe eini etue. Unda ragaro aná kakara bee re. ");
INSERT INTO bjz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kotú enembo avona God du oru aita rouvia-da imendi gamendidava unda kauta kavevera iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kotú unda ingomi ivata anogha urota, enembo nendufa raga rirota righiaveta ereta rousuria-nu tuviturieta, airo-airo egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Unona reaveta, roo enda dumenida kini mane númanda asumbari kambesi doa, serigea sabua egegutuaveta, sabuami vitia kini egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Enembo baimana itatama egegutua-nu, undari taubana manemi unduturie. Kotú gugua-ghayafade enembodu, donu utambi ninenguturieta, tefo igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kotú unda sabua embó Abraham dava be gajituria, ananu nundubuturota, Abraham da mambube mane Israel enembo tumanadu sonembeta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aghade, Meri ungá Elisabet gha irieta, marabe bakode seriguturieta, Meri kaverea, unda naava arie. ");
INSERT INTO bjz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Anada ambova Elisabet unda soká fumbari fefera buburiturieta, itatama ea, mendi reta fufirie. ");
INSERT INTO bjz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jojabee na Elisabet dava unda kauta kavevera iruguturia-nu niningigea, Elisabet unda enembo totofode, kotú unda kambo kasava irita uria enembode unda kambova furia numonde danode gangoro egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Avore, onembo 8 sidara urieta, aná sokáda vii mendó andoro divegea, unda numamo, Sekaria da akau ririkigaita rea, fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tago, nuena eghá ririe, “Tefo, unda ragaro aná Jon righaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aghá ririeta, aná enembo eghá regeguturie, “Avotago, inda totofoda rova enembo eini ragaro Jon, aná tefo re,” ");
INSERT INTO bjz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Anada ambova Sekaria unda mendi ragaro donu ririkigasua-nu tanana egegaita isusu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aghá egeguturieta, Sekaria na fae gembari-da eini-einidu benunu urieta, ututurieta bua, unda mendida ragaro “Jon” gefirie. Aghá urieta, aná enembo gigigea be angea bee sidara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gaimbo ambi, Sekaria da be ifegea, kotú unda aveva dambu urieta, umó God du raga ririe. ");
INSERT INTO bjz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aghá urieta, númanda kambo kasava vitiria enembode kotú naava enembode dano ningia, oru egeguturie. Aghá urieta, anada gaga Judia Frovensi ootokena aria, kambesi dano fafate urie. ");
INSERT INTO bjz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Enembo avona niningiguturia-mi, mana-mana egegea, mino-mino uriga eghá egeguturie, “Ená mendi mo, ambova daiyagha adu?” aghá regeguturia-da bee mo, Jojabeeda ano aná undava vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Aghade, Sekaria dava Asisi Kakarami asuguturieta, donu ambova siroraita rouvia-nu rirota, eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Namonde anda Israel enemboda Jojabee God du raga regegore! Anada bee mo, unda enembo bunditurieta vitiria-nu etia sonembetue. ");
INSERT INTO bjz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","70","Unda donu aita riria-nu, feroveta kakara mane seibe sei irita egeguturia-mi isaghava regeguturie. Ananu sirorari-du rea, unda sabua* kato Devit da mambube maneda gorotova namonde anda Sonemba kato ano tofo, ninenguturieta furie. ");
INSERT INTO bjz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Aghade unona namonde amó gitofoda ingova, kotú namonde amó injigha eta rousua enemboda ingova rougea, baita be gajiturie. ");
INSERT INTO bjz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aghá urota, umó namonde anda mambube manedava unda Be Gajari Anogha kotú Kakara Bee riria-nu nundubuturota, númandu neno mema urota, kaifa tavo aita ririe. ");
INSERT INTO bjz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Avore, God undufako namonde anda afa Abraham dava donu aita be gajituria, aná evere: ");
INSERT INTO bjz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Unona namonde amó gitofoda ingova rougea bata-gea, unda natofo kakara ea, ari taubana egeguturota, gitofoda dibeva oru ambi, umonu tumanadu tumogha baĩ aita rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Aghá rea, Sekaria na kaverea, unda sokádu eghá ririe, “Anda mendi, inda gaga beago vitie. Enembo indú God Iti beevada feroveta eini gaa raita rousue. Anada bee mo, Jojabee númanda ari akokogo nundubea gia dotuturota, númane sonembaita rouvia-da gaganu rata, unda natofo niningigari-du rea, inona Jojabeeda dibe kena irurota, unda emboro ea simbugaita roravore. ");
INSERT INTO bjz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Anada bee mo, namonde anda God kauta kavevera urota, namonde amó roboghami unduta rouvie. Rifo atea, fefera vitiaveta, bingoi sidara eta rouvia aghagonu, God da sonembade unanade uutuvareta janimbota, namonde amó tumbava irirota, amburari oru egegeta rosora enembodava oru sidara ata, namonde amó siriri arida emborova igigaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Atá, Jon da asisi ano ueta, umó neno nundubarigha baborurie. Baboruria, umó uvu tefo kotú enembo irambi kambesiva aria irieta, unda Israel enembodava minono rari fefera buburiturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Fefera aghade, Rom enemboda kotofuko ragaro Sisar Ogastus na agho dari eini urieta siroruturie. Rom enemboda kaifa eta rousua enembo dano kaverea ya, nuabua mane niavo siroruturia naava, númanda abua ari ragaro gegembugasue. ");
INSERT INTO bjz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Embó ragaro Kwirinius umó Siria frovensida gavana ea vitiria feferada dibeva, ragaro jo gembambi re. Fefera anava tutuno ea ragaro gegembuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Amindu rea, enembo dano ragaro gegembugaita rea, ereregea, númanda naa ari naa ari igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Amindu Josep beago, Nasaret doa aria, Galili Frovensi serigea aria, Judia Frovensiva terua, nuabua Devit da siroruturia naa ragaro Betlehem buburiturie. Anada bee mo, umó aná Kini Devit da mambube eini re. ");
INSERT INTO bjz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Unda datu ariri, ragaro Meri, tambouvude ea vitirieta bua, ungá igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Aria, Betlehem bubua irieta, Meri da fumbari fefera furia buburiturieta, Meri unda soká bego, mendi reta fumbua, eembomi otoo ea, nino oka yamena ari rorova ititurieta vavosurie. Anada bee mo, aná esega enemboda kambo rova númane irari kambesi tefo re. ");
INSERT INTO bjz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aghade, Betlehem naa kasava kambesi einiva oka sifi kaifa kakato dumenimi tumbade númanda sifi mane kaifa rousurie. ");
INSERT INTO bjz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aghá ueta, Jojabeeda anera, aná sifi kaifa kakatodava isagha ea, Jojabeeda durogha janimbutueta, númane gigigea, duduku-dadaka ea, oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tago, anerami eghá ririe, “Mania oru egegata! Amó nímandu Gaga Taubana raita rore. Rata niningigea, nímane abua-abua enembo nanjogo dano gangoro jojabe egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Embó eini God na utota, nímane sonembari-du riria, aná oreki Kini Devit da naa Betlehem avo siroretue. Umó aná Jojabee re. ");
INSERT INTO bjz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Atá aná soká tambaita rora ivata, aná eghá ari vitie. Umó eembomi otoo ea, nino oka yamena ari rorova itota vasia irota tatambugaita rosoravore!” ");
INSERT INTO bjz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aghá rieta, gaimbo ambi anera mane oruaruabe uutuvareta vorefuria, anera sei isagha uria-de dano takembea, God du raga rirota eghá regeguturie, ");
INSERT INTO bjz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God iti beevada duroghadu raga rosore. God na endava unda uno rouvia enembodu, siriri ari utota voraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aghá rea doa, aná anera mane kaverea, uutuva vivitiguturieta, sifi kaifa kakato mino-mino eghá regeguturie, “Egege! Namonde Betlehem ya, donu siroretueta, Jojabeeda namonde andú retua-nu gigigore!” ");
INSERT INTO bjz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aghá rea, númane erea tatavami aria, Josep nuyae Meri gha, kotú aná mendi nino oka yamena ari rorova ititurieta vasia irieta tatambuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tambua, aná mendida tamova anera manemi gaga donu regegutururia-nu, númanena regeguturieta fafate urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kotú avona, sifi kaifa kakatoda gaga regeguturia-nu niningiguturia, númane duduku-dadaka egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tago aghade, Meri dava donu siroruturia-nu nundubuturota irita urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Atá, aná sifi kaifa kakato kaverea igiguturota, God du raga rirota divua furia uta igiguturie. Anada bee mo, númanda donu gigiguturia, kotú niningiguturia anada bee dano siroruturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fura dabako seriguturieta, fura einida onembo tutunova aná mendida vii mendó andoro tafugari fefera buburiturie. Aghade, nue jo tambouvude ambi irieta, anerada furia undú ututuria ragaro, Iesu ririkurie. ");
INSERT INTO bjz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Gaga Moses da gefiria-va mo, evevetu mendi sasingu fumbua fefera tufoko irirota, anada ambova, God du vesa utua, númane rekago tutuno ea, God du Tafaroro Ari Kambova* iru-furu egegaita rousue. Aná fefera sidara urieta, Josep nuye Meri gha númanda mendi bua, Meri da ragarova vesa utaita, kotú aná mendi God dava irugea, isuri aita rea, Jerusalem igiguturie. Vesa donu utasua retora mo, unei ungagha o obani memendi ungaghanu vesa utasue. Aná mendi Jojabeeda dibeva isuri egegasua-da bee beago, Jojabeeda Gagava isuri rouvie. Aná evere, “Sasingu vivide bebego dano God da dibeva aná kakara re.” ");
INSERT INTO bjz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aghade, embó taubana eini dinunu tefo ragaro Simeon Jerusalem avo vitirie. Asisi Kakarami undava asuguturieta irirota, God na Israel enembodu sonemba bua furari fefera kaifa eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kotú, Asisi Kakarami seibe undava eghá ririe, “Imó jo amburambi irirota, God na natofo jededa ari-bari akokogo nundubea gia doaita rea, Embó eini ninengota endava voraita rouvia-nu inda dibe mokómi gaita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Avore, fefera eini Asisi Kakarami Simeon unumbea bua aria, God du Tafaroro Ari Kambova terua, kaifa ueta, Iesu nue numamode dano aria terua, God da Gagava donu vitia ananu aita simbugutueta gia, ");
INSERT INTO bjz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon aná mendi oghimbea bua, God du aiye rirota eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Jojabee, inona be gajiturera, aná etia, inda sabuadava* isagha etueta gereta, oreki rege-gea, amó siririgha serigore! ");
INSERT INTO bjz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","32","Anada bee mo, inda sonemba kato abua-abua endava nanjogo vitia-mi gari-du simbuguturera, aná anda dibemi rei-gerore. Ená mendimi, námane Israel enemboda unana bua reifie. Unona janimbuturota, námane Israel enemboda gitofo inda emboro gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aghá ririeta, aná mendida nue numamogha, Simeon da donu riria-nu niningigea, mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Aghá egeguturieta, Simeon na númane ea simbuguturota, Iesu da nue, Meri du eghá ririe, “Ená mendi God na gategea, Israel enemboda nundubari gaita ninengetueta etie. Ená mendi aná God da ivata re. Enembo dumeni, ená mendi gerurota, gangorogha jebuga bubugaita rousue. Tago, dumeni umó gia injigha egeguturota, undú gaga sembago regegaita rousue. Atá-gea, God na rata, númane jebuga jo tambambi egegaita rousue. Aghade, númane aghá egeguturota, númanda nundubari taubanade sembagode aná God umó gia tanana aita rouvie. Kotú, natofo jede inda mendi injigha egeguturota-gea, inda neno rova mema aná eto-bato giimi gayari-go aita rouvie.” Simeon aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Doru eini, ragaro Ana umó God da feroveta ea vitirie. Unda abua ragaro Aser re, kotú numamoda ragaro, aná Fanuel re. Umó vai ea, ghaeko 7 seriguturieta, unda embó ambubuturie. Urieta, umó doru ea irirota, umó ghaeko 84 urie. Umó aghade, tumba onembo God du Tafaroro Ari Kambova irirota, undari bari tama ea benunu urota, God tumogha baĩ eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Avore, Simeon Iesu da nuedu gaga ria aghade, Ana furia, númandava bubua, tutuno ea, God du aiye rea, avona avona God da sonemba Jerusalem anava siroraita rouvia-nu kaifa egegeta uria-du Iesu da bingá isagha urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep nuyae Meri gha, Jojabeeda Agho Dari-va sasingu fumbarida rifova donu ari-du riria, aghagonu ea sidara ea, númanda mendi bua kaverea aria, Galili frovensiva terua, númanda naa Nasaret bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bubua irieta, aná mendi anode neno nundubaride baria, jojabe ueta, God da ea simbugari, undava vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ghaeko inono Iesu da nue numamogha Serigea Yari Banaudu* rea, Jerusalem igigeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aghá egeguturota irieta, Iesu da ghaeko 12 urieta, aná banau dabako aghagonu aita rea, nue numamogha erea, Iesu bua, rekago Jerusalem igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aria, banau ea sidara egeguturia-da ambova, nue numamogha Jerusalem doa kaverea igigutueta, Iesu avo jiriturie. Tago, nue numamogha jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nue numamoghada nundubariva Iesu númanda natofode sei kaverea igigari gaa regeguturie. Aghá ria, emboro rorova tumba ririturieta, númanda totofoda, kotú kokomanada gorotova tava egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tava ea jajaregea, númanda mendi tava egegaita kaverea, Jerusalem igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tava ueta, fefera bakode sidara urieta, ambova umó God du Tafaroro Ari Kambo* rova Moses da Gaga Irugari kakatoda* rorova asumbea, númanda gaga niningurota, kotú númanda gagada minonu rirota irieta tatambuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iesu na gaga ningari taubana kotú gaga mino taubana riria-du, enembo avona niningiguturia-mi duduku-dadaka ea mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aghá ueta, Iesu da nue numamogha furia, umó gia, mana-mana ea, nuena eghá ririe, “Anda mendi, imó dodu ari eghá utata, nimamo angá mo, neno takembea, indú tava uta deĩ ria?” ");
INSERT INTO bjz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aghá ririeta, umó mino eghá ririe, “Nímane dodu amó tava rosa? Amó anda Afada Kambova irasira aghago, nímane sei gigigasiravore.” ");
INSERT INTO bjz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tago, unda donu riria-da bee, nue numamogha jo tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Anada ambova, nue numamoghade kaverea aria, Nasaret naava bubua irirota, nue numamoghada gaga ningia númanda aghi eta urie. Avotago, donu siroruturia dano, nueda neno rova iriaveta nundube-nundube eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aghade, Iesu unda tamode neno nundubaride dano baborurie. Aghá ueta, God umó neno buta urie. Kotú, enembode dano Iesu neno bubugeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Fefera anava, embó ragaro Tiberius umó, abua ragaro Rom enemboda kotofu ea irieta, ghaeko 15 sidara urie. Unda feferava, embó ragaro Pontius Pailat, umó Judia Frovensida kotofu ea vitirie. Herot umó Rom enemboda tuva Galili Frovensi kaifa eta urie. Kotú, Herot da kaka Filip umó Ituria Frovenside Trakonitis de kaifa eta urie. Aghade embó ragaro Lisanias umó Abilin frovensida kotofu ea vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Fefera dabako anava, bogu naa Jerusalem avo Jiusi enemboda fristida* beforo ririkigari ungagha Anas ungá Kaiafas ghana kofiri righita urie. Fefera aghade, Sekaria da mendi Jon umó uvu tefo enembo irambi kambesiva avo aria irieta, God na unda gaganu minono rari-du rea, Jon dava ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","God aghá ririeta ningia, Jon erea, roo enda Jordan uvu kasava deĩ urota, unda minono eghá reta urie. “Neno kaverea, nímanda ari akokogo isagha egeguturadi-gea, nímane bafutaito are! Aghá egegadora, God na nímanda ari akokogo nundubea gia doaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Seibe God ririeta, feroveta Aisaia unda buka rova Jon du gaga gefiria, aná evere: “Embó eini uvu tefo, kotú enembo irambi kambesiva irirota, ghogho reirie, ‘Jojabeeda emboro simbuge, dambu ae! ");
INSERT INTO bjz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Enda dafaru ghambegea vorea devisa ae! Kava afurege, vitia dambu ae! Emboro begina divege, dambu ae! Kotú emboro kava-kava dure vorea vivisegoe! ");
INSERT INTO bjz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aghade, God da sonemba isagha ata, enembo dano gigigaita rousue.’” ");
INSERT INTO bjz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Avore, enembo nanjogo Jon na númane bafutaito ari-du fufuguturieta, Jon na eghá reta urie, “Nímane angoghoda fufumbugari re. Nímane jo neno kaverambi irirota furá, bafutaito nuenembo egegadora, God ari akokogoda mino utaita rei-nundubutua, jo serigambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mania nendufako, ‘Anda afa Abraham re. Amó God da neno bari mendi re.’ regegata! God ená singoi rata, Abraham da sasingu nindari inono re. Unda bouvu serigaita nundubadora mo, neno kaverea, nímanda ari-bari akokogo doa, aito taubana fufugege! ");
INSERT INTO bjz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Oto seibe ika ruruva tafugaita simbugea vitie. Ika domi bee taubana righambi adua, umó vegea ivari tumanadu evirota vitia-va fugota, evaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon aghá reaveta, natofomi uriga eghá egegeta urie, “Atá námane daiyagha egega?” ");
INSERT INTO bjz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aghá reaveta, Jon umó mino eghá reta urie. “Nímandava ombari ungagha iradua, eini kosugea utu, makasi enembomi bubugoe! Undari beago aghago vesa egege!” ");
INSERT INTO bjz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aghade, fefera eini takesi bari kakato dumenimi, Jon na númane bafutaito ari-du furia, eghá regeguturie, “Irugari kato, námane buro daiyagha egega? Ananu rege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aghá regeguturieta, Jon mino eghá ririe. “Takesi da mino bee nuenembo enembodava bubuge! Mania kokomana kukuvirota, mino serigea jojabe bubugata!” ");
INSERT INTO bjz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anada ambova, mene-mene ari kakato dumeni beago furia bububugea uriga egeguturie, “Námane daiyagha egega?” regeguturieta, Jon mino eghá ririe, “Mania nímanda anomi enembo rea bera-bera ea, númanda guri rougea bubugata! Mania koto egeguturota mino baita rea gavera regegata! Kotú mania nímanda buroda minodu besiga egegata!” ");
INSERT INTO bjz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Enembo dano God na Sonemba Kato utaita riria-nu kaifa rosurie-gea, Jon da gaga riria-nu niningigea, mana-mana egeguturota, eghá nundubuturie, “God enemboda ari akokogo nundubea gia doaita rea, embó eini ninengota furari-du riria mo, Jon umó ra?” ");
INSERT INTO bjz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aghá nundubutueta, Jon itatama urota, eghá ririe, “Anona nímane tefo uvumi bafutaito eta rore. Avotago, anda ambova embó eini refia, umó ano tofo re, amó jo umongo irambi re. Anda anode duroghade jo undago irambi re. Nímane unona Asisi Kakarade ivaridemi bafutaito aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ená rera Embó, enembo iruraita simbugea vitie. Umó aayo einida numamo aghago re. Umó faragho genjeguturota, faravada vee simbugea bua, unda koromava ititurota, faragho fugota, tumanadu reivia ivariva evivigaita rousue,” ");
INSERT INTO bjz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon gaga dumeni aghago manenu rirota, númanda ari akokogo vuregari-du rea, God da Gaga Taubananu minono reta urie. ");
INSERT INTO bjz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Frovensi Galili da kotofuko ragaro Herot na, unda ikoko yae ragaro Herodias nu, ufuva yagera urie. Kotú, ari akokogo dumeni uria-du, Jon na tutuno ea, Herot da dibeva gaa ininigha reta urie. ");
INSERT INTO bjz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Avore, Herot na sei ari akokogo dumeni eta urie. Avotago, Herot unda kakada evetu bagia urie-gea, Jon na unda dibeva gaa reta uria-du, umó Jon bua diburava gajituria-mi, aná ari akuago bee urie. ");
INSERT INTO bjz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Herot umó Jon jo bua, diburava gajambi irieta, fefera eini, Jon na enembo avona uno egeguturia-nu, bafutaito ea sidara uria-da ambova, Jon na Iesu beago bafutaito urie. Aghá ueta, Iesu tutuno ea benunu uua, uutu ifeguturieta, ");
INSERT INTO bjz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Asisi Kakara mi dii ukugo nindia, Iesu dava vorea asumbuturie. Aghá urieta, uutuvareta be fugia eghá ririe, “Imó anda neno bari Mendi re. Inda irari gerurota, anda neno roo gangoromi beda rouvie!” ");
INSERT INTO bjz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu unda ghaeko 30 sidara urieta, umó tutuno ea, God Afada buro isaghava eta urie. Enemboda nundubari-va, Iesu umó Josep da Mendi re. Josep da numamo aná, Heli re. ");
INSERT INTO bjz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli da numamo aná Matat re. Matat da numamo aná Levi re. Levi da numamo aná Melki re. Melki da numamo aná Janai re. Janai da numamo aná Josep re. ");
INSERT INTO bjz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep da numamo aná Matatias re. Matatias da numamo aná Amos re. Amos da numamo aná Nahum re. Nahum da numamo aná Esli re. Esli da numamo aná Nagai re. ");
INSERT INTO bjz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai da numamo aná Mat re. Mat da numamo aná Matatias re. Matatias da numamo aná Semein re. Semein da numamo aná Josek re. Josek da numamo aná Joda re. ");
INSERT INTO bjz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda da numamo aná Joanan re. Joanan da numamo aná Resa re. Resa da numamo aná Serubabel re. Serubabel da numamo aná Sealtiel re. Sealtiel da numamo aná Neri re. ");
INSERT INTO bjz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri da numamo aná Melki re. Melki da numamo aná Adi re. Adi da numamo aná Kosam re. Kosam da numamo aná Elmadam re. Elmadam da numamo aná Er re. ");
INSERT INTO bjz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er da numamo aná Josua re. Josua da numamo aná Elieser re. Elieser da numamo aná Jorim re. Jorim da numamo aná Mattat re. Mattat da numamo aná Levi re. ");
INSERT INTO bjz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi da numamo aná Simeon re. Simeon da numamo aná Juda re. Juda da numamo aná Josep re. Josep da numamo aná Jonam re. Jonam da numamo aná Eliakim re. ");
INSERT INTO bjz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim da numamo aná Melea re. Melea da numamo aná Mena re. Mena da numamo aná Matata re. Matata da numamo aná Natan re. Natan da numamo aná Devit re. ");
INSERT INTO bjz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit da numamo aná Jesi re. Jesi da numamo aná Obet re. Obet da numamo aná Boas re. Boas da numamo aná Salmon re. Salmon da numamo aná Nason re. ");
INSERT INTO bjz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason da numamo aná Amminadab re. Amminadab da numamo aná Atmin re. Atmin da numamo aná Arni re. Arni da numamo aná Hesron re. Hesron da numamo aná Peres re. Peres da numamo aná Juda re. ");
INSERT INTO bjz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda da numamo aná Jekop re. Jekop da numamo aná Aisak re. Aisak da numamo aná Abraham re. Abraham da numamo aná Tera re. Tera da numamo aná Nahor re. ");
INSERT INTO bjz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor da numamo aná Seruk re. Seruk da numamo aná Reu re. Reu da numamo aná Pelek re. Pelek da numamo aná Eber re. Eber da numamo aná Sela re. ");
INSERT INTO bjz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela da numamo aná Kainan re. Kainan da numamo aná Arpaksat re. Arpaksat da numamo aná Siem re. Siem da numamo aná Noa re. Noa da numamo aná Lamek re. ");
INSERT INTO bjz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek da numamo aná Metusela re. Metusela da numamo aná Enok re. Enok da numamo aná Jaret re. Jaret da numamo aná Mahalalel re. Mahalalel da numamo aná Kainan re. ");
INSERT INTO bjz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan da numamo aná Enos re. Enos da numamo aná Set re. Set da numamo aná Adam re. Kotú Adam da numamo, aná God re. ");
INSERT INTO bjz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Asisi Kakarami Iesu dava asugea, umó unumbea, uvu Jordan doa, enembo irambi kotú uvu tefo kambesiva arie. ");
INSERT INTO bjz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Iesu tumba kotú onembo 40 avo irieta, Satan na umó kukuvirie. Aghade, Iesu undari tama urota, baimana itatama eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aghade, Satan Iesu du eghá ririe, “Imó God da mendi iradora mo, rege, ená singoi farava nindota undadi!” ");
INSERT INTO bjz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aghá ririeta, Iesu mino eghá ririe, “God amindu Gaga eghá ririeta, gefirie: Enembo jo undarimi jebuga bee tambua bambi aita rouvie,” ");
INSERT INTO bjz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iesu aghá ririeta, Satan umó unumbea bua aria, kambesi iti beeva jiria, roo enda nanjogo endava vitia-nu irugutueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Gerueta, Satan eghá ririe, “God unda ingo sokinembuturieta, ená enda dano anona rururere. Enembo avona uno adua mo, anona rata endada kotofuko ea, iraita rouvie. Kotú ená endava kambesi nanjogoda anode, kotú gugua-ghayafade dano utaitare. ");
INSERT INTO bjz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amindu, andú tumogha baĩ adora, ená endada durogha rei-gerora, indú utota baita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aghá ririeta, Iesu mino eghá ririe, “God da Gagava eghá reirie: ‘Nímanda Jojabee God nuenembo tumogha baĩ egege! Kotú unda uno nuenembo egege!’” ");
INSERT INTO bjz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aghá ririeta, Satan na Iesu unumbea bua aria, bogu naa Jerusalem bubua aria, God du Tafaroro Ari Kambo* fouva vitia, iti beeva jiria, Iesu du eghá ririe, “Imó God da mendi iradora mo, God da Gaganu gaabee urota, ená kambo fouvareta jau ege, gare! ");
INSERT INTO bjz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anada bee mo, God da Gaga eini eghá reirie: ‘God unda anera mane rata, imó kaifa ea goghó aita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kotú, God da Gaga eini eghá reirie: ‘Imó jau ea voradora mo, God na rata, anera mane númanda ingo beisi ea irirota, númanda ingova desembuturota, inda eka jo singoiva dea borambi aita roravore.’” ");
INSERT INTO bjz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Satan aghá ririeta ningia, eghá ririe, “Aná rera gaa bee re, avotago God da Gaga einiva eghá reirie: ‘Mania nímanda Jojabee God kuvia gigigata!’” ");
INSERT INTO bjz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Avore, Satan umó Iesu kuvirota jurota, gaita uria, jo inono ambi re. Aghá uria-du, Satan fefera tufoko Iesu doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Anada ambova, Iesu Asisi Kakarada anogha kaverea aria, Galili Frovensiva buburiturieta, Iesu da bingá aria, fafate urieta, aná frovensiva enembo dano niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aghade, Iesu deĩ urota, naa nanjogoda nghaĩ itari kambova* terua, minono reaveta, enembo niningigea, undú raga regegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu kaverea aria, unda baboruria naa Nasaret avo buburiturie. Aghade, unda sei eta uria aghagonu urota, nangu undari fefera einiva aria, nghaĩ itari kambova* teterurie. Terua, God da Gaga irugaita erea jiriturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aghade, God da Gaga Aisaia na gefiria ananu undú ututurieta ifegea, ená gaganu tambua iruguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Jojabeeda Asisi Kakara andava asugetueta vitere. Anada bee mo, makasi enembodava Gaga taubana rari-du amó ninengetue. Enembo bunditurieta vitia-nu vuregari-du, kotú enembo dibe soikidenu rata, dibe fangea, kambesi gia tanana ari-du retueta, refere. Kotú, enembo númanda kokotofumi jo tavo ambi rousua-nu sonembota jebugari-du refere. ");
INSERT INTO bjz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kotú God ená ghaekova unda jebuga irugaita rouvia-da gaganu rata, isagha ari-du retueta refere.” ");
INSERT INTO bjz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aghá irugea, Iesu aná buka eghovea gajea, unda kaifa katodava utua doa asumbuturie. Aghá ueta gia, aná nghaĩ itari kambo rova enembo dano, umonu tatasegea gigigutueta, ");
INSERT INTO bjz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","umó eghá ririe, “Ferovetada gaga oreki enembo irugetora, aná niningigutueta, bee siroretue.” ");
INSERT INTO bjz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aghade, Iesu da gaga jeuro niningigea mana-mana egeguturie. Ea, mino-mino uriga urota, eghá regeguturie, “Umó Josep da mendi re. Umó ená nundubari doda bua retu?” ");
INSERT INTO bjz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu umó mino eghá ririe, “Nímanda nundubaride, unode amó rei-gerore. Andava eghá raita reisi-nundubetoravore. ‘Inda ano rera-da beenu irugasueta, námane gigigasire!’ O nímanda reisi-nundubetora gaga eini evere, ‘Imó naa Kafernaum ivata anogha dumeni utata, enembo gigigea, raga regeguta aghagonu adi-gea, námane imó gaabee egeguturota, raga regegore!’ ");
INSERT INTO bjz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Atá amó nímandu gaa bee rere, ferovetada gaga aná enembo dano niningigea, umó kakara egegeta rousue. Avotago, feroveta unda totofo aná jo umó gaabee urota, kakara egegambi eta rousue. Ari dabako aghagonu nímanena andava eta rosoravore. Amó nímanda eini-gea, amó jo gaabee egegambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kotú, feroveta Elaija da kikinu nundubea gigige! Elaija da feferava dodoru oruabe Israel vitiria aghade, unona benunu urieta, boruma vorambi ghaeko bakode serigea, eini tutuno ea aria, rorova urie. Aghade aná roo endava enembo dano baimana jojabe itatama egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Avotago, umó namonde anda natofoda doru eini jo sonembambi re. God na ririeta, Elaija aria, gitofoda frovensi Saidon terua, kambesi ragaro Sarefat avo gitofoda doru eininu sonembuturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Dabako aghago, feroveta Elisa da feferava Israel enembo oruaruabedava fetarami gigimbea, tamo akuago urieta vitirie. Avotago God jo rata jejebugambi re. Tago, God na ririeta, namonde anda gitofo enembo Siria embó ragaro Naman umó unuka jebuguturie.” ");
INSERT INTO bjz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aghá ririeta, aná natofo nghaĩ itari kambova vitiria-mi niningigea, neno akokogo egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Aghá ea erea, Iesu ingova ghambugea bua, kokava fugota jua dea amburari-du naa dighia asumbuturia ootova yavurie. ");
INSERT INTO bjz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Aghá urie-tago, Iesu aná natofoda gorotova ghosá ea, númane doa seriguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Anada ambova Iesu aria, Galili Frovensi da naa eini Kafernaum buburiturie. Bubua, nangu undarida rifo buburituria-du, nghaĩ itari kambova terua, tutuno ea, enembo nghaĩ ituturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aghá ueta, natofo niningigea duduku-dadaka egeguturie. Anada bee mo, unda gaga aná anogha ririe. ");
INSERT INTO bjz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aghade, embó eini taimu akuagomi asuguturieta nghaĩ itari kambo* rova vitiria-mi Iesu gaga rieta rei-niningurieta, taimuda anomi rururieta be koko rea, eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eeee! Nasaret embó Iesu, imó námandava daiyagha ado? Imó námane data amburari-du futara, aĩ, tefo? Imó embó avouvi, amó rei-gerore. God da Embó kakara utaita riria, aná imó re.” ");
INSERT INTO bjz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aghá ririeta, Iesu na undú ininigha eghá ririe, “Be do! Aná embóda tamo rova doa, fu isaghava bubadi!” Aghá ririeta, taimumi isaghava bubaita erorurota, aná embó fugiturieta, natofoda dibeva jujururieta, taimu isaghava buburiturie-tago, aná embódava donu jo ambi re. ");
INSERT INTO bjz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aghá ririeta, enembo dano duduku-dadaka ea, mana-mana urota, mino-mino rea niningiguturie, “Ená irugari doro? Ená irugari reka siroretue. Unda anomi reaveta, taimu akokogo mane enemboda tamo rova irari unda gaga ningia, fuava isaghava bububugeta rousue,” ");
INSERT INTO bjz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aghá urieta, Iesu da bingá aria, kambesi dano fafate urieta, enembo dano niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aghá uria-da ambova, Iesu nghaĩ itari kambo* doa aria, Saimon da kambova teterurie. Teteruria mo, Saimon da imboti kae bua, tamo veriveri jojabe itatama urota vasia iria-du, Iesu na sonembari-du benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aghá regeguturieta ningia, Iesu terua aria, aná evetuda kasava jiria, ininigha aná evetuda tamo vevera sidara ari-du ririeta, gaimbo ambi unda tamo vevera sidara urieta, jebugea erea, númanda uno dano simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aghade jama urieta, kae dibe eini be eini bua fugea vitiria enembonu, númanda kokomanami unumbea fufuguturieta, Iesu na unda ingomi tamova righia ririeta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kotú enembo oruabedava taimu akokogo manemi asusugea vitiria dano, Iesu na ririeta, bububuguturota, be fugia, “Imó God da Mendi re,” regeguturie. Tago, Iesu ininigha, númane gaga eini regegauva-degea bureguturie. Anada bee mo, aná God da utaita riria Embó umó re, númane gari re. ");
INSERT INTO bjz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rifo atea furueta, Iesu erea, aná kambo doa, enembo irambi kambesiva arie. Aghá urieta, enembo dano erea, umó tava uta aria tatambugea, Iesu númane doa yauve-degea bureguturie. ");
INSERT INTO bjz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Avotago, umó númandu eghá ririe, “Amó God enembo kaifa aita rouvia-da gaga taubana, naa dumeniva beago minono raita rore. Anada bee mo, God amó ananu ari-du ninenguturieta refere.” ");
INSERT INTO bjz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aghá rea, Iesu erea aria, Jiusi enemboda roo enda anava biruru urota, naa nanjogo nghaĩ itari kambova terua, minono reta urie. ");
INSERT INTO bjz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Fefera eini Iesu Galili Sao betuva jiria, minono rieta, enembo oruaruabe furia danode ea, God da Gaga niningigaita rea, mino-mino mimengi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aghade, ghaa* ungagha uvu oka bari kakatomi buri ea, moyuva seseghegutueta, Iesu gerurie. ");
INSERT INTO bjz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gerurie-gea, umó aria, ghaa eini, Saimon da tofo, anava vorea ririeta, itoko ga sireguturieta, kafuru kena buburiturieta, umó aná ghaa etova asumbea, natofodu minono ririe. ");
INSERT INTO bjz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Umó gaga rea sidara ea kaverea, Saimon du ririe, “Ghaa itoko kafuru kena ga sirege, bubota, nímanda moyuva fugadi vorota, uvu oka beroe!” ");
INSERT INTO bjz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aghá ririeta, Saimon na mino ririe, “Jojabee, námane tumba numbo moyuva fufugegetora, oka eini jo bambi re. Avotago, inona rera-du, amó moyuva fugota vorota gaita rore.” ");
INSERT INTO bjz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aghá rea, númane Iesu da riria aghagonu egeguturieta, uvu oka oruaruabe beberueta, númanda moyuva mane bejaita ua-du, ");
INSERT INTO bjz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","númanda kokomana ghaa einivami sonembari-du ingomi toghoto egeguturieta, númane furia sonembea, ghaa ungagha dano fefendiguturieta, beda ea, rosaita itoko urie. ");
INSERT INTO bjz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aghá urieta, Saimon Pita gia, duduku ea, Iesu da eka tuva koubomi jengirea eghá ririe, “Jojabee! Amó aná ari akuago embó reta. Amó doa serige!” ");
INSERT INTO bjz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Anada bee mo, Saimon Pita unda kokomanade dano, númanda uvu oka oruabe beberiguturia-nu gia, duduku-dadaka ea mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kotú Saimon da kokomana, Sebedi da sasingu, Jems ungá Jon gha beago, aghá egeguturie. Anada ambova, Iesu na Saimon du ririe, “Saimon, oru mania ata! Enada ambova imó enembo unumbea bua, andava furadi, anda ambo nimbi egegoe!” ");
INSERT INTO bjz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aghá ririeta, númane ghaa jumbua vitia, mangosava itia, eini-eini dano doa, Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Fefera eini Iesu aria, naa einiva irieta, embó eini tamo fetarami gigimbea irarimi furia, Iesu gerurie-gea, gonea vorea, dibe bee endava takembea, eghá ririe, “Jojabee, amó tanana rore, ano indava vitia, aná inono bee re. Aghá-gea, imó uno adora, ege-gea, amó jebugore!” ");
INSERT INTO bjz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aghá ririeta, Iesu ingo sinia, aná embóda tamova ririkurota ririe, “Amó uno roreta, imó jebuge!” ririeta, jo gaimbo ambi beto mane aná embóda tamova sidara urie. ");
INSERT INTO bjz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aghá urieta, Iesu na aná embódu eghá ririe, “Anda donu etora, mania enembodu rata! Tago, dibe dambu ii, fristidava* bubua, inda tamo irugadi gata, Moses da Agho dari-va bebeta irari doa jegubaria-da vesa daiyagha dungari-du reiria aghagonu ege-gea, enembo dano imó jebugetora-nu, gigigoe!” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Avotago, Iesu da aghá uria gaga, gaimbo tefo sirorea aria, naa dano fafate urieta, enembo oruaruabe unda gaga niningigaita, kotú númanda kae mane ata jebugaita rea, fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tago, fefera oruabe Iesu bubua iiava, enembo irambi kambesiva benunu eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Fefera eini, Moses da Gaga Kaifa Kakato*, kotú Agho Dari Irugari kakato Galili Judia ghada frovensiva naa ijoijokoko kotú Jerusalem bogu naavareta furia, avo asusumbea irieta, Iesu enembo iruguturie. Aghade, kae bari enembo ata jebugarida ano Jojabeena Iesu dava ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Aghade, enembo dumenimi embó eini eka ingo dimbari-denu ghaitova itia fumbua, aná kambo rova terua, Iesu da dibeva itaita rea, fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tago, aghade kambo enembomi beda urieta, númane aná embó bua ririva vitia, kambo fouva jiria, tino ea, birigha righia bejea sireguturieta, natofoda rorova vorea, Iesu da dibeva vavosurie. ");
INSERT INTO bjz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","21","Aghade Iesu aná enemboda gaabee ari gia, aná eka ingo dimbaride embódu ririe, “Anda komana, inda ari-bari akokogo nundubea gia dotore.” Aghade, Moses da Agho Dari Kaifa kakato, kotú Irugari kakato tutuno ea, eghá nundubuturie, “God unuka ari-bari akokogo nundubea gia doari inono re. Tago, ená embó ari-bari akokogo unona nundubea gia doari gaa reiria-mi, God da ragaro fara rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu númanda nundubari seibe tanana ea, uriga eghá urie, “Nímane dodu neno roomi aghá reisi-nundubuto? ");
INSERT INTO bjz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Atá nundubea gigige! Niana mo rauko ro? ‘Inda sembago nundubea gia dotore!’ rari mo, rauko ra, aĩ? o ‘Erea deĩ ege!’ rari mo rauko ra? ");
INSERT INTO bjz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Enanu ata, gigigea, tanana egegaita rosoravore: ari-bari akokogo nundubea gia, doarida ano Enemboda Jojabeedava* vitie.” Aghá rea kaverea, aná embó eka ingo dimbaridu eghá ririe, “Amó indú rere: Erea, inda ghaito borea bua, kambova ii!” ");
INSERT INTO bjz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aghá ririeta, jo gaimbo ambi, aná embó númanda dibeva erea, unda vasia vitiria ghaito borea bua, God du raga rirota kambova arie. ");
INSERT INTO bjz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aghade enembo dano mana-mana jojabe ea, kotú oru egeguturota, God raga rirota, eghá regeguturie, “Namonde amó eghago jo gigigambi vitata oreki siroretueta, namonde anda dibemi gigigetore.” ");
INSERT INTO bjz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Anada ambova, Iesu bubua aria, takesi bari kato embó ragaro Levi, unda takesi bari dobova asumbea irieta gia, Iesu na undú ririe, “Erea, anda ambova fu!” ");
INSERT INTO bjz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aghá ririeta, Levi erea, eini-eini dano doa, Iesu da ambova arie. ");
INSERT INTO bjz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Anada ambova, Levi unda kambova Iesu du banau jojabe urieta, takesi bari kakato oruabe, kotú enembo dumenide danode ea undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Avotago, Moses da Gaga Kaifa ari kakatoda noniva vitiria Irugari kakatomi* gigiguturie-gea, Iesu da ambo nimbidu eghá regeguturie, “Nímane bee dodu takesi bari kakato, kotú ari-bari akokogo ari kakatode undia-dandia eta roso?” ");
INSERT INTO bjz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aghá regeguturieta, Iesu númandu mino eghá ririe, “Avona, ‘Andava kae tefo re,’ radua mo, ingi embó undava jo yambi aita rouvie. Kotú avona, ‘Amó kae bere,’ radua mo, ingi embó undava yaita rouvie. Amó enembo akokogomi númanda ari-bari akokogonu karigari-du furere, jo enembo taubana ghogho raita furambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amó eve jo God da Agho Dari kaifa ea goghó urota, ambo-ambo eta rousua enembodu furambi re. Tago, ari-bari akokogo enembo rata, númanda ari bari akokogo vuregea doa, taubana irari-du rea, etere. ");
INSERT INTO bjz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aná enembomi undú eghá ririe, “Jon da ambo nimbi fefera dumeni aná tama egeguturota, benunu egegeta rousue. Kotú, Moses da Gaga Kaifa kakatoda* ambo nimbi beago, aghá egegeta rousue. Avotago, inda ambo nimbi aghá ambi, tefo undia-dandia egegeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ririeta, Iesu undufa iruguturota, mino númandu eghá ririe, “Nundubea gigige! Embó eini evetu yagera adua-da banau feferava, namonde amó jo regegota, undava desaita rousua enembo undari tama egegambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tago, fefera furá bubota, aná evetu yagera adua embónu bua data amburadua aghade, undú neno mema egeguturota, undari tama egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kotú, kasia eini númandu eghá ririe, “Embó eini avodava eembo too ea iradua mo, jo eembo rekami tafugea bua itia fifinembambi aita rouvie. Umó aghá asua, aná eembo reka tefo tafugasueta, too asue, kotú aná eembo reka seigha jo gari taubana ambi asue. ");
INSERT INTO bjz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ari dabako aghago vaini reka jo bua kofiri seiva averegota irambi aita rouvie. Aghá adora mo, vaini rekada anomi ata-gea, aná kofiri bejea, vaini averegea vorea, akuago aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amindu, vaini reka aná kofiri rekava averegasueta taubana irasue. ");
INSERT INTO bjz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Enembo vaini seinu undia sidara ea, avona vaini reka averegea bua furadua mo, númane uno ambi egegaita rousue. Númanda nundubariva, vaini sei munogha-gea, uno gogorego egegeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nangu Undari Fefera einiva Iesu farava govari vitiria aayo maneda rova, deĩ irueta, unda ambo nímbi tutuno ea, farava bee dumeni bubugea, ingomi dadasegea, vusi figiturota, beenu undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aghá egegutueta, Moses da Gaga Kaifa kakato* dumenimi uriga egeguturie, “Nímane dodu namonde anda Agho Dari bejiturota, Nangu Undari Feferava aghá roso?” ");
INSERT INTO bjz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aghá regeguturieta, Iesu mino eghá ririe, “Nímane anda ambo nimbidu gaa rera, aĩ? Devit unda kokomanededa baimana itatama ea, donu egeguturia-da gaga irugea gigigambi ra? ");
INSERT INTO bjz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Devit unda kokomanade, God du Tafaroro Ari Kambova terua, farava ingari kakara, God da ragarova vesa ututuria-nu bua, Devit na undia, unda kokomana dumenidu ututurieta, undidiguturie. Aghá egeguturia-mi Agho Dari bebejeguturie. Fristi mane nenuka aná farava ingari kakara undidigasue.” ");
INSERT INTO bjz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aghá rea, Iesu rekago númandu eghá ririe, “Enemboda Jojabee*, umó Nangu Undari Feferada Jojabee re.” ");
INSERT INTO bjz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nangu Undari Fefera einiva, Iesu aria, nghaĩ itari kambova* terua rei-iruguturie. Aghade, embó eini ingo bee dimbaride avo vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moses da Gaga Irugari kakato*, kotú Kaifa Kakato dumenide dano, Iesu daiyagha bua, koto arida ruru tava egeguturota, amindu utuvako kaaka gigiguturie, umó Nangu Undari feferava aná embó ata jebugadua, aĩ, tefo? ");
INSERT INTO bjz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Aghá egeguturie-tago, Iesu númanda nundubari gerurie-gea, aná embó ingo dimbaridedu ririe, “Erea, enemboda dibeva jire!” ririeta, aná embó erea avo jiruturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aghá urieta, Iesu númandu eghá ririe, “Amó nímandava uriga rore. Agho Dariva mo, namonde amó Nangu Undari feferava donu ari-du reiri? Ari taubana ari-du reiria, aĩ, ari sembago ari-du reiria? Kotú enembo sonembota jebugari-du reiria aĩ, data amburari-du reiria?” ");
INSERT INTO bjz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Umó kaverea enembo dano gia biruru ea, aná embódu, “Ingo ruruge!” ririe. Aghá ueta, unda ingo taubana dogo urie. ");
INSERT INTO bjz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aghá urieta, númane neno sembago egeguturie-gea, tutuno ea, Iesu du donu egegasua-da manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Fefera aghade, tumba eini Iesu aria, dafaruva vitia, God dava benunu rorurieta, rifo atiturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Rifo atiturieta, unda yavero dano ghogho ririeta, undava fufuguturieta, enembo dano 12 unda Gaganu bua, minono regegari-du kotú unda ambo nimbi bee ari-du gateguturieta jiriturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Einida ragaro Saimon re, tago Iesu na unda ragaro reka “Pita” ririkurie. Saimon da ikoko, Andru, Jems ungá Jon gha, Filip ungá Bartolomyu gha, ");
INSERT INTO bjz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems da akau eini, aná Alfius da mendi re, Saimon da akau unda ragaro eini “Tuvari kato” re. ");
INSERT INTO bjz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Kotú dumeni, aná Jems da akau eini da mendi, ragaro Judas, kotú Judas da akau aná Keriot embó re. Keriot embó Judas rera, unona ambova Iesu nungia, gitofoda ingova ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu unda ambo nimbi gategea rururia-de dafaruvareta vorea aria, enda devisava unda yavero oruabede jijireguturie. Aghade, Judia Frovensi de, Jerusalem de kotú, Tair de Saidon deda bogu naa karaje diva enembode dano furia desea vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Númane Iesu da gaga niningigaita, kotú númanda kae ata jejebugaita rea fufuguturie. Enembo avona taimumi asugea vitiria beago fufuguturieta, Iesu na ririeta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aghade, enembo dano unda tamo ririkigaita egeguturie. Anada bee mo, ano undavareta bubua irueta númane dano jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu unda yavero gerurota, eghá ririe, “Imó avona makasi iririgadora, fefera ambova God na imó kaifa aita rouvia-du, gangoro egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Imó avona baimanagha vitera, ambova imó undia inono aita rora-du, gangoro egege! Imó avona dari sorara urota vitera, ambova gegha raita rosora-du, gangoro egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Imó avona Enemboda Jojabee* gaabee egegadora-du, enembo indú injigha egegadua, o indú ambo ututugadua o tauga kavavana regegadua o imó taimu gaa regegadua, gangoro egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Númanda abua manemi feroveta mane dava mema bouvu dabako aghagonu ututugeta urie. Aghá egeguturadua feferava, gangoro urota, daa didivugadi rere! Anada bee mo, inda mino jojabe uutuva simbugari vitia-nu utota baita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tago, imó avona gugua-ghayafade vitera, ambova imó neno mema aita roravore. Anada bee mo, inda jebuga rauko seibe rei-ruroravore. ");
INSERT INTO bjz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Aghago, imó avona undari undia inono rora, ambova imó baimana itatama aita roravore. Imó avona gangorogha vitera, ambova imó neno mema urota, jiigha iraita roravore. ");
INSERT INTO bjz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kotú endada enembomi indú raga radua, ambova imó neno mema aita roravore. Anada bee mo, númanda mambube manemi feroveta gavera kakato dava beago raga regeguturie.” ");
INSERT INTO bjz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Avotago nímane avona anda gaga reisi-niningora enembodu rere. Nímanda gitofo neno rururota, imó injigha egegadua enembodu ari taubana egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Avona nímandu simboro fugadua, Jojabeeda Ragarova umó ea simbugadi! Kotú avona nímandu ari sembago adua, númandu benunu egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kotú enembo avona nímane ofova dadua, kaverea-gea, ofo yoveni beago dae! O enembo avona nímanda asugari etova badua, do-gea tu asugaride dano bae! ");
INSERT INTO bjz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Enembo avona nímandava eini-einidu benunu adua, ututuge! O enembo einimi nímandava eini-eini soregami badua mo, mania rekago utari-du benunu egegata! ");
INSERT INTO bjz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Enembomi nímandu daiyagha ari-du uno adora aghagonu, númandu aghá egege! ");
INSERT INTO bjz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Atá, enembo avona imó neno rei-rurua, nuenembo neno badora, God jo nímandu gangoro ambi aita rouvie. Anada bee mo, ari sembago enembo beago númane avona neno buta rousua, ananu neno buta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aghago, enembo avona nímandu ari taubana egegadua nuenembodu ari taubana egegadora mo, God jo gangoro ambi aita rouvie. Anada bee mo, ari sembago enembo beago, aghá egegeta rousue! ");
INSERT INTO bjz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kotú inda guri rekago baita rea, gugua-ghayafade enembodu utadora, God jo indú gangoro ambi aita rouvie. Anada bee mo, ari-bari akokogo enembo beago, númanda guri utota bua, mino rekago aghago utari-du rea, númanda kokomanadu ututa rousue. ");
INSERT INTO bjz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","36","Tago, nímane eghá egegadi rere. Nímanda gitofo neno rururota, númandu taubana egege! Guri utadora mo, mino bari mania nundubata! Eto-bato inda Afami ari akuago enembodu neno mema ea, mino jo utambi eta rouvia aghagonu, egegadi rere! Aghá egegadora, nímane God Iti Bee Itivada sasingu ea vitera-du, mino jojabe ambova utota bubugaita rosoravore. Anada bee mo, enembo sembago unda gaga ningambi urota, undú ‘aiye’ jo rambi eta rousua enembodu umó ari taubana eta rouvia, dabako aghagonu egegadi rere.” ");
INSERT INTO bjz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Atá, imó enembo einida akokogo iruradora, God na imó beago iruraita rouvie. Enembo einida akuagodu rea, bouvu mania utata! Aghá adora, God na indú bouvu utaita rouvie. Kotú enemboda akokogo nundubea gia doadora, God na imó beago nundubea gia doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Enembo dumenidu vesa ege, God indú vesa ae! Aghá adora, God na inda mino taubana utaita rouvie. Vesa enembo dumenidu inda ututa rora-da mino dabako aghagonu, God na indú utota, ingova beda ea averegea voraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu na númandu kasia eini eghá ririe. “Embó eini dibe soikidemi kotú dibe soikide einidu emboro irugari jo inono irambi re. Aghá adua mo, ungá dano kavava jujugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sikuru embó einida bingá jo unda irugari katoda bingá aghago irambi re. Tago, umó sikuru ea goghó adua, umó unda irugari katogo aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kotú imó dodu inda komanada dibeva susundo ijoko gerurota, ika jojabe inda dibeva vitia mo, gambi ro? ");
INSERT INTO bjz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aghadu, mania enembo taubana gaa rirota, aghagago egeguturota, nímanda komanadu eghá regegata! ‘Ariee, mambu, do-gea amó inda dibeva susundo vitia-nu bua fugore!’ Atá, inda dibeva ika jojabe vitia, jo gambi irirota, aghá regegadora mo, jo taubana irambi re. Taubana mo, sei nímanda dibeva ika jojabe vitia-nu bua fugea, ambova nímanda komanada dibeva susundo ijoko vitia-nu, isaghava gia goghó urota, bua fugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ika taubana jo bee sembago righambi aita rouvie. Aghago ika sembago jo bee taubana righambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Enembo ika nanjogoda beenu gerurota, aná ika doro aná tanana eta rousue. Enembo jo baga beenu ghavesi gingideva bambi aita rousue. Aghago ghavesi vaini da bee jo ghavesi babumadava bambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aghagonu embó taubana, unda neno rova gaga taubana vitia-nu reaveta, isaghava bubuta rouvie. Kotú embó sembago unda neno rova gaga sembago vitia-nu reaveta, isaghava bubuta rouvie. Anada bee mo, enemboda neno rova domi beda ea iradua-nu rata isaghava bubaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nímane dodu andú ‘Jojabee, Jojabee!’ regeguturota, anda gaga ambo-ambo egegambi eta roso? ");
INSERT INTO bjz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Enembo avona andava furá, anda gaga ningia, ivatava ititigadua, númane daiyaghago ro? Ananu irugota gigigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Umó eto-bato embó eini kambo etua, aghago re. Tutunova, enda ghambea vorea, singoi jojabebeida etova tutumbu jengirea kambo etue. Aghá etueta, uria bubie-tago, aná kambo ea goghó etua-du, jo yavi-yavi ambi re. ");
INSERT INTO bjz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Avotago, enembo avona anda gaga ningia, jo ivatava itambi adua, umó aná eto-bato embó eini unda kambo mangosa endava etua, aghago re. Etueta, uria bubieta, aná kambo gaimbo ambi jua dea, bununu etue.” ");
INSERT INTO bjz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Natofo dano niningigutueta, Iesu minono rea sidara uria-da ambova, umó aria, Kaperneam teterurie. ");
INSERT INTO bjz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aghade, avo Rom enemboda mene-mene ari kakatoda beforo righari einida neno bari sabua* katomi kae bua amburaita ueta, ");
INSERT INTO bjz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","mene-mene ari kakatoda beforo righarimi Iesu da bingá niningurie-gea, Jiusi enemboda babarigari embobo dumeni, Iesu rata furá, unda sabua embó righota jebugari-du, ninenguturieta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Númane aria, Iesu dava bubua, aná beforo righarida ragarova umó furari-du benunu urota, eghá regeguturie, “Inona umó sonembasira, aná taubana re. ");
INSERT INTO bjz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Anada bee mo, umó namonde anda natofo Jiusi enembo neno bua, namonde anda nghaĩ itari kambo* ituturie.” ");
INSERT INTO bjz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aghá regeguturia-du, Iesu erea, numonde igiguturie. Umó aria, kambo utuva ueta, aná Rom enemboda mene-mene ari kakatoda beforo righarimi unda kokomana dumeni ninenguturota, undú eghá rari-du ririe, “Jojabee, mania indufako nundubari gogorego ata! Anada bee mo, anona imó rata andava furari jo inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kotú dabako aghagonu, andufako anda nundubariva, anona ya, imó tambari beago, jo inono irambi re. Amindu, tefo beemi rege-gea, anda sabua kato jebugoe! ");
INSERT INTO bjz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aghá rera-da bee mo, amó anda barirarida tuva vitere. Aghago, amó anda mene-mene ari kakatoda beforo righari jojabe re. Mene-mene ari kakato dano anda tuva irita rousue. Aghá-gea, anona, ‘Imó ii!’ rari, aná ita rouvie. Kotú ‘Fu!’ rari, aná futa rouvie. Kotú anda sabua katodu, ‘Enanu ege!’ rari, aná eta rouvie.” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu aná gaga ningia, duduku ea, mana-mana urota, kaverea, natofo unda ambova reisi-furia-du eghá ririe, “Amó nímandu eghá rere. Amó namonde anda natofo Israel enembodava gaabee ari jojabe eghago jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Anada ambova, aná aghi furia enembo kaverea aria, kambova buburituria mo, aná sabua embó sei jebugea irieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aghá uria-da ambova jo gaimbo ambi, Iesu unda ambo nimbide, kotú natofo jede dano kaverea, naa eini ragaro Nain avo igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Umó aria, naada kara bebatova teteruua mo, evetu doru einida mendi dabako reta ambubuturieta fumbua bubaita fufuguturie. Aghade, aná naava enembo oruabe aná evetude fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Fufugutueta, Jojabee aria teterurota gia, aná evetudu neno mema urie-gea, eghá ririe, “Mania jii rata!” ");
INSERT INTO bjz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aghá rea, umó bubua aria, aná amburari mendida farova ririkua-du, aná mendi fumbua reisi-aria jijireguturieta eghá ririe, “Mendi, anona imó eradi, rere!” ");
INSERT INTO bjz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aghá ririeta, aná amburari mendi erea asumbea tutuno ea, gaga rieta, Iesu na bua, unda ayadava ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aghá urieta, natofo oru egegea, God raga rirota, eghá regeguturie, “Ená feroveta jojabe namonde anda rorova siroretue. God unda natofo sonembaita etie,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesu aghá uria-da bingá aria, Judia Frovensi rova, kotú kasava naa dumeniva beago, fafate urie. ");
INSERT INTO bjz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Iesu donu uria-nu, Jon Bafutaito ari katoda ambo nímbimi regeguturieta ningia, Jon númanda rorova enembo ungagha ririeta furieta, Jojabeedava uriga eghá ari-du ninenguturie, “Jon na embó eini furaita rouvia riria mo, imovia aĩ, embó eininu kaifa egegara?” ");
INSERT INTO bjz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aghá rari-du ririeta, aná embobo ungagha aria, Iesu dava bubua, eghá regeguturie. “Jon Bafutaito ari katomi námane, indava uriga ari-du ninengetueta etere, ‘Jon na embó eini furaita rouvia riria mo, imovia aĩ, embó eininu kaifa egegara?’” ");
INSERT INTO bjz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aná fefera aghade, Iesu na kae akokogo bubugea irari enembo, eka ingo tatakembari, kotú taimu akokogo manemi asugota iririgaride, dibe soiki mane aná dano eaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Amindu, Iesu aná aghi aria enembodu eghá ririe, “Kaverea ii, nímanda donu dibemi gera, kotú nghaĩmi niningigetora-nu isagha egegadi! Enembo dibe soikide unana reisi-gerue, eka takembari jejebugea, yari furari rousue. Tamo betomi gigimbari enembo tamo taubana egegetue. Aghago, nghaĩ gajari gaga reisi-niningue. Amburari enembo righieta jebugea ererueta, Gaga Taubana makasi enembodu minono rere. ");
INSERT INTO bjz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Avore, enanu gigigetora-du, kaverea Jon du eghá regegadi, ningoe, ‘Andú jo mana-mana ambi egegadua enembodava, ea simbugari taubana iraita rouvie.’” ");
INSERT INTO bjz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon Bafutaito ari katoda aghi kakato kaverea igigutueta, Iesu tutuno ea, Jon du natofodava minono eghá ririe, “Nímane, aná enembo tefo uvu tefo kambesiva donu gigigaita igigeto? Nímane mo, tefo aufogho yaurami righia vuri-vara uua-nu gaita igigetora? ");
INSERT INTO bjz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Atá, nímane donu gigigaita igigeto, embó eini dighari ombari taubana asugea vita-nu gigigaita igigetora, aĩ? Tefo, gugua-ghayafade enembo bo-eembo esiko-esiko asugea irita rousua, aná kokotofuda kambova tatambugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aghá re-tago, nímane donu gigigaita igiguta? Feroveta ra? Avore, aná gaa bee re. Kotú amó nímandu rere, Jon aná feroveta maneda itiva re. ");
INSERT INTO bjz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Feroveta Aisaia na gaga Jon du gefiria, aná evere, ‘Amó anda aghi kato sei ninengota ya, inda emboro simbugaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Amindu, amó nímandu eghá rere, evevetuda fufumbuguturia enemboda rova, eini jo Jon aghago irambi re. Umó embó bingáde, kotú embó jojabe eini re. Tago, amó emboro reka ifegaita rora anava, avona ya, God da natofova* teradua, aná enembo gangoro jojabe egegaita rousue. Jon jo aghá ambi re. ");
INSERT INTO bjz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Bingá tefo enembode, kotú takesi bubugari kakatode, God unda simbuguturia emborodu taubana gaa rirota, ‘avore’ regeguturieta, númane dano Jon na bafutaito urie. ");
INSERT INTO bjz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tago, Moses da Agho Dari kaifa kakatode*, kotú Agho Dari Irugari kakatode, nendufako Jon injigha urota, God na númanda rorova donu asua-nu seriguturota, jo ‘avore’ rambi egeguturieta, Jon númane bafutaito ambi re.”) ");
INSERT INTO bjz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kotú, Iesu eghá ririe, “Enembo oreki endava sirorea vitia mo, daiyaghago ro? Ananu isuri aita rore. ");
INSERT INTO bjz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nímane eto-bato sasingu manego re. Atá, sasingu mane naa rorova asusumbea irirota, mino-mino be fugia eghá regegeaveta niningigeta rosore: ‘Tutunova námane nímandu veku furetore-tago, nímane jo daa didivugambi re. Kotú ambova námane jii yairi gatetore-tago, nímane jo jii regegambi re.’ ");
INSERT INTO bjz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aghá rera-da bee mo, Jon umó sirorea furia-va, faravade vaini de tama ueta, nímane, umó taimu akuagomi asugea irari gaa regegeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tago, Enemboda Jojabee* etia, faravade vain de dieta, nímane gigigea, eghá reisi-reravore, ‘Ená embó undaride, kotú vaini deda jinanga kato re. Umó takesi bari kakatode, kotú ari-bari akokogo egegari kakatodeda komana re.’ ");
INSERT INTO bjz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tago, God da nundubari taubana avodava vitia-da aito fugari gigiguturota, namonde tanana egegeta rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Moses da Agho Dari kaifa kato* einimi Iesu gha undari undaita uno uria-du Iesu aria, aná embóda kambova terua, undari kambesiva asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aghá ueta, ari akuago evetu eini aná naava irita uria-mi, Iesu Moses da Agho Dari Kaifa kato einida kambova aria, undari dieta ningia, aná evetumi botoro eini singoi ragaro arabastami ariva uka muu munodenu avo averegea bua aria, aná kambo rova teterurie. ");
INSERT INTO bjz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Terua, Iesu da ambo kenava jiria, jii rirota, gonea vorea, Iesu da eka unda dibe jivumi seseghurie. Aghá ea, unda foumami dufea, Iesu da ekava muno urota, aná uka muumi avereguturie. ");
INSERT INTO bjz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aghá ueta, Moses da Agho Dari Kaifa kato, Iesu ririeta aria, embómi gia, umó neno roomi undufako nundubuturie, “Ená embó feroveta irasua mo, ená evetu avona unda tamova rei-ririkua, aná gasue. Unda ari bari akokogo eta rouvia, kotú umó daiyaghago, aná gia tanana asue.” ");
INSERT INTO bjz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Umó aghá nundubutueta, Iesu undú eghá ririe, “Saimon, amó indú gaga eini raita rore.” ririeta, umó ririe, “Irugari kato, avota, rege!” ");
INSERT INTO bjz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aghá ririeta, Iesu undú eghá ririe, “Embobo ungaghami guride embódava guridu benunu urieta, einidu 5,000, kotú einidu 500 kina aghá ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aghá urieta, aná guri bubugea aria jijimu ea sidara ea mino utari inono ambi egeguturia-du, umó aná embobo ungaghada dinunu nundubea gia dotuturie. Atá, aná enembo ungaghada rorova avona umó neno bua goghó adu?” ");
INSERT INTO bjz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aghá ririeta, Saimon na mino eghá ririe, “Anda rei-nundubutora, aná guri jojabe avona jijimu uria-mi neno bua goghó aita rouvia-jogo.” ririeta, Iesu na, “Imó gaa bee reravore.” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aghá rea, umó kaverea, dibe aná evetudava urota, Saimon du eghá ririe, “Ená evetu, imó rei-gerora? Amó etera, inda kambova terora, imó anda eka seghari uvu jo utambi re. Tago, ená evetuda dibe jivumi anda eka mane seghea, unda foumami dufetue. ");
INSERT INTO bjz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Atá, amó inda kambova terora, imó jo ‘orokaiva’ rea amó muno ambi re. Avotago, amó etera inda kambova terora feferava, ená evetu anda eka mane muno ea doambi kato etue. ");
INSERT INTO bjz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Imó anda beforova uka muu jo averegambi re. Tago, unona uka munode anda ekava averegetue. ");
INSERT INTO bjz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Amindu, amó enanu indú isaghava rere: Unda ari-bari akokogo oruabe, anona nundubea gia dotora-du, umó amó neno bua goghó rouvie. Tago, enembo avodava ari-bari akuago dabako ungagha aghago nundubea gia doasira-da neno bari, aná ijoko bee re.” ");
INSERT INTO bjz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aghá rea doa, Iesu aná evetudu eghá ririe, “Inda ari bari akokogo aná nundubea gia dotore.” ");
INSERT INTO bjz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aghá urieta, esega enembo dumeni avo numonde danode undari undidiguturia-mi mino-mino uriga egeguturie. “God unuka ari-bari akokogo nundubea gia dota rouvie. Atá ená embó avouvi? Unona daiyagha ari-bari akokogo nundubea gia doari gaa retu?” ");
INSERT INTO bjz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aghá regeguturieta, Iesu aná evetudu eghá ririe, “Inda gaabee arimi imó jebugetoravota, siririgha ii!” ");
INSERT INTO bjz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aghá uria-da ambova, Iesu unda ambo nimbi 12 de dano iiava, naa einiva reta fuava, naa einiva urota, God Afa unda natofo* daiyagha kaifa eta rouvia-da gaga taubananu minono reta urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Aghade, kae akokogo bubugea vitiria evevetude kotú taimu akokogo manemi asugea vitiria evevetude dano Iesu na seibe ririeta, jejebuguturia-mi Iesu de dano deĩ egegeta urie. Numonde dano Makdala embó einida ariri ragaro, Meri, undava taimu akokogo beforo dano 7 vitiria-de ririeta buburiturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kotú aghade Herot da kambo kaifa ari embó Kusa da evetu Joana de, evetu eini ragaro Susana de, kotú evevetu dumenide númanda guride gugua-ghayafademi Iesu unda ambo nimbide sonembeta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aghade, enembo natofo oruabe usitueta, naa dumeniva enembo ambova Iesu dava fufugutueta, Iesu númandu kasia eini eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Embó eini erea, unda aayova farava vee govaita rea iye. Umó farava vee ghasio uta irueta, vee dumeni begatava vovoregetueta diimi etia undidigetue, kotú enembomi ekami fatia dadasegetue. ");
INSERT INTO bjz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Vee dumeni singoi endava vorea, batumo-batumo ea, vivitigetue-tago, feferami evia, yoe-yoe egegetue. Anada bee mo, endava uvu jo jojabe irambi-gea amindu riribu jo gambambi gharasa etue. ");
INSERT INTO bjz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Vee dumeni vive gingideda rova vorea, vivegha danode vivitigetueta, vivemi afuregetue. ");
INSERT INTO bjz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tago, vee dumeni enda taubanava vorea vitia, unda govetua-da itiva bee oruaruabe 100 aghago ririkigetue.” Aghá riria-da ambova Iesu be koko fugia eghá ririe, “Nímane avona nghaĩde iradora, nghaĩ javea ningia goghó egege!” ");
INSERT INTO bjz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aghá ririeta, unda ambo nímbimi aná kasiada bee mo doro, amindu uriga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aghá regeguturieta, Iesu na mino eghá ririe, “Afa God daiyagha unda natofo kaifa eta rouvia-da gaga dumeni kivu uria-da bee nímandava isagha eta rore. Avotago, enembo dumenidu kasia gaganu reta rore. Aghá rata-gea: ‘númane gigigaita rousue-tago, jo gambigo egegaita rousue. Aghago, niningigaita rousue-tago, jo ningia tanana egegambi aita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ená kasia retora-da bee aná evere. Vee retora, aná God da Gaga re. ");
INSERT INTO bjz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Begatava jurari gaa retora, aná enembo avona God da gaga ningita rousua-nu gaabee egegea, jebuga tumanadu tatambugauva-degea rea, Satan fuava aná gaga númanda neno rova vitia-nu tatavami rougea buta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gari dabako aghago, vee dumeni singoi endava vovoregetua-da bee, aná evere. God da Gaga ningia gangorogha buta rousua, númane re. Tago, gaabee ari númandava ijoko-gea, fefera tufoko iririguturota, Satan da kuvia gari númandava fuaveta, númane jujugeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kotú vee dumeni vive gingideda rova vovoregetua-da bee, aná evere. Enembo avona gaga ningita rousue-tago, irirota, eini-eini oruabe nundubeta rousua-mi, gugua-ghayafa bubugaita nundubeta rousua-mi, kotú tamo firída uno manemi gajeaveta, númanda gaabee arida bee jo sirorambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Atá vee enda taubanava vovoregetua-da bee, aná evere. Enembo avona kotofu enemboda neno nundubari taubana eta rouvia aghagomi, God da Gaga ningia kaifa ea goghó urota, kuvia gari donu furadua mo, tutumi serigea, númanda gaabee ari baria númanda jebugava bee taubana siroreta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Enembo nanefa dungadua mo, jo ovu rova o evari kambesi tuva nungambi aita rouvie. Tago, avona fufugadua enembo unana gigiguturota, terari-du rea, aná nanefa jirari sinakefiva itaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Amindu, donu nungia vitia, ambova isaghava itota tanana egegaita rousue. Kotú donu afuregea iradua mo, ambova ifegota isaghava gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","God da Gaga minono rera, aná ningia goghó egege! Anada bee mo, Enembo avodava eini-eini oruabe iradua, anada etova oruabe utota baita rouvie. Tago, enembo avodava itoko iradua, unda nundubariva nanjogo irasua dano, rougea baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu da nuede unda vivide ambobo numonde uro dabakova vorarimi umó gigigaita fufuguturie. Fufuguturie-tago, natofomi umó gajea rorogea irieta, númane ya, unda kasava bubari inono ambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aghá egegutueta, enembo dumenimi furia, undú eghá ririe, “Inda niede kotú jamena vivide onanu isaghava jiria, imó gigigaita uno rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aghá ririeta, umó mino eghá ririe, “Anda aya kotú vivide ambobo, aná avona God da Gaga ningia, ivatava itita rousua, númane re.” ");
INSERT INTO bjz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Fefera eini, Iesu unda ambo nímbidu eghá ririe, “Egege, namonde sao yoveniva rekimbea igigore!” aghá riria-du, numonde aria, ghaava* vorea siregea arie. ");
INSERT INTO bjz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Rekimbea igiguturota, Iesu vasia evieta, aná saova yaura yavata sembago bee erorurie. Erea, númanda ghaa dea rosaita ueta, númane oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aghá ueta, unda ambo nímbi aria, umó evuruturieta, dibe fangiturieta, eghá regeguturie, “Jojabee, Jojabee, namonde amó uvu undia ambubugaita rosore.” Aghá regeguturieta, umó erea, be fugia bureguturieta, yaura yavatada torú-torú dano binono urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aghá urieta, unda ambo nímbidu eghá ririe, “Nímandava gaabee ari tefo re!” aghá ririeta, númane oru ea, mana-mana egeguturota, “Ená avouro? Umó retueta, yaura yavatada torú-torú dano unda gaga ningia aghagonu etue.” ");
INSERT INTO bjz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aghá ea doa, númane rekimbea aria, Galili sao yoveniva Gerasa enemboda endava bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bubua, ghaa* gaiturieta, Iesu ombova vivitua mo, aná bogu naava embó eini taimu akokogomi asuguturieta, dighari ombari jo asugambi taroba vitirie, kotú kambova evambi, uje singoi toova irita uria embómi furia, Iesu tafirie. ");
INSERT INTO bjz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aghade, aná embó, Iesu gia, be jojabe koko fugia, “Iesu, imó God Iti Bee Itivada Mendi re. Imó andú donu aita uno ro? Amó benunu rore, andava mema mania utata!” Aghá rirota, Iesu da eka tuva jua vavosurie. ");
INSERT INTO bjz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aghá riria-da bee mo, Iesu sei aná taimu embóda tamo roo doa serigari-du ririe. Atá, aná embó sei unda irari eghá re. Fefera yafabe, aná embóda eko-ingo seini mi bundia, dibura enembo kaifa arigo roururie. Tago, unda eka ingova seini mane taimu akokogoda anomi righia bununu ea iiava ika uvu tefo kambesiva avo irita urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Amindu, Iesu na uriga urie, “Inda ragaro doro? Rege, ningore!” ririeta, umó mino eghá ririe, “Anda ragaro ‘Oruabe re,’” ririe. Anada bee mo, taimu akokogo mane oruaruabe unda rova terua vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Avore, númanena, rourogo númane rata ya, taimu akokogoda irari enda too tano tefova vorauva-degea, Iesu dava benunu ea doambi kato urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aghade, gudoro jo airo bee irambi, anava naa oka mane oruabe undari undidigutueta gigiguturie. Aná taimu akokogomi, Iesu du benunu eghá egeguturie, “Námane ninenge-gea ya, naa oka maneda tamova teterugore!” Aghá regeguturieta, Iesu avore ririeta, ");
INSERT INTO bjz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","taimu akokogo mane aná embó doa uvugea bububugea aria, naa oka manedava asusuguturieta, aná naa oka mane dano sumbua, kokava voraria, saova undidigea ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aghá egegutueta gigigea, aná naa oka maneda kaifa kakatomi susumbugea aria, aná bogu naava bubua, kotú kasava vitiria naa dumeniva bububugea, númane donu geruria, aná isagha egeguturieta, enembo dano niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Niningigea, aná roo endava natofo donu siroruturia-nu gigigaita rea, dano fufuguturie. Númane furia, Iesu dava bububuguturia mo, aná embó taimu manemi asugea vitiria-da nundubari kaverea furia, dambu urieta, bo-eembo asugea, Iesu da eka tuva asumbea irieta, gigiguturie-gea, númane oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kotú aná embó Iesu na ririeta jebugutueta gigiguturia enembomi regeguturieta, aná enembo ambova fufuguturia, dano niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","39","Aghá uria-du, roo enda Gerasa enembo dano, Iesu doa serigari-du benunu egeguturie. Anada bee mo, aná embó taimu akokogomi asuguturieta vitiria, jebuguturieta gigiguturie-gea, númane oru egeguturie. Avore, Iesu aria ghaava vorea, aná kambesi doa yaita ueta, aná embó taimu manemi asugea vitirieta, Iesu da urieta jebuguturia-mi ungá Iesu gha yaita uno urie-tago, Iesu na umó kaverea yari-du ninenguturota, eghá ririe, “Kaverea, ii, naava bubua, God da indú donu etua-nu radi!” Aghá riria-du aná embó kaverea aria, bogu naava bubua, Iesu da undú daiyagha uria-nu isagha eta urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aghá ea doa, Iesu kaverea aria buburiturieta, natofomi “Orokaiva” rea, ghaito teno fugea, umó bua vivitiguturie. Anada bee mo, númane dano undú kaifa rosurie. ");
INSERT INTO bjz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aghade, embó ragaro Jairus, nghaĩ itari kamboda* beforo righari-mi furia, Iesu da eka tuva jua, ininigha Iesu na unda kambova yari-du, benunu urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairus aghá riria-da bee mo, unda ariri dabako bee dabako unda ghaeko 12 mi, kae bua amburaita uua-du umó aghi furie. Aghá benunu uria-du, Iesu Jairus da kambova yaita irueta, natofomi umó mimutueta, gategea arie. ");
INSERT INTO bjz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aghade, evetu eini tatangu kae bua gutiturota, ghaeko dano 12 sidara urie. Umó ingi barida emboro dumeni tava urota, unda guri dano siosa fugiturie-tago, enembo eini jo umó sonembari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iesu enemboda gorotova irueta, aná kae bua vitiria evetumi ambo kena furia, Iesu da tamo asugari sokuada soriva ririkua, unda tatangu kae gaimbo ambi tukú urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aghá urieta, Iesu itatama urie-gea, kaverea, “Amó avona sinia righi?” ririeta, númane mana-mana urota, gambi gaa regegutua-du, Pita na eghá ririe, “Jojabee, enembo oruaruabe etue-gea, imó mimuturota righia-jogo.” ");
INSERT INTO bjz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aghá ririe-tago, Iesu eghá ririe, “Enembo einimi sinia anda asugariva righieta, ano andavareta enembo einidava rekimbutueta, amó itatama etore.” ");
INSERT INTO bjz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aghá ria-du, aná evetu nenomi sinia, Iesu da asugari soriva ririkuria-mi furia, natofoda rorova unda eka tuva koubumi jengirea, umó bee dodu sinia, Iesu righia, kotú daiyagha ea, umó gaimbo ambi jebuguturia, aná isagha urie. ");
INSERT INTO bjz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aghá ririeta, Iesu na mino undú eghá ririe, “Anda ariri, inda gaabee arimi imó jebugetoravoreta. Siriri arigha ii!” ");
INSERT INTO bjz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aghá rieta, gaga jo sidara ambi irieta, aghi kakato dumeni Jairus da kambovareta furia bubua, Jairus du regeguturie, “Inda ariri ambue. Amindu rea, mania ená Irugari kato bua yaita nundubata!” ");
INSERT INTO bjz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aghá rieta, Iesu niningurie-gea, Jairus du eghá ririe, “Umó jebugaita rouvieta! Mania oru ata! Gaabee ege!” ");
INSERT INTO bjz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aghá riria-da ambova, umó aria, Jairus da kambova bubua, enembo jo doata numonde teterugambi re-tago, Pita, Jon ungá Jems gha, aná aririda nue numamoghade teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aghade, enembo dano aná ariridu dari sorara ueta, Iesu na eghá ririe, “Jii dodoge! Aná ariri jo amburambi re. Umó tefo evo rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aghá ririeta, niningigea, númane undú gegha regeguturie. Anada bee mo umó ambubuturia aná númane seibe gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Avotago, Iesu aná aririda ingova ririkurota, eghá ririe, “Anda ariri, ere!” ");
INSERT INTO bjz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aghá ririeta, aná aririda asisi kaverea furieta, jo gaimbo ambi dibe fangea erorurieta-gea, Iesu na númane undari utota aná ariri undari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aghá urieta, aná aririda nue numamugha duduku-dadaka ueta, Iesu na, aná aririda nue numamoghadu donu siroruturia-nu kivu ari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aghade, Iesu na unda ambo nimbi 12 ghogho rieta furia, danode egeguturieta, taimu akokogo nanjogo tuvari-du, kotú kae dibe eini be eini bubugea irari enembo ata jejebugari-du rea, númandu ano ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aghá ea, God da enembo daiyagha kaifa eta rouvia-da gaganu minono rirota, kotú kae bubugea iririgadua ririkigota jejebugari-du rea, Iesu na númane ninenguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ninenguturota, eghá ririe, “Eini-eini donu mania bata! Besia, etota, guri, farava kotú asugari dighari-ombari aghagode dano mania bua igigaita nundubata! ");
INSERT INTO bjz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ya, naa einiva bubua, kambo niavo teterugota, enembo ‘Orokaiva!’ rirota gangorogha nímane bubugadua, aná kambova iririguturota, buro egegadi! Sidara ata, aná naa doa igige! ");
INSERT INTO bjz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Atá enembo avona jo nímandu ‘Orokaiva!’ rirota, ghaito teno nímandu jo fugambi egegadua mo, aná naa doa seriguturota, nímanda eka ghandada avo dodovire-gea, númane ari akokogo rousua-nu tanana egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aghá ririeta, númane bubua aria, kambesi nanjogo biruru urota, naa einiva reta iiava, naa einiva igiguturota, Gaga Taubananu minono regeguturota, kae akokogo bua irari enembo regegeaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aghade, Iesu da donu-donu ueta sirorutua-da bingá Galili Frovensida kotofuko Herot na ningia mana-mana urie. Anada bee mo, enembo dumeni Iesu da ua-du eghá regegeta urie, “Jon Bafutaito ari katomi jebugea kaverea eretua-jogo.” ");
INSERT INTO bjz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Enembo dumeni, “Feroveta Elaija amburarivareta kaverea bubia-jogo!” reaveta, kotú enembo dumeni mo, God da feroveta sei furia-da einimi amburarivareta kaverea furari gaa regegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aghá regeguturieta, Herot na eghá ririe, “Jon Bafutaito ari kato anona ririeta, ukó diveguturieta ambubuturie. Tago ená ivata mane ueta reisi-sirorutua embó mo, avouvi?” Aghá rea doa, umó Iesu gaita nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anada ambova, unda ambo nímbi kaverea furia bububugea, númane daiyagha-daiyagha egeguturia-da gaga dano Iesu du ririeta, niningurie. Aghá regeguturieta ningia, umó erea, númane unumbea bua, nenukako naa eini ragaro Betsaida avo igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Aghá egeguturie-tago, natofo tanana egegea erea, unda ambo tuvia igiguturie. Aria bububuguturia-du, “Orokaiva” rea, ririeta asusumbuguturieta, God unda natofo* daiyagha kaifa eta rouvia-da gaganu rirota, kotú kae bua vitiria enembo urieta jejebuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aghá ueta, aria jama ua-du, unda ambo nímbi 12 furia, undú eghá ririe, “Enava evari kambeside undaride tefo re. Amindu natofo ninenge, ya, ená roo endava naa dumeni-dumeniva undaride kotú evari kambode tatambugoe!” ");
INSERT INTO bjz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aghá regeguturieta, Iesu na unda ambo nimbidu mino eghá ririe, “Undari nímanena ututuge, undidigoe!” Aghá riria-du, númane mino eghá regeguturie, “Námandava farava ingari ingo yoveni, uvu oka ungagha, aghá vitie. Tago inda uno mo, námanena ya undari ená natofoda inono gurimi utua bubugasira-du rera?” ");
INSERT INTO bjz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Anava embobo 5,000 aghago usiturie. Evetu mendi sasingude jo irugambi re.) Amindu unda ambo nímbidu eghá ririe, “Regege, númane noni daba-daba 50 aghagonu asusumboe!” ");
INSERT INTO bjz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aghá riria-du, unda ambo nímbimi regeguturieta, aná enembo dano asusumbeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aghá egeguturieta, umó aná farava ingari ingo yovenide uvu oka ungaghade bua, dibe jará ea, uutuva urota, God Afadava “aiye” rirota, aná farava ingegebea, enembodu vesa egegota undidigari-du rea, unda ambo nimbidu ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Vesa egeguturieta bua, dirieta inono uria, anada itoto dumeni dodoguturia, Iesu da ambo nimbimi erea bua, kanda jojabebei dano 12 anava fefendiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Anada ambova Iesu unuka benunu uria-da gorotova, unda ambo nimbi numonde vitiria-dava uriga urie, “Nímane regege, ningore! Natofo jede andú mo daiyagha regegeta rousu?” ");
INSERT INTO bjz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aghá ririeta, unda ambo nimbi dumeni mino eghá regeguturie, “‘Imó aná Jon Bafutaito Ari Kato re,’ reta rousue, kotú dumeni mo, ‘Imó aná Elaija re,’ reta rousue, kotú dumeni mo, ‘Imó aná feroveta sei eini amburari vareta kaverea erari gaa,’ reta rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aghá regeguturia-du, umó númandava uriga eghá urie, “Atá nímane mo, andú daiyagha regegado?” aghá ririeta, Pita eghá ririe, “God, enemboda ari-bari akokogo nundubea gia doaita rirota, Embó eini utaita riria, imó re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aghá riria-du, Iesu na, númane rourogo enembodu aná gaganu rauve-degea, ininigha bureguturota, ");
INSERT INTO bjz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","eghá ririe, “Enemboda Jojabee* mema bouvu dibe eini be eini itatama aita rouvie. Babarigaride fristida* kokotofude, kotú Agho Dari irugari kakatodemi* umó injigha egegea, bua dedegota amburaita rouvie-tago, fefera bakodeda ambova umó rekago jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kotú enembo dano avo desuturia-du eghá ririe, “Nímane avona anda ambo nimbi ea, namonde deĩ aita uno egegadora mo, nímanda uno dodogea, anda uno nuenembo egeguturota, fefera inono anda ragarova amburaridu jo oru ambi egegaita rosoravore. Aghá egeguturota, namonde danode iru-furu egegaita rosore. ");
INSERT INTO bjz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Anada bee mo, avona endava gugua-ghayafa nundubuturota, amburaridu oru ea, andú goitu fotadua, fefera ambova umó amburaita rouvie. O avona andú amburadua mo, fefera ambova jebuga tumanadu irari baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Anada bee mo, avona gugua-ghayafadu neno rururota, gugua nanjogo bua, jebuga tumanadu irari kasovigadua, anami umó sonembadua, aĩ, tefo? ");
INSERT INTO bjz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Enembo avona anda gaga, kotú anda irugaridu meka adua mo, fefera ambova Enemboda Jojabee unda durogha gari bua, unda Afa kotú anera kakara manededa durogha gari bua fururota, umó beago aná enembodu meka aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Amó nímandu gaa bee rereta, enava enembo dumeni vitia, aná jo amburambi iririguturota, God unda natofo* daiyagha kaifa eta rouvia-da fefera furota, gigigaita rousue,” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aná gaga mane riria-da ambova fefera 8 aghago sidara urieta, Iesu erea, Pita de, Jon ungá Jems ghade bua, numonde dano dafaru itiva benunu egegaita yayavuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aria bubua, umó benunu ua aghade, unda dibe bededa gari eini urota, unda asugari digharide kaverea, saghai forosago eto-bato kirivada unanago urie. ");
INSERT INTO bjz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Aghá ua-da rova embobo ungagha, Moses ungá Elaija gha númanda durogha garide avo siroruturie. Aghá ea, númane Iesu de, unona God da uno urota, Jerusalem avo amburaita rouvia-da gaga reta beemi rea niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aghade, Pita unda kokomanade evomi akuago bee egeguturie-tago, númanda dibe jará ea ategea goghó urieta, númanena Iesu unda duroghade embobo ungaghade numonde jijiregea irieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iesu avo doa, aná embobo ungagha serigutua, Pita na Iesu du eghá ririe, “Jojabee, namonde amó eve desea vitera, aná taubana re. Aghá-gea, námane dobo bakode, eini indú, eini Moses du, kotú eini Elaija du aghá simbugaita rosore. (Ená gaga eghá riria-da bee, umó mana-managha kotú jo neno nundubuturota rambi re.)” ");
INSERT INTO bjz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita aghá ria, gooso unanaghami vorefuria, númane afuregutueta, oru egegutueta ");
INSERT INTO bjz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","gooso rova be fugia eghá ririe, “Ená anda mendi re. Umó aná anona gateguturereta, unda gaga donu radua-nu, niningige!” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aná gaga rea sidara uria-da ambova, númane dibe fugia, Iesu unuka jiria irieta gigiguturie. Unda ambo nímbi donu siroruturia-nu gigigea, númanda neno rova dotuturie. Aghade, númanda donu gigiguturia aná, enembo eini avodu jo regegambi re. ");
INSERT INTO bjz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rifo atiturieta, númane kaverea vorefuria bububuguturieta, natofomi furia umó tatambuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aná natofo jededa rorova embó einimi be fugia eghá ririe, “Irugari kato, inona anda mendi gadi benunu rore. Umó anda mendi dabako bee-gea, gadi bua etere. ");
INSERT INTO bjz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anada bee mo, undava taimu akuagomi asugea irirota fugeaveta, koko rea jua ambua, kusú be toova bubuta rouvie. Fefera inono, anda mendidu mema aghago ututa rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Amindu, amó inda ambo nimbimi aná taimu akuago tuvota, aná mendidava doa vorari-du, benunu etore-tago, númane jo ari inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aghá riria-du, Iesu númandu eghá ririe, “O yove, nímane oreki vitera, aná gaa ningambi deriva egegeta rosoravore. Nímandava gaabee ari tefo re. Amó fefera yafa daiyaghago namonde irirota, nímanda mema bouvu fumba? Avoreta, inda mendi bua, andava fu!” ");
INSERT INTO bjz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aghá ririeta, aná mendi bua Iesu dava furua aghade, taimumi aná mendi endava fugiturieta jua ambubuturota, tamode eka ingode dadada urota vasia, kusú be toova buburiturie. Tago, Iesu na ininigha taimu akuago ririeta buburiturieta, aná mendi urieta jebuguturieta numamodava ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aghade God da ivata anogha jojabe urieta siroruturia-du, númane dano duduku-dadaka ea, mana-mana egeguturie. Aghá urieta-gea, enembo dano mana-mana egegutueta, Iesu unda ambo nímbidu eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Amó, nímandu donu raita rora-nu nghaĩ javea ningia goghó egege! Enemboda Jojabee* enembomi bua, gitofoda ingova utota, númanda unonu egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Aghá ririe-tago, aná gagada bee unda ambo nimbidava jo isagha ambi re. Kotú, gaga riria-da bee númandava jo isagha ambi re. Númandava nungia irieta, númane jo tanana egegambi-gea, unda gagada bee undava uriga ari oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Anada ambova, unda ambo nimbimi númanda rorova beforo righari mo avona adu rea, tofo-tofo besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aghá egegutueta, Iesu númanda neno rova donu nundubuturia aná gerurie-gea, sasingu mane eininu bua, unda kasava ituturieta jiruturieta, ");
INSERT INTO bjz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","númandu eghá ririe, “Enembo avona sasingu mane ijoijokoko eghagonu anda ragarova ‘Orokaiva’ rea badua, aná andú ‘Orokaiva’ raita rouvie. Kotú avona andú ‘Orokaiva’ radua, aná beago, avona amó ninenguturieta furera-du ‘Orokaiva’ raita rouvie. Anada bee mo, nímanda rorova avona enemboda sabua* adua, umó aná jojabe re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Anada ambova, Jon na Iesu du eghá ririe, “Atá Jojabee, embó einimi inda ragarova taimu akokogo tuvitueta gigigetore-gea, námanena umó aná buro doari-du buregetore. Anada bee mo, umó aná jo namonde anda nonida rova eini irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aghá ririeta, Iesu mino númandu eghá ririe, “Avotago, ambova mania buregaita egegata! Anada bee mo, avona nimonde gitofo ambi adua, aná nímanda tofo re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Anada ambova Iesu uutuva yarida fefera furia buburitueta, umó Jerusalem yaita nundubari fakarabe urota, ");
INSERT INTO bjz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","undú eini-eini mane simbugari-du rea, unda aghi sei ninenguturieta, Samaria naa einiva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Aghá urie-tago, aná Samaria naava enembo undú “Orokaiva” rirota, ghaito teno jo fugambi egeguturie. Anada bee mo, umó dibe dambu Jerusalem yaita arie. ");
INSERT INTO bjz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aghá uria-du, Jon ungá Jems ghana gia, neno akuago urie-gea, eghá ririe, “Jojabee, gigo! Imó ‘Avore’ rora, námane ghogho regegota, ivari uutuvareta vorea, ená naa mane evadua?” ");
INSERT INTO bjz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aghá ririe-tago, Iesu kaverea, númandu aghá auve-degea doari-du ininigha bureguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aghá ririeta, númane dano aná naa doa serigea naa einiva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aghade numonde emborova igiguturota, embó einimi Iesu du eghá ririe, “Irugari kato, imó niavo yadora, amó inda ambova tuvia yaitare!” ");
INSERT INTO bjz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aghá ririeta, Iesu na undú eghá ririe, “Ito-goiriva númanda nangu undari too vitie, kotú itiva dii mane númanda mogha vitie-tago, Enemboda Jojabee* umó doda nangu undari kambesi tefo re.” ");
INSERT INTO bjz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aghá rea doa kaverea, embó einidu eghá ririe, “Anda ambova fu! Angá yare!” Aghá ririeta, aná embómi Iesu du eghá ririe, “Jojabee, anda afa emboko bee re. Umó amburota-gea furugadora mo, amó furá angá deĩ aita rore.” ");
INSERT INTO bjz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aghá ririeta Iesu na undú eghá ririe, “Anda ambova tuvia fu! Do-gea, aná amburari enembo nendufako furugoe! Atá, imó fu ya, God unda natofo* daiyagha kaifa eta rouvia-da minono radi!” ");
INSERT INTO bjz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aghá rieta, kotú embó einimi eghá ririe, “Jojabee, amó aná angá deĩ aitare. Tago do-gea, amó sei ya, anda enembo totofo ghanena ea doa furore.” ");
INSERT INTO bjz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aghá ririeta, Iesu na mino eghá ririe, “Enembo avona God da buro aita urota, umó tamoda unonu nundubea kaverea yadua mo, umó jo furá God da natofo ari inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aghá uria-da ambova, Jojabee umó embobo dano 72 gategea, umó niavo yaita nundubuturia, naava ungá ungá naa inono igigari-du rirota, númane ninenguturota, ");
INSERT INTO bjz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","eghá ririe, “Aayova undari-bari oruaruabe bee etue-tago, undari-bari ghambea buria ari enembo jo orua irambi re. Amindu aayo numamodu benunu egege-gea, undari ghambea buria ari enembo ninengota furoe! ");
INSERT INTO bjz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Amó nímane, eto-bato sifi da memendi nino akokoda rorova irita rouvia, aghagonu enembo akokogoda rorova rei-ninengutoreta, igige! ");
INSERT INTO bjz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Guri fendari etotade ghojade, kotú eka vuside mania bubugata! Emboro rorova enembo tatambugadora beago, mania ghanena urota, fefera yafabe jijiregea irata! ");
INSERT INTO bjz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nímane noni daba-daba ya, kambova teterurota mo, sei regege, ‘Siriri ená kambova iroe!’ ");
INSERT INTO bjz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Siriri ari kato embó eini anava iradua mo, inda siriri do, undava iroe, o embó aghago avo tefo iradua mo, do, kaverea indava furoe! ");
INSERT INTO bjz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Anava teradora mo, aná kambova irirota, dirota evia erea egege! Anada bee mo, undari donu utota undadora, nímane God da buro eta rosora-da mino re. Kambo dabako avo iririge! Mania ya kambo einivareta einivareta egegata! ");
INSERT INTO bjz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nímane ya naava bubota, ‘Orokaiva!’ rirota, ghaito teno fugadua, avore, undari donu bua furá, indú utadua, ananu undidige! ");
INSERT INTO bjz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Anava kae bua iradua enembo rege, jebugota númandu eghá rege, ‘God unda natofo* kaifa rouvia fefera aná etia, utuvako rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Atá nímane ya, naava bubota, indú jo ‘Orokaiva’ rirota, nímandu ghaito teno fugadua mo, emborova jiria eghá regege! ");
INSERT INTO bjz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Amindu námanda ekava nímanda naada ghandada takembetua, aná dodovirea nímandava rei-fugitore. Avotago ená gaganu nundubea goghó egege! “God unda natofo kaifa arida fefera etia, nímandava utuva etue-tago, nímane injigha rosoravore.” ’ ");
INSERT INTO bjz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nímandu gaa bee rere. Irurarida Feferava, Sodom enembo bouvu baita rousue-tago, aná naava enembo bouvu jojago bee bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","O yove! Korasin kotú Betsaida enembo, nímandu rere. Sembago furadua, nímane bouvu jojago bee itatama aita rosoravore. Anada bee mo, aná ivata anogha dumeni dumeni nímandava rei-sirorutua aghagonu, Tair ungá Saidon ghadava irugasira, númane seibe neno kaverea, númanda ari akokogo vuregea isagha urota, neno memada vaya boghora asusugea, enda beforova gharasue. ");
INSERT INTO bjz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gaa bee re, irurarida feferava Tair ungá Saidon ghada enembo mema baita rousue-tago, nímane Korasin kotú Betsaida ghada enembo rera, mema jojago bee bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Atá, Kaponiam inda nundubariva, imó righota erea, uutuva yari rei-nundubutora? Tefo, imó aná kotova fugota voriya, ari bari akokogoda mino utari kambesiva iraita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu unda ambo nimbidu eghá ririe, “Avore, amó eghá rereta. Afa na unda gaga rari-du riria-nu minono rere. Atá, minono anda rasira katogonu, nímanena regegadi rea, rei-ninengutore. Enembo avona nímanda gaga ningadua mo, anda gaga beago ningaita rouvie. Avona nímane injigha adua mo, andú beago injigha aita rouvie. Aghagonu, avona andú injigha adua, God amó ninenguturieta furera beago, injigha aita rouvie,” aghá rea sidara ea, númane ninenguturieta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aná embobo 72 gangorogha kaverea furia, eghá regeguturie, “Jojabee, námane inda ragarova eini-eini dumeni egegutata siroruta. Kotú taimu akokogo beago, donu inda ragarova egegari-du regegutara-nu dano aghá egeguta.” ");
INSERT INTO bjz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aghá regeguturieta, umó mino númandu eghá ririe, “Kiriva uutuva reta jua voreta rouvia aghagonu, Satan jua vovorueta amó gerare. ");
INSERT INTO bjz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Amindu, amó nímandu eghá rere. Niningige! Anda ano nímandu ututata rurara-du, ningabu o ika begara fatadora, o Satan da ano nímane tatambugadua mo, mema jo ambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Avotago, taimu akokogo nímanda gaga niningigeta rousua-du, mania gangoro egegata! Tago, nímanda ragaro uutuva gefirieta vitia-du, gangoro egege!” ");
INSERT INTO bjz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aná fefera aghade Asisi Kakarada anomi Iesu gangoro jojabe urota, God Afadu raga ririe, “Afa, imó uutu endadeda Jojabee re. Amó indú aiye bee rere. Afa, inona uno urota, enembo beforo garide nundubaridedava inda gaga kivu ea nungiturota, enembo beforo gambi, sasingu maneda nundubarigodava iruguturieta isagha urie. Afa, inona uno ea aghá urieta siroruturie.” ");
INSERT INTO bjz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iesu God Afadu aiye gaga rea sidara ea, anada ambova natofodu eghá ririe, “Eini-eini nanjogo dano anda Afami andú ututurie. Enembo eini avona Afada Mendi jo tanana ambi re, Afa unuka rei-gerue. Kotú dabako aghagonu, enembo eini jo God Afa gambi re-tago, unda Mendimi umó rei-gerue. Kotú unda Mendida uno rouvia enembodu unona irugota, Afa gigigea, tanana aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aghá rea doa, umó kaverea, unda ambo nimbide nenuka roboghami eghá ririe, “Nímane oreki nímanda dibemi donu gigigeta rosora-du, gangoro egegasiravore! ");
INSERT INTO bjz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aghá rera-da bee mo evere. Nímanda donu gigigeta rosora ananu, kini mane nanjogo, feroveta mane nanjogo, seibe gigigaita uta fufuguturie-tago, jo gigigambi re. Aghago, donu niningigeta rosora-nu, niningigaita uta fufuguturie-tago, jo niningigambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Onembo eini enemboda rorova, Agho Darida Irugari kato* einimi erea jiria, Iesu kuvia gaita eghá ririe, “Irugari kato, amó daiyagha-daiyagha ea, tumanadu irarida jebuga ba?” ");
INSERT INTO bjz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aghá ririeta, Iesu na mino eghá ririe, “Atá Agho Dari-va daiyagha gefirieta viti? Imó daiyagha irugeta ro?” ");
INSERT INTO bjz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aghá ririeta, aná embómi mino eghá ririe, “‘Inda Jojabee God nu, inda neno roode, inda asiside, inda anode kotú inda nundubaride dano neno bu!’ Kotú gaga eini evere: ‘Imó indufa neno rei-rurora aghagonu, inda komana beago neno bu!’” ");
INSERT INTO bjz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aghá ririeta, Iesu na mino undú eghá ririe, “Imó aná gaa bee reravore. Imó aghá adora mo, jebuga baita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iesu aghá ririeta niningurie-tago, unda ragaro righota erari-du rea, uriga eghá urie, “Atá anda kokomana mo avou-avouro?” ");
INSERT INTO bjz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aghá ririeta, Iesu mino eghá ririe, “Embó einimi Jerusalem reta Jeriko yaita irueta, bagia enembomi tambua dedegea, unda dighari ombari righia kisorea, umó avo doa, númane irueta, aná embó amburaita itoko ueta, ");
INSERT INTO bjz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","fristi* eini, umó aná emboro dabako anava yaita voriya, aná embó emboro yoveniva vasia irieta gia doa, umó emboro taukaka serigetue. ");
INSERT INTO bjz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dabako aghagonu, Levi undi, embó eini aná emboro dabako anava etia, aná embó vasia irieta gia doa, umó beago emboro taukaka serigetue. ");
INSERT INTO bjz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aghá egegetueta, Samaria embó eini emboro dabako anava yaita voretia mo, aná embó avo vasia amburaita itoko ueta gia, umó neno mema etue-gea, ");
INSERT INTO bjz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aná embóda tamo beto mane ingi uka muude vaini de averegea, bandesi mi eghea simbugea, unda oka ragaro donki va itia bua iya, esega enemboda evari kambo einiva bubua terua kaifa etue. ");
INSERT INTO bjz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aghá ea evia rifo atetueta, onembo ungagha buro arida guri aghagonu bua, esega enemboda kambo numamodava utua, eghá retue, ‘Ená embó kaifa ea goghó uu-gea, amó kaverea furá, inda donu ená utora-da itiva serigea fugadora-da mino utaita rore,’ retue. ");
INSERT INTO bjz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gigo! Ená enembo bakodeda rorova aná bagia enemboda detua embóda komana mo, avouro?” ");
INSERT INTO bjz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aghá ririeta, aná Agho Dari Irugari katomi mino eghá ririe, “Avona undú neno mema etue-gea, sonembetua, umó re,” ririeta, Iesu na mino undú eghá ririe. “Avoreta, ii, imó beago donu etua aghagonu, adi!” ");
INSERT INTO bjz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aghade, Iesu unda ambo nimbide Jerusalem igigaita furia rorovareta, umó aria evetu ragaro Marta da naava buburiturieta, undú “Orokaiva” rirota, ghaito teno fugiturie. ");
INSERT INTO bjz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iesu na avo irirota, gaga rieta, aná evetuda rao ragaro, Meri furia, Iesu da eka tuva asumbea, nghaĩ javea unda gaga ria-nu niningueta, ");
INSERT INTO bjz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta unukako kamboda burode undari-baride simbuguturota, nundubari oruaruabe ea, umó gangoro ambi-gea, furia Iesu dava eghá ririe, “Jojabee, imó ená anda rora mo, rei-gerora? Imó daiyagha gia, dotueta, anda rao asumbea irieta, ená buro dano amó anuka ro? Rege-gea, umó furá amó sonemboe!” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","42","Aghá ririeta, Iesu na mino eghá ririe, “Marta, Marta, imó ená eini-eini oruabedu nundubuturota, gangoro ambi eta roravore. Meri donu rouvia, aná taubana bee re. Aná undava jo rougea bua serigambi aita rore,” Iesu na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Fefera eini, Iesu aria, kambesi einiva benunu ea, sidara urieta, unda ambo nímbi einimi undú eghá ririe. “Jojabee, Jon unda ambo nimbi benunu egegari-du iruguturia aghagonu, námane iruge-gea benunu egegore!” ");
INSERT INTO bjz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aghá ririeta, Iesu mino eghá ririe, “Nímane benunu egegaita uno adora mo, eghá regege, ‘Afa, námane inda ragaro kakara urota, righota rei-erorue! Fu, inda natofo* kaifa uradi, namonde irore. ");
INSERT INTO bjz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rifo inono námanda undari bofu! ");
INSERT INTO bjz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Námane enemboda ari akokogo námandava eta rousua-nu, nundubea gia dota rosora amindu, námanda ari akokogo nundubea gia do! Rourogo doadi-gea kuvia gariva yara-degea reisi-rere.’” ");
INSERT INTO bjz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Aghá rea, númandu eghá ririe. “Atá, imó tumba rova inda mambu einidava ya eghá rasiravore, ‘Mambu, anda komana eini emborova rei-fago etia andava bubieta, amó undú undari donu utaita rora, aná tefo re. Amindu, andú farava ingari bakode bofu!’ ");
INSERT INTO bjz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aghá rasira mo, aná kambo tofomi indú eghá rasue, ‘Andava mania rata! Amó kambo bebato gajea, anda sasingu manede námane seibe evaita vavasegetore. Amindu amó jo erea, indú eini-eini donu utambi aita rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Amó nímandu eghá rere. Umó inda mambu ea vitie-tago, umó jo amindu erea eini-eini utambi aita rouvie. Avotago goi-goi rei-deruradora-du umó erea furá, inda uno nanjogo adora, aghagonu utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Amindu amó nímandu eghá rere. Benunu egege, utota bubugadi! Tava egege, utota bubugadi! Goi-goi dedege, nímandu bebato ifegaita rouvie! ");
INSERT INTO bjz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Amindu umó avona benunu ari, aná buta rouvie. Umó avona tava ari, aná tambuta rouvie. Kotú umó avona goi-goi dari, undú bebato ifegeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gigige, nímane afa mane, avona nímanda mendi uvu okadu benunu adua mo, ningabunu utadora? ");
INSERT INTO bjz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O númane dii munjudu radua mo, ika begaranu utadora? ");
INSERT INTO bjz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Avore, nímane enembo sembago re-tago, nímane eini-eini esiko-esiko nímanda sasingudu ututa rosoravore. Avotago, Afa uutuva vitia, umó taubana bee re. Amindu undava benunu eta rousua enembodava, unda Asisi Kakaranu ututa rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Taimumi embó einidava asugea irieta, umó be gunga ea irieta, Iesu na ririeta aná taimu akuago doa vovorurieta, aná embó be fangea tutuno ea, gaga rieta, natofo jede dano duduku-dadaka ea mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Aghá egeguturie-tago, enembo dumenimi eghá regeguturie, “Aná taimu akokogoda barirari Belsebul (o Satan reta rosora) unona ano Iesu du utuaveta bua, anami taimu akokogo tuviaveta isaghava bubuta rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aghá regegutueta, enembo dumenimi umó kuvia gigiguturota, ivata anogha God da ano undava vitia-nu irugota, gigigaita regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aghá regegutueta, Iesu númanda nundubari gerurie-gea, númandu eghá ririe. “Gigige! Kini unda kaifa eta rouvia roo enda bejea, noni-noni ea, tofo-tofo mene-mene egegadua, o kotú kambo einida enembo rorova gategea vesó-vesógo adua, gaimbo ambi mino-mino dea, sidara aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aghago, Satan unda enembo gategea, noni-noni ea, tofo-tofo mene-mene egegadua, unda natofo kaifa eta rouvia kambesi mo, daiyagha jiria iradu? Amó aghá rera-da bee mo, amó Belsebul da anomi taimu akokogo tuvari gaa reisi-reravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Avore, amó oreki Belsebul da anomi taimu tuvota bubari gaa reisi-nundubutoravore. Avotago, inda yaveronu gigige! Númane avoda anomi taimu tuviaveta bubuta rousu? Nímanda yaveroda egeguturia-mi, isagha rouvia mo, nímanda reisi-rera, aná gavera re. ");
INSERT INTO bjz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amindu rere, amó taimu God da anomi tuveta rora-du, nímane tanana egegasiravore! God da natofo* kaifa arida fefera, aná seibe etia nímandava bubua vitie. ");
INSERT INTO bjz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nundubea gigige! Satan umó eto-bato, embó ano kato eini, unda gii bere bua, unda kambo tofo kaifa ueta, unda eini-eini dano taubana vitia, aghago re. ");
INSERT INTO bjz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tago, embó eini ano jojabemi furá aná embó dadua, aná embóda gii beredava sonemba baita nundubuturia-nu righia bejea, aná embóda eini-eini susughi ea gategea baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Umó avona amó sonembambi adua, umó anda gitofo aita rouvie. Kotú umó avona angá danode ambi adua, umó anda noniva bejea, airo-airo aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Aghá rea, Iesu umó ririe, “Taimu sembago embóda tamo rovareta doa, isaghava bubadua mo, umó uvu tefo kambesiva biruru urota, nangu undari kambesi tava aita rouvie. Tava ea tambambi adua, unda kambo seinu nundubuturota eghá raita rouvie, ‘Amó kaverea, anda kambo seiva yaitare.’ ");
INSERT INTO bjz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kaverea yadua mo, aná kambo yaveve tafoni ea, eini-eini simbugota, tambaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aghá ea, aná taimu umó taimu akokogo ingo yoveni yoveniva unghagha, sembago bee sembago umó vitia-da etova aghagonu bua furá, aná kambova numonde iraita rousue. Aghá adua, aná embóda irari sembago bee sembago aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Aghá riria, anava natofo vitiria-da rova, evetu einimi be fugia ririe, “Evetu avona imó fumbua emi gaetueta baborurera-dava, God da ea simbugari vitie!” ");
INSERT INTO bjz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aghá ririeta, Iesu mino eghá ririe, “Avotago God da ea simbugari aná enembo avona unda Gaga ningia ambo-ambo urota, kaifa eta rousua-dava irita rouvie!” ");
INSERT INTO bjz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aghade natofo oruabe desea Iesu fugea roroguturieta, Iesu númandu eghá ririe, “Nímane oreki rei-sirorutua enembo dano, deriva urota viteravore! Nímane ari ivata anogha manedu benunu reta rosoravore-tago, ivata dumeni jo irugota gigigambi aita rosoravore. Dabako: Jona dava donu siroruturia, aghagonu Enemboda Jojabeedava* sirorota gigigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anada bee mo, Nineve enembo neno kaverari-du, God na Jona dava ivata donu urieta siroruturia-nu, gigigea neno kaveruturie. Aghagonu, oreki rei-sirorutua enembo neno kaverari-du, God na rata ivata eini Enemboda Jojabeedava sirorota gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Irurari feferava, Siba bogu naada Kotofu Evetu erea, God da dibeva jiria, nímanda ari bari akokogo isagha aita rouvie. Umó aná roo airo bee reta Solomon da neno nundubari kotú irugarinu gaita rea furie. Atá, oreki nímanda dibeva jiria minono reiria embó, aná Solomon da itiva re. ");
INSERT INTO bjz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Irurari feferava, Nineve enembo beago ereregea, nímanda ari akokogo isagha aita rousue. Anada bee mo, númane Jona da minono niningigea númanda ari akokogo doa, neno kaveruturie. Atá, amó nímandu eghá raita rore: oreki enava minono reiria embó, aná jojabe re. Jona aná ijoko re. Tago, nímane jo neno kaverambi viteravore.” ");
INSERT INTO bjz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Enembo eini avona nanefa jo dungea nungambi eta rousue, o bua ovumi afuregambi eta rousue. Tago, aná nanefa umó bua, nanefa jirari sinakefiva itiaveta, enembo teraita fufugari unda unana gigigeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Inda dibe aná inda tamoda nanefa re. Inda dibe taubana iradua, inda tamo dano unanami beda aita rouvie. Avotago, inda dibe akuago adua, inda tamo dano bingoi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Amindu kaifa egege, rourogo nímanda unana bingoimi gajauve-degea rere. ");
INSERT INTO bjz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amindu rea, nímanda tamo bingoi tefo, dano unanami beda ea iradua, aná eto-bato aivami janimbarigo aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aghade, Iesu gaga rea sidara urieta, Moses da Gaga kaifa kato* einimi, Iesu yata, unda kambova* ungá undari undaita ririeta, Iesu aria terua, undari kambesiva asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Avotago, Iesu undari undaita aria aghade, umó ingo seghambi asumbuturieta, Moses da Gaga kaifa kato gia, Jiusi enemboda Agho Darinu nundubuturota, mana-mana urie. ");
INSERT INTO bjz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Avotago, Jojabee undú eghá ririe, “Nímane, Moses da Gaga kaifa kakato, nímanda neno roo eto-bato aaghade roorodeda tamo isaghavanu segheta rousua aghagonu egegeta rosoravore. Tago, nímanda neno roo daghari arimi kotú ari-bari akokogodemi beda ea vitie. ");
INSERT INTO bjz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nímane beforo dinunu enembomi egegeta rousua aghago re. God unona eto tamode neno roode dano urieta siroruturie. ");
INSERT INTO bjz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aghadu rea, eini-eini donu nímanda aagha rovade kotú tevo rovade vitia-nu, makasi enembodu utu! Aghá egegadora, nímanda tamode neno roode dano taubana iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Aee, dara baita rosoravore! Anada bee mo, Agho Dari reiria aghagonu urota, nímanda aayova vitia-da eini-eini ijoijokoko eto-bato ararugha, dorea kotú ireride aghagonu bua, dibe ingo ungagha itia, anada rova dibe eini God du ututa rosoravore. Aná egegeta rosora, aná taubana re. Tago, nímane eini-eini gategarida gorotova nímanenu nundubuturota, komana eini jo nundubambi egegeta rosoravore. Kotú God beago jo neno rururota, nundubambi egegeta rosoravore. Aná beago egegasiravore! Amindu rea, nímane ambova mema jojabe itatama aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ariee, Moses da Gaga kaifa kakato! Nímane aná ambova mema jojabe itatama aita rosoravore. Anada bee mo, nímane nghaĩ itari kambova enembomi nímandu kokotofuda asumbari kambesi taubana utari-du uno egegeta rosoravore. Kotú aghá urota, utua bari kambesiva enembomi nímane kakara urota, ari oro rea goghó egeguturota, ghanena ari-du uno egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ariee, Moses da Gaga kaifa kakato, dara baita rosoravore! Anada bee mo, nímane enembo itari uje afuregea iriaveta jo gia tanana ambi enembo etova deĩ rarigea igigeta rousua aghago re. Enembomi nímane gari mo, taubana gaa reta rousue. Tago, nímanda neno rova, aná sembago re.” ");
INSERT INTO bjz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aghá ririeta, Moses da Gaga irugari kato einimi eghá ririe. “Irugari, imó aná gaga aghá rera-mi, námanda tamova gaga sembago reravore.” ");
INSERT INTO bjz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aghá ririe-tago, Iesu númandu mino eghá ririe, “Ariee, Moses da Gaga irugari kakato! Nímane beago aná ambova mema jojabe itatama aita rosoravore. Anada bee mo, nímane agho dari oruabe simbugea reaveta, enembo bouvu rururota kaifa egeguturari, nímane anada bouvu jo itoko fufirota sonembambi egegeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Ariee, Moses da Gaga irugari kakato, nímane dara baita rosoravore. Anada bee mo, aná feroveta mane nímanda mambube manemi dedeguturieta ambubuguturia anada uje nímanena itia simbugeaveta gari taubana eta rouvie. Nímane nendufa kukuviguturota viteravore. Aná uje mane ititiguturota, reisi-irugutoravore, nímanda mambube mane donu egeguturia-du gangoro urota, númanda aito daiyagha fugita furia aghagonu rosoravore. Númanena feroveta mane dedeguturieta ambubuguturie, kotú nímane imemendimi feroveta maneda uje mane itia simbugeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Amindu rea, God unda neno nundubarimi eghá ririe, ‘Amó númandu feroveta mane kotú anda aghi enembo ninengota irurota, dumeni data ambubuguturota, kotú dumeni injigha urota, bouvu mema dibe eini be eininu ututugaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Aghá-gea, God uutu enda urieta siroruturia feferavareta furia etia oreki, God da feroveta nanjogo derurieta ambubuturia-da tatanguda bouvu oreki sirorea vitera enembomi itatama aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Embó taubana Abel derurieta ambubuturia feferavareta furia, Sekaria vesa dungari faro kotú kambesi kakara anada gorotova derurieta ambubuguturia-da mino dano, oreki vitia enembomi bubugaita rousue. Gaa bee rere. Anada mema nímane rururota, itatama egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aee, dara baita rosoravore! Anada bee mo, beforo gari-da ruru aná, nímane re. Avotago, God da nundubari daiyaghago nímane jo regegota enembodava isagha ambi eta rouvie. Totofo nímane jo tanana egegambi re. Kotú rourogo enembo dumeni gia tanana egegauve-degea buregeta rosoravore. Amindu rea, anada mino akuago God na ambova nímandu utota bubugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu aghá rea, aná kambesi doa aria-da ambova, Moses da Gaga irugari kotú Gaga kaifa kakatode tutuno ea, Iesu da tamova gaga sembago regeguturota, uriga oruabe simbugea ami umó kuvia gigigeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Anada bee mo, númane Iesu kuvirota, gaga sembago rirota niningigea, umó nandia bua, koto aita nundubuturota, kaifa urota kato egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Fefera aghade, anava natofo jede danode desea, fatia dirigea iru-furu ueta, Iesu tutuno ea, unda ambo nímbidu gaga eghá ririe, “Moses da Gaga kaifa kakato* númane, aná evevetu yisti farava rova itiaveta baria, jojabe eta rouvia aghagonu, númanda rova gaverami beda ea vitie. Amindu, nendufa kaifa ea goghó urota, mania númane aghagago eta rousua aghagonu egegata! ");
INSERT INTO bjz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Eini-eini nanjogo nungariva vitia, aná dano bubua, isagha aita rouvie. Kotú, kivu gaga nanjogo ambova enembo dano niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imó bingoi rova donu radora, aná onembo rorova rirota niningigaita rousue. Kotú imó kambo rova dumumutami donu radora, aná ambova naa rorova minono rirota niningigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Anda kokomana, amó nímandu eghá rere: Enemboda tamo nuenembo data amburari inono ea vitia enembodu, mania oru egegata! ");
INSERT INTO bjz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Avotago, amó nímane avodu igheghi egegasira-nu irugaita rore. Inda tamo data amburota, imó fugota, ivari tumanadu reivia-va vorarida ano God dava vitie. Amindu undú oru egegasiravore. ");
INSERT INTO bjz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Dii buririka nundubadi rere. Guri utua baita rasira mo, toea ingo ungagha aghago utua buririka dano ingo dabako basiravore. Avore, God umó aná buririka neno rururota, númane dano irugari vitie. Tago, unda neno bari númandava ijoko re. Unda neno bari namonde andava aná jojabe re. Namonde anda fouma dano irugari vitie. Amindu, nímane God gaabee ari enembodu rere. Mania amburari-du oru egegata! ");
INSERT INTO bjz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Eini evere: enembo avona Enemboda Jojabee* gaabee urota, natofo jededa dibeva unda gaabee arinu ivatava itadua, amó beago, God da anera maneda dibeva undú ikoko gaa raita rore. ");
INSERT INTO bjz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Avotago, umó avona enemboda dibeva amó kivu adua, Enemboda Jojabee ari dabako aghagonu urota, God da anera maneda dibeva númane beago kivu aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dabako aghago, Enemboda Jojabeeda bingá avona fara adua, God na unda ari-bari akuago aná nundubea gia doaita rouvie. Atá, avona Asisi Kakarada bingá fara adua mo, God aná ari akuago jo nundubea gia doambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kotú, aghade imó kuvia gaita bua furá, nghaĩ itari kamboda* beforo ririkigari-da, kotú gavana manededa beforo ririkigarideda dibeva itota jiradora, mania imó indufa gangada ari nundubata, kotú donu rasira-du neno mema mania ata! ");
INSERT INTO bjz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Fefera anava imó donu rasira, aná Asisi Kakarana irugota raita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aghade, natofo desea vitiria-da rorova embó einimi Iesu du eghá ririe. “Irugari kato, rege-gea, anda kaka námanda afada námandu dotuturia guguanu gategea vesa ata, angá bare!” ");
INSERT INTO bjz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aghá ririeta, Iesu mino undú eghá ririe. “Embó eini avona amó jo ingá inda gorotova gugua gategari-du avore ari utambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aghá rea, númandu eghá ririe, “Gia goghó egege! Rourogo eini-einidu muu undidigareta! Anada bee mo, nímanda jebuga jo nímanda gugua-ghayafa daiyagha righia vitera-va, irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aghá rirota, Iesu númandu kasia gaga eini eghá ririe, “Embó eini gugua-ghayafadeda aayova undari bari bee oruabe etue. ");
INSERT INTO bjz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Etueta, umó undufako eghá nundubetue, ‘Anda koroma mane aná inono irambi re. Amindu amó daiyagha aa? ");
INSERT INTO bjz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Amó eghá aita rore. Anda koroma mane dea bejea, dumeni jojabe itaita rore. Ea, anda undari-baride eini-einide anava itaita rore. ");
INSERT INTO bjz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Amindu amó andufako eghá raita rore, “Bakua, amó eini-eini esiko-esiko oruabe ghaeko oruabedu simbugetore. Amindu gangorogha dirota iraita rore!” ’ ");
INSERT INTO bjz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Avotago, God undú eghá retue, ‘Imó beforo fakara re. Inda jebuga oreki tumbade anona badora mo, inda simbugetora eini-eini avona badu?’ ");
INSERT INTO bjz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Atá, aná enembo retora aghagonu ghununu itia gugua-ghayafade aita egegadora mo, God da dibeva makasi ea, jebuga kasovigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aghá riria-da ambova, Iesu unda ambo nímbidu eghá ririe. “Amó nímandu eghá rere. Mania, nímanda irariva, donu undidigaita rosora, kotú nímanda tamova donu asugaita rosora amindu, gogorego nundubata! ");
INSERT INTO bjz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Inda asisida jebuga aná jojabe re, undari-bari aná ijoko re, kotú gari dabako aghagonu inda tamo aná jojabe re, dighari ombari aná ijoko re. ");
INSERT INTO bjz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Aghago, dii ooa manenu nundubea gigige! Númane jo govea o duria ghambea ambi eta rousue. Númane ghununu itari kambesi o koroma tefo re. Tago, God na númane unduta rouvie. Avotago, God da neno bari namonde andava aná jojabe re. Dii manedava aná ijoko re. Amindu nímanda irari-du mania mema egegata! ");
INSERT INTO bjz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gigige! Nímanda aghá nundubetora-mi, egegota nímane fefera yafabe iririgadora? ");
INSERT INTO bjz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Atá, nímane eini-eini ijoko aghago ari inono ambi egegadora mo, dodu aná eini-eini jojabe, undari-baride ombari-digharidedu nundubado? ");
INSERT INTO bjz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Nundubea gigige! Atá, taima sigina manenda vitita rousua-nu gigige! Númane jo dighari ombari baita rea, buro ambi eta rousue. Tago, amó nímandu eghá rere. Kini Solomon umó gugua-ghayafa embó akuago eini re. Tago, unda dighari asugarida taubana, jo ená taimava siginago irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Aná kirisa oreki vitia, rifode fugota, ivariva evaita rouvia-dava God na unda gari taubana ututa rouvie. Tago, God da dibeva nímane aná jojabebei re. Kirisa aná ijoko re. Amindu, nímanda dighari ombari unona utaita rouvie. Aghá-gea, God da kavevera gaabee egegadi rere! Dodu nímandava gaabee ari bee ijoko ro? ");
INSERT INTO bjz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amindu, nímane donu undia dandia aita rora-du, mania neno mema urota, anadu jojabe nundubata! ");
INSERT INTO bjz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jiusi enemboda gitofo God gaabee ambi enembo númanda nundubari aná eini-eini aghagodava itita rousue. Tago, nímane donu bubugasira-nu, nímanda Afa uutuva vitia-mi sei gita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amindu, God da kaifa eta rouvia-da noniva teraita rirota iririgadora, aná eini-eini nanjogo unona nímandu utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Anda sasingu, God Afa nímane kaifa aita ririe. Amindu mania oru egegata! ");
INSERT INTO bjz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Amindu, taubana mo, nímanda gugua-ghayafa dano utua, guri bua, makasi enembodu utu-gea bubugoe! Aghá egegadora mo, uutuva God Afa na gugua-ghayafa tumanadu irarinu nímandu utaita rouvie. Anava bagia enembo eini jo bagia ambi aita rouvie, kotú faratetemi jo undambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Amó aghá rera-da bee mo, nímanda gugua-ghayafa niavo vitia-nu gogorego nundubeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Eto-bato sabua* kakatomi númanda barirari evetu yagera ari banauva iaveta, kaifa eta rousua aghagonu egege! Nímanda barirarida buro egegaita rea, nímanda boo eembo dighia ombea, kaifa urota, nímanda nanefa dunge, janimboe! Umó kaverea furá bubua, bebatova goi-goi dadua, nímane gaimbo ambi bebato ifegadi, teroe. ");
INSERT INTO bjz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Amó nímandu gaa bee rere. Buro kakato avona númanda irari gia simbugea goghó ea, kaifa egeguturota, númanda barirari kaverea furadua, númane gangoro egegaita rousue. Anada bee mo, unona rata, númane undari bua undita rousua kambesiva asusumbota, umó undari denembea utota, númane undidigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kotú buro kakato númane simbugea goghó ea kaifa egeguturota, númanda barirari tumba rorova o rifo atiturota, furá bubota gigigadua, númane gangoro egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tago, enanu nundubea gigige! Bagia enembo tumba domi embó einida kambo bejaita rirasueta, aná kambo numamo tanana asua mo, rourogo unda kambo bejauve-degea, dibe emboro asue. ");
INSERT INTO bjz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nímane beago fefera inono simbuguturota iririge! Anada bee mo, Enemboda Jojabeeda* kaverea furaita rouvia fefera aná nímane jo tanana ambi iririguturota, bubaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aghá ririeta, Pita Iesu du uriga urie, “Jojabee, imó ená kasia rera mo, námane anuka námandu rera, aĩ enembo dumenide dano rera?” ");
INSERT INTO bjz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aghá ririeta, Iesu mino enembo nanjogodu ririe, “Buro kato umó avona unda barirarida uno ea goghó adua, kotú unda nundubari dano burova itadua-dava, unda barirarimi rata, umó unda kokomanada rorova beforo righari ea, unona númandu undari unda feferava vesa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aná buro kato, unda buro ea goghó urota, unda barirari kaverea furá gadua mo, aná buro kato umó taubana tambua, gangoro aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Amó nímandu gaa bee rere. Aná buro katoda barirarimi unda kambova gugua nanjogo utota, umó anada barirari ea, kaifa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Avotago, buro kato umó eghá nundubasua mo, ‘Anda barirari fefera yafabe irirota, jo tutumi kaverea furambi aita rouvie.’ Aghá nundubadua-gea, aná embómi buro kakato dumeni embobode evevetude dano dea ga urota, uvu fakara undia beforo biruru aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aghá urota, aná buro kato unda barirari kaverea furari fefera jo tanana ambi irirota, kaifa ambi urota, unda barirari furá, umó tambadua, aná buro kato tafugea, ito fakono ea isaghava fugota, gaabee ambi kakato donu itatama aita rousua aghagonu, itatama aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Aghagonu, buro kato avona unda barirarida uno tanana ea, jo simbugea, unda barirarida uno ambi adua, ambova unda barirarimi umonu fefera oruabe embiimi fisuraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Avotago, buro kato avona unda barirarida donu uno rouvia, jo gambi irirota kasovigadua mo, unda barirarida uno jo gambi-gea, umó bouvu fẽko baita rouvie. Enembo avodava God na oruabe utaita rouvia, aná enembodava rekago oruabe rougea baita rouvie, kotú God na enembo avodava vesa boanda taubana adua, ambova umó númandava rekago mino utari-du raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Amó endava ivari dungaita furere. Kotú seibe evasua mo, amó gangoro asire. ");
INSERT INTO bjz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Avotago, amó sei andufako mema jojabe itatama ea amburaita rore. Tago, daiyagha tutumi sirorasua-du, neno mema rore. ");
INSERT INTO bjz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kotú, nímanda nundubariva amó endava siriri ari bua furari gaa mania nundubata! Tefo, amó nímane gategea, mino-mino besiga arinu bua etere. ");
INSERT INTO bjz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aghá-gea, oreki mendi sasingu dano ingo yoveni iradua mo, bakode erea, ungaghade gitofo urota, ungagha bakodede gitofo egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aghago enembo gategea mendi aná numamogha gitofo urota, numamo mendigha gitofo urota, nue unda aririgha gitofo urota, ariri nuegha gitofo urota, nuavia unda mendiyaegha gitofo urota, erea, mendiyae nuaviagha gitofo egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aghá rirota, umó aná natofodu eghá ririe: “Nímane fefera vorari kena gooso vitota gia, ‘Boruma voraita rouvie,’ rari mo, aná boruma voreta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kotú yaura dafaru kena sufirari mo, nímane reta rosoravore, ‘Ghaeko jiraita rouvie.’ Aghá rari aná ghaeko jireta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nímane aghagago ari kakato re! Nímane endava donu siroruturari ananu gia isagha egegeta rosoravore. Atá, oreki donu rei-sirorutua, nímane daiyagha jo gigigea tanana egegambi roso? ");
INSERT INTO bjz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Atá, bee dodu nímane ari taubanada emboro jo gia tanana ea, ambo-ambo egegambi eta roso? ");
INSERT INTO bjz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Atá, inda komanagha besiga ata, imonu koto aita radua mo, koto kambesi bubambi-da dibe kena emboro rorova irurota, inda komanagha gaga rea simbuge! Aghá ambi adora mo, imó bua, irurari katoda ingova utota, unona imó bua, dibura kaifa kakatoda ingova utota, bua diburava gajaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Amó nímandu eghá rere, imó diburava irirota, irurari katomi guri donu utari-du radua-nu, dano utua sidara adora mo, imó doata kaverea bubaita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Fefera dabako aghade, enembo dumeni avo desuturia-mi, Iesu du eghá regeguturie, “Galili enembo dumeni God du vesa dungitueta aghade, Pailat na númane nandia derurieta ambubuguturie.” ");
INSERT INTO bjz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aghá regeguturieta, Iesu na númandu mino eghá ririe, “Aná Galili enembo emboro aghagova derurieta ambubuguturia, aná nímane reisi-nundubutora mo, gaa bee númane ari akokogo ari enembo ra, tago Galili enembo dumeni mo ari akokogo ambi enembo ra, aĩ? ");
INSERT INTO bjz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tefo, amó nímandu eghá rere. Nímanda ari akokogo jo isagha ea dodogambi adora, nímane beago emboro dabako aghagova ambubugaita rosoravore! ");
INSERT INTO bjz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kotú, aná enembo 18 Sailoam anava, kambo yafabeva irieta, borea fafoturieta ambubuturia númane ari akokogo enembo reisi-nundubutora-tago, Jerusalem enembo dumeni mo ari-bari akokogo ambi enembo ra, aĩ? ");
INSERT INTO bjz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tefo! Nímanda ari-bari akokogo jo isagha ea dodogambi egegadora mo, nímane beago emboro dabako aghagova ambubugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu númandu kasia eini eghá ririe, “Embó eini ika ragaro baganu unda ghavesi vaini aayo rova govetue. Atá, fefera eini umó aná ika bee righadua gaita iye. Avotago, aná ika bee eini jo righambi etue. ");
INSERT INTO bjz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Amindu, unda aayo kaifa ari katodu eghá retue, ‘Ghaeko bakodeda rova amó eve iru-furu urota, ená ikava bagada bee eini jo gambi re. Umó tefo jiria irirota, endava undari taubana mane dumeni unona jijimu ea tefo auvota! Vege, juroe!’ ");
INSERT INTO bjz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tago, unda aayo kaifa katomi eghá retue, ‘Barirari, do-gea, ghaeko dabako jiria irirota, unda rurunu duria ovenembea, eini-eini betari manenu unda ruruva itia gare. ");
INSERT INTO bjz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kotú, ghaeko dabakoda rova bee mane righadua mo, avore, atá, bee righambi adua mo, rege-gea, vegea fugore!’” ");
INSERT INTO bjz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nangu Undari Fefera einiva, Iesu God da nghaĩ itari kambo* rova nghaĩ ititueta, ");
INSERT INTO bjz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","evetu eini taimumi asugea, eka ingo difirieta, ghaeko 18 umó goitu banju ea vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aghade, Iesu aná evetu gia, ghogho ririeta, undava furieta, undú eghá ririe, “Evetu, imó oreki jebugetoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aghá rirota, ingomi aná evetuda beforova ititueta, aná evetu gaimbo ambi eka ingo rurugea, goitu dambu ea jiria, God du raga ririe. ");
INSERT INTO bjz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Aghá urieta, Iesu Nangu Undari Rifova aná evetu urieta jebuguturieta gerurie-gea, aná nghaĩ itari kamboda* barirarimi neno akuago ea kaverea, aná enembodu eghá ririe, “Namonde anda buro ari fefera dano 6 gateguturie. Amindu, aná fefera 6 da rova fu-gea rata jejebugadi, mania Nangu Undari Feferava fufugata!” ");
INSERT INTO bjz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aghá ririeta, Iesu undú mino eghá ririe, “Nímane dano aghagago enembo re! Burumakao de donki manede númanda kambova gajeaveta irari mo, nímane dano Nangu Undari Feferava bebato ifegea unumbea bua, uvu utuaveta undidigeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Avore, ená evetu Satan na asuguturieta, goitu banju ea vitiriago, ghaeko 18 sidara etue. Aná Abraham da evetube eini re. Amindu, umó Nangu Undari Feferava retueta jebugetua, aná taubana re.” ");
INSERT INTO bjz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu da gaga mino riria-mi urieta, undú gitofo eta uria enembo, númane nendufako meka egeguturie. Atá, unda gaga ningita uria enembo, unda eini-eini esiko-esiko dumeni eta uria-du, gangoro egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","God da natofo* daiyagha ea, oruabe eta rouvia-nu nundubuturota, Iesu ika ijoko ragaro mastadi dava kasia eini eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“Embó eini aná ika mastadi da veenu bua iya, unda aayova govetueta, ika vitiya jojabe ea, fafatu sarigetueta, dii mane etia, númanda mogha aná ika fafatuva ititigeta etue.” ");
INSERT INTO bjz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu na rekago kasia eini eghá ririe, “God da enembo tumanadu kaifa eta rouvia mo, domigha inono ro? ");
INSERT INTO bjz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Evetu eini farava, barirari-du ingi ragaro yisti itoko bua, farava oruabegha bagega ea, righiaveta, farava dano baria jojabe eta rouvia, aghago re.” ");
INSERT INTO bjz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu Bogu Naa Jerusalem yaita irurota, bogu naa kotú naa ijoijokoko dumeni emboro kasava gaga dumeni iruguta arie. ");
INSERT INTO bjz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aghá uta irueta, embó eini undava uriga eghá urie, “Jojabee, rege ningore! God mo enembo orua irambi-dava jebuga tumanadu utadua, aĩ?” ");
INSERT INTO bjz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Aghá ririeta, Iesu númandu mino eghá ririe, “Nímane aná bebato ijokova teraita egegadi rere. Anada bee mo, enembo oruabe uutuva teraita uno rousue-tago, enembo daba-dabami ya teraita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kotú, aná kambo tofo erea, bebato gajadua mo, nímane kambo bebatova jiria goi-goi urota, ‘Jojabe, bebato ifege!’ regegadora mo, umó mino eghá raita rouvie, ‘Nímane dodareta fufugetora, amó jo gambi re.’ ");
INSERT INTO bjz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aghá rata-gea, nímane mino undú eghá raita rosoravore, ‘Námane namonde danode undia dandia urota, námanda naava nghaĩ itita ureravore’. ");
INSERT INTO bjz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aghá rata, umó mino eghá raita rouvie, ‘Kotú nímane dodareta fufugetora, amó jo gambi re. Nímane ari akokogo enembo reta seserige!’ ");
INSERT INTO bjz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aghade, nímane fugota, kasava vorea jiraita rosoravore. Aghade, Abraham, Aisak, Jekop kotú feroveta mane nanjogo dano God da natofo* tumanadu kaifa eta rouvia-va gigiguturota, memagha diitu kirisi-karasa urota, jiiji regeguturota iririgaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aghade, fefera vitari kena, fefera vorari kena, dafaru kena kotú karaje kena enembo danode furá, God unda natofo tumanadu kaifa eta rouvia-du banau simbugaita rouvia-va asusumbegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Fefera anava, enembo dumeni ambova reisi-fua furá ya, kofiri egeguturota, kofiri rousua enembo kaverea furá, ambo egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Fefera aghade, Moses da Gaga kaifa kakato* dumenimi Iesu du regeguturie, “Imó ená kambesi doa serigea, kambesi dumeniva ii! Anada bee mo, Herot imó data amburari-du manaka gaitueta, námane niningigetore.” ");
INSERT INTO bjz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aghá regeguturieta, Iesu mino eghá ririe, “Igige! Aná kuvia gari kato Herot du eghá regegadi! ‘Amó orekigha, rifodegha kae bua vitia enembo ata jejebuguturota, taimu enemboda tamo rova vitia, aná tuvota bububugota, onembo bakova anda buro sidara aita rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Avotago, oreki rifode amirifogo amó deĩ uta ya, Bogu Naa Jerusalem bubaita rore. Anada bee mo, feroveta jo naa einiva irota dedegota amburambi aita rouvie. Umó ya Jerusalem bubota, avo dedegota amburaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ariee, Jerusalem enembo, nímane feroveta mane dedegeaveta ambubugeta rousue. Kotú God na, nímane irugota, jebuga tumanadu irari tatambugadi rea, enembo ninengeaveta futa rousua-nu singoimi dedegeta rosoravore. Amó fefera oruabe nímanda sasingu bua, danode aita rea, eto-bato kokora nuemi memendi bua, fakina tuva danode ea kaifa eta rouvia aghagonu aita urere-tago, nímane injigha egegutureravore. ");
INSERT INTO bjz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Atá, amó nímandu eghá rere: Oreki reta yaita rouvia, nímane amó jo rekago gigigambi irogo, ambova amó kaverea fururota gigigea, eghá regegaita rosoravore, ‘Orokaiva orokaiva! Umó avona Jojabeeda ragarova bubua reifia-du, raga regegore!’” ");
INSERT INTO bjz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nangu Undari Fefera einiva, Iesu aria, Moses da Gaga Kaifa kakatoda* beforo righari embó einida kambova undari undaita ueta, númane umonu utuvako tatasegea reisi-gerurie. ");
INSERT INTO bjz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aghade, embó eini eka ingo babarigea vitiria-mi furia, unda dibe kena jiriturie. ");
INSERT INTO bjz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aghá urieta, Iesu na Moses da Gaga Kaifa kakato, kotú Irugari kakatodedu uriga urie, “Gigige! God da Agho Dariva Nangu Undari Feferava enembo mo ata jebugadua, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aghá ririe-tago, númane gaga eini jo rambi egeguturia-du aná embó bua urieta jebuguturieta ninenguturieta arie. ");
INSERT INTO bjz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aghá ea, númandava uriga urie, “Atá nímanda soká ra, o nino-oka mendi ra Nangu Undari Feferava ya koto rova juradua mo, nímane jo tutumi ghambugota vitambi adua?” ");
INSERT INTO bjz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aghá ririe-tago, númane undú gaga mino rari emboro tefo egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aná banauva esega enembo kambesi taubana maneva asusumbugutueta gerurie-gea, númandu isuri ari gaga eini eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nímane evetu yagera ari banauva aghi jumbota igigadora mo, mania kambesi taubana maneva asusumbegata! Anada bee mo, enembo eini inda itiva yaita rouvia-jogo. ");
INSERT INTO bjz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aghá siroradua mo, banau numamo furá, indú eghá raita rouvie, ‘Ená kambesi doa, ená embódu utu!’ aghá rata, imó mekagha vorea, tuva asumbaita roravore. ");
INSERT INTO bjz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amindu, imó banauva aghi jumbota yadora mo, kambesi tuva bua asumbe-gea, banau numamo gadua-gea, eghá raita rouvie, ‘Mambu, erea vitia, itiva asumbe!’ raita rouvie. Aghá ata-gea, inda esega kokomanami imó aná embó kotofuko gaa regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Anada bee evere, enembo avona undufako raga radua, ambova God na umó itota voraita rouvie. Atá, enembo avona durumuguturota undufa itota voradua, ambova God na umó righota eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Anada ambova, Iesu na banau numamodu eghá ririe. “Imó ambova banau adora, mania inda ikoko mendi, ariri gharovu, kotú gugua-ghayafade enembonu aghi jumbota fufugauveta! Aghá adora, númane ambova inda banau mino egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amindu imó banau simbugadora mo, makasi enembo, eka ingo dimbaride, dibe soikidenu aghi jumbu fufugoe! ");
INSERT INTO bjz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aghá adora, God na imó taubana ea simbugaita rouvie. Númane jo indú mino egegambi aita rousue-tago, gaabee ari enembo jejebugea eroruradua feferava, God na indú mino utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aghade, embó eini unda kasava vitiria-mi aná gaga riria-nu ningia, Iesu du eghá ririe, “Enembo avona God da natofo* tumanadu kaifa ari kambesiva banau undaita rouvia, umó gangoro aita rouvie!” ");
INSERT INTO bjz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aghá ririeta, Iesu mino undú eghá ririe, “Embó einimi banau jojabe simbuguturota, esega enembo oruaruabe fufugari-du aghi jumbie. ");
INSERT INTO bjz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Banauda fefera bubieta, unda buro kato ninenguturota eghá retue, ‘Eini-eini dano simbugetoreta! Ii radi-gea, númane avona fufugari-du aghi jumbera, dano fufugoe!’ ");
INSERT INTO bjz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tago, númane jo fufugambi aita urota, enembo einimi tutuno ea, serigari gaga eghá ririe, ‘Amó guri utua, aayo reka bere-gea, ya gaita rore. Amindu, amó “Arii!” rere. Amó jo yambi aita rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kotú einimi eghá retue, ‘Amó oreki buro ari oka ragaro burumakau dano ingo ungagha bere-gea, ya kuvia gaita rore. Amindu, amó “Arii” rere. Amó jo banauva yambi aita rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kotú, embó eini eghá retue, ‘Amó oreki enembo evetu reka yagera etore-gea, amó “Arii!” rere. Amó jo yambi aita rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aghá regegetua-du, aná buro kato kaverea iya, unda bariraridu aná gaga dano retueta ningia, neno sembago etue-gea, ‘Tutumi ii, emborova kotú naa maneva makasi enembo, eka ingo dimbaride, dibe soikide, kotú eka takembea vitia enembonu unumbea furadi!’ retue. ");
INSERT INTO bjz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jo gaimbo ambi buro kato kaverea etia, eghá retue, ‘Barirari, amó inda retora aghagonu etore. Tago kambo jo beda ambi re.’ ");
INSERT INTO bjz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aghá retueta, unda barirarimi eghá retue, ‘Avore, imó bubua, emboro jojabebeiva, kotú aayo emboro maneva deĩ urota, enembo gadora-nu ininigha rea bera-bera ege-gea, furá anda kambo beda ae! ");
INSERT INTO bjz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Amó nímandu gaa bee rere: Amó sei enembo avodu aghi jumbieta furambi egegetua, númane jo anda banau itoko undidigambi aita rousue.’” ");
INSERT INTO bjz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Enembo oruaruabe, Iesu de dano igiguturota, umó kaverea, númandu eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Imó avona anda ambova furaita rirota, inda aya afa, ikoko mendi, ariri gharovu, evetu, mendi sasingu, kotú inda jebuganu ininigha neno rururota, inda neno bari andava ijoko iradua, imó jo anda ambo nímbi ari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kotú enembo avona, jo unda ifatara fumbua, anda ambo-ambo urota amburaita simbugadua, umó beago, jo anda ambo nímbi ari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Atá, nímane enembo eini avona kambo yafabe itaita nundubadora, sei imó asumbea, aná kambo ea, sidara aita rouvia-da guri mo inono ra, aĩ, tefo, ananu irugea gasiravore! ");
INSERT INTO bjz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Atá, imó aghá ambi aná kambo tutumbu nuenembo itia, jo ata sidara ambi adora, enembo dumeni gigigea, imó kuvia gegha rirota eghá regegaita rousue. ‘Umó kambo aita tutuno etue-tago jo ea sidara ari inono irambi re.’ ");
INSERT INTO bjz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aghago, kini eini ya, unda komanagha mene-mene aita nundubadua mo, umó sei asumbea nundubea goghó ae! Unda mene-mene ari kakato 10,000 mi ya kini einida mene-mene ari kakato 20,000 de mene-mene ari mo, inono ra? ");
INSERT INTO bjz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Atá umó jo mene-mene ari inono gambi adua mo, kini eini furá utuvako bubambi, airo bee irota-gea aghi ninengota ya tambua, siriri ari gaga raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Dabako aghagonu, imó avona inda gugua-ghayafa jo doambi adora, imó jo anda ambo nímbi ari inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ireri aná taubana re. Tago, ireri musisi ea sororo ea ya, vivi sidara adua, daiyagha ata-gea unda vivi rekago siroradu? ");
INSERT INTO bjz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Vivi sidara adua, umó jo endadu jeuro utari inono irambi re, kotú umó rekago eini-eini dumeniva jijimu ari jo inono irambi re. Amindu, doa fugota-gea, enemboda ekami fatia, iru-furu aita rouvie. Avore, nímane avona nghaĩde iradora, nghaĩ javea ningia goghó egege!” ");
INSERT INTO bjz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aghade, onembo einiva, aná takesi bari kakatode kotú ari-bari akokogo egegari kakatode Iesu da gaga niningigaita bubua, danode desuturie. ");
INSERT INTO bjz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Avotago, Moses da Gaga Kaifa ari kakato kotú Irugari Kakatode* neno akuago egeguturie-gea, gaje rirota, eghá regeguturie, “Ená embó ari akokogo ari kakatonu gangorogha ghanena ea, reaveta fufugeaveta, numonde danode undari undidigeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aghá regeguturieta, Iesu númandu kasia gaga eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Atá nímanda einimi oka sifi dano 100 kirisa rova kaifa rourota, dabako baghimbadua, umó daiyagha adu? Umó aná 99 avo doa, ya aná sifi dabako baghimbetua-nu tava ea ya tambaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Atá, umó tava rourogo tambadua, gangorogha bua ivisava fugea ya bubaita rouvie. Bubua, unda kokomanade, kotú unda enembo totofo rata bubua, danode egegota, eghá raita rouvie, ‘Amó anda sifi baghimbetua, tambua bere. Amindu namonde gangoro egegore!’ ");
INSERT INTO bjz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Amó nímandu eghá raita rore. Emboro dabako aghagonu enembo taubana 99 iradua mo, God unda anera kakarade uutuva irirota, gangoro rousue-tago, embó eini avona ari-bari akokogo rourogo doa, neno kaverea God ambo-ambo adua-du, gangoro jojabe egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Aghago, evetu eini unda guri siliva dano ingo ungagha re. Atá, dabako aná jua baghimbadua mo, aná evetu nanefa inimbia bua, tava goghó urota, kambo roo, kotú isaghava, yaveve rourogo tambaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kotú, aná evetu unda guri tambadua, umó unda kokomanade, kotú totofode rata bububugota eghá raita rouvie, ‘Amó anda guri baghimbetua, aná tambua bereta! Namonde gangoro egegore!’ ");
INSERT INTO bjz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Amó nímandu eghá raitare. Emboro dabako aghagonu, enembo eini avona ari akokogo rourogo, neno kaverea God da Gaga kaifa urota, kotú unda Gaga ambo-ambo adua, God da anera kakara uutuva gangoro jojabe egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aghade, Iesu gaga eini eghá ririe, “Embó eini unda sasingu gigimasa ungagha vita. ");
INSERT INTO bjz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fefera eini, unda mendi ambomi, numamodu eghá retue, ‘Afa, námanda eini-eini inda simbugutara aná gategea, anda boanda bofu!’ aghá retueta, ungá unda numamo númanda eini-eini ungá unda rorova gategea, unda boanda utue. ");
INSERT INTO bjz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Anada ambova jo yafa ambi, mendi ambo unda gugua-ghayafa bua, eini-eini taimbea bua iya, kambesi airo irirota, unda gugua-ghayafa aná yausi-yausi jijimu etue. ");
INSERT INTO bjz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Unda gugua-ghayafa fugea, sidara etua-da ambova, unda vita roo endava baimana akuago siroretueta, umó baimanami akuago etue. ");
INSERT INTO bjz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aghá ea, umó iya, aná unda vita roo endava embó einidava unda buro kato embó eini aita retueta, aná embómi avore retueta iya, unda aayova naa oka unduturota vita. ");
INSERT INTO bjz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Umó baimana ueta, naa okada undarinu undaita nundubetue. Aghade, enembo eini avo jo undú neno mema ea undari utambi re. ");
INSERT INTO bjz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Umó buro urota, goroto einiva unda nenova nundubari eghá etue, ‘Anda afada buro kakato undari bari númanda uno aghago jijimu rousue-tago, amó eve baimanami amburaita itoko rore. ");
INSERT INTO bjz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Amindu amó kaverea ya, afadava eghá raita rore, “Afa, amó inda, kotú God da dibeva ari-bari akokogo bee etore. ");
INSERT INTO bjz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Andú mania inda mendi tofo aghago rata! Tago, amó ege-gea, inda buro kato eini aghago are!” ’ ");
INSERT INTO bjz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aghá nundubetue-gea, umó erea, unda afadava iye. Umó jo ya, numamodava utuvako ambi, numamo umó gia, neno mema etue-gea, sumbua iya, unda mendi nandia, muno etue. ");
INSERT INTO bjz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aghá etueta, unda mendi eghá retue, ‘Afa, amó inda kotú God da dibeva ari-bari akokogo bee etore. Amindu, mania amó inda mendi tofo rata!’ ");
INSERT INTO bjz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aghá retue-tago, unda numamo sei unda buro kakatodu eghá retue, ‘Tutumi! Unda dighari ombari taubananu bua fu dighia, unda ninimo reka eini bua ingova asuge! Kotú, eka andoro eini bua fu, undava asugadi! ");
INSERT INTO bjz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Anda mendi ená ambue-tago, jebugetue. Baghimbetue-tago, tambere, amindu igige, burumakao da mendi reka korodugo eininu dea burea bua fu-gea, namonde banau jojabe egegore!’ ");
INSERT INTO bjz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Aghá egegutueta, unda mendi bego aayo rovareta kaverea etia, kambo kasava bubia mo, divari furari egegetueta ningie. ");
INSERT INTO bjz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aghá ningia, buro kato eini retueta etieta, kambova donu rei-sirorutua-nu, uriga ea ningie. ");
INSERT INTO bjz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Buro kato undú mino eghá retue, ‘Inda ikoko dara eini jo bambi taubana kaverea etia bubie. Amindu, nimamo burumakao da mendi reka korodugo reta dea buria, banau rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aghá retueta, aná mendi bego neno akuago etue-gea, kambo rova terari uno ambi etue. Amindu, numamo bubua etia, isaghava unda mendi terua, unda ikoko gari-du, benunu etue. ");
INSERT INTO bjz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Aghá etueta, numamodu eghá retue, ‘Afa, eveta gi! Amó ená ghaeko inono inda sabua* kato ea, buro uta refara, inda donu rari jo ningia doambi, kotú besiga ambi eta rore. Tago, imó andú oka gouti da mendi eini jo utota, amó anda kokomanade dano neno gangorogha undidigambi re. ");
INSERT INTO bjz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Atá, inda mendi inda gugua-ghayafa bua iya, arau enembode yausi-yausi jijimu ea sidara etueta, imó erea, oka burumakau da mendi ijoko korodugonu undú detoravore.’ ");
INSERT INTO bjz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aghá retueta, numamo mino undú eghá retue, ‘Anda mendi, imó aná angá danode tumanadu viteravore. Amindu, eini-eini dano andava vitia, aná inda tofo re. ");
INSERT INTO bjz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amindu, namonde ená banau neno gangorogha egegaita rosore. Anada bee mo, inda ikoko ambue-tago, umó oreki jebugetue, baghimbetue-tago, namonde umó tatambugetore.’” ");
INSERT INTO bjz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aghade, Iesu na unda ambo nímbidu eghá ririe, “Gugua-ghayafade embóda buro kato eini iya, aná gugua-ghayafade embódava bubua, númanda beforo righarida tamova gaga eghá retue, ‘Námane buro kakatoda beforo righari-mi, inda gugua-ghayafa siosa jijimu rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aghá retueta, aná gugua-ghayafade embómi ghogho retueta etieta, eghá retue, ‘Amó inda tamova gaga sembago retueta ningere. Amindu, inda buro riara-da ingiso bofu gare! Imó ená buroda beforo righari rekago jo ambi aita roravore.’ ");
INSERT INTO bjz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aghá retueta, aná embó undufako eghá nundubetue, ‘Anda barirari anda buro doari-du reirie. Amó enda ghambari jo inono irambi re. Kotú amó begera ariva meka rore. Amindu oreki amó daiyagha a? ");
INSERT INTO bjz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bakua, amó buro doa, daiyagha ata-gea, enembo andú “Orokaiva” rea, ghaito teno fugaita rousua, aná oreki rei-gerore.’ ");
INSERT INTO bjz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Amindu, aná beforo righarimi unda bariraridava eini-eini o guri nanjogo rururia enembo dano aghi etueta, daba-daba etia teterugetue. Sei etia-du eghá retue, ‘Anda bariraridava imó mino nanjogo utasiro?’ ");
INSERT INTO bjz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Amó ika ragaro olivi da muu 3,200 lita aghago utasire,’ aghá retueta, aná beforo righari-mi undú mino eghá retue, ‘Ingiso eini indú gembera évereta. Tutumi bua ii, asumbea, 3,200 retora-nu dufea, 1,200 gembu!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aghá rea doa, kotú unda ambova terua embó einidu eghá retue, ‘Imó nanjogo utasiro?’ retueta, aná embó, mino aná beforo righari-du eghá retue, ‘Amó faravada vee otoo 1,000 aghago utasire.’ Aghá retueta, aná beforo righari-mi eghá retue, ‘Avotago, ená indú simbugetora ingisonu bua, 1,000 dufea, 800 gembu!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Anada ambova, aná gugua-ghayafade embó etia, unda buro katoda beforo righari daiyagha-daiyagha urota, unda undari barida emboro simbugetua-du raga retue. Anada bee mo, ená endava enembo dumeni tamoda unonu ea goghó egegaita rea, númane nundubea goghó eta rousue. Atá, unanava irita rousua enembo jo aghá ambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Atá amó nímandu eghá rere. Endada gugua-ghayafanu makasi enembodava vesa boanda urota, kokomana oruabe bubugadi rere. Aghá egegadora mo, gugua-ghayafa sidara adua feferava, nímane tumanadu irari kambesiva teteruguturota, nímandu ‘Orokaiva’ rirota, ghaito teno fugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Avona enembodu verua urota, buro ijoijokoko ea goghó adua, dabako aghagonu buro jojabebei ea goghó aita rouvie. Kotú enembo avona buro ijoijokoko urota, guri bagia adua, umó buro jojabeva beago bagia aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Amindu imó endada gugua-ghayafa jijimu urota dinunu adora, God imó gaabee ambi urota, gugua-ghayafa bee jo utota bambi aita roravore. ");
INSERT INTO bjz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aghagonu, imó enembo dumenida eini-eini jo kaifa ea goghó ambi adora, God na tofo inda eini-eini jo utota bambi aita roravore. ");
INSERT INTO bjz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sabua* enembo eini avona jo babarigari ungaghada buro ambi aita rouvie. Umó eininu neno rururota, eini injigha aita rouvie. O umó einida buronu ea goghó urota, eini injigha aita rouvie. Amindu gurinu ambo-ambo adora, imó God jo ambo-ambo ambi aita roravore. Nímane jo guri baita nundubuturota, God da buro ari inono egegambi aita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Moses da Gaga Kaifa kakatomi* Iesu da gaga riria-nu niningigea, kuvia gegha regeguturie. Anada bee mo, númane gurinu neno bubugeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aghá egegutueta, Iesu, eghá ririe, “Nímane nendufako enemboda dibeva taubana aghago egegeta rosoravore. Tago, God nímanda neno roo dano gita rouvie. Atá enemboda rorova eini-eini donu númanena iti bee itiva ari gaa regegeta rousua, aná God injigha eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses da Agho Dariva, kotú feroveta dumenimi God dava ya bubarida emboro seida gaganu gembua, minono regegutueta mambube mane niningigeta urie. Tago, Jon Bafutaito Ari kato furia-da ambova God unda emboro reka ifeguturieta, anada minono reaveta niningigea, enembo oruabe ano ea ya, anava teterugaita rea, susumbugeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Atá, uutude endadeda rata manjari rouvia, aná rauko re. Tago, God da Gaga bukava gembari vitia, anada mendó eini itoko jo manjambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Embó avona unda evetu doa, evetu eini yagera adua, umó God da dibeva komanada evetugha kasava viro kombo ari aghago aita rouvie. Kotú baitura eini, avonu yagera adua, umó beago God da dibeva komanada evetugha kasava viro kombo ari aghago aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Embó eini umó gugua-ghayafade re. Atá, unda irariva, umó fefera inono dighari ombari taubana jetogonu dighia ombea, undari bari esiko-esikonu dirota, kotú avo asumbari taubanava asumbea irita etue. ");
INSERT INTO bjz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Aghade, makasi embó eini, ragaro Lasarus, tamo betomi gigimbari, unda kokomanami bua fuava, aná embóda kambo bebatova itiaveta vasia irirota, aná gugua-ghayafade embóda undari farovareta jua voradua-nu, undaita uno eta etue. Aghá uaveta, nino mane fuava, unda beto mane sosofeta etue. ");
INSERT INTO bjz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aghá ueta, aná begera katoda amburari fefera bubieta, umó ambueta, anerami bua iya, Abraham da kasava ititigetue. Anada ambova, aná embó gugua-ghayafade umó beago ambueta, bua iya furugetue. ");
INSERT INTO bjz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aghá etueta, aná embó iya, ari-bari akokogo ari kakatoda kambesiva bubua, umó mema jojabe itatama urota, dibe fugia, Lasarus airobe Abraham da kasava asumbea irieta gie. ");
INSERT INTO bjz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gie-gea, ghogho rirota, eghá retue, ‘Afa Abraham, amó ivarida vevera jojabe itatama roreta! Andú neno mema ea rege, Lasarus unda ingo taruadarimi uvuva ga degimbea bua furá, anda aveva safau ae!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aghá retueta, Abraham ningia, mino eghá retue, ‘Anda mendi, imó endava vitara, aná eini-eini taubana manenu jijimu eta riaravore. Atá, Lasarus, umó eini-eini sembago manenu jijimu eta ria. Amindu, umó oreki neno gangorogha eve irieta, imó mema jojabe itatama roravore. ");
INSERT INTO bjz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kotú eini mo, namonde anda rorova gudoro jojabemi vitie. Amindu enembo eini evereta indava yari jo inono irambi re. Dabako aghago, enembo eini avoreta eve rekimbari inono irambi re.’ ");
INSERT INTO bjz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Aghá retueta, aná gugua-ghayafade embó mino eghá retue, ‘Avore, afa, amó indava benunu rore. Lasarus ninengadi, kaverea ya, anda afada kambova anda jamena ingo yoveni vitia-dava ená gaganu rata niningigoe! Aghá rata-gea, númane ená mema itatama ari kambesiva furambi egegoe!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aghá retueta, Abraham na mino eghá retue, ‘Moses de kotú feroveta dumenideda gegembuguturia gaganu niningigoe!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aghá retueta, gugua-ghayafade embó mino eghá retue, ‘Tefo! Afa Abraham, jo ningambi aita rousue. Tago, enembo eini amburarivareta kaverea yadua mo, númane umonu gaabee urota, neno kaverea, ivata taubana fufugadua-jogo!’ ");
INSERT INTO bjz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aghá retueta, Abraham undú mino eghá retue, ‘Atá, númane Moses da, kotú feroveta maneda gaga jo niningigambi egegadua, amburari enembomi kaverea ya, donu radua beago, númane jo niningigambi egegaita rousue.’” ");
INSERT INTO bjz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu na unda ambo nimbidu nghaĩ ititurota eghá ririe, “Endava enembodava kuvia gari dibe eini be eini siroreaveta, mema kotú bouvu itatama eta rousue. Tago, aná kuvia gari rera-nu, avona bua furá anami unda komana eini kuvirota juradua mo, undava mema sembago sirorota, itatama aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amindu rea, avona sasingu maneda rorova eininu kuvirota, ari akuago adua, taubana mo, singoi jojabenu unda ukova dighia fugasueta, uvu kafuruva degimbasue. ");
INSERT INTO bjz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amindu, nendufa kaifa ea goghó urota iririge! Inda komanami ari-bari sembago adua, gaa dibeva rege! Umó neno kaveradua mo, unda sembago nundubea gia do! ");
INSERT INTO bjz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Atá, umó onembo dabakoda rova, fefera dano 7, indava ari-bari sembago ea, kotú fefera dano 7 kaverea furá indava, ‘Amó neno kaveretore.’ radua, umó aná nundubea gia do!” ");
INSERT INTO bjz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iesu aghá rea sidara uria-da ambova, unda ambo nímbimi regeguturie, “Jojabee, námanda gaabee ari sonembe, bariroe!” ");
INSERT INTO bjz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Nímanda gaabee ari ijokoko, ika ragaro maineda veego iradua mo, inona radi-gea, ená ika jojabe gavide inda gaa ningia, riribu numbua voriya karajeva jiria bariraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nundubea gigige! Nímanda rorova enembo einida sabua* buro katomi unda sifi mane kaifa asua, o aayova buro asua mo, buro sidara asueta, ambova umó kaverea furá kambova bubasueta unda barirarimi, ‘Tutumi fu, terua asumbea undari undadi!’ rasua? ");
INSERT INTO bjz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aghá rasua katogo, doa unda barirarimi eghá raita rouvie. ‘Anda undarinu simbugea, eembo evia, amó kaifa uradi-gea, amó undaride uvude undia sidara adora-da ambova, imó inda undaride uvude undadi!’ raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Atá, umó buro donu ari-du retueta etua-du, unda barirarimi undú ‘aiye’ rari jo nundubambi re. ");
INSERT INTO bjz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nímane aná sabua dabako aghago re! God nímane donu egegadi radua-nu, ege, sidara ata-gea, eghá regege! ‘Námane God da sabua enembo-gea, donu ari-du retua, aná nuenembo egegetore.’” ");
INSERT INTO bjz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu Bogu Naa Jerusalem yaita aria, Galili frovensi doa, Samaria frovensiva rekimbuturia-da gorotova, ");
INSERT INTO bjz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","umó aria, naa einiva buburitua, enembo dano ingo ungagha tamo betomi gigimbarimi umó furueta gigiguturie-gea, airo bee jiria, be koko fugia, “Jojabee Iesu, námandu neno mema ege!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aghá regeguturieta, Iesu, númane gia, eghá ririe, “Igige, fristi* manedava nímanda tamo nendufako irugadi!” ririeta, númane kaverea igigutueta, númanda tamo dano taubana urie. ");
INSERT INTO bjz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Aghá urieta, númanda rorova Jiusi enemboda gitofo Samaria embó einimi, umó jebuguturia-nu undufako gia, be koko fugia, God du raga rita kaverea furia, Iesu dava bubua, unda eka tuva jua vavosurota, undú “Aiye” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aghá urieta, Iesu na uriga urie. “Embobo dano ingo ungagha jebugetora mo, embobo 9 niavoro? ");
INSERT INTO bjz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Númane dano jejebugetua mo, dodu kaverea furá, God du raga rambi dodogetueta, ená naa einiva embómi eti?” ");
INSERT INTO bjz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aghá rea doa, aná embódu ririe, “Inda gaabee arimi imó jebugetoravota! Erea ii!” ");
INSERT INTO bjz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fefera eini Moses Da Gaga Kaifa kakatomi* Iesu dava uriga egeguturie, “God unda natofo* tumanadu kaifa aita rouvia-da fefera nanjigo bubadu?” aghá regeguturieta, umó mino eghá ririe, “God unda natofo tumanadu kaifa aita rouvia-da fefera nanjigo furaita rouvia, jo enemboda nundubarimi tanana ari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Enembo eini avona jo ‘God da riria fefera enanu bubie.’ o ‘Onanu bubie,’ rari inono irambi re. Anada bee mo, Afa God da enembo* kaifa ari fefera seibe unda natofoda neno rova vitie.” ");
INSERT INTO bjz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Anada ambova, Iesu na unda ambo nimbidu eghá ririe, “Nímane Enemboda Jojabee* kaverea furaita riria feferanu gaita uno urota, kaifa egegaita rosoravore-tago, aná riria fefera jo gambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Atá enembomi, ‘Umó enanu bubie.’ o ‘Onanu bubie,’ riradua, ananu mania ningia, inda gaabee ari doa, númanda ambo-ambo ata!” ");
INSERT INTO bjz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anada bee mo, Enemboda Jojabee furaita rouvia feferava, aná eghá aita rouvie. Eto-bato kirivami uutuva tari eaveta, uutu enda tano vareta tanova unana eaveta, enembo oruabemi gita rousua, aghagonu aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Avotago, umó aghá ambi-da tutunova, umó mema oruaruabe itatama urota, kotú orekida feferava enembo vitia-mi umó injigha egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Eto-bato Noa da feferava ari-bari daiyagha siroruturia aghagonu, Enemboda Jojabeeda feferava beago, aghá siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa da feferava enembo boro-banau ueta, evevetu yagera ueta, kotú embobodava vai egegutueta, Noa unda ghava teterurie. Teterurieta, uria jojabe buburiturieta, aná enembo dano karaje undia ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Lot da feferava beago, dabako aghago siroruturie. Sodom bogu naava enembo boro-banau egegutueta, gurimi utua, eini-eini rurueta, urari-govari egegutueta, kambo unombu ititigutueta, Lot aná bogu naa Sodom doa irueta, ivaride ivegha veveraghami uutuvareta boruma vorarigo ea, enembo dano evia ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noa ungá Lot ghada feferava daiyagha siroruturia, aghagonu egeguturota, Enemboda Jojabee isaghava bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Umó furaita rouvia feferava, enembo avona kambo sebova iradua, o aayova buro rouradua, umó jo kaverea ya, kambova terua, unda eini-eini bambi asue. ");
INSERT INTO bjz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot da evetunu nundubea gigige! Umó endada gugua-ghayafanu nundubuturota, bogu naa Sodom gaita kaveruturia, God na urieta, umó singoi ninditurie. ");
INSERT INTO bjz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Enembo avona endava gugua-ghayafa nundubuturota, amburaridu oru ea, andú goitu fotadua, ambova umó jebuga tumanadu irarinu kasovigaita rouvie. Tago, enembo avona anda ragarova bouvu o mema jojabe itatama ea amburadua, ambova umó jebuga tumanadu irari tambaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Amó nímandu eghá rere: aná fefera bubaita rouvia-da tumbade, enembo ungagha kambesi dabakova vasia eviviguturota, eininu rururota, eini doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Dabako aghago evevetu ungagha aayova farava dasiturota, eininu rururota, eini doaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aghá ririeta, unda ambo nímbimi uriga eghá egeguturie. “Jojabee aná niavo siroradu?” regeguturieta, umó númandu mino ririe, “Amburari eini-eini einida tamo niavo betea masa uradua, dii kasi mane avo danode egegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu na, unda ambo nimbi benunu rourogo jarea dodogauve-degea, fefera inono benunu egegari-du iruguturota, kasia eini eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kambesi einiva, irurari kato eini vita, umó God jo gaabee ambi, kotú enembo eini avodu jo verua ambi eta etue. ");
INSERT INTO bjz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kotú, kambesi dabako anava evetu doru eini vita-mi fefera inono fuava aná irurari katodava eghá reta etue, ‘Barirari, anda gitofodava anda uno nanjogo rora-nu amó sonembe!’ ");
INSERT INTO bjz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Aghá reta etue-tago, umó fefera yafabe jo sonembambi eta etue. Anada ambova, umó eghá nundubetue. ‘Amó God jo gaabee ambi, kotú enembo avodu jo verua ambi eta rore-tago, ená evetu doruda uno nanjogo anona ari-du rea reifia, ananu ata, umó neno gangoro aita rouvie. Atá, amó ambi adora, umó fururota amó ea jaraita rore.’” ");
INSERT INTO bjz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kotú, Jojabee eghá ririe, “Aná irurari kato sembagoda retua gaganu, nundubea gigige! ");
INSERT INTO bjz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","God enembo unda tofo gateguturia-mi, fefera inono tumba onembo undava benunu jiigha regegadua mo, tutumi sonembambi adua? ");
INSERT INTO bjz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Amó nímandu eghá rere. God da gateguturia enembo undava benunu egegari tutumi sonembeta rouvie. Tago, Enemboda Jojabee* rekago kaverea furaita rouvia aghade, endava gaabee ari enembo tambadua, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Enembo dumenimi nendufa taubana gaa rirota, enembo dumeni sembago gaa reta rousua-nu nundubuturota, Iesu na kasia eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Embobo ungaghami God Du Tafaroro Ari Kambova* benunu aita rea, iya teterugetue. Eini Moses da Gaga Kaifa kato* re, eini takesi bari kato re. ");
INSERT INTO bjz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Moses da Gaga kaifa katomi undufako umonu nundubuturota, benunuva eghá retue, ‘God, amó indú “aiye” rere. Amó jo embobo dumenigo, bagia kato, ari akokogo ari kato o viro kato aghago irambi re. Kotú ená takesi bari katogo irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Amó fura dabakoda rova fefera ungagha undari tama urota, indava benunu eta rore. Aghade, amó eini-eini donu bari aná dano gategeaveta, dibe ingo ungagha eaveta, dabako aná indú ututa rore.’ ");
INSERT INTO bjz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Avotago aná takesi bari kato, umó airo jiria, dibe uutuva ambi re-tago, umó neno memami jariturota, ingomi nenova derurota, eghá retue, ‘God, amó ari-bari akuago ari kato reta, andú neno mema ege!’ ");
INSERT INTO bjz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Amó nímandu eghá rere, God aná takesi bari katoda benunu ningia, unda ari akokogo nundubea gia dotueta, kambova iye. Tago, Moses da Gaga kaifa katoda sembago jo nundubea gia doambi re. Anada bee evere, enembo avona undufako raga radua, ambova God na umó itota voraita rouvie. Atá, enembo avona durumuguturota, undufa itota voradua, ambova God na umó righota eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Enembo dumeni númanda soká mane, Iesu na unda ingomi númanda tamova isambara ea simbugari-du rea, bua fufuguturie. Aghá egeguturieta, Iesu da ambo nímbimi gigigea, gaa dibe beva regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tago, Iesu aná sasingu mane ghogho ririeta, undava fufuguturieta, eghá ririe. “Sasingu mane mania buregata! Do-gea, andava fufugoe! Anada bee mo, avona neno kaverea, ená sasingu manego adua, númane God unda natofo* kaifa ariva teterugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Amó nímandu gaa bee rere, enembo avona God da natofo kaifa ari kambesiva teraita nundubuturota, sasingu manego ambi adua, númane jo teterugambi aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aghá ririeta, Jiusi enemboda beforo righari embó einimi Iesu dava uriga urie “Irugari kato, imó embó taubana reta, rege ningore! Amó daiyagha ea jebuga tumanadu irari ba?” ");
INSERT INTO bjz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aghá ririeta, Iesu eghá ririe “Imó dodu andú taubana reto? Enembo eini avona jo taubana irambi re-tago, God unuka taubana re. ");
INSERT INTO bjz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Atá, Agho Dari dano imó gari re. Mania komana einida evetu o embógha viro kombo ata, mania enembo eini data amburauveta! Mania bagia ata! Kotú mania enembo einida ragarova gaverami rirota, itia bera-bera ata! Nie nimamoghadu sabua* urota, númanda gaga ningia ambo-ambo ege!” ");
INSERT INTO bjz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aghá ririeta, aná embó mino eghá ririe “Amó ijokovareta baria etera jojabe etora-va, aná Agho Dari dano kaifa eta rore.” ");
INSERT INTO bjz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aghá ririeta, Iesu mino eghá ririe, “Imó dabako jo ambi viteravore. Ii, inda eini-eini dano bua utua, guri bua, makasi enembodu vesa ea doa, imó fu, anda ambova deĩ adi! Aghá adora mo, ambova imó gugua-ghayafa uutuva baita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aná embó Iesu da gaga ningia, unda gugua-ghayafa oruaruabe-gea, umó neno mema urie. ");
INSERT INTO bjz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Aghá ueta, Iesu aná embó tatasegea gia eghá ririe “Oka ragaro kamero mi ninongu toova terari, aná rauko re. Tago, enembo gugua-ghayafade furá, God da natofo* ari aná fakarago bee re.” ");
INSERT INTO bjz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aghá rieta, avona desea niningiguturia-mi uriga egeguturie, “Aghá radora mo, jebuga avona badu?” ");
INSERT INTO bjz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aghá regeguturieta, Iesu mino ririe. “Donu enembomi ari inono irambi, aná God dava rauko bee re.” ");
INSERT INTO bjz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anada ambova, Pita eghá ririe, “Námanda eini-eini dano doa, inda ambo-ambo eta rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aghá ririeta, Iesu númandu mino eghá ririe, “Amó nímandu gaa bee rere, enembo avona God da natofo ea, tumanadu irari kambesiva terua iraita nundubuturota, unda kambode, unda evetude, unda jamenade, unda nue numamode, kotú unda sasingude doa, anda ambova furadua, umó oreki ená retora eini-eini ená endava diguturota rururota, jebuga tumanadu irari beago, fefera ambova baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu na unda ambo nímbi 12 bua, airo jiria, númandu eghá ririe, “Niningige! Namonde amó ya, Jerusalem bubota, feroveta manemi Enemboda Jojabeedava* donu siroraita rouvia gaga gefiria-da bee aná siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Umó nandia bundia bua ya, namonde amó Jiusi enemboda gitofoda ingova itota-gea, undú tauga kavanana rea, kuvia gegha rirota, visogha unda tamova egeguturota, fisurea, ifatarava dedegota amburaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tago fefera bakode sidara adua-da ambova, umó rekago amburarivareta jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tago, Iesu da riria gagada bee unda ambo nimbidava jo isagha ambi-gea, umó donu riria, aná númane jo ningia tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu aria, Jeriko naava buburitua, embó eini dibe soikide emboro kasava asumbea begera urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Irirota, natofo furia, umó serigutueta niningurie-gea, donu sirorutua-nu rata ningaita uriga urieta, ");
INSERT INTO bjz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","mino regeguturie, “Nasaret embó Iesu na etia, rei-serigutue.” ");
INSERT INTO bjz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aghá regeguturieta, aná embó dibe soikidemi be fugia eghá ririe. “Iesu, Kini Devit da mendi, God da utaita riria mo, imó re! Amindu, andú neno mema ea, amó sonembe!” ");
INSERT INTO bjz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aghá ririeta, enembo avona Iesu kofiri ea igiguturia-mi, ininigha be doari-du bureguturie-tago, umó jo itoko doambi re, umó koko rirota, rekago be jojabe ghogho ririe, “Ariee! Devit da Mendi, andú neno mema ea, sonembe!” ");
INSERT INTO bjz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aghá ririeta, Iesu tukú ea jiria, aná embó undava bua furari-du ririeta, bua furia, utuvako urieta, Iesu undú uriga urie, ");
INSERT INTO bjz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Amó indú donu ari-du uno ro?” Aghá ririeta, umó mino eghá ririe, “Jojabee, inona rasueta, anda dibe ifegea, rifoda unana gasire!” ");
INSERT INTO bjz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aghá ririeta, Iesu mino eghá ririe, “Inda dibe ifegoe! Inda gaabee arimi imó jebugetoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aghá ria, gaimbo ambi, unda dibe ifeguturieta, Iesu da ambova irurota, God du raga rieta, enembo avona umó gigiguturia beago, dano God du raga regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Iesu aria, Jeriko bubua terua irueta, takesi bari kakatoda barirari eini, gugua-ghayafade embó, ragaro Sakius na, Iesu mo avouro, ananu gaita uno urie-tago, umó embó tufoko-gea, enembo oruabe buburituria-mi umó gajiturieta, Iesu jo gambi urie. ");
INSERT INTO bjz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Amindu umó, Iesu gaita rea, Iesu da irua emborova sei sumbua aria, ika einiva viviturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aghá urieta, Iesu aria, aná ika tuva bubua, dibe itiva ea, undú eghá ririe, “Sakius, tutumi vore, amó oreki inda kambova ya angá iraita rore.” ");
INSERT INTO bjz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aghá riria-du, umó tutumi vorea, gangorogha undú “Orokaiva!” rirota ghaito teno fugiturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aghá ueta, enembo dano ananu gigigea, mendó gaa eghá regeguturie, “Umó aná ari bari akokogo ari katoda esega embó ea, unda kambova yaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aria, ungá kambova irirota, Sakius na erea jiria, Jojabeedu eghá ririe “Jojabee, gi, amó anda gugua-ghayafa gategea, dibe eini makasi enembodu utaita rore. Kotú, amó enembo avonu kuvia, unda eini-eini rururera-du mino aná aghagonu utaita rore-tago, etova dibe bakode itia utaitare.” ");
INSERT INTO bjz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aghá ririeta, Iesu undú mino eghá ririe, “Ená kamboda numamo oreki God da jebuga tambie. Anada bee mo, Abraham God gaabee urota, jebuga rururia aghagonu ea, umó oreki Abraham da mendi bee eini ea vitie. ");
INSERT INTO bjz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Enemboda Jojabee* reifia-da bee mo, umó avona baghimbea vitia-nu tava ea sonembota, jebuga bari-du rirota reifie,” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Avore, Iesu seibe furia, Bogu Naa Jerusalem utuvako jiria, aná gaga ririe. Kotú umó tanana urie, aná natofo unda gaga niningiguturia-mi, God Afa unda natofo* kaifa ari fefera seibe furia utuvako ari gaa regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Amindu umó kasia eghá ririe, “Kotofuko bingáde embó eini roo enda airo bee einiva undufako yata, ‘avore’ ari utota, umó kini ea kaverea furaita nundubuturota simbugetue. ");
INSERT INTO bjz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Umó yaita urota, unda buro kakato dano ingo ungagha ghogho retueta etia, danode desetueta-gea, guri dabako unda mino onembo 100 buro arida guri aghagonu bua númane daba-dabadu vesa ea doa, eghá retue, ‘Nímane ená guri bua, buro egegutu-gea, etova dumeni siroruturota, amó kaverea furore!’ ");
INSERT INTO bjz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aghá rea doa, umó iye. Tago, unda natofo umó injigha egegeta ria-mi aghi kakato ninengetueta iya, avona rasueta, kini asua embódava eghá regegetue, ‘Námane ená embó námanda kini ari injigha rosore,’ regegetue. ");
INSERT INTO bjz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Aghá regegetue-tago, umó kini ea, kaverea etia, unda naava bubie. Bubua, unda buro kakato aghi etueta bubua, danode desetueta, númane guri nanjogo nanjogo etueta siroretua-nu irugota gaita retue. ");
INSERT INTO bjz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Retueta, unda buro kato eini sei etia-mi retue, ‘Jojabe, inda ututara guri dabakoda etova anona guri dumeni ingo ungaghada inono etore.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aghá retueta, kini mino retue, ‘Aiye rere. Imó aná buro kato taubana bee re. Imó eini-eini ijoijokokonu kaifa ea goghó urota etueta, sirorea jojabe etua-du, imó bogu naa mane dano ingo ungaghada beforo righari aita roravore.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Anada ambova, unda buro kato eini etia retue, ‘Jojabee, amó inda guri ututara-da etova anona guri dumeni ingo dabako etueta siroretue.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aghá retueta, kini mino undú retue. ‘Imó bogu naa dano ingo dabakoda beforo righari aita roravore.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Kotú, unda buro kato eini etia retue, ‘Jojabee, inda guri aná evere. Imó enembo dumenida eini-eini inona tofo buta roravore. Kotú, enembo dumenida aayo govari, inona iiava buta roravore. Imó embó fakara bee-gea, amó indú oru urota, inda guri eembo kasami otoo ea itari vita.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aghá retueta, unda barirari mino retue, ‘Rei-gerora? Imó buro kato embó akuago re. Inda gaga rera-mi anona imó iruraita rore. Imó gari re, amó aná embó fakara bee re. Kotú, imó nundubetoravore, enembo dumenida eini-eini, kotú númanda aayova eini-eini dano anona bari rei-nundubutoravore. ");
INSERT INTO bjz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Amindu imó dodu anda guri bua ya, kambaruva itota, buro urota, amó kaverea furá, inda itadora-da etova dumeni sirorota bambi eto?’ ");
INSERT INTO bjz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aghá rea, enembo anava jijiregea vita-du retue, ‘Ená buro katodava aná guri rougea bua, buro kato avona guri ingo ungagha bua righia vitia-dava ututuge!’ ");
INSERT INTO bjz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aghá retueta, númane mino regegetue, ‘Barirari, umó seibe guri ingo ungagha bie.’ ");
INSERT INTO bjz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aghá regegetueta, umó mino retue, ‘Nímandu amó eghá rere. Enembo avodava eini-eini oruabe iradua, anada etova oruabe utota baita rouvie. Tago, enembo avodava itoko iradua, aná rougea baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Avore, anda gitofo enembo avona amó númanda kini auve-degea, injigha egegetua mane bua fufuge eve, anda dibeva dedegadi ambubugoe!’” Iesu aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aghá riria-da ambova, Iesu erea, númanda dibe kena Bogu Naa Jerusalem arie. ");
INSERT INTO bjz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aria, naa ungagha Betfeij Betani gha ooto ragaro Olivi vitia, anava bubaita igiguturota, unda ambo nimbi ungagha sei ninenguturota, eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Igige, nímanda dibe kena naava teteruguturota, oka donki da mendi, avo buri ari vitia-nu gigigaita rosoravore. Enembo eini jo sei aná okada etova asumbea iru-furu ambi re. Ananu vuregea bua kaverea, eve fufuge! ");
INSERT INTO bjz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aghá urota, embó einimi, ‘Avona retueta rei-vureguto?’ radua mo, undú, ‘Jojabee na uno etue,’ regege!” Iesu aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Avonu ninenguturieta igiguturia-mi aria, Iesu da donu riria aghagonu tatambuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tambua, aná donki mendida buri vuregutueta, unda tofomi uriga urie, “Nímane dodu aná donki mendida buri reisi-vureguto?” ");
INSERT INTO bjz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aghá ririeta, númane mino regeguturie, “Jojabee na uno etue.” ");
INSERT INTO bjz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Rea, ungá bua furia, Iesu dava bubua, númanda asugari etova mane kosugea, aná donki mendida tamova beisi ea, Iesu bua ituturieta, vitia, etova asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aghá egeguturieta, enembo númanda etova asugari mane kokosugea, emborova beisi egegutueta, Iesu avo fatia jiria arie. ");
INSERT INTO bjz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Emborova aria, Olivi Ootovareta vovorurota, Jerusalem utuvako ueta gigiguturie. Gigigea, Iesu da yaveromi Jojabeeda ivata nanjogo uaveta númanda gigigeta uria-nu nundubuturota, be jojabe koko fugia, God du raga regeguturota, “Aiye!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Raga eghá regeguturie, “Orokaiva, Orokaiva! Kini, Jojabeeda ragarova bubua reifia-du raga regegore! ‘Orokaiva!’ Siriri uutuva iroe, kotú God Iti Beeva unda duroghadu raga regegore! Orokaiva!” ");
INSERT INTO bjz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aghá regegutueta, Moses da Gaga kaifa kakato* dumeni enemboda raga rei-riria-da rova iririguturota niningigea, Iesu du eghá regeguturie, “Irugari kato, rege, inda yavero be dodogoe!” ");
INSERT INTO bjz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aghá regeguturieta, Iesu na mino númandu eghá ririe “Gaa bee rere, amó rata númane be dodogadua, ená singoi vavasegea vitia manemi erea, koko regegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu aria, Iesu Bogu Jerusalem utuvako urota, dibe fugia, aná bogu naa gerurota, unda dibe jiivu furia averegea vovorurie. ");
INSERT INTO bjz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Umó jii rirota, eghá ririe, “Anda uno rora, oreki nímane siririda emboro gigigea tanana egegasiravore! Tago, emboro nímandava jo isagha ambi irieta, nímane jo gigigambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Fefera ambova reifia aghade, gitofomi furá, nímanda naa aagha vegea, enda ghaghambegota vitia, jefuru ata-gea, avo vitia jiria rarigea vovoregaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rarigea vorea, nímanda naa susughi egeguturota, natofo dano data ambubugaita rousue. Nímanda naa singoimi dighia ovenembari vitia, aná dea bebejegota averegea vovoregea, unda unda ya, sidara aita rouvie. Anada bee mo, God da nímane sonembaita furia fefera, nímane jo gia tanana egegambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Anada ambova, Iesu aria, God du Tafaroro Ari Kamboda* ghouka rova terua jiria, enembo eini-eini utua, guri rurueta gerurie-gea, tutuno ea númane tuviturie. ");
INSERT INTO bjz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aghá ea, númandu eghá ririe, “God da Gaga bukava eghá gembari vitie, ‘Anda Afada kambo aná benunu ari kambo re. Tago, nímane egegetueta, anda Kambo aná bagia enemboda nungegi ari kambo aghago ea vitie.’” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iesu fefera inono, God du Tafaroro Ari Kambova irugeta urie. Tago, fristida* kokotofude, Moses da Gaga Irugari kakatode* kotú enemboda babarigaride Iesu data amburari-du emboro tava rousurie. ");
INSERT INTO bjz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aghá egeguturie-tago, enembo nanjogo dano Iesu da gaga ria, ananu niningua-du, dedegari-da emboro eini jo tambambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Fefera eini God du Tafaroro Ari Kambova* enembo desuturieta, Iesu na iruguturota, God da Gaga Taubananu minono rieta, fristi* maneda kokotofude, Moses da Gaga Irugari kakatode* kotú Jiusi enemboda babarigaride dano furia eghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Avona retueta, imó ená buro ro? Kotú, imó avoda ragarova ená buro eta ro? Rege, námane niningigore!” ");
INSERT INTO bjz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aghá ririeta, Iesu númandu mino eghá ririe, “Amó mino nímandu uriga eini aita rioreta, andú regege ningore! ");
INSERT INTO bjz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Avota, regege, ningore, Jon Bafutaito Ari Katoda bafutaito arida ano God dava rururia aĩ, endava enembodava rururia? Ananu rege, ningore!” ");
INSERT INTO bjz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Iesu aghá ririeta, númane nenukako mino-mino rea niningiguturie, “Namonde ‘God dava’ regegadora, umó eghá raita rouvie, ‘Atá, dodu Jon Bafutaito Ari Kato gaabee egegambi roso?’ Enembo dano nundubeta rousua, Jon umó God da feroveta eini re. Amindu, namonde amó ‘Endava enembo dava’ regegadora mo, ená natofo jede desetua-mi, namonde amó singoimi dedegaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Amindu, númane mana-mana ea, mino eghá regeguturie, “Niavoreta furia, námane jo tanana irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aghá regeguturieta, Iesu na mino eghá ririe, “Nímane aghá regegetora-du, amó avona ririeta, ená buro rora, jo rata nímane niningigambi aita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aghá rea doa, Iesu tutuno ea, natofo jededu kasia eini eghá ririe, “Aayo numamo eini unda endava vaini da ghavesi govea, guri utota baita rea, enembo dumenida ingova utue. Utua, umó aná kambesi doa erea, kambesi einiva iye. Iya, fefera yafabe avo irieta, ");
INSERT INTO bjz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","aná ghavesida vuri vurarida fefera bubieta, aná aayo numamo unda boanda bua furari-du rea, unda buro kato eini ninengetueta iye. Iya bubia mo, aná aayo kaifa kakato númane erea, aná buro kato dedegea tuvetueta, ingo tefo kaverea iye. ");
INSERT INTO bjz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Avore, aná aayo numamo rekago unda buro ari kato eini ninengetueta iya bubia mo, umógha dano dea, kuvia gegha regeguturota, tuvetueta, ingo tefo kaverea iye. ");
INSERT INTO bjz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kotú, unda buro kato eini ninengetueta iya bubia mo, aná aayo kaifa kakatomi erea, aná buro kato eini beago, dea tamo kikisoregea, aayo kasava fugetueta voretue. ");
INSERT INTO bjz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aghá egegetua-du, aayo numamo eghá retue, ‘Amó daiyagha a? Aghajora, amó anda neno bari mendi dabakonu ninengota yadua mo, undú verua egegadua-jogo.’ ");
INSERT INTO bjz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aghá rea doa, unda mendi ninengetueta iye. Iya bubieta, aná aayo kaifa kakato númane gie-gea mino-mino regegetue, ‘Oná gimasa aná aayo tofoda mendi enanu etia bubie. Egege, namonde umó dedegota amburota, unda eini-eini nanjogo dano namonde anda tofo ae!’ ");
INSERT INTO bjz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aghá regegea, aná mendi aayo rova nandia bua, aayo kasava fugea dedegetueta ambue. Atá gigige! Aghá egegadua mo, aná aayo numamo númandu daiyagha adu? ");
INSERT INTO bjz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umó eghá aita rouvie. Umó furá bubua, aná aayo kaifa ari kakato, data ambubugota, aná aayo bua enembo dumenida ingova utaita rouvie.” Iesu aghá rieta, aná enembo niningigea eghá regeguturie, “Aiya! Mania sirorauveta!” ");
INSERT INTO bjz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aghá regeguturieta, Iesu númanenu tatasegea gia goghó urota, eghá ririe, “Atá, bukava eghá gembari vitia-da bee mo, doro? ‘Singoi eini kambo itari kakatomi injigha ea doa fugituria-nu Jojabee na bua, unda kambo roro tutumbudu itia simbuguturie.’ ");
INSERT INTO bjz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Atá enembo avona aná singoi etova juradua, dea bebetegea, ito-fakono aita rouvie. Avotago, aná singoimi avoda etova juradua, umó fatia betota, enda nindaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aghá ririeta niningigea, Moses da Gaga Irugari kakatode, fristida* kokotofudemi Iesu fefera aghade númanda tamova aná kasia riria-nu tanana egeguturie. Aghade, Iesu nandia bundaita egeguturie-tago, natofodu oru egeguturie-gea, dotuturieta arie. ");
INSERT INTO bjz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Anada ambova, Moses da Gaga irugari kakatode fristida* kokotofudemi righigi enembo ninenguturieta uriga gaveranu gaa bee rarigo urota, umó kuvia gaita igigiguturie. Iesu gaga sembago rata ningia, umó nandia bundia bua, gavanada kokotofudava utota umonu gavanada bingáva koto ari-du igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aná righigi enembo aria bubua, undava uriga eghá urie, “Irugari kato, námane tanana egegeta rosore, imó aná gaa bee nuenembo irugeta roravore. Enembo, kokotofu ra, o makasi enembo ra, imó danode inonova buta roravore. Kotú, imó God da Gaga bee nuenembo irugea goghó eta roravore. ");
INSERT INTO bjz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Rege, niningigore! Namonde anda Agho Darimi reiria mo, daiyagha egega? Namonde anda gitofo Rom enemboda kotofudu takesi mo utara, aĩ, doara? Rege, niningigore!” ");
INSERT INTO bjz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","25","Númanda umó kuvia gigigaita uria, umó tanana urie-gea, númandu eghá ririe, “Aná guri eininu iruge, gare! Aná guri tamova imumude ragarode avoda ro?” ririeta, númane, “Rom enembo da Jojabee Sisar da re,” regeguturieta, umó eghá ririe, “Avorego, Sisar da tofo aná Sisar du ututuge, bae! Kotú God da tofo, aná God du ututuge, bae!” ");
INSERT INTO bjz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aghá ririeta niningigea, númane mana-mana egeguturota, be dodogea, ghuvi-ghava egegututurie. Anada bee mo, natofoda dibeva Iesu kuviraita egeguturia, umó gaga akuago eini jo rambi urie. ");
INSERT INTO bjz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jiusi enemboda dumeni Sadyusi* regegeta rousua-da rari mo, enembo amburarivareta jo jebugea erambi gaa regegeta rousue. Númanda dumenimi furia, Iesu dava bubua, uriga egeguturie, ");
INSERT INTO bjz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Irugari kato, Moses na, Agho Dariva namonde andú eghá gefirie. Embó evetu bua, sasingu jo sirorambi doa, amburadua mo, unda doru aná embóda jamena einimi foite ari-du gefirie. Aghá ea, ana doruda sasingu siroradua mo, aná amburari embó da sasingu asue. ");
INSERT INTO bjz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","31","Námane kiki eini raita roreta, ningi! Sasingu vivide dano 7 sirorea vitirie. Anava begomi evetu bua vitirie-tago, mendi sasingu jo sirorambi doa ambubuturie. Aghami-aghami uta aria, ");
INSERT INTO bjz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ambo jetukomi bua, mendi sasingu jo sirorambi, umó beago ambubuturie. Bego ambo dano 7 dava vee eini jo sirorambi doa ambubuguturie. Aghá ea, sidara uria-da ambova, aná doru beago ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Avotago, rege, niningigore! Fefera ambova amburarivareta jebugea eradua mo, aná evetu avoda evetu adu? Anada bee mo, embobo dano 7 evetu dabako ananu yagera egeguturie.” ");
INSERT INTO bjz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aghá ririeta, Iesu númandu eghá ririe, “Orekida fefera endava enembo evetu yagera ea, kotú embódava vai rousue. ");
INSERT INTO bjz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Avotago, God avodu ‘avore’ rata-gea, amburarivareta jebugea eradua feferava, umó jo yagera ambi o vai ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anada bee mo, God na rata, númane amburarivareta jebugea ereregea, unda sasingu bee ea, anera aghago, jo rekago ambubugambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kotú, enembo amburarivareta jebugea ereta rousua-nu Moses beago undufako iruguturie. Sifá-sifáva ivari gambua bubura ueta geruria-da gagava, Jojabee avouvi nundubuturota, eghá gefirie, ‘Niabua mane, Abraham, Aisak kotú Jekop endava irirota, gaabee eta uria, kotú oreki gaabee eta rousua-da God, aná amó re.’ ");
INSERT INTO bjz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God aghá riria-du, namonde amó reisi-gerore, God jo amburari enemboda God irambi re. Amburari enembo, jo amburota sidara ambi vitie. Enembo sei ambubuturia-de, kotú jebuga vitia-de dano God da dibeva amburambi irieta, rei-gerue.” ");
INSERT INTO bjz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aghá riria-da ambova, Moses da Gaga Irugari kakato* dumenimi mino eghá regeguturie, “Irugari kato, imó gaga taubana bee retoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Anada ambova enembo dano uriga eini undava ari oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aghade, Iesu na númandu eghá ririe, “God na embó eini ninengota furari-du riria mo, daiyagha Devit da mendi gaa reta rousu? ");
INSERT INTO bjz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Aghá rera-da bee mo, Devit na aná Daa Divari buka ragaro Psalms va aná embódu rirota, eghá gefirie, ‘God, unona anda Jojabeedu ririe, “Fu anda ingo bee kena asumbadi-gea, anona inda gitofo dea bundia bua furá, inda eka tuva ghandada gharari-du itota vasioe!” ’ Devit na aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Avore, Devit na undú ‘Jojabee’ radua mo, daiyagha umó mo, Devit da mendi gaa reisi-rere?” ");
INSERT INTO bjz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aghade enembo dano Iesu da gaga donu ria-nu niningueta, unda ambo nimbidu eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kaifa ea goghó egege! Mania Moses da Gaga Irugari kakatoda* ambo-ambo egegata! Númane gangorogha asugari dighari yayafabebei esiko-esikonu asugea ya, utua bari kambesiva bubota, enembomi númane kakara urota, ari oro rea goghó egeguturota, ghanena ari-du uno egegeta rousue. Ari dabako aghagonu nghaĩ itari kambova*, kotú banau feferava enembomi kokotofu enemboda asumbari kambesi taubananu utota asumbaita uno egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Númane aghá urota, dodoruda kambode gugua-ghayafade tefo-tafo rururota, God du Tafaroro Ari Kambova terua jiria, enembomi númane raga rari-du rea, benunu numbo tofo egegeta rousue. Aghá enembo, God na fefera ambova númandu mema jojabe kotú bouvu akuago beenu utota baita rousue.” ");
INSERT INTO bjz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Enembo gugua-ghayafade manemi furia, God du vesa utari kibubuva gurinu vesa ututueta, Iesu dibe jará gerurie. ");
INSERT INTO bjz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kotú aghade, doru makasi bee einimi furia, guri auri kofa mi ari ijoijokoko ungagha kibubuva fefendueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aghá gerurie-gea, eghá ririe, “Reisi-gerora, aná evetu doru umó makasi re-tago, umó jojabe utue. Enembo eini jo unda utua, aghago utambi re. ");
INSERT INTO bjz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Anada bee mo, enembo dumeni númanda gugua-ghayafava gerurota bubua itie. Tago, ená doru makasi bee re. Undava donu vita, aná dano bua utue. Kotú, undava irasueta, umó ambova jijimu asua katogo, aná dano bua etia utue.” ");
INSERT INTO bjz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aghade, unda ambo nimbi dumenimi God du Tafaroro Ari Kambonu* gerurie-gea raga eghá regeguturie. “Gigige! Aná kamboda tutumbu singoi esiko-esiko manemi ari re. Kotú enemboda vesa esiko-esiko ututuguturia-mi itia goghó egeguturie,” raga aghá regeguturia-du, Iesu eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Atá, oreki ená eini-eini donu nímanda reisi-gerora, anada singoi mane eini jo unda irari kambesiva jirambi aita rouvie. Dano averegea, unda unda vovoregaita rousue.” umó aghá riria-du númane undava uriga egeguturie, ");
INSERT INTO bjz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Irugari Kato, ená rera eini-eini, fefera nanjigo siroradu? Ivata domi uutu enda tano aita rouvia fefera irugadu?” ");
INSERT INTO bjz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aghá regeguturieta, Iesu númandu eghá ririe, “Dibe bee gerurota, kaifa egege, rorogo nímane kuvia gavera rata-gea ananu gaa bee gaa regegareta! Anada bee mo, enembo oruaruabe furá, nímane kukuvirota, gavera eghá regegaita rousue, ‘Embó eini God utaita riria, aná amó re,’ kotú, ‘Fefera etia utuvako etue!’ Aghá radua, mania númanda gaga ambo-ambo egegata! ");
INSERT INTO bjz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Atá, enembo tefo neno aita rirota, tataya egegadua-da bingá o mene-mene dumenida kinini gaa niningigadora, mania oru egegata! Anada bee mo, yavi aghago mane sei siroraita rouvie. Tago uutu enda jo aghade banuna ambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kotú, rekago Iesu númandu eghá ririe, “Roo enda dumeni dumenida beforo ririkigari o kini mane ereregea, mino-mino mene-mene egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kotú, gino-gino akokogode baimanade kotú bunembada oyade furaita rouvie. Aghade, ivata jojabebei, akokogo uutuva sirorota, enembo gigiguturota, orumi eka ingo dadada urota, ghabobo itatama arigo egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Avotago, ená yavi sirorambi-da dibe kena enembo dumeni furá, nímane anda ragarova gaabee egegadora-du, nímane nandia bundia bua ya, nghaĩ itari kambo o dibura kambesiva ititigaita rousue. Aghade, nímane bua ya, kini mane, kotú gavanada babarigarida dibeva itota jijiregaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aghade, nímanda fefera bubaita rouvieta, andava donu niningigeta rosora-nu isaghava regege! ");
INSERT INTO bjz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tago, nendufako gangada urota, nímanda serigari gaga donu raita rosora-du mania nundubari fakarago egegata! ");
INSERT INTO bjz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Anada bee mo, nímanda neno nundubarida gaga anona sonembota, gaga taubana, bouvu beenu regegaita rosora-du, nímanda gitofo niningigea, mino rari jo inono ambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Nímane amó gaabee egegeta rosora-du enembo oruaruabe nímane injigha aita rousue. Aghá urota, nímanda aya afa, ikoko mendi, kotú enembo totofomi nímane dumeni nandia bua data ambubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Aghá uradua, mania oru egegata! Afana nímane sonembota amburarivareta jebugea eraita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Amindu, ano ea, gaabee egeguturota jiria goghó egege! Aghá urota, jebuga tumanadu irari bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Tago, gitofoda mene-mene ari kakatomi Bogu Naa Jerusalem aagha vegota gigigadora mo, eghá nundube! ‘Jerusalem bogu naava oreki reta bubua susughi aita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Amindu, nímane avona Judia Frovensiva iririgadora, sumbua airo igigigea, dafaruva nunungegadi! O, nímane avona bogu naava iririgadora beago, tutumi sumbua airo igige! Kotú, nímane avona bogu naava kasava dighia iririgadora, mania sumbua, Bogu Naa Jerusalem va furá teterugata! ");
INSERT INTO bjz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Anada bee mo, God da Gagava donu gefiria, anada bee rifo aghade siroraita rouvie. Ari akokogoda mino God na utaita riria fefera aghade isaghava sirorota gigigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Arii, amó evevetu tambouvude ea iraita rousua-du, kotú evevetu dumeni sasingu emi gaiturota iraita rousua-du, neno mema rore. Anada bee mo, fefera bubadua, evevetu dumeni sasingu bua sumbari ata-bata urota, mema fakara bee itatama egegaita rousue. God na ená endava kotú Jiusi enembodu mema jojago bee utota, númane itatama aita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jiusi enembo dumeni vikokomi data ambubuguturota, dumeni gitofomi susughi ea nandia bua ya, roo enda dumeniva ititigaita rousue. Aghá urota, gitofomi Bogu Naa Jerusalem susughi bubua, beforo ririkiguturota, God da gateguturia fefera bubota, riria, númane serigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","God na ata-gea, fefera marabe kotú damana maneda rorova ivata anogha kotú yavi dibe eini be eini siroraita rouvie. Aghade, yaura yavatade urota, ghorubebea urota, kusúgha bejaita rouvia-du, enda etova roo enda nanjogoda enembo dano mana-mana egeguturota, tatafi egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Uutuva eini-eini nanjogo righia rarovota, unana jo janimbea goghó ambi aita rouvia-du, donu ená endava sirorasua-nu nundubuturota, enembo dano orumi jinongo andebaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Fefera aghade, Enembo da Jojabee, anode durogha jojabede gooso rova vovorurota gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ená eini-eini retora, siroruturota gigigadora mo, ano ea jiria goghó urota, donu siroraita rouvia-nu gia goghó egege! Anada bee mo, nímanda jebugada sonemba bubaita reifieta.” ");
INSERT INTO bjz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aghá rea doa, Iesu kasia eini númandu eghá ririe, “Ika simbia kotú ika dumeni nundubea gigige! ");
INSERT INTO bjz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ika mane batuma ea, igi fangiturota gigigadora, aná bee righaita rouvia aghago, tanana egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aghagonu, aná eini-eini retora-nu gigigadora mo, tanana egegadi rere, fefera utuvako etua-du, God unda natofo* kaifa aita rouvia-da fefera furá bubaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Amó nímandu gaa bee rere. Oreki rei-sirorutua enembo dano, jo ambua sidara ambi, dumeni irota, ená ivata retora, siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Uutude endade dano manjaita rouvie-tago, anda Gaga jo nanjigo aghade manjambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Nímane nendufa kaifa ea goghó egege! Mania nendufa doadi-gea, ená eini-eini nanjogoda unomi nímanda neno rova beda auveta! Boro-banauva kotú uvu fakara bebei undidiguturota, iririgadora mo, amumi gaimbo tefo jua, taima oka deta rouvia aghago, aná fefera furá bubota, nímane duduku egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aghá-gea, fefera inono kaifa ea goghó urota, ano ea, benunu urota iririge! Aghá rera-da bee mo, anda uno, ená eini-eini retora sirorea furá, nímane serigota, Enembo da Jojabeeda dibeva gangorogha jirari inono egegadi rere.” ");
INSERT INTO bjz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Fefera inono Iesu umó God du Tafaroro Ari Kambova* nghaĩ itita urie. Tago, jama ea, tumba rirari mo, umó iiava ooto ragaro Olivi avo evita urie. ");
INSERT INTO bjz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kotú, rifo atea, fururari, enembo nanjogo fuava, unda minono rirari-nu niningigaita rea, God du Tafaroro Ari Kambova teterugeta urie. ");
INSERT INTO bjz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Banau* fefera eini unda ragaro ungagha, Yisti Tama Ari Banau kotú Serigea Yari Banau regegeta uria-mi, furia uutuva ua-du rea, fristi* maneda kokotofu, kotú Moses da Gaga Irugari kakato* tutuno ea, Iesu dedegaita rirota, emboro dumeni tava egeguturie. Natofo jededu oru egeguturota, umonu nenomi dedegaita nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aghá ueta, Satan na Judas dava asuguturie. Judas rera, umó Keriot embó, Iesu da ambo nimbi 12 da eini re. ");
INSERT INTO bjz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Asuguturia-da ambova, Judas aria, fristi maneda kokotofu, kotú God du Tafaroro Ari Kamboda* Kaifa kakato dava bubua, daiyagha Iesu númanda ingova utasua-da manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aghá ririeta ningia, númane gangoro egeguturota, Judas gurimi mino aita regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aghá regeguturieta, Judas “avore” rea, tutuno ea, daiyagha daiyagha natofo jede jo gambi, Iesu nu nenomi bua, númanda ingova utasua-da emboro tava urie. ");
INSERT INTO bjz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yisti Tama Ari Banauda fefera furia buburiturieta, enembo Serigea Yari Banaudu sifi memendi dea burasuada rifo atiturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aghade, Iesu na Pita ungá Jon gha ninenguturota, eghá ririe, “Igige, Serigea Yarida Banau simbugadi, namonde undidigore!” ");
INSERT INTO bjz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Iesu aghá riria-du, ungá uriga urie, “Námane kambesi niavo Serigea Yari Banau simbuga?” ");
INSERT INTO bjz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aghá ririeta, Iesu mino eghá ririe, “Igige, Bogu Naa Jerusalem teteruguturota, embó eini ovumi uvu dimbua bua fururota tatambugaita rosoravore. Aná embóda ambo tuvia, igige! Umó niavo teradua, kambesi dabako avo teterugea, ");
INSERT INTO bjz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aná kambo tofodu eghá regege! ‘Irugari katomi eghá retue, “Umó kambesi niavo terua, unda ambo nimbide Serigea Yari Banau simbugea undidigadu?” ’ ");
INSERT INTO bjz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ingá imó bua ya, kambo tuva doa, kambesi taubana, itiva simbugari vitia-nu, irugota gigigaita rosoravore. Namonde anda banau avo simbuge!” ");
INSERT INTO bjz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iesu aghá ririeta niningigea erea aria, Iesu da daiyagha riria, aghagonu isagha urieta, ungá Serigea Yarida Banau avo simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Serigea Yari Banau undari fefera furia buburiturieta, Iesu unda ambo nimbide dano terua, faro kasava asusumbea ovenembea undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Asusumbuguturia-da ambova, Iesu eghá ririe, “Amó oreki mema jojabe, kotú bouvube itatama aita rora-da dibeva, amó ená Serigea Yari Banau namonde danode undaita uno bee rore. ");
INSERT INTO bjz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Amó gaa bee rere: ená banau jo rekago undambi irota, anada bee sirorota, God Afada natofo* tumanadu kaifa aita rouvia kambesiva danode undidigaitare.” ");
INSERT INTO bjz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aghá riria-da ambova, aagha ririkurieta erorurieta, God du “Aiye” rea, unda ambo nimbidu ututurota ririe, “Ená vaini bua, nendufako vesa ea undidige!” ");
INSERT INTO bjz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Aghá rera-da bee mo, amó vaini ghavesida bee jo rekago undambi irogo, God Afada natofo tumanadu kaifa ari fefera furá bubota-gea, aghade undaitare. ");
INSERT INTO bjz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aghá rea, farava ingari bua, God du aiye rea, righia ingegebea, unda ambo nimbidu ututurota ririe, “Ená anda tamo reta, nímandu rei-ututore. Eghagonu urota, fefera ambova anda amburari-nu nundube-nundube urota iririge!” ");
INSERT INTO bjz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Undari undidiguturia-da ambova, unda uria aghagonu urota, aagha bua, númandu ututurota, eghá ririe, “Ená aagha anda tatangu re. Amó anda tatangu nímandu averegaita rora-mi God dava yari emboro* reka ifegaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Avotago, amó dubo urota bua, gitofodava utaita rouvia embó namonde danode ená farova asumbea vitere. ");
INSERT INTO bjz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Enemboda Jojabee*, umó donu ari-du gaga gefiria, aghagonu aita rouvie. Tago, umó avona Enemboda Jojabee dari-du kivumi emboro aita rouvia embódava, mema jojabe itatama aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iesu aghá ririeta ningia, unda ambo nimbi mana-mana egeguturota, númane, avona umó bua, gitofodava utaita rouvia-nu nendufa tava egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aghade, Iesu da tuva beforo righari avona asua-du nundubuturota, unda ambo nimbi tutuno ea, besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aghá egegutueta, Iesu númandu eghá ririe, “Ená endada kini mane númanda uno nuenembo egegeta rousue. Aghade, númanda kaifa egegeta rousua enembomi númandu raga rirota, ‘Kavevera kato re.’ regegari-du uno rousue. ");
INSERT INTO bjz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Avotago, nímanda rorova aghagonu jo egegambi egegasiravore. Avona nímanda rorova bego aghago iraita asua mo, umó kaverea ambo aghago asue. Kotú avona beforo righari iraita asua mo, umó kaverea vorea, sabua* embó aghago asue. ");
INSERT INTO bjz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Atá jojabe mo avouvi? Avona undari undaita asumbeta rouvie ra, aĩ, undari vesa eta rouvia ra? Jojabe mo aná undari undaita asumbaita rouvia embó re. Tago, nímanda rorova amó buro kato aghagonu ea, nímane sonembeta rore. ");
INSERT INTO bjz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Andava kuvia gari mane furia, nímane namonde danode vitare. Amó jo doa serigambi re. ");
INSERT INTO bjz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Kotú anda Afami, anona beforo righari-du ano ututuria dabako aghagonu, nímandu ano utota babarigari egegea, nímane fefera ambova anda natofo* kaifa aita rora kambesiva babarigarida asumbari kambesiva asumbea irirota, undaride uvude dirota, Israel enemboda abua dano 12 nu gia iruruturota, kaifa egegaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu rekago eghá ririe, “Saimon, Saimon, nghaĩ javea ningi! Satan na seibe angia, eto-bato embó einimi aayova iiava isia taubana mane rururota, jeghi mane dota rouvia aghagonu, nímane kuvia gaita rea, seibe God dava benunu utata ‘avore’ rita. ");
INSERT INTO bjz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Avotago, amó rourogo inda gaabee ari doata jurauve-degea, God Afa na indú ano utari-du benunu etore. Atá imó kaverea andava furadora mo, inda ikoko mendidu ano ututurota kaifa ege!” ");
INSERT INTO bjz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iesu aghá ririeta, Saimon mino eghá ririe, “Jojabee, amó angá ya dibura aita, kotú angá amburaita simbugetore.” ");
INSERT INTO bjz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aghá ririeta, Iesu undú eghá ririe, “Pita, amó indú eghá rere. Oreki tumbade kokora be dimbambi irota, imó fefera bakode amó jo gambi gaa rirota, kivu aita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aghá riria-da ambova Iesu númandava uriga urie, “Amó sei nímane guri, etota kotú eka andoro tefo ninenguturera aghade, nímane eini-eini dodu neno mema ambi ra?” ririeta, númane “Tefo” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu rekago númandu ririe, “Avotago, oreki inda sufide etotade iradua, aná bu! Atá, mene-mene ari kaiya tefo iradua, inda tamo asugari eininu bua utua, guri bua, kaiya eini gia gurimi mino utua bu! ");
INSERT INTO bjz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Amó nímandu gaa bee rere, God na amó nundubuturota ririeta, feroveta einimi unda bukava eghá gefirie, ‘Bagia kakato deaveta ambubugeta rousua aghagonu, umó dedeguturieta ambubuturie.’ Anada gagade, gaga dumenide andú rea gefiria, anada bee rei-siroretue.” ");
INSERT INTO bjz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Aghá ririeta, unda ambo nimbi undú eghá ririe, “Jojabee, gi! Mene-mene ari kaiya ungagha evere!” ririeta, Jojabee na ririe, “Avore, aná inono re.” ");
INSERT INTO bjz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu unda eta uria aghagonu, ooto ragaro Olivi anava irueta, unda ambo nimbi erea, ambo ga numonde igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aria, aná kambesiva bubua kaverea, unda ambo nimbidu eghá ririe, “Dibe fakara ea, benunu egege, rourogo Satan furá, nímane kuvirota, ari akokogo egegare-degea, rere!” ");
INSERT INTO bjz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aghá rea, umó númane doa, eto-bato enembomi singoi fugasueta yasua airo bee jurasua aghagonu aria, koubomi joroto ea, benunu urie. ");
INSERT INTO bjz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Unda benunuva eghá ririe, “Afa, imó ‘avore’ radora, ená mema andava reifia, doa bu! Avotago, jo anda unonu ambi aita roreta, do-gea, inda unonu siroroe!” ");
INSERT INTO bjz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aghá ririeta, anera uutuvareta vorefuria, undava isagha ea, ano ututurie. ");
INSERT INTO bjz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aghade, umó mema jojabe itatama urota, benunu anogha ueta, unda oufufu eto-bato tatangugo tẽtã ea, endava vovorurie. ");
INSERT INTO bjz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","46","Benunu ea doa, Iesu kaverea aria, unda ambo nimbidava buburituria, númane neno memami jajareguturie-gea, vasia evivigutueta gia, númandu uriga urie, “Nímane dodu evo roso? Ereregea, dibe fakara ea, benunu egege, rourogo Satan furá, nímane kuvirota, ari akokogo egegare-degea, rere!” ");
INSERT INTO bjz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu gaga ria aghade, unda ambo nimbida eini, embó ragaro Judas na natofo jede kofiri ea bua furia buburiturie. Bubua, Iesu muno aita, Judas aria, utuva urie. ");
INSERT INTO bjz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aghá urieta, Iesu na undú eghá ririe, “Judas Enemboda Jojabee* inona munomi irugea bua, gitofodava utaita rora?” ");
INSERT INTO bjz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aghá ueta, Iesu da ambo nimbi numonde vitiria-mi donu siroraita rouvia-nu gigiguturie-gea, uriga urie, “Jojabee, námanda kaiya kosugea bua, mene-mene ara?” ");
INSERT INTO bjz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aghá rea, númanda einimi fristida* beforo righarida sabua* embóda nghaĩ ingo bee kenanu vegea kositurieta jujururie. ");
INSERT INTO bjz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aghá urieta, Iesu na ririe, “Rekago donu eini mania egegata!” rirota, aná embóda nghaĩ bua, rekago ititurieta takembuturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aghá ea doa, fristida kokotofu, God du Tafaroro Ari Kambo* kaifa kakato, kotú Jiusi enemboda beforo ririkigaride umó nandaita fufuguturia-du Iesu na eghá ririe, “Nímane dodu vikokode gandighade bua, amó nandaita fufugeto? Amó jo gavana tuvari gaa eini jo rambi re. ");
INSERT INTO bjz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Atá, amó fefera yafabe namonde God du Tafaroro Ari Kambo ghokava terua irirota irugeta riara mo, enembo eini avona amó jo nandambi re-tago, oreki Satan da anomi tumba rirarigo rouvia-du, ená nímanda fefera re.” ");
INSERT INTO bjz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aghá riria-da ambova, númane umó nandia bua, fristida* beforo righarida kambova igigutueta, Pita umó itoko ambo fugea ea jiria uta arie. ");
INSERT INTO bjz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aria bubua, kambo isaghava ivari gagembea, danode asusumbuguturieta, Pita beago númanda gorotova asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aghade, buro kato ariri einimi furia, Pita ivari unanava asumbea irieta gerurie-gea, aria, utuva tatasegea gia goghó urota, eghá ririe, “Ená embó beago, Iesu de danode deĩ rosa.” ");
INSERT INTO bjz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aghá ririeta, Pita umó kivu urota, eghá ririe, “Evetu, inda rera embó, amó jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aghá ririeta, itoko irirota, enembo einimi umó gerurie-gea, eghá ririe, “Imó beago, númanda eini re.” ririeta, Pita mino eghá ririe, “Embó, amó jo númanda eini irambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Anada ambova itoko yafabe irirota, enembo einimi rekago ininigha ririe, “Mana-mana tefo re. Gaa bee re, ená embó aná Galili embó eini re. Aghá-gea, numonde danode vita.” ");
INSERT INTO bjz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aghá ririeta, Pita undú mino eghá ririe, “Embó, imó dodu rera, amó itoko jo gambi re.” Aghá ria, kokora be difirie. ");
INSERT INTO bjz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aghá rieta, Jojabee kaverea, Pita nu tatasegea geruria-du, Pita umó Jojabeeda undú gaga riria-nu nundubuturie, “Oreki tumbade kokora be dimbambi irota, fefera bakode inona amó kivu aita roravore.” ");
INSERT INTO bjz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iesu da riria gaganu nundubea, umó isaghava bubua, jiimi neno gagajeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aghade, embobo Iesu kaifa rousuria-mi, umó kuvia gegha rirota dedeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Númane Iesu da dibe eembomi rafea gajea umó dedeguturota, eghá ririe, “Avota, indava ferovetada ano iradua mo, rege niningigore: Imó avona detu?” ");
INSERT INTO bjz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aghá urota, númane unda tamova gaga akokogo oruabe regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rifo atiturieta, Jiusi enemboda babarigari kanisera* ea vitiria-mi desuturie. (Amó fristi* maneda kokotofude, Moses da Gaga Irugari kakatodu* rere.) Númane aria, danode desuturieta, Iesu bua, númandava arie. ");
INSERT INTO bjz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Aghá urieta, númane Iesu du uriga eghá urie, “Námandu rege ningore! God na enembo sonembari-du embó eini utaita riria mo, aná imó ra?” ririeta, Iesu mino eghá ririe, “Amó nímandu raita rore-tago, nímane amó jo gaabee egegambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kotú, amó nímandu uriga adora, nímane mino jo regegambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tago, oreki enavareta dibe kena yaita rora-va, Enemboda Jojabee* God Afa Ano katoda ingo bee kenava, asumbea iraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aghá ririeta, enembo dano aregea farara urota, mino eghá regeguturie, “Atá imó God da Mendi rera?” regegeguturieta, umó mino eghá ririe, “Nu reravore! Amó re!” ");
INSERT INTO bjz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aghá ririeta, númane mino-mino regeguturie, “Dodu gagada osagho fumbari enembo dumenida gaga niningiga? Unda beemi undufako retueta, namonde niningigetore.” ");
INSERT INTO bjz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aghade kanisera* mane erea, Iesu kofiri ea bua aria, Pailat dava bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aghá ea, númanena umonu itia bera-bera egeguturota, eghá regeguturie, “Ená embómi námanda roo endava enembodu nghaĩ akuago ititurota, Rom enemboda gavana Sisar dava takesi ututugauve-degea gaa rirota, ‘God Enemboda Jojabee* ninengota furari gaa riria, umó re,’ rirota, undufako kini eini gaa rieta niningigutare.” ");
INSERT INTO bjz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aghá regeguturieta, Pailat na Iesu du uriga urie, “Imó Jiusi enemboda kini ra?” ririeta, Iesu mino ririe, “Eẽ, inda rera aghago re,” ");
INSERT INTO bjz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aghá ririeta, Pailat aná fristida* kokotofudu, kotú natofo jededu eghá ririe, “Amó ená embódava dara eini jo tambambi re. Amindu, umó koto arida ruru, aná tefo re.” ");
INSERT INTO bjz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aghá ririe-tago, númane ininigha eghá regeguturie, “Unda irugarimi ueta, Judia enembo dano deriva urota, gaa ningambi egegeta rousue. Umó tutuno avo Galili reta uta etia, oreki enava bubie.” ");
INSERT INTO bjz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat aghá niningurie-gea, uriga urie, “Ená embó mo, Galili embó ra?” ");
INSERT INTO bjz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aghade, Iesu umó Herot da beforo righarida tuva irieta, Pailat gia tanana urie-gea, Iesu ninenguturieta, Herot dava arie. Herot fefera anava Jerusalem vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aghade, Herot Iesu geruria, umó gangoro jojabe urie. Anada bee mo, fefera yafabe umó Iesu gaita uno urota vitirie. Iesu da daiyagha eta uria-nu umó ningita urie-gea, unona ivata dumeni ata sirorota gaita rouvia, aghagonu nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aghá urie-gea, Iesu dava umó uriga oruabe urie-tago, Iesu gaga mino eini jo undú rambi re. ");
INSERT INTO bjz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aghá urieta, fristi maneda* kokotofu, kotú Moses da Gaga Irugari kakatode* anava jijiregea vitiria-mi erea, gaga ininigha rirota, umó itia bera-bera egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aghá egeguturieta, Herot unda mene-mene ari kakatode Iesu kuvia gegha regeguturota, undú gaga akokogo rea doa, asugari taubanadogo eininu ututurieta undava asugea ninenguturieta kaverea, Pailat dava arie. ");
INSERT INTO bjz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Sei Herot ungá Pailat gha vesó-vesó egegeta urie-tago, fefera aghade ungá umó mambu taubana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat na fristida* kokotofu, kotú enemboda beforo ririkigari natofo jede dano ririeta furia, danode egeguturieta, ");
INSERT INTO bjz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","númandu ririe, “Nímane ená embó bua, andava etera, unona námane Rom enembo dea tuvari gaa rari reisi-reravore. Atá, oreki nímanda dibeva umó koto urota gera mo, dara eini jo undava tambambi re. ");
INSERT INTO bjz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot beago, dara eini undava donu jo tambambi-gea, namonde andava itieta kaverea etie. Amindu ená embó data amburari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Aghá-gea, amó anda mene-mene ari kakato rata, umó fisurea doata yaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tago, númane dano be dabako koko fugia regeguturie, “Aná embó dege amburoe! Námandu Barabas nu do-gea furá, isaghava buboe!” ");
INSERT INTO bjz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Atá, Barabas umó enembo dumenide Jerusalem bogu naava Rom enemboda gavana injigha ea, dea tuvari gaa riria-du, kotú enembo derurieta ambubuguturia-du, umó bua diburava gajiturieta vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat na Iesu doata bubua yari-du uno urota, rekago aná natofo ghogho ririe. ");
INSERT INTO bjz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Avotago, númane, “Umó ifatarava dege, amburoe! Umó ifatarava dege, amburoe!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailat sei fefera ungagha uriga ea, rekago fefera eini uriga urie, “Bee dodu? Kotú umó dinunu donu etu? Amó undava tava etora, umó amburari katogo irambi re. Amindu amó rata, umó fisurea doata bubua yaita rouvie,” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aghá ririe-tago, aná enembo umó ifatarava dari-du be jojabe koko fugia, regeguturia-mi, Pailat da uno bureguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aghá-gea, Pailat aná natofoda donu uno egeguturia-nu urie. ");
INSERT INTO bjz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Amindu, embó ragaro Barabas, embó eini derurieta ambubuturia-nu, Pailat na dotuturieta furia, isaghava buburiturie. Pailat aghá uria-mi, númanda unoda bee aná Iesu dava siroruturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aghá urieta, mene-mene ari kakatomi Iesu ghambugea bua igiguturota, Sairini embó eini ragaro Saimon Jerusalem teraita irueta gia, Iesu da ifatara fumbari-du rea bera-bera urieta, Saimon aná ifatara fumbua, Iesu da ambo kena arie. ");
INSERT INTO bjz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Anava enembo natofo oruaruabe Iesu da ambova igigutua-da rova, evevetu dumeni Iesu du neno mema urota, jii regeguta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Igigutueta, Iesu kaverea númandu eghá ririe, “Jerusalem evevetu, mania andú jii regegata! Tofo nendufako kotú nímanda sasingudu jii regege! ");
INSERT INTO bjz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Fefera ambova, evevetu avona eero iraita rousua-du, kotú urova mendi sasingu sirorambi, kotú mendi sasingu emi gaiturota undurambi eta rousua-du ‘bakua egegari’ gaa regegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aghade, númane dafarudu eghá regegaita rousue, ‘Námanda etova jurasiravore!’ kotú ooto manedu, ‘Námane gajasiravore!’ regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anada bee mo, mema anda itatama rora, aná ika safauva evari aghago itatama rore. Atá nímandava reifia eto-bato ghaekova ivari ika evia gharasa eta rouvia aghago re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ari-bari akokogo ari embobo ungaghade dano, Iesu de data ambubugari-du rea, kofiri ea bua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Numonde aria, kambesi ragaro Amburari Enemboda Beforo Siruru anava bububugea, Iesu ifatarava dedeguturie. Aghade, bagia kakato ungagha beago bua furia, eini Iesu da ingo bee kena, eini ingo anda kena ifatarava dedeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aghá egeguturieta, Iesu benunu urota, eghá ririe, “Afa, númane donu rousua-da bee, númane jo tanana ea goghó ambi-gea, númanda ari-bari akokogo nundubea gia do!” Anada ambova, númane kikindo gaegeguturota, Iesu da asugarinu vesa ea bubuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Enembo jiria dingera egegutueta, Jiusi enemboda beforo ririkigarimi Iesu kuvia gegha regeguturota, eghá regeguturie, “Unona urieta, enembo dumeni jejebuguturie. Kotú enemboda ari-bari sembago nundubea gia doari-du, God da utaita riria embó, aná umó re, reirie. Do-gea, umó undufako sonemboe!” aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mene-mene ari kakato beago, Iesu kuvia gegha regeguturota, undú vaini kaeenu ututuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aghá urota regeguturie, “Imó Jiusi enemboda kini iradora mo, indufako sonembe!” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aghade, Iesu da beforo gombuva gaga eghá gembua ititurie: Ená Jiusi enemboda kini re. ");
INSERT INTO bjz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ari-bari akokogo ari embobo Iesu de dedeguturia-da einimi, Iesu du tauga kavavana rirota, eghá ririe, “Atá, imó God enemboda ari-bari akokogo nundubea gia doaita riria embó iradora, indufako sonembuturota, námane beago sonembe!” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Avotago, einimi gaa dibeva eghá ririe, “Imó God du oru ambi rora? Imó daiyagha itatama rora aghagonu umó aghá itatama rouvie. ");
INSERT INTO bjz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tago, angá mo, dodu eghá egegetua aná gaa bee re. Anada bee mo, angáda donu rosara-da mino reta reisi-rurore. Avotago, ená embó ari akuago eini donu jo ambi re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aghá rea doa, kaverea ririe, “Iesu, imó ya inda natofo kaifa ari kambesiva bubadora mo, amó nundube!” ");
INSERT INTO bjz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aghá ririeta, Iesu mino undú eghá ririe, “Amó indú gaa bee rere, oreki imó angá dano God da kambesi taubanava teraita rosore.” ");
INSERT INTO bjz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Fefera beforova aghagonu ueta, roo enda dano bingoimi afuregea irieta aria, jama 3 koroki urie. ");
INSERT INTO bjz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aghá ea, fefera janimbambi irieta, God du Tafaroro Ari Kambo* bogu naa Jerusalem vitiria-da rova, rourogo enembo ya, Kambesi Kakara Bee anava terua amburauve-degea rea, eembo einimi gajari vitiria, aná rorova sarigea, be ungagha urie. ");
INSERT INTO bjz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aghá ueta, Iesu koko fugia ririe, “Afa, inda ingova anda asisi rei-ututore,” aghá rirota, ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aghade, mene-mene ari kakatoda beforo righari aná donu siroruturia-nu gia, God raga rirota ririe, “Gaa bee re, ená embó ari-bari sembago tefo re.” ");
INSERT INTO bjz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aghade, natofo jede anava daiyagha uua-nu gigigaita danode egeguturia-mi Iesu da amburari gigigea, neno mema ea, jii rirota, númanda nenova biyae dedeguturota, kaverea igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Avotago, Iesu tanana egeguturia enembo, kotú evevetu avona Galili reta Iesu da ambova igiguturia-de dano banunava jijiregea, donu siroruturia, aná dingera rousurie. ");
INSERT INTO bjz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Anava embó ragaro Josep, umó aná Judia frovensiva Arimatea naava embó taubana bee eini re. Umó kanisera* maneda eini re. Kanisera mane dumenida manaka gaegegea, donu egeguturia-du umó jo avore rambi re. God furá, unda natofo* kaifa aita rouvia feferadu kaifa urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Unona aria, Pailat dava bubua, Iesu da tamo utota baita benunu urie. ");
INSERT INTO bjz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Umó Iesu da tamo bua ititurieta vovorurieta, eembo saghai tamomi otoo ea bua furia, uje eini gudoro ufuva ghafirieta vitiria-va furuguturie. Uje rera anava, enembo eini sei jo furugambi re. ");
INSERT INTO bjz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Natofo jede Nangu Undari Feferadu simbugutueta-gea, Josep umó aghá urie. ");
INSERT INTO bjz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aghade, Galili reta Iesu da ambova tuvia furia evevetumi Josep da ambova aria, Iesu uje gudoro ufuva daiyagha itituria, aná númanena gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aghá ea, númane kaverea aria, kambova bubua, ingide uka muu munode simbuguturie. Tago, Nangu Undari Fefera tutuno uria-du, agho dari ambo-ambo urota, númane nangu undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Fura jojabeda rifo tumbava aná evevetumi númanda simbuguturia ingide uka muu munodenu bua, ujeva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aria bububuguturia, aná uje be gajari vitiria singoi aná oberea aria, airo irieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Aghá gigigea, rova teteruguturie-tago, Jojabee Iesu da tamo anava jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Númane avo jijiregea, mana-mana egegutua, jo gaimbo ambi, embobo ungagha eembo saghai kirivada unanagomi tiri-tara ueta, númanda kasava jijiregeturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aghá urieta, aná evevetu orumi jarea goghó egeguturie-gea, tumogha baĩ egeguturota, gonea vorea, endava takembuturie. Aghá egegutueta, aná embobo ungaghami númandu ririe, “Nímane dodu jebuga irari embódu amburarida gorotova tava roso? ");
INSERT INTO bjz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Umó jebugea eretue, eve tefo re. Umó, nimonde dano Galili irirota, daiyagha riria-nu nundubea gigige! ");
INSERT INTO bjz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Enemboda Jojabee* aná ari-bari sembago enemboda ingova utota, númanena data amburaita rouvie. Tago fefera bakode sidara adua, umó amburarivareta jebugea eraita rouvie.’” ");
INSERT INTO bjz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aghá ririeta, Iesu na aná gaga donu riria, númane rekago nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","Aná evevetu rera, Makdala embóda ariri Meri, Joana, Jems da nue Meri, kotú evevetu dumenide númane ujevareta kaverea furia, Iesu da ambo nímbi 11 de, kotú enembo dumenidedu, donu geruria, aná regeguturieta niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iesu da ambo nímbi aná gaga niningurie-tago, númane jo gaabee egegambi re. Anada bee mo, aná evevetumi neno nundubea goghó ambi urota rari gaa regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Avotago, Pita na erea sumbua aria, uje beva gonea geruria mo, Iesu da tamo jo gambi re-tago umó eghovuturia eembo bimbi manemi vavasigea irieta gerurie. Donu siroruturia-du mana-mana urota umó kaverea arie. ");
INSERT INTO bjz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Fefera dabako anava, Iesu da yavero embobo ungagha Jerusalem reta naa ragaro Emeus igiguturie. Jerusalem reta Emeus emboroda yafa aná kilomita 11 aghago re. ");
INSERT INTO bjz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aghade, ungá igiguturota, donu siroruturia-da gaganu mino-mino rea nininguta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Irurota, donu siroruturia-nu ungá mino-mino gaga rea niningua aghade, Iesu undufako bubua, numonde danode igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ungá umó Iesu gigigiturie-tago, Iesu na urieta, númane jo umó tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Numonde igiguturota, Iesu na númandu uriga urie, “Nímane dodu mino-mino rea niningiguta reisi-fo?” ririeta, númane tukú ea jijiregea, tumo gonea, neno mema dibe be egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Embó einida ragaro Kliopas re. Unona Iesu du eghá ririe, “Imó mo, Jerusalem yarida esega embó ra-jogo? Aghá-gea eini-eini donu ená feferava siroruta, jo gambi ra?” ");
INSERT INTO bjz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aghá ririeta, Iesu na uriga urie, “Eini-eini doro?” ririeta, númane mino regeguturie, “Nasaret embó Iesu du rere. Umó feroveta eini re. Enemboda dibeva, kotú God da dibeva unda gagade ivatade dano anogha ria. ");
INSERT INTO bjz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Namonde amó Jiusi enemboda babarigaride, kotú fristida* kokotofudemi Iesu amburari-du uno egeguta-gea, umó bua Rom enembodava ututata, ifatarava dedegutata ambubuta. ");
INSERT INTO bjz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aghá egeguta-tago, námanda nundubuturera, unona unda anomi Israel enembo sonembasueta, tefo neno egegasue-tago, umó ifatarava dedegutata ambua, oreki fefera bakode sidara etue. ");
INSERT INTO bjz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Námanda evevetu dumeni oreki rifogha Iesu da ujeva iya, donu gigigetua, ananu retueta ningia, námane duduku-dadaka ea, mana-mana egegetore. ");
INSERT INTO bjz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Atá númane iya, Iesu da tamo jo gigigambi re. Tago, númanda rariva númane anera ungaghanu barauva gigigetue. Atá, aná anera ungaghami númandu Iesu jebugea erari gaa retue. ");
INSERT INTO bjz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Anada ambova, námanda kokomana dumeni aná evevetuda regegetua-nu gigigaita iya mo, númanda daiyagha retua aghagonu gigigetue. Tago, Iesu da tamo avo jo gigigambi re.” ");
INSERT INTO bjz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aghá ririeta, Iesu na númandu mino ririe, “Nímane nundubari tefo re. Kotú feroveta maneda gaga donu riria, nímanda neno roomi gaabee ari jo tatavami egegambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Feroveta manemi seibe isagha urie. God Embó eini ninengota furaita rouvia-mi mema jojabe kotú bouvu bee itatama ea, anada ambova unda durogha gariva teraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aghá rea doa, undava donu siroruturia-da gaga kotú undú donu gegembuturia gaganu isuri ea fururota, Moses da buka maneva tutuno ea, feroveta maneda bukava gaga nanjogo beago, aná dano Iesu ungá undú isuri ea furia, sidara urie. ");
INSERT INTO bjz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Numonde númanda rei-aria naava bubaita igiguturota, Iesu númane doa, umó sei serigea yari aghago urie. ");
INSERT INTO bjz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aghá ueta, ungá umó ininigha Iesu bureguturota, eghá ririe, “Fefera vorea tumba riraita rouvieta, imó fu, namonde evore!” Aghá riria-du, umó numonde evaita teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Terua, undari undidigari kambesiva asusumbea, Iesu na God dava “aiye” rea, farava ingari bua ingebea, númandu vesa aita tutuno urie. ");
INSERT INTO bjz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aghá ueta, númanda dibe fangiturieta, umó tanana uua aghade, Iesu niagha yarigo urie. ");
INSERT INTO bjz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aghá urieta, ungá mino-mino rea niningiguturie. “Angá mo, emborova fufuguturota, unda angá andú Buka Kakarada gaga isuri etueta niningigetora aghade, angá anda neno rova giimi gayari-go ueta, itatama egegetore.” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Aghá rea, ungá erea, tutumi kaverea, Jerusalem aria bububuguturie. Buburiturieta, Iesu da ambo nímbi 11 de, kotú enembo dumeni numonde vitiria-de dano desea eghá ririe, “Aná gaa bee re! Jojabee jebugea erora-gea, Saimon dava isagha etueta gie.” ");
INSERT INTO bjz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Anada ambova ungá umó, númanda emboro rorova donu geruria-de, kotú Iesu da farava ingebuturieta ungá unda gia tanana egeguturia, ananu isagha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ungá umó donu ungá undava siroruturia-da gaganu rirota iria aghade, Iesu númanda rorova sirorea jiria, númandu eghá ririe, “Siriri nímandava iroe!” ");
INSERT INTO bjz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aghá ririeta, númane duduku-dadaka ea, oru egeguturota, númane taimu gigigari aghago nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Númane aghá nundubutua, Iesu na númandu eghá ririe, “Nímane dodu duduku-dadaka ea, mana-mana roso? ");
INSERT INTO bjz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ená amó re! Anda ekade ingodenu gigige! Kotú anda tamonu righia gigige! Taimudava firíde, sirurude, andava vitia aghago, tefo re.” ");
INSERT INTO bjz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iesu aghá rirota, unda ekade ingode númandu iruguturieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Umó aghá urie-tago, númane umó gia, gangoro egeguturota, duduku-dadaka egeguturie-gea, tutumi gaabee egegambi re. Aghá egeguturia-du, Iesu na ririe, “Eve nímandava undari eini vitia?” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Aghá riria-du, númane Iesu du uvu oka ingarinu ututurieta bua, númanda dibeva dieta, gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Undia doa, númandu eghá ririe, “Amó namonde deĩ urota, nímandu eghá rirere, ‘Moses da Agho Dariva, God da feroveta maneda gefiria-va, kotú Daa Divari Buka ragaro Psalms va eini-eini nanjogo andava sirorasua-da gaga, aná oreki siroretueta reisi-geroravore.’” ");
INSERT INTO bjz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anada ambova, númane God da Gaga nundubea goghó egegari-du rea, Iesu na urieta númanda neno nundubari ifeguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aghá urieta, Iesu númandu eghá ririe, “God da Gagava eghá gefirieta vitie, ‘God enemboda ari-bari akokogo nundubea gia doaita rea, Embó eini utaita riria, umó mema jojabe itatama ea, ambua, fefera bakodeda ambova jebugea eraita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aghá ata-gea, Jerusalem reta tutuno ea, unda ragarova enembo neno kaverea, ari-bari akokogo doari-du, kotú God na ari akokogo nundubea gia doarida minono abua-abua nanjogodu regegaita rousue. Aghá ata-gea, nímane Jerusalem reta tutuno ea, anda ragarova enembo neno kaverea, ari-bari akokogo doari-du, kotú God na númanda ari akokogo nundubea gia doarida minono abua-abua nanjogodu regegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eini-eini donu siroretua-da osagho fumbari enembo, aná nímane re. ");
INSERT INTO bjz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Anda Afada be gajiturota, unda Asisi Kakara utaita riria, aná anona nímandu utua, nímane ninengaita rore. Tago, nímane Bogu Naa Jerusalem enava kaifa egegutu-gea, ano uutuvareta vorota bubugadi!” ririe. ");
INSERT INTO bjz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aghá rea doa, númane kofiri ea bua bubua aria, Betani naava bubua, ingo ririkurieta erorurieta, númane ea simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Umó númane ea simbugutua aghade, God umó rururieta, númane doa uutuva viviturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aghá urieta, númane Iesu du tumogha baĩ egegea, gangorogha kaverea Jerusalem igiguturie. ");
INSERT INTO bjz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Anada ambova, númane Jerusalem irirota, tumanadu God du Tafaroro Ari Kambova* God du raga regeguturota vitirie. Avore, anda gaga tano evere. Amó Luk re. ");
INSERT INTO bjz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uutude endade jo sirorambi tutunova, God da Gagami vitirie. God da Gaga, umó God gha danode vitirie. Kotú umó beago God re. ");
INSERT INTO bjz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tutunova, umó God gha danode vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eini-eini vitia, jo einimi undufa unda anova sirorambi re, eini-eini dano God da Gagami urieta siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aná Gaga rera, umó jebugada ruru re. Umó jebuga bua furia mo, enemboda unana aghago janimbeta urie. ");
INSERT INTO bjz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Unda unanami bingoi rova janimbeta rouvie. Tago bingoimi jo afuregari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Avore, God unda aghi embó, ragaro Jon, ninenguturieta furie. ");
INSERT INTO bjz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","God umó ninenguturieta furia-da bee mo, unanada minono rata, enembo niningigea gaabee egegari-du rea, umonu ninenguturieta furie. ");
INSERT INTO bjz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon jo aná unana irambi re. Tago, unona unanada gaganu enembodu rata niningigari-du rea, furie. ");
INSERT INTO bjz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aná unana mo, unana bee re. Unona furia, endava enembo nanjogodava janimbeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ená Gaga seibe furia, endava enembode, eini-einide dano urieta siroruturie. Tago, umó avouvi, enembomi jo gia tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Unda natofo Jiusi enembodava furie-tago, númane umó jo bubugambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Aghá egeguturie-tago, avona umó jamono gatiturota gaabee egeguturadua mo, unona númandava aná God da sasingu ari-du ano ututa rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God da sasingu rera, jo númanda anomi o aya afada anomi, kotú enembo dumenida anomi rata sirorambi re. Númane God da anomi unda sasingu ea vitie. ");
INSERT INTO bjz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ená Gaga embó bee nindia sirorea, namonde anda gorotova vitirie. Umó namonde anda rorova irirota, gaa bee nuenembo rirota, namonde amó sonembeta urie. Unda duroghagha namonde gigiguturere. Afa uutuva vitia-da Mendi dabako duroghagha furia irieta, undava gigiguturere. ");
INSERT INTO bjz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon umó Iesu nu nundubuturota, eghá ririe, “‘Embó eini anda ambova reifia,’ ritara, umó aná jojabe re. Amó ijoko re. Anada bee mo, amó jo sirorambi iria-da dibeva, umó aná vitirie.” Jon umó Iesu du aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Unda sonembaride, taubanade ea simbugeaveta, namonde amó bubugeta rosore. Kotú etova-etova namonde amó ea simbugeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses dava God Afa na unda Agho Dari ututurieta bua, enembodu ututurie. Kotú Iesu Keriso na, enembodu neno mema ea sonembarida aitode kotú gaa beede bua furie. ");
INSERT INTO bjz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Enembo eini dibemi God jo gambi re. Tago, God da Mendi dabako, Numamogha danode irita uria-mi furia, God da irari daiyaghago aná ririeta, enembo niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jiusi enemboda babarigarimi Jon uriga ari-du rea, fristi* mane kotú Levi undi Jerusalem reta ninenguturieta, umó avouvi ananu uriga aita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aria bubua, uriga egeguturieta, umó jo kivu ambi, isaghava eghá ririe, “Enemboda Sonemba kato God da utaita riria, aná jo amó irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aghá riria-du, númane uriga egeguturie, “Atá rege niningigore! Feroveta Elaija rekago kaverea furasua, gefiria mo, indú gefiria, aĩ?” regeguturieta, Jon ririe, “Tefo, amó jo umó irambi re,” Aghá ririeta, númane rekago uriga egeguturie, “Imó aná Feroveta ra?” regeguturieta, Jon ririe, “Tefo, amó jo umó irambi re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Umó aghá ririeta, númanena ririe, “Atá imó avouvi, rege niningigore! Námane gaga mino bua kaverea ya enembo avona ninengetueta etera-du regegaita rosore. Imó indufako daiyagha reta ro?” ");
INSERT INTO bjz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Regeguturieta, Jon undufa iruguturota, eghá ririe, “Aisaia da gefiria aghago rere, ‘Uvu tefo kotú enembo irambi kambesiva avo irirota, amó ghogho rere, “Jojabeeda emboro ea simbuge, dambu ae!” ’”. ");
INSERT INTO bjz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Moses da Gaga Kaifa kakato* dumeni ninenguturieta fufuguturia-mi, númanena Jon dava uriga eghá egeguturie, “God na enembo eini ninengota furari gaa reta rousua, jo imó irambi, kotú imó jo Elaija o aná Feroveta irambi rera mo, imó dodu enembo bafutaito eta ro?” ");
INSERT INTO bjz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Aghá regeguturieta, Jon na mino númandu eghá ririe, “Amó tefo uvumi bafutaito eta rore. Tago, embó eini reifia, enada ambova isagha aita rouvie-tago, umó seibe nímanda rorova vitie. Tago, nímane jo gigigambi viteravore. Anode duroghade anda jo undago irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aná eini-eini dano Betani, Jordan Uvu beina fefera vitari kenava, Jon da bafutaito eta uria kambesiva siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rifo atiturieta, Iesu Jon dava furueta gerurie-gea, natofodu eghá ririe, “Gigige! God Sifi da Mendi enemboda ari-bari akokogo bua fugiturota amburari-du riria, onanu reifie. ");
INSERT INTO bjz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amó ená embónu nundubuturota eghá ritare, ‘Embó eini anda ambova reifia, aná jojabe re. Amó ijoko re.’ Anada bee mo, amó jo sirorambi iria-da dibeva, umó vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Umó avouvi, amó andufako jo tanana ambi re. Tago amó uvumi bafutaito urota, umó karigota, Israel enembo isaghava gigigea, tanana egegari-du rea futare,” Jon aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Anada ambova Jon na gaga eini eghá ririe, “God da Asisi Kakarami uutuvareta dii uku nindia, isaghava voretia undava asumbetueta, amó gere. ");
INSERT INTO bjz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Amó jo umó tanana ea goghó ambi re. Tago, God amó uvumi bafutaito ari-du ninenguturieta furera, unona andú eghá ririe, ‘Asisi Kakara vorea, embó avodava asumbota gadora, aná umó re. Unona Asisi Kakarami enembo bafutaito aita rouvie,’ ");
INSERT INTO bjz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ená andú riria, kotú isagha urieta gerurera-nu nímandu rere, ‘Ená umó God da Mendi re.’” ");
INSERT INTO bjz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rifo atiturieta, Jon unda ambo nimbi ungaghade rekago kambesi dabako avo vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aghade Iesu furia serigutueta, Jon na gia, eghá ririe, “Gigige! God Sifi da Mendi ninenguturieta furia, aná overe!” ");
INSERT INTO bjz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon na aghá ririeta, unda ambo nimbi ungagha niningiguturie-gea, ungá Iesu da ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Igigutueta, Iesu kaverea gerurie-gea, númandu uriga urie, “Nímane dodu uno roso?” ririeta, númane regegeturie, “Rabbi (anada bee mo, aná Irugari Kato re.), imó niavo vite?” ");
INSERT INTO bjz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Regeguturieta, Iesu na mino ririe, “Fufuge, gigigadi!” Aghá ririeta, númane nemonde aria, unda irari kambesiva nemonde dano iririgutueta, fefera aria, jama ea, 4 koroki urie. ");
INSERT INTO bjz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon da gaga niningigea, Iesu da ambova igiguturia embobo ungagha eini, Andru re. Ená Andru rera aná, Saimon (o Pita reta rousua) unda ikoko re. ");
INSERT INTO bjz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andru tatavami aria, unda kaka Saimon tambua eghá ririe, “God embó eini utaita riria, aná tatambugetore.” (God da utaita riria Embódu Grik gaami Keriso regegeta rosore.) ");
INSERT INTO bjz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aghá rea, Andru na unda kaka unumbea bua aria, Iesu dava bububuguturieta, Iesu na Saimon tatasegea gerurota eghá ririe, “Imó Jon da mendi Saimon re-tago, inda ragaro reka, Sifas o Pita rei-ririkore!” (Gaa Sifas kotú Pita rera-da bee mo, aná “singoi” re.) ");
INSERT INTO bjz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rifo atiturieta, Iesu Galili Frovensiva yaita nundubuturie-gea, irurota, Filip tambua ririe, “Fu angá yare!” ");
INSERT INTO bjz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip de Andru de Saimon Pita de dano Betsaida naava embobo re. ");
INSERT INTO bjz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip aria, Nataniel tambua ririe, “God da Agho Dari buka, Moses da gefiria-va, embó eini riria, kotú dabako undú feroveta maneda gegembuguturia embó, umó reta tatambugetore. Nasaret embó, Josep da mendi Iesu du rere.” ");
INSERT INTO bjz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Aghá ririeta, Nataniel na besiga urota, Filip du uriga urie, “Taubana eini donu Nasaret reta furadu?” ririeta, Filip na mino ririe, “Avoreta, fu gadi!” ");
INSERT INTO bjz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aghá riria-du, Nataniel erea aria, Iesu dava buburitueta, umó dibe fugia gerurota ririe, “Israel embó bee evere, undava gavera eini tefo re.” ");
INSERT INTO bjz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aghá ririeta, Nataniel na uriga urie, “Imó daiyagha amó ge?” ririeta, Iesu na mino undú eghá ririe, “Filip jo ya, indava bubambi da dibeva, imó ika baga ruruva asumbea irieta amó gere.” ");
INSERT INTO bjz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aghá ririeta, Nataniel mino eghá ririe, “Irugari Kato, imó God da Mendi, Israel enemboda kini re!” ");
INSERT INTO bjz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ririeta, Iesu na mino ririe, “Imó ika baga ruruva asumbea irota gari gaa retora-du, gaabee rora? Aná avore-tago, enada ambova eini-eini dumeni jojabebei gaita roravore.” ");
INSERT INTO bjz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aghá rea, rekago númandu ririe, “Amó nímandu gaabee rere. Ambova uutu ifegota, God da anera mane enemboda Jojabee davareta, vorea vitia egeguturota gigigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Fefera ungagha seriguturia-da ambova, naa ragaro Kana, Galili Frovensi anava, yagera ari banau ueta, Iesu da nue banauva arie. Kotú Iesu unda ambo nimbide beago aghi jufirieta, aná banauva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aghade banau ueta, vaini sidara urieta, Iesu da nuemi undú eghá ririe, “Vaini sidara etue.” ");
INSERT INTO bjz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aghá ririeta, Iesu na mino ririe, “Aya, dodu andava rere? Anda fefera jo furá bubambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aghá riria-du, Iesu da nuemi buro kakatodu eghá ririe, “Unda daiyagha radua aghagonu egege!” ");
INSERT INTO bjz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jiusi enemboda agho dariva sei ingo seghea, undari undidigeta urie. Aghá-gea, uvu dimbari ovu singoi manemi uubu egegarinu dano, ingo yoveni-yoveniva dabako avo ititiguturieta vitirie. Ovu dabako aná 100 lita da inono re. ");
INSERT INTO bjz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aghá uria-du, Iesu na buro kakatodu eghá ririe, “Uvu tava ea bua fufuge, ená ovu jojabebeiva rurukadi, beda-beda egegoe!” Aghá ririeta, buro kakatomi uvu didimbugea bua furia, rurukuturieta, ovu mane beda-beda urie. ");
INSERT INTO bjz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Anada ambova, Iesu na eghá ririe, “Avoreta, rekago dimbua bua igige, banauda kofiri righari-du ututugadi!” Aghá ririeta, buro kakato unda riria aghagonu ea aria, banauda kofiri righaridava ututurieta, ");
INSERT INTO bjz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aná uvu kaverea vaini ninduturia-nu, aná banauda kofiri righari undia gerurie. Atá, vaini niavoreta furia, umó jo gambi re. Tago buro kakatomi gigiguturie. Aná banauda kofiri righari mana-mana urie-gea, aghi ituturieta aria, aná evetu yagera uria embó bua furieta, ");
INSERT INTO bjz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","undava uriga urie, “Enembo dano eghá egegeta rousue. Vaini taubananu ututugeaveta, esega enembo undia beforo biruru egegeaveta, vaini muno tefo ambova ututa rousue. Tago, imó ená vaini taubana righia vitara, ambova rei-ututoravore!” ");
INSERT INTO bjz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesu ená ivata anogha unda tutunova Kana naa Galili Frovensiva urieta siroruturie. Fefera aghade, unda ano duroghade iruguturieta, unda ambo nimbi gigigea gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Anada ambova, Iesu nuegha, unda ambobo vivide, kotú unda ambo nimbide vovoriguturie. Aria bubua, fefera dumeni númane avo Kafoniam naava desea vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Avo iririgutueta, Jiusi enemboda Serigea Yari Banauda fefera utua uria-du, Iesu erea, Jerusalem yavurie. ");
INSERT INTO bjz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aria bubua, God du Tafaroro Ari Kamboda* ghouka rova terua geruria mo, embobomi oka burumakaude, sifide, kotú dii uku mino-mino ututugea, guri bubugutueta gerurie. Anada kasava guri yayo ari kakato asusumbea buro egegutueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aghá gerurota, eri eininu bua anami sifide burumakaude kotú aná enembode dano dea tuviturieta, isaghava bububuguturie. Kotú guri yayo ari enemboda guri mane dea rifi-rafa urieta vovorueta, faro mane righia averegea tefo urie. ");
INSERT INTO bjz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dii mane utua guri reisi-rururia enembodu eghá ririe, “Nímanda dii mane bubugea isaghava bububuge! Nímane daiyagha aghá egegutueta, anda Afada Kambo guri utua bari kambesi aghago etu?” ");
INSERT INTO bjz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aghá ririeta, námane unda ambo nimbi gaga Buka Seiva gefirieta vitia-nu nundubuturera, aná evere: “Anona inda kambodu neno buta rora, aná eto-bato ivarimi anda neno rova evarigo eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aghá ririeta, Jiusi enembomi mino regeguturie, “Ivata anogha donu adi sirorota, námane gigigea, God na ano utueta, inda ari-bari etora-nu gaabee egega?” ");
INSERT INTO bjz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aghá regeguturieta, Iesu mino númandu eghá ririe, “Ená kambo dea bebejegadora, anona fefera bakodeda rova rekago righota eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Anada ambova, Jiusi enembomi eghá ririe, “Ená Tafaroro Kambo ghaeko 46 da rova egeguturie. Daiyagha inona fefera bakodeda rova righota eradu?” ");
INSERT INTO bjz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aghá ririe-tago, Iesu unda tamodu rirota, kambo gaa ririe. ");
INSERT INTO bjz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Anada ambova, umó amburarivareta erorurieta, unda daiyagha riria, unda ambo nimbi nundubuturie. Aghade God da Gaga sei riria-de, kotú Iesu da riria gagade dano gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Serigea Yari Banauda* feferava, umó Jerusalem irirota, ivata dumeni urieta siroruturieta, enembo oruaruabe gigigea, umó gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Aghá egeguturie-tago, Iesu jo númane gaabee ambi re. Anada bee mo, enemboda neno nundubari dano umó gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Númanda nundubari bemi regegota ningasua, o jo regegambi egegasua, aná avore. Anada bee mo, númanda neno rova nundubari daiyaghago egegeta uria, umó seibe gia tanana eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Moses da Gaga Kaifa kakatoda* einida ragaro Nikodemus, umó Jiusi enemboda beforo righari embó eini re. ");
INSERT INTO bjz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unona tumba eini aria, Iesu dava bubua eghá ririe. “Rabbi, námane reisi-gerore, God na ririeta, imó irugari kato ea fureravore. Avona undufa unda anomi jo inda rora ivata anogha, aghagonu ambi aita rouvie. God ingá dano irambi irasua, inda eta rora, jo sirorambi asue.” ");
INSERT INTO bjz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aghá ririeta, Iesu na mino undú eghá ririe, “Amó indú gaabee rere: avona jo rekago sirorambi adua, umó jo God da natofoda* rorova terua, God unda natofo kaifa aita rouvia kambesi gambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aghá ririeta, Nikodemus na ririe, “Imó daiyagha rere? Embó beemi rekago jo kaverea ya nueda uro rova sirorambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aghá ririeta, Iesu na mino ririe, “Amó indú gaabee rere. Avona umó uvumi kotú God da Asisi Kakarami rekago jo sirorambi adua, umó jo God da natofoda rorova terua, God unda natofo kaifa aita rouvia kambesi gambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Atá tamo eto, aná aya afaghami utuaveta buta rouvie. Tago, enemboda asisi God da asisimi utuaveta jebugeta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Atá, anda imó rekago sirorasiravore retora-du, rourogo imó mana-mana ara-degea rere. ");
INSERT INTO bjz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yauranu nundubea gigo! Yaura unda uno niavo yaita ariva iru-furu uaveta, eronu ningita roravore. Aghá-gea, umó niavo reiya o niavo reifia, imó jo gambi eta roravore. Gari dabako aghagonu, God da Asisi unda unomi iru-furu urota, reaveta enembo dumeni jebugeta rousue,” ");
INSERT INTO bjz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Aghá ririeta, Nikodemus na uriga urie, “Ená daiyagha ea siroradu?” ");
INSERT INTO bjz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ririeta, Iesu na eghá ririe, “Imó namonde amó Israel enemboda irugari kato jojabe eini re-tago daiyagha mana-mana ro? ");
INSERT INTO bjz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Amó indú gaabee rere. Námane eghá regegeta rosora mo, jo tefunu-tefunu regegambi eta rosore. Námane donu niningigea kotú gigiguturera, aná nuenembo nímandu regegeta rosore. Aghá regegeta rosore-tago, nímane jo námanda gaga bambi egegeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ená eini-eini oreki endava vitia-du reta rore-tago, imó jo gaabee ambi eta roravore. Aghá-gea, eini-eini donu uutuva vitia-da gaga rata ningadora mo, imó daiyagha ea gaabee ado? ");
INSERT INTO bjz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kotú eini-eini uutuva vitia, enembo eini avona jo yava gambi vitie. Avotago Enemboda Jojabee* uutuvareta vorea furie-gea, unona avo irirota gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kotú, Moses na uvu tefo, enembo irambi kambesiva ningabu ririkurieta eroruria aghagonu, Enemboda Jojabee aghá righota eraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Aghá ata-gea, enembo avona umó gaabee egegadua, jebuga tumanadu irari baita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anada bee mo, God umó enembo neno bua goghó urota, jebuga tumanadu irarinu bari-du rea, unda Mendi dabako bee dabako ututurieta furie. Unda furia-da bee mo, avona umó gaabee adua, jo ambua sidara ambi aita rouvie, jebuga tumanadu irarinu baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God jo unda Mendi endava enembo gia irurari-du rea, ninengota furambi re. Númane sonembota, jebuga bubugari-du rea ninenguturieta furie. ");
INSERT INTO bjz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Enembo avona God da Mendinu gaabee rousua, God jo númane gia irurambi re. Tago, avona God da Mendinu jo gaabee ambi rousua, God na númane gia irurea mema, utaita rouvie. Anada bee mo, God da Mendi dabako bee re-tago, númane jo gaabee ambi rousue. ");
INSERT INTO bjz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Atá, ená gia irureta rouvia-da bee evere. Unana endava enembodava furie-tago, enembo injigha egeguturie. Númane unana jo neno bambi, bingoinu neno bubugeta rousue. Anada bee mo, númanda ari-bari aná sembago-gea, unanava yari uno ambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Enembo avona ari-bari akokogo eta rousua, númane unana injigha eta rousue. Rourogo númanda ari-bari akokogonu gigigauve-degea, númane jo unanava yambi eta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Atá, enembo avona, gaa beeda aito fugari bee nuenembo urota irita rousua, unanava futa rousue. Anada bee mo, God da anomi númanda donu egegeta rousua-nu enembo oruabemi gigigari-du rea, unanava fufugeta rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anada ambova, Iesu unda ambo nimbide dano Judia Frovensi avo igiguturie. Fefera dumeni numonde anava iririguturota, Iesu na enembo bafutaito eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Aná frovensi dabako avo Jon Bafutaito ari kato beago, naa eini ragaro Ainon, avo bafutaito eta urie. Anada bee mo, avo uvu oruabe kotú, enembo oruabe fufugeta urie. Ená naa Ainon rera, umó naa eini ragaro Salim da kasava re. Jon Bafutaito ari kato jo dibura ambi irirota, enembo furuaveta, númane avo bafutaito eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aghá ueta, Jon da ambo nimbi dumenimi Jiusi embó einide besiga tutuno egeguturie. Numonde besiga egeguturia-da ruru mo, irugari eini tamode eini-einide seghari-da agho dari amindu rea, besiga tutuno egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aghá ea aria, Jon dava bubua, eghá ririe, “Irugari kato, Jordan uvu beina fefera vitari kenava embó eini furia ingá irieta, unda tamova gaga rirera rei-nundubutora? Oreki umó tutuno ea bafutaito ueta, enembo dano namonde amó dodogea undava reisi-igigutue.” ");
INSERT INTO bjz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aghá regeguturieta, Jon na mino eghá ririe, “God na embó avona buro eta rouvia-du ‘avore’ radua, ata bee siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aghá-gea, amó gaga daiyagha rieta niningiguturera, nenuka nu reisi-geroravore. God Embó eini ninengota furaita rouvia riria, jo amó irambi re. Anona aná Embóda emboro rerebari-du rea, God na ninenguturieta, furere. ");
INSERT INTO bjz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Atá, aná embó rera, umó eto-bato embó einimi evetu reka yagera aita rouvia aghago re. O amó mo, aná embó evetu yagera aita rouvia-da mambu, aghagonu kasava jiria irirota, unda mambu gaga reiria-da eronu niningurota, gangoro eta rore. Amó undú gangoromi rei-jaritore. ");
INSERT INTO bjz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Amindu, umó baria jojabe asueta, amó ijoko asire.” ");
INSERT INTO bjz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jon rekago eghá ririe, “Umó avona uutuvareta vorefuria, umó enembo nanjogoda itiva re. Atá avona endava siroradua, umó endada irarinu nundubuturota, anada gaga nuenembo rirota iraita rouvie. Kotú aná embó uutuva reta vorefuria, umó iti bee itiva re. ");
INSERT INTO bjz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Amindu rea, unda minonova, umó donu geruria kotú nininguria nuenembo reta rouvie. Tago, unda gaga enembo eini avona jo ningambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kotú, unda gaga enembo avona niningigea gaabee egegadua-mi rei-irugutue: gaa bee mokóda ruru, aná God unuka umó re. ");
INSERT INTO bjz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God da ninenguturieta furia embómi God da gaga nuenembo reta rouvie. Anada bee mo, God unda Asisida ano aná Embódava averegeaveta, vitia beda ea, eto dirigea voreta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afa God, unda Mendi neno rururota, eini-eini dano unda ingova ututurie. ");
INSERT INTO bjz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Amindu avona God da Mendi gaabee adua, umó aná jebuga tumanadu irari baita rouvie. Atá enembo avona unda Mendida gaga ningia gaabee ambi adua, jebuga tumanadu irari, umó jo bambi irirota, God da neno sembagonu tumanadu itatama urota iraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Enembo Iesu gaabee egeguturota, undava fufuguturia-de, unda yavero egegari-du rea, unda bafutaito uria, oruabe re. Jon da bafutaito uria, jo aghá bee irambi re. Aghá ueta, Moses da Gaga Kaifa kakato* niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Atá, gaa bee evere. Iesu undufa enembo eini jo bafutaito ambi re. Námane sei unda ambo nimbi egeguturera-mi bafutaito egegeta urere. ");
INSERT INTO bjz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu aná gaga niningurie-gea, umó erea, Judia Frovensi doa, Galili Frovensiva rekago arie. ");
INSERT INTO bjz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judia reta Galili yaita adora, imó sei ya frovensi eini ragaro Samaria bubua rekimbea yaita roravore. ");
INSERT INTO bjz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Amindu aria, Samaria Frovensi rekimbuturota, naa eini ragaro Saikar avo buburiturie. Saikar reta ya, námane Israel enemboda mambube Jekop na, unda mendi Josep du enda ututuria kambesiva bubari, jo airo bee irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kotú dabako avo, Jekop na uvu undaita rea koto ghafiria beago, avo vitirie. Námane reisi-furera fefera beforova 12 koroki ueta, avo bububuguturere. Aghade, Iesu rei-furia jariturie-gea koto kasava asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Iesu umó avo asumbea irieta, (námane unda ambo nimbi undari bubugaita rea, naava terua igiguturere.) Aghade, Samaria evetu einimi kofiri bua uvu dimbaita furie. Furieta, Iesu na eghá ririe, “Andú uvu dimbua bofu undore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aghá ririeta, aná evetumi ririe, “Ae, imó Jiusi embó re, amó Samaria evetu re. Námane, nímanda gitofo re. Agharanu, imó daiyagha uvu mo, anona dimbua utota undaita rere?” (Aná mo gaa bee re. Rourogo bebeta egegauve-degea, Jiusi enembo jo Samaria enemboda aaghade kotú kofiride dabakova undidigambi egegeta rousue.) ");
INSERT INTO bjz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aghá ririeta, Iesu na mino undú ririe, “Indava God donu utaita reiria, imó bee gia goghó asira, o avona indava uvudu benunu rouvia-nu gia goghó asira mo, undava benunu asueta, jebuga tumanadu irari-da uvunu utasue.” ");
INSERT INTO bjz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Aghá ririeta, aná evetumi mino eghá ririe, “Jojabee, indava ovu o eri tefo re, kotú ená koto kafuru re. Imó jebuga tumanadu irari rera-da uvu mo, doda bado? ");
INSERT INTO bjz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ená koto mo, namonde anda mambube Jekop na ghambea ututurie. Umó undufa uvu enava dimbua undita urie. Kotú unda sasingu vivedede, unda nino okade dano, uvu enava dimbua undidigeta urie. Aghá-gea, imó jebuga tumanadu irarida uvu bari gaa rera, imó mo daiyagha rirota rere? Inda rei-nundubutora mo, namonde anda mambube Jekop mo ijokoko, imó jojabe aghago rei-nundubutora, aĩ?” ");
INSERT INTO bjz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aghá ririeta, Iesu na mino undú ririe, “Ená uvu avona undadua, undava uvu uno rekago aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Atá, anda utaita rora uvu, avona undadua, umó jo rekago uvu unomi ukó takembambi aita rouvie. Anda utota undaita rouvia uvu, eto-bato enda tova uvumi feru-feru ea vitita rouvia aghagonu unda neno rova gau ea vitia, beda urota, jebuga tumanadu irari tambua baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ririeta, aná evetu eghá ririe, “Jojabee, avoreta, aná uvu rera-nu bofu! Aghá adora, amó rekago uvudu uno jo ata-gea, eve uvu dimbaita furambi aita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aghá ririeta, Iesu na eghá ririe, “Ii, inda embó bua furadi!” ");
INSERT INTO bjz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ririeta, aná evetu ririe, “Amó embó tefo re.” Aghá ririeta, Iesu na undú eghá ririe, “Imó ‘embó tefo’ retora, aná gaa bee retoravore. ");
INSERT INTO bjz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Imó embobo dano ingo yovenidava vai ea, dotutureravore. Aná embó oreki ingá vitarago doa etera, jo inda embó bee irambi re. Amindu, imó ‘embó tefo’ retora, aná gaa bee retoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aghá ririeta, aná evetumi ririe, “Jojabee, amó oreki reta rei-gerore. Imó feroveta eini re. ");
INSERT INTO bjz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Námane Samaria enemboda abua maneda daiyagha regegeta uria, evere. ‘Oná ooto jiria irieta, rei-gerora, anava God du tumogha baĩ egegasire.’ aghá re-tago, nímane Jiusi enemboda rari mo, God du tumogha baĩ ari kambesi bee mo, Jerusalem re!” ");
INSERT INTO bjz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aghá ririeta, Iesu na eghá ririe, “Ená anda gaga rera-nu, ‘Gaabee adi!’ rere. Ambova fefera furá bubadua mo, enembo jo oná ooto jiria vitia-va o Jerusalem avo God du tumogha baĩ egegambi aita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nímane Samaria enembo avonu gaabee egegeta rosora, jo gia tanana ea goghó egegambi eta rosoravore. O námane Jiusi enembo avonu gaabee egegeta rosora, námane tanana rosore. Anada bee mo, God da sonembari enembodava aná Jiusi enemboda rorova siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tago, fefera oreki amirifogo furá bubaita rouvia, aghago re. Fefera aghade, gaabee ari kakato jo tumogha baĩ ari kambesidu nundubambi egegaita rousue. Afa God tumogha baĩ ea goghó egegeta rousua enembo God da Asisida sonembami aito dambu fugiturota, undú tumogha baĩ egegaita rousue. Afa God enembo aghago manemi undú tumogha baĩ egegari-du uno eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God, umó asisi re. Aghá-gea, God da Asisida sonembami enembo aito dambu fugiturota, God tumogha baĩ egegasue!” ");
INSERT INTO bjz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Aghá ririeta, aná evetumi undú eghá ririe, “Amó rei-gerore, embó eini God da ninengota furari-du riria (Unda ragaro Keriso regegeta rousue.), umó ambova furadua mo, gaa dano ruruva isuri ata niningigaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aghá ririeta, Iesu na undú eghá ririe, “Embó avona indú gaga reiria, aná umó re.” ");
INSERT INTO bjz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ungá aghá regegutueta, námane kaverea furera, Iesu aná evetugha tafirere. Umó aná evetugha gaga rieta tambua, námane mana-mana egeguturere-tago, “Imó dodu uno ro?” kotú “Imó dodu aná evetugha gaga rere?” aghago jo uriga egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aghá uria-da ambova, aná evetu unda uvu dimbari ovu avo doa kaverea sumbua aria, naava bubua, natofodu eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Embó einimi etia, anda ari-bari daiyagha-daiyagha uta furera, unona dano retueta ningere. Fu ya, gigigadi, embó eini God da ninengaita riria mo, umó ra?” ");
INSERT INTO bjz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aghá ririeta, númane erea, Iesu gigigaita rea fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iesu gigigaita rea, fufugutueta, námane Iesu du eghá regeguturere. “Irugari kato, undari bua undia jebuge!” ");
INSERT INTO bjz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aghá regeguturere-tago, umó eghá ririe, “Anda undari dibe eini vitia, aná nímane jo gambi egegeta rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aghá riria-du, námane mino-mino eghá rea niningiguturere, “Aghajora undari seibe utueta, undia vitia-jogo.” ");
INSERT INTO bjz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aghá ririeta, Iesu námandu ririe, “Anda undari aná evere. God amó ninenguturieta furera, unda unonu urota iraita rore. Kotú buro donu ari-du riria-nu, ata sidara aita rouvie. Anda undari aná avore. ");
INSERT INTO bjz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nímane reisi-nundubutoravore, marabe ungagha-ungagha sidara ata, anada ambova, undari bee mane barida fefera furá bubaita rouvie. Aghá re-tago, amó nímandu rere: aayo gia irurea goghó egege! Undari bee barida fefera enanu etia bubieta, enembo aghi jumbarida fefera oreki evere. ");
INSERT INTO bjz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Undari avona badua mo, umó buro eta rouvie-gea, anada mino baita rouvie. Gari dabako aghagonu, avona ya, enembo God da natofo ea jebuga tumanadu irarinu tambua bari-du rea, aghi eta rouvia, umó aná buro eta rouvia-da mino baita rouvie. Kotú dabako aghagonu, aayova undari bee eaveta gia, aayo govari katogha kotú bari kato, ungá gangoro eta rouvie. Aghagonu, enembo eini sei iiava minono reaveta, kotú enembo ambova iiava enembo aghi eaveta, God gaabee egegeta rousua-du, ungá danode gangoro egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Namonde amó eghá regegeta rosore, ‘Embó einimi ya aayo govota, anada ambova, embó einimi ya undari baita rouvie.’ Aná mo, gaa bee re. ");
INSERT INTO bjz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gari dabako aghagonu, enembo dumeni, númane seibe aria, aayova buro egeguturie. Atá, nímane anona ninengetueta ambova era, enembo sei aria, buro fakara egeguturieta, bee siroruturia-nu, nímanena reisi-ruroravore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aghade, aná Samaria evetu retora-mi Iesu undú daiyagha riria-nu isagha urie, “Embó einimi etia, anda ari-bari daiyagha-daiyagha uta furera, unona dano retueta ningere.” Iesu da bingá unona aghá ririeta, Samaria naava enembo dano niningigea, númane Iesu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Númane niningigea, gaabee egeguturie-gea, aria, Iesu dava bubua, umó nemonde fefera tufoko evo eini ea doa, yari-du benunu egeguturie. Aghá regeguturia-du, námane Iesu de dano avo fefera ungagha egeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aghá egegutueta, unda gaga riria-nu niningiguturota, enembo oruaruabe tutuno ea, Iesu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Gaabee egeguturota, aná evetudu eghá regeguturie, “Námane oreki umó gaabee rosora, aná jo inda gaga retora-du gaabee egegambire. Tago Iesu gaga rieta, námane anuka niningigea, gaabee egegetore. Embó eini namonde anda ari bari akokogo seseghurota sonembari-du God da utaita riria, aná umó re.” ");
INSERT INTO bjz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Aná naava irieta, onembo ungagha sidara urieta, námane Iesu de dano aná naa vareta Galili Frovensi igiguturere. ");
INSERT INTO bjz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sei Iesu undufa eghá ririe, “Ferovetada gaga enembo dano niningiguturota, umó kakara eta rousue. Aghá re-tago, ferovetada enembo totofo jo umó gaabee egeguturota, umó kakara ambi eta rousue.” Iesu undufa aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Umó aria, Galili Frovensiva teterueta, natofomi umó gigiguturie-gea, “Orokaiva!” regeguturota, ghanena egeguturie. Anada bee mo, Serigea Yari Banauda* feferava, númane beago avo Jerusalem iririguturota, Iesu da daiyagha uria númane gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Avore, Iesu rekago aria, naa Kana Galili Frovensi avo buburiturie. (Sei Kana naa anava unona ririeta, uvu kaverea, vaini ninduturie.) Gavana eini naa dabako avo irita uria-da mendimi kae bua, naa eini ragaro Kaperneam avo vasia vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judia Frovensi reta Iesu rekago kaverea aria, Galili Frovensiva buburituria-da bingá niningurie-gea, gavana erea aria, Iesu dava bubua, ininigha benunu urie, “Anda mendi kae akuago bua, Kaperneam avo vasia amburaita itoko rouvie. Amindu, imó fu, angá ya anda mendi gia radi jebugoe!” ");
INSERT INTO bjz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aghá ririeta, Iesu undú eghá ririe, “Amó ivata anogha dumeni-dumeni ata gigigambi adora, nímane jo amó gaabee egegambi aita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aghá ririeta, aná embómi rekago eghá ririe, “Jojabee, rourogo anda mendi amburauve-degea rereta! Fu, angá tutomi yare!” ");
INSERT INTO bjz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aghá ririeta, Iesu na mino undú eghá ririe, “Avoreta, ii! Inda mendi jo amburambi aita rouvie.” Aghá ririeta, aná embó umó Iesu da gaganu gaabee urie-gea, kaverea arie. ");
INSERT INTO bjz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","52","Kaverea, naava irueta rifo atiturieta, unda sabua* dumenimi furia, umó rorova tambua, “Inda mendi jebugetue,” regeguturie. Aghá regeguturia-du, aná embómi uriga urie, “Nanjigo tutuno ea jebugetu?” ririeta, númane regeguturie, “Tumbó, fefera 1 koroki ueta, unda tamo vevera sidara uta.” ");
INSERT INTO bjz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aghá regeguturieta, aná mendida numamo fefera donu ueta, Iesu undú gaga eghá riria-nu nundubuturie, “Inda mendi jo amburambi, jebugaita rouvie,” riria feferava unda mendi jebuguturie. Amindu rea, umó unda buro kakatode unda evetu sasingu manede dano Iesu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Avore, Iesu buro tutuno ea uta furia Judia Frovensi vareta kaverea Galili Frovensi aria-va, ivata anogha ungagha urieta siroruturie. Ivata anogha tutunova, uvu ririeta kaverea vaini ninditurie. Anada ambova ririeta, gavanada mendi jebuguturia-mi, ungagha urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aghá uria-da ambova, Jiusi enemboda banau eini aita uua-du rea, Iesu Jerusalem arie. ");
INSERT INTO bjz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem avo kara eini singoimi ga ovenembuturieta, irita urie. Aná ghoukada bebato eini, Sifi da Bebato regegeta urie. Jo airo irambi, uvu aghoghombari eini ragaro Betsata kasava irita urie. Aná uvu aghoghombarida kasava saa dano ingo yoveni urieta irita urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Fefera aghade, kae akokogo bubugea irari enembo aná saa maneva avo, vavasigea iririgutueta Iesu buburiturie. Enembo dibe soikide, eka ingo tatakembaride, eka ingo ambubugaride manemi aná uvu aghoghombarida betuva, saava vavasigea iririgeta urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Embó einida kae bua vitiria ghaeko 38 re. Umógha dano avo vasia vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu aná embó gerurota, umó kae bua fefera yafabe vasia irita uria-nu, tanana urie-gea, undú uriga urie, “Imó jebugari uno rora, aĩ, tefo?” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Aghá ririeta, aná embómi eghá ririe, “Jojabee, uvu yavi ea biruru uaveta gita rore-tago, avona jo sonembea furá, amó bua itota vorambi eta rore. Amindu, uvu yavi uaveta giave-gea, amó yavi urari, enembo einimi iiava amó serigea, sei voreta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aghá ririeta ningia, Iesu undú eghá ririe, “Avoreta, erea inda ghaito borea bua ii!” ");
INSERT INTO bjz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aghá riria, jo gaimbo ambi, aná embó jebugea erea, unda ghaito borea bua arie. Ená ivata anogha Nangu Undari Feferava siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aná embó jebugea erea, unda ghaito borea bua irueta, Jiusi enemboda babarigarimi gigiguturie-gea, regeguturie, “Imó jo ghaito borea bua yambi asiravore. Anada bee mo, oreki Nangu Undarida Fefera re. Aghá rora, imó namonde anda agho dari rei-bejutoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aghá regeguturieta, aná embó mino ririe, “Amó retueta jebugetora embómi, ‘Erea, inda ghaito bua ii!’ retua-du aghagonu rore.” ");
INSERT INTO bjz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aghá ririeta, númane uriga egeguturie, “Imó erea inda ghaito borea bua yari-du retua embó mo, avouro?” ");
INSERT INTO bjz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Aghá regeguturie-tago, avona urieta umó jebuguturia, embó jo tanana ambi re. Anada bee mo, enembo oruaruabe avo iririgutua-da rova, Iesu aná ivata anogha ea doa, enembodava dinunu urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Anada ambova, God du Tafaroro Ari Kamboda* rova, Iesu aná embó tambua, undú ririe, “Imó jebugea viteravore. Rekago imó kae akuago beenu bara-degea, inda ari-bari akokogo vuregea doadi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aghá ririeta, aná embó ningia aria, Jiusi enemboda babarigari God du Tafaroro Ari Kambova tambua eghá ririe, “Amó etueta jebugetora embó, aná Iesu re,” ririeta, númane niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nangu Undari Feferava, Iesu ririeta, aná embó jebuguturia-du, undava fakarago egeguturota, eaveta mema dumeni itatama eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Aghá egegutua-du, Iesu númandu eghá ririe, “Anda Afa fefera inono buro eta rouvia aghagonu, amó beago buro eta rore.” ");
INSERT INTO bjz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aghá ririeta, Jiusi enemboda babarigari niningiguturie-gea, Iesu data amburari-du egeguturie. Anada bee mo, Nangu Undari Feferava, umó buro urota, Agho Dari bejuturie. Aná mo ijoko re. O ambova, umó God unda Afa tofo gaa rirota, kotú umó beago God gha dano inono gaa riria-nu, jojabe urie. ");
INSERT INTO bjz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Amindu rea, Iesu númandu eghá ririe, “Amó nímandu gaa bee rere. God da Mendi eini-eini donu jo unuka unda ragarova ambi eta rouvie. Numamoda urari-nu gerurota, umó beago aghago nuenembo eta rouvie. God Afa daiyagha uaveta gari mo, unda Mendi beago ivata anogha dabako aghago nuenembo eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Anada bee mo, Afa God unda Mendi neno rururota, umó daiyagha eta rouvia, nuenembo unda Mendi dava irugeta rouvie. Avotago, ivata anogha donu oreki reisi-gerora, aná mo ijokoko re. Nímane gigigea duduku-dadaka egegari-du rea, God ambova eini-eini jojabenu unda Mendi dava irugota-gea, ata siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afa God da eaveta, enembo amburariva reta jejebugea ereregeta rousua aghagonu, unda Mendimi rata-gea, enembo avonu umó uno adua, númane jebuga bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Aghá-gea, Afa God undufa enemboda ari akokogo jo irurambi eta rouvie. Unda Mendi eto-bato umongo ananu kakara ari-du rea, enembo irurarida buro, God unda Mendidu ututurie. Avona God da Mendi jo kakara ambi eta rouvia, umó Afa God beago, jo kakara ambi eta rouvie. Anada bee mo, God unda Mendinu unda ragarova ninenguturieta furie. ");
INSERT INTO bjz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Amó nímandu gaa bee rere. Avona anda gaga niningurota, God avona amó ninenguturieta furera-nu gaabee eta rousua enembomi, jebuga tumanadu irarinu seibe tambua bubugea vitie. Jo númanda ari akokodu rekago irurambi aita rouvie, númane seibe amburariva reta jejebugea erorurie. ");
INSERT INTO bjz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Amó gaa bee rere. Fefera furá bubadua o etia bubia aghade, amburari enembomi God da Mendi bemi rirota, unda beda ero avona niningigadua-mi jebuga baita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afa God umó aná jebugada ruru re. Aghá-gea, unona rieta, unda Mendi beago, umó jebugada ruru ea irita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","God da Mendi umó Enemboda Jojabee* re. Amindu rea, God na ririeta, unona enemboda ari-bari akokogo irurarida ano righia vitie. ");
INSERT INTO bjz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ená gaga retora-nu niningigea, rourogo mana-mana egegareta! Fefera eini furá bubaita rouvia aghade, amburari enembo dano unda be rirota niningiguturota, ");
INSERT INTO bjz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","númanda ujevareta jejebugea ereregaita rousue. Enembo dumeni ari-bari taubana, dinunu tefo egegeta uria-mi, jebuga tumanadu irari tambua baita rousue. O enembo dumeni ari-bari akokogo egegeta uria-mi, ereregea númanda ari-bari akokogoda bouvunu baita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aghá rirota, Iesu eghá ririe, “Eini-eini donu anona tofo anda ragarova ata sirorari-du rea asira mo, jo inono ambi asue. Aghá re-tago, God unona reaveta ningia, anona enemboda arinu irureta rore. Amindu enemboda ari-bari inonova irureta rore. Anada bee mo, amó jo anda unonu ambi eta rore, avona amó ninenguturieta furera-da unonu eta rore. ");
INSERT INTO bjz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Amonu gaabee egegadi rea, andufa anda gaga osagho fumbasira mo, jo inono ambi asue. ");
INSERT INTO bjz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Avotago, God, anda gaga osagho fumbuta rouvie. Kotú, unda reiria gaga aná gaa bee re. Aghá tanana rore. ");
INSERT INTO bjz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nímanda aghi enembo ninengutata angia, Jon dava buburitata, umó andú rirota, gaa bee rita. ");
INSERT INTO bjz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gaa bee, Jon andú gaga taubana rita-tago, enembo eini anda gagada osagho fumbadua o fumbambi adua mo, aná avore. Tago anda uno mo, nímane Jon da gaganu niningigea, amonu gaabee egegea, jebuga bubugadi rere. ");
INSERT INTO bjz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon, umó nanefa inimbeaveta unana janimbeta rouvia, aghago re. Amindu nímane fefera tufoko iiava undava unana gigigea, gangoro egegeta ureravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Atá Jon na, anda gagada osagho fumbuta urie. Avotago, anda gagada osagho fumbari kato jojabe eini vitie. Ivata anogha kotú ari-bari donu ari-du rea, anda Afa na irugeaveta, anona eaveta siroreaveta, nímane gita rosora-mi rei-irugutue: gaa bee Afa God na amó ninenguturieta furere. ");
INSERT INTO bjz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Afa God amó ninenguturia, umó beago anda gaga sonembeta rouvie. Tago, nímane unda be jo niningigambi kotú, unda dibe be jo gigigambi viteravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Unda gaga nímanda neno rova tefo re. Anada bee mo, unona ninenguturieta amó furere-tago, nímane jo amó gaabee egegambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nímane, God da Gaga rova jebuga tambari gaa regeguturota viteravore. Tago, gaa bee aná evere. God da Gaga aná, andú reirie. ");
INSERT INTO bjz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Avotago, nímane andú injigha egeguturota, andava furá, jebuga bari uno ambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nímanena andú raga regegari-du, amó jo uno ambi re. ");
INSERT INTO bjz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Avotago, nímanda neno roo amó rei-gerore. Nímane jo neno roomi, God neno bambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Avona undufa unda ragarova furari mo, nímane umonu gaabee egeguturota, undú ‘Orokaiva’ regegeta rosoravore. Atá, amó Afada ragarova furere-tago, nímane jo amó gaabee egeguturota, andú ‘Orokaiva’ regegambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Amó seibe rei-gerore. Nímane jo tutumi amó gaabee egegambi aita rosora-da bee mo, nímane mino-mino raga regeguturota, daiyagha ata-gea, God nímandu raga rari jo ea gambi eta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Atá, anona Afada dibeva nímane itia bera-bera aita rora-nu mania nundubata! Nímane Moses da Gaganu gaabee egeguturota, aghá regegeta rosoravore-tago, Moses undufa erea, God Afada dibeva, nímane itia bera-bera aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Anada bee mo, Moses andú rirota, unda gaga gefirie. Nímane Moses nu gaabee egeguturota mo, amó beago gaabee egegasiravore. ");
INSERT INTO bjz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Avotago, unda gefiria gaga, nímane jo gaabee egegambi eta rosoravore. Amindu, anda gaga beago nímane jo gaabee egegambi eta rosoravore,” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aghá uria-da ambova, Iesu erea, sao jojabe ragaro Galili, kotú Taibirias regegeta uria-nu, rekimbea arie. ");
INSERT INTO bjz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Aria buburiturieta gigiguturie-gea, natofo oruaruabe ereregea, unda ambova igiguturie. Aghá egeguturia-da bee mo, Iesu na ivata anogha dumeni eaveta, enembo kae akokogo bubugea iririgari mane, jejebugeaveta gigigeta urie. ");
INSERT INTO bjz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aghade, Iesu na námane unda ambo nimbi bua yavuria, ootova asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Fefera aghade, Jiusi enemboda banau ragaro Serigea Yari Banauda* fefera furia utuva urie. ");
INSERT INTO bjz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu kaveruturia mo, enembo natofo oruaruabe undava fufugutueta gerurie-gea, Filip du eghá ririe, “Enembo natofo eghago mo, namonde farava doda bua utota undidigadu?” ");
INSERT INTO bjz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Umó aghá riria-da bee mo, umó daiyagha aita rouvia, seibe neno roomi nundubuturota, Filip kuvia gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Uriga ririeta, Filip na undú eghá ririe, “Natofo oruabe-gea, námane ya marabe 8 buro ea barida inono gurimi* farava bua furá utota undidigadua, anami jo inono egegambi aita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aghá ririeta, námanda eini, Saimon Pita da ikoko, Andru na eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Mendi eini enanu jiria vitie. Unona farava ingari ingo yoveni kotú uvu oka ungagha bua etie-tago, natofo eghagomi daiyagha undidigota inono adu?” ");
INSERT INTO bjz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aghá ririeta, Iesu na námandu ririe, “Avoreta, regege, natofo asusumboe!” (Anava kambesi beragha bee kirisa isagha re.) Avo asusumbuturia embobo dano 5,000 re. Evevetu sasingu manede jo irugambi re. ");
INSERT INTO bjz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Asusumbuturieta, Iesu na farava ingari bua, God du “Aiye,” rea, enembodu vesa urieta bubuguturie. Oka bua, ari dabako aghago ea, vesa urieta undidigea, inono egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aghá egeguturieta, námane unda ambo nimbidu eghá ririe, “Undidigea dodogetua-da itoto simbugea, danode ititige! Mania siosa egegata!” ");
INSERT INTO bjz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iesu na aghá ririeta, aná farava ingo yoveni undidigea, itoto dodoguturia-nu simbugea, kanda dano 12 fefendurieta beda egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Enembo natofo oruaruabe avo bububugea desuturia-mi, Iesu da ivata anogha donu uria-nu gigigea, eghá regeguturie, “Feroveta jojabe ambova sirorari gaa regegeta rousua, aná evere!” ");
INSERT INTO bjz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aghade Iesu, umó seibe gerurie: natofomi furá umó righia jiria, unona kini ari-du ininigha rea, bera-bera egegasue. Amindu umó erea, natofo avo doa, ootova yavurie. ");
INSERT INTO bjz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jama urieta, námane unda ambo nimbi kaverea vorarera, ");
INSERT INTO bjz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ghaava* vorea siregea, saova rekimbea, beina Kaperneam naa kenava irueta, tumba ririturie. Aghade, Iesu jo furá námandava bubambi re. ");
INSERT INTO bjz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aghá uua-da rova, yaura ininibe sufirota, yavata erorurie. ");
INSERT INTO bjz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yaura yavata sufieta, námane davea, 7 kilomita aghagonu arera, rorova buburitueta, Iesu vorea, uvu etova deĩ ea, námanda ghaa kena furueta gigigea, oru egeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Námane aghá egegutua-du, Iesu na eghá ririe, “Amó reta! Mania oru egegata!” ");
INSERT INTO bjz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aghá ririeta, námane niningigea, neno gangorogha umó fendia, jo gaimbo ambi, námane fafo doda reisi-arera-va, ghaa seibe sumbua terua avo katana urie. ");
INSERT INTO bjz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Aghá egegutueta, rifo atiturieta, enembo yoveniva vitiria-mi dibe fugia, ghaa dabako irieta gigigea, Iesu aná ghaava jo vorea rekimbambi doa jirota, námane unda ambo nimbimi enembo rekimbea yari gaa regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aghá regegutueta, ghaa dumeni kambesi Taiberias reta furia teterugea, Jojabeeda ivata anogha urota, benunu urieta, undari diguturieta, natofo undidiguturia kambesi kasava terua, katana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aghá egeguturie-tago, Iesu námane unda ambo nimbide avo jo gigigambi egeguturie-gea, rekago ghaava vovoregea, Kafoniam naava Iesu tava egeguta igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Númane rekimbea aria, Iesu avo tatambuguturie-gea, uriga egeguturie, “Irugari kato, imó nanjigo etera eve bube?” ");
INSERT INTO bjz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aghá regeguturieta, Iesu mino eghá ririe, “Amó nímandu gaa bee rere! Nímane andú tava rosora-da bee mo, jo anda ivata anogha dumeni dumeni eaveta gigigeta rosora-nu nundubuturota, amó tava egegambi rosoravore. Tago, undari anona simbugutata undidigea inono egegutara-nu nundubuturota, amó tava rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tamoda undari undota, sidara aita rouvia-du, mania buro egeguturota, tava egegata! Afa God Enemboda Jojabee* neno rururota, aghá gigigadi rea, unda anomi ivata andava utuaveta, eaveta gigigeta rosoravore. Amindu rea, jebugada undari anda nimandu utaita rora-mi, jebuga tumanadu irari tambua baita rosoravore. Jebugada undari dabako enadu tava egeguturota, buro urota iririge!” ");
INSERT INTO bjz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aghá ririeta, númane uriga eghá egeguturie, “Námane God da buro egegaita asira mo, daiyagha tutuno egega?” ");
INSERT INTO bjz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aghá regeguturieta, Iesu na eghá ririe, “Buro donu nímanda ari-du God uno eta rouvia, aná evere. Avonu God da ninenguturieta furia, umonu gaabee egege!” ");
INSERT INTO bjz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aghá ririeta niningigea, númane mino Iesu du eghá regeguturie, “Imó ivata anogha donu adi námane gigigea, imó gaabee egega? Imó daiyagha ado? ");
INSERT INTO bjz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Moses da feferava, namonde anda mambube mane uvu tefo, kotú enembo irambi kambesiva, avo God da ututuria undari mena nu, bubugea undidigeta uria-du, God da Gaga eghá reirie, ‘Unona undari uutuva reta utuaveta voreaveta, númane bua undidigeta egeguturie.’” ");
INSERT INTO bjz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aghá regeguturieta, Iesu ririe, “Amó nímandu gaa bee rere. Moses na reaveta, undari vorefuaveta, nimambube mane undidigeta uria mo, jo uutuda undari bee irambi re. Uutuda undari bee, anda Afa na ututa rouvia re. ");
INSERT INTO bjz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Undari bee God da ututa rouvia, aná amó re. God na amonu ninenguturieta uutuvareta furera-mi, enembodu jebuga ututa rore.” ");
INSERT INTO bjz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aghá ririeta, númane undava benunu egeguturie, “Jojabee, aná undari rera-nu, fefera inono námandu bofu!” ");
INSERT INTO bjz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aghá regeguturieta, Iesu eghá ririe, “Jebugada undari, aná amó re. Avona andava furadua, umó jo rekago baimana itatama ambi aita rouvie, kotú avona amó gaabee adua, jo uvu uno ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Anda donu ritara, oreki rei-sirorutue. Nímanda dibemi amó reisi-geroravore-tago, anda gaga nímane jo gaabee egegambi rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Afa, avonu andava utadua, umonu bua, tavo aita rore. Afa avonu andava utadua, númane andava furaita rousue. Enembo avona andava furadua, amó jo umó tuvambi aita rore. ");
INSERT INTO bjz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Anada bee mo, amó jo anda unonu aita rea, uutuva reta vorefurambi re. God unda uno nuenembo ari-du rea, ninenguturieta amó vorefurere. ");
INSERT INTO bjz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Afada uno evere. Andú ututuria enembo eini, jo doata baghimbambi aita rouvie. Kotú fefera ambova, anona númane dano amburari vareta jebugea, ereregari-du raita rore. ");
INSERT INTO bjz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Anada bee mo, Afada uno rouvia mo, avona unda Mendi gigiguturota, gaabee egegadua, númane jebuga tumanadu irari tambua bubugota, fefera ambova, anona númane righota ereregaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iesu na númandu eghá ririe, “Undari uutuva reta vorefuria, aná amó re,” ririeta niningigea, Jiusi enembo tutuno ea, mema egeguturota, yoove-gaje regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Aghá egeguturota, regeguturie, “Ená embó Iesu, umó Josep da mendi re. Unda nue numamogha namonde amó gari re. Agharanu, umó uutuva reta vorefurari gaa reiria mo, umó daiyagha nundubuturota reiri?” ");
INSERT INTO bjz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Aghá regegutua-du, Iesu na númandu eghá ririe, “Mania yoove-gaje regeguturota, mino-mino uriga egegata! ");
INSERT INTO bjz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Enembo einimi undufa jo andava furambi aita rouvie. Afa God amó ninenguturieta furera, unona enembo avonu unumbota, andava fufugadua-nu, fefera ambova anona rata, amburari vareta ereregea, jebuga tumanadu irari tambua bubugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aghá rea doa, eghá ririe, “God na ririeta, unda ferovetada gefiria gaga eini, aná evere: ‘God na enembo dano nghaĩ itaita rouvie.’ Amindu rea, Afa God da gaga enembo avona niningurota, unda irugarinu gaabee egegadua mo, andava fufugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‘God da gaga ningari enembo’ retora mo, númane jo númanda dibemi God gigigambi re. Anada bee mo, avona jo God dibemi gambi eta rouvie. Aná embó, Afada ninenguturieta furia-mi unuka God dibemi gerurie. Aná amó re. ");
INSERT INTO bjz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Amó nímandu gaa bee rere. Avona amó gaabee adua mo, umó seibe jebuga tumanadu irari tambua vitie. ");
INSERT INTO bjz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jebugada undari, aná amó re. ");
INSERT INTO bjz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nímanda mambube mane uvu tefo, kotú enembo irambi kambesiva mena nu undidiguturie-tago, númane ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Avotago, ená undari uutuva reta, God da ututurieta vorefuria-nu, avona bua undadua, umó jo amburambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Atá, jebugada undari uutuva reta vorefurari gaa retora, aná andufa anda tamodu retore. Ená undari avona undadua, jebuga tumanadu irari tambua baita rouvie. Undari enembodu utari gaa rera aná, anda tamodu rere. Enembo jebugari-du rea, anda tamonu utaita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aghá ririeta niningigea, Jiusi enembo neno akokogo egeguturota, mino-mino besiga egeguturie, “Unda tamonu utota undidigari-du reiria mo, daiyagha utadu?” ");
INSERT INTO bjz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aghá regeguturieta, Iesu númandu eghá ririe, “Amó nímandu gaa bee rere. Nímane Enemboda Jojabeeda tamode tatangude jo bua undidigambi adora, nímane jo jebuga tumanadu irari tambua bubugambi aita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Atá, enembo avona anda tamode tatangude undidigadua, númane jebuga tumanadu irari aná tatambugota, fefera ambova anona rata-gea, númane amburari vareta jejebugea ereregaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Anada bee mo, anda tamo aná undari bee re, kotú anda tatangu, aná uvu bee re. ");
INSERT INTO bjz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Avona anda tamode tatangude bua undidigadua, númane amonde takembea iririguturota, amó beago numonde takembea iraita rore. ");
INSERT INTO bjz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Afa God jebuga, vitia unona ninenguturieta, amó furere. Unda jebugada anomi amó beago jebuga vitere. Gari dabako aghagonu, avona anda tamo bua undidigadua mo, anda jebugada anomi, númane jebuga tambua bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Undari uutuva reta vorefuria-da ruru, aná evere. Undari nimambube maneda dirota vitiriago ambubuguturia undari jo anda tamode tatangude aghago irambi re. Amindu enembo avona anda tamode tatangude bua undidigadua, númane jebuga tumanadu irari tambua bubugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu na aná gaganu naa ragaro Kaperneam avo irirota, nghaĩ itari kambova* enembodu iruguturie. ");
INSERT INTO bjz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu da yavero dumenimi ená gaga niningigea, eghá regeguturie, “Ená gaga fakarabe, avona badu?” ");
INSERT INTO bjz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu da yavero dumeni unda gaga riria-du yove gaje regegutueta, umó gerurie-gea, númandu eghá ririe, “Ená gagadu nímane injigha rosora? ");
INSERT INTO bjz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Enemboda Jojabee* nímane doa kaverea, uutuva yavurota gigigadora mo, nímane daiyagha nundubado? ");
INSERT INTO bjz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nímane reisi-geroravore, jebuga aná, God da Asisi Kakarami ututa rouvie, jo enemboda irugarimi ata sirorari inono irambi re. Anda gaga retora-mi, sonembetueta, nímane jebuga ututa rouvia-da Asisi bubugetoravore. ");
INSERT INTO bjz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tago, nímane dumeni jo amó gaabee egegambi rosoravore.” (Aghá riria-da bee mo, avona umó gaabee egegambi aita rousua-de, kotú umó dubo aita rouvia embóde dano umó seibe gerurie.) ");
INSERT INTO bjz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Amindu, umó eghá ririe, “Ená gaganu seibe retore, ‘Avona tefo andava jo furambi aita rouvie. Afa God na enembo unumbota-gea, andava furaita rousue. Avonu jo sonembambi adua, jo andava fufugambi aita rousue.’” ");
INSERT INTO bjz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ená gaga riria-du, unda yavero oruabe umó dodogea, jo rekago numonde danode iru-furu egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aghá-gea, Iesu námane unda ambo nimbi 12 du uriga urie, “Nímanda dumeni amó doa igigetue. Nímane beago aghá egegadora, aĩ? Nundubea gigige!” ");
INSERT INTO bjz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Aghá riria-du, Saimon Pita gaga mino eghá ririe, “Jojabee, námane imó doadora mo, avodava ya? Jebuga barida gaga inuka indava re. ");
INSERT INTO bjz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Oreki námane tanana urota, gaabee rosore, God da utaita riria Embó kakara bee, aná imó re.” ");
INSERT INTO bjz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aghá ririeta, Iesu námandu eghá ririe, “Nímane anda ambo nimbi 12 anona simbuguturere. Avotago, nímanda eini, umó aná Satan da tofo bee re.” ");
INSERT INTO bjz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesu aghá riria-da bee mo, umó Keriot embó Saimon da mendi, ragaro Judas du ririe. Aná embó umó námane ambo nimbi 12 da eini re. Aghá re-tago, unona Iesu dubo urie. ");
INSERT INTO bjz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Anada ambova, Iesu umó Judia Frovensi va yari jo uno ambi re. Anada bee mo, Jiusi enembo anavami umó data amburari-du nundubeta egeguturie. Amindu umó Galili Frovensi va iru-furu eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aghá ueta, Jiusi enemboda banau ragaro, “Bogha Itarida Banauda” fefera furia buburiturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Amindu, Iesu da ambobo vivide furia, undú eghá regeguturie, “Imó ená kambesi doa ii! Judia Frovensi anava ivata anogha dumeni uradi-gea, inda yavero avo desea vitia, inda ivata donu aita rora-nu gigigoe! ");
INSERT INTO bjz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Avona embó jojabe aita nundubadua, unda buro jo nungia ambi aita rouvie. Amindu rea, inda ivata anogha dumeni eta rora-nu enemboda dibeva uradi-gea, imó gigigoe!” ");
INSERT INTO bjz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aghá regeguturia-da bee mo, unda ambobo vivide uro dabakova beago númanda kaka Iesu jo gaabee egegambi urie. ");
INSERT INTO bjz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aghá regeguturieta, Iesu númandu eghá ririe, “Anda fefera jo furá bubambi vitie. Atá, nímane mo, fefera inono igigadora, aná avore. ");
INSERT INTO bjz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nímane enemboda eta rousua aghagonu eta rosora-du, nímane jo injigha egegambi aita rousue. Atá amó mo, enemboda ari akokogodu rirota, enembo dibe beva reta rora-du, amó injigha egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anda fefera jo furambi vitia-du, amó jo yambi aita rore. Amindu, nímane nenukako, igige, banau egegadi!” ");
INSERT INTO bjz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aghá rea doa, umó Galili vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu jo isaghava yambi re. Umó kaifa ueta, unda ambobo vivide igiguturieta, umó ambova nungegimi arie. ");
INSERT INTO bjz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aghade, Jiusi enemboda babarigarimi banauda feferava Iesu du kaifa egeguturota, mino-mino eghá rea niningiguturie, “Aná embó mo, daiyagha etue-gea, furambi etu?” ");
INSERT INTO bjz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Natofomi be dumumutami mino-mino rea niningiguturie. Enembo dumeni eghá regeguturie, “Umó embó taubana re.” Kotú, dumeni eghá regeguturie, “Tefo, umó jo embó taubana irambi-gea, natofo kuveta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tago, enembo einimi jo be fangea, isaghava rea ningambi re. Anada bee mo, númane Jiusi enemboda babarigaridu oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Banau tutuno ea aria, rorova ueta, Iesu aria, God du Tafaroro Ari Kambova* terua, tutuno ea iruguturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aghá rieta, Jiusi enemboda babarigarimi unda gaga niningigea, bee duduku-dadaka egeguturie-gea, mino-mino eghá rea niningiguturie, “Ená embó avona jo irugambi re-tago, umó gari eghago mo doda bi?” ");
INSERT INTO bjz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aghá regeguturieta ningia, Iesu na númanda gaga mino eghá ririe, “Donu irugeta rora, jo anda tofo irambi re. Tago God amó ninenguturieta furera-da irugari reta irugeta rore. ");
INSERT INTO bjz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Amó God da ragarova irugeta rora, aĩ, andufa anda ragarova irugeta rora-nu, avona God da unonu urota iririgadua enembomi, gia tanana egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Anada bee mo, avona undufa unda ragarova raga rirota irugeta rouvia, unda durogha gari-du rea, amindu eta rouvie. Atá avona umó ninenguturieta furia-da durogha gari-du rea, irugadua, undava gavera eini tefo re. Umó gaa bee nuenembo rirota, enembo jo kuvirambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","God da Agho Dari Moses na nímandu ututurie. Avotago, nímane eini avona Agho Dari jo kaifa ea goghó ambi eta rosoravore. Atá, dodu amó data amburari-du roso?” ");
INSERT INTO bjz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Aghá ririeta, natofo dano niningigea erea, eghá regeguturie, “Imó taimumi asugea vitie. Imó data amburari-du mo, avona reiri?” ");
INSERT INTO bjz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aghá regeguturieta, Iesu na mino númandu eghá ririe, “Amó ivata anogha eini etueta, nímane dano duduku egegetoravore. ");
INSERT INTO bjz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","God na ririeta, Moses umó Agho Darida rova sasingu mane vivideda vii mendó andoro tafugari-du ririe. (Gaa bee re, Moses ená gaga bukava gefirie-tago, nímanda mambube manemi Moses sirorambi irieta, tutuno ea, aghá egegeta urie.) Tago, nímane Agho Dari bebejeguturota, Nangu Undari Feferava sasingu vivideda vii mendó andoro tafugeta rosoravore. Aghá egeguturota, nímane Nangu Undari Feferada agho dari bejeta rosoravore. Amindu rea, anona retueta, Nangu Undari Feferava, embó eini jebugetua mo, nímane dodu andú neno akokogo roso? ");
INSERT INTO bjz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mania tefunu-tefunu irurata! Gaa beedu-enembo rirota iruraita rosoravore!” ");
INSERT INTO bjz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iesu aghá rieta niningigea, Jerusalem enembo dumeni eghá regeguturie, “Aná data amburari-du reisi-ria embó mo, evera? ");
INSERT INTO bjz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Atá gigige! Natofoda dibeva, umó erea jiria, minono reirie-tago, enembo eini avona jo undava gaga eini rambi re. Namonde anda babarigarimi reisi-gerua mo, embó eini God da utota furari-du riria, aná umó ra-jogo? ");
INSERT INTO bjz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Avotago, God embó eini ninengota furá, enemboda akokogo nundubea-gea doari-du riria, umó doda reta furaita rouvia, avona jo gambi re. Atá, Iesu da naa kotú umó niavo reta furia, namonde amó dano tanana rosore.” ");
INSERT INTO bjz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aghá regeguturieta ningia, Iesu umó God du Tafaroro Ari Kamboda* rova iruguturota, be jojabemi eghá ririe, “Nímane amó tanana rosora, kotú amó doda reta furera beago, reisi-gerora? Avotago, amó andufa anda unomi jo furambi re. God amó ninenguturieta furera, umó aná gaa bee da ruru, kotú ari-bari taubana nuenembo eta rouvie. Nímane umó jo tanana ambi re. ");
INSERT INTO bjz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tago, unona ninenguturieta, amó undava reta furere-gea, umó anona tanana rore.” ");
INSERT INTO bjz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aghá ririeta niningigea, númane Iesu nandia bua, koto aita nundubuturie-tago, unda fefera jo furá bubambi-gea, enembo eini avona unda tamova righambi re. ");
INSERT INTO bjz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Aghá egeguturie-tago, natofo jede bububuguturia, númane Iesu gaabee egeguturota, eghá regeguturie, “Embó eini God da ninengota furá enemboda akokogo nundubea gia doari-du riria-mi furadua mo, aghajora jo ená embóda rouvia ivata anogha, serigea, oruabe ambi aita rouvia-jogo!” ");
INSERT INTO bjz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Enembo Iesu da tamova gaga be dumumutami regegutueta niningiguturieta, Moses da Gaga Kaifa kakatode*, fristida* kokotofudemi God da Kambo kaifa kakato dumeni ninenguturieta, Iesu sivegea nandaita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aghá egegutueta niningurie-gea, Iesu eghá ririe, “Amó namonde fefera tufoko irirota, nímane doa, umó avona amó ninenguturieta furera-dava kaverea yaita rore. ");
INSERT INTO bjz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nímane andú tava egegaita rosoravore-tago, jo amó tatambugambi aita rosoravore. Kotú, amó niavo iradora beago, nímane fufugari jo inono ambi egegaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jiusi enemboda babarigari mino-mino eghá rea niningiguturie, “Namonde anona rourogo umó tambara-degea, umó niavo yaita reiri? Namonde anda natofo Jiusi enembo dumeni Grik enembodava dighia asusumbuturia, avo ya irirota, Grik enembonu irugaita reiria?” ");
INSERT INTO bjz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Númane mana-mana egeguturota eghá regeguturie, “Umó bee dodu eghá retu? ‘Nímane amó tava egegaita rosoravore-tago, jo amó tatambugambi aita rosoravore,’ kotú, ‘Amó kambesi niavo iradora, nímane jo fufugari inono ambi egegaita rosoravore,’ dodu aghá retu?” ");
INSERT INTO bjz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Banau sidara uria fefera aná fefera jojabe re. Fefera aghade, Iesu erea jiria, be jojabemi eghá ririe, “Avona, uvu uno adua mo, umó furá andava undasue. ");
INSERT INTO bjz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Enembo avona amó gaabee adua, God da Gaga bukava reiria, aghagonu jebuga tumanadu irari unda neno rova eto-bato uvumi uria bubarigo aita rouvie. Ená uvu avona undadua mo, jebuga tumanadu irari tambua baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu aghá riria-da bee mo, enembo avona umó gaabee adua-dava, Asisi Kakara vorea, undava asugea iraita rouvia-nu ririe. Avotago fefera aghade, God jo rata, Iesu amburariva reta jebugea erea ya, rekago unda durogha gari bambi iria-du, unda Asisi Kakara beago jo utota vorefura enembo dava asugambi vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aghade, natofo desuturia-da dumenimi aná gaganu niningigea, eghá regeguturie, “Gaa bee, ená embó, feroveta eini ambova furari gaa reta rousua, aná umó re.” ");
INSERT INTO bjz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kotú, enembo dumeni eghá regeguturie, “God enemboda ari-bari akokogo nundubea gia doari-du embó eini ninengota furari-du riria, aná umó re.” Tago, enembo dumeni eghá regeguturie. “Embó eini God da ninengota furari-du riria, umó jo Galili Frovensi reta furambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God da Gagami rei-irugutua mo, embó eini God da ninengota furari-du riria, umó Devit da imemendida rorova, kotú Devit da siroruturia naa, Betlehem avo, siroraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Númane Iesu du aghá regeguturota, rorova gategea, besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aghá egeguturota, enembo dumeni Iesu nanandigaita nundubuturie-tago, enembo einimi unda tamova jo righambi re. ");
INSERT INTO bjz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aghá egegea, Tafaroro Kambo kaifa kakato kaverea igiguturieta, fristida* kokotofude, Moses da Gaga Kaifa kakatodemi uriga egeguturie, “Nímane dodu Iesu nandia bua fufugambi egegeto?” ");
INSERT INTO bjz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aghá regeguturieta, Tafaroro Kambo kaifa kakatomi mino eghá regeguturie, “Enembo eini avona unda minono reiria aghago, sei jo rirota niningigambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aghá regeguturia-du, Moses da Gaga Kaifa kakato* eghá regeguturie, “Unona nímane kuvetueta, gaabee egegetora-jogo. ");
INSERT INTO bjz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Atá, námanenu nundubea gigige! Námane fristida kokotofude, kotú Moses da Gaga Kaifa kakato einimi Iesu jo gaabee ambi vitere. ");
INSERT INTO bjz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Natofo jede beforo munju tefo bee re! Anada bee mo, Agho Dari Moses da gefiria, númane jo irugea gigigambi re. Aghá-gea, God da simboro numandava iriaveta, númane nundubari akokogo eta rousue.” Tafaroro Ari Kambo kaifa kakatodu, aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Moses da Gaga Kaifa kakatoda eini, Nikodemus sei Iesu gaita tumbade aria-mi erea, unda kokomana du eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Atá gigige! Namonde anda agho darimi reiria mo, enemboda sembago tava ea rea ningambi, o bee jo tambambi adora mo, umó bua koto egegambi asire.” ");
INSERT INTO bjz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aghá ririeta, númane Nikodemus kuvia gegha regeguturota, eghá regeguturie, “Aghajora, imó beago Galili embó eini ra-jogo? Imó God da Gaga irugadora mo, gaita roravore, feroveta eini jo Galili Frovensi reta furambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aghá regeguturieta, enembo dano númanda naa naa igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Igiguturie-tago, Iesu umó Olivi ootova arie. ");
INSERT INTO bjz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Rifogha, Iesu kaverea aria, God du Tafaroro Ari Kambova* buburiturieta, enembomi fugea roroguturieta, umó asumbea númane iruguturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aghade, Moses da Agho Dari irugari kakatode* Moses da Gaga Kaifa kakatodemi, evetu eini viro ueta gigigea nandia bua furia regeguturieta, natofoda dibeva jiruturieta, ");
INSERT INTO bjz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","númanena Iesu du eghá regeguturie, “Irugari kato, ená evetu viro ueta tambua bua fufugetore. ");
INSERT INTO bjz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Namonde anda Agho Dari, Moses da gefiria rova reiria mo, avona unda komanada evetugha o embógha viro kombo kasava adua, umó singoimi data amburari-du ririe. Aghadu rea, imó daiyagha rei-nundubuto?” ");
INSERT INTO bjz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Númane aghá regeguturia-da bee mo, Iesu gaga sembago rata niningigea umó bua koto egegaita nundubuturie. Tago umó gonea endava ingo sumingomi gaga gefirie. ");
INSERT INTO bjz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Númane umó rorogea tatasegea gigiguturota, uriga egegutueta, umó erea jiria, númandu eghá ririe, “Avore, ená evetu dedegadi amburaita rouvie-tago, avona ari akuago eini jo ambi iradua-mi, sei unona singoi ená evetu dava fugoe!” ");
INSERT INTO bjz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aghá rea doa, Iesu rekago gonea vorea, endava ingo sumingomi gefieta, ");
INSERT INTO bjz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","unda gaga aghá riria-nu niningiguturie-gea, númane jivorea-javorea igiguturie. Bego barirari sei arieta, dumeni ambova igiguturie. Aria sidara egegea, aná evetunu Iesu gha dotuturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aghá egeguturieta, Iesu erea jiria, aná evetudu eghá ririe, “Aná enembo niagha igigetu? Imó itia bera-bera urota, daita egegetua enembo eini jo jirambi ra?” ");
INSERT INTO bjz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Aghá ririeta, aná evetumi mino ririe, “Jojabee, enembo eini tefo re.” Aghá ririeta, Iesu eghá ririe, “Avore, amó beago, jo inda sembago iruruturota, imó singoimi dambi aita roreta, ii, tago, rekago ari akokogo mania ata!” ");
INSERT INTO bjz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu na rekago natofodu eghá ririe, “Enemboda unana, aná amó re. Avona anda ambova furadua mo, umó bingoiva jo deĩ ambi aita rouvie-tago, umó jebuga tumanadu irari-da unana tambua baita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aghá ririeta, Moses da Gaga Kaifa kakatomi* undú eghá regeguturie, “Imó avouvi inda rera gagada osagho fumbari enembo eini tefo-gea, jo gaa bee irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aghá regeguturieta, Iesu mino númandu eghá ririe. “Anda gagada osagho fumbari enembo eini tefo-gea amó gavera rari gaa reisi-reravore. Tago, amó eghá rere: amó donu rera, aná gaa bee re. Anada bee mo, amó niavoreta furera, kotú niavo kaverea yaita rora aná, amó rei-gerore. Tago, nímane jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Atá, nímane enemboda beforo garimi kotú nundubarimi reisi-irurutoravore. Amó mo, jo enembo eini irurambi eta rore. ");
INSERT INTO bjz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tago, anona iruraita asira mo, amó gaa bee nuenembo rirota, irurasire. Anada bee mo, amó jo anuka irambi re. Anda Afa amó ninenguturieta furera-gha, angá vitere. ");
INSERT INTO bjz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nímanda Agho Dariva eghá gefirieta vitie. ‘Enembo ungaghami mino-mino osagho fufirota, gaga dabako ananu regegadua mo, númanda gaga gaa bee-gea, gaabee egegari-du rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aghadu, amó andufa anda gagada osagho fufirota reta rore. Kotú Afa amó ninenguturieta furera beago, anda gagada osagho unona fumbuta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aghá ririeta, númanena undava uriga eghá egeguturie. “Inda Nimamo niavoro?” regeguturieta, mino Iesu na númandu eghá ririe, “Amó avouvi, nímane gigigasira mo, anda Afa beago gigigasiravore. Tago, nímane anda Afagha angá mo, jo gigigambi re,” ");
INSERT INTO bjz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kambesi einiva, God du Tafaroro Ari Kambo* rova natofoda vesa ututa uria tevoda kasava jiria irirota, aná gaga ririe. Aghá ririe-tago, enembo eini avona jo furá umó nandambi re. Anada bee mo, unda fefera jo furá bubambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu rekago númandu eghá ririe, “Amó nímane doa serigota-gea, amó tava egeguturota, nímanda ari-bari akokogo jo doambi-gea, amburaita rosoravore. Amindu, amó niavo yaita rora-va, nímane jo yari inono irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aghá ririeta, Jiusi enemboda babarigari tofo-tofo rea niningiguturie, “Umó, niavo yadua, namonde amó avo jo ya bubari inono irambi gaa reiria mo, umó undufa dea amburaita urota reiria, aĩ, daiyagha adu?” númane mana-mana ea, aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aghá regegutueta, Iesu rekago númandu eghá ririe, “Nímane tuva ená endava sirorutureravore. Atá, amó itivareta vorefurere. Amindu, nímane ená endada tofo re. Atá amó mo, jo ená endada tofo irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amindu eghá retore, ‘Nímanda ari-bari akokogo jo doambi-gea, amburaita rosoravore.’ Aghá retora-da bee mo, Afana, amó ninenguturieta furera-nu jo gaabee egegambi adora, God nímanda ari akokogo jo nundubea gia doambi ata, nímane amburaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aghá ririeta, númane regeguturie, “Atá, imó avouvi?” aghá regeguturieta, Iesu gaga mino eghá ririe, “Tutunova iruguturota, amó gaga donu rerara, dabako aghago re. Donu rekago rata niningigado? ");
INSERT INTO bjz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iruraita asira mo, nímandu gaga oruabe rasire-tago, amó ninenguturieta furera umó, ari-bari bee nuenembo re. Amindu, amó donu undava niningurera, aná nuenembo enembodu reaveta niningigeta rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesu aná gaga rirota, umó God Afadu ririe-tago, númane jo tanana ambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Amindu rea, Iesu na númandu eghá ririe, “Nímane amó ririkigadi erota, dedegadi amburota-gea, gigigaita rosoravore: Enemboda Jojabee*, aná amó re. Amó andufa anda ragarova buro jo ambi eta rore-tago, donu anda Afami iruguturia, aná nuenembo reta rora-nu, gigigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Afa amó ninenguturieta furera, jo amó doata, anuka jirambi, umó angá danode jireta rore. Anada bee mo, anda donu eta rora-du, umó gangoro eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesu aghá rieta niningiguturota, enembo oruaruabe umó gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jiusi enembo dumeni, avona umó gaabee egeguturia-dava Iesu eghá ririe, “Nímane anda gaga niningigea, aghago nuenembo egeguturota iririgadora, nímane anda yavero egegea, ");
INSERT INTO bjz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","gaa beeda ruru tanana egegaita rosoravore. Aghá ea, gaa beeda anomi vuregota, nímane jejebugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aghá ririeta, númane mino eghá regeguturie, “Imó dodu vuregari-da gaga mo rere? Námane abua Abraham da imemendi re. Námane jo enembo einida sabua* iririgambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aghá regeguturieta, Iesu mino eghá ririe, “Amó nímandu gaa bee rere. Avona ari-bari akokogo urota iradua mo, umó aná ari-bari akokogoda sabua ea iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sabua jo kambo numamoda mendi bee irambi-gea, jo tumanadu numonde danode irambi aita rouvie. Tago, aná embóda mendimi, numonde danode tumanadu iraita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aghá-gea, God da Mendimi nímane vuregea, nímanda ari-bari akokogo nundubea gia doadua mo, nímane sabuada irari dodogea, unda sasingu bee egegea iririgaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Amó tanana rore, nímane Abraham da sasingu re-tago, nímanda neno rova anda gaga tefo re. Aghá-gea, nímane amó dedegota amburari-du reisi-nundubutoravore. ");
INSERT INTO bjz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Amó Afa andú donu iruguturieta gerurera nuenembo minono reta rore. Tago nímane, nimamoda gaga daiyagha ririeta niningiguturera, ananu egegeta rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aghá ririeta, númane mino, “Námanda afa aná Abraham re,” regeguturieta, Iesu ririe, “Nímane Abraham da sasingu bee iririgasira mo, unda aito fugari daiyagha eta uria, aghagonu egegasiravore. ");
INSERT INTO bjz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Atá amó, gaa bee donu God dava niningurera, aná nuenembo nímandu reta rore. Aghá re-tago, nímane amó dedegota amburari-du reisi-nundubutoravore. Tago ari-bari nímanda rosora aghago, Abraham jo ambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kotú nímane nimamoda buro egeguturota viteravore,” ririeta, númane eghá regeguturie, “Námanda Afa bee aná God re. Afa eini tefo re. Námane unda sasingu bee re.” ");
INSERT INTO bjz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aghá regeguturieta, Iesu na númandu ririe, “Atá God nímanda Afa irasua, nímane amó neno bubugasiravore. Anada bee mo, amó unona ninenguturieta furera, eve vitere. Amó jo anda anomi furambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nímane anda gagada bee jo tanana egegambi eta rosoravore. Anada bee mo, nímane anda gaga ningari jo inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nímanda nimamo bee aná Satan re! Aghá-gea, unda unonu egegaita reisi-nundubutoravore. Tutunova, umó fururota, enembo deaveta ambubugeta urie. Undava gaa bee eini tefo re. Aghá-gea, umó gaa beede, kotú ari-bari taubanade, umó uno ambi eta rouvie. Umó gavera embó, gavera nanjogoda numamo bee re. ");
INSERT INTO bjz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amó nimandu gaa bee nuenembo reta rore-tago, nímane unda sasingu ea iririguturota, amó jo gaabee egegambi rosoravore ");
INSERT INTO bjz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Atá gigige! Amó ari-bari akuago eini ueta, nímanda enembo einimi gigiguturia, aĩ, tefo? Amó gaa bee rere-tago, nímane dodu amó gaabee egegambi roso? ");
INSERT INTO bjz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","God da sasingu, unda Gaga niningigeta rousue. Atá, nímane jo God da sasingu irambi re. Amindu rea, nímane anda gaga jo niningigambi rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aghá ririeta, Jiusi enemboda babarigarimi mino undú eghá regeguturie, “Námane gaa bee regegutare. Imó eto-bato námanda gitofo Samaria embó einidava taimu akuagomi asugea irita uria, aghagonu indava asugea vitie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aghá regeguturieta, Iesu eghá ririe, “Andava taimu eini jo asugea irambi re. Amó anda Afa kera urota irita rore. Tago nímane jo amó kera ambi egegeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Amó jo enembomi raga rari-du buro ambi eta rore. Tago, God na durogha andú utaita nundubeta rouvie. Kotú irurari kato bee, umó re. ");
INSERT INTO bjz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Amó nímandu gaa bee rere, enembo avona anda gaga ningia kaifa ea goghó adua, umó jo amburambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","53","Aghá ririeta, Jiusi enemboda babarigari niningigea, undú regeguturie, “Imó oreki gaga retueta, námane tanana egegetore, taimumi indava asugea vitie! Námanda mambube Abraham de feroveta manede dano ambubuguturie. Aghá egeguturie-tago, imó retoravore, ‘Enembo avona anda gaga ningia kaifa ea goghó adua, umó jo amburambi aita rouvie.’ Aghá rirota, inona Abraham serigea, imó jojabe gaa reravore. Atá imó rei-nundubutora, imó avouro?” ");
INSERT INTO bjz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aghá regeguturieta, Iesu mino ririe, “Amó andufa anda duroghadu raga radora, anda duroghadava bee eini jo sirorambi aita rouvie. Tago, anda Afa nímanda God gaa regegeta rosora-mi, andú durogha ututa rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Avotago, nímane jo God gigigambi viteravore. Atá amó God gerurota, unda gaga niningurota vitere. Atá ‘amó jo God gambi re,’ rasira mo, amó eto-bato nímanego gavera embó irasire. ");
INSERT INTO bjz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nímanda mambube Abraham anda furaita rora feferanu nundubuturota gangoro urie. Atá, aná fefera buburiturieta, umó gia gangoro urie.” ");
INSERT INTO bjz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aghá ririeta, Jiusi enembomi eghá regeguturie, “Imó jo ghaeko 50 tambambi viteravore. Tago, imó daiyagha Abraham gari gaa rere?” ");
INSERT INTO bjz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aghá regeguturieta, Iesu ririe, “Amó nímandu gaa bee rere. Abraham jo sirorambi irieta, amó vitirere.” ");
INSERT INTO bjz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aghá ririeta, númane singoi bubugea, Iesu dedegota amburari-du egeguturie. Tago Iesu umó nungia, God du Tafaroro Ari Kambo* doa isaghava bubua arie. ");
INSERT INTO bjz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu umó deĩ uta irurota, embó eini dibe soikide sirorari reta gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aghá gerurota, námanena uriga egeguturere, “Irugari kato, avoda ari akuagomi oná embó dibe soiki siroruturi? Tofo unda ari akuagomi uria, aĩ? Unda aya afaghada ari akuagomi uria?” ");
INSERT INTO bjz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aghá regeguturieta, Iesu ririe, “Tefo, jo unda sembagomi o nue numamoghada sembagomi umó dibe soikide sirorambi re. Tago, God da anomi undava buro ata gigigari-du rea, aghá siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Onembo vitia-du, God amó buro donu ari-du ninenguturieta furera-nu, namonde egegore! Atá, tumba riradua, avona buro eini jo ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Avotago, amó endava irirota, enembodava unana aghago janimbuturota iraita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aghá rea doa, umó visogha endava ea righia betuturieta, tauya uria-nu bua, aná embó dibe soikideda dibeva davea, ");
INSERT INTO bjz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aná embódu ririe, “Ii, kambesi ragaro Siloam kotova avo inda dibe seghadi!” (Siloam rera-da bee mo, namonde anda gaami aná “Ninengota Yari” regegeta rousue.) Aghá ririeta, aná embó aria, aná kotova dibe seseghurieta fangiturieta, geruta naava arie. ");
INSERT INTO bjz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Umó undari-du benunu uaveta, gigigeta uria enembomi kotú unda mambu mane dumenimi umó gigigea, mino-mino uriga eghá egeguturie, “Ená embó aná dibe soikide, onava asumbea irirota, undari-du benunu eta ria mo, umó ra?” ");
INSERT INTO bjz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Númane mana-mana egeguturota, dumeni “Aná umó re,” regeguturie, kotú dumeni mi, “Embó eini eto-bato umongo re,” regegutueta, aná embómi undufa, “Ená amó re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aghá ririeta, númane undú uriga egeguturie, “Inda dibe daiyagha fangetueta rei-gero?” ");
INSERT INTO bjz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aghá regeguturieta, aná embómi ririe, “Embó ragaro Iesu regegeta rousua-mi, visogha endava ea righia betetueta tauya etua-nu bua, anda dibeva davea doa retue, ‘Ii, kambesi ragaro Siloam kotova dibe seghadi!’ retueta, amó era, dibe seghetueta fangetueta rei-gerore.” ");
INSERT INTO bjz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aghá ririeta, númane uriga egeguturie, “Aná embó Iesu rera, niavoro?” regeguturieta, umó ririe, “Amó jo gambi re,” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Nangu Undari Feferava, Iesu tauyami bua, aná embó dibe soikide urieta, dibe fangiturie. Amindu rea, enembomi aná embó unumbea bua, Moses da Gaga Kaifa kakatodava* igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Númane beago niningigaita uno egeguturie-gea, rekago uriga egeguturie, “Inda dibe daiyagha fangetu?” regeguturieta, aná embó ririe, “Iesu na visogha endava ea tauyagha bua, anda dibeva davea retueta, amó era, dibe seghetueta fangetueta, oreki rei-gerore.” ");
INSERT INTO bjz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aghá ririeta, Moses da Gaga Kaifa kakato dumenimi Iesu da tamova gaga eghá regeguturie, “Ená embó Nangu Undari Feferada agho dari jo kaifa ambi eta rouvie. Aghá-gea, umó jo God davareta furambi re,” regeguturie, kotú dumeni regeguturie, “Ari akuago embómi ivata anogha jo ata sirorambi aita rouvie,” aghá regegea, rorova gategea, besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Aghá regeguturota, Moses da Gaga Kaifa kakatomi rekago aná embódu regeguturie, “Ana embómi retueta, inda dibe fangea taubana etue. Amindu imó daiyagha rei-nundubuto? Rege niningigore! Umó avouro?” regeguturieta, umó eghá ririe, “Umó feroveta eini re.” ");
INSERT INTO bjz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aghá ririeta, Jiusi enemboda babarigari númane aná embó dibe soikide jebuguturia, jo gaabee egegambi re. Amindu rea, ririeta númane aria aná embóda nue numamogha bua fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bua fufuguturieta, uriga egeguturie, “Gigige! Ená nímanda mendi ra? Umó dibe soikide sirorari gaa retora mo, umó ra? Atá umó oreki daiyagha ea rei-geru?” ");
INSERT INTO bjz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aghá regeguturieta, nue numamogha regeguturie, “Námane tanana rosore, ená námanda mendi re. Umó dibe soikide siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tago, avona unda dibe etueta fangetua, kotú umó daiyagha oreki rei-gerua, aná námane beago jo gigigambi re. Amindu, umó embó reta, undava uriga egege! Undufa rata niningigadi!” ");
INSERT INTO bjz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aghá regeguturia-da bee, aná embóda nue numamogha Jiusi enemboda babarigaridu oru egeguturie. Anada bee mo, babarigari númane seibe manaka gaegeguturie: Enembo avona Iesu gaabee egeguturota, “God da ninengota furari-du riria embó aná, umó re,” rirota, nghaĩ itari kambova* furasua, númanena umó tutuvegasueta, airo irasue. ");
INSERT INTO bjz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Amindu rea, aná embóda nue numamogha oru egeguturota, eghá regeguturie, “Undava uriga egege! Undufa rata niningigadi!” ");
INSERT INTO bjz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aghá regeguturieta, Jiusi enemboda babarigarimi rekago ririeta, aná embó dibe soikide siroruturia kaverea furia teterurieta, eghá regeguturie, “Jebugetoravota, God nuenembo raga rege! Námane tanana rosore, aná embó Iesu umó ari-bari akokogo ari kato re.” ");
INSERT INTO bjz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aná embó mino ririe, “Umó ari akuago embó ra, aĩ tefo, amó mana-mana rore. Tago, amó tanana rore, sei amó dibe soikide vitara, oreki dibe fangetueta rei-gerore.” ");
INSERT INTO bjz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aghá ririeta, númane uriga egeguturie, “Atá, umó daiyagha etueta, inda dibe soiki fangetueta, imó rei-gero?” ");
INSERT INTO bjz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aghá regeguturieta, aná embó ririe, “Amó seibe retore-tago, nímane niningigari injigha egegetoravore. Atá dodu rekago ningaita uno roso? Aghajora, nímane beago unda ambo nimbi egegaita uno egeguturota, reisi-rera-jogo.” ");
INSERT INTO bjz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aghá ririeta, númane undú tauga-kavavana rirota, eghá regeguturie, “Imó seibe Iesu da ambo nimbi eini ea viteravore-tago, námane aná, Moses da ambo nimbi re. ");
INSERT INTO bjz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Námane gia tanana rosore, God umó Moses gha gaga reta urie. Atá ená embó Iesu doda reta furia, námane jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Regeguturieta, aná embómi númandu ririe, “Daiyagha reisi-rere? Unona etueta, anda dibe fangetue-tago, umó doda reta furia, nímane tanana ambi gaa reisi-reravore. ");
INSERT INTO bjz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Gigige! Namonde amó dano reisi-gerore. God jo ari akokogo enemboda gaga ningambi eta rouvie. Tago, umonu neno rururota, unda uno egegeta rousua enemboda gaganu ningita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Atá, uutu enda sirorea furia-va, enembo eini avona jo ata-gea, enembo dibe soiki sirorari dibe fangota, avona gigigambi vitare-tago, oreki unona retueta anda dibe fangetue. ");
INSERT INTO bjz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Aghá-gea, umó God davareta furambi asua, ená eini-eini eghago jo asueta sirorambi asue,” ");
INSERT INTO bjz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aghá ririeta, númanena undú tauga kavavana eghá regeguturie, “Imó sirorea furera-va, inda ari akokogogha dano fureravore. Aghá re-tago, imó daiyagha inona námane irugaita rere?” aghá regegea, aná embó tutuveguturota, airo irari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aná embó tutuveguturia-nu ningia, Iesu aria, aná embó tambua ririe, “Imó Enemboda Jojabeenu gaabee rora?” ");
INSERT INTO bjz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Aghá ririeta, aná embó mino undú eghá ririe, “Kotofuko, Enemboda Jojabee niavo ro? Rege, amó ningia, umó gaabee are!” ");
INSERT INTO bjz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aghá ririeta, Iesu undú ririe, “Imó seibe rei-geroravore! Enemboda Jojabee* enanu ingá jiria viteravore.” ");
INSERT INTO bjz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aghá ririeta, aná embó ririe, “Jojabee, amó oreki imó gaabee rore,” rirota, Iesu da dibeva koubomi jengirea tumogha baĩ urie. ");
INSERT INTO bjz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aghá urieta, Iesu na ririe, “Amó enembo iruraita endava vorefurere. Amó enembo dibe soikide rata, dibe fafangegea, neno nundubari-du furere. Kotú, enembo dibe fafangegari mane rata, dibe soiki egegea, nundubari sidara ari-du rea, furere.” ");
INSERT INTO bjz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Aghá rieta niningiguturie-gea, Moses da Gaga Kaifa kakato* dumeni Iesu de vitiria-mi, uriga egeguturie, “Imó námane beago, dibe soikide gaa rera?” ");
INSERT INTO bjz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aghá regeguturieta, Iesu na mino ririe, “Nímane dibe soiki iririgasira, nímane ari-bari akokogoda mino eini jo bambi egegasiravore! Aghá re-tago, ‘Námanda dibe jo soiki irambi re,’ reta rosoravore. Amindu, amó eghá rere. Nímanda ari akokogoda mino jo sidara ambi irota, ambova tambaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu aghá rirota, kasia eini ririe, “Amó nímandu gaa bee rere. Embó avona oka sifi da kara bebatova terambi, emboro einiva samba ea rarigea voradua, umó aná bagia kato re. ");
INSERT INTO bjz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tago, enembo avona bebatova teradua, oka sifi kaifa ari kato bee, aná umó re. ");
INSERT INTO bjz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kotú, bebato kaifa ari kato bebato undú ifegaita rouvie. Kotú sifi mane unda beda eronu niningiguturota, umó tanana eta rousue. Aghá urota, sifi unda tofo-gea, ragarova atembutuaveta ningia, undava iaveta, unumbea bua isaghava bubuta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aghá ea, númanda dibe kena jiria iruaveta, sifi mane unda beda eronu niningigea, tanana egeguturota, unda ambova igigeta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Avotago, enembo einida beda eronu jo ningia tanana egegea, unda ambo-ambo egegambi aita rousue. Anda bee mo, be eini ningadua, númane oru susumbugea igigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu na kasia gaga aghá ririe-tago, aná gagada bee númane jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aghadu rea, Iesu na rekago númandu eghá ririe, “Amó nímandu gaa bee rere. Amó aná sifi da kara bebato re. ");
INSERT INTO bjz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Atá, amó furambi irieta, sei avona anda dibe kena fufuguturia, aná bagia kakato re. Amindu, sifi mane númanda beda eronu jo niningigambi re. ");
INSERT INTO bjz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Atá, amó aná bebato re. Enembo avona furá, andava teradua, anona sonembota, jebuga tambaita rousue. Kotú, terua bubua egeguturota, undari taubana tambaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Bagia katomi bagia urota, data amburari-du, kotú susughi nuenembo aita teruta rouvie. O amó furera aná, anda sifi mane jebuga bubugari-du kotú, jebuga taubanami numandava beda ari-du rea furere. ");
INSERT INTO bjz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Oka sifi kaifa ari kato taubana, aná amó re. Kotú sifi kaifa ari kato taubana unda jebuga unda sifi du rea utua, amburaita simbugea vitie. ");
INSERT INTO bjz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tago, guri baita buro eta rouvia embó, umó jo sifi kaifa ari kato bee irambi re. Aghadu, umó sinakoro fururota gadua, aná sifi mane avo doa, umó oru sumbaita rouvie. Aghá ata, sinakoromi tuvia gambota, sifi mane gategea airo-airo susumbugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Aná buro kato umó doa sumbaita rouvia-da bee mo, umó guridu buro eta rouvie. Aghá-gea, sifi dava donu siroradua, umó jo kaifa ea goghó ambi, doa sumbaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","O amó mo, aná sifi kaifa ari kato taubana bee re. Eto-bato, Afa amó gita rouvia aghagonu, amó beago umó gita rore, kotú amó anda sifi gia, tanana uaveta, anda sifi mane beago, amó gia tanana eta rousue. Amindu rea, amó númandu amburaita simbugea vitere. ");
INSERT INTO bjz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anda sifi dumeni vitie, jo ená kara rova irambi re. Aghá-gea, amó ya númane beago unumbea bua fururota, anda be niningigaita rousue. Aghá ata-gea, kaifa kato dabakomi, númane kara dabakova kaifa aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Anda Afa amó neno bua goghó eta rouvie. Anada bee mo, amó rekago amburariva reta jebugea eraita rea, anda jebuga doa amburaitare. ");
INSERT INTO bjz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Anami reiria mo, enembo eini avona jebuga amó kena jo rougea bambi aita rouvie. Anda unomi ‘avore’ rata-gea, dedegota amburaita rore. Andufa anda anomi anda jebuga doa utaita rore. Kotú andufa anda anomi rekago bua eraita rore. Anda Afami amó aghá ari-du ririe.” ");
INSERT INTO bjz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesu gaga aghá ririeta, Jiusi enembo niningigea, rekago sarigea jiria besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Aghá egeguturota, enembo dumeni regeguturie, “Taimu akuagomi undava asugea vitie, kotú umó beforo akuago re. Dodu unda gaga reisi-niningo?” ");
INSERT INTO bjz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kotú dumeni regeguturie, “Taimu akuagomi unda rova irasua, gaga aghago jo rambi asue. Kotú enembo dibe soikide jo taimumi ata, dibe fangambi asue.” ");
INSERT INTO bjz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yaurada feferava, God du Tafaroro Ari Kambo* Seseghuria-da Banau buburiturie. Banau aita uua-du, Iesu avo Jerusalem vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jiusi enemboda Tafaroro Ari Kambo rova, Iesu na terua kambesi einiva, Kini Solomon da Sebo regegeta uria, avo deĩ ea arie. ");
INSERT INTO bjz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Deĩ irueta, Jiusi enembo umó rorogea jiria eghá regeguturie, “Imó avouvi, daiyagha isaghava radi niningigambi roso? God da ninengota furari-du riria embó Keriso, imó ra, aĩ? Gaa bee nuenembo rege námane niningigore!” ");
INSERT INTO bjz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aghá regeguturieta, Iesu mino ririe, “Amó seibe retore-tago, nímane jo gaabee egegambi re. Afada ragarova, ivata anogha anda eta rora-mi, amó avouvi isagha rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Aghá re-tago, nímane jo gaabee egegambi re. Anada bee mo, nímane jo anda sifi iririgambi re. ");
INSERT INTO bjz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Anda sifi mo, anda beda ero niningiguturota, tanana egegea, númane anda ambo-ambo eta rousue. Kotú amó númane gari re. ");
INSERT INTO bjz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kotú jebuga tumanadu irari anona utota, númane bua, jo ambua sidara ambi aita rousue. Enembo eini avona númane jo anda ingova righia rougea bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Númane, anda Afami andú ututurie, kotú unda ano jojago bee re. Amindu, avona furá númane anda Afada ingova jo rougea bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kotú Afagha angá amó aná dabako re.” ");
INSERT INTO bjz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aghá ririeta, Jiusi enembo rekago Iesu dedegaita singoi bubuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aghá egegutueta, Iesu na númandu ririe, “Ivata anogha oruaruabe anda Afana reaveta, anona irugeaveta, nímane gigigeta rosora-du rea, aĩ, dinunu eini donu etora-du rea, amó singoimi dedegaita roso?” ");
INSERT INTO bjz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Umó aghá riria-du, Jiusi enembomi mino regeguturie, “Inda ivata taubana manedu rea, jo singoimi imó dedegambi egegaita rosore-tago, inona God da ragaro fara rora-du, aghá egegaita rosore. Imó enembo bee re-tago, inda rariva mo, imó indufako God gaa reravore.” ");
INSERT INTO bjz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aghá regeguturieta, Iesu na mino eghá ririe, “Tofo nímanda Agho Dari gefiria-da rova: God na enembodu rirota, númane dano god gaa ririe. ");
INSERT INTO bjz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kotú God da agho darimi donu reiria, aná gaa bee re, tumanadu iraita rouvie. Enembo avona unda gaga niningiguturia-du, God na enembodu rirota, númane dano god gaa ririe. ");
INSERT INTO bjz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Avore, anuka amonu Afa na gategea ninenguturieta endava vorefurere-gea, ‘Amó aná God da Mendi re,’ retora-nu niningigea, nímane dodu God da ragaro anona fara ari gaa reisi-rere? ");
INSERT INTO bjz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Amó anda Afada unonu jo ambi asueta gigigasira, avore, mania amó gaabee egegata! ");
INSERT INTO bjz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Avotago, amó anda Afada unonu urota gigigea, amó gaabee egegambi adora, avore, anda ivata-kavata anode eta rora ananu gigiguturota gaabee egegasiravore! Aghá urota, nimane gigigea tanana ea goghó aita rosoravore: ‘Gaa bee: Afa andava takembea vitie, kotú amó Afadava takembea vitere. Angá mo danode dabako ea vitere.’” ");
INSERT INTO bjz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iesu aghá ririeta, númane rekago umó nanandigaita egegutueta, umó doa jivorea arie. ");
INSERT INTO bjz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iesu aria, Jordan uvu rekimbea, Jon da enembo uvumi bafutaito eta uria kambesi seiva vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Umó avo irieta, enembo oruaruabe furia, undava bububugea, eghá regegeta urie, “Jon ivata-kavata anode eini jo ambi re. Tago, ená embódu donu reta uria, aná gaa bee re.” ");
INSERT INTO bjz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aghade, aná kambesiva enembo oruaruabe umó gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani embó eini, ragaro Lasarus, kae rururie. Betani, aná Meri ungá unda kaka Marta ghada naa re. ");
INSERT INTO bjz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ená Meri rera, mose eini uka muu munode Jojabeeda ekava averegea unda foumami dufituria, aná umó re. Kotú ená Lasarus kae bua vasia vitiria, aná Meri da ruu re. ");
INSERT INTO bjz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Avore, Lasarus kae bua iria-du, unda gharototomi gaga eghá ituturieta, Iesu dava arie: “Jojabee, inda neno bari komana aná kae bua vitie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Aghá ningia, Iesu eghá ririe, “Ená kae Lasarus da bua ambubuta, aná jo amburota sidara ari kae bua amburambi re. Tago, God da durogha isagha ari-du rea, aná kae rura. Aghade, God da durogha isagha aita rouvia-mi unda Mendida durogha beago isagha ata, enembomi gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu Meri ungá Marta gha Lasarus de dano neno rururota irita urie. ");
INSERT INTO bjz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasarus da kae rururia-da bingá, Iesu niningurie-tago, aná kambesi jo doa yambi, fefera ungagha avo vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Fefera ungagha sidara urieta, námane unda ambo nimbidu ririe, “Namonde kaverea Judia Frovensiva igigore!” ");
INSERT INTO bjz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aghá ririeta, námane regeguturere, “Irugari kato, tumbo enembo Jiusi enembo avo vita-mi, imó singoimi dedegaita egeguta-tago, imó rekago kaverea avo yaita rera?” ");
INSERT INTO bjz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aghá regeguturieta, Iesu ririe, “Rifogha reta iiava jamade, unana janimbeta rouvie. Janimbuturota, enembo avona aito ea deĩ yadua mo, jo eka dea fugota jurambi aita rouvie. Anada bee mo, umó unana gerurota yaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Atá, enembo avona tumbade deĩ egegaita rousua-mi, eka dea fugota, umó juraita rouvie. Anada bee mo, unana tefo, tumba-gea, eka dea fugota, umó juraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aghá riria-da ambova, umó eghá ririe, “Namonde anda komana Lasarus umó eevo rouvie. Tago, anona ya avo bubua, evurota umó eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aghá ririeta, námane unda ambo nimbimi regeguturere, “Jojabee, umó evo rouvie-gea, jebugaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasarus da ambubuturia-da gaganu Iesu na nundubuturota ririe-tago, námanda nundubuturera mo, eevo beedu rari gaa regeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","15","Aghá regeguturera-du, Iesu námandu isaghava ririe, “Lasarus aná ambubuta-tago, undava yambi utare-gea, amó gangoro rore. Anada bee mo, eghá rora-mi ata, nímane amó gaabee egegaita rosoravore. Aghadu egege, namonde undava igigore!” ");
INSERT INTO bjz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Aghade, Tomas na námandu eghá ririe, “Avoreta, egege, namonde Irugari katode dano ya ambubugore!” Tomas rera-da ragaro eini Didimus regegeta urere. ");
INSERT INTO bjz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu aria buburiturota nininguria mo, Lasarus seibe bua aria furuguturieta, fefera ungagha-ungagha sidara uria-nu niningurie. ");
INSERT INTO bjz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani naavareta Jerusalem yari jo roo yafabe irambi re, kilomita bakode re. ");
INSERT INTO bjz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aghá-gea, Lasarus amburari bingá niningigea, Jiusi enembo oruaruabe Marta ungá Meri gha sonembea gumema aita fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aghade, Iesu furia, utuva uria-nu ningia, Marta erea, umó tambaita bubua arie. Atá, Meri kambova vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Aria tambua, eghá ririe, “Jojabee, imó eve irasira, anda ruu jo amburambi asue. ");
INSERT INTO bjz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tago, amó rei-gerore, imó oreki enembo God dava dodu benunu adora, God na indú utaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aghá ririeta, Iesu undú ririe, “Inda ruu aná rekago jebugea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Aghá ririeta, Marta na eghá ririe, “Amó rei-gerore, umó ambubuta-tago, fefera ambova rekago kaverea eraita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Marta aghá riria-du, Iesu mino undú ririe, “Amburarivareta jebugea erari-da ano kotú jebugada ano andava vitie. Aghá-gea, enembo avona amó gaabee egeguturota iradua, amburaita rouvie-tago, rekago jebugea eraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kotú, enembo avona amó gaabee egeguturota iradua, umó jo ambua sidara ambi aita rouvie. Umó jebuga tumanadu irarinu tambua baita rouvie. Imó ená gaga gaabee rora?” ririeta, ");
INSERT INTO bjz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta na Iesu du ririe, “Aĩ, Jojabee! God na unda Mendi utota, endava furari gaa riria, aná imó re. Ananu gaabee rore,” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta aghá rea doa, kaverea aria, unda rao Meri ghogho ririeta furieta, be kasami ririe, “Irugari kato etia bubua, imó gaita kaifa urota reirie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Aghá ririeta ningia, Meri tutomi erea, Iesu tambaita arie. ");
INSERT INTO bjz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Atá, Iesu jo ya naa banunava bubambi re. Marta aria, umó niavo tafiria kambesi dabako avo vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Meri tatavami erea irueta gigigea, Jiusi enembo yove gaje rirota, Meri de kambo rova vitiria-da nundubuturia mo, Meri ya, uje singoi toova jii raita yari gaa regeguturie. Amindu númane erea, unda ambova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri aria, Iesu dava bubua, unda eka tuva jujururota eghá ririe, “Jojabee, imó eve irasira, anda ruu jo amburambi asue.” ");
INSERT INTO bjz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aghá rirota, umó jii rieta, kotú enembo numonde fufuguturia beago jii regeguturie. Aghá egegutueta gia, Iesu da neno duduku urota, giimi gayarigo urie. ");
INSERT INTO bjz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Aghá urota ririe, “Umó niavo uje egeguta?” ririeta, numane eghá regeguturie, “Jojabee, fu gadi!” ");
INSERT INTO bjz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aghá regeguturieta, Iesu jii ririe. ");
INSERT INTO bjz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aghá ueta, aná Jiusi enembo gigigea eghá regeguturie, “Gigige, umó Lasarus neno bua goghó eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Aghá ririeta, Jiusi enembo dumenimi eghá regeguturie, “Embó eini dibe soikide sirorari unona utata dibe fangita. Aghá-gea, umó eve irasua, unona buregasueta, Lasarus jo amburambi asue. Aghajora, ivata aghago arida ano undava vitia-jogo.” ");
INSERT INTO bjz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu rekago Lasarus du neno mema jojabe urota, singoi beko too, ujeva arie. Aná uje bebato singoi jojabemi oberea gajari vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Aghá-gea, Iesu na númandu ririe, “Singoi obere, kasava yae!” Aghá ririeta, aná amburari embóda gharovu Marta na ririe, “Jojabee, avotago umó furugutata fefera ungagha-ungagha sidara etue-gea, masa sembago rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Marta aghá ririe-tago, Iesu na mino undú eghá ririe, “Amó indú seibe ritare, ‘Imó amó gaabee adora, God da durogha gaita roravore.’” ");
INSERT INTO bjz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aghá ririeta, númane aná singoi oberea airo ititiguturieta, Iesu dibe itiva ea eghá ririe, “Afa, imó nghaĩ javea, anda gaga ningita rora-du, imó ghanena rore. ");
INSERT INTO bjz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Amó rei-gerore, fefera inono, imó nghaĩ javea, anda gaga ningita roravore. Tago, oreki ená enembomi amó inona ninenguturieta furera-nu gigigea, gaabee egegari-du rere.” ");
INSERT INTO bjz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu aghá rea sidara ea, be jojabe ghogho ririe, “Lasarus, bubua fu!” ");
INSERT INTO bjz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aghá ririeta, aná amburari embóda eka ingo eembo saghai tamoda bimbimi eghovea biruru uria-gha, kotú unda dibe be eembo saghai tamo tufokomi eghovuturia-de aghá bubua isaghava furueta, Iesu na númandu ririe, “Eembo vuregea bua do-gea yae!” ");
INSERT INTO bjz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aghade, Jiusi enembo oruabe Meri sonembaita fufuguturia-mi, Iesu da donu uria-nu gigiguturie-gea, umó gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tago, enembo dumeni kaverea aria, Iesu da daiyagha uria, ananu ririeta, Moses da Agho Dari Kaifa kakato* niningiguturie ");
INSERT INTO bjz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aghá niningiguturie-gea, Moses da Agho Dari Kaifa kakatode, fristi* maneda kokotofude kotú kanisera* manede dano desea, manaka gaegeguturota, eghá regeguturie, “Namonde amó aná embódu daiyagha egega? Aná embóda ivata anogha oruaruabe eta rouvia-nu gigige! ");
INSERT INTO bjz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ená ivata jojabebei anogha eta rouvia, namonde jo rata doambi, aghami aghami urota iradua, enembo dano umó gaabee egegaita rousue. Aghá uradua, Rom enembomi furá, namonde anda Tafaroro Ari Kambo* dea bejea, namonde anda natofo susughi ea, dedegota ambubugaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Aghá regegutueta, aná ghaekova fristi maneda beforo righari embó eini ragaro Kaiafas, unona erea eghá ririe, “Nímane nundubari sembago rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nímane eghá gigige! Namonde Jiusi enembo dano ambubugadora, aná akuago bee re. Aghá-gea, enembo oruaruabeda ragarova, embó dabakomi amburadua, aná taubana re!” ");
INSERT INTO bjz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Avore, Kaiafas umó aná ghaekova fristi maneda beforo righari ea irirota, aná gaga jo undufa unda nundubarimi rambi re. Tefo, God na unda unomi urieta, Kaiafas na Iesu daiyagha Jiusi enembo oruaruabeda kambesi bua amburaita rouvia-nu rirota, God da unonu isagha urie. Iesu unda natofo Jiusi enembo du amburasue, kotú God da uno eini mo, roo enda nanjogoda enembo God nu gaabee egeguturota vitiria-nu, Iesu na bua furá danode takembari-du rea, amburasue. ");
INSERT INTO bjz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aná fefera aghade, númane Iesu dedegota amburari-du rea, manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Aghá ningia, Iesu jo isaghava iru-furu ambi re. Umó aria, naa ragaro Efraim anava buburiturie. Efraim naa, uvu tefo kotú enembo irambi kambesi kasava re. Anava bubua, námane unda ambo nimbide avo vitirere. ");
INSERT INTO bjz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Námane Jiusi enemboda Serigea Yari Banau* fefera furia, utuva urieta, enembo oruaruabe númanda naa dodogea, Jerusalem yayavuguturie. Númane banau feferada dibeva bubua, númanda sembago mane seseghegaita rea, igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Aghade, númane God du Tafaroro Ari Kambo* rova danode desea iririguturota, Iesu bubadua gigigaita rea, dibemi irurea iru-furu egeguturie. Aghá egeguturota, mino-mino rea niningiguturie, “Nímane daiyagha reisi-nundubuto? Iesu Jerusalem banauva furadua?” ");
INSERT INTO bjz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Aghade, fristida kokotofude kotú Moses da Agho Dari Kaifa kakatodemi eghá regeguturie. Enembo eini avona Iesu gigigasua mo, regegasueta númane niningigea, ya umonu nanandigasue. ");
INSERT INTO bjz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Fefera ingo yoveni, yoveniva dabako sidara ata-gea, Serigea Yarida Banau* egegaita ueta, Iesu Betani arie. Iesu da ririeta amburarivareta jebugea eroruria embó Lasarus, aná naava irita urie. ");
INSERT INTO bjz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Anava Iesu da ragarova jama undari simbuguturie. Aghá urota, Marta na eini-eini simbugutueta, Lasarus beago farova enemboda rorova irirota, undari undidiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aghade, Meri na uka muu (1/2) lita aghagonu munode, ragaro nadi reta, bua furie. Aná uka muuda muno taubana dogo, jo uvugha bagega irambi-gea, mino bee itiva re. Terua, Iesu da ekava averegea doa, unda foumami dufiturieta, aná uka muuda muno taubanami aná kambo roo beda urie. ");
INSERT INTO bjz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Aghá ueta, unda ambo nimbi eini, Keriot embó Judas, ambova Iesu dubo ea gitofodu ututuria-mi ririe, ");
INSERT INTO bjz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Daiyagha aná uka muu utua ghaeko dabako buro ea bari guri* aghagonu bua, makasi enembodu vesa egegambi ro?” ");
INSERT INTO bjz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Atá Keriot embó, Judas, umó makasi enembodu jo nundubuturota rambi re. Umó Iesu da noni rova umó guri kaifa kato re-tago, bagia eta urie-gea, undufa umonu nundubuturota ririe. ");
INSERT INTO bjz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aghá ririeta, Iesu na unda gaga mino eghá ririe, “Mania ená evetudu dibe beva regegata! Amó amburota simbugea uje aita rouvia feferadu nundubuturota, ená uka muu munodemi sei simbugetue. ");
INSERT INTO bjz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Atá, reisi-gerora, makasi enembo aná nemonde danode, fefera numbo tofo bee iraita rosoravore-tago amó jo namonde tumanadu irambi aita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aghade, Iesu avo irieta, Jiusi natofo jede unda bingá niningiguturie-gea, dano avo igiguturie. Númane Iesu nuenembo gigigaita yambi re-tago, aná embó Lasarus Iesu da ririeta amburarivareta eroruria, umógha dano gigigaita rea, igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Atá, fristida* kokotofumi Lasarus beago data amburari-du, manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Anada bee mo, Iesu na ririeta, Lasarus amburarivareta jebugea eroruria-du rea, Jiusi enembo oruaruabe Iesu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Enembo oruaruabe Serigea Yari Banauva* fufuguturia-mi, fefera eini Iesu da furari bingá niningiguturie. Avore, Iesu Jerusalem bogu naava bubaita furueta, númane ika einida fafatu oruko aghago bua, Iesu tambaita igiguturota, koko-koko rea eghá regeguturie, “Orokaiva! Orokaiva! God du raga regegore! Umó avona Jojabeeda ragarova bubua reifia-du, raga regegore! Israel enemboda kini du, raga regegore! Orokaiva!” ");
INSERT INTO bjz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu oka ragaro donki da mendinu gia bua, anada etova asumbea furie. Atá umó daiyagha uria aná mo, Buka Seiva gefiria aghago nuenembo siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Aná gaga evere: “Saion* ootova vitia enembodu eghá radi rere, mania oru egegata! Nímanda kini oka donki da etova asumbea reifie.” ");
INSERT INTO bjz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Fefera aghade, námane unda ambo nimbi ená gaga maneda bee tanana egegambi re. Tago ambova, God na Iesu ririeta erea, unda durogha gari bua uutuva asumbuturia aghade, námane donu undú egeguturera, kotú undú Buka Seiva donu gembari vitia-da bee dano, námane nundubea tanana egeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Avore, Iesu sei ririeta, Lasarus uje singoi toova amburarivareta eroruria-nu, natofo jedemi gigigea, bingá regeguturieta aria fafate urie. ");
INSERT INTO bjz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iesu na, aná ivata anogha urieta bingá sirorea aria fafate urieta niningiguturie-gea, enembo oruaruabe erea, Iesu tambaita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Aghadu rea, Moses da Agho Dari Kaifa kakato* mino-mino eghá regeguturie, “Enembo namonde anda gaga ningambi rousue. Atá oná embó gigige! Enembo dano unda ambova reisi-iye.” ");
INSERT INTO bjz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Banauda feferava, enembo nanjogo tumogha baĩ egegaita rea, Jerusalem igiguturia-da rova Grik enembo dumeni igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Númanena furia, Iesu da ambo nimbi eini, ragaro Filip du eghá regeguturie, “Kotofuko, námane Iesu gigigaita uno rosore.” Filip rera, umó Galili roo endava, naa ragaro Betsaida embó re. ");
INSERT INTO bjz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Númane aghá regeguturia-du, Filip aria, Andru rea ningia, ungá aria, Iesu du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Regeguturieta, Iesu númandu mino eghá ririe, “God unda durogha gari Enemboda Jojabee* dava utarida fefera etia bubie. ");
INSERT INTO bjz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Aghá-gea, amó nímandu gaa bee rere. Farava vee tefo isaghava iradua, dibe dabakonu iraita rouvie. Ata, jua endava vorea amburadua, vitia bee oruabe aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dabako aghago, enembo avona unuka unda irari-du nundubuturota, neno badua, umó jebuga tumanadu jo bambi aita rouvie. Avotago, enembo avona endava irirota, unda irari doa, andú rirota amburadua, umó jebuga tumanadu irari baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kotú, enembo avona anda sabua* aita adua mo, umó anda ambo-ambo aita rouvie. Amó niavo iradora, anda sabua beago avo iraita rouvie. Enembo avona andú buro adua, anda Afa na umó kakara aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Aghá rirota, Iesu eghá ririe, “Amó neno rova mema jojabe itatama rore. Tago, ‘Afa, ená mema fefera andava do bua serigadi!’ jo rambi aita rore. Anada bee mo, amó ená memanu itatama aita rea, endava furere. ");
INSERT INTO bjz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amindu rea, Afa, inda ragaro righi eroruturota, durogha ae!” Iesu aghá ririeta, uutuva reta beda eromi eghá ririe, “Seibe righia erorueta durogha urie, kotú rekago aghá aita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aghade, natofo jede avo jijiregea vitiria-mi aná beda ero niningigea, dumenimi eghá regeguturie, “Gururu re.” Kotú enembo dumeni regeguturie, “Anerami undú gaga reirie.” ");
INSERT INTO bjz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aghá regeguturieta, Iesu eghá ririe, “Ená beda ero nímandu rea retue, jo andú rambi re. ");
INSERT INTO bjz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Enembo irurarida fefera etia bubie. Kotú unona ená endada beforo righari embó bua fugota juraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kotú, númane, amó endava reta ifatarava righota eradora mo, enembo dano anona ghambugota andava fufugaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu aghá rirota, unda amburari daiyagha amburaita rouvia-nu isuri urie. ");
INSERT INTO bjz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aghade, natofo jedemi be fugia eghá regeguturie, “Námanda Agho Darinu isuri urota reaveta niningigeta rosora mo, ‘Embó eini, God da ninengota furari-du riria, umó tumanadu iraita rouvie.’ Atá Enemboda Jojabee* ifatarava righota erari gaa rera-du mana-mana urota reisi-rere, ‘Enemboda Jojabee mo avouvi?’” ");
INSERT INTO bjz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aghá regeguturieta, Iesu númandu mino eghá ririe, “Fefera tufoko, unana nemonde dano iraita rouvie. Amindu unanava deĩ egege, doadi-gea bingoimi furá nímane afuregauveta. Atá enembo avona, bingoiva deĩ rouvia, doda reiya, umó jo gia goghó ambi re. ");
INSERT INTO bjz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Amindu, nímane unana gaabee urota bubugadora aná, nímane unanada sasingu bee aita rosoravore.” Iesu, umó aná gaga aghá rea sidara ea, númane doa, ghosá ea aria nungiturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu ivata jojabebei dumeni dumeni númanda dibeva eaveta gigigeta urie-tago, númane jo umó gaabee egegambi eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aghá ueta, feroveta Aisaia da gefiria gagada bee enava isagha urie, aná evere: “Jojabee, gaga námanda ritara gaga, avona gaabee uta? Kotú avodava Jojabeeda ano irugutata gera?” Aisaia aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ená gaga númane gaabee egegambi uria-du, feroveta Aisaia rekago kambesi einiva eghá gefirie: ");
INSERT INTO bjz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Rourogo dibemi gigigea nenomi nundubuturota, neno kaverauve-degea, God na ririeta, númanda dibe soiki ea, neno nundubari sidara urie. Jo aghago ambi asua mo, númane neno kaverea númanda ari akokogo doasueta, God sonembasueta, jejebugasue.” ");
INSERT INTO bjz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia aghá riria-da bee mo, Iesu da durogha umó gerurie-gea, undú rea ririe. ");
INSERT INTO bjz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tago, Jiusi enembo oruabe númanda babarigari dumenide dano Iesu gaabee egeguturie-tago, enembo dumenidu jo isaghava regegambi re. Anada bee mo, rourogo Moses da Agho Dari Kaifa kakatomi* númane nghaĩ itari kambova* terauve-degea gaa regeguturia-du oru egegeturie. ");
INSERT INTO bjz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aghá urota-gea, enembomi númandu raga regegari-du egegeta urie. Tago God na númandu raga rari-du jo egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aghá-gea, Iesu na enembodu be jojabemi eghá ririe, “Enembo avona amó gaabee eta rouvia, umó jo anuka amonu gaabee ambi re. Avona amó ninenguturieta furera-gha dano gaabee eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kotú enembo avona amó gita rouvia, umó avona amó ninenguturieta furera beago, gita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Atá amó aná eto-bato unana aghago furere. Amindu rea, enembo avona amó gaabee eta rouvia, umó jo bingoiva irambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Enembo avona anda gaga ningia, jo gaabee ambi adua, umó jo anona irurambi aita rore. Anada bee mo, amó endava jo iruraita furambi re-tago, enembo sonembota jebuga bari-du furere. ");
INSERT INTO bjz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aghá-gea, umó avona amó injigha urota, anda gaga jo ningambi adua mo, ená anda rera gagami, fefera gombuva umó iruraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aghadu rea, amó anda nundubarimi ená gaga jo rambi re. Tago, Afa amó ninenguturieta furera, unona amó donu, kotú daiyagha rari-du riria-nu rere. ");
INSERT INTO bjz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aghá-gea, amó rei-gerore, God da donu riria-mi enembodu jebuga tumanadu irari bua furaita rouvie. Aghadu Afa na amó donu rari-du riria-nu rere. Kotú anda donu rera, aná dano gaa bee re,” Iesu aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Serigea Yari Banauda* dibeva fefera dabako irieta, ená enda doa kaverea, unda Afadava yarida fefera buburituria-nu, Iesu umó gerurie. Kotú unda natofo endava vitiria-nu Iesu na neno rururota vitirie. Aghá uta aria, unda ambubuturia feferava, unda neno bari jo doambi, irugea goghó urie. ");
INSERT INTO bjz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Fefera aghade, jama undari undidigutueta, Satan seibe Keriot embó Saimon da mendi ragaro Judas dava nundubari sembago, Iesu dubo ari-du, ututurie. ");
INSERT INTO bjz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Avore, God Afa eini-eini kotú ano dano Iesu du ututuria-nu undufa gerurie. Aghade, umó God Afadava reta endava furie-gea, kotú rekago, kaverea God Afadava yaita rouvia, beago umó gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aghá nundubea, umó undari doa erea, unda asugari etova kosugea tamo dufari bua abaguva dea biruru urie. ");
INSERT INTO bjz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Anada ambova, uvu bua tevova averegea, námane unda ambo nimbida eka seseghurota, unda abaguva tamo dufarimi dufita arie. ");
INSERT INTO bjz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Aghá uta aria, Saimon Pita dava buburiturieta, undú eghá ririe, “Jojabee, imó anda eka seghaita rora?” ");
INSERT INTO bjz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aghá riria-du, Iesu na mino eghá ririe, “Amó donu rora, imó gaita ea rei-jaritoravore. Tago ambova, indava isagha ata, gaita roravore.” ");
INSERT INTO bjz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aghá ririeta, Pita eghá ririe, “Tefo, anda eka inona mania seghata!” Ririeta, Iesu mino eghá ririe, “Amó imó seghambi adora, imó jo anda yaveroda eini irambi aita roravore.” ");
INSERT INTO bjz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Aghá ririeta, Pita na mino ririe, “Jojabee, avoreta, mania anda eka nuenembo seghata! Anda ingode beforode dano seghadi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aghá ririeta, Iesu mino ririe, “Enembo eini avona seibe umó uvu gutadua, unda tamo dano taubana aita rouvie. O umó deĩ adua, unda eka nuenembo seghasue. Kotú nímane ambo nimbi dano taubana re-tago, nímanda rorova eini jo taubana irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu seibe enembo avona umó dubo aita rouvia, gerurie-gea, amindu ririe, “Nímanda rorova embó eini jo taubana irambi re,” ");
INSERT INTO bjz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aghá rirota, námanda eka seghea sidara ea doa, unda asugari rekago bua asugea kaverea unda kambesiva aria, eghá ririe, “Amó oreki donu etora nímandava isagha rouvia?” rea niningurie. ");
INSERT INTO bjz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nímane andú, ‘Irugari Kato’ kotú ‘Jojabee’ regegeta rosoravore. Kotú aná gaa bee re. Aná amó re. ");
INSERT INTO bjz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Amó nimanda Jojabee kotú Irugari Kato re. Aghá re-tago, anona nímanda eka seghetore. Amindu nímane beago mino-mino nímanda eka seseghege! ");
INSERT INTO bjz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Anona donu nímandava beforo isagha ari yavi irugetora-nu gia, nímane mino-mino aghá egege! ");
INSERT INTO bjz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nímandu, amó gaa bee rere. Sabua* embómi unda barirari jo serigambi eta rouvie. Kotú aghi embómi, jo umó ninengetua embó serigambi eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Oreki ená yavi dano reisi-geroravore. Atá nímane aghá egegadora, nímane gangorogha iririgaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Iesu aghá rirota eghá ririe, “Atá ená gaga retora, nímane nanjogodu amó jo rambi re. Nímane anona gateguturera-nu, amó tanana urota vitere. Tago, donu Buka Seiva gefiria, aná gaa bee aita rouvie. Aná gaga evere: ‘Angá undari danode undidiguturera embómi, unona anda gitofo ea, amó injigha urie.’ ");
INSERT INTO bjz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aná yavi jo sirorambi irieta, amó nimandu rere. Amindu aná yavi furá siroruturota gigigadora mo, nímane, amó aná umó re nu, gaabee egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nímandu amó gaa bee rere. Enembo avona anda ninengota furaita rouvia aghi enembodu ‘Orokaiva’ rirota ghaito teno fugadua, umó andú beago ‘Orokaiva’ rirota, ghaito teno fugaita rouvie. Kotú avona andú ‘Orokaiva’ rirota, ghaito teno fugadua, umó God amó ninenguturieta furera-du beago, ‘Orokaiva’ rirota, ghaito teno fugaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Umó aghá riria-da ambova, Iesu unda neno rova mema jojago itatama urota isaghava ririe, “Amó nímandu gaa bee rere. Embó eini nímanda rorova vitia-mi, amó dubo urota, gitofoda ingova itaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iesu aghá ririeta, námane unda ambo nimbi dibe mino-mino gigiguturere. Anada bee mo, Iesu aná gaga avodu reiria, námane mana-mana egeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ambo nimbi eini Iesu da neno buta uria, Iesu gha takembea asumbea vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aghá uua-du, Saimon Pita na ingomi undú ivata urota uriga ari-du ririe, “Umó avodu reiria-nu, rea ningi!” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aghá ririeta, umó gosá ea aria Iesu dava takembuturota rea niningurie, “Jojabee, enembo avona imó dubo adu?” ");
INSERT INTO bjz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aghá ririeta, Iesu mino ririe, “Amó ená farava imbebegari itoko suriava ga degimbea avodu utadora, aná umó re.” Aghá rea doa, farava suriava ga degimbea, bua Keriot embó Saimon da mendi, Judas du ututurie. ");
INSERT INTO bjz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ututurieta, Judas aná farava rurua aghade, Satan undava terua asuguturie. Aghá urieta, Iesu na Judas du eghá ririe, “Imó donu aita rora, tutomi ege!” ");
INSERT INTO bjz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tago, Iesu bee dodu undú aghá riria, námane undari undidiguturota vitirera einimi, jo tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Atá Judas umó gurida kaifa kato-gea, banauda undari dumeni bari-du reiria, aĩ, makasi enembodu guri utari-du reiria, aghago nundubuturere. ");
INSERT INTO bjz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Avore, Judas farava bua bubua isaghava irueta, tumba riruturie. ");
INSERT INTO bjz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas arieta-gea, Iesu eghá ririe, “Enemboda Jojabeeda* durogha oreki isagha rouvie. Kotú God da durogha gari beago undava reta furá isagha aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Amó aghá urota, God da durogha enembomi gigiguturota, God beago undufa ata, Enemboda Jojabeeda durogha gari oreki enembo isagha ata enembo gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Anda sasingu, amó namonde fefera tufoko iraita rore. Atá nímane andú tava egegaita rosoravore. Tago Jiusi enembodu rirera aghagonu oreki nímandu rere: Amó niavo yaita rora, nímane jo yari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Atá agho dari reka anda rei-ututora evere. Mino-mino neno bubuge! Amó nímane neno rei-rurora dabako aghagonu, mino-mino neno bubuge! ");
INSERT INTO bjz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nímane mino-mino neno bubugadora mo, nímane anda ambo nimbi egegea vitera-nu, enembomi gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aghá riria-du, Saimon Pita na uriga urie, “Jojabee, imó niavo yado?” ririeta, Iesu mino ririe, “Amó niavo yaita rora, nímane jo oreki anda ambova furari inono irambi re. Tago, ambova nímane anda ambova fufugaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iesu aghá ririeta, Pita na uriga urie, “Jojabee, daiyagha ea, oreki amó inda ambova yambi ari gaa rere? Amó anda jebuga doa, indú rea, amburaita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aghá ririeta, Iesu mino eghá ririe, “Gaa bee, imó inda jebuga doa andú rea amburadora? Amó indú gaa bee rere. Kokora be dimbambi irota, fefera bakode imó, amó jo gambi gaa rea, kivu aita roravore!” ");
INSERT INTO bjz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Aghade, Iesu na námane, unda ambo nimbidu eghá ririe, “Mania neno mema egeguturota iririgata! God gaabee egeguturota, amogha dano gaabee egege! ");
INSERT INTO bjz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Anda Afada kambova too oruabe vitie. Amó avo yavá nímandu kambesi simbugaita rore. Atá aná gaga gavera irasua, amó jo nímandu rambi asire. ");
INSERT INTO bjz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amó ya, avo nímanda kambesi ea simbugea kaverea furá, namonde dano iririgaita rea, nímane unumbea bua, anda irari kambesiva yaita rore. ");
INSERT INTO bjz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kotú amó kambesi niavo reifera-da emboro nímane reisi-geroravore.” ");
INSERT INTO bjz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Aghá ririeta, Tomas na undú ririe, “Jojabee, imó doda yaita rera kambesi, námane jo gigigambi re. Amindu, námane emboro daiyagha gigiga?” ");
INSERT INTO bjz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aghá ririeta, Iesu mino eghá ririe, “Afadava yari emboro aná, amó re. Kotú gaa beeda ruru, aná amó re. Jebugada ruru beago, amó re. Afadava yarida emboro dabako bee, anda toova re, emboro eini tefo re. ");
INSERT INTO bjz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Amó gigigeta rosora-du rere, anda Afa beago gigigeta rosoravore. Amindu rea, oreki enava reta, ‘Námane God Afa gigigutare,’ regegadi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iesu aghá ririeta, Filip na mino eghá ririe, “Jojabee, námanda uno aná, God Afanu iruge, umó gigigore. Gigigadora, námandava inono aita rouvie!” ");
INSERT INTO bjz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Filip aghá ririeta, Iesu na mino eghá ririe, “Filip, amó namonde fefera yafabe iru-furu riare. Nímane amó daiyagha gigigea tanana egegambi roso? Enembo avona amó gita rouvia, umó God Afa beago gita rouvie. Amindu rea, mania ‘Afa, iruge gigigore,’ regegata! ");
INSERT INTO bjz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, amó Afa gha dano takembea vitere, kotú Afa beago angá takembea vitia-nu, gaabee asiravore.” Aghá rea doa, námandava eghá ririe, “Nímandu anda rera gaga aná jo gaga tofo anda irambi re. Aná Afa angáda gaga re. Anada bee mo, Afa angá takembea vitia-mi, buro tofo reta eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Afa angá amó danode takembea irita rora-nu, nímane tefo gaabee egegasiravore. O jo tefo gaabee egegambi adora mo, anda ivata anogha eaveta siroreta rouvia-nu gigigea gaabee egege! ");
INSERT INTO bjz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Aghá-gea, amó nímandu gaa bee rere. Amó gaabee adua enembomi, anda rora aghago, unona ivata anogha jojabebei dumeni aita rouvie. Kotú, amó oreki Afadava yaita rore. Amindu rea, ivata anogha dumeni anda eaveta siroreta rouvia aná ijoijokoko re. O unda aita rouvia aná, anda doa serigea, jojabebei aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Afada durogha andava isagha urota gigigari-du rea, nímane donu anda ragarova rea niningigadora aná, anona ata siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Atá, nímane eini-eini dodu anda ragarova rea niningigadora, amó aita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Aghá rirota, Iesu unda ambo nimbidu eghá ririe, “Nímane amó neno badora, anda agho dari ningia egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aghá egegadora, anona Afadava benunu ata, unona Sonemba Kato eini nímandu utota furá, nemonde tumanadu iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ená Sonemba Kato rera aná, gaa beeda Asisi re. Tamo firída uno eta rousua enembo, umó jo bari aghago irambi re. Anada bee mo, umó jo tanana ea gigigambi eta rousue. Tago, nímane umó reisi-geroravore. Anada bee mo, umó nemonde danode takembea, nímandava asugea iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Amó jo nímane doata babagha aghago iririgambi egegaita rosoravore. Amó kaverea nímandava furaita rore. ");
INSERT INTO bjz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Atá, fefera tufoko sidara adua, tamo firída uno eta rousua enembo amó jo rekago gigigambi aita rousue. Tago, nímanena amó gigigaita rosoravore. Amó jebuga iraita rora-mi, nímane beago jebuga iririgaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Atá, fefera aghade, amó angá Afa gha danode takembea vitera-nu, tanana egegaita rosoravore. Kotú eto-bato amó namonde danode takembea vitera aghagonu, nímane beago namonde danode takembea vitera-nu gigigea, tanana egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kotú enembo avona anda agho dari ningia ambo-ambo eta rouvia-mi, amó neno buta rouvie. Enembo avona amó neno buta rouvia, umó anda Afami neno buta rouvie. Kotú amó beago umó neno rururota, andufa undava isagha ata gaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aghá ririeta, Keriot embó Judas da akaumi undú eghá ririe, “Jojabee, imó daiyagha indufa námandava isagha urota, firída uno eta rousua enembo jo gigigambi ari-du reto?” ");
INSERT INTO bjz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aghá ririeta, Iesu na mino eghá ririe, “Atá enembo avona amó neno buta rouvia, unona anda irugari ningia kaifa aita rouvie. Aghá urota, anda Afami umó neno baita rouvie, kotú amó angá Afa gha furá undava bubua, namonde kambo too dabakova iririgaita rosore. ");
INSERT INTO bjz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Atá enembo avona, amó jo neno bambi adua, umó anda gaga jo ningia, aghago ambi aita rouvie. Ená gaga rera jo anda tofo irambi re. Afa amó ninenguturieta furera unda gaga re. ");
INSERT INTO bjz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Atá amó namonde irirota, nímandu ená gaga dano retore. ");
INSERT INTO bjz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tago ambova Sonemba Kato anda ragarova Afa na ninengota furaita rouvie. Unona eini-eini dano iruguturota, gigigaita rosoravore. Kotú anda rirera-de dano, unona iruguturota rekago nundubaita rosoravore. Sonemba Kato rera aná, Asisi Kakaradu rere. ");
INSERT INTO bjz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Atá, amó siriri ari nímandu utua doa yaita rore. Siriri aná anda tofo re. Aná siriri bee re. Jo tamo firída unonu eta rousua enemboda siriri ari ututa rouvia aghago irambi re. Donu siroraita rouvia-du, mania neno mema urota, oru egegata! ");
INSERT INTO bjz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Amindu, amó nímandu eghá retueta niningigetoravore, ‘Amó nimane doa yaita rore-tago, rekago kaverea nímandava furaita rore.’ Nímane amó neno bubugasira, amó Afadava yaita rora-du, nímane gangoro egegasiravore. Anada bee mo, Afa umó aná jojabe re, amó jo umongo irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Atá ená eini-eini dano jo sirorambi irieta, amó oreki sei nímandu retore. Anada bee mo, ambova sirorota-gea, nímane amó gaabee egegari-du rea, retore. ");
INSERT INTO bjz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kotú amó jo fefera yafabe nímandu gaga rambi aita rore. Anada bee mo, ená endada beforo righari aná reifie. Avotago unda ano jo anda anogha inono irambi re, amó jo unda rari ningari irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tago, amó God Afa neno buta rora-nu, tamo firída uno eta rousua enembomi gigigari-du rea, God Afa amó donu ari-du reta rouvia, aghagonu eta rore. Avoreta, erea fufuge, namonde amó ená kambesi doa igigore!” ");
INSERT INTO bjz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu na ririe, “Amó aná eto-bato ghavesi vaini da ruru aghago re. Kotú anda Afa umó eto-bato ghavesida kaifa kato aghago re. ");
INSERT INTO bjz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Fafatu nianami andava takembea, jo bee ambi eta rouvia, anda Afa na righia borea fugaita rouvie. Kotú fafatu nianami bee uradua, aná reka vitia bee oruabe righari-du rea, unona sendota boiri aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Seibe anda gaga reaveta nímane niningigeta urera-mi, seseghurieta nímanda neno roo taubana urie. ");
INSERT INTO bjz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Amindu, nímane namonde danode takembea iririgadora, amó beago namonde danode takembea iraita rore. Nímane reisi-geroravore, fatu eini unuka iradua, jo bee ambi aita rouvie. Tago, fafatu nianami ruruva ga iradua, aná bee righaita rouvie. Dabako aghagonu, nímane namonde danode takembea iririgadora, eto-bato fatu nianami bee righita rouvia aghago egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Amó aná ruru, nímane aná fafatu re. Atá, enembo avona angá danode takembea iradua, undava bee oruabe siroraita rouvie. Anada bee mo, anona nímane jo sonembambi adora, nímane nenuka eini-eini donu jo ata sirorambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Atá enembo avona angá danode takembea irambi adua, umó eto-bato fatu eini divegea fugeaveta gharasa eta rouvia aghago re. Fafatu aghago mane bua fugea doa, ivarimi dungeaveta evita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Atá, nímane namonde danode takembea iririguturota, anda gaga nímanda neno rova iradua mo, nímane eini-eini dodu uno urota benunu egegadora, anona nímandu utaita rore. ");
INSERT INTO bjz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nímane ghavesi bee righita rouvia aghagonu, urota iririgadora mo, nímane anda ambo-ambo rosora aghagonu, nendufa irugaita rosoravore. Aghá egegaita rosora-mi, God Afada duroghade unanade siroruturota, enembomi gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Eto-bato Afa amó neno buta rouvia aghagonu, amó nímane neno buta rore. Amindu nímane anda neno barida rova iririge! ");
INSERT INTO bjz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Atá amó anda Afada agho dari ambo-ambo urota, unda neno barida rova vitere. Dabako aghagonu, nímane anda agho dari niningigea ambo-ambo egeguturota, anda neno barida rova iririgaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Anda neno gangoro ari nímandava irari-du rirota, amó aná gaga retueta, niningigetoravore. Kotú, nímanda rova beago, gangoromi beda ea irari-du rere. ");
INSERT INTO bjz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Anda agho dari aná evere. Amó nímane neno buta rora aghagonu, mino-mino neno bubuge! ");
INSERT INTO bjz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Neno bari jojabe aná evere, eini eghago tefo re: avona unda kokomana neno bua goghó adua mo, unda kokomanadu rea, unda jebuga doa ututurota amburasua, aná taubana re. ");
INSERT INTO bjz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Atá nímane anda agho dari rera aghagonu egegadora, nímane anda kokomana egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","‘Nímane aná anda buro kakato,’ reta rore-tago, oreki mo, ‘Nímane anda kokomana,’ raita rore. Anada bee mo, buro kato unda beforo righarida buro dano jo gia goghó ambi eta rouvie. Afa andava donu riria aná dano ririeta, nímane niningigutureravore. Amindu rea, ‘Nímane anda kokomana re,’ rere. ");
INSERT INTO bjz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nímanena jo amó gategambi re. Anona nímane gateguturere. Ari-bari taubana kotú yavi beenu urota iririgadi rea, nímane gateguturere. Amindu rea, anda ragarova nímane dodu benunu egegadora mo, Afa na utota bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Avore, agho dari ená anda retora-nu, rekago rere: nímane mino-mino neno bubuge!” ");
INSERT INTO bjz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iesu na eghá ririe, “Nundubea gigige! Enembo avona firída uno eta rousua-mi, sei amó injigha egeguturie. Amindu, ená enembo rera-mi, nímane injigha egegadua-du, rourogo mana-mana egegara-degea rere. ");
INSERT INTO bjz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nimane ya, ená enembo rera-de dano takembasira, númanda tofo gaa rea nímane neno bubugasue. Anada bee mo, nímane númanda dumeni ea iririgasiravore. Nímane sei númanda tofo vitaravore-tago anona nímane gateguturieta, oreki, nímane jo ená endada tofo irambi re, nímane airo viteravore. Amindu, ená enembomi nímane injigha egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sei amó nímandu daiyagha rirera ananu nundubadi rere! Aná evere: ‘Beforo righari umó bingáde re. Unda sabua* umó bingá tefo re.’ Amindu rea, númane andú mema bouvu fakarago ututuria aghagonu, nímandu mema bouvu bee fakarago utaita rousue. Kotú númane anda irugari niningigasua mo, nímanda irugari beago niningigasue. ");
INSERT INTO bjz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kotú nímane anda natofo ea vitera-du, nímandava mema bouvu ututugaita rousue. Anada bee mo, God Afa amonu ninenguturieta furera aná, númane jo gia tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Amó jo furá aná enembo retora-du minono rata niningigambi asua, God jo númandu, ‘ari-bari sembago enembo’ rambi asue. Tago oreki amó furera enembo avodu minono rirera, númanena emboro einiva rea serigari goroto tefo re. ");
INSERT INTO bjz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Avona amó injigha eta rouvia-mi, anda Afa beago injigha eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Aghá re-tago, gaga eini aná evere. Amó ivata anogha dumeni enembo avona jo ambi uria-nu, númanda rova ambi asira mo, God jo númandu, ‘ari-bari sembago enembo’ rambi asue. Avotago, oreki númane anda ivata anogha gigiguturie-tago, númane anda Afa angá mo, dano injigha eta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Númane námane injigha egegeta rousua-da bee mo, númanda Agho Dariva daiyagha gefiria ananu, gaa bee ari-du rea, eta rousue. Agho Dari anda rera, riria aná evere, ‘Númane amó injigha egegeta uria-da bee eini tefo re.’ ");
INSERT INTO bjz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Atá Sonemba Kato retora aná, Gaa Bee Ari da Asisidu retore. Umó anona Afadava reta ninengota furá bubua, anda daiyagha aita rora-nu unona irugota niningigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Niningigea, nímane beago andava donu niningiguturera-nu minono regegaita rosoravore. Anada bee mo, tutunova amó namonde danode takembea furere.” ");
INSERT INTO bjz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iesu gaga rirota, eghá ririe, “Amó ená gaga nímandu rera-da bee mo, rourogo nímanda gaabee ari doata ya sidara auva-degea rere. ");
INSERT INTO bjz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Enembo nímandu injigha urota, nghaĩ itari kambovareta* tuvota isaghava bububugaita rosoravore. Kotú, fefera furá bubota, avona nímane dasueta amburasira, umó eghá nundubaita rouvie, ‘Amó aghá urota, God da uno, kotú unda buro beenu rore,’ raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Númane ari-bari eghá egegota siroraita rouvia-da bee mo, númane Afa jo gambi, kotú amó beago jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amó nímandu ená gaga rera-da bee mo, fefera furá bubota, ari-bari aghago mane siroruturota gigigadora, amó seibe nímane nghaĩ ituturera-nu nundubaita rosoravore. Amó tutunova namonde danode vitare. Amindu, ená gaga jo seibe nímandu rambi re. ");
INSERT INTO bjz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Oreki amó kaverea, avona amó ninenguturieta furera-dava yaita rore. Atá, nímane eini avona andava uriga urota, ‘Imó niavo yado?’ jo rambi viteravore. ");
INSERT INTO bjz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Avore, amó ená gaga retora-mi, nímanda neno roo memami beda rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tago, amó nímandu gaa bee rere. Nímanda taubanadu rea, amó nímane doa yaita rore. Amó jo yambi asira mo, Sonemba Kato jo furambi asue. Tago amó yaita rore-gea, anona ninengota Umó furá nimonde iraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Atá Umó furadua, Unona endava enembo tamoda uno urota, daiyagha gaga dano bakodeda bee kasovigea vitia-nu irugota gia tanana egegaita rousue. Aná gagada bee evere: ari-bari sembago mo doro, irari taubana avona eta rouvia, kotú God daiyagha enembo iruraita rouvia-de dano, irugota gia, tanana egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aghá urota, númane ari-bari sembagoda bee kasovigea vitie, retora mo, Sonemba Kato furá iruguturota, númane amó jo gaabee egegambi urota, ari sembago bee egegeta rousua-nu, tanana egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Gaga eini kasoviguturia aná evere, irari taubana avona eta rouvia, númane jo tanana ambi vitie. Amó kaverea, Afadava yata, nímane amó jo gigigambi egegaita rosora-du Sonemba Kato retora-mi ambova furá, anda ari taubana eta rora-nu, unona iruguturota, númane gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kotú eini kasoviguturia aná, irurarida fefera jo gigigambi re. Avore, God na ená endada barirari, Satan, seibe iruruturia-va, umó jo serigambi-nu Asisi Kakara mi iruguturota gigigaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Amó gaga oruaruabe nímandu rasire-tago, dano oreki radora, nímane jo bari inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tago, God da gaga bee irugeta rouvia Asisi furá bubadua mo, Unona irugota, nímane gaa bee dano niningigaita rosoravore. Avotago, Undufa Unda gaganu jo rambi aita rouvie. Umó gaga donu ningadua, aná nuenembo rirota, fefera ambova daiyagha siroraita rouvia beago, raita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Andava donu ningadua-nu unona bua nímandu irugaita rouvia-mi, durogha gari bua andú utaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Eini-eini Afadava vitia aná dano, anda tofo re. Aghadu rea, amó retore, ‘Anona donu Asisi dava utaita rora-nu bua, nímandu irugaita rouvie.’” aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Anada ambova, Iesu eghá ririe, “Fefera tufoko nímane jo amó gigigambi egegaita rosoravore. Kotú fefera tufoko irirota, anada ambova, rekago amó gigigaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aghá ririeta, námane mino-mino uriga eghá egeguturere, “Gaga eghá retua-da bee mo doro? ‘Fefera tufoko, nímane jo amó gigigambi egegaita rosoravore. Kotú fefera tufoko irirota, anada ambova, rekago amó gigigaita rosoravore.’ Aghá rirota, gaga eini eghá retue. ‘Anada bee mo, amó Afadava yaita rore,’ retue. ");
INSERT INTO bjz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Umó ‘fefera tufoko’ retua-da bee mo, doro? Umó dodu retua, namonde amó jo tanana ambi rosore.” ");
INSERT INTO bjz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Námane mino-mino aghá rirota, námanda uno undava rea niningigaita ueta, Iesu seibe gerurie-gea eghá ririe, “‘Fefera tufokoda rova, nímane jo amó gigigambi egegaita rosoravore. Kotú fefera tufoko irirota anada ambova, rekago amó gigigaita rosoravore.’ Aghá retora-du, mino-mino uriga rosora? ");
INSERT INTO bjz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Amó nímandu gaa bee rere. Nímane neno mema tafirota, jiiji regeguturadi-gea, tamoda uno eta rousua enembomi gangoro egegaita rousue. Tago ambova, nímane gangoro egegaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Evetuda fumbari fefera furá utuva uradua, umó mema itatama aita rouvie. Anada bee mo, soká bari da fefera bubia-du, mema tambaita rouvie. Tago, unda soká siroretua-du, unda mema neno itia, gangoro aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eto-bato aghagonu, nímane oreki neno mema egeguturota viteravore. Tago, amó furá nímane tambota, nímane gia, neno roo gangoromi beda egegaita rosoravore. Ená gangoro rera, enembo eini avona nímandava jo rougea bambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Fefera aghade, nímane andava eini-einidu jo benunu egegambi aita rosoravore. Amó nímandu gaa bee rere. Nímane anda ragarova eini-eini dodu benunu egegadora, anda Afa na utota bubugaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tutunova reta furia, oreki nímane eini-eini dodu anda ragarova jo benunu ambi viteravore. Benunu egege, God na utota bubugadi-gea, nímanda neno roo gangoromi beda ae! ");
INSERT INTO bjz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sei amó gaga kasia reaveta niningigeta egegutaravore. Tago, fefera furá bubadua, amó gaga jo kasiami rambi aitare. Amó anda Afada irari nu isaghava irugota, niningigaita rosoravore. ");
INSERT INTO bjz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Atá aná fefera bubadua, anona nímandu rea, Afadava benunu jo ambi aita rore. Anada bee mo, nímane nendufako anda ragarova Afadava benunu ari inono re. ");
INSERT INTO bjz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Anada bee mo, amó Afadava reta furera-nu, gaabee egeguturota, nímane amó neno bubugeta rosora-du rea, Afa undufa nímane neno buta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Amó Afadava reta furera, ená endava siroruturere. Kotú, amó ená enda doa kaverea Afadava yaita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","30","Aghá ririeta, námane eghá regeguturere. “Oreki, imó kasia doa, gaga isaghava rieta, námane reisi-niningore. Tago, indava dodu uriga egega? Námane dodu uriga asira, aná imó seibe gari re. Aghá-gea, imó God dava reta furera-nu námane gaabee rosore.” ");
INSERT INTO bjz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aghá regeguturieta, umó mino eghá ririe, “Amindu rea, oreki nímane amó gaabee rosora, aĩ? ");
INSERT INTO bjz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Fefera refago etia bubie. Nímane dano, amó doa, oru susumbugea, andivea ya, nímanda naa ari naa ari iririgaita rosoravore. Aghá egegea, amonu doata, anuka jiraitare. Tago, amó jo anuka irambi aitare. Anada bee mo, angá Afa gha dano vitere. ");
INSERT INTO bjz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ená gaga retora-da bee, aná evere: nímane andava takembea iririguturota, siriri bubugadi rere. Ená endava, anda gitofomi nímandava dara dumeni urota, mema tatambugaita rosoravore. Tago, ano egege! Ená endada ano nanjogo dano, anona seibe fatia jiregetore.” ");
INSERT INTO bjz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aghá rea sidara urota, Iesu dibe jará ea uutuva urota, eghá ririe, “Afa, fefera etia bubieta, inda duroghanu andú bofu-gea bare. Aghá uradi-gea, inda duroghanu anona isaghava irugota gigiguturota, enembomi indú raga regegoe! ");
INSERT INTO bjz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Angá anda durogha gigigari-du rea, amó enembo nanjogoda Jojabee ari-du rireravore. Aghá rirera-da bee mo, inda andú ututurera enembonu, anona sonembota jebuga tumanadu irari bububugari-du rireravore. ");
INSERT INTO bjz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tumanadu irari jebuga barida emboro mo, evere. Enembo avona, imó God bee rirota, inda ninenguturieta furera Mendi Iesu Keriso amonu gigigea tanana egegadua mo, jebuga tumanadu irarinu bubugaita rousue. ");
INSERT INTO bjz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inda andú ututurera buro dano urieta sidara uria-mi, amó inda durogha irugeaveta, endava enembo gigigeta urie. ");
INSERT INTO bjz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Afa, oreki amó inda dibeva jiria irirota, anda durogha utadi baita rere. Enda jo sirorambi irieta, seibe amó duroghagha vitirera-da durogha dabako ananu rekago utadi baita rere. ");
INSERT INTO bjz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ená endava vitiria enembo nanjogo inona gia gategea, andava ututurieta, imó avouro anona iruguturieta gigiguturie. Númane aná inda tofo reta, inona andú ututureravore. Kotú númane inda gaga niningigea, aghagonu egegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Eini-eini inda andú ututurera, aná dano indava reta furia-nu, númane gigiguturota, tanana rousue. ");
INSERT INTO bjz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Anada bee mo, inda andú ututurera gaganu amó seibe ririeta, númane niningiguturie. Kotú inona amó ninenguturieta furera-nu, númane gia, tanana ea gaabee rousue. ");
INSERT INTO bjz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amó númandu rea, oreki benunu rore. Endada uno eta rousua enembodu, amó jo benunu ambi re. Tago, inda andú ututurera enembodu benunu rore. Benunu rora-da bee mo, númane aná inda tofo re. ");
INSERT INTO bjz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Anda natofo dano inda tofo re. Kotú inda natofo beago dano anda tofo re. Kotú anda durogha númane irugeaveta isagha eta rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Amó ená endava jo irambi aitare. Oreki amó kaverea, indava yaita rore. Tago, númane eve endava doa yata iririgaita rousue. Aee, Afa, inda ragaro kakarada anomi, númane kaifa adi rere. Angá neno dabako ea vitera aghago, inda andú ututurera ragaromi kaifa uradi númane furá danode takembea, neno dabako egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ená endava amó namonde dano irirota, inda ragaro andú ututurera-da anomi, númane kaifa riare. Anona númane kaifa uaveta, dumeni dano emboro jo kasovigambi, inonova irita ria. Tago, inda Buka seiva embó dabako emboro kasovigasua reiria aghagonu urota, aná embó dabako jebugada emboro rei-kasovigetue. ");
INSERT INTO bjz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oreki, amó indava yaita rore. Atá, amó eve endava irirota, benunu indava rera-da bee mo, númane niningigea, númanda neno roomi, anda gangoro itatama urota, gangoromi neno roo beda egegari-du rere. ");
INSERT INTO bjz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Inda gaga, amó ututurieta númane niningigea bua righia, iririgutueta, tamoda uno ari enembomi númandu injigha egeguturota vitie. Anada bee mo, amó tamoda uno eta rousua enembode jo neno dabako ambi vitera aghagonu, númane beago aná enembode jo neno dabako ambi vitie. ");
INSERT INTO bjz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amó jo, númane ená endavareta doa badi benunu ambi re. Anda uno mo, rourogo doadi-gea ari-bari akokogoda numamomi furá númane kuvirauve-degea gangada adi, benunu rore. ");
INSERT INTO bjz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Anada bee mo, amó tamoda uno eta rousua enembode jo neno dabako ambi vitera aghagonu, númane beago aná enembode jo neno dabako ambi vitie. ");
INSERT INTO bjz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Inda Gaga, aná dano gaa bee re. Inda Gaga beeda anomi númanda neno roo simbugea, númane inda tofodu badi rere! ");
INSERT INTO bjz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Inona amó ninenguturieta, endava enemboda rorova vorefurere. Eto-bato aghagonu anona ninenguturieta, númane enemboda rorova igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Númanda neno roo daiyagha simbugea indava ututugasua-nu nundubuturota, amó anda neno roodemi indava rei-ututore. ");
INSERT INTO bjz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Avore, anda ambo nimbi eve desea vitia nuenembodu, jo benunu ambi re. Aná ambova númanda minononu niningigea, gaabee egegaita rousua enembodu beago, benunu rore. ");
INSERT INTO bjz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Anda benunu rera mo, númane neno dabako egegari-du rere. Eto-bato imó angá danode takembea vitera aghagonu, númane beago namonde danode takembea iririgari-du benunu rore. Aghá egegadora mo, endava enembomi gigigea, inona amó ninenguturieta furera-nu, gaabee egegaita rousue! ");
INSERT INTO bjz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Imó angá danode takembea, neno dabako ea vitera, aghagonu egegari-du rea, inda durogha andava ututurera dabako ananu, númandu ututurieta bubugea vitie. ");
INSERT INTO bjz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Amó ená enembo daba-dabade dano takembea vitera aghagonu, kotú angá beago danode takembea, neno dabako ea vitera aghagonu, númane mino-mino takembea, neno dabako ea goghó egegari-du uno rore. Anada bee mo, aghá egegadua mo, endava enembomi gigigea, inona amó ninenguturieta furera-nu, kotú amó neno buta rora aghagonu, anda natofo beago neno buta rora-nu tanana egegaita rousue! ");
INSERT INTO bjz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Afa, amó kambesi niavo iraita rora anava, ená andú ututurera enembomi namonde danode irirota, anda duroghade unanade gigigari-du rere. Aná durogha mo, uutu enda uubu urera-da dibe kenava amonu neno rururota, ututurera duroghadu rere. ");
INSERT INTO bjz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ariee, Afa, imó taubana bee re. Endava enembo tamoda unonu egeguturota, imó jo tanana egegambi re. Tago, amó imonu tanana rore. Inona amó ninenguturieta, furera-nu, ená enembomi gia tanana rousue. ");
INSERT INTO bjz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Inda, amó neno buta rora neno dabako anami númandava irari-du, kotú, amó numonde iraita rirota, imó avouro irugeta urere, kotú irugaita rore.” Iesu benunu aghá urie. ");
INSERT INTO bjz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu benunu rea sidara uria-da ambova, umó námane unda ambo nimbide arera, Kidron kava vorea rekimbuturere. Aná kava yoveniva aayo eini ika olivi govari irieta, námane anava teteruguturere. ");
INSERT INTO bjz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Avore, Iesu bua gitofoda ingova itituria embó ragaro Judas, umó námanda eini re. Námane fefera oruabe Iesu de deĩ egeguturota iiava, aná kambesiva danode deseta urere. Aghá-gea, umó aná kambesi gari re. ");
INSERT INTO bjz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amindu, Judas na kofiri ea, noni ungagha bua furie. Noni eini, aná Rom enemboda mene-mene ari kakato re. Kotú noni eini mo, fristida* kokotofude, Moses da Gaga kaifa kakatodemi* Tafaroro Ari kamboda* kaifa kakatonu ninenguturieta fufuguturie. Númane aivade giberede nanefadenu bubugea furia bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu undava donu siroraita rouvia, umó seibe gerurie-gea, aná enembodava irurota eghá ririe, “Nímane avonu tava roso?” ");
INSERT INTO bjz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aghá ririeta, Iesu gitofoda ingova utituria embó Judas avo numonde jijiregea, númane mino eghá regeguturie, “Nasaret embó Iesu du tava rosore,” ririeta, “Amouvie.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aghá rieta, númane ambomi aria, endava jujuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aghá egegutueta, Iesu na númandu rekago uriga urie, “Nímane avodu tava roso?” ririeta “Nasaret embó Iesu du tava rosore,” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aghá regeguturieta, Iesu ririe, “Amó seibe nímandu retore. Nímanda tava rosora embó aná amó re. Nímane andú tava urota mo, anda ambo nimbi do-gea, igigoe!” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Umó aghá rieta, unda gaga eini seibe riria-nu gaa bee uria, aná evere. “Afa, inda andú utora enembo eini jo jebugada emboro kasovigambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aghade, Saimon Pita na unda kaiyanu ghorugea bua, fristida beforo righarida buro katoda nghaĩ ingo bee kena kositurieta jujururie. Aná buro katoda ragaro Malkus re. ");
INSERT INTO bjz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aghá urieta, Iesu na Pita du eghá ririe. “Inda kaiya rekago voruva sine, voroe! Memada aagha Afada andú rei-ututua, amó doari aghago mania nundubata, aná amó undaita rore.” ");
INSERT INTO bjz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aghá riria-da ambova, mene-mene ari kakato númanda beforo righaride, Jiusi enemboda Tafaroro Ari Kambo da kaifa kakatodemi Iesu nandia bunditurie. ");
INSERT INTO bjz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bundia bua, sei Anas dava igiguturie. Anas umó aná Kaiafas da ato re. Kaiafas, umó aná ghaekova fristi* maneda beforo righari ea vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiafas rera, unona seibe Iesu dedegota amburari-du nundubuturota, Jiusi enemboda babarigaridu eghá ririe, “Enembo oruaruabeda ragarova, embó dabakomi amburadua, aná taubana re!” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Iesu da ambo nimbi einimi Saimon Pita gha dano Iesu da ambova arie. Avore, aná ambo nimbi einimi fristida* beforo righarida ghouka rova teterurie. Anada bee mo, aná ambo nimbi umó fristida beforo righari seibe tarama ari re. ");
INSERT INTO bjz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Tago, Pita umó bebato beva jiria, kaifa ueta, aná fristida beforo righarigha sei tarama ari-gea ambo nimbimi bebato kaifa ari ariridava rea ningia, Pita unumbea ungá terua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Unumbea teterueta, bebato kaifa ari aririmi gerurie-gea eghá ririe, “Imó oná embóda ambo nimbi eini re,” Aghá ririeta, Pita na mino, “Tefo, jo amó irambi re.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aghade yaura uua-du, buro kakatode Tafaroro Ari Kambo da kaifa kakatode ivari bua furia gagembea evirota, eka ingo masiturota jijiregea irieta, Pita beago aria, numonde jijiregea irirota, ivari evirota vitirie. ");
INSERT INTO bjz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Aghá ueta, fristida* beforo righarimi Iesu unda ambo nimbidedu, kotú unda irugeta uria gagadu undava uriga urie. ");
INSERT INTO bjz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aghá ririeta, Iesu mino ririe, “God Du Tafaroro Ari Kambova*, nghaĩ itari kambova, kotú Jiusi enembo niavo-niavo fuava danode deseaveta, amó natofo jededu gaga isaghava reta riare. Aghade gaga kivumi jo rambi re. ");
INSERT INTO bjz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Agharanu, dodu andava uriga ro? Enembo avona anda gaga niningigeta rosa-dava uriga egege! Anda gaga númanena niningigea tanana rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aghá ririeta, kaifa kato eini avo jiria vitiria-mi Iesu oofova derurota eghá ririe, “Mania fristida* beforo righari-du aghá rata!” ");
INSERT INTO bjz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aghá ririeta, Iesu mino ririe, “Amó gaga akuago donu ritara-nu rege, enembo dano niningigoe! Tago, amó gaabee nuenembo reta rore. Atá imó dodu amó deto?” ");
INSERT INTO bjz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anada ambova, Iesu erimi bundituria aghá irieta, Anas na umó ninenguturieta, Fristida beforo righari Kaiafas dava arie. ");
INSERT INTO bjz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita, umó aghá jiria, ivari evirota irieta, enembomi gigigea, “Gaa bee re, imó aná embóda ambo nimbi eini re,” Aghá ririeta, umó kivu urota, “Tefo, jo amó irambi re.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Fristi maneda beforo righarida buro katoda nghaĩ Pita unda vegea kosituria-da ikoko mendi einimi Pita du eghá ririe, “Imó aná embógha dano aayo rova gere.” ");
INSERT INTO bjz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aghá ririeta, Pita rekago kivu urota, “Tefo” ria, aghade kokora be difirie. ");
INSERT INTO bjz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rifo atitueta, Jiusi enembomi Iesu Kaiafas da kambova reta bua aria, Rom enemboda kotofukoda kambo jojabeva buburiturie. Rourogo bebeta egegea, Serigea Yari Banauda* undari undambi auve-degea, Jiusi enemboda babarigari jo aná kotofuda kambova teterugambi re. ");
INSERT INTO bjz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Aghá egeguturieta, aná kotofuko ragaro Pailat na bubua furia, númandava uriga urie, “Ená embó dara donu etueta, bua fufugeto?” ");
INSERT INTO bjz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aghá ririeta, númane gaga mino eghá regeguturie, “Umó dara eini ambi asua, námane umó jo bua, indava furambi asire.” ");
INSERT INTO bjz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aghá regeguturieta, Pailat na mino ririe, “Avoreta ená embó bubugea, igige! Nímanda agho dariva daiyagha rari vitia anava gigiguturota, nendufa koto egegadi!” ririeta, Jiusi enemboda babarigarimi eghá regeguturie, “Námane koto urota, dinunu da mino dibe eini be eini ututugasueta itatama asue-tago, Rom enemboda barirari, námandu enembo data amburarida ano jo utambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Avore, Iesu umó daiyagha amburaita rouvia gaga undufa iruguturia-da bee sirorari-du rea, God na ririeta, númanda gaga aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat kaverea aria, kambo rova terua ririeta, Iesu furieta uriga urie, “Imó Jiusi enemboda kini ra?” ");
INSERT INTO bjz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Uriga aghá urieta, Iesu mino ririe, “Ená uriga inda tofo ra, aĩ, enembo dumenimi retueta ningia uriga rora?” ");
INSERT INTO bjz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ririeta, Pailat na eghá ririe, “Imó rei-nundubutora, amó Jiusi enembo eini ra? Inda totofo Jiusi enembode inda fristida* kokotofudemi imó bua etia, andava ututugetue. Rege ningore! Imó dinunu donu eto?” ");
INSERT INTO bjz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aghá ririeta, Iesu eghá ririe, “Anda kaifa aita rora kambesi jo ená endava irambi re. Atá amó ená roo endada tofo irasira mo, Jiusi enembomi amó nanadigauve-degea, anda natofomi andú rea mene-mene egegasue. Tago anda kambesi jo enava irambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aghá ririeta ningia, Pailat uriga urie, “Gaa bee, imó aná kini eini ra?” Ririeta, Iesu undú eghá ririe, “Eẽ, inda rera aghago re. Gaa bee nuenembo irugaita rea, amó furera ená endava siroruturere. Anda gaga niningigea gaabee egegeta rousua enembo aná, númane anda natofo re.” ");
INSERT INTO bjz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aghá ririeta, Pailat na uriga urie, “Gaa Bee mo doro?” Aghá rea doa, Pailat kaverea aria, isaghava bubua, Jiusi enembodu eghá ririe, “Amó undava dara eini jo tambambi re. Umó bua koto ea data amburarida bee eini tefo re. ");
INSERT INTO bjz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tago, nímanda evovova vitie, Serigea Yarida Banauva*, dibura embó eini avonu uno egegarinu doaveta bubuta rouvie. Aghá-gea, nímanda uno mo, Jiusi enemboda kini doata isaghava bubadua?” ");
INSERT INTO bjz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aghá ririeta, númane dano aregea farara urota koko fugia regeguturie, “Tefo, umonu mania utata! Námandu Barabas nu bofu!” regeguturie. (Atá Barabas umó bagia embó re.) ");
INSERT INTO bjz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aghá regeguturieta, Pailat na Iesu bua aria, unda mene-mene ari kakatodu ririeta, erimi Iesu fisuruturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Fisuruturia-da ambova mene-mene ari kakatomi kini da kasavago urota, ika fatu gingidemi keifi ea beforova asuguturie. Aghá ea, kini mane da asugeta uria eembo aghago eini, gaduna tamo kotú yafabemi bua, undava asuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aghá ea, númane umó kuvia gegha rirota, “Orokaiva! Jiusi enemboda kini, buberavore! Orokaiva!” rekago rekago regeguturota iiava, umó dibe beva deta urie. ");
INSERT INTO bjz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Aghá egegutueta, Pailat rekago kaverea isaghava bubua, eghá ririe, “Gigige! Undava dara eini amó jo tambambi re. Aghá-gea, amó rata, umó furá isaghava bubaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iesu aná eembo gaduna tamo asugea, ghavesi giidemi keifi ea, nanamu uria-nu asugea, isaghava buburiturieta, Pailat na “Gigige! Aná embó evere!” ");
INSERT INTO bjz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aghá ririeta, fristida* kokotofude, God da kambo kaifa kakatomi Iesu gigigea, koko-koko regeguturota, “Umó ifatarava dege, amburoe! Umó ifatarava dege, amburoe!” regeguturie. Ririeta, Pailat mino ririe, “Avoreta nendufa bua igige, ifatarava dedegadi! Atá, amó andufa undava dara eini jo tambambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aghá ririeta, Jiusi enemboda babarigarimi titinigha regeguturie. “Námanda Agho Darimi umó amburari-du reirie. Anada bee mo, umó undufa, ‘Amó God da Mendi re,’ reta urie.” ");
INSERT INTO bjz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aghá regegutueta ningia, Pailat umó be orumi jariturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ea, Pailat rekago kaverea terua, kambo rova aria, Iesu dava uriga urie. “Imó doda reta fure?” ririe. Tago, Iesu gaga mino jo rambi re. ");
INSERT INTO bjz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aghá urieta, Pailat na ririe, “Andú gaga eini rari uno ambi rora? Gigo, imó ifatarava data amburari, o doata yarida ano andava vitie.” ");
INSERT INTO bjz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aghá ririeta, Iesu mino ririe, “Inda aghá retora-da ano aná God na indú ututurie. Aghadu rea, enembo avona amó bua, inda ingova utua-da ari-bari aná akuago bee re.” ");
INSERT INTO bjz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Iesu aghá ririeta, Pailat ningia kaverea aria bubua, Iesu doata yari-du emboro tava urie. Tago, Jiusi enembo be koko fugia eghá regeguturie, “Imó Iesu doata yadua, imó jo nímane Rom enemboda kotofuko, Sisar da komana irambi re. Anada bee mo enembo avona, ‘Amó kini re,’ radua, umó nímanda kotofuko Sisar da gitofo aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aghá ririeta ningia, Pailat na ririeta, Iesu furia, isaghava buburiturieta, Pailat umó natofo irurarida avo asumbariva asumbuturie. Unda koto eta uria-da avo asumbuturia kambesida ragaro, aná “Kafai Singoimi ea Simbugari re” o Jiusi enemboda gaami “Gabata” regegeta rousue. ");
INSERT INTO bjz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Serigea Yari Banaudu* simbugutua-da feferava, fefera beforo tova ueta Pailat aria, anava asumbuturie. Pailat na Jiusi enembodu “Nímanda kini evere.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aghá ririeta, númane ininigha koko regeguturota, “Bua igige, bua igige, ifatarava dedegadi! Umó ifatarava dege, amburoe!” aghá regeguturieta, Pailat na mino eghá ririe, “Amó rata, nímanda kini bua ya, ifatarava dedegadua?” aghá ririeta, fristi maneda kokotofumi eghá regeguturie, “Kini eini tefo re. Námanda kini dabako Rom enemboda kotofuko, Sisar re.” ");
INSERT INTO bjz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Aghá regeguturia-da ambova, Pailat na Iesu nu bua, ifatarava dedegota amburari-du rirota, mene-mene ari kakato dumenida ingova ututurieta bubuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Aghá urota, Iesu unda ifatara undufa fumbua arie. Aria, kambesi eini Amburari Enemboda Beforo Siruru avo buburiturie. O námane Jiusi enemboda gaami aná kambesidu Golgota regegeta rosore. ");
INSERT INTO bjz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Furia, avo bubua, Iesu ifatarava dedeguturie. Aghade, embobo ungagha Iesu de dano dedeguturie, eini ingo bee kena, eini ingo anda kena. ");
INSERT INTO bjz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aghá urieta, Pailat na gaga eini gembua ututurieta bua aria, Iesu da ifatarava derurie. Gaga aná evere: Ená mo, Nasaret Embó Iesu, Jiusi Enemboda Kini Re. ");
INSERT INTO bjz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jiusi enembo oruaruabemi aná gaga iruguturie. Anada bee mo, aná kambesiva reta ya, Jerusalem bogu naava bubari jo airo bee irambi re. Aná gaga mo, aná Rom enemboda gaami, Grik enemboda gaami, kotú Jiusi enemboda gaami gefirie. ");
INSERT INTO bjz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Enembo oruaruabe aná gaga irugutueta, fristi* maneda kokotofumi aria, Pailat du eghá regeguturie. “Mania ‘Jiusi Enemboda Kini Re,’ rata! Ená embómi undufako, ‘Amó Jiusi Enemboda Kini Re,’ reta urie. Aghá gembu!” ");
INSERT INTO bjz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aghá regeguturieta, Pailat na númandu ririe, “Tefo, anda donu gembera ananu gembere. Do, aghá iroe!” ");
INSERT INTO bjz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Iesu ifatarava deruria-da ambova, mene-mene ari kakatomi unda eembo boo bua, dibe ungagha-ungagha ititigea vesa ea, unda unda bubuguturie. Unda asugari numbobe ukovareta voria, eka tumo bubariva, begaro eini tefo re. ");
INSERT INTO bjz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aghá-gea, aná mene-mene ari kakato mino-mino eghá rea niningiguturie, “Namonde jo kisorambi aita rosore. Kikindo gaegegore! Avona badua, unona baita rouvie,” regeguturie. Aghá urota, God da donu riria, aná gaa bee uria, aná evere: “Anda eembo boo unda unda vesa ea bubuguturie. Anda tamo asugari numbobenu baita rea, kikindo gaegeguturie.” Aghá egegutueta, ");
INSERT INTO bjz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu da ifatara kasava jijiregea vitiria, aná unda nue, kotú nueda rao, Klopas da evetu Meri, kotú Makdala ariri eini unda ragaro beago Meri re. ");
INSERT INTO bjz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Unda nueda kasava, unda neno buta uria ambo nimbi avo jiria irieta gerurie-gea nuedu eghá ririe, “Aya, inda mendi avore.” ");
INSERT INTO bjz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aghá rea doa, kotú ambo nimbidu ririe. “Nie avore,” ririeta, aná ambo nimbimi nue bua aria, unda kambova kaifa eta urie. ");
INSERT INTO bjz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Umó donu asua-nu urieta inono uria-du, Iesu gaga eini God da bukava vitia-da bee sirorari du rea, eghá ririe, “Amó ukó sarai etue.” ");
INSERT INTO bjz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vaini kaeenu kofiriva averege avo itari vitirieta-gea, embó einimi ika eini ragaro hisof da fatumi bua, eini-eini ofusa mokogonu aná ika mendóva fakembea, vaini va ga degimbea bua, Iesu da beva takembuturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aná vaini diria-da ambova, Iesu na “Avore, sidara etue!” rirota, unda oeno asegea doa, ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Avore, evia rifo atadua, Nangu Undari fefera re. Aná Nangu Undari fefera kakarago bee eini-gea, rourogo tamo ifatarava irota, rifo atauve-degea rirota, Jiusi enemboda babarigarimi, Pailat dava igiguturie. Unona “Avore” rata ningia, Iesu de, kotú aná bagia enembodeda eka mane dea boboregota tutumi amburota ifatarava doa baita benunu regeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","“Avore” ririeta, mene-mene ari kakato aria, bagia enembo einida eka dea borea, kotú einida dea boriturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Aghá ea doa, Iesu da dea boraita urota geruria mo, umó seibe ambubuturia-du, unda eka jo dea borambi, dodoguturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Aghá-gea, mene-mene ari kato einimi unda giimi Iesu da kurikeva ga ghusu-ghusu ea, numbua rururieta, gaimbo ambi tatangu uvugha bagegami beredogha ea vovorurie. ");
INSERT INTO bjz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Amó donu gerurera-nu gaabee egegadi rirota, gembere. Amó gaa beenu rere. Jo gavera irambi re.) ");
INSERT INTO bjz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","God da gaga buka seiva gefiria gaa bee ari-du ená eini-eini aghagonu siroruturie. Gaga aná evere: “Unda siruru eini jo dea borambi aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kotú gembari seiva, God da Gaga einiva reirie. “Embó gaegeguturia-nu númanena tatasegea gigigaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Anada ambova, Arimatea embó Josep na aria, Pailat dava bubua, unona “Avore” rata ningia, Iesu da tamo baita rea, benunu urie. Josep umó Iesu da yavero eini ea vitirie. Tago, Jiusi enemboda babarigaridu oru urota, nungegimi Iesu gaabee urota vitirie. Pailat na “Avore” ririeta, umó Iesu da tamo bua arie. ");
INSERT INTO bjz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Embó eini Nikodemus re. Umó seibe sei tumbade Iesu gaita aria-mi, ingi ungagha reta bagega ea bua ujeva arie. Ingi eini ragaro meer einida ragaro aros danode 40 kilo aghagonu bua, Josep gha kanona arie. ");
INSERT INTO bjz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ungá Iesu da tamo bua, aná ingi gharea, eembo saghai tamomi ooto urie. Jiusi enemboda mambube maneda amburari enembo simbugeta egeguturia aghagonu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu ifatarava deruria kambesiva aayo eini irita urie. Gudoro eini aayo rova anada ufuva uje seibe avo ghafirieta vitirie. Amburari enembo eini anava jo sei furugambi re. ");
INSERT INTO bjz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Aná feferava Jiusi enembo númanda Nangu Undaridu simbugutua-du rea, aná uje utuvako-gea, Josep ungá Nikodemus gha Iesu da tamo bua anava furuguturie. ");
INSERT INTO bjz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Fura jojabeda rifo atitueta, Makdala ariri Meri retora, unona erea, ujeva arie. Irurota, geruria mo, uje bebato gajari singoi ifegea irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aghá gia, kaverea sumbua aria, Saimon Pita de aná ambo nimbi avonu Iesu neno buta uria-dava bubua, eghá ririe. “Jojabeeda tamo ujeva aná bua iye. Bua iya, niavo ititigetua námane jo gigigambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Aghá ririeta, Saimon Pita aná retora ambo nimbi einide dano erea susumbugea, ujeva igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ungá danode sufirie-tago, aná ambo nimbi einimi Pita doa, sei sumbua aria, ujeva buburiturie. ");
INSERT INTO bjz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aria ujeva bubua, umó jo rova terambi re. Tago, gonea eembo saghai tamo eghovarimi irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aghá ueta, Pita unda ambova aria, uje toova terua aria, rova aná eembo saghaimi unda tamova eghovuturia-nu avo airo vasia irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kotú unda beforova eghovuturia eembo saghai beago gerurie. Tago, unuka yuuvi ea, airo vasia irieta, gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Anada ambova, aná ambo nimbi sei sumbua aria, ujeva buburituria, umó beago terua aria gia, gaabee urie. ");
INSERT INTO bjz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Avore, Iesu amburarivareta jebugea eraita rouvia-nu, God da Gaga buka seiva gefiria-mi rei-irugutue. Tago, Pita, ungá aná ambo nimbighada nundubariva jo itoko isagha ambi urie. ");
INSERT INTO bjz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aghá gigiguturie-gea, doa kaverea, naava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Númane kaverea igiguturie. Tago, Makdala ariri Meri, umó avo uje beva jiria jii rirota, gonea vorea, uje roo gaita urie. ");
INSERT INTO bjz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Gonea geruria mo, Iesu da tamo itituria kambesiva anera ungaghami eembo saghai tamonu asusugea, eini beforo kena kotú eini eka kenava asusumbea irieta, umó gerurie. ");
INSERT INTO bjz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Gerueta, númanena undú eghá ririe, “Moseko, imó dodu jii rere?” regeguturieta, umó mino ririe, “Anda Jojabee enembomi bua serigetue-tago, niavo ititigetua, amó jo gambi re.” ");
INSERT INTO bjz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aghá rirota, umó kaverea, Iesu avo jiria irieta, gerurie. Tago umó, aná Iesu na jiria vitia, aghago jo tanana ambi re. ");
INSERT INTO bjz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aghá uua-du, Iesu na undú eghá ririe, “Moseko, imó dodu jii rere? Imó avonu tava ro?” ririe. Aná evetuda nundubari aayo govari kato gaa ririe-gea, eghá ririe, “Embó, imó Iesu da tamo bua ya niavo itadora mo, rege ningia amó ya bare!” ");
INSERT INTO bjz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aghá ririeta, Iesu na “Meri!” ririeta, umó ningia kaverea, dibe Iesu kena ea, námane Jiusi enemboda gaami, “Rabonai” ririe (Aghá riria-da bee mo, aná “Irugari Kato re.”) ");
INSERT INTO bjz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ririeta, Iesu eghá ririe, “Amó jo kaverea, anda afadava yambi vitereta, mania anda tamova righata! Imó ii, anda ikoko mendidava bubua, eghá rege, ‘Iesu, kaverea unda Afa, nímanda Afa, kotú unda God, nímanda God dava reiye.’ aghá rege, niningigoe!” ");
INSERT INTO bjz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Aghá rieta, Makdala aririmi ningia kaverea aria, Iesu da ambo nimbidava bubua, “Amó Jojabee gere,” rea, undava gaga riria ananu ririeta, niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Fura jojabeda jama bee tumba kinjí ueta, námane Iesu da ambo nimbi, Jiusi enemboda babarigaridu oru egeguturere-gea, bebato gajea, boraga sinia, rova danode desea vitirere. Aghade, Iesu furia, námanda rorova sirorea jiria, eghá ririe, “Siriri nímandava iroe!” ");
INSERT INTO bjz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aghá rea, unda ingode kurikide iruguturieta, námane gigiguturere. Námane Iesu gigigea, neno roo gangoromi beda urie. ");
INSERT INTO bjz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kotú Iesu rekago ririe, “Siriri nímandava iroe! Afa na amó ninenguturieta furera aghagonu, anona nímane ninengota igigaita rosoravore!” ");
INSERT INTO bjz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aghá rea doa, unona námandava oeno furia, eghá ririe, “Asisi Kakara bubuge! ");
INSERT INTO bjz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nímane enemboda ari-bari sembago nundubea gia dodogadora, God Afa uutuva vitia beago, númanda ari-bari sembago nundubea gia doaita rouvie. Atá númanda ari-bari sembago jo nundubea gia doambi egegadora, God Afa uutuva beago númanda ari-bari sembago jo nundubea gia doambi aita rouvie.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Avore, Iesu furia, námandava isagha uria feferava, námane Iesu da ambo nimbida eini, Tomas, unda ragaro eini aná Didimus, anava tefo re. (Didimus, aná Rom enemboda gaami “Daya fumbari” regegeta rosore.) ");
INSERT INTO bjz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aghá-gea, námane ambo nimbi dumenimi undú eghá regeguturere, “Námane Jojabee isagha etueta gigigetore!” aghá regeguturieta, umó eghá ririe, “Tefo, amó unda ingova bubughade kurikiva giimi gaita bubughade anda ingomi righia gambi adora, amó jo gaabee ambi aita rore.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Fura dabako sidara urieta, anada ambova námane Tomas de dano kambo rova, rekago bebato boraga ea, desea iririgutueta, Iesu furia, námanda rorova jiria eghá ririe, “Siriri nímandava iroe!” ");
INSERT INTO bjz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aghá rea, Tomas du eghá ririe, “Inda ingo sine, furota, anda ingova bubughanu righia gadi! Kotú inda ingomi sinia fu, anda kurikiva righia gadi! Mania mana-mana ata! Amó gaabee adi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aghá ririeta, Tomas na mino eghá ririe, “Anda Jojabee, anda God, amó gaabee rore.” ");
INSERT INTO bjz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aghá ririeta, Iesu na mino undú eghá ririe, “Imó gerurota, amindu gaabee roravore. Atá, avona amó gambi irirota, gaabee adua, Afa na númane ea simbugaita rouvie.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Anada ambova, námane unda ambo nimbida dibeva, ivata dumeni dumeni Iesu da eaveta siroreta uria dano jo ená bukava gembambi re. ");
INSERT INTO bjz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tago, ená bukada rova dodu gembera-da bee aná evere. Iesu umó God da Mendi, kotú God na embó eini gategea ninengota furaita rouvie, riria, aná Iesu umó-gea, umonu gaabee egegadi gefirere. Enembo avona umonu gaabee adua, jebuga tumanadu irari baita rouvie. ");
INSERT INTO bjz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Anada ambova, Sao Jojabe Taiberias betuva Iesu rekago námandava isagha urieta gigiguturere. (Aná sao jojabeda ragaro eini, aná Galili Sao regegeta rosore.) Eghago siroruturie. ");
INSERT INTO bjz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (undú beago Didimus regegeta rosore.) Eini mo Galili Frovensi anava Kana naava embó Nataniel umó re. Kotú anda afa Sebedi da sasingu ungaghade, amó anda kakagha re, kotú námanda embobo ungaghade namonde dano vitirere. ");
INSERT INTO bjz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita na eghá ririe, “Amó uvu oka beraita refere.” Aghá ririeta, námane eghá regeguturere, “Avore, namonde yare!” Námane vorearera ghaava* vorea, tumbade moyuva fugiturere-tago, oka eini jo berambi re. ");
INSERT INTO bjz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rifo tumbava, Iesu furia sao betuva jiruturie. Tago, námane aná Iesu aghago jo tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Avo jiria, be fugia, námandu ririe, “Yarata, nímane oka dumeni beberigetora?” Aghá ririeta, “Tefo, eini jo berambi re.” regeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aghá regeguturieta, umó eghá ririe, “Ingo bee kenava nímanda ghaa kasava ghoto avo fugea, oka dumeni beberige!” ririe. Aghá egegea, oka oruaruabe moyuva rova vovorurieta, námane aná moyuva ghambugari jo inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Aghá egeguturota, ambo nimbi avonu Iesu da neno buta uria-mi Pita du eghá ririe, “Oná Jojabee re,” ririe. Umó aghá rieta, Pita ningia, unda asugari etova sei kosuguturia-nu bua asugea, uvuva jaũ ea vovorurie. ");
INSERT INTO bjz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Betuva reta moyuva fugiturera-va jo roo irambi re, 100 mita aghago re. Amindu, námane ghaava irirota, moyuva ghambugea yavurera, manguava bububuguturere. ");
INSERT INTO bjz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ghaa jerí ea, viviturota, Iesu da kasava farava ingari dumeni vavasigea irieta, ivari gagembea, uvu oka ingutueta gigiguturere. ");
INSERT INTO bjz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Gigigutueta, Iesu na námandu ririe, “Oka beberigetora-nu dumeni bua fufuge!” ");
INSERT INTO bjz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aghá riria-du, Saimon Pita kaverea, ghaava vitia, moyuva ghambugea bua, manguava viviturie. Oka jojabebei dano 153 beberurere-tago, moyuva jo bejambi re. ");
INSERT INTO bjz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Aghá egegutueta, Iesu na námandu eghá ririe, “Fufuge, undari bua undidigadi!” ririe. Aghá ririe-tago, námane uriga ari oru egeguturere. “Imó avouro” jo regegambi re. Anada bee mo, umó námanda Jojabee aná seibe gigigea tanana egeguturere. ");
INSERT INTO bjz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu na furia, farava ingari bua, námandu ututugea, kotú uvu oka beago bua, ari dabako aghagonu urie. ");
INSERT INTO bjz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iesu amburariva reta jebugea eroruria-da ambova, umó manguava gigiturera-mi, fefera bako námandava isagha urieta gigiguturere. ");
INSERT INTO bjz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Undari undidiguturera-da ambova, Iesu na Saimon Pita du eghá ririe, “Saimon, Jon da mendi, imó amó neno bua goghó eta rora aĩ, enda etova gugua-ghayafadu neno buta rora?” Aghá ririeta, “Aĩ, Jojabee, imó rei-geroravore, amó imó neno rei-rurore,” aghá ririeta, Iesu undú ririe, “Anda sifi memendi kaifa adi rere.” ririe. ");
INSERT INTO bjz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aghá rea, rekago ririe, “Saimon, Jon da mendi, imó amó neno rei-rurora, aĩ?” aghá ririeta, “Aĩgo, Jojabee, imó rei-geroravore, amó imó neno rei-rurore.” ririe. Aghá ririeta, Iesu na eghá ririe, “Anda sifi kaifa adi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu rekago fefera bako aná uriga bee ungagha uria dabako aghagonu ririe. “Saimon Pita, Jon da mendi, imó amó neno buta rora, aĩ?” Fefera bako uriga uria-du Pita neno mema urie-gea, eghá ririe, “Jojabee, eini-eini dano imó rei-geroravore. Kotú imó tanana roravore. Amó imó neno rei-rurore,” ririe. Aghá ririeta, Iesu undú ririe, “Anda sifi kaifa adi rere! ");
INSERT INTO bjz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Amó indú gaa bee rere. Imó mendi reka irirota, inda asugari dighari indufa dighia asugea, inda uno urera kambesiva iru-furu eta ureravore. Tago, imó emboko adora, enembo dumenimi inda asugari dighari dighia asugea ata, inda ingo sinota, ingo bundarimi bundia bua, inda uno ambi kambesiva yaita rousue.” ");
INSERT INTO bjz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iesu aghá rirota, Pita da daiyagha amburasueta, enembo gigigea God du raga regegasua-nu isagha urie.) Aghá rea doa, Iesu na Pita du eghá ririe, “Anda ambo-ambo ege!” ");
INSERT INTO bjz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Aghá riria-da ambova, Pita na kaverea, aná Iesu neno buta uria ambo nimbi, númanda ambova furueta gerurie. (Aná ambo nimbi dabako anami Serigea Yari Banauva* Iesu de undari dirota, utuvako baĩ ea aria, Iesu dava desembuturota, umonu avona aghi asua-du uriga urie.) ");
INSERT INTO bjz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita aná ambo nimbinu gerurie-gea, Iesu dava uriga urie. “Atá Jojabee, oná embódava daiyagha siroradu?” ririe ");
INSERT INTO bjz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aghá ririeta, Iesu na mino eghá ririe, “Anda unomi umó irota-gea, amó kaverea furasira mo, aná andava re. Mania nundubata! Tago, imó anda ambo-ambo ea, furadi rere!” ");
INSERT INTO bjz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Avore, aná ambo nimbi jebuga irasueta, Iesu kaverea furasua-da bingá, enembo oruaruabe niningigea fafate urie. Tago, aná ambo nimbi jo amburambi irasua-du, Iesu jo rambi re. Iesu, umó eghá ririe, “Anda unomi umó irota-gea, amó kaverea furasira mo, aná andava re. Mania nundubata!” aghá nuenembo ririe. ");
INSERT INTO bjz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Atá, nímane amó tanana rosoravore. Amó gaa beenu reta rore, kotú ená gaga rei-gefera, aná gaa bee re. ");
INSERT INTO bjz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu da ivata anoghade, kotú ari-bari dumeni eta uria-deda gaga jo dano gembambi re. Atá, unda ari-bari dano gegembugasira, aghajora ená enda bukami gigimbasue. ");
INSERT INTO bjz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Ariee, Tiofilus ko, anda buka seiva gefirera-da bee mo, aná enanu indú rereta, ningi! Iesu umó buro daiyagha tutuno ea furia-va, ari donu uria, kotú gaga donu nghaĩ ititurota furia, kotú uutuva vivituria, ananu gefirere. Avotago, Iesu ambua erea, uutuva jo vitambi irirota, fefera aghade, embobo unda aghi egegari-du sei gateguturia-du nghaĩ ititurie. Númane Asisi Kakarada anomi buro donu egegari-du, kotú gaga donu regegari-du uno uria-nu nghaĩ ititurie. ");
INSERT INTO bjz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesu amburarivareta jebugea erea, umó fefera 40 endava irirota, fefera daba-daba unda ambo nimbidava isagha ea, ivata anogha dibe eini be eini urota, undufa umonu irugeaveta, umó amburarivareta jebugea eroruria-nu gaabee egegeta urie. Aghade, God Afa unda natofo* daiyagha kaifa eta rouvia, ananu irugeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Fefera einiva, Iesu numonde danode desea, undari undidiguturota eghá ririe, “Anda Afada donu utaita be gajituria, aná ririeta niningigutureravore. Amindu eve Jerusalem kaifa egege! Mania doa serigata! ");
INSERT INTO bjz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Anada bee mo, Jon na enembo tefo uvumi bafutaito eta urie. Avotago, fefera dumenida ambova, nímane Asisi Kakarada anomi bafutaito aita rore.” ");
INSERT INTO bjz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Amindu fefera eini, numonde furia desea, uriga eghá egeguturie, “Jojabee, gigo! Inona oreki rata, námane andufa Jiusi enembo tefo neno egeguturota, námane andufa kaifa egegara, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aghá regeguturieta, Iesu na mino númandu eghá ririe, “Nímandu jo rata niningigambi aita rosoravore. Eini-eini dano God Afa na unda unomi reaveta siroreta rouvie. Amindu, nímandu jo rata niningigambi egegaita rosoravore! ");
INSERT INTO bjz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Avotago, Asisi Kakarami nímandava asugadua mo, unda ano utota bua, nímane erea tutuno ea, Jerusalem reta ya Judia Frovensi anava, Samaria Frovensi anava, naa dano kotú roo enda dano biruru urota, anda Gaga Taubananu minono regegaita rosoravore.” ");
INSERT INTO bjz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aghá riria-da ambova, númane gerueta, Iesu rururieta uutuva yavuria gooso rova teterurieta númanda dibe goosomi gajiturie. ");
INSERT INTO bjz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Númane avo jijiregea, unda yavua-nu tatasegea gigigutueta, jo gaimbo ambi, embobo ungagha ungá unda asugari saghai tatamo manemi furia, númane vitiria-da kasava isagha ea jijireguturie. ");
INSERT INTO bjz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Aghá ea, númandu eghá ririe, “Galili embobo, nímane dodu uutuva dingera roso? Iesu daiyagha nímandavareta uutuva vivitueta gigigetora, emboro dabako aghagonu uutuvareta kaverea furaita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aghá uria-da ambova, Iesu da ambo nimbi, ooto ragaro Olivi avo reta kaverea aria, jo roo yafabe yambi, bogu naa Jerusalem bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bubua aria, númanda sei iririgeta uria kambova terua vitia aria, itiva buburiturie. Anava buburituria mo, Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, kotú Alpheaus da mendi Jems da akau, númanda akauda mendi Judas, Saimon Tuvari Katode dano. ");
INSERT INTO bjz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Númane evevetu dumenide, Iesu da nue Meri de kotú Iesu da ikoko mendide dano desea, neno dabako egeguturota, benunu urota iririgeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Anada ambova fefera dumeni seriguturieta, Iesu gaa bee egegeta uria enembo dano 120 bubua desuturieta, Pita na erea jiria eghá ririe, ");
INSERT INTO bjz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Anda ikoko mendi, ariri gharovu, Asisi Kakara na ririeta, namonde anda mambube Devit donu Judas du gefiria, aná gaa bee siroruta. Judas reiria mo, aná namonde anda enembo eini re. Ená buronu ari-du, Iesu na gateguturie. Avotago Judas na gitofo kofiri urota, Iesu númanda ingova itutata, umó nandia bundita. ");
INSERT INTO bjz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas umó, Jiusi enemboda barirari guri ututata bua angia, kambesi eininu aná gurimi utua bua, avo jua dea uro bejea desini bani-bani isaghava buburitata ambubuta. ");
INSERT INTO bjz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aghá utata, Jerusalem enembo dano niningiguta-gea, aná kambesida ragaro númanda gaami Akeldama ririkiguta. Anada bee mo, Tatangu Kambesi re. ");
INSERT INTO bjz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Anada bee mo, Daa Bukava eghá gembari vitie: ‘Unda kambesiva enembo tefo iroe! Mania doata, enembo eini unda kambova irauveta!’ Kotú gaga eini eghá gefirieta vitie, ‘Embó einimi unda kambesi bua, buro aita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Amindu taubana mo, namonde embó eini Judas da kambesi bari-du regegota jiroe! Tutunova Jon enembo bafutaito eta uria-vareta, Jojabee Iesu uutuva vivita anada rorova, namonde danode iru-furu eta uria embó eininu gategore! Aghá adora mo, namonde amó Iesu da ambua erora-da gaga nanjigo riradora mo, umó osagho fumboe!” ");
INSERT INTO bjz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aghá riria-da ambova, embobo ungagha gateguturie. Embó einida ragaro bakode re: Josep, Barsabas, kotú Jastus re. Embó einida ragaro mo, Matias re. ");
INSERT INTO bjz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Aghá egegea benunu urota, eghá regeguturie, “Jojabee, imó enembo nanjogoda neno roo dano gita roravore. Judas unda buro doa kambesi akuago undú simbuguturia anava angie. Amindu, unda kambesi bari-du rea, avonu rei-nundubutora, ananu iruge-gea, regegota jiria inda aghi kato eini ae!” ");
INSERT INTO bjz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anada ambova númane, ungá unda ragarova kikindo gaegeguturia mo, Matias da ragaromi isagha urie. Urieta, Matias umó Iesu da aghi kato eini ea, numonde 12 ea deĩ egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jiusi enemboda banau einida ragaro “Pentikos” regegeta uria-da fefera buburiturieta, Iesu gaabee egegeta uria enembo bubua, danode kambo dabakova desuturie. ");
INSERT INTO bjz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Avo desea iririgutueta, gaimbo ambi, ero eini yaura jojabeda erogomi uutuvareta vorefuria kambo manduguturie. Aghade jo mino-mino gaga rea ningari inono egegambi re. ");
INSERT INTO bjz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aghá uua-da rova mo, eini-eini eto-bato ivari buburago sirorea sarige-sarige ea aria, enembo daba-dabada beforova vasia janimbutueta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aghá ea, Asisi Kakarami númandava asuguturieta, númanda neno roo beda urie. Ano ututurieta, enembo daba-dabada aveva kaveruturieta, númane gaa dumeni dumenimi regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Fefera anava, Jiusi enembo God gaabee egegeta uria anami, roo enda nanjogo dano doa esega furia Jerusalem bubua, anava vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Númane aná yavi niningiguturie-gea, mana-mana ea, enembo oruaruabe furia danode egeguturie. Anada bee mo, Iesu gaabee ari enembo aveva kaveruturieta, númane aná esega fufuguturia enemboda gaa airo-airomi regegutueta niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","Aghá niningigea, númane duduku-dadaka egegea, eghá regeguturie, “Ená gaa eghá reisi-ria enembo, aná dano Galili enembo re. Avotago, daiyaghami aveva kaveretueta, namonde anda gaa manemi regegutueta reisi-niningo? ");
INSERT INTO bjz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Namonde amó dumeni aná, Partia enembo, Media enembo, Ilam enembo, Mesopotemia enembo, Judia enembo, Kapadosia enembo, Pontus enembo, Esia enembo, Frijia enembo, Pamfilia enembo, Krit enembo, Arebia enembo kotú Isip enembo re. Namonde anda enembo dumeni, aná roo enda Libia, bogu naa Sairini kasa-kasavareta fufuguta. Kotú namonde amó, dumeni aná, Rom reta esega fufugutare. Namonde amó, dumeni aná, Jiusi mokó re. O dumeni aná, númanda otu-evovo doa namonde amó Jiusi enembodava rekimbea, namonde anda ambo nimbi ea vitie. Aghá re-tago, oreki daiyagha ea namonde dano reisi-niningora mo, God eini-eini jojabe donu urieta siroruturia ananu, namonde anda gaa ari gaa ari Galili enembomi regegutueta reisi-niningo?” ");
INSERT INTO bjz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mana-managha, númane duduku-dadaka egeguturie-gea, mino-mino uriga egeguturie, “Enada bee mo, doro?” ");
INSERT INTO bjz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Avotago enembo dumeni númane, kuvia gegha regeguturota, eghá regeguturie, “Aná enembo uvu fakara undidigea, be vaive-vaive reisi-rie.” ");
INSERT INTO bjz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Aghá regeguturieta, Pita na erea, ambo nimbi 11 de jiria, be fugia natofodu eghá ririe, “Jerusalem enembo kotú anda ikoko mendi, ariri gharovu, Jiusi enembo, nímane dano ghanena rore. Gaga enanu anona raita roreta, ningia goghó egege! ");
INSERT INTO bjz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Oreki 9 koroki fefera be fakara etue. Fefera eghago, aná jo uvu fakara undarida fefera irambi re. Aghá-gea, námane jo uvu fakara undidigea, ená yavi egegambi re. ");
INSERT INTO bjz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Atá, ená yavi reisi-gerora amindu rea, seibe God ririeta, unda feroveta ragaro Joel na eghá gefirie, ");
INSERT INTO bjz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God na eghá reirie, “Fefera ambova, anona anda Asisi averegota vorea, enembo nanjogodava asugaita rouvie. Asugea irota-gea, nímanda mendi ariridava anda gaga ifegota, númanena isaghava regegaita rousue. Yarata mane númanda dibe mokómi gigigaita rousue, kotú nímanda embobokoko dira egegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Fefera aghade, anda Asisi Kakara anda buro egegari enembo, embobode evevetudedava, averegota vorota, anda gaga isaghava regegaita rousue. ");
INSERT INTO bjz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aghá urota, anona ata, ivata uutuva kotú endava siroruturota gigigea, natofo duduku-dadaka egegaita rousue. Anona ata-gea, tatangu ivari buburagha, kotú dimbori jojabe siroraita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jojabeeda furaita rouvia fefera jojabeva, umó duroghagha furaita rouvie. Anada dibe kena, fefera gotea ya bingoi urota, marabe kaverea tatangugo aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Rifo aghade, enembo avona Jojabeeda ragarova jamono gatiturota, sonembari-du benunu egegadua mo, númane jebuga tambaita rousue,” ’ God aghá ririeta, Joel na gefirie. ");
INSERT INTO bjz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Amindu rea, anda natofo Jiusi enembo, ená anda gaga rera, aná ningia goghó egege! Nasaret embó, ragaro Iesu, God da buro ari du rea, God na ninenguturieta furia siroruturie. Aná irugaita rea, God unda anomi sonembutuaveta, unona ari ivata dumeni dumeni eaveta sirorutuaveta gigigea, natofo duduku-dadaka egegeta urie. Iesu aná ari anogha urieta siroruturia, aná jo roo einiva ambi re. Eve siroreaveta, nímane gigigeta ureravore. ");
INSERT INTO bjz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Avore, God seibe nundubea simbugea, Iesu amburari-du rea ninenguturie. Amindu, nímane Iesu nandia bundia bua angera, ari-bari akokogo ari enembodava ututata, ifatarava dedegutata ambubuta. ");
INSERT INTO bjz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Avotago anada ambova, God na ritata, umó amburarida mema doa serigea jebugea erora. Anada bee mo, amburarida anomi umó buregari jo inono irambi re. ");
INSERT INTO bjz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Undú rea, Devit na eghá gefirie, ‘Fefera inono Jojabee anda dibe kenava gita rore. Umó anda kasava irirota, amó sonembaita rouvia-du, anda eka ingo rarovambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amindu, amó neno gangoro urota, anda beemi undú raga reta rore. Amó embó-gea, amburaita rore. Avotago, amburari-du jo oru ambi re, ");
INSERT INTO bjz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Anada bee mo, imó jo amó doata amburari enemboda kambesiva irambi aita rore. Inda Buro Kato kakarada tamo jo doata ujeva betambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jebuga barida emboro inona iruguturieta, amó rei-gerore. Kotú inda dibe kenava irirota, gangoro urota iraita rore,’ Devit na Iesu du nundubuturota, aghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Avore-tago, anda ikoko mendi, ariri gharovu, namonde anda mambube Devit da kiki ananu isaghava raita roreta, niningige! Devit umó ambubuturieta enava furuguturie. Umó furuguturia beko oreki enanu vitie. ");
INSERT INTO bjz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Avotago, umó jo amburambi irieta, God undava be gajiturota eghá ririe, ‘Inda imendi gamendi eini, anona rata kotofuko imongo aita rouvie.’ Devit umó God da feroveta eini re. Aghá-gea, God donu riria, ananu gaa bee urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God donu ambova aita rouvia, aná Devit umó gerurie. Aghá-gea, God daiyagha daiyagha ea rata, Keriso amburarivareta eraita rouvia gaga aná eghá ririe: ‘Umó jo doata ujeva irambi aita rouvie. Unda tamo jo doata avo betambi aita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ená gaa bee re. Iesu rera umó, God na ritata, amburarivareta jebugea erorata, námanda dibe mokómi gigigutare. ");
INSERT INTO bjz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Gigigutara-da ambova, Iesu du raga rirota umó righota erari-du rea, God na umó bua, unda ingo bee kena itia, Asisi Kakara undava ututa. Ututata, unona bua righia jiria averegetueta, enava vorea oreki vitie. Nímane unda anonu gigiguturota reisi-niningoravore. ");
INSERT INTO bjz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Gaga eini, evere. Jo Devit na ambua uutuva yavambi re. Avotago, umó Iesu nundubuturota, ená gaga ririe. ‘God, unona anda Jojabeedu ririe, “Fu anda ingo bee kena asumbadi-gea, anona inda gitofo dea bundia bua furá, inda eka tuva ghandada gharari-du itota vasioe!” ’ Devit umó Iesu nundubuturota, aná gaga ririe. ");
INSERT INTO bjz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Amindu rea, nímane Israel enembo, ená gaga nundubuturota, ningia goghó egegadi rere. Ená Iesu rera, nímanena bua ifatarava deraravore. Embó dabako umonu, God na gategea, namonde anda jebuga bua furari-du ninenguturieta furie. Kotú God na ririeta kotofuko ea, namonde anda sonembadu vitie,” Pita na aghá rea sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sidara urieta, enembo niningigea, oru ea mana-mana ea jarea, Pita kotú Iesu da ambo nimbidedu eghá regeguturie, “Avore, námanda ikoko mendi, nímane reisi-nundubutora, oreki námane daiyagha daiyagha egega?” ");
INSERT INTO bjz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","39","Aghá regeguturieta, Pita na númanda gaga mino eghá ririe, “God nímane sonembea unda Asisi Kakaranu vesa utaita rea, be gajiturie. Avore-tago, jo nímane nenuka sonembambi aita rouvie. Nímanda imemendide kotú abua-abua nanjogo beago, God da aghi aita rouvia-nu sonembaita rouvie. Amindu rea, nímane daba-daba, neno kaverea, fufuge, Iesu Keriso da ragarova bafutaito egeguturadi-gea, God nímanda ari-bari akokogo nundubea gia doae! Aghá uradi-gea, God da vesa esiko-esiko, aná Asisi Kakara nu utota bubugadi.” ");
INSERT INTO bjz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Aghá rea doa, gaga dumeni dumeni rirota, númandu nghaĩ eghá ititurie, “God ari-bari akokogo enembo oreki sirorea vitia-nu data ambubugaita rouvieta. Amindu rea, nímanda ari-bari akokogo dodogea jebuga bubuge!” ");
INSERT INTO bjz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Fefera dabako anava, natofo oruaruabe gaabee egeguturota, furia bafutaito egeguturie. Aghá uria enembo, dano 3,000 aghago re. ");
INSERT INTO bjz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kotú, Iesu da ambo nimbida donu iruguturia, ananu niningiguturota, unda ambo nimbide irirota, undari numonde dirota, benunu danode egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aghade, Iesu da ambo nimbimi God da anomi eaveta, kae akokogo bubugea irari enembo jejebugeta urie. Taimu akokogo enemboda rova irita uria beago, númanena reaveta fuava isaghava bubuta urie. Kotú ivata anogha dumeni dumeni uaveta, natofo gigiguturota duduku-dadaka egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Aghá egeguturota, Iesu da natofo danode iririguturota, númanda eini-eini mino-mino kavevera urota, vesa egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Númanda enda o gugua-ghayafa aná utua mino bubugea númanda enembo daba-dabada mema sonembeta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Númane danode rifo inono iiava, God du Tafaroro Ari Kambova* terua desea benunu egegea, bubua kambova iiava nundubari dabako urota, gangorogha undari undidigeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Aghá egeguturota, númane God raga regegutuaveta, enembo dano gangorogha Iesu da natofo neno bubugeta urie. Aghá uaveta, Jojabee na reaveta, dumeni fuava Iesu gaabee egeguturota, unda natofo egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Fefera eini ungobo, 3 koroki ueta, benunu ari fefera rurueta, Pita ungá Jon gha God du Tafaroro Ari Kambova* benunu egegaita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Aghade, ungá teraita igiguturota, embó eini eka dimbaride nueda urova aghá sirorarimi avo bebato eini, ragaro “Taubanago Bee” anava asumbea irieta gigiguturie. Aná embó fefera inono, enembo dumenimi bua iiava avo itiaveta, asumbea irirota, natofo God du Tafaroro Ari Kambova benunu egegaita igiguturari mo, umó undari-bari bua undaita rea, guridu benunu eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Umó avo asumbea irirota, Pita ungá Jon gha teraita irueta gia, númandava guridu benunu urie. ");
INSERT INTO bjz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aghá urieta, ungá umó aná embónu tatasegea gigiguturota, Pita na eghá ririe, “Imó dibe jará ea námanenu gia goghó ege!” ");
INSERT INTO bjz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Aghá riria-du, aná embó dibe jará ea, ungá umonu gia goghó urota, eini-eini utota baita rouvia aghagonu, itatama urie. ");
INSERT INTO bjz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aghá ueta, Pita na undú eghá ririe, “Andava guri tefo re. Avotago andava donu vitia ananu indú utaita rore. Nasaret embó Iesu da ragarova, imó erea deĩ iru-furu ege!” ");
INSERT INTO bjz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aghá rea, aná embó ingo bee kena ririkueta umó erorurie. Aghá uua mo, jo gaimbo ambi, aná embóda eka maneda gunguto fakara urieta erea jiruturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Erea jiria, jaujau ea iru-furu urota, God du raga rirota, numonde dano aria God du Tafaroro Ari Kambova teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Teterurieta, anava vitiria enembomi, umó deĩ iru-furu urota, God du raga rieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Gia, númane dano aná embódava donu siroruturia ananu tanana ea, duduku-dadaka ea mana-mana egegea, eghá regeguturie, “Ená embó mo, aná eka dimbaride, bebato Taubanago Bee anava asumbea benunu urota irita uria, ananu ra?” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aghá urieta, aná embómi Pita ungá Jon ghada ingova righia jiruturieta, natofo duduku-dadaka ea susumbugea furia, kambesi eini God du Tafaroro Ari Kambo rova vitiria-va terua jijireguturie. Aná kambesi eini rera-da ragaro aná Solomon da tofo re. ");
INSERT INTO bjz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aghá egeguturia-du, Pita na númandu eghá ririe, “Anda ikoko mendi, Jiusi enembo, nímane dodu duduku-dadaka egegea, námanenu tatasegea gia goghó roso? Jo námanda anomi ata ená embó erea jirambi re. Námane jo inono irambi re, kotú jo God go irambi re. ");
INSERT INTO bjz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God, namonde anda mambube mane Abraham, Aisak, Jekop da gaabee eta uria-mi, unda buro kato, Iesu da bingá righota erari-du rea, unona retueta ená embó eka dimbaride jebugetue. Iesu rera, aná nímanena injigha ea nandia bundia, Rom enemboda kotofu embó, ragaro Pailat dava ututaravore. Umó Iesu doata yari-du rita-tago, nímane Pailat da dibeva Iesu du kamena rea, injigha egegutaravore. ");
INSERT INTO bjz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iesu rera, umó taubana kotú kakara bee re. Avotago, nímanena umó injigha egegutaravore. Aghade, Pailat Iesu doata bubari-du rita-tago, nímane Iesu amburari-du regegea, ari-bari akokogo kato embó eini derurieta ambubuturia-nu doata isaghava bubari-du regegutaravore. ");
INSERT INTO bjz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Atá Iesu, aná jebugada ruru re-tago, nímanena bua angera ifatarava derata ambubuta-tago, God na utata, umó amburarivareta jebugea erora. Iesu jebugea erora, námanda dibemi gigigutare. ");
INSERT INTO bjz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu da ragaroda anomi etueta ená embó gia tanana rosora, jebugetueta nímane dano reisi-geroravore. Námanda gaabee arimi, Iesu da ragarova regegetueta, umó erea jiretueta reisi-geroravore. ");
INSERT INTO bjz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","18","Avotago, anda ikoko mendi, amó rei-gerora, nímanda babarigaride Iesu du donu egegutara aná jo gia tanana egeguturota ambi re. Tago, aghá egegutara-mi, God da gaga sei unda feroveta mane nanjogoda regegeta uria, aná futa gaa bee uta. Aná gaga evere: ‘God umó embó eini simbugea ninengota furá, endada bouvu memagha itatama urota amburaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Amindu, neno kaverea, nímanda ari-bari akokogo isagha ea, God dava fufugutu-gea, unona nímanda ari-bari akokogo nundubea gia doae! Nímane aghá adora, ");
INSERT INTO bjz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","God na rata-gea, unda sonemba nímanda asisi dava furaita rouvie. Kotú, Iesu nímane sonembari-du rea, seibe simbuguturieta vitia-nu God na ninengota nímandava furaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Atá Iesu umó uutuva irota-gea, God Afada be gajari, ‘Uutu enda reka ata siroraita rouvie,’ unda feroveta maneda gegembuguturia-nu siroradua, umó kaverea furaita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kotú Moses beago eghá gefirie, ‘Namonde anda Jojabee, God na feroveta eini, amó ninenguturieta furera aghagonu ninengota furá, namonde anda natofoda rorova siroraita rouvie. Umó donu radua, nímane ningia goghó egegasiravore. ");
INSERT INTO bjz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Atá avona unda gaga ningia jo ambo-ambo ambi adua mo, God na umó bua airo itia, data amburaita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Avore, Samuel undufa kotú Samuel da ambova feroveta nanjogo siroruturia-mi oreki donu eve rei-sirorutua anada gaga gegembuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Feroveta mane da mambube mane nímane re. Aghá-gea, God unda feroveta manedu donu utaita riria, nímane beago bubugasiravore. Aghade be gajari anogha Abraham du rirota, donu utaita riria-da bee beago nímane bubugasiravore, aná evere: ‘Inda imendi gamendi siroraita rouvia-da rova, anda ea simbugari utota, ená endava enembo dano bubugaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amindu, God unda Buro Katomi, nímane daba-daba rata-gea, neno kaverea nímanda ari-bari akokogo dodogadi-gea, ea simbugota jebuga tatambugea bubugadi rea, gateguturieta seibe nímandava furie,” Pita na aghá ririe. ");
INSERT INTO bjz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ungá Jon gha da gaga jo rea sidara ambi irieta, ungá umó enembo dava gaga rieta, fristi* mane, Jiusi enemboda babarigari, ragaro Sadyusi* enembo dumeni, kotú God da Kamboda* mene-mene ari kakatoda beforo righari numonde dano furia bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Númane neno sembago egeguturie. Anada bee mo evere: Pita ungá Jon ghana enembodu gaga eghá iruguturie. Iesu amburarivareta jebugea eroruria aghagonu, enembo amburarivareta jebugea eraita rousue. Anada gaga irugutueta niningigea, númane injigha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Númane bubua, Pita ungá Jon gha nandia bua, tumba riritua-du aria, diburava gagajeguturieta, avo eviviguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Aghá egeguturie-tago, enembo oruabe Pita ungá Jon ghada gaga, God du Tafaroro Ari Kambo anava ningia gaabee egeguturie. Aná embobo gaabee urota, Iesu da natofo egeguturia, 5,000 re, evevetu kotú sasingu mane jo irugambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Rifo atiturieta, Jiusi enemboda kokotofu, enemboda babarigari, kotú Moses da Gaga irugari kakatode* dano furia, Jerusalem anava desuturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Fristi da beforo righari, ragaro Anas de, Kaiafas, Jon, Aleksander mane aná, beforo righarida totofo beago anava desuturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Desea, númane ririeta, Iesu da ambo nimbi bua furia, rorova ititurieta jijireguturieta, uriga egeguturie, “Nímane avoda anova kotú avoda ragarova ritata aná embó eka dimbaride jebuguta?” ");
INSERT INTO bjz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Uriga aghá urieta, Asisi Kakara na Pita dava asuguturieta, neno nundubea ririe, “Kokotofu kotú enemboda babarigaride, dano eve bububugetora-du, ghanena rore. Nghaĩ jajavegutuu-gea, gaga raita roreta. ");
INSERT INTO bjz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Námanda ari taubana egegutara-de kotú ená embó eka dimbaride daiyagha jebuguta-du uriga rosoravore. Amindu, nímane kotú Israel enembo dano gigigadi rea, isaghava raita rore. Nasaret embó Iesu, God da ninenguturieta furia embó ifatarava dedegutata, God na ritata amburarivareta jebugea erora-da ragaroda anova námane ritata, ená embó nímanda dibeva jiria vitia, umó jebuguta. ");
INSERT INTO bjz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","God seibe Iesu du nundubuturota, kasiava eghá ririeta gefirie: ‘Singoi eini kambo itari kakatomi injigha ea doa fugituria-nu Jojabee na bua, unda kambo roro tutumbudu itia simbuguturie.’ ");
INSERT INTO bjz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Amindu rea, namonde amó jebuga bubugaita egegadora mo, namonde Iesu unuka umonu gaabee egegaita rosore. God na namonde anda ari-bari akokogo nundubea gia doaita rea, Iesu ninenguturieta furie. Jebuga bari emboro eini tefo re.” ");
INSERT INTO bjz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita ungá Jon gha beforo gari-da ove urie-tago, jo fefera yafabe gegembugambi re. Avotago ungá umó aná embobo usituria-du oru jo egegambi re. Aghá ueta, Pita ungá Jon gha, Iesu de deĩ urota ano undava rururia-nu tanana ea númane duduku-dadaka egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kotú embó eka dimbaride utata jebuguta anava jiria irieta gia, gaga donu eini rari mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aghá ea, númane Iesu da ambo nimbi ungagha aná ririeta bubua aria airo jiriturieta, númane mino-mino rea niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Namonde daiyagha a? Enembo dano Jerusalem enava, embó jebuguta aná ningia, tanana egegetue. Amindu rea, jo namonde amó kivu ari katogo irambi re. ");
INSERT INTO bjz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Avotago, rourogo natofo dano niningigauve-degea rirota, namonde númane buregea eghá regegore, ‘Mania Iesu da ragarova gaga eini irugata o kotú, regegata!’” aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Anada ambova, ghogho ririeta, Iesu da ambo nimbi ungagha furia teteruguturieta, númane fafota urota eghá regeguturie, “Mania Iesu da ragarova gaga eini irugata o kotú, regegata!” ");
INSERT INTO bjz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aghá ririeta, Pita ungá Jon gha erea, númandu mino eghá regeguturie, “Niana mo taubana ro, nendufako nundubea gigige! Námane God da dibeva mo, nímanda gaganu niningigara, aĩ, God da gaga niningigara? ");
INSERT INTO bjz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Atá námanda donu gerara kotú niningara, aná jo eve tukú ambi egegaita rosore.” ");
INSERT INTO bjz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Aghá regeguturieta, kanisera* mane desuturia aná, dano ungá undava rekago gaa fakarago regeguturie-tago, númandu jo mema eini utambi, ninenguturieta igiguturie. Anada bee mo, aná embó eka dimbaride nueda urova aghá sirorea irirota, ghaeko 40 sidara uria-da ambova, umó urieta jebuguturie. Ananu gigigea, enembo nanjogo God du raga regeguturie. Amindu rea, aná kokotofu oru egegea, Pita ungá Jon ghadu mema eini jo utambi re. ");
INSERT INTO bjz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kanisera* mane dodoguturieta, Pita ungá Jon gha Iesu gaabee ari kakatodava aria bubua, fristida* kokotofu kotú enemboda babarigaride donu regeguturia, ananu isagha egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Urieta niningigea, numonde dano God du benunu egeguturota, eghá regeguturie, “Jojabee Ano Kato, inona ririeta, uutu endade karaje, kotú eini-eini nanjogo dano siroruturie. ");
INSERT INTO bjz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Inda Asisi Kakarada anomi ririeta, námanda abua Devit, inda buro kato eghá gefirie: ‘Gitofo unda abua-abua neno akokogo ea, daiyagha God de mene-mene egegasua, ananu nundubuturota manaka gaegeguturie-tago, jo egegota inono ambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Endada kini mane, nendufako simbuguturie. Kotú babarigari furia danode desea, God de kotú unda ninenguturieta furia embódedava, mene-mene aita simbuguturie.’ ");
INSERT INTO bjz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Atá Devit da aghá riria-da bee siroruta. Aná mo, Kini Herot ungá Rom enemboda kotofu eini ragaro Pontius Pailat gha, takembea futa, Jerusalem enava bubua, gitofoda abua-abua dumeni kotú Israel enembode dano desea, inda Buro Kato kakara, Iesu, ninenguturieta furia-dava, mene-mene aita rea manaka gaegeguturia. ");
INSERT INTO bjz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inda donu sirorari-du nundubutara, aná númane egegutata, inda anomi bee siroruta. ");
INSERT INTO bjz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kotú oreki, Jojabee, námane inda buro kakatodu mema bouvu utari gaga regegetua-nu nundubadi reisi-rere. Aghade ege-gea, námane ivisa jará ea, inda Gaga orugha ambi regegore! ");
INSERT INTO bjz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Inda ingo rurugea sonembuturadi-gea, enembo inda Buro Kato kakara, Iesu da ragarova jejebugoe, kotú unda ragarova ari ivata anogha dibe eini be eini ata sirorota, gia enembo nanjogo duduku-dadaka egegoe!” ");
INSERT INTO bjz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Benunu aghá egeguturieta, aná desuturia kambesiva, enda gino-gino ueta, Asisi Kakara vorea númandava asuguturieta, ano bua, God da gaga minono oru ambi regegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iesu gaabee ari kakato, neno kotú nundubari dabako egeguturota, jo endava gugua-ghayafa neno bambi egegeta urie. Númanda gugua-ghayafa dano bua, mino-mino vesa egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aghá urota, Iesu da ambo nimbi 12 God da ano jojabemi, Iesu amburarivareta jebugea eroruria-da Gaganu isagha egeguturie. Aghá uaveta, God númane dano ea simbugea goghó eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Númane dano uvude, undari-baride inono re. Anada bee mo, avodava enda o kambo vitiria-mi utua, guri bua Iesu da ambo nimbi 12 du ututugeta urie. Eaveta, númane bua enemboda irari kotú mema gerurota, guri vesa egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Aghade, enda butu Saiprus embó eini ragaro Josep, umó abua ragaro Levi da rova re. Unona unda enda utua guri bua, Iesu da ambo nimbidava ututurie. Aghá urieta, Iesu da ambo nimbi númane unda ragaro reka Barnabas ririkiguturie. Barnabas da bee mo, Neno Gangoro Utari Kato re. ");
INSERT INTO bjz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","2","Aghá urota, embó ragaro Ananaius nuyae Safaira gha erea, númanda enda eini utua, guri bubuguturie-tago, aná guri jo dano ututugambi re. Ungá unda irari nundubuturota, dumeni righia jijireguturie, kotú dumeni mo, Ananaius na bua furia, Iesu da ambo nimbi dava ututurota eghá ririe, “Endada mino eveko re.” ");
INSERT INTO bjz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aghá ririeta, Pita erea undú ririe, “Ananaius, Satan na kuvieta, imó unda gaa rei-niningoravore. Imó dodu unda gaa niningurota, enda utua guri bera-da dumeni righia jiria, Asisi Kakaradu gavera re? ");
INSERT INTO bjz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Enda inda tofo re. Amindu rea, inda enda bua utua, guri bera dano righia jirasira mo, avore. Aná inda guri re. Avotago, imó dodu guri bera mo, nungia gavera re? Aghá etora mo, imó God da dibeva gavera reravore.” ");
INSERT INTO bjz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Aghá ririeta, Ananaius umó Pita da gaga niningueta, God na ririeta umó jua ambubuturie. Aghá urieta, yarata dumeni terua, unda tamo otoo ea, fumbua aria furuguturie. Aghá urieta, enembo oruabe undava siroruturia kikinu ningia, orumi jarea goghó egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Pita aghá ririeta, jo yafa ambi anada ambova, Ananaius nuyae furia teterurie. Donu siroruturia jo gambi, furia teterurieta, Pita na guri bua iruguturota, undú uriga urie, “Nimugha enda utua guri bera mo, eveko ra, aĩ?” aghá ririeta, Safaira umó “Avoko re!” ririe. ");
INSERT INTO bjz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ririeta, Pita na eghá ririe, “Imó nimugha dodu God da Asisi rei-kukuve? Imó gi! Yarata nimu fumbua iya furugetua, bubaita itoko rousue. Imó beago fumbua ya furugaita rousue,” ");
INSERT INTO bjz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aghá ririeta, umó niningua, God na ririeta umó beago jua ambubuturie. Urieta, yarata furia terua, Safaira ambubuturia-nu gia, umó fumbua rekago kaverea aria, numuda kasava furuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iesu gaabee ari kakato kotú enembo dumenide aghá uria-da kiki niningigea dano orumi jarea goghó egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aghade, Iesu da ambo nimbi 12 mi ari ivata anogha dibe eini be eini eaveta siroreaveta, enembo númane jo gambi iririgeta uria, aná númanda dibemi gia, duduku-dadaka urota mana-mana egegeta urie. Kotú, Iesu gaabee ari kakato nanjogo iiava, Solomon da kambesi God du Tafaroro Ari Kambo roo anava deseta urie. ");
INSERT INTO bjz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Enembo oruabe Iesu da natofodu raga reta egeguturie-tago enembo Ananaius dava donu siroruturia-nu gigigea oru urota, jo ya Iesu da natofode dano takembambi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jo tefo ya numonde takembambi eta egeguturie-tago, God na reaveta, embobo kotú evevetu oruaruabe Iesu gaabee urota, fuava unda natofo egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Uaveta, Iesu da ambo nimbi ari donu eaveta gigiguturota, enembo dumeni erea, kae enembo aná bua fuava, emboro kasava númanda ghaito beisi ea itiaveta vavasegeta urie. Númane eghá nundubeta egeguturie, “Pita furá serigea irurota, unda imumumi jiradua mo, númane jebugaita rousue,” aghá nundubuturota egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Natofo jede, númanda kokomana kae bua iririgari kotú dumeni númandava taimumi asugea kuvigi-kuvigi urota iririgari aná bua, númanda naa mane doa, Iesu da ambo nimbimi rata jejebugari-du rirota fuava, Jerusalem anava bububugeta urie. Aghá uaveta, Iesu da ambo nimbimi reaveta, númane dano jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","18","Iesu da natofo aghá ueta, fristida* beforo righari unda kokomana, Sadyusi* enembode dano, aná kiki niningigea, Iesu da ambo nimbidu mandudu egeguturie. Aghá ea, manaka gaegeguturota, mene-mene ari kakato dumeni ituturieta aria, Iesu da ambo nimbi nandia bua aria diburava gagajeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gagajeguturie-tago, God unda anera eini ututurieta, aná tumbade aria dibura kamboda bebato ifegea, númane unumbea bua furia isaghava buburiturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Bubua isaghava jiria, anerami eghá ririe, “Nímane igige! God du Tafaroro Ari Kambova* terua jijiregadi-gea, enembo nímandava furá desadua-dava jebuga rekada Gaga regege niningigoe!” ");
INSERT INTO bjz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aghá ririeta, númane anerada gaga ningia aria, rifogha God du Tafaroro Ari Kambo rova terua jijiregea iruguturie. Aghá ueta, fristida beforo righari unda kokomanade, aghi egeguturieta, Israel enemboda kanisera* manede dano furia numonde asusumbuguturie. Asusumbea irirota, Iesu da ambo nimbi unumbea bua fufugari-du aghi ititiguturieta kaverea, dibura kambova arie. ");
INSERT INTO bjz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aghá ririeta aria terua, unda ambo nimbi anava tava ea jarea, kaverea furia bubua kanisera manedu regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Námane era bububugetora mo, dibura kamboda bebato gajetueta irieta gigigetore. Kotú kaifa kakato bebato beva jijiregea irieta gigigetore. Númanena bebato ifegetueta teterugetore-tago, Iesu da ambo nimbi anava tefo re,” aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aghá ririeta niningigea, God da Kamboda mene-mene ari kakatoda beforo righari, numonde fristida kokotofude dano, duduku-dadaka ea eghá regeguturie, “Daiyagha reisi-rere?” ");
INSERT INTO bjz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aghá rea niningueta, embó einimi terua ririe, “Atá, nímane niningige! Embobo tumbo diburava gagajegutara, númane daiyaghami ea, God du Tafaroro Ari Kambo rova jijiregea enembodu minono reisi-ri?” ");
INSERT INTO bjz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aghá ririeta, mene-mene ari kakatoda beforo righari-mi erea, unda natofo dumeni bua, Iesu da ambo nimbi nandaita rea igiguturie. Númane oru egeguturota, rourogo enembo númane singoimi dedegauva-degea, Iesu da ambo nimbi roboghami bua fufuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Furia terua, Iesu da ambo nimbi ririeta, kanisera maneda dibeva jijiregea irieta, fristida beforo righari númandu uriga urie. ");
INSERT INTO bjz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Námane rourogo Iesu da ragarova irugara-degea ritare. Avotago, nímanena Jerusalem enava enembo dano iruguturota, Iesu ambubuturia-da yovero námandu reisi-reravore.” ");
INSERT INTO bjz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","30","Aghá ririeta, Pita kotú Iesu da ambo nimbide, númane mino eghá regeguturie, “Námane nímanda gaga jo ningambi aita rosore. Námane God da gaganu niningigaita rosore. Nímane Iesu ifatarava dedegutaravore. Avotago, namonde anda mambube maneda gaabee egegeta uria God, unona Iesu ritata amburarivareta, jebugea erora. ");
INSERT INTO bjz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Utata, God na Iesu bua, kotofu ari-du rirota, enembo kaifa urota jebuga utari-du rea, unda ingo bee kena ituta. Aghá ea, God na Israel enembodu, neno kaverea númanda ari-bari akokogo vuregota nundubea gia doaita rea, emboro ifeguta. ");
INSERT INTO bjz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aná eini-eini gia, námane anadu osagho fufirota vitere. Aghade, God da Asisi Kakara beago, anadu osagho fufirota vitie. Aná Asisi Kakara rera mo, God unda Gaga ningia ambo-ambo egegeta rousua enembodava vesa eta rouvie.” ");
INSERT INTO bjz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aghá regeguturieta, aná babarigari desuturia-mi niningigea, númane neno gambua usera-usera egeguturia-du, Iesu da ambo nimbi data ambubugari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Avotago, Moses da Gaga kaifa kato* eini, ragaro Gamaliel, nghaĩ itaita rea, erorurie. Gamaliel rera umó, Moses da Gaga irugeta urie, kotú enembo dano undú verua egegeta urie. Unona erea, Iesu da ambo nimbi bua ya, kambo subi einiva itari-du ririeta, unda riria aghagonu egeguturieta, umó eghá ririe. ");
INSERT INTO bjz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Anda ikoko mendi, Israel enembo, amó gaga itoko raita rore. Namonde dano nundubea goghó egegore! Jo tutumi data amburari gaa rambi aita rosore. ");
INSERT INTO bjz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Fefera einiva, embó eini ragaro Teudas na kotofuko aita rea, aghi urieta, embobo 400 danode furia, unda ambo nimbi egeguturie. Aghá urieta, gavana erea, Teudas derurieta ambubuturieta, unda ambo nimbi oru susumbugea tará egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Aghá uria-da ambova, gavanami enemboda ragaro barida fefera furia buburituria anava, Galili embó eini, ragaro Judas na Rom enembo tuvia undufa, tofo gavana aita rirota aghi urieta, enembo dumeni ningia danode ea, unda ambo nimbi egeguturie. Kotú gari dabako aghagonu urota, gavana erea, Judas derurieta ambubuturieta, unda ambo nimbi oru susumbugea tará egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Avore, amó eghá rere: namonde ená embobo bua nanandigutara-nu, jo dedegota amburambi aita rousue. Anada bee mo, tofo númanda nundubari-mi kotú, númanda anomi buro egegadua mo, donu eini o bee eini jo sirorambi aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","O God da anomi buro adua mo, jo namonde amó númane buregari inono irambi re. Rourogo namonde tefo, God dava besigago ara-degea rere!” Aghá ririeta, babarigari desuturia, númane niningigea aghá egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Aghá egeguturota, aghi ninenguturieta aria, Iesu da ambo nimbi bua furia teteruguturieta, númane embiimi dedegea anada ambova, babarigari númandu eghá regeguturie, “Mania Iesu da ragarova gaga eini regegata!” aghá rea, númane dotuturieta bububuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kanisera maneda kambo doa, gangorogha aria bububuguturie. Gangoro uria-da bee mo, God númanda gaabee ari gerurota, inono gaa rirota, unda ingo sokinembuturieta, númane Iesu da ragarova, mema tafirota meka gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Númane fefera inono, God du Tafaroro Ari Kambova* kotú enemboda kambo maneva iruguturota, God da Gaga Taubana eghá minono regegeta urie, God namonde anda ari-bari akokogo nundubea gia doaita rea, embó eini utaita riria, aná Iesu umó re. ");
INSERT INTO bjz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Anada ambova, Iesu da natofo furia oruabe ea, númane tutuno ea, Jiusi enembo dumeni Israel anava sirorea númanda gaami regegeta uria-de, kotú Jiusi enembo dumeni Grik gaami regegeta uria-de, numonde mino-mino besiga egeguturie. Grik gaami regegeta uria enembomi eghá regeguturie, “Jojabeeda ambo nimbi namonde anda guri vesa urota, námanda dodorudu ungaghako ututurota, númanda dodorudu, oruabe ututa rousue.” ");
INSERT INTO bjz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aghá regeguturieta ningia, Iesu da ambo nimbimi aghi egeguturieta, Iesu gaabee ari kakato dano bubua desuturieta, eghá regeguturie, “Námane God da Gaganu minono reisi-rogo doa, fefera yafabe tefo ená gurinu enembodu vesa urota iririgadora, aná jo taubana irambi re. ");
INSERT INTO bjz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Avore, námanda ikoko mendi, eghá egege! Embobo dano 7 Asisi Kakarami asugota neno nundubea goghó uaveta gigigeta rosora-nu gatege! Aghá egegea, vesa arida buro númandu ututuge, námane rifo inono benunu urota minono regegore.” ");
INSERT INTO bjz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aghá regeguturieta, aná natofo ningia gangoro egeguturie. Gangoro ea, embó eini Asisi Kakara na asuguturieta neno beda urota, gaabee jojabe urota vitiria, ragaro Stiven nu gateguturie. Kotú embobo dumeni númanda ragaro mane aná, Filip, Prokorus, Nikanor, Timon, kotú Parmenas, númane beago dano gateguturie. Kotú embó eini mo, Antiok embó ragaro Nikolas re. Nikolas unda otu evovo doa, Jiusi enembo dava rekimbea vitirie. Umode dano gateguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aná gateguturia embobonu bua furia, Iesu da ambo nimbidava irugeguturieta, Iesu da ambo nimbimi ingo beforova ititiguturota, númandu benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aghá egeguturieta, enembo God da Gaga ningia fafate ea, Iesu da natofo oruaruabe Jerusalem anava siroruturie. Kotú aghade, fristi* oruaruabe beago Iesu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aná gateguturia embó Stiven, God na ea simbuguturota, ano ututurieta rururie. Bua, unona ari ivata anogha dibe eini be eini eaveta, jo gambi irari enemboda dibeva siroreaveta gia duduku-dadaka egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aghá egegutueta ningia, Jiusi enembo dumeni Stiven de vesó-vesó egeguturie. Jiusi enembo rera, dumeni Sairini reta kotú Aleksandria reta fufuguturia Jerusalem irirota, númanda nghaĩ itari kambo* itia naa avo dighia vitirie. Aná kamboda ragaro mo, “Enembo Sabuada* Irari Doari” aghá ririkiguturie. Aná nghaĩ itari kamboda totofomi Jiusi enembo dumeni Silisia Frovensi kotú Esia Frovensi reta fufuguturia-demi dano takembea tutuno ea, Stiven de besiga egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Aghá urie-tago, Asisi Kakarami neno nundubari ututueta, Stiven gaga esiko-esiko ririeta niningigea, númane mino rari mana-mana egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mana-mana egegea, Stiven da gaga riria aná injigha urota, embobo dumenidu nenomi guri ututuguturieta bua furia, gavera eghá regeguturie, “Stiven umó Moses da Gaga kotú God da Ragaro fara ueta niningigetore,” ");
INSERT INTO bjz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aghá rea, númanena enembode, babarigari kotú Moses da Gaga irugari kakatode* dano neno evuruturieta, aria Stiven nandia, koto aita rea, Jiusi enemboda kanisera* manedava bua igiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Aria buburiturieta, embobo dumeni númanda gaverada osagho fumbari-du rea, aghi urieta furia teteruguturie. Terua, númane kuvia gavera eghá regeguturie, “Ená embó Stiven rifo inono, God du Tafaroro Ari Kambo kakaranu fara urota, Moses da Gaga doari-du reta rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Umó eghá rieta niningigutare, ‘Iesu, Nasaret embó furá, God du Tafaroro Ari Kambo dea bejea, Moses da otu evovo donu itituria, kotú donu iruguturia, unona rata sidara aita rouvie.’ Stiven aghá ritata niningigutare,” gavera aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Númane aghá rea, embobo nanjogo avo desuturia-mi Stiven nu tatasegea gigiguturia mo, unda dibe be kaverea anerada gari aghago ueta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Aghade, aná fristida* beforo righari-mi Stiven du eghá ririe, “Gaa bee reisi-ria? God da Gaga kotú Moses da Gaga doari-du mo, inona rera, aĩ, tefo?” ");
INSERT INTO bjz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aghá ririeta, Stiven umó mino ririe, “Anda ikoko mendide, anda afa manede, nghaĩ javea niningige! Namonde anda mambube Abraham umó jo naa ragaro Heran yambi, roo enda Mesopotemia anava irieta, God duroghade undava isagha urieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Aghade, God na eghá ririe, ‘Inda enembo totofo kotú inda roo enda doa ii, kambesi eini anda utaita rora anava naa dighia asumbadi!’ ");
INSERT INTO bjz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Aghá ririeta, Abraham erea, roo enda Mesopotemia rova unda naa Kaldia doa furia, Heran anava naa dighia irieta, numamo ambubuturie. Urieta, God na rekago ririeta, Abraham erea, Israel eve, namonde anda naava furie. ");
INSERT INTO bjz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Furia buburituria aghade, God Abraham du enda itoko jo utota unda tofo ambi re. Tago God na be gajiturota, undú kotú unda mambube manedu ená enda utaita ririe. God be gajituria fefera aghade, Abraham nuyae mendi sasingu jo fumbambi vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kotú God undú gaga eghá ririe, ‘Fefera ambova, inda imemendi ená roo enda doa ya, roo enda eini númanda tofo irambi anava sabua* ea iririgaita rousue. Aghá urota, roo endada kokotofumi rata, inda imemendi buro fakarabe egeguturota ghaeko 400 sidara aita rouvie. ");
INSERT INTO bjz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anada ambova, anona inda mambube maneda buro fakarabe aita rouvia roo endada kokotofudu númanda ari-bari akokogoda mino aná enembodu utaita rore. Aghá urota, inda mambube mane unumbea bua, aná roo enda doa, kaverea furá, ená kambesiva bubua, Andú tumogha baĩ egegaita rousue.’ ");
INSERT INTO bjz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Aghade, God unda boanda aita be gajari anogha urota, Abraham aná gaga ningia unda boanda aita rouvia-nu iruguturota, vii mendó tafugari-du ririe. Aghá ririeta, Abraham ningia aghagonu urie. Unda mendi Aisak siroruturieta, fefera 8 sidara urieta, Abraham God da Gaga riria-nu nundubea erea, unda mendida vii mendó andoro tafuguturie. Tafuguturieta, Aisak umó baria, evetu bua, unda mendi Jekop siroruturieta-gea, mendida vii mendó andoro tafuguturie. Avore, Jekop umó baria evevetu bua, mendi sasingu siroruturieta-gea, Jekop umó erea unda sasingu vivide dano 12 dava, aná ari dabako aghago egeguturie. Sasingu 12 rera mo, namonde anda mambube manedu rere. ");
INSERT INTO bjz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Mambube mane rera, aná jo uro dabako irambi re. Josep da kaka mane dano 10 re, avotago Josep umó uro einiva re. Amindu rea, Josep da kaka mane undú mandudu egegea erea, númanda ikoko Josep nandia bua, Ishmael enembodava ututurieta, númanena guri utua Josep bua roo enda Isip igiguturieta, Isip enembomi guri utua Josep rururieta, umó sabua urota buro eta urie. Buro ueta, God na umó kaifa gangada urota, dara dibe eini be eini rova sonembuturieta, Josep jebuguturie. Fefera eini, Isip enemboda kini, aghi urieta, Josep undava aria teterurieta, Josep da neno nundubaride irari durumugaride gerurie-gea, kini gangoro urota ririeta, unda kambova eini-einide kotú unda natofode Josep na kaifa eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Aghá ueta, namonde anda roo enda Keinan enava, kotú Isip anava baimana jojabe siroruturieta, undari sidara bee urieta, enembo bee jarea goghó egegutua aghade, namonde anda mambube maneda undari beago sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aghá urieta, Isip anava undari itoko vitiria-nu ningia, namonde anda mambube Jekop unda sasingu ninenguturieta, guri utua undari baita rea, númanda tutunova Isip igiguturie. Unda sasingu rera, aná namonde anda mambube mane re. ");
INSERT INTO bjz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Aná undari bua furia undia sidara egegea anada ambova, rekago kaverea aria buburiturieta, Josep undufa isagha urota, númandava ririe, ‘Amó nímanda ikoko re. Mania andú mana-mana egegata!’ aghá ririeta, Isip enemboda kini umó Josep da enembo totofo tanana urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Anada ambova, Josep aghi ninenguturota, unda nue numamo kotú unda natofo dano 75 ananu rata Isip yari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aghá ririeta ningia, Jekop unona erea, Isip aria bubua avo irirota, Jekop de namonde anda mambube manede dano ambubuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Amburari mo, númanda sasingu nuabua maneda tamo bua iiava kambesi Sekem anava furugeta urie. Sekem rera aná, Jekop da abua Abraham na Hamor enembodava guri dumenimi utua unda ujedu rururie. ");
INSERT INTO bjz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","God umó be gajiturota, Abraham dava enda utaita riria fefera furia utuvako ueta, namonde anda natofo Isip anava sirorea oruabe urieta, God unda be gajari aná rekago nundubuturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","19","Aná fefera furia buburiturieta, Isip enemboda kini mane sirorea-sirorea furia-da rova, númanda kini eini siroruturia-mi, Josep unda natofodeda kiki jo tanana ambi re. Aghá-gea, namonde anda mambube mane kukuvirota, rea bera-bera eaveta, númanda sasingu vivide ambubugari-du bua isaghava ititigeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Fefera aghade, mendi eini gari taubana bee siroruturie, unda ragaro aná Moses re. Moses siroruturieta-gea, nue numamogha kini da gagadu injigha ea kambova undutueta, marabe bakode sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Urieta, nue numamogha mana-mana ea jarea, númanda soká bua isaghava ititurieta, kini da ariri furia, Moses tambua, unda mendi tofo bua unduturieta baborurie. ");
INSERT INTO bjz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses baborurieta-gea, irugari kakato dumenimi iruguturieta, umó Isip enemboda nundubari, beforo gari kotú otu evovo aná dano tanana urie. Tanana ea, Moses umó barirari jojabe eini urie. Aghá ea, unda gagade yavide dano anogha eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Aghá urota, unda ghaeko 40 sidara urieta, Moses umó erea, unda ikoko mendi, Israel enembo gaita rea arie. ");
INSERT INTO bjz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aria buburituria mo, Isip embó einimi namonde anda abua eini derueta gia, anada mino aita rea, Moses na Isip embó derurieta ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Aghá ea, umó eghá nundubuturie, ‘God na ririeta, amó anda totofo unumbea bua, námanda kambesiva yaita furera-nu, númane tanana egegadua-jogo.’ Aghá nundubuturie-tago, unda totofo umó jo tanana egegambi re. ");
INSERT INTO bjz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Aghade, fefera dabako sidara uria-da ambova, namonde amó Israel enemboda mambube mane ungaghami tataya ueta, Moses gia númandu ririe, ‘Niningige! Nímane abua dabako re. Dodu tofo-tofo tataya roso?’ ");
INSERT INTO bjz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Aghá ririeta, embó unda komana deruria-mi erea, Moses bua mimenenguturota ririe, ‘Avona retueta, imó námanda kotofu gaa rirota, námane gia iruraita rio? ");
INSERT INTO bjz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Imó tumbó Isip embó eini derata ambubuta aghagonu, amó data amburari-du rera?’ ");
INSERT INTO bjz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aghá ririeta, Moses aná gaga ningia oru sumbua aria, roo enda Midian anava bubua, esega embó aghago irirota, evetu bua unda sasingu vivide ungagha siroruturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ghaeko 40 sidara urieta, anada ambova, Moses kambesi uvu tefo kotú enembo tefo dafaru Sainai kasava jiria irirota, sifá-sifáva ivari gambua evirota bubura ueta, Moses anera eini bubura rova jiria irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Moses aná gia bee duduku ea aria, utuva tatasegea gia goghó uua mo, Jojabee na undú gaga eghá ririe, ‘Niabua mane, Abraham, Aisak kotú Jekop endava irirota, gaabee egegeta uria, kotú oreki gaabee eta rousua-da God, aná amó re.’ aghá ririeta, Moses ningia, orumi eka ingo dadada urota, rekago gari oru urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jiria irieta, God rekago undú ririe, ‘Inda eka andoro asugea jiria vitera, aná kosuge! Anada bee mo, ená kambesi inda jiria vitera, aná kakara re. ");
INSERT INTO bjz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Anda natofoda mema kotú númanda irari akuago beenu rei-gerore. Isip enembo ari-bari akokogo númandava ueta jii ria-du, amó sonembaita gitofodava voretore. Amindu imó fu, anona ninengota Isip yadi!’ ririe. ");
INSERT INTO bjz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Embó Moses retora, umonu Israel enembomi injigha urota eghá regeguturie, ‘Avona retueta, imó námanda kotofu gaa rirota, námane gia iruraita rio?’ regeguturie. Namonde anda mambube mane Moses injigha egeguturie-tago, umonu God na Israel enemboda kofiri urota sonembota jebugari-du rea, ninenguturieta rekago Isip avo furie. Aná anera, ivari ika sifá-sifáva evirota bubura uua-da rova siroruturieta unda geruria-da sonembava, God na ririeta Moses aghá urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses unona namonde anda natofo unumbea, Isip reta bububuguturia mo, umó Isip anava kotú sovu eini ragaro Karaje Inimba anava, kotú uvu tefo enembo irambi kambesiva ivata anogha dibe eini be eini uta furueta ghaeko 40 sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses rera, unona eghá ririe, ‘God unda feroveta eini amongonu ninengota ya, namonde anda natofoda rorova siroraita rouvie.’ ");
INSERT INTO bjz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kotú Moses unona namonde anda abua manede dano uvu tefo kotú enembo irambi kambesiva irirota, dafaru ragaro Sainai anava anerami gaga jebugadenu ririeta ningia, namonde andú utaita rea gefirie. ");
INSERT INTO bjz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","40","Moses tumanadu irari gaga gefirie-tago, namonde anda abua mane unda gaga jo niningigambi urie. Númane Moses injigha ea erea, Isip kaverea yaita urota, Moses da kaka Aron du regeguturie, ‘Moses umó God gha gaga rirota jo furambi vitie. Umó furadua, aĩ? Jo furambi adua? Amindu, inona ingomi uubu arinu simbuge! Namonde anda god eini sirorea namonde amó kofiri ata yare!’ aghá regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Fefera aghade, númane ingomi uubu ari kosea simbuguturieta eini-eini eto-bato burumakau mendida gari aghago siroruturie. Sirorea, enembo kotofu urie. Amindu rea, númanda god dava vesa ututurota, nino oka dea buria dungea banau egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Aghá egeguturieta, God namonde anda mambube manedava goitu fotiturota, númane injigha ea, uutuva damana ananu tumogha baĩ ari-du rea dotuturie. Donu siroruturia ananu reta, God na ririeta, unda feroveta einimi eghá gefirie: ‘Israel enembo, niningige! Ghaeko 40 uvu kotú enembo irambi kambesiva irirota, nino oka dea buria dungeta urera mo, jo andú vesa utambi egegeta ureravore. ");
INSERT INTO bjz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nímanda god eini ragaro Molek reta rousua anada gari aghago, ingomi kosea, undú dobo ijoko simbugea bua, deĩ urota, gaabee egegeta ureravore. Kotú god eini ragaro Refan reta rousua anada gari damana aghago beago, ingomi kosea, undú dobo ijoko simbugea bua deĩ urota, gaabee egegeta ureravore. Aná nímane nendufako ingomi urera, ananu nímane kakara egegeta ureravore. Amindu rea, anona rata nímanda gitofo ya, nímane bundia bua ya, Babilon serigea yaita rousue,’ God aghá ririeta, Moses na gefirie. ");
INSERT INTO bjz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Namonde anda mambube mane uvu tefo kotú enembo irambi kambesiva irirota, God númandu rea vorea, numonde vitiria-da tano dobo aghago, eembo manemi itia fifinembea simbuguturie. God aná doboda gari kotú unda joja Moses dava iruguturieta, dabako aghago urota, fifinembea simbuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Anada ambova, namonde anda mambube mane ambubuturieta, númanda sasingu kotú imemendi aná dobo bua, Moses da yayo Josua de dano furia, namonde anda roo endava teterugutueta, God na sonembuturieta, namonde anda mambube manena gitofo dumeni dedeguturieta ambubugutueta, dumeni aná oru susumbuguturieta, ená roo enda mambube manena bua, naa dighia asumbea, aná dobo rekago ititurieta, fefera yafabe irieta, Devit siroruturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Siroruturieta, namonde anda mambube Jekop da gaabee eta uria God na Devit da irari kotú unda gaabee ari gia, umó ea simbuguturie. Amindu, Devit na God da kambo bee itaita ririe. ");
INSERT INTO bjz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aghá ririe-tago, Devit na kambo itari aná God injigha urieta-gea, Devit da mendi Solomon na ititurie. ");
INSERT INTO bjz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ititurie-tago, God iti beeva mo, jo kambo enembomi itari anava irambi eta rouvie. Ananu nundubuturota, God da feroveta einimi eghá gefirie. ");
INSERT INTO bjz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Jojabee eghá reirie, Ená uutu anda asumbari kambesi re. Kotú enda anda eka itari kambesi re. Gigige! Atá nímane anda kambo daiyaghagonu ititigado? O anda irari kambesi niavo simbugado? Ená uutu enda dano anona urieta siroruturie.’ ");
INSERT INTO bjz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Avore, nímane dano gogore kakato re! Nímanda neno airo tofo gitofo dago urota, God jo gaabee egegea unda Gaga ningambi egegeta rosoravore. Nímanda mambube mane ari daiyagha urota, God buregeta egeguturia aghagonu, nímane Asisi Kakara buregeta rosoravore. ");
INSERT INTO bjz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nímanda mambube mane God da feroveta nanjogodava ari-bari akokogo egeguturie. Kotú feroveta dumeni, God da Buro Kato taubana eini ninengota furaita rouvia-da minono regegeta uria-nu, númanena dedeguturieta ambubuguturie. Kotú nimambube mane aghagonu urota, nímane God da Buro Kato taubana bee bua, gitofodava ututata, númanena dedegutata ambubuta. ");
INSERT INTO bjz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God na ririeta, unda Agho Dari anerami bua furia ututurieta, nímanda enembo kotú nímandava ututurieta bubugutureravore-tago, nímane aná Agho Dari jo ambo-ambo ambi egegeta rosoravore,” Stiven umó gaga aghá rea sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Babarigari desuturia-mi, Stiven da gaga niningigea, númanda neno gambua susughi egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Aghá egeguturie-tago, Asisi Kakara Stiven dava asuguturieta, neno rova beda ea vitiria-du, umó dibe uutuva ea, God da unana duroghagha kotú Iesu God da ingo bee kena jiria irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Gerurota, eghá ririe, “Gigige! uutu ifegetueta, amó Enemboda Jojabee* God da ingo bee kena jiria irieta rei-gerore,” ");
INSERT INTO bjz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","60","Aghá ririeta, númane unda gaga injigha ea koko rirota, númanda nghaĩ ingomi gagajeguturota, sumbua umó nanandiguturie. Nandia ghambugea bua aria, Jerusalem isaghava bubua, fugiturieta, umó endava jujururie. Jujururieta, aná embobo Stiven da tamova gavera regeguturia-mi númanda eembo koburunu kosugea, gimasa einida eka tuva ititiguturieta kaifa urie. Ená gimasa rera-da ragaro, aná Sol re. Aghá ea, Stiven singoimi dedegutueta, umó ririe, “Jojabee Iesu, anda asisi inona bu!” aghá rea, umó koubomi jengirea be jojabe ririe, “Jojabee, ari akuago oreki andava rousua, ená nundubea gia do!” aghá rirota, ambubuturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Embobomi Stiven dedeguturieta ambubuturia-du, Sol “Avore” rea gangoro urie. Fefera aghade, Jerusalem enembo dumeni erea, Iesu da yaverodu ari-bari akokogo urota, bouvu ututuaveta mema itatama egegeta urie. Gaabee ari enembo dano oru ea erea, kambesi-kambesi Frovensi Judia kotú Samaria anava tará ea igiguturota, Iesu da ambo nimbi 12 nu Jerusalem dotuturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Stiven ambubuturieta-gea, embobo dumeni God gaabee egegeta uria, númanena undú neno mema urota aria, umó bua aria furuguturota, dari sorara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol na, Iesu da yavero data amburari-du rea, númanda kambo mane bejea terua, Iesu da yavero, embobode evevetude nandia, kambo rova reta ghambugea bua iiava diburava gajeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iesu da yavero naa ari naa ari sokanengea aria, Iesu da Gaga irugeta egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Aghá ueta, Filip erea aria, bogu naa eini Samaria Frovensi anava buburiturie. Bubua irirota, God na Embó jojabe eini ninenguturieta furia-da gaganu Samaria enembo dava minono reta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Minono reaveta, deseta uria enembomi Filip da gaga ningia goghó egegeta urie. Anada bee mo, Filip ari ivata anogha dibe eini be eini eaveta, númanda dibeva siroreaveta gia, duduku-dadaka egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip na taimu mane beago tuveta urie. Umó reaveta, taimu mane koko rirota enembo oruabeda tamo rova reta doa, kasava voreta urie. Kotú enembo dumeni eka ingo dimbaride mane reaveta jejebugeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aghá ueta, Samaria bogu naava enembo gangoro jojabe egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10","Samaria bogu naa dabako anava, embó eini ragaro Saimon na irieta, Filip ambova furie. Saimon kae righia ingi furiturota simboro reaveta-gea, enembo dano duduku-dadaka egegeta urie. Aghá egegutuaveta, umó eghá reta urie, “Amó embó akuago eini re,” reaveta, enembo, kokotofude sabuade* dano, unda gaga niningigeta urie. Ningia, Saimon dava God da ano irari gaa rea, undú “Ano Jojabeda Tofo” regeguturota, umó kakara egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Umó fefera yafabe, kae ririkurota simboro eaveta-gea, enembo duduku-dadaka egegeta urie. Amindu rea, unda donu rari ningia, aghagonu egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Saimon da gaga niningigeta urie-tago, anada ambova Filip furia, God da Gaga Taubananu minono rieta, enembo niningiguturie. God namonde amó daiyagha kaifa eta rouvia, kotú God daiyagha Iesu Keriso ninenguturieta furia-nu niningigea, unda gaga gaabee egeguturieta, Filip na enembo, embobode kotú evevetude bua, bafutaito urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon beago Filip da gaga ningia, gaabee ea ririeta, Filip na umó bafutaito urieta, umó fefera yafabe Filip da ambova deĩ eta urie. Filip umó ari ivata anogha dibe eini be eini eaveta, Saimon da dibeva siroreaveta gia duduku eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iesu da ambo nimbi Jerusalem irirota, Samaria Frovensiva enembo daiyagha ea, God da Gaga ningia gaabee egegeta uria, ananu ningia, Pita ungá Jon gha ninenguturieta, Samaria enembodava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ungá aria Samaria bubua, God gaabee egegeta uria enembodu, Asisi Kakara vorea númandava asugari-du benunu egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Anada bee mo, Filip na númane Jojabee Iesu da ragarova bafutaito urie. Tago Asisi Kakara jo vorea, númandava asugambi vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Amindu Pita ungá Jon gha benunu urota, númanda ingo mane enemboda beforova ititiguturieta, Asisi Kakara vorea númandava asuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Iesu da ambo nimbi ungá unda ingo mane enemboda beforova ititiguturieta, Asisi Kakara vorea asuguturia-nu, Saimon na gerurie-gea, umó Pita ungá Jon gha dava, aghá arida anonu baita rea, guri utaita ririe. ");
INSERT INTO bjz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Rirota, umó eghá ririe, “Aghá arida anonu andú bofu-gea, anda ingo enemboda beforova itadora mo, Asisi Kakara númandava vorea asugoe.” ");
INSERT INTO bjz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aghá ririeta, Pita undú eghá ririe, “Inda gurigha amburadi rere. Imó God da vesa jo gurimi utua bambi aita roravore. ");
INSERT INTO bjz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Anada bee mo, inda neno roo God da dibeva jo taubana irambi re. Amindu, imó airo bee re. Imó jo namonde dano deĩ ambi aita roravore. ");
INSERT INTO bjz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Neno kaverea, inda ari akuago karigea doa, Jojabeedava benunu ege-gea, inda neno roomi sembago rei-nundubutora-nu nundubea gia doae! ");
INSERT INTO bjz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Imó námanda ano gia, muu nendera anami, Satan na imó bundetueta viteravore, aghá rei-gerore.” ");
INSERT INTO bjz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Aghá ririeta, Saimon umó erea, Pita ungá Jon gha dava mino eghá ririe, “Ariee, ingá Jojabeedava andú benunu egege-gea, andava sembago furueta regegetora aná, andava dano jo sirorambi ae!” ririe. ");
INSERT INTO bjz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Anada ambova Pita ungá Jon gha Jojabeeda númane daiyagha sonembuturia-nu isagha ea, Jojabeeda Gaga ananu minono regegeta urie. Anada ambova, númane erea kaverea, Jerusalem irurota, emboro rorova númane Samaria Frovensi anava, naa dumeni dumeniva terua, God da Gaga Taubananu minono rita igiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Anada ambova, Jojabeeda anerami Filip du ririe, “Imó indufa simbugea ii bubua jiria, dibe fefera vitari kena fuge, kaverea ingo bee kena yadi rere! Ya, emboro daya einiva bubadora mo, daya yoveni iya, naa ragaro Gasa bubua vitie. Kotú daya yoveni iya, bogu naa ragaro Jerusalem bubua vitie. Anava bubua jiradi, rere!” ");
INSERT INTO bjz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aghá ririeta, Filip erea aria, Itiopia embó eini furueta tafirie. Aná embó umó, roo enda Itiopia da kotofu evetu, ragaro Kandasi sonembeta urie. Sonembuturota, unda guri mane dano unona kaifa eta urie. Aná embó sei unda kambesi doa Jerusalem aria, God dava benunu ea doa, ");
INSERT INTO bjz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","unda ombo ghaava* vitia kaverea furie. Unda ghaa sariot reta rouvia ananu, hosi mi ghambugea ita rouvie. Aná embó ghaava asumbea fururota, God da feroveta Aisaia da ingisonu irugutueta, Filip gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Gerurota irieta, Asisi Kakarami Filip du ririe, “Ii, sariot kasava jiria ingá yadi!” ");
INSERT INTO bjz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aghá ririeta, Filip umó erea sumbua aria sariot dava bubua, feroveta Aisaia da buka irugutueta niningurie. Ningia eghá ririe, “Aná rei-irugutora-da bee, imó tanana rora?” ");
INSERT INTO bjz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Aghá ririeta, guri kaifa katomi mino ririe, “Amó daiyagha enada bee ga? Inona sonembadora mo, ená gaga rei-irugutora-da bee gaita rore,” aghá rirota, umó Filip vitia unda kasava asumbari-du ririe. ");
INSERT INTO bjz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Aná embóda iruguturia gaga, aná evere: “Nino oka sifi dea, buraita rea, bua yaita rouvia mo, jo be rambi aita rouvie. Kotú sifi mendida segha giriri aita rea, bua yadua mo, umó jo be rambi aita rouvie. Dabako aghagonu, aná embó dava fakarago urota, umó jo undufa sonembaita rea, gaga eini jo rambi re. ");
INSERT INTO bjz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Umó dedeguturia mo, eto-bato bagha eini darigo egeguturieta, meka gerurie. Umó embó taubana re-tago, ari-bari akokogo embó gaa rirota koto egeguturie. Umó derurieta ambubuturia-du, umó imendi gamendi tefo re.” aná embómi ená gaga irugea sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sidara urieta, guri kaifa kato Filip du eghá ririe, “Rege ningore! Aisaia mo, ená gaga tofo undufako undú riria, aĩ? Embó einidu riria?” ");
INSERT INTO bjz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aghá ririeta, Filip umó Aisaia da gaga anava tutuno ea, Iesu da Gaga Taubananu undava iruguta arie. ");
INSERT INTO bjz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Aghá uta, emborova irurota, uvu einiva buburiturie. Bubua, guri kaifa katomi ririe, “Gigo! Ená uvu vitia-va, amó bafutaito adora mo, avora?” ");
INSERT INTO bjz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aghá ririeta, Filip na ririe, “Imó gaabee ea goghó adora mo, imó bafutaito aita rore,” ririeta, aná embómi ririe, “Amó gaabee rore. Iesu Keriso umó God da Mendi bee re.” ");
INSERT INTO bjz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aghá rirota, unda buro kakatodu sariot righia jirari-du ririe. Tukú ea jijireguturieta, aná embó umó Filip gha dano aria uvuva vovorurie. Vorea, Filip na aná embó bafutaito urie. ");
INSERT INTO bjz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aghá ea, ungá uvuvareta kaverea vivitua, jo gaimbo ambi Jojabeeda Asisimi Filip rururieta, aná embó gangorogha God du raga rita arie. Tago, umó Filip rekago jo gambi re. ");
INSERT INTO bjz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Asisi Kakara Filip bua aria, bogu naa eini ragaro Asdot anava ititurie. Filip na Asdot anava tutuno ea, anavareta irurota, naa ijoijokokova God da Gaga Taubananu minono rita aria, bogu naa Sisaria avo buburiturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Filip na aghá urota irieta, Sol na Iesu da yaveronu data amburari-du jajari eta urie. Amindu umó fristida* beforo righari dava aria, benunu eghá urie, “Imó amó daiyagha asira-nu ingisova gembu-gea bua, amó ya bogu naa Damaskus anava namonde amó Jiusi enemboda nghaĩ itari kambova* enembo dumenidu irugota gigigea númanena sonembota, amó Iesu da yavero Jojabeeda Emborova deĩ egegeta rousua embobode kotú evevetude anava tambadora-nu, nandia bundia bua, kaverea furá, Jerusalem bububugore.” ");
INSERT INTO bjz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aghá ririeta, fristida beforo righarimi Sol sonembuturieta-gea, umó erea Damaskus arie. Aria, naa kasava bubaita itoko uua mo, jo gaimbo ambi unana uutuvareta undava janimbuturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","5","Aghá urieta, umó endava jua vasia niningueta, beda eromi undú eghá ririe, “Sol! Sol! Imó dodu andava neno mema ututurota vite?” Aghá ririeta ningia, Sol umó eghá ririe, “Ariee, Jojabee, imó avouvi?” ririeta, aná beda ero rekago ririe, “Amó aná, Iesu reta righia siosa rioravore! ");
INSERT INTO bjz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Avoreta, imó erea ii, naava bubadi-gea, imó donu aita rora avo rata ningadi,” aghá ririeta niningurie. ");
INSERT INTO bjz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sol de igiguturia enembo dumenimi, avo tukú ea jiria be sidara egeguturie. Sol du donu riria aná, númane dano beda eronu niningiguturie-tago, avona be riria enembo jo gigigambi re. ");
INSERT INTO bjz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Aná gaga rea sidara urieta, Sol umó endavareta erea, dibe fangiturie. Dibe fangiturie-tago, Sol umó eini-eini donu jo gambi urie. Aghá uria-du, Sol unda kokomanami umó ingova righia bua aria, Damaskus bubua teteruguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Avo terua, Sol umó dibe fangea, eini-eini jo gambi kotú undari o uvu undambi irirota, onembo bakode sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iesu da gaabee ari kato eini, ragaro Ananaius, umó Damaskus irirota, barauva Jojabee gerueta, undava eghá ririe, “Ananaius!” ririeta, umó eghá ririe, “Jojabee, amó enanu vitere.” ");
INSERT INTO bjz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Aghá ririeta, Jojabee undú eghá ririe, “Imó erea ii! Emboro ragaro Dambudogova ii, Judas da kambova terua, Tarsus embó eini, ragaro Sol avo benunu urota vitieta, undú uriga ea ningi! ");
INSERT INTO bjz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol benunu urota, unda barauva, embó eini ragaro Ananaius na iya terua, unda dibe taubana ari-du rea, ingo unda tamova righia-nu gie.” ");
INSERT INTO bjz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Aghá ririeta, Ananaius eghá ririe, “Jojabee, enembo oruabe Sol da ari-bari akokogo dano unona Jerusalem fefera inono inda yaverodava eta rouvia-nu andú isagha eta rousue. ");
INSERT INTO bjz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kotú oreki umó aná fristida kokotofuda ragarova enembo inda ragarova tumogha baĩ eta rousua-nu nandia bundaita rea reifie.” ");
INSERT INTO bjz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Aghá ririeta, Jojabee Ananaius du mino eghá ririe, “Imó erea ii! Anada bee mo, amó sonembari-du rea, umó gategetore. Umó anda ragarova minono rata, Jiusi enemboda gitofo, endada kokotofu kotú Jiusi enembo dumeni amó tanana egegari-du, gategetore. ");
INSERT INTO bjz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kotú, anona andufa iruguturota, Sol anda ragarova mema daiyagha kotú mema donu itatama aita rouvia-nu gia goghó aita rouvie.” ");
INSERT INTO bjz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Aghá ririeta, Ananaius umó erea aria, kambova terua, unda ingomi Sol da tamova ririkurota, eghá ririe, “Anda ikoko Sol, imó Jojabee Iesu emborova fururota geraravore. Inda dibe taubana ari-du, kotú Asisi Kakara indava vorea asugari-du, Iesu na ninengetueta amó etere.” ");
INSERT INTO bjz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Aghá ririeta, eini-eini uvu okada taatagomi Sol da dibevareta jujururieta, unda dibe taubana urie. Aghá urieta, Sol erea, benunu urieta, umó bafutaito urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aghá urieta, Sol umó undari undia, ano bua jebuguturie. Sol fefera dumeni Iesu da yaverode Damaskus vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Aghade, gaimbo ambi umó tutuno ea, Jiusi enemboda nghaĩ itari kambo* anava iru-furu urota, Iesu da ragarova minono reta urie. Aghá urota, umó eghá reta urie, “Iesu umó aná, God da Mendi bee re,” reta urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Enembo númane, Sol da aghá riria-nu ningia, duduku-dadaka ea mana-mana egeguturota, eghá regeguturie, “Ená embónu nundubea gigige! Embó eini, Jerusalem enembo Iesu da ragaronu rea tumogha baĩ egegeta rousua-nu, deaveta ambubugeta rousua, aná umó ra, aĩ? Kotú embó eini Iesu da yavero enava nandia, God da fristida* kokotofudava utaita rea futa, aná embó mo evera? Avotago, ená embó mo daiyagha gaga dibe eini reiri?” regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aghá reaveta, Sol unda ano dano ititurota, minono reta urie. God na Iesu ninenguturieta furia ananu irugea goghó urieta, Jiusi enembo Damaskus irita uria-mi niningigea, mana-mana ea be sidara egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Fefera dumeni sidara urieta anada ambova, Jiusi enembo númane Sol data amburari-du rea, bubua danode desea, manaka gaegeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Avotago, númane donu riria aná, Sol umó niningurie. Númane Sol nu nandia data amburari-du tumba onembo aná naa ghoukada bebato beva jiria kaifa egegeta urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aghá egegeta ueta, tumba einiva, Sol unda yaveromi erea, umó bua kararava fendia tino ea, toova ititurieta vorea jiria seriguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol aria, Jerusalem bubua, umó ya Iesu da yaverode takembasue-tago, númane umó jo gaabee ambi egeguturie. Umó sei númandava ari-bari akokogo eta uria-du, númane oru egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Oru egegutueta gerurie-gea, Barnabas na erea, Sol sonembea, umó bua aria, Iesu da ambo nimbidava teterurie. Terua, Sol na daiyagha emborova irurota, Jojabee geruria, kotú Jojabee Iesu na daiyagha Sol dava gaga riria ananu, Barnabas na númandu iruguturie. Iruguturota, Sol umó daiyagha Jiusi enembo dava jo oru ambi, Iesu da ragarova Damaskus avo minono reta uria-nu iruguturieta, númane niningiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Sol na Iesu da yavero kena terua, numonde danode irirota, iru-furu urota, jo oru ambi, Jerusalem naava Jojabeeda ragarova minono reta urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Aghá ea, Sol erea, Jiusi enembo dumeni Grik gaa reta uria-de, gaa rea besiga urie. Besiga ea, númane Sol data amburari-du regeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aghá regeguturieta, Iesu da yavero dumenimi ningia, Sol bua aria, bogu naa ragaro Sisaria anava jiria, umó ninenguturieta, Tarsus naava arie. ");
INSERT INTO bjz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Fefera aghade, frovensi dano bakode, Judia, Galili kotú Samaria anava, dara, bouvu o neno mema eini Iesu da yaverodava jo sirorambi re. Asisi Kakarami sonembutuaveta, Iesu da yavero neno nundubari taubana urota, Jojabeedu kakara eta urie. Aghá urota, Iesu da yavero oruaruabe siroreta urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita umó natofo kaifa urota, naa nanjogo iru-furu eta urie. Goroto einiva umó erea, God da natofo gaita rea, naa ragaro Lida anava esega arie. ");
INSERT INTO bjz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aria bubua, Pita na embó eini eka ingo dimbaride, ragaro Ainias nu tafirie. Aná embó kambo rova faro itiva vasia irieta, ghaeko dano 8 sidara urie. ");
INSERT INTO bjz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Tambua, Pita na undú eghá ririe, “Ainias, Iesu Keriso na retueta, imó rei-jebugutoravore. Imó erea, inda ghaito borea iti!” Aghade, Ainias gaimbo ambi jebuguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jebuguturieta, Lida naava kotú Saron naava enembode dano umó avo gia, neno kaverea Jojabee gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Naa ragaro Jopa anava, Iesu du gaabee eta uria evetu eini ragaro Tabita vitirie. Aná evetuda ragaro, Grik gaami Dorkas reta urie. Umó fefera inono enembo sonembuturota, unda gugua-ghayafami makasi enembo sonembuturota vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Fefera aghade, umó kae bua ambubuturieta, númane unda tamo bua, uvumi gutia simbugea bua aria, iti kamboda rova ititiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa naavareta ya Lida bubari, jo airobe irambi re. Pita umó Lida naava esega furia irieta niningigea, Iesu da yavero Jopa vitiria-mi embobo ungagha ninenguturieta aria, Pita dava buburiturie. Bubua, Pita du ririe, “Fu, namonde tutumi yare!” ");
INSERT INTO bjz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aghá ririeta, Pita erea, numonde aria buburiturieta, natofo erea, Pita bua iti kambova viviturie. Dorkas da sonembeta uria dodorumi dano furia Pita fugea ovenembea dari sorara urota, Dorkas da asugari mane fifinembea ututuria-nu bua, Pita kena iruguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Aghá urieta-gea, Pita na ririeta, aná enembo dano erea isaghava bububuguturie. Pita na koubomi jengirea benunu ea sidara ea, kaverea dibe umó kena ea, unda ragaro beenu rirota, “Tabita, ere!” ririeta, aná evetu dibe fangea Pita gia erea asumbuturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Asumbuturieta, Pita na ingo sinia aria, unda ingova bua ririkurieta erorurieta, ghogho ririeta, Iesu da yaverode aná dodorude dano furia bububuguturieta, Dorkas jebuguturia-nu iruguturieta gigiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Aghá uria-da bingá aná aria fafate urieta, Jopa naava enembo dano niningigea, Jojabeenu gaabee egeguturie. ");
INSERT INTO bjz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Aghá urieta, Pita umó itoko yafago avo unda akau Saimon gha vitirie. Saimon rera, umó nino okada andoro ananu bua, ingimi simbugea, enembo dumeni dava ututurota, guri buta urie. ");
INSERT INTO bjz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Rom embó eini, ragaro Konilius umó Rom enemboda mene-mene ari kakatoda noni ragaro Itali da beforo righari eini ea, Sisaria bogu naava irita urie. ");
INSERT INTO bjz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Umó aná God gaabee ari embó eini re. Aghá-gea, umó unda evetu mendi sasingude dano God nu tumogha baĩ urota, unda ragaronu righiaveta ereta urie. Umó amindu sonemba jojabe Jiusi makasi enembodu ututa urie. Kotú God dava benunu tumanadu urota vitirie. ");
INSERT INTO bjz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aghade fefera einiva, ungobo 3 koroki ueta, umó barau eghá urie. God da anerami undava isagha ea eghá ririe, “Konilius!” ");
INSERT INTO bjz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ririeta, Konilius na aná aneranu orugha tatasegea gerurota eghá ririe, “Jojabee, inda uno doro?” ririeta, aná anerami undú mino eghá ririe, “God inda benunude kotú inda enembo sonembeta rora-du gangoro urota, inda benunuda mino rei-simbugutue. ");
INSERT INTO bjz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Avota, oreki aghi kakato ninenge-gea, ya Jopa naava bubua, embó ragaro Saimon kotú, dabako undú Pita reta rousua-nu bua furoe! ");
INSERT INTO bjz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Umó unda akauda kambova vitia-du tambaita rousue. Unda akau Saimon rera, umó nino okada andoronu bua ingimi simbugea, enembo dumenidava utua guri buta rouvie. Unda kambo karaje divareta gi!” ");
INSERT INTO bjz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aghá rea doa, aná anera kaverea arieta, Konilius erea, unda kamboda sabua* aghi ari embobo ungagha kotú umó kaifa ari kato mene-mene embó einide dano ghogho ririeta, undava fufuguturie. Aná mene-mene embó beago God gaabee eta urie. ");
INSERT INTO bjz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konilius na aná enembo bakodenu ninenguturota, anerada donu riria dano ririeta númane niningigea, Jopa naava igiguturie. ");
INSERT INTO bjz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Aria, rorova evia rifo atiturieta erea aria, onembode aghago Jopa naava bubua terua irueta, aghade, Pita benunu aita rea kambo sebova viviturie. ");
INSERT INTO bjz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Aghade umó baimana itatama urota, undari undasua-nu uno urie. Aghá ueta undari simbugutua mo, Pita umó barau urie. ");
INSERT INTO bjz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Unda barauva geruria mo, uutu ifeguturieta, eembo beragha bee unda mendó dano ungagha-ungagha aghagomi uutuvareta ititurieta, endava vovorueta gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aná eemboda rova enda etova genau-bagena kotú dii mane, ningabu, nomburade dano irieta gerurie. ");
INSERT INTO bjz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aghade beda eromi eghá ririe, “Pita, erea dege amburota undadi!” ririe. ");
INSERT INTO bjz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tago, Pita umó eghá ririe, “Tefo, Jojabee. Inona rirera-du, námane Jiusi enembo ená eini-eini rei-gerora, dano tama urota jo undambi eta rosore. Ená eini-eini aná akuago re. Amó itoko jo undambi eta rore.” ");
INSERT INTO bjz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aghá ririeta, beda eromi rekago Pita du eghá ririe, “Eini-eini donu God na undari-du ea simbugadua mo, mania akokogo gaa rata!” ririe. ");
INSERT INTO bjz_vpl VALUES ("AC10_16","074_10_16","ACT","10"