﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjvNT_vpl;
CREATE TABLE bjvNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjvNT_vpl WRITE;
INSERT INTO bjvNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Gɨn ka lə Jəju Kɨrɨsɨ kɨ ngon ka *Dabɨdɨ, kɨ ngon ka *Abɨrakam ə to kɨn: ");
INSERT INTO bjvNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abɨrakam ojɨ *Isakɨ, Isakɨ ojɨ *Jakobɨ, Jakobɨ ojɨ Juda kɨ ngako̰e je. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda əi kɨ Tamar oji Parəsɨ əi kɨ Jara, Parəsɨ ojɨ Əsɨrom, Əsɨrom ojɨ Aram, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ojɨ Amɨnadabɨ, Amɨnadabɨ ojɨ Naso̰, Naso̰ ojɨ Salmo̰, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo̰ əi kɨ Rakabɨ oji Bowajɨ, Bowajɨ əi kɨ Rutɨ oji Obədɨ, Obədɨ ojɨ Jəse, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jəse ojɨ ngar Dabɨdɨ. Dabɨdɨ taa ne Uri ojɨ-n Salomo̰, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","*Salomo̰ ojɨ Robowam, Robowam ojɨ Abɨya, Abɨya ojɨ Aja, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aja ojɨ Jojapa, Jojapa ojɨ Joram, Joram ojɨ Ojɨyasɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojɨyasɨ ojɨ Jowatam, Jowatam ojɨ Akajɨ, Akajɨ ojɨ Ejəkɨyasɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejəkɨyasɨ Ojɨ Manasɨ, Manasɨ ojɨ Amo̰, Amo̰ ojɨ Jojɨyasɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jojɨyasɨ ojɨ Jəkonɨyasɨ kɨ ngako̰e je. Dɔkagɨloe tɨ kɨn ə uwəi dɨje kɨ Jorijaləm awi səde ɓəə *Babɨlon tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lokɨ awi səde Babɨlon tɨ, Jəkonɨyasɨ ojɨ Salatɨyəl, Salatɨyəl ojɨ Jorobabəl, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabəl ojɨ Abɨyudɨ, Abɨyudɨ ojɨ Eliyakɨm, Eliyakɨm ojɨ Ajɔr, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajɔr ojɨ Sadokɨ, Sadokɨ ojɨ Akɨm, Akɨm ojɨ Eliyudɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudɨ ojɨ Eliyajar, Eliyajar ojɨ Mata̰, Mata̰ ojɨ Jakobɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobɨ ojɨ Jɨsəpɨ kɨ ngaw mari. Nɨngə Mari ojɨ Jəju kɨ ɓari-e Kɨrɨsɨ kɨ e dəw kɨ Luwə mbəte. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ɨlə ngɨre dɔ Abɨrakam tɨ bɨtɨ dɔ Dabɨdɨ tɨ, gɨn kojɨ e dɔgɨ gɨde sɔ, ə ḭ dɔ Dabɨdɨ tɨ bɨtɨ kaw ɓəə Babɨlon e gɨn kojɨ dɔgɨ gɨde sɔ, taa ḭ dɔ kaw ɓəə Babɨlon tɨ bɨtɨ kojɨ Kɨrɨsɨ tɨ, e gɨn kojɨ dɔgɨ gɨde sɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Go rəbɨ kojɨ Jəju Kɨrɨsɨ ə to kɨn. Ko̰e Mari e nje nongɨ lə Jɨsəpɨ kɨ uwə dɔe. Nɨngə, lokɨ ɨngəi-naa dəne kɨ dɨngəm al ɓəy ə, Mari ḭ səm kɨ tɔgɨ lə NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lo kɨn tɨ no̰o̰ be, Jɨsəpɨ kɨ nje nongɨ lə Mari, kɨ e dəw kɨ dana, ndɨgɨ kadɨ n-əl ta kɨn kɨ taga n-ɨlə-n rɔsɔl dɔ Mari tɨ al, adɨ ɔjɨ mene tɨ kadɨ n-ɨyə̰i-naa kɨ Mari gɨdɨ ngə̰y par. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lokɨ ɔjɨ ta kɨn be mene tɨ nɨngə, malayka lə Ɓaɓe tḛḛ hɔy me ni tɨ əl-e ə nə: «Jɨsəpɨ, ngon ka *Dabɨdɨ, ɨɓəl al kadɨ ɨtaa Mari nei tɨ, tadɔ ngon kɨ to mee tɨ kɨn, e ngon kɨ re kɨ go rəbɨ lə NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari a ojɨ ngon kɨ dɨngəm, nɨngə a ɨndə tɔe nə Jəju, tadɔ e ə e dəw kɨ a ajɨ dɨje ləne me majal je tɨ ləde.» ");
INSERT INTO bjvNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nḛ je kɨn pətɨ a rai nḛ be mba kadɨ ta kɨ Ɓaɓe əl kɨ ta nje kəl ta kɨ tae tɨ kəte nu kɨn tɔl tane: ");
INSERT INTO bjvNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ɓaɓe əl ta kɨ ta nje kəl ta kɨ tae tɨ ə nə: «Oi ngon kɨ mandɨ kɨ gər dɨngəm al ɓəy a ḭ səm, A ojɨ ngon kɨ dɨngəm, Nɨngə a ɓari-e nə Emanuwəl, Kɨ kɔr gɨne nə: “Luwə e səje”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lokɨ Jɨsəpɨ ndəl dɔ ɓi tɨ, ra təkɨ malayka əl-e-n, adɨ taa Mari nene tɨ, re sie kəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nə gər-e kɨ dəne kɨ dɨngəm tɨ al, bɨtɨ kadɨ Mari ojɨ-n ngon Ojɨ ngon kɨ dɨngəm, adɨ Jɨsəpɨ ɨndə tɔe nə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oji Jəju Bətɨləhəm, dɔnangɨ kɨ Jude tɨ, dɔkagɨlo ko̰ɓe tɨ lə ngar Erodɨ. Go koje tɨ, njé nḛ gər je kɨ dɔ mee je tɨ, ḭḭ lo kɨbə kadɨ tɨ rəi Jorijaləm, ");
INSERT INTO bjvNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nɨngə dəji əi nə: «NGar lə *Jɨpɨ je kɨ oji-e kɨn e ra be ə? J-o mee lie tḛḛ lo kɨbə kadɨ tɨ ə jɨ re kadɨ j-ɔsɨ məkəsɨje nangɨ no̰e tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lokɨ NGar *Erodɨ oo ta kɨn, mee gangɨ man, naa tɨ kɨ dɨje kɨ Jorijaləm tɨ ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Be ə, ngar kaw kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je lə Luwə, dəjɨ-de se lo kɨ ra be ə a oji Kɨrɨsɨ kɨ e *Dəw kɨ Luwə mbəte tɨtɨ wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ə əli-e əi nə: «A oji-e Bətɨləhəm, dɔnangɨ kɨ Jude tɨ, tadɔ ta kɨ nje kəl ta kɨ ta Luwə tɨ əl ə to kɨn: ");
INSERT INTO bjvNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Səi dɨje kɨ Bətɨləhəm kɨ dɔnangɨ tɨ kɨ Jude, Kadɨ ɨgəri təkɨ rɔjetɨ, Ɓe ləsi e kɨ ndae goto al jagɨ dan ɓe bo je tɨ kɨ dɔnangɨ kɨ Jude tɨ, kɨ ndade to tɨ, Tadɔ ngar kɨ nje kɔr no̰ dɨje ləm, je a tḛḛ dansi tɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lo kɨn tɨ, Erodɨ ɓa njé nḛ gər je kɨ dɔ mee je tɨ gɨdɨ ngə̰y, dəjɨ-de se dɔkagɨlo kɨ ra wa bangɨ ə mee tḛḛ-n wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɓa go tɨ, ɨlə-de Bətɨləhəm tɨ ə nə: «Awi ɨdəji ta kɨ rɔjetɨ dɔ ngon tɨ kɨn. Lo kɨ ɨngəi-e ɓa, ɨrəi əli-mi adɨ mi ka m-aw m-ɔsɨ məkəsɨm nangɨ no̰e tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Go ta tɨ lə ngar kɨn ɓa, njé nḛ gər je osi dɔ rəbɨ tɨ ɨsɨ awi. Ə lokɨ ɨsɨ awi nɨngə yə ooi mee ka kɨ ooi-e lo kɨbə kadɨ tɨ ka kɨn ə a njɨyə no̰de tɨ. NJɨyə re tḛḛ dɔ kəy tɨ kɨ ngon to tɨ ɓa, a lo ka tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lokɨ ooi mee kɨn, rɔde nəl-de ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ə uri me kəy tɨ nɨngə, ooi ngon əi kɨ ko̰e Mari, ɓa ɔsi məkəsɨde nangɨ, pɨti-e. Go tɨ, tḛḛi ta ɓɔl je ləde, adi-e ɔr, kɨ ndujɨ kagɨ kɨ ətɨ majɨ, kɨ nom kagɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Go nḛ je tɨ kɨn, Luwə əl-de me ni tɨ kadɨ təli gogɨ kɨ rəbɨ kɨ dɔ Erodɨ tɨ al. Be ə, təli awi ɓe ləde kɨ rəbɨ kɨ rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lokɨ njé nḛ gər je awi nɨngə, malayka lə Ɓaɓe tḛḛ me ni tɨ əl Jɨsəpɨ ə nə: «Ḭ taa un ngon əi kɨ ko̰e, ə a̰y aw səde Ejɨpɨ tɨ. Aw ɨsɨ tɨ no̰o̰ bɨtɨ kadɨ mi wa m-adi ndum ɓəy taa ɨtəl ɨre səde, tadɔ *Erodɨ a sangɨ kadɨ n-tɔl ngon kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jɨsəpɨ ḭ taa kondɔ no̰o̰, un ngon əi kɨ ko̰e, ɓa a̰y aw səde Ejɨpɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ɨsi tɨ no̰o̰ bɨtɨ koy Erodɨ, adɨ ta kɨ Ɓaɓe əl kɨ ndu nje kəl ta kɨ tae tɨ ə nə: «M-ɓar ngonm kadɨ tḛḛ me ɓe tɨ kɨ Ejɨpɨ kɔ» kɨn tɔl tane. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lokɨ *Erodɨ oo kadɨ njé nḛ gər je ədi-e, wongɨ ra-e ngay. Wongɨ ra-e adɨ un ndune kadɨ tɔli ngan je kɨ kasɨ kɨ ḭ dɔ ɓal kɨ joo tɨ təl kɨ nangɨ ne pətɨ me ɓe tɨ kɨ Bətɨləhəm, kɨ ngan ɓe je kɨ gɨdɨ tɨ. Ɓal kɨn e kɨ go dɔkagɨlo tɨ kɨ njé nḛ gər je ɔji-e-n. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Be ə, ta lə nje kəl ta kɨ ta Luwə tɨ Jərəmi, kɨ əl tɔl-n tane. Jərəmi ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«NDu dəw ɓa me ɓe tɨ kɨ Rama, No̰ je, kɨ ndɨngə rɔ kɨ ətɨ ɓəl ngay je. Adɨ e Rasəl ə no̰ ngane je, NDɨgɨ kadɨ dəw sɔl mene al, Tadɔ gotoi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lokɨ *Erodɨ oy ngata ɓa, go koye tɨ, malayka lə Ɓaɓe tḛḛ kɨ rɔ Jɨsəpɨ tɨ, Ejɨpɨ tɨ me ni tɨ, əl-e ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Ḭ taa, un ngon kɨ ko̰e, ə ɨtəli awi dɔnangɨ Isɨrayəl tɨ gogɨ, tadɔ dɨje kɨ ɨsɨ sangi kadɨ n-tɔli ngon ka oyi ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jɨsəpɨ ḭ taa, un ngon kɨ ko̰e, ə təli awi dɔnangɨ *Isɨrayəl tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nə lokɨ oo kadɨ Arkəlosɨ o̰ ɓe dɔ Jude tɨ to bawne Erodɨ tɨ, ɓəl ra-e kadɨ aw Jude tɨ. Be ə, Luwə əl-e me ni tɨ ade aw Galile tɨ yo. ");
INSERT INTO bjvNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aw ɨsɨ me ɓe bo tɨ kɨ ɓari-e nə Najarətɨ. Be kadɨ ta kɨ njé kəl ta je kɨ ta Luwə tɨ əli əi nə: «A ɓari-e dəw kɨ Najarətɨ tɨ kɨn tɔl-n tane.» ");
INSERT INTO bjvNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɓal je də go tɨ, Ja̰ Batɨsɨ tḛḛ, ɨlə mbḛ dɨlə lo tɨ kɨ Jude ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, tadɔ ko̰ɓe lə Luwə e ɓasi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja̰ Batɨsɨ ə, e dəw kɨ nje kəl ta kɨ ta Luwə tɨ Ejay əl ta dɔe tɨ ə nə: «NDu dəw madɨ ɓa dɨlə lo tɨ ə nə: “Ɨrai go rəbɨ lə Ɓaɓe! Ɨrai go rəbɨ lie adɨ a njururu!”» ");
INSERT INTO bjvNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja̰ ɨlə kɨbɨ kɨ ra kɨ bḭ jambal rɔne tɨ, nɨngə dɔ mene kɨ nda tɔ. Nḛ kusoe e gɨbɨri je kɨ təjɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Dɨje kɨ ɓe bo Jorijaləm tɨ, kɨ dɔnangɨ Jude tɨ pətɨ, kɨ dɔnangɨ kɨ kadɨ ba Jurdḛ tɨ pətɨ, rəi rɔ Ja̰ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","rəi tɔri ndude dɔ majal je tɨ ləde, adɨ Ja̰ ra-de batəm me ba Jurdḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lokɨ Ja̰ oo adɨ *Parɨsɨ je, kɨ *Sadusɨ je ngay rəi kadɨ ra-de batəm ɓa, əl-de ə nə: «Səi njé man majal tə li je be kam, na̰ ə əl səsi kadɨ a̰yḭ-naa wongɨ lə Luwə kɨ a re ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Majɨ kadɨ kɨlə rasi tɔjɨ kadɨ səi dɨje kɨ ɨyə̰i pa njɨyəsi je kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nɨngə, kadɨ ɨyə̰i ta kɔjɨ mesi tɨ kə nə: “Je ngan ka *Abɨrakam.” MBata, Luwə asɨ kadɨ a təl gajɨ mbal je kam ngan ka Abɨrakam tɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kɨ ne kɨn, kɨngə e ɓasi kadɨ tɨgə ngɨrə kagɨ je gangɨ ngata. Kagɨ kɨ ra kɨ andɨ majɨ al ə, a tɨgəi-e kadɨ ɨləi-e me por tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mi, m-ra səsi batəm me man tɨ, mba kadɨ tɔjɨ təkɨ ɨyə̰i pa njɨyəsi je kɨ majal kɔ, nə dəw kɨ a re gom tɨ, e nje tɔgɨ kɨ ətɨ ɓəl, kɨ ɨtə-m sa̰y. M-asɨ kadɨ sa kɨ njae tɨ ka m-ɔr al. E a ra səi batəm, me NDɨl Luwə tɨ, kɨ me por tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Uwə kee to nḛ jine tɨ kadɨ to-n ka̰ ko kɨ majɨ, ɔy me dam tɨ, ɓa ɨlə tɨse por. E por kɨ a oy al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lo kɨn tɨ no̰o̰, Jəju ḭ Galile tɨ, re ta ba Jurdḛ tɨ rɔ Ja̰ tɨ, kadɨ Ja̰ ra-e batəm. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nə Ja̰ ge kɔdɨ al, adɨ əl Jəju ə nə: «E mi ə kadɨ ḭ, ɨra-m batəm, nɨngə ḭ taa ɨtəl ɨre rɔm tɨ kadɨ m-ra-i batəm ɓəy tɔ a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nə Jəju əl-e ə nə: «Kɨ ɓasɨne kɨn, ɨra be, tadɔ e kɨ goe kɨn ə j-a jɨ tɔl-n ta ndɨgɨ lə Luwə.» Be ə, Ja̰ ndɨgɨ dɔ tɨ, ra-e-n batəm. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lokɨ Jəju ra batəm taa par, ə tḛḛ me man tɨ nɨngə, loe tɨ no̰o̰, ta dɔra̰ tḛḛ, adɨ oo NDɨl Luwə rɨsɨ tə də dum be re ɨsɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nɨngə, ndu ta madɨ tḛḛ dɔra̰ tɨ, ə nə: «E kam e NGonm, nje ndɨgɨ ləm, kɨ rɔm nəl-m dɔe tɨ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Go tɨ, NDɨl Luwə ɔr no̰ Jəju aw sie dɨlə lo tɨ, mba kadɨ su na-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jəju ɔgɨ rɔne kuso nḛ, kondɔ kɨ kada, ndɔ kutɨ sɔ, ə go tɨ ɓo ra-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lo kɨn tɨ, su, nje na dɨje ɔtɨ re rɔe tɨ, əl-e ə nə: «Re ḭ NGon lə Luwə ə, adɨ mbal je kɨn təli mapa adɨ m-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ə Jəju ɨle tɨ ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Dəw a ɨsɨ kɨ dɔne taa kɨ takul nḛ kuso par al, nə kɨ takul ta je pətɨ kɨ tḛḛ ta Luwə tɨ tɔ”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go tɨ, su aw kɨ Jəju me ɓe tɨ kɨ Jorijaləm, kɨ e ɓe bo lə Luwə, aw sie jam dɔ kəy tɨ lə Luwə taa, ");
INSERT INTO bjvNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ɓa əl-e ə nə: «Re ḭ NGon lə Luwə ə, ɨyə̰ jii taa osɨ adɨ m-o, tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Luwə a adɨ ndune malayka je ləne kadɨ a lai-ni dajide tɨ, mba kadɨ njai tɨgə mbal al”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jəju təl əl-e ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə tɔ əi nə: A na Ɓaɓe Luwə ləi al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Su təl aw kɨ Jəju dɔ mbal tɨ kɨ ngal taa ngay ɓəy, ɔje ko̰ɓe je kɨ dɔnangɨ tɨ ne pətɨ, kɨ nḛ kɨngə je kɨ me tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nɨngə əl-e ə nə: «M-a m-adi nḛ je kɨn pətɨ, lokɨ re ɔsɨ məkəsi nangɨ no̰m tɨ, ə ɨlə tɔjɨ dɔm.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jəju təl əl-e ə nə: «Ḭ *Sata̰, ɔtɨ kɔ sa̰y. Tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “A ɔsɨ məkəsi nangɨ no̰ Ɓaɓe Luwə tɨ ləi, nɨngə e kɨ karne ba par ə a re no̰e tɨ kadɨ ɨgose.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Be ə, su ɨyə̰ Jəju ə ɔtɨ aw. Ɓa malayka je rəi rɔ Jəju tɨ, rəi rai sie. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dɔkagɨlo madɨ uwəi Ja̰ dangay tɨ, ə Jəju oo tae ɓa, təl ɔr rɔne aw Galile tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nə ke ə, ɨyə̰ ɓe bo kɨ Najarətɨ, ə aw ɨsɨ Kapərnayɨm tɨ yo. Kapərnayɨm kɨ e ɓe bo kɨ a kadɨ ba tɨ kɨ Galile, dɔnangɨ tɨ lə Jabɨlo̰ je, kɨ Nəpɨtali je. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Be kadɨ tɔl ta ta kɨ nje kəl ta kɨ ta Luwə tɨ Ejay əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Səi dɨje kɨ Dɔnangɨ Jabɨlo̰ tɨ kɨ dɔnangɨ Nəpɨtali tɨ, Kɨ ɨsi ɓasi kadɨ ba tɨ, Gɨdɨ ba Jurdḛ tɨ, Səi dɨje kɨ dɔnangɨ Galile tɨ, Kɨ səi dɨje kɨ səi Jɨpɨ je al! Uri mbisi oi: ");
INSERT INTO bjvNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dɨje kɨ kəte ɨsi lo kɨ ndul tɨ, OOi kunjɨ kɨ bo, Nɨngə dɨje kɨ kəte ɨsi ɓe lə yo, Kɨ e lo kɨ ndul kururu, Lo kunjɨ tḛḛ dɔde tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dɔ gangɨ loe tɨ kɨn, Jəju ɨlə ngɨrə kɨlə mbḛ ə nə: «Ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, tadɔ ko̰ɓe lə Luwə e ɓasi rɔsi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","NDɔ kare, Jəju a njɨyə kadɨ ba bo tɨ kɨ Galile, nɨngə oo ngakonaa je joo, adɨ e Sɨmo̰ kɨ ɓari-e Pɨyər əi kɨ ngokone Andɨre kɨ əi njé ndo̰ kanjɨ je, a ɨləi bandɨ me man tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jəju əl-de ə nə: «Ɨrəi gom tɨ adɨ m-ndo səsi, kadɨ səi njé ndo̰ dɨje kadɨ ɨngəi kajɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kalangɨ ba, ɨyə̰i bandɨ je ləde, ə awi uni go Jəju tə njé ndo je lie. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jəju ɔtɨ kɨ kəte sa̰y ndə̰y nɨngə, oo ngakonaa je kɨ rangɨ joo: Jakɨ əi kɨ Ja̰ kɨ əi ngan lə Jəbəde, ɨsi me to tɨ kɨ bawde, ɨsɨ rai go bandɨ je ləde, ɓa ɓar-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lokɨ Jəju ɓar-de nɨngə, kalangɨ ba, ɨyə̰i bawde Jəbəde kɨ to, ə awi uni go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jəju njɨyə dɔnangɨ Galile tɨ ba pətɨ, ndo nḛ dɨje me kəy kaw-naa je tɨ lə *Jɨpɨ je, ɨlə mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə, taa ajɨ njé mo̰y je kɨ njé rɔ to je kɨ dan dɨje tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tɔɓa lie sane dɔnangɨ tɨ kɨ Sɨri ba pətɨ, adɨ rəi kɨ dɨje pətɨ kɨ rɔde ra-de, njé rɔ to je kɨ dangɨ dangɨ, njé kɨ ndɨl je kɨ majal rai-de je, njé damsɨl je, kɨ njé rɔ koy je, adɨ ajɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kosɨ dɨje ngay rəi go Jəju tɨ. NJé kḭ dɔnangɨ Galile tɨ je, dɔnangɨ Ɓe bo je tɨ kɨ Dɔgɨ je, ɓe bo Jorijaləm je, kɨ dɔnangɨ Jude tɨ je, kɨ dɔnangɨ kɨ gɨdɨ ba Jurdḛ tɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lokɨ Jəju oo kosɨ dɨje kɨn ɓa, ɔtɨ aw dɔ mbal tɨ, ɨsɨ nangɨ, nɨngə njé ndo je lie rəi rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lo kɨn tɨ, Jəju ɨlə rɔne ndo nḛ dɨje ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Majɨ-kur e lə njé kɨ ooi rɔde kadɨ n-asi al ta kəm Luwə tɨ, tadɔ ko̰ɓe lə Luwə e ya̰de. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Majɨ-kur e lə njé kɨ ɨsɨ no̰i ɓone, tadɔ lo ti ə Luwə a sɔl mede. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Majɨ-kur e lə njé kɨ sɔli lɔm lɔm, tadɔ Luwə a adɨ-de dɔnangɨ kadɨ-kare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Majɨ-kur e lə njé kɨ ɓo ra nḛ kɨ go ndu Luwə tɨ e mede tɨ, tadɔ lo ti ə a ɨngəi tɔgɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Majɨ-kur e lə njé kɨ ɨsɨ ooi kəm-to-ndoo lə dɨje, tadɔ Luwə a ra səde majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Majɨ-kur e lə njé kɨ mede e kare dɔ Luwə tɨ, tadɔ a ooi Luwə kɨ kəmde. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Majɨ-kur e lə njé kɨ ɨsɨ sangi rəbɨ lapɨya, tadɔ a ɓari-de ngan lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Majɨ-kur e lə njé kɨ dɨje ɨsɨ adi-de ko̰ mbata nḛ ra kɨ dana, tadɔ ko̰ɓe lə Luwə e ya̰de. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Majɨ-kur e ləsi lokɨ dɨje ɨsɨ taji səsi je, ɨsɨ adi səsi ko̰ je, ɨsɨ təti ta dɔsi tɨ je mbata ləm. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɨrai rɔnəl, ɨtɨləi kole, tadɔ nḛ kɨgə go jisi e ngay dɔra̰ tɨ. *NJé kəl ta je kɨ ta Luwə tɨ, kɨ rai kɨlə kəte no̰si tɨ, ɨngəi ko̰ kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Səi ə səi katɨ kɨ dɔnangɨ tɨ. Nɨngə kɨn ə mba̰ katɨ goto ə, dəw a ra ban ə kadɨ a təl ade mba̰ gogɨ ɓəy ə? Maje goto ngata; a ɓuki-e kɔ gɨdɨ lo tɨ kadɨ dɨje njɨyəi dɔ tɨ par ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Səi ə səi kunjɨ kɨ dɔnangɨ tɨ. Nɨngə ɓe bo kɨ ɨndəi-e dɔ mbal tɨ taa, asɨ kadɨ a ɓɔyɔ rɔne al. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dəw a re kɨ lambɨ kəy ə dəbɨ ngo dɔ tɨ al. A ɨndə dɔ nḛ tɨ taa mba kadɨ dɨje kɨ me kəy tɨ pətɨ ooi lo. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Be tɔ ə, sɔbɨ kadɨ adi dɨje pətɨ ooi kunjɨsi me nḛ ra kɨ majɨ tɨ. Lokɨ ooi nḛ rasi kɨ majɨ nɨngə, a ɨləi tɔjɨ dɔ Bawsi Luwə tɨ kɨ ɨsɨ dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Sɔbɨ kadɨ ɨgai təkɨ m-re kadɨ m-bujɨ ndu-kun je lə *Mojɨ ə se ta lə njé kəl ta je kɨ ta Luwə tɨ al. M-re mba bujɨ-de al, nə m-re mba tɔl tade yo. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Təkɨ rɔjetɨ, m-əl səsi, kəte no̰ kadɨ dɔra̰ əi kɨ dɔnangɨ kɨn a gotoi kɔ, ngon ku ta kɨ ndə̰y be, ə se ngon ndajɨ madɨ kɨ me ndu-kun tɨ lə Luwə kɨ ndangi kɨ dəw a ɔr kɔ goto. A to be bɨtɨ kadɨ nḛ je pətɨ kɨ ndangi me tɨ rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Dəw kɨ al dɔ ngon ndu-kun kɨ ndə̰y be dan made je tɨ, ə ndo dɨje kadɨ rai təkɨ e ra-n be tɔ ɓa, a e kɨ du ngay me ɓeko̰ tɨ kɨ dɔra̰ tɨ tɔ. Nə dəw kɨ təl rɔne go tɨ, ə ndo dɨje, a e kɨ bo me ɓeko̰ tɨ kɨ dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Adɨ m-əl səsi: kɨn ə nḛ ra kɨ dana ləsi ɨtə ya̰ njé ndo ndu-kun je kɨ *Parɨsɨ je al ə, a uri me ɓeko̰ tɨ kɨ dɔra̰ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Səi, ɨgəri majɨ təkɨ ndu ta əl kaje je ə nə: “A ɨtɔl dəw al, dəw kɨ tɔl madɨne ɓa, sɔbɨ kadɨ awi sie no̰ njé gangɨ ta je tɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nə mi m-əl səsi: «Dəw kɨ ra wongɨ kɨ ngokone, sɔbɨ kadɨ awi sie lo gangɨ ta tɨ; dəw kɨ tajɨ ngokone “mbə”, sɔbɨ kadɨ awi sie lo gangɨ ta tɨ kɨ bo lə Jɨpɨ je, ə dəw kɨ ɓa ngokone “ma”, sɔbɨ kadɨ ɨləi-e me por tɨ lə su. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kɨn ə aw kɨ kadɨ-kare ləi dɨngɨri lo kɨlə kadɨ-kare tɨ kadɨ Luwə, ə mei ole dɔ tɨ kadɨ ngoko̰i aw səi kɨ ta madɨ ɓa, ");
INSERT INTO bjvNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","majɨ kadɨ ɨyə̰ kadɨ-kare kɨn no̰o̰, ə ɨre aw ɨlə nojɨ naa tɨ sie ɓəy taa ɨtəl ɨre un kadɨ-kare ləi adɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Kɨn ə ɨsɨ awi lo gangɨ ta tɨ kɨ nje ta ləi ɓa, lokɨ səi dɔ rəbɨ tɨ ɓəy kɨn ə, ɨsangɨ rəbɨ kadɨ ndusi osɨ go-naa tɨ sie kalangɨ, nə tə aw səi ɨləi ji nje gangɨ ta tɨ, adɨ nje gangɨ ta uni ɨləi ji asɨgar je tɨ, adɨ asɨgar je awi səi ɨləi-ni dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Təkɨ rɔjetɨ, adɨ m-əli, a ɨtḛḛ lo kɨn tɨ al bɨtɨ kadɨ ugə dɔbəy sɨsi ɓəy taa a ɨyə̰i-ni taa. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ɨgəri ndu kɨ əl ə nə: “A uwə marɨm al,” kɨn majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nə mi m-əl səsi: “Dəw kɨ go̰ dəne kɨ kəm-nda ɓa, uwə sie marɨm mene tɨ ngata.” ");
INSERT INTO bjvNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kɨn ə kəmi kɨ dɔ ji ko̰ tɨ rai adɨ osɨ me majal tɨ ə, ɔr-e ɨle kɔ. Tadɔ e sotɨ kadɨ ngon rɔi kare goto, ɨtə kadɨ ɨləi darɔi ba pu me por tɨ lə su. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kɨn ə ji ko̰i rai adɨ osɨ me majal tɨ ə, ɨgange ɨle kɔ. Tadɔ, e sotɨ kadɨ ngon rɔi kare goto, ɨtə kadɨ ɨləi rɔi ba pu me por tɨ lə su. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Ɨgəri kadɨ ndu-kun əl ɓəy tɔ nə: “Re dəw tuwə nene ɓa, kadɨ ade makɨtɨbɨ gangɨ-naa.” ");
INSERT INTO bjvNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nə mi m-əl səsi: “Dəw kɨ ra kɨ tuwə nene mbata nḛ kɨ rangɨ, ɓɨ e ta lə kaya kɨ ra, al ə, dəwe kɨn sur-e ta kuwə marɨm tɨ. A re dəw taa dəne kɨ ngawe tuwe ɓa, dəwe kɨn təl nje kuwə marɨm tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«NDu ta əl kaje je kəte ɓəy tɔ ə nə: “Re ɨbɨ rɔi dɔ nḛ madɨ tɨ ə, a dɔ tɨ, kadɨ ɨra nḛ kɨ ɨbɨ rɔi dɔ tɨ no̰ Ɓaɓe tɨ”. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nə mi m-əl səsi təkɨ a ɨbɨ rɔi al tə kɨbɨ al. A ɨbɨ rɔi kɨ dɔra̰ al, tadɔ dɔra̰ e kɨmbər kɨsɨ Luwə; ");
INSERT INTO bjvNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","a ɨbɨ rɔi kɨ dɔnangɨ al, tadɔ dɔnangɨ e kɨmbər kɨndə njae; a ɨbɨ rɔi kɨ Jorijaləm al, tadɔ Jorijaləm e ɓe bo lə NGar kɨ bo; ");
INSERT INTO bjvNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","a ɨbɨ rɔi kɨ jam dɔi al, tadɔ ḭ asɨ kadɨ ɨtəl bḭ dɔi kare be kɨ nda tɨ ə se kɨ ndul tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Re ta ləsi e oyo ɓa, ai dɔ oyo tɨ, re ta ləsi e jagɨ ɓa, ai dɔ jagɨ tɨ par tɔ. NDəgɨ ta je kɨ a re go tɨ kɨn ḭ rɔ su tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ɨgəri kadɨ ndu ta əl ə nə: “Re dəw tɔ kəm madɨne ɓa, to kadɨ e kɨ tɔ kəme tɔ, a re dəw tətɨ ngangɨ madɨne ɓa, to kadɨ e tətɨ ngange tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nə mi m-əl səsi kadɨ ɨta̰i rɔ nje me ndul al. Re dəw ɨndə dam mbɔi kɨ ko̰ ə, ɨyətɨ dame kɨ gəl ade ɨndə ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Re dəw aw səi no̰ nje gangɨ ta tɨ kadɨ taa kɨbɨ kɨ gɔjɨ ləi ə, ade e kɨ ngal dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Re dəw ɨndə gu dɔi tɨ kadɨ ɨnjɨyə njai dɨbɨ ə, ɨnjɨyə sie njay dɨbɨ joo. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dəw kɨ ra kɨ dəji nḛ ə ade, nɨngə re dəw ndɨməi nḛ ə ɔge al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ɨgəri təkɨ ndu ta əl ə nə: “A ɨndɨgɨ dəw madi, nə a ɔsɨ ta nje ba̰ ləi”. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nə mi, m-əl səsi kadɨ ɨndɨgi njé ba̰ je ləsi, ə əli ta kɨ Luwə mbata lə njé kɨ ɨsɨ adi səsi ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ɨrai be nɨngə, a səi ngan lə Luwə kɨ e Bawsi kɨ ɨsɨ dɔra̰ tɨ. Tadɔ adɨ kadɨ ɔsɨ dɔ njé me majɨ tɨ kɨ njé me majal. Adɨ ndi ədɨ dɔ njé ra nḛ tɨ kɨ dana, kɨ njé ra nḛ tɨ kɨ dana al. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kɨn ə ɨndɨgi njé kɨ ndɨgi səsi tɔ par ə, nḛ kɨgə go ji ri ə Luwə a adɨ səsi ə? *NJé taa la-mbə je ka rai be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kɨn ə ɨrai lapɨya ngako̰si je par ə, ri kɨ to ta dangɨ ə ɨrai ə? Tadɔ njé gər Luwə al ka rai be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nɨngə səi, sɔbɨ kadɨ ɨndɨgi dɨje adɨ osɨ taga pa̰y təkɨ Bawsi Luwə kɨ ɨsɨ dɔra̰ tɨ ndɨgɨ-n dɨje adɨ osɨ taga pa̰y kɨn be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kadɨ oi majɨ, kɨn ə re ɨsɨ rai nḛ kɨ ndu Luwə ndɨgɨ kadɨ ɨrai ɓa, kadɨ ɨrai ta kəm dɨje tɨ kɨ kadɨ dɨje ooi səsi al. Re ɨrai be ɓa, Bawsi kɨ ɨsɨ dɔra̰ tɨ, a adɨ səsi nḛ kɨgə go ji ləsi al. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kɨn ə ɨra kɨ nje ndoo ə, kadɨ ɨndə gəngɨ dɔ tɨ kadɨ dɨje ooi, al. Ɨrai təkɨ nje kədɨ kəm dɨje ɨsɨ rai gɨn kəy kaw-naa tɨ lə *Jɨpɨ je, kɨ go rəbɨ tɨ je kɨn al. Rai be mba kadɨ dɨje pɨti-de. Nə kɨ rɔjetɨ, adɨ m-əl səsi, ɨngəi nḛ kɨgə go ji ləde ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nə ḭ, lokɨ ɨra majɨ kɨ njé ndoo je, majɨ kadɨ ji gəli gər nḛ kɨ ji ko̰i adɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be nɨngə, nḛ ləi kɨ adɨ kɨn to lo ɓɔyɔ tɨ, ɓa Luwə kɨ oo nḛ je kɨ to lo ɓɔyɔ tɨ, a ɨgəi kɨre.» ");
INSERT INTO bjvNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Lokɨ ɨsɨ əli ta kɨ Luwə ɓa, kadɨ ɨrai təkɨ njé kədɨ kəm dɨje ɨsɨ rai kɨn be al. NJé kədɨ kəm dɨje kɨ nəl-de ngay kadɨ ai taa me kəy tɨ lə *Jɨpɨ je, kɨ sɨl rəbɨ je, taa əli ta kɨ Luwə kɨn. Əi je rai be mba kadɨ dɨje ooi-de. Nə kɨ rɔjetɨ, adɨ m-əl səsi, ɨngəi nḛ kɨgə go ji ləde ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nə ḭ, lokɨ ɨge kəl ta kɨ Luwə ɓa, majɨ kadɨ ur kəy toi tɨ, utɨ ta kəy dɔi tɨ, ɓa əl ta kɨ Luwə lo ɓɔyɔ rɔ tɨ kɨn, nɨngə Bawi Luwə kɨ ɨsɨ lo kɨ ɓɔyɔ tɨ, a oo, ə a adi nḛ kɨ ɨdə-je. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Lokɨ ɨsɨ əli ta kɨ Luwə ɓa, əli ta kɨ dɔ-naa tɨ, dɔ-naa tɨ tə dɨje kɨ njé gər Luwə al be, al. Əi je ooi ə nə me ta tɨ kɨ kəl ngay kɨn ə Luwə a oo-n dɔ ndude. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Majɨ kadɨ ɨrai təkɨ əi je ɨsɨ rai kɨn be al, tadɔ Bawsi Luwə gər nḛ je kɨ awi kɨ ndooe, kəte ɓəy taa kadɨ əli sie ta dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Səi ɓa, kadɨ əli ta kɨ Luwə əli əi nə: “Bawje kɨ ɨsɨ me dɔra̰ tɨ taa, Kadɨ dəw kɨ ra gər tɔi təkɨ ḭ Luwə, ");
INSERT INTO bjvNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kadɨ ko̰ɓe ləi re. Kadɨ dɨje rai ndɨgɨ ləi dɔnangɨ tɨ ne, Təkɨ njé kɨ dɔra̰ tɨ ɨsɨ rai kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Adɨ-je nḛ kusoje kɨ asɨ taje me ndɔ tɨ kɨ ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɨyə̰ go majal je ləje kɔ, Təkɨ je wa ka j-ɨyə̰-n go majal je lə dɨje kɨ rai səje majal kɔ kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɨyə̰-je adɨ j-osɨ me nḛ na tɨ al, Nə kadɨ ɔr-je ji nje majal tɨ kɔ. MBata ḭ ə, ko̰ɓe, kɨ tɔgɨ, kɨ tɔɓa e ləi bɨtɨ kɨ no̰ tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kɨn ə re ɨyə̰i go majal je lə dɨje kɔ ɓa, Bawsi kɨ ɨsɨ dɔra̰ tɨ a ɨyə̰ go majal je ləsi kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A kɨn ə re ɨyə̰i go majal je kɨ dɨje rai səsi kɔ al ɓa, Bawsi a ɨyə̰ go majal je ləsi kɔ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Lokɨ ɔgi rɔsi nḛ kuso ɓa, majɨ kadɨ ɨsɨkɨti kəmsi sɨkɨti sɨkɨti tə ya̰ njé kədɨ kəm dɨje be al. Əi, sɨkɨti kəmde mba kadɨ dɨje ooi-de təkɨ n-ɔgi rɔde nḛ kuso. Nə kɨ rɔjetɨ, adɨ m-əl səsi, ɨngəi nḛ kɨgə go ji ləde ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nɨngə ḭ, lokɨ ɔgɨ rɔi nḛ kuso ɓa, majɨ kadɨ ɨtogɨ ta kəmi sukɨ, ə ɨndu dɔi. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","MBa kadɨ dɨje gəri, təkɨ ɔgɨ rɔi nḛ kuso, al. Nɨngə, Bawi kɨ ɨsɨ lo kɨ ɓɔyɔ tɨ par ə oo, e kɨ gər nḛ kɨ to lo ɓɔyɔ tɨ a adɨ səsi nḛ kɨ ɨdəji-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Ɨmbo̰i nḛ kɨngə je mbata ləsi dɔnangɨ tɨ ne al. Dɔnangɨ kɨ e lo kɨ nḛ kɨ tɨtɨ a ndusɨ je, yo̰ je a o̰i je, taa njé ɓogɨ je a mbuti bole bɔr kadɨ ɓogii je. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nə kadɨ ɨmbo̰i nḛ kɨngə je ləsi dɔra̰ tɨ taa, kɨ e lo kɨ nḛ kɨ tɨtɨ a ndusɨ al nɨm, yo̰ je a o̰i al nɨm, taa njé ɓogɨ je a mbuti bole bɔr ɓa a ɓogii al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tadɔ lo kɨ nḛ kɨngə ləi e tɨtɨ ə mei a e tɨtɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Kəm dəw ə e lambɨ lə darɔe. Kɨn ə re kəmi oo lo majɨ ɓa, darɔi pətɨ e me kunjɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A kɨn ə re kəmi oo lo majɨ al tɔ ɓa, darɔi pətɨ e me tɨl tɨ tɔ. A kɨn ə re kunjɨ kɨ to rɔi tɨ kɨn təl tɨl nɨngə, a e tɨl kɨ dum kəl tae. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Dəw kɨ a ra kɨlə ɓəə lə ngar je joo goto: re ɔsɨ ta kɨ kare ə, a ndɨgɨ kɨ nungɨ, re kɨdɨ kɨ kare ə, a uwə kɨ kɨ nungɨ tɔ. A asi kadɨ ɨrai ɓəə lə Luwə nɨm, ɓəə lə la nɨm al. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«E mbata kɨn ə, m-əl səsi kadɨ adi mesi a sururu dɔ nḛ kusosi tɨ, kɨ man ka̰ysi tɨ, kɨ kadɨ ɨsi kɨ dɔsi taa al, taa dɔ kɨbɨ kɔsi tɨ al nɨm tɔ. Tadɔ kɨsɨ kɨ dɔ taa ɨtə nḛ kuso, taa darɔ dəw ɨtə kɨbɨ kɨ kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ɨgo̰i yəl je kɨ a nali dan nəl tɨ kɨn oi, dɨbi ko al nɨm, təti ko al nɨm, taa kawi nḛ me dam tɨ al nɨm tɔ, nə Bawsi kɨ ɨsɨ dɔra̰ tɨ taa, adɨ-de nḛ usoi majɨ. Ə se, səi je, ɨtəi yəl je kɨn gɨdɨ ba̰y ba̰y al wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na̰ dansi tɨ ə asɨ kadɨ a ɨlə ngon kadɨ kɨ ndə̰y be dɔ ndɔne tɨ kɨ takul me ka sururu ləne ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Asi al, nga ra ban be ə mesi a sururu dɔ kɨbɨ kɔsi tɨ ə? Ɨgo̰i putɨ kam je kɨ ai me wale tɨ kɨn oi. Rai kɨlə madɨ al nɨm, oji kɨbɨ al nɨm tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","nə ngar *Salomo̰ kɨ tɔe ɓa ngay me nḛ kɨngə tɨ kɨn ka ɔ kɨbɨ kɨ ndole asɨ naa səde al. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ə kɨn ə Luwə ɨlə kɨbɨ rɔ ngan kagɨ je tɨ kɨ wale, kɨ j-o-de ɓone, ə lo ti par ə a o̰i por kɨn be nɨngə, səi dɨje taa a ɨlə kɨbɨ rɔsi tɨ al a? Səi to̰ je me kadɨ-me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Adi mesi a sururu kadɨ əli ə nə: “Ri ə j-a j-uso wa? Ri ə j-a j-a̰y wa? J-a j-ɨngə kɨbɨ ra ə j-a j-ɔ wa?” al. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nḛ je kɨn pətɨ, e dɨje kɨ gəri Luwə al, ə ɨsɨ sangi kɨ no̰ kəmde tɨ. Nɨngə Bawsi kɨ ɨsɨ me dɔra̰ tɨ gər majɨ kadɨ awi kɨ ndooe tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ɨsangi ko̰ɓe lə Luwə kɨ ndɨgɨ lie kəte, nɨngə a adɨ səsi ndəgɨ nḛ je kɨn pətɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adɨ mesi a sururu dɔ ndɔ kɨ lo ti tɨ al. Tadɔ ndɔ kɨ lo ti tɨ aw kɨ me ka sururu ləne. NDɔ je pətɨ awi kɨ nḛ to rɔ kɨ sɔbɨ dɔde, ɓɨ awi kɨ made dɔ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ɨgangi ta dɔ dəw tɨ al, kadɨ Luwə gangɨ ta dɔsi tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tadɔ Luwə a gangɨ ta dɔsi tɨ təkɨ ɨgangii dɔ madɨsi je tɨ be tɔ. Nɨngə kadɨ ɨgəri təkɨ go rəbɨ kɨ ɨgangii ta dɔ dɨje kɨn ə Luwə a gangɨ-n ta dɔsi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ra ban be ə, oo burɨm wale kɨ to kəm ngoko̰i tɨ yo, ə oo kagɨ kɨ boy kɨ to ya̰i tɨ kɨn al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kagɨ kɨ boy ə to kəmi tɨ ne tɔ kɨn, nga kɨ go rəbɨ kɨ ban ə a əl ngoko̰i ə nə: «Adɨ m-un burɨm wale kɨ to kəmi tɨ kɨn,» ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ḭ nje kədɨ kəm dɨje, un kagɨ kɨ boy kɨ kəmi tɨ kɨn nɨngə tə, a o lo ay njay kadɨ un-n burɨm wale kɨ kəm ngoko̰i tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Oti kadɨ ɨləi nḛ kɨ ay njay adi bɨsɨ je, nə tə a ḭḭ təli kɨ dɔsi tɨ tə to̰i səsi. Taa ɨɓuki mədɨ-kɔsɨ je ləsi no̰ kɔsongɨ je tɨ al, nə tə a ḭḭ njɨyəi dɔ tɨ, tɨbəi kɨ njade.» ");
INSERT INTO bjvNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ɨdəji, ə a adi səsi, ɨsangi ə a ɨngəi, ɨndəi ta kəy ə a tḛḛi adi səsi. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tadɔ dəw kɨ dəjɨ ə a adi-e, dəw kɨ sangɨ ə a ɨngə, dəw kɨ ɨndə ta kəy ə a tḛḛi adi-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na̰ dansi tɨ ə ngone dəje mapa nɨngə a un mbal taa ade ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ə se dəje kanjɨ nɨngə a un li taa ade ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A kɨn ə səi kɨ səi dɨje kɨ kɨlə rasi majal kɨn mɨndɨ ə ɨgəri rəbɨ kadɨ nḛ kɨ majɨ ngansi je nɨngə, ra ban be ə, Bawsi kɨ ɨsɨ me dɔra̰ tɨ taa kɨn taa a adɨ nḛ kɨ majɨ dɨje kɨ dəji-e al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Nḛ je pətɨ kɨ ɨndɨgi kadɨ dɨje rai adi səsi kɨn ə ɨrai adi-de tɔ. Tadɔ e wa kɨn ə e nḛ ndo kɨ to me ndu-kun je tɨ lə *Mojɨ nɨm, me ta je tɨ kɨ njé kəl ta je kɨ ta Luwə tɨ ndangi nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Uri kəy kɨ ta rəbɨ kɨ mbəngɨrə, tadɔ ta rəbɨ kɨ boy, tatɨ pandangɨ, rəbɨ kɨ kun-e o̰ al, e rəbɨ kɨ nje kaw kɨ dɨje tujɨ tɨ. NGata nɨngə, e rəbe kɨn ə dɨje ngay uni. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nɨngə ta rəbɨ kɨ nje kaw kɨ dɨje kajɨ tɨ taa e mbəngɨrə ba, ɨbə dɨje. Ɓa rəbe kɨn, njé kun-e je əi ngay al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ɨndəi kəm-kədɨ dɔ rɔsi tɨ kɨ rɔ njé ɓar rɔde njé kəl ta kɨ ta Luwə tɨ kɨ əi njé ngom je. A rəi rɔsi tɨ, a oi gɨdɨde taga ne əi batɨ je, nə mede tɨ kəy, əi jagɨm je kɨ njé kuwə nḛ kul je. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A e kɨ go kɨlə ra njé ngom je kɨ njé kəl kə nə n-əi njé kəl ta kɨ ta Luwə tɨ ə a ɨgəri-de. Dəw a ɨjə kandɨ nju dɔ kon pa tɨ al, taa dəw a ɨjə kandɨ mbay-kote dɔ kon nga̰ tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kagɨ kɨ majɨ, ɓa a andɨ kandɨ kɨ majɨ, ə kagɨ kɨ majal, a andɨ kandɨ kɨ majal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kagɨ kɨ majɨ a asɨ kadɨ a andɨ kandɨ kɨ majal al, taa kagɨ kɨ majal a asɨ kadɨ a andɨ kandɨ kɨ majɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kagɨ kɨ ra kɨ andɨ kandɨ kɨ majal, a tɨgəi-e kadɨ ɨləi-e me por tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Adɨ, a e kɨ go kɨlə ra njé ngom je kɨ njé kəl kə nə n-əi njé kəl ta kɨ ta Luwə tɨ, ə a ɨgəri-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«E njé kɨ ɨsɨ ɓari-mi “Ɓaɓe, Ɓaɓe!” tade tɨ ne par kɨn ə a uri ko̰ɓe tɨ lə Luwə al, nə e njé kɨ ɨsɨ rai go ndɨgɨ tɨ lə Bai kɨ ɨsɨ me dɔra̰ tɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","NDɔ gangɨ ta tɨ ə, dɨje ngay a əi nə: “Ɓaɓe, Ɓaɓe! e me tɔi tɨ al ə j-əl-n ta kɨ ta Luwə tɨ a? E me tɔi tɨ al ə jɨ tuwə-n ndɨl je kɨ majal a? E me tɔi tɨ al ə jɨ ra-n nḛ kɔjɨ je ngay kɨ ətɨ ɓəl ɓəl a?” ");
INSERT INTO bjvNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɓa lo kɨn tɨ, m-a m-əl-de kɨ taga wangɨ m-ə nə: “Awi sa̰y nu, m-gər səsi ndɔ kare al, səi kɨ səi njé ra majal je!” ");
INSERT INTO bjvNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Be ə, dəw kɨ ra kɨ oo ta je kɨ m-əl kɨn, ə təl rɔne go tɨ nɨngə, to tə dəw kɨ nje kəm-kədɨ, kɨ ra kəy ləne dɔ dii tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Adɨ lokɨ ndi ədɨ nɨngə, man ko̰ lo re un kəy ka kɨn, nɨm taa nəl ka osɨ kɨ dɔ tɨ tɔ, nə kəy budɨ nangɨ al, tadɔ ngɨre e dɔ dii tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nə dəw kɨ ra kɨ oo ta je kɨ m-əl kɨn, ə təl rɔne go tɨ al nɨngə, to tə dəw kɨ mbə, kɨ ra kəy ləne dɔ yangɨra tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Adɨ lokɨ ndi ədɨ nɨngə, man ko̰ lo re un kəy ka kɨn, nɨm taa nəl ka osɨ kɨ dɔ tɨ tɔ, ɓa kəy budɨ nangɨ mur mur, adɨ toe to dɨlə yɨw.» ");
INSERT INTO bjvNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lokɨ Jəju tɔl ta ta ləne, nḛ ndo lie ətɨ kosɨ je ɓəl to tɨ kɨ dum. ");
INSERT INTO bjvNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","MBata ndo nḛ tə dəw kɨ aw kɨ tɔgɨ kɨ ḭ rɔ Luwə tɨ, ɓɨ ndo nḛ tə njé ndo-de ndu-kun je lə Luwə al. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lokɨ Jəju ḭ kɨ dɔ mbal tɨ ɨsɨ rɨsɨ kɨ nangɨ, kosɨ dɨje ngay əi goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","NJe banjɨ kare tḛḛ re rɔ Jəju tɨ, ɔsɨ məkəsɨne nangɨ no̰e tɨ, nɨngə əl-e ə nə: «Ɓaɓe, re ɨndɨgɨ ə, a adɨ banjɨ ləm ur, kadɨ rɔm ay njay.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jəju ɨlə jine, ɔde-n, nɨngə əl-e ə nə: «M-ndɨgɨ, ə kadɨ banjɨ ləi ur, adɨ rɔi ay njay.» Ɓa ta naa tɨ no̰o̰ banjɨ lie ur, adɨ rɔe ay njay. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Go tɨ Jəju əl-e ə nə: «Onoi kadɨ əl tae dəw madɨ, ə aw ɔjɨ rɔi nje kɨjə nḛ məsɨ kadɨ-kare, nɨngə adɨ kadɨ-kare kɨ go ndu-kun tɨ lə *Mojɨ. Ɨra be mba kadɨ gəri təkɨ banjɨ ləi ur adɨ ɨngə rɔ nga.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lokɨ Jəju ɨsɨ ur kɨ me ɓe kɨ Kapərnayɨm tɨ nɨngə, dəw kɨ Rom tɨ kare kɨ nje kun dɔ ɓutɨ asɨgar je kɨ ɓu, re rɔe tɨ, no̰ kɨ dɔe tɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Ɓaɓe, ngon nje kɨlə ləm kare to mo̰y ɓe no̰o̰, njae oy ta gɨne tɨ, adɨ ɨngə ko̰ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ə Jəju əl-e ə nə: «M-a m-aw kadɨ m-aje.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nə nje kun dɔ ɓutɨ asɨgar je kɨ ɓu əl-e ə nə: «Ɓaɓe, mi m-asɨ kadɨ ɨndə njai ta kəy tɨ ləm al, ə əl ta kare par ə ngon nje kɨlə ləm a ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","M-əl be tadɔ, mi kɨ dɔm mi gɨn tɔgɨ tɨ lə njé kɨ dɔm tɨ, nɨngə m-aw kɨ asɨgar je kɨ əi gɨn tɔgɨ tɨ ləm tɔ. Adɨ re m-əl asɨgar kare m-ə nə: “Aw!” ɓa aw; kɨn ə m-əl kɨ nungɨ m-ə nə: “Ɨre!” ɓa re; kɨn ə m-əl ngon nje kɨlə ləm m-ə nə: “Ɨra nḛ kɨ be!” ɓa ra nḛe kɨn tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lokɨ Jəju oo ta kɨn tae tɨ, pɨte, ə əl njé kɨ ai sie ə nə: «Təkɨ rɔjetɨ adɨ m-əl səsi, ko kadɨ-me kɨ be kɨn, m-ɨngə rɔ dəw madɨ tɨ dɔnangɨ kɨ *Isɨrayəl tɨ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","NGa nɨngə, m-əl səsi ɓəy tɔ, dɨje ngay kɨ əi *Jɨpɨ je al, a ḭḭ kɨ lo kɨbə kadɨ tɨ je, lo kur kadɨ tɨ je, kadɨ rəi ɨsi ta nḛ kuso tɨ kɨ *Abɨrakam je, kɨ *Isakɨ je, kɨ *Jakobɨ je me ɓeko̰ tɨ kɨ dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nə njé kɨ kəte ɓeko̰ kɨ dɔra̰ tɨ sɔbɨ dɔde, a tuwəi-de, ɓuki-de kɔ taga, me tɨl tɨ. Lokɨ a no̰i je, a ngəi ngangɨde je tɨtɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɓa, Jəju təl əl nje kun dɔ ɓutɨ asɨgar je kɨ ɓu ka kɨn ə nə: «Majɨ, aw! Nɨngə kadɨ ngon nje kɨlə ləi ajɨ kɨ go kadɨ-me tɨ ləi kɨn.» Nɨngə dɔ kade tɨ no̰o̰, ngon nje kɨlə lie ɨngə rɔ kɨ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Go tɨ, Jəju aw me kəy tɨ lə Pɨyər ɓa, oo məme kɨ dəne to nangɨ, rɔe o̰ por rɨgɨ rɨgɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ə Jəju ɔdɨ jie, nɨngə, rɔe kɨ kəte tɨngə ngay ka kɨn, təl sɔl, adɨ ɨngə rɔ nga. Go tɨ, ḭ taa ra nḛ kuso adɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lokɨ lo sɔl, dɨje rəi kɨ njé mo̰y je ngay kɨ ndɨl je kɨ majal rai-de, rɔ Jəju tɨ. Adɨ Jəju tuwə ndɨl je kɨ majal ka kɨn dɔde tɨ kɔ kɨ ta kɨ tane tɨ, taa ajɨ njé mo̰y je pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Be mba kadɨ ta kɨ nje kəl ta kɨ ta Luwə tɨ Ejay əl ka kɨn tɔl tane. Ejay ə nə: «Ɔy tujɨ je, Kɨ mo̰y je ləje kɨ dɔne tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","NDɔ kare, Jəju oo kosɨ dɨje ngay ɨləi-naa gəi gɨde, nɨngə əl njé ndo je ləne kadɨ n-gangi ba n-awi dame tɨ kɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lo kɨn tɨ, nje ndo ndu-kun lə Luwə kare re rɔ Jəju tɨ əl-e ə nə: «NJe ndo dɨje, m-a m-un goi lo je pətɨ kɨ a aw tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ə Jəju əl-e ə nə: «NJa̰ je ai kɨ ɓe tode, ə yəl je ai kɨ kəyde tɔ, nə *mi NGon dəw m-aw kɨ lo kɨ kadɨ m-ɨlə dɔm tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dəw kare dan njé ndo je tɨ lə Jəju əl-e ə nə: «Ɓaɓe, adɨ-m ta rəbɨ adɨ m-aw m-dɨbɨ bawm ɓəy taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ə Jəju əl-e ə nə: «Un gom, ə ɨyə̰ njé koy je adɨ dɨbi njé koy je ləde.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jəju al me to tɨ, ɓa njé ndo je lie ali goe. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nɨngə yə, nəl kɨ bo ngay ɨbə səde busɨ dɔ ba tɨ, adɨ to aw tə nduy man. Lo tɨ kɨn, Jəju ɨsɨ to ɓi. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","NGa ə, njé ndo je lie rəi kɨ rɔe tɨ, ndəli-e kɨ no̰ tade tɨ əi nə: «Ɓaɓe, ajɨ-je, nə j-ɨsɨ j-oy.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ə Jəju əl-de ə nə: «Ra ban ə ɨɓəli be ə? Səi dɨje kɨ kadɨ-me ləsi e ndɨkɨri ba.» Nɨngə, ḭ taa, ndangɨ nəl əi kɨ man ba, adɨ lo təl to jɨjɨji. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nḛ kɨn ətɨ dɨje ɓəl ngay, adɨ əli əi nə: «Dəw ə wa kam e dəw kɨ ban ə, nəl je kɨ ba je ka oi ta lie be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lokɨ Jəju re tḛḛ gɨdɨ ba tɨ, dɔnangɨ tɨ lə dɨje kɨ Gadara, dɨngəm je joo, kɨ ndɨl je kɨ majal rai-de tḛḛi kɨ dɔ ɓadɨ je tɨ rəi ɨngəi-e. Dɨje kɨn rai nḛ majal ngay, adɨ dəw kɨ kadɨ un rəbɨ kɨn goto. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lo kɨn tɨ, ɨləi rɔde uri kɔl əi nə: «NGon lə Luwə, e ri ə ɨge rɔje tɨ ə? Ɨre nḛ mba kadɨ adɨ-je ko̰ kəte no̰ dɔkagɨloe tɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","NGa nɨngə, kosɨ kɔsongɨ je ngay a usoi nḛ kadɨ lo tɨ no̰o̰ sa̰y ndə̰y. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ə NDɨl je kɨ majal no̰i dɔ Jəju tɨ əli-e əi nə: «Re ɨtuwə-je ə, adɨ j-aw me kɔsongɨ je tɨ kam.» ");
INSERT INTO bjvNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","NGa ə, Jəju əl-de ə nə: «Awi!» Ɓa tḛḛi, awi uri me kɔsongɨ je tɨ, adɨ kosɨ kɔsongɨ je ɓɨngəi-naa kadɨ mbal tɨ taa, tosi me ba tɨ, a̰yḭ-naa man oyi. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","NJé ngəm kɔsongɨ je a̰yḭ-naa awi me ɓe bo tɨ, ɔri poy nḛ kɨ ra nḛ, kɨ nḛ kɨ tḛḛ dɔ dɨngəm je tɨ kɨ joo kɨ ndɨl je kɨ majal rai-de ka kɨn, pətɨ adi dɨje ooi. ");
INSERT INTO bjvNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dɨje pətɨ kɨ me ɓe bo tɨ tḛḛi awi kadɨ ɨngəi Jəju, ə lokɨ ooi-e ɓa, dəji-e kadɨ ɨyə̰ dɔnangɨ ləde ə aw. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jəju al me to tɨ, ɨndə ba gangɨ, aw me ɓe bo tɨ ləne. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dɨje madɨ oti dəw kɨ rɔe oy njururu, me nḛ kotɨ njé mo̰y je tɨ, rəi sie rɔ Jəju tɨ. Lokɨ Jəju oo kadɨ-me ləde nɨngə, əl dəw kɨ rɔe oy njururu ka kɨn ə nə: «NGonm, uwə tɔgi ba, majal je ləi e kɨ kɨyə̰ go kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lo kɨn tɨ, njé ndo ndu-kun je lə Luwə kɨ na̰ je əli ta mede tɨ əi nə: «Dəw kam əl ta kɨ mal dɔ Luwə tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nə Jəju gər mər ta ləde, adɨ əl-de ə nə: «Ra ban ə ɨsɨ ɨməri ta je kɨ majal mesi tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kəl dəw kə nə: “Majal je ləi e kɨ kɨyə̰ go kɔ” ɓa nga̰ ngay al, ə se kəl-e kə nə: “Ḭ taa, ə ɨnjɨyə” ə nga̰ ngay al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Re e be ɓa, m-a m-ɔjɨ səi təkɨ mi NGon Dəw, m-aw kɨ tɔgɨ dɔnangɨ tɨ ne, mba kadɨ m-ɨyə̰-n go majal je lə dɨje kɔ.» Nɨngə, Jəju əl nje rɔ koy njururu ə nə: «Ḭ taa, un tuwə ləi, ə aw ɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɓa dɨngəm ḭ taa, ə un rəbɨ, aw ɓe. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lokɨ kəm kosɨ je oo nḛ kɨn, ra-de ɓəl kɨ dum, adɨ ɨləi tɔjɨ dɔ Luwə tɨ, kɨ adɨ dɨje tɔgɨ kɨ ətɨ ɓəl be kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lokɨ Jəju ɔtɨ no̰o̰ ɨsɨ aw nɨngə, lo də tɨ kɨ ɨsɨ də, oo dɨngəm kɨ ɓari-e nə Matɨye, ɨsɨ me kəy taa la-mbə tɨ. Ə Jəju əl-e ə nə: «Un gom.» Ɓa Matɨye ḭ taa, un go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Go tɨ, Jəju ɨsɨ ta nḛ kuso tɨ me kəy tɨ lə Matɨye. NGa nɨngə njé taa la-mbə je, kɨ ndəgɨ njé ra majal je, ngay, rəi ɨsi naa tɨ kɨ Jəju, kɨ njé ndo je lie ta nḛ kuso tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lokɨ *Parɨsɨ je ooi Jəju ɨsɨ uso nḛ kɨ dɨje kɨn nɨngə, əli njé ndo je lie əi nə: «Ra ban ə NJe ndo səsi nḛ ɨsɨ uso nḛ kɨ njé taa la-mbə je, kɨ njé ra majal je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ə Jəju oo ndude, adɨ əl-de ə nə: «E dɨje kɨ njé mo̰y je ə a sangi dəw kɨ nje ra mo̰y, ɓɨ e njé rɔ nga je ə a sangi dəw kɨ nje ra mo̰y, al. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Awi ɨsangi kadɨ ɨgəri me ta kɨ Luwə əl ə nə: “E ra majɨ ə m-ge, ɓɨ m-ge kɨjə məsɨ kadɨ-kare al. Tadɔ, m-re mba ɓar njé ka dana je al, nə m-re mba njé ra majal je yo”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","*NJé ndo je lə Ja̰ Batɨsɨ rəi ɨngəi Jəju əli-e əi nə: «Ra ban ə je kɨ *Parɨsɨ je j-ɨyə̰ ta nḛ kuso, ə njé ndo je ləi rai al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ə Jəju ɨlə-de tɨ ə nə: «Oi kadɨ dɨje kɨ ɓari-de lo nḛ kuso taa-naa tɨ, a əi kɨ rɔnəl al, dɔkagɨlo tɨ kɨ nje taa dəne ɨsɨ-n səde naa tɨ a? NDɔ je a rəi no̰o̰ kadɨ a uni-e tade tɨ nɨngə, dɔkagɨloe tɨ kɨn ə a ɨyə̰i ta nḛ kuso. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Dəw a un ta kɨbɨ kɨ sɨgɨ kadɨ ɨlə-n kəm kɨbɨ kɨ kɔke al. Re e be ə, ta kɨbɨ kɨ sɨgɨ ka kɨn a ḭ kɨ kɨ kɔke rakɨ rakɨ, kadɨ bole a to wororo ɨtə kɨ kəte ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Taa, dəw a un kasɨ kandɨ nju kɨ ḭ al ɓəy utɨ me mbu nda je tɨ kɨ kɔke al tɔ. Re e be nɨngə, lokɨ kasɨ a ḭ ɓa, mbu nda je a ndui, kadɨ kasɨ kandɨ nju a lo kɔ nɨm, taa mbu nda je ka təli nḛ kɨ tuji kɔ nɨm tɔ. Be ə, re kasɨ kandɨ nju ḭ al ɓəy ɓa, majɨ kadɨ mbu nda je əi kɨ sɨgɨ taa. Be ɓa, mbu a ndu al nɨm, kasɨ kɨ me tɨ ka a lo kɔ al nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lokɨ Jəju a əl-de ta kɨn nɨngə, nje kun dɔ *Jɨpɨ je kare, re ɔsɨ məkəsɨne nangɨ no̰e tɨ, əl-e ə nə: «NGonm kɨ dəne kɨ du oy taji naa tɨ ne ɓəy. Nə re ɨre ɨndə jii dɔe tɨ ə, a təl tɔsɨ ndəl.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jəju ḭ taa, un goe əi kɨ njé ndo je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nɨngə, dəne kare kɨ mo̰y məsɨ ade ko̰ ɓal dɔgɨ gɨde e joo, re ɓasi rɔ Jəju tɨ, kɨ rəbɨ kɨ gɨde tɨ, ɔdɨ ta kɨbɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","MBata əl mene tɨ ə nə: «Kɨn ə re ta kɨbɨ lie wa par mɨndɨ ə m-ɔdɨ ka, rɔm a nga.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jəju ɨlə rətɨ oo-e, ɓa əl-e ə nə: «Uwə tɔgi ba ngonm, kadɨ-me ləi aji.» Nɨngə dɔ kade tɨ wa kɨn par, dəne ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lokɨ Jəju re tḛḛ me kəy tɨ lə kɨ bo lə Jɨpɨ je ka kɨn nɨngə, oo njé kɔl nal je, kɨ kosɨ dɨje sɨngəi sokɨto dɔ-naa tɨ, ə əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ɔri rɔsi gogɨ, ngon oy al, nə to ɓi kare.» Dɨje ɨbəi Jəju kogii. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lokɨ adi kosɨ dɨje tḛḛi taga nɨngə, Jəju ur kəy, uwə ji ngon, ɓa ngon kɨ dəne ḭ taa. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Poy nḛ kɨn sane kɨ dɔnangɨ kɨ no̰o̰ ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lokɨ Jəju ɨsɨ aw, njé kəm tɔ je joo uni goe, əli ta kɨ ndude kɨ boy əi nə: «NGon ka Dabɨdɨ, o kəm-to-ndoo ləje.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jəju re ɓe nɨngə, njé kəm tɔ je kɨ joo ka kɨn rəi rɔe tɨ ɓasi, ə Jəju əl-de ə nə: «Oi kadɨ m-asɨ kadɨ m-ra nḛ kɨn wa kare wa?» Ə njé kəm tɔ je ɨləi-e tɨ əi nə: «Oyo, j-o kadɨ asɨ, Ɓaɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lo kɨn tɨ, Jəju ɔdɨ kəmde, ə əl-de ə nə: «Majɨ, kadɨ nḛ je rai nḛ kɨ go kadɨ-me tɨ ləsi!» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɓa, kəmde oo lo. Nɨngə, go tɨ, Jəju ndəjɨ-de kɨ tɔgɨne ə nə: «Oi majɨ, kadɨ dəw madɨ gər nḛ kɨ ra nḛ kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nə lokɨ tḛḛi kɨ taga be par ə, ɨləi ngɨrə kəl ta kɨ dɔe tɨ kɨ go nangɨ kɨ no̰o̰ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lokɨ njé kəm tɔ je tḛḛi awi nɨngə, dɨje rəi kɨ dɨngəm kare kɨ ndɨl kɨ majal ra-e adɨ əl ta al. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jəju tuwə ndɨl kɨ majal ɓa, dɨngəm kɨ kəte əl ta al ka kɨn, təl əl ta. Nɨngə nḛ kɨn ətɨ kosɨ dɨje ɓəl ngay, adɨ əli əi nə: «J-o nḛ kɨ be kɨn dɔnangɨ *Isɨrayəl tɨ nja kare al ɓəy!» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nə *Parɨsɨ je əli əi nə: «E kɨ tɔgɨ lə ngar lə ndɨl je kɨ majal, ə ɨsɨ tuwə-n ndɨl je kɨ majal.» ");
INSERT INTO bjvNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jəju aw kɨ ɓe bo je, kɨ ngan ɓe je, ndo nḛ me kəy kaw-naa tɨ lə *Jɨpɨ je, ɨlə mbḛ Poy Ta kɨ Majɨ ɔjɨ dɔ ko̰ɓe lə Luwə, taa ajɨ njé mo̰y je, kɨ njé rɔ to je pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lokɨ Jəju oo kosɨ je, oo kəm-to-ndoo ləde, tadɔ kɔ rade, tɔgɨde goto, awi tə batɨ je kɨ nje kul-de goto be. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Be ə, Jəju əl njé ndo je ləne ə nə: «Ko kɨ asɨ kɨjə, dɨle e ngay, nə njé kɨje je əi ngay al. ");
INSERT INTO bjvNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ə əli ta kɨ Ɓa nje ko, adɨ ɨlə kɨ njé ra ko je me ko tɨ ləne.» ");
INSERT INTO bjvNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jəju ɓar njé ndo je ləne kɨ dɔgɨ gɨde e joo, adɨ-de tɔgɨ kadɨ tuwəəi ndɨl je kɨ majal je, ajii njé mo̰y je, kɨ njé rɔ to je, pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tɔ njé kaw kɨlə je kɨ dɔgɨ gɨde e joo ə to kɨn: E kɨ dɔsa̰y e Sɨmo̰, kɨ ɓari-e nə Pɨyər əi kɨ ngokone Andɨre; Jakɨ əi kɨ Ja̰ kɨ ngan lə Jəbəde; ");
INSERT INTO bjvNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pɨlɨpɨ əi kɨ Batɨləmi, Tomasɨ əi kɨ Matɨye kɨ nje taa la-mbə; Jakɨ kɨ ngon lə Alpe əi kɨ Tade; ");
INSERT INTO bjvNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sɨmo̰ kɨ e mbo̰ njé rɔ mbata kɨngə dɔ lə ɓe ləde tɨ əi kɨ Judasɨ Isɨkarɨyotɨ kɨ nje kun dɔ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jəju ɨlə njé kaw kɨlə je ləne kɨ dɔgɨ gɨde joo kɨ ndu kɨn ə nə: «Awi rɔ dɨje tɨ kɨ əi *Jɨpɨ je al, al, taa awi me ɓe bo je tɨ kɨ *Samari tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Awi kɨ rɔ gɨn kojɨ tɨ kɨ *Isɨrayəl, kɨ toi tə batɨ je kɨ ndəmi be kɨn yo. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dɔ rəbɨ tɨ, ɨləi mbḛ təkɨ ko̰ɓe lə Luwə e ɓasi. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ə aji njé mo̰y je, adi njé koy je ḭḭ lo koy tɨ, adi banjɨ ur kɔ rɔ njé banjɨ je tɨ adɨ rɔde ay, ə ɨtuwəi ndɨl je kɨ majal dɔ dɨje tɨ tɔ. E nḛ kɨ ɨngəi kare, ə adi dɨje kare tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uni ɔr al nɨm, la al nɨm, sɨlə al nɨm, ɨləi dɔ nda tɨ kɨ ɓədɨsi tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Taa, uni ɓɔl kaw mba al nɨm, ɔyi kɨbɨ joo al nɨm, ɔyi sa al nɨm, uni kagɨ tɔsɨ al nɨm tɔ. Tadɔ sɔbɨ kadɨ nje ra kɨlə ɨngə nḛ kusone ji dɨje tɨ kɨ ra kɨlə dande tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Lokɨ uri me ngon ɓe tɨ, ə se me ɓe bo tɨ ə, ɨdəji ta, ə re ɨngəi dəw kɨ asɨ kadɨ uwə səsi rɔne tɨ ɓa, ɨsi ɓe lie no̰o̰ bɨtɨ kadɨ awii. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lokɨ uri me kəy tɨ nɨngə, ɨrai dɨje kɨ me tɨ lapɨya. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kɨn ə re uwəi səsi kɨ rɔde tɨ ɓa, kadɨ lapɨya ləsi aw kɨ dɔde tɨ, a kɨn ə re uwəi səsi kɨ rɔde tɨ al tɔ ɓa, kadɨ ɨtəli ɨtaai lapɨya ləsi gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A kɨn ə re, me kəy tɨ, ə se me ɓe tɨ, dɨje mbati kuwəi səsi kɨ rɔde tɨ, ə se mbati koo dɔ ta ləsi ɓa, lokɨ ɨsɨ tḛḛi me ɓe tɨ kɨn kɨ taga ə, ɨndəi bu kɨ njasi tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","M-əl səsi təkɨ rɔjetɨ, ndɔ gangɨ ta tɨ ə, ta kɨ gangɨ kɨ dɔ ɓee tɨ kɨn a ɨtə ya̰ Sodom kɨ Gomɔr ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Kɨ ne kɨn, mi, m-ɨlə səsi tə batɨ je dan jagɨm je tɨ. Majɨ kadɨ ɨndəi kəm-kədɨ dɔ rɔsi tɨ tə li je be, ə ɨsɔli lɔm lɔm tə də dum je be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Adi kəmsi ədɨ dɔ rɔsi tɨ kɨ rɔ dɨje tɨ, tadɔ a awi səsi lo gangɨ ta je tɨ, a tɨndəi səsi kɨ ndəy kabɨlay gɨn kəy kaw-naa je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A awi səsi no̰ njé ko̰ɓe je tɨ, kɨ no̰ ngar je tɨ kɨ boy kɨ mbata ləm. Lo kɨn tɨ, əi je, kɨ dɨje kɨ əi *Jɨpɨ je al, a e ta rəbɨ kɨ kadɨ a ɨngəəi najɨ kɨ ma kɨ dɔm tɨ rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lokɨ a uwəi səsi kadɨ a awi səsi lo gangɨ ta tɨ, onosi kadɨ mesi ɓəl, kə nə se ta ri ə a əli-de wa, ə se a əli-de kɨ kuje kɨ ban wa. Ta kɨ kadɨ a əli-de ɓa, Luwə a ɨndə tasi tɨ loe tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tadɔ e səi je wa ə a əli ta al, nə e NDɨl Bawsi Luwə ə a un səsi kadɨ əl-n ta. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«NGakonaa je a uni dɔ-naa awii lo tɔl-naa tɨ, baw ngon a aw kɨ ngon kadɨ tɔli-e kɔ, nɨngə ngan je, mede a majal kɨ njé kojɨ-de je, ə a uni dɔde awi kadɨ tɔli-de tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dɨje pətɨ mede a majal səsi kɨ mbata ləm, nə dəw kɨ uwə rɔne ba bɨtɨ ta tɔl tae tɨ, ə a ɨngə kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lokɨ a adi səsi ko̰ me ɓe bo tɨ kɨ kare ə, a̰yḭ-naa awi kɨ nungɨ tɨ. Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi, a ɨləi ta nja ɓe bo je kɨ *Isɨrayəl tɨ naa tɨ al ɓəy ə mi *NGon dəw m-a m-re. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","NJe ndo ɨtə nje ndo-e nḛ al, taa ɓəə ɨtə ɓane al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","NJe ndo, re asɨ kɨ nje ndo-e nḛ be ɓa, e ngay; ə ɓəə, re asɨ kɨ ɓane ɓa e ngay tɔ. Kɨn ə, ɓa nje kəy wa mɨndɨ ə, dɨje ɓari-e Bəljəbul kɨ e ngar lə ndɨl je kɨ majal nɨngə, njé kɨ me kəy tɨ lie ya̰de a to ban? ");
INSERT INTO bjvNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Ɨɓəli-de al, tadɔ nḛ ra kɨ gɨdɨ ngə̰y tɨ kɨ gɨne a tḛḛ al goto, taa nḛ kɨ to lo ɓɔyɔ tɨ, kɨ dəw a gər al ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nḛ kɨ m-əl səsi lo kɨ ndul tɨ, əli tae kada wangɨ, ə nḛ kɨ dɨje kɔti mbisi tɨ ngun ngun ngun, ɨləi mbḛe dɔ kagɨ tɨ taa tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɨɓəli dɨje kɨ a tɔli darɔsi par, ɓɨ asi tɔl ndɨlsi al kɨn, al. Nə kadɨ ɨɓəli Luwə kɨ asɨ kadɨ tujɨ ndɨlsi əi kɨ darɔsi naa tɨ me por tɨ lə su kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dɨje ɨsɨ gati kɨ ngan yəl je joo ə gusɨ kare adɨ oi ne, nə kɨ kare dande tɨ kɨ kadɨ osɨ nangɨ kɨ kanjɨ kadɨ Bawsi Luwə ndɨgɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɨ ɔjɨ dɔsi, bḭ dɔsi wa kɨn ka Luwə tɨdə kare kare gər kɔre. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɨɓəli nḛ madɨ al, səi je, Luwə oo ndasi ɨtəi ngan yəl je kɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Dəw kɨ ra kɨ un ndune ta kəm dɨje tɨ wangɨ, təkɨ n-e dəw ləm, mi ka m-a m-un ndum no̰ Bai tɨ, kɨ ɨsɨ dɔra̰ tɨ, təkɨ e dəw ləm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nə dəw kɨ najɨ ta kəm dɨje təkɨ, n-gər-m al, mi ka m-a m-najɨ ta kəm Bai tɨ, kɨ ɨsɨ dɔra̰ tɨ təkɨ m-gər-e al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ɨgai mesi tɨ təkɨ m-re kɨ lapɨya dɔnangɨ tɨ al; m-re kɨ lapɨya al, nə m-re kɨ rɔ dan dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M-re kɨ gangɨ-naa dan ngon kɨ dɨngəm tɨ əi kɨ bawne, m-re kɨ gangɨ-naa dan ngon kɨ dəne tɨ əi kɨ kone, m-re kɨ gangɨ-naa dan ngon kɨ dəne tɨ əi kɨ məmne kɨ dəne. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dəw madɨ, dɨje kɨ me kəy tɨ lie e wa, a təli njé ba̰ je lie. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Dəw kɨ ndɨgɨ kone, ə se bawne ɨtə-m, dəwe kɨn asɨ kadɨ e dəw ləm al. Dəw kɨ ndɨgɨ ngonne kɨ dɨngəm, ə se kɨ dəne ɨtə-m, dəwe kɨn asɨ ta kadɨ e dəw ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Dəw kɨ un kagɨ-dəsɨ ləne dɔne tɨ, ə un gom, al, dəwe kɨn asɨ ta kadɨ e dəw ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dəw kɨ ge ngəm rɔne ne wa, a tḭ tae, nə dəw kɨ ɨlə rɔne kɔ kɨ mbata ləm, ta rɔe a tḭ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Dəw kɨ uwə səsi kɨ rɔne tɨ, e mi ə dəwe uwə-m kɨ rɔne tɨ. Nɨngə dəw kɨ uwə-m kɨ rɔne tɨ, e nje kɨlə-m ə uwe kɨ rɔne tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dəw kɨ uwə nje kəl ta kɨ ta Luwə tɨ kɨ rɔne tɨ, mbata ke kɨ e nje kəl ta kɨ ta Luwə tɨ ɓa, a ɨngə nḛ kɨgə go ji kɨ asɨ naa kɨ ya̰ nje kəl ta kɨ ta Luwə tɨ wa kɨn be tɔ. Dəw kɨ uwə dəw kɨ dana kɨ rɔne tɨ, mbata ke kɨ e dəw kɨ dana ɓa, a ɨngə nḛ kɨgə go ji kɨ asɨ naa kɨ ya̰ dəw kɨ dana wa kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","M-əl səsi təkɨ rɔjetɨ, dəw kɨ adɨ man kɨ sɔl wa kɨn par me ngon kal man tɨ, kɨ kare dan njé kɨ du tɨ kɨ dan njé ndo je tɨ ləm kɨn, mbata ke kɨ e nje ndo ləm ɓa, dəwe kɨn, təkɨ rɔjetɨ, adɨ m-əl səsi, a nal nḛ kɨgə go ji ləne al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lokɨ Jəju adɨ ndu kɨn njé ndo je ləne kɨ dɔgɨ gɨde e joo, gɨne gangɨ ɓa, ɔtɨ no̰o̰, aw ndo nḛ je, ɨlə mbḛ Poy Ta kɨ Majɨ je me ɓe bo je tɨ kɨ dɔnangɨ tɨ kɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lo kɨn tɨ, Ja̰ Batɨsɨ kɨ to kəy dangay tɨ, oo poy nḛ je kɨ Kɨrɨsɨ ra, adɨ ɨlə njé ndo je ləne, kadɨ dəji ta Jəju əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«Ḭ ə ḭ dəw kɨ Luwə mbəte, kɨ sɔbɨ kadɨ a re ka kɨn ə se, e nay no̰o̰ ɓəy kadɨ tə jɨ ngəm tae ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ə Jəju ɨlə-de tɨ ə nə: «Awi əli Ja̰ nḛ je kɨ oi kɨ mbisi je, kɨ kəmsi je kɨn: ");
INSERT INTO bjvNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","NJé kəm tɔ je ooi lo, njé mətɨ je njɨyəi majɨ, njé banjɨ je ɨngəi rɔ nga, njé mbi bəy je ooi ta, njé koy je ḭḭ taa lo koy tɨ, taa njé ndoo je ka, e kɨ kɨlə-de mbḛ Poy Ta kɨ Majɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Majɨ-kur e lə dəw kɨ m-təl gɨn kosɨ lie, al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lokɨ ɔti awi, Jəju ɨlə ngɨrə kəl kosɨ je ta kɨ dɔ Ja̰ tɨ ə nə: «E ri ə awi ɨsɨ oi dɨlə lo tɨ ə? E gakɨra kɨ nəl ɨsɨ aw sie kɨ yo je, kɨ ne je kɨn a? ");
INSERT INTO bjvNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","A re e e al ə, e ri wa bangɨ awi ɨsɨ oi ə? E dəw kɨ ɔ kɨbɨ kɨ ndole ngay ɓa awi oi-e ma? NGa njé kɨ ɔi kɨbɨ je kɨ ndole ngay ka, ɨsi me kəy je tɨ kɨ ngar je ɨsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ə se e ri wa ə awi oi wa? E nje kəl ta kɨ ta Luwə tɨ ə awi oi-e ma? Re e e ə, m-əl səsi m-ə nə oyo, e nje kəl ta kɨ ta Luwə tɨ kɨ ɨtə njé kəl ta je kɨ ta Luwə tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","E e ə makɨtɨbɨ lə Luwə əl ta kɨ dɔe tɨ kəte ə nə: “M-a m-ɨlə kɨ nje kaw kɨlə ləm kəte kadɨ ra go rəbɨ no̰i tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Təkɨ rɔjetɨ, adɨ m-əl səsi, dan dɨje tɨ pətɨ kɨ dəne je oji-de kɨn, dəw kɨ bo ɨtə Ja̰ Batɨsɨ goto. Nə kɨ ɓasɨne kɨn, dəw kɨ e kɨ du ngay me ɓeko̰ tɨ kɨ dɔra̰ tɨ, bo ɨte. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lo kɨlə ngɨre dɔkagɨlo tɨ lə Ja̰ Batɨsɨ, bɨtɨ ɓone, ko̰ɓe lə Luwə e gɨn nḛ ra kɨ kɨ tɔgɨ tɨ, nɨngə njé tɔgɨ je sangi kadɨ n-taai-e gɨn tɔgɨde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Makɨtɨbɨ je lə njé kəl ta je kɨ ta Luwə tɨ pətɨ, kɨ ndu-kun je lə *Mojɨ, əli ta kɨ dɔ nḛ je tɨ kɨ a rai nḛ bɨtɨ tḛḛi dɔ Ja̰ Batɨsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Re ɨndɨgi kadɨ ɨgəri gɨne majɨ ɓa, Ja̰ e nje kəl ta kɨ ta Luwə tɨ, Eli kɨ kadɨ a təl re. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ə dəw kɨ aw kɨ mbine mba koo-n dɔ ta ɓa, kadɨ oo ta kɨn majɨ! ");
INSERT INTO bjvNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«M-o dəw kɨ kadɨ m-un-e m-ɔjɨ-n dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨn al. M-a m-ə nə toi tə ngan je kɨ du kɨ ɨsi ta mbalo je tɨ, ɓari-naa kɨ yo je kɨ ne je əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jɨ kɔl nal kadɨ ɨndamii, ə ɨmbati ndam, j-osɨ pa yo kadɨ ɨno̰i, ə ɨmbati no̰.” ");
INSERT INTO bjvNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E be ə, Ja̰ re, uso nḛ al nɨm, a̰y man al nɨm ɓa, dɨje əli əi nə: “Dɔe majal”, ");
INSERT INTO bjvNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","NGa ə, mi *NGon dəw m-re, ə m-uso nḛ je, m-a̰y man je ɓa, dɨje əli əi nə: “Mi nje kuso nḛ kədɨ, mi nje ka̰y nḛ, mi madɨ njé taa la-mbə je, kɨ njé ra majal je,” ɓəy tɔ! Nə njé kɨ ndɨgi gosɨ lə Luwə, gəri kadɨ gosɨ lə Luwə e gosɨ kɨ dana kɨ go kɨlə rae tɨ kɨ to kɨ taga.» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lo kɨn tɨ, Jəju ɨlə rɔne, kɔl kɨ dɨje kɨ me ɓe bo je tɨ, kɨ əi ə əi dɨje kɨ, ra nḛ kɔjɨ je ngay dande tɨ, nə ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ al, ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kəm-to-ndoo e ləsi, səi dɨje kɨ Korajḛ! Kəm-to-ndoo e ləsi səi dɨje kɨ Bətɨsayda! Nḛ kɔjɨ je kɨ ətɨ ɓəl, kɨ Luwə ɔjɨ dansi tɨ kɨn, re nḛ je kɨn rai nḛ me ɓe bo Tɨr tɨ, kɨ ɓe bo Sɨdo̰ tɨ be ə, re dɨje kɨ me tɨ a ɨyə̰i rəbɨ nḛ rade je kɨ majal mari nu. Re a ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ, kɨ go rəbɨ kɨlə kɨbɨ kuwə ndoo rɔ tɨ, kɔy-n bu por kɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E be ə, m-əl səsi kadɨ ɨgəri təkɨ, ndɔ gangɨ ta tɨ ə, ta kɨ gangɨ kɨ dɔ Tɨr tɨ kɨ Sɨdo̰, ya̰si a nga̰ ɨte. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","NGa nɨngə ḭ Kapərnayɨm, o kadɨ a un dɔi taa bɨtɨ kadɨ ɔdɨ ra̰, nə Luwə a təl səi bɨtɨ kaw səi koo. Tadɔ nḛ kɔjɨ je kɨ rai nḛ Kapərnayɨm tɨ kɨn, re rai nḛ Sodom tɨ be ə, re ɓone kɨn ɓe bo kɨ Sodom a a kɨ dɔne taa ne ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","E be ə, m-əl səsi kadɨ ɨgəri təkɨ, ndɔ gangɨ ta tɨ ə, ta kɨ gangɨ kɨ dɔ dɨje tɨ kɨ Sodom a nga̰ ngay tə ya̰si be al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dɔ gangɨ loe tɨ kɨn, Jəju un ta, əl ə nə: «Bai, kɨ ḭ Ɓa dɔra̰ kɨ dɔnangɨ, m-ɨlə tɔjɨ dɔi tɨ, təkɨ ɨɓɔyɔ nḛ je kɨn njé tər je, kɨ njé nḛ gər je, ə ɨtḛḛ kɨ dɔe adɨ ngan je kɨ du gəri. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oyo, Bai, e ndɨgɨ ləi kadɨ nḛ kɨn ra nḛ be.» ");
INSERT INTO bjvNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ɓa, Jəju əl dɨje kɨ ai no̰o̰ ə nə: «Bai, adɨ-m nḛ je pətɨ, nɨngə dəw kare kɨ gər-m, mi NGon, goto, e Bai kɨ karne ba par, taa dəw kare kɨ gər Bai ka goto tɔ, e mi NGon kɨ karm ba par, nɨngə e dɨje kɨ mi wa ə m-ndɨgɨ kadɨ m-adɨ gəri-mi par tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ɨrəi kɨ rɔm tɨ, səi pətɨ kɨ ɔi rɔgɔgɔ gɨn nḛ kotɨ tɨ kɨ ɔy, ə m-a m-adɨ səsi ɔri kə̰ə̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uni jugɨ ləm, ə ɨtaai nḛ ndo ləm, tadɔ mi dəw kɨ sɔl lɔm lɔm, taa mi nje kɨlə dɔm nangɨ nɨm tɔ. Re ɨrai be ə, a ɨngəi lo kɔr kə̰ə̰ lə ndɨlsi. ");
INSERT INTO bjvNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mi, jugɨ ləm ɔy al, taa nḛ kɨ madɨ səsi kadɨ oti ka ɔle pəl pəl tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","NDɔ kare, Jəju ɨndə də me ndɔr gəme je tɨ, ndɔ taa kə̰ə̰ tɨ lə *Jɨpɨ je. *NJé ndo je lie kɨ əi sie, ɓo ra-de adɨ gangi dɔ ko je, usoi. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ə lokɨ *Parɨsɨ je ooi-de nɨngə, əli Jəju əi nə: «O njé ndo je ləi rai nḛ kɨ kadɨ dəw ra ndɔ taa kə̰ə̰ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ə Jəju təl əl-de ə nə: «Ɨtɨdəi nḛ kɨ ngar *Dabɨdɨ ra lokɨ ɓo ra-de kɨ dɨje kɨ goe tɨ kɨn al a? ");
INSERT INTO bjvNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dabɨdɨ ur me kəy tɨ lə Luwə kɨ ra kɨ kɨbɨ, əi kɨ dɨje kɨ gone tɨ, usoi mapa kɨ dɨje adi Luwə kadɨ-kare tɨ. E mapa kɨ kuso-e sɔbɨ dɔe al nɨm, sɔbɨ dɔ njé kɨ goe tɨ al nɨm, nə e njé kɨjə nḛ məsɨ kadɨ-kare par ə sɔbɨ dɔde kadɨ usoi. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ə se ta kɨ ndu-kun lə *Mojɨ ndangɨ əl ə nə: ndɔ taa kə̰ə̰ tɨ, njé kɨjə nḛ məsɨ kadɨ-kare je, rai kɨlə kɨ e nḛ kɨ kadɨ dəw ra ndɔ taa kə̰ə̰ tɨ al, gɨn kəy tɨ lə Luwə, nə dəw tɨdə dɔde tɨ kadɨ e majal al kɨn, ɨtɨdəi al a? ");
INSERT INTO bjvNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","NGa nɨngə kadɨ m-əl səsi, lo kɨ j-a tɨ ne kɨn, nḛ kɨ bo ngay ɨtə kəy lə Luwə to tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nɨngə kɨn ə re ɨgəri me ta kɨ ə nə: “E koo kəm-to-ndoo ə m-ge, ɓɨ e kɨlə məsɨ kadɨ-kare par al” kɨn ə, re a ɨgangi ta dɔ dɨje tɨ kɨ ta ləde goto kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tadɔ mi *NGon dəw, m-aw kɨ tɔgɨ dɔ ndɔ taa kə̰ə̰ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jəju ḭ no̰o̰, aw kəy kaw-naa tɨ lə *Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nɨngə dɨngəm kare kɨ jie oy njururu e me kəy kaw-naa tɨ no̰o̰. Ɓa, dɨje sangi rəbɨ kɨ kadɨ n-ɨndəi ta dɔ Jəju, adɨ dəji-e ta əi nə: «NDu-kun adɨ ta rəbɨ kadɨ dəw ajɨ madɨne ndɔ taa kə̰ə̰ tɨ ə se aje al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ə Jəju ɨlə-de tɨ ə nə: «Na̰ dansi tɨ ə, aw kɨ batɨ kare ba, ə batɨ ka kɨn osɨ ɓe tɨ ndɔ taa kə̰ə̰ tɨ, ə aw un-e tḛḛ sie taga al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","NGa nɨngə re e dəw ɓa, ɨtə batɨ gɨdɨ ba̰y ba̰y! ƏƏ m-əl səsi təkɨ ndu-kun adɨ ta rəbɨ kadɨ dəw ra majɨ ndɔ taa kə̰ə̰ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lo kɨn tɨ no̰o̰, Jəju əl dɨngəm ka kɨn ə nə: «Ɨsurə jii.» Ə dɨngəm surə jine ɓa, jie təl to majɨ asɨ-naa kɨ kɨ nungɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ə lokɨ *Parɨsɨ je tḛḛi taga ɓa, awi əli-naa ta kɨ dɔ Jəju tɨ, kadɨ n-ooi se n-a n-rai ban ə n-a n-tɔli-e wa. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lokɨ Jəju oo poy nḛ kɨ gei ra sie, ɔtɨ lo kɨn tɨ no̰o̰ kɔ. Dɨje ngay uni goe, nɨngə ajɨ njé mo̰y je pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ɓa, ndəjɨ-de kɨ tɔgɨne, kadɨ rai adɨ dəw gər-ne al. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nɨngə nḛ kɨn ra nḛ be kadɨ ta kɨ Luwə əl kɨ ta nje kəl ta kɨ tae tɨ, Ejay kɨn, tɔl tane. Luwə əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Oi ɓəə kɨlə ləm kɨ m-kɔte, NJe ndɨgɨ ləm, kɨ rɔm nəl-m ngay kadɨ m-ɨlə jim dɔe tɨ. M-a m-ɨndə NDɨlm dɔe tɨ, Nɨngə a ɨlə mbḛ nḛ ra kɨ dana rɔ gɨn ɓe je tɨ kɨ dangɨ dangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A kɔli-naa kɨ dəw al nɨm, a ɨndə ndu al nɨm. Dəw a oo ndue əl ta ta mbalo tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A budɨ gakɨra kɨ to kɨ mbɔne nangɨ al, Taa, a tɔl lambɨ kɨ ɨsɨ oy al nɨm tɔ. A ra be bɨtɨ kadɨ tə nḛ ra kɨ dana o̰ ɓe. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Gɨn ɓe je kɨ dangɨ dangɨ a ɨndəi mede dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dɨje rəi kɨ dɨngəm kare kɨ ndɨl kɨ majal ra-e adɨ kəme oo lo al nɨm, əl ta al nɨm, ə Jəju ade əl ta je, oo lo je. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nḛ kɨn ətɨ kosɨ dɨje ɓəl ngay, adɨ dəji-naa ta əli əi nə: «Dəw kam e *NGon ka Dabɨdɨ al ma?» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nə lokɨ *Parɨsɨ je ooi ta kɨn nɨngə, əli əi nə: «E kam ɨsɨ tuwə ndɨl je kɨ majal kɨ tɔgɨ lə Bəljəbul, kɨ e ngar lə ndɨl je kɨ majal.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jəju gər mər ta ləde adɨ əl-de ə nə: «Kɨn ə, dɨje kɨ me ɓeko̰ tɨ kɨ kare ba, təli dɔ-naa tɨ rɔi-naa ə, ɓe ko̰e kɨn a tujɨ. Taa, ɓe bo, ə se me kəy kɨ dɨje kɨ me tɨ təli dɔ-naa tɨ, rɔi-naa, kɨ kadɨ a a taa ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kɨn ə re *Sata̰ wa tuwə dɨje lə Sata̰, e wa adɨ dɨje lie təli dɔ-naa tɨ rɔi-naa ə, lo kadɨ ko̰ɓe lie a aw kɨ kəte goto. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kɨn ə re e kɨ tɔgɨ lə Bəljəbul ə m-tuwə-n ndɨl je kɨ majal ə, dɨje kɨ gosi tɨ tuwəi-de kɨ tɔgɨ lə na̰ ə? Dɨje kɨ gosi tɨ wa a tɔji kadɨ ta ləsi e ta kɨ go tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A re e kɨ tɔgɨ lə NDɨl Luwə ə m-ɨsɨ m-tuwə-n ndɨl je kɨ majal tɔ nɨngə, tɔjɨ kadɨ ko̰ɓe lə Luwə re tḛḛ rɔsi tɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Nɨngə təkɨ rɔjetɨ, re dəw uwə dəw kɨ nje tɔgɨ dɔe kəte al ə, a asɨ kur me kəy tɨ lie, kadɨ ndur nḛ kɨngə lie al. Lokɨ dɔe ngata nɨngə, a ndur nḛ kɨ me kəy tɨ lie təkɨ mene ge. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nɨngə kadɨ ɨgəri, dəw kɨ e səm al, e nje kɔsɨ-m ta, taa dəw kɨ kaw səm nḛ kɨ naa tɨ al, e nje tɨndə tḭ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Be ə, m-əl səsi təkɨ, majal je pətɨ kɨ dɨje a rai-de, ə se ta je kɨ mal pətɨ kɨ dɨje a əli dɔ Luwə tɨ, Luwə a ɨyə̰ goe kɔ adɨ-de, nə ta kɨ mal kɨ kəl dɔ NDɨl Luwə tɨ, Luwə a ɨyə̰ go kɔ adɨ-de al ratata. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kɨn ə re dəw əl ta kɨ majal ɔsɨ-n tam, mi *NGon dəw ə, Luwə a ɨyə̰ go kɔ ade, nə re əl ta kɨ mal ɔsɨ-n ta NDɨl Luwə ə, Luwə a ɨyə̰ go kɔ ade kɨ ɓone tɨ al nɨm, kɨ lo ti tɨ al nɨm, ratata. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kɨn ə re kagɨ majɨ ɓa, kande majɨ tɔ, a re kagɨ majal ɓa, kande majal tɔ. Tadɔ e kɨ kandɨ kagɨ ə dəw a gər-n kagɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Səi njé man majal tə li je be kam, a rai ban be ə ta kɨ majɨ a tḛḛ tasi tɨ, səi kɨ səi dɨje kɨ majal ə? Tadɔ e nḛ je kɨ rosɨ me dəw kɨn ə ɨsɨ tḛḛ tae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dəw kɨ majɨ, kɨlə rae je tḛḛ me nḛ ra tɨ kɨ majɨ kɨ uwə mee. Nɨngə dəw kɨ majal, kɨlə rae je tḛḛ me nḛ ra tɨ kɨ majal kɨ uwə mee tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","M-əl səsi, ngan ta je kɨ galala pətɨ kɨ ɨsɨ tḛḛ ta dɨje tɨ kɨn, a əli gɨne ndɔ gangɨ ta tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tadɔ e kɨ ta kɨ tai tɨ ə a ɔri ta dɔi tɨ, ə e kɨ ta kɨ tai tɨ tɔ ə ta a uwəi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","NJé ndo ndu-kun je kɨ *Parɨsɨ je uni ta əli Jəju əi nə: «NJe ndo dɨje, jɨ ndɨgɨ kadɨ ɨra nḛ kɔjɨ madɨ kare adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ə Jəju ɨlə-de tɨ ə nə: «Dɨje kɨ dɔkagɨlo tɨ kɨ ɓone, əi dɨje kɨ majal, kɨ njé kuwə marɨm, ndɨgi kadɨ n-ooi nḛ kɔjɨ, nə nḛ kɔjɨ madɨ kɨ rangɨ kɨ kadɨ a oi ore dɔ nḛ kɔjɨ lə nje kəl ta kɨ ta Luwə tɨ Jonasɨ, goto ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tadɔ, tə ka kɨ Jonasɨ ra kondɔ mɨtə, kadɨ mɨtə me kanjɨ tɨ kɨ boy ka kɨn ə, mi *NGon dəw m-a m-ra kondɔ mɨtə, kadɨ mɨtə gɨn nangɨ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","NDɔ gangɨ ta tɨ ə, dɨje kɨ Nɨnɨbɨ tɨ a ḭ taa ta kəm dɨje tɨ kɨ dɔkagɨlo tɨ kɨ ɓone kɨn kadɨ a ɨləi ta dɔde tɨ. MBata, lokɨ Jonasɨ ɨlə mbḛ Poy Ta kɨ Majɨ, dɨje kɨ Nɨnɨbɨ tɨ ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ. NGa nɨngə, kɨ ɓasɨne kɨn, dəw kɨ ɨtə Jonasɨ sa̰y e ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","NDɔ gangɨ ta tɨ ə, ngar kɨ dəne kɨ ḭ gɨn ɓe tɨ, a ḭ taa ta kəm dɨje tɨ kɨ dɔkagɨlo tɨ kɨ ɓone kɨn kadɨ a ɨlə ta dɔde tɨ. MBata, ḭ so̰y dɔnangɨ tɨ nu ə ndɔ kɨ re kadɨ oo gosɨ ta lə Salomo̰. NGa nɨngə, kɨ ɓasɨne kɨn, dəw kɨ ɨtə Salomo̰ sa̰y e ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Lokɨ ndɨl kɨ majal tḛḛ me dəw tɨ, aw ɨlə kɨ dɨlə lo kɨ tutɨ mba kadɨ n-ɨngə lo kɨsɨ kɨ rangɨ kadɨ n-ɔr kə̰ə̰ tɨ, nə ɨngə al ɓa, ");
INSERT INTO bjvNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","əl ə nə: “M-a m-təl kadɨ m-aw lo kɨsɨ-m tɨ kɨ kəte m-ɨsɨ tɨ ə m-tḛḛ ka kɨn gogɨ.” Lokɨ təl aw gogɨ nɨngə, ɨngə me lo ka kɨn to kare, utəi, rai adɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","NGa ə, təl aw, ɔy ndɨl je kɨ majal ɨtəi-e e wa ɓəy sɨri, ɓa rəi uri me dəw tɨ ka kɨn ɨsi. Lo kɨn tɨ, ji kɨsɨ dəw kɨn kɨ dɔe taa a majal ngay ɨtə e kɨ kəte ɓəy. Be ə, dɨje kɨ majal kɨ dɔkagɨlo tɨ kɨ ɓone ka a toi be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jəju ɨsɨ əl ta kosɨ je ba ɓəy nɨngə, ko̰e je kɨ ngako̰e je rəi ai taga, sangi kadɨ n-əli sie ta. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","NGa ə dəw madɨ əl-e ə nə: «O ko̰i je kɨ ngako̰i je ai taga no̰o̰, a sangi kadɨ n-əli səi ta.» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ə Jəju təl əl dəw ka kɨn ə nə: «Na̰ je ə əi kom je, kɨ ngakom je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɓa un jine tɔjɨ-n njé ndo je ləne, ə ə nə: «Oi kom je, kɨ ngakom je ə ɨsi kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tadɔ dəw kɨ nje ra ndɨgɨ lə Bawm kɨ ɨsɨ me dɔra̰ tɨ ə, e ngokom je, e konanm je, kɨ kom je.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","NDɔe tɨ kɨn, Jəju tḛḛ me kəy tɨ, aw ɨsɨ kadɨ ba bo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kosɨ dɨje ngay kawi-naa gəi gɨde, adɨ aw al ɨsɨ me to tɨ. Ɓa kosɨ dɨje pətɨ, ai ngangɨ ba tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jəju əl-de nḛ je ngay me kujɨ ta je tɨ ə nə: «NJe ndɔr kare aw kadɨ dɨbɨ nḛ, ");
INSERT INTO bjvNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","nɨngə dɔkagɨlo tɨ kɨ a ɨlə ko nḛ, ka̰ ko je madɨ tosi ngangɨ rəbɨ tɨ adɨ yəl je rəi o̰i makɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka̰ ko madɨ je, tosi dɔnangɨ njəkɨrə tɨ, adɨ lo kadɨ ɨngəi dɔnangɨ asɨ tam ɨləi ngɨrəde tɨ goto. Nə ke ə, tɔgi kalangɨ ba, tadɔ ngɨrəde to taa ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lokɨ kadɨ ɔsɨ nɨngə, ngan ko je ka kɨn ndoləi mbaw, ɓa go tɨ, tuti kurɨm, tadɔ ngɨrəde aw nangɨ boy al. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ka̰ ko je kɨ nungɨ, tosi dan kon je tɨ, adɨ kon je tɔgi ndəmi-de mbɔl. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nə ka̰ ko je madɨ, tosi dɔnangɨ tɨ kɨ majɨ, adɨ andi. Kɨ na̰ je andi asɨ ɓu kare, njé kɨ nungɨ andi asɨ kutɨ mehḛ, taa njé kɨ nungɨ ɓəy andi asɨ kutɨ mɨtə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jəju ɨlə dɔ tɨ ə nə: «Dəw kɨ aw kɨ mbine mba koo-n dɔ ta ɓa, kadɨ oo dɔ ta kɨn majɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","*NJé ndo je lə Jəju rəi rɔe tɨ dəji-e əi nə: «MBa ri ə əl-de ta kɨ kujɨ ta je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ə Jəju əl-de ə nə: «M-əl-de ta kɨ kujɨ ta tadɔ səi, Luwə tḛḛ kɨ dɔ nḛ kɨ to lo ɓɔyɔ tɨ kɨ ɔjɨ dɔ ko̰ɓe lie adɨ ɨgəri, nə əi je, Luwə tḛḛ kɨ dɔe adɨ-de al. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tadɔ dəw kɨ aw kɨ nḛ jine tɨ, a adi-e dɔ tɨ ɓəy, kadɨ to mbar mbar jie tɨ, nə dəw kɨ nḛ lie goto, e kɨ ndɨkɨri wa kɨ aw-n jine tɨ kɨn ka, a taai jie tɨ wa ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","E mbata kɨn ə, m-əl-n-de ta kɨ kujɨ ta, tadɔ go̰i lo majɨ ka, ooi nḛ al nɨm, ooi ta majɨ ka, gəri me al nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","E be kadɨ ta kɨ Luwə əl kɨ nje kəl ta kɨ tae tɨ Ejay kɨn tɔl tane. Ejay əl ə nə: “A ooi dɔ ta majɨ, nə a ɨgəri me al nɨm, A ɨgo̰i lo majɨ, nə a ooi lo al nɨm, ");
INSERT INTO bjvNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tadɔ me dɨje kɨn təl nga̰ ngororo. Uti mbide, NDəmi kəmde, NDɨgi kadɨ kəmde oo lo al nɨm, Kadɨ mbide oo ta al nɨm, Taa kadɨ n-gəri nḛ madɨ kare al nɨm tɔ, Nə təkɨ ne n-ḭḭ n-rəi rɔm tɨ, Adɨ m-ajɨ-de.” ");
INSERT INTO bjvNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Nə səi, səi njé majɨ-kur, tadɔ kəmsi oo nḛ je majɨ nɨm, mbisi oo ta majɨ nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Təkɨ rɔjetɨ, adɨ m-əl səsi, njé kəl ta je kɨ ta Luwə tɨ, ngay, kɨ njé ra nḛ je kɨ dana ngay, ndɨgi kadɨ kəmde oo nḛ kɨ səi je, kəmsi oo kɨn, nə asi koo al, ndɨgi kadɨ mbide oo dɔ ta kɨ səi je, mbisi oo kɨn, nə asi koo al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Səi, majɨ kadɨ gəri me kujɨ ta lə nje kɨlə ko kɨn majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","NGangɨ rəbɨ kɨ ka̰ ko je tosɨ tɨ, e dəw kɨ oo ta kɨ dɔ ko̰ɓe tɨ lə Luwə, nə gər me al, ə su re ɔr ta kɨ dɨbɨ mee tɨ ka kɨn kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dɔnangɨ njəkɨrə kɨ ka̰ ko je tosɨ tɨ, e dəw kɨ oo ta lə Luwə nɨngə, taa langɨsi ba kɨ rɔnəl, ");
INSERT INTO bjvNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nə ta kɨn, ɨlə ngɨrəne mee tɨ al. E dəw kɨ nje kuwə kɨ ta lə Luwə dɔkagɨlo kɨ ndə̰y be par. Dɔkagɨlo kɨ ko̰ je, ə se kɨndə kəm-ndoo kɨ mbata ta lə Luwə re ɓa, ɨyə̰ kadɨ-me ləne kɔ kalangɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ka̰ ko je kɨ tosɨ dan kon tɨ, e dəw kɨ oo ta lə Luwə, nə me ka sururu dɔ nḛ je tɨ kɨ dɔnangɨ tɨ, kɨ ra ta nḛ majɨ je utɨ dɔ ta kɨ oo, adɨ lo kadɨ andɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nɨngə, dɔnangɨ kɨ majɨ kɨ ka̰ ko je tosɨ tɨ, e dəw kɨ oo ta lə Luwə, gər mee, adɨ andɨ majɨ. Dɔe kɨ madɨ je andi ɓu kare je, kɨ nungɨ andi kutɨ mehḛ je, kutɨ mɨtə je.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jəju ɨndə kujɨ ta kɨ rangɨ no̰de tɨ ɓəy ə nə: «Ko̰ɓe lə Luwə, to tə dəw kɨ dɨbɨ kandɨ nḛ kɨ majɨ me ndɔr tɨ ləne, ");
INSERT INTO bjvNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ə kondɔ, lokɨ dɨje toi ɓi ɓa, nje ba̰ lie re dɨbɨ jəne dɔ nḛ tɨ kɨ majɨ kɨ dɨbɨ ka kɨn, ɓa ɔtɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lokɨ kandɨ nḛ kɨ majɨ ka kɨn ɨbə tɔgɨ, ə kande je ɨsɨ tḛḛi ɓa, jəne ka kande tḛḛ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lo kɨn tɨ, njé ra kɨlə je awi əli ɓade əi nə: “Ɓaje, e kandɨ nḛ kɨ majɨ ə ɨdɨbɨ me ndɔr tɨ ləi tɔ, nga jəne je kɨn tḛḛi ra ə?” ");
INSERT INTO bjvNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ə ɓade əl-de ə nə: “E nje ba̰ ə ra nḛ kɨn.” NGa ə njé ra kɨlə je dəji-e əi nə: “Ɨndɨgɨ kadɨ jɨ rə̰y-de kɔ a?” ");
INSERT INTO bjvNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nə ɓa nje ndɔr əl-de ə nə: “Jagɨ, lo rə̰y jəne je tɨ kɨn, a rə̰yḭ kɨ ko kɨ majɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ə ɨyə̰i-de adɨ tɔgi naa tɨ bɨtɨ kagɨ lo kɨjə ko tɨ, nɨngə ndɔ kɨje tɨ ɓa, m-a m-əl njé kɨje je m-ə nə: Ɨrə̰yḭ jəne je kɨn ɨdɔɔi kɨ dɔe dɔe kadɨ tə ɨləi por ɓəy taa, ɨjəi wa kɨ me dam tɨ ləm.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jəju ɨndə kujɨ ta kɨ rangɨ no̰de tɨ ɓəy ə nə: «Ko̰ɓe lə Luwə to tə ka̰ kagɨ madɨ kɨ ɓari-e nə mutadɨ kɨ dəw madɨ un dɨbɨ me ndɔr tɨ ləne kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka̰ mutadɨ ə e kandɨ nḛ kɨ du ɨtə ndəgɨ kandɨ nḛ je pətɨ, nə lo kɨ tɔgɨ ɓa, təl kagɨ ta̰y kɨ bo ɨtə kam ta̰y je pətɨ kɨ me ndɔr tɨ. Təl kagɨ kɨ bo, adɨ yəl je rəi rai kəy tode bajie je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jəju əl-de kujɨ ta kɨ rangɨ ɓəy ə nə: «Ko̰ɓe kɨ dɔra̰ tɨ to tɨtɨ-naa kɨ əm kɨ dəne madɨ un lɔy-n ndujɨ kɨ me kee joo, adɨ ndujɨ kɨ lɔy ba pətɨ ḭ kɨn be.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ta je kɨn pətɨ, Jəju əl kosɨ je kɨ kujɨ ta. Ta kɨ kadɨ əl-de kɨ kujɨ ta al, goto. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E be kadɨ ta je kɨ Luwə əl kɨ ta nje kəl ta kɨ tae tɨ kɨn tɔl tane. NJe kəl ta kɨ ta Luwə tɨ əl ə nə: «M-a m-tḛḛ tam kadɨ m-əl kujɨ ta je, m-a m-ɨlə mbḛ nḛ je kɨ toi lo ɓɔyɔ tɨ lo kɨlə ngɨrə dɔra̰ tɨ kɨ dɔnangɨ tɨ nu kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jəju ɨyə̰ kosɨ je ə aw ɓe. Lokɨ rəi ɓe, njé ndo je lie rəi rɔe tɨ, dəji-e əi nə: «Ɔr-je gɨn kujɨ ta kɨ dɔ jəne tɨ kɨ a me ndɔr tɨ kɨn adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ə Jəju ɨlə-de tɨ ə nə: «Dəw kɨ nje dɨbɨ ko nḛ kɨ majɨ kɨn, e mi NGon dəw; ");
INSERT INTO bjvNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","nɨngə ndɔr, e dɔnangɨ; ə kandɨ ko kɨ majɨ, e njé je kɨ ndɨgi kadɨ Luwə o̰ ɓe dɔde tɨ; jəne, e njé je kɨ uni go nje majal; ");
INSERT INTO bjvNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","nje ba̰ kɨ nje dɨbe, e su; kagɨ lo kɨjə ko e dɔbəy ndɔ; ɓa njé kɨjə ko je əi malayka je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tə ka kɨ, e kɨ rə̰y-n jəne ɓuki poro, dɔbəy ndɔ a to be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","*Mi NGon dəw m-a m-ɨlə kɨ malayka je ləm kadɨ tuji dɨje pətɨ kɨ njé kɔsɨ madɨde je kadɨ osi me majal tɨ, kɨ dɨje kɨ njé ra majal. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","*Malayka je a ɓuki-de me por tɨ kɨ dum kəl tae, kɨ e lo kɨ a no̰i je a ngəi ngangɨde je tɨtɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lo kɨn tɨ, njé ra nḛ kɨ dana a unji tə kadɨ be me ɓeko̰ tɨ lə Bawde Luwə. Dəw kɨ aw kɨ mbine kadɨ oo-n dɔ ta ɓa, kadɨ oo dɔ ta kɨn majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Ko̰ɓe kɨ dɔra̰ tɨ to tə nḛ kɨngə kɨ ɓɔyɔi me ndɔr tɨ, ə dəw madɨ aw tḛḛ dɔ tɨ kɨn be. Dəw ka kɨn təl ɓɔyɔ gogɨ, ɓa rɔe nəl-e ngay, adɨ aw gatɨ kɨ nḛ majɨ je ləne pətɨ, ə ɨyə̰ lae re ndogɨ-n ndɔr ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ko̰ɓe kɨ dɔra̰ tɨ to tə nje ra gatɨ kɨ ɨsɨ sangɨ mədɨ-kɔsɨ kɨ ndole be. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lokɨ ɨngə e kɨ gate e ngay, təl aw gatɨ kɨ nḛ kɨngə je ləne pətɨ, ə ɨyə̰ lae re ndogɨ-n mədɨ-kɔsɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ko̰ɓe lə Luwə to tə bandɨ kɨ dəw a ɨlə me ba tɨ ə a ɔy dɔ kɔ kanjɨ je kɨ dangɨ dangɨ kam be. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lokɨ bandɨ ka kɨn rosɨ ɓa, nje ndo̰ ndɔr re-n ngangɨ ba tɨ, ɨsɨ nangɨ, nɨngə tɔr njé kɨ majɨ majɨ me sukɨm tɨ, ə ɨyə̰ njé kɨ tḛḛi nḛ al ɓukɨ-de kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kae tɨ ka kɨn ə, dɔbəy ndɔ a e be tɔ. *Malayka je a rəi kadɨ ɔri kəm dɨje kɨ njé ra nḛ je kɨ dana kɨ njé ra nḛ je kɨ dana al, naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","A ɓuki dɨje kɨ njé ra nḛ je kɨ majal me por tɨ kɨ dum kəl tae, kɨ e lo kɨ a no̰i je a ngəi ngangɨde je tɨtɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lo kɨn tɨ no̰o̰, Jəju dəjɨ njé ndo je ləne ə nə: «Ɨgəri me ta je kɨn pətɨ a?» Ə ɨləi-e tɨ əi nə: «Oyo, jɨ gər.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɨngə Jəju əl-de ə nə: «E be ə, nje ndo dɨje ndu-kun kɨ təl nje taa nḛ ndo kɨ dɔ ko̰ɓe tɨ lə Luwə, to tə ɓa nje kəy kɨ ɨngə nḛ je kɨ sɨgɨ kɨ nḛ je kɨ kɔke lo ngəm nḛ tɨ ləne kɨn be.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lokɨ Jəju əl kujɨ ta je gɨne gangɨ ɓa, ɔtɨ lo kɨ a tɨ kɨn kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɔtɨ no̰o̰, aw ɓe bo tɨ kɨ tɔgɨ tɨ. Jəju ndo nḛ dɨje gɨn kəy kaw-naa tɨ lə *Jɨpɨ je. NDo-de nḛ ndo kɨ ətɨ-de ɓəl, adɨ əli əi nə: «Gosɨ ta je kɨ nḛ kɔjɨ je kɨn ḭḭ-n ra ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ma ngon lə nje ragɨ kagɨ dɔ kəy tɨ wa ka am wa? Ko̰e al ə e Mari a? Ə Jakɨ je, kɨ Jɨsəpɨ je, kɨ Sɨmo̰ je kɨ Judɨ je tɔ al ə əi ngako̰e je a? ");
INSERT INTO bjvNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Taa, konane je ka ɨsi səje ne tɔ al a? NGa nḛ je kɨn pətɨ ɨngə ra dana?» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta kɨ dəji kɨn ɔgɨ-de kadɨ adi mede Jəju, ə Jəju əl-de ə nə: «NJe kəl ta kɨ ta Luwə tɨ ɓa, e me ɓe koje tɨ, kɨ me kəy tɨ lie ə dɨje a kɨdi-e tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lo kɨn tɨ, Jəju ra nḛ kɔjɨ je ngay al mbata mbati kadi-e mede. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dɔkagɨloe tɨ kɨn, *Erodɨ kɨ e nje ko̰ɓe dɔnangɨ tɨ kɨ Galile, oo ta tɔɓa lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ə əl njé ra kɨlə je ləne ə nə: «Dəw kɨn e Ja̰ Batɨsɨ! E e ə ḭ taa dan njé koy je tɨ. Gɨne kɨn ə, aw-n kɨ tɔgɨ mba ra-n nḛ je kɨ ətɨ ɓəl ɓəl.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erodɨ əl be, tadɔ ndɔ kɨ adɨ uwəi Ja̰, dɔɔi-e kɨ sən, ɨləi-e dangay tɨ, mbata lə Erodɨyadɨ, kɨ ne ngoko̰e Pɨlɨpɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kɨ Ja̰ əl-e ta dɔ tɨ ə nə: «E go tɨ al kadɨ ɨtaa-e nei tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Me ta tɨ kɨn, Erodɨ ndɨgɨ tɔl Ja̰, nə ɓəl kosɨ je, tadɔ kosɨ je ooi Ja̰ kadɨ e nje kəl ta kɨ ta Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","NGa ə, ndɔ rɔnəl kojɨ Erodɨ tɨ, ngon lə Erodɨyadɨ kɨ dəne, tḛḛ ndam no̰ dɨje tɨ kɨ ɓari-de lo nḛ kuso tɨ, ə nəl Erodɨ ngay, ");
INSERT INTO bjvNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","adɨ Erodɨ un ndune kɨ kɨbɨ rɔ kadɨ n-ade nḛ je pətɨ kɨ dəjɨ-ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lo kɨn tɨ, ko̰e sule, adɨ əl ə nə: «Adɨ-m, təkɨ j-a-n wa kɨn, dɔ Ja̰ Batɨsɨ me supɨra tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Me ngar tujɨ ɔjɨ-n dɔ nḛ kɨ ngon kɨ dəne dəje kɨn, nə kɨ mbata kun mɨndɨ kɨ un, taa kɨ mbata dɨje kɨ ɓar-de lo nḛ kuso tɨ kɨn tɔ ɓa, un ndune kadɨ adi-e dɔ Ja̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Be ə, adɨ dəw madɨ aw gangɨ dɔ Ja̰ kəy dangay tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","re-n me supɨra tɨ, adɨ ngon kɨ dəne ka kɨn, adɨ aw-n adɨ kone. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","*NJé ndo je lə Ja̰ rəi uni nɨne awi dɨbi, ɓa awi ɔri poye Jəju ade oo. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lokɨ Jəju oo ta kɨn ɓa, un to ə aw ɔsɨ rɔne ngərəngɨ kɨ karne ba, lo kɨ dɨje gotoi tɨ. Lokɨ kosɨ je ooi tae ɓa, ḭḭ kɨ ɓe bo je kɨ dangɨ dangɨ awi kɨ njade goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lokɨ Jəju ur nangɨ me to tɨ, oo kosɨ dɨje ngay. Lokɨ oo-de, oo kəm-to-ndoo ləde, adɨ ajɨ njé mo̰y je ləde. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lokɨ kadɨ aw tə ur ɓa, njé ndo je ɔti kɨ rɔ Jəju tɨ əli-e əi nə: «Lo kɨ j-ai tɨ ne kɨn, e lo kɨ dɨje gotoi tɨ, nɨngə kadɨ ɨsɨ ur tɔ ngata, ə ɨtuwə kosɨ dɨje kam adɨ awi kɨ ngan ɓe je tɨ, ndogi nḛ kuso usoi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nə Jəju əl-de ə nə: «Awi kɨ ndoo kadɨ awi lo al, səi je wa adi-de nḛ usoi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ə əli Jəju əi nə: «Kɨ j-a-n ne kɨn, j-aw kɨ mapa mi ə kanjɨ joo tɔ par.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ɓa Jəju əl-de ə nə: «Ɨrəi adi-mi m-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɨngə go tɨ, adɨ ndune kadɨ kosɨ dɨje ka kɨn ɨsi nangɨ dɔ wale je tɨ. Ɓa ɔy mapa kɨ mi kɨ kanjɨ kɨ joo ka kɨn, un kəmne kɨ taa, əl ta kɨ Luwə mba kadɨ njangɨ dɔe, nɨngə uwə gangɨ naa tɨ, adɨ njé ndo je, adɨ adi kosɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dɨje pətɨ usoi nḛ ndani majɨ, adɨ njé ndo je ɔyi gɨndɨ mapa je, kɨ kanjɨ je kɨ nay, kare dɔgɨ gɨde e joo ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dɨje kɨ usoi nḛ kɨn asi dɨngəm je dɨbɨ mi, kɨ kanjɨ tɨdə dəne je kɨ ngan je. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","NDə̰y ba go tɨ, Jəju ɔsɨ njé ndo je ləne kadɨ ali me to tɨ, awi gɨdɨ ba tɨ kəte no̰ne tɨ, dɔkagɨlo tɨ kɨ e a tuwə-n kosɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lokɨ Jəju tuwə-de adɨ awi nɨngə, ɔtɨ aw dɔ mbal tɨ, ɔsɨ rɔne kɨ karne, mba kəl ta kɨ Luwə. Lokɨ kadɨ ur, Jəju ɨsɨ loe tɨ no̰o̰ kɨ karne ba. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dɔ gangɨ loe tɨ kɨn, to lə njé ndo je e dan ba tɨ, sa̰y kɨ ngangɨ ba ngata. Nəl ɨlə, sur to kɨ gogɨ gogɨ, adɨ pungɨ ba ra-de majal. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dan lo tɨ ɓa, Jəju ḭ a njɨyə dɔ man tɨ, ɨsɨ aw kɨ rɔ njé ndo je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ə lokɨ njé ndo je ooi-e a njɨyə dɔ man tɨ nɨngə, dɔde majal, adɨ əli əi nə: «E muwə̰ dəw,» ɓa ɓəl tɔl-de, adɨ uri kɔl. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nə kalangɨ ba, Jəju əl-de ə nə: «Adi mesi osɨ nangɨ nə e mi, ə ɨɓəli al!» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lo kɨn tɨ, Pɨyər ɨlə Jəju tɨ ə nə: «Ɓaɓe, re e ḭ ə, adɨ-m ndui adɨ m-njɨyə dɔ man tɨ m-aw rɔi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ə Jəju əl-e ə nə: «Ɨre!» Ɓa Pɨyər ḭ me to tɨ, ur dɔ man tɨ, njɨyə dɔ tɨ ɨsɨ re kɨ rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nə lokɨ Pɨyər oo nəl kɨ ɨsɨ ɨlə ɓa, ɓəl ra-e adɨ ɨlə ngɨrə nduy man, adɨ no̰ ə nə: «Ɓaɓe, ajɨ-m!» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ə kalangɨ ba, Jəju ɨlə jine uwə-n Pɨyər, ɓa əl-e ə nə: «Ḭ dəw kɨ kadɨ-me ləi e ndɨkɨri ba, ra ban ə ɨɓadɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nɨngə lokɨ ali taa me to tɨ ɓa, gɨn nəl gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ə njé kɨ ɨsi me to tɨ ɔsi məkəsɨde nangɨ no̰e tɨ, ɓa əli-e əi nə: «Təkɨ rɔjetɨ, ḭ NGon lə Luwə wa!» ");
INSERT INTO bjvNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lokɨ Jəju əi kɨ njé ndo je ləne ɨndəi ba gangi nɨngə, tḛḛi dɔnangɨ Gənəjarətɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dɨje kɨ loe tɨ gəri Jəju, adɨ ɨləi kɨlə kɨ lo lo, dɔnangɨ kɨ Gənəjarətɨ tɨ ba pətɨ, ə dɨje rəi kɨ njé mo̰y je pətɨ rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dɨje no̰i dɔ Jəju tɨ kadɨ ɨyə̰ njé mo̰y je adɨ ɔdi ta kɨbɨ lie par ə a ɨngəi rɔ nga, ɓa dɨje pətɨ kɨ ɔdi ta kɨbɨ lie ɨngəi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","*Parɨsɨ je kɨ njé ndo ndu-kun je lə Luwə kɨ madɨ je ḭ Jorijaləm tɨ, rəi ɨngəi Jəju dəji-e əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«MBa ri ə njé ndo je ləi təli rɔde go nḛ jibəl ɓe tɨ lə kaje je al ə? Jɨ dəjɨ be tadɔ togi jide al par ə usoi nḛ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ə Jəju ɨlə-de tɨ ə nə: «NGa səi, mba ri ə ɨtəli rɔsi go ndu-kun tɨ lə Luwə al mbata nḛ jibəl ɓe ləsi ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Təkɨ rɔjetɨ, Luwə əl ə nə: “Ɔsɨ gon bawi kɨ ko̰i.” Taa əl ɓəy ə nə: “Dəw kɨ tajɨ bawne ə se kone asɨ ta koy.” ");
INSERT INTO bjvNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nə səi, əli əi nə: “Dəw kɨ əl bawne ə se kone ə nə: ‹Nḛ majɨ je kɨ re m-a m-ɔsɨ-n sɔli e kadɨ-kare kɨ m-ɨndə ta dangɨ mbata lə Luwə ngata,› ɓa, ");
INSERT INTO bjvNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","dəwe kɨn aw kɨ ndoo kadɨ ɔsɨ gon bawne al ngata. Lo kɨn tɨ, ɨsɨ tuji kɨ ta lə Luwə mbata nḛ jibəl ɓe ləsi.” ");
INSERT INTO bjvNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Səi njé kədɨ kəm dɨje, ta kɨ Luwə əl kɨ ta nje kəl ta kɨ tane tɨ Ejay dɔsi tɨ e ta kɨ rɔjetɨ. Luwə əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Gɨn dɨje kɨn ɔsi gonm kɨ nda tade kare, Nə mede e sa̰y səm. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tɔjɨ kɨ ɨsɨ ɨləi dɔm tɨ, ndae goto, Tadɔ nḛ ndo je kɨ ɨsɨ ndoi dɨje ka, E kəm-kədɨ kɨ ḭ rɔ dɨje tɨ tɔ.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Go tɨ, Jəju ɓar kosɨ dɨje kɨ rɔne tɨ, ə əl-de ə nə: «Uri mbisi majɨ oi ta ləm, ə kadɨ ɨgəri mee tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nḛ madɨ kɨ ḭ taga aw ta dəw tɨ kɨ a təl-e nḛ kɨ to njḛ tɨ ta kəm Luwə tɨ goto. Nə nḛ kɨ tḛḛ ta dəw tɨ ə a təl dəw kɨ nḛ kɨ to njḛ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lo kɨn tɨ, njé ndo je lə Jəju rəi rɔe tɨ əli-e əi nə: «Ta kɨ əl kɨn to me *Parɨsɨ je ngay, kɨn ɨgər ma?» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ə Jəju ɨlə-de tɨ ə nə: «Kagɨ kɨ ra kɨ Bai mə-e al, a ɔri-e kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɨyə̰i-de, əi njé kəm tɔ je kɨ ɨsɨ ndɔri njé kəm tɔ je. NGa nɨngə, re nje kəm tɔ ndɔr nje kəm tɔ ɓa, joo pu a osi me ɓe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ə Pɨyər un ta əl-e ə nə: «Ɔr me kujɨ ta kɨn adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ɓa Jəju əl ə nə: «Adɨ səi je wa ka ɨgəri nḛ al tɔ a? ");
INSERT INTO bjvNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Adɨ m-əl səsi, nḛ je pətɨ kɨ ɔdɨ ta dəw, a aw tḛḛ kandae tɨ, ɓa go tɨ ə, tḛḛ kɔ, aw ɓe sḭ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nə nḛ kɨ tḛḛ ta dəw tɨ, e nḛ kɨ ḭ nga̰me dəw tɨ, nɨngə e kɨn ə e nḛ kɨ nje təl dəw nḛ kɨ to njḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","NGa̰ me dəw ə e lo kɨ mər ta je kɨ majal ɨsɨ tḛḛ tɨ, kɨ tɔl-naa, kɨ kuwə marɨm, kɨ kaya kɨ ra, kɨ ɓogɨ, kɨ ma najɨ kɨ ngom, kɨ kəl ta kɨ majal dɔ-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Əi je kɨn ə əi nḛ je kɨ ɨsɨ təli dəw nḛ kɨ to njḛ tɨ; nə kuso nḛ, kɨ kanjɨ togɨ ji, a təl dəw nḛ kɨ to njḛ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jəju ḭ loe tɨ no̰o̰, ɔr rɔne aw dɔnangɨ tɨ kɨ Tɨr kɨ Sɨdo̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nɨngə yə, dəne kɨ Kana tɨ kare tḛḛ no̰o̰ re, ɓa un ndune kɨ taa əl ə nə: «Ɓaɓe, *NGon ka Dabɨdɨ, o kəm-to-ndoo ləm! tadɔ ndɨl kɨ majal adɨ ko̰ ngonm kɨ dəne ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nə Jəju ɨle ta tɨ al. Ɓa njé ndo je lie rəi rɔe tɨ, əli-e əi nə: «Ɨtuwe kɔ goje tɨ, tadɔ a ɨndə ndu goje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ə Jəju ɨlə tɨ ə nə: «E ngan *Isɨrayəl je, kɨ toi tə batɨ je kɨ nayḭ-naa be kam par ə Luwə ɨlə-m kɨ rɔde tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nə dəne re ɔsɨ məkəsɨne nangɨ no̰e tɨ ə nə: «Ɓaɓe, ɨre ɨra səm!» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ə Jəju ɨle tɨ ə nə: «E go tɨ al kadɨ dəw un nḛ kuso lə ngan je, ɨlə adɨ ngan bɨsɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ɓa dəne əl Jəju ə nə: «E rɔjetɨ Ɓaɓe, nga ke ə, ngan bɨsɨ je kɨ ai gɨn tabɨlə tɨ, a usoi yongɨrɔ nḛ je kɨ tḛḛ ta ɓade je tɨ tosɨ nangɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lo kɨn tɨ, Jəju əl-e ə nə: «Dəne, kadɨ-me ləi bo ngay! Nɨngə kadɨ ɨngə nḛ kɨ to rɔi kɨn, təkɨ ɨdəjɨ-n.» Ɓa ngone kɨ dəne ka kɨn, ɨngə rɔ nga dɔ kade tɨ wa kɨn no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jəju ɔtɨ loe tɨ no̰o̰, aw ta ba tɨ kɨ Galile. Al aw dɔ mbal tɨ, ɨsɨ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kosɨ dɨje ngay rəi rɔ Jəju tɨ kɨ njé mətɨ je, kɨ njé kəm tɔ je, kɨ njé kɨngə tujɨ je, kɨ njé mbi bəy je, taa njé mo̰y je kɨ rangɨ ngay no̰o̰ ɓəy. Rəi kɨ njé mo̰y je kɨn ɓuki-de no̰ Jəju tɨ, ɓa Jəju ajɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","E nḛ kɨ ətɨ kosɨ je ɓəl ngay, kadɨ njé mbi bəy je əli ta nɨm, njé kɨngə tujɨ je ɨngəi rɔ nga nɨm, njé mətɨ je njɨyəi nɨm, taa njé kəm tɔ je ka ooi lo nɨm tɔ, adɨ ɨləi tɔjɨ dɔ Luwə tɨ lə *Isɨrayəl je. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jəju ɓar njé ndo je ləne əl-de ə nə: «M-o kəm-to-ndoo lə kosɨ dɨje kɨn, tadɔ ndɔ mɨtə ɓone ə əi səm naa tɨ, nɨngə, nḛ kɨ kadɨ usoi goto. Ɓa m-ge kadɨ m-tuwə-de kɨ mede kɨ ɓo ba al, nə tə ɓo ḭ taa tɔgɨde rəbə.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ə njé ndo je lie dəji-e əi nə: «J-a j-ḭ kɨ mapa ra dɨlə lo tɨ ne, ə kosɨ dɨje kɨ ətɨ ɓəl be kɨn a usoi asɨ-de ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɓa Jəju dəjɨ-de ə nə: «Mapa kɨ jisi tɨ e ban ə?» Ə əli-e əi nə: «Mapa e sɨri kɨ ngan kanjɨ je ndə̰y dɔ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ə Jəju əl kosɨ dɨje kadɨ ɨsi nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɓa ɔy mapa kɨ sɨri kɨ ngan kanjɨ je ka kɨn jine tɨ, ra oyo Luwə dɔ tɨ, nɨngə gangɨ naa tɨ, adɨ njé ndo je ləne, adɨ adi kosɨ dɨje usoi. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dɨje pətɨ usoi nḛ ndani, adɨ njé ndo je kawi gɨnde je kɨ nay, kare sɨri. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dɨje kɨ usoi nḛ, asi dɨngəm je dɨbɨ sɔ, kɨ kanjɨ tɨdə dəne je kɨ ngan je. ");
INSERT INTO bjvNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Go tɨ, Jəju tuwə kosɨ je adɨ awi, ɓa al me to tɨ, aw dɔnangɨ Magada̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Parɨsɨ je kɨ *Sadusɨ je rəi rɔ Jəju tɨ, dəji-e kadɨ ra nḛ kɔjɨ kɨ ḭ dɔra̰ tɨ adɨ-de n-ooi. Dəji-e be tə kulə kɨ kɨyə mba kuwə-n dəw. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ə Jəju ɨlə-de tɨ ə nə: «Lokɨ kadɨ aw tə ur nɨngə əli əi nə: “Lo a to majɨ, mbata dɔra̰ kər jo̰.” ");
INSERT INTO bjvNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lokɨ lo ti kɨ sḭ ɓatɨ nɨngə, əli əi nə: “Ɓone ndi a ədɨ, mbata dɔra̰ kər wuu.” E be ə, asi kadɨ ɨgəri kəm nḛ je kɨ a rai nḛ dɔra̰ tɨ, nə nḛ je kɨ ɨsɨ rai nḛ dɔkagɨlo tɨ kɨ ɓone taa asi gər al! ");
INSERT INTO bjvNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Dɨje kɨ dɔkagɨlo tɨ kɨ ɓone, əi dɨje kɨ majal, kɨ njé kuwə marɨm, ndɨgi kadɨ n-ooi nḛ kɔjɨ, nə nḛ kɔjɨ madɨ kɨ rangɨ kɨ kadɨ a ooi ore dɔ nḛ kɔjɨ lə Jonasɨ, goto ngata.» Ɓa ɨyə̰-de, ə ɔtɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lokɨ ɨsɨ awi dam ba tɨ kɨ kare, me njé ndo je oy dɔ mapa tɨ kɨ kadɨ ɔyi. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","NGa nɨngə Jəju əl-de ə nə: «Oi majɨ! Ɨndəi kəm-kədɨ dɔ rɔsi tɨ, ɔjɨ-n dɔ əm lə *Parɨsɨ je, kɨ əm lə *Sadusɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nə əi je ɨsɨ məri ta kɨn yo dɔde tɨ əi nə: «E mbata kɔy kɨ j-ɔy mapa al!» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nə Jəju gər ta kɨ mede tɨ, adɨ əl-de ə nə: «Səi dɨje kɨ kadɨ-me ləsi e ndɨkɨri ba, mba ri ə ɨsɨ məri ta kɨ dɔ mapa tɨ kɨ ɔyi al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ɨgəri me nḛ je al ka ɓəy a? Mesi ole dɔ mapa tɨ kɨ mi kɨ dɨngəm je dɨbɨ mi usoi kɨn al a? NDɔ kɨ ɔyi ndəge kɨ nay kare ban ə ɨtəli ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Taa mapa kɨ sɨri kɨ dɨngəm je dɨbɨ sɔ usoi kɨn ka mesi ole dɔ tɨ al nɨm tɔ a? NDɔ kɨ ɔyi ndəge kɨ nay kare ban ə ɨtəli ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ta kɨ m-əl m-ə nə: Ɨndəi kəm-kədɨ dɔ rɔsi tɨ, ɔjɨ dɔ əm lə Parɨsɨ je, kɨ əm lə Sadusɨ je kɨn, e ta kɨ sɔbɨ dɔ mapa al, kɨn ra ban be ə asi kadɨ ɨgəri mee al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lo kɨn tɨ ngata ə gəri təkɨ əl-de kadɨ n-ɨndəi kəm-kədɨ dɔ rɔde tɨ, ɔjɨ dɔ əm ra mapa al, nə ɔjɨ dɔ nḛ ndo lə Parɨsɨ je kɨ Sadusɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lokɨ Jəju aw tḛḛ Səjare tɨ kɨ Pɨlɨpɨ tɨ, dəjɨ njé ndo je ləne ta ə nə: «Dɨje ɨsɨ əli ta kɨ dɔm tɨ təkɨ mi *NGon dəw mi na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ə njé ndo je əli-e əi nə: «Dɨje madɨ əli əi nə ḭ Ja̰ Batɨsɨ; njé kɨ nungɨ əi nə ḭ nje kəl ta kɨ ta Luwə tɨ Eli; njé kɨ rangɨ ɓəy əi nə ḭ nje kəl ta kɨ ta Luwə tɨ Jərəmi al ə kɨ kare dan njé kəl ta je tɨ kɨ ta Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lo kɨn tɨ, Jəju əl-de ə nə: «NGa səi je wa kɨ dɔsi, əli əi nə mi na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ə Sɨmo̰ Pɨyər ɨle tɨ ə nə: «Ḭ Kɨrɨsɨ, kɨ Luwə mbəte, NGon lə Luwə kɨ nje kɨsɨ kəm ba!» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ɓa Jəju əl Sɨmo̰ ə nə: «Ḭ nje majɨ-kur, Sɨmo̰ kɨ ngon Jonasɨ, tadɔ e dəw ɓa tḛḛ kɨ dɔ nḛ kɨn adi ɨgər al, nə e Bai kɨ nje kɨsɨ me dɔra̰ tɨ taa ə tḛḛ kɨ dɔe adi. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","NGa nɨngə m-a m-əli m-ə nə ḭ Pɨyər (kɨ kɔr mee nə MBal), nɨngə dɔ mbal tɨ kɨn ə m-a m-ɨndə ngɨrə njé kaw-naa je ləm dɔ tɨ. Tɔgɨ koy a ra sie nḛ madɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","M-a m-adi lakəle ko̰ɓe kɨ dɔra̰ tɨ. Nɨngə nḛ je pətɨ kɨ a dɔɔ dɔnangɨ tɨ ne, a dɔɔi dɔra̰ tɨ tɔ, ə nḛ je pətɨ kɨ a tutɨ dɔnangɨ tɨ ne, a tuti dɔra̰ tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ɓa ndəjɨ njé ndo je kɨ tɔgɨne təkɨ ke n-e Kɨrɨsɨ kɨ Luwə mbəte kɨn, kadɨ əli tae dəw madɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ḭ dɔkagɨloe tɨ no̰o̰, Jəju ɨlə ngɨrə tɔjɨ njé ndo je adɨ gəri təkɨ, sɔbɨ kadɨ n-aw Jorijaləm, n-ɨngə ko̰ ngay ji ngatɔgɨ je tɨ lə *Jɨpɨ je, kɨ kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je. A tɔli-ne, nə ndɔ kɨ ko̰ mɨtə lə ndɔ koyne ɓa, n-a n-tḛḛ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nə dɔ ta tɨ kɨn, Pɨyər ɔr Jəju aw sie dəbɨ kare, nɨngə ɨlə ngɨrə kɔl sie ə nə: «Ɓaɓe! Luwə a ngəm-i, nḛ kɨn a rai al!» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nə Jəju təl rɔne, əl Pɨyər ə nə: «Ɨtəl gogɨ *Sata̰, ɔr rɔi kɔ gom tɨ! Ḭ jɨgɨ kɨ nje tɨgə-m, tadɔ mər ta ləi e mər ta kɨ ḭ rɔ Luwə tɨ al, nə e mər ta lə dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nɨngə go tɨ, Jəju əl njé ndo je ləne ə nə: «Re dəw madɨ ndɨgɨ njɨyə gom tɨ nɨngə, kadɨ oo rɔne tə nḛ madɨ al, kadɨ e wa un kagɨ-dəsɨ koy ləne, ə re un gom. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Təkɨ rɔjetɨ, dəw kɨ ge kajɨ rɔne ne wa dɔnangɨ tɨ ne a tḭ ta rɔne. Nə dəw kɨ tḭ ta rɔne kɨ mbata ləm, a ɨsɨ kɨ dɔne taa gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kɨn ə re dəw ɨngə nḛ majɨ je kɨ dɔnangɨ tɨ ne pətɨ tɨgə, nə ndɨle tujɨ ə, maje to ra be ə? Nḛ madɨ kɨ dəw a adɨ ɔr-n to ndɨlne to no̰o̰ a? ");
INSERT INTO bjvNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mi *NGon dəw m-a m-re kɨ malayka je ləm me tɔɓa lə Bai Luwə, nɨngə m-a m-ɨgə dəw kɨ ra go jie kɨ go kɨlə rae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Təkɨ rɔjetɨ, adɨ m-əl səsi: dɨje madɨ dansi tɨ ne a oyi al ɓəy ə, a ooi-mi NGon dəw kɨ m-a m-re tə NGar kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","NDɔ mehḛ go tɨ nɨngə, Jəju ɔr Pɨyər nɨm, Jakɨ nɨm, taa Ja̰ kɨ ngoko̰ Jakɨ nɨm tɔ, ə aw səde dɔ mbal tɨ kɨ ngal, sa̰y kɨ ndəge je. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Loe tɨ no̰o̰, Jəju mbəl rɔne ta kəmde tɨ. Ta kəme unjɨ tə kadɨ be, taa kɨbɨ kɨ rɔe tɨ ka unjɨ tə kadɨ be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nɨngə loe tɨ no̰o̰, *Mojɨ əi kɨ Eli tḛḛi kɨ rɔde tɨ hɔy, a əli ta kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ə Pɨyər un ta əl Jəju ə nə: «Ɓaɓe, kɨn ə j-ɨsi lo kɨn tɨ ne be par ə majɨ ngay. Re ɨge ə, m-a m-ra kəy-lo mɨtə: kare e ya̰i, kare e ya̰ Mojɨ, ə kɨ kare e ya̰ Eli tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lokɨ Pɨyər a əl ta tane tɨ ba ɓəy nɨngə yə, kɨl ndi kɨ kunje to, ḭ səbɨ dɔde lɨtɨ. Ɓa ndu ta madɨ tḛḛ me kɨl ndi tɨ ə nə: «E kam e NGonm kɨ m-ndɨge ngay, e kɨ nəl-m ngay kadɨ m-kɔte, ə oi ta lie.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lokɨ njé ndo je ooi dɔ ta kɨn ɓa, osi kɨ ta kəmde nangɨ, ɓəl tɔl-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ə Jəju re rɔde tɨ, ɔdɨ-de ə əl-de ə nə: «Ḭ taa, ə adi ɓəl ra səsi al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","NGa nɨngə, lokɨ əi nə n-uni kəmde kɨ taa ɓa, ooi dəw madɨ kɨ rangɨ al, ooi Jəju kɨ karne ba par. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lokɨ ḭḭ dɔ mbal tɨ ɨsɨ uri kɨ nangɨ, Jəju ɨndə ndu kɨn no̰de tɨ ə nə: «Əli nḛ kɨ ra nḛ adɨ oi kɨn dəw madɨ al, bɨtɨ kadɨ mi *NGon dəw m-tḛḛ dan njé koy je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Go tɨ, njé ndo je dəji-e əi nə: «MBari wa bangɨ ə, njé ndo ndu-kun je əi nə sɔbɨ kadɨ Eli re kəte taa ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ə ɨlə-de tɨ ə nə: «E kɨ rɔjetɨ kadɨ Eli a re kadɨ ra go nḛ je pətɨ adɨ asɨ-naa gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nɨngə mi, adɨ m-əl səsi madɨ oi, Eli re ngata, nə dɨje gəri al, adɨ rai sie nḛ kɨ mede ge. Be tɔ ə, mi NGon dəw ka m-a m-ɨngə-n ko̰ jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lo kɨn tɨ, njé ndo je gəri kadɨ ta kɨ Jəju əl-de kɨn sɔbɨ dɔ Ja̰ Batɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lokɨ təli ɨsɨ rəi kɨ rɔ kosɨ dɨje tɨ, dɨngəm madɨ kare re rɔ Jəju tɨ, ɔsɨ məkəsɨne nangɨ no̰e tɨ, əl-e ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Ɓaɓe, o kəm-to-ndoo lə ngonm kɨ dɨngəm, kɨ damsɨl ra-e adɨ ɨngə ko̰ ngay kɨn. Taa taa, ɨsɨ tosɨ kɨ poro je, kɨ me man tɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","M-re sie rɔ njé ndo je ləi, nə asi kadɨ adi-e ɨngə rɔ nga, al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lo kɨn tɨ, Jəju un ta əl ə nə: «Səi dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨ səi njé me nga̰ je, səi njé ra nḛ kɨ majal, kadɨ tə m-ɨsɨ səsi dɔkagɨlo ban ɓəy taa adi mesi ə? Kadɨ m-a m-ɔsɨ gɨnsi dɔkagɨlo ban ɓəy taa ə? Ɨrəi kɨ ngon rɔm tɨ ne.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ɓa Jəju ndangɨ ndɨl kɨ majal ade tḛḛ rɔ ngon tɨ, par ə ta naa tɨ no̰o̰, ngon ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go tɨ, njé ndo je rəi rɔ Jəju tɨ, lokɨ əi sie kɨ karde ba, dəji-e əi nə: «MBari ə je j-asɨ kadɨ jɨ tuwə ndɨl kɨ majal kɨn al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ə Jəju ɨlə-de tɨ ə nə: «Asi al, mbata kadɨ-me ləsi e ndɨkɨri ba. Nɨngə kadɨ m-əl səsi təkɨ rɔjetɨ, re awi kɨ kadɨ-me kɨ e ndɨkɨri ba tə ka̰ kagɨ kɨ ɓari-e mutadɨ kɨn be mɨndɨ ka, a əli mbal kam əi nə: “Ɔtɨ, aw a nu be” ə, a ɔtɨ kadɨ aw a. Nḛ kɨ a dum dɔsi goto.  ");
INSERT INTO bjvNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Taa ko ndɨl je kɨ be kɨn, dəw a tuwə-de kɨ takul kəl ta kɨ Luwə kɨ kɔgɨ rɔ nḛ kuso par.» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","NDɔ kare njé ndo ɨsi naa tɨ pətɨ Galile tɨ, ə Jəju əl-de ə nə: «A ɨləi-mi *NGon dəw ji dɨje tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kadɨ a tɔli-mi, nə ndɔ kɨ ko̰ mɨtə lə ndɔ koym ə, m-a m-ḭ taa lo koy tɨ.» Ta kɨn ɔr tɔgɨ njé ndo je ə təl ɔr ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lokɨ Jəju əi kɨ njé ndo je rəi tḛḛi Kapərnayɨm tɨ, njé kɨ ɨsɨ taai la-mbə me kəy tɨ lə Luwə rəi rɔ Pɨyər tɨ dəji-e əi nə: «NJe ndo səsi nḛ ɨgə la-mbə kɨ me kəy tɨ lə Luwə al a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ə Pɨyər ɨlə-de tɨ ə nə: «Oyo, ɨgə la-mbə.» Nɨngə lokɨ Pɨyər re tḛḛ ɓe ɓa, Jəju un ta kəte əl-e ə nə: «Mər ta ləi e ri ə Sɨmo̰? Na̰ je ə əi njé kɨgə la-mbə je kɨ njé kɨgə nḛ kɨ ngar je kɨ dɔnangɨ tɨ ne gangi dɔ dɨje tɨ ə? E ngan njé ɓe je ə se e mba je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ə Pɨyər əl-e ə nə: «E mba je.» Lokɨ ə nə: «MBa je», Jəju ə nə: «Re e be ə, ngan njé ɓe je, ai kare ən. ");
INSERT INTO bjvNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nə re e be ka, kadɨ je jɨ təl jɨgɨ tɨgə dɨje kam al, ə aw baa, ɨlə kuy, uwə-n kanjɨ kɨ dɔsa̰y kɨ a re un kuy, nɨngə ɨtḛḛ tae, ɓa a ɨngə sɨlə kare mbɔe tɨ, kadɨ ɨgə-n la-mbə ləi tɔ, ya̰m tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dɔ kade tɨ wa kɨn, njé ndo je rəi dəji Jəju əi nə: «Na̰ ə e kɨ bo me ɓeko̰ tɨ lə Luwə ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ə Jəju ɓar ngon kɨ du ade re a dande tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nɨngə əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, re ɨtəli ɨtoi tə ngan je kɨ du be al ə, a uri me ko̰ɓe tɨ lə Luwə al jagɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Dəw kɨ sɔl dɔne lɔm lɔm tə ngon be ə, dəwe kɨn a e kɨ bo ngay me ɓeko̰ tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Re dəw uwə ngon kɨ be kɨn rɔne tɨ, me tɔm tɨ ə, e mi wa ə dəwe kɨn uwə-m rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Kɨn ə təkɨ dəw madɨ ra adɨ kɨ kare dan njé kɨ du tɨ kɨ adi-mi mede, osɨ me majal tɨ ə, e sotɨ ngay ɓəy mbata tɨ lie kadɨ dɔɔi mbal kɨ bo ngay mɨnde tɨ, ə ɔsi-e, ɨləi-e ɓul ba tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kəm-to-ndoo kɨ dɔ dɨje tɨ kɨ dɔnangɨ tɨ kɨ njé re kɨ nḛ je kɨ ɨsɨ tɨgəi madɨde je jɨgɨ tɨ adɨ osi. Təkɨ rɔjetɨ, sɔbɨ kadɨ nḛ je kɨ njé tɨgə dɨje jɨgɨ tɨ toi, nə kəm-to-ndoo e lə dəw kɨ nje ra kadɨ dəw osɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kɨn ə jii, ə se njai rai-ni adɨ osɨ me majal tɨ ə, ɨgangɨ-de ɨlə-de kɔ sa̰y. Tadɔ, e sotɨ ngay kadɨ ɨngə kajɨ kɨ jii kɨ kare, ə se kɨ njai kare wa, ɨtə kadɨ ɨngəm jii je joo pu, ə se njai je joo pu wa, ə ɨləi-ni me por tɨ kɨ gɨne a gangɨ al kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kɨn ə kəmi kare rai adɨ osɨ majal tɨ ə, ɔr-e ɨle kɔ sa̰y. Tadɔ, e sotɨ kadɨ ɨngə kajɨ kɨ kəmi kɨ kare, ɨtə kadɨ ɨngəm ka̰ kəmi je joo pu, ə ɨləi-ni me dɨlə por tɨ lə su. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Oi majɨ! Kadɨ ɨkɨdi kɨ kare dan ngan je tɨ kɨn al, tadɔ, təkɨ rɔjetɨ, malayka je ləde ɨsi kɨ dɔkagɨlo je pətɨ, ta kəm Bai tɨ kɨ ɨsɨ dɔra̰ tɨ taa.  ");
INSERT INTO bjvNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","MBata mi *NGon dəw m-re mba kajɨ dɨje kɨ tade tḭ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Dəw madɨ aw kɨ batɨ je ɓu, ə e kɨ kare nay nɨngə, ɨyə̰ ndəge je kɨ dɔ jikare gɨde jikare dɔ wale tɨ, ə aw sangɨ e kɨ nay ka kɨn. Ə se kɨ go koe tɨ ləsi, ta ri ə a əli dɔ lo kɨn tɨ wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Təkɨ rɔjetɨ, adɨ m-əl səsi, re ɨngə batɨ kɨ nay kɨn ə, rɔe a nəl-e ngay dɔe tɨ ɨtə njé kɨ dɔ jikare gɨde jikare kɨ nayḭ-naa al kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Be tɔ ə, Bawsi kɨ ɨsɨ me dɔra̰ tɨ, ge kadɨ kɨ kare ka tae tḭ dan ngan je tɨ kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Lokɨ ngoko̰i ra majal ə, aw ɨnge, səi sie joo ba, ɓa ɨlə ji dɔ majal tɨ lie kɨ ra, ade gər. Re oo ta ləi ɓa, ḭ ɨngə ngoko̰i gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A re oo ta ləi al ɓa, aw un dəw kɨ rangɨ kare, ə se dɨje joo wa səi, aw ɨnge-n ɓəy. Ɨra be mba kadɨ “nḛ je pətɨ e kɨ kun-ndu dɔ tɨ kɨ go ta tɨ lə dɨje joo ə se mɨtə kɨ kadɨ mai naje.” ");
INSERT INTO bjvNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɨn ə re mbatɨ koo ta ləde ə, əl njé kaw-naa je. Ə re mbatɨ koo ta lə njé kaw-naa je ɓəy tɔ nɨngə, kadɨ o-e tə dəw kɨ gər Luwə al, ə se tə nje taa la-mbə be. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Təkɨ rɔjetɨ, adɨ m-əl səsi: nḛ je pətɨ kɨ a dɔɔi dɔnangɨ tɨ ne, a dɔɔi dɔra̰ tɨ tɔ, ə nḛ je pətɨ kɨ a tutɨ dɔnangɨ tɨ ne, a tuti dɔra̰ tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Təkɨ rɔjetɨ, m-əl səsi m-adɨ ɨgəri ɓəy təkɨ re dɨje joo dansi tɨ, ɨndəi ndude naa tɨ dɔnangɨ tɨ ne, kadɨ dəji nḛ ri kɨ uwə mede ə, Bai kɨ ɨsɨ me dɔra̰ tɨ a adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tadɔ lo kɨ dɨje joo ə se mɨtə kawi-naa tɨ, me tɔm tɨ ə, mi dande tɨ no̰o̰.» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lo kɨn tɨ, Pɨyər ɔtɨ kɨ rɔ Jəju tɨ dəje ə nə: «Ɓaɓe, kɨn ə ngokom ra səm majal ə, kadɨ m-ɨyə̰ go kɔ nja ban m-ade ə? Kadɨ m-ɨyə̰ go kɔ bɨtɨ nja sɨri a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ə Jəju əl-e ə nə: «M-əl m-ə nə bɨtɨ nja sɨri al, nə bɨtɨ nja dɔsɨri nja sɨri. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«E be ə, ko̰ɓe lə Luwə to tə ta kɨn be. NDɔ kare ngar madɨ ge kadɨ njé ra kɨlə je ləne ɨdəi kɔr nḛ je ləne no̰ne tɨ adɨ n-oo. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ə ɨlə ngɨre, adɨ rəi kɨ e kɨ kadɨ a ade la kɨ dum kɨdə kɔre. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nə dɨngəm ka kɨn aw kɨ nḛ kɨ kadɨ ɨgə-n kɨrə kɨn al, adɨ ɓae un ndune kadɨ gati sie kɨ nee, kɨ ngane je, kɨ nḛ majɨ je lie ba pətɨ to kɨrə tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ə nje ra kɨlə osɨ nangɨ no̰ ɓane tɨ, no̰ uwə njae ə nə: “Ɨsɨ səm dɔ tɨ, ə m-a m-ɨgə-i kɨrə kɨn pətɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","NGa ə, lo kɨn tɨ, ɓae oo kəm-to-ndoo lie, adɨ ɨyə̰ kɨrə kɨ dɔe tɨ kɨn kɔ, ə ɨyḛ adɨ aw kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Lokɨ dəw kɨ kɨrə e dɔe tɨ ka kɨn ə nə n-tḛḛ kɨ taga ɓa, ɨngə madɨ-kɨlə lie kare kɨ e, aw kɨ kɨrə ləne kɨ ndə̰y be par dɔe tɨ, ə osɨ sie uwe, səngɨrə mɨnde, nɨngə əl-e ə nə: “Ɨgə-m kɨrə kɨ dɔi tɨ!” ");
INSERT INTO bjvNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ə made osɨ nangɨ no̰e tɨ, no̰ dɔe tɨ ə nə: “Ɨsɨ səm dɔ tɨ, ə m-a m-ɨgə-i kɨrə kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nə mbatɨ, adɨ aw sie bɨtɨ ɨle dangay tɨ, ngɨnə-n ta kɨrə kɨ kadɨ ɨgə-ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lokɨ madɨ kɨle je ooi nḛ kɨ ra kɨn ɓa, to rɔde ngay adɨ awi ɔri poy nḛ je kɨn pətɨ ɓade adi-e oo. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ə ngar ɓar-e ade re, ɓa əl-e ə nə: “Ḭ nje ra kɨlə kɨ majal, m-ɨyə̰ go kɨrə kɨ dɔi tɨ pətɨ kɔ mbata no̰ kɨ ɨno̰ dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","NGa ḭ, ri ə ɔgi kadɨ o kəm-to-ndoo lə madi təkɨ mi m-o-n kəm-to-ndoo ləi kɨn be tɔ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lo kɨn tɨ, wongɨ ra ɓae dɔe tɨ ngay, adɨ ɨlə sie dangay tɨ, lo ra kɨlə tɨ kɨ ko̰, bɨtɨ kadɨ ɨgə-n kɨrə kɨ dɔne tɨ pətɨ tɨgə. ");
INSERT INTO bjvNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nɨngə Jəju ɨlə dɔ tɨ ə nə: E be tɔ ə, Bai kɨ ɨsɨ me dɔra̰ tɨ taa, a ra-n səsi, lokɨ dəw madɨ dansi tɨ, ɨyə̰ go majal kɔ kɨyə̰ kɨ ḭ nga̰me tɨ adɨ ngokone, al.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lokɨ Jəju tɔl ta ta je ɓa, ɔtɨ Galile tɨ, aw dɔnangɨ Jude tɨ, gɨdɨ ba Jurdḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kosɨ dɨje ngay uni goe, adɨ ajɨ-de dɔ mo̰y je tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Parɨsɨ je ɔti rəi rɔ Jəju tɨ, dəji-e ta tə kulə kɨ kɨyə mba kuwə-n dəw əi nə: «NDu-kun adɨ ta rəbɨ kadɨ dɨngəm tuwə-n nene, ɔjɨ dɔ nḛ kɨ ra kɨ ra adɨ nəl-e al ə se adɨ ta rəbɨ al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ə Jəju ɨlə-de tɨ ə nə: «Ɨtɨdəi ndu Luwə kɨ ndangi kɨn al bɨtɨ a? NDu Luwə əl ə nə: “Lo kɨlə ngɨrə kɨndə nḛ je tɨ, NJe kɨndə nḛ je ra dɨngəm əi kɨ dəne, ");
INSERT INTO bjvNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nɨngə əl ə nə: E be ə, dɨngəm a ɨyə̰ kone je kɨ bawne je, ə a tɨyə̰i-naa kɨ nene, kadɨ təli darɔ kɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lo kɨn tɨ, a əi joo al ngata, nə əi darɔ kɨ kare ba. Nɨngə nḛ kɨ Luwə dɔɔ naa tɨ, majɨ kadɨ dəw gangɨ naa tɨ al.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓa əli Jəju əi nə: «NGa ra ban be ə *Mojɨ adɨ ndu ə nə re dɨngəm tuwə nene ɓa majɨ kadɨ ade makɨtɨbɨ gangɨ-naa jie tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ə Jəju təl əl-de ə nə: «E kɨ mbata me nga̰ ləsi ə Mojɨ adɨ-n səsi ta rəbɨ kadɨ ɨtuwəi nesi je, nə lo kɨlə ngɨrə nḛ je tɨ, e be al. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","NGa nɨngə, adɨ m-əl səsi, re dəw tuwə nene, mbata nḛ kɨ rangɨ, ɓɨ e ta lə kaya kɨ ra, al, ə taa dəne kɨ rangɨ ə, dəwe kɨn təl nje kuwə marɨm.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lo kɨn tɨ, njé ndo je əli-e əi nə: «Re e kɨn ə e ndu kɨ to dɔ dɨngəm tɨ kɨ rɔ dəne tɨ ə, taa dəne al e sotɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ə Jəju əl-de ə nə: «Dɨje pətɨ gəri me ta kɨn al, nə njé kɨ Luwə adɨ-de ta rəbe par. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Dɨje madɨ əi no̰o̰, taai dəne al, mbata tɔgɨde sangɨ dəne goto, nɨngə e nḛ kɨ tḛḛi me ko̰de tɨ nu; njé kɨ madɨ je e mbata kɔr kɨ ɔri-de kujɨ, ə njé kɨ nungɨ, mbati taa dəne mbata ko̰ɓe lə Luwə tɔ. Dəw kɨ asɨ kadɨ gər me ta kɨn ɓa kadɨ gər.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dɨje rəi kɨ ngan je kɨ du rɔ Jəju tɨ kadɨ njangɨ dɔde, ə əl ta kɨ Luwə kɨ mbata tɨ ləde, nə njé ndo je kɔli səde. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ə Jəju əl ə nə: «Ɨyə̰i ngan je du adi-de rəi kɨ rɔm tɨ, ɓɨ ɔgi-de ta rəbɨ al, tadɔ ko̰ɓe kɨ dɔra̰ tɨ e ya̰ dɨje kɨ toi tə ngan je kɨ du be.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Go tɨ, Jəju njangɨ dɔde, ɓa ɔtɨ ɨlə dɔne aw lo kɨ rangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","NDɔ kare, ngon kɨ basa kare re rɔ Jəju tɨ, nɨngə dəje ə nə: «NJe ndo dɨje, e ri kɨ majɨ, ə kadɨ m-ra, ə m-a m-ɨngə-n kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ə Jəju əl-e ə nə: «MBa ri ə ɨdəjɨ-m ta dɔ nḛ kɨ majɨ tɨ ə? Dəw kɨ majɨ e kare ba. Re ɨge kadɨ ɨngə kajɨ ɓa, ɨtəl rɔi go ndu-kun je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ə ngon kɨ basa ka kɨn dəjɨ Jəju ə nə: «NDu-kun je kɨ ra ə?» Ɓa Jəju ɨle tɨ ə nə: «A tɔl dəw al, a uwə marɨm al, a ɓogɨ al, a ma najɨ kɨ ngom dɔ madi tɨ al, ");
INSERT INTO bjvNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɔsɨ gon bawi əi kɨ ko̰i, taa a ndɨgɨ dəw madi tə darɔi ḭ wa be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɨngə ngon basa ə nə: «Nḛ je kɨn pətɨ, m-təl rɔm go tɨ. NGa kɨ ne kɨn, e ri ɓəy ə nay-m kadɨ m-ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ə Jəju əl-e ə nə: «Re ɨge kadɨ asɨ-naa tapɨ ta kəm Luwə tɨ ɓa, aw, ɨgatɨ kɨ nḛ majɨ je ləi pətɨ, adɨ lae njé ndoo je, ɓa a aw kɨ nḛ kɨngə ngay me dɔra̰ tɨ, ə ɨre un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nə lokɨ ngon basa oo ta je kɨn ɓa, ɔtɨ aw kɨ rɔnəl al, tadɔ e dəw kɨ aw kɨ nḛ kɨngə ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ə Jəju əl njé ndo je ləne ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, a nga̰ ngay kɨ rɔ nje nḛ kɨngə tɨ kadɨ ur me ɓeko̰ tɨ kɨ dɔra̰ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","nɨngə m-təl m-əl səsi ɓəy, e nḛ kɨ nga̰ ngay kadɨ jambal kɨ oi-e kɨn ur bole kon ku nḛ tɨ, nə a nga̰ ngay ɨtə e kɨn ɓəy kadɨ nje nḛ kɨngə ur me ɓeko̰ tɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta kɨn ətɨ njé ndo je ɓəl ngay, adɨ əli əi nə: «NGa kɨn ə e be nɨngə, na wa bangɨ ə asɨ kadɨ ɨngə kajɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ə Jəju ɨndə manjɨde ba nɨngə əl-de ə nə: «Kɨ rɔ dɨje tɨ ɓa, dəw kɨ asɨ goto, nə Luwə ɓa, asɨ ra nḛ je pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ə Pɨyər un ta əl-e ə nə: «NGa o je kɨ, j-ɨyə̰ nḛ je ləje pətɨ kɔ, ə j-un goi kɨn, ri ə j-a j-ɨngə ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ə Jəju ɨle tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi: ndɔ kɨ nḛ je pətɨ a ɨndəi ngɨrəde kɨndə kɨ sɨgɨ, ə mi *NGon dəw m-a m-ɨsɨ dɔ kɨmbər ko̰ɓe tɨ ləm, kɨ dɨje a ɨləi tɔjɨ dɔm tɨ kɨn ɓa, səi kɨ uni gom kɨn, səi ka a ɨsi dɔ kɨmbər ko̰ɓe tɨ kɨ dɔgɨ gɨde joo kadɨ ɨgangi ta dɔ gɨn ka *Isɨrayəl tɨ kɨ dɔgɨ gɨde joo. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nɨngə re dəw madɨ, ɨyə̰ kəy ləne, kɨ ngakone je, kɨ konane je, kɨ kone, kɨ bawne, kɨ ngane je ə se dɔnangɨ ləne kɨ mbata ləm ə, a ɨngə nḛ je kɨ al dɔ e kɨn, taa a ɨngə kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ tɔ, tə nḛ kɨ sɔbɨ dɔne. ");
INSERT INTO bjvNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","NGa nɨngə, dɨje ngay kɨ kəte, a təli njé kɨ gogɨ, ə njé kɨ gogɨ, a təli njé kɨ kəte tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Ko̰ɓe lə Luwə to tə ɓa njé ndɔr nju, kɨ tḛḛ kɨ sḭ ɓatɨ ba kadɨ n-ɔy njé ra kɨlə je kadɨ rai kɨlə me ndɔr nju tɨ ləne kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","NDude osɨ naa tɨ kɨ njé ra kɨlə je, kadɨ adɨ-de la kɨ lo ra kɨlə tɨ kɨ ndɔ kare, ɓa adɨ-de awi me ndɔr nju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Lokɨ tḛḛ kɨ kadɨ kɨ jikare nɨngə, oo njé ra kɨlə je kɨ rangɨ ɓəy, kɨ rəi ai ta mbalo tɨ kɨ kanjɨ ra kɨlə, ");
INSERT INTO bjvNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ə əl-de ə nə: “Səi ka, awi me ndu tɨ ləm ɨrai kɨlə, ə m-a m-adɨ səsi nḛ kɨgə go ji kɨ asɨ go rəbe tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓa ɔti awi. Lokɨ tḛḛ taga kɨ kadɨ kɨ jam dɔ ɓe tɨ nɨm, kɨ kadɨ kɨ mbɔ ɓe tɨ nɨm ɓa, ra kae tɨ ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Go tɨ, tḛḛ re kɨ kadɨ kɨ kadɨ ra bɨyə̰ bɨlə nɨngə, oo njé ra kɨlə je kɨ rangɨ ɓəy, kɨ rəi ai no̰o̰, ə əl-de ə nə: “Ra ban ə ɨsi lo kɨn tɨ lo sɔl, kɨ kanjɨ ra kɨlə ə?” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ə ɨləi-e tɨ əi nə: “Dəw kɨ un-je kɨlə tɨ goto.” Ə əl-de ə nə: “Səi ka, awi me ndu tɨ ləm ɨrai kɨlə tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Lokɨ kadɨ ur nɨngə, ɓa nje ndɔr nju əl nje ngəm nḛ lie kare ə nə: “Ɨɓar njé ra kɨlə je, ə adɨ-de nḛ kɨgə go jide, ɨlə ngɨre dɔ njé re gogɨ tɨ, ɨtɔl tae dɔ njé re kəte tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","NJé re kɨ kadɨ ra bɨyə̰ bɨlə, na̰ na̰ ka ɨngə la kɨ lo kɨlə tɨ kɨ ndɔ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lo kɨn tɨ, njé re dɔ kəte rəi ya̰de ngata ɓa, məri kadɨ n-a n-ɨngəi la kɨ ɨtə ya̰ madɨde je, nə əi ka, ɨngəi la kɨ lo kɨlə tɨ kɨ ndɔ kare wa ka kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lokɨ ɨsɨ taai la kɨn, ɓai ta kɨ nje ndɔr ");
INSERT INTO bjvNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","əli əi nə: “NJé kɨ rəi gogɨ ne kɨn, rai kɨlə kadɨ-kare ba par, nɨngə ḭ adɨ-de la kɨ asɨ-naa kɨ ya̰je, je kɨ jɨ ra kɨlə sḭ bɨtɨ j-ɨlə kadɨ, adɨ kadɨ ndabɨ-je.” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lo kɨn tɨ, nje ndɔr əl ta kɨ kare dande tɨ ə nə: “Madɨm, nḛ madɨ kare kɨ majal kɨ m-ra səi go. NDuje səi osɨ naa tɨ dɔ la tɨ kɨ lo kɨlə tɨ kɨ ndɔ kare al ma? ");
INSERT INTO bjvNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ɨtaa nḛ ləi, ə aw. M-ge kadɨ m-adɨ e kɨ re gogɨ ne kɨn, təkɨ m-adi kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E ta ləm mi wa kadɨ nḛ kɨ mem ndɨgɨ ə m-ra kɨ nḛ kɨngə ləm al a? Ə se e ta ləi kadɨ mei o̰i mbata majɨ kɨ m-ra a?” ");
INSERT INTO bjvNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","NGa nɨngə Jəju ɨlə tɨ ə nə: E be ə, njé kɨ gogɨ a təlii njé kɨ kəte, ə njé kɨ kəte a təlii njé kɨ gogɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta kaw kɨ Jorijaləm tɨ, lokɨ əi dɔ rəbɨ tɨ, Jəju ɨjə rɔne kɨ njé ndo je kɨ dɔgɨ gɨde e joo dəbɨ kare, nɨngə əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Oi, j-ɨsɨ j-awi kɨ Jorijaləm tɨ, nɨngə a ɨləi-mi *NGon dəw ji njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ kɨ njé ndo ndu-kun je. A gangi ta koy dɔm tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nɨngə a ɨləi-mi ji dɨje tɨ kɨ əi *Jɨpɨ je al, kadɨ kogi dɔm tɨ je, tɨndəi-mi kɨ ndəy kabɨlay je, ɓəi-mi kagɨ-dəsɨ tɨ je. Nə ndɔ mɨtə lə ndɔ koym ɓa, m-a m-tḛḛ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Go tɨ, ko̰ ngan lə Jəbəde rəi kɨ ngane je rɔ Jəju tɨ, ɓa ko̰ ngan je ɔsɨ məkəsɨne nangɨ no̰ Jəju tɨ mba dəje nḛ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ə Jəju dəje ə nə: «E ri ə ɨge ə?» Nɨngə, əl ə nə: «Un ndui kadɨ nganm je kɨ joo kam, dəw kare ɨsɨ dɔ ji ko̰i tɨ, ə e kɨ nungɨ ɨsɨ dɔ ji gəli tɨ tɔ, lokɨ a ɨsɨ dɔ kɨmbər ko̰ɓe tɨ ləi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lo kɨn tɨ no̰o̰, Jəju ɨle tɨ ə nə: «Ɨgəri me nḛ dəjɨ ləsi kɨn al. A asi kadɨ ɨngəi ko̰ kɨ m-aw tə m-ɨngə kam kare mɨndɨ wa?» Ɓa əli əi nə: «Oyo, j-a j-asɨ kare.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ə Jəju əl-de ə nə: «Ko̰ kɨ m-aw tə m-ɨngə kam ə a ɨngəi kare, nə ta kɨ ɔjɨ dɔ kɨsɨ dɔ ji ko̰m tɨ, kɨ dɔ ji gəlm tɨ; e ta ləm kadɨ mi ə m-adɨ səsi al. Lo je kɨn to mba dɨje kɨ Bai Luwə ra goe kəte nu kɨ mbata tɨ ləde.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","NDəgɨ njé ndo je kɨ dɔgɨ, lokɨ oi ta je kɨn, rɔde nəl-de kɨ ngan lə Jəbəde kɨ joo ka kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ə Jəju ɓar-de pətɨ kɨ rɔne tɨ, əl-de ə nə: «Ɨgəri kadɨ njé ko̰ɓe je dɔ gɨn dɨje tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ tɨ ne, ɨsi tə jɔgɨ dɔ dɨje tɨ, adi-de ko̰, taa dɨje kɨ njé tɔɓa, o̰i ɓe dɔde tɨ ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nə majɨ kadɨ to be dansi tɨ al. Re dəw madɨ dansi tɨ, ndɨgɨ kadɨ n-e kɨ bo nɨngə, kadɨ təl nje ra kɨlə ləsi pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Taa re dəw madɨ ndɨgɨ kadɨ n-e dəw kɨ dɔ kəte dansi tɨ nɨngə, kadɨ təl ɓəə kɨlə ləsi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","E be tɔ ə, mi *NGon dəw m-re mba kadɨ dɨje rai kɨlə adi-mi al, nə kadɨ mi ə m-ra kɨlə m-adɨ-de nɨm, taa m-adɨ rɔm kadɨ m-taa-n kosɨ dɨje ngay m-ɨlə-de taa nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lokɨ Jəju əi kɨ njé ndo je ləne ɨsɨ tḛḛi me ɓe tɨ kɨ Jəriko kɨ taga, kosɨ dɨje ngay njɨyəi gode tɨ mukɨ mukɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nɨngə njé kəm tɔ je joo ɨsi ngangɨ rəbɨ tɨ. Lokɨ ooi kadɨ e Jəju ə ɨsɨ ɨndə də nɨngə, uni ndune kɨ taa əli əi nə: «Ɓaɓe, NGon ka Dabɨdɨ, o kəm-to-ndoo ləje!» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kosɨ je kəngi-de kəngɨ kadɨ utɨ tade, nə njé kəm tɔ je uni ndude kɨ taa wa ɓəy əi nə: «Ɓaɓe, *NGon ka Dabɨdɨ, o kəm-to-ndoo ləje!» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lo kɨn tɨ, Jəju a lo ka tɨ, ɓar-de, ɓa dəjɨ-de ə nə: «E ri ə, ɨgei kadɨ m-ra madɨ səsi ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ə əli-e əi nə: «Ɓaɓe, jɨ ge kadɨ kəmje tḛḛ, adɨ j-o-n lo!» ");
INSERT INTO bjvNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jəju oo kəm-to-ndoo ləde, ə ɔdɨ kəmde, par ə ta naa tɨ no̰o̰, kəmde oo lo, adɨ uni goe. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lokɨ Jəju əi kɨ njé ndo je ləne rəi, ɨndəi dɔ ɓe kɨ Jorijaləm ɓasi, gɨdɨ ɓe tɨ kɨ Bətɨpaje, kɨ kadɨ mbal kagɨ bɨni je tɨ, ɨlə njé ndo je joo, ");
INSERT INTO bjvNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","əl-de ə nə: «Awi me ngon ɓe tɨ kɨ a no̰si tɨ kam. Lo kur ə wa kɨ a uri kɨ me ɓe tɨ par ə, a ɨngəi ko̰ koro əi kɨ ngon koro kɨ dɔɔi-de adɨ ai, ɓa ɨtuti-de, ɨrəi səde adi-mi. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A re dəw madɨ dəjɨ səsi ta dɔ tɨ ə, əli-e əi nə: “Ɓaɓe ə ge-de”, ə a ɨyə̰-de kalangɨ ba kadɨ ɨtuti-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","«Nḛ kɨn a ra nḛ be mba kadɨ ta kɨ nje kəl ta kɨ ta Luwə tɨ əl kɨn tɔl tane: ");
INSERT INTO bjvNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Əli dɨje kɨ *Sɨyo̰ tɨ əli əi nə: Oi ngar ləsi a re dɔsi tɨ, E dəw kɨ sɔl lɔm lɔm, Ɨsɨ dɔ ko̰ koro tɨ əi kɨ ngon koro.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","*NJé ndo je awi, rai təkɨ Jəju əl-n-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Rəi kɨ ko̰ koro əi kɨ ngon koro ka kɨn nɨngə, labi kɨbɨ je ləde gɨdɨde tɨ, ɓa Jəju al ɨsɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kosɨ dɨje ngay labi kɨbɨ je ləde go rəbɨ tɨ. NJé kɨ na̰ je təti mbi kam je ə tɨləi dɔ rəbɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","NJe njɨyə no̰ Jəju tɨ, kɨ njé njɨyə goe tɨ, uni ndude kɨ taa əli əi nə: «Tɔjɨ e kɨ dɔ NGon ka Dabɨdɨ tɨ! Nɨngə kadɨ Luwə njangɨ dɔ dəw kɨ re kɨ tɔ Ɓaɓe! Tɔjɨ e kɨ dɔ NJe kɨsɨ dɔra̰ tɨ taa!» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lokɨ Jəju ur Jorijaləm tɨ, lo kɨ me ɓe tɨ ba pətɨ ndɨgɨ ɓɨr ɓɨr. Adɨ dɨje dəji rɔde ta əi nə: «E dəw kɨ ban ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ə kosɨ je ɨləi-de tɨ əi nə: «E Jəju, nje kəl ta kɨ ta Luwə tɨ, kɨ Najarətɨ, dɔnangɨ Galile tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Go tɨ, Jəju aw ur natɨ kəy tɨ lə Luwə, nɨngə tuwə njé labɨ nḛ je kɨ njé ndogɨ nḛ je natɨ kəy tɨ lə Luwə kɔ. Jəju sur tabɨlə je lə njé mbəl la je tɨlə, naa tɨ kɨ nḛ kɨsɨ lə njé gatɨ də dum je. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nɨngə əl-de ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Kəy ləm a ɓari-e kəy kəl ta kɨ Luwə, nə səi, ɨtəli-e lo ɓɔyɔ rɔ tɨ lə njé ɓogɨ je yo!”» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lo kɨn tɨ no̰o̰, njé kəm tɔ je kɨ njé mətɨ je, rəi rɔe tɨ natɨ kəy tɨ lə Luwə, adɨ adɨ-de rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lokɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé ndo ndu-kun je ooi nḛ je kɨ ətɨ ɓəl kɨ Jəju ra-de, kɨ ndu ngan je kɨ ɨsɨ ɓa ə nə: «Tɔjɨ e kɨ dɔ *NGon ka Dabɨdɨ tɨ,» kɨn ɓa, mede o̰-de, ");
INSERT INTO bjvNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","adɨ əli Jəju əi nə: «O ta kɨ ngan je a əli kam ta?» Ə Jəju ɨlə-de tɨ ə nə: «Oyo, m-o, nə se ɨtɨdəi ndu Luwə kɨ ndangi əi nə: “Ɨra adɨ ngan je kɨ du, kɨ njé to ta mba tɨ ka, tade ɨlə tɔjɨ dɔi tɨ,” kɨn al wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nɨngə lo kɨn tɨ, Jəju ɨyə̰-de no̰o̰, ə tḛḛ me ɓe bo tɨ kɔ, aw Bətani tɨ, aw to nu. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lo ti kɨ sḭ, Jəju təl ɨsɨ re me ɓe bo tɨ, nɨngə ɓo ra-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ə oo kagɨ mbay-kote kɨ a kadɨ rəbɨ tɨ, tɔ kadɨ n-aw gɨn tɨ, nə lokɨ re ɓasi ɓa, oo mbie je par ɓɨ oo kande al. Ə Jəju əl mbay-kote ka kɨn ə nə: «A andɨ gogɨ al bɨtɨ kɨ no̰ tɨ.» Ɓa loe tɨ no̰o̰, mbay-kote tutɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lokɨ njé ndo je ooi nḛ kɨn ɓa, ətɨ-de ɓəl ngay, adɨ dəji ta əi nə: «Ra ban ə loe tɨ ne par ə kagɨ tutɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ə Jəju ɨlə-de tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, re awi kɨ kadɨ-me, ə mesi tɔsɨ al ə, e nḛ kɨ m-ra kɨ mbay-kote kɨn par ə a rai al, nə re əli mbal kam əi nə: “Ɔtɨ lo kɨn tɨ rangɨ, aw osɨ me ba tɨ,” ka nḛ kɨn a ra nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","NGa nɨngə, nḛ je pətɨ kɨ a ɨdəji kɨ kadɨ-me, me kəl ta tɨ kɨ Luwə ə, a ɨngəi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jəju ur natɨ kəy tɨ lə Luwə, ɨsɨ ndo nḛ dɨje nɨngə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je lə *Jɨpɨ je, rəi kɨ rɔe tɨ, dəji-e əi nə: «E kɨ tɔgɨ kɨ ḭ ra ə ɨsɨ ra-n nḛ je kɨn be ə? Ə na̰ tɔ ə adi ndune ə ɨsɨ ɨra-n wa əl-je adɨ j-o?» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ə Jəju təl əl-de ə nə: «Mi ka m-a m-dəjɨ səsi ta kare ba be tɔ. Re ɨləi-mi tɨ nɨngə, m-a m-əl səsi dəw kɨ adɨ-m ndune kadɨ m-ra-n nḛ je kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na̰ ə ɨlə Ja̰ kadɨ ra dɨje batəm ə? E Luwə ə se e dɨje ə?» Nə təli a əli-naa ta dande tɨ əi nə: «Re j-əl-e j-ə nə: “E Luwə ə ɨle” ə, a dəjɨ-je ə nə se ra ban ə j-adɨ Ja̰ meje al wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A kɨn ə re j-əl j-ə nə: “E dɨje ə ɨləi Ja̰” ə, e ta kɨ rɔ kosɨ je tɨ tɔ, tadɔ dɨje pətɨ ooi Ja̰ kadɨ e nje kəl ta kɨ ta Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Be ə, təli əli Jəju əi nə: «Jɨ gər al.» Ə Jəju ka təl ɨlə-de tɨ ə nə: «Re ɨgəri al ə, mi ka m-a m-əl səsi tɔgɨ kɨ m-ɨsɨ m-ra-n nḛ je kɨn al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jəju əl ta kɨ rangɨ ɓəy ə nə: «Əli-mi ta ləsi dɔ ta tɨ kɨn adi-mi m-o. Dɨngəm kare aw kɨ ngan dɨngəm je joo, ə un ta əl kɨ dɔsa̰y ə nə: “NGonm, aw ɨra kɨlə me ndɔr nju tɨ ɓone.” ");
INSERT INTO bjvNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɓa ngon ka kɨn ɨlə bawne tɨ ə nə: “M-a m-aw al,” ə ɨsɨ ba bɨtɨ nɨngə me uwe kɨ ta, adɨ ḭ aw. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dɨngəm re rɔ ngon tɨ kɨ ko̰ joo, əl-e ka ta kɨ əl ngoko̰e ka kɨn, nɨngə e əl ə nə: “Oyo, m-a m-aw bawm,” ɓa aw al. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ə se dan ngan je tɨ kɨ joo kɨn e kɨ ra ə ra go ndɨgɨ tɨ lə bawne wa?» Ɓa ɨləi Jəju tɨ əi nə: «E kɨ dɔsa̰y.» Ə Jəju əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, njé taa la-mbə je kɨ dəne je kɨ njé ra kaya je a tḛḛi ko̰ɓe tɨ lə Luwə no̰si tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tadɔ Ja̰ Batɨsɨ re rɔsi tɨ, tɔjɨ səsi rəbɨ kɨ dana, nə ɨtaai mee al, nə njé taa la-mbə je kɨ dəne je kɨ njé ra kaya je taai mee. Ə səi je, oi nḛ kɨn be ka, mesi uwə səsi kɨ ta go gogɨ ɓa adɨ ɨyə̰i nḛ rasi je kɨ majal kɔ, ə ɨtaai mee al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Go tɨ, Jəju əl-de ə nə: «Uri mbisi oi kujɨ ta kɨ rangɨ ɓəy. Dəw kare kɨ nje ndɔr nju e no̰o̰, nɨngə ɨndə sɨngə gugɨ gɨde wukɨ. Ur ɓe kadɨ tə mborəi man nju tɨ, nɨngə ur nḛ tə ta kagɨ be, kadɨ dɨje ɨsi dɔ tɨ ngəmi ndɔr ka kɨn. Ɓa go tɨ, dɔɔi ta naa tɨ kɨ dɨje kɨ njé ra kɨlə nju, kadɨ tə rai kɨle adi-e, ə kagɨ loe tɨ ɓa, a ka̰yḭ-naa nḛe, nɨngə e wa ɔtɨ aw mba. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lokɨ kagɨ lo kɨjə kandɨ nju asɨ nɨngə, ɨlə ɓəə je ləne kadɨ awi taai kandɨ nḛ ndor ka kɨn, kɨ ya̰ne ji njé ra kɨle tɨ adɨ-ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nə lokɨ ɓəə je awi nɨngə, njé ra kɨlə je uwəi-de. Tɨndəi kɨ kare ngay, tɔli kɨ nungɨ, ɓa kɨ ko̰ mɨtə, tɨləi-e kɨ mbal tɔli-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","NJe ndɔr təl ɨlə kɨ ɓəə je kɨ rangɨ, ngay ɨtə e kɨ kəte wa kɨn ɓəy. Nə rai səde ko nḛ wa kɨ rai kɨ njé kɨ kəte ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta tɔl tae tɨ, dɨngəm təl ɨlə ngonne wa rɔde tɨ, ə nə: “A ɓəli gɨdɨ ngonm.” ");
INSERT INTO bjvNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nə njé ra kɨlə nju, lokɨ ooi ngon ka kɨn ɓa əli-naa dande tɨ əi nə: “Darɔe ə wa kam ə a e nje nḛ nduwə, ɨrəi adɨ jɨ tɔli-e, nɨngə j-a j-uwəi ndɔr nju kɨn ya̰je tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","E be ə, uwəi ngon ka kɨn, ndɔri-e, awi sie gɨdɨ ndɔr tɨ taga, tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ə se ndɔ kɨ dɨngəm kɨ ɓa nje ndɔr kɨn a re ə, ri ə a ra kɨ njé ra kɨlə ndɔr je kɨn wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nɨngə əi je əli Jəju əi nə: «A tɔ kode, ɓa a adɨ ndɔr ləne njé kɨ rangɨ, kɨ kadɨ a adi-e kande kɨ dɔkagɨlo kɨ ɔjɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nɨngə Jəju əl-de ə nə: «Ɨtɨdəi me makɨtɨbɨ tɨ lə Luwə oi al a? “MBal kɨ njé ra kəy je mbati-e, E ə təl mbal kɨ e tɔgɨ kəy. E kɨn e kɨlə ra Ɓaɓe. E nḛ kɔjɨ kɨ ətɨ ɓəl ə to ta kəmje tɨ kɨn.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nɨngə adɨ m-əl səsi ɓəy tɔ: «A taai ko̰ɓe lə Luwə jisi tɨ, kadɨ təli adi gɨn dɨje kɨ rangɨ kɨ kadɨ a raii kɨlə kɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","NGa nɨngə, dəw kɨ osɨ dɔ mbal tɨ kɨn ə, a tətɨ njəkɨ njəkɨ, a re e ə mbal kɨn osɨ dɔe tɨ tɔ nɨngə, a rəkɨte rəkɨtə rəkɨtə.» ");
INSERT INTO bjvNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lokɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ *Parɨsɨ je ooi kujɨ ta kɨn ɓa, gəri mee kadɨ e ta kɨ dɔde tɨ ə Jəju a əl. ");
INSERT INTO bjvNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ə sangi rəbɨ kadɨ n-uwəi-e, nə ɓəli kosɨ je, tadɔ kosɨ je ooi Jəju tə nje kəl ta kɨ ta Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jəju ɨlə rɔne əl-de ta kɨ kujɨ ta ɓəy ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ko̰ɓe kɨ dɔra̰ tɨ to tə ta lə ngar kɨ ra nḛ kuso kɨ bo mbata ngone kɨ aw tə taa dəne kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","NGar ɨlə njé kɨlə je ləne adɨ awi əli dɨje kɨ ɓari-de lo nḛ kuso tɨ, kadɨ rəi, nə dɨje ka kɨn mbati. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","NGar təl ɨndə ta ta njé kɨlə je tɨ kɨ rangɨ ɓəy ə nə: “Kɨ ɓasɨne kɨn, nḛ kuso oy ngata, m-tɔl baw mangɨ je, kɨ bɨyə̰ je kɨ batɨ je ləm, kɨ əməi majɨ, nḛ je pətɨ asɨ-naa, ə ɨrəi lo nḛ kuso taa-naa tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nə dɨje kɨ ɓari-de ka kɨn, rai kɨlə kɨ ta lie kɨn al, njé kɨ madɨ awi kɨ wale je ləde, njé kɨ na̰ je awi kɨ lo gatɨ je tɨ ləde, ");
INSERT INTO bjvNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ə njé kɨ nungɨ ɓəy, uwəi njé kɨlə je adi-de ko̰ je, tɔli-de je. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Lo kɨn tɨ, wongɨ tɔl ngar, adɨ ɨlə kɨ asɨgar je ləne adɨ awi tɔli njé tɔl nḛ je ka kɨn nɨm, tɨləi ɓe je ləde por nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nɨngə go tɨ, ngar əl njé kɨlə je ləne ə nə: “Nḛ kuso taa-naa oy ngata, nə dɨje kɨ e kɨ ɓar-de, əi dɨje kɨ asi ta tḛḛ loe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Awi kɨ ta tɔ rəbɨ je, ɨɓari dɨje pətɨ kɨ ɨngəi-de, adi-de rəi lo nḛ kuso taa-naa tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","NJé kɨlə je awi kɨ go rəbɨ je, kawi dɨje pətɨ kɨ ɨngəi-de, kɨ majɨ je, kɨ majal je, adɨ dɨje rosi me kəy kɨ kadɨ dɨje usoi nḛ taa-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lokɨ ngar ə nə n-ur kəy kadɨ n-oo dɨje kɨ ɓari-de ka kɨn nɨngə, oo dɨngəm madɨ kare kɨ ɨsɨ kɨ kɨbɨ kuso nḛ taa-naa rɔne tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ə ngar əl-e ə nə: “Madɨm, ɨra ban ə ur kəy ne kɨ kanjɨ kɨbɨ kuso nḛ taa-naa rɔi tɨ ə?” Ɓa dɨngəm ka kɨn ɨlə tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","NGa ə ngar əl njé kɨlə je ləne ə nə: “Ɨdɔɔi jie je kɨ njae, ə ɨləi-e taga lo kɨ ndul tɨ, kɨ e lo kɨ a no̰ je, a ngə ngangɨne je tɨtɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Təkɨ rɔjetɨ, Luwə ɓar dɨje ngay, nə njé kɨ mbətɨ je əi ngay al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","*Parɨsɨ je ɨngəi-naa, əli-naa ta, kadɨ n-ɨyəi kulə n-uwəi Jəju me ta tɨ kɨ n-a n-dəji-e ə a tḛḛ tae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Be ə, ɨləi njé ndo je ləde əi kɨ dɨje madɨ kɨ me ɓutɨ tɨ lə *Erodɨ, adɨ awi əli-e əi nə: «NJe ndo dɨje, jɨ gər kadɨ ḭ nje kəl ta kɨ rɔjetɨ, ḭ nje ndo dɨje rəbɨ kɨ rɔjetɨ kɨ nəl Luwə nɨm, ɨɓəl kəm dəw al nɨm, tadɔ ḭ o nḛ ra kɨ gɨdɨ tɨ taga ne kam al. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ə əl-je adɨ j-o ta kɨ mei tɨ: e loe tɨ ə se e loe tɨ al kadɨ dəw ɨgə la-mbə nje ko̰ɓe kɨ bo Səjar ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nə Jəju, təkɨ gər-n me majal ləde, əl-de ə nə: «Səi njé kədɨ kəm dɨje! MBa ri ə ɨyəi kulə kadɨ uwəi-mi ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɔji-mi sɨlə kɨ kadɨ dəw a ɨgə-n la-mbə adi-mi m-o.» Ɓa ɔji-e sɨlə kare. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","NGa ə dəjɨ-de ə nə: «Dɔ na̰ ə ɨndəi, ə tɔ na̰ tɔ ə ndangi sɨlə tɨ kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ə ɨləi-e tɨ əi nə: «E nje ko̰ɓe kɨ bo Səjar.» Ə Jəju təl əl-de ə nə: «Nḛ lə Səjar ə adi Səjar, nḛ lə Luwə ə adi Luwə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta kɨ Jəju əl-de kɨn dum dɔde, adɨ ɨyə̰i-e ə ɔti awi. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","NDɔe tɨ no̰o̰, *Sadusɨ je kɨ əi dɨje kɨ ooi kadɨ njé koy je a ḭḭ taa lo koy tɨ al, rəi rɔ Jəju tɨ dəji-e əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«NJe ndo dɨje, *Mojɨ əl ə nə: “Re dəw madɨ oy, kɨ kanjɨ kɨyə̰ ngan je tone tɨ ɓa, sɔbɨ kadɨ ngoko̰e taa dəne nduwə kɨn, ojɨ-n ngan je, kadɨ tḛḛi to nje goto tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kɨ ɔjɨ dɔ ta kɨn, ndɔ kɨ to danje tɨ no̰o̰. NGakonaa je əi sɨri, kɨ dɔsa̰y taa dəne, nɨngə ojɨ-n ngon kɨ kadɨ tə ɔr toe al ɓəy ə oy, adɨ ɨyə̰ dəne nduwə adɨ ngokone. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nḛ kɨn ra nḛ be, ḭḭ-n dɔ kɨ ko̰ joo tɨ, kɨ kɨ ko̰ mɨtə tɨ, bɨtɨ tḛḛ-n dɔ kɨ ko̰ sɨri tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Gode tɨ pətɨ, darɔ dəne wa re oy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","NGa ə se ndɔ kɨ njé koy je a ḭḭ taa lo koy tɨ ə, na̰ dande kɨ sɨri kɨn ə dəne kɨn a e nee wa? Tadɔ əi pətɨ taai-e nede tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ə Jəju ɨlə-de tɨ ə nə: «Səi dɨje kɨ ɨndəmi rəbɨ, tadɔ ɨgəri makɨtɨbɨ lə Luwə al nɨm, taa ɨgəri tɔgɨ lə Luwə al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","NDɔ kɨ njé koy je a ḭḭ taa lo koy tɨ, dɨngəm je kɨ dəne je a taai-naa al ngata. Pətɨ a toi tə *Malayka je be me dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kɨ ɔjɨ dɔ kḭ taa lo koy tɨ lə njé koy je, ɨtɨdəi ta kɨ Luwə əl səsi kɨn al a? ");
INSERT INTO bjvNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Luwə əl ə nə: “Mi Luwə lə *Abɨrakam, mi Luwə lə *Isakɨ, kɨ Luwə lə *Jakobɨ.” Luwə e Luwə lə dɨje kɨ njé kɨsɨ kəm ba, ɓɨ e Luwə lə njé koy je al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kosɨ je kɨ ooi ta lə Jəju, nḛ ndo lie ətɨ-de ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lokɨ *Parɨsɨ je ooi kadɨ Jəju dum dɔ *Sadusɨ je ɓa, əi je kawi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ə kɨ kare dande tɨ, kɨ e nje ndo ndu-kun je, ɨyə kulə me ta tɨ, dəjɨ Jəju ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«NJe ndo, dan ndu-kun je tɨ lə Luwə pətɨ kɨn, e kɨ ra ə e dɔ madɨne je tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ə Jəju ɨle tɨ ə nə: «A ɨndɨgɨ Ɓaɓe Luwə ləi kɨ nga̰mei ba pətɨ, kɨ ndɨli ba pətɨ, taa kɨ mər ta ləi ba pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","E kɨn ə e ndu-kun kɨ dɔsa̰y kɨ ɨtə ndu-kun je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nɨngə ndu-kun kɨ ko̰ joo kɨ e ndu-kun kɨ nga̰ ngay tɔ ə to kɨn: A ɨndɨgɨ dəw madi tə darɔi ḭ wa be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","*NDu-kun je lə *Mojɨ ba pətɨ, kɨ ta je lə njé kəl ta kɨ ta Luwə tɨ, ngɨrəde e dɔ ndu-kun je tɨ kɨ joo kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lokɨ *Parɨsɨ je kawi-naa ka kɨn, Jəju dəjɨ-de ta ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kɨ go mər ta tɨ ləsi dɔ Kɨrɨsɨ tɨ kɨ e *Dəw kɨ Luwə mbəte kɨn, oi kadɨ e gɨn kojɨ tɨ lə na̰ ə?» Ə əli-e əi nə: «E ngon ka *Dabɨdɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ə Jəju əl-de ə nə: «Ra ban be ə Dabɨdɨ kɨ NDɨl Luwə e mee tɨ ɓar-e “Ɓam” ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tadɔ Dabɨdɨ əl ə nə: “Ɓaɓe Luwə əl Ɓaɓe ləm ə nə: ‹Ɨre ɨsɨ dɔ ji ko̰m tɨ ne, Bɨtɨ kadɨ m-ɨlə njé ba̰ je ləi gɨn tɔgi tɨ›.” ");
INSERT INTO bjvNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ə re Dabɨdɨ ɓar-e Ɓane ə, ra ban taa Kɨrɨsɨ, kɨ e dəw kɨ Luwə mbəte a e ngon ka Dabɨdɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lo kɨn tɨ, dəw kɨ asɨ kadɨ ɨle ta tɨ kare be goto. Nɨngə ḭ dɔ ndɔe tɨ nu kɨn, dəw ka sangɨ kadɨ n-dəje ta al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jəju əl kosɨ je kɨ njé ndo je ləne ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«NJé ndo ndu-kun je kɨ *Parɨsɨ je, kɨlə ləde e kɔr gɨn ndu-kun lə *Mojɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","NGa nɨngə səi, majɨ kadɨ ɨtəli rɔsi go nḛ je tɨ kɨ əli səsi, nə ɨndaji kɨlə rade je al, tadɔ rai nḛ kɨ əi je wa ɨsɨ əli kɨ tade kɨn, al. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dɔɔi nḛ kɨ ɔy ɨndəi dɔ dɨje tɨ, nə mbati kun ngon jide taa ndə̰y be kuwə-n səde tae. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kɨlə rade je pətɨ, rai kɨ kadɨ dɨje ooi gɨdɨde. NGan ndu-kun je kɨ ndangi ɨləi me ngan buwatɨ je tɨ, ə dɨje dɔɔi natɨ no̰de tɨ ə sə jide tɨ wa kɨn, rai ya̰de adɨ boy, taa kulə je kɨ dɨje ɔsi sɨl kɨbɨ je tɨ kɨn ka, rai ya̰de adɨ ngal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Əi dɨje kɨ gei lo kɨsɨ kɨ kəte no̰ dɨje tɨ, lo nḛ kuso tɨ, kɨ nḛ kɨsɨ kɨ kəte no̰ dɨje tɨ, gɨn kəy kaw-naa je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Taa gei kadɨ dɨje rai-de lapɨya kɨ ɓukɨ-naa tɨ lo kɨngə-naa je tɨ lə kosɨ je nɨm, kadɨ dɨje ɓari-de “NJé ndo dɨje” nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nə səi, adi dəw ɓar səsi “NJe ndo dɨje”, al, tadɔ pətɨ, səi ngakonaa je, nɨngə NJe ndo səsi e kare ba tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɨɓari dəw madɨ dɔnangɨ tɨ ne “Bawsi” al, tadɔ Bawsi e kare ba, ə ɨsɨ dɔra̰ tɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Taa adi dəw ɓar səsi “Dɨje kɨ bo”, al tɔ, tadɔ Dəw kɨ bo ləsi e kare ba, ə e Kɨrɨsɨ kɨ e dəw kɨ Luwə mbəte. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dəw kɨ bo dansi tɨ, a e nje ra kɨlə ɓəə ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dəw kɨ un dɔne kɨ taa, a ɨləi dɔe kɨ nangɨ, ə dəw kɨ ɨlə dɔne kɨ nangɨ, a uni dɔe taa tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je, kɨ *Parɨsɨ je. Səi njé kədɨ kəm dɨje! Ɨsɨ uti ta rəbɨ kɨ kaw ko̰ɓe tɨ kɨ dɔra̰ tɨ dɔ dɨje tɨ. Səi je wa uri me tɨ al, nɨngə dɨje kɨ gei kur me tɨ ka, ɔgi-de nɨm tɔ.  ");
INSERT INTO bjvNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je kɨ Parɨsɨ je. Ɨtaai nḛ majɨ je lə njé ngaw koy je pətɨ pətɨ jide tɨ, nɨngə ədi kəm dɨje kɨ kəl ta kɨ Luwə kɨ gɨne gangɨ al, kadɨ dɨje ooi səsi, təkɨ səi dɨje kɨ majɨ. Go kɨlə ra je tɨ kɨ be kɨn, Luwə a gangɨ-n ta kɨ nga̰ ngay dɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je kɨ Parɨsɨ je, səi njé kədɨ kəm dɨje! Awi mba, a̰yḭ-naa ngɔdɨ dɔnangɨ rai je tɨ kɨ lo lo, dɔ ba tɨ je mba kadɨ ɨngəi dəw kare gosi tɨ. Ə lokɨ ɨngəi-e nɨngə, ɨrai-e adɨ təl asɨ ta kaw me por tɨ nja joo ɨtə səi je wa ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Kəm-to-ndoo e ləsi, səi njé kɔr dɨje ta rəbɨ, kɨ kəmsi tɔ! Ɨsɨ əli əi nə: “Re dəw ɨbɨ rɔne kɨ kəy lə Luwə ɓa, to kare, a re ɨbɨ rɔne kɨ lɔr kɨ kəy lə Luwə ə, sɔbɨ kadɨ ra nḛ kɨ ɨbɨ-n rɔne.” ");
INSERT INTO bjvNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Səi mbə dɨje, dɨje kɨ kəmsi oo lo al! Lɔr e nḛ kɨ kəy lə Luwə, adɨ e ya̰ Luwə. Ə se lɔr ɓa e kɨ bo ngay ə se, kəy lə Luwə kɨ təl lɔr nḛ kɨ kɨndə ta dangɨ tɨ kɨn wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɨtəli əli ɓəy əi nə: “Re dəw ɨbɨ rɔne kɨ dɨngɨri lo kɨndə kadɨ-kare ɓa, to kare, a re ɨbɨ rɔne kɨ kadɨ-kare ə, sɔbɨ kadɨ ra nḛ kɨ ɨbɨ-n rɔne.” ");
INSERT INTO bjvNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Səi njé kəm tɔ je! E ri ə e kɨ bo ngay ə? E kadɨ-kare ə se e dɨngɨri lo kɨndə kadɨ-kare kɨ təl kadɨ-kare nḛ kɨ kɨndə ta dangɨ tɨ kɨn ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dəw kɨ ɨbɨ rɔne kɨ lo kɨndə kadɨ-kare ɓa, ɨbɨ rɔne kɨ dɨngɨri lo kɨndə kadɨ-kare nɨm, kɨ nḛ je pətɨ kɨ ɨsɨ dɔ tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Dəw kɨ ɨbɨ rɔne kɨ kəy lə Luwə ɓa, ɨbɨ rɔne kɨ kəy lə Luwə nɨm, kɨ Luwə kɨ ɨsɨ me tɨ nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Dəw kɨ ɨbɨ rɔne kɨ dɔra̰ ɓa, ɨbɨ rɔne kɨ kɨmbər ngar lə Luwə nɨm, kɨ Luwə kɨ ɨsɨ dɔ tɨ nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je, kɨ Parɨsɨ je, səi njé kədɨ kəm dɨje. Ɔri nḛ kare dan kɨ dɔgɨ tɨ, me mbi kam je tɨ kɨ ətɨ majɨ, kɨ me mbi kam ndɨr ta̰y je tɨ, kɨ me ngan nḛ ndɨr ta̰y je tɨ, adi Luwə, nɨngə ɨndəi njasi dɔ nḛ je tɨ kɨ rɔjetɨ me ndu-kun tɨ lə Luwə, tə nḛ ra kɨ dana, kɨ koo kəm-to-ndoo, kɨ ra go tɨ. Kɨ rɔjetɨ, e kɨn ə e nḛ je kɨ sɔbɨ kadɨ re a ɨndəi kəmsi go tɨ ɨrai, kɨ kanjɨ kɨyə̰ ndəge je. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Səi njé kɔr dɨje ta rəbɨ, kɨ kəmsi tɔ! Ɨsɨ ɨləi nḛ ta ngoo man tɨ ɨtaai man mbata ngan ku je kɨ du, ə ɨsɨ tɨwi kədɨ mesi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je, kɨ Parɨsɨ je, səi njé kədɨ kəm dɨje! Ɨtogi gɨdɨ ka man, kɨ gɨdɨ ka kuso nḛ adɨ ay, nə mee kəy rosɨ kɨ nḛ ɓogɨ je, kɨ nḛ kɨ ɨngəi kɨ go rəbɨ ngur nḛ ra kɨ majal. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ḭ Parɨsɨ kɨ nje kəm tɔ! Ɨtogɨ me ka man, nɨngə gɨde a ay tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je kɨ Parɨsɨ je, səi njé kədɨ kəm dɨje! Ɨtoi tə dɔ ɓadɨ je kɨ dɨje lati po̰ gɨdɨ tɨ adɨ ndai kam be: re o gɨde taga ne ɓa, ndole, nə mee kɨ kəy rosɨ kɨ sɨngə dɨje, kɨ nḛ je kɨ ndum. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E be tɔ ə, gɨdɨsi tɨ taga ne, ɨtɔji adɨ dɨje ooi təkɨ səi njé təl rɔsi go ndu Luwə tɨ, nə mesi tɨ kəy ɓa, kədɨ kəm dɨje kɨ majal kɨ ra, rosɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je kɨ Parɨsɨ je, səi njé kədɨ kəm dɨje! Ɨndəi ɓadɨ njé kəl ta kɨ ta Luwə tɨ adɨ majɨ, ɨrai ɓadɨ dɨje kɨ dana adɨ ndole, ");
INSERT INTO bjvNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nɨngə əli əi nə: “Re dɔkagɨlo tɨ lə kaje je kɨn je no̰o̰ ə, re j-a j-ɨndə rɔje naa tɨ səde kadɨ jɨ tɔl-n njé kəl ta je kɨ ta Luwə tɨ, al.” ");
INSERT INTO bjvNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lo kɨn tɨ, səi je wa ɨsɨ tɔji kadɨ səi ngan ka njé tɔl njé kəl ta kɨ ta Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","E ən ə, ɨrai kɨ no̰si tɨ, ɨtɔlii ta nḛ kɨ kasi je ɨləi ngɨre! ");
INSERT INTO bjvNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«Səi dɨje kɨ mansi majal tə li pi je be, ra ban ə ɨməri kadɨ a a̰yḭ-naa, ta ta kɨ gangɨ tɨ lə por ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","E mbata kɨn ə, m-a m-ɨlə-n kɨ njé kəl ta je kɨ ta Luwə tɨ, kɨ njé gosɨ je, kɨ njé ndo dɨje ta lə Luwə, rɔsi tɨ. A tɔli-de je, a ɓəi-de kagɨ-dəsɨ tɨ je, a tɨndəi-de kɨ ndəy kabɨlay gɨn kəy kaw-naa tɨ je, taa a ngɔdi-de, ḭḭ səde ɓe bo tɨ kɨ kare ə ɨgangi səde ɓe bo tɨ kɨ nungɨ kɨ kəte kəte. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lo kɨn tɨ, dɨje kɨ dana kɨ məsɨde e kɨ ɓukɨ kɔ, ɨlə ngɨre dɔ Abəl tɨ, tḛḛ-n dɔ Jakari tɨ kɨ ngon lə Barasi kɨn, ta məsɨde a e dɔsi tɨ. E Jakari kɨ ndɔ kɨ ɨtɔli-e dadan lo tɨ kɨ ḭ kəy tɨ lə Luwə re lo dɨngɨri kadɨ-kare tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Təkɨ rɔjetɨ, adɨ m-əl səsi, ta nḛ tɔl je kɨn pətɨ a e dɔ dɨje tɨ kɨ dɔkagɨlo tɨ kɨ ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Səi dɨje kɨ Jorijaləm tɨ, səi dɨje kɨ Jorijaləm tɨ, səi njé tɔl njé kəl ta je kɨ ta Luwə tɨ, səi njé tɨlə dɨje kɨ Luwə ɨlə səde adɨ səsi kɨ mbal tɔli-de. NJa ngay, m-sangɨ kadɨ m-kaw səsi təkɨ ko̰ kɨnjə a kaw-n ngane je gɨn bagɨne tɨ kɨn be, nə ɔdi al. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nɨngə kɨ ne kɨn, Luwə a ɨyə̰ kəy kaw-naa ləsi kɔ jisi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tadɔ a oi-mi al ngata, bɨtɨ ndɔ kɨ a əli əi nə: “NJangɨ dɔ e dɔ dəw tɨ kɨ re me tɔ Ɓaɓe tɨ”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jəju tḛḛ me kəy tɨ lə Luwə kɨ taga, ɨsɨ aw nɨngə, njé ndo je lie, rəi rɔe tɨ, əli-e kadɨ oo kəy lə Luwə kɨ dɨje ɨndəi adɨ ətɨ ɓəl kɨn! ");
INSERT INTO bjvNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ə Jəju un ta əl-de ə nə: «Nḛ je kɨn pətɨ, kəmsi oo majɨ, nə təkɨ rɔjetɨ, adɨ m-əl səsi m-adɨ oi, mbal kare kɨ a nay kadɨ ɨsɨ dɔ made tɨ ne goto; a budi-de nangɨ mur mur.» ");
INSERT INTO bjvNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Go tɨ, lokɨ Jəju aw ɨsɨ dɔ mbal kagɨ bɨni je tɨ, njé ndo je lie rəi rɔe tɨ, əli-e ta lokɨ əi sie kɨ karde ba əi nə: «Əl-je adɨ j-o, dɔkagɨlo kɨ ra tɨ ə nḛ je kɨn a rai nḛ ə? Ə nḛ kɔjɨ kɨ ban ə a tɔjɨ kadɨ jɨ gər təkɨ e dɔkagɨlo kɨ kadɨ tə ɨre-n nɨm, e dɔbəy ndɔ nɨm tɔ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ə Jəju ɨlə-de ə nə: «Ɨndəi kəm-kədɨ dɔ rɔsi tɨ, adi dəw ədɨ səsi al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tadɔ dɨje ngay a rəi kɨ tɔm, a əli əi nə: “Mi ə mi Kɨrɨsɨ kɨ e Dəw kɨ Luwə mbəte”, nɨngə a ɓuki dɨje ngay wale tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A oi ka rɔ je kɨ e səsi ɓasi, kɨ poy rɔ je kɨ e sa̰y, nə oi majɨ! Adi ɓəl ra səsi al. Ri ri ka nḛ je kɨn a rəi, nə e dɔbəy ndɔ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gɨn ɓe madɨ a aw rɔ dɔ gɨn ɓe madɨne tɨ, ko̰ɓe madɨ a aw rɔ dɔ ko̰ɓe madɨne tɨ; ɓo a o̰ je, dɔnangɨ a yəkɨ je, kɨ lo je kɨ dangɨ dangɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","nə nḛ je kɨn pətɨ a toi tə lo kɨlə ngɨrə to ndoo kɨ a ra dəne kɨn be ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dɨje a uni dɔsi, awi səsi kadɨ ɨngəi ko̰ je, kadɨ tɔli səsi je. Dɨje pətɨ kɨ əi *Jɨpɨ je al, mede a majal səsi kɨ mbata ləm. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lo kɨn tɨ, dɨje ngay a ɨyə̰i kadɨ-me je ləde kɔ. A uni dɔ-naa kɨ yo je kɨ ne je, a ɔsi-naa ta. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","NJé kəl ta ngom kə nə n-əi njé kəl ta kɨ ta Luwə tɨ, a tḛḛi, ədi dɨje ngay ɓuki-de wale. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Majal a taa dɔnangɨ taa kɨ kadɨ, dɨje ngay ndɨgɨ-naa ləde a təl gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nə dəw kɨ uwə tɔgɨne ba bɨtɨ dɔbəy tɨ, a ɨngə kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Poy Ta kɨ Majɨ kɨ dɔ ko̰ɓe tɨ lə Luwə kɨn, dɨje a ɨləi mbḛe kɨ dɔnangɨ pətɨ, kadɨ dɨje pətɨ kɨ gəri Luwə al ooi najɨ kɨ ma kɨ dɔ tɨ. Nɨngə go tɨ, dɔbəy ndɔ a re. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nɨngə lokɨ a oi dəw kɨ nje ra nḛ kɨ kɔbɨ, dəw kɨ nje tujɨ lo, kɨ nje kəl ta kɨ ta Luwə tɨ Danɨyəl əl ta lie kɨn, a uwə lo kɨsɨ lo kɨ ay njay tɨ kɨn ɓa, majɨ kadɨ dəw kɨ nje tɨdə nḛ je kɨn, gər gɨne majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nɨngə njé kɨ ɨsi Jude tɨ a a̰yḭ-naa kɨ dɔ mbal je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Dəw kɨ ɨsɨ dɔ kəy tɨ, a ur nangɨ kadɨ aw me kəy tɨ un nḛ madɨ tḛḛ-n al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Dəw kɨ a e me ndɔr tɨ, a asɨ kadɨ təl re ɓe un kɨbɨ rɔne al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","NDɔe tɨ no̰o̰ kɨn, kəm-to-ndoo kɨ ga̰e goto a e lə dəne je kɨ njé səm, kɨ njé kadɨ mba ngan je. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Əli ta kɨ Luwə kadɨ a̰yḭ-naa ngɔdɨ kɨn ɓara al, taa kadɨ e ndɔ taa kə̰ə̰ tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tadɔ dɔkagɨloe tɨ kɨn, ko̰ kɨ dɨje a ɨngəi, e ko̰ kɨ dəw oo ndɔ kare al ɓəy. Lo kɨlə ngɨrə dɔra̰ kɨ dɔnangɨ tɨ nu, bɨtɨ ɓone, dəw oo ko ko̰ kɨn nja kare al, taa dəw a oo ko ko̰ kɨn gogɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Re Ɓaɓe uwə ta ndɔ je kɨn gangɨ al ə, dəw kare kɨ a ɨsɨ kɨ dɔne taa goto. Nə kɨ mbata lə dɨje kɨ e wa mbətɨ-de ə, a uwə-n ta ndɔ je kɨn gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","NGa nɨngə, re dəw əl səsi ə nə: “Kɨrɨsɨ kɨ e *Dəw kɨ Luwə mbəte ə e yo ɓo, e ə e ne ɓo” ə, onosi kadi-e mesi. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","MBata kɨrɨsɨ je kɨ ngom, kɨ njé kəl kə nə n-əi njé kəl ta je kɨ ta Luwə tɨ, a rəi no̰o̰ tə rai nḛ kɔjɨ je kɨ ətɨ ɓəl kɨ nḛ je kɨ dum kəl tae. A rai ra kɨ kadɨ tə njé wa kɨ Luwə mbətɨ-de kɨn ka, n-ɓuki-de wale. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","E be ə, m-əl səsi nḛ je kɨn kəte be kadɨ ɨgəri. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Kɨn ə re dəw əl səsi ə nə: “Dəw kɨ Luwə mbəte ə a dɨlə lo tɨ yo am” ə, awi al. Re əl səsi ə nə: “E ə ɓɔyɔ rɔne mbo̰ lo tɨ gogɨ nu am” ə adi-e mesi al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nɨngə, təkɨ ndi təl ḭ-n lo kɨbə kadɨ tɨ, aw-n lo kur kadɨ tɨ ka kɨn, kɨrem mi *NGon dəw ka e be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lokɨ nɨn to tɨ ə mal je a kawi-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","NGay al par go ko̰ je tɨ kɨ dɔkagɨloe tɨ kɨn ɓa, kadɨ a tḛḛ kəmne al, nay a nda al, mee je a ḭḭ kɨ dɔra̰ tɨ tosi kɨ nangɨ, nɨngə tɔgɨ je kɨ dɔra̰ tɨ a yəki. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lo kɨn tɨ, nḛ kɔjɨ kɨ dɔm tɨ mi NGon dəw a tḛḛ dɔra̰ tɨ, nɨngə gɨn kojɨ je pətɨ kɨ dɔnangɨ tɨ ne a ndɨgəi rɔde. NGa nɨngə, a oi-mi NGon dəw m-a m-re me kɨl ndi tɨ kɨ tɔgɨ, me kunjɨ tɨ kɨ ətɨ ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","M-a m-ɨlə malayka je ləm kɨ təbɨ kɨ ɓa ɔr lo dɔ kum dɔnangɨ tɨ kɨ sɔ kadɨ kawi njé kɨ Luwə mbətɨ-de kɨ naa tɨ. A kawi-de ḭḭ ngangɨ dɔnangɨ tɨ kɨ kare tḛḛi e kɨ nungɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Majɨ kadɨ ɨgəri nḛ ndo kɨ dɔ kagɨ mbay-kote tɨ kɨn majɨ. Lokɨ bajie je ɨndəi rungɨru, ə mbie ɨtɨ kɨn nɨngə, ɨgəri kadɨ nay ɓa e ɓasi ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Be tɔ ə, lokɨ oi nḛ je kɨn pətɨ rai nḛ nɨngə, majɨ kadɨ ɨgəri təkɨ mi *NGon dəw mi ta kəy tɨ ɓasi rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi, dɨje kɨ ɨsi kɨ dɔde taa ne kɨn a oyi tɨgə al ɓəy ə nḛ je kɨn a rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dɔra̰ kɨ dɔnangɨ a gotoi ndɔ madɨ, nə ta ləm a to lo tone tɨ ba bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Dəw kare kɨ gər ndɔ əi kɨ dɔ kadɨ kɨ nḛ je kɨn a rai nḛ tɨ goto. *Malayka je kɨ dɔra̰ tɨ al nɨm, mi NGon lə Luwə ə wa al nɨm. Dəw ɓa e Bawje Luwə kɨ karne ba par ə gər. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nɨngə, nḛ kɨ ra nḛ dɔkagɨlo tɨ lə Nuwe kɨn ə, nḛe a ra nḛ ndɔ rem tɨ mi *NGon dəw tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kəte no̰ kadɨ man ko̰ kɨ bo kɨn re, dɨje usoi je, a̰yḭ-naa je, taai-naa je, ɨləi ngande je ngaw tɨ je, bɨtɨ ndɔ tɨ kɨ Nuwe ur-n me bato tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Me dɨje uwə-de kɨ ta al, bɨtɨ kadɨ man kɨ bo re o̰-n-de. E be ə, kɨrem mi NGon dəw ka a to be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dɨngəm je joo a ai me ndɔr tɨ ɓa, a uni kare ə a ɨyə̰i kɨ nungɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dəne je joo a uri nḛ me bɨr tɨ kɨ kare, a uni kɨ kare ə a ɨyə̰i kɨ nungɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ə majɨ kadɨ ɨsi dɔgɨ tɨ, tadɔ ɨgəri dɔ kadɨ kɨ Ɓaɓe ləsi a re-n al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɨgəri majɨ kadɨ re ɓa nje kəy gər dɔ kadɨ kɨ nje ɓogɨ a re-n dan lo tɨ ə, a ɨsɨ kəm ba, ɓɨ a ɨyə̰ nje ɓogɨ kadɨ ur kəy al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E mbata kɨn ə, səi ka, ɨsi dɔ njasi tɨ tɔ, tadɔ mi NGon dəw m-a m-re dɔ kadɨ tɨ kɨ ɨgəri al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Ɓəə kɨlə kɨ dana, kɨ kəme ədɨ, ə e dəw kɨ ɓae a ɨnde dɔ dɨje tɨ kɨ me kəy tɨ ləne kadɨ adɨ-de nḛ kuso kɨ dɔ kadɨ kɨ kadɨ adɨ-n-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","NJe ra kɨlə kɨn a e nje majɨ-kur, lo kɨ ɓae təl ə ɨnge ta kɨlə tɨ kɨn, a ra. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Təkɨ rɔjetɨ adɨ m-əl səsi, a ɨnde dɔ nḛ majɨ je tɨ ləne pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A kɨn ə re e nje ra kɨlə kɨ majal ə, a əl mene tɨ ə nə: “Ɓam a re law al ɓəy”, ");
INSERT INTO bjvNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ɓa a a ta tɨndə madɨ-kɨləne je tɨ, a uso je, a a̰y je kɨ njé kasɨ ra je. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lo kɨn tɨ, ɓa nje kəy a re kɨ ndɔ kɨ e ɨndə mene dɔ tɨ al, kɨ dɔ kadɨ kɨ gər al. ");
INSERT INTO bjvNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɓae a tuwe kɔ, kadɨ oo nḛ ko̰ kɨ a ra dɨje kɨ njé kədɨ kəm dɨje, lo no̰ tɨ kɨ lo ngə ngangɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Ko̰ɓe kɨ dɔra̰ tɨ a to tə ta lə ngan mandɨ je kɨ dɔgɨ kɨ ɔyi lambɨ je ləde ə awi kadɨ tɨləi kəm dəw kɨ aw tə taa dəne kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","NJé kɨ mi əi mbə je ə njé kɨ mi əi njé kəm-kaa je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","NJé kɨ mbə je ɔyi lambɨ je ləde nə uni yɨbɨ kɨ rangɨ dɔ made tɨ al, ");
INSERT INTO bjvNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","nə njé kəm-kaa je, ɔyi lambɨ je ləde kɨ yɨbɨ kɨ rangɨ dɔ made tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","NGa nɨngə, lokɨ dəw kɨ aw tə taa dəne ka kɨn re law al, ɓi rade adɨ toi ɓi. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ə dan lo tɨ, ndu dəw ɓa ə nə: “Oi nje taa dəne ka ə am, ɨtḛḛi ɨtɨləi kəme.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lo kɨn tɨ, ngan mandɨ je ka kɨn pətɨ ndəli dɔ ɓi tɨ, ɨndəi dɔ lambɨ je ləde dana. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɨngə njé kɨ mbə je əli njé kəm-kaa je əi nə: “Adi-je yɨbɨ lambɨ ləsi ndə̰y, nə lambɨ je ləje ɨsɨ oyi.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ə njé kəm-kaa je əli-de əi nə: “Jagɨ, a asɨ kadɨ j-əi səsi dɔ tɨ al, ə awi rɔ njé gatɨ nḛ tɨ ɨndogi ya̰si.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ə lokɨ mbə je awi lo ndogɨ yɨbɨ lambɨ tɨ nɨngə, nje taa dəne re tḛḛ. NJé kɨ ɨsi dɔ njade tɨ, uri sie kəy taa-naa tɨ, adɨ uti ta kəy dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Go tɨ gogɨ ɓəy taa njé kɨ nungɨ ka kɨn ḭḭ no̰o̰ rəi ya̰de, əli əi nə: “Ɓaɓe, Ɓaɓe, ɨtḛḛ ta kəy adɨ-je!” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nə nje taa dəne ɨlə-de tɨ ə nə: “Təkɨ rɔjetɨ, adɨ m-əl səsi, m-gər səsi al.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lo kɨn tɨ, Jəju ɨlə dɔ tɨ ə nə: «E be ə, majɨ kadɨ ɨsi dɔ njasi tɨ, tadɔ ɨgəri dɔ ndɔe ə se dɔ kade al. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ta kɨ dɔ Ko̰ɓe tɨ lə Luwə to tə ta lə dɨngəm kɨ ɨsɨ aw mba ə ɓa njé kɨlə je ləne adɨ-de nḛ kɨngə ləne kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Adɨ dəw kare sakɨ la mi, adɨ kɨ nungɨ sakɨ la joo, nɨngə adɨ kɨ nungɨ ɓəy sakɨ la kare tɔ. Adɨ dəw kɨ ra kɨ go tɔge tɨ, ɓa ɔtɨ aw mba. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Be ə, nje kɨlə kɨ ɨngə sakɨ la mi, aw ra-n gatɨ, ɨngə sakɨ la mi dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be tɔ ə, e kɨ ɨngə joo, ra, ɨngə joo dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nə e kɨ ɨngə sakɨ la kare, aw ur ɓe, dɨbɨ la tɨ kɨ ɓae ade ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«NGata nɨngə, dɔkagɨlo ngay go tɨ, ɓa njé kɨlə je ka kɨn ḭ no̰o̰ re. Lokɨ re ɓa, dəjɨ-de kadɨ ɔji kandɨ kɨlə je ləde kɨ rai no̰ne tɨ kadɨ n-oo. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lo kɨn tɨ, e kɨ ɨngə sakɨ la mi ka kɨn, re no̰ ɓane tɨ kɨ sakɨ la kɨ rangɨ mi dɔ tɨ, nɨngə əl-e ə nə: “Ɓam, sakɨ la kɨ mi kɨ adɨ-m ka, yə m-ra be m-ɨngə mi dɔ tɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ə Ɓae əl-e ə nə: “Majɨ ngay, ḭ nje kɨlə kɨ majɨ kɨ a dana. Təkɨ a-n dana me nḛ tɨ kɨ ndə̰y be ka kɨn ə, m-a m-ɨndə-i dɔ nḛ je tɨ kɨ ngay tɔ. Ɨre, ɨra səm rɔnəl.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","E kɨ ɨngə sakɨ la joo ka kɨn, re no̰ ɓane tɨ kɨ sakɨ la kɨ rangɨ joo dɔ tɨ nɨngə əl-e ə nə: “Ɓam, sakɨ la kɨ joo kɨ adɨ-m ka, yə m-ra be m-ɨngə joo dɔ tɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ə Ɓae əl-e ə nə: “Majɨ ngay, ḭ nje kɨlə kɨ majɨ kɨ a dana. Nɨngə təkɨ a-n dana me nḛ tɨ kɨ ndə̰y be ka kɨn ə, m-a m-ɨndə-i dɔ nḛ je tɨ kɨ ngay tɔ. Ɨre, ɨra səm rɔnəl.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ta tɔl tae tɨ, e kɨ ɨngə sakɨ la kare ka kɨn, re no̰ ɓane tɨ əl-e ə nə: “Ɓam, m-gər kadɨ ḭ dəw kɨ nga̰ ngay: lo kɨ ɨdɨbɨ nḛ tɨ al ka ɨtətɨ nɨm, lo kɨ ɨnajɨ nḛ tɨ al ka ɔy nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nḛ kɨn ə m-ɓəl, adɨ m-aw m-ɓɔyɔ la kɨ adɨ-m ka kɨn nangɨ. Nɨngə kɨ ɓasɨne kɨn, nḛ ləi ə to kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lo kɨn tɨ, ɓae əl-e ə nə: “Ḭ nje kɨlə kɨ majal, ḭ nje dabɨ! Ḭ ɨgər majɨ kadɨ lo kɨ m-dɨbɨ nḛ tɨ al ka m-tətɨ nɨm, lo kɨ m-najɨ nḛ tɨ al ka m-ɔy nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","NGa ə re be kɨn ɓa, re a ɨndə la ləm rɔ njé ngəm la je tɨ, ə təkɨ m-təl kɨn ɓa, re m-a m-taa kɨ mane dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ɨtaai sakɨ la kɨ kare kɨ jie tɨ kɨn adi e kɨ aw kɨ sakɨ la dɔgɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tadɔ dəw kɨ aw kɨ nḛ jine tɨ, a adi-e dɔ tɨ kadɨ to-e mbar mbar, nə dəw kɨ nḛ lie goto, e kɨ ndɨkɨri wa kɨ aw-n kɨn ka a taai jie tɨ wa ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nɨngə e kɨ e nje kɨlə kɨ ndae goto, ɨləi-e taga lo kɨ ndul tɨ kɨ kadɨ a no̰ tɨ je, a ngə ngangɨne tɨ je.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jəju əl ɓəy ə nə: «Lokɨ mi *NGon dəw m-a m-re me tɔgɨ tɨ kɨ ətɨ ɓəl, kɨ malayka je pətɨ gom tɨ kɨn ɓa, m-a m-ɨsɨ dɔ kɨmbər ngar tɨ ləm me tɔɓa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nɨngə gɨn ɓe je kɨ dangɨ dangɨ a kawi-naa kɨ no̰m tɨ. M-a m-ɔr kəm dɨje naa tɨ təkɨ nje nḛ kul je a ɔr-n kəm batɨ je kɨ bɨyə̰ je naa tɨ kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","M-ɨndə batɨ je dɔ ji ko̰m tɨ, ə m-a m-ɨndə bɨyə̰ je dɔ ji gəlm tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lo kɨn tɨ, ngar a əl njé kɨ dɔ ji kone tɨ ə nə: “Ɨrəi, səi kɨ Bai ɨndə jine dɔsi tɨ kɨn, ə ɨtaai ko̰ɓe kɨ Luwə ɨndə dɔe naa tɨ mbata tɨ ləsi lo kɨlə ngɨrə dɔra̰ kɨ dɔnangɨ tɨ nu kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","MBata ɓo ra-m ə adi-mi nḛ m-uso; kɨndə ra-m ə adi-mi man m-a̰y; mi mba ə uwəi-mi kɨ rɔsi tɨ; ");
INSERT INTO bjvNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","m-a kɨ rɔm kare ə adi-mi kɨbɨ m-ɨlə rɔm tɨ; rɔm to-m ə ɨrai səm; m-to dangay tɨ ə ɨrəi oi-mi.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","NGa ə njé ra go ndu Luwə tɨ a ɨləi-e tɨ əi nə: “Ɓaɓe, kadɨ ban tɨ ə j-o-i ɓo ra-i ə j-adi nḛ uso ə? Kɨndə ra-i ə j-adi man a̰y ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ḭ mba ə j-uwəi kɨ rɔje tɨ ə? A kɨ rɔi kare ə j-adi kɨbɨ ɨlə rɔi tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Rɔi to-i ə jɨ ra səi ə? Ɨto dangay tɨ ə jɨ re j-o-i ə?” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ə ngar əl njé ra go tɨ je ə nə: “Təkɨ rɔjetɨ, adɨ m-əl səsi, dɔkagɨlo je pətɨ kɨ ɨrai nḛ je kɨn kɨ kɨ du ngay dan ngakom je tɨ kɨ oi-de kam ɓa, e mi ə ɨrai səm.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Nɨngə go tɨ, ngar a əl njé kɨ ai dɔ ji gəlne tɨ ə nə: “Ɔti sa̰y kɔ rɔm tɨ, səi dɨje kɨ ndɔl e dɔsi tɨ! Awi me por tɨ kɨ gɨne a gangɨ al, kɨ Luwə ɨndə dɔe dana mbata tɨ lə su əi kɨ malayka je ləne kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","MBata ɓo ra-m, ə adi-mi nḛ m-uso al; kɨndə ra-m, ə adi-mi man m-a̰y al; ");
INSERT INTO bjvNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mi mba ə uwəi-mi kɨ rɔsi tɨ al; m-a kɨ rɔm kare ə adi-mi kɨbɨ m-ɨlə rɔm tɨ al; rɔm to-m ə ɨrai səm al; m-to dangay tɨ ə ɨrəi oi-mi al.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ɓa əi je ka a ɨləi-e tɨ əi nə: “NGa Ɓaɓe, kadɨ ban tɨ ə j-o-i ɓo ra-i ə j-adi nḛ uso al, ə se kɨndə ra-i ə j-adi man a̰y al ə? Ḭ mba, ə se a kɨ rɔi kare, ə se rɔi to-i, ə se ɨto dangay tɨ ə jɨ mbatɨ ra səi ə?” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ə ngar a ɨlə-de tɨ ə nə: “Təkɨ rɔjetɨ, adɨ m-əl səsi, dɔkagɨlo je pətɨ kɨ ɨrai nḛ je kɨn kɨ kɨ du ngay dan ngakom je tɨ kɨ oi-de kam, al ɓa, mi ka ɨrai səm al jagɨ tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lo kɨn tɨ, njé ra go tɨ al, a awi lo ko̰ tɨ kɨ gɨne a gangɨ al, ə njé ra go ndu Luwə tɨ je a awi lo kajɨ tɨ kɨ bɨtɨ kɨ no̰ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lokɨ Jəju tɔl ta nḛ ndo je ləne ɓa, əl njé ndo je ləne ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ɨgəri kadɨ ndɔ joo par ə, ndɔ ra nay Pakɨ a asɨ, kadɨ dɨje a ɨləi-mi *NGon dəw ji dɨje tɨ kadɨ a ɓəi-mi kagɨ-dəsɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lo kɨn tɨ no̰o̰, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je lə *Jɨpɨ je, kawi-naa natɨ lo tɨ lə Kayɨpɨ kɨ e kɨ boy lə njé kɨjə nḛ məsɨ kadɨ-kare je. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nɨngə ɨndəi ndude naa tɨ kadɨ n-uwəi Jəju gɨdɨ ngə̰y n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ɓa əli-naa əi nə: «Adɨ j-uwəi-e ndɔ ra nay tɨ al, nə tə j-ḭḭ j-osi me wongɨ tɨ lə dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jəju e me ɓe tɨ kɨ Bətani, me kəy tɨ lə Sɨmo̰ kɨ kəte e nje banjɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nɨngə dəne madɨ re rɔ Jəju tɨ kɨ ku mbal kɨ ɓari-e albatɨr kɨ yɨbɨ kɨ ətɨ majɨ rosɨ. E yɨbɨ kɨ gate e ngay. Nɨngə lokɨ Jəju ɨsɨ uso nḛ ɓa, ur yɨbɨ ka kɨn dɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ə lokɨ njé ndo je ooi nḛ kɨn be ɓa, nəl-de al, adɨ əli əi nə: «Kəm tujɨ yɨbɨ kɨn kɔ be e ri ə? ");
INSERT INTO bjvNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Asɨ kadɨ dəw ɨyə̰ taa-n la kɨ ngay ə un ra-n kɨ njé ndoo je!» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jəju oo ta kɨ ɨsɨ əli be ɓa, əl-de ə nə: «MBa ri ə ɨsɨ njɨbəi dəne kɨn ə? Nḛ kɨ ra dɔm tɨ kɨn e kɨlə kɨ majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","NJé ndoo je kam, ɨsi səsi ne kɨ ndɔ je pətɨ, nə mi m-a m-ɨsɨ səsi kɨ no̰ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yɨbɨ kɨ ətɨ majɨ kɨ ur dɔm tɨ kɨn, ur ra-n go darɔm kɨ a aw ɓada. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nɨngə adɨ m-əl səsi ta kɨ rɔjetɨ: lo je pətɨ dɔnangɨ tɨ ne, kɨ dɨje a ɨləi mbḛ Poy Ta kɨ Majɨ kɨn tɨtɨ, a ɔri poy nḛ kɨ dəne ra kɨn kadɨ mede ole-n dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dəw kare kɨ mbo̰ njé ndo je tɨ lə Jəju kɨ dɔgɨ gɨde joo, kɨ tɔe nə Judasɨ Isɨkarɨyotɨ aw ɨngə njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, ");
INSERT INTO bjvNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","əl-de ə nə: «Kɨn ə m-ɨlə Jəju jisi tɨ ə a adi-mi ri ə?» Ɓa əi je tɨdəi la sɨlə kutɨ mɨtə adi-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ɨlə ngɨre loe tɨ kɨn no̰o̰, Judasɨ ɨsɨ sangɨ dɔkagɨlo kɨ to kadɨ ɨlə-n Jəju jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","NDɔ kɨ dɔsa̰y lə ra nay kuso mapa kɨ əm ɔde al, njé ndo je lə Jəju rəi dəji-e əi nə: «Lo kɨ ra be ə ɨndɨgɨ kadɨ j-aw jɨ ra nḛ kuso Pakɨ tɨtɨ j-adi ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ə Jəju əl-de ə nə: «Awi me ɓe bo tɨ kam, ɓe lə dəw kɨ be, ə əli-e əi nə: “NJe ndo dɨje ə nə: ‹Dɔkagɨlo ləm e ɓasi, nɨngə e ɓe ləi ə m-a m-ra pakɨ tɨ kɨ njé ndo je ləm›.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","*NJé ndo je awi rai təkɨ Jəju əl-n-de, adɨ rai nḛ kuso Pakɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lokɨ kadɨ ur, Jəju ɨsɨ ta nḛ kuso tɨ kɨ njé ndo je ləne kɨ dɔgɨ gɨde e joo. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lokɨ ɨsɨ usoi nḛ, Jəju əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kare dansi tɨ ne a ɨlə-m ji dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lo kɨn tɨ, me njé ndo je tɔsɨ-de, adɨ dəji ta Jəju kare kare əi nə: «E mi ɓe, Ɓaɓe?» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ə Jəju ɨlə-de tɨ ə nə: «Dəw kɨ ɨlə jine səm naa tɨ me ka tɨ kɨn ə, dəwe a ɨlə-m ji dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mi *NGon dəw m-a m-oy təkɨ ndangi me makɨtɨbɨ tɨ lə Luwə, nə kəm-to-ndoo e lə dəw kɨ a ɨlə-m mi NGon dəw ji dɨje tɨ. Dəwe kɨn, koje al wa ka e sotɨ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasɨ kɨ a ɨlə Jəju ji dɨje tɨ ka kɨn, dəjɨ Jəju ə nə: «E mi ɓe, NJe ndo dɨje?» Ə Jəju ɨle tɨ ə nə: «Tḛḛ tai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lokɨ ɨsi ta nḛ kuso tɨ, Jəju un mapa, ra oyo Luwə dɔ tɨ, uwə tətɨ naa tɨ, təl-n adɨ njé ndo je, nɨngə əl-de ə nə: «Ɨtaai usoi, e kɨn e darɔm.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Go mapa tɨ, Jəju un kɔpɨ kasɨ kandɨ nju, ra oyo Luwə dɔ tɨ, nɨngə təl-n adɨ njé ndo je ə nə: «Ɨtaai, a̰yḭ-naa pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","E kɨn e məsɨm, məsɨ kun mɨndɨ kɨ sɨgɨ kɨ a a̰y mbata kosɨ dɨje, mba kɨyə̰ go majal je ləde kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nɨngə adɨ m-əl səsi, m-a m-a̰y kasɨ kandɨ nju kɨ rangɨ al, bɨtɨ kadɨ m-a m-a̰y səsi kɨ sɨgɨ me ɓeko̰ tɨ lə Bai.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lokɨ osi pa kɨlə tɔjɨ dɔ Luwə tɨ gɨne gangɨ, tḛḛi awi dɔ mbal kagɨ bɨni je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nɨngə Jəju əl njé ndo je ləne ə nə: «Kondɔ ne wa kɨn, a ɨmbati-mi pətɨ, tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “M-a m-tɔl ɓa batɨ je, nɨngə kosɨ batɨ je a sanəi-naa kɨ lo lo.” ");
INSERT INTO bjvNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nə lokɨ m-a m-ḭ lo koy tɨ, m-a m-aw kəte no̰si tɨ, tə ngəm səsi Galile tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lo kɨn tɨ, Pɨyər un ta əl Jəju ə nə: «Re dɨje pətɨ ə ɨyə̰i-ni kɔ ka, mi m-a m-ɨyə̰i kɔ al jagɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ə Jəju təl əl-e ə nə: «Təkɨ rɔjetɨ, adɨ m-əli, me kondɔ tɨ ne wa kɨn, kəte ɓəy taa kadɨ kunə kɨnjə no̰, a najɨ ta nja mɨtə ə nə ɨgər-m al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nə Pɨyər əl-e ə nə: «Re e-n koy ka m-a m-oy səi, ɓɨ m-a najɨ ta gəri, al ratata.» Nɨngə ndəgɨ njé ndo je pətɨ əli ko ta wa kɨ Pɨyər əl ka kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Go tɨ, Jəju əi kɨ njé ndo je ləne ɔti rəi lo tɨ madɨ kɨ ɓari-e nə Jətɨsəmane. Jəju əl-de ə nə: «Ɨsi lo kɨn tɨ ne be ɨngəmi-mi, dɔkagɨlo tɨ kɨ m-a m-aw nu kadɨ m-əl ta kɨ Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jəju adɨ Pɨyər əi kɨ ngan lə Jəbəde kɨ joo awi sie. Lo kɨn tɨ, me-ko̰ kɨ ɓəl kɨ me ndɨl tɨ ɨlə ngɨrə ra Jəju, ");
INSERT INTO bjvNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","adɨ əl-de ə nə: «Me-ko̰ rosɨ mem rosɨ kɨ asɨ koy. Ɨsi lo kɨn ne be, ɨsi səm kəm ɓɨ ɨtoi ɓi al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jəju ɔtɨ kɨ kəte ndə̰y nɨngə, osɨ kɨ ta kəmne nangɨ, əl ta Luwə ə nə: «Bai, re to ban ə, ɔsɨ ko̰ kɨn adɨ də ngərəngɨ rɔm tɨ! Nə ke ə kadɨ e kɨ go ndɨgɨ tɨ ləm al, nə kɨ go ndɨgɨ tɨ ləi yo taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jəju təl re rɔ njé ndo je tɨ nɨngə ɨngə-de, ɨsɨ toi ɓi, adɨ əl Pɨyər ə nə: «Kɨn ka asi kadɨ ɨsi səm kəm dɔ kadɨ kɨ kare be al bɨtɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɨsi kəm ba, əli ta kɨ Luwə, kadɨ osi me nḛ na tɨ al. NDɨl ndɨgɨ ra nḛ kɨ majɨ, nə darɔ e kɨ to̰.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Təl ɔr nda̰ne səde kɨ ko̰ joo, ɓa əl ta kɨ Luwə ə nə: «Bai, kɨn ə re ko̰ kɨn, sɔbɨ kadɨ m-ɨngə ɓɨ lo kɔse ngərəngɨ rɔm tɨ goto ɓa, kadɨ ɨra ndɨgɨ ləi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lokɨ təl re rɔ njé ndo je tɨ nɨngə, ɨngə-de ɨsɨ toi ɓi ɓəy, kəmde ɔy dɨrɨri. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jəju ɨyə̰-de ə təl ɔr nda̰ne ɓəy, əl ta kɨ Luwə kɨ ko̰ mɨtə, un go mɨndɨne kɨ kəte ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Go tɨ, təl re rɔde tɨ əl-de ə nə: «Ɨtoi ta ɓi tɨ ne, ɨsɨ ɔri kə̰ə̰ ɓəy a? Dɔ kadɨ kɨlə-m mi *NGon dəw ji njé ra majal je tɨ asɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ḬḬ taai adɨ j-awi, nje kɨlə-m ji dɨje tɨ ə re am!» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lokɨ ta nay kɨ ta Jəju tɨ ba ɓəy nɨngə, Judasɨ, kɨ e kɨ kare dan njé ndo je tɨ kɨ dɔgɨ gɨde e joo ɨsɨ re. Re kɨ kosɨ dɨje ngay gone tɨ. Dɨje kɨ njé kuwə kɨyə kasɨgar je, njé kuwə gɔl jide tɨ je. Kosɨ je kɨn, e njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je lə *Jɨpɨ je ə ɨləi-de. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasɨ kɨ nje kun dɔ Jəju, əl-de nḛ kɨ n-a n-ra kadɨ tə gəri Jəju ə nə: «Dəw kɨ m-a m-uwe rɔm tɨ rututu kɨn ɓa, e darɔe ə wa ən ə, uwəi-e.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E be ə, re tḛḛ taa par ə, sɔbɨ Jəju əl-e ə nə: «M-uwə ji, NJe ndo dɨje!» Nɨngə, uwe rututu kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ə Jəju əl-e ə nə: «Madɨm, ɨra nḛ kɨ ɨre kadɨ ɨra.» Ɓa loe tɨ no̰o̰, dɨje ɨndəi jide dɔ Jəju tɨ uwəi-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nɨngə yə, kɨ kare dan njé kɨ əi naa tɨ kɨ Jəju, ɨndə jine dɔ kɨyə kasɨgar ləne, ɔr tɨgə-n paja lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, ɓa tɨgə mbie latɨ gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nə Jəju əl-e ə nə: «Ɨlə kɨyə kasɨgar ləi toe tɨ gogɨ, mbata dɨje kɨ njé rɔ kɨ kɨyə kasɨgar a tuji-de kɨ kɨyə kasɨgar tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Se o kadɨ m-asɨ kadɨ m-dəjɨ tɔgɨ Bai, ə a ɨlə kɨ kosɨ malayka je dɨbɨ kutɨ ba̰y ba̰y kadɨ rəi rɔ ləm al wa? ");
INSERT INTO bjvNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nə kɨn ə re e be ə, lo kadɨ makɨtɨbɨ lə Luwə kɨ əl ə nə nḛ je a rai nḛ be kɨn tɔl ta nḛ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Go tɨ, Jəju əl kosɨ je ə nə: «To tə nḛ kɨ mi nje ɓogɨ, ə ɨrəi kɨ kɨyə kasɨgar je, kɨ gɔl je taa kadɨ uwəi-mi be? NDɔ je pətɨ, mi səsi naa tɨ gɨn kəy tɨ lə Luwə, m-ndo dɨje nḛ, ka uwəi-mi al. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nə nḛ je kɨn pətɨ rai nḛ be ɓone mba kadɨ ta lə njé kəl ta kɨ ta Luwə tɨ kɨ ndangi, tɔli tade.» Lo kɨn tɨ, njé ndo je lie pətɨ a̰yḭ-naa ə ɨyə̰i-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","NJé kuwə Jəju je, awi sie no̰ kɨ bo tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ tɔe nə Kayɨpɨ. E lo kɨ njé ndo ndu-kun je, kɨ ngatɔgɨ je lə *Jɨpɨ je kawi-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pɨyər ə yə adɨ nda̰e ngal, ɓa njɨyə-n go Jəju tɨ, ndə̰y, ndə̰y, bɨtɨ re ur-n gode tɨ, natɨ lo tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ka kɨn. Re ɨsɨ naa tɨ kɨ paja je kadɨ n-oo se ne kɨn a tɔl tane ban wa. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé gangɨ ta je lə Jɨpɨ je ba pətɨ, sangi rəbɨ kadɨ n-ɨngəi dɨje kɨ njé tətɨ ta kɨ ngom dɔ Jəju tɨ, kadɨ n-gangii ta koy dɔe tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nə ɨngəi-de al. Dɨje ngay kɨ njé tətɨ ta rəi əli ta kɨ ngom dɔe tɨ kɨn ka, asɨ-naa tɨ al. Ta tɔl tae tɨ, dɨje joo rəi əli əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Dɨngəm kɨn əl ə nə: “M-asɨ kadɨ m-tujɨ kəy lə Luwə kɔ, ə m-təl m-ɨndə gogɨ me ndɔ tɨ kɨ mɨtə.”» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ḭ taa əl Jəju ə nə: «Ta madɨ kɨ kadɨ əl dɔ ta tɨ kɨ dɨje a əli dɔi tɨ kam goto a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nə Jəju a tane mbə. Ə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je əl Jəju ə nə: «Kɨ tɔ Luwə kɨ nje kɨsɨ kəm ba, m-dəji kadɨ əl-je se ḭ, ə ḭ Kɨrɨsɨ kɨ Luwə mbəte, kɨ e NGon lə Luwə wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ə Jəju əl-e ə nə: «Tḛḛ tai tɨ! NGa nɨngə m-əl səsi taga wangɨ m-adɨ oi təkɨ kaw kɨ kəte no̰o̰, a oi-mi *NGon dəw m-ɨsɨ dɔ ji ko̰ Luwə tɨ kɨ nje tɔgɨ, m-a m-ḭ dɔra̰ tɨ m-re me kɨl ndi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lo kɨn tɨ, kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je tɨl kɨbɨ je kɨ rɔne tɨ, ɓa əl ə nə: «Əl ta kɨ mal dɔ Luwə tɨ. E kɨn, jɨ sangi kadɨ dəw madɨ kɨ rangɨ taa əl ta dɔe tɨ ɓəy a? Səi je wa oi ndue kɨ əl-n ta kɨ mal dɔ Luwə tɨ adɨ oi kɨ mbisi ne. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta ləsi kɨ dɔe tɨ e ri ə?» Ɓa dɨje ɨləi-e tɨ əi nə: «E dəw kɨ sɔbɨ koy.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɨngə tɨbi man tade kəme tɨ je, ɓɨri jide ɔsi-e-n je. Taa njé kɨ na̰ je tɨndəi mbɔe je tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɓa əli-e əi nə: «Je ɓa, jɨ dəji, ḭ Kɨrɨsɨ kɨ Luwə mbəte, kadɨ ɨra nje ndo̰ ndɨl, ə ɨɓa tɔ dəw kɨ ɨndəi adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lokɨ Pɨyər ɨsɨ nangɨ ta mbalo tɨ, tagane nɨngə, dəne kare kɨ dan dəne je tɨ kɨ njé ra kɨlə me kəy tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je re rɔ Pɨyər tɨ əl-e ə nə: «Ḭ ka, ḭ kɨ Jəju, dɨngəm kɨ Galile tɨ kɨn tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nə Pɨyər najɨ ta kəm dɨje pətɨ ə nə: «Jagɨ, m-gər me ta ləi kɨ ɨge kəl kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Go tɨ, Pɨyər ɔtɨ ɨsɨ aw kɨ ta ndogɨ tɨ be, nɨngə dəne kɨ rangɨ kare, kɨ nje ra kɨlə me kəy tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je oo-e, ɓa əl njé kɨ ai loe tɨ no̰o̰ ə nə: «Dəw kam e kɨ Jəju kɨ Najarətɨ tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ə nja kare ɓəy Pɨyər najɨ ə nə: «Jagɨ, təkɨ rɔjetɨ, m-gər dɨngəm kɨn al!» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ɓa njaba go tɨ ə, dɨje kɨ ai səde no̰o̰, ɔti kɨ rɔ Pɨyər tɨ əli əi nə: «Təkɨ rɔjetɨ, ḭ ka, ḭ kɨ kare dan dɨje tɨ lie tɔ, taa ndui kɨ ɨsɨ əl-n ta wa kɨn ka tɔjɨ kadɨ ḭ dəw lie.» ");
INSERT INTO bjvNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ə lo kɨn tɨ, Pɨyər ɨbɨ rɔne kɨ ta kɨ nga̰ ngay ə nə: «M-ɨbɨ rɔm kadɨ Luwə ra səm nḛ kɨ nga̰, re m-əl ta kɨ ngom. M-gər dɨngəm kɨn al.» Ɓa ta naa tɨ no̰o̰, kunə kɨnjə no̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","NGa nɨngə me Pɨyər ole dɔ ta tɨ kɨ Jəju əl-e ə nə: «Kəte taa kadɨ kunə kɨnjə no̰, a najɨ ta nja mɨtə ə nə ɨgər-m al,» ka kɨn, adɨ Pɨyər ɨndə lo tḛḛ taga, no̰ kɨ man kəmne. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lokɨ lo ti, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je pətɨ, kɨ ngatɔgɨ je lə *Jɨpɨ je, ɨngəi-naa, uni ndude kadɨ n-tɔli Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Be ə, dɔɔi Jəju, awi sie ɨləi-e ji *Pɨlatɨ tɨ, dəw kɨ Rom tɨ kɨ e nje ko̰ɓe dɔnangɨ Jude tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lokɨ Judasɨ kɨ nje kun dɔ Jəju kadɨ-de oo kadɨ gangi ta koy dɔ Jəju tɨ ɓa, me uwe kɨ ta adɨ təl kɨ la kɨ sɨlə kutɨ mɨtə aw-n adɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je lə *Jɨpɨ je, ka kɨn, ");
INSERT INTO bjvNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nɨngə əl-de ə nə: «M-ra majal, m-un dɔ dəw kɨ ra nḛ madɨ al.» Ə əi je əli-e əi nə: «Ta kare kɨ usɨ-je tɨ no̰o̰ goto. E kɨn e ta ləi ḭ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lo kɨn tɨ no̰o̰, Judasɨ ɔtɨ ɨlə la kɨ adi-e ka kɨn me kəy tɨ lə Luwə, ə aw ɨlə kɨlə. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je ɔyi la ka kɨn nɨngə əli əi nə: «E go rəbe tɨ al kadɨ jɨ ɓukɨ la kɨn dɔ made tɨ kɨ me kəy tɨ lə Luwə, tadɔ e la məsɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Be ə, go ndude tɨ kɨ osɨ go-naa tɨ, uni la ka kɨn ndogi lo ndɔr lə nje kɨbə ngoo, rai tə lo dɨbɨ mba je. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E mbata kɨn ə, bɨtɨ ɓone ka ɨsɨ ɓari lo ka kɨn «lo məsɨ». ");
INSERT INTO bjvNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lo kɨn tɨ, ta kɨ nje kəl ta kɨ ta Luwə tɨ Jərəmi əl ə nə: «Taai sɨlə kutɨ mɨtə ba par tə la kɨ ngan *Isɨrayəl je ɔji dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Adi la kɨn ndogi lo lə nje kɨbə ngoo, təkɨ Ɓaɓe əl-m.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jəju a no̰ nje ko̰ɓe, *Pɨlatɨ tɨ, ə nje ko̰ɓe dəje ə nə: «Ḭ ngar lə *Jɨpɨ je a?» Ə Jəju əl-e ə nə: «E ta kɨ tḛḛ tai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Me ta je tɨ lə njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ ngatɔgɨ je kɨ ɨsɨ təti dɔ Jəju tɨ kɨn, Jəju tḛḛ tane ɨlə-de tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ə no̰o̰ be, Pɨlatɨ əl Jəju ə nə: «O ta je pətɨ kɨ dɨje a ɨndəi dɔi tɨ kam al a?» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Jəju tḛḛ tane ɨle tɨ al, adɨ ndɔje ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dɔ ɓal je pətɨ, lo ra nay Pakɨ tɨ, nje ko̰ɓe a ɔr dangay kare ɨle taa, adɨ e dəw kɨ kosɨ je dəji-e kadɨ ɔr-e dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nɨngə dɔkagɨloe tɨ kɨn, dangay madɨ kare kɨ dɨje əli ta lie ngay kɨ tɔe nə Barabasɨ e no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","*Pɨlatɨ dəjɨ kosɨ je kɨ kawi-naa no̰o̰ ə nə: «Na̰ ə ɨgei kadɨ m-ɨyḛ taa m-adɨ səsi ə? Jəju Barabasɨ ə se Jəju kɨ e *Dəw kɨ Luwə mbəte ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pɨlatɨ dəjɨ ta kɨn be mbata gər majɨ kadɨ e ni ə ra-de dɔ Jəju tɨ ə ɨləi-e jine tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lokɨ Pɨlatɨ ɨsɨ lo gangɨ ta tɨ, nee adɨ əli-e ə nə: «Ɨndə rɔi me ta tɨ lə dəw kɨ dana kam al, tadɔ kondɔ ne m-ɨngə ko̰ ngay me ni tɨ mbata lie.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je lə *Jɨpɨ je suləi kosɨ je adɨ dəji Pɨlatɨ kadɨ ɔr Barabasɨ adɨ-de ə tɔl Jəju kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","NJe ko̰ɓe təl un ta dəjɨ-de ə nə: «Na̰ dan dɨje tɨ kɨ joo kɨn ə ɨgei kadɨ m-ɔr-e dangay tɨ m-adɨ səsi ə?» Ɓa ɨləi-e tɨ əi nə: «Barabasɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ə Pɨlatɨ, dəjɨ-de ə nə: «NGa ri ə kadɨ m-ra kɨ Jəju kɨ ɓari-e Dəw kɨ Luwə mbəte ə?» Ɓa pətɨ əli əi nə: «E ɓa, sɔbɨ ɓe kagɨ-dəsɨ tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ə Pɨlatɨ təl dəjɨ-de ə nə: «E ri kɨ majal ə ra ə?» Nə uni ndude kɨ taa ngay ɓəy əli əi nə: «Sɔbɨ ɓe kagɨ-dəsɨ tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lokɨ Pɨlatɨ oo kadɨ nḛ madɨ kɨ kadɨ n-a n-ra goto, taa dɨje ɨsɨ rai adɨ nga̰ kɨ dɔ made tɨ ɓəy, un man togɨ-n jine ta kəm kosɨ je tɨ, nɨngə əl-de ə nə: «Ta məsɨ dəw kɨ dana kam e dɔm tɨ al. E ta ləsi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɨngə dɨje pətɨ ɨləi-e tɨ əi nə: «Kadɨ ta məse e dɔje tɨ kɨ dɔ nga ləje je tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be ə, Pɨlatɨ ɔr Barabasɨ adɨ-de, nga nɨngə Jəju taa adɨ ɨndəi-e kɨ ndəy kabɨlay, ɓa ɨle ji asɨgar je tɨ kadɨ ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Asɨgar je lə *Pɨlatɨ awi kɨ Jəju me lo tɨ kɨ boy kɨ Pɨlatɨ ɨsɨ tɨ wa kɨn, lo tɨ kɨ ɓari-e pɨrətuwar, nɨngə kawi ndəgɨ asɨgar je pətɨ kɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","MBa kadɨ tə ɨbəi-e kogii, ɔri kɨbɨ lie, ə ɨləi kɨbɨ ngal kɨ kər rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oji jɔgɨ kon ɨləi dɔe tɨ, ə ɨləi gakɨra ji ko̰e tɨ tɔ, ɓa ɔsi məkəsɨde nangɨ no̰e tɨ ə mbəi sie əi nə: «Lapɨya ngar lə *Jɨpɨ je!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tɨbi man tade dɔe tɨ, taai gakɨra jie tɨ, ɨndəii dɔe. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lokɨ ɨbəi-e kogii asɨ-de nɨngə, ɔri kɨbɨ ngal kɨ kər ka kɨn rɔe tɨ kɔ, ə təli ɨləi kɨbɨ je lie wa rɔe tɨ gogɨ, ɓa awi sie kadɨ ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lokɨ asɨgar je ɨsɨ tḛḛi me ɓe bo tɨ kɨ taga nɨngə, ɨngəi dɨngəm kare kɨ Sɨrən tɨ, kɨ tɔe nə Sɨmo̰. Uwəi-e, ɨndəi tɔgɨ dɔe tɨ adɨ otɨ kagɨ-dəsɨ lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Awi tḛḛi lo madɨ tɨ kare to no̰o̰, ɓari-e nə Golgota, kɨ kɔr me nə: «Lo kɨ to tə ka dɔ dəw be.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Adi-e kasɨ kandɨ nju kɨ bui naa tɨ kɨ nḛ kɨ atɨ kadɨ Jəju a̰y, ə lokɨ ɔdɨ tane tɨ ɓa, mbatɨ ka̰y. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Asɨgar je ka kɨn ɓəi Jəju kagɨ-dəsɨ tɨ, nɨngə tɨgəi kɨr (mbare) dɔ kɨbɨ je tɨ lie, ləbi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Go tɨ, təli ɨsi no̰o̰, ɨsɨ ngəmi tae. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","NDangi me batɨ, nḛ kɨ ra ə n-ɓəi-e-n kagɨ-dəsɨ tɨ, ɨndəi dɔe tɨ taa əi nə: «Dəw kam e Jəju, ngar lə *Jɨpɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Loe tɨ no̰o̰, ɓəi njé ɓogɨ je joo kagɨ-dəsɨ tɨ. Kɨ kare dɔ ji ko̰e tɨ ə kɨ nungɨ dɔ ji gəle tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dɨje kɨ nje də rəbə, tɨgəi dɔde, nɨngə taji-e, ");
INSERT INTO bjvNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","əi nə: «Ḭ kɨ nje tujɨ kəy lə Luwə, ə təl ra e kɨ rangɨ me ndɔ tɨ kɨ mɨtə ka kɨn, re ḭ NGon lə Luwə ə, ajɨ rɔi ḭ wa, ə ḭ taa dɔ kagɨ-dəsɨ tɨ ur nangɨ adɨ j-o!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Be tɔ ə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, kɨ ngatɔgɨ je lə Jɨpɨ je ɨbəi Jəju kogii əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ajɨ dɨje kɨ rangɨ, nə e wa asɨ kajɨ rɔne al! NGar lə *Isɨrayəl je ka kam, kaje ə wa kɨ j-a ne kɨn, kadɨ ḭ taa dɔ kagɨ-dəsɨ tɨ ur nangɨ adɨ j-o, nɨngə j-a j-o ta lie tə ta kɨ rɔjetɨ! ");
INSERT INTO bjvNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uwə kul Luwə ən ə, re Luwə ndɨge ə, kadɨ taa-e ɨle taa adɨ j-o. MBata əl ə nə: “Mi NGon lə Luwə”.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Taa baw kaya je kɨ ɓəi-de kagɨ-dəsɨ tɨ naa tɨ sie ka kɨn ka taji-e kae tɨ wa kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ɨlə ngɨre kadɨ tɨ kɨ a jam dɔ ɓe tɨ, lo ndul dɔnangɨ tɨ ba pətɨ, bɨtɨ kadɨ kɨ mɨtə kɨ lo sɔlɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dɔ kadɨ tɨ kɨ mɨtə, Jəju no̰ kɨ ndune kɨ bo ə nə: «Eli, Eli, lama sabatani?» Kɔr me nə: «Luwə ləm, Luwə ləm, mbari ə ɨyə̰-m kɔ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dɨje madɨ dan njé tɨ kɨ ai no̰o̰, ooi ndue, nɨngə əli əi nə: «Oi dəw ka yə a ɓar Eli!» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɨngə kalangɨ ba, dəw kare dande tɨ, a̰y ngɔdɨ, un nḛ kɨ to hom hom, ɨlə me man kandɨ ndu tɨ kɨ masɨ, nɨngə ɨlə ta gakɨra tɨ adɨ Jəju kadɨ a̰y. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nə ndəge je əli əi nə: «Ɨngəm adɨ j-o se Eli a re aje wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lo kɨn tɨ no̰o̰ be, Jəju təl no̰ kɨ ndune kɨ bo ɓəy, nɨngə kə̰ə̰e tḛḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ɓa go tɨ, kɨbɨ gangɨ lo kɨ a me kəy tɨ lə Luwə, tɨl dana joo, ḭ taa nu bɨtɨ re nangɨ. Dɔnangɨ yəkɨ, taa mbal je ka ta̰i dana tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta dɔ ɓadɨ je tḛḛi, adɨ dɨje ngay kɨ adi mede Luwə ḭḭ taa lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Go tɨ gogɨ, lokɨ Jəju tḛḛ lo koy tɨ ɓa, dɨje ka kɨn awi me ɓe tɨ kɨ Jorijaləm kɨ e ɓe bo kɨ ay njay. Dɨje ngay ooi-de kɨ kəmde. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lokɨ kɨ bo kɨ dɔ ɓutɨ asɨgar je tɨ kɨ ɓu əi kɨ asɨgar je kɨ njé ngəm Jəju kɨ əi sie ooi dɔnangɨ kɨ yəkɨ, kɨ nḛ kɨ ra nḛ kɨn ɓa, ɓəl tɔl-de adɨ əli əi nə: «Təkɨ rɔjetɨ, dəw kɨn e NGon lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dəne je ngay ai no̰o̰, ai sa̰y, ɨndəi kəmde a ooi nḛ je kɨ ɨsɨ rai nḛ. Əi dəne je kɨ uni go Jəju Galile tɨ nu, mba kadɨ rai sie. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dande tɨ, Mari kɨ Magɨdala e no̰o̰ nɨm, Mari kɨ ko̰ Jakɨ əi Jɨsəpɨ nɨm e no̰o̰, taa ko̰ ngan lə Jəbəde ka e no̰o̰ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lokɨ kadɨ aw tə ur, dɨngəm kɨ nje nḛ kɨngə kare kɨ Arɨmate tɨ, kɨ tɔe nə Jɨsəpɨ ḭ no̰o̰ re. E ka e dəw kɨ təl rɔne nje ndo tɨ lə Jəju tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jɨsəpɨ aw rɔ *Pɨlatɨ tɨ dəje nɨn Jəju, ə Pɨlatɨ adɨ ndune kadɨ adi-e. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jɨsəpɨ un nɨn Jəju, dole kɨ ta kɨbɨ kɨ sɨgɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɓa ɨle me ɓe nɨn tɨ kɨ adɨ uri me mbal tɨ ɓasɨne ɓəy mbata ləne wa, nɨngə nduguru mbal kɨ bo ɨlə ta tɨ, ə ɔtɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Loe tɨ kɨn, Mari kɨ Magɨdala əi kɨ Mari kɨ nungɨ əi no̰o̰, ɨsi nangɨ sɔbɨ no̰ ɓadɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo ti go tɨ, kɨ e ndɔ kɨ re go ndɔ kɨndə dɔ nḛ je dana mba ndɔ taa kə̰ə̰ tɨ ɓa, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je awi naa tɨ ɓe lə *Pɨlatɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","əli-e əi nə: «Dəw kɨ bo ləje, meje ole dɔ tɨ təkɨ ndɔ kɨ nje ngom dəwe kɨn əl, dɔkagɨlo tɨ kɨ a-n kɨ dɔne taa ɓəy əl ə nə: “NDɔ kɨ ko̰ mɨtə lə ndɔ koym ɓa, m-a m-ḭ taa lo koy tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ə adɨ ndui adɨ dɨje ngəmi dɔ ɓadɨ bɨtɨ ndɔ kɨ ko̰ mɨtə, nə tə njé ndo je lie rəi ɓogi nɨne, ə təli əli əi nə: “Ḭ lo koy tɨ.” Lo kɨn tɨ, a rai kadɨ ta ngom kɨn a ɨtə kɨ kəte ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ə Pɨlatɨ əl-de ə nə: «Asɨgar je kɨ kadɨ ngəmi ta lo ə ai am, ə awi səde adɨ ngəmi dɔ ɓadɨ təkɨ ɨgei.» ");
INSERT INTO bjvNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lo kɨn tɨ, awi dɔ ɓadɨ tɨ, tɨyə̰i tae, nɨngə ɨndəi asɨgar je kadɨ ngəmi tae. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Go ndɔ taa kə̰ə̰ tɨ, adɨ e ndɔ dɨmasɨ kɨ gɨn lo, Mari kɨ Magɨdala əi kɨ Mari kɨ nungɨ awi kadɨ n-ooi dɔ ɓadɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lo kɨn tɨ no̰o̰ be, dɔnangɨ yəkɨ yəkɨ kɨ ətɨ ɓəl ngay, tadɔ malayka kare re nduguru mbal ta ɓadɨ tɨ kɔ, ɓa təl ɨsɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rɔe unjɨ tə kadɨ be, taa kɨbɨ kɨ rɔe tɨ nda tə buy be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lokɨ asɨgar je kɨ njé ngəm dɔ ɓadɨ ooi-e, ɓəl tɔl-de adɨ təli toi tə nɨn je be. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nə malayka un ta əl dəne je ə nə: «Səi, ɨɓəli al, tadɔ m-gər kadɨ ɨsɨ sangi Jəju kɨ dɨje ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E goto ne, ḭ taa lo koy tɨ təkɨ e wa əl-n. Ɨrəi oi lo kɨ to tɨ ə to kare kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨngə kadɨ awi law əli njé ndo je lie təkɨ “ḭ taa dan njé koy je tɨ, ɓa aw kadɨ a ngɨnə səsi Galile tɨ. Lo kɨn ə a oi-e tɨ.” E kɨn ə e ta kɨ kadɨ m-əl səsi.» ");
INSERT INTO bjvNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dəne je ɔti ta ɓadɨ tɨ kɨ ngɔdɨ njade tɨ, ɓəl ra-de, nə rɔde nəl-de ngay. Awi ɔri poy nḛ kɨ ra nḛ kɨn adi njé ndo je lie ooi. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","NDə̰y ba go tɨ, Jəju aw ɨngə-de, əl-de ə nə: «M-uwə jisi!» Nɨngə əi je ɔti kɨ rɔ Jəju tɨ, uwəi njae, ɔsi məkəsɨde nangɨ no̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ə Jəju əl-de ə nə: «Ɨɓəli al; ə awi əli ngakom je kadɨ awi Galile tɨ. Lo kɨn ə a ooi-mi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lokɨ dəne je njɨyəi dɔ rəbɨ tɨ ɨsɨ awi, asɨgar je madɨ kɨ dan njé ngəm dɔ ɓadɨ tɨ, awi me ɓe bo tɨ, əli njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je nḛ je pətɨ kɨ ra nḛ kɨn adɨ ooi. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Be ə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kawi-naa kɨ ngatɔgɨ je lə *Jɨpɨ je, uni ndude. Ɓa go kun-ndu tɨ, adi asɨgar je la ngay, ");
INSERT INTO bjvNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ə əli-de əi nə: «Ta kɨ kadɨ əli ə to kɨn: əli əi nə: “NJé ndo je lie ə rəi ɓogi nɨne kondɔ, lokɨ j-ɨsɨ jɨ to ɓi.” ");
INSERT INTO bjvNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ə re ta kɨn osɨ mbi njé ko̰ɓe kɨ bo tɨ ə, je wa j-a gər lo ta kɨ kadɨ j-əl-e kadɨ j-ɔr-n ta dɔsi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Be ə, asɨgar je taai la ka kɨn, ɓa rai kɨ go ndu tɨ kɨ adi-de. E be ə, ta kə nə njé ndo je ɓogi nɨn Jəju kɨn, ɨsɨ njɨyə-n dan Jɨpɨ je tɨ bɨtɨ ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","*NJé ndo je kɨ dɔgɨ gɨde kare awi Galile, dɔ mbal tɨ kɨ Jəju əl-de kadɨ awi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lokɨ awi ə ooi-e nɨngə, ɔsi məkəsɨde nangɨ no̰e tɨ, nə kɨ madɨ je ɓadi kadɨ e Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ə Jəju ɔtɨ ɓasi kɨ rɔde tɨ, əl-de ta je kɨn ə nə: «Luwə adɨ-m tɔgɨ je pətɨ me dɔra̰ tɨ, kɨ dɔ dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awi kɨ rɔ gɨn dɨje tɨ kɨ dɔnangɨ tɨ ne pətɨ, ɨtəli-de njé ndo je tɨ ləm, ɨrai-de batəm me tɔ Baw tɨ, kɨ NGon tɨ, kɨ NDɨl Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nɨngə ɨndoi-de kadɨ ngəmi go nḛ je pətɨ kɨ m-dəjɨ səsi kadɨ ɨrai. NGa nɨngə, mi, m-a mi səsi naa tɨ kɨ ndɔ je pətɨ, bɨtɨ dɔbəy ndɔ tɨ.»");
INSERT INTO bjvNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ Jəju Kɨrɨsɨ, kɨ NGon lə Luwə, ə kulə ngɨre to kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","NDangi me makɨtɨbɨ tɨ lə nje kəl ta kɨ ta Luwə tɨ, Ejay, əi nə: «Mi Luwə m-a m-ɨlə kɨ nje kaw kɨlə ləm kəte no̰i tɨ, Kadɨ ra go rəbɨ no̰i tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","NDu dəw madɨ ɓa dɨlə lo tɨ ə nə: Ɨrai go rəbɨ lə Ɓaɓe! Ɨrai go rəbɨ lie adɨ a njururu!» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ja̰ Batɨsɨ tḛḛ ɨlə mbḛ dɨlə lo tɨ ə nə: «Ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, adɨ rai səsi batəm, mba kadɨ Luwə ɨyə̰-n go majal je ləsi kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Dɨje pətɨ kɨ dɔnangɨ Jude tɨ kɨ ɓe bo Jorijaləm tɨ, rəi rɔ Ja̰ tɨ, tɔri ndude dɔ majal je tɨ ləde, adɨ Ja̰ ra-de batəm me ba Jurdḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kɨbɨ kɨ Ja̰ ɨlə rɔne tɨ, e kɨ ra kɨ bḭ jambal, nɨngə dɔ mene kɨ nda tɔ. Nḛ kusoe e gɨbɨri je kɨ təjɨ je par. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ja̰ əl kosɨ dɨje ə nə: «Dəw madɨ kɨ nje tɔgɨ kɨ ətɨ ɓəl, kɨ ɨtə-m sa̰y, a re gom tɨ no̰o̰. E dəw kɨ kɨlə sa lie ka m-asɨ kɨlə dɔm nangɨ tutɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi, m-ra səi batəm me man tɨ, nə e, a ra səi batəm, me NDɨl Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dɔkagɨloe tɨ kɨn, Jəju ḭ Najarətɨ tɨ, kɨ e ngon ɓeko̰ kɨ Galile tɨ, re adɨ Ja̰ ra-e batəm, me ba Jurdḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lokɨ Jəju ɨsɨ tḛḛ me man tɨ, oo dɔra̰ tḛḛ tane, nɨngə oo NDɨl Luwə, rɨsɨ tə də dum be re ɨsɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɨngə, ndu ta madɨ tḛḛ dɔra̰ tɨ, ə nə: «Ḭ NGonm kɨ nje ndɨgɨ ləm, kɨ ḭ nḛ rɔnəl ləm kɨ bo ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kalangɨ ba go tɨ, NDɨl Luwə ɔsɨ Jəju aw sie dɨlə lo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jəju ra ndɔ dɔsɔ dɨlə lo tɨ. *Sata̰ re rɔe tɨ, na-e. Jəju e naa tɨ kɨ da je kɨ wale, malayka je rai sie. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Go kuwə tɨ kɨ uwəi Ja̰ dangay tɨ, Jəju aw Galile tɨ, ɨlə mbḛ Poy Ta kɨ Majɨ lə Luwə ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Dɔkagɨlo kɨ Luwə ɔjɨ ka re nga, nɨngə ko̰ɓe lə Luwə ka, e ɓasi rɔsi tɨ tɔ. Ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, ə adi mesi Poy Ta kɨ Majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","NDɔ kare, Jəju a də kadɨ ba bo tɨ kɨ Galile nɨngə, oo Sɨmo̰ əi kɨ ngokone Andɨre kɨ əi njé ndo̰ kanjɨ je, a ɨləi bandɨ me man tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jəju əl-de ə nə: «Ɨrəi gom tɨ adɨ m-ndo səsi, kadɨ ɨtəli njé ndo̰ dɨje kadɨ ɨngəi kajɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kalangɨ ba, ɨyə̰i bandɨ je ləde, ə awi uni go Jəju tə njé ndo je lie. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jəju ɔtɨ ndə̰y kəte nɨngə, oo Jakɨ əi kɨ Ja̰ kɨ əi ngan lə Jəbəde, ɨsi me to tɨ, ɨsɨ rai go bandɨ je ləde. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kalangɨ ba, Jəju ɓar-de, nɨngə ɨyə̰i bawde Jəbəde kɨ njé ra sie kɨlə je, me to tɨ, ə awi kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jəju əi kɨ njé ndo je ləne awi Kapərnayɨm tɨ. Jəju ur kəy kaw-naa tɨ lə *Jɨpɨ je, kɨ ndɔ taa kə̰ə̰ ləde, nɨngə ɨlə ngɨrə ndo nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nḛ ndo lie, ətɨ dɨje kɨ ɨsɨ ooi dɔe ɓəl kɨ dum, mbata ndo nḛ kɨ tɔgɨ kɨ ɨngə rɔ Luwə tɨ, ɓɨ ndo nḛ tə njé ndo ndu-kun je al. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nɨngə, dəw madɨ kare kɨ ndɨl kɨ majal ra-e, ɨsɨ me kəy kaw-naa tɨ ləde no̰o̰, no̰ kɨ ndune kɨ bo ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Jəju kɨ Najarətɨ, ri ə, ɨge rɔje tɨ ə? Ɨre mba kadɨ ɨtujɨ-je a? M-gər-i majɨ: ḭ kɨ Kay njay lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jəju ndangɨ ndɨl kɨ majal kɨ tɔgɨne ə nə: «Utɨ tai, ə ɨtḛḛ kɔ rɔ dɨngəm tɨ kam.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lo kɨn tɨ, ndɨl kɨ majal, ndajɨ dɨngəm rururu, kɨ tɔgɨne, nɨngə tḛḛ rɔe tɨ kɨ no̰ tane tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nḛ kɨn ətɨ dɨje ɓəl, adɨ dəji-naa ta dande tɨ əi nə: «Ri ə ra nḛ be ə? Oi nḛ ndo kɨ sɨgɨ, kɨ aw kɨ tɔgɨne ngay kɨn! Nɨngə, ndɨl je kɨ majal ka, ɨlə-de gɨn tɔgɨne tɨ, adɨ təli rɔde go ndue tɨ ɓəy tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","E be ə, dɨje sanəi-naa kɨ tɔɓa lə Jəju, dɔnangɨ kɨ Galile tɨ kalangɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lokɨ tḛḛi kəy kaw-naa tɨ lə *Jɨpɨ je ka kɨn nɨngə, Jəju əi kɨ Jakɨ nɨm, Ja̰ nɨm, awi me kəy tɨ lə Sɨmo̰ əi kɨ Andɨre. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Məm Sɨmo̰ kɨ dəne, rɔe o̰ por rɨgɨ rɨgɨ, adɨ to nangɨ. Be ə, lokɨ Jəju ur me kəy tɨ nɨngə, kalangɨ ba, əli-e ta rɔ to lie. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jəju re rɔe tɨ, uwə jie, un-e kɨ taa, nɨngə, rɔe kɨ kəte tɨngə ngay ka kɨn, təl sɔl, adɨ ɨngə rɔ nga. Go tɨ, ra nḛ kuso adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lokɨ lo sɔl, go kadɨ kur tɨ, dɨje rəi kɨ njé mo̰y je, kɨ dɨje pətɨ kɨ ndɨl je kɨ majal, rai-de, rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dɨje pətɨ kɨ me ɓe bo tɨ kawi-naa kɨ ta kəy tɨ, ta kəy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jəju adɨ rɔ nga, njé mo̰y je kɨ dangɨ dangɨ, taa tuwə ndɨl je kɨ majal dɔde tɨ kɔ tɔ. Nɨngə, adɨ ta rəbɨ, ndɨl je kɨ majal kadɨ əli ta al, tadɔ gəri-e ɓətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta gɨn lo tɨ, lokɨ lo tɨjə al ɓəy, Jəju ḭ taa, tḛḛ me kəy tɨ aw dɨlə lo tɨ, nɨngə loe tɨ no̰o̰, ɨlə ngɨrə kəl ta kɨ Bawne. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sɨmo̰ əi kɨ ndəgɨ dɨje kɨ əi sie, awi sangi Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lokɨ ɨngəi-e nɨngə, əli-e əi nə: «Dɨje pətɨ a sangi-ni.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ə Jəju əl-de ə nə: «Adɨ j-awi ngan ɓe je tɨ, kɨ kadɨ tɨ kɨn ngata, tadɔ, sɔbɨ kadɨ m-ɨlə mbḛ Poy Ta kɨ Majɨ nu tɔ. MBata, m-re kadɨ m-ra kɨlə kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","E be ə, Jəju njɨyə dɔnangɨ Galile tɨ ba pətɨ, ɨlə mbḛ Poy Ta kɨ Majɨ me kəy kaw-naa je tɨ lə *Jɨpɨ je, nɨngə tuwə ndɨl je kɨ majal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","NJe banjɨ ɔtɨ re rɔ Jəju tɨ, ɔsɨ məkəsɨne nangɨ no̰e tɨ, nɨngə no̰ dɔe tɨ ə nə: «Re ɨndɨgɨ ə, a adɨ banjɨ ləm ur, kadɨ rɔm ay njay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jəju oo kəm-to-ndoo lie, adɨ ɨlə jine ɔde-n, nɨngə, əl-e ə nə: «M-ndɨgɨ, ə kadɨ banjɨ ləi ur, adɨ rɔi ay njay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ta naa tɨ no̰o̰ banjɨ lie ur, adɨ rɔe nga. ");
INSERT INTO bjvNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nɨngə kəte ɓəy taa kadɨ Jəju ɨyḛ adɨ aw, ndəje kɨ tɔgɨne ngay, ");
INSERT INTO bjvNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ə əl-e ə nə: «Onoi kadɨ əl tae dəw madɨ, ə aw ɔjɨ rɔi nje kɨjə nḛ məsɨ kadɨ-kare, nɨngə adɨ kadɨ-kare kɨ ndu-kun lə *Mojɨ dəjɨ. Ɨra be mba kadɨ gəri təkɨ banjɨ ləi ur adɨ ɨngə rɔ nga.» ");
INSERT INTO bjvNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nə lokɨ dɨngəm ka kɨn ɔtɨ aw nɨngə, ɨlə mbḛ dɔ nḛ tɨ kɨ Jəju ra sie kɨn, adɨ dɨje pətɨ ooi. Nḛ kɨn ra adɨ Jəju asɨ kadɨ ur me ɓe bo tɨ kɨ rangɨ, ta kəm dɨje tɨ ja ja al ngata. Be ə, ɨsɨ gɨdɨ ɓe tɨ, dɨlə lo tɨ, nɨngə dɨje ḭ kɨ lo je kɨ dangɨ dangɨ, rəi rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","NDɔ ngay al go tɨ, Jəju təl aw Kapərnayɨm tɨ. Dɨje gəri kadɨ e me kəy tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dɨje kawi-naa ngay, adɨ lo ɨbə-de ndɨngɨ ndɨngɨ, lo kɨ kadɨ dəw ɨlə njane tɨ ka goto, bɨtɨ kɨ ta kəy tɨ taga. Lo kɨn tɨ, Jəju ndo-de Poy Ta kɨ Majɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dɨje madɨ oti dəw kɨ rɔe oy njururu rəi sie rɔ Jəju tɨ. Dɨngəm je sɔ, ə oti-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lo kadɨ awi sie, ɨləi-e no̰ Jəju tɨ goto, mbata, dɨje ɨbəi lo ndɨngɨ ndɨngɨ. E be ə, ali taa, ndui dɔ kəy, sɔbɨ dɔ lo kɨ Jəju e tɨ, nɨngə kɨ bole ka kɨn ə, ɨləi nje mo̰y kɨ nḛ kotɨ njé mo̰y je, kɨ dɔɔi kulə tɨ, no̰ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lokɨ Jəju oo kadɨ-me ləde nɨngə, əl dəw kɨ rɔe oy njururu ka kɨn ə nə: «NGonm, majal je ləi e kɨ kɨyə̰ go kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","NJé ndo ndu-kun je lə Luwə kɨ na̰ je ɨsi me kəy tɨ no̰o̰, ɨsɨ məri ta əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Ra ban ə dəwe kam, əl ta be ə? Əl ta kɨ mal dɔ Luwə tɨ. Luwə kɨ karne ba par ə asɨ kɨyə̰ go majal lə dɨje kɔ, dəw kɨ rangɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta naa tɨ no̰o̰, Jəju gər mər ta je ləde kɨn, adɨ əl-de ə nə: «Ra ban ɨsɨ ɨməri ta je kɨ be kɨn mesi tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kəl nje rɔ koy njururu kə nə: “Majal je ləi e kɨ kɨyə̰ go kɔ” ɓa nga̰ ngay al ə se, kəl-e kə nə: “Ḭ taa, un tuwə ləi, ə ɨnjɨyə,” ə nga̰ ngay al ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Re e be ɓa, m-a m-ɔjɨ səi təkɨ mi NGon Dəw, m-aw kɨ tɔgɨ dɔnangɨ tɨ ne, mba kadɨ m-ɨyə̰-n go majal je lə dɨje kɔ.» Nɨngə, Jəju əl nje rɔ koy njururu ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ḭ taa, un tuwə ləi, ə aw ɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɓa dɨngəm ḭ taa ta naa tɨ no̰o̰, un tuwə ləne, ə tḛḛ ta kəm dɨje tɨ aw. Ɓəl ra dɨje pətɨ, adɨ ɨləi tɔjɨ dɔ Luwə tɨ əi nə: «Jagɨ, j-o nḛ kɨ be kɨn kəte al ɓəy!» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jəju təl aw kadɨ ba bo tɨ gogɨ. Dɨje pətɨ rəi rɔe tɨ, nɨngə ndo-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lokɨ Jəju ɨsɨ də nɨngə, oo *Ləbi kɨ ngon lə Alpe, ɨsɨ me kəy taa la-mbə tɨ. Jəju əl-e ə nə: «Un gom.» Nɨngə Ləbi ḭ taa, un go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Go tɨ, Jəju ɨsɨ ta nḛ kuso tɨ me kəy tɨ lə Ləbi. *NJé taa la-mbə je, kɨ njé ra majal je, ngay, ɨsi naa tɨ kɨ Jəju kɨ njé ndo je lie ta nḛ kuso tɨ, mbata ko dɨje kɨ be kɨn ngay ə njɨyəi goe tɨ, mukɨ mukɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lokɨ njé ndo ndu-kun je kɨ me ɓutɨ tɨ lə *Parɨsɨ je ooi Jəju ɨsɨ uso nḛ kɨ njé taa la-mbə je kɨ njé ra majal je nɨngə, əli njé ndo je lie əi nə: «Tə, Ɓasi ɨsɨ uso nḛ kɨ njé taa la-mbə je kɨ njé ra majal je a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jəju oo ndude, adɨ əl-de ə nə: «E dɨje kɨ njé mo̰y je ə a sangi dəw kɨ nje ra mo̰y, ɓɨ e njé rɔ nga je ə a sangi dəw kɨ nje ra mo̰y, al. Nɨngə, m-re mba ɓar dɨje kɨ dana al, nə m-re mba dɨje kɨ njé ra majal je yo.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","NDɔ kare njé ndo je lə Ja̰ Batɨsɨ əi kɨ *Parɨsɨ je ɨyə̰i ta nḛ kuso. Dɔkagɨlo tɨ kɨn ə dɨje rəi rɔ Jəju tɨ dəji-e əi nə: «Ra ban ə njé ndo je lə Ja̰ əi kɨ njé ndo je lə Parɨsɨ je, ɨsɨ ɨyə̰i ta nḛ kuso, ə ya̰i je, rai al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jəju ɨlə-de tɨ ə nə: «Oi kadɨ e go rəbe tɨ kadɨ dɨje kɨ ɓari-de lo nḛ kuso taa-naa tɨ, a ɨyə̰i ta nḛ kuso dɔkagɨlo tɨ kɨ nje taa dəne ɨsɨ-n səde naa tɨ a? Jagɨ dɔkagɨlo tɨ kɨ nje taa dəne ɨsɨ-n səde naa tɨ, a asi kɨyə̰ ta nḛ kuso, al. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","NDɔ je a rəi no̰o̰ kadɨ a uni-e tade tɨ nɨngə, dɔkagɨloe tɨ kɨn ə a ɨyə̰i ta nḛ kuso. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Dəw a un ta kɨbɨ kɨ sɨgɨ kadɨ ɨlə-n kəm kɨbɨ kɨ kɔke al. Re e be ə, ta kɨbɨ kɨ sɨgɨ ka kɨn, a ḭ kɨ kɨ kɔke rakɨ rakɨ, kadɨ bole a to wororo ɨtə kɨ kəte ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Taa, dəw a un kasɨ kandɨ nju kɨ ḭ al ɓəy utɨ me mbu nda je tɨ kɨ kɔke al tɔ. Re e be nɨngə, lokɨ kasɨ a ḭ ɓa, mbu nda je a ndui. Nɨngə mbu nda je kɨ kasɨ kandɨ nju je pətɨ a təli nḛ kɨ tujɨ kɔ. Be ə, re kasɨ kandɨ nju ḭ al ɓəy ɓa, majɨ kadɨ mbu nda je əi kɨ sɨgɨ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jəju ɨndə də me ndɔr gəme je tɨ, ndɔ taa kə̰ə̰ tɨ lə *Jɨpɨ je. *NJé ndo je lie kɨ əi sie, gangi dɔ ko je dɔ njɨyə tɨ usoi. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɨngə *Parɨsɨ je əli Jəju əi nə: «O nḛ kɨ to kɨn: njé ndo je ləi rai nḛ kɨ kadɨ dəw ra ndɔ taa kə̰ə̰ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jəju əl-de ə nə: «Ɨtɨdəi nḛ kɨ ngar *Dabɨdɨ ra lokɨ nḛ nga̰ səde, ə ɓo ra-de kɨ dɨje kɨ goe tɨ kɨn ndɔ kare al bɨtɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dabɨdɨ ur me kəy tɨ lə Luwə, dɔkagɨlo tɨ kɨ Abɨyatar ə e nje kɨjə nḛ məsɨ kadɨ-kare kɨ bo. Dabɨdɨ un mapa kɨ dɨje adi Luwə kadɨ-kare tɨ, kɨ njé kɨjə nḛ məsɨ kadɨ-kare par ə sɔbɨ dɔde kadɨ usoi, uso, ə adɨ dɨje kɨ gone tɨ usoi tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jəju təl əl-de ɓəy ə nə: «Luwə ɔr ndɔ ta kə̰ə̰ ɨndə ta dangɨ mba majɨ lə dəw, ɓɨ ra dəw mbata ndɔ ta kə̰ə̰ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","E be ə, mi *NGon dəw, ndɔ taa kə̰ə̰ wa ka m-aw kɨ tɔgɨ dɔ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jəju təl aw kəy kaw-naa tɨ gogɨ ɓəy. Nɨngə dɨngəm kare kɨ jie oy njururu e me kəy kaw-naa tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dɨje ɨsi jəke ɨsɨ ɨndəi kəmde kadɨ n-ooi se Jəju a adɨ dɨngəm kɨn rɔ nga ndɔ ta kə̰ə̰ tɨ wa? E ta bole kɨ ɨsɨ sangi kadɨ n-ɨndəəi ta dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jəju əl dɨngəm kɨ jie oy njururu ka kɨn ə nə: «Ḭ taa ɨre dana ne, ta kəm dɨje tɨ pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɨngə Jəju təl dəjɨ ndəgɨ dɨje ə nə: «Ri ə majɨ mba kadɨ dəw ra ndɔ ta kə̰ə̰ tɨ ə? Kadɨ dəw ra majɨ ə se kadɨ dəw ra majal ə? Kadɨ dəw nagɨ madɨne ta yo tɨ ə se kadɨ ɨyḛ adɨ tujɨ kɔ ə?» Lo to jɨjɨji, dəw kare ka əl ta al. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jəju ɨndə kəmne go̰-n-de ba pətɨ, kɨ wongɨ, mee tɨnge dɔde tɨ ngay mbata me nga̰ ləde. Nɨngə əl dɨngəm ka kɨn ə nə: «Ɨsurə jii.» Dɨngəm surə jine nɨngə, jie təl to majɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ə lokɨ *Parɨsɨ je tḛḛi taga ɓa, awi kalangɨ ba ɨngəi njé kɨ gɨn *Erodɨ tɨ əli-naa səde ta kɨ dɔ Jəju tɨ kadɨ n-ooi se n-a n-rai ban ə n-a n-tɔli-e wa. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jəju ɔtɨ aw kɨ njé ndo je ləne ta ba Galile tɨ. Nɨngə kosɨ dɨje ngay rəi goe tɨ. Kosɨ dɨje ka kɨn ḭ dɔnangɨ Galile tɨ je, dɔnangɨ Jude tɨ je, ");
INSERT INTO bjvNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ɓe bo Jorijaləm tɨ je, dɔnangɨ Idume tɨ je, dɔnangɨ kɨ gɨdɨ ba Jurdḛ tɨ je, taa dɨje kɨ ɨsi gəi gɨdɨ ɓe bo kɨ Tɨr kɨ Sɨdo̰ ba pətɨ ka rəi goe tɨ tɔ. Kosɨ dɨje kɨn rəi rɔ Jəju tɨ, mbata oy poy nḛ je kɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jəju əl njé ndo je ləne kadɨ ɨndəi dɔ to madɨ dana dangɨ adi-ne, mba kadɨ kosɨ dɨje mborəi-ne al. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Təkɨ rɔjetɨ, Jəju adɨ rɔ nga dɨje ngay, adɨ dɨje pətɨ kɨ awi kɨ mo̰y rɔde tɨ, nagi rɔde mba kadɨ n-ɔdi rɔe. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lokɨ dɨje kɨ ndɨl je kɨ majal uwəi-de gɨn tɔgɨde tɨ ooi-e nɨngə, ɔsi məkəsɨde nangɨ no̰e tɨ, uni ndude kɨ taa no̰i əi nə: «Ḭ NGon lə Luwə!» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nə, ndəjɨ-de kɨ tɔgɨne kadɨ rai adɨ dəw gər-ne al. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Go nḛ je tɨ kɨn, Jəju aw dɔ mbal tɨ, ɓar njé kɨ ge-de, nɨngə rəi rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","MBo̰ dɨje tɨ kɨ ɓar-de kɨn ə Jəju mbətɨ njé ndo je ləne kɨ dɔgɨ gɨde e joo kɨ kadɨ əi sie naa tɨ kɨ dɔkagɨlo je pətɨ. Əi sie naa tɨ, mba kadɨ ɨlə-de adɨ awi ɨləi mbḛ Poy Ta kɨ Majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Taa awi kɨ tɔgɨ kadɨ tuwəi ndɨl je kɨ majal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tɔ dɨje kɨ dɔgɨ gɨde e joo kɨ Jəju mbətɨ-de ə to kɨn: Sɨmo̰, kɨ Jəju ɨndə tɔe nə Pɨyər, ");
INSERT INTO bjvNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakɨ, kɨ ngon lə Jəbəde əi kɨ ngokone Ja̰, kɨ Jəju ɓar-de joo pu nə Bowanərjəsɨ, kɨ kɔr me nə «ngan lə ndangɨndi», ");
INSERT INTO bjvNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kɨ Andɨre, kɨ Pɨlɨpɨ, kɨ Batɨləmi, kɨ Matɨye, kɨ Tomasɨ, kɨ Jakɨ kɨ ngon lə Alpe, kɨ Tade, kɨ Sɨmo̰ kɨ e mbo̰ njé rɔ mbata kɨngə dɔ lə ɓe ləde tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","taa Judasɨ Isɨkarɨyotɨ kɨ nje kun dɔ Jəju tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jəju aw ɓe nɨngə, kosɨ dɨje rəi uti kəm lo ka ka ɓəy, adɨ lo kadɨ əi kɨ njé ndo je ləne ɨngəi dɔkagɨlo kadɨ usoi nḛ ka goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lokɨ noje je ooi poy ta kɨn nɨngə, rəi mba kadɨ n-ɔri-e n-awi sie ɓe, tadɔ əli əi nə: «Dɔe ɨsɨ dana al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","NJé ndo ndu-kun je lə Luwə kɨ ḭ Jorijaləm tɨ əli əi nə: «Bəljəbul ɨsɨ mee tɨ. Nɨngə e kɨ tɔgɨ lə ngar lə ndɨl je kɨ majal, ə ɨsɨ tuwə-n ndɨl je kɨ majal.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Be ə Jəju ɓar-de kɨ rɔne tɨ nɨngə, ɔr-de gɨn nḛ je me kujɨ ta je tɨ ə nə: «Oi kadɨ *Sata̰ a tuwə dɨje lə Sata̰ ban? ");
INSERT INTO bjvNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kɨn ə, dɨje kɨ me ɓeko̰ tɨ kɨ kare ba, təli dɔ-naa tɨ rɔi-naa ə, ɓeko̰ kɨn a a taa al. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lokɨ dɨje kɨ me kəy tɨ kɨ kare ba təli dɔ-naa tɨ, rɔi-naa, me kəye kɨn a ra tɔgɨ kaw kəte al. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Re Sata̰ ə wa adɨ dɨje lie təli dɔ-naa tɨ kɨ rɔ, adɨ gangi-naa dana joo ə, ko̰ɓe lie a ra tɔgɨ kaw kɨ kəte al, gɨne a gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Təkɨ rɔjetɨ, adɨ m-əl səsi, kɨn ə re dəw uwə dəw kɨ nje tɔgɨ dɔɔ-e kəte al ə, a asɨ kur me kəy tɨ lie, kadɨ ndur nḛ kɨngə lie al. Lokɨ dɔɔ-e ngata nɨngə, a ndur nḛ kɨ me kəy tɨ lie təkɨ mene ge. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","M-əl səsi təkɨ rɔjetɨ: Majal je pətɨ kɨ dɨje rai, se nḛ tajɨ je pətɨ kɨ a tḛḛ tade tɨ kɨ dɔ Luwə tɨ, Luwə a ɨyə̰ goe kɔ adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nə re dəw əl ta kɨ mal dɔ NDɨl Luwə tɨ nɨngə, Luwə a ɨyə̰ go kɔ ade al ratata. Dəw kɨn a otɨ kɔy majal ləne kɨn kɨ no̰ne tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jəju əl-de ta kɨn be mbata njé ndo ndu-kun je əli əi nə: «Aw kɨ ndɨl kɨ majal rɔne tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ko̰ Jəju kɨ ngako̰e je rəi ai taga, nɨngə ɨləi dəw kare kadɨ ɓar-e adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kosɨ dɨje ngay gəi gɨde wukɨ. Lokɨ rəi əli-e əi nə: «O ko̰i je, kɨ ngako̰i je ai taga no̰o̰, a sangi-ni.» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nɨngə Jəju təl əl-de ə nə: «Na̰ je ə əi kom je kɨ ngakom je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɓa go̰ dɨje kɨ ɨsi gəi dɔe wukɨ ka kɨn, nɨngə əl ə nə: «Oi kom je, kɨ ngakom je ə ɨsi kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tadɔ dəw kɨ nje ra ndɨgɨ lə Luwə ə, e ngokom je, e konanm je, kɨ kom je.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jəju ɨlə ngɨrə kadɨ ndo dɨje nḛ kadɨ ba bo tɨ ɓəy. Kosɨ dɨje ngay kawi-naa gəi gɨde, adɨ aw, al ɨsɨ me to tɨ, nangɨ dɔ ba tɨ. Kosɨ dɨje ai ngangɨ ba tɨ ne, təli kəmde kɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jəju ndo-de nḛ je ngay me kujɨ ta je tɨ. Me nḛ ndo tɨ lie, əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«NJe ndɔr kare aw kadɨ dɨbɨ nḛ, ");
INSERT INTO bjvNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","nɨngə dɔkagɨlo tɨ kɨ a ɨlə ko, ka̰ ko je madɨ tosi ngangɨ rəbɨ tɨ adɨ yəl je rəi o̰i makɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka̰ ko je kɨ nungɨ tosi dɔnangɨ njəkɨrə tɨ, adɨ lo kadɨ ɨngəi dɔnangɨ asɨ tam ɨləi ngɨrəde tɨ goto. Nə ke ə tɔgi kalangɨ ba, tadɔ ngɨrəde to tane. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lokɨ kadɨ ɔsɨ nɨngə, ngan ko je ka kɨn ndoləi mbaw, ɓa go tɨ, tuti kurɨm, tadɔ ngɨrəde aw nangɨ boy al. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ka̰ ko je kɨ nungɨ, tosi dan kon je tɨ, adɨ kon je tɔgi ndəmi-de mbɔl, lo kadɨ andi goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nə ka̰ ko je madɨ tosi dɔnangɨ tɨ kɨ majɨ. Be ə, tɔgi kalangɨ ba, adɨ andi. Kɨ na̰ je andi asɨ kutɨ mɨtə, njé kɨ nungɨ andi asɨ kutɨ mehḛ, taa njé kɨ nungɨ ɓəy andi asɨ ɓu kare tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Go tɨ nɨngə, Jəju əl-de ə nə: «Dəw kɨ aw kɨ mbine mba koo-n dɔ ta ɓa, kadɨ oo dɔ ta kɨn majɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lokɨ kosɨ dɨje awi nɨngə, njé kɨ njé nay sie, kɨ njé ndo je lie kɨ dɔgɨ gɨde e joo, dəji-e kadɨ ɔr-de gɨn kujɨ ta je kɨ ndo-n nḛ kadɨ n-gəri. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ə əl-de ə nə: «Səi, Luwə tḛḛ kɨ dɔ nḛ kɨ to lo ɓɔyɔ tɨ kɨ ɔjɨ dɔ ko̰ɓe lie adɨ səsi. Nə ndəgɨ dɨje kɨ ai taga, ɨngəi nḛ ndo je pətɨ kɨ kujɨ ta. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","E be mba kadɨ, “Re go̰i lo majɨ ka ooi nḛ al nɨm, Re ooi dɔ ta majɨ ka gəri me al nɨm, Tadɔ re gəri me nɨngə, A təli rɔde go Luwə tɨ kadɨ Luwə ɨyə̰ go majal je ləde kɔ”.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jəju əl-de ə nə: «Ɨgəri me kujɨ ta kɨn al a? A re ɨgəri me kujɨ ta kɨn al ə a rai ban ə a ɨgəri ndəge je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","NJe kɨlə ko, nḛ kɨlə lie e Poy Ta kɨ Majɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka̰ ko kɨ tosɨ ngangɨ rəbɨ tɨ, ɔjɨ dɔ dɨje madɨ kɨ ooi ta lə Luwə, nɨngə *Sata̰ re ɔr ta kɨ ooi ka kɨn mede tɨ kalangɨ ba kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","NGa nɨngə, əi je kɨ tosi dɔnangɨ njəkɨrə tɨ, əi dɨje kɨ ooi ta lə Luwə nɨngə, taai langɨsi ba kɨ rɔnəl, ");
INSERT INTO bjvNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","nə ta kɨn, ɨlə ngɨrəne mede tɨ al. Əi dɨje kɨ njé kuwə kɨ ta lə Luwə dɔkagɨlo kɨ ndə̰y be par. Dɔkagɨlo kɨ ko̰ je, ə se kɨndə kəm-ndoo kɨ mbata ta lə Luwə re ɓa, ɨyə̰i kadɨ-me ləde kɔ kalangɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka̰ ko kɨ tosɨ dan kon je tɨ, əi dɨje kɨ ooi ta lə Luwə, ");
INSERT INTO bjvNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nə me ka sururu dɔ nḛ je tɨ kɨ dɔnangɨ tɨ, kɨ ra ta nḛ majɨ je kɨ dɔnangɨ tɨ, taa ɓo nḛ je kɨ rangɨ kɨ dangɨ dangɨ, utɨ dɔ ta kɨ ooi, adɨ lo kadɨ andi goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nɨngə, ndəgɨ ka̰ ko je kɨ tosi dɔnangɨ kɨ majɨ tɨ, ɔjɨ dɔ dɨje kɨ ooi Poy Ta kɨ Majɨ, nɨngə taai mede tɨ, ə tḛḛi kɨ kandɨde tɔ. Kɨ madɨ je andi kutɨ mɨtə je, kutɨ mehḛ je, kɨ ɓu kare je. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nɨngə Jəju təl əl-de ɓəy ə nə: «Dəw a re kɨ lambɨ kəy ə dəbɨ ngo dɔ tɨ, ə se ɨndə gɨn tɨrə tɨ a? A ɨndə dɔ nḛ tɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nḛ je pətɨ kɨ e kɨ ra gɨdɨ ngə̰y tɨ, a to taga ta kəm dɨje, ə nḛ je kɨ e kɨ ra lo ɓɔyɔ tɨ, a to kɨ taga pa̰y tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Re dəw aw kɨ mbine mba koo-n dɔ ta nɨngə, kadɨ oo majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jəju təl əl-de ɓəy ə nə: «Majɨ kadɨ uri mbisi majɨ oi dɔ ta, ɓɨ oy kɨ no̰o̰ be al. Ɓa kadɨ ɨgəri təkɨ go rəbɨ kɨ ɨgangii ta dɔ dɨje kɨn ə Luwə a gangɨ-n ta dɔsi tɨ tɔ. Nɨngə ta kɨ gangɨ kɨ dɔsi tɨ a ɨtə e kɨ səi ɨgangi dɔde tɨ kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Be ə, dəw kɨ aw kɨ nḛ jine tɨ, a adi-e dɔ tɨ ɓəy. Nə dəw kɨ nḛ lie goto, e kɨ ndɨkɨri wa kɨ aw-n jine tɨ kɨn ka, a taai jie tɨ wa ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jəju təl əl-de ɓəy ə nə: «Ko̰ɓe lə Luwə to tə dəw kɨ aw dɨbɨ nḛ me ndɔr tɨ ləne be. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Go nḛ dɨbɨ tɨ kɨn, re nje ndɔr to ɓi ə se, to ɓi al ka, kondɔ kɨ kada, nḛ kɨ dɨbɨ, ɨbə ə ɨsɨ tɔgɨ tɔ, kɨ kanjɨ kadɨ nje dɨbe gər-n rəbɨ kɨ ɨsɨ tɔgɨ-n. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nangɨ wa kɨ dɔrɔne, ra adɨ ko ɨbə ə tɔgɨ, kade tḛḛ, nɨngə go tɨ gogɨ, ɔr dɔne, ə andɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nɨngə dɔkagɨlo kɨ dɔ ko kər asɨ lo kɨjə tɨ, dəw re ɨjə ko tadɔ nayḛ asɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jəju əl-de ɓəy ə nə: «Ri ə j-a j-uni kadɨ j-ɔjii ko̰ɓe lə Luwə ə? Ə se kujɨ ta kɨ ban ə j-a j-un kadɨ j-əl-n ta kɨ dɔ tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ko̰ɓe lə Luwə to tə kandɨ nḛ kɨ ɓari-e mutadɨ kɨn be. E kandɨ nḛ kɨ du ɨtə kandɨ nḛ je pətɨ kɨ dəw ɨsɨ dɨbɨ dɔnangɨ tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lokɨ dəw dɨbe nɨngə, tɔgɨ ə təl kagɨ ta̰y kɨ bo, ɨtə ndəgɨ kagɨ ta̰y je pətɨ. Bajie je kɨ tɔi, boyi ngay, kadɨ yəl je uwəi lo kɨsɨ dɔ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kɨ kujɨ ta je ngay kɨ toi be, kɨ dɨje asi kadɨ gəri, ə Jəju ndo-n-de ta lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta kɨ kadɨ əl-de kɨ kujɨ ta al, goto. Nɨngə dɔkagɨlo kɨ nayḭ kɨ njé ndo je ləne wa par ɓa, ɔr-de me pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Me ndɔe tɨ no̰o̰, dɔ ji lo sɔl tɨ nɨngə, Jəju əl njé ndo je ləne ə nə: «Adɨ jɨ gangi ba, j-awi dame tɨ kɨ kare.» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɨyə̰i kosɨ dɨje, nɨngə njé ndo je awi kɨ Jəju me to tɨ kɨ re e tɨ kəte. To je kɨ rangɨ dani-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nɨngə, nəl kɨ bo ngay bə səde busɨ dɔ batɨ. Pulum ta man ɨndə kadɨ to bɨgɨm bɨgɨm adɨ man ɨsɨ rosɨ to. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jəju lə nḛ gətɨ-n dɔne, ə to mongɨ to tɨ, ɨsɨ to ɓi. *NJé ndo je lie ndəli-e kɨ no̰ tade tɨ əi nə: «NJe ndo, j-ɨsɨ j-oy be ka oo al a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jəju ndəl dɔ ɓi tɨ, ndangɨ nəl, ə əl man ba ə nə: «A lo ka tɨ! Adɨ lo to jɨjɨji!» Loe tɨ no̰o̰, nəl ta kə̰ə̰ adɨ lo təl to jɨjɨji. ");
INSERT INTO bjvNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nɨngə, Jəju əl njé ndo je ləne ə nə: «Ra ban ə ɨɓəli be ə? Bɨtɨ ɓone ka adi mesi al ɓəy a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓəl rade ngay, adɨ dəji-naa ta dande tɨ əi nə: «Dəw ə wa kam e na̰ ə, nəl je kɨ ba je ka ooi ta lie be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jəju əi kɨ njé ndo je ləne tḛḛi gɨdɨ ba tɨ, dɔnangɨ tɨ lə dɨje kɨ Gərasa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lokɨ Jəju ḭ me to tɨ ur nangɨ nɨngə, taji naa tɨ no̰o̰, dəw madɨ kare kɨ aw kɨ ndɨl kɨ majal rɔne tɨ, tḛḛ dɔ ɓadɨ je tɨ re ɨnge. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Dəw ka kɨn ra ɓe dɔ ɓadɨ je tɨ. Re e kɨ kulə gɨndɨ ka, dəw kare kɨ asɨ dɔe lo ka tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dɔɔi-e kɨ kulə gɨndɨ nja ba̰y ba̰y, taa ɨləi kangɨla gɨndɨ njae tɨ tɔ. Nə gangɨ kulə gɨndɨ rɨw rɨw, taa tətɨ gɨndɨ nɔsɨ nɔsɨ tɔ. Dəw kɨ asɨ kuwe gɨn tɔgɨne tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dɔkagɨlo je pətɨ, kondɔ kɨ kada, lo njɨye e dɔ ɓadɨ je tɨ kɨ dan mbal je tɨ kɨ wuy kɨ kur tane tɨ. Nɨngə tɨjə rɔne gangɨ batɨ batɨ kɨ gajɨ mbal je. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lokɨ oo Jəju sa̰y nu ɓəy nɨngə, a̰y kɨ ngɔdɨ re ɔsɨ məkəsɨne nangɨ no̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nɨngə ur kɔl kɨ tɔgɨne ngay ə nə: «Jəju kɨ NGon lə Luwə kɨ nje kɨsɨ dɔra̰ tɨ taa nu, e ri ə ɨge rɔm tɨ ə? M-uwə njai me tɔ Luwə tɨ, adɨ-m ko̰ al!» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Əl ta kɨn be tadɔ ta kɨ Jəju əl-e ə nə: «Ḭ ndɨl kɨ majal, ɨtḛḛ kɔ rɔ dɨngəm tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jəju dəje ə nə: «Tɔi nə na?» E təl əl-e ə nə: «Tɔm nə “kosɨ njé rɔ je”, mbata jɨ ba̰y ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","No̰ kɨ dɔ Jəju kɨ nja naa tɨ nja naa tɨ kadɨ tuwə-de kɔ me ɓe tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dɔkagɨloe tɨ kɨn, kosɨ kɔsongɨ je ngay a usoi nḛ kadɨ mbal tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","NDɨl je kɨ majal no̰i dɔ Jəju tɨ əli-e əi nə: «Ɨtuwə-je adɨ j-aw dan kɔsongɨ je tɨ kam, j-ur mede tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jəju ndɨgɨ səde dɔ tɨ, adɨ tḛḛi me dɨngəm tɨ ka kɨn, ə awi uri me kɔsongɨ je tɨ. Taji naa tɨ no̰o̰, kosɨ kɔsongɨ je kɨ asi dɨbɨ joo kare, ɓɨngəi-naa kadɨ mbal tɨ taa, tosi me ba tɨ, adɨ a̰yḭ-naa man oyi. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","NJé ngəm kɔsongɨ je a̰yḭ-naa awi me ɓe bo tɨ, kɨ me ndɔr je, ɔri poy nḛ kɨ ra nḛ kɨn dɨje, adɨ dɨje awi kadɨ n-ooi nḛ kɨ ra nḛ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lokɨ dɨje ka kɨn rəi tḛḛi rɔ Jəju tɨ nɨngə, ooi dɨngəm kɨ aw kɨ ndɨl je kɨ majal ka kɨn ɨsɨ rɔe tɨ. OOi-e kadɨ ɨsɨ kɨ angal kɨ majɨ, taa ɨsɨ kɨ kɨbɨ rɔne tɨ tɔ. Nḛ je kɨn ra adɨ ɓəl rade ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nɨngə dɨje kɨ awi lo nḛ je tɨ kɨ Jəju ra, ɔri madɨde je poy nḛ kɨ tḛḛ dɔ dɨngəm tɨ kɨ aw kɨ ndɨl je kɨ majal, kɨ nḛ kɨ tḛḛ dɔ kɔsongɨ je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Be ə, ɨləi ngɨrə kadɨ no̰i dɔ Jəju əi nə: «NJai ba, ɨyə̰ dɔnangɨ ləje, ə aw.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dɔkagɨlo tɨ kɨ Jəju ɨsɨ al me to tɨ gogɨ nɨngə, dɨngəm kɨ Jəju tuwə ndɨl je kɨ majal me tɨ ka kɨn dəje kadɨ n-aw sie. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nə Jəju ɔdɨ al, ə əl-e ə nə: «Ɔtɨ aw ɓe dan noji je tɨ, ɔr-de poy nḛ kɨ Ɓaɓe ra səi kɨ koo kəm-to-ndoo kɨ ətɨ ɓəl kɨ ɔjɨ dɔi tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","E be ə, dɨngəm ka kɨn ɔtɨ aw dɔnangɨ ɓe bo je tɨ kɨ dɔgɨ, ɔr poy nḛ je kɨ Jəju ra sie. Dɨje pətɨ kɨ oy ta kɨn, ətɨ-de ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lokɨ Jəju təl aw gɨdɨ ba tɨ kɨ to nɨngə, kosɨ dɨje ngay kawi-naa rɔe tɨ kadɨ ba tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nɨngə dɨngəm kare kɨ dan njé kun dɔ kəy kaw-naa tɨ lə *Jɨpɨ je, kɨ tɔe nə Jayrusɨ re. Lokɨ oo Jəju nɨngə, osɨ nangɨ njae tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","no̰ dɔe tɨ kɨ man kəmne ə nə: «NGonm kɨ dəne kɨ du ɨsɨ oy. NJai ba, kadɨ aw ɨndə jii dɔe tɨ adɨ ɨngə rɔ nga, ə oy al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jəju ɔtɨ aw sie, nɨngə kosɨ dɨje ngay njɨyəi goe tɨ, mborəi-e kɨ yo je kɨ nḛ je. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dəne kare kɨ mo̰y məsɨ ade ko̰ ɓal dɔgɨ gɨde e joo e dan kosɨ dɨje tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mo̰y kɨn ade ko̰ ngay, adɨ a̰y ngɔdɨ ngay tɔ go dɨje tɨ kɨ njé ra dɨje mo̰y, nə tujɨ nḛ kɨngə ləne dɔ tɨ kɔ kare, nɨngə ɨngə ko̰ jide tɨ tə kɨngə yo. Mo̰y aw kɨ kəte tə kaw par par, nḛ kɨ to sotɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dəne ka kɨn oo ta lə Jəju. Be ə, dan kosɨ dɨje tɨ, re kɨ rəbɨ kɨ gɨdɨ Jəju tɨ, ɔdɨ ta kɨbɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","MBata əl mene tɨ ə nə: «Kɨn ə re ta kɨbɨ lie par ə m-ɔdɨ ə, rɔm a nga.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nɨngə taji naa tɨ no̰o̰ par gɨn məsɨ lie gangɨ, adɨ gər me rɔne tɨ təkɨ rɔne nga ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Loe tɨ no̰o̰, Jəju gər me angalne tɨ təkɨ tɔgɨ tḛḛ rɔne tɨ. Be ə, təl kəmne gogɨ dan kosɨ je tɨ, dəjɨ-de ə nə: «Na̰ ə ɔdɨ ta kɨbɨ ləm ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","*Ə njé ndo je lie əli-e əi nə: «Ḭ wa ɨgər majɨ kadɨ kosɨ je mborəi-ni kɨ yo je kɨ nḛ je, ə ɨtəl ɨdəjɨ ə nə: “Na̰ ɔdɨ-m ɓəy a?”» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nə Jəju nay kɨ lo go̰ lo tɨ gə gɨdɨne kadɨ n-oo dəne ə wa kɨ ra nḛ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɓəl ra dəne ka kɨn ngay, adɨ dadɨ par par, mbata gər nḛ kɨ ra-e me rɔe tɨ. Be ə, re osɨ nangɨ nja Jəju tɨ, əl-e ta je kɨ rɔjetɨ pətɨ kɨ to mee tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nə Jəju əl-e ə nə: «NGonm, kadɨ-me ləi aji. Aw kɨ lapɨya, ə kadɨ ɨngə rɔ nga dɔ mo̰y tɨ ləi.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lokɨ Jəju a əl ta ba ɓəy nɨngə, dɨje madɨ ḭḭ me kəy tɨ lə Jayrusɨ, kɨ e kɨ bo dɔ kəy kaw-naa tɨ lə Jɨpɨ je, rəi əli Jayrusɨ əi nə: «NGoni oy, ɨtapɨ NJe ndo, al ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lokɨ Jəju oo ta kəlde be nɨngə, use dɔ tɨ al, ə əl kɨ bo kɨ dɔ kəy kaw-naa tɨ ə nə: «Adɨ ɓəl rai al, adɨ mei par!» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jəju ɔgɨ kadɨ dɨje awi sie, nə ɨyə̰ Pɨyər nɨm, Jakɨ nɨm, Ja̰ kɨ ngoko̰ Jakɨ nɨm par ə adɨ awi sie. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lokɨ rəi tḛḛi ɓe lə kɨ bo kɨ dɔ kəy kaw-naa tɨ nɨngə, Jəju oo dɨje kɨ ɨsɨ sɨngəi sokɨto, ɨsɨ no̰i je, uri wuy je. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jəju ur me kəy tɨ nɨngə, əl-de ə nə: «Ra ban ə dɨje sɨngəi dɔ-naa tɨ sokɨto kɨ no̰ be ə? NGon oy al, nə to ɓi kare.» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dɨje ɨbəi Jəju kogii. Be ə, Jəju adɨ dɨje pətɨ tḛḛ taga, nɨngə baw ngon nɨm, ko̰ ngon nɨm, njé ndo je lie kɨ dani-e nɨm par ə awi sie me kəy tɨ kɨ ngon to tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jəju uwə ji ngon, əl-e ə nə: «Talɨta kumi!» Adɨ kɔr me nə: «NGon kɨ dəne, m-əli m-ə nə, ḭ taa!» ");
INSERT INTO bjvNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Taji naa tɨ no̰o̰, ngon kɨ dəne ḭ taa, njɨyə, tadɔ ɓale e dɔgɨ gɨde e joo. Nḛ kɨ Jəju ra kɨn ətɨ dɨje ɓəl kɨ dum. ");
INSERT INTO bjvNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lo kɨn tɨ, Jəju dəjɨ-de kadɨ əli ta nḛ kɨ ra nḛ kɨn dəw madɨ al. Nɨngə, əl-de kadɨ adi nḛ kuso ngon kɨ dəne ka kɨn uso. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jəju ḭ loe tɨ no̰o̰, aw ɓe bo tɨ kɨ tɔgɨ tɨ, naa tɨ kɨ njé ndo je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lokɨ ndɔ ta kə̰ə̰ lə *Jɨpɨ je asɨ nɨngə, Jəju ɨlə ngɨrə ndo dɨje nḛ me kəy kaw-naa tɨ lə Jɨpɨ je. Dɨje ngay kɨ oi nḛ ndo lie, nḛ ndo kɨn ətɨ-de ɓəl, adɨ əli əi nə: «Dəw kam, ɨngə nḛ ndo kɨn ra ə? Ə na̰ ə ade gosɨ ta kɨ ətɨ ɓəl be kɨn ə? Tɔgɨ kɨ ra-n nḛ kɔjɨ je kɨ ətɨ ɓəl be kɨn ɨngə ra ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ma nje kɨjə kagɨ wa ka am wa? E ngon lə Mari al a? Jakɨ je, kɨ Jose je, kɨ Judɨ je, kɨ Sɨmo̰ je, əi ngako̰e je al a? Taa, konane je ka ɨsi səje ne tɔ al a?» Ta kɨ dəji kɨn ɔgɨ-de kadɨ adi mede Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Be ə, Jəju əl-de ə nə: «NJe kəl ta kɨ ta Luwə tɨ ɓa, e me ɓe koje tɨ, kɨ dan noje je tɨ, kɨ me kəy tɨ lie ə dɨje a kɨdi-e tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lo kadɨ Jəju ra nḛ kɔjɨ kɨ ətɨ ɓəl me ɓe tɨ kɨ Najarətɨ tɨ goto, nə ɨndə jine dɔ njé mo̰y je tɨ kɨ na̰ je gandɨ gandɨ par, adɨ-de ɨngəi rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","NDɔjɨ Jəju ngay kɨ mbata mbatɨ kɨ mbati kadi-e mede. Jəju njɨyə kɨ ngan ɓe je kɨ gugɨ dɔ Najarətɨ, ndo dɨje nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nɨngə, Jəju ɓar njé ndo je ləne kɨ dɔgɨ gɨde e joo, ə ɨlə-de joo joo. Adɨ-de tɔgɨ dɔ ndɨl je tɨ kɨ majal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jəju ndɔr mbide kadɨ uni nḛ kare mbata dɔ rəbɨ al, nə gɔl kare ba par. Əl-de ə nə: «A uni nḛ kuso al nɨm, ɓɔl al nɨm, taa a ɓɨgɨri la me kulə dɔ ɓədɨsi tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ɨləi sa njasi tɨ, ə awi kɨ kɨbɨ kare ba.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kɨn ə uri me kəy tɨ madɨ, ə uwə səsi rɔne tɨ ə, ɨsi tɨ ratata ndɔ kawsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ə re lo madɨ tɨ, ə dɨje mbati kuwəi səsi kɨ rɔde tɨ, ə se mbati koo dɔ ta ləsi, lokɨ ɨsɨ tḛḛi me ɓe tɨ kɨn kɨ taga nɨngə, ɨndəi bu kɨ njasi tɨ kɔ, mba kadɨ to tə nḛ ndəjɨ ndude. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","*NJé ndo je awi ɨləi mbḛ Poy Ta kɨ Majɨ mba kadɨ dɨje ɨyə̰i kalde kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tuwəi ndɨl je kɨ majal ngay taa uri yɨbɨ dɔ njé mo̰y je tɨ ngay adɨ ɨngəi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","NGar *Erodɨ oo ta lə Jəju, tadɔ tɔɓa lie asɨ lo je nakɨ nakɨ. Dɨje kɨ na̰ je əi nə: «Ja̰ Batɨsɨ ḭ taa dan njé koy je tɨ. Gɨne kɨn ə aw-n kɨ tɔgɨ mba ra-n nḛ je kɨ ətɨ ɓəl ɓəl.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","NJe kɨ nungɨ əli əi nə: «E Eli kɨ nje kəl ta kɨ ta Luwə tɨ.» NJé kɨ na̰ je ɓəy əli əi nə: «E nje kəl ta kɨ ta Luwə tɨ tə njé kɨ rəi kəte kɨn be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lokɨ Erodɨ oo ta kɨn nɨngə, əl ə nə: «E Ja̰ kɨ ndɔ kɨ madɨ gangi dɔe ka ə ḭ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erodɨ əl be, tadɔ ndɔ kɨ adɨ uwəi Ja̰, dɔɔi-e kɨ sən, ɨləi-e dangay tɨ, mbata lə Erodɨyadɨ, kɨ ne ngoko̰e Pɨlɨpɨ, kɨ tae nene tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ə Ja̰ əl-e ta dɔ tɨ ə nə: «E go tɨ al kadɨ ɨtaa ne ngoko̰i, nei tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Wongɨ ra Erodɨyadɨ dɔ Ja̰ tɨ ngay, adɨ sangɨ rəbɨ tɔl-e, nə asɨ tɔl-e al. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tadɔ Erodɨ ɓəl Ja̰, gər kadɨ e dəw kɨ nje ra nḛ kɨ dana, taa e dəw kɨ ay njay tɔ. Be ə, Erodɨ ngəm-e-n majɨ. Lokɨ Erodɨ oo ta kəl Ja̰ nɨngə, ta kɨn uwe kɨ ta, nə be ka, Erodɨ ge koo ta kəl Ja̰ par par. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","NDɔ kɨ majɨ kɨ Erodɨyadɨ ɨsɨ sangɨ kəte kəte ka re nga. Adɨ e ndɔ rɔnəl kojɨ Erodɨ, ə Erodɨ adɨ rai nḛ kuso. Nɨngə ndɔe tɨ kɨn, Erodɨ ɓar kɨ bo je ləne nɨm, ɓar njé kun dɔ njé rɔ je ləne nɨm, taa ɓar njé tɔɓa je kɨ dɔnangɨ Galile tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dɔkagɨlo kuso nḛ tɨ, ngon lə Erodɨyadɨ kɨ dəne, ur kəy gode tɨ, ndam. NDam lə ngon kɨ dəne kɨn nəl Erodɨ ngay, taa nəl dɨje kɨ ɓar-de lo nḛ kuso tɨ ngay tɔ, adɨ ngar əl ngon kɨ dəne ka kɨn ə nə: «Ɨdəjɨ-m nḛ kɨ mei ge par ə m-a m-adi.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Erodɨ aw bɨtɨ un ndune kɨ kɨbɨ rɔ ade ə nə: «Nḛ je pətɨ kɨ ɨdəjɨ-m, ə m-a m-adi. Re e dəbɨ ko̰ɓe ləm ka a ɨngə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","NGon kɨ dəne tḛḛ aw taga, aw dəjɨ kone ə nə: «E ri ə kadɨ m-dəje ə?» Ə ko̰e əl-e ə nə: «Ɨdə-je dɔ Ja̰ Batɨsɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","NGon kɨ dəne təl langɨsi ba aw rɔ ngar tɨ əl-e ə nə: «Təkɨ j-a-n taji-naa tɨ ne wa kɨn, kadɨ adɨ-m dɔ Ja̰ Batɨsɨ me supɨra tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me ngar tujɨ ɔjɨ-n dɔ nḛ kɨ ngon kɨ dəne dəje kɨn, nə lo kadɨ ɔge goto kɨ mbata kun mɨndɨ kɨ un, taa kɨ mbata dɨje kɨ ɓar-de lo nḛ kuso tɨ tɔ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Be ə, taji-naa tɨ no̰o̰, ngar un ndune adɨ asɨgar kare kɨ nje ngəm-e kadɨ aw kəy dangay tɨ gangɨ dɔ Ja̰ re-n. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Asɨgar aw gangɨ dɔ Ja̰ me supɨra tɨ, re-n adɨ ngon kɨ dəne, nɨngə ngon kɨ dəne ka kɨn təl-n adɨ kone. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lokɨ njé ndo je lə Ja̰ oi poye nɨngə, rəi uni nɨne awi dɨbi. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lokɨ njé kaw kɨlə je təli lo kɨlə je tɨ ləde nɨngə, kawi-naa rɔ Jəju tɨ, ɔri-e poy nḛ je kɨ rai kɨ nḛ je kɨ nḛ je kɨ ndoi dɨje adi-e oo. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kosɨ dɨje ngay awi nɨm, təli nɨm adɨ lo kadɨ njé ndo je ɨngəi ngon dɔkagɨlo ndi be kadɨ usoi nḛ ka goto. Be ə, Jəju əl-de ə nə: «Ɨrəi adɨ j-awi lo kɨ dɨje gotoi tɨ mba kadɨ ɔri kə̰ə̰ ndə̰y.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Be ə, ali me to tɨ mba kaw kɔsɨ rɔde ngərəngɨ, lo kɨ dɨje gotoi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dɨje ngay ooi-de lo kawde tɨ, ə gəri-de ɓətɨ tɔ. Dɨje ḭḭ ɓe bo je tɨ kɨ dangɨ dangɨ, a̰yḭ-naa kɨ njade bur bur awi kəte, lo kɨ Jəju kɨ njé ndo je ɨsɨ awi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lokɨ Jəju ur nangɨ me to tɨ nɨngə, oo kosɨ dɨje ngay. Lokɨ oo-de, oo kəm-to-ndoo ləde, tadɔ ai tə batɨ je kɨ nje kul-de goto be. E be ə, Jəju un dɔkagɨlo ngay ndo-n-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lokɨ kadɨ yətɨ rɔne kɨ bəlme taa njé ndo je ɔti kɨ rɔ Jəju tɨ əli-e əi nə: «Lo kɨ j-ai me tɨ ne kɨn, e lo kɨ dɨje gotoi tɨ, nɨngə kadɨ ɨsɨ ur tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Majɨ kadɨ ɨtuwə dɨje kam adɨ awi kɨ lo ndɔr je tɨ, kɨ ngan ɓe je tɨ, ndogi nḛ kuso usoi.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nə Jəju təl əl-de ə nə: «Səi je wa adi-de nḛ usoi.» Nɨngə, njé ndo je dəji-e əi nə: «Kadɨ j-aw jɨ ndogɨ mapa asɨ sɨlə ɓu joo j-adɨ-de usoi wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jəju təl əl-de ə nə: «Mapa kɨ jisi tɨ e ban ə? Awi dan dɨje ooi.» Lokɨ awi dan dɨje tɨ, dəji nɨngə, təli əli-e əi nə: «Mapa e mi, ə kanjɨ joo tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jəju un ndune adɨ-de kadɨ adi dɨje ɨsi nangɨ kɨ kute kute dɔ wale tɨ kɨ mbəl. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Be ə, dɨje uwəi-naa ɓu ɓu je, kutɨ mi kutɨ mi je, ə ɨsi nangɨ kɨ bare bare. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jəju ɔy mapa kɨ mi kɨ kanjɨ kɨ joo, un kəmne kɨ taa, əl ta kɨ Luwə mba kadɨ njangɨ dɔ nḛ kuso kɨn. Go tɨ, Jəju uwə mapa je ka kɨn gangɨ naa tɨ ə adɨ njé ndo je kadɨ ləbi kosɨ dɨje. Kanjɨ je kɨ joo ka, Jəju ləbɨ dɨje pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dɨje pətɨ usoi nḛ ndani majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nɨngə, njé ndo je ɔyi gɨndɨ mapa je, kɨ kanjɨ je kɨ nay, kare dɔgɨ gɨde e joo ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dɨje kɨ usoi nḛ kɨn asi dɨngəm je dɨbɨ mi. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","NDə̰y ba go tɨ, Jəju ɔsɨ njé ndo je ləne kadɨ ali me to tɨ, awi gɨdɨ ba tɨ kəte no̰ne tɨ, kɨ kaw kɨ ɓe bo Bətɨsayda tɨ nu. Nɨngə dɔkagɨloe tɨ kɨn, e a tuwə kosɨ je kadɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lokɨ Jəju adɨ-de awi nɨngə, ɔtɨ aw dɔ mbal tɨ mba kəl ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lokɨ lo ndul ngata nɨngə, to e dan batɨ, ə Jəju e kɨ karne ba ə nay nangɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jəju oo kadɨ njé ndo je ləne ɨngəi ko̰ ngay lo kɔsɨ to tɨ, tadɔ nəl ɨlə, sur to kɨ gogɨ gogɨ, adɨ pungɨ ba ra-de majal. Dan lo tɨ ɓa, Jəju ḭ a njɨyə dɔ man tɨ, ɨsɨ aw kɨ rɔde tɨ, nɨngə ge kadɨ n-də tade ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ə lokɨ ooi-e a njɨyə dɔ man tɨ nɨngə, ooi kadɨ e muwə̰ dəw yo, adɨ uri kɔl. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Əi je wa pətɨ ooi-e, adɨ ɓəl rade ngay. Nə kalangɨ ba, Jəju əl-de ə nə: «Adi mesi osɨ nangɨ nə e mi, ə ɨɓəli al!» ");
INSERT INTO bjvNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jəju al gode tɨ me to tɨ nɨngə, gɨn nəl gangɨ. Nḛ je kɨn ətɨ-de ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tadɔ kɨ rɔjetɨ, njé ndo je gəri kəm nḛ kɨ Jəju ra ɔjɨ dɔ mapa kɨn al, kɨ mba me nga̰ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lokɨ Jəju əi kɨ njé ndo je ləne ɨndəi ba gangi nɨngə, tḛḛi dɔnangɨ Gənəjarətɨ tɨ, ɨndəi to ləde nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lokɨ uri nangɨ taa par ə, dɨje gəri Jəju; ");
INSERT INTO bjvNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","adɨ a̰yḭ-naa ngɔdɨ asi ɓe je kɨ dɔnangɨ Gənəjarətɨ tɨ nakɨ, nakɨ. Dɨje ɨləi rɔde, ɔyi njé mo̰y je ləde me nḛ kotɨ njé mo̰y je tɨ, rəi səde rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lo je pətɨ kɨ aw tɨ, ngan ɓe je, kɨ ɓe bo je, kɨ lo ndɔr je, dɨje rəi kɨ njé mo̰y je ɓuki-de ta mbalo tɨ, ə no̰i dɔ Jəju tɨ kadɨ ɨyə̰ njé mo̰y je adɨ ɔdi ta kɨbɨ lie par ə a ɨngəi rɔ nga. Nɨngə, njé kɨ ɔdi ta kɨbɨ lie, ɨngəi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Parɨsɨ je kɨ njé ndo ndu-kun je madɨ ḭḭ Jorijaləm tɨ, kawi-naa dɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nɨngə ooi kadɨ njé ndo je lie kɨ madɨ je usoi nḛ kɨ jide kɨ yoro, kɨ kanjɨ togɨ kɨ go jibəl rae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","NGa nɨngə təkɨ rɔjetɨ, Parɨsɨ je əi kɨ *Jɨpɨ je ba pətɨ, a usoi nḛ kɨ kanjɨ kadɨ a togi jide kadɨ ay njay al. Adɨ e kɨndə kəm go nḛ jibəl ɓe tɨ lə kade je. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Be tɔ ə, re təli sukɨ tɨ nɨngə, a ndogi man rɔde sukɨ sukɨ ɓəy taa a usoi nḛ. Awi kɨ nḛ jibəl ɓe je kɨ rangɨ ngay kɨ ɨndəi kəmde go tɨ ɓəy tə togɨ nḛ ka̰y man je kɨ ngo je kɨ ngoo nɨngə-kasɨ je, kɨ go rəbɨ ra-e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parɨsɨ je kɨ njé ndo ndu-kun je dəji Jəju əi nə: «MBa ri ə njé ndo je ləi təli rɔde go nḛ jibəl ɓe tɨ lə kaje je al ə? Usoi nḛ kɨ jide kɨ yoro kɨ kanjɨ togɨ kɨn me nə ri ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jəju ɨlə-de tɨ ə nə: «Ta kɨ Luwə əl kɨ ta nje kəl ta kɨ tane tɨ Ejay dɔsi tɨ e ta kɨ rɔjetɨ. Səi njé kədɨ kəm dɨje, tadɔ Luwə adɨ Ejay ndangɨ ə nə: “Gɨn dɨje kɨn ɔsi gonm kɨ nda tade kare, Nə mede e sa̰y səm. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tɔjɨ kɨ ɨsɨ ɨləi dɔm tɨ, ndae goto, Tadɔ nḛ ndo je kɨ ɨsɨ ndoi dɨje ka, E kəm-kədɨ kɨ ḭ rɔ dɨje tɨ tɔ.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jəju əl-de ə nə: «Ɨyə̰i ndu-kun lə Luwə dəbɨ kare, ə ɨtəli rɔsi go nḛ jibəl ɓe tɨ lə dɨje yo.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nɨngə, Jəju əl ɓəy ə nə: «To rɔsi al kadɨ ɨyə̰i go ndu-kun lə Luwə kalangɨ ba mba kadɨ ɨngəmi go nḛ jibəl ɓe ləsi! ");
INSERT INTO bjvNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Təkɨ rɔjetɨ, *Mojɨ ə nə: “Ɔsɨ gon bawi kɨ ko̰i.” Taa əl ɓəy ə nə: “Dəw kɨ tajɨ bawne ə se kone asɨ ta koy.” ");
INSERT INTO bjvNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nə səi, əli əi nə: “Re dəw madɨ əl bawne ə se kone ə nə: ‹Nḛ majɨ je kɨ re m-a m-ɔsɨ-n sɔli ə e kɔrba̰,› adɨ e kadɨ-kare lə Luwə.” ");
INSERT INTO bjvNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E kɨn ɔjɨ kadɨ uti ta rəbɨ kadɨ dəw madɨ ra nḛ ɔsɨ-n sɔl bawne ə se kone. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɨgo̰i tujɨ kɨ ɨsɨ tuji ta lə Luwə kɨ nḛ jibəl ɓe ləsi, kɨ ɨsɨ ɨndoi dɨje kɨ kəte kəte kɨn oi! Taa nḛ je kɨ rangɨ kɨ toi be ngay kɨ ɨsɨ rai e no̰o̰ ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Go tɨ nɨngə, Jəju ɓar kosɨ dɨje kɨ rɔne tɨ ɓəy ə əl-de ə nə: «Səi pətɨ, uri mbisi majɨ oi ta ləm, ə kadɨ ɨgəri mee tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nḛ madɨ kɨ ḭ taga aw me dəw tɨ, kɨ a təl-e nḛ kɨ to njḛ tɨ goto. Nə nḛ kɨ ḭ me dəw tɨ ə a təl dəw nḛ kɨ to njḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Re dəw madɨ aw kɨ mbine kadɨ oo-n dɔ ta nɨngə, kadɨ oo. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lokɨ Jəju ɨyə̰ kosɨ dɨje, ə təl aw me kəy tɨ nɨngə, njé ndo je lie dəji-e kadɨ ɔr-de gɨn kujɨ ta ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jəju əl-de ə nə: «Adɨ səi je wa ka ɨgəri nḛ al tɔ a? Ɨgəri me ta kɨ m-ge kəl kɨn al a? Nḛ pətɨ kɨ ḭ taga kɨ aw me dəw tɨ, nḛ kare kɨ a təl-e kɨ njḛ tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Təkɨ rɔjetɨ, nḛ je kɨn pətɨ awi nga̰me tɨ al, nə awi kandae tɨ yo, ɓa go tɨ, tḛḛi kɔ.» Ta lə Jəju kɨn tɔjɨ kadɨ nḛ kuso je pətɨ əi kɨ kay njay. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɨngə Jəju əl-de ɓəy ə nə: «Nḛ kɨ ḭ me dəw tɨ ə e nḛ kɨ nje təl dəw nḛ kɨ to njḛ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","E me dəw tɨ kəy, e nga̰me dəw tɨ ə, mər ta je kɨ majal ɨsɨ tḛḛ tɨ, kɨ kaya kɨ ra, kɨ ɓogɨ, kɨ tɔl-naa, ");
INSERT INTO bjvNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kɨ kuwə marɨm, kɨ ra kəm-nda nḛ, kɨ me ndul, kɨ kədɨ-naa, kɨ nḛ ra kɨ go rəbe tɨ al, kɨ kɔjɨ rɔ, taa kɨlə ra je kɨ to mbə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nḛ je kɨn pətɨ ḭḭ me dəw tɨ, nɨngə əi ə təli-e nḛ kɨ to njḛ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jəju ḭ loe tɨ no̰o̰ nɨngə, aw dɔnangɨ tɨ kɨ Tɨr. Aw ur me kəy tɨ madɨ, ge kadɨ dɨje gəri gone al, nə loe goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Təkɨ rɔjetɨ, re wa kɨ Jəju re tḛḛ ɓəy par ə, dəne madɨ kɨ ndɨl kɨ majal ɨsɨ adɨ ko̰ ngone kɨ dəne oo ta lie, ə a̰y re osɨ nangɨ njae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","E dəne kɨ e Jɨpɨ al, ɓe koje e Pənəsi, dɔnangɨ Sɨri tɨ. No̰ kɨ dɔ Jəju tɨ kadɨ tuwə ndɨl kɨ majal kɨ ɨsɨ adɨ ko̰ ngonne kɨn kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nə Jəju əl-e ə nə: «Ɨyə̰ adɨ ngan je kɨ me kəy tɨ usoi asɨ-de ɓəy taa. Tadɔ e go tɨ al kadɨ dəw un nḛ kuso lə ngan je, ɨlə adɨ ngan bɨsɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ə dəne ka kɨn ɨlə tɨ ə nə: «E rɔjetɨ Ɓaɓe, nə ke ə, ngan bɨsɨ je kɨ ai gɨn tabɨlə tɨ, a usoi yongɨrɔ nḛ je kɨ tḛḛ ta ngan je tɨ tosɨ nangɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nɨngə Jəju əl-e ə nə: «Ta kul ta kɨ tḛḛ tai tɨ kɨn, ɔtɨ aw ɓe ləi, tadɔ ndɨl kɨ majal tḛḛ me ngoni tɨ kɨ dəne kɔ ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dəne ka kɨn təl aw ɓe nɨngə, ɨngə ngonne, to dɔ tɨrə tɨ kare, mbata ndɨl kɨ majal ka kɨn tḛḛ rɔe tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jəju ḭ dɔnangɨ Tɨr, gangɨ Sɨdo̰, nɨngə ɨndə dɔnangɨ ɓe bo je kɨ dɔgɨ gangɨ ɓəy taa re tḛḛ ta ba Galile tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dɨje rəi kɨ dɨngəm kare kɨ mbie bəy, kɨ lo kəl ta to rɔe, rɔ Jəju tɨ, dəji-e kadɨ ɨndə jine dɔe tɨ, kadɨ ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jəju ɔr-e kɨ kare ba aw sie sa̰y kɨ kosɨ dɨje. Lokɨ tɨlə ngan jine je mbi nje mo̰y tɨ nɨngə, tɨbɨ man tane ɔdɨ-n ndon dɨngəm ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Go tɨ nɨngə, Jəju un kəmne kɨ dɔra̰ tɨ, ɨlə kə̰ə̰ pṵṵ, ə əl ə nə: «Epata» (kɔr me ta kɨn nə: ɨmbutɨ). ");
INSERT INTO bjvNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Taji naa tɨ no̰o̰ par ə mbi dɨngəm ka kɨn mbutɨ, ə ndone tutɨ adɨ əl ta ay njay njay. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jəju ndɔr mbi dɨje kɨ oy nḛ kɨn kadɨ dəw əl tae kəte adɨ dəw kɨ rangɨ oo al. Lokɨ ndɔr mbide kɨ nja naa tɨ naa tɨ kadɨ dəw ɔr poy nḛ kɨn al nɨngə, kadɨ be ɓəy ə dɨje ɔri poy nḛ rae kɨ kəte kəte. ");
INSERT INTO bjvNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nḛ ra Jəju ətɨ kosɨ dɨje ɓəl ngay adɨ əli əi nə: «Nḛ rae je pətɨ majɨ: Ra njé je kɨ mbide bəy adɨ ooi dɔ ta, taa ra mbɨki je adɨ əli ta tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Me ndɔ je tɨ kɨn, kosɨ dɨje ngay kawi-naa təkɨ rangɨ ɓəy dɔ Jəju tɨ. Nɨngə, nḛ kɨ kadɨ usoi goto. Be ə Jəju ɓar njé ndo je ləne əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«M-o kəm-to-ndoo lə kosɨ dɨje kɨn, tadɔ ndɔ mɨtə ɓone ə əi səm naa tɨ, nɨngə nḛ kɨ kadɨ usoi goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Re m-tuwə-de madɨ awi ɓe kɨ mede kɨ ɓo ba ə, ɓo a taa tɔgɨde rəbə, tadɔ njé kɨ madɨ dande tɨ ḭḭ sa̰y ə rəi.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","*NJé ndo je lie təli əli-e əi nə: «J-a j-ɨngə mapa ra dɨlə lo tɨ ne, ə a usoi asɨ-de ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jəju dəjɨ-de ə nə: «Mapa kɨ jisi tɨ e ban ə?» Ə əli-e əi nə: «Mapa e sɨri.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Go tɨ nɨngə, Jəju əl kosɨ dɨje kadɨ ɨsi nangɨ. Ɔy mapa kɨ sɨri ka kɨn jine tɨ, ra oyo Luwə dɔ tɨ nɨngə, gangɨ naa tɨ, ə adɨ njé ndo je ləne, kadɨ adi kosɨ dɨje. Be ə, njé ndo je taai ləbi kosɨ dɨje tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Awi kɨ ngan kanjɨ je jide tɨ tɔ. Jəju ra oyo Luwə dɔ tɨ ə adɨ njé ndo je ləne kadɨ ləbi dɨje tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dɨje usoi nḛ ndani, adɨ, njé ndo je kawi gɨnde je kɨ nay, kare sɨri. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dɨje kɨ usoi nḛ, asi dɨbɨ sɔ. Go tɨ nɨngə, Jəju ɨyə̰-de adɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kalangɨ ba go tɨ, Jəju əi kɨ njé ndo je ləne ali me to tɨ, awi dɔnangɨ Dalmanuta tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Parɨsɨ je ḭḭ no̰o̰ rəi nɨngə, ɨləi ngɨrə najɨ ta tɨ kɨ Jəju, ɓa dəji-e kadɨ ra nḛ kɔjɨ madɨ kɨ ḭ dɔra̰ tɨ adɨ-de n-ooi. Dəji-e be tə kulə kɨ kɨyə mba kuwə-n dəw. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jəju ɨlə mene pṵṵ, ə əl-de ə nə: «MBari ə dɨje kɨ dɔkagɨlo tɨ kɨ ɓone dəji mba kadɨ n-ooi nḛ kɔjɨ kɨ ətɨ ɓəl ə? Təkɨ rɔjetɨ, adɨ m-əl səsi madɨ oi, nḛ kɔjɨ madɨ kɨ kadɨ dəw a ra kɨ mbata ləde goto.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Be ə, Jəju ɨyə̰-de, ə al me to tɨ mba kaw dam ba tɨ kɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Me njé ndo je oy dɔ mapa tɨ kɨ kadɨ ɔyi. E kɨ jide tɨ kɨ ɨsi me to tɨ e kare ba par. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jəju ndəjɨ-de, ə əl-de ə nə: «Oi majɨ! Adi kəmsi ədɨ dɔ rɔsi tɨ, ɔjɨ-n dɔ əm lə *Parɨsɨ je, kɨ əm lə Erodɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","*NJé ndo je naji-naa ta dande tɨ əi nə: «Jəju əl be tadɔ jɨ rəi kɨ mapa al!» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jəju gər ta kɨ mede tɨ, adɨ əl-de ə nə: «MBa ri ə ɨsɨ naji-naa ta dansi tɨ dɔ mapa tɨ kɨ ɔyi al ə? Ɨgəri me nḛ je al ka ɓəy a? Kəmsi tḛḛ dɔ nḛ je tɨ madɨ al ka ɓəy a? Səi dɨje kɨ ku dɔsi goto a? ");
INSERT INTO bjvNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kəmsi to mba kadɨ oi lo al a? Rai mbisi kadɨ oi dɔ ta al a? Mesi ole dɔ tɨ al a? ");
INSERT INTO bjvNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","NDɔ kɨ m-ləbɨ mapa mi, dɨngəm je dɨbɨ mi kɨn, gɨndɨ mapa kɨ nay, ɔyi kare ban ə?» Nɨngə əli əi nə: «J-ɔy kare dɔgɨ gɨde e joo.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«NGa ndɔ kɨ, m-ləbɨ mapa sɨri dɨngəm je dɨbɨ sɔ kɨn, gɨnde je kɨ nay, ndɔ kɨ ɔyi kare ban ə?» Nɨngə əli-e əi nə: «J-ɔy kare sɨri.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lo kɨn tɨ, Jəju əl-de ə nə: «Ɨgəri al ɓəy a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lokɨ Jəju əi kɨ njé ndo je ləne rəi tḛḛi me ɓe tɨ kɨ Bətɨsayda tɨ nɨngə, dɨje rəi kɨ nje kəm tɔ kare rɔ Jəju tɨ. Dɨje ka kɨn no̰i dɔ Jəju tɨ kadɨ ɔde. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jəju uwə ji nje kəm tɔ ka kɨn, ə aw sie gɨdɨ ɓe tɨ. Lokɨ yo̰m kəme kɨ man tane nɨngə, ɨndə jine dɔe tɨ ə dəje ə nə: «O nḛ madɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","NJe kəm tɔ go̰ lo nɨngə ə nə: «M-o dɨje, nə to ə toi tə kagɨ je ə a njɨyəi be.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jəju təl ɨndə jine dɔ kəme tɨ nja kare ɓəy adɨ oo lo ay njay njay ngata. Ɨngə rɔ nga, ta oo nḛ je pətɨ ay njay njay tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Go tɨ nɨngə, Jəju ɨyḛ adɨ aw ɓe ləne, ə əl-e ə nə: «Otɨ təl kaw me ɓe tɨ kɨn gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jəju ɔtɨ loe tɨ no̰o̰ nɨngə, awi kɨ njé ndo je ləne ngan ɓe je tɨ kɨ gɨdɨ Səjare tɨ, kɨ Pɨlɨpɨ. Lokɨ əi dɔ rəbɨ tɨ, Jəju dəjɨ-de ə nə: «Dɨje ɨsɨ əli ta kɨ dɔm tɨ təkɨ mi na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ə njé ndo je əli-e əi nə: «Dɨje madɨ əi nə ḭ Ja̰ Batɨsɨ; njé kɨ nungɨ əi nə ḭ nje kəl ta kɨ ta Luwə tɨ Eli; njé kɨ rangɨ ɓəy əi nə ḭ kɨ kare dan njé kəl ta je kɨ ta Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nɨngə, Jəju təl re dəjɨ-de əi je wa ə nə: «NGa səi wa kɨ dɔsi, əli əi nə mi na̰ ə?» Ə Pɨyər ɨle tɨ ə nə: «Ḭ Kɨrɨsɨ, kɨ Luwə mbəte.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jəju ndəjɨ-de kɨ tɔgɨne kadɨ əli ta kɨn kəte kadɨ dəw kɨ rangɨ oo al. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Go ta je tɨ kɨn nɨngə, Jəju ɨlə ngɨrə kadɨ ndo-de təkɨ ne *NGon dəw n-a n-ɨngə ko̰ ngay. *NGatɔgɨ je lə *Jɨpɨ je, kɨ kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je a mbati-ne. Dɨje a tɔli-ne, nə ndɔ kɨ ko̰ mɨtə lə ndɔ koyne ɓa, n-a n-tḛḛ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Əl-de ta je kɨn pətɨ ay njay. Pɨyər ɔr Jəju aw sie dəbɨ kare, nɨngə ɨlə ngɨrə kɔl sie. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nə Jəju təl rɔne, go̰ njé ndo je ləne nɨngə ndangɨ Pɨyər kɨ tɔgɨne ngay ə nə: «Ɨtəl gogɨ *Sata̰, ɔr rɔi kɔ gom tɨ! tadɔ mər ta ləi e mər ta kɨ ḭ rɔ Luwə tɨ al, nə e mər ta lə dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Go tɨ nɨngə, Jəju ɓar kosɨ dɨje kɨ njé ndo je ləne, nɨngə əl-de ə nə: «Re dəw madɨ ndɨgɨ njɨyə gom tɨ nɨngə, kadɨ oo rɔne tə nḛ madɨ al, kadɨ e wa un kagɨ-dəsɨ koy ləne, ə re un gom. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Təkɨ rɔjetɨ, dəw kɨ ge kajɨ rɔne ne wa dɔnangɨ tɨ ne a tḭ ta rɔne. Nə dəw kɨ tḭ ta rɔne kɨ mbata ləm, ə se kɨ mbata Poy Ta kɨ Majɨ, a ajɨ rɔne tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kɨn ə re dəw ɨngə nḛ majɨ je kɨ dɔnangɨ tɨ ne pətɨ tɨgə, nə ndɨle tujɨ ə, maje to ra be ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nḛ madɨ kɨ dəw a adɨ ɔr-n to ndɨlne to no̰o̰ a? ");
INSERT INTO bjvNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Təkɨ rɔjetɨ, re rɔ dəw madɨ sɔl-e kɨ mbata ləm, ə se kɨ mbata ta ləm ta kəm dɨje tɨ kɨ njé ra kaya kɨ njé ra majal kɨ dɔkagɨlo tɨ kɨn, mi NGon dəw m-a m-ra rɔsɔl dɔe tɨ tɔ, ndɔe tɨ kɨ m-a m-re-n me kɔsɨ-gon tɨ lə Bawm, naa tɨ kɨ malayka je kɨ ayi njay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jəju əl-de ɓəy ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi: dɨje madɨ dansi tɨ ne a oyi al ɓəy ə, a ooi ko̰ɓe lə Luwə kɨ a re kɨ tɔgɨne kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","NDɔ mehḛ go tɨ nɨngə, Jəju ɔr Pɨyər nɨm, Jakɨ nɨm, taa Ja̰ nɨm tɔ, ə al aw səde dɔ mbal tɨ kɨ ngal, kɨ karde ba, sa̰y kɨ ndəge je. Loe tɨ kɨn no̰o̰, Jəju mbəl rɔne ta kəmde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kɨbɨ je lie ndoləi kə̰y kə̰y, taa ndai nda kɨ dəw kɨ dɔnangɨ tɨ ne kɨ kadɨ a togɨ kɨbɨ adɨ nda be goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nɨngə lo kɨn tɨ no̰o̰, Eli əi kɨ *Mojɨ tḛḛi kɨ rɔde tɨ hɔy, a əli ta kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ə Pɨyər un ta əl Jəju ə nə: «NJe ndo dɨje, kɨn ə j-ɨsi lo kɨn tɨ ne be par ə majɨ ngay. J-a ra kəy-lo mɨtə: kare e ya̰i, kare e ya̰ Mojɨ, ə kɨ kare e ya̰ Eli tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pɨyər gər ta wa bangɨ kɨ kadɨ əl al, tadɔ əi kɨ madɨne je kɨ joo pu, ɓəl rade ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nɨngə, taji naa tɨ no̰o̰, kɨl ndi ḭ səbɨ dɔde lɨtɨ. NDu ta madɨ tḛḛ me kɨl ndi tɨ ə nə: «E kam e NGonm kɨ m-ndɨge ngay, ə oi ta lie.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kɨ kəm kɨ kɨndə jɨpɨ, njé ndo je go̰i lo gə gɨdɨde, nə dəw kare ka ooi-e al. Jəju kɨ karne ba par ə ooi-e rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lokɨ ḭḭ dɔ mbal tɨ ɨsɨ uri kɨ nangɨ nɨngə, Jəju ndəjɨ-de kadɨ ɔri poy nḛ kɨ ra nḛ ə ooi kɨn dəw madɨ al, bɨtɨ kadɨ ne *NGon dəw n-tḛḛ dan njé koy je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","*NJé ndo je təli rɔde go ta tɨ kɨ Jəju əl-de, nə ke ə, gəri me ta kɨ nə: «Kḭ taa dan njé koy je tɨ kɨn» al, adɨ naji-naa ta dɔ tɨ dande tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Go tɨ, njé ndo je dəji-e əi nə: «MBari ə, njé ndo ndu-kun je əi nə sɔbɨ kadɨ Eli re kəte taa ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jəju ɨlə-de tɨ ə nə: «E kɨ rɔjetɨ kadɨ Eli a re kəte ɓəy taa, mba kadɨ ra go nḛ je pətɨ adɨ asɨ-naa gogɨ. NGa ra ban ə, ndangi me makɨtɨbɨ tɨ lə Luwə, sɔbɨ dɔm mi NGon dəw ɓəy əi nə: “NGon dəw a ɨngə ko̰ ngay, taa dɨje a kɨdi-e tɔ” ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Təkɨ rɔjetɨ, adɨ m-əl səsi madɨ oi, Eli re, ə dɨje rai sie nḛ kɨ mede ge, təkɨ ndangi me makɨtɨbɨ tɨ sɔbɨ-n dɔe.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lokɨ təli rəi rɔ ndəgɨ njé ndo je tɨ nɨngə, oi kosɨ dɨje ɨləi-naa gəi dɔde wukɨ, nɨngə njé ndo ndu-kun je ə ɨsɨ naji-naa ta tɨ səde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lokɨ kosɨ dɨje ooi Jəju nɨngə, ndɔjɨ-de ngay, adɨ a̰yḭ-naa bur bur kɨ rɔe tɨ, uwəi jie rai-e lapɨya. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jəju dəjɨ njé ndo je ləne ə nə: «Ta ri ə ɨsɨ naji-naa ta dɔ tɨ səde ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dəw madɨ kare dan kosɨ dɨje tɨ əl-e ə nə: «NJe ndo dɨje, m-re kɨ ngonm rɔi tɨ, tadɔ e gɨn tɔgɨ tɨ lə ndɨl kɨ ra-e adɨ əl ta al. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lo je pətɨ kɨ ndɨl kɨn ḭ sie tɨ nɨngə, ɨge ɨle nangɨ, adɨ kulum tae ɨbə jugɨ jugɨ, ngə ngangɨne gururu gururu, nɨngə nda-je ra̰y, ade to tə kagɨ be. Be ə, m-dəjɨ njé ndo je ləi kadɨ tuwəi ndɨl kɨ majal kɨn dɔe tɨ kɔ, nə asi tɔgɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lo kɨn tɨ, Jəju un ta əl njé ndo je ləne ə nə: «Səi dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨ səi njé me nga̰ je, kadɨ tə m-ɨsɨ səsi dɔkagɨlo ban ɓəy taa adi mesi ə? Kadɨ m-a m-ɔsɨ gɨnsi dɔkagɨlo ban ɓəy taa ə? Ɨrəi kɨ ngon rɔm tɨ ne.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lokɨ rəi kɨ ngon rɔe tɨ nɨngə, taji naa tɨ no̰o̰ wa kɨ ndɨl kɨ majal oo Jəju par ə, dadɨ ngon ka kɨn nangɨ nangɨ, ɓa man tae ḭ kulum mbukɨ mbukɨ, nɨngə bi-e ɨle nangɨ, ade nduguru nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jəju dəjɨ Bawe ə nə: «Dɔkagɨlo kɨ ra tɨ ə nḛ kɨn ɨlə sie ngɨre ə?» Ə Baw ngon ɨle tɨ ə nə: «Ɨlə ngɨre lo kɨ ngon to du ba ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nɨngə, taa taa ndɨl kɨ majal kɨn, ɨsɨ sur-e tɨle kɨ poro je, kɨ me man tɨ je, kadɨ tɔl-e, ə re asɨ ra nḛ madɨ ə, oo kəm-to-ndoo ləje, ɨra səje.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ə Jəju təl əl-e ə nə: «Re asɨ… kɨn əl be kɨ mba ri ə? Dəw kɨ adɨ mene, asɨ ra nḛ je pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ta naa tɨ no̰o̰, baw ngon əl ta kɨ ndune kɨ bo ə nə: «M-adɨ mem, nə kadɨ-me ləm ə e ngay al, ə ɨra səm!» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lokɨ Jəju oo kadɨ kosɨ dɨje ɨsɨ a̰yḭ-naa bur bur kɨ rɔe tɨ nɨngə, ndangɨ ndɨl kɨ majal ə nə: «Ḭ ndɨl kɨ majal kɨ nje bəy mbi dɨje kɨ nje kadɨ dɨje əli ta al, m-un ndum kadɨ ɨtḛḛ rɔ ngon tɨ kɨ kɔ, ə ɨre gogɨ al ratata!» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","NDɨl kɨ majal ka kɨn ur kɔl, ra ngon adɨ dadɨ nangɨ nangɨ kɨ tɔgɨne ngay, nɨngə tḛḛ rɔe tɨ kɔ. NGon təl to təkɨ oy be, adɨ dɨje pətɨ kɨ ooi nḛ kɨ ra nḛ, əli əi nə: «Oy ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nə Jəju uwə ji ngon un-e ur-e taa. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lokɨ Jəju ur me kəy tɨ, ə njé ndo je lie ɨsi sie kɨ karde ba, dəji-e əi nə: «MBari ə je j-asɨ kadɨ jɨ tuwə ndɨl kɨ majal kɨn al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jəju təl əl-de ə nə: «Ko ndɨl je kɨ be kɨn, dəw a tuwə-de kɨ go rəbɨ kəl ta kɨ Luwə taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Əi, ɔti loe tɨ no̰o̰ nɨngə, ɨndəi dɔnangɨ Galile gangi. Jəju ge kadɨ dəw madɨ gər gone al. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tadɔ un dɔkagɨlo mba kadɨ ndo-n nḛ njé ndo je ləne. Be ə əl-de ə nə: «A ɨləi-mi *mi NGon dəw ji dɨje tɨ kadɨ a tɔli-mi, nɨngə lokɨ tɔli-mi oy ɓa, ndɔ kɨ ko̰ mɨtə lə ndɔ koym ə, m-a m-ḭ taa lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","*NJé ndo je gəri me ta lie kɨn al, nɨngə ɓəli kadɨ dəji-e ta dɔ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lokɨ rəi tḛḛi me ɓe tɨ kɨ Kapərnayɨm, ə uri me kəy tɨ nɨngə, Jəju un ta dəjɨ-de ə nə: «Ta ri ə kəte ɨsɨ naji-naa ta dɔ tɨ dɔ rəbɨ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nə təli ɨsi kekeke, tadɔ, dɔ rəbɨ tɨ, naji-naa ta, kadɨ n-gəri se na̰ ə e kɨ bo wa? ");
INSERT INTO bjvNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jəju ɨsɨ nangɨ, nɨngə ɓar njé ndo je ləne kɨ dɔgɨ gɨde e joo, əl-de ə nə: «Re dəw madɨ ge kadɨ n-e dəw kɨ dɔsa̰y nɨngə, majɨ kadɨ təl rɔne dəw kɨ dɔbəy tɨ nɨm, nje ra kɨlə ɓəə kadɨ ndəge je pətɨ nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Go tɨ, Jəju un ngon kɨ du, ur-e dande tɨ, ə lokɨ ore rɔne tɨ ɓa, əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Re dəw madɨ uwə ngon kɨ be kɨn rɔne tɨ me tɔm tɨ ə, e mi wa ə dəwe kɨn uwə-m rɔne tɨ. Nɨngə, dəw kɨ uwə-m kɨ rɔne tɨ, e mi ə uwə-m kɨ rɔne tɨ al, nə e nje kɨlə-m ə uwe kɨ rɔne tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ja̰ əl Jəju ə nə: «NJe ndo dɨje, j-o dəw madɨ kɨ a tuwə ndɨl je kɨ majal me tɔi tɨ, ə jɨ ndɨgɨ kadɨ j-ɔge dɔ ra nḛ kɨn, tadɔ e njɨyə səje goi tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jəju ɨlə-de tɨ ə nə: «Otɨ kadɨ ɔgi-e dɔ, tadɔ dəw kare kɨ a ra nḛ kɨ ətɨ ɓəl me tɔm tɨ kɨ kadɨ a təl kalangɨ ba əl ta kɨ majal dɔm tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Təkɨ rɔjetɨ, dəw kɨ ɔsɨ-je ta al e dəw ləje. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taa re dəw madɨ adɨ səi man ka̰y me ngon kal man tɨ par, mbata ke kɨ səi dɨje lə Kɨrɨsɨ ka, dəwe kɨn, təkɨ rɔjetɨ, adɨ m-əl səsi, a nal nḛ kɨgə go ji ləne al. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Kɨn ə təkɨ dəw madɨ ra adɨ kɨ kare dan njé kɨ du tɨ kɨ adi-mi mede, osɨ me majal tɨ ə, e sotɨ ngay ɓəy mbata tɨ lie kadɨ dɔɔi mbal kɨ bo ngay mɨnde tɨ, ə ɨləi-e me ba tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kɨn ə jii kare rai adɨ osɨ me majal tɨ ə, ɨgange ɨle kɔ. Tadɔ, e sotɨ kadɨ ɨngə kajɨ kɨ jii kɨ kare, ɨtə kadɨ ɨngəm jii je joo pu, ə ɨləi-ni me por tɨ lə su, me por tɨ kɨ a oy al ratata kɨn.  ");
INSERT INTO bjvNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kɨn ə njai kare rai adɨ osɨ me majal tɨ ə, ɨgange ɨle kɔ. Tadɔ, e sotɨ kadɨ ɨngə kajɨ kɨ njai kɨ kare, ɨtə kadɨ ɨngəm njai je joo pu, ə ɨləi-ni me por tɨ lə su.  ");
INSERT INTO bjvNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kɨn ə kəmi kare rai adɨ osɨ me majal tɨ ə, ɔr-e ɨle kɔ. Tadɔ, e sotɨ kadɨ ur ko̰ɓe tɨ lə Luwə kɨ kəmi kɨ kare, ɨtə kadɨ ɨngəm kəmi joo pu, ə ɨləi-ni me por tɨ lə su. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lokɨ kode je kɨ me tɨ oyi al, taa por kɨ səm tɨ ka oy al ratata tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Təkɨ rɔjetɨ, dəw kɨ ra ka por ko̰ je a ra-e adɨ ay njay, təkɨ katɨ a ra-n nḛ kuso adɨ nəl be. ");
INSERT INTO bjvNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Katɨ e nḛ kɨ majɨ, nə lokɨ nəle goto ə, ri ə a rai kadɨ a təl nəl gogɨ ə? Nḛ kɨ kadɨ dəw a ra-n goto. Nɨngə majɨ kadɨ ɨtɔji hal kɨ majɨ kɨ rɔ-naa tɨ, ə ɨsi kɨ naa kɨ lapɨya dansi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jəju ḭ loe tɨ no̰o̰, aw dɔnangɨ Jude tɨ, gɨdɨ ba Jurdḛ tɨ. Kosɨ dɨje kawi-naa gəi gɨde wukɨ ɓəy. Kɨ go jibəl ra-e tɨ lə Jəju, ɨlə ngɨrə ndo-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Parɨsɨ je ɔti rəi rɔ Jəju tɨ, nɨngə kadɨ tə ɨyəi kulə uwəi-e-n me ta tɨ, dəji-e əi nə: «NDu-kun adɨ ta rəbɨ kadɨ dɨngəm tuwə-n nene ə se adɨ ta rəbɨ al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jəju dəjɨ-de ə nə: «NDu-kun ri ə *Mojɨ adɨ səi dɔ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Əi təli əli-e əi nə: «Mojɨ adɨ ta rəbɨ kadɨ dɨngəm tuwə nene, nə ke ə, kadɨ ade makɨtɨbɨ gangɨ-naa jie tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ə Jəju təl əl-de ə nə: «E kɨ mbata me nga̰ ləsi ə Mojɨ ndangɨ-n ndu-kun kɨn adɨ səsi. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nə lo kɨlə ngɨrə kɨndə nḛ je tɨ, Luwə ra dɨngəm əi kɨ dəne. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E be ə, dɨngəm a ɨyə̰ kone je kɨ bawne je, ə a tɨyə̰i-naa kɨ nene, ");
INSERT INTO bjvNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kadɨ təli darɔ kɨ kare. Lo kɨn tɨ, a əi joo al ngata, nə a əi darɔ kɨ kare ba. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nɨngə nḛ kɨ Luwə dɔɔ naa tɨ, majɨ kadɨ dəw gangɨ naa tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lokɨ təli rəi ɓe, njé ndo je lie dəji-e ta dɔ tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ə Jəju əl-de ə nə: «Re dəw tuwə nene, ə taa dəne kɨ rangɨ ə, dəwe kɨn təl nje kuwə marɨm, tadɔ nee kɨ kəte ɨsɨ no̰o̰ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A re e dəne ə mbatɨ ngawne ə taa dɨngəm kɨ rangɨ ka, e nje kuwə marɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dɨje rəi kɨ ngan je kɨ du rɔ Jəju tɨ kadɨ njangɨ dɔde, nə njé ndo je kɔli səde. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lokɨ Jəju oo kɨlə ra njé ndo je ləne nɨngə, nəl-e al adɨ əl-de ə nə: «Ɨyə̰i ngan je kɨ du adɨ rəi rɔm tɨ, otɨ kadɨ ɔgi-de ta rəbɨ, tadɔ ko̰ɓe lə Luwə e ya̰ dɨje kɨ toi tə ngan je kɨ du be. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ ndɨgɨ kadɨ Luwə o̰ ɓe dɔe tɨ tə ngon kɨ du be al, a ur ko̰ɓe tɨ lə Luwə al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Go tɨ, Jəju uwə ngan je kɨ du ka kɨn kɨ rɔne tɨ, ɨndə jine dɔde tɨ, njangɨ dɔde. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lokɨ Jəju ɔtɨ osɨ dɔ rəbɨ tɨ nɨngə, dɨngəm madɨ kare a̰y re osɨ nangɨ njae tɨ, nɨngə dəje ə nə: «NJe ndo kɨ majɨ, e ri ə m-a m-ra ə m-a m-ɨngə-n kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jəju əl-e ə nə: «MBa ri ə ɨɓar-m dəw kɨ majɨ ə? Dəw kare kɨ majɨ goto, nə Luwə kɨ karne ba par ə e dəw kɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ḭ ɨgər ndu-kun je lə Luwə kɨ ə nə: “A tɔl dəw al, a uwə marɨm al, a ɓogɨ al, a ma najɨ kɨ ngom dɔ madi tɨ al, a ra nḛ kɨ majal kɨ dəw madɨ al, ɔsɨ gon bawi əi kɨ ko̰i kɨn majɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dɨngəm ka kɨn əl-e ə nə: «NJe ndo, nḛ je kɨn pətɨ m-təl rɔm go tɨ dɔkagɨlo kɨlə ngɨrə basam tɨ nu.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jəju go̰ dɨngəm ka kɨn kɨ rɔnəl, nɨngə əl-e ə nə: «Nḛ kare be ə nayḭ kadɨ ɨra. Aw, ɨgatɨ kɨ nḛ majɨ je ləi pətɨ, adɨ lae njé ndoo je, ɓa a aw kɨ nḛ kɨngə ngay me dɔra̰ tɨ, ə ɨre un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nə lokɨ dɨngəm ka kɨn oo ta je kɨn nɨngə, kəme ɨl kɨrɨri, ə ɔtɨ aw kɨ rɔnəl al, tadɔ e dəw kɨ aw kɨ nḛ kɨngə ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jəju go̰ njé ndo je ləne kɨ gəi gɨde, nɨngə əl-de ə nə: «A e nḛ kɨ nga̰ ngay rɔ njé nḛ kɨngə je tɨ kadɨ uri me ɓeko̰ tɨ lə Luwə!» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta lə Jəju kɨn ndɔjɨ-de, nə Jəju a dɔ tɨ gərərə ba ə nə: «NGanm je, e nḛ kɨ nga̰ ngay kadɨ dəw ur me ɓeko̰ tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E nḛ kɨ nga̰ ngay kadɨ jambal kɨ oi-e kɨn ur bole kon ku nḛ tɨ, nə a nga̰ ngay ɨtə e kɨn ɓəy kadɨ nje nḛ kɨngə ur me ɓeko̰ tɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta kɨn ətɨ-de ɓəl dɔ made tɨ ɓəy, adɨ dəji-naa dande tɨ əi nə: «NGa kɨn ə e be nɨngə, na̰ ə asɨ kadɨ ɨngə kajɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jəju ɨndə manjɨde ba, nɨngə əl-de ə nə: «Kɨ rɔ dɨje tɨ ɓa, dəw kɨ asɨ goto, nə kɨ rɔ Luwə tɨ ɓa, nḛ kɨ dum-e goto, tadɔ asɨ ra nḛ je pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ə Pɨyər ɨlə rɔne əl-e ə nə: «NGa o je kɨ, j-ɨyə̰ nḛ je ləje pətɨ kɔ, mba kadɨ j-un-n goi kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jəju ɨle tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, re dəw madɨ, ɨyə̰ kəy ləne, kɨ ngakone je, kɨ konane je, kɨ kone, kɨ bawne, kɨ ngane je ə se dɔnangɨ ləne kɨ mbata ləm, ə se kɨ mbata Poy Ta kɨ Majɨ nɨngə, ");
INSERT INTO bjvNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","dəwe kɨn a ɨngə kəy je, kɨ ngakone je, kɨ konane je, kɨ kone je, kɨ ngane je, kɨ dɔnangɨ, nja ɓu dɔ tɨ. A ɨngə nḛ je kɨn, naa tɨ kɨ ko̰ dɔkagɨlo tɨ kɨ ɓone, taa dɔkagɨlo tɨ kɨ a re, a ɨngə kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","NGa nɨngə, dɨje ngay kɨ kəte, a təli njé kɨ gogɨ, ə njé kɨ gogɨ, a təli njé kɨ kəte tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jəju əi kɨ njé ndo je ləne əi dɔ rəbɨ tɨ, ɨsɨ awi kɨ Jorijaləm. Jəju njɨyə no̰de tɨ no̰de tɨ. Lo kɨn tɨ, ɓəl ra njé ndo je lie ngay, taa njé njɨyə gode tɨ ka ɓəl rade tɔ. Jəju təl ɓar njé ndo je kɨ dɔgɨ gɨde e joo rɔne tɨ, nɨngə ɨlə ngɨrə kadɨ əl-de nḛ je kɨ a ra-e Jorijaləm tɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Oi, j-ɨsɨ j-awi kɨ Jorijaləm, nɨngə a ɨləi-mi *mi NGon dəw ji njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je tɨ. A gangi ta koy dɔm tɨ, nɨngə go tɨ, a ɨləi-mi ji dɨje tɨ kɨ əi *Jɨpɨ je al. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A kogi dɔm tɨ je, a tɨbi man tade dɔm tɨ je, a tɨndəi-mi kɨ ndəy kabɨlay je, taa a tɔli-mi tɔ. Nə ndɔ kɨ ko̰ mɨtə lə ndɔ koym ɓa, m-a m-tḛḛ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Go ta je tɨ kɨn nɨngə, Jakɨ əi kɨ Ja̰ kɨ əi ngan lə Jəbəde, rəi rɔ Jəju tɨ ɓasi, əli-e əi nə: «NJe ndo, jɨ ndɨgɨ kadɨ ɨra nḛ kɨ j-aw tə dəji kam adɨ-je.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jəju dəjɨ-de ə nə: «Ri ə ɨgəi kadɨ m-ra madɨ səsi ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nɨngə, təli əli-e əi nə: «Re ɨndɨgɨ dɔ tɨ səje ə, adɨ dəw kare ɨsɨ dɔ ji ko̰i tɨ, ə e kɨ nungɨ ɨsɨ dɔ ji gəli tɨ tɔ, lokɨ a ɨsɨ dɔ ko̰ɓe tɨ ə dɨje a ɨləi tɔjɨ dɔi tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jəju əl-de ə nə: «Ɨgəri me nḛ dəjɨ ləsi kɨn al. A asi kadɨ ɨngəi ko̰ kɨ m-aw tə m-ɨngə kam kare mɨndɨ wa? Taa, batəm kɨ to ko̰ ngay kɨ m-aw tə m-ɨngə kam a ɨngəi kare tɔ wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓa əli əi nə: «Oyo, j-a j-asɨ kare.» Ə Jəju əl-de ə nə: «Təkɨ rɔjetɨ, a asi kadɨ ɨngəi ko̰ kɨ m-aw tə m-ɨngə kam kare, taa batəm kɨ to ko̰ ngay kɨ m-aw tə m-ɨngə kam a ɨngəi kare tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nə ta kɨ ɔjɨ dɔ kɨsɨ dɔ ji kom tɨ ə se dɔ ji gəlm tɨ; e ta ləm kadɨ mi ə m-adɨ səsi al. Lo je kɨn to kɨ mba dɨje kɨ rai goe kəte nu kɨ mbata ləde.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lokɨ ndəgɨ njé ndo je kɨ dɔgɨ ooi ta je kɨn ɓa, rɔde ɨlə ngɨrə nəl-de al kɨ Jakɨ əi kɨ Ja̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Be ə, Jəju ɓar-de pətɨ kɨ rɔne tɨ, əl-de ə nə: «Ɨgəri kadɨ njé je kɨ ɨndəi-de tə njé ko̰ɓe dɔ gɨn dɨje tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ tɨ ne, ɨsi tə jɔgɨ dɔ dɨje tɨ, adi-de ko̰, taa dɨje kɨ njé tɔɓa, o̰i ɓe dɔde tɨ ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nə a e be dansi tɨ al. Re dəw madɨ dansi tɨ, ndɨgɨ kadɨ n-e kɨ bo nɨngə, kadɨ təl nje ra kɨlə ləsi pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Taa re dəw madɨ ndɨgɨ kadɨ n-e dəw kɨ dɔ kəte dansi tɨ nɨngə, kadɨ təl ɓəə kɨlə ləsi pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tadɔ mi *NGon dəw m-re mba kadɨ dɨje rai kɨlə adi-mi al, nə kadɨ mi ə m-ra kɨlə m-adɨ-de nɨm, taa m-adɨ rɔm kadɨ m-taa-n kosɨ dɨje ngay m-ɨlə-de taa nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jəju əi kɨ njé ndo je ləne rəi tḛḛi Jəriko tɨ. Lokɨ ɨsɨ tḛḛi me ɓe bo tɨ kɨ taga kɨ kosɨ dɨje ngay gode tɨ, nje kəm tɔ kare kɨ tɔe nə Bartɨme, e ngon lə Tɨme, ɨsɨ ngangɨ rəbɨ tɨ no̰o̰, ɨsɨ kɔy nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lokɨ oo kadɨ e Jəju kɨ Najarətɨ tɨ ə ɨsɨ ɨndə də nɨngə, un ndune kɨ taa no̰ ə nə: «Jəju kɨ *NGon ka Dabɨdɨ, o kəm-to-ndoo ləm!» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dɨje ngay kəngi-e kəngɨ kadɨ utɨ tane, nə nje kəm tɔ un ndune kɨ taa dɔ made tɨ wa ɓəy ə nə: «NGon ka *Dabɨdɨ, o kəm-to-ndoo ləm!» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lo kɨn tɨ, Jəju a lo ka tɨ, ə nə: «Ɨɓari-e adi-mi.» Nɨngə ɓari nje kəm tɔ ka kɨn, ə əli-e əi nə: «Uwə rɔi ba, ḭ taa, nə ɨsɨ ɓari.» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lokɨ oo dɔ ta je kɨn nɨngə, bi kɨbɨ ləne, ɨlə kɔ, ə ḭ taa ratɨ aw rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jəju dəje ə nə: «E ri ə, ɨge kadɨ m-ra madi ə?» Ə nje kəm tɔ əl-e ə nə: «NJe ndo, m-ge kadɨ kəm oo lo!» ");
INSERT INTO bjvNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ə Jəju əl-e ə nə: «Aw! tadɔ kadɨ-me ləi aji.» Par ə, ta naa tɨ no̰o̰, kəme oo lo, adɨ un go Jəju dɔ rəbɨ njɨye tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lokɨ Jəju əi kɨ njé ndo je ləne ɨndəi dɔ ɓe kɨ Jorijaləm ɓasi, gɨdɨ ngan ɓe je tɨ kɨ Bətɨpaje kɨ Bətani, kɨ kaw kadɨ mbal kagɨ bɨni je tɨ, ɨlə njé ndo je ləne joo. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jəju əl-de ə nə: «Awi me ngon ɓe tɨ kɨ a no̰si tɨ kam. Lo kur ə wa kɨ a uri kɨ me ɓe tɨ par ə, a ɨngəi ngon koro kɨ dɔɔi-e adɨ a. E ngon koro kɨ dəw al gɨde tɨ al ɓəy. Ɨtuti-e, ɨrəi sie adi-mi. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A re dəw madɨ dəjɨ səsi ə nə: “MBa ri ə a rai nḛ be,” wa ə, əli-e əi nə: “Ɓaɓe ə ge-e, ə a təl ɨlə sie ɓasɨne ba.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","*NJé ndo je awi nɨngə yə ɨngəi ngon koro kɨ dəw dɔe taga ta kəy tɨ, kadɨ rəbɨ tɨ. Adɨ tuti-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dɨje madɨ kɨ ooi-de lo tutɨ koro tɨ dəji-de əi nə: «E ri ə a ɨrai-e be ə? Ɨtuti ngon koro kɨn mba ri ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nɨngə njé ndo je ɨləi-de tɨ təkɨ Jəju əl-n-de, ɓa ɨyə̰i-de adɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lokɨ rəi kɨ ngon koro ka kɨn nɨngə, labi kɨbɨ je ləde gɨde tɨ, ɓa Jəju al ɨsɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dɨje ngay labi kɨbɨ je ləde go rəbɨ tɨ. NJe kɨ madɨ je, e mbi kam je kɨ wale ə təti tɨləi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","NJé njɨyə no̰ Jəju tɨ kɨ njé njɨyə goe tɨ uni ndude kɨ taa əli əi nə: «Tɔjɨ e kɨ dɔ Luwə tɨ! Nɨngə kadɨ Luwə njangɨ dɔ dəw kɨ re kɨ tɔ Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadɨ Luwə njangɨ dɔ ko̰ɓe kɨ a re, adɨ e ko̰ɓe lə kaje *Dabɨdɨ. Tɔjɨ e kɨ dɔ Luwə tɨ, me dɔra̰ tɨ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jəju ur Jorijaləm tɨ, aw me kəy tɨ lə Luwə. Lokɨ ɨndə kəmne oo nḛ je pətɨ kɨ gə gɨde nɨngə, əi kɨ njé ndo je ləne kɨ dɔgɨ gɨde e joo tḛḛi awi Bətani tɨ, tadɔ lo sɔl ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lokɨ lo ti go tɨ, Jəju əi kɨ njé ndo je tḛḛi Bətani tɨ kɨ taga, nɨngə ɓo ra-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jəju oo kagɨ mbay-kote kɨ mbie to dɔ tɨ, a sa̰y nu, nɨngə ɔtɨ aw gɨn tɨ kadɨ n-oo se n-a n-ɨngə kande dɔ tɨ kadɨ n-uso wa? Nə lokɨ re ɓasi rɔ kagɨ tɨ nɨngə, oo mbie je par, ɓɨ oo kande al, tadɔ e nay kandɨ mbay-kote al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Be ə Jəju əl mbay-kote ə nə: «Kadɨ dəw uso kandi gogɨ al bɨtɨ kɨ no̰ tɨ.» *NJé ndo je lie ooi ndu ta kɨ əl. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lokɨ rəi tḛḛi Jorijaləm, Jəju aw ur natɨ kəy tɨ lə Luwə, nɨngə ɨlə rɔne tuwə njé labɨ nḛ je kɨ njé ndogɨ nḛ je natɨ kəy tɨ lə Luwə kɔ. Jəju sur tabɨlə je lə njé mbəl la je tɨlə, naa tɨ kɨ nḛ kɨsɨ lə njé gatɨ də dum je. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɨyə̰ dəw madɨ adɨ un nḛ də-n me kəy tɨ lə Luwə al. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɨngə ndo-de nḛ ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Kəy ləm a ɨɓari-e kəy kəl ta kɨ Luwə kɨ to kɨ mbata lə gɨn dɨje pətɨ, nə səi, ɨtəli-e lo ɓɔyɔ rɔ tɨ lə njé ɓogɨ je yo.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lokɨ kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé ndo ndu-kun je ooi ta je kɨn nɨngə, sangi rəbɨ kadɨ n-tɔli Jəju, nə ɓəli tadɔ kosɨ je ndɨgi nḛ ndo lie ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lokɨ lo sɔl nɨngə, Jəju əi kɨ njé ndo je tḛḛi me ɓe bo tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lokɨ lo ti kɨ sḭ, Jəju əi kɨ njé ndo je ɨsɨ ɨndəi də nɨngə, njé ndo je ooi kagɨ mbay-kote kɨ tutɨ dɔe tɨ ratata kɨ ngɨre tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Loe tɨ no̰o̰, me Pɨyər ole dɔ nḛ tɨ kɨ ndɔ kɨ ra nḛ, adɨ əl Jəju ə nə: «NJe ndo kɨ bo, o kagɨ kɨ ndɔ kɨ ɨman-e ka tutɨ am.» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nɨngə Jəju təl əl njé ndo je ləne ə nə: «Majɨ kadɨ adi mesi Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Təkɨ rɔjetɨ, adɨ m-əl səsi, re dəw madɨ əl mbal kam ə nə: “Ɔtɨ lo kɨn tɨ rangɨ, aw osɨ me ba tɨ”, kɨ kadɨ-me, kɨ kanjɨ ɓadɨ, ə gər təkɨ ta kɨ n-əl kɨn a ra nḛ ɓa, Luwə a ra ade. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","E be ə, m-əl səsi madɨ ɨgəri təkɨ, nḛ je pətɨ kɨ ɨdəji Luwə me kəl sie ta tɨ, majɨ kadɨ ɨndəi dɔsi tɨ təkɨ ɨngəi kɨ bəlme, nɨngə Luwə a ra adɨ səsi. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lokɨ ḭ taa kadɨ əli ta kɨ Luwə, re ta to dansi tɨ kɨ dəw madɨ ə, majɨ kadɨ ɨyə̰i goe kɔ adi-e, kadɨ Bawsi kɨ ɨsɨ dɔra̰ tɨ, ɨyə̰-n go majal je ləsi kɔ adɨ səsi tɔ.  ");
INSERT INTO bjvNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","MBata, re ɨyə̰i go majal je lə dɨje kɨ rangɨ kɔ al nɨngə, Bawsi kɨ ɨsɨ me dɔra̰ tɨ, a ɨyə̰ go majal je ləsi kɔ al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jəju əi kɨ njé ndo je ləne təli rəi Jorijaləm tɨ ɓəy. Lokɨ Jəju ɨsɨ njɨyə natɨ kəy tɨ lə Luwə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, kɨ ngatɔgɨ je, ");
INSERT INTO bjvNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","rəi dəji-e əi nə: «E kɨ tɔgɨ kɨ ḭ ra ə ɨsɨ ra-n nḛ je kɨn be ə? Ə na̰ tɔ ə adi ndune kadɨ ɨra-n-de wa əl-je adɨ j-o?» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jəju təl əl-de ə nə: «M-a m-dəjɨ səsi ta kare be par. Re ɨləi-mi tɨ nɨngə, m-a m-əl səsi dəw kɨ adɨ-m ndune kadɨ m-ra-n nḛ je kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na̰ ə ɨlə Ja̰ kadɨ ra dɨje batəm ə? E Luwə ə se e dɨje wa əli-mi adɨ m-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nə təli a əli-naa ta dande tɨ əi nə: «Re j-əl-e j-ə nə: “E Luwə ə ɨle” ə, a dəjɨ-je ə nə se ra ban ə j-ade meje al wa? ");
INSERT INTO bjvNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ə j-a j-əl j-ə nə: E dɨje ə ɨləi Ja̰ al tɔ…» Təkɨ rɔjetɨ, ɓəli kosɨ je, tadɔ dɨje pətɨ gəri dɔde tɨ kadɨ Ja̰ e nje kəl ta kɨ ta Luwə tɨ kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Be ə təli əli Jəju əi nə: «Jɨ gər al.» Ə Jəju təl ɨlə-de tɨ ə nə: «Re ɨgəri al ə, mi ka m-a m-əl səsi tɔgɨ kɨ m-ɨsɨ m-ra-n nḛ je kɨn al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Go tɨ Jəju lə rɔne əl-de ta kɨ kujɨ ta ə nə: «Dɨngəm kare ndɔr nju, nɨngə ɨndə sɨngə gugɨ gɨde wukɨ. Ur ɓe kadɨ tə mborəi man nju tɨ, nɨngə ur nḛ tə ta kagɨ be, kadɨ dɨje ɨsi dɔ tɨ ngəmi ndɔr ka kɨn. Ɓa go tɨ, dɔɔi ta naa tɨ kɨ dɨje kɨ njé ra kɨlə nju, kadɨ tə rai kɨle adi-e, ə kagɨ loe tɨ ɓa, a ka̰yḭ-naa nḛe, nɨngə e wa ɔtɨ aw mba. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lokɨ kagɨ lo kɨjə kandɨ nju asɨ nɨngə, ɨlə ɓəə ləne kare kadɨ aw taa kandɨ nḛ ndor ka kɨn, kɨ ya̰ne ji njé ra kɨle tɨ adɨ-ne. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nə lokɨ ɓəə aw nɨngə, njé ra kɨlə je uwəi-e, tɨndəi-e ngay, ə tuwəi-e adɨ təl kɨ jine kare aw. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","NJe ndɔr təl ɨlə ɓəə kɨ rangɨ ɓəy. E ka, tɨndəi dɔe mbukɨ mbukɨ je, taji-e je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Be ka, dɨngəm ka kɨn təl ɨlə ɓəə kɨ rangɨ ɓəy. Ɓəə kɨn uwəi-e tɔli-e, taa njé kɨ goe tɨ ka, tɨndəi-de je, tɔli-de je wa ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lo kɨn tɨ, ngonne kɨ dɨngəm kɨ ndɨge ngay, par ə nay kɨ karne sie. Ə un-e ɨle tə dɔbəy dəw rɔde tɨ, tadɔ əl ə nə: “A ɓəli gɨdɨ ngonm.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nə njé ra kɨlə nju ka kɨn əli-naa dande tɨ əi nə: “Darɔe ə wa kam ə a e nje nḛ nduwə, ə adɨ jɨ tɔli-e, nɨngə ndɔr nju kɨn a e nḛ ləje.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","E be ə, uwəi ngon ka kɨn tɔli-e, ɨləi nɨne gɨdɨ ndɔr tɨ taga. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ə se dɨngəm nje ndɔr kɨn a ra ban wa? A re kadɨ tɔl njé ra kɨlə je kɨn kɔ, ə sangɨ njé kɨ rangɨ ɨndə-de ta ndɔr tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ɨtɨdəi ta kɨn me makɨtɨbɨ tɨ lə Luwə oi al a? “MBal kɨ njé ra kəy je mbati-e, E ə təl mbal kɨ e tɔgɨ kəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","E kɨn e kɨlə ra Ɓaɓe. E nḛ kɔjɨ kɨ ətɨ ɓəl ə to ta kəmje tɨ kɨn.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lo kɨn tɨ, kɨ bo je kɨ dɔ *Jɨpɨ je tɨ, sangi rəbɨ kadɨ n-uwəi Jəju, tadɔ gəri majɨ kadɨ kujɨ ta kɨ Jəju əl kɨn sɔbɨ dɔde, nə ɓəli kosɨ je, adɨ ɨyə̰i-e, ə ɔti awi lo ləde. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kɨ bo kɨ dɔ *Jɨpɨ je tɨ ɨləi *Parɨsɨ je madɨ kɨ dɨje madɨ kɨ me ɓutɨ tɨ lə *Erodɨ tɨ rɔ Jəju tɨ mba kadɨ tə n-ɨyəi kulə n-uwəi-e-n kɨ ta kɨ tae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rəi əli-e əi nə: «NJe ndo, jɨ gər kadɨ ḭ nje kəl ta kɨ rɔjetɨ, taa ɨɓəl kəm dəw al nɨm. Ḭ o nḛ ra kɨ gɨdɨ tɨ taga ne kam al, taa ḭ nje ndo dɨje rəbɨ lə Luwə kɨ goe kɨ rɔjetɨ. Ə əl-je adɨ j-o: e loe tɨ ə se e loe tɨ al kadɨ dəw ɨgə la-mbə nje ko̰ɓe kɨ bo Səjar ə? Kadɨ tə j-ɨgə la-mbə ə se j-ɨgə al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nə Jəju gər kədɨ kəm dɨje ləde adɨ əl-de ə nə: «MBa ri ə ɨyəi kulə kadɨ uwəi-mi ə? Ɨrəi kɨ sɨlə kare adi-mi m-o.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ə rəi kɨ sɨlə kare adi-e, nɨngə dəjɨ-de ə nə: «Dɔ na̰ ə ɨndəi, ə tɔ na̰ tɔ ə ndangi sɨlə tɨ kɨn ə?» Ə ɨləi-e tɨ əi nə: «E nje ko̰ɓe kɨ bo Səjar.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jəju təl əl-de ə nə: «Nḛ lə Səjar ə adi Səjar, nḛ lə Luwə ə adi Luwə tɔ.» Lo kɨn tɨ, ta lə Jəju dum dɔde ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadusɨ je kɨ əi dɨje kɨ ooi kadɨ njé koy je a ḭḭ taa lo koy tɨ al, rəi rɔ Jəju tɨ dəji-e əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«NJe ndo dɨje, *Mojɨ ndangɨ ndu kɨn me makɨtɨbɨ tɨ adɨ-je ə nə: “Re dəw madɨ, ngoko̰e taa dəne, ə ngoko̰e ka kɨn ojɨ ngon kɨ dəne ka kɨn al ɓəy ə oy nɨngə, kadɨ taa dəne nduwə kɨn, ojɨ-n ngan je kadɨ tḛḛi to nje goto tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kɨ ɔjɨ dɔ ta kɨn, ngakonaa je əi sɨri. Kɨ dɔsa̰y taa dəne, ə ojɨ-n ngon kɨ kadɨ tə ɔr toe al ɓəy par ə ɔtɨ oy. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kɨ ko̰ joo re taa dəne nduwə ka kɨn, nɨngə ojɨ sie ngon ɓa ɔr to nje goto ka kɨn al ɓəy ə re oy ka ɓəy. Kɨ ko̰ mɨtə re ə kae tɨ ə wa ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Adɨ ngakonaa je kɨ sɨri kɨn, taai dəne kɨ kare kɨn pətɨ tɨgə, ka dəw kare kɨ dande tɨ kɨ ojɨ sie ngon ɓəy taa kadɨ oy goto. Gode tɨ pətɨ, darɔ dəne wa re oy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ə se ndɔ kɨ njé koy je a ḭḭ taa lo koy tɨ, ə əi je a ḭḭ lo koy tɨ ə, na̰ dande tɨ ə dəne kɨn a e nee ə? Tadɔ əi sɨri pətɨ taai-e nede tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jəju əl-de ə nə: «Səi dɨje kɨ ɨndəmi rəbɨ, nɨngə kadɨ ɨgəri təkɨ ɨndəmi rəbɨ tadɔ ɨgəri makɨtɨbɨ lə Luwə al nɨm, taa ɨgəri tɔgɨ lə Luwə al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Təkɨ rɔjetɨ, ndɔ dɨje a ḭḭ taa lo koy tɨ, dɨngəm je kɨ dəne je a taai-naa al ngata. Pətɨ a toi tə *Malayka je be me dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta kɨ ɔjɨ dɔ kḭ kɨ njé koy je a ḭḭ taa lo koy tɨ, ɨtɨdəi ta kɨ ɔjɨ dɔ por kɨ o̰ me nga̰ tɨ, ə e kɨ kəl tae me makɨtɨbɨ tɨ lə Mojɨ kɨn al a? Luwə əl Mojɨ ta lo kɨn tɨ ə nə: “Mi Luwə lə *Abɨrakam, mi Luwə lə *Isakɨ, kɨ Luwə lə *Jakobɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Luwə e Luwə lə dɨje kɨ njé kɨsɨ kəm ba, ɓɨ e Luwə lə njé koy je al. Ɨndəmi rəbɨ ndəm kɨ dɔ gangɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","NJe ndo ndu-kun kare kɨ oo ndude lo najɨ-naa ta tɨ, lo kɨ oo adɨ Jəju ɨlə ta *Sadusɨ je tɨ majɨ ngay, ɔtɨ aw rɔ Jəju tɨ dəje ə nə: «Dan ndu-kun je tɨ pətɨ kɨn, e kɨ ra ə e kɨ dɔsa̰y dan tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jəju əl-e ə nə: «NDu-kun kɨ dɔsa̰y kɨ ɨtə ndu-kun je pətɨ ə to kɨn: “O *Isɨrayəl! Ɓaɓe Luwə ləje e Ɓaɓe kɨ e karne ba. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A ɨndɨgɨ Ɓaɓe Luwə ləi kɨ nga̰mei ba pətɨ, kɨ ndɨli ba pətɨ, kɨ mər ta ləi ba pətɨ, taa kɨ tɔgi ba pətɨ tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nɨngə ndu-kun kɨ ko̰ joo ə to kɨn: “A ɨndɨgɨ dəw madi tə darɔi ḭ wa be tɔ.” *NDu-kun kɨ rangɨ kɨ ɨtə ndu-kun je kɨ joo kɨn goto.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","NJé ndo ndu-kun je lə Luwə əl Jəju ə nə: «Majɨ ngay NJe ndo! ta kɨ əl e ta kɨ rɔjetɨ: Ɓaɓe Luwə ləje e karne ba par ə e Luwə, Luwə kɨ rangɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nɨngə, kadɨ dəw ndɨge kɨ nga̰mene ba pətɨ, kɨ nḛ gər kɨ dɔne ba pətɨ, kɨ tɔgɨne ba pətɨ, taa kadɨ dəw ndɨgɨ dəw madɨne tə darɔne wa be tɔ. E kɨn e sotɨ ngay ɨtə da je kɨ kɨjə məsɨde kadɨ-kare tɨ, kɨlə por dɔ tɨ tə kadɨ-kare, kɨ kɨjə məsɨ kadɨ-kare je kɨ dangɨ dangɨ kɨ kadɨ Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lokɨ Jəju oo kadɨ nje ndo ndu-kun kɨn ɨlə ta tɨ kɨ kəm-kədɨ, nɨngə əl-e ə nə: «Ḭ sa̰y al kɨ ko̰ɓe lə Luwə.» Go ta je tɨ kɨn, dəw ka sangɨ kadɨ n-dəjɨ ta Jəju al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lokɨ Jəju ɨsɨ ndo dɨje nḛ gɨn kəy tɨ lə Luwə, dəjɨ-de ta ə nə: «Ra ban be ə njé ndo ndu-kun je əli par əi nə Kɨrɨsɨ kɨ e *Dəw kɨ Luwə mbəte e ngon ka *Dabɨdɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabɨdɨ ə wa kɨ dɔne, lokɨ NDɨl Luwə ra kɨlə mee tɨ, əl ə nə: “Ɓaɓe Luwə əl Ɓaɓe ləm ə nə: ‹Ɨre ɨsɨ dɔ ji ko̰m tɨ ne, Bɨtɨ kadɨ m-ɨlə njé ba̰ je ləi gɨn tɔgi tɨ›.” ");
INSERT INTO bjvNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Dabɨdɨ ə wa kɨ dɔne ɓar-e Ɓane, nga kɨ go rəbɨ kɨ ban taa Kɨrɨsɨ e-n ngon ka Dabɨdɨ ə?» Kosɨ dɨje ngay ooi ta lə Jəju kɨ rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Me nḛ ndo tɨ lə Jəju kɨ ɨsɨ ndo kosɨ je, əl-de ə nə: «Ɨndəi kəm-kədɨ dɔ rɔsi tɨ kɨ rɔ njé ndo ndu-kun je tɨ. Əi dɨje kɨ gei njɨyə kɨ kɨbɨ ngal, taa gei kadɨ dɨje rai-de lapɨya kɨ ɓukɨ-naa tɨ lo kɨngə-naa je tɨ lə kosɨ je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Gɨn kəy kaw-naa je tɨ, ə se lo nḛ kuso tɨ, a gei lo kɨsɨ dɨje kɨ bo, kəte no̰ dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taai nḛ majɨ je lə nje ngaw koy je pətɨ pətɨ jide tɨ, nɨngə ədi kəm dɨje kɨ kəl ta kɨ Luwə kɨ gɨne gangɨ al, kadɨ dɨje ooi-de təkɨ n-əi dɨje kɨ majɨ. Go kɨlə ra je tɨ kɨ be kɨn, Luwə a gangɨ-n ta kɨ nga̰ ngay dɔde tɨ ɨtə ndəgɨ dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jəju ɨsɨ sɔbɨ no̰ lo kɨlə kadɨ-kare, ɨsɨ ɨsɨ oo kɨlə kɨ dɨje ɨsɨ ləi kadɨ-kare. NJé nḛ kɨngə je ngay adi la ngay ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nɨngə nje ngaw koy kɨ nje ndoo kare re kɨ ngan sɨlə joo, tə nḛ kɨ tḛḛ nḛ al ɨlə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Adɨ Jəju ɓar njé ndo je ləne əl-de ə nə: «M-əl səsi təkɨ rɔjetɨ, nje ngaw koy kɨ nje ndoo kam ɨlə kadɨ-kare ɨtə ndəgɨ dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tadɔ ndəgɨ dɨje adi burɨm la je ləde, nə nje ngaw koy kɨn adɨ nḛ kɨngə kɨ me kəy tɨ ləne ba pu. E ɓay nḛ kɨ nay jie tɨ kadɨ ra-n kɨ rɔne ə un adɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lokɨ Jəju ɨsɨ tḛḛ me kəy tɨ lə Luwə ɨsɨ aw nɨngə, nje ndo lie kare əl-e ə nə: «NJe ndo dɨje, oo mbal je kɨ rai kəy, kɨ kəy je kɨ boy boy kɨ əti ɓəl kɨ dum kam!» ");
INSERT INTO bjvNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jəju təl əl-e ə nə: «O kəy je kɨ boy boy kam majɨ, mbal kare kɨ a nay kadɨ ɨsɨ dɔ made tɨ goto; a budi-de nangɨ mur mur.» ");
INSERT INTO bjvNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Go tɨ, lokɨ Jəju aw ɨsɨ dɔ mbal kagɨ bɨni je tɨ, sɔbɨ dɔ kəy lə Luwə. Pɨyər nɨm, Jakɨ nɨm, Ja̰ nɨm, Andɨre nɨm, dəji-e ta lokɨ əi sie kɨ karde əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Əl-je adɨ j-o, dɔkagɨlo kɨ ra tɨ ə nḛ je kɨn a rai nḛ ə? Ə nḛ kɔjɨ kɨ ban ə a tɔjɨ kadɨ jɨ gər təkɨ nḛ je kɨn pətɨ a ɨndəi ngangɨde ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lo kɨn tɨ Jəju lə rɔne əl-de ə nə: «Ɨndəi kəm-kədɨ dɔ rɔsi tɨ, adi dəw ədɨ səsi al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dɨje ngay a rəi kɨ tɔm, a əli əi nə: “Mi ə mi Kɨrɨsɨ”, nɨngə a ɓuki dɨje ngay wale tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lokɨ a oi ka̰ rɔ je kɨ e səsi ɓasi, kɨ poy rɔ je kɨ e sa̰y, adi ɓəl ra səsi al. Re e ri ri ka nḛ je kɨn a rəi, nə e dɔbəy ndɔ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gɨn ɓe madɨ a aw rɔ dɔ gɨn ɓe madɨne, ko̰ɓe madɨ a aw rɔ dɔ ko̰ɓe madɨne tɨ; dɔnangɨ a yəkɨ je, ɓo a o̰ je kɨ lo je kɨ dangɨ dangɨ, nə nḛ je kɨn a toi tə lo kɨlə ngɨrə to ndoo kɨ a ra dəne kɨn be ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nɨngə kɨ ɔjɨ dɔsi səi je wa, majɨ kadɨ ɨsi dɔ njasi tɨ majɨ, tadɔ dɨje a awi səsi lo gangɨ ta je tɨ, a tɨndəi səsi gɨn kəy kaw-naa je tɨ. A awi səsi kadɨ ai no̰ njé ko̰ɓe je tɨ, kɨ no̰ ngar je tɨ kɨ boy kɨ mbata ləm. Lo kɨn tɨ a e ta rəbɨ kɨ kadɨ a ɨngəəi najɨ kɨ ma kɨ dɔm tɨ rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","NGata nɨngə, nḛ kɨ dɔsa̰y, sɔbɨ kadɨ Poy Ta kɨ Majɨ osɨ mbi dɨje tɨ kɨ dɔnangɨ tɨ ne pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lokɨ a uwəi səsi kadɨ a awi səsi lo gangɨ ta tɨ, onosi kadɨ mesi ɓəl, kə nə se ta ri ə a əli no̰ njé gangɨ ta je tɨ wa? Ta wa kɨ Luwə a ɨndə tasi tɨ loe tɨ no̰o̰ kɨn ə əli-de par. Tadɔ e səi je wa ə a əli ta al, nə e NDɨl Luwə ə a ɨndə tasi tɨ kadɨ əli. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","NGakonaa je a uni dɔ-naa awii lo tɔl-naa tɨ, baw ngon a aw kɨ ngon kadɨ tɔli-e kɔ, nɨngə ngan je, mede a majal kɨ njé kojɨ-de je, ə a uni dɔde awi kadɨ tɔli-de tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dɨje pətɨ mede a majal səsi kɨ mbata ləm, nə dəw kɨ uwə tɔgɨne ba bɨtɨ dɔbəy tɨ a ɨngə kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nɨngə lokɨ a oi dəw kɨ nje ra nḛ kɨ kɔbɨ, kɨ nje tujɨ lo, kɨ a uwə lo kɨsɨ lo tɨ kɨ e lo kɨ sɔbɨ kadɨ e tɨ al. Majɨ kadɨ dəw kɨ nje tɨdə nḛ je kɨn gər gɨne majɨ. Nɨngə njé kɨ ɨsi Jude tɨ a a̰yḭ-naa kɨ dɔ mbal je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dəw kɨ ɨsɨ dɔ kəy tɨ a ur nangɨ ɓa a aw me kəy tɨ kadɨ tə un nḛ madɨ tḛḛ-n al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Dəw kɨ a e me ndɔr tɨ, a asɨ kadɨ təl re ɓe un kɨbɨ rɔne al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","NDɔe tɨ no̰o̰ kɨn, kəm-to-ndoo kɨ ga̰e goto a e lə dəne je kɨ njé səm, kɨ njé kadɨ mba ngan je. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Əli ta kɨ Luwə kadɨ nḛ kɨn ra nḛ ɓara al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kɨ rɔjetɨ, a e dɔkagɨlo ko̰ kɨ dəw oo ndɔ kare al ɓəy. Lo kɨlə ngɨrə dɔra̰ kɨ dɔnangɨ tɨ, kɨ Luwə ɨndə-n nḛ je nu, bɨtɨ ɓone, dəw oo ko ko̰ kɨn nja kare al, taa dəw a oo ko ko̰ kɨn gogɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Re Ɓaɓe uwə ta ndɔ je kɨn gangɨ al ə, dəw kare kɨ a ɨsɨ kɨ dɔne taa goto. Nə kɨ mbata lə dɨje kɨ e wa mbətɨ-de, tə dɨje ləne kɨn ə, uwə-n ta ndɔ je kɨn gangɨ ");
INSERT INTO bjvNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","NGa nɨngə, re dəw əl səsi ə nə: “Kɨrɨsɨ, kɨ e *Dəw kɨ Luwə mbəte ə aw yo am, e ə aw ne am” ə, adi-e mesi al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","MBata kɨrɨsɨ je kɨ ngom, kɨ njé kəl kə nə n-əi njé kəl ta je kɨ ta Luwə tɨ, a rəi no̰o̰ tə rai nḛ kɔjɨ kɨ nḛ je kɨ ətɨ ɓəl ɓəl kɨ dum kəl tae. A rai kadɨ tə re to ban ə njé wa kɨ Luwə mbətɨ-de kɨn ka n-ɓuki-de wale. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","E be ə, kadɨ, səi ɨsi dɔ njasi tɨ, m-əl səsi nḛ je kɨn pətɨ kadɨ ɨgəri. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Nɨngə, dɔkagɨloe tɨ ka kɨn, go ko̰ je tɨ kɨn ɓa, kadɨ a tḛḛ kəmne al, nay a nda al, ");
INSERT INTO bjvNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mee je a ḭḭ kɨ dɔra̰ tɨ tosi kɨ nangɨ, nɨngə tɔgɨ je kɨ me dɔra̰ tɨ a yəki. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lo kɨn tɨ ə yə a oi-mi *NGon dəw m-a m-re me kɨl ndi tɨ. M-a m-re kɨ tɔgɨ, me kunjɨ tɨ kɨ ətɨ ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","M-a m-ɨlə malayka je ləm kadɨ tə dɔ kum dɔnangɨ tɨ kɨ sɔ, a kawi njé kɨ mbəti-de kɨ naa tɨ. A kawi-de ḭḭ ngangɨ dɔnangɨ tɨ kɨ kare tḛḛi e kɨ nungɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Majɨ kadɨ ɨgəri nḛ ndo kɨ dɔ kagɨ mbay-kote tɨ kɨn majɨ. Lokɨ bajie je ɨndəi rungɨru, ə mbie ɨtɨ kɨn nɨngə, ɨgəri kadɨ nay ɓa e ɓasi ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Be tɔ ə, lokɨ oi nḛ je kɨn rai nḛ nɨngə, majɨ kadɨ ɨgəri təkɨ mi *NGon dəw mi ta kəy tɨ, ɓasi rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi, dɨje kɨ ɨsi kɨ dɔde taa ne kɨn a oyi tɨgə al ɓəy ə nḛ je kɨn a rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dɔra̰ kɨ dɔnangɨ a gotoi ndɔ madɨ, nə ta ləm a to lo tone tɨ ba ratata kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Dəw kare kɨ gər ndɔ ə se dɔ kadɨ kɨ nḛ je kɨn a rai nḛ tɨ goto. *Malayka je kɨ dɔra̰ tɨ al nɨm, mi NGon lə Luwə ə wa al nɨm. Dəw ɓa, e Bawje Luwə ba par ə gər. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Majɨ kadɨ oi go rɔsi, ɨsi dɔgɨ tɨ, tadɔ ɨgəri dɔ kade kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A to tə ta lə dɨngəm kare kɨ ɨyə̰ me kəy ləne ə aw mba kɨn be. Kəte ɓəy taa kadɨ aw, ɨyə̰ kɨlə je kɨ me kəy tɨ ji njé kɨlə je tɨ ləne. Adɨ na̰ na̰ kɨlə kɨ sɔbɨ dɔe kadɨ ra, nɨngə ndəjɨ nje ngəm ta kəy kadɨ ɨsi dɔgɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ə majɨ kadɨ ɨsi dɔgɨ tɨ, tadɔ ɨgəri ndɔ kɨ ɓa nje kəy a re-n al. A re lo sɔlɔ, ə se dan lo tɨ, ə se ndu no̰ kɨnjə tɨ, ə se kɨ sḭ, ɨgəri al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Re tḛḛ patɨ nɨngə, kadɨ ɨngə səi dɔ ɓi tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta kɨ m-əl səsi kɨn, e dɨje pətɨ ə m-əl-de. Ɨsi dɔ njasi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nay ndɔ joo kəte kadɨ ndɔ ra nay Pakɨ, kɨ nay mapa kɨ əm ɔde al asɨ. NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, sangi rəbɨ kadɨ n-uwəi Jəju gɨdɨ ngə̰y n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be ə, əli-naa əi nə: «Adɨ j-uwəi-e ndɔ ra nay tɨ al nə dɨje a ḭḭ tə rai wongɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jəju e me ɓe tɨ kɨ Bətani, me kəy tɨ lə Sɨmo̰ kɨ kəte e nje banjɨ. Lokɨ Jəju ɨsɨ uso nḛ, dəne madɨ re kɨ ku mbal kɨ ɓari-e albatɨr kɨ yɨbɨ kɨ ətɨ majɨ rosɨ. Yɨbɨ kɨn gate e ngay, rai kɨ man kagɨ kɨ ɓari-e nar. Dəne tɔ ku, nɨngə ur yɨbɨ ka kɨn dɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dɨje madɨ dan njé kɨ əi loe tɨ no̰o̰, rɔde nəl-de al adɨ əli-naa dande tɨ əi nə: «Kəm tujɨ yɨbɨ kɨn kɔ be par kɨn nə ri ə? ");
INSERT INTO bjvNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Asɨ kadɨ dəw taa-n la kɨ al dɔ kɨlə tɨ kɨ ndɔ ɓu mɨtə be ka e kɨ ra-n kɨ njé ndoo je!» To rɔde adɨ əli ta dəne ka kɨn ngay. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nə Jəju əl-de ə nə: «Ɨyə̰i dəne kɨn jəke. MBari ə ɨsɨ njɨbəi-e ə? Nḛ kɨ ra dɔm tɨ kɨn e kɨlə kɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","NJé ndoo je kam, ɨsi səsi ne kɨ ndɔ je pətɨ, adɨ ndɔ kɨ mesi ndɨgɨ par ə a rai səde, nə mi, m-a m-ɨsɨ səsi kɨ no̰ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dəne kɨn ra nḛ kɨ asɨ go tɔgɨne: Ɔy yɨbɨ rɔm tɨ kəte kadɨ tə darɔm aw-n ɓada. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nɨngə adɨ m-əl səsi ta kɨ rɔjetɨ: lo je pətɨ dɔnangɨ tɨ ne, kɨ dɨje a ɨləi mbḛ Poy Ta kɨ Majɨ tɨtɨ, a ɔri poy nḛ kɨ dəne ra kɨn kadɨ mede ole-n dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judasɨ Isɨkarɨyotɨ kɨ e kɨ kare mbo̰ njé ndo je tɨ lə Jəju kɨ dɔgɨ gɨde joo, aw ɨndə dɔ ta naa tɨ kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, mba kadɨ ɨlə-n Jəju jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lokɨ kɨ bo je ooi ta kɨ ta Judasɨ tɨ, rɔde nəl-de ngay adɨ uni mɨndɨde kadɨ n-adi-e la. Loe tɨ no̰o̰, Judasɨ ɨlə ngɨrə sangɨ kadɨ n-oo se n-a n-ra ban ə n-a n-ɨngə dɔkagɨlo kɨ to kadɨ n-ɨlə-n Jəju jide tɨ wa. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","NDɔ kɨ dɔsa̰y lə ra nay kuso mapa kɨ əm ɔde al, kɨ e ndɔ kɨ dɨje ɨsɨ tɔli ngan dəgɨ batɨ je mbata nḛ kuso Pakɨ, njé ndo je lə Jəju dəji-e əi nə: «Lo kɨ ra be ə ɨndɨgɨ kadɨ j-aw jɨ ra nḛ kuso Pakɨ tɨtɨ, j-ɨndə dɔe dana j-adi uso ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɨngə Jəju ɨlə njé ndo je ləne joo, əl-de ə nə: «Awi me ɓe bo tɨ kam ɓa, a ɨngəi dɨngəm kare kɨ otɨ gum man dɔne tɨ nɨngə uni goe. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Me kəy kɨ ur tɨ ə, əli ɓa nje kəy kɨn əi nə: “NJe ndo dɨje ə nə se me kəy kɨ ra ə kadɨ n-re n-uso nḛ Pakɨ tɨ kɨ njé ndo je ləne wa?” ");
INSERT INTO bjvNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A ɔjɨ səsi me kəy kɨ boy. Me kəy kɨn to taa, e kɨ ra oy, kɨ nḛ je kɨ me tɨ pətɨ. Lo kɨn ə a rai nḛ kuso Pakɨ tɨtɨ kadɨ j-usoi. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","*NJé ndo je ḭḭ taai, awi me ɓe bo tɨ ka kɨn nɨngə, ɨngəi nḛ je pətɨ asɨ naa təkɨ wa kɨ Jəju əl-n-de, adɨ rai nḛ kuso Pakɨ, ɨndəi dɔe dana.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lokɨ kadɨ ur, Jəju re kɨ njé ndo je ləne kɨ dɔgɨ gɨde e joo. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nɨngə lokɨ ɨsi ta nḛ kuso tɨ, Jəju əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kare dansi tɨ kɨ ɨsɨ usoi səm nḛ ne kɨn, a ɨlə-m ji dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me njé ndo je ɨlə ngɨrə tɔsɨ-de, adɨ dəji ta Jəju kɨ bare bare əi nə: «E mi ɓe?» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jəju əl-de ə nə: «E dəw kare dansi tɨ səi kɨ dɔgɨ gɨde e joo wa kɨn. E kɨ ɨsɨ ɨlə jine səm naa tɨ me ka tɨ wa kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi *NGon dəw m-a m-oy təkɨ ndangi me makɨtɨbɨ tɨ lə Luwə, nə kəm-to-ndoo e lə dəw kɨ a ɨlə-m mi NGon dəw ji dɨje tɨ. Dəwe kɨn, koje al e sotɨ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lokɨ ɨsi ta nḛ kuso tɨ, Jəju un mapa, ra oyo Luwə dɔ tɨ, uwə tətɨ naa tɨ, təl-n adɨ njé ndo je, nɨngə əl-de ə nə: «Ɨtaai, e kɨn e darɔm.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Go mapa tɨ, Jəju un kɔpɨ kasɨ kandɨ nju, ra oyo Luwə dɔ tɨ, nɨngə təl-n adɨ njé ndo je a̰yḭ-naa pətɨ dande tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","nɨngə əl-de ə nə: «E kɨn e məsɨm, məsɨ kun mɨndɨ kɨ sɨgɨ kɨ a a̰y mbata kosɨ dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi m-a m-a̰y kasɨ kandɨ nju kɨ rangɨ al, bɨtɨ kadɨ m-a m-a̰y kɨ sɨgɨ me ɓeko̰ tɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lokɨ osi pa kɨlə tɔjɨ dɔ Luwə tɨ gɨne gangɨ, tḛḛi awi dɔ mbal kagɨ bɨni je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jəju əl njé ndo je ləne ə nə: «A ɨmbati-mi pətɨ, tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “M-a m-tɔl ɓa batɨ je, nɨngə batɨ je a sanəi-naa kɨ lo lo”. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nə lokɨ m-a m-ḭ lo koy tɨ, m-a m-aw kəte no̰si tɨ, tə ngəm səsi Galile tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pɨyər əl Jəju ə nə: «Re dɨje pətɨ ə ɨyə̰i-ni kɔ ka, nḛ kɨn a ra nḛ rɔm tɨ mi Pɨyər al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jəju təl əl-e ə nə: «Ḭ, təkɨ rɔjetɨ, adɨ m-əli, ɓone, me kondɔ tɨ wa kɨn, kunə kɨnjə no̰ nja joo al ɓəy ə a najɨ ta nja mɨtə ə nə ɨgər-m al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nə Pɨyər a dɔ ndune ə nə: «Re e-n koy ka m-a m-oy səi, ɓɨ m-a najɨ ta gəri, al ratata.» Nɨngə ndəgɨ njé ndo je pətɨ əli ko ta wa kɨ Pɨyər əl ka kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Go tɨ, Jəju əi kɨ njé ndo je ləne ɔti rəi lo tɨ madɨ kɨ tɔe nə Jətɨsəmane. Jəju əl-de ə nə: «Ɨsi lo kɨn tɨ ne be ɨngɨnəi-mi, dɔkagɨlo tɨ kɨ m-a m-əl ta kɨ Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jəju adɨ Pɨyər nɨm, Jakɨ nɨm, Ja̰ nɨm awi sie. Lo kɨn tɨ, dadɨ kɨ ɓəl kɨ me ndɨl tɨ ɨlə ngɨrə ra Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adɨ Jəju əl-de ə nə: «Me-ko̰ rosɨ mem rosɨ kɨ asɨ koy. Ɨsi lo kɨn tɨ ne be, ɨsi kəm ɓɨ ɨtoi ɓi al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jəju ɔtɨ kɨ kəte ndə̰y, nɨngə osɨ kɨ nangɨ, dəjɨ Luwə kadɨ re to ban ə, ɔsɨ dɔ kadɨ ko̰ kɨn ngərəngɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jəju ə nə: «Aba! Bai, nḛ kɨ dum tɔgi goto, ə ɔsɨ ko̰ kɨn ngərəngɨ kɔ rɔm tɨ! Nə ke ə kadɨ e ndɨgɨ ləm al, nə kadɨ e ndɨgɨ ləi yo taa.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jəju təl re rɔ njé ndo je tɨ kɨ mɨtə, nɨngə ɨngə-de, ɨsɨ toi ɓi, adɨ əl Pɨyər ə nə: «Sɨmo̰, ɨsɨ to ɓi wa bɨtɨ a? Asɨ kadɨ ɨsɨ kəm dɔ kadɨ kɨ kare be al bɨtɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɨsi kəm ba, əli ta kɨ Luwə, kadɨ osi me nḛ na tɨ al. NDɨl ndɨgɨ ra nḛ kɨ majɨ, nə darɔ e kɨ to̰.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nɨngə təl ɔr nda̰ne səde kɨ rangɨ ɓəy, əl ta kɨ Luwə, un go mɨndɨne kɨ kəte wa ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lokɨ təl re rɔ njé ndo je tɨ nɨngə, ɨngə-de ɨsɨ toi ɓi ɓəy, kəmde ɔy dɨrɨri, lo ta kɨ kadɨ əli ka gəri al. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jəju təl aw, re kɨ ko̰ mɨtə, əl-de ə nə: «Ɨtoi ta ɓi tɨ ne, ɨsɨ ɔri kə̰ə̰ ɓəy a? Asɨ be nga! Dɔkagɨlo re kadɨ a ɨləi-mi *NGon dəw ji njé ra majal je tɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ḬḬ taai adɨ j-awi, nje kɨlə-m jide tɨ ə re am!» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Loe tɨ no̰o̰, lokɨ ta nay kɨ ta Jəju tɨ ba ɓəy nɨngə, Judasɨ, kɨ e kɨ kare dan njé ndo je tɨ kɨ dɔgɨ gɨde e joo, ə tḛḛ ɨsɨ re. Re kɨ kosɨ dɨje ngay gone tɨ. Dɨje kɨ njé kuwə kɨyə kasɨgar je, njé kuwə gɔl jide tɨ je. Kosɨ je kɨn, e njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, kɨ ngatɔgɨ je, ə ɨləi-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasɨ kɨ nje kun dɔ Jəju, əli-naa səde nḛ kɨ n-a n-ra kadɨ tə gəri Jəju ə nə: «Dəw kɨ m-a m-uwe rɔm tɨ rututu kɨn ɓa, e darɔe ə wa ən ə, uwəi-e, ɨndəi kəmsi goe tɨ awi sie!» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","E be ə, tḛḛ ə wa kɨ Judasɨ re tḛḛ par ə, sɔbɨ Jəju əl-e ə nə: «NJe ndo dɨje!» Nɨngə, uwe rututu kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ɓa loe tɨ no̰o̰ dɨje, kɨ rəi kɨ Judasɨ ka kɨn ɨndəi jide dɔ Jəju tɨ uwəi-e. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lokɨ uwəi-e, kɨ kare dan njé kɨ əi sie naa tɨ, ɔr kɨyə kasɨgar, tɨgə-n paja lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, ɓa tɨgə mbie latɨ gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","NGa nɨngə Jəju un ta əl-de ə nə: «To tə nḛ kɨ mi nje ɓogɨ, ə ɨrəi kɨ kɨyə kasɨgar je, kɨ gɔl je taa kadɨ uwəi-mi be? ");
INSERT INTO bjvNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","NDɔ je pətɨ, mi dansi tɨ gɨn kəy tɨ lə Luwə, m-ndo dɨje nḛ, ka uwəi-mi al, nə e kɨn to be ɓone mba kadɨ ta je kɨ ndangi me makɨtɨbɨ tɨ lə Luwə tɔli tade.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lo kɨn tɨ, njé ndo je lie pətɨ a̰yḭ-naa ə ɨyə̰i-e ");
INSERT INTO bjvNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","NGon kɨ basa kare, kɨ dole rɔne kɨ ta kɨbɨ ə wa par, un go Jəju. Dɨje uwəi ngon kɨ basa ka kɨn, ");
INSERT INTO bjvNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nə, ɨyə̰ ta kɨbɨ kɨ dolə-n rɔne ka kɨn jide tɨ, ə a̰y kɨ rɔne kare aw. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","NJé kuwə Jəju, awi sie no̰ kɨ bo tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je. E lo kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je, kɨ njé ndo ndu-kun je, pətɨ kawi-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pɨyər adɨ nda̰e ngal, ə njɨyə-n go Jəju tɨ, ndə̰y, ndə̰y, re ur-n gode tɨ kəy, natɨ lo tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ka kɨn. Re ɨsɨ naa tɨ kɨ paja je ta por tɨ, ɨsɨ ndɨbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé gangɨ ta je lə *Jɨpɨ je, ba pətɨ, sangi rəbɨ ta madɨ kadɨ n-gangii ta koy dɔ Jəju tɨ, nə ɨngəi al. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dɨje ngay təti ta je kɨ ngom dɔe tɨ, nə ta kɨ tətɨ je ləde aw go-naa tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","NJé kɨ na̰ je ḭḭ ai taa kɨ njade, taa təti ta je kɨ ngom mɨnde tɨ əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«J-o tae tɨ əl ə nə: “M-a m-tujɨ kəy lə Luwə kɨ dɨje rai kɨ jide kam kɔ, nɨngə me ndɔ tɨ kɨ mɨtə, m-a m-təl m-ɨndə e kɨ rangɨ gogɨ. A e kəy kɨ dəw a ra kɨ jine al.”» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dɔ ta tɨ wa kɨn ka, ndu njé tətɨ ta je osɨ go-naa tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ḭ taa dan dɨje tɨ, dəjɨ Jəju ə nə: «Ta kɨ dɨje a əli dɔi tɨ kam, a əl ta madɨ dɔ tɨ al a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nə Jəju a tane mbə, tḛḛ tane ɨlə-de tɨ al. Ə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je dəjɨ Jəju ta kɨ rangɨ ɓəy ə nə: «E ḭ, ə ḭ Kɨrɨsɨ kɨ Luwə mbəte, kɨ e NGon lə Luwə kɨ dɨje ɨsɨ ɨləi tɔjɨ dɔe tɨ kɨn a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ə Jəju əl-e ə nə: «E mi wa, nɨngə a oi-mi *NGon dəw m-ɨsɨ dɔ ji ko̰ Luwə tɨ kɨ nje tɔgɨ, m-a m-ḭ dɔra̰ tɨ m-re me kɨl ndi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je tɨl kɨbɨ je kɨ rɔne tɨ, ɓa əl ə nə: «E kɨn, jɨ sangi kadɨ dəw madɨ kɨ rangɨ əl ta dɔe tɨ ɓəy a? ");
INSERT INTO bjvNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Səi je wa oi ndue kɨ əl-n ta kɨ mal dɔ Luwə tɨ kɨ mbisi ne. Ta ri ə ɨməri dɔe tɨ ə?» Ə dɨje pətɨ gangi ta dɔ Jəju tɨ, kadɨ e dəw kɨ sɔbɨ koy. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","NJé kɨ na̰ je, ɨləi gɨn tɨbɨ man tade dɔe tɨ, ndəmi ta kəme, nɨngə ɓɨri jide ɔsi-e-n, ə əli-e ə nə: «Ɨndo̰ ndɨl, ə ɨɓa tɔ dəw kɨ ɨndəi adɨ j-o.» Loe tɨ no̰o̰, paja je taai Jəju, ɓa agi kɨ ta tɨndə mbɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lokɨ Pɨyər e ta mbalo tɨ, nangɨ ne ɓəy, dəne kare kɨ dan dəne je tɨ kɨ njé ra kɨlə me kəy tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ḭ no̰o̰ re. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ə lokɨ oo Pɨyər ɨsɨ ndɨbɨ por nɨngə, ɨndə manje ba, ɓa əl-e ə nə: «Ḭ ka, ḭ kɨ Jəju kɨ Najarətɨ tɨ tɔ al a?» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nə Pɨyər najɨ ə nə: «Jagɨ m-gər-e al, taa m-gər me ta ləi kɨ ɨge kəl kɨn al tɔ.» Go tɨ Pɨyər ɔtɨ njɨyə ɨsɨ aw kɨ ta ndogɨ tɨ, nɨngə kunə kɨnjə no̰. ");
INSERT INTO bjvNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dəne ka kɨn ɨlə kəmne oo-n Pɨyər, nɨngə təl re dɔ ta tɨ ka kɨn ɓəy, əl dɨje kɨ ai loe tɨ no̰o̰ ə nə: «Dɨngəm kam e kɨ kare dan dɨje tɨ lie tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pɨyər təl najɨ nja kare ɓəy, ə nə n-gər-e al. Nɨngə njaba go tɨ ə, dɨje kɨ ai səde no̰o̰, rəi əli Pɨyər ɓəy əi nə: «Təkɨ rɔjetɨ, ḭ ka, ḭ kɨ kare dan dɨje tɨ lie tɔ, tadɔ ḭ dəw kɨ Galile tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ə lo kɨn tɨ, Pɨyər ɨbɨ rɔne kɨ ta kɨ nga̰ ngay ə nə: «M-ɨbɨ rɔm kadɨ Luwə ra səm nḛ kɨ nga̰, re m-əl ta kɨ ngom. M-gər dɨngəm kɨ a əli ta lie kam al.» ");
INSERT INTO bjvNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ɓa ta naa tɨ no̰o̰, kunə kɨnjə no̰ kɨ ko̰ joo. NGa nɨngə, me Pɨyər ole dɔ ta tɨ kɨ Jəju əl-e ə nə: «Kəte taa kadɨ kunə kɨnjə no̰ nja joo, a najɨ ta nja mɨtə ə nə ɨgər-m al,» ka kɨn, adɨ Pɨyər ɨndə lo tḛḛ taga kɨ ngɔdɨ njane tɨ, no̰ kɨ man kəmne. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɨ sḭ ɓatɨ ba, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, ɨngəi-naa kɨ ngatɔgɨ je, kɨ njé ndo ndu-kun je, kɨ njé gangɨ ta je lə *Jɨpɨ je ba pətɨ, uni ndude, ɓa dɔɔi Jəju, awi sie ɨləi-e ji *Pɨlatɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ə Pɨlatɨ dəjɨ Jəju ə nə: «Ḭ ngar lə Jɨpɨ je a?» Ɓa Jəju ɨle tɨ ə nə: «E ta kɨ tḛḛ tai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je təti ta je ngay dɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ə Pɨlatɨ təl dəjɨ Jəju ta kɨ rangɨ ɓəy ə nə: «A əl ta madɨ al a? O ta je pətɨ kɨ dɨje a ɨndəi dɔi tɨ kam!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nə Jəju tḛḛ tane ɨlə tɨ al, adɨ ndɔjɨ Pɨlatɨ kɨ dum. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dɔ ɓal je pətɨ, lo ra nay Pakɨ tɨ, *Pɨlatɨ ɔr dangay kare ɨle taa, adɨ e dəw kɨ kosɨ je dəji-e kadɨ ɔr-e dangay tɨ adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","NGa nɨngə dɨngəm kare kɨ ɓari-e nə Barabasɨ e dangay tɨ no̰o̰ tɔ. Uwəi-de dangay tɨ əi kɨ madɨne je ɔjɨ-n dɔ tɔl kɨ tɔli dəw, lo wongɨ tɨ kɨ ra-de dɔ njé ko̰ɓe je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kosɨ je awi rɔ Pɨlatɨ tɨ, nɨngə dəji-e kadɨ ra nḛ kɨ ɨsɨ ra kəte kəte ka kɨn adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","NGata ə Pɨlatɨ dəjɨ-de ə nə: «Ɨgəi kadɨ m-ɨyə̰ ngar lə *Jɨpɨ je taa madɨ səsi wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pɨlatɨ dəjɨ ta kɨn be, mbata gər majɨ kadɨ e ni ə ra njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je dɔ Jəju tɨ ə ɨləi-e jine tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nə njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare suləi kosɨ je adɨ dəji Pɨlatɨ kadɨ ɔr Barabasɨ yo adɨ-de ɓɨ Jəju al. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pɨlatɨ dəjɨ-de ɓəy ə nə: «Ɨgei kadɨ m-ra ri kɨ e kɨ ɓari-e ngar lə Jɨpɨ je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓa əi je təli uni ndude kɨ taa əli Pɨlatɨ əi nə: «Ɨɓe kagɨ-dəsɨ tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pɨlatɨ dəjɨ-de ə nə: «E ri kɨ majal ə ra ə?» Nɨngə uni ndude kɨ taa ngay ɓəy, əli əi nə: «Ɨɓe kagɨ-dəsɨ tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E be ə, mba kadɨ rɔ kosɨ je nəl-n-de, Pɨlatɨ ɔr Barabasɨ adɨ-de. Nɨngə go tɨ, adɨ ɨndəi Jəju kɨ ndəy kabɨlay, ə ɨle ji asɨgar je tɨ kadɨ ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asɨgar je ɔri Jəju awi sie dana, lo tɨ kɨ ɓari-e pɨrətuwar, me lo tɨ kɨ boy kɨ *Pɨlatɨ ɨsɨ tɨ wa kɨn no̰o̰, nɨngə ɓari ndəgɨ asɨgar je pətɨ adi-de rəi. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Loe tɨ no̰o̰, ɨləi kɨbɨ kɨ kər pɨr pɨr rɔ Jəju tɨ, ə oji jɔgɨ kon ɨləi dɔe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nɨngə, ɨləi rɔde rai-e lapɨya əi nə: «Lapɨya ngar lə *Jɨpɨ je!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ɨndəi dɔe kɨ gakɨra, tɨbi man tade dɔe tɨ, ə ɔsi məkəsɨde nangɨ, rai tə nḛ kɨ ɨsɨ ɔsi gone be. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lokɨ ɨbəi-e kogii asɨ-de nɨngə, ɔri kɨbɨ kɨ kər pɨr pɨr ka kɨn rɔe tɨ kɔ, ə təli ɨləi kɨbɨ je lie wa rɔe tɨ gogɨ, ɓa tḛḛi sie taga kadɨ awi ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dɨngəm kare kɨ Sɨrən tɨ, tɔe nə Sɨmo̰, e baw Aləgɨjandɨr əi kɨ Rupusɨ, ḭ wale, nɨngə asɨgar je uwəi-e ɨndəi tɔgɨ dɔe tɨ adɨ otɨ kagɨ-dəsɨ lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Awi kɨ Jəju lo madɨ tɨ kare to no̰o̰, ɓari-e nə Golgota, kɨ kɔr me nə: «Lo kɨ to tə ka dɔ dəw be.» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gei kadɨ n-adi-e kasɨ kandɨ nju kɨ bui naa tɨ kɨ nḛ kɨ ɓari-e nə mɨr, kadɨ a̰y, nə Jəju mbatɨ ka̰y. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Go tɨ, asɨgar je ɓəi-e kagɨ-dəsɨ tɨ, ɓa tɨgəi kɨr (mbare) dɔ kɨbɨ tɨ lie, kadɨ n-ooi nḛ kɨ dəw kɨ ra dande tɨ a ɨngə. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","E kɨ kadɨ kɨ jikare, ə ɓəi-e-n kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","NDangi me batɨ, nḛ kɨ ra ə n-ɓəi-e-n kagɨ-dəsɨ tɨ əi nə: «NGar lə *Jɨpɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓəi njé ɓogɨ je joo naa tɨ sie kagɨ-dəsɨ tɨ. Kɨ kare dɔ ji ko̰e tɨ, kɨ nungɨ dɔ ji gəle tɨ tɔ.  ");
INSERT INTO bjvNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Be kadɨ ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: «Tɨdəi-e dan njé ra majal je tɨ» kɨn tɔl-n tane. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dɨje kɨ njé də rəbə, tɨgəi dɔde, nɨngə taji-e, ə əli əi nə: «Ma, ḭ kɨ nje tujɨ kəy lə Luwə, ə təl ra e kɨ rangɨ me ndɔ tɨ kɨ mɨtə ka kam! ");
INSERT INTO bjvNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ajɨ rɔi ḭ wa, ə ḭ taa dɔ kagɨ-dəsɨ tɨ ur nangɨ adɨ j-o!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Be tɔ ə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, ɨbəi Jəju kogii dande tɨ əi nə: «Ajɨ dɨje kɨ rangɨ, nə e wa asɨ kajɨ rɔne al! ");
INSERT INTO bjvNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kɨrɨsɨ, kɨ Luwə mbəte, ngar lə *Isɨrayəl je ka kam, kaje ə wa kɨ j-a ne kɨn, kadɨ ḭ taa dɔ kagɨ-dəsɨ tɨ ur nangɨ adɨ j-o, adɨ tə j-o-n ta lie tə ta kɨ rɔjetɨ!» NJé kɨ ɓəi-de kagɨ-dəsɨ tɨ naa tɨ sie ka kɨn ka taji-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lokɨ kadɨ a jam dɔ ɓe tɨ, lo ndul dɔnangɨ tɨ ba pətɨ, bɨtɨ kadɨ kɨ mɨtə kɨ lo sɔlɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nɨngə kadɨ tɨ kɨ mɨtə, Jəju no̰ kɨ ndune kɨ bo ə nə: «Eloyi, Eloyi, lama sabatani?» Kɔr me nə: «Luwə ləm, Luwə ləm, mbari ə ɨyə̰-m kɔ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dɨje madɨ dan njé tɨ kɨ ai no̰o̰, ooi ndue, nɨngə əli əi nə: «Oi dəw ka a ɓar Eli!» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dəw kare dande tɨ a̰y ngɔdɨ, un nḛ kɨ to hom hom, ɨlə me man kandɨ ndu tɨ kɨ masɨ, nɨngə ɨlə ta gakɨra tɨ adɨ Jəju kadɨ a̰y, ɓa əl ə nə: «Ɨngəmi adɨ j-oi se Eli a re rɨse nangɨ dɔ kagɨ-dəsɨ tɨ wa?» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lo kɨn tɨ no̰o̰ be, Jəju no̰ kɨ ndune kɨ bo, nɨngə kə̰ə̰e tḛḛ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Go tɨ, kɨbɨ gangɨ lo kɨ a me kəy tɨ lə Luwə, tɨl dana joo, ḭ taa nu bɨtɨ re nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kɨ bo lə ɓutɨ asɨgar je kɨ ɓu, kɨ a ta kəm Jəju tɨ, oo-e lo koy tɨ kɨ oy, əl ə nə: «Təkɨ rɔjetɨ, dəw kɨn e NGon lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dəne je madɨ ai no̰o̰ tɔ, ai sa̰y, ɨndəi kəmde a ooi nḛ je kɨ ɨsɨ rai nḛ. Dande tɨ, Mari kɨ Magɨdala e no̰o̰ nɨm, Mari kɨ ko̰ Jakɨ kɨ ɨɓari-e ngon kɨ e ko̰ Jose e no̰o̰ nɨm, taa Salome e no̰o̰ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","E əi je kɨn ə ndoləi go Jəju, ta rai sie me nḛ ge je tɨ lie lokɨ e-n Galile tɨ. Nɨngə, dəne je kɨ rangɨ ngay kɨ rəi sie Jorijaləm tɨ ka əi no̰o̰ ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","NDɔe tɨ kɨn, e ndɔ kɨ dɨje a ɔsi nja nḛ je naa tɨ ɨndəi, adɨ e ndɔ kɨ no̰ ndɔ ta kə̰ə̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Lokɨ lo sɔl, Jɨsəpɨ kɨ Arɨmate tɨ, kɨ e dəw kare kɨ dɨje ɓuki-e tɨ ngay dan njé gangɨ ta je tɨ lə *Jɨpɨ je re. E wa ka ɨsɨ ngɨnə ta ko̰ɓe lə Luwə kɨ kadɨ a re kɨn tɔ. Ɓəl ra-e al, adɨ aw rɔ *Pɨlatɨ tɨ dəje nɨn Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Lokɨ Pɨlatɨ oo kadɨ Jəju oy ɓa, əte ɓəl, adɨ ɨlə go nje kɨsɨ dɔ ɓutɨ asɨgar je kɨ ɓu, ade re, nɨngə dəje ə nə se Jəju oy mari nu wa? ");
INSERT INTO bjvNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lokɨ oo ta kɨ ta nje kɨsɨ dɔ asɨgar je tɨ nɨngə, adɨ ta rəbɨ Jɨsəpɨ kadɨ un nɨn Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jɨsəpɨ ndogɨ ta kɨbɨ, rɨsɨ nɨn Jəju dɔ kagɨ-dəsɨ tɨ re-n nangɨ, dole, ɨle me ɓe nɨn tɨ kɨ uri me mbal tɨ, nɨngə nduguru mbal ɨlə ta tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari kɨ Magɨdala əi kɨ Mari kɨ ko̰ Jose ai, a oi lo kɨ ɨləi Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lokɨ ndɔ taa kə̰ə̰ də, Mari kɨ Magɨdala nɨm, kɨ Mari kɨ ko̰ Jakɨ nɨm, Salome nɨm, ndogi yɨbɨ kagɨ kɨ ətɨ mbi, mba kaw kɔy rɔ nɨn Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","NDɔ dɨmasɨ, kɨ sḭ ɓatɨ ba, lokɨ kadɨ ɨsɨ bə kɨn, ə yə awi dɔ ɓadɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lokɨ ɨsɨ awi nɨngə, əli-naa dande tɨ əi nə: «NGa kɨn, naa ə tə nduguru mbal ta ɓadɨ tɨ rangɨ adɨ-je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nə lokɨ uni kəmde nɨngə, ooi kadɨ mbal ka kɨn, dəw nduguru-e rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dəne je kɨn uri me ɓe ɓadɨ tɨ nɨngə, oi ngon kɨ basa madɨ kare, ɨlə kɨbɨ ngal kɨ nda rɔne tɨ, ɨsɨ-n kɨ dɔ ji ko̰ tɨ. Lo kɨn tɨ, ɓəl ra dəne je. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nə, ngon kɨ basa ka kɨn əl-de ə nə: «Ɨɓəli al. Ɨsɨ sangi Jəju kɨ Najarətɨ tɨ, kɨ dɨje ɓəi-e kagɨ-dəsɨ tɨ, nə e goto ne, ḭ taa lo koy tɨ. Oi lo kɨ ɨləi-e tɨ ə to kare kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nɨngə kɨ ɓasɨne kɨn, awi əli Pɨyər əi kɨ ndəgɨ njé ndo je lə Jəju təkɨ a aw kadɨ ngɨnə səsi Galile tɨ. Lo kɨn ə a oi-e tɨ, təkɨ əl-n səsi kəte.» ");
INSERT INTO bjvNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dəne je tḛḛi, ɔri ngɔdɨ ta ɓadɨ tɨ ɨsɨ awi, dadi par par kɨ ɓəl, gəri rəbɨ rɔde al. Ta ka əli dəw al, mbata ɓəl tɔl-de. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jəju ḭ lo koy tɨ kɨ ndɔ dɨmasɨ, sḭ ɓatɨ ba. Lokɨ ḭ lo koy tɨ, dəw kɨ dɔsa̰y kɨ tɔje rɔne e Mari kɨ Magɨdala, kɨ ndɔ kɨ tuwə ndɨl je kɨ majal sɨri dɔe tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nɨngə, Mari ə e nje kaw kəl njé ndo je lie kɨ ɨsi ta kuwə ndoo tɨ kɨ ta no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nə lokɨ Mari əl-de təkɨ Jəju ḭ lo koy tɨ, adɨ ne wa n-oo-e kɨ kəmne, njé ndo je taai me al. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Go tɨ, Jəju ɔjɨ rɔne kɔjɨ kɨ to-n ta dangɨ njé ndo je joo kɨ əi dɔ rəbɨ tɨ, ɨsɨ awi kɨ ngan ɓe je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lokɨ Jəju ɨngə-de, təli awi ɔri poye ndəge je, nə ndəge je taai mede al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta tɔl tae tɨ, Jəju ɔjɨ rɔne njé ndo je kɨ dɔgɨ gɨde e kare lokɨ ɨsɨ usoi nḛ. Lo kɨn tɨ, Jəju kɔl səde dɔ me nga̰ tɨ, kɨ kəm kutɨ ləde, mbata mbati taai me njé kɨ ooi-e təkɨ ḭ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Go tɨ, əl-de ə nə: «Awi kɨ dɔ ɓe je kɨ dɔnangɨ tɨ ne pətɨ, ɨləi mbḛ Poy Ta kɨ Majɨ mbi dɨje tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dəw kɨ un mene, ə rai-e batəm, nɨngə a ɨngə kajɨ, nə dəw kɨ mbatɨ kun mene, ta kɨ gangɨ a e dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nḛ kɔjɨ je kɨ njé kɨ uni mede adi Luwə a ɔji ə to kɨn: me tɔm tɨ, a tuwəi ndɨl je kɨ majal, a əli ndon ta je kɨ mba. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A uwəi li je kɨ jide, nɨngə re a̰yḭ-naa nḛ kɨ nje tɔl dəw ka, a ra səde nḛ madɨ al. A ɨndəi jide dɔ njé mo̰y je tɨ, adɨ njé mo̰y je ɨngəi rɔ nga.» ");
INSERT INTO bjvNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Go ta je tɨ kɨ Ɓaɓe Jəju əl-de, uni-e awi sie dɔra̰ tɨ, adɨ ɨsɨ dɔ ji ko̰ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Go kawe dɔra̰ tɨ, njé ndo je awi ɨləi mbḛ Poy Ta kɨ Majɨ. Ɓaɓe e səde naa tɨ, adɨ-de tɔgɨ adɨ rai nḛ je kɨ ətɨ ɓəl ɓəl. Nḛ kɔjɨ je kɨn to be, kadɨ tɔjɨ təkɨ ta lə njé ndo je e ta kɨ rɔjetɨ.");
INSERT INTO bjvNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Təwopɨl, dɨje ngay adi rɔde, ndangi nḛ je kɨ rai nḛ danje tɨ ne kɨn kɨ goe goe. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","NDangi təkɨ, njé kɨ ooi nḛ je kɨn kɨ kəmde əli-je. OOi kɨ kəmde lo kɨlə ngɨre tɨ nu, ə təli njé kɨlə mbḛ Poy Ta kɨ Majɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Be ə, mi ka, m-sangɨ gɨn nḛ je pətɨ kɨ rai nḛ kɨn, lo kɨlə ngɨre tɨ nu kɔre kɔre kadɨ m-o. Nɨngə go sange tɨ kɨ m-sangɨ, m-o majɨ ngay kadɨ, m-ndangɨ me makɨtɨbɨ tɨ kɨ goe goe madi ḭ kɨ bo Təwopɨl. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Lo kɨn tɨ, a gər kadɨ nḛ ndo je kɨ ɨngə-de e nḛ ndo kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dɔkagɨlo tɨ kɨ *Erodɨ e-n ngar kɨ Jude tɨ, dɨngəm kare ɨsɨ no̰ tɔe nə Jakari. Jakari e kɨ kare me ɓutɨ tɨ lə nje kɨjə nḛ məsɨ kadɨ-kare kɨ ɓari-e Abɨya. Tɔ nee nə Elijabətɨ. E ngon dəne kɨ gɨn kojɨ tɨ lə *Aro̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jakari əi kɨ Elijabətɨ joo pu əi dɨje kɨ dana ta kəm Luwə tɨ. Təli rɔde majɨ ngay go ndu-kun je tɨ kɨ go rəbɨ je tɨ lə Ɓaɓe pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nə ɨngəi ngon al, tadɔ Elijabətɨ e kujɨ. Nɨngə e dɔkagɨlo kɨ, əi joo pu, ɓugəi ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","NDɔ kare Jakari ɨsɨ ra kɨlə kɨjə məsɨ kadɨ-kare ta kəm Luwə tɨ, tadɔ e ndɔ ra kɨlə lə ɓutɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nɨngə, kɨ go rae tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨr osɨ dɔ Jakari tɨ kadɨ ur me kəy tɨ lə Luwə. Ur kəy kadɨ ɓukɨ ndujɨ kagɨ kɨ ətɨ mbḭ poro. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lokɨ Jakari a ɓukɨ ndujɨ kagɨ kɨ ətɨ mbḭ poro kɨn, kosɨ dɨje ngay ai taga nḛ a əli ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Loe tɨ no̰o̰, malayka lə Ɓaɓe tḛḛ hɔy kɨ rɔ Jakari tɨ, a kɨ dɔ ji ko̰ lo ɓukɨ ndujɨ kagɨ tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lokɨ Jakari oo malayka ka kɨn nɨngə, ndɨle tḛḛ a̰y nay sar, ɓəl tɔl-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nə Malayka əl-e ə nə: «Ɨɓəl al Jakari, tadɔ Luwə oo dɔ ndu ta kɨ əl sie. Nei Elijabətɨ a ojɨ ngon adi, a ɨndə tɔe nə Ja̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A e nḛ rɔnəl ləi kɨ bo ngay, taa dɨje ngay a rai rɔnəl dɔ koje tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tadɔ a e dəw kɨ bo ta kəm Ɓaɓe tɨ. A a̰y kasɨ nju al nɨm, a a̰y ndəgɨ kasɨ je kɨ əm ɔde al nɨm tɔ. Lokɨ to me kone tɨ ɓəy, NDɨl Luwə a rose. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A təl kɨ ngan *Isɨrayəl je ngay re səde rɔ Ɓaɓe Luwə tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A njɨyə ta kəm Ɓaɓe tɨ kɨ NDɨl nɨm, kɨ tɔgɨ lə nje kəl ta kɨ ta Luwə tɨ, Eli nɨm tɔ. A njɨyə kɨ NDɨl nɨm kɨ tɔgɨ nɨm mba kadɨ ɨlə nojɨ ngan je kɨ bawde je naa tɨ. Taa kadɨ njé dɔ nga̰ je təli njé kaw kɨ hal lə dɨje kɨ dana, mba kadɨ dɨje ɨndəi dɔ rɔde dana mbata lə Ɓaɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari dəjɨ malayka ə nə: «Kɨ go rəbɨ kɨ ban ə m-a m-gər-n kadɨ e ta kɨ rɔjetɨ ə? Tadɔ mi kɨ dɔm m-ɓɨgə, taa nem ka ɓale al dɔ lo tɔ ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɓa malayka təl əl-e ə nə: «Mi Gabɨrɨyəl, kɨ nje ra kɨlə ta kəm Luwə tɨ. Luwə ɨlə-m kadɨ m-əli ta, m-ɨlə Poy Ta kɨ Majɨ kɨn mbi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","O majɨ, a təl mbɨki, adɨ a asɨ kəl ta madɨ al, bɨtɨ kadɨ ndɔ kɨ nḛ je kɨ m-əli tae kɨn rai nḛ ɓəy taa. A e be, tadɔ adɨ mei dɔ ta je tɨ kɨ m-əli kɨn al. Nḛ je kɨn a rai nḛ dɔkagɨloe tɨ kɨ Luwə ɔjɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Me lo kɨn tɨ, kosɨ je toi ta ngəm ta Jakari tɨ, ta ndɔjɨ-de, tadɔ Jakari un dɔkagɨlo ngay me kəy tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lokɨ ɨndə lo tḛḛ kɨ taga kɨ rɔ kosɨ je tɨ nɨngə, asɨ kadɨ əl-de ta al. Lokɨ əl-de ta al, gəri kadɨ oo nḛ me ndɨl tɨ me kəy tɨ lə Luwə. Jakari əl-de ta kɨ jine par, ə ɨsɨ kɨ mbɨki tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lokɨ tɔl ta kɨlə nɨngə, təl aw me kəy tɨ ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ɓa ngay al go tɨ, nee Elijabətɨ ḭ səm. Elijabətɨ ɓɔyɔ rɔne kəy, adɨ dəw oo-e al, asɨ nay mi, ə əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Oi majɨ kɨ Ɓaɓe ra səm kɨn. Ɓaɓe ɨndə kəmne gom tɨ, ɔr rɔsɔl dɔm tɨ dan dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Me nay tɨ kɨ ko̰ mehḛ, Luwə ɨlə malayka Gabɨrɨyəl me ɓe bo tɨ kɨ tɔe nə Najarətɨ, dɔnangɨ tɨ kɨ Galile. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ɨle rɔ ngon mandɨ tɨ madɨ kɨ gər ngaw al ɓəy, kɨ dɨngəm kare kɨ tɔe nə Jɨsəpɨ, kɨ gɨn kojɨ tɨ lə *Dabɨdɨ uwə dɔe. Tɔ ngon mandɨ ka kɨn nə Mari. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malayka ur kəy go Mari tɨ əl-e ə nə: «M-uwə jii Mari, ḭ kɨ ɨngə me-majɨ ta kəm Luwə tɨ, Ɓaɓe e naa tɨ səi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta kɨn ətɨ Mari ɓəl, adɨ dəjɨ rɔne ta ə nə se gɨn kuwə ji kɨn e ri wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malayka əl-e ə nə: «Ɨɓəl al Mari, tadɔ ɨngə majɨ ta kəm Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A ḭ səm, a ojɨ ngon kɨ dɨngəm, a ɨndə tɔe nə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A e kɨ bo, a ɓari-e NGon lə nje ke dɔ nḛ je tɨ pətɨ. Nɨngə, Ɓaɓe Luwə a ade kɨmbər ngar lə kae Dabɨdɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A o̰ ɓe dɔ gɨn kojɨ tɨ lə *Jakobɨ bɨtɨ kɨ no̰ tɨ. Nɨngə ko̰ɓe lie a ɨndə ngangɨne al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari əl malayka ə nə: «Go rəbɨ kɨ ban ə nḛ je kɨn a rai nḛ ə? Tadɔ m-gər ngaw al ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malayka əl-e ə nə: «NDɨl Luwə a re dɔi tɨ, Luwə kɨ e dɔ nḛ je tɨ pətɨ a ɓukɨ tɔgɨne dɔi tɨ. E mbata kɨn ə, ngon kɨ a oje ḭ rɔ Luwə tɨ, a ɓari-e NGon Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","O noji Elijabətɨ kɨ ɓɨgə wa kɨn ka ḭ səm tɔ. E kɨ dɨje ɓari-e kujɨ ka ə yə ḭ səm ra nay mehḛ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ḭ səm tadɔ nḛ kɨ dum Luwə goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari ə nə: «Mi ɓəə lə Ɓaɓe, majɨ kadɨ Luwə ra səm təkɨ tḛḛ-n tai tɨ.» Loe tɨ kɨn, malayka ɨyə̰ Mari ə ɔtɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Me ndɔ je tɨ kɨ go tɨ, Mari ḭ taa, aw law law kɨ dɔnangɨ kɨ mbal je əi tɨ, me ɓe tɨ kɨ Jude. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aw ur me kəy tɨ lə Jakari, uwə ji Elijabətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lokɨ Elijabətɨ oo ndu Mari nɨngə, NGon kɨ mee tɨ ɔdɨ rɔne ndur kutɨ kutɨ. Nɨngə NDɨl Luwə rose tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Lo kɨn tɨ, Elijabətɨ un ndune kɨ taa, əl Mari ə nə: «Luwə adɨ majɨ uri dan dəne je tɨ pətɨ. Nɨngə NGon kɨ to mei tɨ ka majɨ ur-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ra ban ə mi kɨn par, Luwə ɓukɨ-m tɨ kədɨ be bɨtɨ, adɨ ko̰ Ɓam re me kəy tɨ ləm ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lokɨ m-o ndui kɨ uwə-n jim, ngon kɨ mem tɨ ɔdɨ rɔne ndur kɨ rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ḭ nje majɨ-kur, tadɔ adɨ mei kadɨ nḛ je kɨ Ɓaɓe əli tae a tɔli tade.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Be ə Mari ə nə: «NGa̰ mem osɨ pa ɨlə tɔjɨ dɔ Ɓaɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","NDɨlm ra rɔnəl dɔ Luwə tɨ kɨ nje kajɨ-m. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tadɔ Luwə təl kəmne oo-n ɓəə ləne kɨ dəne kɨ asɨ nḛ madɨ al. E be ə, kaw kɨ kəte no̰o̰, Dɨje pətɨ a ɓari-mi nje majɨ-kur kɨ dɔ lo je kɨ dangɨ dangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","MBata Luwə kɨ nje tɔgɨ pətɨ, Ra nḛ je kɨ ətɨ ɓəl ɓəl mbata tɨ ləm. Majɨ kadɨ tɔe e kɨ kay njay. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nɨngə, kadɨ me-majɨ lie to kɨ dɔ ɓal je dɔ ɓal je dɔ dɨje tɨ kɨ njé ɓəl NDɨle. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Luwə ɔjɨ tɔgɨne pətɨ kɨ taga, NJé kɨ nga̰mede rosɨ kɨ kɔjɨ rɔ, Luwə tɨndə-de sane-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sur njé tɔgɨ je tɨlə-de dɔ kɨmbər ngar je tɨ ləde, Nɨngə njé dɔ sɔl, un dɔde kɨ taa tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Adɨ nḛ kɨngə rosɨ ji njé ndoo je, Ə tuwə njé nḛ je jide kare adɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔsɨ sɨl *Isɨrayəl kɨ ɓəə kɨlə lie, Adɨ mee ole dɔ me-majɨ tɨ kɨ mbata dɨje lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Me ole dɔ tɨ təkɨ un-n mɨndɨne adɨ kaje je kəte nu. Un adɨ Abɨrakam kɨ gɨn kojɨ lie ba pətɨ kɨ no̰ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari ɨsɨ kɨ Elijabətɨ asɨ nay mɨtə, nɨngə təl aw ɓe. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dɔkagɨlo kojɨ ngon lə Elijabətɨ asɨ, ə ojɨ ngon kɨ dɨngəm. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","NJé gədɨ kəy je lie kɨ noje je ooi poy majɨ kɨ Luwə ra sie adɨ rai sie rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lokɨ ndɔ kɨ ko̰ jijoo go kojɨ ngon tɨ asɨ nɨngə, rəi kadɨ ɨjəi mɔte. Dɨje ndɨgi kadɨ n-ɓari-e kɨ tɔ bawe kɨ Jakari. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nə ko̰e əl-de ə nə: «Jagɨ, a ɓari-e nə Ja̰.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ə dɨje əli Elijabətɨ əi nə: «Dəw kɨ gɨn kojɨ tɨ ləi kɨ tɔe to be goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lo kɨn tɨ, dəji bawe ta kɨ jide əi nə se ge kadɨ n-ɓari ngon ka kɨn nə na̰ wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakari dəjɨ adɨ rəi kɨ ba ndangɨ nḛ adi-e, nɨngə ndangɨ nḛ tɨ: «Tɔe e Ja̰.» Lo kɨn tɨ, ta ndɔjɨ dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Loe tɨ no̰o̰, ta Jakari tḛḛ, ndone tutɨ adɨ əl ta ɨlə-n tɔjɨ dɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nḛ kɨn ra ɓəl dɨje pətɨ kɨ me ɓe je tɨ kɨ dɔ lo tɨ kɨ no̰o̰, taa go nangɨ mbal je tɨ kɨ Juda pətɨ, dɨje əli tae kɨ lo lo. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dɨje pətɨ kɨ ooi poy ta kɨn ngəmi mede tɨ, ə əli əi nə: «NGon kɨn a təl ri ə?» Təkɨ rɔjetɨ, ji Ɓaɓe e dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","NDɨl rosɨ Jakari kɨ baw ngon, adɨ əl ta kɨ ta Luwə tɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tɔjɨ kɨ dɔ Ɓaɓe tɨ, kɨ Luwə lə *Isɨrayəl, MBata re oo dɨje ləne, taa-de ɨlə-de taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","E ə tḛḛ kɨ NJe kajɨ kɨ NJe tɔgɨ gɨn kojɨ tɨ lə *Dabɨdɨ adɨ-je. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tḛḛ sie təkɨ ɨlə-n mbḛe kɨ ta njé kəl ta je kɨ tae tɨ kɨ ayi njay, dɔkagɨlo tɨ kɨ mari nu. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","NJe kajɨ kɨ a taa-je ji njé ba̰ je tɨ ləje kɨ njé koo kəmje je al pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E be ə, Luwə tɔjɨ-n me-majɨ ləne kɨ rɔ kaje je tɨ, Nɨm taa, me ole dɔ kɨlə mɨndɨ tɨ kɨ ay njay nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kɨlə-mɨndɨ kɨ go mɨnde tɨ kɨ un adɨ ka je *Abɨrakam. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kun mɨndɨ kɨ a ra kadɨ jɨ ra kɨlə ɓəə lie kɨ kanjɨ ɓəl, Lokɨ a taa-je ji njé ba̰ je tɨ ləje. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kadɨ jɨ njɨyə ta kəme tɨ, me kay njay tɨ nɨm, me ka dana tɨ nɨm, Dɔkagɨlo pətɨ kɨ je-n kɨ dɔje taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ḭ ngonm, a ɓari-ni nje kəl ta kɨ ta Luwə tɨ kɨ e dɔ nḛ je tɨ pətɨ, MBata a njɨyə no̰ Ɓaɓe tɨ kadɨ ɨra rəbɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lo kɨn tɨ, dɨje lie a gəri kajɨ kɨ ajɨ-de kɨ go rəbɨ kɨyə̰ go majal je tɨ ləde kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Luwə e nje me-majɨ. Kɨ takul me-majɨ kɨ koo kəm-to-ndoo lie ə, Kunjɨ kɨ dɔra̰ tɨ unjɨ-n dɔje tɨ tə kadɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kunjɨ kɨn unjɨ dɔ dɨje tɨ kɨ ɨsi me tɨl tɨ nɨm, Me ndɨl koy tɨ nɨm, MBa kadɨ ndɔr-je ta rəbɨ, aw səje dɔ rəbɨ kɨsɨ-maje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","NGon ka kɨn tɔgɨ, təl dəw kɨ mbujɨ me ndɨl tɨ. Ra ɓe dɨlə mbo tɨ, bɨtɨ ndɔ kɨ tḛḛ-n taga ta kəm Isɨrayəl tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dɔkagɨloe tɨ kɨn, nje ko̰ɓe kɨ bo Səjar Ogusɨtɨ un ndune kadɨ rai kɔr dɨje kɨ dɔnangɨ tɨ pətɨ me makɨtɨbɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kɨndə tɔ kɨ dɔsa̰y kɨn e dɔkagɨlo tɨ kɨ Kɨrinɨwusɨ e-n nje ko̰ɓe dɔnangɨ tɨ kɨ Sɨri. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dɨje pətɨ awi kadɨ ndangi tɔde, Na̰ na̰ ka aw ɓe kojɨ-ne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E be ə, Jɨsəpɨ ka ḭ ɓe bo Najarətɨ tɨ, dɔnangɨ Galile tɨ, ɨsɨ aw ɓe bo tɨ lə *Dabɨdɨ, kɨ ɓari-e Bətɨləhəm, dɔnangɨ Jude tɨ. MBata Jɨsəpɨ e dəw kɨ gɨn kojɨ tɨ lə Dabɨdɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Awi kadɨ ɨndəi tɔde naa tɨ kɨ Mari kɨ nje nongɨ lie, kɨ a kɨ səm. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lokɨ əi Bətɨləhəm tɨ no̰o̰ ɓəy nɨngə, ndɔ kojɨ ngon lə Mari asɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mari ojɨ ngonne kɨ dɔsa̰y tə ngon kɨ dɨngəm. Ɓɨr ngon ka kɨn kɨ kɨbɨ, ɨle me nḛ ngəm nḛ kuso tɨ lə da je, tadɔ lo kɨ kadɨ adi-de toi tɨ goto me kəy to mba je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","NJé kul da je əi me mu tɨ, dɔ lo tɨ kɨ no̰o̰, ɨndəi ɓi taa ɨsɨ ngəmi da je ləde kondɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nɨngə yə ooi malayka lə Ɓaɓe tḛḛ hɔy kɨ rɔde tɨ. Tɔɓa lə Ɓaɓe unjɨ gugɨ dɔde, adɨ ɓəl tɔl-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nə malayka əl-de ə nə: «Ɨɓəli al, mbata m-re kɨ Poy Ta kɨ Majɨ kadɨ madɨ səsi. Poy Ta kɨ Majɨ kɨn a e nḛ rɔnəl kɨ bo ngay mbata tɨ lə dɨje pətɨ kɨ dɔnangɨ tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","E ɓone ə oji nje kajɨ me ɓe tɨ lə *Dabɨdɨ adi səsi. NJe kajɨ kɨ e Kɨrɨsɨ, Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nɨngə nḛ kɨ a ɨgəri-e-n ə to kɨn: A ɨngəi ngon kɨ kasɨ kɨ ɓɨri-e kɨ kɨbɨ, ə ɨləi-e me nḛ ngəm nḛ kuso tɨ lə da je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta naa tɨ no̰o̰, kosɨ njé rɔ je kɨ dɔra̰ tɨ, tḛḛi, ɨndəi rɔde naa tɨ kɨ malayka kɨ kare ka kɨn, nɨngə osi pa tɔji Luwə əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Tɔɓa e kɨ dɔ Luwə tɨ kɨ nje kɨsɨ dɔra̰ tɨ taa nu. Taa, kɨsɨ majɨ kɨ dɔ dɔnangɨ tɨ, kɨ rɔ dɨje tɨ kɨ Luwə ndɨgɨ-de tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lokɨ malayka je ɨyə̰i-de ə təli awi dɔra̰ tɨ gogɨ, njé ngəm da je əli-naa dande tɨ əi nə: «Adɨ j-awi bɨtɨ kɨ Bətɨləhəm tɨ j-oi nḛ kɨ ra nḛ ə Ɓaɓe tḛḛ kɨ dɔe adɨ-je kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ḬḬ taai kalangɨ awi nɨngə yə, ɨngəi Mari əi kɨ Jɨsəpɨ, naa tɨ kɨ ngon kɨ kasɨ kɨ ɨləi-e me nḛ ngəm nḛ kuso tɨ lə da je. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lokɨ ooi ngon kɨ kasɨ ka kɨn nɨngə, go tɨ ɔri gɨn nḛ je kɨ əli-de ɔjɨ dɔ ngon kɨ kasɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dɨje pətɨ kɨ ooi ta kɨ njé ngəm da je ɔri goe, ətɨ-de ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ngəm nḛ je kɨn pətɨ mene tɨ, mər ta dɔ tɨ kɨ goe goe. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","NJé ngəm da je təli gogɨ kɨ pa, kɨ kɨlə tɔjɨ dɔ Luwə tɨ tade tɨ. MBata Luwə adɨ-de ooi nḛ je kɨ mbide je, kɨ kəmde je. Nɨngə nḛ je ka kɨn rai nḛ kɨ go rəbe ə wa kɨ malayka ɨlə-n-de mbḛe ka kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lokɨ ndɔ kɨ ko̰ jijoo go kojɨ ngon tɨ asɨ, ɨjəi mɔte, nɨngə ɨndəi tɔe nə Jəju. E tɔ kɨ malayka əl-de, lokɨ ko̰e a kɨ səme al ɓəy, kadɨ tə ɓari-e-n. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nɨngə, lokɨ ndɔ kɨ e ndɔ kay rɔ kɨ go ndu-kun tɨ lə *Mojɨ asɨ, Jɨsəpɨ əi kɨ Mari awi kɨ ngon ka kɨn Jorijaləm tɨ kadɨ tɔji-e Ɓaɓe, ");
INSERT INTO bjvNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kɨ go ndange tɨ kɨ ndangi me ndu-kun tɨ lə Ɓaɓe əi nə: «NGan dər je kɨ dɨngəm pətɨ a əi kɨ kɨndə ji dɔde tɨ mbata lə Ɓaɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nɨm taa, rəi kadɨ adi də kərməsɨ je joo ə se ngan də dum je joo kadɨ-kare tɨ, kɨ go ndange tɨ kɨ ndangi me ndu-kun tɨ lə Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dɨngəm kare e Jorijaləm tɨ no̰o̰ tɔe nə Sɨməyo̰. E dəw kɨ dana taa e dəw kɨ nje ra go ndɨgɨ tɨ lə Luwə tɔ. Ɨsɨ ngɨnə ta nje kajɨ *Isɨrayəl mari nu ba. Nɨngə NDɨl Luwə e dɔe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","NDɨl Luwə əl-e kəte ade gər təkɨ n-a n-oy al bɨtɨ kadɨ n-oo Kɨrɨsɨ kɨ Ɓaɓe kɔte kɨ kəme ɓəy taa n-a n-oy. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","NDɨl ɔse kadɨ aw gɨn kəy tɨ lə Luwə, nɨngə təkɨ njé kojɨ Jəju awi sie gɨn kəy tɨ kadɨ rai kɨ go ndu-kun tɨ lə Ɓaɓe, ");
INSERT INTO bjvNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sɨməyo̰ taa Jəju jine tɨ, nɨngə ɨlə tɔjɨ dɔ Luwə ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ɓasɨne, Ɓaɓe, ɨyə̰ ɓəə ləi ade aw maje, kɨ go ta tɨ ləi ngata, ");
INSERT INTO bjvNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","MBata ka kəmm oo nje kajɨ dɨje ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kajɨ kɨ ɨndə dɔe dana ta kəm kosɨ je tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","E kunjɨ kɨ kadɨ unjɨ dɔ gɨn dɨje tɨ pətɨ, taa a e tɔjɨ kɨ dɔ dɨje tɨ ləi, Isɨrayəl tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta kɨ Sɨməyo̰ əl dɔ Jəju tɨ ətɨ ko̰e je kɨ bawe je ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sɨməyo̰ tɔr ndune dɔde tɨ, nɨngə əl Mari ə nə: «Majɨ kadɨ ɨgər majɨ, ngon kɨ oje kɨn a e rəbɨ kosɨ nɨm rəbɨ kḭ taa nɨm lə dɨje ngay dɔnangɨ Isɨrayəl tɨ. Taa, re tə nḛ kɨ nje re kɨ ta kasɨ-naa al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A adɨ gɨr ta kɨ nga̰me dɨje tɨ ngay, gɨne a tḛḛ taga. Nɨngə rɔi ḭ wa tɨ, kɨyə rɔ a gangɨ ndɨli dana tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Dəne kare kɨ nje kəl ta kɨ ta Luwə tɨ ɨsɨ no̰o̰, tɔe nə An. E ngon lə Panuwəl, gɨn kojɨ tɨ lə Ajər. Lokɨ taa dɨngəm mandɨne tɨ, ɨsɨ sie asɨ ɓal sɨri ba par ə ngawe oy. Nɨngə kɨ ɓasɨne kɨn, An tɔgɨ ngay ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɓale e dɔ jijoo gɨde e sɔ. NJe ngaw koy kɨn e me kəy tɨ lə Luwə kɨ dɔkagɨlo je pətɨ. Kondɔ kɨ kada e me kəy tɨ lə Luwə, əl sie ta, ɔgɨ rɔne nḛ kuso. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E be ə, dɔkagɨloe tɨ kɨn, e ka tḛḛ no̰o̰ re tɔ. Osɨ pa ɨlə-n tɔjɨ dɔ Luwə tɨ, taa əl ta kɨ dɔ ngon tɨ kɨn dɨje pətɨ kɨ ɨsɨ ngɨnəi kadɨ Luwə taa Jorijaləm ji njé ba̰ je tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lokɨ njé kojɨ Jəju je rai nḛ je pətɨ kɨ go ndu Ɓaɓe tɨ nɨngə, təli awi Galile me ɓe bo tɨ ləde kɨ Najarətɨ tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nɨngə, ngon ka kɨn tɔgɨ, aw kɨ sɨngəne. Rosɨ kɨ tər, ta me-majɨ lə Luwə e sie naa tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dɔ ɓal je pətɨ, njé kojɨ Jəju awi lo ra nay tɨ kɨ ɓari-e nay pakɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lokɨ Jəju ra ɓal dɔgɨ gɨde e joo nɨngə, awi kɨ njé kojɨ-ne je lo ra nay tɨ təkɨ ɨsɨ rai kəte kəte go kujɨ rae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nɨngə, lokɨ ndɔ ra nay tɨgə ɓa, njé kojɨ Jəju je ɨsɨ təli gogɨ, nə Jəju nay gogɨ Jorijaləm tɨ, kɨ kanjɨ kadɨ njé koje je gəri go. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","NJé kojɨ Jəju je ooi nə Jəju nay nja madɨde je tɨ kɨ uni səde rəbɨ, adɨ njɨyəi ndɔ kare ɓəy taa ɨləi ngɨrə sange dan nojɨde je tɨ kɨ madɨde je. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sangi-e, nə sangi-e pi ɨngəi-e al. Lokɨ ɨngəi-e al, təli tui dɔde awi Jorijaləm tɨ gogɨ sange tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sangi-e bɨtɨ ndɔ kɨ ko̰ mɨtə nɨngə yə, ɨngəi-e, ɨsɨ gɨn kəy tɨ lə Luwə dan njé ndo ndu-kun je. Ɨsɨ dande tɨ, ɨsɨ ur mbine oo-n ta je kɨ ɨsɨ əli tɔ, dəjɨ-n-de ta tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Dɨje pətɨ kɨ ooi ta kəl Jəju kɨn, nḛ gər lie, kɨ ta kɨ tur lie, ətɨ-de ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lokɨ njé koje je ooi-e, ətɨ-de ɓəl ngay, adɨ ko̰e əl-e ə nə: «NGonm, ra ban ə ɨra səje nḛ be ə? O je kɨ bawi, j-a ta sangi tɨ kɨ no̰ kəmje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɨngə əl-de ə nə: «Ɨsangi-mi kɨ mba ri ə? Sɔbɨ kadɨ m-ra kɨlə gɨn kəy tɨ lə Bai kɨn, ɨgəri ə se ɨgəri al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nə njé koje je gəri me ta lie kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nɨngə go tɨ, Jəju təl aw səde Najarətɨ tɨ gogɨ. Jəju təl rɔne go ta tɨ lə njé kojɨ-ne je. Ko̰e ngəm nḛ je pətɨ kɨ rai nḛ kɨn mene tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jəju tɔgɨ darɔne tɨ nɨm, me gosɨ tɨ nɨm tɔ, adɨ ɨngə majɨ ta kəm Luwə tɨ nɨm, ta kəm dɨje tɨ nɨm pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dɔkagɨloe tɨ kɨn, nje ko̰ɓe kɨ bo Səjar, kɨ ɓari-e nə Tɨbər o̰ ɓe ɓal dɔgɨ gɨde e mi. Nɨngə Po̰sɨ *Pɨlatɨ ə e nje ko̰ɓe dɔnangɨ tɨ kɨ Juda, *Erodɨ e ngar dɔnangɨ tɨ kɨ Galile, Pɨlɨpɨ kɨ ngon ko̰ Erodɨ e ngar dɔnangɨ tɨ kɨ Iture kɨ dɔnangɨ kɨ Tɨrakonitɨdɨ, nɨngə Lɨsanɨyasɨ e ngar dɔnangɨ tɨ kɨ Abɨlən tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","An əi kɨ Kayɨpɨ ə əi njé kɨjə nḛ məsɨ kadɨ-kare je kɨ bo kɨ dɔkagɨloe tɨ no̰o̰. Nɨngə, dɔkagɨloe tɨ no̰o̰ kɨn, Ja̰ kɨ ngon lə Jakari e dɨlə lo tɨ ə Luwə əl-e ta. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja̰ aw dɔnangɨ Jurdḛ tɨ pətɨ, ɨlə mbḛ ə nə: «Ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, adɨ rai səsi batəm, mba kadɨ Luwə ɨyə̰-n go majal je ləsi kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ra təkɨ ndangi me makɨtɨbɨ tɨ lə nje kəl ta kɨ ta Luwə tɨ, Ejay, əi nə: «NDu dəw madɨ ɓa dɨlə lo tɨ ə nə: Ɨrai go rəbɨ lə Ɓaɓe! Ɨrai go rəbɨ lie adɨ a njururu. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Uti bole ɓe je adɨ asɨ naa, Ɨkəsi dɔ mbal je kɨ dɔ gadi je adɨ asi ta nangɨ bərəre; Ɨrai rəbɨ je kɨ rugɨ gɔndi gɔndi adɨ a njururu; Ɨrai rəbɨ kɔkɨrɔ je adɨ osɨ naa tɨ lay. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lo kɨn tɨ, dɨje pətɨ a gəri kajɨ kɨ Luwə ajɨ-je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kosɨ dɨje kɨ rəi kadɨ Ja̰ rade batəm, Ja̰ əl-de ə nə: «Səi njé man majal tə li je be kam, na̰ ə əl səsi kadɨ a̰yḭ-naa wongɨ lə Luwə kɨ a re ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Majɨ kadɨ kɨlə rasi tɔjɨ kadɨ səi dɨje kɨ ɨyə̰i pa njɨyəsi je kɨ majal kɔ. Nɨngə oti kadɨ əli mesi tɨ əi nə: “Je ngan ka *Abɨrakam.” MBata, Luwə asɨ kadɨ a təl gajɨ mbal je kam ngan ka Abɨrakam tɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kɨ ɓasɨne kɨn, kɨngə e ɓasi kadɨ tɨgə ngɨrə kagɨ je gangɨ ngata. Kagɨ kɨ ra kɨ andɨ majɨ al ə, a tɨgəi-e kadɨ ɨləi-e me por tɨ kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kosɨ dɨje dəji Ja̰ əi nə: «E ri ə kadɨ jɨ ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ə Ja̰ əl-de ə nə: «Dəw kɨ aw kɨ kɨbɨ joo ə, majɨ kadɨ adɨ kare dəw kɨ aw-n al, nɨngə dəw kɨ aw kɨ nḛ kuso ə, majɨ kadɨ ra-n kɨ e kɨ aw-n al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*NJé taa la-mbə je ka, rəi kadɨ Ja̰ rade batəm tɔ. Nɨngə dəji Ja̰ əi nə: «NJe ndo, e ri ə kadɨ jɨ ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ɓa Ja̰ əl-de ə nə: «Ɨtaai la al dɔ e kɨ dəji səsi kadɨ ɨtaai kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asɨgar je ka dəji əi nə: «NGa je, e ri ə kadɨ jɨ ra ə?» Ja̰ əl-de ə nə: «Ɨndəi tɔgɨ dɔ dəw tɨ ɨtaai la lie al, taa, ɨtəti ta ngom ɨndəi dɔe tɨ al tɔ. Ai dɔ la nay tɨ ləsi wa kɨn par.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dɔkagɨloe tɨ kɨn, dɨje ɨsɨ ngɨnəi dəw kɨ a re, adɨ dəji rɔde ta se Ja̰ e Kɨrɨsɨ kɨ Luwə kote al bɨtɨ wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ə Ja̰ əl dɨje pətɨ ə nə: «Mi, m-ra səsi batəm me man tɨ, nə dəw madɨ a re gom tɨ no̰o̰, a ra səi batəm me NDɨl Luwə, kɨ me por tɨ. E dəw kɨ tɔge ətɨ ɓəl, ɨtə-m sa̰y, kɨlə sa lie ka m-asɨ tutɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Dəw kɨn uwə kee to nḛ jine tɨ kadɨ to-n ka̰ ko kɨ majɨ, ɔy me dam tɨ, ɓa ɨlə tɨse por. E por kɨ a oy al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ja̰ adɨ dɨje ta kɔjɨ je kɨ rangɨ ngay, ɨlə-n-de mbḛ Poy Ta kɨ Majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nḛ kare ɓəy, Ja̰ kɔl kɨ *Erodɨ kɨ e nje ko̰ɓe dɔnangɨ tɨ kɨ Galile, mbata taa kɨ taa Erodɨyadɨ kɨ ne ngokone nɨm, taa ra nḛ je kɨ rangɨ kɨ majal ngay nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nə, nḛ je kɨ go tɨ al pətɨ kɨ Erodɨ ra kɨn ka, təl uwə Ja̰ dangay tɨ dɔ tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lokɨ dɨje pətɨ rai batəm nɨngə, Jəju ka ra batəm tɔ. Ə Lokɨ ɨsɨ əl ta kɨ Luwə ɓa, ta dɔra̰ tḛḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","NDɨl Luwə, rɨsɨ tə də dum be ɨsɨ dɔe tɨ. Nɨngə, ndu ta madɨ tḛḛ dɔra̰ tɨ, ə nə: «Ḭ NGonm kɨ nje ndɨgɨ ləm, kɨ ḭ nḛ rɔnəl ləm kɨ bo ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jəju ɨlə ngɨrə kɨlə ləne, lokɨ ɓale e kutɨ mɨtə. Kɨ go gər-e tɨ kɨ dɨje gəri, Jəju e ngon lə Jɨsəpɨ, Jɨsəpɨ kɨ ngon lə Əli, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Nɨngə Əli e ngon lə Mata, Mata e ngon lə *Ləbi, Ləbi e ngon lə Məlsi, Məlsi e ngon lə Yanay, Yanay e ngon lə Jɨsəpɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jɨsəpɨ e ngon lə Matatɨyasɨ, Matatɨyasɨ e ngon lə Amosɨ, Amosɨ e ngon lə Nawɨm, Nawɨm e ngon lə Əsɨli, Əsɨli e ngon lə Nagay, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay e ngon lə Matɨ, Matɨ e ngon lə Matatɨyasɨ, Matatɨyasɨ e ngon lə Səməyɨn, Səməyɨn e ngon lə Yosəkɨ, Yosəkɨ e ngon lə Yoda, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda e ngon lə Yowana, Yowana e ngon lə Rəsa, Rəsa e ngon lə Jorobabəl, Jorobabəl e ngon lə Salatɨyəl, Salatɨyəl e ngon lə Nəri, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nəri e ngon lə Məlki, Məlki e ngon lə Adi, Adi e ngon lə Kosam, Kosam e ngon lə Elmadam, Elmadam e ngon lə Ər, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ər e ngon lə Jəju, Jəju e ngon lə Eliyəjar, Elɨyəjar e ngon lə Yorɨm, Yorɨm e ngon lə Mata, Mata e ngon lə Ləbi, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ləbi e ngon lə Sɨməyo̰, Sɨməyo̰ e ngon lə Juda, Juda e ngon lə Jɨsəpɨ, Jɨsəpɨ e ngon lə Yonam, Yonam e ngon lə Eliyakɨm, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakɨm e ngon lə Mələya, Mələya e ngon lə Məna, Məna e ngon lə Matata, Matata e ngon lə Nata̰, Nata̰ e ngon lə *Dabɨdɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabɨdɨ e ngon lə Jəse, Jəse e ngon lə Obədɨ, Obədɨ e ngon lə Bowajɨ, Bowajɨ e ngon lə Sala, Sala e ngon lə Naso̰, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naso̰ e ngon lə Amɨnadabɨ, Amɨnadabɨ e ngon lə Adɨmɨn, Adɨmɨn e ngon lə Arni, Arni e ngon lə Əsɨrom, Əsɨrom e ngon lə Pərəsɨ, Pərəsɨ e ngon lə Juda, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda e ngon lə *Jakobɨ, Jakobɨ e ngon lə *Isakɨ, Isakɨ e ngon lə *Abɨrakam, Abɨrakam e ngon lə Təra, Təra e ngon lə Nawor, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nawor e ngon lə Sərugɨ, Sərugɨ e ngon lə Rəwu, Rəwu e ngon lə Peləgɨ, Peləgɨ e ngon lə Ebər, Ebər e ngon lə Səla, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Səla e ngon lə Kaynam, Kaynam e ngon lə Arpasadɨ, Arpasadɨ e ngon lə Səm, Səm e ngon lə Nuwe, Nuwe e ngon lə Ləməkɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ləməkɨ e ngon lə Matusaləm, Matusaləm e ngon lə Ənɔkɨ, Ənɔkɨ e ngon lə Yərədɨ, Yərədɨ e ngon lə Malələl, Malələl e ngon lə Kaynam, ");
INSERT INTO bjvNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam e ngon lə Ənosɨ, Ənosɨ e ngon lə Sətɨ, Sətɨ kɨ ngon lə Adam, Adam kɨ ngon lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Go NDɨl Luwə tɨ kɨ rosɨ Jəju, Jəju təl ta ba Jurdḛ tɨ re. Təl re nɨngə, NDɨl Luwə ɔr no̰e aw sie dɨlə lo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Su na-e ndɔ dɔsɔ dɨlə lo tɨ. NDɔ kɨ Jəju ra dɔsɔ kɨn, uso nḛ madɨ al, adɨ ɓo ra-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","No̰o̰ be, su əl-e ə nə: «Re ḭ NGon lə Luwə ə, adɨ mbal kɨn adɨ təl mapa adɨ m-o.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ə Jəju təl əl-e ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: Dəw a ɨsɨ kɨ dɔne taa kɨ takul nḛ kuso par al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Su aw kɨ Jəju dɔ lo tɨ taa, ɓa kɨ kəm kɨ kɨndə jɨpɨ, ɔje ko̰ɓe je kɨ dɔnangɨ tɨ ne pətɨ ade oo. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lokɨ ɔje nɨngə, təl əl-e ə nə: «M-a m-adi tɔgɨ dɔ ko̰ɓe je tɨ kɨn kɨ nḛ kɨngə je kɨ me tɨ pətɨ. Tadɔ e nḛ kɨ adi-mi me jim tɨ, nɨngə dəw kɨ mem ndɨgɨ ə m-ade. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Re ḭ, ɔsɨ məkəsi nangɨ no̰m tɨ ə, m-a m-adi ba pətɨ tə ya̰i.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jəju təl əl-e ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “A ɔsɨ məkəsi nangɨ no̰ Ɓaɓe Luwə tɨ ləi, nɨngə e kɨ karne ba par ə a re no̰e tɨ kadɨ ɨgose.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Go tɨ gogɨ, su aw kɨ Jəju Jorijaləm tɨ, aw sie jam dɔ kəy tɨ lə Luwə taa. Lokɨ aw sie taa, nɨngə əl-e ə nə: «Re ḭ NGon lə Luwə ə, ɨyə̰ jii taa osɨ adɨ m-o, ");
INSERT INTO bjvNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: Luwə a adɨ ndune malayka je ləne kadɨ tə ɨndəi kəmde goi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɓəy taa, a lai-ni dajide tɨ, mba kadɨ njai tɨgə mbal al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jəju təl əl-e ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “A na Ɓaɓe Luwə ləi al”.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lokɨ su tɨgə kɨ nḛ na je kɨ kadɨ n-na-n Jəju ɓa, ɔr rɔne gogɨ sa̰y rɔe tɨ. Ɔr rɔne ngɨnə-n dɔkagɨlo kɨ rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lo kɨn tɨ, Jəju təl Galile. Re kɨ tɔgɨ kɨ ḭ rɔ NDɨl Luwə tɨ. Tɔ Jəju ɓa kɨ dɔ lo je kɨ no̰o̰ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","NDo nḛ me kəy kaw-naa je tɨ lə *Jɨpɨ je. Dɨje pətɨ ɨləi tɔjɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jəju aw Najarətɨ tɨ, kɨ e ɓe kɨ tɔgɨ tɨ. Təkɨ ɨsɨ ra-n kəte kəte, lokɨ ndɔ taa kə̰ə̰ asɨ nɨngə, Jəju aw kəy kaw-naa tɨ lə *Jɨpɨ je. Jəju ḭ taa kadɨ n-tɨdə makɨtɨbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lokɨ ḭ taa, adi-e makɨtɨbɨ lə nje kəl ta kɨ ta Luwə tɨ Ejay, kɨ kəi. Jəju rɨrə makɨtɨbɨ ka kɨn nɨngə, ɨngə ta kɨ ndangi əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«NDɨl lə Ɓaɓe e dɔm tɨ, Ɓaɓe kɔtɨ-m kadɨ m-ɨlə mbḛ Poy Ta kɨ Majɨ njé ndoo je. Ɓaɓe ɨlə-m kadɨ m-əl dangay je ta tḛḛde kəy dangay tɨ, Kadɨ m-əl njé kəm tɔ je təkɨ, kəmde a oo lo. Kadɨ m-taa njé kɨ dɨje ɨsɨ ɨndəi kəmde ndoo m-ɨlə-de taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kadɨ m-ɨlə mbḛ ɓal me-majɨ lə Ɓaɓe kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Go tɨ, Jəju kə makɨtɨbɨ ka kɨn, nɨngə təl-n adɨ nje kɨlə kɨ me kəy tɨ, ə ɨsɨ nangɨ kadɨ əl ta. Dɨje pətɨ kɨ me kəy kaw-naa tɨ ɓuki kəmde kɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lo kɨn tɨ, Jəju əl-de ə nə: «Ta kɨ oi kɨn, tɔl tane dɔsi tɨ ɓone.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dɨje pətɨ mai najɨ lə Jəju, taa mbḛ me-majɨ kɨ tḛḛ tae tɨ ətɨ-de ɓəl kɨ dum tɔ, adɨ əli-naa əi nə: «Ma, e ngon lə Jɨsəpɨ rɔje tɨ ne al a?» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Be ə Jəju əl-de ə nə: «M-gər kadɨ a əli-mi kujɨ ta kɨ ə nə: “Ḭ nje ra dɨje mo̰y, ajɨ rɔi ḭ wa,” kɨn. A əli-mi əi nə: “J-o poy nḛ je pətɨ kɨ ɨra Kapərnayɨm tɨ kɨn, ə ɨra ɓe koji tɨ ne be tɔ adɨ j-o”.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jəju təl əl-de ɓəy ə nə: «M-əl səsi ta kɨ rɔjetɨ, nje kəl ta kɨ ta Luwə tɨ kɨ ɓe koje uwe rɔne tɨ majɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kɨ rɔjetɨ, dɔkagɨlo tɨ lə nje kəl ta kɨ ta Luwə tɨ Eli, njé ngaw koy je əi ngay *Isɨrayəl tɨ. Nə lokɨ ndi ədɨ dɔnangɨ tɨ al ɓal mɨtə kɨ nusɨ, ə ɓo o̰ kɨ dɔnangɨ pətɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","dəw kare dande tɨ kɨ Luwə ɨlə Eli rɔe tɨ goto. E nje ngaw koy kɨ Sarəpɨta tɨ, dɔnangɨ kɨ Sɨdo̰ tɨ yo ə Luwə ɨlə Eli kɨ rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","NJé banjɨ je ka əi ngay Isɨrayəl tɨ dɔkagɨlo tɨ lə Elɨje tɔ, nə e kɨ kare kɨ kadɨ Luwə ɔr banjɨ rɔe tɨ goto. E Nama kɨ Sɨri tɨ yo ə Luwə ɔr banjɨ rɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lokɨ dɨje kɨ ɨsi gɨn kəy kaw-naa tɨ ooi ta kɨn, wongɨ tɔl-de pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lo kɨn tɨ, ḭḭ taai tuwəi Jəju me ɓe bo tɨ kɔ, nɨngə awi sie jam dɔ mbal tɨ kɨ ɨndəi ɓe bo tɨ. Awi sie tɨ mba kadɨ n-suri-e n-ləi-e n-tɔli-e kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nə Jəju ur dande tɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jəju aw Kapərnayɨm tɨ, kɨ e ɓe bo kɨ dɔnangɨ Galile tɨ. Jəju ndo nḛ dɨje ndɔ taa kə̰ə̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nḛ ndo lie ətɨ dɨje ɓəl kɨ dum. Ətɨ-de ɓəl kɨ dum tadɔ əl ta kɨ tɔgɨ kɨ ḭ rɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nɨngə, dəw madɨ kare kɨ ndɨl kɨ majal ra-e, ɨsɨ me kəy kaw-naa tɨ ləde no̰o̰, no̰ kɨ ndune kɨ bo ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Jəju kɨ Najarətɨ, ri ə ɨge rɔje tɨ ə? Ɨre mba kadɨ ɨtujɨ-je a? M-gər-i majɨ: ḭ kɨ Kay njay lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jəju ndangɨ ndɨl kɨ majal kɨ tɔgɨne ə nə: «Utɨ tai, ə ɨtḛḛ kɔ rɔ dɨngəm tɨ kɨn.» Lo kɨn tɨ, ndɨl kɨ majal bi dɨngəm ɨle dande tɨ, nɨngə tḛḛ rɔe tɨ kɨ kanjɨ kade ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nḛ kɨn ətɨ dɨje pətɨ ɓəl, adɨ dəji-naa ta dande tɨ əi nə: «Ta kɨn e ta kɨ ban ə ətɨ ɓəl be ə? Dəw kam aw kɨ tɔgɨ ko̰ɓe dɔ ndɨl je tɨ kɨ majal, ndangɨ-de kɨ tɔgɨ kɨ ḭ rɔ Luwə tɨ adɨ tḛḛi kɔ!» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","E be ə, tɔɓa lə Jəju sane kɨ dɔnangɨ kɨ no̰o̰ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lokɨ Jəju ḭ kəy kaw-naa tɨ lə *Jɨpɨ je, aw me kəy tɨ lə Sɨmo̰. Məm Sɨmo̰ kɨ dəne, mo̰y ra-e, rɔe tɨngə ngay. Be ə, əli Jəju kadɨ ra nḛ madɨ mbata tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jəju rugɨ rɔne dɔe tɨ, ndangɨ rɔ kɨ tɨngə ngay ka kɨn adɨ ɨyḛ. Kalangɨ ba go tɨ, məm Sɨmo̰ ḭ taa ra nḛ kuso adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lo sɔlɔ, ta kadɨ kur tɨ, dɨje pətɨ kɨ awi kɨ dɨje kɨ mo̰y je kɨ dangɨ dangɨ rai-de, rəi səde rɔ Jəju tɨ. Jəju ɨndə jine dɔde tɨ kare kare pətɨ adɨ ɨngəi rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","NDɨl je kɨ majal ka tḛḛi rɔ dɨje tɨ ngay kɨ no̰ tade tɨ əi nə: «Ḭ NGon lə Luwə!» Nə Jəju ɨndə tɔgɨ dɔde tɨ, adɨ-de ta rəbɨ kadɨ əli ta al, tadɔ gəri-e ɓətɨ kadɨ e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lokɨ lo ti, Jəju tḛḛ me ɓe bo tɨ aw dɨlə lo tɨ. Kosɨ dɨje ngay sangi-e, awi ɨngəi-e. Lokɨ ɨngəi-e, ndɨgi kadɨ n-uwəi-e nangɨ rɔde tɨ kadɨ tə aw lo al. ");
INSERT INTO bjvNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nə Jəju əl-de ə nə: «Sɔbɨ kadɨ m-ɨlə mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə ndəgɨ ɓe bo je tɨ tɔ, tadɔ e kɨ mbata ta kɨn ə Luwə ɨlə-m.» ");
INSERT INTO bjvNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","E be ə, Jəju ɨlə-n mbḛ Poy Ta kɨ Majɨ me kəy kaw-naa je tɨ lə *Jɨpɨ je dɔnangɨ Jude tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","NDɔ kare, Jəju e ɓasi kadɨ ba bo tɨ kɨ Gənəjarətɨ tɨ. Kosɨ dɨje uwəi-naa gəi gɨde mba kadɨ n-ooi ta lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lo kɨn tɨ, Jəju oo to je joo kɨ ɨsi ngangɨ ba tɨ. Əi to je kɨ njé ndo̰ je kɨ me tɨ ɨndəi-de ə awi a togi bandɨ je ləde. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jəju al me to tɨ kɨ kare kɨ e ya̰ Sɨmo̰, nɨngə əl Sɨmo̰ ade ɨyə̰ ngangɨ ba ə aw kɨ dana ndə̰y. Go tɨ, Jəju ɨsɨ nangɨ me to tɨ ndo nḛ kosɨ dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lokɨ əl ta oy nɨngə, əl Sɨmo̰ ə nə: «Aw kɨ dana lo kɨ man u tɨ, ə ɨləi bandɨ je ləsi ɨndo̰i kanjɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sɨmo̰ təl əl-e ə nə: «Ɓaɓe, j-ɨlə bandɨ ndɔ bɨtɨ lo ti, nə kanjɨ kare ka j-ɨngə al. Nə təkɨ e ḭ ə ɨdəjɨ-m, m-a m-ɨlə bandɨ təkɨ əl-m.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lokɨ ɨləi bandɨ je ləde, ɔyi kanjɨ kɔy kɨ to ɓəl, adɨ bandɨ je ləde ka ge gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lo kɨn tɨ, dəji madɨde je kɨ əi me to tɨ kɨ nungɨ kadɨ rəi rai səde. Madɨde je rəi, adɨ ɔyi kanjɨ ka kɨn rosɨ to je kɨ joo. Kanjɨ rosɨ to je adɨ to je awi tə ndui man. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lokɨ Sɨmo̰ oo nḛ kɨn, osɨ, ɔsɨ məkəsɨne nangɨ no̰ Jəju tɨ əl-e ə nə: «Ɓaɓe, ɔsɨ rɔi ngərəngɨ rɔm tɨ, tadɔ mi nje ra majal.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sɨmo̰ kɨ made je kɨ əi sie, ɓəl rade ɔjɨ-n go kanjɨ kɨ ɔyi me bandɨ tɨ to ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jakɨ kɨ Ja̰ kɨ ngan lə Jəbəde kɨ əi kɨ Sɨmo̰ ka ɓəl rade tɔ. Ə Jəju əl Sɨmo̰ ə nə: «Adɨ ɓəl rai al, kaw kɨ kəte no̰o̰, e dɨje ngata ə a ɨsa-de.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lo kɨn tɨ, təli rəi kɨ to je ngangɨ ba tɨ, nɨngə ɨyə̰i nḛ je pətɨ ə uni go Jəju tə njé ndo je lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","NDɔ kɨ rangɨ, Jəju e me ɓe bo tɨ kare, nɨngə dɨngəm kare kɨ banjɨ ra-e tḛḛ no̰o̰ re. Lokɨ oo Jəju nɨngə, osɨ kɨ ta kəmne nangɨ no̰e tɨ, no̰ kɨ dɔe tɨ ə nə: «Ɓaɓe, re ɨndɨgɨ ə a adɨ banjɨ ləm ur, kadɨ rɔm ay njay.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jəju ɨlə jine ɔde-n nɨngə əl-e ə nə: «M-ndɨgɨ, ə kadɨ banjɨ ləi ur, adɨ rɔi ay njay.» Ɓa ta naa tɨ no̰o̰ par ə banjɨ ur, adɨ rɔe ay njay. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Go tɨ, Jəju ade ndune kadɨ əl tae dəw madɨ al, nɨngə əl-e ə nə: «NJe kɨjə nḛ məsɨ kadɨ-kare yo ə aw ɔje rɔi, nɨngə adɨ kadɨ-kare təkɨ ndu-kun tɨ lə *Mojɨ dəjɨ-n. Ɨra be mba kadɨ gəri təkɨ banjɨ ləi ur adɨ ɨngə rɔ nga.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tɔɓa lə Jəju sane kɨ lo lo adɨ dɨje rəi kosɨ kosɨ mba kadɨ n-ooi ta lie je kadɨ ajɨ-n-de dɔ mo̰y je tɨ ləde je. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nə Jəju ɔr rɔne aw lo je tɨ kɨ to dɨlə mba kəl ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","NDɔ kare Jəju ɨsɨ ndo nḛ dɨje nɨngə, *Parɨsɨ je kɨ njé ndo ndu-kun je ɨsi dan dɨje tɨ no̰o̰ tɔ. Dɨje ḭḭ kɨ ngan ɓe je pətɨ kɨ dɔnangɨ Galile tɨ, kɨ dɔnangɨ Jude, kɨ ɓe bo Jorijaləm. Ɓaɓe ɔjɨ tɔgɨne me kajɨ njé mo̰y je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lo kɨn tɨ, dɨje madɨ oti dəw kare kɨ rɔe oy njururu, me nḛ kotɨ njé mo̰y je tɨ, rəi sie rɔ Jəju tɨ. Sangi rəbɨ kadɨ n-awi sie kəy n-ɨləi-e no̰ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nə gəri rəbɨ kɨ kadɨ awi sie al, tadɔ dɨje əi ngay. Be ə, ali taa, rai bole dɔ kəy tɨ nɨngə, ɨləi nje mo̰y kɨ nḛ kotɨ njé mo̰y je, ɨləi-e dan kosɨ dɨje tɨ no̰ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lokɨ Jəju oo kadɨ-me ləde nɨngə, əl dɨngəm ə nə: «Majal je ləi e kɨ kɨyə̰ go kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","NJé ndo ndu-kun je lə Luwə kɨ Parɨsɨ je ɨləi rɔde məri ta nɨngə əli əi nə: «Dəwe kam e na̰ ə əl ta kɨ mal dɔ Luwə tɨ be ə? Luwə kɨ karne ba par ə asɨ kɨyə̰ go majal je lə dɨje kɔ, dəw kɨ rangɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jəju gər mər ta je ləde kɨ mede tɨ adɨ əl-de ə nə: «Ra ban ə ɨsɨ ɨməri ta je kɨ be kɨn mesi tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kəl dəw kə nə: “Majal je ləi e kɨ kɨyə̰ go kɔ” ɓa nga̰ ngay al ə se, kəl-e kə nə: “Ḭ taa ə ɨnjɨyə” ɓa nga̰ ngay al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Re e be ɓa, m-a m-ɔjɨ səi təkɨ mi NGon Dəw, m-aw kɨ tɔgɨ dɔnangɨ tɨ ne, mba kadɨ m-ɨyə̰-n go majal je lə dɨje kɔ.» Nɨngə, Jəju əl nje rɔ koy njururu ə nə: «Ḭ taa, un tuwə ləi, ə aw ɓe.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta naa tɨ no̰o̰, dɨngəm ka kɨn ḭ taa ta kəm dɨje tɨ pətɨ, un tɨrə kɨ kəte to tɨ, ə tḛḛ aw ɓe kɨ kɨlə tɔjɨ dɔ Luwə tɨ tane tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dɨje pətɨ, nḛ kɨn ətɨ-de ɓəl adɨ ɨləi tɔjɨ dɔ Luwə tɨ. Ɓəl rosɨ mede adɨ əli əi nə: «J-o nḛ kɨ mba ɓone.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Go tɨ Jəju tḛḛ nɨngə yə oo dəw kare kɨ nje taa la-mbə kadɨ njé ko̰ɓe je kɨ ɓari-e nə *Ləbi, ɨsɨ me kəy taa la-mbə tɨ. Lokɨ oo Ləbi nɨngə əl-e ə nə: «Un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nɨngə Ləbi ɨyə̰ nḛ je pətɨ, ə ḭ taa un go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Go tɨ, Ləbi ra nḛ kuso kɨ bo ngay me kəy tɨ ləne, ɓar-n Jəju. Lo nḛ kuso tɨ kɨn, njé taa la-mbə je, kɨ ndəgɨ dɨje kɨ rangɨ əi səde tɨtɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","*Parɨsɨ je kɨ njé ndo ndu-kun je ɓai ta, əli njé ndo je lie əi nə: «Ra ban ə ɨsɨ usoi nḛ je, a̰yḭ-naa je kɨ njé taa la-mbə je, kɨ njé ra majal je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jəju un ta əl-de ə nə: «E dɨje kɨ njé mo̰y je ə a sangi dəw kɨ nje ra mo̰y, ɓɨ e njé rɔ nga je ə a sangi dəw kɨ nje ra mo̰y, al. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nɨngə, m-re mba ɓar dɨje kɨ dana al, nə m-re mba dɨje kɨ njé ra majal je yo mba kadɨ ɨyə̰i kɨlə rade je kɨ majal.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","NJé kɨ madɨ je əli Jəju əi nə: «Taa taa, njé ndo je lə Ja̰ Batɨsɨ əi kɨ njé ndo je lə *Parɨsɨ je ɨsɨ ɨyə̰i ta nḛ kuso, taa ɨsɨ əli ta kɨ Luwə tɔ, ə njé kɨ ya̰i je, ɨsɨ usoi nḛ je, a̰yḭ-naa man je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ə Jəju əl-de ə nə: «A asi kadɨ ɔgi dɨje kɨ ɓari-de lo nḛ kuso taa-naa tɨ kuso nḛ a? Dɔkagɨlo kɨ nje taa dəne ɨsɨ-n səde naa tɨ kɨn, a asi kɔgɨ-de kuso nḛ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","NDɔ je a rəi no̰o̰ kadɨ a uni-e tade tɨ nɨngə tə, a ɨyə̰i ta nḛ kuso. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jəju əl-de kujɨ ta kare ə nə: «Dəw a gangɨ ta kɨbɨ kɨ sɨgɨ kadɨ ɨlə-n kəm e kɨ kɔke al. Re e be ə, kɨbɨ kɨ sɨgɨ a e kɨ gangɨ kɔ, nɨngə ta kɨbɨ kɨ sɨgɨ ka kɨn uwəi naa kɨ kɨ kɔke al ɓəy tɔ, adɨ joo pu təl nḛ kɨ tujɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Taa, dəw a un kasɨ kandɨ nju kɨ kɨ ḭ al ɓəy utɨ me mbu nda je tɨ kɨ kɔke al. Re e be nɨngə, lokɨ kasɨ a ḭ ɓa mbu nda je a ndui, kadɨ kasɨ lo kɔ. Nɨngə mbu nda je təli nḛ kɨ tujɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Be ə, re kasɨ kandɨ nju ḭ al ɓəy ɓa, majɨ kadɨ mbu nda je əi kɨ sɨgɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lokɨ dəw a̰y kasɨ kandɨ nju kɨ ḭ nɨngə, a ge e kɨ ḭ al ɓəy al ngata. Tadɔ dɨje əli əi nə: “Kasɨ kɨ ḭ ə majɨ”.» ");
INSERT INTO bjvNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","NDɔ kare, Jəju ɨndə də me ndɔr gəme je tɨ. E ndɔ taa kə̰ə̰ lə *Jɨpɨ je. Nɨngə, njé ndo je lie kɨ əi sie, gangi dɔ ko je jide tɨ, təmi usoi. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ə *Parɨsɨ je madɨ əli-de əi nə: «Ra ban ə ɨrai nḛ kɨ kadɨ dəw ra ndɔ taa kə̰ə̰ tɨ al be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jəju əl-de ə nə: «Ɨtɨdəi nḛ kɨ ngar *Dabɨdɨ ra lokɨ ɓo ra-de kɨ dɨje kɨ goe tɨ kɨn al bɨtɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dabɨdɨ ur me kəy tɨ lə Luwə, un mapa kɨ dɨje adi Luwə kadɨ-kare tɨ uso, nɨngə təl-n adɨ dɨje kɨ goe tɨ usoi tɔ. Usoi mapa kɨ e nḛ kɨ sɔbɨ kadɨ njé kɨjə nḛ məsɨ kadɨ-kare je par ə usoi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jəju təl əl-de ɓəy ə nə: «Mi *NGon dəw m-aw kɨ tɔgɨ dɔ ndɔ taa kə̰ə̰ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*NDɔ taa kə̰ə̰ kɨ rangɨ, Jəju aw kəy kaw-naa tɨ lə *Jɨpɨ je, ndo nḛ dɨje. Nɨngə dɨngəm kare kɨ ji ko̰e oy njururu, e me kəy kaw-naa tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","NJé ndo ndu-kun je kɨ *Parɨsɨ je ɨsi jəke ɨsɨ ɨndəi kəmde kadɨ n-ooi se Jəju a adɨ dɨngəm kɨn rɔ nga ndɔ ta kə̰ə̰ tɨ lə Jɨpɨ je wa? E ta bole kɨ ɨsɨ sangi kadɨ n-ɨngəi ɓa n-ɨndəəi ta dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nə Jəju gər mər ta je ləde, adɨ əl dɨngəm kɨ jie oy njururu ka kɨn ə nə: «Ḭ taa, a dana ta kəm dɨje tɨ pətɨ.» Dɨngəm ḭ a taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nɨngə Jəju təl dəjɨ ndəgɨ dɨje ə nə: «M-dəjɨ səsi m-o, e ri ə majɨ kadɨ dəw ra ndɔ ta kə̰ə̰ tɨ ə? Kadɨ dəw ra majɨ ə se kadɨ ra majal ə? Kadɨ dəw nagɨ madɨne ta yo tɨ ə se kadɨ ɨyḛ adɨ tujɨ kɔ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jəju ɨndə kəmne go̰-n-de ba pətɨ, nɨngə əl dɨngəm ka kɨn ə nə: «Ɨsurə jii.» Dɨngəm surə jine, nɨngə jie təl to majɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wongɨ tɔl njé ndo ndu-kun je kɨ Parɨsɨ je, adɨ əli-naa ta dande tɨ dɔ nḛ tɨ kɨ kadɨ n-rai kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Me ndɔe je tɨ kɨn, Jəju aw dɔ mbal tɨ mba kəl ta kɨ Luwə. Əl ta kɨ Luwə kondɔ bɨtɨ lo ti. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lokɨ lo ti, Jəju ɓar njé ndo je ləne. Nɨngə mbo̰ njé ndo je tɨ kɨn ə, mbətɨ-de dɔgɨ gɨde e joo, ɓar-de njé kaw kɨlə je. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Adɨ e Sɨmo̰, kɨ ɨndə tɔe nə Pɨyər əi kɨ ngokone Andɨre, kɨ Jakɨ, kɨ Ja̰, kɨ Pɨlɨpɨ, kɨ Batɨləmi, ");
INSERT INTO bjvNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","kɨ Matɨye, kɨ Tomasɨ, kɨ Jakɨ, kɨ ngon lə Alpe, kɨ Sɨmo̰ kɨ ɓari-e dəw kɨ e mbo̰ njé rɔ mbata kɨngə dɔ lə ɓe ləde tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kɨ Judɨ kɨ ngon lə Jakɨ, taa Judasɨ Isɨkarɨyotɨ kɨ təl nje kun dɔ Jəju tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jəju ḭ kɨ njé kaw kɨlə je dɔ mbal tɨ re tḛḛ lo tɨ kɨ gɨde asɨ naa majɨ nɨngə, ɨngə kosɨ njé ndo je ləne, kɨ kosɨ dɨje ngay kɨ ḭ dɔnangɨ Jude tɨ je, njé kḭ ɓe bo Jorijaləm tɨ je, njé kḭ ɓe bo je tɨ kɨ kadɨ ba tɨ kɨ Tɨr je kɨ Sɨdo̰ je. Rəi mba koo ta lə Jəju je mba kadɨ ajɨ-de dɔ mo̰y je tɨ ləde je. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","NJé kɨ ndɨl je kɨ majal yəti angalde ɨngəi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nɨngə kosɨ dɨje pətɨ sangi kadɨ n-ɔdi rɔe, tadɔ tɔgɨ madɨ ɨsɨ tḛḛ rɔe tɨ adɨ-de rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jəju un kəmne oo-n njé ndo je ləne nɨngə əl-de ə nə: Səi njé ndoo je, səi njé majɨ-kur, tadɔ ko̰ɓe lə Luwə e ya̰si. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Səi kɨ ɓo ɨsɨ ra səsi ɓone, səi njé majɨ-kur, tadɔ lo ti ə a ɨndani. Səi kɨ ɨsɨ no̰i ɓone, səi njé majɨ-kur, tadɔ lo ti ə a kogi. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Majɨ-kur e ləsi lokɨ dɨje ɨsɨ mbati səsi, dɨje ɨsɨ tuwəi səsi, dɨje ɨsɨ taji səsi, dɨje ɨsɨ əli ta je kɨ majal dɔsi tɨ, mbata tɨ ləm mi *NGon dəw. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","NDɔ kɨ nḛ je kɨn tḛḛ dɔsi tɨ ə, majɨ kadɨ ɨrai rɔnəl, ɨtḭḭ bal, tadɔ nḛ kɨgə go jisi e ngay dɔra̰ tɨ. Tadɔ e be ə kade je adii ko̰ njé kəl ta je kɨ ta Luwə tɨ, kəte. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nə səi njé nḛ kɨngə, səi njé kəm-to-ndoo. Səi njé kəm-to-ndoo tadɔ ɨngəi nḛ sɔl me ləsi ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Səi kɨ ɓone ɨndani, səi njé kəm-to-ndoo, tadɔ lo ti ə ɓo a ra səsi. Səi kɨ ɓone ɨsɨ kogi, səi njé kəm-to-ndoo, tadɔ lo ti ə a uwəi ndoo je a no̰i je. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Səi kɨ dɨje ɨsɨ əli ta kɨ majɨ majɨ dɔsi tɨ, səi njé kəm-to-ndoo, tadɔ e be ə kade je rai kɨ njé kəl ta kɨ ta Luwə tɨ kɨ njé ngom je. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nɨngə səi kɨ ɨsɨ oi ta ləm, m-əl səsi kadɨ ɨndɨgi njé ba̰ je ləsi, ɨrai majɨ kɨ njé kɨ ɨsɨ ɔsi səsi ta. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ɨnjangi dɔ njé kɨ ɨsɨ mani səsi, ə əli ta kɨ Luwə mbata lə njé kɨ ɨsɨ əli ta je kɨ majal dɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Re dəw ɨndə dam mbɔi kɨ kare ə, ɨyətɨ dame kɨ nungɨ ade ɨndə ɓəy. Re dəw taa kɨbɨ kɨ ngal ləi ə, ade e kɨ gɔjɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dəw kɨ ra kɨ dəji nḛ ə ade, nɨngə dəw taa nḛ ləi ə ɨdəjɨ goe al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nḛ je kɨ ɨndɨgi kadɨ dɨje rai adi səsi kɨn ə, ɨrai kae tɨ wa kɨn adi-de tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kɨn ə ɨndɨgi njé kɨ ndɨgi səsi tɔ par ə, oyo ri ə kadɨ dəw ra səsi ə? Dəw a ra səsi oyo al, tadɔ njé ra majal je ka ndɨgi njé kɨ ndɨgi-de tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kɨn ə ɨrai majɨ kɨ njé kɨ rai səsi majɨ par nɨngə, oyo ri ə kadɨ dəw ra səsi ə? Dəw a ra səsi oyo al, tadɔ njé ra majal je ka rai təkɨ ɨrai kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kɨn ə adi njé kɨ ɨgəri majɨ kadɨ a ugəi səsi ɓangɨ par ə tunəi səsi nḛ nɨngə, oyo ri ə kadɨ dəw ra səsi ə? Dəw a ra səsi oyo al, tadɔ njé ra majal je ka, adi njé kɨ gəri majɨ kadɨ a ugəi-de kɔr nḛ ləde gogɨ par ə tunəi-de nḛ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Majɨ kadɨ ɨndɨgi njé ba̰ je ləsi, ɨrai majɨ kɨ no̰o̰ par, ə adi dɨje tunəi səsi nḛ kɨ kanjɨ kadɨ ɨndəi mesi dɔ kɨnge tɨ gogɨ. E be ə a ɨngəi nḛ kɨgə go ji kɨ bo, taa a səi ngan lə nje kɨsɨ dɔ nḛ je tɨ pətɨ tɔ. Tadɔ e nje ra majɨ kɨ dɨje kɨ gəri ra oyo al kɨ dɨje kɨ nje me majal. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Majɨ kadɨ səi njé ra majɨ kɨ ngay təkɨ Bawsi Luwə e-n nje ra majɨ kɨ ngay kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ɨgangi ta dɔ dəw tɨ al, nɨngə Luwə a gangɨ ta dɔsi tɨ al tɔ. Uwəi dəw kɨ ta al, nɨngə Luwə a uwə səsi kɨ ta al tɔ. Ɨyə̰i go majal lə dəw kɔ, nɨngə Luwə a ɨyə̰ go majal ləsi kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Adi, ə Luwə a adɨ səsi tɔ. Luwə a ɓukɨ posɨ kɨbɨ tɨ ləsi kadɨ rosɨ majɨ: a yəkɨ, mbɨsɨ dɨgɨ dɨgɨ, ɓukɨ kadɨ rosɨ re puu kɔ. Tadɔ go rəbɨ kɨ ɨgangii ta dɔ dɨje kɨn ə Luwə a gangɨ-n ta dɔsi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nɨngə Jəju təl əl-de ta kare me kujɨ ta tɨ ɓəy ə nə: «NJe kəm tɔ a ndɔr nje kəm tɔ madɨne ban ə? A ndɔr-e al, tadɔ re ndɔr-e ə a osi joo pu me ɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","NJe ndo ɨtə nje ndo-e nḛ al, re e nje ndo kɨ ɓae ndo-e nḛ bərəre bərəre majɨ nɨngə, a to tə ɓane be. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Ra ban be ə, o burɨm wale kɨ to kəm ngoko̰i tɨ yo, ə o kagɨ kɨ boy kɨ to ya̰i tɨ ḭ wa kɨn al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kagɨ kɨ boy kɨ to kəmi tɨ ḭ wa kɨn o al nɨngə, kɨ go rəbɨ kɨ ban ə a asɨ kadɨ əl ngoko̰i ə nə: “NGokom, adɨ m-un burɨm wale kɨ to kəmi tɨ kɨn,” ə? Ḭ nje kədɨ kəm dɨje, un kagɨ kɨ boy kɨ kəmi tɨ kɨn nɨngə tə, a o lo ay njay kadɨ un-n burɨm wale kɨ kəm ngoko̰i tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kagɨ kɨ majɨ kɨ kadɨ a andɨ kandɨ kɨ majal goto, taa kagɨ kɨ majal kɨ kadɨ a andɨ kandɨ kɨ majɨ ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","E kɨ kandɨ kagɨ kɨ sɔbɨ dɔ kage kɨn ə a gəri-e-n. Dəw a ɨjə kandɨ mbay-kote dɔ kon pa tɨ al, taa dəw a ɨjə kandɨ nju dɔ kon bər tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dəw kɨ majɨ, kɨlə rae tḛḛ me nḛ ra tɨ kɨ majɨ kɨ uwə mee. Nɨngə dəw kɨ majal, kɨlə rae tḛḛ me nḛ ra tɨ kɨ majal kɨ uwə mee tɔ. Tadɔ e nḛ je kɨ rosɨ me dəw kɨn ə ɨsɨ tḛḛ tae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ra ban ə ɨɓari-mi “Ɓaɓe, Ɓaɓe”, ə ɨrai nḛ kɨ m-əl səsi al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dəw kɨ ra kɨ re rɔm tɨ, oo ta ləm, ə təl rɔne go tɨ nɨngə, e dəw kɨ to tə dəw kɨ m-a m-əl səsi ta lie kam be. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","To tə dəw kɨ nje ra kəy, kɨ ur ɓe dɔ dii tɨ adɨ əbɨ majɨ, ɓəy taa, ɨndə gɨn kəy tɨ kɨn be. Lokɨ man ḭ nɨngə, man ko̰ lo re un kəy ka kɨn, nə asɨ kadɨ tɔ kəy ka kɨn al, tadɔ ɨndə adɨ nga̰ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nə dəw kɨ oo ta ləm, ə təl rɔne go tɨ al, to tə dəw kɨ ɨndə kəy ləne dɔnangɨ tɨ taa ne kare, kɨ kanjɨ kur ɓe kɨndə gɨne tɨ be. Lokɨ man ko̰ re un kəy ka kɨn nɨngə, ndə̰y ba ɓəy par ə kəy budɨ nangɨ mur mur kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lokɨ Jəju əl ta je kɨn pətɨ kosɨ dɨje ɓa, ɔtɨ aw Kapərnayɨm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Me ɓe tɨ kɨn, dəw kare kɨ nje kun dɔ ɓutɨ asɨgar je kɨ ɓu, aw kɨ ngon nje kɨlə ləne kare kɨ e mo̰y, to ta koy tɨ. Nɨngə e ngon nje kɨlə kɨ ɓae ge ta lie ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Be ə, lokɨ kɨ bo lə asɨgar je ka kɨn oo ta lə Jəju nɨngə, ɨlə ngatɔgɨ je madɨ, kɨ əi ngatɔgɨ lə *Jɨpɨ je, adɨ-de awi ɨngəi Jəju kadɨ dəji-e adɨ re səde ajɨ ngon nje kɨlə ləne kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lokɨ rəi ɨngəi Jəju nɨngə, no̰i dɔe tɨ kɨ nja naa tɨ naa tɨ əi nə: «Dɨngəm kɨn, e dəw kɨ asɨ kadɨ ɨra sie me nḛ dəjɨ tɨ lie kɨn, ");
INSERT INTO bjvNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tadɔ ndɨgɨ-je je Jɨpɨ je ngay, taa e e tɔ ə ra kəy kaw-naa ləje adɨ-je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ə Jəju ɔtɨ aw səde. Awi, ə lokɨ ɨndəi dɔ kəy ɓasi nɨngə, kɨ bo lə asɨgar je ka kɨn ɨlə madɨne je madɨ adɨ awi əli Jəju əi nə: «Ɓaɓe, ɨtapɨ rɔi al, tadɔ mi m-asɨ kadɨ ɨndə njai ta kəy tɨ ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E mbata kɨn ə, mi wa m-aw-n kɨ rɔm rɔi tɨ al. NGa nɨngə, m-dəji kadɨ əl ta kare par ə ngon nje kɨlə ləm a ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","M-əl be tadɔ, mi kɨ dɔm mi gɨn tɔgɨ tɨ lə njé kɨ dɔm tɨ, nɨngə m-aw kɨ asɨgar je kɨ əi gɨn tɔgɨ tɨ ləm tɔ. Adɨ re m-əl asɨgar kare m-ə nə: “Aw!” ɓa aw; kɨn ə m-əl kɨ nungɨ m-ə nə: “Ɨre!” ɓa re; kɨn ə m-əl ngon nje kɨlə ləm m-ə nə: “Ɨra nḛ kɨ be!” ɓa ra nḛe kɨn tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lokɨ Jəju oo ta je kɨn ɓa, pɨtɨ kɨ bo lə asɨgar je ka kɨn, nɨngə təl kəmne kɨ dɔ kosɨ dɨje tɨ kɨ a njɨyəi goe tɨ, əl-de ə nə: «Adɨ m-əl səsi, ko kadɨ-me kɨ be kɨn, dɔnangɨ kɨ *Isɨrayəl tɨ wa ka m-ɨngə al ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lokɨ njé kaw kɨlə je əi nə n-təli ɓe nɨngə yə ɨngəi ngon nje kɨlə ka kɨn, rɔe nga adɨ ɨsɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jəju ɔtɨ no̰o̰ aw ɓe bo tɨ kɨ tɔe nə Nayɨm. *NJé ndo je lie kɨ kosɨ dɨje ngay uni goe awi sie. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lokɨ rəi tḛḛi ɓasi kɨ ta rəbɨ kɨ ur kɨ me ɓe tɨ ka kɨn nɨngə, dɨje ɨsɨ awi kɨ dəw kɨ oy kadɨ dɨbi-e. Dəw kɨ oy ka kɨn e ngon lə dəne kɨ nje ngaw koy kare be. E ngone kɨ dɨngəm kɨ kare ba be, adɨ kosɨ dɨje ngay kɨ me ɓe tɨ, ɨsɨ dani dəne ka kɨn lo dɨbɨ ngone tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lokɨ Jəju o dəne ka kɨn nɨngə, kəm ko̰ ra-e ngay mbata tɨ lə dəne ka kɨn, adɨ əl-e ə nə: «Ɨno̰ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jəju aw kadɨ kəsɨ yo tɨ, ɨlə jine ɔdɨ-n. NJé kotɨ nɨn je ai nangɨ, ɓa Jəju əl ə nə: «Basa, m-əli kadɨ ḭ taa!» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɨngə nje koy ḭ ɨsɨ taa, ə ɨlə ngɨrə kəl ta. Jəju təl ule ji ko̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Dɨje pətɨ, nḛ je kɨn ətɨ-de ɓəl, adɨ ɨləi tɔjɨ dɔ Luwə tɨ əi nə: «NJe kəl ta kɨ ta Luwə tɨ kare kɨ bo tḛḛ danje tɨ ne: Luwə re ra kɨ dɨje ləne.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nḛ kɨ ra nḛ kɨn, poye rosɨ dɔnangɨ kɨ Jude tɨ pətɨ kɨ ngan ɓe je kɨ gəi gɨde. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","*NJé ndo je lə Ja̰ ɔri-e poy nḛ kɨ ra nḛ kɨn adi-e oo, ə Ja̰ ɓar njé ndo je ləne joo, ");
INSERT INTO bjvNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ɨlə-de rɔ Ɓaɓe tɨ adɨ dəji-e əi nə: «Ḭ ə ḭ dəw kɨ Luwə mbəte, kɨ sɔbɨ kadɨ a re ka kɨn ə se, e nay no̰o̰ ɓəy kadɨ tə jɨ ngəm tae ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lokɨ rəi tḛḛi rɔ Jəju tɨ, əli-e əi «E Ja̰ Batɨsɨ ə ɨlə-je kɨ rɔi tɨ kadɨ jɨ dəji se “ḭ ə ḭ dəw kɨ Luwə mbəte, kɨ sɔbɨ kadɨ a re ka kɨn ə se, e nay no̰o̰ ɓəy kadɨ tə jɨ ngəm tae wa?”» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dɔkagɨloe tɨ wa kɨ ɨsɨ dəji-e ta kɨn, Jəju ɨsɨ ajɨ njé mo̰y je ngay nɨm, njé mətɨ je nɨm, ɨsɨ tuwə ndɨl je kɨ majal dɔ dɨje tɨ nɨm, taa adɨ njé kəm tɔ je ngay ooi lo nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nɨngə ɨlə njé kɨlə je tɨ lə Ja̰ ə nə: «Awi əli Ja̰ nḛ je kɨ oi kɨ mbisi je, kɨ kəmsi je kɨn: NJé kəm tɔ je ooi lo, njé mətɨ je njɨyəi majɨ, njé banjɨ je ɨngəi rɔ nga, njé mbi bəy je ooi ta, njé koy je ḭḭ taa lo koy tɨ, taa njé ndoo je ka, e kɨ kɨlə-de mbḛ Poy Ta kɨ Majɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Majɨ-kur e lə dəw kɨ m-təl gɨn kosɨ lie, al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lokɨ njé ndo je lə Ja̰ təli awi, Jəju ɨlə ngɨrə kəl kosɨ je ta kɨ dɔ Ja̰ tɨ ə nə: «E ri ə awi ɨsɨ oi dɨlə lo tɨ ə? E gakɨra kɨ nəl ɨsɨ aw sie kɨ yo je, kɨ ne je kɨn a? ");
INSERT INTO bjvNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A re e e al ə, e ri wa bangɨ awi ɨsɨ oi ə? E dəw kɨ ɔ kɨbɨ kɨ ndole ngay ɓa awi oi-e ma? NGa njé kɨ ɔi kɨbɨ je kɨ gate e ngay ka, ɨsi lo je tɨ kɨ sɔl lum, ɨsi me kəy je tɨ kɨ boy kɨ ngar je ɨsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ə se e ri wa ə awi oi wa? E nje kəl ta kɨ ta Luwə tɨ ə awi oi-e ma? Re e e ə, m-əl səsi m-ə nə oyo, e nje kəl ta kɨ ta Luwə tɨ kɨ ɨtə njé kəl ta je kɨ ta Luwə tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","E e ə makɨtɨbɨ lə Luwə əl ta kɨ dɔe tɨ kəte ə nə: “M-a m-ɨlə kɨ nje kaw kɨlə ləm kəte kadɨ ra go rəbɨ no̰i tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nɨngə adɨ m-əl səsi, dan dɨje tɨ pətɨ kɨ dəne je oji-de kɨn, dəw kɨ bo ɨtə Ja̰ goto. Nə kɨ ɓasɨne kɨn, dəw kɨ e kɨ du ngay me ɓeko̰ tɨ lə Luwə bo ɨte. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Dɨje pətɨ kɨ ooi ta lie, naa tɨ kɨ njé taa la-mbə je gəri kadɨ Luwə ra nḛ kɨ dana, adɨ adi Ja̰ ra-de batəm. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nə *Parɨsɨ je kɨ njé ndo ndu-kun je ɔsi nḛ kɨ Luwə ɨndə dɔe dana mbata tɨ ləde ngərəngɨ, adɨ mbati kadɨ Ja̰ ra-de batəm. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","M-o dəw kɨ kadɨ m-un-e m-ɔjɨ-n dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨn al. Toi tə na̰ wa ka m-gər al. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","M-a m-ə nə toi tə ngan je kɨ du kɨ ɨsi ta mbalo tɨ, ɓari-naa kɨ yo je, kɨ ne je əi nə: “Jɨ kɔl nal kadɨ ɨndamii, ə ɨmbati ndam, j-osɨ pa yo kadɨ ɨno̰i, ə ɨmbati no̰.” ");
INSERT INTO bjvNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","E be ə, Ja̰ Batɨsɨ re, ə uso mapa al nɨm, a̰y kasɨ nju al nɨm ɓa, əli əi nə: “Dɔe majal.” ");
INSERT INTO bjvNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","NGa ə, mi *NGon dəw m-re, ə m-uso nḛ je, m-a̰y man je ɓa, səi əli əi nə: “Mi nje kuso nḛ kədɨ, mi nje ka̰y nḛ, mi madɨ njé taa la-mbə je, kɨ njé ra majal je,” ɓəy tɔ! ");
INSERT INTO bjvNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nə ngan lə Luwə pətɨ kɨ ndɨgi gosɨ lie, gəri kadɨ gosɨ lie e gosɨ kɨ dana.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parɨsɨ kare ɓa Jəju kadɨ aw uso səne ne. Be ə, Jəju aw ɨsɨ sie ta nḛ kuso tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lo kɨn tɨ, dəne kare kɨ me ɓe tɨ kɨn tḛḛ no̰o̰ re. E dəne kɨ nje ra kaya, ə gər kadɨ Jəju ɨsɨ ɓe lə Parɨsɨ kɨ ɓari-e Sɨmo̰ kɨn no̰o̰, ɨsɨ uso nḛ. Dəne re kɨ ku mbal kɨ ɓari-e albatɨr kɨ yɨbɨ kɨ ətɨ majɨ rosɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Re ɨsɨ go Jəju tɨ, njae tɨ, ɨsɨ no̰, nɨngə yo̰m nja Jəju kɨ man kəmne, ɓa bɔr kɨ bɨsɨ dɔne. Go tɨ, təl tɔn nja Jəju, ɓa ɓukɨ yɨbɨ tɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lo kɨn tɨ, Parɨsɨ kɨ ɓa Jəju ɓe ləne ka kɨn əl mene tɨ ə nə: «Kɨn ə re dɨngəm kɨn e nje kəl ta kɨ ta Luwə tɨ təkɨ rɔjetɨ ə, asɨ kadɨ a gər dəne kɨ ɨsɨ ɔde kɨn, asɨ kadɨ a gər kɨlə ra-e je kɨ majal kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ə Jəju əl-e ə nə: «Sɨmo̰, m-aw kɨ ta kare ne kadɨ m-əli.» NGa ə Sɨmo̰ ɨlə Jəju tɨ ə nə: «NJe ndo dɨje, əl-m.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ɓa Jəju əl-e ə nə: «Dɨngəm kare adɨ la dɨje joo, ɨndə kɨrə tɨ. Kɨ kare kadɨ a uge kɨrə kɨ lo kɨlə kɨ ndɔ ɓu mi, ə kɨ nungɨ kadɨ a uge kɨrə kɨ lo kɨlə tɨ kɨ ndɔ kutɨ mi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nə lokɨ asi kadɨ ugəi kɨrə ka kɨn dɔde tɨ al, dɨngəm kɨ nje la ka kɨn ɨyə̰ kɔ kɨ go me-majɨ tɨ adɨ-de joo pu. Ə se dan dɨje tɨ kɨ joo kɨn, e kɨ ra a ndɨgɨ dɨngəm kɨ nje la kɨn ngay ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nɨngə Sɨmo̰ ɨlə Jəju tɨ ə nə: «M-o kadɨ e e kɨ la kɨ dɔe tɨ e ngay ə ɓae ɨyə̰ kɔ kɨn ə a ndɨgɨ nje la kɨn ngay.» Ə Jəju əl-e ə nə: «Ta ləi e ta kɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nɨngə təl kəmne kɨ dɔ dəne tɨ ka kɨn, ɓa əl Sɨmo̰ ə nə: «O dəne kɨn a? M-re ɓe ləi, ə man kɨ kare ka ɨmbəl dɔ njam tɨ al, nə e, yo̰m njam kɨ man kəmne, taa bɔr kɨ bɨsɨ dɔne ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ḭ uwə-m kɨ rɔi tɨ jururu al, nə e, lokɨ m-ur kəy nu, ra kɨlə kɔy njam jururu kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ḭ ɨɓukɨ yɨbɨ dɔ njam tɨ al, nə e, ɓukɨ yɨbɨ kɨ ətɨ majɨ dɔ njam tɨ pɔ pɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Be ə, m-a m-əli təkɨ e kɨ go rəbɨ majal je lie kɨ ngay kɨ kɨyə̰ kɨn ə, ɔjɨ-n ndɨgɨ-naa kɨ ətɨ ɓəl kɨn. Nɨngə dəw kɨ majal je lie e kɨ kɨyə̰ go kɔ ngay al, a tɔjɨ ndɨgɨ-naa kɨ ngay al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɓa Jəju əl dəne ka kɨn ə nə: «Majal je ləi e kɨ kɨyə̰ go kɔ kadi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lo kɨn tɨ, dɨje madɨ kɨ ɨsi sie ta nḛ kuso tɨ ɨləi ngɨrə kəl mede tɨ əi nə: «Dəw kɨn e na̰ ə aw bɨtɨ kadɨ ɨyə̰ go majal lə dɨje kɔ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nə Jəju əl dəne ə nə: «Kadɨ-me ləi aji, aw kɨ lapɨya.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Go tɨ, Jəju aw kɨ ɓe bo je, kɨ ngan ɓe je, əl ta, ɨlə-n mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə. *NJé ndo je lie kɨ dɔgɨ gɨde joo əi sie naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Taa, dəne je madɨ kɨ ndɔ kɨ Jəju tuwə ndɨl je kɨ majal dɔde tɨ kɔ je, e kɨ adɨ-de rɔ nga dɔ mo̰y je tɨ ləde je kɨn ka əi no̰o̰ tɔ. Adɨ e Mari kɨ Magɨdala kɨ ndɔ kɨ Jəju tuwə ndɨl je kɨ majal sɨri dɔe tɨ kɔ kɨn nɨm, ");
INSERT INTO bjvNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jan kɨ ne Suja, kɨ e dɨngəm kɨ nje ngəm nḛ lə *Erodɨ kɨn nɨm, Sujan nɨm, taa ndəgɨ dəne je kɨ rangɨ ngay ɓəy tɔ. Əi kɨn ə əi dəne je kɨ njé ra kɨ Jəju kɨ nḛ kɨngə je ləde. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kosɨ dɨje kɨ ḭḭ kɨ ɓe bo je kɨ dangɨ dangɨ, kawi-naa kɨ dɔ Jəju tɨ, ə Jəju əl-de kujɨ ta madɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«NJe ndɔr kare aw kadɨ dɨbɨ nḛ, nɨngə dɔkagɨlo kɨ a ɨlə ko nḛ, ka̰ ko je madɨ tosi ngangɨ rəbɨ tɨ, adɨ dɨje njɨyəi dɔ tɨ, yəl je rəi o̰i makɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ka̰ ko je madɨ tosɨ dɔnangɨ njəkɨrə tɨ, adɨ lokɨ mbie je əi nə n-tḛḛi ɓa, təli tuti kurɨm, mbata lo kɨ sɔl kɨ kadɨ ɨləi ngɨrəde tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ka̰ ko je kɨ nungɨ, tosi dan kon je tɨ, adɨ kon je tɔgi səde naa tɨ, təli ndəmi-de mbɔl. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nə ka̰ ko je madɨ, tosi dɔnangɨ tɨ kɨ majɨ, adɨ tɔgi, kandɨde tḛḛ. Dɔe kare andɨ asɨ ɓu, ɓu.» NGa nɨngə, Jəju tɔl dɔ ta ləne kɨn ə nə: «Dəw kɨ aw kɨ mbine mba koo-n dɔ ta ɓa, kadɨ oo dɔ ta kɨn majɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","*NJé ndo je lə Jəju dəji-e əi nə se kujɨ ta kɨn me nə ri wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ə Jəju ɨlə-de tɨ ə nə: «Səi, Luwə tḛḛ kɨ dɔ nḛ kɨ to lo ɓɔyɔ tɨ kɨ ɔjɨ dɔ ko̰ɓe lie adɨ ɨgəri, nə ndəge je, nḛ kɨn e kɨ kɔjɨ-de kɨ kujɨ ta, mba kadɨ: “Re kəmde oo lo majɨ ka, ooi nḛ al, MBide oo dɔ ta majɨ ka gəri me al”.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jəju əl njé ndo je ləne ə nə: «Kujɨ ta kɨn, me ə to kɨn: ka̰ ko, e ta lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","E kɨ tosɨ ngangɨ rəbɨ tɨ, e dɨje madɨ kɨ ooi ta lə Luwə, nɨngə su re ɔr ta kɨ oi ka kɨn mede tɨ kɔ, nə tə pa nḛ ta ḭḭ adi mede Jəju kadɨ ḭḭ ɨngəi kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka̰ ko kɨ tosɨ dɔnangɨ njəkɨrə tɨ, əi dɨje kɨ ooi ta lə Luwə ɓa, taai kɨ rɔnəl, nə lo kadɨ ta kɨn ɨlə ngɨrəne mede tɨ nga̰ goto. Adi mede ngon kagɨ lo kɨ ndə̰y be par, nə lokɨ ko̰ je tḛḛ dɔde tɨ ɓa, ɨyə̰i go kadɨ-me ləde kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka̰ ko kɨ tosɨ dan kon tɨ, əi dɨje kɨ ooi ta lə Luwə, nə go tɨ, me ka sururu, kɨ nḛ majɨ je, kɨ koo majɨ rɔ kɨ dɔnangɨ tɨ ne ɔgɨ-de kadɨ tɔgi me kadɨ-me tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nɨngə ka̰ ko kɨ tosɨ dɔnangɨ tɨ kɨ majɨ, əi dɨje kɨ ooi ta lə Luwə kɨ nga̰mede kɨ majɨ, nga̰me kɨ rɔjetɨ, nɨngə ngəmi mede tɨ, uwəi tɔgɨde ba, adi kandɨ kɨlə ləde tḛḛ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«Dəw a ɨndə por lambɨ tɨ kadɨ dəbɨ ngo dɔ tɨ al, taa ɨndə gɨn tɨrə tɨ al tɔ. A ɨndə dɔ nḛ tɨ taa, kadɨ dɨje uri kəy ɓa, oi lo kɨ kunje. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tadɔ nḛ kɨ to lo ɓɔyɔ tɨ, kɨ gɨne a tḛḛ al goto, taa nḛ kɨ to lo ɓɔyɔ tɨ, kɨ a to taga kadɨ dɨje gəri al ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Majɨ kadɨ uri mbisi majɨ oi dɔ ta kɨ ɨsɨ oi, ɓɨ kadɨ oi kɨ no̰o̰ be al. Tadɔ dəw kɨ aw kɨ nḛ jine tɨ, a adi-e dɔ tɨ ɓəy. Nə dəw kɨ nḛ lie goto, e kɨ ndɨkɨri wa kɨ ɨndə mene dɔ tɨ kɨn ka, a taai jie tɨ wa ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ko̰ Jəju kɨ ngako̰e je rəi kadɨ n-ooi-e, nə lo kadɨ tḛḛi rɔe tɨ goto mbata kosɨ dɨje kɨ əi ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ə əli-e əi nə: «O ko̰i je, kɨ ngako̰i je ai taga no̰o̰, a sangi kadɨ n-ooi-ni.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nɨngə Jəju təl əl-de ə nə: «Kom je, kɨ ngakom je ə əi dɨje kɨ ooi ta lə Luwə, ɓa təli rɔde go tɨ, rai kɨle.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","NDɔ kare, Jəju al me to tɨ əi kɨ njé ndo je ləne, nɨngə əl-de ə nə: «Adɨ jɨ gangi ba j-awi dame tɨ kɨ kare.» Ɓa awi. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lokɨ ɨsɨ ɔsi to ɨsɨ gangi ba kɨn ɓa, Jəju to ɓi makɨ. Ə nəl kɨ bo ngay osɨ dɔ ba tɨ, ra adɨ man rosɨ to, əi ta yo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lo kɨn tɨ, njé ndo je rəi kɨ rɔe Jəju tɨ, ndəli-e kɨ no̰ tade tɨ əi nə: «NJe ndo dɨje, NJe ndo dɨje, j-ɨsɨ j-oy!» Lokɨ Jəju ndəl, ndangɨ nəl je kɨ pungɨ man je adɨ təli toi jəke, lo to jɨjɨji. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ɓa təl əl njé ndo je ə nə: «Kadɨ-me ləsi to ra be tɔy ə?» NGa nɨngə ɓəl ra-de, nḛ kɨn ətɨ-de ɓəl ngay, adɨ dəji-naa ta dande tɨ əi nə: «Dəw ə wa kam e na̰ ə nəl je kɨ man je ka əl-de ta par ə təli rɔde goe tɨ be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jəju əi kɨ njé ndo je ləne rəi tḛḛi dɔnangɨ tɨ kɨ Gərasa, kɨ a ta ɓe tɨ kɨ Galile. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lokɨ Jəju ḭ me to tɨ ur kɨ nangɨ nɨngə, dɨngəm kare kɨ me ɓe tɨ kɨ Gərasa, ḭ no̰o̰ re kɨ rɔ Jəju tɨ. E dɨngəm kɨ ndɨl je kɨ majal rai-e. Asɨ dɔkagɨlo ngay, dɨngəm kɨn ɨlə kɨbɨ rɔne tɨ al nɨm, ɨsɨ ɓe me kəy tɨ al nɨm. Lo kɨse e dɔ ɓadɨ je tɨ par. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lokɨ oo Jəju nɨngə, osɨ nangɨ njae tɨ, ɓa əl ta kɨ ndune kɨ boy ə nə: «Jəju kɨ NGon lə Luwə kɨ nje kɨsɨ dɔra̰ tɨ taa nu, e ri ə ɨge rɔm tɨ ə? NJai ba, adɨ-m ko̰ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Əl be tadɔ Jəju adɨ ndune ndɨl kɨ majal kadɨ tḛḛ rɔ dɨngəm tɨ kɨn kɔ. NJa ngay ndɨl kɨ majal kɨn ḭ kɨ dɨngəm ka kɨn ɓa ra-e. Dɨje dɔɔi-e kɨ kulə gɨndɨ je, ɨləi kangɨla gɨndɨ njae tɨ je, nə gangɨ kulə gɨndɨ je kɨn rɨw rɨw ə tətɨ kangɨla gɨndɨ je kɨn nusɨ nusɨ rɔne tɨ kɔ, ɓa ndɨl je kɨ majal ɔsi-e adɨ aw kɨ dɨlə lo dɨlə lo. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ə Jəju dəje ə nə: «Tɔi nə na?» Ɓa e ɨlə Jəju tɨ ə nə: «Tɔm nə kosɨ njé rɔ je.» Tadɔ ndɨl je kɨ majal ngay uri me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lo kɨn tɨ, ndɨl je kɨ majal ka kɨn no̰i dɔ Jəju tɨ kadɨ adɨ-de n-awi lo dangay tɨ lə ndɨl je kɨ majal al. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kosɨ kɔsongɨ je ai lo tɨ kɨn no̰o̰ a usoi nḛ dɔ mbal tɨ, ə ndɨl je kɨ majal ka kɨn no̰i dɔ Jəju tɨ kadɨ adɨ-de n-awi mede tɨ. Ɓa Jəju adɨ-de ta rəbɨ kadɨ awi mede tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","NDɨl je kɨ majal tḛḛi me dɨngəm tɨ, awi uri me kɔsongɨ je tɨ ka kɨn. Nɨngə yə, kɔsongɨ je ɓɨngəi-naa kadɨ mbal tɨ taa, tosi me ba tɨ, a̰yḭ-naa man oyi. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lokɨ dɨje kɨ njé ngəm kɔsongɨ je ooi nḛ kɨ ra nḛ kɨn ɓa, a̰yḭ-naa awi me ɓe bo tɨ kɨ ngan ɓe je, ɔri poy nḛ kɨ ra nḛ kɨn dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dɨje tḛḛi awi kadɨ n-ooi nḛ kɨ ra nḛ kɨn. Be ə, lokɨ rəi tḛḛi rɔ Jəju tɨ nɨngə, ooi dɨngəm kɨ ndɨl je kɨ majal tḛḛi me tɨ ka kɨn, ɨsɨ nja Jəju tɨ. OOi-e kadɨ ɨsɨ kɨ kɨbɨ rɔne tɨ, kɨ angal kɨ majɨ, adɨ ra-de ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","NJé kɨ ai lo nḛ tɨ kɨ ra nḛ kɨn, ɔri madɨde je poye, tɔji rəbɨ kɨ dɨngəm kɨ aw kɨ ndɨl je kɨ majal kɨn ɨngə-n rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lo kɨn tɨ no̰o̰ be, dɨje kɨ dɔnangɨ Gərasa tɨ, ɓəl tɔl-de, adɨ dəji Jəju kadɨ ɨyə̰ dɔnangɨ ləde ə aw. Ə Jəju al me to tɨ, təl gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dɨngəm kɨ Jəju tuwə ndɨl je kɨ majal dɔe tɨ kɔ ka kɨn dəjɨ Jəju kadɨ n-aw sie, nə Jəju tuwe ");
INSERT INTO bjvNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ə nə: «Ɨtəl aw ɓe, ɔr poy nḛ je pətɨ kɨ Luwə ra səi kɨn adɨ dɨje ooi.» Be ə, dɨngəm aw ɨlə mbḛ nḛ kɨ Jəju ra sie kɨn me ɓe bo tɨ kɨ tae ba. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lokɨ Jəju təl re, kosɨ dəjɨ uwəi-e kɨ rɔde majɨ, tadɔ pətɨ ɨsɨ ngɨnəi tae. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nɨngə yə dɨngəm kare kɨ tɔe nə Jayrusɨ, kɨ e nje kun dɔ kəy kaw-naa lə *Jɨpɨ je ḭ no̰o̰ re. Re osɨ nja Jəju tɨ, no̰ dɔe tɨ kadɨ re aw ɓe ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kadɨ aw ɓe ləne mbata ngone kɨ dəne kɨ e kare ba, ɓale e dɔgɨ gɨde joo to ta koy tɨ. Lokɨ Jəju ɨsɨ aw, kosɨ dɨje mborəi-e kɨ yo je kɨ ne je, lo kɔr kə̰ə̰ goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dan kosɨ dɨje tɨ kɨn, dəne kare kɨ mo̰y məsɨ ade ko̰ ɓal dɔgɨ gɨde joo e no̰o̰. Dəne kɨn tujɨ nḛ kɨngə ləne kɔ pətɨ ji njé ra dɨje mo̰y tɨ, nə dəw kɨ kadɨ ade rɔ nga goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dəne re ɓasi rɔ Jəju tɨ, kɨ rəbɨ kɨ gɨde tɨ, ɔdɨ ta kɨbɨ lə Jəju par ə, ta naa tɨ no̰o̰, məsɨ gangɨ rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Loe tɨ no̰o̰ Jəju dəjɨ ə nə: «Na̰ ə ɔdɨ-m ə?» Nɨngə dɨje pətɨ naji-e tɨ əi nə n-ɔdi-e al. NGa ə Pɨyər əl-e ə nə: «Ɓaɓe, e dɨje kɨ rɔsi gɨdi, mborəi-ni kɨ yo je kɨ ne je kɨn ə ɔdi-ni.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nə Jəju ə nə: «Dəw madɨ ɔdɨ-m, m-gər kadɨ tɔgɨ tḛḛ rɔm tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lokɨ dəne oo kadɨ nḛ kɨ n-ra kɨn Jəju gər ɓa, dadɨ par par, osɨ nja Jəju tɨ. Nɨngə ɔr go nḛ kɨ ra ə adɨ n-ɔdɨ-n Jəju kɨn ta kəm dɨje tɨ pətɨ. Taa, ɔr-de go kɨngə kɨ ɨngə rɔ nga ta ji naa tɨ no̰o̰ par kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ə Jəju əl-e ə nə: «NGonm, kadɨ-me ləi aji. Aw kɨ lapɨya.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lokɨ Jəju a əl ta ba ɓəy nɨngə, dəw kare ḭ ɓe lə nje kun dɔ kəy kaw-naa lə Jɨpɨ je re. Re əl Jayrusɨ ə nə: «NGoni oy, ɨtapɨ NJe ndo dɨje al ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nə Jəju kɨ oo dɔ ta kɨn əl Jayrusɨ ə nə: «Adɨ rai ɓəl al, adɨ mei par, ə a ajɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lokɨ rəi tḛḛi me kəy tɨ, Jəju ɨyə̰ ta rəbɨ adɨ dəw ur kəy go ngon tɨ al. Adɨ Pɨyər nɨm, Ja̰ nɨm, Jakɨ nɨm, baw ngon əi kɨ ko̰ ngon nɨm tɔ par ə uri sie kəy go ngon tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dɨje pətɨ no̰i je, ndɨngəi rɔde je mbata tɨ lə ngon, nə Jəju əl-de ə nə: «Ɨno̰i al, ngon oy al, nə to ɓi kare.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɓa ɨbəi Jəju kogii, mbata gəri kadɨ ngon oy. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nə Jəju uwə ji ngon, ɓa əl-e ta kɨ ndune kɨ boy ə nə: «NGonm, ḭ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lo kɨn tɨ, ngon tɔsɨ ndəl, adɨ ḭ taa ta ji naa tɨ no̰o̰. Ɓa Jəju dəjɨ-de kadɨ adi-e ne uso. ");
INSERT INTO bjvNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nḛ kɨn ra ɓəl njé koje je ngay. Nə Jəju adɨ-de ndune kadɨ əli tae dəw madɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jəju ɓar njé ndo je kɨ dɔgɨ gɨde joo, adɨ-de tɔgɨ, kɨ ko̰ɓe dɔ ndɨl je tɨ kɨ majal pətɨ, taa kadɨ ajii njé mo̰y je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jəju ɨlə-de kadɨ ɨləi mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə, taa kadɨ adi rɔ nga̰ dɨje tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nɨngə əl-de ə nə: «Uni nḛ madɨ mbata dɔ rəbɨ al nɨm, uni kagɨ tɔsɨ al nɨm, uni ɓɔl al nɨm, uni mapa al nɨm, uni la al nɨm, taa kadɨ awi kɨ kɨbɨ rɔsi joo al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ə me kəy kɨ ra kɨ uri tɨ ɓa, a ɨsi tɨtɨ no̰o̰ bɨtɨ kadɨ awii. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A kɨn ə re, me ɓe tɨ, dɨje mbati kuwəi səsi kɨ rɔde tɨ ɓa, lokɨ ɨsɨ tḛḛi me ɓe tɨ kɨn kɨ taga ə, ɨndəi bu kɨ njasi tɨ kɔ, mba kadɨ to tə nḛ ndəjɨ ndude.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","*NJé ndo je ɨləi dɔde awi kɨ ɓe ɓe, ɨləi mbḛ Poy Ta kɨ Majɨ, taa aji njé mo̰y je kɨ lo lo tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lokɨ *Erodɨ kɨ e nje ko̰ɓe dɔnangɨ tɨ kɨ Galile, oo poy nḛ je kɨ ɨsɨ rai nḛ kɨn ɓa, ta ndɔje dɔ Jəju tɨ, tadɔ dɨje madɨ əli əi nə: «E Ja̰ Batɨsɨ ə ḭ taa dan njé koy je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","NJé kɨ nungɨ əli əi nə: «E Eli kɨ nje kəl ta kɨ ta Luwə tɨ ə tḛḛ.» NJé je kɨ na̰ je ɓəy əli əi nə: «E njé kəl ta je kɨ ta Luwə tɨ kɨ kəte je kɨn ə kɨ kare ḭ dan njé koy je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lo kɨn tɨ Erodɨ əl ə nə: «Ja̰, e mi wa ə ndɔ kɨ madɨ gangi dɔe, nga e na ɓəy ə m-ɨsɨ m-o ta je kɨ be kɨn dɔe tɨ wa ka m-gər al.» Ɓa sangɨ kadɨ n-oo Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lokɨ njé kaw kɨlə je təli no̰o̰ rəi ɓa, ɔri Jəju poy nḛ je kɨ rai adi-e oo. Ə Jəju ɔr-de, aw səde kadɨ ɓe bo tɨ kɨ ɓari-e Bətɨsayda. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nə kosɨ je gəri gode, adɨ awi gode tɨ. Jəju uwə-de kɨ rɔne tɨ, əl-de ta kɨ dɔ ko̰ɓe tɨ lə Luwə, taa ajɨ njé je kɨ sangi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nɨngə lokɨ kadɨ aw tə ur, njé ndo je kɨ dɔgɨ gɨde e joo, rəi rɔ Jəju tɨ əli-e əi nə: «Ɨtuwə kosɨ dɨje kam adɨ awi kɨ ngan ɓe je tɨ, kɨ lo ndɔr je tɨ, sangi lo to je kɨ nḛ kuso je, tadɔ lo kɨ j-ai tɨ ne kɨn, e lo kɨ dɨje gotoi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nə Jəju əl-de ə nə: «Səi je wa adi-de nḛ usoi.» Ə njé ndo je əli əi nə: «J-aw kɨ mapa mi ə kanjɨ joo wa be tɔ par, adɨ re e be al wa nɨngə kadɨ je wa j-aw jɨ ndogɨ mapa mbata tɨ lə kosɨ dɨje kɨn pətɨ wa ta.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dɨngəm je asi dɨbɨ mi loe tɨ no̰o̰. Nə Jəju əl njé ndo je ə nə: «Adi-de ɨsi nangɨ, uwəi-naa asɨ kutɨ mi, kutɨ mi be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","*NJé ndo je rai təkɨ Jəju əl-n-de, adɨ adi-de ɨsi nangɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ə Jəju ɔy mapa kɨ mi kɨ kanjɨ kɨ joo ka kɨn, ɓa un kəmne kɨ taa, əl ta kɨ Luwə mba kadɨ njangɨ dɔ nḛ kuso kɨn. Go tɨ, Jəju uwə mapa je ka kɨn gangɨ naa tɨ, ə təl-n adɨ njé ndo je kadɨ ləbi kosɨ dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dɨje pətɨ usoi nḛ ndani majɨ. Nɨngə, njé ndo je ɔyi gɨndɨ mapa je kɨ nay, kare dɔgɨ gɨde e joo ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","NDɔ kare Jəju ɨsɨ əl ta kɨ Luwə gɨdɨ lo tɨ gogɨ, njé ndo je lie əi sie naa tɨ, ə Jəju dəjɨ-de ə nə: «Kosɨ je ɨsɨ əli ta kɨ dɔm tɨ təkɨ mi na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ə ɨləi-e tɨ əi nə: «Dɨje madɨ əli əi nə ḭ Ja̰ Batɨsɨ, njé kɨ nungɨ əi nə ḭ nje kəl ta kɨ ta Luwə tɨ Eli; njé kɨ rangɨ ɓəy əi nə e njé kəl ta kɨ ta Luwə tɨ kɨ kəte je kɨn ə e kɨ kare dande tɨ ə ḭ dan njé koy je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nɨngə Jəju əl-de ə nə: «NGa səi wa kɨ dɔsi, əli əi nə mi na̰ ə?» Ɓa Pɨyər ɨle tɨ ə nə: «Ḭ Kɨrɨsɨ kɨ Luwə mbəte.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jəju ndəjɨ njé ndo je kɨ tɔgɨne ngay kadɨ əli ta kɨn dəw madɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jəju ɨlə dɔ ta tɨ kɨn ə nə: «Sɔbɨ kadɨ mi *NGon dəw m-a m-ɨngə ko̰ ngay. *NGatɔgɨ je lə *Jɨpɨ je, kɨ kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je a mbati-mi. Dɨje a tɔli-mi, nə ndɔ kɨ ko̰ mɨtə lə ndɔ koym ɓa, m-a m-tḛḛ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Go tɨ, Jəju əl dɨje pətɨ ə nə: «Re dəw madɨ ndɨgɨ njɨyə gom tɨ nɨngə, kadɨ oo rɔne tə nḛ madɨ al, kadɨ ndɔ je kare kare pətɨ, e wa un kagɨ-dəsɨ koy ləne, ə re un gom. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Təkɨ rɔjetɨ, dəw kɨ ge kajɨ rɔne ne wa dɔnangɨ tɨ ne a tḭ ta rɔne. Nə dəw kɨ tḭ ta rɔne kɨ mbata ləm, a ajɨ rɔne tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kɨn ə re dəw ɨngə nḛ majɨ je kɨ dɔnangɨ tɨ ne pətɨ tɨgə, nə kadɨ e wa tḭ ta rɔne, ə se tujɨ rɔne ə, maje to ra be ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Təkɨ rɔjetɨ, re rɔ dəw madɨ sɔl-e kɨ mbata ləm, ə se kɨ mbata ta ləm nɨngə, mi NGon dəw ka, m-a m-ra rɔsɔl dɔe tɨ tɔ, ndɔe tɨ kɨ m-a m-re-n me kɔsɨ-gon tɨ ləm, kɨ me kɔsɨ-gon tɨ lə Bawm, kɨ me kɔsɨ-gon tɨ lə malayka je kɨ ayi njay.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Təkɨ rɔjetɨ, adɨ m-əl səsi: dɨje madɨ dansi tɨ ne a oyi al ɓəy ə, a oi ko̰ɓe lə Luwə kɨ kəmde. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","NDɔ jijoo go ta je tɨ kɨn nɨngə, Jəju ɔr Pɨyər nɨm, Ja̰ nɨm, taa Jakɨ nɨm tɔ, ə al aw səde dɔ mbal tɨ kadɨ n-əli ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lokɨ Jəju ɨsɨ əl ta kɨ Luwə nɨngə, ta kəme mbəl, taa kɨbɨ lie təl nda bal bal tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nɨngə loe tɨ no̰o̰, dɨngəm je joo a əli sie ta. Dɨngəm je ka kɨn e *Mojɨ əi kɨ Eli. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tḛḛi me tɔ ɓa tɨ, a əli sie ta ɔjɨ dɔ kaw kɨ a aw Jorijaləm tɨ kadɨ oy, tɔl-n ta kɨlə ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pɨyər əi kɨ madɨne je, ɓi tɔl-de makɨ. Ə lokɨ ə nə n-ndəli nɨngə, ooi kunjɨ Jəju kɨ dɨngəm je kɨ joo kɨ ai sie. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lokɨ dɨngəm je ka kɨn ɨyə̰i Jəju ə ɨsɨ awi ɓa, Pɨyər əl Jəju ə nə: «Ɓaɓe, kɨn ə j-ɨsi lo kɨn tɨ ne be par ə majɨ ngay. J-a ra kəy-lo mɨtə: kare e ya̰i, kare e ya̰ Mojɨ, ə kɨ kare e ya̰ Eli tɔ.» Pɨyər gər me ta kɨ ɨsɨ əl kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ə lokɨ a əl ta tə kəl ba ɓəy nɨngə, kɨl ndi ḭ re səbɨ dɔde lɨtɨ. Lokɨ kɨl ndi ɨsɨ səbɨ dɔde kɨn, ɓəl tɔl njé ndo je. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lo kɨn tɨ, ndu ta madɨ tḛḛ me kɨl ndi tɨ ə nə: «E kam e NGonm, e ə e dəw kɨ m-kɔte, ə oi ta lie.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Go ndu ta tɨ kɨn, Jəju təl nay kɨ karne ba, dəw oo dəw madɨ kɨ rangɨ kade tɨ al. *NJé ndo je ngəmi tade, ta kare ka əli dəw madɨ ndɔe tɨ no̰o̰ dɔ nḛ je tɨ kɨ ooi kɨn, al. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lo ti go tɨ, Jəju əi kɨ njé ndo je ləne kɨ mɨtə ḭḭ dɔ mbal tɨ ɨsɨ rəi kɨ nangɨ ɓa, kosɨ dɨje ngay tɨləi kəme. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nɨngə dan kosɨ dɨje tɨ ka kɨn, dɨngəm kare un ndune kɨ taa ə nə: «NJe ndo dɨje, m-no̰ kɨ dɔi tɨ kadɨ ɨgo̰ ngonm kɨn adɨ-m, tadɔ e kɨ karne ba jim tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dɔkagɨlo je madɨ ɓa, ndɨl kɨ majal a uwə, ra-e adɨ ur kɔl, ə yəke kɨ tɔgɨne, adɨ kulum tae ɨbə jugɨ jugɨ. A ade ko̰ ratata, tə nḛ kɨ a ɨyḛ al be ɓəy taa təl ɨyḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Be ə, m-dəjɨ njé ndo je ləi kadɨ tuwəi ndɨl kɨ majal kɨn dɔe tɨ kɔ, nə asi kadɨ tuwəi-e al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lo kɨn tɨ, Jəju un ta əl ə nə: «Səi dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨ səi njé me nga̰ je, səi njé ra nḛ kɨ majal, kadɨ tə m-ɨsɨ səsi dɔkagɨlo ban ɓəy taa ə? Kadɨ m-a m-ɔsɨ gɨnsi dɔkagɨlo ban ɓəy taa ə? Ɨre kɨ ngoni rɔm tɨ ne.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lokɨ ngon ɨsɨ re ɓasi kɨ rɔ Jəju tɨ nɨngə, ndɨl kɨ majal ka kɨn un-e, ɔte nangɨ, yəke kɨ tɔgɨne, nə Jəju ndangɨ ndɨl kɨ majal ade tḛḛ rɔ ngon tɨ, adɨ ngon ɨngə rɔ nga, ɓa təl sie adɨ bawe. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lo kɨn tɨ, dɨje pətɨ, ta ndɔjɨ-de dɔ tɔgɨ Luwə tɨ kɨ ətɨ ɓəl kɨn. Lokɨ nḛ je pətɨ kɨ Jəju ra, ətɨ dɨje pətɨ ɓəl, Jəju əl njé ndo je ləne ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Oi ta kɨ m-aw tə m-əl səsi kɨn majɨ: A ɨləi-mi *NGon dəw ji dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nə njé ndo je gəri me ta kɨn al. Ta kɨn to kɨ ndəme ba mba kadɨ gəri me al. Nɨngə ɓəli kadɨ dəji ta Jəju dɔ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","*NJé ndo je ɨləi ngɨrə naji-naa ta tɨ kadɨ n-gəri se na̰ dande tɨ ə e kɨ bo wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jəju gər ta kɨ mede tɨ, adɨ un ngon kɨ du, ur-e ade a gədɨne tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nɨngə əl-de ə nə: «Re dəw madɨ uwə ngon kɨn kɨ rɔne tɨ me tɔm tɨ ə, e mi wa ə dəwe kɨn uwə-m kɨ rɔne tɨ. Nɨngə, dəw kɨ uwə-m kɨ rɔne tɨ, e nje kɨlə-m ə uwe kɨ rɔne tɨ.» Təkɨ rɔjetɨ, dəw kɨ e ə e kɨ du ngay dansi tɨ, e dəwe kɨn ə e kɨ bo dansi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ja̰ un ta əl Jəju ə nə: «NJe ndo dɨje, j-o dəw madɨ kɨ a tuwə ndɨl je kɨ majal me tɔi tɨ, ə jɨ ndɨgɨ kadɨ j-ɔge dɔ ra nḛ kɨn, tadɔ e njɨyə səje goi tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nə Jəju ɨle tɨ ə nə: «Ɔgi-e dɔ al, tadɔ dəw kɨ ɔsɨ səsi ta al, e dəw ləsi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lokɨ dɔkagɨlo nay ɓasi kadɨ a uni Jəju awi sie dɔra̰ tɨ, Jəju ɨlə ndune kadɨ gar n-aw Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Be ə, ɨlə njé kaw kɨlə je no̰ne tɨ kəte. *NJé kaw kɨlə je awi, uri me ngon ɓe tɨ kɨ *Samari mba kadɨ ɨndəi dɔ re lə Jəju naa tɨ kəte. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nə dɨje kɨ ngon ɓe tɨ ka kɨn mbati kuwə Jəju kɨ rɔde tɨ tadɔ ɨsɨ aw kɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lokɨ njé ndo je lie, Jakɨ əi kɨ Ja̰ ooi ta kɨn ɓa, əli Jəju ə nə: «Ɓaɓe, ɨndɨgɨ kadɨ jɨ dəjɨ por j-adɨ ḭ dɔra̰ tɨ, osɨ dɔde tɨ, ro-de kɔ a?» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ə Jəju təl kəmne, kɔl səde. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɓa uni rəbɨ, awi ngon ɓe tɨ kɨ rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lokɨ əi dɔ rəbɨ tɨ, dəw madɨ əl Jəju ə nə: «M-a m-un goi lo je pətɨ kɨ a aw tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ə Jəju əl-e ə nə: «NJa̰ je ai kɨ ɓe tode, ə yəl je ai kɨ kəyde tɔ, nə *mi NGon dəw m-aw kɨ lo kɨ kadɨ m-ɨlə dɔm tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Go tɨ, Jəju əl dəw kɨ rangɨ ə nə: «Un gom.» Nɨngə dəw ka kɨn əl-e ə nə: «Ɓaɓe, adɨ-m ta rəbɨ adɨ m-aw m-dɨbɨ bawm ɓəy taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nə Jəju əl-e ə nə: «Ɨyə̰ njé koy je adɨ dɨbi njé koy je ləde, nə ḭ aw ɨlə mbḛ ko̰ɓe lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","E kɨ rangɨ ɓəy əl ə nə: «Ɓaɓe, m-a m-un goi, nə m-dəji kadɨ adɨ-m ta rəbɨ adɨ m-aw m-əl ta kɨ kadɨ j-ɨyə̰-n-naa kɨ njé kɨ me kəy tɨ ləm ɓəy taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ə Jəju əl-e ə nə: «Dəw kɨ uwə dɔ kɔsɨ mangɨ, ə təl ɨlə rətɨ gogɨ ɓa, dəwe kɨn ko̰ɓe lə Luwə e kɨ ta tɔe al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Go ne je tɨ kɨn, Jəju mbətɨ njé ndo je kɨ rangɨ kutɨ sɨri gɨde joo, ɓa ɨlə-de joo joo kɨ ɓe bo je kɨ lo je kɨ dangɨ dangɨ kɨ ɔjɨ kadɨ re e wa a aw tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nɨngə əl-de ə nə: «Ko kɨ asɨ kɨjə, dɨle e ngay, nə njé kɨje je əi ngay al. Ə əli ta kɨ Ɓa nje ko, adɨ ɨlə kɨ njé ra ko je me ko tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɨngə kɨ ɓasɨne kɨn, osi dɔ rəbɨ tɨ awi! M-ɨlə səsi tə ngan batɨ je dan jagɨm je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Uni la al nɨm, uni ɓɔl al nɨm, uni sa njasi al nɨm tɔ. Taa ai rəbə ta lapɨya kɨ ra tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kɨn ə awi kadɨ uri me kəy tɨ madɨ ɓa, nḛ kɨ dɔsa̰y, əli əi nə: “Lapɨya kɨ dɔ me kəy tɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nɨngə kɨn ə re dəw kɨ nje ndɨgɨ lapɨya ɨsɨ me kəye tɨ kɨn no̰o̰ ɓa, lapɨya ləsi a aw kɨ dɔe tɨ. A re dəw goto ɓa, lapɨya ləsi a təl kɨ rɔsi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ɨsi me kəy tɨ kɨ uwə səsi kɨ rɔne tɨ kɨn no̰o̰, nḛ kuso kɨ adi səsi ə usoi, man kɨ adi səsi ə a̰yḭ-naa. Tadɔ sɔbɨ kadɨ nje ra kɨlə ɨngə nḛ kɨgə go ji ləne, ji dɨje tɨ kɨ ra kɨlə dande tɨ. Ɨɓii kəy joo al. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kɨn ə re uri me ɓe tɨ, ə ɓe uwə səsi kɨ rɔne tɨ ɓa, nḛ kɨ adi səsi ə usoi par. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Re dɨje kɨ mo̰y ra-de əi me ɓe tɨ kɨn no̰o̰ ə, aji-de. Ɓa əli dɨje kɨ me ɓee tɨ əi nə: “Ko̰ɓe lə Luwə e ɓasi kɨ rɔsi tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A re uri me ɓe tɨ, ə dɨje kɨ me ɓee tɨ kɨn uwəi səsi kɨ rɔde tɨ al ɓa, ɨtḛḛi kɨ taga ta mbalo tɨ, ə əli əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bu kɨ me ɓe tɨ ləsi kɨ nay gɨn sa njaje tɨ ka, j-ɨndə kɔ gogɨ j-adɨ səsi. Nɨngə kadɨ ɨgəri təkɨ ko̰ɓe lə Luwə e ɓasi.” ");
INSERT INTO bjvNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ə adɨ m-əl səsi m-adɨ ɨgəri təkɨ ndɔ gangɨ ta tɨ ə, ta kɨ gangɨ kɨ dɔ ɓee tɨ kɨn a ɨtə ya̰ Sodom ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Kəm-to-ndoo e ləsi, səi dɨje kɨ Korajḛ! Kəm-to-ndoo e ləsi səi dɨje kɨ Bətɨsayda! Nḛ kɔjɨ je kɨ ətɨ ɓəl, kɨ Luwə ɔjɨ dansi tɨ kɨn, re nḛ je kɨn rai nḛ me ɓe ɓo Tɨr tɨ kɨ ɓe bo Sɨdo̰ tɨ be ə, re dɨje kɨ me tɨ a ɨyə̰i rəbɨ nḛ rade je kɨ majal mari nu. Re a ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ, kɨ go rəbɨ kɨlə kɨbɨ kuwə ndoo rɔ tɨ, kɨsɨ-n bu por tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E be ə, kadɨ ɨgəri təkɨ, dɔkagɨlo gangɨ ta tɨ ə, ta kɨ gangɨ kɨ dɔ Tɨr tɨ kɨ Sɨdo̰, ya̰si a nga̰ ɨte. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","NGa nɨngə ḭ Kapərnayɨm, o kadɨ a un dɔi taa bɨtɨ kadɨ ɔdɨ ra̰, nə Luwə a təl səi bɨtɨ kaw səi koo.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jəju təl əl njé ndo je ləne ɓəy ə nə: «Dəw kɨ oo ta ləsi, e mi ə dəwe kɨn oo ta ləm. Ə dəw kɨ ɔsɨ səsi ngərəngɨ ɓa, e mi ə dəwe kɨn ɔsɨ-m ngərəngɨ. Nɨngə dəw kɨ ɔsɨ-m ngərəngɨ ɓa, e nje kɨlə-m tɔ ə ɔse ngərəngɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","*NJé ndo je kɨ kutɨ sɨri gɨde joo kɨ Jəju ɨlə-de, təli lo kɨlə tɨ kɨ rɔnəl, nɨngə əli Jəju əi nə: «Ɓaɓe, ndɨl je kɨ majal ka, lo kɨ jɨ ɓa tɔi ɓa, ɨləi dɔde gɨn tɔgɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jəju əl-de ə nə: «M-o *Sata̰ ḭ dɔra̰ tɨ osɨ kɨ dɔnangɨ tɨ tə təl ndi be. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nɨngə m-adɨ səsi tɔgɨ kadɨ ɨnjɨyəi dɔ li je tɨ, dɔ ni je tɨ, kɨ dɔ tɔgɨ je tɨ pətɨ kɨ nje ba̰ aw-n. Nḛ madɨ kare kɨ kadɨ a ra səsi majal goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","NGa nɨngə kadɨ ɨrai rɔnəl mbata kɨlə kɨ ndɨl je kɨ majal ɨləi dɔde gɨn tɔgɨsi tɨ kɨn al, nə kadɨ ɨrai rɔnəl mbata tɔsi kɨ e kɨ ndangɨ me dɔra̰ tɨ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dɔkagɨloe tɨ no̰o̰, NDɨl Luwə ra adɨ rɔnəl rosɨ me Jəju, ə Jəju əl ə nə: «Bai, kɨ ḭ Ɓa dɔra̰ kɨ dɔnangɨ, m-ɨlə tɔjɨ dɔi tɨ, təkɨ ɨɓɔyɔ nḛ je kɨn njé tər je, kɨ njé nḛ gər je, ə ɨtḛḛ kɨ dɔe adɨ ngan je kɨ du gəri. Oyo, Bai, e ndɨgɨ ləi kadɨ nḛ kɨn ra nḛ be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ɓa, Jəju əl dɨje kɨ ai no̰o̰ ə nə: «Bai, adɨ-m nḛ je pətɨ, nɨngə dəw kare kɨ gər-m, mi NGon, goto, e Bai kɨ karne ba par, taa dəw kare kɨ gər Bai ka goto tɔ, e mi NGon kɨ karm ba par, nɨngə e dɨje kɨ mi wa ə m-ndɨgɨ kadɨ m-adɨ gəri-mi par tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Go tɨ, Jəju təl kəmne kɨ dɔ njé ndo je tɨ əl-de kɨ karde ba ə nə: «Səi njé majɨ-kur mbata nḛ kɨ kəmsi oo kɨn! ");
INSERT INTO bjvNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","*NJé kəl ta je kɨ ta Luwə tɨ ngay kɨ ngar je ngay ndɨgi kadɨ kəmde oo nḛ kɨ səi je, kəmsi oo kɨn, nə asi koo al, ndɨgi kadɨ mbide oo dɔ ta kɨ səi je, mbisi oo kɨn, nə asi koo al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","NJe ndo ndu-kun kare ɔsɨ nangɨ ḭ taa, nɨngə dəjɨ ta kare Jəju tə ta kuwə-naa kɨ ta ə nə: «NJe ndo dɨje, e ri ə sɔbɨ kadɨ m-ra kadɨ tə m-ɨngə-n kajɨ kɨ bɨtɨ kɨ no̰ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ə Jəju əl-e ə nə: «E ta ri ə ndangi me ndu-kun tɨ? Ə go gər-e ləi e ban?» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɓa nje ndo ndu-kun ka kɨn ɨlə Jəju tɨ ə nə: «A ɨndɨgɨ Ɓaɓe Luwə ləi kɨ nga̰mei ba pətɨ, kɨ ndɨli ba pətɨ, kɨ tɔgi ba pətɨ, kɨ mər ta ləi ba pətɨ. Nɨngə a ndɨgɨ dəw madi tə darɔi ḭ wa be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ə Jəju əl-e ə nə: «Ta kɨ m-dəji, ɨlə-m tɨ majɨ kɨ dum. Ə ɨra be, ɓa a ɨngə kajɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","NJe ndo ndu-kun sangɨ kadɨ n-tɔjɨ təkɨ ne dəw kɨ dana, adɨ təl dəjɨ Jəju ə nə: «Na̰ ə e dəw madɨm ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ə Jəju əl-e ə nə: «Dɨngəm kare ḭ Jorijaləm ɨsɨ aw Jəriko, ɓa osɨ ji kaya je tɨ kɨ njé gangɨ rəbɨ, adɨ taai nḛ je lie pətɨ jie tɨ, tɨndəi-e adɨ to ta koy tɨ, nɨngə ɨyə̰i-e ə ɔti awi. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Go tɨ ɓa, nje kɨjə nḛ məsɨ kadɨ-kare ḭ no̰o̰ re tḛḛ dɔe tɨ, nə lokɨ oo-e, gangɨ sa̰y aw lo ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Go tɨ, dəw kɨ gɨn kojɨ tɨ lə *Ləbi kare ḭ no̰o̰ re tɔ, nə lokɨ oo dɨngəm ka kɨn ɓa, gangɨ sa̰y aw lo ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Go tɨ nɨngə, dəw kɨ *Samari tɨ kare kɨ ɨsɨ aw mba ḭ no̰o̰ re tḛḛ dɔ dɨngəm tɨ ka kɨn. Lokɨ oo-e, oo kəm-to-ndoo lie kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Be ə, re rɔe tɨ, ur yɨbɨ kasɨ nju ta do tɨ, dɔɔ-n, nɨngə un-e ɨnde dɔ koro tɨ ləne, aw sie lo to mba je tɨ, ɨndə kəmne goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lo ti go tɨ, dɨngəm kɨ Samari tɨ ka kɨn ɔr la kɨ asɨ ra kɨlə ndɔ joo adɨ nje kɨndə kəmne go kəy mba je tɨ, nɨngə əl-e dɔ tɨ ə nə: “Ɨndə kəmi goe tɨ majɨ, a re nḛ kɨ ɨndə-n kəmi goe tɨ, al dɔ e kɨ madi kɨn ɓa, ndɔ təlm ə, mi wa m-a m-ɨgə-i.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nɨngə Jəju dəje ta dɔ tɨ ə nə: «Dan dɨje tɨ kɨ mɨtə kɨn, e kɨ ra ə e madɨ dɨngəm kɨ kaya je kɨ njé gangɨ rəbɨ gangi-e kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɓa, nje ndo ndu-kun ə nə: «E e kɨ oo kəm-to-ndoo lie kɨn.» NGa ə Jəju əl-e ə nə: «Re e be nɨngə, ḭ ka kadɨ aw, ə ɨra be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jəju əi kɨ njé ndo je ləne ḭ dɔ rəbɨ tɨ rəi tḛḛi ngon ɓe tɨ kare be nɨngə, dəne madɨ kɨ tɔe nə Martɨ uwə Jəju rɔne tɨ me kəy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martɨ aw kɨ ngokone kɨ dəne kɨ tɔe nə Mari no̰o̰. Ə ngoko̰e ka kɨn re ɨsɨ nangɨ nja Ɓaɓe Jəju tɨ, ɨsɨ oo dɔ ta kɨ Jəju ɨsɨ əl. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nə Martɨ a ta ngan kɨlə je tɨ kɨ njae ɔdɨ nangɨ al, aw yo je kɨ ne je. Nɨngə tḛḛ patɨ, re əl Jəju ə nə: «Ɓaɓe, ra ban ə ngokom Mari ɨyə̰-m adɨ m-a ta kɨlə je tɨ kɨ karm ba be ka usi al par ə? Əl-e adɨ re ra səm kɨlə je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ə Ɓaɓe əl Martɨ ə nə: «Martɨ, Martɨ, mei osɨ nangɨ al, adɨ aw kɨ yo je kɨ ne je mbata nḛ je ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nə nḛ kɨ sotɨ e kare ba. Nɨngə Mari un nḛ kɨ majɨ ɨtə nḛ je pətɨ. E nḛ kɨ dəw a taa jie tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","NDɔ kare Jəju ɨsɨ əl ta kɨ Luwə lo madɨ tɨ. Lokɨ əl ta kɨ Luwə gɨne gangɨ nɨngə, nje ndo lie kare əl-e ə nə: «Ɓaɓe, ɨndo-je kəl ta kɨ Luwə təkɨ Ja̰ Batɨsɨ ndo-n njé ndo je ləne kɨn be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ə Jəju əl-de ə nə: «Lokɨ ɨsɨ əli ta kɨ Luwə nɨngə, kadɨ əli əi nə: “Bawje, Kadɨ dəw kɨ ra gər tɔi təkɨ ḭ Luwə, Kadɨ ko̰ɓe ləi re. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Adɨ-je nḛ kusoje kɨ asɨ taje kɨ ndɔ je ndɔ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ɨyə̰ go majal je ləje kɔ, tadɔ je wa ka, J-ɨyə̰ go majal lə dɨje pətɨ kɨ rai səje majal kɔ tɔ. Ɨyə̰-je adɨ j-osɨ me nḛ na tɨ al”.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɓa Jəju təl əl-de ɓəy ə nə: «Kɨn ə, dəw kare dansi tɨ je be, aw kɨ madɨne no̰o̰, ə ḭ dan lo tɨ aw ɨndə ta kəy dɔe tɨ ə nə: “Madɨm, ɨtunə-m mapa mɨtə, ");
INSERT INTO bjvNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mbata madɨm kare ḭ mba tɨ re tḛḛ dɔm tɨ, nə nḛ kɨ kadɨ m-ra-e-n mba goto.” ");
INSERT INTO bjvNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ə re made ka kɨn to kɨ kəy no̰o̰ ə nə: “Ɨtapɨ-m al, ta kəy e kɨ kutɨ ngata, nɨngə je kɨ nganm je jɨ to nangɨ tɔ, ɓɨ lo kadɨ m-a m-ḭ taa m-adi mapa goto.” ");
INSERT INTO bjvNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","M-əl səsi kadɨ ɨgəri, kɨn ə re ḭ taa ade mapa kɨn mbata ke madɨ-naa ləde al ka, a ḭ kadɨ ade nḛ je pətɨ kɨ ge, mbata ta kəy kɨ a ɨndə kɨ naa tɨ naa tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɨngə mi, m-əl səsi: Ɨdəji, ə a adi səsi, ɨsangi ə a ɨngəi, ɨndəi ta kəy ə a tḛḛi adi səsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tadɔ dəw kɨ dəjɨ ə a adi-e, dəw kɨ sangɨ ə a ɨngə, dəw kɨ ɨndə ta kəy ə a tḛḛi adi-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Baw ngon kɨ ra dansi tɨ ə ngone dəje kanjɨ, nɨngə a un li yo taa ade ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ə se ngone dəje kaw, nɨngə a un ni yo taa ade ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A kɨn ə səi kɨ səi dɨje kɨ kɨlə rasi majal kɨn mɨndɨ ə ɨgəri rəbɨ kadɨ nḛ kɨ majɨ ngansi je nɨngə, ra ban be ə, Bawje kɨ ɨsɨ dɔra̰ tɨ taa kɨn taa, a adɨ NDɨlne dɨje kɨ dəji-e al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","NDɔ kare Jəju tuwə ndɨl kɨ majal dɔ dɨngəm kare tɨ kɨ ndɨl ka kɨn ra-e adɨ əl ta al. Lokɨ ndɨl kɨ majal tḛḛ ɓa, dɨngəm kɨ kəte əl ta al ka kɨn, təl əl ta, adɨ ətɨ kosɨ dɨje ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nɨngə dɨje madɨ əli əi nə: «E kɨ tɔgɨ lə Bəljəbul kɨ e ngar lə ndɨl je kɨ majal, ə ɨsɨ tuwə-n ndɨl je kɨ majal.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ə njé kɨ nungɨ, kadɨ nai-e-n ɓa, dəji-e kadɨ ra nḛ kɔjɨ madɨ kare kɨ ḭ dɔra̰ tɨ adɨ-de n-ooi. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nə Jəju gər mər ta ləde ɓətɨ, adɨ əl-de ə nə: «Kɨn ə, dɨje kɨ me ɓeko̰ tɨ kɨ kare ba, təli dɔ-naa tɨ rɔi-naa ə, ɓe ko̰e kɨn a tujɨ, nɨngə kəy je a budi dɔ-naa tɨ mur mur tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kɨn ə re *Sata̰ ə wa adɨ dɨje lie təli dɔ-naa tɨ rɔi-naa ə, lo kadɨ ko̰ɓe lie a aw kɨ kəte goto. M-əl be mbata əli əi nə e kɨ tɔgɨ lə Bəljəbul kɨ e ngar lə ndɨl je kɨ majal ə m-ɨsɨ m-tuwə-n ndɨl je kɨ majal. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kɨn ə re e kɨ tɔgɨ lə Bəljəbul ə m-tuwə-n ndɨl je kɨ majal ə, dɨje kɨ gosi tɨ tuwəi-de kɨ tɔgɨ lə na̰ ə? Dɨje kɨ gosi tɨ wa a tɔji kadɨ ta ləsi e ta kɨ go tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A re e kɨ tɔgɨ lə Luwə ə m-ɨsɨ m-tuwə-n ndɨl je kɨ majal tɔ nɨngə, tɔjɨ kadɨ ko̰ɓe lə Luwə re tḛḛ rɔsi tɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kɨn ə dəw kɨ tɔge e ngay, kɨ aw kɨ nḛ rɔ je, ngəm ta kəy ləne ə, nḛ kare kɨ a ɔdɨ kadɨ nḛ kɨngə lie goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A re dəw madɨ kɨ tɔge ɨte re ur goe tɨ ə təte rɔ ə, a ɔy nḛ rɔ je lie kɨ ɨndə mene dɔ tɨ kɨn pətɨ, taa a sane nḛ kɨngə je lie tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nɨngə kadɨ ɨgəri, dəw kɨ e səm al, e nje kɔsɨ-m ta, taa dəw kɨ kaw səm nḛ kɨ naa tɨ al, e nje tɨndə tḭ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Lokɨ ndɨl kɨ majal tḛḛ me dəw tɨ, aw ɨlə kɨ dɨlə lo kɨ tutɨ mba kadɨ n-ɨngə lo kɨsɨ kɨ rangɨ kadɨ n-ɔr kə̰ə̰ tɨ, nə ɨngə al ɓa, əl ə nə: “M-a m-təl kadɨ m-aw lo kɨsɨ-m tɨ kɨ kəte m-ɨsɨ tɨ ə m-tḛḛ ka kɨn gogɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lokɨ təl aw gogɨ nɨngə, ɨngə me lo ka kɨn, utəi, rai adɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","NGa ə, təl aw, ɔy ndɨl je kɨ majal ɨtəi-e e wa ɓəy sɨri, ɓa rəi uri me dəw tɨ ka kɨn ɨsi. Lo kɨn tɨ, ji kɨsɨ dəw kɨn kɨ dɔe taa a majal ngay ɨtə e kɨ kəte ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lokɨ Jəju a əl ta kɨn ba nɨngə, dəne kare ɨlə ndune dan kosɨ je tɨ ə nə: «Majɨ-kur e dɔ dəne tɨ kɨ nje koji kɨ nje kadi mba.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nə Jəju ɨle tɨ ə nə: «Majɨ-kur ɓa e dɔ dɨje tɨ kɨ njé koo ndu Luwə ə təl rɔde go tɨ kɨn yo taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dɨje uwəi naa mukɨ mukɨ gɨdɨ Jəju tɨ, adɨ Jəju əl-de ə nə: «Dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨn əi dɨje kɨ maji al. Dəji kadɨ tə n-ooi nḛ kɔjɨ madɨ, nə nḛ kɔjɨ madɨ kɨ rangɨ kɨ kadɨ dəw a ra ore-n dɔ nḛ kɔjɨ lə Jonasɨ, goto ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","MBata, təkɨ Jonasɨ e-n nḛ kɔjɨ mbata tɨ lə dɨje kɨ Nɨnɨbɨ tɨ ka kɨn ə, mi NGon dəw m-a mi-n nḛ kɔjɨ mbata lə dɨje kɨ ɓone tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","NDɔ gangɨ ta tɨ ə, ngar kɨ dəne kɨ ḭ gɨn ɓe tɨ, a ḭ taa ta kəm dɨje tɨ kɨ dɔkagɨlo tɨ kɨ ɓone kɨn kadɨ a ɨlə ta dɔde tɨ. MBata, ḭ so̰y dɔnangɨ tɨ nu ə ndɔ kɨ re kadɨ oo gosɨ ta lə Salomo̰. NGa nɨngə, kɨ ɓasɨne kɨn, dəw kɨ ɨtə Salomo̰ sa̰y e ne. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","NDɔ gangɨ ta tɨ ə, dɨje kɨ Nɨnɨbɨ tɨ a ḭ taa ta kəm dɨje tɨ kɨ dɔkagɨlo tɨ kɨ ɓone kɨn kadɨ a ɨləi ta dɔde tɨ. MBata, lokɨ Jonasɨ ɨlə mbḛ Poy Ta kɨ Majɨ, dɨje kɨ Nɨnɨbɨ tɨ ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ. NGa nɨngə, kɨ ɓasɨne kɨn, dəw kɨ ɨtə Jonasɨ sa̰y e ne. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Dəw a ɨndə por lambɨ tɨ kadɨ ɓɔyɔ ə se dəbɨ ngo dɔ tɨ al, nə a ɨndə dɔ nḛ tɨ taa, kadɨ dɨje uri kəy ɓa, ooi lo kɨ kunje. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kəm dəw ə e lambɨ lə darɔe, re kəmi oo lo majɨ ɓa, darɔi ba pətɨ e me kunjɨ tɨ tɔ. A kɨn ə re kəmi oo lo majɨ al nɨngə, darɔi e me tɨl tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ə ɨndə manjɨ rɔi adɨ kunjɨ kɨ aw-n rɔi tɨ təl tɨl al. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kɨn ə re darɔi pətɨ e me kunjɨ tɨ kɨ kanjɨ kadɨ ngon tɨl ndətɨ kade ɓa, darɔi a unjɨ njay njay təkɨ lambɨ a unjɨ-n dɔi tɨ kɨn be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lokɨ Jəju əl ta oy nɨngə, Parɨsɨ kare ɓar-e kadɨ aw uso nḛ ɓe ləne. Be ə, Jəju aw ɨsɨ sie ta nḛ kuso tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lo kɨn tɨ, ta ndɔjɨ Parɨsɨ ka kɨn ngay kadɨ Jəju togɨ jine kəte no̰ nḛ kuso tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nə Jəju əl-e ə nə: «Səi *Parɨsɨ je, kɨ ne kɨn, ɨsɨ ɨtogi gɨdɨ ka man, kɨ gɨdɨ ka kuso nḛ adɨ ay, nə ngur ɓogɨ, kɨ me ndul rosɨ mesi. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Səi dɨje kɨ mbə, Luwə ra gɨdɨ nḛ, ə ra me nḛ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Majɨ kadɨ adi njé ndoo je nḛ kɨ e me ka tɨ, ə nḛ je pətɨ a ayi njay kɨ rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kəm-to-ndoo e ləsi səi Parɨsɨ je. Ɔri nḛ kare dan kɨ dɔgɨ tɨ, me mbi kam je tɨ kɨ ətɨ majɨ, kɨ me mbi kam je tɨ kɨ dangɨ dangɨ kɨ mba ndɨr ta̰y, adi Luwə, nɨngə ɨndəi njasi dɔ nḛ ra kɨ dana tɨ kɨ dɔ ndɨgɨ-naa tɨ lə Luwə. Kɨ rɔjetɨ, e kɨn ə e nḛ je kɨ sɔbɨ kadɨ re a ɨndəi kəmsi go tɨ ɨrai, kɨ kanjɨ kɔr kəm ndəge je. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kəm-to-ndoo e ləsi, səi Parɨsɨ je, mbata ɨgei lo kɨsɨ kɨ kəte no̰ dɨje tɨ gɨn kəy kaw-naa je tɨ, taa ɨgei kadɨ dɨje rai səsi lapɨya lo kɨngə-naa je tɨ lə kosɨ je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kəm-to-ndoo e ləsi səi, mbata ɨtoi tə dɔ ɓadɨ je kɨ nḛ kɨ tɔjɨ kadɨ dəw gər-n-de goto, adɨ dɨje njɨyəi dɔde tɨ kɨ no̰o̰ be par kɨn be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lo kɨn tɨ, nje ndo ndu-kun kare əl Jəju ə nə: «NJe ndo dɨje, me ta tɨ ləi kɨ ɨsɨ əl kɨn, e je tɔ ə ɨsɨ ɨtajɨ-je!» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ə Jəju ɨlə tɨ ə nə: «Oyo, kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je tɔ, tadɔ ɨndəi nḛ kɨ ɔy ngay dɔ dɨje tɨ, nə ngon jisi kɨ ndə̰y be ka uni taa, uwəi səde nḛ kɨ kɔy kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kəm-to-ndoo e ləsi! Ɨndəi ɓadɨ njé kəl ta kɨ ta Luwə tɨ kɨ e bawsi je wa ə tɔli-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lo kɨn tɨ, ɨsɨ tɔji təkɨ ɨndɨgi kɨ bawsi je dɔ kɨlə rade tɨ kɨ rai, mbata əi je əi njé tɔl njé kəl ta kɨ ta Luwə tɨ, nɨngə səi je səi njé kɨndə ɓadɨde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","E mbata kɨn ə, Luwə əl ta me tər tɨ ə nə: “M-a m-ɨlə kɨ njé kəl ta je kɨ tam tɨ, kɨ njé kaw kɨlə je, m-adɨ-de, ɓa a tɔli-de je, a adi-de ko̰ je.” ");
INSERT INTO bjvNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","E be mba kadɨ dəjii dɨje kɨ dɔkagɨlo tɨ kɨ ɓone, məsɨ njé kəl ta je kɨ tam tɨ kɨ ɓuki kɔ lo kɨlə ngɨrə dɔra̰ kɨ dɔnangɨ tɨ nu bɨtɨ ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Məsɨ kɨ ɨlə ngɨre dɔ Abəl tɨ nu bɨtɨ tḛḛ-n dɔ Jakari tɨ, kɨ ndɔ kɨ tɔli-e dadan lo tɨ kɨ ḭ dɨngɨri kadɨ-kare tɨ re kəy tɨ lə Luwə. Kɨ rɔjetɨ, adɨ m-əl səsi təkɨ dɨje kɨ dɔkagɨlo tɨ kɨ ɓone a ugəi kɨrə nḛ je kɨ ra nḛ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kəm-to-ndoo e ləsi, səi njé ndo ndu-kun je kɨ ta rəbɨ nḛ gər e jisi tɨ, ə səi wa uri me tɨ al nɨm, taa dɨje kɨ gei kadɨ tə n-uri me tɨ ka ɔgi-de nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lokɨ Jəju tḛḛ me kəy tɨ ka kɨn ɓa, njé ndo ndu-kun je kɨ Parɨsɨ je ɨləi ngɨrə ra tɔgɨ dɔ Jəju tɨ je, dəji-e ta je kɨ dangɨ dangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sangi rəbɨ me ta je tɨ kadɨ tə n-ɨngəi ta kɨ go tɨ al tae tɨ ɓa n-uwəi-e-n. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dɔkagɨloe tɨ kɨn, dɨbɨ dɨje kɨ ba̰y ba̰y ə kawi-naa dɔ Jəju tɨ, adɨ mbɨsəi-naa kɨ yo je, kɨ ne je. Lo kɨn tɨ, Jəju əl njé ndo je ləne ə nə: «Nḛ kɨ dɔ kəte, majɨ kadɨ ɨndəi kəm-kədɨ dɔ rɔsi tɨ ɔjɨ-n dɔ əm lə *Parɨsɨ je, adɨ e kədɨ kəm-naa ləde. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nḛ ra kɨ gɨdɨ ngə̰y tɨ kɨ gɨne a tḛḛ al goto, taa nḛ kɨ to lo ɓɔyɔ tɨ, kɨ dəw a gər al ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","MBata, ta je pətɨ kɨ əli lo kɨ ndul tɨ, dɨje a oi dɔe kada wangɨ, ə ta je kɨ uwəi tasi mbinaa tɨ taa əli kəy kɔrɔkɨ, dɨje a ɨləi mbḛe dɔ kagɨ tɨ taa tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Səi kɨ səi madɨm je, m-əl səsi kadɨ ɨɓəli dɨje kɨ a tɔli darɔsi par, ə go tɨ asi ra nḛ kɨ rangɨ al, kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","M-a m-tɔjɨ səsi dəw kɨ sɔbɨ kadɨ ɨɓəli-e. Dəw kɨ sɔbɨ kadɨ ɨɓəli-e e Luwə kɨ a tɔl darɔsi, ɓa təl a dɔ tɨ no̰o̰ kadɨ ɨlə səsi me por tɨ lə su ɓəy kɨn. Təkɨ rɔjetɨ, e ə sɔbɨ kadɨ ɨɓəli-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Dɨje ɨsɨ gati kɨ ngan yəl je mi ə gusɨ joo adɨ oi ne, nə kɨ kare dande tɨ kɨ kadɨ me Luwə oy dɔe tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɨ ətɨ ɓəl ngay wa ɓəy kɨ kadɨ ɨgəri, bḭ dɔsi wa kɨn ka Luwə tɨdə kare kare gər kɔre. Ɨɓəli nḛ madɨ al, səi je, Luwə oo ndasi ɨtəi ngan yəl je kɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","M-əl səsi ta kɨ rɔjetɨ kadɨ ɨgəri təkɨ, dəw kɨ ra kɨ un ndune ta kəm dɨje tɨ wangɨ təkɨ n-e dəw ləm, mi *NGon dəw m-a m-əl ta wangɨ ta kəm malayka je tɨ lə Luwə təkɨ e dəw ləm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nə dəw kɨ najɨ ta ta kəm dɨje tɨ təkɨ n-gər-m al, mi NGon dəw m-a m-najɨ ta ta kəm malayka je tɨ təkɨ m-gər-e al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dəw kɨ əl ta kɨ majal ɔsɨ-n tam mi NGon dəw ə, Luwə a ɨyə̰ go majal je lie kɔ, nə dəw kɨ əl ta kɨ mal ɔsɨ-n ta NDɨl Luwə, Luwə a ɨyə̰ go majal lie kɔ al ratata. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lokɨ a uwəi səsi kadɨ awi səsi lo kaw-naa je tɨ lə *Jɨpɨ je kadɨ gangi ta dɔsi tɨ, a awi səsi no̰ ngar je tɨ, kɨ no̰ njé ko̰ɓe je tɨ, onosi kadɨ mesi ɓəl kə nə se a asi kadɨ ɨnaji ta dɔsi tɨ wa, se ta ri ə a əli wa. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tadɔ, loe tɨ wa no̰o̰ kɨn, NDɨl Luwə a ndo səsi ta kɨ kadɨ əli. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dəw kare dan kosɨ dɨje tɨ əl Jəju ə nə: «NJe ndo dɨje, əl ngokom adɨ, nḛ nduwə kɨ bawje ɨyə̰ adɨ-je kɨn, ka̰y ya̰m adɨ-m.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ə Jəju əl-e ə nə: «Dəw kɨ ɨndə-m kadɨ tə mi nje ngangɨ ta dansi tɨ ə se kadɨ tə mi nje ka̰y səsi nḛ kɨngə goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɓa təl əl dɨje pətɨ ə nə: «Majɨ kadɨ ɨndəi kəm-kədɨ dɔ rɔsi tɨ ɔjɨ-n dɔ mal nḛ kɨngə kɨ dunɨya̰ tɨ. Tadɔ re dəw ɨngə-n nḛ tə ri, tə ri ka, nḛ kɨngə lie kɨn ə a ra adɨ ɨsɨ-n kɨ dɔne taa al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ɓa Jəju təl əl-de kujɨ ta madɨ ə nə: «Dɨngəm madɨ kare kɨ nje nḛ kɨngə ɨsɨ no̰o̰, lo ndɔr je lie, ɨngə nḛ me tɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ə dəjɨ rɔne ta ə nə: “E ri ə kadɨ tə m-ra dana? Lo kɨ kadɨ tə m-kaw nḛ ndɔr tɨ ləm goto.” ");
INSERT INTO bjvNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nɨngə təl əl ə nə: “Majɨ, nḛ kɨ m-a m-ra ə to kɨn: m-a m-ndu dam je ləm kɨ kəte kɨn kɔ, ɓa m-a m-ur dam je kɨ boyi ngay kadɨ tə m-kaw nḛ ko je ləm tɨ pətɨ, naa tɨ kɨ ndəgɨ nḛ majɨ je ləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɨngə m-a m-əl mem tɨ m-ə nə: ‹Ɓasɨne m-aw kɨ nḛ kɨngə kɨ to mbar mbar kadɨ m-ra-n ɓal ba̰y ba̰y, ə kadɨ m-uwə kɔ rɔm, m-uso je, m-a̰y je, m-o-n majɨ rɔm.›” ");
INSERT INTO bjvNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nə Luwə əl-e ə nə: “Ḭ mbə dəw kɨ ɨsɨ əl ta kɨn, kondɔ kɨ ne wa kɨn ndɔi a asɨ. Ə se nḛ je kɨ ɨsɨ kaw kɨ dɔ-naa tɨ kɨn, a e ya̰ na̰ wa?” ");
INSERT INTO bjvNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","E kɨn ə e nḛ kɨ a tḛḛ dɔ dəw tɨ kɨ nje kaw nḛ kɨngə je kɨ naa tɨ mbata lə rɔne wa, ɓɨ mbata tɨ lə Luwə al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jəju əl njé ndo je ləne ə nə: «E mbata kɨn ə, m-əl səsi kadɨ adi mesi a sururu dɔ nḛ kusosi tɨ, kɨ kadɨ ɨsi kɨ dɔsi taa al, taa dɔ kɨbɨ kɔsi tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tadɔ kɨsɨ kɨ dɔ taa ɨtə nḛ kuso, taa darɔ dəw ɨtə kɨbɨ kɨ kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɨgo̰i kaga̰ je oi, dɨbi ko al nɨm, təti al nɨm, taa awi kɨ lo madɨ kɨ kadɨ ngəmi nḛ tɨ mba ndɔ kɨ lo ti tɨ al nɨm, dam ləde ka goto nɨm tɔ, nə Luwə ɨsɨ adɨ-de nḛ usoi majɨ. Nɨngə səi, oi kadɨ Luwə oo ndasi ɨtə yəl je al a? ");
INSERT INTO bjvNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na̰ dansi tɨ ə asɨ kadɨ a ɨlə ngon kadɨ kɨ ndə̰y be dɔ ndɔne tɨ kɨ takul me ka sururu ləne ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kɨn ə nḛ kɨ ndə̰y be kɨn ka asi kadɨ ɨrai kɨ dɔrɔsi al ə, ra ban be ə mesi osɨ nangɨ dɔ ndəgɨ ne je tɨ al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ɨgo̰i putɨ kam je kɨ ai me wale tɨ kɨn oi. Rai kɨlə madɨ al nɨm, oji kɨbɨ al nɨm tɔ, nə ngar *Salomo̰ kɨ tɔe ɓa ngay me nḛ kɨngə tɨ kɨn ka ɔ kɨbɨ kɨ ndole asɨ naa səde al. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ə kɨn ə Luwə ɨlə kɨbɨ rɔ ngan kagɨ je tɨ kɨ wale, kɨ j-o-de ɓone, ə lo ti par ə a o̰i por kɨn be nɨngə, ra ban ə səi dɨje taa a ɨlə kɨbɨ rɔsi tɨ al ə? Səi to̰ je me kadɨ-me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Adi ta ga al dɔsi ɔjɨ-n dɔ nḛ kusosi ə se man ka̰ysi al. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nḛ je kɨn pətɨ, e dɨje kɨ gəri Luwə al kɨ dɔnangɨ tɨ ne kɨn ə ɨsɨ sangi kɨ no̰ kəmde tɨ, nə səi, Bawsi gər majɨ kadɨ awi kɨ ndooe tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nḛ kɨ kadɨ ɨsangi, e ko̰ɓe lie, nɨngə a adɨ səsi ndəgɨ nḛ je kɨn dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Səi kɨ ɨtoi tə nḛ kul je kɨ ngay al, kɨ ɨsɨ uni go ɓade be kɨn, adi ɓəl ra səsi al, mbata Bawsi oo majɨ ngay kadɨ adɨ səsi ɓeko̰ ləne. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Ɨgati kɨ nḛ majɨ je ləsi, ə adi lae njé ndoo je. Ɨrai ɓɔl la kɨ a tujɨ al, ɨkawi nḛ kɨngə je ləsi dɔra̰ tɨ, kɨ e lo kɨ nje ɓogɨ a tḛḛ tɨ al nɨm, e lo kɨ yo̰ goto tɨ nɨm kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tadɔ lo kɨ nḛ kɨngə ləsi e tɨtɨ ə mesi a e tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɨsi dɔ njasi tɨ kɨ kɨbɨ ra kɨlə, adi por lambɨ je ləsi o̰ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nɨngə kadɨ ɨtoi tə dɨje kɨ ɨsɨ ngəmi ta təl ɓade kɨ aw lo taa naa tɨ be. Ɨsɨ ngəmi tae kadɨ re təl taa, ə ɨndə ta kəy ɓa tḛḛi adi-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Majɨ-kur e dɔ ɓəə kɨlə je tɨ kɨ, ɓade təl ɓa ɨngə-de ɨsi dɔ njade tɨ. Təkɨ rɔjetɨ, adɨ m-əl səsi, ɓade a un kɨbɨ kɨlə ləne ɨlə rɔne tɨ, ə a adɨ-de ɨsi nangɨ kadɨ adɨ-de nḛ usoi. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kɨn ə re təl dan lo tɨ, ə se ta gɨn lo tɨ, ə ɨngə-de ɨsi dɔ njade tɨ ə, majɨ a ur-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Ɨgəri majɨ kadɨ re ɓa nje kəy gər dɔ kadɨ kɨ nje ɓogɨ a re-n ə, a ɨyə̰ nje ɓogɨ kadɨ ur kəy al. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ə səi ka, ɨsi dɔ njasi tɨ tɔ, tadɔ mi *NGon dəw m-a m-re dɔ kadɨ tɨ kɨ ɨgəri al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lo kɨn tɨ, Pɨyər dəjɨ Jəju ə nə: «Ɓaɓe, kujɨ ta kɨ əl kɨn sɔbɨ dɔje je par ə se sɔbɨ dɔ dɨje pətɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ə Ɓaɓe əl-e ə nə: «NJe ngəm nḛ kɨ e dəw kɨ dana, kɨ kəme ədɨ, ə e dəw kɨ ɓae a ɨnde dɔ me kəy tɨ kadɨ ləbɨ nḛ kuso dɨje kɨ kadɨ kɨ kadɨ adɨ-n-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","NJe ra kɨlə kɨn a e nje majɨ-kur, lo kɨ ɓae təl ə ɨnge ta kɨlə tɨ kɨn, a ra. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Təkɨ rɔjetɨ kadɨ m-əl səsi, a ɨnde dɔ nḛ majɨ je tɨ ləne pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A kɨn ə re nje ra kɨlə kɨn əl mene tɨ ə nə: “Ɓam a re law al ɓəy” ə, a a ta tɨndə ndəgɨ njé kɨlə je tɨ kɨ dəne kɨ kɨ dɨngəm, a ta kuso tɨ, kɨ ta ka̰y tɨ, ra-n kasɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Lo kɨn tɨ, ɓa nje kəy a re kɨ ndɔ kɨ e ɨndə mene dɔ tɨ al, kɨ dɔ kadɨ kɨ e gər al. Ɓae a tuwe kɔ, kadɨ oo nḛ ko̰ kɨ a ra dɨje kɨ nje ra nḛ kɨ dana al. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ɓəə kɨlə kɨ gər ndɨgɨ ra lə ɓane majɨ, nə ɨndə rɔne ta ndɨgɨ ra tɨ kɨn ra al, a ɨngə ndəy ta ba̰y ba̰y. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","NGa nɨngə, ɓəə kɨlə kɨ gər ndɨgɨ ra lə ɓane al, ə ra nḛ kɨ asɨ ta kɨndə ə, a ɨngə kɨndə ngay al. Ɨgəri kadɨ dəw kɨ adi-e ngay, a dəji-e ngay tɔ, ə dəw kɨ adi-e nḛ ngay kadɨ ngəm, a gei nḛ ngay jie tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«M-re kɨ por dɔnangɨ tɨ; nɨngə kɨn, m-ndɨgɨ kadɨ por ka kɨn o̰ ngata! ");
INSERT INTO bjvNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sɔbɨ kadɨ m-nduy me ko̰ tɨ təkɨ dəw a ra-n batəm kɨn be. Nɨngə e nḛ kɨ adɨ-m ko̰ me ndɨlm tɨ, bɨtɨ kadɨ nḛ je tɔli tade. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kadɨ ɨgai mesi tɨ təkɨ m-re kɨ lapɨya dɔnangɨ tɨ, al. M-əl səsi, m-re kɨ lapɨya al jagɨ, nə m-re kɨ gangɨ-naa yo. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nɨngə kɨ ɓasɨne kɨn, dɨje mi kɨ ɨsi me kəy tɨ kɨ kare a gangi-naa, dɨje kɨ mɨtə a ɔsi ta njé kɨ joo, ə dɨje kɨ joo a ɔsi ta njé kɨ mɨtə. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baw ngon a ɔsɨ ta ngonne kɨ dɨngəm, ngon kɨ dɨngəm a ɔsɨ ta bawne; ko̰ ngon a ɔsɨ ta ngonne kɨ dəne, ngon kɨ dəne a ɔsɨ ta kone; ko̰ ngon kɨ dɨngəm a ɔsɨ ta məmne; ngon kɨ dəne a ɔsɨ ta məmne kɨ dəne.» ");
INSERT INTO bjvNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jəju əl kosɨ je ə nə: «Lokɨ oi ndi ḭ lo kɨbə kadɨ tɨ nɨngə, ta naa tɨ no̰o̰ əli əi nə: “NDi a ədɨ”, ɓa ndi ədɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A re oi nəl kɨ ḭ gɨn ɓe tɨ ə ɨsɨ ɨlə nɨngə, əli əi nə: “Lo a tɨngə”, ɓa lo tɨngə ka tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Səi dɨje kɨ njé me nga̰, asi kadɨ ɨgəri kəm nḛ je kɨ a rai nḛ dɔnangɨ tɨ ne, ə se dɔra̰ tɨ, nɨngə dɔkagɨlo kɨ ɓone kɨn ɓa, asi kadɨ ɨgəri nḛ je ɨsɨ ra nḛ tɨtɨ al! ");
INSERT INTO bjvNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ra ban be ə səi je wa, nḛ kɨ to kadɨ ɨgangi ta kɨ dana dɔ tɨ ə, ɨgangi al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kɨn ə ɨsɨ awi lo gangɨ ta tɨ kɨ nje ta ləi ɓa, lokɨ səi dɔ rəbɨ tɨ ɓəy ə, ɨsangɨ rəbɨ kadɨ ndusi osɨ go-naa tɨ sie, nə tə aw səi ɨləi ji nje gangɨ ta tɨ, adɨ nje gangɨ ta uni ɨləi ji asɨgar je tɨ, adɨ asɨgar je ɨləi-ni dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nɨngə adɨ m-əli, a ɨtḛḛ lo kɨn tɨ al bɨtɨ kadɨ ugə dɔbəy sɨsi ɓəy taa a ɨyə̰i-ni taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dɔkagɨloe tɨ no̰o̰ ə, dɨje madɨ rəi əli Jəju ta lə dɨje kɨ Galile tɨ kɨ ndɔ kɨ *Pɨlatɨ kɨ nje ko̰ɓe adɨ tɔli-de dɔkagɨlo tɨ kɨ ɨsɨ ɨjəi məsɨ kadɨ-kare adi Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ə Jəju ɨlə-de tɨ ə nə: «Ɨgɨri kadɨ dɨje kɨ Galile tɨ kɨ ɨngəi nḛ kɨ to kɨ ətɨ ɓəl be kɨn e mbata ke ə əi njé ra majal je kɨ ngay ɨtəi ndəgɨ dɨje kɨ Galile tɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jagɨ e be al. Nɨngə səi je wa ka adɨ m-əl səsi, re ɨyə̰i pa njɨyəsi je kɨ majal kɔ al ə, kosi a tɔ pətɨ be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Se oi kadɨ dɨje kɨ dɔgɨ gɨde e jijoo kɨ ndogɨ bɔr kɨ Sɨlowe tɨ osɨ dɔde tɨ tɔl-de kɨn, majal ləde ɨtə ndəgɨ dɨje kɨ Jorijaləm tɨ pətɨ tɨgə a? ");
INSERT INTO bjvNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jagɨ e be al. Nɨngə səi je wa ka adɨ m-əl səsi, re ɨyə̰i pa njɨyəsi je kɨ majal kɔ al ə, kosi a tɔ pətɨ be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Go ta je tɨ kɨn, Jəju əl kujɨ ta kare ə nə: «Dɨngəm kare aw kɨ kagɨ mbay-kote kare kɨ mə-e me ndɔr nju tɨ ləne, ə ndɔ kare aw kadɨ tə n-ɨjə kande ɓa ɨngə kande dɔ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ə əl nje ngəm ndɔr ləne ə nə: “O, asɨ ɓal mɨtə ngata ə m-sangɨ kadɨ m-ɨjə kandɨ mbay-kote kam m-uso, nə m-ɨngə kande al. Majɨ kadɨ ɨtɨge kɔ, tadɔ kəme kɨ kadɨ a utɨ-n lo kare goto.” ");
INSERT INTO bjvNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nə nje ngəm ndɔ ka kɨn ɨle tɨ ə nə: “Ɓam, ɨyḛ adɨ a ɓal kare ɓəy. M-a m-ɔr gɨne kadɨ m-ɓukɨ sḭ nḛ je njae tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dɔmajɨ ə ɓal kɨ rangɨ ə a andɨ. A re ɓal kɨ rangɨ ə andɨ al ɓəy ə tə adɨ m-tɨge kɔ mɨndɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","NDɔ kare Jəju ɨsɨ ndo nḛ dɨje kəy kaw-naa tɨ madɨ kare ndɔ ta kə̰ə̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nɨngə me kəy kaw-naa tɨ ka kɨn, dəne kare kɨ ndɨl kɨ majal uwə, ɨlə tae nangɨ, asɨ ɓal dɔgɨ gɨde jijoo ɨsɨ me tɨ no̰o̰. NDɨl kɨ majal ka kɨn dɔɔ-e ngɔn, lo kadɨ ndajɨ taa majɨ goto tə goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lokɨ Jəju oo-e nɨngə ɓar-e ə əl-e ə nə: «Dəne ḭ kɨ taa kɨyə̰ taa dɔ to̰ tɨ ləi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jəju ɨndə jine dɔe tɨ, ɓa ta ji naa tɨ no̰o̰ par ə, dəne ndajɨ rɔne taa majɨ, nɨngə ɨlə ngɨrə kɨlə tɔjɨ dɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lo kɨn tɨ, kɨ bo kɨ dɔ kəy kaw-naa lə Jɨpɨ je ka kɨn, mee o̰-e mbata kadɨ kɨ Jəju adɨ dəw rɔ nga ndɔ taa kə̰ə̰ tɨ, adɨ əl kosɨ dɨje ə nə: «NDɔ kɨ kadɨ dɨje rai kɨlə e mehḛ, ə ɨrəi ndɔe je tɨ kɨ mehḛ kɨn adɨ adi səsi rɔ nga, ɓɨ e ndɔ taa kə̰ə̰ tɨ al!» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɓaɓe əl-e ə nə: «Səi njé kədɨ kəm dɨje! dəw kɨ ra dansi tɨ ə tutɨ mangɨ ləne ə se koro ləne ndɔ ta kə̰ə̰ tɨ, lo kuso nḛ tɨ aw sie lo ka̰y man tɨ al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","NGa dəne kam kɨ e ngon ka *Abɨrakam, kɨ *Sata̰ uwe gɨn tɔgɨ tɨ ləne asɨ ɓal dɔgɨ gɨde e jijoo be kɨn ə, kadɨ m-tute m-ɨle taa al mba ke kɨ e ndɔ ta kə̰ə̰ a?» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dɔkagɨloe tɨ kɨ Jəju ɨsɨ əl ta kɨn nɨngə, rɔ njé ba̰ je lie sɔl-de ngay. Nə rɔ kosɨ dɨje nəl-de ngay mbata nḛ je kɨ ətɨ ɓəl kɨ Jəju ɨsɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Go tɨ nɨngə Jəju ə nə: «M-a m-ɔjɨ səsi nḛ kɨ tɨtɨ-naa kɨ ko̰ɓe lə Luwə, m-a m-un nḛ kare kadɨ m-ɔjɨ-n səsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","To tɨtɨ-naa kɨ kandɨ kagɨ madɨ kɨ a ɓari-e nə mutadɨ kɨ dəw madɨ un dɨbɨ me ndɔr tɨ ləne kɨn be. Kandɨ kagɨ ka kɨn ɨbə, tɔgɨ, adɨ yəl je uwəi lo kɨsɨ bajie je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jəju təl əl ɓəy ə nə: «M-a m-un nḛ kɨ rangɨ kare kadɨ m-ɔjɨ-n səsi ko̰ɓe lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","To tɨtɨ-naa kɨ əm kɨ dəne madɨ un lɔy-n ndujɨ kɨ me kee joo, adɨ ndujɨ kɨ lɔy ba pətɨ ḭ kɨn be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Lokɨ Jəju ɨsɨ aw Jorijaləm tɨ, ndo ne dɨje ɓe bo je tɨ kɨ ngan ɓe je kɨ ɨndə man tɨtɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɨngə dəw madɨ dəje ə nə: «Ɓaɓe, dɨje ngay al ba par ə a aji a?» Ə Jəju əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Uwəi tɔgɨsi ba kadɨ uri kəy kɨ ta rəbɨ kɨ mbəngɨrə, tadɔ adɨ m-əl səsi, dɨje ngay a sangi kadɨ n-urii nə a asi al. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lokɨ ɓa nje kəy a ḭ taa, ə a utɨ ta kəy nɨngə, səi je ɨnayḭ-naa taga, ɨləi ngɨrə kɨndə ta kəy əi nə: “Ɓaɓe, ɨtḛḛ ta kəy adɨ-je!” kɨn ɓa, e a əl səsi ə nə: “Səi, m-gər lo kɨ ḭḭ tɨ al.” ");
INSERT INTO bjvNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lo kɨn tɨ, a əli əi nə: “J-uso səi nɨm, j-a̰y səi nɨm, taa ta mbalo je ləje ə ɨndo nḛ dɨje tɨ nɨm tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nə, a əl səsi ə nə: “M-gər lo kɨ ḭḭ tɨ al, ɔri rɔsi kɔ rɔm tɨ. Səi pətɨ səi njé ra majal je.” ");
INSERT INTO bjvNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Loe tɨ kɨn, a no̰i je, a ɨngəi ngangɨsi je, lokɨ a oi *Abɨrakam je, kɨ *Isakɨ je, kɨ *Jakobɨ je, kɨ njé kəl ta kɨ ta Luwə tɨ pətɨ me ɓeko̰ tɨ lə Luwə. Nɨngə səi je, a tuwəi səsi ɓukɨ səsi kɔ taga. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dɨje a ḭḭ kɨ lo kɨbə kadɨ tɨ je, lo kur kadɨ tɨ je, jam dɔ ɓe tɨ je, gɨn ɓe tɨ je, kadɨ rəi ɨsi ta nḛ kuso tɨ ɓeko̰ tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Lo kɨn tɨ, dɨje madɨ kɨ əi njé kɨ gogɨ a təli njé kɨ kəte, ə dɨje kɨ madɨ kɨ əi njé kɨ kəte a təli njé kɨ gogɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dɔkagɨloe tɨ wa kɨn, *Parɨsɨ je madɨ rəi rɔ Jəju tɨ əli-e əi nə: «Ɔtɨ lo kɨn tɨ kɔ, aw lo kɨ rangɨ tɨ, tadɔ *Erodɨ ge kadɨ n-tɔli.» ");
INSERT INTO bjvNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ə Jəju əl-de ə nə: «Awi əli nja̰ dəw kam, təkɨ ɓone kɨ lo ti, m-a m-tuwə ndɨl je kɨ majal nɨm, m-a madɨ dɨje rɔ nga nɨm tɔ, ɓa ndɔ kɨ ko̰ mɨtə ə m-a tɔl ta kɨlə ləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nɨngə sɔbɨ kadɨ m-un ta rəbɨ ləm me ndɔ tɨ kɨ ɓone nɨm, lo ti nɨm, lo ti kɨ go tɨ nɨm, tadɔ e nḛ kɨ go rəbe tɨ al kadɨ nje kəl ta kɨ ta Luwə tɨ, oy lo kɨ rangɨ tɨ, ɓɨ oy Jorijaləm tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Səi dɨje kɨ Jorijaləm tɨ, oyo, səi kɨ Jorijaləm tɨ, səi kɨ səi njé tɔl njé kəl ta je kɨ ta Luwə tɨ, səi njé tɨlə dɨje kɨ Luwə ɨlə səde adɨ səsi kɨ mbal tɔli-de. NJa ngay, m-sangɨ kadɨ m-kaw səsi təkɨ ko̰ kɨnjə a kaw-n ngane je kɨ tɔde gɨn bagɨne tɨ kɨn be, nə ɔdi al. ");
INSERT INTO bjvNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɨngə kɨ ne kɨn, Luwə a ɨyə̰ kəy kaw-naa ləsi kɔ jisi tɨ. Ə adɨ m-əl səsi madɨ oi təkɨ a oi-mi al bɨtɨ kadɨ dɔkagɨlo madɨ a re kɨ a əli əi nə: “NJangɨ dɔ e dɔ dəw tɨ kɨ re me tɔ Ɓaɓe tɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","NDɔ kare, Jəju aw me kəy tɨ lə nje kɔr no̰ *Parɨsɨ je kare mba kuso nḛ, ndɔ taa kə̰ə̰ tɨ. Dɨje kɨ ɨsi no̰o̰, ɨsɨ ɨndəi manjɨ Jəju ba ooi-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dɨngəm kare kɨ mo̰y ti-e a no̰ Jəju tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ə Jəju dəjɨ njé ndo ndu-kun je kɨ Parɨsɨ je ə nə: «Ta rəbɨ to kadɨ dəw nga-n dəw ndɔ ta kə̰ə̰ tɨ ə se goto ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nə dəw ɨlə Jəju ta tɨ al. Ə Jəju təl rɔne kɨ rɔ nje mo̰y tɨ, ade rɔ nga nɨngə əl-e ade aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Go tɨ Jəju əl-de ə nə: «Na̰ dansi tɨ ə, ngone, ə se mangɨ lie wa osɨ ɓe man tɨ ndɔ taa kə̰ə̰ tɨ, ə un-e taji-naa tɨ no̰o̰ al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nɨngə lo kadɨ ɨləi-e ta tɨ kɨ dəjɨ kɨn goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lokɨ Jəju oo kadɨ dɨje kɨ ɓari-de lo nḛ kuso tɨ kɨn sangi lo kɨsɨ kɨ kəte no̰ dɨje tɨ ɓa, əl-de kujɨ ta madɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Lokɨ dəw madɨ ɓari lo nḛ kuso taa-naa tɨ ə, otɨ kadɨ aw ɨgangɨ rɔi ɨsɨ kəte no̰ dɨje tɨ. Dɔmajal ə, ɓari dəw kɨ ɨtəi loe tɨ no̰o̰ tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nɨngə kadɨ nje ɓar səsi joo pu ka kɨn re, əli ə nə: “Ḭ taa ə ɨyə̰ lo kɨsi kɨn adɨ madi,” ɓa a e kɨ rɔsɔl kɨ bo ngay ə a aw kadɨ ɨsɨ-n lo kɨ gogɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nə lokɨ dəw madɨ ɓari, majɨ kadɨ aw ɨsɨ lokɨ gogɨ tɨ, adɨ nje ɓar-i ə wa lokɨ re nɨngə əli ə nə: “Madɨm, ḭ taa ɨre ɨsɨ kəte yo be.” Lo kɨn tɨ, a e kɔsɨ-gon ləi ta kəm madi je tɨ pətɨ kɨ ɓari-de lo nḛ kuso tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Təkɨ rɔjetɨ, dəw kɨ ra kɨ un dɔne taa, ə a ɨləi dɔe nangɨ, nɨngə dəw kɨ nje kulə dɔne nangɨ ə, a uni dɔe taa tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Go tɨ Jəju əl dəw kɨ nje ɓar-e ka kɨn ə nə: «Lokɨ ɨra nḛ kuso kɨ be kɨn, kɨ kada ə se kɨ lo sɔlɔ, otɨ kadɨ ɨɓar madi je kɨ ngako̰i je kɨ noji je, ə se njé gədɨ kəy ɓe je ləi kɨ njé nḛ kɨngə je. Tadɔ əi je ka a ɓari-ni ndɔ madɨ tɨ tɔ, nɨngə a ɨgəi-ni nḛ kɨ ndɔ kɨ ɨra adɨ-de ka kɨn gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nə lokɨ ɨra nḛ kuso rɔnəl kɨ ngay be kɨn, majɨ kadɨ ɨɓar njé ndoo je kɨ njé je kɨ ta rɔde asɨ-naa al, kɨ njé mətɨ je, kɨ njé kəm tɔ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nɨngə rɔi a nəl-i, tadɔ a ɨngəi nḛ kadɨ a ɨgəi-ni gogɨ al. Təkɨ rɔjetɨ, Luwə a ɨgəi ndɔ kɨ a tḛḛ kɨ njé ra nḛ je kɨ dana lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lokɨ oi ta kɨn nɨngə, dəw kare mbo̰ dɨje tɨ kɨ ɨsi lo nḛ kuso tɨ əl Jəju ə nə: «Rɔnəl e lə dəw kɨ a uso nḛ me ɓeko̰ tɨ lə Luwə!» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɨngə Jəju təl əl-e ə nə: «NDɔ kare, dɨngəm madɨ ra nḛ kuso kɨ bo ngay ɓar-n dɨje ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dɔkagɨlo kuso nḛ tɨ nɨngə, ɨlə nje kɨlə ləne adɨ aw əl dɨje kɨ ɓar-de ka kɨn ə nə: “Nḛ kuso oy ngata ə ɨrəi.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nə dɨje pətɨ kɨ ɓari-de ka kɨn, kare, kare, ɨləi ngɨrə kadɨ dəji me-sɔl. E kɨ dɔsa̰y əl-e ə nə: “M-ndogɨ lo ndɔr ngɔsɨne ɓəy, m-ɨsɨ m-aw kadɨ m-o; ə m-dəji kadɨ adɨ mei sɔl dɔm tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","E kɨ rangɨ ə nə: “M-ndogɨ mangɨ je dɔgɨ ngɔsɨne ɓəy, m-a m-aw kadɨ m-na-de m-o; ə m-dəji kadɨ adɨ mei sɔl dɔm tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","E kɨ rangɨ ə nə: “M-taa dəne ngɔsɨne ɓəy, adɨ lo kadɨ m-a m-aw goto.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","NJe kɨlə təl aw rɔ ɓane tɨ, əl-e ta je pətɨ kɨ əli-e kɨn ade oo. Lo kɨn tɨ, wongɨ tɔl ɓa nje kəy ka kɨn, adɨ əl nje kɨlə ləne ə nə: “Ḭ taa kalangɨ, aw ta mbalo je tɨ, kɨ go rəbɨ je, ɨɓar njé ndoo je, kɨ dɨje kɨ ta rɔde asɨ-naa al, kɨ njé kəm tɔ je, kɨ dɨje kɨ njé mətɨ je, ɨre səde.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","NDə̰y go tɨ nɨngə, nje kaw kɨlə re əl ɓane ə nə: “Ɓam, jɨ ra nḛ je kɨ ɨdəjɨ ka kɨn, nə lo kɨsɨ nay no̰ ɓəy.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ə ɓae əl-e ə nə: “Ɔtɨ aw taga dɔ rəbɨ je tɨ, kɨ lo ndɔr je, ɨndə tɔgɨ dɔ dɨje tɨ adɨ-de rəi mba kadɨ-me kəy ləm rosɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Təkɨ rɔjetɨ adɨ m-əl səi, dəw kare mbo̰ dɨje tɨ kɨ m-ɓar-de kəte kɨn kɨ a ɔdɨ nḛ kuso ləm kɨn tane tɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kosɨ dɨje ngay ɨsɨ njɨyəi kɨ Jəju dɔ rəbɨ tɨ. Jəju təl ɨlə rətɨ nɨngə əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Re dəw madɨ re rɔm tɨ ə ge-m ɨtə bawne kɨ kone al, nene kɨ ngane je al, ngakone je kɨ konane je, ə se darɔne wa al ə, a asɨ ke nje ndo ləm al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Taa dəw kɨ un kagɨ-dəsɨ ləne ə njɨyə gom tɨ, al, a asɨ ke nje ndo ləm al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Təkɨ rɔjetɨ, na̰ dansi tɨ ə lokɨ aw tə kɨndə ndogɨ bɔr kɨ ngal nɨngə, ɨsɨ nangɨ ɨlə kɔr nḛ ra kɨlə je naa tɨ, mba kadɨ n-oo se n-a n-asɨ tɔl ta kɨlə kɨn kare wa al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nə re ɨndə gɨn kəy ə tɔl tae al ə, dɨje pətɨ kɨ a oy gɨn kəy kɨ ɨndə kɨn, a kogi dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A əli əi nə: «Oi, dɨngəm kɨ ɨlə ngɨrə kadɨ ɨndə kəy, nə tɔge asɨ kadɨ tɔl tae al kɨn!» ");
INSERT INTO bjvNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ə se ngar kɨ ra ə lokɨ ɨsɨ aw kadɨ rɔ kɨ ngar madɨne kɨ rangɨ nɨngə, ɨsɨ nangɨ ə dəjɨ ta rɔne oo se kɨ njé rɔ je ləne kɨ dɨbɨ kutɨ kɨn n-a n-aw n-ɨlə-n rɔ madɨne kɨ ɨsɨ re kɨ njé rɔ je ləne kɨ əi dɨbɨ kutɨ joo kɨn kare wa al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Re oo kadɨ tɔgɨne a asɨ al nɨngə, a ɨlə dəjɨ ta ngar madɨne, mba sangɨ rəbɨ lapɨya, lokɨ nda̰e ngal ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ta kɨ dɔsi tɨ ka to be tɔ. Ɨməri ta majɨ oi taa, adi rɔsi, tadɔ dəw kɨ e ɓasi mba kɨyə̰ nḛ kɨngə je ləne al, a asɨ ke nje ndo ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Ɨgəri kadɨ katɨ e nḛ kɨ majɨ, nə lokɨ nəle goto, ə se ri ə dəw a ra-n kadɨ təl nəl gogɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nḛ kɨ kadɨ dəw a ra-n goto. A majɨ mba dɔnangɨ al nɨm, a majɨ mba nḛ kɨ a adɨ tɔgɨ dɔnangɨ kɨn al nɨm tɔ. A ɓuki-e kɔ gɨdɨ lo tɨ. Dəw kɨ aw kɨ mbine kadɨ oo-n ta, nɨngə kadɨ oo ta kɨn majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","*NJé taa la-mbə je, kɨ njé ra majal je, rəi kɨ rɔ Jəju tɨ mba kadɨ n-ooi ta kɨ ɨsɨ əl. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","*Parɨsɨ je, kɨ njé ndo ndu-kun je, ɨndəi ngɔne kɨ Jəju ə əli əi nə: «Oi! Dəw ka uwə njé ra majal je rɔne tɨ nɨm, uso səde nḛ nɨm!» ");
INSERT INTO bjvNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ə Jəju əl-de kujɨ ta madɨ kare ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Na̰ dansi tɨ ə re aw kɨ batɨ je ɓu, ə e kɨ kare nay nɨngə, a ɨyə̰ ndəge je kɨ dɔ jikare gɨde jikare dɔ wale tɨ, ə aw sangɨ e kɨ nay kɨn, ratata kadɨ ɨnge ɓəy taa al ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lokɨ ɨnge nɨngə, kɨ rɔnəl un-e ɨle bagɨne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nɨngə təl aw ɓe, ɓa madɨne je kɨ njé gədɨ kəy ɓe je ləne, əl-de ə nə: «Ɨrəi ɨrai rɔnəl səm tadɔ m-ɨngə ngon batɨ ləm kɨ nay ka!» ");
INSERT INTO bjvNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Be tɔ ə adɨ m-əl səsi, rɔnəl a e ngay me dɔra̰ tɨ mbata lə nje ra majal kare kɨ ɨyə̰ go rəbɨ njɨyəne kɨ majal kɔ, ɨtə njé je kɨ dana kɨ dɔ jikare gɨde jikare kɨ ta kɨ dɔ mbəl pa njɨyə tɨ, e ta ləde al kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Dəne madɨ kare aw kɨ nḛ mbi kɨ gate e ngay asɨ dɔgɨ, ə e kɨ kare nay. Lokɨ e kɨ kare nay, dəne ɨndə por lambɨ tɨ je, ɨtə me kəy je, sangɨ-n nḛ mbi ləne ka kɨn, bɨtɨ ɨngə ɓəy taa, taa kə̰ə̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Lokɨ ɨngə ngata nɨngə, ɓa madɨne je, kɨ njé gədɨ kəy ɓe je ləne, əl-de ə nə: «Ɨrai səm rɔnəl, tadɔ m-ɨngə nḛ mbi ləm kɨ nay ka kɨn!» ");
INSERT INTO bjvNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Be tɔ ə, adɨ m-əl səsi, rɔnəl e ngay mbo̰ malayka je tɨ lə Luwə, mbata nje ra majal kare kɨ ɨyə̰ rəbɨ pa njɨyəne kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jəju təl əl ɓəy ə nə: «Dɨngəm kare aw kɨ ngan je joo. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ə e kɨ du əl bawne ə nə: “Bai, adɨ-m nḛ nduwə ləm.” Be ə bawe ləbɨ nḛ kɨngə ləne ngane je kɨ joo. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","NDɔ ngay al go tɨ nɨngə, e kɨ du gatɨ kɨ nḛ je pətɨ kɨ ɨngə, ə aw mba me ɓe tɨ kɨ sa̰y. Me ɓe tɨ ka kɨn ə tujɨ kɨ la ləne kɔ me kaya tɨ kɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lokɨ tujɨ kɨ la ləne ka kɨn pətɨ tɨgə nɨngə, ɓo kɨ bo osɨ me ɓe tɨ ka kɨn. Nɨngə ɨlə ngɨrə kadɨ nḛ je pətɨ to rɔe ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aw ra kɨlə ɓe lə dəw madɨ kare me ɓe tɨ kɨn no̰o̰. Dɨngəm ka kɨn ade kɨlə ngəm kɔsongɨ je wale. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ɓo kuso nḛ kuso lə kɔsongɨ je to me tɨ, nə dəw kɨ ade goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Be ə ɨlə ngɨrə kadɨ mər ta, nɨngə əl rɔne ə nə: “NJé ra kɨlə je əi ban ɓe lə bai, ə usoi nḛ dum-de dum-de, ə mi ta m-ɨsɨ m-oy yo ɓo be ə! ");
INSERT INTO bjvNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","M-a m-ḭ taa ə m-aw rɔ bai tɨ m-a m-əl-e m-ə nə: ‹M-ra majal m-ɔsɨ-n ta Luwə, taa m-ɔsii ta tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","M-asɨ ta kadɨ ɨɓar-m ngoni al. Ɨra-m təkɨ kare mbo̰ njé ra kɨlə je tɨ ləi be.›” ");
INSERT INTO bjvNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Be ə, ḭ taa osɨ rəbə mba təl kaw rɔ bawne tɨ. Lokɨ nay sa̰y kɨ kəy ɓəy nɨngə, bawe oo-e. Lokɨ oo-e, aw kɨ me-ko̰ kɨ ngay mbata lie, adɨ a̰y ngɔdɨ tɨlə tae, uwe rututu, ore njarara rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","NGon əl bawne ə nə: “Bai m-ra majal m-ɔsɨ-n ta Luwə nɨm, m-ɔsi-i ḭ wa ta nɨm tɔ, m-asɨ ta kadɨ ɨɓar-m ngoni al.” ");
INSERT INTO bjvNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nə bawe əl njé ra kɨlə je ə nə: “Ɨrəi kɨ kɨbɨ kɨ majɨ ɨtə ndəge je kalangɨ ɨləi rɔ ngonm tɨ. Ɨləi nɨngə ngon jie tɨ ə ɨləi sa njae tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɨrəi kɨ ngon mangɨ kɨ bo mbul mbul ɨtɔli-e adɨ j-usoi jɨ rai rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tadɔ ngonm kɨn oy ə təl ɨsɨ kɨ dɔne ta. Nay ə e kɨ kɨnge!” Nɨngə ɨləi ngɨrə kadɨ rai rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Dɔkagɨloe tɨ kɨn, ngoko̰e kɨ ngatɔgɨ e wale. Lokɨ ɨsɨ təl wale ə e ngɔsi kɨ kəy nɨngə oo ndu nḛ kɨndə je kɨ ndam je. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɓar nje ra kɨlə kare, ə dəje nə se ri ə ɨsɨ ra nḛ wa. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","NJe ra kɨlə ka kɨn əl-e ə nə: “NGoko̰i ə re ə bawi adɨ tɔli ngon mangɨ kɨ bo mbul mbul tadɔ təl kɨ lapɨya.” ");
INSERT INTO bjvNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","NGon kɨ ngatɔgɨ ra wongɨ adɨ mbatɨ kaw kəy. Bawe tḛḛ taga mba kadɨ sɔl me ade ur kəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nə əl bawne ə nə: “O ɓal ngay ə m-ɨsɨ m-ra kɨlə madi, ndɔ kare kɨ m-mbatɨ təl rɔm go ta tɨ ləi goto. Nə ndɔ kare kɨ adɨ-m ngon bɨyə̰ be adɨ-m m-ra-n rɔnəl kɨ madɨm je goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nə lokɨ ngoni kɨ tujɨ nḛ kɨngə ləi dɔ kaya dəne je tɨ kɨn re nɨngə, ɨtɔl ngon mangɨ kɨ bo mbul mbul ade.” ");
INSERT INTO bjvNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nɨngə bawe əl-e ə nə: “Ḭ, ngonm, ḭ səm ne naa tɨ kɨ ndɔ je pətɨ, adɨ nḛ je pətɨ kɨ e ya̰m e ya̰i. ");
INSERT INTO bjvNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nə e go tɨ kadɨ jɨ ra nḛ kuso jɨ ra-n rɔnəl, tadɔ ngoko̰i kam oy ə təl ɨsɨ kɨ dɔne taa, nay ə e kɨ kɨnge!”» ");
INSERT INTO bjvNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Go tɨ nɨngə Jəju əl njé ndo je ləne ə nə: «Dɨngəm kare kɨ nje nḛ kɨngə aw kɨ nje kɨndə kəmne go nḛ je tɨ kɨ me kəy tɨ ləne no̰o̰. Dɨje rəi əli-e əi nə: “NJe ngəm nḛ je ləi ɨsɨ tujɨ kɨ nḛ kɨngə ləi tɨgə.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","NJe kəy ɓar nje ra kɨlə ləne əl-e ə nə: “Ta ri ə m-ɨsɨ m-o dɔi tɨ ba ə? Ɔjɨ-m go nḛ je kɨ ɔjɨ dɔ kɨlə ləi kɨ me kəy tɨ adɨ-m m-o. Tadɔ kaw kɨ kəte no̰o̰ kɨn, a asɨ kɨndə kəmi go nḛ je tɨ ləm al ngata!” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","NJe ngəm nḛ əl rɔne ə nə: “Ɓam ge kadɨ m-ɨndə kəm go nḛ kɨngə je tɨ kɨ me kəy tɨ al ngata kam, m-a m-ra ri nga am ə? NDɔr dɔnangɨ ə, tɔgɨm asɨ kadɨ m-ndɔr-n al. Kaw kɔy nḛ ə, rɔm a sɔl-m tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","M-gər nḛ kɨ m-a m-ra mba kadɨ dɨje a uwəi-mi kɨ rɔde tɨ me kəy tɨ ləde lokɨ ɓam tuwə-m kɨlə tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Be ə, ɓar njé kɨrə je lə ɓane kare kare. Əl nje kɨrə kɨ dɔsa̰y ə nə: “Kɨrə lə ɓam e ban dɔi tɨ ə?” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","NJe kɨrə kɨ dɔsa̰y ka kɨn ə nə: “Ku yɨbɨ ɓu kare.” Nɨngə əl-e ə nə: “Makɨtɨbɨ kɨrə ləi ən, ɨsɨ nangɨ kalangɨ, ɨndangɨ me tɨ kutɨ mi.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Go tɨ nɨngə əl kɨ nungɨ ə nə: “Ḭ ya̰i e ban ə?” NJe kɨrə kɨ ko̰ joo əl-e ə nə: “Ya̰m e sakɨ gəme ɓu kare.” Nɨngə əl-e ə nə: “Makɨtɨbɨ kɨrə ləi ən, ɨndangɨ me tɨ dɔ jijoo.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Lo kɨn tɨ, ɓa nje nḛ ɨlə tɔjɨ dɔ nje ngəm nḛ tɨ kɨ majal ka kɨn, tadɔ ra nḛ kɨ kəm-kədɨ. Dɨje kɨ gəri Luwə al rai nḛ kɨ kəm-kədɨ ngay me kɨlə rade tɨ dande tɨ ɨtə ngan je lə lo kunjɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Go tɨ, Jəju əl ə nə: «Adɨ m-əl səsi, uwəi madɨ kɨ nḛ kɨngə kɨ go rəbe tɨ al kɨ dɔnangɨ tɨ ne kɨn, mba kadɨ ndɔ kɨ goto jisi tɨ ə, madɨsi je ka kɨn uwəi səsi rɔde tɨ lo kɨsɨ tɨ kɨ ratata. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dəw kɨ ra kɨ asɨ ta kadɨ dəw ade mene dɔ nḛ tɨ kɨ ndə̰y, a asɨ kadɨ dəw ade mene dɔ nḛ tɨ kɨ boy tɔ. Dəw kɨ nje ra nḛ kɨ dana al me nḛ kɨ ndə̰y tɨ, a ra nḛ kɨ dana al me nḛ kɨ boy tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","E be ə, re dəw asɨ kadi mene al dɔ nḛ kɨngə kɨ go rəbe tɨ al kɨ dɔnangɨ tɨ ne kɨn ə, na̰ ə a adi nḛ kɨngə kɨ rɔjetɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Re dəw asɨ kadɨ adi mene al dɔ nḛ tɨ lə dəw kɨ rangɨ ə, na ə a adi ya̰i kɨ sɔbɨ dɔi ə?. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","NJe ra kɨlə madɨ, kɨ a ra kɨlə ɓəə lə ngar je joo goto: re ɔsɨ ta kɨ kare ə, a ndɨgɨ kɨ nungɨ, re kɨdɨ kɨ kare ə, a uwə kɨ nungɨ tɔ. A asi kadɨ ɨrai ɓəə lə Luwə nɨm, ɓəə lə la nɨm al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Parɨsɨ je kɨ njé ge ta lə la, ɨbəi Jəju kogii lokɨ ooi ta je kɨn pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nɨngə Jəju əl-de ə nə: «Ɨrai rɔsi tə dɨje kɨ njé ra nḛ kɨ dana be ta kəm dɨje tɨ, nə Luwə gər mesi. Tadɔ nḛ kɨ dɨje ooi tə nḛ kɨ nga ngay ta kəmde tɨ kɨn, e nḛ to koo al ta kəm Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«NDu-kun ɨlə ngɨre dɔ *Mojɨ tɨ, kɨ njé kəl ta je kɨ ta Luwə tɨ, bɨtɨ dɔkagɨlo tɨ lə Ja̰ Batɨsɨ, nə go tɨ nu kɨn ɓa, dɨje ɨləi mbḛ Poy Ta kɨ Majɨ lə ko̰ɓe lə Luwə, nɨngə dəw kɨ ra, ɨndə tɔgɨne kadɨ ur-n me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dɔra̰ əi kɨ dɔnangɨ a dəi kɔ təkɨ o̰ al be par, nə a nga̰ ngay kadɨ dəw ɔr ngon ku ta kɨ me ndu-kun tɨ lə Luwə kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dɨngəm kɨ ra kɨ tuwə nene, ə taa e kɨ rangɨ, e nje kuwə marɨm. Taa dəw kɨ nje taa dəne kɨ ngawe tuwe ka təl nje kuwə marɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Dɨngəm kare kɨ nje nḛ kɨngə kɨ nje kɨlə kɨbɨ kɨ ndole pɨr pɨr kɨ gate e ngay e no̰o̰. NDɔ je kare kare pətɨ, ɨsɨ ra rɔnəl mbata ɨsɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","NJe ndoo kare kɨ tɔe nə Lajar kɨ do bay ɨndə rɔe yə̰ngɨ yə̰ngɨ, re to ta kəy tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ge kadɨ n-uso burɨm nḛ kuso je kɨ tosi nangɨ ta tabɨlə kuso nḛ tɨ lə nje majɨ. Nə bɨsɨ je yo ta rəi tɔni ta do bay lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","NDɔ kare nje ndoo ka kɨn oy, adɨ malayka je rəi uni-e awi sie kadɨ *Abɨrakam tɨ. NJe majɨ ka re oy tɔ, adɨ dɨbi-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Lokɨ e koo, ɨngə ko̰ ngay. Nɨngə lokɨ un kəmne taa ɓa, oo Abɨrakam sa̰y nu be kɨ Lajar kade tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","NJe majɨ ka kɨn un ndune kɨ taa no̰ ə nə: “Bai Abɨrakam, o kəm-to-ndoo ləm, əl Lajar adɨ ɨlə ta ngon jine man tɨ, kadɨ re sɔl-n ndonm mbata m-ɨngə ko̰ ngay me por tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ə Abɨrakam əl-e ə nə: “NGonm, adɨ mei ole dɔ tɨ təkɨ ndɔ kɨ ɨngə majɨ me dunɨya̰ tɨ, ə Lajar ɨngə nḛ kɨ to tɔ. NGɔsɨne, bɔri man no̰ kəme tɨ, nə ḭ, ḭ me nḛ kɨ to tɨ tɔ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nɨngə kɨ bo tɔy, ngɔsɨne bole ɓe kɨ bo to danje tɨ səsi, adɨ dəw kɨ ge kadɨ n-aw rɔsi tɨ ka, a asɨ kadɨ a man dɔ tɨ aw rɔsi tɨ al, taa dəw a asɨ kadɨ a man dɔ tɨ re rɔjetɨ al nɨm tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ə nje majɨ əl ə nə: “Re e be nɨngə, njai ba, bawm, ɨlə Lajar ade aw əl njé kɨ me kəy tɨ lə bai. ");
INSERT INTO bjvNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tadɔ ndəgɨ ngakom je nayḭ no̰o̰ əi mi ɓəy, ə kadɨ aw ndɔr mbide kadɨ rəi, tḛḛi lo ko̰ tɨ kɨn al ngata.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ə Abɨrakam əl-e ə nə: “NGako̰i je awi kɨ ndu-kun kɨ *Mojɨ ndangɨ kɨ ta je kɨ njé kəl ta kɨ ta Luwə tɨ ndangi no̰o̰. Majɨ kadɨ ooi dɔ ndude.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","NJe majɨ ə nə: “E kɨn asɨ al bawm Abɨrakam. Re dəw madɨ ḭ dan nje koy je tɨ ne ə aw ɨngə-de ə, a mbəli pa njɨyəde.” ");
INSERT INTO bjvNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ə Abɨrakam təl əl-e ə nə: “Re ooi ta lə Mojɨ al nɨm, ta lə njé kəl ta je kɨ ta Luwə tɨ al nɨm ə, kɨn ə dəw ḭ-n dan njé koy je tɨ aw rɔde tɨ ka, a ooi tə ta kɨ rɔjetɨ al wa kɨn.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jəju əl njé ndo je ləne ə nə: «Lo kadɨ dɨje a osi me majal tɨ al goto. Nə kəm-to-ndoo e dɔ dəw tɨ kɨ majal re kɨ takule. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A e sotɨ ngay ɓəy mbata tɨ lie kadɨ dɔɔi mbal kɨ bo ngay mɨnde tɨ, ə ɨləi-e me ba tɨ, ɨtə kadɨ ra adɨ kɨ kare be par dan ngan je tɨ kɨ du ngay kɨn, osɨ, adɨ Luwə gangɨ ta dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɨndəi kəm-kədɨ dɔ rɔsi tɨ! Re ngoko̰i ra majal ə, majɨ kadɨ ɨndange dɔ tɨ, re tu kalne ə, ɨyə̰ go majal lie kɔ ade. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Re ra majal səi nja sɨri me ndɔ tɨ kɨ kare ka, re re rɔi tɨ nja sɨri dəji kɨyə̰ go kɔ ə, ɨyə̰ go kɔ ade. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","*NJé kaw kɨlə je əli Ɓaɓe əi nə: «Ɨlə kadɨ-me dɔ made tɨ ləje adɨ-je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ə Ɓaɓe əl-de ə nə: «Təkɨ rɔjetɨ, re awi kɨ kadɨ-me kɨ e ndɨkɨri ba tə ka̰ kagɨ kɨ ɓari-e mutadɨ kɨn be mɨndɨ ka, asi kadɨ əli kagɨ mbay-kote kam əi nə: “Ɔr kɨ ngɨrəi ba ə aw ɨmə rɔi me ba tɨ”, ə a təl rɔne go ta tɨ ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Re dəw madɨ dansi tɨ aw kɨ nje ra kɨlə madɨ kɨ e nje ndɔr ə se e nje kul da je, ə nje kɨlə kɨn təl wale re ə, a əl-e ə nə: “Ɨre kalangɨ ɨsɨ nangɨ uso nḛ a?” Jagɨ a əl-e ba al. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta kɨ a əl-e ɓa, a əl-e ə nə: “Ɨra rɔi majɨ, ɨra go nḛ kuso ləm, ɨre-n adɨ-m. Nɨngə lokɨ m-ɨsɨ m-uso nḛ je, m-a̰y je kɨn nɨngə, tə go tɨ ḭ uso ya̰i je, a̰y je tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","NGa nɨngə, nḛ kare, dəw kɨn a ra oyo nje kɨlə ləne mbata təl kɨ təl rɔne go ndu je tɨ lie kɨn, al. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Be ə, ta kɨ dɔsi tɨ ka e be tɔ. Lokɨ ɨrai nḛ je pətɨ kɨ Luwə un ndune kadɨ ɨrai nɨngə, majɨ kadɨ əli əi nə: “Je njé ra kɨlə je kɨ nda je goto, jɨ ra kɨlə kɨ sɔbɨ kadɨ jɨ ra par.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lokɨ Jəju ɨsɨ aw Jorijaləm tɨ, ɨndə man mbo̰ dɔnangɨ *Samari tɨ kɨ dɔnangɨ kɨ Galile tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Lokɨ ɨsɨ ur me ngon ɓe tɨ nɨngə, njé banjɨ je dɔgɨ rəi langi tae, ɓa ai nangɨ sa̰y jɔ, ");
INSERT INTO bjvNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","uni ndude kɨ taa əli-e əi nə: «Jəju, nje ndo dɨje, oo kəm-to-ndoo ləje!» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Lokɨ oo-de nɨngə əl-de ə nə: «Awi ɔji rɔsi njé kɨjə nḛ məsɨ kadɨ-kare je.» Nɨngə dɔ rəbɨ kawde tɨ ɓəy par ə, ɨngəi rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kɨ kare dande tɨ, lokɨ oo kadɨ ɨngə rɔ nga nɨngə, təl dɔ njane tɨ, kɨ kɨlə tɔjɨ dɔ Luwə tɨ, kɨ ndune kɨ bo. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Re osɨ kɨ ta kəmne nangɨ no̰ Jəju tɨ, ra-e oyo. E dɨngəm kɨ Samari tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ə Jəju əl ə nə: «NJé banjɨ je kɨ dɔgɨ pətɨ ɨngəi rɔ nga, ə njé kɨ jikare awi ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","MBo̰de tɨ pətɨ, dəw kare kɨ təl re ɨlə tɔjɨ dɔ Luwə tɨ goto. Dəw ɓa, e dəw kɨ Samari tɨ kɨn kɨ karne ba par. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nɨngə Jəju əl dəw kɨ Samari tɨ ka kɨn ə nə: «Ḭ taa aw, tadɔ kadɨ-me ləi aji.» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","NDɔ kare *Parɨsɨ je dəji Jəju ta kɨ ɔjɨ dɔ dɔkagɨlo re ko̰ɓe lə Luwə. Ə Jəju əl-de ə nə: «Ko̰ɓe lə Luwə a re tə nḛ kɨ dɨje a ooi-e kɨ kəmde nja̰ nja̰ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","A e kɨ kəl kə nə: “E yo ɓo”, “E ne ɓo”, al. Təkɨ rɔjetɨ, ko̰ɓe lə Luwə e dansi tɨ ne ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Go tɨ nɨngə əl njé ndo je ə nə: «NDɔ madɨ a re no̰o̰ kɨ a ndɨngəi ngay kadɨ oi ndɔ kare me ndɔ je tɨ lə NGon Dəw, nə lo kadɨ a oi goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nɨngə a əli səsi əi nə: “Kɨrɨsɨ e yo”, “Kɨrɨsɨ e ne”, nə awi al, a̰yḭ-naa ngɔdɨ awi loe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nɨngə, təkɨ ndi təl ə lo ay njay njay, ḭ dam dɔnangɨ tɨ kɨ kare tḛḛ-n dame tɨ kɨ nungɨ ka kɨn ə, ndɔ rem mi *NGon dəw ka a to be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nə kəte no̰ tɨ, sɔbɨ kadɨ mi NGon Dəw m-ɨngə ko̰ ngay, kadɨ dɨje kɨ dɔkagɨlo tɨ kɨ ɓone kɨn mbati-mi ɓəy taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nɨngə, ko nḛ kɨ ra nḛ dɔkagɨlo tɨ lə Nuwe kɨn ə, nḛe a ra nḛ ndɔ kɨ mi NGon dəw m-a m-re-n tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dɨje usoi je, a̰yḭ-naa je, taai-naa kɨ yo je kɨ ne je, bɨtɨ ndɔ tɨ kɨ Nuwe ur-n me bato tɨ. Go tɨ nɨngə man ko̰ kɨ bo re tujɨ dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A to tə nḛ kɨ ra nḛ dɔkagɨlo tɨ lə Lotɨ be tɔ: Dɨje usoi je, a̰yḭ-naa je, ndogi nḛ je nɨm, gati kɨ nḛ je nɨm, məi kagɨ je nɨm, rai kəy je nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nə ndɔ kɨ Lotɨ tḛḛ-n me ɓe bo tɨ kɨ Sodom, Luwə adɨ ndi por kɨ nḛ je kɨ njé taa por ḭ dɔra̰ tɨ o̰ dɨje tɔl-de pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","NDɔ kɨ mi NGon dəw m-a m-tḛḛ hɔy ka, nḛ je a rai nḛ be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Me ndɔe tɨ kɨn, dəw kɨ ɨsɨ dɔ kəy tɨ, a ur nangɨ kadɨ ɔy nḛ je ləne kɨ me kəy tɨ tḛḛ-n taga al. Be tɔ ə, dəw kɨ a e me ndɔr tɨ ka, a təl re ɓe al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Adɨ mesi ole dɔ nḛ tɨ kɨ tḛḛ dɔ ne Lotɨ tɨ, kɨ ɨlə rətɨ ə ɨngə yo kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dəw kɨ sangɨ kadɨ n-ngəm rɔne kɨ no̰ tɨ, a tḭ ta rɔne. Nə dəw kɨ tḭ ta rɔne mbata ləm ə, a ngəm rɔne kɨ no̰ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Adɨ m-əl səsi, me kondɔe tɨ kɨn, dɨje joo a toi dɔ tɨrə tɨ nɨngə, a uni kɨ kare, a ɨyə̰i kɨ nungɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dəne je joo, a uri nḛ naa tɨ, a uni kɨ kare ə, a ɨyə̰i kɨ nungɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dɨngəm je joo, a rai kɨlə me ndɔr tɨ kɨ kare ə, a uni kɨ kare ə a ɨyə̰i kɨ nungɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nɨngə, njé ndo je dəji Jəju əi nə: «Ɓaɓe, lo kɨ ra tɨ ə, nḛ je kɨn a rai nḛ ə?» Ə əl-de ə nə: «Lokɨ nɨn a to tɨ, e ə mal je a kawi-naa tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jəju əl kujɨ ta madɨ njé ndo je ləne, tɔjɨ-n-de kadɨ əli ta kɨ Luwə taa taa, ɓɨ kadɨ tɔgɨde goto ta tɨ al, ");
INSERT INTO bjvNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ə nə: «NJe gangɨ ta kare ɨsɨ ɓe bo tɨ madɨ no̰o̰. E dəw kɨ ɓəl Luwə al nɨm, taa ɨlə kojɨ dɔ dəw tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nɨngə me ɓe bo tɨ ka kɨn, dəne kare kɨ nje ngaw koy ɨsɨ tɨ no̰o̰ tɔ. Dəne ka kɨn re kɨ dɔkagɨlo je pətɨ əl-e ə nə: “Ɨgangɨ ta ka kɨ to danje tɨ kɨ nje ta ləm ka kɨn adɨ-m.” ");
INSERT INTO bjvNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","NJe gangɨ ta ka kɨn mbatɨ dɔkagɨlo ngay. Nə təl əl ta rɔne ə nə: “Re m-ɓəl Luwə al nɨm, taa m-ɨlə kojɨ dɔ dəw madɨ tɨ kare al ka, ");
INSERT INTO bjvNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dəne kɨ nje ngaw koy kam tapɨ-m ngay. Sɔbɨ kadɨ m-gangɨ ta lie made, mba kadɨ təl re gogɨ ndɔ kɨ rangɨ tɨ, tapɨ-m ɓəy al ngata.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɓaɓe ɨlə dɔ tɨ ɓəy ə nə: «Majɨ kadɨ oi ta kɨ nje gangɨ ta kɨ dana al, əl kɨn majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Səi oi kadɨ Luwə a gangɨ ta kɨ dana adɨ dɨje lie kɨ ɨsɨ no̰i dɔe tɨ kondɔ je kɨ kada je kɨn al a? A ɨsɨ gərərə ba ɓɨ a ra səde al a? ");
INSERT INTO bjvNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Adɨ m-əl səsi, a gangɨ ta kɨ dana kalangɨ ba adɨ-de. Nə nḛ kare ɓa, se ndɔ kɨ mi NGon Dəw m-a m-təl m-re ə, m-a m-ɨngə dɨje kɨ adɨ mede dɔnangɨ tɨ wa mɨndɨ wa?» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jəju əl kujɨ ta kɨ dɔ njé je tɨ kɨ ooi rɔde tə dɨje kɨ dana ə kɨdi ndəgɨ dɨje ");
INSERT INTO bjvNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ə nə: «Dɨngəm je joo, awi kəy kaw-naa tɨ mba kəl ta kɨ Luwə; kɨ kare e Parɨsɨ, kɨ nungɨ e nje taa la-mbə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parɨsɨ ḭ a taa ə əl ta kɨ ɔjɨ dɔ rɔne mene tɨ ə nə: “Luwə ləm, m-ra-i oyo tadɔ mi m-to tə ndəgɨ dɨje kɨ njé ɓogɨ je ə se njé ra nḛ je kɨ go tɨ al, kɨ njé kuwə marɨm, taa tə nje taa la-mbə kam al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me ndɔ je tɨ kɨ sɨri, m-ɔgɨ rɔm nḛ kuso tɨ nja joo, madɨ Luwə nḛ kare me kɨ dɔgɨ tɨ, me nḛ kɨngə je tɨ ləm pətɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nə nje taa la-mbə ɓa, ɔsɨ rɔne ngərəngɨ nu, kun ka ge kun kəmne kɨ dɔra̰ tɨ al, ra rɔne ndoo, ə əl ə nə: “Luwə ləm, oo kəm-to-ndoo ləm tadɔ mi nje ra majal!” ");
INSERT INTO bjvNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Adɨ m-əl səsi, e nje taa la-mbə ə təl aw ɓe ləne kɨ ta kɨ kɔr dɔ tɨ no̰o̰ Luwə tɨ, ɓɨ e Parɨsɨ al. Tadɔ dəw kɨ un dɔne taa ə, a ɨləi dɔe nangɨ, nɨngə dəw kɨ ɨlə dɔne nangɨ, a uni dɔe taa tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","NGan je kɨ kasɨ wa kɨn ka, dɨje rəi səde rɔ Jəju tɨ mba kadɨ njangɨ dɔde. Nə lokɨ njé ndo je ooi nḛ kɨn ɓa, kɔli səde. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nə Jəju adɨ rəi kɨ ngan je kɨ du rɔe tɨ ɓa əl ə nə: «Ɨyə̰i ngan je kɨ du adɨ rəi rɔm tɨ, otɨ kadɨ ɔgi-de ta rəbɨ, tadɔ ko̰ɓe lə Luwə e ya̰ dɨje kɨ toi tə ngan je kɨ du be. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ ndɨgɨ kadɨ Luwə o̰ ɓe dɔe tɨ tə ngon kɨ du be, al, a ur ko̰ɓe tɨ lə Luwə al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kɨ bo lə *Jɨpɨ je kare, dəjɨ Jəju ə nə: «NJe ndo kɨ majɨ, e ri ə m-a m-ra ə m-a m-ɨngə-n kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ə Jəju əl-e ə nə: «MBa ri ə ɨɓar-m dəw kɨ majɨ ə? Dəw kare kɨ majɨ goto, nə Luwə kɨ karne ba par ə e dəw kɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ḭ ɨgər ndu-kun je lə Luwə kɨ ə nə: “A uwə marɨm al, a tɔl dəw al, a ɓogɨ al, a ma najɨ kɨ ngom dɔ madi tɨ al, a ɔsɨ gon bawi kɨ ko̰i.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nɨngə dɨngəm təl əl Jəju ə nə: «Nḛ je kɨn pətɨ m-təl rɔm go tɨ dɔkagɨlo kɨlə ngɨrə basam tɨ nu.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Go ta je tɨ kɨn Jəju əl-e ə nə: «Nḛ kare be ə nayḭḭ kadɨ ɨra ɓəy. Aw ɨgatɨ kɨ nḛ kɨngə je ləi pətɨ, ɨləbɨ lae njé ndoo je, ɓa a aw kɨ nḛ kɨngə ngay me dɔra̰ tɨ, ə ɨre un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nə lokɨ ta kɨn osɨ mbi dɨngəm tɨ ka kɨn, rɔe təl nəl-e al, tadɔ e dəw kɨ nḛ kɨngə lie e ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lokɨ Jəju oo-e kadɨ mee o̰-e nɨngə əl ə nə: «E nḛ kɨ nga̰ ngay rɔ njé nḛ kɨngə je tɨ kadɨ uri me ɓeko̰ tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","E nḛ kɨ nga̰ ngay wa kadɨ jambal kɨ oi-e kɨn ur bole kon ku nḛ tɨ, nə a nga̰ ngay ɨtə e kɨn ɓəy kadɨ nje nḛ kɨngə ur me ɓeko̰ tɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","NJé kɨ ɨsɨ ooi dɔ ta lə Jəju əli əi nə: «NGa kɨn ə e be nɨngə, na̰ ə asɨ kadɨ ɨngə kajɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jəju ɨlə-de tɨ ə nə: «Nḛ kɨ dəw asɨ al, Luwə asɨ ra.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pɨyər əl-e ə nə: «NGa je kɨn, j-ɨyə̰ nḛ kɨngə je ləje pətɨ kɔ, ə j-un goi kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jəju əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, re dəw madɨ, ɨyə̰ kəy ləne, kɨ nene, kɨ ngane je, kɨ ngakone je, kɨ nojɨne je, kɨ mbata ko̰ɓe lə Luwə ə, ");
INSERT INTO bjvNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a ɨngə nḛ je al dɔ e kɨn, dɔkagɨlo tɨ kɨ ɓone, taa dɔkagɨlo tɨ kɨ a re, a ɨngə kajɨ kɨ a to bɨtɨ kɨ no̰ tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jəju ɓar njé ndo je ləne kɨ dɔgɨ gɨde e joo kɨ rɔne tɨ, nɨngə əl-de ə nə: «Oi, j-ɨsɨ j-awi kɨ Jorijaləm tɨ, nḛ je pətɨ kɨ njé kəl ta je kɨ ta Luwə tɨ ndangi ɔjɨ dɔm mi *NGon dəw, a tɔli tade. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tadɔ a ɨləi-mi ji dɨje tɨ kɨ əi *Jɨpɨ je al kadɨ tə kogi dɔm tɨ je, taji-mi je, taa a tɨbi man tade dɔm nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Go tɨ, lokɨ tɨndəi-mi kɨ ndəy kabɨlay nɨngə, a tɔli-mi. Nə ndɔ mɨtə lə ndɔ koym ɓa, m-a m-tḛḛ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nə nḛ kare kɨ njé ndo je gəri me ta tɨ kɨn goto. E ta kɨ to lo ɓɔyɔ tɨ rɔde tɨ. Gəri me ta kɨ Jəju ge kəl-de al. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lokɨ Jəju e ɓasi kɨ ɓe kɨ Jəriko nɨngə, nje kəm tɔ madɨ ɨsɨ ngangɨ rəbɨ tɨ no̰o̰, ɨsɨ kɔy nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lokɨ nje kəm tɔ oo ka kosɨ dɨje kɨ ɨsi ɨndəi də bur bur nɨngə, dəjɨ ta se ri ə ɨsɨ ra nḛ wa. ");
INSERT INTO bjvNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ə əli-e əi nə: «Jəju kɨ Najarətɨ ə ɨsɨ ɨndə də.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","NJe kəm tɔ ɨlə ngɨrə kadɨ un ndune kɨ taa, ə no̰ kɨ tɔgɨne, ə nə: «Jəju kɨ NGon ka Dabɨdɨ, o kəm-to-ndoo ləm!» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dɨje kɨ njé njɨyə kəte no̰ dɨje tɨ kəngi-e kəngɨ kadɨ utɨ tane, nə nje kəm tɔ un ndune kɨ taa dɔ made tɨ ɓəy ə nə: «NGon ka *Dabɨdɨ, o kəm-to-ndoo ləm!» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jəju a lo ka tɨ, ɓa un ndune kadɨ rəi sie rɔne tɨ ne. Lokɨ re rɔe tɨ ɓasi nɨngə, Jəju dəje ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«E ri ə ɨge kadɨ m-ra madi ə?» Ə nje kəm tɔ əl-e ə nə: «Ɓaɓe, m-ge kadɨ kəm oo lo!» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jəju əl-e ə nə: «O lo! Kadɨ-me ləi aji.» ");
INSERT INTO bjvNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Par ə, loe tɨ no̰o̰, kəme oo lo, adɨ un go Jəju kɨ kɨlə tɔjɨ dɔ Luwə tɨ tane tɨ. Lokɨ kosɨ dɨje ooi nḛ kɨn nɨngə, ɨləi ngɨrə kɔsɨ-gon Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lokɨ Jəju ur me ɓe tɨ kɨ Jəriko ə ɨsɨ ɨndə də nɨngə, ");
INSERT INTO bjvNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","dɨngəm kɨ nje nḛ kɨngə kare kɨ tɔe nə Jase, kɨ e boy dɔ njé taa la-mbə je tɨ ɨsɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dɨngəm kɨn sangɨ kadɨ n-oo se Jəju e na̰ dana wa, nə lo kadɨ oo Jəju goto, mbata kosɨ dɨje, tadɔ e dəw kɨ gɔjɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Be ə, a̰y ngɔdɨ kəte, aw al dɔ kagɨ mbay-kote tɨ, kadɨ n-oo Jəju kɨ a man kɨ rəbɨ kɨ loe tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lokɨ Jəju re tḛḛ loe tɨ ka kɨn nɨngə, un kəmne kɨ taa, əl Jase ə nə: «Jase, ur nangɨ ne law, tadɔ sɔbɨ kadɨ m-ɨsɨ me kəy tɨ ləi ɓone.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lo kɨn tɨ, Jase ur nangɨ law, uwə Jəju rɔne tɨ kɨ rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dɨje pətɨ kɨ ooi nḛ kɨn, ɓai ta dɔ Jəju tɨ əli əi nə: «Aw ɨsɨ ɓe lə nje ra majal.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nə Jase a taa, əl Ɓaɓe ə nə: «Ɓaɓe, m-a m-adɨ nusɨ nḛ kɨngə ləm njé ndoo je. A kɨn ə re m-taa nḛ lə dəw kɨ al dɔ majɨ ə, m-a m-təl m-ɨge kɨre gogɨ nja sɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lo kɨn tɨ, Jəju əl-e ə nə: «Ɓone səi kɨ njé kɨ me kəy tɨ ləi ɨngəi kajɨ, tadɔ ḭ ka ḭ ngon ka *Abɨrakam tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tadɔ kɨ rɔjetɨ, mi *NGon dəw m-re mba kadɨ m-sangɨ dɨje kɨ tade tḭ, m-ajɨ-de.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jəju e ɓasi kɨ Jorijaləm adɨ dɨje ooi kadɨ ko̰ɓe lə Luwə a ɔdɨ rɔne loe tɨ no̰o̰. Lokɨ dɨje uri mbide ɨsɨ oi ta kɨ Jəju ɨsɨ əl-de ba ɓəy nɨngə, Jəju un kujɨ ta kare tane tɨ kadɨ ");
INSERT INTO bjvNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","əl-de ə nə: «Dɨngəm kare kɨ oji-e me majɨ tɨ ɨsɨ aw ɓe madɨ tɨ kɨ sa̰y kadɨ ɨndəi jagɨ ngar dɔe tɨ ɓəy taa tə təl. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Be ə, kəte ɓəy taa kadɨ aw, ɓar njé kɨlə je ləne dɔgɨ, adɨ dəw kɨ ra dande tɨ mbal ɔr kare, nɨngə əl-de ə nə: “Ɨtaai, ɨrai gatɨ bɨtɨ kadɨ m-təl m-re m-ɨngə-n səsi.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nə dɨje kɨ me ɓe tɨ lie ḭḭ gɨne tɨ, ə ɨləi dɨje goe tɨ əli əi nə: “Jɨ ndɨgɨ al kadɨ dəw kɨn re ɨsɨ ngar dɔje tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Be ka, ɨndəi jɔgɨ ngar dɔe tɨ. Be ə, lokɨ təl re ɓe nɨngə, ɓar njé kɨlə je ləne kɨ adɨ-de la ka kɨn kadɨ n-oo se e ri ə rai wa. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dəw kɨ dɔ kəte re, nɨngə əl ə nə: “Ɓam, mbal ɔr kɨ kare kɨ adɨ-m ka, yə m-ɨngə dɔgɨ dɔ tɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ə ngar əl-e ə nə: “Majɨ ngay, ḭ nje kɨlə kɨ majɨ. Nɨngə təkɨ a-n dana me kɨndə kəm go nḛ tɨ kɨ ndə̰y be, m-ɨndə-i nje ko̰ɓe dɔ ɓe bo je tɨ dɔgɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Dəw kɨ ko̰ joo re, nɨngə əl ə nə: “Ɓam, mbal ɔr kɨ kare kɨ adɨ-m ka, yə m-ɨngə mi dɔ tɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ə ngar əl-e ko ta wa ka kɨn tɔ ə nə: “Ḭ, ɨsɨ tə nje ko̰ɓe dɔ ɓe bo je tɨ mi.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","E kɨ rangɨ re nɨngə əl ə nə: “Ɓam, mbal ɔr kɨ kare kɨ adɨ-m ka yə to kɨn, m-aw m-ɓɔyɔ-e ta kɨbɨ tɨ m-ade to. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tadɔ m-ɓəli. Ḭ, ḭ dəw kɨ nga̰ ngay, nḛ kɨ ɨndə al ka un nɨm, nḛ kɨ ɨdɨbɨ al ka ɨtətɨ nɨm.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lo kɨn tɨ ngar əl-e ə nə: “Ḭ nje kɨlə kɨ majal. Nɨngə m-a m-gangɨ ta dɔi tɨ kɨ ta kɨ tḛḛ tai tɨ ḭ wa. Ḭ ɨgər majɨ kadɨ mi dəw kɨ nga̰ ngay, nḛ kɨ m-ɨndə al ka m-un nɨm, nḛ kɨ m-dɨbɨ al ka m-tətɨ nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","NGa ra ban be ə re a ɨndə la ləm lo ngəm la tɨ al ə? Re ɨndə lo ngəm la tɨ ə, m-təl kɨn re m-a m-taa kɨ mane dɔ tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Go tɨ ngar əl dɨje kɨ ai loe tɨ no̰o̰ ə nə: “Ɨtaai mbal ɔr kɨ kare kɨ jie tɨ kɨn adi e kɨ aw kɨ mbal ɔr dɔgɨ kɨn.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ə dɨje əli ngar əi nə: “E kam aw kɨ mbal ɔr dɔgɨ ngata.” ");
INSERT INTO bjvNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nə ngar əl-de ə nə: “M-əl səsi təkɨ, dəw kɨ aw kɨ nḛ jine tɨ, a adi-e dɔ tɨ, nə dəw kɨ nḛ lie goto, e kɨ ndɨkɨri wa kɨ aw-n kɨn ka a taai jie tɨ wa ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nɨngə njé ba̰ je ləm, kɨ mbati kadɨ mi ngar dɔ tɨ, ɨrəi səde, ɨtɔli-de ta kəm tɨ ne.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Go ta je tɨ kɨn, Jəju gangɨ kəte no̰ kosɨ je tɨ, un rəbɨ kɨ kaw kɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lokɨ Jəju re tḛḛ ɓasi kɨ ɓe kɨ Bətɨpaje əi kɨ ɓe kɨ Bətani, kɨ kaw kɨ kadɨ mbal je tɨ kɨ ɓari-de mbal kagɨ bɨni je kɨn ɓa, ɨlə njé ndo je ləne joo ");
INSERT INTO bjvNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ə nə: «Awi me ngon ɓe tɨ kɨ a no̰si tɨ kam. Lokɨ a uri kɨ me ɓe tɨ, a ɨngəi ngon koro kɨ dɔɔi-e adɨ a. E ngon koro kɨ dəw al gɨde tɨ nja kare al ɓəy. Ɨtuti-e, ɨrəi sie adi-mi. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A re dəw madɨ dəjɨ səsi ə nə: “MBa ri ə ɨsɨ ɨtuti ngon koro kɨn” ə, əli-e əi nə: “E Ɓaɓe ə ge-e.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","NJé kɨ Jəju ɨlə-de ka kɨn awi nɨngə yə, ɨngəi nḛ je təkɨ wa kɨ Jəju əl-n-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Be ə, tuti ngon koro ka kɨn nɨngə, ɓa njé koro je dəji-de əi nə: «MBa ri ə ɨtuti ngon koro kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nɨngə njé ndo je ɨləi-de tɨ əi nə: «Ɓaɓe ə ge-e.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lokɨ rəi kɨ ngon koro ka kɨn adi Jəju ɓa, labi kɨbɨ je ləde gɨde tɨ, ə adi Jəju al ɨsɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kɔtɨ wa kɨ ɨsɨ ɔti kəte kəte kɨn ɓa, dɨje labi kɨbɨ je ləde dɔ rəbɨ tɨ adi-e njɨyə dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lokɨ Jəju ɨsɨ re ɓasi kɨ Jorijaləm tɨ kɨ rəbɨ kɨ ḭ kɨ dɔ mbal kagɨ bɨni je tɨ kɨn ɓa, kosɨ njé ndo je lie, rɔde nəl-de ngay adɨ uni ndude kɨ taa, pɨtii Luwə mbata nḛ kɔjɨ je pətɨ kɨ ra adɨ oi kɨ kəmde, ");
INSERT INTO bjvNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","əi nə: «Kadɨ Luwə njangɨ dɔ ngar kɨ re kɨ tɔ Ɓaɓe! Kadɨ Lapɨya re kɨ dɔ dɔra̰ tɨ, ə tɔɓa e kɨ dɔ Luwə tɨ kɨ ɨsɨ taa dɔ dɔra̰ tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","*Parɨsɨ je madɨ kɨ əi dan kosɨ je tɨ əli Jəju əi nə: «Ɓaɓe, əl njé ndo je ləi adɨ uri tade naa tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ə Jəju əl-de ə nə: «M-əl səsi m-adɨ oi, re əi je uri tade naa tɨ ə, gajɨ mbal je a sɨngəi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lokɨ Jəju ɨndə dɔ ɓe kɨ Jorijaləm ɓasi ə un kəmne oo-e-n nɨngə, man no̰ re kəme tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Man no̰ re kəme tɨ adɨ əl ə nə: «Kɨn ə re dɔkagɨlo kɨ je tɨ ɓone kɨn, ḭ wa ɨgər rəbɨ lapɨya kɨn ə re a e sotɨ səi, nə kəmi tḛḛ dɔ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","NDɔ je kɨ nga̰ a rəi no̰o̰ kadɨ njé ba̰ je ləi a ɨləi-naa gəi dɔi, a ɨləi-naa kɨ ta tɔ rəbɨ je pətɨ, a uti-ni nguy lo kadɨ ɨtḛḛ goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A budi-ni nangɨ mur mur kɨ dɨje ləi. MBal madɨ kɨ kadɨ dəw a ɨyə̰ adɨ ɨsɨ dɔ made tɨ goto. Tadɔ kəmi tḛḛ dɔ dɔkagɨlo tɨ kɨ Luwə re-n kadɨ ra-n səi kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Go tɨ, Jəju aw ur natɨ kəy tɨ lə Luwə, nɨngə ɨlə rɔne tuwə njé labɨ nḛ je tɨtɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nɨngə əl-de ə nə: «NDangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Kəy ləm a ɨɓari-e kəy kəl ta kɨ Luwə, nə səi, ɨtəli-e lo ɓɔyɔ rɔ tɨ lə njé ɓogɨ je yo.”» ");
INSERT INTO bjvNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","NDɔ je pətɨ, Jəju ndo dɨje nḛ gɨn kəy tɨ lə Luwə. Lo kɨn tɨ, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé ndo ndu-kun je, kɨ njé kun dɔ dɨje me ɓe, sangi rəbɨ kadɨ n-tɔli Jəju, ");
INSERT INTO bjvNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nə gəri rəbe al, tadɔ kosɨ je ɨndəi mbide majɨ ngay go ta tɨ lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","NDɔ kare, Jəju ɨsɨ ndo dɨje nḛ me kəy tɨ lə Luwə, ɨlə-n mbḛ Poy Ta kɨ Majɨ nɨngə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, kɨ ngatɔgɨ je, tḛḛi no̰o̰ rəi. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lokɨ rəi nɨngə əli-e əi nə: «Əl-je adɨ j-o, e kɨ tɔgɨ kɨ ḭ ra ə ɨsɨ ra-n nḛ je kɨn be ə? Ə na̰ tɔ ə adi ndune ə ɨsɨ ɨra-n ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ə Jəju təl əl-de ə nə: «Mi ka m-a m-dəjɨ səsi ta kare kadɨ əli-mi adɨ m-o tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Na̰ ə ɨlə Ja̰ kadɨ ra dɨje batəm ə? E Luwə ə se e dɨje?» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nə təli a məri ta dande tɨ əi nə: «Re j-əl-e j-ə nə: “E Luwə ə ɨle” ə, a dəjɨ-je ə nə se ra ban ə j-ade meje al wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A kɨn ə re j-əl j-ə nə: “E dɨje ə ɨləi Ja̰” ə, kosɨ je ba pətɨ a tɨləi-je kɨ mbal tɔli-je, tadɔ gəri majɨ ngay kadɨ Ja̰ e nje kəl ta kɨ ta Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Be ə, təli əli Jəju təkɨ n-gəri dəw kɨ ɨle al. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ə Jəju ɨlə-de tɨ ə nə: «Re ɨgəri al ə, mi ka m-a m-əl səsi tɔgɨ kɨ m-ɨsɨ m-ra-n nḛ je kɨn al tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Go tɨ, Jəju ɨlə rɔne əl ta *Jɨpɨ je me kujɨ ta tɨ ə nə: «Dɨngəm kare ndɔr nju, nɨngə dɔɔi ta naa tɨ kɨ dɨje kɨ njé ra kɨlə nju, kadɨ tə rai kɨle adi-e, ə kagɨ loe tɨ ɓa, a ka̰yḭ-naa nḛe, nɨngə e wa ɔtɨ aw mba kɨ goe ngal. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lokɨ kagɨ lo kɨjə kandɨ nju asɨ nɨngə, ɨlə ɓəə ləne kare kadɨ aw taa kandɨ nḛ ndor ka kɨn, kɨ ya̰ne ji njé ra kɨlə je tɨ adɨ-ne. Nə lokɨ ɓəə aw nɨngə, njé ra kɨlə je, tɨndəi-e ngay, ə tuwəi-e adɨ təl kɨ jine kare aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","NJe ndɔr təl ɨlə ɓəə kɨ rangɨ ɓəy. Nə e ka, tɨndəi-e je, taji-e je, ə tuwəi-e adɨ təl kɨ jine kare aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Be ka dɨngəm ka kɨn təl ɨlə ɓəə kɨ nje ko̰ mɨtə ɓəy. Ɓa e kɨ nje ko̰ mɨtə kɨn, njé ra kɨlə je ka kɨn tɨndəi-e, adi-e do, ə tuwəi-e adi-e aw. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Lo kɨn tɨ, nje ndɔr dəjɨ ta rɔne ə nə: “E ri ə kadɨ m-ra ə? M-a m-ɨlə kɨ ngonm kɨ dɨngəm kɨ m-ndɨge ngay kɨn. E ə, a ɓəli gɨde.” ");
INSERT INTO bjvNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nə njé ra kɨlə nju, lokɨ kəmde osɨ dɔ ngone tɨ ɓa, əli-naa ta kɨn dande tɨ əi nə: “Darɔe e wa kam ə a e nje nḛ nduwə. Jɨ tɔli-e j-adi ndɔr nju kɨn təl nḛ ləje!” ");
INSERT INTO bjvNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Be ə, ndɔri ngon ka kɨn, awi sie gɨdɨ ndɔr tɨ taga, tɔli-e. Ə se dɨngəm kɨ nje ndɔr kɨn a ra səde ban wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A re kadɨ tɔl njé ra kɨlə je kɨn kɔ, ə sangɨ njé kɨ rangɨ ɨndə-de ta ndɔr tɨ.» Lokɨ dɨje ooi ta kɨ Jəju əl kɨn ɓa, əli əi nə: «Jagɨ, nḛ kɨn a re nḛ ba al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nə Jəju go̰-de ba nɨngə əl-de ə nə: «Ta kɨ makɨtɨbɨ lə Luwə əl ə nə “MBal kɨ njé ra kəy je mbati-e, E ə təl mbal kɨ e tɔgɨ kəy,” kɨn me nə ri ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Dəw kɨ ra kɨ osɨ dɔ mbal tɨ kɨn ə, a tətɨ njəkɨ njəkɨ, a re e ə mbal kɨn ə osɨ dɔe tɨ tɔ nɨngə, a rəkɨte rəkɨtə rəkɨtə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","NJé ndo ndu-kun je, kɨ kɨ bo je kɨ dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ, sangi rəbɨ kadɨ n-uwəi Jəju loe tɨ wa kɨn no̰o̰, tadɔ gəri majɨ kadɨ kujɨ ta kɨ Jəju əl kɨn sɔbɨ dɔde, nə ɓəli kosɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Be ə, ɨndəi kəmde go Jəju tɨ, ɓa ɨləi dɨje madɨ kɨ rai rɔde tə dɨje kɨ dana be rɔe. Ɨləi-de rɔe tɨ mba kadɨ tə me ta tɨ kɨ a tḛḛ tae tɨ kɨn ɓa, n-uwəi-e-n, n-ɨləi-e ji njé ko̰ɓe je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dɨje ka kɨn dəji Jəju əi nə: «NJe ndo dɨje, jɨ gər kadɨ ḭ nje kəl ta kɨ rɔjetɨ, taa ḭ nje ndo nḛ kɨ rɔjetɨ tɔ. Kɔr kəm dəw dana goto rɔi tɨ, ɨsɨ ɨndo dɨje rəbɨ kɨ rɔjetɨ kɨ nəl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ə əl-je adɨ j-o: e loe tɨ ə se e loe tɨ al kadɨ j-ɨgə la-mbə nje ko̰ɓe kɨ bo Səjar ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nə Jəju kɨ gər kadɨ ɨsɨ ədi kəme, əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Adi-mi sɨlə kare adi-mi m-o, se dɔ na̰ ə ɨndəi tɨ, ə tɔ na̰ tɔ ə ndangi tɨ wa?» Nɨngə əli əi nə: «E nje ko̰ɓe kɨ bo Səjar.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","NGata ə Jəju əl-de ə nə: «Nḛ lə Səjar ə adi Səjar, nḛ lə Luwə ə adi Luwə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lo kɨn tɨ, lo kadɨ uwəi Jəju kɨ ta kɨ tae tɨ no̰ kosɨ je tɨ goto. Ta kɨ tur-de tɨ kɨn dum dɔde, adɨ ai tade mbə. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ɓa go tɨ, *Sadusɨ je kɨ əi dɨje kɨ njé majɨ təkɨ njé koy je a ḭḭ taa lo koy tɨ al, kɨ madɨ je dande tɨ, rəi rɔ Jəju tɨ dəji-e əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«NJe ndo dɨje, *Mojɨ ndangɨ ndu kɨn me makɨtɨbɨ tɨ adɨ-je ə nə: “Re dəw madɨ, ngoko̰e taa dəne, ə ngoko̰e ka kɨn ojɨ ngan je kɨ dəne ka kɨn al ɓəy ə oy nɨngə, sɔbɨ kadɨ taa dəne nduwə kɨn ojɨ-n ngan je kadɨ tḛḛi to nje goto tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɨngə kɨ ɔjɨ dɔ ta kɨn, ngakonaa je əi sɨri. Kɨ dɔsa̰y taa dəne, ə ojɨ-n ngon al ɓəy par ə oy. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kɨ ko̰ joo re taa dəne nduwə ka kɨn, ɓa kae tɨ wa ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Re tḛḛ dɔ kɨ ko̰ mɨtə be, adɨ ngakonaa je kɨ sɨri kɨn, taai dəne kɨ kare kɨn pətɨ, ɓa oyi kɨ kanjɨ kadɨ dəw kare dande tɨ ojɨ sie ngon. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta tɔl tae ə, darɔ dəne wa re oy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","NGa ə se ndɔ kɨ njé koy je a ḭḭ taa lo koy tɨ ə, na̰ dande tɨ ə dəne ka kɨn a e nee wa? Tadɔ əi sɨri pətɨ taai-e nede tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ə Jəju əl-de ə nə: «Dɔnangɨ tɨ ne kɨn ə dɨngəm je kɨ dəne je ɨsɨ taai-naa. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nə dɨje kɨ Luwə oo-de kadɨ asi kadɨ a ḭḭ taai lo koy tɨ, kadɨ ɨsi me ɓeko̰ tɨ kɨ sɨgɨ, a taai-naa al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Taa a oyi al tɔ, tadɔ a toi tə malayka je be. Əi ngan lə Luwə tadɔ Luwə adɨ-de ḭḭ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nɨngə ta kḭ kɨ nə njé koy a ḭḭ taa lo koy tɨ, Mojɨ wa əl ta ay njay dɔ tɨ kadɨ njé koy je a ḭḭ taa lo koy. Lokɨ əl ta ɔjɨ-n dɔ por kɨ o̰ me nga̰ tɨ, Mojɨ ɓar Luwə ə nə: “Luwə lə *Abɨrakam, Luwə lə *Isakɨ, kɨ Luwə lə Jakobɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nɨngə Jəju ɨlə dɔ tɨ təkɨ Luwə e Luwə lə dɨje kɨ njé kɨsɨ kəm ba, ɓɨ e Luwə lə njé koy je al. Tadɔ ta kəm Luwə tɨ, dɨje pətɨ ɨsi kɨ dɔde taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lo kɨn tɨ, njé ndo dɨje ndu-kun kɨ na̰ je əli Jəju əi nə: «NJe ndo dɨje, əl ta majɨ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nɨngə sangi kadɨ n-dəji-e ta kɨ rangɨ al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jəju dəjɨ-de ta ə nə: «Ra ban be ə dɨje əli par əi nə Kɨrɨsɨ kɨ e *Dəw kɨ Luwə mbəte e ngon ka *Dabɨdɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tadɔ Dabɨdɨ ə wa kɨ dɔne əl me makɨtɨbɨ Pa je tɨ ə nə: “Ɓaɓe Luwə əl Ɓaɓe ləm ə nə: ‹Ɨre ɨsɨ dɔ ji ko̰m tɨ ne, ");
INSERT INTO bjvNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Bɨtɨ kadɨ m-aw kɨ njé ba̰ je ləi m-ɨlə-de gɨn tɔgi tɨ›.” ");
INSERT INTO bjvNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Ə re Dabɨdɨ ɓar Kɨrɨsɨ Ɓane ə, ra ban taa Kɨrɨsɨ a e ngon ka Dabɨdɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jəju əl njé ndo je ləne ta kəm kosɨ je tɨ kɨ ɨsɨ oi dɔ nḛ ndo lie ");
INSERT INTO bjvNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ə nə: «Ɨndəi kəm-kədɨ dɔ rɔsi tɨ kɨ rɔ njé ndo ndu-kun je tɨ. Əi dɨje kɨ gei njɨyə kɨ kɨbɨ ngal, taa gei kadɨ dɨje rai-de lapɨya kɨ ɓukɨ-naa tɨ lo kɨngə-naa je tɨ lə kosɨ je tɔ. Gɨn kəy kaw-naa je tɨ, ə se lo nḛ kuso je tɨ, a gei lo kɨsɨ dɨje kɨ bo, kəte no̰ dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Taai nḛ majɨ je lə njé ngaw koy je pətɨ pətɨ jide tɨ, nɨngə ədi kəm dɨje kɨ kəl ta kɨ Luwə kɨ gɨne gangɨ al, kadɨ dɨje ooi-de təkɨ n-əi dɨje kɨ majɨ. Go kɨlə rade je tɨ kɨ be kɨn, Luwə a gangɨ-n ta kɨ nga̰ ngay dɔde tɨ ɨtə ndəgɨ dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jəju un kəmne ɨsɨ oo-n njé nḛ kɨngə je kɨ ɨsɨ ɨləi kadɨ-kare ləde me nḛ kadɨ-kare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nɨngə oo nje ngaw koy kɨ nje kəm-to-ndoo kare re kɨ ngan sɨlə joo ɨlə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ə Jəju əl ə nə: «M-əl səsi təkɨ rɔjetɨ, nje ngaw koy kɨ nje ndoo kam ɨlə kadɨ-kare ɨtə ndəgɨ dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tadɔ ndəgɨ dɨje pətɨ kam, adi burɨm la je ləde, nə nje ngaw koy kɨn, me ndoo tɨ lie, nḛ kɨ nay jie tɨ kadɨ ra-n kɨ rɔne ə un ba pu adɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Go tɨ, dɨje madɨ ɨsɨ əli ta dɔ kəy tɨ lə Luwə, əli əi nə: mbal je kɨ ndole kɨ rai, kɨ nḛ je kɨ dɨje adi Luwə kɨn ra adɨ kəy kɨn ətɨ ɓəl kɨ dum bɨtɨ. Nə Jəju əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Nḛ je pətɨ kɨ oi-de kɨn, ndɔ madɨ a re no̰o̰ kɨ mbal kare kɨ a nay kadɨ ɨsɨ dɔ made tɨ goto; a budi-de nangɨ mur mur.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lo kɨn tɨ, dɨje ka kɨn dəji Jəju əi nə: «NJe ndo dɨje, dɔkagɨlo tɨ kɨ ra bangɨ ə nḛ je kɨn a rai nḛ ə? Ə nḛ kɔjɨ kɨ ban ə a tɔjɨ kadɨ dɨje gərii dɔkagɨloe kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ə Jəju əl-de ə nə: «Ɨndəi kəm-kədɨ dɔ rɔsi tɨ, ɨyə̰i ta rəbɨ adi dəw ədɨ səsi al. Tadɔ dɨje ngay a rəi kɨ tɔm əi nə: “Mi ə mi Kɨrɨsɨ”, taa a əli tɔ əi nə: “Dɔkagɨlo re ngata”, nə majɨ kadɨ uni gode al. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lokɨ a oi ka rɔ je, dɨje a ḭḭ kɨ naa kɨ rɔ je kɨn, adi ɓəl ra səsi al. Tadɔ ri ri ka nḛ je kɨn a rəi ɓəy taa, nə e dɔbəy ndɔ ta ji naa tɨ no̰o̰ al ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ɓa Jəju əl-de ɓəy ə nə: «Gɨn ɓe madɨ a aw rɔ dɔ gɨn ɓe madɨne, ko̰ɓe madɨ a aw rɔ dɔ ko̰ɓe madɨne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dɔnangɨ a yəkɨ, yəkɨ kɨ ətɨ ɓəl, taa kɨ lo je kɨ dangɨ dangɨ, mo̰y je kɨ njé tɔ ko dɨje a osi je, ɓo a o̰ je. Nɨngə nḛ je kɨ ətɨ ɓəl ngay a ḭḭ kɨ dɔra̰ tɨ rəi kɨ nḛ kɔjɨ je kɨ to ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Nə kəte no̰ nḛ je tɨ kɨn pɨtɨ, dɨje a ɨndəi jide dɔsi tɨ, a adi səsi ko̰. A awi səsi lo kaw-naa je tɨ, a ɓuki səsi dangay tɨ, a awi səsi no̰ ngar je tɨ kɨ boy, kɨ no̰ njé ko̰ɓe je tɨ kɨ mbata ləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lo kɨn tɨ, e ta rəbɨ kɨ a ɨngəi kadɨ ɨmai najɨ ləm kɨ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nɨngə nḛ kɨ kadɨ ɨndəi dɔsi tɨ ə to kɨn. Onosi kadɨ ɨsangi ta madɨ ɨndəi dɔsi tɨ kəte kadɨ tə əli-de ɨnajii ta dɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tadɔ mi wa m-a m-adɨ səsi ta kɨ gosɨ kɨ kadɨ əli-de. Nɨngə njé kɔsɨ səsi ta a asi kadɨ awi kɨ ta madɨ kɨ kadɨ ɔsi kəm ya̰si ə se kadɨ najii al. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A oi kadɨ ko̰si je, kɨ bawsi je, kɨ ngako̰si je, nojɨsi je ba pətɨ, kɨ madɨsi je a uni dɔsi kadɨ adi dɨje. Nɨngə a gangi ta koy dɔ dɨje tɨ ngay dansi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dɨje pətɨ mede a majal səsi kɨ mbata ləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nə bɨsɨ dɔsi kare ka a osɨ kɔ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nɨngə e me kuwə tɔgɨ ba tɨ ə yə a ɨngəi kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Lokɨ a oi njé rɔ je ɨləi-naa gəi dɔ Jorijaləm kɨn ɓa, kadɨ ɨgəri təkɨ dɔkagɨlo tuje asɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Be ə, dɨje kɨ ɨsi Jude tɨ a a̰yḭ-naa kɨ dɔ mbal je tɨ, ə kadɨ njé kɨ ɨsi me ɓe bo Jorijaləm tɨ, tḛḛi kɨ taga kɔ, nɨngə kadɨ dɨje kɨ awi wale, təli me ɓe bo tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tadɔ a e ndɔ gangɨ ta kɨ kadɨ nḛ je pətɨ kɨ Makɨtɨbɨ lə Luwə əl tae a rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","NDɔe tɨ kɨn, kəm-to-ndoo kɨ ga̰e goto a e lə dəne je kɨ njé səm, kɨ njé kadɨ mba ngan je. Tadɔ kəm-to-ndoo kɨ ngay a ra dɨje, taa wongɨ lə Luwə a re dɔde tɨ me ɓee tɨ kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dɨje a tɔli-de kɨ kɨyə kasɨgar, a uwəi-de awi səde ɓəə tɨ dɔ ɓe je tɨ kɨ dangɨ dangɨ. Dɨje kɨ gəri Luwə al a njɨyəi dɔ Jorijaləm mbɨsəi-e mbarakɨ mbarakɨ, bɨtɨ kadɨ dɔkagɨlo ləde kɨ Luwə ɔjɨ ɨndə ngangɨne. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Dɔkagɨloe tɨ kɨn, nḛ je kɨ to ɓəl a tḛḛi kəm kadɨ tɨ je, kɨ nay je, kɨ mee je. Man ba a ḭ, kae a ɓa kɨ taa, adɨ dɨje kɨ gɨn ɓe je tɨ kɨ dangɨ dangɨ, ɓəl a tɔl-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓəl a tɔl-de adɨ dadi par par, ɨsɨ ngɨnəi ta nḛ kɨ a tḛḛ dɔde tɨ dɔnangɨ tɨ. Tadɔ tɔgɨ je kɨ dɔra̰ tɨ a yəki. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lo kɨn tɨ ə yə a oi-mi *NGon dəw m-a m-re me kɨl ndi tɨ. M-a m-re kɨ tɔgɨ, me kunjɨ tɨ kɨ ətɨ ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lokɨ nḛ je kɨn rai nḛ nɨngə, majɨ kadɨ ɨrai rɔsi, ɔri dɔsi taa, tadɔ kagɨ lo kɨngə dɔ ləsi e ɓasi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nɨngə Jəju un nḛ kare ndo-n-de nḛ ə nə: «Ɨgo̰i kagɨ mbay-kote kɨ ndəgɨ kagɨ je oi. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lokɨ mbie ɨlə ngɨrə kɨtɨ kɨn nɨngə, ɨgəri kadɨ nay ɓa e ɓasi ngata. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Be tɔ ə, lokɨ oi nḛ je kɨn rai nḛ nɨngə, majɨ kadɨ ɨgəri təkɨ ko̰ɓe lə Luwə e ɓasi. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi, dɨje kɨ ɨsi kɨ dɔde taa ne kɨn a oyi tɨgə al ɓəy ə nḛ je kɨn a rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dɔra̰ kɨ dɔnangɨ a gotoi ndɔ madɨ, nə ta ləm a to lo tone tɨ ba ratata kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Majɨ kadɨ ɨsi dɔgɨ tɨ, ɓɨ adi go̰ nḛ kuso kɨ go̰ nḛ ka̰y, kɨ taga kɨ dɔ nḛ kɨ dunɨya̰ tɨ ne uwə mesi adɨ ndɔ kɨn uwə səsi nangɨ busɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kadɨ uwə səsi nangɨ təkɨ bandɨ a osɨ-n dɔ kanjɨ je tɨ kɨn be al. Tadɔ e nḛ kɨ a osɨ dɔ dɨje tɨ pətɨ kɨ dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nɨngə kadɨ ɨtoi ɓi al, əli ta kɨ Luwə kɨ dɔkagɨlo je pətɨ kadɨ tə ɨngəi tɔgɨ ɨdumi dɔ nḛ je pətɨ kɨ a rai nḛ kɨn, ə kadɨ ɨtḛḛi ai taa ta kəmm *mi NGon dəw tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Re kada ɓa, Jəju ndo nḛ dɨje gɨn kəy tɨ lə Luwə. A re kondɔ tɔ nɨngə, tḛḛ aw dɔ mbal tɨ kɨ ɓari-e dɔ mbal kagɨ bɨni je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lokɨ lo ti njay tɔ ɓa, kosɨ je rəi gɨn kəy tɨ kadɨ ooi dɔ ta lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nay mapa kɨ əm ɔde al, kɨ ɓari-e nay Pakɨ e ɓasi. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","NJé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, sangi rəbɨ kadɨ n-uwəi Jəju n-tɔli-e, nə ɓəli kosɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nɨngə *Sata̰ ur me Judasɨ tɨ kɨ ɓari-e Isɨkarɨyotɨ kɨ e kɨ kare mbo̰ njé ndo je tɨ lə Jəju kɨ dɔgɨ gɨde joo. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ur me tɨ ade aw ɨndə ta naa tɨ kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé kun dɔ njé ngəm ta kəy lə Luwə, dɔ rəbɨ tɨ kɨ kadɨ ɨlə-n Jəju jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lo kɨn tɨ, rɔ njé je kɨ Judasɨ aw ɨngə-de ka kɨn nəl-de ngay adɨ ndude osɨ naa tɨ kadɨ n-adi-e la. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasɨ ndɨgɨ dɔ tɨ, nga nɨngə ɨlə ngɨrə sangɨ rəbɨ kɨ to kadɨ ɨlə-n Jəju jide tɨ kɨ kanjɨ kadɨ kosɨ je ooi loe. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","NDɔ kuso mapa kɨ əm ɔde al, kɨ e ndɔ kɨ kadɨ dɨje tɔli ngan dəgɨ batɨ je mbata nḛ kuso Pakɨ asɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ə Jəju ɨlə Pɨyər əi kɨ Ja̰ ə nə: «Awi ɨndəi dɔ nḛ kuso Pakɨ dana kadɨ j-usoi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓa əi je təli dəji-e əi nə: «Lo kɨ ra be ə ɨndɨgɨ kadɨ j-aw jɨ ra nḛ kuso tɨtɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nɨngə Jəju ɨlə-de tɨ ə nə: «Awi, lokɨ ɨsɨ uri kɨ me ɓe tɨ ɓa, a ɨngəi dɨngəm kare kɨ otɨ gum man dɔne tɨ nɨngə uni goe, uri me kəy tɨ kɨ ur tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lokɨ uri goe tɨ ɓa, əli ɓa nje kəy kɨn əi nə: “NJe ndo dɨje ə nə kadɨ jɨ dəji se me kəy kɨ ra ə kadɨ n-uso nḛ Pakɨ tɨ kɨ njé ndo je ləne wa?” ");
INSERT INTO bjvNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lo kɨn tɨ, a ɔjɨ səsi me kəy kɨ boy. Me kəy kɨn to taa, kɨ nḛ je pətɨ me tɨ. Lo kɨn ə a rai nḛ kuso tɨ kadɨ j-usoi. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pɨyər əi kɨ Ja̰ awi nɨngə, ɨngəi nḛ je pətɨ asɨ naa təkɨ wa kɨ Jəju əl-n-de ka kɨn, adɨ rai nḛ kuso Pakɨ, ɨndəi dɔe dana.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lokɨ dɔ kadɨ asɨ, Jəju əi kɨ njé kaw kɨlə je ɨsi ta nḛ kuso tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ə Jəju əl-de ə nə: «M-ndɨgɨ ngay kadɨ m-uso nḛ Pakɨ kɨn səsi ɓəy taa kadɨ m-ɨngə ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nɨngə m-əl səsi, m-a m-uso səsi kɨ rangɨ gogɨ al, bɨtɨ kadɨ nḛ kuso kɨn tɔl tane me ɓeko̰ tɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Go tɨ, Jəju taa kɔpɨ kasɨ kandɨ nju, ra oyo Luwə dɔ tɨ, nɨngə təl-n adɨ njé kaw kɨlə je ə əl-de ə nə: «Ɨtaai a̰yḭ-naa dansi tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tadɔ, m-a m-a̰y kasɨ kandɨ nju kɨ rangɨ al, bɨtɨ kadɨ ɓeko̰ lə Luwə re-n.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Go tɨ, Jəju un mapa, ra oyo Luwə dɔ tɨ, uwə tətɨ naa tɨ, təl-n adɨ njé ndo je, nɨngə əl-de ə nə: «E kɨn e darɔm, kɨ e kɨ kun kadɨ mbata ləsi. Ɨtaai usoi kadɨ mesi ole-n dɔm tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Go nḛ kuso tɨ, Jəju un kɔpɨ kasɨ kandɨ nju, ra təkɨ ra-n kəte ka kɨn be ɓəy, nɨngə əl-de ə nə: «Kɔpɨ kɨn e kun mɨndɨ kɨ sɨgɨ me məsɨm tɨ kɨ a a̰y mbata ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Nɨngə kadɨ ɨgəri təkɨ dəw kɨ a ɨlə-m ji dɨje tɨ, ɨsɨ səm ta nḛ kuso tɨ kɨ ne wa kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mi *NGon dəw m-a m-oy təkɨ Luwə ɔjɨ-n, nə kəm-to-ndoo e lə dəw kɨ a ɨlə-m mi NGon dəw ji dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lo kɨn tɨ, njé kaw kɨlə je ɨləi rɔde ɨsɨ dəji-naa ta dande tɨ se naa dande tɨ ə kadɨ a ra nḛ kɨ be kɨn wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Go tɨ, njé kaw kɨlə je ɨləi ngɨrə naji-naa ta tɨ kɨ tɔgɨde əi nə se na̰ ə a e kɨ bo dande tɨ wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ə Jəju əl-de ə nə: «NGar je kɨ o̰i ɓe dɔ gɨn dɨje tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ tɨ ne, rai rɔde kadɨ n-əi ɓaɓe je dɔ dɨje tɨ, taa njé kɨ tɔgɨ ko̰ɓe e jide tɨ, ɨndəi tɔgɨ dɔ dɨje tɨ adɨ ɓari-de njé ra majɨ je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nə səi, majɨ kadɨ ɨrai təkɨ əi je ɨsɨ rai kɨn be al. Dəw kɨ e kɨ tɔgɨ dansi tɨ, majɨ kadɨ təl rɔne dəw kɨ dɔ du tɨ, nɨngə kadɨ dəw kɨ nje kun dɔsi, təl nje ra kɨlə ləsi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tadɔ dəw kɨ nje kɨsɨ ta nḛ kuso tɨ nɨm, dəw kɨ nje re kɨ nḛ kuso nɨm, dande tɨ kɨ joo kɨn, e kɨ nje kɨsɨ ta nḛ kuso tɨ ə e kɨ bo al a? Nɨngə mi, m-ɨsɨ dansi tɨ tə nje re kɨ nḛ kuso kadɨ səsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Səi ə səi dɨje kɨ uwəi tɔgɨsi ba səm me ko̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɨngə təkɨ Luwə kɨ Bai adɨ-m ko̰ɓe ka kɨn ə, mi m-adɨ-n səsi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","A usoi je, a a̰yḭ-naa je səm me ɓeko̰ tɨ ləm. Nɨngə a ɨsi dɔ kɨmbər ko̰ɓe tɨ kadɨ ɨgangi ta dɔ gɨn ka *Isɨrayəl tɨ kɨ dɔgɨ gɨde joo.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jəju əl Sɨmo̰ ə nə: «Sɨmo̰, Sɨmo̰, Su dəjɨ ta rəbɨ kadɨ n-sɨyə səsi təkɨ dəw a sɨyə-n ko me kee tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nə mi, m-əl ta kɨ Luwə mbata tɨ ləi, kadɨ ɨlə kadɨ-me ləi kɔ al. Nɨngə lokɨ a təl kɨ rɔm tɨ, majɨ kadɨ ɨlə dɨngəm me ngako̰i je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ə Pɨyər əl Jəju ə nə: «Ɓaɓe, mi ɓasi kadɨ re e dangay ka m-a m-aw tɨ səi. A re e-n koy ka m-a m-oy səi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ə Jəju təl əl-e ə nə: «Pɨyər, adɨ m-əli, ɓone wa kɨn, kunə kɨnjə no̰ al ɓəy ə, a najɨ ta nja mɨtə təkɨ ɨgər-m al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jəju əl njé ndo je ə nə: «Lokɨ kəte m-ɨlə səsi kɨ kanjɨ kadɨ uni la, ə se ɓɔl, ə se sa njasi kɨn nḛ madɨ du səsi ma?» Ə ɨləi Jəju tɨ əi nə: «Jagɨ, nḛ madɨ du-je al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","NGa ə Jəju əl-de ə nə: «Nɨngə kɨ ngɔsɨne kɨn, dəw kɨ aw kɨ la ɓa kadɨ un jine tɨ, e kɨ aw kɨ ɓɔl ə kadɨ un jine tɨ. A kɨn ə re dəw madɨ aw kɨ nḛ katɨ al ə kadɨ ɔr kɨbɨ kɨ rɔne tɨ gatɨ-n ə ɨyə̰ lae ndogɨ-n nḛ katɨ kare uwə jine tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Adɨ m-əl səsi, sɔbɨ kadɨ nḛ kɨ makɨtɨbɨ lə Luwə əl tae ə nə: “Tɨdəi-e dan njé ra majal je tɨ,” kɨn ra nḛ dɔm tɨ. Nɨngə nḛ kɨ sɔbɨ kadɨ a re dɔm tɨ kɨn, a ra nḛ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ə njé ndoo je əli-e əi nə: «Ɓaɓe, nḛ katɨ ə e joo kɨn.» Ɓa əl-de ə nə: «E wa kɨn asɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Go tɨ Jəju tḛḛ, nɨngə təkɨ ɨsɨ ra-n kəte kəte, un ta rəbɨ ɨsɨ aw kɨ dɔ mbal kagɨ bɨni je tɨ. *NJé ndo je lie uni goe. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lokɨ rəi tḛḛi dɔ mbal tɨ, Jəju əl njé ndo je ə nə: «Əli ta kɨ Luwə, kadɨ osi me nḛ na tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɓa ɔr rɔne sa̰y ndə̰y, nɨngə ɔsɨ məkəsɨne nangɨ, əl ta kɨ Luwə ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Bai, re ɨndɨgɨ ə, ɔsɨ ko̰ kɨn ngərəngɨ kɔ rɔm tɨ. Nə ke ə kadɨ e ndɨgɨ ləm mi al, nə kadɨ e ndɨgɨ ləi ḭ wa ə tɔl tane.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lo kɨn tɨ no̰o̰ be, malayka kare ḭ dɔra̰ tɨ re ade tɔgɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɓəl ra Jəju, NDɨle ɨsɨ nangɨ al, adɨ əl ta kɨ Luwə kɨ tɔgɨne, təte tosɨ nangɨ tə kɔr məsɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Go kəl ta tɨ kɨ Luwə, Jəju ḭ taa, təl re rɔ njé ndo je tɨ nɨngə, ɨngə-de, ɨsɨ toi ɓi kɨ me-ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ə əl-de ə nə: «Wa! ɨsɨ ɨtoi ɓi wa bɨtɨ a? ḬḬ taai, ə əli ta kɨ Luwə, kadɨ osi me nḛ na tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lokɨ Jəju a əl ta ba ɓəy nɨngə, kosɨ dɨje tḛḛi no̰o̰ ɨsɨ rəi. Judasɨ, kɨ e kɨ kare dan njé ndo je tɨ lə Jəju kɨ dɔgɨ gɨde e joo ə e no̰de tɨ. Re kɨ rɔ Jəju tɨ kadɨ n-uwe kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ə Jəju əl-e ə nə: «E kɨ kuwə kɨ a uwə-m mi *NGon dəw kɨ rɔi tɨ ə a ɨlə-m ji dɨje tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lokɨ njé njɨyə kɨ Jəju ooi nḛ je kɨ ɨsɨ ra nḛ kɨn be ɓa, dəji Jəju əi nə: «Ɓaɓe, sɔbɨ kadɨ jɨ tɨgə-de kɨ nḛ katɨ ə se kadɨ jɨ ra ban ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nɨngə loe tɨ no̰o̰, kɨ kare dande tɨ ɔr kɨyə tɨgə-n paja lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, ɓa tɨgə mbie kɨ dɔ ji ko̰ tɨ latɨ gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nə Jəju əl-de ə nə: «Asɨ be ngata, ɨyə̰i-de adɨ rai.» Nɨngə ɨlə jine ɔdɨ-n mbi paja ka kɨn, ɓa mbie təl to majɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Go tɨ, Jəju un ta əl kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé je kɨ njé ngəm ta kəy lə Luwə, kɨ ngatɔgɨ je ə nə: «To tə nḛ kɨ mi nje ɓogɨ, ə ɨrəi kɨ kɨyə kasɨgar je, kɨ gɔl je taa kadɨ uwəi-mi be? ");
INSERT INTO bjvNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","NDɔ je pətɨ, mi səsi naa tɨ gɨn kəy tɨ lə Luwə, nə jisi ɔdɨ-m al, nɨngə e ndɔ ləsi ɓone, e ndɔ kɨ kadɨ tɔgɨ je kɨ majal ɔdi rɔde me tɨl tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lo kɨn tɨ, uwəi Jəju, awi sie, uri sie kəy lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je. Pɨyər adɨ nda̰e ngal ndə̰y, nɨngə un gode ɨsɨ aw səde. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Dɨje ɨləi por dana natɨ lo tɨ, ɨsi ta tɨ, adɨ Pɨyər aw ɨsɨ ta tɨ səde. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nɨngə ngon dəne kare kɨ nje ra kɨlə me kəy tɨ, oo Pɨyər ɨsɨ kunjɨ por tɨ, ə ɨndə manje ba, nɨngə əl ə nə: «E kɨ ɨsɨ kɨn ka, kəte e sie tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nə Pɨyər najɨ ə nə: «Dəne, m-gər-e al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓa ndə̰y go tɨ ə dəw kɨ rangɨ oo Pɨyər, nɨngə təl əl ɓəy ə nə: «Ḭ ka, ḭ dan dɨje tɨ lie tɔ.» Nə Pɨyər ɨlə dəw tɨ ka kɨn ə nə: «Jagɨ, mi səde al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bɨtɨ asɨ kadɨ-kare go tɨ, nɨngə dəw kɨ rangɨ təl re dɔ tɨ ɓəy ə nə: «Kɨ rɔjetɨ, dɨngəm kɨn kəte e sie tɔ, tadɔ e dəw kɨ Galile tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ə Pɨyər ɨle tɨ ə nə: «Dɨngəm, m-gər me ta ləi kɨ ɨge kadɨ əl kɨn al.» Ɓa ta naa tɨ no̰o̰ wa kɨ Pɨyər ɨsɨ əl ta tane tɨ ba ɓəy nɨngə, kunə kɨnjə no̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Loe tɨ no̰o̰, Jəju ɨlə rətɨ go̰ Pɨyər, ɓa me Pɨyər ole dɔ ta tɨ kɨ Jəju əl-e ə nə: «Ɓone wa kɨn, kəte ɓəy taa kadɨ kunə kɨnjə no̰, a najɨ ta nja mɨtə ə nə ɨgər-m al,» ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pɨyər ɨndə lo tḛḛ taga, no̰ kɨ man kəmne. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dɨje kɨ njé ngəm Jəju, mbəi sie je, tɨndəi-e je. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓa dɔɔi kəme ə əli əi nə: «Na̰ ə ɨndəi wa ɨgər dəwe adɨ j-o!» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Taa nḛ tajɨ je kɨ rangɨ ngay tḛḛ tade tɨ kɨ rɔe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lokɨ lo ti nɨngə, ngatɔgɨ je lə *Jɨpɨ je, kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je, ɨngəi-naa, awi kɨ Jəju no̰ njé gangɨ ta je tɨ lə Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɨngə əli-e əi nə: «Re e ḭ ə ḭ Kɨrɨsɨ kɨ Luwə mbəte ə əl-je adɨ j-o.» Ə Jəju ɨlə-de tɨ ə nə: «Re m-əl səsi ka a taai mem al. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Taa re m-dəjɨ səsi ta ka a ɨləi-mi tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nɨngə kɨ j-ai ta jije tɨ ne kɨn, ɨlə ngɨre ɓone kɨn, mi *NGon dəw m-a m-ɨsɨ dɔ ji ko̰ Luwə tɨ kɨ nje tɔgɨ ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɓa pətɨ dəji-e əi nə: «Adɨ ḭ ngon lə Luwə ta?» Ə Jəju əl-de ə nə: «Səi je wa əli kɨ tasi təkɨ, mi NGon lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lo kɨn tɨ, əli əi nə: «E kɨn, jɨ sangi kadɨ dəw madɨ kɨ rangɨ əl ta dɔe tɨ ɓəy a? J-əi je wa j-oi ta ka tae tɨ kɨ mbije ne ngata kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Go tɨ, ḭḭ taai pətɨ awi kɨ Jəju no̰ *Pɨlatɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nɨngə lo kɨn tɨ, ɨləi rɔde ɨsɨ ɨndəi ta dɔ Jəju tɨ əi nə: «Dɨngəm kam j-ɨnge ɨsɨ sulə dɨje kadɨ ɓukɨ-de wale. Əl-de kadɨ ugəi la-mbə nje ko̰ kɨ bo Səjar al. Taa a dɔ tɨ no̰o̰ əl ɓəy təkɨ n-e Kɨrɨsɨ, n-e ngar.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ə Pɨlatɨ dəjɨ Jəju ə nə: «Ḭ ngar lə *Jɨpɨ je a?» Ɓa Jəju ɨle tɨ ə nə: «E ta kɨ tḛḛ tai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lo kɨn tɨ, Pɨlatɨ əl kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ kosɨ je ə nə: «M-ɨngə nḛ madɨ kɨ asɨ kadɨ m-gangɨ-n ta dɔ dɨngəm tɨ kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nə uwəi tade nga̰ əi nə: «E nje sulə dɨje kɨ nḛ ndo ləne kadɨ ta̰i rɔ. Ɨlə ngɨre Galile tɨ, un-n dɔnangɨ kɨ Jude ba pətɨ, bɨtɨ ə tḛḛ-n rɔjetɨ ne kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lokɨ *Pɨlatɨ oo ta kɨn nɨngə dəjɨ ə nə se dɨngəm kɨn e dəw kɨ Galile tɨ wa? ");
INSERT INTO bjvNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ə lokɨ oo kadɨ Jəju ḭ gɨn ɓeko̰ tɨ lə *Erodɨ nɨngə, ɨlə sie adɨ Erodɨ kɨ dɔkagɨloe tɨ kɨn e Jorijaləm tɨ no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lokɨ Erodɨ oo Jəju ɓa, rɔe nəl-e ngay tadɔ mari nu ba ə ɨsɨ sangɨ kadɨ n-oo Jəju ɔjɨ-n dɔ ta lie kɨ dɨje ɨsɨ əli. Erodɨ ɨndə mene tɨ kadɨ Jəju a ra nḛ kɔjɨ je kadɨ n-oo. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ə dəje ta je ngay, nə Jəju ɨle tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ndo ndu-kun je əi no̰o̰, ɨsɨ səki dɔ Jəju kɨ tɔgɨde. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodɨ əi kɨ asɨgar je ləne kɨdi Jəju, mbəi sie, ɓa ɨləi kɨbɨ kɨ ndole rɔe tɨ, ə təli ɨləi sie adɨ Pɨlatɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","NDɔe tɨ no̰o̰, Erodɨ əi kɨ Pɨlatɨ kɨ kəte əi njé ba̰ je lə naa, təli madɨ-naa je. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","*Pɨlatɨ ɓar kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé kun dɔ kosɨ je, ");
INSERT INTO bjvNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","əl-de ə nə: «Ɨrəi kɨ dɨngəm kɨn adi-mi əi nə e nje sulə dɨje ɓukɨ-de wale, nə me ta tɨ kɨ m-dəje no̰si tɨ ne kɨn, m-ɨngə nḛ kɨ majal kɨ ɨsəki-e-n, kɨ asɨ kadɨ m-gangɨ-n ta dɔe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","*Erodɨ ka ɨngə nḛ madɨ al tɔ, tadɔ təl ɨlə sie rɔjetɨ gogɨ. Nḛ kɨ asɨ kadɨ dəw tɔl-e-n goto. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Be ə, m-a m-adɨ ɨndəi-e par ə m-a m-ɨyḛ taa.»  ");
INSERT INTO bjvNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pɨlatɨ əl be mbata dɔ ɓal je pətɨ, lo ra nay pakɨ tɨ, sɔbɨ kadɨ Pɨlatɨ ɔr dəw kare dangay tɨ adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nə dɨje pətɨ uni ndude kɨ taa əli əi nə: «Ɨtɔl-e kɔ ə ɔr Barabasɨ adɨ-je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasɨ e dəw kɨ uwəi-e dangay tɨ mbata e dan dɨje tɨ kɨ wongɨ ra-de dɔ njé ko̰ɓe je tɨ me ɓe tɨ nɨm, tɔli dəw nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Nɨngə təkɨ Pɨlatɨ ndɨgɨ-n kadɨ n-ɨyə̰ Jəju taa, təl dəjɨ-de ta dɔ tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nə əi je əli ta kɨ ndu kɨ nga̰ ngay əi nə: «Ɨɓe kagɨ-dəsɨ tɨ, ɨɓe kagɨ-dəsɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pɨlatɨ re səde dɔ tɨ ɓəy kɨ ko̰ mɨtə ə nə: «E ri kɨ majal ə dɨngəm kɨn ra ə? Nḛ kɨ asɨ kadɨ dəw tɔl-e-n goto, adɨ m-a m-adɨ ɨndəi-e par ə m-a m-ɨyḛ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nə əi je ai dɔ ndude tɨ, uni ndude kɨ taa, əli ta kɨ tɔgɨde ngay ɨtə kɨ kəte kadɨ ɓe kagɨ-dəsɨ tɨ tə ɓə wa. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Be ə, Pɨlatɨ un ndune kadɨ n-ra nḛ kɨ kosɨ je ndɨgi. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Adɨ ɔr Barabasɨ kɨ ndɨgi kadɨ ɔr-e adɨ-de. Barabasɨ e dəw kɨ uwəi-e dangay tɨ mbata e dan dɨje tɨ kɨ rai wongɨ dɔ njé ko̰ɓe je tɨ nɨm, taa tɔli dəw nɨm. NGa nɨngə ndɨgɨ kadɨ tə Jəju taa n-ule ji asɨgar je tɨ kadɨ rai sie nḛ kɨ go ndɨgɨ tɨ ləde əi kosɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lokɨ asɨgar je ɨsɨ awi kɨ Jəju nɨngə, ɨngəi Sɨmo̰, dəw kɨ Sɨrən tɨ, kɨ ḭ wale, ɓa ɨndəi kagɨ-dəsɨ lə Jəju dɔe tɨ, adɨ otɨ goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kosɨ dɨje ngay uni go Jəju. Dəne je ɨndəi kadɨde no̰i, ndɨngəi rɔde mbata lie. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Be ə, Jəju yətɨ kəmne kɨ dɔde tɨ, əl-de ə nə: «Dəne je kɨ Jorijaləm, ɨno̰i-mi al, nə kadɨ ɨno̰i rɔsi səi je wa, ə ɨno̰i ngansi je. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","MBata ndɔ a re no̰o̰ kadɨ dɨje a əli əi nə: “Majɨ-kur ə dɔ kujɨ dəne je tɨ, e dɔ njé je tɨ kɨ oji ngon ndɔ kare al, kɨ ɨləi mba ta ngon tɨ al.” ");
INSERT INTO bjvNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lo kɨn tɨ no̰o̰ be, dɨje a əli mbal je əi nə: “Osi dɔje tɨ!” Ə a əli dii je əi nə: “Ɨɓɔyɔi-je!” ");
INSERT INTO bjvNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kɨn ə dəw ra kagɨ mbəl be nɨngə, kagɨ kɨ tutɨ taa ya̰e a to ban ə?» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lo kɨn tɨ, rəi kɨ baw kaya je kɨ njé tɔl nḛ joo kadɨ tɔli-de naa tɨ kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lokɨ rəi tḛḛi lo tɨ kɨ ɓari-e «Ka dɔ dəw» ɓa, asɨgar je ɓəi Jəju kagɨ-dəsɨ tɨ, loe tɨ no̰o̰, taa ɓəi baw kaya je kɨ joo ka kɨn naa tɨ kɨ Jəju dɔ kagɨ-dəsɨ tɨ tɔ. Ɓəi kɨ kare dɔ ji ko̰e tɨ, ə ɓəi kɨ nungɨ dɔ ji gəle tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɨngə Jəju əl ə nə: «Bai, adɨ mei sɔl dɔde tɨ, tadɔ gəri nḛ kɨ a rai kam al.» No̰o̰ be, asɨgar je tɨgəi kɨr (mbare) dɔ kɨbɨ tɨ lie, ləbi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kosɨ dɨje ai no̰o̰ a go̰i-de, nɨngə njé kun dɔ *Jɨpɨ je ɨbəi Jəju kogii əi nə: «Ajɨ dɨje kɨ rangɨ, ən ə, kadɨ ajɨ rɔne e wa adɨ j-o tɔ, təkɨ re e Kɨrɨsɨ lə Luwə kɨ Luwə mbəte.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asɨgar je ka kɨn agi kɨ rɔ Jəju tɨ, mbəi sie, ɓa adi-e kasɨ kɨ masɨ kade a̰y. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nɨngə əli-e əi nə: «Re ḭ ngar lə Jɨpɨ je ə, ajɨ rɔi ḭ wa adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɓa ndangi nḛ madɨ ɓəy tɔ me ba tɨ, ɨndəi taa dɔ Jəju tɨ əi nə: «Dəw kam e ngar lə Jɨpɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nɨngə baw kaya kare kɨ ɓəi-e dɔ kagɨ-dəsɨ tɨ tajɨ Jəju ə nə: «Ḭ al ə ə nə ḭ Kɨrɨsɨ kɨ Luwə mbəte a? Ajɨ rɔi ḭ wa, ə ajɨ-je səi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nə e kɨ nungɨ kɔl kɨ madɨne ə nə: «Ḭ kɨ ta kɨ gangɨ kɨ kare wa kɨn ɨsɨ dɔi tɨ tɔ kɨn, ɨɓəl Luwə al a? ");
INSERT INTO bjvNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kɨ ɔjɨ dɔje, e go tɨ, tadɔ e nḛ kɨ je wa jɨ dɨbɨ ə jɨ tətɨ kande, nə e, nḛ madɨ kare kɨ majal kɨ ra goto.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɓa e kɨ nje kɔl kɨ madɨne ka kɨn təl əl Jəju ə nə: «Jəju, ndɔ kɨ a re tə ngar ə, adɨ mei ole dɔm tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ə Jəju ɨle tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əli, ɓone wa kɨn a ḭ səm naa tɨ me ɓe rɔnəl tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kɨ kadɨ kɨ kaw kɨ jam dɔ ɓe tɨ be, ə lo ndul dɔnangɨ tɨ bɨtɨ kadɨ kɨ mɨtə kɨ lo sɔlɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kadɨ ur dana, dəw oo-e al. NGa nɨngə, kɨbɨ kɨ gangi lo kɨ me kəy tɨ lə Luwə gangɨ dana lə naa je joo. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɓa Jəju un ndune kɨ taa ə nə: «Bai, m-ɨyə̰ ndɨlm me jii tɨ.» Nɨngə go ta tɨ kɨn ɓa kə̰ə̰e tḛḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lokɨ kɨ bo lə asɨgar je oo nḛ je kɨ rai nḛ kɨn be ɓa, ɨlə tɔjɨ dɔ Luwə tɨ ə əl ə nə: «E kɨ rɔjetɨ, dəw kɨn e dəw kɨ dana.» ");
INSERT INTO bjvNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kosɨ dɨje kɨ əi lo nḛ tɨ kɨn, lokɨ ooi nḛ kɨ ra kɨn ɓa, təli ɓe je kɨ kadɨde kɨ kɨndə, ndɨngəi rɔde. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dɨje pətɨ kɨ gəri Jəju, kɨ dəne je kɨ ḭ sie Galile tɨ, ai sa̰y ɨndəi kəmde a ooi nḛ je kɨ ɨsɨ rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lo kɨn tɨ no̰o̰ be ə, dɨngəm kare kɨ tɔe nə Jɨsəpɨ ḭ no̰o̰ re. Jɨsəpɨ e kɨ kare dan njé gangɨ ta je tɨ lə *Jɨpɨ je, e dəw kɨ majɨ, e dəw kɨ dana, ");
INSERT INTO bjvNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","adɨ nḛ je kɨ made je dɔɔi naa tɨ ə rai kɨn, e ndɨgɨ səde dɔ tɨ al. Jɨsəpɨ e dəw kɨ Arɨmate tɨ, kɨ e ɓe lə Jɨpɨ je. E ɨsɨ ngɨnə ta ko̰ɓe lə Luwə kɨ kadɨ a re. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jɨsəpɨ aw rɔ *Pɨlatɨ tɨ, dəje nɨn Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Be ə, aw rɨsɨ nɨn Jəju dɔ kagɨ-dəsɨ tɨ, re-n nangɨ, dole kɨ kɨbɨ, ɓa aw ɨle me ɓe nɨn tɨ kɨ rai kadɨ mbal tɨ. E ɓe kɨ dəw ɨlə nɨn tɨ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","NDɔe tɨ kɨn, e ndɔ kɨ dɨje ɨsɨ ɔsi nja nḛ je naa tɨ, tadɔ lo ti par ə e ndɔ taa kə̰ə̰. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dəne je kɨ ḭ kɨ Jəju Galile tɨ nu, rəi sie, awi naa tɨ kɨ Jɨsəpɨ. Awi go̰i ɓe nɨn kɨ kadɨ ɨləi Jəju tɨ ka kɨn, ə ooi kujɨ kɨlə kɨ ɨləi nɨne. ");
INSERT INTO bjvNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Go tɨ, təli awi ɓe, ɨndəi dɔ yɨbɨ kagɨ kɨ ətɨ mbi, naa tɨ, mba kɔy rɔ nɨn Jəju tɨ. Nɨngə ndɔ kɔr kə̰ə̰, uwəi kɔ rɔde təkɨ ndu-kun əl-n. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","NDɔ dɨmasɨ kɨ sḭ ɓatɨ ba ɓa, dəne je awi dɔ ɓadɨ tɨ kɨ yɨbɨ kagɨ kɨ ətɨ mbi kɨ ɨndəi dɔe dana mba kɔy rɔ nɨn Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lokɨ awi nɨngə, ɨngəi mbal kɨ uti ta ɓadɨ ka kɨn dəw nduguru-e rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lokɨ uri me ɓadɨ tɨ ɓa, oi nɨn Ɓaɓe Jəju, al. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Loe tɨ no̰o̰ be, gəri nḛ kɨ kadɨ rai al, nɨngə yə dɨngəm je joo kɨ ɨləi kɨbɨ kɨ ndo̰y rɔde tɨ, tḛḛi hɔy kɨ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓəl tɔl-de, adɨ ɨləi dɔde kɨ nangɨ, nə dɨngəm je ka kɨn əli-de əi nə: «Ra ban ə ɨsɨ sangi dəw kɨ ɨsɨ kəm dan njé koy je tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","E goto ne ngata, ḭ taa lo koy tɨ. Nɨngə majɨ kadɨ adi mesi ole dɔ ta tɨ kɨ əl səsi lokɨ e-n Galile tɨ ɓəy kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Əl ə nə: «Sɔbɨ kadɨ dɨje a ɨləi-mi *mi NGon dəw ji njé ra majal je tɨ kadɨ ɓəi-mi kagɨ-dəsɨ tɨ, ɓa go tɨ, m-a m-ḭ taa lo koy tɨ kɨ ndɔ kɨ ko̰ mɨtə go koym tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lo kɨn tɨ, mede ole dɔ ta tɨ kɨ Jəju əl. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Be ə, lokɨ təli dɔ ɓadɨ tɨ, rəi ɔri poy nḛ je kɨn njé ndo je kɨ dɔgɨ gɨde kare əi kɨ ndəge je pətɨ adɨ-de oi. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","NJé kɔr poy nḛ kɨn njé kaw kɨlə je e Mari kɨ Magɨdala nɨm, Jan nɨm, Mari kɨ ko̰ Jakɨ nɨm, kɨ ndəgɨ dəne je kɨ əi səde. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nə njé kaw kɨlə je ooi ta kɨn tə ta ni adɨ taai ta lə dəne je ka kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lo kɨn tɨ no̰o̰, Pɨyər ə ḭ kɨ ngɔdɨ, aw ɨlə mbɔne ɓe nɨn tɨ nɨngə, oo ta kɨbɨ je kɨ doləi nɨn par ə a nangɨ. Nḛ kɨn ndɔjɨ Pɨyər ngay, lokɨ ɨsɨ təl kɨ ɓe. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","NDɔe tɨ wa ka kɨn, njé ndo je joo ɨsɨ awi ngon ɓe tɨ kare kɨ ɓari-e Emawusɨ, kɨ a asɨ kulə mətər dɔgɨ gɨde kare kɨ ɓe bo kɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","*NJé ndo je kɨ joo ka kɨn, a əli-naa ta dɔ nḛ je tɨ kɨ ra nḛ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nɨngə lokɨ a əli-naa ta, a naji-naa tɨ ka kɨn nɨngə, Jəju tḛḛ uwə səde rəbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nə kəmde utɨ dɔe tɨ adɨ gəri-e al. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ə Jəju dəjɨ-de ə nə: «E ri ə a naji-naa ta tɨ dɔ rəbɨ tɨ be ə?» Nɨngə təli ai lo ka tɨ, kəmde ɨl kɨrɨri. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ɓa kɨ kare dande tɨ kɨ tɔe nə Kɨləwopasɨ əl Jəju ə nə: «Ḭ kɨ kari ba par ə ḭ dəw kɨ ɨsɨ Jorijaləm tɨ ne kɨ kanjɨ kadɨ oo ka nḛ je kɨ rai nḛ me ndɔ je kɨ ne kɨn!» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ə təl dəjɨ-de ə nə: «E ri ə ra nḛ ə?» Nɨngə ɨləi-e tɨ əi nə: «Nḛ kɨ ra nḛ ɔjɨ-n dɔ Jəju kɨ Najarətɨ tɨ, kɨ e nje kəl ta kɨ ta Luwə tɨ kɨ aw kɨ tɔgɨ ngay. Aw kɨ tɔgɨ me kɨlə rane tɨ nɨm, me ta kəlne tɨ nɨm, no̰ Luwə tɨ kɨ no̰ dɨje me tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nə kɨ bo je kɨ dɔ njé kɨjə nḛ məsɨ kadɨ-kare tɨ, kɨ njé kun dɔ Jɨpɨ je, uwəi-e, ɨləi-e ji dɨje tɨ kadɨ gangi ta koy dɔe tɨ, ə ɓəi-e dɔ kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Je j-o kadɨ e ə e dəw kɨ kadɨ a taa *Isɨrayəl je ɨlə-de taa. Nɨngə me nḛ je tɨ kɨn pətɨ, ɓone ə e ndɔ kɨ ko̰ mɨtə kɨ nḛ je kɨn rai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nə nḛ kare, dəne je kɨ me ɓutɨ tɨ ləje əli-je nḛ kɨ ndɔjɨ-je ngay. Tḛḛi kɨ sḭ ɓatɨ ba awi dɔ ɓadɨ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nə oi nɨne al, ɓa təli rəi əli-je təkɨ malayka je tḛḛi rɔde tɨ əli-de təkɨ a kɨ dɔne taa. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ə madɨje je madɨ awi dɔ ɓadɨ tɨ ɓa, oi nḛ je təkɨ wa kɨ dəne je əlii. Nɨngə e wa taa, dəw oo-e al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lo kɨn tɨ, Jəju əl-de ə nə: «Səi dɨje kɨ nḛ gər ləsi goto, nga̰ səsi kadɨ adi mesi kalangɨ ba nje kəl ta kɨ ta Luwə tɨ! ");
INSERT INTO bjvNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sɔbɨ kadɨ Kɨrɨsɨ a ɨngə ko̰ be taa kadɨ a ɨngə-n tɔɓa ləne.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Be ə, ɔr-n-de gɨn makɨtɨbɨ je pətɨ kɨ əl ta kɨ dɔe tɨ, ɨlə ngɨre dɔ ndu-kun tɨ lə *Mojɨ tḛḛ-n dɔ njé kəl ta je kɨ ta Luwə tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lokɨ ɨndəi dɔ ɓe kɨ ɨsɨ awi tɨ ɓasi ɓa, Jəju ra dɔ kəmne tɨ tə nḛ kɨ a aw kɨ kəte be. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ə gangi-e əi nə: «Kadɨ ur ngata, adɨ lo dɨbɨ, ə nə ɨsɨ nangɨ rɔjetɨ.» Be ə, tɔ aw səde lo kɨsɨde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lokɨ ɨsɨ ta nḛ kuso tɨ səde, un mapa, ra oyo Luwə dɔ tɨ, uwə tətɨ naa tɨ, ɓa təl-n adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lo kɨn tɨ ngata ə, kəmde tḛḛ adɨ gəri-e təkɨ e Jəju, nə loe tɨ no̰o̰, Jəju tən jɨpɨ adɨ ooi-e al. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ə təli ɨsɨ əli-naa əi nə: «Lokɨ ɨsɨ əl-je ta dɔ rəbɨ tɨ, ɨsɨ ɔr-n-je gɨn nḛ je kɨ ndangi me makɨtɨbɨ je kɨn, to tə nḛ kɨ e por ə ɨsɨ o̰ meje tɨ be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɓa loe tɨ no̰o̰, ḭḭ taai, təli ɨləi dɔde kaw Jorijaləm gogɨ. Awi ɨngəi njé ndo je kɨ dɔgɨ gɨde kare kɨ ndəge je kɨ gode tɨ kawi-naa ɨsi. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ə pətɨ əli njé ndo je kɨ joo ka kɨn əi nə: «E ta kɨ rɔjetɨ kadɨ Ɓaɓe ḭ lo koy tɨ! Tḛḛ ɨngə Sɨmo̰, adɨ Sɨmo̰ oo-e kɨ kəmne!» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lo kɨn tɨ, njé ndo je kɨ joo, ɨləi rɔde ɔri-de gɨn nḛ je kɨ ɨngə-de dɔ rəbɨ tɨ, kɨ gər kɨ gəri Jəju lo tətɨ mapa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lokɨ ɨsɨ əli-naa ta ba ɓəy nɨngə, Jəju wa tḛḛ hɔy dande tɨ, əl-de ə nə: «Lapɨya e səsi.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lo kɨn tɨ, ɓəl tɔl-de, ndɨlde tḛḛ. Gai kadɨ e ndɨl ə ooi-e. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ə Jəju əl-de ə nə: «Ra ban ə ndɨlsi goto je, mesi tɔsɨ je be ə? ");
INSERT INTO bjvNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɨgo̰i jim je, kɨ njam je kɨn oi, e mi wa. NDɨl aw kɨ dane je, kɨ sɨngəne je təkɨ oi-mi kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Lo kɨn tɨ, tɔjɨ-de jine je, kɨ njane je adɨ-de ooi. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rɔnəl dum dɔ njé ndo je, e nḛ kɨ ətɨ-de ɓəl kɨ dum, adɨ lo kadɨ ooi tə e nḛ kɨ rɔjetɨ nga̰. Ə Jəju dəjɨ-de ə nə: «Awi kɨ ngon nḛ kuso nḛ a?» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓa adi-e ngon dam kanjɨ kɨ ndaw. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ə Jəju taa, uso ta kəmde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nɨngə go tɨ, əl-de ə nə: «Ta je kɨ ndɔ kɨ m-əl səsi lokɨ mi-n səsi ɓəy ə to kɨn: NDɔ kɨ m-əl səsi təkɨ, nḛ je pətɨ kɨ ndangi me ndu-kun tɨ lə *Mojɨ je, kɨ me ta tɨ lə njé kəl ta je kɨ ta Luwə tɨ, kɨ me pa kosɨ je tɨ kɨn, sɔbɨ kadɨ a tɔli tade be.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lo kɨn tɨ nga ə, Jəju adɨ-de ku dɔde, kadɨ gəri me makɨtɨbɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nɨngə əl-de ə nə: «E ta kɨ ndangi kəte, təkɨ mi Kɨrɨsɨ m-a m-ɨngə ko̰, dɨje a tɔli-mi, ɓa go tɨ, m-a m-ḭ taa dan njé koy je tɨ kɨ ndɔ kɨ ko̰ mɨtə lə ndɔ koym. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dɨje a ɨləi mbḛ kɨ tɔm, ɨlə ngɨre Jorijaləm tɨ, bɨtɨ kɨ rɔ gɨn dɨje tɨ pətɨ, kadɨ dɨje ɨyə̰i go rəbɨ nḛ rade je kɨ majal kɔ, kadɨ Luwə ɨyə̰-n go majal je ləde kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɨngə səi ə səi njé ma najɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kɨ ɔjɨ dɔm, m-a m-ɨlə kɨ nḛ kɨ Bai un mɨndɨne dɔ tɨ kadɨ n-a n-adɨ səsi kɨn. Nɨngə a ɨsi ɓe bo tɨ ne bɨtɨ kadɨ tɔgɨ kɨ ḭ dɔra̰ tɨ kɨn re dɔsi tɨ ɓəy taa.» ");
INSERT INTO bjvNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Go tɨ, Jəju aw kɨ njé ndo je ləne ɓasi kadɨ ɓe tɨ kɨ Bətani, ɓa ɔy jine kɨ taa, njangɨ dɔde. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lokɨ njangɨ dɔde nɨngə, ɨyə̰-de ə ɔr rɔne kɔ rɔde tɨ, ɓa uni-e awi sie dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lo kɨn tɨ no̰o̰, njé ndo je ɔsi məkəsɨde nangɨ no̰e tɨ, ɓa təli gogɨ Jorijaləm tɨ kɨ rɔnəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dɔkagɨlo je pətɨ, əi gɨn kəy tɨ lə Luwə, ɨləi tɔjɨ dɔ Luwə tɨ.");
INSERT INTO bjvNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lo kɨlə ngɨrə nḛ je tɨ pətɨ, dəw kɨ e ta e no̰o̰ ngata, Dəw kɨ e ta e naa tɨ kɨ Luwə, Dəw kɨ e ta e Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lo kɨlə ngɨrə nḛ tɨ, dəw kɨ e ta e naa tɨ kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E ə Luwə un-e ra-n nḛ je pətɨ. Nḛ kɨ Luwə ra-e kɨ kanje e goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dəw kɨ e ta ka kɨn ə e nje kadɨ dɨje ɨsi kɨ dɔde taa. Nɨngə kɨsɨ kɨ dɔ taa kɨ ḭ rɔe tɨ kɨn ə e kunjɨ dɔ dɨje tɨ kɨ dɔnangɨ tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kunjɨ unjɨ dɔ tɨl tɨ, Nə tɨl uwə kunjɨ ka kɨn kɨ rɔne tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Luwə ɨlə dəw kare kɨ tɔe nə Ja̰ ade re. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Re tə nje ma najɨ kadɨ ma najɨ lə kunjɨ, Kadɨ dɨje pətɨ adi mede kunjɨ kɨ takule. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ja̰ e kunjɨ al, nə e nje ma najɨ lə kunjɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Dəw kɨ e ta kɨn e ə e kunjɨ kɨ rɔjetɨ. Kunjɨ kɨ rɔjetɨ kɨ re dɔnangɨ tɨ ne, Unjɨ dɔ dɨje tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Dəw kɨ e ta e dɔnangɨ tɨ ne. Nɨngə e ə Luwə un-e ra-n dɨje kɨ dɔnangɨ tɨ ne, Nə dɨje kɨ dɔnangɨ tɨ ne gəri-e al. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Dəw kɨ e ta kɨn re dan dɨje tɨ lie, Nə dɨje lie uwəi-e kɨ rɔde tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","NGa nɨngə, njé kɨ uwəi-e kɨ rɔde tɨ, Adɨ e njé kɨ adi-e mede, adɨ-de ta rəbɨ kadɨ təli ngan lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Təli ngan lə Luwə, kɨ go kojɨ tɨ kɨ məsɨ təkɨ dɨje ɨsɨ ojii-naa kɨn al nɨm, Kɨ go ndɨgɨ tɨ lə dəw al nɨm, nə e Luwə wa ə ra adɨ təli ngane je. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dəw kɨ e ta, təl darɔ dəw kɨ rɔjetɨ, Uwə lo kɨsɨ danje tɨ. Me-majɨ, kɨ nḛ kɨ rɔjetɨ rosɨ mee. Je j-o tɔɓa lie. E tɔɓa kɨ NGon kɨ kare ba ɨngə kɨ rɔ Bawne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ja̰ un ndune kɨ taa, ma-n najɨ lie ə nə: «E ə e dəw kɨ m-əl ta lie kəte m-əl m-ə nə: “Dəw kɨ re gom tɨ, e kɨ bo dɔm tɨ, Tadɔ e ɨsɨ kɨ dɔne taa kəte no̰m tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","«Je pətɨ, j-ɨngə nḛ majɨ kɨ ḭ rɔe tɨ, kɨ go me-majɨ tɨ lie. Adɨ-je majɨ-kur kɨ ɔsɨ go naa go naa. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Luwə adɨ-je ndu-kun kɨ go rəbɨ lə Mojɨ, Nə me-majɨ kɨ nḛ kɨ rɔjetɨ rəi kɨ go rəbɨ lə Jəju Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dəw kɨ oo Luwə goto, nə NGon kɨ kare ba, Kɨ e Luwə ə ɨsɨ kadɨ Bawne tɨ, ə ra adɨ jɨ gər-e.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lokɨ *Jɨpɨ je kɨ Jorijaləm tɨ ɨləi njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé je kɨ gɨn kojɨ tɨ lə *Ləbi kɨ rɔ Ja̰ tɨ dəji-e ə nə: «Ḭ na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ɓa, Ja̰ əl-de wangɨ kɨ taga, kɨ kanjɨ yətɨ ta ə nə: «Mi Kɨrɨsɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","NJé kɨ ɨləi-de ka kɨn təli dəji-e əi nə: «NGa ḭ na̰ dana? Ḭ nje kəl ta kɨ ta Luwə tɨ Eli a?» Ə Ja̰ ɨlə-de tɨ ə nə: «Jagɨ, mi Eli al.» Təli dəji-e ɓəy əi nə: «Ḭ NJe kəl ta kɨ ta Luwə tɨ kɨ j-ɨsɨ jɨ ngəm-e a?» Ja̰ ə nə: «Jagɨ, mi NJe kəl ta kɨ ta Luwə tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lo kɨn tɨ no̰o̰, əli-e əi nə: «NGa ḭ na̰ dana bangɨ wa əl-je adɨ j-o, tadɔ sɔbɨ kadɨ j-a jɨ təl kɨ ta madɨ kadɨ j-aw-n kɨ rɔ njé je tɨ kɨ ɨləi-je. Ta ri ə əl dɔ rɔi tɨ ḭ wa ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","No̰o̰ be ngata ə Ja̰ ɨlə-de tɨ ə nə: «Mi ə mi dəw kɨ ndue ɓa dɨlə lo tɨ ə nə: “Ɨrai go rəbɨ lə Ɓaɓe adɨ a njururu!” Təkɨ nje kəl ta kɨ ta Luwə tɨ Ejay əl-n.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","NJé kɨ ɨləi-de ka kɨn əi *Parɨsɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ə təli dəji Ja̰ Batɨsɨ ɓəy əi nə: «A kɨn ə re ḭ Kɨrɨsɨ al nɨm, ḭ Eli al nɨm, taa ḭ NJe kəl ta kɨ ta Luwə tɨ kɨ j-ɨsɨ jɨ ngəm-e kɨn al nɨm tɔ ə, ra ban ə ɨsɨ ɨra dɨje batəm ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ə Ja̰ əl-de ə nə: «Mi m-ra dɨje batəm me man tɨ, nə dəw madɨ e mbo̰si tɨ no̰o̰ kɨ ɨgəri-e al. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E re gom tɨ, nə kɨlə sa kɨ njae tɨ ka mi m-asɨ kadɨ m-tutɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nḛ je kɨn pətɨ rai nḛ Bətani tɨ, dam ba Jurdḛ tɨ, kɨ Ja̰ ra dɨje batəm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lo ti dɔ tɨ, Ja̰ oo Jəju kɨ ɨsɨ re kɨ rɔe tɨ nɨngə əl ə nə: «Oi *NGon dəgɨ batɨ lə Luwə kɨ nje kɔr majal lə dɨje kɨ dɔnangɨ tɨ ne kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","E ə e dəw kɨ m-əl ta lie kəte m-əl m-ə nə: “Dəw kɨ re gom tɨ, e kɨ bo dɔm tɨ, tadɔ e ɨsɨ kɨ dɔne taa kəte no̰m tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mi kɨ dɔm m-gər-e kəte al, nə m-re m-ra dɨje batəm me man tɨ mba kadɨ m-adɨ *Isɨrayəl je gəri-e-n.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja̰ ma najɨ ə nə: «M-o NDɨl Luwə ḭ taa, rɨsɨ tə də dum be re ɨsɨ dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mi m-gər-e al, nə Luwə kɨ ɨlə-m adɨ m-re m-ra dɨje batəm me man tɨ ə əl-m ə nə: “Dəw kɨ a o NDɨl ḭ taa rɨsɨ re ɨsɨ dɔe tɨ kɨn ə, a ra dɨje batəm me NDɨl tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɨngə mi, m-o nḛ kɨn kɨ kəm, adɨ m-ma naje təkɨ dəw kɨn e NGon Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lo ti kɨ go tɨ, Ja̰ təl re loe tɨ ka kɨn ɓəy, əi kɨ njé ndo je ləne joo. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Be ə, lokɨ Jəju ɨsɨ də, adɨ kəme e kɨ dɔe tɨ oo-e-n, nɨngə əl ə nə: «Oi NGon dəgɨ batɨ lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lokɨ njé ndo je lə Ja̰ ooi dɔ ta kɨn nɨngə, uni go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lokɨ Jəju ɨlə rətɨ nɨngə, oo-de kadɨ ɨsɨ uni goe, ə dəjɨ-de ə nə: «Ə ri ə ɨsɨ sangi ə?» Ə əi je ɨləi-e tɨ əi nə: «Rabi, lo kɨ ɨsɨ tɨ e ra be ə?» («Rabi» kɔr me nə: NJe ndo dɨje) ");
INSERT INTO bjvNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jəju əl-de ə nə: «Ɨrəi, ə a oi.» Be ə, awi, ooi lokɨ Jəju ɨsɨ tɨ. Ɓa ɨsi, tɔli ta ndɔ ləde rɔe tɨ no̰o̰. Dɔ kadɨ, e kadɨ kɨ sɔ kɨ lo sɔlɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andɨre kɨ ngoko̰ Sɨmo̰ Pɨyər e dəw kare dan dɨje tɨ kɨ joo kɨ ooi ta ta Ja̰ tɨ ə uni go Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dəw kɨ dɔsa̰y kɨ Andɨre ɨnge, e ngoko̰e Sɨmo̰. Ə əl-e ə nə: «J-ɨngə Məsi.» («Məsi» kɔr me nə «Kɨrɨsɨ, kɨ e dəw kɨ Luwə mbəte.») ");
INSERT INTO bjvNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ɓa, aw kɨ Sɨmo̰ rɔ Jəju tɨ. Ə Jəju go̰ Sɨmo̰ ba nɨngə əl Sɨmo̰ ə nə: «Ḭ Sɨmo̰, kɨ ngon lə Jonasɨ. A ɓari-ni Səpasɨ», («Səpasɨ», kɔr me nə «Pɨyər».) ");
INSERT INTO bjvNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lo ti kɨ go tɨ, Jəju un ndune kadɨ n-aw dɔnangɨ Galile tɨ. Dɔ rəbɨ tɨ, ɨngə Pɨlɨpɨ, nɨngə əl-e ə nə: «Un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pɨlɨpɨ e dəw kɨ Bətɨsayda tɨ, kɨ e ɓe lə Andɨre əi kɨ Pɨyər. ");
INSERT INTO bjvNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Go tɨ, Pɨlɨpɨ aw ɨngə Natanɨyəl, nɨngə əl-e ə nə: «J-ɨngə dəw kɨ *Mojɨ əl ta lie me ndu-kun tɨ, taa njé kəl ta je kɨ ta Luwə tɨ ka əli ta lie tɔ ka kɨn. E Jəju kɨ ngon lə Jɨsəpɨ kɨ Najarətɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ə Natanɨyəl əl-e ə nə: «Ɓe kɨ Najarətɨ tɨ kam kadɨ nḛ kɨ majɨ a tḛḛ tɨ tɔ ma?» Ə Pɨlɨpɨ əl-e ə nə: «Ɨre o.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Lokɨ Jəju oo Natanɨyəl ɨsɨ re kɨ rɔe tɨ, əl ta dɔe tɨ ə nə: «Oi *Isɨrayəl kɨ rɔjetɨ, kɨ dəw asɨ kɨngə nḛ kɨ majal rɔe tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Lo kɨn tɨ no̰o̰, Natanɨyəl dəjɨ Jəju ə nə: «Ɨra ban ə ɨgər-m ə?» Ə Jəju əl-e ə nə: «Kəte ɓəy taa kadɨ Pɨlɨpɨ ɓar-i, lokɨ ɨsɨ gɨn kagɨ mbay-kote tɨ kɨn m-o-i.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","NGata ə Natanɨyəl əl Jəju ə nə: «NJe ndo dɨje, ḭ NGon lə Luwə, ḭ ngar lə Isɨrayəl je.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jəju ɨle tɨ ə nə: «MBata kəl kɨ m-əli m-ə nə m-o-i gɨn kagɨ mbay-kote tɨ kɨn ə adɨ-m mei, nə a o nḛ je kɨ ətɨ ɓəl ɨtə e kɨn ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Taa Jəju təl ɨlə dɔ ta tɨ kɨn ɓəy ə nə: «Təkɨ rɔjetɨ, m-əl səsi, a oi dɔra̰ tḛḛ tane, nɨngə malayka je lə Luwə a awi kɨ taa je, təli kɨ nangɨ je dɔm tɨ mi *NGon dəw.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","NDɔ joo go tɨ, taa-naa to Kana tɨ kɨ Galile. Ko̰ Jəju e loe tɨ no̰o̰, ");
INSERT INTO bjvNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","nɨngə ɓari Jəju əi kɨ njé ndo je ləne loe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dɔ gangɨ lo madɨ ɓa, kasɨ goto. Ə ko̰ Jəju əl-e ə nə: «Dɨje a̰yḭ-naa kasɨ tɨgə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nə Jəju ɨle tɨ ə nə: «E ri ə ɨge rɔm tɨ ə dəne? Dɔ kadɨ ləm asɨ al ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ɓa ko̰e əl njé ləbɨ nḛ je ə nə: «Nḛ ri kɨ əl səsi ə ɨrai.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","NGa nɨngə gum je mehḛ kɨ kɨbə kɨ mbal ɨsi no̰o̰, tə gum je kɨ *Jɨpɨ je ɨsɨ ɔdi man kɨ mee tɨ ndogi rɔde kɨ go kujɨ nḛ ra je tɨ ləde kadɨ tə awi kɨ ta dɔde al, ta kəm Luwə tɨ. Gum je ka kɨn, kɨ kare mee a asɨ mbul joo je mɨtə je kare. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jəju əl njé ra kɨlə je ə nə: «Uti man me gum je tɨ kɨn adi rosɨ,» nɨngə uti man me tɨ adi rosɨ bututu. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɓa Jəju əl-de ə nə: «Ɔdi ngata, ə awii adi nje kɨndə kəmne go nḛ kuso je tɨ,» ɓa ɔdi awii adi-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","NJe kɨndə kəmne go nḛ kuso tɨ ɔdɨ man kɨ təl kasɨ ka kɨn tane tɨ. Gər lo kɨ kasɨ kɨn tḛḛ tɨ al, nə njé ra kɨlə je kɨ ɔdi kasɨ kɨn gəri majɨ. NJe kɨndə kəmne go nḛ kuso tɨ ɓar nje taa dəne ");
INSERT INTO bjvNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","əl-e ə nə: «Dɨje əi njé kadɨ kasɨ kɨ nəl dɨje a̰yḭ-naa kəte, adɨ lokɨ dɨje a̰yḭ-naa adɨ rade ɓəy taa təli dɔ e kɨ nəl al tɨ, nga ḭ ra ban ə ɨngəm kasɨ kɨ nəl adɨ ɨsɨ bɨtɨ dɔ kadɨ kɨ ne kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","E kɨn ə e nḛ kɔjɨ lə Jəju kɨ dɔ kəte kɨ ra Kana tɨ, dɔnangɨ Galile tɨ. Ra ɔjɨ-n tɔgɨne, nɨngə njé ndo je lie adi-e mede. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Go nḛ je tɨ kɨn, Jəju aw Kapərnayɨm tɨ, əi kɨ kone je, kɨ ngakone je, kɨ njé ndo je ləne; nə ke ə ɨsɨ Kapərnayɨm tɨ ndɔ ngay al. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","NDɔ ra nay Pakɨ lə *Jɨpɨ je e ɓasi ə Jəju aw Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jorijaləm tɨ, Jəju ɨngə njé gatɨ mangɨ je, njé gatɨ batɨ je, kɨ njé gatɨ kɨ də dum je natɨ kəy tɨ lə Luwə, taa njé mbəl la je ka ɨsɨ mbəli la je ləde no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Lo kɨn tɨ, Jəju ra ndəy kulə, tuwə-n-de pətɨ natɨ kəy tɨ lə Luwə kɔ, naa tɨ kɨ mangɨ je, kɨ batɨ je, taa njé mbəl la je ka, sane la je ləde kɔ, tɨndə tabɨlə je ləde tɨlə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɨngə əl njé gatɨ də je ə nə: «Ɔyi nḛ je kɨn pətɨ kɔ lo kɨn tɨ rangɨ, nɨngə kadɨ ɨrai me kəy lə Bai tə lo gatɨ ləsi al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lo kɨn tɨ, me njé ndo je ole dɔ ta tɨ kɨ ndangi me makɨtɨbɨ tɨ əi nə: «Ta lə kəy ləi uwə mem kuwə kɨ a tɔl-m.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nə Jɨpɨ je uni ta əli-e əi nə: «Nḛ kɔjɨ ri ə a tɔjɨ kadɨ jɨ gər-n təkɨ aw kɨ tɔgɨ kadɨ ɨra-n nḛ je kɨ ɨra kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ə Jəju əl-de ə nə: «Ɨtɔi kəy lə Luwə kam, ə me ndɔ tɨ kɨ mɨtə, m-a m-təl m-ɨndə taa gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ə Jɨpɨ je əli-e əi nə: «Jɨ ra ɓal kutɨ sɔ gɨde mehḛ ɓa jɨ ra kəy lə Luwə kam oy, nɨngə ḭ a təl ɨndə rangɨ me ndɔ tɨ kɨ mɨtə a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kəy kɨ Jəju əl tae kɨn e darɔe. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","NGa nɨngə, ndɔ kɨ Jəju ḭḭ-n taa dan njé koy je tɨ kɨn, me njé ndo je ole dɔ tɨ təkɨ ndɔ kɨ əl ta kɨn, ɓa adi mede ta lə Luwə kɨ ndangɨ nɨm, adi mede ta kɨ Jəju əl ka kɨn nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lokɨ Jəju e-n Jorijaləm tɨ, dɔkagɨlo ra nay pakɨ tɨ, dɨje ngay adi-e mede, lokɨ oi nḛ kɔjɨ je kɨ ra adɨ ooi kɨ kəmde. ");
INSERT INTO bjvNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nə Jəju ə, taa mede al, tadɔ gər-de pətɨ majɨ ngay, ");
INSERT INTO bjvNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","taa aw kɨ ndoo kadɨ dəw ma najɨ dɔ dəw tɨ ade al tɔ, tadɔ e wa gər nḛ je pətɨ kɨ to me dəw tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Me ɓutɨ tɨ lə *Parɨsɨ je, dɨngəm kare e no̰o̰, tɔe nə Nɨkodəm. E kɨ kare dan kɨ boy je tɨ lə *Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dɨngəm kɨn re rɔ Jəju tɨ kondɔ əl-e ə nə: «NJe ndo dɨje, jɨ gər kadɨ Luwə ɨləi kadɨ ɨre ɨndo-je nḛ, tadɔ dəw kɨ asɨ kadɨ ra nḛ je kɨ ətɨ ɓəl təkɨ ɨsɨ ɨra-n kɨn be kɨ kanjɨ kadɨ Luwə e sie goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jəju əl-e ə nə: «Təkɨ rɔjetɨ, adɨ m-əli, dəw kɨ asɨ kadɨ a oo ko̰ɓe lə Luwə kɨ kanjɨ kadɨ oji-e kojɨ kɨ sɨgɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lo kɨn tɨ, Nɨkodəm dəjɨ Jəju ə nə: «Dəw a ra ban be ə a təli oji-e kojɨ kɨ sɨgɨ, lokɨ tɔgɨ ngata kɨn ə? A asɨ kadɨ təl aw me kone tɨ gogɨ ɓəy kadɨ oji-e kɨ ko̰ joo a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jəju ɨle tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əli, dəw kɨ asɨ kadɨ a ur ko̰ɓe tɨ lə Luwə kɨ kanjɨ kadɨ oji-e me man tɨ, kɨ me NDɨl tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Darɔ dəw kɨ koo kɨ kəm, e kɨ kojɨ me məsɨ tɨ, nɨngə darɔ kɨ ndɨl, e NDɨl Luwə ə oje tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta kɨ m-əli m-ə nə: “Sɔbɨ kadɨ oji səsi kojɨ kɨ sɨgɨ” kɨn, adɨ əti ɓəl al. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tadɔ nəl ɨlə lo tɨ kɨ me ndɨgɨ, nɨngə ḭ o kae kɨ ɨsɨ ɓa, nə ɨgər lo kɨ ḭ tɨ al nɨm, ɨgər lo kɨ ɨsɨ aw tɨ al nɨm tɔ. Be ə, dəw kɨ NDɨl oje ka e be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Lo kɨn tɨ, Nɨkodəm dəjɨ Jəju ə nə: «Nḛ kɨn a ra nḛ kɨ go rəbɨ kɨ ban ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ə Jəju əl-e ə nə: «Ḭ kɨ ḭ nje ndo dɨje ndu-kun kɨ dɨje gəri dɔi *Isɨrayəl tɨ ka ɨgər nḛ je kɨn al ɓəy a? ");
INSERT INTO bjvNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Təkɨ rɔjetɨ, adɨ m-əli, j-əl ta dɔ nḛ tɨ kɨ jɨ gər, taa jɨ ma najɨ dɔ nḛ tɨ kɨ j-o kɨ kəmje tɔ, nə səi, ɨndɨgi najɨ kɨ ma ləje al. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Lokɨ m-əl səsi ta dɔ nḛ je tɨ kɨ dɔnangɨ tɨ ne ə adi-mi mesi al, ə ra ban be a adi-mi mesi dɔ nḛ je tɨ kɨ dɔra̰ tɨ kɨ m-a m-əl səsi tae ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Dəw kɨ aw dɔra̰ tɨ goto. Re e dəw ə, e mi *NGon dəw kɨ karm ba par ə m-ḭ dɔra̰ tɨ m-re dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nɨngə təkɨ *Mojɨ ɨlə-n li kɨ rai-e kɨ nɨngə-kasɨ ta kagɨ tɨ dɨlə lo tɨ ka kɨn ə, sɔbɨ kadɨ ɓəi-mi mi NGon dəw taa dɔ kagɨ-dəsɨ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","MBa kadɨ dəw kɨ adɨ-m mene ɓa, dəwe ɨsɨ kɨ dɔne taa bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tadɔ Luwə ndɨgɨ dɨje kɨ dɔnangɨ tɨ ne ngay, ə adɨ-de NGone kɨ kojɨ kare be, mba kadɨ dəw kɨ ade mene ɓa, kadɨ dəwe kɨn tujɨ kɔ al, nə kadɨ ɨsɨ kɨ dɔne taa bɨtɨ kɨ no̰ne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nḛ kɨ kadɨ dəw gər, Luwə ɨlə NGonne dɔnangɨ tɨ mba kadɨ gangɨ-n ta dɔ dɨje tɨ kɨ dɔnangɨ tɨ al, nə ɨlə sie mba kadɨ ajɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Dəw kɨ adɨ mene NGon Luwə, Luwə a gangɨ ta dɔe tɨ al, nə dəw kɨ ade mene al, dəwe kɨn Luwə gangɨ ta dɔe tɨ ngata. Tadɔ mbatɨ kadɨ mene NGon Luwə kɨ kare ba kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Go rəbɨ kɨ ta kɨ gangɨ re-n ə to kɨn: Kunjɨ re dɔnangɨ tɨ, nə dɨje kɨ dɔnangɨ tɨ ndɨgi tɨl yo ə mbati kunjɨ, mbata kɨlə rade je e kɨ majal. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Dɨje pətɨ kɨ əi njé ra majal, mbati kunjɨ, awi kɨ rɔe tɨ al. Nɨngə kɨ rɔjetɨ, ɓəli kaw rɔ kunjɨ tɨ, nə tə kunjɨ tɔjɨ nḛ rade je kɨ majal kɨ taga. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nə dɨje kɨ njé təl rɔde go ndu Luwə tɨ, əi rəi kɨ rɔ kunjɨ tɨ, mba kadɨ kunjɨ tɔjɨ kɨlə rade je kɨ taga wangɨ. Əi kɨlə je kɨ rai-de kɨ go ndu Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Go nḛ je tɨ kɨn, Jəju əi kɨ njé ndo je ləne ɔti awi dɔnangɨ Jude tɨ. Ɨsɨ tɨ səde no̰o̰ ba, ra-n dɨje batəm. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja̰ ka a ra dɨje batəm Eno̰ tɨ, kɨ e ɓasi kadɨ Salɨm tɨ no̰o̰ tɔ. Tadɔ e lo kɨ man e tɨ ngay. Nɨngə dɨje rəi kɨ rɔe tɨ adɨ rade batəm. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dɔkagɨloe tɨ kɨn, uwəi Ja̰ dangay tɨ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Be ə, njé ndo je lə Ja̰ kɨ na̰ je, naji-naa ta tɨ kɨ Jɨpɨ kare be, dɔ togɨ rɔ mba kadɨ Luwə ɔr-n ta dɔ dəw tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Go tɨ, awi ɨngəi Ja̰ əli əi nə: «Ɓaje, dəw kɨ ndɔ kɨ ai sie dam ba Jurdḛ tɨ kɨ kare, kɨ ndɔ kɨ ɨma najɨ lie ka kɨn, e ka a ra dɨje batəm tɔ, adɨ dɨje pətɨ awi kɨ rɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ə Ja̰ ɨlə-de tɨ ə nə: «Dəw kɨ asɨ kadɨ ɨngə nḛ madɨ kɨ rangɨ kɨ dɔne dɔ e tɨ kɨ Luwə wa ade kɨn goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Səi je wa ka asi kadɨ ɨmai najɨ ləm dɔ ta tɨ kɨ m-əl m-ə nə: “Mi, mi Kɨrɨsɨ al, nə mi dəw kɨ ɨləi-mi kadɨ m-re kəte no̰e tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kadɨ ɨgəri təkɨ, dəw kɨ nje taa dəne ə e ngaw dəne, nɨngə kɨ ɔjɨ dɔ basa madɨ ngaw dəne, e, e kadɨ basa madɨne tɨ kadɨ oo ta lie, ə lokɨ basa made əl ta ə osɨ mbie tɨ ɓa, rɔe nəl-e ngay dɔ tɨ. NGa nɨngə, e kɨn ə e rɔnəl ləm, nɨngə e rɔnəl kɨ tae asɨ-naa bərəre. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sɔbɨ kadɨ tɔɓa lie aw kɨ dɔ made tɨ dɔ made tɨ, ə kadɨ mi, m-təl kɨ gogɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«Dəw kɨ ḭ dɔra̰ tɨ e dɔ nḛ je tɨ pətɨ, nɨngə dəw kɨ dɔnangɨ tɨ ne e nḛ kɨ dɔnangɨ tɨ, adɨ əl ta dɔ nḛ je tɨ kɨ dɔnangɨ tɨ ne par. Nə dəw kɨ ḭ dɔra̰ tɨ e dɔ nḛ je tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ma najɨ dɔ nḛ je tɨ kɨ oo kɨ kəmne je kɨ mbine je. Nə dəw kɨ ndɨgɨ najɨ kɨ ma lie goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dəw kɨ ndɨgɨ najɨ kɨ ma lie ɓa, dəwe tɔjɨ kadɨ Luwə əl ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Təkɨ rɔjetɨ, dəw kɨ Luwə ɨle, əl ta je kɨ ta Luwə tɨ, tadɔ Luwə rose kɨ NDɨlne. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baw NGon ndɨgɨ NGon, adɨ ɨyə̰ nḛ je pətɨ me jie tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dəw kɨ adɨ mene NGon, a ɨsɨ kɨ dɔne taa bɨtɨ kɨ no̰ne tɨ, nə dəw kɨ təl rɔne go ndu tɨ lə NGon al, kɨsɨ kɨ dɔ taa lie goto, wongɨ lə Luwə a e dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dɨje əli adɨ *Parɨsɨ je ooi təkɨ Jəju ɔi njé ndo je gone tɨ ɨtə Ja̰, taa rade batəm ɨte tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","NGa nɨngə təkɨ rɔjetɨ ɓa, Jəju wa ra dɨje batəm al, nə e njé ndo je lie. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ə lokɨ Jəju oo kadɨ Parɨsɨ je ooi ta kɨn be ɓa, ɨyə̰ dɔnangɨ Jude ə təl aw Galile tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","NGa nɨngə kadɨ aw Galile tɨ, sɔbɨ kadɨ a ɨndə dɔnangɨ kɨ *Samari tɨ gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E be ə aw tḛḛ ɓe bo tɨ kɨ ɓari-e Sisar kɨ e sa̰y al kɨ lo ndɔr kɨ ndɔ kɨ *Jakobɨ adɨ ngonne Jɨsəpɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","E loe tɨ wa kɨn ə bɨlə man lə Jakobɨ to tɨ. Ə Jəju njɨyə ɔ ɓa, təl ɨsɨ nangɨ ta man tɨ ka kɨn. E dɔ kadɨ tɨ kɨ kaw kɨ jam dɔ ɓe tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lo kɨn tɨ no̰o̰, dəne kɨ Samari tɨ kare re kadɨ ɔdɨ man ə Jəju əl-e ə nə: «Adɨ-m man m-a̰y.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","*NJé ndo je lie ɓa awi me ɓe tɨ kadɨ ndogi nḛ kuso. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nə dəne kɨ Samari tɨ ka kɨn əl Jəju ə nə: «E ta kɨn ban ə? Ḭ Jɨpɨ tɔ, ra ban be ə a dəjɨ-m mi kɨ mi dəne kɨ Samari tɨ man kadɨ a̰y ə?.» Dəne əl be mbata *Jɨpɨ je gei kadɨ n-əi kɨ Samari je n-ɨndəi rɔde naa tɨ dɔ nḛ madɨ tɨ kare al. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jəju ɨle tɨ ə nə: «Kɨn ə re kəte ɨgər kadɨ-kare lə Luwə nɨm, dəw kɨ nje dəji man ka̰y kɨn nɨm ə, re ḭ ə re a dəje kadɨ adi man kajɨ kadɨ a̰y.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dəne əl-e ə nə: «Ɓaɓe! Aw kɨ nḛ kɔdɨ man al tɔ, taa bɨlə man əbɨ tɔ, nga a ra ban be ə a ɨngə man kajɨ kɨn ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ḭ o rɔi kadɨ ɨtə bawje Jakobɨ kɨ adɨ-je man kɨn nɨm taa e wa əi kɨ nganne je a̰yḭ-naa kɨ da je ləne nɨm kɨn a?.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jəju ɨle tɨ ə nə: «Dəw kɨ a̰y man kɨ j-a-n ne kɨn, kɨndə a ra-e ɓəy; ");
INSERT INTO bjvNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nə dəw kɨ a a̰y man kɨ m-a m-ade kɨn, kɨndə a ra-e gogɨ al ratata. Man kɨ m-a m-ade kɨn yo ə a təl ta ɓe man kɨ man kajɨ a tḛḛ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dəne əl ə nə: «Ɓaɓe, adɨ-m man kɨ a əl tae kɨn kadɨ kɨndə ra-m gogɨ al, taa kadɨ m-təl m-re-n ne be gogɨ m-ɔdɨ man al ngata tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ə Jəju əl-e ə nə: «Aw, ɨɓar ngawi ə ɨtəl ɨre ne.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ɓa dəne əl Jəju ə nə: «Dəw oo ngawm al.» Nɨngə Jəju əl-e ə nə: «Ta ləi e kɨ rɔjetɨ kadɨ əl ə nə dəw oo ngawi al, ");
INSERT INTO bjvNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tadɔ ɨtaa dɨngəm je mi, nə e kɨ ɨsɨ sie ɓasɨne kɨn e ngawi al. Lo kɨn tɨ e ta kɨ rɔjetɨ ə əl.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","No̰o̰ be ngata ə dəne əl ə nə: «Ɓaɓe, m-gər kadɨ ḭ nje kəl ta kɨ ta Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bawje je ɔsi məkəsɨde nangɨ no̰ Luwə tɨ dɔ mbal tɨ kɨn, nɨngə səi əli əi nə lo kɔsɨ məkəsɨ nangɨ no̰ Luwə tɨ e Jorijaləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jəju əl-e ə nə: «Dəne, ɨtaa mem. Dɔkagɨlo re kɨ kadɨ a ɔsi məkəsɨsi nangɨ no̰ Bawje Luwə tɨ dɔ mbal tɨ kam al nɨm, Jorijaləm tɨ al nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Səi dɨje kɨ Samari tɨ, ɔsi məkəsɨsi nangɨ no̰ Luwə tɨ kɨ ɨgəri-e al, nə je, j-ɔsɨ məkəsɨje nangɨ no̰ Luwə tɨ kɨ jɨ gər-e, tadɔ kajɨ ḭ rɔje tɨ je Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","NGa nɨngə ndɔ re, ɓa e ndɔ kɨ kadɨ njé kɔsɨ məkəsɨ kɨ rɔjetɨ nangɨ no̰ Luwə tɨ a ɔsi məkəsɨde nangɨ no̰ Bawje Luwə tɨ me NDɨl tɨ kɨ me nḛ ra tɨ kɨ rɔjetɨ. Əi je kɨn ə əi njé kɔsɨ məkəsɨ kɨ rɔjetɨ nangɨ no̰ Luwə tɨ kɨ Bawje ɨsɨ sangɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Luwə e NDɨl, nɨngə kadɨ njé kɔsɨ məkəsɨde nangɨ no̰e tɨ ɔsi me NDɨl tɨ kɨ me nḛ ra tɨ kɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ə dəne əl-e ə nə: «M-gər kadɨ Dəw kɨ mbətɨ lə Luwə kɨ ɓari-e Kɨrɨsɨ kɨn a re. Nɨngə ndɔ kɨ a re ɓa, a ɔr-je me nḛ je pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ə Jəju əl-e ə nə: «E darɔm mi wa ə m-a m-əli ta am.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lo kɨn tɨ no̰o̰ be, njé ndo je lə Jəju tḛḛi no̰o̰ rəi, nɨngə ndɔjɨ-de ngay kadɨ ooi Jəju a əl ta kɨ dəne dəw, nə dəw kɨ kadɨ əl-e ə nə: «E ri ə ɨge jie tɨ ə?» Ə se «mba ri ə əl-e ta ə?» goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dəne ɨyə̰ gum man ləne no̰o̰ be, ə a̰y aw me ɓe bo tɨ əl ə dɨje ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ɨrəi oi dəw kɨ əl-m nḛ je pətɨ kɨ m-ra kɨn. A e Kɨrɨsɨ al bɨtɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓa dɨje tḛḛi me ɓe bo tɨ kɨ taga awi kɨ rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lokɨ dəne ɔtɨ aw kɨn ə njé ndo je əli Jəju əi nə: «NJe ndo dɨje, uso nḛ!» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nə Jəju əl-de ə nə: «Mi m-aw kɨ nḛ kuso kɨ kadɨ m-uso kɨ e nḛ kuso kɨ ɨgəri al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dɔ ta tɨ kɨn njé ndo je dəji-naa ta dande tɨ əi nə: «Dəw madɨ ade nḛ uso ma?» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ə Jəju əl-de ə nə: «Nḛ kuso ləm e ra go ndɨgɨ tɨ lə NJe kɨlə-m, kɨ tɔl ta kɨlə lie. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Səi əli mesi tɨ əi nə: “Nay sɔ ɓəy ə ko a asɨ tətɨ,” nə mi m-a m-əl səsi m-ə nə: uni kəmsi kɨ taa ɨgo̰i ndɔr oi; ko tutɨ asɨ kɨjə ngata! ");
INSERT INTO bjvNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kɨ j-a ne kɨn, dəw kɨ nje tətɨ ko ɨngə nḛ kɨgə go ji ləne nɨngə kaw kandɨ nḛ kɨ dɔ-naa tɨ mba kɨsɨ kɨ dɔ taa kɨ bɨtɨ kɨ no̰ tɨ kadɨ tə dəw kɨ nje dɨbɨ nḛ nɨm nje təte nɨm rai rɔnəl naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tadɔ kujɨ ta kɨ ə nə: “Dəw kare dɨbɨ ə e kɨ nungɨ tətɨ” kɨn e kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","M-ɨlə səsi m-adɨ awi təti ko me ndɔr tɨ kɨ səi je ɨrai kɨle al. NJé kɨ rangɨ ɨngəi ko̰e, nɨngə səi ɨrəi təti kandɨ kɨlə ləde.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Dɨje kɨ dɔnangɨ Samari tɨ pətɨ kɨ me ɓe bo tɨ kɨn adi mede Jəju dɔ najɨ kɨ ma tɨ kɨ dəne ma dɔe tɨ ə nə: «Əl-m nḛ je pətɨ kɨ m-ra.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","NGa nɨngə lokɨ rəi tḛḛi rɔe tɨ, dəji-e kadɨ ɨsɨ səde, ə Jəju ɨsɨ səde ndɔ joo. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kɨ takul ta kɨ tae tɨ, dɨje kɨ njé kade mede əi ngay wa ɓəy; ");
INSERT INTO bjvNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","nɨngə əli dəne əi nə: «E kɨ mbata ta je kɨ əl-je wa kɨn par ɓa j-ade-n meje al, nə je wa j-o ta kɨ tae tɨ kɨ mbije, nɨngə jɨ gər kadɨ e nje kajɨ dɨje təkɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","NDɔ joo go tɨ, Jəju ɔtɨ no̰o̰ təl aw dɔnangɨ Galile tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nɨngə e wa ma najɨ ə nə: «Dəw kɨ nje kəl ta kɨ ta Luwə tɨ kɨ ɨngə kɔsɨ-gon me ɓe kojɨ-ne tɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nə lokɨ re tḛḛ Galile tɨ, dɨje kɨ dɔnangɨ Galile tɨ uwəi-e kɨ rɔde tɨ majɨ ngay, tadɔ əi je wa ka awi lo ra nay tɨ kɨ Jorijaləm tɔ adɨ ooi nḛ je pətɨ kɨ Jəju ra lo ra nay tɨ kɨ kəmde. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jəju təl re Kana kɨ Galile tɨ kɨ ndɔ kɨ ra man adɨ təl kasɨ tɨ. Nɨngə dɨngəm kare kɨ e dəw kɨ bo lə asɨgar je kɨ ɨsɨ ra kɨlə kɨ ngar, ə rɔ ngone kɨ dɨngəm to-e Kapərnayɨm tɨ e no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lokɨ dɨngəm ka kɨn oo kadɨ Jəju ḭ Jude tɨ re dɔnangɨ Galile tɨ, re ɨnge, no̰ kɨ dɔe tɨ kadɨ aw Kapərnayɨm tɨ ajɨ ngonne kɨ to ta koy tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ə Jəju əl-e ə nə: «Kɨn ə re oi nḛ kɔjɨ je, kɨ nḛ je kɨ ətɨ ɓəl kɨ kəmsi al ə a asi kadɨ a adi mesi al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dəw kɨ bo kɨ nje ra kɨlə kɨ ngar ka kɨn əl Jəju ə nə: «Ɓaɓe, təkɨ ngonm oy al ɓəy kɨn ɨre ɓe ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nə Jəju əl-e ə nə: «Aw, ngoni ajɨ ngata.» Ɓa dɨngəm taa me Jəju dɔ ta tɨ kɨ əl, adɨ osɨ dɔ rəbɨ tɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ə lokɨ e dɔ rəbɨ tɨ ɨsɨ təl, ɓəə je lie awi tɨləi kəme əli-e əi nə: «NGoni ajɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɨngə dəjɨ-de se kadɨ kɨ ban ə rɔ ngon to-n sotɨ wa? Ɓa əli-e əi nə: «E tagɨne kɨ kadɨ kɨ dɔgɨ gɨde mɨtə ə rɔe kɨ tɨngə ngay kəte ka kɨn təl sɔl.» ");
INSERT INTO bjvNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lo kɨn tɨ, baw ngon oo kadɨ e dɔ kadɨ tɨ wa kɨ Jəju əl-e-n ə nə: «NGoni ajɨ ngata» kɨn. Loe tɨ no̰o̰, dɨngəm adɨ mene Jəju, naa tɨ kɨ dɨje kɨ me kəy tɨ lie ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","E kɨn ə e nḛ kɔjɨ kɨ ko̰ joo kɨ Jəju ra lokɨ təl-n Jude tɨ re Galile tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Go nḛ je tɨ kɨn, *Jɨpɨ je rai nay ləde adɨ Jəju aw Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","NGa nɨngə Jorijaləm tɨ, lo ndogɨ man kɨ ɓari-e kɨ ta ebɨrə nə Bətɨsata to no̰o̰, ɓasi kadɨ ta rəbɨ ndogɨ bɔr tɨ kɨ dɨje ɨsɨ awii kɨ nḛ kul je me ɓe bo tɨ. Pal je əi mi ta lo ndogɨ man tɨ ka kɨn, ");
INSERT INTO bjvNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","nɨngə gɨn pal je tɨ ka kɨn njé mo̰y je toi tɨ mbar mbar: njé kəm tɔ je, njé mətɨ je, kɨ njé rɔ koy njururu je. Toi ɨsɨ ngɨnəi ta man kɨ kadɨ ɔdɨ rɔne; ");
INSERT INTO bjvNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tadɔ malayka lə Ɓaɓe kare a ur me man tɨ kadɨ buu. NJe mo̰y kɨ dɔsa̰y kɨ osɨ me man tɨ kɨ buu ka kɨn ɓa, re mo̰y lie to-n ban ban ka ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Loe tɨ kɨn, dəw kɨ mo̰y ra-e ɓal kutɨ mɨtə gɨde jijoo e tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jəju oo-e to nangɨ, nɨngə lokɨ əli-e təkɨ to me ko̰ tɨ kɨn be ɓal ngay, dəje ə nə: «Ɨge kɨngə rɔ nga a?.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ə nje mo̰y ɨle tɨ nə: «Ɓaɓe, dəw kɨ kadɨ un-m ɨlə-m me man tɨ lokɨ man ɨsɨ ɔdɨ rɔne kɨn goto. Lokɨ m-ə nə m-aw ɓa, dəw kɨ rangɨ ur me tɨ no̰m tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ə Jəju əl-e ə nə: «Ḭ taa, un tuwə ləi ə ɨnjɨyə aw.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nɨngə ta naa tɨ no̰o̰, dɨngəm ɨngə rɔ nga adɨ un tuwə ləne ə njɨyə aw. NGa nɨngə ndɔe tɨ kɨn e ndɔ taa kə̰ə̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ə Jɨpɨ je əli dɨngəm kɨ ɨngə rɔ nga ka kɨn əi nə: «Ɓone e ndɔ taa kə̰ə̰, e go tɨ al kadɨ otɨ tuwə ləi ɨnjɨyə-n.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nə əl-de ə nə: «E dəw wa kɨ adɨ-m rɔ nga kɨn ə əl-m ə nə: “Un tuwə ləi ə aw.”» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ə dəji-e ta əi nə: «Dəw ə wa kɨ əli ə nə: “Un tuwə ləi ə aw kɨn e na̰ ə”?» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nə dəw kɨ ɨngə rɔ nga gər-e al, tadɔ Jəju ur kakɨ dan kosɨ dɨje tɨ kɨ ai loe tɨ no̰o̰ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","NGan kadɨ je go tɨ, Jəju təl ɨnge natɨ kəy tɨ lə Luwə ɓa əl-e ə nə: «O, ɓasɨne kɨn ɨngə rɔ nga ngata. Nɨngə kadɨ ɨra majal al ratata nə tə nḛ madɨ kɨ nga̰ ngay tḛḛ dɔi tɨ ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lo kɨn tɨ, dɨngəm aw əl Jɨpɨ je təkɨ e Jəju ə adɨ-ne rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","E be ə, Jɨpɨ je awii kɨ ta kɨ Jəju kɨ ra nḛ kɨn ndɔ taa kə̰ə̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nə Jəju əl-de: «Bɨtɨ ɓone ka Bai ɨsɨ ta ra kɨ dɨje tɨ, nɨngə mi ka sɔbɨ kadɨ m-ra kɨ dɨje tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kɨ mbata ta kɨ Jəju əl kɨn, njé kun dɔ Jɨpɨ je sangi rəbɨ kɨ rangɨ dɔ made tɨ kadɨ n-tɔli-e; tadɔ əli əi nə Jəju ra nḛ bujɨ-n ndɔ taa kə̰ə̰ par al, nə əl ɓəy tɔ ə nə Luwə e Bawne kɨ ojɨ-ne, adɨ ra rɔne kadɨ ne dəw kɨ n-asɨ-naa kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jəju təl un ta əl-de ə nə: «Oyo, təkɨ rɔjetɨ, adɨ m-əl səsi, mi NGon lə Luwə m-asɨ kadɨ m-ra nḛ dɔ rɔm al. E nḛ kɨ m-o Bai ra ə mi m-ra. Nḛ kɨ Bai ra ɓa, mi NGone m-ra kae tɨ wa kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tadɔ Bai ndɨgɨ-m mi NGone adɨ tɔjɨ-m nḛ je pətɨ kɨ e wa ra. A tɔjɨ-m kɨlə ra je kɨ ətɨ ɓəl ɓəl ngay ɓəy kɨ kadɨ a ra səsi ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tadɔ tə ka kɨ Bai un-n njé koy je lo koy tɨ adɨ ɨsi kəm ka kɨn ə, mi NGone, m-ge ɓa, m-a m-ade ɨsɨ kəm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bai gangɨ ta dɔ dəw tɨ al, nə adɨ-m tɔgɨ mi NGone kadɨ m-gangɨ ta dɔ dɨje tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kadɨ dɨje pətɨ ɔsi gonm təkɨ ɔsi gon Bai be tɔ. Dəw kɨ ɔsɨ gonm mi NGon al, ɔsɨ gon Bai kɨ nje kɨlə-m al jagɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ oo ta ləm, taa adɨ mene nje kɨlə-m nɨm tɔ ɓa, dəwe kɨn a ɨngə kajɨ kɨ bɨtɨ kɨ no̰ tɨ. Ta kɨ gangɨ a osɨ dɔe tɨ al, nə də dɔ koy ngata adɨ e me kajɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Təkɨ rɔjetɨ, adɨ m-əl səsi, ndɔ a re, nɨngə ndɔe re ngata kɨ kadɨ njé koy je a ooi dɔ ndum mi NGon lə Luwə. NGa nɨngə dɨje kɨ a oi dɔ ndum a ɨsi kəm ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tadɔ tə ka kɨ Bai ə e nje kadɨ dɨje kajɨ ka kɨn ə, adɨ-m mi NGone tɔgɨ kadɨ m-adɨ dɨje kajɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Adɨ-m mi NGone tɔgɨ kadɨ m-gangɨ-n ta dɔ dɨje tɨ, mbata mi *NGon dəw. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nɨngə kadɨ adi ətɨ səsi ɓəl al, tadɔ ndɔ re ngata kɨ kadɨ dɨje pətɨ kɨ toi ɓe nɨn tɨ a ooi dɔ ndum. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","NJé kɨ rai nḛ kɨ majɨ a tḛḛi lo koy tɨ mba kaw kɨ kajɨ tɨ, ə njé ra nḛ kɨ majal a tḛḛi lo koy tɨ mba kaw kɨ lo gangɨ ta tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mi m-asɨ kadɨ m-ra nḛ madɨ dɔ rɔm al. Mi m-gangɨ ta kɨ go ndu tɨ kɨ m-ɨngə rɔ Luwə tɨ. NGa nɨngə, ta kɨ gangɨ ləm e ta kɨ gangɨ kɨ dana tadɔ m-ɨsɨ m-sangɨ ndɨgɨ ləm al nə m-ɨsɨ m-sangɨ ndɨgɨ lə nje kɨlə-m.» ");
INSERT INTO bjvNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jəju əl ə nə: «Kɨn ə re e mi wa ə m-ma najɨ dɔ rɔm tɨ ə re dəw kɨ a ndɨgɨ səm dɔ najɨ kɨ ma tɨ ləm goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nə e dəw kɨ rangɨ ə ma najɨ dɔm tɨ, nɨngə m-gər kadɨ najɨ kɨ ma dɔm tɨ kɨn e ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Səi ɨləi kɨ dɨje rɔ Ja̰ Batɨsɨ tɨ, ə Ja̰ ma najɨ kɨ rɔjetɨ dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mi m-aw kɨ ndoo kadɨ dəw ma najɨ dɔm tɨ al, nə m-əl be mba kadɨ ɨngəəi kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ja̰ Batɨsɨ e lambɨ kɨ kɨndə por tɨ mba koo lo, nɨngə ɨndɨgi kadɨ ɨrai rɔnəl kunje tɨ ngon kagɨ lo kare. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","NGa nɨngə mi najɨ kɨ kadɨ dɨje mai dɔm tɨ ɨtə ya̰ Ja̰ sa̰y. Kɨlə je kɨ m-ra-de, adɨ e kɨlə je kɨ Bai adɨ-m kadɨ m-ra kɨn əl ta dɔm tɨ taa tɔjɨ kadɨ Bai ɨlə-m tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bai wa kɨ ɨlə-m, ma najɨ dɔm tɨ. Nə ke ə səi oi ndue ndɔ kare al nɨm, oi ta kəme al nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ɨngəmi ta lie mesi tɨ al tadɔ mi kɨ ɨlə-m kɨn adi-mi mesi al. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɨsɨ sangi gɨn ta lə Luwə maje maje tadɔ oi kadɨ a ɨngəi kajɨ kɨ bɨtɨ kɨ no̰ tɨ me tɨ; nga nɨngə e ta lə Luwə wa kɨn ə e nje ma najɨ dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nə səi ɨmbati rəi rɔm tɨ kadɨ ɨngəi kajɨ kɨ bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mi m-sangɨ kadɨ dɨje pɨti-mi al. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nɨngə nḛ kare kɨ m-o rɔsi tɨ, m-gər kadɨ ɨndɨgi Luwə al. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi m-re kɨ tɔ Bai, nə ɨmbati kadɨ uwəi-mi kɨ rɔsi tɨ. Nɨngə kɨn ə dəw kɨ rangɨ re kɨ tɔne wa ɓa, a uwəi-e kɨ rɔsi tɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Səi kɨ ɨsɨ sangi kadɨ ɨngəi tɔjɨ kɨ kadɨ səi je wa ɨləi dɔ-naa tɨ kɨ yo je kɨ ne je yo, ɓɨ ɨsangi kadɨ ɨngəi tɔjɨ kɨ ḭ rɔ Luwə tɨ kɨ e kɨ karne ba ə e Luwə kɨn al, nɨngə a rai ban be ə a adi-mi mesi ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kadɨ oi təkɨ e mi ɓa m-a m-ɨndə ta dɔsi tɨ no̰ Bai tɨ al, nə e *Mojɨ kɨ ɨndəi mesi dɔe tɨ kɨn ə a ɨndə ta dɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nɨngə kɨn ə re adi mesi Mojɨ təkɨ rɔjetɨ dɔ ta tɨ kɨ ndangɨ ə re a adi-mi mesi tɔ, nə e kadɨ kɨ adi-e mesi al ə adi-mi mesi al tɔ, tadɔ e ta kɨ dɔm tɨ ə Mojɨ ndangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ə re oi ta kɨ ndangɨ kɨn tə ta kɨ rɔjetɨ al ə ra ban be ə a adi-mi mesi dɔ ta tɨ kɨ m-əl ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Go nḛ je tɨ kɨn, Jəju ɔtɨ no̰o̰, aw gɨdɨ ba tɨ kɨ Galile, kɨ ɓari-e ba kɨ Tɨbərɨyadɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kosɨ dɨje ngay uni goe, tadɔ dɨje ooi nḛ kɔjɨ je kɨ ətɨ ɓəl kɨ Jəju ra dɔ njé mo̰y je tɨ ajɨ-n-de. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jəju al dɔ mbal tɨ taa, nɨngə ɨsi nangɨ kɨ njé ndo je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dɔkagɨloe tɨ kɨn, nay lə *Jɨpɨ je kɨ ɓari-e nay Pakɨ e ɓasi. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lokɨ Jəju un kəmne nɨngə, oo kosɨ dɨje ngay kɨ ɨsɨ rəi kɨ rɔe tɨ. Ə dəjɨ Pɨlɨpɨ ə nə: «J-a j-ɨngə mapa ra ə j-a jɨ ndogɨ kadɨ kosɨ dɨje kɨn pətɨ usoi ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jəju dəjɨ ta kɨn be mba kadɨ oo-n ta kɨ me Pɨlɨpɨ tɨ, tadɔ e wa gər nḛ kɨ kadɨ a ra ɓətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ə Pɨlɨpɨ ɨle tɨ ə nə: «Kɨn ə re jɨ ndogɨ mapa kɨ la kɨlə kɨ ndɔ ɓu joo mɨndɨ ka asɨ kadɨ a ɔdɨ tade ndə̰y ndə̰y pətɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lo kɨn tɨ, nje ndo lə Jəju kare kɨ tɔe nə Andɨre, kɨ e ngoko̰ Sɨmo̰ Pɨyər, əl Jəju ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«NGon kɨ dɨngəm kare, aw kɨ mapa mi, kɨ e mapa kɨ rai kɨ ko kɨ ɓari-e ɔrjɨ, taa ngan kanjɨ je joo tɔ. Nə e kɨn e nḛ kɨ kadɨ dəw əl tae kadɨ dɨje tɨ kɨ bore be kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ə Jəju ə nə: «Adi dɨje pətɨ ɨsi nangɨ.» Loe tɨ kɨn, wale e ngay tɨtɨ, adɨ dɨje uwəi lo ɨsi tɨ nangɨ. Dɨje kɨn asi dɨngəm je dɨbɨ mi. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Be ə, Jəju un mapa, ra oyo Luwə dɔ tɨ, ɓa ləbɨ dɨje pətɨ kɨ ai loe tɨ no̰o̰ kɨn. Un kanjɨ ləbɨ-de kae tɨ ka kɨn tɔ. Adɨ-de kɨ go me ge tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lokɨ usoi asɨ-de ngata ɓa, Jəju əl njé ndo je ləne ə nə: «Ɨkawi gɨnde je kɨ nay kɨn, kadɨ dəw ɨyə̰ nḛ madɨ kɔ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Be ə, mapa kɨ mi kɨ dɨje usoi, njé ndo je kawi gɨnde kɨ nay kare dɔgɨ gɨde e joo. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lokɨ dɨje ooi nḛ kɔjɨ kɨ ətɨ ɓəl kɨ Jəju ra kɨn nɨngə əli əi nə: «Kɨ rɔjetɨ, dəw kɨn e NJe kəl ta kɨ ta Luwə tɨ kɨ sɔbɨ kadɨ tə re dɔnangɨ tɨ ka kɨn ə wa.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","NGa nɨngə, Jəju gər kadɨ a rəi tə uni-e awi ɨndəi-e ngar, adɨ təl ɔr rɔne aw gogɨ dɔ mbal tɨ, kɨ karne ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lokɨ lo sɔl, njé ndo je lə Jəju awi kadɨ ba tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Awi ali me to tɨ, uni tade kaw kɨ Kapərnayɨm tɨ, kɨ e dam ba tɨ kɨ kare. Lo kɨn tɨ, lo ndul dɔde tɨ, taa Jəju ka təl re rɔde tɨ al ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nəl ɨlə kɨ tɔgɨne ngay, adɨ man ḭ pu pu. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","*NJé ndo je ɔsi to asɨ kulə mətər mi be nɨngə, oi Jəju ka a njɨyə dɔ man tɨ ɨsɨ re kɨ rɔ to tɨ. Lokɨ ooi Jəju a njɨyə dɔ man tɨ, ɓəl ra-de ngay. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nə Jəju əl-de ə nə: «E mi, ə ɨɓəli al!» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lo kɨn tɨ, ndɨgi kadɨ n-uni Jəju me to tɨ, nə ta naa tɨ no̰o̰ par ə, to ɔdɨ nangɨ lo kɨ ɨsɨ awi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lo ti go tɨ, kosɨ je kɨ nayḭ-naa gɨdɨ ba tɨ, oi kadɨ tagɨne to e kare ba par ə njé ndo je lə Jəju ali me tɨ awi dɔ rɔde, ɓɨ Jəju al me tɨ səde al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lo kɨn tɨ no̰o̰, to je kɨ rangɨ ḭḭ Tɨbərɨyadɨ tɨ rəi, ai lo ka tɨ, ɓasi kadɨ lo tɨ kɨ Ɓaɓe əl ta dɔ mapa tɨ tɨtɨ ə tḛḛ ba̰y ba̰y adɨ-de usoi ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lokɨ kosɨ je ooi Jəju al nɨm, njé ndo je lie al nɨm ɓa, ali me to je tɨ awi kɨ Kapərnayɨm sangɨ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lokɨ ɨngəi Jəju dam ba tɨ kɨ kare, dəji-e əi nə: «NJe ndo dɨje, ɨre ɨtḛḛ ne kadɨ ban tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ə Jəju təl əl-de ə nə: «Adɨ m-əl səsi ta kɨ rɔjetɨ, ɨsɨ sangi-mi mbata mapa kɨ usoi ndan mesi, ɓɨ e mbata gər ɓa ɨgəri me nḛ kɔjɨ je kɨ m-ra kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Majɨ kadɨ ɨrai kɨlə mba nḛ kuso kɨ a ndum kɨn al, nə mba nḛ kuso kɨ a to bɨtɨ kɨ no̰ tɨ. E nḛ kuso kɨ mi *NGon dəw m-a m-adɨ səsi, mbata Luwə kɨ Bawje ra ndajɨ kare rɔm tɨ mba tɔjɨ-m təkɨ mi dəw ləne.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lo kɨn tɨ, kosɨ je təli dəji-e əi nə: «E ri ə sɔbɨ kadɨ jɨ ra taa kadɨ jɨ ra-n kɨlə kɨ Luwə ndɨgɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ə Jəju təl əl-de ə nə: «Nḛ kɨ Luwə ge rɔsi tɨ, e kadɨ adi mesi dəw kɨ ɨle.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Be ə əli-e əi nə: «Nḛ kɔjɨ ri ə a ra taa kadɨ j-o ə j-adi-n me je ə? Kɨlə ri ə a ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kaje je usoi nḛ kuso kɨ ḭ dɔra̰ tɨ kɨ ɓari-e nə man. Be ə ndangi me makɨtɨbɨ tɨ əli ə nə: «Adɨ-de usoi mapa kɨ ḭ dɔra̰ tɨ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lo kɨn tɨ, Jəju təl əl-de ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, e *Mojɨ ə adɨ səsi mapa kɨ ḭ dɔra̰ tɨ al, nə e Bai Luwə ə adɨ səsi mapa kɨ rɔjetɨ kɨ ḭ dɔra̰ tɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","MBata mapa lə Luwə kɨ adɨ dɨje, e mapa kɨ ḭ dɔra̰ tɨ taa kɨ nje kadɨ dɨje kɨ dɔnangɨ tɨ ne ɨsi kɨ dɔde taa.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Be ə, təli əli-e əi nə: «Ɓaɓe, adɨ-je mapa kɨn kɨ ndɔe ndɔe adɨ j-uso.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jəju əl-de ay njay ə nə: «Mi mapa kɨ dəw uso ə a oy al. Dəw kɨ re rɔm tɨ ɓo a ra-e al nɨm, dəw kɨ adɨ-m me nḛ ka, kɨndə a ra-e al nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nɨngə m-əl səsi təkɨ oi-mi, nə adi-mi mesi al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","NJé kɨ Bai adɨ-m-de a rəi rɔm tɨ. Nɨngə dəw kɨ re rɔm tɨ, m-a m-tuwe al jagɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","MBata m-ḭ dɔra̰ tɨ, m-re dɔnangɨ tɨ mba ra ndɨgɨ ləm al, nə kadɨ m-ra ndɨgɨ lə nje kɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nɨngə nḛ kɨ nje kɨlə-m kɨ ɨlə-m ndɨgɨ kadɨ m-ra ə to kɨn: ndɨgɨ kadɨ tə m-tḭ ta dəw kare dan dɨje tɨ kɨ adɨ-m-de kɨn al, nə kadɨ m-tḛḛ səde ji koy tɨ dɔbəy ndɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","E kɨn ə e nḛ kɨ Bai ndɨgɨ: ndɨgɨ kadɨ dɨje pətɨ kɨ ooi-mi NGon lə Luwə ə adi-mi mede, ɨngəi kajɨ kɨ to bɨtɨ kɨ no̰ tɨ, ə kadɨ m-tḛḛ səde ji koy tɨ dɔbəy ndɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","*Jɨpɨ je ɓai ta dɔ Jəju tɨ mbata əl ə nə: «Mi mapa kɨ ḭ dɔra̰ tɨ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɨngə əli-naa dande əi nə: «Jəju kam, e ngon lə Jɨsəpɨ al a? Jɨ gər ko̰e je kɨ bawe je majɨ tɔ, nga ra ban be ə əl ə nə n-ḭ dɔra̰ tɨ taa ə n-re ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jəju təl əl-de ə nə: «Ɨɓai ta dansi tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dəw kɨ asɨ kadɨ re rɔm tɨ kɨ kanjɨ kadɨ Bai kɨ ɨlə-m, ɔr-e ta rəbɨ goto. Nɨngə re Bai tḛḛ ta rəbɨ ade ɓa, mi m-a tḛḛ sie ji koy tɨ dɔbəy ndɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","NDangi me makɨtɨbɨ tɨ lə kɨ kare dan NJé kəl ta kɨ ta Luwə tɨ əi nə: “Pətɨ, Luwə a ndo-de nḛ,” nɨngə dəw kɨ ra kɨ oo ndu Luwə kɨ Bai ə taa nḛ ndo lie, dəwe kɨn re rɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","E kɨn ɓa tɔjɨ kadɨ dəw oo Bai Luwə al; e nje kḭ rɔ Luwə tɨ kɨ karne ba ə oo Bai Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kɨ rɔjetɨ, m-əl səsi, dəw kɨ un mene adɨ-m, ɨngə kajɨ kɨ to bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi mapa kɨ dəw uso ə a oy al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dɨlə mbo tɨ, kasi je usoi nḛ kuso kɨ ḭ dɔra̰ tɨ kɨ ɓari-e nə man, ka oyi. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nə mapa kɨ ḭ dɔra̰ tɨ kɨn, e mapa kɨ kadɨ re dəw uso ɓa, dəwe a oy al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi mapa kɨsɨ kəm ba kɨ ḭ dɔra̰ tɨ taa. Re dəw uso mapa kɨn ɓa, dəwe a oy al. Mapa kɨ m-a m-adɨ, e darɔm kɨ kadɨ dɨje ɨsii kəm ba.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lo kɨn tɨ, Jɨpɨ je naji-naa ta ngay dande tɨ əi nə: «Dəw kɨn a ra ban ta kadɨ a adɨ-je darɔe kadɨ j-uso ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ə Jəju əl-de ə nə: «Kɨ rɔjetɨ, adɨ m-əl səsi, re usoi darɔm mi NGon dəw al nɨm, a̰yḭ-naa məsɨm al nɨm ə, a ɨngəi kajɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dəw kɨ uso darɔm ə a̰y məsɨm tɔ nɨngə, dəwe kɨn a ɨngə kajɨ kɨ to bɨtɨ kɨ no̰ tɨ, nɨngə m-a m-tḛḛ sie ji koy tɨ dɔbəy ndɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","MBata darɔm e nḛ kuso kɨ rɔjetɨ, ə məsɨm e nḛ ka̰y kɨ rɔjetɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dəw kɨ uso darɔm nɨm, a̰y məsɨm nɨm tɔ ɓa, je sie je naa tɨ kare ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bai kɨ ɨlə-m ɨsɨ kəm ba adɨ mi m-ɨsɨ kəm ba kɨ takule. Be ə, dəw kɨ uso darɔm a ɨsɨ kəm ba kɨ ta kulm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","E kɨn ə e mapa kɨ ḭ dɔra̰ tɨ taa. E tə mapa kɨ kasi je usoi ə oyi kɨn al, nə e mapa kɨ dəw uso ɓa, dəwe kɨn a oy al, a ɨsɨ kɨ dɔne taa kɨ ndɔe ndɔe.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ta je kɨn tḛḛ ta Jəju tɨ lo kɨ ɨsɨ ndo-n nḛ dɨje gɨn kəy kaw-naa tɨ lə Jɨpɨ je, me ɓe tɨ kɨ Kapərnayɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dɨje ngay dan njé ndo je tɨ lə Jəju, lokɨ ooi ta kɨn ta Jəju tɨ nɨngə, əli əi nə: «Ta kɨn e ta kɨ nga̰ ngay, dəw kɨ asɨ kadɨ a ɨndə mbine go tɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jəju gər mene tɨ kadɨ njé ndo je lie ɨsɨ ɓai ta dɔ ta tɨ lie. Be ə əl-de ə nə: «Ta kɨn tɨgə səsi jɨgɨ tɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A kɨn ə re oi-mi *NGon dəw m-təl m-aw taa lo kɨsɨ tɨ kɨ m-ɨsɨ tɨ kəte kɨn ə a rai ban ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","E NDɨl ə e nje kadɨ dəw ɨsɨ kɨ dɔne taa. Dəw kɨ dɔrɔne e nḛ madɨ al. Nɨngə ta je kɨ m-əl səsi kəte kɨn e NDɨl nɨm e kɨsɨ kɨ dɔ taa nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nə dɨje madɨ dansi tɨ adi-mi mede al.» Jəju əl be, tadɔ lo kɨlə ngɨre tɨ ɓəy, gər dɨje kɨ a adi-e mede al, taa gər dəw kɨ nje kɨle ji njé ba̰ je tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jəju ɨlə dɔ tɨ ɓəy ə nə: «E mbata kɨn ə m-əl səsi m-ə nə: “Dəw kɨ Bai ade ta rəbɨ al, asɨ kadɨ a re rɔm tɨ dɔrɔne al.”» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ḭ dɔ ndɔe tɨ no̰o̰ kɨn, ngay je dan njé ndo je tɨ lie təli goe tɨ, mbati njɨyəi sie. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ə Jəju tu rɔne kɨ rɔ njé kɨ dɔgɨ gɨde joo tɨ əl-de ə nə: «NGa səi, a awi al ya̰ne ma?» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nə Pɨyər əl Jəju ə nə: «Ɓaɓe, j-a j-aw kɨ rɔ naa tɨ ə? Ḭ ə ta kajɨ e me ji tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Je, meje pətɨ e dɔi tɨ. Nɨngə jɨ gər kadɨ ḭ NJe kay njay kɨ Luwə ɨle.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jəju təl əl-de ə nə: «E mi ə m-mbətɨ səsi səi kɨ dɔgɨ gɨde e joo kɨn, nə dəw kare dansi tɨ, ndɨl su e mee tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Lo kɨn tɨ, Jəju ɨsɨ əl ta kɨ dɔ Judasɨ tɨ kɨ ngon lə Sɨmo̰ Isɨkarɨyotɨ tɨ. Tadɔ e ə e dəw kare dan njé ndo je tɨ kɨ dɔgɨ gɨde e joo kɨ a ɨlə Jəju ji njé ba̰ je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Go tɨ, Jəju nay kɨ lo njɨyə tɨ dɔnangɨ Galile tɨ, ge al kadɨ n-njɨyə n-aw ə n-təl dɔnangɨ Jude tɨ, tadɔ njé kun dɔ *Jɨpɨ je ɨsɨ sangi kadɨ n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","NGa nɨngə dɔkagɨlo ra nay lə Jɨpɨ je kɨ kadɨ ɨsi gɨn Kəy lo tɨ e ɓasi, ");
INSERT INTO bjvNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ə ngako̰ Jəju je əli-e əi nə: «Ḭ ne ə aw dɔnangɨ Jude tɨ adɨ njé ndo je ləi ka ooi nḛ je kɨ ɨsɨ ra-de kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Dəw kɨ ndɨgɨ kadɨ dɨje ooi-ne kam a ra nḛ je kutɨ lo tɨ al. NGa nɨngə, təkɨ ɨsɨ ra nḛ je kɨ ətɨ ɓəl kɨn, majɨ kadɨ ɨra adɨ dɨje pətɨ ooi-ni.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nə təkɨ rɔjetɨ, ngako̰e je wa adi-e mede al. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ə Jəju əl-de ə nə: «NDɔ ləm re al ɓəy; nə səi je, ndɔ je pətɨ to majɨ mbata tɨ ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Dɨje kɨ dɔnangɨ tɨ ne kɨn a awi səsi kɨ ta al, nə mi ɓa, mede majal səm mbata m-əl kɨlə rade je kɨ majal kɨ taga. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Səi ə awi lo ra nay tɨ kɨn. Mi ɓa, m-a m-aw al, tadɔ ndɔ ləm nay ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Go ta je tɨ kɨ əl kɨn, ɨsɨ Galile tɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nə lokɨ ngako̰e je awi lo ra nay tɨ, e ka ɔtɨ osɨ dɔ rəbɨ tɨ tɔ kɨ kanjɨ kadɨ dəw oo-e. Aw tə lo kaw kɨ lo ɓɔyɔ tɨ be. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dɔkagɨlo ra nay tɨ, njé kun dɔ *Jɨpɨ je sangi Jəju nɨngə dəji əi nə: «E lo tɨ kɨ ra be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Dɨje naji-naa ta tɨ ngay dɔe tɨ dan kosɨ je tɨ; njé kɨ na̰ je əli əi nə: «E dəw kɨ majɨ,» ə njé kɨ nungɨ əli əi nə: «Jagɨ, ɨsɨ ɓukɨ kosɨ dɨje wale,» tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","E be ka dəw kɨ kadɨ əl ta lie kɨ taga wangɨ goto, ɓəli njé kun dɔ Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","NDɔ je kɨ mba ra nay də tḛḛ dana ngata ɓa Jəju aw gɨn kəy tɨ lə Luwə, ɨsɨ ndo nḛ dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E nḛ kɨ ndɔjɨ Jɨpɨ je ngay adɨ dəji-naa ta əi nə: «E kam dəw ndo-e nḛ al tɔ, nga ra ban ə gər nḛ ətɨ ɓəl be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ə Jəju ɨlə-de tɨ ə nə: «Nḛ kɨ m-ɨsɨ m-ndo kɨn ngɨre ḭ rɔm tɨ al, nə ngɨre ḭ rɔ Luwə tɨ kɨ nje kɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kɨn ə re dəw ndɨgɨ kadɨ n-ra nḛ kɨ Luwə ndɨgɨ ɓa, lo kɨn tɨ ə a gər ay njay se nḛ kɨ m-ɨsɨ m-ndo kɨn ngɨre ḭ rɔ Luwə tɨ ə se e mi wa ə m-ɨndə ngɨre wa. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dəw kɨ nje kəl ta kɨ tɔne wa ɨsɨ sangɨ tɔɓa ləne wa. Nə dəw kɨ nje sangɨ tɔɓa lə nje kɨlə-ne a əl ta kɨ rɔjetɨ, nɨngə nḛ kɨ dana al goto rɔe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","*Mojɨ adɨ səsi ndu-kun adɨ ɨtaai majɨ, nə dəw kɨ təl rɔne go tɨ goto. NGa ra ban ə ɨsɨ sangi kadɨ ɨtɔli-mi ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ə kosɨ je əli-e əi nə: «Ḭ aw kɨ ndɨl kɨ majal mei tɨ! Na̰ ə ɨsɨ sangɨ kadɨ n-tɔli ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ə Jəju təl un ta ɨlə-de tɨ ə nə: «M-ra nḛ kare ba be, ə səi pətɨ ətɨ səsi ɓəl! ");
INSERT INTO bjvNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mojɨ adɨ səsi ndu kadɨ ɨjəi mɔtɨ ngan je (nɨngə e ndu kɨ tḛḛ rɔ Mojɨ tɨ ne par al, nə e kaje je kɨ kəte nu ə adi ndu kɨn) ɓa səi ɨsɨ ɨjəi mɔtɨ ngan je ndɔ taa kə̰ə̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kɨn ə re ɨjəi mɔtɨ ngon ndɔ taa kə̰ə̰ tɨ kadɨ tə dəw kɨdɨ ndu-kun lə Mojɨ al ə, ra ban ə mesi to səsi dɔm tɨ mi kɨ m-ajɨ darɔ dəw ba pətɨ ndɔ taa kə̰ə̰ tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɨyə̰i ta gangɨ ta kɨ go lo koo tɨ ləsi, ə ɨgangi ta kɨ dana.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Dɨje kɨ Jorijaləm tɨ əli əi nə: «Dəw kam al ə dɨje ɨsɨ sangi kadɨ n-tɔli-e a? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","NGa yə a əl ta taga wangɨ am, ə dəw əl-e ta madɨ al! NJé kun dɔje je ooi kadɨ e Kɨrɨsɨ ə se? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kɨ ne kɨn, jɨ gər lo kɨ dəw kɨn ḭ tɨ majɨ, nə ndɔ kɨ Kɨrɨsɨ kɨ e dəw kɨ Luwə mbəte a tḛḛ hɔy ɓa, dəw kare ka a gər lokɨ ḭ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lo kɨn tɨ, Jəju kɨ ɨsɨ ndo dɨje nḛ gɨn kəy tɨ lə Luwə un ndune kɨ taa ə nə: «Ɨgai kadɨ ɨgəri-mi majɨ, taa ɨgəri lo kɨ m-ḭ tɨ tɔ! Nɨngə e mi wa ɓa m-ɨlə rɔm al, nə Luwə kɨ nje kɨlə-m e dəw kɨ asɨ kadɨ dəw ɨndə mene dɔe tɨ. Səi, ɨgəri-e majɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mi m-gər-e majɨ tadɔ m-ḭ rɔe tɨ, taa e e ə ɨlə-m tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Lo kɨn tɨ, dɨje ɨsɨ sangi kadɨ n-uwəi Jəju, nə dəw kɨ kadɨ ɨndə jine dɔe tɨ goto, tadɔ ndɔ lie asɨ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nɨngə dan kosɨ je tɨ, dɨje ngay adi-e mede ɓa əli əi nə: «Dɔkagɨlo kɨ Kɨrɨsɨ a re ə a ra nḛ kɔjɨ je kɨ ɨtə ya̰ dɨngəm kɨn wa?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ə ta kɨ kosɨ je ɨsɨ kɔti gɨn mɨndɨde tɨ ɔjɨ dɔ Jəju kɨn osɨ mbi *Parɨsɨ je tɨ, adɨ Parɨsɨ je, kɨ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je ɨləi njé ngəm dɔ lo je ləde kadɨ awi uwəi Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ə Jəju əl ə nə: «M-a mi səsi ngan ndɔ je ndə̰y ɓəy, ɓa m-a m-aw kɨ rɔ nje kɨlə-m tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A sangi-mi nə a ɨngəi-mi al, tadɔ lo kɨ m-a mi tɨ kɨn a asi kadɨ a awi tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ə dɔ ta tɨ kɨn *Jɨpɨ je dəji-naa ta əi nə: «Lo kɨ ra be ə a aw tɨ ə kadɨ j-a j-ɨnge al ə? A aw go ngakone je tɨ kɨ sanəi-naa dan Gɨrəkɨ je tɨ kɨn kadɨ aw ndo nḛ Gɨrəkɨ je ma? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ta kɨ əl ə nə: “A sangi-mi nə a ɨngəi-mi al, tadɔ lo kɨ m-a mi tɨ kɨn a asi kadɨ a awi tɨ al,” kɨn me nə ri ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dɔbəy ndɔ ra nay, kɨ e ndɔ kɨ bo ngay ɓa, Jəju ḭ a taa un ndune əl ə nə: «Kɨn ə re dəw madɨ kɨndə ra-e ə, kadɨ re rɔm tɨ a̰y man. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dəw kɨ adɨ-m mene ɓa, “ndəə man kɨ nje kadɨ dɨje ɨsi kɨ dɔde taa a tḛḛ nga̰mee tɨ,” təkɨ Makɨtɨbɨ lə Luwə əl-n.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lo kɨn tɨ; Jəju ɨsɨ əl ta lə NDɨl Luwə kɨ kadɨ dɨje kɨ adi-e mede a ɨngəi, mbata dɔkagɨloe tɨ kɨn NDɨl Luwə re dɔ dɨje tɨ al ɓəy, tadɔ Jəju ɨngə kɔsɨ-gon al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dan kosɨ je tɨ, dɨje madɨ kɨ ooi ta kəl Jəju əli əi nə: «Təkɨ rɔjetɨ, dəw kam e NJe kəl ta kɨ ta Luwə tɨ kɨ sɔbɨ kadɨ a re ka kɨn ə wa!» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","NJé kɨ na̰ je əli əi nə: «E Kɨrɨsɨ kɨ Luwə mbəte.» Nə njé kɨ nungɨ ɓəy naji əi nə: «Kadɨ Kɨrɨsɨ e dəw kɨ Galile tɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Makɨtɨbɨ lə Luwə əl təkɨ Kɨrɨsɨ a e dəw kɨ gɨn kojɨ tɨ lə *Dabɨdɨ, nɨngə a tḛḛ kɨ ta rəbɨ kɨ Bətɨləhəm tɨ, kɨ e ngon ɓe kojɨ Dabɨdɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","E be ə, kosɨ je gangi-naa mbata lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Dɨje madɨ dande tɨ ndɨgi kuwe, nə dəw kɨ kadɨ ɨndə jine dɔe tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","NJé ngəm ta lo lə *Jɨpɨ je kɨ awi kadɨ uwəi Jəju ka kɨn, təli rəi rɔ njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ əi kɨ *Parɨsɨ je, ə njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je kɨ Parɨsɨ je dəji-de əi nə: «Ra ban ə ɨrəi sie al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ə njé ngəm lo je əli əi nə: «NDɔ kare j-o dəw əl ta təkɨ dɨngəm kɨn ɨsɨ əl-n al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ə Parɨsɨ je dəji-de əi nə: «Səi je ka ɨyə̰i rɔsi adɨ ədɨ səsi tɔ a?. ");
INSERT INTO bjvNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oi dəw kare be dan njé kɨ boy je tɨ ə se dan Parɨsɨ je tɨ ade mene no̰o̰ a? ");
INSERT INTO bjvNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kosɨ je kam əi dɨje kɨ gəri ndu-kun lə *Mojɨ al, əi dɨje kɨ Luwə a tujɨ-de kɔ!» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nɨkodəm kɨ e kɨ kare dan Parɨsɨ je tɨ kɨ kəte aw rɔ Jəju tɨ un ta əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kɨn ə re dəw oo ta kɨ ta dəw tɨ al nɨm, taa oo nḛ kɨ ra al nɨm ə, ndu-kun ləje a gangɨ ta dɔe tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nə ɨləi-e tɨ əi nə: «Ḭ ka ḭ dəw kɨ Galile tɨ tɔ a? Ɨsangɨ gɨne majɨ o, nje kəl ta kɨ ta Luwə tɨ kɨ kadɨ e dəw kɨ Galile tɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Go tɨ, dəw kɨ ra ka ɔtɨ aw ɓe ləne. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jəju ɔtɨ no̰o̰ aw dɔ mbal kagɨ bɨni je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nə lokɨ lo ti njay par ə təl re natɨ kəy tɨ lə Luwə. Dɨje pətɨ rəi kɨ rɔe tɨ, ə ɨsɨ nangɨ ɨsɨ ndo-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lo kɨn tɨ, njé ndo ndu-kun je, kɨ *Parɨsɨ je rəi kɨ dəne kɨ ɨndəi jide dɔe tɨ lo kuwə marɨm tɨ, adi-e a ta kəm dɨje tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nɨngə əli Jəju əi nə: «NJe ndo dɨje, dəne kam j-ɨndə jije dɔe tɨ lo kuwə marɨm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","NGa nɨngə, *Mojɨ əl-je me ndu-kun tɨ kadɨ ko dəne je kɨ be kɨn jɨ tɨlə-de kɨ mbal jɨ tɔl-de kɔ, ə se ḭ, ta ləi e ri wa?» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Əli ta kɨn be tə kulə kɨ kɨyə kadɨ uwəi Jəju tə ɨndəi ta dɔe tɨ. Nə Jəju ɨlə dɔne nangɨ ə ɨsɨ ndangɨ nḛ kɨ ngon jine nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ə lokɨ nayḭ-naa kɨ lə dəje ta tɨ, Jəju ɔr dɔne taa əl-de ə nə: «Dəw kɨ dansi tɨ ne kɨ ra majal nja kare al ɓa, kadɨ ɨle kɨ mbal dɔsa̰y.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jəju əl ta be ɓa təl ɨlə dɔne nangɨ gogɨ, ɨsɨ ndangɨ nḛ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ə lokɨ ooi ta kɨn ɓa, ɔti kare kare, ɨlə ngɨre dɔ njé kɨ tɔgɨ tɨ, təl-n dɔ njé kɨ du tɨ. Ta tɔl tae tɨ, Jəju nay kɨ karne ba. Dəne ka kɨn ə a dadan lo tɨ; ");
INSERT INTO bjvNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ə Jəju un dɔne kɨ taa əl-e ə nə: «Dəne, dɨje ka awi ra? Dəw kare ka gangɨ ta dɔi tɨ al a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɓa dəne ɨle tɨ ə nə: «Ɓaɓe, dəw kare ka gangɨ ta dɔm tɨ al,» ə Jəju əl-e ə nə: «Mi ka m-gangɨ ta dɔi tɨ al jagɨ tɔ, nga nɨngə aw, ə ɨra majal gogɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jəju təl əl-de ɓəy ə nə: «Mi kunjɨ kɨ dɔnangɨ tɨ, dəw kɨ un gom, a njɨyə me tɨl tɨ al, kunjɨ kɨ nje kadɨ dɨje ɨsi kɨ dɔde taa a unjɨ dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lo kɨn tɨ, *Parɨsɨ je əli-e əi nə: «Ḭ wa ə ɨsɨ ma najɨ kɨ dɔi tɨ ɓa, najɨ kɨ ma ləi e kɨ rɔjetɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ə Jəju ɨlə-de tɨ ə nə: «Re mi wa m-ma najɨ dɔ rɔm tɨ ka m-gər kadɨ najɨ kɨ ma ləm e ta kɨ rɔjetɨ, tadɔ mi m-gər lo kɨ m-ḭ tɨ nɨm, m-gər lo kɨ m-ɨsɨ m-aw tɨ nɨm, nə səi je, ɨgəri lo kɨ m-ḭ tɨ al nɨm, ɨgəri lo kɨ m-ɨsɨ m-aw tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Səi ɨsɨ gangi ta kɨ go lo koo tɨ lə dəw, nə mi m-gangɨ ta dɔ dəw tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A kɨn ə re m-gangɨ ta no̰o̰ ɓa, e ta kɨ gangɨ kɨ go rəbe tɨ, tadɔ mi kɨ karm ə m-gangɨ ta al, Bai kɨ nje kɨlə-m e səm naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nɨngə me ndu-kun tɨ ləsi wa ka ndangi əi nə: “Kɨn ə re dɨje joo mai najɨ, ə najɨ kɨ ma ləde aw go-naa tɨ ɓa, ta ləde e ta kɨ rɔjetɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mi wa m-ma najɨ dɔ rɔm tɨ, nɨngə Bai kɨ ɨlə-m ka ma najɨ ləne dɔm tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nɨngə dəji-e əi nə: «Bawi e lo kɨ ra tɨ dana?» Ə Jəju ɨlə-de tɨ ə nə: «Ɨgəri-mi al, taa ɨgəri Bai al tɔ. Kɨn ə re ɨgəri-mi ə re a ɨgəri Bai tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ta je kɨn tḛḛ ta Jəju tɨ lokɨ ɨsɨ ndo-n dɨje nḛ natɨ kəy tɨ lə Luwə. Ɨsɨ lo tɨ kɨ nḛ je kɨ dɨje ɨsɨ ɨləi kadɨ-kare tɨtɨ adi Luwə ɨsɨ tɨ. NGa nɨngə dəw uwe al, tadɔ ndɔ lie asɨ al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jəju əl-de ta kɨ rangɨ ɓəy ə nə: «M-a m-aw, nɨngə a sangi-mi, nə a oyi me majal je tɨ ləsi. Lo kɨ m-a m-aw tɨ kɨn a asi kadɨ a awi tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lo kɨn tɨ, *Jɨpɨ je əli-naa əi nə: «A tɔl rɔne ə se ra ban ə əl ə nə: “Lo kɨ m-a m-aw tɨ kɨn a asi kadɨ a awi tɨ al ə?”» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ə Jəju əl-de ə nə: «Səi, səi dɨje kɨ dɔnangɨ tɨ nangɨ ne, ə mi, mi dəw kɨ dɔra̰ tɨ taa nu tɔ; səi dɨje lə dɔnangɨ, nə mi, mi dəw lə dɔnangɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɨngə e mbata kɨn ə m-əl-n səsi m-ə nə: “A oyi me majal je tɨ ləsi.” Kɨn ə re adi-mi mesi təkɨ mi “NJe kɨsɨ no̰o̰” al ə, a oyi me majal je tɨ ləsi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ə dəji-e əi nə: «Ḭ wa kam ḭ na̰ ə?» Ɓa Jəju ɨlə-de tɨ ə nə: «Mi dəw kɨ m-əl səsi lo kɨlə ngɨre tɨ nu wa kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","NGa nɨngə, kɨ ɔjɨ dɔsi, m-aw kɨ ta ngay kadɨ m-əl je, m-gangɨ je; nə ta kɨ m-ɨngə rɔ nje kɨlə-m tɨ kɨn par ə m-a m-ɨlə mbḛe rɔ dɨje tɨ kɨ dɔnangɨ tɨ ne. E, ta lie e ta kɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jəju ɨsɨ əl-de ta kɨ dɔ Bawne Luwə tɨ nə əi je gəri me ta kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ə Jəju əl-de ə nə: «NDɔ kɨ a ɓəi-mi *mi NGon dəw taa kagɨ-dəsɨ tɨ kɨn ɓa, a gəri kadɨ mi “NJe kɨsɨ no̰o̰”; taa a gəri kadɨ m-ra nḛ madɨ dɔ rɔm al tɔ, nə e nḛ kɨ Bai ndo-m ə m-ɨsɨ m-əl. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","NJe kɨlə-m e səm naa tɨ; ɨyə̰-m kɨ karm al, tadɔ dɔkagɨlo je pətɨ m-ra nḛ kɨ nəl-e.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lokɨ Jəju əl ta kɨn be, dɨje ngay adi-e mede. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jəju əl *Jɨpɨ je kɨ adi-e mede ə nə: «Kɨn ə re ai dɔ njasi tɨ me ta tɨ ləm ɓa, səi njé ndo je ləm kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A gəri nḛ kɨ rɔjetɨ, nɨngə nḛ kɨ rɔjetɨ kɨn a taa səsi ɨlə səsi taa ji ɓəə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ə əi je əli Jəju əi nə: «Je ngan ka *Abɨrakam, nɨngə jɨ ra ɓəə lə dəw ndɔ kare al tɔ, nga ra ban be ə ḭ əl ə nə nḛ kɨ rɔjetɨ a taa-je ɨlə-je taa ji ɓəə tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ə Jəju ɨlə-de tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi: dəw kɨ ra kɨ ra majal, e ɓəə lə majal. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɓəə a ɨsɨ kɨ dɨje kɨ ɨsɨ ra ɓəə ləde kɨn bɨtɨ kɨ no̰ tɨ al, nə ngon kojɨ-de a ɨsɨ səde bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adɨ re NGon lə Luwə taa səsi ji ɓəə tɨ ɨlə səsi taa ɓa, a səi dɨje kɨ taa kɨlə taa kɨ rɔjetɨ ji ɓəə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","NGa nɨngə, m-gər kadɨ səi ngan ka Abɨrakam; nə ɨsɨ sangi kadɨ ɨtɔli-mi tadɔ ɨmbati ta ləm. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mi m-ɨsɨ m-əl nḛ kɨ m-o rɔ Bai tɨ, nə səi ɓa, ɨsɨ rai nḛ kɨ bawsi əl səsi tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nɨngə ɨləi Jəju tɨ əi nə: «Kaje e Abɨrakam.» Ə Jəju əl-de ə nə: «Kɨn ə re səi ngan ka Abɨrakam təkɨ rɔjetɨ ə re a rai kɨlə ra Abɨrakam. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mi m-əl səsi nḛ kɨ rɔjetɨ kɨ m-ɨngə rɔ Luwə tɨ, nɨngə kɨ ɓasɨne kɨn ɨsɨ sangi kadɨ ɨtɔli-mi. E kɨn e kɨlə kɨ Abɨrakam ra al jagɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Səi ɨsɨ rai kɨlə ra bawsi.» Nɨngə ɨləi Jəju tɨ əi nə: «Je ngan je kɨ kojɨ gɨn kaya tɨ al; Bawje e kare ba ə e Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ə Jəju əl-de ə nə: «Kɨn ə re Luwə e Bawsi ə re a ɨndɨgi-mi, tadɔ m-tḛḛ rɔe tɨ ə m-re lo kɨn tɨ. E mi wa ə m-re kɨ dɔm al, nə e e ə ɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","MBata ri ə ɨgəri me ta ləm al ə? Ɨgəri al tadɔ asi kadɨ uri mbisi go ta tɨ ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Su ə e bawsi, nɨngə ɨndɨgi kadɨ ɨrai ndɨgɨ lə bawsi. E dəw kɨ e nje tɔl dɨje lo kɨlə ngɨrə kosɨ tɨ lie nu. E a me nḛ ra tɨ kɨ rɔjetɨ nja kare al, tadɔ nḛ kɨ rɔjetɨ goto rɔe tɨ. Kɨn ə re əl ta kɨ ngom ɓa, e kɨn ə e ta kɨ osɨ ɓoe tɨ, tadɔ e nje ngom nɨm, e baw nḛ ra kɨ ngom nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mi ɓa, mi nje kəl ta kɨ rɔjetɨ ə ɨmbati kadɨ adi-mi mesi. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na̰ dansi tɨ ə asɨ kadɨ tɔjɨ təkɨ m-ra majal ə? A kɨn ə re m-əl ta kɨ rɔjetɨ ə, ra ban ə ɨmbati kadi-mi mesi ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dəw kɨ e ya̰ Luwə, a oo ta lə Luwə, nɨngə səi, oi ta lie al, mbata səi ya̰e je al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lo kɨn tɨ, *Jɨpɨ je əli Jəju əi nə: «E go rəbe tɨ kadɨ j-əl j-ə nə: ḭ dəw kɨ *Samari tɨ, taa ndɨl kɨ majal ɨsɨ mei tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ə Jəju əl-de ə nə: «Jagɨ, ndɨl kɨ majal goto mem tɨ, nə nḛ kare kɨ m-o ɓa, mi m-ɔsɨ gon Bai, ə səi ɨmbati kɔsɨ gonm tɔ par. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi m-ɨsɨ m-sangɨ kadɨ dɨje ɨləi tɔjɨ dɔm tɨ al. Dəw kɨ ɨsɨ sangɨ kadɨ dɨje ɨləi tɔjɨ dɔm tɨ e no̰o̰, e ə a gangɨ ta kɨn adɨ-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨngə təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ təl rɔne go ta tɨ ləm ɓa, dəwe kɨn a oy al ratata.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lo kɨn tɨ no̰o̰, Jɨpɨ je əli-e əi nə: «Kɨ ne kɨn, jɨ gər majɨ ngata təkɨ ndɨl kɨ majal ɨsɨ mei tɨ. *Abɨrakam oy, taa njé kəl ta je kɨ ta Luwə tɨ ka oyi tɔ, nɨngə ḭ əl ə nə: “Dəw kɨ təl rɔne go ta tɨ ləi ɓa, dəwe kɨn a oy al ratata.” ");
INSERT INTO bjvNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ḭ ɨtə kaje Abɨrakam kɨ oy kɨn a? Taa njé kəl ta kɨ ta Luwə tɨ ka oyi tɔ! Ḭ o rɔi kadɨ ḭ na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ɓa Jəju ɨlə-de tɨ ə nə: «Kɨn ə re m-tɔjɨ rɔm mi wa nɨngə, e tɔjɨ kɨ ndae goto. NGa nɨngə, dəw kɨ nje kɨlə tɔjɨ dɔm tɨ e Bai. E kɨ ɨsɨ əli ta lie əi nə e Luwə ləsi, ");
INSERT INTO bjvNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","nə ɨgəri-e al. Mi m-gər-e. Kɨn ə re m-əl m-ə nə m-gər-e al ə, re m-a mi nje ngom tə səi je be tɔ. Nə mi m-gər-e, taa m-təl rɔm go ta tɨ lie tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kasi Abɨrakam ra rɔnəl ngay mbata ɨndə mene tɨ kadɨ n-a n-oo ndɔ kɨ m-a m-re-n. NGa nɨngə oo ndɔ rem, adɨ rɔe nəl-e ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lo kɨn tɨ, Jɨpɨ je dəji Jəju əi nə: «Ɨra ɓal kutɨ mi al ɓəy ə kəmi oo Abɨrakam a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ə Jəju ɨlə-de tɨ ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, kəte no̰ kojɨ Abɨrakam tɨ, “Mi m-ɨsɨ no̰o̰”.» ");
INSERT INTO bjvNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lo kɨn tɨ no̰o̰ be, kəi mbal kadɨ n-tɨləi Jəju, nə ur dan kosɨ je, ə tḛḛ gɨn kəy tɨ lə Luwə kɔ, aw. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lokɨ Jəju ɨsɨ ɨndə də nɨngə, oo dəw kɨ kəme tɔ lo koje tɨ nu ɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","*NJé ndo je lie dəji-e əi nə: «NJe ndo dɨje, dɨngəm kɨ kəme tɔ lo koje tɨ nu kɨn, kəme tɔ ɔjɨ-n dɔ majal lie e wa ə se, ɔjɨ-n dɔ majal lə njé koje je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ə Jəju əl-de ə nə: «E ta lə majal lie al nɨm, e ta lə majal lə njé koje je al nɨm, nə kəme tɔ be mba kadɨ Luwə ɔjɨ-n tɔgɨne taga kadɨ dɨje gəri. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dɔkagɨlo kɨ kadɨ to ɓəy, sɔbɨ kadɨ jɨ rai kɨlə lə dəw kɨ nje kɨlə-m, tadɔ lo a ndul ɓa, lo kadɨ dəw a ra kɨlə goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Təkɨ mi-n dɔnangɨ tɨ ne ɓəy, mi kunjɨ kɨ dɔnangɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lokɨ Jəju əl ta je kɨn be ɓa, go tɨ, tɨbɨ man tane nangɨ, lɔy-n nangɨ, ɔr gɨdɨ kəm nje kəm tɔ tɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nɨngə, əl nje kəm tɔ ə nə: «Aw ɨtogɨ kəmi lo ndogɨ man tɨ kɨ Sɨlowe.» «Sɨlowe» kɔr me nə «nje kaw kɨlə». Be ə, nje kəm tɔ aw togɨ kəmne loe tɨ ka kɨn, ɓa ta təl-e, kəme oo lo majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","NJé gədɨ kəy je lie, kɨ njé je kɨ kəte ɨsɨ ooi-e lo kɔy nḛ tɨ, əli əi nə: «Ma, e kam e dəw kɨ nje kɨsɨ nangɨ, kɔy nḛ ka kɨn al a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nɨngə njé kɨ na̰ je əli əi nə: «E darɔe e wa.» Ə njé kɨ nungɨ əli əi nə: «Jagɨ e e al, nə e dəw kɨ nje tɨtɨ naa sie.» Nɨngə e wa kɨ dɔne əl ə nə: «E darɔm mi wa.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","NGata ə dəji-e ta əi nə: «Re e ḭ wa ə, ra ban be ə kəmi oo lo ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ə əl-de ə nə: «Dɨngəm kɨ tɔe nə Jəju ə lɔy nangɨ ɔr gɨdɨ kəm tɨ, ə əl-m ə nə: “Aw Sɨlowe tɨ ɨtogɨ kəmi”, ə m-aw m-togɨ kəmm, par ə kəmm oo lo majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nɨngə dəji-e əi nə: «Dɨngəm kɨn e ra be ə?» Ə əl-de ə nə: «M-gər al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lo kɨn tɨ, ɔri dɨngəm kɨ kəte kəme tɔ ka kɨn awi sie rɔ *Parɨsɨ je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nɨngə, ndɔe tɨ kɨ Jəju lɔy-n nangɨ kɨ man tane ɔr gɨdɨ kəme tɨ adɨ kəme oo lo ka kɨn e ndɔ taa kə̰ə̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ə Parɨsɨ je dəji-e ta kɨ ya̰de rangɨ ɓəy se n-ra ban ə n-oo lo wa? Ə əl-de ə nə: «Jəju ɔr nangɨ kɨ lɔy kəmm tɨ, ə m-aw m-togɨ kəmm, ə ngɔsɨne kəmm oo lo.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lo kɨn tɨ, Parɨsɨ je kɨ madɨ əli əi nə: «Dəw kɨ ra nḛ kɨn e dəw kɨ ḭ rɔ Luwə tɨ al, tadɔ ɨndə kəmne go ndɔ taa kə̰ə̰ tɨ al.» Nə njé kɨ nungɨ əli əi nə: «Ra ban be ə, dəw kɨ nje ra majal par a aw kɨ tɔgɨ kadɨ ra-n nḛ kɔjɨ je kɨ ətɨ ɓəl be kɨn ə?» Be ə, ta kɨn re kɨ gangɨ-naa dande tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nɨngə təli dəji nje kəm tɔ ka kɨn ɓəy əi nə: «NGa ḭ wa kɨ dɔi, ta ri ə əl dɔ dəw tɨ kɨ tḛḛ kəmi adɨ kəmi oo lo kɨn ə?» Ə nje kəm tɔ əl ə nə: «E nje kəl ta kɨ ta Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","*Jɨpɨ je mbati kadɨ mede təkɨ e dəw kɨ kəte kəme tɔ, ə ngɔsɨne dəw tḛḛ kəme adɨ kəme oo lo. Rai bɨtɨ adi njé koje je rəi. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ə dəji-de ta əi nə: «Dəw kam e ngonsi wa təkɨ rɔjetɨ a? A re e ngonsi wa ə, kəme tɔ lo koje tɨ wa a? A re kəme tɔ lo koje tɨ ə, ra ban be ə ngɔsɨne kəme oo lo ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ə njé koje je əli əi nə: «Jɨ gər majɨ kadɨ e ngonje wa, taa kəme tɔ lo koje tɨ nu tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nə kɨ ɔjɨ dɔ kəme kɨ ngɔsɨne oo lo, ə se na̰ ə tḛḛ kəme adɨ kəme oo lo wa kɨn ə, jɨ gər nḛ kare me tɨ al. Nɨngə e wa tɔgɨ gangɨ ə nə ɨdəji-e, ə a əl ta kɨ dɔ rɔne tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","NJé koje je əli ta kɨn be mbata ɓəl kɨ ɓəli Jɨpɨ je. Tadɔ Jɨpɨ je dɔɔi ta naa tɨ kadɨ tə dəw kɨ re əl ə nə Jəju e Kɨrɨsɨ kɨ Luwə mbəte ɓa, sɔbɨ tuwe gɨn kəy kaw-naa tɨ ləde kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","E mbata kɨn ə, njé koje je əli əi nə: «E wa tɔgɨ gangɨ ə nə, ɨdəji-e.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ə Parɨsɨ je ɓari dəw kɨ kəte kəme tɔ ka kɨn adi-e re kɨ ko̰ joo, nɨngə əli-e əi nə: «Əl ta kɨ rɔjetɨ, ɔsɨ-n gon Luwə. Jɨ gər kadɨ dɨngəm kɨn e nje ra majal.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lo kɨn tɨ, dɨngəm kɨ kəte kəme tɔ ka kɨn əl-de ə nə: «E nje ra majɨ, ə se e nje ra majal wa ka m-gər nḛ kare me tɨ al, nḛ kare kɨ m-gər majɨ ən: kəte kəm tɔ, nɨngə ngɔsɨne kəmm oo lo.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nɨngə təli əli-e əi nə: «E ri ə ra səi ə? Ə ra ban tɔ ə adɨ kəmi oo lo ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lo kɨn tɨ əl-de ə nə: «Ta kɨn m-əl səsi kəte ngata, ə ɨmbati koo ta ləm, ə ra ban ə ɨgei kadɨ m-təl m-əl səsi ɓəy ə? Ɨndɨgi kadɨ ɨtəli njé ndo je lie tɔ a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lokɨ əl Parɨsɨ je ta be ɓa, əi je taji-e ə əli-e əi nə: «Ḭ ə ḭ nje ndo lie, nə je, je njé ndo je lə *Mojɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jɨ gər kadɨ Luwə əl ta kɨ Mojɨ, nə dəw ləi kɨn, jɨ gər lo kɨ tḛḛ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ə dɨngəm ka kɨn əl Parɨsɨ je ə nə: «E nḛ kɨ ətɨ ɓəl ngay kadɨ dəw kɨ səi, ɨgəri lokɨ tḛḛ tɨ al tɔ, ə dəwe ka kɨn taa adɨ kəmm oo lo. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jɨ gəri majɨ kadɨ dɨje kɨ njé ra majal, re əli ta kɨ Luwə ə, Luwə oo dɔ ta ləde al, nə dəw kɨ nje ɓəl Luwə, kɨ nje təl rɔne go ndue tɨ, Luwə oo dɔ ta lie. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kɨ mari nu wa kɨn, ndɔ kare kadɨ j-o nə dəw madɨ ə adɨ kəm dəw kɨ tɔ lo koje tɨ nu oo lo be kɨn, m-o al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kɨn ə re dɨngəm kɨn ḭ rɔ Luwə tɨ al ə, nḛ madɨ kare kɨ asɨ kadɨ ra goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lo kɨn tɨ, əli-e əi nə: «Ḭ dəw kɨ a me majal tɨ lo koji tɨ nu kam ə, ɨge kadɨ ḭ ə ɨndo-je nḛ!» Ɓa tuwəi-e adɨ tḛḛ taga. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jəju oo kadɨ tuwəi-e, ə lokɨ ɨnge, dəje ə nə: «Ḭ adɨ mei *NGon dəw a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ə əl Jəju ə nə: «Ɓaɓe, NGon dəw ə e na wa əl-m adɨ tə m-ade mem.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɨngə Jəju əl-e ə nə: «Ḭ o-e kɨ kəmi, e darɔe e wa ə ɨsɨ əli ta kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Be ə, dɨngəm ka kɨn əl Jəju ə nə: «Ɓaɓe, m-adi mem.» Ɓa ɔsɨ məkəsɨne nangɨ no̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jəju əl-e ə nə: «M-re dɔnangɨ tɨ ne mba gangɨ ta, m-re mba kadɨ dɨje kɨ kəmde tɔ, ooi lo, ə kadɨ njé kɨ kəmde oo lo, təli njé kəm tɔ je tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lokɨ Parɨsɨ je madɨ kɨ ai kɨ Jəju no̰o̰, ooi dɔ ta kɨ Jəju əl kɨn nɨngə, dəji-e əi nə: «Je ka je njé kəm tɔ je tɔ a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ə Jəju ɨlə-de tɨ ə nə: «Kɨn ə re səi njé kəm tɔ je təkɨ rɔjetɨ ə, re majal ləsi a goto, nə təkɨ j-ɨsɨ-n, ə oi rɔsi kadɨ kəmsi oo lo kɨn ɓa, majal ləsi to lo tone tɨ ba.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jəju əl ə nə: «Təkɨ rɔjetɨ adɨ m-əl səsi. Kɨn ə re dəw madɨ ur go batɨ je tɨ kɨ ta kəy al, nə ḭ bal kɨ dɔ bɔr kɨ rəbɨ kɨ rangɨ ɓa, dəwe kɨn e nje ɓogɨ, e baw kaya. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nə dəw kɨ ur kəy go batɨ je tɨ kɨ ta kəy, e ə e ɓa batɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","NJe ngəm ta kəy batɨ je tḛḛ ta kəy ade, ɓa batɨ je ooi dɔ ndue. Nɨngə ɓar batɨ je ləne kare kare kɨ tɔde, tḛḛ səde taga. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lokɨ tḛḛ kɨ batɨ je ləne pətɨ taga nɨngə, ɔtɨ njɨyə no̰de tɨ, ɓa batɨ je uni goe, tadɔ gəri ndue. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Batɨ je a uni go dəw kɨ rangɨ al. Re ooi dəw kɨ rangɨ ɓa, a a̰yḭ-naa sa̰y kɔ kade tɨ, tadɔ gəri ndu dɨje kɨ rangɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jəju əl-de kujɨ ta kɨn, nə gəri nḛ kɨ əl-de ta dɔ tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ə təl əl-de ɓəy ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, mi ta kəy batɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dɨje pətɨ kɨ rəi no̰m tɨ, əi njé ɓogɨ je, kɨ baw kaya je, adɨ batɨ je ooi ta ləde al. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mi ta kəy, re dəw ur kəy kɨ rəbɨ kɨ rɔm tɨ ɓa, dəwe a ɨngə kajɨ. A ur kəy nɨm, a tḛḛ nɨm, taa a ɨngə nḛ kusone nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","NJe ɓogɨ re ɓa, re mba ɓogɨ, re mba tɔl nḛ, ə re mba tujɨ nḛ tɔ par. Nə mi, m-re mba kadɨ dɨje ɨngəi kajɨ. Nɨngə kadɨ e kajɨ kɨ to mbar mbar. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Mi ɓa batɨ je kɨ m-ul batɨ je majɨ. Dəw kɨ ul batɨ je majɨ, adɨ rɔne mbata batɨ je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nə dəw kɨ e nje ngəm batɨ je mba kɨngə la par ɓɨ e ɓade al, lokɨ oo jagɨm ɨsɨ re kɨ dɔ batɨ je ɓa, ɨyə̰ batɨ je ə a̰y, adɨ jagɨm re uwə-de je, sane-de je. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","NJe ngəm batɨ je mbata kɨngə-n la kɨn a̰y, tadɔ nḛ lie e la par ə ɨsɨ sangɨ, adɨ oo lo kadɨ ɨndə rɔne ko̰ tɨ mbata lə batɨ je al. Mi, mi ɓa batɨ je kɨ m-ɨndə kəmm go batɨ je tɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","M-gər batɨ je ləm, ə batɨ je ləm gəri-mi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Gəri-mi təkɨ Bai gər-m ə mi m-gər-n Bai kɨn be tɔ. Be ə, m-adɨ rɔm mbata batɨ je ləm. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M-aw kɨ batɨ je kɨ rangɨ no̰o̰ ɓəy kɨ əi me kəy tɨ ne al. Əi je ka, sɔbɨ kadɨ m-re səde me kəy tɨ tɔ. A ooi ndum ɓa, a təli nḛ kul je kɨ kare ba gɨn ɓade tɨ kɨ kare ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bai ndɨgɨ-m, mbata m-ɨlə rɔm kɔ kadɨ tə m-təl m-ɨngə kɨngə kɨ rangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Dəw kɨ a ɨndə tɔgɨ dɔm tɨ kadɨ m-ɨlə rɔm kɔ goto. E mi wa ə m-adɨ kɨ me ndɨgɨ ləm. M-aw kɨ tɔgɨ kadɨ m-adɨ-n nɨm, kadɨ m-taa-n nɨm. E kɨn ə e ndu kɨ m-gər kɨ rɔ Bai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta lə Jəju kɨn təl re kɨ gangɨ-naa kɨ rangɨ dan *Jɨpɨ je tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","NGay je dande tɨ əli əi nə: «NDɨl kɨ majal ɨsɨ mee tɨ, dɔe a dana al, ə ra ban ə ɨsɨ oi ta lie ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ə njé kɨ nungɨ əli əi nə: «Dəw kɨ ndɨl kɨ majal ɨsɨ mee tɨ əl ta be al. Dəw kɨ ndɨl kɨ majal ɨsɨ mee tɨ asɨ kadɨ a tḛḛ kəm njé kəm tɔ je al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dɔkagɨloe tɨ kɨn, *Jɨpɨ je ɨsɨ rai nay tɔr ndu dɔ kəy tɨ lə Luwə Jorijaləm tɨ. E dɔkagɨlo kul tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jəju ɨlə lo aw je təl je gɨn pal tɨ lə *Salomo̰, natɨ kəy tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jɨpɨ je ɨləi-naa gəi gɨde, nɨngə əli-e əi nə: «Kadɨ ban tɨ ə a əl-je ta kɨ kadɨ meje osɨ nangɨ ə? Kɨn ə re ḭ Kɨrɨsɨ kɨ Luwə mbəte ə, əl-je wangɨ adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ə Jəju əl-de ə nə: «Ta kɨn m-əl səsi kəte ngata, nə ɨmbati kadɨ ɨtaai ta ləm. Nḛ je kɨ m-ɨsɨ m-ra-de me tɔ Bai tɨ kɨn mai najɨ dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nə səi, ɨmbati kadi-mi mesi. Ɨmbati tadɔ səi dan batɨ je tɨ ləm al. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Batɨ je ləm ooi ndum, m-gər-de, nɨngə əi je uni gom tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","M-adɨ-de kajɨ kɨ to bɨtɨ kɨ no̰ tɨ, ɓɨ tade a tḭ al. Taa dəw kɨ kadɨ ɨndə tɔgɨne taa-n-de jim tɨ ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bai kɨ nje kadɨ-m-de aw kɨ tɔgɨ dɔ dɨje tɨ pətɨ, adɨ dəw madɨ kɨ asɨ kadɨ ɨndə tɔgɨ taa-n-de ji Bai tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Je kɨ Bai je dɨje kɨ kare ba.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lo kɨn tɨ, Jɨpɨ je təli kəi mbal ɓəy kadɨ n-tɨləi Jəju n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ə Jəju əl-de ə nə: «M-ra nḛ je kɨ majɨ majɨ ngay ta kəmsi tɨ kɨ tɔgɨ kɨ ḭ rɔ Bai tɨ, nga e kɨ ra ə ɨgei kadɨ ɨtɨləəi-mi kɨ mbal ɨtɔli-mi kɨ mbae ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ə Jɨpɨ je əli-e əi nə: «E mbata nḛ majɨ kɨ ɨra ə jɨ ge kadɨ jɨ tɨləi kɨ mbal jɨ tɔli al, nə e kɨ mbata ta kɨ mal. Tadɔ ḭ kɨ ḭ dəw kare par əl ə nə ḭ Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jəju əl-de ə nə: «Luwə əl me ndu-kun tɨ ləsi ə nə: “Mi m-əl səsi, səi luwə je”. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dɨje kɨ Luwə əl-de ta ləne ə Luwə ɓar-de luwə je kɨn. Nɨngə ɨgəri majɨ kadɨ dəw asɨ tɔgɨ bujɨ ta lə Luwə al. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mi, e Luwə ə mbətɨ-m, ɨlə-m dɔnangɨ tɨ, ə m-əl-n m-ə nə mi NGon Luwə, nɨngə səi əli əi nə se mi na̰ ə m-əl m-ə nə mi NGon Luwə wa ɓa, mi nje kəl ta kɨ mal dɔ tɔ Luwə tɨ, kɨn e mba ri ə? ");
INSERT INTO bjvNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kɨn ə re m-ra kɨlə lə Bai al nɨngə tə adi-mi mesi al! ");
INSERT INTO bjvNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A kɨn ə re m-ɨsɨ m-ra kɨlə lə Bai nɨngə, re adi-mi mesi al ka, adi mesi kɨlə je kɨ m-ra-de ka kɨn ndə̰y taa. Adi mesi kadɨ ɨgəri təkɨ Bai ɨsɨ mem tɨ, ə mi m-ɨsɨ me Bai tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Lo kɨn tɨ, sangi rəbɨ nja kare ɓəy kadɨ n-uwəi Jəju, nə tḛḛ mbo̰de tɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jəju təl aw gɨdɨ ba Jurdḛ tɨ, lo tɨ kɨ kəte Ja̰ ra dɨje batəm tɨ. Jəju aw ɨsɨ loe tɨ kɨn no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dɨje ngay awi rɔe tɨ, nɨngə əli-naa əi nə: «Ja̰ ra nḛ madɨ kare kɨ ətɨ ɓəl al, nə nḛ je pətɨ kɨ əl ɔjɨ-n dɔ dɨngəm kɨn e nḛ je kɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lo kɨn tɨ no̰o̰ be dɨje ngay adi mede Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dɨngəm kare kɨ nje mo̰y e no̰o̰, tɔe nə Lajar. Ɨsɨ me ɓe tɨ kɨ Bətani kɨ e ngon ɓe lə Mari əi kɨ ngokone Martɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E darɔ Mari wa kɨn ə a ɔy yɨbɨ kɨ ətɨ majɨ nja Ɓaɓe tɨ nɨm, bɔr njae kɨ bɨsɨ dɔne nɨm. NGa nɨngə e ngoko̰e Lajar ə rɔe to-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","NGakonaa je kɨ dəne kɨ joo kɨn ɨləi dəw madɨ ade aw əl Jəju ə nə: «Ɓaɓe, basa madi e mo̰y.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lokɨ Jəju oo ta kɨn nɨngə əl ə nə: «Mo̰y lə Lajar kɨn a tɔl-e al, nə e mo̰y kɨ re kadɨ tɔjɨ tɔgɨ Luwə, taa kadɨ dɨje ɨləi tɔjɨ dɔm tɨ mi NGon Luwə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jəju ndɨgɨ Martɨ əi kɨ ngoko̰e Mari, taa ndɨgɨ Lajar tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jəju oo majɨ kadɨ Lajar e mo̰y, nə ɨsɨ lo tɨ kɨ ɨsɨ tɨ kɨn ba ndɔ joo ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Go tɨ, əl njé ndo je ləne ə nə: «Adɨ jɨ təli j-awi Jude tɨ gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ə *NJé ndo je lie əli-e əi nə: «NJe ndo dɨje, ndɔ ngay al ne ɓəy ə *Jɨpɨ je sangi kadɨ n-tɨləi-ni kɨ mbal n-tɔli-ni ka kɨn ə, ɨge kadɨ ɨtəl aw Jude tɨ ɓəy a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jəju ɨlə-de tɨ ə nə: «NGan kadɨ e dɔgɨ gɨde joo me kadɨ tɨ kɨ kare. Nɨngə kɨn ə re dəw njɨyə kada ə a osɨ al, tadɔ oo lo majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","A re njɨyə kondɔ ə a osɨ, tadɔ oo lo majɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Go ta tɨ kɨn, Jəju ɨlə ta kɨ rangɨ dɔ tɨ ə nə: «Madɨje Lajar to ɓi, nɨngə m-a m-aw kadɨ m-ndəl-e.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ə njé ndo je əli-e əi nə: «Ɓaɓe, re e ɓi ə to ə a ndəl ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jəju əl ta lə koy Lajar, nə njé ndo je ooi təkɨ e ta lə ɓi kɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ə Jəju əl-de ay njay ə nə: «Lajar oy. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","NGa nɨngə kɨ ɔjɨ dɔsi, rɔm nəl-m ngay kadɨ m-goto loe tɨ, kadɨ tə səi je adii-mi mesi. Ɓa kɨ ne kɨn, adɨ j-awi dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ə Tomasɨ kɨ ɨsɨ ɓari-e «NDɨngə» əl ndəgɨ njé ndo je ə nə: «J-əi ka adɨ j-awi sie tə j-oyi sie.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lokɨ Jəju re tḛḛ Bətani tɨ, oo kadɨ dɨbi Lajar ra ndɔ sɔ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bətani e ɓasi kɨ Jorijaləm, asɨ kulə mətər mɨtə be par, ");
INSERT INTO bjvNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","adɨ *Jɨpɨ je ngay rəi rɔ Martɨ tɨ əi kɨ Mari kadɨ sɔli mede ɔjɨ-n dɔ koy lə ngoko̰de. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lokɨ Martɨ oo kadɨ Jəju a re no̰o̰, ḭ aw tɨlə kəme, nɨngə Mari taa ɨsɨ ya̰ne nangɨ me kəy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martɨ kɨ aw tɨlə kəm Jəju, əl Jəju ə nə: «Ɓaɓe, kɨn ə re ḭ səje ne ə re ngokom a oy al. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nə kɨ ne wa kɨn ka m-gər kadɨ nḛ je pətɨ kɨ ɨdəjɨ Luwə ə a adi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ə Jəju əl-e ə nə: «NGoko̰i a ḭ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nɨngə Martɨ ɨle tɨ ə nə: «E kɨ rɔjetɨ, m-gər kadɨ ndɔ kɨ njé koy je a ḭḭ taa lo koy tɨ dɔbəy ndɔ tɨ ə, Lajar a ḭ taa lo koy tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lo kɨn tɨ, Jəju əl-e ə nə: «Mi nje kadɨ dɨje ḭḭ taa lo koy tɨ, kɨ nje kadɨ dɨje ɨsi kɨ dɔde taa. Dəw kɨ adɨ-m mene, re oy mɨndɨ ka, a təl ɨsɨ kɨ dɔne taa. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","NGa nɨngə, dəw kɨ ɨsɨ kɨ dɔne taa, ə adɨ-m mene ɓa, dəwe kɨn a oy al ratata. M-dəji se oo be wa?» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ɓa Martɨ ɨle tɨ ə nə: «Oyo, Ɓaɓe, m-adi mem təkɨ ḭ ə ḭ Kɨrɨsɨ kɨ Luwə mbəte, ḭ ə ḭ NGon lə Luwə, ḭ ə ḭ dəw kɨ sɔbɨ kadɨ a re dɔnangɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Go ta tɨ kɨ Martɨ əl kɨn ɓa, ɔtɨ aw ɓar ngokone Mari, əl-e ta nangɨ yɔgɨrɔ be ə nə: «NJe ndo dɨje a no̰o̰, ə ɨsɨ dəji kadɨ aw.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lokɨ Mari oo ta kɨn taa par ə ḭ taa kalangɨ aw kɨ rɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jəju ur me ɓe tɨ al ɓəy, e lo tɨ wa kɨ Martɨ aw ɨnge tɨ kəte ka kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","*Jɨpɨ je kɨ ɨsi me kəy tɨ kɨ Mari, ɨsɨ sɔli mee, lokɨ ooi-e ḭ taa kalangɨ, tḛḛ taga, ooi ə nə ɨsɨ aw kɨ dɔ ɓadɨ tɨ kadɨ no̰ wa, adɨ ḭḭ taai goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lokɨ Mari aw tḛḛ lo tɨ kɨ Jəju a tɨ, ə oo Jəju ɓa, osɨ nangɨ njae tɨ, nɨngə əl-e ə nə: «Ɓaɓe, kɨn ə re ḭ səje ne ə re ngokom a oy al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Lokɨ Jəju oo kadɨ Mari ɨsɨ no̰, taa Jɨpɨ je kɨ ḭḭ goe tɨ ka ɨsɨ no̰i tɔ ɓa, mee ur made, taa ndɨle ɨsɨ nangɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ə dəjɨ-de ə nə: «Ɨləi-e ra be ə?» Ɓa əli-e əi nə: «Ɓaɓe, ɨre ə a o.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lo kɨn tɨ, Jəju no̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ə Jɨpɨ je əli əi nə: «Oi tɔjɨ kɨ tɔjɨ ndɨgɨ kɨ ndɨge kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nə njé kɨ nungɨ əli əi nə: «Tḛḛ kəm nje kəm tɔ, nga ra ban ə asɨ kadɨ ɔgɨ Lajar koy al tɔy?» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lo kɨn tɨ, me Jəju təl ur made kur kɨ rangɨ ɓəy, adɨ ɔtɨ aw kɨ dɔ ɓadɨ tɨ. Nɨngə e bole mbal ə ɨndəi mbal made utii tae. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jəju əl-de ə nə: «Ɔri mbal kɨn kɔ», nə Martɨ kɨ konan nje goto əl Jəju ə nə: «Ɓaɓe, ra ndɔ sɔ ngata, adɨ a ətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ə Jəju əl-e ə nə: «M-əli m-ə nə ri ə? M-əli m-ə nə re adɨ mei ə a o tɔgɨ Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lo kɨn tɨ, ɔri mbal kɔ, ə Jəju un kəmne kɨ taa nɨngə əl ə nə: «Bai, m-ra-i oyo təkɨ o dɔ ndum. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","M-gər kadɨ ta je kɨ m-ɨsɨ m-əl səi kɨn o dɔ ndum dɔrɔ, nə m-əl ta kɨn be mbata kosɨ dɨje kɨ gəi gɨdɨm kɨn, kadɨ adi-mi mede təkɨ e ḭ ə ɨlə-m.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Go ta tɨ kɨn ɓa, Jəju un ndune kɨ taa əl ta kɨ tɔgɨne ə nə: «Lajar, ɨtḛḛ taga!» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nɨngə nje goto Lajar ɨndə lo tḛḛ taga. Jie je kɨ njae je e kɨ ragɨ kɨ ta kɨbɨ, taa ta kəme e kɨ dole kɨ kɨbɨ tɔ. Ə Jəju əl-de ə nə: «Ɨtuti-e, ə ɨyə̰i-e adɨ aw.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","*Jɨpɨ je ngay kɨ awi rɔ Mari tɨ, ə ooi nḛ kɨ Jəju ra, adi mede Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nə njé kɨ na̰ je awi ɨngəi *Parɨsɨ je, əli-de nḛ kɨ Jəju ra. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lo kɨn tɨ, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ Parɨsɨ je, ɔsi dɔ njé gangɨ ta je lə Jɨpɨ je naa tɨ, nɨngə dəji-naa əi nə: «E ri dana ə kadɨ jɨ rai ə? Dɨngəm kɨn ra nḛ je kɨ ətɨ ɓəl ɓəl ngay! ");
INSERT INTO bjvNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kɨn ə re j-ɨyə̰i-e j-adɨ ra nḛ je ləne kɨn kɨ no̰ne tɨ ə, dɨje pətɨ a adi-e mede, nɨngə dɨje kɨ Rom tɨ a rəi kadɨ tuji kəy lə Luwə, taa a tuji gɨn ɓe ləje tɔ!» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ə Kayɨpɨ kɨ e kɨ kare dan njé kun dɔ Jɨpɨ je tɨ, kɨ ɓale tɨ no̰o̰ e kɨ bo dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ, un ta əl-de ə nə: «Ɨgəri nḛ kare me nḛ tɨ kɨ ɨsɨ ra nḛ kɨn al! ");
INSERT INTO bjvNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ɨməri ta majɨ oi! E sotɨ ngay mbata tɨ ləsi kadɨ ba kal dəw kare oy mbata lə gɨn dɨje kosɨ, ə gɨn ɓe kɨ tae ba ɨngə tujɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","NGa nɨngə e ta kɨ Kayɨpɨ wa ɓa əl kɨ dɔne al, nə təkɨ ɓale tɨ no̰o̰ e kɨ bo dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ, Luwə ɨndə ta tae tɨ adɨ ɨlə mbḛe kəte təkɨ sɔbɨ kadɨ Jəju a oy mbata lə gɨn ɓe lə Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nɨngə a oy mbata lə gɨn ɓe lə Jɨpɨ je par al, nə a oy mba kadɨ kaw-n ngan lə Luwə kɨ sanəi-naa kɨ lo je dangɨ dangɨ kɨn kadɨ təli gɨn dɨje kɨ kare ba. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ḭ dɔ ndɔe tɨ no̰o̰ kɨn, njé kun dɔ Jɨpɨ je uni ndude kadɨ n-tɔli Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","E be ə, Jəju ɨndə ngangɨ njɨyə taga ta kəm Jɨpɨ je tɨ. Ɔr rɔne aw ɓasi kadɨ dɨlə lo tɨ, me ngon ɓe tɨ kɨ ɓari-e Epɨrayɨm. Aw ɨsɨ tɨ no̰o̰ kɨ njé ndo je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dɔkagɨlo ra nay lə Jɨpɨ je kɨ ɓari-e Pakɨ e ɓasi, adɨ dɨje ngay awi Jorijaləm tɨ kəte no̰ tɨ kadɨ tə rai nḛ je kɨ go kuje tɨ ləde əi Jɨpɨ je kadɨ Luwə oo-n-de tə dɨje kɨ kanjɨ majal. ");
INSERT INTO bjvNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Dɨje ka kɨn əi gɨn kəy tɨ lə Luwə, nɨngə ɨsɨ sangi Jəju, ə dəji-naa ta dande tɨ əi nə: «Mər ta ləsi e ri ə? Kadɨ a re lo ra nay tɨ al a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nḛ kare ɓa, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ Parɨsɨ je adi ndu kadɨ re dəw madɨ oo lo kɨ Jəju e tɨ ɓa, kadɨ əl-de adɨ n-awi n-uwəi-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","NDɔ mehḛ kəte no̰ ra nay Pakɨ tɨ, Jəju aw Bətani tɨ kɨ Lajar ɨsɨ tɨ. Lajar kɨ ndɔ kɨ ade ḭ taa lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lo kɨn tɨ no̰o̰, rai nḛ kuso kɨ tɔ Jəju. Martɨ ə e nje kadɨ-de nḛ kuso, nɨngə Lajar e kɨ kare dan njé kɨsɨ ta nḛ kuso tɨ kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari un yɨbɨ kɨ rai kɨ man kagɨ kɨ ɓari-e nar, a rosɨ ngon ku be, ɓukɨ nja Jəju tɨ, nɨngə go tɨ, bɔr njae kɨ bɨsɨ dɔne. E yɨbɨ nar dɔrɔe kɨ gate e ngay. Ba̰yḛ taa me kəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Lo kɨn tɨ, Judasɨ Isɨkarɨyotɨ kɨ e kɨ kare dan njé ndo je tɨ lə Jəju, e kɨ a un dɔ Jəju, əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«MBa ri ə e kɨ gatɨ kɨ yɨbɨ kɨn, taa-n la kɨ lo kɨlə tɨ kɨ ndɔ ɓu mɨtə be ka e kɨ ra-n kɨ njé ndoo je al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasɨ əl ta kɨn be mba to ɓa ta lə njé ndoo je to rɔe al, nə mbata e nje ɓogɨ. E ə ɓɔl la e jie tɨ, adɨ ɨsɨ ɓogɨ la kɨ ɨsɨ ɓuki me tɨ ndə̰y ndə̰y. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nə Jəju əl ə nə: «Ɨyə̰i Mari jəke! Ra nḛ kɨn be ngɨnə-n ndɔ kɨ kadɨ darɔm a aw-n ɓada. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","NJé ndoo je kam, ɨsi səsi ne kɨ ndɔ je pətɨ, nə mi m-a m-ɨsɨ səsi kɨ no̰ tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kosɨ *Jɨpɨ je ngay ooi kadɨ Jəju e Bətani tɨ, adɨ rəi. Nɨngə rəi mbata lə Jəju par al, nə rəi mba koo Lajar kɨ Jəju ade ḭ taa lo koy tɨ ka kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","E be ə, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je uni ndude kadɨ n-tɔli Lajar kɔ, ");
INSERT INTO bjvNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mbata e ta lie ə ra adɨ Jɨpɨ je ngay ɨyə̰i-de ə adi mede Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lo ti go tɨ, kosɨ dɨje kɨ ngay kɨ rəi Jorijaləm, ooi kadɨ Jəju ɨsɨ re Jorijaləm, ");
INSERT INTO bjvNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ə ɔyi baji tan je, ə tḛḛi taga gɨdɨ ɓe tɨ, awi tɨlə kəme. Nɨngə lo kɨn tɨ, uni ndude kɨ taa əli əi nə: «Tɔjɨ e kɨ dɔ Luwə tɨ! Nɨngə kadɨ Luwə ɨndə jine dɔ dəw tɨ kɨ re kɨ tɔ Ɓaɓe, kadɨ Luwə ɨndə jine dɔ ngar tɨ lə *Isɨrayəl je!» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jəju ɨngə ngon koro, nɨngə al ɨsɨ dɔe tɨ təkɨ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Ɨɓəl al, ɓe bo *Sɨyo̰! Ɨgo̰ lo o, ngar ləi ɨsɨ re, Ɨsɨ dɔ ngon koro tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dɔsa̰y ba, njé ndo je lie gəri me nḛ je kɨ ɨsɨ rai kɨn al, nə lokɨ dɨje ɨsɨ ɨləi tɔjɨ dɔ Jəju tɨ ngata ɓa kadɨ mede ole dɔ tɨ təkɨ makɨtɨbɨ lə Luwə əl ta lie kadɨ nḛ kɨn a ra nḛ dɔe tɨ be. Nɨngə e nḛe ka ə ɨsɨ ra nḛ dɔe tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dɨje ngay kɨ ndɔ kɨ əi sie naa tɨ lokɨ ndəl Lajar ade tḛḛ ɓada, dan njé koy je tɨ, mai najɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɨngə e najɨ kɨ ma ləde kɨn ə ra adɨ kosɨ dɨje awi tɨləi kəme, tadɔ ooi kadɨ ra nḛ kɔjɨ kɨ ətɨ ɓəl ngay kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lo kɨn tɨ, *Parɨsɨ je əli-naa dande tɨ əi nə: «Oi to kɨ taga ta kəmsi tɨ ne kadɨ asi ra nḛ madɨ al; dɨje pətɨ ɓuki-naa kɨ goe tɨ!» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gɨrəkɨ je madɨ əi dan dɨje tɨ kɨ rəi Jorijaləm lo ra nay tɨ kadɨ ɔsi məkəsɨde nangɨ no̰ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gɨrəkɨ je ka kɨn rəi ɓasi rɔ Pɨlɨpɨ tɨ kɨ e dəw kɨ ngon ɓe tɨ kɨ Bətɨsayda kɨ Galile tɨ, dəji-e əi nə: «Jɨ ndɨgɨ kadɨ j-o Jəju.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ə Pɨlɨpɨ aw əl Andɨre, nga ə ɨndəi rɔde naa tɨ joo pu awi əli Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jəju ɨlə-de tɨ ə nə: «Kɨ ne kɨn ɓa, ndɔ asɨ kadɨ Luwə tɔjɨ tɔgɨm mi *NGon dəw kɨ taga ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨngə kɨ rɔjetɨ, adɨ m-əl səsi, ka̰ ko kɨ kare kɨ osɨ nangɨ kɨn re oy al ə, a to kɨ karne ba par, a re oy tɔ ɓa, a tḛḛ kɨ ka̰ ko je kɨ rangɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Dəw kɨ ndɨgɨ koo majɨ rɔne, a tḭ tae, nə dəw kɨ ɨyə̰ ta koo majɨ rɔne dɔnangɨ tɨ ne, a ngəm rɔne kadɨ kajɨ kɨ bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kɨn ə re dəw madɨ ge ra kɨlə ɓəə ləm ɓa, sɔbɨ kadɨ un gom, nga nɨngə nje kɨlə ɓəə ləm kɨn a e səm lo tɨ kɨ m-a m-ḭ tɨ. Dəw kɨ nje ra kɨlə ɓəə ləm, Bai Luwə a ɔsɨ gone.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jəju əl ə nə: «Kɨ ne kɨn, ndɨlm ɨsɨ nangɨ al, ə se ta ri ə kadɨ m-əl wa? Kadɨ m-əl m-ə nə: “Bai, ajɨ-m ta dɔ kadɨ tɨ kɨ nga̰ kɨ a re dɔm tɨ kɨn a?” NGa e mbata dɔ kadɨ wa kɨn ə m-re bɨtɨ m-tḛḛ-n ne kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bai, ɨtɔjɨ adɨ dɨje gəri tɔɓa ləi.» Nɨngə ndu dəw ɓa ḭ kɨ dɔra̰ tɨ ə nə: «M-adɨ dɨje gəri tɔ ɓa ləm ngata, nə m-a m-adɨ-de gəri ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kosɨ dɨje kɨ ai loe tɨ no̰o̰ ə ooi ndu ta kɨn kɨ mbide əli əi nə: «E ndi ə ndangɨ nḛ.» Nɨngə njé kɨ nungɨ əli əi nə: «Malayka kare ə əl-e ta.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ə Jəju əl-de ə nə: «NDu ta kɨ ɓa ə oi kɨn tḛḛ mbata ləm mi al, nə tḛḛ kɨ mbata ləsi səi je. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kɨ ne kɨn, e dɔkagɨlo kɨ kadɨ Luwə a gangɨ-n ta dɔ dɨje tɨ kɨ dɔnangɨ tɨ ne ngata, e dɔkagɨlo kɨ kadɨ Luwə a uwə-n nje majal kɨ ɨsɨ ɨndə tɔgɨne dɔ dɨje tɨ kɨ dɔnangɨ tɨ ne, ɨle gɨdɨ lo tɨ kɔ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","NGa nɨngə mi, ndɔ kɨ dɨje a ɓəi-mi taa dɔ kagɨ-dəsɨ tɨ kɨn ɓa, m-a m-ndɔr dɨje pətɨ kɨ rɔm tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Me ta tɨ kɨn, Jəju tɔjɨ kadɨ gəri se go rəbɨ kɨ ban ə a oy-n wa?. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ə kosɨ je əli-e əi nə: «J-ɨngə me makɨtɨbɨ ndu-kun je tɨ ləje təkɨ Kɨrɨsɨ kɨ e dəw kɨ Luwə mbəte, a ɨsɨ bɨtɨ kɨ no̰ne tɨ ɓɨ a oy al, nga ra ban be ə ḭ əl ə nə: “Sɔbɨ kadɨ a ɓəi NGon dəw taa dɔ kagɨ-dəsɨ tɨ ə?” Ə NGon dəw ə wa kɨn e na̰ dana ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ɓa Jəju əl-de ə nə: «Kunjɨ e dansi tɨ ne dɔkagɨlo ndə̰y ɓəy. Nɨngə kadɨ ɨnjɨyəi kɨ no̰si tɨ lokɨ kunjɨ ɨsɨ unjɨ dɔsi tɨ kɨn, kadɨ tə tɨl ɨngə səsi dɔ rəbɨ tɨ al. Tadɔ dəw kɨ njɨyə me tɨl tɨ, gər lo kɨ ɨsɨ aw tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dɔkagɨlo kɨ kunjɨ e səsi kɨn ɓa, adi mesi kunjɨ, kadɨ tə ɨtəli dɨje kɨ me kunjɨ tɨ.» Lokɨ Jəju əl-de ta be nɨngə, ɔtɨ aw ɓɔyɔ rɔne sa̰y ta kəmde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jəju ra nḛ kɔjɨ je kɨ ətɨ ɓəl ɓəl ta kəm *Jɨpɨ je tɨ ka, mbati kadi-e mede. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","E kɨn tɔjɨ ta kɨ nje kəl ta kɨ ta Luwə tɨ Ejay əl ə nə: «Ɓaɓe, na̰ ə taa ta kɨ tḛḛ taje tɨ osɨ mbide tɨ kɨn ə? E na̰ je ə Ɓaɓe tɔjɨ-de tɔgɨne ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nɨngə darɔ Ejay ə wa təl a no̰o̰ ɔr gɨn nḛ kɨ asii kadɨ mede al ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Luwə tɔ kəmde, Kadɨ tə ooi lo al, Adɨ mede nga̰ ngororo, Kadɨ tə gəri nḛ madɨ kare al, Kadɨ tə təli kəmde rɔ Luwə tɨ al, Nə tə Luwə ḭ ajɨ-de.» ");
INSERT INTO bjvNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ejay əl ta kɨn be mbata kunjɨ Jəju kɨ oo kəte nu ə əl-n ta dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nḛ kare ɓa, dan njé kun dɔ Jɨpɨ je tɨ wa kɨn, ngay je adi mede Jəju, nə mbati kəli kɨ taga mbata lə *Parɨsɨ je kɨ kadɨ a tuwəi-de kɔ gɨn kəy kaw-naa tɨ ləde əi Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Oi majɨ ngay kadɨ dɨje ə pɨti-de ə e sotɨ ɨtə kadɨ Luwə ə pɨtɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jəju əl ta kɨ ndune kɨ boy ə nə: «Dəw kɨ adɨ-m mene ɓa, e mi ə adɨ-m mene al, nə e nje kɨlə-m ə ade mene; ");
INSERT INTO bjvNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","nɨngə dəw kɨ oo-m ə, oo nje kɨlə-m tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi, mi kunjɨ, ə m-re dɔnangɨ tɨ ne mba kadɨ dəw kɨ adɨ-m mene ɓa, dəwe njɨyə me tɨl tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kɨn ə re ta ləm osɨ mbi dəw tɨ, ə dəwe ra-n kɨlə al ə, e mi ɓa m-gangɨ ta dɔe tɨ al, tadɔ m-re dɔnangɨ tɨ ne kadɨ m-ajɨ dɨje ɓɨ kadɨ m-gangɨ ta dɔde tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dəw kɨ mbatɨ-m nɨm, taa ta ləm al nɨm ə, aw kɨ nje gangɨ ta dɔne tɨ ngata. Tadɔ e nḛ je kɨ m-ndo dɨje wa kɨn ə, a gangɨ ta dɔe tɨ dɔbəy ndɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Təkɨ rɔjetɨ, m-əl ta kɨ dɔ rɔm al, nə e Bai kɨ nje kɨlə-m ə adɨ-m ndu je kɨ kadɨ m-əl nɨm, m-ndo nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","NGa nɨngə, m-gər kadɨ ndu kɨ Luwə adɨ kɨn ə, e nje re kɨ kajɨ kɨ bɨtɨ kɨ no̰ tɨ. Ta je kɨ m-əl, m-əl-de təkɨ Bai əl-m.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kəte no̰ ra nay Pakɨ tɨ, Jəju gər kadɨ ndɔ re nga kadɨ tə ɨyə̰ dɔnangɨ ə aw rɔ Bawne tɨ. Jəju kɨ ndɨgɨ njé kɨ ya̰ne je kɨ dɔnangɨ tɨ ne mari nu, ndɨgɨ-de bɨtɨ kadɨ tɔl tae. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jəju əi kɨ njé ndo je ləne ɨsi ta nḛ kuso tɨ lo sɔlɔ. Nɨngə dɔkagɨloe tɨ kɨn, su ɨndə ta ga kulə Jəju ji njé ba̰ je tɨ me Judasɨ tɨ kɨ ngon lə Sɨmo̰ Isɨkarɨyotɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jəju wa kɨ dɔne gər kadɨ Bawne Luwə ɨlə nḛ je pətɨ jine tɨ, nɨngə gər təkɨ n-ḭ rɔe tɨ ə n-re, adɨ n-a n-təl n-aw rɔe tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jəju ḭ taa ta nḛ kuso tɨ, ɔr kɨbɨ ləne kɨ ɨlə dɔ made tɨ, ɓa un ta kɨbɨ dɔɔ-n ɓədɨne. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Go tɨ, mbəl man me nḛ tɨ, ɓa ɨlə rɔne togɨ nja njé ndo je ləne, ə bɔr njade kɨ ta kɨbɨ kɨ kəte dɔɔ-n ɓədɨne ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lokɨ Jəju re tḛḛ dɔ Sɨmo̰ Pɨyər tɨ ɓa, Sɨmo̰ Pɨyər əl-e ə nə: «Ɓaɓe, ḭ ə kadɨ ɨtogɨ njam a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ə Jəju əl-e ə nə: «Nḛ kɨ m-ɨsɨ m-ra kɨn, ta ji naa tɨ ne ɨgər al, nə a gər mee kɨ ɓəy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be ka Pɨyər əl Jəju ə nə: «Jagɨ, ḭ a togɨ njam al.» Ə Jəju ɨle tɨ ə nə: «Kɨn ə re m-togɨ njay al ɓa, nḛ madɨ kɨ ɓəw-je naa tɨ səi goto.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nɨngə Pɨyər əl ə nə: «Ɓaɓe, re e be ɓa, ɨtogɨ njam par al, nə kadɨ ɨtogɨ jim je, kɨ dɔm je tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ə Jəju əl-e ə nə: «Dəw kɨ ndogɨ man, aw kɨ ndoo togɨ njane par, ɓɨ rɔe je pətɨ al, tadɔ ndəgɨ rɔe je ay njay. NGa nɨngə səi je, rɔsi ay njay, nə e dɨje pətɨ ɓa rɔde ay, al ɓəy tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Lo kɨn tɨ, Jəju gər dəw kɨ a ule ji njé ba̰ je tɨ, ə əl-n ə nə: «E səi pətɨ ɓa rɔsi ay, al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lokɨ Jəju togɨ njade gɨne gangɨ nɨngə, un kɨbɨ ləne ɨlə rɔne tɨ, ə təl aw ɨsɨ ta nḛ kuso tɨ gogɨ, ɓa əl-de ə nə: «Ɨgəri me nḛ kɨ m-ra səsi kɨn a? ");
INSERT INTO bjvNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ɨsɨ ɓari-mi NJe ndo dɨje je, Ɓaɓe je, nɨngə e go rəbe tɨ, tadɔ e mi ə wa. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","NGa nɨngə re mi kɨ mi NJe ndo dɨje je, mi Ɓaɓe je ə m-togɨ njasi nɨngə, səi ka sɔbɨ kadɨ ɨtogi njanaa kɨ yo je kɨ ne je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","E nḛ ə m-ɔjɨ səsi, kadɨ səi ka ɨndaji, ɨrai təkɨ m-ra səsi kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Təkɨ rɔjetɨ, adɨ m-əl səsi, ɓəə ɨtə ɓane al, taa ngon nje kaw kɨlə ɨtə nje kɨle al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Təkɨ ɨgəri ngata kɨn ə, ɨrai kɨle ə, rɔsi a nəl səsi ngay. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","E səi pətɨ ɓa m-ɨsɨ m-əl ta ləsi al; m-gər dɨje kɨ m-mbətɨ-de. NGa nɨngə, sɔbɨ kadɨ ta kɨ makɨtɨbɨ lə Luwə əl kɨn ra nḛ. Makɨtɨbɨ əl ə nə: “Dəw kɨ ɨsɨ uso səm nḛ, tu gajɨne ɔsɨ-m.” ");
INSERT INTO bjvNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","M-əl səsi ta kɨn ɓasɨne, kadɨ tə ndɔ kɨ nḛe a ra nḛ ɓa, ɨgəri təkɨ “Mi NJe kɨsɨ no̰o̰.” ");
INSERT INTO bjvNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ uwə dəw kɨ m-ɨle kɨ rɔne tɨ, uwə-m kɨ rɔne tɨ, ə dəw kɨ uwə-m kɨ rɔne tɨ, uwə nje kɨlə-m kɨ rɔne tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Go ta je tɨ kɨn, ndɨl Jəju ɨsɨ nangɨ al, adɨ ta tḛḛ tae tɨ kɨ taga ə nə: «Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kare dansi tɨ ne a ɨlə-m ji dɨje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lo kɨn tɨ, njé ndo je lie go̰i kəm-naa, nɨngə dəji-naa se na̰ dana ə ɨsɨ əl ta lie wa. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kɨ kare dan njé ndo je tɨ, kɨ e dəw kɨ Jəju ndɨge, ɨsɨ kadɨ Jəju tɨ ɓasi. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ə Sɨmo̰ Pɨyər ra nḛ yɔgɨrɔ nangɨ əl-e-n kadɨ dəjɨ Jəju se ɨsɨ əl ta lə na̰ dana wa. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","NJe ndo ka kɨn ɔy kɨ dɔ Jəju tɨ, nɨngə dəje ə nə: «Ɓaɓe, dəwe e na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ə Jəju ɨle tɨ ə nə: «E dəw kɨ m-a m-ade mapa kɨ m-gangɨ, m-ɨlə me ta̰y tɨ kɨn.» Nɨngə Jəju gangɨ mapa ɨlə me ta̰y tɨ, adɨ Judasɨ kɨ ngon lə Sɨmo̰ Isɨkarɨyotɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Lokɨ Judasɨ taa mapa ka kɨn taa par ə, *Sata̰ ur mee tɨ. Ə Jəju əl-e ə nə: «Nḛ kɨ to mei tɨ kadɨ ɨra ka kɨn, ɨra law!» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dan dɨje tɨ kɨ ɨsi sie ta nḛ kuso tɨ kɨn, dəw kɨ kadɨ gər se mba ri ə əl-e ta kɨn be wa goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tə ka kɨ Judasɨ e-n nje kotɨ ɓɔl la ka kɨn, ngay je ooi təkɨ Jəju dəje kadɨ aw ndogɨ nḛ kɨ kadɨ n-rai nay Pakɨ, ə se kadɨ aw adɨ nḛ madɨ njé ndoo je wa be. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasɨ taa mapa kɨ Jəju ade ka kɨn taa par ə tḛḛ taga. Dɔ kade tɨ kɨn, lo ndul ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lokɨ Judasɨ tḛḛ ɓa, Jəju əl ə nə: «Kɨ ɓasɨne kɨn, dɨje ɨləi tɔjɨ dɔm tɨ mi *NGon dəw, nɨngə mi NGon dəw m-ra m-adɨ dɨje ɨləi tɔjɨ dɔ Luwə tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kɨn ə re m-ra m-adɨ dɨje ɨləi tɔjɨ dɔ Luwə tɨ ɓa, Luwə wa kɨ dɔne a adɨ dɨje ɨləi tɔjɨ dɔm tɨ mi NGon dəw tɔ. NGa nɨngə e nḛ kɨ a ra nḛ ɓasɨne. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","NGanm je, mi səsi ne, naa tɨ dɔkagɨlo kɨ ndə̰y be par. A sangi-mi, nɨngə təkɨ m-əl-n *Jɨpɨ je, m-əl səsi ɓone tɔ təkɨ: “Lo kɨ m-a m-aw tɨ, a asi kadɨ awi tɨ al.” ");
INSERT INTO bjvNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","M-adɨ səsi ndu-kun kɨ sɨgɨ kɨ e ta kadɨ ɨndɨgi-naa dansi tɨ kɨ yo je kɨ ne je. Majɨ kadɨ ɨndɨgi-naa dansi tɨ kɨ yo je kɨ ne je təkɨ mi m-ndɨgɨ-n səsi kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kɨn ə re ɨndɨgi-naa dansi tɨ kɨ yo je kɨ ne je ɓa, dɨje pətɨ a gəri təkɨ səi njé ndo je ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sɨmo̰ Pɨyər dəjɨ Jəju ə nə: «Ɓaɓe, a aw ra ə?» Ə Jəju ɨle tɨ ə nə: «Lo kɨ m-a m-aw tɨ, a asɨ kadɨ un gom kɨ ɓasɨne kɨn al, nə a un gom kɨ ɓəy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ɓa Pɨyər dəjɨ Jəju ə nə: «Ɓaɓe, mba ri ə m-a m-asɨ kadɨ m-un goi kɨ ɓasɨne kɨn al ə? Mi ɓasi ngay kadɨ m-ɨlə rɔm kɔ mbata ləi!» ");
INSERT INTO bjvNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lo kɨn tɨ, Jəju ɨlə Pɨyər tɨ ə nə: «Adɨ ḭ ɓasi ngay kadɨ ɨlə rɔi kɔ mbata ləm wa ta? Təkɨ rɔjetɨ, adɨ m-əli, kunə kɨnjə no̰ al ɓəy ə, a najɨ ta nja mɨtə ə nə ɨgər-m al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jəju əl njé ndo je ləne ə nə: «Sɔbɨ kadɨ mesi ɓəl al, adi mesi Luwə, ə adi-mi mesi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Me ɓe tɨ lə Bai, kəy je e ngay no̰o̰. Kɨn ə re e nḛ kɨ rɔjetɨ al ə, re m-a m-əl səsi, tadɔ m-aw kadɨ m-ɨndə dɔ lo dana mbata tɨ ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lokɨ m-aw, ə m-ɨndə dɔ lo dana gɨne gangɨ nɨngə, m-a m-təl tə m-re kadɨ m-ɔy səsi, m-aw səsi rɔm tɨ, kadɨ tə lo kɨ mi tɨ, səi ka səi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Səi, ɨgəri rəbɨ kɨ kaw lo tɨ kɨ m-ɨsɨ m-aw tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Lo kɨn tɨ, Tomasɨ əl Jəju ə nə: «Ɓaɓe, jɨ gər lo kɨ ɨsɨ aw tɨ al tɔ, ə ra ban be ə j-a jɨ gər rəbɨ kɨ kaw tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ə Jəju əl-e ə nə: «Mi rəbɨ, mi ta kɨ rɔjetɨ, mi kɨsɨ kɨ dɔ taa. Rəbɨ kɨ rangɨ kɨ kadɨ dəw asɨ kaw-n rɔ Bai Luwə tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Re ɨgəri-mi ɓa, a ɨgəri Bai tɔ. NGa nɨngə, təkɨ j-a-n ne wa kɨn, ɨgəri-e nɨm, oi-e nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nɨngə Pɨlɨpɨ əl Jəju ə nə: «Ɓaɓe, ɨtɔjɨ-je Bawje Luwə adɨ j-o-e par ə, e wa kɨn asɨ-je nakɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ə Jəju ɨle tɨ ə nə: «Pɨlɨpɨ, e mari nu ba ə m-a səsi ne kɨn ka ɨgər-m al ɓəy a? Dəw kɨ oo-m ɓa, oo Bai Luwə tɔ. Ra ban be ə əl ə nə: “Ɨtɔjɨ-je Bawje Luwə adɨ j-o-e?” ");
INSERT INTO bjvNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","O tə ta kɨ rɔjetɨ al kadɨ mi m-ɨsɨ me Bai tɨ, ə Bai ɨsɨ mem tɨ a? Ta je kɨ m-ɨsɨ m-əl səsi kɨn, e mi wa kɨ dɔm ɓa m-ɨsɨ m-əl al; e Bai kɨ ɨsɨ mem tɨ ə ɨsɨ ra kɨlə je ləne. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Adi-mi mesi təkɨ mi m-ɨsɨ me Bai tɨ, ə Bai ɨsɨ mem tɨ tɔ kɨn. A re adi-mi mesi dɔ ta je tɨ kɨ m-ɨsɨ m-əl al ə, kɨlə ra je lə Luwə kɨ oi kɨ kəmsi kɨn yo ə, adii mesi ndə̰y. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Təkɨ rɔjetɨ, adɨ m-əl səsi, dəw kɨ adɨ-m mene ɓa, e ka a ra nḛ je kɨ m-ɨsɨ m-ra-de kɨn tɔ. A ra nḛ je kɨ ətɨ ɓəl ngay ɓəy, mbata mi m-ɨsɨ m-aw rɔ Bai tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","NGa nɨngə, nḛ je pətɨ kɨ ɨdəji me tɔm tɨ ə, m-a m-ra m-adɨ səsi, mba kadɨ mi NGon, m-ra m-adɨ dɨje ɨləi tɔjɨ dɔ Bai Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kɨn ə re ɨdəji nḛ madɨ me tɔm tɨ ə, m-a m-ra m-adɨ səsi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jəju ɨlə ta kɨ rangɨ dɔ tɨ ɓəy ə nə: «Kɨn ə re ɨndɨgi-mi ə, a təli rɔsi go ndu-kun je tɨ ləm. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nɨngə mi, m-a m-dəjɨ Bai Luwə kadɨ ɨlə kɨ NJe ra səsi kɨ rangɨ, kɨ a ɨsɨ səsi bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","E ə e NDɨl kɨ nje ra nḛ kɨ rɔjetɨ, kɨ dɨje kɨ dɔnangɨ tɨ ne asi kadɨ taai-e mede tɨ al, tadɔ ooi-e al, taa gəri-e al tɔ, nə səi je, ɨgəri-e, mbata ɨsɨ kadɨsi tɨ ne, taa a ɨsɨ mesi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","M-a m-ɨyə̰ səsi kɨ karsi tə ngan kal je be al, nə m-a m-təl kadɨ m-re rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nay ngay al kadɨ dɨje kɨ dɔnangɨ tɨ ne a ooi-mi al ratata, nə səi je, a oi-mi, tadɔ m-ɨsɨ kɨ dɔm taa, taa səi je ka a ɨsi kɨ dɔsi taa tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","NDɔe tɨ kɨn ə, a oi kadɨ mi me Bai tɨ, nɨngə səi, səi mem tɨ, ə mi, mi mesi tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dəw kɨ nje ndɨgɨ-m, e dəw kɨ ngəm go ndu-kun je ləm majɨ nɨm, təl rɔne go tɨ nɨm. Bai a ndɨgɨ dəw kɨ nje ndɨgɨ-m, nɨngə mi ka m-a m-ndɨge tɔ, taa m-a m-tɔje rɔm kɨ taga kadɨ gər-m tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judɨ (kɨ Judasɨ Isɨkarɨyotɨ al) əl Jəju ə nə: «Ɓaɓe, ra ban be ə je par ə a tɔjɨ-je rɔi kɨ taga kadɨ jɨ gər-i, ɓɨ a tɔjɨ rɔi kɨ taga kadɨ ndəgɨ dɨje kɨ dɔnangɨ tɨ ne kɨn gəri-ni al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jəju ɨle tɨ ə nə: «Dəw kɨ ndɨgɨ-m ə, a ngəm go ta je ləm. Bai a ndɨge, nɨngə je kɨ Bai Luwə joo pu j-a jɨ re rɔe tɨ, j-a j-ɨndə ɓe naa tɨ sie. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dəw kɨ ndɨgɨ-m al, təl rɔne go ta je tɨ ləm al. Ta je kɨ ɨsɨ tḛḛ tam tɨ ə ɨsɨ oi kɨn, e ta je kɨ mi wa m-əl kɨ dɔm al, nə e ta je kɨ ḭ rɔ Bai tɨ kɨ nje kɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","M-əl səsi ta je kɨn dɔkagɨlo kɨ mi səsi naa tɨ ne ɓəy kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","NJe ra səsi, NDɨl kɨ Bai a ɨlə sie adɨ səsi me tɔm tɨ kɨn, a ndo səsi nḛ je pətɨ, taa a ole mesi dɔ nḛ je tɨ pətɨ kɨ m-əl səsi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","M-ɨyə̰ lapɨya m-adɨ səsi, m-adɨ səsi lapɨya. Nɨngə mi m-adɨ səsi təkɨ dɨje kɨ dɔnangɨ tɨ ne adii səsi al. Adi mesi osɨ nangɨ, ɨɓəli al. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Oi tḛḛ tam tɨ m-əl m-ə nə: “M-a m-aw, ə m-a m-təl m-re rɔsi tɨ”. Nɨngə kɨn ə re ɨndɨgi-mi ə, a ɨrai rɔnəl dɔ kaw tɨ kɨ m-ɨsɨ m-aw rɔ Bai tɨ, tadɔ e, e kɨ bo ɨtə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","M-əl səsi ta kɨn ɓasɨne, kəte taa kadɨ nḛ je rai nḛ, kadɨ tə lokɨ a rai nḛ ɓa, adii mesi. ");
INSERT INTO bjvNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","M-a m-əl səsi ta gogɨ al ngata, tadɔ, nje majal kɨ ɨsɨ ɨndə tɔgɨne dɔ dɨje tɨ kɨ dɔnangɨ tɨ ne, re. Nɨngə e aw kɨ tɔgɨ madɨ dɔm tɨ al, ");
INSERT INTO bjvNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nə a ɨngə ta rəbɨ kadɨ ra adɨ dɨje gəri təkɨ m-ndɨgɨ Bai, ə m-ra nḛ je təkɨ Bai dəjɨ-m kadɨ m-ra. ḬḬ taa lo kɨn tɨ adɨ j-awi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jəju əl ə nə: «Mi, mi kagɨ nju kɨ rɔjetɨ, nɨngə Bai e ɓa nje ndɔr nju tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Baji nju kɨ ḭ rɔm tɨ, ə andɨ al ə, Bai a tɨge kɔ, nə e kɨ andɨ majɨ ɓa, a tɨgə ngan bajie je kɨ majal kɔ kadɨ andɨ kɨ kəte dɔ made tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nɨngə səi, nḛ ndo kɨ m-ndo səsi, ra adɨ səi dɨje kɨ ayi njay ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ə re uwəi rɔsi rɔm tɨ nga̰ ɓa, mi m-a m-uwə səsi rɔm tɨ nga̰ tɔ. NGa nɨngə, tə ka kɨ baji kagɨ a asɨ kadɨ andɨ kɨ kanjɨ kagɨ al ka kɨn ə, səi ka a asi kadɨ ɨrai nḛ madɨ kɨ kanjɨ kadɨ uwəi rɔsi rɔm tɨ, al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mi kagɨ nju, ə səi bajim je tɔ. Dəw kɨ uwə rɔne rɔm tɨ nga̰, ə mi m-uwe rɔm tɨ tɔ ɓa, a ra nḛ je kɨ majɨ majɨ ngay, tadɔ a asi kadɨ ɨrai nḛ madɨ kɨ majɨ kanjɨm al. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dəw kɨ uwə rɔne nga̰ rɔm tɨ al, a ɨləi-e kɔ gɨdɨ lo tɨ tə baji kagɨ be. Baji kagɨ je kɨ tuti, a kəi-de kadɨ ɓuki-de poro kadɨ o̰i por kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kɨn ə re uwəi rɔsi rɔm tɨ nga̰, ə ta ləm ɨsɨ mesi tɨ tɔ ɓa, ɨdəji nḛ kɨ ɨndɨgi ə a ɨngəi. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nḛ kɨ a ra kadɨ dɨje ɨləi tɔjɨ dɔ Luwə tɨ kɨ taga, e ta kadɨ ɨrai kɨlə je kɨ majɨ majɨ, kɨ dɔ-naa tɨ, dɔ-naa tɨ nɨm, kadɨ ɨtɔji təkɨ səi njé ndo je ləm kɨ rɔjetɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mi m-ndɨgɨ səsi təkɨ Bai ndɨgɨ-m be tɔ. NGa nɨngə, majɨ kadɨ ai dɔ njasi tɨ, me ndɨgɨ tɨ kɨ m-ndɨgɨ səsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kɨn ə re ɨtəli rɔsi go ndu-kun je tɨ ləm ə, a ai dɔ njasi tɨ, me ndɨgɨ tɨ kɨ m-ndɨgɨ səsi, təkɨ m-təl-n rɔm go ndu-kun je tɨ lə Bai Luwə, ə m-a-n dɔ njam tɨ, me ndɨgɨ tɨ kɨ e ndɨgɨ-m kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«M-əl səsi ta je kɨn be mba kadɨ rɔnəl kɨ mem tɨ e rɔnəl ləsi tɔ, nɨngə kadɨ rɔnəl ləsi e rɔnəl kɨ asɨ-naa tapɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","*NDu-kun ləm ə to kɨn: Ɨndɨgi-naa kɨ yo je kɨ ne je dansi tɨ, təkɨ m-ndɨgɨ-n səsi kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kɨn ə re dəw un rɔne ɨlə kɔ mbata lə madɨne je ə, nḛ madɨ kɨ rangɨ kɨ kadɨ a ra, tɔjɨ-n ndɨgɨ-naa kɨ ɨtə e kɨn goto ngata. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kɨn ə re ɨrai nḛ kɨ m-dəjɨ səsi kadɨ ɨrai ɓa, səi madɨm je. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","M-ɓar səsi ɓəə kɨlə je al ratata, tadɔ ɓəə kɨlə gər nḛ kɨ ɓae ɨsɨ ra al. NGa nɨngə mi, m-ɓar səsi madɨm je, mbata m-adɨ səi ɨgəri nḛ je pətɨ kɨ m-ɨngə rɔ Bai Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","E səi je ɓa ɨmbəti-mi al, nə e mi ə m-mbətɨ səsi. Nɨngə, m-adɨ səsi kɨlə kadɨ awi, ɨrai kɨlə je kɨ majɨ majɨ, kɨ a to ratata. Ɓa lo kɨn tɨ, Bai a adɨ səsi nḛ je pətɨ kɨ ɨdəji-e kɨ tɔm. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nḛ kare kɨ m-dəjɨ səsi, e ta kadɨ ɨndɨgi-naa kɨ yo je kɨ ne je dansi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jəju əl ɓəy ə nə: «Kɨn ə re dɨje kɨ dɔnangɨ tɨ ne ɔsi səsi ta ə, kadɨ ɨgər təkɨ e mi ə ɔsi-mi ta kəte no̰si tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","NGa nɨngə, kɨn ə re səi uwəi kɨ dɨje kɨ dɔnangɨ tɨ ne ɓa, re dɨje kɨ dɔnangɨ tɨ ne a ndɨgi səsi; nə kɨ ne kɨn, səi uwəi səde al, tadɔ m-mbətɨ səsi, m-tḛḛ səsi kɔ dande tɨ. Nɨngə e mbata kɨn ə, ɔsi səsi ta. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ə adi mesi ole dɔ ta tɨ kɨ m-əl səsi kəte m-ə nə: “Ɓəə ɨtə ɓane al” kɨn. Kɨn ə re adi-mi ko̰ ɓa, a adi səsi ko̰ tɔ, a re təli rɔde go ta tɨ ləm ɓa, a təli rɔde go ta tɨ ləsi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kɨ ne kɨn, a adi səsi ko̰ mbata ləm, tadɔ gəri dəw kɨ nje kɨlə-m al. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kɨn ə re m-re al, re m-əl-de ta al ə, re dəw a tɨdə majal je ləde dɔde tɨ al; nə kɨ ne kɨn, lo kadɨ a əli əi nə: “Gər ə jɨ gər al,” kadɨ dəw ɨyə̰-n go majal je ləde kɔ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Dəw kɨ mee majal səm ɓa, mee majal kɨ Bai Luwə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kɨn ə re m-ra kɨlə madɨ kɨ dəw madɨ kɨ rangɨ ra nja kare al, dande tɨ al ə, re dəw a tɨdə majal je ləde dɔde tɨ al; nə kɨ ne kɨn, ooi kɨlə ram je kɨ kəmde. Be ka, mede majal səm nɨm, majal kɨ Bai nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nɨngə, e nḛ kɨ ra nḛ be mba kadɨ ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “Mede majal səm kɨ kanjɨ ta madɨ,” kɨn nḛe ra nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«NJe ra səsi kɨ m-a m-ɨlə sie kɨ tɔ Bai Luwə, a re. Nɨngə e ə e NDɨl kɨ nje kəl nḛ je kɨ rɔjetɨ dɔ Luwə, kɨ a ḭ rɔ Luwə tɨ. E ə a ma najɨ dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","NGa nɨngə, səi ka a mai najɨ ləm tɔ, tadɔ səi səm naa tɨ lo kɨlə ngɨrə nḛ je tɨ nu.» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«M-əl səsi ta je kɨn be pətɨ mba kadɨ tə ɨyə̰i ta kadɨ-me ləsi al. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Dɨje a tuwəi səsi kɔ gɨn kəy kaw-naa je tɨ. Nɨngə ndɔ je a rəi wa ɓəy kɨ kadɨ njé kɨ a tɔli səsi, a əli mede tɨ əi nə e kɨlə lə Luwə ə yə n-ɨsɨ n-rai. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A rai be, mbata gəri Bai al nɨm, gəri-mi al nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","NGa nɨngə, m-əl səsi ta je kɨn be kəte, kadɨ tə ndɔ kɨ nḛe je a rai nḛ ɓa, mesi ole dɔ tɨ təkɨ ndɔ kɨ m-əl səsi. M-əl səsi ta je kɨn lo kɨlə ngɨre tɨ nu al, tadɔ mi səsi naa tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Kɨ ɓasɨne kɨn, m-ɨsɨ m-aw kɨ rɔ nje kɨlə-m tɨ, nə dəw kare dansi tɨ kɨ kadɨ dəjɨ-m ə nə: “Ɨsɨ aw ra wa ka,” goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mesi ur made mbata ta je kɨ m-əl səsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","NGa nɨngə, e ta kɨ rɔjetɨ ə m-əl səsi: majɨ ngay mbata tɨ ləsi kadɨ m-aw, tadɔ re m-aw al ə, dəw kɨ nje ra səsi kɨ sɔbɨ kadɨ a re kɨn, a re al. A re m-aw tɔ ɓa, m-a m-ɨlə sie m-adɨ səsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ə lokɨ a re ɓa, a ra kadɨ dɨje kɨ dɔnangɨ tɨ ne gəri nḛ kɨ e majal kɨ ra, kɨ nḛ ra kɨ dana, kɨ ta kɨ gangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kadɨ gəri nḛ kɨ e majal kɨ ra, tadɔ mbati kadi-mi mede, ");
INSERT INTO bjvNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kadɨ gəri nḛ ra kɨ dana, tadɔ m-ɨsɨ m-aw rɔ Bai tɨ, nɨngə səi a oi-mi gogɨ al ratata, ");
INSERT INTO bjvNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","kadɨ gəri ta kɨ gangɨ, tadɔ gangi ta dɔ nje majal tɨ ngata. Adɨ e nje majal kɨ ɨsɨ ɨndə tɔgɨne dɔ dɨje tɨ kɨ dɔnangɨ tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«M-aw kɨ ta je ngay ɓəy kadɨ m-əl səsi, nə kɨ ɓasɨne kɨn, a al dɔsi. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","NGa nɨngə, dɔkagɨlo kɨ NDɨl kɨ nje kɔjɨ nḛ je kɨ rɔjetɨ a re ɓa, a ra kadɨ ɨgəri nḛ je pətɨ kɨ rɔjetɨ. A əl ta kɨ tɔne wa al, nə a əl nḛ je pətɨ kɨ ɨngə rɔ Luwə tɨ, nɨngə a ɨlə səsi mbḛ nḛ je kɨ a rai nḛ lo ti tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","E tɔjɨ tɔɓa ləm kɨ taga, tadɔ e ta je ləm, ə a ɨlə səsi mbḛe. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nḛ je pətɨ kɨ e ya̰ Bai, e ya̰m tɔ. E mbata kɨn ə, m-əl-n m-ə nə: E ta je ləm, ə NDɨl a ɨlə səsi mbḛe.» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jəju əl ə nə: «Nay dɔkagɨlo ndə̰y ba kadɨ a oi-mi al, nɨngə dɔkagɨlo ndə̰y go tɨ ə, a təli oi-mi gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ə njé ndo je madɨ əli-naa dande tɨ əi nə: «Ta kɨ əl-je ə nə: “Nay dɔkagɨlo ndə̰y ba kadɨ a oi-mi al, nɨngə dɔkagɨlo ndə̰y go tɨ ə, a təli oi-mi gogɨ,” kɨn mee nə ri ə? Taa əl ta kɨ kare ɓəy ə nə: “Tadɔ m-ɨsɨ m-aw rɔ Bai tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ə “dɔkagɨlo ndə̰y” kɨ əl tae kɨn me nə ri tɔ ə? Jɨ gər me ta kɨ ge kəl-je kɨn al!» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lokɨ Jəju gər kadɨ njé ndo je lie ɨsɨ sangi kadɨ dəji-e ta ɓa, əl-de ə nə: «Ɨsɨ dəji-naa ta dansi tɨ ɔjɨ dɔ ta kɨ m-əl səsi m-ə nə: “Nay dɔkagɨlo ndə̰y ba kadɨ a oi-mi al, nɨngə dɔkagɨlo ndə̰y go tɨ ə, a təli oi-mi gogɨ,” kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","NGa nɨngə, təkɨ rɔjetɨ, adɨ m-əl səsi: A no̰i je, a ndɨgəi ndoo je, nə dɨje kɨ dɔnangɨ tɨ ne a rai rɔnəl. Me ko̰ a ra səsi, nə me-ko̰ ləsi kɨn a təl rɔnəl. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lokɨ dəne aw tə ojɨ ngon ɓa, e me ko̰ tɨ, tadɔ dɔkagɨlo ko̰ lie re, nə lokɨ ngon tḛḛ rɔe tɨ ngata ɓa, mee oy dɔ ko̰ tɨ, mbata rɔnəl dəw kɨ oje ɨle dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nɨngə, səi ka, kɨ ɓasɨne kɨn, səi me ko̰ tɨ, nə m-a m-təl m-o səsi, kadɨ rɔnəl a rosɨ mesi, nɨngə e rɔnəl kɨ dəw a ɔr mesi tɨ goto al. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","NDɔe tɨ kɨn, a dəji-mi ta dɔ nḛ madɨ tɨ al ngata. Nɨngə, təkɨ rɔjetɨ, adɨ m-əl səsi, Bai a adɨ səsi nḛ je pətɨ kɨ ɨdəji-e kɨ tɔm. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bɨtɨ ɓone ka, ɨdəji nḛ madɨ kɨ tɔm al ɓəy. Ɨdəji ə a ɨngəi, kadɨ rɔnəl ləsi asɨ-naa tapɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«M-əl səsi ta je kɨn me kujɨ ta tɨ, nə ndɔ je a rəi no̰o̰ kadɨ m-a m-əl səsi ta me kujɨ ta tɨ al ngata, nə m-a m-əl səsi ta kɨ dɔ Bai Luwə tɨ wangɨ taga. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ḭ dɔ ndɔe tɨ kɨn, a dəji nḛ Bai kɨ tɔm, nɨngə m-a m-əl səsi al, təkɨ m-ɨsɨ m-əl ta kɨ Bai mbata tɨ ləsi, ");
INSERT INTO bjvNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tadɔ Bai Luwə ə wa ndɨgɨ səsi. Luwə ndɨgɨ səsi, mbata ɨndɨgi-mi, taa adi mesi təkɨ m-ḭ rɔe tɨ ə m-re tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","M-ḭ rɔ Bai tɨ ə m-re dɔnangɨ tɨ ne, nɨngə kɨ ɓasɨne kɨn, m-a m-ɨyə̰ dɔnangɨ ə m-təl m-aw rɔ Bai tɨ gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ə njé ndo je lie əli əi nə: «O, kɨ ne kɨn, yə əl-je ta ay njay, kɨ kanjɨ kəl me kujɨ ta tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nɨngə kɨ ɓasɨne kɨn, jɨ gər kadɨ ɨgər nḛ je pətɨ, taa ta je kɨ to me dəw tɨ ɓəy, kadɨ tə dəw dəji ka ɨgər kəte. Lo kɨn tɨ, j-adi meje kadɨ ḭ rɔ Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ə Jəju ɨlə-de tɨ ə nə: «Adi mesi ngata a? ");
INSERT INTO bjvNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Oi, dɔ kadɨ ɨsɨ re, nɨngə kɨ ne kɨn, re tḛḛ ne ngata kɨ kadɨ dɨje a sanəi səsi kɨ lo kare kare. A ɨyə̰i-mi kɨ karm, nə mi kɨ karm al, tadɔ Bai Luwə e səm naa tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","M-əl səsi ta je kɨn pətɨ be, mba kadɨ lapɨya e mesi tɨ, me kɨndə rɔ naa tɨ səm. A ɨngəi ko̰ dɔnangɨ tɨ ne, nə kadɨ uwəi tɔgɨsi ba, tadɔ m-tətɨ rɔ njé tɔgɨ je kɨ dɔnangɨ tɨ ne ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Go ta tɨ kɨ Jəju əl kɨn ɓa, un kəmne kɨ taa dɔra̰ tɨ, nɨngə əl ə nə: «Bai, ndɔ re nga. Ɨtɔjɨ tɔɓa ləm, mi NGoni kɨ taga adɨ dɨje gəri, kadɨ tə mi NGoni, m-tɔjɨ tɔɓa ləi kɨ taga madɨ dɨje gəri tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ḭ, adɨ-m tɔgɨ dɔ dɨje tɨ pətɨ, kadɨ tə m-adɨ njé kɨ ɨyə̰-de jim tɨ, ɨsi kɨ dɔde taa bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kɨsɨ kɨ dɔ taa bɨtɨ kɨ no̰ tɨ, e ta kadɨ dəw gəri, ḭ kɨ ḭ kɨ kari ba ə ḭ Luwə kɨ rɔjetɨ kɨn nɨm, kadɨ gər Jəju Kɨrɨsɨ kɨ e dəw kɨ ɨle kɨn nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","M-tɔjɨ tɔɓa ləi m-adɨ dɨje kɨ dɔnangɨ tɨ ne pətɨ gəri, nɨngə kɨlə kɨ adɨ-m kadɨ m-ra ka m-tɔl tae majɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kɨ ɓasɨne kɨn, Bai, m-dəji kadɨ adɨ-m m-ɨngə kɔsɨ-gon ta kəmi tɨ təkɨ ndɔ kɨ adɨ-m kəte no̰ kɨndə dɔra̰ tɨ, kɨ dɔnangɨ tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«M-ra m-adɨ dɨje kɨ ɔy-de dan madɨde je tɨ kɨ dɔnangɨ ne, adɨ-m kɨn gəri-ni. Əi dɨje ləi, ə ɨyə̰-de me jim tɨ, nɨngə təli rɔde majɨ go ta tɨ ləi. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kɨ ɓasɨne kɨn, gəri kadɨ nḛ je pətɨ kɨ adɨ-m, ḭ rɔi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tadɔ m-adɨ-de ta je kɨ adɨ-m, nɨngə taai. Lokɨ taai ɓa, gəri kadɨ m-ḭ rɔi tɨ, adɨ adi-mi mede təkɨ e ḭ ə ɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nɨngə e mbata tɨ ləde ə m-əl səi ta. M-əl səi ta mbata lə dɨje kɨ dɔnangɨ tɨ ne al, nə mbata lə njé kɨ ɨyə̰-de me jim tɨ, tadɔ njé kɨ ɨyə̰-de me jim tɨ kɨn əi dɨje ləi. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nɨngə nḛ je pətɨ kɨ e ya̰m, e ya̰i, ə nḛ je pətɨ kɨ e ya̰i, e ya̰m tɔ. NGa nɨngə, əi je, tɔji tɔɓa ləm kɨ taga adi dɨje ooi. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi, m-a mi dɔnangɨ tɨ ne al ngata, m-ɨsɨ m-aw kɨ rɔi tɨ, nə əi je, ɨsi dɔnangɨ tɨ ne ɓəy. Be ə, Bai Luwə kɨ njé kay njay, m-dəji kadɨ ɨndə kəmi gode tɨ majɨ. Ɨndə kəmi gode tɨ kɨ tɔgɨ ləi, kɨ e tɔgɨ kɨ adɨ-m m-ra-n kɨlə kɨn, kadɨ tə əi kare ba təkɨ je səi je kare ba kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dɔkagɨlo kɨ mi səde, m-ɨndə kəm gode tɨ majɨ kɨ tɔgɨ ləi kɨ adɨ-m. M-dəbɨ bagɨm dɔde tɨ, adɨ dəw kare ka tae tḭ al. Dəw ɓa, e e kɨ sɔbɨ kadɨ tae a tḭ kadɨ tə ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə tɔl-n tane ka kɨn par. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","NGa nɨngə, kɨ ɓasɨne kɨn, m-ɨsɨ m-aw kɨ rɔi tɨ, ə m-əl ta kɨn be təkɨ mi-n səde dɔnangɨ tɨ ne ɓəy kɨn, kadɨ tə əi wa ɨngəi rɔnəl kɨ mem tɨ, kɨ e rɔnəl kɨ asɨ-naa tapɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","M-adɨ-de ta ləi nɨngə, dɨje kɨ dɔnangɨ tɨ ne ɔsi-de ta mbata ke kɨ əi dɨje kɨ dɔnangɨ tɨ ne al, təkɨ mi mi-n dəw kɨ dɔnangɨ tɨ ne al kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","NGa nɨngə, m-dəji kadɨ ɔy-de kɔ dɔnangɨ tɨ ne al, nə kadɨ ɔsɨ NJe majal ngərəngɨ dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Əi dɨje kɨ dɔnangɨ tɨ ne al, təkɨ mi mi-n dəw kɨ dɔnangɨ tɨ ne al kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Majɨ kadɨ un-de kɨ ta kɨ rɔjetɨ, ɨndə-de ta dangɨ tə dɨje ləi. Ta ləi e ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nɨngə, mi ka, m-ɨlə-de dɔnangɨ tɨ, təkɨ ɨlə-m dɔnangɨ tɨ ka kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi wa, m-un rɔm m-ɨndə ta dangɨ tə dəw ləi mbata tɨ ləde, kadɨ tə əi je ka, əi kɨ kɨndə ta dangɨ me ta kɨ rɔjetɨ tə dɨje ləi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«M-əl səi ta mbata tɨ lə njé kɨ m-ɨlə-de kɨn par al, nə mbata tɨ lə dɨje pətɨ kɨ a adi-mi mede, kɨ go rəbɨ lə ta kɨ a tḛḛ ta njé je tɨ kɨ m-ɨlə-de. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","M-dəji kadɨ pətɨ, təli dɨje kɨ kare, təkɨ ḭ Bai, ɨndə rɔi naa tɨ səm, ə mi m-ɨndə rɔm naa tɨ səi kɨn be. Kadɨ əi ka ɨndəi rɔde naa tɨ səje tɔ, kadɨ tə dɨje kɨ dɔnangɨ tɨ ne adi mede təkɨ e ḭ ə ɨlə-m. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi m-adɨ-de kɔsɨ-gon kɨ adɨ-m, kadɨ tə əi dɨje kɨ kare, təkɨ je səi je-n dɨje kɨ kare kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mi m-ɨndə rɔm naa tɨ səde, nɨngə ḭ, ɨndə rɔi naa tɨ səm tɔ; ɓa lo kɨn tɨ, a asi kadɨ əi dɨje kɨ kare ba kɨ rɔjetɨ, kadɨ dɨje kɨ dɔnangɨ tɨ ne gəri təkɨ e ḭ ə ɨlə-m nɨm, ɨndɨgɨ-de təkɨ ɨndɨgɨ-m be nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Oyo, Bai, njé kɨ adɨ-m-de kɨn, m-ndɨgɨ ngay kadɨ əi səm naa tɨ, lo tɨ kɨ m-a mi tɨ, kadɨ oi kɔsɨ-gon kɨ m-aw-n, kɔsɨ-gon kɨ ḭ adɨ-m. M-əl m-ə nə adɨ-m kɔsɨ-gon, mbata ɨndɨgɨ-m kəte no̰ kɨndə dɔra̰ tɨ kɨ dɔnangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bai kɨ nje ra nḛ kɨ dana, dɨje kɨ dɔnangɨ tɨ ne gəri-ni al, nə mi m-gər-i, taa njé kɨ adɨ-m-de ka gəri təkɨ e ḭ ə ɨlə-m tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","M-ra m-adɨ gəri-ni, nɨngə m-a m-adɨ gəri-ni kɨ kəte ɓəy, kadɨ tə ko ndɨgɨ kɨ ɨndɨgɨ-m kɨn to mede tɨ nɨm, kadɨ mi wa mi naa tɨ səde nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Go ta tɨ kɨ Jəju əl kɨ Luwə kɨn ɓa, ɔti kɨ njé ndo je ləne, ali dɔ lo, awi dam ngon man tɨ madɨ kɨ ɓari-e Sədɨro̰. Loe tɨ kɨn, lo ndɔr kɨ dəw mə kagɨ je tɨ to no̰o̰, ə uri me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasɨ kɨ nje kun dɔ Jəju, gər lo kɨn majɨ, mbata e lo kɨ Jəju əi kɨ njé ndo je ləne ɨsɨ rəi tɨ taa taa. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","E be ə, Judasɨ un dɔ ɓutɨ asɨgar je lə ko̰ɓe kɨ Rom, aw səde loe tɨ ka kɨn. Taa njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ *Parɨsɨ je, ɨləi njé ngəm ta kəy lə Luwə adɨ əi səde no̰o̰ tɔ. Dɨje kɨ go Judasɨ tɨ kɨn oti kɨyə kasɨgar je, kɨ lambɨ je, kɨ por ngəl je. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lo kɨn tɨ, Jəju kɨ gər nḛ pətɨ kɨ a re dɔe tɨ, ɔtɨ kɨ rɔde tɨ, dəjɨ-de ə nə: «Ɨsɨ sangi na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓa əi je ɨləi-e tɨ əi nə: «J-ɨsɨ jɨ sangɨ Jəju kɨ Najarətɨ tɨ.» Ə Jəju əl-de ə nə: «E mi wa ə m-a am.» Judasɨ wa kɨ nje kun dɔ Jəju ka kɨn ka a səde no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lokɨ Jəju əl-de ə nə: «E mi wa ə m-a am» kɨn ɓa, gədi gogɨ, nɨngə tḛḛi tosi. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jəju təl dəjɨ-de ɓəy ə nə: «Ɨsɨ sangi na̰ wa?» Ɓa əi je ɨləi-e tɨ əi nə: «J-ɨsɨ jɨ sangɨ Jəju kɨ Najarətɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ə Jəju əl-de ə nə: «M-əl səsi m-ə nə, e mi wa ə m-a am. Ə re e mi ə ɨsɨ ɨsangi-mi ɓa, ɨyə̰i ndəgɨ dɨje kam adɨ awi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","To be kadɨ ta kɨ tḛḛ ta Jəju tɨ kɨ rɔ Bawe Luwə tɨ ə nə: «NJé kɨ adɨ-m-de, dəw kare ka m-tḭ tae al» kɨn, tɔl tane. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sɨmo̰ Pɨyər kɨ otɨ kɨyə kasɨgar rɔne tɨ, ɔr tɨgə-n paja lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, ɓa ɔdɨ mbie kɨ dɔ ji ko̰ tɨ, tɨgə latɨ gangɨ. Tɔ paja ka kɨn nə Malkusɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ə Jəju əl Pɨyər ə nə: «Ɨlə kɨyə ləi sawe tɨ gogɨ. O kadɨ m-a m-ɨngə ko̰ kɨ Bai ɨndə dɔe dana mbata tɨ ləm kɨn al a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɓutɨ asɨgar je lə ko̰ɓe kɨ Rom, naa tɨ kɨ nje kun dɔde nɨm, kɨ njé ngəm ta kəy lə Luwə kɨ *Jɨpɨ je ɨləi-de ka kɨn nɨm, uwəi Jəju dɔɔi-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dɔ kəte, awi sie ɓe lə An kɨ e məm Kayɨpɨ. Kayɨpɨ ə e kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je ɓale tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","NGa nɨngə e darɔ Kayɨpɨ wa kɨn ə e nje kəl kə nə: «E sotɨ ngay mbata tɨ ləsi kadɨ ba kal dəw kare oy mbata lə gɨn dɨje kosɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sɨmo̰ Pɨyər əi kɨ nje ndo kare kɨ dan njé ndo je tɨ lə Jəju, uni go Jəju. NJe ndo kare kɨ əi kɨ Pɨyər ka kɨn e dəw kɨ kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je gər-e, adɨ ur natɨ kəy tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, naa tɨ kɨ Jəju kɨ uri sie kəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pɨyər ə ɨsɨ ya̰ne taga, ɓasi ta kəy tɨ. Lo kɨn tɨ, nje ndo kɨ kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je gər-e ka kɨn, tḛḛ taga, əl ta kɨ dəne kɨ nje ngəm ta kəy, ɓa go tɨ, dəne ɨyə̰ Pɨyər ade ur kəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dəne kɨ nje ngəm ta kəy ka kɨn əl Pɨyər ə nə: «Ḭ ka ḭ dan njé ndo je tɨ lə dɨngəm kɨn tɔ al a?» Ə Pɨyər ɨle tɨ ə nə: «Jagɨ, mi səde al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kul o̰, adɨ njé ra kɨlə je, kɨ njé ngəm ta lo je, ɨləi por a ndɨbi. Pɨyər ka a səde ta por tɨ ka kɨn no̰o̰, a ndɨbɨ səde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je dəjɨ ta Jəju dɔ njé ndo je tɨ lie kɨ dɔ nḛ ndo tɨ lie kɨ ɨsɨ ndo dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ə Jəju ɨlə tɨ ə nə: «M-əl ta dɨje taga wangɨ, taa kɨ ndɔ je, ndɔ je, m-ɨsɨ m-ndo nḛ dɨje gɨn kəy kaw-naa je tɨ lə *Jɨpɨ je nɨm, gɨn kəy tɨ lə Luwə nɨm, kɨ e lo je kɨ dɔ Jɨpɨ je pətɨ ɨsɨ ɔsɨ-naa tɨ. Nḛ madɨ kɨ m-əl lo ɓɔyɔ tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","NGa ra ban ə ɨdəjɨ-m ta ɓəy ə? Ɨdəjɨ ta njé kɨ ɨsɨ ooi-mi lo kəl ta tɨ kɨn o, gəri ta kɨ m-ɨsɨ m-əl-de majɨ ngay.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dɔ ta tɨ kɨn, nje ngəm ta lo kare kɨ a səde no̰o̰, ɨndə mbɔ Jəju, ə əl-e ə nə: «Adɨ e be ə kadɨ tur-n ta kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je tɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ə Jəju ɨle tɨ ə nə: «Kɨn ə re ta kɨ m-əl kɨn, majal ə, ɔjɨ maje al adɨ-m m-o, a re m-əl majɨ tɔ ə, ra ban be ə ɨndə-m ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lo kɨn tɨ, An adɨ awi kɨ Jəju kɨ dɔɔ kɨ dɔɔi-e kɨn be ɓe lə Kayɨpɨ, kɨ e kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pɨyər ɨsɨ ta por tɨ no̰o̰, ɨsɨ ndɨbɨ por, ə əli-e əi nə: «Ma, ḭ ka ḭ dan njé ndo je tɨ lie tɔ al a?» Nə Pɨyər najɨ ə nə: «Jagɨ, mi səde al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kɨ kare dan njé ra kɨlə je tɨ lə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ e nojɨ dɨngəm kɨ Pɨyər tɨgə mbie gangɨ, əl Pɨyər ə nə: «Dəw kɨ m-o-e sie, lo ndɔr tɨ kɨ məi kagɨ je tɨ kɨn, e ḭ al ə na̰ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nə Pɨyər najɨ wa ɓəy. Ɓa ta ji naa tɨ no̰o̰, kunə kɨnjə no̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lokɨ ḭḭ kɨ Jəju ɓe lə Kayɨpɨ ɓa, awi sie kəy tɨ kɨ boy kɨ *Pɨlatɨ kɨ e nje ko̰ɓe kɨ ngar kɨ Rom tɨ ɨnde dɔ dɔnangɨ tɨ kɨ Jude tɨ ɨsɨ tɨtɨ. E sḭ ɓatɨ ba ɓəy. Nɨngə njé kun dɔ *Jɨpɨ je mbati kur me kəy kɨ boy tɨ, kadɨ tə n-awi kɨ ta dɔde tɨ al, ta kəm Luwə tɨ, kadɨ tə n-usoii nḛ lo ra nay Pakɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","E mbata kɨn ə, Pɨlatɨ tḛḛ ɨngə-de taga, nɨngə dəjɨ-de ə nə: «E ri ə ɨsəkii dɨngəm kam ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓa, əi je ɨləi-e tɨ əi nə: «Kɨn ə re e dəw kɨ nje ra nḛ kɨ majal al ə, re j-a jɨ re sie, j-ule jii tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ə Pɨlatɨ əl-de ə nə: «Səi je wa, ɨtaai-e, awi gangi ta dɔe tɨ kɨ go ndu-kun je tɨ ləsi, səi Jɨpɨ je.» Nə əli Pɨlatɨ əi nə: «Je, dəw adɨ-je ta rəbɨ kɨ kadɨ jɨ gangɨ-n ta koy dɔ dəw tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","E be ə, ta kɨ Jəju wa əl kadɨ tɔjɨ-n ko koy kɨ a oy kɨn tɔl tane. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pɨlatɨ təl ur me kəy tɨ kɨ boy, ɓar Jəju, nɨngə dəje ə nə: «Ḭ ngar lə Jɨpɨ je a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ə Jəju təl dəjɨ Pɨlatɨ ə nə: «Ta kɨn, e ḭ wa ə əl ə se, e dɨje kɨ rangɨ ə əli-ni ta kɨ dɔm tɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ɓa Pɨlatɨ əl Jəju ə nə: «Mi kɨ o-m kɨn mi Jɨpɨ a? E dɨje kɨ gɨn ɓe tɨ ləi ə wa nɨm, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je nɨm, ə rəi səi ɨləi-ni jim tɨ! NGa nɨngə m-dəji se e ri ə ɨra wa?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ə Jəju ɨle tɨ ə nə: «Mi ngar kɨ dɔnangɨ tɨ ne al, re mi ngar kɨ dɔnangɨ tɨ ne ə, re dɨje kɨ gom tɨ, a rɔi dɔm tɨ kadɨ dəw ɨlə-m ji njé kun dɔ Jɨpɨ je tɨ al; nə ke ə mi ngar kɨ dɔnangɨ tɨ ne al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nɨngə Pɨlatɨ dəje ə nə: «Adɨ ḭ ngar ta?» Ɓa Jəju ɨle tɨ ə nə: «E ta kɨ ḭ ə tḛḛ tai ə nə mi ngar. Mi, oji-mi, nɨngə m-re dɔnangɨ tɨ ne mba kadɨ m-ma najɨ dɔ nḛ kɨ rɔjetɨ. NGa nɨngə, dəw kɨ e me nḛ kɨ rɔjetɨ, təl rɔne go ta tɨ ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lo kɨn tɨ, Pɨlatɨ dəje ə nə: «E ri ə e nḛ kɨ rɔjetɨ ə?» Go ta tɨ kɨ Pɨlatɨ dəjɨ kɨn ɓa, təl tḛḛ taga rɔ Jɨpɨ je tɨ əl-de ə nə: «M-ɨngə ta madɨ kare kɨ kadɨ m-gangɨ-n ta dɔ dəw tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","NGa nɨngə, kɨ go jibəl rae tɨ kɨ ɨsɨ rai kəte, kəte, ə dɔkagɨlo ra nay Pakɨ ɓa, m-ɨyə̰ dangay kare taa m-adɨ səsi kɨn, ɨndɨgi dɔ tɨ kadɨ m-ɨyə̰ ngar lə *Jɨpɨ je taa madɨ səsi a?» ");
INSERT INTO bjvNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nə əi je, uni ndude kɨ taa əli əi nə: «Jagɨ, e al, e Barabasɨ ə jɨ ndɨgɨ kadɨ ɨyḛ taa.» Barabasɨ kɨ əli ta lie kɨn, e baw kaya. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","*Pɨlatɨ adɨ ndune asɨgar je kadɨ awi kɨ Jəju, nɨngə kadɨ ɨndəi-e kɨ ndəy kabɨlay. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asɨgar je oji jɔgɨ kon ɨləi dɔe tɨ, nɨngə ɨləi kɨbɨ ngal kɨ kər pɨr pɨr rɔe tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","NJɨyəi rəi rɔe tɨ, nɨngə əli-e əi nə: «Lapɨya, ngar lə Jɨpɨ je!» Ɓa ɓuki jide mbɔe tɨ, ɨndəi-e. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","NJa kare ɓəy, Pɨlatɨ tḛḛ rɔ kosɨ je tɨ əl-de ə nə: «Majɨ, m-a m-re sie taga rɔsi tɨ ne, kadɨ ɨgəri təkɨ m-ɨngə ta madɨ kare kɨ kadɨ m-gangɨ-n ta dɔe tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lo kɨn tɨ no̰o̰ be, Jəju tḛḛ taga kɨ jɔgɨ kon dɔne tɨ nɨm, kɨ kɨbɨ ngal kɨ kər pɨr pɨr rɔne tɨ nɨm. Nɨngə Pɨlatɨ əl-de ə nə: «Dɨngəm ka yə a am!» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nə lokɨ, njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ njé ngəm ta lo je lə Jɨpɨ je, ooi-e ɓa, ɨləi ngɨrə kəl ta kɨ ndude kɨ boy əi nə: «Ɨɓe kagɨ-dəsɨ tɨ! ɨɓe kagɨ-dəsɨ tɨ!» Ə Pɨlatɨ əl-de ə nə: «Səi je wa, ɨtaai-e, awi ɨɓəi-e kagɨ-dəsɨ tɨ, tadɔ mi, m-ɨngə ta madɨ kɨ kadɨ m-gangɨ-n ta koy dɔe tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nɨngə Jɨpɨ je əli Pɨlatɨ əi nə: «J-aw kɨ ndu-kun kare no̰o̰, ɓa kɨ go ndu-kun tɨ ka kɨn, e dəw kɨ sɔbɨ kadɨ a oy, tadɔ əl ə nə n-e NGon lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lokɨ Pɨlatɨ oo ta kɨn ɓa, ade ɓəl kɨ dɔ made tɨ ɓəy, ");
INSERT INTO bjvNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ə təl ur me kəy tɨ kɨ boy, nɨngə dəjɨ Jəju ə nə: «Ḭ, ḭ ra ə?» Nə Jəju ɨle ta tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ə Pɨlatɨ əl Jəju ə nə: «Mi ə m-dəji ta ə ɨlə-m tɨ al a? Ɨgər kadɨ m-aw kɨ tɔgɨ kadɨ m-ge ə m-ɨyə̰-i taa nɨm, m-ge ə m-ɓə-i kagɨ-dəsɨ tɨ nɨm, ə se ɨgər al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jəju ɨle tɨ ə nə: «Kɨn ə re e tɔgɨ kɨ Luwə wa ə adi dɔra̰ tɨ nu kɨn al ə, aw kɨ tɔgɨ madɨ kare dɔm tɨ al. Ɓa e mbata kɨn ə, dəw kɨ nje kɨlə-m jii tɨ, majal lie e ngay ɨtə ya̰i.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dɔ ta tɨ wa kɨn ɓa, Pɨlatɨ sangɨ kadɨ n-ɨyə̰ Jəju, nə Jɨpɨ je ɨləi kɔl, ə əli-e əi nə: «Kɨn ə re ɨyḛ taa ɓa, ḭ madɨ Səjar kɨ e ngar kɨ bo kɨn al. Dəw kɨ ə nə n-e ngar ɓa, dəwe kɨn e nje ta lə Səjar.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lokɨ Pɨlatɨ oo ta kɨn ɓa, adɨ awi kɨ Jəju taga, nɨngə e wa ɨsɨ dɔ kɨmbər ngar tɨ, lo tɨ kɨ ɓari-e Gajɨ mbal je kɨ kɨndə nangɨ, kɨ ta ebɨrə ə nə «Gabata». ");
INSERT INTO bjvNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","E ndɔ kɨ kadɨ lo ti par ə e kɨlə ngɨrə ra nay Pakɨ, nɨngə e kadɨ kɨ jam dɔ ɓe tɨ be. Ə Pɨlatɨ əl Jɨpɨ je ə nə: «Oi ngar ləsi.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nə uni ndude kɨ taa əli əi nə: «Kadɨ oy kɔ! kadɨ oy kɔ! Ɨɓe kagɨ-dəsɨ tɨ!» Ə Pɨlatɨ əl-de ə nə: «Kadɨ tə m-ɓə ngar ləsi kagɨ-dəsɨ tɨ a?» Ɓa njé kun dɔ njé kɨjə nḛ məsɨ kadɨ-kare je əli əi nə: «Dəw oo ngar ləje kɨ rangɨ al, ngar ləje e Səjar par.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lo kɨn tɨ, Pɨlatɨ ɨlə Jəju ji asɨgar je tɨ kadɨ ɓəi-e kagɨ-dəsɨ tɨ. Asɨgar je uwəi Jəju awi sie. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","E wa otɨ kagɨ-dəsɨ ləne, tḛḛ-n gɨdɨ ɓe bo tɨ kɨ taga, kadɨ aw-n lo tɨ kɨ ɓari-e «Ka dɔ dəw», kɨ ta ebɨrə nə «Golgota». ");
INSERT INTO bjvNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","E loe tɨ kɨn ə asɨgar je ɓəi Jəju tɨ, kagɨ-dəsɨ tɨ. Ɓəi dɨje joo kagɨ-dəsɨ tɨ sie, kɨ kare dɔ ji ko̰e tɨ, ə kɨ kare dɔ ji gəle tɨ tɔ, nɨngə e wa a dana. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","*Pɨlatɨ adɨ rai ngon ba, ndangi nḛ me tɨ, ɨndəi taa dɔ kagɨ-dəsɨ kɨ Jəju a tɨ. Nḛ kɨ ndangi me tɨ nə: «Jəju kɨ Najarətɨ tɨ, ngar lə *Jɨpɨ je.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lokɨ ɓəi Jəju tɨ, kagɨ-dəsɨ tɨ ka kɨn e ɓasi kɨ ɓe bo, adɨ Jɨpɨ je ngay tɨdəi nḛ kɨ ndangi kɨn. NDangi kɨ ta ebɨrə nɨm, kɨ ta latḛ nɨm, taa kɨ ta gɨrəkɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ə njé kun dɔ njé kɨjə nḛ kadɨ-kare je əli Pɨlatɨ əi nə: «Nḛ kɨn, sɔbɨ kadɨ re a ndangɨ “ngar lə Jɨpɨ” be al, nə re a ndangɨ “dɨngəm kam əl ə nə n-e ngar lə Jɨpɨ je” taa e go rəbe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nə Pɨlatɨ əl-de ə nə: «Nḛ kɨ m-ndangɨ ɓa, ndange ka m-ndangɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lokɨ asɨgar je ɓəi Jəju kagɨ-dəsɨ tɨ gɨne gangɨ ɓa, kəi kɨbɨ je lie, ka̰yḭ gɨn sɔ, sɔbɨ dɔde kare kare. Nɨngə nay kɨbɨ ngal kɨ dəw uu al, nə oji ta naa tɨ be par, ḭ taa re nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ə asɨgar je əli-naa əi nə: «Adɨ jɨ tɨli kɨbɨ ngal kɨn al, nə adɨ jɨ tɨgəi kɨr (mbare) dɔ tɨ j-oi se na̰ ə a e ya̰e wa.» Nɨngə e nḛ kɨ a to be kadɨ ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: «Ka̰yḭ-naa kɨbɨ je lie, Ə tɨgəi kɨr dɔ kɨbɨ ngal tɨ lie tɔ» kɨn tɔl tane. Nɨngə e nḛe ka yə asɨgar je rai kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ko̰ Jəju əi kɨ ngokone kɨ dəne nɨm, Mari kɨ ne Kɨləwopasɨ nɨm, taa Mari kɨ Magɨdala nɨm ai no̰o̰, ɓasi kadɨ kagɨ-dəsɨ tɨ kɨ ɓəi Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lokɨ Jəju oo kone, ə oo nje ndo ləne kɨ e Jəju ndɨgɨ, a gədɨ ko̰e tɨ ɓa, əl kone ə nə: «Dəne, o ngoni ə a am.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɓa go tɨ, əl nje ndo ləne ka kɨn ə nə: «O ko̰i ə a am.» Nɨngə, ndɔe tɨ no̰o̰, nje ndo ka kɨn aw kɨ ko̰ Jəju rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Go nḛ je tɨ kɨn, Jəju gər kadɨ gɨn nḛ je pətɨ gangɨ ngata ɓa, əl ta kɨn kadɨ tɔl ta ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə ə nə: «Kɨndə ra-m.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","NGoo kɨ kasɨ nju kɨ masɨ rosɨ ɨsɨ no̰o̰, ə asɨgar je ndui nḛ kɨ to hom hom me kasɨ nju tɨ kɨ masɨ ka kɨn, ɨləi ta kagɨ tɨ kɨ ɓari-e ijopɨ, ɓa ɨləi ta Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ə lokɨ Jəju njɨbɨ kasɨ kɨ masɨ ka kɨn nɨngə, əl ə nə: «Gɨn nḛ je pətɨ gangɨ ngata», ɓa ɨlə dɔne nangɨ, nɨngə kə̰ə̰e tḛḛ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","E ndɔ kɨ kadɨ lo ti dɔ tɨ ə, e ndɔ taa kə̰ə̰. E ndo taa kə̰ə̰ kɨ to ta dangɨ, ə, kadɨ tə nɨn je ai dɔ kagɨ-dəsɨ tɨ ba ndɔ taa kə̰ə̰ tɨ al, Jɨpɨ je awi dəji Pɨlatɨ kadɨ adɨ budi njade, ə ɔri-de kɔ dɔ kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lo kɨn tɨ, asɨgar je awi budi nja dəw kɨ dɔsa̰y nɨm, e kɨ ko̰ joo nɨm, kɨ ɓəi-de kagɨ-dəsɨ tɨ naa tɨ kɨ Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lokɨ rəi tḛḛi dɔ Jəju tɨ ɓa, oi kadɨ e oy ngata, adɨ budi njae al. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nɨngə asɨgar kare ə ɔsɨ kade kɨ nɨngə, ɓa ta naa tɨ no̰o̰, məsɨ əi kɨ man tḛḛi ta do nɨngə tɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Dəw kɨ ɔr go nḛ je kɨn, oo kɨ kəmne, nɨngə najɨ kɨ ma lie e kɨ rɔjetɨ, taa e wa gər kadɨ e ta kɨ rɔjetɨ ə n-əl tɔ, mba kadɨ tə səi ka adii mesi. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Təkɨ rɔjetɨ, nḛ je kɨn rai nḛ be mba kadɨ tə ta kɨ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: «Sɨnge kare ka dəw a tətɨ al», kɨn tɔl tane. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Taa ndangi ta kɨ rangɨ ɓəy me makɨtɨbɨ tɨ lə Luwə əi nə: «A go̰i lo kɨ rɔ dəw tɨ kɨ ɔsi kade kɨ nɨngə.» ");
INSERT INTO bjvNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Go nḛ je tɨ kɨn, Jɨsəpɨ kɨ e dəw kɨ Arɨmate tɨ, aw dəjɨ ta rəbɨ *Pɨlatɨ kadɨ n-ɔr nɨn Jəju. Jɨsəpɨ e nje ndo lə Jəju kɨ ra rɔne lo ɓɔyɔ tɨ, mbata ɓəl *Jɨpɨ je. Pɨlatɨ ade ta rəbɨ, adɨ aw ɔr nɨn Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nɨkodəm kɨ ndɔ kɨ aw ɨngə Jəju kondɔ ka kɨn ka, aw kɨ ndujɨ kagɨ je kɨ ətɨ majɨ joo kɨ mba kɔy rɔ nɨn tɨ. NDujɨ kagɨ je kɨ ɓari-de mɨr əi kɨ alowəsɨ, poləi-de naa tɨ asɨ kɨləw kutɨ mɨtə be. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dɨje kɨ joo kɨn, uni nɨn Jəju, doləi kɨ ta kɨbɨ lḛ. Lo dole tɨ, ɓuki ndujɨ kagɨ kɨ ətɨ majɨ tɨtɨ ndə̰y, ndə̰y, taa doləi, kɨ go kujɨ rae tɨ lə Jɨpɨ je kɨ ɨsɨ rai kɨ nɨn je ləde ɓəy taa ɨləi ɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lo kɨ ɓəi Jəju tɨ, kagɨ-dəsɨ tɨ ka kɨn, lo ndɔr kɨ məi kagɨ je tɨ to no̰o̰, nɨngə me ndɔr tɨ ka kɨn, ɓe kɨ to sɨgɨ, kɨ dəw ɨlə nɨn tɨ al ɓəy to tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","NGa nɨngə, tə ka kɨ lo ti ə a e ndɔ taa kə̰ə̰ lə Jɨpɨ je, ɨləi Jəju me ɓe tɨ ka kɨn, tadɔ e ɓasi kade tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","NDɔ dɨmasɨ kɨ gɨn lo, lo kɨ lo to pɨtɨ pɨtɨ ba ɓəy, Mari kɨ Magɨdala ɨsɨ aw dɔ ɓadɨ tɨ nɨngə, oo kadɨ mbal kɨ uti ta ɓadɨ ka kɨn, dəw uwə ɔr. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ə Mari a̰y ngɔdɨ, aw ɨngə Pɨyər əi kɨ nje ndo kare kɨ Jəju ndɨge, əl-de ə nə: «Uwəi Ɓaɓe ɔri-e ɓada, nɨngə jɨ gər lo kɨ ɨləi-e tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pɨyər əi kɨ nje ndo kɨ kare ka kɨn tḛḛi, ɨsɨ awi kɨ dɔ ɓadɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A̰yḭ-naa ngɔdɨ joo pu, nə nje ndo kɨ kare ka kɨn a̰y ngɔdɨ ɨtə Pɨyər, adɨ aw tḛḛ dɔ ɓadɨ tɨ kəte no̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lokɨ aw tḛḛ, ɨlə mbɔne, go̰ lo nɨngə, oo ta kɨbɨ je kɨ doləi nɨn ə a, nə ur me ɓe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pɨyər kɨ e goe tɨ, ḭ ya̰ne no̰o̰ re ɓa, ur me ɓe tɨ, oo ta kɨbɨ je kɨ doləi nɨn ə a, ");
INSERT INTO bjvNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","taa oo ta kɨbɨ kɨ ɨləi jam dɔ Jəju tɨ tɔ ə to. Ta kɨbe kɨn to naa tɨ kɨ əi je kɨ doləi nɨn kɨn al, nə dəw ɓɨndɨ adɨ to ya̰ne dangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Go tɨ, nje ndo kɨ kare kɨ re kəte ka kɨn, ur me ɓe tɨ tɔ, adɨ oo nḛ je kɨ kəmne nɨm, adɨ mene kadɨ e nḛ kɨ rɔjetɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","NGa nɨngə, bɨtɨ tḛḛ loe tɨ kɨn ka, tɨjə-de tɨ kadɨ Jəju a ḭ taa dan njé koy tɨ, təkɨ makɨtɨbɨ lə Luwə əl-n tae kəte kɨn, al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","E be ə, njé ndo je kɨ joo, təli ɨləi dɔde awi ɓe. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lokɨ njé ndo je awi, Mari a taga, kadɨ ɓadɨ tɨ ɓasi, a no̰. Lokɨ a no̰, ɨlə mbɔne go̰-n lo ɓe nɨn tɨ ɓa, ");
INSERT INTO bjvNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oo malayka je joo kɨ ɔi kɨbɨ kɨ nda, ə ɨsi lo tɨ kɨ kəte ɨləi nɨn Jəju tɨ. Kɨ kare ɨsɨ toe tɨ, kaw kɨ dɔe tɨ, ə e kɨ nungɨ ɨsɨ kaw kɨ njae tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","*Malayka je dəji-e əi nə: «Dəne, ra ban ə a no̰ ə?» Ə Mari ɨlə-de tɨ ə nə: «Ɔri Ɓaɓe ləm, nɨngə m-gər lo kɨ ɨləi-e tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lokɨ əl ta be nɨngə, ɨlə rətɨ ɓa, oo Jəju, nə gər kadɨ e Jəju al. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ə Jəju dəje ə nə: «Dəne, ra ban ə a no̰ ə? Ɨsɨ sangɨ na̰ ə?» Nɨngə Mari oo ə nə e nje ra kɨlə me ndɔr tɨ kɨ to no̰o̰ ka kɨn wa, adɨ əl-e ə nə: «Ɓam, re e ḭ ə ɔr-e ə, ɔjɨ-m lo kɨ ɨle tɨ, adɨ m-aw m-un-e.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jəju ɓar-e: «Mari!» Ə Mari yətɨ rɔne kɨ rɔe tɨ, un ndune kɨ taa, əl-e ə nə: «Rabuni!» kɨ ta ebɨrə, kɨ kɔr me nə «NJe ndo dɨje!» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lo kɨn tɨ, Jəju əl-e ə nə: «Ɔdɨ rɔm al, tadɔ m-aw dɔra̰ tɨ rɔ Bai tɨ al ɓəy. NGa nɨngə, kɨ ɓasɨne kɨn ɓa, aw rɔ ngakom je tɨ, əl-de təkɨ m-aw rɔ Bai tɨ kɨ e Bawsi tɔ kɨn, m-aw rɔ Luwə tɨ ləm kɨ e Luwə ləsi tɔ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ə Mari kɨ Magɨdala aw ɨngə njé ndo je əl-de ə nə: «M-o Ɓaɓe kɨ kəm!» Nɨngə əl-de ta je kɨ Jəju əl-e ka kɨn adɨ-de ooi. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","NDɔ dɨmasɨ tɨ wa no̰o̰ lo sɔlɔ, njé ndo je kawi-naa me kəy tɨ madɨ, nɨngə uti ta kəy mbukɨ dɔde tɨ, mbata ɓəli njé kun dɔ *Jɨpɨ je. Ə Jəju re, a taa dande tɨ, əl-de ə nə: «M-dəjɨ kadɨ lapɨya e səsi!» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɓa lo kɨn tɨ, tɔjɨ-de to do kɨ jie tɨ je, kade tɨ je adɨ-de ooi. Rɔ njé ndo je nəl-de ngay, lokɨ ooi Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jəju təl əl-de ɓəy ə nə: «M-dəjɨ kadɨ lapɨya e səsi! NGa nɨngə, təkɨ Bai ɨlə-m, mi ka m-ɨlə səsi tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɓa go ta je tɨ kɨn, Jəju to kə̰ə̰ne dɔ njé ndo je tɨ, ə əl-de ə nə: «Ɨtaai NDɨl Luwə mesi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dɨje kɨ a ɨyə̰i go majal je ləde kɔ, Luwə a ɨyə̰ go majal je ləde kɔ tɔ, ə njé kɨ a mbati kɨyə̰ go majal je ləde kɔ, Luwə a tɨdə majal je ləde dɔde tɨ ba tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lokɨ Jəju re rɔ njé ndo je tɨ kɨn, Tomasɨ kɨ ɓari-e NDɨgə, kɨ e kɨ kare dan njé ndo je tɨ e səde loe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ə ndəgɨ njé ndo je əli-e əi nə: «J-o Ɓaɓe kɨ kəmje.» Nə Tomasɨ əl-de ə nə: «Kɨn ə m-o to do po̰ytɨ kɨ ɓəi jie kɨn al nɨm, m-ɨlə ngon jim to po̰ytɨ tɨ kɨn al nɨm, taa m-ɨlə jim m-ɔdɨ-n to do nɨngə kɨ ɔsi kade kɨn al nɨm ə, m-a m-adɨ səsi mem al jagɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","NDɔ jijoo go tɨ, njé ndo je təli ɨngəi-naa me kəy tɨ ɓəy, nɨngə e kɨn Tomasɨ e səde ngata. Uti ta kəy mbukɨ dɔde tɨ, ə Jəju re, a taa dande tɨ, əl-de ə nə: «M-dəjɨ kadɨ lapɨya e səsi!» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nɨngə əl Tomasɨ ə nə: «Tomasɨ, ɨlə ngon jii lo kɨn tɨ, ə ɨgo̰ jim je kɨn oo, taa ɨlə jii ɔdɨ-n to do nɨngə kɨ kadɨm tɨ kɨn o tɔ. Onoi kadɨ mei nga̰, majɨ kadɨ adɨ mei.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lo kɨn tɨ no̰o̰, Tomasɨ əl Jəju ə nə: «Ɓaɓe ləm! Luwə Ləm!» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ə Jəju əl-e ə nə: «E koo kɨ o-m kɨ kəmi ne kɨn ə adɨ-n mei. Nɨngə adɨ m-əli m-adɨ ɨgər təkɨ njé rɔnəl je ə əi dɨje kɨ adi mede kɨ kanjɨ koo nḛ kɨ kəmde.» ");
INSERT INTO bjvNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jəju ra nḛ kɔjɨ je kɨ rangɨ ngay wa ɓəy ta kəm njé ndo je tɨ ləne, kɨ e kɨ ndangɨ me makɨtɨbɨ tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nə e je kɨn e kɨ ndangɨ-de be mba kadɨ adii mesi təkɨ Jəju e Kɨrɨsɨ kɨ Luwə mbəte, e NGon lə Luwə. Nɨngə lokɨ adi mesi kɨn ɓa a ɨngəi kajɨ kɨ bɨtɨ kɨ no̰ tɨ kɨ takule. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Go tɨ gogɨ, Jəju təl tḛḛ ɨngə njé ndo je ɓəy taa ba tɨ kɨ Tɨbərɨyadɨ. Rəbɨ kɨ tḛḛ ɨngə-n-de ə to kɨn: ");
INSERT INTO bjvNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","NDɔ madɨ, Sɨmo̰ Pɨyər nɨm, Tomasɨ kɨ ɓari-e NDɨngə nɨm, Natanɨyəl nɨm kɨ əi dɨje kɨ Kana tɨ kɨ Galile tɔ, ngan lə Jəbəde kɨ joo tɔ, njé ndo je lə Jəju kɨ rangɨ əi joo tɔ ɨsi naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ə Sɨmo̰ əl-de ə nə: «M-a m-aw baa kadɨ m-ndo̰ kanjɨ je.» Ɓa ndəge je əli-e əi nə: «Je ka j-a j-aw səi tɔ.» Nɨngə tḛḛi, ali me to tɨ awi, nə kondɔe tɨ kɨn, ngon kanjɨ kare ka uwəi al. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lokɨ lo ti, Jəju re a ta ba tɨ no̰o̰, nə njé ndo je gəri təkɨ e Jəju al. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ə Jəju əl-de ə nə: «NGan je, uwəi kanjɨ ndə̰y al a?» Ɓa ɨləi-e tɨ əi nə: «Jagɨ, ngon kanjɨ kare ka j-uwə al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nɨngə, Jəju əl-de ə nə: «Ɨləi bandɨ dam to tɨ, kɨ dɔ ji ko̰si tɨ kɨn, ə a uwəi kanjɨ je.» Ə lokɨ ɨləi bandɨ ɓa, bandɨ ɔy kanjɨ kɔy kɨ asi kadɨ ndɔri tḛḛi taga al. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Lo kɨn tɨ, nje ndo kɨ Jəju ndɨge əl Pɨyər ə nə: «E Ɓaɓe.» Ə lokɨ ta kɨ əl ə nə: «E Ɓaɓe», kɨn osɨ mbi Pɨyər tɨ taa par ə, Pɨyər ɨlə kɨbɨ ləne rɔne tɨ, tadɔ kəte a kɨ rɔne kare, nɨngə osɨ me man tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lo kɨ ai tɨ kɨn, e sa̰y al kɨ ngangɨ ba, ai asɨ kulə bi kare be par, adɨ ndəgɨ njé ndo je awi kɨ to ndə̰y ndə̰y kɨ ngangɨ ba tɨ, ndɔrii bandɨ kɨ kanjɨ rosɨ ka kɨn gode tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lokɨ uri nangɨ nɨngə, ooi por kɨ dəw ɨlə kanjɨ tɨ, taa mapa ka to no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jəju əl-de ə nə: «Ɨrəi kɨ kanjɨ je kɨ uwəi-de ka kɨn ne adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ə Sɨmo̰ Pɨyər al me to tɨ, ndɔr bandɨ kɨ kanjɨ rosɨ ka kɨn nangɨ. E kanjɨ je kɨ boy boy wa ə əi ɓu kɨ kutɨ mi gɨde mɨtə (153). Kɔrde wa kɨ to ɓəl kɨn nə, bandɨ gangɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jəju əl-de ə nə: «Ɨrəi usoi nḛ.» NGa nɨngə, dəw kare dan njé ndo je tɨ kɨ kadɨ dəjɨ Jəju ə nə: «Ḭ na̰ wa?» goto, tadɔ gəri majɨ kadɨ e Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jəju ɔtɨ rɔde tɨ, un mapa adɨ-de, nɨngə adɨ-de kanjɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lokɨ Jəju ḭ taa dan njé koy je tɨ kɨn, e tḛḛ kɨ ko̰ mɨtə ngata ə tḛḛ kɨ rɔ njé ndo je tɨ ləne kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Go nḛ kuso tɨ, Jəju dəjɨ Sɨmo̰ Pɨyər ə nə: «Sɨmo̰ kɨ ngon lə Jonasɨ, ɨndɨgɨ-m ɨtə njé je kɨ ɨsi kɨn a?» Ə Sɨmo̰ ɨle tɨ ə nə: «Oyo, Ɓaɓe, ɨgər kadɨ m-ndɨgi.» Nɨngə Jəju əl-e ə nə: «Ul batɨ je ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jəju təl dəjɨ Sɨmo̰ ɓəy kɨ ko̰ joo ə nə: «Sɨmo̰ kɨ ngon lə Ja̰, ɨndɨgɨ-m a?» Ə Sɨmo̰ ɨle tɨ ə nə: «Oyo, Ɓaɓe, ɨgər kadɨ m-ndɨgi.» Nɨngə Jəju əl-e ə nə: «Ul batɨ je ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jəju təl dəjɨ Sɨmo̰ ɓəy kɨ ko̰ mɨtə ə nə: «Sɨmo̰ kɨ ngon lə Ja̰, ɨndɨgɨ-m a?» Ɓa lo kɨn tɨ, me Pɨyər o̰-e dɔ təl tɨ kɨ Jəju təl dəje ɓəy kɨ ko̰ mɨtə ə nə: «Ɨndɨgɨ-m a?» kɨn, adɨ ɨle tɨ ə nə: «Ɓaɓe, ɨgər nḛ je pətɨ, ɨgər kadɨ m-ndɨgi.» Nɨngə Jəju əl-e ə nə: «Ul batɨ je ləm. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","NGa nɨngə, təkɨ rɔjetɨ, adɨ m-əli: dɔkagɨlo basai tɨ, ḭ wa ɨdɔɔ nda ɓədi tɨ, ə aw lo kɨ mei ndɨgɨ, nə dɔkagɨlo kɨ a ɓɨgə ɓa, a ɔy jii taa kadɨ dəw kɨ rangɨ ə a dɔɔ nda ɓədi tɨ, ə aw səi lo tɨ kɨ mei ndɨgɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta je kɨn Jəju əl be kadɨ tɔjɨ-n go rəbɨ koy kɨ Pɨyər a oy kadɨ ɨlə-n tɔjɨ dɔ Luwə tɨ. Go tɨ, Jəju əl-e ə nə: «Un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pɨyər ɨlə rətɨ gogɨ nɨngə, oo nje ndo kɨ Jəju ndɨge, e kɨ ndɔ kɨ, lo nḛ kuso tɨ, ɔy kɨ dɔ Jəju tɨ, dəje ə nə: «Ɓaɓe, na̰ ə a ɨləi ji dɨje tɨ ə?» ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lokɨ Pɨyər oo-e ɓa, dəjɨ Jəju ə nə: «Ɓaɓe, ə e kam, e ri ə a ra-e ə?» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ə Jəju əl Pɨyər ə nə: «Kɨn ə re m-ndɨgɨ kadɨ ɨsɨ kɨ dɔne taa bɨtɨ kadɨ tə m-təl m-re m-ɨnge-n ka, e kɨn ta ləi goto tɨ. Ḭ, ta ləi e ta kadɨ un gom par.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ta kɨn sane dan njé kadɨ-me je tɨ təkɨ nje ndo kam a oy al. Nə kɨ rɔjetɨ, kadɨ Jəju əl Pɨyər ə nə: «A oy al» kɨn, əl-e be al. Ta kɨ əl-e ɓa, əl-e ə nə: «Kɨn ə re m-ndɨgɨ kadɨ ɨsɨ kɨ dɔne taa bɨtɨ kadɨ tə m-təl m-re m-ɨnge-n ka, e kɨn ta ləi goto tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","E darɔ nje ndo-e ə wa kɨn ə ma najɨ dɔ nḛ je tɨ, ndangɨ-de me makɨtɨbɨ tɨ kɨn. NGa nɨngə jɨ gər kadɨ najɨ kɨ ma lie e ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jəju ra nḛ je kɨ rangɨ ngay wa ɓəy. Re dəw ə nə n-ɨndə tane wa nəm n-ndangɨ-de pətɨ me makɨtɨbɨ je tɨ ə, m-ga kadɨ dɔnangɨ wa kɨn pətɨ, makɨtɨbɨ je kɨn a ɨbə.");
INSERT INTO bjvNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Təwopɨl, me makɨtɨbɨ tɨ ləm kɨ dɔsa̰y, m-ndangɨ ta je kɨ ɔjɨ dɔ nḛ je kɨ Jəju ɨlə ngɨre ra je, ndo dɨje je. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nḛ je kɨ ra bɨtɨ tḛḛ-n me ndɔ tɨ kɨ Luwə un-e-n aw sie dɔra̰ tɨ. Nɨngə kəte ɓəy taa kadɨ aw dɔra̰ tɨ, Jəju mbətɨ njé kaw kɨlə je ləne, adɨ-de ndu-kun je ləne kɨ go rəbɨ lə NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Go koye tɨ, Jəju ɔjɨ rɔne njé kaw kɨlə je ləne. Ɔjɨ-de kɨ rəbɨ je kɨ dangɨ dangɨ kadɨ gəri təkɨ n-a kɨ dɔne taa. NDɔ kutɨ sɔ go tɨ nɨngə, tḛḛ hɔy kɨ rɔde tɨ əl-de ta dɔ ko̰ɓe tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","NDɔ kare kɨ ɨsɨ uso nḛ səde, Jəju əl-de kadɨ tḛḛi gɨdɨ ɓe bo Jorijaləm tɨ al. Nə kadɨ ngəmi bɨtɨ kadɨ Bawne adɨ-de kadɨ-kare kɨ un mɨndɨne dɔ tɨ kadɨ n-a n-ade kɨn ɓəy taa. Nɨngə əl-de ə nə: «E kadɨ-kare kɨ mi wa m-əl səsi tae kəte ngata. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ja̰ ra dɨje batəm me man tɨ, nə səi je, me ndɔ je tɨ kɨ ngay al ne ə, a rai səsi batəm me NDɨl Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","*NJé kaw kɨlə je lə Jəju kɨ kawi-naa rɔe tɨ dəji-e əi nə: «Ɓaɓe, e dɔkagɨlo tɨ kɨ ngɔsɨne wa kɨn ə a taa ko̰ɓe adɨ *Isɨrayəl a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ə əl-de ə nə: «E ta ləsi kadɨ ɨgəri dɔ kade ə se dɔ gangɨ lo je kɨ Bai ɔjɨ kɨ go lo ko̰ɓe tɨ ləne al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nə a ɨngəi tɔgɨ lokɨ NDɨl Luwə a re dɔsi tɨ. A təli njé ma najɨ ləm me ɓe bo Jorijaləm tɨ nɨm, dɔnangɨ Jude tɨ ba pətɨ nɨm, *Samari tɨ nɨm, ratata kɨ ta so̰y dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lokɨ Jəju əl-de ta je kɨn gɨne gangɨ nɨngə, ooi-e ɨsɨ aw kɨ taa me nəl tɨ. Nɨngə kɨl ndi re utɨ kəmde adɨ ooi-e al. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kəmde naa kɨ taa dɔra̰ tɨ, lo koo go Jəju lo kawe tɨ, nɨngə, dɨngəm je joo kɨ ɨləi kɨbɨ je kɨ nda bal bal tḛḛi hɔy kɨ rɔde tɨ, nɨngə əli-de əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«Dɨje kɨ Galile tɨ, mba ri ə ai a ɨgo̰i lo kɨ taa dɔra̰ tɨ be ə? Darɔ Jəju wa kɨ uni-e tasi tɨ awi sie dɔra̰ tɨ kɨn ə, a təl re təkɨ oi goe lo kawe dɔra̰ tɨ kɨn be tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Be ə njé kaw kɨlə je lə Jəju təli dɔ mbal kagɨ bɨni tɨ awi Jorijaləm tɨ gogɨ. MBal kagɨ bɨni kɨn e ɓasi kɨ ɓe bo Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lokɨ rəi tḛḛi Jorijaləm tɨ nɨngə, ali aw me kəy tɨ kare kɨ e dɔ made tɨ taa, lo kɨ rai tə lo kɨsɨde kəte kəte. Adɨ e Pɨyər nɨm, Ja̰ nɨm, Jakɨ əi kɨ Andɨre nɨm, Pɨlɨpɨ əi kɨ Tomasɨ nɨm, Batɨləmi əi kɨ Matɨye nɨm, Jakɨ kɨ ngon lə Alpe nɨm, Sɨmo̰ kɨ nje rɔ mbata ta kɨngə dɔ lə ɓe ləne nɨm, taa Judɨ kɨ ngon lə Jakɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Əi pətɨ, kɨ mede kɨ kare ba, kawi-naa nəm nəm mba kadɨ əli ta kɨ Luwə, naa tɨ kɨ dəne je madɨ. Mari kɨ ko̰ Jəju e dande tɨ nɨm taa ngako̰ Jəju je nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Me ndɔ je tɨ kɨn, njé kadɨ-me je kawi-naa asi ɓu kɨ kutɨ joo. Nɨngə Pɨyər ḭ taa dan ngakone je tɨ əl ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«NGakom je, sɔbɨ kadɨ nḛ kɨ NDɨl Luwə əl tae me Makɨtɨbɨ tɨ lə Luwə tɔl tane. Tadɔ NDɨl Luwə, əl ta kəte kɨ ta *Dabɨdɨ, ɔjɨ-n dɔ Judasɨ kɨ ɔr no̰ dɨje kɨ rəi uwəi Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasɨ e kɨ kare danje tɨ, nɨngə aw kɨ kɨlə ləne kɨ sɔbɨ dɔne kadɨ ra danje tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kɨ la kɨ adi-e mba kɨgə-n go ji kɨlə kɨ majal kɨ ra kɨn ə, Judasɨ aw ndogɨ-n lo ndɔr. Me ndɔr tɨ kɨ ndogɨ ka kɨn ə, ḭ taa osɨ tɨ, dɔe su kɨ nangɨ, me ndu adɨ tie ale mba dɔnangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Dɨje pətɨ kɨ dɔnangɨ Jorijaləm tɨ ooi ta kɨn. Be ə ɓari lo ndɔr ka kɨn kɨ ta ɓe ləde ə nə: “Akəldama”, kɔr me ta kɨn nə: “Lo ndɔr məsɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nɨngə ndangi me makɨtɨbɨ Pa je tɨ əi nə: “Kadɨ kəy lie e kɨ kɨyə̰ kɔ nɨm, Kadɨ dəw kare ka ɨsɨ me tɨ al nɨm,” Taa ndangi ɓəy əi nə: “Kadɨ dəw kɨ rangɨ un toe.” ");
INSERT INTO bjvNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Be ə, majɨ kadɨ jɨ mbəti dəw kare mbo̰ dɨje tɨ wa kɨ njɨyəi səje naa tɨ kɨ ndɔ je pətɨ kɨ Ɓaɓe Jəju aw-n səje nɨm təl-n səje nɨm wa kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ɨlə ngɨre dɔ batəm tɨ lə Ja̰, ratata tḛḛ-n dɔ ndɔ tɨ kɨ Luwə un-n Jəju taje tɨ awi sie dɔra̰ tɨ. Kadɨ dəw kare dande tɨ, e nje ma najɨ, naa tɨ səje təkɨ Jəju ḭ lo koy tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Lo kɨn tɨ, rəi kɨ dɨje joo ɔji-de, kɨ dɔsa̰y e Jɨsəpɨ kɨ ɓari-e nə Barsabasɨ, kɨ ɨndəi tɔe kɨ rangɨ nə Jusɨtusɨ, nɨngə kɨ ko̰ joo e Matɨyasɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nɨngə əli Ɓaɓe əi nə: «Ɓaɓe, ḭ ɨgər nga̰me dɨje pətɨ tɨgə, ə ɔjɨ-je se mbo̰ dɨje tɨ kɨ joo kɨn, e kɨ ra ə ɨmbəte wa? ");
INSERT INTO bjvNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","MBəte kadɨ un ta kɨlə ɓəə lə njé kaw kɨlə je kɨ Judasɨ ɨyə̰ tae ə aw lo tɨ ləne kɨ sɔbɨ dɔe kadɨ aw tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rai yukɨ, nɨngə yukɨ osɨ dɔ Matɨyasɨ tɨ, adɨ Matɨyasɨ ore kadɨ njé kaw kɨlə je kɨ dɔgɨ gɨde e kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lokɨ ndɔ nay Pa̰təkotɨ asɨ nɨngə, njé kadɨ-me je pətɨ kawi-naa lo kare ba. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ta naa tɨ no̰o̰, ka nḛ madɨ ḭ dɔra̰ tɨ, ɓa tə nəl bo kɨ ɨlə kɨ tɔgɨne kɨn be. Ka nḛ ka kɨn taa lo me kəy tɨ kɨ ɨsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","OOi nḛ je kɨ toi tə por ə ndone je tḛḛi bɨlɨm bɨlɨm be, tḛḛi, ka̰yḭ-naa dɔde tɨ kare kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","NDɨl Luwə rosɨ mede pətɨ, adɨ ɨləi ngɨrə kəl ndon ta je kɨ rangɨ kɨ dəw gər me al, kɨ go kɨndə tɨ kɨ NDɨl Luwə ɨndə-n tade tɨ kadɨ əli. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nɨngə me ndɔe je tɨ kɨn, *Jɨpɨ je kɨ njé ɓəl Luwə, ḭḭ kɨ dɔ ɓe je kɨ dangɨ dangɨ kɨ dɔnangɨ tɨ ne pətɨ, rəi kawi-naa Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Lokɨ ooi ka nḛ kɨn nɨngə, a̰yḭ-naa ngɔdɨ rəi kawi-naa, kosɨ kosɨ, ɓəl rade tadɔ na̰ na̰, dande tɨ, oo dɔ ndu njé kadɨ-me je kɨ ɨsɨ əli ta kɨ ndon ta ɓe ləne. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nḛ kɨn ətɨ-de ɓəl ngay adɨ ndɨlde a̰y ur kakɨ, ooi kadɨ e nḛ kɨ rɔjetɨ al, adɨ əli əi nə: «Dɨje kɨ ɨsɨ əli ta kɨn pətɨ əi dɨje kɨ ḭ Galile tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","nga ban be ə na̰ na̰ danje tɨ, oo ta kɨ tḛḛ tade tɨ kɨ ndon ta ɓe ləne ə? ");
INSERT INTO bjvNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Je dɨje kɨ Partəjɨ tɨ, kɨ Medɨ tɨ, kɨ Elamɨtɨ tɨ, kɨ njé kḭ dɔnangɨ Mejopotami tɨ nɨm, kɨ Jude tɨ nɨm, Kapadosɨ tɨ nɨm, taa Po̰ tɨ kɨ e ngon ɓe kɨ dɔnangɨ Aji tɨ nɨm, ");
INSERT INTO bjvNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pɨrɨji tɨ nɨm, Pampɨli tɨ nɨm, Ejɨpɨ tɨ, kɨ dɔnangɨ Lɨbi tɨ kɨ e ɓasi kɨ Sɨrən, ə se njé kḭ dɔnangɨ Rom tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Je pətɨ je Jɨpɨ kojɨ je kɨ Jɨpɨ təl je. J-ḭ Kɨrətɨ tɨ kɨ Arabi tɨ. Be ka, joo dɔ ndude kɨ əli ta kɨ ndon ta ɓe ləje, ɔjɨ dɔ nḛ je kɨ ətɨ ɓəl kɨ Luwə ra.» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Əi pətɨ ndɨlde ay ur kakɨ adɨ gəri ta wa kɨ kadɨ əli al, nɨngə əli-naa mbo̰de tɨ əi nə: «Kɔr me nḛ kɨ ra nḛ kɨn nə ri ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nə njé kɨ na̰ je kogi dɔ njé kəl ndon ta je tɨ kɨ dangɨ dangɨ kɨ dəw gər dɔe al, əi nə: «E kasɨ nju ə a̰yḭ-naa ngay ə rade.» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pɨyər ḭ a taa kɨ ndəgɨ njé kaw kɨlə je kɨ dɔgɨ gɨde e kare, nɨngə un ndune kɨ taa əl ta kosɨ dɨje ə nə: «Uri mbisi majɨ oi dɔ ta ləm səi *Jɨpɨ je, kɨ səi pətɨ kɨ ɨsɨ Jorijaləm tɨ ne. Sɔbɨ kadɨ ɨgəri nḛ kɨ ɨsɨ ra nḛ kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Dɨje madɨ dansi tɨ ooi kadɨ e kasɨ ə ra dɨje kam. Nə Jagɨ kasɨ rade al! J-a sḭ kadɨ nda tɨ ɓəy! ");
INSERT INTO bjvNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nə ngɔsɨne nḛ kɨ ndɔ kɨ nje kəl ta kɨ ta Luwə tɨ Juwəl əl tae ka kɨn ə ra nḛ: ");
INSERT INTO bjvNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nḛ je kɨ Luwə əl tae kadɨ a rai nḛ me ndɔ je tɨ kɨ dɔbəy tɨ ka ə toi kɨn: M-a m-ɨlə kɨ NDɨlm dɔ dɨje tɨ pətɨ. NGansi je kɨ dɨngəm kɨ njé kɨ dəne a təli njé kəl ta kɨ ta Luwə tɨ, Basa je ləsi a ooi nḛ je me ndɨl tɨ, Ɓɨgə je ləsi, a ooi nḛ je kɨ to lo ɓɔyɔ tɨ me ni tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oyo me ndɔ je tɨ kɨn, M-a m-ɨlə kɨ NDɨlm dɔ ngan njé kɨlə je tɨ ləm kɨ dɨngəm kɨ njé kɨ dəne. A əi njé kəl ta kɨ tam tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","M-a m-ra nḛ je kɨ dəw asɨ ra al me dɔra̰ tɨ taa nu, Nɨngə dɔnangɨ tɨ ne, m-a m ra nḛ kɔjɨ je kɨ ətɨ ɓəl, Adɨ e: məsɨ nɨm, por nɨm, sa kɨ su luy luy nɨm tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kəte ɓəy taa kadɨ ndɔ kɨ bo ngay, kɨ rosɨ kɨ tɔɓa lə Ɓaɓe kɨn a re, Lo kɨ kada a təl lo kɨ ndul, nɨngə nay a təl məsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɨngə me ndɔ tɨ kɨn, dɨje pətɨ kɨ ɓai tɔ Ɓaɓe a ɨngəi kajɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«Səi *Isɨrayəl je, uri mbisi majɨ oi ta kɨ m-a m-əl səsi. Ɨgəri pətɨ kadɨ Jəju kɨ Najarətɨ, dɨngəm kɨn kɨ Luwə ɔje kɨ taga kadɨ n-ndɨge, ə Luwə ra nḛ je kɨ dəw asɨ ra al kɨ nḛ kɔjɨ je kɨ ətɨ ɓəl kɨ takule dansi tɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dɨngəm kɨn, ɨləi-e jisi tɨ kɨ go ndu-kun tɨ kɨ Luwə un, ə se kɨ go kɔjɨ ta ra tɨ lie kɨ to kəte. Nɨngə səi adi dɨje kɨ gəri Luwə al tɔli-e kɨ rəbɨ ɓə kɨ ɓəi-e kagɨ-dəsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nə Luwə gangɨ kulə yo rɔe tɨ kɔ ade ḭ lo koy tɨ, tadɔ koy aw kɨ tɔgɨ kadɨ uwe gɨn tɔgɨne tɨ ɓe nɨn tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","*Dabɨdɨ əl ta ɔjɨ-n dɔe ə nə: “M-o Ɓaɓe kɨ dɔkagɨlo je pətɨ no̰m tɨ, Tadɔ e dɔ ji kom tɨ mba kadɨ m-tḛḛ m-osɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","E mbata kɨn ə rɔnəl rosɨ mem adɨ m-osɨ-n pa tɔ. Be ə, ɓe nɨn tɨ ka, darɔm a ɔr kə̰ə̰ kɨ kɨndə me dɔ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ḭ Ɓaɓe, a ɨyə̰-m kɔ koo al, A ɨyə̰ ɓəə ləi kɨ a dɔ njane tɨ ade ndum ɓada al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ḭ ə ɔjɨ-m rəbɨ kadɨ m-təl m-ɨsɨ-n kɨ dɔm taa, Nɨngə a adɨ-m rɔnəl me kei naa tɨ səm.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pɨyər təl əl ɓəy ə nə: «NGakom je, adɨ m-əl səsi ta kɨ rɔjetɨ: Kaje Dabɨdɨ oy təkɨ rɔjetɨ adɨ dɨbi-e. Dɔ ɓade to danje tɨ ne bɨtɨ ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","E nje kəl ta kɨ ta Luwə tɨ, ə gər kadɨ Luwə un mɨndɨne ade kɨ kɨbɨ rɔ kadɨ n-a n-adɨ dəw kare kɨ gɨn ka tɨ lie a o̰ ɓe toe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dabɨdɨ gər nḛ kɨ a ra nḛ lo ti tɨ, adɨ əl ta kḭ lo koy tɨ lə Kɨrɨsɨ kɨn kəte. E ta lie ə Dabɨdɨ ə nə Luwə a ɨyḛ lo kɨ koo tɨ al, taa a ɨyə̰ darɔe adɨ ndum ɓe nɨn tɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jəju kɨ m-ɨsɨ m-əl ta lie kɨn, Luwə ade ḭ dan njé koy je tɨ, j-əi pətɨ jɨ gəri majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Go tɨ nɨngə, Luwə un-e aw sie dɔra̰ tɨ adɨ ɨsɨ dɔ ji ko̰e tɨ. Nɨngə ngɔsɨne Luwə ade NDɨlne təkɨ un-n mɨndɨne. NDɨl kɨn ə, Luwə ɓukɨ dɔje tɨ, təkɨ oi ngɔsɨne kɨ kəmsi je, kɨ mbisi je kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Təkɨ rɔjetɨ, Dabɨdɨ aw dɔra̰ tɨ al, nə əl ə nə: “Ɓaɓe əl Ɓaɓe ləm ə nə: ‹Ɨre ɨsɨ dɔ ji kom tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ratata kadɨ m-ɨlə njé ba̰ je ləi gɨn tɔgi tɨ›”. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","E be ə, rɔ Jəju wa kɨ ɨɓəi-e kagɨ-dəsɨ tɨ kɨn ə, Luwə ade e Ɓaɓe nɨm, Kɨrɨsɨ nɨm tɔ. E kɨn ə e nḛ kɨ sɔbɨ kadɨ dɨje pətɨ kɨ Isɨrayəl tɨ gəri majɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lokɨ dɨje ooi ta kɨn nɨngə, mede ole wutɨ wutɨ adɨ dəji Pɨyər əi kɨ ndəgɨ njé kaw kɨlə je əi nə: «NGako̰je je, e ri ə kadɨ jɨ ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ə Pɨyər təl əl-de ə nə: «Ɨyə̰i rəbɨ nḛ rasi je kɨ majal kɔ, nɨngə kadɨ dəw kɨ ra dansi tɨ adɨ rai-e batəm me tɔ Jəju Kɨrɨsɨ tɨ, mba kadɨ majal je ləsi e kɨ kɨyə̰ go kɔ. Ɓa a ɨngəi NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Təkɨ rɔjetɨ, kun mɨndɨ lə Luwə e kɨ mbata ləsi nɨm, mbata lə ngansi je nɨm, kɨ mbata dɨje kɨ ɨsi sa̰y nɨm. Sɔbɨ dɔ dɨje pətɨ kɨ Ɓaɓe Luwə ləje a ɓar-de.» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pɨyər əl-de ta je kɨ rangɨ ngay go tɨ ɓəy mba kadɨ ma-n najɨ, nɨngə ɨlə dɨngəm mede tɨ ə əl-de ə nə: «Ɨgangi-naa kɨ gɨn dɨje kɨ majal kɨ ɓone kɨn, mba kadɨ Luwə ajɨ-n səsi.» ");
INSERT INTO bjvNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dɨje pətɨ kɨ taai ta lə Pɨyər, rai-de batəm. NDɔe tɨ ka kɨn, dɨje asi dɨbɨ mɨtə rəi orəi kadɨ njé kadɨ-me je kɨ kəte. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ɨlə ngɨre dɔkagɨloe tɨ kɨn, rəi nəm nəm mba koo dɔ nḛ ndo lə njé kaw kɨlə je nɨm, lo ra madɨ-naa tɨ nɨm, lo tətɨ mapa tɨ nɨm, ta lo kəl ta tɨ kɨ Luwə nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","*NJé kaw kɨlə je rai nḛ je kɨ dəw asɨ ra al kɨ nḛ kɔjɨ je kɨ ətɨ ɓəl ngay adɨ dɨje pətɨ ɨsi kɨ ɓəl mede tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","NJé kadɨ-me je ɨndəi rɔde naa tɨ kare ba ə kawi nḛ kɨngə je ləde dɔ-naa tɨ kare ba tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Gati kɨ nḛ kɨngə je kɨ nḛ majɨ je ləde ə ləbi-naa lae kɨ go nḛ ge tɨ lə dəw kɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","NDɔ je kare kare pətɨ, kɨ me kɨ kare ba, ɨngəi-naa me kəy tɨ lə Luwə. Nɨngə awi kɨ me kəy je tɨ lənaa usoi nḛ kuso lə Ɓaɓe nɨm, taa usoi nḛ je ləde kɨ rɔnəl nɨm, kɨ me kɨ sɔl lɔm lɔm. ");
INSERT INTO bjvNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Osi pa je ɨləi tɔjɨ dɔ Luwə tɨ, nɨngə dɨje pətɨ ndɨgi ta ləde tɔ. NDɔ je kare kare pətɨ, Ɓaɓe adɨ kɔr dɨje kɨ ajɨ-de, re dɔ made tɨ par par. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","NDɔ kare Pɨyər əi kɨ Ja̰ ɨsɨ awi kəy kaw-naa tɨ mba kəl ta kɨ Luwə dɔ kadɨ tɨ kɨ mɨtə kɨ lo sɔlɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dɔkagɨloe tɨ kɨn ə dɨje awi kɨ dəw kɨ njae oy lo koje tɨ nu, ɨndəi-e ta kəy kaw-naa tɨ. Dəw ka kɨn, ndɔ je kare kare pətɨ, a ɨndəi-e ta kəy kaw-naa tɨ kɨ ɓari-e nə: «Ta Kəy kɨ NDole». Ɨndəi-e mba kadɨ kɔy nḛ dɨje kɨ ɨsɨ uri kəy kaw-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lokɨ oo Pɨyər əi kɨ Ja̰ kɨ ɨsɨ uri kɨ kəy kaw-naa tɨ nɨngə, kɔy-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pɨyər əi kɨ Ja̰ uri kəmde kɨ dɔe tɨ, nɨngə Pɨyər əl-e ə nə: «Ɨgo̰-je ne!» ");
INSERT INTO bjvNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","NJe nja koy go̰-de, ga mene tɨ kadɨ n-a nɨngə nḛ madɨ jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nə Pɨyər əl-e ə nə: «M-aw kɨ la al nɨm, kɨ ɔr al nɨm kadɨ m-adi. Nə nḛ kɨ m-aw jim tɨ e tɔgɨ Jəju Kɨrɨsɨ. Be ə kadɨ-me tɔ Jəju Kɨrɨsɨ kɨ Najarətɨ tɨ, ḭ taa ə njɨyə!» ");
INSERT INTO bjvNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pɨyər uwə taji ko̰e, ɓa un-e kɨ taa. Ta naa tɨ no̰o̰ par ə njae je kɨ gul njae je təli toi majɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ḭ bal a taa ə ɨlə ngɨrə njɨyə. Aw səde naa tɨ kəy kaw-naa tɨ. Tḭ bal kɨ rɔnəl nɨm ɨlə tɔjɨ dɔ Luwə tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Dɨje pətɨ ooi-e lo njɨyə tɨ nɨm, lo kɨlə tɔjɨ dɔ Luwə tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Dɨje gəri-e majɨ kadɨ e nje mətɨ kɨ kəte e nje kɨsɨ ta kəy kaw-naa tɨ kɨ ɓari-e nə: «Ta Kəy kɨ NDole», ɨsɨ kɔy nḛ wa ka am. Lokɨ dɨje ooi nḛ kɨ tḛḛ dɔe tɨ kɨn nɨngə, ndɨlde a̰y ur kakɨ adɨ ɓəl rade ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","NJe nja koy ka kɨn ɨyə̰ go Pɨyər əi kɨ Ja̰ al. Nḛ kɨn ra adɨ ndɨl dɨje pətɨ a̰y ur kakɨ. Be ə, dɨje pətɨ a̰yḭ-naa ngɔdɨ kawi-naa kɨ dɔde tɨ dɔde tɨ lo tɨ kɨ ɓari-e nə: «Pal lə Salomo̰». ");
INSERT INTO bjvNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lokɨ Pɨyər oo nḛ kɨn nɨngə, əl kosɨ dɨje ə nə: «NGan *Isɨrayəl je, ban ə nḛ kɨ ra nḛ kɨn ətɨ səsi ɓəl kədɨ be ə? Ban ə uri kəmsi kɨ dɔje tɨ tə nḛ kɨ e je wa kɨ tɔgɨje, ə se e kɨ takul kaw kɨ j-aw kɨ ɓəl Luwə meje ə j-adɨ-n dɨngəm kam njɨyə-n be ə? ");
INSERT INTO bjvNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jagɨ, e Luwə lə *Abɨrakam, lə *Isakɨ, lə *Jakobɨ, Luwə lə kaje je ə ɨlə tɔjɨ dɔ ɓəə kɨlə tɨ ləne Jəju, kɨ ɨləi-e ji *Pɨlatɨ tɨ, Pɨlatɨ un ndune kadɨ n-ɨle taa, nə səi ɨmbati. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Oyo, səi ɨnaji ta gər nje kay njay kɨ nje ra nḛ kɨ dana. Nɨngə ɨdəji kadɨ ɨləi dəw kɨ nje tɔl dɨje taa toe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","E be ə, adɨ tɔli e kɨ e nje kadɨ dɨje ɨsi kɨ dɔde taa. Nə Luwə ade ḭ dan njé koy je tɨ, j-əi pətɨ jɨ gəri majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","E mbata kadɨ kɨ j-adɨ meje Jəju kɨn ə, tɔgɨ kɨ to me tɔe tɨ, adɨ tɔgɨ dɨngəm kɨ oi-e, taa ɨgəri-e kɨn, kadɨ ḭ a-n taa. Oyo, kadɨ-me kɨ tɔge to, kɨ takul Jəju, adɨ dɨngəm kɨn rɔ nga kɨ rɔjetɨ, e nḛ kɨ ra nḛ ta kəmsi tɨ pətɨ adɨ oi ne. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","NGɔsɨne ngakom je, m-gər majɨ ngay kadɨ nḛ kɨ ɨrai kɨn, e kɨ go gər-e tɨ al, səi je kɨ njé kɔr no̰si je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nə, e kɨ rəbɨ kɨn ə, Luwə tɔl-n ta nḛ kɨ ɨlə mbḛ kəte kɨ takul njé kəl ta je kɨ tae tɨ pətɨ ə nə: Kɨrɨsɨ kɨ n-un ndune kadɨ n-a n-ɨle, a ɨngə ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","NGɔsɨne, ɨyə̰i go rəbɨ njɨyəsi je kɨ majal kɔ, ə təli ɨrəi rɔ Luwə tɨ mba kadɨ ɨyə̰-n go majal je ləsi kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nɨngə Ɓaɓe a adɨ səi dɔkagɨlo kɔr kə̰ə̰, a ɨlə kɨ e kɨ ɨndə dɔe naa tɨ kəte tə Kɨrɨsɨ, adɨ e Jəju, adɨ səi. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nə ngɔsɨne kɨn, sɔbɨ kadɨ Jəju ɨsɨ dɔra̰ tɨ, bɨtɨ kadɨ Luwə təl nḛ je pətɨ kɨ dɔnangɨ tɨ kɨ sɨgɨ gogɨ, təkɨ ɨlə-n mbḛ me ɓal je tɨ kɨ man, kɨ takul njé kəl ta je kɨ tae tɨ kɨ ayi njay. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Be ə, *Mojɨ ə nə: “Ɓaɓe Luwə ləsi a adɨ nje kəl ta kɨ tae tɨ, kɨ to tə mi be, a ḭ dan ngako̰si je tɨ, kɨ mbata ləsi, a oi dɔ ta je pətɨ kɨ a əl səsi. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dəw kɨ mbatɨ təl rɔne go ta tɨ kɨ nje kəl ta kɨ ta Luwə tɨ kɨn a əl nɨngə, Luwə a tuje kɔ dan dɨje tɨ ləne kɨ koy.” ");
INSERT INTO bjvNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","*NJé kəl ta je kɨ ta Luwə tɨ pətɨ, ɨlə ngɨre dɔ Samɨyəl tɨ nu kɨ njé re goe tɨ, əli ta dɔ dɔkagɨlo tɨ kɨ jisi me tɨ ɓone kɨn kəte. ");
INSERT INTO bjvNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Səi, ə səi dɨje kɨ ta kɨ Luwə əl kɨ ta njé kəl ta je kɨ tae tɨ kɨn sɔbɨ dɔsi, taa kun mɨndɨ kɨ Luwə un adɨ kaje je lokɨ un ndune adɨ Abɨrakam kɨn sɔbɨ dɔsi tɔ. Luwə un mɨndɨne ə nə: “Gɨn kojɨ je kɨ dɔnangɨ tɨ ne pətɨ a ɨngəi ndu kɨ tɔr dɔ tɨ kɨ takul gɨn ka ləi.” ");
INSERT INTO bjvNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","E kɨ mbata ləsi kəte, ə Luwə tḛḛ-n kɨ ɓəə ləne, ɨle adɨ səsi mba kadɨ njangɨ dɔsi, kɨ takul ra kɨ ra adɨ na̰ na̰ ɨyə̰ go rəbɨ njɨyə je ləne kɨ majal kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lokɨ Pɨyər əi kɨ Ja̰ ɨsɨ əli ta kosɨ dɨje tə kəl ba ɓəy ə, njé kɨjə nḛ məsɨ kadɨ-kare je kɨ madɨ nɨm, kɨ bo kɨ dɔ kəy kaw-naa tɨ nɨm ta kɨ dɨje madɨ kɨ mbo̰ ɓutɨ tɨ lə *Sadusɨ je, tḛḛi kɨ rɔde tɨ hɔy. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wongɨ ra njé kɔr no̰ *Jɨpɨ je ngay mbata ooi Pɨyər əi kɨ Ja̰ ɨsɨ ndoi nḛ kosɨ dɨje, nɨngə əli-de əi nə: «Təkɨ Jəju ḭḭ-n lo koy tɨ wa kɨn ə, njé koy je ka a ḭḭ lo koy tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Uwəi-de ɨləi-de kəy dangay tɨ ratata lo ti, tadɔ lo sɔl ngata, adɨ lo kadɨ gangi ta dɔde tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nɨngə mbo̰ njé je tɨ kɨ ooi ta ləde, ngay je dande tɨ adi mede. Be ə, ra adɨ kɔr dɨngəm je re dɔ made tɨ adɨ asɨ dɨbɨ mi kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lo ti dɔ tɨ nɨngə, njé kɔr no̰ Jɨpɨ je nɨm, ngatɔgɨ je nɨm ta njé ndo ndu-kun je nɨm, kawi-naa me ɓe bo tɨ kɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Lo kaw-naa tɨ kɨn, An kɨ e kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je e tɨ no̰o̰, taa Kayɨpɨ nɨm, Ja̰ nɨm, Aləgɨjandɨr kɨ ndəgɨ dɨje pətɨ kɨ me kəy tɨ lə nje kɨjə nḛ məsɨ kadɨ-kare tɨ kɨ bo ka kɨn nɨm ka əi no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Adi rəi kɨ Pɨyər əi kɨ Ja̰ no̰de tɨ kɨ no̰ njé kaw-naa je tɨ, ɓa dəji-de ta əi nə: «Kɨ tɔgɨ kɨ ḭ ra, ə se me tɔ na̰ tɨ ə ɨrai nḛ kɨn ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nɨngə Pɨyər, NDɨl Luwə rosɨ mee, adɨ əl-de ə nə: «Səi njé ko̰ɓe je kɨ ngatɔgɨ je, ");
INSERT INTO bjvNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","dəji-je ta ɓone ɔjɨ dɔ nḛ kɨ majɨ kɨ jɨ ra kɨ dəw kɨ njae oy kɨ kujɨ nḛ kɨ jɨ ra ə ɨngə-n rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Majɨ kadɨ səi pətɨ ɨgəri ay njay, taa dɨje pətɨ kɨ *Isɨrayəl tɨ ka, kadɨ gəri majɨ tɔ. E me tɔ Jəju Kɨrɨsɨ kɨ Najarətɨ tɨ ə jɨ ra-n nḛ kɨn. E kɨ takul Jəju wa kɨ ɓəi-e dɔ kagɨ-dəsɨ tɨ ə Luwə ade ḭ taa dan njé koy je tɨ wa kɨn ə, dɨngəm kɨn a-n ta no̰si tɨ, kɨ rɔ kɨ nga. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","E mbal kɨ səi njé ra kəy je ɨmbati-e, nə e ə təl mbal kɨ ndae ɨtə made je pətɨ, e mbal kɨ nje kadɨ tɔgɨ kəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kajɨ e me tɔe tɨ kɨ karne ba. Tɔ kɨ rangɨ kɨ Luwə adɨ dəw dɔnangɨ tɨ ne mbo̰ dɨje tɨ kɨ mba kadɨ j-ɨngəi kajɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","NDɔjɨ njé gangɨ ta je kɨ kɨ bo lə Jɨpɨ je ngay lokɨ oi Pɨyər əi Ja̰ əli ta kɨ kanjɨ ɓəl, tadɔ gəri-de kadɨ əi dɨje kɨ kare kɨ kanjɨ nḛ ndo. Nə ke ə gəri kadɨ əi dɨje kɨ əi naa tɨ kɨ Jəju mari nu. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nə lokɨ ooi dɨngəm kɨ ngai-e ka kɨn a gədɨde tɨ nɨngə, gəri lo ta kɨ kadɨ əli-de al. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Be ə uni ndude adi Pɨyər əi kɨ Ja̰, taa dɨngəm ka kɨn nɨm kadɨ tḛḛi taga, nɨngə naji-naa ta mbo̰de tɨ ə əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Ri ə j-a rai kɨ dɨje kam ə? Tadɔ rai nḛ kɔjɨ kɨ ətɨ ɓəl kɨ to ndalo tɨ ay njay adɨ dɨje kɨ Jorijaləm ooi poye. Lo kadɨ jɨ naji goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nə ke ə kadɨ poy ta kɨn aw kɨ kəte kəte mbo̰ dɨje tɨ al ngata. Adɨ j-ɨləi jije kəmde tɨ kadɨ kaw kɨ kəte no̰o̰ kam, əli dəw madɨ ta kɨ tɔ Jəju al ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Go ta je tɨ kɨn, awi kɨ Pɨyər əi kɨ Ja̰ kəy gogɨ ə ɔgi-de kɨ tɔgɨde kadɨ əli ta ə se ndoi nḛ kɨ tɔ Jəju al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nə Pɨyər əi kɨ Ja̰ əli-de əi nə: «Əli-je adɨ joo, se e go rəbe tɨ, ta kəm Luwə tɨ, kadɨ jɨ təl rɔje go ta tɨ ləsi yo ə j-ɨyə̰ ta lə Luwə wa? ");
INSERT INTO bjvNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kɨ ɔjɨ dɔje, j-a j-asɨ kutɨ taje dɔ nḛ tɨ kɨ j-o kɨ kəmje nɨm, kɨ mbije nɨm kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lokɨ ɨləi jide kəmde tɨ kɨ ko̰ joo ɓəy nɨngə, ɨyə̰i-de adɨ awi. Təkɨ rɔjetɨ, ɨngəi nḛ madɨ rɔde tɨ kɨ asɨ kuwə-n-de dangay tɨ al, tadɔ dɨje pətɨ pɨti Luwə mba nḛ kɨ ra nḛ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɓal dɨngəm kɨ ɨngə rɔ nga kɨ takul nḛ kɔjɨ kɨ ətɨ ɓəl kɨn, ɨtə kutɨ sɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Go kɨyə̰-de tɨ, Pɨyər əi kɨ Ja̰ awi ɨngəi madɨde je kɨ njé kadɨ-me je, ɔri-de poy nḛ je pətɨ kɨ kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ ngatɔgɨ je əli-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lokɨ madɨde je ooi ta ləde gɨne gangɨ ngata nɨngə, pətɨ kɨ me kɨ kare, əli ta kɨ Luwə əi nə: «Ɓaɓe, ḭ ə ɨra dɔra̰ kɨ dɔnangɨ, taa ɨra ba bo kɨ nḛ je pətɨ kɨ me tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","E ḭ ə adɨ NDɨli əl ta kɨ ta kaje *Dabɨdɨ kɨ ɓəə ləi ə nə: “Gɨn ɓe je kɨ dangɨ dangɨ to̰i rɔ kɨ ndangɨ kare be. Taa kɔjɨ ta ra je ləde to rɔde tɨ kare! ");
INSERT INTO bjvNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","NGar je kɨ dɔnangɨ tɨ ne ɨndəi dɔ rɔde dana mba kaw rɔ, NJé ko̰ɓe je ɨndəi rɔde naa tɨ, ɔsi ta Ɓaɓe kɨ dəw lie kɨ mbəte tə NGar”. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Təkɨ rɔjetɨ, e me ɓe bo tɨ kɨn ə, *Erodɨ əi kɨ Po̰sɨ *Pɨlatɨ, naa tɨ kɨ gɨn ɓe je kɨ dangɨ dangɨ kɨ ngan *Isɨrayəl je ɨndəi rɔde naa tɨ ɔsi ta ɓəə kɨlə ləi kɨ ay njay, kɨ e Jəju kɨ ɨmbəte tə Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nḛ je ləde kɨ rai kɨn, e tɔl ə tɔli ta kɔjɨ ra je ləi pətɨ kɨ ɔjɨ kəte, kɨ tɔgi, me ndɨgɨ tɨ ləi. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ɓasɨne Ɓaɓe, oo jide kɨ ɨsɨ ɨləi kəmje tɨ kadɨ ɨndəi je ɓəl tɨ kɨn! Adɨ ɓəə je ləi tɔgɨ kadɨ ɨləi mbḛ ta ləi kɨ me kɨ ti katɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nɨngə, kadɨ ɔjɨ tɔgi me tɔ ɓəə kɨlə tɨ ləi kɨ ay njay Jəju, kadɨ njé mo̰y je ɨngəi rɔ nga nɨm, taa kadɨ nḛ kɔjɨ je kɨ nḛ je kɨ dəw asɨ ra al rai nḛ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lokɨ tai kə̰ə̰ ta kəl ta tɨ kɨ Luwə nɨngə, dɔnangɨ yəkɨ yɨkɨti yɨkɨti gɨn njade tɨ, lokɨ kɨ kawi-naa tɨ. Ɓa NDɨl kɨ kay njay rosɨ mede pətɨ adɨ ɨləi mbḛ ta lə Luwə kɨ rɔ kɨ tḭ katɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","NJé kadɨ-me je pətɨ ɨndəi rɔde naa tɨ kɨ nga̰me kɨ kare kɨ gɨr ta kɨ kare. Dəw kare kɨ ɨndə gune kɨ nḛ kɨngə ləne kɨ sɔbɨ dɔne goto, nḛ je pətɨ e ya̰de. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kɨ tɔgɨ kɨ ətɨ ɓəl ngay ə njé kaw kɨlə je mai najɨ kḭ lo koy tɨ lə Ɓaɓe Jəju. Nɨngə, kare kare pətɨ, Luwə jangɨ dɔde jangɨ dɔ kɨ ətɨ ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Be ə dəw kare dande tɨ kɨ nḛ to rɔe goto. Tadɔ njé je kɨ ay kɨ lo ndɔr je kɨ kəy je, uni gati ə rəi kɨ lae, ");
INSERT INTO bjvNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","adi njé kaw kɨlə je. Nɨngə njé kaw kɨlə je ləbi la ka kɨn dande tɨ pətɨ, ɓa na̰ na̰ ɨngə kɨ go nḛ ge je tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Dəw madɨ kare kɨ tɔe nə Jɨsəpɨ, kɨ e gɨn kojɨ tɨ lə *Ləbi, kɨ dɔnangɨ Sɨpɨr tɨ, kɨ njé kaw kɨlə je ɨndəi tɔe nə Barnabasɨ, kɔr me nə: «Dəw kɨ nje kɨlə dɨngəm me dɨje tɨ,» ");
INSERT INTO bjvNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","e ka, aw kɨ lo ndɔr, ə un lo ndɔr ləne ka kɨn gatɨ-n, ə re kɨ lae adɨ njé kaw kɨlə je. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dɨngəm madɨ kare kɨ tɔe nə Ananɨyasɨ əi kɨ dəne ləne Sapɨra, gati kɨ nḛ kɨngə ləde kare tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananɨyasɨ əi kɨ dəne ləne Sapɨra ɨndəi ndude naa tɨ, ɓɔyɔi nusɨ la, ə awi kɨ ndəge adi njé kaw kɨlə je. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pɨyər əl-e ə nə: «Ananɨyasɨ, ra ban ə ɨyə̰ *Sata̰ adɨ ur mei tɨ bore be ə? Ɔr nusɨ la lo ndɔr ləi ɨngəm, ə əl ta kɨ ngom NDɨl kɨ kay njay! ");
INSERT INTO bjvNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ri ə ɔgi kadɨ ɨngəm nḛ kɨngə ləi ə? A re gatɨ-n ə bəlme ka, ri ə ɔgi kadɨ la kɨ ɨngə kɨn, ɨra-n nḛ kɨ mei ge ə? Nḛ kɨ ɨga mei tɨ kɨn e nḛ kɨ majal. E dɨje ə əl-de ta kɨ ngom al, nə e Luwə ə əl-e ta kɨ ngom.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lokɨ Ananɨyasɨ oo ta kɨn par ə, osɨ nangɨ, oy. Dɨje pətɨ kɨ ooi poy ta kɨn, ɓəl ra-de ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Basa je rəi ragi nɨne, ɓa uni-e, awi dɨbi-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Asɨ ngɨrə kadɨ mɨtə go tɨ, dəne lie re ur kəy kɨ kanjɨ kadɨ gər nḛ kɨ ra nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pɨyər dəje ə nə: «Əl-m adɨ-m m-o, se kɔr la kɨ ɨgati kɨ lo ndɔr ləsi wa ə n wa?» Ə dəne əl-e ə nə: «Oyo, kɔr la kɨ j-ɨngə wa ən.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lo kɨn tɨ, Pɨyər əl-e ə nə: «Ra ban ə ɨndəi ndusi naa tɨ mba kadɨ soki NDɨl kɨ kay njay lə Ɓaɓe ə?» O ka nja dɨje kɨ awi kɨ ngawi dɨbi-e ə ɓa ta kəy tɨ kɨn, ḭ ka a awi səi tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta naa tɨ no̰o̰ par ə Sapɨra osɨ nja Pɨyər tɨ nangɨ, oy. Lokɨ basa je kɨ njé kaw dɨbɨ ngawe uri kəy nɨngə, ɨngəi nɨne adɨ uni-e awi sie dɨbi-e kadɨ ngawe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nḛ kɨ ra nḛ kɨn, ra adɨ njé kaw-naa je pətɨ, ɓəl rade ngay, taa dɨje pətɨ kɨ ooi poy ta kɨn ka, ɓəl rade ngay tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","*NJé kaw kɨlə je rai nḛ je kɨ ətɨ ɓəl kɨ nḛ je kɨ dəw asɨ ra al ngay dan dɨje tɨ. NJé kadɨ-me je pətɨ, kawi-naa lo kare ba, gɨn pal tɨ lə *Salomo̰, ta kəy tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dɨje kɨ rangɨ kɨ adi mede Luwə al ɓəy ɓəli kadɨ rəi rɔde tɨ. Be ka, pɨti njé kadɨ-me je ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dɨngəm je kɨ dəne je ngay ngay adi mede Ɓaɓe, adɨ kɔrde ore dɔ njé kadɨ-me je kɨ dɔ tɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Dɨje awi bɨtɨ ɔyi njé mo̰y je kɨ taga kadɨ rəbɨ tɨ, tɨləi-de dɔ tɨrə je tɨ ə se dɔ kagɨ tɨ kɨ otii-de, mba kadɨ re Pɨyər man nɨngə, ndɨle ur dɔ e kɨ ra tɨ wa kare dande tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dɨje ngay ḭ ɓe je tɨ kɨ gɨdɨ ɓe bo Jorijaləm tɨ, rəi bur bur kɨ njé mo̰y je kɨ dɨje kɨ ndɨl je kɨ majal yəti dɔde. Nɨngə pətɨ ɨngəi rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Go nḛ je tɨ kɨn, kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ dɨje kɨ goe tɨ kɨ əi me ɓutɨ tɨ lə *Sadusɨ je, jangɨ ra-de ngay dɔ njé kaw kɨlə je tɨ. Adɨ uni ndude kadɨ n-a rai nḛ madɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Be ə, uwəi njé kaw kɨlə je ɨləi-de kəy dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nə dan kondɔ tɨ, malayka lə Ɓaɓe re tḛḛ ta kəy dangay, lokɨ adɨ tḛḛi taga nɨngə, əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Awi me kəy kaw-naa tɨ, ɨləi mbḛ ta kɨ nje kadɨ dəw təl ɨsɨ kɨ dɔne taa kɨn adi dɨje pətɨ ooi!» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","*NJé kaw kɨlə je təli rɔde go tɨ, adɨ lo ti kɨ sḭ ɓatɨ ba par ə, awi kəy kaw-naa tɨ, ɨləi ngɨrə kadɨ ndoi nḛ dɨje. Kɨ bo kɨ dɔ njé kɨjə nḛ məsɨ kadɨ-kare je tɨ kɨ dɨje kɨ goe tɨ, ɓari ngatɔgɨ je kɨ njé gangɨ ta, kɨ ngatɔgɨ je lə ngan *Isɨrayəl je pətɨ. Nɨngə ɨləi kəy dangay tɨ mba kadɨ rəi kɨ njé kaw kɨlə je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nə lokɨ njé kɨlə je awi nɨngə, ɨngəi-de kəy dangay tɨ al, adɨ təli rəi ɔri-de poye əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«J-ɨngə ta kəy dangay e kɨ kutɨ mbukɨ majɨ nɨm, njé ngəm ta kəy je ka ai ta kəy tɨ no̰o̰ nɨm tɔ, nə lokɨ j-ur me kəy tɨ nɨngə, j-ɨngə dəw madɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lokɨ kɨ bo kɨ dɔ njé ngəm ta kəy kaw-naa tɨ əi kɨ kɨ bo kɨ dɔ njé kɨjə nḛ məsɨ kadɨ-kare tɨ ooi ta kɨn nɨngə, ndɨlde a̰y ur kakɨ, adɨ dəji-naa ta dɔ nḛ tɨ kɨ a ra nḛ go nḛ tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ɓa dəw madɨ re əl-de ə nə: «Dɨngəm je kɨ adi uwəi-de dangay tɨ ka kɨn, ai kəy kaw-naa tɨ no̰o̰, ɨsɨ ndoi nḛ dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kɨ bo kɨ dɔ kəy kaw-naa tɨ aw kɨ dɨje ləne uwə-n njé kaw kɨlə je re səde, nə ke ə ɨndəi gu dɔde tɨ al tadɔ ɓəli kadɨ kosɨ dɨje kɨ kawi-naa dɔ nḛ ndo tɨ lə njé kaw kɨlə je a tɨləi-de kɨ mbal tɔli-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lokɨ rəi səde nɨngə, awi səde kəy ngangɨ ta tɨ kɨ bo. Ə kɨ bo lə njé kɨjə nḛ məsi kadɨ-kare je əl-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«J-ɔgɨ səsi kɨ tɔgɨje kadɨ ɨndoi nḛ kosɨ dɨje kɨ tɔ dɨngəm kɨn. Ə səi ɨtəli rɔsi go ta tɨ ləje al, asi dɔnangɨ Jorijaləm nakɨ kɨ nḛ ndo ləsi, nɨngə ɨgei kadɨ məse e dɔje tɨ ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nə Pɨyər əi kɨ ndəgɨ njé kaw kɨlə je əli-de əi nə: «Təl rɔ go ta tɨ lə Luwə e sotɨ ɨtə təl rɔ go ta tɨ lə dɨje. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Luwə lə kaje je adɨ Jəju kɨ ɨtɔli-e kɨ rəbɨ ɓə-e dɔ kagɨ-dəsɨ tɨ kɨn, tḛḛ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E ə Luwə un-e, ɨnde ade ɨsɨ taa, dɔ ji kone tɨ tə NGar kɨ ɨtə ngar je pətɨ, taa nje kajɨ dɨje tɔ. Luwə ɨnde kadɨ, kɨ ta rəbɨ lie, Isɨrayəl je ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ, adɨ n-ɨyə̰-n go majal je ləde kɔ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Je njé ma najɨ dɔ nḛ je tɨ kɨ rai nḛ kɨn, naa tɨ kɨ NDɨl kɨ kay njay kɨ Luwə adɨ njé je kɨ təli rɔde go ta tɨ lie.» ");
INSERT INTO bjvNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lokɨ njé gangɨ ta je ooi ta kɨn nɨngə, wongɨ rade ngay dɔ njé kaw kɨlə je tɨ, adɨ ndɨgi tɔli-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nə e kɨ kare kɨ mbo̰de tɨ kɨ tɔe nə Gamalɨyəl ɔsɨ nangɨ ḭ taa. E Parɨsɨ kɨ nje ndo dɨje ndu-kun, e dəw kɨ dɨje pətɨ gei ta lie ngay. Lokɨ ḭ taa dande tɨ nɨngə, dəjɨ mba kadɨ adi njé kaw kɨlə je ɨjəi rɔde dəbɨ kare jɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ɓa go tɨ, əl-de ə nə: «Isɨrayəl je, ɨndəi manjɨ nḛ kɨ ɨgəi kadɨ rai kɨ dɨje kam majɨ oi taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dɔkagɨlo ngay al nḛ ɓəy ə, dəw madɨ kɨ tɔe nə Təda tɔjɨ rɔne kadɨ nḛ dəw kɨ nga. Ɔr dɨje asɨ ɓu sɔ gone tɨ. Nə dɨje rəi tɔli-e adɨ dɨje kɨ goe tɨ ka kɨn sanəi-naa. Dəw oo ta lie al ɓone. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Goe tɨ nɨngə, Juda kɨ Galile tɨ, tḛḛ dɔkagɨlo ndangɨ tɔ dɨje me makɨtɨbɨ tɨ, ɔy dɨje ngay gone tɨ ra-n wongɨ. Nə e wa ka dɨje tɔli-e tɔ, adɨ dɨje kɨ goe tɨ sanəi-naa kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","NGɔsɨne, ta ləm ə to kɨn: Otɨ kadɨ ɨrai nḛ madɨ kɨ dɨje kam, ɨyə̰i-de adɨ awi lo ləde. Nḛ kɨ kadɨ ɨgəri ə to kɨn, re kɔjɨ ta ra je ləde kɨ kɨlə rade je ḭ rɔ dɨje tɨ ə, gɨn nḛ je kɨn a gangɨ tə ya̰ ndəge je be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nə re nḛ je kɨn ḭ rɔ Luwə tɨ ə, lo kadɨ səi a ɔgi dɔ goto. Otɨ kadɨ ɨnai rɔ kɨ Luwə.» Lo kɨn tɨ, njé gangɨ ta je ndɨgi goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Be ə, təli ɓari njé kaw kɨlə je kəy gogɨ, ɓa, adi tɨndəi-de, ə ndɔri mbide kadɨ əli ta kɨ tɔ Jəju al, nɨngə ɨyə̰i-de adɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","NJé kaw kɨlə je tḛḛi lo gangɨ ta tɨ kɨ rɔnəl mba koo kɨ Luwə oo-de adɨ asi nakɨ kadɨ ɨngəi ko̰ mbata lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nɨngə kɨ ndɔ je kare kare pətɨ, me kəy kaw-naa tɨ ə se me kəy je tɨ madɨ, njé kaw kɨlə je nayḭ kɨ lo ndo nḛ dɨje tɨ nɨm, kɨ lo kɨlə mbḛ Poy Ta kɨ Majɨ tɨ, təkɨ Jəju e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dɔkagɨloe tɨ kɨn, kɔr njé ndo je ḭ kɨ dɔ made tɨ kɨ kəte kəte. Be ə, ra adɨ *Jɨpɨ je kɨ njé kəl ta Gɨrəkɨ ɓai ta dɔ Jɨpɨ je tɨ kɨ njé kəl ta Ebɨrə. NJé kəl ta Gɨrəkɨ ɓai ta mbata njé ngaw koy je ləde ɨngəi nḛ kuso kɨ dɨje ɨsɨ ləbi kɨ ndɔ je kare kare pətɨ kɨn, tə ndəge je al. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Be ə, njé kaw kɨlə je kɨ dɔgɨ gɨde e joo kawi njé ndo je kɨ naa tɨ, əli-de əi nə: «A e nḛ kɨ go tɨ al kadɨ j-ɨyə̰ ta kəl ta lə Luwə, ə jɨ təl jɨ nay ta nḛ ləbɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","MBata kɨn ə, ngako̰ je je, majɨ kadɨ ɨkɔti dɨje sɨri dansi tɨ, kɨ dɨje mai najɨ ləde majɨ nɨm, NDɨl Luwə rosɨ mede nɨm, taa awi kɨ kəm-kədɨ nɨm tɔ, mba kadɨ j-ɨlə kɨlə kɨn jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Be mba kadɨ j-un-n rɔje j-ɨndə ta dangɨ mbata kəl ta kɨ Luwə kɨ mbata ndo nḛ dɨje.» ");
INSERT INTO bjvNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta kɔjɨ je kɨn nəl njé ndo je pətɨ. Be ə, mbəti Etɨyən kɨ e dəw kɨ rosɨ kɨ kadɨ-me nɨm, kɨ NDɨl kɨ kay njay nɨm tɔ. Taa mbəti Pɨlɨpɨ nɨm, Pɨrokɔr nɨm, Nɨkanɔr nɨm, Tɨmo̰ nɨm, Parmənasɨ nɨm, taa Nɨkola kɨ e dəw kɨ A̰tɨyosɨ tɨ, kɨ təl Jɨpɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Rəi səde ɔji-de njé kaw kɨlə je, adɨ əli ta kɨ Luwə mbata ləde, ɨndəi jide dɔde tɨ nɨm, njangi dɔde nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ta lə Luwə aw kɨ kəte par par. Kɔr njé ndo je ḭ dɔ made tɨ ngay me ɓe bo tɨ kɨ Jorijaləm. Taa njé kɨjə nḛ məsɨ kadɨ-kare je wa ngay ka adi mede Jəju tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etɨyən e dəw kɨ rosɨ kɨ me-majɨ nɨm, kɨ tɔgɨ lə Luwə nɨm, taa ra nḛ je kɨ dum ra kɨ nḛ kɔjɨ je kɨ ətɨ ɓəl ɓəl dan dɨje tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nɨngə dɨje madɨ ɨləi ngɨrə kadɨ naji ta kɨ Etɨyən. Dɨje kɨn əi njé kɨ me kəy kaw-naa tɨ lə *Jɨpɨ je. Əi njé je kɨ ɓari rɔde: «Dɨje kɨ taa kɨyə̰ taa.» Adɨ əi Jɨpɨ je kɨ ḭḭ Sɨrən tɨ nɨm, Aləgɨjandɨri tɨ nɨm, kɨ njé kɨ ḭḭ Sɨlɨsi tɨ nɨm, taa kɨ dɔnangɨ Aji tɨ nɨm tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","nə tɔgɨ ta kəlde asɨ go ya̰ Etɨyən tɨ al, tadɔ Etɨyən əl ta kɨ kəm-kədɨ kɨ NDɨl Luwə ade. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lo kɨn tɨ, awi ndogi dɨje kɨ la kɨ jide tɨ kadɨ əli əi nə: «Je wa j-o kɨ mbije kadɨ Etɨyən əl ta kɨ mal dɔ *Mojɨ nɨm, dɔ Luwə nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Be ə, suləi kosɨ dɨje nɨm, ngatɔgɨ je nɨm, taa njé ndo ndu-kun je nɨm adɨ rəi uwəi Etɨyən dɔ jie tɨ, awi sie lo gangɨ ta tɨ kɨ bo. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ɨndəi njé ma najɨ je kɨ ngom adɨ təti ta dɔe tɨ, əli əi nə: «Dɨngəm kam ta kə̰ə̰ ta kəl ta kɨ mal dɔ kəy tɨ lə Luwə kɨ e lo kɨ ay njay kɨn al nɨm, taa dɔ ndu-kun tɨ lə Mojɨ al nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Təkɨ rɔjetɨ, je wa j-o ndue kɨ əl-n kadɨ Jəju kɨ Najarətɨ tɨ a tujɨ kəy kɨn, ə a yətɨ nḛ kagɨ ɓe je kɨ Mojɨ adɨ-je. ");
INSERT INTO bjvNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Dɨje pətɨ kɨ lo gangɨ ta tɨ kɨ bo, uri kəmde pətɨ dɔ Etɨyən tɨ, nɨngə ooi kadɨ ta kəme to tə ya̰ malayka be. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je dəjɨ ta Etɨyən ə nə: «Ta je kɨ dɨje əli dɔi tɨ kɨn, e kɨ rɔjetɨ wa ta?» ");
INSERT INTO bjvNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etɨyən ɨle tɨ ə nə: «Səi bawm je ngakom je kɨ, uri mbisi oi dɔ ta kɨ m-a m-əl səsi kam majɨ. Me ndɔ je tɨ kɨ kəte, Luwə kɨ nje pɨtɨ ɔjɨ rɔne kaje *Abɨrakam, dɔkagɨlo tɨ kɨ ɨsɨ-n me ɓe tɨ kɨ Mejopotami tɨ ɓəy, kəte ɓəy taa kadɨ aw uwə lo kɨsɨ dɔnangɨ Aram tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Luwə əl-e ə nə: “Ḭ taa ɨyə̰ ɓe ləi kɨ njé koji je ə aw me ɓe tɨ kɨ m-a m-ɔji.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","E be ə, Abɨrakam ɨyə̰ me ɓe kɨ Kalde ə re uwə lo kɨsɨ Aram tɨ. Nɨngə go koy bawe tɨ, Luwə ade ḭ taa re me ɓe tɨ kɨ ɨsi tɨ ngɔsɨne kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nḛ nduwə kɨ Luwə adɨ Abɨrakam me ɓe tɨ kɨn goto. NGon nusɨ lo kɨ ndɨkɨri be ka ade al. Nə un ndune ade kadɨ n-a n-ade ɓe kam ba pətɨ. Taa n-a n-adɨ ngan kae je toe tɨ tɔ. Dɔkagɨlo tɨ kɨ Luwə ɨsɨ əl ta Abɨrakam kɨn, Abɨrakam ojɨ ngon al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ta kɨ Luwə əl-e ə to kɨn: “NGan kai je a ɨsi tə mba je dɔnangɨ tɨ kɨ rangɨ nɨm, dɨje a rai-de ɓəə tɨ nɨm, ta dɨje a adi-de ko̰ asɨ ɓal ɓu sɔ nɨm tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Go ta je tɨ kɨn, Luwə əl ə nə: “Gɨn dɨje kɨ rai-de ɓəə tɨ kɨn, mi wa m-a m-gangɨ ta dɔde tɨ. Go tɨ nɨngə, a tḛḛi me ɓe mba tɨ kɨ rade ɓəə tɨ kɨn kɔ, ə a təli rəi me ɓe tɨ kɨ ḭ tɨ ə awi ɓəə tɨ kɨn mba kadɨ rəi ɔsi məkəsɨde nangɨ no̰m tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ɓa Luwə ade nḛ kɨlə mɨndɨ kɨ e kɨjə mɔtɨ. Be ə, lokɨ Abɨrakam ojɨ *Isakɨ nɨngə ndɔ jijoo go tɨ par ə ɨjə mɔte. Isakɨ ra be tɔ mbata ngone *Jakobɨ. Jakobɨ ka ra be tɔ mbata ngane je kɨ əi gɨn *Isɨrayəl je kɨ dɔgɨ gɨde e joo. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Nɨngə ni kɨ me ngan lə Jakobɨ tɨ ra adɨ gati kɨ ngoko̰de Jɨsəpɨ adɨ awi sie tə ɓəə me ɓe tɨ kɨ Ejɨpɨ tɨ. Nə Luwə e sie naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Be ə, ɔr-e me ko̰ je tɨ pətɨ. Nɨngə me-majɨ lə Luwə kɨ e sie, ade kəm-kədɨ ta kəm Parawo̰ tɨ kɨ e ngar kɨ Ejɨpɨ tɨ. Adɨ Parawo̰ un-e ɨnde tə nje ko̰ɓe dɔnangɨ kɨ Ejɨpɨ tɨ, taa dɔ me kəy tɨ ləne pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dɔkagɨloe tɨ kɨn ə, ɓo kɨ bo osɨ dɔnangɨ Ejɨpɨ tɨ ba pətɨ, taa dɔnangɨ Kana tɨ tɔ. E dɔkagɨlo kəm-to-ndoo kɨ ətɨ ɓəl ngay. Lo kadɨ bawje je ɨngəi nḛ ndɨkɨri usoi goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lokɨ Jakobɨ oo kadɨ nḛ kuso to me ɓe tɨ kɨ Ejɨpɨ tɨ nɨngə, ɨlə nganne je kɨ əi kaje je adɨ awi kɨ dɔsa̰y. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lokɨ təl ɨlə-de kɨ ko̰ joo nɨngə, Jɨsəpɨ ra adɨ ngako̰e je gəri-e. Lo kɨn tɨ, Parawo̰ ka, gər-n gɨn kojɨ lə Jɨsəpɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Go tɨ nɨngə, Jɨsəpɨ ɨlə go bawne Jakobɨ tɨ ade re kɨ gɨn kojɨ lie ba pətɨ, asi dɨje dɔsɨri gɨde e mi. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakobɨ aw Ejɨpɨ tɨ nɨngə oy kɨ kəte no̰o̰. Kaje je ka oyi no̰o̰ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Təli kɨ sɨngəde rəi dɔnangɨ Kana tɨ, me ɓe bo tɨ kɨ tɔe nə Sɨsəm. Dɨbi-de ɓe nɨn tɨ kɨ Abɨrakam ndogɨ kɨ la ji ngan lə Amɔr tɨ me ɓe tɨ kɨ Sɨsəm. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Dɔkagɨlo tɔl kon kun mɨndɨ kɨ Luwə un adɨ Abɨrakam e ɓasi. Nɨngə kɔr ngan Isɨrayəl je ba̰y kɨ dɔ made tɨ dɔ made tɨ dɔnangɨ Ejɨpɨ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","bɨtɨ dɔkagɨlo tɨ kɨ ngar kɨ rangɨ kɨ gər Jɨsəpɨ al o̰-n ɓe dɔnangɨ Ejɨpɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","NGar ka kɨn uwə dɨje ləje ra-n kɨlə kɨ al dɔ majɨ nɨm, adɨ-de ko̰ nɨm, ta ɨndə gu dɔde tɨ adɨ ɨyə̰i ngande je kɨ kasɨ kɔ, bɨtɨ kadɨ oyi. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dɔkagɨlo tɨ kɨn ə, oji *Mojɨ kɨ me-majɨ lə Luwə e dɔe tɨ adɨ oti-e me kəy tɨ lə bawe asɨ nay mɨtə. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nɨngə lokɨ dum dɔde adɨ ɨləi-e kɔ, ngon lə Parawo̰ kɨ dəne tḛḛ dɔe tɨ, ə un-e ote tə ngonne wa be. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Be ə Mojɨ ɨngə-n nḛ ndo kɨ ɔjɨ dɔ kəm-kədɨ pətɨ kɨ dɔnangɨ Ejɨpɨ tɨ. Adɨ aw kɨ tɔgɨ me ta kəl-e tɨ nɨm, me kɨlə rae tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Lokɨ ɓale e kutɨ sɔ nɨngə, mər ta re dɔe tɨ mba kadɨ n-aw n-oo ngakone je kɨ əi ngan Isɨrayəl je. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dɔkagɨlo tɨ kɨ e-n kɨ ngakone je ə, oo dəw kare kɨ Ejɨpɨ tɨ ɨsɨ adɨ ko̰ kɨ kare dande tɨ. Be ə, re rɔ dɔ ngokone tɨ adɨ ɨndə dəw kɨ Ejɨpɨ tɨ ka kɨn tɔl-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mojɨ gɨr kadɨ ngakone je a gəri təkɨ Luwə ə ɨlə səne mba kadɨ n-taa dɔde. Nə ngako̰e je gəri al. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","NDɔ kɨ go tɨ, oo ngakone je joo kɨ əi Isɨrayəl je ɨsɨ rɔi-naa. Ɨre a dande tɨ mba kadɨ gangɨ-de naa tɨ. Əl-de ə nə: “Səi ngakonaa je tɔ, ə ban ə ɨsɨ rai na majal be ə?” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nɨngə e kɨ nje tɨndə ngokone ka kɨn ɔse ngərəngɨ, ə əl-e ə nə: “Na̰ ə ɨndəi dɔje tɨ tə ngar ləje, ə se nje gangɨ ta danje tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɨge tɔl-m təkɨ tagɨne ɨtɔl-n dəw kɨ Ejɨpɨ tɨ ka kɨn be a?” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lokɨ Mojɨ oo dɔ ta kɨn nɨngə, ɓəl ra-e, adɨ aw uwə lo kɨsɨ tə mba dɔnangɨ Madɨya̰ tɨ. Dɔnangɨ Madɨya̰ tɨ ə Mojɨ taa dəne ojɨ-n ngan je joo. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ɓal kutɨ sɔ go tɨ nɨngə, malayka tḛḛ hɔy rɔe tɨ dɨlə lo tɨ, ɓasi kɨ dɔ mbal Sɨnay, dan ndon por tɨ me gu tɨ kɨ ɨsɨ o̰ por. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lokɨ Mojɨ oo nḛ kɨn nɨngə, ndɨle a̰y ur kakɨ. Mojɨ ge kadɨ n-oo nḛ kɨn majɨ adɨ ɔtɨ re ɓasi rɔ tɨ. Loe tɨ no̰o̰ ə oo dɔ ndu Ɓaɓe ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Mi Luwə lə kai je, Luwə lə Abɨrakam, Luwə lə Isakɨ, Luwə lə Jakobɨ.” Mojɨ ɓəl dadɨ par par, lo kadɨ un kəmne kɨ taa goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ə Ɓaɓe əl-e ə nə: “Ɔr sa njai tɨ tadɔ lo kɨ a tɨ kam e lo kɨ ay njay. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","M-o kəm ko̰ lə dɨje ləm me ɓe tɨ kɨ Ejɨpɨ tɨ. M-o dɔ tɨmə kɨ ɨsɨ tɨməi rusɨ rusɨ, ə m-ur nangɨ m-re kadɨ m-taa-de m-ɨlə-de taa. Nɨngə kɨ ɓasɨne kɨn, ɨre adɨ m-ɨlə-i Ejɨpɨ tɨ gogɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Oi majɨ! E Mojɨ kɨ ngako̰e je ɔsi-e ngərəngɨ, ə əli-e əi nə: “Na̰ ɨndəi dɔje tɨ tə ngar ləje ə se nje gangɨ ta danje tɨ ə”, wa kɨn ə, Luwə ɨle tə ngar nɨm, taa nje taa-de kɨlə-de taa nɨm, kɨ takul tɔgɨ lə malayka kɨ tḛḛ sie hɔy me gu tɨ, kɨn nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E ə tḛḛ səde kɨ takul nḛ ra je kɨ dəw asɨ ra al nɨm, kɨ takul nḛ kɔjɨ je nɨm, me ɓe tɨ kɨ Ejɨpɨ tɨ. Taa dɔkagɨlo tɨ kɨ ɨsɨ ɨndəi ba bo kasɨ gangi nɨm, dɔkagɨlo tɨ kɨ rai ɓal kutɨ sɔ dɨlə lo tɨ kɨn nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","E darɔ Mojɨ kɨ kare wa kɨn ɓəy ə tɔ ə əl ngan Isɨrayəl je ə nə: “Luwə a tḛḛ kɨ nje kəl ta kɨ tane tɨ kare dansi tɨ səi je wa, kɨ a to tə mi be.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lokɨ ngan Isɨrayəl je kawi-naa dɨlə lo tɨ ka, e Mojɨ wa kɨn ə taa ta ta malayka tɨ dɔ mbal Sɨnay tɨ, əl kaje je. E ə taa ta kajɨ kɨn rɔ Luwə tɨ, mba kadɨ adɨ-je. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nə kaje je mbati kadɨ təli rɔde go ta je tɨ lie. Nɨngə kɨ bo tɔy, ɔsi-e ngərəngɨ. Mede e dɔ təl kaw dɔnangɨ Ejɨpɨ tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dɔkagɨlo tɨ kɨ Mojɨ nay dɔ mbal Sɨnay tɨ ɓəy, rəi rɔ *Aro̰ tɨ əli-e əi nə: “Ɨra kagɨ yo je kɨ kadɨ ɔri no̰je, tadɔ jɨ gər nḛ kɨ ra Mojɨ kɨ nje tḛḛ səje me ɓe tɨ kɨ Ejɨpɨ tɨ kɨn al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Be ə me ndɔ je tɨ kɨn, ɨbəi ngon yo madɨ kɨ to tə ngon baw mangɨ be, ə ɨləi kadɨ-kare adi-e. Ɓa rai rɔnəl ngay ɔsi gon nḛ kɨ əi je wa ɨbəi kɨ jide kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nə Luwə təl gɨdɨne adɨ-de, ɨyə̰-de kɔ adɨ ɨsi ta ra yo tɨ, kɨ kɔsɨ-gon nḛ je kɨ dɔra̰ tɨ tə nay je kɨ kadɨ je kɨ mee je tə kagɨ yo je ləde, təkɨ ndangi me makɨtɨbɨ tɨ lə nje kəl ta kɨ ta Luwə tɨ: “Səi dɨje kɨ Isɨrayəl, ɓal kutɨ sɔ kɨ ɨrai dɨlə lo tɨ kɨn se da je kɨ ɨtɔli-de kɨ ndəgɨ kadɨ-kare je adi, e mi ə adi-mi a? ");
INSERT INTO bjvNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jagɨ, səi oti kəy yo lə kagɨ yo ləsi Molokɨ yo, kɨ mee lə kagɨ yo ləsi Rəpa̰, yo je kɨ səi wa ɨrai-de kɨ jisi mba kadɨ ɔsi məkəsɨsi no̰de tɨ. MBata nḛ rasi je kɨn ə, m-a m-adɨ njé ba̰ je ləsi a uwəi səsi, awi səsi sa̰y tə mba je gɨdɨ *Babɨlon tɨ ɓəy”. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Me dɨlə lo tɨ, kaje je ai kɨ kəy kɨbɨ kɨngə-naa kɨ Luwə. Mojɨ ra kəy kɨbɨ ka kɨn təkɨ Luwə un-n ndune ade. Ra go kuje tɨ kɨ oo. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ɨyə̰i kəy kɨbɨ ka kɨn adi gɨn kojɨ je ləde kɨ rangɨ, kɨ əi kaje je kɨ rəi gode tɨ. Kəy kɨbɨ kɨn e jide tɨ, lokɨ Jojuwe ɔr no̰de adɨ rəi taai dɔnangɨ lə gɨn dɨje kɨ dangɨ dangɨ kɨ Luwə tuwə-de no̰de tɨ. Kəy kɨbɨ ka kɨn, to bɨtɨ dɔkagɨlo tɨ lə Dabɨdɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Me-majɨ lə Luwə e kɨ *Dabɨdɨ adɨ dəjɨ ta rəbɨ mba kadɨ n-ra kəy n-adɨ Luwə lə Jakobɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nə e *Salomo̰ yo ə ra kəy adɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«NGa nɨngə Luwə kɨ e kɨ dɔkagɨlo je tɨ pətɨ, a ɨsɨ me kəy tɨ kɨ dəw ra kɨ jine al. Təkɨ nje kəl ta kɨ tae tɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Dɔra̰ e kɨmbər ngar ləm, nɨngə dɔnangɨ e nḛ kɨndə njam.” Ɓaɓe əl ɓəy ə nə: “Kəy kɨ ban ə, a ɨrai adi-mi ə? Lo kɨ ra a e lo kuwə rɔ ləm ə? ");
INSERT INTO bjvNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Se e mi al ə, na̰ tɔy ə, ra nḛ je kɨn pətɨ ə?” ");
INSERT INTO bjvNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«Səi dɨje kɨ njé ta̰ rɔ je, ɨtḛḛi mesi al nɨm, ɨbəyi mbisi nɨm dɔ ta tɨ lə Luwə tə dɨje kɨ njé gər Luwə al be. Ɨtoi tə bawsi je wa be. Nḛ kɨn ə ra adɨ, ɨsi ta rɔ kɨ NDɨl Luwə tɨ, kɨ dɔkagɨlo je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","NJe kəl ta kɨ ta Luwə tɨ kɨ ra ə bawsi je adi-e ko̰ al ə? Əi je ə tɔli njé kɨlə mbḛ kəte, kɨ ɔjɨ dɔ re lə dəw kɨ e kare ba, kɨ e dəw kɨ dana. Nɨngə ngɔsɨne, lokɨ Kɨrɨsɨ re, səi je uni dɔe, ə tɔli-e tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Oyo, səi ɨngəi ndu-kun lə Luwə kɨ takul malayka je, nə lo kadɨ ɨtəli rɔsi tɨ go tɨ goto.» ");
INSERT INTO bjvNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lokɨ njé gangɨ ta je kɨ bo lə *Jɨpɨ je ooi dɔ ta kɨ Etɨyən əl nɨngə, wongɨ rade ngay adɨ ngəi ngangɨde mur mur dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nə Etɨyən kɨ NDɨl Luwə rose, un kəmne taa kɨ dɔra̰ tɨ nɨngə oo kunjɨ Luwə nɨm, taa oo Jəju kɨ a taa dɔ ji ko̰ Luwə tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Əl ə nə: «Oi, m-o dɔra̰ tḛḛ tane, nɨngə m-o NGon Dəw a taa dɔ ji ko̰ Luwə tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lokɨ ooi dɔ ta kɨn nɨngə, uri kɔl kɨ ndude kɨ bo ə uti mbide dɔ ta tɨ lie, ə ɓuki-naa dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","NDɔri-e awi sie taga gɨdɨ ɓe bo tɨ, ə tɨləi-e kɨ mbal tɔli-e. Dɨje ka kɨn ɨyə̰i kɨbɨ je ləde rɔ ngon kɨ basa tɨ kɨ tɔe nə Sol. ");
INSERT INTO bjvNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dɔkagɨlo tɨ kɨ ɨsɨ tɨləi-e kɨ mbal, Etɨyən əl ta ə nə: «Ɓaɓe Jəju, ɨtaa ndɨlm kɨ rɔi tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Go tɨ nɨngə ɔsɨ məkəsɨne nangɨ, ə əl ta kɨ ndune kɨ bo ə nə: «Ɨyə̰ go majal kɨn kɔ adɨ-de!» Go ta je kɨn tɨ, nɨngə Etɨyən oy. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol e mbo̰ dɨje tɨ kɨ ndɨgi kadɨ tɔli Etɨyən. Dɔ ndɔe tɨ kɨn kɨndə kəm-ndoo kɨ bo ngay tḛḛ dɔ njé kaw-naa je tɨ kɨ Jorijaləm. Adɨ njé kadɨ-me je pətɨ sanəi-naa kɨ go lo je. Awi kɨ Jude tɨ je kɨ *Samari tɨ je. *NJé kaw kɨlə je wa par ə nayḭ-naa Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dɨje kɨ njé ɓəl Luwə dɨbi Etɨyən, no̰i-e ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nə Sol ɓa, ɔr njé kaw-naa je nja̰. Aw kɨ ta kəy ta kəy uwə dɨngəm je kɨ dəne je ɓukɨ-de dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","NJé kɨ sanəi-naa ka kɨn awi kɨ lo lo ɨləi mbḛ Poy Ta kɨ Majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","E be ə, Pɨlɨpɨ kɨ aw me ɓe bo tɨ kɨ *Samari, ɨlə dɨje mbḛ Poy Ta kɨ Majɨ lə Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kosɨ dɨje ba pətɨ, lokɨ ooi ta je kɨ Pɨlɨpɨ əl je kɨ nḛ kɔjɨ je kɨ ra adɨ ooi kɨ kəmde nɨngə, uri mbide kɨ dɔ ta tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tadɔ ndɨl je kɨ majal tḛḛi me njé mo̰y je tɨ ngay kɨ no̰ kɨ boy tade tɨ. Taa, dɨje kɨ rɔde oy kɨ njé mətɨ je ngay ɨngəi rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Rɔnəl kɨ bo ngay to me ɓe bo tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kəte taa kadɨ Pɨlɨpɨ re, dɨngəm madɨ kɨ tɔe nə Sɨmo̰ ɨsɨ me ɓe bo tɨ kɨn no̰o̰. E nje ra mbəli, adɨ ɔr ndɨl dɨje kɨ me ɓe tɨ kɨ Samari ngay. Ra rɔne kadɨ nḛ dəw madɨ kɨ ətɨ ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Adɨ dɨje pətɨ, ḭ dɔ ngan je kɨ du tɨ, bɨtɨ kɨ dɔ dɨje kɨ tɔgɨ tɨ, angalde e kɨ dɔe tɨ. Əli əi nə dɨngəm kam aw kɨ tɔgɨ lə Luwə kɨ e tɔgɨ kɨ ətɨ ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Angal dɨje e kɨ dɔe tɨ, tadɔ e mari nu ba ə ɨsɨ ɔr ndɨlde kɨ mbəli kɨ ra ləne. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nə lokɨ dɨje adi mede Pɨlɨpɨ kɨ ɨlə-de mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə nɨm, kɨ Jəju Kɨrɨsɨ nɨm tɔ nɨngə, dɨngəm je kɨ dəne je adi Pɨlɨpɨ ra-de batəm. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sɨmo̰ wa kɨ dɔne ka adɨ mene tɔ. Lokɨ Pɨlɨpɨ ra-e batəm nɨngə, ɨyə̰ go Pɨlɨpɨ al. Lokɨ oo nḛ kɔjɨ je kɨ nḛ je kɨ ətɨ ɓəl ngay ka kɨn nɨngə, e wa təl re əte ɓəl ngay ɓəy tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lokɨ njé kaw kɨlə je kɨ ɨsi Jorijaləm tɨ ooi kadɨ dɨje kɨ *Samari tɨ taai ta lə Luwə nɨngə, ɨləi Pɨyər əi kɨ Ja̰ kɨ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lokɨ rəi tḛḛi Samari tɨ nɨngə, əli ta kɨ Luwə mba kadɨ njé kadɨ-me je ɨngəi NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tadɔ NDɨl re dɔ dəw madɨ tɨ kare dande tɨ al ɓəy. E batəm par ə rai-de me tɔ Ɓaɓe Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","E be ə, Pɨyər əi kɨ Ja̰ ɨndəi jide dɔde tɨ kadɨ ɨngəi NDɨl Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lokɨ Sɨmo̰ oo kadɨ e kɨ go rəbɨ lə ji kɨ kɨndə dɔ tɨ lə njé kaw kɨlə je ə NDɨl re-n dɔ njé kadɨ-me je tɨ nɨngə, adɨ Pɨyər əi kɨ Ja̰ la, ");
INSERT INTO bjvNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ə əl-de ə nə: «Mi ka adi-mi tɔgɨ kɨn tɔ kadɨ tə dəw kɨ m-a m-ɨndə jim dɔe tɨ ɓa, ɨngə NDɨl Luwə tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ə Pɨyər əl-e ə nə: «Kadɨ la ləi kɨn tujɨ naa tɨ kɨ darɔi. Tadɔ ɨndə mei tɨ kadɨ a ndogi kadɨ-kare lə Luwə kɨ la. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nḛ kɨ ɓa tɔi, ə se nḛ kɨ sɔbɨ dɔi goto me nḛ tɨ kɨ j-a-n kam, tadɔ mei e dana no̰ Luwə tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Majɨ kadɨ ɨtɔr ndui dɔ majal tɨ ləi, ə əl ta kɨ Ɓaɓe adɨ re to ban ə, ɨyə̰ go kɔjɨ ta je kɨ mei tɨ kɨn kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tadɔ m-o kadɨ mei atɨ kanana, taa majal doləi dole tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","NGa ə, Sɨmo̰ əl Pɨyər əi kɨ Ja̰ ə nə: «Kadɨ səi je wa əli ta kɨ Ɓaɓe mbata ləm, kadɨ nḛ madɨ kare me nḛ je tɨ kɨ əli tae kɨn tḛḛ dɔm tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lokɨ Pɨyər əi kɨ Ja̰ mai najɨ, ə ndoi ta lə Ɓaɓe tɔ nɨngə, təli kɨ Jorijaləm tɨ gogɨ. Ɨləi mbḛ Poy Ta kɨ Majɨ me ngan ɓe je tɨ kɨ Samari ngay kɨ go rəbɨ go rəbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","NDɔ kare Malayka lə Ɓaɓe əl Pɨlɨpɨ ə nə: «Ḭ taa aw kɨ gɨn ɓe tɨ be, dɔ rəbɨ tɨ kɨ ḭ Jorijaləm aw kɨ Gaja tɨ, kɨ e rəbɨ kɨ dɨlə lo tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pɨlɨpɨ ḭ taa kalangɨ aw nɨngə, ɨngə dɨngəm kare kɨ dɔnangɨ Etɨyopi, kɨ e kɨ boy, kɨ nje ngəm nḛ majɨ je lə ngar kɨ dəne kɨ Etɨyopi tɨ, kɨ tɔe nə Kandasɨ. Dɨngəm kɨn aw Jorijaləm tɨ ɔsɨ dɔne nangɨ no̰ Luwə tɨ ə ɨsɨ təl kɨ ɓe gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ɨsɨ me pusɨ tɨ ləne, ɨsɨ tɨdə makɨtɨbɨ lə nje kəl ta kɨ ta Luwə tɨ Ejay. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lo kɨn tɨ, NDɨl Luwə əl Pɨlɨpɨ ə nə: «Ɔtɨ aw ɓasi kɨ rɔ pusɨ tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pɨlɨpɨ a̰y ngɔdɨ aw nɨngə, oo ndu dɨngəm kɨ Etɨyopi tɨ ka kɨn ɨsɨ tɨdə makɨtɨbɨ lə nje kəl ta kɨ ta Luwə tɨ Ejay. Pɨlɨpɨ dəje ə nə: «Ɨgər me ta kɨ ɨsɨ tɨdə kɨn majɨ wa a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dɨngəm ka kɨn əl-e ə nə: «Re nje kɔr mee kadɨ-m goto ə m-a m-gər ban ə?» Ɓa dəjɨ Pɨlɨpɨ adɨ al taa goe tɨ, ɨsɨ gəde tɨ me pusɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ta kɨ ɨsɨ tɨdə ə to kɨn: «Ɔri-e tə batɨ kɨ dəw ɨsɨ aw sie kadɨ tɔl-e be; Tə ngon batɨ kɨ a tane mbə no̰ nje kɨjə bḭe tɨ be. E be ə, tḛḛ-n tane al. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ɨləi rɔsɔl dɔe tɨ, gangi ta lie kɨ go rəbɨ kɨ dana al. Na̰ ə a ɔr gɨn kojɨ lie ə? Tadɔ ɨndəi ngangɨ ndɔ kɨsɨ kɨ dɔ taa lie.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nɨngə, kujɨ dɨngəm un ta əl Pɨlɨpɨ ə nə: «M-dəji kadɨ əl-m adɨ m-o, na̰ ə nje kəl ta kɨ ta Luwə tɨ ɨsɨ əl ta lie be ə? Ɨsɨ əl ta kɨ dɔ rɔne tɨ wa ə se ɨsɨ əl ta dɔ dəw madɨ tɨ kɨ rangɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lo kɨn tɨ nga ə, Pɨlɨpɨ ɨngə rəbɨ adɨ un ta tane tɨ, nɨngə kɨ rəbɨ lə makɨtɨbɨ lə nje kəl ta kɨ ta Luwə tɨ Ejay kɨn, ɨle-n mbḛ Poy ta kɨ kɨ Majɨ lə Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lokɨ njɨyəi ɨsɨ awi nɨngə, tḛḛi ta man tɨ, ə kujɨ dɨngəm ka kɨn əl ə nə: «Man ə am, nga ri ə ɔgɨ kadɨ m-ra batəm ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pɨlɨpɨ əl-e ə nə: «Re adɨ mei Luwə təkɨ rɔjetɨ ə, nḛ kɨ ɔgi ra batəm goto.» Kujɨ dɨngəm ə nə: «M-adɨ mem təkɨ Jəju Kɨrɨsɨ e NGon Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lo kɨn tɨ, adɨ pusɨ a nangɨ, nɨngə əi kɨ Pɨlɨpɨ joo pu, uri me man tɨ adɨ Pɨlɨpɨ ra-e batəm. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lokɨ tḛḛi me man tɨ kɨ taga nɨngə, NDɨl Ɓaɓe un Pɨlɨpɨ aw sie adɨ kujɨ dɨngəm oo-e al. Nə e ɨlə rəbɨ ləne kɨ rɔnəl aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pɨlɨpɨ aw tḛḛ me ɓe tɨ kɨ Ajotɨ, ɨlə mbḛ Poy Ta kɨ Majɨ me ɓe bo je tɨ pətɨ kɨ tḛḛ tɨ, bɨtɨ tḛḛ-n Səjare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dɔkagɨloe tɨ kɨn, gɨr ta kɨ dɔ kadɨ ko̰ njé ndo je tɨ lə Ɓaɓe kɨ dɔ tɔl-de tɨ to dɔ Sol tɨ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Be ə, aw rɔ kɨ boy tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je, dəje makɨtɨbɨ mba kadɨ n-aw-n lo kaw-naa je tɨ lə *Jɨpɨ je kɨ me ɓe tɨ kɨ Damasɨ, kadɨ re n-ɨngə dɨngəm je kɨ dəne je kɨ njé ndole go nḛ ndo kɨ sɨgɨ kɨn ə n-dɔɔ-de n-re səde Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lokɨ Sol e dɔ rəbɨ tɨ, ɨndə dɔ ɓe kɨ Damasɨ ɓasi nɨngə, kunjɨ madɨ tḛḛ patɨ, ḭ kɨ dɔra̰ tɨ, unjɨ gə dɔe. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tḛḛ osɨ nangɨ nɨngə, oo dɔ ndu ta madɨ əl-e ə nə: «Sol, Sol, mbata ri ə ɨsɨ adɨ-m ko̰ be ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol dəje ə nə: «Ḭ na̰ ə Ɓaɓe?» Nɨngə, Ɓaɓe əl-e ə nə: «E mi Jəju kɨ ɨsɨ adɨ-m ko̰.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ḭ taa aw me ɓe bo tɨ ə, a əli-ni nḛ kɨ kadɨ a ɨra. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","NJé kɨ ɨsɨ awi kɨ Sol təli ai lo ka tɨ. Ɓəl tɔl-de adɨ lo kadɨ əli ta goto. OOi dɔ ndu ta, nə ooi dəw madɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ḭ taa, tḛḛ kəmne majɨ, nə oo lo al, adɨ made je uwəi jie, ndɔri-e tə ndɔr, ə awi sie Damasɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ɨsɨ loe tɨ no̰o̰ ndɔ mɨtə kɨ kanjɨ kadɨ oo lo. Uso nḛ al nɨm, a̰y man al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nɨngə nje ndo lə Jəju kare ɨsɨ Damasɨ tɨ no̰o̰, tɔe nə Ananɨyasɨ. Ɓaɓe ɓar-e me nḛ koo me ndɨl tɨ ə nə: «Ananɨyasɨ», nɨngə Ananɨyasɨ ndɨgɨ ə nə: «Mi ne Ɓaɓe». ");
INSERT INTO bjvNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ɓaɓe təl un ta əl-e ə nə: «Aw un rəbɨ kɨ ɓari-e rəbɨ kɨ ko̰ tɨ, ə ɨdəjɨ me kəy tɨ lə Judasɨ, dəw kɨ tɔe nə Sol kɨ Tarsɨ tɨ, ɨsɨ no̰o̰ ɨsɨ əl ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","OO dəw madɨ kɨ tɔe nə Ananɨyasɨ me nḛ koo me ndɨl tɨ, ur kəy goe tɨ nɨngə, ɨndə jine dɔe tɨ kadɨ oo lo gogɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ə Ananɨyasɨ əl ə nə: «Ɓaɓe, m-o ta lə dəw kɨn ta dɨje tɨ ngay, ɔjɨ dɔ ko̰ je pətɨ kɨ adɨ dɨje ləi kɨ me ɓe tɨ kɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nɨngə, kɨ ne kɨn, re kɨ tɔgɨ kɨ ɨngə rɔ kɨ boy je tɨ lə njé kɨjə nḛ məsɨ kadɨ kare je, kadɨ uwə dɨje kɨ ɨsɨ əli səi ta, dɔɔ-de.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nə Ɓaɓe əl-e ə nə: «Aw, tadɔ dɨngəm kɨn e nḛ ra kɨlə kɨ m-kɔte kadɨ əl ta ləm no̰ gɨn dɨje tɨ kɨ dunɨya̰ tɨ, kɨ no̰ ngar je tɨ, kɨ no̰ *Isɨrayəl je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi wa m-a m-ɔje ko̰ je pətɨ kɨ a tḛḛ dɔe tɨ kɨ mbata ləm.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananɨyasɨ aw, ur kəy ɨndə jine dɔe tɨ, nɨngə əl-e ə nə: «NGokom Sol, e Ɓaɓe ə ɨlə-m, e Jəju ka kɨ tḛḛ ɨngəi dɔ rəbɨ tɨ kɨ ɨsɨ re-n ka kɨn ə ɨlə-m kadɨ m-adi o lo. Nɨngə kadɨ NDɨl Luwə rɔsi tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ta naa tɨ no̰o̰, nḛ je kɨ toi tə ngɔy kanjɨ je be tḛḛi kəm Sol tɨ tosi, adɨ təl oo lo gogɨ, nɨngə ḭ taa adɨ rai-e batəm. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Go tɨ, uso nḛ ɓa, təl ɨngə tɔgɨ nḛ gogɨ. Sol təl ɨsɨ kɨ njé ndo je lə Jəju kɨ me ɓe tɨ kɨ Damasɨ ngan ndɔ je jɔ ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ta naa tɨ no̰o̰, Sol aw ɨlə mbḛ me kəy kaw-naa je tɨ lə *Jɨpɨ je ə nə: «Jəju e NGon Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Dɨje pətɨ kɨ ooi dɔ ta kɨn ta Sol tɨ, ndɔjɨ-de ngay adɨ əli əi nə: «E kam al ə e nje kadɨ ko̰ dɨje kɨ Jorijaləm tɨ kɨ njé ɓa tɔ kɨn a? Re nḛ a un gɨrə mba kadɨ uwə-de, dɔɔ-de aw səde rɔ kɨ boy je tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je al bɨtɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nə Sol uwə rɔne nga̰ adɨ kəme e kəte me kadɨ-me tɨ lie. Jɨpɨ je kɨ Damasɨ tɨ gəri lo ta kɨ kadɨ əli-e al, lokɨ tɔjɨ-de kadɨ Jəju e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ra ndɔ je go tɨ ɓa, Jɨpɨ je ɔji-naa ta mba kadɨ n-tɔli-e ");
INSERT INTO bjvNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nə ta kɔjɨ ləde tḛḛ mbi Sol tɨ. NGəmi ta rəbɨ kada je kondɔ je mba kadɨ n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Be ə, me kondɔ tɨ madɨ, njé ndo je lə Sol, uni-e me kare tɨ, tuyi-e adɨ osɨ gɨdɨ ndogɨ bɔr tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Go tɨ, Sol aw tḛḛ me ɓe tɨ kɨ Jorijaləm ɓa, sangɨ kadɨ n-ɨndə rɔne naa tɨ kɨ njé ndo je, nə pətɨ ɓəli-e, tadɔ dəw kɨ taa mee kadɨ e nje ndo kɨ rɔjetɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Be ə, Barnabasɨ un-e me jine tɨ, aw sie rɔ njé kaw kɨlə je tɨ, ɔr-de go kɨngə kɨ Jəju ɨngə Sol dɔ rəbɨ tɨ, kɨ koo kɨ oo Jəju əl-e ta, kɨ ta kɨ əl kɨ taga wangɨ Damasɨ tɨ me tɔ Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dɔ gangɨ loe tɨ no̰o̰, Sol aw səde je, təl səde je naa tɨ me ɓe tɨ kɨ Jorijaləm. Əl ta kɨ kadɨ-me me tɔ Ɓaɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Əl ta kɨ *Jɨpɨ je kɨ njé kəl ta Gɨrəkɨ, naji-naa səde ta tɨ. Nə sangi rəbɨ kadɨ n-tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lokɨ ngako̰je je ooi tae nɨngə, ɔri-e awi sie Səjare tɨ. Nɨngə adi-e aw me ɓe tɨ kɨ Tarsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","*NJé kaw-naa je pətɨ kɨ dɔnangɨ Jude tɨ kɨ tae ba, kɨ dɔnangɨ Galile tɨ, kɨ dɔnangɨ *Samari tɨ, ɨsi kɨ Lapɨya. Ɨngəi tɔgɨ, njɨyəi me ɓəl Ɓaɓe tɨ, taa kɔrde ḭ kɨ dɔ tɨ dɔ tɨ kɨ takul tɔgɨ lə NDɨl Luwə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Təkɨ Pɨyər a njɨyə-n kɨ lo je pətɨ oo-n dɨje lə Luwə, ndɔ kare aw tḛḛ rɔ njé tɨ kɨ me ɓe tɨ kɨ Lɨda. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lo kɨn tɨ, ɨngə dɨngəm kare kɨ tɔe nə Ene, kɨ to dɔ tɨrə mo̰y tɨ ra ɓal jijoo. Tadɔ rɔe oy. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pɨyər əl-e ə nə: «Ene, Jəju Kɨrɨsɨ adi rɔ nga, ḭ taa, ɨkaw nḛ toi.» Nɨngə Ene ḭ taa ta naa tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Dɨje pətɨ kɨ me ɓe tɨ kɨ Lɨda kɨ Saro̰ ooi-e, ɓa adi mede Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Dəne madɨ e dan njé ndo je tɨ kɨ me ɓe bo tɨ kɨ Jope no̰o̰, tɔe nə Tabɨta. Tɔ kɨn kɨ ta Gɨrəkɨ nə Dorkasɨ. E dəne kɨ njé ra kɨlə je kɨ majɨ majɨ ngay, taa e nje ra kɨ njé ndoo je kɨ nḛ kɨ me jine tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mo̰y ra-e dɔkagɨloe tɨ kɨn adɨ oy. Lokɨ ndogi-e man nɨngə, awi ɨləi-e me kəy tɨ kɨ kare taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓe kɨ Lɨda e ɓasi kɨ Jope. Be ə, lokɨ njé ndo je ooi kadɨ Pɨyər e me ɓe tɨ kɨ Lɨda no̰o̰ nɨngə, ɨləi dɨngəm je joo rɔe tɨ kadɨ re kalangɨ ɨngə-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pɨyər ḭ taa aw səde. Lokɨ re tḛḛ rɔde tɨ nɨngə, ɔri-e awi sie me kəy tɨ kɨ taa. NJé ngaw koy je pətɨ ɨləi-naa gəi dɔe kɨ no̰, nɨngə tɔji kɨbɨ je kɨ dangɨ dangɨ kɨ kojɨ ta naa tɨ kɨ Dorkasɨ ojɨ dɔkagɨlo tɨ kɨ ɨsɨ-n səde kɨ dɔne taa ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pɨyər adɨ dɨje pətɨ tḛḛi taga, ɓa ɔsɨ məkəsɨne nangɨ əl ta kɨ Luwə, nɨngə tu rɔne kɨ rɔ nɨn tɨ əl ə nə: «Tabɨta ḭ taa.» Lokɨ tḛḛ kəmne oo Pɨyər nɨngə, ndu rɔne, ḭ ɨsɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pɨyər ɨlə jine un-e-n kɨ taa, ɓa, ɓa dɨje lə Luwə kɨ njé ngaw koy je, ɔjɨ-de Tabɨta kɨ dɔe taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Poy nḛ kɨn sane kɨ dɔnangɨ kɨ Jope ba pətɨ, adɨ dɨje ngay adi mede Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pɨyər ra ndɔ asɨ tatɨ me ɓe tɨ kɨ Jope, me kəy tɨ lə nje kɔr gɨdɨ ngɨrə kɨ tɔe nə Sɨmo̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dɨngəm madɨ ɨsɨ me ɓe tɨ kɨ Səjare no̰o̰, tɔe nə Kɔrnəy. E kɨ boy dɔ ɓutɨ asɨgar je tɨ kɨ ɓu kare, kɨ ɓari-e «ɓutɨ kɨ Itali tɨ». ");
INSERT INTO bjvNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","E dəw kɨ nje ra nḛ kɨ go ndu Luwə tɨ, taa, naa tɨ kɨ dɨje pətɨ kɨ me kəy tɨ lie, əi njé kɔsɨ dɔde nangɨ no̰ Luwə tɨ tɔ. Ra majɨ kɨ njé ndoo je ngay, taa əl ta kɨ Luwə taa taa tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","NDɔ kare, kɨ kadɨ kɨ mɨtə kɨ lo sɔlɔ, oo malayka lə Luwə me nḛ koo me ndɨl tɨ ur me kəy tɨ lie, nɨngə ɓar-e ə nə: «Kɔrnəy.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrnəy ur kəmne dɔe tɨ kɨ ɓəl, nɨngə əl-e ə nə: «E ri ə Ɓaɓe?» NGa ə malayka əl-e ə nə: «Kəl ta kɨ Luwə ləi kɨ majɨ kɨ ɨsɨ ra kɨ njé ndoo je kɨn tḛḛ rɔ Luwə tɨ, ə Luwə ga dɔi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nɨngə kɨ ngɔsɨne kɨn, ɨlə dɨngəm je me ɓe tɨ kɨ Jope adɨ ɓari Sɨmo̰ kɨ ɓari-e nə Pɨyər ade re. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ɨsɨ me kəy tɨ lə Sɨmo̰ kɨ nje kɔr gɨdɨ ngɨrə kɨ kəy lie e kadɨ batɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lokɨ malayka kɨ əl-e ta kɨn ɔtɨ nɨngə, Kɔrnəy ɓa ngan njé kɨlə je ləne joo kɨ nje rɔ ləne kare kɨ nje ɓəl Luwə mbo̰ njé kɨ əi naa tɨ sie kɨ dɔkagɨlo je pətɨ adɨ-de rəi. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Rəi adɨ ɔr-de go nḛ je pətɨ kɨ ra nḛ adɨ-de ooi nɨngə, ɨlə-de adɨ awi Jope tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lo ti go tɨ, lokɨ əi dɔ rəbə ɨsɨ awi, ɨndəi dɔ ɓe bo ɓasi nɨngə, Pɨyər al dɔ kəy tɨ kɨ taa, kɨ kadɨ kɨ dan ɓe tɨ mba kəl ta kɨ Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɓo ra-e adɨ ge kuso nḛ. Nɨngə lokɨ ɨsɨ rai nḛ kuso mba kadɨ uso ɓa, oo nḛ me ndɨl tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","OO ta dɔra̰ a tagɨra, nɨngə oo nḛ madɨ kɨ to tə ta kɨbɨ kɨ tatɨ kɨ dəw uwə sɨle je kɨ sɔ be ə ḭ kɨ taa ɨsɨ re kɨ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Me nḛ tɨ ka kɨn, da je kɨ dangɨ dangɨ əi tɨtɨ: da je kɨ njade e sɔ je, kɨ njé kagɨ nangɨ je, kɨ yəl je. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nɨngə, ndu ta madɨ tḛḛ əl-e ə nə: «Pɨyər, ḭ taa ɨtɔl uso.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nə Pɨyər ə nə: «Jagɨ Ɓaɓe, mi m-uso nḛ kɨ nḛ kɨ majal ɔde, ə se nḛ kɨ to njḛ nja kare al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","NDu ta təl re əl Pɨyər kəl kɨ ko̰ joo ɓəy ə nə: «Nḛ kɨ Luwə təl-e kɨ kay njay tɨ, kadɨ ḭ o-e tə e nḛ kɨ to njḛ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nḛ kɨn ra nḛ be nja mɨtə, nɨngə ta naa tɨ no̰o̰ təli ndɔri-e kɨ dɔra̰ tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pɨyər gər me nḛ kɨ oo me ndɨl tɨ kɨn al, adɨ ɨsɨ dəjɨ rɔne ta dɔ tɨ, nɨngə yə dɨngəm je kɨ Kɔrnəy ɨlə-de kɨ a sangi kəy lə Sɨmo̰ rəi ai ta kəy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓa dəji ta kɨ ndude kɨ boy ə nə: «E me kəy kɨn ə Sɨmo̰ kɨ ɓari-e nə Pɨyər ɨsɨ tɨ tɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pɨyər ɨsɨ mər ta dɔ nḛ tɨ kɨ oo me ndɨl tɨ kɨn ba ɓəy nɨngə, NDɨl Luwə əl-e ə nə: «O dɨngəm je mɨtə a sangi-ni. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ḭ taa, ur nangɨ, ə aw səde kɨ kanjɨ kadɨ mei tɔsɨ, tadɔ e mi ə m-ɨlə-de.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pɨyər re rɔ dɨngəm je tɨ ka kɨn əl-de ə nə: «E mi ə mi dəw kɨ ɨsɨ ɨsangi-e, ə se e ri ə ɨsɨ ɨsangi-mi wa?» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Əli-e əi nə: «E Kɔrnəy kɨ e kɨ boy dɔ ɓutɨ asɨgar je tɨ kɨ ɓu, kɨ e dəw kɨ dana, taa e nje ɓəl Luwə tɔ kɨn ə ɨlə-je. E dəw kɨ *Jɨpɨ je pətɨ əli ta lie majɨ. Malayka lə Luwə re tḛḛ kɨ dɔ ta rɔe tɨ əl-e kadɨ ɨlə goi tɨ kadɨ ɨre me kəy tɨ lie kadɨ oo dɔ ta kɨ tai tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pɨyər aw səde ra-de mba, adɨ-de lo toi. Lokɨ lo ti go tɨ nɨngə, ḭ taa aw səde. NGako̰je je madɨ kɨ me ɓe tɨ kɨ Jope dani-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lo ti kɨ rangɨ nɨngə tḛḛi Səjare tɨ. Kɔrnəy ɓar nojɨne je kɨ madɨne je ɨsɨ ngɨnə-n-de kəte. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lokɨ Pɨyər ur me kəy tɨ nɨngə, Kɔrnəy ḭ taa tɨlə kəme, ɓa osɨ nanga njae tɨ, ɨlə dɔne nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nə Pɨyər əl-e ə nə: «Ḭ taa, tadɔ mi ka mi dəw tɔ.» Nɨngə ɔsɨ sɔle un-e-n kɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wali-naa taa urii kɨ kəy nɨngə, Pɨyər oo kosɨ dɨje ngay kawi-naa ɨsi. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lo kɨn tɨ Pɨyər əl-de ə nə: «Səi je, ɨgəri majɨ təkɨ ndu-kun ləje ɔgɨ kadɨ dəw kɨ e Jɨpɨ ɨndə rɔne naa tɨ kɨ dəw kɨ e Jɨpɨ al, ə se kadɨ ur me kəy tɨ lie. Nə Luwə əl-m kadɨ m-o dəw madɨ tə nḛ kɨ majal, ə se nḛ kɨ to njḛ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","E mbata kɨn ə, m-mbatɨ-n ɓa ləsi al, m-re kɨ kanjɨ kəl ta madɨ kɨ rangɨ. Nɨngə təkɨ ɨɓari-mi, m-dəjɨ səsi kadɨ m-o se e ri ə ɨləi gom tɨ wa?» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrnəy ə nə: «Asɨ ndɔ sɔ ɓone, kɨ dɔ kadɨ kɨ təkɨ made wa kɨn be, adɨ e kadɨ kɨ mɨtə kɨ lo sɔlɔ, ə m-ɨsɨ m-əl ta kɨ Luwə me kəy tɨ ləm, nɨngə dɨngəm madɨ kɨ ɨlə kɨbɨ kɨ nda bal bal tḛḛ a no̰m tɨ, əl-m ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Kɔrnəy, Luwə oo dɔ ta kɨ ɨsɨ əl sie, taa ga dɔ majɨ tɨ kɨ ɨsɨ ra kɨ njé ndoo je kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ə kadɨ ɨlə dəw madɨ Jope tɨ, ɨɓar Sɨmo̰ kɨ ɓari-e nə Pɨyər adɨ re. Ɨsɨ me kəy tɨ lə Sɨmo̰ kɨ nje ra kɨlə ngɨrə, kɨ ɨsɨ kadɨ ba tɨ ɓasi.” ");
INSERT INTO bjvNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɓe ə, ta naa tɨ no̰o̰ par, m-ɨlə-de rɔi tɨ, ə yə ɨra majɨ adɨ ɨre tɔ kɨn. Nɨngə kɨ ngɔsɨne kɨn, je pətɨ j-ɨsɨ no̰i tɨ ne kadɨ j-o dɔ ta je pətɨ kɨ Ɓaɓe ɨndə tai tɨ kadɨ əl-je.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lo kɨn tɨ, Pɨyər un ta tane tɨ əl ə nə: «Tə kɨ rɔjetɨ, m-gər kadɨ kɔr kəm dəw dana goto rɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dəw kɨ ra ra, dan gɨn dɨje tɨ kɨ dangɨ dangɨ, kɨ e nje ɓəl ndɨle, kɨ nje ra nḛ kɨ dana ɓa, uwe kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ɨlə kɨ ta ləne kɨ rɔ ngan *Isɨrayəl je tɨ, ɨlə-n-de mbḛ lapɨya kɨ takul Jəju Kɨrɨsɨ kɨ e Ɓaɓe lə dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Təkɨ ɨgəri, e nḛ kɨ ɨlə ngɨrəne Galile tɨ, go batəm tɨ kɨ Ja̰ ɨlə mbḛe ə ra nḛ dɔnangɨ Jude tɨ ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ɨgəri kadɨ kɨ Luwə adɨ Jəju kɨ Najarətɨ tɨ NDɨlne, kɨ tɔgɨ kɨn majɨ. Jəju aw kɨ lo lo, ra majɨ kɨ dɨje, taa ajɨ dɨje pətɨ kɨ ɨsi gɨn tɔgɨ tɨ lə su tɔ. Tadɔ Luwə e sie naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Je ə je njé ma najɨ dɔ nḛ je tɨ pətɨ kɨ ra dɔnangɨ tɨ lə *Jɨpɨ je kɨ Jorijaləm tɨ. Ɓəi-e kagɨ-dəsɨ tɨ, tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nə Luwə ade ḭ lo koy tɨ ndɔ kɨ ko̰ mɨtə lə ndɔ koye. Ade ta rəbɨ adɨ tɔjɨ rɔne taga, ");
INSERT INTO bjvNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kɨ rɔ dɨje tɨ pətɨ al, nə kɨ rɔ njé ma najɨ je tɨ kɨ Luwə kɔtɨ-de kəte. Adɨ e je kɨ j-uso sie je, j-a̰y sie je, go tḛḛe dan njé koy je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jəju un ndune adɨ-je kadɨ j-ɨlə mbḛ kɨ rɔ gɨn dɨje tɨ, ə kadɨ jɨ tɔjɨ təkɨ e nḛ ə yə Luwə ɨndə-ne tə nje gangɨ ta dɔ njé kɨsɨ kɨ dɔde taa tɨ kɨ njé koy je. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","*NJé kəl ta je kɨ ta Luwə tɨ pətɨ mai najɨ dɔe tɨ əli əi nə: “Dəw kɨ ra kɨ ade mene ɓa, Luwə a ɨyə̰ go majal je lie kɔ me tɔe tɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lokɨ Pɨyər ɨsɨ əl ta je kɨn ba ɓəy nɨngə, NDɨl kɨ kay njay rɨsɨ kɨ dɔ dɨje tɨ kɨ ɨsɨ ooi dɔ ta lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nḛ kɨn ətɨ ɓəl njé kadɨ mede Luwə kɨ əi Jɨpɨ je kɨ dani Pɨyər, lokɨ ooi kadɨ Luwə ɓukɨ NDɨlne dɔ gɨn dɨje tɨ kɨ əi Jɨpɨ je al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tadɔ ooi ndude ɨsɨ əli ta kɨ ta ɓe je kɨ dangɨ dangɨ ɨləi tɔjɨ dɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Nɨngə Pɨyər əl ə nə: «Kɨ təkɨ ɨngəi NDɨl Luwə tə je be tɔ kɨn, nḛ kɨ ɔgɨ-de dɔ ra batəm goto.» ");
INSERT INTO bjvNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Be ə Pɨyər un ndune adɨ rai-de batəm me tɔ Ɓaɓe tɨ, ɓa go tɨ, dəji Pɨyər kadɨ ɨsɨ səde ngan ndɔ je ɓəy taa kadɨ tə təl. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","*NJé kaw kɨlə je kɨ ngako̰ je kɨ ɨsi Jude tɨ ooi kadɨ dɨje kɨ əi *Jɨpɨ je al ka oi ta lə Luwə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lokɨ Pɨyər aw Jorijaləm tɨ, njé kadɨ mede Luwə, kɨ əi njé kɨjə mɔtɨde je gaki-e ngay, ");
INSERT INTO bjvNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","əi nə: «Aw rɔ dɨje tɨ kɨ ɨjəi mɔtɨde al, aw uso səde nḛ!» ");
INSERT INTO bjvNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lo kɨn tɨ, Pɨyər ɨlə rɔne ɔr-de go nḛ je kɨ rai nḛ kɨ goe goe adɨ-de ooi. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Pɨyər əl ə nə: «Mi me ɓe bo tɨ kɨ Jope, nɨngə lokɨ m-ɨsɨ m-əl ta kɨ Luwə, m-o nḛ me ndɨl tɨ. E nḛ madɨ kɨ to tə ta kɨbɨ kɨ tatɨ kɨ dəw uwə sɨle je kɨ sɔ be ə ḭ dɔra̰ tɨ, rɨsɨ bɨtɨ re no̰m tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","M-ur kəm kɨ dɔ ta kɨbɨ tɨ ka kɨn m-ɨsɨ m-go̰, nɨngə m-o da je kɨ njade e sɔ, kɨ njé kagɨ nangɨ, kɨ da je kɨ wale kɨ yəl je kɨ njé nal kadɨ ra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nɨngə m-o ndu ta madɨ əl-m ə nə: “Pɨyər, ḭ taa, ɨtɔl uso.” ");
INSERT INTO bjvNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ə m-əl m-ə nə: “Jagɨ Ɓaɓe, nḛ kɨ to njḛ ɔdɨ tam nja kare al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ko̰ joo, ndu ta təl tḛḛ dɔra̰ tɨ ɓəy əl-m ə nə: “Nḛ kɨ Luwə təl-e kɨ kay njay tɨ ɓa, kadɨ o-e tə nḛ kɨ to njḛ al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nḛ kɨn ra nḛ be asɨ nja mɨtə, nɨngə təli tuyi-e dɔra̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nɨngə ta naa tɨ no̰o̰, dɨngəm je mɨtə kɨ ɨləi-de me ɓe kɨ Səjare tɨ, kɨ rɔm tɨ rəi ay ta kəy tɨ kɨ m-ɨsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","NDɨl əl-m kadɨ m-aw səde ɓɨ m-mbatɨ al. E be ə dɨngəm je kɨ mehḛ kam dani-mi, ə j-ur-n me kəy tɨ lə Kɔrnəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kɔrnəy ɔjɨ-je go rəbɨ kɨ n-oo-n malayka kɨ tḛḛ kɨ rɔne tɨ, me kəy tɨ ləne, əl ə nə: “Ɨlə dəw madɨ me ɓe tɨ kɨ Jope kadɨ əl Sɨmo̰ kɨ ɓari-e Pɨyər kadɨ re. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A əli nḛ je kɨ a ra səi kadɨ ɨngə kajɨ naa tɨ kɨ njé kɨ me kəy tɨ ləi.” ");
INSERT INTO bjvNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lokɨ m-a m-əl ta ba ɓəy nɨngə, NDɨl Luwə rɨsɨ re dɔde tɨ təkɨ ndɔ kɨ re-n dɔje tɨ lo kɨlə ngɨre tɨ ka kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ra adɨ mem ole dɔ ta tɨ lə Ɓaɓe kɨ ə nə: “Ja̰ ra batəm me man tɨ, nə səi je, a rai səsi batəm me NDɨl Luwə tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ə se, təkɨ Luwə adɨ-n-de kadɨ-kare kɨ kare wa təkɨ adɨ-n-je, j-əi kɨ j-adi meje Ɓaɓe Jəju Kɨrɨsɨ kɨn, kadɨ mi m-ndor Luwə wa?» ");
INSERT INTO bjvNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lokɨ ooi dɔ ta kɨn nɨngə, angalde osɨ nangɨ adɨ ɨləi tɔjɨ dɔ Luwə tɨ əi nə: «Gɨn dɨje kɨ dunɨya̰ tɨ ka Luwə adɨ-de kajɨ kɨ go rəbɨ kɨyə̰ go majal kɔ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kɨndə kəm-ndoo kɨ tḛḛ dɔ Etɨyən tɨ ra adɨ njé ndo je sanəi-naa, awi bɨtɨ tḛḛi me ɓe tɨ kɨ Pənəsi, kɨ Sɨpɨr, kɨ A̰tɨyosɨ. Lokɨ awi, əli ta lə Luwə Jɨpɨ je par ɓɨ dəw kɨ rangɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","MBo̰de tɨ no̰o̰, dɨje kɨ na̰ je kɨ əi gɨn kojɨ tɨ kɨ Sɨpɨr, kɨ Sɨrən kɨ awi A̰tɨyosɨ tɨ, əli ta kɨ majɨ lə Ɓaje Jəju gɨn dɨje kɨ əi *Jɨpɨ je al kɨ ɓari-de Gɨrəkɨ je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tɔgɨ Ɓaɓe e səde naa tɨ adɨ dɨje ngay təli kɨ rɔ Ɓaɓe tɨ adi-e mede. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Poy nḛ je kɨ ra nḛ kɨn tḛḛ rɔ njé kaw-naa je tɨ kɨ ɨsi Jorijaləm, adɨ ɨləi Barnabasɨ adi-e aw A̰tɨyosɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lokɨ aw tḛḛ rɔde tɨ, ə oo me-majɨ lə Luwə kɨ ra kɨlə nɨngə, rɔe nəl-e ngay adɨ ɔsɨ gɨnde pətɨ kɨ ta lə Luwə kadɨ ai dɔ njade me kɨndə rɔ naa tɨ kɨ Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasɨ e dəw kɨ dana, NDɨl Luwə rose, taa aw kɨ kadɨ-me tɔ, adɨ kosɨ dɨje ngay rəi kɨ rɔ Ɓaɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabasɨ aw me ɓe tɨ kɨ Tarsɨ mba kadɨ sangɨ Sol. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lokɨ ɨnge nɨngə, aw sie A̰tɨyosɨ tɨ, rai ɓal kare tɨtɨ. Kawi-naa kɨ njé kaw-naa je, ndoi ta lə Luwə kosɨ dɨje ngay. E me ɓe tɨ kɨ A̰tɨyosɨ ə yə dɨje ɨləi ngɨrə ɓar njé ndo je tɨ, dɨje lə Kɨrɨsɨ (kɨrətɨyḛ je). ");
INSERT INTO bjvNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dɔkagɨloe tɨ no̰o̰, njé kəl ta je kɨ ta Luwə tɨ ḭḭ Jorijaləm awi bɨtɨ kɨ A̰tɨyosɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","E kɨ kare dande tɨ, tɔe nə Agabusɨ, ḭ taa nɨngə əl ta kɨ takul NDɨl təkɨ ɓo kɨ bo ngay a o̰ dɔnangɨ tɨ kɨ tae ba. Nɨngə nḛ ka kɨn ra nḛ dɔkagɨlo tɨ lə nje ko̰ɓe kɨ bo kɨ ɓari-e nə Kɨlodɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","*NJé ndo je uni ndude kadɨ n-ɨləi kɨ nḛ kɨ jide tɨ, na̰ na̰ kɨ go tɔge tɨ kadɨ n-dḭḭ ngako̰de je kɨ ɨsi Jude tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Adi nḛ majɨ je ləde ka kɨn Barnabasɨ əi kɨ Sol adɨ awi adi ngatɔgɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dɔkagɨloe tɨ wa kɨn ə ngar *Erodɨ ɨlə ngɨrə kadɨ ko̰ njé kaw-naa je kɨ na̰ je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tɔl Jakɨ kɨ ngoko̰ Ja̰ kɨ kɨyə kasɨgar. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nə Lokɨ oo kadɨ nəl *Jɨpɨ je ngay, nɨngə təl adɨ uwəi Pɨyər ɓəy. E dɔkagɨlo ra pətɨ mapa kɨ kanjɨ əm. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lokɨ uwe ɨle dangay tɨ nɨngə, adɨ njé rɔ je sɔ sɔ nja sɔ ngəmi-e. Ra be kadɨ tə n-tḛḛ sie taga no̰ kosɨ je tɨ go pətɨ pakɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pɨyər to dangay tɨ, nə njé kaw-naa je ɨyə̰i ta kəl ta kɨ Luwə al kɨ mbata lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Me kondɔe tɨ kɨ kadɨ re lo ti ə, Erodɨ tḛḛ sie no̰ kosɨ je tɨ ka kɨn nɨngə, Pɨyər to ɓi mbo̰ asɨgar je, dɔɔi-e kɨ kulə gɨndɨ joo. Nɨngə njé ngəm lo je, ai ta kəy tɨ, a ngəmi ta kəy dangay tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lo kɨn tɨ, malayka lə Ɓaɓe kare tḛḛ patɨ, adɨ kunje taa lo me kəy dangay tɨ, lo kɨ Pɨyər to tɨ. Malayka ɨndə Pɨyər kade tɨ ndəl-e-n ə nə: «Ḭ taa kalangɨ!» Ɓa kulə gɨndɨ je kɨ jie tɨ tḛḛi tosi. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malayka əl-e ə nə: «Ɨdɔɔ nda kɨ ɓədi tɨ, ə ɨtɨlə sa njay tɨ.» Nɨngə Pɨyər ra təkɨ əl-e-n. Malayka əl-e ɓəy ə nə: «Ɨlə kɨbɨ ləi rɔi tɨ ə un gom.» ");
INSERT INTO bjvNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pɨyər tḛḛ goe tɨ, nə gər təkɨ e malayka ə re tḛḛ sie təkɨ rɔjetɨ, al. OO təkɨ e nḛ kɨ oo me ndɨl tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lokɨ ɨndəi nje ngəm lo kɨ dɔ kəte, kɨ kɨ ko̰ joo dəi nɨngə, rəi tḛḛi ta ta rəbɨ gɨndɨ tɨ kɨ aw kɨ ɓe bo tɨ, ta rəbɨ wa tḛḛ dɔrɔne ba no̰de tɨ, adɨ tḛḛi taga awi dɔ rəbɨ tɨ. Lokɨ tḛḛi dɔ rəbɨ tɨ nɨngə, ta naa tɨ no̰o̰, malayka ɨyḛ ə aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Lokɨ angale re rɔe tɨ nɨngə əl ə nə: «M-o ay njay ngata təkɨ e Ɓaɓe ə ɨlə kɨ malayka ləne adɨ re tḛḛ səm ji Erodɨ tɨ, kɨ ta nḛ je tɨ kɨ majal pətɨ kɨ kosɨ Jɨpɨ je ɔji kadɨ rai səm.» ");
INSERT INTO bjvNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Lokɨ ga ta be nɨngə, ɨlə dɔne aw ɓe lə Mari kɨ ko̰ Ja̰ kɨ ɓari-e nə Markɨ. Dɨje ngay kawi-naa me kəy tɨ no̰o̰ ɨsɨ əli ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Lokɨ ɨndə ta kəy nɨngə, ngon nje kɨlə kɨ dəne kɨ tɔe nə Rodɨ ɔtɨ re kadɨ n-oo. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Gər ndu Pɨyər adɨ ta rəbɨ ka tḛḛ al par ə, rɔe nəl-e ngay adɨ təl kɨ ngɔdɨ aw əl-de ə nə Pɨyər a ta kəy tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Əli-e əi nə: «Ḭ nje kone.» Nə a dɔ ndune tɨ təkɨ e ta kɨ rɔjetɨ. NGa ə təli əli əi nə: «E malayka lie.» ");
INSERT INTO bjvNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Loe tɨ kɨn, Pɨyər a ta kɨndə ta kəy tɨ par par. Ə lokɨ rəi tḛḛi ta kəy nɨngə, e Pɨyər ə wa, adɨ gəri lo ta kɨ kadɨ əli al. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Əl-de ta kɨ jine kadɨ əli ta al, nɨngə ɔr-de go tḛḛ kɨ Ɓaɓe tḛḛ sie dangay tɨ adɨ gəri. Go tɨ, əl-de ə nə: «Awi əli Jakɨ kɨ ndəgɨ ngako̰je je adɨ ooi.» Nɨngə tḛḛ aw lo kɨ rangɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lokɨ lo ti nɨngə, dɔ asɨgar je ɨsɨ dana al. Dəji-naa se ri dana ə Pɨyər təl wa? ");
INSERT INTO bjvNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","NGar Erodɨ sange ngay nə ɨnge al. Go tɨ, dəjɨ ta asɨgar je, ɓa un ndune kadɨ tɔli-de kɔ. Pɨyər ɨyə̰ dɔnangɨ Jude ə ḭ aw Səjare tɨ, aw ɨsɨ tɨtɨ nu. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","*Erodɨ aw kɨ ta kɨ dɨje kɨ Tɨr tɨ, kɨ Sɨdo̰. Ə dɨje kɨ Tɨr kɨ Sɨdo̰ ɨndəi ndude naa tɨ rəi ɨngəi-e. Lokɨ ndogi me Bɨlasɨtusɨ kɨ nje koo go ta lə ngar Erodɨ taai nɨngə, dəji kadɨ lapɨya to dande tɨ. Kadɨ lapɨya to mbata nḛ majɨ je kɨ dɔnangɨ tɨ ləde ngɨre e me ɓe tɨ lə ngar Erodɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lokɨ tḛḛ me ndɔ tɨ kɨ ɔjɨ nɨngə, Erodɨ ɨlə kɨbɨ ko̰ɓe ləne rɔne tɨ, ɨsɨ dɔ kɨmbər ngar tɨ ləne, əl kosɨ dɨje ta kongɨ kongɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kosɨ dɨje ɨləi tɔjɨ dɔe tɨ əi nə: «E ndu luwə madɨ ɓɨ e ndu dəw al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Loe tɨ no̰o̰ malayka lə Ɓaɓe ɨnde ɔje mbata adɨ kɔsɨ-gon Luwə al. Go tɨ, kode je ɨndəi rɔe yəngɨ yəngɨ adɨ oy. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nə ta lə Luwə taa lo aw kɨ kəte kəte, adɨ kɔr njé ndo je re kɨ dɔ made tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lokɨ Barnabasɨ əi kɨ Sol tɔli kon kɨlə ləde kɨ awi kɨ mba kadɨ rai nɨngə, ɨyə̰i ɓe bo kɨ Jorijaləm ə awi. Uni Ja̰ kɨ ɓari-e Markɨ naa tɨ səde ə təli awi me ɓe tɨ kɨ A̰tɨyosɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","*NJé kəl ta je kɨ ta Luwə tɨ kɨ njé ndo nḛ je lə Luwə ɨsi dan njé kaw-naa je tɨ kɨ A̰tɨyosɨ tɨ no̰o̰. Adɨ e: Barnabasɨ kɨ Sɨmo̰ kɨ ɓari-e Nɨjər, kɨ Lɨsɨyusɨ kɨ ɓe lie e Sɨrən tɨ, kɨ Manaye kɨ oti-de naa tɨ kɨ *Erodɨ kɨ ɨsɨ dɔ dɔnangɨ tɨ kɨ Galile, kɨ Sol tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","NDɔ kare be ɔsi məkəsɨde nangɨ no̰ Luwə tɨ ə əli ta sie kɨ kɔgɨ rɔ nḛ kuso tɔ. Nɨngə NDɨl kɨ kay njay əl-de nə: «Kadɨ ɔri Barnabasɨ əi kɨ Sol ɨndəi-de ta dangɨ mbata kɨlə kɨ m-ɓar-de kadɨ rai.» ");
INSERT INTO bjvNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","NGata ə, lokɨ ɔgi rɔde nḛ kuso ə əli ta kɨ Luwə nɨngə, ɨndəi jide dɔde tɨ ə ɨyə̰i-de adɨ awi, ");
INSERT INTO bjvNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","təkɨ NDɨl kɨ kay njay əl-n-de. E be ə, Barnabasɨ əi kɨ Sol awi me ɓe tɨ kɨ Sələsi. Nɨngə ai no̰o̰ gangi awi Sɨpɨr tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lokɨ kɨ tḛḛi Salamɨn tɨ nɨngə, əli ta lə Luwə me kəy kaw-naa tɨ lə *Jɨpɨ je. Ja̰ Markɨ e kadɨde tɨ tə nje ra səde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lokɨ ɨndəi dɔ dər je kɨ ɓe tɨ kɨ Sɨpɨr tɨ gangi nɨngə, awi tḛḛi me ɓe tɨ kɨ Paposɨ. Loe tɨ no̰o̰, ɨngəi Jɨpɨ kare be kɨ tɔe nə Bar-Jəju kɨ e nje ra mbəli, kɨ ə nə ne nje kəl ta kɨ ta Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ɨsi naa tɨ kɨ dəw kɨ boy kɨ tɔe nə Sərjɨyusɨ Polusɨ kɨ e nje nḛ gər. Sərjɨyusɨ Polusɨ ɓar Barnabasɨ əi kɨ Sol ɔjɨ-de adɨ gəri təkɨ n-aw kɨ ɓo koo ta lə Luwə tade tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nə Elɨmasɨ kɨ kɔr gɨn tɔe nə nje mbəli ta̰-de rɔ. Ge kadɨ dəw kɨ boy kɨn adɨ mene Kɨrɨsɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Be ə, Sol kɨ ɓari-e Pol NDɨl Luwə rose adɨ ur kəmne kɨ dɔe tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","əl-e ə nə: «Ḭ ngon lə su, tə dəw kɨ kədɨ kəm dɨje rosɨ mei. Ḭ nje kɔsɨ ta nḛ ra je kɨ dana pətɨ. A ɨyə̰ go rəbɨ ndor ta lə Luwə al a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kɨ ɓasɨne kɨn, Ɓaɓe a ɨndəi ɔji, kəmi a oo lo al, nɨngə a o kəm kadɨ al bɨtɨ dɔkagɨlo madɨ. Nɨngə ta naa tɨ no̰o̰ par ə kəme ndul kururu adɨ oo lo al, a mam lo. Sangɨ dəw kɨ kadɨ ɔr-e ta rəbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lokɨ dəw kɨ boy oo nḛ kɨ ra nḛ kɨn nɨngə, adɨ mene, mbata nḛ ndo kɨ dɔ Ɓaɓe tɨ kɨ adi-e, əte ɓəl ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol əi kɨ madɨne je ali me bato tɨ me ɓe tɨ kɨ Paposɨ, awi me ɓe tɨ kɨ Pərjɨ kɨ Pampɨli tɨ, nɨngə Ja̰ Markɨ ɨyə̰-de ə təl aw Jorijaləm tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lokɨ ɔti me ɓe tɨ kɨ Pərjɨ nɨngə, awi tḛḛi me ɓe tɨ kɨ A̰tɨyosɨ kɨ Pɨsɨdi tɨ, awi me kəy kaw-naa tɨ lə *Jɨpɨ je kɨ ndɔ taa kə̰ə̰, ɨsi nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lokɨ njé tɨdə makɨtɨbɨ je, tɨdəi makɨtɨbɨ ndu-kun kɨ makɨtɨbɨ lə njé kəl ta je kɨ ta Luwə tɨ nɨngə, kɨ boy je kɨ njé ngəm kəy kaw-naa ɨləi əli-de əi nə: «NGako̰je je, kɨn ə awi kɨ ta kadɨ əli dɨje, ə kadɨ əli.» ");
INSERT INTO bjvNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ə Pol ḭ taa, yəkɨ jine tade tɨ kadɨ ɨsi kekeke, nɨngə əl-de ə nə: «Səi *Isɨrayəl je kɨ dɨje kɨ njé ɓəl Luwə, kadɨ oi dɔ ta ləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Luwə ləje, j-əi kosɨ Isɨrayəl je, kɔtɨ bawje je, nɨngə ra səde adɨ oji naa kɨ kəte kəte, lokɨ ɨsi me ɓe tɨ kɨ Ejɨpɨ tɨ. Ɔr-de tḛḛ səde kɨ taga kɨ takul tɔge kɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Asɨ ɓal dɔsɔ kɨ adɨ-de nḛ usoi dɨlə lo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lokɨ tɔ ko gɨn dɨje sɨri kɨ dɔnangɨ tɨ kɨ Kana no̰de tɨ nɨngə, təl kɨ dɔnangɨ ka kɨn adɨ-de tə nḛ nduwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nḛ je pətɨ kɨ ra nḛ kɨn, a ra ɓal asɨ ɓu sɔ kɨ dɔmi. Go tɨ nɨngə, adɨ-de njé gangɨ ta je bɨtɨ tḛḛ-n dɔ nje kəl ta kɨ ta Luwə tɨ Samɨyəl. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɨngə, dəji ngar adɨ Luwə adɨ-de Sawul kɨ ngon lə Kɨsɨ, kɨ e gɨn ka tɨ lə Bənjame, adɨ o̰ ɓe dɔde tɨ ɓal dɔsɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lokɨ ɔr-e kɔ nɨngə, ɨndə *Dabɨdɨ ngar tɨ toe tɨ. Dabɨdɨ kɨ ma najɨ lie ə nə: “M-ɨngə Dabɨdɨ kɨ e ngon lə Jəse, kɨ e dəw kɨ go me ndɨgɨ tɨ ləm. A tɔl kon nḛ je pətɨ kɨ mem ndɨgɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","E gɨn ka tɨ lie ə, Luwə adɨ Jəju kɨ nje kajɨ Isɨrayəl tḛḛ tɨ, kɨ go kun mɨndɨ tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kəte no̰ re Jəju tɨ, Ja̰ ɨlə mbḛ kadɨ dɨje tɔri ndude, nɨngə kadɨ rai batəm. Ɨlə mbḛ kɨn kɨ rɔ kosɨ Isɨrayəl je tɨ ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lokɨ Ja̰ aw kadɨ tɔl ta kɨlə ləne nɨngə, əl ə nə: “Mi dəw kɨ ɨsɨ ɨgai ta dɔe tɨ kɨn al. Nə e a re gom tɨ no̰o̰ kɨ kɨlə sa kɨ njae tɨ ka mi m-asɨ tutɨ al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«NGakom je kɨ gɨn ka tɨ lə *Abɨrakam, kɨ njé ɓəl Luwə kɨ dansi tɨ, e j-əi je ə Luwə ɨlə kɨ ta kajɨ kɨn rɔje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dɨje kɨ njé kɨsɨ Jorijaləm tɨ əi kɨ kɨ boy je ləde gəri dəw kɨ e Jəju kɨn al, taa gəri me ta je lə njé kəl ta je kɨ ta Luwə tɨ, kɨ ɨsɨ tɨdəi kɨ ndɔ taa kə̰ə̰ je pətɨ kɨn al tɔ. Be ə lokɨ gangi ta dɔ Jəju tɨ, tɔli ta ta je kɨ njé kəl ta kɨ ta Luwə tɨ ndangi. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ɨngəi nḛ madɨ kare kɨ asɨ kadɨ tɔli-e-n al, nə dəji *Pɨlatɨ kadɨ tɔl-e par. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lokɨ tɔli kon nḛ je pətɨ kɨ ndangɨ me makɨtɨbɨ tɨ ɔjɨ dɔe nɨngə, adɨ rɨsi-e dɔ kagɨ-dəsɨ tɨ nangɨ, ɨle me ɓe nɨn tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nə Luwə ade ḭ dan njé koy je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Asɨ ndɔ ngay kɨ tḛḛ kɨ rɔ dɨje tɨ kɨ ḭḭ sie dɔnangɨ Galile tɨ nu, ə rəi sie bɨtɨ Jorijaləm tɨ, əi je kɨn ə əi njé ma najɨ lie kɨ no̰ kosɨ dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Je ka j-ɨsɨ j-ɨlə səsi mbḛ Poy Ta kɨ Majɨ kɨn tɔ. Poy Ta kɨ Majɨ kɨ e ta kun mɨndɨ kɨ Luwə un mɨndɨne dɔ tɨ adɨ bawje je. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Luwə tɔl ta kun mɨndɨ kɨn kɨ rɔje tɨ j-əi ngande je kɨ go rəbɨ tḛḛ kɨ adɨ Jəju tḛḛ lo koy tɨ təkɨ ndangi me makɨtɨbɨ pa je tɨ əi nə: “Ḭ NGonm, Kɨ m-oji ɓone.” ");
INSERT INTO bjvNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Luwə ade ḭ lo koy tɨ ɓɨ ade ndum me ɓe tɨ al, təkɨ əl-n ə nə: “M-a m-adɨ səsi nḛ, Kɨ m-un mɨndɨm dɔ tɨ m-adɨ Dabɨdɨ, Kɨ e nḛ kɨ asɨ kadɨ ɨndəi mesi dɔ tɨ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«E mbata kɨn ə, əl-n me makɨtɨbɨ tɨ lo madɨ tɨ ɓəy ə nə: “A ɨyə̰ dəw ləi kɨ ay njay kadɨ ndum al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nə Dabɨdɨ, lokɨ ra kɨlə dɔkagɨlo tɨ ləne kɨ go kɔjɨ ta ra tɨ lə Luwə nɨngə, oy adɨ dɨbi-e gədɨ kae je tɨ, nɨngə ndum me ɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nə e kɨ Luwə ade ḭ lo koy tɨ ndum me ɓe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Kadɨ ɨgəri majɨ ngakom je, təkɨ e kɨ takule ə ɨsɨ oi dɔ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ kɨyə̰ go majal kɔ, kɨ kɔr ta dɔ tɨ kɨ asi kadɨ ɨngəi me ndu-kun lə *Mojɨ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","E kɨ takule tɔ ə, re dəw kɨ adɨ mene nɨngə, a ɨngə ta kɨ kɔr dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","MBata kɨn ə, kadɨ oi go rɔsi majɨ nə tə ta kɨ njé kəl ta kɨ ta Luwə tɨ əli kɨn tae tɔl dɔsi tɨ: ");
INSERT INTO bjvNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","*NJé kəl ta je kɨ ta Luwə tɨ əli əi nə: “Səi njé kɔjɨ rɔsi, Kadɨ oi go rɔsi majɨ, A oi nḛ kɨ a ətɨ səsi ɓəl bɨtɨ kadɨ a gotoi kɔ. Tadɔ dɔkagɨlo tɨ ləsi, m-a m-ra nḛ madɨ. Nḛ kɨ re dəw ɔr səsi poye ka, a adi mesi dɔ tɨ al.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lokɨ Pol əi kɨ Barnabasɨ ɨsɨ tḛḛi taga nɨngə, dəji-de kadɨ ndɔ taa kə̰ə̰ kɨ gogɨ ə kadɨ təli rəi ndoi-de ta kɨn ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lokɨ kosɨ njé kaw-naa je sanəi-naa nɨngə, Jɨpɨ je kɨ dɨje kɨ təli Jɨpɨ je, dani Pol əi kɨ Barnabasɨ, a wali-naa ta səde. Nɨngə Pol əi kɨ Barnabasɨ ɨləi dɨngəm mede tɨ kadɨ uwəi rɔde ba me me-majɨ tɨ lə Luwə kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","*NDɔ taa kə̰ə̰ tɨ kɨ gogɨ nɨngə, kosɨ dɨje ngay kɨ me ɓe bo tɨ kawi-naa kɨ naa tɨ kadɨ n-ooi dɔ ta lə Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lokɨ *Jɨpɨ je ooi kosɨ dɨje nɨngə, ni ra-de adɨ taji Pol, ə əli ta je kɨ mal dɔ ta tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol əi kɨ Barnabasɨ əli-de kɨ me kɨ tḭ katɨ əi nə: «E səi je ə kadɨ j-ɨlə səsi mbḛ ta kɨn kəte, nə təkɨ ɨmbati ə oi təkɨ səi je asi ta kajɨ kɨ bɨtɨ kɨn al, je j-a jɨ təl jɨ yətɨ rɔje kɨ rɔ gɨn dɨje tɨ kɨ əi Jɨpɨ je al tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tadɔ Ɓaɓe ləje un ndune adɨ-je ə nə: “M-ɨndə-i kadɨ ḭ kunjɨ kɨ mbata gɨn dɨje kɨ dɔnangɨ tɨ, Kɨ mbata kadɨ aw kɨ ta kajɨ bɨtɨ kɨ dɔbəy dɔnangɨ tɨ.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Lokɨ gɨn dɨje kɨ əi Jɨpɨ je al ooi dɔ ta kɨn nɨngə, rai rɔnəl ngay dɔ tɨ, adɨ ɨləi tɔjɨ dɔ ta tɨ lə Ɓaɓe, adɨ dɨje pətɨ kɨ Luwə kɔtɨ-de kɨ mbata kajɨ kɨ bɨtɨ kɨ no̰ tɨ, adi mede. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ta lə Ɓaɓe sane kɨ dɔnangɨ kɨ A̰tɨyosɨ tɨ kɨ tae ba. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nə Jɨpɨ je suləi dəne je kɨ əi dəne je kɨ njé tɔɓa kɨ me ɓe tɨ, kɨ njé kɔsɨ məkəsɨde nangɨ no̰ Luwə tɨ, kɨ dɨje kɨ boy kɨ me ɓe tɨ adɨ ɨndəi kəm Pol əi kɨ Barnabasɨ ndoo, nɨngə tɨbəi-de me ɓe tɨ ləde kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pol əi kɨ Barnabasɨ ɨndəi bu kɨ njade tɨ kɨ dɔ ɓe tɨ ləde nɨngə, ɔti awi me ɓe tɨ kɨ Ikonɨyom. ");
INSERT INTO bjvNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kɨ rɔ njé ndo je tɨ lə Jəju ɓa, rɔde nəl-de ngay, taa NDɨl Luwə ka rosɨ mede tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Lokɨ Pol əi kɨ Barnabasɨ awi Ikonɨyom tɨ, awi me kəy kaw-naa tɨ lə *Jɨpɨ je kɨ Ikonɨyom tɨ tɔ. Awi əli dɨje ta lə Luwə kəl kɨ ra adɨ dɨje ngay kɨ əi Jɨpɨ je kɨ njé kɨ əi Gɨrəkɨ je adi mede Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nə Jɨpɨ je madɨ kɨ njé me nga̰, ɨndəi ta kɨ majal me dɨje tɨ kɨ əi Jɨpɨ je al, suləi-de dɔ ngako̰je je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Be ka, Pol əi kɨ Barnabasɨ ɨsi Ikonɨyom tɨ ndɔ ba̰y ba̰y. Əli ta lə Luwə kɨ me kɨ tḭ katɨ, ɨndəi tɔgɨde dɔ Ɓaɓe tɨ kɨ ma najɨ dɔ me-majɨ tɨ lie kɨ ɨsɨ ɨləi mbḛe, adɨ-de tɔgɨ adɨ rai nḛ kɔjɨ je kɨ nḛ je kɨ ətɨ ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lo kɨn tɨ, dɨje kɨ me ɓe bo tɨ gangi naa lo joo, njé kɨ madɨ je əi go Jɨpɨ je tɨ, njé kɨ nungɨ əi go njé kaw kɨlə je tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","NJé kɨ əi Jɨpɨ je al, kɨ njé kɨ əi Jɨpɨ je, kɨ kɨ bo je ləde ɨndəi dɔ rɔde dana kadɨ n-adi ko̰ Pol əi kɨ Barnabasɨ, kadɨ n-tɨləi-de kɨ mbal n-tɔli-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nə Pol əi kɨ Barnabasɨ ooi ta kɨn, adɨ a̰yḭ-naa awi ɓɔyɔi rɔde ɓe bo je tɨ kɨ Lɨkawoni, kɨ Lɨsɨtɨr, kɨ Dərbɨ, kɨ ngan lo je kɨ gɨdɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Lo je tɨ kɨn ka, ɨləi mbḛ Poy Ta kɨ Majɨ tɨtɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Me ɓe tɨ kɨ Lɨsɨtɨr, dɨngəm kare kɨ njae oy ta gɨne tɨ ɨsɨ no̰o̰. NJae oy lo koje tɨ nu, adɨ njɨyə nja kare al. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ə ndɔ kare, ur mbine ɨsɨ oo-n ta kɨ Pol a əl. Ɓa, Pol uwə kəmne kɨ dɔe tɨ oo-e-n ba nɨngə, oo kadɨ aw kɨ kadɨ-me kɨ kadɨ ɨngə-n kajɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Lo kɨn tɨ, Pol əl-e ta kɨ tɔgɨne ə nə: «Ḭ, a taa dɔ njai tɨ!» Ɓa Dɨngəm ɨbə nangɨ ḭ a taa, a njɨyə. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lo kɨ kosɨ dɨje ooi nḛ kɨ Pol ra kɨn nɨngə, uni ndude kɨ taa, əli ta kɨ ta lɨkawoni əi nə: «Yo je təli rɔde dɨje tɨ, rəi uri nangɨ danje tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Be ə, ɓari Barnabasɨ «Jəsɨ», ə ɓari Pol «Ərməsɨ» tɔ, mbata Pol ə e nje kəl ta. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","NJe kɨjə nḛ məsɨ kadɨ-kare lə Jəsɨ, kɨ ɨsɨ ta lo tɨ taga gɨdɨ ɓe bo tɨ, re kɨ baw mangɨ je kɨ tɔy nḛ je kɨ ndole rɔde tɨ. Re səde, nɨngə, ndude e naa tɨ kɨ kosɨ je, kadɨ n-ɨləi məsɨ n-adi Pol əi kɨ Barnabasɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nə lokɨ, njé kaw kɨlə je, Pol əi kɨ Barnabasɨ ooi poy ta kɨn, gangi kɨbɨ rɔde tɨ, ɓa a̰yḭ-naa kɨ rɔ kosɨ je tɨ, uni ndude kɨ taa, əli-de əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Madɨje je, ra ban ə a rai nḛ be ə? Je ka je dɨje tə səi be tɔ, nɨngə, re j-ɨlə səsi mbḛ Poy Ta kɨ Majɨ nɨngə, e mba kadɨ ɨyə̰i kagɨ yo je kɨ ndade goto kɨ ɨsɨ rai-de, ə kadɨ ɨtəli rɔsi go Luwə tɨ kɨ nje kɨsɨ kəm ba, Luwə kɨ nje ra dɔra̰ kɨ dɔnangɨ kɨ nḛ je pətɨ kɨ me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dɔkagɨlo je tɨ kɨ man kəte, Luwə ɨyə̰ dɨje pətɨ adɨ uni rəbɨ kɨ mede ndɨgɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Be wa kɨn ka ɨyə̰ ta tɔjɨ me-majɨ ləne, al. Ɨlə kɨ man ndi dɔra̰ tɨ adɨ səsi je, adɨ səsi dɔkagɨlo kɨ majɨ adɨ ɨngəi kandɨ nḛ je, adɨ səsi nḛ kuso kɨ to mbar je, adɨ rɔnəl rosɨ mesi je.» ");
INSERT INTO bjvNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ta je wa kɨ əli kɨn ka, nga̰ səde ngay kadɨ ɔgi kosɨ je kɨlə məsɨ nangɨ kadɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lo kɨn tɨ, *Jɨpɨ je kɨ ḭḭ A̰tɨyosɨ kɨ Pɨsɨdi tɨ, kɨ Ikonɨyom, rəi, suləi kosɨ dɨje ka kɨn, ɓuki-de gode tɨ, adɨ tɨləi Pol kɨ mbal kadɨ n-tɔli-e, ɓa ndɔri-e, awi sie, ɨləi-e gɨdɨ ɓe tɨ, ooi ə nə oy. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nə lokɨ njé ndo je kawi-naa kɨ dɔe tɨ, ḭ taa, təl aw me ɓe bo tɨ gogɨ. Ɓa lo ti kɨ go tɨ, əi kɨ Barnabasɨ awi kɨ Dərbɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Lokɨ Pol əi kɨ Barnabasɨ ɨləi mbḛ Poy Ta kɨ Majɨ Dərbɨ tɨ, dɨje ngay təli njé ndo je lə Kɨrɨsɨ. Ɓa əi je, təli uni dɔ njade, tḛḛi Lɨsɨtɨr, kɨ Ikonɨyom, kɨ A̰tɨyosɨ kɨ Pɨsɨdi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ɨləi dɨngəm me njé ndo je tɨ, adi-de ta kɔjɨ kadɨ uwəi tɔgɨde ba me kadɨ-me tɨ ləde. Ɓa, ai dɔ tɨ no̰o̰ əli-de ə nə: «E kɨ ko̰ kɨ ngay ə j-a j-o-n ko̰ɓe lə Luwə.» ");
INSERT INTO bjvNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol əi kɨ Barnabasɨ ɨndəi njé kɔr no̰o̰ njé kaw-naa je dɔ njé kaw-naa je tɨ pətɨ kɨ tḛḛi dande tɨ. Ɔgi rɔde nḛ kuso, əli ta kɨ Luwə, ɓa go tɨ, ɨyə̰i-de ji Ɓaɓe tɨ kɨ uni mede adi-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ḬḬ no̰o̰, ɨndəi me ɓe kɨ Pɨsɨdi gangi, awi tḛḛi Pampɨli tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɨləi mbḛ Poy ta lə Luwə me ɓe tɨ kɨ Pərjɨ, ɓa awi tḛḛi ta ba tɨ kɨ Atali. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lo kɨn tɨ no̰o̰, uni bato kɨ kaw A̰tɨyosɨ tɨ. A̰tɨyosɨ kɨ e ɓe kɨ ndɔ kɨ njé kɔr no̰ njé kaw-naa je kɨ me tɨ, ɨyə̰i-de ji Luwə tɨ. Ɨyə̰i-de ji Luwə tɨ kadɨ me-majɨ lie e dɔde tɨ mbata kɨlə kɨ ḭḭ lo ra-e tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lokɨ tḛḛi A̰tɨyosɨ tɨ, kawi njé kaw-naa je, əli-de nḛ je pətɨ kɨ Luwə un-de ra-n. Ɔji-de tḛḛ kɨ Luwə tḛḛ ta rəbɨ kadɨ-me adɨ dɨje kɨ əi *Jɨpɨ je al. ");
INSERT INTO bjvNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɨsi kɨ njé ndo je dɔkagɨlo ngay A̰tɨyosɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Dɨje kɨ na̰ je ḭḭ Jude tɨ rəi A̰tɨyosɨ tɨ, ndoi ngako̰je je nḛ əi nə: «Kɨn ə re adɨ ɨjəi mɔtɨsi kɨ go ndu tɨ lə *Mojɨ al ə, a ɨngəi kajɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nḛ ndo kɨn re kɨ ta kasɨ-naa al, kɨ gakɨ-naa kɨ bo ngay mbo̰ njé ndo-e tɨ je kɨ Pol əi kɨ Barnabasɨ. Lo kɨn tɨ no̰o̰ be, uni tade kadɨ Pol əi kɨ Barnabasɨ, naa tɨ kɨ ngako̰je je madɨ, awi Jorijaləm tɨ ɨngəi njé kaw kɨlə je kɨ kɨ boy je lə njé kaw-naa je mbata ta kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","*NJé kaw-naa je kɨ A̰tɨyosɨ adi-de nḛ kɨ kadɨ ra səde dɔ rəbɨ mba tɨ. Uni rəbɨ, tḛḛi Pənəsi tɨ əi kɨ *Samari, ɔri dɨje gɨn nḛ je kɨ goe goe, go rəbɨ kɨ dɨje kɨ əi *Jɨpɨ je al təli adii mede Kɨrɨsɨ. Ta kɨn adɨ rɔnəl ngako̰ je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Lokɨ rəi tḛḛi Jorijaləm tɨ, njé kaw-naa je, kɨ njé kaw kɨlə je, kɨ ngatɔgɨ je lə njé kaw-naa je uwəi-de kɨ rɔde tɨ. Pol əi kɨ Barnabasɨ əli poy nḛ kɨ Luwə ra səde adɨ-de ooi. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nə dɨje kɨ na̰ je, kɨ adi mede dan *Parɨsɨ je tɨ uni ta əli əi nə: «Majɨ kadɨ dɨje kɨ əi Jɨpɨ je al, adi-de ɨjəi mɔtɨde ə ngəmi go ndu-kun je lə Mojɨ ɓəy tɔ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lo kɨn tɨ, njé kaw kɨlə je kɨ ngatɔgɨ je lə njé kaw-naa je kawi-naa mba kadɨ ɨndəi manjɨ ta kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lokɨ naji-naa ta adɨ dande ngal ɓa, Pɨyər ɔsɨ nangɨ ḭ taa əl-de ə nə: «NGakom je, təkɨ ɨgərii, e mari nu ə Luwə mbətɨ-m dansi tɨ mba kadɨ m-ɨlə mbḛ Poy ta kɨ Majɨ rɔ dɨje tɨ kɨ əi Jɨpɨ je al, kadɨ ooi ə adi mede. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Luwə kɨ gər me dɨje, ma najɨ ləde majɨ kɨ go rəbɨ NDɨl Luwə kɨ adɨ-de təkɨ adɨ-n-je be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Əi je ə je tɔ, Luwə ɔr kəm dəw dana al, mbata e kɨ takul kadɨ-me ləde ə Luwə adɨ nga̰mede ay-n njay. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nɨngə kɨ ɓasɨne kɨn, mba ri ə ɨsɨ sangi ta Luwə kɨ nḛ kɨndə kɨ ɔy mɨndɨ njé kadɨ-me je tɨ ə? Nḛ kɨ je wa ə se bawje je ka j-awi kɨ tɔgɨ kadɨ j-otii al. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nḛ kɨ j-adɨ meje dɔ tɨ ə to kɨn: E kɨ takul me-majɨ lə Ɓaɓe Jəju ə yə j-ɨngəi kajɨ, j-əi kɨ j-əi Jɨpɨ je, kae tɨ ləde əi Jɨpɨ je al ka kɨn tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ɓa, dɨje pətɨ uti tade, uri mbide kadɨ ooi dɔ ta lə Barnabasɨ əi kɨ Pol kɨ a əli-de ɔjɨ dɔ poy nḛ kɔjɨ je kɨ nḛ je kɨ ətɨ ɓəl je kɨ Luwə rade kɨ takul Pol əi kɨ Barnabasɨ dan dɨje tɨ kɨ əi Jɨpɨ je al. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lokɨ ɨləi ta nangɨ nɨngə, Jakɨ un ta əl ə nə: «NGakom je, uri mbisi oi ta ləm ɓasɨne. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sɨmo̰ ḭ taa əl-je ne, adɨ j-oi rəbɨ kɨ lo kɨlə ngɨre tɨ wa nu, Luwə ɨndə-n kəmne go tɨ majɨ, kadɨ ɔr dɨje kɨ na̰ je dan dɨje tɨ kɨ əi Jɨpɨ je al, ɨndə-de dangɨ tə dɨje ləne. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta je lə njé kəl ta je kɨ ta Luwə tɨ awi go-naa tɨ lo kare ba kɨ ta kɨn. Tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Go nḛ je tɨ kɨn, m-a m-re kadɨ m-ra ɓe lə *Dabɨdɨ kɨ budɨ kɨn rangɨ. M-a m-ra e kɨ sɨgɨ gogɨ, m-a m-ra toe tɨ gogɨ tɔ, M-a m-ɨndə taa gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","MBa kadɨ ndəgɨ dɨje sangi Ɓaɓe, Adɨ e gɨn dɨje pətɨ kɨ uni tɔm dɔde tɨ. Ɓaɓe əl ta kɨn be. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ɓaɓe kɨ nje tḛḛ kɨ gɨn nḛ kɨ ɨndə dɔe naa tɨ mari nu adɨ dɨje gəri.” ");
INSERT INTO bjvNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«E mbata kɨn ə, mi m-o majɨ ngay kadɨ j-ɨləi kagɨ no̰ dɨje tɨ kɨ əi Jɨpɨ je al kɨ adi mede Luwə kɨn, al. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Adɨ jɨ ndangi makɨtɨbɨ par j-adi-de kadɨ usoi da kɨ dəw ɨlə kadɨ-kare tɨ adɨ yo je al, kadɨ sangi-naa lo kaya tɨ al, kadɨ usoi da nḛ kɨ dəw tu mɨnde al, kadɨ usoi məsɨ da al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","NGa nɨngə, ɨlə ngɨre mari nu ba bɨtɨ ɓone, dɨje kɨ njé ndo madɨde je ndu-kun lə Mojɨ əi me ɓe bo je tɨ kare kare, nɨm ndɔ kare kare kɨ e ndɔ taa kə̰ə̰ lə Jɨpɨ je, dɨje a tɨdəi ndu-kun kɨn me kəy kaw-naa je tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Be ə, ngatɔgɨ je lə njé kaw-naa je, kɨ njé kaw kɨlə je, kɨ njé kaw-naa je, ndɨgi kadɨ n-mbəti dɨje kɨ na̰ je dande tɨ kadɨ uni tode dani Pol əi kɨ Barnabasɨ awi səde A̰tɨyosɨ tɨ. MBətɨ Judɨ kɨ ɓari-e nə Barsabasɨ əi kɨ Sɨlasɨ. Əi joo pu, ngako̰de je taai mede majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ta kɨ ndangi Makɨtɨbɨ tɨ adi-de ə to kɨn: «Je njé kaw kɨlə je kɨ ngatɔgɨ je lə njé kaw-naa je, jɨ ndangɨ makɨtɨbɨ kɨn j-adɨ səi ngako̰je je kɨ ɨsi ɓe bo A̰tɨyosɨ tɨ kɨ dɔnangɨ je kɨ Sɨri tɨ kɨ Sɨlɨsi kɨ səi gɨn kojɨ lə Jɨpɨ je al, jɨ ra səsi lapɨya. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","J-o poy dɨje madɨ ḭḭ danje tɨ ne awi rɔsi tɨ tuji mesi, təli səsi gogɨ kɨ ta je ləde, nɨngə e je ɓa j-ɨlə-de al. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Be ə, j-o majɨ kadɨ j-ɨndə taje naa tɨ kare ba, jɨ mbətɨ dɨje j-ɨlə-de kɨ rɔsi tɨ, naa tɨ kɨ Barnabasɨ əi kɨ Pol kɨ əi njé ndɨgɨ je ləje. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Əi kɨ ɨləi rɔde kɔ mbata tɔ Ɓaɓe ləje Jəju Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","E kɨn ə, j-ɨlə-n Judɨ əi kɨ Sɨlasɨ. Dɨje kɨ joo kɨn a əli səsi nḛ je kɨn kɨ tade. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","MBata NDɨl Luwə nɨm, je wa nɨm, j-un nduje kadɨ dəw ɨndə nḛ kɨ rangɨ gɨdɨ nḛ tɨ kɨ e nḛ kɨ ndae to tɨ kɨn, dɔsi tɨ kɨ tɔgɨ al ngata. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Nɨngə nḛ kɨ kadɨ ɨrai ə to kɨn: kadɨ usoi da kɨ dəw ɨlə kadɨ-kare tɨ adɨ yo je al, usoi məsɨ da al, usoi da kɨ dəw tu mɨnde al, ɨsai-naa lo kaya tɨ al. Pətɨ ɨtoi be nɨngə, a rai nḛ kɨ majɨ. Ɨtaai lapɨya ləje, je kɨ je ngako̰si je.» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ɨyə̰i njé kɨ mbəti-de ka kɨn adɨ awi A̰tɨyosɨ tɨ. Lokɨ awi tḛḛi A̰tɨyosɨ tɨ, kawi njé kadɨ-me je kɨ naa tɨ, ə ɨləi makɨtɨbɨ ka kɨn jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lokɨ tɨdəi makɨtɨbɨ ka kɨn nɨngə, rɔde nəl-de ngay tadɔ ɨngəi ta je kɨ adɨ-de tɔgɨ me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Təkɨ Judɨ əi kɨ Sɨlasɨ wa əi njé kəl ta kɨ ta Luwə tɨ, uni dɔkagɨlo ngay ɨləi dɨngəm me ngako̰ je tɨ, mbɨsi njade me kadɨ-me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ɨsi səde dɔkagɨlo ndə̰y ɓa, ngako̰ je uwəi jide, ɨndəi-de ta rəbɨ tɨ kadɨ awi kɨ lapɨya, təli kɨ rɔ njé kɨlə-de je tɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nə Sɨlasɨ oo majɨ ngay kadɨ n-ɨsɨ A̰tɨyosɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol əi kɨ Barnabasɨ ɨsi A̰tɨyosɨ tɨ, naa tɨ kɨ ndəgɨ dɨje kɨ rangɨ, ndoi dɨje nḛ, ɨləi-de mbḛ Poy Ta kɨ Majɨ lə Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","NDə̰y go tɨ, Pol əl Barnabasɨ ə nə: «Adɨ jɨ təl j-un dɔ njaje me ɓe bo je tɨ pətɨ kɨ j-əl ta lə Ɓaɓe tɨtɨ kɨn, ə jɨ go̰ ngako̰je je j-o se təli toi ban wa?» ");
INSERT INTO bjvNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Lo kɨn tɨ, Barnabasɨ ndɨgɨ kadɨ Ja̰ Markɨ aw səde. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nə Pol oo kadɨ e loe tɨ al kadɨ Ja̰ Markɨ kɨ ndɔ kɨ ɨyə̰-de Pampɨli tɨ, ɓɨ aw səde lo kaw kɨlə tɨ al kɨn, kadɨ aw səde ɓone ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mɨndɨ kasɨ-naa al kɨ bo ngay to dande tɨ adɨ ɨyə̰i-naa no̰o̰ be. Barnabasɨ un Ja̰ Markɨ, ə uni bato kɨ aw kɨ Sɨpɨr tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","NGa Pol ə un Sɨlasɨ ə awi. NGako̰je je ɨyə̰i-de ji Ɓaɓe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol je njɨyəi dɔnangɨ Sɨri tɨ kɨ dɔnangɨ Sɨlɨsi tɨ ɨləi dɨngəm me njé kaw-naa je tɨ kɨ lo lo. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol re tḛḛ Dərbɨ tɨ, go tɨ aw Lɨsɨtɨr tɨ. Lo kɨn tɨ ə, ɨngə nje ndo kare kɨ tɔe nə Tɨmote. Ko̰e e nje kadɨ-me kɨ e Jɨpɨ, ə bawe e Gɨrəkɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","NGako̰je je kɨ Lɨsɨtɨr kɨ Ikonɨyom əli ta lie majɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Adɨ Pol ndɨgɨ kuwe jine tɨ kaw sie. Be ə, aw sie ɨjə mɔte, mbata *Jɨpɨ je kɨ rai ɓe lo je tɨ kɨn, gəri-e ɓətɨ kadɨ bawe e Gɨrəkɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ɓe bo je pətɨ kɨ tḛḛi tɨ, ɔji ngako̰de je ndu-kun je kɨ njé kaw kɨlə je kɨ ngatɔgɨ je lə njé kaw-naa je kɨ Jorijaləm tɨ uni. Ɓa əli-de kadɨ rai go ndu je tɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","*NJé kaw-naa je ɨngəi tɔgɨ me kadɨ-me tɨ ləde, nɨngə kɔrde ḭ dɔ made tɨ kɨ ndɔe ndɔe. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","NDɨl Luwə ɔgɨ-de kɨlə mbḛ Poy Ta kɨ Majɨ ngan ɓe je tɨ kɨ Aji. Adɨ ɔti no̰o̰, ɨndəi dɔnangɨ Pɨrɨji kɨ dɔnangɨ Galasi mani. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Lokɨ rəi tḛḛi ɓasi kɨ Mɨsi, sangi rəbɨ kadɨ n-awi Bɨtɨni tɨ, nə NDɨl Jəju ɔgɨ-de rəbɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Be ə, ɨndəi dɔnangɨ kɨ Mɨsi gangi, awi tḛḛi ta ba tɨ kɨ Tɨrowasɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Loe tɨ kɨn ə, kondɔ ɓa, Pol oo dəw kare kɨ Masəduwan tɨ me ndɨl tɨ re a dɔe tɨ. Dəw ka kɨn əl Pol ə ə nə: «NJai ba, ɨre Masəduwan tɨ ɨra səje.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Go nḛ koo me ndɨl tɨ lə Pol, ta naa tɨ no̰o̰, jɨ sangɨ rəbɨ kadɨ j-aw Masəduwan tɨ, mbata jɨ gər majɨ təkɨ Luwə ə wa ə ɓar-je kadɨ j-aw j-ɨlə mbḛ Poy Ta kɨ Majɨ tɨtɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","J-al bato Tɨrowasɨ tɨ no̰o̰, ɓa j-ɔsɨ jɨ tḛḛ dɔ dər Samotɨrasɨ tɨ. Lo ti kɨ go tɨ nɨngə, jɨ tḛḛ Nəyapolɨsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","J-ḭ loe tɨ no̰o̰, j-aw Pɨlɨpɨ tɨ, kɨ e ɓe bo kɨ dɔsa̰y kɨ dɔnangɨ tɨ kɨ Masəduwan, kɨ e gɨn ko̰ɓe tɨ kɨ Rom. J-ɨsɨ no̰o̰, jɨ ra ngan ndɔ je asɨ tatɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nɨngə ndɔ ta kə̰ə̰ tɨ lə *Jɨpɨ je, jɨ tḛḛ gɨdɨ ɓe bo tɨ taga, kadɨ j-aw kadɨ mbo tɨ. J-aw tɨ mbata jɨ gɨr kadɨ j-a j-ɨngə lo kəl ta kɨ Luwə tɨtɨ. Lokɨ j-aw nɨngə, j-ɨsɨ nangɨ rɔ dəne je tɨ kɨ kawi-naa loe tɨ, j-əl-de ta. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Dan dəne je tɨ ka kɨn, e kɨ kare ɨsɨ no̰o̰, tɔe nə Lɨdi. E dəne kɨ ɓe bo tɨ kɨ Tɨyatɨr. E nje labɨ ta kɨbɨ kɨ kər pɨr pɨr. Nɨngə e dəw kɨ nje ɓəl Luwə tɔ. Ɨsɨ oo ta, ɓa Ɓaɓe tḛḛ nga̰mee, adɨ ɨndə mbine majɨ go ta je tɨ kɨ Pol ɨsɨ əl. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ra batəm naa tɨ kɨ njé kɨ me kəy tɨ ləne. Ɓa ɓar-je kadɨ j-aw ɓe ləne ə nə: «Kɨn ə re oi-mi kadɨ mi nje kadɨ mem Ɓaɓe ɓa, ɨrəi ɨsi ɓe ləm.» A dɔ ta tɨ kɨn nga̰, kadɨ jɨ ndɨgɨ gone tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","NDɔ kare j-ɨsɨ j-aw kɨ lo kəl ta tɨ kɨ Luwə ɓa, dəne kɨ nje ra kɨlə me kəy tɨ kare re ɨngə-je. Dəne kɨn aw kɨ ndɨl ndo̰, adɨ lo kɨ ɨndə gara ɓa, ɨngə-n nḛ ngay adɨ ɓane je. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Un goje kɨ Pol je ɓa, əl ta kɨ ndune kɨ boy ə nə: «Dɨje kɨ ai kam əi ɓəə je lə Luwə kɨ e dɔ nḛ je tɨ pətɨ. Rəi a ɔji səsi rəbɨ kajɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dəne ra nḛ kɨn be ndɔne ba̰y ba̰y goje tɨ. Be ə, ta tɔl tae tɨ, wongɨ ra Pol dɔe tɨ, adɨ təl tane əl ndɨl kɨ ɨsɨ me dəne tɨ ka kɨn ə nə: «Me tɔ Jəju Kɨrɨsɨ tɨ, m-əli kadɨ ɨtḛḛ kɔ me tɨ.» Nɨngə ta naa tɨ no̰o̰, ndɨl tḛḛ kɔ me dəne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lokɨ ɓae je ooi kadɨ nḛ kɨngə nḛ ləde ka, ɨndə ngangɨne ɓa, uwəi Pol əi kɨ Sɨlasɨ awi səde ta mbalo tɨ, no̰ njé ko̰ɓe je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Awi səde no̰ njé gangɨ ta je tɨ əli-de əi nə: «Dɨje kɨ oi-de kam əi *Jɨpɨ je, ə rəi kɨ ndu kɨ majal me ɓe bo tɨ ləje. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Rəi kɨ nḛ jibəl ɓe je kɨ, je kɨ je Rom je, sɔbɨ dɔje al, kadɨ tə jɨ taa, jɨ ra-n kɨlə.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kosɨ dɨje ḭḭ, ɓuki-naa dɔ Pol tɨ əi kɨ Sɨlasɨ. Ɓa, njé gangɨ ta je, adɨ ngḭḭ kɨbɨ rɔde tɨ, tɨndəi-de kɨ gɔl. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lokɨ ɨndəi-de majɨ ɓa, awi ɓuki-de dangay tɨ, nɨngə əli nje ngəm dangay je kadɨ ngəm-de majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Lokɨ nje ngəm dangay je ɨngə ndu kɨn be ɓa, aw səde kəy dangay tɨ kɨ duni nu, taa ɨlə kangɨla njade tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kondɔ dan lo tɨ, Pol əi kɨ Sɨlasɨ ḭḭ ɨsɨ əli ta kɨ Luwə, osi pa ɨləi tɔjɨ dɔ Luwə, ə ndəgɨ dangay je ooi ndude. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nɨngə, kɨ kəm kɨ kɨndə jɨpɨ, dɔnangɨ yəkɨ kɨ tɔgɨne ngay. Yəkɨ yəkɨ kɨ ra adɨ ngɨrə kəy dangay ka ḭ ɓakɨ ɓakɨ. Ɓa kɨ ta naa tɨ no̰o̰, ta kəy je tḛḛi nɨm, kulə gɨndɨ kɨ dɔɔi dangay je pətɨ ka tutɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lo kɨn tɨ no̰o̰, nje ngəm dangay je ḭ dɔ ɓi tɨ. Lokɨ ḭ dɔ ɓi tɨ ə oo ta kəy je a tagɨra, oo ə nə dangay je a̰yḭ-naa wa, adɨ ɔr kɨyə ləne kadɨ tə n-tɔl-n rɔne kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ə Pol Un ndune kɨ taa ngay əl-e ə nə: «Ɨtujɨ rɔi al, nə j-a nḛ pətɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lo kɨn tɨ, nje ngəm dangay je dəjɨ por, ɓa nagɨ rɔne ur kəy, osɨ no̰ Pol tɨ kɨ Sɨlasɨ kɨ dadɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Go tɨ, adɨ-de tḛḛi taga, nɨngə dəjɨ-de ə nə: «Ɓam je, e ri ə kadɨ m-ra ə m-a m-ɨngə-n kajɨ ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ə əli-e ə nə: «Adɨ mei Ɓaɓe Jəju, ə a ɨngə kajɨ səi kɨ njé kɨ me kəy tɨ ləi.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lo kɨn tɨ, ɨləi-e mbḛ ta lə Ɓaɓe, naa tɨ kɨ njé kɨ me kəy tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dan kondɔ tɨ wa kɨn no̰o̰, nje ngəm dangay je aw kɨ Pol əi kɨ Sɨlasɨ, togɨ do je ləde, ɓa kalangɨ ba go tɨ, adɨ rai-e batəm naa tɨ kɨ dɨje kɨ me kəy tɨ ləne. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Go tɨ, təl aw səde me kəy tɨ ləne, adɨ-de nḛ kuso usoi, rai rɔnəl me kəy tɨ mbata kadɨ kɨ adi mede Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lokɨ lo ti nɨngə, njé gangɨ ta je ɨləi paja je ləde kɨ rɔ nje ngəm dangay je tɨ əi nə: «Ɨyə̰ dɨje kɨn adɨ awi.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ə nje ngəm dangay je re əl Pol ta kɨn ə nə: «NJé gangɨ ta je əi nə kadɨ m-ɨyə̰ səsi madɨ awi, ə nə ɨtḛḛi awi lo ləsi kɨ lapɨya.» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nə Pol əl paja je ə nə: «Je dɨje kɨ Rom tɨ tɔ, ə adi dɨje ɨndəi je ta kəm kosɨ je tɨ, kɨ kanjɨ gangɨ ta dɔ je tɨ. Ə go tɨ, ɓuki je dangay tɨ be par tɔ. Nɨngə ɓasɨne, ɨyə̰i-je taa lo ngə̰y tɨ be par a? A e be al! Adɨ əi je wa rəi kɨ rɔde ɨyə̰i-je taa!» ");
INSERT INTO bjvNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ə paja je təli kɨ ta kɨn awi rɔ njé gangɨ ta je tɨ, adɨ ɓəl ra njé gangɨ ta je ngay. Ɓəl ra-de, lokɨ ooi kadɨ Pol je əi dɨje kɨ Rom tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Be ə, ḭḭ, rəi rɔde tɨ, dəji-de me-sɔl, ɓa ɨyə̰i-de kadɨ awi, ə dəji-de kadɨ tḛḛi me ɓe bo tɨ kɨn kɔ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lokɨ Pol əi kɨ Sɨlasɨ tḛḛi dangay tɨ ɓa, awi ɓe lə Lɨdi. Awi ooi ngako̰je je kɨ njé kadɨ-me je, ɨləi dɨngəm mede tɨ ɓa awi. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol əi kɨ Sɨlasɨ ɨndəi Ampɨpolɨsɨ kɨ Apoloni gangi, ɓa awi tḛḛi Təsalonɨkɨ tɨ. Nɨngə Təsalonɨkɨ tɨ, *Jɨpɨ je awi kɨ lo kaw-naa ləde no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Be ə, Pol aw tɨ, təkɨ ɨsɨ ra-n kɨ lo je pətɨ. Asɨ ndɔ taa kə̰ə̰ mɨtə go-naa tɨ, Pol naji-naa ta tɨ kɨ Jɨpɨ je dɔ ta je tɨ kɨ me makɨtɨbɨ tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ɔr-de gɨn ta je, tɔjɨ-de adɨ gəri təkɨ, makɨtɨbɨ lə Luwə əl kadɨ Kɨrɨsɨ a oy, ɓa go tɨ, a tɔsɨ ndəl dan njé koy je tɨ. Nɨngə, Pol əl-de təkɨ e darɔ Jəju wa kɨ n-ɨsɨ n-əl-de ta lie kɨn ə e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jɨpɨ je kɨ na̰ je, ta kɨn ra kɨlə rɔde tɨ, adɨ ɨndəi rɔde naa tɨ kɨ Pol əi kɨ Sɨlasɨ. Kosɨ Gɨrəkɨ je, kɨ dəne je ngay kɨ əi dəne je kɨ njé tɔɓa je ka ɨndəi rɔde naa tɨ səde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ə lo kɨn tɨ, jangɨ ra Jɨpɨ je, adɨ kawi dɨje kɨ a ɨləi lo kɨ go rəbɨ kare, adɨ ɔsi dɔ dɨje naa tɨ, rai ndu kɨ me ɓe. Awi tḛḛi me kəy tɨ lə Jaso̰, sangi Pol əi kɨ Sɨlasɨ kadɨ n-uwəi-de, n-awi səde taga, no̰ kosɨ je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nə lokɨ ɨngəi-de al, uwəi Jaso̰ əi kɨ njé kadɨ-me je kɨ madɨ je, awi səde no̰ njé gangɨ ta je tɨ. Ɓa əli ta kɨ ndude kɨ boy əi nə: «Dɨje kɨ tuji dɔnangɨ kɨ tae ba ka, rəi tḛḛi ne. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Rəi ə, Jaso̰ uwə-de rɔne tɨ ɓe ləne. Dɨje kɨn pətɨ, nḛ rade e nḛ ra kɨ ɔsɨ ta ndu-kun je lə NJe ko̰ɓe kɨ bo Səjar. Əi əli təkɨ ngar madɨ kɨ rangɨ e no̰o̰ tɔe nə Jəju.» ");
INSERT INTO bjvNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ta kɨn adɨ wongɨ kosɨ je kɨ njé gangɨ ta je, ");
INSERT INTO bjvNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","adɨ uwəi Jaso̰ kɨ ndəgɨ njé kadɨ-me je adɨ ugəi la ɓəy taa ɨyə̰i-de taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lokɨ lo ə nə n-go̰i par ə, njé kadɨ-me je adi Pol əi kɨ Sɨlasɨ awi Bəre tɨ. Lo kɨ rəi tḛḛi Bəre tɨ ɓa, awi kəy kaw-naa tɨ lə *Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jɨpɨ je kɨ Bəre tɨ, awi kɨ mər ta kɨ majɨ ngay ɨtə njé kɨ Təsalonɨkɨ tɨ. Taai ta lə Luwə kɨ me kɨ majɨ ngay. NDəri gɨn ta lə Luwə kɨ ndɔ je pətɨ, kadɨ n-ooi se ta je kɨ Pol je əli-de kɨn e ta kɨ rɔjetɨ wa. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Be ə, ngay je dande tɨ adi mede, taa dan Gɨrəkɨ je tɨ, dəne je kɨ njé tɔɓa, kɨ dɨngəm je ngay adi mede tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nə lokɨ Jɨpɨ je kɨ Təsalonɨkɨ tɨ, ooi kadɨ Pol ɨsɨ ɨlə mbḛ ta lə Luwə Bəre tɨ no̰o̰ nɨngə, təli awi gode tɨ ɓəy, awi suləi kosɨ je adɨ rai ndu. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lo kɨn tɨ, njé kadɨ-me je sangi rəbɨ kalangɨ ba adi Pol aw kɨ kadɨ ba bo tɨ. NGa nɨngə, Sɨlasɨ əi kɨ Tɨmote ə nayḭ-naa Bəre tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","NJé kɨ dani Pol, dani-e bɨtɨ, awi tḛḛi sie Atən tɨ. NGata ɓa, lokɨ ɨsɨ təli, Pol adɨ-de ndune kadɨ Sɨlasɨ əi kɨ Tɨmote rəi law ɨngəi-ne. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lokɨ Pol ɨsɨ ngəm Sɨlasɨ əi kɨ Tɨmote, angale tujɨ mbata yo je kɨ dɨje ɨsɨ rai-de, rɔsi me ɓe bo kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pol naji-naa ta tɨ kɨ *Jɨpɨ je, kɨ dɨje kɨ təli Jɨpɨ je, me kəy kaw-naa tɨ lə Jɨpɨ je, taa kɨ ndɔ je pətɨ, ta mbalo tɨ, kɨ dɨje kɨ ɨngə-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","NJé nḛ gər je kɨ ɓari-de Əpɨkɨr je kɨ Ɨsɨtoyɨsɨ je ka naji-naa ta tɨ səde tɔ. Ə njé kɨ madɨ je əli əi nə: «NJe ta je kam ta ri ə a əl ə?» Nɨngə njé kɨ nungɨ əli əi nə: «To tə nḛ kɨ e nje kəl ta kɨ dɔ yo je tɨ kɨ mba be ə am.» Əli be mbata ooi kadɨ Pol ɨsɨ ɨlə mbḛ Poy Ta kɨ Majɨ lə Jəju nɨm, ɨsɨ ɨlə mbḛ kḭe lo koy tɨ nɨm. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Be ə, uwəi Pol, awi sie rɔ njé gangɨ ta je tɨ, ɓa əli-e əi nə: «To kadɨ əl-je ta dɔ nḛ ndo tɨ kɨ sɨgɨ kɨ ɨsɨ ɨndo kɨn adɨ jɨ gər a? ");
INSERT INTO bjvNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","MBata ɨsɨ əl-je ta je kɨ mbije oo nja kare al, ə kadɨ ɔr gɨne majɨ adɨ j-o.» ");
INSERT INTO bjvNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Nɨngə nḛ kare kɨ sɔbɨ gər, dɨje kɨ Atən tɨ pətɨ, kɨ mba je kɨ ɨsi dande tɨ, dɔkagɨlo ləde kɨ ngay e mba kəl-n ta je, koo-n ta je kɨ mba. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lo kɨn tɨ, Pol ḭ a taa, dan njé gangɨ ta je tɨ, ɓa un ta əl ə nə: «Səi dɨje kɨ Atən tɨ, m-o kadɨ səi dɨje kɨ, pole yo ləsi ətɨ ɓəl kɨ dum. Ɨpoləi yo me nḛ je tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tadɔ, lokɨ m-njɨyə me ɓe tɨ, m-o nḛ je kɨ ɨsɨ ɔsi məkəsɨsi nangɨ no̰de tɨ. M-o lo gugɨ yo madɨ wa ɓəy kɨ ɨndəi nḛ dɔ tɨ əi nə e lo lə “yo kɨ ɨgəri-e al,” nɨngə e e kɨ ɨsɨ ɔsi məkəsɨsi nangɨ no̰e tɨ kɨ kanjɨ gər-e ka kɨn ə m-ɨsɨ m-ɨlə səsi mbḛ ta lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","E Luwə kɨ nje ra dɔra̰ kɨ dɔnangɨ kɨ nḛ je pətɨ kɨ me tɨ, e kɨ e Ɓa dɔra̰ kɨ dɔnangɨ. E nje kɨsɨ me kəy tɨ kɨ dəw ra kɨ jine al. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Taa aw kɨ ndoo kadɨ dəw ra kɨlə madɨ ade al tɔ, tadɔ e ə e nje kadɨ dəw ɨsɨ kəm ba nɨm, nje kadɨ dəw kə̰ə̰ kɨ nḛ je pətɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kɨ dəw kɨ kare ba be ə ɨndə-n dɨje pətɨ adɨ taai dɔnangɨ. Ɨndə dɔkagɨlo adɨ-de nɨm, ɨndə gangɨ lo kɨsɨde nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Luwə ɨndə nḛ je kɨn be mba kadɨ dɨje sangi-e-n. Dɔmajɨ ə a ɨngəi-e me mam lo tɨ ləde. Kɨ rɔjetɨ, Luwə e sa̰y al kɨ dəw kɨ ra danje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tadɔ kɨsɨ kɨ dɔ taa ləje e me jie tɨ. E ə e nje kadɨ j-ɔdɨ rɔje, kɨ nje kadɨ j-ɨsɨ kəm. E mbata kɨn ə njé gosɨ ta je ləsi kɨ madɨ je əli əi nə: “Je ka je ngane je tɔ.” ");
INSERT INTO bjvNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ə re je ngan Luwə je ɓa, sɔbɨ kadɨ j-o Luwə kadɨ e dəw kɨ to tə yo ɔr je, kɨ yo la je kɨ dɨje lḛi-de, ə se yo mbal je kɨ dɨje tɔli-de kɨ gosɨ kɨ dɔde tɨ kɨn be al. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Luwə ɨyə̰ go nḛ kɨ dɨje rai kəte dɔ day tɨ, dɔkagɨlo tɨ kɨ gəri-e al ɓəy kɨn kɔ, nə kɨ ne kɨn, Luwə dəjɨ dɨje pətɨ, kɨ lo je pətɨ, kadɨ ɨyə̰i rəbɨ nḛ rade je kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tadɔ ɔr ndɔ kare ɨndə no̰o̰ kadɨ tə a gangɨ-n ta dɔ dɨje kɨ dɔnangɨ tɨ ne pətɨ kɨ rəbɨ kɨ dana. A gangɨ ta kɨn kɨ rəbɨ lə dəw kare kɨ kɔte mbata kɨlə kɨn, ə tɔje kɨ taga adɨ dɨje pətɨ gəri-e kɨ rəbɨ kḭe dan njé koy je tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Lokɨ Pol əl ta kḭ lo koy tɨ, ə osɨ mbide tɨ nɨngə, njé kɨ madɨ je ɨbəi-e kogii, ə njé kɨ nungɨ əli əi nə: «J-a j-o ta ləi kɨn ndɔ kɨ rangɨ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","E be ə, Pol tḛḛ-n dande tɨ, aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nə be ka, kɨ madɨ je dande tɨ nayḭ-naa go Pol tɨ, adi mede Jəju Kɨrɨsɨ. Dande tɨ kɨn, Dənɨsɨ kɨ e kɨ kare dan njé gangɨ ta je tɨ e səde no̰o̰, taa dəne kɨ ɓari-e nə Damarɨsɨ kɨ ndəgɨ dɨje kɨ rangɨ ka əi səde no̰o̰ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lokɨ Pol ḭ Atən tɨ nɨngə, aw Korḛtɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lo kɨn tɨ no̰o̰, ɨngə Jɨpɨ kare kɨ tɔe nə Akɨlasɨ, kɨ gɨne e Po̰, ḭḭ Itali kɨ nene Pɨrɨsɨl rəi ngɔsɨne ɓəy. Rəi mbata nje ko̰ɓe kɨ bo kɨ Rom tɨ kɨ tɔe nə Kɨlodɨ un ndune kadɨ *Jɨpɨ je pətɨ tḛḛi Rom tɨ kɔ. Pol aw ɨngə Akɨlasɨ je no̰o̰, ");
INSERT INTO bjvNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","nɨngə təkɨ kɨlə kɨ kadɨ rai ɨngəi nḛ e kɨlə kɨ kare ba, adɨ e kɨlə kojɨ kɨbɨ ra kəy, Pol ɨsɨ səde, adɨ rai kɨlə kɨn naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","*NDɔ taa kə̰ə̰ je pətɨ, Pol un ta, əl me kəy kaw-naa tɨ lə Jɨpɨ je. Əl kɨ kuje kɨ sangɨ kadɨ Jɨpɨ je kɨ Gɨrəkɨ taai tə ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nə lokɨ Sɨlasɨ əi kɨ Tɨmote ḭḭ Masəduwan tɨ rəi ɨngəi-e, Pol un dɔkagɨlo ləne pətɨ mba kəl-n ta lə Luwə. Tɔjɨ Jɨpɨ je kadɨ gəri təkɨ Jəju e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nə Jɨpɨ je ta̰i-e rɔ, taji-e, adɨ Pol jəngɨ bu kɨbɨ ləne tade tɨ, ə əl-de ə nə: «Ta məsɨsi e dɔsi tɨ! mi m-goto me tɨ. Nɨngə kɨ ɓasɨne kɨn, dɨje kɨ əi Jɨpɨ je al ə m-a m-aw kɨ rɔde tɨ ngata.» ");
INSERT INTO bjvNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Be ə, Pol ḭ no̰o̰, aw ɓe lə Tɨtusɨ Jusɨtusɨ, kɨ e dəw kare kɨ nje kaw no̰ Luwə tɨ, kɨ kəy lie ndunəi-naa kɨ kəy kaw-naa lə Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kɨrɨsɨpusɨ, kɨ e kɨ boy dɔ kəy kaw-naa tɨ lə Jɨpɨ je əi kɨ dɨje kɨ me kəy tɨ ləne ba pətɨ, adi mede Ɓaɓe. Taa dɨje kɨ Korḛtɨ tɨ ngay, kɨ ooi ta lə Pol ka adi mede tɔ, adɨ rai-de batəm. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","NDɔ kare kondɔ, Ɓaɓe əl Pol ta me ni tɨ ə nə: «Ɨɓəl al, əl ta kɨ no̰i tɨ, ɓɨ utɨ tai al. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tadɔ mi səi naa tɨ, dəw madɨ kare kɨ a ɨlə jine kadɨ ɔdi təkɨ majal goto. Dɨje kɨ əi dɨje ləm əi ngay me ɓe bo tɨ kɨn ne.» ");
INSERT INTO bjvNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Be ə Pol ɨsɨ-n Korḛtɨ tɨ ɓal kare kɨ nay mehḛ, ndo-n dɨje ta lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dɔkagɨlo tɨ kɨ Galɨyo̰ e-n nje ko̰ɓe kɨ Akay, *Jɨpɨ je dɔɔi ta naa tɨ dɔ Pol tɨ, adɨ awi sie no̰ njé gangɨ ta je tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","əi nə: «Dəw kam ɨsɨ aw kɨ dɨje kadɨ ɔsi dɔde nangɨ no̰ Luwə tɨ, kɨ go ndu-kun tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol ra kadɨ tə n-əl ta nɨngə, Galɨyo̰ un ta tane tɨ kəte əl Jɨpɨ je ə nə: «Kɨn ə re e ta lə nḛ tɔl, ə se ta lə majal madɨ kɨ nga̰ ngay ə to be ə, re m-a m-o ta ləsi, səi Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nə təkɨ e ta kɨ najɨ-naa tɨ kɨ ɔjɨ dɔ ta je, kɨ tɔ je, kɨ ndu-kun je ləsi kɨ sɔbɨ dɔsi kɨn ɓa, ai dansi tɨ no̰o̰. Mi m-a m-gangɨ ta kɨ be kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ɓa tuwə-de lo gangɨ ta tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ə loe tɨ no̰o̰, dɨje pətɨ uwəi Sosɨtən kɨ e kɨ boy dɔ kəy kaw-naa tɨ lə Jɨpɨ je, ɨndəi-e, nə usɨ Galɨyo̰ nḛ kare dɔde tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol təl ɨsɨ Korḛtɨ tɨ no̰o̰ dɔkagɨlo asɨ ta tɨ ɓəy. Ɓa go tɨ, ɨyə̰ njé kadɨ-me je, ə un bato kɨ kaw kɨ Sɨri tɨ, naa tɨ kɨ Pɨrɨsɨl əi kɨ Akɨlasɨ. Pol adɨ ngɨsəi dɔe Sa̰kɨre tɨ, mbata un mɨndɨne adɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Awi tḛḛi Epəjɨ tɨ, Pol ɨyə̰ Pɨrɨsɨl əi kɨ Akɨlasɨ ə aw kəy kaw-naa tɨ lə *Jɨpɨ je, naji-naa ta tɨ səde. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jɨpɨ je kɨn dəji Pol kadɨ ɨsɨ səde ngan ndɔ je ɓəy, nə Pol ndɨgɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ɓa əl-de ə nə: «NDɔ kɨ rangɨ, ə Luwə ndɨgɨ ə, m-a m-təl tə m-re rɔsi tɨ ɓəy,» nɨngə ɨyə̰-de ə aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ɓa un bato Epəjɨ tɨ, aw Səjare tɨ. Lokɨ tḛḛ Səjare tɨ, aw uwə ji njé kaw-naa je, ɓa un rəbɨ aw A̰tɨyosɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol ra ngan ndɔ je no̰o̰, ɓa təl ɨlə dɔne gogɨ. Aw tḛḛ Galasi tɨ kɨ Pɨrɨji tɨ, adɨ tɔgɨ njé ndo je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jɨpɨ kare kɨ tɔe nə Apolosɨ, kɨ e dəw kɨ gɨne e Aləgɨjandɨri tɨ re Epəjɨ tɨ. E dəw kɨ ɓal ta to tae tɨ, taa gər ta lə Luwə majɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","NDoi-e rəbɨ ta lə Ɓaɓe, adɨ ɨlə mbḛ ta lə Jəju kɨ rɔnəl kɨ ngay, ndo dɨje nḛ kɨ dɔ Jəju tɨ kɨ go rəbe tɨ. Nə ke ə, gər batəm lə Ja̰ par. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ɨlə rɔne, əl ta lə Luwə kəy kaw-naa tɨ lə *Jɨpɨ je kɨ me kɨ tḭ katɨ. Nə lokɨ Pɨrɨsɨl əi kɨ Akɨlasɨ ooi-e lo kəl ta tɨ, ɓari-e rɔde tɨ, ɔji-e go rəbɨ lə Luwə ay njay, adi-e gər. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Go tɨ, ndɨgɨ kaw Akay tɨ, ə ngako̰je je ndɨgi dɔ tɨ sie, adɨ rai makɨtɨbɨ adi njé ndo je kɨ Akay tɨ kadɨ uwəi-e rɔde majɨ. Lokɨ aw tḛḛ Akay tɨ, kɨ go me-majɨ tɨ lə Luwə, ra kɨ njé kɨ adi mede Luwə ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tadɔ dum dɔ Jɨpɨ je kɨ tɔgɨ ta ləne taga wangɨ ta kəm dɨje tɨ. Tɔjɨ kɨ ta lə Luwə jine tɨ təkɨ Jəju e Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dɔkagɨlo tɨ kɨ Apolosɨ e-n Korḛtɨ tɨ, Pol ɨndə dɔnangɨ kɨ mbal je əi tɨ kɨ dɔnangɨ Aji tɨ gangɨ, ɓa re tḛḛ Epəjɨ tɨ. Ɨngə njé ndo je lə Jəju kɨ na̰ je tɨ no̰o̰. Adɨ dəjɨ-de ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Lokɨ adi mesi Jəju kɨn, ɨngəi NDɨl Luwə a?» Ə təli ɨləi-e tɨ əi nə: «Jagɨ, ko ka j-o kəte kadɨ NDɨl Luwə e no̰o̰ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol təl dəjɨ-de ɓəy ə nə: «Batəm kɨ ban ə ɨngəi ə?» Ə əli-e əi nə: «J-ɨngə batəm lə Ja̰ Batɨsɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Be ə, əl-de ə nə: «Oyo, Ja̰ ra batəm *Isɨrayəl je mba kadɨ tɔri ndude dɔ majal je tɨ ləde. Ə təl əl-de ɓəy kadɨ tə adi mede dəw kɨ a re gone tɨ no̰o̰, adɨ dəwe kɨn e Jəju.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lokɨ ooi ta je kɨn nɨngə, adɨ rai-de batəm me tɔ Ɓaɓe Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Be ə, Pol ɨndə jine dɔde tɨ, ə NDɨl Luwə rɨsɨ dɔde tɨ. Nɨngə ɨləi ngɨrə kadɨ əli ta kɨ ndon ta je kɨ dangɨ dangɨ nɨm, taa əli ta kɨ ta Luwə tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Dɨngəm je pətɨ kɨ ai lo nḛ je tɨ kɨn asi dɔgɨ gɨde e joo. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Go tɨ, asɨ nay mɨtə go-naa tɨ, Pol tḛḛ ə aw kəy kaw-naa tɨ lə *Jɨpɨ je, əl-de ta kɨ kanjɨ ɓəl. Ɨlə mbḛ ko̰ɓe lə Luwə, əl-de kɨ go rəbe, kadɨ ooi tə ta kɨ rɔjetɨ mba kadɨ taai ta kɨn tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nə Jɨpɨ je kɨ na̰ je dande tɨ rai me nga̰, adɨ mbati kadɨ adi mede. Əli ta kɨdii nḛ ndo lə Pol kɨ ɔjɨ go rəbɨ ta lə Ɓaɓe kɨn ta kəm kosɨ dɨje tɨ. Be ə, Pol ɨyə̰-de ə ɔtɨ aw kɨ njé ndo je me kəy ndo nḛ tɨ kɨ tɔe nə Tɨranusɨ. Nɨngə kɨ ndɔ je kare kare pətɨ, ndo-de nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nḛ ndo kɨn, Pol ra kɨle asɨ ɓal joo. Be ə, ra adɨ Jɨpɨ kɨ dɨje kɨ ə Jɨpɨ je al kɨ ɨsi dɔnangɨ Aji tɨ, ooi ta lə Ɓaɓe. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Luwə ra nḛ kɔjɨ je kɨ ətɨ ɓəl kɨ takul Pol. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Adɨ, dɨje ɔyi ta kɨbɨ kɨ kare je kɨ ta kɨbɨ lḛjɨ je kɨ jie ɔdɨ, awi ɔdi njé mo̰y je adɨ ɨngəi rɔ nga nɨm, ndɨl je kɨ majal ka ɨyə̰i-de nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jɨpɨ je kɨ na̰ je kɨ njé njɨyə kɨ go ɓe je, kadɨ n-tuwəi ndɨl je kɨ majal, əi je ka gei kadɨ n-ɓai tɔ Ɓaɓe Jəju dɔ dɨje tɨ kɨ əi gɨn tɔgɨ tɨ lə ndɨl je kɨ majal tɔ. Adɨ əli əi nə: «Me tɔ Jəju tɨ kɨ Pol ɨsɨ ɨlə mbḛ ta lie, m-dəjɨ səsi kadɨ ɨtḛḛi kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Dɨje kɨ njé ra nḛ be ka kɨn, əi sɨri. Əi ngan lə Jɨpɨ kare kɨ tɔe nə Səba. E kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","NDɨl kɨ majal təl ɨlə-de tɨ ə nə: «M-gər Jəju, taa m-gər dəw kɨ e Pol tɔ, nə səi, səi na̰ je ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lo kɨn tɨ, dəw kɨ ndɨl je majal ɨsi me tɨ ka kɨn ḭ ur dɔde tɨ uwə-de tɔsɔsɔ. Nɨngə ɨndə-de kɨndə kɨ dəw oo go madɨne al, adɨ tḛḛi me kəy tɨ kɨ ka̰y kɨ rɔde kare, kɨ kɨbɨ kɨ gangɨ rɔde tɨ batɨ batɨ kɨ məsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Dɨje pətɨ kɨ ɓe bo Epəjɨ tɨ, kɨ Jɨpɨ je, naa tɨ kɨ dɨje kɨ əi Jɨpɨ je al, gəri go nḛ kɨ ra nḛ kɨn majɨ. Əi pətɨ ɓəl ra-de, adɨ ɔsi gon Ɓaɓe Jəju. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Dɨje ngay kɨ əi njé kadɨ-me je rəi tɔri ndude, ə əli kɨlə rade je kɨ majal kɨ taga no̰ dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","NJé kɨ na̰ je dan njé ra mbəli je tɨ, rəi kɨ makɨtɨbɨ ra mbəli je ləde, kawi kɨ dɔ-naa tɨ ə ɨləi por ta kəm dɨje tɨ. Gatɨ makɨtɨbɨ je ləde kɨn asɨ sɨlə dɨbɨ kutɨ mi nja dɨbɨ kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","E be ə, kɨ takul tɔgɨ lə Ɓaɓe, ta lə Luwə sane lo je tɨ kɨ kəte kəte kɨ tɔgɨne tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Go nḛ je tɨ kɨn, NDɨl Luwə ɔsɨ Pol adɨ un ndune kadɨ n-aw ɓe bo Jorijaləm tɨ. Dɔ rəbɨ kawe tɨ, ɨndə dɔnangɨ Masəduwan kɨ Akay gangɨ. Nɨngə Pol əl ə nə: «Re m-aw m-tḛḛ ɓe bo Jorijaləm tɨ ɓa, majɨ kadɨ m-aw m-o dɔnangɨ Rom tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pol ɨlə kɨ njé ra sie kɨlə je joo, Tɨmote əi kɨ Erasɨ adɨ-de awi dɔnangɨ Masəduwan tɨ. Nɨngə e wa, ɨsɨ dɔnangɨ Aji tɨ ba njaba ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dɔkagɨloe tɨ kɨn, ta kasɨ-naa al kɨ bo ngay ḭ dɔ rəbɨ ta tɨ lə Ɓaɓe me ɓe tɨ kɨ Epəjɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Dəw kare kɨ tɔe nə Dəmetɨrusɨ, e kɔdɨ kɨ nje ra nɨngə kasɨ je. E nje ra ngan kəy yo kɨ dəne kɨ a ɓari-e nə Artəmɨsɨ. Kɨlə kɨn ra adɨ e sotɨ kɨ njé kɨlə je lie ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Be ə, Dəmetɨrusɨ kaw kɔdɨ je kɨ dɨje pətɨ kɨ ɨsɨ kɨ dɔde taa kɨ takul kɨlə kɨn naa tɨ, ə əl-de ə nə: «Madɨm je, ɨgəri kadɨ e kɨ takul kɨlə kɨn ə, j-ɨsɨ j-ɨngəi nḛ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Səi je oi kɨ kəmsi taa kɨ mbɨsi tɔ, kadɨ e Epəjɨ tɨ ne par al, nə dɔnangɨ Aji tɨ ba pətɨ, ə dɨngəm kɨ tɔe nə Pol kam təl dɔ kosɨ dɨje basi. E əl-de ə nə: “Kagɨ yo je kɨ dɨje rai kɨ jide əi Luwə al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","E kɨlə je kɨ j-ɨsi rai kɨn par ə dɨje a ooi tə nḛ kɨ kare al, nḛ kəy lə yo kɨ dəne kɨ bo kɨ e Artəmɨsɨ kɨn ka, dɨje a ooi-e nḛ madɨ tɨ al tɔ. Lo kadɨ dɨje a əli ə nə: “Artəmɨsɨ e yo kɨ dəne kɨ bo,” goto. Artəmɨsɨ kɨ dɨje kɨ dɔnangɨ Aji tɨ kɨ ndəgɨ dɔnangɨ ba pətɨ ɔsi gone kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lokɨ kɔdɨ je ooi ta je kɨn nɨngə, wongɨ rade ngay, adɨ ɨləi ngɨrə kadɨ əli ta kɨ ndude kɨ boy əi nə: «Artəmɨsɨ lə Epəjɨ je, e kɨ bo.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kalangɨ ba go tɨ nɨngə, lo sɨngə sokɨto kɨ ta tate ba me ɓe bo tɨ. Dɨje ndɔri Gayusɨ əi kɨ Arɨsɨtarkɨ, dɨje kɨ Masəduwan tɨ, kɨ əi madɨ mba lə Pol je kəmde tɨ, ə ngɔdɨ tɔl-n-de kɨ ta mbalo tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ndɨgɨ mba kadɨ n-tɔjɨ rɔne kosɨ dɨje, nə njé ndo je ɔgi-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Nɨngə basa madɨ Pol je madɨ kɨ əi dɨje kɨ bo kɨ dɔnangɨ Aji tɨ, ɨləi kɨlə rɔe tɨ, əli-e kadɨ aw ta mbalo tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ta mbalo tɨ, nḛ kɨ to ay njay dɔ dɨje tɨ goto. Ta je kɨ ɨsɨ tḛḛ ta dɨje tɨ əi ta je kɨ dangɨ dangɨ. Nɨngə dɨje ngay dan madɨde je tɨ gəri gɨn nḛ kɨ kawi-naa al. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Dɨje kɨ na̰ je dan kosɨ dɨje tɨ ɔri gɨn nḛ kɨ ra nḛ kɨn adɨ Aləgɨjandɨr kɨ *Jɨpɨ je ɨndəi-e tə nje kun dɔde kɨn ade oo. Aləgɨjandɨr ɨlə jine taa, dəjɨ-n dɨje mba kadɨ ai kekeke, tadɔ ge kəl ta, ɔr-n ta dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lokɨ gəri-e kadɨ e Jɨpɨ nɨngə, əi je pətɨ ɨləi bɨlə kɨ ndude kɨ bo asɨ ngɨrə kadɨ joo je be əi nə: «Artəmɨsɨ lə Epəjɨ je, e kɨ bo.» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ta tɔl ta tɨ nɨngə, nje ndo ndu-kun kɨ me ɓe bo tɨ, re ra adɨ lo to jɨjɨji, ɓəy taa əl-de ə nə: «Səi dɨje kɨ Epəjɨ tɨ, na̰ ə gər kadɨ ɓe kɨ Epəjɨ tɨ, e nje ngəm kəy lə Artəmɨsɨ kɨ e yo kɨ dəne kɨ e kɨ bo kɨn al ə, ə se na̰ ə gər kadɨ e nje ngəm mbal kɨ e bana kəme kɨ ḭ dɔra̰ tɨ osɨ kɨn al ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","E kɨn e nḛ kɨ dum majɨ. Majɨ kadɨ uwəi angalsi ɨndəi nangɨ, ə ɨməri ta taa ɨrai nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Səi je ə ɔri dɨje kam ɨrəi səde ne, nga, nḛ madɨ kɨ majal kɨ rai ɔsi ta kəy kɨn goto, taa əli ta kɨ mal dɔ yo tɨ ləje kɨ dəne Artəmɨsɨ al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Re Dəmetɨrusɨ əi kɨ dɨje kɨ njé ra kɨlə je ləne, ai kɨ ta kɨ dəw madɨ nɨngə, ndɔ gangɨ ta je to no̰o̰, ə majɨ kadɨ awi ooi njé gangɨ ta je. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Re nḛ madɨ kɨ rangɨ to no̰o̰ kadɨ ɨdəji ə, ndɔ kɨ kadɨ njé kɨndə manjɨ ta je kɨn kɨ go rəbe tɨ to no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nḛ je kɨ rai nḛ ɓone kɨn, asɨ kadɨ dɨje ɨləi ta dɔje tɨ tə njé kal dɔ ndu je, tadɔ ta madɨ kɨ j-a j-əli ə j-a j-ɔrii ta dɔ je tɨ, kɨ ɔjɨ go kaw-naa lə dɨje kɨ ɓone kɨn goto. Be ə, go ta je tɨ kɨ nje ndo ndu-kun əl, tuwə dɨje adɨ sanəi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lokɨ wongɨ lə dɨje yogɨro nɨngə, Pol ɨlə ɓar njé ndo je, ɨlə dɨngəm mede tɨ ɓəy taa rade lapɨya ə ɔtɨ aw Masəduwan tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pol ɨngə dɔkagɨlo je ngay ɨlə-n dɨngəm me njé kadɨ-me je tɨ lokɨ ɨsɨ ɨndə dɔnangɨ ka kɨn gangɨ. Nɨngə gangɨ kɨ kəte no̰o̰ aw Gɨrəkɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pol ɨsɨ tɨ no̰o̰ nay mɨtə. Dɔkagɨlo tɨ kɨ kadɨ un bato kɨ kaw kɨ dɔnangɨ Sɨri tɨ nɨngə, gər kadɨ *Jɨpɨ je ləi tade nangɨ kadɨ n-rai sie nḛ kɨ majal. Be ə, təl un rəbɨ kɨ Masəduwan tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","MBo̰ dɨje tɨ kɨ dani-e a ɨngə Sopatər kɨ ngon lə Pɨrusɨ kɨ Bəre tɨ nɨm, Arɨsɨtarkɨ əi kɨ Səgo̰dusɨ kɨ əi dɨje kɨ Təsalonɨkɨ tɨ nɨm, Gayusɨ kɨ Dərbɨ tɨ nɨm, Tɨmote nɨm, taa Tɨsɨkɨ əi kɨ Tɨropɨm kɨ əi dɨje kɨ dɔnangɨ Aji tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dɨje kɨn ɔti kəte no̰je tɨ, awi ngɨnəi-je Tɨrowasɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Je ɓa, go ndɔ je tɨ lə mapa kɨ ra kɨ kanjɨ əm, ə j-al me bato tɨ me ɓe tɨ kɨ Pɨlɨpɨ j-ɨsɨ j-aw. J-aw, jɨ ra ndɔ mi rəbə, ɓa j-aw j-ɨngə madɨje je Tɨrowasɨ tɨ, jɨ ra ndɔ sɨri. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","NDɔ dɨmasɨ, jɨ kaw-naa mba kuso mapa, Pol a aw lo ti tɨ, adɨ əl ta kɨ njé ndo je. Be ə, əl ta ratata dan lo dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jɨ kaw-naa me kəy tɨ kɨ e dɔ made tɨ taa. Nɨngə me kəy tɨ ka kɨn, lambɨ je ngay əi tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lokɨ Pol ɨsɨ əl ta adɨ ngal, Basa kare kɨ tɔe nə Etɨkusɨ ɨsɨ pənətɨr tɨ, to ɓi makɨ, adɨ ɓi un-e, ḭ kəy tɨ kɨ ko̰ mɨtə dɔ made tɨ, tḛḛ osɨ. Lokɨ dɨje əi nə n-uni-e ɓa, basa oy. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol ur nangɨ, dəbɨ rɔne dɔe tɨ ə un-e jine tɨ ɓa əl-de ə nə: «Kadɨ mesi gangɨ man al nə to kəm ɓəy!» ");
INSERT INTO bjvNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Go tɨ, Pol təl al aw ta gogɨ, gangɨ mapa uso. Un ta kɨ tane tɨ gogɨ bɨtɨ ta gɨn lo tɨ, ɓa ɔtɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","NGa nɨngə, dɨje ɔri basa awi sie ɓe kəm, adɨ dɨje pətɨ mede osɨ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Je j-aw kəte kɨ bato me ɓe tɨ kɨ Asosɨ. Me ɓee tɨ kɨn ə, j-a j-un Pol naa tɨ səje. Tadɔ kɨ go kɔjɨ ta tɨ lie, ge kadɨ n-un rəbɨ kɨ njane. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Lokɨ re ɨngə-je Asosɨ tɨ, j-un-e me bato tɨ naa tɨ səje ə j-aw Mɨtɨlən tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lo ti go tɨ nɨngə, j-ɔtɨ no̰o̰, jɨ re jɨ tḛḛ ta lo tɨ kɨ Kɨyo. NDɔ kɨ go tɨ nɨngə, jɨ tḛḛ Samosɨ. NDɔ kɨ ko̰ sɔ ɓəy taa jɨ tḛḛ Mɨle tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ndɨgɨ kadɨ n-a lo ka tɨ Epəjɨ tɨ al nə pane taa dɔkagɨlo də dɔne tɨ dɔnangɨ Aji tɨ. Ge mba kadɨ n-aw kalangɨ kadɨ re to-n ban wa ka, ndɔ Pa̰təkotɨ osɨ dɔne tɨ Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lokɨ Pol e me ɓe tɨ kɨ Mɨle ɓa, ɨlə ɓar ngatɔgɨ je lə njé kaw-naa je kɨ Epəjɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Lokɨ rəi tḛḛi rɔe tɨ nɨngə, əl-de ə nə: «Ɨgəri rəbɨ pa njɨyəm dɔkagɨlo je pətɨ kɨ mi-n səsi naa tɨ, ɨlə ngɨre dɔ ndɔ kɨ dɔsa̰y tɨ kɨ m-re-n dɔnangɨ Aji tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","M-ra kɨlə ɓəə lə Ɓaɓe kɨ dɔ kɨ sɔl lɔm lɔm, me man no̰ tɨ kɨ me nḛ na je tɨ kɨ m-ɨngə kɨ rəbɨ je kɨ dangɨ dangɨ kɨ go rəbɨ kɨlə ta nangɨ kɨ ḭ rɔ *Jɨpɨ je tɨ kɨ madɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Səi ɨgəri ɓətɨ, m-ɓɔyɔ səsi dɔ nḛ madɨ kare al. M-ɨlə səsi mbḛ Poy Ta kɨ Majɨ ta m-ndo səsi nḛ je pətɨ kɨ a ra səsi majɨ tɔ, taga dan kosɨ dɨje tɨ nɨm, me kəy je tɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","M-ɨlə mbḛ Jɨpɨ je nɨm, Gɨrəkɨ je nɨm kadɨ təli rɔde go Luwə tɨ ə ɨyə̰i go rəbɨ nḛ rade je kɨ majal kɨn kɔ, taa kadɨ adi mede Ɓaɓe ləje Jəju Kɨrɨsɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kɨ ɓasɨne kɨn, NDɨl Luwə ɨndə dɔm tɨ, adɨ m-ɨsɨ m-aw Jorijaləm tɨ kɨ kanjɨ kadɨ m-gər nḛ kɨ a ra-m nu. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nḛ kɨ m-gər, me ɓe bo je tɨ kare kare kɨ m-tḛḛ tɨ, NDɨl Luwə adɨ-m m-gər təkɨ dangay je kɨ ko̰ je ɨsɨ ngɨnəi-mi no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kɨ ɔjɨ dɔm, kɨsɨ kɨ dɔ ta ləm e nḛ madɨ ta kəm tɨ al. Nḛ ge ləm e kadɨ m-aw ratata m-tɔl ta ngɔdɨ ləm, ə kadɨ m-ra kɨlə ɓəə kɨ m-ɨngə ji Ɓaɓe tɨ kɨn majɨ. Adɨ e kɨlə kɨlə mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ me-majɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nɨngə ɓasɨne, m-gər kadɨ səi pətɨ kɨ m-njɨyə dansi tɨ ə m-ɨlə səsi mbḛ Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ ko̰ɓe lə Luwə kɨn, a oi kəm gogɨ al ratata ngata. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","E be ə, m-əl ta ləm taga ay njay ɓone, ta məsɨsi səi pətɨ goto dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tadɔ kɔjɨ ta ra je lə Luwə pətɨ, m-ɨlə mbḛ dɔ tɨ madɨ oi. Nḛ kɨ m-ɓɔyɔ dɔe rɔsi tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɨndəi kəm-kədɨ dɔ rɔsi tɨ səi je wa, taa dɔ nḛ kul je tɨ kɨ NDɨl Luwə adɨ səsi kadɨ ɨngəmi-de kɨn tɔ. Majɨ kadɨ ɨndəi kəmsi go njé kaw-naa je tɨ lə Luwə kɨ ndogɨ-de kɨ məsɨne, tə njé ngəm nḛ kul je kɨ majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","M-gər kadɨ lokɨ m-a m-goto dansi tɨ, dɨje madɨ kɨ a toi tə jagɨm je kɨ njé me ndul, a rəi uri dansi tɨ ə a rai njé kaw-naa je majal. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Nɨngə mbo̰si tɨ wa ka, dɨje madɨ a təli njé rugɨ ta kɨ rɔjetɨ mba kadɨ təli njé kaw-naa madɨ je njé ndo je tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Majɨ kadɨ ɨsi dɔgɨ tɨ, adi mesi ole dɔ tɨ, təkɨ me ɓal tɨ kɨ mɨtə kɨ m-ra dansi tɨ, kondɔ kɨ kada, kare kare pətɨ, m-ɨyə̰ ta kɨlə dɨngəm mesi tɨ al, kɨ man no̰ kəm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nɨngə ngɔsɨne, m-ɨlə səsi ji Luwə tɨ, taa m-ndəjɨ səsi kɨ ta lie kɨ go me-majɨ tɨ lie tɔ. Ta kɨn aw kɨ tɔgɨ mba kadɨ adɨ ɨtɔgii me kadɨ-me tɨ, taa Luwə a adɨ səsi nḛ majɨ je pətɨ kɨ ɨsɨ ngəm mbata tɨ lə dɨje pətɨ kɨ əi ya̰e je tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Lo kɨ mi dansi tɨ, m-ra kəm-nda la, ə se ɔr ə se kɨbɨ lə dəw madɨ dansi tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Səi je wa ɨgəri ɓətɨ, kadɨ kɨ ɔjɨ dɔ kɨsɨ kɨ dɔ taa ləm, ə se kɨ ya̰ madɨ-kɨləm je, m-ra kɨlə kɨ jim mi wa. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","M-ɔjɨ səsi kɨ lo je pətɨ, ə se kɨ dɔkagɨlo je pətɨ kadɨ ɨrai kɨlə be mba kadɨ ɨndəi kəmsi go njé ndoo je tɨ. Nɨngə majɨ kadɨ mesi ole dɔ ta tɨ kɨ Ɓaɓe Jəju wa əl kɨ tane ə nə: “Majɨ-kur e ngay dɔ ji tɨ kɨ adɨ ɨtə ji kɨ taa.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Go ta je tɨ kɨ Pol əl kɨn nɨngə, ɔsɨ məkəsɨne nangɨ, ɓa əl ta kɨ Luwə kɨ mbata tɨ ləde pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɓa go tɨ, əi pətɨ, ɓuki-naa kɨ no̰ tɨ, tosi mɨndɨ Pol tɨ uwəi-e, orəi-e kɨ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ta lie kɨ əl-de ə nə: «A oi kəm gogɨ al, ngata» kɨn ɔr tɔgɨde ngay. Nɨngə dani-e bɨtɨ awi sie ta bato tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Go kɨyə̰-naa tɨ kɨ ngatɔgɨ je lə njé kaw-naa je kɨ Epəjɨ tɨ, j-al me bato tɨ, ə j-aw njururu dɔ dər tɨ kɨ tɔe nə Kosɨ. Lo ti go tɨ nɨngə, jɨ tḛḛ me ɓe bo tɨ kɨ Rodɨ. J-ɔtɨ Rodɨ tɨ ɓa j-aw ɓe bo tɨ kɨ Patara. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","J-ɨngə bato kɨ ɨsɨ aw Pənəsi tɨ adɨ j-al me tɨ j-aw sie. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Lokɨ j-o dɔ dər Sɨpɨr kɨ kəmje be nɨngə, j-ɨyḛ kɨ dɔ ji gəl je tɨ ə j-ɔr taa kɨ dɔnangɨ Sɨri tɨ. J-aw j-ur nangɨ Tɨr. Lo kɨn tɨ no̰o̰ kɨ a ɔri nḛ je kɨ me bato tɨ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","J-ɨngə njé ndo je me ɓe tɨ ka kɨn no̰o̰, adɨ j-ɨsɨ səde asɨ ndo sɨri. *NJé ndo je ka kɨn, NDɨl Luwə ɔsɨ-de adɨ əli Pol kadɨ aw Jorijaləm tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nə lokɨ dɔkagɨlo ləje asɨ nɨngə, j-ḭ taa, j-un ta rəbɨ ləje. NJé ndo je pətɨ, kɨ nede je, kɨ ngande je dani je bɨtɨ tḛḛi səje gɨdɨ ɓe bo tɨ. Loe tɨ no̰o̰, j-ɔsɨ məkəsɨje nangɨ ta ba tɨ, j-əl ta kɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Go tɨ, lokɨ j-əl-naa ta je kɨ dɔbəy tɨ kɨ kadɨ j-ɨyə̰-n-naa ɓa, j-al me bato tɨ ə əi je təli kɨ ɓe je ləde tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","J-ɨndə ngangɨ kaw mba ləje kɨ bato, lo kɨ j-ḭ Tɨr tɨ jɨ re jɨ tḛḛ Toləmayɨsɨ tɨ. Me ɓe bo tɨ kɨn no̰o̰, j-uwə ji ngako̰je je, ɓa j-ɨsɨ səde ndɔ kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo ti dɔ tɨ nɨngə, jɨ re jɨ tḛḛ Səjare tɨ. J-aw me kəy tɨ lə Pɨlɨpɨ kɨ e nje kɨlə mbḛ Poy Ta kɨ Majɨ, kɨ e mbo̰ dɨje tɨ kɨ sɨri kɨ njé kɨndə kəmde go nḛ majɨ je tɨ lə njé kaw-naa je kɨ Jorijaləm tɨ. J-ɨsɨ rɔe tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Me kəy tɨ lie, ngan dəne je sɔ kɨ gəri dɨngəm al ɓəy, kɨ əi njé kəl ta je kɨ ta Luwə tɨ ɨsi səm tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","J-ɨsɨ me kəy tɨ lə Pɨlɨpɨ ka kɨn jɨ ra ndɔ ngay nga ɓa kadɨ nje kəl ta kɨ ta Luwə tɨ kɨ tɔe nə Agabusɨ ḭ Jude tɨ re ɨngə je no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","NJe kəl ta kɨ ta Luwə tɨ ka kɨn un nda dɔ ɓədɨ lə Pol dɔɔ-n jine je kɨ njane je, nɨngə əl ə nə: «NDɨl Luwə əl ə nə, me ɓe bo tɨ kɨ Jorijaləm, kɨ bo je lə *Jɨpɨ je a dɔɔi ɓa nje nda dɔɔ ɓədɨ kɨn be. Nɨngə a ɨləi-e ji dɨje tɨ kɨ əi Jɨpɨ je al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Lokɨ j-o ta kɨn nɨngə je kɨ ngako̰je je kɨ Səjare tɨ j-uwə nja Pol, jɨ dəje kadɨ aw Jorijaləm tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nə Pol ɨlə-je tɨ ə nə: «Oti kadɨ ɨno̰i adɨ mem gangɨ man. Mi Pol mi ɓasi kadɨ dɨje tɔi-mi par al, nə re ɔjɨ dɔ koy ka, mi ɓasi kadɨ m-oy kɨ mbata tɔ Ɓaɓe Jəju Jorijaləm tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lokɨ j-o kadɨ Pol yətɨ ndune go ta je tɨ kɨ j-əl-e, al, je ka jɨ təl jɨ ta kə̰ə̰ tɔ, ə jɨ təl jɨ dəjɨ kadɨ Luwə ra ndɨgɨ ləne par. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Go ndɔ je tɨ kɨ ban wa kɨ jɨ ra dɔnangɨ Səjare tɨ, jɨ ra go rɔje ə j-ɔtɨ j-aw Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","NJé ndo je kɨ madɨ kɨ Səjare tɨ awi səje naa tɨ Jorijaləm tɨ. Lokɨ jɨ tḛḛ Jorijaləm tɨ nɨngə dani je me kəy tɨ kɨ dəw madɨ kɨ tɔe nə Mɨnaso̰, adɨ j-ɨsɨ tɨ. E dəw kɨ Sɨpɨr tɨ. E kɨ kare mbo̰ njé ndo je tɨ kɨ dɔsa̰y. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Lokɨ jɨ re jɨ tḛḛ Jorijaləm tɨ, ngako̰je je uwəi-je rɔde tɨ kɨ rɔnəl kɨ ətɨ ɓəl. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lo ti dɔ tɨ, Pol aw səje me kəy tɨ lə Jakɨ. Lo kɨn tɨ ə, j-ɨngə ngatɔgɨ je lə njé kaw-naa je pətɨ, tɨtɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Go kuwə ji tɨ kɨ Pol uwə jide nɨngə, ɔr-de poy nḛ je kɨ Luwə ra kɨ mbata gɨn dɨje kɨ əi Jɨpɨ je al, kɨ takul kɨlə lie kɨn, bəre bəre adɨ-de ooi. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Go nḛ je tɨ kɨ Pol ɔr-de poye kɨn nɨngə, ɨləi tɔjɨ dɔ Luwə tɨ, ɓa əli Pol əi nə: «NGoko̰je, ɨndə kəmi o, Jɨpɨ je dɨbɨ ba̰y ba̰y ə adi mede Jəju, nə pətɨ uwəi go ndu-kun lə *Mojɨ nga̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nɨngə kɨ ɓasɨne kɨn ooi ta dɔi tɨ təkɨ ɨsɨ ɨndo Jɨpɨ pətɨ kɨ ɨsi tə mba je dɔnangɨ je tɨ kɨ rangɨ kadɨ ɨyə̰i go ndu-kun je lə Mojɨ kɔ nɨm, əl-de kadɨ ɨjəi mɔtɨ ngande je al nɨm, taa nḛ jibəl ɓe je lə Jɨpɨ je ka kadɨ uni goe al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Adɨ jɨ gɨri dɔ nḛ tɨ kɨ kadɨ jɨ rai, tadɔ a ooi poyi kadɨ ɨre ka par am! ");
INSERT INTO bjvNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Be ə, majɨ kadɨ ɨra nḛ je kɨ j-a j-əli kam. J-aw kɨ dɨje sɔ mbo̰ je tɨ ne kɨ uni mɨndɨde kadɨ n-ɨndəi rɔde ta dangɨ mbata lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Majɨ kadɨ ɔr dɨje kɨn goi tɨ, ə ɨra səde nḛ jibəl ɓe kay rɔ dɔ majal tɨ, ə ɨgə dɔde mba kadɨ ngɨsəi dɔde. Nɨngə dɨje pətɨ a gəri kadɨ poy ta je pətɨ kɨ ooi ɔjɨ dɔi e ta je kɨ ngom. Tadɔ ḭ wa kɨ dɔi, ɨtəl rɔi go ndo kun je tɨ lə Mojɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kɨ ɔjɨ dɔ dɨje kɨ əi Jɨpɨ je al kɨ adi mede, ndu-kun je kɨ jɨ ndangɨ j-ɨlə-n j-adɨ-de, e kadɨ usoi da kɨ dəw gugɨ-n yo al nɨm, kadɨ usoi məsɨ al nɨm, da kɨ dəw tu mɨnde al nɨm, taa kadɨ sangɨ-naa kɨ go lo kaya tɨ ka goto dande tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","E be ə, lo ti go tɨ nɨngə, Pol aw kɨ dɨje kɨ sɔ ka kɨn, ay rɔne səde, ɓa goto ur natɨ kəy tɨ lə Luwə, ɔjɨ ndɔ kɨ gɨn kay rɔ ləde a gangɨ-n, ə kadɨ dəw kɨ ra dande tɨ a re-n kɨ kadɨ-kare, kadɨ adɨ Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lokɨ nay ɓasi kadɨ gɨn ndɔ kɨ sɨri gangɨ, *Jɨpɨ je madɨ kɨ ḭḭ dɔnangɨ Aji tɨ, ooi Pol kəy kaw-naa tɨ, suləi kosɨ dɨje dɔe tɨ ə osi sie uwəi-e, ");
INSERT INTO bjvNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","nɨngə əli ta kɨ ndude kɨ bo əi nə: «Səi dɨje kɨ *Isɨrayəl, ɨrəi ɔsi gɨn je! Dəw kam ə, e nje ndo dɨje kɨ lo je pətɨ kadɨ ɔsi ta dɨje ləje nɨm, ndu-kun je ləje nɨm taa kəy kaw-naa kɨn nɨm tɔ. Nɨngə kɨ rangɨ ɓəy, re ur kɨ dɨje kɨ ɨjəi mɔtɨde al natɨ kəy tɨ lə Luwə mba kadɨ təl-n lo kɨ ay njay kɨn, lo kɨ to njḛ tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Əli ta kɨn be, mbata kəte ooi Tɨropɨm, dəw kɨ ɓe bo Epəjɨ tɨ sie me ɓe bo Jorijaləm tɨ. Adɨ gɨri kadɨ re ur sie kəy kaw-naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Dɨje awi pɨr pɨr dɔ-naa tɨ me ɓe bo tɨ kɨ Jorijaləm tɨ ba pətɨ. Nɨngə dɨje tḛḛi kɨ lo njo̰ njo̰ ɨsɨ rəi bur bur. Rəi uwəi Pol tḛḛi sie kəy kaw-naa tɨ taga. Nɨngə taji naa tɨ no̰o̰ uwəi ta kəy je uti. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dɨje sangi kadɨ n-tɔli Pol. Nɨngə kəte ɓəy taa kadɨ tɔli-e, poy ta osi mbi kɨ bo kɨ dɔ asɨgar je tɨ kɨ Rom tɨ təkɨ ɓe bo Jorijaləm ba pətɨ a kɨ njane taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Taji naa tɨ no̰o̰ par ə, ḭ taa ɔy asɨgar je kɨ kɨ bo je kɨ dɔ ɓutɨ asɨgar je tɨ kɨ ɓu, ə a̰y ngɔdɨ kɨ rɔ kosɨ dɨje tɨ. Lokɨ kosɨ dɨje ka kɨn ooi kɨ bo kɨ dɔ asɨgar je tɨ kɨ asɨgar je nɨngə, taai kə̰ə̰ ta kɨndə Pol tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lokɨ re tḛḛ rɔ kosɨ dɨje tɨ, kɨ bo kɨ dɔ asɨgar je tɨ ka kɨn ɔtɨ ɓasi kɨ rɔ Pol tɨ, un ndune adɨ uwəi-e, ə adɨ dɔɔi-e kɨ kulə gɨndɨ joo. Nɨngə təl dəjɨ ta ə nə: «Na̰ e dɨngəm kam ə? Ə ri ə ra ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nɨngə tur ta to dangɨ dangɨ dan kosɨ dɨje tɨ, ta ləde un go-naa al. Adɨ lo kadɨ kɨ bo kɨ dɔ asɨgar je tɨ ka kɨn oo ta kɨ rɔjetɨ goto. Be ə un ndune kadɨ awi kɨ Pol me ndogɨ bɔr tɨ kɨ ngal, lo kɨsɨ asɨgar je tɨ ");
INSERT INTO bjvNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lokɨ Pol re tḛḛ rɨgɨ lo njɨyə je tɨ kɨn nɨngə, loe goto adɨ asɨgar je uni-e, tadɔ kosɨ dɨje bətɨrəi-e kɨ wongɨ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kosɨ dɨje kɨ ɨsi njɨyəi goe tɨ bur bur əli kɨ ndude kɨ boy əi nə: «Adɨ jɨ tɔl-e!» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kəte ɓəy taa kadɨ asɨgar je awi sie me ndogɨ bɔr tɨ kɨ ngal kɨ lo kɨsɨde tɨ, Pol dəjɨ ta kɨ bo kɨ dɔ asɨgar je tɨ ə nə: «A adɨ-m ta rəbɨ kadɨ m-əl-n ta kare a?» Nɨngə kɨ bo kɨ dɔ asɨgar je tɨ ka kɨn dəje ə nə: «Ɨgər kəl ta Gɨrəkɨ ɓətɨ a? ");
INSERT INTO bjvNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","M-gər al adɨ m-ɔjɨ m-ə nə ḭ dəw kɨ Ejɨpɨ tɨ kɨ ndɔ kɨ me ndɔ je tɨ kɨ gogɨ ne kɨn, sulə dɨje adɨ rai wongɨ, ə ɔr-de asi dɨje dɨbɨ sɔ kɨ bundungɨ je jide tɨ, ə ur-n wale kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ə Pol ə nə: «Jagɨ, mi Jɨpɨ kɨ ɓe bo tɨ kɨ Tarsɨ kɨ dɔnangɨ Sɨlɨsi tɨ, mi dəw kɨ me ɓe ɓo tɨ kɨ tɔe ɓa, ə njai ba ɨyə̰-m adɨ-m m-əl dɨje kɨn ta.» ");
INSERT INTO bjvNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Be ə, kɨ bo kɨ dɔ asɨgar je tɨ ade ta rəbɨ. Pol ḭ a taa dɔ rɨgɨ lo njɨyə tɨ, ɔy jine dəjɨ-n kosɨ dɨje kadɨ uri mbide. Lokɨ lo to jɨjɨji nɨngə, əl-de ta kɨ ta ebɨrə. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol əl ə nə: «NGakom je kɨ bawm je, uri mbisi majɨ kadɨ ooi ta kɨ m-aw tə m-əl səi ɓasɨne kadɨ m-najɨ-n ta dɔm tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lokɨ ooi kadɨ Pol əl-de ta kɨ ta Ebɨrə nɨngə, təli adɨ lo to jɨjɨji wa ɓəy kadɨ n-ooi ta lie. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Be ə Pol əl-de ə nə: «Mi Jɨpɨ kɨ oji-mi Tarsɨ tɨ, kɨ dɔnangɨ Sɨlɨsi tɨ. Nə oti-mi Jorijaləm tɨ ne. Gamalɨyəl ə e nje ndo-m ndu-kun lə kaje je kadɨ m-gər kɔre kɔre. Kəte m-tɨngə bɨl mbata lə Luwə təkɨ ai ɓasɨne kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","M-adɨ ko̰ dɨje kɨ njé kun go nḛ ndo kɨ m-ɨsɨ m-ndo kɨn kadɨ kɨ asɨ ta koyde. M-uwə-de, dəne je kɨ dɨngəm je, m-tɔ-de m-tɨlə-de dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ ngatɔgɨ je pətɨ asi kadɨ a mai najɨ ləm dɔ ta tɨ kɨn. Əi je wa ə m-taa makɨtɨbɨ jide tɨ je be kadɨ m-aw m-uwə-n ngako̰ je kɨ Damasɨ tɨ kɨ njé kun go nḛ ndo kɨn. M-uwə-de kadɨ m-re səde Jorijaləm tɨ ne m-ɓukɨ-de dangay tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Lokɨ mi dɔ rəbɨ tɨ, m-re ɓasi kɨ Damasɨ tɨ, nɨngə kɨ kadɨ kɨ e ɓasi kɨ jam dɔ ɓe ɓa, ta naa tɨ no̰o̰ par ə, kunjɨ kɨ bo ngay ḭ dɔra̰ tɨ re unjɨ gə dɔm. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","M-osɨ kɨ ta kəm nangɨ, nɨngə m-o ndu ta madɨ əl-m ə nə: “Sol, Sol, mbata ri ə ɨsɨ adɨ-m ko̰ be ə?” ");
INSERT INTO bjvNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ə m-ɨle tɨ m-ə nə: “Ḭ na̰ ə Ɓaɓe?” Nɨngə təl əl-m ə nə: “E mi Jəju kɨ Najarətɨ tɨ kɨ ɨsɨ adɨ-m ko̰.” ");
INSERT INTO bjvNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","NJé kɨ əi səm ooi kunjɨ ka kɨn majɨ, nə ooi ndu dəw kɨ ɨsɨ əl-m ta al. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Lo kɨn tɨ, m-dəje m-ə nə: “Ɓaɓe, e ri ə kadɨ m-ra ə?” NGata ə Ɓaɓe əl-m ə nə: “Ḭ taa aw Damasɨ tɨ no̰o̰, ə a əli-ni nḛ je pətɨ kɨ kadɨ ɨra.” ");
INSERT INTO bjvNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kunjɨ kɨ ətɨ ɓəl ngay ka kɨn ra adɨ kəmm oo lo al, adɨ dɨje kɨ əi səm ndɔri-mi tə ndɔr ə awi səm Damasɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nɨngə Damasɨ tɨ, dɨngəm kare kɨ ɓari-e nə Ananɨyasɨ ɨsɨ no̰o̰. E dəw kɨ nje ra go ndu-kun tɨ, adɨ Jɨpɨ je pətɨ kɨ Damasɨ tɨ ndɨgi ta lie ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","E ə aw rɔm tɨ əl-m ə nə: “NGokom Sol, kadɨ kəmi oo lo.” Nɨngə ta naa tɨ no̰o̰ par ə kəmm oo lo adɨ m-o-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ɓa əl-m ə nə: “Luwə lə kaje je mbəti kəte nu mba kadɨ ɨgər ndɨgɨ lie, ə kadɨ o nje ka dana, taa kadɨ o ta kɨ tae tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tadɔ a ḭ nje ma najɨ lie dɔ nḛ je tɨ kɨ o kɨ kəmi nɨm, o kɨ mbii nɨm, kɨ rɔ dɨje tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nɨngə kɨ ɓasɨne kɨn, nḛ kɨ nay kadɨ dəw ra goto ngata. Ə Ḭ taa, ɨɓa tɔ Luwə, ə ɨra batəm, adɨ majal je ləi e kɨ togɨ kɔ.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Lokɨ m-təl m-re Jorijaləm tɨ, m-ɨsɨ m-əl ta kɨ Luwə gɨn kəy tɨ lie nɨngə, m-o nḛ me ndɨl tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","M-o Ɓaɓe əl-m ə nə: “Ḭ taa law kadɨ ɨtḛḛ kɔ Jorijaləm tɨ, tadɔ a taai najɨ ləi kɨ a ma dɔm tɨ al.” ");
INSERT INTO bjvNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lo kɨn tɨ, m-əl-e m-ə nə: “Ɓaɓe, dɨje kɨn gəri majɨ kadɨ e mi ə kəte mi nje kaw kɨ lo kaw-naa je lə *Jɨpɨ je, m-uwə njé kɨ adi-ni mede, m-tɨndə-de je, m-tɨlə-de dangay tɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Taa lokɨ ndɔ kɨ ɨsɨ tɔli nje ma najɨ ləi Etɨyən kɨn ka, mi loe tɨ no̰o̰ tɔ. Adɨ ndum e naa tɨ kɨ njé tɔl-e je, mi wa m-ɨsɨ ta kɨbɨ je tɨ ləde m-ngəm.” ");
INSERT INTO bjvNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nə Ɓaɓe əl-m ə nə: “Aw, tadɔ m-a m-ɨlə-i sa̰y rɔ dɨje tɨ kɨ əi Jɨpɨ je al.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lokɨ uri mbide ooi ta lə Pol bɨtɨ tḛḛi dɔ ta tɨ kɨn ɓa, uni ndude kɨ taa əli əi nə: «Dəw kɨ be kɨn e dəw kɨ kadɨ goto kɔ dɔnangɨ tɨ. E dəw kɨ kadɨ ɨsɨ kɨ dɔne taa al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Uri kɔl nɨngə, tɔri kɨbɨ je ləde tɨləi kɔ, ə kəi bu sanəi kɨ taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Lo kɨn tɨ, nje kun dɔ asɨgar je un ndune kadɨ awi kɨ Pol me ndogɨ bɔr tɨ kɨ ngal kadɨ dəji-e ta kɨ ndəy kadɨ əl nḛ kɨ ra nḛ ə adɨ dɨje ɨsɨ ɨləi bɨlə dɔe tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nə, lokɨ dɔɔi Pol kadɨ ɨndəi-e ɓa, Pol əl kɨ bo lə asɨgar je kare kɨ a no̰o̰ ə nə: «Adɨ awi kɨ tɔgɨ kadɨ ɨndəii dəw kɨ Rom tɨ kɨ ta ka dəw gangɨ dɔe tɨ al wa?» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lokɨ kɨ bo lə asɨgar je oo ta kɨn nɨngə, aw əl kɨ bo kɨ dɔde tɨ ə nə: «Ɨra nḛ kɨ aw tə ra kɨn al, dəw kam e dəw kɨ Rom tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lo kɨn tɨ, kɨ bo kɨ dɔ asɨgar je tɨ re rɔ Pol tɨ dəje ə nə: «Əl-m adɨ m-o, ḭ dəw kɨ Rom tɨ a?» Ə Pol əl-e ə nə: «Oyo, mi dəw kɨ Rom tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ə kɨ bo kɨ dɔ asɨgar je tɨ əl Pol ə nə: «Mi m-adɨ la ngay ɓəy taa kadɨ m-təl-n dəw kɨ Rom tɨ.» Nə Pol əl-e ə nə: «Ya̰m mi, ojii-mi tə kojɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Par ə, ta naa tɨ no̰o̰, dɨje kɨ kəte kadɨ ɨndəi Pol, dəji-e-n ta ka kɨn tɔri rɔde gogɨ. Kɨ bo kɨ dɔ asɨgar je tɨ wa ka ɓəl ra-e tɔ, lokɨ oo kadɨ Pol e dəw kɨ Rom tɨ, ə n-adɨ dɔɔi-e kɨ kulə gɨndɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kɨ bo kɨ dɔ asɨgar je tɨ sangɨ kadɨ n-gər nḛ wa kɨ *Jɨpɨ je səki Pol kɨn ay njay. Be ə, lo ti dɔ tɨ nɨngə, adɨ tuti Pol, ɓa adɨ ndune kadɨ kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ njé gangɨ ta je lə Jɨpɨ je kawi-naa, ɓa aw kɨ Pol no̰de tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol go̰ njé gangɨ ta je lə Jɨpɨ je ba, ɓa əl-de ə nə: «NGakom je, mem uwə-m kɨ ta ndə̰y al, dɔ ka-m no̰ Luwə tɨ bɨtɨ ɓone.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nɨngə kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ ɓari-e nə Ananɨyasɨ adɨ ndune dɨje kɨ ai kadɨ Pol tɨ kadɨ ɨndəi tae. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ə Pol əl-e ə nə: «E ḭ ə Luwə a ɨndəi, ḭ bɔr kɨ kɔy po̰ gɨdɨ tɨ kadɨ nda kare. Ɨsɨ nḛ kadɨ ɨgangɨ ta dɔm tɨ kɨ go ndu-kun tɨ, nɨngə ɨtəl al dɔ ndu-kun, adɨ ndui kadɨ ɨndəi-mi ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","NJé kɨ ai kadɨ Pol tɨ ɓasi əli-e əi nə: «Ɨtajɨ kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je lə Luwə a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol əl-de ə nə: «NGakom je, m-gər kadɨ e kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je lə Luwə al. Tadɔ ndangi me makɨtɨbɨ tɨ lə Luwə əi nə: “A əl ta kɨ majal dɔ ngar tɨ lə dɨje ləi al.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Lokɨ Pol gər kadɨ dɨje kɨ kawi-naa kɨn, njé kɨ na̰ je əi *Sadusɨ je, ə njé kɨ nungɨ əi *Parɨsɨ je nɨngə, un ndune kɨ taa dan njé gangɨ ta je tɨ ə nə: «NGakom je, mi Parɨsɨ, nje kojɨ-m e Parɨsɨ. Nɨngə e kɨ mbata kɨndə kɨ m-ɨndə mem dɔ kḭ lo koy tɨ lə njé koy je kɨn ə rəi səm lo gangɨ ta tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Lokɨ Pol əl ta kɨn ɓa, ta kɨ najɨ-naa tɨ ḭ dan Parɨsɨ je tɨ kɨ Sadusɨ je, adɨ dɨje gangi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tadɔ Sadusɨ je əli əi nə dɨje a ḭḭ lo koy tɨ al, taa malayka je, kɨ ndɨl je ka gotoi tɔ. Nə Parɨsɨ je əli təkɨ nḛ je kɨn toi no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lo sɨngə sokɨto, ə njé ndangɨ ndu-kun je kɨ me ɓutɨ tɨ lə Parɨsɨ je ḭḭ taa əli ta kɨ tɔgɨde əli əi nə: «Je j-o nḛ madɨ kare kɨ majal rɔ dɨngəm tɨ kɨn al. Dɔmajɨ ə e ndɨl ə se malayka wa ə əl-e ta.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Lokɨ ta kasɨ-naa al aw kɨ kəte kəte, kɨ bo lə asɨgar je ɓəl kadɨ dɨje kɨn ḭḭ rɨbəi Pol. Be ə, un ndune adɨ asɨgar je kadɨ rəi ɔri Pol awi sie me ndogɨ bɔr tɨ kɨ ngal gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kondɔ go tɨ ɓa, Ɓaɓe tḛḛ ɔy rɔ Pol tɨ əl-e ə nə: «Uwə tɔgi ba. Təkɨ ɨma-n najɨ ləm Jorijaləm tɨ, majɨ kadɨ ɨma najɨ kɨn Rom tɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lokɨ lo ti, *Jɨpɨ je uni mɨndɨde kadɨ n-usoi nḛ al nɨm, n-a̰yḭ-naa man al nɨm, bɨtɨ kadɨ n-tɔli Pol ɓəy taa. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","NJé kɨ dɔɔi ta naa tɨ kɨn ali dɔ kutɨ sɔ kare. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Nɨngə awi əli kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ ngatɔgɨ je əi nə: «J-un mɨndɨje kɨ nga̰ ngay kadɨ j-uso nḛ al nɨm, j-a̰y man al nɨm, bɨtɨ kadɨ jɨ tɔl Pol ɓəy taa.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nɨngə kɨ ɓasɨne kɨn, səi je kadɨ ndusi e naa tɨ kɨ njé gangɨ ta je, ə kadɨ awi ɨngəi kɨ bo lə asɨgar je, əli-e təkɨ ɨgei kadɨ re kɨ Pol no̰si tɨ kadɨ ɨndəi manjɨ ta lie maje maje oi. NGa ə, lokɨ Pol a re ɓa, tḛḛ rɔsi tɨ al ɓəy ə je j-a jɨ tɔl-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","NGon lə konan Pol kare oo ta kɨn, adɨ aw go Pol tɨ me ndogɨ bɔr tɨ kɨ ngal əl-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Be ə, Pol ɓar nje kun dɔ ɓutɨ asɨgar je kɨ ɓu kare əl-e ə nə: «Aw kɨ ngon kɨn rɔ kɨ bo tɨ lə asɨgar je. Aw kɨ ta kare no̰o̰ kadɨ əl-e.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","NJe kun dɔ asɨgar je kɨ ɓu aw kɨ ngon ka kɨn rɔ kɨ bo tɨ ə əl-e ə nə: «Dangay kɨ ɓari-e Pol ə ɓar-m, ə nə m-re kɨ ngon kɨn rɔi tɨ, təkɨ aw kɨ ta kare no̰o̰ kadɨ əli.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kɨ bo lə asɨgar je, uwə ngon ka kɨn jine tɨ, ɔr-e aw sie dam kare, ɓa dəje ə nə: «Ta ri ə aw-n kadɨ əl-m ə?» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","NGon ka kɨn əl-e ə nə: «Jɨpɨ je dɔɔi ta naa tɨ kadɨ n-dəji-ni kadɨ ɨtḛḛ kɨ Pol lo ti tɨ, no̰ njé gangɨ ta je tɨ ləde, təkɨ gei kadɨ n-ɨndəi manjɨ ta lie maje maje n-ooi. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nə majɨ kadɨ o ta ləde al. Tadɔ dɨje kɨ ɨtəi kutɨ sɔ kare a toi rəbə kadɨ uwəi-e. Uni mɨndɨde kɨ nga̰ ngay be kadɨ n-usoi nḛ al nɨm, n-a̰yḭ-naa man al nɨm, bɨtɨ kadɨ n-tɔli-e ɓəy taa. Kɨ ɓasɨne kɨn, ɨsi dɔ njade tɨ, ɨsɨ ngɨnəi ndu ləi par.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kɨ bo lə asɨgar je, ndəjɨ ngon kɨ basa ka kɨn kadɨ əl ta kɨn kəte adɨ dəw kɨ rangɨ oo al, ɓa ɨyḛ adɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Go tɨ, kɨ bo lə asɨgar je, ɓa njé kun dɔ asɨgar je kɨ ɓu əi joo əl-de ə nə: «Ɔsi nja asɨgar je ɓu joo naa tɨ, njé sɨndə je dɔ sɨri, ə njé nɨngə je ɓu joo tɔ. Ɓa ɨsi dɔ njasi tɨ kadɨ kadɨ kɨ kutɨ joo gɨde kare ɓa, uni ta rəbɨ kɨ kaw kɨ Səjare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ɨndəi dɔ sɨndə je naa tɨ adi Pol tɔ. Ə kadɨ awi ɨtḛḛi sie rɔ nje ko̰ɓe tɨ, Pəlɨsɨ kɨ kanjɨ kadɨ nḛ madɨ ra-e.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kɨ bo lə asɨgar je ndangɨ makɨtɨbɨ kɨn be adɨ nje ko̰ɓe ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Mi Kɨlodɨ Lɨsɨyasɨ ə m-ndangɨ makɨtɨbɨ kɨn m-adi kɨ bo ləm, nje ko̰ɓe Pəlɨsɨ. Nḛ kɨ dɔsa̰y, m-uwə jii! ");
INSERT INTO bjvNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Nɨngə dɨngəm kɨn, Jɨpɨ je uwəi-e kadɨ re a tɔli-e, ə lokɨ m-o kadɨ e dəw kɨ Rom tɨ, m-aw kɨ asɨgar je m-taa-e-n jide tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","M-sangɨ kadɨ m-gər nḛ wa kɨ ra ə Jɨpɨ je səki-e-n, adɨ m-aw sie no̰ njé gangɨ ta je tɨ ləde əi Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lo kɨn tɨ ə, m-o kadɨ səki-e ɔjɨ dɔ ndu-kun je ləde, nə nḛ madɨ kare kɨ majal kɨ ra kɨ asɨ kadɨ dəw tɔl-e-n ə se uwe-n dangay tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eli-mi kadɨ Jɨpɨ je ɨsɨ sangi rəbɨ kadɨ n-tɔli-e, be ə, m-un-e law m-ɨlə sie m-adi. Ɓa m-əl-de kadɨ awi səki-e rɔi tɨ nu.» ");
INSERT INTO bjvNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Asɨgar je rai təkɨ kɨ bo ləde ɔjɨ-n-de, adɨ awi kɨ Pol kondɔ ratata tḛḛi sie A̰tɨpatɨrɨsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lo ti dɔ tɨ, asɨgar je kɨ njé nja təli gogɨ lo kɨsɨde tɨ, ə ɨyə̰i njé sɨndə je adɨ awi kɨ Pol. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lokɨ tḛḛi Səjare tɨ, njé sɨndə je adi makɨtɨbɨ nje ko̰ɓe, ə ɔji-e Pol tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","NJe ko̰ɓe tɨdə makɨtɨbɨ ka kɨn, ɓa dəjɨ Pol se e dəw kɨ dɔnangɨ tɨ kɨ ra wa? Ɓa oo kadɨ Pol e dəw kɨ Sɨlɨsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ə əl Pol ə nə: «M-a m-o ta kɨ tai tɨ, ndɔ kɨ njé səki-je wa a rəi.» Nɨngə adɨ ndune kadɨ ngəmi Pol me kəy ngar tɨ lə *Erodɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","NDɔ mi go tɨ, kɨ bo lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ ɓari-e nə Ananɨyasɨ re Səjare tɨ. Dɨje kɨ dani-e rəi sie əi ngatɔgɨ je taa nje najɨ ta dɔ dɨje tɨ kɨ ɓari-e nə Tərtulusɨ tɔ. Ananɨyasɨ kɨ dɨje kɨ goe tɨ kɨn awi səki Pol rɔ nje ko̰ɓe tɨ kɨ dɔnangɨ Səjare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lokɨ ɓari Pol ɓa, Tərtulusɨ ɨlə ngɨrə kɨndə ta dɔe tɨ no̰o̰ nje ko̰ɓe tɨ ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","«Ḭ kɨ bo, Pəlɨsɨ, kɨ takuli, kɨ takul gosɨ ko̰ɓe ləi, kɨ takul nḛ je kɨ ɨtu gɨnde kɨ mba majɨ lə dɨje me ɓe ə, j-ɨsɨ-n kɨ lapɨya. E kɨn e majɨ kɨ jɨ gər kɨ lo je pətɨ me nḛ je tɨ pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nɨngə, kadɨ j-ɨndəi kɔ tɨ ngay al, jɨ dəji kadɨ ur mbi, kɨ go me-majɨ tɨ ləi kadɨ o-n dɔ ta kɨ j-a j-əli ta je kare joo. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","J-o kadɨ dɨngəm kam e nje tujɨ ɓe. Re kɨ gangɨ-naa dan *Jɨpɨ je tɨ kɨ lo je pətɨ dɔnangɨ tɨ ne. E nje kun dɔ ɓutɨ lə dɨje kɨ Najarətɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Aw bɨtɨ kadɨ n-təl kɨ kəy lə Luwə lo kɨ to njḛ tɨ, ə j-uwe.  ");
INSERT INTO bjvNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Jɨ ndɨgɨ kadɨ jɨ gangɨ ta dɔe tɨ kɨ go ndu-kun tɨ ləje, nə nje kun dɔ asɨgar je kɨ ɓari-e nə Lɨsɨyasɨ, re ɨndə tɔgɨ taa-e-n jije tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nɨngə un ndune kadɨ njé kɨndə ta dɔe tɨ rəi no̰i tɨ. Kɨn ə ɨdə-je ta ə, ḭ wa a oo kadɨ ta je kɨ j-əli dɔe tɨ kɨn e ta kɨ rɔjetɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jɨpɨ je ɨndəi rɔde naa tɨ kɨ Tərtulusɨ əi nə, ta je kɨ əl dɔ Pol tɨ e ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","NJé ko̰ɓe ra nḛ madɨ adɨ-n ta rəbɨ Pol kadɨ əl ta. Be ə, Pol un ta tane tɨ ə nə: «M-gər kadɨ asɨ ɓal ngay ə ɨsɨ gangɨ ta me ɓe tɨ ləje ne. Nɨngə, e kɨ go taa kɨ m-taa mei ə m-a m-najɨ-n ta dɔm tɨ no̰i tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Asɨ kadɨ ḭ wa ɨsangɨ gɨne ə a ɨgər majɨ. Kaw kɨ m-aw Jorijaləm tɨ m-ɔsɨ dɔm nangɨ no̰ Luwə tɨ kɨn, man dɔ ndɔ kɨ dɔgɨ gɨde e joo al ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nɨngə, lokɨ m-aw kɨn, e gɨn kəy tɨ lə Luwə, ə se gɨn kəy kaw-naa tɨ lə *Jɨpɨ je, ə se lo madɨ tɨ kɨ rangɨ me ɓe bo tɨ no̰o̰, dəw kɨ oo-je, j-ɨsɨ jɨ najɨ-naa ta tɨ kɨ dəw madɨ, ə se oo-m m-ɨsɨ m-sulə dɨje goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Taa dɨje wa kɨ ai ne kam, asi kadɨ ɔji nḛ madɨ kare dɔ ta tɨ kɨ ɨndəi dɔm tɨ kɨn, kadɨ e ta kɨ rɔjetɨ, al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nɨngə, m-gər no̰i tɨ ne təkɨ, m-ɨsɨ m-ra kɨlə ɓəə lə Luwə lə bawm je. M-ra kɨlə kɨn kɨ go rəbɨ kɨ əi je kɨ ɨndəi ta dɔm tɨ kɨn, ooi kadɨ e go rəbɨ kɨ loe tɨ al. Mi m-o kadɨ nḛ je pətɨ kɨ ndu-kun lə *Mojɨ əl tae, kɨ nḛ je pətɨ kɨ njé kəl ta je kɨ ta Luwə tɨ əli tae əi nḛ je kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","M-ɨndə mem dɔ nḛ tɨ kɨn rɔ Luwə tɨ. Nɨngə əi je ka, ɨndəi mede dɔ tɨ tɔ. Pətɨ, j-ɨndə meje tɨ kadɨ dɨje kɨ njé ra nḛ kɨ dana kɨ njé ra nḛ kɨ dana al, a ḭ lo koy tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","E mbata kɨn ə, m-ɨndə tɔgɨ dɔ rɔm tɨ mba kadɨ angalm uwə-m kɨ ta no̰ Luwə tɨ al nɨm, no̰ dɨje tɨ al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Go ɓal je tɨ kɨ ba̰y ba̰y kɨ m-goto, m-re kɨ la kadɨ m-ra-n kɨ dɨje ləm, taa kɨ kadɨ-kare kadɨ m-adɨ Luwə tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lo kɨn tɨ, e Jɨpɨ je kɨ Aji tɨ, ə ɨngəi-mi m-a m-ra kujɨ nḛ ra je kɨ mba kay rɔ njay gɨn kəy tɨ lə Luwə. Lokɨ ɨngəi-mi kɨn, dɨje uwəi-naa gɨdɨm tɨ al nɨm, taa dəw ra nḛ kɨ bɨrɨri al nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","NGa nɨngə, e Jɨpɨ je kɨ Aji tɨ ka kɨn ə re a rəi no̰i tɨ ne kadɨ tə ɨndəi ta dɔm tɨ, lokɨ re awi səm kɨ ta madɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","A re e be al tɔ nɨngə, njé kɨndə ta dɔm tɨ kɨ ai nḛ ka kɨn, əli ta nḛ kɨ m-tɔl ə ooi tae, lokɨ m-a-n no̰ njé gangɨ ta tɨ lə Jɨpɨ je ka kɨn adɨ j-o. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ta kare kɨ m-un ndum taa no̰de tɨ m-əl m-ə nə: “E kɨ mba kadɨ kɨ m-adɨ mem kadɨ njé koy je a ḭ lo koy tɨ ə m-a-n no̰si tɨ lo gangɨ ta tɨ ne”, kɨn wa ə e ta kɨ kare ba kɨ ai dɔ tɨ wa taa.» ");
INSERT INTO bjvNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pəlɨsɨ kɨ gər rəbɨ lə Kɨrɨsɨ majɨ, ɔr ndɔ kəte, nɨngə əl-de ə nə: «NDɔ kɨ Lɨsɨyasɨ kɨ nje kun dɔ asɨgar je re ə tə m-ɨndə manjɨ ta ləsi kɨn ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nɨngə adɨ ndune adɨ kɨ bo lə asɨgar je kɨ ɓu, kare kɨ nje ngəm Pol kadɨ ngəm-e dangay tɨ. Nə ke ə kadɨ ɨyə̰ Pol adɨ ɨlə rɔne, taa kadɨ ɨyə̰ ta rəbɨ adɨ dəw lie kɨ ra kɨ ge kadɨ n-ra sie ka, kadɨ ra sie tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Asɨ ndɔ je go tɨ, Pəlɨsɨ təl rəi kɨ nene Dɨrusɨl kɨ e Jɨpɨ. Lokɨ rəi, ɨlə adɨ rəi kɨ Pol adɨ əl-e ta kɨ dɔ kadɨ-me Jəju Kɨrɨsɨ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nə lokɨ Pol əl ta tḛḛ-n dɔ nḛ ra tɨ kɨ dana, kɨ kuwə rɔ gɨn tɔgɨ tɨ, kɨ ta kɨ gangɨ kɨ a re ɓa, ɓəl ra Pəlɨsɨ adɨ əl Pol ə nə: «Asɨ ngata, ə aw tə ndɔ kɨ m-ɨngə dɔkagɨlo kɨ rangɨ ə m-a m-ɓari ɓəy.» ");
INSERT INTO bjvNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nɨngə ga mene tɨ təkɨ Pol a adɨ-ne la wa, adɨ taa taa, ɓa Pol adɨ re wal sie ta. ");
INSERT INTO bjvNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ɓal man joo dɔ Pol tɨ, nɨngə Pɔrsɨyusɨ Pəsɨtusɨ ɔr to Pəlɨsɨ. Pəlɨsɨ ndɨgɨ kadɨ n-ra nḛ kɨ nəl *Jɨpɨ je adɨ ɨyə̰ Pol dangay tɨ ba. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","NDɔ mɨtə go ree dɔnangɨ tɨ kɨ kadɨ a o̰ ɓe dɔ tɨ, Pəsɨtusɨ ḭ Səjare tɨ aw Jorijaləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Lo kɨn tɨ, kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je kɨ kɨ bo je lə *Jɨpɨ je, rəi səki dɔ Pol rɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Me səkɨ tɨ, dəji Pəsɨtusɨ kɨ no̰ kəmde tɨ kadɨ ra səde ə ɨlə kɨ Pol Jorijaləm. Nə kɨ rɔjetɨ ɓa, ɨndəi dɔ ta naa tɨ kadɨ tə gangi Pol dɔ rəbɨ tɨ tɔli-e. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","No̰o̰ be, Pəsɨtusɨ əl-de ə nə: «Pol e dangay tɨ Səjare, taa mi wa kɨ dɔm ka ndɔ ngay al ə m-a m-təl kadɨ m-aw Səjare tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ə nə, re dɨngəm kɨn ra nḛ kɨ go tɨ al no̰o̰ ɓa, majɨ kadɨ kɨ bo je ləsi awi səm naa tɨ səki-e.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pəsɨtusɨ ra ndɔ kɨ asɨ Jijoo, a re ngay ə dɔgɨ be par, ə təl aw Səjare tɨ gogɨ. Lokɨ təl re ə, lo ti kɨ rangɨ go tɨ nɨngə, aw lo gangɨ ta tɨ, un ndune adɨ rəi kɨ Pol no̰e tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lokɨ Pol re, Jɨpɨ je kɨ ḭ Jorijaləm tɨ ɨləi-naa gəi dɔe, ɨndəi ta je kɨ nga̰ nga̰ ngay dɔe tɨ. Nə asi kadɨ ɔji nḛ je kɨ rɔjetɨ kɨ ay njay be dɔ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Be ə, Pol najɨ ta dɔne tɨ ə nə: «M-ra nḛ madɨ kɨ majal kɨ ndu-kun lə Jɨpɨ je al nɨm, kɨ kəy lə Luwə al nɨm, taa m-ɔsɨ-n ta Səjar al nɨm tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pəsɨtusɨ kɨ ndɨgɨ ra nḛ kɨ nəl Jɨpɨ je, əl Pol ə nə: «Ɨndɨgɨ kadɨ aw Jorijaləm tɨ kadɨ gangi ta dɔi tɨ dɔ ta tɨ kɨn ta kəmm tɨ a?» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ə Pol ə nə: «Jagɨ, e no̰ lo gangɨ ta tɨ lə nje ko̰ɓe kɨ bo Səjar ə kɨ m-a tɨ, ə e lo kɨ a gangi ta dɔm tɨ tɨtɨ. Təkɨ ḭ wa ɨgər-n majɨ, nḛ madɨ kare kɨ majal kɨ m-ra kɨ Jɨpɨ je goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kɨn ə re m-ra nḛ kɨ dana al, ə se m-tɔl nḛ kɨ asɨ koym, ə m-a mbatɨ koy al. A re ta je kɨ ɨndəi dɔm tɨ e ta je kɨ rɔjetɨ al ə, dəw kɨ a ɨlə-m jide tɨ goto. M-dəjɨ kadɨ m-o Səjar.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Lo kɨn tɨ, Pəsɨtusɨ əli-naa ta kɨ njé kɔjɨ ta je ləne, ɓa go tɨ əl Pol ə nə: «Ɨdəjɨ kadɨ o Səjar ɓa, a aw no̰ Səjar tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Asɨ ndɔ je go tɨ, ngar Agɨrɨpa əi kɨ konane Bərənɨsɨ rəi Səjare tɨ mba kuwə ji Pəsɨtusɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Rai ndɔ je asɨ ta tɨ rɔe tɨ no̰o̰, adɨ Pəsɨtusɨ ɨndə ta lə Pol no̰ ngar Agɨrɨpa tɨ əl-e ə nə: «Pəlɨsɨ ɨyə̰ dɨngəm madɨ dangay tɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Adɨ lokɨ m-aw Jorijaləm tɨ, kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je, kɨ kɨ bo je lə *Jɨpɨ je rəi səki-e rɔm tɨ, ə dəji-mi kadɨ m-gangɨ ta koy dɔe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ə m-əl-de təkɨ rəbɨ ra-e lə dɨje kɨ Rom tɨ e be al. Dəw kɨ Rom tɨ a ɨlə dəw ji njé səke je tɨ kɨ kanjɨ kadɨ dəwe ɨngə ta rəbɨ najɨ-n ta dɔne tɨ no̰ njé səke je tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Be ə, rəi ne, nɨngə, m-ndɨgɨ kadɨ ndɔ je man kare al, adɨ lo ti kɨ rangɨ go tɨ par ə m-aw lo gangɨ ta tɨ m-adɨ rəi kɨ dɨngəm ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","M-ga mem tɨ kadɨ nḛ madɨ kɨ nga̰ kɨ ra to no̰, nə lokɨ njé səke je rəi nɨngə, dəw oo lo nḛ madɨ kɨ nga̰ kɨ ra kɨ kadɨ ɨndəi ta dɔe tɨ be al. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","E ta kɨ najɨ par ə naji-naa tɨ səde ɔjɨ dɔ rəbɨ ra Luwə ləde əi je wa nɨm, ɔjɨ dɔ dəw madɨ kɨ tɔe nə Jəju kɨ oy ə Pol ə nə ɨsɨ kəm ba. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ta ləde kɨn, m-gər lo kuje kɨ kadɨ m-ra tɨ al, adɨ m-dəjɨ Pol ə wa m-ə nə se ndɨgɨ kadɨ aw Jorijaləm tɨ kadɨ e kɨ gangɨ ta kɨn dɔe tɨ wa. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nə Pol ndɨgɨ kadɨ nje ko̰ɓe kɨ bo kɨ Rom tɨ taa oo ta ləne. Be ə, m-un ndum kadɨ ngəmi-e dangay tɨ, bɨtɨ kadɨ tə m-ɨlə sie madɨ nje ko̰ɓe kɨ bo kɨ Rom tɨ, Səjar.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agɨrɨpa əl Pəsɨtusɨ ə nə: «M-ndɨgɨ ngay kadɨ m-o ta lə dɨngəm kɨn tɔ.» Ə Pɨsɨtusɨ əl-e ə nə: «Lo ti ə a oo ta kɨ tae tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lo ti kɨ rangɨ, Agɨrɨpa əi kɨ Bərənɨsɨ rəi kɨ dɨje ngay gode tɨ, urii lo gangɨ ta tɨ. Kɨ bo lə asɨgar je kɨ kɨ bo je kɨ me ɓe bo tɨ əi səde. NGa ə, Pəsɨtusɨ un ndune adɨ rəi kɨ Pol. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Lokɨ Pol re, Pəsɨtusɨ un ta əl ə nə: «Ḭ ngar Agɨrɨpa kɨ dɨje pətɨ kɨ ɨsi ne, oi dəw kɨn. E ə kosɨ Jɨpɨ je ngay rəi səki-e rɔm tɨ ne je, kɨ Jorijaləm tɨ je. Lokɨ səki-e, uni ndude kɨ taa əi nə e dəw kɨ sɔbɨ kadɨ goto kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kɨ rɔm tɨ, mi m-o nḛ madɨ kɨ nga̰ kɨ ra kɨ asɨ koy al. Nɨngə, təkɨ e wa dəjɨ kadɨ n-oo nje ko̰ɓe kɨ bo kɨ Rom tɨ, m-un ndum kadɨ m-ade aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","M-gər ta wa kɨ kadɨ tə m-ndangɨ me makɨtɨbɨ tɨ m-adɨ nje ko̰ɓe kɨ bo kɨ Rom tɨ ɔjɨ dɔ ta lie kɨn al. E be ə, m-adɨ re no̰si tɨ ne, kɨ bo tɔy, m-adɨ re no̰i tɨ ḭ ngar Agɨrɨpa kadɨ tə go ta tɨ kɨ a ɨdə-je ɓa, m-ɨngə nḛ kɨ kadɨ tə m-ndangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tadɔ m-o kadɨ e nḛ kɨ go rəbe tɨ al kadɨ m-ɨlə kɨ dangay Rom tɨ, kanjɨ kəl ta kɨ dɨje ɨndəi dɔe tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agɨrɨpa əl Pol ə nə: «Ta rəbɨ e ləi kadɨ ɨnajɨ-n ta dɔ rɔi tɨ.» Lo kɨn tɨ, Pol un jine kɨ taa, nɨngə ta kɨ əl dɔ rɔne tɨ ə to kɨn: ");
INSERT INTO bjvNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«NGar Agɨrɨpa, rɔm nəl-m ngay kadɨ m-ɨngə ta rəbɨ ɓone, m-əl-n ta dɔ rɔm tɨ ɔjɨ-n dɔ ta je pətɨ kɨ *Jɨpɨ je ɨndəi dɔm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","M-əl be tadɔ ɨgər nḛ jibəl ɓe je, kɨ ta kɨ najɨ je ləde pətɨ majɨ. Nɨngə, m-dəji kadɨ ɨlə mei nangɨ po̰, kadɨ o-n ta kɨ m-a m-əli kɨn majɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Jɨpɨ je pətɨ gəri nḛ ram je, lo kɨlə ngɨrə basam tɨ. Gəri majɨ tadɔ m-tɔgɨ dan dɨje tɨ ləm, Jorijaləm tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Gəri-mi mari ngay, nɨngə re ndɨgi ə, asi kadɨ a mai naje. Mai naje təkɨ nḛ ram je e kɨ go rəbɨ ra-e tɨ lə *Parɨsɨ je, kɨ e ɓutɨ kɨ nga̰ ngay dan ɓutɨ je tɨ kɨ njé ra ta lə Luwə ləje. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nɨngə kɨ ɓasɨne kɨn, rəi səm lo gangɨ ta tɨ, tadɔ m-ɨndə mem majɨ dɔ nḛ tɨ kɨ Luwə un ndune adɨ kaje je kadɨ n-a n-adɨ-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Gɨn kojɨ ləje kɨ dɔgɨ gɨde joo, ɨndəi mede tɨ kadɨ kun-ndu kɨn a tɔl tane. Be ə, rai kɨlə lə Luwə kɨ tɔgɨde kondɔ kɨ kada. Nɨngə e kɨ mbata kɨndə me dɔ tɨ kɨn ə Jɨpɨ je ɨndəi ta dɔm tɨ, ngar! ");
INSERT INTO bjvNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ra ban be ə səi Jɨpɨ je oi kadɨ e ta kɨ rɔjetɨ al kadɨ Luwə a tɔsɨ njé koy je ndəl lo koy tɨ ə? ");
INSERT INTO bjvNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«Mi wa kɨ dɔm, kəte m-o kadɨ e go tɨ ngay, kadɨ m-rɔ kɨ tɔgɨm, kɨ rəbɨ kɨ dangɨ dangɨ kadɨ dəw ɓa tɔ Jəju kɨ Najarətɨ tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nɨngə e kɨn ə e kɨlə ra-m kɨ m-ra Jorijaləm tɨ. Be ə, kɨ tɔgɨ kɨ m-ɨngə kɨ rɔ kɨ bo je tɨ lə njé kɨjə nḛ məsɨ kadɨ-kare je, m-ɓukɨ-n njé kadɨ-me je ngay dangay tɨ. NGa nɨngə lokɨ gangi ta koy dɔde tɨ ɓa, m-ndɨgɨ dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Taa taa, m-aw kɨ lo kaw-naa je lə Jɨpɨ je pətɨ, m-adɨ-de ko̰. Nɨngə m-ɨndə gu dɔde tɨ kadɨ naji ta gər Kɨrɨsɨ. Mem tɨngə-m ngay dɔde tɨ, adɨ m-aw bɨtɨ gode tɨ, kɨ dɔ ɓe je kɨ rangɨ, m-adɨ-de ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","E goe tɨ kɨn ə, m-ḭḭ-n m-ɨsɨ m-aw Damasɨ tɨ kadɨ m-uwə-de. Kɨ bo je lə njé kɨjə nḛ məsɨ kadɨ-kare je adi-mi tɔgɨ je, adi-mi ndude je, kadɨ m-ra-n kɨlə kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","NGar, lokɨ mi dɔ rəbɨ tɨ, kɨ kadɨ kɨ jam dɔ ɓe tɨ, m-o kunjɨ madɨ kɨ unjɨ ɨtə kadɨ ḭ dɔra̰ tɨ re gə dɔm, je kɨ njé kɨ gom tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jɨ tḛḛ j-osɨ nangɨ, nɨngə, m-o ndu dəw madɨ əl-m ta kɨ ndon ta Ebɨrə ə nə: “Sol, Sol, mbata ri ə ɨsɨ adɨ-m ko̰ be ə?” MBa ri ə uwə rɔi nga̰ tə mangɨ kɨ uwə rɔne nga̰ ta kɨndə tɨ lə ɓae be ə? E nḛ kɨ ndangɨ kare! ");
INSERT INTO bjvNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Lo kɨn tɨ m-dəje m-ə nə: “Ḭ naa ə Ɓaɓe?” Nɨngə, Ɓaɓe əl-m ə nə: “E mi Jəju kɨ ɨsɨ adɨ-m ko̰.” ");
INSERT INTO bjvNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nɨngə ḭ a taa dɔ njai tɨ. Nḛ kɨ m-tḛḛ m-ɨngə-i ə to kɨn: M-kɔti kadɨ ɨtəl ɓəə kɨlə ləm, nɨngə kadɨ ɨma najɨ dɔ koo tɨ kɨ o-m kɨn je, dɔ koo tɨ kɨ a o-m ɓəy je. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","M-a m-dəbɨ bagɨm dɔi tɨ ji Jɨpɨ je tɨ kɨ ji ndəgɨ dɨje tɨ kɨ m-a m-ɨlə-i kɨ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","MBa kadɨ ɨtḛḛ kəmde, ɔr-de lo kɨ ndul tɨ, ɨtḛḛ səde lo kunjɨ tɨ. Kadɨ ɔr-de ko̰ɓe tɨ lə su, ɨre səde ko̰ɓe tɨ lə Luwə, kadɨ Luwə ɨyə̰ go majal je ləde kɔ, kadɨ ɨngəi lo dan dɨje tɨ kɨ Luwə ɔr ta dɔde tɨ me kadɨ-me Jəju tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Lo kɨn tɨ, NGar Agɨrɨpa, m-ta̰ rɔ nḛ koo me ndɨl tɨ kɨ ḭ dɔra̰ tɨ kɨn al. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","M-ɨlə mbḛ kadɨ-me Kɨrɨsɨ, kɨ mbḛ kɨyə̰ go nḛ ra je kɨ majal kɔ. M-ɨlə mbḛ kɨn kɨ rɔ dɨje tɨ kɨ Damasɨ, kɨ rɔ dɨje tɨ kɨ Jorijaləm, kɨ rɔ dɨje tɨ kɨ dɔnangɨ Jude tɨ ba pətɨ, kɨ kɨ rɔ dɨje tɨ kɨ əi Jɨpɨ je al. Nɨngə m-dəjɨ-de kadɨ kɨlə ra-de tɔjɨ təkɨ rɔjetɨ, ɨyə̰i go nḛ rade je kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","E mbata kɨn ə, Jɨpɨ je uwəi-mi gɨn kəy tɨ lə Luwə kadɨ n-tɔli-mi. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nə Luwə dəbɨ bagɨne dɔm tɨ bɨtɨ ɓone, adɨ m-a kɨ dɔm taa, m-ɨsɨ ma najɨ kɨ dɔm tɨ no̰o̰ dɨje tɨ kɨ boy kɨ no̰ dɨje tɨ kɨ du. M-ɨlə mbḛ nḛ kɨ rangɨ al, nə e mbḛ nḛ kɨ njé kəl ta je kɨ ta Luwə tɨ je kɨ *Mojɨ je əli tae. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Əli təkɨ Kɨrɨsɨ a ɨngə ko̰, a e dəw kɨ dɔsa̰y kɨ a ḭ taa dan njé koy je tɨ tɔ. Nɨngə a ḭ taa kadɨ ɨlə mbḛ kunjɨ kɨ rɔ Jɨpɨ je tɨ kɨ kɨ rɔ dɨje tɨ kɨ əi Jɨpɨ je al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol a ma najɨ kɨ dɔne tɨ ba ɓəy nɨngə, Pəsɨtusɨ un ndune kɨ taa əl-e ə nə: «Pol, dɔi majal! Nḛ gər ləi kɨ ngay tujɨ dɔi kɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nə Pol əl-e ə nə: «Kɨ bo, dɔm majal al, ta je kɨ m-əl, e ta kɨ rɔjetɨ, kɨ kəme to. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","NGar Agɨrɨpa gər gɨn nḛ je kɨn majɨ, adɨ asɨ kadɨ m-tḭ rɔm katɨ m-əl-e ta. M-gər kadɨ nḛ kɨ dum-e goto, tadɔ e nḛ je kɨ rai nḛ lo ɓɔyɔ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","NGar Agɨrɨpa, adɨ mei dɔ ta je tɨ kɨ njé kəl ta kɨ ta Luwə tɨ əli tae kɨn ə se adɨ al? M-gər kadɨ adɨ mei dɔ ta je tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nɨngə NGar Agɨrɨpa əl Pol ə nə: «Nay ngay al par ə a ɨyətɨ angalm kadɨ m-təl nje kun go Kɨrɨsɨ ə a am!» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol ɨle tɨ ə nə: «Re e kɨ ngɔsɨne tɨ, ə se kɨ ɓəy tɨ ka, m-dəjɨ Luwə kadɨ ra be. Nɨngə kadɨ ḭ kɨ kari par al, nə kadɨ səi kɨ dɨje pətɨ kɨ ɨsɨ ooi ndum ne kɨn, ɨtəli ɨtoi tə mi be tɔ. Ke ə kadɨ ai me ka dangay tɨ kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Lo kɨn tɨ, NGar Agɨrɨpa je, kɨ nje ko̰ɓe kɨ dɔnangɨ tɨ kɨ no̰ kɨn je, Bərənɨsɨ je, kɨ ndəgɨ dɨje pətɨ kɨ əi səde, ɔri rɔde gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Lokɨ ɨsɨ ɔri rɔde gogɨ, əli-naa dande tɨ əi nə: «Dɨngəm kɨn ra nḛ madɨ kare kɨ asɨ kadɨ dəw tɔl-e-n ə se uwe-n dangay tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ə ngar Agɨrɨpa əl Pəsɨtusɨ ə nə: «Dɨngəm kɨn, e dəjɨ kɨ dəjɨ kadɨ n-aw no̰ Səjar tɨ kɨn al ə asɨ kadɨ ɨyḛ taa.» ");
INSERT INTO bjvNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lokɨ uni ndude kadɨ j-aw kɨ bato kɨ Itali tɨ, ɨyə̰i Pol əi kɨ ndəgɨ dangay je kɨ rangɨ ji nje kun dɔ ɓutɨ asɨgar je kɨ ɓu kɨ ɓari-e nə Julɨyusɨ, me ɓutɨ tɨ lə Ogusɨtɨ kadɨ ngəm-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","J-al me bato tɨ kɨ Adɨrami tɨ, kɨ a un rəbɨ kɨ a̰y ngangɨ lo kɨ Aji tɨ. Lokɨ j-ɔtɨ j-ɨsɨ j-aw, Arɨsɨtarkɨ kɨ Təsalonɨkɨ kɨ dɔnangɨ Masəduwan tɨ e səje naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lo ti go tɨ, jɨ re jɨ tḛḛ Sɨdo̰. Lo kɨn tɨ no̰o̰, Julɨyusɨ kɨ ɨndə kəmne go Pol tɨ majɨ ngay, ɨyə̰ ta rəbɨ ade kadɨ aw rɔ made je tɨ kadɨ rai sie. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Go tɨ, j-ḭ j-ɨlə dɔje, j-un kadɨ dər kɨ ɓari-e nə Sɨpɨr. Jɨ təl be, tadɔ nəl un-je kɨ gogɨ gogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","J-aw j-ɨndə ba bo ɓasi kadɨ Sɨlɨsi tɨ əi kɨ Pampɨli gangɨ. J-aw jɨ tḛḛ Mɨra, dɔnangɨ tɨ kɨ Lɨsi. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lo kɨn tɨ, nje kun dɔ ɓutɨ asɨgar je kɨ ɓu, ɨngə bato kɨ Aləgɨjandɨri tɨ, kɨ ɨsɨ aw Itali tɨ, ə adɨ j-al me tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Jɨ ra ndɔ ngay dɔ ba tɨ. Bato a̰y ngɔdɨ ndə̰y ndə̰y ba be, nɨngə j-ɨngə ko̰ ngay ɓəy taa jɨ tḛḛ ɓe bo tɨ kɨ Nɨdɨ. Nəl ɔgɨ-je kaw kɨ kəte, adɨ jɨ tḛḛ kɨ rəbɨ kɨ gɨn dər tɨ kɨ Kɨrətɨ, kaw kɨ kadɨ Salmone tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Lo kɔtɨ kəte e lo tɔl naa. J-ɔtɨ ndə̰y ndə̰y j-ɨndə kadɨ lo bɨtɨ taa jɨ re jɨ tḛḛ lo tɨ madɨ kɨ ɓari-e nə: «Ta ba kɨ Majɨ», ɓasi kadɨ ɓe bo tɨ kɨ ɓari-e nə Lase. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kagɨ lo man ngay dɔje tɨ. Dɔkagɨlo kɔgɨ rɔ nḛ kuso kɨ nay kul tɨ ka də tɔ, adɨ kaw kɨ kəte lə bato ka təl re nga̰ kɨ asɨ koy dəw. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","E mbata kɨn ə, Pol ndəjɨ-de ə nə: «Kama je, m-o kadɨ kɨn ə re jɨ ndɨgi kadɨ j-uni ta mba ləje kɨ kəte ə, e mba kɨ nḛ je a tuji tɨ. Nɨngə e bato kɨ nḛ je kɨ me tɨ par ə a tujɨ al, darɔje wa ka a tujɨ tɔ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nə nje kun dɔ ɓutɨ asɨgar je kɨ ɓu oo ta lə Pol al, oo ta lə njé kuwə ngandɨ bato je əi kɨ kɨ bo kɨ dɔde tɨ yo. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ta ba kɨn majɨ kadɨ dəw ɨsɨ tɨtɨ dɔkagɨlo kul tɨ al, adɨ dɨje ngay ndɨgi kadɨ n-awi tə re to ban wa nɨngə n-tḛḛi dɔ dər tɨ kɨ Kɨrətɨ, kɨ ɓari-e Pənɨsɨ. Ta ba kɨn tu rɔne kɨ lo kur kadɨ tɨ, ḭ gɨn ɓe tɨ bɨtɨ kɨ dɔ ɓe tɨ. E ə kadɨ n-ɨsi tɨ kadɨ tə kagɨ lo kul gangɨ dɔde tɨ tɨtɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lo kɨn tɨ, ngon nəl madɨ ɨlə, ḭ kɨ gɨn ɓe tɨ be re, adɨ oi kadɨ ndɨgɨ ra ləde a tɔl tane majɨ. Be ə, ḭḭ taai tuti bato, ə ɨləi dɔde kɨ kadɨ dər tɨ kɨ Kɨrətɨ ngɔsi ngɔsi ɨsɨ awi. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nə ndə̰y ba go tɨ par ə, nəl kɨ bo madɨ kɨ ɓari-e nə Ərakɨlo̰ ḭ kɨ dɔ dər tɨ, re osɨ dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nəl un bato dɔne tɨ. Lo kuwə bato nangɨ tae tɨ goto, j-ɨyə̰ rɔje kɨ jie tɨ adɨ aw səje kɨ no̰o̰ par. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","J-aw jɨ tḛḛ gɨn dər tɨ, kɨ ɓari-e nə Koda. Lo ka kɨn taa nəl dɔje tɨ, adɨ j-ɨngə ta rəbɨ j-ɨndə-n jije dɔ ngon bato tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Lokɨ njé ra kɨlə me bato tɨ uni-e ɨndəi me bato tɨ kɨ bo ɓa, doləi bato kɨ bo ka kɨn kɨ kɨlə ɓɨndɨ ɓɨndɨ. Jɨ ɓəl kadɨ j-aw j-ɔsɨ dɔje yangɨra tɨ kɨ Sɨrtɨ, adɨ uni gɨndɨ ngɔ kɨ dɔɔi bato tɨ ɨləi-e dɔ man tɨ, go bato tɨ. E be ə, nəl aw səje kɨ no̰o̰. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nəl rɔ səje kɨ tɔgɨne ngay, adɨ lo ti dɔ tɨ, dum dɔde ə, ɓuki nḛ je madɨ kɨ me bato tɨ kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","NDɔ kɨ ko̰ mɨtə go tɨ, ɔyi nḛ kɨ rɔ bato tɨ kɨ jide ɓuki kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","NDɔ ngay, j-asɨ kadɨ j-o kadɨ al nɨm, j-asɨ kadɨ j-o mee je al nɨm. Nəl nay kɨ lo kɨlə tɨ kɨ tɔgɨne, adɨ dəw kɨ ɨndə mene dɔ tḛḛ tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","J-uso nḛ al kagɨ lo ngay, ə Pol ḭ a taa dan dɨje tɨ, əl-de ə nə: «Kama je, kɨn ə re oi ta ləm ə j-ɨsɨ Kɨrətɨ tɨ ba ə, nḛ je a tujɨ je, nay kɔ je be al. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nɨngə kɨ ɓasɨne kɨn, m-ɨlə dɨngəm mesi tɨ kadɨ uwəi tɔgɨsi ba, tadɔ dəw kɨ a tujɨ dansi tɨ goto. Nḛ kɨ a tujɨ, e bato kɨ gɨn je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Luwə ləm kɨ m-ɨsɨ m-ra kɨlə ɓəə lie kɨn, malayka lie kare tḛḛ hɔy kɨ rɔm tɨ kondɔ ne əl-m ə nə: ");
INSERT INTO bjvNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","“Pol, ɨɓəl nḛ madɨ al. Ɨɓəl al tadɔ, sɔbɨ kadɨ a a no̰ Səjar tɨ. Nɨngə Luwə a ajɨ dɨje pətɨ kɨ əi səi me bato tɨ adi.” ");
INSERT INTO bjvNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","E be ə ngakom je, m-dəjɨ səsi kadɨ ɨləi mesi nangɨ. Madɨ mem Luwə ləm kadɨ a tḛḛ səje təkɨ əl-n. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nə j-a jɨ tɔli taje majal dɔ dər tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Je me lo kɨ ndɔ tɨ kɨ ko̰ dɔgɨ gɨde sɔ, nə nəl un je aw səje kɨ dɔ ba bo tɨ kɨ ɓari-e Adɨrɨyatɨkɨ. Lokɨ jɨ tḛḛ dan lo tɨ, njé ra kɨlə me bato tɨ ooi kadɨ je ɓasi kɨ dɔnangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lokɨ ɨləi nḛ kɨ kadɨ dəw gər-n ku man nɨngə, ɔdi nangɨ asɨ tatɨ ji dəw kutɨ joo. Lokɨ awi kɨ kəte sa̰y ndə̰y nɨngə, ɨləi ɓəy ɓa, ɔdi nangɨ lo tatɨ ji dəw tɨ dɔgɨ gɨde mi. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓəli kadɨ j-aw j-ɔsɨ rɔje mbal madɨ tɨ, adɨ ɓuki gɨndɨ kɨ dɔɔi bato sɔ kɔ, ə ɨsɨ ngɨnəi kadɨ lo ti law. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","NJé ra kɨlə me bato je tɨ sangi rəbɨ kɨyə̰ bato kadɨ n-a̰yḭ-naa, adɨ uni ngon bato ɨndəi dɔ ba tɨ nɨngə, uni gɨrə əi nə n-a n-awi kadɨ n-dɔɔi go kɨlə gɨndɨ kɨ dɔɔi no̰ bato tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nə Pol əl nje kun dɔ ɓutɨ asɨgar je kɨ ɓu nɨm, asɨgar je wa nɨm ə nə: «Kɨn ə dɨje kɨn ɨsi səje me bato tɨ ba al ə, dəw kare ka a tḛḛ dansi tɨ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Be ə, asɨgar je gangi kulə ngon bato ka kɨn ə ɨyə̰i-e adɨ aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kəte ɓəy taa kadɨ lo ti, Pol ɨlə dɨngəm me dɨje tɨ pətɨ ə nə: «Oi, ndɔ dɔgɨ gɨde sɔ ɓone kɨ ɨsɨ ɨngəmi, kɨ kanjɨ kadɨ usoi nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nɨngə kɨ ɓasɨne kɨn, m-dəjɨ səsi kadɨ uni nḛ usoi, tadɔ e kɨn ə a ra səsi kadɨ tə ɨtḛḛi kajɨ tɨ. M-əl səsi təkɨ ngon bɨsɨ dɔ dəw kare dansi tɨ a osɨ kɔ al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Lokɨ Pol əl-de ta ba nɨngə, un mapa ra oyo Luwə dɔ tɨ ta kəm dɨje tɨ pətɨ ɓa uso. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Lo kɨn tɨ no̰o̰ nga ə, dɨje pətɨ uwəi rɔde nga̰ usoi nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Pətɨ, je dɨje ɓu joo kɨ dɔ sɨri gɨde mehḛ me bato tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lokɨ usoi nḛ dani majɨ ɓa, ɓuki gəme kɔ kadɨ bato ɔle kəl. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lokɨ lo ti, njé kuwə ngandɨ bato je gəri lo al. Nə nḛ kɨ ooi e sɨl ba kɨ aw tɔl ta nḛ dɔ yangɨra tɨ par. Ə uni ndude kadɨ n-rai ndə̰y ndə̰y tə re to ban ə n-awi kɨ bato tɨtɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nɨngə tuti gɨndɨ je kɨ dɔɔi bato tɨ, ɓuki ba, ə ai dɔ tɨ no̰o̰ tuti kɨlə kɨ dɔɔi nḛ ləl bato je tɔ. Go tɨ, ɔyi kɨbɨ kɨ nje kuwə nəl taa. Ɔyi taa kadɨ tə nəl sur bato aw sie kɨ dɔ yangɨra tɨ ka kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lokɨ ɨsɨ awi ɓa, ɔsi bato dɨbi yangɨra tɨ kɨ tɔgɨ man kɨ ḭ yo je nḛ je re ɔsɨ naa tɨ adɨ a. No̰ bato dɨbɨ yangɨra tɨ tuti tuti adɨ lo kadɨ ɔtɨ kəte goto. Nɨngə goe kɨ gogɨ, man re kɨ tɔgɨne ɨndə tujɨ-n tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asɨgar je adi ndude asɨ-naa kadɨ tə n-tɔli dangay je nə tə kɨ madɨ dande tɨ ḭ ur me man tɨ a̰y aw. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nə nje kun dɔ ɓutɨ asɨgar je kɨ ɓu ndɨgɨ kajɨ Pol, adɨ ɔgɨ-de dɔ kadɨ rai ndɨgɨ ləde. Adɨ ndune kadɨ dɨje kɨ gəri kal man tosi me man tɨ kəte, awi kɨ dɔ yangɨra tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nɨngə kadɨ ndəge je ɨsi dɔ kagɨ tɨ je, dɔ nusɨ bato tɨ je, uni gode. E be ə, dɨje pətɨ awi tḛḛi dɔ yangɨra tɨ kɨ kanjɨ kadɨ nḛ madɨ ra-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Go tḛḛ kɨ jɨ tḛḛ ta yo tɨ nga ɓa j-o kadɨ tɔ dər kɨ je tɨ ka kɨn nə Maltɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Dɨje kɨ ɨsi dɔ dər tɨ ka kɨn uwəi-je kɨ rɔde tɨ kɨ rɔnəl kɨ dəw oo ga̰e nja kare al. Rai por kɨ bo ngay adɨ j-a ta tɨ pətɨ, tadɔ ndi ədɨ adɨ kul o̰ ngay. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol saa ngəngɨrə kadɨ n-ɓukɨ poro ɓa, por ra adɨ li pi tḛḛ tɨ naa jie tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lokɨ dɨje kɨ me ɓe tɨ ooi li naa ji Pol tɨ nɨngə, əli-naa dande tɨ əi nə: «Kɨ rɔjetɨ, dɨngəm kɨn e nje tɔl dɨje. Be ə, tḛḛ ta man tɨ ajɨ ka, ta kɨ gangɨ lə Luwə ndɨgɨ kadɨ a kɨ dɔne taa al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nə Pol sɨyə li ɨle me por tɨ, ə ngon rɔe kɨ ndə̰y ka to-e al. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Dɨje pətɨ ngɨnəi kadɨ rɔ Pol ti ə se osɨ watɨ oy wa be. Nə lokɨ ngɨnəi pi nḛ madɨ ra-e al, əli əi nə: «Dəw kam e yo.» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Lo lə kɨ bo kɨ dɔ dər tɨ ka kɨn, kɨ tɔe nə Pɨbɨlusɨ, to kadɨ lo tɨ no̰o̰ ngɔsi. Ə Pɨbɨlusɨ uwə-je kɨ rɔne tɨ majɨ ngay, adɨ-je kəy jɨ to-n ndɔje mɨtə. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nɨngə baw Pɨbɨlusɨ to mo̰y nangɨ: rɔe tɨngə je, ndəgɨ məsɨ je. Ə Pol ḭ taa aw ɨndə jine dɔe tɨ adɨ ɨngə rɔ nga. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Go tɨ, ndəgɨ njé mo̰y je kɨ me ɓe tɨ rəi ɨngəi Pol adɨ adɨ-de rɔ nga tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Dɨje ɔsi gonje no̰o̰ be. NGa nɨngə, lokɨ kagɨ lo asɨ kadɨ j-aw ngata ɓa, adi-je nḛ je kɨ j-aw kɨ ndooe kadɨ ra səje dɔ rəbɨ mba tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Jɨ ra nay mɨtə no̰o̰ be ɓəy taa kadɨ j-ɨlə dɔje kɨ bato kɨ ḭ Aləgɨjandɨri tɨ kɨ ɓari-e nə Kasɨtɔr nɨm, Polusɨ nɨm. Bato kɨn, kagɨ lo kul man dɔe tɨ me ɓe tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Lokɨ j-aw jɨ tḛḛ Sɨrakusɨ, j-ɨsɨ tɨ no̰o̰ ndɔ mɨtə. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Lo kɨn tɨ no̰o̰, j-ḭ j-un kadɨ ba, j-aw jɨ tḛḛ Rəjɨyo. Lo ti go tɨ, nəl kɨ ḭ gɨn ɓe tɨ ɨlə ngɨrə kulə, ə jɨ ra ndɔ joo ɓa jɨ tḛḛ Pujol. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Me ɓe tɨ kɨn ə j-ɨngə ngako̰je je kɨ dəji-je adɨ jɨ ra ndɔ sɨri səde ɓəy taa j-aw. E be ə j-aw-n kɨ njaje kadɨ jɨ tḛḛ-n Rom tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","NGako̰je je kɨ Rom tɨ kɨ ooi poyje, rəi tɨləi kəmje bɨtɨ lo sukɨ tɨ kɨ Apɨyusɨ kɨ e lo kəy kuso nḛ je kɨ mɨtə. Lokɨ Pol oo-de, ra oyo Luwə, ə təl ɨngə tɔgɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Go tḛḛ je Rom tɨ, adi ta rəbɨ Pol kadɨ ɨsɨ lo ləne kɨ asɨgar kare kɨ kadɨ ɨndə kəmne goe tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","NDɔ mɨtə go tɨ, Pol ɓa kɨ bo je lə *Jɨpɨ je kadɨ rəi ɨngəi-e. Lokɨ kawi-naa, Pol əl-de ə nə: «NGakom je, m-ra nḛ madɨ m-ɔsɨ-n ta dɨje ləje al nɨm, m-ɔsɨ-n ta nḛ jibəl ɓe lə kaje je al nɨm tɔ. Nə Jɨpɨ je uwəi-mi Jorijaləm tɨ ɨləi-mi dangay tɨ ji Rom je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Go ta tɨ kɨ Rom je dəji-mi, ɨngəi nḛ madɨ kɨ asɨ kadɨ dəw gangɨ-n ta koy dɔm tɨ al, adɨ ndɨgi kadɨ ɨyə̰i-mi. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nə Jɨpɨ je ɔdi al. Lo kɨn tɨ, e gu dɔm tɨ kadɨ m-dəjɨ ka no̰ Səjar tɨ, kɨ kanjɨ kadɨ m-ɨndə-n ta dɔ dɨje tɨ ləm. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","E mbata kɨn ə, m-dəjɨ kadɨ m-ɨngə səsi, m-əl səsi ta. Tadɔ e kɨ mbata nḛ kɨndə me dɔ tɨ lə *Isɨrayəl ə m-to-n dangay tɨ kɨn.» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Lo kɨn tɨ, Jɨpɨ je əli-e əi nə: «J-ɨngə makɨtɨbɨ madɨ kɨ ḭ Jude tɨ kɨ əl ta kɨ dɔi tɨ al, taa ngako̰ je je madɨ kɨ kadɨ rəi əli-je ta je kɨ dɔi tɨ ə se ɓari tɔi majal ka goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nə jɨ ndɨgɨ kadɨ əl-je ta ləi kɨ ɔjɨ dɔ ɓutɨ kɨ ḭ me tɨ kɨn adɨ j-o. Tadɔ jɨ gər kadɨ kɨ lo je pətɨ, dɨje ɔdi ta lə ɓu tɨ kɨn al.» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Be ə, ɔji-naa ndɔ ɓa rəi ngay ɨngəi Pol lo kɨse tɨ. Pol ɨlə-de mbḛ ko̰ɓe lə Luwə. A dɔ ndu-kun tɨ lə *Mojɨ kɨ nje kəl ta kɨ ta Luwə tɨ, ma-n najɨ lə Jəju. Taa sangɨ kadɨ n-ɓukɨ-de gone tɨ ɔjɨ dɔ tɔ Jəju tɔ. Əli-naa ta sḭ bɨtɨ lo sɔl-de. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Dɨje madɨ ooi kadɨ ta kɨ əl-de e ta kɨ rɔjetɨ, nə njé kɨ nungɨ mbati kadɨ mede tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Lo kɨ ḭ sanəi-naa kɨ ndu kasɨ-naa al, Pol əl-de ə nə: «Ta kɨ NDɨl Luwə əl bawsi je kɨ ta nje kəl ta kɨ ta Luwə tɨ Ejay e ta kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","NDɨl əl-e ə nə: “Aw ɨngə dɨje kam ə əl-de ə nə: A oi ta kɨ mbisi, nə a ɨgəri me al; A ɨgo̰i lo kɨ kəmsi, nə a oi lo al. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tadɔ nga̰mede ɨlə mii. Bəyi mbide je, ndəmi kəmde je, MBa kadɨ kəmde oo lo al nɨm, mbide oo ta al nɨm. MBa kadɨ n-gəri nḛ kare al, nə tə n-ḭḭ n-təli rɔde gom tɨ adɨ m-ajɨ-de.”» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol təl ɨlə tɨ ɓəy ə nə: «Kadɨ ɨgəri təkɨ, ta kajɨ lə Luwə kɨn, ɨlə-n adɨ dɨje kɨ əi Jɨpɨ je al. Nɨngə əi je a uri mbide kadɨ ooi.» ");
INSERT INTO bjvNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Lokɨ Pol əl ta kɨn nɨngə, Jɨpɨ je ḭḭ taa, awi kɨ ta kɨ najɨ-naa dande tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol ra ɓal joo ta kasɨ-naa me kəy tɨ kɨ uwə. Nɨngə dɨje pətɨ kɨ rəi rɔe tɨ, uwə-de kɨ rɔne tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pol ɨlə mbḛ ko̰ɓe lə Luwə nɨm, ndo dɨje ta kɨ dɔ Ɓaɓe Jəju Kɨrɨsɨ tɨ kɨ me kɨ kare kɨ kanjɨ kadɨ nḛ madɨ ɔge dɔ nɨm tɔ.");
INSERT INTO bjvNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Mi Pol kɨ ɓəə kɨlə lə Jəju Kɨrɨsɨ ə m-ndangɨ ta kɨn m-adɨ səsi. Mi kɨ Luwə ɓar-m tə nje kaw kɨlə, ɨndə-m ta dangɨ mba kadɨ m-ɨlə mbḛ Poy Ta kɨ Majɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Poy Ta kɨ Majɨ kɨ Luwə ɨndə ta njé kəl ta kɨ tae tɨ kəte, adɨ əli tae me makɨtɨbɨ tɨ lie kɨ ay njay. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","E Poy Ta kɨ Majɨ kɨ ɔjɨ dɔ NGone kɨ oji-e gɨn ka tɨ lə ngar Dabɨdɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Adɨ e Ɓaɓe ləje, Jəju Kɨrɨsɨ, kɨ Luwə un dɔe taa tə NGonne, kɨ tɔgɨ lə NDɨl Luwə, lokɨ ḭḭ-n taa dan njé koy je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","E kɨ takul Jəju Kɨrɨsɨ ə, Luwə ra-n səm majɨ adɨ m-təl-n nje kaw kɨlə lie mba kadɨ dɨje pətɨ kɨ dɔnangɨ tɨ ne, adi-e-n mede, təli rɔde go ta tɨ lie kadɨ tɔe ɓa-n. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Səi ka səi mbo̰ dɨje tɨ kɨn tɔ. Səi dɨje kɨ Luwə ɓar səsi kadɨ səi dɨje lə Jəju Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Səi pətɨ kɨ ɨsi Rom tɨ, kɨ Luwə ndɨgɨ səsi ə ɓar səsi tə dɨje ləne, kadɨ me-majɨ kɨ kɨsɨ-maje lə Luwə kɨ Bawje əi kɨ Ɓaɓe ləje Jəju Kɨrɨsɨ e səsi naa tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nḛ kɨ dɔsa̰y, m-ra oyo Luwə ləm me tɔ Jəju Kɨrɨsɨ tɨ kɨ mbata tɨ ləsi pətɨ. Tadɔ dɨje əli ta kɨ dɔ kadɨ-me tɨ ləsi kɨ dɔ dunɨya̰ ba pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Luwə kɨ m-ɨsɨ m-ra kɨlə ɓəə lie kɨ me kɨ kare, kɨ go rəbɨ kɨlə mbḛ Poy Ta kɨ Majɨ lə NGone, asɨ kadɨ a ma najɨ ləm. E gər majɨ təkɨ m-ɨsɨ m-əl ta ləsi kɨ dɔkagɨlo je pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nɨngə m-ɨsɨ m-dəje kɨ ndɔ je pətɨ, kadɨ re e ndɨgɨ lie ə, kadɨ adɨ-m ta rəbɨ adɨ m-aw-n rɔsi tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","M-ndɨgɨ ngay kadɨ m-aw m-o səsi, m-adɨ səsi kadɨ-kare lə NDɨl Luwə kɨ kadɨ ra səsi adɨ ɨnga̰i me kadɨ-me tɨ ləsi. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Taa, kɨsɨje naa tɨ, a ra kadɨ kadɨ-me kɨ kare kɨ j-awi, j-a j-ɨləi dɨngəm me naa tɨ yo kɨ ne. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","NGakom je kɨ dəne kɨ kɨ dɨngəm, m-ndɨgɨ kadɨ ɨgəri təkɨ, m-sangɨ rəbɨ ngay kadɨ m-aw rɔsi tɨ, nə bɨtɨ ɓone ka m-ɨngə rəbɨ al. M-ndɨgɨ kadɨ m-aw, adɨ m-ɨngə kandɨ kɨlə rɔsi tɨ təkɨ m-ɨngə-n rɔ ndəgɨ dɨje tɨ kɨ dɔnangɨ tɨ ne kɨn be tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Sɔbɨ kadɨ m-ɨndə kəmm go dɨje tɨ pətɨ, njé kəm tḛḛ je kɨ njé kəm tḛḛ al je, njé nḛ gər je kɨ njé nḛ gər al je. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","E mbata kɨn ə, m-ndɨgɨ ngay kadɨ m-aw m-ɨlə səsi mbḛ Poy Ta kɨ Majɨ, səi kɨ ɨsi Rom tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tadɔ mi Pol, rɔm sɔl-m al kadɨ m-ɨlə mbḛ Poy Ta kɨ Majɨ. Poy ta kɨ Majɨ kɨn e tɔgɨ lə Luwə kɨ kadɨ ajɨ dəw kɨ adɨ mene Jəju Kɨrɨsɨ. Kajɨ kɨ ɨlə ngɨrəne dɔ *Jɨpɨ je tɨ kəte, taa re tḛḛ-n dɔ dɨje tɨ kɨ əi Jɨpɨ je al. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kɨ rɔjetɨ, Poy Ta kɨ Majɨ tɔjɨ rəbɨ kɨ Luwə tɨdə-n dɨje kɨ adi-e mede dɨje tɨ ləne. E kɨ go rəbɨ kadɨ-me təkɨ makɨtɨbɨ lə Luwə əl-n ə nə: «Dəw kɨ Luwə tɨde dəw tɨ ləne kɨ go rəbɨ kadɨ-me lie, a ɨsɨ kɨ dɔne taa.» ");
INSERT INTO bjvNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Luwə ɨsɨ dɔra̰ tɨ taa nu, tɔjɨ wongɨ ləne dɔ dɨje tɨ kɨ njé ra majal, njé ra nḛ kɨ go rəbe tɨ al. Kɨlə rade je kɨ majal utɨ dɔ nḛ kɨ rɔjetɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kɨlə ra Luwə to kɨ taga wangɨ kadɨ dəw gər. Luwə wa tɔjɨ dɨje kɨlə rane kɨ taga. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Təkɨ rɔjetɨ, lo kɨlə ngɨrə kɨndə nḛ je tɨ nu, nḛ je kɨ to rɔ Luwə tɨ, kɨ dəw oo-de kɨ kəmne al, kɨ tɔge kɨ bɨtɨ kɨ no̰ tɨ, kɨ kee Luwə, nḛ je kɨn toi kɨ taga me kɨlə rae tɨ kadɨ dəw gər kɨ nḛ gər kɨ aw-n dɔne tɨ. Adɨ nḛ kɨ kadɨ me Luwə a sɔl-n dɔ dəw tɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Dɨje gəri Luwə majɨ, nə mbati kadɨ ɔsi kure nɨm, mbati təl kɨ oyo kade nɨm, təkɨ sɔbɨ kadɨ raii. Tagade ur-de wale yo, nḛ gər ləde goto, adɨ ɨləi rɔde me lo kɨ ndul tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","OOi rɔde tə njé gosɨ je, nə təli mbə je. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Kadɨ ɔsi məkəsɨde nangɨ no̰ Luwə tɨ kɨ nje koy al nɨngə, ɔsi məkəsɨde nangɨ no̰ nḛ je tɨ kɨ dɨje rai-de tə bana kəm dɨje tɨ kɨ ndɔ madɨ ə a gotoi, təli-de yəl je tɨ, təli-de da je tɨ kɨ njade e sɔ, kɨ njé kɨ nje kagɨ nangɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","E mbata kɨn ə, Luwə ɨyə̰-n-de me nḛ ra je tɨ kɨ majal kɨ mede ndɨgɨ, adɨ ɨləi rɔsɔl dɔ rɔde tɨ əi je wa. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Uni nḛ kɨ rɔjetɨ lə Luwə mbəli nḛ kɨ ngom. Nɨngə ɔsi dɔde nangɨ no̰ nḛ je tɨ kɨ Luwə ɨndə-de kɨn yo, ə ɨyə̰i Luwə kɨ nje kɨndə nḛ je, kɨ kɔsɨ-gon e lie bɨtɨ kɨ no̰ tɨ kɨn. *Amen. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","E mbata kɨn ə, Luwə ɨyə̰-n-de me ngur darɔ tɨ kɨ to rɔsɔl. Nede je, ɨyə̰i ta sangɨ-naa lə dəne kɨ dɨngəm kɨ go rəbe tɨ, ə təli nayḭ-naa ta sangɨ-naa tɨ kɨ go rəbe tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Dɨngəm je ka ɨyə̰i taa sangɨ nede je, ə nayḭ-naa ta sangɨ-naa tɨ dande əi je wa. Rai nḛ kɨ kɔbɨ kɨ naa, adɨ ɨngəi nḛ kɨgə go kɨlə rade kɨ ur səde wale. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Lokɨ mbati kadɨ n-gəri rəbɨ lə Luwə, Luwə ɨyə̰-de adɨ uni rəbɨ kɨ go nḛ gər tɨ ləde kɨ rugɨ, kɨ asɨ kadɨ ɔr-de ta rəbɨ al. Lo kɨn tɨ, ɨsi ta nḛ ra tɨ kɨ kadɨ dəw ra al. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nḛ ra kɨ dana al rosɨ mede, əi njé ra majal je, əi njé ra kəm-nda nḛ lə dɨje, əi njé me ndul je, jangɨ rosɨ mede, əi njé tɔl dɨje, əi njé kɔl, njé kədɨ dɨje, nḛ rade e kɨ go rəbe tɨ al, əi njé tətɨ ta dɔ dɨje tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","əi je wa ɨsɨ əli ta kɨ majal dɔ-naa tɨ, əi njé ba̰ je lə Luwə, njé ta kɨ to, njé kun dɔde taa, njé kɔjɨ rɔde, mər ta ləde pətɨ e dɔ majal tɨ kɨ ra, əi njé ta̰ rɔ njé kojɨ-de je, ");
INSERT INTO bjvNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nḛ gər ləde goto, əi dɨje kɨ ooi to mɨndɨde al, əi dɨje kɨ usɨ-de dɔ dəw tɨ al, taa ooi kəm-to-ndoo lə dəw al tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Gəri ta kɨ gangɨ lə Luwə majɨ, kadɨ dɨje kɨ njé ra nḛ kɨ be kɨn, əi dɨje kɨ asi ta koy, nə toi ta ra tɨ par par. Nɨngə e əi je wa par ə rai al, nə dɨje kɨ rangɨ kɨ ɨsɨ rai ka, ndɨgi səde dɔ tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ḭ kɨ ɨsɨ gangɨ ta dɔ madi je tɨ, re ḭḭ-n na̰ na̰ ka, dəw a ɨyə̰ go kɔ adi al, tadɔ ɨsɨ gangɨ ta dɔ dɨje tɨ kɨ njé ra nḛ je kɨ majal, nə kɨlə rai to tə kɨlə rade be tɔ. Adɨ ta kɨ ɨsɨ gangɨ kɨn, ɨsɨ gangɨ ta dɔ rɔi tɨ ḭ wa. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Jɨ gər majɨ, kadɨ Luwə ɨsɨ gangɨ ta, kɨ go rəbɨ kɨ dana, dɔ dɨje tɨ kɨ njé ra nḛ je kɨ majal kɨ be kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","NGa ḭ kɨ ɨsɨ gangɨ ta dɔ dɨje tɨ kɨ njé ra nḛ je kɨ majal, nɨngə ɨsɨ ra nḛ je kɨ ɨsɨ rai ka kɨn tɔ kɨn, kadɨ o ə nə, ḭ a goto me ta kɨ gangɨ tɨ lə Luwə, al. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ḭ, ɨsɨ kɨdɨ ra majɨ lə Luwə kɨ ətɨ ɓəl, kɨ kore me lie, kɨ kɨsɨ dɔ tɨ lie, kɨ kanjɨ kadɨ ɨgər təkɨ, ra majɨ lie kɨn ɨsɨ ɔsi kadɨ ɨyə̰ rəbɨ nḛ rai je kɨ majal kɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ɨsɨ ta ra me nga̰ tɨ, ɨmbatɨ kɨyə̰ rəbɨ nḛ ra kɨ majal kɔ. Lo kɨn tɨ, ɨsɨ kaw wongɨ kɨ pangɨlae al dɔi tɨ, ɨsɨ ngɨnə-n ndɔ kɨ, Luwə kɨ nje gangɨ ta kɨ dana, a re-n kadɨ ɔjɨ-n wongɨ ləne dɔ dɨje tɨ kɨ njé ra nḛ kɨ majal. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Luwə kɨ nje kɨgə dəw kɨ ra kɨrə kɨlə rae. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Dɨje kɨ uwəi tɔgɨde ba me nḛ ra tɨ kɨ majɨ, ɨsɨ sangii tɔɓa, kɨ kɔsɨ-gon, kɨ ɨsɨ sangi kadɨ n-oyi al, Luwə a adɨ-de kɨsɨ kɨ dɔ taa kɨ bɨtɨ kɨ no̰ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nə njé kɨ njé kur wale, njé ta̰ rɔ ta kɨ rɔjetɨ, ə təli rɔde go nḛ ra tɨ kɨ dana al, Luwə a mbatɨ-de, a adɨ wongɨ lie kɨ bo osɨ dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","A adɨ me-ko̰ kɨ ɓəl a ra dɨje pətɨ kɨ njé ra majal. A ɨlə ngɨre dɔ *Jɨpɨ je tɨ ɓəy taa re-n dɔ dɨje tɨ kɨ əi Jɨpɨ je al tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Nɨngə dɨje kɨ njé ra majɨ, Luwə a adɨ-de tɔɓa, kɨ kɔsɨ-gon, kɨ kɨsɨ-maje. A ɨlə ngɨre dɔ Jɨpɨ je tɨ ɓəy taa re-n dɔ dɨje tɨ kɨ əi Jɨpɨ je al. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tadɔ kɔr kəm naa goto rɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Dɨje kɨ əi Jɨpɨ je al kɨ rai majal kɨ kanjɨ gər ndu-kun lə *Mojɨ, a tuji kɨ go lo gər-e tɨ al wa kɨn tɔ, nə Jɨpɨ je kɨ gəri ndu-kun lə Mojɨ ɓətɨ ə rai majal, ndu-kun a gangɨ ta dɔde tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nɨngə, e njé kɨ ɨsɨ ooi ndu-kun mbide tɨ be par ɓa Luwə ɨsɨ ɔr ta dɔde al, nə əi njé kɨ ɨsɨ ooi, ə təli rɔde go tɨ ə, Luwə ɨsɨ ɔr ta dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Dɨje kɨ əi Jɨpɨ je al, kɨ gəri ndu-kun lə Mojɨ al, nə ɨsɨ rai nḛ kɨ ndu-kun dəjɨ, kɨ kanjɨ gər kɨn, əi je wa əi ndu-kun kɨ nje gangɨ ta dɔ rɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Me lo tɨ kɨn, tɔji kadɨ, nḛ kɨ ndu-kun dəjɨ kadɨ dəw ra kɨn, e kɨ ndangɨ nga̰mede tɨ. Nɨngə, mede kɨ ɨsɨ uwə-de kɨ ta ka ma najɨ dɔ ta tɨ kɨn, taa gangɨ kɨ ɨsɨ gangɨ ta dɔ rɔde tɨ je, ɨsɨ ɔr ta dɔ rɔde tɨ je kɨn ka ma naje tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Nɨngə təkɨ mbḛ Poy Ta kɨ Majɨ kɨ m-ɨsɨ m-ɨlə, əl-n, e kɨn ə e nḛ kɨ a ra nḛ ndɔ tɨ kɨ Luwə a un Jəju Kɨrɨsɨ kadɨ a gangɨ-n ta dɔ nḛ je tɨ pətɨ kɨ dɨje ɓɔyɔi mede tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Nɨngə ḭ kɨ ɨsɨ ɓar rɔi Jɨpɨ, kɨ a dɔ ndu-kun tɨ nga̰, rɔi ɨsɨ nəl-i dɔ Luwə tɨ ləi; ");
INSERT INTO bjvNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kɨ ɨgər nḛ kɨ e ndɨgɨ lie majɨ, ndu-kun ndoi nḛ kadɨ ɨkɔtɨ nḛ kɨ majɨ dan kɨ majal tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ḭ o rɔi majɨ ngay kadɨ asɨ kɔr njé kəm tɔ je ta rəbɨ, o rɔi kadɨ ḭ kunjɨ lə dɨje kɨ ai lo kɨ ndul tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ḭ nje ndo nḛ njé nḛ gər al je, nje ndo nḛ ngan je kɨ du. Ḭ ɨsɨ ra nḛ je kɨn be, mbata o kadɨ me ndu-kun tɨ, ɨngə nḛ gər, kɨ ta kɨ rɔjetɨ ngata. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Ḭ ɨsɨ ɨndo nḛ dɨje, nə asɨ kadɨ ɨndo rɔi ḭ wa al, ɨsɨ ɨlə mbḛ kadɨ dɨje ɓogi al, ə ḭ wa ɨsɨ ɓogɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ɨsɨ əl dɨje kadɨ sangi-naa kaya tɨ al, nə ḭ wa ɨsɨ sangɨ dəne je kɨ lo kaya tɨ, ɨsɨ əl ta lə yo je kɨ ra majal, ə ɨsɨ ɨkə nḛ me kəy tɨ ləde. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ɨsɨ ɨra rɔnəl dɔ ndu-kun tɨ, nə ɨsɨ al dɔe, adɨ ɨmbatɨ kɔsɨ-gon Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Lo kɨn tɨ, təkɨ ndangi me makɨtɨbɨ tɨ lə Luwə, dɨje kɨ əi *Jɨpɨ je al ɨsɨ əli ta kɨ mal dɔ Luwə tɨ mbata kɨlə rasi səi kɨ səi Jɨpɨ je. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nɨngə kadɨ ɨgəri majɨ təkɨ kɨjə mɔtɨ e nḛ kɨ ndae to, lokɨ dəw ɨsɨ təl rɔne go ndu-kun tɨ, nə lokɨ ɨtəl rɔi go ndu-kun tɨ al ə, səi kɨ dəw kɨ ɨjə mɔtɨne al, asi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kɨn ə dəw kɨ ɨjə mɔtɨne al, təl rɔne go ndu-kun tɨ ə, Luwə a oo-e tə dəw kɨ ɨjə mɔtɨne. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Dəwe kɨ ɨjə mɔtɨne kɨ go darɔ tɨ al, nə təl rɔne go ndu-kun tɨ kɨn, a gangɨ ta dɔi tɨ. A gangɨ ta dɔi tɨ, ḭ kɨ aw kɨ ndu-kun kɨ ndangɨ me ji tɨ, taa ɨjə mɔti tɔ, nə ɨtəl rɔi go ndu-kun tɨ al kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Təkɨ rɔjetɨ, ke Jɨpɨ, e ba gɨdɨ tɨ taga ne al, taa kɨjə mɔtɨ e me ndajɨ kɨ rɔ tɨ kɨn al tɔ, ");
INSERT INTO bjvNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","nə ke Jɨpɨ kɨ rɔjetɨ e me tɨ kəy. Nɨngə kɨjə mɔtɨ, e kɨjə mɔtɨ kɨ nga̰me tɨ. E kɨjə mɔtɨ kɨ ḭ rɔ NDɨl Luwə tɨ, ɓɨ me ndu-kun tɨ kɨ ndangɨ al. Dəw kɨ kɨ ɨjə mɔtɨne, e dəw kɨ ɨngə tɔjɨ kɨ rɔ Luwə tɨ ɓɨ rɔ dɨje tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ke Jɨpɨ, maje to tɨ, kɨjə mɔtɨ, ndae to tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Maje e ngay me nḛ je tɨ pətɨ, tadɔ, e *Jɨpɨ je ə Luwə ɨlə ta ləne jide tɨ kəte. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ə re kɨ madɨ je ai dɔ njade tɨ al ə, ka dɔ nja tɨ al ləde a ra kadɨ Luwə yətɨ ndune al. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Luwə a yətɨ ndune al jagɨ! Nɨngə sɔbɨ kadɨ Luwə e nje kəl ta kɨ rɔjetɨ, ə dɨje pətɨ əi njé kəl ta kɨ ngom, təkɨ ndangi me makɨtɨbɨ tɨ əi nə: «Sɔbɨ kadɨ dɨje gəri ka dana ləi me ta kəli tɨ, A re awi kadɨ gangi ta dɔi tɨ ə, Kadɨ ta uwəi al, kadɨ ɨtḛḛ me tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kɨn ə re majal kɨ j-ɨsɨ ra, tɔjɨ kadɨ Luwə e dəw kɨ dana ə, dəw oo ta kɨ kadɨ j-əl al. Kɨn ə re Luwə ɨngə tɔɓa me majal raje tɨ, ə a no̰o̰ ra səje wongɨ ə, e dəw kɨ rɔjetɨ al. M-əl ta kɨn be kɨ go koe tɨ lə dəw. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Nɨngə kadɨ ɨgəri təkɨ, Luwə e dəw kɨ dana al, al jagɨ. Kɨn ə Luwə e dəw kɨ dana al ə, a asɨ kadɨ gangɨ ta dɔ dunɨya̰ tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Nɨngə kɨn ə, kadɨ me ta ngom tɨ kɨ ɨsɨ tḛḛ tam tɨ, ta kɨ rɔjetɨ lə Luwə tḛḛ kɨ taga, kadɨ Luwə ɨngə-n tɔɓa ə, gɨne e ri ə kadɨ dəw a gangɨ ta dɔm tɨ tə nje ra majal ɓəy ə? ");
INSERT INTO bjvNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","J-a j-əl kɨ kəte par j-ə nə: «Jɨ rai majal j-adi nḛ kɨ majɨ tḛḛ me tɨ.» Təkɨ dɨje madɨ ɨndəi ta dɔm tɨ əi nə: mi ə m-ə nə jɨ ra majal kadɨ nḛ kɨ majɨ tḛḛ me tɨ ka kɨn be. Dɨjee kɨ əli ta kɨn asi ta kadɨ dəw gangɨ ta koy dɔde tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nɨngə e nḛ kɨ kadɨ dəw əl-n ə nə: je kɨ je Jɨpɨ je, j-ɨtə ndəgɨ dɨje al. J-ɨtə-de al, nɨngə j-əl ta dɔ tɨ ngata j-ə nə: Jɨpɨ je kɨ dɨje kɨ əi Jɨpɨ je al, pətɨ, əi gɨn tɔgɨ tɨ lə majal. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Təkɨ makɨtɨbɨ lə Luwə əl-n ə nə: «Dəw kare be kɨ kadɨ e dəw kɨ dana goto. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Dəw kare be kɨ kadɨ gər nḛ goto, Dəw kare be kɨ kadɨ sangɨ Luwə goto. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Pətɨ ɨyə̰i rəbɨ kɨ majɨ, ndəmi rəbɨ. Dəw kare kɨ nje ra majɨ goto. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Rəbɨ mɨndɨde to tə ɓe nɨn kɨ tae to tagɨra be, NDonde e ndon kəl ta kɨ ngom, NDa tade rosɨ kɨ kəngɨ li, ");
INSERT INTO bjvNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ɨsɨ mani dɨje man kɨ to kəl tae al, Tade atɨ kanana dɔ dɨje tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","NJade e nja ka̰y law kɨ lo tɔl nḛ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Lo kɨ dəi tɨ ɓa, dɔ njade e nḛ kɨ tujɨ kɨ me-ko̰. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Əi dɨje kɨ gəri rəbɨ lapɨya al. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ɓəl Luwə kɨ ndə̰y goto mede tɨ.» ");
INSERT INTO bjvNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Jɨ gər kadɨ nḛ je pətɨ kɨ ndu-kun əl, əl dɨje kɨ əi gɨn ndu-kun tɨ, mba kadɨ ta dəw madɨ tḛḛ əl ta dɔ rɔe tɨ al, ə kadɨ dɨje pətɨ gəri go majal je ləde no̰ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","E mbata kɨn ə, dəw kɨ Luwə a tɨde dəw tɨ ləne kɨ go rəbɨ təl rɔ go ndu-kun tɨ goto. MBata ndu-kun to mba kadɨ ɔjɨ dɨje adɨ gəri nḛ kɨ ɓari-e majal. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kɨ ngɔsɨne kɨn, Luwə tɔjɨ-je go rəbɨ kɨ tɨdə-n dɨje, dɨje tɨ ləne kɨ kanjɨ ndu-kun. Nɨngə e, ndu-kun lə Mojɨ kɨ njé kəl ta je kɨ ta Luwə tɨ mai naje. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Luwə tɨdə dɨje, dɨje tɨ ləne kɨ go rəbɨ ka dɔ nja tɨ lə Jəju Kɨrɨsɨ. Ta rəbɨ kɨn to mbata tɨ lə dɨje pətɨ kɨ adi mede Jəju Kɨrɨsɨ, tadɔ dɨje pətɨ asi-naa. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Dɨje pətɨ əi njé ra majal je, adɨ tɔɓa lə Luwə nal-de. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nə Luwə tɨdə-de dɨje tɨ ləne kare, kɨ kanjɨ kadɨ ugəi nḛ madɨ. E kɨ go me-majɨ tɨ lie, me tɔ Jəju Kɨrɨsɨ tɨ kɨ taa-de gɨn tɔgɨ tɨ lə majal ɨlə-de taa. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","E Jəju Kɨrɨsɨ ə, Luwə un-e tə nḛ kɨgə dɔ majal, me məse tɨ kɨ a̰y, kɨ go rəbɨ ka dɔ nja tɨ lie. Luwə ra be mba kadɨ tɔjɨ-n nḛ ra kɨ dana ləne, mbata majal je kɨ dɨje rai-de kəte, tɨdə goe al, ");
INSERT INTO bjvNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","dɔkagɨlo kɨsɨ dɔ tɨ lie. Luwə tɔjɨ nḛ ra kɨ dana ləne dɔkagɨlo tɨ kɨ ɓone, mba kadɨ e-n nje ka dana, taa kadɨ tɨdə-n dɨje kɨ ɨndəi mede dɔ me-majɨ tɨ lə Kɨrɨsɨ, dɨje tɨ ləne tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nḛ kare kɨ kadɨ dəw ɨndə-n gune goto, mbata nḛ kɨ Luwə a dɔ tɨ, e təl rɔ go ndu-kun tɨ al, nə e kadɨ-me Jəju Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jɨ gər majɨ kadɨ Luwə tɨdə dəw, dəw tɨ ləne kɨ go rəbɨ kadɨ-me Jəju Kɨrɨsɨ, ɓɨ e kɨ go rəbɨ təl rɔ go ndu-kun tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Luwə e Luwə lə *Jɨpɨ je par al. Kɨ rɔjetɨ, e Luwə ləde par al, nə e Luwə lə ndəgɨ dɨje pətɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","MBata Luwə e kare ba. E ə tɨdə Jɨpɨ je dɨje tɨ ləne kɨ go rəbɨ kadɨ-me Jəju Kɨrɨsɨ nɨm, a tɨdə ndəgɨ dɨje, dɨje tɨ ləne kɨ go rəbɨ kadɨ-me Jəju Kɨrɨsɨ nɨm tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Lokɨ j-adɨ meje Kɨrɨsɨ kɨn, tɔjɨ kadɨ nda ndu-kun goto al. Lo kɨn tɨ, jɨ tɔjɨ kadɨ ndae e ngay tə ke yo. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kadɨ j-əl ta lə kaje *Abɨrakam ɓa, nḛ madɨ kɨ ɨngə kɨ go tɔge tɨ e wa goto. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kɨn ə Luwə tɨdə Abɨrakam dəw tɨ ləne kɨ takul kɨlə rae je ə, asɨ kadɨ Abɨrakam a ɨndə-n gune wa, nə a ɨndə gune no̰ Luwə tɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Tadɔ, ta kɨ makɨtɨbɨ lə Luwə əl ə to kɨn: makɨtɨbɨ lə Luwə əl ə nə: «Abɨrakam adɨ mene Luwə, ə Luwə tɨde dəw tɨ ləne.» ");
INSERT INTO bjvNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nɨngə nḛ kare, dəw kɨ ra kɨlə ɨngə-n nḛ kɨgə go ji, nḛ kɨ ɨngə kɨn, ɨngə kare al, nə e nḛ kɨ ɨngə to kɨlə tɨ kɨ ra. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kɨn ə dəw ra kɨlə madɨ al, nə adɨ mene kadɨ Luwə e nje tɨdə dəw kɨ nje ra majal dəw tɨ ləne ə, Luwə a tɨde dəw tɨ ləne, kɨ go kadɨ-me Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","E be ə, *Dabɨdɨ un-n ndune kɨ taa əl-n ta lə majɨ kɨ ḭ rɔ Luwə tɨ re kɨ dɔ dəw tɨ. Adɨ e dəw kɨ Luwə tɨde dəw tɨ ləne kɨ kanjɨ go̰ kɨlə rae je. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Dabɨdɨ ə nə: «Dɨje kɨ Luwə ɨyə̰ nḛ rade je kɨ go tɨ al kɔ, Luwə bɔr majal je ləde kɔ, əi njé majɨ-kur je. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Dəw kɨ Luwə tɨdə majal lie dɔe tɨ al e nje majɨ-kur.» ");
INSERT INTO bjvNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Majɨ kɨn e mbata lə njé kɨjə mɔtɨ par al, nə e mbata lə njé kɨjə mɔtɨ al je tɔ. Tadɔ j-əl j-ə nə: Luwə tɨdə Abɨrakam dəw tɨ ləne kɨ takul kadɨ-me lie. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ə se nḛ kɨn ra nḛ dɔkagɨlo tɨ kɨ ra wa? Se e kəte no̰ kɨjə mɔtɨ Abɨrakam tɨ ə se e go tɨ wa? Nḛ kɨn ra nḛ kəte no̰ tɨ, ɓɨ e go tɨ gogɨ al. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","12","Nɨngə kɨjə mɔtɨ re go tɨ gogɨ tə ndajɨ, kɨ kadɨ tɔjɨ təkɨ Luwə tɨdə Abɨrakam dəw tɨ ləne, kɨ takul kadɨ-me kɨ adɨ mene, dɔkagɨlo tɨ kɨ ɨjə-n mɔtɨne al ɓəy. Lo kɨn tɨ, dɨje kɨ ɨjəi mɔtɨde al ka Luwə tɨdə-de dɨje tɨ ləne nɨm, dɨje kɨ ɨjəi mɔtɨde ka tɨdə-de dɨje tɨ ləne nɨm tɔ. Nɨngə Abɨrakam təl baw dɨje pətɨ kɨ ɨjəi mɔtɨde al, kɨ adi mede, taa təl baw dɨje kɨ ɨjəi mɔtɨde tɔ. Adɨ əi njé je kɨ uwəi kul kɨjə mɔtɨ par al, nə uni dɔ nja bawje Abɨrakam kɨ un, ə adɨ mene Luwə kəte no̰ kɨjə mɔtɨne tɨ kɨn. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Luwə un mɨndɨne adɨ *Abɨrakam kɨ dɨje kɨ gɨn kojɨ tɨ lie təkɨ dɔnangɨ e nḛ nduwə ləde. Nɨngə e kɨ mbata təl ɓa Abɨrakam təl rɔne go ndu-kun tɨ al, nə e kɨ mbata tɨdə kɨ Luwə tɨde dəw tɨ ləne kɨ go rəbɨ kadɨ-me Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kɨn ə re nḛ nduwə kɨn e mbata tɨ lə dɨje kɨ njé təl rɔde go ndu-kun tɨ par nɨngə, nda kadɨ-me goto, taa kun mɨndɨ lə Luwə ka təl nḛ kɨ kəme goto tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tadɔ ndu-kun ə e nje re kɨ wongɨ lə Luwə. MBata lo kɨ ndu-kun goto tɨ, kal dɔ ndu-kun ka goto tɨ tɔ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Lo kɨn tɨ, nḛ majɨ kɨ Luwə un mɨndɨne kadɨ n-a n-adɨ dəw kɨn, dəw a ɨngə kɨ go rəbɨ kadɨ-me Luwə. Be mba kadɨ e nḛ kadɨ-kare kɨ Luwə adɨ, kɨ ndae to tɨ mbata lə dɨje pətɨ kɨ adi mede tə Abɨrakam be, ɓɨ mbata tɨ lə dɨje kɨ njé təl rɔde go ndu-kun tɨ par al. Abɨrakam kɨ e bawje je dɨje pətɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Makɨtɨbɨ lə Luwə əl ta dɔ Abɨrakam tɨ ə nə: «M-ra-i tə baw dɨje ngay kɨ dɔnangɨ tɨ ne.» Abɨrakam e bawje ta kəm Luwə tɨ kɨ ade mene. Luwə kɨ nje kadɨ njé koy je ḭḭ lo koy tɨ, kɨ nje kadɨ nḛ je kɨ kəte gotoi, toi. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abɨrakam adɨ mene Luwə, adɨ təl baw dɨje ngay kɨ dɔnangɨ tɨ ne təkɨ makɨtɨbɨ lə Luwə əl-n ə nə: «Gɨn dɨje ləi a ba̰yḭ-naa tə mee je kɨ dɔra̰ tɨ be.» Lo kɨn tɨ, nḛ kɨ kadɨ dəw ɨndə mene dɔ tɨ goto, nə Abɨrakam aw kɨ kɨndə me dɔ tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abɨrakam aw kɨ ɓal kɨ asɨ ɓasi kɨ ɓu kare, nɨngə gər kadɨ n-tɔgɨ, tɔgɨne goto, taa nene Sara ka e kujɨ tɔ, nə go̰ lo kɨn al, adɨ mene kadɨ kun mɨndɨ lə Luwə kɨ un kɨn a ra nḛ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abɨrakam ɨlə kadɨ-me ləne kɔ al, taa mee tɔsɨ dɔ kun mɨndɨ tɨ lə Luwə al tɔ. Ɨngə tɔgɨ tə kɨngə me kadɨ-me tɨ ləne, ɨlə-n tɔjɨ dɔ Luwə tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Nɨngə gər dɔne tɨ majɨ ngay kadɨ nḛ kɨ Luwə un mɨndɨ kadɨ n-ra kɨn, aw kɨ tɔgɨ kadɨ a ra-n. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","E mbata kɨn ə, Luwə tɨdə-n Abɨrakam dəw tɨ kɨ dana. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Nɨngə lokɨ makɨtɨbɨ ə nə: «Luwə tɨdə Abɨrakam dəw tɨ kɨ dana,» kɨn, e kɨ mbata lə Abɨrakam kɨ karne par al. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nə e ta kɨ sɔbɨ dɔje tɔ. Je kɨ kadɨ Luwə a tɨdə-je dɨje tɨ kɨ dana, kɨ takul kadɨ-me ləje. J-adɨ meje Luwə kɨ ḭ kɨ Ɓaɓe ləje Jəju dan njé koy je tɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jəju kɨ Luwə un-e adɨ koy mbata majal je ləje, nɨngə un-e dan njé koy je tɨ tḛḛ sie mba kadɨ tɨdə-n-je dɨje tɨ ləne. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Lokɨ Luwə tɨdə-je dɨje tɨ ləne kɨ go rəbɨ kadɨ-me ləje, danje sie e kɨ lapɨya kɨ takul Ɓaɓe ləje Jəju Kɨrɨsɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","E kɨ takul Jəju Kɨrɨsɨ, kɨ go rəbɨ kadɨ-me ə, j-ɨngə-n majɨ-kur lə Luwə. Majɨ-kur kɨ j-a me tɨ, j-ɨsɨ jɨ ra rɔnəl, tadɔ j-ɨndə meje dɔ tɨ kadɨ j-a je gɨn tɔɓa tɨ lə Luwə. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","E kɨ bo ngay, me ko̰ tɨ ka jɨ ra rɔnəl, tadɔ jɨ gər kadɨ ko̰ a re kɨ kore me, ");
INSERT INTO bjvNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nɨngə dəw kɨ nje kore mene, a a dɔ njane tɨ me nḛ je tɨ kɨ to, ə dəw kɨ nje ka dɔ nja tɨ, e dəw kɨ aw kɨ nḛ kɨndə me dɔ tɨ, ");
INSERT INTO bjvNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","nɨngə nḛ kɨ ɨndə mene dɔ tɨ kɨn, a e nḛ kɨ ngom al. Tadɔ Luwə ta̰-je bɨyə̰ tɨ kɨ ndɨgɨ-naa kɨ ɨndə nga̰meje tɨ kɨ go rəbɨ lə NDɨle kɨ adɨ-je. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kɨrɨsɨ re oy mbata tɨ lə njé ra majal je, lokɨ j-asɨ kadɨ jɨ ra nḛ madɨ kɨ dɔrɔje al. Nɨngə oy kɨ dɔkagɨlo kɨ Luwə wa ɔjɨ. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Dəw kɨ dana wa mɨndɨ ka, nga̰ ngay kadɨ dəw a adɨ rɔne koy tɨ mbata lie. Re dum wa nɨngə, dəw kɨ nje ra nḛ kɨ majɨ, ə dəw made kɨ rangɨ, a uwə rɔne ba kadɨ oy mbata tɨ lie. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lo kɨn tɨ, Luwə tɔjɨ-je ndɨgɨ kɨ ndɨgɨ-je kɨ taga adɨ j-o. Luwə adɨ Kɨrɨsɨ re oy mbata tɨ ləje, dɔkagɨlo tɨ kɨ jɨ nay-n me majal tɨ kɨ ra ɓəy. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nɨngə, təkɨ ɓasɨne, kadɨ rɔ koy tɨ lə Kɨrɨsɨ, təl-je dɨje tɨ kɨ dana ta kəm Luwə tɨ kɨn ɓa, kɨ bo ngay ɓəy, Kɨrɨsɨ a ajɨ-je ta wongɨ tɨ lə Luwə kɨ a re. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kəte je njé ba̰ je lə Luwə, nə e wa ɨlə-je nojɨ naa tɨ səne kɨ go rəbɨ kɔy NGone. Təkɨ ɨlə-je nojɨ naa tɨ kɨ rɔne, e wa a ajɨ-je me kɨsɨ kəm tɨ lə NGone. ");
INSERT INTO bjvNT_vpl VALUES ("RM5_11"