﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjr_vpl;
CREATE TABLE bjr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjr_vpl WRITE;
INSERT INTO bjr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Oosana kuradoo aukuanna Anutufa sia maru ainainannai mirisinnaarunna faqa maa maqana faqa oosana arasee auqinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Mi aukuanna maa maqafa fifau faafau inoo marufanoo, asukuna firaafa rafaaqafinoo marufanoo Anutuna maraquna fannoo nammari amuaqumau ufaira foora uqidanoo oonuree aniree imarinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mi faasaanna Anutufa qinau, kaaqa qaranara mariannee qufanoo kaaqa qarafa kambiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kambiqafufanoo qafamaseenoo amiqimambinoo qimaseenoo kaaqa qarana faqa asukuna faqa aadu aadu rakeemma quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Rakeemma quqaseenoo qafamaseenoo Anutufa kaaqa qaranara faasaanee qinau, asukunara eendaki fee qinau. Miqi qimasoofanoo mikari indaaru oosana araseenoo eendirafa naaree anireenoo aiqaroofanoo iaqarafa aniroofanoo mifa mi iaqarafa faqa mi eendirafa faqa indaaruqaa faasaana marinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mina inaaqianaa faasaana Anutufa kaifaa qinau. Innaaruna kaqi saqanna rainafinanoo nammari mirinni faqa mianni faqa aadu aadu rainanoo marianifeera qufanoo miqimminau. ");
INSERT INTO bjr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Miqi qimaseenoo Anutufa innaaruna kaqi saqanna auqu quqaseenoo nammari raina mianni faqa mirinni faqa quqanau. Quqasoofanoo doo miqinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Anutufa mi kaqi saqanna auqureenoo innaarunee qinau. Miqimmasoofanoo eendirafa aiqaroofanoo iaqarafa aniroofanoo mi iaqarafa faqa mi eendirafa faqa inaaqianaa faasaana marinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Qaaramoo faasaanaikufanoo Anutufa kaifaa qinau. Maqasaa nammari suqufinoo moodaanaki mandi finanoo maqa aadana koorooianifeera qimasoofanoo miqimminoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Anutufa aadanaikunara maqa fee qinoo auquranau. Nammari moodaanaki suqunara ooruku nammari fee qinoo auquranau. Miqi qimaseenoo doo andeeqafiifoo qimaseenoo asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Asasammaseenoo fuka maqasaara Anutufa qinau. Andanda oosana oosana kambiqaani, oosana oosana andanda neemaru ainainna aqama faqa kambiqaanni, oosana oosana aqama ireemari saqarisa faqa kambiqaannee qufanoo miqimminau. ");
INSERT INTO bjr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Maqa fannoo, oosana oosana andanda faqa saqari faqa maqanau. Maqasoofanoo Anutufa aiquqummaseenoo doo amiqimminoo fee qimasee asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Miqimmasoofanoo eendirafa aiqaroofanoo iaqarafa aniroofanoo mi iaqarafa faqa mi eendirafa faqa qaaramookinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Anutufa kaifaa qinau. Innaarunai qooma oosana oosana kambiqafinana, suani faqa quqoona faqa fasau faqa iaqarana faqa asukuna faqa rainaanifeera qinau, iaqarafa faqa aukuana faqa amaana suqirana oosana areemariana uqannifiqaani fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Mi qoomausa innarunaindari maqasaa kaaqa qamannimaqaani qufanoo miqimminau. ");
INSERT INTO bjr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Miqi qimaseenoo Anutufa firaa qoomatiaqara suani faqa quqoona faqa miqanda quqanau. Firaa qooma suaniara anee faasaana rakisinnimaqaannee qinau. Kaqikaa qoomara quqoonara anee eendaki rakisinnimaqaannee qinau. Fasau namu faqa auqu quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Anutufa mi qoomausa innaarunaindari maqasaa kaaqa qaanifeera quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Eendaki faqa faasaana faqa rakisidanoo asukuna faqa kaaqa qarana faqa rainaanifeera quqanau. Anutufa quqaseenoo aiquqummaseenoo doo amiqimmafinoo fee qimasee asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Miqimmasoofanoo eendirafa aiqaroofanoo iaqarafa aniroofanoo mi iaqarafa faqa mi eendirafa faqa qaara faqa qaara faqaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Anutufa kaifaa qinau. Aiqama nammariki maria ainainausa oosana oosana kambiqaani, maqa mirinni kaqi saqanna oosana oosana ufinuqa qumbiqaqa maridaqa qaqaqa nuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Miqi qimaseenoo Anutufa ooruku nammariki maria firaa aandausa faqa oosana oosana ainaina faqa auqu quqanau. Ufiniuqa oosana oosana faqa auqu quqanau. Auqu quqaseenoo aiquqummaseenoo amiqimmiifoo qimasee asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Miqi qimaseenoo Anutufa narí afaaqooqa qimannimaqeenoo qinau. Inni asumu moomoo kambiqafiqa ooruku nammarki qumbiqaqa mariaqa. Mifa ufiniuqara faqa moomoo kambiqafi mariaqee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Miqi qimasoofanoo eendirafa aiqaroofanoo iaqarafa aniroofanoo mi iaqarafa faqa mi eendirafa faqa moodaannai qisaukukinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Miqimma fufanoo Anutufa qinau. Maqa fannoo oosana oosana kasirana faqaa aandauqa maqaani. Maaqeena aadau faqa kaasau aandau faqa firaana faqa kaqikaana faqa maqa fannoo maqaani qufanoo miqimminau. ");
INSERT INTO bjr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Miqimmaseenoo Anutufa mi aiqama ainainausa auqu quqaseenoo amiqimmafinoo qimaseenoo asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Miqimmaseenoo Anutufa kaifaa qinau. Maasa faiqí naanna faqaasa auquanaura, maasa qimana kai maasa qeeqa fooqaana auquanaura. Misa ooruku nammariki noodaanna ainaina faqa sandaaqai qaqamaree nimaria ufinisa faqa maaqeena aandauqa faqa kaasau aandauqa firaanauqa saa faqa kaqikaanauqa saa faqa rakisianifeera auquanaura. ");
INSERT INTO bjr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Miqi qimaseenoo Anutufa faiqí narí fooqaa irana kai auqinau. Faiqí faqa anaasee faqa naumoo faqaa qanda auqinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Auquseenoo Anutufa nifaaqooqa qinoo qinau. Inniqara asumu moomoo kambiqeeqa maa maqa maaqanaki qumbiqafiqa rakisiaqa. Qinee inniqara mareeqee ooruku nammariki noodaanna faqa ufiniuqa faqa aiqama kaasau aandauqa rakisirausaika mannimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Anutufa kaifaa qinoo qinau. Inni narana sakummara foora ireemarina oosana oosana faqa oosana oosana saqari aqama faqa naaqeera nimidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Doo qinee aiqama kaasau aandauqa faqa ufiniuqa faqa andanda faqa nariqa neemaria saqari amaneesa faqa naaqeera qinee nimidaqa. Miqi qimasoofanoo miqimminoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Doo Anutufa narí auqu quqasoo aiqama ainainauqa qafamaseenoo firaaqoo asasinau. Miqimmaseenoo eendirafa aiqaroofanoo iaqarafa aniroofanoo mi iaqarafa faqa mi eendirafa faqa moodaannai qisauku taikasee dinni moodaa marasee 6 faasaanaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Miqimmaseenoo Anutufa aiqama innaaruna faqa maqa faqa auqu taikanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dinni taikasee dinni oonu qaaraqanda marasee 7 faasaana Anutufa narí ainainirana taikanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dinni taikasee dinni oonu qaaraqanda 7 faasaanara Anutufa afaaqooqa qimasee, aaduma naaquqara faasaanee qinau. Narí kadaapirirana mi faasaanna taikoonara mi faasaannara naaquqara faasaanee qimasee idooanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Miqimmaseenoo Anutufa innaaruna faqa maqa faqa auqinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Indaaru karaambaiqa Anutufa maa maqana faqa miri innaaruna faqa auqu aukuanna aaku sia maqasaa quqoonara oosana oosana andanda qaqama sia kambiqanau. Faiqí maqa apaurirafa faqa sia marinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mikamuqoo nammari fannoo maqakiqari urureenoo aiqama maqa maaqa uqeena amaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mikari karaambaiqa Anutufa maqa qumareenoo faiqí minannoo auqinau. Auquseenoo marirana nimi maru aidoona aikaamarai fuaqasoofanoo mi fasiqafa kasirana maranau. ");
INSERT INTO bjr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mi fasannai Anutufa suani afu oosanai Eedeenna maqa maaqaki kadiqa firaana auquseenoo narí auquqoo fasiqana minaki quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Anutufa oosana oosana amiqira saqariara qufanoo minaki kambiqafufaqa amiqira aqama iraqau. Kadiqa qambaanai saqari qaaraqanda marinau. Moo saqari fannoo marirana nimi maru saqarifa marinau. Kafaa moo saqari fannoo mandainainara faqa amiqira ainainara faqa irimaria iriranna nimimarufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nammari moo fannoo Eedeena maqa maaqakiqari qumureenoo kadiqa qambaana maqa uqeena uqeena ianifeera qumiqareenoo qaara faqa qaara faqaki raina fufanoo ooqufinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Moo amara auqu Pisoona nammari fee qiqau. Mifa Qafiraa maqa maaqa atindannai ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Miqoo koora amiqirafa maridanoo, amiqira afundi maru saqari anoonafa faqa miqoo marinau. Firaa feefauru aqimaria oonifa faqa miqoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kafa moo amara auqu Kiqoona nammari marinau. Mifa Kusa maqa maaqa atindanai qumifi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kafa moo amara auqu Taikirisa nammari marinau. Mifa Asiria maqa maaqa suani oosana qaannai atindanai qumi marinau. Moo amara auqu Eeufarateesa nammari marinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Karaambaiqa Anutufa narí auquqoo fasiqana mareeqee Eedeena kadidakina quqanau. Kadidaki maqa apauridanoo aiqama ainainasaa mi kadidanaki rakisianifeera quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Anutufa quqaseenoo mi fasiqana maaqi qimaseenoo aakapanau. Anee kadidakina aiqama saqari qaqama diqisee naannee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Moodaa saqariara kai qinee qaoo qidaqa. Manda ainainara irirana faqa amiqira ainainara irirana faqa nimi mari saqarina kai sia naa. Anee namaseenana mikari kai kuqinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mi fasannai karaambaiqa Anutufa mi fasiqanara qinau, maa fasiqafa naríaraa marifanoo siamma andeeqaidanoo. Qinee mina aqoonnana auqusaananoo mina dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Anutufa maqa qumareenoo minannai aiqama aandau faqa ufiniuqa faqa auqinau. Auquseenoo aiqama naarammeeqeenoo faiqí maruqoo nuquraanifeera quqasoofanoo nana ainainee auquroofa doo mi nuquna faqaasa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Miqimmaseenoo faiqí fannoo kooqikinaa aandauqa faqa kaasau aandauqa faqa ufiniuqa faqa nuqu rama quqanau. Miqiqa marufanoo Anutufa mi fasiqana aqoonnanaikiranara misaki randeenoo sia paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Minara faiqarana faiqí aminau. Faifufanoo Anutufa mina aqaasana moodaa tatuseenoo mina amaqinnai minaki ititanau. ");
INSERT INTO bjr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ititaseenoo karaambaiqa Anutufa mina aqaasanannoo anaasee auqinau. Auquseenoo faiqí maruqoo afiqee finau. ");
INSERT INTO bjr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Quqasoofanoo faiqí fannoo qafamaseenoo qinau. Doo maqee uqanna qini fooqaairafa uqanna maridanoo, amudaani qini qimudaani kinaafa, amaqi qini qimaqinnai auqirafa, qinee minara anaasee fee qimasee auquraanaura, mifa faiqí kinaafa marinara miqi qimasee auqu raanaura. ");
INSERT INTO bjr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Minara kai faiqí narí anoona akoona minnisee narí anaaqa faqa moodaanaki mafi moodaara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mi fasiqafa narí aanaaqandiri kaqisamu maruqanda mariqau, sia nariara nariara nisauri mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Karaambaiqa Anutufa aiqama aandauqakina auquqoona qambaanaindari sakani mifa nikaru qira ufa akoofasa marinau. Mifa anaasee iramirinoo qinau. Kuqaa fee Anutufa saqariuqaki aiqama qaoo qinoo fee sia naaqee qinoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mi anaaseefa minara iriseenoo qimaminau. Eeoo aiqama maa afuqanakinaa saqari naaqee qifaqa naidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kadiqa qambaanai moodaa saqariara sia naaqee sia auqaaqee qifaqa sia naidaqa. Maasa namaseeqa kuquanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sakani mina ufa iriseenoo anaasee akaru qinoo qinau. Namasee sia kuqinnara unnaqidanoo, anee sia kuqinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Anutufa minara iridanoo qaoo qinoo. Innee mi saqari aqamana namasee Anutufara foora maridaqa manda ainainara faqa amiqira ainainara faqa irifoora. ");
INSERT INTO bjr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Anaasee sakani ufa iriseenoo mi saqarina afu qafamasoofanoo amiqirafa marufanoo aqama faqa qafoofanoo idaaqirafa marufanoo amiqira ainainara iriranara faqa manda ainainara iriranara faqa irufanoo amiqufanoo mi saqari aqamana diqiseenoo neenoo narí afaaqi faqa amufanoo nanau. ");
INSERT INTO bjr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Miqanda namasoofanoo mikari miqanda nifusaa irirafa kambiqoofaqa nári nifaaqa qafamasee kaqisamu maridee qimaseeqa nisauruseeqa saqari amanee didiqi amanee fooqaana qumaree akunuseeqa nári nifaaqasaa ititaqau. ");
INSERT INTO bjr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mi faasaanna eenaanianna asooaa asooaa imarufanoo Karaambaiqa Anutufa kadidai nimarufaqa faiqí faqa anaasee faqa iriqaqara saqariuqaki nisaurusee kukeeqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Karambaiqa Anutufa faiqí aaramasee anee yaifee qufanoo mifa qinau. ");
INSERT INTO bjr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Anee kadidai nuanaqa qinee iriseeqa kaqisamu mariunausa rufiaseeqa saqariuqaki kukeeqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Miqi qufanoo Anutufa qinau, yafee ani kaqisamu mariannanara qimaminoo fee. Anee saqari aqama qinee qaoo qunnana neenanee. ");
INSERT INTO bjr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Faiqí iriseenoo narí qimaminoo qinau. Maa anaaseefa qini faqa marifa anee qimunafa mifa qimifaqa neeqa. ");
INSERT INTO bjr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Miqi qufanoo karaambaiqa Anutufa mi anaaseena iramirinoo qinau. Anee nanaree maa oosanna mareenanee. Mi anaaseefa iriseenoo qinau. Sakani fannoo anireenoo qini qikaru qifaqa neeqa. ");
INSERT INTO bjr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Karaambaiqa Anutufa mina iriseenoo quandafinoo mi sakanina manda afaaqooqa qimamaqeenoo qinau. Anee maa anaaseena akaru qiannanara mina akiiqara aiqama aandauqakiqari anee kai maa manda afaaqooqana mareennaranoo. Anee maqamau amuaqundari nidana kookoomma nananua. ");
INSERT INTO bjr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Qinee qianaqa maa anaaseefa faqa anee faqa nariara nariara fidiaqaa ifaranoo. Inniqara faiqinamu naaruara namuqaa marifaranoo. Mi anaaseena asumu kiqari moodaa fannoo ani akiiqa radamuannoo. Anee mina asumu kinaana aiku ataa ukaqa aminnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Anutufa maaqi qimasee anaasee afaaqooqa qinoo qinau. Anee amuaquqa faqa marinaqa umaara firaanaikamma amaqaanaura. Miqimmaseeqa faiqi maqaraqoo faqa aupurarana amianaura. Ani aundura fannoo aneenna afaaqiara rida marinnaranoo. Ani afaaqi fannoo ani uri aaqararafa marinana anee mina ureeqarafa marinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Miqi qimaseenoo Anutufa quandafinoo faiqi afaaqooqa qinoo qinau. Anee aneenna anaaqa ufa iriseena qinee qaoo qunna saqarina qaqama naananoo. Minara maa maqana aqurarasaanana anee kadaapi ridana arirana rakeeidana maa maqanaki ummaqusee naida maria. ");
INSERT INTO bjr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nimmuru faqa amuka faqaa ainaina faqa maqakiqari kambiqaannoo. Anee kaasau andanda neennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Anee tooqaamu arimarinana kadaapirumasaidana maa maqanasaa narana kambiqasaidana nana fifiinana kuqinana maqaki ani auquafannanaki finnaranoo. Ani maqannai auquqaafanafa marianafa mariananoo. Anee maqa mariananoo kaifaa maqaikamma finnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Faiqí fannoo narí aanaaqara maqasaa qaraa fasiqa anaasee ninoo fee qimaseenoo auqu Eewanee qinau. (Mi auquna oosana aiqama faiqí faiqi ninoo fee qidanoo.) ");
INSERT INTO bjr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Karaambaiqa Anutufa aandau apata qumareenoo minannai qamunnara foora auqeeqeennoo Adamana faqa narí anaaqa Eewana faqa niminau. ");
INSERT INTO bjr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Miqimmaseenoo Karaambaiqa Anutufa qinau. Maqee faiqí faiqi maafa maasara foora maridaqa aaqara oosanara faqa andeeqara oosanara faqa iridaqa. Maasa sia miqandara qianaqa naaru marirana nimimari saqari aqamana diqisee neefaranoo. Diqisee namaseeqa naaruara marifoora. ");
INSERT INTO bjr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Karaambaiqa Anutufa minara iriseenoo Eedeena kadidakinaana doo miqanda nifaqaseenoo qinau. Inneeqara inni auquafanna maqanasaa maridaqa maqa auqamasaidaqa narana paquriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Anutufa Eedeenna kadidakiqari Adamasa Eewasa niqiqoofaqa fufanoo suani oosana qaannai kadida atinni naaru marira saqari fainnai fimaru aannanasaa angiroouqa quqasoofaqa ida auru arira paipana uaqeeidaqa faiqí minni fifoora ruki tataaka imariqau. ");
INSERT INTO bjr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamafa narí anaaqa Eewana faqa aana numasoofanoo amuaqu qaikinoo faiqi maqaseenoo mina auqu Kainafee qinau. Maqaseenoo Eewafa qinau, Anutufa dadaaqifaqa qinee faiqi akoonaiqi maqeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kafaa mariufanoo faiqi moo maqaseenoo mina auqu Abeeranee qinau. Abeerafa innooqafinoo kooqikinaa aandausaa rakisirafa marinau. Mina afasaafa Kainafa innooqafinoo afuqakina ainaini marufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mariufanoo moo kari Kainafa narí afuqakinaa ainaina maraseeoo Anutuna tatufirana suqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeerafa mifa faqa Anutuna tatufu amiraree qimaseenoo narí firimaru aandausakinaana ooqasaa maqarana afaaqafaqaana aruseenoo amiqira afaaqa kai tatufirana suqa aminau. Abeerana tatufirana Anutufa qafeenoo amiqira fee qimasee asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kafaa Kainaindi qafamasee minnisanau. Kainafa mina qafoofanoo firaqoo arana qoofanoo oori runinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Anutufa Kainana qafamaseenoo qimaminau, nanaree ani arana qaidanoo fee. Nanaree ani oori mianni qumidanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Anee amiqira ainaina auqeenanau asasa mianaiqini. Anee mandainaina auqaannanara numoo fannoo ani kooqiki ani amaara usinoo maridanoo. Mifa ani rafaaqa firarinana anee mina uraaqaraa. ");
INSERT INTO bjr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Miqi qimasoofanoo Kainafa narí akaqa Abeerana qimaminoo qinau. Aninaqa aana fua. Miqanda moosaa oonureeqa Kainafa narí akaqa Abeerana kuqa arinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Arusoofanoo Anutufa Kaina iramirinoo qinau, ani akaqa Abeerafa yaifee maridanoo fee. Qufanoo Kainafa qinau, Abee qinee sia iridaqa, anee qiniara narí akaqasaa rakisimarifee fee qidanee. ");
INSERT INTO bjr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Anutufa mina iriseenoo qinau. Kaina anee nanee mareenee. Anee iria, aneenna akaqa fidika maqasaa teeqiananoo. Mi fidikafa mina akiiqara iannee qimasee maqakiqari qini daaraifaqa iriqa. ");
INSERT INTO bjr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Anee aneenna akaqa fidika maa maqanasaa teeqiananoo maqa qoo raqafinaki ani akaqa fidika minaki keeqeenoo. Minara qinee ani aqurara ufa ameemaanai quqaidaqa. Anee sia kaifaa maqaki narana ummaqusaida neennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Anee narana ummaqusainanoo maqa fannoo sia ani narana amiannoo. Minara anee maaqa siainafa maridana aiku quqirafa maaqa maaqa kaqi ninnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kainafa minara iriseenoo Anutuna qimaminoo qinau. Anee qummaara firaana qini qimiananoo sia qinee amana uqeeraanaura. ");
INSERT INTO bjr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Qinee maa maqanasaa ani afusaa marunnana anee diqiqaanaqa qinee qiku quqirausa aiqamatinai nuanaura. Qinee maaqanna maaqanna dapikiqa nuananoo yafee qini qiqafainafa mifa kuqa daruannoo. ");
INSERT INTO bjr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Karaambaiqa minara iriseenoo qimaminoo qinau. Sia miqifara, faiqí moo fannoo yafee ani arinnana qinee mina akiiqara dinni taikasee dinni ani qaaraqanda marasee naruanaura. Miqi qimaseenoo karaambaiqa Kaina afaaqasaa sia aruaqee akara quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Miqooqari Kainafa Anutuna oorisaaqari finoo Eedeena kadida aaqaqari suani oosana qaannai moo maqa maaqai mina auqu niku quqirausa nua maqusa fee qimarunnai finau. ");
INSERT INTO bjr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Miqoo oonureenoo Kainafa narí anaaqa faqa faiqi moo akoonaiqi maqaseenoo mina auqu Eenookanee qinau. Kainafa narí anaaqa faiqi maqoo kari maqusa moo auquseenoo mi maqusana auqu narí amaaku amaranaikinoo Eenooka maqusa fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Eenookafa faiqí kammafinoo akoonaiqi Iradana maqanau. Iradafa faiqí kammafinoo akoonaiqi Meequyaeerana maqanau. Meequyaeerafa faiqí kammafinoo akoonaiqi Metusaeerana maqanau. Metusaeerafa faiqí kammafinoo akoonaiqi Rameekana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Rameekafa faiqí kammafinoo qaara anaasee maranau, moona auqu Adaa nammarifa moona auqu Siraa nammarifa mariqau. (Adaa nammarina auqu oosana amiqira fee qimaqoofa marinau. Siraa nammarina auqu oosana auqaana fee qimaqoofa marinau.) ");
INSERT INTO bjr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Indaaruqaa anaasee auqu Adaa nammarifa faiqi moo Yabarana maqasoofanoo findifinoo aandau apatannai uiqaana maqa usakasaida nimarusa nikoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabarafa firimaru aandausasaa rakisi marusa nikoofa marinau. Yabarana akaqa Yubarafa marinau. Mifa findifinoo qufireena fuaqee marusa faqa piripunna arimarusa faqa nikoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Rameekana inaaqiana anaasee moo Siraa nammarifa marinau. Mifa akoonaiqi Tubarakaina maqasoofanoo findifinoo koopaannai faqa qainnannai faqa ainaina auqimarufa marinau. Tubarakainana auna auqu Naammaa nammarifa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Rameekafa narí aanaaqaqara maaqi qimasee qimanniminau. Adaa nammarisa Siraa nammarisa qini ufa iriaqa, Qinee Rameekausa qini qinaaqaqara ufa qianaqa amiqimmasee iriaqa. Faiqí moo fannoo kaakadi darifaqa qinee mina kuqamma ariqa. Asauku samu qini darina akiiqara mi kumaaraana kuqamma ariqa. ");
INSERT INTO bjr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Moo fannoo Kainana arinnana akiiaqara Anutufa dinni taikasee dinni ani qaara marasee 7 fasiqa naruannoo. Moo fannoo qini Rameekausa darinnana akiiaqara Anutufa fiqaramasee 77 fasiqa naruannoo. ");
INSERT INTO bjr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamafa kaifaa narí anaaqa faiqi mara amisoofanoo amuaqu qaikinoo akoonaiqi moo maqaseenoo mina auqu Seetanee qinau. Miqi qimaseenoo mina anoofa qinau. Anutufa qini qimaaku moo qiminoo narí afasaana Abeerana amaaqa maqaanifeera qiminoo mifa Kainafa aruna amaaqa maqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seetafa innooqafinoo akoonaiqi Eenoosana maqanau. Eenoosafa maru kamuqooqari oosana arasee misa Anutunara innaaru qidaqa minara naaqura Karaambaiqee Yaawee fee qidaqa innaaru qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adamana aiku asauku misa oosana maaqimmasee akaraki marinau. Anutufa indaaru narí amana kai faiqí anaasee auqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Naumoo faqaa qanda auquseenoo nifaaqooqa qima nimaqaseenoo faiqí anaasee fee qimasee nuqu ranau. ");
INSERT INTO bjr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamafa aukuana 130 marasoofanoo mina amaaku Seetafa kambiqanau. Narí akoona fooqaafa mina amana kai marinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seetana maqookari oosana araseenoo Adamafa 800 aukuana maranau. Mi kamuqoo akoonaiqi maanaaqa faiqi namu moomoo Adamafa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamana aukuana aiqama 930 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seetafa 105 aukuana maraseenoo akoonaiqi Eennoosana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Eennoosana maqoo kamuqooqari Seetafa 807 aukuana maraseenoo mi kamuqoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seetana aiqama aukuana 912 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Eennoosafa 90 aukuana maraseenoo akoonaiqi Keennana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Keennana maqoo kamuqooqari Eennoosafa 815 aukuana maraseenoo mi kamuqoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Eennoosana aukuana aiqama moodaanaki 905 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mina amaaku Keennafa 70 aukuana maraseenoo akoonaiqi Maqarareerana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maqarareerana maqoo kamuqooqari Keennafa 840 aukuana maraseenoo mi kamuqoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Keennana aukuana aiqama moodaanaki 910 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mina amaaku Maqarareerafa 65 aukuana maraseenoo akoonaiqi Yareedana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yareedana maqooqooqari 830 aukuana maraseenoo mi kamuqoo akoonaiqi maanaaqa faiqi namu moomoo Yareedafa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maqarareerana aukuana aiqama moodaanaki 895 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mina amaaku Yaareedafa 162 aukuana maraseenoo narí amaaku Eennookana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Eennookana maqooqooqari Yareedafa 800 aukuana maraseenoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yareedana aukuana aiqama moodaanaki 962 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mina amaaku Eennookafa 65 aukuana maraseenoo akoonaiqi Meetuseerana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Eennookafa 300 aukuana Anutuna aqoondikiranaki maridanoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Eennookana aukuana aiqama moodaanaki 365 aukuana maranau. ");
INSERT INTO bjr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Eennookafa sia kuqinau. Kaaqa Anutunara rimarufa marufanoo Anutufa kaqimma afiqasoofanoo sia sia inau. ");
INSERT INTO bjr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Eennookana amaaku Meetuseerafa 187 aukuana maraseenoo akoonaiqi Rammeekana amarana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Rammeekana maqooqooqari mina akoofa Meetuseerafa 782 aukuana maraseenoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Meetuseerana aukuana aiqama moodaanaki 969 aukuana maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Meetuseerana amaaku Rammeekana amarafa 82 aukuana maraseenoo akoonaiqi maqaseenoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Anutufa maa maqa maaqana aquraraqoofaqa maasa kadaapi ridaqa. Maa faiqifa kadaapiriranaki marunnana asooarana qimiannoo fee qimasee mina auqu Nooa nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nooana maqooqooqari mina akoofa Rammeekafa 595 aukuana maraseenoo akoonaiqi maanaaqa faiqi namu moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Rameekana aukuana aiqama moodaanaki 777 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mina amaaku Nooafa 500 aukuana maraseenoo miqooqari akoonaiqi qaaramoo maqanau. Misa nuqu Seemmana faqa Qammana faqa Yafeetana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Mi fasannai faiqí anaasee moomoo kamambufaqa maqa maaqa itita fiqa maridaqa misa maanaaqauqa moomoo maqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Maqasaa fasiqauqa Anutuna faiqi namu mi manaaqausa nindafoofaqa nifu noori amiqirausauqa kai marufaqa nári nidimarusa maree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Miqi marufanoo Anutufa qinau. Qini maraquna naaru naaru sia faiqiki mariannoo. Misa fifau faiqí faiqi marianara kisaaqa aukuana ateekasee qusa aukuana nimianaura, 120 aukuana kai nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mikari faqa kasooqaqee faqa maqasaa fasiqauqa Anutuna faiqi namu faiqí niraamuna maraqa ninii soofaqa faiqi maqee mariqau. Mi faiqisa nimudaani faqaasa murusaqa arirausa maa maqanasaa maridaqa nuqu faqaasa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Anutufa aiqama maqasaaqaraasa nindafoofaqa misa marirafa faqa irirafa faqa mandaika uqanna inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Miqiqa marufanoo Anutufa firaqoo misa mi manda oosannara irinau. Mifa faiqí auqu maqasaa quqoonara irufanoo aundura mandaikufanoo akooqoofanoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Maa oosanausa qinee auquafanausa maa maqanasaa qaraana qinee aiqama ruka aqusaanaura. Faiqí faqa ufini aandau faqa aiqama ruka aqusaanaura qinee misa auquafannanara qikooqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Anutufa Nooanara kai asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nooana oosana maaqimminoo marinau. Nooafa kai sia aaqarana marufa marinau, narí faqa marusakiqari naríara andeeqarafa marinau. Mifa kai Anutuna aqoondikiranaki marinau. Mina amaaku qarammoo namu mariqau. Misa nuqu Seemmafa faqa Qammafa faqa Yafeetafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Aiqamausa Anutuna afusaa mandainainaki mariqau. Faiqí narari nararirafa aiqama maqa maaqaki qumbiqanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Anutufa aiqama maqa maaqaki qafoofanoo mandaika uqannamminoo marinau. Faiqí anaasee aiqama mandainainaki kai mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Miqiqa marufanoo Anutufa Nooana qimaminoo qinau. Faiqí narari nararirafa qumbiqanoo marinara qinee aiqama fasiqa anaasee naru taikaanauree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nooa, anee amiqira saqarinnai firaa sipa auqua. Mina aunduraki moomoo rumma auqua. Aunduraki faqa adisaa faqa koorootaqa qumaree akusainanoo ititaani. ");
INSERT INTO bjr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Anee sipa maaqimasee auqua. Mina kisaaqa fannoo Aarinnoonna nammarikiqari Siara Doona nammariki amanasaa 130 metres mina kisaaqa mariani. Mina qusa fannoo 22 meters sia kisaaqa uqanna marinau. Mi sipana maqasaqari maaqa akiiqa amanasaa 13 metres mariani. ");
INSERT INTO bjr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Asaana qumeeqarana ameemaanai apootaana kaqi mariani 0.5 metre mariani. Sipa qaqaasanai firaa kooqi auquseenana sipa aundurai maqasaa tida rua, mina murufi qambaanai moo tida rua, mina maariqoo moo tida rua. ");
INSERT INTO bjr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Anutufa kaifaa Nooana qimaminoo qinau. Qinee nammari mareeqee quqasaananoo firaaqoo aufinoo aiqama kasimari ainainausa naru taikaannoo. Aiqama maqasaa maria ainainausa faqa kuqu taikeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ani faqa kai moodaanaki kira ufa qianaura. Aneenna anaaqa faqa aneenna faiqi namu faqa misa ninaaqmaaka faqa sipaki keeqafi mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Anee aandau oosana oosana mareeqee sipaki quqaa. Oosana oosana qaara kai qaara kai akoona faqa anaasee faqa apammasee sipaki quqasainaqa ani faqa asumu mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Oosana oosana ufini faqa qaara kai qaara kai mara quqasainaqa ani faqa asumu mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Anee oosana oosana narainaina misaindi faqa aneennaindi faqa mara sipaki quqaa. ");
INSERT INTO bjr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nooafa Anutuna ufa iriseenoo mifa qundee kai inau. ");
INSERT INTO bjr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Karaambaiqa Nooana maaqi qimasee qimaminau. Anee aneenna aiku asauku faqa sipaki keeqaa. Maqa saaqaraasakiqari anee kai aneennaraa andeeqarafa mariana qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Innee qini qifusaa anukara aandau fee qimariana qisauku dinni taikasee dinni oonu qaara marasee 7 akoona faqa anaasee faqa ani faqa sipaki mareeqee quqasainaqa asumu mariaqa. Innee qini qifusaa sia anukara aandau oosana oosana akoona faqa anaasee faqa moodaa kai mareeqee minaki asumu quqasaina mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Aiqama ufini oosana oosana dinni taikasee dinni oonu qaara marasee 7 akoona faqa anaasee faqa mareeqee sipaki quqaa. Miqimmasainaqa aiqama aandau ufini kaifaa maa maqanasaa moomoo kiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Dinni taikasee dinni oonu qaaraqanda marasee 7 faasaana aiqarainaqa miqoo aaku maqasaa quqaanaura. Qaara fasiqa niku nisauku taikasee 40 faasaana faqa eendaki faqa aaku rida mariannoo. Miqi marinaqa qinee maqasaa aiqama naanna faqaasa qeeqa auqu nisaafanausa taika nisaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nooafa aiqama ainaina Anutufa qimamundee kaimminau. ");
INSERT INTO bjr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nooafa 600 aukuana marasoofanoo mi aukuannasaa nammari aufirafa aninau. ");
INSERT INTO bjr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nooafa Anutuna mi ufausa iriseenoo rufiaseenoo narí faqa narí anaaqa faqa narí amaaku qaaramoo namu faqa minamusa ninaaqmaaka faqa sipaki keeqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Oosana oosana aandau ufini akoona faqa anaasee faqa Anutuna afusaa anukarausa faqa sia anukarausa faqa aiqama Nooana faqa sipaki keeqaqau. Anutufa ufa qumau kai keeqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Dinni taikasee dinni oonu qaara marasee 7 faasana marinoo nammari aufinau. ");
INSERT INTO bjr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mi aukuanna Nooafa 600 aukuana maranau. Qaara quqoonasaa qiku dinni taikasee dinni oonu qaaraqanda marasee 17 faasaanasaa mi faasaanna kai nammari radiqinau. Mi faasaanna kai maqa ameemaanaindari nammari radiqisee urureenoo innaaruna kooqiara foora atuqoofanoo aaku firaafa nammariara foora adianau. ");
INSERT INTO bjr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Qaara fasiqa niku nisauku taikasee 40 eendaki faqa faasaana faqa aaku firaafa nammariara foora adianau. ");
INSERT INTO bjr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nammari radiqu faasaanna mi faasaanna kai Nooafa narí aanaaqandiri faqa narí amaaku namu Seemafa faqa Qammafa faqa Yafeetafa faqa minamusa nári ninaaqmaaka faqa sipaki keeqafiqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Kaasau aandau oosana oosana faqa maaqeena aandau oosana oosana faqa ufini oosana oosana faqa firaa aandauqa faqa kaqikaa aandauqa faqa Nooana aiku asauku faqa sipaki keeqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Aiqama oosana oosana kasimaru aandau ufinisa akoona faqa anaasee faqa Nooana faqa sipaki keeqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Anutufa Nooana qimamu mau kai keeqa fufanoo Anutufa narí kai kooqi itita nimaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Qaara fasiqa niku nisauku taikasee 40 faasana aaku nammariara foora adianau. Miqi ufanoo nammari qumbiqeenoo sipa uqeereeqeenoo murusaqa quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nammari fannoo firaaqoo innooqoofanoo sipa fannoo mina amuaqumau nimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Nammari fannoo moo faqa innooqeenoo aiqama kisaaqa aaqana dukuninau. ");
INSERT INTO bjr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Kaifaa innooqeenoo kisaaqa aaqana oori aaqaramaseenoo 7 meters amana ooru marinau. ");
INSERT INTO bjr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Miqinoo marufanoo maqasaa maru ainainausa aiqama kuqiqau. Aiqama ufiniuqa faqa aiqama andauqa faqa aiqama fasiqa anaasee faqa kuqu taikaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Aiqama aandau faqa doodaani faqa maa maqanasaa marusa kuqu taikaqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Karaambaiqa aiqama ainaina maqasaaqaraa ainaina taika uqanna sanau. Faiqí anaasee faqa aandau faqa ufini faqa taikannisanau. Nooafa kai narí aiku asauku faqa narí sipakinaa ainainauqa faqa misa kai asumu mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Dinni qisauku taikasee dinni oonu qaara fasiqa maraseenoo moodaa fasiqa asaukuqara 150 faasaana nammari kaqi aufinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Marufanoo Anutufa Nooanara faqa narí aiku asauku faqa aiqama aandau mina faqa marusara faqa iriseenoo qufanoo ufai uqufanoo nammari fannoo qumi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Maqa ameemaanaindari nammari ururee maruna rafaaqa finau. Rafaaqafuseenoo innaaruna kooqiara foora ititasoofanoo innaarunaindaraa nammari faqa sia quminau. ");
INSERT INTO bjr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Itita fufanoo maqasaa nammari fannoo ireeda kai ireeda kai ooru maree ooru maree qumiqumii ufanoo maqa koorooinau. 150 suanisaa nammari qumimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Dinni taikaseenoo dinni oonu qaaraqanda marasee 7 quqoonasaa miqi mandee quqoonna qambaanai qisaukuqara faqa dinni qiku taikaseenoo dinni oonu qaara marasee 17 faasaana Nooana sipa fannoo Ararata aaqanasaa muqufi quqasoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Miqooqari nammari uru maree ooqinufanoo qisaukuqara taikasee 10 quqoonasaa indaaruqaa faasaanasaa aaqana atiuqa koorooinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Qaara fasiqa niku nisauku taikasee 40 faasaana aiqaroofanoo Nooafa winduaqa atuaseenoo ufini kaammeesa fooqaana mara aqinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ufini fannoo sia kaifaa aninau. Kaqi kai qaqanoo nimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nooafa mi ufininara rakisusia sia anufanoo nakipuruna mara aquseenoo nammari qafaanifeera aqiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Aqusoofanoo nakipuruna maqara randoosianoo nammari kaqi marufanoo mi eendanaki kai kaifaa Nooafunnai sipaki aninau. Nooafa narí asauku madaanai quqaseenoo qumara sipaki quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Qisauku dinni taikasee dinni oonu qaara marasee 7 faasaana afeesida mariufanoo Nooafa nakipuruna kaiqaa mareeqeenoo madaanai aqinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eenee marufanoo nakipuruna fannoo oorifa saqari amanee ammunirana rakeemma aaku maree aninau. Nooafa mi saqari amaneena qafamaseenoo doo nammari ooqi maridanoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Miqooqari kaifaa dinni taikasee dinni oonu qaara marasee (7) faasaana aiqaroo fanooo Nooafa nakipuruna kafaa mara quqasoofanoo doo funnai fifinoo doo sia kafaa aninau. ");
INSERT INTO bjr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nooafa 601 aukuana marasoofanoo indaaruqaa quqoona indaaruqaa faasaanasaa nammari tukaqnanau. Nooafa sipa ataufakaaqa akuamaqaqoona rafaammasee qafoofanoo maqa aadana usimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Namba 2 quqoonasaa 27 faasaanasaa aiqama nammari tukaqnamafufanoo maqa maaqa aadana uqanna marinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Miqimmafufanoo Anutufa Nooana qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Doo sipakiqari anee faqa aneenna anaaqa faqa aneenna faiqi namu faqa misa ninaaqmaaka faqa raudaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Aiqama ufiniuqa faqa aandauqa faqa nifiqee raudaaqa. Raudamafiqa maqa maaqaki daraaniqa asumu moomoo kambiaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Miqi qimasoofanoo Nooafa faqa narí anaaqa faqa narí faiqi namu faqa misa ninaaqmaaka faqa sipakiqari raudaqau. ");
INSERT INTO bjr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Aiqama aandauqa faqa ufiniuqa faqa narí oosana narí oosana kai moodaanaki suqufufaqa raudamaki daraaniqau. ");
INSERT INTO bjr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nooafa rafudamafufanoo karaambaiqa tatufirana suqarara ooni qumareenoo aaku aakummaseenoo Anutuna afusaa anukara aandau faqa ufini faqa maraseenoo muduka Anutuna tatufirana suqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Suqoofanoo mina afunda karaambaiqa aikiambu ufanoo udirama qafeenoo asasinau. Asasammaseenoo maaqi qimasee qimmirinoo qinau. Sia qinee kaifaa faiqí inni mandainaina akiiqara aiqama maqa maaqa niquraraanauranoo. Inneeqa faiqi saaqari irirana faqa marirana faqa mandaika kai imarunara sia kaifaa unandee iqa maqa maaqa afaaqasasa maria fasiqa aanaaseesa faqa aandau doodaani faqa naru taikaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Anutufa minara maaqi qimasee qinau. Maa maqafa kaqi marinaqa qummaqira aukuana faqa narana nara aukuana faqa suara faqa aiqaiqa faqa aaku aukuana faqa suani aukuana faqa faasaana faqa eendaki faqa sia taika nimaqaanaura, kaqi marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Anutufa Nooana narí faiqi namu faqa nifaaqooqa qinoo qinau. Inni asumu moomoo kambiqafi aiqama maqa maaqa amana kai mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Aiqama aandauqa faqa ufiniuqa faqa noodaanna faqa inniara rufiaranaki mariaqa. Misa inni afeeka ameemaanai mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Innee maaqooqari sia andanda kai naaqa mi aandausa namu faqa naaqa. Innee naranara foora naaqeera nimidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Innee moodaa ainaina kai sia naaqa, fidika amaqiki marinnana kai sia naaqa. Mifa marirana nimimarifa marinara sia naaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Faiqí moo fannoo faiqí faiqi fidika ruqiqainaqa qinee mina akiiqara ummaara amianauranoo. Aandau moo fannoo faiqí faiqi kuqa narinaqa qinee mi aandauna kuqa aruanaura. ");
INSERT INTO bjr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Anutufa faiqí faiqi narí fooqaasa auquqoonara yafee moona auqu qimasee kuqa arinnana akaqausa mina akiiqara narí arifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Innee moomoo faiqi maqasaifaqa aiqama maqa maaqaki amanaikammafi mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Anutufa Nooana faqa narí faiqi namu faqa kaifaa qimanniminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Maqee qinee inni faqa innisaaqari kasooaqee kambiqainausa faqa moodaanaki kira ufa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Aiqama ainaina ufiniuqa faqa aiqama aandauqa faqa ani faqa sipakiqari anusa faqa moodaanaki kianaura. ");
INSERT INTO bjr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Maa ufausannoo qinee moodaanaki kira ufa inni faqa qidaqa. Qinee kuqaa qima afeekaika qidaqa sia kaifaa nammari aufirafa faiqí faqa aiqama ainaina faqa naruannoo. Sia uqanna kafaa nammari aufirafa maa maqa maaqana mandaikiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Qinee naaru marira moodaanaki kira ufa ani faqa aiqama aandauqa faqa doodaaniuqa faqa qunafa maaqi qimasee uqannifiqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Qinee qeeqa oondanda oonnamuki quqaanaura. Mifa qinee maa maqanasaaqaraasa faqa moodaanaki kirana uqannifiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yairee fee qinee oonnamunnai innaaruna itita saananoo miqoo oondanda kambiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Oonnamuki oondanda rafeeqna finaqa qafeeqa qinee ani faqa aiqama aandau doodaani faqa qima afeekaikira ufara irisee sia kaifaa nammari aufirafa naruannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Oondanda oonnamuki rafeeqnainaqa qafamaseeqa naaruara qinee inni maqasaaqaraasa faqa naaru marira moodaanaki kira ufa qiafannanara irianaura. ");
INSERT INTO bjr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Minannai qinee aandauqa faqa doodaaniuqa faqa qima afeekaikiafanna ufana kooroo idaqa. ");
INSERT INTO bjr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nooana faiqi namu sipakiqari anusa nuqu maaqimminoo marinau. Seemmafa faqa Qammafa faqa Yafeetafa faqa mariqau. Qammafa Kannaana akoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nooana mi faiqi qaaramoo namusa aiqama maa maqanasaaqaraasa nikeeku nikaaku mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nooafa afuqaki ainaini marufa marinau. Mifa indaaru oosana arasee afuqa auqusee uainna sanda moomoo ummaqinau. ");
INSERT INTO bjr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mifa uainna aqama tatiseenoo moomoo neeneeseenoo furufara maseenoo narí qamunna raipaquseenoo narí uiqaana maqaki kaqi samu faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","(Yafeetafa indaaruqaafa Seemafa mina aanaaqianaafa marinau Qammafa inaaqianaafa marinau.) Qammafa Kannaana akoofa maridanoo anireenoo narí akoofa kaqi samu faiqaqee ufanoo oonu qafeenoo narí akaqaafasaaqara naaramaseenoo qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Seemafa faqa Yafeetafa faqa minara iriseeqa qaoo qimasee qamunna marasee moo fannoo dinni ati narí aururusaa quqasoofanoo moo fannoo dinni ati narí aururusaa quqaseeqara ninaaqianaindari uiqaana maaqaki keeqa fiqaqara nári nikoona afaaqa itita amaqaqau. Miqanda noori kaqinni quqasee nisauruanoo qimasee sia nári nikoona qafaqau. ");
INSERT INTO bjr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nooafa kasooqaqee irirafa kambiqafufanoo narí inaaqianaa faiqi mifa auqoo ainainnara irinau. ");
INSERT INTO bjr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Iriseenooo maaqi qimasee aquraranau. Qinee ani amaaku Kannaanasaa aqurara ufa quqaanaura. Anee aneenna akaqaafasaauqa saika faiqi maria. ");
INSERT INTO bjr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Miqi qimaseenoo Nooafa quandafinoo Qammana akaqaafasaa qarara maaqi qinau. Karaambaiqa Seemana Anutuna amooqirana amia. Kannaafa Seemana ainainira faiqi mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Anutufa qinanoo Yafeetanakiqari moomoo kambiqafiqa mina faiqi namu Seemana faiqi namu faqa moodaanaki marifaranoo. Miqiqa marifanoo Kannaafa Yafeetana ainainira faiqi mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nammari aufirafa taikoofanoo miqooqari Nooafa 350 aukuana maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mina aukuana aiqama moodaanaki 950 aukuana maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nooana faiqi namu nuqu maaqimminoo marinau. Seemmafa faqa Qammafa faqa Yafeetafa faqa mariqau. Nammari aufirafa taikooqooqari misasaaqari kambiqarausa nuqu maaqimminoo mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafeetana faiqi namu nuqu maaqimminoo marinau. Koommafa faqa Makookafa faqa Madaifa faqa Yafanafa faqa Tubanafa faqa Meeseekafa faqa Tirasafa faqa mariqau. Mi fasiqausa ninaiqimara nisaifaqausa nariqa ninaakusa nuqu maree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Koommanasaaqari kambiqoo maqannaasa nuqu Asakeenasa maqannaasa faqa Rifata maqannaasa faqa Tookaramma maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yafatanasaaqari kambiqoo maqannaasa nuqu Eerisa maqannaasa faqa Sipainna maqannaasa faqa Sipurusa maqannaasa faqa Roodeesa maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Misa ooruku nammari afaiqara marusa faqa kaqikaa afumaki marusa faqa misa ninaakusa mariqau. Misauqa Yafeetanakiqari kambiqarausa maridaqa naadu naadu maqa maaqaki maridaqa naadu naadu ufa qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Qammana faiqi namu nuqu maaqimminoo marinau. Kusafa faqa Isipafa faqa Ribiafa faqa Kannaafa faqa mariqau. Mi fasiqausa ninaiqimara nisaifaqausa nári ninaakusa nuqu maree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusana faiqi namukiqari kambiqoosa Seebaa maqannaasa faqa Qafiraa maqannaasa faqa Sabataa maqannaasa faqa Rammaa maqannaasa faqa Sabateeka maqannaasa faqa mariqau. Rammanasaaqari kambiqoosa Seebaa maqannaasa faqa Deedana maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusafa akoonaiqi Nimaroodana maqanau. Nimaroodafa findifinoo maa maqa maaqanaki indaaruqaa rakira karaambaiqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Karaambaiqa dadaaqufanoo mifa amudaanai qimasee uaqee marufa marinau. Miqi marunara faiqí anaasee maaqi qimasee akaqausara qimariqau. Karaambaiqa fannoo ani Nimarooda fara foora kaaqa amudaanai qimasee uaqee mari fara foora maisaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimaroodafa Baabeera maqusa faqa Eereeka maqusa faqa Akada maqusa faqa mi maqusa namuna indaaru rakisimarinau. Mi maqusa namusa Babiroonia maqa maaqaki mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Miqoo mariufanoo Nimaroodafa Asiria maqa maaqai oonureenoo Ninifee maqusa faqa Reehoobootaira maqusa faqa Karaa maqusa faqa Reeseena maqusa faqa auqinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Reeseena maqusa fannoo Nineefee maqusa dinni marifanoo Karaa firaa taunna dinni marifanoo qambaana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isipana saaqari aruakusa Ridiaa maqannaasa faqa Anamma maqannaasa faqa Reehaba maqannaasa faqa Nafatuqa maqannaasa faqa ");
INSERT INTO bjr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarusa maqannaasa faqa Kasaru maqannaasa faa Kareetee maqannaasa faqa mariqau. Firistia maqannaasa Kareetee maqannaasakiqari kambiqarausa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kannaana faiqi namu nuqu maaqimminoo marinau. Indaaruqaafa Sidoonafa marinau. Mina aanaaqiannaafa Heetafa marinau. Miqanda nári ninaakusa nuqu marasee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kannaafa Yeebusa maqannaasa faqa Amoora maqannaasa faqa Kirakasa maqannasa faqa ninaakufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hifita maqannaasa faqa Akaa maqannaasa faqa Sinita maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arafada maqannaasa faqa Seemara maqannaasa faqa Qamata maqannaasa faqa mariqau. Kannaa maqannaasa moomoo oosana rainafufaqa aiqama maqa maaqaki daraanimambi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mariufaqa Kannaana saaqari kambiqarausa misa maru maqana dinni ati Sidoona maqusaki marufanoo suani dinni ataaqeenni Keeraa maqusa Kasaa maqusa aaqa maruna raquru aminoo marinau. Miqooqari suani oosana qaannai Soodoomma maqusa faqa Koomoora maqusa faa Adama maqusa faqa Seeboima maqusa Rasaa maqusa aaqa marunnai dinni ati marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Doo Qammana saaqari kambiqarausa naadu naadu maqusakiaqa rainafufaqa naadu naadu ufa qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemmafa Yafeetana afasaafa Heeburu maqannaasa ninaakufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seemana faiqi namu nuqu maaqimminoo marinau. Eerammafa faqa Asurafa faqa Arafakadafa faqa Rudafa faqa Arammafa faqa mariqau. Mi fasiqausa ninaiqimara nári ninaakusa nuqu maree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arammana faiqi namu Qusa maqannaasa faqa Huraa maqannaasa faqa Keeteera maqannaasa faqa Meeseekaa maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arafakadafa Seeraana akoofa marinau. Seeraafa Eebeereena akoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eebeerafa akoonaiqi qaaraqanda maqanau. Indaaruqaana auqu Peereekafa marinau. Mina auqu oosana rainara fee qinoo marinau. Mifa maru aukuanna maqa maaqa rainanoo marufaqa minara Peereekanee qinau. Peereekana akaqa auqu Yookatanafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Yookatana faiqi namukiqari maaqimmasee maqannaasa mariqau. Aramooda maqannaasa faqa Seereefaa maqannaasa faqa Asammafee maqannaasa faqa Yeeraa maqannaasa faqa Adooramma maqannaasa faqa Qusaraa maqannaasa faqa Dikaraa maqannaasa faqa Oobara maqannaasa faqa Abimaeera maqannaasa faqa Seebaa maqannaasa faqa Oofira maqannaasa faqa Qafiraa maqannaasa faqa Yoobabaa maqannaasa faqa mariqau. Aiqamusa Yookatana anaiqimara mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Misa maru maqa maaqafa dinni ati fannoo Meesaa maqa maaqaindari Seefaraa maqa maaqai suani oosana qaannai aaqana maqa maaqa dinni ati fannoo raquru aminoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Seemana faiqi namu miqimmiqa mariqau. Naadu naadu maqa maaqaki maridaqa naadu naadu ufa qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aiqama misauqa Nooanasaaqari kambiqarausa mariqau. Moo maqannaa moo maqannaa nariqa oosana amana kai mariqau. Nammari aufirafa taikafufaqa aiqama maa maqanasaaqaraasa Nooana faiqi namukiqari kai kambiqafi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Indaaru nammari taikoo kamuqoo aiqama maqasaa qaraasa moodaa ufa faqaasa maridaqa moodaa ufa kai qimariqau. Aiqama ainainara moodaa auqu kai ree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Misa suani oosana qaannai oonuree aniree iqa niniufaqa Babiroonia afaasa paqurimmasee miqoo mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Misa miqoo maridaqa maaqi qimasee narí qimami narí qimami qidaqa qiqau. Anifaqa innisaimbaqa maqa qumareeqa atakuseeqa idara saananoo afeekaikamma finaqa minannai maaqa usakaa. Maasa miqimmaseeqa aaku aakummaseeqa koorootaqa mina apootaanaki akusaananoo atukaraani. ");
INSERT INTO bjr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Miqi qimaseeqa maqee innisaimbaqa fuka maqusa indufusee kisaaqa maaqa auqiqa ooru fiinaqa innaaruna amana kai ooruraanaura. Miqimmasee maasa duqu faqaasa moodaanaki maridaqa sia aiqama maqa maaqaki daraanianaura. Miqi qimaseeqa doo miqimmiqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mi maqusana auquseeqa kisaaqa maaqa faqa usakasoofanoo Karaambaiqa qumu nindafeenoo maaqi qinau. ");
INSERT INTO bjr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Maqee maasauqa moodaa maqannaasa maridaqa moodaa ufa qidaqa. Misa nári auqararee qia ainainna oosana araidaqa. Qusasaa misa nári nidimari ainainna auqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Doo anifaqa inni saimbaqa ooquree misa ufa furufaramma nimaqasaanaqa sia narí ufa narí ufa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Anutufa miqi qimasee misa ufa furufaramma nimaqasoofaqa misa mi maqusana auquanee quna minniseeqa maqa maaqaki daraaniqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mi maqusana auqu Babiroonnia fee qimariqau. Miqoo karaambaiqa fannoo misa ufa furufaramma nimaqoonara miqi qimasee auqu raqau. Miqoo maruna Karaambaiqa furufaramma nimaqasoofaqa aiqama maqa maaqaki daraaniqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seemmana saaqari kambiqoosa maaqimmiqa mariqau. Nammari aufirafa taika fufanoo miqooqari qaara aukuana aiqarama fufanoo Seemmafa 100 aukuana maraseenoo akoonaiqi Arafasadana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arafasadana maqooqooqari Seemafa 500 aukuana marinoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arafasadafa 35 aukuana maraseenoo narí faiqi Seeraana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Seeraana maqooqooqari Arafasadafa 403 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Seeraafa 30 aukuana maraseenoo narí faiqi Eebeerana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eebeerana maqooqooqari Seeraafa 403 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eebeerafa 34 aukuana maraseenoo narí faiqi Peereekana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peereekana maqooqooqari Eebeerafa 430 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peereekafa 30 aukuana maraseenoo narí faiqi Reeuna maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reeuna maqooqooqari Peereekafa 209 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reeufa 32 aukuana maraseenoo narí faiqi Seerukana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seerukana maqooqooqari Reeufa 207 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seerukafa 30 aukuana maraseenoo narí faiqi Naqoorana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naqoorana maqooqooqari Seerukafa 200 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naqoorafa 29 aukuana maraseenoo narí faiqi Teeraana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teeraana maqooqooqari Naqoorafa 119 aukuana maraseenoo akoonaiqi maanaaqa moomoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teeraafa 70 aukuana maraseenoo Abarammana faqa Naqoorana faqa Qarana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Teeraana faiqi namu mi oosanausa maaqimmiqa mariqau. Teeraafa Abarammana faqa Naqoorana faqa Qarana faqa nikoofa marinau. Qaranafa Rootana akoofa marinau. * ");
INSERT INTO bjr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Qaranafa Babiroonia maqa maaqaki narí maqusa Uraa maqusaki mina akoofa faqa kaqi marufanoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abarammafa Sarai nammarina maranau. Naqoorafa Mirakaa nammarina maranau. Mirikaa nammarifa Qarana araamuna maranau. Qaranafa Isakana akoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai nammarifa sia faiqi maqoofa aafa anaasee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teeraafa narí amaaku Abarammana faqa Qarana amaaku narí anaiqi Rootana faqa Abarammana anaaqa narí aanaakuqu Sarai nammarina faqa Babiroonia maqa maaqaki Uraa maqusaindari nifiqeenoo Kannaana maqa maaqai fiqau. Teeraafa narí aiku asauku faqa Kannaana maqa maaqai fuanee qimasee Qarana auqu amarana maqusai oonu aana kasaaqai mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Miqoo mariiufanoo Teeraafa miqoo kuqinau. Teeraana aukuana aiqama moodaanaki 205 maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Abarammana akoofa Teeraafa kuqufanoo Karaambaiqa Abarammana qimaminoo qinau. Aneenna maqa faqa aneenna aiku asauku faqa aneenna akoona maqa maaqakinaa ainaina faqa quqasee minniseenana maqa maaqa moo uqafiqaanana miqoo fua. ");
INSERT INTO bjr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Miqoo oonu marinaqa ani faiqi moomoo amiananoo maqa maaqa qumbiqafi marifara. Qinee ani amiqi amiqimma amaqasaanana anee auqu faqaafa marinnaranoo. Miqimma finaqa anisaaqaraa amiqi amiqirana faiqí anaasee mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aniara amiqi amiqi mariasa qinee faqa quandafiqa misa faqa amiqi amiqi ianaura ani aqurarainausa qinee faqa quandafiqa misa faqa niquraraanaura. Aniaroo qimasee misa aiqama maqasaaqaraasa amiqi amiqimma nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abarammafa 75 aukuana maraseenoo Qarana maqusa minniseenoo Kannaana maqa maaqai Karaambaiqa qimamundee inoo fufanoo Rootafa mina faqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abarammafa narí anaaqa Sarai nammarina faqa narí akaqa faiqi Rootana faqa narí moomoo qumiasana ainainira faiqiuqa faqa nifiqeenoo Arana maqasaa mariuna nifiqeenoo Kannaana maqa maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Misa Kannaana maqasaa oonuroofanoo Abarammafa oonuree aniree inoo niniiufanoo Seekeemma maqa maaqaki naaquqara maqusasaa tatufirana suqee maruqoo Mooree maqa maaqaki naaquqara saqari atukaki aniranau. Mi aukuanna Kannaana maqannaasa mi maqa maaqanaki kaqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Abarammafa mi maqusanai oonu marufanoo Karaambaiqa akooqoo mina afusaa kooroomafinoo qimaminau. Qinee maa maqa maaqanara ani qimamunnana ani aiku asauku nimianaura. Miqi qimasoofanoo Abarammafa miqoo mina afusaa kooroou Karaambaiqana tatufirana suqa amira qainda auqusee tatufirana suqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Suqa amiseenoo Abarammafa findifinoo aaqana maqa maaqai ooru finau. Beeteera maqusa fannoo suani keeqoo qaannai marufanoo suani oosana qaannai Ai maqusa marufanoo qambaanai narí uiqaana maqa usakanau. Usakaseenoo miqoo Karaambaiqa aadau tatufira ooni qainda faqa auquseenoo Anutuna aaramaseenoo innaaru qimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Miqinoo faiqanoo fifiiufanoo suani afu dinni ataaqeenni Kannaana maqa maaqa dinni atinni Isipa maqa maaqa oosira qaannai ooquranau. Neekeefa maqasaa ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Miqoo marufanoo aandaroo firaafa Kannaa maqannaasa narinau. Abarammafa mina qafoofanoo mandaikufanoo narí aiku asauku faqa narí ainaina namu faqa Isipa maqasaa ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Isipa maqa maaqa adeedi rama soofanoo Abarammafa narí anaaqa Sarai nammarina qimaminoo qinau. Ani afaaqa amiqirafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isipa maqannaa ani qafamasee, oo mina aanaaqammi maqi qimasee qini darusee ani maree foora. ");
INSERT INTO bjr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Anee aneennara qiniara auna fee qinaqa sia darifaqa anindiri kaqi marianau. ");
INSERT INTO bjr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abarammafa Isipa maqa maaqai aniroofaqa Isipa maqannaasa Sarai nammarina qafamasee boo amiqira fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Isipa maqannaasa rakisirafa Faraoona mina faiqi namu Sarai nammarina qafamaseeqa Faraoona qimamiqa qiqau, qoo amiqira manaaqa fee qufanoo Faraoofa qimannimufaqa Sarai nammarina ani mareeqee Faraoona kinna maaqaki quqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mina akiiqara Faraoofa Abarammana amiqi amiqimmaseenoo sipsipauqa faqa mimmiuqa faqa burimakauqa faqa doonkiuqa faqa kammeerauqa faqa ainainira faiqiuqa faqa maanaaqauqa faqa feefaru Abarammana aminau. ");
INSERT INTO bjr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Faraoofa Sarai nammarina maroonara Karaambaiqa fannoo oosana oosana manda aurirana Faraoona faqa mina maaqaki marusaki faqa quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraoofa mina qafamaseenoo Abarammana aaramaseenoo aqinoo qinau. Anee qini naqaa fee maqimaqeenee. Anee nanaree sia qini qinaaqa fee qimasee qimaqiminanee. ");
INSERT INTO bjr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Anee nanaree qini dauna fee qianaqee qinee qeeqara qinaaqara mareeqee qeeqa maaqaki quqee fee. Maa ani anaaqa marinoo, doo ani afiqee fifua. ");
INSERT INTO bjr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraoofa miqi qimaseenoo narí sundiauqa niqiqoofaqa Abarammana faqa narí anaaqa faqa narí aiqama ainaina faqa nifiqa maree nári maqa atinni munusoofaqa fiqa. ");
INSERT INTO bjr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abarammafa Isipa maqa maaqakiqari suani afu dinni ataaqeendari dinni ataaqeenni Kannaana maqa maaqai qumurandee narí anaaqa faqa Rootana faqa narí aiqama qumiasana faqa maree finau. ");
INSERT INTO bjr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abarammafa ainaina faqaafa marinau. Sipsipa faqa mimmi faqa burimakau faqa siruaa faqa koora faqa faqaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mifa miqooqari quqasee fifiiufanoo Beeteera maqusa amummaqa fimarinau. Mifa ooqai narí Beeteera maqusa faqa Ai maqusa faqa qambaana uiqaana maqa usakaqooqoo ooqu ranau. ");
INSERT INTO bjr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ooqai mifa miqoo tatufira qainda auquqoo ooqureenoo Karaambaiqa innaaru qimamaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Rootafa faqa sipsipauqa faqa mimmiuqa faqa burimakauqa faqa faiqi anaasee faqa narí ainainira faiqiuqa faqa maanaaqauqa faqa Abarammana faqa nimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Miqanda moomoo aandau ainaina faqaaqanda maridaqa aandauqa neemaru andandafa sia amanaikufaqa sia amana moodaanaki mariaqaa inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Miqiqa marufanoo Abarammana aandausaa rakisi marusa faqa Rootana aandausaa rakisi marusa faqa andanda narana saara tinooriqau. Mikari Kannaana maqannaasa faqa Peerisa maqannaasa faqa mi maqanasaa kaqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abarammafa mina qafamaseenoo Rootana qimaminau. Maasa moodaa oosana maridaqa anee faqa qinee faqa sia tinooria, ani faiqi namu faqa qini faiqi namu faqa sia tinooriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Maqa maaqa firaatiamma maridanoo ania, anindiri rainaa, anee aninna aidimari maqana qafamasee utaaqamasee mi tinai finaqa qinee moo tinai fuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Miqi qimasee qimamufanoo Rootafa afu maqaidanoo Yooradanna noopundu dinni marufanoo Sooara maqusa dinni marufanoo mi qambaanna nammari moomoo marinau. Karaambaiqa kadidakiara foora moomoo nammari marinau. Amiqinoo maridanoo Isipa maqa maaqara foora marinau. Mi aukuannai Karaambaiqa Soodoomma maqusa faqa Koomoora maqusa faqa sia naru kammuqoo Rootafa mi maqa maaqana qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Rootafa qafamaseenoo aiqama Yooradanna afaasasaa ooqu mariraree qimaseenoo suani oosanai fimaru aatata finau. Miqi mandeeqara rainaqau. ");
INSERT INTO bjr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abarammafa Kannaana maqa maaqai kaqi marufanoo Rootafa Soodoomma maqusa aaqa maqusauqa dinni dinni marufanoo qambaana noopunduki narí uiqaana maqa usakanau. ");
INSERT INTO bjr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Soodooma maqannaasa kaaqa mandainaina maree marusa maridaqa. Karaambaiqa afusaa oosana oosana mandainaina uqanna auqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Rootafa fifufanoo Karaambaiqa Abarammana qimaminoo qinau, anee mariannaqooqari amiqimmasee aiqama atinai aiuqia. ");
INSERT INTO bjr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Anee qafaanna maqa maaqana ani faqa anisaaqari kambiqainausa faqa nimisaananoo naaruara naaruara innindi kamminoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Qinee ani aiku asauku asumu moomoo kambiqa nimaqaanaura. Sia amana moo fannoo asaana rirana amanaikiannoo. Nukuda aiqama amana asaana rifaranoo, ani faiqi namu kai sia amana nisaana rifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Doo maqee oonuree aiqama maqa maaqa qinee ani amiannana aiuqia. ");
INSERT INTO bjr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abarammafa minara iriseenoo narí uiqaana maaqa rapeemma mareenoo Heebaroona maqa maaqaki Mamareena saqariuqa atukaki ooqureenoo miqoo Karaambaiqa tatufira qainda ooninnai auquseenoo tatufirana suqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mi fasannai Amarafeerafa Babiroonia maqannaa karaambaiqa marinau. Mi aukuannai Eerasaa maqannaa karaambaiqa Ariookafa faqa Eeramma maqannaa karaambaiqa Keedooraoomafa faqa Kooimma maqannaasa karaambaiqa Tidarafa faqa minamusa aiqama nári sundiauqa moodaanaki nifiqeeqa Soodooma maqannaasa narirara fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Misa moodaannai qisauku karaambaiqauqa faqa rakiraree qimaseeqa fiqau. Soodooma maqannaa karaambaiqa Beerana faqa Koomoora maqannaa karaambaiqa Birasana faqa Adama maqannaasa karaambaiqa Sinabana faqa Seeboyima maqusanaasa karaambaiqa Seemeebeerana faqa Beeraa moo auqu Sooara maqanna karaambaiqa faqa mi moodaannai qisauku karaambaiqausa faqa rakiraree qimasee qumiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mi moodaannai qisauku karaambaiqausa rufiasee Sidimma noopunduki suqiqau. Maqee mi noopundunaki ooruku nammari rafaaqa finoo marifaqa mina auqu raidaqa Kuqira Nammari fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Qisaukuqara taikasee qikunni ooqu qaara marasee 12 aukuanaki Keedooraoomana asauku ameemaanai mariqau. Qisaukuqara taikasee qikunni ooqu qaaramoo marasee 13 aukuanaki mina ufa rukiee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","14 aukuannasaa Keedooraoomafa findifinoo aqoonna karaambaiqauqa faqa nári rakira fasiqauqa faqa findifiqa ooqu fiqau. Ooqu fiu faqa moo maqannaasa ooqi naru maree fiqau. Reefaimma maqannaasa Aseetaroota Karanaimma maqusaki nariqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Naruseeqa Susima maqusanaasa Qamma maqa maaqaki faqa nariqau. Naruseeqa Eemimma maqannaa faqa Kiriataimma afaasa maqa maaqaki marusa nariqau. Miqooqari ooquree Qoora maqannaasa Eedoona aaqanasaa marusa nariqau. Misa naru mareeqa Eeraparanna aadana maqa maaqa atinni munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Miqooqari oonu randeeqa Kadeeasa maqusai ooqeenaa auqu Eenamisapatee qimaru maqusaanaasa faqa nariqau. Amareekana aiku asauku misaqa maru maqusausa aiqama rafaaqa fiqau. Rafaaqafusee Amoorana aiku asauku Qasasoona Tamara maqusaki marusa faqa rafaaqafu nimaqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Miqimmasoofaqa Soodooma maqannaa karaambaiqa faqa Koomoora maqannaa karaambaiqa faqa Adamma maqannaa karaambaiqa faqa Seebooyima maqannaa karaambaiqa faqa Beera moo auqu Sooaa maqannaa karaambaiqa faqa mi maqusa namusa karaambaiqauqa faqa nári rakira fasiqauqa faqa moodaaqoo Sidima noopunduki suqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Suqufufaqa Eeramma maqannaa karaambaiqa faqa Kooimma maqannaa karaambaiqa faqa Babiroonia maqannaa karaambaiqa faqa Eerasara maqanna karaambaiqa faqa rakirara deedaqiqau. Moodaanai qisauku karaambaiqauqa qaara faqa qaara faqa karaambaiqauqa faqa rakirara deedaqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidima noopunduki koorootaqa madika moomoo marinau. Soodooma faqa Koomoora maqannaa karaambaiqauqa rakiranakiqari quqasee sandaani quna mi madikausaki aqufiqau. Qaaramoo karaambaiqauqa sanda maqaraasiqa aaqanai akaraqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Qaara faqa qaarafaqa karaambaiqauqa Soodoomma maqannaasa faqa Koomoora maqannaasa faqa aiqama ainaina uqanna maraqau. Afuqakinaa nara ainaina faqa maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Rootafa Abarammana akaqa amaaku fannoo Soodooma maqusai marufaqa mina faqa mina qumiasana faqa maraqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Faiqí moo fannoo rakiranakiqari sandeenoo Abarammafa Qeeburu maqannaa fasiqa fannoo Amoora maqannaa fasiqa Mamareena saqariuqa atukaki marufanoo ooru qimaminau. Mamareefa narí akaqaqara Eesakoorana faqa Aneerana faqa minamusa Abarammana aqoondi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abarammafa Rootana mara maree funara iriseenoo narí ainainira faiqiuqaki nimudaanai qimarusa narí uiqaana maqusakinaasa 318 fasiqa nifiqanau. Nifiqaseenoo qimannimufaqa qaara faqa qaara faqa karaambaiqauqa nifaqamaree Dannaa maqa maaqai nianai fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ooruree namuqaa nindafamaseenoo narí faqa fusa rainaseenoo eendaki namuqaa maruqoo oonureeqa naru nindaqaaqa qiqau. Mifa misa nifaqa maree suani afu dinni ataaqeenni Damasakusa maqusa fiaaqaree Hoobaa maqusaki munusaqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ooru randee qumureeqa Abarammafa Rootana faqa mina qumiasana faqa aiqama aanaaseeuqa faqa rumbee fusauqa faqa aiqama nifiqee aniqau. ");
INSERT INTO bjr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abarammafa Keedooraoommana faqa mina aqoonna karaambaiqauqa faqa naruseenoo aniroofanoo Soodooma maqanna karaambaiqa fannoo mina qafarara Saavee noopunduki moo auqu Kinna noopunduki fee qimaruqoo paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Sareema maqannaasa karaambaiqa auqu Meerakiseedeekafa uriqarara Anutuna aanaiqikirafa marufa feemu faqa uainna nammari faqa Abarammana mini aminau. ");
INSERT INTO bjr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Meerakiseedeekafa amiseenoo maaqi qimaseenoo amiqi amiqira ufa qimamaqanau. Uriqarara Anutufa innaaruna faqa maqa faqa auqufa mifa kai Abarammana amiqi amiqiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kaaqa uriqarara Anutufa kai namuqaa mareeqee ani asaukuki quqeenoo miqinara Anutuna amoo qiaqa. Miqi qimasee amiqi amiqira ufa qimasoofanoo Abarammafa namuqaa ainaina maraqoona qisaukuqaraki rainaseenoo moodaaki Meereekiseedeekana aminau. ");
INSERT INTO bjr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Amisoofanoo Soodooma maqannaa karaambaiqa Abarammana qimaminoo qinau. Anee rakiranaki maraanna ainainausa aneennara mareenana qini faiqí anaasee kai qimia. ");
INSERT INTO bjr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Miqi qufanoo Abarammafa asauku uqeeraseenoo qinau. Qeeqa qisauku uqeereeqa, kaaqa uriqarara Anutuna innaaruna faqa maqa faqa auquna afusaa uqeerasee qimamidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Sia uqanna ani ainaina kaqikaa ainaina maraanaura tirita faqa niku aanaamu sanda faqa ririmma sia maraanaura. Anee qiniara maasa ainaina maraseenoo moomoo ainaina faqaasee qidanoo mifoo qinoora. Sia uqanna maraanaura. ");
INSERT INTO bjr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Qinee sia uqanna moo ainaina qeeqara maraanaura. Qini faqa rakiranaki fuasa misa namasaa ainainnara kai doo maree fee qidaqa. Qini qiqoodi namu Aneerafa faqa Eesakoorafa faqa Mamareefa faqa misa kai nári nimanasaa maraaqa. ");
INSERT INTO bjr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Rakirana taikaseenoo marufanoo Yaaweefa Abarammana afu pisipasa mandeenoo qimaminau. Abaramma anee sia rufiaa. Qinee ani saqariara foora anisaa ititafuananoo sia moo fannoo ani aruannoo. Qinee mina akiiqara firaa ainaina ani amianaura. ");
INSERT INTO bjr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abarammafa mi ufana iriseenoo narí qimaminoo qinau. Oo uriqarara karaambaiqa anee nana qumiasanee qini qiminnaree qinee faiqi siaisa maridaqa. Maa qini ainainira faiqi auqu Eerieseerafa Damaskusa maqusaindaraafa mifa kai maridanoo qinee kuquananoo qini ainaina maraannoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Anee faiqi asumu sia qini qimiananoo qini ainainira faiqi uqakiqari moo fannoo qini qumiasana maraannoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Miqi qimaseenoo Abarammafa irufanoo kafaa Karaambaiqa qimaminoo qinau. Maa ani ainainira faiqi Eerieseerafa sia ani qumiasana ainaina maraannoo. Aninna faiqi uqanna fannoo ani ainaina maraannoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Miqi qimaseenoo Karaambaiqa Abarammana afiqee madaanai muquseenoo qinau. Innaarunai qafamaseenana fasau amanee anee asaana rinnaree. Aniki ani aruakinausa miqimmasee kambiqeefara. ");
INSERT INTO bjr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abarammafa Yaaweena mi ufana iriseenoo narí saqarikirana mi ufanasaa rusisee marinau. Miqunara Karaambaiqa asasammaseenoo Abarammana mareeqee narí aqoondikiranaki quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Miqi qimasee Karaambaiqa Abarammana qimaminoo qinau, qinee Karaambaiqa ani Ura maqusakinaana Babiroonia maqa maaqaindaraana afiqee minisee maa maqa maaqana amiananoo anindikianifee qimasee afiqee aniqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Miqi qufanoo Abarammafa iramirinoo qinau. Oo uriqarara Karaambaiqa qinee naqi fee masee qinindi kammiannoo fee qimasee irianauree. ");
INSERT INTO bjr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Miqi qufanoo Karaambaiqa narí qimaminoo qinau. Anee burimakau faqa mimmi faqa sipsipa faqa qaaramoo aukuana mararausa faqa nakipuruna faqa kukuma faqa maree mini qimia. ");
INSERT INTO bjr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Miqi qimasoofanoo Abarammafa mi aandausa Anutufa maruqoo maree mini quqaseenoo minauqa qambaana kai afoommaseenoo dinni moo afooirana dinni moo afooirana qaaramau irasasaa quqanau. Ufiniqara kai sia afooinau. ");
INSERT INTO bjr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Meemoonauqa mi aandausa narara aniroofanoo Abarammafa niiqaaqinau. ");
INSERT INTO bjr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Suani keeqarana namu faqa eenoofanoo Abarammafa afuki qaunduarufanoo faiqaqeeidanoo qaini marufanoo firaa rufiarafa faqa maparaairafa faqa Abarammana afaaqai aqufinau. ");
INSERT INTO bjr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Miqida rufiee marufanoo Karaambaiqa Abarammana qimaminoo qinau. Anisaaqari kambiqainausa aanaamuruara foora moo maqannaasa maqasaa oonu maridaqa ainainira faiqikiqa marifaqa 400 aukuanaki manda fitiqnarana nimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Miqi marifaqa qinee mi maqannaasa mi fitiqnarana nimimariana akiiqara aupurarana nimianaura. Misa mi maqa maaqana minnisee oonurandee aniqa moomoo qumiasana maree anifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Aniara maaqi qiqa anee asooaqeenana asooaranaki kuqufinaqa akundaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ani aiku asauku qaara faqa qaara faqa oosana mi rumbaranakiqari oonu randee anifaranoo. Qinee sia Amoora maqannaasa dauni naru taikaanaura. Misa kaaqa mandaika uqanna ifaqa miqoo misa naru nindaqaaqa masee ani aiku asauku miqoo quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Suani keeqoofanoo eendirara mammandufanoo Abarammafa qafoofanoo qafeeki idamuna namu faqa qooma namu faqa akooqoo narí kai kambiqafinoo aandau afoomma dinni dinni quqaqoona qambaana runna finau. ");
INSERT INTO bjr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Doo aaqee mikari kai Yaaweefa Abarammana faqa moodaanaki kira ufa qinau. Qinee maa maqa maaqana ani aiku asauku nimianauranoo. Isipa maqannaa nammari dinni oosirafa ani rameeqeenoo firaa nammari dinni Eeufarateesa nammari mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Keenaa maqusanaasa maqa faqa Keennisa maqusanaasa maqa faqa Koodamoona maqusanaasa maqa faqa Qeeta maqusanaasa maqa faqa Peerisa maqusanaasa maqa faqa Reefaimma maqusanaasa maqa faqa Amoora maqusanaasa maqa faqa Kannaana maqusanaasa maqa faqa Kirakasa maqusanaasa maqa faqa Yeebusa maqusanaasa maqa faqa miqimmasee maqannaasa maqa faqa ani aiku asauku nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abarammana anaaqa Sarai nammarifa mifa qaafa anaasee marinau, sia faiqi maqanau. Mina ainainira maanaaqa Isipa maqannaa maanaaqa marinau. Mina auqu Qakaara nammarifa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarai nammarifa nári oosana maraseenoo Abarammana qimaminoo qinau, anee iria, Anutufa sia faiqi qini qiminoo. Minara maa qini ainainira maanaaqa mara sainanoo mifa ani faqa finoo aqbee faiqi maqa sainaqa qinee qeeqara maraanaura. Miqi qufanoo Abarammafa eedoo qimaseenoo maranau. ");
INSERT INTO bjr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abarammafa qisaukuqara taikasee aukuana Kannaana maqa maaqai marufanoo Sarai nammarifa narí ainainira maanaaqa Qakaara nammarina Abarammana aminau. ");
INSERT INTO bjr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abarammafa Qakaara nammarina faqa aana fufanoo faiqi maranau. Qakaara nammarifa amuaquqaika mafufanoo nasuridanoo narí aqoonnana Sarai nammarina ramoo ramaa ira ufa qimamaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Miqufanoo Sarai nammarifa Abarammana qimaminoo qinau. Ani oosanasaa Qakaara nammarifa qini fidiaqaamma qimaqaidanoo. Qinee qeeqa kai mina ani amisaafananoo amuaquqaika mafinoo qini uridaaqa raidanoo. Karaambaiqa fannoo kai anindiri ufa rainaannoo. Anee fee, qinee fee andeeqee fee. ");
INSERT INTO bjr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abarammafa kafaa narí qimaminoo qinau. Doo amana ani ainainira maanaaqa ani ameemaanai maridanoo. Naqaamma amaqararee fee qimasee iridanee, doo miqia. Sarai nammarifa Akaara nammarina maqee maqee oofana qaidanoo ari aqimarunara quqasee sandanau. ");
INSERT INTO bjr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Qakaara nammarifa amaaqa firaree qimasee Suraa maqa maaqaki fimaru aatata sandee fifiiufanoo aadana maqa maaqa qambaanai nammari kaqikaafa ururee maruqoo Karaambaiqa angiroo fannoo Qakaara nammarina paqurimmasee qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Qakaara nammari, Sarai nammarina ainainira maanaaqa, anee yaindari fee anidanee maaqooqari yai fee fidanee. Miqi qufanoo Qakaara nammarifa qinau, qeeqa rakisirana Sarai nammarina aaqu rufiee sandaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Angiroo fannoo minara iriseenoo maaqi qimasee qimaminau, doo findi finana aneenna rakisira anaasee marinnai kafaa anirandee oonureenana mina ainainira manaaqaikia. ");
INSERT INTO bjr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Angiroo fannoo kafaa qimaminoo qinau. Qinee moomoo asumu ani amianaqa sia amana asaana rifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Maqee ani aranandaki faiqi rinoo anee akoonaiqi maqeennaranoo anee mina auqu Isamaeera nee qia. Karaambaiqa fannoo anee aupuraranakiqari mina aaramasee faaqa ruannana irinara minara mi faiqina auqu Isamaeera nee qia. ");
INSERT INTO bjr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mi faiqifa kaasau fainiara foora mariannoo. Mifa aiqamausa namuqaakamma nimaqainaqa misa faqa narí namuqaakamma amaqeefaranoo. Mifa narí ainaina rakeemasee aaduma mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Qakaara nammarifa narí kai qimirinoo qinau. Qinee kuqaa fee Anutuna qafamasee fee sia kuqirai kaqi maridee qimannimianauree. Miqi qimasee mina qimamu karaambaiqanara niqafee mari Anutu fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Miqooqari misa mi nammari dikaandana auqu reeqa kaqi marira Anutufa qini qiqafai nammari dikaanda fee qiqau. Mi nammari dikaandafa Kadeesa maqusa dinni Beereeda maqusa dinni qambaana marinau. ");
INSERT INTO bjr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Qakaara nammarifa kafaa anirandee oonureenoo faiqi maqasoofanoo Abarammafa mina auqu Isamaeera nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Mi aukuanna Abarammafa 86 aukuana faqaafa marufanoo mina faiqi kambiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abarammafa mariufanoo 99 aukuana marasoofanoo Karaambaiqa mina afusa kooroo mafi qimaminau. Qinee aiqama afeeka faqaa Anutusa maridaqa. Anee aiqama kari qini ufa qaindusidana andeeqara ainaina kai auqaa. ");
INSERT INTO bjr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Qinee ani faqa qeeqa moodaanaki kira ufa qimasee anisaaqari asumu moomoo kambiqa nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abarammafa mi ufana iriseenoo oorindari maqasaa mapamufufanoo Anutufa maaqi qimasee qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Qinee maa moodaanaki kira ufana ani faqa qidaqa. Qinee kuqaa qima afeekaikidaqa. Anee moomoo maqannaasa ninaakufa marinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Doo maqee ani auqu Abarammafa marina maqee fuka auqu amiqa. Abaraqaammanee qianaura. Qinee ani moomoo maqannaa ninaakufaika maisaannanara ani auqu Abaraqaammanee qianaura. ");
INSERT INTO bjr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Qinee ani faiqi asumu moomoo amianaqa misakiqari akaqausa karaambaiqa marifara. Ani asaifaqausa moomoo maridaqa moomoo maqannaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Qinee qeeqa qima afeekaikira ufa ani faqa ani asaifaqausa naaru kambiqainausa faqa qiafannana naaru marira moodaanaki kira ufara foora rakisianaura. Qinee ani faqa ani asaifaqausa Anutusa marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Anee asaqiraa faira foora maa maqanasaa mariannana qinee ani faqa ani asaifaqausa faqa nimianaura. Nimiananoo aiqama Kannaana maqa maaqa fannoo ani asaifaqausaindi kamminoo naaru naaru marinaqa qinee misa Anutusa marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Miqi qimaseenoo Anutufa kaifaa Abaraqaammana qimaminoo qinau. Anee faqa eedoo qimasee qini qima afeekai kira ufamau aneenna asaifaqausa naaru kambiqainausa faqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Anee faqa ani asaifaqausamara faqa aiqama eedoo qimasee akoonaiqi faiqiuqa nifaaqa ati aukuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Maaqooqari aiqama akoonaiqi faiqiuqa maqasaifanoo 8 faasaana aiqaramafinaqa nifaaqa ati aukuaqa. Ainainira faiqiuqa inniki mariasa faiqi namu faqa nianaindaraasa feefaurumma quqaqaafaqa inniki mariasa faiqi namu faqa nifaaqa ati aukuaqa. Miqimmasaifanoo mifa qinee faqa innee faqa moodaanaki kirana uqannifiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Aiqama uqanna nifaaqa ati aukuaqa. Aukusaifanoo mifa inni nifaaqai qini moodaanaki kira ufa naaruara marianinnanara koorooiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Inniki qari akoonaiqi moo fannoo sia afaaqa ati aukinafa marinaqa sia qini faiqí aanaaseeki mariannoo fee qianaura. Mifa qini qima afeekaikira ufamau sia finara sia inniki mariani. ");
INSERT INTO bjr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kafaa Anutufa Abaraqaammana qimaminoo qinau, sia aneenna aanaaqara Sarai nammarinee qia. Maqee mina auqa Saraqa nammarifa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Qinee Saraqa nammarina amiqi amiqi maisaananoo faiqi akoonaiqi ani maqa amiannoo. Mifa moomoo maqannaasa ninoofa marinaqa mina faiqi namukiqari akaqausa karaambaiqauqa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abaraqaammafa mi ufana iriseenoo maqasaa mapamu finoo naanaidara qidanoo qinau. Amanee 100 aukuana marara fasiqa fannoo faiqi maqaannoo fee Saraqa nammarifa faqa 90 aukuana mararafa amanee faiqi maqaannoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Miqi qimaseenoo Abaraqammafa Anutuna qimaminoo qinau. Naqaa saina Isamaeerafa qini ainaina maraaqaana ifanee. ");
INSERT INTO bjr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Miqi qufanoo Anutufa qimaminoo qinau. Ani anaaqa Saraqa nammarifa ani faiqi akoonaiqi maqasainana mina auqu Isakee nee qia. (Maasa ufakiqari Isakeena auqu naanaidara qiranee qimaqoofanoo.) Qinee ani faqa moodaanaki kira ufa quqaunafa Isakeenasaa faqa minasaaqari naaru naaru kambiqainausasaa faqa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isamaeerana faqa anee qianandee, mina faqa amiqi amiqi ianaura. Mina faiqi namu moomoo uqanna kambiqeefara. Akoonaiqiuqa qisauku qara taikasee qikunni ooqu qaaraqanda 12 marasee uriqararausa marifara. Mina saaqari kambiqainausa firaa maqannaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Moo aukuana maa quqoonnanasaa kai Saraqa nammarifa ani faiqi Isakeena maqannoo. Qinee qeeqa moodaanaki kira ufa minasaa quqaqaana mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Anutufa aiqama maa ufana Abaraqaammana qimamiseenoo doo quqasee finau. ");
INSERT INTO bjr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Fifufanoo Abaraqaammafa Anutuna ufa mau finoo mi faasaanna kai narí faqa narí amaaku Isamaeerana faqa narí ainainira faiqiuqa faqa narí ainainiranaki marida maqaqoo faiqisa faqa aiqama nifaaqa ati aukinau. ");
INSERT INTO bjr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abaraqaammafa 99 aukuana marinoo narí afaaqa ati ateeka aqinau. Isamaeerafa 13 aukuana marasoofanoo mina afaaqa ati ateeka aqinau. ");
INSERT INTO bjr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Moodaa faasaana kai Abaraqaammafa faqa narí amaaku Isamaeerafa faqa narí ainainira faiqiuqa aiqama nifaqa ati ateekaqau. ");
INSERT INTO bjr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abaraqaammafa Mamareena arookasa atukaki suani qambaanai aiqaiqa ufanoo narí uiqaana maqa kooqiki ooqu faaqee marufanoo karaambaiqa maaqimmasee mina afusaa kooroo inau. ");
INSERT INTO bjr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ooqufaaqee marufaqa faiqí qaaramoo namu anufanoo Abaraqaammafa niqafamaseenoo nári oosana mareenoo findimeeqeenoo misa anuqoo sandee oonureenoo oorindari maqasaa kummarama finoo qimanniminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Oo uriqararausa, qinee inni dadaaqirausa maridaqa sia qini aidaaqa raaqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Qinee qianaqa nammari minisaifaqa inneeqa niku nammari uqu seeqa maa saqarina atukaki adooaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Qinee akaqa narana nimiana namaseeqa afeeka mara mareeqa fuaqa. Qinee inni dadaaqianeera maaqoo aniafanoo. Innee mai anianannai qini duqu uqeeraafanoo. Minara eedoo qifaqa narana nimia. Miqi qufaqa misa qiqau. Dufi dufi doo nimina naanee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abaraqaammafa iriseenoo uiqaa maaqaki sandeenoo oonureenoo Saraqa nammarina qimaminau. Anee kai kaqi parauaqa amiqirana moodaa beeka marasee feemu suqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Miqi qimaseenoo raudamaki sandeenoo burimakau maruqoo oonureenoo burimakau aanaaqi amiqirana amaqi qumooqu kirana mara rumba mareenoo narí ainainira faiqi amisoofanoo kai kaqi ufanoo arusee suqanau. ");
INSERT INTO bjr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abaraqaammafa burimakau naamma anoona faqa naamma anoona fadameena faqa feemu faqa burimakau suqarana faqa mara maree mini nimufaqa naqau. Abaraqaammafa saqari atukaki misa faqa maridanoo narana nimufaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Misa namaseeqa Abaraqaammana maaqi qimasee iraqau. Ani anaaqa Saraqa nammarifa yai fee marinoo fee qufanoo mifa qinau. Maa uiqaana maqaki maridanoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Miqi qufanoo misakiqari moo fannoo qinau. Moo aukuana maa quqoonnanasaa kai qinee kafaa aniraananoo ani anaaqa Saraqa nammarifa akoonaiqi faiqi maqaannoo. Miqi qimarufanoo Saraqa nammarifa uiqaana maqa kooqiki mi fasiqana aanaaqiannai ooqu faaqee idanoo irimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Miqi qufanoo Saraqa nammarisa Abaraqaamasa asooqa uqanna marufanoo Saraqa nammarifa faqa faiqi maqara aukuana ooqai taikanau. ");
INSERT INTO bjr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saraqa nammarifa minara iriseenoo narí kai naanaidara qidanoo qinau. Qinee faqa qeeqa nauraiqindiri asooqa marida. Naqimmasee fee qeeqa qifaaqi faqa aana fuanauree. ");
INSERT INTO bjr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Miqufanoo karaambaiqa Abaraqaammana qimaminoo qinau. Naqaa fee ifanoo fee Saraqa nammarifa naanaidara qinoo fee. Maana qinee asooqa maridaqa naqimandee faiqi maqaanauree qinoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nana ainainee moo ainaina Yaaweefa sia amana auqaannoo fee mifa amana aiqama ainaina auqaannoo. Qinee anoona ufa qidaqa, moo aukuana maa quqoonnasaa qinee kafaa aniraananoo Saraqa nammarifa akoonaiqi faiqi maqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saraqa nammarifa mina iriseenoo rufia mareennoo unna qimasee qaoo qinau, Qinee sia naanaidara qiqa. Miqi qufanoo misa uriqararafa Karaambaiqa qimaminoo qinau. Anee naanaidara qianaqa iriqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","17","Mi fasiqa qaaramoo namusa Abaraqaammana faqa ooqu fiufaqa Soodooma maqusai qafee maruqoo muqunnisoofanoo Karaambaiqa narí kai qimasee irinau. Qinee auqararee qunna ainaina sia Abaraqaammana umeerama amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Mina saaqari kambiqainausa firaa maqannaa marifaranoo. Aiqama maqannaasa Abaraqaammana saaqaraanannai amiqi amiqimma nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Abaraqaammafa narí faiqi namu faqa misasaaqari kambiqainausara faqa andeeqara oosanamau kai fuaqeera fuki faaki ianifeera rusandeesamummasee maraqiafana. Misa miqi faqa qinee qima afeekaikiafanna ainainausa aiqama miqimma nisaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Miqi qimiriseenoo Yaaweefa Abaraqaammana akooqoo kooroommasee qimaminau. Soodoomma maqusanaasa faqa Koomoora maqusanaasa faqa manda oosana fiqaranoo marifaqa akaqausa minara nikoo uqanna qaifaqa qimaqimiafaqa iriqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Qinee ooqureeqa mi fasiqa anaaseesa mi oosanna auqee mariana qafaanaura kuqaa fee unna fee maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mi qaaramoo fasiqa namusakiqari qaara qanda Soodoomma maqusai ooqu fimarufanoo Karaambaiqa Abaraqaammana faqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abaraqaammafa Karaambaiqa oorinni oonu reenoo iramirinoo qinau. Kuqaa fee anee andeeqarausa faqa aaqee mariasa faqa aiqamee naru taikeennaree. ");
INSERT INTO bjr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Qaara fasiqa niku nisauku taikasee qini qisauku qara taikasee 50 andeeqarausa mi maqusanaki marifana anee aiqamee naru taikeennaree. Kafaa 50 andeeqarausa marifana mi maqusana asumu quqeennaree. ");
INSERT INTO bjr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Sia amana andeeqarausa faqa mandaikirausa faqa moodaanaki narinnaranoo. Mifa sia andeeqanoo maridanoo. Andeeqarausa faqa aaqee mariasa faqa sia amana moodaa oosana kai niminnaranoo. Aiqama maa maqanasaa mariasa siaasa marianafa andeeqara oosana kai maraa. ");
INSERT INTO bjr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Karaambaiqa Abaraqaammana ufa iriseenoo qimaminau. Qinee qaara fasiqa niku nisauku taikasee qini qisauku qara taikasee 50 andeeqarausa mi maqusanaki paquriqa sia mi maqusana kuridianaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abaraqaammafa mina iriseenoo kafaa qimaminau. Oo karaambaiqa qinee qifaaqa quqasee ani qimamunna ufana mi numoona minni qisaa. Qinee faiqí faiqi maridaqa aaqamammasee ani faqa moomoo kari ufa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Amanee 50 sia marifana 45 kai andeeqarausa marifana moodaannai qisauku 5 minaki sia marinnanara irisee narinnaree. Karaambaiqa narí qimaminoo qinau. 45 andeeqarausa mi maqusanaki marifaqa sia kuridi taikaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abaraqaammafa mina iriseenoo kafaa qimaminau. Oo karaambaiqa qaara fasiqa niku nisauku taikasee 40 andeeqarausa marifana aiqama narinnaree. Karaambaiqa mina iriseenoo qimaminau. Qinee qaara fasiqa niku nisauku taikasee 40 andeeqarausa paquriqa mi maqusana sia kuridianaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abaraqaammafa iriseenoo kafaa Karaambaiqa qimaminau. Qinee kaifaa ani qimamianana anee sia qiniara aanoo qia. Moodaa fasiqa aiku asauku taikasee qini qisauku qara taikasee 30 andeeqarausa marifana naqaa fee innaree. Yaaweefa iriseenoo qinau. Qinee 30 andeeqarausa paquriqa sia miqianaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abaraqaammafa kafaa qimaminau. Qinee qifaaqa quqasee ani faqa moomoo ufa qimarunnana mi numoona minni qisaa. Mi maqusanaki moodaa fasiqa 20 kai marifana naqaa fee innaree. Karaambaiqa iriseenoo qinau. Qinee 20 andeeqarausa paquriqa sia mi maqusana kuridianaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abaraqaammafa kaifaa qinau. Oo karaambaiqa sia aanoo qia. Qinee moo ufa kafaa qianaura. 10 andeeqarausa paqurimasee naqi fee innaree. Miqi qufanoo Karaambaiqa qinau. Qinee qisauku qara 10 kai andeeqarausa paquri mandee sia kuridi nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Karaambaiqa Abaraqaammana faqa ufa qimaseenoo doo ooqu finau. Ooqu fufanoo Abraqaammafa quqasee anirandee amaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Abaraqaammafa muqunnisoo qangirooqanda Soodoomma maqusai ooquree maqusa kooqiki qafoofanoo Rootafa miqoo ooqu faaqee marinau. Maridanoo Rootafa miqanda nindafeenoo maqeenoo oonu miqanda noorinni oorindari maqasaa rupaitama fufanoo maaqi qimasee qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Oo qini uriqarara qanda qinee inniqara dadaaqirara maridaqa. Innee qara qini maaqaki aniree niku nammari uqusee qini maaqaki faiqaaqa. Faiqee duna kananaana findi finaqa inneeqa finnannai fuaqa. Miqi qimasoofaqa miqanda qaoo qida qiqau. Saina maa qanda maqusa qambaana faiqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Rootafa sandanainai qimaseenoo ufaqa miqanda mina faqa maaqaki keeqaqau. Ooru roofanoo Rootafa narí ainainira faiqiuqara qufaqa misa ooruku anoona sia qai feemuna faqa amiqira narana faqa suqasee nimufaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Namaseeqa faiqarara imarufaqa mi maqusaanaasa faiqí kumaaraa nauraiqi aiqama aniree Rootana maaqa fuseemma dati mambufaqa Rootana maaqi qimasee aaraqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mi faiqi qanda faasai ani maaqaki keeqaa qanda yai fee maridaqee. Anee miqanda maasa qiminaqa mi qanda manda oosana nimia. ");
INSERT INTO bjr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Rootafa misa ufa iriseenoo rauda mafinoo narí aanaaqianaindari kooqi ititasee qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Qinee qaoo qira ufa inni qimannimidaqa. Sia uqanna maa manda oosanna maraaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Iriaqa, qeeqa qiraamuna qaara qanda sia faiqí faqa nuaqanda inni nimisaanaqa inneeqa iriranannai kai maraaqa. Maa fasiqa qanda qini maaqaki ani raafaqa aqoondi kammaqauna mariafaqa qinee amiqimmasee miqandasaa rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Miqi qimasee qimannimisoofaqa misa aiqama maaqi qiqau. Anee moo maqannaafa maasaki ani marianafa. Yafee qifanee anee maasara qaoo qidanee. Anee nimaaraa. Sia nimaarainaqa sia ani aqoondiqara kai mandaikamma nimaqaanaura, ani faqa firaaqoo mandaikamma amaqaanaura. Miqi qimaseeqa misa Rootana afeeqa aquseeqa mina kooqi rufadaairara iqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Maaqakiqari Rootana aqoondiqara Rootana qumu rarisameeqee maaqaki aqusee kooqi ititaqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ititaseeqa mi fasiqausa madaanai marusa aiqama nifu qimbasoofaqa kooqiara randoosia minnisaqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Minni soofaqa Rootana aqoondi qara iramiriqa qiqau. Maa anee marianna maqusanaki ani ati akaqausa maridee. Kai kaqi aneenna araamuqmaaka faqa airaamaku oondamara faqa aneenna atiuqa faqa aiqama nifiqee moosaa fua. ");
INSERT INTO bjr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Maasa maa maqusana damunamma aquanaura. Karaambaiqa maa maqusanakina oosana oosana mandainaina kambiqaifanoo mi ufana iriseenoo maaqanda diqiqaifaqa maa maqusana kuridirara qumidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Rootafa iriseenoo narí araamuna qara nifaaqi qarara qutaaqamaqoo fasiqa qanda faqa qimanniminau. Doo anifaqa innisaimbaqa mootinai fuaqa. Anutufa maa maqusana damunirara qinoo. Miqi qufaqa mina airaamaku qara sia iriqau. Quteeti qidanoo mifoo qimasee kaqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Iaqoo faqa kananaana angirooqara Rootana kafaa fuki faaki qiqau. Doo kai kaqinana aneenna anaaqa faqa aneenna araamuna qara faqa nifiqee fua. Innee faqa maa maqusana namu faqa kuridifaara. ");
INSERT INTO bjr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Rootafa iriseenoo oonauqee anauqee imarufanoo mina aqoondiqara mina asauku faqa mina anaaqa asauku faqa mina araamunaqara faqa qumaree rarisameeqee aanai ubeekaqau. Yaaweefa Rootanara amuqusufanoo miqinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nifiqa quqasoofanoo angiroo moo fannoo qimanniminoo qinau. Innee sandamafuaqa kuqifaara. Fidaqa sia quandafi qafaaqa. Afaasasaa faqa sia kasooiaqa. Innee kuqifaara, aaqanai sandee ooru fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Rootafa iriseenoo maaqi qimasee qimaminau. Sia aneenna qiannannai diiqaa. ");
INSERT INTO bjr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Anee firaqoo qiniara amuqusifana qini kuqiranakinaana maraananoo. Aaqana nianai marifaqa minni fimariananoo mi narirafa qini faqa darinaqa kuquanoora. ");
INSERT INTO bjr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Anee kaqikaa maqusa muqunni qafaidanee. Mifa adeedi marifaqa amanee qinee minni sandaanauree. Kaqikaa maqusa uqanna maridanoo qinee minni oonureeqa asumu marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Miqi qimasoofanoo angiroo moo fannoo qimaminau. Doo amana qinee minara eedoo qidaqa. Sia qinee mi maqusana kuridianaura. ");
INSERT INTO bjr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Doo kai kaqi sandaa. Anee oonu rainaqa miqoo qeeqa qunna ainaina auqaanaura. Rootafa mi maqusanara kaqikaa maqusee qunara misa mi maqusana auqu Sooara fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mi kananaanna suani afu maqee uri marufanoo Rootafa Sooara maqusai oonu ranau. ");
INSERT INTO bjr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Oonuroofanoo Karaambaiqa ida namu faqa koorootaqasaaqari qeemari idanara foora irana namufaqa quqasoofanoo aakuara foora Soodoomma maqusasaa faqa Koomoora maqusasaa faqa aqufinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Aqufinoo mi arumunaki maru maqusausa faqa aiqama faiqí anaasee faqa andanda faqa naru taikanau. ");
INSERT INTO bjr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Rootana anaaqa narí afaaqi faqa sandee fidanoo oonu quandafinoo afu maqeenoo doo miqoo ooruku kammafi kisaaqa saqariara foora rakiqanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Moo kananaana Abaraqaammafa findimeeqeenoo Karaambaiqa faqa ufa quqoo ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Miqooqari Abaraqaammafa mara muami qafoofanoo Soodoomma faqa Koomoora faqa mi afaasanasaa maru maqusausaki ida muna fannoo firaafa uqanna ooru fufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Anutufa mi afaasanasaa maru maqusausa faqa maqa maaqa faqa kurididanoo Abaraqaammanara iriseenoo Rootafa mariu maqusausa naridanoo Rootana kai mareeqee kaqinni quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Rootafa Sooara maqusara rufiaseenoo narí araamuna qara nifiqeenoo amuaqu namusaa ooni aamara marunaki ooru marinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mariufanoo mina araamuna indaaruqaafa inaaqianaana maaqi qimasee qimaminau. Doo maasa qikoofa asooqa maridanoo. Sia maa saqanna anindiri marasee faiqi mara qimifaqa maqara fasiqauqa maridaqa. Aiqama faiqí auqeeu oosanafa sia anindiriki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Doo aninaqa anindiri uainna nammari auquseeqa nári nikoona amiananoo moomoo namaseenoo furu farinaqa anindiri mina faqa sakasee faiqaa. Miqi masaifanoo anindiri nikoofa anindiri faiqi mara qiminaqa anindiri faiqi namu findifiqa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Miqi qimaseeqa mi eendanaki miqanda uainna nammari moomoo nári nikoona amisoofanoo neeneeseenoo furufara masoofanoo anasaafa naaree narí akoona faqa sakasee faiqanau. Uainna nammari fannoo mina furu fara masoofanoo narí araamuna auqoo ainainara sia irinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kananaana anasaafa narí auna qimaminoo qinau. Faasai eendaki qinee qeeqa qikoona faqa sakasee faiqeeqa. Doo fafaa eendaki anindiri uainna moomoo kaifaa amiananoo namaseenoo furu farinana anee faqa mina sakasee faiqaa. Miqimasee aninidiri qeeqa qikoona faiqi maqasaana faiqí asumu kaqi mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Miqi qimasee doo mi eendanaki miqanda uainna nammari moomoo nári nikoona amisoofanoo furu faramma soofanoo auna fannoo narí akoona faqa sakaseenoo faiqanau. Rootafa uainna nammari namseenoo furu faridanoo narí araamuna auqoo ainainara sia irinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Miqimmasee Rootana araamuna qara nári nikoona faqa faiqoonannai nimuaqu qaikiqau. ");
INSERT INTO bjr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Miqimasee marufanoo indaaruqaa araamana fannoo faiqi akoonaiqi maqaseenoo mina auqu Mooaba nee qinau. Mariu fanoo Mooabafa findifinoo Mooaba maqannaasa nikoofaikamminoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Auna fannoo mifa faqa faiqi akoonaiqi maqaseenoo mina auqu Beenaami fee qinau. Mariu fanoo Beenaamifa findifinoo Amoona maqannaasa nikoofaikamminoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abaraqaammafa Mamareena maqusa minni seenoo Neekeefa maqa maaqakina ooqu finau. Mifa Kadeesa maqusa dinni Sura maqausa dinni qambaana ooqu marinau. Marikinoo kafaa Keeraara maqusaki ooqu marinau. ");
INSERT INTO bjr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Keeraara maqusaki kaqi maridanoo Abaraqaammafa narí aanaaqara Saraqa nammarinara qini dauna fee qinau. Keeraara maqannaa karaambaiqa mina auqu Abimeereekafa marinau. Mifa Abaraqaammana ufa iriseenoo Saraqa nammarinara mina auna fee qimaseenoo narí ainainira faiqiuqa niqiqoofaqa Saraqa nammarina mareeqeeqa Abimeereekana amiqau. ");
INSERT INTO bjr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Miqoo marufanoo Anutufa Abimeereekana qaina saa kooroo qimasee qimaminau. Anee kuqinnaranoo maa anaaseena anee maraannana moo fasiqa anaaqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeereekafa Saraqa nammarina sia sakasee faiqanau. Minara iriseenoo Anutuna qimaminoo qinau. Oo karaambaiqa qinee andeeqarausa maridaqa anee qini faqa qini faiqí anaasee faqee narinnaree. ");
INSERT INTO bjr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abaraqaammafa narí kai Saraqa nammarinara qini dauna fee qifaqa qinee iriqa. Kafaa maa anaaseefa faqa narí afaaqiara qinoo qini qifasaa fee qinoo. Miqi qifaqa qinee mina irunanoo qini daakirafa qimaqiminoo sia aaqarafa aniki mariannoo fee qifaqa maraunanoo sia aaqarafa qiniki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Anutufa iriseenoo kafaa qainasaa qimaminoo qinau. Eeoo qinee iridaqa kuqaa ani aakirafa qimamifana andeeqaananoo. Qinee kai ani qumee rafaaqafunana anee sia qini mandaikamma qimaqeenana mi anaaseena faqa sakasee faiqaananoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Doo findi finana mi fasiqana anaaqa kaifaa narí afaaqinnai aiqainanoo fuani. Abaraqaammafa qini tamummaqara fasiqa maridanoo. Mifa aniara innaaru qinaqa iriseeqa siamma ani aruanauranoo. Anee sia mi anaaseena aiqainaqa ani faqa ani maqannaasa faqa aiqama naruanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeereekafa mina iriseenoo Kananaana eendai findifinoo narí maqannaa uriqararausa naaramaseenoo Karaambaiqa qu ufana qimannimisoofaqa firaa qoo rufiaqau. ");
INSERT INTO bjr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeereekafa kafaa Abaraqaammana aaramaseenoo iramirinau. Anee nana oosanee maasa qiminanee. Nana manda ainainee maasa ani amunanee anee qini faqa qini qiku qisauku faqa firaa ummaara qiminanee. Sia auqaaqaa ira oosana maasa qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nana irirafee marifanee maaq inanee. ");
INSERT INTO bjr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abaraqaammafa mina iriseenoo maaqi qimasee Abimeereekana qimaminoo qinau. Qinee maaqi qimasee qimiriqa maa maqannaasa sia Anutunara rufiqee mariafaqa qini daruseeqa qini qinaaqa maree maqi qimaseeqa miqi qiqa. ");
INSERT INTO bjr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Qini qinaaqa kuqaa qini dauna maridanoo qini qikoona araamuna maridanoo moo anaasee faiqi marifaqa maraqaunafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Anutufa qiniara aneenna akoona maqusa minnisee anaamurinni nuannee qufaqa qinee Saraqa nammarina qimamiqa maaqi qiqiafana. Anee qiniara qini uriqarara fee qinana qiniara qini qifasaa fee qia. ");
INSERT INTO bjr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Miqi qufanoo iriseenoo Abimeereekafa Saraqa nammarina kafaa Abaraqaammana aminau. Mikari mifa sipsipauqa faqa burimakauqa faqa ainainira maanaaqa kumaaraauqa faqa Abaraqaammana aminau. ");
INSERT INTO bjr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Amiseenoo maaqi qimasee qimaminau. Qini maqa maaqa maridanoo. Aneenna kai aidinnaqoo maria. ");
INSERT INTO bjr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Miqi qimaseenoo quanda finoo Saraqa nammarina maaqi qimaseenoo qimaminau. Doo ani afasaana siruaa munnimma wan tauseenna (1,000) amiqa, maa ummaarafa taikainaqa ani faqa mariasa ani aaqarana sia mariifoo qiaqeera. Kafaa aiqamausa aniara sia mandoosana auqee maqi qiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Yaaweefa Saraqa nammarinaki kambiqoonara iriseenoo Abimeereekana, na aiku asaukukinaa aanaaseeuqa faiqi maqara aana ititasoofaqa faiqi maqarara sia amanaikiqau. Miqiqa marufanoo Abaraqaammafa Abimeereekanara Anutufinnai innaaru qufanoo Anutufa Abimeereekana faqa narí anaaqa faqa narí ainainira maanaaqauqa faqa misa aurirana taikannisoofaqa kafaa faiqi maqarana amanaikiqau. ");
INSERT INTO bjr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Karaambaiqa narí qimaqoondee inoo Saraqa nammarina amiqi amiqimma amaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Miqimmasoofanoo Abaraqaammafa nauraiqi marufanoo Saraqa nammarifa amuaqu qaikinoo Abaraqaammana faiqi Anutufa qimaqooqoo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Maqasoofanoo Abaraqaammafa mina auqu Isakeenee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Auqu ramaseenoo qisauku dinni taikasee dinni ani qaaramoo maraseenoo 8 faasaana aiqarama fufanoo Abaraqaammafa Anutufa qimamundee inoo Isakeena afaaqa ati ateeka aqinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abaraqaammafa uan handeereeta 100 aukuana faqaafa marufanoo Isakeena maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saraqa nammarifa Isakeena maqaseenoo maaqi qinau. Anutufa asasirana faqa naanaidara qirana faqa qiminoo. Aiqamausa minara irinausa qini faqa naanaidara qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Miqi qimaseenoo Saraqa nammarifa maaqi qinau. Yafee moo fannoo Abaraqaammana qimaminoo Saraqa nammarifa narí faiqi maqasee amana naamma amiannoo fee qiannoo fee, sia amana moo fannoo miqi qiannoo. Miqi qimariafaqa qinee asooqa namuki Abaraqaammana faiqi akoonaiqi maqeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isakeefa aaqoo irinoo naamma minnisoo faasaana Abaraqaammafa qoomaqa firaaqoo suqananau. ");
INSERT INTO bjr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Miqimmasee mariufanoo moo kari Isipa maqannaa anaasee Akaara nammarina amaaku fannoo Saraqa nammarina amaaku Isaakeena faqa sarari marinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sararimarufanoo Saraqa nammarifa mina qafamaseenoo Abaraqaammana qimaminoo qinau. Maa ainainira manaaqana faqa narí faiqi faqa niiqainaqa fuaqa. Maa anaaseena faiqi fannoo sia ani qumiasana qini faiqi mararee qinnana maraannoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Isamaeerafa faqa Abaraqaammana faiqi marunara Abaraqaammafa mi ufana irufanoo aundura ummaara ranau. ");
INSERT INTO bjr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Miqufanoo Anutufa Abaraqaammana qimaminoo qinau. Sia faiqi aanaaqi qisanoosara amuqusiani. Anee Saraqa nammarifa qimamindee ia. Isakeena saaqari kai qinee qima afeekaikiafannandee inoo moomoo asumu kambiqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ani ainainira anaasee faiqi faqa qinee dadaaqiananoo moomoo faiqi maqasainaqa moo maqannaasara foora marifaranoo. Mifa faqa ani faiqi kai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abaraqaammafa mi ufana iriseenoo moo kananaana findifinoo feemu aafaqa faqa aandau apata taquki nammari sakaseenoo Akaara nammarina uqaruma amiseenoo faiqi aakuamaqaseenoo aiqanau. Akaara nammarifa narí amaaku afiqeenoo Beeraseeba maqa maaqaki aadana maqa maaqaki ooqu maridanoo oonuree aniree ida marinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Aandau apata taqukinaa nammari aiqama taikafufanoo Akaara nammarifa narí faiqi kaqikaa saqari atukaki aisanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Aisaseenoo kaqikaaqoo kisaaqasaa oonu ooqufaqee idanoo narí kai qimirinau. Qinee sia amana qeeqa faiqi kuqirana qafaanauranoo. Miqi qimaseenoo miqoo ooqufaaqee maridanoo iki raqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Miqi marufanoo Anutufa mi faiqina iki raqarana irufanoo innaarunaindari Anutuna angiroo moo fannoo Akaara nammarina qimaminoo qinau. Akaara nammari anee nanaree ummaara maraidanee. Sia rufiaa. Ani amaaku iki raqarana Anutufa doo irinoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Doo findi finana oonu faiqi rafususee amiqi amiqia. Qinee mina saaqari kambiqainausa firaa maqannaasaika mannisaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Miqi qimaseenoo Anutufa Akaara nammarina afu maqa amufanoo nammari madika qafanau. Qafamaseenoo aandau apata taqu mara mareenoo ooqu saka narí faiqi amufanoo nanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Anutufa Isamaeerana rakisi amaqee marufanoo innooqanau. Innooqafufanoo mifa Paraana aadana maqa maaqaki maridanoo uaqarana akoofasa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paraana aadana maqa maaqaki marufanoo mina anoofa Isipa maqusaindaraa maanaaqa mara aminau. ");
INSERT INTO bjr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mikari Abimeereekafa Pikoorana narí rakira fasiqauqa uriqararana afiqeenoo Abaraqaammafa maruqoo oonu reeqa maaqi qimasee qimamiqa qiqau. Anee aiqama ainaina auqaannanaki Anutufa dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Doo maqee Anutuna afusaa qima afeekaikammasee qini faqa qini faiqi namu faqa qini saaqari naaru kambiqainausa faqa sia mandaikamma nimaqaa. Qinee ani amiqimma amaqaqiafana anee faqa miqi kai inana qima afeekaikammasee qini faqa maa maqa maaqana anee marianna maqa maaqana faqa amiqimma qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abaraqaammafa minara iriseenoo qimaminau. Qinee miqimmianauree qimasee qima afeekaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Miqi qimaseenoo Abaraqaammafa Abimeereekana oori kandara ufakiqari qimaminau. Ani ainainira faiqiuqa qini nammari madika rakirara maseeqa mareea. ");
INSERT INTO bjr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeereekafa iriseenoo qimaminau, Qoo qinee sia mina iridaqa, yafee miqinoo fee. Anee minara sia qima qimunaqa sia iriqiafana. Maqee kai iridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abaraqaammafa minara iriseenoo burimakauqa faqa sipsipauqa faqa mareeqee Abimeereekana aminau. Amisee miqanda moodaanaki kiqau. ");
INSERT INTO bjr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abaraqaammafa sipsipa aanaaqiuqa dinni taikasee dinni ani qaara marasee 7 naadumasaa raina quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeereekafa mina qafamaseenoo Abaraqaammana iramirinau. Anee nanaree miqidanee. ");
INSERT INTO bjr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Miqi qimasee iroofanoo Abaraqaammafa qinau. Anee maanauqa maraa. Anee marainnanannoo qiniara maa nammari dikaandana indu finaufoo qinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Misa miqoo qima afeekaika maseeqa mi maqusana auqureeqa Beeraseeba fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Miqanda Beeraseeba maqa maaqaki moodaanaki kira ufa qimasoofanoo Abimeereekafa narí rakira fasiqauqa uriqararana Pikoorasandiri nári maqusai Firistia maqa maaqai fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Miqanda fufanoo Abaraqaammafa tamarisika saqari Beeraseeba maqusai ummaquseenoo naaru naaru marira Karaambaiqa Anutunara innaaru qimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Mi kamuqoo Abaraqaammafa kisaaqasaa Firistia maqa maaqakina marinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Mariiufanoo Anutufa Abaraqaammana amanammasee qafaanee qimasee innaarunaindari aaramasee qinau. Oo Abaraqaama qufanoo Abaraqaammafa qinau qinee maaqoo maridaqa. Miqi qufanoo Anutufa qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Aneenna amaaku Isakeena ani amaaku moodaa, kaaqa amuqusa imariannana afiqeenana Mooria maqa maaqai ooru rainaqa qinee aaqana moo uqafiqaanaura. Anee mi aaqannanasaa aneenna amaaku arusee qini tatufirana suqa qimia. ");
INSERT INTO bjr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Miqi qimasoofanoo kananaana findifinoo narí dookisaa ida rufariseenoo minasaa quqaseenoo narí ainaini maru faiqi qanda faqa narí amaaku Isakeena faqa nifiqeenoo findimeeqee Anutufa qimamunnai finau. ");
INSERT INTO bjr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Qaara afuru aanai fi faiqaqau. Qaaramoo kufanoo Anutufa qimaqoo aaqannafa nianasaa marufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Qafamaseenoo Abaraqammafa narí ainaini maru faiqi qanda qimanniminoo qinau. Inneeqara maaqoo marida doonkisaa rakisiaqa. Qeeqa qimaakundiri miqoo ooru Anutunara innaaru qimasee inneeqara iannai qumuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Miqi qimaseenoo Abaraqaammafa tatufirana suqaaninna idana mareeqeenoo Isakeenasaa soofanoo maroofanoo narí ida qeemaruna akuru mandeenoo mina qumareenoo musuka faqa qumareenoo doo narí faiqi afiqeenoo Anutufa qimaqoo aaqanna kaaqa ooru finau. ");
INSERT INTO bjr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aanai ooru fimarufanoo Isakeefa narí akoona aaramaseenoo qinau, Qipoo qufanoo Abaraqaammafa maqi qimasee qinau. Nanaree qidanee qufanoo Isakeefa qinau. Qinee qafaunana anee idati faqa ida rumbarana faqa maree fimarinanoo, yaafee tatufirana suqeefandinna sipsipafa maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abaraqaammafa maaqi qimasee narí amaaku qimaminau. Anutufa narí kai sipsipa aanaaqi moodaa qiminaqa tatufirana suqamianaura. Miqi qimaseeqa miqanda moodaanaki ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Miqanda Anutufa qimaqoo aaqannasaa ooru reeqa Abaraqaammafa ooniuqa mareeqee aaku aakummaseenoo ida mina amuaaqa quqaseenoo narí faiqi Isakeena ruumbeeqeenoo rafusu idasaa rusinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Rusiseenoo musuka qumareenoo narí faiqi kuqa arusaaneera inau. ");
INSERT INTO bjr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Karaambaiqa angiroo innaarunaindari aaramaseenoo qinau, Abaraqaamma, Abaraqaamma, miqi qufanoo Abaraqaammafa qinau. Qinee maa maridaqee qufanoo Karaambaiqa qinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Sia faiqi arua, sia mandaikamma amaqaa. Sia aneenna asaukukoo aneenna faiqi arua. Doo maqee qinee iridaqa anee Anutuna ufa qaindusidana mina ufa afaqee mariananoo. Anee aneenna amaakuara aneenna amuqusa uqannara sia qaoo qiananoo eedoo kai qiananoo. ");
INSERT INTO bjr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Miqi qufanoo Abaraqaammafa uqeerafinoo qafoofanoo andandaki sipsipa akoona saqari aanaaqiki aanai rutaqusee marufanoo qafanau. Qafamaseenoo Abaraqaammafa narí amaaku amaaqa maqeenoo sipsipa akoona aruseenoo Anutuna tatufirana suqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Miqooqari Abaraqaammafa mi aaqanna auqu reenoo, Karaambaiqa nimira aaqanee qinau. Minara maqee mindaraasa maaqi qidaqa, Yaaweefa narí aaqanasaa nimidanoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Karaambaiqa angiroo innaarunaindari kaifaa Abaraqaammana aaramaseenoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Karaambaiqa aniara maqi qidanoo. Qinee qeeqa duqusaa qima afeekaikammasee qidaqa. Qinee firaaqoo ani amiqimma amaqaanaura. Anee aneenna amaaku moodaa sia qaoo qiannanara qinee miqianaura. ");
INSERT INTO bjr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Qinee kuqaa qima afeekaikammasee anisaa ani aruakinausa ani aiku asauku innaarunai fasaura foora moomoo marifaranoo nukudara foora ani amianauranoo. Ani aiku asauku namuqaa rafaaqa fusee misa ainaina maree marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Aiqama maqannaasa qiniara ani aiku asauku amiqi amiqimma nimaaqaafanandee masee maasa faqa amiqi amiqimma qimaqaannee qifaranoo. Anee qini aakapara ufa qaindusuannanara miqiqa. ");
INSERT INTO bjr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abaraqaammafa miqooqari narí faiqi Isakeesandiri narí ainainira faiqi qara qumi nifiqee narí maru maqusanai Beeraseeba maqusai ooqu marinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Mariiufanoo Abaraqaammafa irufanoo Mirikaa nammarifa Naqoorana Abaraqaammana akaqa faiqi qisauku dinni taikasee dinni oonu qaarammoo marasee 8 maqee foo qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usafa indaaruqaafa Busafa mina aanaaqiannaafa marinau, mina aanaaqiannaafa Keemueerafa mifa Arammana akoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","23","Mina aanaaqiannaafa Keeseedafa marinau, mina aanaaqiannaafa Qasoorafa marinau, mina aanaaqiannaafa Piradasafa marinau mina aanaaqiannaafa Didarafa marinau, misa ninaaqiannaafa Beetueerafa marinau. Mifa Reebeeka nammarina akoofa marinau. Mirikaa nammarifa mi faiqi namusa Naqoorana Abaraqaammana akaqasaa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reumma nammarifa Naqoorana inaaqiannaa anaasee fannoo Teebana faqa Kaqammana faqa Taqasana faqa Maakaana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saraqa nammarifa 127 aukuana marasee kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Kannaana maqa maaqaki Qeebooroona maqusaki kuqufufanoo Abaraaqaammafa mina kuqiranara soofaari marinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abaraqaammafa narí anaaqa kuqirana mafi quqasee Qeetana aiku asauku maruqoo oonureenoo maaqi qimasee iramirinoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Qinee moo maqannaasa inni qambaana ani maridaqa. Amanee qini maqa moo qimifaqa feefauru nimiseeqa qeeqa qinaaqa minaki akundaanauree. ");
INSERT INTO bjr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Qeetana aiku asuku irisee Abaraqaammana qimamiqa qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Anee maasa ufa iria, maasa ani qafaunana anee afeeka rakisirafa marianafa mariananoo. Aneenna anaaqa maasa amiqira madikaki akundaa. Maasa aiqamausa mi madikanaki akundaranara asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Miqi qufanoo Abaraqaammafa misa noorinni kumma ramafinoo qimanniminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","Innee eedoo qiafaqa amanee innee Eefaroona, Sooqarana amaaku iramirifanoo inni nifusaa Makapeera maqa maaqaki narí anaadoo atinni ooni aamara marina qiminaqa feefauru amana kai amiseeqee mi maqa maaqana qeeqaindi kammasee qeeqa qiku qisauku nikundee marianauree. ");
INSERT INTO bjr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eefaroofa narí Qeetana aiku asauku faqa faandaamura kooqiki ufa suqiranaki maridanoo iriseenoo aiqamausa iramirufanoo Abaraqaammana qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Oo uriqararafa iria, qinee aiqama mi maqana faqa ooni aamara minaki marina faqa ani amianaura. Maaqoo qeeqa faiqi anaasee nifusaa ani amianana aneenna anaaqa minaki akundaa. ");
INSERT INTO bjr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Miqi qufanoo Abaraqaammafa Qeetana aiku asauku noorinni kumma ramafinoo Eefaroona aiqamausa iriaqeera firaaqoo qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Amanee qinee iramiriananee irinnaree. Qinee mi maqana atisaa aiqama feefaurianaura. Qinee feefauru amianana anee eedoo qimasee marainaqa qinee qeeqa qinaaqa miqoo akundaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eefaroonafa minara iriseenoo maaqi qimasee Abaraqaammana qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Oo uriqararafa, maqa feefauru 400 siruaa maridanoo, mi feefauruna maasa qeeqa qambaana naqa fee masee rainaanauree. Anee aneenna anaaqa kaqi minaki akundaa. ");
INSERT INTO bjr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abaraqaammafa iriseenoo eedoo qimaseenoo sikeera maraseenoo 400 qummaara ainaina dinni quqaseenoo siruaa dinni quqasoofanoo amana kai ufanoo aminau. Eefaroonafa aiqamausa narí maqannaasa Qeetana aiku asauku nifusaa qufanoo iriseenoo miqi kai minau. Nári sikeera qummaara amana kai Eefaroona aminau. ");
INSERT INTO bjr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Miqimmasee Abaraqaammafa Eefaroona aiqama ainaina Makapeeraa maqa maaqaki suani oosana qaannai Mammareena maqusa adeedi maruna feefaurummasoofanoo Abaraqaammanaindi kinau. Mi feefaurirafa maqa faqa ooni aamara minaki maruna faqa aiqama saqariuqa mi maqana atisaa maru saqarisa faqa aiqama moodaanaki rafaaqafinau. ");
INSERT INTO bjr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Aiqama Qeetana aiku asauku miqoo suqiranaki mariusa mi maqa maaqanara Abaraqaammanaindi fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Miqimmaseenoo Abaraqaammafa narí anaaqa Saraqa nammarina mi ooni aamaranaki Kannaana maqa maaqaki akundanau. ");
INSERT INTO bjr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Miqimmasoofanoo mi maqafa faqa ooni aamara minaki marufa Qeetana aiku asaukundi mariufa Abaraqaammanaindi kufanoo mi maqana nikundara maqaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Doo Abaraqaammafa kaaqa nauraiqi marinau. Karaambaiqa Abaraqaammafa aiqama auqoo ainainna amiqi amiqimma amaqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abaraqaammafa nári oosana maraseenoo nári ainainiranasaa kisaaqasaa rakisi maruna aaramaseenoo qimaminoo qinau. Anee aneenna asauku qifundana ameemaanai aususee afeekaika masee qima afeekaikia. ");
INSERT INTO bjr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Qinee aniara Karaambaiqa innaaruna faqa maqa faqa auqu Anutuna auqusaa qima afeekaikamasee sia qini qimaaku Kannaana maqannaa anaasee mara amiannee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Anee qinee kambiqaafanna maqusanai oonuree qini atikinaa maanaaqa mara maree Isakeena muqu amia. ");
INSERT INTO bjr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Miqi qimasoofanoo mi rakisirafa maaqi qinau. Doo amana, ooru raanaqa mindaraa maanaaqa iraifanoo narí maqa maaqa minnisee mai qumirara ititinaqa amanee qinee ani amaaku aiqaananoo anee qumunna maqa maaqanai ooru fuannoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Miqi qufanoo Abaraqaammafa qinau. Oo sia uqanna anee qini qimaaku aiqainanoo minni oorufuani. ");
INSERT INTO bjr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yaaweefa innaarunaindaraa Anutufa qeeqa qikoona maqusaindaraana faqa qeeqa ainaina maqasaaqaraana faqa mara mareenoo maa maqa maaqanasaa quqaqoosa maridaqa. Mifa qima afeekaikammasee qini faqa qini qiku qisauku faqa maa maqa maaqana nimianauree qinau. Mifa narí angiroo aiqainanoo ani afunni finana ooru qini qimaaku anaaqa afiqee qumi naranoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mindaraa maanaaqa fannoo sia mai qumiraree qinana miqoo kai qima afeekaika maqaanna ufanakiqari idukuananoo. Qini qimaaku sia minni afiqee ooru fua. ");
INSERT INTO bjr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Miqi qimasoofanoo mi ainainira fasiqafa narí asauku Abaraqaammana narí uriqararana afundana ameemaanai quqaseenoo qinau, doo qinee anee qianandee ianaura. ");
INSERT INTO bjr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Miqi qimaseenoo raudama kinoo Abaraqaammana kammeera, qoosa fooqaana, mina qisauku qara maraseenoo narí uriqararana ainaina amiqirana kai maraseenoo kammeerasaa quqaseenoo mareenoo finau. Abaraqaammana akaqa Naqoorafa Mesopotamia maqusai suani dinni ataaqeenni marunnai ooru finau. ");
INSERT INTO bjr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aanai faiqanoo fifiiu fanoo eenee marufanoo aanaaseeuqa nammari sakee maruqoo oonu ranau. Oonuree qafoofanoo maqusa adeedi nammari sakee maruqoo oonu reenoo miqoo narí kammeerauqa quqasoofaqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Narí kammeerauqa quqaseenoo mi fasiqafa Yaaweenara innaaru qinoo qinau. Oo Anutu qini uriqararana Abaraqaammana Anutufa anee qini faqa maridana maqee qini dadaaqia. Anee qini uriqararana Abaraqaammana faqa qima afeekaika maqoonafa maqee anoonaikiani. ");
INSERT INTO bjr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Qinee nammari sakee mariana aaqa adeedi marunaqa, aanaaseeuqa nammari ani sakee mariafaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Moo maanaaqa anirainaqa qinee maaqi qimasee qimamianaura. Amanee aneenna taquki nammari saka qiminaqa naanauree. Mifa qiniara namasainaqa ani kammeerauqa faqa nimianauree qinnanara minara aneenna ainainira faiqi Isakeena utaaqama amaqaqaanafee qianaura. Mi ainainafa kambiqainaqa anee qini uriqararanasaa qima afeekaikunna ufanara irianaura. ");
INSERT INTO bjr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mifa miqi qimasee innaaru qimarufanoo moo maanaaqa Reebeeka nammarifa nammari taqu akumaaqa aku maree aniranau. Mifa Abaraqaammana akaqa Naqoorana faqa mina anaaqa Mirikaa nammarina faqa faiqi Betueerana araamuna marinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mina oori afiri amiqi amiqi irafa sia auqu marufa aniroofanoo qafoofanoo ooqu nammari saka maree urinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ururoofanoo Abaraqaammana ainainasaa rakisira fasiqa fannoo mi funnai sandee oonureenoo maaqi qimasee qimaminau. Amanee aneenna taqukinaa nammari kaqikaana qini qiminaqee naanauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Miqi qufanoo mi manaaqafa qinau, eeoo faiqí firaafa, doo naa qimaseenoo nammari taqu afiqu quqasoofanoo doo nanau. ");
INSERT INTO bjr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Namasoofanoo mi manaaqafa narí kai qinau. Qinee nammari moo faqa sakasee ani kammeerauqa nimii saanaqa nama saifanoo nimuaqu iannoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Miqi qimaseenoo narí nammari taqu kai kaqi difaaniki adiaseenoo sandeenoo ooqu moo faqa saka mareenoo muru adia soofaqa kammeerauqa naqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kammeerauqa nammari nimi marufanoo Abaraqaammana ainainira fasiqa fannoo ireeda kai kasooinoo maridanoo qafaidanoo maaqi qimirinau. Doo fee Yaaweefa qinee kisaaqasaa anunnanara anoonai kidanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kammeerauqa nammari neeneesee nimuaqummasee marufanoo Abaraqaammana ainainira fasiqa fannoo koorannai auqira qimmusa mi manaaqana aikiki qusamaqaseenoo kafa koorannai auqira isaaqama qaaraqanda asaukuki usamaqaseenoo iramirinoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Anee yana araamunee maridanee amanee qini qimaqimia. Amanee maasa namu aneenna akoona maaqa kina nifiqee finaqee faiqaanauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Reebeeka nammarifa mina iriseenoo narí qimaminoo qinau. Qini qikoofa Beetueerafa Naqoorana faqa Mirikaa nammarina faqa faiqi maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Maasa maaqa narana amana maridanoo ani faqa aniasa faqa ani kammeerauqa faqa narana maaqa faqa nimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Miqi qimasoofanoo Abaraqaammana ainainira fasiqa iriseenoo maqasaa oorindari mapamu finoo Karaambaiqa narí uriqararana Abaraqaammana Anutuna amooqidanoo maaqi qinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Oo Anutu Abaraqaammana Anutufa, anee amiqi amiqi uqanna miananoo. Anee Abaraqaammana amiqi amiqi imariannanara sia taikeenoo kaqi fidanoo. Karaambaiqa fannoo qini uriqararana atiuqa iannai andeeqasee qifiqee aninoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Miqi qimasee innaaru qimasoofanoo Reebeeka nammarifa sandeenoo narí anoona maaqai oonureenoo aiqama mi ufausa qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Reebeeka nammarina afasaafa Rabanafa Reebeeka nammarina ufa iriseenoo koorannai auqira qimmusa qusamaqoona faqa koorannai auqira isaaqama qusamaqoona faqa qafamaseenoo raudamaku fanoo ooqureenoo nammari sakee maru madikana afainni qafoofanoo Abaraqaammana ainainira fasiqa miqoo nammari afainni narí kammeerauqa naaqa kikiqinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Marufanoo qafamaseenoo qimaminoo qinau. Qini faqa aninaqa maaqai fua. Karaambaiqa fannoo ani amiqi amiqimma amaqee marifa mariananoo. Nanaree anee maaqoo maridanee. Qinee ani faiqara maaqa doo deedaqammasee ani kammeerauqa marirana faqa deedaqiqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Abaraqaammana ainainira fasiqa fannoo mina iriseenoo narí faqa marusa faqa narí kammeerauqa faqa nifiqeenoo doo maaqai finau. Maaqai oonu roofanoo Rabanafa kammeera saaqaraa qumaara mara maqasaa quqaseenoo narana nammari nimiseenoo Abaraqaammana faiqi namu nammari nimufaqa niku nammari uqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Niku nammari uqu soofanoo Rabanafa narana niminau. Nimufanoo Abaraqaammana ainainira fasiqa fannoo qaoo qimasee qinau. Sia qinee kaqi naanaura. Qinee qiraree qunna ufana qima nimiseeqa miqoo naanaura. Rabanafa minara iriseenoo qinau. Doo qinaqa maasa iria. ");
INSERT INTO bjr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Miqi qimasoofanoo Abaraqaammana ainainira fasiqa qima niminoo qinau. Qinee Abaraqaammana ainainira fasiqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Karaambaiqa firaaqoo qini uriqararana amiqi amiqimma amaqaseenoo ainaina faqaafaikamma amaqeenoo. Karaambaiqa sipsipauqa faqa burimakauqa faqa siruaa faqa koora faqa ainainira fasiqauqa faqa maanaaqauqa faqa kammeerauqa faqa doonkiuqa faqa moomoo aminoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Qini uriqararana anaaqa Saraqa nammarifa asooqasaa faiqi akoonaiqi maqasoofanoo qini uriqararafa narí aiqama ainaina mina kai aminoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Qini uriqararafa qifaqa qinee afeeka ufannai qima afeekaikammaseeqa mina aamuaqira ufa qaindusuanauree qiafananoo qinau. Anee maqoo qaraasa Kannaana maqannaa kinaa anaasee sia uqanna mareeqee qini qimaaku amia. ");
INSERT INTO bjr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Anee ooru qini qikoona maqannaasaki qini atikinaa maanaaqa mara maree muqusee qini faiqi amia. ");
INSERT INTO bjr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Qinee mi ufana iriseeqa narí maaqi qimaseeqa qimamiqa. Mi manaaqafa sia qini faqa quminaqa naqaa fee ianauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Qunanoo mifa qinoo, qinee Karaambaiqa ufa aiqama kari afaqee marunausa maridaqa, mifa narí angiroo aiqainanoo ani faqa fidanoo dadaaqinanoo anoona kambiqaannoo. Anee qini faiqi anaaqa qini maqannaasakinaana qini qikoona atikinaana mareennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Moodaa aana kai anee idukinna aanafa maridanoo. Ooru rainaqa misa maanaaqa moo sia qimifanoo ani qima afeekaikirafa taikainana idukira fasiqaikinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Qinee Abaraqaammana mi ufana iriseeqa nammari dikaanda mariqoo ururee maaqi qimasee innaaru qiqa. Oo Karaambaiqa qini uriqararana Abaraqaammana Anutufa mariananoo, qinee auqaunna ainainna anoona kambiqaani. ");
INSERT INTO bjr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Qinee nammari dikaanda mariqoo marianaura. Mariananoo maanaaqa moo fannoo nammari sakarara anirainaqa qinee nammariara innaaru qianaura. ");
INSERT INTO bjr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mifa eedoo qimaseenoo qini faqa qini kammeerauqa faqa nammari niminanoo mifa anee qini uriqararana amaaku utaaqama amaqaqaanafa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Qinee qireeda kai innaaru qimarunanoo Reebeeka nammarifa maqusaindari nammari taqu akumaaqa akumareenoo aiqareenoo nammari sakararee qimasee fifaqa qinee maaqi qimasee qimamiqa. Amanee anee nammari qimina naanauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Miqi qunanoo mifa kai kaqi narí nammari taqu akumaaqa qaraana afaimma quqaseenoo qinoo. Namasainaqa ani kammeerauqa faqa nimianaura. Miqi qifaqa qinee namasaunanoo mifa kammeerauqa faqa nimifaqa neea. ");
INSERT INTO bjr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Namaseeqa qinee maaqi qimasee iramiriqa ani akoofa yafee, qunanoo mifa qimaqiminoo qinoo. Qini qikoofa Beetueerafa Naqoorasa Mirikaa nammarisa faiqi maridanoo. Qinee mi ufana iriseeqa koorannai auqira qimmusa usuamaqaseeqa kafa koora isaaqama asaukuki usuamaqeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Usuamaqaseeqa doorindari maqasaa kummarama fifaqa qeeqa uriqarana Abaraqaammana karaambaiqa Anutuna amooqiqa. Mifa qini qifiqamareenoo andeeqasee qini uriqararana atiuqa iannai murusaifaqa qinee misa niraamuna qeeqa uriqararana amaaku anaaqa marianinnana paquriqa. ");
INSERT INTO bjr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Doo maqee uqanna Rabanna anee qima qiminaqa iria. Anee qini uriqararana andeeqa amaqararee qinana qima qimia. Anee sia andeeqa amaqararee qinana minara faqa qima qiminaqa qinee qeeqa ianna ainainara oonu mafi irianaura. ");
INSERT INTO bjr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Rabanafa faqa mina akoofa Beetueerafa faqa narí qimamiqa qiqau. Maa ufafa Karaambaiqinaindari ani marifaqa maasa naqifee masee minara ufa qinauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Maa Reebeeka nammarifa marinoo. Afiqamaree fua. Munusainanoo mifa ani uriqararana amaaku aanaaqaikinoo, Karaambaiqa narí qindee iani. ");
INSERT INTO bjr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abaraqaammana ainainira fasiqa mi ufana iriseenoo oorindari maqasaa aqufinoo Karaambaiqa amooqimamaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Amooqimaseenoo findifinoo qamunna faqa siruaa faqa koora faqa firaa feefauru aqimaru oonisa Reebeeka nammarina aminau. Mifa firaa munnimma aqimaru ainainausa mina afasaana faqa mina anoona faqa niminau. ");
INSERT INTO bjr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nimi seenoo narí faqa anusa saimbaqa narana faqa nammari faqa neenee seeqa faiqaqau. Faiqee iaqoofanoo kananaana Abaraqaammana ainainira fasiqa Reebeeka nammarina afasaana faqa anoona faqa qima niminau. Amanee qinee maqee qeeqa firaa finnai fuanauree. ");
INSERT INTO bjr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Miqi qufaqa miqanda qiqau, saina Reebeeka nammarifa maasa faqa moodaa amaanaki fee, qisauku qara taikaseenoo afuru fee faiqeenoo fuani. ");
INSERT INTO bjr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Miqi qufanoo Abaraqaammana ainainira fasiqa fannoo qinau. Doo sia maasa rafaaqa fua. Doo qinee maqee fidaqa. Karaambaiqa fannoo qinee kisaaqasaa anunna saikana anoona doo kambiqasaifaqa qafamaseeqa sainaqa qeeqa uriqarara finnai fua. ");
INSERT INTO bjr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Miqanda minara iriseeqa qimamiqa qiqau. Saina Reebeeka nammarina aaramasee qifanoo naqaa fee qiannoofee. ");
INSERT INTO bjr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Miqi qimaseeqa Reebeeka nammarina aaramaseeqa iramiriqa qiqau. Anee maa fasiqana faqa maqee fee finnaree. Miqi qufanoo doo maqee fuanauree qinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Misa mi ufana iriseeqa Reebeeka nammarifa faqa minasaa rakisi maru anaaseefa faqa Abaraqaammana ainainira fasiqa faqa mina faqa anusa faqa doo niqiqoofaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Reebeeka nammarifa firarufaqa maa ufanannoo mina afaaqooqa qiqau. Oo maasa qisooki anikiqari aruakinausa moomoo uqanna firaaqoo uqanna kambiqeefara ani aiku asauku marinausa namuqaa nárí nifaqaaqa mandaida misa maqa maaqa namu faqa misa ainaina faqa maree marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Miqi qimasee afaaqooqa qimasoofanoo Reebeeka nammarifa faqa ainainira maanaaqauqa faqa kammeerasaa akaree fufaqa Abaraqaammana ainainira fasiqa namu faqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isakeefa Neekeefa maqa maaqakiqari aadana maqa maaqai nammari dikaanda maruqoo ooqu marinau. Mi nammari dikaandana auqu kaqi marirafa qini qiqafaidanoo fee qimariqau. Mifa Kannaana maqa maaqa qaannai suani afu dinni ataaqeenni marinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Miqoo maridanoo Isakeefa moo eenoonnai aatata nidanoo uqeera fufanoo mirinni qafoofanoo kammeerauqa qumiqau. ");
INSERT INTO bjr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Reebeeka nammarifa kammeera saaqari uqeera finoo Isakeena qafanau. Reebeeka nammarifa qafamaseenoo narí kammeera saaqari maqasaa aqufinau. ");
INSERT INTO bjr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Aqufufanoo Abaraqaammana ainainira faiqi iramirinau. Ya fasiqa fee maasa unannai anidanoo fee. Miqi qufanoo Abaraqaammana ainainira fasiqa qinau. Qini uriqararafa anidanoommi qufanoo Reebeeka nammarifa nári oosana mareenoo qamunna mafi oorisaa ititanau. ");
INSERT INTO bjr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Isakeefa uru paqurimmasoofanoo Abaraqaammana ainainira fasiqa fannoo aiqama ainaina auqoonara Isakeena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Qimamisoofanoo Isakeefa Reebeeka nammarina mareeqeenoo narí maaqaki Saraqa nammarifa mariunaki quqasoofanoo mina aanaaqai kinoo marufanoo Isakeefa Rebeeka nammarinara aidi marufanoo mi aidirafa Isakeefa narí anoofa kuqunara amuqusiufa doo asooanau. ");
INSERT INTO bjr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abaraqaammafa anaasee moo maranau. Mina auqu Keeturaa nammarifa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Minasaa faiqi moomoo maqanau. Faiqi moo indaaruqaana auqu Simaramafa marinau mina aanaaqianaafa Yookasanafa marinau mina aanaaqianaafa Meedanafa marinau mina aanaaqianaafa Midianaafa marinau. Mina aanaaqianaafa Isabakafa marinau ninaaqianaafa uqanna Suaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Indaaruqaana aanaaqianaafa Yookasanafa mifa Seebabana faqa Deedana faqa nikoofa marinau. Deedana aiku asuku Asuraa maqannaasa faqa Reetusimma maqannaasa faqa Reeummimma maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiana amaaku indaaruqaa faiqi Eefaafa marinau, mina aanaaqianaafa Eefeerafa marinau, misa ninaaqianaafa Qannookafa marinau misa ninaaqianaafa Abidafa marinau, misa ninaaqianaafa uqanna Eeradaafa marinau. Minamusa Abaraqaammana anaaqa Keeturaa nammarina saaqari kambiqarausa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abaraqaammafa narí aiqama ainaina Isakeena kai aminau. ");
INSERT INTO bjr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Amiseenoo narí kaqi maridanoo moo anaasee faiqi namu faqa amiqira ainaina oosana oosana Abaraqaammafa kaqi nimiseenoo Isakeefa maruqooqari suani oosana qaannai maqa maaqai nianai niiqoofaqa mitinai oonu mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abaraqaammafa asooqaqeenoo kuqinau. 175 aukuana marasee kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kuqufufaqa mina amaaku qara Isakeesa Isamaeerasa miqanda nári nikoona iri mara maree Makapeeraa maqa maaqaki Mamaree maqusa suani oosana qaannai ooni aamaraki akundaqau. Mi maqana Eefaroona Sooqarana amaaku Heetana aiku asaukundi feefaurummaqoonaki Abaraqaammana akundaqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abaraqaammafa kaqi maridanoo Qeetana aiku asauku feefauru maqoonakina Saraqa nammarina faqa Abaraqaammana faqa nikundaqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abaraqaammafa kuqufufanoo mina amaaku Isakeena Anutufa amiqi amiqi imarinau. Isakeefa kaqi marira nammari dikaanda qini qiqafaidanoo fee qimaru nammari dikaandana aaqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Qakaara nammarifa Saraqa nammarina ainainira maanaaqa Isipa maqannaa maanaaqa marufa mifa Abaraqaammana amaaku Isamaeerana maqoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Isamaeerana faiqi namu maaqimmiqa mariqau. Indaaruqaafa Neebaiootafa marinau, mina aanaaqianaafa Keedarafa marinau, misa ninaaqianaafa Adabeerafa marinau, misa ninaaqianaafa Mibasamafa marinau, misa ninaaqianaafa Misammafa marinau, misa ninaaqianaafa Dummaafa marinau, misa ninaaqianaafa Masafa marinau, misa ninaaqianaafa Qadadafa marinau, misa ninaaqianaafa Teemafa marinau, misa ninaaqianaafa Yeeturafa marinau, misa ninaaqianaafa Nafisafa marinau, misa ninaaqianaafa uqanna Keedeemaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Misa qisaukuqara taikasee qikunnooqu qaara marasee maqannaasa nikausaikiqa mariqau. Miqiqa maridaqa nariqa nuqu nariqa maqusa faqa nariqa uiqaana maqusa faqa qafaafauree mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isamaeerafa 137 aukuana maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isamaeerana aiku asauku Isipa maqusaindari suani oosana qaannai Sura maqa maaqa faqa, Qafiraa maqa maaqa faqa qambaana Asiria maqa maaqai fimaruqoo mariqau. Misa Abaraqaamana aiku asauku akaqausa maruqooqari naaduma mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Moo ufa Abaraqaammana amaaku Isakeena ufa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isakeefa qaara fasiqa niku nisauku taikasee 40 aukuana maraseenoo Beetueerana araamuna Reebeeka nammarina maranau. Rabannana asookina maranau. Beetueerafa Arameeannaindaraafa Meesoopootamia maqa maaqaki ani marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Reebeeka nammarifa sia faiqi maqanau aafanaasee marinau. Isakeefa minara iriseenoo Yaaweenara innaaru qimarinau. Yaaweefa mina ufa iriseenoo dadaaqufanoo Reebeeka nammarifa amuaqu qaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Amuaqu qaikufanoo faiqi qaara qanda mina aranandaki maridaqa raki mariqau. Raki marufanoo Reebeeka nammarifa qinau, maa ainainafa nanaree qiniki kambiqaidanoo fee qimaseenoo karaambaiqunnai oonuree anoonufa qimamianifeera innaaru qinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Innaaru qufanoo Yaaweefa qimaminoo qinau. Qaara maqannaasa ani aranandaki maridaqa. Anee nariara nariara rairai qimariasa nikooqanda maqeennaranoo. Moo fannoo moo uriqarara afeeka faqaafa marianno. Akaqa fannoo afasaana rafaaqa fuaninafa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Reebeeka nammarina faiqi maqarafa aniroofanoo qaara qanda maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Indaaruqaana afaaqa kaaqa taatuqee arinoo marinau, mina afaaqasasa asausi aanaaqi marinau. Mina auqu Eesau nee qiqau. (Mina auqu oosana asausi fee qiqau). ");
INSERT INTO bjr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Inaaqianaafa indaaruqaana aiku ataa rakisisimma uqirafa quminau. Minara mina auqu Yakooboo nee qiqau. (Mina auqu oosana aiku ataa fee qiqau.) Isakeefa qaaramoo fasiqa niku nisauku taikaseenoo 60 aukuana maraseenoo miqanda maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Miqanda innooqafufaqa Eesaufa uaqarana akoofasa maridanoo sia ooqu marufa kaqi niranara aidimarufa marinau. Miqi marufanoo Yakooboofa sia miqi marinau. Fifirafa maridanoo maqusasaa marufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isakeefa Eesaunara aidi marinau. Mifa aandau arusoofanoo nee marunara minara aidi marinau. Reebeeka nammarifa Yakooboonara rimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Moo kari Yakooboofa narana suqasee auqee marufanoo mina afasaafa nandaki niniiufa aararoofanoo anireenoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Anee taatuqee narana auqee mariannana doo mina mara qiminaqa naa daarandee marifaqee qinau. Miqi qimasoofaqa misa minara iriseeqa Eesaunara Eedoomee qimariqau. Mi auquna oosana taatuqee fee qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakooboofa iriseenoo qinau, aninidiri qikoofa anee indaaruqaa faiqi mariananoo ani afaaqooqa qima amaqee marina qiminaqa narana ani amianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Eesaufa qinau. Saa qinee daararai faqa kuqua qaammidaqa qini mi ainainausa sia qini dadaaqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakooboofa iriseenoo qinau, aneenna ufa qima afeekaika mandee qiminaqa qinee narana ani amianaura. Qimasoofanoo Eesaufa Yakooboonara qima afeekaika mandee indaaru mina akoofa qutaaqama amaqoo ainainna amiraree qinau. ");
INSERT INTO bjr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Miqi qima afeekaika masoofanoo Yakooboofa quanda fufanoo feemu faqa nara ainaina faqa nammari faqa Eesauna amufanoo namasee doo finau. Miqi maseenoo Eesaufa narí indaaruqaa faiqi marunara akooqoofanoo narí akaqa amisee quqasee finau. ");
INSERT INTO bjr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abaraqaammafa maru aukuanna aandaroo firaafa narufanoo Abaraqaammafa Isipa maqa maaqai ooqu finau. Kafaa mina amaaku Isakeefa maru aukuanna aandaroo narufanoo Isakeefa Keeraa maqusai Abimeereekana maqusai finau. Abimeereekafa Firistia maqannaasa uriqararafa Keeraa maqusai marunnai finau. ");
INSERT INTO bjr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Isakeefa Keeraa maqusai oonu marufanoo Karaambaiqa maaqi qimasee qimaminoo qinau. Anee sia Isipa maqa maaqai ooqu fua. Maaqoo qinee aniara mariannee qunnaqoo kai maria. ");
INSERT INTO bjr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Maaqoo kai marinaqa qinee ani faqa marida amiqi amiqida dadaaqianaura. Maa maqa maaqana faqa anisaa ani aruakinausa faqa nimianaura. Qinee minara Abaraqaammana ufa qima afeekaika masee amianauroo qiafannana doo ani faqa qima afeekaikiqa amianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Qinee anisaa ani aruaki kambiqainausa fasaura foora moomoo amianaura. Qinee maa maqa maaqana misa nimianaura. Aiqama maqannaasa aniree maaqi qimasee innaaru qifaranoo. Oo Anutu anee Isakeena aiku asauku amiqi amiqimma nimaqoonandee inana maasa faqa amiqi amiqimma qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abaraqaammafa ani akoofa qini sandufa faqa aamuaqira ufa faqa afaqee marunara qinee ani amiqi amiqimma amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isakeefa Anutuna mi ufana iriseenoo eedoo qimaseenoo Keeraa maqusai maridanoo Isipa maqa maaqai sia ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Keeraa maqannaa fasiqauqa mina aanaaqara iramirufanoo Isakeefa qini qisooki fee qinau. Isakeefa narí anaaqa Reebeekaa nammarifa oori amiqirafa marufanoo qini darusee qini qinaaqa mareefoo qimaseenoo rufia mareenoo qini qisooki fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isakeefa kaqi kaaqoo marinoo moo kari narí anaaqa Reebeeka nammarina faqa madaanai ooqu faaqee narisaa narisaa mundiqa marufanoo mi maqannaasa uriqararafa narí maaqaki ooqufaaqee maridanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Qafamaseenoo Abimeereekafa Isakeena aaramaseenoo qinau. Maa anaaseefa ani anaaqa uqanna maridanoo. Anee nanaree qini qisooki fee qinanee. Isakeefa qinau. Qini qinaaqa fee qianaqa darifoora miqi qiqa. ");
INSERT INTO bjr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeereekafa iriseenoo qinau. Anee maasa naqaa fee maqimaqeenee. Qini maqannaa moo fannoo ani anaaqa sakasee faiqaifana anee mi ummaarana maasa qimianaiqini. ");
INSERT INTO bjr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Miqi qimaseenoo narí maqannaasa aiqama naarama quqaseenoo maaqi qimasee qima niminau. Yafee maa fasiqanee mina aanaaqee mandaikamma nimaqaifaqa qinee kuqa kai mina aruanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mi aukuannai Isakeefa narana ummaqusoofanoo kambiqafufanoo amiqimmasee anoona mafufanoo unakira aukuana moomoo uqanna unakinau. Karaambaiqa amiqi amiqimma amaqasee dadaaqunara miqinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Karaambaiqa dadaaqufanoo mina ainaina rairaaufanoo kaaqa ainaina faqaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Mifa moomoo sipsipa faqa burimakau faqa ainainira faiqiuqa faqa marunara Firistia maqannaasa niranaqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ooqai Abaraqammafa kaqi maridanoo indufuqoo nammari dikaandausa Firistia maqannaasa aiqama rafaaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Moo kari Abimeereekafa Isakeena aiqama ainaina tia qafamaseenoo rufia seenoo qimaminau. Doo anee maasa uridaaqarana mariananoo. Anee maasa maqa maaqa quqasee moosaa fua. ");
INSERT INTO bjr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isakeefa mi ufana iriseenoo mi maqa maaqana minniseenoo narí uiqaana maaqa Keeraa noopunduki usakasee miqoo kisaaqasaa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Miqoo ooqu Isakeefa narí akoona nammari madikauqa Firistia maqannaa rafaaqa fuqoona paqurimmaseenoo kafaa indufuseenoo narí akoofa auquroo auquna kai kaifaa auquranau. ");
INSERT INTO bjr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isakeena ainaini maru fasiqausa mi arumunaki fuka madika indufiufaqa nammari paquriqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Paquri masoofaqa Keeraa maqannaa sipsipasaa rakisi marusa mi nammarina qafamasee Isakeena sipsipa rakisirausa faqa rakirarida qiqau. Maa nammarifa maasaindi maridanoo. Miqi qufanoo Isakeefa mi nammari madikana auqu Tinoorira nammari madikee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Miqi qimasoofaqa mina ainainira fasiqa namu kafaa moo indufiqau. Keeraa maqannaasa minara faqa miqi kai iqau. Isakeefa mina iriseenoo minara faqa niranaqara nammari fee kai qinau. ");
INSERT INTO bjr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Miqi qimaseenoo kafaa quqasee moosaa oonureenoo miqi kai minoo moo nammari madika indufinau. Miqoo minara sia tinoo taanoo rirafa marufanoo mi nammari madikana auqureenoo nifaaqa quqasee mana manira nammari madikee qinau. Maqee Karaambaiqa fannoo mana manirana maasa qimifaqa maridaqa maaqoo aiqama ainaina masaananoo rairaaiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Doo miqoo mariufanoo miqoo minni seenoo Beeraseeba maqa maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Miqoo marufanoo moo eendaki akooqoo Karaambaiqa maaqi qimasee qimaminau. Qinee ani akoona Abaraqaammana Anutusa maridaqa. Sia anee rufia rufiaqia. Qinee ani faqa nidaqa. Qeeqa ainainira fasiqa Abaraqaammana faqa qima afeekaikiafannanara iriseeqa ani amiqi amiqi ianaura anisaa ani aruakinausa moomoo kambiqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isakeefa Karaambaiqa mi ufana iriseenoo ooninnai qainda auquseenoo Karaambaiqa aandau tatufirana minasaa suqa amiseenoo innaaru qinau. Miqoo Isakeeefa narí uiqaana maqa burimakau apatannoo usakaseenoo marinau. Minaki maridanoo narí ainainira fasiqauqa niiqoofaqa moo nammari madika indufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeereekafa Keeraa maqa maaqaindari Ausafatana narí irirana amimaru fasiqana faqa narí sundiauqa uriqararana Pikoorana faqa Isakeena qafararee qimasee Beeraseeba maqusai aniqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aniroofanoo Isakeefa iramirinoo qinau. Naqi fee qifaqee qiniara nikooqoofaqa diiqamasoosa marunnannai kafaa anidanee. ");
INSERT INTO bjr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Miqi qufanoo Abimeereekafa faqa mina faqa anusa qiqau. Karaambaiqa ani faqa marinara maqee maasa iridaqa. Ani faqa maasa faqa qambaana kuqaa qima afeekaikirafa marianifeera iridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Maasa aniara qima afeekaikammasee sia maasa mandaikamma qimaqaannee qidaqa. Maasa sia ani mandaikamma amaqaafannandee inana maasa faqa sia mandaikamma qimaqaa. Maasa ani amiqi amiqimma aisaafanana anee asooaranaki finau. Maqee akooqoo uqanna Karaambaiqa fannoo ani amiqi amiqimma amaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Miqi qimasoofanoo Isakeefa qoomaqa deedaqinau. Deedaqammasoofaqa misa narana namaseeqa faiqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kananaana findi fufaqa narí qimami narí qimamimma afeekaikamasee firaa ufannai qima afeekaikamma rafaaqafiqau. Miqimmaseenoo Isakeefa nimandara ufa qimasoofaqa aqoondi kammasee quqasee fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Doo mi faasaanna Isakeena ainainira fasiqa namu nammari madika indufu qoonaki nammari paqurimmasee Isakeena qimamiqa qiqau. Doo maasa nammari paquriqa. ");
INSERT INTO bjr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Miqi qimasee qimamufanoo Isakeefa mi nammari madikanara qima afeekaikira madikee qinau. Miqi qimaseenoo nári ufakiqari Beeraseeba maqusa fee qimasee auqu ranau. ");
INSERT INTO bjr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isakeena faiqi indaaruqaafa mina auqu Eesaufa marinau. Mifa qaara fasiqa aiku asauku taikasee 40 aukuana maraseenoo Qeetaa maqannaa aanaaseeqara maranau. Moo anaasee auqu Yuditi nammarina Beerina araamuna maranau. Moo anaasee auqu Baseemata nammarina Eeroona aramuna maranau. ");
INSERT INTO bjr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Miqanda nári ninaakuquqara Isakeesa Reebeeka nammarisa sukaqara oosana nimufaqa nikooqanau. ");
INSERT INTO bjr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isakeefa mariiufanoo doo asooqaqoofanoo afu mandaikinau. Mariiufanoo moo kari narí indaaruqaa faiqi Eesauna aaroofanoo Eesaufa maqi qinau. ");
INSERT INTO bjr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Foo qimasoofanoo Isakeefa Eesauna qimaminoo qinau. Doo qinee asooqa marida, qeeqa kuqira aukuana sia qafaida, minara ani qimamiqa. ");
INSERT INTO bjr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","Aneenna duru feefa mareenana nandaki aandau aru maree qini didi marina mini suqa qiminaqa namseeqa ani afaaqooqa qimamaqaseeqa kuqua. ");
INSERT INTO bjr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Isakeefa Eesauna faqa ufa qiqiisoofanoo Reebeeka nammarifa iriseenoo qafoofanoo Eesaufa nandakinai uaqarara fufanoo quanda fufanoo Yakooboona qumee kai qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Doo maqee ani akoofa Eesauna maaqi qimasee qimaminoo, anee aandau arumaree mini suqa qiminaqa qinee namasee Karaambaiqa afusaa ani afaaqooqa amisee kuqua. ");
INSERT INTO bjr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Qini qimaaku doo anee qini ufa irisee qinee qianandee ia. ");
INSERT INTO bjr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Anee doo fua oonu mimmi aanaaqiuqa marianakinaana afaaqa faqaana qaaraqanda mini sainaqa qinee ani akoona aidi marina suqa saanana munu amia. ");
INSERT INTO bjr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Munu aminano namaseenoo narí afaaqooqa amiseenoo kuquani. ");
INSERT INTO bjr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakooboofa iriseenoo narí anoona qimaminoo qinau. Qini qifasaafa asausi faqaafa maridanoo asausi aadaiki marifa maridanoo. Qini qifaaqa qisausi sia maridanoo umooqu kammidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Abee qini qikoofa qini qifaaqa duqama qafamaseenoo iriannoo. Qiniara qikaru qidanoo fee qiannoo. Miqiqa qinee rairaiqirana qeeqa qifaaqai qifaaqooqara foora mara quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mina anoofa mi ufana iriseenoo qinau. Ani aqira ufa fannoo qinisaa kai mariannoo, sia anee minara iria, sandeenana oonu mimmi aanaaqi kaqi maree mini qimia. ");
INSERT INTO bjr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Miqi qima soofanoo Yaakooboofa eedoo qimasee mara maree mini soofanoo mina anoofa maraseenoo narí afaaqi Isakeena aidira narana suqanau. ");
INSERT INTO bjr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Reebeeka nammarifa aandau suqaseenoo Eesauna amiqira qamunna narí maaqaki quqaqoona maraseenoo Yakooboona afisu amaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Afisu amaqaseenoo mimmi aanaaqi apata qumareenoo Yakooboona afaarinni faqa asauku faqa asausi sia maruqoo afisu amaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Miqi mandeenoo mi adiafaaira naranna feemu namu faqa suqaqoona amufanoo narí akoo funnai maree finau. ");
INSERT INTO bjr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Oonureenoo narí akoona maaqi qimasee qimaminau. Qipoo doo qinee anireeqa, qufanoo Isakeefa qinau. Qini faiqi namukiqari anee yafee maridanee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakooboofa qinau. Qinee ani indaaruqaa faiqi Eesausa maridaqa. Doo anee aandaura qiannana arusee suqamaree anireeqa doo anee findi finana namasee qifaaqooqa qimia. ");
INSERT INTO bjr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Miqi qufanoo Isakeefa qinau. Oo qini qimaaku anee naqaa fee maseenanee kai kaqi paqurinanee qufanoo Yakoobofa qinau. Karaambaiqa ani Anutufa qini dadaaqi paqurimma qiminoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isakeefa minara iriseenoo Yakoobona aaramaseenoo qinau. Anee qini daaqa adeedi ani rainaqa qinee ani auqama qafaa. Kuqaa anee Eesau fee maridanee. ");
INSERT INTO bjr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Miqi qufanoo Yakooboofa narí akoona oorinni oonu kikiqamma fufanoo Isakeefa auqama qafamaseenoo qinau. Qinee irunanoo anee ufa qianafa ani Yakooboona aunda maridanoo ani asauku auqamasee qafaunanoo Eesauna asauku maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Yakooboofa mimmi asausi afisuqoofanoo Eesauna asaukuara foora asausi aanaaqi marufanoo Isakeefa sia irinau. Isakeefa narí afaaqooqa mina amirarammaseenoo kaifaa iramirinoo qinau. Anee kuqaa Eesau fee maridanee. Miqi qufanoo Yakooboofa qinau. Eeoo qinee Eesausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Miqi qufanoo Isakeefa qinau. Doo aneenna aandau mini qiminaqa namaseeqa afaaqooqa qimamaqaanaura. Yakooboofa irinoo aandau aina faqa uainna nammari faqa mini amufanoo nanau. ");
INSERT INTO bjr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Namaseenoo Yakooboona maaqi qimasee qimaminoo qinau. Qini qimaaku maaqoo adeedi ani reenana qini qimooqaa. ");
INSERT INTO bjr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Qufanoo Yakooboofa adeedi aaqa ani reenoo narí akoona amooqee marufanoo andanda unda afaaqaindari ufanoo udirama qafamaseenoo maaqi qimasee afaaqooqa qinau. Qini qimaaku afaaqai amiqira unda fannoo Karaambaiqa afaaqooqa qimamaqaqai maqana afundara foora idanoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Anutufa innaarunaindaraa qifi faramu quqasainanoo ani maqa ainoo ainoommaseenoo moomoo narana amiani. ");
INSERT INTO bjr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Moo aanaamuru marinausa ani ainainira faiqi kammambi faranoo. Maaqanna maaqanna mariasa misa ani ani qafeeqa noorindari maqasaa kummaree faranoo. Anee aneenna akaqaafasaauqa firaafai kina marinnaranoo. Ani anoona faiqi namu ani ani qafeeqa noorindari maqasaa kummaree faranoo. Moo fannoo ani aqinafa mi ufafa nariki kai mariannoo. Moo fannoo ani amiqi amiqimma amaqainafa nariki faqa mariani. ");
INSERT INTO bjr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Miqi qimasee Isakeefa Yakooboona afaaqooqa qimami soofanoo Yakooboofa narí akoona maaqakiqari raudamakufanoo dindanai fufanoo doo Eesaufa dindanai uaqanoo niniiufa aniranau. ");
INSERT INTO bjr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eesaufa anireenoo adiafaa ira aandau aina suqa mareenoo narí akoofuqoo oonu reenoo qinau. Qipoo doo findi finana namasee qifaaqooqa qimia. ");
INSERT INTO bjr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mina akoofa qinau. Anee yafee. Miqi qufanoo mifa qinau. Qinee Eesausa indaaruqaa faiqi maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isakeefa minara iriseenoo boo qimasee tautu maseenoo aindiri aindiri imarufanoo qinau. Yafee moo fannoo aandau arusee mini qimifaqa, namasaunana anee aniraananoo. Qinee namaseeqa doo qeeqa taikara afaaqooqa qimamaqasaunanoo naaru naaru minaindi mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eesaufa mina iriseenoo firaaqoo aundurai sukaqoofanoo qinau. Oo qipoo qini faqa qifaaqooqa qimia. ");
INSERT INTO bjr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Qufanoo Isakeefa qinau. Ani akaqa fannoo qikaru qimaseenoo doo ani afaaqooqa maree fifinoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eesaufa minara irufanoo Yaakooboonara arana qoofanoo qinau. Oo mina auqu Yakooboofa maridanoo narí auqu mau kaimbinoo qini ainaina qaara kari qini qikaru qimasee mareenoo. Indaaru mifa qinee indaaruqaa faiqi uriqararausa maraani qiafanna ainaina maroofa maqee miqi kai inoo qini qifaaqooqa qirana doo maree finoo. Miqi qimaseeno Eesaufa narí akoona qimaminoo qinau. Anee afaaqooqa sia fee qini faqa qiseenanee. ");
INSERT INTO bjr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Miqi qufanoo Isakeefa qinau. Doo qinee ani uriqararafa marianifee afaaqooqa amiseeqa. Kaifa mina ainaina mina ainainira faiqi kiaqee afaaqooqa faqa amiqa. Qinee oosana oosana narana faqa nammari faqa amiqa. Qini qimaaku, maqee sia moo ainaina marinaqa ani amianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eesaufa narí akoona kafaa kafaa iki raqaidanoo iranau. Moodaa afaaqooqa marinee aminanee sia fee moo qini faqa qiminnaree. ");
INSERT INTO bjr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isakeefa minara irinoo maaqi qimasee Eesauna qimaminau. Sia innaarunaindaraa qifi faramu anindi mariannoo. Sia ainoo faqaa maqa anindi mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Anee duru saamu uqeerasaidana aneenna amiqira marirana paqurinnaranoo. Miqidana anee aneenna akaqa ainainira faiqikina mariinana rakeemmaki aaduma finnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yakooboofa Eesauna afaaqooqa maree fifufanoo Eesaufa narí akaqara akoo qaidanoo fidiaqaammi marinau. Miqi marufanoo maaqi qimasee narí kai oonu mafi iriseenoo qinau. Kaqi kaaqoo maasa qikoofa kuqu finaqa soofaara taikaseeqa mikari qeeqa qikaqa kuqamma aruanaura. ");
INSERT INTO bjr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Reebeeka nammarifa mi ufana iriseenoo Yakooboona aaramaseenoo aaqu qimamaqeenoo qinau. Iria ani afasaafa Eesaufa afaaqooqara qimammareenoo ani aruannoo. ");
INSERT INTO bjr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Qini faiqi qinee qimamianandee ia. Anee quqasee sandeenana Qaraana maqusai qini qisookifa ani anaufa Rabannafa marinnai fua. ");
INSERT INTO bjr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Anee ooru miqoo marinanoo ani afasaana arana qarafa asooainana qumua. ");
INSERT INTO bjr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Anee mina mandaikamma amaqaannanara qaunusainaqa qinee akaqausa niiqaanaqa ani ooru afiqee qumuaqa. Qinee qikoo inneeqara moodaafa kuqiranara irunanoo qaifaqa doo quqasee fua. ");
INSERT INTO bjr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Miqanda ninoofa Reebeeka nammarifa oonu reenoo narí afaaqi Isakeena qimaminoo qinau. Qinee maa Qeeta maqannaa anaasee qandara Eesauna anaaqa qarara qikoo uqanna fidiaqaammidaqa. Yakooboofa Qeeta maqannaa anaasee maaqirana moo marainaqa qinee kuquanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isakeefa minara iriseenoo Yakooboona aaramaseenoo amandaidanoo qinau. Oo Yakooboo sia uqanna Kannaana maqannaa anaasee maraa. ");
INSERT INTO bjr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Doo findi finana ooru fua. Aneenna aanaakuna Beetueerana maqa maaqa Meesoopootamia maqa maaqaki ooruree aneenna anauna Rabannana araamuna maraa. ");
INSERT INTO bjr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Aiqama afeeka faqaa Anutufa ani faqa ani anaaqa faqa amiqi amiqimma nimaqaseenoo moomoo faiqi nimisainana anee moomoo maqannaasa nikoofa marinnara. ");
INSERT INTO bjr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Anutufa Abaraqaammana amiqi amiqimma amaqoondee inoo ani faqa amiqi amiqimma aisainana anee aneenna marianna maqa maaqana Anutufa Abaraqaamana amiqoonakinaa qumiasana maraa. ");
INSERT INTO bjr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Miqi qimaseenoo Isakeefa Yakooboona aiqoofanoo findifinoo Meesoopootamia maqa maaqai Rabanafa Beetueerana amaaku Arameea maqannaafa Reebeekaa nammarina asookifa marunnai oorufinau. Rebeekaa nammarifa Yakooboosa Eesausa ninoofa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isakeefa Yakooboona afaaqooqa amiseenoo Meesoopootamia maqa maaqai anaasee maraanifeera aqiqoonara Eesaufa irinau. Isakeefa afaaqooqa Yakooboona amiseenoo Kannaana maqanna anaasee sia maraannee qunara faqa irinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakooboofa narí anaukoo ufa irisee Meesoopootamia maqa maaqai funara faqa Eesaufa irinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isakeefa Kannaana maqannaa aanaaseera akooqee marunara Eesaufa irinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Iriseenoo Isamaeerafa Abaraqaammana amaaku marunnai oonuree mina araamuna auqu Maqarata nammarina maranau. Maqarata nammarina asookifa Neebaiootafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kaifa Yakooboofa Beeraseeba maqusaindari Qaraana maqusai firaree qimasee faiqanoo ooru fimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Fimarufanoo eendufanoo moosaa uiqaana araseenoo faiqanau. Faiqararinoo ooni firaana marasee qunu rumasee miqoo faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Faiqaqee idanoo qaina moo inau. Aana kisaaqa maqasaaqari innaarunai ooru marufanoo angiroouqa mimau ooruree qumuree imariqau. ");
INSERT INTO bjr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Karaambaiqa Yakooboona aakaarinni kikiqinoo maridanoo maaqi qimasee qimaminau. Qinee Karaambaiqa maridaqa, ani aanaakuna Abaraqaamana Anutusa maridaqa, ani akoona Isakeena faqa Anutusa maridaqa. Qinee maa maqa maaqana anee faiqaannana ani faqa ani aiku asauku faqa nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ani aiku asauku anisaa ani aruakinausa faqa nukudara foora maa maqanasaa marifaranoo. Misa miqooqari kambiqamaree suani oosana qaannai finanoo aramareenoo keeqee mari qaannai finanoo dinni dinni ataaqeenni finanoo miqi mambi amana kai marifaranoo. Ani faqa ani aiku asaukuaroo qiqa aiqama maqannaasa amiqimma nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Karaambaiqa kafaa qimaminoo qinau. Iria, qinee ani faqa maridaqa aiqamai finnannai anisaa rakisianaura. Rakisidaqa kaifaa ani mareeqee maa maqanasaa quqaanaura. Qinee sia ani minnisaanaura, qinee qeeqa qima afeekaikiafanna ufafa anoona kambiqainaqa quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Miqi qimsoofanoo Yakooboofa tautinoo findifinoo qinau. Karaambaiqa maaqoo maridanoo. Mifa maaqoo marinara qinee sia iridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakooboofa Anutuna ufa iriseenoo rufia rufia idanoo qinau. Maa maqa maaqafa daaquqara maqa maqaa maridanoo. Abee Anutuna maaqa mariannoo innaarunai fimaria kooqifa uqanna mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kananaana Yakooboofa findifinoo narí ooni qunu qumareenoo daaqoo auqaanifee qimasee maqasaa rakiqaseenoo Anutunaindi fee qimasee oorifa fadameena akuamaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Akuamaqaseenoo mi maqanara Beeteera fee qinau. (Mi auquna oosana Anutuna maaqa fee qinau.) Ooqai miqoora misa Rusa maqusa fee qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Yakooboofa mi maqana auqu ramaseenoo Karaambaiqara qima afeekaikinoo qinau. Qinee fimarianana anee qini faqa marida qinisaa rakisidana narana faqa qamunna faqa qiminaqa qinee amiqimmaseeqa qeeqa qikoona maaqai qumu raanana anee qini Anutufa marinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Maa daaqoo auqara oonina rakiqaunnana ani naaru amooqi fandinnaqoo mariannoo. Anee aiqama ainaina qiminaqa qinee qisaukuqarakinaana aninna amianaura. ");
INSERT INTO bjr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Miqi qimaseenoo innaaru qimaseenoo Yakooboofa suani oosana qaannai mariasa, misa maqa maaqai oonu ranau. ");
INSERT INTO bjr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Oonureenoo qafoofanoo nammari madika qusau saqanna marufanoo qaaramooki sipsipauqa mi nammari madikana afainni faiqaqeeufaqa misasaa rakisirausa miqoo rakisimariqau. Sipsipauqa mi madikanakinaa nammari neemariqau. Firaa ooninnoo mi madikana rafaaqafuqoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sipsipauqa aiqama moodaa qoo aniroofaqa sipsipasaa rakisirausa mi oonina quanda quandamma aqusee nammari nimisee kaifaa mi oonina quanda qundamma mafi rafaaqafi mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakooboofa sipsipasaa rakisi marusa oonu nindafeenoo qinau. Qini qikaqaafasaa, innee yaindaraasee maridaqee. Misa qiqau, maasa Qaraana maqusaindaraasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakooboofa iriseenoo qinau. Innee Naqoorana anaiqi Rabannanara iridee qufaqa misa qiqau. Eeoo maasa minara iridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Miqi qufanoo Yakooboofa qinau. Rabannafa amiqisaa fee maridanoo fee. Misa qiqau. Eeoo amiqisaa maridanoo. Mina qafaa, doo mina araamuna Raseera nammarifa mina sipsipauqa nifiqee anidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakooboofa misa sipsipa oosana qafeenoo qinau. Innee naqifee ifaqee sipsipa suani qambaana mara quqaqaafaqee maridee. Dauni nammari nimiseeqa mara quqasaifaqa misa fida qusau neeqa nifaaqa maraaqa. ");
INSERT INTO bjr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mi maqannaasa iriseeqa qiqau. Maasa sia miqianaura. Aiqama sipsipa maaqoo aniraifaqa ooni quanda quandamma aqusee nammari nimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakooboofa misa faqa ufa qimarufanoo Raseera nammarifa narí akoona Rabanna sipsipauqa nifiqee aniranau. ");
INSERT INTO bjr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakooboofa narí anoona Reebeeka nammarina asookina araamuna qafamaseenoo Rabanna sipsipa faqa qafamaseenoo findifinoo nammari madikaki rafaaqafuqoo oonina quanda quandamma mafi quqaseenoo Raseera nammarina sipsipauqa nammari niminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Nammari nimiseenoo Raseera nammarina ooriki amooqaidanoo asasirafa firaafa minaki marufanoo iki raqanau. ");
INSERT INTO bjr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Iki raqaseenoo Raseera nammarina qimaminoo qinau. Qinee ani akoona ati Reebeeka nammarina amaaku maridaqa. Raseera nammarifa mina ufa iriseenoo sandeenoo oonuree narí akoona qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Rabannafa narí anauqi Yakooboona ufa iriseenoo sandeenoo oonu mafi kaqaramma qumareenoo amooqaseenoo sukudaakutamasee afiqeenoo narí maaqai aninau. Miqoo oonu maridanoo Yakooboofa Rabanna aiqama ainaina kambiqoonara qimaminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Rabannafa iriseenoo maaqi qimasee qimaminoo qinau. Anee qini moodaa fidika mariananoo. Miqi qimasoofanoo Yakooboofa moodaa uqoona mina faqa miqoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Rabannafa maaqi qimaseenoo Yakooboona qimaminoo qinau. Kuqaa anee qini qinauqi mariananoo, sia fifau qini ainaina kai innaranoo. Maqee oosana araseeqa feefauru amiqambuanaura. Ani naqifee mandee feefauru amianauree. ");
INSERT INTO bjr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Rabanna araamuna qara qaaraqanda mariqau, indaaruqaafa Reeaa nammarifa marinau inaaqianaafa Raseera nammarifa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Reeaa nammarifa indaaruqaafa amiqira oori afiri faqaafa marinau. Raseera nammarifa mina faqa arusee kaaqa amiqirafa uqanna marinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakooboona irirafa Raseera nammarinara kai iri marufa marinau. Minara iriseenoo Yakooboofa Rabannana narí ainaini maruna akiiqara qimaminoo qinau. Amanee qinee Raseera nammarina maraanauree. Anee eedoo qinaqa qinee mina akiiqara qisauku dinni taikasee dinni ani qaara marasee 7 aukuana ani ainaina ianaura. ");
INSERT INTO bjr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Qufanoo Rabannafa qimaminau. Qinee amana ani amianaura, moo oosana nimiranara qikooqaidanoo. Doo anee qini faqa maridana ainainia. ");
INSERT INTO bjr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Rabannafa miqi qimasoofanoo Yakooboofa Raseera nammarina marararee qimaseenoo qisauku dinni taikaseenoo dinni ani qaara maraseenoo 7 aukuana mina ainaina maisee marinau. Yakooboofa Raseera nammarinara aidi marufanoo mi aukuanna namufa qaaramoo faasaanara foora aiqaranau. ");
INSERT INTO bjr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Dinni taikasee dinni ani qaara marasee 7 aukuana taikasoofanoo Yakooboofa Rabanna qimaminoo qinau. Doo qini maanaaqa qimiraree qunna aukuanafa aiqareenoo. Doo Raseera nammarina qiminaqa maraa. ");
INSERT INTO bjr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Rabannafa eedoo qimaseenoo narí araamuna amundaida oomaqa sakasee aiqama naaroofaqa ani naqau. ");
INSERT INTO bjr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mi eendanaki Rabannafa narí araamuna indaaruqaana Reeaa nammarina qumee Yakooboona maaqaki quqasoofanoo Yakooboofa auna Raseera nammarifa mifoo qimaseenoo mina faqa sakasee faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Rabannafa miqoo qaraasa oosana mareeno narí ainainira maanaaqa moo minauqu Siripaa nammarina mareeqee narí araamuna Reeaa nammarina ainaina maisaanifeera aminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Iaqoofanoo findifinoo Yakooboofa qafamaseenoo, boo Reeaa nammari fee qinau. Yakooboofa Rabanna funnai oonureenoo aqinoo qinau. Anee naqifee ifanee qini miqimma qimaqeenee. Qinee Raseera nammarina marararee qimasee ani ainaina maiseeqa. Anee nanaree qini qikaru q inanee. ");
INSERT INTO bjr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Rabannafa qinau. Maasa maaqoo qaraasa oosana sia miqinoo maridanoo. Indaaruqaana naaree amundaseeqa inaaqiannaana kasooaqee inaaqianna amundaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Anee Reeaa nammarina faqa kaqi marinanoo mina oomaqirafa 7 faasaana mariannoo. Taikainaqa miqoo kafaa Raseera nammarina faqa amianaura. Amianana miqooqari mina akiiqara anee oosana araseenana kaifaa dinni taikasee dinni ani qaara marasee 7 aukuana qini ainaina innaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakooboofa minara iriseenoo eedoo qimaseenoo Reeaa nammarina faqa mariufanoo qoomaqa narana taikoofanoo Rabannafa narí araamuna Raseera nammarina faqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Kafaa Rabannafa narí ainainira maanaaqa mina auqu Biriqaa nammarina mareeqeenoo Raseera nammarina ainainianifeera aminau. ");
INSERT INTO bjr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Amufanoo Yakooboofa Raseera nammarina faqa sakasee faiqanau. Yakooboofa Raseera nammarinara aidi marufanoo Reeaa nammarinara sia amiqimma aidi marinau. Miqidanoo Rabannana ainainiranaki kafaa qisauku dinni taikasee dinni ani qaara marasee 7 aukuanaki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Yakooboona irirafa Raseera nammarinasaa kai mundinoo marunara Reeaa nammarinara akoo akaa mimarinau. Miqi marunara Karaambaiqa qafeenoo dadaaqufanoo Reeaa nammarifa amuaqu qaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Reeaa nammarifa amuaqu qaikinoo mariiufanoo faiqi akoonaiqi maqanau. Maqaseenoo qinau. Karaambaiqa qiniara qimudaoo qinara qini qifaaqi fannoo maqee qinisaa atooqeenoo fee qianaura. Mi irirana iriseenoo mi faiqina auqu Reeubeena fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Reeaa nammarifa marikinoo kaifaa amuaqu qaikinoo mariiufanoo faiqi akoonaiqi moo maqanau. Maqaseenoo qinau. Qini qifaaqi qini ameesuqi marinara Karaambaiqa irinoo qiniara qimudaoo qimaseenoo maa faiqina qiminoo. Minara mina auqu Simeeoona fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Reeaa nammarifa marikinoo kafaa amuaqu qaikinoo mariiufanoo faiqi akoonaiqi moo maqaseenoo qinau. Doo maqee uqanna qini qifaaqi fannoo doo qinisaa atooqaannoo, qinee qaaramoo akoonaiqi maqaseeqa. Minara iriseeqa mi faiqina auqu Reefi nee qiqa. ");
INSERT INTO bjr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Reeaa nammarifa marikinoo kaifaa amuaqu qaikinoo mariiufanoo faiqi akoonaiqi moo maqanau. Maqaseenoo qinau doo maqee qinee Karaambaiqa amooqidaqa, maa faiqina auqu Yuda fee qidaqa. Reeaa nammarifa Yudana kai maqaseenoo mi kamuqoo kisaaqasaa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raseera nammarifa narí anasaana faiqi namu nindafeenoo Yakooboona aqinoo qinau. Anee faiqi sia qini mara qimianaqa qinee kaqi marianabaqa kuquanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakooboofa minara irufanoo arana qoofanoo qinau. Qinee Anutusau maridau. Anutufa kai ani itita amaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Miqi qimasoofanoo Raseera nammarifa qinau. Maa qini ainaini mari manaaqafa Biriqaa nammarifa marinoo qinee mina ani amiqa. Anee mina faqa faiqeenana faiqi mara amia. Aminanoo faiqi maqasainanoo qinindi kammiannoo. Miqimasee qinee faqa faiqi anausa marianaura. (Mi aukuannai mi maqannaasa oosana miqi marusa mariqau.) ");
INSERT INTO bjr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Raseera nammarifa miqi qimasee narí ainaini maru manaaqana mina auqu Biriqaa nammarina Yakooboona amisoofanoo mina faqa sakasee faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Miqimmasoofanoo Biriqaa nammarifa amuaqu qaikinoo mariiufanoo Yakoboona faiqi akoonaiqi maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Maqasoofanoo Raseera nammarifa qafamaseenoo qinau. Doo maqee Anutufa qini oosanara andeeqara oosana fee qimasee qini innaaru qirana iriseenoo doo akoonaiqi qiminoo. Miqi qimaseenoo Raseera nammarifa mi faiqina auqu Dannaa nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Mi manaaqafa Biriqaa nammarifa marikinoo kaifaa amuaqu qaikinoo mariiufanoo akoonaiqi moo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raseera nammarifa mina qafamaseenoo qinau. Qinee qeeqa qinasaana faqa firaaqoo rairai qimasee qinee uriaaqareeqee qimaseenoo mi faiqina auqu Napatari fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Reeaa nammarifa faiqi maqarana taikaseenoo narí ainaini maru manaaqana auqu Siripaa nammarina narí afaaqi Yakooboona mara aminau. ");
INSERT INTO bjr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Amufanoo minasaa faiqi akoonaiqi moo maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Reeaa nammarifa qafamasee qinau. Oo qini amiqimma qisainara mi faiqina auqu Kadafa nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Siripaa nammarifa marikinoo kafaa akoonaiqi moo Yakooboona faiqi maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Reeaa nammarifa mina faqa nariara maraseenoo qinau. Doo qinee firaaqoo asasidaqa. Maqee aanaaseeuqa qiniara asasirafee qimasee duqu reefaranoo. Minara iriseenoo mi faiqina auqu Aseera fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Reeaa nammarina amaaku Reeubeenafa sakumma neemaru kamuqoo andanda kinai nidanoo faiqi maqee maru andandana qaqama paqurinau. Mi aqamana auqu mandareeka marinau. Mina paqurimaseenoo mara mareenoo mini narí anoona Reeaa nammarina aminau. Raseera nammarifa mina qafamaseenoo Reeaa nammarina qimaminoo qinau. Amanee mandareeka qaqama akaqana qini faqa qiminnaree. ");
INSERT INTO bjr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Miqi qufanoo Reeaa nammarifa narí qimaminoo qinau. Anee qini qifaaqi marasaanafa kaifaa qini qimaaku mandareeka qaqama marararee fee qidanee. Miqi qufanoo Raseera nammarifa qinau. Ani amaaku marai mandareekana qaqama qini qiminaqa doo Yakooboona ani amiananoo ani faqa faiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Eenee marufanoo Yakooboofa ainainaindari aniroofanoo Reeaa nammarifa aanai oonu afiqeenoo anidanoo qimaminau. Doo qinee mandareeka qaqama Raseera nammarina amiqa. Mifa mina akiiqara maqee eendaki aniara qini faqa faiqaannee qinoo. Miqi qufanoo Yakooboofa eedoo qimasee Reeaa nammarina faqa sakasee faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Anutufa Reeaana innaaruqirana iriseenoo dadaaqufanoo Reeaa nammarifa kafaa amuaqu qaikinoo faiqi akoonaiqi maqanau. Moodaannai qisauku namu Yakooboonasaa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Reeaa nammarifa maqaseenoo qinau. Qinee qeeqa ainainira maanaaqa qeeqa qifaaqi amiafannanara maa faiqina Anutufa qini qiminoo. Mifa minara iriseenoo mi faiqina auqu Isakaranee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Reeaa nammarifa marikinoo kafaa amuaqu qaikinoo akoonaiqi moo maqanau. Dinni ani moodaa maraseenoo Yakooboonasaa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Maqaseenoo qinau. Anutufa idaaqira ainaina kaqi qiminoo. Maqee dinni qisauku taikasee dinni ani moodaa 6 maraunnanara qini qifaaqi qiniara aidiannoo. Mifa minara iriseenoo mi faiqina auqu Seeburuna fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mina aanaaqianna Reeaa nammarifa maanaaqa maqaseenoo Dinnaa nammari fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Miqooqari Anutufa Raseera nammarina innaaru qirana iriseenoo dadaaqufanoo faiqi maqarana amanaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Mifa amuaquqaika mafufanoo faiqi akoonaiqi maqaseenoo qinau. Anutufa qini qisaurirana taikeenoo qini faiqi akoonaiqi qiminoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Raseera nammarifa minara iriseenoo qinau. Karaambaiqa qini faiqi moo akoonaiqi qimiani. Miqi qimaseenoo mi faiqina auqu Yooseefaa nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raseera nammarifa Yooseefaana maqasoo kamuqoo Yakooboofa Rabanna maaqi qimasee qimaminoo qinau. Anee amanee qini quqasainaqa qeeqa maaqai fua. ");
INSERT INTO bjr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Qinee ani ainainammasaunana qimianna anaaseesa nári faiqi namu faqa qiminaqa maree fua. Qinee amiqimmasee ani ainaina iunnanara anee minara iri mariananoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Rabannafa minara iriseenoo qinau. Qini afunee fannoo aniara qima qimifaqa iriseeqa anee qini faqa marunnaqoo Anutufa qini ainaina amiqi amiqifanoo firaa qoo kambiqafinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Qinee minara iridaqa anee aneenna feefauruara qinaqa qinee ani amianaura. ");
INSERT INTO bjr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakooboofa mina iriseenoo kafaa qimaminau. Anee qini ainainirana oosana amiqimmasee irimariananoo. Qinee ani aandau ainasaa rakisi mariafananoo qini rakisirana ameemaanai marida moomoo kambiqee irairaa imariqau. ");
INSERT INTO bjr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Qinee aniafanna kari ani ainaina oodaa kai marinau. Qinee maaqoo ani maridaqa ani ainaina aiqamai auqaunanoo Anutufa dadaaqifanoo firaanaikinoo maridanoo. Qinee maqee qeeqaree qianna ainainausa maraanaura. ");
INSERT INTO bjr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Miqi qima soofanoo Rabannafa irinoo narí qimaminau. Doo anee qiananoo naqifee masee feefauru ani amianauree. Miqi qufanoo Yakooboofa qinau. Sia anee feefauru munnimma aina qini qimia. Qeeqa qiannana kai qimia. Qinee kaqi ani sipsipasaa rakisi marianana qini maa iriranara anee eedoo qinaqa ani sipsipasaa rakisianaura. ");
INSERT INTO bjr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Qinee maqee ani sipsipauqa mariannai oonuree aiqama takoosa takoosira sipsipauqa faqa mimmi miqiranauqa faqa sipsipa aanaaqi ruduqariranauqa faqa maraanaura. Mi feerunara kai qini dididanoo. ");
INSERT INTO bjr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Qinee andeeqasee maraanaura anee kasooaqee aneenna oonu reenana qafaa. Eekara arira sipsipa qinindiki marinana eekara fee dunduqarira mimmi fee qinindiki marinana qiniara qumuara miaanoo qia. ");
INSERT INTO bjr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Rabannafa mina iriseenoo asasa mandee qinau. Eeoo maasa anee qianandeemmianaura. ");
INSERT INTO bjr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mi faasaanna qumee kai mimmi akoona takoosa takoosa iranauqa faqa mimmi anaasee miqiranauqa faqa eekarasai runduqasai irana faqa runduqarira sipsipauqa faqa moodaanaki quqaseenoo narí faiqi namuara qufaqa misasaa rakisiqau. ");
INSERT INTO bjr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Rabannafa Yakooboonara maraandoo qimasee narí mimmi sipsipa mara mareenoo narí faiqi namusaa quqasoofaqa nianai qaaramoo afuru aanai faiqee oonuraaqaa irannai munu quqasee rakisi mariqau. Maree fifufanoo Yakooboofa akaqa sipsipauqa mafisoosasaa kai rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Rabanna sipsipasaa maqusai rakisida maridanoo saqari amimiuqa ateekaseenoo moodaa mau apata ruata aquseenoo eekara ari marutinai quandaseenoo sipsipa nammari nee maruqoo rakiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Sipsipa mimmi nammari naidaqa miqoo ani raidaqa naafeeqaambaaqaa rimariqau. Yakooboofa mi saqarisa sipsipauqa difaaniki nammari neemaruqoo rakiqaqoofanoo marufaqa sipsipauqa nammari narara anireeqa mi saqarina qafaidaqa akoonauqa anaasee naafeeqaambaaqaa riaqeera rakianau. ");
INSERT INTO bjr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mimmiuqaindi miqoo mina qafaidaqa akoonauqa anaasee naafeeqasoofaqa akarakaurira aanaaqiuqa maqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakooboofa sipsipauqa nifiqeenoo akarakaurira mimmiuqa maruqoo munusaina sipsipa akoonauqa akarakaurirana qafaidaqa anaasee sipsipa naafeeqasaifaqa miqirana maqaaqeera nifiqee finau. Miqi marunannoo Yakooboofa akarakaurira aanaaqiuqa narindiki mareeqaida aaduma quqee marufanoo moomooki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nifaaqauqa faqaa sipsipa faqa mimmi faqa naafee qaambaaqaa rirara ufanoo Yakooboofa mi saqari asaanausa mareeqee nammari neemaruqoo rakiqeesoofaqa minakiaqa nidaqa naafeeqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Nimudaani aanaaqi ummooqukiqa nusa naafeeqara rufanoo Yakooboofa sia mi saqarisa rakiqanau. Miqimmasee maru fanoo Rabananaindi amudaani aanaaqi ummooqukirafauqa kai marufanoo Yakooboonaindi nifaaqauqa faqaasa amiqirausa kai mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mi oosannanannai Yakooboofa moomoo akinaina faqaafa marinau. Mina sipsipa mimmi moomoo uqanna mariqau. Mina ainainira fasiqauqa faqa aanaaseeuqa faqa kammeerauqa faqa doonkiuqa faqa moomoo qumbiqaqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakooboofa irufaqa Rabanna faiqi namu misa Yakooboona ainaina moomoo qafamaseeqa aqidaqa qiqau. Yakooboofa maasa qikoonaindi aiqama mareeqee narinni quqeenoo. Yaindaraanee maa firaa qumiasanna mareenoo fee. Maasa qikoonaindi kai mareenoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakooboofa mi ufana iriseenoo quanda fufanoo Rabanna oori qafoofanoo sia ooqai undee oori runinoo marufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Mi kamuqoo Karaambaiqa Yakooboona qimaminoo qinau. Doo findi finana aneenna akoona faqa aneenna ainaina maqai fua. Anee finaqa qinee ani faqa marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yakooboofa mi ufana iriseenoo sipsipa rakisi marunnaindari Raseera nammarina faqa Reeaa nammarina faqa naaroofaqa oonu roofanoo qima niminau. ");
INSERT INTO bjr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ooqai inni nikoona oori sia runinoo mariufa maqee oori runifaqa qafaidaqa. Sia qiniara amiqi amiqidanoo. Miqimmi marifaqa qini qikoona Anutufa qini faqa mariufa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inneeqara irimariafanoo, qinee qeeqa afeekannai inni nikoona ainaini mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Miqi mariafanano mifa qini qikaru qimaseenoo qisauku qara 10 kari qini feefauru quandaqaandinoo. Miqi marifanoo Anutufa qifanoo sia qini mandaikamma qimaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Inni nikoona ainaina iafannana feefauru mina sipsipa nifaaqa takoosa takoosa irana kai mi aukuanna maqee marufaqa qinee mareeqee qeeqaindiki quqee mariqiafana. Inni nikoofa qini feefauruara nifaaqa akara kau rirausa kai maraannee qufaqa mina sipsipauqa mi aukuannai miqi ranauqa kai maqee marufaqa mareeqee qeeqara qeeqaindiki quqee mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Miqimma saafananoo Anutufa inni nikoona aandau aina mareeqeenoo qinindiki kai quqaqiseenoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Mimmi sipsipa nariqa araraiki maru anaana qinee qaina qafaafananoo mimmi akoonauqa aanaaseeuqa naafeeqee marufaqa qafaqiafana. Mi akoonausa aiqama akarakau rirausa faqa nifaaqa takoosa takoosa irausa faqa anaasee naafeeqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Qinee qainasaa qafaafananoo Anutuna angiroo moo fannoo qini daaroofaqa qinee maqi qiqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Foo qiafananoo qinau. Qafaa maa nifaaqa takoosa takoosira akoonauqa naafeeqaidaqa. Qinee Rabanafa ani mandaikamma amaqee marina qafamasee qunanoo maa ainainafa kambiqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Qinee ooqai Beeteera maqa maaqai ani afusaa koorooiafanna Anutusa maridaqa. Miqoo anee aaqoo auqara ooni rakiqasee oorifa fadameena minasaa adiasee qiniara qima afeekaikinau. Doo maqee indaammamaree aneenna maqusai anirandee anee kambiqoonna maqanasaa fua. ");
INSERT INTO bjr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raseera nammarisa Reeaa nammarisa qimannimi soofaqa Yakooboona ufa iriseeqa qimamiqau. Sia maasa qikoona qumiasana aina kaqi marinaqa maasa maraanaura. ");
INSERT INTO bjr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mifa maaqandara aanaamuruara foora midanoo. Doo mifa maaqandasaa feefauru mara mareenoo doo nariki kai taikeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Anutufa maaqanda qikoona kinaana mareeqee maaqanda faqa maaqanda faiqi namu faqa nimifanoo maasaindi kamminoo maridanoo. Anutufa ani qimamindee ia. ");
INSERT INTO bjr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakooboofa misa ufa iriseenoo narí akoona maqai Kannaana maqasaa firara deedaqinau. Mifa narí aanaaqmaaka faqa narí faiqi namu faqa kammeerauqa saa quqasee ooqu mari fufanoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yakooboofa narí mimmi sipsipa doonki kammeera aiqama Meesoopootamia maqusai marida maroo ainainausa aiqama mareeqee oorinni quqaseenoo doo narí inaaqianna Kannaana maqa maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Rabannafa narí sipsipa asausi moosaa oonu aukirara fifufanoo Raseera nammarifa narí akoona maaqaki keeqa fufanoo narí akoona afunee ainaina maaqaki quqaqoona qumee kai mara mareenoo kukeeqa mareenoo Yakooboona faqa sia qimamirai doo mara mareenoo narí afaaqi faqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakooboofa Rabannana akaru qimasee sia qimamirai quqasee finau. ");
INSERT INTO bjr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yakooboofa narí ainaina namu faqa mareenoo kai kaqi ufanoo finau. Fifii ufanoo Eeufarateesa nammari taqa mareenoo dinni afainni oonu ranau. Doo miqooqari Kiriata aaqana qaannai oori ubeekamafi finau. ");
INSERT INTO bjr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Qaarammoo faasaana aiqaroofanoo Yakooboofa sandoonara Rabanna qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Rabannafa minara iriseenoo narí aiku asauku aiqama nifiqee Yakooboona aanaaqiana afaqee finau. Dinni taikasee dinni oonu qaara marasee 7 afuru aanai fi faiqeenoo afaqee finoo oonu Yakooboona paqurinau. Kiriata aaqana moo amuaqu namusaa paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Rabannafa aanai faiqaqee ufanoo mi eendanaki Anutufa qaina afunnareenoo qimaminau. Anee sia Yakooboona manda ufa amia. ");
INSERT INTO bjr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakooboofa aaqanasaa narí uiqaana maqa usakaseenoo marufanoo Rabannafa narí ainaina faqa oonu reenoo mifa faqa narí uiqaana maqa Kiriata amuaqu namusaa usakanau. ");
INSERT INTO bjr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Usakaseenoo Rabannafa oonu reenoo Yakooboona qimaminoo qinau. Naqi fee ifanee qini qikaru qimaseenee qini qiraamuqmaaka rakiranakiara foora rarisamammaree sandeenee. ");
INSERT INTO bjr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Naqi fee ifanee sia qima qimirai qikaru qimasee qumee quqasee sandeenee. Anee qini qima qiminaqau qinee idi namu faqa asasirana namu faqa piripunna faqa dukaanaa faqa aridaqau aiqani. ");
INSERT INTO bjr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Anee sia qini qima qimianaqa qeeqa qinaiqi mara faqa qeeqa qiraamuna qara faqa nimooqa saanana nifiqee aniaqaana. Anee furufarira ainaina auqaananoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Qinee ani mandaikamma amaqara afeeka marifaqa marunanoo eenda eendaki ani akoona Anutufa qini rafaaqafu seenoo qinoo. Anee sia uqanna Yakooboona mandaika mamaqaa qifaqa sia mandaikamma amaqaanauara. ");
INSERT INTO bjr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Qinee iridaqa anee aneenna akoona maqa maaqara oonu mafi iriananoo aundura dapikifana qini qisee sandaananoo. Naqaa fee ifanee qini maaqaki rakisi maria anutusa ummuara mamaree aninanee. ");
INSERT INTO bjr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakooboofa iriseenoo qimaminoo qinau. Qinee aniara narí araamuna qara rafiqaandoo qimasee rufiasee sandeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ani maaqaki rakisi maria anutusa marainnana paqurimmaseenana kuqa arua. Doo qini qiku qisauku nifusaa qini ainaina moodaa moodaa mara quqaseenana aneenna ainaina paqurimmasee maraa. Yakooboofa Raseera nammarifa narí akoona Rabannana unnaqira anutusa ummuarunara sia irirai miqi qinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Rabannafa Yakooboona uiqaana maqaki keeqa fufanoo randoosia sia paqurinau. Miqooqari Rabannafa Reeaa nammarina uiqaana maqaki keeqafi randoosia. Kafaa miqooqari ainainira maanaaqaqara uiqaana maaqaki faqa keeqafi randasee sia paqurinau. Miqooqari Rabannafa Raseera nammarina uiqaana maaqaki keeqafinoo randanau. ");
INSERT INTO bjr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raseera nammarifa Rabannana maaqasaa rakisi maru anutusa mareeqeenoo kammeera saririqa maaqaki quqaqoona uqeeraseenoo minaki kukeeqaseenoo minasaa ooqu faaqee marinau. Rabannafa Raseera nammarina uiqaana maqaki aiqama ainainaki randasee qafoofanoo sia marinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rabannafa randeemarufanoo Raseera nammarifa narí akoona qimaminoo qinau. Oo qipoo sia qinee findi fuanana sia qini diqia. Qinee qimaaqai qafaidaqa sia findi fidaqa. Miqi qufanoo Rabannafa aiqama ainainaki randoosia sia paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sia paqurufanoo Yakoobofa amambaina qimasee aanoo qidanoo qinau. Qinee nana aaqaranee maree fee. Nana sandufee rukiasaunana aranaqaifanee qiniara randamaree qumidanee. ");
INSERT INTO bjr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Anee qini ainainaki randeesee doo fee aneenna ainaina paqurinanee. Doo mina mareeqeenana aneenna faiqi namu nifusaa faqa qini faiqi namu nifusaa faqa quqasee ufa qida qafaa, yafee andeeqeenoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Qinee moodaa fasiqa aiku asauku taikasee 20 aukuana ani ainaina imariqiafana. Mi kamuqoo ani sipsipa ani mimmi sia moo fannoo dapi maqee mariqau, amiqi kai mimariqau. Sia ani sipsipa akoona moo arusee naqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kaasau faini ani sipsipa arusoofaqa qinee mina amudaani apata siamma ani uqafiqee mariqiafana qeeqaindi kai moo mareeqee mina amaaqa maqeeqa anindiki quqee mariqiafana. Ummuara fasiqa eendaki fee faasaana fee ummuara masoofana anee qiniara qunaqa qinee qeeqaindi mareeqee anindiki quqee mari qiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Qinee moomoo kari ani ainaina imariafananoo suani darinoo eendaki suara darinoo miqi marufaqa sia faiqee mariqiafana. Miqidaqa ani ainainasaa rakisi mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yakooboofa qimamidanoo qinau. Qinee moodaa fasiqa aiku asauku taikasee 20 aukuana ani ainaini mariafanausa marida. Qisauku qara taikasee qikunooqu qaara faqa qaara faqa marasee 14 aukuana ani araamuna qara mararara ani ainainiaafanausa maridaqa. Dinni taikasee dinni oonu moodaa marasee 6 aukuana ani sipsipa mimmi mararara kaifaa ainaini qiafana. Miqi mariafanana anee qisauku qara taikasee 10 kari anee qini feefauruara qikaru maakaru qimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Abaraqaammana Anutufa qini qikoona Isakeena Anutufa sia qini dadaaqinanau anee qiniara kaqi samu fua qinaqau qinee kaqi samu fini. Anutufa qini ummaara faqa qini kadaapirirana faqa qiqafamaseenoo eenda eendaki narí ufa irirana ani aminoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Rabannafa Yakooboona mi ufana iriseenoo qinau. Maa ani anaaqa qara qini qiraamuna qara maridaqa maa ani faiqi namu qini qinaiqi mara maridaqa maa ani sipsipa qinindi uqanna maridanoo, maa aiqama ainaina anee marana nuanafa aiqama ainaina maaqoo marifa qinindi kai maridanoo. Qinee sia amana qeeqa qiraamuna qara faqa qinaiqi mara faqa rafaaqa fuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Doo maqee ani faqa moodaanaki ufa qirara deedaqidaqa. Anindiri ooni aaku aakummasaananoo mifa maasa moodaanaki kira ufara daaqoo auqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakooboofa minara iriseenoo eedoo qimaseenoo ooni firaatia qumaree kuradama seenoo daaqoo auqara ooni fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Miqimmaseenoo Yakooboofa narí ainainira faiqiuqara qufaqa ooni moomoo suqusee aaku aaku iqau. Miqimmasee mi ooni aaku aaku irana aakaarinni ooqumarifi narana naqau. ");
INSERT INTO bjr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Namaseeqa Rabannafa mi oonisa auqureenoo Yageer Sahadutaa fee qimasee narí ufakiqari auqu ramasoofanoo Yakooboofa narí ufakiqari Gareeda fee qinau. (Mi nuquna oosana daaqoo auqara ooni fee qimasee nári ufakiqari auquraqau.) ");
INSERT INTO bjr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Rabannafa Yakooboona qimaminoo qinau. Maa ooni aaku aaku irafa anindiri daaqoo auqarafa mariannoo. Minara mi maqusana auqu Gareeda fee qianaura. ");
INSERT INTO bjr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Rabannafa kafaa maaqi qinau. Karaambaiqa fannoo maaqanda daraaniananoo mina afu fannoo maasasaa mariani. Miqi qimaseenoo mi maqusana auqureenoo Misipaa fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Rabannafa maaqi qinau. Anee qini qiraamuna qara mandaikamma nimaqeennaree moo anaasee fee mareennaree, qinee sia minara iriananoo Anutufa anindirisaa rakisidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Maaqoo qinee ooni aaku aaku maqaunanoo anindiri qara qambaana maridanoo. Maaqoo daaqoo auqara ooni rakiqarafa faqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Maa ooni aaku aaku irafa faqa rakiqarafa faqa anindiri daaqoo auqarafa maridanoo. Qinee sia mina fiaaqaree ani aruanaura. Anee faqa sia mina aiaaqaree qini darua. ");
INSERT INTO bjr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abaraqaammana Anutufa faqa Naqoorana Anutufa faqa maasa qambaana andeeqa qisaannoo. Rabannafa miqi qufanoo Yakooboofa qinau. Qini qikoofa Isakeefa innaaru qimamaqee mari Anutuna auqusaa qimasee afaqaanauree qimasee qima afeekaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Miqi qimaseenoo Yakooboofa aandau aruseenoo mi aaqannasaa Anutuna aandau tatufusee suqaminau. Suqa amiseenoo Yakooboofa narí aiku asauku naaramasoofaqa moodaaqoo ooqu mari fufaqa mi aandauna ataraasa naqau. Namasee mi aaqannasaa faiqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kananaana findifufanoo Rabannafa narí anaiqimara faqa araamuna qara faqa nimooqa namasee nimandamasee amaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakooboofa miqooqari findi fufanoo narí anaukoo unnai aanai fimaru fanoo Anutuna angiroouqa aanai ani paquriqau. ");
INSERT INTO bjr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakooboofa nindafamaseenoo qinau. Maa maqa maaqafa Anutuna uiqaana maqusa maridanoo. Miqi qimasee mi maqusana auqureenoo Maqannaimmee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakooboofa narí faiqi namu qaaramoo ufa maree narí afasaafa Eesau funnai fuaqeera niiqoofaqa Eedoomma maqa maaqai fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Miqoo qini qifasaana paqurimmasee qini maa ufana qimamiaqa. Qinee Yakooboosa ani ainainira faiqi maaqi qimasee ani Eesauna qini uriqararana qimamidaqa. Qinee Rabannana faqa maridaqa anirara masaidaqa mariifaqa maqee anidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Qinee burimmakau faqa doonkiuqa faqa sipsipa faqa mimmiuqa faqa ainainira faiqiuqa faqa faqaasa maridaqa. Qinee aniara ufa quqaidaqa qini uriqararafa qini maa ufafa ani asooamamaqaanifeera qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ufa mareefu fasiqausa oonu randee aniree Yakooboona maaqi qimasee qimamiqa qiqau. Doo maasa ani afasaana qimamisaunanoo mifa narí ainainira fasiqauqa maqi handareeta 400 namu faqa maasa inaaqianna anidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakooboofa mi ufana irufanoo aaququqoofanoo moomoo irirana maranau. Miqufanoo narí sipsipauqa faqa mimmiuqa faqa burimakauqa faqa kammeerauqa faqa qaaraki raina quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Maaqi qimasee qimirinau. Eesaufa anireenoo moo usiranaki narinaqa moo usiranakiqari amana sandeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Miqimmasee Yakooboofa maaqi qimasee innaaru qinau. Oo Anutu, qini qinaakuna Abaraqaammana Anutufa qini qikoona Isakeena Anutufa qini innaaru iria. Karaambaiqa anee qini qima qimiananoo aneenna maqa maaqai aneenna ainainiannai finaqa qinee aiqama ainaina andeeqa aisaanauranoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Oo Anutu anee qini amiqi amiqimma qisarana faqa ani mapukira dadaaqiranara faqa irunanoo uriqaraifaqa qinee oorudupiqa maridaqa. Qinee ooqai Yooradanna nammari qeeqa saunu kai uqirausa taqaqiafana doo maqee qinee qaaraki rainarausa faqa anidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Qinee qeeqa qifasaana Eesauna asaukukinaana asumu mara quqaqisaanneera innaaru qidaqa. Qinee minara rufiaidaqa. Mifa anireenoo maasa faiqi anaasee faqa aiqama daru taikaandoora rufiaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Anee maaqi qimasee qiniara qima afeekaikinau. Ani aiqama ainaina andeeqamma aisaanauranoo fee qinau. Ani moomoo faiqi asumu amianaqa sia amana moo fannoo asaana ruannoo, nukudara foora sia kasoo uqanna marifaranoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakooboofa miqi qimaseenoo innaaru qimaseenoo mi eendanaki miqoo faiqeenoo iaqoofanoo narí aandau Eesauna amiraree qimasee raina quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mifa mimmi anaasee 200 faqa mimmi akoona 20 faqa sipsipa anaasee 200 faqa sipsipa akoona 20 faqa raina aaduma quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Miqimmaseenoo kaifaa kammeera anaasee 30 faqa nári aanaaqi naamma neemarusa faqa burimakau anaasee 40 faqa akoona 10 faqa doonki anaasee 20 faqa akoona 10 faqa raina quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Yakooboofa raineeqeenoo aandau oosana oosana naadu naadu kai quqaseenoo narí ainaini maru faiqisa moodaa moodaa mareeqeenoo minauqasaa rakisiaqeera quqanau. Quqaseenoo maaqi qimasee qimanniminoo qinau. Innee qini qifunni fidaqa adaaraika masaidaqa niana niana maridaqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","18","Miqi qimaseenoo Yakooboofa indaarufu faiqina qimaminoo qinau. Qini qifasaafa Eesaufa paquri maseenoo irainana yafee ani uriqararafa maridanoo fee yaifee anee fidanee yana aandauqee anee maree fidanee, qinana anee maaqi qimasee narí qimamia. Maa ainausa ani ainainira faiqi Yakooboooonaindi maridanoo. Mifa narí uriqararana Eesauna amiannee qimasee quqasaifaqa maree anidaqa. Yakooboofa narí inaaqianna anidanoo mifoo qia. ");
INSERT INTO bjr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakooboofa indaaru fu faiqina qimamundee kai minoo mina aanaaqiana fusa faqa miqi kaimmasee qimanniminau. Innee Eesauna paqurimmasee miqi kaimmasee qimamiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Innee maaqi qiaqa. Eeoo ani ainainira faiqi Yakooboofa inaaqianna anidanoo mifoo qiaqa. Yakooboofa narí kai oonu mafi irinoo qinau. Qinee maa ainainausa amiannanannoo mina irirana quandasaananoo qiniara amiqi amiqiani. Qinee mina paqurimasaananoo aqbee mifa qini numooo minniqisaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Eesauna amaqoo ainainausa indaaru fifufanoo doo narí miqoo mi uiqaana maqusanaki faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Mi eenda amuqusanai Yakooboofa findi fufanoo narí anaaqa qara faqa narí ainainira anaasee qanda faqa narí faiqi namu qisaukuqara taikasee qikunni ooqu moodaa marasee 11 nifiqamareenoo Yabooka nammari fitaqamareenoo muqu afainai munu nisanau. ");
INSERT INTO bjr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Munusee niiqamasoofaqa fufanoo narí aiqama aandauqa faqa mara quqasoofaqa misa faqa taqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Taqa nimaqaseenoo naríara dinni afainni kaqi marinau. Marufanoo faiqí moo fannoo anireenoo aitata fufanoo Yakooboona qumaranau. Uaqeeidanoo narí rudammiqi narí rudammiqi idamarufanoo iaqarafa adeedi ranau. ");
INSERT INTO bjr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Sia mi fasiqafa Yakoboona uraaqaranau. Miqi usianoo asauku samu Yakooboona upisuna aranaiqi arinau. Miqubaqa Yakooboona upisuna arufanoo amudaani ootuparafa aikatamafufanoo raaqee raaqee inoo ninau. ");
INSERT INTO bjr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Iaqoofanoo mi fasiqafa Yakooboona qimaminau. Doo qini quqasainaqa fua, doo iaqarafa adeedi reenoo. Yakooboofa iriseenoo qinau. Sia ani quqaanaura. Anee qini qifaaqooqa qima qimaqasainaqa quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mi fasiqafa Yakooboona qimaminoo qinau. Ani auqu yafee. Aneenna auqu rainaqa iria. Yakooboofa qinau. Qini duqu Yakooboosa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Miqi qufanoo mi fasiqafa qinau. Maqee maaqooqari Yakooboofa taikaannoo ani auqu Isaraeerafa marinnaranoo. Anee Anutuna faqa faiqí faqa aitatafi qumaraanannannoo uriqararafa marianaqa minara ani auqu Isaraeera fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Miqi qimasoofanoo Yakooboofa mi fasiqana qimaminoo qinau. Aneenna auqu qimaqimia. Miqu qufanoo mi fasiqafa qinau. Nanaree anee qini duqu irirara iraidanee. Miqi qimaseenoo Yakooboona afaqooqa qimama qaseenoo doo quqaseenoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Mi fasiqafa fifufanoo Yakooboofa qinau. Qinee Anutuna oori qafamaseeqa sia kuqiqa kaqi maridee qimaseenoo miqoo auqureenoo Peenieera fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Suani afu ururoofanoo Yakooboofa Peenieera maqa quqaseenoo upisuna aidafi marufanoo reetaa reetaa qinoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Miqooqari oosana arasee Isaraee maqannaasa sia aandau upisunakinaa amaqi neemariqau. Maqee faqa sia naidaqa. Anutuna angiroo fannoo Yakooboona upisunaki arunara iridaqa sia naidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakooboofa qafoofanoo Eesaufa 400 fasiqa faqa aninau. Yakooboofa mina qafamaseenoo narí faiqi namu rainasee Reeaa nammarina faqa Raseera nammarina faqa ainainira anaasee qaaraqanda faqa niminau. ");
INSERT INTO bjr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nimiseenoo indaaru narí ainainira anaasee qara faqa nári faiqi namu faqa niiqoofaqa fiqau. Misa ninaaqianna Reeaa nammarifa narí faiqi namu faqa finau. Inaaqianna uqanna Raseera nammarifa narí faiqi Yooseefaana faqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakooboofa misa noorinni indaaru finau. Oonu reenoo dinni taikasee dinni oonu qaara marasee kari maqasaa mapaminoo fifiufanoo narí afasaafa maruqoo oonuranau. ");
INSERT INTO bjr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Eesaufa Yakooboona oori qafamaseenoo sandamammareenoo ani kaqaramma qumaraseenoo amooqananau. Miqanda aiqama qara qiki raqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Qiki raqaseenoo Eesaufa quanda fufanoo Yakooboona faiqi anaasee nindafamaseenoo qinau. Maa ani faqa aniasa yausee maridee. Qufanoo Yakooboofa qinau. Oo uriqararafa maa faiqi anaaseesannoo Anutufa qini amiqi amiqimma qimaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Miqi qimarufanoo Yakooboona ainainira aanaaseeqara nári faiqi namu faqa Eesauna oorisaa ani ninuka tuqu naumoo amisee reendeeniqau. ");
INSERT INTO bjr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Miqanda ninaaqianna Reeaa nammarifa narí faiqi namu faqa anireenoo miqinau. Mina aanaaqianna uqanna Raseera nammarifa narí faiqi Yooseefaana faqa anireenoo miqikai inau. ");
INSERT INTO bjr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Miqima soofanoo Eesaufa Yakooboona maaqi qimasee qimaminau. Faasai qafaunna aandausa oosana naqaa fee inoo maridano fee qufanoo Yakooboofa qinau. Ani aqoondikiraree qimasee kaqi ani amidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Miqi qufanoo Eesaufa narí qimaminoo qinau. Qinindi moomoo maridanoo aneenaindi aneenna kai maraa. ");
INSERT INTO bjr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Miqi qufanoo Yakooboofa qinau. Qinee ani aqoondikiqa amunna ainainausa kaqi maraa. Anee qini kaaqa aqoondi kiannanara qinee ani oori Anutuna ooriara foora qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Qinee ani amiraree qimasee maree anunna ainainausa maraa. Anutufa qini amiqi amiqimma qiseenoo qini didimari aiqama ainainausa qiminoo. Yakooboofa maraanifeera afeekaiki marufanoo Eesaufa maranau. ");
INSERT INTO bjr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Eesaufa Yakooboona qimaminau. Doo uqeeraina anindiri fua qinee ani oorinni fuanana anee qini qinaaqianna ania. ");
INSERT INTO bjr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Qufanoo Yakooboofa qinau. Oo qini uriqararafa anee iria, qini faiqi namu ummooqukiqa mariafaqa qinee sipsipa faqa misa aanaaqiuqara faqa iridaqa. Misa moodaa faasaana rarisaqa fimarianaqa aiqama aandauqa kuqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Anee indaaru finaqa qinee ani afaqee kasooaqee qeeqa aandauqa faqa faiqi namu faqa fifiinaqa Eedoomma maqa maaqaki ani paqurianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Miqi qufanoo Eesaufa qinau. Doo amana qini faiqi namu akaqausa ani dadaaqi fifaranoo. Qufanoo Yakooboofa qaoo qinoo qinau. Qinee ani aqoondikunnanara minara kai firaa ainainee qidaqa. Doo amana qeeqa kai fuanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eesaufa mi ufana iriseenoo doo mi faasaanna kai anirandee narí maqa maaqai Eedoomma maqa maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Miqufanoo Yakooboofa Sukoota maqa maaqai oonureenoo narí maaqa faqa narí aandau auqaana faqa usakanau. Minara mi maqusana auqureenoo Sukoota fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakooboofa Meesoopootamia maqa maaqaindari oonurandee amiqimmaseenoo Kannaana maqa maaqai Seekeemma maqusaki anireenoo narí uiqaana maqa mi maqusana adeedi usakanau. ");
INSERT INTO bjr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Usakaseenoo Yakooboofa mi maqana Amoorana Seekeemana akoona aiku asauku unnai wan handareeta 100 siruaa munnimmannoo feefaurinau. ");
INSERT INTO bjr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Feefauru maseenoo tatufirana suqara qainda auquseenoo mi kaqikaa maqusana auqureenoo Eeraa fee qinau. Mi auquna oosana Isaraee maqannaasa Anutu fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Moo kari Dinnaa nammarifa Yakooboosa Reeaa nammarisa niraamuna fannoo Dinnaa nammarifa Kannaa maqannaa aanaaseeuqa nindafaanee qimaseenoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Seekeemmafa Amoorana amaaku Qifina aiku asaukukinaafa mi maqa maaqanakinaasa uriqararafa Dinnaa nammarina aanai paqurimaseenoo rarisanau. ");
INSERT INTO bjr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mifa qafoofanoo Dinnaa nammarifa kaaqa amiqirafa marufanoo amuqusa mandaikufanoo amiqira ufannoo mi manaaqana amuqusa reendeenianee qimasee amiqira ufauqa qinau. ");
INSERT INTO bjr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Seekeemmafa narí akoona Qamoorana qimaminau. Anee maa manaaqana feefaurumma qiminaqa qinaaqara maraa. ");
INSERT INTO bjr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakooboofa narí araamuna Dinnaa nammarina rarisoonara iriseenoo kasoo inoo marinau. Narí faiqi namu narí aandausaa rakisi marusa nianai marufanoo nifeesi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Seekeemmana akoofa Ammoorafa Yakooboona faqa ufa qirara finau. ");
INSERT INTO bjr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Oonuroofaqa kai Yakooboona faiqi namu aandausaa rakisiusa aniraqau. Misa Dinnaa nammarina rarisoonara irufanoo sia faiqí auqaaqaa ira ainaina marufaqa kaaqa niranaqeenoo nifai sandurinau. Seekeemmafa Yakooboona araamuna rarisoonannoo Isaraee maqannaasa nuqu mara maree quminau. ");
INSERT INTO bjr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Qamoorafa maaqi qimasee Yakooboona qimaminau. Qini qimaaku Seekeemmana irirafa ani araamunara firaaqoo aqufifaqa ani qimamidaqa. Amanee mina maraannoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Sainaqa maasa moodaanaki kira ufa qimasaanaqa kaqi ani maqannaa faqa qini maqannaa faqa kaqi narí maree narí maree iaqa. ");
INSERT INTO bjr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Miqi mandaanaqa innee maa maqanasaa maridaqa kaqi dapi maa maqa maaqanaki oonuree aniree idaqa maqa akausa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Seekeemmafa Dinnaa nammarina akoona faqa asooqmaaka faqa qimanniminoo qinau. Innee qini didi marindee masaifaqa inni nidi mari ainaina nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Inni nidi mari ainainnara qimaqimifaqa nimianaura. Firaa feefauruara qifaqa nimianaura. Innee qiniara mina maraannee qimasee innee iraifandinna ainainna kai nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Miqi qimasoofaqa Yakooboona faiqi namu nári nisookina rarisoonara iriseeqa akaru qira ufa Seekeemmana faqa mina akoona Amoorana faqa qimannimiqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Maaqi qimasee qimamiqau. Maasa sia amana qeeqa dauna nifaaqa ati sia aukirausa nimianaura. Miqiqa maasa firaaqoo qisauruanoora. ");
INSERT INTO bjr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Innee maasa daanna reeqa inneeqa faiqi namu nifaaqa ati aukusaifaqa minara kai maasa eedoo qianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Miqimmasaifaqa maasa inniara eedoo qimasee inni faqa narí maree narí maree ifaranoo. Maasa inni qambaana maridaqa inni faqa moodaa maqannaa marianauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Innee sia mi ufanara eedoo qimasee nifaaqa ati ateekaifaqa maasa qeeqa dauna afiqamaree doo fuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Mi ufausara Qamoorafa faqa mina amaaku Seekeemmafa faqa iriseeqa amanee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Seekeemmafa kai kaqi uqanna inoo misa qimamundee inau. Mifa Yakooboona araamunara aidi marunara miqinau. Seekeemmafa narí aiku asaukukiqari kaaqa uriqararafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amoorafa narí amaaku Seekeemmasandiri ufa suqimaru maqusanasaa faandaaura kooqiki oonuree nári maqusanaki marusa maaqi qimasee qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Maa fasiqausa aqoondiuqa maridaqa. Saifaqa maa maqanasaa maridaqa mana mana iqa nuaqa. Maa maqafa firaafa maridanoo. Misa faqa amana marifaranoo. Maasa misa niraamuqmaaka maraanaqa misa faqa maasaindi mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Maa fasiqausa maasa qambaana marirara eedoo qidaqa moodaa mariranaki mariranara eedoo qidaqa. Maasa misa naanna reeqa qeeqa faiqi namu akoonaiqiuqa nifaaqa ati ateekaaqeera qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Maasa miqianaqa misaki sipsipa burimakau aina marifa maasaindi kammiannoo. Anifaqa eedoo qianaqa maasa qambaana mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Aiqama mi maqusanakinaasa Qamoorana faqa Seekeemmana faqa ufa iriseeqa eedoo qimasee aiqama akoonaiqi qisakoosa nifaaqa ati auku aqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Qaarammoo faasaana aiqaroofaqa nifaaqa ati aukuqoosa firaaqoo nammuana nidafi marufaqa Yakooboona amaaku qara Simeeoonafa faqa Reefifa faqa miqanda Dinnaa nammarina asooki qanda nári faaqaana qara mara maree umee kai Seekeemma maqusai ooru reeqara aiqama faiqí kumaaraa naru taikaqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Qamoorana faqa Seekeemmana faqa narusee Dinnaa nammarina Seekeemmana maaqakinaana afiqamaree doo quqasee fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Narusoofaqa Yakooboona faiqi namu akaqausa inaaqianna oonu reeqa nári nisookina rarisoona akiiqara mi maqusanakina aiqama ainaina maraqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Misa sipsipauqa faqa burimmakauqa faqa doonkiuqa faqa aiqama ainaina mi maqusanaki maruna faqa mi maqusana atiqara maru ainainausa aiqama maraqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Misa aiqama amiqira ainaina kai maraqau. Aiqama faiqi anaasee faqa maraqau. Aiqama maaqakinaa ainainauqa faqa maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakooboofa miqunara irinoo Simeeoonna faqa Reefina faqa maaqi qimasee qimanniminau. Inneeqara qini ummaaraki quqaqisaafanoo. Kannaa maqannaasa faqa Peerisaa maqannaasa faqa aiqama maa maqa maaqanaki mariasa qiniara fidiaqaammifaranoo. Qini faiqí sia moomoo mariafaqa, misa aiqama moodaanaki aniree qini dariqa aiqama maasa faiqi anaasee kuridi nimaqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yakooboofa miqi qufaqa miqanda narí qimamiqa qiqau. Maasa sia qeeqa qisookina quqaqaanaqa aanasaa aanaaseera foora kaqi maraqa nifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mi fasannai Anutufa Yakooboona qimaminoo qinau. Anee doo findi finana Beeteera maqa maaqaki oonu maria. Anee aneenna afasaana Eesaunara rufiasee sandoonaqa ani afusaa kooroo iafanna Anutusa tatufirana suqaqimira qainda miqoo oonuree auqua. ");
INSERT INTO bjr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yakooboofa iriseenoo narí aiku asauku faqa narí faqa marusa faqa qimanniminoo qinau. Moo maqannaasa unnaqira anutusa uaqeeianauqa mara aquaqa. Mara aquseeqa inneeqa nifaaqa anukamasee amiqira qamunna afisuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Maasa maaqooqari quqasee Beeteera maqa maaqai oonureeqa qini ummaara aukuana dadaaqi mari Anutuna qinee aiqama atinai nunanoo qini faqa mari Anutuna tatufirana suqara qainda auquanauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Miqi qimasoofaqa misa aiqamausa iriseeqa nariqa moosaaqaraa unnaqira anutusa maraqa nuna faqa naaqooki quqee maru fidinaanuna faqa Yakooboona amufanoo umareenoo Seekeemma maqusaki arookasa aaqa maqa indufusee minaki akundanau. ");
INSERT INTO bjr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Akundamaseenoo Yakooboofa faqa narí faiqi namu faqa doo quqasee fufanoo firaa rufiarafa mi saqanna maru maqusausaki maru fasiqausa rafaaqafufaqa sia nifaqasee nariqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakooboofa aiqama narí faiqi namu faqa fifiufanoo Rusa maqusa ki Kannaana maqa maaqaki oonuranau. Maqee mi maqusana auqu Beeteera fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Mifa miqoo oonureenoo tatufirana suqara ooni qainda auquseenoo mi maqusanaki Anutufa uainaina afaafau reenoo Beeteera fee qinau. Yakooboofa ooqai narí afasaanara rufiasee sandeenoo miqoo aniroofanoo Anutufa miqoo mina afusaa kooroouqoo marunara auqureenoo Beeteera fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Miqi qimasee miqoo marufanoo Reebeeka nammarina ainainira maanaaqa Deebooraa nammarifa kuqufufaqa arookasa ameemaanai suani afu ataaqee qaannai Beeteera maqusa dinni atinai akundaqau. Akundamasee mi maqusana auqureenoo ikiraqara saqari fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakooboofa Meesoopootamia maqa maaqaindari oonu randee ani marufanoo Anutufa kaifaa mina afunni kooroommafufanoo amiqira afaaqooqa qimamaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Miqimmaseenoo Anutufa qimaminau. Ani auqu Yakooboofa maridanoo, maqee maaqooqari oosana arasee Isaraeerafa marinnaranoo. Miqi qimaseenoo Anutufa mina auqureenoo Isaraeeranee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Miqi qimaseenoo Anutufa kafaa Yakooboona maaqi qimasee qimaminau. Qinee aiqama afeeka faqaa Anutusa maridaqa qimamidaqa. Anee moomoo faiqi faqaafa maria. Akaqa maqannaasa ani aiku asaukukiqari marifaranoo. Anee karaambaiqauqa ninaakufa marinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Qinee Abaraqaammana faqa Isakeena faqa nimiafanna maqa maaqana ani faqa ani aiku asauku kasooqaqee kambiqainausa faqa nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Anutufa miqi qimaseenoo Yakooboona qimamiseenoo doo quqaseenoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakooboofa mi maqusana Anutufa qimamuqoo miqoo ooni marasee daaqoo auqaanifee qimaseenoo rakiqaseenoo uainna nammari qumareenoo mi oonina adia amaqaseenoo oorifa fadameena faqa adianau. ");
INSERT INTO bjr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Miqimasee mi maqusana auqu Beeteera fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakooboofa narí faiqi namu faqa Beeteera maqusa quqasee Eefarataa maqusai fuanee qimasee aanai fimarufanoo Raseera nammarina faiqi maqarafa arinau. Arufanoo firaaqoo uqanna aupuranau. ");
INSERT INTO bjr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Raseera nammarina aidafirafa kaaqa mandaika uqanna ufanoo mina dadaaqi maru aanaaseefa qinau. Raseera sia rufiaa, moo akoonaiqi maqaananoo. ");
INSERT INTO bjr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Maqaseenoo Raseera nammarifa doo kuqiraridanoo aanna taikee marufanoo mi faiqina auqureenoo Beenooni fee qinau. Mina akoofa auqu reenoo Beensaminna fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raseera nammarifa kuqufufaqa Eefarataa maqusai fimaru aannana afainni akundaqau. Maqee miqoo Eefarataa maqusara Beeteereeqeemma maqusa fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakooboofa aaqoo auqaanifeera ooni miqoo rakiqanau. Maqee kaqi mi oonifa Raseera nammarina madika mariuqoo maridanoo mi madikanara koorooidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Miqooqari Isaraeerafa findifinoo moo maqa maaqai Eedeera kisaaqa ooni maaqa usakaqoona dinni atinni narí uiqaana maaqa usakanau. ");
INSERT INTO bjr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isaraeerafa mi maqa maaqanaki marufanoo Reeubeennafa narí akoona anaaqa Biriqaa nammarina narí ainainira maanaaqa maraqoona sakasee faiqanau. Isaraeerafa mi ufana irufanoo arana qanau. Isaraeerana faiqi namu qisauku qara taikasee qikunni ooqu qaara marasee 12 mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Reeaa nammarina faiqi namu maaqimmiqa mariqau. Reeubeennafa indaaruqaafa Yakooboona ooqa faiqi marinau. Mina aanaaqianaafa Simeeoonafa faqa Reefifa faqa Yudafa faqa Isakaarafa faqa Seeburunafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raseera nammarina faiqi namu Yooseefaasa Beensaminnasa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raseera nammarina ainainira maanaaqa Biriqaa nammarina faiqi namu Dannaafa faqa Napatarifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Reeaa nammarina ainainira maanaaqa Siripaa nammarina faiqí namu Kadafa faqa Aseerafa faqa mariqau. Mi faiqi namusa aiqama Meesoopotamia maqa maaqai kambiqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakooboofa narí akoofa Isakeefa unnai finau, Mamareena maqusaki Qeebooroona maqusa aaqa Abaraqaammafa faqa Isakeefa faqa mariuqoo finau. ");
INSERT INTO bjr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isakeefa 180 aukuana maranau. ");
INSERT INTO bjr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Maraseenoo kuqufufaqa mina faiqi qara Eesausa Yakooboosa akundaqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Eesauna aiku asauku marusa maaqimmiqa mariqau. Mina moo auqa Eedoomma fee qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eesaufa Kannaana maqannaa aanaaseeuqa maranau. Indaaru maroo anaaseena auqu Adaa nammarifa marinau. Mifa Qeeta maqannaa fasiqa Eeroona araamuna maranau. Mina aanaaqiana maroo anaaseena auqu Ooqooribammaa nammarifa maranau. Mifa Qifita maqannaa fasiqa Sibeeoona amaaku Annaana namarina araamuna maranau. ");
INSERT INTO bjr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Mina aanaaqianna maroo anaaseena auqu Baseemata nammarifa marinau. Mifa Isamaeerana araamuna Neebaiootana asookifa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Eesauna indaaruqaa anaasee Adaa nammarifa faiqi Eerifasana maqanau. Moo anaasee Baseemata nammarifa Reeueerana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Moo anaasee auqu Ooqooribammaa nammarifa Yeeusana faqa Yaramana faqa Kooraana faqa maqanau. Eesauna mi faiqi namusa miqimmasee Kannaana maqasaa kambiaqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eesaufa narí aanaaqmaaka faqa narí faiqi namu faqa narí araamuqmaaka faqa aiqama mina maaqaki mariusa faqa aiqama narí aandauqa faqa aiqama narí qumiasana Kannaana maqusai maridanoo maraqoona aiqama mara mareenoo Yakooboofa maruqoo qari nianasaa moo maqa maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Eesaufa faqa Yakooboofa faqa maru maqafa sia amana misa dadaaqiaqaa qufaqa Eesaufa quqasee moosaa finau. Misa kaaqa moomoo aandau ainaina marufaqa minara sia amana moodaanaki mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Eesaufa Eedoomma maqa maaqakina amuaqu namusaa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eesauna aiku asauku maaqimmiqa mariqau. Misa Eedoomma maqannaasa ninaakusa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Eesauna anaaqa Adaa nammarina amaaku moodaa Eerifasafa marinau. Eerifasafa moodaannai qisauku faiqi maqanau. Teemmanafa faqa Oommarafa faqa Seefoofa faqa Katammafa faqa Keenasafa faqa mariqau. Moo anaasee Timinaa nammarinasaa moodaa akoonaiqi Amareekana maqanau. Eesauna moo anaasee Baseemata nammarifa akoonaiqi moodaa Reeueerana maqanau. Reeueerafa qaara faqa qaara faqa faiqi akoonaiqi maqanau. Naqatana faqa Seeraana faqa Sammaana faqa Misaana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Eesauna moo anaasee Ooqooribammaa nammarifa Anaana araamuna marinau. Anaafa Sibeeoona amaaku marinau. Mi anaaseefa faiqi qaaramoo maqanau. Yeeusana faqa Yarammana faqa Kooraana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Miqimmasee Eesaunakiqari aruaki kambiqarausa mariqau. Eesauna ooqa faiqi Eerifasafa maa maqannaasa ninaakufa marinau. Teemanaa maqannaasa faqa Oomaraa maqannaasa faqa Seefoo maqannaasa faqa Keenasaa maqannaasa faqa Kooraa maqannaasa faqa Katamaa maqannaasa faqa Amareeka maqannaasa faqa ninaakufa marinau. Misa aiqamausa Eesauna anaaqa Adaa nammarinakiqari kambiqarausa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eesauna amaaku Reeueerafa maaqimmasee maqannaasa ninaakufa marinau. Naqataa maqannaasa faqa Seeraa maqannaasa faqa Sammaa maqannaasa faqa Misaa maqannaasa faqa ninaakufa marinau. Aiqama misauqa Eesauna anaaqa Baseemata nammarinasaaqari kambiqarausa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kaifaa maa maqannaasa Eesauna anaaqa Ooqooribamma nammarina araamuna Annaa nammarinasaaqari kambiqaqau. Yeeusa maqannaasa faqa Yaramma maqannaasa faqa Kooraa maqannaasa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aiqama mi maqannaasa Eesaunakiqari kambiaqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Eedoomma maqannaasa miqoo maridaqa rainasee qaara maqannaasaikammiqa mariqau. Misa ninaakufa Seirafa Qoora maqannaafa marufaqa minasaa aruaki maaqimmasee kambiaqau. Rootanafa faqa Soobarafa faqa Sibeeoonafa faqa Annaafa faqa Disoonafa faqa Eeseerafa faqa Disanafa faqa minamusa Eedoomma maqannaasa ninaakusa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Rootanafa Qoorina oosana faqa Qeemmana oosana faqa ninaakufa marinau. (Rootanana auna Timinaa nammarifa marianau.) ");
INSERT INTO bjr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Soobarafa Arafana oosana faqa Manaqatana oosana faqa Eebarana oosana faqa Seefoona oosana faqa Oonamana oosana faqa ninaakufa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeeoonnafa akoonaiqi qaaraqanda maqanau. Miqanda nuqu Aiaafa faqa Anaafa faqa mariqau. (Anaafa narí akoona Sibeeoonana doonkiuqa mareenoo andanda naaqeera kaasau maqa maaqaki munusoofaqa neemarufanoo rakisidanoo ida qeemaru nammarifa maqakiqari ururee maruna paqurinau.) ");
INSERT INTO bjr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anaafa Disoona faqa mina auna Ooqooriba nammarina faqa nikoofa marinau. Disoonafa Qeemadana oosana faqa Eesabana oosana faqa Itarana oosana faqa Keerana oosana faqa ninaakufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eeseerafa Biriqana oosana faqa Saafana oosana faqa Akana oosana faqa ninaakufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disanafa Usana oosana faqa Arana oosana faqa ninaakufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Maaqimmasee Qooranasaaqari kambiqoo maqannaasa Eedoomma maqa maaqaki mariqau. Rootanana maqannaa faqa Soobara maqannaa faqa Sibeeoona maqannaa faqa Annaa maqannaa faqa Disoona maqannaa faqa Eeseera maqannaa faqa Disana maqannaa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isaraee maqannaa karaambaiqa sia maru kamuqoo maa fasiqausa Eedoomma maqa maaqaki karaambaiqauqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Eedoomma maqannaasa indaaru rakisi nimaqoo karaambaiqana auqu Beerafa marinau. Beeoorana amaaku marinau. Mifa Dinabaa maqusanaasa karaambaiqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Beerafa kuqufanoo Seeraana amaaku Yoobabafa karaambaiqa marinau. Mifa Boosaraa maqusanaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yoobabafa kuqufanoo Qusamafa Teemana maqa maaqakinaafa karaambaiqaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Qusamafa kuqufufanoo Beedadana amaaku Adadafa karaambaiqaikinau. Mifa Midianna maqannaasa Mooaba maqa maaqaki naru nifaqaaqa maseenoo Adadafa Afitaa maqusaki karaambaiqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Adadafa kuqufufanoo Samarafa karaambaiqaikinau. Mifa Masareekaa maqusakinaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samarafa kuqufufanoo Saurafa Reeqooboota maqusakiqari Eeufarateesa nammari adeedi marufa karaambaiqaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saurafa kuqufufanoo miqooqari Akaboonana amaaku Baaraqanafa karaambaiqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baaraqanafa kuqufufanoo Qadarafa karaambaiqaikinau. Mifa Pau maqusanaasa karaambaiqa marinau. Mina anaaqa auqu Meeqeetabeera nammarifa Maatareeda nammarina araamuna marinau. Maatareeda nammarifa Meesaqabana anaiqi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Eesaufa Eedoomma maqa maaqakina maru maqusausa kinaasa ninaakufa marinau. Timina maqannaasa faqa Arafaa maqannaasa faqa Yeeteeta maqannaasa faqa Ooqooribammaa maqannaasa faqa Eeraa maqannaasa faqa Pinoona maqannaasa faqa Keenasa maqannaasa faqa Teemana maqannaasa faqa Mibasara maqannaasa faqa Makadieera maqannaasa faqa Iramma maqannaasa faqa ninaakufa mariqau. Misa maru maqusausa nariqa ninaakusa nuqu nifaafau ramaqoofaqa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakooboofa narí akoofa Isakeefa mariu maqa maaqana Kannaana maqa maaqaki miqoo kai marinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Maa ufafa Yakooboona faiqi namu ufa maridanoo. Yooseefaafa kumaaraa maridanoo qisauku qara taikasee qiku dinni taikasee dinni oonu qaara marasee 17 aukuana faqaafa maridanoo narí afasausa faqa sipsipauqasaa faqa mimmiuqasaa faqa rakisimarinau. Narí akoona ainainira anaasee qara Biriqaa nammarisa Siripaa nammarisa faiqi namu faqa nidanoo rakisi marinau. Mina afasausamara manda oosana auqoonara narí akoona qimami marinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakooboofa aiqama narí faiqi namuara aidimaruna uraaqaramaseenoo Yooseefaanara aidi marinau. Mifa asooqa namuki maqoonara kaaqa minara aidi marinau. Mifa kisaaqa qamunna kisaaqa asauku faqaana auqu aminau. ");
INSERT INTO bjr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mina afasausamara qafoofanoo misa nikoofa Yooseefaanara aidi marufa uriqaranoo marufaqa misa firaaqoo uqanna naundura mandaiki marufaqa mina faqa ufa qimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Moo eendaki Yooseefaafa qainammaseenoo qafanau. Minara narí afasausa mara qimannimufaqa firaaqoo uqanna fidiaqaamma amaqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yooseefaafa maaqi qimasee narí afasausamara qimanniminau. Qini maa qainnana iriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Maasa aiqamausa qafuqaki maridaqa raisa fooqaairana ateekasee rumbasee narisaa narisaa mundiiqaunanoo innindi fannoo maqasaa aqufifanoo qinindi fannoo andeeqasee kikiqinoo mariinoo. Innindi fannoo qinindi oosanaki aqufifanoo fiqu fiqumma datimmafinoo ammuqu namu rambaqaki oosanai quminoo. ");
INSERT INTO bjr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Miqi qimasoofaqa mina afasausamara aqiqa qiqau. Kasooaqee anee karaambaiqaika mafi maasa rakisiqimaqeennaree. Miqi qimaseeqa mifa qainunara faqa misara qunara faqa iriseeqa firaaqoo fidiaqaamma amaqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Moo kari mifa kafaa qaina maseenoo narí afasausamara qima niminau. Innee iriaqa qinee qaina moommiqa. Qinee qafaunanoo suani faqa uqoona faqa qisaukuqara taikasee qikunni ooqu moodaa marasee 11 fasau namu faqa qini daumooki aniree ninuka tuqu naumoo amisee mariafaqa niqafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Mifa narí akoona faqa mi qainufana qimamufanoo mina akoofa aqinoo qinau. Naqaa ira qaina fee inanee. Anee aneenna anoonara faqa aneenna afasausa marara faqa qiniara faqa ani aramandunnai ninuka tuqu naumoo amisee mariaqee fee qidanee. ");
INSERT INTO bjr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yooseefaana afasausa mara nári nikaqara nirana qeemarinau. Miqi marufanoo mina akoofa aiqama ufara kaqi kai irimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Moo kari Yooseefaana afasausa mara nári nikoona sipsipa mara maree Seekeemma maqusai karasa naaqeera nifiqee fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Oonu marufanoo Yakooboofa Yooseefaana qimaminoo qinau. Ani afasausa mara Seekeemma maqusai mariannai fua. Miqi qufanoo Yooseefaafa qinau. Qinee firara deedaqidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Mina akoofa maaqi qimasee qimaminau. Anee oonureenana qafaa. Ani afasausa mara kaqi fee maridafee. Aandauqa faqa amiqiqa fee maridee. Nindafamasee anireenana qimaqimia. Mina akoofa Heebooroona noopundukiqari aiqoofanoo finau. Yooseefaafa doo findifufanoo fifiiufanoo Seekeemma maqusai oonuranau. ");
INSERT INTO bjr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Oonureenoo narí afasausa mararara randanoo nidanoo oonuree aniree inoo nufanoo faiqí moo fannoo qafamasee mina iramirinoo qinau. Anee nanaree randaidanee. ");
INSERT INTO bjr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Miqi qufanoo Yooseefaafa qinau. Qinee qeeqa qifasausa mara sipsipasaa rakisi mariasara randaidaqa. Amanee anee misa mariannaira qini qima qiminnaree. ");
INSERT INTO bjr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Miqi qufanoo mi fasiqafa qinau. Misa doo quqasee fiqau. Misa Dootana maqa maaqai firaree qufaqa iriqiafana. Yooseefaafa mi ufana iriseenoo narí afasausa ninaaqianna fifiufanoo Dootana maqa maaqai misa oonu paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mifa nianai ani marufaqa mina afasausamara qafamaseeqa mina arirara tipundaariqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Misa maaqi qimasee narí qimami narí qimami qimariqau. Doo qaininoo nifa anidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Anifaqa mina aruseeqa mina iri mareeqee maa soorausaki mooki aqua. Miqimmaseeqa maasa minara kaasau aandau ariifoo qianaura. Maasa miqimmasaananoo mina qaina fannoo naqaa fee iannoo. ");
INSERT INTO bjr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Reeubeenafa misa ufa iriseenoo Yooseefaana saa ititaidanoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kaqi maa kaasau maqa maaqanaki maa nammari madikanaki aqua. Sia aidafirana amia. Mifa miqi qimasee narí kai qimiriseenoo qumee afiqamaree narí akoofunnai munu aisarara miqi qinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yooseefaafa narí afasausamara maruqoo ururoofaqa qumarasee mina kisaaqa qamunna kisaaqa asauku faqaana raipaqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Miqimmaseeqa nammari aadana usufu madikanaki aqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Aquseeqa miqoo ooqu faqee narana naidaqa tautummasee qafoofaqa Isamaeerana aiku asauku aniqau. Misa Kireeata maqa maaqaindari Isipa maqa maaqai fimariqau. Misa adiafaa imarufaqa neemaru ainainna faqa afundimaru saqari anoonnana faqa mara kammeerasaa quqeesee Isipa maqannaasa feefauriaqeera maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yudafa narí akaqaa fasaauqa qimanniminoo qinau. Inni saimbaqa qeeqa qikaqa arusee mina fidika rafaaqafusee nana dadaaqiranee maraanauree. ");
INSERT INTO bjr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Anifaqa Isamaeerana aiku asauku maa aniraasa nimianaqa feefauru qimiaqa. Mifa maasa qikaqa maridanoo maasa moodaa fidika marinara sia mina aidafirana amia. Miqi qufaqa misa eedoo qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Eedoo qimarufaqa Midianna maqusanaasa ainaina feefauri marusa aniroofaqa misa nári nikaqa Yooseefaana madikakinaana qubaqeeqee misa nimisoofaqa siruaa munnimma moodaa fasiqa aiku asauku taikasee 20 nimisee doo Yooseefaana maree Isipa maqa maaqai fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Misa Yooseefaana nimuna Reeubeenafa sia qafanau. Mifa anireenoo madikaki ooqu qafoofanoo sia marufanoo narí qamunna anaqaana qinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Miqimmaseenoo Reeubeennafa narí akaqaafasaauqa unnai oonuree qimanniminau. Yooseefaafa sia maridanoo qinee naqi fee ianauree. ");
INSERT INTO bjr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Miqi qufaqa misa mimmi arusee Yooseefaana kisaaqa qammunna mina fidikaki raaraa iqau. ");
INSERT INTO bjr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Miqimmasee misa mi qammunnana mara maree nári nikoofunnai oonuree qimamiqau. Maasa maa qamunnana moosaa paquriqa, qafaa, ani amaakundi fee maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakooboofa mi qamunnana qafamaseenoo qinau. Qini qimaaku qamunna maridanoo. Kaasau aandau fannoo qini faiqi Yooseefaana arusee rakeekaammaseenoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Miqi qimaseenoo Yakooboofa narí qamunna anaqana qiiseenoo soofaara qamunna afisuseenoo kisaaqasaa narí faiqiara soofaarida marinau. ");
INSERT INTO bjr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Marufaqa mina faiqi namu faqa araamuqmaaka faqa anireeqa nári nikoona aundura reendeenira ufa qufanoo misa nikoofa qaoo qidanoo qinau. Qinee qeeqa faiqiara iki raqaqa fuannaqbaqa kuqiqa kuqirausa mariannai fuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yakooboofa miqi marufaqa Midianna maqannaasa Yooseefaana afiqamaree Isipa maqa maaqai Pootifaana ainainira faiqi kianifeera amiseeqa feefauru maraqau. Isipa maqannaa kinna maaqasaa rakisi marusakiqari Pootifaafa uriqarara oofisaa marufaqa amiqau. ");
INSERT INTO bjr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mi aukuanna Yudafa narí ainaina minniseenoo Qiraana faqa Aduramma maqusai ooqu marinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Miqoo Yudafa Kannaana maqannaa fasiqa Suana araamuna qafamasee maranau. ");
INSERT INTO bjr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mariufanoo mi anaaseefa amuaqu qaikinoo akoonaiqi maqasoofanoo Yudafa mina auqu Eera fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kafaa mariufanoo mi anaaseefa amuaqu qaikinoo faiqi moo maqaseenoo mina auqu reenoo Oonanee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Kaifaa amuaqu qaikinoo akoonaiqi moo maqaseeoo mina auqu Seeraa fee qinau. Yudafa Keesiba maqusai marufanoo mina anaaqa fannoo Seeraana maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yudafa narí indaruqaa faiqi auqu Eerafa innooqa fufanoo anaasee Tammaara nammarina mara aminau. ");
INSERT INTO bjr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Eerana marirafa Karaambaiqa afusaa mandaika uqanna ufanoo kuqa arinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kuqufanoo Yudafa mina akaqa Oonana qimaminoo qinau. Anee maasa oosana mareenana aneenna afasaana anaaqa faqa aana finanoo faiqi maqasainanoo ani afasaana auqu sia taikaani. ");
INSERT INTO bjr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Oonanafa mina iriseenoo maaqi qimirinau. Qinee faiqi maqasaananoo sia qinindi kiandoo qimaseenoo narí afasaana anaaqa faqa aana nidanoo kaqinni kai nammari adiee marinau. Narí afasaana faiqi asumu sia marianifeera miqi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Oonanafa mi oosanna maroofanoo Karaambaiqa qafoofanoo mandaika uqanna ufanoo mina kuqamma arinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kuqufufanoo Yudafa narí aanaakuqu Tammaara nammarina qimaminoo qinau. Aneenna akoona maqa maaqai oonu adeedaana kai marinaqa Seeraafa innooqa finaqa mina faqa ani kai amianaura. Seeraafa faqa narí afasaaqanda undee inoo mi anaaseena marasee kuquandoora mina akoofa miqiqinau. Miqi qufanoo Tammaara nammarifa narí akoona maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mariufanoo Yudana anaaqa Suana araamuna kuqinau. Kuqufufanoo soofaara taikaseeoo Yudafa narí aqoondi Aduramma maqusanaana mina auqu Qiraana faqa Timinaa maqusai narí sipsipa asausi aukimaruna niqafarara ooru finau. ");
INSERT INTO bjr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Faiqí moo fannoo Tammaara nammarina qimaminau. Ani aanaakuqu Timinaa maqusai narí sipsipa asausi ateekarara ooru fidanoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tammaara nammarifa mi ufana iriseenoo adeedaana marida afisiu qamunnana raipaquseenoo moo qamunna afisumareenoo narí oori kaqikaa qamunnannai ititaseenoo Eenaimma maqusaki fimaru aannanasaa ooqufaaqee marinau. Tammaara nammarifa Seeraafa innooqanoo marifanoo sia qimiannoo fee qimasee miqinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yudafa ani qafoofanoo qamunnannai oori rafaaqafusee marufanoo dapi maraqa nua aanaaseefa mifoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Miqi qimaseenoo aana afainni mi anaaseefa marufanoo oonuree qimaminau. Ani rarisama saana mina akiiqara naqumma feefauru fee maridanoo fee. Yudafa mi anaaseenara sia narí aanaakuqu fee qimasee miqi qinau. Miqiqufanoo mi anaaseefa qinau. Mina akiiqara nanee qiminnaree. ");
INSERT INTO bjr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Miqi qufanoo Yudafa qinau. Qinee mimmi moo timmusa ani amaqaanaura. Miqi qufanoo mi anaaseefa qinau. Anee moo ainaina qimiqaina uaqeeiana kasooaqee mimmi qiminna kari aninna amianaura. ");
INSERT INTO bjr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Miqi qufanoo Yudafa qinau. Nana ainainee amianauree. Miqi qufanoo mi aneeseefa qinau. Aneenna asaukukinaa isaaqama faqa aneenna saunu faqa qimia. Miqi qufanoo Yudafa minauqa amiseenoo mi anaaseena faqa aana numasoofanoo amuaqu qaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamaara nammarifa findi fufanoo narí maqusai oonureenoo dapi anaasee maraqanu qamunnana raipaqusee adeedaana qamunna kaifaa afisinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yudafa narí qaqoondi Qiraanasaa mimmi aanaaqi timmusa quqaseenoo munu mi anaaseena amisee narí ainaina uaqeeuna oonu mini qimiannee qufanoo oonu randoosiaa sia mi anaaseena paqurinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Mifa oonureenoo Eenaimma maqusanaa fasiqauqa iramirinoo qinau. Yaifee dapi maraqanua aanaaseefa maa aannana afainni ooqufaaqeeiufa maridanoo fee. Miqi qufaqa misa qiqau. Sia maa maqusanaki dapi maraqanua aanaaseefa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Miqi qufanoo mi fasiqafa kafaa anirandeenoo Yuda funnai oonureenoo qimaminau. Oo qinee sia mi manaaqana paquriqa. Mi maqusanakinaa fasiqauqa faqa qiqa, sia ooqaindari maasa maqusaki dapi maraqanua aanaaseesa marida miaafoo qia. ");
INSERT INTO bjr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Miqi qufanoo Yudafa qinau. Saina mi anaaseefa mi ainainausa uaqee iani. Faiqí maasara naanaidara qifoora qikooqaidanoo. Minara qinee mi anaaseena feefauru amirara qunana anee oonuree sia paquriananoo. ");
INSERT INTO bjr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Qaarammoo quqoona aiqaramafufanoo Yudana qimamiqa qiqau. Ani aanaakuqu fannoo dapi maraqanua aanaaseesara foora numaseenoo maqee mifa amuaqu qaikinoo maridanoo. Yudafa mi ufana iriseenoo qinau. Mi anaaseena maree munusee idarasaifanoo qaani. ");
INSERT INTO bjr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Misa afiqee fimarufanoo narí aanaakuqu Yudanara ufa quqanau. Qinee maa ainainausa faqaa fasiqa faiqi uqa faqa maridaqa. Qafamasee iria, yana ainainauqee maridanoo fee. Maa qisaaqamafa faqa mina sanda faqa saunu faqa yanaindi fee maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yudafa qafamaseenoo qinau. Maa anaaseefa andeeqanoo maridanoo. Qinee kai aaqeeqa. Qinee qeeqa qimaaku Seeraana amiaqaana. Miqi qimaseenoo Yudafa sia kaifaa mi anaaseena faqa aana finau. ");
INSERT INTO bjr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mi anaaseena faiqi maqarafa aniroofaqa qafeeqa qiqau. Maa anaaseefa qaara faiqi maqaannoo fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Faiqi maqarara aupuree marufaqa moo fannoo naaree asauku quqasoo qumuroofanoo mina innaammuna afeesu aanaaseefa asauku qumaraseenoo taatuqee sanda rumbaseenoo qinau. Maafa indaaruqaafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Miqi qimasoofanoo asauku raqandaamma maroofanoo moo kaiqeena naaree maqanau. Maqasoofanoo innaamunai afeesu aanaaseefa qinau. Anee naqaa fee ifanee kaqinnaindari anee naaree qumidanee. Minara mina auqureenoo Peereesanee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Mina inaaqianna mina akaqa taatuqee sanda asaukusaa rumbarana maqanau. Maqaseenoo mina auqu Seeraa fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isamaeerana aiku asauku Yooseefaana afiqamaree Isipa maqa maaqai muqusoofanoo Isipa maqannaa karaambaiqa Faraoona sundiauqa rakisirafa Pootifaafa Yooseefaana feefaurinau. Pootifaafa Faraoofa maruqoo rakisi maru sundiasa uriqararafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Karaambaiqa Yooseefaana faqa maridanoo dadaaqi marufanoo aiqama ainaina auqoofanoo anoona kai kambiqee marinau. Mifa narí Isipa maqannaa uriqararana maaqaki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Pootifaafa qafoofanoo karaambaiqa Yooseefaana faqa maridanoo aiqama ainaina auqoofa anoona kambiqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pootifaafa Yooseefaanara asasammaseenoo uriqarara ainainira faiqikammaqoofanoo marinau. Miqimmaseenoo mifa Yooseefaana mareeqee narí maaqasaa faqa narí aiqama ainainasaa rakisirafaikamma qoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Miqooqari Yooseefaanaroo kai qidanoo karaambaiqa fannoo Isipa maqannaasa maaqakinaa aiqama ainaina faqa Pootifaana maaqakinaa ainaina faqa mina maqakinaa nara ainaina faqa amiqi amiqimma nimaqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Pootifaafa mana mana kaimmi marinau. Sia narí ainainara irimarinau, naranara kai irimarinau. Yooseefaafa amudaani tiafa amiqirafa uqanna mariau. ");
INSERT INTO bjr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kaqi kaaqoo marinoo mina uriqararana anaaqa fannoo Yooseefaanara aidufanoo qimaminau, aniree qini faqa faiqaa. ");
INSERT INTO bjr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Miqi qufanoo Yooseefaafa qaoo qimaseenoo qimaminoo qinau. Qini uriqararafa sia maaqaki quqaqai ainainausara iridanoo. Qinee marunanoo sia iridanoo. Mifa narí aiqama ainainasaa qini quqaqaifaqa rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Qinee maa maaqanaki rakisira afeeka mifa uaqeeindee kai masee uaqee idaqa. Mifa sia moo ainaina qini kukeeqa qimaqa qaifanoo maridanoo aiqama ainaina qimiqaifanoo, ani kai sia qimiqaifanoo. Naqi fee mandee fee qinee maa manda oosanna auqamasee fee Anutuna mandaikamma amaqaanauree. ");
INSERT INTO bjr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pootifaana anaaqa fannoo aiqama faasaana Yooseefaanara qini faqa faiqaannee qimarufanoo Yooseefaafa sia mina faqa faiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Moo faasaana Yooseefaafa naríara maaqaki ainaina auqanoo nufanoo sia moo ainainira faiqi minaki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Nariaraa marufanoo mi anaaseefa mina siuta ani qumareenoo qinau. Doo ania. Aniree qini sakasee faiqaa. Miqi qimaseenoo Yooseefaana siutandauru qumaroofanoo mifa narí siuta kai raipaqueeqee mina asaukuki quqaseenoo rafudamakufanoo madaanai sandanau. ");
INSERT INTO bjr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Madaanai sandoofanoo Pootifaana anaaqa fannoo qafamaseenoo narí maaqaki ainaini maru faiqisa naaramaseenoo qinau. Innee maana qafaaqa. Maa Qeeburu maqannaa fasiqana qini qifaaqi fannoo maaqaki miniqaifa maasa mandaikamma qima qaidanoo. Mifa qini rarisara rifaqa qinee firaaqoo faaqa runanoo mifa narí siuta qini daaqa quqasee sandeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mifa miqi qimasee qimannimiseenoo mi siutana kaqi uaqeeufannoo Yooseefaana uriqararafa aniranau. ");
INSERT INTO bjr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Aniroofanoo mi ufana kai qimaminau. Maa Qeeburu maqannaa anainira faiqina anee miniqaanafa qini maaqaki keeqafi qini faqa manda oosana auqarara inoo. ");
INSERT INTO bjr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Miqifaqa qinee faaqa runanoo narí siuta qini daaqa raipaqu quqasee madaanai sandeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","20","Yooseefaana uriqararafa mina irufanoo aranaqoofanoo Yooseefaana qumareeqee uriqararausa rumbara fasiqauqa marunaki quqanau. Quqasoofanoo minaki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Marufanoo karaambaiqa Yooseefaana faqa maridanoo dadaaqida amiqi amiqimma amaqee marufanoo karabusasaa rakisi marufa Yooseefaana qafamaseenoo asasinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Karabusasaa rakisi marufa Yooseefaana mareeqee karabusauqasaa rakisiranaika minau. Miqimmasoofanoo Yooseefaafa karabusa maaqaki aiqama ainaina auqee maruna rakisirafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Karabusasaa rakisirafa Yoosefaafa rakisi maru ainainausara sia amiqimmasee iridanoo. Sia rakisi marinau. Karaambaiqa fannoo Yooseefaana faqa marunara aiqama ainaina mifa auqoofa anoona kai kambiqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kaqikaaqoo marinoo Isipa maqannaa karaambaiqa uainna anoona tatimaru fasiqafa faqa mina feemu suqee marufa faqa nariqa uriqararana mandaikamma amaqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mandaikamma amaqasoofanoo mi qandara aranaqoofanoo narí sundiauqara qufaqa qumaraqau. ");
INSERT INTO bjr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Qumaraseeqa sundiauqa uriqararana karabusa maqaki Yooseefaafa maru maqanaki quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mi qanda kisaaqasaa karabusaki marufanoo karabusasaa rakisirafa qufanoo Yooseefaafa misasaa rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Miqoo karabusaki maridaqa moo eendaki uainna tati marufa faqa feemu suqee marufa faqa qainiqau. Uainna tati marufa mina qaina oosana aaduma marinau. Feemu suqee marufa mina qaina oosana aaduma marinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mi kananaanna miqanda noori runusee marufanoo Yooseefaafa ani nindafeenoo iramirinoo qinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Inneeqara nanaree kaaqa moomoo irira irida maridee. ");
INSERT INTO bjr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Qufaqa miqannda qiqau. Maaqanda qaina maqaqee idaqa qaina oosana qimannimi marifa sia marifaqa maaqanda minara oonu mafi irida maridaqa. Yooseefaafa miqanda ufa iriseenoo qima niminau. Anutufa kai qaina oosana qimannimirana nimidanoo. Inneeqa qaina qima qimifaqa iria. ");
INSERT INTO bjr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Miqi qimasoofanoo Faraoona uainna nammari tati maru fasiqafa narí qaina maaqi qimasee Yooseefaana qimaminau. Qinee qafaunanoo uainna sanda qini doorinni marifaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Qaarammoo asaana minasaa marifaqa qafeeqa. Amanee ifaqa qafaunanoo afufeenaarifaqa qafaunanoo qaqama irafi akuqeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Qinee karaambaiqa Faraoona kaafa uaqeeidaqa akuqamafina minaki anoona tatiisee munu amiqa. ");
INSERT INTO bjr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yooseefaafa mina iriseenoo maaqi qimasee qimaminau. Sanda qaarammoo asaana qafaannana mina amana qaaramoo faasaana marinnara. ");
INSERT INTO bjr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Qaaramoo faasaaana taikainanoo Faraoofa ani iduku aisainana kafaa aneenna saikaki finnaranoo. Anee ooqai mina uainna tatira faiqi maridana mina uainna kaafa amiunnandee inana kaifaa aminnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Anee miqimma finana qiniara qimudaoo qimasee karaambaiqa Faraoona qimaminanoo qini dadaaqinoo iduku qisaani. ");
INSERT INTO bjr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Misa ooqai qini Qeeburu maqusaindaraana ummuara mamaree aniqau. Qinee maaqoo Isipa maqa maaqaki marida sia moo manda oosana mareeqa. Misa fifau qini karabusaki quqaqaafaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Feemu suqee marufa narí aqoonnana qaina oosana qimamuna irufanoo amiqufanoo Yooseefaana qimaminoo qinau. Qinee faqa moo qainammiqa. Qinee qaarammoo feemu difaani qumbiqarana qikiiaaqa akuaqee idaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Meeraqooqaraa difaaniki oosana oosana feemu ainaina uriqararanaindi marifanoo ufiniuqa nee mariafaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yooseefaafa mina qaina oosana iriseenoo maaqi qimasee narí qimaminau. Qaarammoo difaani qafaanafa qaarammoo faasaana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Qaaramoo faasaana amana mina qaaramoo feemu difaani marifana qafaananoo. Qaaramoo faasaana aiqarainanoo Faraoofa ani ani qumareenoo munusee anuka ateekasee ani iri saqarisaa dirisainaqa ufiniuqa ani amaqi neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Miqiqimasee qima nimisoofanoo miqooqari mi qaaramoo faasaanna aiqaroofanoo mikari Faraoona maqoo aukuanafa aniroofanoo narana firaaqoo suqaseenoo narí ainainasaa rakisi marusa niminau. Mifa narí uainna tati maruna faqa feemu suqee maru fasiqana faqa idukumaree mini narí ainainasaa rakisi marusa nifusaa quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Idukuseenoo uainna tati maru fasiqana mareeqee ooqai mareeu saikanaki kafaa quqasoofanoo uainna tatimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Feemu suqee maruna idukuseenoo anuka ateekasoofaqa sandannai mina qiri saqarisaa diriqau. Aiqama ainaina Yooseefaana ufamau andeeqaseenoo mimau kaimbinau. ");
INSERT INTO bjr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Uainna tati marufa kafaa Faraoona ainainidanoo Yooseefaanara siamma irinau. Qaunusee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Qaara aukuana aiqaroofanoo moo eendaki Isipa maqannaa karaambaiqa Faraoofa moo qaina maaqimmasee qafee fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Qinee Niru nammmari afainni kikiqiqa marida qafaunanoo qisauku dinni taikasee dinni ani qaara marasee 7 burimakau nifaaqa faqaasa urureeqa andanda nee mariafaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Neemarufaqa dinni qisauku taikasee dinni oonu qaara marasee 7 nimudaani aanaaqi nammarikiqari urureeqa indaaru qaasa naaqa nammari afainni kikiqamma fuafaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nimudaani aanaaqiuqa nifaaqa faqaasa aiqama nambiqama saafaqa qafeeqa. Mi ainainausa qainasaa qafamaseenoo karaambaiqa Faraoofa tauti findifinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mifa kaifaa afuki qaunduarufanoo faifufanoo moo qaininau. Sakumma moodaa oosana saa dinni qisauku taikasee dinni oonu qaara marasee 7 iranoo marufa aiqama anoona qumbi qumbiqirafa marufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kafaa mina aanaaqianna moo qaina qafoofanoo dinni taikasee dinni ani qaaraqanda marasee 7 sakumma moodaa oosanasaa iranoo marinau. Anoona siaifa narana maaqina kinaafa mandaikirafa sia anoona marufa, ufai fannoo raudaqoo fara foora marufanoo fifau akee kai marinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Anoona siai sakummafa quandaku fanoo anoona faqaa sakumma aiqama namasanau. Mi qainna maseenoo Faraoofa tauti findi fufanoo Boo moo qainammidaqee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mi kananaanna Faraoofa findi fufanoo moomoo irirana maroosia Isipa maqannaa irirana faqaasa faqa afunee fasiqauqa faqa naaranau. Naaramaseenoo narí qainuna qimannimufaqa sia moo fannoo amana mina oosana narí qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Minara tutu qidaqa randee marufanoo Faraoona uainna tati maru fasiqafa Yooseefaanara iriseenoo Faraoona qimaminoo qinau. Oo karaambaiqa maqee kai qeeqa furufariafanna oosanna oonu mafi iriseeqa kooroommasee qimamidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ooqai anee aanoo qimaseenana qini faqa feemu suqee maruna faqa aneenna sundia rakisirana maaqaki quqaqisanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Moo eendaki maaqanda qaina qiqiafana. Mi qaina qanda naadu naadu oosana faqaa qaina qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Minakina Qeeburu maqannaa kumaaraa moo fannoo, sundia rakisirana Pootifaana ainainira faiqi marufa maasa faqa marinau. Maasa qeeqa qaina qimamiafananoo mifa mina oosana maasa qimaqiminau. ");
INSERT INTO bjr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mifa qundee kaimminau. Anee qini saikaki kaifaa mara quqaqiseenana feemu suqee maruna d irinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraoofa mi ufana iriseenoo niqiqoofaqa Yooseefaana karabusa kinaana aaqee uqanna afiqee aniqau. Mifa oosau suqaseenoo narí qamunna fuka afisumareenoo Faraoona afusaa aniranau. ");
INSERT INTO bjr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Aniroofanoo Faraoofa qimaminau. Qinee qainammasaunaqa sia moo fannoo mina oosana qimaqimia faqa iriqa. Anee qaina oosana kooroo qimarianafa mariannanara qimaqimiafaqa aaraidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Miqi qufanoo Yooseefaafa qinau. Oo qini uriqararafa amiqirafa qinee qeeqa kai sia amanaikianauranoo. Anutufa kai qaina oosana qimannimirana qiminaqa qimamianaura. ");
INSERT INTO bjr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Miqi qimasoofanoo Faraoofa narí qaina oosana Yooseefaana maaqi qimasee qimaminau. Qainunnana qinee Niru nammari afainni kikiqiqa maridaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Qafaunanoo burimakau nifaaqa faqaasa dinni qisauku taikasee dinni oonu qaara marasee 7 nammarikiqari urureeqa andanda neemariafaqa niqafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Misa ninaaqianna miqi kaimmaseeqa dinni qisauku taikasee dinni oonu qaara marasee 7 misa nimana kai nimudaani aanaaqi urureeqa kikiqamma fuafaqa nindafeeqa. Miqira mandaikira burimakauqa sia ooqai Isipa maqa maaqaki mootinai mariafaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nimudaani aanaaqi burimakauqa nifaaqa faqaasa namataikeea. ");
INSERT INTO bjr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Nambiqamaseeqa sia moo fannoo nifaaqa mareea, ooqai mariundee kai miqa mariafaqa qafeeqa. Nindafamaseeqa tauti findi fiqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Qinee moo qaina faqa masee qafaunanoo dinni qisauku taikasee dinni oonu qaara maraseenoo 7 sakuma aiqama qumbi qumbiqirafa moodaa saqarisaa marifaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mina aanaaqianna qafaunanoo kafaa moo sakuma saqarisaa dinni qisauku taikasee dinni oonu qaara maraseenoo 7 iranoo marifaqa qafeeqa. Mifa anoona siaifa ufai uqinoo rauda quqaqai fara foora marifaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ira fifaqa qafaunanoo anoonna siaifa indaaru iraina anoona sakumma nambiqamasaafaqa qafeeqa. Qinee mi qainnana afunee fasiqauqa qima nimunaqa sia moo fannoo mina oosana qimaqimia. ");
INSERT INTO bjr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yooseefaafa mina qaina ufa iriseenoo Faraoona qimaminoo qinau. Anee qainiannana oosana moodaara qaaraqanda qaina iananoo. Anutufa auqaaninna ainainnara qainasaa ani qimaminoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dinni qisauku taikasee dinni oonu qaara marasee 7 burimakau afaaqa faqaana qafaannana oosana dinni qisauku taikasee dinni oonu qaara marasee 7 aukuana qafaananoo. Sakumma dinni qisauku taikasee dinni oonu qaara marasee 7 sakuma anoona qumbi qumbiqirana faqa qafaanafa mifa faqa miqikai inoo dinni qisauku taikasee dinni oonu qaara marasee 7 aukuana maridanoo. Mi qaina qanda oosana moodaa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dinni qisauku taikasee dinni oonu qaara marasee 7 burimakau nimudaani aanaaqi nammariki ururaasa faqa dinni qisauku taikasee dinni oonu qaara marasee 7 sakuma anoona siaina qafaannana oosana 7 aukuanaki aandaroo firaafa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Qinee qimamunandee kaimmiannoo. Anutufa narí auqaaninnanara ani uqafiqeenoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dinni qisauku taikasee dinni oonu qaara marasee 7 aukuanaki Isipa maqa maaqaki narana firaaqoo rairaa iannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mina aanaaqianna kafaa miqi kai inoo dinni qisauku taikasee dinni oonu qaara marasee 7 aukuana aandaroo naruannoo. Mi aandaroonaki mi rairaaira narannara qaunifaranoo. Aandaroo fannoo maqa maaqa mandaika uqanna masaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Mi aandaroo aukuannai faiqí anaasee doo rairaaira aukuanara qaunu uqannaseefaranoo. Aandaroo firaafa mandaika uqanna irafa marianinnanara miqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anee kaifaa kaifaa qainiannana oosana Anutufa mi ainainna kasooaqee kuqaa miqiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Minara anee aneenna maqannaasakina moo qafamaseenana irirana faqaa fasiqa mara quqasainanoo mifa Isipa maqa maaqasaa rakisiani. ");
INSERT INTO bjr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Anee akaqa rakisirausa quqasainaqa moodaannai qisauku taikasee dinni oonu qaara marasee 7 rairaaira aukuanakina oosana oosana narana moodaannai qisauku namu kinaana moodaa moodaa mara afeediaqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Anee qimanniminaqa aiqama narana rairaaira aukuanakinaana suqu quqaaqa. Anee afeeka ufa nimisainaqa narana maqusa maqusaki suqu quqasee minasaa rakisiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Mi narannafa dinni qisauku taikasee dinni oonu qaara marasee 7 aukuana aandaroo firaafa anianinnanaki mi afeediranakinaana neefaranoo. Miqidaqa sia faiqí anaasee kuqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Faraoofa faqa narí uriqararausa faqa Yooseefaana iriranara eedoo qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Miqi qimaseenoo Faraoofa qimanniminoo qinau. Maasa sia amana moo fasiqa Yooseefaana uraaqararana paqurianaura, Anutuna maraquna minaki marifa marinara saifanoo mifa kai mariani. ");
INSERT INTO bjr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Miqi qimaseenoo Faraoofa Yooseefaana qimaminoo qinau. Anutufa kai maa aiqama ainainna ani uqafiqeenoo. Anee aiqamausa urinnaaqara masee firaa irirana faqaafa akooqoo mariananoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Qinee ani quqasaanana qini maqa maaqasaa rakisinnaranoo. Aiqama qini faiqí anaasee ani ufa mau kai fifaranoo. Ani afeeka fannoo qini afeeka ameemaanai mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Miqi qimaseenoo Faraoofa kafaa Yooseefaana qimaminau. Qinee maqee ani mareeqee Isipa maqannaasa uriqararafai kammiqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Miqi qimaseenoo Faraoofa narí asauku amukakinaa rinna firaa uriqararausa rinna maruna raduku Yooseefaana asaukuki quqanau. (Yooseefaafa mi rinnanannai peennakina raaraa maseenoo papiqasaa atooqasoofaqa maaqanna maaqanna mina qafeeqa Faraoona rinna akara fee qimaseeqa kaaqa rufieeqa mi papiqana saaqaraa ufara eedoo kai qimariqau.) Faraoofa amiqira qamunna afisu amaqaseenoo koorannai auqira kukukakana faqa rufu amaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Miqimmasoofanoo Faraoofa uriqararausa nifiqanoo nu qoosa karana Faraoofa Yooseefaana amisoofanoo minasaa rakisira sundiauqa mina afunni fidaqa maaqi qimasee faaqaridaqa qiqau. Amaaraaqa amaaraaqa. Mi oosannanannai Yooseefaana aiqama Isipa maqannaasa uriqararanaikinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraoofa kafaa Yooseefaana maaqi qimasee qimaminau. Qinee uriqararausa Faraoosa qimamidaqa. Sia amana Isipa maqannaa fasiqa moo fannoo narí aidiranannai moo ainaina auqaannoo. Mifa anisaa naaree iraannoo. ");
INSERT INTO bjr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Miqi qimaseenoo Faraoofa Yooseefaana fuka auqu reenoo Safeenata Paneeanee qinau. Miqi qimasee mifa Yooseefaana anaasee aminau. Mi anaaseena auqu Aseenata nammarifa Pootifeerana araamuna marinau. Pootifeerafa Qeerioopoorisa maqusanaasa suani afuara innaaru qimarusa aanaiqikirafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yooseefaafa moodaa fasiqa faqa moo fasiqa asaukuqara taikasee 30 aukuana marasee Faraoona ainainirana oosana aranau. Oosana araseenoo Faraoona aiseenoo Isipi maqa maaqaki oonuree aniree idanoo aiqama atinai nimarinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Qisauku dinni taikasee dinni ani qaara marasee aukuanaki Isipa maqa maaqaki narana moomoo kambiqafi rairaa inau. ");
INSERT INTO bjr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Mi aukuanna namunakinaa narana irairaa una Yooseefaafa mareeqeenoo maqusakiaqa afeedinau. Mi moodaa moodaa maqusanaki mi maqusana fiqu fiquinoo maru maqanakinaa naranna marasee mi maqusanaki afeedinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Mi naranausa unakiisoofanoo ooruku nammari afaiqaraa nukudara foora moomoo uqanna marufanoo Yooseefaafa asaana rusia minnisanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Aandaroo aukuana sia ani marufanoo Yooseefaana anaaqa Aseenata nammarifa akoonaiqi qaara qanda maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Maqasoofanoo Yooseefaafa qinau. Anutufa qini dadaaqifaqa qeeqa aupurarana faqa qeeqa qikoona atiara iriranara faqa auniqa. Miqi qimaseenoo mifa narí indaaruqaa faiqi auqureenoo Mannasee nee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kafaa Yooseefaafa akoonaiqi moo maqaseenoo qinau. Anutufa maa maqa maaqanaki qinee aupurarana maree marunnanaki faiqi qiminoo. Miqi qimaseenoo mifa narí inaaqiannaa faiqi auqureenoo Eefaraimmanee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Qisauku dinni taikasee dinni oonu qaara marasee 7 aukuanaki narana irairaa imarufaqa Isipa maqannaasa asasiufa taikanau. ");
INSERT INTO bjr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yooseefaafa undee kai inoo qisauku dinni taikasee dinni oonu qaara marasee irairaa ira aukuana aiqaroofanoo aandaroo kambiqanau. Aiqama maqa maaqaki aandaroo narinau. Isipa maqa maaqaki kai narana kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mariufanoo Isipa maqa maaqaki faqa aandaroo narufaqa faiqí anaasee Faraoo funnai oonuree naranara faaqarida innaaru qufanoo mifa qinau. Innee Yooseefaa finnai oonu raifanoo mifa innandee innandee kai iaqa. ");
INSERT INTO bjr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aandaroo firaafa Isipa maqa maaqaki aiqama atinai firaaqoo narufanoo Yooseefaafa aiqama afeedira maqauqa atuqasoofaqa Isipa maqannaasa narana feefauri mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Aiqama maqa maaqaki maru fasiqa aanaaseesa aandaroo firaafa naru faqa aiqama atinaindari narana feefaurirara Yooseefaa funnai Isipa maqa maaqaki aniqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakooboofa Isipa maqa maaqai narana moomoo marunara narí faiqi namu qimanniminoo qinau. Innee naqaa fee ifaqee narana minni ooqu maraaqaana maridee. ");
INSERT INTO bjr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Isipa maqa maaqai narana maridanoo mifoo qiafaqa iriqa. Miqoo ooqureeqa akaqa narana feefaurumma maree murusaifaqa namasee sia kuqua. ");
INSERT INTO bjr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Miqi qufaqa Yooseefaana afasausa mara moo anaasee faiqi namu qisauku qara taikasee marusa narana feefaurirara Isipa maqa maaqai ooqu fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yakooboofa Yooseefaana akaqa uqanna Beensaminna sia aiqanau. Moo ainaina mina afaaqai kambiqaandoo qimasee rufiasee sia aiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Aandaroo firaafa Kannaa maqa maaqaki nári marunara Yakooboona faiqi namu faqa moomoosa faqa narana feefaurirara ooqu fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yooseefaafa Isipa maqa maaqakinaasa uriqararafa maridanoo aiqama maqa maaqakinaasa feefauriaqee qimasee quqaqoofaqa feefauri mariqau. Yooseefaana afasausa mara ooquree Yooseena oorinni noorindari maqasaa kummaraqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yooseefaafa narí afasausa mara noori nindafoofanoo Yooseefaana irirafa kambiqanau. Kambi qoofanoo sia misara iridanoora foora aranaiqi iramirinoo qinau. Innee yaindarifee anidee. Qufaqa misa qiqau. Maasa Kannaana maqusaindari narana feefau rirara qumidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Miqi qufanoo Yooseefaafa misara iri marufaqa mina afasausa mara minara sia iri mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yooseefaana irirafa kambiqa fufanoo mifa ooqai narí faiqi saa qainunara oonu mafi irinau. Innee nipuraraa fasiqauqa mariafaqa nindafaida. Innee mai qumuree maasa aandaroo darifaqa ummooqukida mandaiki marunausa qumu qiqafararee qimasee qumuafanoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Miqi qufaqa misa maaqi qimasee narí qimamiqau. Oo uriqararafa sia maasa miqianaura. Maasa ani ainainira faiqiara foora narana feefaurirara qumidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Maasa moodaa fasiqa faiqi namu kai maridaqa. Maasa kuqaa ufa kai qimarunausa maridaqa. Uriqararafa maasa sia nipuraraa fasiqau maridaqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Miqi qimasoofanoo Yooseefaafa nariqa qima niminoo qinau. Innee unna qimariafanoo. Maasa maqa maaqa mandaikinoo sia afeekaikinoo marina qafarara qumuafanoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Misa mi ufana iriseeqa kafaa narí qimamiqa qiqau. Uriqararafa, maasa aiqama qisaukuqara taikasee qikunni ooqu qaara marasee 12 maridaqa. Kannaa maqa maaqaki moodaa fasiqa faiqi namu mariafannanakiqari moodaafa kuqinau. Maasa ninaaqiannaafa maasa nikoona faqa maqusai kaqi maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yooseefaafa mina iriseenoo kafaa qima niminoo qinau. Doo qinee qidaqa, innee nipuraraa fasiqauqa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Qinee maaqimmasee inni nimanammasee qafaanaura. Qinee Faraoona auqusaa inni qima nimidaqa sia innee ooru fifaranoo maaqoo marifanoo inni nikaqa qumurainaqa oorufifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Innikiqari moo fannoo ooru inneeqa nikaqa afiqee qumuaqa. Innee akaqausa sundiauqa faqa marifaqa innisaa rakisi marifaqa maasa innee qia ufana qimasee qafamasaana oorufifaranoo. Innee unna qifaqa kuqaa Faraoona auqusa qimannimidaqa innee nipuraraa fasiqa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Miqi qimasee Yooseefaafa qufaqa misauqa rumbeeqee karabusa maqaki quqasoofaqa qaaramoo faasaana mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Qaaramoo faasaanasaa marisoofanoo Yooseefaafa maaqi qimasee qima niminau. Qinee Anutunara rufiee marunna fasiqausa maridaqa. Innee qini ufa mau fiqa amiqimmasee marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Inniara kuqaa qira fasiqauqee qiaqeera innikiqari moodaafa innee maria karabusanaki marinaqa innee akaqausa narana feefauru maqaana muru inneeqa faiqi anaasee nimifaqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Innee ooruree inneeqa nikaqa inaaqianaana afiqeeqa qumuaqa. Qumu raifaqa qinee inniara kuqaa ufa kai qimariasee qimasee sia kuqa naruanaura. Miqi qufaqa misa aiqamausa mina ufara eedoo qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Eedoo qimasee narí qimami narí qimami qiqau. Innisaimbaqa kuqaa qeeqa qikaqa mandaikamma amaqa qiafana. Mifa firaa ummaaraki maridanoo dadaaqiaqee qimarufaqa innisaimbaqa sia iriqiafana. Minara maasa maqee maa ummaaranaki maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reeubeenafa misa ufa iriseenoo maaqi qinoo qinau. Qinee qaoo qiafana innee sia iriqau. Mifa kuquna akiiqara maasa maqee ummaara maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yooseefaafa misa qimaru ufana umee kai irimarinau, miqi marunara misa sia iriqau. Misa Yooseefaana faqa ufa qianee qimasee qimarufanoo moo fasiqa fannoo misa ufa quandee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yooseefaafa misa ufa iriseenoo quqasee umeenni oonureenoo ikiraqa seenoo oonu randee aninau. Iki raqarafa taikoofanoo ufaqirana amanaikufanoo oonu randee aninau. Anireenoo misakina Simeeoonnana qumarasee misa nifusaa rumbanau. ");
INSERT INTO bjr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yooseefaafa narí ainainira faiqiuqa qimannimufaqa narana mina afasausamara uqa umbiqaseeqa misa munnimma kaifaa nariqa uqa adianai uqarumasee nimiaqa, aanai fida neefandinna narana faqa nimiaqa qufaqa eedoo qimasee miqimma nimiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mina afasausa mara feefaurummasoo naranna nariqa doonkisaa quqasee maree ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Yooseefaana afasausa mara narana nári doonkisaa quqasee maree fifii ufaqa eendufaqa aanai uiqaana arasee faiqarara imarufanoo mina afasaafa moofannoo narí doonki narana amirara narí uqa ooraqasee qafoofanoo mina munnimma uqa adianai marufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Qafamasee narí ainaina naaramaseenoo qinau. Innee aniree qafaaqa qini munnimma kaifaa qiqa qimiafanoo qini uqaki maridanoo. Miqi qufaqa misa nimuqusa mandaikufaqa rufiaidaqa qiqau. Anutufa maasa naqaa feemma qimaqeenoo fee maaqinoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Miqi qimasee faiqaqee mariufaqa iaqoo kananaana nári nikoofa Yakooboofa marunnai Kannaa maqusai ooruree aiqama mi ainainausa kambiqoonara qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isipa maqannaa karaambaiqa fannoo aanoo qira ufa kai maasa qima qimaqeenoo. Mifa maasara innee qini maqa maaqaki nidaqa nipuree mariafanoo fee qimasee rairai qinoo. ");
INSERT INTO bjr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Miqi qifaqa maasa maaqi qimasee narí qimamiqa. Oo maasa sia nipuraraa fasiqau maridaqau. Maasa kuqaa ufa qimarunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Maasa moodaa fasiqa faiqi namu qisauku qara taikasee qikunnooqu qaara marasee 12 maridaqa. Maasa qikaqa moo fannoo narí akoona faqa Kannaana maqusai maridanoo, moo fannoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Maasa miqi qimasee qimamiafanoo mifa mina iriseenoo qinoo, qinee maaqi masee inni nimanida qafaanauree qinoo. Innikiqari moodaafa qini faqa marinaqa innee akaqausa sakumma aina maree muru faiqi anaasee nimiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Nimiseeqa narana taikainaqa kafaa qumiqa inneeqa nikaqa faqa afiqee qumuaqa. Muqusaifaqa qinee mina qafamaseeqa inniara kuqaa sia nipuraraa fasiqauqee kuqaa ufakai qimariasee qimaseeqa inni faiqí iduku nimianaqa innee maqee maqee narana aina feefaurida ooruree qumuree qiqa nuaqee qinoo. Misa miqi qimasee nári nikoona qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Qimamiseeqa nári uqauqa idukusee ooraqasee qafoofanoo aiqamausa munnimma kaqi marinau. Misa qafamasee nári nikoona Yakooboona faqa rufiaqau. ");
INSERT INTO bjr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yakooboofa rufiaidanoo maaqi qimasee narí faiqi namu niqinau. Innee qini faiqi namu mandaika maqimaqee mariafanoo. Yooseefaafa doo taika fufaqa, Simeeoonafa faqa taika fifaqa kafaa innee Beensaminnana faqa afiqee firaree qidee. Qinee ummaaraki kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reeubeenafa narí akoona ufa iriseenoo maaqi qimasee narí akoona qimaminau. Oo qipoo, qinee Beensaminnasaa rakisianaura. Qinee sia mina afiqee ururaanana mina akiiqara qini qimaaku qara narua. Anee qini qisaukuki quqasainaqa qinee amiqi masee afiqaqa niniinaqa afiqee uruanaura. ");
INSERT INTO bjr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Miqi qimasoofanoo Yakooboofa qinau. Qini qimaaku sia uqanna inni faqa fuannoo. Mina afasaafa doo kuqu fufaqa mifa naríara maridanoo. Aanai mandainaina paqurinaqa qinee maaqirausa asooqa inni mi ummaarafa darinaqa kuquanoora. ");
INSERT INTO bjr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kannaana maqa maaqaki aandaroo firaafa narinoo mandaika uqanna inau. ");
INSERT INTO bjr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Isipa maqa maaqai feefaurummamaree murusoo naranna Yakooboona aiku asauku nama taikasoofanoo Yakooboofa narí faiqi namu qimanniminau. Kaifaa ooquree kaqikaa narana feefaurumma murusaifaqa naa. ");
INSERT INTO bjr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Miqi qimasoofanoo Yudafa qinau. Mindaraa uriqararafa maasa oori runusee qimaqimifaqa iriqa. Innee inneeqa nikaqa sia afiqee qumiqa sia qini qifusaa nifaranoo fee qinoo. ");
INSERT INTO bjr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Anee qini qikaqara eedoo qinaqa maasa afiqee ooquree ani narana feefaurianaura. ");
INSERT INTO bjr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Anee sia eedoo qinanoo maasa qikaqa sia ooqu finaqa sia amana fifau ooqu fuanaura. Mi maqannaasa uriqararafa qinoo inni nikaqa sia quminaqa sia qini qifusaa nifaranoo fee qinoo. ");
INSERT INTO bjr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakooboofa mi ufana iriseenoo qinau. Innee nanaree moomoo ummaara qini qimidee mi uriqararana qimamiqa maasa qikaqa maridanoo fee qifee. ");
INSERT INTO bjr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Misa iriseeqa kafaa qimamiqa qiqau. Mi uriqararafa maasara faqa maasa faiqi aanaaseera faqa iréenoo. Inni nikoofa kaqi fee maridanoo fee qinoo. Kafaa inni nikaqa moo maridanoo fee qinoo. Miqi qimasee maasa iraifaqa qimamiqa. Maasa naqaa fee masee maasa qikaqa afiqee qumuaqee qianinnanara irianauree. Sia maasa iriqa. ");
INSERT INTO bjr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Miqi qimasee Yudafa narí akoona maaqi qimasee qimaminau. Qipoo anee maasa qikaqa qini qisaukuki quqasainaqa maasa doo findifi ooqu fuanauranoo. Miqinaqa maasa sia daara rainaqa kuqunauranoo. ");
INSERT INTO bjr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Qinee qeeqa marirana mina amaaqa maqaanaura. Anee minara qini kikiaqa usua. Qinee sia afiqee andeeqasee anee iannannai uriqa qinee ani nifairirana maraanaura. ");
INSERT INTO bjr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Maasa sia ani faqa kisaaqasaa ufa qifau, maasa amana qaara kari ooquree ururee unaiqini. ");
INSERT INTO bjr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Miqi qufanoo misa nikoofa qimanniminau. Doo amana inneeqa miqiqa miqiaqa. Innee maa maqa maaqana kinaana amiqira ainaina inneeqa uqaki rumammareeqa kaqi nimi maria ainainnara foora muqu mi maqannaasa uriqararana amiaqa. Saqari anoona qoodaa faqa ookasaasa anoona qoodaa faqa adiafaa imari saqari qaqamana anoona faqa oofauna fooqaa ira ainaina anoona faqa kasa fooqaana anoona faqa maree ooqu fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Innee moomoo munnimma qaara kari afaqamaree ooqu fuaqa. Innee ooqai munnimma inni uqa adianai marufaqa qafaqau. Abee, aaqamasee munnimma inni uqaki kafaa quqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Inneeqa nikaqa afiqee ooqurandee kai kaqi uruaqa. ");
INSERT INTO bjr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Aiqama afeeka faqaa Anutufa dadaaqinanoo mi fasiqafa inniara qimudaoo qiani. Qimudaoo qimaseenoo Beensaminna faqa inni nikaqa moo faqa kafaa nimiani. Qinee qini faiqi namu kakasifanoo doo saina kakasiani. ");
INSERT INTO bjr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Miqi qimasoofaqa Yakooboona faiqi namu mi saqari anoonausa faqa munnimma moomoo qaara kari mara maree Isipa maqa maaqai Beensaminna faqa afiqeeqa ooqu fiqau. Miqoo misa Yooseefaafa maruqoo ooqu kikiqa mambufanoo Yooseefaafa misa nindafanau. ");
INSERT INTO bjr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yooseefaafa Beensaminna qafamaseenoo narí maaqakinaa ainainasaa rakisi maru fasiqana qimaminoo qinau. Anee maa fasiqausa nifiqeenana qini maaqaki munu quqaa. Misa suani qambaana qini faqa narana neefaranoo. Anee aandau aruseenana deedaqia. ");
INSERT INTO bjr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ainainira faiqi fannoo mifa qimamundee inoo misauqa nifiqee Yooseefaana maaqaki munu quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Yooseefaana maaqai nifiqee munu quqarara fimarufaqa misa rufiaidaqa oonumafi irimariqau. Indaaru narana feefauriafanna munnimmana maasa mara mareeqa qimaaqai murusee mi munnimmana maasa uqaki paquriafannana akiiqara maasa mai qifiqee anidanoo. Misa kai kaqi maasa darusee maasa doonkiuqa marasaifaqa maasa misa ainainira faiqikianaura. ");
INSERT INTO bjr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Misa miqi qimiriseeqa mina ainainasaa rakisi maru faiqina maaqa kooqiki oonuree qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Oo uriqarara amanee maasa ufa irinnaree. Ooqai maasa qeeqa maaqaindari mai qumuree narana feefauru iqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Maasa mai feefauru mamaree ooru fiiufaqa aanai ooru faiqarara uiqaana arasee maasa qeeqa sakuma uqa sanda idukusee qafaafananoo maasa aiqamausa aquafanna munnimmafa aiqama maasa uqauqa adianai marinau. ");
INSERT INTO bjr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Maasa mi munnimmana fabaqa maasa qeeqaindi moo faqa fiqaramasee narana feefaurirara maree qumidaqa. Yafee moo fannoo maasa uqakiaqa maasa narana feefauriafanna munnimmana kafaa uqarinau fee. ");
INSERT INTO bjr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Miqi qimasoofanoo Yooseefaana ainainasaa rakisi maru faiqifa iriseenoo qinau. Doo innee nifaaqa quqaaqa. Sia rufia rufia iaqa. Inni Anutufa inni nikoona Anutufa mifa kai inni munnimma inni uqaki rinau. Doo qinee inni munnimma mareeqa. Mifa miqi qimaseenoo Simeeoonna karabusaki maruna iduku eeqeenoo misaki quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Quqaseenoo misa nifiqa mareenoo Yooseefaana maaqaki munu quqaseenoo nammari nimufaqa niku nammari uqusee mariqau. Misa doonkiuqa faqa narana nimufaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Miqimmasee misa nári maree qumu ainainausa Yooseefaafa suani qambaana anirainaqa amiraree qimasee deedaqiqau. Yooseefaafa suani qambaana inni faqa narana naanauranoo fee qimasee qimannimunara irisee deedaqiqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yooseefaafa maaqai aniroofaqa misa nári maaqaindari maree qumu ainainausa mara maree maaqaki mifa marunnai ooruree mina oorinni noorindari maqasaa aqufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Miqimmasoofanoo Yooseefaafa misara amiqi fee masee maridee qimasee iramirinau. Inneeqa nikoona nauraiqiara qima qimufaqa iriafanafa maqee kaqi fee maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Qufaqa misa iriseeqa qiqau. Eeoo ani ureeqara ainainira faiqi maasa qikoofa kaqi maridanoo. Miqi qimaseeqa misa kafaa Yooseefaana oorinni noorindari maqasaa aqufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Miqimmasoofanoo Yooseefaafa narí akaqa Beensaminna qafamaseenoo qinau. Maana inneeqa nikaqara qima qimufaqa iriafanafee. Qimaseenoo Yooseefaafa qinau. Qini qimaaku Anutufa ani amiqi amiqimma amaqaani. ");
INSERT INTO bjr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Miqi qimaseenoo kai kaqi findifufanoo quqasee finau. Mina amuqusa firaaqoo narí akaqara mandaikufanoo finau. Yooseefaafa misa nifusaa iki raqaaqaa ufanoo quqasee narí faiqee maru rummanai oonuree iki raqanau. ");
INSERT INTO bjr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Iki raqeeseenoo nammarinnnai aukunu nammari uquseenoo narí aukunu afeekaika mandeenoo doo misunnai qumureenoo narí suqee maruna qimaminau. Doo narana rakiqaannee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Miqi qufanoo suqee marufa narana naadu naadu rakiqanau. Yooseefaana aaduma teeboorasaa rakiqa amaqanau. Kafaa mina afasausa mara naaduma teeboorasaa rakiqa nimaqanau. Isipa maqannaasa minaki nee marusa naaduma moo teeboorasaa rakiqa nimaqanau. Isipa maqannaasa Qeeburu maqannaasa faqa narana narara nikooqee marusa marunara naadu naadu naqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yooseefaafa narí narana suqee maru faiqina qumee kai qimamufanoo mi faiqifa misa nifasaana indaaru mara ooqu mara amaqaseenoo mina aanaaqiannaana mina muqufi ooqu mara amaqasee miqimmamaree inaaqiana nikaqa fannoo atinni ooqu marinau. Misa nári ooqufaaqeeuna qafamasee tautumasee narí qafee narí qafee iqau. ");
INSERT INTO bjr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yooseefaafa narí qufanoo mina difaanikinaa narana mareeqaida misa piritakiaqa quqa mareenoo Beensaminnaindiki fiqaramasee moodaannai qisauku 5 kari narana quqanau. Quqasoofaqa narana faqa uainna nammari faqa neeneesoofanoo doo nifaaqa iduku fufaqa qufaina qiqa asasiqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Namasoofanoo Yooseefaafa narí maaqakinaa ainainasaa rakisi maru fasiqana qimaminoo qinau. Anee misa uqa maraseenana minakiaqa narana uqa ruma qumbiqasainaqa maree fuaqa. Moo uqa sia apeequniani. Amana kai marinaqa maree fuaqa. Misa munnimma faqa narana feefauriana nariqa uqa adianai rumasainaqa maree ooru fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Miqidana inaaqiannaana uqakina narí munnimma narana feefaurina namufaqa qini siruaa kaafa faqa mina uqa adianai rua. Miqi qimasoofanoo mifa qimamundee inau. ");
INSERT INTO bjr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kananaana keekoo qufaqa doo misa nári doonkiuqa namufaqa niqiqoofaqa oorufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Doo mareeqa kaqi kaaqoo maqusa quqasee nianai fufanoo Yooseefaafa narí ainainasaa rakisi maru faiqina aiqeenoo qinau. Anee kai kaqi misa ninaaqianna fua fidana oonu misa rafaaqafusee maaqi qimasee qimannimia. Innee naqi fee ifaqee qinee amiqimma nimaqaunnana akiiqara mandaikamma qimaqee fee. Miqi qimasee qimannimia. ");
INSERT INTO bjr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nanaree innee qini uriqararana kaafa qummuari fee, mifa minaki kai nammari neemarina. Mifa minaki afunee qafeemari kaafana qummuariafanoo, innee manda ainaina uqanna auqaafanoo fee qia. ");
INSERT INTO bjr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Miqi qimasoofanoo mina ainainira faiqi fannoo iriseenoo nifaqee finau. Misa oonu paquri mandeenoo Yooseefaana ufa kai misa qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Qimannimisoofaqa misa qiqau. Oo uriqararafa maasa ani ufa oosanara randaidaqa. Sia uqanna maasaki maaqira manda oosana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Maasa ooqai indaaru narana feefauriafanna munnimmafa maasa uqaki maruna mina maasa sia qumuariqa mina Kannaana maqusaindari mara maree kafaa muqu ani amiqa. Maasa miqi marunausa maridaqa naqi maseeqee ani uriqararana maaqakinaa siruaa faqa koora faqa maraanauree. ");
INSERT INTO bjr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Anee maasa uqa kiaqa randasee qafa. Yana uqakifee mi ainainafa mariannoo fee doo mifa kai kuquannoo, maasa ani ainainira faiqi kamambi marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yooseefaana ainainira fasiqa fannoo misa ufa iriseenoo qima niminau. Doo amana inni ufa mau kai fuanaura. Ya fasiqana uqaki fee marinafa mifa kai qini ainainira faiqi mariannoo. Innee aiqama nimaaqa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Miqi qimasoofaqa misa kai kaqi nári uqauqa afiqu maqasaa quqasee idukiqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yooseefaana ainainasaa rakisirafa indaaruqaanaindi naaree qafamaseenoo miqooqaraanaindiki miqoo qafamaseenoo kafa miqoo qaraanaindiki qafamaseenoo miqi kai mamaree aiqamausa uqakiaqa amiqimmasee qafanoo finau. Miqi mamareenoo misa ninaaqiannaana Beensammina uqaki qafoofanoo kaafa minaki marinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Beensaminnana uqaki paquri masoofaqa mina afasausa mara aiqamausa nimuqusufaqa nári qamunna aiqamausa rakeekaa iqau. Miqooqari nári ainaina doonkisaa quqasee oonu quandakufaqa maqusai aniqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yudafa narí auna akaqa faqa Yooseefaana maaqai oonuree qafoofanoo Yooseefaafa kaqi maaqaki marinau. Marufaqa misa anireeqa noorindari maqasaa aqufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Aqufuma fufanoo Yooseefaafa qinau. Innee naqi fee ifee. Innee sia fee iridee, qinee maaqira uriqararausa qeeqa afuneennoo inni ummuarirana paquriranara, sia fee irifee. ");
INSERT INTO bjr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Miqi qimasoofanoo Yudafa qinau. Oo uriqararafa maasa nana ufa fee ani qimamianauree. Maasa naqi mandee fee maasa qeeqa andeeqaranara qianauree. Anee maasa kikiqa qusimariannana naqimmasee fee qaoo qianauree. Anutufa maasa aaqarana koorooinoo. Sia kaafa maraifa kai ani ainainira faiqi mariannoo, maasa aiqamausa ani ainainira faiqi marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Miqi qimasoofanoo Yooseefaafa nariqa qimanniminoo qinau. Oo sia uqanna qinee miqianauranoo. Kaafa maraifa kai qini ainainira faiqi kiannoo. Innee akaqausa nimaaqa ooruree ineeqa nikoona qimamiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yudafa Yooseefaafa maruqoo oorureenoo qimaminoo qinau. Oo uriqararafa, anee qiniara eedoo qinaqa ani faqa qifaaqa quqasee ufa qia. Anee sia qiniara aanoo qia. Anee Faraoona miqirafa mariananoo, uriqararafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Oo uriqararafa, ooqai maasa umuraafanana anee maasa iramirinana inni nikoofa maridanoo fee inni nikaqa maridanoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Miqi qunaqa maasa maaqi qimasee aninna qimamiqiafana. Maasa qikoofa asooqa maridanoo. Maasa qikaqa faqa maridanoo. Mifa asooqa namuki mi faiqina maqeenoo. Mi faiqina afasaafa kuqufufanoo naríara marifanoo maasa qikoofa kaaqa minara amuqusidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Maasa miqi qimasee indaaru ani qimamiqiafana. Uriqararafa anee maasara afiqee muqusaifaqa qafaanee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Miqi qunaqa maasa maaqi qimasee aninna qimamiqiafana. Oo mi faiqifa sia amana narí akoona quqaannoo. Mina faiqi fannoo miqinanoo mina akoofa kuquannoo fee qiqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Maasa miqi qimasee ani qimamiafana anee maaqi qinau. Innee inneeqa nikaqa sia afiqee qumiqa sia qini qifusaa anifaranoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Maasa ani ufa iriseeqa qeeqa qikoo finnai oonuree anee qunna ufana qimamiqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Qimamiseeqa mariafananoo maasa qikoofa maasara kaifaa ooqu narana feefauriaqee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Miqi qufaqa maasa maaqi qimasee narí qimamiqiafana. Maasa qikaqa ooqu finaqa maasa ooqu fuanaura. Sia maasa qeeqaraa uriqararana afusaa ooqu fuanaura. ");
INSERT INTO bjr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Miqi qufanoo maasa qikoofa maaqi qimasee maasa qima qiminau. Innee irimmariafanoo qini qinaaqa Raseera nammarifa qini faiqi qaaraqanda kai maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Moo fannoo fifufaqa qinee minara kaasau aandau fannoo qini faiqi arusee rakeekaamma namaseefoo qiqiafana. Mi fasannai sia kafaa mina qafeeqa. Doo mifa taikafinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Innee maana qinee unnannaindaraana afiqee fifanoo moo ainaina mina afaaqai kambiqainaqa qini minara qimudaoo qirafa asooqa marunnaqoo qini daruannoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Yudafa Yooseefaana kaifaa qimamidanoo qinau. Maasa qeeqa qikaqa quqaseeqa oonuraananoo maasa qikoofa maasa qiqafamaseenoo doo narí faiqiara amuqusinanoo kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Maasa qikoona amuqusirafa firaaqoo maa faiqinaki maridanoo. Mifa asooqa uqanna maridanoo maasa maaqaamma saananoo mi ummaarafa mina kuqa aruannoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Qinee qeeqa qikoona maaqi qimasee qimami qiafana. Qinee qeeqa qikaqa akiiqara ummaara maraanauree qiqiafana. Qinee sia mina afiqee uriqa ani nifairira ufa qinee maraanauranoo fee qiqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Miqi qimasee qinee qeeqa qikoona qimamiqiafana. Maqee qinee qeeqa qikaqa amaaqa maqeeqa ani ainainira faiqi kiananoo qini qikaqa fannoo narí afasausa faqa ooru fuannoo. ");
INSERT INTO bjr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Qinee naqimmasee fee maa faiqifa sia qini faqa ooru finaqa qeeqaraa qeeqa qikoo finnai ooru fuanauree. Qini qikoofa manda ummaara marainaqa qafaananoo sia amiqiannoo, mandaikammiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yooseefaana aundura dapikufanoo narí ainainira fasiqauqa nifusaa ikiraqararusia minnisee sia amanaikufanoo niqi qamasoofaqa madaanai fiqau. Fifufanoo Yooseefaafa narí ainaina faqa kai maridanoo qimanniminau. Qinee inni nikaqa Yooseefaasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yooseefaafa firaaqoo iki raqaida qufaqa Isipa maqannaasa madaanai maridaqa iriseeqa oonu Faraoona qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yooseefaafa narí afasausa mara maaqi qimasee qimanniminau. Qinee maana Yooseefaasa maridaa. Kuqaa fee qini qikoofa kaqi fee maridanoo fee. Miqi qufaqa mina afasausa mara tautu maseeqa naaquqoofaqa sia ufa qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yooseefaafa kafaa qimanniminoo qinau. Doo innee qini daaqa aniaqee qufaqa misa mina aaqa aniroofanoo kafaa qimanniminoo qinau. Qinee inni nikaqa mariafanaqa innee feefauruara mamaree qini quqasoofaqa qini qifiqamaree Isipa maqa maaqaki ainainira faiqi kamma qisaqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Doo maqee innee sia qini qimu oosannara inneeqa kikiqusifanoo nimuqusiani. Anutufa kai qini diiqoofaqa innee kuqi foora indaarunni kamma nimaqasee inni dadaaqianeera qufaqa qumiqiafana. ");
INSERT INTO bjr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Firaa aandaroo narirafa maa maqanasaa qaara aukuana marasee aiqaraifanoo moodaannai qisauku aukuana kaqi maridanoo. Mi kamuqoo fuka narana ummaqirafa faqa unakirafa faqa sia mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Anutufa kai qini mareeqee inni indaarunni kamma saifaqa inni asumu marasainaqa sia kuquaqeera, mi mookira oosannananai kuqaa mifa inni faqa inni niku nisauku faqa marasainaqa asumu marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Minara sia innee fau qini diiqoofaqau maa maqa maaqanaki ani maridaqau. Anutufa diiqoofaqa ani maridaqa. Mifa kai qini mareeqee Faraoona oofisaauqa uriqarausaikamma qaifaqa maridaqa. Miqimmasaifaqa qinee mina aiqama maqa maaqasaa rakisirausa maridaqa. Aiqama Isipa maqa maaqasaa rakisirausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Innee kai kaqi qini qikoo finnai ooruree ani amaaku Yooseefaafa maaqi qinoofee qimasee qimamiaqa. Anutufa qini mareeqeenoo aiqama Isipa maqa maaqasaa rakisira faika maqaifaqa maridaqa. Sia kisaaqasaa maria, kai kaqi qinee unnannai qumua. ");
INSERT INTO bjr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Anee faqa aneenna faiqi namu faqa aneenna anaiqi mara faqa inneeqa sipsipa faqa inneeqa mimmiuqa faqa inneeqa burimakau faqa inneeqa aiqama ainaina faqa indaa mamaree qumuraifaqa Kooseena maqa nimianaqa qini daaqa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Innee Kooseena maqa maaqaki innisaa rakisianaura. Moodaannai qisauku aukuana kaqi maridanoo, mi aukuana namunaki aandaroo ida mariannoo. Innee faqa ineeqa faiqí anaasee faqa inneeqa aandauqa faqa naararaina kuqifoora qikooqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yooseefaafa kaifaa narí afasausa mara qima nimidanoo qinau. Innee nifu maqasee qini qiqafaaqa sia moosau maridau qinee Yooseefaasa uqanna maridaqa. Doo qini qikaqa Beensaminnafa mifa faqa qini qiqafaani. ");
INSERT INTO bjr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Qinee Isipa maqasaa firaaqoo uriqararausa marunnanara qini qikoona qimamiaqa. Aiqama ainaina qafaanara faqa qimamiaqa. Qimamiseeqa doo dauni dauni afiqee mai qumuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Miqi qimaseenoo narí akaqa Beensaminna oonu mafi anukaki difaa difaamma qumareenoo iki raqoofanoo Beensaminnafa faqa iki raqanau. ");
INSERT INTO bjr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yooseefafa quandaku fanoo narí afasausa mara aiqamausa nimooqaseenoo naiki raqanau. Naiki raqasoofaqa mina afasausa mara mina faqa ufa qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Isipa maqannaasa misa miqi unara oonu Faraoona qimamisoofanoo Faraoofa faqa mina uriqararausa faqa iriseeqa asasammiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraoofa Yooseefaana maaqi qimasee qimaminoo qinau. Anee maaqi qimasee aneenna afasausa qimanniminaqa nári ummaara doonkisaa mara quqasaifaqa maree Kannaana maqusai ooru fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Miqoo oorureeqa nári nikoona faqa nári faiqi anaasee faqa nifiqee mai qumuaqa. Qumuraifaqa Isipa maqa maaqaki qafamasee amiqira maqa nimianaqa miqoo narana fiqaranoo moomoo marinaqa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Faraoofa kafaa Yooseefaana qimaminau. Anee qinee ufa qunnana qimanniminaqa Isipa maqusaindaraa qoosa rarisee mari karausa faqa daraiwaa faqa mara maree ooru fuaqa. Minakina nári ninaaqmaaka faqa nári faiqi aanaaqiuqa faqa nári nikoona faqa mara quqasai ooqu marifiqa qumuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Misa sia nári umiasana aina mafi quqasee quminnanara oonu mafi iriaqa. Isipa maqa maaqa amiqirafa aiqama misaindikammiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yakooboona amaaku mara Faraoofa qimannimundee kai iqau. Yooseefaafa Faraoona ufa iriseenoo qoosa rarisee maru karausa mara quqasoofaqa daraiwaa namu faqa aatata neefandinna narana faqa nimufaqa maree ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yooseefaafa narí afasausa mara qamunna moodaa kai moodaa kai nimana nimana kai niminau. Beensaminna moodaanai qisauku qamunna faqa siruaa munnimma 300 faqa aminau. ");
INSERT INTO bjr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yooseefaafa Isipa maqannaa amiqira ainaina suquseenoo qisauku qara taikasee doonkisaa oorufusasaa amaqoofaqa mara maree muru mina akoona amiqau. Kafaa aatata qumidanoo naaninna narana sakumana faqa feemu faqa narana oosana oosana faqa anaasee doonki qisauku qara taikaseesaa oorufusasaa quqasoofaqa maree ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yooseefaafa narí afasausa mara Kannaana maqusai niiqamasoofaqa fufanoo qima niminoo qinau. Innee aatata fidaqa sia qiniara qimasaida narí aqi narí aqiqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Misa Isipa maqa maaqa quqasee nimaaqa nári nikoofa Yakooboofa marunnai Kannaana maqa maaqai ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ooruree nári nikoona qimamiqau. Yooseefaafa sia kuqinoo kaqi maridanoo, misa miqi qimasee nári nikoona qimamiqau. Mifa Isipa maqannaa aiqamausa uriqarafa maridanoo fee qiqau. Yakooboofa mi ufana irufanoo amuqusa kaqinnaindari ufanoo misa ufara sia kuqaa fee qinau. ");
INSERT INTO bjr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yooseefaafa qimannimu ufausa nári nikoona qimami marufanoo Yakooboofa qafoofanoo qoosa rarisee maru karausa Yooseefaafa quqasoosa Yakooboona afiqee Isipa maqa maaqai ooqu firara ururaqau. Yakooboofa mi karausa qafoofanoo aundura idukinau. ");
INSERT INTO bjr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Idukufanoo qinau. Qini qimaaku Yooseefaafa kaqi maridanoo. (Qinee kaqi maridaqa ooqu mina qafarafa mifa kai aiqama ainaina arusee uriqararafa maridanoo.) Qinee ooqu mina qafamasee kuquanauree qinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakooboofa narí ainaina indaaii mareenoo Beeraseeba maqusai ooqureenoo miqoo narí akoona Isakeena Anutuna aandau tatufirana suqaminau. ");
INSERT INTO bjr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Miqoo eendaki faiqaqee ufanoo Anutufa qainasaa afu nareenoo qinau. Yakooboo Yakooboo qufanoo Yakooboofa maqi qimaseenoo qinau qinee maaqoo maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Qufanoo Anutufa qimaminoo qinau. Qinee Anutusa ani akoona Anutusa maridaqa. Anee sia Isipa maqasaa ooqu firaranara rufiaa. Mi maqanasaa ooqu marinaqa ani aiku asauku firaa maqanaasaikamma nisaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Qinee ani faqa Isipa maqasaa ooqu fuanaura. Yooseefaafa ani faqa Isipa maqa maaqaki marinana mariinana kuqinnaranoo. Mariinaqa kasooaqee kafaa ani aiku asauku mareeqee kafaa Kannaana maqasaa quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Beeraseeba maqusa Yakooboofa quqasee Kannaana maqa maaqai ooqufinau. Mina faiqi namu Yakooboona faqa nári faiqi aanaaqiuqa faqa nári ninaaqmaaka faqa mareeqee qoosa rarisee maru karana Isipa maqannaa karaambaiqa Faraoofa nimaqoonasaa quqasee nifiqee ooqufiqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Misa nári aandau aina faqa nariqa umiasana faqa Kannaa maqasaa maridaqa maqeeiunauqa aiqama maree ooqu fiqau. Yakooboofa narí aiku asauku aiqama nifiqee ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakooboofa narí faiqi namu faqa narí anaiqi mara akoonaiqiuqa faqa narí araamuqmaaka faqa narí anaiqi mara maanaaqauqa faqa aiqama nifiqee ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakooboona faiqi namu Isipa maqasaa ooqu fusa maaqi miqa mariqau. Yakooboona ooqa faiqi Reeubeenafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reeubeena faiqi namu Qanookafa faqa Parufa faqa Qeeseeroonafa faqa Karamifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeeona faiqi namu Yeemueerafa faqa Yaminafa faqa Ooqadafa faqa Yakifa faqa Sooqarafa faqa mariqau, misa aiqamausa moodaa anaasee faiqi namu mariqau. Moo anaasee faiqi Saurafa marinau. Mina anoofa Kannaana maqannaa anaasee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Reefina faiqi namu Keerasoonafa faqa Kooqafa faqa Meerarifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudaana faiqi namu Seeraafa faqa Peereesafa faqa Siraafa faqa mariqau. Yudaana faiqi qaaraqanda Eerafa faqa Oonanafa faqa mariiufaqa Oonanafa Kannaana maqasaa kuqinau. Peereesana faiqi qara Qeesaroonafa faqa Qamurafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakarana faiqi namu Toorafa faqa Puaafa faqa Yasubafa faqa Simaroonafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Seeburuna faiqi namu Seereedafa faqa Eeroonafa faqa Yareerafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Miqimmaseenoo Reeaa nammarifa Yakooboona faiqi namu Meesapotamia maqusai maridanoo maqanau. Maanaaqa moodaa auqu Dinnaa nammarifa mina faqa miqoo maqanau. Doo Reeaa nammarina faiqi namu maanaaqa akoonaiqi aiqamausa 33 mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kadana faiqi namu Seefoonaa faqa Qakifa faqa Sunifa faqa Eesaboonafa faqa Eerifa faqa Aroodifa faqa Areerifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseerana faiqi namu Iminaafa faqa Isauaafa faqa Isififa faqa Beeriaafa faqa misa nisookifa Seera nammarifa faqa mariqau. Beeriaana amaaku qara Qeebeerafa faqa Marakieerafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Doo miqimmasee Yakooboona aiku asauku 16 nári ainainira maanaaqa Rabanafa Reeaa namarina amuna Siripaa nammarinasaa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakooboona anaaqa Raseera nammarifa faiqi qaaraqanda maqanau. Yooseefaafa faqa Beensaminnafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yooseefaana faiqiqara qaaraqanda Isipa maqasaa kambiqaqau. Miqanda nuqu Mannaseefa faqa Eefaraimmafa faqa mariqau. Miqanda ninoofa Aseenata nammarifa marinau. Aseenata nammarina akoona auqu Pootifeerafa marinau. Mi fasiqafa Qeerioporisa maqannaa amaana maqasaa rakisi marufa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beenasaminna faiqi namu maaqimmiqa mariqau. Beerafa faqa Beekeerafa faqa Asabeerafa faqa Keerafa faqa Naamanafa faqa Eeqifa faqa Roosafa faqa Mupimafa faqa Qupimafa faqa Aratafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Doo miqimmasee 14 Yakooboona aiku asauku Raseera nammarinasaa qari kambiqaqau. (Rabanafa Biriqaa nammarina narí ainainira maanaaqa Raseera nammarina narí araamuna amufanoo mifa mareeqeenoo narí afaaqi Yakooboona amufanoo faiqi maaqi mandee maqanau.) ");
INSERT INTO bjr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Biriqaa nammarina indaruqaa faiqi Dannafa marinau. Dannana faiqi moodaa marinau mina auqu Qusimafa marinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Biriqaa nammarina faiqi moo Nafatarifa marinau. Nafatarina faiqi namu maaqi miqa mariqau. Yaqaseerafa faqa Kunifa faqa Yeeseerafa faqa Sireemafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Doo miqimmasee Yakoobooona aiku asauku 7 narí ainainira manaaqa Rabanafa Raseera nammarina amunasaa Biriqaa nammarinasaa maqanau. ");
INSERT INTO bjr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakooboona aiku asauku uqanna Isipa maqasaa ooqufusaa aiqama moodaanaki 66 mariqau. Misa ninaakuqmaaka sia nisaanariqa. ");
INSERT INTO bjr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yooseefaana faiqi qara Isipa maqasaa kambiqaqau. Miqanda faqa Yooseefaana faqa Yakooboona faqa moodaanaki ootupamasee 70 fasiqa ooqu fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakooboofa Yudana aiqoofanoo indaaru ooqu Yooseefaana qimaminanoo Kooseena maqasaa misa paquriani feera aiqanau. ");
INSERT INTO bjr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yooseefaafa narí qoosa rarisee maru karanaki akarama fufanoo Kooseena maqa maaqai narí akoona paqurirara finau. Oonu paqurimmaseenoo Yooseefaafa narí akoona anukaki oonu mafi kaqaramma umareenoo kisaaqasaa iki raqee marinau. ");
INSERT INTO bjr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Iki raqee marufanoo Yakooboofa Yooseefaana qimaminoo qinau. Doo qinee kuqiraridaqa qinee maqee ani qafeeqa anee sia kuqina mariana kaqi mariana. ");
INSERT INTO bjr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yooseefaafa iki raqaseenoo narí afasausa mara faqa narí akoona aiku asauku aiqama faqa qimanniminoo qinau. Qinee Faraoofa mariqoo ooruree inniara qimamianaura. Qini qikoofa faqa qini qifasausa faqa Kannaana maqusaindari qinee marunnannai qumureeaa maqi qianaura. ");
INSERT INTO bjr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Qinee inniara sipsipasaa rakisi mariasa maridaqa nariqa sipsipa faqa burimakau faqa nariqa aiqama ainaina faqa maree qumiaa maqi qimasee qimamianaura. ");
INSERT INTO bjr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Qinee miqi qimasee qimamisaananoo Faraoofa inni naaramasee innee ainaini marianara irainaqa maaqi qimasee qimamiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Oo maasa uriqararafa maasa qikeeku qikaaku ooqai sipsipa kai rakisi marusa marufaqa maasa faqa maqee minasaa kai rakisidaqa. Innee miqi qimasee Faraoona qimamifanoo mifa Kooseena maqa inni nimiannoo. Isipa maqannaasa sipsipa rakisiranara nikoo uqanna qaidanoo. Minara inni naaduma saa Kooseena maqa nimiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yooseefaafa narí afasausa moodaannai qisauku namu nifiqeenoo Faraoo fuqoo ooru finau. Oorureenoo qimaminoo qinau. Oo Faraoo qini qikoofa faqa qini qifasausa faqa Kannaana maqusaindari nári sipsipa burimakau aiqama faqa nári ainaina faqa maree qumidaqa. Maqee misa Kooseena maqasaa qumu maridaqa. ");
INSERT INTO bjr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Miqi qimasee narí afasausa mara Faraoona oorinni murusoofanoo niqafanau. ");
INSERT INTO bjr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraoofa Yooseefaana ufa iriseenoo mina afasausa mara iramirinoo qinau. Innee nana ainaini mariasee. Miqi qufaqa misa iriseeqa qiqau. Uriqararafa, maasa sipsipasaa rakisira ainaina imarunausa maridaqa. Maasa qikeeku qikaaku auqeeu saikana kai maasa faqa maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Aandaroo firaafa uqanna Kannaana maqasaa darifanoo maasa sipsipauqa nara andanda sia marifaqa maasa maa maqa maaqanaki marirara umidaqa. Amanee eedoo qirana qiminaqa maasa Kooseena maqa maaqaki marianauree. ");
INSERT INTO bjr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraoofa misa ufa iriseenoo Yooseefaana qimaminoo qinau. Doo ani akoofa faqa ani afasausa faqa ani faqa mariraree qidee. ");
INSERT INTO bjr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Isipa maqa maaqa misaindi maridanoo. Sainaqa Kooseena maqa maaqaki mariaqa. Kooseena maqa maaqa amiqirafa maridanoo. Ani afasausa kinaana moo qafainanoo sipsipa burimakau amiqi mandee rakisi marinnana mina mareeqeenana quqasainanoo mifa qini sipsipa burimakausaa rakisiani. ");
INSERT INTO bjr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Miqi qimasoofanoo Yooseefaafa narí akoona afiqeenoo Faraoo fuqoo minisoofanoo Yakooboofa miqoo anireenoo Faraoona afaaqooqa qimama qanau. ");
INSERT INTO bjr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Miqi qimasoofanoo Faraoofa Yakooboona aukuanara iramirinau. Ani aukuana naqummee maridanoo fee qufanoo Yakooboofa qinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Qinee 130 aukuana kai maa maqanasaa maridaqa. Sia kisaaqasaa fau qinee moomoo ummaara paquriqa. Qini qikeeku qikaaku kisaaqasaa uqanna mariqau. Misa aukuana fannoo qini aukuana fiaaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakooboofa miqi qimaseenoo kafaa Faraoona afaaqooqa qimama qaseenoo doo raudamaki finau. ");
INSERT INTO bjr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yooseefaafa narí afasausa mara faqa narí akoona faqa Faraoofa uqoo Isipa maqa maqaki Rameeseesa maqusa aaqa soofaqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Miqiqa miqoo marufanoo Yooseefaafa narí akoona faqa narí afasausa mara faqa narí akoona aiku asauku marusa faqa kaaqa aanaaqi faiqiuqa faqa narana nimi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Aandaroo firaafa uqanna imarufanoo sia uqanna aiqama tinai narana marinau. Isipa maqannaa fasiqa anaasee faqa Kannaana maqannaa fasiqa anaasee faqa naararoofaqa ummooquka iqa nimariqau. ");
INSERT INTO bjr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Misa narana feefauri marufanoo Yooseefaafa mi munnimmana mara maree Faraoofa maruqoo munusee mina ami marinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isipa maqannaasa faqa Kannaana maqanaasa faqa narana feefaurida aiqama nári munnimma taikaqau. Miqi maseeqa Isipa maqannaasa anireeqa Yooseefaana qimamiqa qiqau. Maasa munnimma doo taikaseeqa anee sia maasa afu kai qiqafaa kuquana faara narana niminaqa naa. Sia maasa narana qiminaqa maasa ani afusaa kuquanaura. ");
INSERT INTO bjr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Misa miqi qufanoo Yooseefaafa maaqi qimasee nariqa qimanniminau. Inni munnimma taikainaqa inneeeqa aandau aina maree mini qimidaqa narana mina akiiqara maraaqa. ");
INSERT INTO bjr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Miqi qufaqa misa nariqa aandau aina Yooseefaana mini amufanoo misa qoosauqa faqa sipsipauqa faqa mimmiuqa faqa burimakauqa faqa doonkiuqa faqa mina akiiqara narana nimimarinau. Doo mi aukuanna misa nári aandau aina akiiqara Yooseefaafa narana nimi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mi aukuanna taikoofaqa kafaa moo aukuanaki Yooseefaa fuqoo anireeqa maaqi qimasee qimamiqau. Maasa naqi fee mandee moo ainaina ani afusaa kukeeqaanauree, sia. Doo maasa munnimma taika fifaqa maasa aandau aina faqa anindika kai mambifaqa kaqi maridaqa. Sia ani amira ainaina moo marifaqa. Maasa qiqa qifaaqa faqa maasa maqa faqa kai maasaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Maasa ani afusaa kuquaqaa midaqa doo saina maasa qeeqa faiqi faqa maqa faqa mina kai amisaidaqa feefauru marasaidaqa narana naa. Miqimmaseeqa maasa qeeqa faqa Faraoona anainira faiqi kakai iqa maria. Maasa moodaa ainainara kai iridaqa. Narana faqa narana asumu faqa niminaqa maasa qummaqua. Narana qummaquseeqa maasa sia kuqua. ");
INSERT INTO bjr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yooseefaafa misa ufa iriseenoo aiqama Isipa maqa maaqa feefaurumma Faraoona aminau. Aiqama Isipa maqannaasa aandaroo firaafa uqanna narunara nariqa maqa amisee feefauru marasee minannoo narana feefaurumma neemarufanoo aiqama maqa maaqa Faraoonaindika minoo maarinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Miqi marufanoo Yooseefaafa Isipa maqa maaqa dinni atindari dinni atinni marusa mareeqee ainainira faiqika kai masanau. ");
INSERT INTO bjr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Isipa maqannaa amaana maqasaa rakisirausa maqa kai Yooseefaafa sia feefaurinau. Faraoofa maqee maqee munnimma nimi marufaqa narana feefaurummasaida neemarufaqa sia misa maqa feefauriqau. ");
INSERT INTO bjr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yooseefaafa faiqí anaasee qimanniminoo qinau. Doo innee qafaidee qinee maqee inni faqa inniqa maqa faqa feefaurumma Faraoona amiqa. Maqee narana asumu nimianaqa inneeqa maqa Faraoona amu maqanaki kafaa qummaquaqa. ");
INSERT INTO bjr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Narana anoona mambinaqa moodaaqoo unaku quqaseeqa aiqama moodaannai qisaukukinaana moodaa moodaa Faraoona amisee akaqana inneeqa faiqi aanaaseera faqa asumuara faqa quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Faiqí anaasee Yooseefaana maaqi qimasee qimamiqa qiqau. Oo Yooseefaafa anee aneenna kai maasa manda ainainasaa itita qisaananoo. Anee kai maasa amiqimma qisaananoo. Uriqararafa maasa amana Faraoona ainainira faiqi marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Miqoo qari Yooseefaafa afeeka sanda ufa quqanau. Mi sanda ufana oosana maaqi minoo maridanoo. Aiqama Isipa maqa maaqakinaa narana unakusee moodaannai qisauku kinaana moodaa Faraoona amiaqa. Mi ufafa maqee kaqi afeekaikinoo maridanoo. Amaana maqasaa rakisi marusa maqa kai sia Faraoonaindikinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isaraee maqannaasa Isipa maqasaa Kooseena maqa maaqaki mariqau. Miqoo maridaqa moomoo ainaina faqaasa marufanoo misa faiqi namu faqa moomoo kambiqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakooboofa qisauku qara taikaseenoo qiku dinni taikaseenoo dinni oonu qaara maraseenoo 17 aukuana Isipa maqasaa marinau. Mina aukuana aiqama moodaanaki 147 aukuana marasee kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mina kuqirafa adeedi rama fufanoo Yakooboofa Yooseefaana aaramaseenoo qimaminau. Anee aneenna asauku qini qifundana ameemaanai quqaseenana sia Isipa maqasaa akundaanauranoofee qimasee qimafeekaikia. ");
INSERT INTO bjr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Qini qiqa qikausa mara nikundoonaki qikundaa. Qini Isipa maqasaaqari mara maree misa nikundooqoo qikundaa. Miqi qufanoo Yooseefaafa narí qimaminoo qinau. Anee qianandee mianaura. ");
INSERT INTO bjr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yooseefaafa narí akoona ufa iriseenoo eedoo qufanoo mina akoofa qinau. Saa sia kaqi eedoo qia, kuqaa qima afeekai kinana eedoo qia. Miqi qimasoofanoo kuqaa Yooseefaafa eedoo qima afeekai kinau. Qima afeekai kammasoofanoo Yakooboofa narí qaarisaa ooqu marifi Anutunara dufi dufi qinau. Innaaru qimasoofanoo Yooseefaafa narí ainainai finau. ");
INSERT INTO bjr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kaqikaaqoo mari kufaqa misa Yooseefaana qimamiqau. Ani akoofa doo amiqimma auridanoo. Yooseefaafa mi ufana iriseenoo narí amaaku qara Mannaaseesa Eefaraimasa nindiqeenoo narí akoofunnai ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Misa Yakooboona qimamiqau ani amaaku Yooseefaafa ani qafarara qumidanoo fee qufanoo Yakooboofa afeekaikammasee findi fufanoo narí qaarisaa ooqu marinau. ");
INSERT INTO bjr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ooqu mari fufanoo Yakooboofa Yooseefaana qimaminoo qinau. Ooqai qinee Kannaana maqa maaqaki nuafannana kinai Rusa maqa maaqaki mariafananoo Anutufa aiqama afeeka faqaafa akooqoo kooroomma fufanoo qini qifaaqooqa qima qimaqanau. ");
INSERT INTO bjr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Mifa maaqi qimasee qini qima qiminau. Qinee moomoo faiqi asumu amiana anisaaqari ani aruakinausa moomoo maqannaasaika mifaranoo. Qinee maa maqana ani aiku asauku nimiananoo naaru naaru misaindika minoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ani amaaku qara Isipa maqasaa kambiqara qanda qinee Kannaana maqasaa kaqi marunaqa kambiqaa qanda Mannaseesa Eefaraimasa qini faiqi qara Reeubeenasa Simeeoonasara foora marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Anee akaqa faiqi namu maqa sainausa misa anindika mambi marifara. Misa nári nifasaa qanda Mannaseesa Eefaraimasakinaa qumiasana ainaina maree faranoo. ");
INSERT INTO bjr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Qinee ani anoona Raseera nammarinara iriqa miqi qidaqa. Mifa qini firaa qimudaoo qiranaki Kannaana maqa maaqaki kuqinau. Qinee Meesapootamia maqa maaqaindari ani mariafananoo aanai Eefarataa maqusa aaqa kuqinau. Qinee mina iri Eefarata maqusai fimaru aanna afainni akundaqiafana. (Maqee Eefarataa maqusara Beedeeree maqusee qidaqa) ");
INSERT INTO bjr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakooboofa miqi qimaseenoo Yooseefaana amaaku qara nindafeenoo qinau. Maaqanda yana faiqi qaree. ");
INSERT INTO bjr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Qufanoo Yooseefaafa qinau. Qini faiqi qara Anutufa Isipa maqasaa mariafananoo qimu qanda maridaqa. Yakooboofa mi ufana iriseenoo qinau. Doo miqanda nifiqee mai qinee unnaqoo adeedi minisainaqa nifaaqooqa qima nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakooboofa nauraiqi marunara sia amiqimmasee afu maqee marinau. Yooseefaafa narí amaakuqara minisoofanoo oonu mafi kaqaramma qumareenoo nimooqanau. ");
INSERT INTO bjr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Nimooqa namasee Yakooboofa Yooseefaana qimaminoo qinau. Qinee sia kaifaa ani qafaanauree qunanoo Anutufa kai qifaqa ani faiqi namu niqafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Miqi qimasoofanoo Yooseefaafa narí akoona afundana saaqaraana narí faiqi qara qumareeqeenoo narí akoona afunni oorindari maqasaa aqufinau. ");
INSERT INTO bjr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yooseefaafa narí akoona afusaa kummarama fufanoo Eefaraimmana mara munu Yakooboona asaaqai quqaseenoo Mannaseena mina asaukuannai quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Quqasoofanoo Yakooboofa asauku qara fiqaree aiqaree mambufanoo akaqa Eefaraimana saa asauku uqannai quqeenoo afasaana Mannaseena saa asaaqai asauku quqanau. ");
INSERT INTO bjr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Miqi mandeenoo Yooseefaana afaaqooqa qimamaqeenoo qinau. Qini qikausa mara Abaraqaammana faqa Isakeena faqa nikoofa Anutufa maa faiqisa amiqi amiqimma nimaqaani. Qini qifiqamaree maaqoo maqee miniqaifaqa marunna Anutufa misa amiqi amiqimma nimaqaani. ");
INSERT INTO bjr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Qini oosana oosana madainaina kinaana itita qimaqoo qangiroofa misa amiqi amiqimma nimaqaani. Qini duqu faqa qini qikooqanda Abaraqaammasa Isakeesa nuqu faqa maa faiqi qandasaa mariani. Miqanda moomoo faiqi maqasaifanoo moomoo miqanda kiqari kambiqafi mariaqa. ");
INSERT INTO bjr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yooseefaafa narí akoona asauku qafoofanoo aundura mandai kufanoo narí akoona asauku qumareenoo afasaanasaa asaaqai asauku quqaqoona mareeqee akaqasaa quqasee akaqasaa asaukuannai asauku quqaqoona mareeqee afasaanasaa quqarara qinau. ");
INSERT INTO bjr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Oo qipoo anee sia andeeqaananoo indaaruqaafa mai maridanoo aneenna asauku uqannai asauku mina akiiqasaa quqaaqaana. ");
INSERT INTO bjr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Miqi qufanoo mina akoofa qaoo qida qinau. Qini qimaaku qinee iridaqa miqidaqa. Indaaruqaafa mifa faqa mina aiku asauku moomoo marifaranoo. Inaaqiannaana aiku asaukuqa firaa afeeka maqannaauqanna marifaranoo narí afasaana ooraaqaranoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Miqi qimaseenoo mi faasaanna nifaaqooqa qima nimaqeenoo qinau. Isaraee maqannaasa nifaaqooqa qiqa anisaa qimasaida qifaranoo. Misa maaqi qifaranoo Anutufa Eefaraimmana faqa Mannaseena undeemma amaqaani. Miqunannai Yakooboofa Eefaraimmana uqeerasee Mannaseena rafaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Miqi qimaseenoo Yakooboofa Yooseefaana qimaminoo qinau. Qinee kuqirara midaqa Anutufa ani faqa maridanoo ani afiqee aninna akeeku akaaku maqasaa ooru fuannoo. ");
INSERT INTO bjr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Seekeemma maqa maaqa amiqirafa maridanoo. Qinee ooqai qeeqa duru feefannoo Amoora maqannaasa faqa rakusee maraafanna maqana ani amianaura sia ani akaqaa fasaauqa nimianaura. ");
INSERT INTO bjr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakooboofa narí faiqi namu naaramaseenoo qima niminau. Innee aiqama maaqoo aniraifaqa kasooaqee inni kina kambiqaaninna ainainara qima nimiana iriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Innee qini Yakooboosa faiqi namu innee qini fiqu fiqu mambifaqa inneeqa nikausa qini Isaraeerasa ufa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reeubeenafa anee qini ooqa faiqi mariananoo. Anee qini afeeka indaaruqaafa mariananoo. Anee aiqama qini faiqi namu kiqari uriqararafa kaaqa afeekaiki marianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Anee nammari aufindee imarianafa kaaqa afeekaiki marianafa mariananoo. Anee sia uriqarana marinnaranoo. Anee qini qaarisaa qini ainainira anaasee sakasee faiqaannanara miqinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeeoonasa Reefisa innee qara moodaa fidika mariafanoo. Innee qara inneeqa rakira duru saamunnoo faiqí mandaikamma nimaqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Qini irirafa sia misa kukeeqara ufaki ootupanoo maridanoo. Qinee sia miqanda ufa suqiranaki marianaura. Misa nirana qoofaqa faiqí anaasee narusee miqooqari nasuridaqa burimakau akoonauqa naununu ateekaqau. ");
INSERT INTO bjr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Inniqara aannoo qiranasaa niqirafa mariannoo. Innee kaqi fifau nárí marianara minara niqirafa mariannoo. Isaraee maqa maaqakina inniqara faiqi namu furufaramambuaqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yakooboofa miqanda nifaaqooqa qimaseenoo quandafinoo Yudana afaaqooqa qinau. Yuda, ani akaqaafasaa ani amooqifara. Anee aneenna namuqaa ninukasaa reenana rafaaqa finafa mariananoo. Ani akoona faiqi namu ani oorinni niqoori saunu areefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda anee kaasau aandaura foora faiqí nárí marianafa mariananoo. Anee firaa kaasau ainaina mariana, anee aandau arusee namasee faiqaqee inanoo moo fannoo sia ani afauriannoo, rufiaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yudafa karaambaiqa duru feefa uaqeeiannoo. Minasaa ani aruakinausa uriqaraqa maridaqa rakisi nimaqeefaranoo. Mifa uriqarara auqu marasee rakisi nimaqanoo fifiinoo Siroo maqusaki oonuraannoo. Miqoo maridanoo aiqama maqannaasa mina ameemaanai marifanoo rakisinnimaqaannoo mina aiku oosana maridaqa mina ufa mau kai fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mifa narí doonki timmusa uainna sandasaa rumbeenoo. Uainnauqakiqari kaaqa amiqiranasaa rumbeenoo. Mifa narí qamunna fidika arira uainna anoonaki nammaruqinoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mifa uainna neemarifanoo mina afu fidikandanda inoo marifanoo mimmi naamma anoona neemarifanoo afai eekara aridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Miqi qimasee Yudana qimamiseenoo Seeburunana quandafi afaaqooqa qinau. Seeburuna, anee ooruku nammari afainni marinaranoo. Sipauqaindi nammariara rufiasee ani mandaaqasee marifara. Ani maqa maaqa oosu Sidoona maqa maaqa ati raquru aminoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Miqi qimasee Seeburuna qimamiseenoo Yakooboofa quanda finoo Isakaana afaaqooqa qinau. Isakaa anee afeeka doonkiara foora mafinana narana uqauqa amuaaqa faiqaqeeia. ");
INSERT INTO bjr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Isakaafa idooara maqusa qafoofanoo amiqinoo marufanoo kummarama fufanoo ataufakaaqa firaa ummaara quqasee maranoo nimarinau. Mifa ainainira faiqiara foora ainainiannoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Yakooboofa Isakaana qimamiseenoo quandafinoo Dannaana afaaqooqa qinau. Dannaafa narí maqannaasa uriqararafa mariannoo. Misa Isaraee maqannaa foora marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Anee ukadiqara foora aana afainni marinanoo qoosa fannoo aatata finana aiku raquraminanoo maqasaa aqufinanoo faiqí minasaa marina afiqu aqusainanoo aanaaqiannaindari aqufuani. ");
INSERT INTO bjr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yakooboofa Dannaanara miqi qimaseenoo Anutunara innaaru qinoo qinau. Oo Yaawee qinee ani dadaaqiranara afeesidaa. ");
INSERT INTO bjr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Miqi qimaseenoo Kadannana afaaqooqa qinau. Kada nipuraraa fasiqauqa ani arifaranoo. Miqifana anee quandaki nariqa nifaqee finnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Miqi qimaseenoo Yakooboofa Aseeranara qinau. Ani maqa maaqaki narana moomoo amiqirafa kai mariannoo. Anee kinna ami mariandee ira narana kai neemarinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napatari anee kaasau aandaura fooqaana maridana aneenna aidiranasaa sandana nua. Anee amiqira faiqi moomoo maqeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yooseefaafa anee irumu miqirafa maridana nammari afainni kambiqafi aqama moomoo ireennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ani namuqaa nimudaanai qimasee nári duru feefannoo ani arirara afaqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Miqifanoo Yooseefaana duru fannoo sia paruparuqiannoo tipu kai qinoo mariannoo. Yakooboona Anutufa aiqama afeeka faqaafa mina afeeka aminanoo mina asauku fannoo afeekaikiannoo. Mi Anutufa Isaraee maqannaasa rakisirafa misa afeeka kukeeqara maqusa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ani akoona Anutufa ani dadaaqiannoo. Aiqama afeeka faqaa Anutufa ani amiqi amiqiani. Innaarunaindaraa aakunnoo ani amiqi amiqimma amaqaannoo. Maqakiqari ururainna nammarifa ani amiqi amiqirana amiani. Ani burimakau aandau faqa faiqi aanaaqiuqa faqa amiqi amiqimma nimaqaani. ");
INSERT INTO bjr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Moomoo taatuqeenauqa faqa sakummauqannoo faqa ani amiqi amiqimma amaqaani. Ooqeenaa aaqanasaaqaraa amiqi amiqirafa ani amiqi amiqiannoo. Naaruara marira aaqanasaaqaraa amiqi amiqirafa ani amiqimma amaqaani. Oosana oosana ainaina qinee qunna amiqi amiqirafa ani Yooseefaanasaa mariannoo. Anee aneenna afasausa kiqari uriqararafa marinnanasa mi ainainausa anisaa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Miqi qimasee Yooseefaana qimamisee quandafinoo Beensaminna qimaminau. Beensaminna anee kaasau fainiara foora marinaranoo. Anee kananaana faqa eendimarinana faqa aandau arusee neennaranoo. ");
INSERT INTO bjr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Doo miqimasee Yakooboofa narí faiqi namu indaaruqaana saa oosana araseenoo aiqama mafi nifaaqooqa qimasanau. Miqimasoofaqa misa qisauku qara taikasee qikunooqu qaara marasee oosana faiqi namu Isaraee maqannaa mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakooboofa nifaaqooqa qimannimaqaseenoo maaqi qimasee narí faiqi namu qimaniminau. Qinee kaqi kaaqoo kuqiqa qeeqa qikeeku qikaaku marianaki oonu ootupaanaura. Innee sia maaqoo qikundaaqa. Ooqai Abaraqaammafa nikundara maqa feefauru maqoofa maridanoo. Qeeta maqannaa Eefaroona maqaki qini qikausa nikundoonaki qini faqa qikundaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kannaana maqa maaqaki Makapeera maqusa Mamareena maqusa suani afu oosana qaanai maridanoo. Abaraqaammafa Eefaroonafa unnai mi maqana feefaurummaseenoo nikundanau. ");
INSERT INTO bjr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Miqoo misa Abaraqaammana faqa mina anaaqa Saraqa nammmarina faqa nikundaqau. Minakikai Isakeena faqa mina anaaqa Reebeeka nammarina faqa nikundaqau. Qinee minaki inni ninoona Reeaa nammarina akundeeqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Mi maqana faqa minakinaa ooni aamara faqa Qeeta maqannaasa unnai feefauriqia. Qini minaki qikundaaqa. ");
INSERT INTO bjr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakooboofa narí faiqi namu qimannimi taikasee aiku raqandaammasee doo kuqinoo narí akeeku akaaku unnai finau. ");
INSERT INTO bjr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yakooboofa kuqu fufanoo Yooseefaafa aundura mandaikufanoo narí akoona qirisaa roofeebaaqa mambufanoo narí akoona oori amooqeenoo qiki raqanau. ");
INSERT INTO bjr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Qiki raqaseenoo Yooseefaafa Isipa maqannaa oosana mareenoo tutaqausa qimannimufaqa anireeqa sia kai kaqi mandaikianifeera marasinna oosana oosana akuamaqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Misa Isipa maqannaasa oosana maraseeqa qaara fasiqa niku nisauku taikasee 40 faasaanasaa marasinna Yakooboona qiri akuamaqaqau. Isipa maqannaa qaaramoo fasiqa faqa qisaukuqara taikasee 70 faasaanasaa Yakooboonara iki raqaida soofaari mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Soofaarirana taikasoofanoo Yooseefaafa Faraoona aaqa marusa uriqararausa qimanniminoo qinau. Innee maa ufana mara maree munu karaambaiqa Faraoona qimamiaqa. ");
INSERT INTO bjr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Qini qikoofa kuqirara idanoo qima afeekaikammasee qini qima qiminoo qinau. Qinee kuquanana qini qiri mara maree Kannaana maqa maaqaki ooni aamara deedaqamma qaafannanaki qikundaa. Minara amanee qinee oorureeqa qeeqa qikoona minaki akundamaseeqa qumuanauree. ");
INSERT INTO bjr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Minara Faraoofa irisee qimaminau. Doo ooruree aneenna qima afeekaikianandee inana aneenna akoona akundamasee qumua. ");
INSERT INTO bjr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yooseefaafa narí akoona akundarara oorufufaqa Faraoona aaqa uriqararausa marusa faqa Faraoona koota irimarusa uriqararausa faqa Isipa maqannaasa indaarunniki imaru fasiqausa faqa Yooseefaana faqa ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Mina aiku asauku faqa mina afasausa mara faqa mina akoona aiku asauku akaqausa faqa aiqamausa Yooseefaana faqa ooru fiqau. Misa aandau faqa faiqi aanaaqiuqa faqa kaqi kai Kooseena maqa maaqaki mariqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Akaqausa qoosasaa ooru fiqau. Akaqausa qoosa rariseemaru karanaki ooru fiqau. Yooseefaana faqa faiqí tatufufaqa ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Misa aiqamausa suani oosana qaanai Yooradana nammari afainni sakuma faqa raisa adiuqa mara qaqimaru maqusanasaa ooruree misa firaaqoo kisaaqasaa soofaariqau. Yooseefaafa narí akoonara qisauku dinni taikasee dinni ani qaara marasee 7 faasaana soofaarinau. ");
INSERT INTO bjr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kannaana maqusanaasa miqoo marusa iki raqoona qafamasee qiqau. Nindafaaqa Isipa maqannaa firaaqoo faaqa rumasaida iki raqaida. Miqi qimaseeqa misa mi maqusana auqu Abeera Misaraima fee qimariqau. Mi auquna oosana Isipa maqannaa soofaarira maqusa fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yakooboona faiqi namu nári nikoofa qimannimundee iqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Misa nári nikoona qiri mara maree Kannaana maqa maaqai ooruree Makapeeraa maqa maaqaki Mamaree maqusa suani oosana qaannai marufaqa miqoo ooni aamaraki akundaqau. Qeeta maqanaa fasiqa mina auqu Eefaroona Abaraqaammafa feefauru maqoonaki quqaqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yooseefaafa narí akoona akundamaseenoo narí faqa fusa narí akaqaafasaauqa faqa moosa faqa kafaa anirandee Isipa maqusai fiqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yooseefaana akaqaa fasaauqa misa nikoofa kuqufufaqa Yooseefaanara rufieeqa narí qimami narí qimami qiqau. Ooqai maasa Yooseefaana mandaika mamaqaafanausa marida. Mina akiiqara iannoofee. ");
INSERT INTO bjr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Misa miqi qimaseeqa Yooseefaa funnai ufa quqaseeqa maaqi qimasee qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Oo Yooseefaa maasa qikoofa kuqiraridanoo aniara maaqi qimasee maasa qimaqiminau. Yooseefaa ani akaqaafasaa ani mandaika mamaqoonara qaunummasaa siamma iria. Misa ani mandaika mamaqoonara doo qinee mi ufana oosana iriqa. Maasa qikoofa miqi qunara minara maasa ani qimamidaqa. Ani akoona Anutuna ainainira faiqiuqa maasa ani mandaikamma amaqaafanna numoona minni qisaa. Miqi qufanoo Yooseefaafa minara iriseenoo iki raqanau. ");
INSERT INTO bjr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Mina akaqaa fasaauqa minara iriseeqa anireeqa nariqa Yooseefaana oorinni maqasaa kummarama fufaqa qiqau. Maasa ani ainainira faiqi kakai mambi marianaura. ");
INSERT INTO bjr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yooseefaafa iriseenoo qinau. Innee sia qiniara rufiaaqa. Sia qinee qeeqa qifaaqa Anutuna amaaqa maqaanaura. ");
INSERT INTO bjr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kuqaa innee qini mandaikamma qimaqaaneera tipundaarufanoo Anutufa mina mara quandasoofanoo amiqinau. Moomoo maqee kaqi mariasa marirana dadaaqianifeera miqinau. ");
INSERT INTO bjr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Sia rufiaaqa. Qinee inni faqa inni faiqi anaasee faqa narana nimida rakisi nimaqaanaura. Miqi qimasee Yooseefaafa narí ainaina nifaaqa quqaaqeera qima niminau. ");
INSERT INTO bjr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Miqoo Yooseefaafa Isipa maqannai narí ainaina faqa kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Mifa wan handereeta faqa qisauku qara faqa 110 maraseenoo kuqinau. Yooseefaafa miqoo maridanoo narí amaaku Eefaraimmana faiqi faqa qafanau narí anaiqi faqa narí afaqnausa faqa nindafanau. Yooseefaafa Mannaaseena faiqi Makirana faiqi namu narí afaqnausa marasee f irinau. ");
INSERT INTO bjr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kuqiraridanoo Yooseefaafa maaqi qimasee narí ainaina qimanniminau. Qinee kuqirarammidaqa. Qinee kuqu fuananoo Anutufa innisaa rakisidanoo inni indaarunnikinaqa ooqai Abaraqaammana faqa Isakeena faqa Yakooboona faqa qima afeekaika mandee nimiqoo maqanasaa inni nindiqamaree miqoo munu quqaannoo. ");
INSERT INTO bjr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yooseefaafa minara kai kafaa qimanniminau. Anutufa inni nifiqee finaqa qini qimudaani faqa mara mareeqa miqoo munu madikama qisaaqa. Innee minara qima afeekai kifaqa qinee iria. Misa irisee qima afeekaikammasoofanoo Yooseefaafa kuqinau. ");
INSERT INTO bjr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yooseefaafa Isipa maqa maaqaki maridanoo wan handeereeta faqa qisauku qara faqa 110 aukuana maraseenoo kuqinau. Kuqufufaqa misa sia kai kaqi putaa ianifeera mi marasinna aku amaqaseeqa bukisaki quqaqoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yakooboona amaaku oondamara misa faqa Isipa maqusai ooqu fusa misa nuqu maaqimminoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reeubeenafa faqa Simeeoonafa faqa Reefifa faqa Yudafa faqa ");
INSERT INTO bjr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","4","Isakarafa faqa Seeburunafa faqa Beensaminafa faqa Dannaafa faqa Napatarifa faqa Kadaafa faqa Aseerafa faqa minamusa faqa misa faiqinamu faqa nári nikoona ninaakuna faqa Isipa maqa maaqaki ooqu fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Moodaanaki ruqauiqa ooqu fusa qaaramoo fasiqa niku nisauku taikasee moo fasiqa asaukuqara kai taikasee 70 Isipa maqa maaqaki ooqu mariqau. Yooseefaafa ooqai miqoo maruqoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","7","Miqoo mariiufaqa Yooseefaafa faqa narí afasausamara faqa aiqama mi akiiqausa kuqu taikafufaqa misa faiqi namu niku nisauku findifufaqa faiqi moomoo uqanna maqasoofaqa kambiqaqau. Kambiqafiqa Isipa maqa maaqa umbiqamma aqiqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Faraoofa Isipa maqannaa rakisirafa kuqufufanoo kisaaqasaa marinoo fuka moo Faraoofa kambiqanau. Mifa Yooseefaanara faqa aandaroo aukuana rakisiiunara faqa mina aiku asaukuara faqa sia irinau. ");
INSERT INTO bjr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Faraoofa narí maqannaasa qimanniminoo qinau. Isaraee maqannaasa moomoo uqanna maqa maaqa umbiaqa mariafaqa maasa uridaaqaramaseeqa maasa rafaaqafu qimaqeefaara. ");
INSERT INTO bjr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Rakirafa kambiqainaqa misa maasa namuqaa faqa moodaanaki kammafi maasa darusee quqasee sandee foora. Inni saimbaqa naqifee mandee oonumafi irisee misa rafaaqafusaanaqee misa sia moomoo kambiqeefaree. ");
INSERT INTO bjr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Miqi qimasoofaqa Isipa maqannaasa Isaraee maqannaasa karafusa saika nimiqau. Afeeka rakisirausa misasaa rakisi mariqau. Isaraee maqannaasa karafusaki maridaqa qaara maqusa auqiqau. Moo maqusa auqu Pitoona maqusa auqusee moo maqusa auqu Raqamaseesa maqusa auqiqau. Mi maqusa qanda narana afeedimaru maqusa qanda mariqau. Qafee maqannai kai maaqa usakeemariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isipa maqannaasa Isaraee maqannaa kafaa kafaa ummaara nimufaqa moomoo kambiqafiqa maqa maaqa qumbiaqau. Isipa maqannaa misa nindafeeqa kaaqa rufiee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Miqunara sia moomoo asumu kambiqaaqeera firaa kadaapi uqanna misa nimuaaqa quqasoofaqa misa manda marira mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Isipa maqannaasa qufaqa Isaraee maqannaa qafee maqa qumaree ausirira ooniara foora moomoo auquseeqa minannai maaqa usakeeqa kafaa afuqaki ainaina faqa imariqau. Miqi marufaqa sia Isipa maqannaasa misara qimudaoo qimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Faraoofa mi kadaapirirana Isaraee maqannaa nimiseenoo quandafinoo Isareee maqannaa anaasee qaaraqanda Sifaraa nammarisa Puaa nammarisa inaamunai fusasaa rakisimaru anaasee qanda qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Inneeqara innaamunai fidaqara dadaaqiqa faiqi maqaseeqa akoonaiqi aiqama aaqee uqanna rutukuaqa, maanaaqa kai kaqi mariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mi anaaseeqanda Faraoona ufa iriseeqara Anutuna ufara rufiaseeqa sia akoonaiqiuqa nárí mariqau, kaqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Faraoofa akoonaiqi moomoo kambiqoofanoo nindafamaseenoo innaamunai nifiqaqanu aanaaseeqanda naaramaseenoo niqinoo qinau. Inneeqara naqaafee ifaqee sia akoonaiqi naridee qini ufa rukiaafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Miqanda mina ufa iriseeqa qiqau. Heeburu anaasee sia Isipa anaasee naannaraidaqa misa kaqi kaqi faiqi maqaidaqa. Maaqanda oonu raunaqa faasai faiqi maqaqaafaqa oonu nindafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Anutufa mi anaaseeqanda oosana nindafamaseenoo amiqi amiqimasoofaqa Isaraee maqannaasa moomoo kambiqafiqa afeeka maqannaa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Miqanda Anutunara rufioofanoo mina akiiqara Anutufa miqanda faqa faiqi asumu niminau. ");
INSERT INTO bjr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Faraoofa misa nindafeenoo narí maqannaa Isipa maqannaa aiqamausa naaramaseenoo ufa afeeka ufa qimanniminau. Heeburu anaasee akoonaiqi maqasaifaqa innee mina mareeqee nammari firaana Niru nammariki aqusaifaqa kuquaqa. Aiqama kuquaqeera maanaaqauqa kai kaqi mariaqeera qinau. Miqi qimasoofaqa miqimmi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Mi kamuqoo mi aukuanna Reefina atikiqari kumaaraa moo fannoo findi finoo maanaaqa Reefina oosanaki maranau. ");
INSERT INTO bjr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Maraseenoo faiqi moo akoonaiqi maqaseenoo mina anoofa qafoofanoo amiqira faiqi marufanoo Isipa maqannaasa arifoo qimaseenoo qaaramoo quqoonasaa kukeeqa amaqaqoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Qaaramoo quqoona aiqaroofanoo faiqi aanaaqi kaqikaaqoo aaqoo irufanoo mina anoofa akoofa rafaaqafirara oonumafi irusia mina anoofa furaa amanee uqa kisaaqa difaaniara foora auqinau. Mifa koorootaqa qumareenoo furaa uqamau sia nammari ruqiqaki keeqaanifeera akinau. Uqa auquseenoo mina anoofa faiqi aanaaqi uqaki rumaseenoo furaa moomoo nammari ammausai marunaki kukeeqaqoofanoo minaki marinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nammariki marufanoo mi faiqina anasaafa nianaindari kukeeqanoo maridanoo rakisi marinau. Nanee kambiqaannoo qimasaidanoo rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Faraoona araamuna nammari auqaaneera narí rakisimaru manaaqausa faqa mi nammarinai quminau. Mifa nammari auqaidanoo furaaki qafoofanoo uqa marinau. Marufanoo qafamaseenoo narí ainaini maru manaaqana qimamufanoo mi uqana nammarikinaana maranau. ");
INSERT INTO bjr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Marasoofanoo Faraoona araamuna asaukukinaana maraseenoo uqa oo raqasee faiqi aanaaqi qafanau. Faiqi aanaaqi ikiraqoofanoo mina irufanoo amuqusufanoo qinau. Maafa Heeburu maqannaasa faiqi akoonaiqi maridanoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Mifa miqi qimarufanoo mi faiqi anaaqina anasaafa anireenoo Faraoona araamuna maaqi qimasee qimaminau. Amanee Heeburu anaasee moo ooru afiqee muqusaananoo fee naamma amiannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraoona araamuna eedoo qufanoo mi faiqi anaaqina anasaafa ooru nári ninoona uqanna afiqee quminau. ");
INSERT INTO bjr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Qumuroofanoo Faraoona araamuna fannoo maaqi qimaseenoo mi anaaseena qimaminau. Anee maa faiqi anaaqina naamma amidana rakisi marinaqa qinee maqee maqee feefauru ani ami marianauranoo. Mi anaaseefa eedoo qimaseenoo narí faiqi aanaaqi uqanna narí maaqai munu qaqee idanoo rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mi faiqi anaaqifa kaqi kaaqoo innooqafufanoo narí anoofa afiqeenoo Faraoona araamuna maruqoo minisoofanoo narí faiqi kamambinau. Fuka anoofa auqu rarara maaqi qinau. Qinee nammarikinaana maraunnanara auqu Mooseenee qianaura. ");
INSERT INTO bjr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mariiufanoo Mooseefa innooqafufanoo moo kari narí maqanna Isaraee maqannaasa oonu nindafoofaqa firaa kadaapi rimariqau. Isipa maqannaa moo fannoo Heeburu maqannaa Mooseena aqoonnana arimarufanoo Mooseefa qafanau. ");
INSERT INTO bjr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Aranaqoofanoo faiqiara dinni dinni munu afu maqee mini afu maqee ufanoo faiqí sia marufanoo Isipa maqannaa fasiqa Mooseefa kuqa aruseenoo mina iri nukuda afaqaseenoo minaki kukeeqasee akundanau. ");
INSERT INTO bjr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Iqaqoofanoo kananaana rafudamakufanoo Mooseefa narí maqannaa nindafarara kafaa finau. Oonuree nindafoofaqa Heeburu fasiqa qaaraqanda rakiqau. Mooseefa aqoonnana arimaruna qimaminoo qinau. Anee naqaafee ifanee aneenna aqoonnana oosana siainaki fifau aridanee. ");
INSERT INTO bjr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Miqi qufanoo aru fasiqafa qinau. Yafee aniara karaambaiqee qifanee anee maasa ufa irisee andeeqaidanee. Eenda anee Isipa maqannaa aruanafa kafaa maqee qini faqa darinnaree qufanoo Mooseefa tautinau. Tautumandee qinau. Doo eenda arunnanara aiqama kooroomminoo maridanoommifoo qimaseenoo rufianau. ");
INSERT INTO bjr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faraoofa minara iriseenoo Mooseena kuqa aruaneera ufanoo Mooseefa minara rufiamareenoo Isipa maqa maaqa quqasee Midianna maqa maaqai nianai sandanau. ");
INSERT INTO bjr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Sandee oonureenoo nammari madika afaisaa ooqu marinau. Midianna maqannaa amaana maqaki aanaiqikirana mina auqu Yeetaroona araamuqmaaka dinni qisauku taikasee dinni oonu qaara marasee 7 mariqau. Mooseefa nammari madika afaisaa marufaqa mi manaaqausa nári nikoona sipsipauqa faqa mimmiuqa faqa nammari saka nimianee qimasee aniraqau. ");
INSERT INTO bjr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Faiqí akaqausa nári sipsipasaa rakisimarusa mi manaaqausa niqiqoofaqa anirandee fufaqa misa nári sipsipa naaree nammari nimianeera qufanoo Mooseefa findifinoo misara qaoo qimaseenoo maanaaqauqa naaroofaqa aniroofanoo Mooseefa narí kai misa sipsipauqa faqa mimmiuqa faqa nammari saka niminau. ");
INSERT INTO bjr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Mi manaaqausa sipsipauqa nammari neeneesoofaqa nifiqee maaqai fiqau. Oonu roofanoo misa nikoofa iramirinoo qinau. Innee naqifee ifaqee maqee faasaanasaa anidee. ");
INSERT INTO bjr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Miqi qufaqa misa qiqau. Isipa maqannaa fasiqa moo fannoo faiqí sipsipasaa rakisi mariasa oonu raafanoo misara qaoo qimaseenoo maasa sipsipauqa narí kai nammari saka qumaree nimiisaifaqa dauni anidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Misa nikoofa mina irinoo qinau. Mi fasiqafa yaifee maridanoo fee. Nanaree innee minni aisee anidee. Doo sandee oonu afiqaifanoo narana ani naani. Miqi qimasoofaqa oonu Mooseena afiqee aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Yeetaroofa Mooseenara qini faqa mariannee qufanoo eedoo qimasee marinau. Marufanoo Yeetaroofa narí araamuna Sipooraa nammarina Mooseena amufanoo maranau. ");
INSERT INTO bjr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Maraseenoo faiqi akoonaiqi maqanau. Maqaseenoo Mooseefa narí faiqi auqureenoo qinee aanaamuru maqusaki maridee qimaseenoo Keerasoomma nee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Mooseefa miqoo moomoo aukuanaki marufanoo Isipa maqanna karaambaiqa Faraoofa kuqinau. Kuqufufaqa Isaraee maqannaasa Isipa maqannaasa afeeka rumbarana ameemaanai kaqi kai annadannada qidaqa maridaqa Anutufinnai dadaaqianifeera innaaru qimariqau. Misa innaaru qirafa Anutufinnai ooru finau. ");
INSERT INTO bjr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Anutufa misa qiki raqarana iriseenoo Abarahaamana faqa Isakeena faqa Yakooboona faqa moodaanaki kira ufa qimaqoofa misa faiqinamu faqa dadaaqianifeera oonu mafi irinau. ");
INSERT INTO bjr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Anutufa misa mandainainaki marufanoo misara oonu mafi irufanoo amuqusinau. ");
INSERT INTO bjr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moo kari Mooseefa narí airaamaku Yeetaroona Midianna maqannaa amaana maqaki aanaiqi kirafa maruna sipsipasaa faqa mimmisaa faqa rakisi marinau. Moo kari Mooseefa narí airaamaku sipsipauqa faqa mimmiuqa faqa nifiqa mareenoo aadana maqa maaqa fiqareenoo Hooreeba naaquqara aaqanasaa muruqoofaqa andanda neemarufanoo rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Miqi marufanoo Anutuna qangiroo Mooseena afusaa tautumma amaqaseenoo kooroomafinoo saqari amimikiqari idauru kambiqanau. Mooseefa mina qafoofanoo idauru firaafa qaidanoo sia mi saqari amimina qanau. ");
INSERT INTO bjr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mooseefa mina qafamaseenoo moo ainainammifoo saina aaqa oonuree qafaa, nanaree saqari amimi sia qaidanoo fee qimasee aaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mooseefa quandakinoo aaqa oonu roofanoo Anutufa minakiqari Mooseena aaraidanoo qinau. Moosee Moosee qufanoo Mooseefa iriseenoo maqi qimaseenoo qinau. Qinee maa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Miqi qimasoofanoo Anutufa kafaa qimaminau Moosee sia anee adeedi ania. Aneenna aiku aanaamu raipaqusee miqoo maria. Naaquqara maqa maaqa marinara aneenna aiku aanaamu mara aqua. ");
INSERT INTO bjr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Miqi qimaseenoo Anutufa kafaa qimaminau. Qinee ani akoona Anutusa maridaqa. Abarahaamana faqa Isakeena faqa Yakooboona faqa Anutusa maridaqa. Mooseefa mi ufana iriseenoo Anutuna qafaanoo qimaseenoo rufiaseenoo oorisaa ititanau. ");
INSERT INTO bjr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Anutufa kaifaa Mooseena qimaminoo qinau. Qini faiqí anaasee Isaraee maqannaasa Isipa maqasaa firaa aupurarana nimi mariafaqa nindafaidaqa. Misa qiniara maasa afeeka rakisira rakisi mariasa nisaukukinaana rafia quqaannee qimasee qini daaree mariafaqa iridaqa. Qinee misa aiqama aupurarana maree marianara iridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Qinee innaarunaindari qumuree Isipa maqannaasa nisaukukinaana mareeqee firaa maqa maaqa ainoo faqaa maqa aiqama ainaina rairaa imariqoo quqaanaura. Mi maqanasaa Kannaana maqannaasa faqa Heeta maqannaasa faqa Amoora maqannaasa faqa Peerisita maqannaasa faqa Hifita maqannaasa faqa Yeebusa maqannaasa faqa misauqa mariaqoo quqannisaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isipa maqannaa Heeburu maqannaa radami mariafaqa misa qiki raqee mariafa doo qini daaqoosaa rifaqa niqafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Qinee ani Isipa maqannaa karaambaiqa Faraoo finnai aiqaanana oonureenana qini faiqí anaasee indaarunni kamma nimaqainaqa Faraoona maqa maaqakiqari quqasee aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mooseefa mi ufana iriseenoo Anutunara qaoo qidanoo qinau. Akasaa qinee maaqirausa naqimaseeqee Faraoo finnai oonuree fee Isaraee maqannaasa Isipa maqa maaqaki mariana nifiqaanauree. ");
INSERT INTO bjr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Anutufa iriseenoo qinau. Qinee anifaqa marianana anee Isaraee maqannaasa Isipa maqasaa qaraana nifiqamaree maa aaqannasaa aniree qini qimoo qifaranoo. Miqinna oosanafa qinee ani aiqaafannanara kooroo iannoo. ");
INSERT INTO bjr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mooseefa iriseenoo kafaa Anutuna qimaminoo qinau. Anee qini diqiqaanaqa qinee Isaraee maqannaa innannai oonu reeqa maaqi qianaura. Inni nisaifaqausa ninaakusa Anutufa qini diqiqaifaqa inni qimannimirara anidaqa. Miqi qianaqa misa maaqi qimasee qini ireefaranoo. Mina auqu yafee maridanoo fee qifaqa qinee naqifee qimasee qimannimianauree. ");
INSERT INTO bjr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Anutufa iriseenoo Mooseena qimaminoo qinau. Qinee qeeqa marunausa qidaqa. Anee maaqi qimasee qimannimia. Nariara qinee qeeqa marunausee qimarifa diqiqaifaqa innee iannai anidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Maaqi qimasee kafaa moo faqa qimannimia. Inni nikausa Abarahaammana faqa Isakeena faqa Yakooboona faqa Anutusa Yaaweesa maridaqa ani Isaraee maqannaa iannai ani aqiqaidaqa. Qini mi duqufa naaruara mariannoo. Kasooaqee kambiqainausa qini mi duquna reefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Anutufa kaifaa Mooseena qimaminoo qinau. Anee ooquree Isaraee maqannaa uriqararausa suqusee maaqi qimasee qimannimia. Yaaweefa inni ninaakusa Abarahaammana faqa Isakeena faqa Yakooboona faqa Anutusa qini qifusaa kooroo mafinoo qimaqiminoo. Misa qimannimia, qinee misa iannai aniree qafaunaqa Isipa maqannaasa qumaara moomoo nimimariafaqa qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Qinee Isipa maqa maaqakinaana maraanauree qimasee iridaqa. Misa firaa aupurarana kinaana nifieeqee ainoo faqaa maqasaa irairaa ida reemindeemiri mariqoo Kannaa maqasaa faqa Heeta maqasaa faqa Amoora maqasaa faqa Peerisita maqasaa faqa Hifita maqasaa faqa Yeebusa maqasaa faqa quqannisaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Moosee anee Isaraee maqannaasa mi ufana qimanniminaqa irifara. Anee Isaraee maqannaa uriqararausa faqa nifiqamareenana Isipa maqannaa karaambaiqa marinnai oonuree maaqi qimasee qimamia. Maasa Heeburu maqannaasa Yaaweefa maasa Anutufa maasa qifusaa kooroo mafinoo qimanniminoo. Maqee anee maasara eedoo qinaqa qaaramoo faasaana aadana maqa maaqaki oonuree maasa Yaaweena maasa Anutuna tatufirana suqa amianee qia. ");
INSERT INTO bjr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Qinee iridaqa anee qimaminanoo Isipa maqannaa karaambaiqa fannoo sia inni niiqainaqa fifaranoo. Qinee mina aidafirana amiananoo miqoo inni niiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Qinee qeeqa afeekannai Isipa maqannaasa oosana oosana naaquqara ainainannai fitiqnarana nimianaura. Nimiananoo Faraoofa miqoo inni idukuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Qinee Isipa maqannaasa inniara naaquqarana nimianaqa innee Isipa maqasaaqari sia kaqi fifaranoo. Ainaina nimifaqa maree fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Innee firarifaqa inni ninaaqmaaka Isipa maqannaa aanaaseeuqa nári naaqa maria aanaaseesa faqa nariqa maaqaki mariasara faqa qifaqa qamunna faqa koora faqa siruaa faqa nifaaqa auqi maria ainainausa faqa nimifaqa inneeqa faiqi namu niraamuqmaaka Isipa maqannaa amiqira qamunna ainaina kai afisunnimaqaifaqa maree fuaqa. Miqinnanannai innee Isipa maqannaasa ainaina maree fiara foora ifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mooseefa Anutuna ufa iriseenoo kaifaa iramirinoo qinau. Misa Isaraee maqannaa sia qini ufa qaindusia, sia qini ufa iria qiniara unna fee qimasee Yaaweefa sia ani afusaa kooroo ifana unna qiaanoo qifaqa qinee naqifee ianauree. Naqifee ianaqee misa qini oosana qafee fee kuqaa fee qifaree. ");
INSERT INTO bjr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Miqi qufanoo Anutufa qinau. Ani asaukuki anee nanee uqirafa nidanee, qufanoo Mooseefa qinau. Saunu uqirausa nidaqee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Anutufa iriseenoo qinau. Doo mina maqasaa aqua qufanoo maqasaa aqusoofanoo mi saunufa sakani kambiqa fufanoo Mooseefa mina qafamaseenoo rufiasee sandanau. ");
INSERT INTO bjr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Anutufa kafaa qimaminoo qinau. Aneenna asaukunnai mara miami ameesa qumaraa qufanoo qumaroofanoo kafaa asaukuki saunu kammafinau. ");
INSERT INTO bjr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Miqooqari Yaaweefa Mooseena qimaminau. Anee ooqu Isaraee maqannaa nifusaa miqinaqa misa qiniara Abarahaamana faqa Isakeena faqa Yakooboona faqa misa Yaaweefa misa Anutufa kuqaa ani afusaa kooroo iifoo qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Yaaweefa kafaa Mooseena qimaminau. Anee aneenna siutaki asauku upeekaa. Miqi qufanoo Mooseefa miqimminau. Asauku upeekaseenoo radukusee qafoofanoo asaukumau aiqama namuandaundau inoo marufanoo qafanau. ");
INSERT INTO bjr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Anutufa kafaa qinau aneenna asauku kafaa upeekaa qufanoo upeekaseenoo radukuseenoo qafoofanoo asauku mau namuandaundau irafa sia marinau. Dinniara foora kai marinau. ");
INSERT INTO bjr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Anutufa kafaa Mooseena qimaminoo qinau. Anee indaaru saunu uqannifiqaina sia irifana innaaqiana asauku uqannifiqainaqa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Misa ani mi ainaina qanda qafamasee sia ani ufa irifana anee Niru nammari saka qumareenana aadana maqasaa adiasainanoo fidika kai mandifinaqa qafaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mooseefa Yaaweena ufa iriseenoo qimaminau. Oo Yaawee sia qini diiqaa. Qinee ooqaindari sia amiqimmasee faiqí nifusaa ufa qunausa maridaqa. Maqee anee qini qima qimiannaqooqari sia mifa qini mareeqee ufa qimarunausaikamma qiseenoo. Qinee sia ufa qunausa ufara mamma qimarunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Miqi qufanoo Anutufa Mooseena qimaminoo qinau. Yafee nifauru nimidanoo fee. Yafee sia ufa qiasaika faqa naaqoo qaunirausaika faqa mannisaidanoo fee. Yafee nifu maqarana faqa nifu dimbarana faqa nimidanoo fee. Qinee Yaaweesa kai miqidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Moosee anee doo fua. Qinee ani ufa dadaaqi aakapaanana qinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mooseefa kaifaa Yaaweena qimaminoo qinau. Oo Yaawee anee moo aqiqainanoo fuani. ");
INSERT INTO bjr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Yaaweefa mina iriseenoo aranaqoofanoo qinau. Doo amana ani afasaafa Aaroonafa Reefina atikinaafa andeeqasee ufa qimarifa marifaqa qinee iridaqa. Mifa maqee aniara randanoo anidanoo. Mifa ani paqurimandee asasiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Anee mina qimaminanoo mifa misa qimannimiani. Qinee inniqara dadaaqianaqa ufa qimannimifaranoo. Qinee inneeqara ifandinna ainaina qimannimianaqa auqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Anutufa kafaa Mooseena qimaminau. Aaroonafa ani ufa mareeqee faiqí anaasee qimannimiannoo. Mifa ani oora foora marinana anee mina Anutufara foora maridana mifa auqaaninna ainaina anee aakapeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Anee aneenna saunu faqa uqirafa fua. Minannai oosana oosana ainaina faiqí sia amana auqaaqaa ira ainaina auqeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mooseefa Yaaweena ufa iriseenoo narí airaamaku Yeetaroo funnai oonureenoo qimaminoo qinau. Amanee qinee Isipa maqusai kafaa anirandee oonuree qeeqa ainaina niqafaanauree. Misa kaqi fee maridee doo fee kuqia. Miqiqufanoo Yeetaroofa iriseenoo eedoo qimasee aiqanau. ");
INSERT INTO bjr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mooseefa Midianna maqa maaqai kaqi marufanoo Anutufa kafaa qimaminoo qinau. Doo findi finana kafaa Isipa maqusai fua. Ani arirari marusa doo kuqia. ");
INSERT INTO bjr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mooseefa irisee eedoo qimaseenoo narí anaaqa faqa faiqi namu faqa mareeqee doonkisaa quqaseenoo finau. Anutufa maree fuannee qu saununa faqa maree finau. ");
INSERT INTO bjr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Anutufa Mooseena qimaminoo qinau. Anee Isipa maqa maaqai oonureenana misa karaambaiqa afusaa faiqí sia amana auqaaqaa ira ainaina qinee amiafanna afeekanannoo auqaa. Miqi marinaqa qinee Faraoona kaukaata qira irirana amiananoo sia eedoo qinaqa Isaraee maqannaasa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Anee maaqi qimaseenana Faraoona qimamia. Yaaweefa maaqi qidanoo. Isaraee maqannaasa qini ooqa faiqiara foora maridammiaafoo qia. ");
INSERT INTO bjr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Qinee ani qimamidaqa. Anee qini ooqa faiqiuqa Isaraee maqannaasa quqasainaqa misa oonuree qini qimooqiaqa, qunana anee qaoo qianaqa doo maqee ani ooqa faiqi aruanaura. ");
INSERT INTO bjr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Mooseefa narí faiqi anaasee faqa fidanoo eendufanoo aanai faiqanau. Eendaki Anutufa anireenoo Mooseena kuqa arirara inau. ");
INSERT INTO bjr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Miqufanoo Mooseena anaaqa Sipooraa nammarifa ooni raiqarana qumareenoo narí amaaku afaaqa ati aukuseenoo minannoo Mooseena aiku auqamaseenoo maqasaa quqanau. Quqaseenoo qinau. Anee qini qifaaqi fidika aanaaqi fasiqa mariananoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Miqimmasoofanoo Yaaweefa Mooseena sia arinau. ");
INSERT INTO bjr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Miqi qimarufanoo Yaaweefa Aaroona qimaminoo qinau. Anee aadana maqa maaqai fidana Mooseena paquria. Aaroonafa eedoo qimasee Anutuna naaquqara aaqanai ooru Mooseena paqurinau. Paqurimasee amooqa nanau. ");
INSERT INTO bjr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Amooqasoofanoo Mooseefa Isipa maqa maaqai fuanifeera Yaaweefa qimamuna faqa oosana oosana ainainara faqa Aaroona qimaminau. Yaaweefa faiqí sia amana auqaaqaa ira ainaina auqannee quna faqa Aaroona qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mooseesa Aaroonasa Isipa maqa maaqai ooqureeqa Isaraee maqannaa faiqí firaasa naarama quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Quqaseeqa Yaaweefa Mooseena qimamu ufausa aiqama Aaroonafa qimannimisoofanoo Mooseefa faiqí sia amana auqaaqaa ira ainainauqa misa nifusaa auqanau. ");
INSERT INTO bjr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Isaraee maqannaasa Aaroona mi ufana iriseeqa kuqaa mifoo qiqau. Misa Yaaweefa misa unnai anunara nariqa firaa aupuraranara irisee kumma ramafufaqa innaaru qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Innaaru qimasoofaqa Mooseesa Aaroonasa Faraoo funnai oonuree qimamiqa qiqau. Oo Faraoo, Yaaweefa maasa Isaraee maqannaa Anutufa aniara maaqi qinoo. Anee qini faiqi namu idukusainaqa aadana maqa maaqaki oonureeqa oomaqa mandee qiniara innaaru qidaqa qimooqiaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraoofa miqanda ufa iriseenoo qinau. Yaaweefa yafee. Nanaree mina ufara eedoo qimasee Isaraee maqannaasa niiqaana fifaree. Sia qinee Yaaweenara iridaqa. Minara qinee sia uqanna Isaraee maqannaasa niiqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mooseesa Aaroonasa kafaa Faraoona qimamiqa qiqau. Maasa Heeburu maqannaasa Anutufa maasa qifusaa koorooinoo. Anee maasara eedoo qinaqa qaaramoo faasaana aadana maqa maaqaki oonuree Yaaweena maasa Anutuna tatufirana suqa amianaura. Maasa sia miqiananoo mifa firaa manda auriranannai fee firaa dariranannai fee maasa aiqama daruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Faraoofa iriseenoo Mooseesa Aaroonasa qimanniminoo qinau, inneeqara nanaree faiqí anaasee qini ainaini mariasa nifiqee fuafaqee minnisee fidee. Saina kafaa anirandee ainainiranaki fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Innee Isaraee maqannaasa maqee moomoo kammafi qini ainainirana minnisararee fee qidafee. ");
INSERT INTO bjr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mi faasaana kai Faraoofa Isipa maqannaa karabusasaa rakisi marusa faqa Isaraee maqannaa niqoonausasaa rakisi marusa faqa qimanninoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Innee maqee sia kafaa uita asaki ateekasee Isaraee maqannaa nimifaqa minannoo maaqa usakee maria simmeerana auquaqa. Sai faqa nári kai maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Maraseeqa sia oorudupi masee auquaqa. Aiqama kari auqi mariana amana kai auquaqa. Misa kudiki mariasa maridaqa qiniara maasa idukusainaqa maasa oonuree Yaaweena nári Anutuna tatufirana suqa amianee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Miqi qidaqifaqa innee firaa kadaapi nimifaqa misa oonauqee anauqee idaqa Mooseesa Aaroonasa qinna unnufausa sia iriaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Miqi qufaqa karabusasaa rakisi marusa faqa Isaraee maqannaasa nári niqoonausasaa rakisi marusa oonuree maaqi qimasee Isaraee maqannaasa qimannimiqau. Faraoofa maasara sia uita asaki raraku mini nimiaqee qidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mifa inniara inneeqa kai minakinai randasee maree miniseeqa ooqai auqiu simmeerana amana kai auquaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Miqi qufaqa misa Isipa maqa maaqaki aiqamatinai nidaqa uita asaki randasee suqimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Isipa maqannaa karabusasaa rakisi marusa fuki faaki qidaqa qiqau. Innee ooqai maasa uita asaki nimiafana auqeeundee masee mina amana kai simmeera auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Miqi qimaseeqa karabusasaa rakisi maru Isipa maqannaa fasiqausa Isaraee maqannaasa nári niqoonausasaa rakisiaqeera mara quqaqoosa naruseeqa qiqau. Innee nanaree simmeera ooqai auqiuna amana sia auqidee. ");
INSERT INTO bjr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Qufaqa Isaaraee maqannaa rakisirausa Faraoo funnai oonuree qimamiqa qiqau. Oo uriqararafa. Anee naqaa fee ifanee maasa maaqimma qimaqaidanee. ");
INSERT INTO bjr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Misa sia uita asaki nimiseeqa kaqi maasara simmeera auquaqee qidaqa. Mina saara maasa daria. Sia maasa oosanasaa fau. Inneeqa oosanasaa fifau miqiafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faraoofa iriseenoo qimanniminau. Innee kudiki mariasa ainainiranara nikooqaifaqa qiniara maasa idukuqisainaqa Yaaweena tatufirana suqamianee qimariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Doo kaqi kaqi anirandee inneeqa ainainai fuaqa. Misa sia inni uita asaki nimifaranoo. Inneeqa kai uita asaki maree miniseeqa ooqai iundee kai moomoo simmeera auquaqa. Doo fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isaraee maqannaasa nári niqoonausasaa rakisi marusa Faraoofa ooqai auqiundee kai masee auquaqee qunara irisee doo maasa ummaaraki maridee qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Faraoo funnaindari quqasee anidaqa Mooseesa Aaroonasa misa nifeesidaqa marufaqa ani paquriqau. ");
INSERT INTO bjr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ani paqurimmasee qimannimiqa qiqau. Yaaweefa inniqara oosana qafamaseenoo mina akiiqara nimiannoo. Inneeqara oosana arasaafanoo minasaara Faraoofa narí rakisirausa faqa maasa daruannoo. Inneeqara Faraoofa maasa daruanifeera andaana rumasaafanoo daruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mooseefa misa ufa iriseenoo quandakufanoo oonureenoo Yaaweenara innaaru qinau. Oo Yaawee, anee naqaafee ifanee Isaraee maqannaa maa mandaikana mannimaqaidanee. Anee naqi fee ifanee qini mai diiqeenee. ");
INSERT INTO bjr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Qinee Faraoo funnai oonureeqa ani ufa qimamiafanna qooqari Faraoofa Isaraee maqannaasa mandaika kai mannimaqaidanoo. Anee sia uqanna dadaaqira kari mariananoo. ");
INSERT INTO bjr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yaaweefa Mooseena ufa iriseenoo qimaminau. Amana doo anee maqee qini oosana qafeennaranoo. Qinee Faraoona afeekaikammasee qimamiananoo qini faiqí anaasee idukusainaqa fifaranoo. Sia kaqi idukuannoo qinee qiananoo idukuseenoo fuki faaki qinaqa mina maqasaaqari quqasee fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Anutufa kafaa Mooseena qimaminoo qinau. Qinee Yaaweesa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Qinee Abarahaamana faqa Isakeena faqa Yakooboona faqa misa nifusaa aiqama afeeka faqaa Anutusa qeeqa duqu kooroo iqiafana. Qinee sia qeeqa fuka naaquqara duqu Yaaweesee qirana qimannimi qiafana. ");
INSERT INTO bjr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Qinee qeeqa moodaanaki kira ufa misa faqa qidaqa Kannaana maqa maqa misa nimiraree qima afeekaikiqiafana. Misa minaki asaqiraa faira foora mariunaki quqannisaanauranoo fee qiqiafana. ");
INSERT INTO bjr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Qinee maqee Isaraee maqannaasa Isipa maqanaasa karafusaki maridaqa aupuraida annada annada imarianara iriseeqa qinee qeeqa moodaanaki kira ufara oonu mafi iriqa. ");
INSERT INTO bjr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Moosee anee Isaraee maqannaasa maaqi qimasee qini ufa qimannimia, qinee Yaaweesa maridaqa. Innee Isipa maqannaa rumbaranaki mariana qinee inni idukeeqee asumu mariranaki quqannisaanaura. Qinee afeeka qisaukunnai manda aupurarana Isipa maqannaasasaa quqaanaura. Quqaseeqa inni Isaraee maqannaasa asumu maraanaura. ");
INSERT INTO bjr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Qinee inni qeeqa faiqí aanaaseekammaseeqa qinee inni Anutusa marianaura. Qinee inni Isipa maqannaa karabusa kinaana iduku nisaanaqa miqoo innee qini Anutusara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Qinee inni nifieeqee kuqaa qima afeekaikammasee Abarahaammana faqa Isakeena faqa Yakooboona faqa nimianauree qiafannaqoo quqannisaanaura. Qinee inni nimiananoo mi maqafa innindi kammiannoo. Qinee Yaaweesa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mooseefa Isaraee maqannaasa qima nimufaqa misa sia mina ufa iriqau. Misa firaa ummaara maree marufa mifa misa naaqoo nifu furufara masoofaqa sia iriqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Anutufa kafaa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Anee Isipa maqannaa karaambaiqa Faraoo finnai oonuree Isaraee maqannaasara qimamia. Misa karafusaki mariana idukusaina fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mooseefa mi ufana iriseenoo Yaaweena qimaminoo qinau. Isaraee maqannaasa ririmma sia qini ufa iria naqaa fee masee Faraoofa iriannoo fee. Qinee ufa qirara mamma qimarunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yaaweefa Mooseena faqa Aaroona faqa qimanniminoo qinau. Inneeqara Isaraee maqannaasa faqa Faraoona faqa maaqi qimasee qimannimiaqa, qinee ani Mooseenara Isaraee maqannaasa Isipa maqa maaqaindaraana nifiqee fuannee qunnanara qimannimia. ");
INSERT INTO bjr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Yakooboona indaaruqaa faiqi Reeubeenafa qaara faqa qaara faqa 4 faiqi maqanau. Misa nuqu Hanookafa faqa Paruafa faqa Heesaroona faqa Karamifa faqa minamusa mariqau. Misa nári nifaafaurara maqa maaqakina marusa ninaakusa mara mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeeoonafa qisauku dinni taikasee dinni ani moodaa marasee 6 faiqi maqanau. Misa nuqu Yeemueerafa faqa Yaminafa faqa Ooqadafa faqa Yakinafa faqa Sooqarafa faqa Sauroofa faqa mariqau. Sauroona anoofa Kannaa anaasee marinau. Misa nári nifaafau rara maqa maaqakina marusa ninaakusa mara mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Reefifa qaara moo faiqi maqanau. Misa nuqu Keerasoonafa faqa Kooqatafa faqa Meerarifa faqa mariqau. Misa nikoofa Reefifa 137 aukuana maraseenoo kuqinau. Misa nári nifaafaurara maqa maaqakina marusa ninaakusa mara mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Keerasoonafa qaara faiqi maqanau. Miqanda nuqu Ribinifa faqa Simeeifa faqa mariqau. Miqandasaaqari moomoo kambiaqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kooqatafa qaara faqa qaara faqa 4 faiqi maqanau. Misa nuqu Amarammafa faqa Isaqaranafa faqa Heebaroonafa faqa Usieerafa faqa mariqau. Misa nikoofa Kooqatafa 133 aukuana marasee kuqinau. ");
INSERT INTO bjr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meerarifa qaara faiqí maqanau. Miqanda nuqu Maqarifa faqa Musaqifa faqa mariqau. Reefina faiqi namu anaiqi mara miqimmiqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amarammafa narí akoona auna narí amaamuna Yookeebeeda nammarina maraseenoo Aaroona faqa Mooseena faqa maqanau. Amarammafa 137 aukuana maraseenoo kuqinau. ");
INSERT INTO bjr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isaqarafa qaaramoo faiqi maqanau. Misa nuqu Kooraafa faqa Neefeekafa faqa Sikirifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usieerafa faqa qaaramoo faiqi maqanau. Misa nuqu Misaeerafa faqa Eerasafanafa faqa Sitirifa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroonafa Aminadafana araamuna Nasoona asookina Eeriseepa nammarina maraseenoo minasaa Nadabana faqa Abiquna faqa Eeriasarana faqa Itamarana faqa maqanau. ");
INSERT INTO bjr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kooraafa qaaramoo faiqi maqanau. Misa nuqu Asirafa faqa Eerakanafa faqa Abiasafa faqa mariqau. Misa Kooraanasaa ani aruaki kambiqainausa ninaakusa mara mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaroona amaaku Eeriasarafa Putieerana araamuna maraseenoo Fineeasana maqanau. Miqimmasee doo Reefinakiqari ani aruaki faiqí oosana oosana mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Yaaweefa Aaroonasa Mooseesara kai qufaqa Isaraee maqannaasa Isipa maqannaasa rumbarana kinaana nifiqa maree aniaqee qimaqoo qanda mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Miqanda kai Isipa maqannaa karaambaiqa Faraoona Isaraee maqanaasa idukuanifeera qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Yaaweefa Isipa maqa maaqaki maaqi qimasee Mooseena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Qinee Yaaweesa maridaqa. Anee Isipa maqanna kaaraambaiqa Faraoona aiqama qinee qunnufana qimamia. ");
INSERT INTO bjr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mooseefa iriseenoo Anutuna qimaminoo qinau. Qinee ufa qirara mamma qimarunausa maridaqa. Faraoofa naqifee masee qini ufa iriannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yaaweefa Mooseena qimaminoo qinau. Qinee ani aiqaanana anee Faraoona afusaa Anutufara foora marinnaranoo Aaroonafa ani afasaafa ani tamummaqara fasiqara foora mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Qinee aiqama ufa qimamunnana anee Aaroona qimaminanoo mifa Faraoona qimaminanoo Isaraee maqannaasa Isipa maqa maaqaki rumbaqa mariana idukusainaqa mi maqa maaqana quqasee fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Inneeqara Faraoona qimami marifaqa qinee kaukaata qimasee qaoo qira irirana amiananoo sia inniqara ufa iriannoo. Qinee moomoo naaquqara ainaina Isipa maqa maaqai auqaananoo sia inni ufa iriannoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Qinee firaa aupurarana uqanna Isipa maqannaasa nimisee qeeqa faiqí anaasee aiqama faiqí oosaa indaarunni kiqa nifiqee fuanaura. ");
INSERT INTO bjr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Qinee Isipa maqannaasa naruseeqa Isaraee maqannaasa misa maqa maaqaki mariana nifiqee fuanaqa Isipa maqannaasa qinee kai Yaaweesa marunnanara misa irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mooseesa Aaroonasa Yaaweena ufa iriseeqa doo miqimmiqau. ");
INSERT INTO bjr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mooseefa Faraoona faqa ufa quu kari Mooseefa 80 aukuana faqaafa marufanoo Aaroonafa 83 aukuana faqaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yaaweefa Mooseesa Aaroonasa qimanniminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Faraoofa inni qarara moo naaquqara ainaina auqamasaifaqa kuqaa anoonee qianee qinaqa Moosee anee Aaroona qimaminanoo mifa narí asaukukinaa saunu maqasaa Faraoona afusaa aqusainanoo sakanikiani. ");
INSERT INTO bjr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mooseesa Aaroonasa Faraoo funnai oonuree Yaaweefa qimannimundee qiqau. Aaroonafa narí saunu Faraoona faqa mina uriqarara fasiqauqa faqa nifusaa aqusoofanoo sakani kinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faraoofa mina qafamaseenoo narí irirana faqaa fasiqauqa faqa narí afunee fasiqauqa faqa naaroofaqa anireeqa nári afuneennoo Aaroonafa auqoo ainaina auqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Mi afunee fasiqausa faqa nariqa saunu maqasaa aqusoofanoo sakanikinau. Sakani kamafufanoo Aaroona saunu fannoo misaindi nambiqamasanau. ");
INSERT INTO bjr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Faraoofa mina qafamaseenoo Yaaweefa qundee inoo kaukaata qira irirafa kaqi minaki marufanoo sia Mooseesa Aaroonasa ufa irinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Sia irufanoo Yaaweefa kafaa Mooseena qimaminoo qinau. Faraoofa kaaqa kaukaata qira irirafa minaki marifanoo idukirara akooqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Duna kananaana Faraoofa Niru nammari auqarara ooqufinaqa inneeqara mina minni ooqu paquriaqa. Sakaniki mari saununa faqa mara maree nammari afainni ooqu marida minara rakisiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Paquri maseeqa maaqi qimasee qimamiaqa. Yaaweefa Heeburu maqannaa Anutufa maaqanda diqiqaifaqa Isaraee maqannaasa anee idukusainaqa aadana maqa maaqai oonureeqa qiniara innaaru qiaqee qifaqa ani qimamidaqa. Anee sia iri mariananoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Maqee Yaaweefa aniara maaqi qidanoo. Anee qinee auqaanna ainaina qafamasee anee qiniara Yaawee fee qimasee irinnaranoo. Anee qafainaqa qinee nammari amuaqu maa saununannoo rukamu amiananoo nammari fannoo fidikaika miannoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Miqinanoo noodaanna minakinaafauqa aiqama kuqu taikainanoo nammari faqa manda unda inaqa Isipa maqannaasa sia amana mi nammarina neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yaaweefa Mooseena kafaa qimaminoo qinau. Anee Aaroona maaqi qimasee qimaminanoo narí saunu qumaree aiqama nammariuqa faqa oorakinaa nammariuqa faqa akammandira nammariuqa faqa aiqama nammari amummaqa uqeeraani. Nammari fannoo aiqama fidikaika kai mafuannoo. Aiqama Isipa maqa maaqakinaa nammariuqaki fidika kai mariannoo. Difaaniki faqa afeeki faqa sakaqainafa faqa kai fidika aruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mooseesa Aaroonasa Yaaweefa qima nimundee iqau. Faraoona faqa mina uriqarara rakisirausa faqa nifusaa Aaroonafa narí saunu uqeeraseenoo nammari amuaqu arufanoo aiqama mi nammarisa fidika kai arinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Noodaanna aiqama nammarikinaafa kuqu taikafufanoo nammari kaaqa manda undufaqa Isipa maqannaasa sia mi nammarisa nee mariqau. Aiqama Isipa maqa maaqakinaa nammariuqaki fidika kai arinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Faraoona afunee fasiqauqa nariqa afuneennoo Aaroonafa undee iqau. Miqufanoo Faraoofa Yaaweefa qundee inoo kaukaata qinoo Mooseesa Aaroonasa ufa sia irinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraoofa mina qafamaseenoo narí maaqai oonureenoo sia mi ainainausara irinau. ");
INSERT INTO bjr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Isipa maqannaasa nammariara randoosia Niru nammari afaiqara nukuda indufusaida amiqira nammari sakasaidaqa neemariqau. Anoona nammari mandaikinoo marunara sia neemariqau. ");
INSERT INTO bjr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Qisauku dinni taikasee dinni ani qaara marasee 7 faasaana nammari kaqi fidika arinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yaaweefa kafaa Mooseesa Aaroonasa qimanniminoo qinau. Inneeqara Faraoo finnai oonuree maaqi qimasee qimamiaqa. Yaaweefa aniara maaqi qidanoo. Anee qini qiku qisauku idukusainaqa misa qiniara innaaru qidaqa qimooqiaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Anee qaoo qinaqa qinee eeqamoosa moomoora qianaqa anireeqa ani maqa maaqa qumbiqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Niru nammariki faqa eeqamoosa kai qumbiaqa marifaranoo miqooqari anee kooti marianna firaa maaqanaki faqa keeqeefaranoo. Anee faiqee mariannanaki faqa keeqeefara. Ani qaari qamunnasaa faqa qumbiqeefaranoo. Ani faiqí firaasa faqa ani maqannaasa faqa misa oonidaki faqa afeeki faqa qumbiqeefara. ");
INSERT INTO bjr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Eeqamoosa fannoo urureenoo ani faqa ani ainainirausasaa rakisi mariasa faqa ani maqannaasa faqa nifaaqai akareefaranoo. Miqi qufanoo Faraoofa sia mi ufana irinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yaaweefa kafaa Mooseena qimaminau. Anee Aaroona maaqi qimasee qimamia. Doo aneenna saunu uqeeraseenana aiqama nammari faqa oorakinaa nammari faqa aka mandira nammariuqa faqa uqeera uqafiqasainanoo eeqamoosa fannoo moomoo urureenoo Isipa maqa maaqa rafaaqa fuani. ");
INSERT INTO bjr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaroonafa Mooseena ufa iriseenoo saunu uqeeraseenoo aiqama nammariuqa nimummaqa uqeeranau. Uqeerasoofanoo eeqamoosauqa moomoo nammarikiqari urureeqa maqa maaqa rafaaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Isipa maqannaa afunee fasiqauqa misa faqa nári afunee auqusoofanoo eeqamoosa moomoo nammarikiqari Isipa maqa maaqaki qumbiqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Faraoofa eeqamoosara akooqoofanoo Mooseena faqa Aaroona faqa naaramasee qimanniminau. Inneeqara oonu Yaaweenara innaaru qimasaifanoo kafaa eeqamoosa niiqaani. Eeqamoosa aiqama niiqamasainaqa qinee Isaraee maqannaa karabusakinaana idukusaanaqa oonureeqa Yaaweena aandau tatufirana suqa amiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mooseefa Faraoona ufa iriseenoo qimaminau. Qinee inniara innaaru qirara asasammidaqa. Aneenna kai yairee fee innaaru qiannee qinaqa qinee aniara faqa ani ainainirausasaa rakisirausara faqa ani maqannaara faqa innaaru qianaura. Mi faasaanna kai inni maaqakiaqa qari eeqamoosauqa quqasee Niru nammariki kai ooqu marifarannoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faraoofa iriseenoo duna kai innaaru qiannee qufanoo Mooseefa iriseenoo qimaminau. Anee qianandee ianaura. Miqianana anee mina qafamaseenana sia moo maqasaa anutufa Yaaweena maasa Anutuna fooqaafa maridanoo fee qimasee irinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Aniki faqa ani ainainiranasaa rakisirausaki faqa ani maqannaasaki faqa maria eeqamoosausa taika fuannoo. Sia uqanna moodaa faqa kaqi mariannoo. Niru nammariki kai marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mooseefa faqa Aaroonafa faqa Faraoona maaqakiqari raudeeqa oonuroofanoo Mooseefa Yaawee funnai eeqamoosa Faraoona faqa narí maqannaasaki faqa quqaqoona taika nisaanifeera innaaru qinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yaaweefa Mooseefa iroondee inau. Aiqama maaqakinaa eeqamoosauqa faqa maaqa naambeeqa qara maru eeqamoosausa faqa maaqa saqama atiqara marusa faqa aiqama qufaqa kuqu taikaqau. ");
INSERT INTO bjr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Isipa maqannaasa mi eeqamoosausa kuqiranauqa mareeqaida moodaanaki quqeesoofaqa putaa iqa aiqama maqa maaqaki putaa undi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Eeqamoosa kuqu taikafufanoo Faraoofa qafamaseenoo Yaaweefa qundee inoo kaukaata qimaseenoo sia Mooseena faqa Aaroona faqa ufa irinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yaaweefa Mooseena qimaminoo qinau. Aaroona maaqi qimasee qimamia. Aaroona anee aneenna saunu qumaree maqa rupeemma aminanoo kookooma fannoo quandaki aakukaikamafi Isipa maqa maaqaki umbiqaani. ");
INSERT INTO bjr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aaroonafa narí saunu samu kookooma rupeema amufanoo aiqama Isipa maqa maaqakinaa kookoomma fannoo aakukaikinau. Mifa faiqí anaasee faqa aandauqa faqa nifaaqasasa qumbiaqa marida ukaqa nimi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Isipa maqannaa afunee fasiqauqa Aaroona oosana qafamaseeqa misa faqa nári afuneennai aakuka amanammasee qafaanee qimasee amanufanoo sia ufaqa minnisaqau. Minnisoofaqa aakukauqa aiqama atinai amanaikiqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Afunee fasiqauqa Faraoona qimamiqa qiqau. Anutufa maa ainaina auqaidanoo. Faraoofa misa ufa iriseenoo Anutufa qundee inoo kaukaata qimasee Mooseesa Aaroonasa ufa sia irinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yaaweefa Mooseena kafaa qimaminoo qinau. Duna kananaana uqanna Faraoofa nammari auqarara ooqu fuannoo. Anee kananaana findifinana ooqureenana paqurimasee maaqi qimasee qini ufa qimamia. Faraoo Yaaweefa aniara maa ufana qinoo. Anee qini qiku qisauku idukusainaqa qini qimoo qiaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Qinee ani aaqu qimama qaidaqa anee sia idukinaqa qinee ani faqa ani ainainiranasaa rakisirausa faqa ani maqannaasa faqa faufaarinnoo aupurarana nimianaura. Isipa maqannaasa maaqauqaki faufaari kai qumbiqaannoo. Aiqama misa maqa maaqa faqa rafaaqa fuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Miqi mafinaqa qinee Kooseena maqa maaqaki qini faiqí anaasee mariasasaa ititasaana sia faufaari iannoo. Qinee miqianana anee qini Yaaweesara mi maqa maaqanaki maridanoo fee qinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Qinee ani faiqí anaasee faqa qeeqa faiqí anaasee faqa rainaanaura. Mi rainarafa naaquqara ainaina duna kambiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kananaana Yaaweefa qufaqa faufaari moomoo uqanna nukudara foora anireeqa Faraoona ufa irira maaqaki faqa mina ainainiranasaa rakisi marusa maaqakiaqa faqa aiqama Isipa maqa maaqaki faufaari fannoo mandaika uqanna masanau. ");
INSERT INTO bjr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Miqimmasoofanoo Faraoofa Mooseesa Aaroonasa naaramaseenoo qimanniminau. Innee maaqoo Isipa maqa maaqaki moo atinai inneeqa Anutuna tatufirana suqasee innaaru qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mooseefa narí qimaminoo qinau. Maasa sia amana miqianaura. Isipa maqannaasa Yaaweena maasa Anutuna tatufirana suqa amiranara nikooqaandoora. Maasa maa aandausannoo tatufirana suqarafa Isipa maqannaasa nikooqarana nimianaqa maasa qiqafamaseeqa oonisamu maasa kuqa darifoora. ");
INSERT INTO bjr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Maasa qaaramoo faasaana aadana maqa maaqaki oonuree aandau tatufirana Yaaweena maasa Anutuna narí qimannimundee kai iqa suqa amianaura. ");
INSERT INTO bjr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faraoofa iriseenoo qinau. Doo amana innee aadana maqa maaqai oonu maridaqa aandau tatufirana suqasee Yaaweena inneeqa Anutuna amiaqa. Sia nianai fuaqa, adeedi maridaqa innaaru qidaqa qiniara faqa innaaru qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mooseefa Faraoona ufa iriseenoo qimaminau. Ani maaqakiqari raudeeqa qumureeqa innaaru qianaura. Duna kananaana faufaari taikaannoo. Ani maaqaki faqa ani ainainiranasaa rakisirausa maaqaki faqa ani maqannaasa maaqaki faqa duna kananaana taikaannoo. Faraoo sia kaifaa unna qimaseenana qaoo qia. Isaraee maqannaasa Yaaweena tatufirana suqamiranara sia kafaa qaoo qia. ");
INSERT INTO bjr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Miqi qimaseenoo Mooseefa Faraoona maaqaki aiseenoo raudamafinoo Yaaweenara innaaru qinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Yaaweefa Mooseena irara ufa iriseenoo faufaari Faraoona maaqakinaana faqa mina ainainiranasaa rakisi marusa maaqakinaana faqa mina maqannaasa maaqakinaana faqa aiqama taikannisanau. Sia moodaa faufaari kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Miqi marufanoo Faraoofa kafaa kaukaata qimaseenoo sia Isaraee maqannaasa idukusoofaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Anutufa kaifaa Mooseena qimaminau. Anee Faraoo finnai oonureenana maaqi qimaseenana qimamia. Oo Faraoo, Yaaweefa Heeburu maqannaa Anutufa aniara maaqi qidanoo. Anee qini qiku qisauku idukusainaqa qiniara innaaru qimaseeqa qimooqiaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Anee kaifaa qaoo qimasee Isaraee maqannaasa sia idukinaqa, qinee manda auriranara qiananoo ani aandau qoosauqa faqa doonkiuqa faqa kameerauqa faqa burimakauqa faqa sipsipauqa faqa mimmiuqa faqa mi aurirana nimianauranoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Qinee aandau rainaanauranoo Isipa maqannaa aadau aurirana nimianauranoo. Isaraee maqannaasaindi sia aurirana nimianaqa sia misaindi kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Qinee Yaaweesa duna faasaana miqianauranoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Iaqoo kananaana Yaaweefa narí qundee inau. Isipa maqannaasa aandau aiqama kuqu taikaqau. Isaraee maqanaasa aandau sia moo kuqinau. Kaqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraoofa minara iriseenoo narí maqannaasa niqiqoofaqa oonu qafamasee aniree Faraoona qimamiqau. Isaraee maqannaasa aandau sia uqanna moodaafa kuqinoo. Miqi qufanoo Faraoofa kaukaata qimasee sia Isaraee maqannaasa idukusoofaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yaaweefa kafaa Mooseena faqa Aaroona faqa qimanniminoo qinau. Moosee anee danda qoodaa asaukunnoo afaqamaree Faraoona oorinni oonuree innaarunai aqua. ");
INSERT INTO bjr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Miqimmasainanoo mi dandafa kookoomara foora aiqama Isipa maqa maaqakinai aqufinoo aandauqa faqa faiqí anaasee faqa nibeema naruani. Naru finoo radiqinoo namuana firaafa kambiqaani. ");
INSERT INTO bjr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mooseefa faqa Aaroonafa faqa Yaaweena ufa iriseeqa danda afaqamaree Faraoo funnai fiqau. Faraoona oorinni oonu kikiqa mafufaqa Mooseefa mi dandana innaarunai aqinau. Aqusoofanoo maqasaa aqufinoo mi dandafa aandauqa faqa faiqí anaasee faqa abeema niminau. Nimisoofanoo mifa radiqinoo namuana firaafa nárí marinau. ");
INSERT INTO bjr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Isipa maqannaa afunee fasiqauqa sia amana Mooseena afusaa anirana amanaikiqau. Misa faqa aiqama Isipa maqannaa undee kai inoo abeema nárí marunara sia Mooseefa maruqoo aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Miqufanoo Yaaweefa qufanoo Faraoofa kaukaata qimasee Yaaweefa qundee inoo sia Mooseesa Aaroonasa ufa irinau. ");
INSERT INTO bjr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yaaweefa mina qafamaseenoo kafaa Mooseena qimaminoo qinau. Inneeqara duna kananaana findifiqa oonureeqa Faraoona maaqi qimasee qimamiaqa. Heeburu maqannaa maasa Anutufa Yaaweefa aniara maaqi qidanoo. Anee qini faiqí anaasee idukusainaqa misa qini qimooqiaqee qidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Anee sia miqinaqa mikari qinee sia ani ainainiranasaa rakisirausa faqa ani maqannaasa faqa kai naruanauranoo, ani faqa aupurarana amianauranoo. Miqianana anee irinnaranoo, sia moo fannoo qini daanna rarafa aiqama maqa maaqaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Qinee ani faqa ani maqannaasa faqa manda auriranannai amana naru taikaunaiqini. ");
INSERT INTO bjr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Qinee inni qeeqa afeeka uqannifiqarara inni minni nisaunaqa kaqi marianara qini afeeka duqu aiqama maqa maaqaki daraaniannoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Faraoo, anee kaqi kai ramoo ramaa idana sia qini faiqí anaasee idukusaanaqa fidammia. ");
INSERT INTO bjr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Duna suani afu maa maqee marina amanasaa ururainaqa qinee qiananoo aaku firaafa pupu samu namufaqa aqufuannoo. Miqira pupu samu Isipa maqannaasa ooqai faqa maqee mariaqooqari faqa sia qafoo ainainafa maqee kai kambiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Doo aneenna maqannaasa qimanniminaqa nariqa aandauqa faqa aiqama ainaina madaanai mari ainainausa faqa mareeqee maaqaki quqaaqa. Madaanai marinna aandausasaa faqa faiqí aanaaseesaa faqa firaa pupusamu aqufinoo kuqa naruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kinna Faraoona ainainasaa rakisi marusa uriqararausa akaqausa Karaambaiqa mi ufanara rufiasee nariqa ainainira faiqiuqa faqa aandauqa faqa mareeqee maaqaki uqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Akaqausa Yaaweena ufa irisee nikooqoosa misa nariqa ainainira fasiqauqa faqa nariqa aandauqa faqa kaqi madaanai quqaqoofaqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Iaqoofanoo Yaaweefa Mooseena qimaminoo qinau. Aneenna asauku innaarunai uqeeraa. Uqeerasainanoo pupu samu aiqama Isipa maqa maaqakinaa fasiqa aanaaseesaa faqa aandauqasaa faqa aiqama afuqakinaa naranauqasaa faqa aqufuani. ");
INSERT INTO bjr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Miqi qufanoo Mooseefa narí saunu innaarunai uqeerasoofanoo Yaaweefa innaarunai qirana faqa aakuasaa faqa pupusamu faqa quqasoofanoo maqasaa quminau. ");
INSERT INTO bjr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Yaaweefa aaku faqa pupu samu faqa quqaseenoo aakuasaara qufanoo aiqama atinai uqi marinau. Ooqai Isipa maqannaasa miqirana sia qafaqau. Mikari kai firaafa uqanna kambiqoofaqa qafaqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Pupu samu fannoo aiqama Isipa maqannaa maqusai quqaqoo ainainausa faqa aiqama faiqí anaasee faqa aandauqa faqa narinau. Mifa aiqama afuqakinaa narana faqa saqari qaqama nee marunauqa faqa itairi aqinau. ");
INSERT INTO bjr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kooseena maqa maaqaki Isaraee maqanaasa maruqoo kai pupu samu sia aqufinoo narinau. ");
INSERT INTO bjr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraoofa mina qafamaseenoo Mooseena faqa Aaroona faqa naaramaseenoo qimanniminau. Maqee qinee aaqamamma seeqa. Yaaweefa andeeqarafa maridanoo. Qinee faqa qeeqa maqannaasa faqa aaqee marunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Inneeqara oonuree Yaaweenara innaaru qiaqa. Maasa innaarunai qiranara faqa pupu samuara faqa qikoo uqanna qeenoo. Qinee inni idukusaanaqa fifaranoo fee qimasee qima afeekaikidaqa. Innee sia maaqoo kisaaqasaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Miqi qufanoo Mooseefa qimaminau. Qinee ani maqusa naambeeqai oonureeqa qisauku Yaawee finnai uqeerasee innaaru qiananoo innaarunai qirafa faqa pupu samu faqa taikaannoo. Miqimmasaanana anee maa maqa maaqanara Yaaweenaindi fee qimasee irinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Qinee iridaqa anee faqa ani ainainiranasaa rakisirausa faqa sia Yaaweena maasa Anutunara rufiee mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Mikari Isipa maqannaasa reepaa faqa raisa fooqaa ira ainaina baari faqa mandaikinau. Baari fannoo akuqamafufanoo reepaa qaqama irarara deedaqa mafufanoo pupu samu fannoo aqufinoo mandaika masanau. ");
INSERT INTO bjr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Sia moodaa uita fannoo mandaikinau. Mifa inaaqianna ummaqirafa maridanoo maqee uri marunara sia mifa mandaikinau. ");
INSERT INTO bjr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mooseefa Faraoona maaqakiqari raudeenoo naambeeqai qumureennoo asauku innaarunai uqeerasee Yaaweenara innaaru qinau. Innaaru qufanoo innaarunai qirafa faqa pupu samu faqa aaku faqa aiqama taikanau. ");
INSERT INTO bjr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Taikafufanoo Faraoofa qafamaseenoo kafaa aaqanau. Mifa faqa narí ainainiranasaa rakisi marusa faqa kaqi kai kaukaataqiqa ani mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ooqai Yaaweefa Mooseena qimamundee kai inoo Faraoofa kaukaata qimaseenoo sia Isaraee maqannaasa idukusoofaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Yaaweefa kafaa Mooseena qimaminoo qinau. Anee kafaa Faraoo finnai fua. Qinee Faraoona faqa mina ainainiranasaa rakisirausa faqa kaukaataqira irirana nimiseeqa qeeqa faiqí sia auqaaqaa ira ainaina misa qambaana auqarara miqianaura. ");
INSERT INTO bjr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Innee inneeqa faiqi namu faqa ninaiqimara faqa, qinee Isipa maqannaasa faiqí sia auqaaqaa ira ainainannai misa mara furufarirausaika mannimaqaafannanara qimannimia. Innee aiqamausa qini Yaaweesara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mooseefa faqa Aaroonafa faqa Faraoo funnai oonuree maaqi qimasee qimamiqa qiqau. Yaaweefa Qeeburu maqannaasa Anutufa aniara maaqi qidanoo. Kisaaqasaa fee anee qaoo qidanee sia fee aneenna auqu mara maree muqufisee qini qimeemaanai marinnaree. Anee qini faiqí anaasee idukusainaqa oonureeqa qiniara innaaru qiaqee qidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Anee kaqi kai qaoo qimarinaqa qinee duna pandaaqa moomoo mara quqasaanaqa ani maqa maaqaki qumbiqaannoo fee qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Pandaaqa moomoo uqanna kambiqafi maqa ititafinaqa sia maqa qafeefaranoo. Pupusamu fannoo naridanoo mafisai andandausa aiqama nama taikeefaranoo. Saqari mafisainauqa faqa neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mi pandaaqausa ani ufa irira maaqaki faqa ani ainainiranasaa rakisi mariasa maaqakiaqa faqa ani maqannaasa maaqakiaqa faqa qumbiqeefaranoo. Ani akeeku akaaku maruqooqari faqa maqee anee mariannaqooqari faqa sia qafaa ainainafa mandainaina uqanna mariannoo. Miqi qimaseenoo Mooseefa raudamaki finau. ");
INSERT INTO bjr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Faraoona ainainirana saa rakisi marusa Faraoona qimamiqa qiqau. Maa fasiqafa Mooseefa kisaaqasaa maasa ummaara qimidanoo. Isaraee maqannaa idukusainaqa oonuree nári Anutuna Yaaweenara innaaru qiaqa. Anee sia fee qafaidanee Isipa maqa maaqa doo mandaikidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Miqi qufaqa Mooseesa Aaroonasa nifiqee Faraoofa maruqoo minisoofanoo Faraoofa qimanniminoo qinau. Innee oonureeqa inni Anutuna Yaaweenara innaaru qiaqa. Inneeqa firanara faqa amiqi masee qimaqimifaqa iria. Yauyausee fifaranoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Miqi qufanoo Mooseefa narí qimaminoo qinau. Maasa aiqamausa fuanauranoo. Maasa qeeqa faiqi asooqa faqa fuanauranoo. Maasa qeeqa sipsipauqa faqa mimmiuqa faqa burimakauqa faqa aiqama oonuree Yaaweeena oomaqa suqamianauranoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Miqi qufanoo Faraoofa qinau. Qinee Yaaweena auqu ramasee qeeqa qimana aiqamasee maaqi qidaqa. Qinee sia eedoo qianaqa innee inneeqa faiqi anaasee nifiqee fifaranoo. Innee akooqoo maasa mandaikamma qimaqarara tipundaara maqaqee miqi mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Minara qinee inniara faiqí kai oonureeqa innee iri mariandee Yaaweenara innaaru qimaseeqa amooqiaqa. Miqi qimasee narí sundiauqara qufaqa Mooseesa Aaroonasa niiqoofaqa raudee fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yaaweefa mina qafamaseenoo Mooseena qimaminoo qinau. Aneenna asauku Isipa maqa maaqa amummaqa uqeerasainaqa pandaaqauqa aniaqa. Anireeqa misa Isipa maqannaasa narana amanee aiqama naaqa. Pupu samu aridanoo mafisoona namataikaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mooseefa iriseenoo narí saunu uqeerasoofanoo Yaaweefa ufaira qufanoo suani oosanaindari mi faasaanna faqa mi eendanaki faqa uqinau. Kananaana ufai fannoo pandaaqauqa moomoo maree urinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Pandaaqa moomoo nukudara foora urureeqa aiqama Isipa maqa maaqaki amanaikiqa mariqau. Moomoo indaaru ooqbiqasee urufaqa kafaa inaaqiana akaqausa ooqbiqasee urufaqa, miqi kai masaida moomoosa uru maqa maaqa qumbiaqau. Ooqai sia miqirana qafaqau, naaru faqa sia qafeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Mi pandaaqausa aiqama maqa rafaaqafusoofanoo sia maqa ati faqa kooroo inau. Maqa faqa kai kudima arinoo marinau. Pupu samu fannoo aridanoo mafisoo andandausa faqa aiqama saqari qaqama faqa namasaqau. Sia saqari amanee arira ainaina, saqarisaa faqa ummaqira ainainasaa faqa Isipa maqa maaqaki marinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraoofa Mooseesa Aaroonasara aniaqee qufaqa aniroofanoo qimanniminau. Qinee Yaaweena inni Anutuna faqa inni faqa mandaikamma nimaqeeqa. ");
INSERT INTO bjr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Inneeqara qini aaqarana akiiqara kafaa maqee kai minni qisaaqa. Minni qiseeqa Yaaweena inneeqa Anutufinnai innaaru qifanoo maa kuquaqaa ira aupurarana mara aqu qisaani. ");
INSERT INTO bjr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mooseefa iriseenoo raudamaku fanoo oonureenoo Yaawee funnai innaaru qinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yaaweefa qufanoo ufai fannoo suani afu oosana qaannaindari uriufa mara quandasee suani afu keeqee marunnaindari afeeka ufai uqanna uqinoo aiqama pandaaqauqa fuaqa Taatuqee ooruku nammarinni aqinau. Sia uqanna moodaa pandaaqa Isipa maqa maaqaki kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Yaaweefa qufanoo Faraoofa kaukaata qimasee sia Isaraee maqannaasa idukusoofaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yaaweefa kafaa Mooseena qimaminoo qinau. Anee aneenna asauku innaarunai uqeerasainanoo asukuna fannoo aiqama Isipa maqa maaqa rafaaqafuani. Asukuna firaafa misa nifaaqai atooqanoo maridanoora foora inoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mooseefa narí asauku innaarunai uqeerasoofanoo Isipa maqa maaqa asukuna firaafa qaaramoo faasaana ititannimaqanau. ");
INSERT INTO bjr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Isipa maqannaasa mikari sia narí qafee narí qafee imariqau. Sia aana nimariqau, maaqaki kai mariqau. Isaraee maqannaasa maruqoo kai kaaqa qee marufaqa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Faraoofa Mooseena aaramaseenoo qimaminau. Aneenna maqannaasa faqa doo oonureeqa Yaaweenara innaaru qimaseeqa amooqiaqa. Innee inneeqa faiqi anaasee faqa aiqama nifiqee fuaqa. Inneeqa aandauqa maaqoo quqasee inneeqa kai fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Miqi qimasoofanoo Mooseefa qinau. Maasa nariqa aandauqa faqa maree oonureeqa Yaaweena maasa Anutuna tatufirana suqa amianaura. ");
INSERT INTO bjr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Maasa qeeqa aandauqa maree fuanaura. Sia moodaa maaqoo kaqi mafi quqaanaura. Maasa qeeqa kai nana aandau fee aruseeqa Yaaweena maasa Anutuna tatufirana suqa amianauree. Maasa maqee sia iridaqa. Miqoo oonuree irianaura. Nana aandaunnoo fee tatufirana suqaanauree. ");
INSERT INTO bjr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yaaweefa qufanoo Faraoofa kaukaata qira irirana maraseenoo ititammaseenoo Isaraee maqannaa sia idukinau. ");
INSERT INTO bjr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Miqi qimaseenoo Faraoofa Mooseena qimaminau. Doo qinee qafee mariana qini qifusaaqari fifua. Qinee sia kaifaa ani qafaanaura. Ani qafaanana kuqinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mooseefa mina ufa iriseenoo Faraoona qimaminau. Anee kuqaa qiananoo. Anee sia kafaa qini qiqafeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Miqi qimasoofanoo Yaaweefa Mooseena qimaminoo qinau. Qinee moodaa ummaara kai Isipa maqannaasa karaambaiqa faqa mina maqannaasa faqa nimianaura. Miqimmasaananoo mifa inni idukusainaqa fifaranoo. Kuqaa uqanna mifa sia reendeenasaa inni niiqaannoo. Kaukaata qidanoo niiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Moosee anee aneenna maqannaasa maaqi qimasee qimannimia. Misa aiqama Isipa maqannaasa nári naaqa mariasa iramirifaqa nifaaqa auqi maria ainainna siruaannoo faqa koorannoo faqa auqirana nimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Yaaweefa qufaqa Isipa maqannaasa Isaraee maqannaasara uriqararausee qiqau. Isipa maqannaa Faraoona ainainiranasaa rakisi marusa faqa aiqama faiqí anaasee faqa Mooseenara kaaqa uriqarara fee qimasee ainaina nimiraree qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mooseefa Yaaweena mi ufana iriseenoo oonu Faraoona qimaminoo qinau. Yaaweefa aniara maaqi qinoo. Eendamuqusai uqanna qinee Isipa maqa maaqaki nuanaura. ");
INSERT INTO bjr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Isipa maqannaa akoonaiqi ooqa faiqiuqa aiqama kuqifaranoo. Ani Faraoona faiqi ani amaaqa maqaaninnana saaqari oosana arasee miqooqaraasa ooqa faiqiuqa faqa kaaqa ureeqarausa ooqa faiqiuqa faqa aiqama naru taikaannoo. Aiqama burimmakauqa ooqa aanaaqiuqa faqa kuqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Aiqama Isipa maqa maaqaki ikifaafau qirafa firaafa mariannoo. Ooqai sia miqira iki raqarafa marinau. Kasooqaqee faqa sia miqira qikiraqarafa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Miqi marifanoo sia uqanna faini fannoo Isaraee maqannaasa faqa misa aandauqa faqa nindafeenoo kau kau qiannoo. Miqinana anee qinee Yaaweesa Isaraee maqannaasa faqa Isipa maqannaasa faqa rainee marunnanara irinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mooseefa kafaa Faraoona qimamidanoo qinau. Ani ainainiranasaa rakisi mariasa aiqamausa qinee iannannai anireeqa qini doorinni niqoori saunu arafiqa qiniara doo aneenna maqannaasa nifiqee fuannee qifaranoo. Miqi qifaqa qinee doo fuanauranoo. Mooseefa miqi qimasee aranaqoofanoo aanoomaseenoo raudanau. ");
INSERT INTO bjr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Raudamafufanoo Yaaweefa Mooseena qimaminoo qinau. Faraoofa ani ufa sia uqanna iriannoo. Miqi marinaqa qinee faiqí sia auqaaqaa ira ainaina moo faqa moo faqa auqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mooseefa faqa Aaroonafa faqa Faraoona oorisaa mi oosana oosanna ainainna auqoofanoo mifa sia irinau. Yaaweefa qufanoo kaukaata qira irirana maraseenoo sia niqiqoofaqa mina maqa maaqakiqari fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mooseena faqa Aaroona faqa Isipa maqa maaqaki Yaaweefa kafaa qimanniminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Innee aiqama aukuanaki maa quqoonnara maasa indaaruqaa quqoona fee qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Anutufa Mooseena qimaminoo qinau. Aiqama Isaraee maqannaa maa ufana qimannimia. Maa quqoonnasaa qisaukuqara taikasee faasaanasaa moodaa moodaa fasiqa oonu sipsipa aanaaqi fee mimmi aanaaqi fee nári maaqaki mariasa naaqeera maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Mi maqanakinaasa oodaa maridaqa sia mi aandauna nama taikaaqaa inaqa misa naaqa marinausa naaramasee misa faqa amana rainasee naaqa. Faiqí anaasee nimana nimana kai aukusee niminaqa naifanoo taikaani. ");
INSERT INTO bjr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Innee sipsipa aanaaqi fee mimmi aanaaqi fee akoona kai moodaa aukuana marasainnana, sia moo nammuana faqa aurirana faqa marinnana maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mi quqoonnanasaa qisaukuqara taikasee qikunni qaara faqa qaara faqa marasee 14 faasaana eenee marinaqa kai aiqama Isaraee maqannaasa mi aandausa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Sipsipa arusaifaqa mina fidika sakaseeqa maaqa kooqiuqa dinni dinni afaimau faqa mirinni auni riranasaa faqa akuaqa. Innee mi aandausa neefandinna maaqana kooqi aku amaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mi eendanaki kai mi aandauna amaqi idasaa kasooqammasee sukaqee mari adasana namufaqa naaqa. Sia innooqee mari pauraqana aqira bereeta suqasee sipsipa amaqi namufaqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Sia fuka naaqa. Nammariki faqa sia suqasee naaqa. Idaki kai akiiqa faqa aiku faqa arada faqa suqasee naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Eendaki mina aiqama taikaaqa. Mina ataraasa sia kananaana kaqi mariani, ida qarasainanoo taikaani. ");
INSERT INTO bjr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Innee maaqimmasee mi aandauna naaqa. Amunnanda maraseeqa niku aanaamu afisuseeqa, saunu nisaukuki qumareeqa doo kaqi kaqi naaqa. Namaseeqa maaqooqari innee mi narannara Yaaweefa ainnaaqaroo narana fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Mi eendanaki qinee Isipa maqa maaqa aiqamai oonuree aniree idaqa aiqama ooqa akoonaiqi faqa ooqasaa andau akoonauqa maqarana faqa kuqa naruanaura. Qinee Yaaweesa Isipa maqannaasa unna anutusa faqa aupurarana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Fidika kooqi afaisaa aku amaqarafa mifa kai innee maria maaqana koorooiannoo. Qinee Isipa maqannaa aiqama nariqa fidaqa inni maaqa kooqisaa fidika qafamasee ainaaqaraanaura sia inni naruanaura. ");
INSERT INTO bjr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Innee mi faasaanna amaana qoomaqa faasaanara foora marinaqa qinee Yaaweesa auqaafanna ainainara naaqoo auqainaqa irisee asasifaranoo. Innee aiqama kari mi faasaannara asasifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yaaweefa kaifaa maaqi qinau. Qisauku dinni taikasee dinni ani qaara marasee 7 faasaana innooqee mari pauraqana aquqaa bereeta sia naaqa. Sia pauraqa aqira bereeta kai naaqa. Oomaqa indaaruqaa faasaana inneeqa maaqakiaqa aiqama innooqee mari pauraqana mara aqusaaqa. Oomaqaki faiqí moo fannoo innooqee mari pauraqana aqira bereeta nainna fasiqanara sia Isaraee maqannaa fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Oomaqa indaaruqaa faasaana faqa qoomaqa taikara faasaanara faqa naaquqara faasaanee qimasee suqufi innaaru qiaqa. Sia moo ainainirafa mi faasaana qandasaa mariani. Narana deedaqirafa kai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Innee miqimmasee qoomaqa naida mariaqa. Mi faasaanna qinee inni faiqí oosana faiqí oosana Isipa maqa maaqaindaraana nifiqee aniqiafana. Innee aiqama kari mi faasaannasaa qoomaqa sakeera foora mi faasaannara asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Indaaruqaa quqoonasaa 14 faasaanasaa eenee marinaqa oosana arasee fifiinaqa mi quqoonnana 21 faasaanasaa innee sia innooqee mari pauraqana aqira bereeta naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Innee 7 faasaana qoomaqa nara faasaana innooqee mari pauraqafa sia inni maaqakiaqa mariani. Innikiqari faiqí moo fannoo fee moo aanaamuru ani marina fee innooqee mari pauraqana aqira bereeta nainaqa innee sia minara Isaraee maqannaa fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Innee yai yai fee maridaqa sia innooqee mari pauraqana aqira bereeta kai naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Anutufa Mooseena mi ufana qimamisoofanoo Mooseefa Isaraee maqannaasa uriqararausa qimanniminoo qinau. Innee moodaa moodaa sipsipa akoona fee mimmi akoona timmusa fee inneeqa faiqi anaasee nimana kai mara minisee aruseeqa ainnaaqaroo qoomaqana suqasee naidaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Aandau aruseeqa fidika difaaniki sakaaqa. Innee hisoopa saqari amanee raudasee minannoo fidika difaaniki raaraammasee kooqi afai dinni dinni faqa mirinni faqa akuaqa. Akuseeqa innee sia raudaaqa, maaqaki kai marifanoo iaqaani. ");
INSERT INTO bjr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Fafaa eendaki Yaaweefa Isipa maqannaasa ooqa faiqi narinoo fidanoo inni kooqi mirinni faqa dinni dinni faqa fidika qafamaseenoo narinoo nimari qangiroonara qinanoo sia mi maqanaki keeqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Innee faqa inneeqa faiqi namu faqa naaru naaru maaqi kai iqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Innee Yaaweefa qima afeekaikamasee nimiraree qimaqoo maqannaasa oonureeqa maaqimmiqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kasooaqee inni faiqi namu mi qoomaqana qafamaseeqa mina oosanara iraifaqa innee maaqi qimasee qimannimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Maa qoomaqafa Yaaweefa ainnaaqaroo qoomaqafa maridanoo fee qimasee qimannimiaqa. Ooqai mifa Isipa maqa maaqaki maasa ainnaaqareenoo Isipa maqannaasa ooqa faiqiuqa narinoo maasa sia darinau maqi qiaqa. Mooseefa miqi qimasoofaqa Isaraee maqannnaasa iriseeqa aiqama kumma ramafi Anutunara susuiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Susummaseeqa misa daraanimafiqa Yaaweefa Mooseesa Aaroonasa nimu ufa mau fiqa aiqama ainaina andeeqasee deedaqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Mi eendanaki kai eenda amuqusai Yaaweefa Isipa maqannaa ooqa akoonaiqiuqa narinau. Faraoona amaaku narí akoona ainaina maraaninnana saaqari oosana arasee rumbaranaki mariasa faiqi namu faqa aiqama narinau. Aandau aanaaqiuqa akoona ooqasaa maqaranauqa faqa Yaaweefa narinau. ");
INSERT INTO bjr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Narusoofaqa mi eendanaki Faraoofa faqa narí ainainasaa rakisi marusa faqa aiqama Isipa maqannaasa faqa aiqama tauti findifiqau. Iki faafau qirafa firaafa Isipa maqa maaqaki marinau. Sia moo maqaki kaqi mariqau, aiqama maaqaki kuqirafa marunara iki raqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mi eendanaki kai Faraoofa Mooseena faqa Aaroona faqa naaramaseenoo qimanniminau. Inneeqara faqa inneeqa maqannaasa Isaraee maqannaasa faqa qini maqa maaqakiqari quqaseeqa inneeqa qiannai oonureeqa Yaaweena amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Inneeqa sipsipauqa faqa mimmiuqa faqa burimakauqa faqa doo fuaqa nani. Oonuree qini faqa amiqi amiqimma qimaqaanifeera innaaru qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Isipa maqannaa faiqí anaasee misa faqa Isaraee maqannaasa niqiqeeqa qiqau. Innee kai kaqi fuaqa. Innee kaqi marifaqa maasa aiqama kuqu taikaanoora. Innee doo fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Miqi qimasoofaqa Isaraee maqanaasa innooqee maru pauraqana sia aqira bereeta sia suqarana difaaniki qamunnasaa kukuqamma quqasee nikumaaqa akumaree fiqau ");
INSERT INTO bjr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isaraee maqannaasa Mooseefa qundee kai iqa Isipa maqannaa nifaaqa auqimaru ainainara siruaara faqa koorara faqa qamunnaara faqa iraqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yaaweefa qufaqa Isipa maqannaasa Isaraee maqannaasara uriqararausee qimasee misa iroo ainainna kaqi nimiqau. Miqunannai Isaraee maqannaasa Isipa maqannaa aiqama ainaina maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isaraee maqannaasa sandeeqa Ramaseesa maqusa quqasee Sakoota maqusai fiqau. Misa nambaqa maaqimminoo marinau, 600,000 faiqí kai mariqau, sia faiqi anaasee nisaana riqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Moomoo maqusanaasa Isipa maqa maqaki ani marusa misa faqa nári burimakauqa faqa sipsipauqa faqa mimmiuqa faqa maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Misa aanai fidaqa fuka bereeta innooqee mari pauraqana sia aqirana maree funa suqa naqau. Isipa maqannaasa Isaraee maqannaasa nifaqasoonara aaqmuriqa bereeta innooqee maru pauraqana sia aqirana maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isaraee maqannaasa 430 aukuana Isipa maqa maaqaki mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","430 aukuana taikarana namu faqa faiqí aiqama oosana Yaaweena aiku asauku Isaraee maqannaasa Isipa maqa maaqa quqasee fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Eendaki Yaaweefa Isaraee maqannaasa qumee rakisidanoo nifiqee finau. Aiqama aukuanaki mi eendiranara kai Yaaweenaindi fee qimasee innaaru qidaqa rakisi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yaaweefa Mooseena faqa Aaroona faqa qima niminau. Ainnaaqaraafanna oomaqana suqara naakapara ufa maaqimminoo mariannoo. Moo maqanaindari ani marinafa sia amana mi oomaqana naannoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Inneeqa munnimmannai feefaurummaqoo ainainira fasiqausa fainanduqu saifaqa misa amana neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ufaasu ani mariasa faqa feefauruara ainaini mariasa faqa sia neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Aiqama mi aandau naranna deedaqia maqanaki kai nama taikaaqa. Sia uqanna madaanai maree fuaqa. Sia aandau amudaani itairiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Aiqama Isaraee maqaannaasa mi oomaqanara asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Sia fainanduqira fasiqa fannoo sia amana naannoo. Anaamuru fasiqa inni qambaana marinafa ainnaaqaroo oomaqanara asasidanoo Yaaweena auqu uqeerararee qinaqa innee mina maaqaki mariasa akoonaiqiuqa fainanduqu saifaqa misa faqa mi oomaqanara asasiaqa. Miqi masaifanoo mifa Isaraee maqannaasaki kambiqara fara foora maridanoo mifa faqa oomaqa naranaki mariani. ");
INSERT INTO bjr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Innee faqa moo maqannaa inniki ani marinafa faqa moodaa sanda mau kai fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yaaweefa Mooseesa Aaroonasa qima nimundee Isaraee maqannaasa iqau. ");
INSERT INTO bjr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mi faasaanna Yaaweefa Isaraeerana aiku asauku Isipa maqasaa qaraana nifiqee finau. ");
INSERT INTO bjr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yaaweefa Mooseena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Innee aiqama akoonaiqi ooqa faiqiuqa qini kai qimia. Aiqama Isaraee maqannaa ooqa faiqiuqa faqa aiqama aandau ooqasaa maqarana akoonauqa faqa qinindi marinara qini qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mooseefa Isaraee maqannaasa qima niminoo qinau. Innee maa faasaannara iriaqa. Innee karabusakiqari maa faasaanna Yaaweefa narí afeekannoo nifiqee anunara innooqee mari pauraqana aqira bereeta sia naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Innee maqee Abiba quqoona indaaruqaa faasaana marifaqa Isipa maqa maaqa quqasee ani mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yaaweefa inni nikeeku nikaaku faqa oori kandamasee qima afeekaika masee Kannaana maqa maaqa faqa Heeta maqa maaqa faqa Amoora maqa maaqa faqa Hifita maqa maaqa faqa Yeebusa maqa maaqa faqa misa maqa maaqa inni nimiraree qinau. Mifa inni nifiqeenoo ainoo faqaa maqa ainaina rairaa imariqoo munu sainaqa innee aiqama aukuana indaaruqaa quqoonasaa maa oomaqana sakasee naidaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Dinni taikasee dinni ani qaara qanda marasee 7 faasaana innooqee mari pauraqana sia aqira bereeta naaqa. Innee miqimmaseeqa naidaqa mi 7 faasaanafa taikainaqa miqoo innee Yaaweenara uriqarara fee qimasee firaa oomaqa sakasee naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Dinni qisauku taikasee dinni ani qaara qanda marasee 7 faasaana innooqee mari pauraqana sia aqira bereeta kai naaqa. Mi kamuqoo inni maaqaki faqa inni maqa maaqaki faqa innooqee mari pauraqafa faqa innooqee mari pauraqana aqira bereeta faqa sia uqanna mariani. ");
INSERT INTO bjr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mi oomaqana nainna kari inneeqa faiqi namu maaqi qimasee qimannimiaqa. Maasa Isipa maqa maaqakinaana Yaaweefa nifiqee anunara maa oomaqana sakasee naidaqee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mooseefa kafaa Isaraee maqannaa qimannimidanoo qinau. Maa oomaqana narafa inni naaqoo auqaannoo. Nisaukuki sanda rumbeera foora faqa niqinaaqa rumbeera foora inoo maridanoo, mifa inni naaqoo auqainaqa innee Yaaweena sandufa qirana faqa mina ufa asaana rumasee irirana faqa naaqoo auqaannoo. Yaaweefa narí afeekannoo inni Isipa maqa maaqaindaraana nifiqee anunara miqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Aiqama aukuanaki maa faasaanna maa oomaqana sakasee naidaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Yaaweefa ooqai inni faqa inni nikeeku nikaaku faqa nimirara qima afeekaikammasee Kannaana maqa maaqa nimianauree qimaqoonnai nifiqee fuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Mifa inni mi maqana niminaqa innee ooqa faiqi akoonaiqiuqa Yaaweena amiaqa. Aiqama aandau ooqasaa maqarana akoonauqa Yaaweenaindi mariani. ");
INSERT INTO bjr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Doonki ooqasaa maqarana aanaaqi minisee sipsipa aanaaqi moodaa maraseeqa doonki aanaaqi amaaqa maqasaifanoo doonki aanaaqi kaqi mariannoo. Innee sia moo aandaunnai doonki aanaaqi amaaqa maqaani qimasee doonki aanaaqiuqa ninuka qumaree kuridiaqa. Innee inneeqa ooqa faiqiuqa faqa Yaaweenaindikinoo marina kafaa inneeqa feefauriaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kasooqaqee inni faiqi namu mi suqanara oosannara inni iraifaqa innee maaqi qimasee qimannimiaqa. Yaaweefa narí firaa afeekannoo maasa Isipa maqa maaqai rumbaranakinaana qifiqee aninau maqi qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faraoofa kaukaata qimasee sia maasa idukiraree qufanoo Yaaweefa ooqa faiqiuqa akoonaiqiuqa Isipa maqa maaqakinaana aiqama narinau. Aiqama aandau akoona ooqasaa maqaranauqa faqa narinau. Minara maasa aiqama ooqasaa maqara aandau Yaaweena tatufirana suqa amiseeqa nári faiqi namu kafaa maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Maa oomaqana narafa maasa daaqoo auqaannoo. Nisauku sanda rumbeera foora faqa niqinaaqa rumbeera foora inoo maridanoo, mifa maasa daaqoo auqainaqa Yaaweefa maasa Isipa maqa maaqaindaraana narí firaa afeekannoo nifiqee anunara irianaura. ");
INSERT INTO bjr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraoofa Isaraee maqannaa idukusoofaqa fimarufanoo Anutufa Firistianni qusa aatata sia nifiqee finau. Isaraee maqannaasa Firistia maqannaasa faqa rakiqa anirandee kaifaa Isipa maqa maaqai fifoo qimaseenoo nifiqee moo aatata finau. ");
INSERT INTO bjr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Minara iriseenoo Anutufa misa nifiqeenoo aadana maqa maaqai fiquinoo taatuqee nammari fimarunnai nifiqee fiquinau. Fidaqa Isaraee maqannaasa rakira ainaina deedaqa muqirausa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ooqai Yooseefaafa kaqi maridanoo maaqi qimaseenoo Isaraee maqannaasara qufaqa noori kandamasee mina amudaani maree firara qima afeekaikiqau. Yooseefaafa maaqi qimasee qimanniminau. Kasooqaqee Anutufa inni nifiqee finaqa innee qini qimudaani faqa maa maqusanakinaana maree fuaqa. Mooseefa minara iriseenoo Yooseefaana amudaani faqa mareenoo finau. ");
INSERT INTO bjr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isaraee maqannaasa Sakoota maqusakiqari fifiufaqa aadana maqa maaqa atinni Eetama maqusai oonuree miqoo uiqaana maqauqa usakasee faiqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yaaweefa faasaana oonnamuki marufanoo oonamu fannoo nifiqee fimarinau. Eendaki mifa idauruki marufanoo idauru fannoo kaaqa qamannimaqee marufaqa eendaki faqa faasaana faqa kaqi kai fimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Aiqama faasaana oonnamu misa noorinni fimarinau. Aiqama eendaki idauru faqa miqikai imarinau. ");
INSERT INTO bjr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yaaweefa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Anee Isaraee maqannaasa qimanniminaqa misa oonurandee quandaki Piqaqiroota maqusa oorinni Mikadoora maqusa dinni taatuqee ooruku nammari dinni mina qambaana Baa Seefoona maqusa aaqa uiqaana maqauqa usakaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraoofa maaqi qimasee iriannoo, Isaraee maqannaasa aadana maqa maaqaki firanara rufiqaidaqa maqa maaqaki oonuree aniree idammiaafoo qiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Qinee Yaaweesa kaukaata qira irirana Faraoona amiananoo mifa inni ninaaqiana nifaqee fuannoo. Qinee Faraoona faqa mina rakira fasiqauqa faqa urinnaaqararanannai firaa duqu maraanaura. Miqimmasaanaqa Isipa maqannaasa qini Yaaweesara irifaranoo. Miqi qimasoofaqa Isaraee maqannaasa Yaaweena ufa mau fiqa anirandee fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Isipa maqannaa karaambaiqa Faraoofa narí ainainiranasaa rakisirausa faqa Isaraee maqannaa quqasee funara kaifaa oonu mafi irufanoo sia andeeqoofanoo qinau. Maasa nana furufaree qimarunaqee Isaraee maqannaasa idukuaki quqasee fidaqee. Maasa Isaraee maqannaasa quqasaafaqa fuafanoo yafee maasa ainainira faiqi kiannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Miqi qimasoofanoo Faraoofa narí qoosa rarisee maru rakira karana faqa narí rakira fasiqauqa faqa deedaqinau. ");
INSERT INTO bjr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Faraoofa qoosa rarisee maru rakira karausa amiqiranauqa kai sikis handareeta 600 faqa Isipa maqa maaqaki maru qoosa karausa faqa minasaa rakisi marusa faqa mara quqasoofaqa Isaraee maqannaasa nifaqee fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yaaweefa kaukaataqira irirana Faraoona Isipa maqannaa uriqararana amufanoo Isaraee maqannaasa idukuakiqa fidaqa nasuriqa fimarufanoo Faraoofa nifaqee finau. ");
INSERT INTO bjr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Isipa maqannaa sudiauqa nariqa qoosauqa faqa nári qoosa rarisee maru karausa faqa daraiwaauqa faqa Isaraee maqannaasa nifaqeeqa Taatuqee ooruku nammari aaqa Piqaqiroota maqusa dinni Baaraseefoona maqusa dinni qambaana uiqaana maqa usakasee marufaqa oonu paquriqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Oonuroofaqa Isaraee maqannaasa Faraoona faqa mina rakira fasiqauqa faqa niqafamaseeqa tautumaseeqa rufiaidaqa Yaaweefa dadaaqianifeera faaqariqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Faaqaridaqa Mooseena qimamiqa qiqau. Isipa maqasaa madika sia amanaikifanee anee maasa qifiqeenanee maa aadana maqa maaqanaki kuquaneera aninanee. Anee maasa Isipa maqa maaqakinaana qifiqee anianafa quandafina qafaa. ");
INSERT INTO bjr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ooqai maasa ani ufa qimamiqiafana maasa Isipa maqa maaqaki kaqi maridaqa maa ainainafa kambiqaannoo fee qiqiafana. Maasa ani qimamiqiafana saina maasa kaqi Isipa maqannaasa ainainira faiqi kiqa marianee qiqiafana. Miqoo maridaqa misa ainainira faiqikirafa amiqirafa mariqini anee maa aadana maqa maaqanai fifau qifiqee minisaanaqa kuquanaura. ");
INSERT INTO bjr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mooseefa misa ufa iriseenoo qimanniminoo qinau. Innee sia rufiaaqa, kaqi nimatautasee maridaqa Yaaweefa innee asumu mariaqeera itita nimaqainaqa qafeefaranoo. Maqee innee Isipa maqannaa amiqimasee nindafaaqa. Innee maaqooqari sia kafaa nindafeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yaaweefa inni rakirana nimaaqa maqa finoo misa saimbaqa rakuannoo. Miqinaqa innee sia moo ainaina auqaaqa, kaqi kai mariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Miqi qimasoofanoo Yaaweefa Mooseena qimaminau. Anee nanaree qiniara dadaaqiannee qimasee faaqaridanee. Anee Isaraee maqannaasa qimanniminaqa noori munduqaannai fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Anee aneenna saunu nammari amummaqa uqeeraa. Miqimma sainaqa nammari raina finaqa Isaraee maqannaaa amana aadana maqasaa taqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Qinee Yaaweesa Isipa maqannaasara qianaqa kaaqa firaaqoo kaukaataqira irirana marasee Isaraee maqanna ninaaqianna nifaqee fifaranoo. Qinee Faraoona faqa mina sundiauqa faqa mina qoosa rarisee mari karausa faqa daraiwaauqa faqa rakirana urinnaaqararanannai firaa duqu maraanaura. ");
INSERT INTO bjr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Qinee misa urinnaaqarama saanaqa misa qiniara Yaawee fee qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Anutuna qangiroo fannoo Isaraee maqannaasa noorinni mariufa aiqareenoo ninaaqiannai finau. Oonnamu faqa miqi kai inoo aiqaree ninaaqiannai finau. ");
INSERT INTO bjr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mi oonnamufa Isipa maqannaasa dinni Isaraee maqannaasa dinni qambaana marinau. Mi oonamufa Isipa maqannaasa asukuna nimisee Isaraee maqannaa kaaqa qamannimaqanau. Miqinoo marufaqa mi eendanaki Isipa maqannaasa faqa Isaraee maqannaasa faqa sia narí aaqa narí aaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mooseefa asauku nammari amummaqa uqeerasoofanoo Yaaweefa suani afu urimarunnaindaraa afeeka ufainnoo ooruku nammari rainanau. Mi ufaifa mi eendanaki uqidanoo mariufanoo ooruku nammari rainasoofanoo aadana maqa koorooinau. Miqimmafufanoo nammari rainanau. ");
INSERT INTO bjr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Miqimmafufaqa Isaraee maqannaasa ooruku nammari qambaana aadana maqasaa taqaqau. Dinni dinni nammari fannoo safasara foora inoo marufaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Isipa maqannaasa misa niqafamaseeqa misa ninaaqianna nifaqeeqa nammari qambaanai ooquraqau. Isipa maqannaasa nariqa qoosauqa faqa nariqa qoosa rarisee maru karausa faqa nariqa daraiwaauqa faqa Isaraee maaqanaasa nifaqee nammariki ooqu raqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Iaqarooka Yaaweefa oonnamukiqari faqa idaurukiqari faqa Isipa maqannaasa nindafamaseenoo maparaa irana niminau. ");
INSERT INTO bjr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yaaweefa qufanoo qoosa rarisee maru karausa misa niku utusamafufaqa firara firaaqoo anuqi mariqau. Miqufaqa Isipa maqannaasa qiqau. Yaaweefa Isaraee maqannaasa saaroo qinoo maasa daridanoo. Maraifaqa quqasee fua. ");
INSERT INTO bjr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Miqimasoofanoo Yaaweefa Mooseena qimaminau. Aneenna asauku nammari amummaqa uqeerasainanoo kafaa nammari fannoo quminoo Isipa maqannaa nári qoosa rarisee maru karausa faqa daraiwaauqa faqa rafaaqa fuani. ");
INSERT INTO bjr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mooseefa iriseenoo asauku nammari amummaqa uqeeranau. Miqimma soofanoo iaqarooka nammari fannoo kafaa oonurandeenoo ooqai mariundee kai mafinau. Isipa maqannaa sandeeqa fuaneera qufanoo Yaaweefa misa mareeqee nammariki aqinau. ");
INSERT INTO bjr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nammari fannoo kafaa quminoo Faraoona rakira fasiqauqa faqa qoosa kara faqa daraiwaauqa faqa aiqama Isaraee maqannaasa nifaqee nammariki ooquroosa aiqama rafaaqa finau. Sia uqanna moodaafa kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isaraee maqannaa ooruku nammari qambaana aadana maqasaa taqaqau. Nammari dinni dinni safasara foora inoo marufaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mi faasaanna Yaaweefa Isaraee maqannaasa Isipa maqannaasa nisaukukinaana maranau. Marasoofaqa Isaraee maqannaasa quandafi niqafoofaqa Isipa maqannaa nammari afaiqara kuqiqeeqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isaraee maqannaasa Yaaweena moo ainaina afeeka eeraarirana rakiranaki Isipa maqannaasa urinnaaqaroonara irufanoo naaquqoofaqa nári saqarikirana Yaaweenasaa faqa mina ainainira faiqi Mooseenasaa faqa mundiqau. ");
INSERT INTO bjr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mikari Mooseefa faqa Isaraee maqannaa faqa maaqi qimasee Yaaweena amooqira idi raqau. Qinee Yaaweenara idi raanauranoo. Mifa rakiranaki uriqarainara miqianaura. Mifa qoosauqa faqa qoosasaa marusa faqa ooruku nammariki mara aqinara idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yaaweefa qini afeeka ititarafa maridanoo. Mifa qini asumu maroofa maridanoo. Mifa qini Anutufa marifaqa qinee mina amooqianaura. Qini qikoona Anutunafa marifaqa qinee mina afeekara idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yaaweefa afeeka rakira fasiqa maridanoo. Mina auqu Yaaweefa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Mifa Isipa maqanna sundiauqa faqa misa qoosa karauqa faqa rafusu ooruku nammariki aqinoo. Mina uriqarara sundiauqa Taatuqee Ooruku Nammariki ukuqneea. ");
INSERT INTO bjr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ooruku nammari faruma fannoo misa rafaaqa fusaifaqa misa ooniara foora meemaqoo maqasaa ooqu maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oo Yaawee ani asauku uqannai asauku fannoo naaquqara afeeka maridanoo. Mi asaukufa namuqaa naruseenoo utitiqeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Aneenna firaa uriqararanannai aneenna namuqaa rafusu aquananoo. Ani aanoo qirafa ida dudaaqasaaqari qeera foora mannimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Anee ooruku nammari fuaqasaananoo nammari mandi mareenoo aaqanara foora ooru finoo. Nammari dinni dinni innooqa maree safasara foora ooru finoo. Nammari dinni dinni raina fufanoo maqa meemaqoo afeekaika minoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Namuqaauqa maaqi qiqau. Maasa misa nifaqasee qumaraanauranoo. Misa qumaraseeqa misa amiqira ainaina maasa didimarina aiqama maraanaura. Maasa qeeqa rakira paipanannai naruseeqa misa aiqama ainaina mararee qia. ");
INSERT INTO bjr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Miqi qiafana anee Yaaweefa moodaannai aidoo fuaqasaananoo Isipa maqannaasa ukuqneea. Miqimma saifaqa misa ooniara foora firaa difukunaki ooqu fia. ");
INSERT INTO bjr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yaawee, yafee unna anutusakiqari ani fooqaafa maridanoo fee. Sia moo fannoo. Yafee ani amana maridanoo kaaqa naaquqara andeeqarafa maridanoo fee. Yafee faiqí sia amana auqaaqaa ira ainaina faqa afeeka ainaina anee imarianandee masee auqaannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Aneenna asauku uqannannai uqeera saananoo maqa fannoo namuqaa nambiqeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Aneenna qima afeekaikiranasaa mapukusee maridana faiqí anaasee mandainainaki mariusa nifiqa maree fimariananoo. Aneenna afeekannoo misa indaarunni kamma nimaqa maree aneenna naaquqara andeeqara maqasaa quqanni seennaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Anaamuru minara irifanoo naaquqeenoo naindiri raannoo, Firistia maqannaasa iriafanoo maparaairafa misa qumareenoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idooma maqannaa karaambaiqauqa faqa iriafanoo naaquqeenoo. Mooapa maqannaa afeeka fasiqauqa faqa naindiri raidanoo. Kannaana maqannaasa afeeka faqa nammari kidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Maparaa irafa faqa firaa rufiarafa faqa misaki maridanoo. Misa ani Yaaweena afeeka qafamasee naaquqaifaqa kaqi muquriqa mariafaqa ani faiqí anaasee karabusakinaana iduku saanausa misa nifusaa fiqaraidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Anee misa nifiqa maree aneenna aaqanasaa munuseenana asumu ainainara foora ummaqu saananoo. Anee Yaaweefa aneennara utaaqama qaanna maqusanaki munusaananoo. Amaana maqa aneenna usakaqaanna maqusanaki munusaananoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Anee Yaaweefa naaru naaru uriqarara karaambaiqa marinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Isaraee maqannaasa ooruku nammari qambaana aadana maqasaa taqaqau. Fitaqafufaqa Isipa maqannaasa qoosa kara faqa nári qoosauqa faqa nári daraiwaauqa faqa mi ooruku nammarinaki ooqu roofanoo Yaaweefa kaifaa nammariara qufanoo quminoo misa rafaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aaroona anasaafa Miriama nammarifa Anutuna tamummaqara anaasee marufa marinau. Isipa maqannaasa nammariki kuqutaika fufanoo dukaanaa qumareenoo aridanoo idi ranau. Anaasee aiqama qafamaseeqa nári dukaanaa maree mina faqa oonuree aridaqa niqoori raqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamma nammarifa maaqi qimasee idi ranau. Yaaweenara idi raaqa. Mifa rakirana firaaqoo uraaqareenoo, mifa qoosauqa faqa qoosasaa nimariasa faqa ooruku nammariki rafusu aqinoo. ");
INSERT INTO bjr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mooseefa Isaraee maqannaa taatuqee ooruku nammarindaraana nifiqeenoo Suraa aadana maqa maaqaki quqanau. Qaaramoo faasaanasaa aadana maqa maaqaki fidaqa sia nammari paquriqau. ");
INSERT INTO bjr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Misa Maraa maqa maaqaki oonureeqa nammari moo paqurimasee noofanoo suka narufaqa sia naqau. Minara mi maqa maaqana auqu Maraa fee qiqau. Mi auquna oosana sukaqee mari fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Isaraee maqannaasa Mooseena aanoo qimamaqaidaqa qiqau. Maasa nana nammari fee naanauree. ");
INSERT INTO bjr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mooseefa iriseenoo afeekaika maseenoo Yaaweenara innaaru qinau. Innaaru qufanoo Yaaweefa Mooseena saqari moo uqafiqoofanoo Mooseefa mi saqarina nammariki aqusoofanoo nammari amiqinau. Miqoo Yaaweefa narí sanda ufa mi mau fuaqeera nimiseenoo miqoo misa nimana masee qafanau. ");
INSERT INTO bjr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yaaweefa qimanniminoo qinau. Innee qini ufa qaidusiqa qinee andeeqara ainainee qimarunnana auqeeqa kafaa qini sanda ufa mau fifaqa qinee sia manda aupurarana Isipa maqannaa nimiafannandee iqa inni nimianaura. Qinee Yaaweesa inni aurirana taikannisee marunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Miqooqari Isaraee maqannaasa fifiiufaqa Eerimma maqa maaqaki oonuraqau. Miqoo qisaukuqara taikasee qikunni ooqu qaara marasee 12 nammari maqakiqari ururee maruna faqa fasaafana fooqaa ira saqari moomoo 70 marinau. Miqoo nammari afainni misa uiqaana maqa usakasee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Isaraee maqannaasa Isipa maqa maaqaindari quqasee anuqooqari inaaqiannaa quqoona 15 faasaanasaa Sinai aaqana dinni Eerimma maqa maaqa dinni qambaana Sinnaa aadana maqa maaqaki oonuraqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Misa aiqamausa aadana maqa maaqai funara Mooseesa Aaroonasa kaukaata qimannimaqasee qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Maasa Isipa maqa maaqaki mariafannaqoo Yaaweefa daruaqaana. Miqoo maasa maridaqa aandau faqa akaqa narana maasa didi maruna maasa qimana kai neemariqiafana. Inneeqara miqooqaraana maasa qifiqeeqeeqa maa aadana maqa maaqanaki quqasaafaqa aandaroo darinaqa kuqu taikaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yaaweefa misa ufa iriseenoo Mooseena qimaminoo qinau. Qinee maqee inni aiqamausa naranara qiananoo innaarunaindari aakuara foora aqufina mara neefaranoo. Faasaambaasaana narana quqasaanaqa faiqí anaasee raudamafiqa moodaa faasaana amanakai maree marifaranoo. Qinee miqimmasee misa nimanamasee qafaanaura. Misa qini ufa irifaree sia fee irifaree. ");
INSERT INTO bjr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Moodaannai qisauku taikasee dinni ani moodaa marasee 6 faasaana qaara eenda narana amanasaa mara deedaqamma quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mooseesa Aaroonasa Isaraee maqannaa aiqama suqusee qimannimiqa qiqau. Maqee eenee marinaqa innee Yaaweenara Isipa maqa maaqaindari nifiqee anunara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Kananaana innee Yaaweefa maasaki maridanoo daroo daraa ida kaaqa qeemarina qafeefaranoo. Innee minara aanoo qimariana doo mifa irinoo. Innee sia maaqanda rau qimariafanoo fau. Maaqanda faiqí faiqi kai maridaqa mina naakapurufa mau fidaqa mina kai qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mooseefa kafaa qimanniminoo qinau. Eendinanoo Yaaweefa aandau niminaqa neefaranoo. Kananaana bereeta fooqaana inni nimana kai nimiannoo. Innee mina firaaqoo aanoo qimarianara miqiannoo. Innee maasara aanoo qimariana sia maasarau miqi mariafanoo, Yaaweenara aanoo qimariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mooseefa Aaroona qimaminoo qinau. Anee Isaraee maqannaa aiqama qima niminaqa Yaaweena oorinni ani kikiqiaqa. Mifa misa aanooqira ufa irinara miqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaroofa faiqí anaasee ufa qimannimi marufaqa quandafi aadana maqa maaqai qafoofanoo oonamuki Yaaweena daroo daraa ira kaaqa qarafa koorooinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yaaweefa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Qinee Isaraee maqannaa aanoo qira ufa doo iriqa. Maaqi qimasee qimannimia fafaa eendinoo mammandi marinaqa misa aandau nimianaura duna kananaana uqanna bereeta fooqaana nári narana nimana kai nimianaura. Nimisaanaqa innee qini Yaaweesa inneeqa Anutusara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Miqi qimasoofanoo eendi marufanoo afidauqa moomoo qaqamaraidaqa anirameeqee uiqaana maqusa amanaikiqau. Kananaana qififaramu uiqaana maqa aiqama fiqu fiqu inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Qififaramu taikafufanoo adamanna ainaina kaqikaafauqa aadana maqa mau marinau. Mi ainainafa pupusamuara foora kaqikaafauqa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isaraee maqannaasa mina qafamaseeqa mina oosanara randeeqa narí qimami narí qimamiqa qiqau. Maana nana ainaina fee maridanoo fee qiqau. Miqi qufanoo Mooseefa maaqi qimasee qimanniminau. Yaaweefa narana naaqeera nimidannoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yaaweefa maaqi qimasee qimanniminau. Innee inneeqa faiqi anaasee faqa inneeqa nimana kai maraaqa. Inneeqa maaqaki mariasa nimana nimana kai susufinna qumbiqa quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isaraee maqannaa irisee miqimmiqau. Akaqausa moomoo maroofaqa akaqausa qoodaa maraqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Aiqamausa suqusee narí amani narí amani masee qafoofanoo akaqausa moomoo suqufanoo akaqausa oodaa suqiqau. Moomoo suqusa namasoofanoo nimuaqumminau. Oodaa suqusa misa faqa namasoofanoo nimuaqu kaimminau. Aiqamausa nári nimana kai suqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mooseefa qimanniminoo qinau. Sia ataraasa duna nararee qimasee quqaaqa. Aiqama naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Miqi qufaqa akaqausa Mooseena ufa rukiasee duna kananaana nararee qimasee quqasoofanoo putaa undufanoo qimi kai qumbiqoofanoo Mooseefa aranaqoofanoo aanoomannimaqanau. ");
INSERT INTO bjr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Aiqama kananaana nári nimana kai suqusaida neemariqau. Kaqi mafisoofauqa suani urureenoo ididiufanoo nammari nammarimma taikanau. ");
INSERT INTO bjr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Dinni ani moodaa marasee 6 faasaanasaa qaara kari suqarana amana kai maraqau. Miqi masoofaqa Isaraee maqannaasa uriqararausa aniree mi ainainnara Mooseena qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mooseefa iriseenoo moo ufa maaqi qimasee qimanniminau. Duna Yaaweena naaquqara idooara faasaana mariannoo. Mi faasaanna minaindi mariannoo. Innee nana ainainee suqararee qinnana maqee suqaaqa. Kaqi marinna narana aaduma quqaqaifanoo marinaqa duna suqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Misa Mooseefa qimannimundee iqa dunaindi kaqi maaqaki quqaqau. Iqaqoofaqa qafoofanoo sia putaa inoo qimi marinau amiqinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mooseefa minara qimanniminoo qinau. Doo maqee mina naaqa. Maqee Sabata idooara faasaana Yaaweenaindi maridanoo. Minara innee fuka narana uiqaana maqusa naambeeaqara mararafa sia mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Innee qisauku dinni taikasee dinni ani moodaa marasee 6 faasaana narana suqu quqaaqa. Qisauku dinni taikasee dinni ani qaara marasee 7 faasaana idooara faasaana marinaqa sia miqoo narana mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Qisauku dinni taikasee dinni ani qaara marasee 7 faasaanasaa akaqausa narana suquanee qimasee oonu qafoofanoo sia marinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Anutufa mina qafamasee Mooseena qimaminau. Innee kisaaqasaa fee qini ufa rukiaidaqa sia qini sanda ufa afaqeefaree. ");
INSERT INTO bjr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Innee iriaqa. Qinee Yaaweesa idooara faasaana nimiqa. Miqunnanara qinee dinni taikasee dinni ani moodaa marasee 6 faasaanasaa qinee qaara faasaana narana amana kai nimianaura. Aiqamausa mi faasaanna inneeqa mariaqoo kai mariaqa, sia kasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Faiqí anaasee minara iriseeqa dinni ani qaara marasee 7 faasaanaikufaqa sia ainaini mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isaraee maqannaasa mi narannara mannaa fee qimariqau. Mifa ooroorana qaqama fooqaafa eekara arirafa marinau. Mina namasoofanoo mina adiafaa irafa ookasaasa anoonannai auqira biskitara foora imarinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mooseefa Yaaweena ufa iriseenoo maaqi qimasee qimanniminau. Yaaweefa inniara maaqi qidanoo, qinee mannaa nimmunnana akaqana afeeki mara quqaqai marinaqa inneeqa ninaiqimara nikeeku nikaaku uqannifiqaidaqa maaqi qimasee qimannimiaqa. Yaaweefa Isipa maqasaaqari maasa aadana maqasaa nifiqee anireenoo qimufaqa naafannanee qimasee uqannifiqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Miqi qimasee qimannimiseenoo Mooseefa Aaroona qimaminau. Anee qafee moo mara maree mannaa suqeeqee Anutuna afusaa quqasainaqa kasooaqee kambiqainausa qafaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Yaaweefa Mooseena qimamundee inoo Aaroonafa mi naranna mara mareenoo moodaanaki kira bookisa aaqa quqasoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isaraee maqannaasa 40 aukuanaki mannaa neemariqau. Mi naranna naqa fifiufaqa Kannaana maqasaa nariqa mariraree quqoo oonuraqau. ");
INSERT INTO bjr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mikari misa ummaara amana masee qafee marufa qaaraqanda marinau. Moo fannoo moodaa kaqikaa susufinna amana marinau. Moo fannoo qisaukuqara 10 kaqikaa susufinauqa amana marinau. ");
INSERT INTO bjr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Yaaweena ufa mau fiqa Isaraee maqannaasa Sinnaa aadana maqa maaqakiqari quqasee fiqau. Fidaqa misa maqusa maqusa faiqaqa fimariqau. Misa Reefidimma maqa maaqaki nammari sia maruqoo oonu mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Sia marufaqa misa Mooseenara kaukaata qidaqa qiqau. Anee nammari nimina naanee qufanoo Mooseefa qimanniminoo qinau. Innee nanaree qini aanoo qima qimaqaidee. Nanaree innee Yaaweena amanammasee qafaidee. ");
INSERT INTO bjr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Isaraee maqannaasa nammariara kaaqa nidufaqa Mooseena kaqi kai aanoo qimamaqee mariqau. Misa maaqi qiqau. Nanaree anee maasa Isipa maqa maaqaindaraana qifiqee mini saananoo fee nammariara didirafa maasa faqa maasa faiqi namu faqa maasa aandauqa namufaqa kuqa daruannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Miqi qufanoo Mooseefa afeekai kammaseenoo Yaaweenara innaaru qidanoo qinau. Oo Yaawee qinee maa fasiqa anaaseesa naqifeemma nimaqaanauree. Misa qusasaa oonisamu qini darifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yaaweefa Mooseena qimaminoo qinau. Moosee anee Isaraee maqannaasa uriqararausa nifiqee indaaru fua. Ooqai anee Niru nammari arunna saununa faqa maree fua. ");
INSERT INTO bjr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Qinee Sinai aaqanasaa inni noorinni oonisaa kikiqiqa marianaura. Aneenna saunu samu ooni arusainanoo nammari minakiqari quminaqa faiqí anaasee naaqa. Miqi qufanoo Mooseefa Isaraee maqanna uriqararausa nifusaa miqimandoofanoo nammari quminau. ");
INSERT INTO bjr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Misa mi maqa maaqana auqu qaara auqu raqau. Masaa faqa Meeribaa faqee qiqau. Mi auqu qanda oosana amana masee qafarafa faqa aanoo qirafa faqee qiqau. Aanoo qidaqa qiqau. Yaaweefa maasa faqa maridanoo fee sia fee maridanoo fee. Misa mi ufanannai Yaaweena amana masee qafaqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Isaraee maqannaa Reefidimma maqa maaqai marufaqa Amareekana aiku asauku anireeqa misa nariqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mooseefa misa nidafamasee Yoosuaana qimaminoo qinau. Anee akaqa fasiqauqa mara quqasainaqa duna kananaana Amareekana aiku asauku faqa oonu rakuaqa. Qinee aaqanasaa Anutufa marana nuannee qimasee qimaqimu saununa uqusee kikiqiqa marianaura. ");
INSERT INTO bjr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yoosuaafa eedoo qimasee kananaana iqaqoofanoo doo Amareekana aiku asauku faqa rakirara nifiqee finau. Fufaqa Mooseefa faqa Aaroonafa faqa Hurafa faqa aaqanai ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mooseefa aaqanasaa kikiqamambufanoo asaukuqara uqeerasoofaqa Isaraee maqannaasa rakiranaki afeekaikiqau. Kafaa narí asauku muqufisoofaqa Amareekana aiku asauku rakiranaki afeekaikiqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mooseena asauku anuda qoofaqa Aaroonasa Hurasa ooni ufiqisoofanoo Mooseefa minasaa ooqu marifufanoo Aaroonasa Hurasa Mooseena asaukuqara uaqeeufanoo kisaaqasaa marufanoo suani keeqanau. ");
INSERT INTO bjr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Miqimmasee uaqeeunara Yoosuaafa faqa narí rakira fasiqauqa faqa Amareekana aiku asauku amiqimmasee naruqaraasiqau. ");
INSERT INTO bjr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Miqimmasoofanoo Yaaweefa Mooseena qimaminau. Anee papiqaki maa rakiranara akararumma quqaa. Miqinoo marinaqa kaqi iriqa nuaqa. Yoosuaana qimamia. Qinee Yaaweesa Amareekana aiku asauku kuridi taikasaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Rakirafa taikafufanoo Mooseefa ooniuqa qumareenoo mi maqa maaqanaki qainda auquseenoo mi qaindana auqureenoo Yaaweefa qini rakira saqari fee qimasee mi qaindana auqu ranau. ");
INSERT INTO bjr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mooseefa kafaa qinau. Innee Yaaweena rakira saqari uqeeraaqa. Yaaweefa kaqi kai Amareekana aiku asauku faqa naaruara rakida mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yeetaroofa Midianna maqannaasa aanaiqikirafa Mooseena airaamaku marinau. Aiqama ainaina Anutufa Mooseena faqa Isaraee maqannaasa faqa dadaaqi marunara faqa Isipa maqa maaqakinaana nifiqee anunara faqa Yeetaroofa irinau. ");
INSERT INTO bjr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Iriseenoo mifa faqa Mooseena anaaqa Sipooraa nammarina maqusai quqasee anuna afiqee aninau. ");
INSERT INTO bjr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Mina faiqiqara Keerasoommana faqa Eerieesarana faqa nifiqee aninau. Mooseefa maaqi qinau. Qinee aanaamuru maqa maaqaki asaqiraafai ani maridee qimasee narí amaaku auqureenoo Keerasoommanee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mooseena inaaqianaa faiqi auqu Eerieeseerafa marinau. Mina anoofa maqasoofanoo Mooseefa qinau. Qini qikoona Anutufa qini dadaaqinoo Faraoona duru feefa ookinaana qini ititaqisainaree qinoo mina auqu Eerieesaranee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yeetaroofa Mooseena anaaqa faqa mina faiqi qara faqa nifiqeenoo aadana maqa maaqaki naaquqara aaqana aaqa Mooseefa uiqaana maqa usakasee maruqoo aniranau. ");
INSERT INTO bjr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yeetaroofa Mooseenara ufa quqaidanoo qinau. Oonuree maaqi qimasee qimamiaqa. Ani airaamaku faqa ani faiqi anaasee faqa anidammiaafoo qia. ");
INSERT INTO bjr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mooseefa mi ufana iriseenoo narí airaamaku oonu aanai paqurimaseenoo mina oorinni aqoori saunu arafufanoo mina amooqa nanau. Miqi masoofaqa nári mariranara narí iree narí iree maseeqa doo Moosena uiqaana maqaki keeqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Minaki ooru maridanoo Mooseefa narí airaamaku oosana oosana aupurarana Yaaweefa Faraoona faqa Isipa maqannaasa faqa nimiseenoo Isaraee maqannaasa maroonara qimaminau. Mifa Isaraee maqannaasa aanai anidaqa moomoo ummaara maree marufanoo Yaaweefa dadaaqunara faqa qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yeetaroofa mi aiqama ufana iriseenoo asasinau. ");
INSERT INTO bjr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Asasammaseenoo qinau. Yaaweefa Faraoona asaukukinaana faqa Isipa maqannaasa nisaukukinaana marainara mina amooqia. Yaaweefa narí faiqí anaasee rumbarana kinaana idukunara mina amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Doo maqee qinee iridaqa, Yaaweefa aiqama unna anutusa urinnaaqararafa maridanoo. Isipa maqannaasa inni mandaikamma nimaqee marufanoo inni idaaqamma nisoonannai mifa aiqama unna anutusa urinnaaqararafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Miqi qimaseenoo Yeetaroofa aandau marasee aruseenoo muduka ida aiqama qama taikara tatufirana Anutuna suqa aminau. Kafaa mifa akaqa tatufirana faqa Anutuna suqa aminau. Aaroonafa faqa Isaraee maqannaa uriqararausa faqa anireeqa Mooseena airaamaku faqa Anutuna amooqidaqa mi naaquqara qoomaqana naqau. ");
INSERT INTO bjr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Iaqoo kananaana Mooseefa findifinoo narí maqannaa qambaanai oonureenoo misa kootauqa irinau. Kananaana oosana arasee kootinoo fifii ufanoo eenda kai masanau. ");
INSERT INTO bjr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yeetaroofa Mooseena kadaapirirana qafamaseenoo maaqi qimaseenoo Mooseena qimaminau. Anee nanaree aneennaraa maa saikausa auqaidanee. Faiqí anaasee kananaana kootirara ani marida rakisi mariafanoo eendidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mooseefa iriseenoo qimaminoo qinau. Qinee miqianaqa faiqí anaasee qinee unnannai aniree Anutuna aidiranara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Qaara fasiqa qara ufa rainaida narí afu mau narí afu mau maseeqa qinee unnannai aniraafaqa qinee andeeqai fasiqanara maafa andeeqee maqi qimaseeqa Anutuna sanda ufa naakapaidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yeetaroofa Mooseena qimaminoo qinau. Anee sia andeeqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Anee miqidana aneenna afeeka taikainaqa maa fasiqa anaaseesa faqa miqi kai ifaranoo. Aneennaraa sia amanaiki mariananoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Anee maqee qini ufa iria. Qinee amiqira aakapara ufa ani amianaura. Anee irinanoo Anutufa ani faqa marida dadaaqiannoo. Anee andeeqaseenana Anutuna afusaa aanaiqikina maridana faiqí anaasee ummaara Anutuna qimami mariananoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Anee Anutuna sanda ufa qimannimisee andeeqara marirana oosana naamua qimasee misa ifandinna ainainara faqa qimannimia. ");
INSERT INTO bjr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Qima nimiseenana anee mina amuaaqa irirana faqaa fasiqauqa mara quqasainaqa Isaraee maqannaasa uriqararausaikiqa mariaqa. Akaqausa wan tauseenna (1,000) fasiqa aanaaseesaa rakisifaqa akaqausa wan handareetasaa 100 rakisifaqa akaqausa fiftisaa 50 rakisifaqa akaqausa teennasaa 10 rakisiaqa. Misa Anutunara rufiee mariasa maridaqa misa andeeqara oosana faqaasa maridaqa sia umee raaqee munnimma maree marinausa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Mi fasiqausa aiqama kari faiqí anaasee koota ufa irimarinausa mariaqa. Moo afeeka ainaina firaa ainaina kambiqafinaqa maree mini ani amifana anee mina andeeqaa. Kaqikaa ainaina nári kai andeeqaaqa. Misa miqimandee ani qummaara raina maraifanoo ani afaaqa aufadaani. ");
INSERT INTO bjr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Anutufa eedoo qinana qini ufa mau finana sia kudoosaapeennaranoo. Miqinaqa maa fasiqa anaaseesa aanoo qirafa taikafinaqa quqasee nimaaqa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mooseefa Yeetaroona ufa iriseenoo mi mau kai finau. ");
INSERT INTO bjr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mooseefa irirana faqaasa Isaraee maqannaasa kinaana mara quqasoofaqa uriqararausaikiqau. 1,000 fasiqasaa rakisirausa faqa 100 fasiqasaa rakisirausa faqa 50 fasiqasaa rakisirausa faqa 10 fasiqasaa rakisirausa faqa mara quqasoofaqa rakisimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Misa aiqama kari siaasara foora naaruara mariqau. Maridaqa kaqikaa kootauqa misa andeeqee mariqau. Firaa koota Moosee funnai maree fimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Miqimmasee Mooseefa Yeetaroona amandama soofanoo amaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Isaraee maqannaasa Isipa maqa maaqakiqari Reefidimma maqa maaqaki ani mariufaqa miqooqari qaaramoo uqoona indaaruqaa faasaanasaa Reefidimma maqa maaqaindari Sinai aadana maqa maaqai oonu mariqau. Miqoo misa Sinai aaqana aikunni uiqaana maqa usakasee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mooseefa miqooqari Sinai aaqanasaa Anutuna faqa ufa qiraree qimasee ooru finau. Yaaweefa aaqana saaqari Mooseena aaramaseenoo qimaminau. Anee Yakooboona aiku asauku Isaraee maqannaasa maaqi qimasee qimannimia. ");
INSERT INTO bjr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Innee qini oosana qafee mariafanoo. Qinee Isipa maqannaa narunnana innee qafaafanoo. Qinee inni quqaumu aanaaqiara foora itateeqeeqa qiqoosasaa quqaseeqa uqeereeqee qeeqa marunannai quqaqaunaqa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Innee qini ufa iriseeqa qini moodaanaki kira ufa mau fiqa qini faiqí anaasee marifaranoo. Aiqama maa maqa maaqafa faqa faiqí anaasee faqa qinindi kai maridaqa innee qinee qeeqara utaaqama qaunausa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Innee qinindi uqanna maridaqa qini aanaiqi kirausa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mooseefa irisee ooqureenoo Isaree maqanaa uriqararausa suquseenoo aiqama Yaaweefa qimamu ufana qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Faiqí anaasee Yaaweena ufa iriseeqa aiqamausa moodaa kari noo raqa maree qiqau. Yaaweefa aiqama ufa qinnana maasa irianauree qiqau. Miqi qufanoo Mooseefa misa ufa iriseenoo Yaaweena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yaaweefa misa ufa iriseenoo Mooseena qimaminoo qinau. Qinee amatooki arira oonnamukiqari anee iannannai qumuree ani faqa ufa qianaqa faiqí anaasee iriseeqa miqooqari ani ufara kuqaa fee qifaranoo. Miqi qimasoofanoo Mooseefa faiqí anaasee quu ufana Yaaweena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Qimamisoofanoo Yaaweefa kafaa Mooseena qimaminoo qinau. Anee kafaa ooquree faiqí anaasee maaqi qimasee qimannimia. Misa aiqama maqee faqa duna faqa nári qamunna nammari uqusee nári nifaaqa anukamasee qini qimooqirara deedaqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Deeda qimarifaqa duna kaqi mari moona qinee Sinai aaqanasaa qumuraanaqa aiqama faiqí anaasee qini qiqafeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Anee aaqana ameemaanai fiqu fiqumma oosumma sainaqa sia faiqí anaasee mina fiaaqaraaqa. Miqimmaseenana qimanniminaqa sia aaqanai ooru fuaqa, sia uqanna mina aaqa fuaqa. Minasaa aiku rainafa kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Innee miqinna fasiqana sia uqanna nisaukunnai aruaqa, ooni samu fee feefannai fee kuqa aruaqa. Maa ufana faiqí faqa aandaura faqa qidaqa. Miqinna fasiqa fee aandau fee kuquannoo. Ukeena fuaqaifaqa kai faiqí anaasee aaqana aikunni ooru fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mooseefa aaqanaindari qumureenoo faiqí anaasee Yaaweenara deedaqa masee amooqiaqeera qimanniminau. Miqi qufaqa faiqí anaasee nariqa qamunna nammari uqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Miqi marufanoo Mooseefa qimanninau. Duna kaqi mari moona deedaqiaqa. Maqee oosana arasee sia anaasee sakasee faiqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Qaara afuru faisoofanoo qaaramookufanoo kananaana aaqanasaa ukeena firaana fuaqarana namu faqa qamatooki kira oonnamu namu faqa aakuasaa innaarunai namu faqa ufaqa faiqí anaasee uiqaana maqaki mariusa aiqama naindiri roofaqa rufiaqau. ");
INSERT INTO bjr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mooseefa faiqí anaasee aiqama uiqaana maqakinaana nifiqeenoo Yaaweena paqurirara aaqana aikunni oonu kikiqino marinau. ");
INSERT INTO bjr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Yaaweefa idauruki qari Sinai aaqanasaa qumu marunara ida muna fannoo aaqana aiqama rafaaqafinoo marinau. Mi munafa firaa ida munara foora ooru fufaqa faiqí anaasee qafoofanoo firaaqoo naindiri ranau. ");
INSERT INTO bjr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ukeena feendundaanai qimarinau. Miqi qimarufanoo Mooseefa Yaaweena qimamufanoo Yaaweefa kafaa innaarunai darara qiranakiqari narí qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yaaweefa Sinai aaqanasaa qumureenoo Mooseena aaroofanoo oorufinau. ");
INSERT INTO bjr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ooru roofanoo Yaaweefa Mooseena qimaminoo qinau. Anee ooquree faiqí anaasee qimanniminaqa sia oosu aiaaqaree qini qiqafarara aniaqa. Misa miqiqa moomoosa kuqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Aanaiqikirausa faqa qini daaqa aniani qimasee anukamafiqa aniaqa. Sia miqifaqa misa aupurarana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mooseefa Yaaweena ufa iriseenoo qimaminoo qinau. Faiqí anaasee sia amana Sinai aaqanasaa urifaranoo. Anee aneenna kai maasa daakapama seenana naaquqara aaqana fiqu fiqumma amusa arasaanaqa sia urifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yaaweefa iriseenoo Mooseena qimaminau. Ooqureenana Aaroona faqa afiqee urua. Qini aanaiqikirausa faqa faiqí anaasee faqa sia qini qiqafararee qimasee amusa rapeemmasee uruaqa. Miqifaqa qinee misa ummaara nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mooseefa iriseenoo ooqureenoo faiqí anaasee aiqama Yaaweefa quu ufana qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Anutufa maaqi qinoo. ");
INSERT INTO bjr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Qinee Yaaweesa inni Anutusa maridaqa. Qinee Isipa maqasaa rumbaranaki maruna inni mareeqee mai quqaafanausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Innee sia moo anutuna amooqiaqa, qini kai qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Innee sia innaarunai mari ainainausa faqa maqasaa mari ainainausa faqa nammariki mari ainainausa faqa nimana auqusee maasa anutufee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Minara sia moo ainaina amana auqirana oorinni mapamufida innaaru qidaqa amooqiaqa. Qinee Yaaweesa inni Anutusa marunnanara sia mi ainainausa nimooqiaqa. Qinee sia uqanna moo anutunara qiananoo qini qimaaqa maqaannoo. Faiqí qiniara fidiaqaa inausa aupurarana nimiananoo misasaa faqa misa faiqi namu saa faqa misa ninaiqimara saa faqa nisaifaqausa saa faqa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Moomoosa qiniara ridaqa qini sanda ufa mau finausa qinee misa faiqi namu kasooaqee nukudara foora kambiqainausa qeeqa didirana uqannifiqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Innee sia qini duqunnai manda oosana auqaaqa. Qinee Yaaweesa inni Anutusa qini duqa fifau faafau inausa aupurarana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Innee Sabata faasaanara naaquqara faasaanee qimasee iriqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Dinni taikasee dinni ani moodaa marasee 6 faasaana inni ainainira faasaana mariani. ");
INSERT INTO bjr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Dinni ani qaara marasee 7 faasaanasaa qini Yaaweesa adooara faasaana maridanoo. Mi faasaannasaa sia uqanna moodaafa faqa ainainiani. Innee faqa inni faiqi namu faqa inni ainainira faiqiuqa faqa inni aandauqa faqa aanaamuru inniki ani mariasa faqa sia uqanna ainainiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Dinni taikasee dinni ani moodaa marasee 6 faasaana qinee Yaaweesa innaaruna faqa maqa faqa ooruku nammari faqa minauqaki mari ainainausa faqa auqi qiafana. Dinni ani qaara marasee 7 faasaanasaa qinee qidooa qiafana. Minara qinee Yaaweesa Sabata faasaana afaaqooqa qimasee naaquqara faasaanee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Inneeqa ninausa nikausara qeerairidaqa misa ufa qaindusuaqa. Innee miqiqa qinee nimianna maqanasaa kisaaqasaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Innee sia faiqí anaasee nuqu qimasee naruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Innee faiqí anaasee sia narí ummuari narí umuariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Innee sia moona ainaina umuariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Innee sia akaqausara unna qimasee misa kikiqa ususee ufa nimia. ");
INSERT INTO bjr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Sia moona maaqa umiasanara amuqusiani. Sia moona aanaaqara amukaani mina ainainira fasiqa anaaseera faqa misa aandau ainainara faqa mina aiqama ainainara faqa sia amukaani. ");
INSERT INTO bjr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Faiqí anaasee aiqama innaarunai qirana faqa aakuasaa faqa ukeena firaana faqa aaqanasaa idamuna namu faqa qafoofanoo naindiri reenoo naaquqoofaqa nianasaa marida qafee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Miqi masee misa rufiasee Mooseena qimamiqa qiqau. Anutufa maasa qimaqiminaqa maasa irisee kuquanoora rufiaidaqa anee kai maasa qimaqiminaqa iria. ");
INSERT INTO bjr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mooseefa iriseenoo qimanniminau. Innee sia rufiaaqa Anutufa inni nimanamasee qafainaqa aiqama kari minara rufiasee mina ameemaanai maridaqa numoo ainaina sia auqaaqeera. ");
INSERT INTO bjr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Miqi qimasoofaqa faiqí anaasee nianai marufanoo Mooseefa kai Anutufa asukuna arira oonamuki maruna aaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yaaweefa Isaraee maqannaasa qimannimianifeera maaqi qimaseenoo Mooseena qimaminau. Qinee innaarunaindari inni faqa ufa qimarunaqa innee inneeqa nifunnai mina qafaafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Innee sia siruaannai faqa koorannai faqa unna anutuna amana auqusee qini Yaaweesa faqbaqa masee amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Innee maqannai qainda auqusee minasaa inneeqa sipsipa faqa burimakau faqa miniseeqa ida qama taikara tatufirana suqasaifaqa faiqí anaasee qini faqa moodaanaki kiaqa. Aiqama maqusa innee qini qimooqiaqeera utaaqama qaunna maqusanaki oonureeqa miqifaqa qinee innee iannai qumuree amiqi amiqimma nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Innee ooninnai qini aidara auqiraree qimasee sia faiqí rukamuqaa ooninannai auquaqa. Innee faiqí rukamuqaa ooninannai auquseeqa minasaa tatufirana suqa qimirafa sia amanaikiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Innee sia aidara auqusee minni akarara irirasu auquaqa. Innee miqiqa umee nifaaqa kooroo ifaqa qafeefoora. ");
INSERT INTO bjr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Anutufa Mooseena qimaminoo qinau. Anee maa sandufana Isaraee maqannaasa qimannimi. ");
INSERT INTO bjr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Innee Heeburu maqannaasa ainainira faiqi munnimmannai feefaurumasaifanoo mifa inni faqa moodaannai taikasee dinni ani moodaa 6 marasee aukuana ainaina masainaqa dinni ani qaaraikinaqa 7 doo quqasaifanoo kaqi fuani. Idukinnana akiiqara sia feefauriani. ");
INSERT INTO bjr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Mifa adeedaana maridanoo ani ainainira faiqikinoo mariinafa amaaqa firarinoo sia anaasee maree fuannoo. Kafaa anaasee faqaafa inni ainainira faiqi kinoo mariinafa amaaqa finoo amana narí anaaqa afiqee fuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mina feefauru mina rakisiifa anaasee aminanoo mifa faiqi maqaseenoo mariinanoo mina aukuana taikainanoo anaasee faqa faiqi faqa miqoo quqaseenoo kaqisamu amaaqa fuani. Mi anaaseena faqa mina faiqi faqa rakisiranaindi kai marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ainainira fasiqa fannoo narí faiqi aanaaseera amuqusinanoo sia amana uqaanauree qimaseenoo ");
INSERT INTO bjr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","qinee qeeqa rakisiranara didimarifaqa qimaseenoo sia qinee taikasee fuanaura kaqi rumbaranaki marianauree qimasainanoo mina rakisirafa mina qumareenoo amaana maaqaki munuseenoo quka qumareenoo kooqi mammaaqai aaqoo ruqiaani. Ruqiasainanoo mi fasiqafa naaruara ainainira faiqi mariinanoo miqoo kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Faiqí moo fannoo narí araamuna ainainira maanaaqaikianifeera amisainanoo sia ainainira fasiqauqa iduku nisaandee masee idukusaina fuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Mi manaaqana ainaina faqaafa feefauru meeqeenoo narí ainainiranaki quqasee qinaaqara maraanauree qimasee mariinoo akooqaifanoo sia mareenoo. Miqinannai mi manaaqana mandaikama amaqaseenoo sia aanaamuru nimisee feefauru maraannoo. Narí akoofa kai kaifaa feefauriannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Faiqí moo fannoo narí faiqi amiraree qimaseenoo ainainira maanaaqa feefauru maseenoo narí araamunara foora rakisiani. ");
INSERT INTO bjr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Faiqí moo fannoo anaasee faqaafa moo maraseenoo indaaruqaana narana faqa qamunna faqa mina ainaina dadaaqirana faqa sia minnisaani, ooqai iundee kai iani. ");
INSERT INTO bjr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Mi fasiqafa indaaruqaana sia mi ainainausa andeeeqa amaqeenoo mi fasiqafa mi anaaseena aiqainanoo finanoo sia feefauru maraannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Faiqí moo fannoo moo fasiqa kuqarusainaqa narí faqa kai kuqaruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Faiqí moo fannoo sia moo fasiqa auqu qimasee arinafa mifa amana qinee inni utaaqama nimaqa qaunna maqusanaki keeqafinoo asumu mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Yafee moo fannoo moonara aranaqainanoo auqu qimasee arinafa mifa faqa kuquani. Qini aidarai mifa oonu kukeeqafi asumu marianauree qinaqa innee mindaraana rarisamasee kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Yafee moo fannoo narí anoona akoona narinaqa innee mina kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Faiqí moo fannoo moo fasiqa mareeqeenoo narí ainainira faiqi kee iannoo fee moo atinai nimisee feefauru fee marainnana kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Yafee moo fannoo narí anoona akoona manda ufa qimannimaqainnana mina kuqamma aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Faiqí misa tinoorammamaree fidaqa faiqí moo fannoo moona ooni samu fee saamu samu fee arusainanoo sia kuqirai aurida mariinanoo findifinoo nimarinaqa innee mina akiiqara ari fasiqana sia aupurarana amiaqa. Arinna fasiqafa narí qaarisaa mariinanoo findifinoo madaanai saunusaa ooquree ururee irana amanaikinanoo ari fasiqafa mina feefauru auriranaki mariinna faasaana amana kai feefauru amisee minasaa rakisi marinanoo findi fuani. ");
INSERT INTO bjr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Faiqí moo fannoo narí feefaurummaqai ainainira fasiqa nee maanaaqa nee saamu qumaree arusainanoo aaqee kuqinaqa innee mina akiiqara narí faqa moo aupurarana amiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mi ainainira fasiqa nee manaaqa nee sia aaqee kuqirai moodaa eenda fee qaara eenda fee kaqi mariinanoo kuqinaqa innee sia mina uriqararafa mina arinnana akiiqara amiaqa. Narí ainainira faiqiara aupurama amaqaifa narí ariranasaa ititeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Faiqí rakinnanaki moo fasiqa fannoo amuaqu faqaa anaasee arusainanoo kuqira faiqi maqaseenoo mina anoofa kaqi marinanoo mi anaaseena afaaqi fannoo nana feefauruaree irainanoo mi fasiqafa feefauriannoo. Siaasauqa eedoo qinna feefauruna kai amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mi anaaseefa moo aupurarana marainaqa mina arinna fasiqana faqa mi aupuraranna kai amiaqa. Kuqa arinaqa narí faqa kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Nifu dimbasainaqa narí afu faqa dimbaaqa. Nifai itairisainaqa narí afai faqa itairiaqa. Nisauku raudasainaqa narí asauku faqa raudaaqa. Niku itairisainaqa narí aiku faqa itairiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Idati raquru niminaqa narí faqa idati raquru amiaqa. Kaakadi narinaqa narí faqa kaakadi aruaqa. Saamu narinaqa narí faqa saamu aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Faiqí moo fannoo narí ainainira maanaaqa fee fasiqa fee arumareenoo afu qimbaseenoo mina akiiqara idukusee aiqainanoo amaaqa fuani. ");
INSERT INTO bjr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kafaa mifa narí ainainira fasiqa fee maanaaqa fee arumaree afai itairiseenoo mina akiiqara idukusee aiqainanoo amaaqa fuani. ");
INSERT INTO bjr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Burimakau akoona fannoo faiqí fee anaasee fee kuqa narusainaqa ooni samu mi burimakau akoonna kuqa aruseeqa mina amaqi sia naaqa. Mi burimakau akoona arusaifanoo mina akoona aupurarana amirafa sia mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mi burimakau akoonnafa ooqai faiqí nárí marifa maridanoo kafaa moo fasiqa kuqa arinaqa mina akoofa sia ququsaki mara quqainanoo kafaa narinaqa mina akiiqara ooni samu mi burimakauna kuqa aruseeqa mina akoona faqa kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kuqina akiiqara aqira feefauruara ooqai auqu ramaqaana amana kai aquseenoo narí kuqiranasaa ititaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Burimakau akoona moo fannoo maanaaqa fee akoonaiqi fee narusainaqa innee ooqai qimaqaa ufa mau kai fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Burimakau akoona moo fannoo ainainira kumaaraa fee maanaaqee narusainaqa mi burimakauna akoofa ainainira faiqi uriqararana firaa feefauru amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","Faiqí moo fannoo madika indufuseenoo rafaaqafu qainanoo moo fannoo oonu mina rafaqaamma sainanoo burimakau fee doonki fee minaki aqufiqa kuqifanoo, madika afu rafaqaa ifa mi aandauna akiiqara feefauru maseenoo nariara mi aandauna maraanoo. Faiqí moo fannoo madika indufusee sia rafaaqa finanoo aandauqa minaki aqufiqa kuqifanoo mi fasiqafa aandau akoona feefauru amiseenoo nariara mi aandauna maraannoo. ");
INSERT INTO bjr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Moo fasiqa burimakau akoona fannoo moona burimakau akoona arusainaqa burimakau akooqanda kaqi mari burimakauna mareeqee moosaa quqasee feefauru marasee miqanda mi munnimmana rainaqaraasa mandee kuqira burimakau qambaana aukuqaraasa masee moo fannoo dinni maraina moo fannoo dinni maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mi burimakau akoonafa ooqai nárí maru burimakaufa marifanoo mina akoofa sia ququsaki quqainanoo moona burimakau kuqa arusainanoo mina akiiqara moo kaqi mari burimakauna amiseenoo kuqirana nariara maraannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Faiqí moo fannoo burimakau fee sipsipa fee qummuara mamaree munu moona amisee feefauru maraina fee arusaina fee mi fasiqafa moodaa burimakau akiiqara moodaannai qisauku burimakau mina amiannoo. Moodaa sipsipa qummuarinnana akiiqara qaara faqa qaara faqa sipsipa amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Mi fasiqafa narí qummuarirana akiiqara feefauriannoo. Moo ainaina sia marinaqa mi fasiqana mareeqee moo maqannaa nimisee mina feefauru mareeqee mifa qumuarina akiiqara nimiaqa. Mi fasiqafa burimakau fee doonki fee sipsipa fee maraqainafa kaqi riri marinanoo qaaraqanda mina akiiqara nimiani. Eendakinai qummuarira fasiqa fannoo maaqa ruiqasee keeqainaqa mina qumarasee kuqa arusainafa sia mina akiiqara ufa maraannoo. Faasaana miqi marinaqa kuqa arinna fasiqafa mina akiiqara ufa maraannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Faiqí moo fannoo narí burimakau fee sipsipa fee andanda nee marinana sia amiqimmasee rakisinanoo moona afuqaki keeqafi narana nainanoo mina akiiqara narana faqaana narí afuqakinaana amiqirana kai unaku maree munu amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Faiqí moo fannoo narí afuaki ida arasainanoo qamammareenoo moona afuqa qeenoo narana unaku quqaqainnana qamasainanoo mina akiiqara idarai fasiqafa mina amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Faiqí moo fannoo munnimma moo fasiqasaa quqasaina marinanoo moo fasiqa fannoo qummuari marinaqa paquri masaifanoo mina akiaqara qaara kari feefauru amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Qummuari fasiqana innee sia paquriqa munnimmasaa rakisii fasiqana afiqamaree innaaru qimaria maqusanaki munusee iraifanoo mifa narí amana aiqamasee kuqaa sia qinee maree fee qiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Aiqama ainainara aanooqiranaki burimakaura faqa doonkiuqara faqa sipsipauqa faqa qamunnara faqa akaqa ainainara faqa qinindi kai fee qimasee aanoo qinna fasiqa qanda nifiqamaree innaaru qimariaqoo nifiqee aniaqa. Anutufa yanaree unnaqiifoo qinafa mifa mina akiiqara qaara kari feefauru amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Faiqí moo fannoo moona doonki fee burimakau fee sipsipa fee moo aandau fee rakisi marinanoo moo aandau fannoo kuqinoo fee nana afaaqee mandaikinanoo fee namuqaa fee mara maraafanoo moo fasiqa fannoo sia minauqa qafeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Mi aandausa saa rakisirafa innaaru qimariaqoo oonureenoo amana aqiqamaseenoo qinee sia uqanna mi aandausa ummuari fee qiani. Mi aandausa sia ummuarifanoo aandau akoofa minara amanammifoo qimasee sia mina akiiqara rakisiinafinnai feefauru maraannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kuqaa mi fasiqafa ummuarinoo mifa aandau akoona mina akiiqara feefauru amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kaasau faini mi aandauna aruneennoo fee mina rakisi mari fasiqafa mina asausifee amudaani fee mara mina akoona uqafiqaseenoo sia mina akiiqara feefauriannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Faiqí moo fannoo moona aandau akaqa ainainirana dadaaqianifeera marasainanoo kuquannoo fee amudaani itairinoo fee mi aandauna akoofa uqanna sia marinanoo ufaasu marai fasiqafa feefauriannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mi aandauna akoofa uqanna mina afusaa miqifanoo sia mina akiiqara feefauru aandau akoona amiannoo. Ufaasu feefauru masaafanoo ainainirana dadaaqi mari aandaufa kuquannoo fee amudaani itairiannoo fee feefauru maqaifa miqiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Faiqí moo fannoo maanaaqa moo faiqí moo sia utaaqama amaqarana sararamma amaqaseenoo mi fasiqafa mararara mina akoona feefauru amiseenoo marasainanoo mina aanaaqaikinoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mi manaaqana akoofa mi fasiqanara akooqainanoo sia narí araamuna maraannee qinanoo mi fasiqafa fuka maanaaqa feefauri mariana amana kai mina akoona amiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Aukainaina maraqanua aanaaseesa kuqa naruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Faiqí moo fannoo aandau amuaaqa akarainnana mina kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Qini Yaaaweesa kai aandau tatufirana suqa qimiaqa. Moo unnaqira anutuna tatufirana suqa aminnana kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Innee ooqai Isipa maqasaa aanaamuru marunaki mandainainaki marunnara irisee sia aanaamuru inniki marinausa mandaikamma nimaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Innee adeedaana anaasee fee fiaiqi faiqi fee sia mandaikamma nimaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Innee miqifaqa misa qini daaraifaqa qinee Yaaweesa irianaura. ");
INSERT INTO bjr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Qini qirana qainaqa rakiranaki inni kuqa naruanaura. Narusaanaqa inni ninaaqmaaka adeedaana marifaqa inni faiqi namu fiaiqi marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Inniki qari qini Yaaweesa faiqí anaasee moo fannoo munnimmara sarau imarinnana ufaasu munnimma aminana sia ufaasu munnimma nimimariasa naanna raaqa. Misa nimiseeqa nárindi akiiqara maraseeqa aabaa faqa maraidaqa. Innee inneeqaindi akiiqara kai maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Innikiqari faiqí moo fannoo ani ainaina ufaasu maraseenoo kafaa amianauree qimasee narí suara siuta amiseenoo minannoo narí amianinna ainainara kooroo idanoo kuqaa amianauree qidanoo. Miqi qinana anee suani afu sia keeqanoo marinana mina suara siuta kai kaqi narí amia. ");
INSERT INTO bjr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Mi suara siutafa tootooqirana amianifeera quqaqaina marifanoo nanee moo ainaina akusee faiqaannoo. Anee sia aminanoo suara arinanoo qinee unnannai innaaru qinaqa qinee mina ufa irianaura. Qinee kaaqa faiqiara qimudaoo qimarunausa maridaqa miqianaura. ");
INSERT INTO bjr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Innee sia qini Anutusara manda ufa qiaqa. Inniqa rakisirausara faqa sia miqi qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Innee fuka narana afiana neeqa sakuma faqa uainna faqa oorifa fadameena faqa inneeqa ooqa faiqi faqa qini Anutusa naaree qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Inneeqa burimakau sipsipa ooqasaa maqarana akoonauqa dinni taikaseenoo dinni oonu qaara marasee 7 faasaana narí anoona faqa mariseenoo dinni oonu qaaramoo 8 faasaanaikinaqa mina arusee tatufirana suqa qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Innee qini faiqí anaasee marianara kaasau faini fannoo aru quqaqainna aandauna amaqi sia suqasee naaqa. Faini mara nimifaqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Innee aatata qaraa unna ufa iriseeqa sia moona munu qimamia. Innee sia aaqee mari fasiqana unna ufannai mina dadaaqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Kootaki oonureeqa moomoosa unna ufa qifana anee sia misa dadaaqia. Misa ufaki kikiqa mafi andeeqara ufa mara furufarifana sia misa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Kudi fasiqa moo fannoo kootaki kikiqa mafinana sia kudi marinnana roo qimasee dadaaqia. Andeeqara nara kai qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Innee inneeqa namuqaa burimakau fee doonki fee furufariqa nifaqa innee qafamaseeqa maree narí akoona munu amiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Mi fasiqana doonki fannoo ummaara mara maree fidanoo aanai saamurinoo marinaqa innee oonu qafee sia fiaaqaraaqa dadaaqi uqeera aisaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Kudi fasiqa fannoo kootaki marinaqa innee sia minara manda fasiqee qimasee andeeqara oosana sia mina amiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Innee sia unna qimasee kootaki aqoonnana kikiqa usua. Sia andeeqarausa numoo siaisa fifau kuqiranaki mara quqannisaa. Qinee Anutusa mi manda ainainna auqainnana kuqa aruanauranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Moo fannoo maqandanai kootaki minasaa roo qiannee munnimma aminana sia uqanna maraa. Miqira munnima fannoo faiqí nifu dimbarausaikamma saifaqa sia andeeqarana qafaidaqa. Andeeqara fasiqa faqa mara furufaramma aisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Innee ooqai Isipa maqasaa maridaqa aanaamuru aupurarana qafeeusa mariafanoo minara innee sia quandafi aanaamuru inni faqa marinausa mandaikamma nimaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Inneeqa maqa ummaqu nee maria maqanaki minaki dinni qisauku taikasee dinni ani moodaa marasee 6 aukuana ummaqusaidaqa unakusaidaqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Miqiqa fifi inaqa qisauku dinni taikasee dinni ani qaara marasee 7 aukuanasaa saifanoo maqa fanoo idooaani. Mi maqanasaa moo ainaina kambiqainnana sia unaku naaqa. Kudi fasiqauqa mina naaqa. Misa naidaqa andaanauqa mafi sainnana kaasau aandauqa naaqa. Inneeqa uainna afuqa faqa oorifa saqari faqa miqi kai iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Innee moodaannai qisauku taikasee dinni ani moodaa marasee 6 faasaana ainainiaqa. Ainainiqa fifi inaqa dinni taikasee dinni ani qaara marasee 7 faasaanasaa sia ainainiaqa. Inni ainainira faiqiuqa faqa aanaamuru inni ainaini marinausa faqa inni aandauqa faqa aiqama idooaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Qinee Yaaweesa aiqama ufa qimarunnana iriaqa. Innee maa amaana ufausa amiqimasee irimaree fuaqa. Sia unna anutusara innaaru qiaqa. Sia uqanna misa nuqu raaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Aiqama aukuanaki qaarammoo kari oomaqa sakasee naidaqa qini Anutusara innaaruqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Innee Isipa maqa maaqaindari anu quqoonnana Abiba quqoonasaa qinee qimannimiafannandee iqa innooqee mari pauraqana sia aqira bereeta naidaqa asasiaqa. Mi oomaqanaki 7 faasaanasaa sia innooqee mari pauraqana aqira bereeta naaqa. Innee qini qimooqiraree qimasee sia kaqi aniaqa. Qini tatufirana suqara ainaina faqa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Fukakinaana unakusee oomaqa sakasee asasidaqa namaseeqa inneeqa narana ummaquqaana oosanarasee unaku naaqa. Saqari aqama akuqainaqa innee mina tiqisee auqaanai maridaqa moo oomaqa sakasee naida asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Aiqama aukuana mi qaaramoo oomaqiranakina aiqama Isaraee maqannaa fasiqauqa anireeqa qini Yaaweesa inneeqa Anutusa qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Innee aandaunnoo qini tatufirana suqa qimiraree qimasee sia innooqee mari pauraqana aqira bereeta namu faqa moodaanaki suqaaqa. Tatufira aandau fadameena fannoo sia faiqee kananaana kaqi mariani aaqee kai aiqama idaki aqusaifanoo qama taikafuani. ");
INSERT INTO bjr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Aiqama aukuana innee fukakinaa narana unaku maree qini Yaaweesa inneeqa Anutusa amaana maqaki maree aniaqa. Innee sipsipa aanaaqi fee mimmi aanaaqi fee arusee sia narí anoona naamma anoonannai suqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Anutufa kafaa qinau. Qinee qeeqa kai qeeqa Qangiroo aqiqaananoo mifa qumuree inni indaaru nikidanoo innisaa rakisi marinaqa qinee inni deedaqamma nisaafanna maqa maaqanaki fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Innee mi qangiroofa qinnandee iaqa. Sia mina ufa rukiaaqa. Qinee mina aiqaunanoo qumu marinara sia mina ufa rukiaaqa. Mifa sia inni manda oosana akiiqara nifauaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Innee mina ufa irisee andeeqasee qinee qunnufa mau kai fifaqa qinee inni namuqaauqa faqa rakuanaura. ");
INSERT INTO bjr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Qini qangiroo fannoo inni indaaru nikinoo nifiqee Amoora maqa maaqa faqa Heeta maqa maaqa faqa Perisita maqa maaqa faqa Kannaana maqa maaqa faqa Hifitana maqa maaqa faqa Yeebusa maqa maaqaki mariasa faqa naru taikaseenoo inni miqoo quqannisaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Innee miqoo oonu maridaqa sia misa unna qira anutusara niqoori saunu arafi innaaru qiaqa. Sia misa innaaru qimariandee iaqa. Innee misa unna anutusa turi taari maseeqa ooni rakiaaqee minara innaaru qimariana raudaandammeeqee aqusaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Innee qini Yaaweesa inneeqa Anutusa qimooqifaqa qinee narana faqa nammari faqa inni nimiseeqa inni auriranauqa mara aqunnisaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Innee Yaaweena kai amooqifaqa sia aanaaseeuqa eedada faiqi maqee faranoo. Sia moo aafa anaasee mariannoo. Innee sia dauni kuqifara, kisaaqasaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Qinee inni nifiqee fidaqa inni namuqaa qiniara rufiarana nimiseeqa inni faqa rakinausa furufarirana nimianaura. Nimiseeqa qianaqa inni namuqaauqa quqasee sandeefara. ");
INSERT INTO bjr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Qinee ukaqa nimimari doodaanina inni namuqaaki quqasaana ukaqa niminaqa naaqoo nifu furufarinaqa sandee faranoo. Innee fimarifaqa qinee Hifita maqannaasa faqa Kannaana maqannaasa faqa Heeta maqannaasa faqa nifaqasaanaqa innee miqoo oonu marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Qinee sia moodaa aukuanaki inni namuqaa rapatutumma aquanaura. Qinee miqimma saananoo naakunduka mafinaqa kaasau aandauqa moomoo mi maqa maaqanaki maridaqa inni narifoora. ");
INSERT INTO bjr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Qinee misara qianaqa misa moodaa kai qaara kai idaqa taikafifaqa innee moomoo kammafi amana mi maqa maaqana maree faranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Qinee inni oosu maaqimasee oosumma nisaanaura. Dinni taatuqee nammari mariannoo. Dinni Firistia ooruku nammari mariannoo, dinni aadana maqa maaqa mariannoo, dinni Eeufarateesa nammari mariannoo. Qinee inni afeeka nimianaqa innee mi maqa maaqanaki fimarifaqa qinee inni namuqaa rapatutu iqa fimarianaqa innee misa maqa maaqa mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Innee sia uqanna misa ufara eedoo qimasee moodaanaki kira ufa qiaqa. Misa unna anutusara faqa sia uqanna moodaanaki kiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mi maqannaasa sia inni maqa maaqaki mariaqa. Innee miqifaqa misa inni mareeqee qini numookamma qimaqara tinai quqeefaranoo. Innee misa unna anutusa nimooqifanoo mifa inni ninuka ufanara foora fufinoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Anutufa aiqama ufauqa Mooseena qimamiseenoo kafaa maaqi qinau. Moosee anee faqa Aaroona faqa Nadabana faqa Abiquna faqa Isaraee maqannaa rakisirausa 70 uriqararausa faqa nifiqa maree urureeqa nianasaa kummaramafinaqa qiniara innaaru qidaqa qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moosee anee kai adeedi ania. Sia akaqa rakisirausa qini daaqa aniaqa. Faiqí anaasee faqa sia uqanna aaqanai uruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mooseefa ooqureenoo faiqí anaasee Yaaweena sandufa aiqama qimannimisoofaqa misa maaqi qimasee moodaa kari noo raqamaree qiqau. Yaaweefa qindee iqa maasa aiqama ainaina auqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Miqi qimasoofanoo Mooseefa Yaaweena sandaufa aiqama akara rinau. Akara rumaseenoo kananaana iaqoofanoo aaqana aikunni aandau tutufira qainda auqinau. Auquseenoo ooni qisaukuqara taikasee qikunni ooqu qaara marasee 12 ooni maraseenoo qainda fiqu fiqumma Isaraeena faiqi namu nimana kai rakiqanau. ");
INSERT INTO bjr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Rakiqaseenoo kumaaraauqa qimannimufaqa burimakau arusee munu Anutuna tatufirana suqaqau. Mi tatufira aandauna Isaraee maqannaasa faqa Anutuna faqa moodaanaki suqira tatufiranee qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Misa arusoofanoo Mooseefa burimakau fidika akaqana difaanikiaqa sakaseenoo kaqi maruna qumarenoo aidarai rurufinau. ");
INSERT INTO bjr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Rurufa maseenoo Akiiseenoo Mooseefa Anutufa moodaanaki kira ufa qimaqoo bukana akara rumaqoona maree findifinoo aiqama minakinaa ufa asaana rumasee firaaqoo faiqí anaasee qimanniminau. Misa iriseeqa qiqau. Maasa Yaaweena mi sandaufana aiqama irisee afaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mooseefa misa ufa iriseenoo difaanikinaa fidika kaqi maruna indaku faiqí anaasee kiaqa aqidanoo qinau. Anutufa maa sanda ufausa nimuqooqari maa fidikafa Anutufa inni faqa moodaanaki kuna afeekaikamma nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Miqi qimaseenoo Mooseefa Aaroona faqa Nadabana faqa Abiqufana faqa Isaraee maqanaa uriqararausa 70 faqa nifiqeenoo aaqanasaa oorufinau. ");
INSERT INTO bjr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Oorureeqa miqoo misa Isaraee maqannaa Anutuna qafaqau. Mina aiku ameemaanai innaaruna kudimandara foora ira ooniuqa mina auqu safiree fee qimaru oonisa ausirirafauqa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Misa Anutuna qafoofanoo sia misa narinau. Misa miqoo moodaanaki suqufu faqa narana nammari naqau. ");
INSERT INTO bjr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Misa namasoofanoo Anutufa Mooseena qimaminau. Anee aaqanai qinee marunnannai urua. Ururainaqa qinee qeeqa sandufa anee faiqí anaasee naakapaanneera qaara oonisaa akara ruma amianaura. ");
INSERT INTO bjr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mooseefa mina iriseenoo narí dadaaqimaruna Yoosuaana faqa deedaqamma seeqa Mooseefa aaqanai Yaaweefa marunnai ooru finau. ");
INSERT INTO bjr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ooru fidanoo Mooseefa Isaraee maqannaa uriqararausa maaqi qimasee qimanniminau. Innee maaqoo uiqaana maqusaki maridaqa maaqanda qifeesiaqa. Aaroonafa faqa Hurafa faqa inni faqa maaqoo marifaranoo. Akaqausaki ufa rainarafa kambiqainaqa miqanda andeeqa nimaqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Miqi qimasee qimannimiseenoo Mooseefa aaqanai oorufufanoo qasuru fannoo aaqana rafaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yaaweefa kaaqa qarafa aaqana aaqa qumuroonara Sinai aaqana saa qasuru quminau. Isaraee maqannaasa mi kaaqa qaranna qafoofanoo aaqanasaa firaa ida qeera foora qimarinau. Dinni ani moodaa marasee 6 faasaanna qasuru fannoo aaqana rafaaqa finoo marinau. Dinni ani qaara qanda marasee 7 faasaanna Yaaweefa qasurukiqari Mooseenara mai uruannee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Faiqí anaasee afaasasaa marusa aaqana qafeeqa naaquqara kudifaannammiifoo qiqau. Anutuna kaaqa qarafa aaqana saa firaaqoo idauruara foora imarinau. ");
INSERT INTO bjr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mooseefa aaqanai ooru fidanoo qasuruki keeqakufanoo aaqanasa ooru qaara fasiqa niku nisauku taikasee 40 eendaki faqa faasaana faqa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mi aaqannanasaa Yaaweefa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Anee Isaraee maqannaasa qimanniminaqa misa oosana oosana ainaina qini qimiani qinnana qimiaqa. Faiqí anaasee qini qimirara nidinaqa minisainna ainaina anee mara quqaa. ");
INSERT INTO bjr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","5","Maa ainainausa maree anifaranoo. Koora faqa siruaa faqa booroosa faqa amiqira qamunna faqa dirindaasi akira sipsipa asausi faqa pannoona akira sipsipa asausi faqa faeena akira sipsipa asausi faqa mimmi asausinnai auqira qamunna faqa sipsipa akoona apatasaa faeena akirana faqa ooruku nammariki mari firaa noodaana apata faqa akasia saqari amiqira saqari faqa maree minisaifana mara quqaa. ");
INSERT INTO bjr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Qooma qumbi maria fadameenna faqa aanaiqikirausa aki maria oosana oosana fadameenna faqa moo pauraqa ida arasaafanoo muninoo amiqira afundi mari pauraqana faqa mini amiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Firaa feefauru aqi maria oonisa faqa aka amiqira ooniuqa faqa aanaiqikirausa eefooda qamunnasaa faqa nimuqusasaa rumbee marianasaa faqa atooqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Isaraee maqannaasa qimanniminaqa qini naaquqara uiqaana maqa usakasaifaqa qinee misa qambaanai marianaura. ");
INSERT INTO bjr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Innee uiqaana maqa faqa minakinaa aiqama ainaina faqa qinee naakapaunandee miqi kai masee auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Innee akasia saqari marasee minannai moodaanaki kira bookisa auquaqa. Mina kisaaqa 110 centimetres amana auquaqa. Mina qusandanai faqa mina kuradarafa faqa amana amana kai 66 centimetres amana auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Innee amiqira koora marasee turimmasai ausi rumafinaqa minannai kai bookisa adisaa faqa aundurai faqa ititaaqa. Mi bookisana afaimau koorannai amatookika masee rafaaqafuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Innee koorannai qaindusi fandinnana amaaqa qaara faqa qaara faqa 4 auqusee aiqama aikusaa quqaaqa. Dinni aikusaa qaara qanda dinni aikusaa qaara qanda quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Akasia saqari qaindusi fandinna qanda koora turimandee ausiruma qumaree minannai kukuqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kukuqa maseeqa dinni dinni amaaqa auquqainnanaki ausuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Miqimmaseeqa sia radukuaqa, saifanoo miqinoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Miqimma saifaqa kasooaqee qaara oonisaa qeeqa sanda ufa akara ruma nimianaqa minaki quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Bukisa afu faqa Koorannai kai auquaqa. Mina kisaaqa 110 centimetres amana mariani. Mina qusa 66 centimetres amana mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Innee kooraa turimmaseeqa bukisa afu auquseeqa minannai kai dinni dinni qangiroo qaara qanda nimana auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Afu dinni atinni moo qangiroo amana auqusee dinni moo qangiroo amana auquaqa. Afu faqa mi qangiroo qanda nimana faqa moodaa koorannai kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Mi qangiroo qanda bukisa afusaa quqasaifaqa noori narí qafee narí qafee iaqa. Miqanda niqoosa uqeerasaifanoo bookisa afusaa ititanoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Qaara oonisaa sanda ufa marina mi bukisanaki quqasee afu rafaaqafuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Qinee inni faqa miqoo moodaanakika mafiqa bukisa afusaa qaara qangiroo qambaana maridaqa qeeqa sanda ufa inni Isaraee maqannaasa nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Innee akasia saqarinnoo teeboora auqauqa. Mina kisaaqa 88 centimetres mariani. Mina qusandanai 44 centimetres mina kuradarafa 66 centimetres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Innee amiqira koora marasee turimmasaifanoo ausiruma finaqa minannai teeboora rafaaqa fusee kafaa moonnai teeboora atiqara fiqu fiqumma rafaaqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Innee teeboora atiqara fiqu fiqumma 8 centimetres amana ititasee mina afaimau koorannai rafaaqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Innee koorannai qaindusifandinnana amaaqa 4 auqusee teeboora aiqama aiku namusaa quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Teeboora afai ameemaanandanai qaindusirana amaaqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Qaindusifandinna saqari qanda akasia saqari ateekasee koorannai mina kuku iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Amiqira koorannai kai teeboorasaa quqeefandinna pirita kaafausa faqa kisaaqa kaafauqa faqa uainna adiara pirita uqnaurirana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Qini qimifandinna bereetana mi teebooranasaa quqaqaifanoo aiqama kari qini moodaanaki kira bukisa aaqa mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Innee qooma qumbifandinna aikana amiqira koorannai auqua. Innee koora turiiseeqa minannai kai qooma aika oosana faqa adaka faqa asaanauqa faqa auquaqa. Mi asaanausa saa mi kooranannai kai taatuqee aqama afufeenaari marindee maseeqa auqusaifanoo kaafara foora afisu amaqanoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Mi qooma aikausa qisauku dinni taikasee dinni ani moodaa marasee 6 mariani. Dinni qaaramoo dinni qaaramoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Aiqama mi asaana namuna atimau koorannai taatuqee aqama afufeenaari marindee masee afaaqa auquaqa. Mi afufeenaarirafa teeqnoorina aqamara foora marufaqa mi asaana namuna saa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Mina adakasaa qaara faqa qaara faqa 4 saa taatuqee aqama teeqnoorina aqamara foora auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Moodaa aqama indaaruqaa asaana qara ameemaanai mariani. Kafaa mina murufi asaana qara ameemaanai moo aqama mariani. Kafaa mina murufi asaana qara ameemaanai moo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Amiqira koora turiiseeqa minannai kai oosana faqa asaanauqa faqa afufeenaarirana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Miqimmaseenana dinni taikasee dinni ani qaara qanda marasee 7 qooma auqusee mi asaanausa ati mau quqaa. Quqaseenana mara quandasainanoo mi qoomausa kaaqa qarafa sia kaqinni fuani. Maaqa aundurai kai kaaqa qaani. ");
INSERT INTO bjr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mina ufaqa faqa futufita faqa amiqira koorannai kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Qooma quqara aika amiqira koorannai 35 kilogram ummaara amana kai marasee auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Moosee qinee aaqanasaa ani qimamunandee aiqama ainaina miqikaimmasee andeeqasee auqua. ");
INSERT INTO bjr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Innee qini naaquqara uiqaana maqasaa akifandinna qamunna kisaaqa maaqimasee auquaqa. Sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa sufusee amiqira qamunna auqusee aqoosa faqaa aandau amana auqusee minasaa atooqasee akuniaqa. Miqimmasee minauqannai innee qisaukuqara taikasee 10 firaa qamunna auqusee moodaanaki akuniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Mi aiqama qamunnausa amana amana kai 12 metre kisaaqa mina qusa 2 metre mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mi qamunnausa moodaannai qisauku 5 marasee moodaanaki ootupamasee akuniaqa. Dinni qisauku taikasee 5 faqa miqi kai iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Miqimmaseeqa mi qamunna qanda atiqara dirindaasi arira qamunnannai anaanu auqusee moodaanaki ootupaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Firaa qamunna atimau anaanu 50 auquaqa. Moo qamunna faqa miqi kai iqa moo qamunna saaqaraa aanaanu amummaqa kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Koora qumaree turimandee qusa tafara foora saaeemma qumaree dinni dinni anaanuki upeekasaifanoo mi qamunna qanda moodaara maqi inoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Uiqaana maqa saa akira qamunna firaana mimmi asausinnai 11 auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Innee aiqama moodaa karirana kai auquaqa. Mina kisaaqa 13 metres amana mariani. Mina qusa fannoo 2 metres amana mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Mi qamunnausa moodaannai qisauku taikasee 5 qamunna akunusainanoo moodaa qamunnaika mafuani. Kafaa moodaannai qisauku taikasee dinni ani moodaa marasee 6 narisaa narisaa akuniisaifanoo firaafaikiani. Miqimma finaqa uiqaana maqa kooqindaraana murufi tukaanda quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Qamunna atimau anaanu 50 akuniaqa. Moo atimau faqa mina amummaqa kai akuniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Booroosannai tafara foora ati saaeemmasee 50 auqusee minannoo dinni dinni anaanuki aususee ootupama saifanoo moodaa qamunnara foora mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mi firaa qamunnana uiqaana maaqa akuamaqa saifanoo mina ati fiqaramasee akunirafa uruanatinai naambeeqai qumiqaranoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Aabaa akunira qamunna fannoo uiqaana maqa ati fiqaree aiqaree inoo mariani. Dinni dinni amana amana kai 50 centimetre kai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Mina taikasee mina amuaaqa qaara qanda faqa auquaqa. Moo sipsipa akoona apata faeena akiranannai auquaqa. Auquseeqa moo ooruku nammarikinaa aandau kuara fooqaa irana apatannai auquseeqa minannoo meeraqoo amuaaqa akuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Innee akasia saqarinnai kai naaquqara uiqaana maqa atuna auqusee kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Maaqi mandee maaqa atuna auquaqa. Saqari dinni dinni kuradarafa 4 metres mariani. Mina ausana qusa 66 centimetres amana kai auni ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Aiqama atuna maqaki rakiqaranara irisee ati ooqiqara masee ateekaaqa. Aiqama maaqa atuna miqi kai masee ateekaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Innee suani afu ataaqeenni south kisaaqandanai maaqa atuna 20 narisaa narisaa apamandee kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Maaqa atuna oosana sia maqaki kaqi rakiaaqa. Siruaannai amaaqa auqusee minaki maaqa atuna kuradaaqa. Siruaannai 40 maaqa atuna oosana amaaqa auqusee minaki kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Uiqaana maqa suani dinni ataaqeenni north kisaaqandanai maaqa atuna 20 narisaa narisaa apamandee kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Maaqa atuna sia maqaki kaqi rakiaaqa. Siruaannai 40 amaaqa auqusee minaki maaqa atuna kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Suani keeqee mari qaannai (west) uiqaana maaqa uruanatinai maaqa atuna dinni qisauku taikasee dinni ani moodaa marasee 6 narisaa narisaa apamandee auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Maaqa dinni dinni munu raqaranaki kafaa qaaraqanda auqusee kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Raudaranaki maaqa atuna oosanaki apammasee kuradama saifanoo amiqimasee narisaa narisaa apinoo mariani. Maaqa atuna rakiqarana oosanaki rumba atukarasee miqi kai mamaree mirinni murufisaaqa. Dinni dinni munu raqaranaki miqi kaimmiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Miqimmaseeqa maaqa atuna 8 oosanaki siruaannai qaaraqanda qaaraqanda amaaqa auqusaifanoo 16 mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Innee qauniri fandinnana akasia saqari 15 maraaqa. Uiqaana maqa ataaqee dinni dinni faqa uruanai faqa faifa faifannoo auni rumasaifanoo maaqa atukarama qumaraani. ");
INSERT INTO bjr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mi maaqa atunna qambaana aunirira saqari fannoo maaqa amana kai dinni dinni ati mariani. ");
INSERT INTO bjr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Maaqa atuna aiqama koorannai kai rafaaqa fuaqa. Maaqa atuna mau aiqama koorannai kai anaanu mamaree fuaqa. Aunirifandinna saqarisa faqa koorannoo rafaaqafusee mi anaanusaki ausuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Doo Moosee qini uiqaana maqa aaqanasaa qinee qimamiafanandee masee usakaa. ");
INSERT INTO bjr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Innee sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa sufusee minannai amiqira qamunna auquaqa. Miqimmasee mi qamunnana saa qangiroo qaqoosa faqaana amana auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Akasia saqari qaara faqa qaara faqa 4 marasee koorannai aiqama rafaaqa fusee mina atisaa mirinni qamunna dirifandinna amaaqa auquaqa. Miqimmasee mina kuradee fandinnana amaaqa 4 oosanaki siruaannai auqusee minaki kuradaaqa. Kaaqa naaquqara oosirana ititaanifeera kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Miqimmaseeqa mi qamunnana amaaqa auquqaanasaa dirisaifanoo amaaqa auqirana ameemaanai qamunna ati ooreeqanoo mariani. Miqimmasaifanoo mi qamunnana ititarafa ataufaka ameemaanai ooreeqanoo mariani. Mi qamunnafa ititaranaki moodaanaki kira bukisaki qaara oonisaa sandufa marina quqaaqa. Mi qamunnafa naaquqara oosirana faqa kaaqa naaquqara oosirana faqa rainaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Moodaanaki kira bukisa kaaqa naaquqara oosiranaki quqasee koorannai mina afu auqusee rafaaqa fuaqa, nifauara afu minasaa rafaaqa fuaqa. Dirira qamunna fannoo raina nimaqaidanoo kooqi kinaa oosiranara naaquqara maqa fee qimasee kukeeqara oosiranara uriqaramasee naaquqara maqa fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Teeboora mareeqee naaquqara oosirana maaqoo oonumafi kooqiki suani afu dinni ataaqee qaannai (north) mafi quqaaqa. Qooma saqari suani afu dinni ataaqee qaannai (south) mafi quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Uiqaana maqa kooqiki ititee fandinna qamunnana sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akiranannai faqa marasee auquaqa. Oosana oosana sandannai mooka maakira ainainauqa mi qamunnanasaa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Mi qamunnana dirifandinnana moodaannai qisauku 5 akasia saqari marasee koorannai mina atimau rafaaqafusee qamunna dirifandinnana anaanu auqusee quqaaqa. Miqimmasee booroosannai moodaannai qisauku 5 atuna oosana amaaqa auqusee minaki kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Innee akasia saqari marasee minannoo tatufirana suqara qainda auquaqa. Mina kisaaqandanai faqa qusandanai faqa amana amana kai mariani 2.2 metres. Maqasaaqari urirafa qaara faqa qaara faqa aiku 4 amana 1.3 metres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mina qaara faqa qaara faqa atisaa aanaira foora auqinoo mariani. Tatufira qainda moodaa saqari fannoo kai atimau faqa qambaanai faqa aanai faqa moodaa saqarinnai kai auqusaifanoo mariani. Mi aiqama ainainausa booroosannai rafaaqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mi tatufirana suqeemaria qaindanasaa suqee maria ainainausa booroosannai kai auquaqa. Fadameena dandaki aqufinnana afaqee maria futufitausa faqa savoorauqa faqa uqnaurira piritauqa faqa tafa fooqaa irana ati saaee irana faqa ida auni afaqee maria futufitausa faqa aiqama booroosannai kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Innee fukaa asaana booroosannai auqusee booroosannai kai aanaanu faqa auqusee qaara faqa qaara faqa atinni quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mi fukaa asaanafa tatufira bukisa aundurai kasaaqai ooqeeqanoo qambaanai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Akasia saqari tatufira qainda qaindusi fandinnana qaaraqanda maraseeqa booroosannai miqanda rafaaqafuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mi qaindana maree fuaqee qifaqa kai mi saqari qanda dinni dinni anaanuki aususaifaqa maree fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tatufira qainda indooira saqarinnai kai aundura faqaana auquaqa. Qinee aaqanasaa ani uqafiqaa fanandee masee auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Innee amiqira sanda sufusee auquqaa qamunnanannoo uiqaana maqasaa ququsara foora auqu ititaaqa. Suani afu dinni ataaqeenni South mina kisaaqa 44 metres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mi qamunnana dirifandinnana booroosannai dapu 20 auqusee mina kuradee fandinnana amaaqa miqi kai masee 20 auqusee siruaannai tafara foora mina amana kai auqusee auniri fandinna saqarina faqa minannai kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Suani afu dinni ataaqeenni iandee kai iqa dinni ataaqeenni faqa miqi kai iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Suani keeqee mari qaannai dapu qusandanai 22 metres mariani. Mina dapu saqari 10 faqa mina amaaqa auqirafa faqa 10 kai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kafaa suani oosana qaannai kooqi maru tinai faqa uruanai inoo marina amana kai 22 metres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Suani oosana qaannai East kooqi mariani. Mi kooqina dinni dinni diri fandinna qamunnafa 6.6 metres mariani. Mi kooqina dinni dinni qaarammoo dapu faqa mina amaaqa faqa dinni dinni qaarammoo kai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kooqiki dirira qamunna 9 metres kisaaqa amiqira sipasipa asausi dirindaasianda faqa pannoonanda faqa faeenanda faqa marasee mi qamunnanasaa oosana oosana amiqira akara ruaqa. Mi qamunnana quqee fandinna saqarina qaara faqa qaara faqa 4 mariani. Mina rakiqee fandinnana qaara faqa qaara faqa ki mina amaaqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Aiqama dapu fiqu fiqu qirafa siruaannai rafaaqa fuqaa saqarinasaa ootupanoo mariani. Minasaa qamunna diri fandinnana tafara maqi iranauqa siruaannai auquaqa. Mi saqarisa rakiqee fandinnana amaaqauqa booroosannai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ququsa afuqai kisaaqa kamu 44 metres mariani. Mina qusa kamu 22 metres mariani. Ququsasaa dirira qamunna mina oorufirafa 2.2 metres maqasaaqari oorufuannoo. Mi qamunnana amiqira qamunna kaqikaa sandannai sufirafa afeeka mariani. Mina dapu oosanaki booroosannai amaaqa auqirafa maqaki mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Uiqaana maqaki oosana oosana ainainira ainainauqa aiqama booroosannai auqirafauqa kai mariani. Uiqaana maqa ati mau apupuka arifandinna aikausa booroosannai kai auquaqa. Uiqaana maqa dapu rakiqarana qumaraanifee qimasee apupuka aqoosai faqa afuqai faqa arifandinafa aiqama booroosannai auqira apupuka kai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Moosee anee Isaraee maqannaasa qimanniminaqa oorifa saqari qaqamakinaa fadameena amiqirana kai minisaifana aiqama eendirana minannoo qooma qumbia. ");
INSERT INTO bjr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaroonafa narí faiqi namu faqa qini Anutusa naaquqara uiqaana maqaki moodaanaki kira bukisa ititee maria qamunna naaquqara oosiranaki qoomauqa quqaaqa. Miqoo qini qifusaa eendi marinaqa qumbisaifanoo qamammareenoo iaqarana kai raquru amiani. Maa naamuaqira ufana Isaraee maqannaasa faqa misasaa ani arua kinausa faqa naaru naaru afaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Yaaweefa kaifaa Mooseena qimaminoo qinau. Anee aneenna afasaana faqa mina faiqi namu Nadabana faqa Abiuna faqa Eeriasana faqa naara masee Itammarana faqa Isaraee maqannaasa kinaana raina naaduma quqasainaqa qini aanaiqi kira saika maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Aneenna afasaana Aaroona misakina uriqarara aanaiqikira qamunna auqu amia. Miqimmasainanoo mi qamunnafa amiqirana faqa uriqararausee qirana faqa amiani. ");
INSERT INTO bjr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Moosee anee Aaroona qamunna akunifandinna fasiqausa irirana fiqararausa qinee irirana nimiqaunausa misa kai suqusee qimanniminaqa mina qamunna akuniaqa. Akunusaifanoo mina afisusee miqooqari qini aanaiqikira saika maraani. ");
INSERT INTO bjr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Anee qimanniminaqa nimuqusasaa rufi maria ainainna faqa eefooda qamunna faqa kisaaqa qamunna aikusaa faqa ititeemari qamunnana faqa akara faqaa siuta faqa akiiqa rafaaqa fimari qamunna faqa aranandauqanna rumbarana faqa minamuna auquaqa. Misa miqimmaseeqa uriqarara aanaiqikira qamuna ani afasaana faqa mina faiqi namu faqa auqu nimisaifaqa misa qini aanaiqi kira saika maraaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Akunirana akoofasauqaindi sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa koora tiritanda faqa amiqira tiritanda faqa mi ainainausannai aanaiqikirausa qamunna auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Misa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa koora tiritanda faqa amiqira tiritanda faqa aiqama mi ainainausannai eefooda qamunna auquseeqa minasaa oosana oosana akara ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Eefooda qamunna anaanu qaaraqanda aururusaa aakandianinnana auqusee eefooda qamunnasaa dinni dinni rumbaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mina ooiqanda ianinnana amiqira qamunnannai eefooda qamunna auquandee kai masee auquaqa. Mifa eefooda qamunnasaa akunirafa mariani. ");
INSERT INTO bjr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Eefooda anaanusaa akumaaqa ooni qaaraqanda pupuooni marasee dinni anaanusaa moo dinni anaanusaa moo quqasee Yakooboona faiqi namu qisauku qara taikasee qikunni ooqu qaara marasee nuqu mi ooni qandasaa akara ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Dinni pupu oonisaa dinni taikasee dinni ani moodaa marasee 6 nuqu akara ruani, dinni pupu oonisaa miqikai mandee 6 akara ruani. Aiqama narí kambiqoona amana kai nuqu akara ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Oonisaa akara rirana akoofasa marina afiqasaifanoo mifa qaara oonisaa Yakooboona faiqi namu nuqu akara ruani. Akara rumaseeenoo mi ooni qanda koora qambaana quqasainanoo atukaranoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Miqimmasee aururusaa eefooda qamunna aakandammasainanoo Yakooboona faiqi namu qisauku qaara taikasee qikunni ooqu qaara marasee 12 Isaraee maqannaasa kikiqusinoo mariani. Miqimasaifanoo Aaroonafa misa nuqu narí aururusaa maranoo nimarinaqa qinee Yaaweesa qeeqa faiqí aanaaseera aiqama kari irianaura. ");
INSERT INTO bjr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Aururusaa qaara ooni atukaramma qumaree mari kooranasaa qaara qanda amiqira koora sainanda sufirana moo ati moo oonisaa moo ati moo oonisaa ootupaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Innee nimuqusa saa rufi mariana aanaiqikirausa auqu nimisaifaqa minannoo misa Anutuna iriranara aidiranara irifaranoo. Eefooda qamunna auqu ainainausannoo kai auquseeqa moodaa karira akara kai ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Qambaana tukaandasaifanoo aiqama ati amana amana kai 22 centimetres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Innee ooni amiqirana firaa feefauru aqi mariana kai marasee qaara faqa qaara faqaki mi qamunnanasaa padiaqa. Indaaruqaa padiranaki moo ooni auqu rubi faqa moo ooni toopasa faqa moo ooni ganeeta faqa minamuna padiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mina aanaaqiannaa padiranaki moo ooni auqu eemeerara faqa moo ooni safairee faqa moo ooni daimanna faqa minamunannai padiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mina aanaaqiannaa padiranaki moo ooni auqu teerakoosa faqa moo ooni agatee faqa moo ooni auqu ameetisa faqa minamunannai padiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mina aanaaqianaa padiranaki moo ooni auqu beerira faqa moo ooni kanirianna faqa moo ooni yasapaa faqa minamunannai padiaqa. Mi oonisa koorandannai amuqusa saa ititanoo mari qamunnanasaa isooqa araaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Mi oonisa moodaa moodaa ooni fannoo Yakooboona faiqi namu qisauku qara taikasee qikunni ooqu qaara marasee 12 Isaraee maqannaasa kikiqa usinoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Innee nimuqusasaa rufirana anaanu amiqira koorannai auqira sanda seenandara foora auquseeqa afundasee dinni dinni atisaa qusuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Koorannai anaanu qaaraqanda auqusee amuqusa saa rufinna qamunnana mirinni atisaaqara qusuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Qaara qanda seennanda koorannoo afundaranannai mi anaanu qandaki qusuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mi sandana ati qarannai aururusaa koorandannai ooni isooqa aruqaanaki ootupaaqa. Miqimmasaifanoo aururusaa eefooda qamunnasaa rumbaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kafaa nimuqusa saa rufi mariana anaanu qaara qanda koorannai auqusee aunduraindari ati saa mi anaanuna rumbasaifanoo eefooda qamunna mammaaqai mariani. ");
INSERT INTO bjr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kafaa qaaraqanda aanaanu koorannai auquseee afunni qumu mari eefooda qamunnana saa aqaasanai amiqira qamunnannai sufirana ooi qandianinnana aaqa rumbaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Nimuqusa saa diri maria qamunnana saa anaanuki dirindaasiandannai sufira sanda qusuaki eefooda qamunna saaqaraa aanaanuki qususee rumbaaqa. Miqimasaifanoo amuqusa saa ititara qamunna sia kasi kasiani. ");
INSERT INTO bjr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aaroonafa naaquqara maaqaki keeqafinoo mi qamunnana Isaraee maqannaasa nuqu akara rirana afisusainaqa qinee Yaaweesa aiqama kari qeeqa faiqí aanaaseera irianauranoo. ");
INSERT INTO bjr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Amuqusaa ititara qamunna raqandaamasee uqara foora akunusai mariani. Mi uqanaki ooni qaaraqanda miqanda nuqu Urimma faqa Tumimma faqa Aaroonafa mi uqanaki uqarumasee qini uiqaana maqaki aniani. Miqiraree qimaseenoo aiqama kari nimuqusa saa diri maria qamunnana rufu maree anireenoo mifa qini irirana iriseenoo Isaraee maqannaasa qimannimiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Innee eefooda qamunna meeaqoo qaraana auqirara dirindaasi akira sipsipa asausinnai kai auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Anuka amaaqa auquaqa. Qamunna raqandaammasee akunusaifanoo anuka upeekaina sia anaqiani. ");
INSERT INTO bjr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Mina atimau raqandaammasee akunuseeqa saqari aqama faqa kaqikaa biru koorannai auqirana faqa mina atimau qusuaqa. Dirindaasi akira sipsipa asausinnai faqa pannoona akiranannai faqa faeena akiranannai faqa mi saqri aqamana amana auquaqa. Auquseeqa mi saqari aqamana faqa koorannai auqira biru faqa qamunna atimau moo mafi quqee moo mafi quqee iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaroonafa aanaiqikira saika auqararee qimasee mi qamunnana afisuani. Mifa naaquqara maaqaki qinee umee marunnana qifusaa aninanoo fee quqasee finanoo fee mi birusa narisaa narisaa ariqa ufa qifanoo Aaroonafa sia kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Innee amiqira koora marasee aqiniandirana auqusee mina saa akara rumaasee Yaaweena ainainira faiqi fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Akiiqa aanaamu qusirana aqini saa quqasee dirindaasiandannoo rumbaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaroonafa mina aqinaaqa rumbasainaqa qinee Yaaweesa aiqama Isaraee maqannaasa aaduma qini qimiraree qinna ainainausara eedoo qimasee maraanaura. Misa akaqa aaqarana auqamasee qimifaqa qinee Aaroona mi aqiniandiranara irisee sia minni saanaura. Kaqi maraanaura. ");
INSERT INTO bjr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Innee amiqira sanda sufuseeqa Aaroona siuta auqusee mina akiiqa aanaamu faqa auqusee minannoo kai aranandauqa rumbarana faqa auquseeqa minasaa oosana oosana akarannoo afaaqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aaroona faiqi namu siutauqa faqa niranandauqanna rumbee mariana faqa nikiiqa aanaamu faqa kaaqa amiqiranauqa auqu nimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Moosee anee maa qamunnausa mara maree aneenna afasaana Aaroona narí faiqi namu faqa afisu nimaqaa. Oorifa fadameena misa nikiiqa amoondunna adia nimaqasee naaduma mara quqasee mi saikana nimia. Miqimmasainaqa misa qini aanaiqikira saika maraaqa. ");
INSERT INTO bjr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Innee qusa karausisa nooiqakiqari nifundana saa ooqeeqarana auqu nimiaqa. Miqimmasaifaqa misa sia nári nifaaqa kooroo iaqeera. ");
INSERT INTO bjr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroonafa narí faiqi namu faqa qinee umee marunnanaki qini uiqaana maqaki keeqafinoo qini qaindasaa naaquqara qoo aanaiqikira ainaina auqararee qimasee aiqama kari mi karausisana afisuaqa. Miqiqa sia nári nifaaqa kooroo iqa sia kuqifaranoo. Maa ufafa Aaroona faqa mina saa ani aruakinausa saa faqa naaruara mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Maaqimmasee Aaroona faqa mina faiqi namu faqa naaduma mara quqasaifaqa qini saikaki aanaiqikirausa mariaqa. Innee burimakau akoona timmusa faqa sipsipa akoona qaaraqanda dinee teeroo siaina kai maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Amiqira parauaqa qaindirirana innooqee mari pauraqana sia aqirana oorifa fadameenannai suqaaqa. Akaqana sia oorifa fadameennannai suqaaqa. Akaqana ausirira feemu auqusee oorifa fadameena akusee suqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Mi ainainausa nafisaa amanee uqa fooqaa iranaki rumaseeqa innee burimakau akoonannoo faqa sipsipa akoona qaara qandannoo qini tatufirana suqa qimiraree qimasee mi ainainausa namufaqa qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Moosee anee Aaroona narí faiqi namu faqa nifiqamaree qinee umee marunna uiqaana maqa kooqiki minisee qimanniminaqa amiqimmasee nammari auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Miqimmasaifana anee uriqarara aanaiqikira qamunna Aaroona afisuamaqaa. Siuta faqa kisaaqa qamunna aiku ataa dukunirana faqa eefooda qamunna meeaqoo afisirana faqa mina amuaaqa eefooda faqa nimuqusa saa rufi maria qamunnana faqa nooiqandi mariana faqa aiqama mi ainainausannoo afisu amaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Nikiiqa aanaamu afisu amaqasee naaquqara kooroo ira fee qimasee rumbaa. Maaqi qimasee minasaa akara ruaqa. Yaaweena saikaki marifee qimasee akara ruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Rumba amaqasee Yaaweenaindi fee qimasee utaaqama amaqara fadameena akiiaaqa adiaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Anee Aaroona faiqi namu nifiqa quqasaina mi siutausa afisuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Niranandauqanna rumbee mariana rumbasee nikiiqa aanaamu faqa afisu nimaqaaqa. Miqimmaseeqa Aaroona faqa mina faiqi namu faqa mi saikana nimia. Misa faqa misa saa aniaruakinausa qini aanaiqikira saikaki naaru naaru marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Moosee anee Aaroona narí faiqi namu faqa qamunna afisu nimaqasainaqa burimakau akoona timmusa mara qinee umee marunna uiqaana maaqana kooqinni minisaifana Aaroona narí faiqi namu faqa qimanniminaqa mina akiiqasaa nisauku quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Miniseeqa mi burimakau akoonnana qinee umee marunna naaquqara uiqaana maqana kooqiki aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Aruseeqa mina fidika marasee aneenna asauku amukasaa raaraammasee qaidara qaara faqa qaara faqa atisaa aanai fooqaa iranasaa akua. Miqimmasee akaqa fidika kaqi marinauqa mara maree qaidara qainda oosanaki adiaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Miqimmasee kafaa aradanda saaqaraa ainoo aiqama maraaqa. Mina annaama faqa mina atakisa qara faqa ainoo minasaa marina faqa amaandamoona saaqaraa karoo karoona faqa marasee tatufira qaindasaa quqasee suqa qimia. ");
INSERT INTO bjr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Burimakau akoona amaqi faqa apata faqa arada faqa inneeqa naambeeqai aqoosai ida arasaifanoo qaani. Mifa aanaiqikirausa numoo maraqu niseenoo taika nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Sipsipa akoona moodaa marasee Aaroona faqa mina faiqi namu faqa qimanniminaqa nisauku mina akiiqa saa quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Miqimmasaifana mina arusee mina fidika marasee qaidara qaara faqa qaara faqa atinni mi fidikana adiaa. ");
INSERT INTO bjr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Miqimmasee mi sipsipa akoonnana kaqikaana kaqikaana auku quqasee mina aunduraindaraa ainaina faqa aikuqara faqa nammari uqusee minauqa mareeqee mi sipsipana akiiaaqa akaqa aukiranauqa namufaqa quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Mi sipsipa akoonna aiqama afaaqa qaidarai quqasee qini tatufiranara foora ida araaqa. Mina afundara qinee asasianaura. ");
INSERT INTO bjr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Mina ida arasee sipsipa akoona moo aanaiqikira saikaki quqee mariana mara minisainanoo Aaroonafa narí faiqi namu faqa mina akiiqasaa nisauku quqaaqa. Quqasaafana arua. ");
INSERT INTO bjr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Aruseenana mina fidika afeeriqiseenana Aaroona narí faiqi namu faqa nisauku uqannai naaqoosaa akusee nisauku uqannai nisauku akoonnanasaa akusee, nisauku uqannai niku akoonnana saa faqa akua. Akusee fidika kaqi marina qumaree qaidara qaara faqa qaara faqa atinni adia aquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Qaindasaaqaraa fidika akaqana qumaree nikiiqaki aki maria fadameena namu faqa marasee Aaroona narí faiqi namu faqa nifaaqai faqa qamunnasaa faqa rurufida akunnimaqaaqa. Miqi masaifaqa Aaroonafa narí faiqi namu faqa misa fuka qamunna faqa qinindi kiani. ");
INSERT INTO bjr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Mi sipsipana ainoo ameesa saa qaraana faqa audurakinaa afaaqa saa qaraa ainoo faqa annaama ati amiqirana faqa qaara atakisa mina saa ainoo marina faqa asauku uqannai afundana faqa ateeka aqua. ");
INSERT INTO bjr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Qini qimia nafisa amanee uqana kinaana oosana oosana narana moodaa moodaa maraaqa. Oorifa fadameenannai suqarana moodaa faqa moo sia oorifa fadameenannoo suqarana moodaa faqa ausirira feemu moodaa faqa maraa. ");
INSERT INTO bjr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mi naranausa Aaroona faqa mina faiqi namu faqa nisaukuki quqasainaqa uriqarara kaqi nimirafa qini Anutusaindi fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Miqi maseenana kafaa nisaukukinaana mareeqeenana qaindasaa sipsipa akoona auku quqaqaana amuaaqa quqasee ida arasaifanoo qaani. Qini qimira naranara foora ida araaqa. Mina afundara qinee asasianaura. ");
INSERT INTO bjr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Moosee anee mi sipsipa akoonnana marasee qini Yaaweesa qifu saa uqeerasee qini Yaaweesa uriqarara qimira ainainee qimasee aneenna mi aandauna naa. ");
INSERT INTO bjr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Innee faiqí aanaiqi kirausaikamma nimaqararee qimasee qini qimia narannakinaana sipsipa akoona ameemmeeqana marasee qini qifu saa uqeeraseeqa mina asaukuqannai afundana uqaqifiqaaqa. Miqimmaseeqa mi aandauna aanaiqikirausa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mi ufafa qini ufa marinaqa naaruara naaruara qini faiqí anaasee qini faqa moodaanaki suqira tatufirana suqaaqa. Mi aandauna ameemmeeqana faqa asaukuqannai afundana faqa aanaiqikirausaindi mariani. Faiqí anaasee qini Yaaweesa kaqi qimira ainaina miqimminoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaroonafa kuqinaqa mina uriqarara aanaiqikira qamunna mina faiqi namu maraaqa. Mi saikana oosana arainna faasaana mi qamunnana afisusaifaqa fadameena nikiiqa amoondunna adiaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aaroona amaaku narí akoona amaaqa maqainafa uiqaana maqaki qinee umee marunnnanaki keeqafinoo naaquqara oosiranaki ainainiraree qimaseenoo mi uriqarara qaanaiqikira qamunnana afisusee moodaannai qisauku taikasee dinni ani qaara marasee 7 faasaana saa mi naaquqara oosiranaki ainainiani. ");
INSERT INTO bjr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Yaaweefa kafaa Mooseena qimaminoo qinau. Anee Aaroona faqa mina faiqi namu faqa nikiiqa amoodunna fadameena adia nimaqaidana suqeenna sipsipa akoonnana ameemmeeqana faqa asaukuqannai afundana faqa marasee qini naaquqara oosiranaki afeeki quqasee nammari namufaqa suqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Qinee umee marunna uiqaana maqana kooqiki mina naaqa. Nafisa amanee uqaki kaqi mari feemusa namu faqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Misa namasaifana aanaiqikira saikaki keeqarana fadameena nikiiqa amoondunna adiasainanoo misa numoo akiiqara mininnisarafa mariannoo. Mi narannafa naaquqarafa marinara aanaiqikirausa kai naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Akaqa aandau faqa feemu faqa nimuaquinaqa sia naifandinnana kananaana kaqi marinaqa ida araseeqa minaki aqusaifanoo amiqimmasee qama taikaani. Mi naranafa naaquqarafa marinara sia naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Aaroonafa narí faiqi namu faqa aanaiqikira saika oosana arainna qooqari qinee ani aamua qunandee iqa moodaannai qisauku taikasee dinni ani qaara marasee 7 faasaana uqanna kai mi ainainausa auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mi moodaa moodaa faasaannasaa anee burimakau akoona tatufirana suqa qiminanoo aiqama numoo taikaannoo. Miqinanoo qini qaidara fannoo anukarafa mariannoo. Miqimmafinana oorifa fadameena qaidarasaa adiasainanoo naaquqanoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Aiqama kari moodaannai qisauku taikasee dinni ani qaara marasee faasaana saa miqia. Miqinanoo qini qaidara fannoo kaaqa uqanna naaquqarafa mariannoo. Moo fannoo fee moo ainaina fee mina auqainafa mina naaquqara afeeka fannoo aruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Yaaweefa kafaa Mooseena qimaminoo qinau. Innee sipsipa aanaaqi qaaraqanda moodaa aukuana marara qanda marasee qaidarai tatufirana suqaaqa. Naaru naaru aiqama faasaana miqi kaimmiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Moo sipsipa kananaana tatufuaqa moo eendimarina tatufuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kananaana suqainna sipsipana namu faqa amiqira sakumannoo qaindirira parauaqa mina ummaara fannoo 1 kilogramme oodaa namu faqa amiqira oorifa fadameena namu faqa quandasee suqa qimia. Uainna nammari oodaa 1 litre amana kai qinee Anutusa naannana adiaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Eendi marinaqa suqainna tatufirana kananaana suqaandee kai iqa sakuma qaindiriranannoo faqa oorifa fadameenannoo faqa uainna nammarinnoo faqa suqaaqa. Mifa qini Yaaweesa qimira narana maridanoo. Mina afunda fannoo qini asasirana qimidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Naaru naaru kasooaqee maa tatufira suqarafa qinee umee marunna uiqaana maqa kooqiki qini qifu saa tatufu qimiaqa. Miqifaqa miqoo qinee inni qeeqa faiqí anaasee faqa moodaanaki maridaqa ufa qima nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Miqoo qinee Isaraee maqannaasa faqa mariananoo qinee umee marunna maaqanakiqari daroo daraa ira kaaqa qarafa mi saqanna naaquqainaqa sia faiqí anaasee kaiqeesa miqoo fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Qinee qeeqa uiqaana maqa faqa qaidara faqa naaquqara faika masaanaura. Qinee Aaroona narí faiqi namu faqa qini ainainirausa mariafaqa naaduma misa aanaiqikira saikaki quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Qinee Isaraee maqannaasa qambaana maridaqa misa Anutusa marianaura. ");
INSERT INTO bjr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Misa qini Yaaweesa nariqa Anutusa Isipa maqa maaqaindaraana nifiqee aniafannanara iri marifaqa qinee misa qambaana marianaura. Qinee Yaaweesa misa Anutusa marianaura. ");
INSERT INTO bjr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Yaaweefa kaifaa Mooseena qimaminoo qinau. Moosee innee akasia saqari marasee amiqira afundi mari ida munana aree fandinna qaidarana auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Mi qaidarafa dinni dinni amana kai mariani. Mina kisaaqandanai 45 centimetres mariani. Mina qusandanai miqi kai inoo 45 centimetres mariani. Maqa saaqari ooru firafa 90 centimetres mariani. Mina qaara faqa qaara faqa ati moodaa saqarinnoo kai burimakau aanaira foora auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Mina afu faqa aanai fooqaana faqa ataaqeeqara faqa amiqira koorannai kai rafaaqafusee koorannai mina fiqu fiqumma auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Koorannai qaara qanda aanaanu auqusee dinni moo dinni moo quqasaifanoo qaindusi fandinna saqarina atukaramma qumaraani. ");
INSERT INTO bjr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mi qaindusira saqari qanda akasia saqarinnai auqusee koorannai rafaaqa fuaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Mi qaidarana mara maree naaquqara oosirana dinni qini moodaanaki kira bukisa marina oorinni quqaaqa. Miqoo qinee inni faqa moodaanaki kianaura. ");
INSERT INTO bjr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aiqama kananaana Aroonafa qoomauqa andeeqarara anireenoo mifa mina saa amiqira adiafaa ira afundi marina suqaani. ");
INSERT INTO bjr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Mifa kaifaa eendi marinanoo qoomauqa qumbiseenoo amiqira adiafaa imari afundana imarina suqaani. Mi oosanafa naaru naaru sia uqanna taikaannoo kaqi kai mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Innee sia moo mi qaidarana saa qinee qaoo qima qaunna afundirana suqaaqa. Aandau tatufiranee sakuma qaindirira tatufiranee uainna nammari adiasee suqara tatufiranee sia minasaa suqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aiqama aukuana moodaa faasaana kai Aaroonafa mi qaidaranasaa ainaininanoo qini qifusaa amiqiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yaaweefa kafaa Mooseena qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Moosee anee Isaraee maqannaasa nuqu marasainaqa moodaa moodaa fasiqa nariqa mariranara qini feefauru qimiaqa. Miqimmasee nuqu maree marinaqa moo ummaara sia misa saa aqufuannoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Aiqama nuqu akaraki marisa uriqararausa auqu ramaqaa munnimmana amana kai quqaaqa. Aiqamausa mi feefauruna aqiqa qini qimira ainaina qimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Faiqí moodaa fasiqa aiku asauku taikasee 20 aukuana faqaasa faqa mina fiqarara aukuana faqaasa miqimmasee qini feefauru qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Misa nariqa marirana maaqimmasee feefauriaqa. Ainaina faqaasa sia fiqaramasee aqifaranoo. Ainaina siaisa sia oorudupi masee aqifaranoo. Aiqama amana amana kai aqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Mi munnimmana Isaraee maqannaasiannai marasee qinee umee marunna uiqaana maaqafa mandaikinana minannoo itipia. Misa nariqa mariranara mi takisana aqusaifaqa qinee misa saa itita nimaqaranara irianaura. ");
INSERT INTO bjr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yaaweefa Mooseena maaqi qimasee kafaa qimaminau. ");
INSERT INTO bjr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Moosee anee nammari auqeemaria difaanina firaana auqua. Booroosannai auqusee mina aiku faqa booroosannai kai auqua. Auqusee nammari minaki adiasee qini uiqaana maaqa dinni marinana qaidara dinni marinana qambaana quqaa. ");
INSERT INTO bjr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaroona faqa narí faiqi namu faqa minaki niku nisauku nammari uqimarifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Misa qini ufa suqira maaqaki keeqaanee qimasee niku nisauku minaki mafi nammari uqusee qini qimifandinna narana qaidarasaa suqa qimiaqa. Miqiqa sia kuqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Misa nári niku nisauku nammari uquseeqa sia kuqifaranoo. Maa sanda ufana Aaroonafa narí faiqi namu faqa kasooqaqee misa saa aniaruakinausa faqa maa sanda ufana afaqee faranoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yaweefa kaifaa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Moosee anee makaqa anoona moomoo 6 kilograms faqa isaaqa anoona moomoo 3 kilograms faqa amiqira undi mari innupina anoona moomoo 3 kilograms faqa maraa. ");
INSERT INTO bjr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Saadapu moomoo 6 kilograms faqa maraa. Aiqama ainaina uiqaana maqa sikeera amana kai mariani. Oorifa fadameena 4 litres amana minaki adiaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mi naaquqara fadameena Yaaweenaindi fee qimasee nikiiqa amoondunna adiee fandinnana auqusee amiqira afundi marina namufaqa quandaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Anee mi fadameenausa auqu maree qini uiqaana maqasaa akuseenana qini moodaanaki kira ufa mari bookisanasaa faqa akua. ");
INSERT INTO bjr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Aiku faqaa teeboora faqa minasaa qaraa ainainauqa faqa qooma saqari faqa minasaa qaraa ainainauqa faqa amiqira afundi mari pauraqana ida qee mari qaidarana faqa akuamaqaa. ");
INSERT INTO bjr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Tatufirana suqee mafia qaidarana faqa minasaaqaraa ainainauqa faqa akuamaqasee nammari difaani faqa mina aiku faqa akuamaqaa. ");
INSERT INTO bjr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Miqimmasee mi ainainausa aaduma saa mara quqasainanoo kaaqa naaquqanoo mariani. Moo fannoo fee moo ainainee mi ainainausa auqainafa mi ainainausa naaquqara afeeka fannoo naruannoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Miqimmasee Aaroona narí faiqi namu faqa mi fadameenna aku nimaqa sainaqa qini aanaiqikira saikaki mariaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Moosee anee Isaraee maqannaasa maaqi qimasee qimannimia. Maa naaquqara fadameenna nikiiqa amoondunna adiee fandinnana qini ainainiranaki naaru naaru quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Maa fadameennafa sia kaiqee fasiqa adiannimaqee mariafa maridanoo. Innee sia moo fadameena miqirana auquaqa. Mifa naaquqara ainaina marinara innee minara naaquqara fee qimasee eerairiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Yafee moo fannoo maa fadameennara foora auqusee moona akiiaaqa adiainafa qini faiqí aanaaseeki sia mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yaaweefa kaifaa Mooseena qiminoo qinau. Moosee anee oosana oosana amiqira undi mari pauraqana sitakatee pauraqa faqa oonikaa pauraqa faqa karabanumma pauraqa faqa amiqira makaqa anoona faqa aiqama amana amana kai maraa. ");
INSERT INTO bjr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Maraseenana amiqira afundi marifaqa nifaaqai aki marianara foora auqamasee ida arasainanoo qeenoo amiqira muna afundiani. Ooruku faqa oodaa quqasainanoo amiqinoo naaquqara faikiani. ");
INSERT INTO bjr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Anee mina atiuqa maraseenana kaada ririisainanoo kookoomaika mafinana mara maree qinee umee marunna maqanaki muruseenana moodaanaki kira bukisa oorinni quqaa. Mi amiqira undana imarinara kaaqa naaquara fee iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Innee sia moo miqira afudimarinnana auquaqa. Innee minara naaquqara andeeqara ainaina Yaaweenaindi fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Yafee moo fannoo miqirana amiqira undi marina afaaqai akiraree qimasee auqinafa sia qini faiqí aanaaseeki mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yaaweefa kafaa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Moosee qinee innikinaana Beesareerana utaaqeeqa. Mifa Urina amaaku Hurana anaiqi Yudana oosanakinaafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Qinee qeeqa maraquna afeeka aaku amaqeeqa. Qinee irirana faqa aiqama ainainirana akoofasaikira saika amiqa. Aiqama amiqira ainaina auqirana akoofasaikirana faqa amiqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Mifa koorannoo faqa siruaannoo faqa booroosannai faqa oonu mafi irisaidanoo oosana oosana ainaina akoofasauqa akara rimaria irirana faqa auquani feera amiqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Qinee firaa feefauru aqi maria oonina ateekara oosana faqa saqarinnai ainaina amana auqirana akoofasaikirana faqa Basareerana amiqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Qinee moo fasiqa Ooqooriabana Aqisamakana amaaku Dannana oosanakinaana mara quqasaananoo Beesareerana faqa ainainiannoo. Qinee akaqausa faqa firaa irirana oosana oosana ainaina auqirana akoofasaikirana nimiqa. Miqimma saanaqa misa qinee qimannimianna aiqama ainainna auquaqeera. ");
INSERT INTO bjr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Qinee umee marunna uiqaana maaqana faqa moodaanaki kira bukisa faqa mina afu numoo taikannisarana faqa aiqama uiqaana maqakinaa ainainauqa faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Teeboora faqa minasaa mari ainainausa faqa ramma dirirana amiqira koorannoo auqirana faqa minasaa mari aiqama ainainausa faqa amiqira afundi mari tatufirana suqara qainda faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Tatufirana suqee maria qaindana faqa mina suqee maria ainainausa faqa niku nisauku nammari uqimaria difaanina faqa mina oosana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Misa amiqira qamunnauqa Aaroona faqa mina faiqi namundi faqa aanaiqi kira saikaki maridaqa afisifandinnana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Qinindi fee qimasee akunnimaqee fandinna fadameenna faqa adiafaa ira amiqira afundimarina naaquqara oosiranakinaana faqa auqua. Misa auqidaqa qinee qunandee kaimaseeqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yaaweefa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Moosee anee maaqi qimasee Isaraee maqannaa qimannimia. Sabata qini idooara faasaana amiqimandee ireedakai mariaqa. Mi faasaanafa qini faqa inni faqa qambaana naaru naaru maridanoo qinee Yaaweesa inni mara qeeqa faiqí anaasee kunnanara quqannifiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Innee qini idooara faasaana naaquqarafa marinara ireeda kai mariaqa. Faiqí moo fannoo sia ireeda marirai mi faasaanna ainaininnana kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Qisauku dinni taikasee dinni moodaa marasee 6 faasaana innee inneeqa ainainiaqa. Qisauku dinni ani qaara marasee 7 faasaana firaa idooara faasaana qini naaquqara faasaana maridanoo. Yafee mi faasaanna ainaininnana innee mina kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isaraee maqannaasa innee faqa qinee faqa moodaanaki kunnanara mi faasaanafa uqannifiqaani. ");
INSERT INTO bjr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mi faasaanafa inni Isaraee maqannaa faqa qini faqa naaru naaru aqoondikirana koorooi mari faasaanafa mariannoo. Qinee Yaaweesa dinni taikasee dinni ani moodaa marasee 6 faasaanasaa maqa faqa innaaruna faqa auqusee dinni ani qaara marasee 7 faasaana ainainirana quqasee idooaafannanara mi faasaanafa idooara faasaana mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Anutufa aiqama ufa Mooseena Sinai aaqanasaa qimami taikaseenoo qaara ooni ausiriranasaa Anutufa narí asaukunnai sanda ufa akara rumaqoona aminau. ");
INSERT INTO bjr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mooseefa aaqanai kisaaqasaa ooru marufaqa Isaraee maqanna faiqí anaasee Aaroonafa maruqoo suqumaree aniree Aaroona maaqi qimasee qimamiqau. Maa fasiqafa maasa Isipa maqa maaqaindari qifiqee anufa naqaafee imari faqee maasa sia iridaqa. Minara anee moo anutuna auqusainanoo maasa indaarunnikamma nimaqaani. ");
INSERT INTO bjr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroonafa misa ufa iriseenoo qinau. Inneeqa faiqi anaasee naaqookinaa koora faqa fidinaanu faqa tatuseeqa mini qimiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Miqi qufaqa aiqama faiqí anaasee nári naaqookinaana raduku maree mini Aroona amiqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Amisoofanoo Aaroonafa mina qumareenoo idannai tasirisiri mandeenoo maqasaa burimakau akoona aanaaqi amana auqu qoonaki adiasoofanoo burimakau amana auqinau. Auquseenoo paipanannai mina atiuqa andeeqanau. Miqimmasoofaqa faiqí anaasee qiqau. Isaraee maqannaasa maafa maasa Anutufa maridanoo. Maafa kai maasa Isipa maqannaindari nindiqee anufa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaroonafa misa ufa iriseenoo burimakau akoona amana auqirana aaqa tatufira qainda auquseenoo faiqí anaasee qimanniminoo qinau. Duna aiqama suqumaree aniraifaqa oomaqa sakasee naidaqa Yaaweena auqa uqeeraa. ");
INSERT INTO bjr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Miqi qimasoofaqa iaqoo kananaana faiqí anaasee akaqa aandau mara maree minisee qaindasaa tatufirana faqa Yaaweena faqa moodaanaki kira tatufirana faqa suqaqau. Suqamiseeqa ooqu marifiqa afeeka nammari faqa narana faqa namaseeqa findifiqa aanaaseeuqa faqa manda oosana maraqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Yaaweefa misa nindafeenoo Mooseena qimaminau. Anee kai kaqi ooqufua. Faiqí anaasee anee Isipa maqanaindari nifiqee anianausa qini minnisee aaqara oosana maraidammia. ");
INSERT INTO bjr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Misa doo qinee fuaqee qimasee naamuaqiafanna aana minniseea. Misa koorannai burimakau akoona aanaaqi amana auqusee mina tatufirana suqamiseeqa minara innaaru qidaqa. Misa maaqi qidaqa Isaraee maqanaasa maasa Anutufa maafa maasa Isipa maqannaindari nifiqee anufa maridanoofee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Minara qinee Yaaweesa Isaraee maqannaasa kaaqa ramoo ramaa imariafaqa iridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Doo firaaqoo qini qirana qaifaqa misa kuridi taikasaanaura. Anee sia qiniara qaoo qia. Miqimmaseeqa ani faqa anisaa ani aruakinausa faqa kai amiqi amiqimma nisaanaqa firaa maqannaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mooseefa irinoo Yaaweena aanoo qiranara innaarukiqari qaoo qidanoo qinau. Oo Yaawee nanaree anee aneenna faiqí aanaaseera arana qaidanoo fee. Anee firaa afeekannai misa Isipa maqanaindari nifiqee anianafa naqaaifanee aanoo qima nimaqaidanee. ");
INSERT INTO bjr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Anee miqinaqa Isipa maqannaasa aniara nári kai qimirisee Isaraee maqannaasa nifiqee aaqana aikunni munusee naru taikarara nifiqee fiifoo qifaara. Sia arana qaani aneenna arana qara irirana quandasee sia ummaara aneenna faiqi anaasee nimia. ");
INSERT INTO bjr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Anee aneenna ainainira faiqiuqa Abarahammana faqa Isakeena faqa Yakooboona faqa kuqaa qima afeekaikira ufa qunnanara oonumafi iria. Anee misara fasaura foora mafifaqa qinee qima afeekaikiafanna maqa maaqana inni nimianauree qinau. Nimisaananoo mi maqa maaqafa innindikamminoo naaru naaru mariannoo fee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mooseefa miqi qufanoo Yaaweefa narí aranaqara irirana quandasee sia ummaara narí faiqí anaasee niminau. ");
INSERT INTO bjr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Yaaweefa Mooseena qaara oonisaa akara rumamufanoo mareenoo aaqanaindari afaasai narí maqannaa marunnai ooqu finau. Ausirira ooniqandasaa Anutufa sanda ufa dinni dinni akara rumaqoona uqirafa ooqu finau. ");
INSERT INTO bjr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Anutufa narí kai mi oonina auquseenoo minasaa sanda ufa akara rinau. ");
INSERT INTO bjr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoosuafa irufaqa faiqí anaasee nariqa uiqaana maqusakiqari faaqa fuisee qida qufanoo iriseenoo Mooseena qima minoo qinau. Qinee rakidaqia ufana iridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Miqi qufanoo Mooseefa qinau. Sia qufoona rira ufa fau maridanoo fau. Sia qiki faafau qirufa fau maridanoo. Idi rarana kai iridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mooseefa uiqaana maqusa adeedi ooqureenoo nindafoofaqa burimakau aanaaqi amana auqirana faiqí anaasee fusakidaqa idi ree mariqau. Miqi marufanoo Mooseefa nindafoofanoo aranaqoofanoo akara rira ooniqara aaqana aikunni maqasaa aqusoofaqa miqanda rukamiqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mooseefa aranaqoofanoo burimakau aanaaqi amana auqirana qumareeqeenoo idaki aqusoofanoo tasiris irinau. Tasirisiri maseenoo andaana rumeeqee nammariki aqusee naaqee qufaqa Isaraee maqannaasa mi nammarina naqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Miqimandeenoo Mooseefa quandakufanoo Aaroona qimaminau. Maa fasiqa anaaseesa ani naqi fee mamaqaafanee anee maa manda firaa aaqarana misa nifaaqai quqeenee. ");
INSERT INTO bjr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Miqi qufanoo Aaroonafa Mooseena qimaminau. Oo qini uriqararafa anee sia qiniara aanoo qia. Anee maa fasiqa anaaseesa oosana irimariananoo. Misa kaaqa mandoosana auqarara sandanainai qimariasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Misa qiniara maaqi qia. Maasa maa fasiqafa Mooseefa maasa Isipa maqa maaqaindaraana qifiqee anunaki kambiqai ainainnara sia iridaqa. Anee moo anutuna auqu sainanoo maasa indaarunnikamma qimaqaani. ");
INSERT INTO bjr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Miqi qiafaqa qinee qimannimiqa koora faqaasa qimiaqee qunaqa uaqee iasa akaqana qimia. Qimiafaqa idaki aqusaunanoo burimakau aanaaqi kambiqeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mooseefa qafoofaqa Aroonafa eedoo qufaqa faiqí anaasee nariqa namuqaa nifusaa oosana oosana manda oosana maroofaqa namuqaa misara uteetiqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Minara Mooseefa arana qoofanoo uiqaana maqusa kooqiki kikiqamma fufanoo maaqi qimasee nammeera qinau. Aiqamausa yafee Yaaweenaindi kiani qinafa maaqoo aniaqa. Miqi qufaqa aiqama Reefina aiku asauku kai suqumaree miqoo ani mina fiqu fiqumma fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Aniroofanoo Mooseefa maaqi qimasee qimanniminau. Isaraeerana Anutufa Yaaweefa maaqi qimasee aiqamausa inni naakapaidanoo mifa inneeqa rakira paipana mara maree innee uiqaana maqusa dinni kooqindari dinni kooqinni oonuree aniree idaqa unna anutuna amana auqi mariana akiiqara inneeqa nikaqaafasaauqa faqa inneeqa niqoondiuqa faqa inni naaqa mariasa faqa aiqama kuqa naru taikaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Miqi qufaqa Reefina aiku asauku eedoo qimasee mi faasaanna 3,000 fasiqa nariqau. ");
INSERT INTO bjr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Narusoofanoo Mooseefa kafaa qimanniminau. Innee inneeqa faiqi namufaqa inneeqa nikaqaa fasaauqa faqa naruanara innee Yaaweena aanaiqikirausai kiqa mariafanoo. Miqi mariafanoo Yaaweefa narí amiqi amiqirana inni niminoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Iaqoofanoo kananaana Mooseefa faiqí anaasee qima niminau. Innee firaa manda aaqarana marasaafaqa aqbee qinee aaqanai kaifaa ooruree inniara Yaaweena iramiriananoo inni aaqarana akiiqara minninisaannoo fee. ");
INSERT INTO bjr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Miqi qimaseenoo Mooseefa Yaawee funnai aaqanai ooruree qimaminoo qinau. Maa fasiqa anaaseesa firaa manda aaqarara marasee unna qira anutuna koorannai auqusee minara innaaru qiqiiaafanoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Amanee misa aaqarana akiiqara minninnisaa. Sia minninniseenana qini duqu ani faiqí anaasee faqa ani bukaki akararinoo marina kai rukaa. ");
INSERT INTO bjr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yaaweefa iriseenoo qinau. Sia kaiqeesa nuqu qeeqa bukakinaana rukaanaura. Qini ufa rukiee mariasa nuqukai rukaanaura. ");
INSERT INTO bjr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Doo oonuree faiqí anaasee nifiqamaree qinee qimamiafanna maqa maaqanai fua. Anee iria, qini qangiroo fannoo inni indaarunni kamma nimaqaannoo. Mi fasiqa anaaseesa aaqarana akiiqara ummaara nimianna aukuanafa anidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Miqi qimaseenoo Yaaweefa manda aurirana mi fasiqa anaaseesa niminau. Misa Aaroonara qufanoo koorannai burimakau akoona aanaaqi auqunara miqinau. ");
INSERT INTO bjr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yaaweefa maaqi qimasee Mooseena qimaminoo qinau. Anee faqa Isipa maqa maaqaindari nifiqee anianna fasiqa aanaaseesa faqa maa maqana quqasee qinee qima afeekaikammasee Abarahaamana faqa Isakeena faqa Yakooboona faqa misasaa ani aruaki kambiqainausa faqa nimiraree qiafanna maqanasaa fua. ");
INSERT INTO bjr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Qinee qeeqa angiroo aiqaananoo inni nifu uqi marinaqa fimarifaqa qinee Kannaa maqannaasa faqa Amoora maqannaasa faqa Heeta maqannaasa faqa Peerisa maqannaasa faqa Hifita maqannaasa faqa Yeebusa maqannaasa faqa naru nifaqaaqa ianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Innee ainoo faqaa maqasaa ainaina ummaqusaa fanoo reemindeemiri mari maqanasaa fifaranoo. Qinee qeeqa sia inni faqa fuanaura. Innee ramooramaa imariasa mariafaqa qinee inni faqa fidaqa aanai inni naruanoora. ");
INSERT INTO bjr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Isaraee maqannaa Yaaweena mi ufana iriseeqa nifaaqa auqira ainaina aiqama raipaqu quqasee soofaara maridara foora mafiqau. ");
INSERT INTO bjr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yaaweefa maa ainaina auqaaqeera qimannimufaqa miqiqau. Maaqi qimasee Yaaweefa Mooseena qimaminau. Innee kaaqa ramooramaa imariasa mariafanoo. Qinee inni faqa maqee fiqa inni kuridi nimaqaunaiqini. Doo maqee inneeqa nifaaqa auqirana raipaqu quqasee kaqi marifaqa qinee inni naqaafee mannimaqaannanara oonumafi irianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Miqi qimasoofaqa Sinai aaqana quqasee fidaqa Isaraee maqannaasa sia nári nifaaqa auqirana afisiqau. ");
INSERT INTO bjr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Isaraee maqannaasa nariqa uiqaana maaqauqa usakasoofanoo Mooseefa naaquqara uiqaana maaqa naambeeqai nianasaa usakanau. Usakasee mina auqureenoo Yaaweefa umee mari uiqaana maaqa fee qinau. Faiqí anaasee moo fannoo Yaaweena iriranara irianee qimasee mi maaqana kooqinni fimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mooseefa narí uiqaana maaqai fufaqa faiqí anaasee nári uiqaana maqa kooqikiaqa kikiqamafi qafee maru fanoo keeqanau. ");
INSERT INTO bjr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mooseefa uiqaana maaqaki keeqafufanoo asuru qumureenoo mi kooqinaki marufanoo Yaaweefa minakiqari Mooseena faqa ufa qimarinau. ");
INSERT INTO bjr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Asuru uiqaana maqa kooqiki qumu kasoo inoo marufaqa faiqí anaasee mina qafamasee ninuka tuqu naumoo amisee Yaaweena amooqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yaaweefa Mooseena faqa narí oori narí oori qafaida ufa qimarinau, faíqi narí aqoondi faqa ufa qimarindee inau. Ufa taikaseenoo Mooseefa anirandee faiqí anaasee maru uiqaana maaqanai finau. Kumaaraa moo mina dadaaqi marufa Yoosuafa Nunnaana amaaku naaquqara uiqaana maaqaki kaqi marinau. ");
INSERT INTO bjr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mooseefa Yaaweena qimaminoo qinau. Oo Yaawee kuqaa anee qiniara maa fasiqa anaaseesa indaarunnikamma nimaqainaqa mi maqanasaa fuaqee qinau. Anee sia qini faqa fidanoo qini dadaaqianinna fasiqanara qimaqimiananoo. Anee qiniara amiqimmasee iridana qiniara asasidaqee qiananoo. ");
INSERT INTO bjr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Anee kuqaa qiniara miqidana anee qimiriannana qimaqiminaqa qinee ani ainainiranaki maridqa maqee maqee ani asasamma amaqaanaura. Anee maanara faqa iria, maa maqannaasa ani faiqí anaasee anee utaaqama qaanausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yaaweefa mina iriseenoo Mooseena qimaminau. Qinee ani faqa fidaqa adooarana inni nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mooseefa iriseenoo Yaaweena qimaminoo qinau. Anee sia maasa faqa finana sia maasa maaqooqari diqiqaa. ");
INSERT INTO bjr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Anee sia maasa faqa finaqa naqaafee masee akaqausa anee qiniara faqa aneenna faiqí aanaaseera faqa rimariannanara irifaranoo fee. Anee maasaki marinaqa maa maqa maaqana kinaasakiqari naaduma moo kirausa marianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yaaweefa Mooseena mi ufana iriseenoo qimaminau. Doo anee qianandee kaimmianaura. Qinee amiqimmasee aniara irimarunnanara faqa aniara asasi marunnanara faqa miqianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mooseefa mi ufana iriseenoo kaifaa Yaaweena iramirinoo qinau. Amanee aneenna oori daroo daraa irana uqaqifiqasainaqa qafaanauree qufanoo Yaaweefa qinau. ");
INSERT INTO bjr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Amana qinee qeeqa amiqira areenarana quqasaananoo ani aiaaqaree afunni fuannoo. Qinee ani afusaa qeeqa naaquqara duquara koorooianaura. Qinee Yaaweesa qeeqa nifauarana faqa qeeqa qimudaoo qirana faqa qinee utaaqama qaunausa nimianaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Moosee anee qini doori sia qafeenaranoo moo fannoo qini qiqafainafa sia amana kaqi mariannoo kuquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Moosee anee qini daakaarinni oonisaa kikiqina maria. ");
INSERT INTO bjr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Qini doori areenarafa finaqa qinee ani ooni afoo iranaki quqaseeqa qeeqa qisauku anisaa ititaseeqa fiqaramafiqa qisauku maraanaura. ");
INSERT INTO bjr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Qinee qisauku mara maraanana anee qini itaufaka kai qiqafa. Sia doori qiqafeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yaaweefa Mooseena qimaminoo qinau. Moosee anee maa aaqannasaaqari ooquree ooni ausiqara ateekasee maree urua. Anee indaaruqaa qanda amana kai ateekasee maree urua. Murusainaqa indaaru rukamunnanasaa akara ruafannufana kafaa akara ruanaura. ");
INSERT INTO bjr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Anee maqee deedaqamaqai marinana duna kananaana eendai mara maree Sinai aaqanasaa ururee qini paquria. ");
INSERT INTO bjr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Faiqí moo fannoo sia ani faqa uruannoo. Sia uqanna moo fannoo aaqanai fee aaqana aaqa fee mariani. Sia misa burimakau sipsipa faqa aaqana aikunni andanda naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mooseefa iriseenoo ooni ausirirana qaara qanda ateekamaree kananaana Yaaweefa qimamundee inoo Sinai aaqanai oorufinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yaaweefa asurukina qumureenoo Mooseena faqa kikiqa mafinoo narí auquara koorooinoo qinee Yaaweesee qinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yaaweefa Mooseena oorinni fiqaree oonuree maaqi qimasee firaaqoo qinau. Qinee Yaaweesa maridaqa. Qinee qimuqusirana faqa qimudaoo qirana faqa umbiqarausa maridaqa. Qinee sia kai kaqi aanooqunausa maridaqa, qinee kaaqa faiqí anaaseera qimuqusi marunausa mardaqa, qinee ooqai marunnaqoo kai marunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Qinee qeeqa qima afeekaikira ufa kasooaqee nukudara foora kambiqainausara qima qaafanna ufana kaqi kai iridqa, numoo faqa manda oosana akiiqara faqa minninisaanaura. Qinee numoo auqainna fasiqa aanaaseesa faiqi namu faqa mina anaiqi mara faqa mina asaifaqausa faqa afaqnausa faqa sia sia naruanaura, naruanaura. ");
INSERT INTO bjr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mooseefa mi ufausa iriseenoo kai kaqi maqasaa oorindari mapamufufanoo Yaaweena amooqinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Amooqidanoo maaqi qimasee Yaaweena qimaminau. Yaawee anee kuqaa uqanna qiniara asasidana qinee aniara maasa faqa fuanneera iraidaqa. Maa fasiqa anaaseesa ramooramaa idaqa anee maasa numoo akiiqara minniqiseenana maasara aneenna faiqí anaasee fee qia. ");
INSERT INTO bjr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yaaweefa Mooseena qimaminoo qinau. Maqee qinee Isaraee maqannaasa faqa moodaanakikira ufa qidaqa. Qinee misa nifusaa firaa ainainauqa sia maa maqanasaa moo atinai faqa moo maqannaa qambaana faqa auqaafanna ainainausa auqaanaura. Aiqama faiqí anaasee qinee Yaaweesa firaa ainaina auqaanaqa qafaifanoo naaquqaannoo. Inni dadaaqianifeera miqianaura. ");
INSERT INTO bjr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Qinee maqee qimannimianna sandufana amiqimasee irisee mimau fuaqa. Qinee Amoora maqannaa faqa Kannaana maqannaa faqa Heeta maqannaa faqa Peerisa maqannaa faqa Hifita maqannaa faqa Yeebusa maqannaa faqa inni noorinni fidaqa misa nifaqasaana fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Innee fuka maqasaa oonuree sia mi maqannaasa faqa kaqikaa ainaina ree firaa ainaina ree sia misa faqa moodaanaki kira ufa qiaqa. Misa ufaanara foora fufusaifaqa innee minaki arifoora, minara qeerairiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Misa tatufirana suqee maria qaidarana misa ooni ateekarana rakiaaqee maasa naaquqara anutunee qimariana innee mina rukamu aquaqa misa saqari ateeka rakiqasee maasa anaasee anutufa Aseeraafee qimariana minauqa faqa ateekaateekamma aqusaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Innee sia moo unna anutunara innaaru qiaqa. Qinee Yaaweesa unna anutufa qini qimaaqa maqaranara rairai qimarunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Innee fuka maqasaa oonuree sia uqanna misa faqa moo ainainara moodaanaki kira ufa qiaqa. Misa nariqa unna anutuna innaaru qidaqa tatufirana suqami mariana inniara naaqee qifaqa nee foora. ");
INSERT INTO bjr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Inni faiqi namu mi anaamuru anaaseesa maraseeqa qini minnisee moo unna qira anutusara innaaru qifoora. Mi oosanafa qini qifusaa dapi nua aanaaseesara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Innee sia moo ainaina tasirisiri masee unna anutuna amana auqusee minara innaaru qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ooqai innee Abiba quqoonasaa Isipa maqasaaqari anusa mariafanoo. Minara Abiba quqoona anirainaqa maqee maqee innee sia yis mari feemuna oomaqa sakasee maqee maqee naaqa. Dinni qisauku taikasee dinni oonu qaara marasee 7 faasaana mi oomaqana sakasee naaqa. Isipa maqasaaqari anu quqoonafa marinara miqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Aiqama ainaina ooqasaa aanaaqi qinindi maridanoo. Innikina ooqasaa akoonaiqi maqainafa faqa aiqama maaqeena aandauqa ooqasaa akoona maqainafa faqa qinindi kai mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Innee inni doonki aanaaqi ooqasaa maqarafa kaqi marianifee qimasee sipsipa aanaaqi mina amaaqa maqasee tatufirana suqa qimiaqa. Innee sia miqiqa mina anuka kuridiaqa. Innee aiqama inneeqa ooqa faiqiuqa feefauru masaifaqa kafaa inniqaindi kiaqa. Sia moo fannoo tatufirana suqara ainaina sia uqirafa qini Yaaweesa qifusaa aniannoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Dinni taikasee dinni ani moodaa marasee 6 faasaanasaa inni ainainira faasaana maridanoo. Dinni ani qaara marasee 7 faasaanasaa sia ainainiaqa. Umaqira aukuanee aiqira aukuanee anirainaqa sia mi faasaanna ainainiaqa, idooaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Innee unakirana oosana arasee miqoo afiana nara oomaqa suqaaqa. Innee asumu aiqu quqara oomaqa faqa sakasee naidaqa mina auqu reeqa asumu aiqu quqara oomaqa fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Moodaa aukuanaki qaarammoo kari aiqama Isaraee maqannaasa moodaaqoo suqufi qini Yaaweesa Isaraee maqannaasa Anutusa qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Qinee aanaamuru innee finnatinai nifaqaseeqa misa maqa maaqa inni nimisee inni mi maqa maaqana firaanaikamma nisaanaqa innee aiqama aukuana qaaramoo kari moodaaqoo suqufi inneeqa Anutusa qini Yaaweesa qifusaa marifanoo sia moo aanaamuru aniree inni maqa maaqa mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Innee aandau arusee tatufirana suqa qimiraree qimasee sia innooqeemari pauraqana namufaqa feemu suqaaqa. Ainnaaqarara oomaqaki arusainna aandauna ataraasa fannoo sia akaqafa kaqi marinanoo faiqee iaqaani. ");
INSERT INTO bjr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Aiqama aukuana indaaruqaa narana afiana nararee qinnana Yaaweena naree maree munu amiaqa. Innee sia mimmi fee sipsipafee arusee narí anoona naamma anoonannai suqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yaaweefa mi ufanara Mooseena qimaminoo qinau. Anee aiqama maa ufausa akara rua. Maa ufausa qinee ani faqa Isaraee maqannaasa faqa moodaanaki qima afeekai kamma qaunna ufana oosana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Miqi qimasoofanoo Mooseefa aaqanasaa Yaaweena faqa kisaaqasaa marinau. Qaara fasiqa niku nisauku taikasee 40 faasaana faqa eendaki faqa nammari faqa narana faqa sia neemarinau. Yaaweena moodaanaki kira sanda ufa ooni qarasaa akara rinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Mooseefa Sinai aaqanaindari Yaaweena sanda ufa akara rira ooniqara uqirafa quminau. Mifa Yaaweena faqa ufa qiqiunara mina oori afiri daroo daraa imarufanoo narí sia minara irinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaroonafa Isaraee maqannaasa faqa Mooseena oori afiri daroo daraa imaruna qafamaseeqa rufiaida nianasaa mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mooseefa misa nindafamaseenoo Aaroona faqa faiqí firaasa faqa naarama quqasoofaqa aiqama aniroofanoo ufa qima niminau. ");
INSERT INTO bjr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Adeedi aniroofanoo Yaaweefa Sinai aaqanasaa aiqama sandufa Mooseena qimamu ufana qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mooseefa qimannimi taikaseenoo karoo karoonaikira qamunna qumaree oorisaa rafaaqafinau. Mina oori qafee rufieefoora miqinau. ");
INSERT INTO bjr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Mooseefa aqoosai kaqikaa uiqaana maqaki keeqafinoo qamunna uturuquseenoo Yaaweena faqa ufa qimarinau. Qimaseenoo madaanai raudamafinoo faiqí anaasee Yaaweefa qimamu ufana qima niminau. ");
INSERT INTO bjr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Qima nimi marufaqa misa mina oori qafoofanoo daroo daraa ufanoo Mooseefa narí oorisaa qamunannai ititaseenoo qima nimi taikaseenoo quandaki Yaaweena faqa ufa qiraree qimasee uiqaana maaqaki keeqafinoo kaifaa qamunna uturuqinau. ");
INSERT INTO bjr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mooseefa Isaraee maqannaa faiqí anaasee aiqama suquseenoo qima niminau. Yaaweefa inniara maa ufamau fuaqee qidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Qisauku dinni taikasee dinni ani moodaa marasee 6 faasaanasaa ainainiaqee qinoo. Dinni ani qaaraikinoo 7 qini firaa naaquqara idooara faasaana mariannoo. Faiqí moo fannoo mi faasaanna ainaininaqa innee mina kuqa aruaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Innee sia Sabata faasaannasaa inneeqa maaqaki suqa naaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mooseefa Isaraee maqannaa aiqama kafaa maaqi qimasee qimanniminau. Yaaweefa maaqi qimasee naamua qidanoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Innee Anutuna amiraree qimasee nifaaqa asasinausa koora faqa siruaa faqa booroosa faqa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Amiqira qamunna faqa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa mimmi asausinnai auqira qamunna faqa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Sipsipa akoona apata faeena akirana faqa ooruku nammarikinaa aandau apata faqa akasia saqari faqa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Qooma qumbi maria fadameena faqa amiqira afundi mari ainainna andaana rirana idaki adiasaafanoo adiafaa ira undi marina faqa mi ainainna kai nikiiqa amoondunna adiee maria fadameenaki quqarara faqa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Pupu ooniuqa faqa akaqa amiqira ooniuqa faqa aanaiqi kirausa uriqararausa afisi maria eefooda qamunnanasaa faqa amuqusasaa ititara qamunna saa faqa quqeefandinna oonisa maree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Inni kiqari oosana oosana ainaina auqarana akoofasauqa kai anireeqa Yaaweena uiqaana maaqaki ainaina mifa naamua qimaqaimau kai auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Misa uiqaana maqa faqa mina rafaaqafi maria qamunnana faqa mina anaanu faqa mi maqana usakara atunauqa faqa aunirira saqari faqa oosuki faqa kooqiki faqa rakiqee fandinna saqarisa faqa saqari maqaki rakiqarana amaaqa auqirana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Moodaanaki kira bookisa faqa mina qaindusira saqari qara faqa mina afu faqa minasaa ititara qamunna faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Aiku faqaa qainda faqa mina aindusira saqari qara faqa minasaa quqee maria ainainna faqa auquaqa, Anutuna amifandinna feemuna faqa uquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Qooma saqari faqa mina qoomauqa faqa mina oosana oosana ainaina faqa mina qeemari fadameenna faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Afundi marina andaana rirana suqee maria qaidarana faqa mina qaindusi maria saqari qanda faqa faiqí nikiiqa amoondunna adieemaria fadameenna faqa afundimarina andaana rirana faqa uiqaana maaqa kooqi qamunna faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Aandau tatufirana suqee maria qaidarana faqa mina fukaa asaana booroosannai auqirana faqa mina qaindusira saqari qara faqa mina oosana oosana ainaina faqa nammari auqara difaani faqa mina oosana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Dapusaa diri maria qamunnana faqa dapu saqari faqa saqari kuradee mariana oosana amaaqa auqiranauqa faqa dapu kooqiki keeqee maria qamunnana faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Kafaa dapu faqa uiqaana maaqa apupukauqa faqa mina rumbee maria sanda ainaina faqa auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Aaroona idaaqira qamunna faqa mina faiqi namu qamunna faqa uiqaana maaqaki naaquqara oosiranaki aanaiqikira saika maraidaqa afisifandinna qamunnana faqa mi aiqama ainainna auquaqa. ");
INSERT INTO bjr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Mooseefa mi ufana qima nimisoofaqa faiqí anaasee irisee daraaniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Nifaaqa asasusa mi ainainausa Yaaweena mini amisoofaqa mi ainainausannai Yaaweena uiqaana maqa usakaqau. Yaaweena amooqifandinna ainainausa faqa aanaiqikirausa afisifandinna qamunnausa auqifandinna ainainausa faqa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Faiqí anaasee Yaaweena amirara nidimarusa misa kai nifaaqa auqimaru ainainausa nikiiqa asausi rumbee maru pinnana faqa naaqoo kinaa fidinaanu faqa nisaukuki quqee maru isaaqamana faqa ninukaki rufi maru kukukakana faqa oosana oosana ainaina nifaaqa auqi maruna koorannai auqiranauqa mini Yaaweena amidee qiqa mini quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Akaqausa amiqira qamunna maqeeusa faqa sipsipa asausi dirindaasi akiranee pannoona akiranee faeena akiranee maqeeusa faqa mimmi asausinnai auqira qamunna maqeeusa faqa sipsipa akoona apata faeena akirana maqeeusa faqa ooruku nammariki maru aandauna apata maqeeusa faqa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Siruaa faqa booroosa faqa Yaaweena amirara amanaikusa maree aniqau. Akaqausa akasia saqari Yaaweena uiqaana maqa usakarana amana maqeeusa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Akoofasa anaaseeuqa oosana oosana amiqira sanda sipsipa asausinnai dirindaasianda faqa faeenanda faqa pannoona ariranda faqa sufirana mini quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Misa mimmi asausinnai faqa sufimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Faiqí firaasa aanaiqikirausa uriqarana qamunnasaa faqa amuqusasaa faqa quqaaqeera faraafana ooniuqa faqa firaa feefaura aqimaru amiqira oonisa faqa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Kafaa misa adiafaa imaru ainainausa oosana oosana faqa qooma qumbi maru fadameennana faqa nikiiqa amoondunna adiee maru fadameennana faqa adiafaa ira afudimaru ainaina aindirirana idaki teeqimmasoofanoo adiafaa ira afundi maruna faqa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isaraee maqannaasa faiqí anaasee Yaaweena amirara nidimarusa Yaaweefa Mooseenara auqaanifeera aakapoo ainainausa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mooseefa kaifaa Isaraee maqannaa maaqi qimasee qima niminau. Yaaweefa faiqí moo mina auqu Beesareerana Urina amaaku Hurana anaiqi Yudana atikinaana mara quqeenoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Yaaweefa Beesareerana aiqama amiqira ainaina auqaanifeera narí maraquna afeeka umbiqa amaqeenoo. Aiqama ainaina auqirana akoofasaikirana faqa amanaikirana faqa oosana oosana ainaina amana auqira irirana faqa aminoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Yaaweefa Beesareerana oonu mafi irisee auqara irirana amisaifanoo mifa koorannai faqa siruaannai faqa boroosannai faqa oosana oosana ainaina auqirana akoofasa maridanoo auquannoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Kafaa mifa amiqira ooni ateekeemaria irirana faqa koorannai mi oonina quqarana amaaqa auqira irirana faqa saqarisaa oosana oosana ainaina amana auqira irirana faqa amiqaifanoo auqaannoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ooqooriabana Aqisamakana amaaku Dannana oosanakinaana faqa Yaaweefa inniki quqaqaifanoo mifa faqa Beesareerana dadaaqianifeera maridanoo. Yaaweefa miqanda akaqausa uqannifiqaaqee irirana faqa niminoo. ");
INSERT INTO bjr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Yaaweefa oosana oosana ainaina nisaukunnai auqarana akoofasaikirana nimiqaifaqa maridaqa. Oonisaa akararirana faqa oosana oosana amiqira akara rira irirana faqa amiqira qamunna afundara irirana faqa sipsipa asausi dirindaasi akiranannoo faqa pannoona akiranannoo faqa faeena akiranannoo faa akaqa qamunna auqira irirana faqa niminoo. Nimisaifaqa miqanda oosana oosana ainaina auqira irirana akoofasa qara maridaqa. ");
INSERT INTO bjr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Mooseefa Isaraee maqannaasa qima nimidanoo qinau. Beesareerana faqa Ooqooriabana faqa miqanda dadaaqi marusa oosana oosana ainaina auqirana akoofasaikira irirana Yaaweefa nimiqoosa aiqama ainaina Yaaweefa naamua qundee kai masee naaquqara uiqaana maqa auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Miqi qimaseenoo Mooseefa Beesareerana faqa Ooqooriabana faqa Yaaweefa aiqama ainaina auqira irirana akoofasaikirana nimimaru fasiqausa faqa naarama quqaseenoo qimanniminau. Doo innee oosana arasee auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isaraee maqannaasa Yaaweena amideequu ainainausa mini soo fanoo Mooseefa mi ainainira fasiqausa nimufaqa auqimariqau. Faiqí anaasee eedoo qimasaida aiqama kananaana Anutuna amidee quu ainainausa kaqikai maraidaqa Mooseefunnai munu quqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Naaquqara maqa usakee marusa moomoo ainaina qafamasee nariqa ainainirana minnisee Moosee finnai oonuree qimamiqa qiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Faiqí anaasee moomoo ainaina aabaa faqa maree anidammia. Yaaweefa maasara auqaaqee qimaqaina amana minisee aabaa faqa minisaafannoo kaqi fifau mariannoo. ");
INSERT INTO bjr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mooseefa mina iriseenoo ufa quqasoofaqa aiqamausa qimannimiqa qiqau. Faiqí anaasee sia moo fannoo kafaa moo ainaina naaquqara uiqaana maqa usakaaqeera maree aniaqa. Miqi qimasee qimanimufaqa faiqí anaasee mina iriseeqa sia kafaa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Indaaru mini qoo ainainausa aiqama ainaina taikarana amana faqa fiqaramasee aabaa faqa maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Irirana kaaqa fiqararausa kai indaaruqaa qamunna uiqaana maqasaa akirana auqiqau. Sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa sufusee amiqira qamunna auqusee aqoosa faqaa aandau amana auqusee minasaa atooqasee akuniqau. Miqimmaseeqa minauqannai qisaukuqara taikasee 10 firaa qamunna auqusee moodaanaki akuniqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mi aiqama qamunnausa amana amana kai 12 metres kisaaqa mina qusa 2 metres mariani. ");
INSERT INTO bjr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Mi qamunnausa moodaannai qisauku 5 marasee ootupamasee akuniqau. Dinni qisauku taikasee 5 faqa miqikai iqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Miqimmaseeqa mi qamunna qanda atiqara dirindaasi arira qamunnannai anaanu auqusee moodaanaki ootupaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Firaa qamunna ati mau anaanu 50 auqiqau. Moo qamunna faqa miqi kai iqa moo qamunna saa qaraa anaanu amummaqa kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Koora qumaree turimmandee qusa tafara foora saaeemma qumaree dinni dinni anaanuki upeekasoofanoo mi qamunna qanda moodaaraa maqi inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Uiqaana maqasaa akira qamunna firaana mimmi asausinnai 11 auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Misa aiqama moodaa karirana kai auqiqau. Mina kisaaqa 13 metres amana marianoo mina qusa fannoo 2 metres amana marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Mi qamunnausa moodaannai qisauku taikasee 5 qamunna akunusoofanoo moodaa qamunnaika mafinau. Kafaa moodaannai qisauku taikasee dinni ani moodaa marasee 6 narisaa narisaa akunusoofanoo firaanaikinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Qamunna atimau anaanu 50 akuniqau. Moo atimau faqa mina amummaqa kai akuniqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Booroosannai tafara foora ati saaeemmasee 50 auqusee minannoo dinni dinni anaanuki aususee ootupamasoofanoo moodaa qamunnara foora marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kafaa misa uiqaana maqa akuamaqara qamunna sipsipa akoona apata faeena akiranannai moo auqiqau. Inaaqianna amuaaqa akirana ooruku nammarikinaa aandau apatannai auqirafa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Misa akasia saqarinnai kai naaquqara uiqaana maqa atuna auqusee kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Maaqi mandee maaqa atuna auqiqau. Saqari dinni dinni kuradarafa 4 metres marinau. Mina ausana qusa 66 centimetres amana kai auniriqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Aiqama atuna maqaki rakiqaranara irisee ati ooqiqaramasee ateekaqau. Aiqama maaqa atuna miqi kaimasee ateekaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Misa suani afu ataaqeenni south kisaaqandanai maaqa atuna 20 narisaa narisaa apamandee kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Maaqa atuna oosana sia maqaki kaqi rakiaqau. Siruaannai amaaqa auqusee minaki kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Misa uiqaana maqa suani dinni ataaqeenni north kisaaqandanai maaqa atuna 20 narisaa narisaa apamandee kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Maaqa atuna sia maqaki kaqi rakiaqau. Siruaannai 40 amaaqa auqusee minaki maaqa atuna kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Suani keeqeemari qaannai west uiqaana maqa uruanatinai maaqa atuna dinni qisauku taikasee dinni ani moodaa marasee 6 narisaa narisaa apamandee auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Maaqa dinni dinni munu raqaranaki kafaa qaaraqanda auqusee kuradaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Raudaranaki maaqa atuna oosanaki apammasee kuradama soofanoo amiqimasee narisaa narisaa apinoo marinau. Maaqa atuna rakiqarana oosanaki rumba atukarasee miqi kai mamaree mirinni murufi saqau. Dinni dinni munu raqaranaki miqi kaimmiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Miqimmaseeqa maaqa atuna 8 oosanaki siruaannai qaaraqanda qaaraqanda amaaqa auqusoofanoo 16 marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Misa aunirifandinnana akasia saqari 15 maraqau. Uiqaana maqa dinni dinni ataaqee faqa uruanai faqa faifa faifannoo aunirumasoofanoo maaqa atukarama qumaranau. ");
INSERT INTO bjr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Mi maaqa atunna aunirira saqari fannoo maaqa amana kai dinni dinni ati marinau. ");
INSERT INTO bjr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Maaqa atuna aiqama koorannai kai rafaaqa fiqau. Maaqa atunamau aiqama koorannai kai anaanu mamaree fiqau. Aunirifandinna saqarisa faqa koorannoo mi anaanusaki rafaaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Misa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa sufusee minannai amiqira qamunna auqiqau. Miqimmasee mi qamunnanasaa angiroo niqoosa faqaasa nimana auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Mi qamunnana dirianee qimasee qaara faqa qaara faqa 4 atuna akasia saqari ateekasee koorannai rafaaqafusee kuradaqau. Mina atimau koorannai qamunna dirifandinna anaanusa auqiqau. Mi saqarisa oosanaki siruannai amaaqa auqusee minakiaqa kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Uiqaana maqa kooqiki ititeefandinna qamunnana sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akiranannai faqa marasee kooqiki dirifandinna amiqira qamunna auqiqau. Oosana oosana sandannai mooka maakira ainainauqa mi qamunnanasaa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Mi qamunnana dirifandinnana moodaannai qisauku 5 akasia saqari marasee koorannai mina atimau rafaaqafusee qamunna dirifandinnana anaanu auqusee quqaqau. Mi atunnana qumaraanifeera koorannai saqari kukuqamasee atimau auniriqau. Miqimmasee booroosannai moodaannai qisauku 5 atuna oosana amaaqa auqusee minaki kuradaqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Beesareerafa narí dadaaqi marusa faqa akasia saqari marasee minannai moodaanaki kira bookisa auqiqau. Mina kisaaqa 110 centimetres auqiqau. Mina qusandanai faqa mina kuradarafa faqa amana amana kai 66 centimetres amana auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Misa amiqira koora marasee turimmasoofanoo ausirumafufaqa minannai kai bookisa adisaa faqa aundurai faqa ititaqau. Mi bookisana afaimau koorannai amatookika masee rafaaqafiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Misa koorannai qaindusi fandinnana amaaqa qaara faqa qaara faqa 4 auqusee aiqama aikusaa quqaqau. Dinni aikusaa qaara qanda dinni aikusaa qaara qanda quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Misa akasia saqari qaindusi fandinna qanda koora turimmandee ausiruma qumaree minannai kukuqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Kukuqammaseeqa dinni dinni amaaqa auquqoonaki ausiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Bookisa afu faqa koorannai kai auqiqau. Mina kisaaqa 110 centimetres amana marinau, mina qusa 66 centimetres amana marinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Misa koora turimaseenoo bookisa afu auquseeqa minannai kai dinni dinni qangiroo qaaraqanda nimana auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Afu dinni atinni moo qangiroo amana auqusee dinni moo qangiroo amana auqiqau. Afu faqa mi qangiroo qanda nimana faqa moodaa koorannai kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mi qangiroo qanda bookisa afusaa quqasoofaqa noori narí qafee narí qafee iqa mariqau. Miqanda niqoosa uqeerasoofanoo bookisa afusaa ititanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Beesareerafa akasia saqarinnoo teeboora auqinau. Mina kisaaqa 88 centimetres marinau. Mina qusa 44 centimetres marinau. Mina kuradarafa 66 centimetres marinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Mifa amiqira koora marasee turimmasoofanoo ausiruma fufanoo minannai teeboora rafaaqa fusee kafaa moonnai teeboora atiqara fiqu fiqumma rafaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mifa teeboora atiqara fiqu fiqumma 8 centimetres amana ititasee mina afaimau koorannai rafaaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Mifa koorannai qaindusifandinnana amaaqa 4 auqusee teeboora aiqama aiku namusaa quqanau. ");
INSERT INTO bjr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Teeboora afai ameemaanandanai qaindusirana amaaqa auqinau. Mifa mi anaanusa afai ameemaanai ququseenoo atukaranau. Atukarasainaqa aindusira saqari minaki ausuaqeera atukuranau. ");
INSERT INTO bjr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mifa akasia saqari qaindusifandinna qanda koorannai kukuqinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Mifa amiqira koorannai kai teeboorasaa quqeefandinna pirita kaafausa faqa kisaaqa kaafauqa faqa Yaaweena amifandinna uainna adiara pirita uqnaurirana faqa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Misa qooma qumbira aika amiqira koorannai auqiqau. Misa koora turiiseeqa minannai kai qooma qumbira aika oosana faqa adaka faqa asaanauqa faqa auqiqau. Mi asaanausa saa mi kooranannai kai taatuqee aqama afufeenaari marindee maseeqa kaafara foora afisu amaqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mi qooma aikausa qisauku dinni taikasee dinni ani moodaa marasee 6 marinau. Dinni qaaramoo dinni qaaramoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Aiqama mi asaana namuna atimau koorannai taatuqee aqama afufeenaari marindee masee afaaqa auqiqau. Mi afufeenaarirafa teeqnoorina aqamara foora marufaqa mi asaana namuna saa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Mina adaka saa qaara faqa qaara faqa 4 saa taatuqee aqama teeqnoorina aqamara foora auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Moodaa aqama indaaruqaa asaana qara ameemaanai marinau, kafaa mina murufi asaana qara ameemaanai moo aqama marinau. Kafaa mina murufi asaana qara ameemaanai moo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Amiqira koora turiiseeqa minannai kai qooma oosana faqa asaanauqa faqa afufeenaarirana faqa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Misa amiqira koorannai qoomauqa dinni taikasee dinni ani qaara marasee 7 qooma auquseeqa mi asaanausa atimau quqaqau. Mina ufaqaa faqa danda afaqee mariana faqa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Qooma quqara aika amiqira koorannai 34 kilogram umaara amana kai marasee auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Misa akasia saqari marasee amiqira afundi mari ida munana areefandinna aidarana auqiqau. Mi aidarafa dinni dinni amana kai marinau. Mina kisaaqandanai 45 centimetres marinau. Mina qusandanai miqi kai inoo 45 centimetres marinau. Maqasaa qari ooru firafa 90 centimetres marinau. Mina qara qaara faqa qaara faqa ati moodaa saqarinnai kai burimakau aanaira foora auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Mina afu faqa aanai fooqaana faqa ataaqee qara faqa amiqira koorannai kai rafaaqafusee koorannai mina fiqu fiqumma auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Koorannai qaaraqanda anaanu auqusee dinni moo dinni moo quqasoofanoo qaindusifandina saqarina atukaramma qumaranau. ");
INSERT INTO bjr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Mi qaindusira saqari qanda akasia saqarinnai auqusee koorannai rafaaqafiqau. ");
INSERT INTO bjr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Misa naaquqara fadameenna Yaaweenaindi fee qimasee nikiiqa amoondunna adiee fandinnana auqiqau. Idaki quqasaafanoo adiafaa ira undimari pauraqara amiqira undimari fadameennara foora auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Beesareerafa akasia saqari marasee minannai tatufirana suqara qainda auqinau. Mina kisaaqandanai faqa qusandanai faqa amana amanakai 2.2 metres marinau. Maqa saaqari kuradarafa qaara faqa qaara faqa 4 amana 1.3 metres marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mina qaara faqa qaara faqa 4 atisaa aanaira foora auquqoofanoo marinau. Tatufira qainda moodaa saqari fannoo kai atimau faqa qambaanai faqa aanai faqa moodaa saqarinnai kai auquqoofanoo marinau. Mi aiqama ainainausa booroosannai rafaaqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Mi tatufirana suqee maria qaindanasaa suqee maria ainainausa booroosannai kai auqinau. Danda afaqara futufitauqa faqa savoorauqa faqa uqnaurira piritauqa faqa tafa fooqaa irana ati saaee irana faqa ida qauni afaqee maria futufitausa faqa aiqama booroosannai kai auqinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mifa fukaasaana booroosannai auquseenoo tatufira bookisa aundurai kasaaqai ooqeeqasee qambaanai quqanau. ");
INSERT INTO bjr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tatufira qainda atiqara anaanu qaara faqa qaara faqa 4 auquseeqa bookisa atiuqasaa rumbaqau. Misa aindusi fandinna saqari qanda upeekaaqeera rumbaqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Mifa akasia saqari tatufira qainda aindusifandinnana qaaraqanda maraseenoo booroosannai miqanda rafaaqafinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Mifa akasia saqari marasee anaanu auquqoonaki ausinau. Tatufira qainda indooira saqarinnai kai aundura faqaana auqinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Uiqaana maqa kooqiki dadaaqi maru aanaaseesa nariqa booroosannai auquqoo tanukana Beesareerana amufanoo minannai nammari auqara difaanina faqa mina oosana faqa auqinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Amiqira sanda sufusee auquqaa qamunnanannoo uiqaana maqasaa ququsara foora auqu ititanau. Suani afu dinni ataaqeenni (south) mina kisaaqa fannoo 44 metres marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Mi qamunnana dirifandinnana booroosannai dapu 20 auqusee mina kuradeefandinnana amaaqa miqi kai masee 20 auquseeqa siruaannai tafara foora mina amana kai auqusee aunirifandinna saqarina faqa minannai kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Suani afu dinni ataaqeenni undee kai iqa dinni ataaqeenni faqa miqi kai miqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Suani keeqee maru qaannai dapu qusandanai mina kisaaqa 22 metres marinau. Mina dapu saqari 10 faqa mina amaaqa auqirafa faqa 10 kai marinau. Qamunna dirifandinnana tafarafoo iranauqa faqa aunirifandinna saqarisa faqa siruaannnai kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Suani oosana qaannai kooqi marutinai aqa uruanai inoo maruna amana kai 22 metres marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Mi kooqina dinni dinni dirifandinna qamunnafa 6.6 metres marinau. Mi kooqina dinni dinni qaaramoo dapu faqa mina amaaqa faqa dinni dinni qaaramoo faqa mina amaaqa faqa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Aiqama qamunna dapusaa dirinoo marufa amiqira qamunna kai auqirafa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Aiqama dapu fiqu fiqu irafa siruaannai rafaaqa fuqaa saqarinasaa ootupanoo marinau. Minasaa qamunna dirifandinnana tafara maqi iranauqa siruaannai kai auqiqau. Mina dapu atimau faqa siruaannai kai rafaaqa fiqau. Mi saqarisa rakiqeefandinnana amaaqauqa booroosannai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kooqisaa ititara qamunna amiqirafa marinau. Misa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akiranannai faqa sufusee mi qamunnana auqiqau. Auquseeqa amiqira sandannai oosana oosana ainaina amana auqiqau. Mi qamunnana kisaaqa fannoo 9 metres marinau. Mina qusa fannoo 2.2 metres marinau. Mi kooqina qamunna dapu rakiqarana amana kai marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Misa mi qamunnana dapu saqari qaara faqa qaara faqa kooqiki rakiqaranasaa diriqau. Mi dapusa oosanaki booroosannai amaaqa auqusee minaki rakiaqau. Mi dapusa ati rafaaqafirana faqa auni rumaqaa saqarisaa faqa tafara foora iranauqa faqa siruaannai kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Uiqaana maqa atimau apupuka arifandinna aikausa booroosannai kai auqiqau. Uiqaana maqa dapu rakiqarana qumaraanifee qimasee apupuka aqoosai faqa afuqai faqa aruqaafa aiqama booroosannai auqira apupuka kai marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Yaaweena uiqaana maqaki qaara oonisaa qisaukuqara 10 sanda ufa akara rirafa marinau. Mi maqanaki ainaini maruna koora faqa siruaa faqa booroosa faqa marinau. Aanaiqikirana Aaroona amaaku Itamarafa Reefina aiku asauku qimannimi marufaqa misa mi koora ainainausa asaana rumasee akara rimariqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Beesareerafa Urina amaaku Hurana anaiqi Yudana ati marufa mifa aiqama ainaina Yaaweefa Mooseena qimamundee kai masee auqinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Mina dadaaqi marufa Ooqooriabafa marinau. Mifa Aasamakana amaaku Dannana ati marinau. Mifa oonisaa oosana oosana ainaina amana auqi marufa marinau. Mifa sipsipa asausi dirindaasi akiranannai faqa pannoona akiranannai faqa faeena akiranannai faqa amiqira sanda sufusee amiqira qamunna auqimarufa marinau. Kafaa mifa oosana oosana ainaina amana auqirana akoofasa marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Aiqama koorauqa naaquqara uiqaana maqa usakarara Yaaweena amidee qufa mina ummaara uiqaana maqakinaa ainainauqa amana masee qafee maru sikeerana amana 998 kilogram maree aniqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Aiqama fasiqauqa 20 aukuana faqaasa nuqu marasoofaqa misa nambaqa 603, 550 fasiqauqa takisa munnimma aqi mariqau. Mi takisana aqusoofaqa mi siruaana qumaree uiqaana maqa sikeerasaa diriseeqa qafoofanoo 3,430 kilograms marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Maaqa atuna oosana amaaqa auqirafa 100 marinau. Mi siruaana moodaanaki asaana rumasoofanoo 3,400 kilograms marinau. Naaquqara uiqaana maaqaki qamunna diri maru saqarisa rakiqarana amaaqa faqa maaqa atuna rakiqarana amaaqa aiqama moodaa moodaa 34 kilograms kai marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Miqimmaseeqa akaqa siruaa 30 kilograms amana kaqi marunannoo aunirira saqari faqa atuna rakiqarana ati mau faqa qamunna dirirana tafara maqi irana faqa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Yaaweena amu booroosana umaara fannoo 2,425 kilograms marinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Mi booroosanannai Yaaweena uiqaana maqa kooqiki saqari rakiqarana amaaqauqa auqiqau. Aandau tatufira qainda faqa mina fukaa asaana faqa minaki suqee maru ainainausa faqa minannai kai auqinau. ");
INSERT INTO bjr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Dapu saqari rakiqarana amaaqauqa faqa kooqi saqari rakiqarana amaaqauqa faqa uiqaana maaqa apupukauqa faqa dapu fiqu fiqu irana apupukauqa faqa aiqama mi booroosanannai kai auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Misa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa marasee aanaiqikirausa naaquqara oosiranaki ainainiaqeera amiqira qamunna auqiqau. Aaroona aanaiqikira qamunna faqa Yaaweefa Mooseena qimamundee masee auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Misa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa koora sanda faqa sufuseeqa eefooda qamunna auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Misa koora turiisoofanoo adamanaika mafufaqa tiritandara foora aukiiseeqa sipsipa asausi dirindaasi akirana faqa pannoona akirana faqa faeena akirana namu faqa sufuseeqa amiqira qamunna auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Eefooda qamunna anaanu qaaraqanda fannoo aururusaa aakandianinnana auqusee eefooda qamunnasaa dinni dinni rumbaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mina ooiqanda ianinnana amiqira qamunnannai eefooda qamunna auqundee kai masee auqiqau. Mifa eefooda qamunnasaa akunirafa marinau. Yaaweefa Mooseena qimamundee kai iqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Eefooda anaanusaa akumaaqa ooni qaaraqanda pupu ooni marasee dinni aanaanusaa moo dinni aanaanusaa moo quqasee Yakooboona faiqi namu qisaukuqara taikasee qikunni ooqu qaara marasee nuqu mi ooni qandasaa akara riqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Miqimmasee aururusaa eefooda qammunna aakandammasoofanoo Yakooboona faiqi namu qisaukuqara taikasee qikunni ooqu qaara marasee 12 Isaraee maqannaasa kikiqa usinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Eefooda qamunna auqu ainainausannoo kai amuqusasaa rumbara qamunna auquseeqa moodaa karira akara kai riqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Mi qamunnana tukaandasoofanoo aiqama ati amana amana kai 22 centimetres marinau. ");
INSERT INTO bjr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Misa ooni amiqirana firaa feefauru aqimariana kai marasee qaara faqa qaara faqaki mi qamunnanasaa padiqau. Indaaruqaa padiranaki moo ooni auqu rubi faqa moo ooni toopasa faqa moo ooni ganeeta faqa minamuna padiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Mina aanaaqianna padiranaki moo ooni auqu eemeerara faqa moo ooni auqu safairee faqa moo ooni auqu daimanna faqa minamunannai padiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Miqanda muqufi padiranaki moo ooni auqu teerakoisa faqa moo ooni auqu agatee faqa moo ooni auqu ameetisa faqa minamunannai padiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Inaaqiana atimau padiranaki moo ooni auqu beerira faqa moo ooni auqu kanirianna faqa moo ooni auqu yasapaa faqa minamunannai padiqau. Mi oonisa koorandannai amuqusasaa maru qamunnanasaa isooqa araqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Mi oonisa moodaa moodaa ooni fannoo Yakooboona faiqi namu qisaukuqara taikasee qikunni ooqu qaara marasee 12 Isaraee maqannaasa kikiqa usinoo marinau. ");
INSERT INTO bjr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Misa nimuqusasaa rumbarana aanaanu amiqira koorannai auqira sandannai seenandara foora auquseeqa moodaanaki quqasee afundasee dinni dinni ati saa qusiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Koorannai anaanu qaara qanda auqusee amuqusasaa rufuaninna qamunnana mirinni atisaa qara qusiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Qaaraqanda seenanda koorannoo afundaranannai mi anaanu qandaki qusiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mi sandana ati qarannai aururusaa koorandannai ooni isooqa aruqaanaki ootupaaqa. Miqimmasoofanoo aururusaa eefooda qamunnasaa rumbanau. ");
INSERT INTO bjr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kafaa nimuqusasaa rufimariana anaanu qaara qanda koorannai auqusee aunduraindari atisaa mi anaanuna rumbasoofanoo eefooda qamunna mammaaqai marinau. ");
INSERT INTO bjr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kafaa qaaraqanda aanaanu koorannai auqusee afunni qumu maru eefooda qamunnanasaa aqaasanai amiqira qamunnannai sufirana ooiqandi maruna aakaariqara rumbaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Nimuqusasaa diri maria qamunnanasaa anaanuki dirindaasiandannai sufira sanda usuaki eefooda qamunnasaa qaraa anaanuki ususee rumbaqau. Miqimmasoofanoo amuqusasaa ititara qamunna sia kasi kasinau. Yaaweefa Mooseena qimamundee kai iqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Misa eefooda qamunna meeaqoo qaraana auqirara dirindaasi akira sipsipa asausinnai kai qamunna kisaaqa auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Misa anuka amaaqa auqiqau. Qamunna raqandaammasee akunusoofanoo anuka upeekoofanoo sia anaqinau. ");
INSERT INTO bjr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Mina ati mau raqandaammasee akunuseeqa saqari aqama faqa kaqikaa biru koorannai auqirana faqa mina atimau qusiqau. Dirindaasi akira sipsipa asausi faqa pannoona akiranannai faqa faeena akiranannai mi saqari aqamana amana auqiqau. Auquseeqa mi saqari aqamana aaqa koorannai auqira biru faqa qamunna atimau moo mafi quqee moo mafi quqee iqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","Misa sipsipa asusi dirindaasi akirana faqa pannoona akirana faqa faeena akirana faqa tirita uqanna namu faqa sufusee Aaroona narí faiqinamu siutauqa faqa Aaroona uriqarara qata faqa mina faiqinamu kaqikaa qatauqa faqa auqiqau. Auqusee ooiqanda ianinnana minannai kai auquseeqa oosana oosana akarannoo afaaqa auqiqau. Miqimmaseeqa misa tarausisa tirita uqannannai auqiqau. Yaaweefa Mooseena qimamundee kai iqa aiqama ainaina auqiqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Misa amiqira koorannai niqinaaqa rumbeemaru doodapaaninara foora auqusee minasaa Anutunaindi fee qimasee akara riqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Misa doodapaani dirindaasiandannai auqirana marasee qatasaa quqasee akuniqau. Yaaweefa Mooseena qimamundee kai iqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Miqimasee Yaaweena uiqaana maqa taikaqau. Isaraeena aiku asauku Yaaweefa Mooseena qimamundee kai aiqama ainaina iqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Misa uiqaana maqa faqa mina rafaaqa fimaria qamunnana faqa mina anaanu faqa mi maqana usakara atunauqa faqa aunirira saqari faqa oosuki faqa kooqiki faqa rakiqee fandinna saqarisa faqa saqari maqaki rakiqarana amaaqa auqirana faqa maree Mooseefa marunnai munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Sipsipa akoona apata faeena akirana minannai uiqaana maaqasaa akirana faqa ooruku nammarikinaa aandau apata uiqaana maqasaa akirana faqa kaaqa naaquqara oosiranaki ititara qamunna faqa maree munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Misa moodaaniki kira bookisa qaara ooni minaki maruna faqa mina afu faqa mina qaindusira saqari qara faqa maree munu Mooseefa unnai quqaqau ");
INSERT INTO bjr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Misa aiku faqaa qainda faqa minasaa mari ainainausa faqa Anutuna afusaa quqara feemu faqa maree munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Misa amiqira koorannai auqira qooma saqari faqa mina qoomauqa faqa mina oosana oosana ainainauqa faqa mi qoomausa fadameena faqa maree munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Koorannai auqira aidara faqa Yaaweenaindi fee qimasee utaaqama amaqasee adia nimaqee maria fadameenna faqa afundi mari pauraqana faqa uiqaana maqaki kooqi ititara qamunna faqa maree munu quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Booroosannai auqira aidara faqa mina fukaa asaana booroosannai auqirana faqa mina qaindusira saqari qara faqa mina oosana oosana ainaina faqa nammari adiee maria difaanina faqa mina oosana faqa maree muna Mooseefa unnai quqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Dapu qamunna faqa dapu faqa dapu oosana amaaqa auqirana faqa dapu kooqi qamunna faqa dapu sanda faqa apupuka faqa aiqama ainaina naaquqara uiqaana maaqa aundurai auqee maria ainainausa faqa maree munu Mooseena uqafiqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Minauqa munu uqafiqaseeqa Aaroona naaquqara qamunna faqa narí faiqi namundi faqa naaquqara maqaki ainainidaqa afisifandinna qamunnana amiqirana munu Mooseena uqafiqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isaree maqannaasa Yaaweefa Mooseena qimamundee kai masee aiqama ainaina auqaqau. ");
INSERT INTO bjr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mooseefa aiqama ainaina aiququ masee qafamaseenoo Yaaweena irirana mau kai auqeeaafoo qimaseenoo amiqi amiqimma nimaqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yaaweefa Mooseena qimaminoo qinau. ");
INSERT INTO bjr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Indaaruqaa quqoonasaa indaaruqaa faasaana innee qini naaquqara uiqaana maqa oosana arasee usakaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Moodaanaki kira bookisaki qisaukuqara taikasee 10 sanda ufa marina kaaqa naaquqara oosiranaki quqasee ititee fandinnana firaa qamunna marasee minasaa ititaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Aikufaqaa qainda maree mini quqaseeqa minasaa ainainifandinna ainainausa minasaa mini quqaaqa. Qooma saqari faqa mini quqaseeqa mina qoomauqa mina ati mau quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Quqaseeqa koorannai auqira aidara amiqira afundi mari pauraqana suqee mariana mareeqee maamiqoo oosiranaki moodaanaki kira bookisa amummaqa quqaaqa. Quqaseeqa kooqiki ititee maria qamunnana maraseeqa kooqiki diriaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Qaidara firaana aandau tatufirana suqee mariana uiqaana maaqa kooqi amummaqa ququsaki quqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kafaa nammari difaani mareeqee maaqa kooqi dinni firaa qaidara dinni qambaana quqasee nammari adia umbiqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ququsa dapu uiqaana maaqa aru fiqu fiqumma datimasee kooqiki qamunna diriaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Yaaweefa Mooseena kafaa qimaminoo qinau. Qini naaquqara fadameena maraseenana uiqaana maaqa faqa minakinaa aiqama ainaina qini utaaqama qimaqaranasaa rurufa masainanoo naaquqanoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Miqimmaseenana firaa aidara aandau tatufirana suqee mariana faqa minasaa qaraa ainainauqasaa faqa mi fadameenna rurufa masainanoo kaaqa naaquqanoo mariani. ");
INSERT INTO bjr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nammari difaanisaa faqa mina oosanasaa faqa miqi kai iaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Miqi masee Aaroona narí faiqi namu faqa nifiqamaree uiqaana maqa kooqiki munusainaqa nammari auqaaqa. ");
INSERT INTO bjr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Auqamasaifana aanaiqikirausa qamunna marasee Aaroona afisu amaqasee qini utaaqama qimaqara fadameena akiiqa amoondunna rurufammasainanoo naaquqanoo maridanoo qini aanaiqikira saikaki mariani. ");
INSERT INTO bjr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mina faiqi namu nifiqee miniseenana aanaiqikirausa qamunna afisu nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Miqi maseenana Aaroona ianandee inana mina faiqi namu faqa fadameena nikiiqa amoondunna rurufamma nimaqaa. Miqimmasainaqa qini aanaiqikira saikaki mariaqa. Mi fadameenafa misa naaruara qini aanaiqikira saikaki marirana nimiannoo. ");
INSERT INTO bjr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mooseefa aiqama ainaina Yaaweefa qimamundee kai masee auqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Isipa maqa maaqa kiqari anukari moo aukuana aiqaroofaqa moo aukuana indaaruqaa uqoona mina indaaruqaa faasaanasaa Yaaweena naaquqara uiqaana maaqa usakaqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mooseefa qufaqa uiqaana maaqa atuna amaaqauqa maqaki quqaseeqa maaqa atuna minakiaqa kuradamasee ausana auni rumasee kooqindanai atuna faqa rakiaqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Rakiqaseeqa indaaruqaa qamunna qairi akuseeqa mina amuaaqa qaaramoo mina rafaaqafuanifeera qairi akiqau. Yaaweena ufamau kaimbiqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Mooseefa sanda ufa akararira ooniqara bookisaki quqaseenoo mina aindusira aikaqara anaanuki upeekaseenoo mina nifauara afu rafaaqafinau. ");
INSERT INTO bjr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Rafaaqafuseenoo mi bookisana mareeqeenoo uiqaana maqaki quqaseenoo qamunna qumareenoo dirisoofanoo minasaa itita amaqanau. Yaaweena ufamau kai miqinau. ");
INSERT INTO bjr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mooseefa aiku faqaa teeboora mareeqeenoo naaquqara oosiranaki suani afu dinni ataaqeenni North quqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Quqaseenoo mi teebooranasaa Yaaweena amiraree qu feemuna quqaqoofanoo marinau. Yaaweena ufamau kai finau. ");
INSERT INTO bjr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Miqi maseenoo Mooseefa qooma saqari uiqaana maqaki suani afu dinni ataaqeenni (South) maaqa atuna mammaaqai quqanau. Dinni taatatai aiku faqaa teeboora quqasee dinni taatatai qooma saqari quqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Yaaweefa qumi maru uiqaana maqanaki qooma saqari quqasee qumbisoofanoo qanau. Yaaweefa qimamundee kai inau. ");
INSERT INTO bjr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Miqi maseenoo Mooseefa koorannai auqira qaidara mareeqeenoo uiqaana maqa maamiqoo oosiranaki ititaqoo qamunnana aaqa quqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Quqaseenoo mifa amiqira afundimaruna andaana rirana quqaseenoo idaranau. Yaaweena ufamau kai finau. ");
INSERT INTO bjr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mifa uiqaana maqa kooqiki qamunna d irinau. ");
INSERT INTO bjr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Diriseenoo tatufirana suqee maru qaidarana uiqaana maqa kooqi amummaqa madaanai quqanau. Quqaseenoo Mooseefa aandau tatufirana faqa sakuma fooqaa irana qaindi rirana faqa tatufinau. Yaaweena ufamau kai miqinau. ");
INSERT INTO bjr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Miqi maseenoo Mooseefa nammari difaani madaanai qaidara mianni marufanoo uiqaana maqa kooqi murunni marufanoo qambaana quqanau. Quqaseenoo nammari minaki adia qumbiqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mi nammarinaki Mooseefa faqa Aaroonafa narí faiqi namu faqa mi nammarinaki niku nisauku nammari uqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Misa uiqaana maqaki keeqararee qimasee fee tatufira qaidara aaqa firaree qimasee fee mi nammarinaki niku nisauku nammari uqusee fimariqau. Yaaweena ufamau kai miqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Miqimma taikaseeqa Mooseefa qufaqa uiqaana maqa faqa firaa qaidara faqa ququsa dapu fiqu fiqumma rakiqaqau. Rakiqaseeqa dapu kooqiki faqa qamunna ititaqau. Miqimmasee misa Mooseena faqa aiqama ainainirana taikaqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Miqi masoofanoo qasuru fannoo uiqaana maqa dukunimambufanoo Yaaweena kaaqa qara daroo daraa irafa uiqaana maqaki qumbiqa finau. ");
INSERT INTO bjr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Miqimmafunara Mooseefa sia uiqaana maqa keeqanau. ");
INSERT INTO bjr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Qasuru fannoo uqeeree fukari kai Isaraee maqannaasa nári uiqaana maqa faqa Yaaweena uiqaana maqa faqa aiqama ainaina faqa tatu maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Qasuru fannoo kaqi miqoo marufaqa misa faqa kaqi miqoo mariqau. ");
INSERT INTO bjr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Isaraee maqannaasa fida marufanoo qasuru fannoo aiqama faasaana Yaaweena uiqaana maqa akiiaaqa marinau. Aiqama eendaki idauruara foora mina akiiaaqa marufaqa qafee mariqau. Miqinoo marufaqa fifiiufaqa Yaaweefa nimiraree qu maqa maaqanaki oonu raqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_1","018_1_1","EST","1","1","2","Serkisisafa Peereesia maqa maaqaki kinna maru aukuana mifa Susa maqusaki narí kinna siaqa ufiqiseenoo ooqu marifinoo 127 maqa maaqa rakisi marinau. Suani afu uri maru qaannai India maqa maaqaki oosana araseenoo suanafu keeqee maru qaannai Itiopia maqa maaqaaki dinni ati oonu marinau. ");
INSERT INTO bjr_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Mifa qaarammoo aukuanaki kinna maridanoo aiqama kiapausa faqa kaammanna uriqararausa faqa aiqama maqa maaqaki marusa faqa firaa oomaqa sakasaida nee marinau. Peereesia maqa maaqaki faqa Midia maqa maaqakinaa ammiuqa faqa mi firaa oomaqanaki ani mariqau. Rakisirausa faqa firaa fasiqauqa faqa aiqama maqa maaqaki marusa misa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Mi naranafa qisauku dinni taikasee dinni oonu moodaa marasee 6 uqoonaki marinau. Marufanoo kinna fannoo narí aiqama munnimma faqa narí maaqa afaaqa auqirana faiqi anaasee quqannifiqanau. Quqannifiqasoofaqa misa mi ainainausa qafoofanoo kaaqa amiqirafa uriqaranoo uqanna marinau. ");
INSERT INTO bjr_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Mina anaaqiana kinna fanoo moo firaa oomaqa narí uqusaki narí maaqa adeedi sakanau. Mi oomaqafa aiqama Susaa maqusaki maru fasiqausa ainaina faqaasa faqa ainaina siaisa faqa misaindi marinau. Marufaqa misa moodaa amaana aundurai naida mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Mitinai misa narana nee marunnai amiqira tida marinau. Ooqai faiqi misa taatuqee ooninnai faqa eekara ooninnai faqa dirindaasi arira ooni faqa kinnaa ooniuqa misa rarai fee qimasee auqu ree maruna mookira ooni tanukaida qeemaruna faqa maqasaa padimmaseeqa minasaa tida auqiqau. Misa mi tidanasaa oomaqa naani qimasee eekara arira qamunnainnai faqa dirindaasi arira qamunnanai faqa afaaqa auqusee amiqira sandannai rumbaqoofanoo marinau. Misa mi sandanannai siruaannai auqira rinna amiqira ooni pausasaa rumbaqau. Misa miqoo koorannnai faqa siruaannai faqa auqira kisaaqa siaqauqa ufiqisaidaqa minasaa ooqu marifidaqa narana nee mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Faiqi misa mooka maakira koora kaafaki nammari nee mariqau. Nee marufanoo kinna fannoo moomoo uainna mi fasiqausa nimi marinau. ");
INSERT INTO bjr_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Sia misa neefandinnana asaana riqau. Kinna fannoo narí maaqaki ainaini maru faiqisa qimannimufaqa misa nári nidiranasaa moodaa moodaa fasiqa nammari nimi mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Mikari Kuinna Wasti nammarifa aiqama anaaseeuqa faqa kinna maaqaki firaa oomaqa sakasee nee mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Qisauku dinni taikasee dinni oonu qaaraqanda marasee 7 faasanasaa mi firaa oomaqanaki kinna fannoo kaqi kaaqoo uqanna uainnasaa furufarinau, furufarinoo mifa narí maaqaki ainaini maru faiqisa qisauku dinni taikase dinni oonu qaaraqanda marasee 7 naaroofaqa aniqau. Misa nuqu maaqimminoo marinau. Meehummafa faqa Bistaafa faqa Aboonnafa faqa Bitaafa faqa abaktaafa faqa Seetarafa faqa Karkasaafa faqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","Kinna fannoo misara kuinna Wasti nammarina afiqee aniaqee qimaseenoo qimanniminau. Kuinna Wasti nammarifa narí kuinna qafee afisu maree aniani. Kuinna Wasti nammarifa amiqira manaaqa uqanna marufanoo minara kinna fannoo kiapausa faqa aiqama mina firaa oomaqaki ani marusa uqannifiqarara aaranau. ");
INSERT INTO bjr_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Mi ainainira faiqisa oonu kuinna Wasti nammarina kinna qu ufana qimamufanoo kuinna fannoo sia anufanoo minara kinna firaaqoo uqanna aranaqanau. ");
INSERT INTO bjr_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Mifa irirana faqaa fasiqauqa naroofaqa anireeqa kuinna faqa auqaaninna ainainara qimamiqau. Kinna fannoo irirana faqaasa iramiriseenoo misa qimamundeemmasee narí sandufaki ainaini maruna faqa faiqi anaasee ooqu marirana faqa andeeqanau. ");
INSERT INTO bjr_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Mi fasiqausa nuqu maaqimminoo marinau. Kareesanafa faqa Seetaraafa faqa Atmataafa faqa Tarasisaafa faqa Meereesafa faqa Maraseenafa faqa Meemukanafa faqa mariqau. Misauqa qisauku dinni taikasee dinni oonu qaaraqanda marasee 7 nikiiqa fasiqauqa Peereesia maqa maaqaki faqa Midia maqa maaqaki faqa aiqama kinna rakisi maru maqa maaqanaki misa uriqarara kaammanna mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Mifa mi fasiqausa maaqi qimasee qimanniminau. Qinee kinna Seerkisisasa eeqá maaqaki ainainimaru faiqisa niiqaafanaqa oonu kuinna Wasti nammarina qimamifanoo qinee qimamianna ainainausa auqaanifee qiafananoo mifa qini ufa rukioofanoo qirana qanau. Sandufa fannoo minara naqaa fee qidanoo fee. Innisaimbaqa kuinna naqaa feemma amaqaanauree. ");
INSERT INTO bjr_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Meemukanafa kinna narí oofisaa faqa maaqi qimasee qimanniminau. Rakisirafa anee iria, kuinna Wasti nammarifa sia anikai fau mandaikamma amaqeenoo fau. Mifa aiqama uriqarara fasiqauqa faqa aiqama ani maqa maaqaki maria fasiqausa faqa mandaikamma nimaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Qusasaa uqanna aiqama anaaseeuqa anee rakisi marianna maqa maaqanaki mariasa misa kuinna mi oosanna auqainara irifaranoo. Iriseeqa misa maaqi qifaranoo, kinna Seerkisisafa kuinna Wasti nammarifa oonu mina qafaanifeera qufanoo kuinna fannoo kinna ufa rukiasee sia finau. Miqi kai iqa anaaseeuqa faqa nári nifaaqmaaka ufa rukieefaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Mi faasanna kai uriqarara fasiqauqa Peereesia maqa maaqaki faqa Midia maqa maaqaki faqa marusa ninaaqmaaka kuinna mi oosanna auqoo ufana irisee misa mi ainannara nári nifaaqmaaka qimannimisee mi anaseesa moomoo mandoosana faqa mandufa faqa qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Rakisirafa anee irinanoo amiqinana, anee moo ufa maaqi qimasee faiqi anaasee iannai uqaa. Wasti nammarifa sia kaifaa ani ani qafaani. Mi ufana Peereesia maqa maaqakinaasa faqa Midia maqa maaqakinaasa sandufa mari papiqanaki akara ruaqa. Akara rumasaifanoo mi sandufafa sia amana taikaannoo. Minara anee Wasti nammarina mara aqusee moo amiqira manaaqa mara uqasainanoo mifa kuinna mariani. ");
INSERT INTO bjr_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Mikari ani mi ufafa aiqama anee rakisi marianna maqa maaqausaki daraani mafinaqa aiqama anaaseeuqa nári nifaaqmaaka nuqu faqaasa faqa nuqu siaisa faqa misa ufa amiqimmasee irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Kinna narí uriqarara fasiqauqa faqa misa mi ufanara nidufanoo kinna fannoo Meemukanafa qundee inau. ");
INSERT INTO bjr_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Kinna fannoo narí rakisi maru maqa maaqausakiaqa papiqa quqasoofanoo fifaininau, mifa aiqamausa nári ufakiqari papiqa akara ruma nimaqanau. Akara ruma nimaqaseenoo mifa maaqi qinau, faiqi fannoo kai narí faiqi anaasee rakisiannoo. ");
INSERT INTO bjr_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Mikari kinna aranaqarafa kaqikaaqoo taikoofanoo mifa kaifaa Wasti nammarifa mandaikamma amaqoo oosannara oonu mafi irinau. Iriseenoo mifa Wasti nammarina aiqamasainanoo mifa sia kaifaa kuinna mariannoo fee qu ufanara oonumafi irinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Akaqa fasiqauqa mina amiqira irirana amimarusa mina aaqa ooqufaaqeeidaqa maaqi qimasee mina qimamiqau, rakisirafa anee akaqa amiqira manaaqauqa sia faiqi faqa faiqama qaasara randaannee qiqau. ");
INSERT INTO bjr_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Anee rakisi marianna maqa maaqanakinaa fasiqauqa mara uqasainaqa misa amiqira manaaqauqa sia faiqi faqa faiqama qaasa nifiqamaree kaammanna uriqarara taunna Susaa maqusaki minisee anee manaaqauqa suqu uqee marianna maaqanaki misauqa mini uqaaqa. Uqasaifanoo Eekaifa ani ainainira faiqi ani anaaqmaakasaa rakisi marifa mifa misasaa rakisiani. Rakisi marinaqa anaaseeuqa misa fadameena akunnimaqaseeqa misa nifaaqa auqusaifaqa misa kaaqa amiqirausa uqanna mariaqa. ");
INSERT INTO bjr_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Marifana anee mi manaaqausa kinaana moodaa ani aidi marinnana mareeqee uqasainanoo mifa kuinnaika mafinanoo kuinna Wasti nammarina amaaqa maqaani. Miqi qufanoo kinna fannoo iriseenoo mi ufanara eedoo qimaseenoo afaqanau. ");
INSERT INTO bjr_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Susaa maqusaki Yuda maqannaa fasiqa moo marinau, minauqu Moodeekaifa marinau mina akoona auqu Yairafa marinau. Yairafa Kisaana amaaku Simeena anaiqi Beensamina atikinaafa marinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","Ooqai Babiroonnia maqannaasa kinna Neebukatneesafa Yuda maqannaasa kinna Yeeoiakina faqa Yuda maqannaasa akaqausa faqa nifiqeenoo Babiroonnia maqusai mariaqeera finau. Mifa Moodeekaina aiku asauku faqa nifiqoo faqa misa faqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Moodeekaifa moo manaaqa rakisi maruna minauqu Eestaa nammarifa marinau. Minauqu Heeburu ufakiqari Adasanee qimariqau. Eesta nammarifa Moodeekaina akoona akaqa araamuna marinau. Mina akoofa narí anaaqa faqa kuqufufanoo Moodeekaifa Eestaa nammarina maraseenoo narí faiqiara foora rakisi marinau. Rakisi marufanoo Eestaa nammarifa kaaqa amiqira manaaqa uqanna findifi marufaqa qafoofanoo amiqirafa uqanna marinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Kinna Seerkisisafa narí oofisaauqara moomoo amiqira manaaqauqa nifiqamaree Susaa maqusai aniaqee qimasee ufa quqanau. Ufa uqasoofaqa misa manaaqauqa nifiqee anidaqa misa Eestaa nammarina faqa afiqee aniqau. Miniseeqa misa Eeataa nammarina kinna uqusaki manaaqauqa maru maaqanaki uqaqau. Uqasoofanoo Eekaifa mi manaaqausasaa rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Eekaifa Eesta nammarina qafoofanoo amiqira manaaqa marufanoo minara aidi marinau. Aidufanoo mifa kai kaqi ufanoo Eestaa nammarifa afaaqa auquaninna fadameena mainainausa faqa oosana oosana amiqira narana faqa aminau. Amiseenoo mifa kinna maaqaki marusara Eesta nammarinasaa amiqimmasee rakisiaqee qimaseenoo mara uqanau. ");
INSERT INTO bjr_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Indaaru Moodeekaifa Eesta nammarina qimaminau, anee sia aneenara Yuda maqanaa manaaqa maridee qimasee koorooiannee qu ufana Eesta nammarifa narí rakisi maru akoona mi ufana afaqeenoo sia qimaminau. ");
INSERT INTO bjr_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Aiqama faasaana Moodeekaifa anaaseeuqa maaqa maru uqusana kooqindanai oonuree aniree inoo nimarinau. Mifa Eesta nammarifa naqaa fee masee marinaqee irianauree misa Eesta nammarina naqi feemma amaqaifaqee irianauree qimasaidanoo oonuree aniree imarinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Moodaa aukuana aundurai misa manaaqauqa rakisi marufaqa amiqirausa uqanna kambiqee mariqau. Kambiqee marufaqa misa qisauku dinni taikasee dinni oonu moodaa marasee 6 uqoonaki misa meea saqari anoonnai auquqoo fadameena amiqira afundi maruna mi manaaqausa nifaaqai akunnimaqee mariqau. Akunnimaqasee moo 6 uqoonaki misa fadameena faqa ainoo faqa amiqira afundi maruna akunnimaqee mariqau. Miqimmasee inaaqianna misa aiqama manaaqauqa moodaa moodaa nifiqa maraida kinna Seerkisisafa marunnai fimariqau. ");
INSERT INTO bjr_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Manaaqa moo fannoo kinna maaqai fuani qimaseenoo narí aidiranasaa afaaqa auqu mareenoo fimarinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Manaaqa fannoo eendi marufanoo kinna marunnai oonu mariinoo iaqee marinau. Iaqasoofaqa kananaana mina afiqamaree anaaseeuqa maaqa mooki munu Saskasana asaukuki uqaqau. Mi moodaa fasiqafa kai kinna inaaqianna anaaseeuqasaa rakisi marinau, rakisi marufaqa mi anaaseesa sia kaifaa kinna oonu qafee mariqau. Kinnna fannoo moonara aidinanoo mina auquramasee aarainanoo mifa amana fuannoo, sia moo aana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Eesta nammarifa kinna qafaaninna faasaanafa aniranau. Eesta nammarifa Moodeekaina akoona akaqa Abiairana araamuna marufanoo Moodeekaifa Eesta nammarina maraseenoo narí araamunara foora rakisi marinau. Rakisi marufaqa aiqama fasiqauqa Eesta nammaria qafee marufanoo kaaqa uqanna minara nidi marinau. Mikari Eesta nammarifa kinna qafarara finoo sia narí aidiranasaa qamunna afisinau. Manaaqauqa rakisirafa Eekaifa qimamundeemmasee qamunna afisinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Mikari Seerkisisafa qisauku dinni taikasee dinni oonu qaara marasee 7 aukuanaki kinna marinau. Mi aukuannanaki qisakuqara taikasee 10 uqoona misa auquree Teebeeta uqoonafee qimariqau. Mi uqoonnanaki misa Eesta nammarina afiqee kinna marunnai fiqau. ");
INSERT INTO bjr_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Munusoofanoo kinna fannoo firaaqoo uqanna Eesta nammarinara aidinau. Mifa sia akaqa manaaqauqara aidi marundeemmaseenoo Eesta nammarinara aidinau. Mifa Eesta nammarina qafoofanoo akaqa manaaqauqa urinnaaqaramaseenoo kaaqa amiqirafa uqanna marinau. Sia moo manaaqa fannoo Eesta nammarifa kinna aqaararana amundee iannoo. Minara kinna fannoo mina akiiqaki kuinna qafee afisu amqanau. Afisu amaqasoofanoo Eesta nammarifa Wasti nammarina amaaqa maqaseenoo kuinnaikinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Kinna fannoo Eesta nammarinara asasidanoo firaa oomaqa sakaseenoo nanau. Mifa aiqama uriqarara fasiqauqa faqa kiapausa faqa naaroofaqa mi firaa oomaqanaki aniqau. Aniroofanoo mifa qinau aiqama fasiqa anaasee qini maqa maaqaki mariasa misa maa faasaana idooaidaqa. Miqi qimaseenoo kinna fannoo moomoo amiqira ainaina faiqi anaasee niminau. ");
INSERT INTO bjr_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Mikari kai kinna fannoo Moodeekaina mara uqasoofanoo mina maaqasaa rakisira fasiqaikinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ooqai Moodeekaifa Eesta nammarinaa qimaminau, anee sia aneennara Yuda maqannaa manaaqa maridee qimasee faiqi qimannimia. Miqi qimaqoona Eesta nammarifa mi ufana afaqanau. Mina oosana mifa aiqama kari Moodeekaina maaqaki maridanoo mina ufa afaqee marinau. ");
INSERT INTO bjr_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Mikari Moodeekaifa kinna Seerkisisana saika maroofaqa qaara fasiqa qara kinnara aanoo qimasee miqanda mina kuqa arirara ufa tipundaari mariqau. Mi fasiqa qanda nuqu Biktanafa faqa Teereesaafa faqa marinau. Mi fasiqa qanda kinna faiqee maru maaqana kooqiki rakisimaru qanda mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Moodeekaifa miqanda ufa iriseenoo mifa oonu kuinna Eesta nammarina qimaminau. Qimamufnoo Eesta nammarifa Moodeekaina faqa mi fasiqaqanda faqa ufa iruna kinna qimaminau. ");
INSERT INTO bjr_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Misa mi ufana oosana randaseeqa iriseeqa mi ufanara kuqaa fee qiqau. Kuqaa fee qimaseeqa misa mi fasiqaqanda saqarisaa dirisoofaqa kuqiqau. Kuqufufanoo kinna fannoo narí oofisaauqa qimanniminoo qinau, mi ainainafa kambiqaina innisaimbaqa kaammanna papiqaki akara rua qufaqa misa miqimmiqau. ");
INSERT INTO bjr_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Kaqikaaqoo marinoo kinna Seerkisisafa moo fasiqa mina auqu Amaannana mara uqasoofanoo mifa uriqarara kaammanna marinau. Amannafa Hammeedatana amaaaku Akakana anaiqi marinau. ");
INSERT INTO bjr_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Kinna fannoo aiqama kiapausara Amaannanara niqoori saunu araseee mina firaa auqu amiaqee qufaqa misa aiqamausa kinna qundee ufanoo Moodeekaifa kai sia miqinau. Moodeekaifa Amannanara aqoori saunu arara akooqanau. ");
INSERT INTO bjr_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Inaaqianna akaqa kiapausa mina qafamasee mina iramiriqa qiqau anee nanaree kinna ufamau sia finanee. ");
INSERT INTO bjr_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Moomoo kari Moodeekaina mi oosannanara qimami mariqau. Miqi marufanoo Moodeekaifa misa ufa irirara akooqanau. Miqufanoo Moodeekaifa misa qimanniminoo qinau, qinee Yuda maqannaasa maridaqa minara qinee Amannanara sia qiqoori saunu araidaqa. Miqi qufaqa kiapausa Moodeekaifa qu ufana Amannana qimamiqau. Misa Moodeekainara kaqi mi ooasanna maree marinanoo Amannafa qafamasee arana qaannoo fee sia fee arana qaannoo fee qimasee qafee mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Amannafa qaqfoofanoo Moodeekaifa sia minara aqoori saunu araseenoo mina amooqinau, miqufanoo mifa minara firaaqoo aranaqanau. ");
INSERT INTO bjr_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Miqi marufanoo mifa mina paqurimmaseenoo qafoofanoo Moodeekaifa Yuda maqannaa fasiqa marunara mifa Moodeekaina mandaikamma amaqarara irinau. Sia Moodeekaina kai fau miqinau. Amannafa Yuda maqannaasa Peereesia maqa maaqaki marusa aiqama naru taikarara oonu mafi irinau. ");
INSERT INTO bjr_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Qisaukqara taikasee qikunni ooqu qaara marasee 12 aukuanaki Seerkisisafa kinna marinau. Indaaruqaa uqoona auqu nisaanna fee qimarunasaa Amannafa purimma fee qimaru sararana masee qafaaqee qinau. Ya uqoonnanaki fee ya faasaanee Yuda maqannaa kuridi nimaqara amiqira faasaana mariannoo fee. Miqi qufaqa misa sarara masee maaqimmasee paquriqau. Adara 12 uqoona fee qimaru uqoonnanaki 13 faasaana Amannafa misa kuridi nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Amnnafa oonureenoo rakisirana qimaminoo qinau. Aiqama anee rakisi marianna maqa maaqaki maria fasiqa anaaseesa akaqausa sia maaqoo mariasa naanna raidaqa, misa mooka uqanna midammia. Minara anee misa afu kai niqafee marinaqa marifanoo mifa sia ani faqa ani maqa maaqa faqa dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Minara rakisirafa ani aidinana anee aiqama faiqi anaaseera qinaqa mi fasiqa anaaseesa kuqa naruaqa. Anee miqinaqa qinee maqee aniara kuqaa idaqa qinee siruaa munnimma moomoo uqanna 50 mirioonna anee munnimma afeedi marianna maaqanaki uqaisaanaura. Miqimmaseenana anee minannai kaamaanna saika mareenaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Kinna fannoo narí sandufauqa qimasainnana afeekaikiani feera mina rinnasaa mina akara maridanoo. Kinna fanoo mi ufana iriseenoo asaukukinaa rinna radukuseenoo Amannana Ammeedatana amaaku Akakana atikinaana Yuda maqannaasa namuqaa aminau. ");
INSERT INTO bjr_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Amiseenoo kinna fannoo Amannana maaqi qimasee qimaminau sia munnimmara iria, anee nana ainainee maa fasiqa anaaseesaki auqararee iridanee kaqi auqaa. ");
INSERT INTO bjr_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Indaaruqaa uqoona 13 faasaana Amannafa kinna kuskusauqa aiqama naaroofaqa aniqau. Aniroofanoo mifa narí ufauqa qimanniminaqa akara ruaqeera naaroofaqa aniqau. Misa anireeqa aiqama moodaa moodaa maqannaasa nári ufakiqari akara ruma nimaqaqau. Miqimmasoofanoo mifa mi papiqana aiqama rakisirausa faqa aiqama kaammnauqa faqa aiqama kiapausa faqa nimaqanau. Aiqama papiqa Seerkisisana rinna saaqaraa akara marinau. Kinna fannoo narí uqanna papiqa akarariifoo qirana koorooinau. ");
INSERT INTO bjr_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Pasa maraqa nu fasiqausa mi pasausa mara maree kinna maqa maaqakinai aiqama maqannaa rakisirausa nimiqau. Aiqama pasauqa kiaqa maaqi qinoo marinau Adara uqoona 13 faasaana innee Yuda maqannaasa aiqama kuqa naruaqee qinoo marinau. Kumaara fasiqa anaasee faqa asooqauqa faqa faiqi anaaqiuqa faqa aiqama mi faasaana kai naru taikaaqa qiqau. Sia misara qimudaoo qiaqa aiqama naru taikaseeqa misa ainainauqa faqa maraaqa. ");
INSERT INTO bjr_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Rakisirausa aiqama oosana oosana fasiqa anaasee aiqama maqa maaqaindari ani mariasa nifusaa mi pasana asaana ruaqa. Asaana rifaqa iriseeqa mi faasaanafa kambiqainaqa misa Yuda maqannaasa narirara deedaqiaqa. ");
INSERT INTO bjr_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Pasa maraqa nu fasiaqusa misa kaunna qimasee pasa maree aiqamai fifainiqau. Misa maa ufana faqa Susaa maqusaki faiqi anaasee iriaqeera qimannimiqau. Kinna faqa Amannafa faqa miqanda kai nimuqusa amiqi marufaqa ooqu faaqee maridaqa uainna nee mariqau. Miqi marufaqa Susaa maqusakinaa fasiqa anaasee mi ufana irisee tautufanoo misa irirafa furufara uqanna minau. ");
INSERT INTO bjr_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Moodeekaifa mi ufana iriseenoo firaaqoo qimudaoo qinau. Mina amuqusa ummaara uqanna roofanoo narí qamunna rakeekaammeeqee aqinau. Miqimmaseenoo mifa soofaara qamunnanda rumbaseenoo akiiqaki danda afaqa teeqinau. Mifa miqimmaseenoo maqusaki oorureenoo firaaqoo faaqa rumasee ikiraqanau. ");
INSERT INTO bjr_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Mifa kinna maaqaki kooqiki oonureenoo mifa sia maaqaki keeqanau. Faiqi kinna maaqaqki keeqararee qinausa sia soofaara qamunna afisu mareeqa keeqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Mikari misa kinna ufa aiqama maqa maaqaki qimannimufaqa Yuda maqannaasa irufanoo naundura ummaara roofaqa firaaqoo faaqa riqau. Misa sia narana naqau qimudaoo qira idi ramasaidaqa iki faafau qimariqau. Yuda maqannaasa moomoo soofaara qamunna rakeekaa irana afisuseeqa dandaki noorindari aqufiqa mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Eesta nammarina ainainira manaaqauqa faqa minasaa rakisi maru fasiqausa faqa Moodeekaifa auqoo oosanara qimamufanoo Eesta nammarina amuqusa firaaqoo uqanna ummaara ranau. Mifa Moodeekaifa qamunna anaqirana raipaqusee amiqirana afisuani feera amaqanau. Amaqasoofanoo Moodeekaifa akoo marara qanau. ");
INSERT INTO bjr_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Miqufanoo Eesta nammarifa Atakana aaranau. Atakafa manaaqauqasaa rakisirafa marufanoo kinna fannoo Eesta nammarina ainainiani feera utaaqama amaqanau. Miqufanoo Eesta nammarifa Moodeekaina oosana paquriani feera nana oosanaree mifa mi ainaina auqeenoo fee qimaseenoo Akatana aiqanau. ");
INSERT INTO bjr_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Akatafa suqira maqusaki keeqafufanoo kinna firaa maaqa kooqiki oonu Modekaina paqurinau. ");
INSERT INTO bjr_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Oonu paqurimma soofanoo Moodeekaifa aiqama ainaina nariki kambiqoonara Akatana qimaminau. Amanafa faiqi Yuda maqannaa aiqama kuqa narusaifanoo mina akiiqara kinna fannoo munnimma uqeemaru maaqanaki mifa naqumma munnimmee uqaaninnanara faqa qinau. ");
INSERT INTO bjr_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Moodeekaifa Amannana ufa maru pasausa kinaana moo maraseenoo Akatana aminau. Mi pasanaki faiqi anaasee Yuda maqannaasa aiqama kuqa naruaqee qinoo marinau. Moodeekaifa Akatanara mi pasana mara maree Eesta nammarifinnai munusee aiqama ainaina kambiqaaninnara qimamianne qinau. Akatafa Eesta nammarina qimaminanoo Eesta nammarifa kinninnai oonureenoo mifa Yuda maqannaara qimudaoo qimasee amuqusiani feera qimaminau. ");
INSERT INTO bjr_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Miqi qufanoo Akatafa oonu Eesta nammarina qimaminau. ");
INSERT INTO bjr_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Qimamufanoo Eesta nammarifa Moodeekaina qimamiani feera moo ufa Akatanasaa uqanau. ");
INSERT INTO bjr_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","Mifa maaqi qinau sia amana qinee oonu kinna qafaanauranoo. Kinna fannoo faiqi moo aarainanoo mifa amana mina maaqaki keeqaannoo. Sia riri aarainanoo narí iriranasaa keeqainnana misa kuqamma arifaranoo. Moodaa aana kai mi sandufana aiaaqararafa maridanoo. Faiqi moo fannoo kinna innannai kaqi fifau oonurainanoo kinna fannoo narí koora saununnai mina afaaqai mundusainafa mifa sia kuquannoo. Aiqama kinna ainainira faiqiuqa faqa kinna rakisi maru maqa maaqanaki maru fasiqausa aiqama mi sandufanara iridaqa. Minara moodaa uqoona taikarara imarufanoo kinna fannoo sia qini daaranau. ");
INSERT INTO bjr_vpl VALUES ("ET4_12","018_4_12","EST","4","12","13","Moodeekaifa Eesta nammarina ufa qimamufanoo iriseenoo mifa narí maaqi qimaseenoo qimaminau. Kuqaa anee kinna maaqaki mariananoo anee sia Yuda maqannaasakiqari aneennara kinna maaqaki marunnanara sia ummaaraki kuquanauree qimasee iria. ");
INSERT INTO bjr_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Anee miqinna kari aneenna oo qumarainanoo akaqa ainaiana innisaimbaqa dadaaqirafa kambiqaannoo. Anee kuqinaqa ani ainaina aiqama kuqu taikeefaranoo. Minara innisaimbaqa sia iridaqa. Manda aukuana innisaimbaqa Yuda maqannaasa dadaaqirara anee kuinnaika mafuananoo. ");
INSERT INTO bjr_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Eesta nammarifa Moodeekaifunnai kaifaa maaqi qimasee ufa uqanau. ");
INSERT INTO bjr_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","Anee oonu Susaa maqusaki aiqama Yuda maqannaasa suqu uqasee qimannimia innee qaarammoo faasaana faqa eendaki faqa narana faqa nammarifaqa auramasee sia naaqa. Kaifa qinee faqa eeqá ainainira manaaqauqa faqa miqi kai iqa narana faqa nammari faqa auramasee sia naanauranoo. Miqimmaseeqa inaaqianna qinee kinna innai fuanauranoo. Kaqi qinee sandufa rukiaanauranoo. Qinee miqimmasee kuquananoo sia ufa mariannoo kaqi qinee kuquanaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Moodeekaifa Eesta nammarina ufa iriseenoo mifa kinna maaqa kooqi uqaseenoo oonureenoo Eesta nammarifa qimamundee maseenoo auqanau. ");
INSERT INTO bjr_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Eesta nammarifa qaarammoo faasaana narana auranau. Mifa qaarammoo faasaanasaa kuinna qamunna afisu mareenoo kinna maaqa maru uqusanaki keeqanau. Kinna firaa oosiranaki maruna aaqa oorufinau. Kinna fanno narí siaqasaa ooqu faaqeeidanoo kooqinni afu maqanau. ");
INSERT INTO bjr_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Kinna fannoo Eesta nammarifa maqusai kikiqinoo marufanoo qafoofanoo mina amuqusa fannoo Eesta nammarinara amiqufanoo mifa koora saunu uaqee mariiu asaukuna afaaqai mundinau. Miqufanoo Eesta nammarifa mina aaqa anireenoo mi saununa ati auqanau. ");
INSERT INTO bjr_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Kinna fannoo qinau, kuinna Eesta nammari ani nanaree aididanoo fee. Qinee ani eeqá firaa maqa maaqa dinni ati ani amianeera aidi marinaqa qinee ani amianaura. ");
INSERT INTO bjr_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Miqi qufanoo Eesta nammarifa maaqi qinau. Rakisirafa amanee anee faqa Amannafa faqa maqee eendaki firaa oomaqaki anifaree. ");
INSERT INTO bjr_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Miqi qufanoo kinna fannoo mi ufanara eedoo qimaseenoo mifa Amannanara kai kaqi anirainaqa anindiri Eesta nammarifinnai fuanee qinau. Miqi qimaseeqa kinna faqa Amannafa faqa miqanda Eesta nammarina oomaqai fiqau. ");
INSERT INTO bjr_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Misa oonu maridaqa uainna nee marufanoo kinna fannoo Eesta nammarina iramirinoo qinau. Anee nana ainainaree aidinnanara qinaqa amia. Aiqama ainainara anee irainnanara qinee eedoo qianaura. Anee qini maqa maaqa dinni ati mararee qinaqa qinee ani amianana anee rakisinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Kinna fannoo miqi qufanoo Eesta nammarifa kinna narí qimaminoo qinau, qinee maaqi qimaseee ani iramiridaqa. ");
INSERT INTO bjr_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","Anee qiniara firaaqoo asasinana qini irara ufara faqa asasinaqa duna qinee moo oomaqa deedaqamma saanaqa anee faqa Amanafa faqa ani naaqa. Nee marifaqa miqoo qinee eeqá didirana ani qimamianauranoo. ");
INSERT INTO bjr_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Amannafa narana neeneeuqooqari amuqusa amiqufanoo firaaqoo asasinau. Miqimmaseenoo oonuree qafoofanoo Moodeekaifa kinna maaqa kooqi aaqa ooqufaaqee marinau. Moodeekaifa maridanoo Amannana qafamaseenoo sia findifi amandanau. Miqufanoo Amannana firaaqoo arana qanau. ");
INSERT INTO bjr_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Amannana aranaqarafa suka uqanna qoofanoo mifa narí amuqusa muqufiseenoo mifa sia moo ainaina auqanau. Mifa narí maaqai oonureenoo narí aqoondiuqa naaroofaqa aniroofanoo narí anaaqa Seereesa nammarina misa faqa mariani feera qimaminau. ");
INSERT INTO bjr_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Misa maaqaki aniroofanoo Amannafa misa nifusaa narí auqu uqeeranau. Mifa narí munnimma moomoo marunara faqa umiasana faqa mina faiqi namu akoonaiqiuqa moomoo marunara faqa qimanniminau. Kinna fannoo mina firaa saika faqa firaaq auqu faqa amiqoonara qimanniminau. Qimannimufaqa kinna oofisaauqa akaqausa mina ameemaanai mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Amannafa kaifaa maaqi qinau, kuinna Eesta nammarifa moo firaa oomaqa qinindi faqa kinnaindi faqa kai suqanau. Mifa sia moo fasiqa aaranau. Mifa maaqi qinau duna maaqandara kaifaa mina faqa oonu narana naaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Qinee Moodeekaina qafaunanoo mifa Yuda maqannaa fasiqa maridanoo. Mifa kinna kooqiki ooqufaaqee marifanoo qini qimuqusa ummaara raifaqa qinee mi amiqira ainainausara fifau ainainee qimasee iridaqa. ");
INSERT INTO bjr_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Seereesa nammarifa Amannana anaaqa mifa narí aqoondiuqa faqa misa maaqi qimasee mina qimamiqau. Anee sia minara iria. Faiqi qimannimifaqa misa kisaaqa saqari 26 mita amana rakiqasee duna kananaana oonu kinna iramirisee Moodeekaina diriaqa. Anee miqimma sainanoo ani amuqusa amiqinana anee oonu narana naa. Amannafa mi ufanara asasammaseenoo faiqi qimannimufaqa misa Moodeekaina dirifandinn a saqarina rakiaqau. ");
INSERT INTO bjr_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Miqu eendanaki kinna fannoo sia faiqanau. Minara mifa mina maqa maaqaki aiqama ainaina kambiqoonara akara rumaqoo papiqanara maree minisaifaqa misa minaki akara ufa qafaaqee qinau. ");
INSERT INTO bjr_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Minisoofaqa misa Biktana faqa Teereesaana faqa ufa asaana rumasee qafoofaqa miqanda kinna maaqa oosiranauqaki rakisi mariqau. Mi fasiqa qanda kinna kuqa arira aanara randee mariqau. Randee marufanoo Moodeekaifa miqanda kukeeqara irirana qafamaseenoo miqanda koota niminau. ");
INSERT INTO bjr_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Minara rakisirafa qinau, innisaimbaqa nanee moo amiqira ainainannai Moodeekaifa auqai oosana akiiqara amianauree. Miqi qufaqa faiqi maaqi qimasee mina qimamiqau, innisaimbaqa sia moo ainaina mina amiqa. ");
INSERT INTO bjr_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Kinna fannoo misa iramirinoo qinau, qini oofisaauqa mi maqanaki mariiaafanoo fee sia fee. Maqee Amannafa kinna irara anidanoo, mifa Moodeekaina saqari rakiqasee deedaqamma qaanasaa diriaqeera qimamirara anidanoo. Minara Amannafa narí uqanna kinna maaqa mari uqusanaki keeqarara anidanoo. ");
INSERT INTO bjr_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Ainainira faiqiuqa mina qafamaseeqa kinna qimamiqa qiqau, Amannafa ani maaqai maridanoo ani afeesidanoo. Mifa ani qafarara maridanoo ani afeesidanoo. Miqi qufanoo kinna fannoo qinau mina afiqee maaqaki uruaqee qinau. ");
INSERT INTO bjr_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Amannafa maaqaki ooruroofanoo kinna fannoo qimaminoo qinau, qinee faiqi moo firaa auqu amirara iridaqa. Qinee sia iridaqa nanee moo amiqira ainainannai fee mina andeeqa amaqaanauree. Anee iria, qinee naqaa fee ianauree qufanoo Amannafa nariara maaqi qimasee oonu mafi irinau. Aqbee kinna fannoo yana miqimma amaqraree qidanoo fee sia moo fannoo maridanoo qinee kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("ET6_7","018_6_7","EST","6","7","8","Amannafa miqi qimiriseenoo kaifaa rakisirana narí maaqi qimasee qimaminau. Aneenna afisi marianna qamunnana minisee mi fasiqana afisu amaqaa. Anee qoosasaa uqeemaria sandiriqana faqa bakarainna faqa amiqimmasee afaaqa auqusee aneenna qoossaa uqaa. Miqimmaseenana kaifaa qoosa akiiqa faqa afaaqa auqusainanoo mifa kinna qoosa fee qirana koorooiani. ");
INSERT INTO bjr_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Anee aneenna oofisaauqa kinaana moo misa uriqararana mara uqasainanoo mifa ani qamunnannai mina afaaqa auquani. Miqimma sainanoo mi fasiqafa qoosasaa ooqu marifinanoo oofisaa fannoo mina afiqeenoo firaa suqira maqusaki fuani. Afiqee fidanoo mi oofisaafa maaqi qimasee nammeera qiani, maa fasiqana qafaaqa kinna fannoo mina firaa auqu amiseenoo mina amiqimma amaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Kinna fannoo mi ufana iriseenoo Amannana qimaminoo qinau anee kai kaqi oonu qamunna faqa qoosa faqa maraseenana qini saika faiqi Moodeekaina Yuda maqannaa fasiqa firaa auqu amia mi fasiqafa qini maaqa kooqiki ainaini marifa maridanoo. Aiqama ainaina maqee aneenna qiannandee masee auqaa. ");
INSERT INTO bjr_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Miqi qufanoo Amannafa iriseenoo qamunna faqa qoosa faqa maraseennoo Moodeekaina afaaqa auqinau. Auqusoofanoo Moodeekaifa qoosasaa ooqu marifufanoo Amannafa qafamaseenoo suqi maru maqusanai afiqee finau. Afiqee fidanoo Amannafa nammeera qimasee maaqi qimasee faiqi anaasee qimanniminau. Maa fasiqana qafaaqa kinna fannoo firaa auqu amiseenoo amiqimma amaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Miqi qimasoofanoo Moodeekaifa kaifaa anirandee kinna kooqinni finau. Fufanoo Amannafa asaurirana maraseenoo aundura ummaararoofanoo mifa oorisaa itita mareenoo kaifaa anirandee narí maaqai finau. ");
INSERT INTO bjr_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Oonureenoo mifa moo anaasee faqa narí aqoondiuqa faqa aiqama ainaina minaki kambiqoonara qimanniminau. Mi anaaseefa faqa mi aqoondisa faqa irirana firaana faqaasa maridaqa misa mina maaqi qimasee qimamiqau. Maqee ani afeeka faqa ani auqu faqa quminanoo Moodeekaifa ani uriaaqaranoo. Mifa Yuda maqannaafa marinara anee sia mina aana titara aana maridanoo, anee ummaara kai mareennaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Misa ufa qida marufanoo kinna ainainira faiqiuqa aniraqau. Misa Amannana kai kaqi afiqee Esta nammarina oomaqai firara aniqau. ");
INSERT INTO bjr_vpl VALUES ("ET7_1","018_7_1","EST","7","1","2","Minara kinna faqa Amannafa faqa kaifaa oonu Estaa nammarina faqa narana naqau. Nasmaseeqa misa uainna nammari naida marufanoo kinna fanno Estaa nammarina iramirinoo qinau, kuinna Esta nammari ani nana ainainaree aididanoo fee anee qinaqa qinee ani amianauranoo. Ani aidinaqa qinee eeqá maqa maaqa faqa ani amianauranoo. ");
INSERT INTO bjr_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Qufanoo kuinna Estaa nammarifa qimaminoo qinau. Rakisirafa anee kuqaa anee qiniara aidinana qini amiqimma qimaqararee qimaseenana kaqi miqia. Qinee ikoo eeqá faiqi anaasee faqa kuqirara qaidanoo. ");
INSERT INTO bjr_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Faiqi moo fannoo qini faqa qini faiqi anaqasee faqa kuqa nariraree qimasee doo ufa rumbaqaifanoo maridanoo. Misa maasa aiqama mandaikamma qimaqararee qidaqa. Misa maasa mandaikamma qimaqasee rumbara saika maasa qimisee fifau ainainira fasiqa anaaseekiaqee qifaqa qinee sia ufa qianauranoo. Qinee ikoo ani ummaara amirara qaifaqa misa maasa taikararee qianara minara qinee koorooidaqa. ");
INSERT INTO bjr_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Kinna Serkisisafa mi ufana iriseenoo kuinna Estaa nammarina iramirinoo qinau. Ya manda fasiqafee sia miqirara rufieenoo fee, yaa fee mi fasiqafa maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Qufanoo Estaa nammarifa narí qimaminoo qinau. Qinee Amannanara qidaqa. Mifa manda fasiqa maasa namuqaa maridanoo maasa darirara deedaqidanoo. Qufanoo Amannana firaaqoo aindiri roofanoo rufianau. ");
INSERT INTO bjr_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Kinna fannoo mi ufana irufanoo arana qoofanoo uainna neneuna minniseenoo aqoosai narí afuqai ooqufinau. Ooqufufanoo Amannafa kinna ooqufuna qafamasee mifa maaqi qimasee irinau kinna fannoo qini daruannoo, qimaseenoo Amannafa maaqaki maridanoo kuinna Estaa nammarifa minara qimudaoo qimasee kinna qimaminanoo sia mina mandaikamma amaqaanifeera iree marinau. ");
INSERT INTO bjr_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Kinna fannoo qafuqaindari kaifaa oonurandee narana nee maruqoo anireenoo mifa Amannana qafoofanoo Estaa nammarifa ooqumarifida narana nee maru qaindanasaa faiaqee ufanoo qafamaseenoo tautinau. Faiaqee idanoo Amannafa minara qimudaoo qianifeera iree marinau. Iree marufanoo kinna mina qafamaseenoo faaqa rumasee qinau, aqbee maa fasiqafa kuinna qini maaqaki qini qifusaa mandaikamma amaqararee qidanoo fee, qimaseenoo kinna fannoo qufaqa misa kaunna qufaqa qamunnannai Amannana akiiqa kinna fannoo (faiqi kuqa narirara rumba nimaqee marundeemmasee rumba amaqanau). ");
INSERT INTO bjr_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Ainainira faiqiuqa moo auqu Aboonafa maaqi qinau, iridafee Amannafa narí maaqa adeedi narí rakiaqoo pausafa mina kisaaqa fannoo 20 mita marinau. Mifa Moodeekaina minasaa diriraree qimasee rakiqanau. Kinna Moodeekaifa ooqai ani dadaqufaqa namuqaauqa sia ani kuqa ariqau. Qufanoo kinna fannoo qinau, innee Amannana narí mi pausanasaa dirisaifanoo kuquani. ");
INSERT INTO bjr_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Qufaqa misa Amannafa Moodeekaina diriraree qimaseenoo rakiaqoo pausanasaa narí diriqau. Misa miqimmasoofanoo kinna aranaqarafa taikanau. ");
INSERT INTO bjr_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Mi faasaanna kai kinna Serkisisafa Yuda maqannaasa namuqaa Amannana maaqa faqa aiqama mina ainaina faqa kuinna Estaa nammarina aminau. Amisoofanoo inaaqianna Moodeekaifa qini moodaa fidika maridanoo qufanoo kinna fannoo Moodeekainara qufanoo aiqama kari ani kinna qafee marinau. ");
INSERT INTO bjr_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Kinna fannoo Amannafa unnai narí rinna maraseenoo kaifaa narí asauku amukaki uqaqoona Moodeekaina aminau. Mi rinnafa kinna nambaqa faqaafa marinau. Marufanoo Estaa nammarifa Moodeekaina mara uqasoofanoo Amannana aiqama ainainasaa rakisi marinau. ");
INSERT INTO bjr_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Rakisi marufanoo inaaqianna Estaa nammarifa kinna marunnai oonureenoo mina aikuki aqufinoo maridanoo iki raqee marinau. Mifa kinna qimaminanoo mifa faiqi mi manda oosanna auqeefoora rafaaqafu sainaqa Amannafa Akakana atikinaafa Yuda maqannaasaki auqararee qimasee ufa rumboondee sia iaqa. ");
INSERT INTO bjr_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Kinna fannoo narí koora saunu Estaa nammarinasaa mundusoofanoo findifinoo qinau. ");
INSERT INTO bjr_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Rakisirafa anee qiniara aidinana qini ufa irinanoo amiqinana ufa uqasainanoo fifaininaqa misa sia Amannana Ammeedatana amaaku ufa afaqaaqa. Amannafa aiqama Yuda maqannaa fasiqa anaasee ani maqa maaqaki mariasa aiqama naru taikaaqee qimaseenoo qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Qinee mi mandafa qini faiqi anaaseeki sia kambiqaanifee qimasee iridaqa. Misa qini moodaa fidikauqa kuqa narusaifaqa qinee naqi fee masee amiqiqa marianauree. ");
INSERT INTO bjr_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Qufanoo kinna Serkisisafa Estaa nammarina faqa Moodeekaina faqa maaqi qimasee qimanniminau. Iridaqee qinee iriafananoo Amannafa Yuda maqannnaasa mandaikamma nimaqararee qufaqa minara qinee mina saqarisaa diriseeqa mina aiqama ainaina Esta nammarina kai amiqa. ");
INSERT INTO bjr_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Papiqa qini duqusaa akara rumasee qini nambaqa minasaa uqaqaana mina kai sia mara aquanauranoo. Inneeqara nana ufa fee Yuda maqannaasara akara ruani qimasee kaqi akara ruaqa. Akara rumaseeqa inneeqara mi papiqanasaa qini duqu uqasee qini nambaqa faqa uqaaqa. ");
INSERT INTO bjr_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Misa miqimmasee Siwa uqoona 23 faasaana Moodeekaifa aiqama kinna kuskusauqa naaroofaqa aniqau. Aniroofanoo misa ufa qimannimufaqa misa mi ufausa papiqaki akara riqau. Misa mi pasana Yuda maqannaasa uriqararausa faqa kiapausa faqa aiqama oofisaauqa faqa 127 maqa maaqaki marusa faqa India maqa maaqaki oosana arasee Itioopia maqa maaqai dinni ati oonuroofanoo misa akara ruma nimaqaqau. Misa mi pasana aiqama mi maqa maaqausaki marusa ufakiqari faqa Yuda maqannaasa ufakiqari faqa akara riqau. ");
INSERT INTO bjr_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Moodeekaifa misa kinna Serkisisana auqusaa pasa akara rumasee mina nambaqa faqa mi pasanasaa uqaaqeera qimanniminau. Mi pasana maree firaree qu fasiqausa misa amiqira qoosa kinna ququsakinaana kaaqa sandee maruna maree minisee minasaa ooqu marifufaqa pasauqa maree aiqama maqusakiaqa fifainiqau. ");
INSERT INTO bjr_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Pasaki maaqi qimasee akara riqau. Kinna fannoo qidanoo, Yuda maqannaasa misa aiqama maqusakiaqa mariasa misa nári faiqi anaasee namufaqa nariraree qu fasiqausa misa ruqaummafi nári faqa naruaqa. Moo maqusakinaa fasiqauqee moo maqannaa fasiqauqee misa mandaikamma nimaqararee qusa, Yuda maqannaasa aiqama ruqaummafi misa naru taikasee misa aiqama ainaina mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Mi faasaana Yuda maqannaasa aiqama Peereesia maqa maaqaki mi ainainausa auqeefaranoo. Misa 13 faasaana Adara uqoonaki auqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Misa kinna maa sandufa aiqama fasiqauqa aiqama maqa maaqaki mariasa qimannimiaqa. Qimannimi marifaqa Yuda maqanaasa mi faasaanafa anirainaqa nári namuqaa faqa rakirara deedaqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Kinna fannoo qufaqa faiqi ufa maree fusa qoosasaa ooqumari kai kaqi sandee akaqa maqusakiaqa fiqau. Susa firaa maqusaki mi ufana oosana arasoofanoo aiqamai fifaininau. ");
INSERT INTO bjr_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Misa kinna qamunna eekara faqa panoona arirana faqa Moodeekaina afisu amaqaqau. Afisu amaqsee dirindaasi arira qamunna moo marasee mina aku amaqaqau. Aku amaqasee inaaqianna misa kinna koora qafee firaana amiqira afaaqa auqirana akiaaqa afisu amaqasee afaaqa auqusoofanoo mifa kinna maaqakiqari raudee maqusai ooqufinau. Ooquroofaqa Susa firaa maqusakinaa fasiqa anasee mina qafamasee firaaqoo faaqaridaqa asasiqau. ");
INSERT INTO bjr_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Yuda maqannaasa nimuqusa amiqi uqanna ufaqa misa nimuqusa asooarana faqa mariqau. Maridaqa misa firaaqoo asasidaqa nariara maaqi qimasee iriqau. Maas doo uriqaramafiqa sia amana kaifaa oorudupianauranoo. ");
INSERT INTO bjr_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Aiqama maqa maaqaki faqa maqusaki faqa Yuda maqannaasa kinna ufa marasee moodaa faasaana utaaqamasee misa firaa narana naidaqa minara asasi mariqau. Asasi marufaqa moomoosa akaqa fasiqauqa Yuda maqannaasara rufiasee misaki ootupaqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Mikari Adara uqoona 13 faasaana aniroofanoo indaaaruqaa kinna fannoo qinau, mi faasaanna kai namuqaauqa Yuda maqannaasa mandaikamma nimaqasee naru taikeefaranoo. Miqi qufaqa Yuda maqannaasa findifufaqa misa rafaaqafusee aiqama naru taikaqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Yuda maqannaasa kinna fannoo rakisi maru maqusausakiaqa faqa maqa maaqanaki marusa misa namuqaauqa misa faqa rakirara anufaqa rakirara deedaqiqau. Aiqama fasiqa anaasee aiqama tinaindaraasa Yuda maqannaasara rufiasee misaki sia moo ainaina auqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Aiqama maqa maaqakinaa kiapausa faqa kaammannaauqa faqa aiqama kinna ainainasaa rakisi marusa faqa Yuda maqannaasa dadaaqiqau. Misa Moodeekainara rufiasee miqiqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Aiqama fasiqauqa kinna rakisimaru maqa maaqanakinaasa irufanoo kinna fannoo firaa afeeka faqa uriqarara auqu faqa Moodeekaina aminau. Amisoofanoo mina afeeka aiqama kari uriqaranoo uqanna marinau. ");
INSERT INTO bjr_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Marufaqa Yuda maqannaasa nári namuqaauqa nariqau. Misa kisaaqa paipanannai rakidaqa nariqa namuqaauqa naru taikaqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Susa firaa maqusaki Yuda maqannaasa 500 fasiqa kuqa nariqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_7","018_9_7","EST","9","7","10","Amannana faiqi namu qisaukuqara taikasee 10 mariqau. Yuda maqannaasa namuqaauqa nuqu maaqimminoo maridanoo. Parasadataafa faqa Darfoonafa faqa Asbatannafa faqa Pooratanafa faqa Adarianafa faqa Aridatanafa faqa Parmastanafa faqa Arisainafa faqa Aridainafa faqa Uaisataanafa faqa minamusa ainaina kai Yuda maqannaasa sia maraqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Mi faasaana kai Yuda maqannaasa naqumma fasiqa Susa maqusaki narunara kinna qimamiqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Marikinoo kinna fannoo kuinna Estaa nammarina qimaminau. Yuda maqannaasa 500 fasiqa Susa maqusakinaasa kuqa nariaafoo qinau. Misa Amannana faiqi namu qisaukuqara 10 faqa kuqa nariqau. Qinee iruna misa akaqa maqa maaqaki moomoo fasiqa faqa kuqa naria. Anee maqee nana ainainee akaqa ainaina mararee qinaqa, qinee amana ani amianauranoo. Esta anee nana ainainaree aidinna ainaina kaqi maraa. ");
INSERT INTO bjr_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Estaa nammarifa kaifaa kinna qimaminoo qinau. Rakisirafa ani aidinana duna Susa maqusaindaraa Yuda maqannaasara qinaqa namuqaauqaki duna faqa maqee iandee kai iaqa. Misa Amannana faiqi namu qisaukuqara taikasee 10 mariasa mi faakannanasaa diriaqa. ");
INSERT INTO bjr_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Doo kinna fannoo misara miqiaqee qimaseenoo mifa mi ufana Susaa maqusaindaraa fasiqauqa unnai afeeqoofanoo fufaqa misa Amannana faiqi namu qisaukuqara taikasee 10 marusa faakana rakiaqoonasa dirimarufaqa aiqama fasiqauqa qafaqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Adara uqoona 14 faasaanasaa Susa maqusai maru Yuda maqannaasa kaifaa ruqaumma fufaqa 300 fasiqa mi maqusanaki kuqa nariqau, narusee sia misa ainainauqa maraqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Yuda maqannaasa akaqa maqa maaqaki marusa misa faqa moodaanakika mafiqa afeekaika masee misa narusee misa amiqimmasee marifaranoo. Misara nikooqee maru namuqaasa 75,000 fasiqa anaasee kuqa nariqau. Narusee sia misa ainaina maraqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Mi rakirafa maqa maaqaki 13 faasaana Adara uqoonaki kambiqanau. Kafa 14 faasaana misa sia nári namuqaa nariqau. Mi faasaana misa idooaidaqa firaa qoomaqa sakasee naidaqa firaaqoo asasi mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Misa miqi marufaqa Yuda maqannaasa Susaa maqusaki marusa misa 15 faasaanara idooaidaqa asasira faasaanee qimasee utaaqaqau. Misa namuqaauqa 13 faasaana faqa 14 faasaana faqa narusee 15 faasaana misa sia rakiqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Minara kai Yuda maqannaasa kaqikaa maqusauqa uqusa sia auqiranakiaqa mariusa misa Adara uqoona 14 faasaana firaa oomaqa naidaqa ainaina narami naramira faasaanee qimasee utaaqaqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Moodeekaifa mi faasaanna aiqama ainaina auqoo ainaina akara rumaseenoo Yuda maqannaasa nianai marusa faqa adeedi marusa faqa kinna Serkisisafa rakisi nimaqee maru maqa maaqanakinai marusa nimaqanau. ");
INSERT INTO bjr_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Misa Adara uqoonaki 14 faasaana faqa 15 faasaana faqa aiqama aukuanaki asasira faasaana utaaqaaqee qimaseenoo qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Mi qaara faasaanna Yuda maqannaasa nári maqannaasa niiaqau. Mi uqoonnanaki kai misa naundura ummaara reereeufa faqa aiaaee qiqiufa faqa taikoofaqa Yuda maqannaasa nimuqusa amiqinau. Miqufanoo Moodeekaifa mi qaara faasaanara firaa oomaqa sakasee aqoondiuqa faqa kudi fasiqauqa nimiaqeera qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Miqi qimasoofaqa Yuda maqannaasa Moodeekaina ufa afaqeeqa aiqama aukuanaki mi oosannana auqaidaqa asasi mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Ooqai Amannafa Ameedatana amaaku Akaakana faiqi anaiqi maridanoo mifa Yuda maqannaasa namuqaakamma nimaqaseenoo mifa misa aiqama kuqa nariraree qimaseenoo satu sararidanoo misa narira faasaanara randee marinau. Misa Heeburu maqannaasa ufakiqari satura rarisaidanoo fee qimasee auqu ree mariqau. Amannafa aiqama Yuda maqannaasa naru taikaani qimasee ufa rumbee marinau. ");
INSERT INTO bjr_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Ufa rumbee marufanoo Estaa nammarifa kinna unnai oonuroofanoo kinna fannoo maaqi qimasee papiqa akara rinau. Ooqai Amannafa Yuda maqannaasa kuqa nariraree qinau, maqee nári kuqa aruaqa qufaqa misa mina diriseeqa inaaqianna mina faiqi namu faqa misa mi poosanasaa kai diriqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Mi oosannara kai misa mi idooqara faasaana qandara maaqi qimasee auqu raqau. Purimma faasaanee qiqau. Misa purimma fee qimaru auquna oosana satu maridanoo. Misa mi oosanna auqaidaqa mi ainainausa misaki kambiqoonara oonu mafi irimariqau. Irimarufanoo Moodeekaifa misa unnai papiqa afeeqaseenoo misa mi faasaana idooaaqeera qimanniminau. ");
INSERT INTO bjr_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","Yuda maqannasa mina mareeqee narí faqa misa ninaiqi mara inaaqianna kambiqainausa faqa aiqama fasiqa minaki ani keeqainausa faqa sandufaika maqoofanoo marinau. Aiqama aukuana misa mi qaara faasaanafa aniroofaqa misa Moodeekaifa qufanoo mi ainainafa kambiqoonara oonu mafi irimariqau. ");
INSERT INTO bjr_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Misa maaqi qiqau aiqama Yuda maqannaasa moodaa moodaa oosana kasooaqee inaaqianna kambiqainausa faqa aiqama maqa maaqaki faqa aiqama maqusaki faqa maru fasiqa anaaseesa misa mi firaa masisa aqira faasaanara oonu mafi irisaidaqa aiqama aukuanaki miqoo kai idooaidaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Kuinna Estaa nammarifa Abiaina araamuna Moodeekaisandiri miqanda Yuda maqannaa qanda miqanda moo papiqa mi qaara faasaana masisa sararu ufana akara riqau mi oosannanannai kuinna fanno indaaruqaa papiqa Moodeekaifa nariara akara rumaqoona afeekaikinau. ");
INSERT INTO bjr_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Miqanda mi papiqana uqasoofanoo Peereesiaa maqa maaqaki 127 (provinsaki) Yuda maqannaasa marunakinai papiqa maaqi qimasee akara rumasoofanoo fifaininau. Inni nimuqusa ireeda marinaqa innee amiqira ooqu marirana maraaqa sia rakirafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Innee faqa inni ninaiqi mara kasooaqee kambiqainausa faqa innee afeekaikammasee inneeqa mariaqoo mi firaa masisa sararira faasaannana umaraaqa. Innee narana aurarana faqa nimuqusa ummaarara oosana afaqararana faqa iki raqarana faqa mi sandufana uaqeeufaqa qinee Moodeekaisa kuinna Estaa nammarisandiri maaqanda maa sandufana inni nimiqa. ");
INSERT INTO bjr_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Estaa nammarina mi sandufana masisa sararira sandufauqa afeekaika masoofaqa misa moo papiqasaa akara rumasee uqaqoofanoo marinau. ");
INSERT INTO bjr_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Kinna Serkisisafa faiqi ooruku nammari afaiqara marusa faqa narí maqa maaqaki marusa faqa nifiqasoofaqa misa mifa rakisi maru maqanasa dadaaqira saika auqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Aiqama amiqira ainaina faqa firaa ainaina faqa kinna fannoo auqaidanoo mifa Moodeekaina firaa auqu amimarufaqa aiqama mi oosannara ufa qimariqau. Aiqama mi ufana misa Peereesiaa maqannaasa faqa Midiannaa maqannaasa faqa kinna papiqaki akara riqau. ");
INSERT INTO bjr_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mi Yuda maqannaa fasiqafa Moodeekaifa kinna Serkisisana namba 2 marinau. Yuda maqannaasa minara firaaqoo uqanna nidimarufaqa misa mina firaa auqu amimariqau. Amimarufanoo mifa misa dadaaqinaqa amiqimmasee ooqu mariaqeera ainaini marinau. Mifa miqimma sainaqa misa niku nisauku kasooaqee kambiqainausa misa sia moo ainainara rufieefaranoo amiqimmasee marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Manda oosana maree mariasa iriranamau sia fimariasa faqa Anutuna ufa rukiee mariasa faqa sia moodaanaki kimariasa faqa andeeqara oosanara fidiaqaa imariasa faqa sia ooqu maria fasiqausa mi manda oosanausara rufiee mariasa misa asasiranaki maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Miqi maria andeeqara fasiqa anaaseesa Anutuna sandufamau fuanara asasirana maraidaqa. Misa faasaana faqa eendanaki faqa mi sandufana asaana rumasee irimaree fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Miqi maria fasiqa anaaseesa saqari nammari aaqa ummaqirafara foora iqa mariasa maridaqa narí qanaa mina aqama amiqimmasee iraidanoo mina amanee sia kakasidanoo. Miqira fasiqa anaasee nana ainainee auqaafanoo anoonaikidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Manda oosana maree marisa sia miqidaqa. Misa anaaqmaarara foora ufai uqinoo fuaqaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Yaaweena ufa rukiee marisa Anutufa narí ufannai rumbannimaqaseenoo narí faiqí anaasee mariaqooqari nianai naaduma mara quqannisaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Yaaweefa andeeqarausa nirana mariranasaa rakisidanoo itita nimaqaidanoo. Manda oosana maree mariasa kuridiranaki maaniki fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Nanaree aiqama maqannaasa fifau suqufiqa manda oosanara tipundaarammasee aanoo qidee. Nanaree faiqí anaasee anoona siai ainainara tipundaaridee. ");
INSERT INTO bjr_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Misa karaambaiqauqa faqa misa rakisi nimaqee mariasa faqa Yaaweefa rakisi nimaqee marinakiqari quqasee kaqinni firara tipundaaridaqa. Yaaweefa utaaqamaqai rakisirana rakisi nimaqaranakiqari faqa quqasee kaqinni firaree qimasee tipundaaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Misa maaqi qidaqa anifaqa maasa misa rakisi nimaqaranakiqari qeeqa qifaaqa idukua. Anifaqa misa qimaqimira ufa aqusaanee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Yaaweefa innaarunai marifa naanaidara qimasee misa oosana siai tipundaariranara ataasa ataasa qimannimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Miqimmaseenoo narí aanooqiranakiqari aauqima nimaqasee narí idara fooira aanooqirana kiqari rufiarana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Mifa maaqi qidanoo qinee Yaaweesa inni karaambaiqa marianinnana qeeqa naaquqara aaqana Sioona aaqanasaa quqeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Maqasaa karaambaiqa maaqi qinau, qinee Yaaweefa qima qimu ufana kooroo ianauree qinau. Mifa qiniara maaqi qinau. Anee qini qimaaku mariananoo maqee faasaana ani akausaikammiqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Anee qini iramirinaqa qinee aiqama maqannaasa ani amianaura. Aiqama maqa maaqa anindi kai mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Anee qainna samu misa narusee nimudaani itairi nimaqeennaranoo. Anee qafeera foora misa rukamusee andaana rumaseennaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Innee maa maqanasaa karaambaiqauqa maa aauqira ufana iriaqa. Maa maqa maaqanakinaa rakisirausa maa irirana maaqimmasee iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Innee naaquqee marinaqa Yaaweena ainaina mamaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Naindiri ree marinaqa mina oorinni niqoori saunu araaqa. Innee sia miqifanoo mifa aanoo qinaqa innee kuqifaranoo. Mifa itita qimaqaanifee qimasee mifinnai fimariasa asasi mariasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Oo Yaawee qini namuqaa moomoo maridaqa, qini qiqoondikiqa mariusa quandaki qini namuqaakidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Misa qiniara maaqi qidaqa. Anutufa sia mina dadaaqiannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Miqi qimariafana oo Yaawee anee qini aiqama kari mandainainaki itita qimaqee marianafa mariananoo. Anee rakiranaki uriqararana qimiseenana qini paasoosirafa taikanoo marina kaifaa qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Qinee Yaaweena dadaaqianifeera aaree marunanoo narí naaquqara aaqanasaaqari iriseenoo dadaaqirana qiminoo. ");
INSERT INTO bjr_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Qinee maqasaa faiqaqee unaanoo aiqama eendirana Yaaweefa qini itita qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Namuqaauqa nukudara foora qini fiqu fiqu iqa marianara sia qinee rufiaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Qini Anutu, qini Yaawee anireenana qini mandainainaki marunnana dadaaqia. Anee qini namuqaa aiqama aupurarana nimiseenana misa afeeka siaisaikamma sainaqa maridaqa sia qini daruaqa. ");
INSERT INTO bjr_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Oosana oosana ummaaraki uriqararafa ani Yaawee finaindari anidanoo. Mifa narí faiqí anaasee amiqi amiqimma nimaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Oo qini itita qimaqee marianna Anutufa qinee innaaru ufakiqari ani aaraanana qini ufa iria. Qinee manda qumaaraki mariafannana anee dadaaqinau. Qiniara maqee qimudaoo qimisee qini innaaru qirana iria. ");
INSERT INTO bjr_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Kisaaqasaa fee innee aasaandaana ufa qima qimaqeefaree. Kisaaqasaa fee innee anoona siai ainainnara ridaqee unnaqira ainaina afaqaqa fifaree. ");
INSERT INTO bjr_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Innee iriaqa. Yaaweefa andeeqarausa nariara utaaqama qaifaqa maridaqa. Qinee mina aaraunanoo qini ufa iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Innee naindiri ree marinaqa rufiaidaqa aaqee maria oosannana minnisaaqa. Anee aneenna qaarisaa ireeda faiqaqee idana firaaqoo minara oonu mafi iria. ");
INSERT INTO bjr_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Anee Yaaweefa aidimari andeeqara tatufirana kai suqa amia Anutuna suqa amiseenana mina kai saqarikia. ");
INSERT INTO bjr_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Moomoosa maaqi qimasee innaaru qidaqa. Oo Yaawee moomoo amiqi amiqirana maasa qimia. Maasa qiqafamasee qimudaoo qimasee qimia. ");
INSERT INTO bjr_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Misa miqi qimariafana anee qini asasirana qimi marianafa mifa misa mi ainainausa uriqararafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Oo Yaawee anee kai amiqimmasee ititaqisaanaqa amiqimmasee faiqaidaqa. Qinee qeeqa qaarisaa qifaaqa quqasee asooaranaki faiqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Oo Yaaweefa qini ufa iria. Qini innaaru annada annada qiranakiqari qimarunnana iria. ");
INSERT INTO bjr_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Oo qini Anutufa, qini karaambaiqa qinee dadaaqiannee innaaru qimarunnana iria. Oo Yaawee qinee aniara innaaru qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Oo Yaawee aiqama kananaana kananaana qini ufa iriananoo. Suani afu ururaifaqa qeeqa innaaru qirana amiseeqa ani dadaaqiranara afeesidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Anee aaqara oosanara sia asasimarianna Anutufa mariananoo. Aaqara oosana maree mariasa sia eedoo qinaqa ani afusaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Nári nimoo naamoo qimariasa misa noori niqafarara ani akooqaidanoo. Anee aiqama manda oosana maree mariasara fidiaqaa imariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Unnufa qimariasa kuridiranaki anee quqannisee mariananoo. Faiqí fidikanauqara faqa nikaru qimariasara faqa Yaaweefa fidiaqaamma nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ani firaa amuqusirafa marinara qinee kaqi ani naaquqara maaqaki keeqaanaura. Qinee kaqi ani naaquqara amaana maqaki keeqafi qeeqa mara maree muqusee qiqoori saunarafi innaaru qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Oo Yaawee qini namuqaa moomoo maridaqa. Aneenna aidi mari ainainnara kai qimaqiminaqa auqaa. Aneenna aana uqaqifiqainaqa mimau kai fua. ");
INSERT INTO bjr_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Qini namuqaauqa ufa sia anoona mari ufana qidaqa. Misa kuridiranara kai nididanoo. Misa nári ufannai unna qimasee fadameenara foora akusaafanoo faiqí narirafa qumbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Oo Anutu anee misa ufa nimisee aupurarana faqa nimia. Misa nariqa manda tipundaarirafa nári kuridirana nimiannoo. Misa moomoo aaqarafa marinara faqa misa ani ufa afaqaranara ititammasee qaoo qimarianara misa aiqama aneenna afusaaqari futeeqeeqee nianai aqusaa. ");
INSERT INTO bjr_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Miqimmasainaqa aiqama ani saqariki mariasa asasifaranoo. Misa aiqama kari ani amooqira idi raaqa. Aniara rimariasa ititannimaqaa. Anee mariannanara misa kuqaa uqanna asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Oo Yaawee ani ufamau fimariasa amiqi amiqimmannimaqaa. Ani amuqusirafa rakira saqariara foora misa itita nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Oo Yaawee aneenna aanooqiranaki qari sia qiniara qaoo qimasee minni qisaa. Aneenna aanooqiranannai sia qini aupurarana qimia. ");
INSERT INTO bjr_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Oo Yaawee qinee kudoosaapaidaqa anee qiniara qimudaoo qia. Qini afeeka taikee marifaqa kudoosaapaida marunnanara anee afeeka qimia. ");
INSERT INTO bjr_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Qini marirafa mudukatia firaaqoo ummaaraki maridanoo. Oo Yaawee kisaaqasaafee kaqi fifau maridanee sia qini dadaaqidanee. ");
INSERT INTO bjr_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Oo Yaawee anee aniree mandaki marunnana uqeereeqeena amiqiraqoo quqaqisaa. Aneenna nifauaranakiqari qinee kuqiranaki marunnana dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Kuqirausa sia aniara iridaqa. Sia moo fannoo amana miqoo ani amooqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Qinee firaa ummaaraki maridaqa firaaqoo qimudaani rimarifaqa kudoosaapaidaqa. Aiqama eenda qini qaari faiqee marunnanasaa daukunu kai nammariara foora aufidanoo. Qiqa daukunu fannoo qini qunusaa aqufidanoo putaa idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Qini namuqaa darirari marianara qiki raqee marunanoo firaaqoo qifukaumuqa innooqaifaqa qifu maqarara anuqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Innee manda oosana maree mariasa qinee marunnaqooqari nianasaa fifuaqa. Yaaweefa qini qiki raqarana iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Mifa qinee dadaaqianifeera nammeera qunnana irisee qini innaaru qirana akiiqara dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Qini namuqaauqa manda nisaurirafa tautummasee rafaaqafu nimaqainaqa furufariqa quqasee daraanifara. ");
INSERT INTO bjr_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Oo Yaawee qini Anutu qinee ititaqimaqaanneera anee iannannai anidaqa. Qini qifaqaqa nimarianakinaana qumareeqee amiqirannai kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Anee sia qini dadaaqinaqa misa kaasau fainiara foora qini daaku mareeqa fifaranoo. Qini dadaaqirausa sia maria maqa maaqanaki munusee miqoo misa qini qipata anaqifoora. ");
INSERT INTO bjr_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Oo Yaawee qini Anutufa qinee moona mandaikamma amaqasaananoo fee qeeqa qiqoondi oosana siainaki ueeqasaananoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Qeeqa namuqaa oosana siainaki aupurarana amiananoo fee qinee mi ainainausa akaqana auqamasaanaqau qini namuqaa qini qifaqasee qumarani. ");
INSERT INTO bjr_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Qini qumaraseefau kuqa darusee ateekaateeka masaifaqau kasirana siai ainainnara foora maqasaa qisaifaqau marini. ");
INSERT INTO bjr_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Oo Yaawee aneenna aanooqiranakiqari findifua. Qini namuqaa aanoo qirana firaanara irinana findifinana ititaqisaa. Anee andeeqaranara rimarianafa mariannanara findifinana qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Aiqama fasiqa anaasee aneenna aaqa moodaanaki suqu quqasee innaarunai mirindari rakisi nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Anee aiqama fasiqa anaasee ufa andeeqannisee marianafa mariananoo. Qinee aaqarana siaisa marunnanara anee irimmariananoo. Minara anee qini ufa irisee qiniara andeeqara fee qia. ");
INSERT INTO bjr_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Anutu anee andeeqarafa maridana maasa irirana faqa maasa qimuqusa faqa aiququmasee qafee marianafa mariananoo. Anee manda oosana maree mariasa aaqara oosana taikasainaqa mariaqa. Andeeqarausa amiqimasee dadaaqinaqa mapukusee mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Anutufa qini ititaqimaqee marifa maridanoo. Mifa narí ufa mau fimariasa dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Anutufa andeeqara ufasaa rakisirafa maridanoo. Aiqama faasaambaasaana narí aanoo qiranara manda oosana maree mariasa qimannimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Misa sia naundura quandaifanoo Anutufa narí rakira faaqaana aaruqiannoo. Mifa narí duru fufuseenoo deedaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Mifa narí kuqa nári maria duru saamuna deedaqammasee maridanoo. Narí idaqeemari feefana faqa deedaqammasee maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Manda oosana maree mariasa firaaqoo aaqara oosana auqarara qimiridaqa. Misa unna qimasee ummaara oosana uqeerarara tipundaaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Misa akaqausa nimaara ufaana fufusee nári minaki aridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Nariqa aaqara oosaa fannoo nariqa aupurarana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Qinee Anutuna andeeqaranara irisee dufi dufi qidaqa. Qinee firaaqoo uriqarara Anutuna amooqira idi raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Oo Yaawee maasa Yaaweefa, ani uriqararana aiqama maa maqa maaqanaki mariasa qafaidaqa. Ani amooqirafa innaaruna amana kai ooru maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Miqi qimasee faiqí aanaaqiuqaindi faqa naaqoo iriasa faqa ani amooqira idi raidaqa. Anee amiqiranaki marianaqa ani namuqaa sia ani arifaranoo. Nariara uriqararausee qimariasa anee misa aana ititannimaqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Qinee anee auqu quqaqoonnana quqoona faqa fasauqa faqa innaarunai qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Qinee mi ainainausa qafaidaqa maaqi qidaqa, Faiqí nanee mariafanee anee misara iridanee. Fifau kaqikaa ainaina maridanoo. Faiqí faiqí faqa nanainainee mariafanee anee misa rakisidanee. ");
INSERT INTO bjr_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Anee Yaaweefa faiqí faiqí mareeqee aiqama ainaina urinnaaqaramasee aneenna ameemaanai quqaseenana miqoo qareenarana faqa nuqu firaana faqa qatara foora afisu nimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Anee faiqiara aiqama anee auquqoonna ainainausasaa rakisiaqee qimasee qinau. Anee aiqama ainaina auquqoonnana uriqararausa mariaqeera quqanau. ");
INSERT INTO bjr_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Sipsipauqasaa faqa burimmakauqasaa faqa kaasau aandausaa faqa rakisiaqeera quqanau. ");
INSERT INTO bjr_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","Innaarunai qaqamaree nimaria ufinisa faqa ooruku nammariki maria noodaannausa faqa minaki maria aandausa oosana oosana saa rakisiaqeera faiqí quqanau. ");
INSERT INTO bjr_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Oo Yaawee maasa Yaaweefa ani uriqarara afeeka aiqama maqa maaqaki mariasa qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Oo Yaawee qinee qeeqa qimuqusa aiqamannoo ani amooqianaura. Anee aiqama naaquqara ainaina auqoonnanara qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Qinee aniki marunnanara asasidaqa idi raanaura. Aiqama afeeka faqaa Anutunara qinee amooqira idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Qini namuqaa ani qafamasee quandaki fuani qiana saamuriqa kuqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Ani ufa iriranaki kuqaa qirana faqa amana amana kai ira oosanannoo rainee marianafa mariananoo. Anee qini ufa irisee qiniara andeeqara fee qimariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Anee ani ufa rukiee marusa ufa nimiseenana kafaa manda oosana maree marusa kuridi nimaqasoonaqa naaru naaru sia kaifaa misara irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Anee maasa namuqaa aiqama taikaseenana misa maqusauqa faqa kuridi nimaqanau. Miqimma soonaqa misara kaaqa qaunuqanna saqau. Misara irirana faqa kaaqa qaunuqanna seefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Miqiqa mariafanoo Yaaweefa kai naaru naaru karaambaiqa maridanoo. Narí ufa irira qaari deedaqamma quqaseenoo ufa andeeqa nimaqaranara rakisidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Mifa narí andeeqaranannai maa maqa maaqanasaa mariasa rakisinimaqaidanoo. Mifa aiqama maqannaasa amana amana kai ufa irinnimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Oorudupirausee qimannimaqee mariasa Yaaweefa misa afeeka ititara maqusara foora maridanoo. Ummaara aukuana kukeeqee maria maqusafa Yaaweefa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Oo Yaawee ani oosanara irimariasa ani saqarikifaranoo. Anee sia anee iannannai ani mariasa moona minnisaanafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Sioonna maqusai marida rakisinnimaqee mari Yaaweena amooqira idirama amaqaaqa. Mifa auqoo ainainnara aiqama maqannaasa kooroommasee qimannimiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Anutufa aupuraranaki mariasara sia qaunidanoo iridanoo. Mifa sia misa nammeera qiranara qaunidanoo. Mifa misa mandaikamma nimaqee mariasa aupurarana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Oo Yaawee qini namuqaauqa ummaara qimimariana qafamasee qiniara qimudaoo qia. Oo Yaawee qini kuqiranakinaana ititaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Miqimmasainaqa qinee Yeerusaree maqannaa fasiqa anaasee nifusaa kikiqammafi ani amooqimarunnanara qimannimianaura. Anee qini asumu mariranaki quqaqisaannanara asasianaura. ");
INSERT INTO bjr_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Anutunara sia iri mariasa maasa qimaara madika indufusee nári kai minaki aqufidaqa. Misa maasa qimaara ufaana fufusee nári kai minaki aridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yaaweefa andeeqasee ufa raina nimaqaranannai nariara kooroo idanoo. Manda oosana maree mariasa nári auqee maria ainainafa quandakinoo ufaanara foora nariqa qumaraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Aiqama manda oosana maraqanuasa faqa aiqama Anutuna ufa minnisee nári irirana mau nimariasa faqa kuqirafa misa maqusara foora maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Kudi fasiqa aanaaseera Anutufa sia aiqama kari qaunuannoo. Ainaina siaisa sia kisaaqasaa rafaaqafu nimaqaqaifaqa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Oo Yaawee anee findifua sia faiqí faiqi ani afusaa aanoo qimasee ani ufa rukiaannoo. Ani ufa sia irimariasa aneenna afusaa quqasee ufa nimia. ");
INSERT INTO bjr_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Oo Yaawee anee misa rufiarana nimia. Aiqama maqannaasa nariara faiqí faiqi kai maridee qimasee iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Oo Yaawee anee nanaree nianai maridanee. Maasa qummaaraki marunana anee nanaree kukeeqana maridanee. ");
INSERT INTO bjr_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Aaqee mariasa misa nári nimoo namoo qidaqa ainaina siaisa narunnindaqaa idaqa. Misa kai indufuqaa dikaandanaki ainaia siaisa aqufidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Manda oosana maree mariasa nariqa manda oosana maree marianara nári nimoo naamoo qidaqa. Ainainara kaaqa rimarifa Yaaweena aquraraseenoo mina ameesa ubeekama amaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Manda oosana maree mariasa sia Yaaweenara qeerairidaqa. Nári nasuriranakiqari Anutunara sia anoonee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Manda oosana auqee mariasa aiqama ainaina auqaafa anoona kambiqaidanoo. Misa sia Anutuna iriranara iridaqa. Misa nári namuqaa uqmairaaqmairamma nimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Misa náriara maaqi qidaqa. Maasa sia aqufuanauree qidaqa. Sia maasa moo ummaaraki marianauree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Misa ufa qirafa niqurara ufa faqa unna ufa faqa naaquqara ufa faqa kai umbiqanoo maridanoo. Misa kai kaqi fidiaqaa ira manda ufauqa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Misa aiqama maqusakiaqa kukeeaqa maridaqa andeeqara fasiqauqa kuqa narirara nimaarusidaqa. Misa afeeka siaisa nimaara kukeeqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Misa kaasau fainiara foora kukeeaqa maridaqa rakisidaqa. Misa miqimandee ainaina siaisara rakisidaqa. Misa ufaana fufuqaanaki arufuafaqa oonu rarisamammaree fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Misasaaroo qirausa sia marisa narusaafaqa maqasaa aqufuafaqa nikunnai radamuqaafaqara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Manda oosana maree mariasa maaqi qimasee nariqakai qidaqa. Anutufa qini manda oosanara fifau ainainee qidanoo. Mifa afu tautasee sia qini qiqafaannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Oo Yaawee, miqira manda oosana maree mariasa aupurarana nimia. Kafaa aupuraranaki mariasara sia qaunua, misa faqa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Manda oosana maree mariasa naqimmasee fee Anutunara unnaqimasee maaqi qidee. Mifa sia maasa aupurana qimiannoo fee qidee. ");
INSERT INTO bjr_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Oo Anutu anee niqafee mariananoo, anee ummaaraki mariasa faqa aupuraranaki mariasa faqa niqafaidana aiqama kari dadaaqirara deedaqi marianafa mariananoo. Misasaaroo qirausa siaisa aniki nári nifaaqa quqaidaqa. Anee ooqaindari sarau imariasa dadaaqi marianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Manda oosana maree mariasa faqa aaqee mariasa faqa misa afeeka qumaree raqurusaa. Anee misa manda oosana auqaana akiiqara aupurarana niminaqa sia kaifaa miqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yaaweefa naaru naaru uriqarara Karaambaiqa maridanoo. Aiqama unna anutusa nimooqi mariasa mina maqa maaqakiqari taikafifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Oo Yaawee anee oorudupirausa innaaru irinnaranoo. Anee misa paasoosirana niminnaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Anee fiaiqi faiqi faqa rafaaqafu nimmaqee mariasa faqa iki raqarana irinnaranoo. Anee misa ufa irinnisainna kari misa dadaaqinnaranoo. Miqinaqa maqasaa fasiqa rufiarana firaana nimimariasa sia kafaa miqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Qinee Yaaweena saqarikiananoo mifa qini ititaqimaqaannoo. Anee nana furufaree inanee qiniara ufiniara foora qaqamaree aaqanai ooru fuannee qidanee. ");
INSERT INTO bjr_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Misa maaqi qimasee kaifaa unna qimasee qima qimidaqa. Manda oosana maree mariasa nári duru rambaqa fufusee, dindaramasee andeeqarausa qumee kukeeqaindari nariraree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Maa maqanasaa aiqama maasa dadaaqi maria ainainausa mandaikinaqa andeeqara fasiqauqa naqaa fee ifaree. ");
INSERT INTO bjr_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yaaweefa narí naaquqara amaana maqaki maridanoo, mina ufirira qaari innaarunai ufiqinoo marifanoo minasaa maridanoo. Miqooqari mina afu fannoo aiqama fasiqa anaasee aiqamatinai nindafaidanoo. Misa auqee marianara iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yaaweefa andeeqee mariasa faqa aaqee mariasa faqa amana amana kai niuqidanoo. Sia mina sandufa afaqee mariasara Yaaweefa narí amuqusa aiqamannoo misara fidiaqaammidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Mandoosana maree mariasa Yaaweefa ida qauni namufaqa idauru fasafasi marina namufaqa nammariara foora teeqimma nimaqaidanoo. Mifa ididimari ufainannoo misa aupurarana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yaaweefa andeeqarafa maridanoo. Mifa andeeqaranara aididanoo. Miandeeqara oosanna maree mariasa misa Anutuna oorisaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Oo Yaawee maasa dadaaqia, sia uqanna moodaa andeeqara fasiqa maridanoo. Kuqaa kai qimari fasiqanara randeenana sia paqurinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Misa nári niqoonausara unnufa kai qiqanuasa maridaqa. Misa fadameena akusee nikaru qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Oo Yaawee anee fadameena akira ufa qimaria nifauruna ititannisaa. Nári nimooqida nári nuqu uqeeree maria nifauruna faqa ititannisaa. ");
INSERT INTO bjr_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Misa maaqi qidaqa maasa qeeqa ufannai maasa didimari ainaina maraidaqee qidaqa. Maasa didimari ufana kaqi qianaura, sia moo fannoo maasa doo ititaannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Yaaweefa maaqi qidanoo. Kudi fasiqauqa rafaaqafi marianara faqa aupurarana nimiafaqa anaadannada qimarianara faqa qinee maqee aniree misa dadaaqianauree qidanoo. Qinee anireeqa nifaaqa quqasee mariranara rakisimariana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yaaweena qima afeekaikira ufasaa nifaaqa quqee mariafa maridanoo. Mi ufafa amiqira siruaa qisauku dinni taikasee dinni ani qaara marasee 7 kari tisirisiri maqaafara foora kaaqa amiqirafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Oo Yaawee anee maqee maqee maasa ititaqisaa. Mi manda fasiqausasaa ititasainaqa sia maasa mandaikamma qimaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Manda oosana maree mariasa aiqamatinai maridaqa. Aiqama fasiqa anaasee mandoosanara amiqira ainainee qimasaida asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Oo Yaawee kisaaqasaa fee anee qiniara qauninnaree. Naaruara naaruara miqi fee imarinnaree. Anee kisaaqasaa fee qini qifusaaqari kukeeqana marinnaree. ");
INSERT INTO bjr_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Kisaaqasaa fee qinee aupurarana uaqee maridaqee. Daunduraki rairai qimari umaaranara oonu mafi irianauree. Aiqama eendaki faasaana kisaaqasaa fee qini aiaaee qirafa mariannoo fee. Kisaaqasaa fee qinee namuqaa nimeemaanai marianuree. ");
INSERT INTO bjr_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Oo Yaawee qini Anutu anee amiqimasee qini qiqafamasee qini ufa anoona qimaqimia. Anee kafaa qini afeeka qiminaqa sia kuqua. ");
INSERT INTO bjr_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Oo Yaawee anee sia qini namuqaara qinaqa qiniara mina doo rafaaqafusee fee qiaqa. Anee sia qini namuqaara qinaqa qinee saamuruannanara nasuriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Anee maqee maqee qiniara aidimariannanasaa qinee mundidaqa. Anee qini asumu marainnanara qinee asasianaura. ");
INSERT INTO bjr_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Oo Yaawee anee qini amiqi amiqimma qimaqoonnanara ani amooqira idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Furufari mariasa nári nimuqusakiqari maaqi qidaqa sia Anutufa maridanoo fee qidaqa. Miqi qimariasa furufarira oosana maraidaqa. Misa kaaqa aaqara oosana uqanna auqee mariasa maridaqa. Sia moo fannoo andeeqara oosana maraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yaaweefa innaarunaindari maa maqanasaa faiqí faiqi mariasa niuqidanoo. Mifa irirana faqaasara randaifaqa sia maridaqa. Akaqausa qini Anutusara inaaru qidafee qimasee randaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Aiqamausa quandaki kaqi runna fidaqa. Misoo maasoo amana amana kai mandaiki marunausa maridaqa. Sia moo fannoo andeeqarausa maridaqa. Sia uqanna. ");
INSERT INTO bjr_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Anutufa maaqi qimasee iraidanoo, misa sia fee iridafee. Aiqama maa aaqara oosanna maree mariasa irirana siaisee maridee. Misa qini faiqí anaasee feemuara foora nama taikaidaqa. Misa sia qiniara aiqama kari innaaru qimariasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Miqi mariasa firaaqoo rufiee faranoo. Anutufa narí ufamau fimariasa faqa maridanoo dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Narí mara maree qumimarifa moo ainaina auqarara oonu mafi irifaqa aaqeemariasa itita amaqaafanoo Yaaweefa mina dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Qinee maaqi qimasee firaaqoo innaaru qidaqa, Isaraee maqannaasa dadaaqirafa Sioonna maqusakiqari anianifee qidaqa. Yaaweefa Isaraee maqannaasa nári maqa maaqa faqa qumiasana faqa kafa rairaamma saina misa firaaqoo asasifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Oo Yaawee, yafee ani amaana maqaki keeqaannoo fee. Yafee Sioonna ani naaquqara aaqanasaa marida innaaru qiannoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Aiqama ainainaki ani ufa mau fimariasa faqa andeeqara oosana auqee mariasa faqa nári nimuqusa ookiqari anoona ufa kai qimariasa faqa ani naaquqara aaqanasaa marida innaaru qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Sia aqoonnana manda auqu amifa faqa sia narí aqoondi mandaikamma amaqaifa faqa sia nári niqoonausara munuqi miniqiasa faqa mi naaquqara aaqannasaa marida innaaru qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Anutufa ameesuqu nimaqaqaisara andeeqarausa faqa misara fidiaqaa idaqa. Yaweena ufa mau fimariasara uriqararausee qidaqa. Moo fannoo narí amana aiqamasee moo ainaina auqararee qimasaifanoo mi faasaanna moo ummaara kambiqaifanoo afai riqiseenoo oonu mi ainainna auqeenoo narí qima afeekaikira ufa taikaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Faiqí moo fannoo narí ufaasu munnimma nimiseenoo aabaa munnimma siaina naríndi amana kai maree marifa faqa, aaqarana siai fasiqana mara ufaki quqaanifee qimasee munnimma amiafanoo qeerairi mari fasiqafa faqa ani naaquqara aaqanasaa marifaranoo. Mi aiqama ainainausa auqee maria fasiqausa misa naaruara mapukusee marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Qinee ani saqariki marunnanara ititaqimaqa. Oo Anutu, anee qini ititaqimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Qinee Yaaweena maaqi qimasee qimamiqa. Anee qini Yaaweefa mariananoo. Aiqama ainaina anee iannannaindari kai qiniki anidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Faiqí anaasee Yaaweenaki mapukusee mariasa kaaqa andeeqarausa maridaqa. Qini firaa irirafa misa faqa marirara dididanoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Unna anutusa iannai sandee mariasa oosana oosana ummaara nári nifaaqai mara quqaidaqa. Qinee sia misa faqa aandau tatufirana suqaanaura. Qinee sia misa faqa misa unnaqira anutuna amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Oo Yaawee, anee kai qini aiqama ainainara foora mariananoo. Qini didimari aiqama ainainna anee qimimariananoo. Qini marirafa ani asaukuki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Anee qimimarianna ainainausa amiqirafa kai maridanoo. Mi ainainausa aiqama kaaqa amiqirafa kai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yaweefa qini aana muquni marinara mina amooqidaqa. Eendaki qini daakirafa daakapaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Qinee aiqama kari Yaaweena afusaa marunnanara iridaqa. Mifa qini faqa marinara sia moo ainaina fannoo qini kasi kasimma qimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Minara qinee dufi dufi qidaqa asasidaqa. Qinee kaaqa amiqiranaki marunnanara miqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Anee kuqira afeeka ameemaanaindaraana ititaqimaqaannanara miqidaqa. Anee aneenna aidimarina sia minnisainanoo mifa kuqufinoo putaaiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Anee kisaaqasaa maa maqanasaa marira aana qini uqafiqeennaranoo. Ani afusaa marunafa asasirana qumbiqa qimaqaidanoo. Mifa naaru naaru marira asasirana qimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Oo Yaawee andeeqaranara innaaru qimarunnana iria. Qinee dadaaqianneera innaaru qimarunnana faqa iria. Qini kuqaa qira innaaru iria. ");
INSERT INTO bjr_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Anee andeeqaranara irimariannanara qini qifairi mariana dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Yaawee anee qini qimuqusara irimmariananoo. Anee eendaki qinee unnannai anireenana qini qimanammasee qafaananoo sia manda irirafa qiniki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Qinee sia akaqausa naannareeqa manda ufa qidaqa. Qinee ani naakapara ufa qaindusidaqa sia faiqi narimariasa fimaria aatata fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Qini qiku fannoo ani aatata kai fida sia munuree miniree unausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Oo Anutu anee qini inaaru irimariannanara qinee aniara innaaru qidaqa. Minara anee aneenna aaqoo rammatinimambi qini innaaru qirana iria. ");
INSERT INTO bjr_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Oo Anutu aneenna firaa amuqusirana maasa uqaqifiqaseenana anee maasa asumu maraqisaa. Maasa ani mandaaqaqa maridaqa sia namuqaa dariratinai marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Anee aneenna afu rakisianandee kai masee qini faqa rakisia. Anee aneenna aumooki quqaseenana rakisi qimaqainaqa qini namuqaa sia daruaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Qini kuqa darirara imariasa qini fiqu fiqu iqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Misa qimudaoo qirana siaisa, nári nimoo naamoo kai qimariasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Misa qini itita qimaqaqaafaqa qinee firannai anirannaira idaqa. Misa qini qumara rudammiqi qaqeeidaqa rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Misa kaasau fainiara foora qini qimaara usidaqa. Qini qumarasee rakeekaa irara miqiqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Oo Yaawee anireenana qini namuqaa noorisaa oonureenana misa narusee urinnaaqaraa. Aneenna rakira paipanannai mandoosana maree mariasa narusee misa nisaukukinaana qini maraa. ");
INSERT INTO bjr_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Oo Yaawee maa maqanasaaqaraa aiqama ainaina náriara kai maree mariasa nisaukukinaana qini mara qisaa. Anee misa narirara nimaara usuqaanna samu misa narua. Naridana mina atisamu kaqi marinana misa faiqi namu faqa ninaiqimara faqa kasooqaqee kambiqaifana misa faqa narua. ");
INSERT INTO bjr_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Qinee sia aaqara ainaina auqaunnanara qinee ani qafaanaura. Qinee faiqaqee iinaqa findi fuananoo ani afusaa marira oosana fannoo qini asasirana qumbiqa qimiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Anee qini itita qimaqee marianafa mariannanara ani Yaaweenara firaaqoo dididanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yaaweefa qini itita qimaqee marifa maridanoo. Mifa qini afeeka faandaamurara foora maridanoo. Qini Anutufa qini itita qimaqee marifa maridanoo. Minaki marunnanara asumu maridaqa. Mifa qini rakira saqariara foora maridanoo. Mifa qinisaa ititaseenoo qini asumu mara quqaqisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Qinee Yaaweenara innaaru qunanoo qini namuqaauqa darirari mariana kinaana asumu mara quqaqiseenoo. Minara Yaaweena amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Manda kuqirafa qini fiqu fiqu inoo marifanoo, darirafa ooruku nammari amakauriara foora inoo qini rafaaqafidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Manda kuqirafa qini fiqu fiqu inoo marifanoo, faiqí madika fannoo ufaanara foora qini qimaara fufinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Qeeqa ummaarakiqari Yaaweena aareeqa. Qinee qeeqa Anutuna dadaaqianifeera aareeqa. Narí amaana maqakiqari qini nammeera qirana irinoo. Qinee dadaaqianifeera nammeera qiqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Anutufa qini namuqaara aranaqainara maqa kasifanoo aaqanauqa doori doorifanoo firaa ooniuqa faqa kasi kasidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ida muna fannoo Yaaweena aikaamaraindari anifanoo aiqama ainaina qama taikara ida faqa ida qauni namufaqa mina ookiqari anidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Yaaweefa innaaruna rakeemmafufanoo quminau. Mina aiku ameemaanai asukuna arira oonnamu marinau. ");
INSERT INTO bjr_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Yaaweefa aqoosa faqaa ainainasaara foora ooqu marifinoo qaqamaree ufaimau quminau. ");
INSERT INTO bjr_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Mifa asukunannoo narí kukeeqasoofanoo, amatooki oonnamu aaku suqirafa mina fiqu fiqu inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Pupusamu faqa idauru fasafasirafa faqa mina oorinni aakuasaa iranakiqari qumureenoo asukuna arira oonnamu rakeeinau. ");
INSERT INTO bjr_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yaaweefa innaarunaindari innaarunai qiara foora qufaqa kaaqa uriqarara Anutuna ufa iriqau. ");
INSERT INTO bjr_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Yaaweefa miqi qidanoo narí feefauqa qumaree aquseenoo namuqaa narufaqa daraaniqau. Mina aakuasaa fannoo feefara foora aqusee narufaqa quqasee sandaqau. ");
INSERT INTO bjr_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Anee aneenna namuqaauqa niqiseenana aranaqoofana rairai qimannimaqee marinau. Miqunanoo ooruku nammari ameemaanaindaraa maqa koorooinau. Maqa ameemaanaindaraa ooniuqa faqa koorooinau. ");
INSERT INTO bjr_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Yaaweefa innaarunaindari qini nammari farumakinaanara foora qisauku qumaree uqeera quqanau. ");
INSERT INTO bjr_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Mifa qini afeeka namuqaauqa nisaukukinaana mara kaqinni quqaqiseenoo, qiniara fidiaqaa imariasa qini uridaaqarara afeeka faqaasa nisaukukinaana faqa mara kaqinni quqaqisanau. ");
INSERT INTO bjr_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Qinee ummaaraki mariafanaqa qini namuqaauqa qini darirariqau. Miqufanoo Yaaweefa qini ititaqimaqanau. ");
INSERT INTO bjr_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Mifa qiniara asasi marunara qini manda ummaarakinaana dadaaqamma qisanau. ");
INSERT INTO bjr_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Qinee andeeqee marunnana akiiqara amiqi amiqimma qimaqeenoo. Qiniki sia aaqarafa marinara miqimma qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Qinee Yaaweena sandufamau fimarunausa maridaqa. Sia qeeqa Anutuna qimeesa uqusee mandoosana maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Qinee mina aiqama sandufamau fimarunausa maridaqa. Qinee sia mina naamuaqira ufa rukiqaunausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Qinee aaqarana siaisa marunnanara mifa iridanoo. Qinee kaqi runna fuanoora qeeqa mariranasaa rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Qinee miqunnana akiiqara faqa andeeqara oosana maraunnanara faqa mifa amiqimma qimaqaidanoo. Qinee aaqarana siaisa marunnanara miqimma qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Oo Yaawee aniki mapukusee mariasa anee misa mapukunnimaqee mariananoo. Kaaqa andeeqee mariasa anee amiqi amiqimma nimaqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Anee kaaqa anukarausa andeeqa nimaqee mariananoo. Mandoosana maree mariasa mandaikamma nimaqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Nári mara maree qumi mariasa anee asumu maree mariananoo. Nári nuqu uqeeree mariasa anee mara maree qumimariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Oo Yaawee anee kaaqa qarana qimiananoo asukuna rakeemma qisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Anee qini afeeka qimianaqa qeeqa namuqaauqa naru nindaqaaqa idaqa. Miqimmaseeqa misa afeeka faandaamura aafeeqaramaki aqufiqa naru nindaqaaqa idaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Mi Anutuna oosana fannoo andeeqanoo maridanoo. Mina ufasaa faiqí mundimaria ufafa maridanoo. Mifa narí mandaaqee mariasa rakira saqariara foora maridanoo, ititannimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Yaaweefa kai Anutufa maridanoo. Anutufa kai maasa faandaamura maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Mi Anutufa kai qini afeeka qimiseenoo, rakisiqimaqee marifaqa qifaaqa quqasee aana nidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Mifa qini qiku afaidama saifaqa kaasau aandaura foora sandaidaqa. Qinee aaqanauqakiaqa nimarunanoo mifa qini rakisi qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Mifa qini rakira oosana uqaqifiqasaifaqa qinee afeeka duru uqanna rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Oo Yaawee anee qini itita qimaqaseenana asumu mara quqaqisaananoo. Ani rakisi qimaqarafa qini duqu uqeereenoo. Ani afeeka fannoo qini ititaqimaqaseenoo asumu marirana qiminoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Anee qini aana amiqimmasaanaqa sandaidaqa sia qiku qamaki saamurunaqa namuqaa qini qumareea. ");
INSERT INTO bjr_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Qinee qeeqa namuqaa sia minniseeqa nifaqaqa fifiifaqa oonu qumarasee naruseeqa kai seeqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Qinee oonu misa naru quqasaunaqa qini qikuki aqufiqa sia findifirana amanaikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Oo Anutu anee rakira afeeka qini qimiseenana qeeqa namuqaa rakiranaki urinaaqarara afeeka qimianaqa misa urinnaaqareeqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Anee qini namuqaara qianaqa misa qini daaqu rufiasee sandeea. Sandaafaqa akaqausa qiniara fidiaqaa imariasa naru taikeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Misa akaqausara dadaaqiaqeera faaqaruafaqa sia dadaaqirausa maridaqa sia dadaaqia. Misa Yaaweenara faqa dadaaqianifeera aaraafanoo sia misa innaaru qirana irinoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Qinee misa radamusaunaqa misa kookoommaika mafuafanoo ufai fannoo misa fuaqa aqinoo. Misa aatataqaraa doonara foora mariafaqa qinee misasaa qiku reeqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Anee qini aanoo qimaqimaqee mariasa nisaukukinaana asumu mara quqaqiseenana moomoo maqannaasa rakisirausaikamma qisaananoo. Miqimma saanaqa qinee sia irunna fasiqa aanaaseesa qini qimeemaanai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Anaamuru qini qikuki niqoori saunu araidaqa Misa qini ufa irisee qini ufamau fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Misa afeeka taikafifaqa nariqa afeeka faandaamura minniseeqa naindiri raifaqa qinee unannai anidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Yaaweefa kaqi marifa maridanoo. Qini ititaqimaqee marina amooqiaqa. Qini namuqaa nisaukukinaana asumu mara quqee mari Anutuna uriqararanara kooroo iaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Mifa qini namuqaauqa urinnaaqarara afeeka qiminoo. Mifa moomoo maqannaasa qini qimeemaanai mara quqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Miqimmaseenoo qini namuqaa nisaukukinaana asumu mara quqaqiseenoo. Oo Yaawee, anee qini namuqaa urinnaaqarara afeeka qimiseenana faiqí kuqa narimariasasaa ititaqisaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Miqiannanara qinee moomoo maqannaasa qambaanaindari ani amooqidaqa. Qinee ani amooqira idi raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Anee qini Dafidisa utaaqama qaanausa aneenna sia taikaaninna amuqusirana qinisaa faqa naaru naaru qinisaa ani aruakinausasaa faqa quqaananoo. Minara Anutufa rakira afeeka qini Dafidisasaa quqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Innaaruna fannoo Anutuna qareenaranara firaaqoo koorooidanoo. Innaaruna fannoo kaifaa Anutufa auqoo ainainausara kooroo idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Maqee faasaana fannoo Anutuna areenaranara duna faasaana qimamidanoo. Eendirafa miqikai qimasee moo eendirana qimamidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Iaqarafa faqa eendirafa faqa sia noo mari faqa sia ufa qidaqa. Minara maasa misa ufa qirana sia iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Miqinoo marifaqa aiqama maqa maaqaindari misa Anutunara koorooimariana qafaidaqa. Maa maqana ati munu taikee mini taikee irannaindari misa ufa iridaqa. Innaaruna Yaaweefa uiqaana maaqara foora usakasaifanoo suani minaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Suani fannoo minakiqari narí fuka anaasee amundara anaasee mararara foora asasidanoo suani qaidanoo. Mifa sandaranaki amani mariasara foora sandarara deedaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Suani fannoo innaaruna atisaaqari urureenoo fifiifanoo meeqai dinni keeqaidanoo. Sia moo ainaina fannoo mina ididiranara rufiasee kukeeqaanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yaaweena sanda ufa andeeqarafa uqanna maridanoo. Mifa fuka afeeka nimidanoo. Yaaweena naakaparufa minasaa mundi mariafa maridanoo. Mifa irirana siaisa irirana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yaaweena sandufa andeeqarafa marifaqa mi ufamau fimariasa asasidaqa. Yaaweena naamuaqira ufa fannoo amana amana kai andeeqa nimaqaseenoo maasa qitikuraki irirana moo faqa moo faqa qimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yaaweena oorinni nisaurusee madoodoonnara oosana fannoo kaaqa anukarafa maridanoo, naaru naaru kaqi kai mariannoo. Yaaweena ufa irirafa andeeqarafa marifanoo aiqama kari amana amana kai rainannimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Yaaweena ufa irirafa amiqira koora uqanna uriaaqararafa maridanoo. Mina adiafaairafa ookasaasa anoona adiafaairana faqa arusee uriaaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Mi ufausa qini Dafidisa ani ainainira faiqi irirana qimidanoo. Qinee mi ufamau fimarunnana akiiqara anee Yaaweefa amiqi amiqimma qimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Sia moo fannoo narí aaqara oosanara iridanoo. Oo Yaawee, qinee kukeeqara aaqaranaki marunnana mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Qinee iridaqa faqa aaqee marunnanasaa ititaqisaa. Sia mi aaqarafa qini rakisi qimaqaani. Miqimma qisainaqa andeeqafuananoo mandoosana fannoo sia rumba qimaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Oo Yaawee, anee qini afeeka kukeeqara maqusa faqa qini asumu maree marianafa faqa mariananoo. Amanee qini ufara faqa qini iriranara faqa amiqira fee qimasee eedoo qia. ");
INSERT INTO bjr_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Anee ummaaraki maridana Yaaweenara innaaru qinanoo ani dadaaqiani. Yakooboona Anutufa ani itita amaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Mifa Sioonna aaqanasaa narí naaquqara amaana maqakiqari ani dadaaqiani. ");
INSERT INTO bjr_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Mifa anee aminna ainainara eedoo qimasee ani aiqama aandau tatufiranara faqa asasiani. ");
INSERT INTO bjr_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Anutufa ani aidimari ainainna amiani. Anee oonu mafi irinna ainainafa anoona kambiqaani. ");
INSERT INTO bjr_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Anee rakiranaki urinnaaqaraannanara asasida faaqa ruanaura. Anee rakiranaki urinnaaqaraannanara maasa qeeqa Anutuna idi raidaqa amooqianaura. Anee aiqama ainainara irainnana Yaaweefa iriani. ");
INSERT INTO bjr_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Doo maqee qinee iridaqa Yaaweefa rakirana uriqarara afeeka narí utaaqamaqai karaambaiqana qini Dafidisa qiminoo. Mifa narí amiqira maqusa innaarunaindari qini innaaru qirana irinoo. Yaaweena afeeka fannoo firaa rakiranaki uriqarara afeeka qiminoo. ");
INSERT INTO bjr_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Rakiranaki akaqausa nári qoosa rarisee mari karana saqarikidaqa, akaqausa nári qoosa saqarikidaqa. Miqi mariafaqa maasa Yaaweena maasa Anutuna mina afeeka saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Maasa namuqaa mi rakira ainainausa saqariki mariasa niku amaki saamurifaqa maasa kaqi afeekaikammasee kikiqiqa marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Oo Yaawee anee rakiranaki uriqarara afeeka qini Dafidisa qimia. Maasa ani aaraanana maasa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Oo Yaawee anee Dafidina afeeka amiannanara asasidanoo. Anee mina dadaaqiananoo rakirana uriaaqarainara firaaqoo nasuridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Anee mina amuqusaki aidimari ainainna amiananoo. Anee mifa irai ainainna faqa amiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Anee mifinnai anireenana firaaqoo amiqi amiqimma amaqaananoo. Miqimmasee anee uriqararausa qata koorannai auqirana afisu amaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Mifa mariranara iraifana anee amiseenana mina marirana kisaaqaikamma amaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Anee Yaaweefa dadaaqiannanara mifa uriqarara auqu mareenoo. Anee mina afeeka faqa uriqarara auqu faqa amiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Ani amiqi amiqirafa naaru naaru mina faqa mariannoo. Ani afusaa marirafa mina asasirana qumbiqa amidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Dafidifa Yaaweena aiqama afeeka faqaana saqarikidanoo. Yaaweena kaqi marira aidirafa marinara mifa aiqama ainainaki afeekaikammasee mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Dafidifa narí aiqama namuqaa rumbannimaqaannoo. Mifa nariara fidiaqaa imariasa faqa rumbannimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Mifa anireenoo idaurunnoo narí namuqaa aiqama kuridi nimaqaannoo. Yaaweena arana qarafa misa nambiqamasaannoo. Ida fannoo misa qama taikaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Sia uqanna misa atikiqari moo fannoo kaqi mariannoo. Dafidifa aiqama naru taikaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Misa mina ariraree qimasee tipundaaramma saifanoo sia misa tipundaarirafa anoona kambiqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Mifa feefa niiqamasainaqa quqasee sandeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yaawee maasa ani firaa afeekara amooqidaqa. Maasa idi raidaqa ani afeekara amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Oo qini Anutu, qini Anutu, naqifee ifanee anee qini minniqiseenanee. Anee naqaa fee ifanee aadumai nianasaa maridana sia qini dadaaqidanee. Anee naqaa fee ifanee sia qini ikiraqarana irinanee. ");
INSERT INTO bjr_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Faasaana ani qeeqa Anutuna aaraunana sia maqi qiananoo. Eendaki faqa aaraida maridaqa sia idooeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Anee naaquqarafa andeeqara oosana faqaafa mariananoo. Isaraee maqannaasa ani amooqi mariafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Maasa qikeeku qikaaku ani saqariki mariqau. Misa ani saqari kammasoofana anee misa asumu mariaqeera maranau. ");
INSERT INTO bjr_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Misa manda ainainakiqari ani auqu roonannai asumu mariqau. Misa ani saqarikida sia nisaurirana mareea. ");
INSERT INTO bjr_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Qinee oorudupirausa fifau doodaaniara foora maridaqa. Qiniara nikooqaifaqa fidiaqaa midaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Misa qini qiqafeeqa uteeti qimasee nimaakiri rummiqi qimaqaidaqa. Miqimmasee misa ninuka aqidaqa maaqi qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Anee Yaaweenasaa mundi mariananoo nanaree mifa sia ani dadaaqidanoo fee. Yaweefa aniara aidi marifanoo nanaree mifa ani sia itita amaqaidanoo fee. Nanaree sia ani dadaaqidanoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Oo Yaawee anee kai qini qinoona aranandakinaana amiqimmasee qini mara akoonnai quqaqisaananoo. Qinee aanaaqi maridaqa qeeqa qinoona naamma neemariafanana anee qini amiqimmasee rakisi qimaqee marunaqa mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Qinee qeeqa qinoona aranandakiqari kambiqaafannaqoo qari anisaa mundiqa maridaqa. Miqiqa marunana anee qini Anutufa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Ummaara qiniki maridanoo, sia nianai maria. Sia qini dadaaqirausa maridammia. ");
INSERT INTO bjr_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Namuqaa moomoo kaasau aandaura foora qini fiqu fiqu iqa maridaqa. Misa Basaana maqa maaqakina afeeka kaasau aandaura foora qini fiqu fiqu iqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Misa kaasau fainiara foora nooraqasee qini qipata anaqirara rairai qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Nammari maqasaa adiasaafanoo dadasindee inoo qini afeeka taikeenoo. Qini qimudaani aiqama radukinoo maridanoo. Qini qimuqusaki daaquqarafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Qini qimaaqaara aadana usidanoo. Qini qimaakiri qimaaqaarai atooqanoo maridanoo. Anee qini kookoommaki rumaqimaqa qaanaqa kuqirara midaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Manda oosana maree mariasa aanoo qimaria fainisara foora qini fiqu fiqu iqa maridaqa. Misa qini qiku qisauku aakumaree rakee iraridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Qini qimudaani akooqoo marifaqa misa qini kaaqa tataqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Misa qini qammunna marasee rainaidaqa. Qini siuta raipaqusee kaatara foora sararammasee mareea. ");
INSERT INTO bjr_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Oo Yaawee sia anee nianai maria qini daaqa ani maria. Kai kaqi aniree qini rukia qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Oo Yaawee misa nookinaana qini mareeqee asumu quqaqisaa. Maa fainisa nookinaana qini mareeqee kaqinni asumu quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Kaasau fainiuqa nookinaana mara kaqinni quqaqisaa. Qinee kaasau aandauqa nifusaa ititarausa sia mariafaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Miqimma sainaqa anee auqaanna ainainnara qinee qeeqa maqannaasa qimannimianaura. Qimannimisee qinee misa suqiranakiqari ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Innee Yaaweena ainainira faiqiuqa mina amooqiaqa. Innee Yakooboona aiku asauku mariasa mina auqu uqeeraaqa. Innee Isaraee maqannaasa mina kai amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Yaaweefa sia kudi fasiqauqa sarau imarianara irisee ameesuqu nimaqaidanoo. Sia oori rafusu kaqinni aqidanoo, mifa misa innaaru qirana iriseenoo dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Qinee firaa suqiranaki anee auqaanna ainainnara ani amooqianaura. Ani amooqirara suqiqa mariasa nifusaa ani amooqianaura. Qinee qima afeekaikammasee suqa amianauree qiafanna tatufirana suqa amianaura. ");
INSERT INTO bjr_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Sarau iranaki mariasa narana namasaifanoo nimuaqu imarina marifaranoo. Yaaweefinnai anirainausa mina amooqifaranoo. Miqi mariasa naaru naaru aiqama ainaina amanaikirausa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Aiqama maqannaasa Yaaweenara irifaranoo. Aiqama maqa maaqakinaasa mifinnai ubeekeefaranoo. Aiqama fasiqa anaasee mina amooqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Yaaweefa karaambaiqa maridanoo aiqama maqannaasa rakisinnimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Aiqama ramoo ramaa imariasa mina oorinni niqoori saunu areefaranoo. Aiqama faiqí faiqi mina oorinni niqoori saunu areefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Naaru kambiqainausa mina ainainira faiqiuqa marifaranoo. Misa kasooaqee kambiqainausa Yaaweenara qimannimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Yaaweefa narí faiqí anaasee maroonara naaru kambiqainausa qimannimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Yaaweefa qini sipsipasaara foora rakisi qimaqee marifaqa qinee sia moo ainainara sarau ianaura. Mifa qini mareeqeenoo sipsipara foora quqeenara andandaki quqasaifaqa namasee faiqaidaqa. Mifa qini qifiqeeqee amiqira nammari reendeenammasee ooqu fimarina afaisaa quqaqisaifaqa namasee idooaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Mifa qini fuka afeeka qimidanoo. Mifa narí qima afeekaika maqoomau finoo qini andeeqara aatata kai qifiqee fidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Yaawee anee qini faqa mariannanara qinee kuqira ummaaraki asukuna titunaanu qiranakiara foora fidaqa sia moo mandainainara rufiaanaura. Ani saunu faqa unnaana samu faqa qini itita qimaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Anee qini namuqaa nifusaa firaa oomaqa qini qimiananoo. Qinee uriqarara fasiqara foora marunana qini daarama quqaananoo. Anee amiqi amiqira ainaina namariara foora qini kaafaki adia afairaqaramma qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ani amiqi amiqirafa faqa amuqusirafa faqa qini faqa mariinoo kuquananoo kai taikaannoo. Ani amaana maqa fannoo qini maaqara foora marinaqa qinee minaki keeqee raudee iiqa kuquananoo taikaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Maa maqa maaqafa faqa aiqama minakinaa ainaina faqa Yaaweenaindi kai maridanoo. Maqa faqa minasaa maria fasiqa aanaaseesa faqa minaindi kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Mifa maa maqana ameemaanai maru nammarina amuaaqa auqu quqanau. Quqaseenoo mina faakanauqa maqa ameemaanaindaraa nammariki rakiqanau. ");
INSERT INTO bjr_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Yafee amana Yaaweena aaqanasaa oorufuannoo fee. Yafee amana mina naaquqara amaana maqaki keeqaannoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Andeeqara oosana auqee marifa faqa amiqira amuqusa faqaafa faqa sia unna anutusa nimooqi mariasa faqa sia unna qimasee nimana aiqee mariasa kai minaki keeqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Yaaweefa misa asumu mara quqasee amiqi amiqimma nimaqaannoo. Miqimmaseenoo Anutufa misara aaqarana siaisee qiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Miqira fasiqauqa Anutufinnai anidaqa. Misa Yakooboona Anutuna oorinni fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Innee faandaamura kooqiuqa firaaqoo atua aquaqa. Innee ooqeennaa amaana maqa kooqiuqa faqa atuasaifanoo uriqarara karaambaiqa keeqaani. ");
INSERT INTO bjr_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Yafee mi uriqarara karaambaiqafa maridanoo fee. Mifa Yaaweefa afeeka faqa eeraara faqa faqaafa maridanoo. Mifa Yaaweefa aiqama rakiranaki uriqaree marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Innee faandaamura kooqiuqa firaaqoo atua aquaqa. Innee ooqeennaa amaana maqa kooqiuqa faqa atuasaifanoo uriqarara karaambaiqa keeqaani. ");
INSERT INTO bjr_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Yafee mi afeeka karaambaiqafa maridanoo fee. Yaaweefa aiqama maqannaa uriqarara afeeka faqaafa, afeeka karaambaiqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Oo Yaawee qeeqa innaaru qirana ani amidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Oo qini Anutu, qinee ani saqarikidaqa. Namuqaa darifaqa qisauruanoora anee mi dariranasaa ititaqisaa. Anee dadaaqinaqa qini namuqaa sia qiniara ataasa ataasa qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Ani saqariki mariasa namuqaa rafaaqafu nimaqarafa sia maridanoo. Qusufa qimasee ani Yaaweenara kaukaata qimariasa namuqaa misa rafaaqafu nimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Oo Yaawee anee fimarianna aanna qini uqaqifiqaina fua. Anee fimarianna aannara qini daamuaqinaqa iria. ");
INSERT INTO bjr_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Anee qini Anutufa qini asumu maree marianafa mariannanara ani anoona ufa mau firana daakapa. Qinee aiqama kari ani saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Oo Yaawee aneenna qimudaoo qirana faqa aneenna naaru marira amuqusirana quqannifiqoonnanara oonu mafi iria. ");
INSERT INTO bjr_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Qinee kumaaraasaa auqaafanna aaqarana akiiqara minniqisaa. Oo Yaawee, aneenna naaru marira amuqusiranannoo faqa aneenna amiqi amiqirannoo faqa qiniara oonu mafi iriqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yaaweefa andeeqara marirana faqaafa marinara aaqee mariasa andeeqara aanara naamua qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Nári nifaaqa mara maree qumi mariasa Yaaweefa andeeqara aatata nifiqee fidanoo, narí aidiranara qimannimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Mina moodaanaki kira ufa faqa mina sandufa faqa afaqee mariasa Yaaweefa narí mapukusee marira oosanannoo faqa narí amuqusiranannoo faqa nifiqee fidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Oo Yaawee, aneenna qima afeekai kiranara oonumafi irisee qini moomoo aaqarana akiiqara minniqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Yaaweenara naaquqee marisa mifa amiqira aanara qimannimiannoo. Qima niminaqa mi mau fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Misa aiqama ainaina amanaikiranaki amiqiranaki marifaranoo. Misa faiqi namu maqa maaqa mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yaaweefa mina ufa qaindusi mariasa niqoondi maridanoo. Mifa narí moodaanaki kira ufa qimaqoona kafaa qimannimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Qinee aiqama kari dadaaqianifeera Yaaweefinnai qifu maqaidaqa. Miqi marunanoo mifa qini manda ainainakinaana itita qisee marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Qinee qeeqaraa marida ummooquki marunnanara Yaawee anee qinnee unnannai quandafi qiniara qimudaoo qia. ");
INSERT INTO bjr_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Qini qimuqusakina oosana oosana ummaarauqa maraqu qisasee qini oosana oosana ummaarakinaana mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Oo Yaawee, qini aiqama aaqarana akiiqara minni qiseenana aupurarana faqa fitinnarana faqa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Oo Yaawee anee qafaa qini namuqaa moomoo uqanna maridaqa. Misa firaaqoo uqanna qiniara fidiaqaa idaqa. ");
INSERT INTO bjr_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Qini titaqisaidana qini marirana mara afeedamma qisaa. Anee itita qimaqaanneera qinee anee iannannai anidaqa. Namuqaa qini rafaaqafu qimaqee marianasaa itita qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Qinee ani mandaaqee marunnanara qini andeeqarafa faqa anoona qiramau firafa faqa qini rakisiqimaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Oo Anutu, Isaraee maqannaa aneenna faiqí anaasee nariqa oosana oosana ummaara kinaana mara kaqinni quqannisaa. ");
INSERT INTO bjr_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Oo Yaawee qinee andeeqara oosana maree marunnanara faqa firaaqoo ani saqariki marunnanara faqa iriseenana qiniara aaqarana siai fee qinaqa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Oo Yaawee, anee qini diuqummasee qimanammasee qafaa. Qini didirana faqa qini irirana faqa rainasee iria. ");
INSERT INTO bjr_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Ani aiqama kari mari amuqusirafa qini indaarunnikamma qimaqaidanoo. Aniki mapukusee marira oosana fannoo qini dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Qinee sia fifau aatata nimariasa saimbaqa nidaqa. Qinee sia qaaraiki mariasa faqa moodaanaki kianaura. ");
INSERT INTO bjr_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Qinee aaqee mariasa faqa moodaanaki nirara fidiaqaammidanoo. Manda oosana auqee mariasa finnaaqa raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Qinee qeeqa qisauku nammari uqusee qeeqara aaqarana siaisee qidaqa. Miqimmasee qinee ani aidara fiqu fiqu idaqa ani amooqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Qinee aniara dufi dufi qira idi raidaqa anee firaa ainaina auqoonnanara qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Oo Yaawee qinee anee marianna maaqanara firaaqoo dididanoo. Ani qareenarafa mariqoora firaaqoo dididanoo. ");
INSERT INTO bjr_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Sia aaqee mariasa namufaqa qini kuridi qimaqaa. Faiqí nári mariasa darirana kinaana qini mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Miqi mariasa aiqama kari manda oosana faqa umeeramaisaanifee munnimma maqee maqee maree mariasa faqa nariranakinaana qini mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Qinee qeeqaraa andeeqara oosana auqaidaqa. Anee qiniara qimudaoo qimasee qini asumu mara quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Qinee aiqama manda ainainakiqari kaqinni maridaqa. Qinee Yaaweena faiqí anaasee suqiranaki mina amooqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Yaaweefa qini qoomara foora maridanoo qini asumu maree marifa marinara qinee yanaree moonara rufiaanauree. Qini marirana nirana afeeka Yaaweefa kai marinara qinee yanaree maparaa ianauree. ");
INSERT INTO bjr_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Manda oosana maree mariasa aanaamuru qini namuqaauqa qini makuruanee qimasee anireeqa niku amaki saamurifara. ");
INSERT INTO bjr_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Qini namuqaa moomoo aniree qini maqusa uqusaifaqa sia qinee misara rufiaanaura. Rakiranaki misa aniree darirarifaqa sia qinee maparaa ianaura qifaaqa quqasee marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Qinee moodaa ainaina kai Yaaweenasaa qaraana marararee qidaqa, qinee minara kai randaanaura. Qinee maa maqanasaa marunna kamuqoo Yaaweena uiqaana maqaki marianauree qidaqa. Minaki maridaqa Yaaweena qareenarana qafamasee asasianauree qidaqa. Mina uiqaana maqaki mina iriranara mariranara randaanauree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Manda aukuana kambiqainanoo narí mari maqanaki kukeeqa qimaqaannoo. Narí uiqaana maqaki qini kukeeqaqisaanoo. Mifa qini uqeereeqee aaqanasaa oonisaa amiqiraqoo quqaqisaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Doo miqoo qini namuqaa qini uqusaafanoo Yaaweefa qini mareeqee misa urinnaaqarama saifaqa marianaura. Miqimmasainaqa qinee narí Yaaweena naaquqara uiqaana maqaki faaqa quqasee asasammasee aandau tatufirana suqamianaura. Qinee idi namu faqa ufireena namu faqa Yaaweenara amooqira idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Oo Yaawee qinee qeeqa ufannai aniara nameera qimasee aaraanana iria. Anee qini qifauarana qimisee kafaa anoona ufa qimaqimia. ");
INSERT INTO bjr_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Anee qiniara aniree qini qimooqiannee qianaqa Yaawee, qinee eedoo qimasee anianaura. ");
INSERT INTO bjr_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Oo Yaawee aneenna oori afiri sia qini kukeeqa qimaqaa. Sia qiniara arana qaani. Sia aneenna ainainira faiqi qiniara anirandee fuannee qia. Anee qini dadaaqi marianafa mariananoo. Oo qini Manika Anutu anee qini asumu maree marianafa mariananoo, sia qini minniqisaa sia qini quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Qini qinaukoo qini minniqisaifanoo Yaaweefa qinisaa rakisiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Oo Yaawee anee qiniara auqaannee qimarianna ainainnara daamuaqia. Qini namuqaa moomoo marianara irisee andeeqara aatata amiqiraqoo qifiqee fua. ");
INSERT INTO bjr_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Sia anee qini mareeqee qini namuqaa marianaki quqaqisaa. Misa naaquqara ufannai faqa unna ufannai faqa qini daridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Qinee maa ainainnara amiqimmasee iridaqa, qinee kasooaqee kaqi mariasa faqa maridaqa Yaaweena amiqi amiqirana qafaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Yaaweena saqarikia. Sia ani amuqusa ummaara raani, afeekaikammasee mina saqarikia. ");
INSERT INTO bjr_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Oo Yaawee anee qini dadaaqida ititaqimaqee marianaqa minakiqari qinee ani aaraanana qini nammeera qirana iria. Anee sia qini anoona ufa qima qiminaqa qinee kuqira maqa maaqaki kuqufida fimariasa qambaana marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Qinee qeeqa qisauku ani naaquqara amaana maqa maritinai uqeerasee dadaaqianneera innaaru qianana iria. ");
INSERT INTO bjr_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Oo Yaawee anee sia manda oosana maree mariasa faqa aaqee mariasa faqa amiqira adiafaa ira ufa qimaria fanoo misa nimuqusaki manda irirafa umbiqarausa namufaqa qini rafaaqafu qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Oo Yaawee misa auqee mariana akiiqara aupurarana nimia. Nisaukunnai manda oosana auqee mariana amana kai aupurarana nimia. Misa aiqama manda oosana maree mariana amana kai aupurarana nimia. Misa aaqarana akiiqara amanaikamma nimia. ");
INSERT INTO bjr_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Miqi mariasa Yaaweefa auqoo ainainnara sia iridaqa. Mifa narí asaukunnai auqu quqoo ainainara sia misa iridaqa mina akiiqara Yaaweefa misa aupurarana nimiseenoo kuridi nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yaaweefa qinee dadaaqiani feera nammeera qunnana irinara mina amooqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yaaweefa qini itita qimaqaseenoo qini dadaaqi marifa maridanoo. Qinee mina saqarikidaqa. Mifa qini dadaaqirana faqa asasirana faqa qimisaifaqa asasidaqa. Minara qinee mina amooqidaqa asasira idi rama amaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yaaweefa narí faiqí anaasee itita nimaqaidanoo. Mifa narí utaaqamaqai karaambaiqana itita amaqaseenoo mina manda ainainakinaana mara kaqinni quqaisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Oo Yaawee aneenna faiqí anaasee manda ainainakinaana mara kaqinni quqasee anindikiqa mariasa amiqi amiqimma nimaqaa. Anee misasaa sipsipasaa rakisirafara foora maridana naaruara misasaa rakisia. ");
INSERT INTO bjr_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Innee innaarunai mariasa mina amooqiaqa. Mina afeekara faqa qareenaranara faqa amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Yaaweena qareenara auqu uqeeraaqa. Yaaweefa naaquqarafa koorooinaqa mina oorinni niqoori saunu arafi naaquqamafi mina amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yaaweefa ufa qifaqa ooruku nammariki aiqamaindari mina ufa iridaqa. Uriqarara qareenarana faqaa Anutufa innaarunaira foora darara qifanoo ooruku nammari aiqamai daraanifaqa iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yaaweefa aiqama afeeka faqa eeraarirana faqaana ufa qirana irisee aiqamausa rufiaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yaaweena ufa fannoo firaa saqari raudee marifa maridanoo. Yaaweena ufa fannoo Reebanoona maqa maaqaki mari saqarisa sidaa saqariuqa raudee marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Yaaweefa qifaqa Reebanoona aaqanauqa kasidaqa aandau aanaaqiara foora rafusaki rafusaki idaqa. Qeeramoonna aaqana faqa miqi kai idanoo burimakau aanaaqi timmusara foora rafusaki rafusaki idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yaaweena ufa fannoo aakuasaara foora pananana qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Yaaweena ufa fannoo aadana maqa maaqa kasidanoo. Mifa qifanoo Kadeesa aadana maqa maaqa faqa kasidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yaaweena ufa fannoo aakuasaara foora pananana qinoo saqari amanee rauqu aqidanoo. Yaaweena maaqaki mariasa firaaqoo faaqa rumasee Yaaweefa uriqarara qareenarana faqaafee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yaaweefa naaruara uriqarara karaambaiqa maridanoo aiqama nammariuqasaa rakisidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yaaweefa narí aiku asauku afeeka nimidanoo. Amiqi amiqimma nimaqasee asooaranaki quqannisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Oo Yaawee, ani auqu qinee uqeeraidaqa. Qini namuqaauqa qini darusee ataasa ataasa qidaqa nasuriraree qianakinaana kaqinni mara quqa qisaannanara ani auqu uqeeraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Oo Yaawee qini Anutufa qinee ani dadaaqiranara aaraunana anee qini dadaaqiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Oo Yaawee anee qini madikakinaana qumbaqi qisaananoo, qinee kuqira madikaki ooqu raunana anee qumbaqisee kaqi marirana qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Oo innee Yaaweenaki mapukusee mariasa, innee mina amooqira idi raaqa. Innee mifa auqoo ainainara oonu mafi irisee mina dufi dufi qima amaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Yaaweena aanooqirafa qusakamu marinoo taikaannoo. Mina amiqirafa maa maqanasaa kisaaqasaa mariannoo. Eendaki qusasaa qikiraqarafa mariannoo, iaqainanoo kananaana asasirafa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Qinee afeekaikammasee mapukiqa maridaqa qinee aaqamasee qeeqara maaqi qiqiafana. Qinee naaruara naaruara sia kasianauree qiqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Oo Yaawee anee qini amiqimma qimaqaseenana aaqana saaqaraa maaqara foora mariafanana qinisaa itita qimaqanau. Anee aneenna oori kaqinni quandoonaqa qinee maparaa iranaki mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Oo Yaawee qinee ani aareeqa anee dadaaqirana qimianneera aareeqa ");
INSERT INTO bjr_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Qini kuqirafa sia kaqikaaqoo faqa ani amooqirafa mariannoo. Qinee madikaki ooquraananoo qini mi kuqirafa sia amana moo ainaina auqaannoo. Kuqirauasa amanee ani amooqifaree. Sia amana. Amanee misa anee kisaaqasaa amiqimma nimaqee mariannanara kooroo ifaree. Sia amana. ");
INSERT INTO bjr_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Oo Yaawee, anee qini innaaru irisee qimudaoo qimasee qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Qinee soofaaraki marunnana anee quandasee idi rarana qimiananoo. Anee qini ikiraqarana mara aquseenana asasirana qini fiqu fiqumma datimmma qimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Miqimma qisaannanara qinee sia ufa siaina qireeda marianaura qinee ani amooqira idi raanaura. Oo Yaawee anee qini Anutufa qinee naaruara naaruara ani dufi dufi qima amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Oo Yaawee qinee itita qimaqaanneera anee iannannai anidaqa. Naaruara sia qini qisauriranaki quqaqisaa. Anee andeeqara Anutufa mariananoo qini kuqiranakinaana mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Qini ufa irisee maqee uqanna qini kuqiranakinaana mara kaqinni quqaqisaa. Anee qini faandaamura ooniara foora maridana qini itita qisaa. Anee qinisaa ququsara foora auqu ititaseenana qini kuqiranakinaana mara kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Oo Yaawee anee qini faandaamura ooniara foora faqa ququsara foora faqa mariananoo. Aneenna qima afeekaikunadee inana qini qisauku qumaree aana muquninaqa fua. ");
INSERT INTO bjr_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Anee qini dadaaqinaqa qini qimaara fufuqaa ufaannanaki sia arua. Manda ainainasaa auqaanara foora qinisaa mandaaqa qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ani asaukuki qeeqa qimana quqaidaqa. Oo Yaawee anee qini kuqiranakinaana mara kaqinni quqa qiseennaranoo. Anee mapukusee marirana faqaa Anutufa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Anee unnaqira anutusara innaaru qimariasara fidiaqaa imariananoo. Misa miqi mariafaqa qinee ani kai saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ani maasara kisaaqasaa amuqusiranara qinee asasidaqa nasurianaura. Anee qini aupurarana faqa ummaara faqa qafaannanara miqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Anee sia qini mareeqee namuqaa nisaukuki quqasaanaqa qini qumareea. Qinee qifaaqa quqasee qeeqa didimarinnai firana anee qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Oo Yaawee qinee qummaaraki maridaqa qiniara qimudaoo qia. Qinee kaaqa moomoo kari iki raqee saunanoo qifukaumu innooqafinoo. Qini qimudaani firaaqoo ummooqukidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Qini ummaara fannoo qini afeeka taikaidanoo. Qini iki raqarafa qini marirana qusa raidanoo. Qini ummaara fannoo qini afeeka taikasaifanoo qini qimudaani ummooqukidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Qini namuqaa faqa qini qiqoonausa faqa qiniara uteeti amara auqidaqa. Minara kai qiniara irimariasa naaquqaifaqa qini daaqu rufiqaidaqa. Aanai qini paquri masee quqasee sandaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Qinee kuqiara foora iqa marunaqa qiniara qaunidaqa. Qinee rukamufifaqa aqusaa qafeesara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Qini namuqaauqa maqandanai narí qimami narí qimami masaidaqa uteeti qimariafaqa iridaqa. Rufiarafa firaafa qini fiqu fiqu inoo maridanoo. Misa moodaanaki suqufiqa qini marirana taika qimaqaaneera tipundaaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Miqi mariafaqa Oo Yaawee qini Anutu qinee ani kai saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Qinee aiqama kari ani rakisi qimaqaranaki maridaqa. Qini namuqaa qini darirara qifaqaqa nuanakinaana qini mareeqee amiqiraqoo quqa qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Qini aneenna ainainira faiqiara qimudaoo qidana qiqafaa. Aneenna sia takee mari amuqusiranaki qini mara quqa qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Oo Yaawee, qinee ani aaraunnanara anee qinaqa qini namuqaauqa sia qini qisauriranaki quqaqisaaqa. Manda oosana maree mariasa kai nisauriranaki mariaqa. Misa ufa taikafinaqa madikaki kuqirausa faqa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Unna ufa qimariasa noo qummuna mannisaa. Misa nári nifaaqa uqeerasee akaqausa mara maree qumimariasa misa andeeqarausara manda ufa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ani ameemaanai maridaqa ani ufa mau fimariasa afeedamma nimaqaqaanna ainainausa kaaqa amiqirafa maridanoo. Anee firaaqoo amiqimma nimaqee mariannanara aiqamausa iridaqa. Ani saqariki mariasa anee firaaqoo rakisi nimaqaidana itita nimaqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ani saqariki mariasa narirara tipundaari mariafana anee mareeqee aneenna afusaa amiqiranaki quqannisee marianafa mariananoo. Misa namuqaa nifairiranakinaana mareeqee amiqira auqaanai quqannisee marianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yaaweena amooqirana amiaqa. Qini namuqaa qini fiqu fiqumma datimmafi daruaneerufanoo qiniara firaaqoo aidufanoo itita qimaqoonara amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Qinee rufiaidaqa maaqi qimasee iriqa, doo Yaaweefa qini narí afusaa marunnana mareeqeenoo kaqinni quqaqee maqi qimasee irunanoo, Yaaweefa qini innaaru qirana irisee dadaaqinoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Innee Yaaweena faiqí anaasee innee Yaaweenara firaaqoo nidiani. Yaaweefa narí ufaki mapukusee mariasa itita nimaqaseenoo, nári nuqu uqeeree mariasa nári manda oosana akiiqara nimimarifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Innee Yaaweenaki mapukusee mariasa inni nimuqusa fannoo aiqama kari afeekaikinoo mariani. ");
INSERT INTO bjr_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Inni numoo minninisaisa faqa inni numoo rafaaqafu nimaqasaisa faqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Yaaweena nifairiranaki sia mari fasiqafa asasiranaki maridanoo. Sia unna qimasee nikaru qimari fasiqafa faqa asasiranaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Qinee qeeqa numoo sia koorooiqa iki raqaida marunanoo suani afu keeqaidanoo. Miqunanoo qini qimudaani ummooqukidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Eendaki faqa faasaana faqa Yaawee aneenna asaukunnai fannoo qini aupurarana qimimariananoo qini afeeka taikeenoo. Aiqaiqa aukuana suani firaafa qeenoo maqa aadana ususaifanoo taadairindee idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Qinee miqiqa maridaqa qeeqa aaqarana ani Yaaweena afusaa akooqoo koorooiqa. Qeeqa manda oosana sia kukeeqeeqa kooroommasee ani qimamiqa. Qinee maaqi qiqa, qeeqa aaqarana Yaaweena afusaa kooroo qianauree qimasee kooroomma saunana anee Yaaweefa qini mandoosana faqa qini aaqarana akiiqara faqa minniqisaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Miqiannanara aiqama ani ufamau fimariasa aiqama ainainara randeeqa aniara innaaru qidaqa. Firaa ummaara nammari aufiara foora inoo sia misa rafaaqa fuannoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Anee qini kukeeqara maqusa mariananoo. Anee ummaara aukuana qinisaa rakisinnaranoo. Anee qini maree marianafa mariannanara firaaqoo idi raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Yaaweefa maaqi qidanoo. Qinee anee finna aannanara qima amianaura. Qinee ani aakapamasee aamuaqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Anee sia qoosa doonkiara foora furufaria. Misa irirana siai ainainara foora maridaqa. Anee qainna misa nooki quqasee rarisee mariandee inaqa irifaranoo. Anee nookinaa qainna sia quqainaqa sia ani ufamau fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Manda oosana maree mariasa moomoo ummaara oosana oosana misaki maridanoo. Yaaweena saqariki mariasa mina naaru marira amuqusirafa misa kukuqinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Innee andeeqarausa Yaaweefa auqoo ainainausara asasida nasuriaqa. Innee mina ufa qaindusi mariasa faaqa ridaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Innee andeeqarausa Yaaweefa auqoo ainainnara faaqa ridaqa asasiaqa. Mina ufa mau fimariasa mina amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Innee piripuna aridaqa Yaaweena amooqiaqa. Qisaukuqara taikasee sandafaqaa piripuna aridaqa Yaaweena amooqira idi raaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Innee Yaaweenara fuka idi raidaqa amooqiaqa. Innee amiqimmasee akoofasara foora piripuna aridaqa faaqa fuisee qidaqa amooqira idi raaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yaaweena ufa fannoo kuqaa anoona kai maridanoo. Aiqama ainaina auqee marina mi mau kai uqee marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yaaweefa andeeqara marirana faqa andeeqasee amana amana kai rainee marianara faqa aididanoo. Maa maqa maaqanaki Yaaweena sia taikara amuqusirafa qumbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yaaweefa ufannai qufanoo innaaruna kambiqanau. Narí ookinaa aidoonnai qufanoo suani faqa quqoona faqa fasau faqa kambiqanau. ");
INSERT INTO bjr_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Yaaweefa ooruku nammari susufinnaki saka quqaandee inoo moodaannai suqu quqanau. Ooruku nammari faruma meemai uqanna quqasee afeedinau. ");
INSERT INTO bjr_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Minara maa maqa maaqanasaaqaraasa aiqama Yaaweenara innaaru qiaqa. Maa maqa maaqanasaa mariasa minara naaquqee marina mina ameemaanai mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Yaaweefa qufanoo maa maqa maaqafa kambiqanau. Mifa afeeka ufa qufanoo aiqama ainaina kambiqanau. ");
INSERT INTO bjr_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yaaweefa maa maqana saaqaraasa manda ufa tipundaariafanoo titannimaqaidanoo. Maa maqana saa mariasa auqararee qia ainainna itita nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Yaaweena qimirirafa miqinoo maridanoo naaruara naaruara afeekaikamminoo maridanoo. Mina amuqusakinaa qimirirafa naaruara naaruara mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Aiqama maqannaasa kiqari ya maqannaasee misa Anutufa Yaaweefa maridanoo fee asasiaqa. Yaaweefa nariaree qimasee utaaqama qaisa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yaaweefa innaarunaindari maqasaa mariasa aiqama niuqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Narí maridanoo rakisi nimaqee mariqooqari aiqama maqasaa mariasa niqafaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Yaaweefa aiqama maqannaasa nimuqusa auqunisaidanoo. Misa auqee maria aiqama ainainnara iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Sia moo karaambiqa fannoo narí rakira fasiqa moomoonnaifau rakiranaki uriqaraidanoofau. Afeeka sundia sia narí amudaanai qiranannai fau rakiranaki namuqaa urinnaaqaraidanoo fau. ");
INSERT INTO bjr_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Rakiranaki maraqa nua qoosausa sia sundiauqa dadaaqifaqa rakirana urinnaaqareefaranoo. Mi qoosausa firaa nimudanai qiranannai sia amana moona kuqirana titaqamaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Yaaweena afu fannoo nariara rufiee mariasa dadaaqirara misasaa maridanoo. Yaaweena naaru marira amuqusiranasaa mundimariasa misasaa Yaaweena afu fannoo rusinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Mifa kuqiranasaa itita nimaqaidanoo. Mifa aandaroo aukuana faqa rakisi nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Maasa qimana Yaaweenaki kai quqaidanoo. Mifa kai maasa dadaaqirafa maasa saqari maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Maasa mina naaquqara andeeqara auqu saqarikunnanara firaaqoo asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Oo Yaawee ani naaru marira amuqusirafa maasa faqa mariani. Maasa anisaa mundiqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Qinee aiqama kari Yaaweenara dufi dufi qianaura. Qinee sia mina amooqirana munu quqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Qinee mifa auqoo ainaina irisee mina amooqianaura. Ummaaraki mariasa minara irisee asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Innee aniraifaqa maasa Yaaweena auqu qareenaranara koorooia. Doo aniraifaqa innisaimbaqa mina auqu uqeeraa. ");
INSERT INTO bjr_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Qinee Yaaweenara innaaru qunanoo mifa qini dadaaqinoo. Qini rufiaranakinaana iduku qiseenoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Ummaaraki mariasa Yaawee finnai ubeekamafuanara misa asasidaqa. Minara misa saqarikirafa sia kuridiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Kudi fasiqauqa Yaaweenara innaaru qiafanoo dadaaqidanoo. Mifa misa aiqama ummaarakinaana mareeqee kaqinni quqannisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yaaweenara rufiee mariasa mina angiroouqa misa fiqufiquiqa maridaqa mandainainakinaana maraqunnisaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Aneenna kai Yaaweena firaa amiqiranara oonu mafi iria. Yaaweena itita nimaqaranaki kukeeaqa mariasa asasiranaki maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Innee Yaaweena faiqí anaasee innee Yaaweena ameemaanai mariaqa. Mina ameemaanai mariasa sia sarauirafa misaki mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Kaasau faini narana sia amanaikianara naara raifaqa kudoosaapaidaqa. Yaaweena ufa mau fimariasa sia moo amiqira ainainara sarauifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Innee qini faiqinamu mai aniree qini ufa irifaqa qinee Yaaweenara rufiara oosanara qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Yafee moo fasiqa fannoo kaqi mariranara ridanoo fee. Anee kisaaqasaa maridana asasiranara aididanoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Aidinana anee sia manda ufa qia. Anee sia unna ufa qia. ");
INSERT INTO bjr_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Manda oosana ameesuqusee amiqira oosana maraa. Aneenna aiqama amuqusannoo asooaranara randasee faiqí anaasee faqa moodaanaki maria. ");
INSERT INTO bjr_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yaaweena afu fannoo andeeqarausasaa mundinoo marifanoo rakisi nimaqaidanoo. Mina aaqoo fannoo misa nammeeraqiana iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Yaaweefa manda oosana maree mariasara akooqaidanoo. Misa kuquafaqa miqoo kai misara qaunidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Andeeqara oosana maree mariasa Yaaweena aaraafanoo iridanoo. Mifa misa oosana oosana ummaarakinaana dadaaqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yaaweefa ummaaraki mariasa dadaaqirara naaqa maridanoo. Mifa kudoosaapee mariasa dadaaqinoo mara amiqiraqoo quqannisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Andeeqara fasiqa anaasee ummaara oosana oosana fannoo aupurarana nimifanoo, Yaaweefa minakinaana aiqama mareeqee amiqiraqoo quqannisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Yaaweefa misa aiqama nimudaanisaa rakisidanoo, sia moodaa nimudaani faqa raqanoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Manda oosana fannoo manda oosana maree mariasa kuqa naruannoo. Andeeqara oosana maree mariasara fidiaqaa imariasa Yaaweena narira ufa ameemaanai marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yaaweefa narí ainaini maria fasiqausa feefaurummasee kafaa maraidanoo. Mifa innai itita qimaqaanifee qimasee fimariasa sia kuridifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Oo Yaawee qini rairai qimaqimaqee mariasa anee misa faqa rairai qimannimaqaa. Qini darimariasa nariqa faqa narua. ");
INSERT INTO bjr_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Aneenna rakira saqari faqa rakira ainainauqa namufaqa maree aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Aneenna duru feefa faqa saasuna faqa mara maree aniree qini darirara qifaqaqanuasa narua. Anee qini dadaaqiraree qimasee qima qimia. ");
INSERT INTO bjr_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Qini darirari mariasa anee rafaaqafu nisainaqa nisauriranaki mariaqa. Qini mandaikamma qimaqarara tipundaari mariasa mara quanda sainaqa furufariranaki mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Yaaweena angiroo fannoo misa nifaqaseenoo oofaafanaumuara foora utitiqameeqee aqusaina ufai fannoo aanaaqmaara fuaqa aqindee iannoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Misa nimaria aanafa asukuna faqa farindarafa faqa mariani, Yaaweena angiroo fannoo misa nifaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Qini namuqaauqa oosana siainaki qini qimaara qufaana fufuseeqa qini qimaarusidaqa. Misa fifau qini qimaara madika indufia. ");
INSERT INTO bjr_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Oo Yaawee anee dadaaqinaqa qini namuqaauqa sia iri marifanoo ummaara fannoo tautummaki misasaa aqufuani. Misa nariqa fufuqaa ufaanaki arufi nariqa ummaaraki aqufifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Miqimma fifaqa qinee Yaaweenara asasianauranoo. Mifa qini asumu marainara nasurianauranoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Qinee qeeqa qimuqusa aiqamannoo Yaaweenara maaqi qianaura. Sia moo fannoo ani fooqaafaa maridanoo. Aniara afeeka siaisa afeekaikimariasa nisaukukinaana rafiaana fee qianaura. Kudi fasiqauqa mandaikamma nimaqee mariasa nisaukukinaana faqa maree marifee qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Manda fasiqauqa qinee sia qafaunna ainainara faqa sia irunna ainainnara faqa fifau qini rairai qima qimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Qinee amiqi amiqimmannisaunnana akiiqara mandaikamma qimaqeea. Miqiafanoo qini qimuqusa firaaqoo ummaarareenoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Qini oosana moomau fidanoo. Qini namuqaauqa auriranaki mariafaqa qinee misara soofaarira qamunna afisusee qeeqa mara maree qumureeqa daararee marufaqa misara findifuaqeera innaaru qimariqiafana. Qinee inuka tuqu daumoo amisee findifuaqeera innaaru qimariqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Qini namuqaauqa auriranaki marufaqa qini marirafa maaqimminoo marinau. Qinee misara qini qiqoondifaqa qini qikaqaafasaa faqa qini qinoofa faqa kuqiara foora iafaqa soofaarida kummaaraqa mariqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Qini namuqaauqa oosana misa sia qini daanna raidaqa. Qinee ummaaraki aqufunaqa misa qiqafamaseeqa asasammasee aiqama qini fiqu fiqummafi uteeti qidaqa. Qinee aanaamuru misara sia irimarunausa qini dariqa kai maridaqa, sia idooaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Qinee qiku qisauku mandaikirausara foora marunaqa misa qiniara uteeti qidaqa. Misa qiniara fidiaqaa imarifaqa qini qiqafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Oo Yaawee, kisaaqasaa fee anee kaqi nindafaida marinnaree. Misa qini kuridi qimaqarara imarianasaa itita qimaqaa. Anee maa kaasau fainisa nookinaana qini mareeqee amiqiraqoo kaqinni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Miqimma sainaqa ani faiqí anaasee moomoosa suqirana qambaanaindari findifi ani Yaaweenara dufi dufi qianaura. Moomoo fasiqa anaasee firaa suqiranaki noorinni oonuree ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Fifau unna qimariasa qini namuqaa qini tataqaida asasifana Yaawee anee titaqisaa. Qini qumaara qafamasee fidiaqaaidaqa noorinnai nifunnai unnamaanna qimariasa anee misa faqa rafaaqafunnimaqasaa. ");
INSERT INTO bjr_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Misa nifauru fannoo sia asooara ufa aqoondikira ufa qimarisa, misa oosana oosana unna ufauqa faqa ida qai ufana faqa kai qimariasa maridaqa, misa unnamaanna qiranara randasee mareeqee asooaranaki mariasa nimuaaqa aqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Qini namuqaauqa fifau firaaqoo noo raqasee qini kikiqususeeqa qiniara eeoo eeoo maasa qifu fannoo mina aaqarana qafee fee qidaqa unnaqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Misa miqi qimariafana, oo Yaawee, anee misa unnaqirana qafaananoo. Anee sia ufa siaina maria, anee sia nianai maria, daaqa ani marida dadaqia. ");
INSERT INTO bjr_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Oo Yaawee, anee faiqara see findifi qini itita qisaa. Oo qini Anutu findifinana qini ufa afeekaikamma qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Oo Yaawee, qini Anutu, anee andeeqarafa, anee qiniara sia aaqarana siai fee qia. Anee qini dadaaqinaqa qini namuqaa qiniara ataasa ataasa qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Anee qinaqa qini namuqaauqa sia nári nimuqusakiqari maaqi qimasee qiniara qiaqa. Eeoo maasa qunnandee kai qinoo mina mandainaina doo kambiqeenoo fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Qini ummaara qafamasee nasuri mariasa anee misa aupuraranaki quqannisaa. Anee misa nisauriranaki quqasee furufaramma nimaqaa. Anee misa nisauriranannoo faqa noori runiranannoo faqa qamunnara foora dukunimma nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Qini andeeqaranara irisee qini iduku qimaqarara irimariasa kaifaa kaifaa maaqi qimasee faaqaridaqa asasiaqa. Yaaweefa kaaqa uriqararafa maridanoo. Yaaweefa qini narí ainainira faiqi qinee auqaunna ainainafa anoona kambiqainara iriseenoo asasidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Miqinaqa qinee ani andeeqaranara kananaana oosana arasee ani amooqianafa eedirana kai raquru amianaura. ");
INSERT INTO bjr_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Numoo fannoo manda oosana maree mariasa nimuqusaki maridanoo akaqa aaqara oosanara naakapaidanoo. Anutuna minnisee sia minara rufiee marianara manda oosanara irirafa nimuqasaki kambiqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Miqi mariasa nári kai náriara kaaqa uriqararausee qidaqa, Anutufa maasa aaqarana sia amana qafamasee maasa ufa qimiannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Misa nookinaa ufa fannoo manda ufa faqa unnufa faqa kai maridanoo. Misa sia iriqaraasammasee auqara oosanara faqa andeeqara oosana faqa auqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Misa nári qaarisaa faiaqee idaqa manda oosanara oonumafi irida maridaqa. Misa sia moo andeeqara oosana auqaidaqa, misa manda oosanara faqa sia qaoo qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Oo Yaawee, ani sia takaaninna amuqusirafa innaaruna amana kai ooru maridanoo. Ani mapukusee marira oosana fannoo oonnamu amana kai ooru maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Ani Yaaweena andeeqarafa firaa aaqananamuara foora uriqaranoo maridanoo. Anee maasa ufa irisee andeeqasee raina qimaqara oosana fannoo ooruku nammari farumara foora meemai uqanna maridanoo. Faiqí faqa aandau faqa ani rakisinnimaqarana ameemaanai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Oo Yaawee ani maasara amuqusirafa firaa feefauru aqimaria ainainnafara foora maridanoo. Maasa ani aqoosa ameemaanai keeqafi mandaaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Oo Yaawee anee rairaamma nimianna naranna oomaqa sakasee naidaqa. Anee qinaqa maasa ani andeeqara oosana nammariara foora naa. ");
INSERT INTO bjr_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Anee aiqama marirana oosana mariananoo. Anee kaaqa qarafa mariannanara maasa kaaqa qarana qafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Oo Yaawee anee aneenna amuqusirana aniara irimariasa kaifaa kaifaa nimida kai maria. Anee aneenna andeeqarana andeeqara aatata fimariasa nimidana kai maria. ");
INSERT INTO bjr_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Anee qinaqa nári nimoo naamoo imariasa sia nikunnai qini rafaaqafu qimaqaaqa. Anee qinaqa manda oosana maree mariasa sia qini daru qifaqaaqa iaqa. ");
INSERT INTO bjr_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Niqafaa, manda oosana maree mariasa doo saamuriqa maridaqa. Misa maqasaa aqufiqa sia amana kafaa findififaaranoo. Miqoo kai marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Anee aaqara oosana maree mariasa nindafamasee sia minara aiaaqee qimasee sia qinee misa dadaaqunoo sia qia. Manda oosana maree mariasa nindafamasee sia minara qinee faqa sia maraunoo qimasee arana qaani. ");
INSERT INTO bjr_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Misa miqi marianara amukafaqaa sanda miqirausa qusasaa ateeka saifaqa qammundeefaranoo, misa andanda miqirausa maridaqa qusasaa aadanusifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Yaaweena saqarikida andeeqara oosana kai maraida maria. Anee miqidana maa maqa maaqanaki kisaaqasaa kaqi marinanoo sia moo ainaina fannoo ani mandaikamma amaqaannoo. Anee aneenna maqa maaqaki kai marida asooaranaki maria. ");
INSERT INTO bjr_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Yaaweenaki asasamasee marinanoo ani amuqusaki aidimari ainainna ani amiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Anee aneenna marirana nirana Yaaweena amisee mina saqarikammasainanoo mifa maa ainainna ani amiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Mifa ani andeeqara oosana dadaaqinanoo suani qambaanara foora amiqimmasee kaaqa qaanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Anee Yaaweena oorinni afaaqa quqasee ireeda maria. Manda oosana maree mariasa aaqara oosanara tipundaarifanoo anoona kambiqainana sia qeeqara faqa miqianee qia. Sia moomoo qumiasana faqaasa niqafamasee sia qinee faqa miqiunoo qia. ");
INSERT INTO bjr_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Anee mina qafamasee sia moomoo irira iria. Sia aanoo qia. Mi oosanafa ummaaraki nifiqee fidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Manda oosana faqaasa Yaaweefa misa aiqama taikannimaqaannoo. Irirana Yaaweenasaa mundimariasa maa maqanasaa amiqimmasee marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Kaqikaaqoo marikinanoo doo miqoo mandoosana maree mariasa taikeefaranoo. Anee misara randeenana sia paqurinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Nári mara maree qumi mariasa Yaaweefa aiqama maqa nimiannoo. Misa miqoo aiqama ainaina rairaa imarinaqa asooaranaki maridaqa asasifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Manda oosana maraqanuasa andeeqarausa nariraree qimasee tipundaaridaqa. Miqidaqa misa andeeqarausara fidiaqaaira noori nifiri maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Yaaweefa qusasaa misa mandaikamma nimaqaaninnanara iriseenoo naanaidara qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Manda oosana maree mariasa kudi fasiqa anaasee faqa sarauiranaki mariasa faqa andeeqara aatata fimariasa faqa nariraree qimasee nári faaqaana mai qumaree duru rakisisee nimaarusida maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Misa nariqa rakira faaqaana fannoo nári nimuqusa raquru nimiannoo. Misa duru faqa raudaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Andeeqee mari fasiqana ainaina oodaa mariannoo, Anutuna afusaa uriqaranoo maridanoo. Manda oosana maree mari fasiqana ainaina moomoo maridanoo, Anutuna afusaa ureeqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Minara manda oosana maree mariasa Anutufa misa afeeka mara maraannoo. Andeeqee mariasa Yaaweefa itita nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yaaweena ufa mau fimariasa Yaaweefa misa marirana niranasaa rakisidanoo. Maa maqa maaqafa misaindikinoo naaruara mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Miqi mariasa manda aukuana anirainaqa sia aupurarana mareefaranoo. Aandaroo aukuana misa narana moomoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Mandoosana maree mariasa kuqifaranoo. Yaaweena namuqaauqa taatuqeena kakasindee ifaranoo. Misa ida muna qusasaa marinoo taikaindee ifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Manda oosana maree mariasa moosa ainaina ufaasu maraseeqa sia kafaa nimidaqa. Andeeqarausa oosana moo maridanoo, misa afaarida kaqi nimimariasa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Yaaweefa amiqi amiqimmanimaqee marisa misa nári maqa maaqaki amiqimmasee marifaranoo. Yaaweefa niquraree marisa mina maqasaa mariana mara qaqusainaqa quqasee fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Andeeqara fasiqa niranara Yaaweefa asasidanoo dadaaqidanoo. Yaaweefa asasi maria fasiqa anaaseesa itita nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Mi andeeqara fasiqafa saamurinoo maqasaa aqufinoo sia miqinoo mariannoo findifuannoo. Yaaweefa uqeerainara miqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Qinee kumaaraa mariiafanausa doo maqee asooqa maridaqa, Yaaweefa andeeqarausa minninnisoona sia qinee mi kamu qafaqiafana. Mina faiqi namu naranara sarauida innaaru qirana faqa sia qafaqiafana. ");
INSERT INTO bjr_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Andeeqarausa aiqama kari afaari mariasa maridaqa. Sarau imariasa iraafaqa eedooo qimasee kaqi ufaasu nimidaqa, misa faiqi namu faqa amiqi amiqiranaki marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Anee manda oosanakiqari quandakinana andeeqara oosana maraa. Miqinaqa ani faiqi namu ani maqasaa naaruara marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Yaaweefa andeeqara oosana maree mariasara aididanoo narí ufamau mapukusee fimariasa faqa sia minninnisaannoo, misasaa naaruara titannimaqaannoo. Manda oosana maree mariasa faiqi namu mara aqusaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Andeeqarausa nári nikausa ninaakusa maqa maaqa umiasanara foora maraseeqa, minaki naaruara marifara. ");
INSERT INTO bjr_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Andeeqarausa nifauru fannoo irirana faqaasa ufa kai qidanoo. Mina afauru fannoo qambaana andeeqara ufa kai qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Anutuna sanda ufa andeeqarausa nimuqusaki maridanoo. Minara misa sia quqasee moosaa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Manda oosana maree mariasa andeeqarausa nipuraida narirara nimaarusidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Yaaweefa sia andeeqarausa manda oosana maree mariasa nisaukuki quqasaifaqa naridaqa. Manda oosana maree maria fasiqausa andeeqarausa ufaki quqasaifanoo Yaaweefa misa titannimaqainaqa sia narifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Anee aneenna irirana Yaaweenaki quqasee mina ufa mau kai andeeqasee fua. Anee miqimarinanoo Yaaweefa ani firaa auqu amiseenoo ani aanaakusa akausa maqa maaqa amiannoo. Mifa minaki manda oosana maree mariasa mara aqusaina qafamasee kuqaa fee qinnaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Qinee Dafidisa, mandoosana maree mari fasiqana qafaafananoo firaa saqari miqirafa Reebanoona amiqira maqasaa kambiqafi ititanoo mariara foora inoo marinau. ");
INSERT INTO bjr_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","Mifa qusasaa marinoo doo taikafifaqa qinee qafaunanoo sia marifaqa randeeqa sia uqanna paquriqa. ");
INSERT INTO bjr_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Anee ufa siai fasiqana faqa andeeqara aatata fimari fasiqana faqa niuqummasee qafaa. Asooara oosanaki reendeennammasee mariasa maa maqanasaa misa saaqari kambiqainausa faqa kisaaqasaa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Aaqee mariasa Yaaweefa aiqama uqanna kuridi nimaqaannoo. Manda oosana maree mariasa niku nisauku marirana Anutufa ateekasaina sia marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Ummaara aukuana Yaaweefa andeeqarausa itita nimaqasee asumu maraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yaaweefa andeeqarausa dadaaqinoo manda mariranakinaana uqeerannisaidannoo. Aaqee mariasa nisaukukinaana asumu mareeqee kaqinni quqannisaidannoo. Misa Yaaweena mandaaqee marianara asumu maraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Oo Yaawee, aneenna aanooqiranakiqari sia qiniara aanooqia. Aneenna aranaqaranakiqari sia qini ummaara qimia. ");
INSERT INTO bjr_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Anee feefara foora amiqimmasee qini tapooqaananoo. Ani asauku fannoo firaaqoo qini radamimarifaqa ummaara maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Anee qiniara aanooqiannanara qini qifaaqa firaaqoo didafidanoo. Qini numoo marinara qini qimudaani umooqukinoo marifaqa sia afeekaikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Qini aaqara ummaara fannoo qini rafaaqafu qisaidanoo. Mifa firaa ummaara maridanoo, sia qinee amana akuanaura. ");
INSERT INTO bjr_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Qini furufarirafa marinara qifaaqa ateekeeqaafanoo adiara usufifanoo afundida putaaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Qinee ummaaraki maridaqa maqasaa aqufiqa maridaqa, aiqama faasaana suani afu ururarana namu faqa soofaarida kummaraqa maridaqa iki raqaida marunanoo suani afu keeqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Qini qifaaqa idara foora qaidanoo. Qinee kuqirana adeedi raqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Qini qimudaani raqanoo mariara foora qumooqukiqa nidaqa. Qini qimuqusa firaaqoo didafi marinara annadannada qida maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Oo Yaawee qini didimari ainainausa ani afusaa akooqoo marifana iri mariananoo. Qini didafi marifaqa annadannadirafa ani afusaa sia kukeeqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Qini qimuqusa rundurundi marifanoo qini afeeka taikeenoo. Qini afeeka doo quminoo, qini qifusaa mari kaaqa qarafa doo taikafifanoo asukuna kai titeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Qini qiqoondiuqa faqa qini faqa nimariasa faqa qini nammuana qafeeqa rufiasee niana tatutatuidaqa. Qini qiqoonausa faqa miqikaimmidaqa rufiqa rufiqa idaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Qini darirara randee mariasa qufaana fufidaqa. Qini mandaikamma qimaqarara ufa qimariasa maridaqa. Suani afu ururarana namufaqa tipundaarida mariafanoo suani afu keeqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Qinee daaqoo qaunirausara foora sia misa ufa iriqa doo qummunirausara foora sia qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Qinee sia ufa irimaria fasiqausara foora maridaqa, qeeqa dookiqari qimannimirara sia amanaikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Oo Yaawee qinee ani kai saqarikidaqa. Oo Yaawee qini Anutufa anee qini ufa qima qiminnaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Oo Yaawee qini namuqaa sia qini mandaikamma qimaqasee nasuriaqa. Qini qiku farindamaki aqufuanaqa sia nasurida asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Qinee saamuruaqaammidaqa. Qini didafirafa kisaaqasaa qini faqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Qinee qeeqa aaqarana akooqoo kooroomasaunanoo, qini numoo fannoo qini qummaara qimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Qini namuqaauqa moomoosa nimudaanai qimariasa maridaqa. Qiniara fifau fidiaqaa imariasa moomoosa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Qini amiqira oosana akiiqara mandaikammaqimaqee mariasa misa qinee andeeqaramau fimarunaqa misa qini namuqaakamma qimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Oo Yaawee qini Anutu, sia qini minniqisaa, sia nianai maria, daaqa ania. ");
INSERT INTO bjr_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Oo Yaawee qini asumu maree marianafa kai kaqi aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Qinee Dafidisa qeeqara maaqi qiqa, qinee qeeqa nirana mariranasaa rakisianaura. Qini qifauru fannoo sia aaqara ufa qiannoo. Manda oosana maree mariasa qini daaqa marifaqa sia qinee moo manda ufa qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Qeeqa ufa rafaaqa fusee doo qummunimmasee marunanoo mifa sia dadaaqinoo. Doo qummunimmasee sia amiqira ufa faqa qimarunanoo qini daundurakinaa ummaara firaanaikinoo. ");
INSERT INTO bjr_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Doo qummunimmasee marunanoo qini daundurai qimuqusaki idara foora aurinoo. Qinee firaaqoo oonumafi irimarunanoo qini daundurai firaaqoo idaqeenoo. Idaqee marifaqa qinee sia doo qummunimmasee marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Oo Yaawee qinee taikaanna aukuannara qinaqa iria. Yairee fee qinee kuquanauree. Qini marirafa munu taikaaninnanara faqa qima qimia. ");
INSERT INTO bjr_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Anee qini marirana qusa uqanna ramasaananoo. Qini marirafa ani afusaa fifau ainainara foora sia maridanoora foora maridanoo. Aiqama fasiqa fifau naidoora foora kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Aiqama fasiqauqa nimanandara foora marida nidaqa. Miqi mariasa aiqama ainaina fifau kai kadaapi ridaqa. Maaqoo maridaqa qumiasana suqu quqaseeqa kuqifanoo yafee maraannoo fee qimasaida sia iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Oo Yaawee qinee nana moo ainainara afeesianauree. Qini irirafa aniki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Qini aiqama numoo kinaana mareeqee kaqinni quqa qisaa. Miqimma sainaqa furufarirausa sia qiniara naanaidara qiaqeera. ");
INSERT INTO bjr_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Anee kai maa aupurarana qimi marianafa mariannanara qinee doo qummunimmasee qireeda kai maridaqa sia ufa qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Sia kaifaa qini mandaikamma qimaqaa. Anee qini daruanaqa kuqirara miqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Faiqí aaqara oosana maraasara anee Anutufa afeekaikaqmmasee aanoo qima amaqasee mina idi mari ainainna kuridi aisee mariananoo. Qumura mandaikindee idanoo. Aiqama fasiqauqa ani afusaa aidoora foora qusasaa fuaqaki taikaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Oo Yaawee qini innaaru qirana iria. Qini dadaaqianneera aaraunnana aaqoo rammatinimmasee irisee qini dadaaqia. Qinee ani dadaaqiranara qiki raqaidaqa nammeera qianana dadaaqia. Qinee qusasaa maa maqanasaa ani faqa mariqa, qeeqa qikeeku qikaaku naanna reeqa qusasaa kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Oo Yaawee ani oori afiriara kaaqa daaquqaidanoo anee kaqinni anneenna oori ubeekamasainaqa qinee qusasaa asasiranaki mariqa kuqua. ");
INSERT INTO bjr_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Qinee Yaaweenara deendeena mandee afeesida marunanoo, mifa quandafi qini nammeera qirana amiqimmasee irisee qimudaoo qimasee dadaaqinoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Qinee qeeqa aaqaranaki doona doona imarina kiara foora faqa faurima saara foora faqa farindamaki kuqira madikaki faqa afundimari doonna kiara foora faqa marunanoo minakinaana mifa qini uqeereeqeenoo oonisaa kikiqammaqiseenoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Miqoo mifa fuka idi qini qima qiminoo mi idifa maasa Anutuna amooqira idi maridanoo. Moomoosa mina qafamasee rufiasee Anutuna saqarikifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Yaaweena saqariki mariasa asasiaqa. Tumunnai auqira anutufinnai sia ubeekee mariasa faqa unnaqira anutusa sia nimooqi mariasa faqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Oo Yaawee qini Anutufa anee moomoo afeeka naaquqara ainainannoo maasa dadaaqinau. Sia moo fannoo ani fooqaafa maridanoo. Anee moomoo amiqira irirausa maasara aneenna iriranaki qimirisaidana dadaaqi mariananoo. Qinee minauqara ufa qianee qimasee sia amana aiqamara ufa qianaura. Mifa moomoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Andau tatufirana faqa oosana oosana ani amira ainainara faqa anee akooqananoo. Anee aneenna aidimarianna tatufiranara ani ufamau firana qini daaqooki quqasaana iriaa. Aandau ida tatufirana faiqí aaqarana akiiqara amiranara faqa anee sia qimiannee qiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Qinee minara iriseeqa maaqi qiqa. Doo qinee anireeqa. Anutuna akarakinaafa qinee aniannanara qifaqa anidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Oo qini Anutu, ani aidirana mau firara firaaqoo dididanoo. Ani sanda ufa qini qimuqusaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Qinee ani faiqí anaasee moomoosa suqiqa mariana qambaanai anee maasa asumu maraannanara andeeqara ufa kai qimannimidaqa. Oo Yaawee qinee sia qeeqa doo qummunianaura, kaqi qimannimianaura. Anee minara irimmariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Qinee sia anee qini dadaaqinana qini asumu maraannanara qeeqa qimuqusaki rafaaqa fiqa, kooroomasee qimannimiqa. Ani mapukusee marira oosanara faqa ani asumu nimirana faqa kooroommasee qimannimiqa. Faiqí anaasee moomoosaki anee misara amuqusirana faqa ani kuqaa anoona ufa qirana faqa sia rafaaqa fiqa, kaqi qimannimiqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Oo Yaawee qinee iridaqa ani qiniara qimudaoo qirafa sia taikaannoo. Ani amuqusirafa faqa ani kuqaa anoona ufa qira oosana faqa qini itita qimaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Qini mandoosana moomoo sia asaanarirana amana qini Dafidisa fiqu fiqu inoo maridanoo. Qini aaqarafa doo qini rafaaqafusaifaqa sia qifu maqaidaqa. Qini qikiiqa qisausi moomoo maridanoo, qini aaqarafa mina faqa uriaaqaranoo sia asaanarirana amana maridanoo. Minara qini qimuqusa ummooquki fanoo qini afeeka taikaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Oo Yaawee anee qini mandainainakinaana mara quqaqisaa. Oo Yaawee kai kaqi aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Qini marirana taika qimaqarara randeemariasa rafaaqafu nimaqasee mareeqee furufariranaki quqannisaa. Qini aupuraranara asasimariasa mara quandasainaqa nisaurusee quqasee sandaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Qiniara uteeti qimariasa misa nariqa nisaurirana firaafa marina qafeeqa firaaqoo tautiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Oo Yaawee anee iannannai ani mariasa asasida nasuriaqa. Ani asumu mariranara dufi dufi qimariasa aiqama kari maaqi qiaqa Yaaweefa kaaqa uriqararafa maridanoo fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Qinee Dafidisa qimudaani radukirausa saraui marunna fasiqausa marunnanara oo Yaawee anee sia qiniara qaunuananoo. Anee qini asumu maree marianafa faqa qini Anutufa faqa mariannanara kai kaqi aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Kudi fasiqa aanaaseera irisee dadaaqi mariasa asasiaqa. Ummaara aukuanaki Yaaweefa miqimariasa uqeera kaqinni quqannisaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Kudi fasiqa anaasee dadaaqimariasa Yaaweefa ititannimaqaseenoo misa maa maqanasaa marirana afeekaika masainaqa kisaaqasaa marifaranoo. Maa maqa maaqanasaa marirana mifa amiqi amiqimannimaqaannoo. Sia mifa misa namuqaa nisaukuki quqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Miqi maria fasiqa aanaaseesa auriranaki marifanoo Yaaweefa misa dadaaqiannoo. Misa aurida marifanoo Yaaweefa misa aurirana taikannimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Qinee maaqi qidaqa, oo Yaawee qinee ani mandaikamma amaqeeqa. Anee qini qifauamasee qini auriranara foora taikaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Qini namuqaa qiniara nimuqusa ummaara reemarifaqa maaqi qidaqa. Yaireefee mi fasiqafa kuqinaqa maasa minara qaunuanauranoo. ");
INSERT INTO bjr_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Qinee aurimarunaqa akaqausa ani qiqafeeqa qisee ufoo qidaqa unnaqidaqa miqidaqa. Misa unna ufa irisee raudamaki oonuree aiqama tinai qini qifasaasa qidaqa qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Aiqama qiniara fidiaqaa imariasa nupiqnupita kiqari nári qimami nári qimami qidaqa. Qini mandainaina daruani fee qidaqa miqi qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Misa qiniara manda aurirafa aukainaina aurirafa mina arifanoo amiqimandee auridanoo mifoo qidaqa. Doo mifa rinoo maridanoo, sia findifuannoo, kuquannoo fee qidaqa qimatundaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Qini qifaaqasaa qiqoondi, qinee minasaa mundimarunna fasiqafa, qini faqa neeneeu fasiqafa, mifa narí aiku qumbaqi uqeera qumaree aiku ataannai qini darinoo. ");
INSERT INTO bjr_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Oo Yaawee, anee qiniara amuqusinana qini uqeeraqisee afeeka qiminaqa mina akiiqara mannimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Oo Yaawee qini namuqaa sia qini uridaaqaree mariafaqa qinee mina qafamasee oo Yaaweefa qiniara aidimarifanoo miqidanoo fee qidaqa qimiridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Anee qini andeeqara mariranara irisee qini uqeera qisainaqa naaru naaru ani oorisaa maria. ");
INSERT INTO bjr_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Yaaweena Isaraee maqannaasa Anutuna amooqia. Maqee faqa naaru naaru faqa amooqima amaqaa. Kuqaa uqanna kafaa kuqaa fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Aandau nammariara aidifanoo maqee maqee aannanai aannanai qidanoo. Qini maraquna fannoo misa naanna raida maqee maqee oo Anutu ani aaqa mariranara didimarifaqa daannanai daannanai idara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Qini nammariara foora kaqi marira Anutunara dididanoo. Yairee fee qinee oonuree minara innaaru qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Qini namuqaauqa moomoo kari qiniara yaqoo fee ani Anutufa marifanee qiafaqa qinee mina iriseeqa qikiraqaidaqa. Faasaana faqa eendaki faqa qeeqa daiqunu daukunu naidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Qinee ooqai iafannanara irunanoo qimuqusa mandaikidanoo. Ooqai qinee moomoo fasiqa anaasee indaarunnikiafanaqa Anutuna amaana maqaki fimariqau. Oonuree faaqa fuisee qida asasida Anutunara dufi dufi qira idiuqa reemariqau. ");
INSERT INTO bjr_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Nanaree qini daundura kaaqa ummaara raidanoo fee, nanaree qinee kaaqa ummaaraki maridee. Qinee Yaaweenasaa kai irirana mundusee kaifaa mina amooqianaura. Mifa qini asumu maree marifa faqa qini Anutufa faqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Oo qini Anutu, qinee ummaaraki maridaqa Yooradanna maqa maaqaki faqa Qeeramoona aaqanasaa faqa Misaraa aaqanasaa faqa maridaqa aniara irianaura. ");
INSERT INTO bjr_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Qini ummaara firaafa ooruku nammariara foora mandinoo maridanoo. Mi nammarina qamakaurirafa narisaa narisaa arinoo sandaaqai ooru fidanoo aiai qidaoo. Mifa innaarunaindari oondaindariara foora aaku quminoo maqasaa aqufifanoo firaaqoo aiai qidanoo. Ani mi nammari amakaurirafa qini uridaaqaramafi rafaaqafu qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Faasaana Yaaweefa narí sia taikara amuqusirana aiqainanoo qinisaa qumuani. Miqinaqa eendaki qinee minara dufi dufi qira idi raanaura. Qinee Anutufa qini mariranasaa rakisi marina innaaru qima amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Anutufa qini itita qimaqee marinara qinee minara maaqi qidaqa. Nanaree anee qini qaunuqiseenanee. Naqifee ifaqee qini namuqaa aupurarana qimi mariafaqee oonuree aniree iqa nidee. ");
INSERT INTO bjr_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Qini namuqaa qini ataasa ataasa ufa qima qimaqee mariafaqa kuqirafa qusaree marifaqara foora aupuraidaqa. Faasaambaasaana qiniara ani Anutufa yaifee maridanoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Nanaree qini daundura kaaqa ummaara raidanoo fee. Nanaree qinee kaaqa ummaaraki maridee. Qinee Yaaweenasaa kai irirana mundusee kaifaa mina amooqianaura. Mifa qini asumu maree marifa faqa qini Anutufa faqa marinara mina amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Anutu ani ufa sia iri mariasa qini rafaaqa fidaqa, anee qini dadaaqinaqa qifairi mariasa ufa urinnaaqarama saanaqa qiniara andeeqara oosana faqaafee qiaqa. Ueeqee mariasa faqa mandoosana faqaasa faqa nisaukukinaana qini maraquqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Oo Anutu anee qini titaqimaqee marianafa mariananoo. Nanaree qini minniqiseenanee. Nanaree qini namuqaa aupurarana qimi mariafaqee oonuree aniree iqa nidee. ");
INSERT INTO bjr_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Oo Anutu anee aneenna kaaqa qarana faqa anoona ufa qirana faqa niqiqainaqa qini aana muquniaqa. Mi irira qanda qini mareeqee Sioona ani naaquqara aaqanasaa, mari amaana maqanaki anee mariannaqoo quqaqisaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Qinee miqoo maridaqa Anutuna qaidara mariqoo mina amooqirara fuanaura. Kaaqa asasirana faqa kaaqa nariara didirana faqa qimimari Yaaweefa miqoo maridanoo. Oo Anutu qini Anutufa qinee piripuna aridaqa ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Nanaree qinee kaaqa doori runusee maridee. Qinee Yaaweenasaa kai irirana mundusee kaifaa mina amooqianaura. Mifa qini asumu maree marifa faqa qini Anutufa faqa marinara mina amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Oo Anutu, maasa qikeeku qikaaku ooqai anee auquqoonna ainainnara qimaqimiafaqa iridaqa. Maasa qeeqa daaqoonnai misa marukamuqoo auqoonna firaa ainainnara qima qimiafaqa iriqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Anee aneenna kai aanaamuru niqiqamasoona amaaramafufana maasa qikeeku qikaaku maa maqa maaqanaki mara quqanau. Anee aanaamuru aupurarana nimisee Isaraee maqannaa maa maqanasaa mara quqasoonaqa faiqí moomoo kambiqafi maa maqa maaqana amanakai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Isaraee maqannaasa sia nári rakiranannaifau maa maqa maaqana maraqau. Sia nári afeekannaifau maraqau. Anee aneenna afeekannai faqa eeraariranannai faqa oori inaa inaa iranannai maa maqana mara niminau. Anutu, anee misara ani aidi marunara miqinau. ");
INSERT INTO bjr_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Anee qini karaambaiqa qini Anutufa mariananoo. Anee aneenna maqannaasara rakiranaki namuqaa urinnaaqaraaqee qiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Oo Anutu ani afeekannai maasa qeeqa namuqaa rafaaqafi marunausa maridaqa. Akaqausa findifi darirariafana anee maasa faqa marianaqa maasa rakirana uraaqa raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Qinee sia qeeqa duru saqarikidaqa qini rakira paipana faqa sia qini dadaaqidanoo. Anee kai. ");
INSERT INTO bjr_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Anee kai maasara fidiaqaaimaria namuqaasa nisaukukinaana doo rafiamaree nisaurirana misa nimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Maasa aiqama kari Anutuna kai amooqidaqa. Naaru naaru minara dufi dufi qianaura. Kuqaa. ");
INSERT INTO bjr_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Anee maasa rakira fasiqauqa faqa nidana dadaaqiunafa maqee sia nidana, sia dadaaqimariananoo. Oo Anutu, anee maasa minniqiseenana maasa ooru muqufi qisaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Anee miqiannanara namuqaa maasa nifaqasaafaqa sandaunaqa maasa aiqama ainaina mareea. ");
INSERT INTO bjr_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Anee maasa mareeqee namuqaa nimianaqa misa maasa sipsipara foora kuqa darirara idaqa. Anee maasa aanaamurukiaqa doo daru qifaqaa qianaqa moodaa moodaa iqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Oo Anutu anee aneenna faiqí anaasee kaqikaa munnimma aqusee maree maria ainainnara foora mariafana namuqaa nimiananoo. Anee nimisee aabaa munnimma sia maree marianara foora nimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Anutu anee miqi marianaqa maasa qiqoonausa maasara naanaidara qidaqa. Maasa daaqa mariasa ataasa ataasa maqimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Anee sia maasa dadaaqiannanara aiqama maqannaasa maasa qisaurirana qimidaqa. Akaqa maqannaa maasa Isaraee maqannaasa qiqafeeqa uteeti qimasaidaqa ninuka aqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Qini namuqaa faqa qiniara fidiaqaa imariasa qini ataasa ataasa qima qimaqaafaqa qinee aiqama kari ummaaraki maruna qisaurirafa qini rafaaqa fidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Oo Anutu, anee fifau maasa dari mariananoo. Maasa aniara sia qauniqa sia ani qima afeekaikira ufa rukieeqa sandanainai qidaqa. Maa manda oosanafa fifau maasa rafaaqafu qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Maasa nimuqusa sia qikooqaifaqa andeeqara oosanasaaqari moosaa quandeeqa, kaqi mariaqoo kai maridaqa. Maasa qiku faqa maasa firana faqa sia ani minnisee qiku munuree miniree idaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Anee fifau maasa qimudaani tureeraummasee mareeqee kaasau faini ooki quqeenanara foora masaanaqa maridaqa. Anee firaa asukunannoo maasa rafaaqafu qimaqaananoo oosana sia marinaki fifau miqiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Maasa Isaraee maqannaasa Anutuna auqu qaunusaananoo fau mifa iriqini. Maasa unna anutunauqa uqeeraananoofau Anutufa minara faqa iriqini. ");
INSERT INTO bjr_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Anutufa maasa qimuqusaki kukeeqara ainainara irimarifa marinara mi aiqama ainaina qafaiqini. ");
INSERT INTO bjr_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Faasaambaasaana misa ani auqusaara maasa daruqifaqaaidaqa. Misa maasara kuqifandinna sipsipausee qimasaida maasa daruqifaqaaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Oo Yaawee findifua nanaree faiqaidanee. Findifua sia kisaaqasaa maasa minniqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Anee nanaree aneenna oorisaa ititasee sia maasa qiqafaidanee. Yaawee anee nanaree maasa aupurarana faqa ummaara qimiranara faqa qaunidanee. ");
INSERT INTO bjr_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Maasa maqasaa aqufunaqa nikusamu radamu saafaqa maqasaa riqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Oo Yaawee anee findifi maasa dadaaqia. Aneenna maasara naaruara aidiranara irisee maasa mareeqee amiqiranaki quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Amiqira irirafa qini iriranaki umbiqanoo marifaqa karaambaiqa irianifeera maa idi ufana akara ruma amidaqa. Qini qifauru fannoo papiqa saiki marina amiqira kirifiara foora maa idina akara ridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Oo maasa maqasaa Karaambaiqa ani afaaqa aiqama faiqí faiqikiqari amiqirafa mariananoo. Ani afauru deepimaseera foora amiqira ufa adiafaa ira ufa kai ani ookiqari ururaidanoo. Minara naaruara naaruara Anutufa ani amiqi amiqimma amaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Oo uriqararafa ani afeeka faqa ani qareenarafa faqa ani uriqararafa faqa marinara doo aneenna duru feefa deedaqinana rakiranaki fua. ");
INSERT INTO bjr_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Anee aneenna uriqararana namu faqa doo rakiranaki finana uriqaraa. Fimarinaqa ani anoona ufa qirana faqa andeeqarana faqa sia rafaaqa fuaqeera rakiranaki fua. Ani rakirafa afeekaikinaqa manda oosana maree mariasa aniara firaaqoo rufieefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ani duru feefa aaruqirafa namuqaauqa nimuqusaki kai naruannoo. Miqiannanannai moomoosa ani aikuki aqufifana radamu nimaqeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Anutufa anee naaru naaru uriqarana maridana aneenna faiqí anaasee andeeqara oosanannoo rakisi nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Ani andeeqaranara aidinoo mandainainara fidiaqaa inoo imarifa mariananoo. Minara kai ani Anutufa ani utaaqamaseenoo asasirana ani akiiqa amoondunna akaqa uriqararausa adia nimaqaina faqa uraaqa ramasee adia amaqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Ani qamunna makaqa mandeefana undidanoo ani karaambaiqa amiqira maaqakina aiqama ainainauqa eereefanta aanainnai auqira ainainauqa kai maridanoo. Minaki piripunna oosana oosanannai auqaafana anee asasimariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Akaqa karaambaiqa niraamuqmaaka uriqarara aanaaseeuqa kai ani maaqaki maridaqa. Ani karaambaiqa asauku uqannai ani anaaqa uriqarara anaasee amiqira qamunna afisimarufa Oofiraa maqusaindaraa koorannoo afaaqa auqusee ani asauku uqannai kikiqinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Oo fuka amundara anaasee anee aneenna aaqoo ramatinimmafi qini ufa iria. Aneenna maqannaa faqa aneenna ainainara faqa qaunuseenana aneenna afaaqi maqa maaqaki kai maria. ");
INSERT INTO bjr_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Miqimarinanoo ani afaaqi karaambaiqa ani amiqira oori afiriara firaaqoo aidiannoo. Mifa ani karaambaiqa maridanoo anee minara kai qeerairidana mina ufa qaindusua. ");
INSERT INTO bjr_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Tiree maqusaindaraasa moo amira ainaina nisaukuki uqirausa aniree asasidaqa amifaranoo. Faiqí aanaaseekiqari ainaina faqaasa aniree ani aqoondikifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Moo maqannaa karaambaiqa araamuna fannoo narí afaaqauqira maqaki maridanoo narí afaaqinnai firaridanoo. Mi manaaqana qamunna koorannai auqirafa idaaqirafa kai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Misa mina afiqamaree narí qamunna oosana oosana akararirana namufaqa karaambaiqa munu amiafaqa qafeeqa. Aqoonna maanaaqauqa mina dadaaqi marusa mina afiqee fia. ");
INSERT INTO bjr_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Misa asasirana namufaqa nasu nasurirana namufaqa aana muquniqa karaambaiqa amiqira maaqaki keeqaafaqa niqafeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Maa anaaseena afaaqi karaambaiqa, ani faiqi namu kambiqainausa ani amaaqa maqee findifi karaambaiqaikiqa fifaranoo. Aneenna faiqi namu anee kaqi maridana aiqama maqa maaqai uriqararausaika mannimaqasaina rakisi nimaqeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Qinee ani auqu uqeerasaanaqa naaru naaru aiqama kambiqeefandinausa minara irifaranoo. Miqiannanara faiqí anaasee naaru naaru ani amooqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Anutufa maasa kukeeqara maqusa faqa maasa afeeka faqa maridanoo. Maasa aiqama kari ummaaraki aqufunanoo dadaaqi marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Maasa minara irisee sia rufiaanaura. Maqa firaaqoo kasinaqa sia maasa minara rufiaanaura. Aaqana namu mareeqee ooruku nammari qambaanai uqasaina aqufinaqa maasa sia minara maparaa ianaura. ");
INSERT INTO bjr_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Aiqama nammari aufinoo firaaqoo narisaa narisaa arinoo qaqaara qaqaarinanoo firaaqoo ufaqinaqa sia rufiaanaura. Aaqana namu kasinaqa nammari fannoo aaqana ammitu ammitu inaqa sia rufiaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Anutuna maqusa aaqa mari nammarifa qumidanoo raina rainidanoo Anutuna maqusaki mariasa mi nammarifa asasirana nimidanoo. Mi maqusafa naaquqarafa marifanoo uriqarara Anutufa mi maqusanaki maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Anutufa mi maqusanaki marinara sia kasinoo sia aqufuannoo. Namuqaa aniraifanoo mi kananaanna kai Anutufa dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Aamina maqannaa tautummasee aanoo qimasee faaqa fuisee qiafaqa akaqa maqannaasa kurididaqa. Misa miqi mariafanoo Anutufa narí ufa firaaqoo uqeeraifanoo aiqama maqa tasirisirinoo nammarikidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Karaambaiqa aiqama afeeka faqaafa maasa faqa maridanoo. Yaakooboona Anutufa maasa afeeka kukeeqara maqusa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Oo aiqamausa aniree Yaaweefa auqamasai ainaina qafaa. Maa maqa maaqana aiqama naaquqara ainaina auqaina qafaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Mifa maa maqa maaqanasaa aiqama atiqara mari rakirana taikannimaqaidanoo. Mifa duru feefa itairaatairidanoo. Rakira saqari faqa idaki aqusaifanoo qama taikaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Oo innee kasoomafinaqa qinee Anutusa marunnanara oonumafi iriaqa. Qinee moomoo maqannaasa qambaanai uriqaraqa marianaura. Qinee aiqama maa maqa maaqanaki uriqaramafuanaura. ");
INSERT INTO bjr_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Karaambaiqa aiqama afeeka faqaafa maasa faqa maridanoo. Yakooboona Anutufa maasa afeeka kukeeqara maqusa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Oo innee aiqama maqannaasa nisauku aridaqa asasiaqa. Innee Anutunara idi rama amaqaidaqa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Kaaqa uriqarara Yaaweefa naaquqarafa maridanoo, minara rufiaaqa. Mifa aiqama maqa maaqasaa uriqarara karaambaiqa maridanoo rakisi nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Mifa aiqama maqannaa mareeqeenoo maasa Isaraee maqannaa niramandunnai quqanau. Aiqama maqannaa oonu mafi maasa qiku ameemaanai quqasanau. ");
INSERT INTO bjr_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Maasa maqa maaqa qimiraree qimasee utaaqama qimaqoona narí kai qiminau. Anutufa mi amiqira maqa maaqana maasa Isaraee maqanaasa narí aidi marusa qimufaqa maasa mi maqa maaqanara asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Anutufa narí ufa irira qaari maruqoo ooru fimarufaqa mina fiqu fiquiqa marusa faaqa ridaqa asasi mariqau. Ukeena fuaqarana namufaqa Yaaweefa ooru finau. ");
INSERT INTO bjr_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Amooqira idi Anutuna ramamia. Doo ramamiaqa. Maasa karaambaiqa amooqira idi ramamiaqa. Doo kafaa idi ramamiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Anutufa aiqama maa maqanasaa mariasa karaambaiqa maridanoo. Doo innee mina amooqira idi ramamiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Mifa narí naaquqara qaarisaa ooqu marifi aiqama maqannaasasaa rakisi nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Aiqama maqannaasa uriqararausa moodaaqoo Abarahaammana Anutuna ufa iri mariasa namufaqa suqidaqa. Misa aiqamausa Anutunaindi maridaqa. Mifa firaaqoo uriqarara afeeka faqaafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Yaaweefa firaafa uqanna maridanoo. Maasa Anutuna maqusaki mina naaquqara aaqanasaa mari maqusanaki maasa Anutuna amooqidaqa. Mina firaaqoo uqanna amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sioona aaqana Anutunaindi kaaqa uriqararafa amiqirafa maridanoo. Mifa uriqarara karaambaiqa maqusa maridanoo. Mi aaqanafa maa maqa maaqanakinaa fasiqa anaasee asasirana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Anutufa mi maqusanaki maridanoo faiqí anaasee dadaaqidanoo, mifa rakira aukuana faiqí anaasee mi afeeka faandaamura ququsanaki dadaaqidanoo ititannisaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","5","Moomoo namuqaa karaambaiqauqa suqufi mi maqusana ooru qafoofanoo naindiri ree naaquqoofaqa quqasee doo sandamafiqau. ");
INSERT INTO bjr_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Naindiri rarafa misa naakufufaqa anaasee innaamunara auruandee miqau. ");
INSERT INTO bjr_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Namuqaa nariqa rakira kannuqaki oobiqasee urufanoo suani oosanaindari ufai firaafa urinoo nammari amakaurufanoo misa kannuqa Tarasisaa maqusanaasaindi teeqindee mannisanau. ");
INSERT INTO bjr_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Maasa ooqai Yaaweefa rakisi marunara iriafannana maqee maasa qeeqa qifunnoo qafeeqa. Yaaweena aiqama afeeka faqaana maqusa marinara narí Anutufa mi maqusanaki amiqimmasee ititaqaifanoo naaru naaru afeekaikinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Oo Anutu, ani naaquqara amaana maqaki keeqafiqa ani maasara firaaqoo aidi marinara oonumafi iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Oo Anutu, aiqama maqa maaqaki mariasa ani amooqidaqa. Ani firaa auquara aiqama maa maqa maaqanakinaa fasiqa anaasee asasidaqa. Anee andeeqara oosanannoo rakisi nimaqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Oo Anutu, ani rainara ufa andeeqarafa marinara, Sioona aaqanasaa mariasa asasiaqa. Yuda maqa maaqakinaa maqusakiaqa mariasa faqa nasuriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Innee Anutuna faiqi namu Sioona aaqana fiqu fiqummasee qafaaqa, ooni faandaamura auquqoona amiqimasee qafeeqa asaanaruaqa. ");
INSERT INTO bjr_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Mina faandaamura ooru ree qumuree qiranakiaqa qafamaqaraasammasee kasooaqee inaaqianna kambiqainausa mi faandaamuranara qimannimiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Maa Anutufa naaru naaru innisaimbaqa Anutufa maridanoo. Mifa naaru naaru maasa qifiqee aana uqaqifiqanoo fuannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Maa ufana aiqamausa iriaqa. Aiqama maa maqa maaqanaki mariasa amiqimmasee iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Aiqamausa uriqararausa faqa ureeqarausa faqa ainaina faqaasa faqa kudi fasiqa faqa, aiqama iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Eeqá dookiqari irirana faqaasa ufa kai qianaura. Qini daunduraindaraa irirafa andeeqara irirana maree maria irirana nimiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Eeqá naamuaqira ufa quandasee qianaura. Qini quandara ufa piripuna aridaqa idinnai qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Manda aukuana aninaqa qinee sia fifau rufiaanaura. Mandoosana maree mariasa qini fiqu fiqu iqa maridaqa mandaikamma qisararifaqa sia qinee minara rufiaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Mi aaqara fasiqausa nári ainainasaa kai mundidaqa, nári moomoo munnimma ainaina faqaasa marianara nári nimoo namoo qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Maasa sia amana qeeqa maa maqanasaa kisaaqasaa marirana feefaurianaura. Maasa sia amana Anutuna munnimma amisee qeeqa marirana feefaurianaura. ");
INSERT INTO bjr_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Faiqí marirana feefaurirafa firaafa fiqaranoo maridanoo. Firaa feefauru tia aqinanoo faqa sia kai amanaikiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Sia amana feefauru Anutuna amisaifanoo maa maqanasaa kisaaqasaa marida sia kuquanee qiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Aiqamausa maa ainainna qafaidaqa. Irirana faqaasa misa faqa kaqi kuqifaranoo. Irirana siaisa faqa furufarirausa faqa aiqama amana amana kai kuqiqa nári ainaina mafi quqasaafaqa akaqausa maraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Ooqai maqa misaindi marinau. Maqee faiqí madika fannoo misa maqusa maridanoo. Naaruara naaruara misa mi madikanaki kai marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Maasa uriqarara duqu fannoo sia amana kuqirana itita qimaqaannoo. Maasa kaqi aandaura foora kuquanauranoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Faiqí náriara uriqararausee qimasee náriara kai irimariasa, miqira fasiqa irirafa sia andeeqanoo maridanoo. Misa fifau nariqa ainainara asasidaqa misa faqa aandaura foora kai kuqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Misa sipsipauqara foora kuqifaranoo. Misa kuqu fifanoo kuqirafa misa sipsipasaa rakisirafara foora misa rakisi nimaqaannoo. Andeeqara oosana maree mariasa doo misa kanaanaanara foora findifiqa manda oosana maree mariasasaa rakisifaranoo. Manda oosana maree mariasa kaqi maridaqa amiqira maaqaki mariinaqa kuqiqa sia minaki marifaranoo nianai madikaki maridaqa kai kaqi putaa ifaranoo. Misa miqiqa mariafaqa qinee sia misa naanna raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Anutufa qini kuqira afeeka ameemaanaindaraana feefauru masainaqa asumu marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Faiqí moo fannoo firaaqoo ainaina moomoo faqaafaikinnanara sia minara irinanoo amuqusiani. Mina maaqa amiqirana firaana usakainara sia anee qinee faqa miqiaqaanee qia. ");
INSERT INTO bjr_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Mi ainainna faqaa fasiqa kuqinoo sia moo ainaina maree fuannoo. Mina qumiasana sia mina faqa madikaki ooqu fuannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Mi fasiqafa kaqi maru kamuqoo moomoo amiqira ainaina faqaafa maridanoo mifa fifau nariara amiqi amiqiranaki maridee qimarinau. Mifa moomoo amiqira ainaina faqaafa marufaqa aiqamausa mina amooqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Ainaina faqaafa kuqinoo mifa faqa narí akeeku akaaku kuqiqa oonu mariaqoo fuannoo. Mifa miqoo oonu maridanoo sia kaifaa kaaqa qarana qafaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Maasa uriqarara duqu fannoo sia maasa kuqiranasaa itita qisaannoo. Maasa aandaura foora kaqi kai kuquanaura. ");
INSERT INTO bjr_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Afeeka faqaa Anutufa Yaaweefa maa maqa maaqanakinaasara nammeera qifaqa suqufuafanoo qimannimi marifa maridanoo. Suani oosanaindari faqa suani keeqee marinnaindari faqa nammeera qifaqa suqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Sioonna maqusa kaaqa amiqirafa qareenarafa marifanoo Anutufa mi maqusanaki maridanoo akooqoo kaaqa qaidanoo rupannoo imarifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Maasa Anutufa anireenoo sia ufa siaina marifa maridanoo. Ida fannoo mina afunni fidanoo fasafasimarifanoo fidanoo. Misaqa mina fiqu fiqu inoo mari ainainausa ufai aakuasaa innaarunai qirafa mifauqa kai firaaqoo ufa qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Anutufa aiqama maqannaa suqu quqaseenoo misa ufa andeeqaani qimasee innaaruna faqa maqa faqa naaramasainaqa anireeqa Anutufa narí faiqí anaasee raina nimaqaaninna ufana irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Anutufa qidanoo, qiniki mapukusee maria fasiqa anaaseesa suqumaree moodaaqoo aniaqa. Aandau tatufiranannai qini faqa qima afeekaikirana qimimariasa misa qinee marunnannai moodaaqoo suqumaree aniaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Innaaruna fannoo Anutunara maaqi qimasee kooroo idanoo. Anutufa narí kai andeeqarafa ufa raina nimaqee marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Anutufa kafaa maaqi qidanoo. Oo Isaraee maqannaa qini maqannaasa irifaqa inni mandoosanara kooroommasee qimannimianaura. Qinee Anutusa inni Anutusa maridaqa qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Innee qimi maria ainainna faqa aandau tatufi mariana faqa maqee maqee qimimariana sia minara aanoo qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Qinee sia inni aandauqa kinaana burimmakau akoonara dididanoo. Sia inni mimmi ququsakinaana moora dididanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Nandaki maria kaasau aandausa aiqama qinindi kai maridanoo, maaqeena aandau aiqama aaqanasaa faqa maqa maaqaki mariasa qinindi kai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Aiqama ufiniuqa faqa qinindi kai maridanoo. Aiqama maqa maaqaki maria aandausa aiqama qinindi kai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Qinee Anutusa aandaura didi marinaqau sia inni qimannimunaiqini. Maa maqa maaqana faqa aiqama minaki mari ainainausa qinindi kai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Innee qiniara burimmakau akoona amaqi neemarifee fee qidaqee. Innee qiniara mimmi fidika faqa neemari fee fee qidaqee. Sia mina naidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Innee dufi dufi qirana kai tatufiranara foora qini Anutusa qimiaqa. Innee qini uriqarara afeeka faqaasara qima afeekaikammaqaa mau kai fuaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Ummaara inniki kambiqafinaqa qini daaraifaqa qinee inni dadaaqianaqa innee quandakina qini qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Aaqara oosana maree mariasa Anutufa maaqi qimasee qimannimidanoo. Innee nanaree qini naamuaqira ufa nikaru qimasee naakapaidee. Innee nanaree qini moodaanaki kira ufa unnaqimasee inni nifaurusaaqari uridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Qinee andeeqa nimaqararunaqa nikooqee mariasa. Aiqama kari qini naamuaqira ufa rukiee mariasa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Innee qummuari mari fasiqana qafamasee mina aqoondiki mariafanoo. Innee faiqí anaasee qummuari mariasa niqafamasee innee faqa minaki ootupee mariasa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Inni noo fannoo manda oosanara qiranara kai rakisidanoo. Inni nifauru fannoo unna ufa qirara sia marammara ridanoo kaqi qimariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Innee inneeqa nikaqaafasaa unnufannai misa ufa nimi mariasa mariafanoo. Innee oosana siainaki misara manda ufa qimariasa mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Innee mi manda oosana oosanausa auqee mariafaqa qinee Anutusa kaqi kasooiqa marunaqa innee qiniara Anutufa maasa daanna raidanoo manda oosanara sia ufa qidanoo fee qimariafanoo. Innee miqi qidaqa aaqee mariafanoo. Inni nifusaa akooqoo inni aaqaranara kooroomma nimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Innee qini Anutusara nikooqee mariasa maana iriaqa. Qinee inni mandaikamma nimaqaanaura. Sia moo fannoo amana inni dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Qini Anutusa dufi dufi qirana tatufiranara foora suqa qimimariasa faqa qini ufamau fimariasa faqa qinee Anutusa qeeqa asumu marirana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Oo Anutu aneenna sia taikaaninna amuqusirafa marinara irisee qini qifauama qisaa. Aneenna firaa nifauarafa marinara irisee qini aaqarana akiiqara rukaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Qini manda oosana findaukamaqisaa. Qini aaqarana nammari uqu taika qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Qinee qeeqa aaqaranara iridaqa. Qini manda oosana fannoo naaruara doorinni marinaqa sia qaunuanaura. ");
INSERT INTO bjr_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Oo Anutu qini aaqarafa ani kai mandaikamma amaqeeqa. Ani afusaa kai maa manda oosanna auqeeqa. Oo Anutu akooqoo ani qimamidaqa. Anee qini ufa qimiannana anee kuqaa andeeqarafa mariananoo. Anee ufa qimiannanannai qini aaqarana akiiqara iananoo. ");
INSERT INTO bjr_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Qini qinoofa qini maqa qisooqooqari numoo aanaaqi mariafanausa maridaqa. Qeeqa qinoona amuaquki mariafananoo aaqarana asumu qiniki marinau. ");
INSERT INTO bjr_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Oo Anutu faiqí naundarai anoona ufa kai marianifee qimarianafa mariananoo. Qini daundurai kukeeqaranaki aneenna irirana daamuaqia. ");
INSERT INTO bjr_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Anee qini anukama qisainaqa qinee anukaqa maria. Qini nammari uqusainaqa qinee eekara arira qasuruara foora qiqa maria. ");
INSERT INTO bjr_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Oo Anutu anee qini aaqarana akiiqara qini qimudaani raqeera foora maqaanaqa maridaqa. Anee qini aaqarana minni qisainanoo qini qimudaani kafaa ootupeera foora inaqa qinee asasianaura. ");
INSERT INTO bjr_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Aneenna afu tautasee qini aaqarana sia qafaa. Qini manda oosana aiqama rukaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Oo Anutu qini qimuqusa fuka amiqira qimuqusa auqu qisaa. Qini daunduraki naaruara ani ufamau fira maraquna quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Sia qini mareeqee aneenna mariannaqooqari aquqisaa. Aneenna naaquqara andeeqara maraquna qiniki marina sia maraqua. ");
INSERT INTO bjr_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Qinee ani asasira asumu mariranaki mariufaqa kaqinni ubeekaqa marunnana kaifaa mina qiminaqa asasia. Miqianana anee kaifaa ani ufmau fira didira maraquna qiminanoo qini dadaaqinaqa ani aidirana mau fua. ");
INSERT INTO bjr_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Anee miqinaqa qinee aaqee mariasa ani andeeqara aana uqannifiqaanaura. Manda oosana maree mariasa faqa irisee anee innannai quandaki ubeekeefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Oo Anutu qini asumu marirana qimianna Anutufa mariananoo. Anee sia qini kuqa darua, anee ititaqisainaqa qinee firaaqoo asasida ani andeeqaranara idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Oo Yaaweefa anee qini doo raqasainaqa qinee qeeqa dookiqari ani amooqiranara kai koorooianaura. ");
INSERT INTO bjr_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Qinee ani Anutuna aandau tatufirana amianee runana anee sia didiifoo qianaqa minniseeqa. Qinee tatufirana ani amianee runana anee minara sia asasiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Anutufa narí amira ainainara akooqaidanoo. Qini tatufirafa qeeqa mara maree qumirafa maridanoo. Anee nariqa mara maree qumira oosana faqa faiqí nári mandainainakiqari quandara oosanara faqa sia akooqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Oo Yaawee aneenna amiqira iriranannai Sioona maqusanaasa amiqi amiqimmannimaqaa. Anee Yeerusaree faandaamura kafaa auqu uqeerasaa. ");
INSERT INTO bjr_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Auqu uqeerasainaqa miqooqari ani aminna ainainafa ani aidimarifa mariannoo. Aandau muduka tatufirana suqarafa oosana oosana ani aidirafa kai mariannoo. Miqoo misa burimmakau akoonauqa arusee tatufirana suqasee ani amifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Oo amudaanai qimarianna fasiqa, anee nanaree aneenna manda oosana amooqidanee. Anee nanaree faasaambaasaana anee Anutufa aidimari fasiqa aanaaseesa mandaikamma nisaidanee. Anutufa mapukusee marira oosana fannoo naaruara marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Manda fasiqa anee mandaikamma nimaqarara kai tipundaari marianafa mariananoo. Afai keedaira foora raiqarafa unna ainaina kai inanuanafa. ");
INSERT INTO bjr_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Ani manda oosanara rirafa amiqira oosanara rimariannana uriqaranoo maridanoo. Ani unna ufa qiranara aidirafa anoona ufa qira aidirana uriaaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Anee unna ufa qirara kai aidi marifa mariananoo. Anee faiqí mandaikamma nimaqara ufara kai aidi marianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Anutufa kuqaa uqanna anee mariannaqoo qaraana ani rarisameeqee naaru naaru kuridiranaki quqasaannoo. Mifa ani maaqakinaana qumara rarisameeqee ummaaraki quqaisaannoo. Mifa maa maqa maaqakinaana ani umareeqeenoo kuqiranaki quqaisaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Anutufa manda fasiqauqa kuridinnimaqainaqa andeeqee mariasa qafamasee rufieefaranoo. Misa mi manda fasiqausara naanaidara qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Misa mi manda fasiqanara maaqi qimasee uteeti qifaranoo. Maa fasiqafa sia Anutunasaa mundidanoo. Sia mina dadaaqianifee qidaqa. Narí moomoo ainainasaa mundinoo maridanoo, mifa narí firaa qumiasanara qini dadaaqiannoo fee qidanoo. Mifa narí manda oosanara qini itita qimaqaannoo fee qianoo ");
INSERT INTO bjr_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Qinee Davidisa sia miqimarunausa maridaqa. Qinee Anutuna amaana maqaki fuka oorifa saqariara foora ammunidaqa. Qinee naaru naaru Anutuna sia taikaaninna amuqusirana saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Qinee anee auquqoonna ainaina oosana qafamasee naaru naaru ani faiqí anaasee nifusaa dufi dufi qianaura. Qinee ani andeeqaranara kooroommasee qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Furufari mariasa nári nimuqusakiqari maaqi qidaqa sia Anutufa maridanoo fee qidaqa. Miqi qimariasa oosana mandaika minoo maridanoo. Misa manda ainaina kai auqee mariasa maridaqa. Sia moo fannoo andeeqara oosana maraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Yaaweefa innaarunaindari maa maqanasaa faiqí faiqi mariasa nindafaidanoo maaqi qimasee qimannimidanoo. Akaqausa amiqira irirana faqaasa maridee sia fee maridee. Akaqausa qini Anutusara randaidee sia fee randaidee qidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Aiqamausa quandaki kaqi runna fidaqa. Misoo maasoo amana amana kai mandaikiqa maridaqa. Sia moo fannoo andeeqarafa maridanoo. Sia uqanna. ");
INSERT INTO bjr_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Anutufa maaqi qimasee iraidanoo. Manda oosana maree mariasa irirana siaisee maridee. Misa qini faiqí anaasee ainaina qumuaramasaida minasaa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Miqi mariasa firaaqoo rufiee faranoo. Ooqai rufioona arusee maqee firaaqoo rufiqeefaranoo. Anutufa narí faiqí anaasee namuqaauqa naruseenoo misa nimudaani aiqama tinai modaa moodaa aqusaannoo. Anutufa mi namuqaasa ameesuqinaqa Isaraee maqannaasa misa naru nifaqaaqifara. ");
INSERT INTO bjr_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Qinee maaqi qimasee innaaru qidaqa Isaraee maqanaasa asumu marirafa Sioona maqusakiqari aniani. Anutufa Isaraee maqannaasa nári maqa maaqa faqa qumiasana faqa kafaa rairaamma niminaqa misa asasidaqa idireefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Oo Anutu aneenna afeekannai qini mara amiqiranaki quqaqisaa. Aneenna firaa afeekannai qini rumbaranakinaana iduku qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Oo Anutu, qini innaaru qirana iria, qini dookinaa ufa iria. ");
INSERT INTO bjr_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Ramoo ramaa imariasa aniree qini dariraridaqa. Faiqí kuqa narimariasa qini marirana taika qimaqarara midaqa. Anutu ani ufara sia irimariasa qini dariraridammia. ");
INSERT INTO bjr_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Kuqaa Anutufa qini dadaaqi marifa maridanoo. Qini mariranasaa rakisi marifa Yaaweefa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Anutufa qini namuqaa qini mandaikamma qimaqee maria oosannana quandasee nariqa faqa mandaikamma nimaqaani. Oo Yaawee aneenna mapukusee mariranara irisee misa kuridinnisaa. ");
INSERT INTO bjr_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Oo Yaawee qinee aandau tatufirana ani suqa amirara dididanoo. Oo Yaawee ani auqu amiqirafa marinara ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Anee qini dadaaqiananoo aiqama ummaara fannoo sia qini rafaaqafinoo. Miqimma saanaqa qeeqa qifunnai qeeqa namuqaa aqufuana niqafeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Oo Anutu qini innaaruqirana iria. Qinee ani iramirianana sia aaqoosaa ititasee kaqinni oori rafusu aqua. ");
INSERT INTO bjr_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Anee qini ufa irisee dadaaqinnanara qima qimia. Qini ummaara irirafa qini daruaqaa midanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Qini namuqaa qini mandaikamma qimaqarara sandanainai qidaqa. Mi manda oosanna maree mariasa qini rafaaqafu qimaqaidaqa. Misa ummaara mareeqee qinisaa quqaidaqa. Misa qiniara aanoo qimasee fidiqaamaqisaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Qinee firaaqoo rufiee marunanoo mi irirafa qini kuqirafa qimaqaa idanoo. Kuquanna daaquqarafa firaafa daakinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Firaaqoo rufiee marunanoo daindiri raidanoo. Kuqira daaquqarafa qini rafaaqfinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Qinee nakipuruna miqirausa qiqoosa faqaasa maridau qaqamaree moosaa oonuree idooaranaki marini. ");
INSERT INTO bjr_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Qinee qaqamaree nianai faiqí sia mariannai maaqa marunaiqini. ");
INSERT INTO bjr_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Ufainamu faqa aakuasaa namufaqara foora namuqaa darimariafaqa ufini maridau kai kaqi mooatinai auqaanaira foora asooarannai fini. ");
INSERT INTO bjr_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Oo Yaawee anee qini namuqaa ufa qirana furufaramma nimaqa. Narirafa faqa aanooqirafa faqa qini maqusaki marinara miqimmannisaaneera qinee ani iraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Eendaki faqa faasaana faqa maqusa faandaamura afaimau oonuree aniree idaqa manda ainaina faqa ummaara faqa uqeeraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Kuridinnimaqara oosana fannoo maasa maqusaki aiqama tinai maridanoo. Narira ufa faqa unna qira ufa faqa maasa maqusaki aiqama tinai qumbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Qini namuqaa qifasaasa ufa qimi naqau kaqi maraunaiqini. Qini namuqaa darirari faqau qinee miqooqari kukeeqafini. ");
INSERT INTO bjr_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Sia qini namuqaa fau miqidau anee qini fooqaa ira fasiqa qini qifaaqasaa qiqoondi fannoo qini qiqoonafa qiniara ueeqee mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Maaqanda moomoosa faqa moodaanaki Anutuna amaana maqaki keeqafiqa amiqira ufa narí qimami narí qimami qimari qiafana. ");
INSERT INTO bjr_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Kuqirafa qini namuqaauqa tautumasee naruani. Misa kaqi marifaqa misa mareeqee kuqirausa marianaki quqaaqa. Aaqarafa misa maaqaki faqa misa nimuqusaki faqa marinara miqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Qinee Anutuna aaraananoo mifa qini asumu maraannoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Eeneemarinaqa faqa kananaana faqa faasaana qambaana faqa qinee qeeqa aupuraranakiqari aaraananoo mifa qini ufa iriannoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Rakiranaki moomoo namuqaa darirariafanoo Yaaweefa minakinaana amiqimmasee qifiqaifaqa oonurandee qimaaqa anianaura. ");
INSERT INTO bjr_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Misauqa nári manda nirana sia minnisee andeeqarannai quandaidaqa. Misa Anutunara rufiarafa sia maridanoo. Anutufa naaru mariranakiqari uriqararafa marifa qini innaaru iriseenoo misa aupurarana nimiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Qini ooqeenaa qiqoondi fannoo narí aqoondiuqa naridanoo. Narí aqoondikira qima afeekaikira ufa rukiasee naridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Mina afaurusaa ufa fannoo fadameenara foora amiqi amiqi qimarifanoo mina amuqusaki qari rakirafa kai kambiqee marifa maridanoo. Mina ufa fannoo fadameenara foora farindaidanoo mi ufana anoona aseema miqirafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Aneenna ummaara Yaaweenasaa quqasainanoo mifa aufadama amaqaannoo. Yaaweefa andeeqarausa mandainainaki aqufifanoo irinoo siamma mininnisaannoo dadaaqammiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Oo Anutu anee faiqí kuqa nárí mariasa faqa unna ufa qiqanuasa faqa sia asooqa qeefaranoo, fukasaa kuqifaranoo. Misa miqifaqa qinee ani kai saqarikinaura. ");
INSERT INTO bjr_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Oo Anutu, anee qiniara qimudaoo qia. Faiqí moomoo nimudaanai qimasee qini daru qifaqaa qidammia. Qini namuqaa aiqama kari qini qifaqasee dariraridammia. ");
INSERT INTO bjr_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Qiniara ataasataasa qimariasa faasaambaasaana qini daru qifaqaa qidammia. Moomoosa qini dariraridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Qinee rufiaunna kari Oo Yaawee, qinee ani kai saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Qinee Anutuna saqarikdaqa sia moo ainainara rufiaidaqa. Mina qima afeekaikira ufara irisee mina auqu quqeeraidaqa. Faiqí faiqi nana mandaikee maqimaqaifaqa sia qinee rufiaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Aiqama faasaana qini namuqaa ummaara qimidaqa. Misa maqee maqee qini mandaikamma qimaqarara kai iridaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Misa qini marirana nirana qiqafamasee qini darirara kukeeaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Oo Anutu, anee misa manda oosana akiiqara aupurarana nimia. Anee aneenna aanooqiranannai mimaqannaasa muqufisee rafaaqafunnisaa. ");
INSERT INTO bjr_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Oo Anutu qini qiki raqarana aneenna papiqaki akararua. Qini daukunu quminara papiqaki padimmasee akara rua. ");
INSERT INTO bjr_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Qinee ani aaraanana anee irisee qinaqa namuqaa sandeefaranoo. Anee miqinaqa qini Anutufa qini saaroo qidanoo fee qianaura. ");
INSERT INTO bjr_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Qinee Anutuna saqarikidaqa mina qima afeekaikira ufara amooqidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Qinee mi Anutunasaa kai qeeqa irirana rusidaqa. Faiqí faiqi nana mandaikee maqimaqaifaqa sia qinee rufiaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Oo Anutu qinee qima afeekaikiafanna ufanara irisee dufi dufi qirana aandau tatufiranara foora suqamianaura. ");
INSERT INTO bjr_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Oo Yaawee, qinee madika afaisaa oonuraunnana uqeera qisaannanara dufi dufi qira tatufirana suqamianaura. Qinee farindamaki saamurirara unana qini mara findifuma qisaananoo. Qinee ani Anutuna afusaa kaqi marira kaaqa qaranasaa nuaneera mara findifuma qisaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Qiniara qimudaoo qimisee dadaaqiannee qidaqa. Oo Anutu qiniara qimudaoo qimasee dadaaqia. Qinee anee iannannai dadaaqianeera animarunnanara irisee qimudaoo qia. Qinee ani aqoosa ameemaanai itita qisaina kuqirafa aiqaramafinaqa akoonnai anianaura. ");
INSERT INTO bjr_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Qinee Anutuna aiqama afeeka faqaana aaraidaqa. Qini didimari aiqama ainainna qimimari Anutuna aaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Mifa innaarunaindari qini innaaru qirana iriseenoo qini asumu maraannoo. Mifa qini mandaikamma qimaqee mariasa rafaaqafidanoo. Anutufa narí sia taikaaninna amuqusirana faqa narí mapukusee marira oosana faqa qini uqaqifiqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Qinee kaasau aandau raioonnara foora fiqu fiqu iqa mariana qambaanai maridaqa. Misa nifai fannoo feefara foora faqa faaqaanara foora faqa kaaqa aaruqirausa qambaanai maridaqa. Misa nifauru fannoo aseemara foora raiqarafa faiqí ateekee marisa qambaanai maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Oo Anutu, aneenna uriqararana innaarunai uqannifiqaa. Aneenna qareenarana aiqama maqa maaqaki mariasa uqannifiqaa. ");
INSERT INTO bjr_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Qini namuqaa qini qiku ufana fufidammia. Qini daundurai rufiarafa marinara mapamidaqa. Misa qini qimaara madika indufuseeqa nariqa sia irirai nári indufuqaanaki nári kai doo aqufia. ");
INSERT INTO bjr_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Oo Anutu miqiqa maridaqa aniara irunanoo qini qimuqusa mapukinoo maridanoo. Minara qinee idi raidaqa ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Qinee findifiqa. Qinee piripuna faqa ufireena faqa arimariananoo iaqainanoo suani afu uruani. ");
INSERT INTO bjr_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Oo Yaawee qinee moomoo maqannaasa qambaanai kikiqamafi amooqianaura. Qinee moomoo fasiqa anaasee qambaanai idi raida ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Oo Yaawee ani maasara amuqusirafa firaatia innaaruna amana kai ooru maridanoo. Ani mapukusee marira oosana fannoo kudimanda mariqoo ooru maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Oo Anutu, aneenna uriqararana innaarunai uqannifiqaa. Aneenna qareenarana aiqama maqa maaqaki mariasa uqannifiqaa. ");
INSERT INTO bjr_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Innee uriqararausa andeeqasee ufa nimidee. Innee anoona ufannai faiqí amana amana kai fee andeeqannimaqaidee. ");
INSERT INTO bjr_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Innee sia miqi mariafanoo. Inni nimuqusaki innee aaqaranara indeeindee imariafanoo. Innee maa maqa maaqanaki faiqí narira oosana kai nimi mariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Aaqee mariasa maqannimaqoona kiqari kaqi runnai ubeekaqa maridaqa. Misa maqannimaqoona kiqari aaqaranaki kai fidaqa unnufa kai qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Misa aaqara oosana fannoo ukadiqara foora faiqí anaasee ukaqa nimifaqa kuqidaqa. Misa moo sakani sia ufa irimari sakani fara foora ufa sia iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","(Akaqa maqannaasa sakani rakisi mariasa ufireena fuaqaafaqa misa ninuka aqidaqa. Davidifa faiqí sia ufa irimariasa mi sakanina kikiqa ususee niqinoo maaqi qinau.) Innee faiqí sakaniara foora ufireena fuaqaifaqa sia ufa irifaranoo. Ufireena akoofasa amiqimasee fuaqaifaqa mina faqa siamma irifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Oo Anutu aaqee mariasa kaasau fainiara foora mariasa anee misa nifai rufidia. ");
INSERT INTO bjr_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Anee aaqara oosana maree mariasa nammari akooqoo qumida muqufi dadasindee mannisaa. Aanasaa mari ainainna nikunnai radamuandeemma nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Oo Anutu saina aaqee mariasa qoofi kuqufi putaa iandee iaqa. Kuqira faiqi maqasaasa sia kaaqa qarana qafaandee iaqa. ");
INSERT INTO bjr_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Faiqí kaqikaa saqari ateekaindee inoo kai kaqi Anutufa misa mandaikamma nimaqaannoo. Misa kaqi marifanoo Anutufa narí firaa arana qaranakiqari misa ufaira foora fuaqa aquannoo. ");
INSERT INTO bjr_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Misa manda oosana akiiqara Anutufa niminaqa, andeeqee mariasa mina qafamasee asasammifaranoo. Andeeqee mariasa misa fidikaki niku nammari uqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Faiqí mina qafamasee maaqi qifaranoo. Andeeqara marirana maree mariasa mi andeeqarana akiiqara nimirafa kuqaa maridanoo. Maa maqanasaa qaraasa andeeqasee rainee mari Anutufa kuqaa maridanoo, sia sia maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Oo Anutu qini namuqaauqa nisaukukinaana maraquqisaa. Aiqama qini darirari mariasasaa ititaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Manda fasiqa nisaukinaana maraquqisaa. Faiqí kuqa nári mariasa nisaukukinaana qini soodaaqammaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Oo Anutu anee qafaa. Misa kukeeqafi qini darirara qipuraidaqa. Misa kaaqa aanoo qimariasa qini darirara suqidaqa. Oo Yaawee sia qini manda oosana akiaqarau dariraridau, kaqi fifau nariqa kai dariraridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Qinee sia aaqara oosanau maree fau. Misa sia minara irirai kaqi fifau qini darirara deedaqidaqa. Oo Yaawee, misa kai kaqi qini darirara deedaqidaqa rakisidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Oo Yaawee, aiqama afeeka faqaa Anutufa findifinana qini dadaaqia. Isaraee maqannaa Anutufa anee qumuree misa manda oosana aneenna afunnai qafaa. Findifinana Anutuna ufa sia iriasa ummaara nimia. Qini ueeqee mariasara sia qimudaoo qia, kaqi ummaara nimia. ");
INSERT INTO bjr_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Misa eendifaqa fainiara foora rairai qidaqa, manda ainaina uqeerarara qini maqusamau fiqu faiqu fiqa nidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Misa nookiqari nanee fididee. Misa nifauru nimaakiri qaseema miqirafa kai maridanoo. Misa nári manda ufara maaqi qidaqa. Yafee iriannoo fee qimasaidaqa kaqi fifau qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Oo Yaawee, anee misa ufa irisee misara naanaidara qimariananoo. Anee aiqama mi manda maqannaasa ataasa ataasa qira ufa nimimariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Oo Yaawee, anee kai qini afeekaikamma qimaqasee rakisi qimaqee mariananoo. Anee Anutufa qini kukeeqara maqusara foora mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Qini Anutufa qiniara amuqusi marifa qinee unnannai anireenoo dadaaqiananoo. Mifa qini namuqaa rafaaqafu nimaqainaqa qeeqa qifunnai niqafaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Oo Yaawee maasa ititaqisee marianafa qini maqannaasa mi manda maqannaasara qaunifoora minara sia aiqama naru taikaa. Aneenna afeekannai mi manda fasiqausa narunnifaqaaqa masainaqa auiqeera foora aiqama maqa maaqakinai oonuree aniree iqa nuaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Misa nookinaa ufa faqa nifaurusaaqaraa ufa faqa aaqarafa kai maridanoo. Misa aaqara ufa faqa unna ufa faqa qimariana akiiqara mandaikiaqa. Misa nári noori uqeeree maria oosanafa ufaanara foora misa ninuka qumaraani. ");
INSERT INTO bjr_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Oo Anutu aneenna aanooqiranaki qari misa kuridi nimaqaa. Amiqimmasee kuridi taikasaa. Miqinaqa maa maqa maaqana atinni atinni mariasa minara iriseeqa oo Anutufa Isaraee maqannaasa rakisidanoo fee qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Eendifaqa namuqaa kafaa aniree fainiara foora rairai qidaqa mandainaina uqeerarara fiqu faiqu idaqa maqusamau nidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Misa nári naranara randaida oonuree aniree iqanida sia nimuaqu imarifaqa firaaqoo faaqa riqanidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Misa miqi mariafaqa qinee ani afeekara irisee idi raanaura. Oo Anutu, qinee firaa ummaaraki marunnana anee qini afeeka kukeeqara maqusa mariannanara qinee kananaana findifi ani maasara amuqusiranara idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Qinee qini Anutuna qini itita qimaqee mariannana amooqianaura. Anutufa firaaqoo qiniara aidi marifa qini afeeka kukeeqara maqusa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Oo Anutu, anee maasa minniqisaananoo. Anee maasa rafaaqafu qimaqaananoo. Anee maasa aanoo qima qimaqaananoo. Oo Yaawee, kafaa maasa iannai quandafi maasa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Anee maqa kasiananoo maqa fannoo oo raqaidanoo. Anee maqa oo raqafina kafaa mafi titaa. ");
INSERT INTO bjr_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Anee maa aukuanna maasa afeeka ummaara doo uqaqifiqaananoo. Mi ummarana manda nammariara foora nimianaqa namasaafanoo narifanoo nifuai nifuai inoo. ");
INSERT INTO bjr_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Oo Anutu maasa aniara daaquqee marisa namuqaa maasa daru qifaqaa ifaqa anee firaka uqeerainnannai sandaifanoo namuqaa duru feefa nammari araannoo, miqifaqa maasa sia kuridianaura kaqi marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Oo Yaawee maasa innaaru qirana irisee aneenna afeekannai maasa asumu maraqisaa. Miqimmaseenana ani aidi maria fasiqa anaaseesa mandainaina kinaana asumu mariaqeera maraa. ");
INSERT INTO bjr_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Anutufa narí naaquqara uiqaana maqakiqari maaqi qinau. Qinee ufoona ridaqa Seekeemma maqa maaqa rainasee qeeqa maqannaasa nimianaura. Qinee Sukoota noopundu faqa miqi kai iqa qeeqa maqannaasa rainasee nimianauree qinau. ");
INSERT INTO bjr_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Kireeata maqa maaqa faqa Mannaseena maqa maaqa faqa qinindi maridanoo fee qinau. Eefaraimma maqa maaqa qeeqa qikiiqa afisi marunna afeeka qafeefara foora maridanoo. Yuda maqa maaqa fannoo qini uriqararausara uqannifiqee mari saunu fara foora maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Qinee Anutusa Mooaba maqa maaqa mareeqee nammari difaanirara foora masee ooru dupimma nisaanaura. Qinee Eedooma maqa maaqa qiku aanaamu raipaqu quqee marunna maqa maaqafa ooreeqarafa mariannoo, miqiannanannoo qeeqaindika masaunnana kooroo ianaura. Qinee Firistia maqannaasa urinnaaqaramasee faaqa rumasee ufoona ruanaura. ");
INSERT INTO bjr_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Oo Anutu, yafee qini aana muquninaqee Eedooma maqannaasa afeeka faandaamuraki keeqafi naruanauree. ");
INSERT INTO bjr_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Oo Anutufa kuqaa fee anee maasa ameesa uquqiseenanee. Anee sia fee ooqai unnandee inana maasa rakira fasiqauqa faqa oonuree dadaqinnaree. Anee sia maasa rakira fasiqa namufaqa fidana dadaaqi mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Anee maasa dadaaqinaqa maasa nári namuqaa narua. Faiqí faiqi dadaaqirafa sia amanaikiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Anutufa maasa dadaaqinaqa rakiranaki oonuree uriqaraanaura. Mifa maasa namuqaa rafaaqafu nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Oo Anutu, qini iki raqarana iria, qini innaaru qiranara aaqoo rammatinia. ");
INSERT INTO bjr_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Qinee moo maqa maaqai nianai oonu marunanoo qini qimuqusa mandaikimarifaqa ani aaraidaqa. Anee qini mareeqee afeeka kukeeqara maqusaki quqaqisaina asumu maria. ");
INSERT INTO bjr_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Nnaree anee qini faandaamurara foora qini ititaqimaqee marianafa mariananoo. Anee qini faandaamura marianaqa namuqaa sia amana qini rafaaqafifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Qinee naaru naaru ani uriqarara naaquqara uiqaana maqaki marirara dididanoo. Ani aqoosa ameemaanaira foora mandaaqaanauree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Oo Anutu, qinee qima afeekaikira ufa ani qimamiafannanara anee irimmariananoo. Anee iriseenana ani auquara rufiee mariasa nimiraree qianna ainainna qini Dafidisa faqa qimiananoo. ");
INSERT INTO bjr_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Qinee Isaraee maqannaa karaambaiqa marunausa Anutu anee qini aukuana moomoo ootupamasainaqa qeeqa qinaiqimara qisaifaqausa nindafaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Oo Anutu anee qiniara naaruara qini qifusaa maridana Isaraee maqannaasa rakisi nimaqaannee qia. Anee aneenna amuqusirana faqa aneenna mapukusee marira oosanannoo faqa ititaqimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Miqimarinaqa qinee naaru naaru ani auquara amooqira idi raanaura. Qinee ooqai aiqama faasaana ani amianauree qimasee qima afeekaika maqaafannamau fuanaura. ");
INSERT INTO bjr_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Qinee Anutufa qini asumu maraani feera kai afeesida maridaqa. Mifa kai qini asumu marirana qimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Mifa kai qini itita qimaqaseenoo qini asumu marirana qimidanoo. Mifa qini afeeka kukeeqara maqusara foora marinara naaru naaru sia qini rakiranaki rafaaqa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Oo qini namuqaauqa, naqumma kari fee qini darida marifaree. Innee qiniara nauraa ququsa rafaurinoo fifaiqanoo marindee irafee qimariafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Innee qinee uriqararaqoo marunnana qifeeqa maqasaa aqirara ufa qimariafanoo. Inni unnufara kai nididanoo. Inni nookiqari unna qimasee Anutuna amooqira ufa qimariafanoo, inni naunduraki manda niqurara ufa kai umbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Qinee Anutuna kai mandaaqaidaqa. Qeeqa irirana minasaa kai munduqaqee maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Mifa kai qini itita qimaqaseenoo qini asumu marirana qimidanoo. Mifa kai qini afeeka kukeeqara maqusara foora marinara sia qini rakiranaki rafaaqa fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Qini asumu marirafa faqa qini uriqarara duqu faqa Anutunakiqari kai qiniki anidanoo. Mifa kai qini itita qimaqee marifa maridanoo, mifa kai qini auqaana maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Innee qini qiku qisauku aiqama kari Anutuna kai saqarikiaqa. Inneeqa aiqama ummaarara mina qimamiaqa. Maasa mifinnai oonuree kai asumu marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Aiqama faiqí faiqi fifau naidoora foora maridaqa. Nuqu faqaasa faqa ooreeqarausa faqa moodaakarirausa fifau ainainara foora maridaqa. Anee misa uqaki rumaseenana sikeerasaa dirisee qafa, siara foorammiqa maridaqa. Naidoo ummaara fannoo misa ummaara uraaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Innee sia rakirana faqa moona ainaina ummuara mararana faqa saqarikiaqa. Inni ainaina moomoo kinaqa sia irirana minasaa rusiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Moomoo kari Anutufa maaqi qifaqa iriqa. Qinee Anutusa firaa afeeka faqaasa maridaqee qinoo. ");
INSERT INTO bjr_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Kafaa moo ainaina anee Yaaweefa maasara amuqusi marianafa mariananoo. Oo Yaawee anee kuqaa aiqamausa ainainirana akiiqara feefauru amana kai rainasee nimimarianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Oo Anutu, anee qini Anutufa mariananoo. Qinee doori kandamasee aniara randaida innaaru qidaqa. Qinee aadana maqa maaqai marunanoo nammariara didiara foora aniara dididanoo. Miqikaimmasee qini maa qifaaqafa faqa aniara nammariara foora aididanoo. ");
INSERT INTO bjr_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ani naaquqara uiqaana maqaki ani qafaanaura, ani afeeka faqa ani qareenarana faqa qafaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Oo Anutu ani amuqusirafa maa maqee marunna marirana uriaaqaranoo marinara qinee ani auqu uqeeraanaura. ");
INSERT INTO bjr_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Qinee maaqoo kaqi marianna kamu aniara dufi dufi qianaura. Qinee qeeqa qisauku uqeeraseeqa ani innaaru qima amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Qeeqa qimuqusannai amiqira naranara foora namasaananoo qini qimuaqu inaqa qinee asasira idinnai ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Anee ooqaindari qini dadaaqi marianafa mariannanara qinee qeeqa faiqara qaarisaa maridaqa aniara iridaqa. Eendamuqusai faiqarara andee qumooridaqa aniara kai iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Qinee ani aqoosa ameemaanai maridaqa aniara asasira idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Qinee anisaa atooqaidaqa. Ani asauku uqannai asauku fannoo qini asumu maraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Qini kuqa darirara imariasa aiqama kuqufi kuqirausa maria maqa maaqaki fifaranoo. Misa maqa ameemaanai kuqirausa faqa marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Misa duru feefa ooki keeqaifanoo kaasau aandau misa nipata neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Qinee Isaraee maqannaasa karaambaiqa rakiranaki uriqararana qimimarinara. Anutunara asasianaura. Aiqama Anutuna auqusaa kuqaa qima afeekaiki mariasa mina amooqifaranoo. Unna ufa qimariasa noo Anutufa ititannimaqasainaqa sia ufa qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Oo Anutu, qinee ummaaraki maridaqa, qini innaaru qirana iria. Qini namuqaa dariranara rufiaidaqa, anee qini marirana dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Manda oosana maree mariasa tipundaari mariasakinaana qini mareeqee kukeeqaqisaa. Aaqee mariasa faaqa fuisee qida qini darirari marianasaa faqa ititaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Mi fasiqausa nári nifauru nimaakiri faaqaanara foora aaruqu maqaafanoo maridanoo. Misa ufa fannoo feefa dindasaa quqasee rakisiandee qini rakisi qimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Miqi maria manda fasiqausa qumee ooqa andeeqara fasiqa naridaqa. Misa rufiarana siaisa kaqi tautumaki naridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Misa nariqa suqufifaqa manda oosanara narí pooduqee narí pooduqee idaqa. Misa kukeeqara ufaana fufira oosanara amiqimmasee iriqaraasammasee maaqi qidaqa, sia moo fannoo maasa ufaana qafaannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Misa manda ainaina auqarara tipundaaridaqa. Misa nariqa tipundaariranara andeeqanoo maridanoo fee qidaqa. Faiqí faiqi kukeeqara irirafa farumara foora meemai uqnaurinoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Anutufa mi manda faiqausa narí feefannai naruannoo. Dauni misa naru quqasaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Misa manda ufa akiiqara kuridi nimaqaannoo. Aiqamausa misa mi narirana niqafamasee boo firaa ainaina kambiqee maqi qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Misa aiqamausa misa narirana qafamaseeqa rufieeqa misa Anutuna ainainiranara iridaqa kooroommasee mina ainainiranara qimannimifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Andeeqarausa Yaaweefa auqoo ainainara irisee asasifaranoo. Misa Yaaweenaki amiqimmasee marirana paqurifaranoo. Aiqama andeeqarausa mina amooqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Oo Anutu, anee maasa innaaru irimariannanara maasa Sioona maqusaki andeeqasee oonuree ani amooqidaqa ani amianauree qima afeekaika maqaafanna ainainauqa ani amianaura. ");
INSERT INTO bjr_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Faiqí anaasee aiqama maqa maaqaindari nári manda oosanara iriseeqa anee Anutufa iannannai ani faranoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Maasa mandainaina fannoo maasa dukunimma saifana anee Anutufa mina taikaqisaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Anutu anee rusandeesamummasee maraqaanausa ani asasiranaki maridaqa. Anee aneenna naaquqara maaqaki mariaqeera nifiqa quqasainausa asasiaqa. Maasa mi amaana maqanaki marunanoo ani amiqi amiqirafa maasaki qumbiqanoo marifaqa maridaqa. Ani naaquqara amaana maqaki marunanoo ani amiqi amiqirafa minaki marifa maasaki qumbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Oo Anutu, anee maasa asumu qimi marianafa mariananoo. Anee maasa aneenna naaquqara andeeqara ainaina auqee mariannanannai maasa qimaqimi marianafa mariananoo. Aiqama maqannaasa nianai atinni atinni mariasa faqa ooruku nammari dinni afainni mariasa faqa ani kai saqarikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Anee aaqanauqa aneenna afeekannai auqu eeqee nári maqee mariaqoo quqanau. Miqunnanannoo aneenna afeeka uqannifiqanau. ");
INSERT INTO bjr_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ani afeeka fannoo ooruku nammari kasinoo amakaurirana faqa rafaaqafusaifanoo mina kasirana faqa ufaqirana faqa daimafinoo. Faiqí anaasee tutuqirana faqa taikannimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Aiqama maqannaasa anee auqee marianna ainainna qafaafanoo naaquqaidanoo. Suani ururee marinnai mariasa faqa suani keeqee marinnai mariasa faqa aiqama ainaina auqee marianna ainainna qafamasee mi aiqama maqannaasa naaquqaifaqa faaqa rumasee aniara asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Oo Anutu anee maa maqa maaqana rakisidana uqeena uqeenianifeera aaku firaana teeqiananoo. Anee miqiannanannai maa maqana ainookamma saananoo. Anutu ani nammariuqa qumbiqanoo maridanoo. Mi nammarifa maqa maaqa amiqimma saifanoo amiqira narana faíqí anaasee nimidanoo. Anee miqimmasee auqinau. ");
INSERT INTO bjr_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Oo Anutu, anee qiananoo aaku firaafa rinoo maqa uqeena uqeena masaifanoo afuqaki narana kambiqaidanoo. Anee aaku dunoonnannai maqa uqeena saananoo narana kambiqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ani amiqirafa narana rairaamma qimaqee marifa maridanoo. Anee finnatinai miqikai inoo narana rairaa iannoo. ");
INSERT INTO bjr_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Andandaki aiqamatinai burimakau faqa sipsipa faqa umbiaqa maridaqa. Aaqanauqa faqa kaqikaa amuaqu namuqa faqa aaku rifaqa firaaqoo asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Firaa afaasasaa burimakau sipsipa moomoo qumbiqaidanoo. Noopunduki faqa sakumma ainaina moomoo kambiqeenoo aiqama noopundu titaidanoo. Aaku rifanoo aiqama ainaina asasidaqa idi raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Aiqama maqa maaqaki mariasa asasidaqa firaaqoo Anutunara faaqarumasee amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Idi raidaqa mina auqu qareenaranara kooroo iaqa. Qareenara amooqirana mina amiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Innee Anutuna maaqi qimasee qimamiaqa. Anee auqu quqoonna ainainafa kaaqa naaquqarafa maridanoo. Ani namuqaauqa ani uriqarara afeeka qafamasee aniara firaaqoo rufieeqa ani oorinni niqoori saunu araidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Aiqama maa maqa maaqanasaa qaraasa ani amooqidaqa. Misa ani amooqira idi raidaqa ani auqu uqeeraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Innee aiqamausa aniree Anutufa auqeeu ainaina qafaaqa. Mifa naaquqara ainaina faiqí anaasee qambaanai auqanau. ");
INSERT INTO bjr_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Mifa ooruku nammariara qufanoo aadanusufufaqa maasa qikeeku qikaaku maqamau aandanasaa funara Anutunara asasiqau. ");
INSERT INTO bjr_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Anutufa naaru naaru narí afeekannai aiqama maqannaasa rakisinnimaqaidanoo. Mina afu fannoo aiqama maqannaasa auqee maria ainainna niuqidanoo. Ufa rukiee mariasa sia Anutuna aana itita amaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Innee aiqama maqannaasa maasa Anutuna amooqiaqa. Innee mina amooqirana firaaqoo uqeeraifaqa nianaindari faiqí anaasee iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Mifa maasa marirana afeedammaqisaifaqa kaqi maridaqa. Mifa maasa mandainainaki aqufuanoora itita qimaqaifaqa sia aqufidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Oo Anutu, anee maasa qimanammasee qafaananoo. Siruaa tasirisiri masee apaapu maraquandee iananoo. ");
INSERT INTO bjr_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Oo Anutu, anee maasa mareeqee ufaanaki aruqisasee firaa ummaara tia maasa qitaufakaaqa daaku qimaqaananoo. ");
INSERT INTO bjr_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Anee namuqaara qianaqa misa nikunnai maasa qikiiqa radamia. Maasa ida qambaanaira foora faqa nammari aufi marinakiara foora faqa oosana oosana ummaaraki fimariafanana anee maasa mareeqee amiqiraqoo quqaqisanau. ");
INSERT INTO bjr_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Qinee ummaaraki maridaqa ani Anutuna oosana oosana qima afeekaikira ufa qimamiqiafana. Doo maqee mi qima afeekaikira ufana qimamiafannandee ianaura. Doo maqee qinee qima afeekaikiafanna ufanara qianaura. Qinee aandau tatufirana mara maree ani amaana maqaki minisee suqa amianaura. ");
INSERT INTO bjr_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Qinee sipsipa tatufirana suqamianaura. Qinee burimmakau akoona faqa mimmi faqa tatufirana suqa amianaura. Miqiananoo muna fannoo innaarunai ani aikiambu iannoo. ");
INSERT INTO bjr_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Innee Anutunara qeerairi mariasa mai aniraifaqa qini dadaaqinara qimannimia. ");
INSERT INTO bjr_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Qeeqa dookiqari dadaaqianifeera aareeqa, idinnai mina amooqiqa. ");
INSERT INTO bjr_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Qinee mandainainara fifau ainainee qimasee kaqi auqaunanoo Anutufa sia qini innaaru qirana iriqini. ");
INSERT INTO bjr_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Kuqaa Anutufa qini ufa irinoo, qini innaaru qirana faqa irinoo. ");
INSERT INTO bjr_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Anutufa sia qini innaaru qirana minniseenoo. Sia narí aiqama kari amuqusiranara qao qinoo. Minara mina auqu uqeerasee mina amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Anutu anee maasara qimudaoo qimasee amiqi amiqimmaqisaa. Aneenna oori afiri kaaqa qarana maasiannai ubeekamasee dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Miqinaqa ani oosana aiqama maqa maaqakinaasa iriaqa. Aiqama maqannaasa ani asumu mariranara faqa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Oo Anutu aiqama faiqí anaasee ani amooqiaqa. Aiqama faiqí anaasee ani amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Oo Anutu, anee faiqí anaasee aiqama amana amana kai andeeqasee rakisi mariannana faqa amiqimmasee naamua qimasee nifiqee fimariannanara faqa aiqama maqannaasa asasammasee idi raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Oo Anutu faiqí anaasee ani amooqiaqa. Aiqama faiqí anaasee ani auqu uqeeraaqa. ");
INSERT INTO bjr_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Miqifanoo maqakiqari aiqama narana kambiqanoo. Kambiqainanoo Anutufa maasa Anutufa amiqi amiqimma qimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Anutufa maasa amiqi amiqimma qimaqanau. Aiqama maa maqanasaaqaraa fasiqa anaasee minara uriqarara fee qimasee qeerairiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Anutufa findifinoo narí namuqaauqa mara furufaramma saifaqa daraania. Anutunara fidiaqaa imariasa mina oorisaaqari nisaurusee quqasee sandaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Aneenna namuqaauqa ufai idamuna fuaqa aqindeemma saina fifuaqa. Mandainaina maree mariasa ainoo ainaina idaki quqasaafanoora foora iqa Anutu ani afusaaqari tasirisirimma taikafuaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Andeeqee mariasa asasidaqa ani Anutuna afusaa nasuriaqa. Misa faaqa rumasee asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Innee Anutunara idi raida mina auqu amooqirana amiaqa. Oonnamusaa ooqumarifi nimari Anutuna aana andeeqaa. Mina auqu Yaaweefa maridanoo. Mina afusaa asasiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Anutufa narí naaquqara amaana maqaki marifa fiaiqi faiqi rakisi nimaqaidanoo, adeedaana aanaaseeuqa faqa ummaaraki itita nimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Anutufa náriaraa mariasa mareeqee moo fasiqa anaasee nári faiqi kiaqeera nimidanoo. Mifa rumbaranaki mariasa idukusee nifieeqee amiqiranaki quqannisaidanoo. Anutuna ufa rukiee mariasa sia miqidaqa, misa manda maqa maaqaki marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Oo Anutu, anee ooqai Isaraee maqannaa aadana maqa maaqaki nifiqee finau. ");
INSERT INTO bjr_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Sinai aaqanasaa marunna Anutufa, Isaraee maqannaa Anutufa, anee ooqai Isaraee maqannaasa nifiqee funanoo maqa kasinoo aaku nammariara foora adianau. ");
INSERT INTO bjr_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Oo Anutu anee qunanoo aaku firaafa rufanoo ani maqa Isaraee maqa maaqa mandaikinoo marufa amiqinau. ");
INSERT INTO bjr_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Ani maqannaasa mi maqa maaqanaki oonu marufaqa akaqausa kudi marufana Anutu anee afaaridana misa narana niminau. ");
INSERT INTO bjr_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Yaaweefa faiqí anaasee naamua qufaqa aanaaseeuqa mi ufana mara maree aiqama maaqi qimasee qimannimiqau. ");
INSERT INTO bjr_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Kannaa maqannaa karaambaiqauqa faqa sundiauqa faqa anirandee sandama qaraasidammiaafoo qiqau. Miqi qufaqa Isaraee maqannaa aanaaseeuqa oonu misa rakiranaki maraqoo ainainausa marasee rainaqau. ");
INSERT INTO bjr_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Mi anaaseesa siruaannnai faqa koorannai faqa nifaaqa auqusoofanoo amiqira ufiniara foora inoo marinau. Misa nifaaqa fannoo siruaara foora daroo daraa ufanoo misa niqoosara foora koora fannoo kaaqa qee marinau. Miqi marufaqa akaqausa nanaree kaqi nariqa sipsipasaa rakisi mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Mi rakiranaki aiqama afeeka faqaa Anutufa karaambaiqauqa Saramoona aaqanasaa naru nindaqaaqa ufaqa fifainufanoo firaa oonnamuara misaqa aiqamai itita aqufinau. ");
INSERT INTO bjr_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Basana aaqana kaaqa uriqarara aaqana maridanoo. Miqoo moomoo kaqikaa aaqanauqa mina aaqa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Innee Basana aaqanasaa maria aaqanausa nanaree innee Sioona Anutufa mari aaqannara fifau ainainee qidee. Yaaweefa narí kai mi aaqannana utaaqamaseenoo naaruara mi aaqannasaa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Anutufa narí sundiauqa moomoo tauseenna afeeka rakira karauqasaa ooqufaqee marusa faqa Sinai aaqanaindari qumuree Sioona aaqanasaa narí uiqaana maaqaki keeqanau. ");
INSERT INTO bjr_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Anutufa Sioona aaqanasaa ooru fidanoo rumbarausa aana muqunufaqa ooru fiqau. Mifa miqoo ooru marufaqa faiqí anaasee akaqa ainaina Yaaweena mini amiqau. Yaaweena ufa ooqai rukieeusa misa faqa akaqa ainaina amiqau. Mifa miqoo mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Yaaweena amooqimamaqaa. Maasa Anutufa maasa asumu maree marifa marina amooqiaqa. Mifa aiqama kari maasa ummaara dadaaqi marifa marinara mina amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Maasa Anutufa asumu marirana qimimari Anutufa maridanoo. Yaaweefa maasa kuqiranakinaana asumu maree mari Karaambaiqafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Anutufa narí namuqaauqa nikiiqa kuqaa uqanna radandamumma saannoo. Nári aaqara oosanaki afeekaikammandee fimariasa faqa radandamumma saannoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Yaaweefa maaqi qinau, inni namuqaa Basana maqa maaqaki mariana nifiqee anianaura. Ooruku nammari farumakiara foora mariana oonu nifiqee anianaura. ");
INSERT INTO bjr_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Innee inneeqa namuqaa narusaifaqa inni maqannaasa misa fidikaki niku reefaranoo. Fainiuqa nári nidiranasaa misa fidika neefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Oo Anutu qini karaambaiqa. Anee moomoo fasiqa anaasee aana muqunimma maree aneenna amaana maqaki keeqararee qimarianaqa doo aiqamausa misa nindafaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Idi ree mariasa indaaru fimarifaqa piripunna ari mariasa inaaqianna fuafaqa qambaana temberinna ari maria manaaqausa fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Innee Isaraee maqannaa fasiqa anaasee suqiqa marianakiqari Anutuna amooqiaqa. Innee Yakooboona saaqari kambiqarausa innee Anutuna amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Isaraee maqannaasa Beensamina akeeku akaaku qoodaa marusa indaaru fimarufaqa Yudana akeeku akaaku marusakiqari uriqararausa moomoosa faqa Seeburuna akeeku akaaku kiqari faiqí uriqararausa faqa Napatarina akeeku akaaku kiqari faiqí uriqararausa faqa misa ninaaqianna amaana maqai suqirannai ooru fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Oo Anutu anee aneenna afeeka maasa uqaqifiqaa. Oo Anutu, anee ooqai aneenna afeeka uqannifiqoonnandee kai inana maqee faqa uqannindiqaa. ");
INSERT INTO bjr_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Anee aneenna uriqarara amaana maqaki Yeerusaree maqusai mariannanara, moomoo maqanaa karaambaiqauqa kaqi nimimaria ainainnaa maree mini ani amifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Firaa doona aqmauraqmauri marinaki mari kaasau aandaufa Isipa maqannaa karaambaiqa Faraoofa maasa darirarinana Anutu anee minara aanoo qimasee qaoo qia. Faraoona dadaaqimaria uriqarara fasiqausa aanoo qimaria burimmakau akoonausara foora kaiqeesa qambaana oonuree narirara ifana anee misara faqa aanoo qimasee qaoo qia. Anee misa mara muqufisainaqa misa siruaa mara maree mini ani amiaqa. Aiqama rakiranara rimaria maqannaasa anee misa naru nindaqaaqa masainaqa daraaniaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Isipa maqanaa uriqararausa Anutufinnai ubeekarara anifaranoo, Eetoopia maqannaasa nisauku uqeerasee Anutunara innaaru qifaranoo ");
INSERT INTO bjr_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Oo innee maa maqanasaa mariasa innee Anutuna idi ramamaqaaqa. Yaaweena amooqira idi raaqa. ");
INSERT INTO bjr_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Anutufa ooqaindari mari innaarunasaa nimari Anutunara amooqira idi ramamaqaaqa. Mi Anutuna ufa firaafa innaarunai qiara foora qimarifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Innee Anutuna afeekara koorooiaqa. Mina amiqira uriqararafa Isaraee maqannaasa rafaaqafu nimaqaidanoo. Mina afeeka innaarunai maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Isaraee maqannaasa Anutufa narí amaana maaqaki marifa kaaqa naaquqarafa marinara rufiaaqa. Mifa uriqarara afeeka faqa eeraarirana faqa narí faiqí anaasee nimidanoo. Anutuna amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Oo Anutu anee uqeeraqisaa. Nammariara foora qini ummaara fannoo rafaaqafinoo qinukaki ururaifaqa kaqi kaaqoo kuquanaura. ");
INSERT INTO bjr_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Qinee firaa doona poopoo qimarinakiara foora qiku utusaqa maridaqa sia afeeka maqasaa qiku raidaqa. Qinee nammari difukunaki aniraunanoo nammari aufirafa qini dukuniaqaa idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Qinee Anutufa dadaaqianifeera aaraida afeesida marunanoo qini daunda aadana usufifanoo qini ufa akieenoo. Aniara rakisida marida qifuanda rakee iqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Qiniara fidiaqaa imariasa qini qikiiqa asausi faqa arusee fiqaramasee maridaqa. Qini kuqa darirari mariasa fifau qini oosana siainaki namuqaakamma qimaqaidaqa. Misa qiniara moo ainaina fifau unnaqimasee ummuariaanoo qimasee mina akiiqara nimiannee qimasee sandanainai qiafaqa rufiaseeqa fifau qeeqa ainaina nimiqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Oo Anutu qini furufarira oosanara anee irimmariananoo, qini aaqarafa sia ani afusaa kukeeqanoo maridanoo, akooqoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Oo Yaawee, anee qini dadaaqinaqa sia moo aaqaranaki aqufuanaqa ani ufamau fimariasa nisauruaqa. Oo uriqarara Yaawee aiqama afeeka faqaafa anee qini dadaaqinaqa aniara innaaru qimariasara sia manda ufa qimannimaqaaqa. Oo Isaraee maqanaasa Anutufa miqimma qimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Oo Anutu, ani auqu raunnanara aasaandaana ufa qimi mariafaqa qini qisaurirafa qini rafaaqafuqaifaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Qinee ani auqu raunnanara qeeqa qikaqaafasaa nifusaa aanaamuruara foora maridaqa. Qeeqa qinoona faiqi namu nifusaa moo aanaamuruara foora maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Qinee ani Anutuna amaana maqara didirafa firaaqoo idara foora qaidanoo. Ani Anutuna aquraree maria aqurararafa qinisaa faqa aqufinoo marifaqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Qinee qeeqa mara maree muqusee narana auramasee marunaqa faiqí anaasee qini qiqafamasee aasaandaana ufa qimaqimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Qinee manda qammunna soofaara qammunnara foora afisuqaunaqa faiqí anaasee qiqafamaseeqa qiniara ataasa ataasa qimasee naanaidara qima qimaqaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Aatata oonuree aniree idaqa qini qiqafee mandufa qidaqa. Afeeka nammari namasee furufari mariasa faqa qiqafeeqa manda idi qiniara raidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Qinee sia misa ufa irianaura aniara kai innaaru qianaura. Oo Yaawee, aneenna qinna kari qini innaaru akiiqara kafaa qiqa qimaqimia. Anee qima afeekaikammasee qini asumu maraanauree qunnanara irisee miqia. Anee sia unna qimarianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Doona poopoo qimarinakiara foora utusaqa maridaqa Oo Anutufa anee qini qumaree tatu qisainaqa sia minaki ooqu keeqafi minaki kuqua. Qini namuqaa nisaukukinaana maraquqisaa. Faruma firaanaki uqnauriranakiara foora aqufiqa marunnana umbaqi afainni quqaqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Oo Anutu anee qinanooo sia nammari qini dukuniani. Faruma uqnauriranaki sia qinee aqufiqa ukuqnaanaura. Sia qinee madikakiara foora aqufuana maqa fannoo mafi titaqisaani. ");
INSERT INTO bjr_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Oo Yaawee, anee aneenna amiqiranakiqari qini innaaru iria. Anee aneena firaa nifauaranakiqari qinee unnannai oori ubeekaa. ");
INSERT INTO bjr_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Oo Anutu, qinee ani ainainira faiqi marunnanara sia anee oori rafusu kaqinni aqua. Qinee firaa ummaaraki marunnanara dauni dauni qini irara ufa anoona qima qimia. ");
INSERT INTO bjr_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Oo Anutu, anee qini daaqa aniree qini namuqaa nisaukukinaana mara asumu quqaqisaa. Qini namuqaauqa darirarifana qini mareeqee kaqinni qisaa. ");
INSERT INTO bjr_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Oo Anutu, qini namuqaauqa anee niqafee mariana qiniara aasaandaana qirana faqa mandaikamma qimaqarana faqa qisaurirana faqa qimi mariafana anee iri mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Qini aasaandaana ufa qimiafa qini qimuqusa raquruqiminoo marifaqa qini qifaaqaki aiqama ummooqukinoo marifanoo qini qifaaqa dadaaqirafa sia maridanoo. Qinee nimuqusiranara randauna sia moo fannoo qiniara amuqusirafa maridanoo. Qinee qimudao qira ufa qima qimaqarausara randauna sia uqanna maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Qini daararaifaqa misa qini naranaki qumee adudu fooqaana minaki quqasee qimiafaqa nauna suka darifaqa minniseeqa. Qini nammariara didifaqa misa sukaqee mari nammarina qimiafaqa namasee qafeeqa minniseeqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Mi manda oosanna qimimariasa nariqa narana difaani fannoo nári quandaki kuridi nimaqaani. Misa nariqa mi firaa naaquqara oomaqafa nikuqamasaina aqufuaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Misa nifu asukunaarusaina mikiqmakiqa nuaqa. Misa nitaufaka faqa rambaqasaina naaruara miqiqa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Oo Anutu, aneenna aranaqarana nammariara foora misasaa adiasaa. Ani aanooqirafa idara foora misa qama taikaani. ");
INSERT INTO bjr_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Misa maqa maaqa naakundu kai saaeemasaa. Sia moodaafa faqa nariqa uiqaana maaqaki mariaqa, naakundu kai mariani. ");
INSERT INTO bjr_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Anee Yaaweefa ani ufa rukiee mariana akiiqara anee maasa kaakadi darusaanausa namuqaa anireeqa aaqaidaqa misa kaaqmukaidaqa. Kaaqmukamaseeqa misa nári maqusai oonureeqa anee Yaaweefa maasa daruannanara aupuraunaqa ataasataasa qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Oo Yaawee anee misa aaqarana akiiqara sia qaunua amiqimmasee iria. Misa ani Anutuna asumu marirana sia uqanna kaqikaana faqa maraaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Oo Yaawee ani naaru marira papiqaki misa nuqu marina rukaa. Aaqee mariasa nuqu sia andeeqee mariasa nuqu namu faqa moodaanaki akara rua. ");
INSERT INTO bjr_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Qinee Dafidisa firaa didafirana faqa ummaara faqa maraidaqa. Oo Anutu, anee qini uqeerasee asumu marirana qimia. ");
INSERT INTO bjr_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Qinee dufi dufi qira idinnai mina auqu qareenaranara koorooianaura. ");
INSERT INTO bjr_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Mina mi dufi dufi qirafa burimakau sipsipannoo tatufirana suqami mariana uriaaqaranoo maridanoo. Muduka burimakau faqa sipsipa faqa aiku namufaqa aanai namu faqa tatufirana suqarana faqa uriaaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Kudi fasiqauqa mina qafamasee asasammifaranoo. Innee Anutunara randeemariasa inni irirana afeekaikamma nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yaaweefa kudi fasiqauqa innaaru qiana iridanoo. Isaraee maqannaasa namuqaa rumbaranaki mariafanoo Yaaweefa misara sia qaunidanoo misara faqa iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Innaarunai mariasa faqa maqasaa mariasa faqa ooruku nammariki nimaria ainainausa faqa Yaaweena amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Anutufa Sioona maqusa moo auqu Yeerusaree maqusaki mariasa misa namuqaasaa ititannimaqaannoo. Yuda maqa maaqakinaa maqusauqa rapeepaa inoo marinauqa kaifaa itipiannoo. Itipammasainaqa faiqí anaasee miqoo kaifaa maridaqa aiqama maqa mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Isaraee maqannaasa Anutuna ainainira faiqiuqa, misa faiqi namu kambiqafinaqa mi maqusausa marasaifanoo maasaindi kamminoo marinaqa minaki marifaranoo. Mina auquara rimariasa faqa minaki marifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Oo Anutu, anee qini mandainainakinaana mara aquqisaa. Oo Yaawee, kai kaqi aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Qini marirana taika qimaqarara randeemariasa rafaaqafu saina nisauriranaki faqa furufariranaki faqa mariaqa. Qini ummaarara irisee asasimariasa mara quandasainaqa nisauruaqa ");
INSERT INTO bjr_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Qiniara uteeti qimariasa nariqa nisaurirana firaafa marina qafaifanoo firaaqoo naaquqaani. ");
INSERT INTO bjr_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Oo Yaawee anee iannannai ani mariasa asasidaqa nasuriaqa. Ani asumu mariranara nidimarisa, maaqi qiaqa. Yaaweefa uriqararafa maridanoo fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Qinee Dafidisa qimudaani radukirausa marunausa saraui marunna fasiqausa marunnanara oo Yaawee anee sia qiniara qaunuananoo. Anee qini asumu maree marianafa faqa qini Anutufa faqa mariannanara kai kaqi aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Oo Yaawee, anee itita qimaqaanneera anee iannannai anidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Anee andeeqarafa mariannanara qini dadaaqinana mareeqee kaqinni quqaqisaa. Aneenna aaqoo qinee iannannai rammatinimmandee irisee qini asumu maraa. ");
INSERT INTO bjr_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Oo Anutu, anee qini ooni faandaamurara foora faqa auqaanara foora faqa auquqisaina qinee minaki keeqafi asumu maria. Anee qini ititee marianna oonifa faqa qini afeeka kukeeqara maqusa faqa mariananoo. Anee qinaqa qinee amiqimmasee marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Oo qini Anutu, manda oosana maree mariasa nisauku kinaana faqa eendaandi mariasa nisauku kinaana faqa fitiqnarana qimimariasa nisauku kinaana faqa maraquqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Oo uriqarara Yaaweefa, qinee aniara kai aambeembeesida marunausa maridaqa. Kumaaraasaa qari ani kai saqarikii aafanausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Qini maqoonakiqari qinee anisaa mundiqa mariafanausa maridaqa. Qini qinoofa maqaqisooqoooqari anee kai qinisaa rakisina aniifana maqee aniraananoo, minara qinee maqee maqee ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Moomoosa qini faqa qiniki kambiqoo ainainna faqa qafamasee iriqau. Minara anee kai qini afeeka kukeeqara maqusara foora mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Aiqama faasaambaasaana qinee ani amooqidaqa ani qareenaranara koorooidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Oo Anutu, qinee asooqa qaanana sia qini maraquqisaa. Qini afeeka taikainana sia qini minniqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Qini namuqaauqa qini darirarammidaqa. Qini dariraree qimasee ufa suqidaqa tipundaaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Misa qiniara maaqi qidaqa. Anutufa mina minnisaifanoo sia moo fannoo mina dadaaqirafa maridanoo, anifaqa mina afaqaseeqa qumaraanee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Oo Anutu, sia nianasaa maria. Oo qini Anutu dauni aniree qini dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Qini darirari mariasa anee Yaaweefa misa rafaaqafu nimaqasee kuridi taikannisaa. Qini aupurarana qimirari mariasa nisauriranaki faqa aupuraranaki faqa mariaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Qini irirafa naaru naaru aniara kai aambeembeesida mariannoo. Qinee kaifaa kaifaa ani amooqima amaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Qini doo fannoo ani Anutuna andeeqarana faqa asumu mariranara faqa faasaambaasaana kooroo ianaura. Qinee mi andeeqarafa faqa asumu marirafa faqa fiqaranoo marifaqa ati kai iridaqa mina oosanara faqa ammuquara faqa sia iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Oo uriqarara Yaaweefa qinee anee amudaanai qimasee auqunna ainainausara kooroo ianaura. Qinee ani andeeqaranara kooroo ianaura. Anindiara kai kooroo ianaura ");
INSERT INTO bjr_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Oo Anutu, anee qini kumaaraasaaqari oosana arasee aneenna oosana uqaqifiqana ani mariananoo. Qinee miqooqari anee firaa ainaina auqoonnanara faiqí anaasee kaqi kai qimannimiqa fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Oo Anutu maqee qinee nauraiqi aandau aanaaqi maridaqa sia qini minniqisaa. Anee qini faqa marinaqa qinee naaru kambiqainausa faqa qimanimia. ");
INSERT INTO bjr_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Oo Anutu, ani andeeqarafa maqasaaqari innaaruna auqanoo maridanoo. Anee firaa ainaina auqunafa mariananoo. Oo Anutu yafee ani fooqaafa maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Oo Yaawee, anee oosana oosana ummaara faqa aupurarana faqa qimimariananoo. Kasooqaqee anee kaifaa qini marirana ooqai mariundeemma qiseennaranoo. Anee qini kuqa dariranasaa itita qimaqeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Anee qini firaaqoo uqeera murufi qiseennaranoo. Anae kaifaa qini amiqi amiqimma qima qeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Oo qini Anutu, ani mapukusee marira oosanara piripunna aridaqa ani amooqianaura. Oo Isaraee maqannaasa naaquqara Anutufa, qinee piripunna aridaqa ani amooqira idi raanaura. ");
INSERT INTO bjr_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Qinee piripunna arida ani amooqira idi raidaqa firaaqoo asasianaura. Anee qini mandainainakinaana kaqinni mara quqaqisaannanara asasidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Qinee faasaambaasana ani andeeqaranara qimannimianaura. Qini didafirana qimirari mariasa anee rafaaqafu nimaqasee mandaikamma nimaqaannanara irisee ani andeeqaranara qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Oo Anutu anee Isaraee maqannaa karaambaiqa aneenna amiqimmasee ufa irira oosana amia, aneenna andeeqara oosana faqa mina amia. ");
INSERT INTO bjr_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Mifa andeeqaranannai ani Anutuna faiqí anaasee ufa andeeqannisaani. Narí maqannaa nuqu siai fasiqa anaaseesa faqa amana amana kai andeeqasee ufa raina nimaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Miqi marinaqa misa maqa maaqa ainoo kinoo aiqama ainaina rairaaiani. Mi maqanasaa mariasa andeeqara oosana mareefaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Mi karaambaiqafa kudi fasiqa anaasee amana amana kai raina nimaqaani. Ainaina siaisa faqa ummaaraki marianasaa ititannimaqaani. Mifa nariara uriqararausee qimasee akaqausa rafaaqafi mariasa radamusaani. ");
INSERT INTO bjr_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Ani faiqí anaasee suani afu kaqi qeemarinaqa ani amooqiaqa. Quqoona faqa kaqi qeemarinaqa ani amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Mi karaambaiqafa aakuara foora fuka afuqaki rifanoo aiqama andanda afu amifanoo raambandaariara foora iani. Mifa aakuara foora rinoo maqa uqeenuqeeniani. ");
INSERT INTO bjr_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Mi karaambaiqafa marianinna aukuana faiqí anaasee andeeqara oosana kai maraaqa. Quqoona kaqi qeemarinanoo reemindeemirirafa kai mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Mina rakisinnimaqarafa dinni ooruku nammarinni oosanarasee dinni ooruku nammarinni amanasaa rakisinnimaqaani. Dinni ati fannoo Eeufarateesa nammarindari maqa maaqa atinni amanasaa rakisinnimaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Aadana maqa maaqaki mariasa karaambaiqa aninaqa mina oorinni kummarama fifaranoo. Mina namuqaa faqa mina qafamasee maqasaa aqufifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Sipeena maqannaa karaambaiqauqa faqa kaqikaa afuma kiaqa maria karaambaiqausa faqa amiqira ainaina mara maree Isaraee maqannaasa karaambaiqa mini amifaranoo. Seebaa faqa Sibaa maqannaa karaambaiqauqa faqa amifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Aiqama maqannaa karaambaiqauqa maasa uriqarara fee qimasee mina oorinni niqoori saunu areefaranoo. Aiqama maqannaasa mina ainainira faiqikamma fifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Mifa kudi fasiqauqa nammeera qiafanoo iriseenoo dadaaqidanoo. Kudiki mariasa faqa dadaaqirana siaisa faqa misauqa aiqama dadaaqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Mifa kudiuqa faqa ainainirana sia amanaiki marifaqa ummooquki mariasara faqa qimudaoo qimasee dadaaqi marifa mariannoo, sarau imariasa nimana faqa kuqiranakinaana maree marifa mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Mi karaambaiqafa mi kudi fasiqausa faqa ummooquki maria fasiqausa faqa kuqa narirari maria fasiqausa nisaukukinaana mara kaqinni quqannisaannoo. Mifa misara uriqarara ainainee qimasee miqidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Mi karaambaiqafa kisaaqasaa mariani. Seebaa maqannaasa nariqa koora mi karaambaiqana amiaqanani. Aiqamausa maqee maqee Anutufa mi karaambaiqana dadaaqiani feera innaaru qimamaqaaqanani. Aiqama faasaana Anutufa mina amiqimma amaqaani. ");
INSERT INTO bjr_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Mi karaambaiqafa marinna kamuqoo mi maqa maaqanaki sakuma faqa uita faqa moomoo rairaa inoo mariani, kaqikaa amuaqu namuqasaa faqa narana kai itita fuani. Mina qaqama fannoo Reebanoonna maqa maaqakinaa saqari aanna reenoo moomoo qaqama ireenoo rairaaiani. Mi maqusausa kiaqa faiqí qumbiaqa mariaqa. Mi sakummana qaqama faqa uita qaqama faqa andandara foora sia kasoo mariani. ");
INSERT INTO bjr_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Mi karaambaiqana auquara naaru naaru sia aunuaqa. Mina uriqararafa aiqama kari suani afuara foora uridaa kai mariani. Aiqama maqannaasa mi karambaiqana amiqa amiqimma amaqoonandee inana maasa faqa amiqi amiqimma qimaqaannee qimasaidaqa qifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Isaraee maqannaasa Anutufa moo auqu Yaaweefa, mina amooqimamaqaaqa. Mifa naríara maa idaaqira ainainausa auqee marifa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Mina areenara auqu naaru naaru amooqiaqa. Maa maqa maaqanakina aiqamai mina qareenarafa qumbiqanoo mariani. Kuqaa uqanna. ");
INSERT INTO bjr_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Qini Dafidisa Yeeseena amaaku marunausa doo qini innaaru qirafa taikeenoo.");
INSERT INTO bjr_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Oo kuqaa Anutufa Isaraee maqannaasa amiqi amiqi marifa maridanoo. Anukara nimuqusa faqaasa amiqi amiqimma nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Manda oosana maree mariasa aiqama ainaina amiqifaqa nári nimoo naamoo qiafaqa qinee qafaunanoo qirana qaifaqa Yaaweena minnisaaqaa unanoo Yaaweenaki mapukiqa marunafa taikaaqaammidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Miqi mariasa sia nidafirana maraidaqa. Misa nifaaqa afeeka marifaqa sia dinee teeroo maraidaqa. Amiqirausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Misa sia akaqausa naanna raidaqa, sia ummaara oosana oosana faisa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Misa noori uqeerasee ramooramaairafa misa ninukakinaa kukukakanara foora maridanoo. Faiqí narirana misa qamunnara foora nári nifaaqai afisuaqee maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Misa nimuqusa kiqari oosana oosana manda oosana kambiqaidanoo. Misa iriranaki oosana oosana manda ainainara oonu auqee ani auqee idanoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Misa akaqausara naanaidara qidaqa mandainainara ufa qidaqa. Misa nári nimoo naamoo qidaqa akaqausa uriqaramafi rakisi nimaqaanauree qimasee tipundaaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Misa innaarunai mari Anutuna manda ufa qimamaqaidaqa. Misa nári ufamau fuaqeera aanoommasee maqasaa fasiqauqa qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Minara Anutuna faiqí anaasee misiannai quandafiqa aaqaidaqa misa ufara anoonee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Mi manda oosanna maree mariasa maaqi qimasee unnaqidaqa. Anutufa maasa oosana sia iriannoo. Uriqarara Anutufa sia manda oosana paquriannoo fee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Doo qafaa. Mi manda oosanna maree mariasa oosana miqimminoo maridanoo. Misa maaqimmiqa maridaqa misa moomoo ainaina faqaasa maridaqa aiqama kari moo faqa moo faqa mara usidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Qinee misa nindafamaseeqa maaqi qimasee manda irirana qiqa. Fifau qinee andeeqaidee qidaqa. Qinee fifau aaqara oosanara qeerairi marunausee qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Oo Anutu anee faasaambaasaana qini aupurarana qimimariananoo. Aiqama kananaana kananaana ummaara kai daridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Qinee mi manda aaqara ufana qidaqau ani Anutuna faiqí anaasee naanna sia raunaiqini. ");
INSERT INTO bjr_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Qinee mi oosana oosana marirana oosanara irianeera oonu mafi irunanoo kadaapi daridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Miqiqa maridaqa ani Anutuna amaana maqaki keeqafifaqa mi manda oosanausa maree mariasa nifaaqai kambiqaaninna ainainara iriqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Oo Anutu, anee mi manda oosanna maree mariasa mareeqee farindara maqasaara foora quqeennaranoo. Anee qinaqa misa mareeqee kuridiranaki aqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Misa tautummaki mandainainaki kuridiranaki aqufidaqa. Miqi mariasa manda kuqiranaki ooqu fidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Aaqee mariasa qainammasee findifinana qaunuannandee inoo misa marirafa kai kaqi taikaanoo. Oo Yaawee aneenna mariannaqooqari findifuanaqa misa mina qafamasee miqooqari doo sia siammafia. ");
INSERT INTO bjr_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Qinee manda oosana maree mariasa moomoo qumiasanara irunanoo qini irirafa suka qaifanoo qini qimuqusa mandaikinoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Qinee kaasau aandaura foora ani afusaa irirana siaisa furufarirausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Miqiqa maridaqa ani aaqa aiqama kari marunana, anee qini qisauku uqannai qisauku qumaree qisaadaku imarianafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Anee aneenna aamuaqira ufannai qini daamua qimaseenana qini itita qisamammaree munusee kasooaqee innaarunai qifiqa quqaseenana uriqarara duqu qimisainaqa ani faqa marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Yafee moo fannoo innaarunai qini qiqoondi maridanoo fee, sia moo fannoo maridanoo, anee kai. Qinee ani Yaaweena maraafannaqooqari nannee moo maa maqa maaqanasaaqaraa ainainara didiannoo fee. Aniara didirafa aiqama minauqa uriaaqaranoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Qini irirana faqa qini qifaaqa faqa ummooquki marifanoo Anutufa qini afeeka maridanoo. Mifa qini faqa marifaqa qinee aiqama kari amanaikidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Ani nimeesa uqusee kaqinni fimariasa anee mandaikamma nimaqeennaranoo. Ani ufaki sia mapukusee kisaaqasaa mariasa anee misa aiqama kuridi nimaqeennaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Qinee sia miqidaqa, Anutuna aaqa mariranara qinee kaaqa amiqira fee qidaqa. Qinee uriqarara Yaaweena mara qeeqa afeeka kukeeqara maqusaikammiqa. Anee auqoonna ainainara aiqama kooroommasee qimannimianura. ");
INSERT INTO bjr_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Oo Anutu, anee nanaree maasa maaqi uqanna masee minniqisaidanee. Anee kisaaqasaafee aneenna faiqí aanaaseera aanooqinnaree. ");
INSERT INTO bjr_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Oo Anutu, anee ooqai Isaraee maqannaasa rusandeesamummasee maroonausara, misara amiqi mandee oonumafi iria. Anee maasa feefaurummasee aneenna maqannaasaika maqoona marianara oonumafi iria. Sioona aaqanasaa anee marunafa mariananoo, minara faqa oonumafi iria. ");
INSERT INTO bjr_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Anee mai aniree Yeerusaree maqusa rapeepaa iranauqa qafaa. Maasa namuqaauqa ani amaana maqa faqa rapeepaammaseea. ");
INSERT INTO bjr_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Namuqaauqa aniree kaasau fainiara foora faaqa ridaqa aiqama ainaina auku usidaqa. Misa ani biraka raipaqu quqasee nariqa biraka uqeera quqasee náriara uriqararausee qirana kooroo ianifeera miqiqau. ");
INSERT INTO bjr_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Namuqaa ani Anutuna amaana maqaki anireeqa nandakinaa saqari ateekeera foora ani amaana maqa ateekaateekamma quqaseea. ");
INSERT INTO bjr_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Misa saasuna qamma firaana faqa mara mareeqa ani amaana maqaki keeqafifaqa aiqama amiqira akara mari saqarisa ateekaa teekamma aquseeqa. ");
INSERT INTO bjr_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Misa ani naaquqara amaana maqa ida arasaafanoo aiqama qama taikeenoo. Misa ani Anutuna innaaru qimamaqee mariana faqa, rapeemmasaafanoo mandaika mafinoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Mi manda fasiqausa nariqa maaqi qimasee qimiriqa qiqau. Doo maasa misa amiqiuqanna masee radamusaanaura. Aiqama maqusa maqusa Anutuna amooqi maria amaana maqausa misa idarasoofanoo qama taikanau. ");
INSERT INTO bjr_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Maasa Yaaweenara daaqoo auqee mari ainainausa aiqama mandaikamma aqusaqau. Tamummaqara fasiqauqa qima qimirausa faqa sia maridaqa aiqama taikafia. Minara maasakiqari sia moo fannoo maa manda aukuanafa taikaaninnanara iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Oo Anutu, kisaaqasaa fee namuqaa aniara naanaidara qifaree. Naaru naaru namuqaa ani auquara manda ufa kai fee qimarifaree. ");
INSERT INTO bjr_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Oo Anutu, nanaree anee maasa dadaaqirara akooqaidanoo fee. Nanaree aneenna asauku raqandaammasee maridanee. ");
INSERT INTO bjr_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Oo Anutu anee maasa ooqeenna karaambaiqa mariananoo. Anee maa maqa maaqanaki maasa moomoo kari mandainainakinaana mareeqee amiqiraqoo quqaqisee marunafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Oo Anutu, anee aneenna afeekannai ooruku nammari qambaana rakeeunafa mariananoo. Ooruku nammariki mari firaa aandauna akiiqauqa anee rukaminau. ");
INSERT INTO bjr_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Anee ooruka nammarikinaa firaa aandau mina auqu Reefiatanee qimaruna mina aiqama akiiqauqa rukamuseenana aadana maqa maaqaki maru aandausa mina amaqi nimunaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Anee qunanoo maqakinaa nammari faqa nammariuqa faqa quminau. Anee aneenna afeekannai firaa nammariuqa aadanusunafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Asukuna faqa faasaana faqa auqunafa mariananoo. Suani faqa quqoona faqa anee kai quqoonafa mariananoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Oo Anutu anee maqa maaqaki aiqama oosiranauqa quqanau. Aiqaiqa dumudumu qira aukuna faqa suara aukuana faqa anee kai auqu quqasoonafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Oo Yaawee namuqaa aniara uteeti naakada qimarianara iria. Kisaaqasaa furufari mariasa aniara fifau ainaina fee qimasee ani auqu aquraraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Oo Anutu, aneenna faiqí anaasee sia minninnisainaqa fitiqnarana nimimaria namuqaasa maasa daruaqa. Aneenna faiqí anaasee namuqaa nimimaria ummaaranaki kisaaqasaa mariasara sia misara qaunua. ");
INSERT INTO bjr_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Aneenna ooqai qima afeekaikunnanara minara maqee irisee maasa dadaaqia. Maa maqa maaqanaki narari nararirafa aiqama amannaunai faqa asukuna arirannai faqa qumbiqanoo maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Oo Anutu anee ummaara ameemaanai mariasa dadaaqinaqa sia nisauriqa oofikiaqa. Kudi fasiqa anaasee faqa sarau imariasa faqa ani auqu amooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Oo Anutu, findifinana aneenna auqusaa titaa. Furufari maria fasiqausa faasaambaasaana ani oosanara uteeti naakada qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Sia anee aneenna namuqaa ani auquara fidiaqaammasee faaqa fuisee qimarianara irisee qaunua, amiqimmasee iria. Ani namuqaauqa aniara tutuqirafa kaqikai fida marinara sia qaunua, amiqimmasee iriaa. ");
INSERT INTO bjr_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Oo Anutu, maasa aniara dufi dufi qidaqa ani auqu uqeeraidaqa. Maasa anee uriqararafa mariannanara kooroommasee qimannimisee kaifaa anee naaquqara uriqarara ainaina auqoonnanara faqa aiqamausa qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Anutufa maaqi qidanoo. Qinee ufa irira faasaana utaaqamaqaunanoo maridanoo, qinee andeeqasee amana amana kai raina nimaqara oosanannoo raina nimaqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Maa maqa maaqanakinaa aiqama ainaina rufieeqa naindiri raifanoo maqa faqa kasinaqa qinee Anutusa kai mina oosana atukaramma qumaraananoo sia kaaqa mandaikiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Qinee manda oosana maree mariasa sia ramoo ramaa iaqeera qimannimidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Qinee maaqi qimasee qimannimidaqa. Innee sia inneeqa nuqu uqeeraseeqa qiniara sia fee qiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Raina nimaqara oosana fannoo sia suani oosanaindari fau sia suani keeqee marinnaindari fau sia dinni dinni ataaqeendari fau anidanoo fau. Sia moo fannoo suani dinni dinni ataaqeendari amana faiqí raina nimaqaannoo. ");
INSERT INTO bjr_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Anutufa kai faiqí rainee marifa maridanoo. Mifa kai moo mara maqasaa muqufi quqaidanoo, moo uqeerasaifanoo uriqaraidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yaaweefa narí asaukuki narí aanooqira nammari taqu uaqee idanoo. Mi taqufa afeeka wainna mina aanooqirafa qumbiqanoo marina uaqee idanoo. Mifa mi nammarina adiasaifaqa aiqama manda oosana maree mariasa namaseeqa mandainainaki maridaqa. Misa aiqama nama taikaidaqa, sia atiti taquki kaqi mariannoo. ");
INSERT INTO bjr_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Qinee Yakooboona Anutunara naaruara naaruara koorooiqa fuanaura. Qinee Yakooboona Anutunara idi raidaqa amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Mifa manda oosana maree mariasa afeeka aiqama rauda nimaqaannoo. Andeeqara oosana maree mariasa afeeka moo faqa moo faqa nimiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Yuda maqannaasa Anutuna auquara iridaqa, Isaraee maqa maaqakina mariasa mina auqu uqeeraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Anutuna uiqaana maqa Yeerusaree maqusaki maridanoo. Mifa Sioona aaqanasaa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Miqoo Yeerusaree maqusaki Anutufa namuqaa duru feefa saqari raudaandamma aqinau. Mifa saqari faqa saamu faqa oosana oosana rakira ainaina faqa aiqama itairaatairamma aqinau. ");
INSERT INTO bjr_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Oo Anutu, anee firaaqoo qareenarafa mariananoo. Anee aaqanasaa aneenna namuqaa rafaaqafuseenana aneenna uriqarara rupannoo irana namu faqa oorurandee qumuananoo. ");
INSERT INTO bjr_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Oo Anutu, anee ufa qunaqa sundiauqa nimudaanai qimarusa doo kuqufufaqa akaqausa misa aiqama ainaina raipaqu maraqau. Misa aiqama doo saara faiqaidaqa sia kafaa findi fifara. Misa aiqamausa rakira afeeka faqa akoofasaikirafa faqa sia nariqa dadaaqufaqa kuqiqau. ");
INSERT INTO bjr_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Oo Yakooboona Anutu, anee aanoo qianaqa rakira qoosauqa faqa qoosasaa ooqu marifi nimariasa faqa rakira afeeka taikafifaqa maqasaa aqufi kuqiqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Oo Anutu, aiqamausa aniara rufiee mariafa mariananoo. Anee aanooqinaqa sia amana moo fannoo ani afusaa kikiqiannoo. ");
INSERT INTO bjr_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Oo Yaawee, anee innaarunaindari andeeqa nimaqara ufa qunaqa maqasaa fasiqauqa rufiasee ufa sia qirai madoodoonnama fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Akaqausa uriqararanannai rafaaqafu nimaqaafaqa aiqama maa maqanasaa anee misa dadaaqiraree qimasee findifi andeeqara ufa qunaqa aiqama irisee daimmafiqau. ");
INSERT INTO bjr_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Faiqí faiqi aanoo qirafa quandaki ani Yaaweena amooqirana moo faqa moo faqa amidanoo. Akaqausa mi rakiranaki sia kuqinausa ani ufa suqiranaki ani amooqifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Innee inneeqa Anutuna Yaaweena amiraree qimasee qima afeekaika maqaa ainaina sia minnisaa, kuqaa mina amia. Adeedi maria anaamurusa innee faqa aqoondikira ainaina mina amiaqa. Anutufa qifaqa aiqama faiqí anaasee minara rufiaidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Mifa nári nuqu uqeeree maria uriqararausa mara muqufi rafaaqafidanoo. Mifa maa maqanasaa maria uriqarara karaambaiqausa naindiri rarana nimidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Qinee Anutunara dadaaqiannee qimasee faaqa riqa. Qinee faaqa rimarunanoo mifa iridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Qinee ummaaraki maridaqa Yaaweenara innaaru qidaqa. Eendaki kisaaqasaa qisauku uqeerasee innaaru qidaqa, sia daundura asooarana mareeqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Qinee Anutunara iridaqa aiaaee qidaqa. Qinee minara oonu mafi irunanoo qini daundura ummaara reenoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Eendaki Anutufa sia qini faiqarana qimifaqa qinee oonu mafi irunanoo ummaararaifaqa sia qini ufa qirafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Qinee ooqai mariaafannanara iridaqa, mi aukuanna amiqimmasee mariaafannanara oonu mafi iridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Eendaki qinee iriqaraasida maridaqa. Qinee maaqi qimasee oonu mafi iriranakiqari qeeqa iraidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Anutufa naaruaree maasa minniqisaannoo fee. Sia fee kafaa naaruara mifa maasara aidiannoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Kuqaa fee maasara aidirafa taikeenoo fee. Mina maasara qima afeekaikirafa doo fee taikeenoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Anutufa narí nifauaranara doo fee qaunuseenoo fee. Mina aanoo qirafee mina maasara amuqusirana amaaqa maqanoo maridanoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Qinee mina iriseeqa maaqi qimiriqa. Maa ainainafa qini daundura ummaara qimidanoo, Yaaweena afeeka doo taikanoo mariifoo qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Anee firaa ainainauqa auqoonnanara qinee oonu mafi irianaura. Qinee mifa faiqí sia amana auqaaqaa ira ainaina auqoonara irianauree qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Oo Anutu, qinee anee aiqama ainaina auqoonnanara indee indee ianauranoo. Anee amudaanai qimasee auqoonnanara qinee oonumafi irianaura. ");
INSERT INTO bjr_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Oo Anutu, ani oosana fannoo kaaqa naaquqarafa andeeqarafa maridanoo. Unna anutusa sia maasa uriqarara Anutufara foora uriqaraqa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Oo Anutu, anee faiqí sia amana auqaaqaa ira ainaina auqunafa mariananoo. Anee aneenna afeeka aiqama maqannaasaki uqeera akooqoo kooroommasaanaqa qafeea. ");
INSERT INTO bjr_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Aneenna afeekannai aneenna aiku asauku ummaarakinaana maraananoo. Anee Yakooboosa Yooseefaasa nikeeku nikaaku maraananoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Oo Anutu, nammari fannoo ani qafamaseenoo rufiaseenoo, rakeeinoo. Ooruku nammari faruma meemai ooqu marifa faqa ani qafamasee aindirireenoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Oonnamu fannoo ani Anutunara rufiasee maqasaa aaku nammariara foora adianau. Innaarunai qirafa firaaqoo darara qufanoo aakuasaa fannoo idauruanda kai qifuki munu raqee mini raqee inoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Ufai namufaqa aaku namu faqa ifanoo ani Anutuna innaarunai qirafa minaki kambiqaifaqa iriqa. Ani aakuasaa fannoo aiqama maqa maaqai kaaqa qamannimaqeenoo, maqa fannoo aindiri raifanoo kasinoo. ");
INSERT INTO bjr_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Anutu ani aana firaa nammari ameemaanai maridanoo. Ani aana firaa nammari ameemaanai marifana mi aatata fuanaqa sia ani aiku amaaqa qafeeqa. ");
INSERT INTO bjr_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Mooseesa Aaroonasa rakisiraqanda maridaqa ani Anutuna faiqí anaasee sipsipasaa rakisirausara foora iqa nifiqee fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Oo qini maqannaasa, innee amiqimmasee qini ufa iriaqa. Amiqimmasee naaqoo quqasee qini ufa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Qinee quandara ufannai inni qimannimianaura. Qinee ooqeennaasa ufa oonukeeqee anikeeqee qirana qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Maasa ooqai iriafanna ufana maasa qikausa qimaqimu ufana qimannimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Yaaweefa amiqira ainaina auqoonara faqa mina afeeka faqa mina naaquqara ainaina auqoona faqa maasa faiqi namu naaru kambiqainausa faqa qimannimianaura sia kukeeqaanaura. ");
INSERT INTO bjr_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Yaaweefa narí sanda ufa narí faiqí anaasee Isaraee maqannaasa nimisee, Yakooboona aiku asauku narí aauqira ufa niminau. Miqimmaseenoo maasa qikeeku qikaaku afeekaikammaseenoo qimanniminoo qinau. Innee inneeqa faiqi namu sanda ufa qimannimiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Innee inneeqa faiqi namu qimannimifaqa misa inaaqiana kambiqainausa quandafi qimannimiaqa, kafaa misa miqi kai iqa nári ninaaqianna kambiqainausa quandafi qimannimifaqa, misa aiqamausa qini sanda ufa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Miqinnanannai nári irirana Anutunasaa kai mundifaranoo, misa Anutufa auquqoo ainainnara sia qaunuaqeera mina sanda ufa kai afaqaaqeera. ");
INSERT INTO bjr_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Miqidaqa sia nári nikausa naanna raaqeera. Misa nikausa ufa rukiasee ramoo ramaa imarusa mariqau. Sia misa nári irirana Anutunasaa mundiqau. Misa sia Anutuna ufaki mapukusee mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Miqimarunara Eefaraimmana akeeku akaaku duru feefa mareeqa rakiranaki oonureeqa, fifau rufiasee oonurandee sandaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Misa Anutuna moodaanaki kira ufamau sia andeeqasee fiqau. Mina sanda ufara nikooqoofaqa minnisee kaqi runna fimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Anutufa auqoo ainaina qaunuseeqa, mifa naaquqara ainaina uqannifiqoonara faqa qaunusaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Misa nikeeku nikaaku nikausa noorisaa faiqí sia amana auqaaqaa ira ainaina uqannifiqanau, Isipa maqa maaqaki moo maqusa auqu Sooana mi maqusanaki maru afaasanasaa uqannifiqoonara faqa qaunusaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Anutufa taatuqee ooruku nammari rakeemasee misa nifiqee aadanasaa finau. Mifa nammari rakeemandoofanoo, dinni dinni aaqanara foora inau. ");
INSERT INTO bjr_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Faasaanasaa mifa asurukiqari misa nifiqee finau. Eendaki ida fannoo kaaqa qamannimaqee marufaqa fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Misa nammari siaisaqa fimarufanoo Anutufa ooni afoommandeenoo nammari farumakinaanara foora moomoo nimufaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Anutufa oonikiqari nammariara ooqufuannee qufanoo nammari quminau, firaa nammari anoonara foora quminau. ");
INSERT INTO bjr_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Misa sia minara irirai kaqi kai aaqara oosana Anutuna afusaa maree mariqau. Misa aadana maqa maaqaki fidaqa uriqarara Anutuna afusaa ititammasee nári iriranamau mandainainaki kaqi fimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Misa Anutuna amanamasee qafaanee qimasee nariqa nidimari naranara innaaru qimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Sia mina kai, misa Anutunara firaaqoo amanammasee qafaidee qimasee maaqi qiqau. Amanee maa aadana maqa maaqanaki Anutufa narana qimiannoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Kuqaa Anutufa ooni arufanoo nammari firaafa quminau. Mi nammarifa firaa nammariara foora quminau. Kafaa amanee mifa narana faqa aandau faqa maasa narí maqannaasa qimiannoofee. ");
INSERT INTO bjr_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Yaaweefa misa ufa iriseenoo firaaqoo aanoo qinau. Aanooqidanoo ida radiqisoofanoo Yakooboona faiqi namu narinau. Mina aanooqirafa firaanaikinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Misa Anutunasaa sia nári irirana rusiqau. Misa Anutunara sia amana mandainainakinaana maasa asumu maraannoo fee qiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Mifa sia minara irinau kaqi qasuru qimamufanoo innaruna kooqi atuanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Atuaseenoo mannaa feemu innaarunaindaraa narana sakuma fooqaana aakuara foora teeqimasoofaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Mikari Anutufa angiroouqa neemaru naranna nimufaqa naqau. Anutufa misa sia amana nama taikaaqaaira narana niminau. ");
INSERT INTO bjr_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Anutufa narí afeekannai qufanoo suani afu oosanaindari faqa dinni ataaqeendari faqa ufai uqinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Mifa ufiniuqa kookoommara foora misa teeqimma niminau. Ooruku nammari afaiqaraa nukudara foora ufini misa niminau. ");
INSERT INTO bjr_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Anutufa qufanoo ufiniuqa misa uiqaana maqusa qambaana faqa naambeeqaqara faqa teeqi teequfaqa naqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Teeqi teeqimmasoofaqa marasee noofanoo moomoo uqanna kaqi marinau. Misa faaqa rimarufanoo Anutufa moomoo uqanna nimufaqa misa namasoofanoo nimuaqu inau. ");
INSERT INTO bjr_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","31","Mi ufini naranausa neemarufanoo sia nimuaqu inau, kaqi naida marufanoo Anutuna arana qoofanoo misa afeeka fasiqauqa kuqa narinau. Mifa Isaraee maqannaa amiqira kumaaraauqa narinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Misa mi aiqama ainaina tianaki Anutuna afeeka qafamasee sia mina saqari kiqau, kaqi aaqaranaki fimariqau. Misa Anutufa sia faiqí auqaaqaa ira naaquqara ainaina auqoonara irisee sia misa irirana Anutunasaa rusimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Mina akiiqara misa maa maqanasaa marirana naidoora foora fuaqasoofaqa kai kaqi taikaqau. Misa mandaikamma nimaqasoofaqa kuqirafa tautummasee misa qumaroofaqa kuqiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Anutufa misa kuqa narufaqa kaqi marusa misa quandaki Anutufinnai ubeekaqau. Mifa misa kuqa narufaqa kaqi marusa noori runusee mifunnai ubeekamafi innaaru qimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Anutufa misa kuqa narufaqa nári oonu mafi iriseeqa, kuqaa Anutufa maasa ititaqimaqee mari fee qiqau. Uriqarara Anutufa maasa mandainainakinaana feefaurummasee dadaaqi marifammifoo qimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Misa sia nimuqusa ookiqarifau miqi qiqau. Misa fifau nookiqari kai Anutuna amiqi amiqidaqa miqi qimariqau. Misa nári nifaurunnai unnufa kai qimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Misa sia kuqaa uqanna Anutuna ufa afaqee marinau. Misa sia Anutuna faqa moodaanaki kammaqoo ufanasaa mapukusee mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Anutufa misa manda oosana qafamaseenoo, mina amuqusirafa qumbiqanoo marunara misa manda oosana akiiqara minnisanau, sia narinau. Moomoo kari narí aanooqirana rafaaqafuseenoo sia narí aanooqirana aiqama uqeeranau. ");
INSERT INTO bjr_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Mifa misara faiqí faiqi kai fee qimaseenoo irinau, misara kaqikaa ufai fuaqaifaqa kai kaqi taikee mariasee qinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Misa aadana maqa maaqaki naqumma kari fee naakapara ufara nikooqoofaqa aanooqimariqau, moomoo kari miqimariqau. Naqumma kari Anutuna amuqusa mandaikirana amimariqau fee. Moomoo kari miqimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Misa moomoo kari Anutuna amanammasee qafaqau. Misa Isaraee maqannaa naaquqara andeeqara Anutuna amuqusa mandaikirana kaifaa kaifaa amimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Misa Anutuna afeekara qauniqau. Mifa misa firaa ummaara ameemaanai mariuna kinaana maroonara faqa qauniqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Anutufa Isipa maqa maaqaki narí oosana uqannifiqoofaqa qafaqau. Moo maqusa auqu Sooana mi maqusanaki maru afaasanasaa faqa narí oosana uqannifiqoofaqa qafaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Anutufa qufanoo nammari uqanna fannoo quandaki fidikaikinau. Miqimmafufaqa Isipa maqannaasa nammari naranara randoosia minnisaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Mifa qufanoo faufaari oosana oosana kambiqafufaqa Isipa maqannaasa ukaqa nimidaqa aupurarana nimimariqau. Mifa eeqamoosara qufaqa anireeqa misa maqa maaqa mandaikamma nimaqaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Anutufa qufanoo pandaaqa moomoo aniree misa ainaina aiqama nama taikaqau. Mifa qufanoo misa kadaapi rirafa aammaadi oo aamarai kaimbinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Anutufa qufanoo pupusamu aqufinoo misa waina sanda afuqakinaana ariisoofanoo aiqama aadana usu taikanau. Firaa suara namu faqa pupusamu namu faqa aninoo misa saqari qaqama neemaruna faafisa fooqaa irana aiqama mandaikammasanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Mifa qufanoo misa burimakau aina pupusamu aqufinoo aiqama narinau. Kafaa aakuasaa fannoo aiqama firimaru aandausa oosana oosana narinau. ");
INSERT INTO bjr_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Anutufa narí aanoo qirana faqa narí kaukaata qirana faqa narí aranaqaranara faqa faiqí nárí maru qangiroosa faqa idara foora niqiqoofaqa qumuree Isipa maqannaasa nariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Mifa narí aanoo qirana sia rafaaqa finau. Misa nimana kuqiranaki firarufanoo sia rafaaqa finau. Mifa Isipa maqannaasa manda auriranaki quqasoofaqa kuqi mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Mi angiroofa Isipa maqannaa ooqa faiqiuqa aiqama naru raurukanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Anutufa narí maqannaa Isaraee maqanaasa sipsipara foora nifiqee finau. Mifa sipsipara foora aadana maqa maaqaki misa andeeqasee indaarunnikamma nimaqanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Anutufa amiqimmasee rakisi nimaqee marufaqa sia narira ainainara rufiaqau. Taatuqee nammari fannoo misa namuqaa aiqama dukuninau. ");
INSERT INTO bjr_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Anutufa misa nifiqamaree Kannaa maqa maaqai narí naaquqara maqa maaqai nifiqee oonuranau. Narí afeekannai maroo aaqannasaa quqannisanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Mi maqa maaqanakinaa aanaamuru damunamma aquseeqa maqa maaqa oosuseeqa Isaraee maqannaa faiqí oosana faiqí oosana rainannimufaqa maqa maaqa marasee nariqa maqasaa ooqu mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Misa mi aiqama ainainna qafamaseeqa quandakiqa uriqarara Anutunara amanammasee qafaqau. Misa sia mina naamuaqira ufa afaqaqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Misa quandaki nári ninaakusa naanna raida ufa rukiee mariqau. Misa eendaandira feefaraa foora aqusoofanoo fuadakamaki kaqinni fimariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Isaraee maqannaasa unnaqira anutusa tatufirana suqa nimidaqa minannai Anutuna uqanna arana fundakiqau. Náriqa tumunnai auqira unna anutunannai mina arana qarana amiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Anutufa misa oosana qafamasee misa aanoomma nimaqasee misa miniseenoo ameesa uqunnisanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Rakeemmeeqee aquseenoo Anutufa narí naaquqara uiqaana maaqa Siroo maqusaki maruna faqa minnisanau. Narí maasa qambaana mariu maqana minnisanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Mifa narí qima afeekaikira bookisa narí afeeka maruna namuqaa nisaukuki quqasoofaqa maree fiqau. Mifa narí bookisa narí afeeka areenarafa maruna mareeqeenoo namuqaa nisaukuki quqasoofaqa maree fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Mifa narí maqannasa Isaraee maqannaasa aanoomannimaqaseenoo misa namuqaara qufaqa akaqausa kuqa nariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Misa kumaaraauqa rakiranaki kuqufufaqa maanaaqauqa marara fasiqa sia mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Misa amaana maqasaa aanaikirausa duru saamu ookina keeqafufaqa misa ninaaqmaaka rakirafa kaqi kai marufaqa náriara faqa rufiasee sia iki raqee mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Miqooqari Yaaweefa faiqaranakiara foora tautuma findifinau. Mifa afeeka fasiqa wainna nammari namasee afeeka marasee findi fuandee inau. ");
INSERT INTO bjr_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Findifinoo narí namuqaauqa narunifaqaaqa masoofaqa fiqau. Anutufa naru nifaqasoofaqa naaru marira nisaurirana marasee sia kafaa rakiqau. ");
INSERT INTO bjr_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Yaaweefa Yooseefaana narí amaaku Eefaraimmana faqa misa nikeeku nikaaku sia rusandeesamummasee maranau. ");
INSERT INTO bjr_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Yudana akeeku akaaku rusandeesamummasee maranau. Anutufa misa maqa maaqaki maru aaqanna misa auqu faqaa aaqanna Sioona aaqana narí aidi maru aaqanna faqa maranau. ");
INSERT INTO bjr_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Miqoo Sioona aaqanasaa Yaaweefa narí innaarunai maru naaquqara amaana maqana fooqaairana usakanau. Maa maqanara foora naaruara mapukusee marira maaqa usakanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Anutufa narí ainainira faiqi Dafidina rusandeesamummasee maranau. Mifa sipsipasaa rakisi marunakinaana maranau. ");
INSERT INTO bjr_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Anutufa Dafidina sipsipasaa rakisi marunakinaana mareeqeenoo Isaraee maqannaasa karaambaiqaika masanau. Anutu faiqí aanaaseesa sipsipara foora faqa rakisianifeera mara quqanau. ");
INSERT INTO bjr_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Miqooqari Dafidifa narí andeeqara iriranannai faqa narí akoofasaikiranannai Isaraee maqannaasa sipsipara foora indaarunnikamma nimaqanau. ");
INSERT INTO bjr_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Oo Anutu, aamina maqannaa aniara sia iri mariasa maasa maqa maaqaki doo aniree maasa ani faiqí anaasee faqa rakidaqa. Misa ani naaquqara amaana maqa putaammamaqeea. Yeerusaree maqusa rapeepaammaseea. ");
INSERT INTO bjr_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Misa ani aiku asauku aiqama narusee quqasoofaqa ufiniuqa aniree misa iri naqau. Kaasau aandau faqa ani maqannaasa naru quqasoosa nipata naqau. ");
INSERT INTO bjr_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Misa fidika Yeerusaree maqusamau nammariara foora umbiqanau. Misa nikundara fasiqa sia mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Maasa daaqa mariasa faqa maasa fiqu fiqumma mariasa faqa mina qafamasee maasara ataasataasa qimaseeqa naanaidara qidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Oo Yaawee, ani aanoo qirafa naaruaree mariannoo fee. Ani rairai qirafa naaru naaru idara fooree qaannoo fee. ");
INSERT INTO bjr_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Oo Yaawee, aneenna aanoo qirana aamina maqannaasa, sia ani auqu amooqi mariasasaa teeqia. Akaqa maqannaasa sia aniara innaaru qimariasa misasaa teeqiaqaana. ");
INSERT INTO bjr_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Misauqa maasa ani faiqí anaasee kuqa daridaqa. Misa ani maqa maaqa furufaridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Oo Yaawee, sia maasa qikeeku qikaaku aaqarana akiiqara maasa aupurarana qimia. Aneenna nifauara reendeeniranannoo kai kaqi maasa dadaaqia. Maasa oonumafi irirafa oorudupinoo marinara maasa dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Oo Anutu maasa asumu maree marianafa anee aneenna auqu qareenaranara irisee maasa aaqarana akiiqara minniqisainaqa maasa ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Nanaree akaqa maqanaasa maasara yaifee inni Anutufa maridanoo fee qifoora. Aneenna aiku asauku fidika akiiqara qimasee maasa qifusaa aupurarana niminaqa maasa qafaa. Misa ani ainainira faiqiuqa naruana akiiqara miqia. ");
INSERT INTO bjr_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Oo Yaawee, maasa qiku qisauku namuqaa rumbaranaki mariasa faaqari mariana iria. Namuqaa naruaneera ifana anee aneenna afeeka asaukunnai misa ititannimaqasee mara asumu mariranaki quqannisaa. ");
INSERT INTO bjr_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Oo Yaawee maasa daaqa mariasa ani manda ufa ami mariasa anee mina akiiqara dinni taikasee dinni ani qaaraqanda marasee kari misa nimia. ");
INSERT INTO bjr_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Anee miqimmasainaqa maasa ani faiqi namu, ani sipsipara foora aniara naaru naaru dufi dufi qianaura. Naaru kambiqainausa faqa ani amooqirana amifaranoo. ");
INSERT INTO bjr_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Oo Yaawee, anee Isaraee maqannaa sipsipasaa rakisirafara foora mariannanara maasa ufa iria. Anee maasa sipsipara foora rakisi marianafa mariannanara maasa ufa iria. Anee angiroouqa niqoosa faqaasa mariaqoo seerubimma mariaqoo miqoo anee Yaaweefa ooqu marifi marianafa mariannanara anee maasa ufa iria. ");
INSERT INTO bjr_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Eefaraimmana akeeku akaaku faqa Beensaminnana akeeku akaaku faqa Mannaseena akeeku akaaku faqa nifusaa koorooia. Aneenna afeekannai findi finana mai aniree maasa ummaaraki marunnana uqeeraqisaa. ");
INSERT INTO bjr_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Oo Anutu, anee kafaa maasa uqeera quqaqisaa. Anee maasara qimudaoo qinaqa maasa kaqi asumu marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Oo Yaawee, aiqama afeeka faqaa Anutufa, anee kisaaqasaa fee aneenna faiqí anaasee innaaru qiranara aanoo qinnaree. ");
INSERT INTO bjr_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Anee maasa naukunu kai naranara foora nimianaqa neeqa. Anee naukunu qumbiqanoo mari difaanina qimianaqa nammariara maqi neeqa. ");
INSERT INTO bjr_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Anee qianaqa maasa daaqa mariasa faqa maasa maqasaara tinoo taanoo ridaqa. Maasa namuqaa maasa qiqafeeqa ataasataasa qima qimaqaidanoo. ");
INSERT INTO bjr_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Oo Anutu anee kafaa maasa uqeera quqaqisaa. Anee maasara qimudaoo qinaqa maasa kaqi asumu marianaura. ");
INSERT INTO bjr_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Oo Anutu, anee maasa Isaraee maqannaasa wainna sandara foora Isipa maqa maaqakinaana maasa asumuanara mamaree anireenana maaqoo aiqama maqannaasa futeeqa aqusee misa maqasaa ummaquqoonausa maridaqa. ");
INSERT INTO bjr_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Anee saikammasee miqoo ummaqusoona mariifanoo kambiqafinoo maa maqa maaqana amanaikinoo. Mina atuka fannoo maqaki meemai uqanna keeqeenoo. ");
INSERT INTO bjr_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Mi sandafa firaanaikufanoo amuaqu namuqa faqa mina auqaanai mariqau. Firaa sidaa saqariuqa faqa mi sandana auqaanai kai mariqau. ");
INSERT INTO bjr_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Mi sandana dinni asaana fannoo firaa ooruku nammari mediteereenia afainni ooqu finau. Dinni asaana fannoo firaa nammari Eufarateesa nammari afainni amana kai finau. ");
INSERT INTO bjr_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Oo Anutu, anee nanaree mina ququsa rakeemmasaanaqee aatata fiqaree aiqaree inausa mina qaqama tiqinfaree. ");
INSERT INTO bjr_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Kaasau kuara fannoo nandakiqari aniree mi sandana nikunnai radamuseea. Kaasau aandau faqa aniree mina naidaqa. ");
INSERT INTO bjr_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Oo aiqama afeeka faqaa Anutufa, anee maasa iannannai quandaa. Innaarunaindari maasa qiqafaa. Ani wainna sanda marunausa qiqafamasee dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Anee qummaquqoonna afuqana qumuree qafaa. Ani wainna sanda anooka aneennara ummaquqoonafa afeekaikinoo maridanoo, qumu qafamasee dadaaqia. ");
INSERT INTO bjr_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Maasa namuqaa maasa Isaraee maqannaasa ani wainna sanda asaanara foora mariafaqa ateekasee idara saafanoo doo qamafinoo. Anutu anee aanoo qimasee misa kuridi nimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Anee rusandeesamummasee maraqoonausa aneenna asaukunnai misa ititannimaqaa. ");
INSERT INTO bjr_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Miqimmandaina sia maasa anikiqari quandaki kaqinni sandaanauranoo. Anee marirana qiminaqa maasa kafaa findifi ani auqu ramasee ani amooqianaura. ");
INSERT INTO bjr_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Oo Yaawee aiqama afeeka faqaa Anutufa, anee kafaa maasa qifiqee aneenna iannannai ania. Anee maasara qimudaoo qinaqa maasa sia kuqua kaqi asumu maria. ");
INSERT INTO bjr_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Anutufa maasa dadaaqi marifa marinara faaqa rumasee asasida idi rama amaqaaqa. Yakooboona Anutuna amooqira idi raaqa. ");
INSERT INTO bjr_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Idi oosana arasee, temberinna namu faqa piripuna namu faqa ufireena namu faqa marasee aridaqa asasira idi raaqa. ");
INSERT INTO bjr_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Fuka quqoona anirainaqa sipsipa aanainnoo ufireena fuaqaaqa. Kafaa mi quqoonafa rufatee fatinaqa oomaqa sakasee naida ukeena fuaqaaqa. ");
INSERT INTO bjr_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Mi qoomaqa sakarafa Isaraee maqannaasa sanda ufara foora marinaqa aukuana aukuana naaru naaru miqifaranoo. Yakooboona Anutufa maasa qimu sanda ufafa maridanoo. ");
INSERT INTO bjr_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Anutufa Isipa maqannaasa naruseenoo mi sandufana Isaraee maqannaasa niminau. Qinee sia qafeemarunna fasiqana aunda irida. ");
INSERT INTO bjr_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Mifa maaqi qimasee qimanniminau. Qinee inni Isaraee maqannaasa nikumaaqa firaa ummaara akunnimaqaqoona afaimeeqee quqeeqa. Qinee inniara qunaqa inneeqa ummaara maqasaa afaimma quqaafanoo. ");
INSERT INTO bjr_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Innee manda aupuraranaki maridaqa qini Anutusa daaroofaqa qinee minakinaana inni mareeqee kaqinni quqannisa qiafana. Qinee qeeqa kukeeqara maqusa oonnamukiqari inni dadaaiqiafana. Innee Meeribaa nammari maruqoo marufaqa qinee inni nimanammasee qafaqiafana. (Meeribaa mi nammarina auqu oosana tinoo taanoo rira nammari fee qinau.) ");
INSERT INTO bjr_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Oo qini maqannaasa qinee inni aauqira ufa qimannimianaqa iriaqa. Oo Isaraee maqannaasa innee qini aauqira ufa iriaqa. ");
INSERT INTO bjr_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Innee sia moo unna anutuna amooqiaqa. Qini kai qimooqiaqa. ");
INSERT INTO bjr_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Qinee Yaaweesa inni Anutusa maridaqa. Qinee inni Isipa maqa maaqaindaraana nifiqee aniafanausa maridaqa. Innee minara iriseeqa qinee unnannai kai noo raqasaifaqa qinee kai inni narana nimianaura. ");
INSERT INTO bjr_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Qinee mi ufana amiqimasee qeeqa maqannaasa qimannimiafanaqa sia mi ufana iriqau. Isaraee maqannaasa sia qini Anutusa ufamau fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Qinee misa mumuqira oosana qafamaseeqa misa rafuseeqee nári nidimaru mandoosanaki aqiqiafana. Doo miqooqari misa nári nidimaru manda iriranamau fiqau. ");
INSERT INTO bjr_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Oo qini maqannaasa naqaa qini ufa iriaqaana. Isaraee maqannaasa qini aatata fuaqaana. ");
INSERT INTO bjr_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Misa miqifaqau qinee kai kaqi misa namuqaa rafaaqafusani. M