﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjp_vpl;
CREATE TABLE bjp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjp_vpl WRITE;
INSERT INTO bjp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Igii e asan foron tubutamat e Iesu Karisito kalalik ke Dewit, ma Dewit kalalik ke Abaram: ");
INSERT INTO bjp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram i e tama Aisak, Aisak i e tama Jekop. Jekop i e tama Juda turan foron tualik. ");
INSERT INTO bjp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda i e tama Peres ru e Sera, tinruh e Tamar. Peres i e tama Esron, Esron i e tama Ram. ");
INSERT INTO bjp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram i e tama Aminadap, Aminadap i e tama Nason. Nason i e tama Salmon. ");
INSERT INTO bjp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon i e tama Buas, tina e Rahap. Buas i e tama Obet, tina e Rut. Obet i e tama Jesi, ");
INSERT INTO bjp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ke Jesi i e tama king Dewit. Dewit i e tama Solomon, tina i antu Uria ta bii. ");
INSERT INTO bjp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon i e tama Reoboam, Reoboam i e tama Abia, Abia i e tama Asa. ");
INSERT INTO bjp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa i e tama Jeosafat, Jeosafat i e tama Jeoram. Jeoram i e tama Usia. ");
INSERT INTO bjp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia i e tama Jotam. Jotam i e tama Ahas. Ahas i e tama Esekia. ");
INSERT INTO bjp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia i e tama Manase. Manase i e tama Amon, Amon i e tama Josaia, ");
INSERT INTO bjp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ke Josaia i e tama Jekonia turan foron tualik. Aunbiing ae fan Israel ri ka kamkabet na Babilon. ");
INSERT INTO bjp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nami na kamkabet na Babilon: Jekonia i e tama Sealtiel, Sealtiel i e tama Serubabel. ");
INSERT INTO bjp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel i e tama Abiut. Abiut i e tama Eliakim. Eliakim i e tama Asor. ");
INSERT INTO bjp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor i e tama Sadok. Sadok i e tama Akim. Akim i e tama Eliut. ");
INSERT INTO bjp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut i e tama Eleasar. Eleasar i e tama Matan. Matan i e tama Jekop, ");
INSERT INTO bjp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ke Jekop i e tama Josep antu Maria, tina Iesu, Iesu ae ri foteng u ini Mesaia. ");
INSERT INTO bjp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","I sangful ini fet e ulul tipes u lo Abaram ulo Dewit, ke i sangful ini fet, tipes u lo Dewit una aunbiing fan Israel ri kamkabet na Babilon, ke i sangful ini fet tina aunbiing na kamkabet na Babilon una aunbiing Mesaia i pang. ");
INSERT INTO bjp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ususe lo Iesu Karisito ae i pang i aragii: Maria, tina Iesu, ri fakale ta u le in telpes Josep, isau le aunbiing biil biitom ru kiis turim, ke ri ka par u le Maria ka tian tah. Tanwa Kalkaluu tom i fatapiek kalalik na bala. ");
INSERT INTO bjp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep antu Maria i nenge tom tortores, pesu biil i to ier isi famatlawen Maria na matan fanu, ka wol le in lin fakum u sau. ");
INSERT INTO bjp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Isau le aunbiing i wolwol la biitom, ke nenge angelo ke Kumguui ka tapiek sing i na nimnibiil, ke ka tarah, “Josep, kalalik ke Dewit, gong o sokeh isi telpes Maria arae antum, wara le kalalik ae na bala, Tanwa Kalkaluu tom i fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","In fang nenge kalalik tamat ma on foteng u ini Iesu, wara le in faliu fanu kia koseng foron sinang laulau kiri.” ");
INSERT INTO bjp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Foron tier tikii igii i tapiek una fasuut orek ke Kumguui ae profet i use ta u aragii: ");
INSERT INTO bjp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Gam ongen u, nenge tah ae biil biitom i borong turan ti kaltu, in tian ke ik fang nenge kalalik ma rik foteng u ini Imanuel.” Kamtinan orek ae le, “God i kiis tura kerer.” ");
INSERT INTO bjp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aunbiing Josep ka mat, ka telpes Maria arae antu, arae tom angelo ke Kumguui i fas ta u. ");
INSERT INTO bjp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Isau le Josep biil i borong tura papang na aunbiing Maria ka luun kalalik. Ke Josep ka ta asa le Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu i pang na Betliem na falifu na Iudaia, na aunbiing ke king Erot. Namih, foron tom tasum tina falifu ae pisiih i susupiek la wah ri ka tapiek na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ke ri ka diik aragii, “Fia i pang wa e kalalik ae i king ken fan Iudaia? Keme par keltot kia na falifu ae pisiih i susupiek la wah, ke keme ka la isi lotu unaisa.” ");
INSERT INTO bjp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aunbiing king Erot ka ongen u, ka lala wol, ke fanu tikii sabin tina Ierusalem ri ka lala wol. ");
INSERT INTO bjp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","King Erot ka kam turim foron laulaumet na pris turan foron tom fafausum ini nagogon ke ka diik ri aragii, “Fia in pang wa e Mesaia?” ");
INSERT INTO bjp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ke ri ka kiliis u aragii, “Na Betliem na falifu na Iudaia. Wara le profet i siit ta u aragii: ");
INSERT INTO bjp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Isau le wo Betliem, na nanal na Iudaia, biil o ae na kesting na fatpoton foron tom nagogon na Iudaia. Wara le nenge tom nagogon in la tinawii sing o, ae in fofonoi lon fanu kiak, fan Israel, arae nenge tom fofonoi na sipsip.’” ");
INSERT INTO bjp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ke king Erot ka kam fakum foron tom tasum ae, ke ka diik ri isi aunbiing sa tom keltot i kiispiek lo. ");
INSERT INTO bjp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ka wuun ufu ri una Betliem ke ka fas ri aragii, “Gam la ke gamek im rokap isi kalalik ae. Aunbiing gam tafe u, gamek fas iau, isi ia sabin iak la ma iak lotu unaisa.” ");
INSERT INTO bjp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ri ka ongen ta orek ke king, ke ri ka la. Na ninla kiri, keltot ae ri par ta u na falifu ae pisiih i susupiek la wah, ka famu ini ri, ke ka kiis tortores na olon falifu ae kalalik i kiis lo. ");
INSERT INTO bjp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aunbiing ri par keltot ae, ke ri fuun ini tara laes. ");
INSERT INTO bjp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ri ka kau una fel ae, ke ri ka par kalalik ru lapoko e Maria. Ri ka ilepul ma ri ka lotu unaisan kalalik ae. Ri ka sapeng na foron minsik kiri, ke ri ka fafen unaisa ini goul, tier ae bau lo i furung rokap, ke tier ae imel e rokap na sana, ri foteng u ini mir. ");
INSERT INTO bjp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na nimnibiil, God ka fakiing ri le gong ri fis usuf Erot. Pesu, ri ka fis una maleh kiri na nenge sal keskes. ");
INSERT INTO bjp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aunbiing ri ka la tah, ke nenge angelo ke Kumguui ka tapiek sing Josep na nimnibiil ke ka fas u aragii, “On aptih, telpes kalalik tura tina, ma gamtuulek fin una Isip. Gamtuulen kiis aiwa papang na aunbiing ian fas o, wara le Erot in im isi kalalik ae isi ik siimete u.” ");
INSERT INTO bjp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na wor tom ae, ka aptih, ka telpes kalalik tura tina ke rituul ka la una Isip. ");
INSERT INTO bjp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rituul ka kiis aiwa papang na aunbiing Erot ka met. Tier igii i tapiek una fasuut orek ke Kumguui ae profet i use ta u aragii, “Ia tawi pes keng kalalik tina Isip.” ");
INSERT INTO bjp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Aunbiing Erot ka usum mang le foron tom tasum ae ri ka fabal ta u, ka kut laulau e bala. Ke ka luun rakrakai na nagogon le rin siimete foron kalalik tamat tikii na Betliem ke na foron maleh fatat, tipes u lon foron mirmiriiu papang lon berberat ae iwu e bet kiri, arae na aunbiing ae i ongen ta u sing foron tom tasum. ");
INSERT INTO bjp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ke orek ae profet Jeremaia i use ta u, ka suut: ");
INSERT INTO bjp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kinen tikas ri ongen u na Rama, i luluen ma ka lala teng. Rakel i tingis berberat kia, ma biil i ges e bala isi tikas in famor u, wara le ri tikii ri ka met tah.” ");
INSERT INTO bjp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aunbiing Erot ka met tah, nenge angelo ke Kumguui ka tapiek sing Josep na nimnibiil na Isip. ");
INSERT INTO bjp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ke ka tara sing i aragii, “On aptih, telpes kalalik tura tina ke gamtuulek fis una nanal na Israel, wara le fanu ae ri famam ier isi siimete kalalik ae, ri ka met tah.” ");
INSERT INTO bjp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ke ka aptih, ka telpes kalalik tura tina ke rituul ka fis una nanal na Israel. ");
INSERT INTO bjp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Isau le aunbiing Josep ka ongen u le Akelaus ka ti kiliis Erot, tama, arae king ken fan Iudaia, Josep ka soke isi in la unaiwa. Ke na nenge nimnibiil, God ka fanau Josep, pesu rituul ka apti tinaiwa una falifu na Galili. ");
INSERT INTO bjp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Rituul ka la ke rituul ka melmel na nenge maleh ae ri foteng u ini Nasaret, una fasuut orek ae foron profet ri use ta u le: “Rin foteng u ini sikin Nasaret.” ");
INSERT INTO bjp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na foron biing ae, Jon Tom tel Bapitaiso ka tapiek ma ka fafas na falifu foes na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ma ka tarah, “Gamen sokiliis liu kimi, wara le matanfuntih na kukulii ka fatat.” ");
INSERT INTO bjp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon i e kaltu ae profet Aisaia i use ta u, aunbiing i tarah, “Kinen tikas i tautau na sunbiil aragii, ‘Fageges sal sala Kumguui, fatortores sal sala.’” ");
INSERT INTO bjp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kilkiliis ke Jon ri tel u ini olon kamel ma i fis lifa ini pus ae ri tel u ini punun bulmakau. Inen aia e sukuuw turan mindu aka. ");
INSERT INTO bjp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Fanu tinbae na Ierusalem, fan Iudaia tikii ke fanu tikii tina foron maleh fatat dan na Ioridan ri ka la usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri ka fapos foron sinang laulau kiri, ke Jon ka baptais ri na dan na Ioridan. ");
INSERT INTO bjp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Isau le aunbiing i par ifuun e Farasi turan foron Sadusi ri la una falifu ae i tel bapitaiso lo, ka tara sing ri aragii, “Gam foron natun sii fafangaet! Se i tara le gamen alfe ngaliaf ke God ae in tapiek? ");
INSERT INTO bjp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","In mel e rokap na fua gam, una finngas u le gam ka sokiliis liu tah. ");
INSERT INTO bjp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na wolwol kimi, gong gam tara sing gam tom le, ‘Abaram i e tama kemem.’ Ia fas gam, God ifasi in sokiliis foron fat igii isi rik tapiek berberat ke Abaram. ");
INSERT INTO bjp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Palnget ae mang ta na baulin foron au, ma foron au tikii ae biil ri fua rokap la, rin pok faluut ri ma rik lin ri una yiif. ");
INSERT INTO bjp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ia baptais gam ini dan una finngas u le gam ka sokiliis liu tah, isau le ier ae in mi pes iau, rakrakai kia i liu kulkulef na rakrakai kiak. Pesu, biil ia tortores isi ifasi iak kep su kia. In baptais gam ini Tanwa Kalkaluu ke ini yiif. ");
INSERT INTO bjp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I pose na nenge saol una simke ufu foron piin tina wit. Aunbiing ka simke tikii ta u, ik luun turim wit rokap na felu, ke foron piin ik fasok u na tara yiif ae biil i to met la.” ");
INSERT INTO bjp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ke Iesu ka la tina Galili una dan na Ioridan isi Jon ik baptais u. ");
INSERT INTO bjp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Isau le Jon ka totof isi in tikale u, ke ka tara sing i aragii, “Isi sani o ka la usuf iau? I rokap le on baptais iau.” ");
INSERT INTO bjp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Isau le Iesu ka tara sing i aragii, “Taftawa ik tapiek tom arae, igii. I rokap le karan tel u arae una fasuut foron tier tikii ae i tortores na mata God.” Ke Jon ka somangat mang isi baptais u. ");
INSERT INTO bjp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aunbiing Jon ka baptais ta u, Iesu ka masah tina dan, ma fanpil kukulii ka sapeng, ke ka par Tanwa God i puh arae nenge bun ma ka top lo. ");
INSERT INTO bjp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ke kinen tikas tinbae na kukulii ka tarah, “Igii e keng Kalalik, ae ia ier kanaka isi, ma ia laes kanaka ini.” ");
INSERT INTO bjp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ke Tanwa Kalkaluu ka lame Iesu una sunbiil isi Satan ik tof u. ");
INSERT INTO bjp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aunbiing Iesu i fafel na ifet e sangful e biing ke ifet e sangful e wor, ka fitol. ");
INSERT INTO bjp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ke tom fasobor ka tapiek sing i, ma ka tarah, “Male o Kalalik ke God, ke ok fas foron fat igii rik tapiek beret.” ");
INSERT INTO bjp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu ka kiliis u aragii, “Ri siit ta u ae na Buk na Gogoh le, ‘Fanu biil ri liu la na inen sau, biil. Ri liu na foron sun orek tikii ae i suu tina ngusu God.’” ");
INSERT INTO bjp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Namih, Satan ka lame u una Ierusalem, i e maleh kalkaluu, ke ka fiti u bae na fungan Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ke ka fas u aragii, “Male o Kalalik ke God, ke ok wof puh. Wara le ri siit ta u na Buk na Gogoh aragii, ‘God in fas foron angelo kia ini wo ke rik pose pes wo ini limri, isi biil ifasi on tuke kekem na ti fat.’” ");
INSERT INTO bjp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ke Iesu ka kiliis u aragii, “Ri siit u sabin na Buk na Gogoh le, ‘Gong o luun Kumguui, God kiam, na fatoftof.’” ");
INSERT INTO bjp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Namih, Satan ka tel pes Iesu sabin una nenge tara pungpung, ke ka finngas u ini foron matanfuntih tikii na piklinbat ke ini foron memeh kiri. ");
INSERT INTO bjp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ke ka fas Iesu aragii, “Ian ta foron tier tikii igii usuf o, male on ilepul ma ok lotu unaisang.” ");
INSERT INTO bjp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ke Iesu ka tara sing i aragii, “Satan! Ti koseng iau! Wara le ri siit ta u na Buk na Gogoh aragii, ‘On lotu unaisa Kumguui, God kiam, ma on wong sing i sau.’” ");
INSERT INTO bjp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ke Satan ka la koseng u, ma foron angelo ri ka tapiek ke ri ka lupes u. ");
INSERT INTO bjp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aunbiing Iesu ka ongen ta u le ri ka luun ta Jon na felun kamkabet, ke ka fis una falifu na Galili. ");
INSERT INTO bjp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka apti tina Nasaret ke ka melmel na Kapernaum. Kapernaum i fatat isi dan kawil na Galili, na nanal ken fan Sebulun ke fan Naptali. ");
INSERT INTO bjp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tier igii i tapiek una fasuut orek ae profet Aisaia i use ta u aragii, ");
INSERT INTO bjp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nanal ken fan Sebulun ke nanal ken fan Naptali, na sal una dan kawil, na nenge bulin dan na Ioridan, Galili ken fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Fanu ae ri liu na palgan kubunor, ri ka par ta tara malal. Ma fanse ae malmaluu ken minet i afit ri, malal ka popos ta ulo ri.” ");
INSERT INTO bjp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na aunbiing mang ae, Iesu ka tipes fafas aragii, “Gamen sokiliis liu kimi, wara le matanfuntih na kukulii ka fatat.” ");
INSERT INTO bjp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aunbiing Iesu i toltole bulin dan kawil la na Galili, ka par iun latualik, Saimon ae ri foteng u la ini Pita ru latualik e Enru. Ru linlin ubiin la na dan kawil, wara le ru un tom ienmaket. ");
INSERT INTO bjp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ke Iesu ka fas ru aragii, “Kamu mi lo iau, isi iak fausum kamu na sinangun dat fanu.” ");
INSERT INTO bjp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Fanpil ru ka la koseng foron ubiin kiruh ke ru ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iesu ka la tinaiwa, ke ka par nenge un latualik sabin, Jems ru latualik e Jon, ru un kalalik ke Sebedi. Ru tinawii na palgan mon tura temruh, rituul tumtumarnge foron ubiin kirituul la. Iesu ka kam pes ruh, ");
INSERT INTO bjp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma fanpil ru ka la koseng mon ke koseng temruh ma ru ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu i la na foron falifu tikii na Galili ma ka tel fafausum na foron felun lotu kiri. Ka famam fafas ini Rokap na Fafas na matanfuntih ke God, ke ka faliu fanu koseng marmarsan sasem tikii. ");
INSERT INTO bjp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ususe lo ka sararah usuf fanu tikii na falifu na Siria, pesu ri ka filange fanu tikii ae ri sem marmarsan sasem usuf i, fanu ae ri kalsakai tara fangungut, fanu ae tanwa laulau i susuef ulo ri, fanu ae ri gokgok la turan fanu ae baban fo ri i met, ma Iesu ka faliu ri. ");
INSERT INTO bjp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tara gur na fanu tina falifu na Galili, Dekapolis, Ierusalem, Iudaia ke tina nenge bulin dan na Ioridan ri ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aunbiing Iesu ka par tara gur na fanu, ka tatkau una baban nenge pungpung. Ka kiis, ke berberat na fafausum kia ri ka la unaisa ");
INSERT INTO bjp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ka tipes fausum ri aragii: ");
INSERT INTO bjp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ri kalok e fanu ae ri usum le ri lauu na tanwa, wara le kiri e matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ri kalok e fanu ae ri teng, wara le God in famor ri. ");
INSERT INTO bjp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ri kalok e fanu ae ri fapu ri la, wara le God in ta piklinbat tikii usuf ri. ");
INSERT INTO bjp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ri kalok e fanu ae ri fitol ma ri ka metdan isi tortores na sinang, wara le nami rin mas. ");
INSERT INTO bjp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ri kalok e fanu ae ri famais la, wara le God in mais ri. ");
INSERT INTO bjp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ri kalok e fanu ae i kalkaluu e balri, wara le rin par God. ");
INSERT INTO bjp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ri kalok e fanu ae ri fatapiek siaroh la, wara le God in foteng ri arae berberat kia tom. ");
INSERT INTO bjp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ri kalok e fanu ae ri kep fangungut sing fanu wara na tortores na sinang, wara le kiri e matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Gam kalok aunbiing fanu ri nes gam, ri ka ta fangungut sing gam ke ri ka use foron orek laulau ulo gam ae biil i tekentu, wara lo iau. ");
INSERT INTO bjp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gamen gesges ma gamek laes, wara le i laumet kanaka e fifiil kimi buuii na kukulii. Foron profet sabin ae ri liu famu ta lo gam ri kep ta fangungut arae sing fanu. ");
INSERT INTO bjp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gam arae tes an fanu tikii na piklinbat. Isau male in rop e musmus lo, ke arafa sabin rin famusmus fafis u arae? Biil mang i rokap una tel ti tier, i rokap sau le rin fore ufu ma fanu rik fose u. ");
INSERT INTO bjp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gam arae malal na piklinbat. Nenge maleh ae i kiis na olon pungpung biil ifasi in mumun. ");
INSERT INTO bjp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Fanu biil ri fasok lam la ke ri ka luun u la na piklin paket, biil. Ri luun u la tom na sala, isi ik ta malal usuf fanu tikii na palgan fel. ");
INSERT INTO bjp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pesu gam sabin, malal kimi in popos una matan fanu, isi rik par foron rokap na sinangu gam ma rik usefages Tama gam buuii na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesu ka use u sabin aragii, “Gong gam wol le ia la isi tel ufu nagogon ke Moses turan orek ken foron profet. Biil ia la isi tel ufu ri, biil. Ia la isi fasuut ri. ");
INSERT INTO bjp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tekentu kanaka ia fas gam, papang na aunbiing kukulii turan piklinbat run mangmangal, biil ti fabiro sisiit ke biil ti fabiro tok na pen in mangmangal tina nagogon ke Moses, papang na aunbiing foron tier tikii ik suut. ");
INSERT INTO bjp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Se i lek ti fabiro nagogon na foron nagogon tikii igii, ma ka fausum fanu isi rin mi na sinangu, rin foteng u le i fabiro kanaka na matanfuntih na kukulii. Isau le se i misuut na foron nagogon igii, ma ka fausum fanu isi rin mi lo, rin foteng u le i laumet na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ia fas gam, male tortores na sinangu gam biil i liu ufu tortores na sinangun foron Farasi turan foron tom fafausum ini nagogon, ke biil tom ifasi gamen kau na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gam ka ongen ta u le foron tubutamat kerer ri kep ta orek aragii, ‘Gong o siimete tikas, male se i siimete tikas in ti na nagogon.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Isau le ia fas gam, le se i ngaliaf ulo tualik, in ti na nagogon. Se sabin i orek laulau ulo tualik, in ti na nagogon na matan foron famfamu. Isau le se i tara le, ‘O talos’ ifasi in la una tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pesu, male o ier isi ta fafen kiam usuf God na salan tunmapek, ma aiwa o ka wol tafe ti tier laulau ae o tel ta u ulo tuamlik, ");
INSERT INTO bjp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ke on sok ufu fafen kiam usuf God aiwa na baban salan tunmapek. La famu bii ok pose na lima tuamlik, ke nami ok fis ma ok ta fafen kiam mang usuf God. ");
INSERT INTO bjp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Male tikas i ier isi luun o na nagogon, ke on fatortores sape orek tura aunbiing kamu toltole sal la, kiliis ta biil biitom o ti na mata tom nagogon. Tarama ka ta ufu o una liman tom nagogon, ke tom nagogon ka ta ufu o una liman tom parpar kale felun kamkabet, ke ka fakau o na felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tekentu kanaka ia fas o, biil ifasi on suuh, papang na aunbiing on ta tikii ifis e pitkalang ae on fiil u.” ");
INSERT INTO bjp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ke Iesu ka tara sabin aragii, “Gam ka ongen ta nagogon ae i tara le, ‘Gong o tel sinangun puur.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Isau le ia fas gam, male tikas i par nenge fifin ma ka mel e wolwol laulau isi, ka tel ta sinangun puur turan fifin ae na wolwol kia. ");
INSERT INTO bjp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Male kolson matam na miam i faluut o na sinang laulau, au ufu ke ok lin u. In rokap le nenge irin pununfom in mangmangal, isi biil rin lin pununfom kuruur una tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ke, male miam i faluut o na sinang laulau, bus ufu ke ok lin u. In rokap le nenge irin pununfom in mangmangal, isi biil rin lin pununfom kuruur una tara yiif ae biil i met la.” ");
INSERT INTO bjp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pakanini ri use ta u le, ‘Kaltu i lin antu, in ta ti aun buk una puk fakekel usuf antu.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Isau le ia fas gam, nenge kaltu ae i lin foes antu, ae biil i tel ta sinangun puur, i tel fifin ae ka tel sinangun puur, aunbiing i fakekel sabin. Ma kaltu sabin ae i telpes u, ka tel sinangun puur. ");
INSERT INTO bjp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gam ka ongen ta u ri fas ta fanu pakanini le, ‘Gong o lek falimlim kiam, isau le on tel fasuut u tom e falimlim kiam usuf Kumguui.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Isau le ia fas gam, gong gam falimlim ini ti tier. Gong gam falimlim ini kukulii, wara le kukulii i e nian kiiskiis ke God. ");
INSERT INTO bjp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ke gong gam falimlim ini piklinbat, wara le piklinbat i e nian fefes ke God. Ke gong sabin gam falimlim ini Ierusalem, wara le i e maleh ken Tara King. ");
INSERT INTO bjp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ke gong gam falimlim ini paklu gam, wara le biil ifasi gamen tel ti olmi ik kor le ik pulpulu. ");
INSERT INTO bjp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Male gam somangat, ke gamen tara sau le, ‘Iuu.’ Ke male gam fakawe, ke gamen tara sau le, ‘Auuh.’ Ti orek sabin ae gamen falimlim ini, i la tom sing kaltu laulau. ");
INSERT INTO bjp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gam ka ongen ta u ae ri tara le, ‘Male nenge kaltu i fabor kolson matan tikas, ke rin tel fabor kolson mata sabin. Ke male nenge kaltu i bayi ngisan tikas, ke rin bayi ngisa sabin.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Isau le ia fas gam, gong gam kiliis sinang laulau ae neng i tel u ulo gam. Male tikas i pose peum na miam, tamikis isi ik pose nenge baba sabin. ");
INSERT INTO bjp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ke male tikas i ier isi luun o na nagogon isi in kep kolos kiam, ta dolon kaen kiam sabin usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Male tikas i fangongos o isi on kekep sing i na nenge kilomita, ke on kekep sing i na in u e kilomita. ");
INSERT INTO bjp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Male tikas i sising o isi ti tier, ke on ta u usuf i. Ke male tikas i ier isi kep ti tier ta bii sing o, gong o rut u.” ");
INSERT INTO bjp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gam ka ongen ta u ae ri tara le, ‘On ier isi ier ae na fatat o, ma ok ememse tuui kiam.’ ");
INSERT INTO bjp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Isau le ia fas gam: Gamen ier isi foron tuui kimi ke gamek sising isi fanse ae ri ta fangungut usuf gam, ");
INSERT INTO bjp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","isi fanu rik iliim u le gam berberat ke Tama gam buuii na kukulii. I tel pisiih kia ka popos ulon fanu laulau ke ulon fanu rokap sabin. Ke ka tel us ka luut na olon foron tom tortores ke na olon fanu sabin ae biil ri foron tom tortores. ");
INSERT INTO bjp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Male gam ier la sau isi fanse ae ri ier isi gam, ke fifiil arafa gamen kep u? Matngan sinang ae foron tom kep takiis sabin ri tel u la. ");
INSERT INTO bjp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ke male gam faorek pes foron tualik gam la sau, ke arafa gam neng keskes arae lon fal? Fanu sabin ae biil ri usum lo God, ri tel u la arae. ");
INSERT INTO bjp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pesu, gamen tapiek tortores, arae Tama gam buuii na kukulii i tortores kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Gamen tumarang, gong gam tel foron rokap na sinang sau na matan fanu isi rik par u. Male gam tel u arae, ke biil in mel e fifiil kimi tinbae sing Tama gam buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pesu, male gam fen foron lauu, gong gam arae foron tom gargaranmet ae ri kuf tafih la na foron felun lotu ke na foron sun sal isi fanu rik bulat lo ri. Tekentu kanaka ia fas gam, ri ka kep tikii ta fifiil kiri. ");
INSERT INTO bjp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Isau le, aunbiing o fen nenge lauu, kaisam gong i usum na sani miam i tel u, ");
INSERT INTO bjp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","isi fafen kiam ik kum sau. Tamam sau ae i par sani ae o tel fakum u, in suat o. ");
INSERT INTO bjp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ke aunbiing gam sising, gong gam arae foron tom gargaranmet. Wara le ri ier kanaka la isi rin soti ma rik sising na foron felun lotu, ke na foron paspasngan sal isi fanu rik par ri. Tekentu kanaka ia fas gam, ri ka kep tikii ta fifiil kiri. ");
INSERT INTO bjp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Isau le aunbiing o sising, kau una fel kiam ke ok babat na matanfel, ke ok sising usuf Tamam ae biil ifasi rin par u. Tamam sau ae i par sani ae o tel fakum u, in suat o. ");
INSERT INTO bjp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ke aunbiing gam sising, gong gam use ifuun e orek ae biil ti kamtina, arae fanu ae biil ri usum lo God. Ri wol la le foron god kiri rin ongen ri wara na almin orek kiri. ");
INSERT INTO bjp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gong gam arae ri, wara le Tama gam i usum na sani gam ier isi aunbiing biil biitom gam sising. ");
INSERT INTO bjp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Gamen sising kol aragii: ‘Tama kemem buuii na kukulii, keme bulat na asam ae i kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Keme ier isi matanfuntih kiam in tapiek, ma wolwol kiam ik suut aga na piklinbat arae sau buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Fen kemem ini inen una biing igii. ");
INSERT INTO bjp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pa ufu foron sinang laulau kimem, arae kemem sabin keme ka wol ufu ta foron sinang laulau ae ri tel ta u ulo kemem. ");
INSERT INTO bjp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","On lame ufu kemem koseng foron fatoftof, ma ok faliu kemem koseng kaltu laulau.’ ");
INSERT INTO bjp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Male gamen wol ufu foron sinang laulau ae fanu ri tel ta u ulo gam, ke Tama gam sabin buuii na kukulii in pa ufu foron sinang laulau kimi. ");
INSERT INTO bjp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Isau male biil gam wol ufu foron sinang laulau ken fal, ke Tama gam sabin, biil in pa ufu foron sinang laulau kimi. ");
INSERT INTO bjp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aunbiing gam fafel, gong gam finngas u na matmi arae foron tom gargaranmet. Ri tel matri ka par mamais una finngas fanu le ri fafel. Tekentu kanaka ia fas gam, ri ka kep tikii ta fifiil kiri. ");
INSERT INTO bjp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Isau le aunbiing o fafel, on dalus ma ok luun wel na paklum, ");
INSERT INTO bjp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","isi fanu biil rin to usum le o fafel, biil. Tamam sau ae biil ifasi rin par u, in par o. Tamam sau ae i par sani o tel fakum u, ik suat o. ");
INSERT INTO bjp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gong gam luun turim minsik kimi tom aga na piklinbat, ae fitfit in ngutngut u ke ros ik falaulau u, ke ae foron tom sisii rin kau ma rik sukuum u. ");
INSERT INTO bjp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Isau le gamen luun turim minsik kimi tom bae na kukulii ae fitfit biil ifasi in ngutngut u ke ros biil ifasi in falaulau u, ke ae foron tom sisii biil ifasi rin kau ma rik sukuum u. ");
INSERT INTO bjp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wara le falifu sa ae minsik kiam i kiis lo, balam sabin in kiis lo. ");
INSERT INTO bjp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kolson matam i e malal na pununfom. Male iun kolson matam i rokap, ke pununfom tikii in fuun ini malal. ");
INSERT INTO bjp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Isau male iun kolson matam i laulau, ke pununfom tikii in fuun ini kubunor. Male malal ae sing o i kubunor, ke kubunor ae in laumet kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Biil tikas ifasi in foim sing iwu turim e laulaumet. Wara le, in ememse neng ma ik ier isi neng, ke in mi lo neng ma ik ire neng. Biil ifasi gamen foim sing God ke pitkalang sabin. ");
INSERT INTO bjp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pesu ia fas gam, gong gam lala wol isi liu kimi, isi sani gamen ien u le isi sani gamen umin u, ke isi pununfo gam, le sani gamen kilkiliis ini. Arafah, biil gam usum le liu kimi i laumet na inen, ma pununfo gam i laumet na kilkiliis? ");
INSERT INTO bjp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gam par foron man ae na mua: Biil ri soso la, biil ri il inen la ke biil ri pakne inen la na papah, biil. Tama gam i fen ri la. Arafah, biil gam usum le gam rokap kanaka lo ri? ");
INSERT INTO bjp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Se lo gam ifasi in bunuut pes ti aunbiing sabin na olon liu kia, aunbiing i lala wol na liu kia? ");
INSERT INTO bjp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ke isi sani gam ka lala wol isi kilkiliis? Gam par foron purpur arafa ri kuum la arae na topormok. Biil ri foim la ke biil ri tel kilkiliis la kiri, biil. ");
INSERT INTO bjp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ia fas gam, foron memeh tikii ae king Solomon i ges la ini, biil i par rokap arae tikas lon foron purpur igii. ");
INSERT INTO bjp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God i me foron fifih na topormok ae ri liu igii ke lumen ri ka lin ri una yiif. Arafah, gam wol le God biil ifasi in fakilkiliis gam? Unune kimi i fabiro kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pesu gong gam lala wol ma gamek tara le, “Sani keren ien u?” le “Sani keren umin u?” le “Sani keren kilkiliis ini?” ");
INSERT INTO bjp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Fanu ae na kabarais ri lala im la isi foron tier igii, isau le Tama gam buuii na kukulii i usum le gam dar foron tier ae. ");
INSERT INTO bjp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Isau le gamen im famu bii isi matanfuntih kia turan tortores na sinangu, ke foron tier tikii igii ik ta u sabin usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pesu gong gam lala wol isi lumen, biing lumen in wol tom isi. Tatawin na temtem tikii na biing ifasi tom lo. ");
INSERT INTO bjp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Gong gam nagogon tikas, tarama God ka nagogon gam sabin. ");
INSERT INTO bjp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wara le matngan nagogon arafa gam ta u usuf fal, matngan nagogon sau ae, God in ta fafis u usuf gam. Ke matngan sinang arafa gam tel u usuf fal, God in tel u sabin arae usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Isi sani o ka par fabiro piin na kolson mata tuamlik ma biil o wol na kiptin au ae na kolson matam tom? ");
INSERT INTO bjp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Male imel e kiptin au ae na kolson matam, isi sani o ka tara sing tuamlik le, ‘La iak tel ufu piin ae na kolson matam’? ");
INSERT INTO bjp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O tom gargaranmet, on tel ufu kiptin au ta bii ae na kolson matam ma aunbiing o ka par rokap mang ke, ok tel ufu fabiro piin mang ae na kolson mata tuamlik. ");
INSERT INTO bjp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gong gam ta foron tier ae i kalkaluu usuf foron puul. Ke gong gam lin foron rokap na kutkute kimi usuf foron boh. Tarama foron boh ri ka fosfose u, ke foron puul ri ka giliim fis ma ri ka ngaet falaulau gam. ");
INSERT INTO bjp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gamen sising, ke gamek kep u. Gamen im, ke gamek im tafe u. Gamen pispisih, ke matanfel ik sapeng isi gam. ");
INSERT INTO bjp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wara le fanu tikii ae ri sising, rin kep sani ae ri sising isi, ma se i im, in tafe sani i im isi, ke se i pispisih, matanfel in sapeng isi. ");
INSERT INTO bjp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Se lo gam, male ke kalalik i sising u isi beret ke in fen u bin ini ti fat? ");
INSERT INTO bjp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ke, male i sising u isi ti kok, ke ik fen u bin ini ti sii? ");
INSERT INTO bjp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Taftawa le gam tel sinang laulau la, isau le gam usum tom na ta foron rokap na fafen usuf berberat kimi. Pesu, gamen usum tom le Tama gam buuii na kukulii in ta foron rokap na fafen usuf fanu ae ri sising u. ");
INSERT INTO bjp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pesu, foron sinang tikii ae gam ier isi fanu rin tel u ulo gam, gamen tel u ulo ri. Matngan sinang igii, i e wara e nagogon ke Moses turan fafausum ken foron profet. ");
INSERT INTO bjp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gamen kau na matanfel ae i fiuuk. Wara le matanfel una fiu fitliu i laumet ma sal ulo i sapeng, ma fanu fuun ri kau lo. ");
INSERT INTO bjp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Isau le matanfel una liu i fabiro, ma sal ulo i fiuuk, ma temtem tikii sau ri tafe u. ");
INSERT INTO bjp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gamen tumarang isi foron profet famfabal. Rin kilkiliis ini punun sipsip ke rik tapiek sing gam, isau le tekentu lo le, ri foron puul ngalngaliaf. ");
INSERT INTO bjp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gamen iliim ri na fuan foim kiri. Fanu biil ri lus fuan wain la tina finau ae imel e si, biil. Ke biil sabin ri lus fuan fik la tina au ae i moseng, biil. ");
INSERT INTO bjp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ifasi sabin arae foron rokap na au tikii, ri luun foron rokap na fuan au la, ma foron au laulau ri luun foron fuan au laulau la. ");
INSERT INTO bjp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nenge au rokap biil ifasi in fatapiek fuan au laulau, ke nenge au laulau biil ifasi in fatapiek fuan au rokap, biil. ");
INSERT INTO bjp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Foron au tikii ae biil ri luun ti rokap na fua ri, rin pok faluut ri ma rik lin ri una yiif. ");
INSERT INTO bjp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ifasi sabin arae lon foron profet famfabal, gamen iliim ri na fuan foim kiri. ");
INSERT INTO bjp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Biil e fanu tikii ae ri foteng iau le ‘Kumguui, Kumguui,’ rin kau na matanfuntih buuii na kukulii, biil. Se sau ae i mi na wolwol ke Tata buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na biingen nagogon, fanu fuun rin tara sing iau aragii, ‘Kumguui, Kumguui, ini asam keme fafas ta arae profet, keme ka tel ufu ta foron tanwa laulau lon fanu ke keme ka fatapiek ta ifuun e tier an fabitit.’ ");
INSERT INTO bjp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Isau le iak fas ri aragii, ‘Biil ia to usum lo gam. Gam ti koseng iau. Gam foron tom tel sinang laulau!’ ");
INSERT INTO bjp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pesu, fanu tikii ae ri ongen pes foron orek kiak ma ri ka mi lo, ri arae nenge tom tasum ae i tel fel kia na olon fatkiis. ");
INSERT INTO bjp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Us ka luut, dan ka nor, ke kif ka aptih ma ka pipiis na fel ae, isau le biil i to luut, wara le waransinglen lo i ti na olon fatkiis. ");
INSERT INTO bjp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Fanu tikii ae ri ongen orek kiak ma biil ri mi lo, ri arae nenge talos ae i tel fel kia na kiin. ");
INSERT INTO bjp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Us ka luut, dan ka nor, kif ka aptih ma ka pipiis na fel ae, ke ka masuuf ma ka tamrabat laulau.” ");
INSERT INTO bjp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Aunbiing Iesu ka use tikii ta foron tier igii, gur na fanu aiwa ri ka lala bitit na fafausum kia, ");
INSERT INTO bjp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","wara le i fausum ri aragii kaltu ae God tom i ta rakrakai usuf i. Ma biil i fausum ri arae foron tom fafausum ini nagogon ri fausum ri la, biil. ");
INSERT INTO bjp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Aunbiing Iesu ka pu tinbae na baban pungpung, tara gur na fanu ri ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nenge kaltu ae i sem lepra ka la ma ka ilepul na mata Iesu, ke ka tarah, “Kumguui, male o ier isi, ke ok fafuu pes iau.” ");
INSERT INTO bjp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ke Iesu ka sawe lima, ka sigil u ke ka tara sing i aragii, “Ia ier isi. On fuuh!” Ma fanpil lepra ka rop koseng u. ");
INSERT INTO bjp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ke Iesu ka tara sing i aragii, “Ongen u, gong o fas tikas ini sani i tapiek lo wo. Isau le on la ma ok finngas pununfom sing pris, ke ok ta fafen kiam usuf God arae Moses i use ta u, isi fanu rik usum le sasem kiam ka rop tah.” ");
INSERT INTO bjp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Aunbiing Iesu ka tapiek na maleh na Kapernaum, nenge kabisit ken nenge mar e tom fapaket tina Rom ka la ke ka sising Iesu isi ti falupes. ");
INSERT INTO bjp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ka tarah, “Kumguui, nenge fafauun kiak i borong ini sasem na fel, pununfo i met ma i kalsakai tara fangungut.” ");
INSERT INTO bjp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ke Iesu ka tara sing i aragii, “Ian la ma iak faliu u.” ");
INSERT INTO bjp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Isau le kabisit ae ka kiliis u aragii, “Kumguui, biil ia kaltu rokap isi ok kau na fel kiak, biil. On orek sau, ke fafauun kiak ik liu. ");
INSERT INTO bjp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ia use u arae, wara le ia sabin ia kiis na piklin nagogon ken fale fanu, ke fale tom fapaket sabin ri kiis na pikling. Ia wuun nenge tom fapaket, ke ka la. Ia kam neng, ke ka la usuf iau. Ke ia ka fas nenge fafauun kiak le, ‘Tel tier igii,’ ke ka tel u.” ");
INSERT INTO bjp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aunbiing Iesu ka ongen u arae, ka bitit, ke ka fas fanu ae ri mimi la lo aragii, “Tekentu kanaka ia fas gam, biil biitom ia tafe tikas na Israel, unune kia i laumet arae ier igii. ");
INSERT INTO bjp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ia fas gam, fanu fuun rin la tina falifu ae pisiih i susupiek la wah ke tina falifu ae pisiih i sup la lo, ke rik kiis ma rik ien tura Abaram, Aisak ke Jekop na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Isau le berberat ae le kiri e matanfuntih, God in lin fasuu ri una kubunor, na falifu ae rin teng ma rik faririt ngisri.” ");
INSERT INTO bjp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ke Iesu ka fas kabisit ae aragii, “La mang. Foron tier in tapiek tom arae na unune kiam.” Ke na aunbiing tom ae, fafauun kia ka liu. ");
INSERT INTO bjp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aunbiing Iesu i kau na fel ke Pita, ka par tina antu Pita i borong kiniis ini gogor. ");
INSERT INTO bjp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu ka sigil lima ke gogor ka rop koseng u. Ka aptih ke ka sosok a Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na efef ae, ri ka lame turim ifuun e fanu ae tanwa laulau i susuef ulo ri usuf Iesu. Iesu i orek sau, ke foron tanwa laulau ri ka suu koseng fanu ae ma ka faliu fanu tikii ae ri sasem. ");
INSERT INTO bjp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tier igii i tapiek una fasuut orek ke God ae profet Aisaia i use ta u aragii, “I tom i kep ta foron sasem kirer ke ka tel ufu ta foron fangungut kirer.” ");
INSERT INTO bjp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aunbiing Iesu ka par gur na fanu ae ri ti kawil ta u, ke ka fas berberat na fafausum kia le rin sopaket dan kawil una nenge baba. ");
INSERT INTO bjp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ke nenge tom fafausum ini nagogon ka la usuf i, ke ka tarah, “Tom fafausum, ian mi lo wo una foron falifu tikii ae on la ulo.” ");
INSERT INTO bjp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ke, Iesu ka kiliis u aragii, “Foron puul aka imel e solsol salri, ke foron man tina mua imel e polpolo ri, isau le Kalalik ken Kaltu biil ti falifu sala una borong.” ");
INSERT INTO bjp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ke nenge kalalik na fafausum ka tara sing i aragii, “Kumguui, on sok ufu iau ta bii isi iak ile tata.” ");
INSERT INTO bjp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Isau le Iesu ka tara sing i aragii, “Mi lo iau, ma taftawa foron minet rik ile fafis foron minet kiri tom.” ");
INSERT INTO bjp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Namih, Iesu ka wof na mon ke berberat na fafausum kia ri ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Fanpil, nenge tara kif ka apti na dan kawil, ma panaf ka tamket una palgan mon. Isau le Iesu i masun. ");
INSERT INTO bjp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ke berberat na fafausum ri ka la, ri ka famat u ma ri ka tarah, “Kumguui, faliu kerer! Kerek dom mang igii!” ");
INSERT INTO bjp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka kiliis ri aragii, “Isi sani gam ka sokeh? Unune kimi i fabiro kanaka.” Ka aptih ma ka fakiing kif turan panaf, ke falifu ka siaroh tikii. ");
INSERT INTO bjp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ri ka bitit ke ri ka tarah, “Matngan kaltu arafa igii? Kif turan panaf ru wong sing i!” ");
INSERT INTO bjp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aunbiing Iesu ka tapiek na nenge baban dan kawil na nanal ken fan Gadara, ke iwu e kaltu ae tanwa laulau i susuef ulo ruh, ru ka suu tina foron matanfat una luun minet ke ru ka tafe u. Ru bengbeng, pesu biil tikas i la la lo e sal ae. ");
INSERT INTO bjp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ru ka ngangeh aragii, “Kalalik ke God, sani o ier isi on tel u ini kamah? Biil biitom i tapiek e aunbiing, ma isi sani o ka ier isi ta fangungut usuf kamah?” ");
INSERT INTO bjp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nenge tara u na boh ri suupsuup la fatat isi ri. ");
INSERT INTO bjp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ke foron tanwa laulau ae, ri ka sising Iesu aragii, “Male on tel ufu kemem, ke on wuun ufu kemem una u na boh ae.” ");
INSERT INTO bjp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ke Iesu ka fas ri aragii, “Gam la!” Foron tanwa laulau ae ri ka suuh ke ri ka susuef ulon foron boh ae. Ke foron boh tikii ae, ri ka fasasai pu na nenge bolonfam una dan kawil, ke ri ka kong. ");
INSERT INTO bjp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Fanu ae ri fofonoi la na foron boh ri ka fin ke ri ka la una maleh. Ri ka fafas ini sani i tapiek tah ke ri ka ususe sabin na sani i tapiek ta lo uner ae foron tanwa laulau ri susuef ta ulo ruh. ");
INSERT INTO bjp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ke fanu tikii na maleh ae ri ka la isi tafe Iesu. Ma aunbiing ri ka par u, ri ka piispiis u le in la koseng nanal kiri. ");
INSERT INTO bjp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu ka wof na mon, una nenge baban dan kawil, ke ka tapiek na maleh tutus kia. ");
INSERT INTO bjp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ke fale fanu ri ka kep nenge peo ini luuf usuf i. Aunbiing Iesu ka par unune kiri, ka tara sing peo ae aragii, “Keng kalalik, in rorokiis e balam. Foron sinang laulau kiam ia ka pa ufu tah.” ");
INSERT INTO bjp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Fale tom fafausum ini nagogon ri ka ongen orek igii, ke ri ka tara fis tom sing ri tom aragii, “Ier igii i orek laulau, i orek arae le i tom e God.” ");
INSERT INTO bjp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu ka usum ta na wolwol kiri ke ka tarah, “Isi sani ka mel e matngan wolwol laulau arae na balmi? ");
INSERT INTO bjp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Orek sa i malmuh? Ian tara le, ‘Ia ka pa ufu ta sinang laulau kiam,’ le ian tarah, ‘Aptih ma ok la’? ");
INSERT INTO bjp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Isau le ia use u arae, isi gamek usum le Kalalik ken Kaltu imel e rakrakai kia aga na piklinbat una pa ufu foron sinang laulau.” Ke ka tara sing peo ae aragii, “Aptih, kep mii salam ma ok la una fel kiam.” ");
INSERT INTO bjp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kaltu ae ka aptih ma ka la una fel kia. ");
INSERT INTO bjp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Aunbiing gur na fanu aiwa ri par sani i tapiek, ri ka sokeh ma ri ka sik asa God ae i ta ta matngan rakrakai igii usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aunbiing Iesu ka apti tinaiwa, ka par nenge kaltu asa e Metiu, i kiis ta na felun kep takiis. Ke ka tara sing i aragii, “Mi lo iau.” Metiu ka aptih ke ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aunbiing Iesu i ienien la na efef na fel ke Metiu, ifuun e foron tom kep takiis turan foron tom tel sinang laulau ri ka tapiek, ma ri ka ien tura Iesu, ke turan berberat na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aunbiing foron Farasi ri ka par u arae, ke ri ka diik berberat na fafausum kia aragii, “Isi sani ke tom fafausum kimi ka ien turan foron tom kep takiis, ke foron tom tel sinang laulau?” ");
INSERT INTO bjp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu ka ongen u ke ka tarah, “Fanu ae biil ri sasem, biil ri la la usuf dokta, biil. Fanu sau ae ri sasem ri la la usuf dokta. ");
INSERT INTO bjp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Isau le gam la, ma gamek im isi kamtinan orek ae na Buk na Gogoh ae i tarah, ‘Ia ier kanaka isi sinangun famais na foron tunmapek kimi usuf iau.’ Wara le biil ia la uga isi tawi pes foron tom tortores, biil. Ia la isi tawi foron tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Namih, berberat na fafausum ke Jon ri tapiek ke ri ka diik Iesu aragii, “Isi sani ke kemem turan foron Farasi keme ka fafel ma berberat na fafausum kiam biil?” ");
INSERT INTO bjp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu ka kiliis ri aragii, “Biil ifasi le foron ses ken kaltu ae i fakekel fuuh rin mamais aunbiing i kiis biitom naisri, biil. Nenge aunbiing in tapiek, ae rin kep ufu kaltu ae i fakekel fuuh koseng ri, ke aimang rik fafel. ");
INSERT INTO bjp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Biil tikas i mapmap la ini dangan kaen fuuh na olon kaen tofe, biil. Male in tel u arae, ke dangan kaen fuuh ae in paradadat ke ik tamsih tina kaen tofe ae, ma in tel tamrabat ae ik laumet mang tom. ");
INSERT INTO bjp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ke biil tikas i to wain fuu la una pungun dan tofe ae ri tel u ini punun meme, biil. Male in tel u arae, ke wain fuu ae in rabat punun meme ae, ke wain fuu in bereng ke punun meme ae ik laulau. Isau le ri to wain fuu la tom una palgan punun meme fuuh, isi ru turim ruk rokap.” ");
INSERT INTO bjp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aunbiing Iesu i ororek la biitom, nenge famfamu ka tapiek, ka ilepul na mata ma ka tarah, “Keng keleflik i am met sau. Isau le on la ma ok luun limam lo, isi ik liu fis.” ");
INSERT INTO bjp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu ka aptih ke ka la tura, ke berberat na fafausum sabin kia ri ka mi lo ruh. ");
INSERT INTO bjp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Biil i sawin ke nenge fifin ae i sem dah ifasi aragii nenge sangful ini u e bet, ka la tina pokta Iesu ke ka sigil sun kaen kia. ");
INSERT INTO bjp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wara le fifin ae i wol aragii, “Male ian sigil dolon kaen kia sau, ke ian liu.” ");
INSERT INTO bjp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu ka giliim, ka par fifin ae ke ka tarah, “Keng keleflik, in rorokiis e balam. Unune kiam tom i faliu o.” Ke na aunbiing tom ae, fifin ae ka liu. ");
INSERT INTO bjp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aunbiing Iesu ka kau na fel ken famfamu ae, ka par fanu ri kuf tulal ma falifu ka rigorigo ini tineng. ");
INSERT INTO bjp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ke ka tarah, “Gam suuh. Keleflik igii, biil i to met. I borong sau.” Isau le ri ka yongne u. ");
INSERT INTO bjp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aunbiing ri ka wuun fasuu ta gur na fanu ae, Iesu ka kau ke ka pose na liman keleflik ae, ke keleflik ae ka aptih. ");
INSERT INTO bjp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ke ususe na sani ae Iesu i tel ta u, ka sarara na falifu tikii ae. ");
INSERT INTO bjp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Aunbiing Iesu ka apti tinaiwa, iwu e kut ru ka mi lo, ke ru ka famam tautau aragii, “Kalalik ke Dewit! On mais kamah!” ");
INSERT INTO bjp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu ka kau na fel, ke iun kut ae ru ka la unaisa. Ke ka diik ru aragii, “Arafah, kamu unune le ifasi ian tel u?” Ke ru ka kiliis u aragii, “Iuu, Kumguui, kama unune.” ");
INSERT INTO bjp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka sigil matruh ke ka tarah, “In tapiek tom arae lo kamuh namin unune kimuh.” ");
INSERT INTO bjp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ke matruh ka rokap fis. Ma Iesu ka piispiis ruh aragii, “Gong kamu fas tikas ini tier igii.” ");
INSERT INTO bjp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Isau le ru ka la bin ke ru ka use sarara u na falifu tikii ae. ");
INSERT INTO bjp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aunbiing ru suuh, ke fale fanu ri ka kep nenge kaltu usuf Iesu ae tanwa laulau i susuef lo ma biil ifasi in orek. ");
INSERT INTO bjp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aunbiing Iesu ka tel ufu ta tanwa laulau ae, ke kaltu ae biil i orek la, ka orek mang. Gur na fanu ae ri ka wolpane, ma ri ka tarah, “Biil biitom ti tier aragii kere par u la na Israel.” ");
INSERT INTO bjp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Isau le foron Farasi ri ka tara le, “I tel ufu foron tanwa laulau la ini rakrakai ken laulaumet ken foron tanwa laulau.” ");
INSERT INTO bjp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu i soleng tikii piran maleh turan birbiron maleh ma ka tel fafausum na foron felun lotu kiri. Ka fafas ini Rokap na Fafas na matanfuntih ma ka faliu marmarsan sasem tikii. ");
INSERT INTO bjp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Aunbiing i par gur na fanu ae, ka mais ri, wara le wolwol kiri i rigorigo ma ri ka bilbiling, arae foron sipsip ae biil ti tom fofonoi kiri. ");
INSERT INTO bjp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ke ka tara sing berberat na fafausum kia aragii, “Ifuun kanaka e inen i matuk, isau le foron tom foim i tuul sau. ");
INSERT INTO bjp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pesu gamen sising usuf Kumguui na ilfafua, isi ik wuun ufu ti fale tom foim una lalamok na mok kia.” ");
INSERT INTO bjp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu ka tawi sangful ini u e kalalik na fafausum kia usuf i, ke ka ta rakrakai sing ri una tel ufu foron tanwa laulau ke una faliu fanu koseng marmarsan sasem tikii. ");
INSERT INTO bjp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Igii e asan sangful ini u e aposel: Tipes u lo Saimon, ae Iesu ka foteng u ini Pita, ke Enru tualik. Iun kalalik ke Sebedi, Jems ru latualik e Jon. ");
INSERT INTO bjp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ke Batolomiu, Tomas ke Metiu tom kep takiis. Jems kalalik ke Alfius, ke Tadius. ");
INSERT INTO bjp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon nenge Silot ke Iudas Iskariot ae in ta ufu Iesu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu ka wuun ufu sangful ini u e aposel ae ini fafanau igii: “Gong gam la na fatpoton fanu ae biil ri fan Iudaia, ke gong gam kau na ti maleh ken fan Samaria. ");
INSERT INTO bjp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gamen la sau usuf fan Israel ae ri arae foron sipsip ae ri rong tah. ");
INSERT INTO bjp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aunbiing gam la, gamen fafas ini orek igii: ‘Matanfuntih na kukulii ka fatat.’ ");
INSERT INTO bjp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ke gamek faliu foron sasem, fapti foron minet, fafuu fanu ae ri sem lepra, ke gamek tel ufu foron tanwa laulau. Gam kep foes ta rakrakai igii sing iau, ke gamen ta foes u usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gong gam siing ti goul le siliwa le kopa na pus kimi. ");
INSERT INTO bjp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ke gong gam kep ti sara, le ti kilkiliis sabin, le ti su le ti buk una la. Wara le i foim ken fanu tom una lupes nenge tom foim. ");
INSERT INTO bjp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Aunbiing gam tapiek na ti tara maleh, le fabiro maleh, gamen im isi ti kaltu rokap aiwa, ke gamek melmel tura papang na aunbiing gamen la. ");
INSERT INTO bjp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aunbiing gam kau na fel ae, gamen faorek pes ri ini siaroh. ");
INSERT INTO bjp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Male fanu na fel ae ri somangat pes gam, ke siaroh kimi in kiis aiwa. Male biil ri somangat pes gam, ke siaroh kimi in fis usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Male tikas biil i somangat pes gam le biil i ongen pes foron orek kimi, ke gamen pakte ufu piyiif tina foron kekmi aunbiing gam kang koseng fel le maleh ae. ");
INSERT INTO bjp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tekentu kanaka ia fas gam, na biingen nagogon in lilibiit e tatawin ae God in ta u usuf fan Sodom ke fan Gomora, na fangungut ae in ta u usuf fanu na maleh ae. ");
INSERT INTO bjp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ongen u, ia wuun gam arae foron sipsip ae ri la na fatpoton foron puul ngalngaliaf. Pesu, in poh e wol kimi arae foron sii ke gamen kalkaluu arae foron bun. ");
INSERT INTO bjp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Gamen tumarang isi fanu. Rin luse gam ke rik ta ufu gam na liman foron tom nagogon ma rik pis gam na foron felun lotu kiri. ");
INSERT INTO bjp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","I wara lo iau, ke rik dat gam isi gamek ti na matan foron famfamu na matanfuntih turan foron king, isi gamek famalal iau usuf ri ke usuf fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Isau le aunbiing rin luse gam, gong gam lala wol le sani gamen use u ke arafa gamen orek arae. Na aunbiing ae, God tom in fapitil wolwol kimi ini sani ae gamen use u, ");
INSERT INTO bjp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","wara le biil mang e gam ae gamen orek, biil. Tanwa Tama gam tom in luun orek na ngusmi. ");
INSERT INTO bjp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nenge kaltu in ta tualik isi rin siimete u, ke nenge tamankak in tel u arae lo ke kalalik. Berberat rin tapiek tuui ini foron temri ke foron tinri ma rik fas fanu isi rin siimete ri. ");
INSERT INTO bjp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Fanu tikii rin ememse gam, i wara lo iau. Isau le se i tifat una farfarop na aunbiing, God in faliu u. ");
INSERT INTO bjp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aunbiing ri ta fangungut sing gam na nenge maleh, ke gamen fin una nenge maleh. Tekentu kanaka ia fas gam, biil biitom gamen la tikii na foron maleh na Israel, ke Kalalik ken Kaltu ik tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nenge kalalik na fafausum biil i to laumet lon tom fafausum kia, biil. Ke nenge fafauun biil i to laumet lon laulaumet kia, biil. ");
INSERT INTO bjp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ifasi le kalalik na fafausum in tapiek arae tom fafausum kia ke fafauun ik tapiek arae laulaumet kia. Male taman fel ri foteng u ini Belsebul, ke fanu sabin na fel ae, rin foteng ri ini foron as ae i laulau mang tom. ");
INSERT INTO bjp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pesu, gong gam soke ri. Foron tier tikii ae i mumun in tapiek malal. Ke foron tier ae i kiis kuum tah, fanu rin usum lo. ");
INSERT INTO bjp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sani ia fas gam ini na kubunor, gamen use u na siat. Sani ia orek siksikau ini na balbalu gam, gamen soti na olon foron fel ma gamek perek ini usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gong gam soke fanu ae rin siimete pununfo gam ma biil ifasi rin siimete tanwa gam, gong. Gamen soke God ae i sau ifasi in falaulau tanwa gam turan pununfo gam na yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gam usum le, fanu ri fiil iwu e tomsiksik la ini nenge siliin sau. Isau le biil tikas lo ruh in luut una nanal, ae Tama gam biil i somangat ufu. ");
INSERT INTO bjp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Temtem tikii na olmi ae na paklu gam, God i usum na wewes tikii lo. ");
INSERT INTO bjp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pesu, gong gam sokeh. Liu kimi i temin tier lon ifuun e tomsiksik. ");
INSERT INTO bjp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Se i fapos iau na matan fanu, ke ia sabin ian fapos u na matan Tata buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Isau le se i fakawe ufu iau na matan fanu, ke ia sabin ian fakawe ufu na mata Tata buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gong gam wol le ia la isi ian ta siaroh aga na piklinbat. Biil ia to la isi ta siaroh, biil. Ia la ta isi ta popok una fapaket. ");
INSERT INTO bjp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ia la ta uga isi ‘nenge kalalik in ememse tama, nenge keleflik in ememse tina, ke nenge fifin ae i fakekel in ememse awa. ");
INSERT INTO bjp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Fanu na nenge matanfel ken nenge kaltu, rin tapiek arae tuui tom kia.’ ");
INSERT INTO bjp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Se i ier kanaka isi tama le tina lo iau, biil ifasi in tapiek kalalik na fafausum kiak. Ke se i ier kanaka isi ke kalalik le ke keleflik lo iau, biil ifasi in tapiek kalalik na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ke se biil i kusep aupaket kia ma ka mi lo iau, biil ifasi in tapiek kalalik na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Se i gong kale liu kia, liu kia in mangmangal koseng u, ma se i sok ufu liu kia wara lo iau, in liu. ");
INSERT INTO bjp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Se i somangat pes gam, i somangat pes iau. Ma se i somangat pes iau, i somangat pes ier ae i wuun ufu ta iau uga. ");
INSERT INTO bjp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Se i somangat pes nenge profet, wara le i nenge profet, ke in kep fifiil arae ken nenge profet. Ke se i somangat pes nenge tom tortores, wara le i nenge tom tortores, ke in kep fifiil arae ken nenge tom tortores. ");
INSERT INTO bjp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tekentu kanaka ia fas gam, male tikas i faumin tikas lon birbiron berberat na fafausum kiak igii, ini ti kap na dan mir, in kep fasuat kia tom.” ");
INSERT INTO bjp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aunbiing Iesu ka fausum ta sangful ini u e kalalik na fafausum kia, ka la tinaiwa isi ik fausum fanu ke ik fafas na foron maleh na Galili. ");
INSERT INTO bjp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aunbiing Jon i kiis na felun kamkabet ma ka ongen foron foim ke Karisito, ka wuun ufu fale berberat na fafausum kia isi diik u aragii, ");
INSERT INTO bjp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Arafah, wo mang e ier ae le in tapiek, le kemen nene biitom isi tikas aiwa?” ");
INSERT INTO bjp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ke Iesu ka kiliis ri aragii, “Gam fis ma gamek fas Jon ini foron sani gam ongen u ke gam par u: ");
INSERT INTO bjp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Foron kut ri ka par, foron peu ri ka la, fanu ae ri sem lepra ri ka tapiek fuuh, fanu ae i kutkut e foron balbalu ri, ri ka wong, foron minet ri ka liu fis ke foron lauu ri ka ongen Rokap na Fafas. ");
INSERT INTO bjp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","I kalok e ier ae i par foron tier igii ia fatapiek u, ma unune kia biil i luut.” ");
INSERT INTO bjp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aunbiing berberat na fafausum ke Jon ri ka la tah, Iesu ka fas gur na fanu ae ini Jon, aragii, “Sani gam la isi par u, aunbiing gam la ta usuf Jon na falifu foes? Awii gam la sau isi alim nenge aun ngan ae kif i kufkufe u? ");
INSERT INTO bjp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Male biil, sani gam la ta isi par u? Nenge kaltu ae i kilkiliis ta ini foron rokap na kilkiliis? Biil. Gam par u, fanse ae ri kilkiliis ini foron rokap na kilkiliis ri kiis la na foron fel ken foron king. ");
INSERT INTO bjp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ke sani gam la isi par u? Nenge profet? Tekentu tom, ia fas gam, Jon tom i laumet lon foron profet tikii. ");
INSERT INTO bjp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ri siit ta u na Buk na Gogoh ulo aragii, ‘Ian wuun famu tom fafas kiak lo wo, ae in fageges sal salam.’ ");
INSERT INTO bjp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tekentu kanaka ia fas gam, Jon Tom tel Bapitaiso i laumet kanaka lon fanu tikii ae ri fang ta ri, isau le ier ae i fabiro kanaka na matanfuntih buuii na kukulii, i laumet tom lo Jon. ");
INSERT INTO bjp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tipes u na aunbiing ae Jon Tom tel Bapitaiso i fafas, papang igii, fanu ri fapaket isi rin kau una matanfuntih na kukulii, ke foron rakrakai na fanu ri ngongos isi rin kep u. ");
INSERT INTO bjp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Foron profet tikii turan nagogon ke Moses, ri famalal orek ke God papang na aunbiing Jon ka tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ke male gam ier isi somangat pes orek kiri, Jon sau i e Elaija ae ri use ta u le in tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Se imel e balbalu, i rokap le in wong ini. ");
INSERT INTO bjp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Sani ian fatof ulul na fanu igii ini? Ri arae berberat ae ri kiis na salan la turim ken fanu ma ri ka tautau usuf fale berberat aragii: ");
INSERT INTO bjp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aunbiing kemem kuf tulal usuf gam, ke biil gam guui. Ke aunbiing kemem sek nenge seksek an mamais, ke biil gam teng.’ ");
INSERT INTO bjp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aunbiing Jon i tapiek, biil i lala ien la ke biil i umin wain la, pesu ri ka tara le, ‘I mel e tanwa laulau lo.’ ");
INSERT INTO bjp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ke aunbiing Kalalik ken Kaltu i tapiek, ka ien ke ka yin, ke ri ka tarah, ‘Par u, kaltu igii i nenge tom kiimkiim ke tom ininmet, i talan foron tom kep takiis turan foron tom tel sinang laulau.’ Isau le foim ke God i finngas u tom le i polo na wol tekentu.” ");
INSERT INTO bjp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ke Iesu ka ngaliaf ulon fanu na foron maleh ae i fatapiek ta ifuun e tier an fabitit lo, wara le biil ri kiliis liu. ");
INSERT INTO bjp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ka tarah, “Kiskam kanaka sing gam fan Korasin! Kiskam kanaka sabin sing gam fan Betsaida. Male rin fatapiek ta foron tier an fabitit igii usuf fan Tair ke fan Saidon, arae ri fatapiek ta u na matmi, awii pakanini tom rin kiliis ta liu ke rik mamais. Ke rik kilkiliis ini kaen na mamais ma rik saba ini piyiif. ");
INSERT INTO bjp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ia fas gam, na biingen nagogon, tatawin ae God in ta u usuf gam in laumet na tatawin ae in ta u usuf fan Tair ke Saidon. ");
INSERT INTO bjp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ke arafa lo gam, fan Kapernaum, gam wol le rin sik falaumet gam tom ubae suusuu na kukulii? Biil. Rin lin fapu gam una tara yiif. Male foron tier an fabitit igii ia fatapiek ta u na matmi, rin fatapiek ta u sabin na Sodom, ke igii Sodom in kiis biitom. ");
INSERT INTO bjp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Isau le tekentu kanaka ia fas gam, na biingen nagogon in lilibiit e tatawin ae God in ta u usuf fan Sodom, na tatawin ae in ta u usuf gam.” ");
INSERT INTO bjp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na aunbiing ae, Iesu ka tarah, “Tata, o Kumguui na kukulii ke na piklinbat tikii, ia usefages o wara le o fun ta foron tier igii sing foron tom tasum ke sing ri ae ri usum na marmarsan tier, ma o ka finngas u usuf fanu ae ri arae birbiron berberat. ");
INSERT INTO bjp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tekentu kanaka Tata, i wara le o ier tom isi arae. ");
INSERT INTO bjp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tata ka ta tikii ta foron tier usuf iau. Biil tikas i usum lon Kalalik, Tama keskes sau. Ke biil sabin tikas i usum lo Tama, Kalalik keskes sau turan fanse ae Kalalik i ier isi in famalal Tama usuf ri. ");
INSERT INTO bjp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gam tikii ae i mut e fo gam ma gam ngar foron tatawin, gam la usuf iau ke iak famange gam. ");
INSERT INTO bjp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gamen kusep kiip kiak ma gamek kep fafausum sing iau, wara le sinangung i fofo ma ia fabiro pes iau la tom, ke gamek tafe mangeh na tanwa gam. ");
INSERT INTO bjp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wara le kiip ae ian fakuskusep gam ini i malmuh ma i malalah.” ");
INSERT INTO bjp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na aunbiing ae, Iesu ka soleng foron mok na wit na Biingen Mangeh. Berberat na fafausum kia ri ka fitol ke ri ka tipes lus fale kutun wit ma ri ka ien u. ");
INSERT INTO bjp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aunbiing foron Farasi ri ka par u, ri ka tara sing i aragii, “Par u, aunbiing berberat na fafausum kiam ri tel u arae, ri ka lek ta nagogon na Biingen Mangeh.” ");
INSERT INTO bjp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ke Iesu ka kiliis ri aragii, “Arafah, biil biitom gam wes ususe na sani ae Dewit i tel ta u, aunbiing i turan fanu ae ri batme u ri fitol? ");
INSERT INTO bjp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I kau na fel ke God ma i turan fanu sabin ae ri batme u, ri ka ien foron beret ae foron pris ri ka ta ta u arae fafen usuf God. Na nagogon, biil i tortores le fanu foes rin ien foron beret ae, foron pris sau rin ien u. ");
INSERT INTO bjp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Arafah, biil biitom gam wes u ae na Buk na Nagogon le foron pris ri foim la na Felun Tunmapek na Biingen Mangeh? Isau le biil ri tiu ri la. ");
INSERT INTO bjp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ia fas gam, igii sau e ier ae i laumet kanaka na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Buk na Gogoh i use u aragii, ‘Ia ier kanaka isi sinangun famais, na foron tunmapek kimi usuf iau.’ Male gam usum na kamtinan foron orek ae, ke biil ifasi gamen tiu fanse ae biil ri lek nagogon. ");
INSERT INTO bjp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wara le Kalalik ken Kaltu i e Kumguui na Biingen Mangeh.” ");
INSERT INTO bjp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu ka la koseng falifu ae ma ka kau na felun lotu kiri. ");
INSERT INTO bjp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nenge kaltu aiwa, nenge lima i met. Ri ka ier isi tiu Iesu, pesu ri ka diik u aragii, “Arafah, na nagogon kirer i tortores le rin faliu tikas na Biingen Mangeh, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ke ka fas ri aragii, “Male tikas lo gam imel e sipsip kia i luut siluung na nenge toh na Biingen Mangeh, ke arafah, biil in pose lo ma ik dat ufu? ");
INSERT INTO bjp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Liu ken nenge kaltu i laumet na liu ken nenge sipsip. Pesu, i tortores le keren tel rokap na sinang na Biingen Mangeh.” ");
INSERT INTO bjp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ke ka fas kaltu ae aragii, “Sawe limam.” Ka sawe lima, ke lima ka rokap fis sabin, arae nenge lima. ");
INSERT INTO bjp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Isau le, foron Farasi ri ka suu tina felun lotu ma ri ka puput isi rin siimete Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Aunbiing Iesu ka usum ta le ri puput isi siimete u, ka la koseng falifu ae. Fanu fuun ri mi lo ma ka faliu ri tikii ae ri sasem. ");
INSERT INTO bjp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ke ka fakiing ri le gong ri use famalal u le i e seh. ");
INSERT INTO bjp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I use u arae una fasuut orek ae profet Aisaia i use ta u le: ");
INSERT INTO bjp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Igii e tom foim kiak ae ia tim pes ta u, ier ae ia ier kanaka isi, ma ia laes ini. Ian luun Tanwang lo, ma in famalal nagogon ae i tortores usuf foron funmat tikii na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Biil in fapit le in perek, ma biil rin ongen kine na foron sun sal. ");
INSERT INTO bjp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Biil in bayi ti fifih ae i takukuuw ke biil in kuf mete paupau na lam ae biil i sok rokap. In tel u tom arae papang na aunbiing in fatapiek tortores na nagogon usuf fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ke foron funmat tikii na piklinbat, rik unune na asa.” ");
INSERT INTO bjp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ri ka lame nenge kaltu usuf Iesu ae tanwa laulau i susuef lo, i kut ma biil i orek la. Ke Iesu ka faliu u, ke ka par ma ka orek sabin. ");
INSERT INTO bjp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Fanu tikii ri ka bitit ma ri ka tarah, “I sangan e Kalalik ke Dewit?” ");
INSERT INTO bjp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Isau le foron Farasi ri ka ongen u ma ri ka tarah, “Kaltu igii i tel ufu foron tanwa laulau la ini rakrakai ke Belsebul, ae i laulaumet ken foron tanwa laulau.” ");
INSERT INTO bjp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu ka usum ta na foron wolwol kiri, ke ka tarah, “Male nenge matanfuntih in fapaket fis tom ini, matanfuntih ae in laulau sikit. Male fanu tina nenge maleh, le na nenge matanfel ri fapaket fis tom ini ri, biil mang rin kiis turim sabin. ");
INSERT INTO bjp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Male Satan i fes ufu Satan ma ka fapaket fis tom ini, ke matanfuntih kia in ti rakrakai arafah? ");
INSERT INTO bjp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Male ia fes ufu foron tanwa laulau ini rakrakai ke Belsebul, ke fanu kimi ri fes ufu foron tanwa laulau la ini rakrakai kiseh? Fanu kimi tom rin nagogon gam. ");
INSERT INTO bjp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Isau, male ia fes ufu foron tanwa laulau ini Tanwa God, ke gamen usum le matanfuntih ke God ka tapiek ta usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ke biil sabin tikas ifasi in kau na fel ken nenge rakrakai na kaltu isi ik sukuum foron minmara, male biil i kabet famu kaltu ae. In kabet famu u ke nami ik suksukuum na fel kia. ");
INSERT INTO bjp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Se ae biil i foim turang, i tikale foim kiak. Ma se ae biil i lupes iau na tel turim fanu, i fes sarara ri la. ");
INSERT INTO bjp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pesu ia ka fas gam le, God ifasi in pa ufu foron sinang laulau tikii ke foron orek laulau tikii ae fanu ri tel u la, isau le se i orek laulau ulon Tanwa Kalkaluu, God biil in to pa ufu sinang laulau kia. ");
INSERT INTO bjp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ke male tikas in use ti orek laulau ulon Kalalik ken Kaltu, God in pa ufu. Isau le se i orek laulau ulon Tanwa Kalkaluu, God biil in to pa ufu sinang laulau kia, na liu igii ke na liu sabin ae na mih. ");
INSERT INTO bjp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Male nenge au i rokap, ke fua in rokap, ke male au i laulau, ke fua in laulau, wara le rin iliim nenge au na fua. ");
INSERT INTO bjp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gam foron natun sii fafangaet! Gamen use foron tier rokap arafa aunbiing gam fanu laulau? Wara le orek ae i suu tina ngusun nenge kaltu, i famalal sinang ae ifuun na liu kia. ");
INSERT INTO bjp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Rokap na kaltu i finngas rokap na sinang la tina foron rokap na tier ae na liu kia. Ke kaltu laulau sabin i finngas sinang laulau la tina foron tier laulau ae na liu kia. ");
INSERT INTO bjp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Isau le ia fas gam, foron orek laulau tikii ae fanu ri use ta u, God in diik ri isi ae na biingen nagogon. ");
INSERT INTO bjp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aunbiing on ti na nagogon, foron orek kiam tom in fasengsegeng o le in falaulau o.” ");
INSERT INTO bjp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Namih, fale Farasi turan fale tom fafausum ini nagogon ri ka fas u aragii, “Tom fafausum, keme ier le on fatapiek ti fakileng, isi kemek par u.” ");
INSERT INTO bjp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ke ka kiliis ri aragii, “Gam na ulul igii, gam fanu laulau, gam la koseng God arae nenge fifin i lin antu ma ka telpes nenge kaltu sabin. Gam ier isi gamen par ti fakileng, isau le biil ti fakileng in tapiek usuf gam, fakileng sau ke profet Jona. ");
INSERT INTO bjp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Arae Jona i kiis ta na balan nenge tara kok na ituul e biing ke ituul e wor, ke Kalalik ken Kaltu sabin in kiis na palgan nanal na in tuul e biing ke in tuul e wor. ");
INSERT INTO bjp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na biingen nagogon, fan Niniwe rin tih ma rik pot matan fanu na ulul igii, wara le ri kiliis ta liu kiri sau na fafas ke profet Jona. Ongen u, igii sau e ier ae i laumet kanaka lo Jona. ");
INSERT INTO bjp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na biingen nagogon, kuin tina Seba in tih ma ik pot matan fanu na ulul igii, wara le i la tom tina tapak isi ongen tasum ke king Solomon. Ongen u, igii sau e ier ae i laumet kanaka lo king Solomon. ");
INSERT INTO bjp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Aunbiing nenge tanwa laulau i suu koseng nenge kaltu, ik la una foron falifu sengseng isi ik im isi ti falifu una mangeh. Ma aunbiing biil i tafe ti falifuh, ");
INSERT INTO bjp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ik tarah, ‘Ian fis tom una fel ae ia la koseng ta u.’ Ma aunbiing in tapiek, ik par u le fel ae i pungu, ri ka sa fakasi ta u ma ri ka tumarnge ta u. ");
INSERT INTO bjp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ke ik la ma ik telpes in fit sabin e tanwa laulau ae ri laulau kanaka mang tom lo. Ri tikii rik kau na fel ae, ke rik mel aiwa. Pesu, liu ken kaltu ae ik laulau kanaka mang tom na liu famu kia. In fasi sau arae usuf fanu laulau na ulul igii.” ");
INSERT INTO bjp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aunbiing Iesu i ororek la biitom usuf fanu, tina turan foron tualik ri ka la, ke ri ka soti awii na maleh, wara le ri ier isi faorek u. ");
INSERT INTO bjp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ke nenge kaltu ka fas Iesu aragii, “Par u, tinam turan foron tuamlik ae na maleh ma ri ier isi faorek o.” ");
INSERT INTO bjp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu ka kiliis u aragii, “Se e tinang ma fanse e foron tuaklik?” ");
INSERT INTO bjp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ka tus berberat na fafausum kia ke ka tarah, “Par u, igii e tinang ke foron tuaklik. ");
INSERT INTO bjp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wara le se sau i mi na wolwol ke Tata buuii na kukulii, i sau e tuaklik, feneklik ke tinang.” ");
INSERT INTO bjp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na biing tom ae, Iesu ka suu tina fel ke ka kiis na baban dan kawil. ");
INSERT INTO bjp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tara gur na fanu ri ka la usuf i, pesu ka wof na nenge mon ke ka kiis lo, ma tara gur na fanu ae ri ka soti na kiin. ");
INSERT INTO bjp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ke ka fas ri ini ifuun e tier ini orek fatoftof ma ka tarah, “Ongen u! Nenge tom soso i la isi saprai kutun wit. ");
INSERT INTO bjp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aunbiing i sapsaprai, fal ka luut tole sal ke foron man ri ka wofpiek ke ri ka ting tikii u. ");
INSERT INTO bjp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fal ka luut na olon fatfat ae biil i laumet e nanal lo. Ka rarau sape, wara le nanal biil i to laumet. ");
INSERT INTO bjp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Isau le aunbiing pisiih i popos, ka pose ri ke ri ka mang, wara le biil ti bauli. ");
INSERT INTO bjp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fale kutun wit ka luut na palgan foron finau ae imel e si. Aunbiing finau i kuum, ka kuruung foron wit. ");
INSERT INTO bjp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Isau le fale kutun wit ka luut na nanal rokap ke ka fua, fal nenge mar e fua, fal iwon e sangful ke fal ituul e sangful. ");
INSERT INTO bjp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Se imel e balbalu, i rokap le in wong ini.” ");
INSERT INTO bjp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Berberat na fafausum kia ri ka la unaisa ma ri ka diik u aragii, “Isi sani o ka orek la usuf fanu ini foron orek fatoftof?” ");
INSERT INTO bjp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ke ka kiliis ri aragii, “God i ta ta tasum usuf gam isi gamen usum na foron tier ae i kum na matanfuntih tinbae na kukulii, isau le biil i ta u usuf fanu tikii igii. ");
INSERT INTO bjp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Se imel e tasum kia, rin falaumet tasum ae sing i, isi tasum kia ik lala laumet. Isau le se ae biil ti tasum kia, rin tel ufu fabiro tasum ae sing i. ");
INSERT INTO bjp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ia orek usuf ri ini orek fatoftof, wara le: ‘Taftawa ri par, isau le biil ri par failiim ti tier, ri wong, isau le biil ri ongen failiim ti tier ke biil ri malal ulo.’ ");
INSERT INTO bjp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ka suut mang e orek ke profet Aisaia ulo ri ae i use ta u aragii: ‘Gamen ongne ma gamek ongne, isau le biil tom gamen malal. Ke gamen par ma gamek par, isau le biil tom gamen iliim ti tier. ");
INSERT INTO bjp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wara le balan fanu igii ka kutkut tah ke biil ifasi rin wong ini balbalu ri ma matri ka kut tah. Tarama ri ka par failiim ini foron matri, ri ka ongen failiim tier ini balbalu ri ke wolwol kiri ik malal ma rik fis usuf iau ma iak faliu ri.’ ");
INSERT INTO bjp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Isau le gam kalok, wara le gam par ini kolson matmi, ke gam wong ini balbalu gam. ");
INSERT INTO bjp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tekentu kanaka ia fas gam, ifuun e profet turan foron tom tortores, ri kalkal ta isi rin par sani gam par u, isau le biil ri par u. Ke ri kalkal ta isi rin ongen sani gam ongen u, isau le biil ri to ongen u. ");
INSERT INTO bjp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Gam ongen u, igii e kamtinan orek fatoftof lon tom soso. ");
INSERT INTO bjp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aunbiing tikas i ongen Rokap na Fafas na matanfuntih ma biil i malal lo, i arae kutun wit ae i luut tole sal. Ke kaltu laulau ka la ma ka tel ufu orek ae ri so ta u na bala. ");
INSERT INTO bjp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ke kutun wit ae i luut na olon fatfat, i arae nenge kaltu ae i ongen orek ma fanpil ka somangat pes u ini laes. ");
INSERT INTO bjp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Isau le biil i ti dolo, arae wit ae biil ti bauli. Ka luut sape sau, aunbiing i tafe tatawin ke aunbiing fanu ri ta fangungut sing i, wara na orek ke God. ");
INSERT INTO bjp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kutun wit ae i luut na palgan foron finau ae imel e si, i arae nenge kaltu ae i ongen orek, isau le i mamais kanaka isi foron tier tinaga na piklinbat ma sinangun ier isi in fuun e minsik i fabal u, ke ka aung orek ke God, arae finau i rarau kale wit, ke biil i fua. ");
INSERT INTO bjp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ke kutun wit ae i luut na nanal rokap, i arae kaltu ae i ongen orek ma ka malal lo. I arae wit ae i luun nenge mar, le iwon e sangful le ituul e sangful e fua.” ");
INSERT INTO bjp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu ka fas ri sabin ini nenge orek fatoftof aragii, “Matanfuntih na kukulii i arae nenge kaltu ae i la isi so foron rokap na kutun wit na mok kia. ");
INSERT INTO bjp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Isau le aunbiing fanu tikii ri borong, tuui kia ka la ma ka so foron kutun fifih laulau na fatpoton foron kutun wit, ke ka la. ");
INSERT INTO bjp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aunbiing foron kutun wit ri ka kuum ma fatat rik fua, foron fifih laulau sabin ri ka kuum turim tura. ");
INSERT INTO bjp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ke foron tom foim ken taman mok ae ri ka la usuf i ma ri ka fas u aragii, ‘Ier, o so ta foron kutun wit rokap sau na mok kiam. Tinga sabin e foron fifih laulau ae ka kuum na mok kiam?’ ");
INSERT INTO bjp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ka kiliis ri aragii, ‘Nenge tuui i tel u e matngan sinang ae.’ “Ke foron tom foim kia ri ka diik u aragii, ‘Arafah, o ier le kemen la ma kemek fut sarara ufu ri?’ ");
INSERT INTO bjp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ka tikale ri le, ‘Gong, tarama gam ka fut saraf foron wit sabin turan foron fifih laulau. ");
INSERT INTO bjp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Taftawa bii ruk kuum turim papang na biingen lulus. Na aunbiing mang ae ian fas foron tom lulus le: Gamen fut turim foron fifih laulau famu, ke gamek diit buta, isi gamek fasok ri, namih gamek lus turim foron wit ke gamek siing u na papah kiak.’” ");
INSERT INTO bjp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ke ka fas ri sabin ini nenge orek fatoftof aragii, “Matanfuntih na kukulii i aragii kutun mastet ae nenge kaltu i kep u ma ka so u na mok kia. ");
INSERT INTO bjp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kutu i fabiro kanaka na foron kutun au tikii, isau le aunbiing i kuum, ka tapiek nenge au, ma ka liu ufu foron au tikii na palgan mok ae ri so u la. Ma foron man na mua ri ka tel polpolo ri na foron aka.” ");
INSERT INTO bjp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu ka fas ri sabin ini nenge orek fatoftof aragii, “Matanfuntih na kukulii i arae is ae nenge fifin i kep u ma ka ikis u turan ifuun e palawa, ma palawa tikii ae ka sut.” ");
INSERT INTO bjp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Foron tier tikii igii Iesu i use u usuf gur na fanu ini foron orek fatoftof sau. Biil i use famalal ti tier usuf ri, biil. I fafas usuf ri ini foron orek fatoftof sau. ");
INSERT INTO bjp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I use u arae una fasuut orek ke profet ae i use ta u aragii: “Ian orek ini foron orek fatoftof. Ian use foron tier ae ri mumun, tipes u tom na aunbiing God i fakiis ta piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Namih, Iesu ka la koseng gur na fanu ae ma ka kau na fel. Berberat na fafausum kia ri ka la usuf i ma ri ka diik u isi in famalal kamtinan orek fatoftof na foron fifih laulau ae ri kuum na mok. ");
INSERT INTO bjp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ke ka fas ri aragii, “Kaltu ae i so kutun wit, i e Kalalik ken Kaltu. ");
INSERT INTO bjp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mok i e piklinbat, ke foron kutun wit, ri arae fanu tinbae na matanfuntih na kukulii. Foron fifih laulau ri arae berberat ken kaltu laulau. ");
INSERT INTO bjp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ke tuui ae i so ta fifih laulau, i e Satan. Ma aunbiing na lulus e farfarop na biing, ke foron tom lulus e foron angelo. ");
INSERT INTO bjp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Foron fifih laulau ae ri fut turim ri ma ri ka fasok ri na yiif, in tara sabin arae na farfarop na biing. ");
INSERT INTO bjp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kalalik ken Kaltu in wuun ufu foron angelo kia, isi rik rap ufu foron tier tikii tina matanfuntih kia, ae i falamlam fanu la isi tel sinang laulau turan foron tom tel sinang laulau tikii. ");
INSERT INTO bjp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ke rik lin ri una tara yiif, ae rin teng ma rik faririt ngisri aiwa. ");
INSERT INTO bjp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Foron tom tortores rik popos arae pisiih na matanfuntih ke Temri. Se imel e balbalu, i rokap le in wong ini. ");
INSERT INTO bjp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Matanfuntih na kukulii i arae nenge rokap na tier ae ri fun ta u na nenge falifuh. Aunbiing nenge kaltu i im tafe u, ka fun kiliis u sabin, ke ka la ini laes isi sufii tikii foron minmara, ma pitkalang lo ik fiil pes sun falifu ae ini. ");
INSERT INTO bjp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ke matanfuntih na kukulii, i arae nenge kaltu sabin i im isi foron rokap na kolson matanwah. ");
INSERT INTO bjp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aunbiing ka tafe ta nenge kolson matanwah ae i rokap kanaka, ka la ma ka sufii tikii foron minmara, ma pitkalang lo ik fiil pes kolson matanwah ae ini. ");
INSERT INTO bjp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Matanfuntih na kukulii sabin i arae nenge ubiin ae ri lin ta u na palgantes, ma marmarsan kok tikii ri ka liil lo. ");
INSERT INTO bjp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aunbiing ubiin ka fuun, foron tom lin ubiin ri ka dat famasa u, ri ka kiis ma ri ka fule pes fal rokap, ke ri ka siing u na foron sara. Isau le fal laulau ri ka lin u. ");
INSERT INTO bjp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","In tara sabin arae na farfarop na biing. Foron angelo rin la, ma rik fule ufu fanu laulau koseng foron tom tortores. ");
INSERT INTO bjp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ke rik lin fanu laulau una tara yiif ma aiwa, rin teng ke rik faririt ngisri.” ");
INSERT INTO bjp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu ka diik ri aragii, “Arafah, gam malal sabin na sani ae ia ka use ta u?” Ri ka kiliis u aragii, “Iuu.” ");
INSERT INTO bjp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ke ka fas ri aragii, “Foron tom fafausum ini nagogon tikii ae ri ka kep tasum ta na matanfuntih na kukulii, ri arae nenge taman fel ae i fasuu foron minsik tina fel kia, fal fuuh turan fal tofe.” ");
INSERT INTO bjp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Aunbiing Iesu ka use tikii ta foron orek fatoftof ae, ka la koseng maleh ae ");
INSERT INTO bjp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ma ka fis una maleh tutus kia. Ka fausum fanu aiwa na felun lotu kiri, ke ri ka lala bitit ma ri ka tarah, “Kaltu igii i kep tasum igii tingah? Ke i kep rakrakai una fatapiek foron tier an fabitit igii tingah? ");
INSERT INTO bjp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kere usum sau le, tama i nenge tom tel fel ke tina e Maria, foron tualik e Jems, Josep, Saimon ke Iudas ");
INSERT INTO bjp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ke foron fenelik igii sau na aisrer. Ma i kep foron tier igii tingah?” ");
INSERT INTO bjp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pesu biil mang ri laes ini. Isau le Iesu ka fas ri aragii, “Nenge profet ri bulat la lo na fale maleh keskes, isau le na maleh tutus kia ke na matanfel kia tom, biil ri bulat la lo.” ");
INSERT INTO bjp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ke biil i fatapiek ifuun e tier an fabitit aiwa, wara le biil ri unune lo. ");
INSERT INTO bjp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na aunbiing ae, Erot, famfamu na matanfuntih na Galili, ka ongen ususe lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ke ka fas foron tom foim kia aragii, “Jon Tom tel Bapitaiso sau ae. Ka liu fis sabin, pesu ka mel e rakrakai kia una fatapiek foron tier an fabitit.” ");
INSERT INTO bjp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Pakanini Jon Tom tel Bapitaiso i fas ta Erot aragii, “Biil i tortores arae le o ka telpes Erodias antu Filip, tuamlik.” Pesu, Erot ka fas foron tom fapaket kia isi luse u. Ri ka kabet u ma ri ka fakau u na felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ke Erot ka ier isi siimete Jon, isau le i soke fanu, wara ri use u le Jon i nenge profet. ");
INSERT INTO bjp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na biingen pang ke Erot, keleflik ke Erodias ka guui na matan foron ses ke Erot. Ke Erot ka lala laes ini keleflik ae ");
INSERT INTO bjp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ma ka falimlim aragii, “Ia falimlim le, sani on sising iau isi, ian ta u.” ");
INSERT INTO bjp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Keleflik ae ka fas Erot aragii, “Luun paklu Jon Tom tel Bapitaiso na ti pelet ma ok ta u usuf iau.” I use u arae, wara le tina i fas ta u le in fas Erot arae. ");
INSERT INTO bjp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King i ongen sising ken keleflik ae ke ka purngis e bala. Isau le, wara na falimlim kia, ke na foron ses ae, pesu ka tel fasuut sising ken keleflik ae. ");
INSERT INTO bjp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka fawuun isi rin bus ufu paklu Jon awii na felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ri ka luun paklu na nenge pelet ke ri ka ta u usuf keleflik ae, ke ka kep u usuf tina. ");
INSERT INTO bjp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Berberat na fafausum ke Jon ri ka la, ri ka kep pununfo, ke ri ka ile u. Nami ri ka la, ke ri ka fas Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Aunbiing Iesu ka ongen ta u le Jon ka met tah, i keskes ka wof na nenge mon una nenge sunbiil ma ka kiis aiwa. Ma aunbiing fanu ri ongen u arae, ri ka la tina foron maleh kiri ma ri ka tole sal na mi. ");
INSERT INTO bjp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aunbiing i masah ma ka par tara gur na fanu, ka mais ri ma ka faliu fanu ae ri sasem. ");
INSERT INTO bjp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka efef mang, ke berberat na fafausum kia ri ka la usuf i ma ri ka fas u aragii, “Kiptin biil sau igii ma ka efef tah. Wuun ufu gur na fanu mang igii, isi rik la una foron maleh ma rik fiil inen ari.” ");
INSERT INTO bjp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ke Iesu ka kiliis ri aragii, “Rin la isi sah? Gam fen ri ini ti inen.” ");
INSERT INTO bjp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ke ri ka tara sing i aragii, “Ilim sau e beret turan iwu e kok igii sing kemem.” ");
INSERT INTO bjp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ke Iesu ka fas ri aragii, “Kep u uga usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Namih, ka fas gur na fanu ae isi rin kiis na olon fifih. Ke ka kep ilim e beret turan iwu e kok ae, ka tar una kukulii ke ka fotrokap lo usuf God. Ka sibik foron beret ae, ke ka ta u usuf berberat na fafausum kia, ma ri ka tulus fanu ini. ");
INSERT INTO bjp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ri tikii ri ien ma ri ka mas. Namih, berberat na fafausum kia ri ka siing fafuun nenge sangful ini u e kes ini foron tigan inen ae ri mas tiga. ");
INSERT INTO bjp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wewes lon fanu tamat ae ri ien, ifasi aragii ilim e arip, ma biil ri wes kelefin turan berberat. ");
INSERT INTO bjp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Fanpil Iesu ka wuun famu berberat na fafausum kia isi rik wof na mon una nenge bulin dan kawil. Ma ka kiis fis isi wuun sarara fanu ae. ");
INSERT INTO bjp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Aunbiing ka wuun ufu ta ri, ka tatkau keskes una nenge pungpung isi sising. Ka efef worwor mang, ma i keskes sau tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aunbiing mon ka tapak ta tina kiin, ka panlak na panaf, wara le kif i pipiis tina famu na mon. ");
INSERT INTO bjp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na piklin ien, Iesu ka la na olon dan usuf ri. ");
INSERT INTO bjp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aunbiing berberat na fafausum kia ri par u i la na olon dan, ri ka ngangeh ini sokeh aragii, “Nenge kinit apiek!” ");
INSERT INTO bjp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Fanpil Iesu ka fas ri aragii, “Gong gam sokeh! In rorokiis e balmi. Iau sau igii.” ");
INSERT INTO bjp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ka kiliis u aragii, “Kumguui, male wo sau, ke ok tawi iau, isi ia sabin iak la na olon dan unawii naisam.” ");
INSERT INTO bjp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ke Iesu ka tarah, “La ugapiek.” Pita ka wof pu tina mon ke ka la na olon dan usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Isau le aunbiing i par tara kif, ka nangnangih ke ka tipes dom, ma ka tautau aragii, “Kumguui, faliu iau!” ");
INSERT INTO bjp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Fanpil Iesu ka sawe lima ke ka sik fapti u una mawe ma ka tara sing i aragii, “Unune kiam i fabiro kanaka. Isi sa ka wu e wolwol kiam?” ");
INSERT INTO bjp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aunbiing ru ka wof una mon, kif ka met. ");
INSERT INTO bjp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ke berberat na fafausum ae na palgan mon ri ka lotu unaisa ma ri ka tarah, “Tekentu kanaka, o Kalalik ke God.” ");
INSERT INTO bjp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Aunbiing ri ka sopaket ta dan kawil, ri ka masa na Genesaret. ");
INSERT INTO bjp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma aunbiing fanu tinaiwa ri ka iliim Iesu, ri ka fafas una foron maleh fatat ke ri ka filange foron sasem tikii usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ke ri ka sising u isi rin sigil sun kolos kia sau, ma ri tikii ae ri sigil u, ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ke fale Farasi turan foron tom fafausum ini nagogon tinbae na Ierusalem ri ka la usuf Iesu ma ri ka diik u aragii, ");
INSERT INTO bjp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Isi sani ke berberat na fafausum kiam ri ka lek foron fafausum ken foron tubutamat kerer? Biil ri sofolim famu la isi rik ien.” ");
INSERT INTO bjp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ke ka kiliis ri aragii, “Ke isi sani gam ka lek nagogon ke God ma gam ka mi sau na fafausum ken foron tubutamat gam? ");
INSERT INTO bjp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wara le God i tarah, ‘On bulat lo tamam ru e tinam,’ ke ka use u sabin aragii, ‘Male tikas i orek laulau ulo tama le tina, ke rin siimete u.’ ");
INSERT INTO bjp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Isau le gam use u la aragii, in rokap male tikas in tara sing tama ru e tina aragii, ‘Tier ae le ian ta u sing kamuh, ia ka kale ta u le ian ta u usuf God.’ ");
INSERT INTO bjp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aunbiing gam use u arae, ke gam tipes u isi biil mang in bulat lo tama. Aunbiing gam tel u arae, gam fapu orek ke God isi gamek mi sau na foron fafausum ken foron tubutamat gam. ");
INSERT INTO bjp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gam foron tom gargaranmet! Profet Aisaia i orek tekentu tom aunbiing i orek famu ta le: ");
INSERT INTO bjp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Fanu igii ri bulat lo iau sau ini ngusri, isau le balri i tapak koseng iau. ");
INSERT INTO bjp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ri lotu foes la sau unaisang, wara le ri fausum fanu la sau ini nagogon foes ken fanu.’ ” ");
INSERT INTO bjp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu ka kam gur na fanu ae unaisa ke ka fas ri aragii, “Gamen ongen iau ma gamek malal na orek kiak. ");
INSERT INTO bjp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sani ae i kau na ngusun nenge kaltu, biil i fadu u na mata God, biil. Sani sau ae i suu tina ngusu, i sau i fadu u.” ");
INSERT INTO bjp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ke berberat na fafausum ri ka la usuf i ma ri ka tara sing i aragii, “Be, o usum sabin le orek kiam i fatel foron Farasi ma ka laulau e balri?” ");
INSERT INTO bjp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ke ka fas ri aragii, “Foron au tikii ae Tata buuii na kukulii biil i so ta u, rin rap ufu. ");
INSERT INTO bjp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sok ufu foron Farasi ae, ri arae foron kut ae ri lame fanu. Male nenge kut i lame nenge kut, ke run luut turim una nenge toh.” ");
INSERT INTO bjp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ka fas u aragii, “On famalal kemem ini kamtinan orek fatoftof ae.” ");
INSERT INTO bjp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ke Iesu ka tarah, “Paklu gam i kutkut biitom? ");
INSERT INTO bjp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Arafah, biil gam usum le foron tier tikii ae i kau na ngusun nenge kaltu, i la sikit una bala, ke nami ka suu tina pununfo? ");
INSERT INTO bjp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Isau le foron orek ae i suu tina ngusu, i la tom tina wolwol kia ke ka fadu u na mata God. ");
INSERT INTO bjp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wara le foron matngan sinang aragii i suu la tina wolwol ken nenge kaltu: Wolwol laulau, sinangun sisiimete, sinangun puur, sinangun tamfaes, sinangun suksukuum, sinangun tiu foes fal, ke sinangun orek laulau ulon fal. ");
INSERT INTO bjp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Foron matngan sinang igii, i fadu fanu la na mata God, isau male tikas i ien ma biil i sofolim, sinang ae biil i fadu u na mata God.” ");
INSERT INTO bjp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu ka la tinaiwa una falifu na Tair ke Saidon. ");
INSERT INTO bjp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ke nenge fafnan Kenan tina falifu ae, ka la ma ka tautau usuf i aragii, “Kumguui! Kalalik ke Dewit, on mais iau! Tanwa laulau i susuef ulon keng keleflik ma ka lala falaulau u.” ");
INSERT INTO bjp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Isau le Iesu biil i kiliis u. Ke berberat na fafausum kia ri ka la usuf i ma ri ka fas u aragii, “Wuun ufu sau, wara le i famam tautau nami kerer.” ");
INSERT INTO bjp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu ka tarah, “God i wuun ufu ta iau uga isi foron sipsip sau tina Israel ae ri rong tah.” ");
INSERT INTO bjp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Isau le fifin ae ka la usuf Iesu, ka ilepul na mata ke ka tarah, “Kumguui, on lupes iau!” ");
INSERT INTO bjp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ke Iesu ka kiliis u aragii, “Biil i tortores le rin kep inen an berberat ma rik lin u an birbiron puul.” ");
INSERT INTO bjp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fifin ae ka tarah, “I tekentu, Kumguui, isau le birbiron puul sabin ri ien foron peksen inen la an foron temri, ae i luut la tina luuf una ien.” ");
INSERT INTO bjp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ke Iesu ka kiliis u aragii, “Tinier, unune kiam i laumet kanaka. Sising kiam ka suut tah.” Ke na aunbiing tom ae, ke keleflik ka liu. ");
INSERT INTO bjp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu ka apti tinaiwa, ka tole bulin dan kawil na Galili ke ka tatkau na nenge pungpung ma ka kiis aiwa. ");
INSERT INTO bjp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ke nenge tara gur na fanu ri ka la usuf i. Ri ka filange foron peu, foron kut, fanu ae baban fo ri i met, foron tabilikut turan ifuun e sasem sabin usuf i, ke ri ka fakiis ri naisa ma ka faliu ri. ");
INSERT INTO bjp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gur na fanu ae, ri ka lala bitit aunbiing ri par foron tabilikut ri ka orek, ke fanu ae baban fo ri i met, ri ka rokap, foron peu ri ka la ke foron kut ri ka par. Ke ri ka usefages God ken fan Israel. ");
INSERT INTO bjp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu ka kam pes berberat na fafausum kia unaisa ke ka fas ri aragii, “Ia mais kanaka fanu igii, wara le ri ka kiis pes ta ituul e biing turang, ma biil mang ti inen ari. Biil ia ier le ian wuun ufu ri foes sau ini fitol, tarama ka taltal e matri tole sal.” ");
INSERT INTO bjp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Berberat na fafausum ri ka tara sing i aragii, “Kiptin biil sau igii. Fia keren kep ti beret wah, isi ik fasi una fen tara gur na fanu igii?” ");
INSERT INTO bjp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ke Iesu ka diik ri aragii, “Ifis e beret ae sing gam?” Ri ka kiliis u aragii, “Ifit, ma ituul sau e fabiro kok.” ");
INSERT INTO bjp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka fas fanu ae isi rin kiis na nanal. ");
INSERT INTO bjp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka kep ifit e beret turan foron kok ae, ka fotrokap lo usuf God, ka sibik u ke ka ta u usuf berberat na fafausum kia, ma ri ka tulus fanu ini. ");
INSERT INTO bjp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ri tikii ri ien ma ri ka mas. Ke berberat na fafausum kia ri ka siing fafuun ifit e kes ini foron tigan inen ae ri mas tiga. ");
INSERT INTO bjp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma wewes lon fanu tamat ae ri ien, ifasi aragii ifet e arip, biil ri wes kelefin turan berberat. ");
INSERT INTO bjp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aunbiing Iesu ka wuun sarara ta gur na fanu ae, ka wof na mon ma ka la una falifu na Magadan. ");
INSERT INTO bjp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Foron Farasi turan foron Sadusi ri ka la usuf Iesu ke ri ka ier isi tof u, pesu ri ka fas u isi in finngas ri ini ti fakileng tinbae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ke Iesu ka kiliis ri aragii, “Aunbiing pisiih i sup, ke gam use u la le, ‘In aunbiing rokap, wara le bat i melmelek.’ ");
INSERT INTO bjp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma na biingbiing gam use u la le, ‘In luut e us, wara le laukaf i melmelek ma bat ka kubunor.’ Gam par foron fakileng la na bat, ke gam ka usum le aunbiing arafa in tapiek. Isau le biil ifasi gamen iliim foron fakileng na foron aunbiing igii. ");
INSERT INTO bjp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gam na ulul igii, gam fanu laulau, ma gam la koseng God arae nenge fifin i lin antu ma ka telpes nenge kaltu sabin. Gam ier isi par ti fakileng, isau le fakileng sau in tapiek usuf gam, e fakileng ke Jona.” Ke Iesu ka kang koseng ri ma ka la. ");
INSERT INTO bjp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Aunbiing ri ka tapiek ta na nenge baban dan kawil, berberat na fafausum ri ruruu le rin kep ti beret. ");
INSERT INTO bjp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ke Iesu ka fas ri aragii, “Gamen tumarang! Gamen fofonoi lo gam koseng is ken foron Farasi ke ken foron Sadusi.” ");
INSERT INTO bjp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ri ka ngurke orek ae na fatpoto ri, ke ri ka tarah, “I use u arae, wara le biil kere kep ti beret.” ");
INSERT INTO bjp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ka usum ta na sani ri ngurke u ke ka tarah, “Unune kimi i fabiro. Isi sa gam ka ngurke fafis u na fatpoto gam le biil gam kep ti beret? ");
INSERT INTO bjp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Arafah, biil biitom gam malal? Gam ka ruruu ta na ilim e beret ae ilim e arip e fanu ri ien ta u turan i fis e kes ae gam siing fafuun ta u ini foron tigan inen? ");
INSERT INTO bjp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ke gam ka ruruu sabin na ifit e beret ae ifet e arip e fanu ri ien ta u turan i fis e kes ae gam siing fafuun ta u ini foron tigan inen? ");
INSERT INTO bjp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Isi sa biil gam malal? Biil ia fas gam ini beret. Isau le gamen fofonoi lo gam koseng is ken foron Farasi ke ken foron Sadusi.” ");
INSERT INTO bjp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ke ri ka malal mang le biil i fas ri isi rin tumarang isi is una beret, biil. Isau le rin tumarang isi fafausum ken foron Farasi turan foron Sadusi. ");
INSERT INTO bjp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aunbiing Iesu i la una nanal na Sisaria Filipai, ka diik berberat na fafausum kia aragii, “Fanu ri use u la le se tom e Kalalik ken Kaltu?” ");
INSERT INTO bjp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ke ri ka kiliis u aragii, “Fal ri tara le wo Jon Tom tel Bapitaiso, fal ri tara le wo Elaija, fal sabin ri tara le wo Jeremaia, le wo neng lon foron profet.” ");
INSERT INTO bjp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ke Iesu ka diik ri aragii, “Ke arafa lo gam? Gam tara le iau e seh?” ");
INSERT INTO bjp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ke Saimon Pita ka kiliis u aragii, “O Mesaia, Kalalik ke God ae i liu.” ");
INSERT INTO bjp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu ka kiliis u aragii, “Saimon kalalik ke Jona, o kalok, wara le fanu biil ri fausum wo ini. Tata tom buuii na kukulii i finngas wo ini. ");
INSERT INTO bjp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ia fas o, wo e Pita. Na olon fatkiis igii, ian fiti lotu kiak, ma Edes, salan foron minet biil ifasi in faluut u. ");
INSERT INTO bjp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ian ta foron ki na matanfuntih na kukulii usuf o, sani o kabet u aga na piklinbat, God in kabet u bae na kukulii, ke sani o puk u aga na piklinbat, God in puk u bae na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ke ka tikale berberat na fafausum kia isi gong ri fas tikas le i e Mesaia. ");
INSERT INTO bjp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tipesu mang na aunbiing ae, Iesu ka fas berberat na fafausum kia le, in la tom una Ierusalem isi ik kalsakai in fuun tom e tatawin na liman foron famfamu, foron laulaumet na pris turan foron tom fafausum ini nagogon. Fanu rin siimete u ma na fatuul u e biing ik apti fis sabin. ");
INSERT INTO bjp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ka lame pes u una baba ke ka fakiing u aragii, “Kumguui, gong o orek arae. Foron tier ae, biil in to tapiek lo wo.” ");
INSERT INTO bjp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu ka giliim ma ka tara sing Pita aragii, “Satan! Fin koseng iau! O ti fakut iau, wara le biil o mi na wolwol ke God. O mi sau na wolwol ken fanu.” ");
INSERT INTO bjp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ke Iesu ka fas berberat na fafausum kia aragii, “Male tikas i ier le in mi lo iau, in wol ufu tom ma ik kusep aupaket kia ke ik mi lo iau. ");
INSERT INTO bjp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wara le se i gong kale liu kia, liu ae in mangmangal koseng u, isau le se i sok ufu liu kia wara lo iau, in liu. ");
INSERT INTO bjp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Male tikas i kep tikii foron tier tina piklinbat, isau le ka falaulau liu kia, ke foron tier ae in farokap u arafah? Ke in ta sani una fiil kiliis liu kia? ");
INSERT INTO bjp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kalalik ken Kaltu in fis sabin ini memeh ke Tama turan foron angelo kia. Na aunbiing ae in fasuat temtem tikii na sani i tel ta u. ");
INSERT INTO bjp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tekentu kanaka ia fas gam, fal lo gam igii gam ti la, biil biitom rin met ke rik par Kalalik ken Kaltu in tapiek ini matanfuntih kia.” ");
INSERT INTO bjp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iwon e biing namih, Iesu ka lame pes Pita ke Jems ru latualik e Jon, ke rifet ka tatkau keskes na nenge tara pungpung. ");
INSERT INTO bjp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aiwa rituul ka par pununfo Iesu ka sokiliis. Posong na mata ka popos arae matan pisiih, ke kilkiliis kia i pos ma ka kilangkilang. ");
INSERT INTO bjp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Fanpil, tuul kalalik na fafausum ae, rituul ka par Moses ru e Elaija ru tipiek ma ru ka orek tura Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ke Pita ka fas Iesu aragii, “Kumguui, i rokap le kerer mang agawa. Male o ier isi, ke iak tel in tuul e palpalbuang, neng kiam, neng ke Moses ke neng ke Elaija.” ");
INSERT INTO bjp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aunbiing Pita i ororek la biitom, ke nenge laukaf ae i barang kanaka ka afit ri. Ma kinen tikas ka orek tina laukaf aragii, “Igii e keng Kalalik ae ia ier kanaka isi ma ia laes kanaka ini. Gamen wong sing i.” ");
INSERT INTO bjp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aunbiing tuul kalalik na fafausum ae rituul ongen u, rituul ka lala sokeh ke rituul ka luut ini posong na matrituul una nanal. ");
INSERT INTO bjp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isau le Iesu ka la usuf rituul, ka pose lo rituul ke ka tarah, “Gamtuul aptih, gong gamtuul sokeh.” ");
INSERT INTO bjp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aunbiing rituul sake matrituul, biil mang rituul par tikas, Iesu keskes mang tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aunbiing rifet pupu la tinbae na pungpung, Iesu ka fakiing rituul aragii, “Gong gamtuul fas tikas ini sani gamtuul par ta u, papang na aunbiing Kalalik ken Kaltu in apti fis tina minet.” ");
INSERT INTO bjp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuul kalalik na fafausum ae, rituul ka diik u aragii, “Isi sani ke foron tom fafausum ini nagogon ri ka use u le Elaija in tapiek famu lo Mesaia?” ");
INSERT INTO bjp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ke Iesu ka kiliis rituul aragii, “Tekentu tom, Elaija in tapiek famu ma ik fatortores fafis foron tier tikii. ");
INSERT INTO bjp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Isau le ia fas gamtuul, Elaija ka tapiek tah ma biil ri iliim u. Ri tel foron sinang laulau ulo namin wolwol kiri tom. Ifasi sabin lon Kalalik ken Kaltu, in kalsakai fangungut na limri.” ");
INSERT INTO bjp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ke tuul kalalik na fafausum ae, rituul ka usum mang le i fas rituul sau ini Jon Tom tel Bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aunbiing rifet ka tapiek naisan gur na fanu ae, ke nenge kaltu ka la usuf Iesu ma ka ilepul na mata, ");
INSERT INTO bjp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ke ka tara sing i aragii, “Kumguui, on mais keng kalalik. I gokgok la, ma i kalsakai tara fangungut la. Ifuun e aunbiing i luut la una yiif ke una dan. ");
INSERT INTO bjp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ia ka lame ta u usuf berberat na fafausum kiam, isau le biil ifasi rin faliu u.” ");
INSERT INTO bjp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ke Iesu ka kiliis u aragii, “Gam na ulul igii, gam foron tabun unune, ma gam ka la ger tah. Ia ka kiis dolo ta tura gam. Nangis mang gamek unune? Tangne kalalik ae uga usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu ka balkut ufu tanwa laulau ae, ke tanwa laulau ka suu koseng kalalik ae, ma na aunbiing tom ae, ka liu. ");
INSERT INTO bjp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Namih, berberat na fafausum ri ka la usuf Iesu ke ri ka diik fakum u aragii, “Isi sani ke biil ifasi kemen tel ufu tanwa laulau koseng u?” ");
INSERT INTO bjp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ke Iesu ka kiliis ri aragii, “Wara le unune kimi i fabiro kanaka. Tekentu kanaka ia fas gam, male unune kimi i fabiro arae fabiro kutun mastet, ifasi gamen fas pungpung igii le, ‘Gigin tinaga unawii,’ ke in gigin tom. Biil ti tier in ngangaten usuf gam.” ");
INSERT INTO bjp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Aunbiing Iesu turan berberat na fafausum kia ri ka tapiek turim na Galili, ka fas ri aragii, “Rin ta ufu Kalalik ken Kaltu una liman fanu. ");
INSERT INTO bjp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Rin siimete u ma na fatuul u e biing ik apti fis.” Ke balan berberat na fafausum kia ka purngis. ");
INSERT INTO bjp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aunbiing Iesu turan berberat na fafausum kia ri ka tapiek na Kapernaum, ke foron tom kep takiis tina Felun Tunmapek ri ka la usuf Pita ke ri ka diik u aragii, “Arafah, tom fafausum kiam i fiil takiis la sabin una Felun Tunmapek, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ke Pita ka kiliis ri aragii, “Iuu, i fiil u la.” Aunbiing Pita ka kau una fel, biil biitom i orek, ke Iesu ka diik famu u aragii, “Saimon, o wol arafah? Foron king tinaga na piklinbat ri kep foron takiis la sing fanseh? Sing berberat kiri tom, le sing fal keskes?” ");
INSERT INTO bjp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ke ka kiliis u aragii, “Sing fal keskes.” Ke Iesu ka fas u aragii, “Male arae, ke berberat kiri, biil rin to fiil takiis. ");
INSERT INTO bjp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Isau le tarama ri ka balkut lo karah, pesu, la una dan kawil ke ok wonwon. Ke kok famu ae o won u, sapeng na ngusu ke ok par nenge pitkalang. Kep u usuf ri isi ok fiil takiis kirah ini.” ");
INSERT INTO bjp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na aunbiing ae, berberat na fafausum ri ka la usuf Iesu ke ri ka diik u aragii, “Se tom i laumet kanaka na matanfuntih na kukulii?” ");
INSERT INTO bjp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ka tawi pes nenge fabiro kalalik, ka fasoti u na fatpoto ri ");
INSERT INTO bjp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ke ka tarah, “Tekentu kanaka ia fas gam, male biil gam sokiliis ma gam ka tapiek arae birbiro berberat, ke biil ifasi gamen kau na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Se sau ae i fabiro pes u arae kalalik igii, i laumet kanaka na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Male tikas i somangat pes ti kalalik arae ier igii na asang, i somangat pes iau tom. ");
INSERT INTO bjp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Male se i faluut tikas lon birbiron berberat igii ae ri unune lo iau na sinang laulau, in rokap ulo le rin kabet ta ti tara fat na kongkongo ma rik fadom ta u na kasap. ");
INSERT INTO bjp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kiskam kanaka usuf fanu na piklinbat, wara na foron tier ae in fatel fanu isi rik luut na sinang laulau. Foron tier ae in tapiek tom, isau le kiskam kanaka sing ier ae in fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Male nenge limam le nenge kekem i faluut o na sinang laulau, bus ufu ke ok lin u. In rokap le on kep liu fitliu ini kumuk, tarama ri ka lin o turan iun limam ke iun kekem turim una tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Male nenge kolson matam i faluut o na sinang laulau, au ufu ke ok lin u. In rokap le on kep liu fitliu ini in tikii sau e kolson matam, tarama ri ka lin o ini iun kolson matam turim una tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Gong gam ire tikas lon birbiro berberat igii. Ia fas gam, foron angelo kiri buuii na kukulii ri par posong na mata Tata la buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Arafah gam wol arae lon nenge kaltu ae imel e nenge mar e sipsip kia, ma neng lo ri ka rong? Arafah, biil in la koseng i siu e sangful ini siu aiwa na pungpung, ke ik im isi neng ae i rong tah? ");
INSERT INTO bjp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tekentu kanaka ia fas gam, aunbiing in tafe u, laes kia isi in laumet kanaka na laes kia isi isiu e sangful ini siu ae biil i rong tah. ");
INSERT INTO bjp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ifasi sabin arae Tama gam buuii na kukulii, biil i ier isi tikas lon birbiron berberat igii in rong. ");
INSERT INTO bjp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Male tuamlik i tel sinang laulau ulo wo, la ok fas u ini sinang laulau kia na fatpoto kamu sau. Male ka wong sing o, ke kamuk fatualik fis. ");
INSERT INTO bjp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Isau male biil i wong sing o, ke on tel pes in tikii le in u bin e kaltu turam, wara le Buk na Gogoh i use u aragii, ‘Orek ken iwu le ituul tom e kaltu in tatawin una fatekentu orek.’ ");
INSERT INTO bjp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Male biil i wong sing ri, fas foron tom unune tikii ini. Ke male biil i wong sabin sing foron tom unune ae, i rokap le on par u sau arae nenge kaltu tina kabarais le nenge tom kep takiis. ");
INSERT INTO bjp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tekentu kanaka ia fas gam, sani gam kabet u aga na piklinbat, God in kabet u bae na kukulii. Ke sani gam puk u aga na piklinbat, God in puk u bae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ia fas gam sabin, male iwu e kaltu lo gam aga na piklinbat ru somangat turim le run sising isi ti tier, ke Tata buuii na kukulii in ta u usuf ruh. ");
INSERT INTO bjp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Male iwu le ituul ri la turim na asang, ian kiis turim tura ri.” ");
INSERT INTO bjp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita ka la usuf Iesu ma ka diik u aragii, “Kumguui, fafis tom ian wol ufu foron sinang laulau ae tuaklik i tel ta u ulo iau? Fafit tom?” ");
INSERT INTO bjp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu ka kiliis u aragii, “Biil ia fas o le fafit sau, biil. Ia fas o le on wol ufu sinangu tuamlik in fasi aragii ifit e sangful ini fit e aunbiing. ");
INSERT INTO bjp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ia use u aragii, wara le matanfuntih na kukulii ifasi arae nenge king ae i ier isi kekep fis na foron tuka kia, ae foron fafauun kia ri kekep ta lo sing i. ");
INSERT INTO bjp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aunbiing ka diik pes ri, ri ka lame pes nenge fafauun kia usuf i, ae tuka kia ifasi ini nenge sangful e arip. ");
INSERT INTO bjp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Isau le biil ti pitkalang sing i ifasi una kiliis tuka kia sing king. Pesu king ae ka ier isi in ta kaltu ae tura antu ke berberat kia turan foron minmara tikii, isi tikas ik fiil pes ri una kiliis tuka kia. ");
INSERT INTO bjp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Isau le fafauun ae ka ilepul na mata ke ka sising u aragii, ‘Ok mais iau ta bii, nami ian kiliis tikii foron tuka kiak.’ ");
INSERT INTO bjp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","King ka mais fafauun ae ma ka fas u aragii, ‘Gong mang o kiliis foron tuka kiam.’ Ke ka wuun ufu. ");
INSERT INTO bjp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Isau le aunbiing fafauun ae ka suuh, ka tafe nenge tikiin foim kia ae i kep pes ta nenge mar sing i. Ka pose papte u ma ka bing kongkongo ke ka fas u aragii, ‘On kiliis sape tuka kiam.’ ");
INSERT INTO bjp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ke tikiin foim kia ka ilepul na mata ma ka sising u aragii, ‘On mais iau ta bii, nami ian kiliis tuka kiak.’ ");
INSERT INTO bjp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Isau le biil i ges e bala. Ka tel pes u ma ka fakau u na felun kamkabet, papang na biing in kiliis tuka kia. ");
INSERT INTO bjp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aunbiing fale tikiin foim kia ri par sani i tapiek lo, ka purngis e balri. Ri ka la usuf king ke ri ka fas u ini foron tier tikii ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“King ka tawi pes fafauun ae ma ka tara sing i aragii, ‘O nenge fafauun laulau, ia ka wol ufu ta e foron tuka tikii kiam, wara le o sising ta iau. ");
INSERT INTO bjp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Isi sani biil o mais tikiin foim kiam, arae ia mais ta wo?’ ");
INSERT INTO bjp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King ae ka ngaliaf ulo ke ka ta ufu usuf foron tom parpar kale felun kamkabet isi rik ta fangungut sing i, papang na aunbiing in kiliis tikii foron tuka kia. ");
INSERT INTO bjp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ma Tata buuii na kukulii in tel u sabin arae usuf gam, male biil gam wol ufu sinang laulau ken foron tualik gam ini tekentu.” ");
INSERT INTO bjp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aunbiing Iesu ka use tikii ta foron tier igii, ka apti tina Galili ma ka la una falifu na Iudaia, na nenge baban dan na Ioridan. ");
INSERT INTO bjp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tara gur na fanu ri ka mi lo ke ka faliu ri aiwa. ");
INSERT INTO bjp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fale Farasi ri ka la usuf i isi rin tof u ke ri ka diik u aragii, “Na nagogon kirer, i tortores le nenge kaltu in lin foes antu sau, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu ka kiliis ri aragii, “Arafah, biil biitom gam wes foron orek ae na Buk na Gogoh? I use u aragii, ‘Na tanwaran fakfakiis, Tom Fakfakiis i fakiis ta ruh, tamat ke fifin,’ ");
INSERT INTO bjp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ke ka tarah, ‘I e wara ae nenge kaltu in la koseng tama ru e tina ma ik kiis turim tura antu, isi ik tikii mang lo ruh.’ ");
INSERT INTO bjp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ma biil mang in u lo ruh, biil. Run tapiek itikii sau. Pesu, sani ae God ka faturim ta u, gong tikas i tempaek u.” ");
INSERT INTO bjp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ke foron Farasi ri ka diik u sabin aragii, “Male i arae, ke isi sani Moses ka use u le, male nenge kaltu i ier isi in lin antu, ke in ta ti aun buk una puk fakekel usuf antu?” ");
INSERT INTO bjp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu ka kiliis ri aragii, “Moses i somangat ufu gam isi lin antu gam, wara le balmi i sorokai kanaka, isau le tina tanwara biil i tara ta arae. ");
INSERT INTO bjp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ia fas gam, male nenge kaltu i lin foes antu ae biil i tel ta sinangun puur, ke kaltu ae ka telpes nenge fifin sabin, kaltu ae i tel sinangun puur.” ");
INSERT INTO bjp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ke berberat na fafausum kia, ri ka fas u aragii, “Male nagogon na kiiskiis an fakekel i ngangaten kanaka, ke i rokap le gong sau e fakekel.” ");
INSERT INTO bjp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu ka kiliis ri aragii, “Biil e fanu tikii ifasi rin somangat pes fafausum igii, biil. God i ta rakrakai sau usuf fal. ");
INSERT INTO bjp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ifuun e wara ae fale fanu biil ri fakekel. Fal ri pang tom arae. Fal, fanu sau ri falaulau ri, ma fal biil ri fakekel, wara le ri wol na foim na matanfuntih na kukulii. Se ifasi in somangat pes fafausum igii, in somangat pes u.” ");
INSERT INTO bjp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Fale fanu ri ka filange birbiron berberat usuf Iesu isi ik luun iun lima na olri ma ik sising kale ri. Isau le berberat na fafausum kia ri ka fakiing fanu ae. ");
INSERT INTO bjp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu ka fas ri aragii, “Gam sok ufu birbiron berberat ae usuf iau. Gong gam tikale ri, wara le matanfuntih na kukulii ken fanu ae ri arae berberat igii.” ");
INSERT INTO bjp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aunbiing ka luun ta iun lima na olri, ka apti tinaiwa ke ka la. ");
INSERT INTO bjp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nenge guam ka la usuf Iesu ma ka diik u aragii, “Tom Fafausum, sani rokap tom ian tel u, isi iak kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu ka kiliis u aragii, “Isi sani o ka diik iau isi sani i rokap? Itikii sau ae i rokap. Male o ier isi kep liu fitliu, ke on misuut na foron nagogon.” ");
INSERT INTO bjp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Guam ae ka diik u sabin aragii, “Foron nagogon arafah?” Iesu ka kiliis u aragii, “Gong o siimete tikas, gong o tel sinangun puur, gong o suksukuum, gong o tiu foes tikas, ");
INSERT INTO bjp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","on bulat lo tamam ru e tinam, ke ok ier isi ier ae na fatat o, arae o ier isi wo tom.” ");
INSERT INTO bjp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Guam ae ka tarah, “Foron nagogon tikii ae, ia ka misuut ta lo. Sani biitom ia pongpong isi?” ");
INSERT INTO bjp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ke Iesu ka kiliis u aragii, “Male o ier le on tapiek tom tortores, la ma ok sufii foron minmaram tikii ma pitkalang lo, ok ta u usuf foron lauu. Male on tel u arae, ke kiam e minsik buuii na kukulii. Nami ok fis, ok mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aunbiing guam ae i ongen u arae, ka la ini mamais, wara le ifuun kanaka e minmara. ");
INSERT INTO bjp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ke Iesu ka tara sing berberat na fafausum kia aragii, “Tekentu kanaka ia fas gam, in ngangaten kanaka isi nenge kaltu ae ifuun e minsik kia in kau na matanfuntih na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iak fas gam sabin, i ngangaten usuf kamel isi in kau na solsol na nil una somap, isau le i ngangaten kanaka tom usuf nenge kaltu ae ifuun e minsik kia isi in kau na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aunbiing berberat na fafausum kia ri ka ongen u, ri ka lala bitit ma ri ka tarah, “Male i arae, ke se mang ifasi in kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu ka par usuf ri ke ka tarah, “Usuf fanu biil ifasih, isau le God ifasi in tel foron tier tikii.” ");
INSERT INTO bjp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita ka kiliis u aragii, “Par u, keme ka la koseng ta foron tier tikii kimem ke keme ka mi lo wo. Sani mang kimem ae namih?” ");
INSERT INTO bjp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu ka tara sing ri aragii, “Tekentu kanaka ia fas gam, aunbiing foron tier tikii ka tapiek fuu tah, ke Kalalik ken Kaltu ka kiis na memeh kia arae king, gam ae gam ka mi ta lo iau, gamen kiis na nenge sangful ini u e nian kiiskiis una nagogon nenge sangful ini u e mat tina Israel. ");
INSERT INTO bjp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ke ri tikii ae ri la koseng foron fel kiri, le koseng foron tualik ri, le koseng foron fenelik ri, le koseng foron temri le koseng foron tinri, le koseng berberat kiri, le koseng nanal kiri iwara lo iau, ke rin kep nenge mar, nenge mar sabin e tier ma rik kep liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Isau le ifuun ae ri famu ta igii, nami rin mih, ma ifuun ae ri mih igii, nami rin famu. ");
INSERT INTO bjp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Matanfuntih na kukulii ifasi arae: Nenge kaltu ae imel e porpor wain kia. I suu na biingbiing saksak isi telpes ti fale tom foim isi rin foim na porpor wain kia. ");
INSERT INTO bjp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ke ka somangat turim tura ri, le in fasuat ri ini fifiil una nenge biingen foim ke ka wuun ufu ri una porpor wain kia. ");
INSERT INTO bjp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na isiu e aunbiing, ka la sabin ke ka par fale fanu ae ri soti foes la sau na salan la turim. ");
INSERT INTO bjp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ke ka fas ri aragii, ‘Gam la sabin isi gamek foim na porpor wain kiak ke iak fasuat gam fasi ini foim kimi.’ ");
INSERT INTO bjp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ke ri ka la. “Ke na siat tuntun ka la sabin ke ka telpes fale tom foim, ke na ituul e aunbiing na efef ka telpes fal sabin. ");
INSERT INTO bjp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Na ilim e aunbiing na efef, ka la sabin ke ka par fale fanu ae ri soti foes la sau ke ka diik ri aragii, ‘Isi sani gam ka soti foes la sau aga na biing kuruur igii?’ ");
INSERT INTO bjp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ri ka kiliis u aragii, ‘Biil tikas i telpes kemem isi foim.’ “Ke ka tara sing ri aragii, ‘Gam sabin, gam la ma gamek foim na porpor wain kiak.’ ");
INSERT INTO bjp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Na efef worwor, kaltu ae porpor wain kia ka fas famfamu ken foron tom foim kia aragii, ‘Tawi foron tom foim uga ke ok suat ri. On tipes u lon fanu ae ri tapiek namih ke farop u lon fanu ae ri tapiek famu.’ ");
INSERT INTO bjp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Foron tom foim ae ri tipes foim sau na ilim e aunbiing ri ka la ma temtem tikii lo ri, ri kep fifiil ifasi na itikii e biingen foim. ");
INSERT INTO bjp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Foron tom foim ae ri tipes foim famu tah, ri la ma ri ka wol le rin kep fifiil laumet. Isau le, temtem tikii lo ri, ri suat ri sabin ini fifiil sau na itikii e biingen foim. ");
INSERT INTO bjp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aunbiing ri ka kep fifiil tikii tah, ri ka belbel orek mang ulon kaltu ae porpor wain kia. Ke ri ka tara sing i aragii, ");
INSERT INTO bjp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Fanu ae o am telpes ri sau, biil ri foim dolo tah. Ma kemem, keme tel ta tara foim ke pisiih ka tun kemem, isau le o fiil ri sabin arae kemem.’ ");
INSERT INTO bjp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ke ka fas neng lo ri aragii, ‘Talang, biil ia falaulau wo. Arafah, biil kara somangat ta isi fifiil una nenge biingen foim? ");
INSERT INTO bjp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kep fifiil kiam ma ok la. Ia tom ia ier le ian suat fanse ae ri tapiek namih, arae wo ae o tapiek famu. ");
INSERT INTO bjp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Arafah, biil i tortores le ian nagogon pitkalang kiak namin wolwol kiak tom? Kol arafah, o bala laulau aunbiing ia rokap ini fanu igii?’ ");
INSERT INTO bjp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Fanu ae ri mih ta igii, nami rin famu, ke fanu ae ri famu igii, nami rin mih.” ");
INSERT INTO bjp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Aunbiing Iesu i tatatkau la una Ierusalem, ka lame pes sangful ini u e kalalik na fafausum kia una baba ke ka fas ri aragii, ");
INSERT INTO bjp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Par u, igii kerek tatkau mang una Ierusalem, ke rik ta ufu Kalalik ken Kaltu mang una liman foron laulaumet na pris turan foron tom fafausum ini nagogon. Rin nagogon u isi ik met. ");
INSERT INTO bjp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rin ta ufu usuf fanu ae biil ri fan Iudaia isi rik morot ini, rik pis u ke rik fakulkulik u na aupaket. Ma na fatuul u e biing ik apti fis.” ");
INSERT INTO bjp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Namih, tinan iwu e kalalik ke Sebedi turan iwu e kalalik kia, rituul ka la usuf Iesu ke tinruh ka ilepul isi in sising u isi nenge tier. ");
INSERT INTO bjp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu ka diik u aragii, “Sani o ier isi?” Ke ka kiliis u aragii, “Aunbiing on tapiek king, on fakiis iun kalalik kiak igii na matanfuntih kiam, neng na miam ke neng na kaisam.” ");
INSERT INTO bjp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu ka kiliis u aragii, “Biil gamtuul usum na sani ae gamtuul sising isi. Arafah, ifasi kamun yin na kap ae ian yin lo?” Ke ru ka kiliis u aragii, “Kama fasih.” ");
INSERT INTO bjp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu ka fas ru aragii, “Tekentu le kamun yin na kap kiak. Isau le isi kiis na miang le na kaisang, biil e tier kiak isi ian ta u. Tata tom in ta u usuf fanse ae ka fageges ta u usuf ri.” ");
INSERT INTO bjp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aunbiing nenge sangful e kalalik na fafausum ri ka ongen u arae, ri ka ngaliaf ulo ru latualik. ");
INSERT INTO bjp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu ka kam turim ri ke ka tarah, “Gam usum le foron king ken fanu ae biil ri fan Iudaia, ri lala nagogon fanu la. Ma piran famfamu kiri sabin, ri luun foron rakrakai na nagogon la na olon fanu. ");
INSERT INTO bjp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Isau le gong gam tara arae ri. Male tikas i ier le in laumet lo gam, ke in fasabiro pes u tom ma ik tapiek arae tom foim kimi. ");
INSERT INTO bjp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma se i ier le in famfamu kimi, in arae fafauun kimi. ");
INSERT INTO bjp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ifasi sabin arae lon Kalalik ken Kaltu, biil i tapiek isi fanu rin lupes u, biil. I tapiek isi i tom in lupes fanu ke ik ta liu kia tom una fiil fafis fanu fuun.” ");
INSERT INTO bjp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aunbiing Iesu turan berberat na fafausum kia ri la koseng Jeriko, nenge tara gur na fanu ri ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iwu e kut ru kiis ta na bulin sal. Aunbiing ru ongen u le Iesu aimang na fatat, ru ka tautau aragii, “Kumguui, Kalalik ke Dewit, on mais kamah!” ");
INSERT INTO bjp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ke gur na fanu ae, ri ka fakiing ru isi run kiis fofo. Isau le ru ka lala tautau mang tom aragii, “Kumguui, Kalalik ke Dewit, on mais kamah!” ");
INSERT INTO bjp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu ka sotih, ka tawi pes ruh ke ka diik ru aragii, “Sani kamu ier le ian tel u ini kamuh?” ");
INSERT INTO bjp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ru ka kiliis u aragii, “Kumguui, kama ier isi matmah in sapeng.” ");
INSERT INTO bjp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu ka mais ruh ke ka sigil matruh. Fanpil ru ka par ke ru ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aunbiing ri ka la fatat Ierusalem, ri ka tapiek na Betfage na Pungpung na Olif, Iesu ka wuun ufu iwu e kalalik na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ke ka fas ru aragii, “Kamu la una maleh ae na famu lo kamuh. Aunbiing kamun tapiek, kamun par nenge dongki ae ri kabet ta u turan natu. Puk ufu ruh ke kamuk tangne ru uga usuf iau. ");
INSERT INTO bjp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Male tikas in diik kamu isi, ke kamun fas u le, ‘Kumguui imel e foim kia lo,’ ma fanpil ik mangte ufu ru usuf kamuh.” ");
INSERT INTO bjp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Foron tier igii i tapiek una fasuut orek ke God ae profet i use ta u le: ");
INSERT INTO bjp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fas fan Saion le, ‘Par u! King kimi apiek mang usuf gam, i fapu u tom ma ka kiis na olon nenge dongki, na fabiro dongki.’” ");
INSERT INTO bjp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iun kalalik na fafausum ae, ru ka la ke ru ka tel u arae Iesu i patrai ta ruh. ");
INSERT INTO bjp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ru ka tangne dongki ae turan natu, ke ru ka sol ini iun dolon kaen kiruh na olon iun dongki ae ma Iesu ka kiis lo. ");
INSERT INTO bjp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nenge tara gur na fanu ri ka sol ini foron dolon kaen kiri tole sal. Fal ri ka pakat foron akan au ma ri ka sol ini tole sal. ");
INSERT INTO bjp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gur na fanu ae ri famfamu la lo Iesu ke fanu ae ri mimi la, ri ka tautau aragii, “Osana usuf Kalalik ke Dewit!” “Fafakalok usuf ier ae i la uga ini asa Kumguui!” “Osana ubae na mawe!” ");
INSERT INTO bjp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aunbiing Iesu i kau na Ierusalem, falifu tikii ae ka rigorigo ma fanu ri ka diik le, “Se ae?” ");
INSERT INTO bjp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Gur na fanu ae ri la tura, ri ka kiliis ri aragii, “I e Iesu, profet tina Nasaret na falifu na Galili.” ");
INSERT INTO bjp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu ka kau na palgan ubiif kale Felun Tunmapek ma ka fes fasuu fanu tikii aiwa ae ri famam fifiil turan fanu sabin ae ri sufii foron tier isi fanu rik fiil u. Ka fabereng foron luuf ini fanu ae ri famam sokiliis pitkalang ke foron luuf ken fanu ae ri sufii foron bun. ");
INSERT INTO bjp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ke ka tara sing ri aragii, “Ri siit ta u na Buk na Gogoh aragii, ‘Rin foteng fel kiak le Felun Sising,’ isau le gam ka tel u bin arae ‘salan mumumun ken foron tom sisii.’” ");
INSERT INTO bjp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ke foron kut turan foron peu ri la usuf i na Felun Tunmapek ke ka faliu ri. ");
INSERT INTO bjp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Isau le aunbiing foron laulaumet na pris turan foron tom fafausum ini nagogon ri par foron tier rokap ae i fatapiek ta u ke ri ka ongen berberat ri tautau awii na palgan ubiif kale Felun Tunmapek aragii, “Osana usuf Kalalik ke Dewit,” ke ri ka lala ngaliaf. ");
INSERT INTO bjp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ri ka diik Iesu aragii, “O ongen sani berberat igii ri use u?” Iesu ka kiliis ri aragii, “Iuu. Arafah, biil biitom gam wes u na Buk na Gogoh? I use u aragii, ‘O ka fausum ta birbiron berberat ke foron mirmiriiu isi rin sik asam.’” ");
INSERT INTO bjp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ke Iesu ka kang koseng ri na Ierusalem ma ka la una Beteni ke ka borong aiwa na wor. ");
INSERT INTO bjp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na biingbiing saksak Iesu ka fitol aunbiing i tatkau fis una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka par nenge au na fik awii na bulin sal ke ka la fatat u, isau le biil i par ti fua, awu kanan sau. Ke ka fas au na fik ae aragii, “Tipes u igii ma namih, biil mang on fua sabin.” Ma fanpil au na fik ae ka mang. ");
INSERT INTO bjp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aunbiing berberat na fafausum ri par u, ri ka bitit ke ri ka tarah, “Arafa ke au na fik igii ka mang sape?” ");
INSERT INTO bjp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka kiliis ri aragii, “Tekentu kanaka ia fas gam, male gamen unune ma biil iwu e wolwol kimi, gamen tel foim ae ia tel ta u na au na fik igii. Ke ifasi sabin gamen fas pungpung igii le, ‘Apti tinaiwa ma ok luut na palgantes,’ ke in tapiek tom arae. ");
INSERT INTO bjp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Male gam unune, ke gamen kep foron tier tikii ae gam sising isi.” ");
INSERT INTO bjp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu ka kau na palgan ubiif kale Felun Tunmapek. Ma aunbiing i fafausum fanu la, foron laulaumet na pris turan foron famfamu ken fanu ri ka la usuf i ke ri ka diik u aragii, “Rakrakai tinga o tel foron tier igii ini? Se i ta u e rakrakai igii sing o?” ");
INSERT INTO bjp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu ka kiliis ri aragii, “Ia sabin ian diik gam ini nenge fagalte. Male gamen kiliis iau, ke ian fas gam ini rakrakai tinga ia tel foron tier igii ini. ");
INSERT INTO bjp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tinga e bapitaiso ke Jon? Tinbae na kukulii, le sing fanu sau?” Ri ka ngurke u tom na fatpoto ri aragii, “Male keren tara le, ‘Tinbae na kukulii,’ ke in diik kerer le, ‘Isi sani biil gam unune lo?’ ");
INSERT INTO bjp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Isau male keren tara le, ‘Sing fanu sau,’ ke kere soke fanu sabin, wara le ri tikii ri unune le Jon i nenge profet.” ");
INSERT INTO bjp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ri ka kiliis Iesu sau aragii, “Biil keme usum.” Ke Iesu ka tarah, “Iau sabin, biil ian fas gam le rakrakai tinga ia tel foron tier igii ini.” ");
INSERT INTO bjp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesu ka fas ri sabin aragii, “Gam wol arafah? I mel e nenge kaltu iwu e kalalik tamat kia. Ka la usuf neng famu ke ka fas u aragii, ‘Keng kalalik, igii on la ma ok foim na porpor wain.’ ");
INSERT INTO bjp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ka kiliis u aragii, ‘Biil ian la.’ Isau le namih, ka kiliis wolwol kia ke ka la. ");
INSERT INTO bjp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Namih, temruh ka la sabin usuf nenge kalalik sabin, ke ka fas u sabin arae. Ke kalalik ae ka kiliis u aragii, ‘Tata, ian la.’ Isau le biil i la. ");
INSERT INTO bjp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Se lo ru i tel sani ae temru i ier isi?” Ke ri ka kiliis u le, “Neng famu.” Iesu ka fas ri aragii, “Tekentu kanaka ia fas gam, foron tom kep takiis turan foron tamfaes rin kau famu lo gam una matanfuntih ke God. ");
INSERT INTO bjp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jon i la tah ke ka fausum gam ini sinang ae i tortores ke biil gam unune lo, isau le foron tom kep takiis turan foron tamfaes ri ka unune lo. Aunbiing gam par u, biil gam kiliis liu kimi ke biil gam unune lo. ");
INSERT INTO bjp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Gam ongen nenge orek fatoftof sabin igii: Nenge taman nanal i so ta nenge porpor wain ke ka ubiif kale u. Aiwa na palgan porpor wain ae, ka tuung nenge fat una bing turim danun wain, ke ka tel nenge fabiro fel ae i kangkang ken tom parpar kaleh. Namih, ka ta porpor wain ae usuf fale tom foim isi rin parpar kale ta bii lo ma ka la na nenge ninla. ");
INSERT INTO bjp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na taul lulus, ka wuun ufu fale fafauun unaisan foron tom foim ae ri parpar kale na porpor wain kia, isi rin kep ti fale fuan wain. ");
INSERT INTO bjp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ke foron tom foim ae ri ka luse foron fafauun kia. Ri ka paket neng, ri ka siimete neng ke ri ka luumete neng. ");
INSERT INTO bjp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ke ka wuun fale fafauun sabin ma wewes lo ri i laumet lon fal ae i wuun famu ta ri. Isau le foron tom foim ae ri ka tel u sabin lo ri, arae ri tel ta u ulon fal. ");
INSERT INTO bjp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nami mang, ka wuun ufu ke kalalik tutus usuf ri. Ka tarah, ‘Rin bulat lo keng kalalik.’ ");
INSERT INTO bjp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Isau le aunbiing foron tom foim ae ri par ke kalalik, ri ka put orek aragii, ‘Ier ae in ti kiliis tama. Kere mang, kerek siimete u, isi kerek kep u mang e porpor wain igii, ae tama i fakale ta u ini.’ ");
INSERT INTO bjp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ri ka luse u, ri ka luu suu ini tina porpor wain ae ke ri ka siimete u. ");
INSERT INTO bjp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pesu aunbiing taman porpor wain ae in tapiek, sani mang in tel u ini foron tom foim ae?” ");
INSERT INTO bjp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ri ka kiliis u aragii, “In siimete ufu fanu laulau tikii ae ma ik ta porpor wain usuf fale fanu keskes, isi rik ta ti fale fuan wain usuf i na taul lulus.” ");
INSERT INTO bjp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ke Iesu ka kiliis ri aragii, “Arafah, biil gam wes orek ae na Buk na Gogoh? I use u le: ‘Tuh ae foron tom tel fel ri puris ta u, ka tapiek temin tuh mang bin. Tier igii Kumguui tom i tel ta u ma i rokap kanaka na parpar kirer.’ ");
INSERT INTO bjp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Pesu ia ka fas gam le God in kep ufu matanfuntih kia koseng gam ma ik ta u usuf fanu ae liu kiri in fatapiek rokap na fua ae in fasi ini matanfuntih kia. ");
INSERT INTO bjp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Male tikas in luut una tuh ae, in burburngi, ma se ae tuh igii i luut na olo, in pekpekes.” ");
INSERT INTO bjp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aunbiing foron laulaumet na pris turan foron Farasi ri ongen foron orek fatoftof ke Iesu, ri ka usum ta le i use ri sau. ");
INSERT INTO bjp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ke ri ka im sal isi luse u, isau le ri soke gur na fanu ae, wara le fanu ri unune le Iesu i nenge profet. ");
INSERT INTO bjp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu ka fas ri sabin ini nenge orek fatoftof aragii: ");
INSERT INTO bjp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Matanfuntih na kukulii ifasi arae nenge king ae kalalik tamat kia in fakekel, pesu king ka geges ini tara inen. ");
INSERT INTO bjp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka wuun foron fafauun kia isi rin til pes fanu ae i sising ta ri isi rin la una inen ken fakekel fuu ae, isau le ri ka ngoingoi. ");
INSERT INTO bjp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ka wuun ufu fale fafauun sabin ke ka fas ri aragii, ‘Fas fanse ae ia sising ta ri le, inen ka geges tah. Ia ka siimete ta foron bulmakau turan fal birbiro ae ri sut rokap ma foron tier tikii ka geges tah. Gam la uga na inen ken fakekel fuuh.’ ");
INSERT INTO bjp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Isau le fanu ae i sising ta ri, biil ri wong, ri ka mi tom na wolwol kiri. Neng ka la una mok kia, ke neng ka la isi foimnge pitkalang kia. ");
INSERT INTO bjp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Fal ri ka luse foron fafauun ke king, ke ri ka paket ri ma ri ka siimete ri. ");
INSERT INTO bjp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King ae ka lala ngaliaf ke ka wuun ufu foron tom fapaket kia. Ke ri ka siimete fanu ae ri siimete ta foron fafauun kia ma ri ka fasok maleh kiri. ");
INSERT INTO bjp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ka fas foron fafauun kia sabin aragii, ‘Inen ken fakekel fuuh ka geges tah. Isau le fanse ae ia sising ta ri, sinangu ri i finngas u le biil ifasi rin kiis na inen. ");
INSERT INTO bjp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gam la una foron sunsun sal, ma fanu tikii ae gam tafe ri, gamen fas ri isi rik la uga na inen ken fakekel fuuh.’ ");
INSERT INTO bjp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ke foron fafauun ae ri ka la una foron sunsun sal ma ri ka tawi turim fanu tikii ae ri tafe ri. Fanu laulau ke fanu rokap sabin ma fel ae ka fuun ini foron ses. ");
INSERT INTO bjp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Isau le aunbiing king ka kau isi par foron ses kia, ka par tafe nenge kaltu ae biil i luun kaen ifasi una kiis na inen ken fakekel fuuh ae. ");
INSERT INTO bjp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ke ka diik u aragii, ‘Talang, arafa o kau arae uga ma biil o luun kaen ifasi una kiis na inen ken fakekel fuuh?’ Isau le biil i kiliis u. ");
INSERT INTO bjp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ke king ka fas foron fafauun aragii, ‘Kabet iun lima ke iun keke ke gamek lin fasuu u una kubunor, isi in teng ma ik faririt ngisa aiwa.’” ");
INSERT INTO bjp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ke Iesu ka farop orek kia aragii, “God i tawi ta fanu fuun, isau le i fule pes ta ituul sau.” ");
INSERT INTO bjp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Namih, foron Farasi ri ka la turim ke ri ka pidai orek le rin tatakuun pes Iesu ini ti orek kia, isi rik tiu u. ");
INSERT INTO bjp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ri ka wuun ufu berberat na fafausum kiri turan fanu ke Erot usuf Iesu, ma ri ka tara sing i aragii, “Tom fafausum, keme usum le o tom tortores ma o fausum tekentu fanu la tom ini sinangu God. Biil o wol pes sani fanu ri use u ulo wo. Fafausum kiam i fafasi usuf fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Fas kemem, arafa o wol arae, i tortores le keren fiil takiis usuf Sisar, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Isau le Iesu i usum tom na wolwol laulau kiri, pesu ka tarah, “Gam foron tom gargaranmet, isi sani gam ka ier isi tatakuun pes iau? ");
INSERT INTO bjp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gam finngas iau ini ti pitkalang ae ri fiil takiis la ini.” Ke ri ka ta nenge dinaria usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ka diik ri aragii, “Tantanwa se ke asa se igii lo?” ");
INSERT INTO bjp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ri ka kiliis u aragii, “Sisar.” Ka fas ri le, “Sani ke Sisar, ta u usuf Sisar, ma sani ke God, ta u usuf God.” ");
INSERT INTO bjp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aunbiing ri ongen u, ri ka bitit ma ri ka la koseng u. ");
INSERT INTO bjp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na biing tom ae, foron Sadusi sabin, ae ri tara la le biil ti apaptifis, ri ka la usuf Iesu ini nenge fagalte. ");
INSERT INTO bjp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ke ri ka tarah, “Tom fafausum, Moses i fas ta kerer aragii, male nenge kaltu i met ma biil ti kalalik kia, ke tualik in telpes makos kia, isi ik fapuar ti berberat ke tualik ae ka met tah. ");
INSERT INTO bjp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nenge ifit latualik, tinaga na aismem. Neng famu i fakekel ta ma ka met ma biil ti kalalik kia. Ke fawu e tualik ka telpes makos kia. ");
INSERT INTO bjp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ifasi sabin arae ini fawu e tualik ke fatuul u. Ri fit tikii ri telpes ta u ke ri ka met. ");
INSERT INTO bjp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ke nami lo ri tikii, fifin ae ka met. ");
INSERT INTO bjp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ke, na biingen apaptifis, fifin ae in antu se tutus mang lo ri? Wara le ifit latualik tikii ae ri telpes ta u.” ");
INSERT INTO bjp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu ka fas ri aragii, “Gam ka la ger tah, wara le biil gam usum na foron orek ae na Buk na Gogoh ke na rakrakai sabin ke God. ");
INSERT INTO bjp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na biingen apaptifis, fanu biil rin to fakekel sabin, rin arae foron angelo buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Gam use u la le foron minet biil rin apti fis. Arafah, biil biitom gam wes foron orek ae God i fas ta gam ini? I use u le, ");
INSERT INTO bjp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ia God ke Abaram, God ke Aisak ke God ke Jekop.’ God biil i God ken foron minet, biil. I God ken fanu ae ri liu.” ");
INSERT INTO bjp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aunbiing gur na fanu ae ri ka ongen u, ri ka lala bitit na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aunbiing foron Farasi ri ka ongen u le Iesu ka babat ta na ngusun foron Sadusi, ri ka la turim unaisa. ");
INSERT INTO bjp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Neng lo ri, i nenge tom tasum na nagogon, ka tof Iesu ini nenge fagalte aragii, ");
INSERT INTO bjp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tom fafausum, nagogon sa i laumet kanaka lon foron nagogon tikii?” ");
INSERT INTO bjp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ke Iesu ka kiliis u aragii, “‘On ier isi Kumguui, God kiam ini balam tikii, ini tanwam tikii ke ini wolwol tikii kiam.’ ");
INSERT INTO bjp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nagogon igii, i e nagogon famu ma i laumet kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma fawu u e nagogon ifasi sabin arae, ‘On ier isi ier ae na fatat o, arae o ier isi wo tom.’ ");
INSERT INTO bjp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Foron Nagogon ke Moses turan foron buk tikii ken foron profet, ri fefesti sau na iun nagogon igii.” ");
INSERT INTO bjp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Aunbiing foron Farasi ri kiis turim biitom aiwa, ke Iesu ka diik ri aragii, ");
INSERT INTO bjp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Arafa gam wol arae lo Mesaia? I kalalik kise tom?” Ri ka kiliis u aragii, “I kalalik ke Dewit.” ");
INSERT INTO bjp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ke Iesu ka tara sing ri aragii, “Male arae, ke isi sani Dewit ka kam Mesaia le, ‘Kumguui kiak,’ aunbiing Tanwa Kalkaluu i susuef ta ulo? Wara le Dewit i use ta u aragii, ");
INSERT INTO bjp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kumguui God i tara sing Kumguui kiak: Kiis na miang, papang na aunbiing ian luun foron tuui kiam na piklin kekem.’ ");
INSERT INTO bjp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dewit i foteng ta Mesaia le Kumguui kia. Male i arae, ke in tapiek kalalik ke Dewit arafah?” ");
INSERT INTO bjp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma biil tikas ifasi in use ti orek una kiliis u. Tipes u na biing ae, biil sabin tikas i diik u ini ti fagalte, wara le ri ka binbin mang. ");
INSERT INTO bjp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Namih, Iesu ka fas gur na fanu ae turan berberat na fafausum kia aragii, ");
INSERT INTO bjp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Foron tom fafausum ini nagogon turan foron Farasi ri kep sala Moses na fafausum ini nagogon. ");
INSERT INTO bjp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pesu, gamen ongen pes foron orek tikii kiri ke gamek tel foron tier tikii ae ri fas gam ini. Isau le gong gam parpar pes na sinangu ri, wara le foron tier ae ri use u la, ri tom biil ri mi la lo. ");
INSERT INTO bjp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ri fakuskusep fanu la ini foron kiip tatawin, isau le ri tom biil ri mamlik ta limri la. ");
INSERT INTO bjp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ri tel foron rokap na foim tikii isi fanu rik par u. Aunbiing ri tel foron bokiis una siing fale sun orek na Buk na Gogoh, foron Farasi rin tel u kiri, in laumet mang tom lon fanu tikii. Ke aunbiing ri kabet finau na foron sun kaen kiri, in dolo tom lon fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma ri ier isi nian kiiskiis ken foron laulaumet na foron tel inen, ke ri ier la tom isi rin kiis na foron nian kiiskiis kausi na foron felun lotu. ");
INSERT INTO bjp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ri ier la tom le fanu rin faorek pes ri ini bulat na foron salan la turim ken fanu ma rik foteng ri le, ‘Rabi.’ ");
INSERT INTO bjp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Isau le gam, gong ri foteng gam le foron tom fafausum, wara le itikii sau e Tom Fafausum kimi ma gam tikii gam fatfat latualik sau. ");
INSERT INTO bjp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ke gong gam foteng tikas aga na piklinbat le tama gam, wara le itikii sau e Tama gam ae i kiis buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ke gong ri foteng gam le gam famfamu, wara le itikii sau e famfamu kimi, i e Mesaia. ");
INSERT INTO bjp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Se i laulaumet kimi, in tapiek tom foim kimi. ");
INSERT INTO bjp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wara le se i falaumet u tom, God in fasabiro u, ma se i fasabiro u tom, God in falaumet u. ");
INSERT INTO bjp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi! Gam foron tom gargaranmet! Gam babat ufu fanu isi gong ri kau na matanfuntih na kukulii. Gam tom biil gam kau lo ke gam ka tikale fanu sabin ae ri ier isi rin kau. ");
INSERT INTO bjp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi, gam foron tom gargaranmet! Gam la na nanal ke na palgantes isi dat pes tikas isi ik mi na matngan sinangu gam. Ma aunbiing ka mi ta na sinangu gam, gam tel u isi sinangu ik laulau kanaka lo gam, ke ik kalsakai tara fangungut na tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kiskam kanaka sing gam foron famfamu ae gam kut! Gam tara la le, ‘Male tikas i falimlim ini Felun Tunmapek, ke falimlim kia i ier foes, isau male tikas i falimlim ini goul ae na Felun Tunmapek, ke falimlim kia i tekentu.’ ");
INSERT INTO bjp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gam foron talos ma gam kut! Sani i laumet? Goul, le Felun Tunmapek ae i fafuu goul la ka kalkaluu na mata God? ");
INSERT INTO bjp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Gam use u la sabin aragii, ‘Male tikas i falimlim ini salan tunmapek, ke falimlim kia i ier foes, isau male tikas i falimlim ini fafen ae ri tun u na salan tunmapek, ke falimlim kia i tekentu.’ ");
INSERT INTO bjp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gam foron kut! Neng sa lo ru i laumet? Fafen, le salan tunmapek ae i fafuu foron fafen la ka kalkaluu na mata God? ");
INSERT INTO bjp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Male tikas i falimlim ini salan tunmapek, ke i falimlim sabin ini foron fafen tikii ae na olon salan tunmapek. ");
INSERT INTO bjp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Male tikas i falimlim ini Felun Tunmapek, ke i falimlim sabin ini God ae i kiis la aiwa. ");
INSERT INTO bjp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Male tikas i falimlim ini kukulii, ke i falimlim sabin ini nian kiiskiis an King ke God ke ini God ae i kiis la lo. ");
INSERT INTO bjp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi! Gam foron tom gargaranmet! Gam ta itikii tina nenge sangful e birbiron au la ae i fafurung inen la, arae layi ke lobo, isau le biil gam misuut na foron nagogon ae i laumet. Foron nagogon aragii, sinangun nagogon ae i fafasi usuf fanu tikii, famais, ke sinangun tel foim ini tekentu. In rokap le gamen ta in tikii tina nenge sangful usuf God, isau le gong gam ruruu na foron nagogon ae i laumet. ");
INSERT INTO bjp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gam foron famfamu, gam foron kut! Aunbiing gam yin la, gam tel ufu foron menmen la tina palgan kap, isau le kamel, gam kiim u sau. ");
INSERT INTO bjp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi! Gam foron tom gargaranmet! Gam gorse poktan kap ke pelet la, isau le ae na palga, ifuun ini sinangun akalemok ke sinangun wol isi gam tom. ");
INSERT INTO bjp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“O nenge kut na Farasi. On gorse famu palgan kap ke pelet, isi poktan kap ke pelet ik fuu sabin. ");
INSERT INTO bjp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi! Gam foron tom gargaranmet! Gam arae foron matanfat una luun minet ae ri mof ta u. Ri par rokap, aunbiing ri par u tina maleh, isau le na palga, ifuun ini foron tuan minet ma foron tier tikii ae i duh. ");
INSERT INTO bjp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ke ifasi sabin arae, fanu ri par gam le gam foron tom tortores, isau le balmi ifuun ini sinangun garan ke ini foron sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kiskam kanaka sing gam foron tom fafausum ini nagogon turan foron Farasi! Gam foron tom gargaranmet! Gam tel foron fat na namnamne la na olon matmat lon foron profet, ke gam ka me fakasi matmat la ken foron tom tortores. ");
INSERT INTO bjp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ke gam ka use u la le, ‘Male kemen liu ta turan foron tubutamat kemem pakanini, ke biil kemen to fatal ta ri na siimete foron profet.’ ");
INSERT INTO bjp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Isau le igii, gam tom gam ka famalal u le, gam berberat tutus ken fanu ae ri siimete ta foron profet. ");
INSERT INTO bjp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Arik, gam farop u mang e sani ae foron tubutamat gam ri tanwara tah pakanini. ");
INSERT INTO bjp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gam foron sii! Gam foron natun sii fafangaet! Arafa gamen fin arae koseng nagogon una tara yiif ae biil i met la? ");
INSERT INTO bjp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I e wara ae ian wuun ufu foron profet ke foron tom tasum ke foron tom fafausum usuf gam. Fal lo ri, gamen siimete ri, fal gamen fakulkulik ri na aupaket, ke fal sabin gamen pis ri na foron felun lotu kimi ke gamek fes ufu ri tina maleh kimi una fale maleh keskes. ");
INSERT INTO bjp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pesu, gamen ti na nagogon isi daun foron tom tortores tikii ae ri siimete ta ri. Tipes u lo Abel ae i nenge tom tortores papang lo Sakaria, kalalik ke Berekaia, ae ri siimete ta u na fatpoton Felun Tunmapek ke salan tunmapek. ");
INSERT INTO bjp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tekentu kanaka ia fas gam, nagogon kunan foron tier tikii igii, in luut na olon fanu na ulul igii.” ");
INSERT INTO bjp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ke Iesu ka tara sabin aragii, “Ierusalem! Ierusalem! O siimete foron profet la ke o luumete fanu la ae God i wuun ta ri usuf o. Ifuun e aunbiing, ia lala ier le ian tel turim berberat kiam arae nenge tinantau ae i ruruuf na olon foron natu, isau le biil o ier isi. ");
INSERT INTO bjp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Par u, maleh kimi in pungu mang. ");
INSERT INTO bjp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ia fas gam, biil sabin gamen par iau papang na aunbiing gamen tarah, ‘Fafakalok usuf ier ae i la uga ini asa Kumguui.’” ");
INSERT INTO bjp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu ka suu tina Felun Tunmapek. Ma aunbiing ka la koseng u, berberat na fafausum kia ri ka la usuf i ma ri ka tus u ini foron fel ae na palgan ubiif kale Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ke ka fas ri aragii, “Gam par foron tier tikii igii? Tekentu kanaka ia fas gam, namih, biil mang in tikii e fat in borong na olon neng, rin lin sabalke ri tikii.” ");
INSERT INTO bjp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aunbiing Iesu i kiis na olon Pungpung na Olif, berberat na fafausum kia ri ka la usuf i ma ri ka diik fakum u aragii, “Fas kemem, nangis foron tier igii in tapiek? Ke matngan fakileng arafa in finngas u le paipaifis kiam ke farfarop na foron biing ka fatat?” ");
INSERT INTO bjp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ke Iesu ka kiliis ri aragii, “Gamen tumarang, tarama tikas ka fabal gam. ");
INSERT INTO bjp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wara le in fuun rin la ini asang ma rik use u lo ri tom le, ‘Iau e Mesaia,’ ke rik fabal fanu fuun. ");
INSERT INTO bjp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gamen ongen foron fapaket ke babauus na foron fapaket, isau le gong gam nangnangih. Foron tier arae in tapiek tom, isau le farfarop na biing biil biitom. ");
INSERT INTO bjp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nenge funmat in fapaket turan nenge funmat, ke nenge matanfuntih ik fapaket turan nenge matanfuntih. Fitol turan gih in tapiek na fale maleh. ");
INSERT INTO bjp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Foron tier tikii igii in arae tanwaran fangungut ae nenge fifin i kalsakai famu u, aunbiing i fafang. ");
INSERT INTO bjp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Namih, fanu rin ta ufu gam isi rik ta fangungut sing gam ke rik siimete gam. Ma foron funmat tikii rin ememse gam, i wara na asang. ");
INSERT INTO bjp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na aunbiing ae, unune ken fanu in luut ma rik ta ufu foron talri una liman tuui ke rik ememse fafis temtem tikii lo ri tom. ");
INSERT INTO bjp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","In fuun sabin e profet famfabal rin tapiek, ma rik fabal fanu fuun. ");
INSERT INTO bjp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sinangun famais na liu ken fanu fuun in mir, i wara le sinang laulau in laumet lalala. ");
INSERT INTO bjp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Isau le se i tifat papang na farfarop, God in faliu u. ");
INSERT INTO bjp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Rin fafas ini Rokap na Fafas na matanfuntih usuf fanu tikii na piklinbat arae orek an fafamalal usuf foron funmat tikii. Ke namih, farfarop na foron biing ik tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gamen par nenge tier ae i laulau kanaka in tapiek, in kiis na fel ae i kalkaluu ma ik fadu u. Tier igii profet Daniel i ororek famu ta isi pakanini. Se i wes foron orek igii, i rokap le in malal ulo. ");
INSERT INTO bjp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na aunbiing ae, fanse ae ri kiis na falifu na Iudaia, rin fin una foron pungpung. ");
INSERT INTO bjp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Male tikas bae na olon fel kia, aunbiing in puh, gong i kau isi kep fasuu ti minmara. ");
INSERT INTO bjp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ke male tikas awii na mok, gong i fis una fel isi kep kilkiliis kia. ");
INSERT INTO bjp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kiskam kanaka sing foron tian ke kelefin ae ri fasfasus na aunbiing ae. ");
INSERT INTO bjp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gamen sising isi aunbiing una fin gong i tapiek na funiil ae falifu i mir la, le na ti Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Wara le na aunbiing ae, tatawin in laumet kanaka tom na foron tatawin ae i tapiek la aga na piklinbat, tipes u tina tanwaran fakfakiis papang igii ma namih, biil sabin in mel e tatawin in arae. ");
INSERT INTO bjp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Male God biil in kiit fatukli aunbiing na tatawin ae, ke biil tikas in liu. Isau le in kiit fatukli u, wara lon fanu ae ka tus pes ta ri. ");
INSERT INTO bjp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Na aunbiing ae, male tikas in fas gam le, ‘Par u, igii e Mesaia,’ le, ‘Ae e Mesaia,’ gong gam unune lo. ");
INSERT INTO bjp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wara le foron mesaia famfabal ke foron profet famfabal rin tapiek. Rin fatapiek foron rakrakai na fakileng ke foron tier an fabitit. Male ri fasih, ke rik fabal fanu sabin ae God ka tus pes ta ri. ");
INSERT INTO bjp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Par u, ia ka fas famu gam mang ini foron tier ae in tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Pesu, male tikas in fas gam le, ‘Mesaia ae na sunbiil,’ gong gam la una falifu ae. Ke male tikas in fas gam le, ‘Igii na palgan fel,’ gong gam unune lo. ");
INSERT INTO bjp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wara le paipaifis ken Kalalik ken Kaltu, in arae pil ae i maeng tina falifu ae pisiih i susupiek la wah, una falifu ae pisiih i sup la lo. ");
INSERT INTO bjp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Falifu ae imel e minet lo, foron kauko rin la turim aiwa.” ");
INSERT INTO bjp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesu ka orek biitom aragii, “Aunbiing tatawin na foron biing ae in rop, fanpil ‘matan pisiih in kubunor, funiil biil in to popos, foron keltot rin luut tinbae na bat ma foron tier buuii na bat rik nut.’ ");
INSERT INTO bjp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Na aunbiing ae, fakileng na Kalalik ken Kaltu in tapiek bae na bat, ma foron funmat tikii na piklinbat rin par u ke rik teng. Rin par Kalalik ken Kaltu in tapiek na laukaf tinbae na bat ini rakrakai ke ini tara memeh kia. ");
INSERT INTO bjp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tafih in lala ninih ke ik wuun foron angelo kia isi tel turim fanu kia ae ka tim pes ta ri tina ifet e matan kif, tina nenge baban nanal una nenge baba sabin. ");
INSERT INTO bjp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gamen kep usum tina au na fik. Aunbiing foron kubu i kuum ke foron awu ka tampalas, gamen usum le foron funiil ae falifu i tuntun la ka fatat. ");
INSERT INTO bjp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ifasi sabin arae, aunbiing gam par foron tier tikii ae ia use ta u i tapiek, ke gamek usum le aunbiing ka fatat, ae mang na matanfel. ");
INSERT INTO bjp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tekentu kanaka ia fas gam, fanu na ulul igii biil biitom rin mangmangal, ke foron tier tikii igii ik tapiek. ");
INSERT INTO bjp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kukulii ke piklinbat run mangmangal, isau le foron orek kiak biil in to mangmangal. ");
INSERT INTO bjp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Biil tikas i usum na biing ke na aunbiing. Foron angelo sabin buuii na kukulii tura ke Kalalik biil ri usum, biil. Tata keskes sau. ");
INSERT INTO bjp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Biingen paipaifis ken Kalalik ken Kaltu in fasi arae na foron biing ke Noa. ");
INSERT INTO bjp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wara le na foron biing ae nor biil biitom i tapiek, fanu ri famam ien, yin ke fakekel, papang na biing ae Noa ka kau na sip. ");
INSERT INTO bjp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma biil ri usum le sani in tapiek, papang na aunbiing nor ka tapiek ke ri tikii ri ka ring. In fasi sabin arae na biingen paipaifis ken Kalalik ken Kaltu. ");
INSERT INTO bjp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na biing ae, in wu e kaltu run foim na mok, rin kep pes itikii koseng neng. ");
INSERT INTO bjp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ke in wu e fifin run gosgos wit la ini fat, ke rin kep pes itikii koseng neng. ");
INSERT INTO bjp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Pesu, gamen tumarang, wara le biil gam usum na aunbiing Kumguui kimi in tapiek lo. ");
INSERT INTO bjp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Isau le gamen malal na tier igii: Male taman fel in usum na aunbiing sa na wor ae tom sisii in tapiek lo, ke ifasi in kiis ma ik famam parpar. Biil ifasi in wol fofoes ufu tom sisii ik suksukuum na fel kia, biil. ");
INSERT INTO bjp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pesu, gam sabin gamen geges, wara le Kalalik ken Kaltu in tapiek na aunbiing ae biil gam wol le in tapiek lo.” ");
INSERT INTO bjp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Iesu ka orek biitom aragii, “Fafauun sa ae i tel fakasi foim ma imel sabin e rokap na wolwol kia? Matngan fafauun arae, laulaumet kia in luun u isi ik famfamu ken foron fafauun na fel kia ma ik fen ri na aunbiing tom una ien. ");
INSERT INTO bjp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","In kalok e fafauun ae, aunbiing laulaumet kia in tapiek ma ik par u le i tel fasuut foim kia tom. ");
INSERT INTO bjp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tekentu kanaka ia fas gam, laulaumet ae in ta ufu foron minmara tikii isi fafauun ae ik fofonoi lo. ");
INSERT INTO bjp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Isau male fafauun ae i kaltu laulau ma ka tara sing i tom aragii, ‘Laulaumet kiak biil in to fis sape,’ ");
INSERT INTO bjp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ke ka tipes paket foron tikiin foim kia, ka ien ke ka umin dan rakrakai turan foron tom ininmet. ");
INSERT INTO bjp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Laulaumet ken foron tom foim ae in tapiek na nenge biing ae biil i to wol le in tapiek lo, le na ti aunbiing ae biil i usum lo, ");
INSERT INTO bjp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ke laulaumet kia in tingting burburngi u ma ik luun u turan foron tom gargaranmet. Ma na falifu ae, rin teng ma rik faririt ngisri.” ");
INSERT INTO bjp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesu ka use u sabin aragii, “Na aunbiing ae, matanfuntih na kukulii in fasi arae nenge sangful e tah ae ri kep foron lam kiri isi rin fatafe turan kaltu ae in fakekel. ");
INSERT INTO bjp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ilim lo ri, ri talos ma ilim lo ri, imel e rokap na wolwol kiri. ");
INSERT INTO bjp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ilim ae ri talos, ri kep foron lam kiri, isau le biil ri kep ti wel sabin una nanau na lam kiri. ");
INSERT INTO bjp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma ilim ae imel e rokap na wolwol kiri, ri ka kep fale wel sabin turan foron lam kiri. ");
INSERT INTO bjp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kaltu ae in fakekel biil i tapiek sape, pesu sangful e tah ae, ka tatawin e matri, ke ri tikii ri ka masun. ");
INSERT INTO bjp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na fapot, nenge kaltu ka tautau aragii, ‘Par u! Kaltu ae in fakekel, igii mang ka tapiek! Gam la ma gamek fatafe tura.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Foron tah tikii ae ri ka mat ke ri ka geges ini foron lam kiri. ");
INSERT INTO bjp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma ilim ae ri talos, ri ka sising ilim ae imel e rokap na wolwol kiri, aragii, ‘Gam ta ti wel bii usuf kemem, wara le foron lam kimem fatat ik met.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma ilim ae imel e rokap na wolwol kiri, ri ka kiliis ri aragii, ‘Wel igii biil in to fasi lo kerer tikii. Gam la ma gamek fiil ti wel kimi na falifu ae ri fiil wel la lo.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Isau le aunbiing ri ka la ta isi fiil ti wel una foron lam kiri, kaltu ae in fakekel ka tapiek. Foron tah sau ae ri geges, ri ka kau isi ien tura na inen ken fakekel ma aunbiing ri ka kau tah, matanfel ka babat. ");
INSERT INTO bjp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Namih, ilim ae ri ka tapiek sabin ke ri ka fakam aragii, ‘Ier! Ier! Sapeng pes kemem!’ ");
INSERT INTO bjp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Isau le ka kiliis ri aragii, ‘Tekentu kanaka ia fas gam, biil ia to usum lo gam.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Pesu gam sabin, gamen tumarang, wara le biil gam usum na biing ke na aunbiing.” ");
INSERT INTO bjp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu ka use u sabin aragii, “Matanfuntih na kukulii i arae nenge kaltu ae i geges isi in la na nenge ninla. Ka kam pes ituul e fafauun kia ke ka tem foron minmara usuf rituul, isi rituulen fofonoi lo. ");
INSERT INTO bjp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka ta talen usuf rituul, neng ilim, neng iwu ke neng itikii. I ta u usuf rituul, namin tasum ken temtem tikii lo rituul. Namih, ka la na ninla kia. ");
INSERT INTO bjp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Neng ae i kep ta ilim, i la ke ka foim sape ini ke ka fatapiek ilim sabin. ");
INSERT INTO bjp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ifasi sabin arae neng ae i kep ta iwu. I foim sape ini ke ka fatapiek iwu sabin. ");
INSERT INTO bjp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Isau le neng ae i kep ta itikii, ka la, ka kef toh na nanal ma ka fun pitkalang ken laulaumet kia. ");
INSERT INTO bjp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Laulaumet kirituul ka kiis dolo tah ke nami ka fis ma ka fatortores pitkalang kia tura rituul. ");
INSERT INTO bjp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Neng ae i kep ta ilim ka la usuf laulaumet kia ini ilim sabin ke ka tarah, ‘Ier, o ta ta ilim usuf iau. Par u, ilim sabin igii ia ka fatapiek u.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Laulaumet kia ka fas u aragii, ‘Rokap kanaka na rokap na foim kiam. O nenge rokap na fafauun, o tel fasuut foim kiam. Ian luun o isi ok fofonoi na in fuun e tier, wara le o tel fasuut foim kiam ini ituul sau e tier. La uga ma karak laes turim.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ke ier sabin ae i kep ta iwu, ka la usuf laulaumet kia ke ka tarah, ‘Ier, o ta ta iwu sau usuf iau. Par u, iwu sabin igii ia ka fatapiek u.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Laulaumet kia ka fas u aragii, ‘Rokap kanaka na rokap na foim kiam. O nenge rokap na fafauun, o tel fasuut foim kiam. Ian luun o isi ok fofonoi na in fuun e tier, wara le o tel fasuut foim kiam ini ituul sau e tier. La uga ma karak laes turim.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Namih, ier ae i kep ta itikii ka la ma ka tarah, ‘Ier, ia usum le o nenge tom ngalngaliaf. O il inen la tina mok ae biil o so ta u, ke o ka lus fuan au la tina au ae biil o so ta u. ");
INSERT INTO bjp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ia soke wo, pesu ia ka la ma ia ka kef nenge toh ke ia ka fun u. Par u, igii tom e talen kiam.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Laulaumet kia ka fas u aragii, ‘O fafauun laulau ma o nenge tom angos! O usum le ia il inen la ae biil ia so ta u, ke ia ka lus fuan au la ae biil ia so ta u. ");
INSERT INTO bjp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Isi sani biil o luun ta pitkalang kiak na felun luun pitkalang, isi aunbiing ian fis, iak kep fafis u ini ti kubu? ");
INSERT INTO bjp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Kep ufu pitkalang ae sing i ma gamek ta u usuf ier ae i pose na itikii sangful. ");
INSERT INTO bjp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wara le se ae ka mel ta sing i, rin ta tifal biitom sing i, isi ik fuun. Ma se ae biil tikas sing i, ituul ae sing i, rin tel ufu koseng u. ");
INSERT INTO bjp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gam lin fasuu fafauun laulau ae una kubunor, aiwa in teng ma ik faririt ngisa.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aunbiing Kalalik ken Kaltu in fis, in tapiek ini memeh kia, turan foron angelo tikii. Ma in kiis na nian kiiskiis ken king ae ifuun ini memeh. ");
INSERT INTO bjp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Foron funmat tikii rin tapiek turim na mata ma ik fule ri, arae nenge tom fofonoi na sipsip i fule pes foron sipsip koseng foron meme. ");
INSERT INTO bjp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In fule pes foron sipsip una mia ke foron meme una kaisa. ");
INSERT INTO bjp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ke King ik fas fanu ae na mia aragii, ‘Gam la ugapiek, gam ae Tata ka fakalok ta gam. Gam la, kimi e matanfuntih ae Tata i geges ta ini le kimi na aunbiing i fakiis ta piklinbat. ");
INSERT INTO bjp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Wara le na aunbiing ia fitol, gam fen iau ini inen, ke na aunbiing ia met dan, gam faumin iau, ke na aunbiing ia arae nenge ses, gam somangat pes iau una foron fel kimi. ");
INSERT INTO bjp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aunbiing biil ti kilkiliis kiak, gam ta kilkiliis sing iau, ke aunbiing ia sasem, gam fofonoi lo iau, ke aunbiing ia kiis na kamkabet gam laum iau.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Foron tom tortores rik diik u aragii, ‘Kumguui, nangis keme par ta wo fitol ke keme ka fen o, ke o met dan ke keme ka faumin o? ");
INSERT INTO bjp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nangis keme par ta wo o arae nenge ses ke keme ka somangat pes o una foron fel kimem, ke biil ti kilkiliis kiam ke keme ka ta kilkiliis sing o? ");
INSERT INTO bjp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nangis keme par ta o sasem le o kiis na kamkabet, ke keme ka laum o?’ ");
INSERT INTO bjp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“King ae ik kiliis ri aragii, ‘Tekentu kanaka ia fas gam, sani ae gam tel ta u ulon foron tuaklik igii ae biil ti asri la, gam tel u sau ulo iau.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ke ik fas fanu sabin ae na kaisa aragii, ‘Gam ti koseng iau. Gam ae ngaliaf ke God ka kiis ta na olmi isi gamen fiu na tara yiif ae biil i met la, ae ri ka fageges ta u le ke Satan turan foron angelo kia. ");
INSERT INTO bjp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wara le na aunbiing ia fitol, biil gam fen ta iau ini ti inen, ke na aunbiing ia met dan, biil gam faumin ta iau. ");
INSERT INTO bjp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aunbiing ia arae nenge ses, biil gam somangat pes ta iau una foron fel kimi, ke aunbiing biil ti kilkiliis kiak, biil gam ta kilkiliis ta sing iau, ke aunbiing ia sasem tah, ke aunbiing ia kiis na kamkabet, biil gam fofonoi ta lo iau.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ke rik diik u sabin aragii, ‘Kumguui, nangis ae keme par o fitol, le o met dan, le o arae nenge ses, le biil ti kilkiliis kiam, le o sasem, le o kiis na kamkabet ma biil keme lupes ta o?’ ");
INSERT INTO bjp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ke ik fas ri aragii, ‘Tekentu kanaka ia fas gam, male biil gam tel ta u lon fanu ae biil ti asri la, ke biil sabin gam tel ta u ulo iau.’ ");
INSERT INTO bjp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Fanu ae, rin kep tara fangungut ae i kiis fitliu, isau le foron tom tortores rin kep liu fitliu.” ");
INSERT INTO bjp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Aunbiing Iesu ka use tikii ta foron orek igii, ka fas berberat na fafausum kia aragii, ");
INSERT INTO bjp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Arae tom gam ka usum tah, iwu mang e biing aiwa isi Ngasa na Liuliu Kulef, ke rik ta ufu Kalalik ken Kaltu isi rik fakulkulik u na aupaket.” ");
INSERT INTO bjp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Namih, foron laulaumet na pris turan foron famfamu ken fanu ri ka la turim una fel ke Kaiapas ae i famfamu ken foron pris. ");
INSERT INTO bjp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ri ka put orek isi rin luse fakum Iesu ma rik siimete u. ");
INSERT INTO bjp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ke ri ka tarah, “Gong kere tel u na aunbiing na ngasa, tarama ka mel e fapaket na fatpoton fanu.” ");
INSERT INTO bjp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu tinawii biitom na Beteni, na fel ke Saimon ae pakanini i sem ta lepra. ");
INSERT INTO bjp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aunbiing i ienien la, nenge fifin ka la usuf i ini nenge sanda ae i furung rokap ma mata i fen kanaka, pungu ri tel u ini fat ae ri foteng u ini alabasta. Ke ka fore u na olo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Isau le aunbiing berberat na fafausum ri par u, ri ka ngaliaf ma ri ka tarah, “Isi sani ka falange sanda? ");
INSERT INTO bjp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ifasi le tikas ik fiil pes ta u ini pitkalang laumet isi rik ta u usuf foron lauu.” ");
INSERT INTO bjp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu i usum tom na sani ae ri use u, pesu ka tara sing ri aragii, “Isi sani gam ka fatel fifin igii? Tier igii i tel u ulo iau, i rokap kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Foron lauu rin kiis fitliu naismi, isau le iau, biil ian kiis fitliu tura gam. ");
INSERT INTO bjp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I fore sanda igii na olong una fageges pununfong isi biingen ilile kiak. ");
INSERT INTO bjp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tekentu kanaka ia fas gam, na foron maleh tikii na piklinbat aunbiing rin fafas ini Rokap na Fafas, sani fifin igii i tel ta u, rin use u una namnamne tirik isi.” ");
INSERT INTO bjp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na aunbiing ae, Iudas Iskariot, neng lon nenge sangful ini u e kalalik na fafausum ke Iesu, ka la usuf foron laulaumet na pris ");
INSERT INTO bjp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ke ka diik ri aragii, “Male ian ta ufu Iesu usuf gam, ke sani gamen suat iau ini?” Ke ri ka ta ufu ituul e sangful e siliwa usuf i. ");
INSERT INTO bjp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tipesu mang na aunbiing ae, Iudas ka im isi ti aunbiing rokap isi ik ta ufu Iesu una limri. ");
INSERT INTO bjp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na biing famu na foron biingen ngasa na Beret ae biil ti is lo, berberat na fafausum ri ka la usuf Iesu ke ri ka diik u aragii, “Fia o ier le kemen fageges inen kiam wa una Ngasa na Liuliu Kulef?” ");
INSERT INTO bjp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ke ka kiliis ri aragii, “Gamen kau bae na Ierusalem ke gamek tafe nenge kaltu ma gamek fas u le, ‘Tom fafausum i tara le, aunbiing kia ka fatat. I turan berberat na fafausum kia rin ien inen na Liuliu Kulef aga na fel kiam.’” ");
INSERT INTO bjp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ke berberat na fafausum ri ka tel u tom arae Iesu i patrai ta ri ke ri ka fageges inen na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na efef, Iesu turan nenge sangful ini u e kalalik na fafausum kia ri ka kiis isi ien. ");
INSERT INTO bjp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Aunbiing ri ienien la, ka tarah, “Tekentu kanaka ia fas gam, neng lo gam tom in ta ufu iau una liman foron tuui.” ");
INSERT INTO bjp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka purngis kanaka e balri ke temtem tikii lo ri ka tarah, “Kumguui, o use iau?” ");
INSERT INTO bjp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu ka fas ri aragii, “Kaltu ae kaman falum turim liumah na dis, i sau in ta ufu iau. ");
INSERT INTO bjp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kalalik ken Kaltu in met arae tom ri siit ta u na Buk na Gogoh. Isau le kiskam kanaka sing ier ae in ta ufu Kalalik ken Kaltu una liman foron tuui. In rokap male biil in pang tah.” ");
INSERT INTO bjp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ke Iudas, ae in ta ufu Iesu, ka diik u aragii, “Rabi, o use iau?” Ke Iesu ka kiliis u aragii, “Iuu, wo sau.” ");
INSERT INTO bjp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Aunbiing ri ienien la, Iesu ka kep beret, ka fotrokap lo usuf God, ka simsibik u ke ka fen berberat na fafausum kia ini, ma ka tarah, “Pununfong igii, gam kep u ke gamek ien u.” ");
INSERT INTO bjp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Namih, ka kep kap na wain, ka fotrokap lo usuf God ke ka ta u usuf ri ma ka tarah, “Gam tikii gam yin lo. ");
INSERT INTO bjp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Igii e daung ae i fasuut puput ke God. I ring una tel ufu sinang laulau ken fanu fuun. ");
INSERT INTO bjp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ia fas gam le biil sabin ian umin danun wain igii, papang na biing ian umin wain fuuh tura gam na matanfuntih ke Tata.” ");
INSERT INTO bjp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ke aunbiing ri ka sek ta nenge seksek, ri ka suuh ma ri ka la una Pungpung na Olif. ");
INSERT INTO bjp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ke Iesu ka fas ri aragii, “Igii na wor, gam tikii gamen fin koseng iau, i wara na foron tier ae rin tel u ulo iau. Arae ri siit ta u na Buk na Gogoh le God i tarah, ‘Ian siimete tom fofonoi na sipsip ma uh na sipsip ik sararah.’ ");
INSERT INTO bjp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Isau le aunbiing iak apti fis tah, ian famu lo gam una Galili.” ");
INSERT INTO bjp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ka kiliis u aragii, “Taftawa le ri tikii rin fin koseng o, wara na foron tier ae rin tel u ulo wo, ia biil tom.” ");
INSERT INTO bjp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu ka fas u aragii, “Tekentu kanaka ia fas o, igii na wor aunbiing to biil biitom in teng, ke fatuul ok fakawe ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Isau le Pita ka kiliis u aragii, “Taftawa le ian met turam, biil tom ian fakawe ufu wo.” Ke berberat na fafausum tikii sabin, ri ka use u arae. ");
INSERT INTO bjp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Namih, Iesu turan berberat na fafausum kia ri ka tapiek na falifu ae ri foteng u ini Getsemani ke ka fas ri aragii, “Gamen kiis sau aga ma iak la bii isi sising.” ");
INSERT INTO bjp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka telpes Pita turan iwu e kalalik ke Sebedi. Na aunbiing ae, ka tipes kalsakai tara mamais ma ka purngis e bala. ");
INSERT INTO bjp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ke ka fas rituul aragii, “Mamais ifuun na balang, ma fatat iak met. Gamtuulen kiis agawa ma gamtuulek mat turang.” ");
INSERT INTO bjp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ka mamlik la ituul sau ke ka luutuf ini posong na mata una nanal ma ka sising aragii, “Tata, male ifasi, ke ok tel ufu kap igii koseng iau. Isau le gong o mi lo arae na wolwol kiak, mi tom lo arae na wolwol kiam.” ");
INSERT INTO bjp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aunbiing i fis, ka par u le tuul kalalik na fafausum kia rituul masun. Ke ka diik Pita aragii, “Arafah, biil ifasi gamtuulen mat bii turang na fatuklin aunbiing? ");
INSERT INTO bjp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mat ma gamtuulek sising, tarama gamtuul ka luut na fatoftof. Tanwa gamtuul i gesges, isau le fo gamtuul i mut.” ");
INSERT INTO bjp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ke fawu sabin ka la koseng rituul ma ka sising aragii, “Tata, male kap igii biil ifasi in la koseng iau ma o ka ier le ian yin tom lo, taftawa on mi tom lo arae na wolwol kiam.” ");
INSERT INTO bjp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aunbiing ka fis, ka par u sabin le rituul ka masun fis tah, wara le matrituul i tatawin kanaka. ");
INSERT INTO bjp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka la koseng rituul sabin, ke na fatuul u e sising kia, ka sising sabin arae tom i sising tah. ");
INSERT INTO bjp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka fis sabin usuf rituul, ke ka tarah, “Gamtuul borborong la biitom? Par u, ka fatat mang e aunbiing isi rik ta ufu Kalalik ken Kaltu una liman foron tom tel sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aptih ma kerek la! Par u, apiek mang e kaltu ae in ta ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Aunbiing Iesu i ororek la biitom, Iudas neng lon sangful ini u e kalalik na fafausum, ka tapiek turan nenge tara gur na fanu. Ri kep foron popok una fapaket turan foron kapsil. Foron laulaumet na pris turan foron famfamu ri wuun ufu ta ri. ");
INSERT INTO bjp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ier ae in ta ufu Iesu ka fas famu ta fanu ae ini matngan fakileng ae in tel u ulo Iesu. I fas ri aragii, “Ier ae ian dor u, i sau e kaltu ae. Gam luse u.” ");
INSERT INTO bjp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Fanpil Iudas ka la usuf Iesu ke ka faorek pes u aragii, “Rabi, wor mang!” Ke ka dor u. ");
INSERT INTO bjp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ke Iesu ka fas u aragii, “Talang, tier o la isi, tel u mang.” Ri ka la, ri ka pose lo ma ri ka dat pes u. ");
INSERT INTO bjp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Neng lo ri ae ri lala tura Iesu, ka fut ufu popok una fapaket kia ke ka kasim ufu balbalun fafauun ken famfamu ken foron pris. ");
INSERT INTO bjp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Isau le Iesu ka fas u aragii, “Siing fafis popok kiam na poko! Wara le fanu tikii ae ri fating ini popok una fapaket, rin met sabin arae. ");
INSERT INTO bjp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Arafah, o wol le i ngangaten ulo iau isi ian sising Tata, isi igii tom ik wuun ufu ti foron angelo ae wewes lo ri in laumet lon ifit e sangful e arip, ma rik fapaket isi iau? ");
INSERT INTO bjp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Isau male ian tel u arae, ke foron orek ae na Buk na Gogoh biil mang in to suut, ae i ororek ta isi foron tier ae in tapiek lo iau.” ");
INSERT INTO bjp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na aunbiing ae, Iesu ka fas gur na fanu aragii, “Arafah, awii ngan ia nenge tom sisiimete, ae gam ka la ini foron popok una fapaket turan foron kapsil isi luse iau? Foron biing tikii ia kiis la na Felun Tunmapek ma ia ka fausum fanu la, ke biil gam luse iau. ");
INSERT INTO bjp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Foron tier tikii igii i tapiek una fasuut orek ae na Buk ken foron profet.” Ke berberat na fafausum tikii kia ri ka apti koseng u ma ri ka fin. ");
INSERT INTO bjp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ke fanu ae ri luse ta Iesu ri ka lame u una fel ke Kaiapas, famfamu ken foron pris. Ma foron tom fafausum ini nagogon turan foron famfamu ri ka kiis turim ta aiwa. ");
INSERT INTO bjp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita i mimi susu la tom ma ka kau una palgan ubiif kale fel ken famfamu ken foron pris. Ka kiis turan foron tom parpar kaleh, isi ik par sani in tapiek lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Foron laulaumet na pris turan foron famfamu tikii ken fan Iudaia, ri ka im isi ti fale orek lemlem una tiu Iesu isi rik siimete u. ");
INSERT INTO bjp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Isau le biil ri tafe tikas, taftawa le fanu fuun ri tapiek ini foron lem kiri. Nami mang tom, iwu e kaltu ru ka tapiek ");
INSERT INTO bjp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ke ru ka tarah, “Kaltu igii i tara ta le ifasi in rabat ufu Felun Tunmapek ke God, ma ik fapti fafis u na in tuul e biing sau.” ");
INSERT INTO bjp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Famfamu ken foron pris ka sotih ke ka tara sing Iesu aragii, “Arafah, biil ti orek kiam una kiliis u? Orek arafa igii ru tiu o ini?” ");
INSERT INTO bjp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Isau le Iesu biil i kiliis u. Ke famfamu ken foron pris ka fas u aragii, “Ia sising o le on falimlim ini asa God ae i liu. Fas kemem, o Mesaia Kalalik ke God, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ke Iesu ka kiliis u aragii, “Iuu, arae o ka use ta u. Isau le ia fas gam tikii, ae namih, gamen par Kalalik ken Kaltu in kiis na mia God ae i Rakrakai, ma in tapiek na laukaf tinbae na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Famfamu ken foron pris ae ka si dolon kaen kia tom ma ka tarah, “Ier igii ka orek laulau ta ulo God! Isi sani biitom kere ka ier isi ti orek una tiu u? Par u, gam ka ongen ta u e foron orek laulau kia ulo God. ");
INSERT INTO bjp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Arafa gam wol arae?” Ke ri ka kiliis u aragii, “I rokap le in met.” ");
INSERT INTO bjp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ke ri ka ubis u na posong na mata ma ri ka tut u. Fal ri ka pose u ");
INSERT INTO bjp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ke ri ka diik u aragii, “Mesaia, on orek profet usuf kemem, se i tut o?” ");
INSERT INTO bjp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita i kiis la biitom aiwa na palgan ubiif kale fel ae, ke nenge tah, fafauun tina fel ae, ka la usuf i ke ka tara sing i aragii, “O sabin o neng lon fanu ae ri la la tura Iesu tina Galili.” ");
INSERT INTO bjp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Isau le Pita ka fakawe na matan fanu tikii ae aragii, “Biil ia usum na sani o use u.” ");
INSERT INTO bjp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Namih, ka suu una matan ubiif, ke nenge tah sabin ka par u ke ka fas fanu ae aragii, “Ier igii i la la tura Iesu tina Nasaret.” ");
INSERT INTO bjp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka fakawe sabin, ke ka falimlim ma ka tarah, “Biil ia to usum lo e kaltu ae.” ");
INSERT INTO bjp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Namih, fanu ae ri sotsoti la aiwa ri ka la usuf Pita ke ri ka tara sing i aragii, “Tekentu tom le wo sabin o neng lo ri, wara le keme ongen failiim o na orek kiam.” ");
INSERT INTO bjp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ke ka tipes fotfot ulo tom aragii, “God in ta fangungut sing iau male ian lem. Biil ia to usum lon kaltu ae.” Ke fanpil, nenge to ka teng. ");
INSERT INTO bjp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ke Pita ka wolpes orek ae Iesu i use ta u aragii, “Aunbiing to biil biitom in teng, ke fatuul ok fakawe ufu iau.” Ka suu tina falifu ae ke ka sikpes tineng. ");
INSERT INTO bjp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na biingbiing saksak, foron laulaumet na pris tikii turan foron famfamu ken fanu, ri ka put orek isi rin siimete Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri ka kabet iun lima ke ri ka lame ufu usuf Pailat, famfamu na matanfuntih na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iudas i ta ufu ta Iesu una liman tuui. Aunbiing ka usum mang le ri ka nagogon ta Iesu isi ik met, ka kiliis wolwol kia ke ka la isi ta fafis ituul e sangful e siliwa ae usuf foron laulaumet na pris turan foron famfamu. ");
INSERT INTO bjp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ke ka fas ri aragii, “Ia ka tel ta sinang laulau, wara le ia ka ta ufu ta kaltu ae biil ti sinang laulau kia isi rin siimete u.” Isau le ri ka kiliis u aragii, “Sani kimem lo? Tier kiam tom ae!” ");
INSERT INTO bjp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka lin sarara foron siliwa aiwa na palgan Felun Tunmapek ke ka la ma ka bibing. ");
INSERT INTO bjp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Foron laulaumet na pris ri ka sik turim foron siliwa ae, ke ri ka tarah, “Na nagogon, biil i tortores le keren luun u na salan luun pitkalang na Felun Tunmapek, wara le i fifiil na minet ken nenge kaltu.” ");
INSERT INTO bjp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ke ri ka somangat isi rin fiil sun nanal ken tom tel sospen ini pisak, una salan ililii ken foron ses ini pitkalang ae. ");
INSERT INTO bjp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pesu, ri ka foteng u e sun nanal ae le, “Nanal na Dah.” Papang igii, ri foteng u la biitom arae. ");
INSERT INTO bjp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ke sani ae profet Jeremaia i use famu ta u ulo Iesu, ka suut mang, ae i tarah, “Ri kep ituul e sangful e siliwa, i e mata ae fan Israel ri somangat ta le rin fiil liu kia ini. ");
INSERT INTO bjp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ke ri ka fiil sun nanal ken tom tel sospen, arae tom Kumguui i fas ta iau.” ");
INSERT INTO bjp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu ka ti na mata Pailat, famfamu na matanfuntih na Iudaia ke Pailat ka diik u aragii, “Be, o king ken fan Iudaia?” Iesu ka kiliis u aragii, “Arae tom o use u.” ");
INSERT INTO bjp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aunbiing foron laulaumet na pris turan foron famfamu ri tiu u, biil i to kiliis ri. ");
INSERT INTO bjp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ke Pailat ka diik u aragii, “Arafah, biil o ongen foron orek ae ri tiu wo ini?” ");
INSERT INTO bjp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Isau le Iesu biil i kiliis ti orek kiri. Pesu, Pailat ka lala wolpane. ");
INSERT INTO bjp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na foron bet tikii na Ngasa na Liuliu Kulef, famfamu na matanfuntih na Iudaia i fasuu ufu itikii la e kaltu tina kamkabet ae fanu ri tim pes u. ");
INSERT INTO bjp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na bet ae, nenge kaltu asa e Barabas i kiis na kamkabet, ma fanu tikii ri usum le i nenge kaltu laulau. ");
INSERT INTO bjp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Aunbiing gur na fanu ae ri ka la turim, Pailat ka diik ri aragii, “Gam ier le ian fasuu se tina kamkabet usuf gam? Barabas le Iesu ae ri foteng u ini Mesaia?” ");
INSERT INTO bjp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I use u arae, wara i usum le ri ta ufu Iesu una lima ini wolwol laulau sau kiri. ");
INSERT INTO bjp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aunbiing Pailat i tel nagogon la biitom, antu ka ta orek usuf i aragii, “Gong o tel ti tier ini kaltu ae, wara le biil i tel ti sinang laulau. Na wor ia borong ke ia ka nimbiilnge u ma foron tier ia par u na nimnibiil kiak ka fatel iau ma ka purngis e balang.” ");
INSERT INTO bjp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Isau le foron laulaumet na pris turan foron famfamu ken fanu, ri ka siingsiing orek na balan gur na fanu ae isi rin sising Pailat isi in fasuu Barabas ma rik siimete Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat ka diik ri aragii, “Se lo ruh, gam ier le ian fasuu ufu usuf gam?” Ri ka kiliis u aragii, “Barabas.” ");
INSERT INTO bjp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat ka diik ri aragii, “Sani mang iak tel u ini Iesu, ae ri foteng u ini Mesaia?” Ri tikii ri ka teme kiliis u aragii, “Fakulkulik u na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ke ka diik ri sabin aragii, “Isi sah? Sani i tel fager ta u?” Isau le ri ka lala perek mang tom le, “Fakulkulik u na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aunbiing Pailat ka par u le biil mang ifasi in orek kale Iesu ma fatat nenge tara na fapaket ik tapiek, ka kep dan ma ka sofolim na matan gur na fanu ae ke ka tarah, “Ia sengsegeng koseng daun tom tortores igii. Gam tom rin nagogon gam isi.” ");
INSERT INTO bjp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Fanu tikii ri ka kiliis u aragii, “Taftawa, rik nagogon kemem turan berberat kimem isi dawu.” ");
INSERT INTO bjp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ke Pailat ka fasuu ufu Barabas usuf ri. Ka fas foron tom fapaket isi rin fuk Iesu, nami ka ta ufu isi rin fakulkulik u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Foron tom fapaket ke Pailat ri lame fakau Iesu una tara fel ae Pailat i kiis la lo, ke ri ka tawi turim foron tom fapaket tikii isi rin ka kawil u. ");
INSERT INTO bjp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ri ka kasis ufu kilkiliis kia ke ri ka fakilkiliis u ini nenge dolon kaen melmelek. ");
INSERT INTO bjp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma ri ka tel nenge bangbang ini finau ae imel e si ke ri ka luun u na paklu. Ri ka ta nenge bis na mia, ri ka ilepul na mata ke ri ka morot ini aragii, “King ken fan Iudaia, mangiam!” ");
INSERT INTO bjp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aunbiing ri ka ubis ta u, ri ka kep bis ae tina lima ke ri ka famam paket paklu ini. ");
INSERT INTO bjp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Aunbiing ri ka morot ta ini, ri ka kasis ufu dolon kaen ae lo. Ri ka fakilkiliis fafis u ini kilkiliis kia ke ri ka lame ufu isi rik fakulkulik u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Aunbiing ri ka suu tinaiwa, ri ka tafe nenge kaltu tina Sairini asa e Saimon. Ri ka fangongos u isi in kusep aupaket ke Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ri ka tapiek na falifu ae ri foteng u ini Golgota. Kamtinan as ae le, Salan Tuan Paklun Kaltu. ");
INSERT INTO bjp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ri ka ta wain usuf Iesu, ae ri ikis u turan nenge tier ae i mamapek. Isau le aunbiing Iesu i tof u, biil i ier isi umin u. ");
INSERT INTO bjp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ke aunbiing ri ka fakulkulik ta u na aupaket, ri ka fangfang laki isi rik tem foron kilkiliis kia lo ri. ");
INSERT INTO bjp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Namih, ri ka kiis ke ri ka parpar kale Iesu. ");
INSERT INTO bjp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bae na olon aupaket isi paklu, ri ka siit nenge sun orek ae ri tiu u ini aragii: ");
INSERT INTO bjp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ke ri ka fakulkulik iwu sabin e tom sisii tura na iwu e aupaket, neng na mia ke neng na kaisa. ");
INSERT INTO bjp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Fanu ae ri liuliu ufu Iesu la, ri ka famam orek laulau ulo ke ri ka famam pakpakte paklu ri ulo. ");
INSERT INTO bjp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ma ri ka tarah, “O ae o tara ta le on rabat ufu Felun Tunmapek ma ok fapti fafis u na in tuul e biing, ok faliu fafis wo tom! Male o Kalalik ke God, ke ok pu tinbae na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ke foron laulaumet na pris, foron tom fafausum ini nagogon turan foron famfamu ri ka morot ini ma ri ka tarah, ");
INSERT INTO bjp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I faliu fal, isau le biil ifasi in faliu fafis u tom. Male i King ken fan Israel, ke ik pu tinbae na aupaket isi kerek unune lo. ");
INSERT INTO bjp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I unune lo God ke ka tara sabin le, i Kalalik ke God. Male God i ier isi, ke igii tom in faliu u.” ");
INSERT INTO bjp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iun tom sisii sabin ae ri fakulkulik ta ru tura Iesu, ru ka orek laulau ulo. ");
INSERT INTO bjp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tipesu na sangful ini u e aunbiing na siat, papang na ituul e aunbiing na efef, falifu tikii ka kubunor. ");
INSERT INTO bjp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma na ituul e aunbiing na efef, Iesu ka ngangeh aragii, “Eloi, Eloi lama sabakatani?” Kamtinan orek ae i aragii, “God kiak, God kiak, isi sa o ka la koseng iau?” ");
INSERT INTO bjp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Fale fanu ae ri sotsoti la aiwa, ri ongen Iesu i ngangeh arae ke ri ka tarah, “I tawi Elaija.” ");
INSERT INTO bjp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Fanpil ke neng lo ri ka filau ka kep nenge tier ae i duup pes dan la, ka falum u na wain ae i mingin, ka tu u na nenge au ke ka sik u una mawe isi Iesu ik duup u. ");
INSERT INTO bjp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Isau le fal ri ka tarah, “Nene, kerek par u la bii. Tarama Elaija ka la isi faliu u.” ");
INSERT INTO bjp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ke Iesu ka lala ngangeh sabin ke ka sok ufu liu kia. ");
INSERT INTO bjp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na aunbiing masau ae, tara kaen na Felun Tunmapek, ae i balo kale mua ae na palga, ka tamsih tinbae na mawe ubuif sikit na pikli. Nanal ka nut ma foron fat ka tamtampaek. ");
INSERT INTO bjp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Foron matanfat una luun minet ka sapeng, ke ifuun e fanu kalkaluu ae ri ka met ta, ri ka apti fis sabin. ");
INSERT INTO bjp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ri ka suu tina foron matanfat, ma aunbiing Iesu ka apti fis tah, ri ka la una Maleh Kalkaluu ma ri ka tapiek sing fanu fuun. ");
INSERT INTO bjp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aunbiing kabisit ken foron tom fapaket ke fanu sabin ae ri parpar kale lo Iesu, ri ongen gih ma ri ka par foron tier ae i tapiek, ri ka lala sokeh ke ri ka tarah, “Tekentu kanaka, ier igii i e Kalalik ke God.” ");
INSERT INTO bjp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ifuun e kelefin ri soti tina tapak ma ri ka alim foron tier ae i tapiek. Kelefin ae ri mi ta lo Iesu tina Galili isi lupes u. ");
INSERT INTO bjp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tuul fifin sabin igii tinaiwa naisan kelefin ae, Maria Makdalin, Maria tina Jems ru e Joses, ke tinan iun kalalik ke Sebedi. ");
INSERT INTO bjp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nenge kaltu tina Arimatia, asa e Josep, ifuun e minsik kia ma i neng lon berberat na fafausum ke Iesu. Na efef, aunbiing pisiih biil biitom i sup, ");
INSERT INTO bjp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ka la usuf Pailat ke ka sising u isi pununfo Iesu. Ke Pailat ka fas foron tom fapaket isi rin ta ufu usuf Josep. ");
INSERT INTO bjp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ka kep pununfo Iesu ke ka afit u ini nenge rokap na kaen fuuh. ");
INSERT INTO bjp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ke ka fakau u na matanfat fuu kia tom ae i tuung ta u na balan fat una luun minet. Ka fabulbulis nenge tara fat kale matanfat ae ke ka la. ");
INSERT INTO bjp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdalin ru e nenge Maria sabin ru kiiskiis la aiwa fatat isi matanfat ae. ");
INSERT INTO bjp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na biing namih, i e Biingen Mangeh, foron laulaumet na pris turan foron Farasi ri ka la turim unaisa Pailat ");
INSERT INTO bjp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ke ri ka fas u aragii, “Ier, keme ka wolpes nenge orek ken tom gargaranmet ae i use ta u aunbiing i liu biitom. I use ta u le nami na in tuul e biing in apti fis sabin. ");
INSERT INTO bjp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wuun ufu ti fanu isi rik parpar rokap kale matanfat ae na in tuul e biing, tarama berberat na fafausum kia ri ka la ma ri ka sukuum pes pununfo ke rik fas fanu le ka apti fis tah. Famfabal kiri igii, ik laumet na famfabal ke Iesu ae i use ta u pakanini.” ");
INSERT INTO bjp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ka fas ri aragii, “Gam tel pes ti foron tom fapaket isi rik parpar rokap kale matanfat ae, arae tom na tasum kimi.” ");
INSERT INTO bjp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ke ri ka la ma ri ka babat rakrakai na matanfat ae. Ke ri ka luun nenge fakileng lo. Ri ka fas foron tom fapaket isi rin parpar kale na matanfat ae. ");
INSERT INTO bjp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nami na Biingen Mangeh, na biingbiing saksak na biing famu na wik, Maria Makdalin ru e nenge Maria sabin ru ka la isi par matanfat una luun minet ae. ");
INSERT INTO bjp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nenge tara gih ka tapiek, wara le nenge angelo ke Kumguui i pu tinbae na kukulii ke ka fabulbulis ufu fat tinawii na matanfat ae ma ka kiis ta mang na olon fat ae. ");
INSERT INTO bjp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Posong na mata i kilangkilang arae pil ma foron kilkiliis kia i lala pos arae laukaf. ");
INSERT INTO bjp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Foron tom fapaket ae ri parpar kale matanfat, ri ka soke u, ri ka nananar ma ri ka met pelpel. ");
INSERT INTO bjp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Isau le angelo ae ka fas iun fifin ae aragii, “Gong kamu sokeh, ia usum le kamu im isi Iesu ae ri fakulkulik ta u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mangmangal mang aga, ka apti fis tah, arae tom i use ta u. Kamu la ma kamuk par falifu ae i borong ta lo. ");
INSERT INTO bjp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kamun fis sape ke kamuk fas berberat na fafausum kia aragii, ‘Iesu ka apti fis ta tina minet. In famu lo gam una Galili ma gamen tafe u aiwa.’ Par u, igii ia ka fas ta kamuh.” ");
INSERT INTO bjp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ke ru ka fis sape tina matanfat ae. Ru sokeh, isau le ru fuun ini laes. Ru ka filau isi fas berberat na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Fanpil Iesu ka tafe ruh ke ka faorek pes ru aragii, “Biingbiing mang.” Ru ka la usuf i, ru ka pose na iun keke ke ru ka lotu unaisa. ");
INSERT INTO bjp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ke Iesu ka fas ru aragii, “Gong kamu sokeh, kamu la ma kamuk fas foron tuaklik le rin la una Galili ma rik tafe iau aiwa.” ");
INSERT INTO bjp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aunbiing iun fifin ae ru toltole sal la biitom, fale tom fapaket ae ri parpar kale matanfat ae, ri ka la una Ierusalem ke ri ka fas foron laulaumet na pris ini foron tier ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Aunbiing foron laulaumet na pris turan foron famfamu ri kiis turim, ri ka put orek turim isi ti sal rin mih lo. Ri ka ta ifuun e pitkalang usuf foron tom fapaket ae ");
INSERT INTO bjp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ke ri ka fas ri aragii, “Gamen fas fanu le, na wor aunbiing gam masun, berberat na fafausum kia ri ka la ma ri ka sukuum pes pununfo. ");
INSERT INTO bjp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Male famfamu na matanfuntih in ongen u ma ka diik, ke kemen orek kale gam sing i.” ");
INSERT INTO bjp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ke ri ka pose pes pitkalang ae ma ri ka mi lo arae foron laulaumet na pris ri fas ta ri. Ma ususe ae ka sarara na fatpoton fan Iudaia, papang igii. ");
INSERT INTO bjp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ke, sangful ini tikii e kalalik na fafausum ke Iesu ri ka la una Galili, una pungpung ae Iesu i fas ta ri le rin la ulo. ");
INSERT INTO bjp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aunbiing ri ka tapiek, ri ka par u ma ri ka lotu unaisa. Isau le fal lo ri, biil ri unune. ");
INSERT INTO bjp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu ka la usuf ri ke ka fas ri aragii, “Foron rakrakai una nagogon tikii bae na kukulii ke aga na piklinbat, God ka ta ta u usuf iau. ");
INSERT INTO bjp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pesu, gamen la una foron funmat tikii ke gamek fausum fanu isi ri sabin rik tapiek berberat na fafausum kiak. Gamen baptais ri ini asa Tata, ke Kalalik ke Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ke gamek fausum ri isi rik mi na foron orek tikii ae ia ka fas ta gam ini. Tekentu kanaka, ian kiis fitliu naismi una farfarop na aunbiing.” ");
INSERT INTO bjp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Igii e tanwaran Rokap na Fafas ulo Iesu Karisito, Kalalik ke God. ");
INSERT INTO bjp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Orek ke God ae profet Aisaia i siit ta u i tarah, “Ian wuun famu tom fafas kiak lo wo, ae in fageges sal salam.” ");
INSERT INTO bjp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kinen tikas i tautau na sunbiil aragii, “Fageges sal sala Kumguui, fatortores sal sala.” ");
INSERT INTO bjp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon ka tapiek na falifu foes, ka famam baptais fanu ke ka famam fafas sing ri le rin sokiliis liu kiri ma rik kep bapitaiso, isi God ik pa ufu foron sinang laulau kiri. ");
INSERT INTO bjp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fanu tina foron maleh tikii na falifu na Iudaia turan fanu tikii tinbae na Ierusalem ri ka la usuf i. Ri ka fapos foron sinang laulau kiri ke Jon ka baptais ri na dan na Ioridan. ");
INSERT INTO bjp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon i kilkiliis la ini kaen ae ri tel u ini olon kamel ke ka fis lifa la ini pus ae ri tel u ini punun bulmakau. Ma i ien sukuuw la turan mindu aka. ");
INSERT INTO bjp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma ka fafas aragii, “Ier ae in mi pes iau, rakrakai kia i liu kulkulef na rakrakai kiak. Pesu, biil ia tortores isi ifasi ian parau ma iak puk ufu finaun su kia. ");
INSERT INTO bjp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ia baptais gam ini dan, isau le in baptais gam ini Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na aunbiing ae, Iesu ka la tina Nasaret na falifu na Galili ma Jon ka baptais u na dan na Ioridan. ");
INSERT INTO bjp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aunbiing Iesu ka apti tina dan, ka par kukulii i sapsapeng la ma Tanwa Kalkaluu ka pu arae nenge bun ulo. ");
INSERT INTO bjp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma kinen tikas ka orek tinbae na kukulii aragii, “O keng Kalalik ae ia ier kanaka isi wo. Ia laes kanaka ini wo.” ");
INSERT INTO bjp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma fanpil, Tanwa Kalkaluu ka wuun ufu una sunbiil. ");
INSERT INTO bjp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ka kiis pes ifet e sangful e biing aiwa ma Satan ka tof u. Foron muruuw aka sabin tinaiwa, isau le foron angelo ri ka lupes u. ");
INSERT INTO bjp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aunbiing ri ka luun ta Jon na felun kamkabet, Iesu ka la una falifu na Galili ma ka famam fafas ini Rokap na Fafas ke God. ");
INSERT INTO bjp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke Iesu ka tarah, “Aunbiing ka tapiek tah, matanfuntih ke God ka fatat. Gamen sokiliis liu kimi ma gamek unune na Rokap na Fafas!” ");
INSERT INTO bjp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na aunbiing Iesu i tole bulin dan kawil na Galili, ka par Saimon ru latualik e Enru ru linlin ubiin la na dan, wara le ru un tom ienmaket. ");
INSERT INTO bjp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ke ka tara sing ru aragii, “Kamu mi lo iau isi iak fausum kamu ini sinangun dat fanu.” ");
INSERT INTO bjp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Fanpil ru ka la koseng foron ubiin kiruh ke ru ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesu i la ituul sau ke ka par iun kalalik ke Sebedi, Jems ru latualik e Jon. Ru tumtumarnge foron ubiin kiru la awii na palgan mon. ");
INSERT INTO bjp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Fanpil Iesu ka tawi pes ruh, ma ru ka kang koseng temruh turan foron tom foim kiri aiwa na mon ke ru ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri ka la una Kapernaum, ma na Biingen Mangeh, Iesu ka kau una felun lotu ma ka tipes fausum fanu. ");
INSERT INTO bjp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Fanu tikii ae ri ongen fafausum kia ri ka bitit, wara le biil i fausum ri arae foron tom fafausum ini nagogon ri fausum ri la, biil. I fausum ri aragii kaltu ae God tom i ta rakrakai usuf i. ");
INSERT INTO bjp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na aunbiing ae, nenge kaltu aiwa na felun lotu ae tanwa laulau i susuef ulo, ka perek aragii, ");
INSERT INTO bjp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu tina Nasaret, sani o ier le on tel u ini kemem? O la isi falaulau kemem? Ia usum le wo e seh. O Kaltu Kalkaluu ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ke Iesu ka fakiing u aragii, “Babat na ngusum ma ok suu koseng kaltu ae!” ");
INSERT INTO bjp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tanwa laulau ae ka gule falaulau kaltu ae, ka lala ngangeh ke ka suu koseng u. ");
INSERT INTO bjp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ke fanu tikii aiwa ri ka bitit ma ri ka fadiik faliu ini ri aragii, “Sani aragii? Fafausum fuu ae imel e rakrakai lo? Kaltu igii i fakiing foron tanwa laulau ma ri wong tom sing i.” ");
INSERT INTO bjp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma fanpil, ususe lo Iesu ka sarara na foron falifu tikii na Galili. ");
INSERT INTO bjp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Fanpil, Iesu turan berberat na fafausum kia ri ka suu tina felun lotu ke ri ka la tura Jems ru e Jon una fel ke Saimon ru e Enru. ");
INSERT INTO bjp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tina antu Saimon i borong kiniis ini gogor, ke ri ka fas Iesu ini. ");
INSERT INTO bjp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu ka la usuf i, ka pose na lima ke ka fapti u. Ke sasem ka rop koseng u ke ka tipes sosok ari. ");
INSERT INTO bjp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aunbiing pisiih ka sup ta na efef, fanu ri ka filange fanu tikii ae ri sasem turan fanu tikii ae tanwa laulau i susuef ulo ri usuf Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ke fanu tikii na tara maleh ri ka tapiek turim una matanfel ae. ");
INSERT INTO bjp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ke Iesu ka faliu ifuun e fanu ini marmarsan sasem ma ka tel ufu ifuun e tanwa laulau. Isau le biil i somangat isi foron tanwa laulau rin use ti tier, wara le ri usum le i e seh. ");
INSERT INTO bjp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na biingbiing saksak, aunbiing pisiih biil biitom i supiek, Iesu ka aptih, ka suu tina fel ma ka la una nenge kiptin biil isi sising. ");
INSERT INTO bjp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ke Saimon turan foron tala ri ka im isi. ");
INSERT INTO bjp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma aunbiing ri ka tafe u, ri ka tarah, “Fanu tikii ri famam im isi wo.” ");
INSERT INTO bjp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ke Iesu ka tara sing ri aragii, “Kere mang na ti fale maleh fatat, isi iak fafas sabin aiwa. I e wara ae ia ka la uga.” ");
INSERT INTO bjp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I la na foron falifu tikii na Galili. Ka famam fafas na foron felun lotu kiri ke ka tel ufu foron tanwa laulau. ");
INSERT INTO bjp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nenge kaltu ae i sem lepra ka la, ka ilepul na mata Iesu ma ka sising u aragii, “Male o ier isi, ke ok fafuu pes iau.” ");
INSERT INTO bjp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu ka mais u, ka sawe lima, ka pose lo ke ka tarah, “Ia ier isi. On fuuh!” ");
INSERT INTO bjp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Fanpil lepra ka rop tina pununfo ke ka tapiek fuuh. ");
INSERT INTO bjp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ma Iesu ka wuun ufu ke ka fanau u aragii, ");
INSERT INTO bjp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ongen u, gong o fas tikas ini sani i tapiek lo wo. Isau le on la ma ok finngas pununfom sing pris ke ok ta fafen kiam usuf God, arae Moses i use ta u isi rik usum le sasem kiam ka rop tah.” ");
INSERT INTO bjp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Isau le kaltu ae ka la bin ke ka fasarara ususe na foron maleh tikii ini sani i tapiek ta lo. I e wara ae Iesu biil mang i to la malal la na matan fanu na ti maleh. Ka kiis sau na foron sunbiil, isau le fanu tina marmarsan falifu ri famam la biitom usuf i. ");
INSERT INTO bjp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Fale biing namih, Iesu ka fis sabin una Kapernaum ke fanu fuun ri ka ongen u le Iesu ae mang ta na fel. ");
INSERT INTO bjp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pesu, ifuun ri ka tapiek aiwa, ma fel ae ka fuun. Awii sabin na matanfel biil mang ti mua. Ma Iesu ka fafas usuf ri. ");
INSERT INTO bjp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Fale fanu ri ka tapiek ini nenge peo, ma ifet lo ri, ri kep u ini mii sala. ");
INSERT INTO bjp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Isau le, biil ifasi rin kep u usuf Iesu, wara le falifu ifuun ini fanu. Pesu, ri ka fen ubae na olon fel ke ri ka tel nenge solsol tortores bae na olo Iesu, ke ri ka fasiluung peo ae ini mii sala. ");
INSERT INTO bjp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aunbiing Iesu ka par unune kiri, ka tara sing peo ae aragii, “Keng kalalik, foron sinang laulau kiam, ia ka pa ufu tah.” ");
INSERT INTO bjp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Fale tom fafausum ini nagogon ae ri kiis ta aiwa, ri ka kiis an wol le, ");
INSERT INTO bjp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Isi sani kaltu igii ka orek arae? I puris God ini orek kia! Biil tikas ifasi in pa ufu sinang laulau, biil. God keskes sau.” ");
INSERT INTO bjp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Fanpil, Iesu, na tanwa ka usum ta na wolwol kiri ke ka tara sing ri aragii, “Isi sani ka mel e matngan wolwol arae na balmi? ");
INSERT INTO bjp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Orek sa i malmuh? Ian tara sing peo igii le, ‘Ia ka pa ufu ta foron sinang laulau kiam’ le ian tarah, ‘Aptih, kep mii salam ma ok la’? ");
INSERT INTO bjp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ian use u aragii isi gamek usum le Kalalik ken Kaltu imel e rakrakai kia aga na piklinbat una pa ufu foron sinang laulau.” Ke ka tara sing peo ae aragii, ");
INSERT INTO bjp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ia fas o, aptih, kep mii salam ma ok la una fel kiam.” ");
INSERT INTO bjp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kaltu ae ka aptih, ka kep mii sala ke ka suu na matri. Fanu tikii aiwa, ri ka lala bitit ke ri ka sik asa God ma ri ka tarah, “Biil bii kere par ti matngan tier aragii!” ");
INSERT INTO bjp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu ka fis sabin una baban dan kawil na Galili. Ke nenge tara gur na fanu ri ka la usuf i ma ka tipes fausum ri. ");
INSERT INTO bjp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aunbiing i toltole sal la, ka par Liwai kalalik ke Alfius i kiis ta na felun kep takiis. Ke ka tara sing i aragii, “Mi lo iau.” Liwai ka aptih ke ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aunbiing Iesu i ien na efef na fel ke Liwai, ifuun e foron tom kep takiis ke foron tom tel sinang laulau ri ien tura Iesu ke berberat na fafausum kia, wara le fanu fuun ri mi lo. ");
INSERT INTO bjp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aunbiing foron tom fafausum ini nagogon, ae ri foron Farasi, ri par Iesu i ienien la turan foron tom kep takiis ke foron tom tel sinang laulau, ri ka diik berberat na fafausum kia aragii, “Isi sani Iesu ka ien turan foron tom kep takiis ke foron tom tel sinang laulau?” ");
INSERT INTO bjp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu ka ongen u ke ka tara sing ri aragii, “Fanu ae biil ri sasem, biil ri la la usuf dokta, biil. Fanu sau ae ri sasem, ri la la usuf dokta. Biil ia la uga isi tawi foron tom tortores, biil. Ia la isi tawi foron tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nenge aunbiing berberat na fafausum ke Jon Tom tel Bapitaiso turan foron Farasi ri fafel. Fale fanu ri ka la ke ri ka diik Iesu aragii, “Isi sani ke berberat na fafausum ke Jon turan berberat na fafausum ken foron Farasi ri ka fafel, ma berberat na fafausum kiam biil?” ");
INSERT INTO bjp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ke Iesu ka kiliis ri aragii, “Aunbiing kaltu ae i fakekel fuuh i kiis biitom turan foron tala, arafah, ifasi rin fafel? Biil. Wara le kaltu ae i fakekel fuuh i kiis biitom tura ri, ke biil ifasi rin fafel. ");
INSERT INTO bjp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Isau le aunbiing rin kep ufu kaltu ae i fakekel fuuh koseng ri, ke na biing mang ae rik fafel. ");
INSERT INTO bjp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Biil tikas i mapmap la ini dangan kaen fuuh na olon kaen tofe, biil. Male in tel u arae, ke dangan kaen fuuh ae in paradadat ke ik tamsih tina kaen tofe ma in tel tamrabat ae ik laumet. ");
INSERT INTO bjp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ke biil tikas i to wain fuuh la una pungun dan ae ri tel u ini punun meme tofe, biil. Male in tel u arae, ke wain fuuh ae in rabat punun meme, ke wain fuuh in bereng ke punun meme ae ik laulau. Isau le ri to wain fuuh la tom una palgan punun meme fuuh.” ");
INSERT INTO bjp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na nenge Biingen Mangeh, Iesu i soleng foron mok na wit, ke berberat na fafausum kia ae ri la tura, ri ka lus fale kutun wit, ");
INSERT INTO bjp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ke foron Farasi ri ka tara sing i aragii, “Par u, isi sani ri ka tel matngan sinang ae nagogon i use u le, gong kere tel u na Biingen Mangeh?” ");
INSERT INTO bjp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ke Iesu ka kiliis ri aragii, “Biil biitom gam wes ususe na sani Dewit i tel ta u, aunbiing i turan fanu ae ri batme u ri fitol ma biil ti inen ari? ");
INSERT INTO bjp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Na aunbiing Abiatar i famfamu ken foron pris, Dewit i kau una fel ke God ke ka ien foron beret ae ri ka ta ta u arae fafen usuf God, ma ka fen fanu sabin ae ri batme u ini fal. Na nagogon, foron pris sau ifasi rin ien u.” ");
INSERT INTO bjp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ke Iesu ka fas ri sabin aragii, “God i fakiis Biingen Mangeh una lupes fanu, biil i fakiis fanu una lupes Biingen Mangeh, biil. ");
INSERT INTO bjp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pesu, Kalalik ken Kaltu i e Kumguui sabin na Biingen Mangeh.” ");
INSERT INTO bjp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nenge aunbiing sabin, Iesu ka kau una felun lotu, ma nenge kaltu aiwa i met e nenge lima. ");
INSERT INTO bjp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Fale fanu aiwa, ri famam im sal una tiu Iesu. Pesu, ri ka lala luun matri lo isi rik par u le in faliu kaltu ae na Biingen Mangeh, le biil. ");
INSERT INTO bjp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ke Iesu ka tara sing kaltu ae i met e lima aragii, “Soti aga na famu.” ");
INSERT INTO bjp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ke ka diik fanu ae aragii, “Sani nagogon kirer i mangte u le keren tel u na Biingen Mangeh? Keren tel rokap na sinang le keren tel sinang laulau? Keren fafaliu le keren sisiimete?” Isau le biil ri use ti tier. ");
INSERT INTO bjp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu i parpar ri la ke ka kut e bala. I par balri i arae fat, ka mais ri ke ka tara sing kaltu ae aragii, “Sawe limam.” Kaltu ae ka sawe lima ke ka rokap fis. ");
INSERT INTO bjp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ke foron Farasi ri ka suu tina felun lotu. Ri ka kiis turim turan foron tala Erot ma ri ka tipes puput isi siimete Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu turan berberat na fafausum kia ri ka kang koseng falifu ae ke ri ka la una baban dan kawil na Galili, ma tara gur na fanu tina Galili ri ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aunbiing ri ongen sani ae Iesu i tel u, fanu fuun ri ka la usuf i tina foron falifu na Iudaia, Ierusalem, Idumea, tina nenge bulin dan na Ioridan ke tina foron falifu kawil Tair ke Saidon. ");
INSERT INTO bjp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","I wara na tara gur na fanu aiwa, ke Iesu ka fas berberat na fafausum kia le rin geges ini ti mon usuf i, isi fanu gong ri sit u. ");
INSERT INTO bjp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesu ka faliu ta fanu fuun, pesu fanu ae ri sasem ri ka famam sipsip solsol isi rin sigil u. ");
INSERT INTO bjp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma na aunbiing fanu ae imel e tanwa laulau lo ri, ri par pes Iesu la, ri ilepul la na mata ke ri ka ngangeh la aragii, “O Kalalik ke God!” ");
INSERT INTO bjp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Isau le, Iesu i fakiing foron tanwa laulau la le, gong ri use u le i e seh. ");
INSERT INTO bjp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu ka tatkau na nenge pungpung ke ka tawi pes fanu ae i ier isi ri, ma ri ka la usuf i. ");
INSERT INTO bjp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ke ka tim pes sangful ini u e kalalik na fafausum ae ka foteng ri ini foron aposel. I tim pes ri, isi rin kiis tura ma ik wuun ri isi fafas ini orek ke God, ");
INSERT INTO bjp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma ik mel e rakrakai kiri una tel ufu foron tanwa laulau. ");
INSERT INTO bjp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Igii e asan sangful ini u e aposel ae Iesu i tim pes ta ri: Saimon ae Iesu ka foteng u ini Pita, ");
INSERT INTO bjp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tura Jems ru latualik e Jon ru un kalalik ke Sebedi, ae Iesu i ta asruh ini Boanerges, kamtinan orek ae le, iun kalalik tina pah. ");
INSERT INTO bjp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ke Enru, Filip, Batolomiu, Metiu, Tomas, Jems kalalik ke Alfius, Tadius, Saimon nenge Silot ");
INSERT INTO bjp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ke Iudas Iskariot ae in ta ufu Iesu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Namih, Iesu ka fis una fel, ke nenge gur na fanu ri ka tapiek turim sabin, pesu i turan berberat na fafausum kia biil ifasi rin ien. ");
INSERT INTO bjp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aunbiing fanu lo, ri ka ongen u arae, ri ka ier isi rin lame pes u ke ri ka tarah, “Ka talos tah.” ");
INSERT INTO bjp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ke fale tom fafausum ini nagogon ae ri la ta tina Ierusalem ri ka tara aragii, “Belsebul, laulaumet ken foron tanwa laulau i susuef lo ma ka ta rakrakai sing i una tel ufu foron tanwa laulau.” ");
INSERT INTO bjp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iesu ka tawi pes ri ke ka fas ri ini fale orek fatoftof aragii, “Arafa Satan in tel ufu Satan arae? ");
INSERT INTO bjp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Male nenge matanfuntih in fapaket fis tom ini, ke matanfuntih ae arafa in rakrakai arae? ");
INSERT INTO bjp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Male fanu tina nenge matanfel ri fapaket fis tom ini ri, ke fanu tina matanfel ae biil mang rin kiis turim. ");
INSERT INTO bjp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ke male Satan in fapaket fis tom ini, ke fanu kia rin tampaek ma matanfuntih kia biil ifasi in ti dolo, biil. In rop sau. ");
INSERT INTO bjp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Biil tikas ifasi in kau na fel ken nenge rakrakai na kaltu isi ik sukuum foron minmara, male biil i kabet famu kaltu ae. In kabet famu u, ke nami ik suksukuum na fel kia. ");
INSERT INTO bjp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tekentu kanaka ia fas gam, God ifasi in pa ufu foron sinang laulau tikii ke foron orek laulau tikii ae fanu ri tel u la. ");
INSERT INTO bjp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Isau le se i orek laulau ulon Tanwa Kalkaluu, God biil in to pa ufu sinang laulau kia, biil. Sinang laulau kia in kiis fitliu.” ");
INSERT INTO bjp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu i use u arae, wara le ri tara le, “Imel e tanwa laulau lo.” ");
INSERT INTO bjp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Namih, tina Iesu turan foron tualik ri ka tapiek. Ri ka soti awii na maleh ke ri ka fawuun isi Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tara gur na fanu ri kawil ta Iesu ke ri ka fas u aragii, “Ongen u, tinam turan foron tuamlik ae na maleh, ma ri ier isi par o.” ");
INSERT INTO bjp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ke Iesu ka diik aragii, “Se e tinang ke fanse e foron tuaklik?” ");
INSERT INTO bjp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka par fanu ae ri kiis kawil ta u ke ka tarah, “Ongen u, igii e tinang ke foron tuaklik! ");
INSERT INTO bjp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Se sau i mi na wolwol ke God, i e tuaklik ke feneklik ke tinang.” ");
INSERT INTO bjp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu ka tipes tel fafausum sabin na baban dan kawil. Gur na fanu ae ri kawil ta u, ri fuun kanaka, pesu ka wof na nenge mon ke ka kiis lo na dan ma fanu tikii tinawii na mas. ");
INSERT INTO bjp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ke ka fausum ri ini ifuun e tier ini orek fatoftof. Na fafausum kia, ka tarah, ");
INSERT INTO bjp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ongen u! Nenge tom soso i la isi saprai kutun wit. ");
INSERT INTO bjp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aunbiing i sapsaprai, fal ka luut tole sal ke foron man ri ka wofpiek ma ri ka ting tikii u. ");
INSERT INTO bjp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fal ka luut na olon fatfat, ae biil i laumet e nanal lo. Ka rarau sape, wara le nanal biil i laumet. ");
INSERT INTO bjp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Isau le aunbiing pisiih i popos, ka pose ri ke ri ka mang, wara le bauli ri biil i laumet. ");
INSERT INTO bjp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fale kutun wit ka luut na palgan foron finau ae imel e si. Aunbiing finau i kuum, ka kuruung foron wit ae ke biil ri fua. ");
INSERT INTO bjp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Isau le fale kutun wit ka luut na nanal rokap. Ka kuum ke ka fua. Fal ituul e sangful e fua, fal iwon e sangful ke fal ifasi aragii nenge mar e fua.” ");
INSERT INTO bjp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ke Iesu ka tarah, “Se imel e balbalu, i rokap le in wong ini.” ");
INSERT INTO bjp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Namih, aunbiing Iesu keskes mang tinaiwa, ke sangful ini u e kalalik na fafausum kia turan fale fanu, ri ka diik u isi foron orek fatoftof ae. ");
INSERT INTO bjp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ke ka tara sing ri aragii, “God ka finngas ta gam ini foron tier ae i kum na matanfuntih kia. Isau le usuf fanu keskes, ia fausum ri ini foron orek fatoftof sau, ");
INSERT INTO bjp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","isi, ‘rin par ma rik par, isau le biil tom rin par failiim ti tier, ke rin ongne ma rik ongne, isau le biil tom rin malal, tarama ri ka fis, ma God ka pa ufu foron sinang laulau kiri!’” ");
INSERT INTO bjp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ke Iesu ka tara sing ri aragii, “Arafah, biil gam malal na orek fatoftof igii? Ke arafa gamen malal arae na ti fale orek fatoftof sabin? ");
INSERT INTO bjp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kutun wit ae kaltu i saprai u, i e orek ke God. ");
INSERT INTO bjp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Foron kutun wit ae i luut tole sal, ri arae fanu ae ri ongen orek. Isau le na aunbiing tom ae ri ongen u, Satan ka tapiek ke ka tel ufu orek ae tina balri. ");
INSERT INTO bjp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fal, ri arae kutun wit ae ri luut na olon fatfat, ri ongen orek ke fanpil ri ka somangat pes u ini laes. ");
INSERT INTO bjp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Isau le biil ri ti dolo, arae wit ae bauli biil i laumet. Ri luut sape sau, aunbiing ri tafe tatawin ke aunbiing fanu ri ta fangungut sing ri, wara na orek ke God. ");
INSERT INTO bjp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ke fale fanu, ri arae kutun wit ae ri luut na palgan foron finau ae imel e si. Ri ongen orek, ");
INSERT INTO bjp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","isau le ri mamais kanaka isi foron tier tinaga na piklinbat, ma sinangun ier isi in fuun e minsik i fabal ri, ke sinangun ier isi fale tier sabin ka aung orek ke God, arae finau i rarau kale wit, ke biil ri fua. ");
INSERT INTO bjp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma fal, ri arae kutun wit ae ri luut na rokap na nanal, ri ongen orek ke ri ka somangat pes u. Ri arae wit ae i luun ituul e sangful, le iwon e sangful ke fal ifasi aragii nenge mar e fua.” ");
INSERT INTO bjp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ke Iesu ka tara sing ri aragii, “Arafah, gam kep fakau lam la ke gam ka luun u la na piklin paket le na piklin luuf? Auuh, biil. Gam luun u la tom na sala. ");
INSERT INTO bjp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Isi foron sani ae i kiis mumun ta ik tapiek na malal, ke sani ae i kiis kum ta ik malmalal. ");
INSERT INTO bjp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Se imel e balbalu, i rokap le in wong ini.” ");
INSERT INTO bjp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu ka fas ri sabin aragii, “Gamen wol papte sani ae gam ka ongen ta u. Matngan fafen arafa gam ta ta u, tara tier le fabiro, God in ta u sabin arae usuf gam, ma in ta in fuun biitom usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Se ae ka mel ta sing i, rin ta tifal biitom sing i. Isau le se ae biil ti tier sing i, ituul ae sing i, rin tel ufu koseng u.” ");
INSERT INTO bjp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ke Iesu ka use u sabin aragii, “Matanfuntih ke God ifasi arae nenge kaltu ae i saprai kutun wit na olon nanal. ");
INSERT INTO bjp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na wor i borong la ma na siat ka mat la, foron kutun wit ae ka rarau ke ri ka kuum, isau le kaltu ae biil i to usum le ri kuum arafah. ");
INSERT INTO bjp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nanal tom i tel kutun wit ka kuum ke nami ka fua. I luun famu kubu, nami ka sia ke ka luun fua. ");
INSERT INTO bjp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aunbiing wit ka matuk, ke kaltu ae ka pakat turim u, wara le ka aunbiing mang una lalamok.” ");
INSERT INTO bjp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu ka tara sabin aragii, “Sani keren fatof matanfuntih ke God ini, kol matngan orek fatoftof arafa keren tel u? ");
INSERT INTO bjp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ifasi arae kutun mastet ae i fabiro na foron kutun au tikii ae ri so u na nanal. ");
INSERT INTO bjp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Isau le aunbiing ri ka so ta u, ka kuum ma ka liu ufu foron au tikii na palgan mok. Ma foron man na mua ri ka tel polpolo ri na piran aka ae imel e malmaluu lo.” ");
INSERT INTO bjp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu i use ifuun e orek fatoftof ae i fafasi usuf ri, namin tasum kiri. ");
INSERT INTO bjp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Foron tier tikii ae i fas ri ini, i use u ini orek fatoftof sau. Isau le aunbiing i keskes mang turan berberat na fafausum kia, ke ik fas ri mang ini kamtinan foron orek fatoftof tikii. ");
INSERT INTO bjp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na efef tom lo e biing ae, Iesu ka fas berberat na fafausum kia aragii, “Kere mang una nenge bulin dan kawil.” ");
INSERT INTO bjp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ke ri ka la koseng tara gur na fanu aiwa ma ri ka wof na mon ae Iesu tinaiwa mang lo, ke ri tikii ri ka la. Fale mon sabin ri ka la turim tura ri. ");
INSERT INTO bjp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nenge tara kif ka aptih ke panaf ka tamket una palgan mon ma fatat ik dom. ");
INSERT INTO bjp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu tinawii na min mon, i koskosngoi ta na nenge koskosngoi ma ka masun. Berberat na fafausum ri ka famat u, ma ri ka tarah, “Tom fafausum! Arafah, biil o wol lo kerer? Fatat kerek dom!” ");
INSERT INTO bjp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu ka aptih, ka fakiing kif ma ka fas panaf aragii, “Mangeh! Ma ok siaroh!” Ke ka met e kif ma ka siaroh. ");
INSERT INTO bjp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ke Iesu ka tara sing berberat na fafausum kia aragii, “Isi sani gam ka lala sokeh? Arafah, biil biitom ti unune kimi?” ");
INSERT INTO bjp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ri ka lala sokeh ma ri ka fadiik faliu ini ri tom aragii, “Kaltu sa igii? Kif turan panaf ru wong sing i!” ");
INSERT INTO bjp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Namih, ri ka masa na nenge bulin dan kawil na nanal ken fan Gerasa. ");
INSERT INTO bjp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aunbiing Iesu ka wof pu tina mon, nenge kaltu ae tanwa laulau i susuef lo, ka suu tina foron matanfat una luun minet ma ka tafe u. ");
INSERT INTO bjp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kaltu ae i borong la na foron matanfat ae ma biil mang ifasi tikas in kabet u, taftawa le ini sen. ");
INSERT INTO bjp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wara le ri kabet iun lima la ke iun keke la ini sen, isau le in tiifamut sen tom tina iun lima ke ik bayi aen tina iun keke. Biil tikas ifasi in famo u. ");
INSERT INTO bjp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na foron wor ke na foron siat, i kiis la na foron matanfat ae, ke na foron pungpung. I ngangeh la ma ka kiitkiit fafis pununfo la tom ini fat. ");
INSERT INTO bjp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Aunbiing i par pes Iesu tina tapak, ka filau isi ke ka ilepul na mata. ");
INSERT INTO bjp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ke ka lala perek aragii, “Iesu, Kalalik ke God Buuii kanaka na mawe! Sani on tel u ini iau? Falimlim ini asa God le biil on to ta fangungut sing iau!” ");
INSERT INTO bjp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ka use u arae, wara le Iesu ka fas ta u aragii, “Tanwa laulau, suu koseng kaltu igii!” ");
INSERT INTO bjp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ke Iesu ka diik u aragii, “Se asam?” Ka kiliis u aragii, “Asang e Legion, wara le keme fuun.” ");
INSERT INTO bjp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ka piispiis Iesu le gong i wuun ufu ri koseng falifu ae. ");
INSERT INTO bjp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nenge tara uh na boh ri suupsuup la na baban nenge pungpung fatat. ");
INSERT INTO bjp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ke foron tanwa laulau ae ri ka sising Iesu aragii, “Wuun ufu kemem una foron boh ae isi kemek susuef ulo ri.” ");
INSERT INTO bjp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ke Iesu ka somangat ufu ri. Foron tanwa laulau ri ka la koseng kaltu ae, ke ri ka susuef ulon foron boh. Foron boh ae ri ka fasasai puh na nenge bolonfam una dan kawil ke ri ka kong. Wewes tikii na foron boh ae, ifasi aragii iwu e arip. ");
INSERT INTO bjp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Foron tom fofonoi na boh ri par sani ae i tapiek tah, ke ri ka fin ma ri ka use u na tara maleh, ke na birbiron maleh. Ma fanu tikii ri ka la ma ri ka par sani ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Aunbiing ri ka tapiek sing Iesu, ri ka par kaltu ae foron tanwa laulau ri susuef ta ulo ka kiis ta mang ini kaen na pununfo ma wolwol kia ka malal tikii tah ke ri tikii ri ka sokeh. ");
INSERT INTO bjp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Fanse ae ri par ta u, ri ka fas fanu ini tier ae i tapiek ta lon kaltu ae tanwa laulau i susuef ta ulo. Ke ri ka fas ri sabin ini foron boh. ");
INSERT INTO bjp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ri ka ongen u arae, ke ri ka sising Iesu isi in la koseng falifu kiri. ");
INSERT INTO bjp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aunbiing Iesu ka ier isi wof na mon, kaltu ae Iesu i tel ufu ta tanwa laulau lo, ka piispiis u le in la tura. ");
INSERT INTO bjp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu biil i to somangat pes u, isau le ka fas u aragii, “Fis una fel kiam, ma ok fas fanu lo wo ini foron tier laumet ae Kumguui i tel ta u lo wo, ma ini famais kia unaisam.” ");
INSERT INTO bjp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ke kaltu ae ka la ma ka tipes fafas na Dekapolis ini sani ae Iesu i tel ta u lo. Ma fanu tikii ri ka bitit. ");
INSERT INTO bjp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu ka sopaket dan kawil sabin ini mon una nenge baba. Aunbiing i tinaiwa biitom na baban dan, nenge tara gur na fanu ri ka kawil u. ");
INSERT INTO bjp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ke nenge famfamu tina felun lotu, asa e Jairus ka la, ka par Iesu ma ka ilepul na mata. ");
INSERT INTO bjp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma ka piispiis u aragii, “Fabiro keleflik kiak fatat in met. Kiskam, la ma ok luun limam lo isi ik liu.” ");
INSERT INTO bjp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ke Iesu ka la tura. Nenge tara gur na fanu ri ka mi lo ke ri ka fasisit kale u. ");
INSERT INTO bjp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nenge fifin aiwa i sem dah ifasi aragii sangful ini u e bet. ");
INSERT INTO bjp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Fifin ae ka kalsakai ta piran fangungut na liman ifuun e dokta, ma ka farop tikii ta pitkalang kia, isi in liu, isau le sasem kia ka laulaumet la bin. ");
INSERT INTO bjp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ka ongen ta ususe lo Iesu, pesu ka sipsip solsol na fatpoton gur ae tina mi Iesu ma ka sigil dolon kaen kia. ");
INSERT INTO bjp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wara le i wol aragii, “Male ian sigil dolon kaen kia sau, ke ian liu.” ");
INSERT INTO bjp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ka sigil dolon kaen ke Iesu, ma na aunbiing tom ae, dah ka mas ke ka usum le sasem kia ka rop. ");
INSERT INTO bjp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Fanpil, Iesu ka usum mang le, fale rakrakai tina pununfo ka mangmangal koseng u. Ka giliim fis na fatpoton gur ae, ma ka diik aragii, “Se i sigil kaen kiak?” ");
INSERT INTO bjp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ke berberat na fafausum kia ri ka kiliis u aragii, “O par tara gur na fanu ri kawil o. Arafa o ka diik le, ‘Se i sigil iau?’” ");
INSERT INTO bjp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Isau le Iesu ka gilgiliim la biitom isi se i sigil ta u. ");
INSERT INTO bjp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fifin ae i usum na sani i tapiek ta lo, ka sokeh ma ka nananar, ke ka ilepul na mata Iesu, ma ka fas u ini foron tier tikii. ");
INSERT INTO bjp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ke Iesu ka tara sing i aragii, “Keng keleflik, unune kiam tom ka faliu ta wo. La ini siaroh, sasem kiam ka rop tah.” ");
INSERT INTO bjp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aunbiing Iesu i ororek la biitom, fale fanu ri ka la tina fel ke Jairus, famfamu tina felun lotu, ke ri ka tarah, “Kem keleflik ka met tah. Gong mang o fatel Tom Fafausum.” ");
INSERT INTO bjp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Isau le Iesu biil i wong sing ri, ka fas Jairus aragii, “Gong o sokeh. On unune sau.” ");
INSERT INTO bjp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Biil i somangat isi tikas in mi lo, Pita sau ke Jems ru latualik e Jon rituul mi lo. ");
INSERT INTO bjp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aunbiing ri ka tapiek na fel ke Jairus, Iesu ka par maleh i rigorigo, ma ka ongen fanu ri famam luluen. ");
INSERT INTO bjp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ka kau ke ka tara sing ri aragii, “Isi sani maleh ka rigorigo ma fanu ri ka luluen? Keleflik ae biil i to met, i masun sau.” ");
INSERT INTO bjp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Isau le ri ka yongne u. Ka fasuu fanu tikii, ke ka tel pes taman keleflik ae ru e tina turan berberat na fafausum sau ae ri mi ta lo. Ri ka kau tura una falifu keleflik ae i borong lo. ");
INSERT INTO bjp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ka pose na lima ke ka tara sing i aragii, “Talita koum!” Kamtinan orek ae i aragii, “Lik, ia fas o, aptih!” ");
INSERT INTO bjp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Fanpil keleflik ae ka sotih ke ka la. Ma fanu ae ri par ta sani i tapiek, ri ka lala bitit. Keleflik ae, i sangful ini u e bet kia. ");
INSERT INTO bjp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ke Iesu ka fakiing ri le gong ri fas tikas ini sani ae i tapiek tah, ke ka fas ri sabin isi rin fen keleflik ae. ");
INSERT INTO bjp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu turan berberat na fafausum kia ri ka la tinaiwa, ma ri ka tapiek na Nasaret na maleh tutus kia. ");
INSERT INTO bjp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma na Biingen Mangeh, ka tipes fausum fanu na felun lotu ma fanu fuun ae ri ongen u ri ka lala bitit ke ri ka tarah, “Kaltu igii i kep u tinga e foron tier igii? Matngan tasum arafa ri ta ta u sing i, pesu ka fasi in fatapiek foron tier an fabitit igii? ");
INSERT INTO bjp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I nenge tom tel fel sau. Ma i kalalik ke Maria, foron tualik e Jems, Josep, Iudas ke Saimon. Ma foron fenelik igii sau naisrer.” Pesu ka laulau e balri ini. ");
INSERT INTO bjp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu ka fas ri aragii, “Nenge profet ri bulat la lo na fale maleh keskes, isau le fanu na maleh tutus kia, foron sikinting lo turan fanu sabin na matanfel kia, biil ri bulat la lo.” ");
INSERT INTO bjp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iesu biil mang ifasi in fatapiek ti foron tier an fabitit aiwa, isau le ka luun lima sau na olon fale fanu ae ri sasem ma ka faliu ri. ");
INSERT INTO bjp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma ka bitit le biil ti unune kiri. Namih, Iesu ka la una foron maleh temtem tikii ke ka famam fausum fanu. ");
INSERT INTO bjp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka kam pes sangful ini u e kalalik na fafausum kia, ka ta rakrakai usuf ri una tel ufu foron tanwa laulau, ma ka wuun ri tem u tem u. ");
INSERT INTO bjp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma ka fas ri aragii, “Gong gam kep ti tier na ninla kimi, gamen kep ti buk sau una la. Gong gam kep ti inen, gong gam kep ti sara ke gong gam pus kale ti pitkalang na kaen kimi. ");
INSERT INTO bjp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gamen la sau ini foron su na kekmi, isau le gong gam kep ti kilkiliis kimi.” ");
INSERT INTO bjp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iesu ka fas ri sabin aragii, “Aunbiing gam kau na ti fel, gamen kiis tom aiwa papang na aunbiing gamen kang koseng maleh ae. ");
INSERT INTO bjp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Male fanu tina nenge maleh biil ri somangat pes gam ke biil ri ongen orek kimi, aunbiing gam la koseng maleh ae, gamen pakte ufu piyiif tina kekmi, isi ik arae fakileng usuf ri le ri kiis na piklin ngaliaf ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ke ri ka la ma ri ka fafas usuf fanu isi rin kiliis liu. ");
INSERT INTO bjp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ri tel ufu ifuun e tanwa laulau, ke ri ka saba wel lon fanu fuun ae ri sasem ma ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Erot ka ongen foron ususe lo Iesu, wara le fanu tikii ri ka usum ta lo Iesu. Fale fanu ri use u le, “I e Jon Tom tel Bapitaiso sau ae ka liu fis sabin, pesu ka mel e rakrakai kia una fatapiek foron tier an fabitit.” ");
INSERT INTO bjp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Fale fanu sabin ri ka use u le, “I e Elaija.” Ma fal sabin ri ka tara le, “I nenge profet arae foron profet tinpakanini.” ");
INSERT INTO bjp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Aunbiing Erot ka ongen foron orek arae lo Iesu, ka tarah, “Jon ae ia ka bus ufu ta paklu, ka liu fis sabin!” ");
INSERT INTO bjp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Pakanini Erot tom i wuun ta foron tom fapaket isi luse Jon. Ri ka kabet u ma ri ka fakau u na felun kamkabet, wara le Jon i tara sing i aragii, “Biil i tortores arae o ka telpes Erodias, antu tuamlik.” Jon i use u arae, wara le Erot ka tel pes antu Filip, tualik. ");
INSERT INTO bjp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodias i ememse Jon, pesu ka ier le rin siimete u, wara le i sir matruh kunan fakekel kiruh. Isau le Erot biil i somangat ini wolwol ke Erodias, ");
INSERT INTO bjp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","wara le Erot i usum le Jon i nenge tom tortores ma i nenge kalkaluu na kaltu, pesu ka mel e sokeh kia lo. Ke ka tikale ri le gong ri siimete u. Aunbiing Erot i ongen foron orek la ke Jon, biil tom i malal la ulo isau le i laes la tom le in ongen u. ");
INSERT INTO bjp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Isau le na biingen pang ke Erot, Erodias ka wolpes nenge sal una siimete Jon. Erot ka tel nenge tara inen ke ka sising foron famfamu na matanfuntih kia turan foron famfamu ken foron tom fapaket ke foron laulaumet ken fan Galili, isi rin ien tura. ");
INSERT INTO bjp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aunbiing ri ienien la, keleflik ke Erodias ka kau ma ka guui na matan foron ses tikii. Erot turan foron ses tikii ae ri ien turim, ri ka laes ini matngan guui kia. Pesu, king ka fas keleflik ae aragii, “Sani on sising iau isi, ke ian ta u usuf o.” ");
INSERT INTO bjp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ke ka falimlim usuf i aragii, “Matngan sani o sising isi, ian ta u usuf o, taftawa le i laumet kanaka ma ifasi ini nenge baban matanfuntih kiak, ian ta u.” ");
INSERT INTO bjp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Keleflik ae ka suuh ke ka diik tina aragii, “Sani ian sising u isi?” Ke tina ka kiliis u aragii, “On sising u isi paklu Jon Tom tel Bapitaiso.” ");
INSERT INTO bjp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fanpil, ka sangar fis usuf king ma ka fas u aragii, “Igii tom on ta paklu Jon Tom tel Bapitaiso usuf iau na ti pelet.” ");
INSERT INTO bjp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King ka lala purngis e bala, isau le wara na falimlim kia ke na foron ses ae ri ka ongen ta orek ae i use ta u, pesu biil ifasi in ongen ufu sising kia. ");
INSERT INTO bjp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Fanpil ka wuun ufu nenge tom fapaket ini rakrakai na orek isi in fis ini paklu Jon Tom tel Bapitaiso. Tom fapaket ae ka la una felun kamkabet ke ka bus ufu paklu Jon. ");
INSERT INTO bjp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ka kep fafis u na nenge pelet, ka ta u usuf keleflik ae, ke keleflik ae ka ta u usuf tina. ");
INSERT INTO bjp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aunbiing berberat na fafausum ke Jon ri ongen u, ri ka la, ri ka kep pununfo ma ri ka luun u na nenge matanfat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Foron aposel ri ka fis unaisa Iesu ke ri ka fas u ini foron tier tikii ae ri tel ta u ke ae ri fausum ta fanu ini. ");
INSERT INTO bjp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Fanu fuun ri famam fafakiliis unaisri, pesu Iesu turan berberat na fafausum kia biil ti aunbiing kiri una ien. Iesu ka fas berberat na fafausum aragii, “Gam sau turang, keren la una ti kiptin biil isi gamek mamlik mangeh.” ");
INSERT INTO bjp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ke ri keskes ri ka wof na nenge mon ma ri ka la una nenge sunbiil. ");
INSERT INTO bjp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Isau le fanu fuun ae ri par ta ri sawe, ri iliim Iesu turan berberat na fafausum kia. Ke ri ka filau tina foron maleh tikii ma ri ka tapiek famu na falifu ae rin masa lo. ");
INSERT INTO bjp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aunbiing ri ka masah, Iesu ka par tara gur na fanu ma ka mais ri, wara le ri arae foron sipsip ae biil ti tom fofonoi kiri. Ke ka tipes fausum ri ini ifuun e tier. ");
INSERT INTO bjp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ka efef mang, ke berberat na fafausum kia ri ka la usuf i ma ri ka fas u aragii, “Kiptin biil sau igii ma ka efef laulau tah. ");
INSERT INTO bjp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wuun ufu fanu mang una foron fel ke una foron maleh fatat, isi rik fiil inen ari.” ");
INSERT INTO bjp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Isau le ka kiliis ri aragii, “Gam fen ri ini ti inen.” Ke ri ka fas u aragii, “O ier le kemen la ma kemek fiil ti foron beret ari? In wu tom ngan e mar e dinaria in fasi una fiil beret ari!” ");
INSERT INTO bjp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ke Iesu ka diik ri aragii, “Ifis e beret ae sing gam? Gam la ma gamek par.” Aunbiing ri ka usum tah, ri ka fas Iesu aragii, “Ilim e beret ma ka u e kok.” ");
INSERT INTO bjp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ke Iesu ka fas berberat na fafausum kia le rin fakiis fanu na foron uh na olon fifih makmakrau aiwa. ");
INSERT INTO bjp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ke ri ka kiis na foron uh, fal nenge mar, ke fal ilim e sangful e fanu. ");
INSERT INTO bjp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ke Iesu ka kep ilim e beret turan iwu e kok ae, ka tar una kukulii ma ka fotrokap usuf God ke ka sibik foron beret ae. Nami ka ta u usuf berberat na fafausum kia isi rin tulus fanu ini. Ka tulus ri tikii sabin ini iun kok. ");
INSERT INTO bjp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ri tikii ri ien ke ri ka mas. ");
INSERT INTO bjp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Namih, berberat na fafausum ri ka siing fafuun nenge sangful ini u e kes ini foron tigan beret turan kok. ");
INSERT INTO bjp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wewes lon fanu tamat ae ri ien, ifasi aragii ilim e arip. ");
INSERT INTO bjp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fanpil Iesu ka wuun famu berberat na fafausum kia isi rin wof na mon una Betsaida ae na nenge bulin dan kawil. Ma ka kiis fis isi in wuun sarara fanu ae. ");
INSERT INTO bjp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Aunbiing ka wuun ufu ta ri, ka tatkau una nenge pungpung isi sising. ");
INSERT INTO bjp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ka efef worwor mang ma mon tinawii mang ta na fatpoton dan kawil, ma i keskes mang tinaiwa na mas. ");
INSERT INTO bjp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesu i par u le i ngangaten kanaka ulon berberat na fafausum kia isi rin awes, wara le kif i pipiis tina famu lo ri. Ma na piklin ien, ka la na olon dan kawil usuf ri ma fatat ik liu ufu ri. ");
INSERT INTO bjp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Isau le aunbiing ri ka par u i la na olon dan, ri ka wol le kinit. Ke ri ka ngangeh, ");
INSERT INTO bjp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","wara le ri tikii ri par u ma ri ka lala sokeh. Fanpil Iesu ka tara sing ri aragii, “In rorokiis e balmi! Iau sau igii. Gong gam sokeh.” ");
INSERT INTO bjp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ke ka wof na mon unaisri ma kif ka met. Ri ka lala bitit, ");
INSERT INTO bjp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","wara le biil ri malal rokap na fakileng ae Iesu i fatapiek ta u na beret ke na kok. Balri i sorokai. ");
INSERT INTO bjp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aunbiing ri ka sopaket ta dan kawil, ri ka famasa mon kiri na Genesaret. ");
INSERT INTO bjp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma aunbiing sau ri pu tina mon, fanu ri ka iliim Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ke ri ka filau una foron maleh tikii na falifu ae. Ma aunbiing ri ongen u le Iesu ae na nenge maleh fatat, ri ka kep foron sasem ini foron salri una maleh ae. ");
INSERT INTO bjp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na foron maleh, na foron nanal na fel ke na birbiron maleh ae Iesu i la ulo, fanu ri faborong foron sasem na foron salan la turim. Foron sasem ae ri ka sising Iesu sau isi rik sigil sun kaen kia, ma ri tikii ae ri sigil u, ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Foron Farasi turan fale tom fafausum ini nagogon ae ri pu tinbae na Ierusalem, ri ka la turim unaisa Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ke ri ka par fale berberat na fafausum ke Iesu ri ien sau ini duh, biil ri sofolim tah. ");
INSERT INTO bjp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Foron Farasi turan fan Iudaia tikii ri mi la tom na fafausum ken foron tubutamat ri, biil rin ien male biil ri sofolim. ");
INSERT INTO bjp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aunbiing ri fis la tina salan fifiil, rin sofolim tom ke nami rik ien. Ri mi la tom na ifuun e matngan fafausum kiri aragii: Rin gorse foron kap, foron sospen ke foron ketel. ");
INSERT INTO bjp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Foron Farasi turan foron tom fafausum ini nagogon ri ka diik Iesu aragii, “Isi sani ke berberat na fafausum kiam biil ri to mi na foron fafausum ken foron tubutamat kerer? Ri ien sau ini limri ae i duh.” ");
INSERT INTO bjp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu ka kiliis ri aragii, “Profet Aisaia i orek tekentu tom, aunbiing i orek famu ta ulo gam foron tom gargaranmet, arae tom i siit ta u aragii, ‘Fanu igii ri bulat lo iau sau ini ngusri, isau le balri i tapak koseng iau. ");
INSERT INTO bjp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ri lotu foes la sau unaisang, wara le ri fausum fanu la tom ini nagogon foes ken fanu.’ ");
INSERT INTO bjp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gam ka la koseng ta foron nagogon ke God ma gam ka mi mang namin foron fafausum sau ken fanu.” ");
INSERT INTO bjp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ke Iesu ka fas ri sabin aragii, “Gam usum rokap tom na sinangun ongen ufu nagogon ke God isi gamek kep papte fafausum kimi tom. ");
INSERT INTO bjp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses i use u aragii, ‘On bulat lo tamam ru e tinam,’ ke ka use u sabin aragii, ‘Male tikas i nes tama le tina, rin siimete u.’ ");
INSERT INTO bjp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Isau le gam use u la aragii, in rokap male tikas in tara sing tama le tina aragii, ‘Tier ae le ian ta u sing kamuh, ia ka kale ta u le ian ta u usuf God.’ ");
INSERT INTO bjp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ke gam ka tikale u isi biil mang in lupes tama le tina. ");
INSERT INTO bjp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Male gam tel u arae, ke gam fapu orek ke God ma gam ka mi sau na foron fafausum ae gam kep ta u sing foron tubutamat gam. Ma ifuun tom e tier aragii gam tel u la.” ");
INSERT INTO bjp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu ka kam gur na fanu sabin ae unaisa ke ka fas ri aragii, “Gam tikii, gamen ongen iau ma gamek malal na orek kiak. ");
INSERT INTO bjp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Biil ti tier ae nenge kaltu i kiim u, in fadu u na mata God, biil. Tier ae kaltu i fasuu u tina wolwol kia, in fadu u na mata God.” ");
INSERT INTO bjp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na aunbiing ka kang koseng gur na fanu ae ma ka kau na fel, berberat na fafausum kia ri ka diik u isi foron orek fatoftof ae i use ta u. ");
INSERT INTO bjp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ke Iesu ka tara sabin aragii, “Paklu gam i kutkut biitom? Arafah, biil gam usum le, tier ae kaltu i kiim u biil in fadu u na mata God? ");
INSERT INTO bjp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wara le biil i kau na wolwol kia, i kau sau una bala ke nami ka suu tina pununfo.” Aunbiing Iesu i use u arae, i famalal u le foron inen tikii i fuu na mata God. ");
INSERT INTO bjp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ka use u biitom aragii, “Sani sau ae i suu tina wolwol ken nenge kaltu, i fadu u la na mata God. ");
INSERT INTO bjp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wara le foron matngan sinang aragii i suu la tina wolwol ken nenge kaltu: Wolwol laulau, sinangun tamfaes, sinangun suksukuum, sinangun sisiimete ke sinangun puur, ");
INSERT INTO bjp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sinangun akalemok, sinangun falaulau fanu, sinangun famfabal, sinangun mi na wolwol laulau na pununfo, sinangun ram, sinangun orek laulau ulon fal, sinangun falaumet wo tom ke sinangun talos. ");
INSERT INTO bjp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Foron sinang laulau tikii igii, ri tapiek tina wolwol ken fanu ke ka fadu ri la na mata God.” ");
INSERT INTO bjp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ke Iesu ka apti tina maleh ae ma ka tapiek na falifu na Tair. Ka kau na nenge fel ma biil i ier le tikas in usum lo le i ae na palgan fel, isau le biil tom ifasi le in mumun. ");
INSERT INTO bjp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nenge fifin, keleflik kia tanwa laulau i susuef ulo. Aunbiing ka ongen u le Iesu ae na fel, fanpil ka la ma ka ilepul na mata. ");
INSERT INTO bjp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Fifin ae biil i fafnan Iudaia, i fafnan Fonisia tina nanal na Siria. Ka sising Iesu le in tel ufu tanwa laulau koseng keleflik kia. ");
INSERT INTO bjp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Isau le Iesu ka fas u aragii, “Tier famu, rin fen famas berberat ta bii. Biil i tortores le rin kep inen an berberat ma rik lin u an birbiron puul.” ");
INSERT INTO bjp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Fifin ae ka kiliis u aragii, “I tekentu, Kumguui, isau le birbiron puul sabin ae na piklin luuf una ien, ri ien foron peksen inen la an berberat.” ");
INSERT INTO bjp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ke Iesu ka fas fifin ae aragii, “Wara le o kiliis fakasi orek kiak, la mang, tanwa laulau ka suu ta koseng kem keleflik.” ");
INSERT INTO bjp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aunbiing fifin ae ka fis una fel kia, ka par ke keleflik i borong na sala ma tanwa laulau ka suu ta koseng u. ");
INSERT INTO bjp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu ka la tina Tair ke ka soleng maleh na Saidon ke ka tapiek na dan kawil na Galili, na baba na nanal na Dekapolis. ");
INSERT INTO bjp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma nenge kaltu tinaiwa i baut ke biil i orek rokap la. Fale fanu ri ka tangne u usuf Iesu ke ri ka sising Iesu le in luun lima na olo. ");
INSERT INTO bjp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu ka tangne u koseng gur na fanu ae ke ka fakau iun katngan lima na iun balbalu. Ka ubis ke ka sigil kermen kaltu ae. ");
INSERT INTO bjp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ke ka par una kukulii, ka mangeh ma ka tara sing i aragii, “Efata!” Kamtinan orek le, “Sapeng!” ");
INSERT INTO bjp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ke ka malal e balbalu, ka malalah e kerme ma fanpil ka orek rokap. ");
INSERT INTO bjp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu ka tikale fanu aiwa le gong ri fas tikas ini tier ae. Isau le aunbiing i tikale ri la, ri ka lala fasarara ususe mang tom lo, usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma ri ka lala bitit ke ri ka tarah, “Iesu i tel fakasi foron tier tikii. I tel foron baut ke ri ka wong ke foron tabilikut ri ka orek.” ");
INSERT INTO bjp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na foron biing tom ae, nenge tara gur na fanu ri ka la turim sabin. Ma aunbiing biil mang ti inen ari, Iesu ka kam pes berberat na fafausum kia unaisa ke ka fas ri aragii, ");
INSERT INTO bjp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ia mais kanaka fanu igii, wara le ri ka kiis pes ta ituul e biing naisang ma biil mang ti inen ari. ");
INSERT INTO bjp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Male ian wuun sarara ri una foron maleh temtem tikii kiri ini fitol, ke in taltal e matri tole sal, wara le fal, foron maleh kiri i tapak.” ");
INSERT INTO bjp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Berberat na fafausum kia ri ka tara sing i aragii, “Kiptin biil sau igii, fia keren kep ti beret wah, isi ik fasi una fen ri tikii?” ");
INSERT INTO bjp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ke Iesu ka diik ri aragii, “Ifis e beret ae sing gam?” Ri ka kiliis u le, “Ifit.” ");
INSERT INTO bjp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ke ka fas fanu ae isi rin kiis na nanal. Ka kep ifit e beret ae, ka fotrokap lo usuf God, ka sibik u ke ka ta u usuf berberat na fafausum kia isi rin tulus fanu ini. Ke berberat na fafausum kia ri ka tel u arae i use ta u. ");
INSERT INTO bjp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Imel e fale birbiro kok sabin tinaiwa. Ka fotrokap sabin usuf God isi ke ka fas berberat na fafausum kia isi rin tulus fanu ini. ");
INSERT INTO bjp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri ien ma ri ka mas. Ke berberat na fafausum kia ri ka siing fafuun ifit e kes ini foron tigan inen ae ri mas tiga. ");
INSERT INTO bjp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wewes lon fanu tamat tikii aiwa, ifasi aragii ifet e arip. Aunbiing ri ka ien tikii, ke Iesu ka wuun sarara ri. ");
INSERT INTO bjp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ka wof na mon turan berberat na fafausum kia ma ri ka la una falifu na Dalmanuta. ");
INSERT INTO bjp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Foron Farasi ri ka tapiek ke ri ka tipes fapue tura Iesu. Ri ier isi tof u, ke ri ka fas u isi in fatapiek ti fakileng tinbae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu ka mangeh ma ka tarah, “Sani e wara ae fanu na ulul igii ri ka ier isi rin par ti fakileng? Tekentu kanaka ia fas gam, biil tom ti fakileng in tapiek usuf gam.” ");
INSERT INTO bjp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ke ka la koseng ri, ka wof fis na mon ma ka sopaket dan kawil una nenge buli. ");
INSERT INTO bjp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Berberat na fafausum ri ruruu le rin kep ti fale beret, ri kep itikii tutus sau e beret tura ri na mon. ");
INSERT INTO bjp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ke Iesu ka fanau ri aragii, “Gamen tumarang! Gamen fofonoi lo gam koseng is ken foron Farasi ke is ke Erot.” ");
INSERT INTO bjp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ri ongen u arae ke ri ka ngurke orek ae na fatpoto ri tom, aragii, “I use u arae, wara le biil ti beret arer.” ");
INSERT INTO bjp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu ka usum ta na sani ri ngurke u, pesu ka diik ri aragii, “Isi sani gam ka use u le biil ti beret? Arafah, biil biitom gam iliim u ke biil biitom gam malal lo? Kol balmi i sorokai? ");
INSERT INTO bjp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imel e matmi, isau le biil ifasi gamen par ini. Ke imel e balbalu gam, isau le biil ifasi gamen wong ini. Gam wolpes u, ");
INSERT INTO bjp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","aunbiing ia sibik ta ilim e beret usuf ilim e arip e fanu. Ifis e kes gam fafuun u ini foron tigan beret ae fanu ri mas tiga?” Ri ka kiliis u le, “Sangful ini u.” ");
INSERT INTO bjp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ke ka diik ri sabin aragii, “Ke aunbiing ia sibik ta ifit e beret usuf ifet e arip e fanu, ifis e kes gam fafuun u ini foron tigan beret ae fanu ri mas tiga?” Ke ri ka kiliis u le, “Ifit.” ");
INSERT INTO bjp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ke ka diik ri aragii, “Arafah, biil biitom gam malal?” ");
INSERT INTO bjp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesu turan berberat na fafausum kia ri ka tapiek na Betsaida. Ke fale fanu ri ka tangne nenge kut usuf i ma ri ka sising u isi in sigil iun mata. ");
INSERT INTO bjp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka pose na liman kut ae ke ka tangne ufu tina maleh ae. Aunbiing ka ubis ta matan kaltu ae, ka luun iun lima na iun mata ke ka diik u aragii, “O ka par ti tier?” ");
INSERT INTO bjp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ke kaltu ae ka sake paklu, ke ka tarah, “Ia par fanu, ma ri par arae foron au ri la.” ");
INSERT INTO bjp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ke Iesu ka luun iun lima sabin na iun matan kut ae. Ke ru ka sapeng fis ke ka par fakasi foron tier tikii. ");
INSERT INTO bjp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu ka wuun ufu una fel kia ke ka fas u aragii, “Gong o soleng maleh ae.” ");
INSERT INTO bjp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ke Iesu turan berberat na fafausum kia ri ka la una foron maleh fatat isi Sisaria Filipai. Aunbiing ri toltole sal la, ka diik ri le, “Fanu ri tara le iau e seh?” ");
INSERT INTO bjp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ri ka kiliis u aragii, “Fal ri tara le wo Jon Tom tel Bapitaiso, fal ri tara le wo Elaija ke fal ri ka tara le wo neng lon foron profet.” ");
INSERT INTO bjp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ke ka diik ri sabin aragii, “Ma arafa lo gam, gam tara le iau e seh?” Pita ka kiliis u aragii, “O e Mesaia.” ");
INSERT INTO bjp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ke Iesu ka fakiing ri le gong ri fas tikas ini. ");
INSERT INTO bjp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Namih, Iesu ka tipes fausum berberat na fafausum kia aragii, “Kalalik ken Kaltu in kalsakai in fuun tom e tatawin. Ma foron famfamu, foron laulaumet na pris turan foron tom fafausum ini nagogon rin ta pokta ri ulo. Fanu rin siimete u, ma nami na in tuul e biing ik apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I famalal fakasi tom e orek kia, pesu Pita ka lame pes u una baba ke ka fakiing u le gong i orek arae. ");
INSERT INTO bjp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Iesu ka giliim ke ka par berberat na fafausum kia ke ka fakiing Pita aragii, “Satan! Fin koseng iau! Wara le biil o mi na wolwol ke God. O mi sau na wolwol ken fanu.” ");
INSERT INTO bjp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ke Iesu ka tawi turim gur na fanu ae turan berberat na fafausum kia unaisa ke ka fas ri aragii, “Male tikas i ier le in mi lo iau, in wol ufu tom ma ik kusep aupaket kia ke ik mi lo iau. ");
INSERT INTO bjp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wara le se i gong kale liu kia, in mangmangal koseng u, isau le se i sok ufu liu kia i wara lo iau ke Rokap na Fafas, in liu. ");
INSERT INTO bjp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Male tikas i kep tikii foron tier tina piklinbat, isau le ka falaulau liu kia, ke in farokap u arafah? ");
INSERT INTO bjp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ke in ta sani una fiil kiliis liu kia? ");
INSERT INTO bjp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Fanu na ulul igii, ri fanu laulau ma ri la koseng God arae nenge fifin i lin antu ma ka telpes nenge kaltu sabin. Male tikas na ulul igii i matlawen isi fapos iau ke foron orek kiak, Kalalik ken Kaltu sabin in matlawen lo, aunbiing in tapiek ini memeh ke Tama turan foron angelo kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ke ka fas ri aragii, “Tekentu kanaka ia fas gam, fal lo gam igii gam ti la, biil biitom rin met, ke rik par matanfuntih ke God in tapiek ini rakrakai.” ");
INSERT INTO bjp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iwon e biing namih, Iesu ka lame pes Pita, Jems ke Jon ma rifet ka tatkau keskes na nenge tara pungpung. Aiwa, rituul ka par pununfo ka sokiliis. ");
INSERT INTO bjp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma kilkiliis kia ka lala pos ma ka kilangkilang. Biil tikas tinaga na piklinbat ifasi in gorse ti kaen ma ik pos arae. ");
INSERT INTO bjp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tuul kalalik na fafausum ae, rituul ka par Elaija ru e Moses ru ka tipiek ma ru ka orek tura Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ke tuul kalalik na fafausum ae, rituul ka lala sokeh ma Pita biil mang i usum le sani in use u, pesu ka su tara sau sing Iesu aragii, “Tom fafausum, i rokap le kerer mang agawa. Kemtuulen tel in tuul e palpalbuang, neng kiam, neng ke Moses ke neng ke Elaija.” ");
INSERT INTO bjp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Namih, nenge laukaf ka tapiek ke ka afit ri. Ma kinen tikas ka orek tina laukaf aragii, “Igii e keng kalalik ae ia ier kanaka isi. Gamen wong sing i.” ");
INSERT INTO bjp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aunbiing rituul ka par sabin, fanpil biil mang rituul par tikas, Iesu keskes mang tinaiwa naisa rituul. ");
INSERT INTO bjp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Namih, aunbiing rifet pupu la tinbae na pungpung, Iesu ka fakiing rituul aragii, “Gong gamtuul fas tikas ini sani gamtuul par ta u, papang na aunbiing Kalalik ken Kaltu in apti fis tina minet.” ");
INSERT INTO bjp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rituul ka im isi kamtinan orek ae ke rituul ka fadiik fis ini rituul tom aragii, “Sani e kamtina e apti fis tina minet?” ");
INSERT INTO bjp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ke rituul ka diik Iesu aragii, “Isi sani foron tom fafausum ini nagogon ri ka use u le Elaija in tapiek famu lo Mesaia?” ");
INSERT INTO bjp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka kiliis rituul aragii, “Tekentu tom le, Elaija in tapiek famu ma ik fatortores fafis foron tier tikii. Isau le, isi sa ke ri ka siit ta u na Buk na Gogoh le Kalalik ken Kaltu in kalsakai in fuun e fangungut ma rik fakawe ufu? ");
INSERT INTO bjp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ia fas gamtuul, Elaija ka tapiek tah ma fanu ri ka tel ta sinang laulau ulo namin wolwol kiri, arae tom ri siit ta u na Buk na Gogoh ulo.” ");
INSERT INTO bjp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aunbiing Iesu turan tuul kalalik na fafausum kia rifet ka pu unaisan fale berberat na fafausum, rifet ka par tara gur na fanu turan foron tom fafausum ini nagogon ri kawil ta berberat na fafausum ma ri ka fafapue la tura ri. ");
INSERT INTO bjp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma aunbiing sau fanu ae ri par Iesu, ri ka lala bitit ke ri ka filau isi ma ri ka faorek pes u. ");
INSERT INTO bjp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ke Iesu ka diik berberat na fafausum kia aragii, “Gam fapue tura ri kunan sanih?” ");
INSERT INTO bjp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nenge kaltu tinawii na palgan gur na fanu ae ka kiliis u aragii, “Tom fafausum, ia lame keng kalalik igii usuf o, wara le tanwa laulau i susuef ulo ma biil ifasi in orek. ");
INSERT INTO bjp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aunbiing i fatalos u la, in faluut u na nanal, busbus ik suu tina ngusu ke ik faririt ngisa ma ik sorokai e fo. Ia sising ta berberat na fafausum kiam isi rin tel ufu tanwa laulau ae koseng u, isau le biil ri fasih.” ");
INSERT INTO bjp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu ka kiliis ri aragii, “Gam na ulul igii, gam foron tabun unune. Ia ka kiis dolo ta tura gam. Nangis mang gamek unune? Tangne kalalik ae usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ke ri ka lame u usuf i. Ma aunbiing tanwa laulau i par Iesu, fanpil ka faluut kalalik ae una nanal, ka gokgok ma busbus ka suu tina ngusu. ");
INSERT INTO bjp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu ka diik taman kalalik ae aragii, “Nangis i tanwara?” Ka kiliis u aragii, “I tanwara lo na aunbiing i fabiro kalalik biitom. ");
INSERT INTO bjp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ka fuun ta e aunbiing tanwa laulau i luu la ini una yiif ke una dan isi siimete u. Male ifasi on tel ufu tanwa laulau koseng u, ke mais kamah ma ok lupes kamah.” ");
INSERT INTO bjp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu ka fas taman kalalik ae aragii, “Isi sani o ka tara le male ia fasih? Se i unune ifasi in tel foron tier tikii.” ");
INSERT INTO bjp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Fanpil taman kalalik ae ka tarah, “Ia unune, isau le biil i to laumet. Lupes iau isi unune kiak ik laumet.” ");
INSERT INTO bjp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aunbiing Iesu ka par tara gur na fanu ri ka faruru kale ri, ka balkut ufu tanwa laulau ae aragii, “Tanwan baut ke tabilikut! Ia fas o, suu koseng kalalik igii ma gong sabin o susuef ulo.” ");
INSERT INTO bjp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tanwa laulau ae ka lala ngangeh ke ka gule faluut kalalik ae ma ka suu koseng u. Ke kalalik ae ka borong la mang ini sut lo aiwa, ma fanu fuun ri ka tara le, “Ka met.” ");
INSERT INTO bjp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Isau le Iesu ka pose na lima, ka fapti u, ke ka sotih. ");
INSERT INTO bjp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aunbiing Iesu turan berberat na fafausum kia ri ka kau una fel ke ri ka diik fakum u sau aragii, “Isi sani ke biil ifasi kemen tel ufu tanwa laulau koseng u?” ");
INSERT INTO bjp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu ka kiliis ri aragii, “Ini sising sau, ifasi rin tel ufu matngan tanwa laulau arae.” ");
INSERT INTO bjp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ri ka apti tinaiwa ma ri ka soleng falifu na Galili. Iesu biil i ier le tikas in usum na falifu ae ri la wah, ");
INSERT INTO bjp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wara le i famam fausum berberat na fafausum kia. Ke Iesu ka tarah, “Rin ta ufu Kalalik ken Kaltu una liman fanu. Rin siimete u, ma nami na ituul e biing ik apti fis.” ");
INSERT INTO bjp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Isau le biil ri to malal na kamtinan orek kia ke ri ka binbin sabin isi rin diik u. ");
INSERT INTO bjp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ri ka tapiek na Kapernaum. Ma aunbiing ri tinawii na palgan fel, Iesu ka diik ri aragii, “Sani gam fafapue la kuna tole sal?” ");
INSERT INTO bjp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Isau le biil ri kiliis u, wara le ri fapue ta tole sal le se i laumet lo ri tikii. ");
INSERT INTO bjp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu ka kiis ke ka kam sangful ini u e kalalik na fafausum kia ma ka tara sing ri aragii, “Male tikas i ier isi in famu, ke in kiis na kesting tutus ma ik tapiek tom foim ken fanu tikii.” ");
INSERT INTO bjp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka tangne pes nenge fabiro kalalik, ka fasoti u na fatpoto ri, ka diit pes u ke ka tarah, ");
INSERT INTO bjp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Male tikas i somangat pes ti fabiro kalalik arae neng igii na asang, i somangat pes iau sabin. Ke male tikas i somangat pes iau, biil i somangat pes iau sau, i somangat pes ier tom ae i wuun ufu ta iau.” ");
INSERT INTO bjp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ka tara sing Iesu aragii, “Tom fafausum, keme par nenge kaltu i tel ufu foron tanwa laulau ini asam ke keme ka tikale u, wara le biil i neng lo kerer.” ");
INSERT INTO bjp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ke Iesu ka tarah, “Gong gam tikale u. Biil ifasi tikas in fatapiek ti fakileng ini asang ke nami sau ik use ti tier laulau ulo iau. ");
INSERT INTO bjp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wara le se biil i tikale kerer, i neng lo kerer. ");
INSERT INTO bjp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tekentu kanaka ia fas gam, male tikas i faumin gam ini ti kap na dan, wara le gam ke Karisito, in kep fasuat kia tom. ");
INSERT INTO bjp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Male se i faluut tikas lon birbiron berberat igii ae ri unune lo iau na sinang laulau, in rokap ulo le rin kabet ta ti tara fat na kongkongo ma rik fadom ta u na palgantes. ");
INSERT INTO bjp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Male nenge limam i faluut o na sinang laulau, bus ufu. In rokap le on kep liu fitliu ini kumuk, tarama o ka sok ini iwu e limam turim na tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Male nenge kekem i faluut o na sinang laulau, bus ufu. In rokap le on kep liu fitliu ini kumuk, tarama ri ka lin o turan iun kekem turim una tara yiif. ");
INSERT INTO bjp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Male nenge kolson matam i faluut o na sinang laulau, au ufu. In rokap le on kau na matanfuntih ke God ini in tikii sau e kolson matam, tarama ri ka lin o ini iun kolson matam turim una tara yiif ae biil i met la. ");
INSERT INTO bjp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aiwa, ‘foron sisii ae rin sus pununfo ri, biil ri met la, ke yiif sabin ae biil i met la.’” ");
INSERT INTO bjp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Fan Iudaia ri fafuu foron fafen la usuf God ini tes, arae sau rin fafuu fanu tikii ini yiif. ");
INSERT INTO bjp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Tes i rokap, isau male in rop e musmus lo, ke arafa sabin gamen famusmus fafis u arae? Biil ifasi. Tes i farokap foron inen la, arae gam sabin gamen tapiek arae rokap na tes ae in fatapiek siaroh na fatpoto gam.” ");
INSERT INTO bjp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu ka apti tinaiwa una falifu na Iudaia ma ka sopaket dan na Ioridan. Ma gur na fanu ri ka la usuf i sabin, ke ka fausum ri arae tom i tel u la. ");
INSERT INTO bjp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fale Farasi ri ka la usuf i isi rin tof u ke ri ka diik u aragii, “I tortores tom na nagogon kirer le nenge kaltu in lin antu, le biil?” ");
INSERT INTO bjp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ke Iesu ka kiliis ri aragii, “Moses i ta ta Nagogon arafa usuf gam?” ");
INSERT INTO bjp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ri ka kiliis u aragii, “Moses i somangat le nenge kaltu in sisiit na nenge aun buk una puk fakekel isi ik lin antu.” ");
INSERT INTO bjp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu ka fas ri aragii, “Moses i siit ta nagogon ae usuf gam wara le balmi i sorokai kanaka. ");
INSERT INTO bjp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Isau le na tanwaran fakfakiis, ‘God i fakiis ta ruh, tamat ke fifin.’ ");
INSERT INTO bjp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘I e wara ae nenge kaltu in la koseng tama ru e tina, ma ik kiis turim tura antu, ");
INSERT INTO bjp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","isi ik tikii mang lo ruh.’ Ma biil mang in u lo ruh, biil. Run tapiek itikii sau. ");
INSERT INTO bjp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pesu, sani ae God ka faturim ta u, gong tikas i tempaek u.” ");
INSERT INTO bjp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ri ka fis sabin una fel ke berberat na fafausum ri ka diik Iesu sabin isi sani ae i use ta u. ");
INSERT INTO bjp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka kiliis ri aragii, “Male tikas i lin antu ma ka telpes ti fifin sabin, kaltu ae i tel sinangun puur usuf antu famu. ");
INSERT INTO bjp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ke, male ti fifin i lin antu ma ka telpes tikas sabin, fifin sabin ae i tel sinangun puur.” ");
INSERT INTO bjp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Fale fanu ri ka filange birbiron berberat usuf Iesu isi in luun lima na olri. Isau le berberat na fafausum kia ri ka fakiing ri. ");
INSERT INTO bjp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Aunbiing Iesu i par u arae, ka ngaliaf ke ka tara sing ri aragii, “Gam sok ufu birbiron berberat ae usuf iau. Gong gam tikale ri, wara le matanfuntih ke God, ken fanu ae ri arae berberat igii. ");
INSERT INTO bjp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tekentu kanaka ia fas gam, male tikas i ier isi in kau na matanfuntih ke God, isau le biil i arae fabiro kalalik, biil tom ifasi in kau.” ");
INSERT INTO bjp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ke ka diit pes berberat ae, ka luun iun lima na olri ke ka fakalok ri. ");
INSERT INTO bjp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Aunbiing Iesu ka tipes la sabin, nenge kaltu ka filau usuf i, ka ilepul na mata ma ka diik u aragii, “Rokap na Tom Fafausum, sani ian tel u isi iak kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ke Iesu ka kiliis u aragii, “Isi sani o ka foteng iau le ia rokap? Biil tikas i rokap, God keskes sau. ");
INSERT INTO bjp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O ka usum ta na foron nagogon: ‘Gong o siimete tikas, gong o tel sinangun puur, gong o suksukuum, gong o tiu foes tikas, gong o lem pes ti tier ken tikas, on bulat lo tamam ru e tinam.’” ");
INSERT INTO bjp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kaltu ae ka kiliis u aragii, “Tom Fafausum, tipes u na aunbiing ia kalalik tah, ka papang igii, ia misuut la tom na foron nagogon tikii igii.” ");
INSERT INTO bjp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu ka par una mata ma ka lala mais u ke ka tara sing i aragii, “Nenge tier biitom o pongpong isi. La ma ok sufii foron minmaram tikii, ma pitkalang lo, ok ta u usuf foron lauu. Male on tel u arae, ke kiam e minsik buuii na kukulii. Nami ok fis ke ok mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aunbiing i ongen orek ae, ka mingmingin e mata ma ka la ini mamais, wara le ifuun kanaka e minmara. ");
INSERT INTO bjp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu ka giliim usuf berberat na fafausum kia ke ka tarah, “I ngangaten kanaka isi fanu ae ifuun e minsik kiri, rin kau na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Berberat na fafausum kia ri ka lala bitit na orek ae. Isau le Iesu ka tara sabin sing ri aragii, “Berberat kiak, i ngangaten kanaka isi fanu rin kau una matanfuntih ke God. ");
INSERT INTO bjp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I ngangaten usuf kamel isi in kau na solsol na nil una somap, isau le i ngangaten kanaka tom usuf nenge kaltu ae ifuun e minsik kia isi in kau na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Berberat na fafausum ri ka lala bitit ma ri ka fadiik fis ini ri tom aragii, “Male i arae, ke se mang ifasi ik kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu ka par usuf ri ke ka tarah, “Usuf fanu, biil ifasi, isau le God i fasih. God ifasi in tel foron tier tikii.” ");
INSERT INTO bjp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita ka tara sing i aragii, “Par u, keme ka la koseng ta foron tier tikii kimem ke keme ka mi lo wo.” ");
INSERT INTO bjp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu ka tarah, “Tekentu kanaka ia fas o, se i la koseng fel kia, le koseng foron tualik le foron fenelik, le koseng tina ru e tama, le koseng berberat kia, le koseng nanal kia, iwara lo iau ke na Rokap na Fafas, ");
INSERT INTO bjp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na liu igii, in kep in fuun tom e tier. In kep nenge mar e fel, nenge mar e tualik, nenge mar e fenelik, nenge mar e tina, nenge mar e kalalik kia ke nenge mar e sun nanal kia, ma fanu rin ta fangungut sabin usuf i. Ke na liu ae namih in kep liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Isau le ifuun ae ri famu ta igii, nami rin mih, ma fanu ae ri mih igii, nami rin famu.” ");
INSERT INTO bjp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu i famfamu la ini berberat na fafausum kia aunbiing ri tatatkau la una Ierusalem. Ke berberat na fafausum kia ri ka lala wol, ma fanu sabin ae ri mi lo ri, ri ka sokeh. Iesu ka lame pes sangful ini u e kalalik na fafausum kia una baba ke ka fas ri sabin ini sani ae in tapiek lo. ");
INSERT INTO bjp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ka fas ri aragii, “Par u, igii kerek tatkau mang una Ierusalem, ke rik ta ufu Kalalik ken Kaltu mang una liman foron laulaumet na pris ke foron tom fafausum ini nagogon. Rin nagogon u isi ik met ke rik ta ufu usuf fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rin morot ini, rin ubis u, rin pis u ke rik siimete u. Isau le na fatuul u e biing, ik apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Namih, iun kalalik ke Sebedi, Jems ru e Jon, ru ka la usuf Iesu ke ru ka tarah, “Tom Fafausum, kama ier le on tel sani ae kaman sising u sing o.” ");
INSERT INTO bjp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ke ka diik ru aragii, “Sani kamu ier isi ian tel u kimuh?” ");
INSERT INTO bjp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ru ka tarah, “Aunbiing on kiis na memeh kiam, on fakiis kamah turam, neng na miam ke neng na kaisam.” ");
INSERT INTO bjp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesu ka kiliis ru aragii, “Biil kamu usum na sani ae kamu sising isi. Arafah, ifasi kamun yin na kap ae ia yin lo? Ke ifasi kamun kep bapitaiso ae rin baptais iau ini?” ");
INSERT INTO bjp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ru ka kiliis u aragii, “Kama fasih.” Iesu ka fas ru aragii, “Kamun yin na kap ae ia yin lo, ke kamuk kep bapitaiso ae rin baptais iau ini. ");
INSERT INTO bjp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Isau le isi kiis na miang le na kaisang, biil e tier kiak isi ian ta u, biil. God tom in ta u usuf fanse ae ka fageges ta u usuf ri.” ");
INSERT INTO bjp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma aunbiing sangful e kalalik na fafausum ri ka ongen u arae, ri ka ngaliaf ulo Jems ru e Jon. ");
INSERT INTO bjp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu ka kam turim ri ke ka tarah, “Gam usum le fanse ae ri foteng ri arae foron king ken fanu ae biil ri fan Iudaia, ri lala nagogon fanu la. Ma piran famfamu kiri sabin ri luun foron rakrakai na nagogon la na olon fanu. ");
INSERT INTO bjp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Isau le gong gam tara arae ri. Male tikas i ier le in laumet lo gam, ke in fasabiro pes u tom ma ik tapiek arae tom foim kimi. ");
INSERT INTO bjp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma se i ier le in famfamu kimi, ke in fafauun ken fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wara le Kalalik ken Kaltu sabin biil i tapiek isi fanu rin lupes u, biil. I tapiek isi i tom in lupes fanu ke ik ta liu kia tom una fiil fafis fanu fuun.” ");
INSERT INTO bjp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ke ri ka tapiek na Jeriko. Aunbiing Iesu turan berberat na fafausum kia ke tara gur na fanu sabin ri apti tinaiwa, nenge kaltu ae i kut, asa e Bartimeus (kamtinan as ae le kalalik ke Timeus), i kiis la na baban sal isi sising fanu. ");
INSERT INTO bjp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aunbiing i ongen u le Iesu tina Nasaret apiek, ka tautau aragii, “Iesu, kalalik ke Dewit, on mais iau!” ");
INSERT INTO bjp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma fanu fuun ri ka fakiing u isi in kiis fofo. Isau le ka lala tautau mang tom aragii, “Kalalik ke Dewit, on mais iau!” ");
INSERT INTO bjp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu ka sotih ma ka tarah, “Tawi u uga.” Ri ka tawi pes kut ae ke ri ka tara sing i aragii, “In rorokiis e balam! Aptih! Iesu i tawi o.” ");
INSERT INTO bjp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus ka lin ufu dolon kaen kia, ka sirok ma ka la usuf Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ke Iesu ka diik u aragii, “Sani o ier isi le ian tel u ini wo?” Kut ae ka kiliis u aragii, “Tom fafausum, ia ier isi par.” ");
INSERT INTO bjp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu ka fas u aragii, “La mang, unune kiam ka faliu ta wo.” Fanpil ka par ke ka mi lo Iesu tole sal. ");
INSERT INTO bjp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aunbiing ri ka la fatat Ierusalem, ri ka tapiek na Betfage ke Beteni na Pungpung na Olif, ke Iesu ka wuun ufu iwu e kalalik na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ka fas ru aragii, “Kamu la una maleh ae na famu lo kamuh. Aunbiing kamun tapiek, kamun par nenge fabiro dongki ae biil biitom tikas i kiis lo, ri kabet ta u aiwa. Puk ufu ke kamuk tangne u uga. ");
INSERT INTO bjp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Male tikas in diik kamu le, ‘Isi sani kamu ka tel u arae?’ ke kamun kiliis u le, ‘Kumguui imel e foim kia lo ma biil in sawin, ke ik filange fafis u sabin.’” ");
INSERT INTO bjp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aunbiing ru ka la, ru ka tafe dongki ae ri kabet ta u na nenge matanfel na bulin sal ke ru ka puk pes u. ");
INSERT INTO bjp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fale fanu ae ri soti ta aiwa, ri ka diik ru aragii, “Kamu puk ufu dongki ae isi sanih?” ");
INSERT INTO bjp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ru ka kiliis ri ini orek ae Iesu i fas ta ru ini, ke ri ka somangat ufu usuf ruh. ");
INSERT INTO bjp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ru ka tangne fabiro dongki ae usuf Iesu ke ru ka sol ini iun dolon kaen kiru na olon dongki ae, ma Iesu ka kiis lo. ");
INSERT INTO bjp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fanu fuun ri ka sol ini foron dolon kaen kiri sabin tole sal, ke fal ri pakat foron akan au tina topormok ma ri ka sol ini tole sal. ");
INSERT INTO bjp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma fanu ae ri famfamu la ke ae ri mimi la, ri ka famam tautau aragii, “Osana!” “Fafakalok usuf ier ae i la uga ini asa Kumguui!” ");
INSERT INTO bjp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Fafakalok una matanfuntih ke tama kerer Dewit ae in tapiek!” “Osana ubae na mawe!” ");
INSERT INTO bjp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aunbiing Iesu i kau na Ierusalem, ka la una Felun Tunmapek. Ka par tikii ta foron tier, isau le ka fis una Beteni turan sangful ini u e kalalik na fafausum kia, wara le ka efef mang. ");
INSERT INTO bjp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na biing namih, aunbiing ri fis tina Beteni, Iesu ka fitol. ");
INSERT INTO bjp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka par nenge au na fik tina tapak, i batong rokap ke ka la isi par u, isi ti fale fua. Aunbiing i tapiek aiwa na pikli, ka par u le biil ti fua, awu kanan sau, wara le biil biitom e taul fua ken fik. ");
INSERT INTO bjp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ke ka fas au na fik ae aragii, “Tipes u igii, biil sabin tikas in ien ti fuam.” Berberat na fafausum kia ri ongen u i use u arae. ");
INSERT INTO bjp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aunbiing ri ka tapiek na Ierusalem, Iesu ka kau na palgan ubiif kale Felun Tunmapek. Ka fes fasuu fanu tinaiwa, ae ri famam fifiil turan fanu sabin ae ri sufii foron tier isi fanu rik fiil u. Ka fabereng foron luuf ini fanu ae ri famam sokiliis pitkalang ke foron luuf ken fanu ae ri sufii foron bun. ");
INSERT INTO bjp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma biil i somangat pes fanu isi rin soleng palgan ubiif kale Felun Tunmapek ini foron tier una fifiil. ");
INSERT INTO bjp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aunbiing i fausum ri, ka tarah, “Ri siit ta u na Buk na Gogoh aragii, ‘Rin foteng fel kiak le Felun Sising ken fanu tikii na piklinbat.’ Isau le gam ka tel u bin arae ‘salan mumumun ken foron tom sisii.’” ");
INSERT INTO bjp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Foron laulaumet na pris ke foron tom fafausum ini nagogon sabin ri ka ongen u ma ri ka tipes im sal una siimete u. Ri soke u, wara le fanu tikii ri pangang na foron fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na efef, Iesu turan berberat na fafausum kia ri ka suu tina nanal na fel na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na biingbiing, aunbiing ri toltole sal fis la, ri ka par u le au na fik ae ka mang tikii ta tina foron bauli. ");
INSERT INTO bjp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ke Pita ka wolpes orek ke Iesu ke ka tara sing i aragii, “Rabi, par u! Au na fik ae o bo ta u, ka mang tah!” ");
INSERT INTO bjp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu ka kiliis u aragii, “Gamen unune lo God. ");
INSERT INTO bjp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tekentu kanaka ia fas gam, male tikas i fas pungpung igii le, ‘Aptih ma ok luut na palgantes,’ ma biil iwu e wolwol kia, isau le i unune tom le in tapiek, ke in tapiek tom arae. ");
INSERT INTO bjp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pesu, ia ka fas gam, foron tier tikii ae gam sising isi, gamen unune le gam ka kep ta u, ke God ik ta u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Aunbiing gam sotih isi sising ma gam ka wolpes ti sinang laulau ae tikas i tel ta u ulo gam, gamen wol ufu, isi Tata buuii na kukulii ik pa ufu foron sinang laulau sabin kimi.” ");
INSERT INTO bjp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri ka tapiek sabin bae na Ierusalem. Aunbiing Iesu ka la na palgan ubiif kale Felun Tunmapek, foron laulaumet na pris, foron tom fafausum ini nagogon turan foron famfamu ri ka la usuf i ");
INSERT INTO bjp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ke ri ka diik u aragii, “Rakrakai tinga o tel foron tier igii ini? Se i ta u e rakrakai sing o una tel foron tier igii?” ");
INSERT INTO bjp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu ka kiliis ri aragii, “Ia sabin ian diik gam ini nenge fagalte. Male gamen kiliis iau, ke ian fas gam ini rakrakai tinga ia tel foron tier igii ini. ");
INSERT INTO bjp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Gam fas iau, bapitaiso ke Jon tinbae na kukulii, le sing fanu sau?” ");
INSERT INTO bjp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ke ri ka ngurke u tom na fatpoto ri aragii, “Male keren tara le, ‘tinbae na kukulii,’ ke in diik kerer le, ‘Isi sani biil gam unune lo?’ ");
INSERT INTO bjp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Isau le, gong kere tara le, ‘sing fanu sau.’” Ri use u arae, wara le ri soke fanu, wara fanu tikii ri unune le Jon i nenge profet. ");
INSERT INTO bjp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ke ri ka kiliis u sau aragii, “Biil keme usum.” Iesu ka tara sing ri aragii, “Iau sabin, biil ian fas gam le rakrakai tinga ia tel foron tier igii ini.” ");
INSERT INTO bjp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Namih, Iesu ka tipes fas ri sabin ini foron orek fatoftof igii: “Nenge kaltu i so nenge porpor wain ke ka ubiif kale u. Aiwa na palgan porpor wain ae, ka tuung nenge fat una bing turim danun wain, ke ka tel nenge fabiro fel ae i kangkang ken tom parpar kaleh. Namih, ka ta porpor wain ae usuf fale tom foim isi rin parpar kale ta bii lo, ma ka la na nenge ninla. ");
INSERT INTO bjp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na taul lulus, ka wuun ufu nenge fafauun usuf foron tom foim ae, isi ti fale fuan wain sing ri tina porpor wain kia. ");
INSERT INTO bjp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Isau le ri ka luse u, ri ka pakti ke ri ka wuun fafis u ini lima kanan sau. ");
INSERT INTO bjp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ke taman porpor wain ae ka wuun ufu nenge fafauun sabin usuf ri, ri ka paket u na paklu ke ri ka famatlawen u. ");
INSERT INTO bjp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka wuun ufu nenge fafauun sabin, ke ri ka siimete u. Ka wuun ufu ifuun sabin, isau le ri ka paket fal ke ri ka siimete fal. ");
INSERT INTO bjp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ka tikii mang aiwa tura, e ke kalalik tutus, ae i ier kanaka isi. Ka wuun ufu mang tom usuf ri ma ka tarah, ‘Rin bulat lo keng kalalik.’ ");
INSERT INTO bjp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Isau le foron tom foim ri ka put orek aragii, ‘Ier ae in ti kiliis tama. Kere mang, kerek siimete u isi kirer mang e porpor wain ae tama i fakale ta u ini.’ ");
INSERT INTO bjp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ri ka luse u, ri ka siimete u ke ri ka lin fasuu u tina porpor wain ae. ");
INSERT INTO bjp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Sani sabin taman porpor wain ae ik tel u? In la ma ik siimete foron tom foim ae ma ik ta porpor wain ae usuf fale fanu keskes. ");
INSERT INTO bjp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Arafah, biil gam wes sun orek ae na Buk na Gogoh? I use u le, ‘Tuh ae foron tom tel fel ri puris ta u, ka tapiek temin tuh. ");
INSERT INTO bjp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tier igii Kumguui tom i tel ta u, ma i rokap kanaka na parpar kirer.’” ");
INSERT INTO bjp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ke foron famfamu ken fan Iudaia ri ka im sal isi rin luse Iesu, wara le ri usum le i use orek fatoftof igii ulo ri. Isau le ri soke gur na fanu ae, pesu ri ka la koseng u. ");
INSERT INTO bjp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Namih, ri ka wuun ufu fale Farasi turan fale fanu ke Erot usuf Iesu, isi rik tatakuun pes u ini ti orek ae in use u. ");
INSERT INTO bjp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aunbiing ri la usuf i, ri ka tarah, “Tom fafausum, keme usum le o tom tortores, ma biil o wol pes sani fanu ri use u ulo wo. Fafausum kiam i fafasi sau usuf fanu tikii ma o fausum tekentu ri la tom ini sinangu God. Arafah, i tortores le keren fiil takiis usuf Sisar, le biil? ");
INSERT INTO bjp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Arafah, keren ta u le biil?” Ka iliim ta lem kiri, pesu ka diik ri aragii, “Isi sani gam ka ier isi takun iau? Ti dinaria uga iak par u.” ");
INSERT INTO bjp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ke ri ka ta nenge dinaria usuf i. Ke ka diik ri aragii, “Tantanwa se ke asa se igii lo?” Ke ri ka kiliis u aragii, “Sisar.” ");
INSERT INTO bjp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ke ka fas ri aragii, “Sani ke Sisar, ta u usuf Sisar, ma sani ke God, ta u usuf God.” Ke ri ka lala bitit lo. ");
INSERT INTO bjp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Namih, foron Sadusi ri ka la usuf Iesu. Ri use u la le biil ti apaptifis. Ri ka la ini nenge fagalte ke ri ka tarah, ");
INSERT INTO bjp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tom fafausum, Moses i siit ta u usuf kerer aragii, male nenge kaltu i met koseng antu ma biil ti kalalik kiruh, ke tualik in telpes makos ae, isi ik fapuar ti berberat ke tualik ae ka met tah. ");
INSERT INTO bjp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nenge ifit latualik, neng famu i fakekel ta ke ka met ma biil ti kalalik kia. ");
INSERT INTO bjp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ke fawu u e tualik ka telpes makos kia, ke ka met sabin koseng u ma biil ti kalalik kia. Ma fatuul u sabin arae. ");
INSERT INTO bjp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ifit latualik tikii ae ri telpes ta fifin ae, ke ri ka met ma biil ti kalalik kiri. Namih, fifin sabin ae ka met. ");
INSERT INTO bjp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na biingen apaptifis, fifin ae in antu se tutus mang lo ri? Wara le ri fit tikii ri telpes ta u.” ");
INSERT INTO bjp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu ka kiliis ri aragii, “Gam ka la ger tah, wara le biil gam usum na foron orek ae na Buk na Gogoh ke na rakrakai sabin ke God. ");
INSERT INTO bjp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aunbiing foron minet rin apti fis, biil rin to fakekel sabin, biil. Rin arae foron angelo buuii na kukulii. ");
INSERT INTO bjp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gam use u le biil ti apaptifis. Arafah, biil biitom gam wes ususe ae na buk ke Moses na au ae i sok? God i fas Moses aragii, ‘Ia God ke Abaram, God ke Aisak ke God ke Jekop.’ ");
INSERT INTO bjp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God biil i God ken foron minet, biil. I God ken fanu ae ri liu. Gam la ger kanaka.” ");
INSERT INTO bjp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Neng lon foron tom fafausum ini nagogon i la ma ka ongen Iesu i fafapit la turan foron Sadusi. Ka ongen u le i kiliis fakasi ri, ke ka diik u aragii, “Nagogon sa i laumet kanaka lon foron nagogon tikii?” ");
INSERT INTO bjp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu ka kiliis u aragii, “Igii e nagogon ae i laumet kanaka, ‘Fan Israel, gam ongen u: Kumguui God kirer, i keskes sau i e God. ");
INSERT INTO bjp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","On ier isi Kumguui, God kiam, ini balam tikii, ini tanwam tikii, ini wolwol tikii kiam ke ini rakrakai tikii kiam.’ ");
INSERT INTO bjp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma fawu u e nagogon i aragii: ‘On ier isi ier ae na fatat o, arae o ier isi wo tom.’ Biil ti nagogon i laumet lon iwu e nagogon igii.” ");
INSERT INTO bjp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tom fafausum ini nagogon ae ka tara sing Iesu aragii, “Tom fafausum, i tekentu kanaka, i tortores e orek kiam, le God itikii sau ma biil sabin tikas awii. ");
INSERT INTO bjp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Keren ier isi God ini balrer tikii, ini wolwol tikii kirer ke ini rakrakai tikii kirer. Ke kerek ier isi fanse ae na fatat kerer, arae kere ier isi kerer tom. Iun nagogon igii, ru laumet kanaka lon foron tunmapek tikii ae ri ta u usuf God, ke foron fafen sabin.” ");
INSERT INTO bjp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aunbiing Iesu i par u le tom fafausum ae i kiliis fakasi u tom, ka tarah, “Biil o tapak tina matanfuntih ke God.” Ma tipes u mang aiwa, ri ka binbin mang isi diik Iesu ini ti fagalte. ");
INSERT INTO bjp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Aunbiing Iesu i fafausum ri la awii na Felun Tunmapek, ka diik ri aragii, “Isi sani foron tom fafausum ini nagogon ri ka tara le Mesaia i e kalalik ke Dewit? ");
INSERT INTO bjp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tanwa Kalkaluu i susuef ta ulo Dewit ma ka tarah, ‘Kumguui God i tara sing Kumguui kiak: Kiis na miang, papang na aunbiing ian luun foron tuui kiam na piklin kekem.’ ");
INSERT INTO bjp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit tom i foteng ta Mesaia le i Kumguui kia. Male i arae, in tapiek kalalik ke Dewit arafah?” Tara gur na fanu ae ri laes kanaka aunbiing ri ongen orek ke Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Aunbiing i fafausum ri la, ka tarah, “Gamen tumarang lon foron tom fafausum ini nagogon. Ri ier la isi rin soleng fanu ini foron rokap na kilkiliis, ke ri ka ier la isi fanu rin faorek pes ri ini bulat na foron salan la turim. ");
INSERT INTO bjp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma ri ier isi kiis la tom na foron nian kiiskiis kausi na foron felun lotu, ke nian kiiskiis ken foron laulaumet na foron tel inen. ");
INSERT INTO bjp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ri farop minmaran foron makos la, ke ri ka tel foron dolon sising la isi fanu rik par ri. Matngan fanu arae, in laulau kanaka e fangungut rin kep u.” ");
INSERT INTO bjp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu i kiis ta fatat isi salan luun pitkalang na Felun Tunmapek ke ka par fanu fuun ri famam luun pitkalang. Ifuun e fanu ae ifuun e minsik kiri, ri luun piran pitkalang aiwa na salan luun pitkalang. ");
INSERT INTO bjp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Isau le nenge lauu na makos, ka la ma ka luun iwu sau e fabiro pitkalang ae i afi kanaka. ");
INSERT INTO bjp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu ka tawi pes berberat na fafausum kia, ke ka fas ri aragii, “Tekentu kanaka ia fas gam, lauu na makos igii, i luun tara pitkalang na salan luun pitkalang lon fanu tikii igii. ");
INSERT INTO bjp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ri tikii ri ta u tina foron minsik kiri. Isau le lauu na makos igii, i ta ufu foron tier tikii kia, foron tier tikii ae in fasi na kiis kia.” ");
INSERT INTO bjp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Aunbiing Iesu ka suu tina Felun Tunmapek, neng lon berberat na fafausum kia ka tara sing i aragii, “Tom fafausum, par foron rokap na fel igii ae ri tel ta u ini pirpiran fat.” ");
INSERT INTO bjp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu ka kiliis u le, “O par piran fel igii? Namih, biil mang in tikii e fat in borong na olon neng, rin lin sabalke ri tikii.” ");
INSERT INTO bjp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aunbiing Iesu i kiis bae na olon Pungpung na Olif ma ri ka par una Felun Tunmapek, Pita, Jems, Jon ke Enru ri ka diik fakum u aragii, ");
INSERT INTO bjp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Fas kemem, nangis foron tier igii in tapiek? Ke matngan fakileng arafa in finngas u le foron tier igii, fatat ik suut?” ");
INSERT INTO bjp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu ka kiliis ri aragii, “Gamen tumarang, tarama tikas ka fabal gam. ");
INSERT INTO bjp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","In fuun rin la ini asang ma rik use u lo ri tom le, ‘Iau e Mesaia’, ke rik fabal fanu fuun. ");
INSERT INTO bjp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Aunbiing gamen ongen fapaket ke babauus na foron fapaket, gong gam nangnangih, wara le foron tier arae in tapiek tom, isau le farfarop na biing biil biitom. ");
INSERT INTO bjp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nenge funmat in fapaket turan nenge funmat, ke nenge matanfuntih in fapaket turan nenge matanfuntih. Gih turan fitol in tapiek na fale maleh. Foron tier igii in arae tanwaran fangungut ae nenge fifin i kalsakai famu u, aunbiing i fafang. ");
INSERT INTO bjp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gamen tumarang. Fanu rin ta ufu gam na liman foron tom nagogon ma rik pis gam awii na foron felun lotu. Gamen ti na matan foron famfamu na matanfuntih turan foron king, i wara lo iau, ke gamek famalal iau usuf ri. ");
INSERT INTO bjp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma Rokap na Fafas in la famu usuf foron funmat tikii na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aunbiing rin dat gam una nagogon, gong gam lala wol isi sani gamen use u. Gamen use orek sau ae Tanwa Kalkaluu in fas gam ini na aunbiing ae, wara le biil e gam ae gamen orek, biil. Tanwa Kalkaluu tom. ");
INSERT INTO bjp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nenge kaltu in somangat ufu tualik isi rin siimete u, ke nenge kaltu in somangat ufu ke kalalik isi rin siimete u. Berberat rin fapaket turan foron temri ke tinri ke rik somangat ufu ri, isi fanu rik siimete ri. ");
INSERT INTO bjp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma fanu tikii rin ememse gam, i wara na asang. Isau le se i tifat una farfarop, God in faliu u. ");
INSERT INTO bjp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Gamen par nenge tier ae i laulau kanaka in tapiek, in kiis na falifu ae biil i tortores le in kiis lo ma ik fadu u. Se i wes foron orek igii, i rokap le in malal ulo. Na aunbiing ae, fanse ae ri kiis na falifu na Iudaia, rin fin una foron pungpung. ");
INSERT INTO bjp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Male tikas bae na olon fel kia, aunbiing in puh, gong i kau isi kep fasuu ti minmara. ");
INSERT INTO bjp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ke male tikas awii na mok, gong i fis una fel isi kep kilkiliis kia. ");
INSERT INTO bjp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kiskam kanaka sing foron tian turan kelefin ae ri fasfasus na aunbiing ae. ");
INSERT INTO bjp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gamen sising isi foron tier igii gong i tapiek na funiil ae falifu i mir la. ");
INSERT INTO bjp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wara le foron biing ae, tatawin in laumet kanaka tom na foron tatawin ae i tapiek la aga na piklinbat, tipes u na aunbiing God i fakiis ta piklinbat papang igii ma namih, biil sabin in mel e tatawin in arae. ");
INSERT INTO bjp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Male Kumguui biil in kiit fatukli aunbiing na tatawin ae, ke biil tikas in liu. Isau le, ka kiit fatukli u, wara lon fanu ae ka tus pes ta ri ma ka somangat pes ta ri. ");
INSERT INTO bjp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Na aunbiing ae, male tikas in fas gam le, ‘Par u! Igii e Mesaia!’ le ‘Par u! Ae e Mesaia!’ gong gam unune lo. ");
INSERT INTO bjp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wara le foron mesaia famfabal ke foron profet famfabal rin tapiek. Ke rik fatapiek foron fakileng ke foron tier an fabitit. Male ri fasih, ke rik fabal fanu ae God ka tus pes ta ri. ");
INSERT INTO bjp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pesu gamen tumarang. Igii ia ka fas famu gam mang ini foron tier tikii ae in tapiek. ");
INSERT INTO bjp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na foron biing nami sau na tara tatawin ae, ‘matan pisiih in kubunor, funiil biil in to popos, ");
INSERT INTO bjp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","foron keltot rin luut tinbae na bat ma foron tier buuii na bat rik nut.’ ");
INSERT INTO bjp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Na aunbiing ae, fanu rin par Kalalik ken Kaltu in tapiek na laukaf ini tara rakrakai ke memeh kia. ");
INSERT INTO bjp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma in wuun foron angelo kia isi tel turim fanu kia ae ka tim pes ta ri tina ifet e matan kif, tina nenge baban nanal una nenge baba sabin. ");
INSERT INTO bjp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gamen kep usum tina au na fik. Aunbiing foron kubu i kuum ke foron awu ka tampalas, gamek usum le foron funiil ae falifu i tuntun la ka fatat. ");
INSERT INTO bjp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ifasi sabin arae, aunbiing gam par tier ae ia use ta u i taptapiek la, ke gamek usum le aunbiing ka fatat, ae mang na matanfel. ");
INSERT INTO bjp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tekentu kanaka ia fas gam, fanu na ulul igii biil tom rin mangmangal, ke foron tier tikii igii ik tapiek. ");
INSERT INTO bjp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kukulii turan piklinbat run mangmangal, isau le foron orek kiak biil in to mangmangal. ");
INSERT INTO bjp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Biil tikas i usum na biing ke na aunbiing. Foron angelo sabin buuii na kukulii tura ke Kalalik biil ri usum, biil. Tata keskes sau. ");
INSERT INTO bjp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gamen tumarang ke gamek geges! Wara le biil gam usum le nangis e aunbiing ae in tapiek. ");
INSERT INTO bjp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I arae nenge kaltu ae i geges isi in la na nenge ninla. Ka luun fel kia na liman foron fafauun kia isi rin fofonoi lo. Ka tem foron foim usuf temtem tikii lo ri, ke ka fas tom parpar kale na matanfel isi in parpar rokap. ");
INSERT INTO bjp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Pesu, gamen tumarang, wara le biil gam usum na aunbiing sa taman fel in tapiek. Tarama in tapiek na efef, le na fapot, le na aunbiing to in teng, le na biingbiing. ");
INSERT INTO bjp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Male in tapiek sape, ke gong i tafe gam le gam gok. ");
INSERT INTO bjp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sani ia fas gam ini, ia fas fanu tikii sabin ini le, ‘Gamen tumarang!’” ");
INSERT INTO bjp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iwu e biing famu na Ngasa na Liuliu Kulef ke Ngasa na Beret ae biil ti is lo, foron laulaumet na pris turan foron tom fafausum ini nagogon ri ka im sal isi rin luse fakum Iesu ma rik siimete u. ");
INSERT INTO bjp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ri ka tarah, “Gong kere tel u na aunbiing na ngasa, tarama fanu ri ka fapaket.” ");
INSERT INTO bjp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu tinawii biitom na Beteni na fel ke Saimon ae pakanini i sem ta lepra. Aunbiing i ienien la, nenge fifin ka la usuf i ini nenge sanda ae i furung rokap ma ri foteng u ini nat. I fen kanaka e mata ma pungu ri tel u ini fat ae ri foteng u ini alabasta. Ka bayi ufu mata ke ka fore u na olo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Fale fanu ae ri kiis ta aiwa, ri ka ngaliaf ma ri ka tara fis tom sing ri aragii, “Isi sani ka falange sanda igii? ");
INSERT INTO bjp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ifasi le tikas in fiil pes u ini ituul e mar ma tiga e dinaria, isi ik ta u usuf foron lauu.” Ke ri ka belbel orek ulo. ");
INSERT INTO bjp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Isau le, Iesu ka tara sing ri aragii, “Sok ufu. Isi sani gam ka fatel u? Tier igii i tel u ulo iau i rokap kanaka. ");
INSERT INTO bjp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Foron lauu rin kiis fitliu naismi, ke ifasi gamen lupes ri na aunbiing sa gam ier isi. Isau le iau, biil ian to kiis fitliu tura gam. ");
INSERT INTO bjp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Sani ae ifasi le in tel u, ka tel fasuut ta u. I fore sanda igii na olong, una fageges famu pununfong isi biingen ilile kiak. ");
INSERT INTO bjp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tekentu kanaka ia fas gam, na foron maleh tikii na piklinbat, aunbiing rin fafas ini Rokap na Fafas, sani fifin igii i tel ta u, rin use u una namnamne tirik isi.” ");
INSERT INTO bjp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iudas Iskariot neng lon nenge sangful ini u e kalalik na fafausum, ka la usuf foron laulaumet na pris isi in ta ufu Iesu una limri. ");
INSERT INTO bjp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aunbiing ri ongen u arae, ri ka lala laes ke ri ka falimlim le rin suat u tom. Ke Iudas ka tipes im isi ti aunbiing rokap isi ik ta ufu Iesu una limri. ");
INSERT INTO bjp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na biing famu na Ngasa na Beret ae biil ti is lo, aunbiing ri siimete natun sipsip la lo una Ngasa na Liuliu Kulef, berberat na fafausum ri ka diik Iesu aragii, “Fia o ier le kemen la isi fageges inen kiam wa una Ngasa na Liuliu Kulef?” ");
INSERT INTO bjp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ke ka wuun ufu iwu e kalalik na fafausum kia ma ka fas ru aragii, “Kamun kau na Ierusalem, ma nenge kaltu ae i kusep nenge luunluun dan in tafe kamuh. Kamun mi lo ");
INSERT INTO bjp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","una fel ae in kau lo, ke kamuk diik taman fel ae aragii, ‘Tom Fafausum i diik le, fiawa e falifu ae i turan berberat na fafausum kia rin ien inen na Liuliu Kulef lo?’ ");
INSERT INTO bjp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ke ik finngas kamu ini nenge tara sun fel bae na mawe na fel, ae ri ka tumarnge ta u ma ri ka fageges ta u. Ke kamuk fageges inen arer aiwa.” ");
INSERT INTO bjp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iun kalalik na fafausum ae ru ka kau na Ierusalem, ke ru ka tafe foron tier tikii arae tom Iesu i fas ta ru ini. Ke ru ka fageges inen na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na efef, Iesu turan sangful ini u e kalalik na fafausum kia ri ka tapiek. ");
INSERT INTO bjp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aunbiing ri ienien la, Iesu ka tarah, “Tekentu kanaka ia fas gam, neng lo gam tom igii i ienien la turang, in ta ufu iau una liman foron tuui.” ");
INSERT INTO bjp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka purngis kanaka e balri ke temtem tikii lo ri ka tarah, “O use iau?” ");
INSERT INTO bjp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ke Iesu ka fas ri aragii, “Neng lo gam tom e sangful ini u e kalalik na fafausum, ae i falum beret na dis turang. ");
INSERT INTO bjp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kalalik ken Kaltu in met tom arae ri siit ta u na Buk na Gogoh. Isau le kiskam kanaka sing ier ae in ta ufu una liman foron tuui. In rokap male biil in pang tah.” ");
INSERT INTO bjp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aunbiing ri ienien la, Iesu ka kep beret, ka fotrokap lo usuf God, ka simsibik u ke ka fen berberat na fafausum kia ini ma ka tarah, “Igii e pununfong, gam kep u.” ");
INSERT INTO bjp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Namih, ka kep kap na wain, ka fotrokap lo usuf God, ka ta u usuf ri ke ri tikii ri ka yin lo. ");
INSERT INTO bjp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ke ka fas ri aragii, “Igii e daung ae i ring isi fanu fuun, ae i fasuut falimlim ke God isi fanu kia. ");
INSERT INTO bjp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tekentu kanaka ia fas gam, biil sabin ian umin danun wain igii papang na aunbiing ian umin wain fuu na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aunbiing ri ka sek ta nenge seksek, ri ka suuh ke ri ka la una Pungpung na Olif. ");
INSERT INTO bjp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu ka fas ri aragii, “Gam tikii gamen fin koseng iau, arae ri siit ta u na Buk na Gogoh le God i tarah, ‘Ian siimete tom fofonoi na sipsip, ke foron sipsip rik fin sararah.’ ");
INSERT INTO bjp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Isau le aunbiing ia ka apti fis tah, ian famu lo gam una Galili.” ");
INSERT INTO bjp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita ka tara sing i aragii, “Taftawa le ri tikii rin fin koseng o, iau biil tom.” ");
INSERT INTO bjp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu ka kiliis u aragii, “Tekentu kanaka ia fas o, igii na wor aunbiing to biil biitom fawu i teng, ke fatuul ok fakawe ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Isau le Pita ka rakrakai tom le, “Taftawa le ian met turam, biil tom ian fakawe ufu wo.” Ke berberat na fafausum tikii sabin, ri ka use u arae. ");
INSERT INTO bjp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iesu turan berberat na fafausum kia ri ka la una nenge falifu asa e Getsemani, ke ka fas ri aragii, “Gamen kiis sau aga ma iak sising.” ");
INSERT INTO bjp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ke ka telpes Pita, Jems ke Jon. Na aunbiing ae, ka tipes kalsakai tara mamais ma ka purngis e bala. ");
INSERT INTO bjp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka fas rituul aragii, “Mamais ifuun na balang ma fatat iak met. Gamtuulen kiis agawa ma gamtuulek mat.” ");
INSERT INTO bjp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ka mamlik la ituul sau, ke ka luutuf na nanal ma ka sising le, male ifasi, ke aunbiing ae gong i tapiek lo. ");
INSERT INTO bjp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ka sising aragii, “Aba, Tata, o fasi on tel foron tier tikii, tel ufu kap igii koseng iau. Isau le gong o mi lo arae na wolwol kiak, mi tom lo arae na wolwol kiam.” ");
INSERT INTO bjp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aunbiing i fis, ka par u le tuul kalalik na fafausum kia rituul masun. Ke ka diik Pita aragii, “Saimon, arafah, o ka masun bin? Biil ifasi on mat bii pes ti fatuklin aunbiing? ");
INSERT INTO bjp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mat ma gamtuulek sising, tarama gamtuul ka luut na fatoftof. Tanwa gamtuul i gesges, isau le fo gamtuul i mut.” ");
INSERT INTO bjp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ke, ka la ma ka sising sabin arae sau i sising ta na famu. ");
INSERT INTO bjp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aunbiing ka fis sabin, ka par u le rituul ka masun fis tah, wara le matrituul i tatawin kanaka. Biil rituul usum na sani rituulen use u usuf i. ");
INSERT INTO bjp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Fatuul u e aunbiing ka fis sabin ke ka tarah, “Gamtuul borborong la biitom? Ka fasi mang. Aunbiing igii mang ka tapiek tah. Par u, igii mang rik ta ufu Kalalik ken Kaltu una liman foron tom tel sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aptih, kerek la. Par u, kaltu ae in ta ufu iau apiek mang.” ");
INSERT INTO bjp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Aunbiing Iesu i ororek la, Iudas neng lon sangful ini u e kalalik na fafausum, ka tapiek turan nenge gur na fanu. Ri kep foron popok una fapaket turan foron kapsil. Foron laulaumet na pris turan foron tom fafausum ini nagogon ke foron famfamu ri wuun ufu ta ri. ");
INSERT INTO bjp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ier ae in ta ufu Iesu ka fas famu ta fanu ae ini matngan fakileng ae in tel u ulo Iesu. I fas ta ri aragii, “Ier ae ian dor u, i sau e kaltu ae. Gam luse u ke gamek lame ufu, ma matmi ta tom lo.” ");
INSERT INTO bjp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Fanpil Iudas ka la usuf Iesu ke ka faorek pes u aragii, “Rabi!” Ke ka dor u. ");
INSERT INTO bjp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ke ri ka pose lo ma ri ka dat pes u. ");
INSERT INTO bjp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Neng lon fanu ae ri soti ta awii na fatat, ka fut ufu popok una fapaket kia ke ka kasim ufu balbalun fafauun ken famfamu ken foron pris. ");
INSERT INTO bjp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ke Iesu ka tara sing ri aragii, “Arafah, awii ngan ia nenge tom sisiimete, ae gam ka la ini foron popok una fapaket turan foron kapsil isi luse iau, beh? ");
INSERT INTO bjp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Foron biing tikii ia kiis la tura gam ma ia ka fausum fanu la na Felun Tunmapek, ke biil gam luse iau. Isau le ka tapiek aragii una fasuut orek ae na Buk na Gogoh.” ");
INSERT INTO bjp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ke berberat na fafausum tikii kia ri ka apti koseng u ma ri ka fin. ");
INSERT INTO bjp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nenge guam ae i mimi la lo Iesu, i fis ta u sau ini nenge kaen. Aunbiing ri luse u, ");
INSERT INTO bjp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ka sok ufu kaen kia aiwa na limri ke ka fin ini pongong. ");
INSERT INTO bjp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ri ka lame Iesu usuf famfamu ken foron pris. Ma foron laulaumet na pris tikii, foron famfamu turan foron tom fafausum ini nagogon, ri ka tapiek turim aiwa. ");
INSERT INTO bjp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita i mimi susu la tom ke ka kau una palgan ubiif kale fel ken famfamu ken foron pris. Ka kiis turan foron tom parpar kaleh ma ka mingmingi na yiif. ");
INSERT INTO bjp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Foron laulaumet na pris turan foron famfamu tikii ken fan Iudaia, ri ka im isi ti fale orek una tiu Iesu isi rik siimete u. Isau le biil ri tafe tikas. ");
INSERT INTO bjp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ifuun ri ka lem ulo Iesu, isau le foron orek kiri biil i fafasih. ");
INSERT INTO bjp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Fale fanu ri ka sotih ma ri ka lem ulo Iesu le, ");
INSERT INTO bjp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Keme ongen ta u i use u le in rabat Felun Tunmapek igii, ae fanu ri tel ta u, ke na in tuul e biing, ik tel neng ae fanu biil ri tel u.” ");
INSERT INTO bjp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Isau le foron orek kiri biil i fafasih. ");
INSERT INTO bjp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Famfamu ken foron pris ka soti na famu lo ri ke ka diik Iesu aragii, “Arafah, biil ti orek kiam una kiliis u? Orek arafa igii ri tiu o ini?” ");
INSERT INTO bjp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Isau le Iesu biil i kiliis ri ini ti orek. Famfamu ken foron pris ka diik u sabin le, “Arafah, o Mesaia, Kalalik ke God ae i kalok fitliu?” ");
INSERT INTO bjp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu ka kiliis u aragii, “Iau sau. Nami gamen par Kalalik ken Kaltu in kiis na mia God ae i Rakrakai, ma in tapiek na laukaf tinbae na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Famfamu ken foron pris ka si dolon kaen kia tom ma ka tarah, “Isi sa biitom kere ka ier isi ti orek una tiu u? ");
INSERT INTO bjp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gam ka ongen ta u e foron orek laulau kia ulo God. Arafa gam wol arae?” Ke ri tikii ri ka somangat ufu le in met tom. ");
INSERT INTO bjp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ke fal lo ri, ri ka tipes ubis u. Ri ka kabet kale mata ma ri ka tut u ke ri ka tara sing i aragii, “Arik, orek profet mang!” Ke foron tom parpar kaleh ri dat pes u ke ri ka paket u. ");
INSERT INTO bjp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Aunbiing Pita tinaiwa biitom na palgan ubiif kale fel ae, nenge tah, fafauun ken famfamu ken foron pris ka tapiek. ");
INSERT INTO bjp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aunbiing i par Pita i mingmingih la aiwa, ka lala kanap u ke ka tarah, “O sabin o la la tura Iesu tina Nasaret, bikiih?” ");
INSERT INTO bjp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Isau le Pita ka fakawe aragii, “Biil ia to usum ke biil ia malal na sani o use u.” Ka suu una matan ubiif, ke to ka teng. ");
INSERT INTO bjp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tah ae ka par u sabin ke ka fas fanu ae ri sotsoti la aiwa aragii, “Ier igii i neng lo ri.” ");
INSERT INTO bjp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ke Pita ka fakawe sabin. Biil i sawin ke fanu ae ri sotsoti la fatat Pita, ri ka tara sing i aragii, “Tekentu tom, o neng lo ri, wara le wo nenge sikin Galili.” ");
INSERT INTO bjp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ke ka fotfot ulo tom aragii, “God in ta fangungut usuf iau male ian lem. Biil ia to usum lon kaltu ae gam use u.” ");
INSERT INTO bjp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Fanpil fawu to ka teng. Ke Pita ka sikpes tineng aunbiing i wolpes foron orek ae Iesu i use ta u sing i le, “Biil biitom fawu to in teng, ke fatuul ok fakawe ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na biingbiing saksak, foron laulaumet na pris, foron famfamu, foron tom fafausum ini nagogon turan foron laulaumet tikii ken fan Iudaia, ri ka kiis turim ke ri ka tapiek ini nenge wolwol. Ri ka kabet iun lima Iesu ke ri ka lame ufu usuf Pailat. ");
INSERT INTO bjp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat ka diik u aragii, “Be, o king ken fan Iudaia?” Iesu ka kiliis u le, “Arae tom o use u.” ");
INSERT INTO bjp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Foron laulaumet na pris ri ka tiu u ini ifuun e tier. ");
INSERT INTO bjp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ke Pailat ka diik u sabin aragii, “Be, biil ti orek kiam una kiliis ri? Par u, ri tiu wo ini ifuun e tier.” ");
INSERT INTO bjp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Isau le Iesu biil i to kiliis u ini ti orek, pesu Pailat ka wolpane. ");
INSERT INTO bjp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na foron bet tikii na Ngasa na Liuliu Kulef, Pailat i fasuu ufu itikii la e kaltu tina kamkabet ae fanu ri sising pes u. ");
INSERT INTO bjp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na bet ae, nenge kaltu asa e Barabas, i e neng lon fanu ae ri fapti ta nenge tara fapaket. Ri kiis tikii na kamkabet, wara le ri siimete ta fale fanu. ");
INSERT INTO bjp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gur na fanu ri ka la usuf Pailat, ke ri ka sising u isi in fasuu tikas ae i kiis na kamkabet, arae tom i tel u la. ");
INSERT INTO bjp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ke Pailat ka diik ri aragii, “Arafah, gam ier le ian fasuu ufu King ken fan Iudaia usuf gam?” ");
INSERT INTO bjp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ka diik ri arae, wara le ka usum ta le foron laulaumet na pris ri ta ufu Iesu una lima, ini wolwol laulau sau kiri. ");
INSERT INTO bjp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Isau le foron laulaumet na pris ae, ri ka siingsiing orek na balan gur na fanu ae le rin sising Pailat isi in fasuu Barabas. ");
INSERT INTO bjp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat ka diik ri sabin aragii, “Sani ian tel u ini ier ae gam foteng u le King ken fan Iudaia?” ");
INSERT INTO bjp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ke ri ka perek aragii, “Fakulkulik u na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat ka diik sabin aragii, “Isi sah? Sani i tel fager ta u?” Isau le ri ka lala perek mang tom le, “Fakulkulik u na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat i ier isi falaes fanu, pesu ka fasuu ufu Barabas usuf ri. Ka fas foron tom fapaket isi rin fuk Iesu, nami ka ta ufu isi rin fakulkulik u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Foron tom fapaket ri ka lame Iesu una tara fel ae Pailat i kiis la lo, ke ri ka tawi turim foron tom fapaket tikii. ");
INSERT INTO bjp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ri fakilkiliis u ini dolon kaen melmelek, ke ri ka tel nenge bangbang ini finau ae imel e si ma ri ka luun u na paklu. ");
INSERT INTO bjp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ke ri ka faorek pes u aragii, “King ken fan Iudaia, mangiam!” ");
INSERT INTO bjp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ke ri ka famam paket paklu ini nenge akan au, ri ka ubis u ma ri ka lemlem ilepul na mata arae ri bulat lo. ");
INSERT INTO bjp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aunbiing ri ka morot ta ini, ri ka kasis ufu dolon kaen melmelek lo. Ri ka fakilkiliis fafis u ini kilkiliis kia tom, ke ri ka lame fasuu u isi rik fakulkulik u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Awii tole sal, foron tom fapaket ri ka tafe nenge kaltu tina Sairini asa e Saimon, tama Aleksenda ru e Rufus. I la tina nenge maleh isi in tatkau una Ierusalem. Ke foron tom fapaket ri ka fangongos u isi in kusep aupaket ke Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ri ka lame Iesu una falifu ae ri foteng u ini Golgota. Kamtinan as ae le, Salan Tuan Paklun Kaltu. ");
INSERT INTO bjp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ri ka ta wain sing i, ae ri ikis u turan bultan mir, isau le biil i to umin u. ");
INSERT INTO bjp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ri ka fakulkulik ta u na aupaket, ke ri ka fangfang laki isi se tom in kep ti kilkiliis kia. ");
INSERT INTO bjp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na isiu e aunbiing na biingbiing, ri ka fakulkulik u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ri ka siit orek ae ri tiu u ini bae na olon aupaket kia, aragii: ");
INSERT INTO bjp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ke ri ka fakulkulik iwu sabin e tom sisii tura na iwu e aupaket, neng na mia ke neng na kaisa. ");
INSERT INTO bjp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Fanu ae ri liuliu ufu Iesu la, ri ka famam orek laulau ulo, ri ka famam pakpakte paklu ri ulo ke ri ka tarah, “Uui! Wo, ae o tara ta le on rabat ufu Felun Tunmapek ma ok fapti fafis u na in tuul e biing, ");
INSERT INTO bjp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","pu mang tinbae na aupaket, ke ok faliu fafis wo tom!” ");
INSERT INTO bjp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Foron laulaumet na pris ke foron tom fafausum ini nagogon sabin, ri ka morot ini Iesu na fatpoto ri tom aragii, “I faliu fal, isau le biil ifasi in faliu fafis u tom! ");
INSERT INTO bjp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Male i Mesaia, King ken fan Israel, ke ik puh tinbae na aupaket isi kerek par u ma kerek unune lo.” Ke iun kaltu sabin ae ri fakulkulik ta ru na iun aupaket na iun baba, ru ka orek laulau ulo. ");
INSERT INTO bjp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na sangful ini u e aunbiing na siat, falifu tikii ka kubunor, papang na ituul e aunbiing na efef. ");
INSERT INTO bjp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma na ituul e aunbiing, Iesu ka ngangeh aragii, “Eloi, Eloi, lama sabakatani?” Kamtinan orek ae i aragii, “God kiak, God kiak, isi sa o ka la koseng iau?” ");
INSERT INTO bjp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aunbiing fanu ae ri sotsoti la na fatat ri ongen u, ri ka tarah, “Ongen u, i tawi Elaija.” ");
INSERT INTO bjp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nenge kaltu ka filau ma ka kep nenge tier ae i duup pes dan la, ka falum u na wain ae i mingin, ka tu u na nenge au ke ka sik u una mawe isi Iesu ik duup u. Ke ka tarah, “Nene, kerek par u la bii, tarama Elaija ka la isi fapu u.” ");
INSERT INTO bjp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu ka lala ngangeh, ke ka fut paket mangia. ");
INSERT INTO bjp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ke tara kaen na Felun Tunmapek ae i balo kale mua ae na palga, ka tamsih tinbae na mawe ubuif sikit na pikli. ");
INSERT INTO bjp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aunbiing kabisit ken foron tom fapaket ae i soti ta na famu na aupaket ke Iesu, i ongen Iesu i ngangeh ma ka par matngan minet kia, ka tarah, “Tekentu kanaka, kaltu igii i e Kalalik ke God.” ");
INSERT INTO bjp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Fale kelefin ri soti ta tina tapak ma ri ka alim foron tier ae i tapiek. Awii na fatpoto ri e Maria Makdalin, Salome ke Maria tina fabiro Jems ru e Joses. ");
INSERT INTO bjp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tuul fifin igii, rituul mi la lo Iesu aunbiing i kiis na Galili isi lupes u. Ke ifuun e kelefin sabin ri la turim ta tura una Ierusalem, ri sabin tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Biing ae, i e biingen geges wara le i biing famu na Biingen Mangeh. Josep tina Arimatia, i neng lon foron famfamu ken fan Iudaia ae ri bulat la lo, ma i nene la isi matanfuntih ke God. I kep balamas ma ka la usuf Pailat na efef aunbiing pisiih biil biitom i sup ke ka sising u isi pununfo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ka bitit aunbiing i ongen u le Iesu ka met tah. Ka kam pes kabisit ken foron tom fapaket ke ka diik u aragii, “Tekentu tom le Iesu ka met tah?” ");
INSERT INTO bjp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat ka ongen ta orek ken kabisit ae, ke ka mangte ufu pununfo Iesu usuf Josep. ");
INSERT INTO bjp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep ka fiil nenge rokap na kaen, ka fapu pununfo Iesu ke ka afit u ini. Namih, ka fakau u na matanfat una luun minet ae ri tuung ta u na balan fat, ke ka fabulbulis nenge tara fat una babat kale matanfat ae. ");
INSERT INTO bjp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdalin ru e Maria tina Joses, ru par falifu ae ri faborong ta Iesu lo. ");
INSERT INTO bjp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nami sau na Biingen Mangeh, Maria Makdalin, Maria tina Jems, ke Salome rituul ka fiil foron tier ae sana i furung rokap una saba u na pununfo Iesu. ");
INSERT INTO bjp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na biingbiing saksak na biing famu na wik ae, rituul ka la una matanfat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aunbiing rituul toltole sal la, rituul ka fadiik fis ini rituul aragii, “Se mang ik lupes kertuul na fabulbulis ufu fat ae ri babat kale ta matanfat ini?” ");
INSERT INTO bjp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Isau le aunbiing rituul lin matrituul una famu, rituul ka par u le tara fat ae, ri ka fabulbulis ufu tah. ");
INSERT INTO bjp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aunbiing rituul ka kau una matanfat ae, rituul ka par nenge guam ae i kilkiliis ini kaen pos. I kiis ta tina mia rituul, ma rituul ka sokeh. ");
INSERT INTO bjp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Guam ae ka fas rituul aragii, “Gong gamtuul sokeh. Ia usum le gamtuul im isi Iesu tina Nasaret ae ri fakulkulik ta u na aupaket. Mangmangal mang aga. Ka apti fis tah! Gamtuul par falifu ae ri faborong ta u lo. ");
INSERT INTO bjp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gamtuulen la ma gamtuulek fas berberat na fafausum kia tura Pita le, ‘Iesu in famu lo gam una Galili. Gamen tafe u aiwa, arae tom i fas ta gam.’” ");
INSERT INTO bjp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rituul ka fin koseng matanfat ae ke rituul ka nananar ini sokeh. Biil rituul use ti tier usuf tikas, wara le rituul lala sokeh. ");
INSERT INTO bjp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aunbiing Iesu i apti fis na biingbiing saksak na biing famu na wik, i tapiek famu sing Maria Makdalin ae Iesu i tel ufu ta ifit e tanwa laulau lo. ");
INSERT INTO bjp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Makdalin ka la ma ka fas fanu ae ri la la tura Iesu. Ri kiis ini mamais ma ri ka famam tingis u. ");
INSERT INTO bjp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aunbiing ri ka ongen ta u le Iesu ka liu fis tah, ke Maria Makdalin ka par ta u, biil ri to unune lo. ");
INSERT INTO bjp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Namih, Iesu ka tapiek sing iwu e kalalik na fafausum kia ae ru toltole sal la, isau le pununfo i par neng keskes. ");
INSERT INTO bjp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aunbiing ru fis, ru ka fas fale berberat na fafausum sabin, isau le biil ri unune lo ruh. ");
INSERT INTO bjp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Namih, Iesu ka tapiek sing nenge sangful ini tikii e kalalik na fafausum kia aunbiing ri ienien la. Ka balkut lo ri, wara le biil ti unune kiri, ma balri i sorokai kanaka isi unune na orek ken fanu ae ri ka par ta u nami na apaptifis kia. ");
INSERT INTO bjp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ke ka fas ri aragii, “Gamen la una foron falifu tikii na piklinbat, ke gamek fafas ini Rokap na Fafas usuf foron fakfakiis tikii. ");
INSERT INTO bjp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Se i unune ke ka kep bapitaiso, God in faliu u. Isau le se ae biil i to unune, in fiu na nagogon ke God. ");
INSERT INTO bjp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Foron tom unune rin fatapiek foron rakrakai na fakileng aragii: Rin tel ufu foron tanwa laulau ini asang, rin orek ini foron orek fuuh, ");
INSERT INTO bjp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","rin pose na foron sii ae imel e wef lo ma aunbiing rin umin danun mun, biil in to falaulau ri. Rin luun limri lon foron sasem, ke rik liu.” ");
INSERT INTO bjp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Aunbiing Kumguui Iesu ka fas ta ri ini foron tier igii, ke God ka kep u ubase na kukulii ma ka kiis na mia God. ");
INSERT INTO bjp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ke berberat na fafausum ri ka la ma ri ka fafas na foron falifu tikii. Kumguui i foim tura ri ma ka farakrakai orek kia ini foron fakileng ae ri fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Usuf Tiofilus: Ifuun e fanu ri totof rakrakai isi rin siit papte foron tier ae i tapiek ta na fatpoto kemem. ");
INSERT INTO bjp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Fanu ae ri par ta foron tier igii ini kolson matri tina tanwara, ma ri fafas la ini orek ke God, ri fas ta kemem ini foron tier igii. ");
INSERT INTO bjp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pesu, iau tom ia ka tatang rokap tah ke ia ka tafe ta foron tier tikii tina tanwara, ma ia wol le i rokap sabin le ian sisiit usuf o, Tiofilus, wo tara kaltu. Ia siit u tom arae i tapiek tah, ");
INSERT INTO bjp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","isi ok usum le foron tier tikii ae ri fausum ta wo ini, i tekentu. ");
INSERT INTO bjp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na aunbiing ae Erot i king na falifu na Iudaia, imel e nenge pris asa e Sakaria, i tina uh na pris ke Abia. Antu, asa e Elisabet, i sabin tina mat ke Aron. ");
INSERT INTO bjp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ru turim ru iwun tom tortores na mata God, ma ru misuut la tom na foron orek ke Kumguui ke na foron nagogon kia. ");
INSERT INTO bjp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Isau le biil ti kalalik kiruh, wara le Elisabet i koros. Ka wok mang ke Sakaria sabin ka tubunkak mang. ");
INSERT INTO bjp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nenge biing Sakaria i foim arae pris na mata God, wara le na aunbiing ae, uh na pris ke Sakaria ri tel foim na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na sinangun foron pris una tim pes se lo ri in kau na Felun Tunmapek, ri fangfang satu ke asa Sakaria ka tapiek. Ma ka kau una palgan Felun Tunmapek ke Kumguui isi ik fasok foron tier ae bau lo i furung rokap. ");
INSERT INTO bjp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma na aunbiing mang una fasok foron tier ae bau lo i furung rokap, gur na fanu ri ka famam sising turim awii na maleh na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ke nenge angelo ke Kumguui ka tapiek sing i, ma ka soti awii isi mia na salan tunmapek ae ri fasok foron tier ae bau lo i furung rokap la. ");
INSERT INTO bjp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aunbiing Sakaria ka par u, ka nananar ma sokeh ka kuruung u. ");
INSERT INTO bjp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Isau le angelo ae ka tara sing i aragii, “Sakaria! Gong o sokeh. God ka ongen ta sising kiam. Elisabet antum, in fang ti kalalik kiam, ke on foteng u ini Jon. ");
INSERT INTO bjp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","On lala laes ke balam in gesges isi, ma fanu fuun rin laes aunbiing in pang, ");
INSERT INTO bjp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","wara le in laumet na mata Kumguui. Biil in umin wain la le umin dan rakrakai. Ma in fuun ini Tanwa Kalkaluu aunbiing biil biitom i pang. ");
INSERT INTO bjp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ma in lame fafis in fuun e fan Israel usuf Kumguui, God kiri. ");
INSERT INTO bjp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","In la famu lo Kumguui, ini matngan tanwa ke rakrakai arae Elaija, ke in sokiliis balan foron tamankak isi rik ier isi berberat kiri, ke ik sokiliis wolwol ken foron tom ongen fabulwar isi rik mi na polo na wol ken foron tom tortores. In tel u arae una fageges fanu isi tapiek ke Kumguui.” ");
INSERT INTO bjp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ke Sakaria ka diik angelo aragii, “Arafa ian usum arae le tier igii in tapiek? Wara le ia ka tubunkak mang ke antung sabin ka wok mang.” ");
INSERT INTO bjp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ke angelo ka kiliis u aragii, “Ia Gabriel. Ia soti la na mata God, ma i wuun iau isi ian fas wo ini rokap na fafas igii. ");
INSERT INTO bjp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ongen u, igii in kut e ngusum ma biil ifasi on orek papang na biing tier igii in suut, wara le biil o unune na foron orek kiak, ae in tapiek na aunbiing tom lo.” ");
INSERT INTO bjp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na aunbiing ae, fanu ri ka nene pane Sakaria, ri ka wol pane le, isi sani ka muduung awii na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aunbiing ka suu fis tina Felun Tunmapek, biil mang ifasi in orek. Ri ka usum ta le i par nenge parpar awii na Felun Tunmapek, wara le i famam fakileng sau ini lima usuf ri, ma ngusu i kut ta tom. ");
INSERT INTO bjp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma aunbiing ka farop foim kia, ka fis una maleh kia. ");
INSERT INTO bjp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nami sau, antu Sakaria, Elisabet, ka tian ma na ilim e funiil biil i suu tina fel. ");
INSERT INTO bjp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ke ka tarah, “Tier igii Kumguui tom i tel u usuf iau. Ia koros tah, ma na foron biing igii, Kumguui ka mais iau ke ka tel ufu matlawen kiak na matan fanu.” ");
INSERT INTO bjp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Na fawon u e funiil ke Elisabet, God ka wuun angelo asa e Gabriel una Nasaret na falifu na Galili. ");
INSERT INTO bjp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ka wuun ufu usuf nenge tah ae biil biitom i borong turan ti kaltu, asa e Maria. Ri fakale ta u isi in telpes nenge kaltu asa e Josep, tina mat ke king Dewit. ");
INSERT INTO bjp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ke angelo ka tapiek sing i, ma ka tarah, “Tinier, on laes. Kumguui i kating kanaka wo ma i kiis turam.” ");
INSERT INTO bjp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aunbiing Maria i ongen foron orek kia, ka lala purngis e bala ma ka wolpane le, sani e kamtina. ");
INSERT INTO bjp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Isau le angelo ka tara sing i aragii, “Maria, gong o sokeh. God i laes kanaka ini wo. ");
INSERT INTO bjp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ongen u. On tian ke ok fang nenge kalalik tamat, ke ok foteng u ini Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Asa in laumet, ma rin foteng u ini kalalik ke God Buuii kanaka na Mawe. Ma Kumguui God in luun u na nian kiiskiis an king ke Dewit tama. ");
INSERT INTO bjp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","In nagogon fitliu na mat ke Jekop ma matanfuntih kia biil in to rop.” ");
INSERT INTO bjp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ka diik angelo ae aragii, “Arafa in tapiek arae e tier igii, wara le biil biitom ia borong ta turan ti kaltu?” ");
INSERT INTO bjp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ke angelo ka kiliis u aragii, “Tanwa Kalkaluu in susuef ulo wo, ke rakrakai ke God Buuii kanaka na Mawe ik kumef o. Ke ier ae on fang u, in kalkaluu ma rin foteng u le Kalalik ke God. ");
INSERT INTO bjp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Par u, sikinting lo wo, Elisabet, ka wok mang. Ri tara la sing i le i koros, isau le igii ka tian mang, ma ka won ta e funiil kia. ");
INSERT INTO bjp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wara le biil ti tier ae God biil ifasi in tel u.” ");
INSERT INTO bjp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ka kiliis u aragii, “Ia fafauun ke Kumguui. I rokap, ik tapiek arae lo iau, arae tom o ka use ta u.” Ke angelo ae ka la koseng u. ");
INSERT INTO bjp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Na aunbiing ae, Maria ka aptih ma ka sangar una nenge maleh na foron pungpung na falifu na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aiwa, ka kau una fel ke Sakaria ma ka faorek pes Elisabet. ");
INSERT INTO bjp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aunbiing Elisabet i ongen Maria i faorek pes u, kalalik ae na bala ka miliu ke Elisabet ka fuun ini Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ke ka perek aragii, “O kalok lon kelefin tikii, ke kalalik sabin ae on fang u i kalok. ");
INSERT INTO bjp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Isau le ia matngan fifin arafa tom ae tina Kumguui kiak ka tapiek sing iau? ");
INSERT INTO bjp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aunbiing sau ia ongen o faorek pes iau, kalalik igii na balang ka miliu ini laes. ");
INSERT INTO bjp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","O kalok, wara o unune le sani Kumguui i use ta u usuf o, in suut.” ");
INSERT INTO bjp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ke Maria ka tarah, “Balang i usefages Kumguui, ");
INSERT INTO bjp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ke tanwang ka laes ini God, Tom Fafaliu kiak, ");
INSERT INTO bjp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","wara i mais iau le, ia nenge fafauun foes sau kia. Tipesu igii, foron ulul tikii rin use u le ia kalok, ");
INSERT INTO bjp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","wara le, God ae i Rakrakai, ka tel ta foron tier laumet usuf iau, ma asa i kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma famais kia i la usuf fanu ae ri bulat la lo, tina foron ulul tinpakanini, una foron ulul ae namih. ");
INSERT INTO bjp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ka tel ta foron rakrakai na foim ini lima: Ka tel sarara ta fanu ae wolwol kiri ifuun ini sinangun got. ");
INSERT INTO bjp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ka fapu ta foron tom nagogon tina foron nian kiiskiis kiri, ma ka falaumet fanu ae ri fapuh ri la tom. ");
INSERT INTO bjp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ka fen ta fanu ae ri fitol ini foron rokap na tier, isau le ka wuun ufu ta fanu ae ifuun e minsik kiri ini pungun limri. ");
INSERT INTO bjp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ka lupes ta Israel, tom foim kia, wara le i wolpes Abaram turan berberat kia fitliu ini famais, arae tom ka use ta u sing foron tubutamat kerer.” ");
INSERT INTO bjp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ka melmel tura Elisabet pes ituul e funiil, ke nami ka fis una maleh kia. ");
INSERT INTO bjp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka aunbiing mang ke Elisabet una fafang, ka fang nenge kalalik tamat. ");
INSERT INTO bjp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fanu ae ri mel fatat u turan foron sikinting lo, ri ka ongen u le Kumguui ka finngas tara famais kia usuf Elisabet, ke ri ka laes turim tura. ");
INSERT INTO bjp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Na fawal u e biing ken kalalik, ri ka geges isi rin kiit pununfo, ke ri ka ier isi fafenngo ini Sakaria, tama. ");
INSERT INTO bjp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Isau le tina ka tarah, “Biil. Rin foteng u ini Jon.” ");
INSERT INTO bjp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ri ka tara sing i aragii, “Biil ti sikinting lo wo i kep ta u e as ae.” ");
INSERT INTO bjp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ke ri ka fapik tama, isi as sa tom i ier le rin luun u lon kalalik. ");
INSERT INTO bjp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria ka tutus isi ti tier in sisiit lo, ke ka siit u le, “Asa e Jon.” Ma fanu tikii ae ri ka lala bitit. ");
INSERT INTO bjp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Fanpil ngusu ka sapeng, kerme ka malmalos, ke ka tipes orek, ma ka usefages God. ");
INSERT INTO bjp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ke fanu tikii ae ri mel fatat ri, ri ka fuun ini sokeh. Ma ususe na foron tier igii ka sarara na foron maleh ae na foron pungpung na falifu na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Fanu tikii ae ri ongen u, ri ka lala wol lo, ma ri ka diik aragii, “Kalalik igii in tapiek matngan kalalik arafah?” Wara le lima Kumguui ae lo. ");
INSERT INTO bjp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tanwa Kalkaluu i susuef ulo Sakaria, tama Jon, ke ka orek profet aragii, ");
INSERT INTO bjp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ususefages usuf Kumguui, God ken fan Israel, wara le ka tapiek ta usuf fanu kia, ma ka fiil fasengsegeng ri. ");
INSERT INTO bjp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ka fapti ta nenge rakrakai na Tom Fafaliu usuf kerer, tina mat ke Dewit, tom foim kia, ");
INSERT INTO bjp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","arae tom i use ta u na ngusun foron profet kalkaluu kia tinpakanini. ");
INSERT INTO bjp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ke in faliu kerer koseng foron tuui kirer, ke tina liman fanu tikii ae ri ememse kerer. ");
INSERT INTO bjp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I tel u arae una finngas famais kia usuf foron tubutamat kerer, ke isi ik fasuut puput kalkaluu kia, ");
INSERT INTO bjp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ae i falimlim ta ini usuf Abaram tubutamat kerer, ");
INSERT INTO bjp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","le in faliu kerer tina liman foron tuui kirer, isi kerek foim sing i ma biil keren sokeh, ");
INSERT INTO bjp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ini sinang ae i kalkaluu ke i tortores na mata na foron biing tikii ae kere liu lo. ");
INSERT INTO bjp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma wo, keng kalalik, rin foteng o le, o profet ke God Buuii kanaka na Mawe, wara le on la famu lo Kumguui, ma ok fageges sal sala, ");
INSERT INTO bjp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","isi famalal fanu kia le God in faliu ri, aunbiing i pa ufu foron sinang laulau kiri, ");
INSERT INTO bjp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","wara na tara famais ke God kirer. Pesu, malal tina kukulii in susupiek ulo kerer, arae pisiih i susupiek na biingbiing. ");
INSERT INTO bjp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","In popos ulon fanu ae ri kiis na kubunor, ke ulon fanu ae malmaluu na minet i afit ri, ke ik lame kerer na sal ae i siaroh.” ");
INSERT INTO bjp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ke kalalik ae ka laulaumet la, ma ka lala rakrakai na tanwa. Ka mel na falifu foes papang na aunbiing ka tapiek malal usuf fan Israel. ");
INSERT INTO bjp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na bet ae, Sisar Augustus ka luun nenge nagogon le, rin kep asan fanu na foron maleh tikii ae ri kiis na piklin matanfuntih na Rom. ");
INSERT INTO bjp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","I e aunbiing famu masau ae ri kep asan fanu lo, aunbiing Kurinius i famfamu na falifu na Siria. ");
INSERT INTO bjp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ke fanu tikii ri ka la una foron waran maleh tutus kiri isi fakau asri. ");
INSERT INTO bjp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ke Josep sabin ka la tina Nasaret na falifu na Galili una Betliem na falifu na Iudaia. Betliem i e maleh ke Dewit, wara le Josep i tina mat ke Dewit. ");
INSERT INTO bjp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I la unaiwa isi fakau asru e Maria, ae ri fakale ta u le in telpes u. Maria i tian, ");
INSERT INTO bjp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ma aunbiing ru tinaiwa na Betliem, ka aunbiing mang kia una fafang. ");
INSERT INTO bjp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ka fang nenge kalalik tamat, i kalalik famu kia. Ka afit u ini foron dangan kaen ma ka faborong u na salan ien ken foron muruuw, wara le biil mang ti salrituul awii na salan foron ses. ");
INSERT INTO bjp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na wor ae, fale tom fofonoi na sipsip ri fofonoi na foron sipsip kiri na topormok fatat maleh ae. ");
INSERT INTO bjp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nenge angelo ke Kumguui ka tapiek sing ri, ma memeh ke Kumguui ka popos kawil ri, ma ri ka lala sokeh. ");
INSERT INTO bjp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Isau le angelo ka tara sing ri aragii, “Gong gam sokeh. Ongen u, ia la usuf gam ini rokap na fafas na tara laes ae in falaes fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Igii sau, na maleh ke Dewit, i pang e Tom Fafaliu kimi, i e Mesaia, Kumguui. ");
INSERT INTO bjp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gamen par matngan fakileng aragii: Gamen tafe nenge mirmiriiu ae ri afit ta u ini foron dangan kaen, ma i borong na salan ien ken foron muruuw.” ");
INSERT INTO bjp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Fanpil nenge tara gur na angelo tina kukulii ri ka puh unaisan angelo ae, ke ri ka usefages God ma ri ka tarah, ");
INSERT INTO bjp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Memeh usuf God buuii na mawe, ke aga na piklinbat, siaroh usuf fanu ae God i laes ini ri.” ");
INSERT INTO bjp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aunbiing foron angelo ri ka la koseng ta ri una kukulii, foron tom fofonoi na sipsip ae, ri ka orek faliu ini ri tom aragii, “Kere mang una Betliem ma kerek par sani ae ka tapiek tah, ae Kumguui i fas ta kerer ini.” ");
INSERT INTO bjp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ke ri ka la sape, ma ri ka tafe Maria ru e Josep turan mirmiriiu ae i borong ta na salan ien ken foron muruuw. ");
INSERT INTO bjp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aunbiing ri ka par ta u, ri ka use orek ae angelo i fas ta ri ini ulon kalalik ae. ");
INSERT INTO bjp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma fanu tikii ae ri ongen orek ken foron tom fofonoi na sipsip, ri ka lala bitit. ");
INSERT INTO bjp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aunbiing Maria ka ongen ta orek igii, ka luun u na bala ma ka lala wol tole u. ");
INSERT INTO bjp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Foron tom fofonoi na sipsip ae ri ka fis, ma ri ka me asa God ke ri ka usefages u isi foron tier ae ri ongen ta u, ke ri ka par ta u arae tom angelo i use ta u. ");
INSERT INTO bjp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na fawal u e biing ken kalalik, i e biing mang una kiit pununfo, ri ka luun asa le Iesu, arae tom angelo i fas ta Maria ini aunbiing biil biitom i tian. ");
INSERT INTO bjp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ka aunbiing mang una fafuu Josep ru e Maria, arae nagogon ke Moses i use u, ke ru ka kaf kalalik ae una Ierusalem isi rik ta u usuf Kumguui. ");
INSERT INTO bjp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wara le nagogon ke Kumguui i use u le, “Foron kalalik tamat famu tikii, rin ta u usuf Kumguui.” ");
INSERT INTO bjp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma ruk ta fafen arae na nagogon ke Kumguui i use u: “Iwu e bun le iwu e fabiro balus.” ");
INSERT INTO bjp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Imel e nenge kaltu na Ierusalem, asa e Simeon. I nenge tom tortores ma i ta tikii liu kia la tom na lotu. I nene la isi fafaliu ken fan Israel ma ifuun ini Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tanwa Kalkaluu i fas ta u le in par Mesaia ke Kumguui ta bii ke nami ik met. ");
INSERT INTO bjp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tanwa Kalkaluu ka lame fakau u una palgan ubiif kale Felun Tunmapek. Maria ru e Josep ru ka kaf fakau kalalik kiruh, Iesu, isi run ta u usuf Kumguui, arae na nagogon i use u. ");
INSERT INTO bjp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ke Simeon ka ofe pes u, ka usefages God ma ka tarah, ");
INSERT INTO bjp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kumguui, ia fafauun kiam, igii on sokufu iau, isi iak la ini siaroh, arae tom o falimlim tah. ");
INSERT INTO bjp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Wara le iwun kolson matang ka par ta fafaliu kiam, ");
INSERT INTO bjp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ae o ka fageges ta u isi fanu tikii rin par u. ");
INSERT INTO bjp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I arae nenge malal una famalal God usuf fanu ae biil ri fan Iudaia, ke arae memeh ken fanu kiam, fan Israel.” ");
INSERT INTO bjp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tama ru e tina ru ka pangang na foron orek ae Simeon i use u ulo Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ke Simeon ka fakalok ruh, ma ka tara sing Maria tina Iesu aragii, “Kalalik igii, God ka tim pes ta u ma wara lo, in fuun e fan Israel rin fiu ke in fuun sabin rin liu, ma in arae fakileng, le fanu fuun rin ta pokta ri ulo, ");
INSERT INTO bjp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","isi wolwol ae i kum na balan fanu fuun, ik tapiek na malmalal. Ma on kalsakai u na liu kiam, arae popok una fapaket ae i rup lo wo.” ");
INSERT INTO bjp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Imel e nenge fifin profet sabin asa e Ana. Tama e Panuel, tina mat ke Aser. Ka wok laulau mang. I kiis sau tura antu na ifit e bet, ");
INSERT INTO bjp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ke nami ka makos. Ma igii, bet kia ka fasi aragii iwal e sangful ini fet e bet. Biil i la koseng Felun Tunmapek la, ma na foron wor ke na foron siat, i lotu mulmul la, ka fafel ke ka sising la. ");
INSERT INTO bjp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na aunbiing ae, ka la unaisa rituul, ka fotrokap usuf God ke ka fafas ini kalalik ae usuf fanu tikii ae ri nene la isi God in fasengsegeng Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aunbiing Josep ru e Maria ru ka tel tikii ta foron tier arae na nagogon ke Kumguui, rituul ka fis una maleh kirituul na Nasaret, na falifu na Galili. ");
INSERT INTO bjp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kalalik ae ka laulaumet la ke ka rakrakai. I fuun ini rokap na wolwol, ma famais ke God i kiis lo. ");
INSERT INTO bjp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na foron bet tikii tama ru e tina Iesu, ru la la una Ierusalem isi Ngasa na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aunbiing i sangful ini u e bet ke Iesu, rituul ka tatkau una Ierusalem isi Ngasa na Liuliu Kulef, arae tom ri tel u la. ");
INSERT INTO bjp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nami na ngasa, aunbiing tama ru e tina ru fisfis la una maleh, biil ru usum le Iesu tinaiwa tom na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ru wol le i la tura ri. Aunbiing ka tikii mang e biing na ninla kiri, ru ka tipes im isi Iesu awii na fatpoton foron sikinting lo rituul ke foron talrituul. ");
INSERT INTO bjp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Aunbiing biil mang ru tafe u, ru ka fis sabin ubae na Ierusalem isi im isi. ");
INSERT INTO bjp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nami na ituul e biing, ru ka tafe u awii na palgan ubiif kale Felun Tunmapek. I kiis ta turan foron tom fafausum, ka ongen ri, ke ka famam diik ri ini foron fagalte. ");
INSERT INTO bjp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Fanu tikii ae ri ongen u, ri ka lala bitit na foron rokap na wolwol kia, ke na foron kilkiliis kia usuf ri. ");
INSERT INTO bjp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aunbiing tama ru e tina ru par u, ru ka lala bitit. Ke tina ka tara sing i aragii, “Keng kalalik, ongen u, kama e tamam kama im ta na foron falifu tikii isi wo, ma i purngis kanaka e balma isi wo. O tel kama arae isi sah?” ");
INSERT INTO bjp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu ka diik ru aragii, “Isi sani kamu ka im isi iau? Arafah, biil kamu usum le, i tortores le ian kiis tom na fel ke Tata?” ");
INSERT INTO bjp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Isau le biil ru malal na sani i fas ru ini. ");
INSERT INTO bjp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Namih, rituul ka fis una Nasaret, ma i wong rokap la tom sing ruh. Ma tina i gong kale foron orek tikii ae i ongen ta u. ");
INSERT INTO bjp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu ka laulaumet la na pununfo ke na tasum kia. Ma God i laes isi, ke fanu sabin ri laes isi. ");
INSERT INTO bjp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na fasangful ini lim e bet aunbiing Sisar Taiberias i nagogon, Pontus Pailat i nagogon na matanfuntih na Iudaia, ke Erot i famfamu na matanfuntih na Galili. Ke Filip tualik e Erot i famfamu na matanfuntih na Iturea ke na Trakonitis, ke Lisanias i famfamu na matanfuntih na Abilene. ");
INSERT INTO bjp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ma Anas ru e Kaiapas ru famfamu ken foron pris. Na bet ae, orek ke God ka tapiek sing Jon, kalalik ke Sakaria, na falifu foes. ");
INSERT INTO bjp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon i la na foron falifu tikii fatat dan na Ioridan, ma ka famam fafas sing ri le rin sokiliis liu kiri ke rik kep bapitaiso, isi God ik pa ufu foron sinang laulau kiri. ");
INSERT INTO bjp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Arae ri siit ta u na buk ke profet Aisaia, “Kinen tikas i tautau na sunbiil aragii: Fageges sal sala Kumguui, fatortores sal sala. ");
INSERT INTO bjp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wof foron palgan dan, kef fapu foron pungpung turan foron tatkau. Foron sal ae i firfirit, fatortores ri. Foron sal ae ri tohtohnen, tumarnge ri. ");
INSERT INTO bjp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma fanu tikii rik par fafaliu ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tara gur na fanu ri ka la usuf Jon isi in baptais ri, isau le ka tara sing ri aragii, “Gam foron natun sii fafangaet. Se i tara le gamen alfe ngaliaf ke God ae in tapiek? ");
INSERT INTO bjp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","In mel e rokap na fua gam, isi ik finngas u le gam ka sokiliis liu tah. Ke gong gam tipes tara sing gam tom le, ‘Abaram i e tama kemem.’ Ia fas gam, God ifasi in sokiliis foron fat igii isi rik tapiek berberat ke Abaram. ");
INSERT INTO bjp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Palnget ae mang ta na baulin foron au, ma foron au tikii ae biil ri fua rokap la, rin pok faluut ri ma rik lin ri una yiif.” ");
INSERT INTO bjp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gur na fanu ae ri ka diik aragii, “Sani mang kemek tel u?” ");
INSERT INTO bjp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ka kiliis ri aragii, “Se iwu e kaen kia, in ta tikas usuf ier ae biil tikas kia, ke se ae imel e inen, in tel u sabin arae.” ");
INSERT INTO bjp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ke fale tom kep takiis sabin ri ka la usuf i isi in baptais ri, ke ri ka diik u aragii, “Tom Fafausum, sani kemen tel u?” ");
INSERT INTO bjp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ke ka kiliis ri aragii, “Gamen kep takiis sau namin nagogon ae ri ka luun ta u. Gong gam kep ti fal sabin na olo, gong.” ");
INSERT INTO bjp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ke fale tom fapaket ri ka diik u aragii, “Ke sani kemen tel u?” Jon ka kiliis ri aragii, “Gong gam fangongos fanu isi rin ta pitkalang usuf gam, ke gong gam tiu foes fanu. Gamen laes sau isi fifiil kimi.” ");
INSERT INTO bjp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Fanu ri nene la isi Mesaia. Aunbiing ri ongen Jon, ri ka wol le, “I mang ngan e Mesaia?” ");
INSERT INTO bjp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon ka kiliis ri aragii, “Ia baptais gam ini dan. Isau le ier ae in mi pes iau, rakrakai kia i liu kulkulef na rakrakai kiak. Pesu, biil ia tortores isi ifasi ian puk ufu finaun su kia. In baptais gam ini Tanwa Kalkaluu ke ini yiif. ");
INSERT INTO bjp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I pose na nenge saol una simke ufu foron piin na wit. Aunbiing ka simke tikii ta u, ke ik luun turim wit rokap na felu. Isau le foron piin, ik fasok u na tara yiif ae biil i to met la.” ");
INSERT INTO bjp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon ka farakrakai ri ini ifuun e orek, ma ka fafas ini rokap na fafas usuf ri. ");
INSERT INTO bjp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Isau le aunbiing ka fakiing Erot, wara le i telpes Erodias antu Filip tualik, ke isi fale sinang laulau sabin ae i tel ta u, ");
INSERT INTO bjp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Erot ka tel nenge tier laulau sabin, aunbiing i luun Jon na felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Aunbiing Jon ka baptais tikii ta fanu, ka baptais Iesu sabin. Ma aunbiing Iesu i sising, kukulii ka sapeng, ");
INSERT INTO bjp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ke Tanwa Kalkaluu ka puh arae nenge bun ulo. Ma kinen tikas ka orek tinbae na kukulii aragii, “O keng Kalalik ae ia ier kanaka isi wo. Ia laes kanaka ini wo.” ");
INSERT INTO bjp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu i tipes tel foim kia aunbiing bet kia ifasi aragii ituul e sangful e bet. Fanu ri wol le i kalalik ke Josep. Josep i e kalalik ke Eli, ");
INSERT INTO bjp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli i e kalalik ke Matat, Matat i e kalalik ke Liwai, Liwai i e kalalik ke Melki, Melki i e kalalik ke Janai, Janai i e kalalik ke Josep, ");
INSERT INTO bjp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep i e kalalik ke Matatias, Matatias i e kalalik ke Amos Amos i e kalalik ke Naum, Naum i e kalalik ke Esli, Esli i e kalalik ke Nagai, ");
INSERT INTO bjp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai i e kalalik ke Mat, Mat i e kalalik ke Matatias, Matatias i e kalalik ke Semein, Semein i e kalalik ke Josek, Josek i e kalalik ke Joda, ");
INSERT INTO bjp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda i e kalalik ke Joanan, Joanan i e kalalik ke Resa, Resa i e kalalik ke Jerubabel, Jerubabel i e kalalik ke Sealtiel, Sealtiel i e kalalik ke Neri ");
INSERT INTO bjp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri i e kalalik ke Melki, Melki i e kalalik ke Adi, Adi i e kalalik ke Kosam, Kosam i e kalalik ke Elmadam, Elmadam i e kalalik ke Er, Er i e kalalik ke Josua, ");
INSERT INTO bjp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josua i e kalalik ke Elieser, Elieser i e kalalik ke Jorim, Jorim i e kalalik ke Matat, Matat i e kalalik ke Liwai, ");
INSERT INTO bjp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai i e kalalik ke Simion, Simion i e kalalik ke Juda, Juda i e kalalik ke Josep, Josep i e kalalik ke Jonam, Jonam i e kalalik ke Eliakim, ");
INSERT INTO bjp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim i e kalalik ke Melea, Melea i e kalalik ke Mena, Mena i e kalalik ke Matata, Matata i e kalalik ke Neitan, Neitan i e kalalik ke Dewit, ");
INSERT INTO bjp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dewit i e kalalik ke Jesi, Jesi i e kalalik ke Obet, Obet i e kalalik ke Buas, Buas i e kalalik ke Salmon, Salmon i e kalalik ke Nason, ");
INSERT INTO bjp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason i e kalalik ke Aminadap, Aminadap i e kalalik ke Admin, Admin i e kalalik ke Arni, Arni i e kalalik ke Esron, Esron i e kalalik ke Peres, Peres i e kalalik ke Juda, ");
INSERT INTO bjp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda i e kalalik ke Jekop, Jekop i e kalalik ke Aisak, Aisak i e kalalik ke Abaram, Abaram i e kalalik ke Tera, Tera i e kalalik ke Naor, ");
INSERT INTO bjp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naor i e kalalik ke Seruk, Seruk i e kalalik ke Reu, Reu i e kalalik ke Pelek, Pelek i e kalalik ke Eber, Eber i e kalalik ke Sela, ");
INSERT INTO bjp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela i e kalalik ke Kainan, Kainan i e kalalik ke Arpakat, Arpakat i e kalalik ke Sem, Sem i e kalalik ke Noa, Noa i e kalalik ke Lamek, ");
INSERT INTO bjp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek i e kalalik ke Metusela, Metusela i e kalalik ke Enok, Enok i e kalalik ke Jaret, Jaret i e kalalik ke Mahalalel, Mahalalel i e kalalik ke Kenan, ");
INSERT INTO bjp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan i e kalalik ke Enos, Enos i e kalalik ke Set, Set i e kalalik ke Adam, Adam i e kalalik ke God. ");
INSERT INTO bjp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu ifuun ini Tanwa Kalkaluu, ma aunbiing ka fis tina dan na Ioridan, Tanwa Kalkaluu ka lame u una sunbiil. ");
INSERT INTO bjp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ka kiis aiwa na ifet e sangful e biing ma Satan ka tof u. Na foron biing ae, Iesu biil i ien ti tier, ke nami ka fitol. ");
INSERT INTO bjp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ke Satan ka tara sing i aragii, “Male o kalalik ke God, ke ok fas fat igii ik tapiek beret.” ");
INSERT INTO bjp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ke Iesu ka kiliis u aragii, “Ri siit ta u ae na Buk na Gogoh aragii, ‘Fanu biil ri liu la na inen sau, biil.’” ");
INSERT INTO bjp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satan ka lame Iesu una nenge falifu ae i buuii kanaka, ma na fatuklin aunbiing sau ka finngas u ini foron matanfuntih tikii na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ke ka fas u aragii, “Ian ta foron rakrakai tikii turan foron memeh na foron matanfuntih igii usuf o, wara le ri ka ta ta u usuf iau ma ifasi ian ta u usuf se sau ae ia ier le ian ta u usuf i. ");
INSERT INTO bjp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pesu, male on lotu unaisang, ke kiam mang e foron tier tikii igii.” ");
INSERT INTO bjp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu ka kiliis u aragii, “Ri siit ta u na Buk na Gogoh aragii, ‘On lotu unaisa Kumguui, God kiam, ma on wong sing i sau.’” ");
INSERT INTO bjp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Namih Satan ka lame u una Ierusalem ma ka fiti u bae na fungan Felun Tunmapek. Ke ka fas u aragii, “Male o kalalik ke God, ke ok wof pu tinaga. ");
INSERT INTO bjp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Wara le ri siit ta u na Buk na Gogoh aragii, ‘God in fas foron angelo kia, isi rin fofonoi rokap lo wo, ");
INSERT INTO bjp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ke rik pose pes wo ini limri, isi biil ifasi on tuke kekem na ti fat.’” ");
INSERT INTO bjp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ka kiliis u aragii, “Ri siit u sabin na Buk na Gogoh le, ‘Gong o luun Kumguui God kiam na fatoftof.’” ");
INSERT INTO bjp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aunbiing Satan ka tof tikii ta u ini foron fatoftof igii, ka la pes ta bii koseng u. ");
INSERT INTO bjp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu ka fis una Galili ini rakrakai ken Tanwa Kalkaluu, ke ususe lo ka sarara na falifu tikii ae. ");
INSERT INTO bjp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ka fausum fanu na foron felun lotu kiri, ma ri tikii ri ka usefages u. ");
INSERT INTO bjp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu ka la una Nasaret, na maleh ae i laumet ta lo. Ma na Biingen Mangeh, ka kau na felun lotu arae tom i tel u la, ke ka soti isi wewes. ");
INSERT INTO bjp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ke ri ka ta buk ke profet Aisaia usuf i. Ka sapeng na buk ae ri finris ta u ma ka par falifu ae ri siit ta u aragii, ");
INSERT INTO bjp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tanwa Kumguui i kiis lo iau, wara le i tom i kale pes ta iau, isi ian fafas ini Rokap na Fafas usuf foron lauu. I wuun ta iau isi ian fafas usuf fanu ae ri kiis na kamkabet, rik sengsegeng, ke foron kut, rik par sabin, ke fanu ae ri kalsakai fangungut, rik sengsegeng. ");
INSERT INTO bjp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ke isi iak fafas ini bet ae Kumguui in finngas famais kia.” ");
INSERT INTO bjp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nami ka finris fafis buk ae, ke ka ta fafis u usuf tom foim ae, ke ka kiis. Ma fanu tikii na felun lotu ae, ri ka kanap fasoksok u, ");
INSERT INTO bjp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ke ka tipes fas ri aragii, “Foron orek ae gam ongen u igii, ka suut mang.” ");
INSERT INTO bjp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma ri tikii ri ka laes isi ma ri ka bitit na foron rokap na orek ae i suu tina ngusu. Ri ka diik aragii, “Be, kaltu igii i e kalalik ke Josep sau?” ");
INSERT INTO bjp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu ka tara sing ri aragii, “Tarama gam ka use orek fatoftof igii ulo iau, ‘Dokta, on faliu fafis wo tom. Foron tier tikii ae keme ongen u o tel ta u na Kapernaum, on tel u sabin aga na maleh tutus kiam.’” ");
INSERT INTO bjp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ke ka fas ri sabin aragii, “Tekentu kanaka ia fas gam, biil ti profet ri somangat pes u la na maleh tutus kia. ");
INSERT INTO bjp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na aunbiing ke profet Elaija, ituul e bet ke iwon e funiil us biil i to luut ke tara fitol ka tapiek na foron maleh tikii ae. I tekentu kanaka tom le, ifuun e makos na Israel, na aunbiing ae. ");
INSERT INTO bjp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isau le God biil i wuun ta Elaija usuf tikas lo ri, biil. I wuun u tom usuf nenge makos tina Sarefat na falifu na Saidon. ");
INSERT INTO bjp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ke ifuun e fanu ae ri sem lepra ri liu na Israel na aunbiing ke profet Elisa. Isau le biil i fafuu tikas lo ri, biil. I fafuu Naman keskes sau, tina Siria.” ");
INSERT INTO bjp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ke fanu tikii ae na felun lotu, ri ka lala ngaliaf, aunbiing ri ongen u. ");
INSERT INTO bjp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ri ka aptih ma ri ka tel ufu Iesu tina maleh kiri. Ri ka dat fatatkau u ubase na pungpung ae ri tel maleh kiri lo, isi rik lin fapu u una dim. ");
INSERT INTO bjp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Isau le Iesu ka la na fatpoton gur na fanu ae, ke ka la koseng ri. ");
INSERT INTO bjp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Namih, Iesu ka pu una Kapernaum na falifu na Galili, ma na Biingen Mangeh, ka fausum fanu. ");
INSERT INTO bjp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ri ka lala bitit na fafausum kia, wara le orek kia imel e rakrakai lo. ");
INSERT INTO bjp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Imel e nenge kaltu aiwa na felun lotu ae tanwa laulau i susuef ulo. Ka perek aragii, ");
INSERT INTO bjp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Uui! Iesu tina Nasaret, sani o ier le on tel u ini kemem? O la isi falaulau kemem? Ia usum le wo e seh. O Kaltu Kalkaluu ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu ka fakiing u aragii, “Babat na ngusum ma ok suu koseng kaltu ae.” Tanwa laulau ae ka faluut kaltu ae una pikli na matri, ka suu koseng u ma biil i falaulau pununfo. ");
INSERT INTO bjp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fanu tikii ri ka bitit ma ri ka fadiik faliu ini ri aragii, “Fafausum arafa igii? Kaltu igii imel e rakrakai kia una nagogon, ke imel sabin e rakrakai kia una fakiing foron tanwa laulau, ke ri ka suuh.” ");
INSERT INTO bjp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma ususe lo ka sararah na foron maleh tikii na falifu ae. ");
INSERT INTO bjp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu ka suu tina felun lotu ma ka la una fel ke Saimon. Tina antu Saimon i lala gogor ma ri ka sising Iesu isi in lupes u. ");
INSERT INTO bjp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu ka ti fatat u, ka fakiing gogor ae ke ka rop koseng u. Fanpil ka aptih ke ka tipes sok inen ari. ");
INSERT INTO bjp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aunbiing pisiih fatat in sup, fanu ri ka filange fanu tikii ae imel e marmarsan sasem lo ri usuf Iesu. Ke ka luun iwun lima na olon temtem tikii lo ri, ma ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ke foron tanwa laulau sabin ri ka suu koseng ifuun e fanu ma ri ka famam perek aragii, “O Kalalik ke God.” Isau le Iesu ka tikale ri isi gong ri orek, wara ri usum le i e Mesaia. ");
INSERT INTO bjp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na biingbiing saksak, Iesu ka la koseng maleh ae una nenge sunbiil. Fanu fuun ri ka famam im isi, ma aunbiing ri tafe u, ri ka totof isi tikale u isi gong i la koseng ri. ");
INSERT INTO bjp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Isau le ka kiliis ri aragii, “Ian fafas ini Rokap na Fafas na matanfuntih ke God na fale maleh sabin, i e wara ae God i wuun ta iau uga.” ");
INSERT INTO bjp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma ka famam fafas tom na foron felun lotu na falifu na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nenge biing, Iesu i sotsoti la na bulin dan kawil na Genesaret, ke fanu fuun ri ka faruru kawil u isi ongen orek ke God. ");
INSERT INTO bjp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka par iwu e mon awii na bulin dan kawil ae foron tom ienmaket ri la koseng ta u ma ri ka gorse foron ubiin kiri. ");
INSERT INTO bjp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu ka wof una neng lon iwun mon ae, neng ke Saimon. Ka fas u isi in mamlik sule ufu mon tina mas. Ke ka kiis lo ma ka tipes fausum fanu. ");
INSERT INTO bjp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aunbiing ka orek tikii tah, ka tara sing Saimon aragii, “Awes sau ubaewa na maut ma ok lin foron ubiin kiam, isi ok kep ti fale kok.” ");
INSERT INTO bjp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ka kiliis u aragii, “Tara Kaltu, keme foim rakrakai nangen na wor kuruur, isau le keme ka puplir. Ma i wara na orek kiam, ke iak lin fapu foron ubiin.” ");
INSERT INTO bjp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aunbiing ri tel u arae, ri ka kep ifuun e kok ma foron ubiin kiri ka tipes tamrabat. ");
INSERT INTO bjp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ke ri ka kalif foron talri ae na nenge mon isi rin la ma rik lupes ri. Ri ka la ma ri ka siing fafuun iwu e mon turim ini kok, ma fatat ruk dom. ");
INSERT INTO bjp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aunbiing Saimon Pita ka par u arae, ka ilepul na mata Iesu ma ka tarah, “Kumguui, la koseng iau. Ia nenge tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","I use u arae, wara le i turan fanu tikii ae ri la tura, ri lala bitit na foron kok ae ri kep u. ");
INSERT INTO bjp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iwun kalalik ke Sebedi, Jems ru e Jon, ru iwun tala Saimon, ru sabin ru ka lala bitit. Ke Iesu ka tara sing Saimon aragii, “Gong o sokeh. Tipesu igii, on dat fanu.” ");
INSERT INTO bjp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aunbiing ri ka famasa ta iwun mon kiri, ri ka la koseng foron tier tikii kiri ke ri ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aunbiing Iesu tinawii na nenge maleh, nenge kaltu ae lepra i kuruung tikii pununfo ka la usuf i. Aunbiing ka par u, ka luut ini posong na mata una nanal ma ka sising u aragii, “Kumguui, male o ier isi, ke ifasi ok fafuu pes iau.” ");
INSERT INTO bjp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu ka sawe lima, ka sigil u ke ka tarah, “Ia ier isi. On fuuh!” Ma fanpil, lepra ka rop koseng u. ");
INSERT INTO bjp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu ka fakiing u aragii, “Gong o fas tikas, isau le on la ma ok finngas pununfom sing pris ke ok ta fafen kiam usuf God, arae Moses i use ta u, isi rik usum le sasem kiam ka rop tah.” ");
INSERT INTO bjp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Isau le ususe lo ka lala sarara mang tom, ma fanu fuun ri ka la turim isi ongen u ke isi ik faliu ri koseng foron sasem kiri. ");
INSERT INTO bjp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Isau le ifuun e aunbiing Iesu i la keskes la una foron sunbiil isi sising. ");
INSERT INTO bjp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nenge biing, aunbiing Iesu i fafausum fanu la, fale Farasi turan fale tom fafausum ini nagogon ae ri la tina foron maleh tikii na falifu na Galili, falifu na Iudaia, ke tina Ierusalem, ri kiis ta aiwa. Ma rakrakai ke Kumguui i kiis lo una faliu foron sasem. ");
INSERT INTO bjp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Fale fanu ri ka tapiek ini nenge peo ae ri kep u ini mii sala. Ri ka totof isi kau ini una fel, isi rik faborong u na mata Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Isau le biil ifasi rin kau ini, wara na gur na fanu. Pesu, ri ka fen ubae na olon fel ke ri ka piit ufu fale olon fel ma ri ka fasiluung u ini mii sala na fatpoton gur na fanu, una famu lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aunbiing Iesu ka par unune kiri, ka tara sing peo ae aragii, “Talang, foron sinang laulau kiam, ia ka pa ufu tah.” ");
INSERT INTO bjp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Foron Farasi turan foron tom fafausum ini nagogon, ka tipes fapaket e wolwol kiri tom aragii, “Matngan kaltu arafa igii, i puris God? Biil ifasi tikas in pa ufu sinang laulau, biil. God keskes sau.” ");
INSERT INTO bjp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu ka usum ta na wolwol kiri, ke ka diik ri aragii, “Isi sani ka mel e matngan wolwol aragii na balmi? ");
INSERT INTO bjp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Orek sa i malmuh? Ian tara le, ‘Ia ka pa ufu ta foron sinang laulau kiam,’ le ian tarah, ‘Aptih ma ok la’? ");
INSERT INTO bjp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ian use u aragii isi gamek usum le Kalalik ken Kaltu imel e rakrakai kia aga na piklinbat una pa ufu foron sinang laulau.” Ke ka tara sing peo ae aragii, “Ia fas o, aptih kep mii salam ma ok la una fel kiam.” ");
INSERT INTO bjp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Fanpil ka soti na matri tikii, ka kep mii sala ke ka la una fel kia. Na ninla kia, ka famam usefages God. ");
INSERT INTO bjp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Fanu tikii ri ka bitit ke ri ka usefages God. Ri ka fuun ini sokeh ma ri ka tarah, “Igii kere ka par ta nenge tier ae i neng keskes na matrer.” ");
INSERT INTO bjp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nami na foron tier igii, Iesu ka la tinaiwa ma ka par nenge tom kep takiis, asa e Liwai. I kiis ta na felun kep takiis. Ke Iesu ka tara sing i aragii, “Mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ka aptih koseng foron tier tikii, ma ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Namih, Liwai ka tel nenge tara inen a Iesu na fel kia. Ifuun e foron tom kep takiis turan fale fanu sabin ri ka ien tura ruh. ");
INSERT INTO bjp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Isau le foron Farasi ke foron tom fafausum ini nagogon ae ri sabin ri foron Farasi, ri ka belbel orek ulon berberat na fafausum ke Iesu aragii, “Isi sani gam ka ien ke yin turim turan foron tom kep takiis ke foron tom tel sinang laulau?” ");
INSERT INTO bjp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu ka kiliis ri aragii, “Fanu ae biil ri sasem, biil ri la la usuf dokta, biil. Fanu sau ae ri sasem, ri la la usuf dokta. ");
INSERT INTO bjp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Biil ia la ta uga isi tawi pes foron tom tortores, biil. Ia la isi tawi foron tom tel sinang laulau, isi rik sokiliis liu kiri.” ");
INSERT INTO bjp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ke ri ka tara sing Iesu aragii, “Berberat na fafausum ke Jon ri fafel la ke ri ka sising la, arae sabin lon berberat na fafausum ken foron Farasi. Isau le berberat na fafausum kiam, ri ien ke ri ka yin la sau.” ");
INSERT INTO bjp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu ka kiliis ri aragii, “Aunbiing kaltu ae i fakekel fuuh i kiis biitom turan foron tala, arafah, ifasi rin fafel? Biil. ");
INSERT INTO bjp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Isau le nenge aunbiing in tapiek ae rin kep ufu kaltu ae i fakekel fuuh koseng ri, ke na foron biing mang ae rik fafel.” ");
INSERT INTO bjp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ke Iesu ka fas ri ini nenge orek fatoftof aragii, “Biil tikas i si ufu nenge dangan kaen la tina kaen fuuh, isi ik sok papte u turan kaen tofe. Male in tel u arae, ke in tel fatamrabat kaen fuuh ae, ke dangan kaen fuuh ae biil in par fasih arae kaen tofe ae. ");
INSERT INTO bjp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ke biil tikas i to wain fuu la una pungun dan tofe ae ri tel u ini punun meme, biil. Male in tel u arae, ke wain fuuh in rabat punun meme tofe, ma wain ik bereng ke punun meme ik laulau. ");
INSERT INTO bjp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Biil ri tel u la arae. Ri to wain fuuh la tom na punun meme fuuh. ");
INSERT INTO bjp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Biil tikas ae ka umin ta wain tofe, in ier sabin isi wain fuuh, biil. In tara le, ‘Wain tofe tom i rokap.’” ");
INSERT INTO bjp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na nenge Biingen Mangeh, Iesu i soleng foron mok na wit. Ke Berberat na fafausum kia ri ka tipes pul fale wit, ri ka gosgos ufu punu ini limri ma ri ka ien u. ");
INSERT INTO bjp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fale Farasi ri ka diik u aragii, “Isi sani gam ka tel matngan sinang ae nagogon i use u le, gong kere tel u na Biingen Mangeh?” ");
INSERT INTO bjp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ke Iesu ka kiliis ri aragii, “Arafah, biil biitom gam wes ususe na sani Dewit i tel ta u, aunbiing i turan fanu ae ri batme u ri fitol? ");
INSERT INTO bjp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewit i kau na fel ke God, ka kep foron beret ae ri ka ta ta u arae fafen usuf God ma ka ien u. Ke ka fen fanu sabin ae ri batme u ini fal. Na nagogon, foron pris sau ifasi rin ien u.” ");
INSERT INTO bjp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ke Iesu ka tara sing ri aragii, “Kalalik ken Kaltu i e Kumguui na Biingen Mangeh.” ");
INSERT INTO bjp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nenge Biingen Mangeh sabin, Iesu ka kau una felun lotu ke ka fausum fanu. Ma nenge kaltu aiwa, i met e lima ae na mia. ");
INSERT INTO bjp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Foron Farasi turan foron tom fafausum ini nagogon ri ka famam im sal una tiu Iesu, ke ri ka lala luun matri lo isi rik par u le in faliu kaltu ae na Biingen Mangeh, le biil. ");
INSERT INTO bjp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Isau le Iesu ka usum ta na wolwol kiri, ke ka tara sing kaltu ae i met e lima aragii, “Aptih, ma ok soti na matan fanu tikii.” Ka aptih, ma ka soti na matri. ");
INSERT INTO bjp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ke Iesu ka tarah, “Ian diik gam, sani nagogon kirer i mangte u le keren tel u na Biingen Mangeh? Keren tel rokap na sinang le keren tel sinang laulau, keren fafaliu le keren sisiimete?” ");
INSERT INTO bjp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu ka par usuf ri tikii ke ka tara sing kaltu ae aragii, “Sawe limam.” Kaltu ae ka sawe u, ke lima ka rokap fis. ");
INSERT INTO bjp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Isau le ka kut laulau e balri ma ri ka tipes ngurke orek ae na fatpoto ri tom le sani rin tel u ini Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nenge biing, Iesu ka tatkau una nenge pungpung isi sising. Ma na wor kuruur ae i sising usuf God. ");
INSERT INTO bjp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Na biingbiing, ka kam berberat na fafausum kia ke ka tim pes nenge sangful ini u lo ri, ma ka foteng ri ini foron aposel. ");
INSERT INTO bjp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Igii e asri: Saimon ae Iesu ka foteng u ini Pita, ru latualik e Enru, Jems, Jon, Filip, Batolomiu, ");
INSERT INTO bjp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metiu, Tomas, Jems kalalik ke Alfius, Saimon ae i nenge Silot, ");
INSERT INTO bjp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudas kalalik ke Jems, ke Iudas Iskariot ae in ta ufu Iesu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aunbiing Iesu turan berberat na fafausum ri ka filaupu tina pungpung ma ka soti na nenge malanbu, nenge tara gur na berberat na fafausum kia tinaiwa. Ma fanu fuun tina falifu tikii na Iudaia, tina Ierusalem ke tina baban kiin na Tair ke Saidon, ri sabin tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ri la ta isi ongen u ke isi ik faliu ri koseng foron sasem kiri. Ma fanu sabin ae foron tanwa laulau ri fatel ta ri, ri ka rokap fis. ");
INSERT INTO bjp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fanu tikii ri ka totof isi sigil u, wara le rakrakai i la tin lo ma ka faliu ri tikii. ");
INSERT INTO bjp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu ka par berberat na fafausum kia, ke ka tara sing ri aragii, “Gam ae gam lauu, gam kalok, wara le kimi e matanfuntih ke God. ");
INSERT INTO bjp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gam ae gam fitol igii, gam kalok, wara le namih, gamen mas. Gam ae gam teng igii, gam kalok, wara le namih, gamen yong. ");
INSERT INTO bjp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gam kalok aunbiing fanu ri ememse gam, aunbiing ri wes ufu gam, aunbiing ri nes gam, ke aunbiing ri use falaulau asmi, i wara lon Kalalik ken Kaltu. ");
INSERT INTO bjp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Aunbiing rin tel foron tier igii ulo gam, gamen gesges ma gamek sirok ini laes, wara le i laumet kanaka e fifiil kimi buuii na kukulii. Wara le foron tubutamat ri, ri tel ta u sabin arae ulon foron profet. ");
INSERT INTO bjp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Isau le kiskam sing gam ae ifuun e minsik kimi, gam ka kep tikii ta rokap kimi. ");
INSERT INTO bjp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kiskam sing gam ae gam mas igii, nami gamen fitol. Kiskam sing gam ae gam yong igii, nami gamen mamais ke gamek teng. ");
INSERT INTO bjp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kiskam sing gam aunbiing fanu tikii ri usefages gam, wara le foron tubutamat ri, ri tel ta u sabin arae ulon foron profet famfabal. ");
INSERT INTO bjp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Isau le ia fas gam ae gam ongen iau: Gamen ier isi foron tuui kimi ke gamek tel rokap na sinang usuf fanse ae ri ememse gam. ");
INSERT INTO bjp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gamen fakalok fanse ae ri bo gam, ke gamek sising isi fanse ae ri falaulau gam. ");
INSERT INTO bjp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Male tikas i pose nenge peum, tamikis isi ik pose nenge baba sabin. Ke male tikas i kep dolon kaen kiam, gong o rut kolos kiam sabin. ");
INSERT INTO bjp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Male tikas i sising o isi ti tier, ke on ta u usuf i. Ke male tikas i kep ta ti tier sing o, gong sabin o sising fafis u. ");
INSERT INTO bjp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Foron sinang ae gam ier isi fanu rin tel u ulo gam, gamen tel u ulo ri. ");
INSERT INTO bjp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Male gam ier la sau isi fanse ae ri ier isi gam, ke arafa rin usefages gam arae? Wara le foron tom tel sinang laulau sabin ri ier la isi fanu ae ri ier isi ri. ");
INSERT INTO bjp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ke male gam tel sinang rokap la sau usuf fanse ae ri tel sinang rokap la usuf gam, ke rin usefages gam arafah? Wara le foron tom tel sinang laulau sabin, ri tel u la arae. ");
INSERT INTO bjp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Male gam ta tuka usuf fanse sau ae gam usum le rin kiliis fafis u tom usuf gam, ke rin usefages gam arafah? Wara le foron tom tel sinang laulau sabin, ri ta tuka la usuf foron tom tel sinang laulau, wara ri usum le rin kiliis tikii u tom. ");
INSERT INTO bjp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Isau le gamen ier isi foron tuui kimi ke gamek tel sinang rokap usuf ri. Male tikas i kep ta ti tuka sing gam, gong gam lala ier isi in kiliis fafis u. Male gamen tel u arae, ke fifiil kimi in lala laumet ke gam berberat ke God buuii na Mawe. Wara le i tel sinang rokap la usuf fanu ae biil ri fotrokap la ke usuf fanu laulau sabin. ");
INSERT INTO bjp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Gamen famais la, arae Tama gam, i tom famais. ");
INSERT INTO bjp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gong gam nagogon tikas, tarama God ka nagogon gam. Gong gam tiu tikas isi God gong i tiu gam. Gamen wol ufu foron sinang laulau ae ri tel u ulo gam, isi God ik pa ufu foron sinang laulau kimi. ");
INSERT INTO bjp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gamen fafen, ke God ik fen gam. Isau le fafen ke God usuf gam in laumet kanaka, rin gulgule u, rin suguur fapu u ma ik fuun basbasah ke gamek berau pes u. Wara le matngan fafen arafa gam ta u, tara tier le fabiro, God in ta u sabin arae usuf gam.” ");
INSERT INTO bjp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ke Iesu ka fas ri sabin ini nenge orek fatoftof aragii, “Ifasi le nenge kut in lame nenge kut sabin? Arafah, biil run luut turim una ti toh? ");
INSERT INTO bjp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nenge kalalik na fafausum biil i laumet lon tom fafausum kia. Isau le aunbiing ka farop tikii ta foron fafausum kia, ke ik tapiek mang arae tom fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Isi sani o ka par fabiro piin ae na kolson mata tuamlik, ma biil o wol na kiptin au ae na kolson matam tom? ");
INSERT INTO bjp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Male biil o par kiptin au ae na kolson matam, ke isi sani o ka tara sing tuamlik le, ‘Tuaklik, ian tel ufu piin ae na kolson matam’? O tom gargaranmet. On tel ufu kiptin au ta bii ae na kolson matam ke aunbiing o ka par rokap mang, ke ok tel ufu fabiro piin mang ae na kolson mata tuamlik. ");
INSERT INTO bjp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Nenge rokap na au, biil i luun fuan au laulau la, ke nenge au laulau biil i luun fuan au rokap la, biil. ");
INSERT INTO bjp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Temtem tikii na au rin iliim u tom tina fua. Fanu biil ri lus fuan fik la tina finau ae imel e si, biil. Ke biil sabin ri lus fuan wain la tina au ae i moseng, biil. ");
INSERT INTO bjp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Rokap na kaltu i finngas rokap na sinang la tina foron rokap na tier ae na liu kia. Ke kaltu laulau sabin i finngas sinang laulau la tina foron tier laulau ae na liu kia. Wara le orek ae i suu tina ngusun nenge kaltu, i famalal sinang ae ifuun na liu kia. ");
INSERT INTO bjp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Isi sani gam ka foteng iau le, ‘Kumguui, Kumguui,’ ma biil gam tel sani ae ia use u? ");
INSERT INTO bjp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ier ae i la usuf iau ma ka ongen pes foron orek kiak ma ka misuut lo, i arae ier igii ian fas gam ini. ");
INSERT INTO bjp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I arae nenge kaltu ae i tel fel. I lala kekef tom ma ka fiti foron tuh na olon fatkiis. Aunbiing nor i tapiek ma dan ka pipiis na fel ae, biil ifasi in nut, wara le i tel fakasi u tom. ");
INSERT INTO bjp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Isau le, ier ae i ongen orek kiak ma biil i misuut lo, i arae nenge kaltu ae i fiti fel sau na olon nanal ma biil i kekef met ta ini foron tuh. Aunbiing nor i pipiis na fel ae, ka masuuf ke ka tamrabat sikit.” ");
INSERT INTO bjp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aunbiing Iesu ka use ta foron orek tikii igii na wongwong ken fanu, ka la una Kapernaum. ");
INSERT INTO bjp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nenge kabisit ken nenge mar e tom fapaket tina Rom i kiis la aiwa. Nenge fafauun kia i sasem ma fatat in met. Fafauun ae, laulaumet kia i ier kanaka la isi. ");
INSERT INTO bjp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Aunbiing kabisit ae ka ongen ususe lo Iesu, ka wuun ufu fale famfamu ken fan Iudaia usuf i, isi sising u isi in la ma ik faliu fafauun kia. ");
INSERT INTO bjp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aunbiing ri ka tapiek sing Iesu, ri ka lala piispiis u aragii, “Kaltu igii, i nenge rokap na kaltu ma ifasi on lupes u, ");
INSERT INTO bjp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","wara le i ier isi fanu kirer, ke ka tel ta felun lotu kimem.” ");
INSERT INTO bjp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ke Iesu ka la tura ri. Aunbiing ri ka la fatat fel, kabisit ae ka wuun fale tala usuf Iesu ini orek aragii, “Kumguui, fatel o. Biil ia to kaltu rokap isi ok kau una fel kiak. ");
INSERT INTO bjp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ke biil sabin ifasi ian la unaisam. Isau le, on orek sau ke fafauun kiak ik liu. ");
INSERT INTO bjp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ia use u arae, wara le ia kiis sau na piklin nagogon ken fale fanu, ke fale tom fapaket sabin ri kiis na piklin nagogon kiak. Ia wuun nenge tom fapaket ke ka la. Ke ia ka kam u ke ka la usuf iau. Ke ia ka fas nenge fafauun kiak le, ‘Tel tier igii,’ ke ka tel u.” ");
INSERT INTO bjp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aunbiing Iesu ka ongen u arae, ka bitit ke ka giliim usuf fanu ae ri mimi la lo ke ka tara sing ri aragii, “Ia fas gam, biil biitom ia tafe ti sikin Israel, unune kia i laumet aragii.” ");
INSERT INTO bjp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ke fanu ae kabisit i wuun ta ri, ri ka fis una fel ke ri ka par u le fafauun ae ka liu tah. ");
INSERT INTO bjp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Biil i sawin, ke Iesu ka la una nenge maleh asa e Nain. Berberat na fafausum kia turan nenge tara gur na fanu sabin ri ka la turim tura. ");
INSERT INTO bjp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aunbiing ka la fatat matan ubiif kawil maleh ae, ka par fanu ri kep fasuu nenge minet. Minet ae, tina i makos, ma i keskes sau i kalalik kia. Ma ifuun e fanu tina maleh ae ri batme u. ");
INSERT INTO bjp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aunbiing Kumguui ka par makos ae, ka purngis e bala isi ke ka fas u aragii, “Gong o teng.” ");
INSERT INTO bjp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ka la fatat, ka sigil luuf ae ri kep minet lo, ke fanu ae ri kep u ri ka sotih. Ke Iesu ka tarah, “Guam, ia fas o, aptih!” ");
INSERT INTO bjp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Guam ae i met ta ka kiis ke ka tipes orek. Ke Iesu ka ta fafis u usuf tina. ");
INSERT INTO bjp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sokeh ka kuruung tikii fanu ae ke ri ka usefages God ma ri ka tarah, “Nenge tara profet ka tapiek ta na fatpoto kerer. God ka tapiek ta isi lupes fanu kia.” ");
INSERT INTO bjp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ususe igii lo Iesu ka sarara na falifu tikii na Iudaia ke na fale falifu fatat sabin. ");
INSERT INTO bjp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Berberat na fafausum ke Jon ri ka fas u ini foron ususe tikii lo Iesu. Ke Jon ka tawi pes iwu lo ri, ");
INSERT INTO bjp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka wuun ru usuf Kumguui, isi ruk diik u aragii, “Arafah, wo mang e ier ae le in tapiek, le kemen nene biitom isi tikas aiwa?” ");
INSERT INTO bjp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aunbiing ru ka tapiek sing Iesu, ru ka tarah, “Jon Tom tel Bapitaiso i wuun ta kama usuf o isi kaman diik wo le, ‘Arafah, wo mang e ier ae le in tapiek, le kemen nene biitom isi tikas aiwa?’” ");
INSERT INTO bjp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na aunbiing ae, Iesu i faliu ifuun e fanu ae ri sem marmarsan tier na pununfo ri, fanu ae ri sasem, fanu ae foron tanwa laulau ri susuef lo ri ke ka sapeng na matan ifuun e kut. ");
INSERT INTO bjp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ke Iesu ka kiliis ru aragii, “Kamu fis ma kamuk fas Jon ini foron sani kamu ongen u ke kamu ka par ta u: Foron kut ri ka par, foron peo ri ka la, fanu ae ri sem lepra ri ka tapiek fuuh, fanu ae i kutkut e balbalu ri, ri ka wong, foron minet ri ka liu fis ke foron lauu ri ka ongen Rokap na Fafas. ");
INSERT INTO bjp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","I kalok e ier ae unune kia lo iau biil i luut.” ");
INSERT INTO bjp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aunbiing iun kalalik na fafausum ke Jon ru ka la tah, Iesu ka fas gur na fanu ae ini Jon aragii, “Sani gam la isi par u, aunbiing gam la ta usuf Jon na falifu foes? Awii gam la sau isi alim nenge aun ngan ae kif i kufe u? Biil. ");
INSERT INTO bjp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ke sani gam la ta isi par u? Nenge kaltu ae i ges ta ini foron rokap na kilkiliis? Biil. Gam par u, fanse ae ri ges ini foron kilkiliis ae i fen e matri ma ri kiis pikpiik, ri kiis la na foron fel ken foron king. ");
INSERT INTO bjp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma sani gam la ta isi par u? Nenge profet? Iuu. Ia fas gam, Jon i laumet lon foron profet tikii. ");
INSERT INTO bjp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ri siit ta u na Buk na Gogoh ulo aragii, ‘Ian wuun famu tom fafas kiak lo wo, ae in fageges sal salam.’ ");
INSERT INTO bjp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ia fas gam, Jon i laumet kanaka lo fanu tikii ae ri fang ta ri, isau le se i fabiro kanaka na matanfuntih ke God, i laumet tom lo Jon.” ");
INSERT INTO bjp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Fanu tikii, ke foron tom kep takiis sabin, aunbiing ri ongen foron orek ke Iesu, ri ka somangat le sinangu God i tortores, wara le Jon i baptais ta ri. ");
INSERT INTO bjp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Isau le foron Farasi turan foron tom tasum na nagogon ri ire sal ke God usuf ri, pesu biil ri kep ta bapitaiso sing Jon. ");
INSERT INTO bjp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ke Iesu ka tara sabin sing ri aragii, “Sani ian fatof ulul igii ini? Ri matngan fanu arafah? ");
INSERT INTO bjp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri arae berberat ae ri kiis na salan la turim ken fanu ma ri ka tautau usuf fale berberat sabin aragii: ‘Aunbiing kemem kuf tulal usuf gam, ke biil gam guui ke aunbiing kemem sek nenge seksek an mamais ke biil gam teng.’ ");
INSERT INTO bjp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wara le Jon Tom tel Bapitaiso i la, biil i ien beret la ke biil i umin wain la, ke gam ka tara le, ‘Imel e tanwa laulau lo.’ ");
INSERT INTO bjp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kalalik ken Kaltu i la, ka ien ke ka yin, ke gam ka tara le, ‘Gam par u, kaltu igii i nenge tom kiimkiim ke nenge tom ininmet, ma i nenge talan foron tom kep takiis turan foron tom tel sinang laulau.’ ");
INSERT INTO bjp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Isau le foim ke God i finngas u tom le i polo na wol tekentu.” ");
INSERT INTO bjp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Neng lon foron Farasi ka sising Iesu isi in ien tura. Ke Iesu ka kau una fel ken Farasi ae ma ka kep sala na luuf isi ien. ");
INSERT INTO bjp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ke nenge fifin tina maleh ae, i nenge tom tel sinang laulau. Aunbiing i usum le Iesu i ien na fel ken Farasi ae, ka kau una fel ini nenge sanda, ae pungu ri tel u ini fat ae ri foteng u ini alabasta. ");
INSERT INTO bjp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ke ka soti awii na pokta Iesu, fatat isi karkeke. Ka teng ke danun mata ka ring una iun keke Iesu, ka salis fasengseng u ini olo, ka dor u ke ka fore sanda lo. ");
INSERT INTO bjp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aunbiing Farasi ae i sising ta Iesu una fel kia ka par u, ka tara sing i tom aragii, “Male kaltu igii i nenge profet, ke in usum le se i sigil u, i matngan fifin arafah, wara le fifin ae i nenge tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu ka tara sing i aragii, “Saimon, ia ier isi ian fas o ini nenge tier.” Ke ka kiliis u aragii, “Tom Fafausum, fas iau.” ");
INSERT INTO bjp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu ka tara sing i aragii, “Iwu e kaltu ru kep ta pitkalang sing nenge kaltu. Neng lo ru i kep ta ilim e mar e dinaria, ke neng i kep ta ilim e sangful e dinaria. ");
INSERT INTO bjp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Biil mang ifasi run kiliis fafis tuka kiruh wara le biil ti pitkalang sing ruh. Ke kaltu ae ka tara sing ruh aragii, ‘Taftawa, igii gong mang kamu kiliis foron tuka kimuh.’ Se lo ru in ier kanaka isi kaltu ae ru kep ta pitkalang sing i?” ");
INSERT INTO bjp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ka kiliis u aragii, “Ia wol le ier ae i kep ta tara pitkalang sing i.” Ke Iesu ka tara sing i aragii, “Orek kiam i tortores.” ");
INSERT INTO bjp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesu ka giliim usuf fifin ae ke ka tara sing Saimon aragii, “Par fifin igii. Aunbiing ia kau una fel kiam, biil o ta ti dan usuf iau isi iak gorse iun kekeng ini. Isau le fifin igii, ka gorse ta iun kekeng ini danun mata, ke ka salis fasengseng u ini olo. ");
INSERT INTO bjp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Biil o dor ta iau, isau le fifin igii i dor iun kekeng, tipes u tom na aunbiing ia kau uga. ");
INSERT INTO bjp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Biil o luun ta wel na paklung, isau le fifin igii ka fore ta sanda na iun kekeng. ");
INSERT INTO bjp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pesu, ia fas o, famais kia usuf iau, i finngas u le ifuun e sinang laulau kia, God ka pa ufu tah. Isau le, se ae God i pa ufu fabiro sinang laulau kia, famais kia i fabiro sau.” ");
INSERT INTO bjp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ke Iesu ka tara sing fifin ae aragii, “Foron sinang laulau kiam ka pah tah.” ");
INSERT INTO bjp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Fale ses sabin ae ri kiis turim na inen ae, ri ka tipes orek sing ri tom aragii, “Kaltu arafa igii, ifasi sabin in pa ufu foron sinang laulau?” ");
INSERT INTO bjp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ke Iesu ka tara sing fifin ae aragii, “Unune kiam tom ka faliu ta wo. La ini siaroh.” ");
INSERT INTO bjp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nami na foron tier igii, Iesu ka la tikii na piran maleh ke na birbiron maleh sabin, ma ka fafas ini Rokap na Fafas na matanfuntih ke God. Ma sangful ini u e kalalik na fafausum kia ri ka batme u, ");
INSERT INTO bjp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","turan fale kelefin sabin ae Iesu i fes ufu ta tanwa laulau lon fal, ke fal i faliu ta ri koseng foron sasem kiri. Igii e asan kelefin ae: Maria ae ri foteng u ini fafnan Makdalin, ae ifit e tanwa laulau ri suu koseng ta u, ");
INSERT INTO bjp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ke Joana antu Kusa, famfamu na fel ke Erot, ke Susana ma ifuun biitom. Kelefin igii ri lupes Iesu la turan berberat na fafausum kia tina foron minmara ri tom. ");
INSERT INTO bjp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Aunbiing tara gur na fanu tina foron maleh ae, ri taptapiek turim la unaisa Iesu, ka fas ri ini orek fatoftof igii: ");
INSERT INTO bjp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nenge tom soso i la isi saprai kutun wit kia. Aunbiing i sapsaprai, fal ka luut tole sal ke fanu ri ka fefes lo, ke foron man ri ka ting tikii u. ");
INSERT INTO bjp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fal ka luut na olon fatfat, ma aunbiing ri kuum, ri ka mang, wara le nanal i sengseng. ");
INSERT INTO bjp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fale kutun wit ka luut na palgan foron finau ae imel e si. Ke finau ae ka kuum turim turan wit ma ka kuruung foron wit ae. ");
INSERT INTO bjp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Isau le fale kutun wit ka luut na nanal rokap. Ka kuum ke ka fua. Temtem tikii na au na wit i fua ifasi aragii nenge mar e fua.” Aunbiing ka use ta u arae, ka perek aragii, “Se imel e balbalu, i rokap le in wong ini.” ");
INSERT INTO bjp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ke berberat na fafausum kia ri ka diik u isi kamtinan orek fatoftof ae. ");
INSERT INTO bjp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka fas ri aragii, “God i ta ta tasum usuf gam isi gamen usum na foron tier ae i kum na matanfuntih kia. Isau le usuf fale fanu, ian fausum ri ini foron orek fatoftof isi, ‘Taftawa ri par, isau le biil rin par failiim ti tier, ri wong, isau le biil rin malal.’ ");
INSERT INTO bjp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Kamtinan orek fatoftof ae, i aragii: Kutun wit i e orek ke God. ");
INSERT INTO bjp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Foron kutun wit ae ri luut tole sal, i arae fanu ae ri ongen orek, ke Satan ka tapiek ma ka tel ufu orek ae tina balri, isi biil rin unune ke biil rin kep liu. ");
INSERT INTO bjp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Foron kutun wit ae ri luut na olon fatfat, i arae fanu ae ri ongen orek ke ri ka somangat pes u ini laes. Isau le biil ri ti dolo, arae wit ae bauli biil i laumet. Na aunbiing fatoftof i tapiek, ri ka luut. ");
INSERT INTO bjp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Foron kutun wit ae ri luut na palgan foron finau ae imel e si, i arae fanu ae ri ongen orek, isau le aunbiing ri la, foron mamais, foron minsik ke foron laes foes tina liu igii, ka kuruung ri ma fua ri biil biitom i matuk ke ka us. ");
INSERT INTO bjp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Isau le kutun wit ae i luut na rokap na nanal, i arae fanu ae ri ongen orek ke ri ka pose papte u ini tortores ma ini rokap na balri, papang na aunbiing ri ka fua. ");
INSERT INTO bjp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Biil tikas i fasok lam la ke ka luun u la na piklin paket, le na piklin luuf, biil. I luun u la tom na sala, isi fanu ae ri kau rik par malal lo. ");
INSERT INTO bjp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wara le foron tier tikii ae ri kiis mumun tah, rin kiis na malmalal. Ke foron tier tikii ae i kum tah, nami fanu rin usum lo ma ik tapiek na malmalal. ");
INSERT INTO bjp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pesu, gamen wolwol rokap, arafa gam ongen orek la arae. Wara le se ae ka mel ta sing i, rin ta tifal biitom sing i. Isau le se ae biil ti tier sing i, fabiro ae i wol le imel sing i, rin tel ufu koseng u.” ");
INSERT INTO bjp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tina Iesu turan foron tualik ri ka tapiek isi par Iesu, isau le biil ifasi rin la fatat, wara na tara gur na fanu. ");
INSERT INTO bjp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nenge kaltu ka fas Iesu aragii, “Tinam turan foron tuamlik ae na maleh ma ri ier isi par o.” ");
INSERT INTO bjp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesu ka kiliis u aragii, “Tinang ke foron tuaklik e fanse ae ri ongen orek ke God ma ri ka mi lo.” ");
INSERT INTO bjp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nenge biing Iesu ka fas berberat na fafausum kia aragii, “Kere mang una nenge baban dan kawil.” Ri ka wof na nenge mon ke ri ka la. ");
INSERT INTO bjp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Aunbiing ri la, Iesu ka borong. Ke nenge tara kif ka apti awii na dan kawil, ke mon ae ka siing tes ma fatat rik fiu. ");
INSERT INTO bjp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ke berberat na fafausum ri ka la usuf i, ri ka famat u ke ri ka tarah, “Tara Kaltu, Tara Kaltu! Kerek dom!” Iesu ka aptih, ka fakiing kif turan piran panaf, ke ka rop ma ka siaroh e falifuh. ");
INSERT INTO bjp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ke ka tara sing berberat na fafausum kia aragii, “Fiawa e unune kimi?” Ri ka bitit ke ri ka fadiik faliu ini ri tom ini sokeh aragii, “Matngan kaltu arafa igii? I fakiing kif turan panaf ke ru ka wong sing i.” ");
INSERT INTO bjp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu turan berberat na fafausum kia ri sopaket dan kawil na Galili ta tina falifu na Galili, ma ri ka masa na nanal ken fan Gerasa. ");
INSERT INTO bjp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aunbiing Iesu ka pu tina mon, nenge kaltu tina maleh ae ka tafe u, ae tanwa laulau i susuef lo. Dolon aunbiing biil i luun kaen la ke biil i kiis la na ti fel, i kiis la sau na foron matanfat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aunbiing i par pes Iesu, ka ngangeh ke ka luut uf na famu lo Iesu. Ke ka perek aragii, “Iesu Kalalik ke God Buuii kanaka na mawe, sani on tel u ini iau? Ia sising wo le gong o ta fangungut sing iau!” ");
INSERT INTO bjp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I use u arae, wara le Iesu ka fakiing ta tanwa laulau ae isi in suu koseng kaltu ae. Ifuun e aunbiing tanwa laulau i fatel u la. Fanu ri lose u la, rik kabet iun lima ke iun keke ini sen, isau le i tiifamut u la, ke tanwa laulau ae ka fatel u la isi in fin una foron kiptin biil. ");
INSERT INTO bjp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ke Iesu ka diik u aragii, “Se asam?” Ka kiliis u aragii, “Asang e Legion.” Wara le ifuun e tanwa laulau ri susuef ta ulo. ");
INSERT INTO bjp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ri ka piispiis Iesu le gong i wuun ufu ri una tara turuung ae biil ti farfarop lo. ");
INSERT INTO bjp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nenge tara uh na boh ri suupsuup la na baban nenge pungpung fatat. Ke foron tanwa laulau ae, ri ka sising Iesu isi rin susuef ulon foron boh ae. Ke Iesu ka somangat ufu ri. ");
INSERT INTO bjp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Foron tanwa laulau ri ka suu koseng kaltu ae ke ri ka susuef una foron boh. Foron boh ae, ri ka fasasai pu na nenge bolonfam una dan kawil ke ri ka kong. ");
INSERT INTO bjp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aunbiing foron tom fofonoi na boh ri par sani ae i tapiek tah, ri ka fin ma ri ka ususe na tara maleh ke na birbiron maleh sabin. ");
INSERT INTO bjp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ke fanu ri ka la ma ri ka par sani ae i tapiek tah. Aunbiing ri ka tapiek sing Iesu, ri ka par kaltu ae foron tanwa laulau ri suu koseng ta u, i kiis ta fatat iun keke Iesu, ini kaen na pununfo ma wolwol kia ka malal mang. Ke ri ka lala sokeh. ");
INSERT INTO bjp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Fanse ae ri par ta sani i tapiek tah, ri ka fas fanu arafa Iesu i faliu kaltu ae tanwa laulau i susuef ta ulo. ");
INSERT INTO bjp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ke fanu tikii na falifu na Gerasa, ri ka sising Iesu isi in la koseng ri, wara le tara sokeh i kuruung ri. Ke Iesu ka wof na mon ma ka la. ");
INSERT INTO bjp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kaltu ae tanwa laulau i suu koseng ta u, ka piispiis Iesu isi in la tura. Isau le Iesu ka wuun ufu ma ka fas u aragii, ");
INSERT INTO bjp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Fis una fel kiam ma ok fafas ini tier laumet ae God ka tel ta u lo wo.” Ke kaltu ae ka la ma ka fafas ini sani ae Iesu i tel ta u ulo na maleh tikii ae. ");
INSERT INTO bjp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Aunbiing Iesu ka fis, nenge tara gur na fanu ri ka laes isi, wara le ri tikii ri famam nene u. ");
INSERT INTO bjp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ke nenge kaltu asa e Jairus, i nenge famfamu tina felun lotu, ka la ma ka ilepul na mata Iesu. Ma ka sising u le in la una fel kia, ");
INSERT INTO bjp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wara le keleflik kia fatat in met. Itikii tutus sau e keleflik kia ma i sangful ini u e bet kia. Aunbiing Iesu ka la una fel ke Jairus, tara gur na fanu ri ka fasisit kawil u. ");
INSERT INTO bjp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nenge fifin aiwa i sem dah na sangful ini u e bet, ma biil ifasi tikas in faliu u. ");
INSERT INTO bjp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka la tina mi Iesu, ka sigil sun kaen kia ma fanpil ka mas e dah. ");
INSERT INTO bjp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu ka diik aragii, “Se i sigil iau?” Aunbiing ri tikii ri ka fakawe, Pita ka tarah, “Tara Kaltu, tara gur na fanu ri kawil o ma ri ka sit o.” ");
INSERT INTO bjp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Isau le Iesu ka tarah, “Tikas tom i sigil iau. Ia usum le rakrakai i suu koseng iau.” ");
INSERT INTO bjp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Fifin ae i usum le biil ifasi in mumun, ka nananar ma ka ilepul na mata Iesu. Ma na matan fanu tikii, ka fas u isi sani ka sigil u ke ka fas u sabin le fanpil ka liu. ");
INSERT INTO bjp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ke Iesu ka tara sing i aragii, “Lik, unune kiam tom i faliu wo. La ini siaroh.” ");
INSERT INTO bjp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aunbiing Iesu i ororek la biitom, nenge kaltu ka la tina fel ke Jairus, famfamu tina felun lotu, ke ka tarah, “Kem keleflik ka met tah. Gong mang o fatel Tom Fafausum.” ");
INSERT INTO bjp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aunbiing Iesu ka ongen u arae, ka tara sing Jairus aragii, “Gong o sokeh. Unune sau, ke ik liu.” ");
INSERT INTO bjp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Aunbiing Iesu ka tapiek na fel ke Jairus, biil i ier isi tikas in kau tura. Pita, Jon ke Jems sau, tura tama ru e tinan keleflik ae. ");
INSERT INTO bjp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma fanu tikii ri famam luluen ke ri ka tingis u. Ke Iesu ka tara sing ri aragii, “Gong gam teng! Keleflik ae biil i to met, i masun sau.” ");
INSERT INTO bjp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri ka yongne u, wara ri usum le ka met tah. ");
INSERT INTO bjp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Isau le ka pose na lima ke ka tara sing i aragii, “Lik, aptih.” ");
INSERT INTO bjp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ke tanwa ka fis ulo, ma fanpil ka sotih. Ke Iesu ka fas ri isi rin fen u ini ti inen. ");
INSERT INTO bjp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tama ru e tina ru ka lala bitit, isau le Iesu ka tikale ru isi gong ru fas tikas ini sani ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aunbiing Iesu ka tawi turim ta sangful ini u e kalalik na fafausum kia, ka ta rakrakai usuf ri una nagogon na olon foron tanwa laulau tikii ke una faliu fanu koseng foron sasem. ");
INSERT INTO bjp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ke ka wuun ufu ri isi rin fafas ini matanfuntih ke God ke isi faliu foron sasem. ");
INSERT INTO bjp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I fas ri aragii, “Gong gam kep ti tier na ninla kimi: Gong gam kep ti buk una la, ti sara, ti inen, ti pitkalang le ti kilkiliis kimi, gong. ");
INSERT INTO bjp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Fel sa ae gam la ma gam ka kiis lo, gamen kiis tom aiwa, papang na aunbiing gamen kang koseng maleh ae. ");
INSERT INTO bjp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Male fanu biil ri somangat pes gam, ke aunbiing gam kang koseng maleh kiri, gamen paket ufu piyiif tina kekmi isi ik arae fakileng usuf ri le ri kiis na piklin ngaliaf ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ke berberat na fafausum ri ka la una foron maleh tikii, ri ka famam fafas ini Rokap na Fafas ma ri ka famam faliu fanu na foron falifu tikii. ");
INSERT INTO bjp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erot, famfamu na matanfuntih na Galili, ka ongen foron tier ae i taptapiek la ke ka wolpane, wara le fale fanu ri use u le Jon Tom tel Bapitaiso ka liu fis sabin. ");
INSERT INTO bjp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Fal ri tara le Elaija ka tapiek fis, ke fal sabin ri ka tara le nenge profet tinpakanini ka liu fis. ");
INSERT INTO bjp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Isau le Erot ka tarah, “Ia ka bus ufu ta paklu Jon, ma se sabin igii ia ka ongen foron ususe lo?” Ke ka ier le in par Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aunbiing foron aposel ri ka fis, ri ka fas Iesu ini foron tier tikii ri tel ta u. Ka telpes ri ke ri keskes ri ka la tura una nenge maleh ae ri foteng u ini Betsaida. ");
INSERT INTO bjp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Isau le gur na fanu ri ka usum ke ri ka mi lo. Ka somangat pes ri ke ka fas ri ini matanfuntih ke God ma ka faliu fanu ae ri sasem. ");
INSERT INTO bjp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka efef laulau mang, ke sangful ini u e aposel ri ka la usuf i ma ri ka fas u aragii, “Wuun ufu fanu mang una foron maleh ke una foron fel fatat isi rik im inen ke falifu una borong, wara le kiptin biil sau igii.” ");
INSERT INTO bjp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu ka kiliis ri aragii, “Gam fen ri ini ti inen.” Ke ri ka kiliis u aragii, “Ilim sau e beret turan iwu e kok igii sing kemem. Kol, o ier le kemen la ma kemek fiil ti inen an gur na fanu igii?” ");
INSERT INTO bjp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wewes lon fanu tamat aiwa, ifasi aragii ilim e arip. Ke Iesu ka fas berberat na fafausum kia aragii, “Fakiis ri na foron uh. Nenge uh in fasih aragii ilim e sangful e kaltu.” ");
INSERT INTO bjp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Berberat na fafausum ri ka tel u tom arae, ma fanu tikii ri ka kiis. ");
INSERT INTO bjp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ke Iesu ka kep ilim e beret turan iwu e kok ae, ka tar una kukulii, ka fotrokap lo ke ka sibik foron beret ae. Namih, ka ta u usuf berberat na fafausum kia isi rin tulus fanu ini. ");
INSERT INTO bjp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ri tikii ri ien ma ri ka mas. Namih, berberat na fafausum kia ri ka siing fafuun sangful ini u e kes ini foron tigan inen ae ri mas tiga. ");
INSERT INTO bjp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nenge biing, aunbiing Iesu keskes i famam sising ma berberat na fafausum kia tinaiwa naisa, ka diik ri aragii, “Fanu ri tara le iau e seh?” ");
INSERT INTO bjp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ke ri ka kiliis u aragii, “Fal ri tara le wo Jon Tom tel Bapitaiso, fal ri ka tara le wo Elaija ke fal sabin ri tara le wo neng lon foron profet tinpakanini ae ka liu fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ke Iesu ka diik ri sabin aragii, “Arafa lo gam, gam tara le iau e seh?” Pita ka kiliis u aragii, “O Mesaia ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ke, Iesu ka fakiing ri isi gong ri fas tikas ini. ");
INSERT INTO bjp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ke Iesu ka fas ri sabin aragii, “Kalalik ken Kaltu in kalsakai in fuun e tatawin tom, ma foron famfamu, foron laulaumet na pris turan foron tom fafausum ini nagogon rin ta pokta ri ulo. Fanu rin siimete u, ma na fatuul u e biing, ik apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ke ka fas ri tikii aragii, “Male tikas i ier le in mi lo iau, in wol ufu tom ma ik kusep aupaket kia na foron biing tikii ke ik mi lo iau. ");
INSERT INTO bjp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Wara le se i gong kale liu kia, liu kia in mangmangal koseng u. Isau le se i sok ufu liu kia wara lo iau, in liu. ");
INSERT INTO bjp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Male tikas i kep tikii foron tier tina piklinbat, isau le liu kia ka mangmangal koseng u ma ka laulau, ke foron tier ae in farokap u arafah? ");
INSERT INTO bjp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Male tikas i matlawen isi fapos iau ke foron orek kiak, Kalalik ken Kaltu sabin in matlawen lo aunbiing in tapiek ini memeh kia ke memeh ke Tama turan foron angelo kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tekentu kanaka ia fas gam, fal lo gam igii gam ti la, biil biitom rin met ke rik par matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iwal e biing kale orek igii, Iesu ka lame pes Pita, Jon ke Jems ma rifet ka tatkau na nenge pungpung isi sising. ");
INSERT INTO bjp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aunbiing i sisising la, posong na mata ka par neng keskes ma kilkiliis kia ka kilangkilang arae pil. ");
INSERT INTO bjp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ke iwu e kaltu ru ka tipiek, Moses ru e Elaija, ke ru ka orek tura. ");
INSERT INTO bjp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ru tapiek ini tara memeh ma rituul ka ororek isi minet ke Iesu ae fatat in fasuut u na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita rituul masun. Aunbiing rituul ka mat, rituul ka par memeh ke Iesu turan iwu e kaltu ae ru soti ta tura. ");
INSERT INTO bjp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aunbiing iwun kaltu ae ru ka ier isi la koseng Iesu, Pita ka fas u aragii, “Tara Kaltu, i rokap le kere mang agawa. Kemtuulen tel in tuul e palpalbuang, neng kiam, neng ke Moses ke neng ke Elaija.” Pita biil i usum na sani i use u. ");
INSERT INTO bjp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aunbiing Pita i ororek la, nenge laukaf ka tapiek ke ka afit ri. Ma Pita rituul ka sokeh aunbiing laukaf i afit ri. ");
INSERT INTO bjp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma kinen tikas ka orek tina laukaf aragii, “Igii e keng Kalalik ae ia ka tim pes ta u. Gamen wong sing i.” ");
INSERT INTO bjp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aunbiing kinen tikas ae ka orek tikii tah, ri ka par Iesu keskes mang tinaiwa. Ma na aunbiing ae, tuul kalalik na fafausum biil rituul fas tikas ini sani ae rituul par ta u. ");
INSERT INTO bjp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na biing namih, aunbiing Iesu turan tuul kalalik na fafausum kia rifet puh tinbae na pungpung, nenge tara gur na fanu ri ka tafe u. ");
INSERT INTO bjp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nenge kaltu tinaiwa na palgan gur na fanu ae, ka tautau aragii, “Tom fafausum, ia sising o le on par keng kalalik, wara le i sau itikii e kalalik kiak. ");
INSERT INTO bjp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nenge tanwa laulau i susuef la ulo, ma kalalik ae ka ngangeh tuktuk la. I gokgok la ma busbus ka suu la tina ngusu. Tanwa laulau ae biil i suaf dolo u la, i falaulau u la tom. ");
INSERT INTO bjp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ia sising ta berberat na fafausum kiam isi rin tel ufu, isau le biil ri fasih.” ");
INSERT INTO bjp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu ka tarah, “Kiskam, fanu na ulul igii, gam foron tabun unune ma gam ka la ger tah. Ia ka kiis dolo ta tura gam ma nangis mang gamek unune? Tangne kem kalalik uga.” ");
INSERT INTO bjp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aunbiing kalalik ae ka la usuf Iesu, tanwa laulau ae ka luu ini una nanal ke ka gokgok. Iesu ka balkut ufu tanwa laulau ae ke ka suu koseng kalalik ae. Kalalik ae ka liu, ke Iesu ka ta fafis u usuf tama. ");
INSERT INTO bjp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Fanu tikii ri ka bitit na tara rakrakai ke God. Aunbiing fanu tikii ri wolwol la biitom tole foron tier tikii ae Iesu i fatapiek ta u, ka fas berberat na fafausum kia aragii, ");
INSERT INTO bjp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Gam ongen fakasi sani igii ian fas gam ini: Rin ta ufu Kalalik ken Kaltu una liman fanu.” ");
INSERT INTO bjp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Isau le biil ri malal na kamtinan orek igii. I mumun lo ri, pesu biil ri kep u. Ri ka binbin isi rin diik u isi. ");
INSERT INTO bjp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Berberat na fafausum ri ka tipes fakep ini orek na fatpoto ri le se lo ri i laumet. ");
INSERT INTO bjp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu i usum na wolwol kiri, pesu ka tangne pes nenge fabiro kalalik ke ka fasoti u na baba. ");
INSERT INTO bjp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ke ka tara sing ri aragii, “Male tikas i somangat pes fabiro kalalik igii na asang, i somangat pes iau sabin. Ke male tikas i somangat pes iau, i somangat pes ier sabin ae i wuun ta iau. Wara le se i fabiro lo gam tikii, i laumet kanaka.” ");
INSERT INTO bjp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon ka fas Iesu aragii, “Tara Kaltu, keme par nenge kaltu i tel ufu tanwa laulau ini asam, ke keme ka ier isi tikale u, wara le biil i neng lo kerer.” ");
INSERT INTO bjp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ke Iesu ka tarah, “Gong gam tikale u, wara le se biil i tikale gam, i neng lo gam.” ");
INSERT INTO bjp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka fatat mang e aunbiing ke Iesu isi God ik telpes u ubase na kukulii, pesu ka rakrakai e wolwol kia isi tatkau una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka wuun famu fale tom fafas, ke ri ka la una nenge maleh na Samaria isi rik fageges foron tier nene u. ");
INSERT INTO bjp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Isau le fanu aiwa biil ri somangat pes u, wara le in la una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aunbiing iun kalalik na fafausum kia, Jems ru e Jon ru ka par u arae, ru ka diik u aragii, “Kumguui, o ier le kaman tawi fapu yiif tina kukulii isi ik fasok ri tikii?” ");
INSERT INTO bjp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Isau le Iesu ka giliim usuf ru ma ka fakiing ruh. ");
INSERT INTO bjp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ke ri ka la una nenge maleh sabin. ");
INSERT INTO bjp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Aunbiing ri toltole sal la, nenge kaltu ka tara sing Iesu aragii, “Ian mi lo wo una foron falifu tikii on la ulo.” ");
INSERT INTO bjp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu ka kiliis u aragii, “Foron puul aka imel e solsol salri, ke foron man tina mua imel e polpolo ri, isau le Kalalik ken Kaltu biil ti falifu sala una borong.” ");
INSERT INTO bjp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ke ka fas nenge kaltu sabin aragii, “Mi lo iau.” Isau le kaltu ae ka kiliis u aragii, “Kumguui, somangat ufu iau ta bii isi iak la ma iak ile tata.” ");
INSERT INTO bjp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu ka fas u aragii, “Sokufu foron minet rik ile foron minet kiri tom, isau le wo, la ma ok fafas ini matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nenge kaltu biitom ka fas u aragii, “Kumguui, ian mi lo wo, isau le somangat ufu iau ta bii isi iak fis ma iak faorek ting ta fanu na fel kiak.” ");
INSERT INTO bjp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu ka kiliis u aragii, “Biil ti kaltu i giliim fis la una mih aunbiing i purak. Male in tel u arae, ke biil ifasi in tel foim na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Namih, Kumguui ka tim pes ifit e sangful ini u sabin e kalalik na fafausum ke ka wuun famu ri. I wuun tem u tem u lo ri una piran maleh ke una birbiron maleh tikii, ae i sabin in la ulo. ");
INSERT INTO bjp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ke ka fas ri aragii, “Ifuun kanaka e inen una ilfafua, isau le ituul sau e tom foim. Pesu, gamen sising usuf Kumguui na ilfafua, isi ik wuun ufu ti fal biitom e tom foim una mok kia. ");
INSERT INTO bjp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gam la. Ongen u, ia wuun ufu gam arae birbiron sipsip na fatpoton foron puul ngalngaliaf. ");
INSERT INTO bjp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gong gam kep ti pauus una siing pitkalang, ti sara le su. Ke gong sabin gam faorek pes tikas ae gam tafe u tole sal. ");
INSERT INTO bjp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Aunbiing gam kau na ti fel, famu gamen fas ri aragii, ‘Siaroh usuf gam.’ ");
INSERT INTO bjp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Male ti kaltu aiwa ifuun ini siaroh, ke siaroh kimi in kiis lo. Male biil, ke siaroh kimi in fis tom usuf gam. ");
INSERT INTO bjp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gamen melmel tom aiwa na fel ae, gamen ien ke gamek umin sani ae ri ta u usuf gam, wara le nenge tom foim i tortores tom le in kep fifiil kia. Gong gam weswes fel na borong. ");
INSERT INTO bjp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Aunbiing gam tapiek na ti maleh ma ri ka somangat pes gam, sani ae ri fen gam ini, ien u sau. ");
INSERT INTO bjp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","“Gam faliu foron sasem aiwa ke gamek fas ri le, matanfuntih ke God ka fatat ta isi ri. ");
INSERT INTO bjp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ke male gam tapiek na ti maleh ma biil ri somangat pes gam, gamen la una foron sunsun sal na maleh ae ke gamek fas ri aragii, ");
INSERT INTO bjp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Piyiif tina maleh kimi igii na kekmem, kemem tuke ufu isi ik arae fakileng usuf gam le gam kiis na palgan ngaliaf ke God. Ma gamen usum le matanfuntih ke God ka fatat.’ ");
INSERT INTO bjp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ia fas gam, na biingen nagogon, tatawin ae God in ta u usuf fan Sodom in lilibiit na tatawin ae in tapiek lon fanu na maleh ae. ");
INSERT INTO bjp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kiskam sing gam fan Korasin! Kiskam sabin sing gam fan Betsaida! Male rin fatapiek ta foron tier an fabitit igii ae ri fatapiek u usuf gam, usuf fan Tair ke fan Saidon, ke rik sokiliis ta liu kiri pakanini tom. Rik kilkiliis ini foron kaen na mamais ke rik saba ini piyiif. ");
INSERT INTO bjp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na biingen nagogon, tatawin ae God in ta u usuf fan Tair ke fan Saidon in lilibiit na tatawin ae God in ta u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma gam fan Kapernaum, gam wol le rin sik gam ubae na bat? Biil tom. Rin fapu gam ubuif sikit na Edes, salan foron minet. ");
INSERT INTO bjp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Se i ongen pes orek kimi, i ongen pes orek kiak. Se i ire gam, i ire iau. Ma se i ire iau, i ire ier sabin ae i wuun ta iau.” ");
INSERT INTO bjp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ke ifit e sangful ini u e kalalik na fafausum ae ri ka fis ini laes ma ri ka fas Iesu aragii, “Kumguui, foron tanwa laulau sabin ri wong sing kemem, aunbiing keme fes ufu ri ini asam.” ");
INSERT INTO bjp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ke Iesu ka kiliis ri aragii, “Ia par Satan i luut tinbae na kukulii arae pil. ");
INSERT INTO bjp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ia ka ta ta rakrakai usuf gam isi gamen fefes na foron sii ke na foron makal ke isi gamek fapu rakrakai ken tuui kimi ma biil ti tier in falaulau gam. ");
INSERT INTO bjp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Isau le, gong gam laes wara le foron tanwa laulau ri wong sing gam. Gamen laes, wara le ri ka siit ta asmi buuii na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na aunbiing ae, Iesu ka fuun ini laes sing Tanwa Kalkaluu ke ka tarah, “Tata, o Kumguui na kukulii ke na piklinbat tikii. Ia usefages o wara le o fun ta foron tier igii sing foron tom tasum ke sing ri ae ri usum na marmarsan tier, ma o ka finngas u usuf fanu ae ri arae birbiron berberat. Iuu, Tata, o tel u arae wara o ier tom isi arae. ");
INSERT INTO bjp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tata ka unune ufu ta foron tier tikii usuf iau. Biil tikas i usum lon Kalalik, Tama keskes sau. Ke biil tikas i usum lo Tama, Kalalik keskes sau turan fanse ae Kalalik ka tim pes ta ri isi in famalal Tama usuf ri.” ");
INSERT INTO bjp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aunbiing Iesu keskes sau turan berberat na fafausum kia tinaiwa, ka giliim usuf ri ke ka fas ri aragii, “Gam kalok wara le gam par foron tier igii ini kolson matmi. ");
INSERT INTO bjp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ia fas gam, ifuun e profet turan foron king ri ier kanaka ta isi rin par sani gam par u, isau le biil ri par u. Ke ri ier kanaka ta isi rin ongen sani gam ongen u, isau le biil ri ongen u.” ");
INSERT INTO bjp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nenge biing, nenge tom tasum na nagogon ka soti ke ka tof Iesu ini nenge fagalte aragii, “Tom Fafausum, sani ian tel u isi iak kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ke Iesu ka kiliis u aragii, “Sani i use u e nagogon? Aunbiing o wes u, o wol arafah?” ");
INSERT INTO bjp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kaltu ae ka kiliis u aragii, “‘On ier isi Kumguui, God kiam ini balam tikii, ini tanwam tikii, ini rakrakai tikii kiam ke ini wolwol tikii kiam,’ ke ‘On ier isi ier ae na fatat o, arae o ier isi wo tom.’” ");
INSERT INTO bjp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu ka tarah, “Orek kiam i tortores. On tel u arae ke ok liu.” ");
INSERT INTO bjp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Isau le tom tasum na nagogon ae ka ier isi finngas u le i tortores na mata Iesu, pesu ka diik u aragii, “Ier ae na fatat iau, i seh?” ");
INSERT INTO bjp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu ka kiliis u ini orek fatoftof igii, “Nenge kaltu i filaupu tina Ierusalem una Jeriko. Ma na ninla kia, fale tom suksukuum ri ka lose u. Ri ka kasis ufu kilkiliis kia, ri ka paket u ma ka met pelpel, ke ri ka fin koseng u. ");
INSERT INTO bjp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nenge pris i pu sabin lo e sal ae ma aunbiing i par u, ka alfe u ke ka la. ");
INSERT INTO bjp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ke nenge Liwai sabin arae. Aunbiing i tapiek na falifu ae, ka par u ke ka alfe u sabin. ");
INSERT INTO bjp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Isau le nenge sikin Samaria, na ninla kia ka tapiek na aisan kaltu ae. Aunbiing ka par u, ka purngis e bala isi. ");
INSERT INTO bjp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ka la unaisa, ka to wel turan wain na pununfo ae i dahdahnen ke ka mapmap lo. Ka sik u una dongki kia ke ka luun u na nenge felun ses ma ka fofonoi lo aiwa. ");
INSERT INTO bjp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na biing namih, ka kep iwu e dinaria ke ka ta u usuf tom parpar kale na fel ae ma ka fas u aragii, ‘Fofonoi bii lo. Male ti tier sabin ae on lupes u ini, aunbiing ian fis ke iak kiliis fafis u usuf o.’ ");
INSERT INTO bjp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“O wol arafah, se lo rituul i finngas u le kaltu ae foron tom suksukuum ri paket ta u, ae na fatat u?” ");
INSERT INTO bjp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tom tasum na nagogon ka kiliis u aragii, “Kaltu ae i mais u.” Ke Iesu ka fas u aragii, “La ma ok tel u sabin arae.” ");
INSERT INTO bjp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aunbiing Iesu turan berberat na fafausum kia ri toltole sal la, ri ka tapiek na nenge maleh. Aiwa, nenge fifin asa e Mata ka somangat pes Iesu una fel kia. ");
INSERT INTO bjp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nenge kisilik asa e Maria, i kiis fatat keke Kumguui ke ka ongongen orek la kia. ");
INSERT INTO bjp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Isau le Mata i lala wol na foron tier ae in fageges u biitom, pesu ka la ke ka fas Iesu aragii, “Kumguui, biil o wol lo iau? Kisiklik i la koseng iau ma iau keskes sau ia ka tel foron foim tikii. Fas u bii uga isi ik lupes iau.” ");
INSERT INTO bjp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Isau le Kumguui ka kiliis u aragii, “Mata, Mata! I purngis kanaka e balam ma o ka lala wol isi ifuun e tier. ");
INSERT INTO bjp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Itikii sau e tier i laumet. Maria ka tus pes ta sani ae i rokap kanaka, ae biil ifasi rin kep ufu sing i.” ");
INSERT INTO bjp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nenge biing Iesu i famam sising na nenge falifuh. Aunbiing ka sising tikii tah, nenge kalalik na fafausum kia ka tara sing i aragii, “Kumguui, fausum kemem ini sising, arae Jon Tom tel Bapitaiso i fausum ta berberat na fafausum kia.” ");
INSERT INTO bjp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ke Iesu ka fas ri aragii, “Aunbiing gam sising, gamen tara aragii, Tata, keme bulat na asam ae i kalkaluu, keme ier isi matanfuntih kiam in tapiek aga. ");
INSERT INTO bjp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Fen kemem ini inen una temtem tikii na biing. ");
INSERT INTO bjp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pa ufu foron sinang laulau kimem, arae kemem sabin keme ka wol ufu ta foron sinang laulau ae fal ri tel ta u ulo kemem. Lame ufu kemem koseng foron fatoftof.” ");
INSERT INTO bjp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Namih, Iesu ka fas ri aragii, “Male tikas lo gam i la usuf tala na fapot ke ka sising aragii, ‘Talang, ta in tuul bii e beret uga, ");
INSERT INTO bjp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","wara le nenge talang i la na nenge ninla ke ka tapiek naisang ma biil ti beret una fen u.’ ");
INSERT INTO bjp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ke tala ae na fel ka kiliis u aragii, ‘Gong o famfabos iau! Ka babat ta e matanfel ma iau turan berberat kiak kemem ka borong tah. Biil ifasi ian suu isi iak ta ti tier usuf o, biil.’ ");
INSERT INTO bjp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ia fas gam, kaltu ae na fel kia, biil in suu isi ik fen kaltu ae ini ti inen, wara sau le i rokap na tala, biil. In suu ma ik fen u ini sani i ier isi, wara le tala biil i to matlawen ke biil i mangeh na sising. ");
INSERT INTO bjp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Pesu ia ka fas gam, gamen sising ke gamek kep u. Gamen im ke gamek tafe u. Gamen pispisih ke matanfel ik sapeng isi gam. ");
INSERT INTO bjp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wara le fanu tikii ae ri sising, rin kep sani ae ri sising isi, ma se i im, in im tafe sani ae i im isi, ke se i pispisih, matanfel in sapeng isi. ");
INSERT INTO bjp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Se lo gam foron tamankak, male ke kalalik i sising u isi ti kok, ke ik fen u bin ini ti sii? ");
INSERT INTO bjp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ke male i sising u isi ti katluunto ke ik fen u ini ti makal? ");
INSERT INTO bjp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Taftawa le gam tel sinang laulau la, isau le gam usum tom na ta foron rokap na fafen usuf berberat kimi. Pesu, gamen usum tom le, Tama gam buuii na kukulii, in ta Tanwa Kalkaluu usuf fanu ae ri sising u.” ");
INSERT INTO bjp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu i tel ufu nenge tanwa laulau ae biil i orek la lon nenge kaltu. Aunbiing tanwa laulau ae ka suu ke kaltu ae ka orek mang, ma gur na fanu ae ri ka bitit. ");
INSERT INTO bjp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Isau le fal lo ri, ri ka tarah, “Iesu i tel ufu foron tanwa laulau la ini rakrakai ke Belsebul, i e laulaumet ken foron tanwa laulau.” ");
INSERT INTO bjp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Fale fanu sabin ri ier isi tof u ke ri ka fas u isi in finngas ri ini ti fakileng tinbae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Isau le ka usum ta na wolwol kiri ke ka tarah, “Male fanu na nenge matanfuntih ri tampaek ma ri ka fapaket fis tom ini ri, ke matanfuntih ae in laulau sikit. Male fanu tina nenge matanfel ri tampaek ma ri ka fapaket fis tom ini ri, ke biil mang rin kiis turim sabin. ");
INSERT INTO bjp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Male fanu ke Satan ri tampaek ma ri ka fapaket fis tom ini ri, ke matanfuntih kia in rakrakai arafah? Ia use u arae, wara le gam tara le ia tel ufu foron tanwa laulau la ini rakrakai ke Belsebul. ");
INSERT INTO bjp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ke, male ia tel ufu tanwa laulau la ini rakrakai ke Belsebul, ke fanu kimi ri tel ufu foron tanwa laulau la ini rakrakai kiseh? Ri tom rin nagogon fafis gam. ");
INSERT INTO bjp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Isau male ia tel ufu foron tanwa laulau ini rakrakai ke God, ke gamen usum le matanfuntih ke God ka tapiek ta usuf gam. ");
INSERT INTO bjp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Male nenge rakrakai na kaltu i ges ini foron tier tikii una fapaket ma ka parpar kale fel kia, ke minmara in kiis rokap. ");
INSERT INTO bjp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Isau male tikas ae i rakrakai kanaka lo ka tapiek, ka fapaket tura ma ka paket u ke, in tel ufu foron tier tikii una fapaket ae kaltu ae i luun unune kia lo ma ik tem sarara minmaran kaltu ae. ");
INSERT INTO bjp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Se biil i ti turang, i tuui kiak, ma se biil i lupes iau na tel turim fanu, i fes sarara ri la. ");
INSERT INTO bjp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Aunbiing nenge tanwa laulau i suu koseng nenge kaltu, ik la una foron falifu sengseng isi ik im isi ti falifu una mangeh. Ma aunbiing biil i tafe ti falifuh, ik tarah, ‘Ian fis tom una fel ae ia la koseng ta u.’ ");
INSERT INTO bjp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma aunbiing in tapiek, ik par u le fel ae, ri ka sa fakasi ta u ma ri ka tumarnge ta u. ");
INSERT INTO bjp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ke ik la ma ik telpes in fit sabin e tanwa laulau ae ri laulau kanaka mang tom lo. Ri tikii rik kau na fel ae ke rik mel aiwa. Pesu, liu ken kaltu ae ik laulau kanaka mang tom na liu famu kia.” ");
INSERT INTO bjp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu i ororek la biitom ke nenge fifin tinawii na palgan gur na fanu ae ka perek aragii, “I kalok e fifin ae i fang ta wo ma ka fasus ta wo.” ");
INSERT INTO bjp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Isau le Iesu ka kiliis u aragii, “Fanu ae ri ongen orek ke God ma ri ka misuut lo, ri kalok kanaka.” ");
INSERT INTO bjp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aunbiing gur na fanu ri ka fuunfuun la kale Iesu, ka fas ri aragii, “Fanu na ulul igii, ri fanu laulau, ri ier le rin par ti fakileng, isau le biil ti fakileng in tapiek usuf ri, fakileng sau ke profet Jona. ");
INSERT INTO bjp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona i arae fakileng usuf fan Niniwe, ke Kalalik ken Kaltu sabin in arae fakileng usuf fanu na ulul igii. ");
INSERT INTO bjp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na biingen nagogon, kuin tina Seba in tih ma ik pot matan fanu na ulul igii, wara le i la tom tina tapak isi ongen tasum ke king Solomon. Ongen u, igii sau e ier ae i laumet kanaka lo king Solomon. ");
INSERT INTO bjp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na biingen nagogon, fan Niniwe rin tih ma rik pot matan fanu na ulul igii, wara le ri kiliis ta liu kiri sau na fafas ke profet Jona. Ongen u, igii sau e ier ae i laumet kanaka lo Jona. ");
INSERT INTO bjp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Biil tikas i fasok lam la ke ka fun u la, le ka luun u la na piklin paket, biil. I luun u la tom na sala, isi fanu ae ri kau rik par malal lo. ");
INSERT INTO bjp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kolson matam i e malal na pununfom. Male iun kolson matam i rokap, ke pununfom tikii in fuun ini malal. Isau male iun kolson matam i laulau, ke pununfom tikii sabin in fuun ini kubunor. ");
INSERT INTO bjp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pesu, on tumarang, tarama malal ae na pununfom ka kubunor. ");
INSERT INTO bjp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Male pununfom tikii ifuun ini malal ma biil ti baba i kubunor, ke in popos kanaka arae lam ae malal lo i popos ulo wo.” ");
INSERT INTO bjp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aunbiing Iesu ka orek tikii tah, nenge Farasi ka sising pes u una fel kia isi rin ien turim. Ka kau ke ka kep sala na luuf una ien. ");
INSERT INTO bjp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Isau le Farasi ae ka bitit, aunbiing i par Iesu biil i sofolim famu ta bii isi ik ien. ");
INSERT INTO bjp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Isau le Kumguui ka tara sing i aragii, “Gam foron Farasi, gam gorse poktan kap la ke pelet, isau le balmi ifuun ini sinangun akalemok ke foron sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gam foron talos! Arafah, biil gam usum le ier ae i tel ta poktan foron tier, i tel ta palga sabin? ");
INSERT INTO bjp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Isau le gamen fen foron lauu ini foron tier ae na palgan pelet isi foron tier tikii ik fuu usuf gam. ");
INSERT INTO bjp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kiskam sing gam foron Farasi. Gam ta itikii la e aunawau tina nenge sangful e aun birbiron au, arae aun ianian, rikrik le fale matngan bi sabin, isau le biil gam misuut na foron nagogon ae i laumet, arae sinangun nagogon ae i fafasi usuf fanu tikii ke biil gam ier isi God. In rokap le gamen ta in tikii tina nenge sangful usuf God, isau le gong gam ruruu na foron nagogon ae i laumet. ");
INSERT INTO bjp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kiskam sing gam foron Farasi, wara le gam ier la isi foron nian kiiskiis kausi na foron felun lotu. Ke gam ier la tom le fanu rin faorek pes gam ini bulat na foron salan la turim ken fanu. ");
INSERT INTO bjp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kiskam sing gam, wara le gam arae foron matmat ae biil ti fakileng lo, ae fanu ri la la na olo ma biil ri usum lo.” ");
INSERT INTO bjp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ke nenge tom tasum na nagogon ka tara sing Iesu aragii, “Tom fafausum, aunbiing o use u arae, o use falaulau kemem sabin.” ");
INSERT INTO bjp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu ka kiliis u aragii, “Kiskam sing gam foron tom tasum na nagogon, wara le gam fakuskusep fanu la ini piran kiip tatawin ae i ngangaten kanaka ulo ri. Isau le gam tom, biil gam mamlik ta liumi la. ");
INSERT INTO bjp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kiskam sing gam, wara le gam tel foron fat na namnamne la na olon matmat lon foron profet ae foron tubutamat gam tom ri siimete ta ri. ");
INSERT INTO bjp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Isau le igii, gam famalal u le gam somangat na sinang ae foron tubutamat gam ri tel ta u. Wara le ri siimete ta foron profet, ma gam ka luun foron fat na namnamne na olri. ");
INSERT INTO bjp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","I e wara ke God ae i tasum kanaka ka tarah, ‘Ian wuun foron profet turan foron aposel usuf ri, ma rik siimete fal lo ri ke rik ta fangungut sing fal.’ ");
INSERT INTO bjp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pesu, gam na ulul igii, gamen ti na nagogon isi daun foron profet ae ri siimete ta ri, tipes u na tanwaran fakfakiis. ");
INSERT INTO bjp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tipesu na dawu Abel, papang na dawu Sakaria ae ri siimete ta u na fatpoton Felun Tunmapek ke salan tunmapek. Tekentu kanaka ia fas gam, fanu na ulul igii, rin ti na nagogon kunan foron tier tikii igii. ");
INSERT INTO bjp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kiskam sing gam, foron tom tasum na nagogon, wara le gam ka fut ufu ta ki tina matanfel na tasum. Gam tom biil gam kau ta ulo, biil. Ma gam ka tikale fanu sabin ae ri ier isi rin kau.” ");
INSERT INTO bjp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aunbiing Iesu i suu tina fel ae, foron Farasi turan foron tom fafausum ini nagogon ri ka tipes ngaliaf ulo ke ri ka diikdiik faikis u ini ifuun e fagalte, ");
INSERT INTO bjp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","isi rik tatakuun pes u ini ti orek ae in use u. ");
INSERT INTO bjp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aunbiing ifuun e arip na fanu ri tapiek turim ma ri ka famam fasisit fis tom ini ri, Iesu ka fas famu ta berberat na fafausum kia aragii, “Gamen tumarang isi is ken foron Farasi, i e sinangun garan. ");
INSERT INTO bjp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Foron tier tikii ae ri kum tah, rin tapiek malal, ke foron tier ae i mumun tah, fanu rin usum tikii lo. ");
INSERT INTO bjp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sani ae gam use ta u na kubunor, namih, rin ongen u na siat. Sani ae gam orek siksikau ta ini na balbalun tikas na palgan fel, nami rin ti na olon fel ke rik perek ini. ");
INSERT INTO bjp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Foron talang, ia fas gam, gong gam soke fanu ae ifasi rin siimete pununfo gam sau ma namih, biil mang ifasi rin tel ti tier. ");
INSERT INTO bjp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Isau le ian fas gam ini se ae gamen soke u. Gamen soke ier ae ifasi in siimete pununfo gam ke imel sabin e rakrakai kia una lin gam una tara yiif ae biil i met la. Iuu, ia fas gam, gamen soke u sau. ");
INSERT INTO bjp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Fanu ri fiil ilim e tomsiksik la ini iwu sau e siliin. Isau le God biil i ruu ufu tikas la lo ri. ");
INSERT INTO bjp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ma i tekentu kanaka, temtem tikii na olmi ae na paklu gam, God i usum tikii na wewes lo. Pesu, gong gam sokeh, liu kimi i temin tier lon ifuun e tomsiksik. ");
INSERT INTO bjp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ia fas gam, se i famalal iau na matan fanu, ke Kalalik ken Kaltu sabin in famalal u na matan foron angelo ke God. ");
INSERT INTO bjp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Isau le se i fakawe ufu iau na matan fanu, ian fakawe ufu sabin na matan foron angelo ke God. ");
INSERT INTO bjp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Se i use ti orek laulau ulon Kalalik ken Kaltu, God ifasi in pa ufu. Isau le se i orek laulau ulon Tanwa Kalkaluu, God biil in to pa ufu sinang laulau kia. ");
INSERT INTO bjp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Aunbiing ri fasoti gam na nagogon na foron felun lotu, le na matan foron tom nagogon turan foron famfamu na matanfuntih, gong gam lala wol arafa gamen orek kale gam arae ke sani gamen use u. ");
INSERT INTO bjp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wara le na aunbiing ae, Tanwa Kalkaluu tom in fausum gam ini sani gamen use u.” ");
INSERT INTO bjp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nenge kaltu tinawii na palgan gur ae ka fas Iesu aragii, “Tom fafausum, fas tuaklik isi ik tem foron minmara teumah lo kamah.” ");
INSERT INTO bjp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ke Iesu ka kiliis u aragii, “Ier, se i luun ta iau isi ian tapiek arae tom nagogon ke iak tempaek foron minmara teumuh lo kamuh?” ");
INSERT INTO bjp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ka fas gur na fanu ae aragii, “Tumarang! Gamen tumarang isi marmarsan sinangun akalemok. Wara le liu ken nenge kaltu, biil i wara na ifuun e minmara, biil.” ");
INSERT INTO bjp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ka fas ri sabin ini orek fatoftof igii, “Nenge kaltu ae ifuun e minsik kia, mok kia i tapiek rokap. ");
INSERT INTO bjp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ke kaltu ae ka tara sing i tom aragii, ‘Sani ian tel u? Biil mang ti mua na papah una siing turim foron inen kiak.’ ");
INSERT INTO bjp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Nami ka tarah, ‘Ian tel u aragii: Ian rabat ufu foron papah kiak ke iak tel pes ti fal in laumet, isi ifasi iak siing tikii foron inen na mok kiak turan foron minmarang. ");
INSERT INTO bjp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke iak tara sing iau tom aragii: Ifuun e rokap na tier kiak ia ka pakne ta u, ae in fasi na in fuun e bet. Liu kiak in malmuh, ian ien, iak yin ke iak laes.’ ");
INSERT INTO bjp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Isau le God ka tara sing i aragii, ‘O talos! Igii sau na wor liu kiam in mangmangal koseng o. Ke se mang ik kep foron tier ae o ka fageges turim ta u le kiam tom?’ ");
INSERT INTO bjp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“In fasi sabin arae usuf se ae i luun turim foron minsik kia tom, isau le na mata God, i lauu.” ");
INSERT INTO bjp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Namih, Iesu ka fas berberat na fafausum kia aragii, “Pesu, ia ka fas gam, gong gam lala wol isi liu kimi le sani gamen ien u, ke isi pununfo gam le sani gamen kilkiliis ini. ");
INSERT INTO bjp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Liu kimi i laumet na inen, ke pununfo gam i laumet na kilkiliis. ");
INSERT INTO bjp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Par foron kauko, biil ri soso la ke biil ri il turim inen la ke biil ti papah kiri, isau le God i fen ri la. Gamen usum tom le gam rokap kanaka lon foron man. ");
INSERT INTO bjp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Se lo gam ifasi in bunuut pes ti aunbiing sabin na olon liu kia, aunbiing i lala wol na liu kia? ");
INSERT INTO bjp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Male biil ifasi gamen tel fabiro tier igii, ke isi sani gam ka lala wol na fale tier sabin? ");
INSERT INTO bjp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Gam par foron purpur arafa ri kuum la arae. Biil ri foim la ke biil ri tel kilkiliis la kiri, isau le ia fas gam, king Solomon na foron memeh tikii kia ae i ges la ini, biil i par rokap arae tikas lon foron purpur igii. ");
INSERT INTO bjp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God i me foron fifih na topormok ae ri liu igii ke lumen ri ka lin ri una yiif. Male i arae, ke God in fakilkiliis fakasi gam tom. Unune kimi i fabiro kanaka. ");
INSERT INTO bjp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gong gam muduung na im isi sani gamen ien u ke sani gamen umin u. Gong gam lala wol isi. ");
INSERT INTO bjp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Fanu na piklinbat ae biil ri usum lo God, ri lala im la isi foron tier arae, isau le gam, Tama gam ka usum ta le gam dar foron tier ae. ");
INSERT INTO bjp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Isau le, gamen im isi matanfuntih kia, ke foron tier tikii igii, ik ta u sabin usuf gam. ");
INSERT INTO bjp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Fabiro uh na sipsip, gong gam sokeh! Wara le Tama gam ka laes ta le in ta matanfuntih sing gam. ");
INSERT INTO bjp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sufii foron minmara gam ma pitkalang lo, gamek ta u usuf foron lauu. Gam tel ti pauus kimi ae biil ifasi in mutmut, i e minsik kimi buuii na kukulii, ae biil in to rop, ma foron tom sisii biil ifasi rin la fatat u ke fitfit biil ifasi in ngutngut u. ");
INSERT INTO bjp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wara le falifu sa ae minsik kimi i kiis lo, balmi sabin in kiis lo. ");
INSERT INTO bjp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Fitliu gamen kilkiliis geges isi tel foim ma lam kimi in soksok la tom, ");
INSERT INTO bjp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","arae fanu ae ri nene laulaumet kiri in fis tina inen ken fakekel fuuh. Aunbiing in fis ma ka pispisih na matanfel, ke fanpil rin sapeng pes u. ");
INSERT INTO bjp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ri kalok e foron fafauun ae laulaumet kiri i tapiek ma ka par u le ri geges ta tom ma ri ka nene u. Tekentu kanaka ia fas gam, laulaumet ae in kilkiliis isi tel foim, ik fakiis ri na luuf ma ik sosok ari. ");
INSERT INTO bjp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ri kalok e foron fafauun ae laulaumet kiri i tapiek, taftawa le na fapot le na piklin ien ma ka par u le ae tom ri nene u la. ");
INSERT INTO bjp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Isau le gamen malal na tier igii: Male taman fel in usum na aunbiing sa ae tom sisii in tapiek lo, ke biil ifasi in wol fofoes ufu tom sisii ik suksukuum na fel kia. ");
INSERT INTO bjp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gam sabin gamen geges, wara le Kalalik ken Kaltu in tapiek na aunbiing ae biil gam wol le in tapiek lo.” ");
INSERT INTO bjp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ke Pita ka diik u aragii, “Kumguui, o use orek fatoftof igii usuf kemem sau, le usuf fanu tikii?” ");
INSERT INTO bjp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kumguui ka kiliis u aragii, “Tom foim sa ae i tel fakasi foim ma imel sabin e rokap na wolwol kia? Matngan tom foim arae, laulaumet kia in luun u isi ik famfamu ken foron fafauun kia ma ik fen ri na aunbiing tom una ien. ");
INSERT INTO bjp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","In kalok e fafauun ae, aunbiing laulaumet kia in tapiek ma ik par u le i tel fasuut foim kia tom. ");
INSERT INTO bjp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tekentu kanaka ia fas gam, laulaumet ae in ta ufu foron minmara tikii isi tom foim ae ik fofonoi lo. ");
INSERT INTO bjp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Isau male fafauun ae ka wol le, laulaumet kia biil in to fis sape ke ka tipes paket foron tikiin foim kia, fanu tamat turan kelefin ke ka ien, ka umin dan rakrakai ma ka talos. ");
INSERT INTO bjp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Laulaumet kia ka tapiek bin na nenge biing ae biil i wol le in tapiek lo, ma na aunbiing ae biil i usum lo. Ke laulaumet kia ik tingting burburngi u ma ik luun u turan foron tabun unune. ");
INSERT INTO bjp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Male fafauun ae ka usum ta na sani ae laulaumet kia i ier le in tel u, isau le biil i geges ke biil i tel fasuut foron foim arae na wolwol ken laulaumet kia, ke rin fatakal falaulau u. ");
INSERT INTO bjp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Isau male biil i usum na sani ae laulaumet kia i ier le in tel u ma ka tel nenge tier ae ifasi in kep fangungut isi, ke rin mamlik pis u sau. Se ae ri ta ta ifuun e tier sing i, rin kep in fuun sabin e tier sing i. Ke se ae ri unune ufu ta ifuun e tier usuf i, rin sising u isi in fuun tom e tier. ");
INSERT INTO bjp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ia la ta uga isi fasok piklinbat ma ia lala ier le aga mang ik soksok la. ");
INSERT INTO bjp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Isau le imel e bapitaiso biitom ae ian kep u. Igii ia kalsakai tara tatawin papang na aunbiing in rop. ");
INSERT INTO bjp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Arafah, gam wol le ia tapiek ta isi ta siaroh na piklinbat? Biil. Ia fas gam, ia la uga isi tempaek fanu. ");
INSERT INTO bjp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tipes u igii, male in lim e kaltu na nenge matanfel, ke rin tampaek: In tuul koseng iwu ke in u koseng ituul. ");
INSERT INTO bjp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ke nenge tamankak in tampaek koseng ke kalalik ke nenge kalalik koseng tama, nenge finsus koseng ke keleflik ke nenge keleflik koseng tina, nenge fifin koseng awa ke awa koseng u.” ");
INSERT INTO bjp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu ka fas gur na fanu aragii, “Aunbiing gam par laukaf i fenfen la ubase na falifu ae pisiih i sup la wah, fanpil gam ka tara le, ‘Us in luut,’ ke ka tekentu tom. ");
INSERT INTO bjp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ke aunbiing gam par taubar i tapiek, gamek use u le, ‘In pisiih,’ ke ka tekentu tom. ");
INSERT INTO bjp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Foron tom gargaranmet! Gam par foron fakileng la na piklinbat ke na bat, ke gam ka usum le aunbiing arafa in tapiek. Arafah, biil ifasi gamen iliim foron fakileng na aunbiing igii? ");
INSERT INTO bjp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Isi sani gam tom, biil gam par failiim foron sinang ae i tortores? ");
INSERT INTO bjp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aunbiing kamu e tuui kiam kamu la isi ti na nagogon, on totof rakrakai tom isi kamun fatala fis aunbiing kamu toltole sal la biitom, tarama ka dat o usuf tom nagogon, ke tom nagogon ka ta ufu wo una liman tom parpar kale felun kamkabet isi ik fakau wo una felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ia fas o, biil ifasi on suuh, papang na aunbiing on ta tikii ifis e pitkalang ae on fiil u.” ");
INSERT INTO bjp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aunbiing sabin ae, fale fanu ri fas Iesu ini fale fan Galili ae Pailat i siimete ta ri, aunbiing ri tel tunmapek. Dawu ri ka faluuiluui turan dawun foron sipsip una tel tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ke Iesu ka kiliis ri aragii, “Arafah, gam wol le fan Galili ae, ri foron tom tel sinang laulau tutus tom lon fan Galili tikii, i wara na matngan minet ae ri kalsakai ta u? ");
INSERT INTO bjp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Biil tom. Isau le ia fas gam, male biil gam kiliis liu, ke gam tikii gamen fiu arae ri. ");
INSERT INTO bjp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ke arafa lon sangful ini wal e fanu na Ierusalem ae nenge fel na Siloam ae i dolo ubase na mawe, i masuuf na olri ma ka siimete ri tikii? Gam wol le sinang laulau kiri i laumet lon fanu tikii ae na Ierusalem? ");
INSERT INTO bjp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Biil tom. Isau le ia fas gam, male biil gam kiliis liu, ke gam tikii gamen fiu arae ri.” ");
INSERT INTO bjp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu ka fas ri sabin ini orek fatoftof igii, “Nenge kaltu i so ta nenge au na fik na palgan porpor wain kia. Nami ka la isi par isi ti fuan fik ae, isau le biil i tafe tikas. ");
INSERT INTO bjp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pesu, ka fas kaltu ae i parpar la na porpor wain kia aragii, ‘Ka tuul mang e bet ia la la isi par isi ti fuan fik igii, isau le biil tom ia tafe tikas la. Pok ufu sau! Isi sa ka farop foes inen tina nanal?’ ");
INSERT INTO bjp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Isau le tom parpar kale na mok ka fas u aragii, ‘Kumguui, taftawa bii arae na in tikii bin e bet. Ian susuup kawil u ke iak lin piin una wara. ");
INSERT INTO bjp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Male in fua na bet apiek, ke i rokap. Male biil, ke pok ufu.’” ");
INSERT INTO bjp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na nenge Biingen Mangeh, Iesu i famam fausum fanu na nenge felun lotu. ");
INSERT INTO bjp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nenge fifin aiwa, tanwa laulau i fatel u, ma ka puuw e pokta na sangful ini wal e bet ma biil ifasi in ti tortores. ");
INSERT INTO bjp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aunbiing Iesu ka par u, ka kam pes u ke ka tara sing i aragii, “Tin ier, o sengsegeng koseng sasem kiam!” ");
INSERT INTO bjp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iesu ka luun iun lima lo, fanpil ka sotih tortores ma ka usefages God. ");
INSERT INTO bjp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Famfamu na felun lotu ae ka balkut, wara le Iesu i faliu fifin ae na Biingen Mangeh. Pesu, ka fas fanu aiwa aragii, “Iwon e biing una foim. Gam la isi rik faliu gam na foron biing ae, ma na Biingen Mangeh gong.” ");
INSERT INTO bjp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ke Kumguui ka kiliis u aragii, “Gam foron tom gargaranmet! Arafah, na foron Biingen Mangeh biil gam puk ufu foron bulmakau la ke foron dongki tina felu ri ke gam ka fasuu ri la isi faumin ri? ");
INSERT INTO bjp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Fifin igii i tina mat ke Abaram, isau le Satan i kabet ta u na nenge sangful ini wal e bet. Arafah, biil i tortores le ian puk ufu na Biingen Mangeh?” ");
INSERT INTO bjp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aunbiing Iesu i use u arae, foron tuui tikii kia ri ka matlawen. Isau le gur na fanu ae, ri laes isi foron rokap na tier ae Iesu i tel u. ");
INSERT INTO bjp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ke Iesu ka tarah, “Matanfuntih ke God i arafah? Ke sani ian fatof u ini? ");
INSERT INTO bjp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I arae kutun mastet ae nenge kaltu i kep u ma ka so u na mok kia. Ka kuum ma ka tapiek nenge au ke foron man na mua ri ka tel polpolo ri na foron aka.” ");
INSERT INTO bjp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu ka diik sabin aragii, “Sani ian fatof matanfuntih ke God ini? ");
INSERT INTO bjp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I arae is ae nenge fifin i kep u ke ka ikis u turan ifuun e palawa, ma palawa tikii ae ka sut.” ");
INSERT INTO bjp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aunbiing Iesu i tatatkau la una Ierusalem, ka famam fausum fanu na piran maleh ke na birbiron maleh sabin. ");
INSERT INTO bjp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nenge kaltu ka diik u aragii, “Be Kumguui, in tuul sau e fanu ae God in faliu pes ri?” Ke Iesu ka kiliis u aragii, ");
INSERT INTO bjp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gamen rakrakai tom isi gamek kau na matanfel ae i fiuuk. Ia fas gam, fanu fuun rin totof isi kau, isau le biil ri fasih. ");
INSERT INTO bjp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aunbiing taman fel in apti ma ik babat na matanfel, gamen soti awii na maleh, gamek pispisih ke gamek famam fakam aragii, ‘Kumguui, sapeng pes kemem!’ “Isau le ik kiliis gam aragii, ‘Biil ia to usum lo gam, le gam tingah.’ ");
INSERT INTO bjp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ke gamek fas u aragii, ‘Keme ien la ke keme ka yin la turam, ma o ka fafas la na foron sunsun sal kimem.’ ");
INSERT INTO bjp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Isau le ik fas gam aragii, ‘Biil ia to usum lo gam, le gam tingah. Gam ti koseng iau, gam tikii foron tom tel sinang laulau.’ ");
INSERT INTO bjp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Aunbiing gamen par Abaram, Aisak ke Jekop turan foron profet tikii na matanfuntih ke God, gamen teng ma gamek faririt ngismi, wara le ri ka lin fasuu ta gam una maleh. ");
INSERT INTO bjp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Fanu rin la tina ifet tikii e matan kif ke rik kiis na inen na matanfuntih ke God. ");
INSERT INTO bjp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ongen u, fanu ae ri mi igii, nami rin famu, ke fanu ae ri famu igii, nami rin mih.” ");
INSERT INTO bjp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na aunbiing ae, fale Farasi ri la usuf Iesu ke ri ka fas u aragii, “Kang koseng falifu igii ma ok la una ti maleh keskes, wara le Erot i ier le in siimete o.” ");
INSERT INTO bjp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ke Iesu ka kiliis ri aragii, “La, ma gamek fas tom gargaranmet ae le, igii ke lumen, ian tel ufu foron tanwa laulau ke iak faliu foron sasem ma na fatuul u e biing iak fasuut foim kiak. ");
INSERT INTO bjp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ian la tom igii, lumen ke pakaii, wara le biil ifasi rin siimete ti profet na ti maleh keskes, biil. Na Ierusalem sau. ");
INSERT INTO bjp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusalem! Ierusalem! O siimete foron profet la ke o luumete fanu la ae God i wuun ta ri usuf o. Ifuun e aunbiing ia ier le ian tel turim berberat kiam, arae nenge tinantau ae i ruruuf na olon foron natu, isau le biil o ier isi. ");
INSERT INTO bjp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Par u, maleh kimi ik sum mang. Ia fas gam, biil sabin gamen par iau papang na aunbiing gamen tarah, ‘Fafakalok usuf ier ae i la uga ini asa Kumguui.’” ");
INSERT INTO bjp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na nenge Biingen Mangeh, aunbiing Iesu i kau isi ien na fel ken nenge laulaumet ken foron Farasi, fanu ri ka lala luun matri lo. ");
INSERT INTO bjp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nenge kaltu i sutsut e fo, tinawii na mata Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu ka giliim ke ka diik foron Farasi turan foron tom tasum na nagogon aragii, “Arafah, na nagogon i tortores le rin fafaliu na Biingen Mangeh, le biil?” ");
INSERT INTO bjp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Isau le biil ri orek. Ke Iesu ka pose lon kaltu ae, ka faliu u ke ka wuun ufu. ");
INSERT INTO bjp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iesu ka diik ri aragii, “Male tikas lo gam, ke kalalik le nenge bulmakau kia i luut siluung na toh na dan na Biingen Mangeh, ke arafah, biil in sangar sape na dat ufu?” ");
INSERT INTO bjp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Biil ifasi rin kiliis u ini ti orek. ");
INSERT INTO bjp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aunbiing Iesu i par foron ses ri tim pes foron nian kiiskiis ae na famu, ka fas ri ini orek fatoftof igii: ");
INSERT INTO bjp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Male tikas i sising o una inen ken fakekel fuuh, gong o kep nian kiiskiis ae na famu, tarama tikas ae kiiskiis kia i laumet lo wo, ri sising u sabin una inen ae. ");
INSERT INTO bjp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ke ier ae i sising ta kamu una inen ae, ka la usuf o ma ka fas o aragii, ‘Kang tinawii, ma ier igii ik kep salam.’ Ke on matlawen ma ok kiis mang tom na nian kiiskiis ae na mih. ");
INSERT INTO bjp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Isau le aunbiing ri sising o una ti inen, la ma ok kiis na nian kiiskiis ae tom na mih, isi kaltu ae i sising ta wo ik la ma ik fas o aragii, ‘Talang, kang una nian kiiskiis ae na famu.’ Ke in sik asam na matan fanu tikii ae na inen ae. ");
INSERT INTO bjp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Se i falaumet u tom, God in fasabiro u, ma se i fasabiro u, God in falaumet u.” ");
INSERT INTO bjp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu ka fas ier ae i sising pes ta u aragii, “Aunbiing o tel nenge inen, gong o sising pes foron talam, foron tuamlik, foron sikinting lo wo turan fanu ae ifuun e minsik kiri ae fatat o. Male on tel u arae, ke ri sabin rin sising pes o isi rik kiliis fafen kiam. ");
INSERT INTO bjp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Isau le aunbiing o tel nenge inen, ke on sising pes foron lauu, fanu ae baban fo ri i met, foron peo ke foron kut. ");
INSERT INTO bjp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Male on tel u arae, ke on kalok, wara le biil ifasi rin kiliis fafis u usuf o. God tom in kiliis fafis u usuf o na biingen apaptifis ken foron tom tortores.” ");
INSERT INTO bjp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Neng lon fanu ae ri kiis ta tura Iesu, ka ongen u ke ka tarah, “I kalok e kaltu ae in ien na tel inen na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu ka kiliis u aragii, “Nenge kaltu i geges isi tel nenge tara inen ke ka sising fanu fuun isi rin tapiek. ");
INSERT INTO bjp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na biingen tel inen, ka wuun fafauun kia le in fas fanu ae i sising ta ri, aragii, ‘Gam la mang ugapiek, wara le foron tier tikii ka geges tah.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Isau le ri tikii ri ka tel marmarsan orek bin. Neng famu ka tarah, ‘Igii sau ia fiil nenge sun nanal una mok kiak. Kiskam, iak la ta bii isi par u.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Neng sabin ka tarah, ‘Igii sau ia fiil nenge sangful e bulmakau kiak una foim. Kiskam, iak la ta bii isi iak tof ri.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ke neng sabin ka tarah, ‘Ia am fakekel sau, pesu biil ifasi ian la.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Fafauun ae ka fis ke ka fas laulaumet kia ini foron orek ae. Laulaumet kia ka kut e bala ke ka fas fafauun ae aragii, ‘On sangar sau una foron saltih ke una foron sunsun sal na maleh ae ke ok telpes foron lauu, fanu ae baban fo ri i met, foron kut ke foron peo.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Namih, fafauun kia ka tarah, ‘Tara kaltu, sani o fas ta iau ini, ia ka tel ta u, isau le imel biitom e mua na fel.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Laulaumet kia ka fas u aragii, ‘La una foron saltih ke una foron sunsun sal na topormok ke ok fangongos pes ti fale fanu sabin ugapiek, isi fel kiak ik fuun. ");
INSERT INTO bjp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ia fas gam, biil tikas lon fanu ae ia sising famu ta ri, in tof ti inen na inen kiak, biil.’” ");
INSERT INTO bjp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tara gur na fanu ri la tura Iesu, ke Iesu ka giliim usuf ri ma ka tarah, ");
INSERT INTO bjp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Male tikas i ier isi mi lo iau, isau le i lala ier tom isi tama, tina, antu, berberat kia, foron tualik, foron fenelik ke liu kia tom, ma biil isi iau, biil ifasi in tapiek kalalik na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ke se biil i kusep aupaket kia tom ma ka mi lo iau, biil ifasi in tapiek kalalik na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Male tikas lo gam i ier le in tel nenge fel ae i dolo ubase na mawe, famu in kiis fofo bii ke ik wol tole u, le infis e pitkalang in fasi una farop fel ae. ");
INSERT INTO bjp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Male biil in tel u arae, ke in tanwara ta sau ma biil in farop u. Ma fanu tikii ae ri par fel ae, rin morot ini kaltu ae. ");
INSERT INTO bjp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Rin tara aragii, ‘Ier igii, i tartar u le in tel fel ae. I tanwara ta sau ma biil mang ifasi in farop u.’ ");
INSERT INTO bjp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Male nenge king i ier isi fapaket turan nenge king, famu in kiis fofo ma ik wol rokap bii. Arafah, nenge sangful e arip e tom fapaket kia ifasi rin fapaket turan iwu e sangful e arip e tom fapaket ken nenge king? ");
INSERT INTO bjp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Male biil ifasi, ke in wuun ti fale fanu isi tel ti orek una fatapiek siaroh turan king ae, aunbiing i tapak biitom. ");
INSERT INTO bjp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ifasi sau arae usuf gam, male tikas lo gam biil i wol ufu foron tier tikii kia, ke biil ifasi in tapiek kalalik na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tes i rokap, isau male in rop e musmus lo, ke arafa sabin rin famusmus fafis u arae? ");
INSERT INTO bjp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Biil mang i rokap una ti tier sabin ke biil mang ifasi in farokap nanal, rin fore ufu sau. “Se imel e balbalu, i rokap le in wong ini.” ");
INSERT INTO bjp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nenge aunbiing, foron tom kep takiis turan foron tom tel sinang laulau, ri tikii ri taptapiek turim la isi ongen Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Isau le foron Farasi turan foron tom fafausum ini nagogon ri ka belbel orek aragii, “Kaltu igii i fatala bin turan foron tom tel sinang laulau ke ka ien turim tura ri.” ");
INSERT INTO bjp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ke Iesu ka fas ri ini orek fatoftof igii: ");
INSERT INTO bjp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Male tikas lo gam imel e nenge mar e sipsip kia ma neng lo ri ka rong, ke gam wol arafah? Biil in la koseng isiu e sangful ini siu aiwa na falifu foes ma ik im isi neng ae i rong tah, papang na aunbiing ik tafe u? ");
INSERT INTO bjp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ke aunbiing in tafe u, in laes ma ik kusep pes u ");
INSERT INTO bjp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","una maleh. Namih, ik kam turim foron tala turan fanu ae fatat u ma ik fas ri aragii, ‘Gamen laes turang, wara le ia ka tafe ta u e sipsip kiak ae i rong tah.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ia fas gam, in fasih sabin arae. Laes bae na kukulii in laumet kanaka aunbiing nenge tom tel sinang laulau i kiliis liu kia, na laes isi isiu e sangful ini siu e tom tortores ae biil ri dar ti sokiliis na liu kiri. ");
INSERT INTO bjp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ke, male nenge fifin imel e nenge sangful e siliwa kia ma ka farong neng, ke gam wol arafah? Biil in fasok ti lam, ik sa palgan fel kia ke ik im rokap isi, papang na aunbiing in tafe ta u tom? ");
INSERT INTO bjp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aunbiing in tafe u, ik kam turim foron tala turan fanu ae fatat u ma ik fas ri aragii, ‘Gamen laes turang, wara le ia ka tafe ta nenge siliwa kiak ae ia farong ta u.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ia fas gam, imel sabin e matngan laes arae na fatpoton foron angelo ke God, aunbiing nenge tom tel sinang laulau i sokiliis liu kia.” ");
INSERT INTO bjp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu ka tara sabin aragii, “Imel e nenge kaltu, ae iwu e kalalik tamat kia. ");
INSERT INTO bjp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fawu u e kalalik kia ka fas tama aragii, ‘Tata, ta u mang e foron tier ae le kiak tina foron minmaram.’ Pesu, temruh ka tem foron minmara lo ruh. ");
INSERT INTO bjp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Fale biing nami sau, fawu u e kalalik ka kep foron tier ae kia ke ka la una nenge maleh tapak ma ka langre foron minsik kia na matngan liu ae biil i tortores. ");
INSERT INTO bjp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aunbiing ka farop tikii ta foron tier kia, nenge tara taul fitol ka tapiek na maleh ae, ma ka tipes bilbiling. ");
INSERT INTO bjp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pesu, ka la ma ka patep isi nenge kaltu tina falifu ae. Ke kaltu ae ka wuun ufu una falifu kia, isi fenfen boh. ");
INSERT INTO bjp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I ier isi ien sani sau ae i fen foron boh la ini, isau le biil tikas i fen u ini ti tier. ");
INSERT INTO bjp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Aunbiing ka tapiek e rokap na wolwol sing i, ka tarah, ‘Foron tom foim tikii ke tata, ifuun e inen ari. Isau le iau, ia ka met aiak aga. ");
INSERT INTO bjp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ian aptih ma iak fis usuf tata ke iak fas u aragii: Tata ia ka tel ta sinang laulau na mata God ke na matam sabin. ");
INSERT INTO bjp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Biil mang ia tortores isi ok foteng iau le, ia kem kalalik. On tel iau sau arae nenge tom foim kiam.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ke ka aptih ma ka fis usuf tama. “Isau le aunbiing i tapak biitom, tama ka par u ke ka lala mais u. Ka filau usuf i, ka diit pes u ma ka dor u. ");
INSERT INTO bjp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ke ke kalalik ka tara sing i aragii, ‘Tata, ia ka tel ta sinang laulau na mata God ke na matam sabin. Biil mang ia tortores isi ok foteng iau le, ia kem kalalik.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Isau le, tama ka fas foron fafauun kia aragii, ‘Sangar! Kep ti rokap na kaen uga ma gamek fakilkiliis u ini. Gamek luun ti ring na katngan lima ke gamek fakau su na iun keke. ");
INSERT INTO bjp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Gam kep natun bulmakau ae i sut rokap uga ma gamek siimete u. Keren ien turim ma kerek laes. ");
INSERT INTO bjp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wara le keng kalalik igii, i met tah ma igii ka liu fis sabin. I rong tah ma igii ia ka tafe u sabin.’ Ke ri ka tipes laes turim. ");
INSERT INTO bjp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Isau le kalalik famu kia tinawii biitom na mok. Aunbiing ka la fatat fel, ka ongen kinen seksek ke niguui. ");
INSERT INTO bjp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ke ka tawi pes nenge kalalik ma ka diik u aragii, ‘Sani i tara aragii?’ ");
INSERT INTO bjp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Kalalik ae ka fas u aragii, ‘Tuamlik ka fis tah, ke tamam ka siimete natun bulmakau ae i sut rokap, wara le i somangat pes ke kalalik ae i fis ini liu rokap.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Aunbiing ka ongen u, ka kut e bala ma biil i ier isi kau. Pesu, temruh ka suuh ke ka famomo pes u isi in kau. ");
INSERT INTO bjp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Isau le ka kiliis tama aragii, ‘Ongen u, ifuun e bet ia foim ta kiam arae nenge fafauun ma biil ia ongen ufu ta ti orek kiam, ke biil tom o ta ta ti fabiro meme usuf iau, isi iak laes turim turan foron talang. ");
INSERT INTO bjp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Isau le aunbiing kem kalalik ae i langre ta foron minmaram lon foron tamfaes ka tapiek, o ka siimete natun bulmakau tom ae i sut rokap aia.’ ");
INSERT INTO bjp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Tama ka kiliis u aragii, ‘Keng kalalik, o kiis la turang na foron aunbiing tikii ke foron minmarang tikii kiam. ");
INSERT INTO bjp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Isau le, i rokap le keren gesges ma kerek laes, wara le tuamlik i met tah ma igii ka liu fis sabin. I rong tah ma igii ia ka tafe u.’” ");
INSERT INTO bjp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ka fas berberat na fafausum kia aragii, “Nenge kaltu ae ifuun e minsik kia, imel e tom foim kia ae i parpar kaleh na foron minmara, isau le ri ka tiu u le i langre foron minmara laulaumet kia. ");
INSERT INTO bjp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ke laulaumet ae ka kam pes u ma ka diik u aragii, ‘Orek arafa igii ia ongen u lo wo? On ta buk ae o siit papte foim kiam lo uga, wara le biil mang on parpar kaleh.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Tom parpar kale ae ka tara sing i tom aragii, ‘Sani mang iak tel u? Laulaumet kiak ik tel ufu iau mang tina foim kiak. Biil ti miang una purak ma ia matlawen sabin isi ian sising fanu isi ti tier. ");
INSERT INTO bjp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ia usum na sani ian tel u, isi aunbiing in tel ufu iau tina foim kiak, ke fanu rin somangat pes iau una fel kiri.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ke ka kam temtem tikii lon fanu ae imel e tuka kiri sing laulaumet kia. Ka diik neng famu aragii, ‘Ifis e tuka kiam sing laulaumet kiak?’ ");
INSERT INTO bjp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ka kiliis u aragii, ‘Iwal e mar e galen na wel na olif.’ “Tom parpar kale ae ka fas u aragii, ‘Aun buk na tuka kiam igii. Kiis ma ok siit sape ifet e mar sau.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ka diik neng sabin aragii, ‘Ke wo, ifis e tuka kiam?’ “Ke ka kiliis u le, ‘Iwu e sangful e arip e kilogrem na wit.’ “Ke tom parpar kale ka fas u aragii, ‘Aun buk na tuka kiam igii, kep u ma ok siit sangful ini won e arip e kilogrem na wit.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Laulaumet ae ka usefages tom parpar kale ae biil i tekentu na foim kia, wara le sani i tel u, i finngas u le paklu i sapeng. Fanu tina piklinbat i sapeng tom e paklu ri na tumarnge foim kiri tom, lon fanu tina malal. ");
INSERT INTO bjp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ia fas gam, gamen fatala turan fanu ini minsik tinaga na piklinbat, isi le aunbiing in rop, ke God in somangat pes gam una maleh ae i kiis fitliu. ");
INSERT INTO bjp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Se ae ifasi rin unune ufu ituul e tier usuf i, ifasi sabin rin unune ufu in fuun e tier usuf i. Se ae biil i tekentu na ituul e tier, ke biil sabin ifasi in tekentu na in fuun e tier. ");
INSERT INTO bjp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pesu, male biil gam tekentu na foron minsik tinaga na piklinbat, ke se in unune ufu foron minsik tekentu usuf gam? ");
INSERT INTO bjp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Male biil gam tekentu na fofonoi na minmaran tikas, ke se in ta ti tier sing gam isi kimi tutus tom? ");
INSERT INTO bjp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Biil ti tom foim ifasi in foim sing iwu turim e laulaumet, biil. Wara le, in ememse neng ma ik ier isi neng, in mi lo neng ma ik ire neng. Biil ifasi gamen foim sing God ke pitkalang sabin, biil.” ");
INSERT INTO bjp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Foron Farasi ae ri lala ier la isi pitkalang, aunbiing ri ongen Iesu i use u aragii, ke ri ka mutmut orek ulo. ");
INSERT INTO bjp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ke Iesu ka fas ri aragii, “Gam tel gam arae gam tortores tom na matan fanu, isau le God i usum na balmi. Sani ae i laumet kanaka na parpar ken fanu, i laulau kanaka na mata God. ");
INSERT INTO bjp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nagogon ke Moses turan orek ken foron profet i papang sau na aunbiing ke Jon Tom tel Bapitaiso. Tipes u mang aiwa, ri fafas ini Rokap na Fafas na matanfuntih ke God ma fanu tikii ri ka totof rakrakai tom isi rin kau ulo. ");
INSERT INTO bjp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","I ngangaten isi kukulii turan piklinbat run mangmangal, isau le, i ngangaten kanaka tom isi ti fabiro tok na pen in mangmangal tina nagogon ke Moses. ");
INSERT INTO bjp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Male tikas i lin antu ma ka telpes ti fifin sabin, i tel sinangun puur, ke kaltu sabin ae i telpes fifin ae antu i lin u, i tel sinangun puur. ");
INSERT INTO bjp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“I mel e nenge kaltu ae ifuun e minsik kia. I ges la tom ini foron rokap na kilkiliis ma i ien pikpiik la na foron biing tikii. ");
INSERT INTO bjp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma awii na matan ubiif kale fel kia, ri fakiis ta nenge lauu ae i lotlot e fo, asa e Lasarus. ");
INSERT INTO bjp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I ier la le in ien foron peksen inen ae i luut la tina luuf una ien ken kaltu ae ifuun e minsik kia. Ke foron puul sabin ri ka dem foron lot la na pununfo. ");
INSERT INTO bjp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Namih, lauu ae ka met ke foron angelo ri ka tel pes u ke ri ka fakiis u na baba Abaram. Kaltu sabin ae ifuun e minsik kia ka met ke ri ka ile u. ");
INSERT INTO bjp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma ka la una tara yiif ae biil i met la. Aiwa ka kalsakai tara fangungut. Aunbiing ka tar, ka par Abaram na tapak ma Lasarus awii naisa. ");
INSERT INTO bjp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ke, ka fakam usuf Abaram aragii, ‘Tata Abaram, mais iau! Wuun Lasarus bii ik falum tiptipan lima na dan ma ik famir kermeng, wara le ia kalsakai tara fangungut kanaka na yiif igii.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Isau le Abaram ka kiliis u aragii, ‘Liliif, wolpes u le o kep ta foron rokap na tier aunbiing o liu tah, ma Lasarus i kep ta foron tier laulau. Isau le igii, ka laes aga ma o ka kalsakai fangungut. ");
INSERT INTO bjp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma nenge tier sabin i aragii: Ri ka tel ta nenge tara turuung na fatpoto kerer, isi biil ifasi tikas in la tinaga usuf gam, le tinawii uga usuf kemem.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kaltu ae ka kiliis u aragii, ‘Tata, male i arae, ke ia piispiis wo le on wuun Lasarus bii una fel ke tata, ");
INSERT INTO bjp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","wara le ilim e tuaklik. Fas Lasarus le in fakiing ri isi gong sabin ri la una salan fangungut igii.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abaram ka kiliis u aragii, ‘Nagogon ke Moses turan orek ken foron profet ae naisri, taftawa rik ongen u.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kaltu ae ka tarah, ‘Auuh, tata Abaram! Male tikas tom in liu fis tina minet in la unaisri, ke rik sokiliis liu kiri.’ ");
INSERT INTO bjp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abaram ka fas u aragii, ‘Male biil ri wong na foron nagogon ke Moses turan orek ken foron profet, ke biil sabin rin to unune na orek ken tikas ae i apti fis tina minet.’” ");
INSERT INTO bjp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Namih, Iesu ka fas berberat na fafausum kia aragii, “Foron tier ae in fatel fanu isi rik luut na sinang laulau in tapiek tom, isau le kiskam kanaka sing ier ae in fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","In rokap ulo le rin kabet ta ti tara fat na kongkongo ma rik fadom ta u na palgantes, tarama ka faluut tikas lon birbiron berberat igii na sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pesu, gamen tumarang! “Male tuamlik i tel sinang laulau, ke on fakiing u. Male ka kiliis liu kia, ke on wol ufu sinangu. ");
INSERT INTO bjp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Male i tel sinang laulau ulo wo ifit e aunbiing na nenge biing ma fafit ka fis usuf o ma ka fot kiskam, ke on wol ufu sinangu.” ");
INSERT INTO bjp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Foron aposel ri ka tara sing Kumguui aragii, “Falaumet unune kimem!” ");
INSERT INTO bjp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ke Kumguui ka kiliis ri aragii, “Male unune kimi i fabiro arae fabiro kutun mastet, ke ifasi gamen fas au igii le, ‘Kang ini baulim ma ok ti na palgantes,’ ke in wong sing gam. ");
INSERT INTO bjp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Male tikas lo gam imel e fafauun kia ae i purak, le i fofonoi la na foron sipsip, aunbiing i fis tina potormok, ke biil on fas u le, ‘La ugapiek, kep salam ma ok ien.’ ");
INSERT INTO bjp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Biil. On tara sing i aragii, ‘Fageges inen aiak! Kilkiliis ma ok sosok aiak ma iak ien, nami on ien ke ok yin.’ ");
INSERT INTO bjp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Arafah, on fot rokap sing fafauun kiam, wara le i tel fasuut sani o fas ta u le in tel u? Biil tom. ");
INSERT INTO bjp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pesu gam sabin, aunbiing gam ka tel fasuut ta sani ae God i fas ta gam isi tel u, ke gamen tara aragii, ‘Keme foron fafauun foes sau, keme tel fasuut foim sau kimem.’” ");
INSERT INTO bjp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na ninla ke Iesu una Ierusalem, i la na fatpoton iwu e falifuh, Samaria ke Galili. ");
INSERT INTO bjp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aunbiing ka tapiek na nenge maleh, i sangful e kaltu ae ri sem lepra ri ka la usuf i. Ri soti tapak tom ");
INSERT INTO bjp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ke ri ka perek aragii, “Iesu, Tara Kaltu, mais kemem!” ");
INSERT INTO bjp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aunbiing Iesu ka par ri, ka fas ri aragii, “Gam la ma gamek finngas gam sing foron pris.” Ma aunbiing ri ka la, sasem ka rop ma pununfo ri ka fuuh. ");
INSERT INTO bjp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Neng lo ri, aunbiing i par u le sasem ka rop mang koseng u, ka fis ma ka kukuk ini ususefages usuf God. ");
INSERT INTO bjp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ka ilepul na keke Iesu ke ka fot rokap. Kaltu ae i nenge sikin Samaria. ");
INSERT INTO bjp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ke Iesu ka diik aragii, “I sangful e kaltu ae sasem i rop ta koseng ri, bikiih? Isiu fiawah? ");
INSERT INTO bjp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Arafah, biil tikas lo ri i fis isi usefages God? Ses keskes sau igii i fis?” ");
INSERT INTO bjp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ke Iesu ka tara sing i aragii, “Aptih ma ok la. Unune kiam ka faliu ta wo.” ");
INSERT INTO bjp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fale Farasi ri diik Iesu isi aunbiing sa matanfuntih ke God in tapiek, ke ka kiliis ri aragii, “Aunbiing matanfuntih ke God in tapiek, biil ifasi rin par u. ");
INSERT INTO bjp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ke biil ifasi rin tara le, ‘Igii,’ le, ‘Ae,’ wara le matanfuntih ke God ae mang ta naismi.” ");
INSERT INTO bjp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Namih, ka tara sing berberat na fafausum kia aragii, “Nenge aunbiing in tapiek ae gamen lala ier isi par tikas e biing na foron biing ken Kalalik ken Kaltu, isau le biil gamen par u. ");
INSERT INTO bjp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Fale fanu rin tara sing gam aragii, ‘Par u, Kalalik ken Kaltu ae,’ le ‘I igii.’ Gong gam la ke gong gam mi lo ri. ");
INSERT INTO bjp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wara le biing ken Kalalik ken Kaltu, in arae pil ae i maeng ma ka famalal tikii bat tina nenge baba una nenge baba. ");
INSERT INTO bjp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Isau le famu, in kalsakai in fuun e fangungut ma fanu na ulul igii rin ire u. ");
INSERT INTO bjp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Foron biing ken Kalalik ken Kaltu, in fasi sau arae na foron biing ke Noa. ");
INSERT INTO bjp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Fanu ri famam ien, yin ke ri ka fakekel papang na biing ae Noa ka kau na sip. Ke nor ka tapiek ma ka falaulau ri tikii. ");
INSERT INTO bjp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ifasi sabin arae na foron biing ke Lot. Fanu ri famam ien ke yin, ri famam fifiil ke ri ka sufii foron tier, ri ka famam soso ke ri ka famam tel fel. ");
INSERT INTO bjp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Isau le na biing Lot ka la koseng Sodom, yiif turan salfa ka luut arae us tina kukulii ma ka falaulau ri tikii. ");
INSERT INTO bjp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“In fasi sabin arae na aunbiing Kalalik ken Kaltu in tapiek. ");
INSERT INTO bjp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na biing ae, male tikas bae na olon fel kia, gong i pu isi kep fasuu ti minmara. Ke male tikas awii na mok, gong i fis una fel isi kep ti tier. ");
INSERT INTO bjp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gam wolpes antu Lot! ");
INSERT INTO bjp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Se i totof isi gong kale liu kia, liu ae in mangmangal koseng u. Isau le se i sok ufu liu kia, ke in liu. ");
INSERT INTO bjp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ia fas gam, na wor ae, in u run borong turim na nenge luuf ke rik kep pes itikii, koseng neng. ");
INSERT INTO bjp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ke in u e fifin run gosgos wit turim la, rik kep pes itikii, koseng neng.” ");
INSERT INTO bjp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ke berberat na fafausum ri ka diik aragii, “Kumguui, fia in tapiek wa e foron tier igii?” Ke Iesu ka kiliis ri aragii, “Falifu ae imel e minet lo, foron kauko rin la turim aiwa.” ");
INSERT INTO bjp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ke Iesu ka fas berberat na fafausum kia ini nenge orek fatoftof isi rin sising mulmul ma gong ri angos. ");
INSERT INTO bjp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ka tarah, “Na nenge maleh, imel e nenge tom nagogon ae biil i bulat la lo God ke biil sabin i mais fanu la. ");
INSERT INTO bjp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na maleh sabin ae, imel e nenge makos ae i la mulmul la usuf i ke ka sising u la aragii, ‘On fatortores tatawin ae na fatpoto kama e tuui kiak.’ ");
INSERT INTO bjp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Na dolon aunbiing biil i wong la sing i, isau le namih, ka tara sing i tom aragii, ‘Biil ia bulat la lo God ke biil sabin ia mais fanu la, ");
INSERT INTO bjp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","isau le, iwara makos igii i fatel kanaka iau la, pesu ian fatortores tatawin kia, tarama ka famut fong na belbel la unaisang.’” ");
INSERT INTO bjp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ke Kumguui ka tara sing ri aragii, “Gam ongen orek ken tom nagogon laulau ae. ");
INSERT INTO bjp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Arafah, gam wol le God biil in tel tortores na nagogon usuf fanu kia ae i tim pes ta ri, ae ri tautau la usuf i isi falupes na foron siat ke na foron wor? Arafah, in fofo na lupes ri? ");
INSERT INTO bjp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ia fas gam, in lupes sape ri ke ik tel nagogon ae i tortores usuf ri. Isau le aunbiing Kalalik ken Kaltu in tapiek, ke arafah, in tafe ti fanu tom ae imel e unune kiri aga na piklinbat, le biil?” ");
INSERT INTO bjp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iesu i use orek fatoftof igii ulon fanu ae ri unune le ri tom ri tortores ma ri ka puris fal la: ");
INSERT INTO bjp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Iwu e kaltu ru tatkau una Felun Tunmapek isi sising, neng lo ru i nenge Farasi ma neng i nenge tom kep takiis. ");
INSERT INTO bjp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasi ae ka sotih ke ka sising isi i tom aragii, ‘God, ia fotrokap lo wo wara le biil ia arae fale fanu: Foron tom sisii, foron tom tel sinang laulau, foron tom tel sinangun puur ke biil sabin ia arae tom kep takiis igii. ");
INSERT INTO bjp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fawu ia fafel la na nenge wik ke ia ka ta itikii la tina nenge sangful na foron tier tikii ae ia fatapiek u la.’ ");
INSERT INTO bjp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Isau le tom kep takiis ae i soti tapak. Biil i ier isi tar una kukulii, isau le ka pose na matan mangia ke ka tarah, ‘Kiskam God, on mais iau, ia tom tel sinang laulau.’ ");
INSERT INTO bjp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ia fas gam, tom kep takiis ae, aunbiing i fis una fel kia, ka tortores ta na mata God ma neng biil. Wara le se i falaumet u tom, God in fasabiro u. Ma se i fasabiro u tom, God in falaumet u.” ");
INSERT INTO bjp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Fale fanu ri ka kaf foron mirmiriiu sabin usuf Iesu isi in luun lima lo ri. Isau le aunbiing berberat na fafausum kia ri ka par u, ri ka fakiing ri. ");
INSERT INTO bjp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Isau le Iesu ka fakam isi berberat ke ka tarah, “Gamen sok ufu birbiron berberat usuf iau. Gong gam tikale ri. Wara le matanfuntih ke God, ken fanu ae ri arae berberat igii. ");
INSERT INTO bjp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tekentu kanaka ia fas gam, male tikas i ier isi kau na matanfuntih ke God, isau le biil i arae fabiro kalalik, biil tom ifasi in kau.” ");
INSERT INTO bjp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nenge famfamu ka diik Iesu aragii, “Rokap na Tom Fafausum, sani ian tel u isi iak kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ke Iesu ka kiliis u aragii, “Isi sani o ka foteng iau le ia rokap? Biil tikas i rokap, God keskes sau. ");
INSERT INTO bjp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O ka usum ta na foron nagogon: ‘Gong o tel sinangun puur, gong o siimete tikas, gong o suksukuum, gong o tiu foes tikas, on bulat lo tamam ru e tinam.’” ");
INSERT INTO bjp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ke kaltu ae ka kiliis u aragii, “Tipes u na aunbiing ia kalalik, papang igii, ia misuut la tom na foron nagogon tikii igii.” ");
INSERT INTO bjp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aunbiing Iesu i ongen u, ka tara sing i aragii, “Nenge tier biitom o pongpong isi. On sufii tikii foron minmaram ma pitkalang lo, ok ta u usuf foron lauu. Male on tel u arae, kiam e minsik buuii na kukulii. Namih ok fis ke ok mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aunbiing i ongen u arae, ka purngis e bala, wara le ifuun kanaka e minmara. ");
INSERT INTO bjp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu ka par kaltu ae ke ka tarah, “I ngangaten kanaka isi fanu ae ifuun e minsik kiri, rin kau na matanfuntih ke God! ");
INSERT INTO bjp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tekentu, i ngangaten usuf kamel isi in kau na solsol na nil una somap, isau le i ngangaten kanaka tom usuf kaltu ae ifuun e minsik kia isi in kau na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Fanu ae ri ongen orek ae, ri ka diik aragii, “Male i arae, ke se mang ifasi in kep liu fitliu?” ");
INSERT INTO bjp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ke Iesu ka kiliis ri aragii, “Sani ae fanu biil ifasi rin tel u, God ifasi in tel u.” ");
INSERT INTO bjp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita ka tara sing i aragii, “Par u! Keme ka la koseng ta foron tier tikii kimem, isi kemen mi lo wo.” ");
INSERT INTO bjp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu ka tara sing ri aragii, “Tekentu kanaka ia fas gam, se i la koseng fel kia, le koseng antu, le koseng foron tualik, le koseng tama ru e tina, le koseng berberat kia, iwara na matanfuntih ke God, ");
INSERT INTO bjp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sani in kep u na aunbiing i liu biitom, in fuun kanaka mang tom na sani i la koseng ta u. Ke na liu ae namih, in liu fitliu.” ");
INSERT INTO bjp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu ka lame pes sangful ini u e kalalik na fafausum kia una baba ke ka tara sing ri aragii, “Par u, igii kerek tatkau mang una Ierusalem ma foron tier tikii ae foron profet ri siit ta u le in tapiek lon Kalalik ken Kaltu, ik suut mang. ");
INSERT INTO bjp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Rin ta ufu na liman fanu ae biil ri fan Iudaia ke rik morot ini, rik orek laulau ulo, rik ubis u, rik pis u ke rik siimete u. ");
INSERT INTO bjp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Isau le na fatuul u e biing ik apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Berberat na fafausum biil tom ri malal na ti tier ae i use u. Kamtinan orek ae i mumun lo ri ke biil ri usum na sani i use u. ");
INSERT INTO bjp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aunbiing Iesu fatat in tapiek na Jeriko, nenge kut i kiis ta na bulin sal ma ka famam sising fanu. ");
INSERT INTO bjp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aunbiing ka ongen gur na fanu ae ri lala fatat u, ka diik aragii, “Be, sani aragii?” ");
INSERT INTO bjp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ke ri ka kiliis u aragii, “Iesu tina Nasaret apiek.” ");
INSERT INTO bjp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ke kut ae ka tautau aragii, “Iesu, kalalik ke Dewit, on mais iau!” ");
INSERT INTO bjp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Fanu ae ri famfamu la ri ka fakiing u isi in kiis fofo. Isau le ka lala tautau mang tom aragii, “Kalalik ke Dewit, mais iau!” ");
INSERT INTO bjp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu ka soti ke ka tara le rin lame u usuf i. Aunbiing ka la fatat, Iesu ka diik u aragii, ");
INSERT INTO bjp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Sani o ier le ian tel u ini wo?” Ke kut ae ka kiliis u aragii, “Kumguui, ia ier la ian par.” ");
INSERT INTO bjp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ka tara sing i aragii, “On par! Unune kiam tom ka faliu ta wo.” ");
INSERT INTO bjp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Fanpil ka par ke ka mi lo Iesu ini ususefages usuf God. Ke fanu tikii ae ri par sani i tapiek tah, ri sabin ri ka usefages God. ");
INSERT INTO bjp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu i kau na Jeriko ma ka liu ufu. ");
INSERT INTO bjp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nenge kaltu aiwa, asa e Sakias. I nenge famfamu ken foron tom kep takiis ma ifuun e minsik kia. ");
INSERT INTO bjp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I ier le in par u le Iesu i e seh. Isau le, i fatukli ma biil ifasi in par u, iwara na gur na fanu. ");
INSERT INTO bjp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pesu ka filau famu ke ka fen na nenge au ae ri foteng u ini sikamo, isi in par Iesu, wara le Iesu in la lo e sal ae. ");
INSERT INTO bjp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aunbiing Iesu ka tapiek na falifu ae, ka tar ke ka tara sing i aragii, “Sakias, pu sape! Wara le igii, ian kiis na fel kiam.” ");
INSERT INTO bjp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Fanpil Sakias ka puh ke ka somangat pes u ini laes. ");
INSERT INTO bjp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Fanu tikii ri par u ke ri ka ngurngurngur aragii, “I tapiek ses ken nenge tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Isau le Sakias ka sotih ke ka tara sing Kumguui aragii, “Kumguui, par u, igii ian ta baban minmarang kuruur usuf foron lauu. Male ia ka fabal pes ta ti tier sing tikas ke fafet ian kiliis fafis u.” ");
INSERT INTO bjp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ke Iesu ka tara sing i aragii, “Igii tom, fafaliu i tapiek na matanfel igii, wara le kaltu sabin igii, i nenge tubutamat e Abaram. ");
INSERT INTO bjp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wara le Kalalik ken Kaltu i tapiek isi im isi fanse ae ri rong tah ke isi faliu ri.” ");
INSERT INTO bjp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aunbiing fanu ri ongongen orek la igii, ka fas ri sabin ini nenge orek fatoftof. Ke ri ka wol le matanfuntih ke God fatat in tapiek, wara le Iesu ka la fatat Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","I fas ri aragii, “Nenge tara kaltu i geges isi in la una nenge falifu tapak isi ik kep as arae king ke nami ik fis. ");
INSERT INTO bjp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka kam pes i sangful e fafauun kia ke ka ta i sangful e mina usuf ri ke ka tarah, ‘Gamen foimnge u isi ik mel e kubu, papang na biing ian fis.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Isau le fanu tom tina maleh kia ri ememse u ke ri ka wuun fale fanu nami isi rin tara le, ‘Biil keme ier isi kaltu igii in tapiek king kimem.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ka tapiek king tah ke ka fis una maleh kia. Ka fawuun isi foron fafauun ae i ta ta pitkalang usuf ri isi ik usum na ifis e kubu ri ka fatapiek ta u. ");
INSERT INTO bjp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Fafauun famu ka tapiek ke ka tarah, ‘Ier, ka sangful sabin e mina na olon mina kiam.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ke ka kiliis u aragii, ‘Rokap kanaka, o nenge rokap na fafauun! Wara le o tel fasuut fabiro foim ae ia unune ufu ta usuf o, ke igii ian luun o isi ok nagogon in sangful e maleh.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ke fawu u ka tapiek ke ka tarah, ‘Ier, ka lim sabin e mina na olon mina kiam.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ke ka kiliis u aragii, ‘O sabin on nagogon in lim e maleh.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ke fatuul u ka tapiek ke ka tarah, ‘Ier, par u, igii tom e mina kiam. Ia afit u ini nenge dangan kaen ke ia ka luun fakasi ta u tom. ");
INSERT INTO bjp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ia soke wo, wara le o luun rakrakai na nagogon la na olon foron fafauun kiam. O kep foron tier la ae biil o luun ta u ke o ka il inen la ae biil o so ta u.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ke tara kaltu ae ka kiliis u aragii, ‘O fafauun laulau! Ian nagogon o namin foron orek kiam tom. O usum le ia luun rakrakai na nagogon la na olon foron fafauun kiak. Ia kep foron tier la ae biil ia luun ta u, ke ia ka il inen la ae biil ia so ta u. ");
INSERT INTO bjp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Isi sani biil o luun ta pitkalang kiak na felun luun pitkalang, isi aunbiing ian fis, iak kep fafis u ini ti kubu?’ ");
INSERT INTO bjp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ke ka tara sing fanu ae ri soti fatat aragii, ‘Kep ufu mina ae sing i, ma gamek ta u usuf ier ae i pose na itikii e sangful.’ ");
INSERT INTO bjp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Isau le ri ka kiliis u aragii, ‘Ier, ka mel ta e nenge sangful ae sing i!’ ");
INSERT INTO bjp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ka kiliis ri aragii, ‘Ia fas gam, se ae ka mel ta sing i, rin ta tifal biitom sing i. Ma se ae biil tikas sing i, ituul ae sing i, rin tel ufu. ");
INSERT INTO bjp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Isau le foron tuui kiak ae biil ri ier isi ian tapiek king kiri, gam tel pes ri uga ma gamek siimete ri aga na matang.’” ");
INSERT INTO bjp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aunbiing Iesu ka use ta foron orek fatoftof igii, ka famu lo ri ubase na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aunbiing ka la fatat Betfage ke Beteni na pungpung ae ri foteng u ini Pungpung na Olif, ka wuun ufu iwu e kalalik na fafausum kia ini orek igii, ");
INSERT INTO bjp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kamu la una maleh ae na famu lo kamuh. Aunbiing kamun tapiek, kamun par nenge fabiro dongki ae biil biitom tikas i kiis lo, ri kabet ta u aiwa. Puk ufu ke kamuk tangne u uga. ");
INSERT INTO bjp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Male tikas in diik kamu le, ‘Isi sani kamu ka puk ufu?’ ke kamun kiliis u le, ‘Kumguui imel e foim kia lo.’” ");
INSERT INTO bjp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Uner ae Iesu i wuun ta ruh, ru ka la ke ru ka tafe u tom arae Iesu i fas ta ruh. ");
INSERT INTO bjp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma aunbiing ru ka pukpuk fabiro dongki la ae, taman dongki ae ka diik ru aragii, “Kamu puk ufu dongki ae isi sanih?” ");
INSERT INTO bjp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ke ru ka kiliis u aragii, “Kumguui imel e foim kia lo.” ");
INSERT INTO bjp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ru ka tangne u usuf Iesu ke ru ka sol ini iun dolon kaen kiru na olon dongki ae ma ru ka fakiis Iesu na olo. ");
INSERT INTO bjp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aunbiing ka toltole sal la, fanu ri ka sol ini foron dolon kaen kiri tole sal. ");
INSERT INTO bjp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aunbiing ka la fatat na falifu ae sal i pu tina Pungpung na Olif, tara gur na berberat na fafausum, ri tikii ri ka tipes usefages God ini laes isi foron tier an fabitit tikii ae ri ka par ta u ma ri ka kukuk aragii: ");
INSERT INTO bjp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Fafakalok usuf king ae i la uga ini asa Kumguui!” “Siaroh ubae na kukulii ma memeh ubae kanaka na mawe!” ");
INSERT INTO bjp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Fale Farasi aiwa na palgan gur ae, ri ka tara sing Iesu aragii, “Tom fafausum, fakiing berberat na fafausum kiam!” ");
INSERT INTO bjp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ke Iesu ka kiliis ri aragii, “Ia fas gam, male rin babat na ngusri, ke foron fat rin kukuk.” ");
INSERT INTO bjp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Aunbiing Iesu ka la fatat Ierusalem, ka par u ke ka tingis u. ");
INSERT INTO bjp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ka tarah, “Ierusalem, male ok usum ta sau na sani ae in ta siaroh usuf o na biing igii, ke in rokap. Isau le i mumun na matam. ");
INSERT INTO bjp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Fale biing in tapiek, ae foron tuui kiam rin fiti ti ubiif kale o, rin kawil o ma rik sit o tina foron babam tikii. ");
INSERT INTO bjp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Rin faleplep o na nanal, wo turan berberat ae lo wo. Biil rin sok ufu ti fat isi ik borong na olon neng, wara le biil o iliim aunbiing God i tapiek naisam.” ");
INSERT INTO bjp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu ka kau na palgan ubiif kale Felun Tunmapek ke ka fes fasuu fanu ae ri famam sufii foron tier isi fanu rik fiil u. ");
INSERT INTO bjp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ke ka fas ri aragii, “Ri siit ta u na Buk na Gogoh aragii, ‘Fel kiak in fel una sising,’ isau le gam ka tel u bin arae ‘salan mumumun ken foron tom sisii.’” ");
INSERT INTO bjp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Foron biing tikii Iesu i fausum fanu la na Felun Tunmapek. Isau le foron laulaumet na pris, foron tom fafausum ini nagogon turan foron famfamu ken fanu ri ka famam im sal una siimete u. ");
INSERT INTO bjp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Isau le ri im pane isi ti sal una siimete u, wara le fanu tikii ri lala ier tom isi ongen foron orek kia. ");
INSERT INTO bjp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nenge biing, aunbiing Iesu i fafausum fanu la ke ka famam fafas ini Rokap na Fafas na palgan ubiif kale Felun Tunmapek, foron laulaumet na pris, foron tom fafausum ini nagogon ke foron famfamu ri ka la usuf i, ");
INSERT INTO bjp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ma ri ka diik u aragii, “Fas kemem, rakrakai tinga o tel foron tier igii ini? Ma se i ta u e rakrakai igii sing o?” ");
INSERT INTO bjp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu ka kiliis ri aragii, “Ia sabin ian diik gam ini nenge fagalte. Gam fas iau, ");
INSERT INTO bjp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","bapitaiso ke Jon, tinbae na kukulii le sing fanu sau?” ");
INSERT INTO bjp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ke ri ka ngurke u tom na fatpoto ri aragii, “Male keren tara le tinbae na kukulii, ke in diik kerer le, ‘Isi sani biil gam unune lo?’ ");
INSERT INTO bjp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Isau male keren tara le, ‘sing fanu,’ ke fanu rin luumete kerer. Wara le fanu tikii ri unune tom le Jon i e nenge profet.” ");
INSERT INTO bjp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ke ri ka kiliis u sau aragii, “Biil keme usum le tingah.” ");
INSERT INTO bjp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu ka fas ri aragii, “Iau sabin, biil ian fas gam le rakrakai tinga ia tel foron tier igii ini.” ");
INSERT INTO bjp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu ka fas fanu sabin ini orek fatoftof igii: “Nenge kaltu i so nenge porpor wain ke ka ta u usuf fale tom foim isi rin parpar kale ta bii lo ma ka la na nenge ninla ma biil i to fis sape. ");
INSERT INTO bjp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na taul lulus, ka wuun nenge fafauun usuf foron tom foim ae, isi rik ta ti fale fuan wain tina porpor wain. Isau le foron tom foim ri ka pakti ke ri ka wuun fafis u ini lima kanan sau. ");
INSERT INTO bjp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ke ka wuun ufu nenge fafauun kia sabin, ri ka pakti, ri ka famatlawen u ke ri ka wuun fafis u sabin ini lima kanan sau. ");
INSERT INTO bjp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Namih, ka wuun ufu fatuul u e fafauun ke ri ka paket falaulau u ke ri ka lin fasuu u. ");
INSERT INTO bjp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ke taman porpor wain ae ka tarah, ‘Sani ian tel u? Ian wuun keng kalalik ae ia ier kanaka isi. Awii ngan rin bulat lo.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Isau le aunbiing foron tom foim ae, ri par u, ri ka put orek aragii, ‘Ier igii, in ti kiliis tama. Kerek siimete u, isi kirer mang e porpor wain igii, ae tama i fakale ta u ini.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ri ka luu suu ini tina porpor wain ae ke ri ka siimete u. “Sani sabin taman porpor wain ae ik tel u ini ri? ");
INSERT INTO bjp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In la ma ik siimete foron tom foim ae ke ik ta porpor wain ae usuf fale fanu keskes.” Aunbiing fanu ae ri ongen orek igii, ri ka tarah, “Biil tom!” ");
INSERT INTO bjp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu ka par tortores usuf ri ke ka tarah, “Ke sani e kamtinan orek ae ri siit ta u na Buk na Gogoh ae i tarah, ‘Tuh ae foron tom tel fel ri puris ta u ka tapiek temin tuh.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Fanu tikii ae ri luut una tuh ae rin burburngih ma se ae tuh igii i luut na olo, in pekpekes.” ");
INSERT INTO bjp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Foron tom fafausum ini nagogon turan foron laulaumet na pris ri ka im sal isi luse Iesu na aunbiing tom ae, wara le ri usum le i use orek fatoftof igii ulo ri. Isau le ri soke fanu. ");
INSERT INTO bjp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Foron tom fafausum ini nagogon turan foron laulaumet na pris ri ka luun matri lo Iesu. Ke ri ka wuun fakum fale fanu isi rin ongen u. Rin garan le ri foron tom tortores, isi rik tatakuun pes u ini ti orek ae in use u, isi rik ta u na liman laulaumet tina Rom ma ik nagogon u. ");
INSERT INTO bjp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ke fanu ae ri wuun ta ri, ri ka diik Iesu aragii, “Tom fafausum, keme usum le orek turan fafausum kiam i tortores. Fafausum kiam i fafasi sau usuf fanu tikii ma o fausum tekentu ri la tom ini sinangu God. ");
INSERT INTO bjp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Arafah, i tortores le keren fiil takiis usuf Sisar, le biil?” ");
INSERT INTO bjp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka iliim ta garan kiri, pesu ka tara sing ri aragii, ");
INSERT INTO bjp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Finngas iau ini ti dinaria. Tantanwa se ke asa se igii lo?” ");
INSERT INTO bjp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ke ri ka kiliis u aragii, “Sisar.” Ka fas ri aragii, “Pesu, sani ke Sisar, ta u usuf Sisar, ma sani ke God, ta u usuf God.” ");
INSERT INTO bjp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Biil ifasi rin tatakuun pes u ini orek ae i use u na matan fanu. Ma ri ka bitit na orek ae i kiliis ri ini ke ri ka babat na ngusri. ");
INSERT INTO bjp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Fale Sadusi ae ri use u la le biil ti apaptifis, ri ka la usuf Iesu ini nenge fagalte ke ri ka tarah, ");
INSERT INTO bjp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tom fafausum, Moses i siit ta u usuf kerer aragii, ‘Male nenge kaltu i met koseng antu ma biil ti kalalik kiruh, ke tualik in telpes makos ae, isi ik fapuar ti berberat ke tualik ae ka met tah.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nenge ifit latualik, neng famu i fakekel ta ke ka met koseng antu, ma biil ti kalalik kiruh. ");
INSERT INTO bjp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Fawu u, ");
INSERT INTO bjp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ke fatuul u sabin arae. Ifit latualik tikii ae, ri telpes ta fifin ae, ke ri ka met ma biil ti kalalik kiri. ");
INSERT INTO bjp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Namih, fifin sabin ae ka met. ");
INSERT INTO bjp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ke, na biingen apaptifis, fifin ae in antu se tutus mang lo ri? Wara le ri fit tikii, ri telpes ta u.” ");
INSERT INTO bjp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ke Iesu ka kiliis ri aragii, “Na liu igii, fanu ri fakekel la. ");
INSERT INTO bjp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Isau le na liu ae namih, fanu ae ri tortores isi rin apti fis tina minet, biil rin to fakekel sabin, biil. ");
INSERT INTO bjp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ke biil sabin rin met, wara le rin arae foron angelo. Ri berberat ke God, wara le ri ka apti fis ta tina minet. ");
INSERT INTO bjp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses sabin i finngas ta u le foron minet rin apti fis, wara le, na ususe na au ae i sok, i foteng Kumguui le, ‘God ke Abaram, God ke Aisak ke God ke Jekop.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God biil i God ken foron minet, biil. I God ken fanu ae ri liu, wara le na mata, ri tikii ri liu.” ");
INSERT INTO bjp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Fale tom fafausum ini nagogon ri ka tarah, “Tom fafausum, i rokap kanaka e orek kiam!” ");
INSERT INTO bjp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ke ri ka binbin le rin diik u sabin ini ti fagalte. ");
INSERT INTO bjp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu ka diik ri aragii, “Isi sani ri ka tara le Mesaia i e kalalik ke Dewit? ");
INSERT INTO bjp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Wara le Dewit tom i use u na Buk Seksek aragii: ‘Kumguui God i tara sing Kumguui kiak: Kiis na miang, ");
INSERT INTO bjp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","papang na aunbiing ian luun foron tuui kiam na piklin kekem.’ ");
INSERT INTO bjp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit i foteng ta Mesaia le Kumguui kia. Male i arae, ke in tapiek kalalik ke Dewit arafah?” ");
INSERT INTO bjp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aunbiing fanu tikii ri ongongen orek la ke Iesu, ka tara sing berberat na fafausum kia aragii, ");
INSERT INTO bjp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gamen tumarang lon foron tom fafausum ini nagogon. Ri ier la isi rin soleng fanu ini foron rokap na kilkiliis ke ri ier la isi fanu rin faorek pes ri ini bulat na foron salan la turim ken fanu. Ma ri ier isi kiis la tom na foron nian kiiskiis kausi na foron felun lotu ke na foron nian kiiskiis ken foron laulaumet na foron tel inen. ");
INSERT INTO bjp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ri farop minmaran foron makos la, ke ri ka tel foron dolon sising la isi fanu rik par ri. Matngan fanu arae, in laumet kanaka e fangungut rin kep u.” ");
INSERT INTO bjp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Aunbiing Iesu i giliim, ka par fanu ae ifuun e minsik kiri ri famam luun pitkalang na salan luun pitkalang na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ke ka par nenge lauu na makos sabin, i luun iwu e fabiro pitkalang. ");
INSERT INTO bjp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ke Iesu ka tarah, “Tekentu kanaka ia fas gam, lauu na makos igii i ta tara pitkalang lon fanu tikii igii. ");
INSERT INTO bjp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Fanu tikii igii ri ta fafen kiri tina piran minsik kiri. Ma makos igii, i lauu, isau le i ta ufu foron tier tikii ae in fasi na kiis kia.” ");
INSERT INTO bjp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Fale berberat na fafausum kia ri famam paeng Felun Tunmapek la, le ri me ta u ini foron rokap na fat ke ini foron fafen ae ri ta ta u usuf God. Isau le Iesu ka tarah, ");
INSERT INTO bjp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Foron tier igii gam par u, nenge aunbiing in tapiek ae biil mang in tikii e fat in borong na olon neng. Rin lin sabalke ri tikii.” ");
INSERT INTO bjp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ke ri ka diik Iesu aragii, “Tom fafausum, nangis foron tier igii in tapiek? Ke matngan fakileng arafa in finngas u le foron tier igii, fatat in tapiek?” ");
INSERT INTO bjp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ka kiliis ri aragii, “Gamen tumarang, tarama tikas ka fabal gam. Wara le in fuun rin la ini asang ma rik use u lo ri tom le, ‘Iau e Mesaia,’ ma rik tara le, ‘Aunbiing ka fatat.’ Isau le gong gam mi lo ri. ");
INSERT INTO bjp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Aunbiing gam ongen ususe na foron fapaket ke fale falifu i rigorigo, gong gam nangnangih, wara le foron tier ae in tapiek famu, isau le farfarop na biing biil biitom in tapiek sape.” ");
INSERT INTO bjp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ke ka fas ri sabin aragii, “Nenge funmat in fapaket turan nenge funmat ke nenge matanfuntih in fapaket turan nenge matanfuntih. ");
INSERT INTO bjp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Piran gih turan fitol ke pirpiran sasem in tapiek na fale maleh ke marmarsan tier ae in fasoksoke fanu ke piran fakileng tinbae na bat in tapiek. ");
INSERT INTO bjp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aunbiing foron tier ae biil biitom in tapiek, ke rin luse gam ma rik ta fangungut usuf gam. Rin nagogon gam na foron felun lotu kiri ma rik luun gam na kamkabet. Rin fasoti gam na matan foron king ke foron famfamu na matanfuntih, i wara na asang. ");
INSERT INTO bjp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Aunbiing foron tier ae in tapiek lo gam, ke in rokap na aunbiing kimi una famalal iau usuf ri. ");
INSERT INTO bjp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Isau le gong i fik e balmi isi orek arafa gamen orek kale gam ini, ");
INSERT INTO bjp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","wara le iau tom ian ta orek turan rokap na wolwol usuf gam, isi foron tuui kimi biil ifasi rin panpan ufu ke biil ifasi rin fakawe ufu. ");
INSERT INTO bjp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Foron teumi turan foron tinmi, foron tualik gam, foron sikinting lo gam turan foron talmi tom rin ta ufu gam na liman foron tuui ke rik siimete fal lo gam. ");
INSERT INTO bjp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Fanu tikii rin ememse gam, iwara na asang. ");
INSERT INTO bjp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Isau le biil in tikii e olmi tina paklu gam in mangmangal. ");
INSERT INTO bjp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Male gam tifat, ke gamen kep liu. ");
INSERT INTO bjp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Aunbiing gamen par foron tom fapaket rin kawil Ierusalem, ke gamek usum le fatat ik laulau. ");
INSERT INTO bjp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na aunbiing ae, fanse ae na falifu na Iudaia, rin fin una foron pungpung. Ke fanu ae na Ierusalem rin fin suuh ma fanu ae ri mel fatat Ierusalem, biil rin kau una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wara le aunbiing ae, in aunbiing una kep fangungut isi foron orek tikii ae ri siit ta u na Buk na Gogoh ik suut. ");
INSERT INTO bjp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kiskam kanaka sing foron tian ke kelefin ae ri fasfasus na aunbiing ae. Tara tatawin in tapiek na nanal na Israel ma ngaliaf ke God in luut na olon fanu igii. ");
INSERT INTO bjp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Rin siimete fal ini popok una fapaket ma rik dat fal isi kamkabet na fale falifu keskes. Fanu ae biil ri fan Iudaia rin fosfose Ierusalem, papang na biing, aunbiing ken fanu ae biil ri fan Iudaia ik rop. ");
INSERT INTO bjp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“In mel e fakileng in tapiek bae na pisiih, na funiil ke na foron keltot. Ma aga na piklinbat, foron funmat tikii in fik e balri ma rik nangnangih kunan kinen tuun ke piran panaf. ");
INSERT INTO bjp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","In taltal e matan fanu ini sokeh ke ik fik e balri le sani in tapiek na piklinbat, wara le foron tier buuii na bat rin nut. ");
INSERT INTO bjp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na aunbiing ae, fanu rin par Kalalik ken Kaltu in tapiek na laukaf ini rakrakai ke ini tara memeh kia. ");
INSERT INTO bjp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aunbiing foron tier ae in tanwaran tapiek, gamen sotih ma gamek tar ini gesges, wara le biing una fasengsegeng gam ka fatfatat la mang.” ");
INSERT INTO bjp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu ka fas ri ini nenge orek fatoftof aragii: “Gam par au na fik turan fale au sabin. ");
INSERT INTO bjp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aunbiing gam par foron awu ka tampalas, gamen usum le foron funiil ae falifu i tuntun la ka fatat. ");
INSERT INTO bjp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ifasi sabin arae, aunbiing gam par foron tier ae ia use ta u i taptapiek la, ke gamek usum le matanfuntih ke God ka fatat. ");
INSERT INTO bjp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tekentu kanaka ia fas gam, fanu na ulul igii biil biitom rin mangmangal, ke foron tier tikii igii ik tapiek. ");
INSERT INTO bjp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kukulii ke piklinbat run mangmangal, isau le foron orek kiak biil in to mangmangal. ");
INSERT INTO bjp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Gamen tumarang, tarama sinangun umin dan rakrakai ke talos, ke mamais isi foron tier tina piklinbat ka fatel gam ma biing ae ka fabitit gam arae kuun. ");
INSERT INTO bjp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wara le biing ae in tapiek lon fanu tikii ae ri liu aga na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Fitliu gamen geges ke gamek sising, isi ifasi gamek alfe foron tier tikii ae fatat in tapiek, ke isi ifasi gamek soti na mata Kalalik ken Kaltu.” ");
INSERT INTO bjp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Foron biing tikii, Iesu i fausum fanu la na Felun Tunmapek. Ma na foron efef tikii ka tatkau la una pungpung ae ri foteng u ini Pungpung na Olif ma ka kiis la aiwa na foron wor. ");
INSERT INTO bjp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma na foron biingbiing saksak, fanu tikii ri la la usuf i, isi ongen u na Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ka fatat e aunbiing isi ngasa ae ri foteng u ini Beret ae biil ti is lo, ri foteng u sabin ini Ngasa na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Foron laulaumet na pris turan foron tom fafausum ini nagogon ri ka famam im sal una siimete Iesu, wara le ri soke fanu. ");
INSERT INTO bjp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ke Satan ka susuef lo Iudas ae nenge asa sabin e Iskariot, i neng lon sangful ini u e kalalik na fafausum. ");
INSERT INTO bjp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ka la usuf foron laulaumet na pris turan foron laulaumet ken foron tom parpar kale Felun Tunmapek ke ka pidai orek tura ri arafa in ta ufu Iesu arae usuf ri. ");
INSERT INTO bjp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ri ka lala laes ke ri ka somangat le rin suat u. ");
INSERT INTO bjp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ke Iudas ka mangat ke ka im isi ti rokap na aunbiing ae biil ti fanu fuun lo, isi ik ta ufu Iesu usuf ri. ");
INSERT INTO bjp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na biingen Ngasa na Beret ae biil ti is lo, ae ri siimete natun sipsip la una Ngasa na Liuliu Kulef, ");
INSERT INTO bjp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu ka wuun ufu Pita ru e Jon ke ka fas ru aragii, “Kamu la ma kamuk fageges inen arer una Ngasa na Liuliu Kulef.” ");
INSERT INTO bjp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ke ru ka diik u aragii, “Fia o ier isi kaman fageges u wah?” ");
INSERT INTO bjp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ka kiliis ru aragii, “Aunbiing kamun tapiek na Ierusalem, nenge kaltu ae i kusep nenge luunluun dan in tafe kamuh. Kamun mi lo una fel ae in kau lo, ");
INSERT INTO bjp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ke kamuk diik taman fel ae aragii, ‘Tom fafausum i diik le, fiawa e falifu ae i turan berberat na fafausum kia rin ien inen na Liuliu Kulef lo?’ ");
INSERT INTO bjp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ke in finngas kamu ini nenge tara sun fel, bae na mawe na fel, ae ri ka tumarnge ta u. Kamun fageges inen aiwa.” ");
INSERT INTO bjp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ru la ke ru ka tafe foron tier tikii arae tom Iesu i fas ta ru ini. Ke ru ka fageges inen na Liuliu Kulef aiwa. ");
INSERT INTO bjp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aunbiing ka fasi mang, ke Iesu turan foron aposel kia ri ka kiis turim isi ien. ");
INSERT INTO bjp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ke ka fas ri aragii, “Imel e tara wolwol kiak ta tom le ian ien inen na Liuliu Kulef igii tura gam, aunbiing biil biitom ia kalsakai fangungut. ");
INSERT INTO bjp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wara le, ia fas gam, biil sabin ian ien ti inen na Liuliu Kulef, papang na aunbiing kamtina tutus ik suut na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iesu ka kep nenge kap na wain, ka fotrokap lo ke ka tarah, “Gam kep u ma gamek famir ini. ");
INSERT INTO bjp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wara le, ia fas gam, biil sabin ian umin danun wain igii papang na aunbiing matanfuntih ke God ik tapiek.” ");
INSERT INTO bjp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iesu ka kep beret, ka fotrokap lo usuf God ke ka simsibik u ma ka ta u usuf ri. Ke ka tarah, “Igii e pununfong, ae ia ta u usuf gam. Gamen tel u aragii una namnamne tirik isi iau.” ");
INSERT INTO bjp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aunbiing ri ka ien tikii tah, ka tel u sabin arae na kap na wain. Ka kep u ke ka tarah, “Kap igii, i e puput fuuh na daung ae i ring isi gam. ");
INSERT INTO bjp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Isau le, par u, liman kaltu ae in ta ufu iau, igii na olon luuf turang. ");
INSERT INTO bjp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kalalik ken Kaltu in met arae tom God ka ninwei ta u. Isau le kiskam kanaka sing ier ae in ta ufu una liman foron tuui.” ");
INSERT INTO bjp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ke ri ka fadiik fis tom ini ri le, se tom ifasi in tel u arae. ");
INSERT INTO bjp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ke ri ka fakep ini orek na fatpoto ri le, se tom lo ri, ri par u le in laumet kanaka. ");
INSERT INTO bjp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke Iesu ka tara sing ri aragii, “Gam usum le foron king ken fanu ae biil ri fan Iudaia, ri lala nagogon fanu la. Ma foron famfamu kiri ae ri luun foron rakrakai na nagogon ulo ri, ri ier isi rin foteng ri le, ri foron rokap na tom falupes. ");
INSERT INTO bjp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Isau le, gong gam arae ri. Se i laumet na fatpoto gam, in arae kalalik. Ma famfamu, in arae nenge tom foim. ");
INSERT INTO bjp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gam wol le se i laumet? Ier ae i kiis nene isi ien, le ier ae i sosok la? Ier ae i kiis nene isi ien, bikiih? Isau le iau, ia kiis na fatpoto gam arae ier ae i sosok la. ");
INSERT INTO bjp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gam ti ta turang na foron fatoftof ae i tapiek ta lo iau. ");
INSERT INTO bjp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Arae Tata i ta ta matanfuntih usuf iau, ke ian somangat ufu gam ");
INSERT INTO bjp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","isi gamen ien ma gamek yin turang na luuf una ien kiak na matanfuntih kiak. Ke gamek kiis na foron nian kiiskiis una nagogon nenge sangful ini u e mat tina Israel.” ");
INSERT INTO bjp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ke Iesu ka tarah, “Saimon, Saimon! Par u, Satan ka sising ta isi in tof gam arae kaltu ae i simke ufu piin tina wit. ");
INSERT INTO bjp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Isau le ia ka sising ta isi wo Saimon, isi unune kiam gong i luut. Ma aunbiing o ka sokiliis ta liu kiam, ke ok farakrakai foron tuamlik.” ");
INSERT INTO bjp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita ka kiliis u aragii, “Kumguui, ia geges isi ian la turam una kamkabet ke isi met turam.” ");
INSERT INTO bjp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ke Iesu ka tara sing i aragii, “Pita, ia fas o, agii, aunbiing to biil biitom in teng, ke fatuul ok fakawe le biil o usum lo iau.” ");
INSERT INTO bjp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ke Iesu ka diik ri aragii, “Aunbiing ia wuun ta gam, ke ia ka fas ta gam le gong gam kep ti pauus na pitkalang, le ti sara, le ti su, ke arafah, gam dar ta ti tier?” Ke ri ka kiliis u aragii, “Auuh, biil.” ");
INSERT INTO bjp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ka tara sing ri aragii, “Isau le igii, se imel e pauus kia, in kep u ke sara sabin. Male se biil ti popok kia una fapaket, in sufii dolon kaen kia pes pitkalang ma ik fiil tikas kia. ");
INSERT INTO bjp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ia fas gam, rin fasuut orek ae ri siit ta u na Buk na Gogoh ulo iau, aragii, ‘Ri wes fakau u turan fanu laulau.’ I tekentu, sani ae ri siit ta u ulo iau, ik suut mang.” ");
INSERT INTO bjp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Berberat na fafausum ri ka tarah, “Kumguui, par u! Iwu e popok una fapaket igii.” Ke ka kiliis ri aragii, “Ifasi.” ");
INSERT INTO bjp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu ka suu tinaiwa una Pungpung na Olif, arae tom i tel u la. Ke berberat na fafausum kia ri ka mi lo. ");
INSERT INTO bjp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aunbiing ri ka tapiek na falifu ae, ka tara sing ri aragii, “Gamen sising isi gong gam luut na fatoftof.” ");
INSERT INTO bjp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ka mamlik la koseng ri, ifasi arae nenge kaltu in luu ini ti fat. Ke ka ilepul ma ka sising aragii, ");
INSERT INTO bjp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, male o ier isi, ke ok tel ufu kap igii koseng iau. Isau le gong o mi lo arae na wolwol kiak, mi tom lo arae na wolwol kiam.” ");
INSERT INTO bjp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ke nenge angelo tinbae na kukulii ka tapiek sing i, ke ka farakrakai u. ");
INSERT INTO bjp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I kalsakai tara tatawin na liu kia, ke ka lala sising mang tom. Ma songsong na pununfo ka toroptorop arae dah una nanal. ");
INSERT INTO bjp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ka sising tikii tah ke ka fis usuf berberat na fafausum kia. Ka par u le ri masun, wara le i mut e fo ri ini mamais. ");
INSERT INTO bjp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ka diik ri aragii, “Isi sani gam ka masun? Aptih ma gamek sising, tarama gam ka luut na fatoftof.” ");
INSERT INTO bjp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aunbiing Iesu i ororek la biitom, nenge gur na fanu ri ka tapiek. Ma Iudas, neng lon sangful ini u e kalalik na fafausum kia, i famfamu la pes ri. Ka la tortores usuf Iesu isi in dor u. ");
INSERT INTO bjp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ke Iesu ka diik u aragii, “Be Iudas, on dor Kalalik ken Kaltu isi ok ta ufu na liman foron tuui?” ");
INSERT INTO bjp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aunbiing berberat na fafausum ri par sani i ier isi tapiek, ri ka tarah, “Kumguui, arafah, kemen fating ini popok una fapaket?” ");
INSERT INTO bjp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ke neng lo ri ka ting nenge fafauun ken famfamu ken foron pris, i kasim ufu balbalu na mia. ");
INSERT INTO bjp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Isau le Iesu ka tara sing ri aragii, “Gong!” Ka sigil balbalun kaltu ae, ke ka rokap fis. ");
INSERT INTO bjp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Namih, Iesu ka diik foron laulaumet na pris, foron tom parpar kale Felun Tunmapek turan foron famfamu ae ri la isi luse u aragii, “Arafah, awii ngan ia nenge tom sisiimete, ae gam ka la uga ini foron popok una fapaket turan foron kapsil? ");
INSERT INTO bjp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Foron biing tikii, ia kiis la tura gam na Felun Tunmapek ke biil gam luse iau. Isau le igii e aunbiing kimi, aunbiing kubunor i nagogon.” ");
INSERT INTO bjp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ke ri ka luse Iesu ma ri ka lame ufu una fel ken famfamu ken foron pris. Pita i mimi susu la tom. ");
INSERT INTO bjp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ri map ta nenge yiif na palgan ubiif kale fel ae ke ri ka kiis kawil u. Pita sabin i kiis tura ri. ");
INSERT INTO bjp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ke nenge tah, fafauun tina fel ae, ka par Pita i kiis ta na malal na yiif ae, ka lala kanap u ke ka tarah, “Ier igii, i la la sabin tura Iesu.” ");
INSERT INTO bjp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Isau le Pita ka fakawe ufu aragii, “Tinier, biil ia usum lo.” ");
INSERT INTO bjp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Biil i sawin, ke nenge kaltu sabin ka tara sing i aragii, “O sabin o neng lo ri.” Pita ka kiliis u aragii, “Ier, ia biil!” ");
INSERT INTO bjp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Biil i mongmong, ke nenge kaltu sabin ka rakrakai aragii, “Tekentu tom, ier igii i la la tura, wara le i nenge sikin Galili.” ");
INSERT INTO bjp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Isau le Pita ka kiliis u aragii, “Ier, biil ia to usum na sani o use u!” Aunbiing i ororek la biitom, ke nenge to ka teng. ");
INSERT INTO bjp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kumguui ka giliim ke ka par tortores usuf Pita. Ke Pita ka wolpes orek ae Kumguui i fas ta u ini aragii: “Agii, aunbiing to biil biitom in teng, ke fatuul ok fakawe ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ke Pita ka suu tinaiwa, ke ka sikpes tineng. ");
INSERT INTO bjp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Fanu ae ri parpar kale Iesu ri mormorot la ini ma ri ka pakpaket u la. ");
INSERT INTO bjp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ri ka kabet kale mata ke ri ka diik u aragii, “On orek profet, se i tut o?” ");
INSERT INTO bjp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ke ri ka use ifuun e orek laulau sabin ulo. ");
INSERT INTO bjp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aunbiing pisiih ka susupiek, foron famfamu ken fan Iudaia tikii ri ka kiis turim, foron laulaumet na pris turan foron tom fafausum ini nagogon. Ri ka fiti Iesu na matri, ma ri ka tara sing i aragii, ");
INSERT INTO bjp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Fas kemem, o Mesaia, le biil?” Ke Iesu ka kiliis ri aragii, “Male ian fas gam, ke biil ifasi gamen unune lo iau. ");
INSERT INTO bjp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ke male ian diik gam ini ti fagalte, ke biil gamen kiliis u. ");
INSERT INTO bjp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Isau le tipes u igii, Kalalik ken Kaltu in kiis na mia God ae i Rakrakai.” ");
INSERT INTO bjp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ri tikii ri ka diik u aragii, “O Kalalik ke God, beh?” Ka kiliis ri aragii, “Arae tom gam use u le iau.” ");
INSERT INTO bjp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ke ri ka tarah, “Isi sa biitom kere ka ier isi ti orek una tiu u? Kere ka ongen ta u tina ngusu tom.” ");
INSERT INTO bjp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ke foron famfamu tikii ae ri ka aptih ke ri ka lame Iesu usuf Pailat. ");
INSERT INTO bjp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ke ri ka tipes tiu u aragii, “Keme tafe ier igii, i lame fager fanu kimem, ka tikale fanu isi gong ri fiil takiis usuf Sisar ke ka tara sabin le i e Mesaia, nenge king.” ");
INSERT INTO bjp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat ka diik u aragii, “Be, o king ken fan Iudaia?” Ka kiliis u aragii, “Arae tom o use u.” ");
INSERT INTO bjp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailat ka fas foron laulaumet na pris turan gur na fanu ae aragii, “Biil ia tafe ti tier kaltu igii i tel fager u.” ");
INSERT INTO bjp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Isau le ri ka rakrakai tom aragii, “I farigorigo fanu na falifu tikii na Iudaia ini fafausum kia, tipes u na falifu na Galili, uga.” ");
INSERT INTO bjp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aunbiing Pailat ka ongen u arae, ka diik ri aragii, “Kaltu igii i nenge sikin Galili?” ");
INSERT INTO bjp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aunbiing ka usum mang le Iesu tina falifu ae i kiis na piklin nagogon ke Erot, ka wuun ufu usuf i. Wara le Erot tinaiwa na Ierusalem na aunbiing ae. ");
INSERT INTO bjp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aunbiing Erot i par Iesu, ka lala laes, wara le tinawii tom i nene la isi in par u. Ka ongen ta ususe lo, pesu ka ier isi par ti fakileng Iesu in fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ka diikdiik faikis u ini ifuun e fagalte, isau le Iesu biil i to kiliis u. ");
INSERT INTO bjp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Foron laulaumet na pris turan foron tom fafausum ini nagogon ri soti ta aiwa ma ri ka lala tiu u. ");
INSERT INTO bjp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erot turan foron tom fapaket kia ri ka mutmut orek ulo, ke ri ka morot ini. Ri ka fakilkiliis u ini nenge rokap na kaen arae ken king, ke Erot ka wuun fafis u usuf Pailat. ");
INSERT INTO bjp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Erot ru e Pailat tinpakanini ru tuui tah, isau le na biing ae, ru ka fatala mang. ");
INSERT INTO bjp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ka tawi turim foron laulaumet na pris, foron famfamu turan fanu ");
INSERT INTO bjp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ke ka tara sing ri aragii, “Gam lame kaltu igii usuf iau ke gam ka tara le i famam lame fager fanu. Ma igii, ia ka diikdiik faikis ta u na matmi ma biil ia tafe ti tier i tel fager u na foron tier ae gam tiu u ini. ");
INSERT INTO bjp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot sabin biil i tafe ti tier i tel fager u, pesu ka wuun fafis u usuf kerer. Par u, kaltu igii biil i tel fager ti tier tah, isi ik met kuna. ");
INSERT INTO bjp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Pesu, ian ta fangungut sau usuf i, ke nami iak sok ufu.” ");
INSERT INTO bjp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Isau le ri ka teme perek tikii aragii, “Siimete u! Fasuu Barabas usuf kemem!” ");
INSERT INTO bjp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ri luun ta Barabas na kamkabet, wara le i fapti ta nenge tara fapaket na Ierusalem ma i siimete ta fale fanu. ");
INSERT INTO bjp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat ka ier isi sok ufu Iesu, pesu ka faorek ri sabin. ");
INSERT INTO bjp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Isau le, ri tongon perek tom aragii, “Fakulkulik u na aupaket! Fakulkulik u na aupaket!” ");
INSERT INTO bjp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Fatuul Pailat ka faorek ri ke ka diik ri aragii, “Isi sah? Sani i tel fager ta u? Biil ia tafe ti tier ae in met kuna. Pesu, ian ta fangungut sau usuf i, ke iak sok ufu.” ");
INSERT INTO bjp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Isau le ri ka lala perek mang tom ke ri ka rakrakai tom le, “Fakulkulik u na aupaket!” Ma kukuk kiri ka ian. ");
INSERT INTO bjp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ke Pailat ka mi mang na wolwol kiri. ");
INSERT INTO bjp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka fasuu ufu Barabas, ier ae ri sising ta isi. I kiis na kamkabet, wara le i fapti ta nenge tara fapaket ke ka siimete ta fale fanu. Ke Pailat ka ta ufu Iesu, namin wolwol kiri tom. ");
INSERT INTO bjp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Foron tom fapaket ri ka lame ufu Iesu ke ri ka pose lon nenge kaltu tina Sairini asa e Saimon. I la tina nenge maleh isi in tatkau una Ierusalem. Ri ka fakuskusep u ini aupaket ke ri ka fangongos u isi in mi lo Iesu ini. ");
INSERT INTO bjp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Fanu fuun ri mimi la lo turan kelefin sabin ae ri mais u ma ri ka tingis u. ");
INSERT INTO bjp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ke Iesu ka giliim ma ka tara sing ri aragii, “Kelefin na Ierusalem! Gong gam tingis iau. Gamen tingis gam tom turan berberat kimi. ");
INSERT INTO bjp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wara le nenge aunbiing in tapiek, ke gamek tara aragii, ‘Ri kalok e foron koros ae biil ri fafang ma biil ri fasfasus la!’ ");
INSERT INTO bjp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Namih, ‘rin tara sing foron pungpung aragii, “Luut una olmem!” Ke rik tara sing birbiron pungpung aragii, “Wof kemem!” ’ ");
INSERT INTO bjp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wara le, male fanu rin tel foron tier igii aunbiing au i matek biitom, ke sani rin tel u aunbiing au ae in mang?” ");
INSERT INTO bjp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iwu e kaltu sabin, ru iun kaltu laulau, ri lame fasuu ru isi rin siimete ru tura Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Aunbiing ri ka tapiek na falifu ae ri foteng u ini Tuan Paklun Kaltu, aiwa ri ka fakulkulik Iesu turan iwu sabin e kaltu laulau na iwu e aupaket, neng na mia, ke neng na kaisa. ");
INSERT INTO bjp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ke Iesu ka tarah, “Tata, wol ufu sinang laulau kiri, wara le biil ri to usum na sani ae ri tel u.” Ke ri ka fangfang laki isi rik tem foron kilkiliis kia. ");
INSERT INTO bjp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Fanu ri soti aiwa ma ri ka alal ke foron famfamu sabin ri ka morot ini. Ri tarah, “I faliu ta fal, taftawa ik faliu fafis u tom, male i e Mesaia ke God ae i tim pes ta u.” ");
INSERT INTO bjp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Foron tom fapaket sabin ri ka la ma ri ka morot ini. Ri ka faumin u ini wain ae i mingin ");
INSERT INTO bjp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ke ri ka tara sing i aragii, “Male o king ken fan Iudaia, ke ok faliu fafis wo tom!” ");
INSERT INTO bjp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nenge sisiit sabin bae na olon aupaket kia, i tara aragii: ");
INSERT INTO bjp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Neng lon iwu e kaltu laulau ae ru kulkulik ta aiwa, ka orek laulau ulo aragii, “Be, o Mesaia? Ok faliu wo tom ke kama sabin!” ");
INSERT INTO bjp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Isau le neng ka fakiing u aragii, “Uui! Biil o soke God, beh? O kep u sabin e matngan fangungut arae i. ");
INSERT INTO bjp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Fangungut ae ri ta u usuf karah, i tortores, wara le i e fifiil na foron sinangu karah. Isau le ier igii, biil i to tel fager ta ti tier, biil.” ");
INSERT INTO bjp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ke ka tarah, “Iesu, wolpes iau aunbiing on king na matanfuntih kiam.” ");
INSERT INTO bjp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu ka fas u aragii, “Tekentu kanaka, ia fas o, igii tom on kiis turang na Paradais.” ");
INSERT INTO bjp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ifasi aragii sangful ini u e aunbiing na siat, falifu tikii ka kubunor, papang na ituul e aunbiing na efef, ");
INSERT INTO bjp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","wara le pisiih biil i to popos. Tara kaen na palgan Felun Tunmapek ka tamsih na fatpoto una iwu e danga. ");
INSERT INTO bjp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ke Iesu ka lala ngangeh aragii, “Tata, ia luun tanwang na limam.” Aunbiing ka use ta u arae, ke ka fut paket mangia. ");
INSERT INTO bjp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aunbiing kabisit ken foron tom fapaket ka par sani ae i tapiek, ka usefages God aragii, “Tekentu kanaka, kaltu igii i nenge tom tortores!” ");
INSERT INTO bjp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aunbiing fanu tikii ae ri la turim ta isi par sani i tapiek, ri ka par foron tier ae, ke ri ka pose na matan mangia ri ini mamais, aunbiing ri pipiek. ");
INSERT INTO bjp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Isau le fanu tikii ae ri usum lo Iesu turan kelefin ae ri mi ta lo tina Galili, ri soti tina tapak ma ri ka alim foron tier ae i tapiek. ");
INSERT INTO bjp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Imel e nenge kaltu asa e Josep, i tina Arimatia nenge maleh na Iudaia. I nenge rokap na kaltu ma i nenge tom tortores. ");
INSERT INTO bjp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","I nene la isi matanfuntih ke God. Taftawa le i neng lon foron famfamu ken fan Iudaia, isau le biil i to somangat na wolwol kiri ke na sani ri ka tel ta u. ");
INSERT INTO bjp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I la usuf Pailat ke ka sising u isi pununfo Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ka fapu pununfo Iesu tina aupaket ke ka afit u ini nenge rokap na kaen. Nami ka fakau u na matanfat una luun minet ae ri tuung ta u na balan fat. Matanfat ae biil biitom ri luun ti minet lo. ");
INSERT INTO bjp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Biing ae i e Biingen Geges ma fatat ik tanwara e Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kelefin ae ri la ta tura Iesu tina Galili, ri ka mi lo Josep ke ri ka par matan fat ae ma arafa ri faborong pununfo Iesu arae. ");
INSERT INTO bjp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Namih, ri ka piek una foron fel kiri ke ri ka fageges foron tier ae i furung rokap turan wel ae imel e rokap na sana. Isau le na Biingen Mangeh, ri ka mangeh namin nagogon kiri. ");
INSERT INTO bjp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na biingbiing saksak na biing famu na wik ae, kelefin ae ri ka kep foron tier ae i furung rokap ae ri fageges ta u ke ri ka la una matan fat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ri ka par u le fat tinawii na matanfat ae, ri ka fabulbulis ufu tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Isau le aunbiing ri kau, biil ri to tafe pununfo Kumguui Iesu. ");
INSERT INTO bjp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aunbiing ri wolwol la biitom tole u, fanpil, iwu e kaltu ae foron kilkiliis kiruh i kilangkilang arae pil, ru ka tipiek na baba ri. ");
INSERT INTO bjp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ri ka lala sokeh ke ri ka parau una nanal. Isau le uner ae, ru ka fas ri aragii, “Isi sah gam ka im isi ier ae i liu na fatpoton foron minet? ");
INSERT INTO bjp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mangmangal aga. Ka apti fis tah! Gamen wolpes orek ae i fas ta gam ini, aunbiing i kiis biitom tura gam na Galili. ");
INSERT INTO bjp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","I use ta u aragii, ‘Rin ta ufu Kalalik ken Kaltu una liman foron tom tel sinang laulau ke rik fakulkulik u na aupaket. Ma na fatuul u e biing, ik apti fis.’” ");
INSERT INTO bjp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ke ri ka wolpes foron orek kia. ");
INSERT INTO bjp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aunbiing ri ka fis tina matanfat ae, ri ka fas sangful ini tikii e kalalik na fafausum turan fale fanu sabin ini foron tier tikii. ");
INSERT INTO bjp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kelefin ae ri fas foron aposel ini foron tier ae, e: Maria Makdalin, Joana, Maria tina Jems ke fale kelefin sabin. ");
INSERT INTO bjp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Foron aposel ri wol le orek ken kelefin ae i orek foes sau, pesu biil ri to unune lo. ");
INSERT INTO bjp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Isau le Pita ka aptih ke ka filau una matanfat una luun minet. Ka parau ma ka par foron kaen sau tinaiwa. Ka fis ma ka lala wol tole sani i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na biing sabin ae, iwu lo ri ae ru mi la lo Iesu, ru tole sal una nenge maleh asa e Emaus. I tapak aragii sangful ini tikii e kilomita tina Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma ru ka ngurngurke foron tier tikii ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aunbiing ru ororek la biitom ma ru ka ngurngurke foron tier la ae, Iesu tom ka tapiek ma ka la tura ruh. ");
INSERT INTO bjp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Isau le matruh arae i kut, pesu biil ru par failiim u. ");
INSERT INTO bjp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka diik ru aragii, “Sani kamu ngurngurke u, aunbiing kamu toltole sal la?” Ru ka sotih ma ka mamais e matruh. ");
INSERT INTO bjp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Neng lo ruh asa e Kleopas, ka diik u aragii, “Kol, wo keskes sau lon foron ses na Ierusalem ae biil o usum na foron tier ae i tapiek ta na foron biing igii?” ");
INSERT INTO bjp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka diik u aragii, “Foron sanih?” Ke ru ka kiliis u aragii, “Foron tier ae i tapiek ta lo Iesu tina Nasaret. I nenge profet ma i rakrakai kanaka e orek turan foim kia na mata God ke na matan fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Foron laulaumet na pris turan foron famfamu kirer ri ta ufu tah, isi rin nagogon u isi in met ke ri ka fakulkulik ta u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Isau le keme unune ta le, i e ier ae in fasengsegeng fan Israel. Ma igii, fatuul u mang e biing nami na foron tier tikii ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nenge tier sabin, fale kelefin lo kemem ri fabitit kemem. Nangen na biingbiing saksak, ri la una matanfat una luun minet, ");
INSERT INTO bjp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","isau le biil ri tafe pununfo. Ri fis ke ri ka fas kemem le ri par nenge parpar. Iwu e angelo ru fas ri le, ka liu fis tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ke fal lo kemem sabin ri ka la una matanfat ae ke ri ka tafe u tom arae kelefin ae ri use ta u, isau le biil ri to par Iesu.” ");
INSERT INTO bjp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ke, Iesu ka tara sing ru aragii, “Kamu talos! Balmu i fofo kanaka isi kamun unune na foron orek tikii ae foron profet ri use ta u. ");
INSERT INTO bjp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Arafah, biil kamu usum le Mesaia in kalsakai u tom e foron tier tikii igii ke nami ik kau una memeh kia?” ");
INSERT INTO bjp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ke ka puk foron orek tikii ae ri siit ta u ulo, tipes u na foron buk ke Moses, papang na foron sisiit tikii ken foron profet. ");
INSERT INTO bjp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Fatat rituulen tapiek na maleh ae run la ulo, ke Iesu ka tel u arae le in la sikit. ");
INSERT INTO bjp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Isau le ru ka lala piispiis u aragii, “O agawa naismah, wara le ka efef mang ma ka kumkubunor la e falifuh.” Ke rituul ka kau ma ka kiis aiwa na aisruh. ");
INSERT INTO bjp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aunbiing ka kiis isi ien tura ruh, ka kep beret, ka fotrokap lo, ka sibik u ke ka ta u usuf ruh. ");
INSERT INTO bjp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Fanpil, matruh ka sapeng ke ru ka par failiim u, isau le ka rorom na matruh. ");
INSERT INTO bjp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ke ru ka fadiik fis ini ru tom aragii, “Be arafah, balrah biil i karef arae yiif, aunbiing i faorek karah tole sal ma aunbiing i puk foron orek ae na Buk na Gogoh usuf karah?” ");
INSERT INTO bjp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ru aptih ke ru ka fis una Ierusalem. Aiwa, ru ka tafe sangful ini tikii e kalalik na fafausum turan fal sabin, ri kiis turim tah. ");
INSERT INTO bjp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ke ri ka fas ru aragii, “I tekentu tom! Kumguui ka apti fis tah ke ka tapiek sing Saimon.” ");
INSERT INTO bjp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Namih, ru ka fas ri ini foron tier tikii ae i tapiek ta tole sal ke arafa ru par failiim Iesu arae, aunbiing i sibik beret. ");
INSERT INTO bjp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ru ususe foron tier la biitom ae, ke Iesu tom ka tipiek na fatpoto ri ke ka tarah, “Siaroh usuf gam.” ");
INSERT INTO bjp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Isau le ri ka bitit ke ri ka sokeh. Ri wol le ri par nenge kinit. ");
INSERT INTO bjp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka tara sing ri aragii, “Isi sani ka purngis e balmi? Ke isi sani ka wu e wolwol kimi? ");
INSERT INTO bjp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iau sau igii. Par iun limang ke iun kekeng. Gam sigil iau ma gamek par u. Kinit biil ti pinsa ke biil ti foron tua, arae gam par u igii lo iau.” ");
INSERT INTO bjp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aunbiing ka use ta u arae, ka finngas ri ini iun lima ke iun keke. ");
INSERT INTO bjp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Isau le biil biitom ri unune, wara le laes i kuruung ri ma ri wolpane. Ke Iesu ka diik ri aragii, “Biil ti inen awii sing gam?” ");
INSERT INTO bjp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ke ri ka fen u ini nenge kiptin kok ae ri tun ta u. ");
INSERT INTO bjp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ka kep u ma ka ien u na matri. ");
INSERT INTO bjp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ka fas ri aragii, “Aunbiing ia kiis biitom tura gam, ia fas ta gam ini orek igii: Foron tier tikii ae ri siit ta u ulo iau, ae na Nagogon ke Moses, na sisiit ken foron Profet ke na Buk Seksek, in suut tom.” ");
INSERT INTO bjp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ke ka sapeng na wolwol kiri, isi rik malal na foron orek ae na Buk na Gogoh. ");
INSERT INTO bjp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ka fas ri aragii, “Igii e orek ae na Buk na Gogoh: Mesaia in kalsakai fangungut ma na fatuul u e biing, ik apti fis tina minet. ");
INSERT INTO bjp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma na asa, rik fafas, tipes u na Ierusalem ke usuf foron funmat tikii, isi rik sokiliis liu kiri ma God ik pa ufu foron sinang laulau kiri. ");
INSERT INTO bjp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gamen fas fanu ini foron tier ae gam par ta u. ");
INSERT INTO bjp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ongen u, ian wuun ufu Tanwa Kalkaluu, arae tom Tata i falimlim ta gam ini. Gamen kiis tom agawa, papang na aunbiing gamen fuun ini rakrakai tinbae na mawe.” ");
INSERT INTO bjp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Namih, ka lame fasuu ri una nenge falifu fatat Beteni. Aiwa, ka sik iun lima ke ka fakalok ri. ");
INSERT INTO bjp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Aunbiing i fafakalok ri la biitom, God ka kep ufu koseng ri una kukulii. ");
INSERT INTO bjp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ke ri ka lotu unaisa, namih, ri ka fis una Ierusalem ini tara laes. ");
INSERT INTO bjp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma fitliu ri kiis la na Felun Tunmapek isi usefages God. ");
INSERT INTO bjp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na tanwaran fakfakiis, Orek ka kiis tah ma Orek i kiis ta tura God ma Orek tom i e God. ");
INSERT INTO bjp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I kiis ta tura God na tanwara. ");
INSERT INTO bjp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na Orek sau, God ka fakiis foron tier tikii ma biil ti tier God i fakiis ta u na nenge sal keskes, biil. Na Orek tom. ");
INSERT INTO bjp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sing i tom e liu ma liu ae i e malal ken fanu. ");
INSERT INTO bjp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma malal i popos una kubunor, isau le kubunor biil i to fasi in fapu u. ");
INSERT INTO bjp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God i wuun ufu ta nenge kaltu, asa e Jon. ");
INSERT INTO bjp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I la arae nenge tom fafas una famalal fanu ini malal ae, isi fanu tikii ae ri ongen u, rik unune. ");
INSERT INTO bjp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I tom biil e malal, i la sau isi fafas ini malal. ");
INSERT INTO bjp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tekentu na malal ae i ta malal la usuf fanu tikii, ka tapiek mang aga na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I kiis ta na piklinbat. Taftawa le piklinbat i tapiek ta sing i tom, isau le fanu na piklinbat biil ri to iliim u. ");
INSERT INTO bjp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I tapiek na maleh kia tom ma fanu kia tom biil ri to ier isi. ");
INSERT INTO bjp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Isau le, fanu tikii ae ri ka somangat pes ta u ma ri ka unune ta na asa, ka somangat pes ri isi rin tapiek berberat ke God. ");
INSERT INTO bjp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Biil ri tapiek berberat ke God wara ri pang namin mat, le namin wolwol ken kaltu, le na sinangun fakekel, biil. Lo God tom. ");
INSERT INTO bjp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Orek ka tapiek kaltu ma ka liu na fatpoto kemem. Keme ka par ta u e memeh kia, i e memeh ke itikii sau e Kalalik ae i la tinbae sing Tama. I fuun ini famais ke tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ka famalal fanu ini. I perek ma ka tarah, “Igii mang e ier ae ia use ta u le: I mi pes iau, isau le i laumet lo iau, wara le i liu famu ta tom lo iau.” ");
INSERT INTO bjp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ifuun ini famais ma tina famais kia, kere tikii kere ka kep fafakalok fafamih. ");
INSERT INTO bjp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lo Moses, God i ta ta foron nagogon usuf kerer, isau le lo Iesu Karisito ka ta famais ke tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Biil biitom tikas i par God, biil. Itikii sau e Kalalik ke God ae i tom i God, i kiis na baba Tama ke ka famalal u usuf kerer. ");
INSERT INTO bjp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon i orek malal, aunbiing foron famfamu ken fan Iudaia tina Ierusalem ri wuun fale pris ke foron Liwai isi rin diik u le, “O seh?” ");
INSERT INTO bjp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Biil i fun ti orek una kiliis ri. I use famalal u tom aragii, “Ia biil e Mesaia.” ");
INSERT INTO bjp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pesu, ri ka diik u le, “O seh? O Elaija?” Ka kiliis ri aragii, “Ia biil e Elaija.” Ke ri ka diik u sabin le, “Kol wo mang e Profet ae Buk na Gogoh i ororek ta isi?” Ka kiliis ri aragii, “Biil.” ");
INSERT INTO bjp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Namih, ri ka diik ta u la aragii, “Ma wo seh? On fas kemem ini ti orek isi kemek kep fafis u usuf fanu ae ri wuun ta kemem. O tara le wo se tom?” ");
INSERT INTO bjp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ke Jon ka kiliis ri ini orek ae na buk ke profet Aisaia, ae i tarah, “Ia kinen tikas i tautau na sunbiil aragii, ‘Fatortores sal sala Kumguui.’” ");
INSERT INTO bjp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Foron Farasi ae ri wuun ta ri usuf Jon, ");
INSERT INTO bjp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ri ka diik u aragii, “Le biil wo e Mesaia, le Elaija, le Profet, ke isi sa o ka baptais fanu?” ");
INSERT INTO bjp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon ka kiliis ri aragii, “Ia baptais fanu ini dan, isau le awii na fatpoto gam e ier ae biil gam usum lo. ");
INSERT INTO bjp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I mang e ier ae i mi pes iau ma biil ia tortores isi ifasi iak puk ufu finaun su kia.” ");
INSERT INTO bjp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Foron tier tikii igii i tapiek na Beteni, na nenge baban dan na Ioridan, na falifu ae Jon i tel bapitaiso lo. ");
INSERT INTO bjp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na biing namih, Jon ka par Iesu i la usuf i ke ka tarah, “Par u! Apiek e Natun Sipsip ke God ae in tel ufu sinang laulau ken fanu tikii na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Igii mang e ier ae ia use ta u le, ‘I mi pes iau, isau le i laumet lo iau, wara le i liu famu ta tom lo iau.’ ");
INSERT INTO bjp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ia tom biil ia usum ta le i e seh, isau le wara ae ia ka baptais fanu ini dan, isi iak famalal u usuf fan Israel.” ");
INSERT INTO bjp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ke Jon ka ta orek an famalal kia aragii, “Ia par Tanwa Kalkaluu i filaupu arae nenge bun tinbae na kukulii ma ka kiis lo. ");
INSERT INTO bjp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Biil ifasi ian usum ta lo, isau le, God tom ae i wuun ta iau isi baptais fanu ini dan, i fas ta iau le, ‘Kaltu sa on par Tanwa Kalkaluu in puh ma ka kiis lo, i sau e ier ae in baptais fanu ini Tanwa Kalkaluu.’ ");
INSERT INTO bjp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ia ka par ta u ke ia ka famalal u le, i e Kalalik ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na biing namih, Jon tinaiwa sabin turan iwu e kalalik na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Aunbiing ka par Iesu i sobel rituul, ka tarah, “Par u! Ae kol e Natun Sipsip ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aunbiing iun kalalik na fafausum ae ru ongen Jon i use ta u arae, ru apti sau ke ru ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu ka giliim fis ma ka par ru mimi la lo, ke ka diik ru aragii, “Sani kamu ier isi?” Ke ru ka kiliis u aragii, “Rabi, fia o kiis la wah?” (Rabi, kamtina le, tom fafausum.) ");
INSERT INTO bjp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iesu ka kiliis ru aragii, “Kamu la, isi kamuk par u.” Ru ka la ma ru ka par falifu ae Iesu i kiis la wah. Rituul ka tapiek na ifet e aunbiing ma ru ka melmel tura papang na aunbiing ka sup e pisiih. ");
INSERT INTO bjp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Enru, tualik e Saimon Pita, i e neng lo ruh, ae ru ongen ta Jon i use u arae ma ru ka mi lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tier famu ae Enru i tel u, i im isi Saimon Pita tualik ke ka fas u aragii, “Kama ka tafe ta Mesaia.” (Mesaia, na orek Grik le, Karisito.) ");
INSERT INTO bjp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ka lame u usuf Iesu, ke Iesu ka par u ma ka tarah, “Asam e Saimon, kalalik ke Jon. Rin foteng wo mang ini Sifas.” Sifas, na orek Grik le Pita, kamtinan as ae le, fat. ");
INSERT INTO bjp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na biing namih, Iesu ka ier isi la una Galili. Ka tafe Filip ke ka fas u aragii, “Mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip i tina maleh na Betsaida, na maleh sau ke Enru ru e Pita. ");
INSERT INTO bjp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip ka tafe Nataniel ke ka fas u aragii, “Keme ka tafe ta kaltu ae Moses i use ta u na Buk na Nagogon, le in tapiek ma foron profet sabin ri ororek famu ta isi. I e Iesu tina Nasaret kalalik ke Josep.” ");
INSERT INTO bjp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel ka tarah, “Tina Nasaret? Ifasi le ti tier rokap in tapiek na Nasaret?” Filip ka kiliis u aragii, “La ugapiek, isi ok par u.” ");
INSERT INTO bjp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aunbiing Iesu ka par pes Nataniel i la usuf i, ka fas fanu aiwa tura le, “Igii mang kol e sikin Israel tekentu, ae biil i lem la.” ");
INSERT INTO bjp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ka diik Iesu aragii, “O usum lo iau arafah?” Ke Iesu ka kiliis u aragii, “Ia par ta wo tom awii na piklin au na fik, aunbiing Filip biil biitom i tawi pes o.” ");
INSERT INTO bjp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aunbiing Nataniel i ongen u arae, ka tarah, “Rabi! O Kalalik ke God ke o King ken fan Israel.” ");
INSERT INTO bjp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ke Iesu ka tara sing i aragii, “Arafah, o unune sau wara ia fas ta wo le, ia par o awii na piklin au na fik? Nami on par in fuun biitom e tier laumet na neng igii.” ");
INSERT INTO bjp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ke Iesu ka tara sabin aragii, “Tekentu kanaka ia fas gam, gamen par kukulii in sapeng ma foron angelo ke God rin fen ke rik pu lon Kalalik ken Kaltu.” ");
INSERT INTO bjp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Iwu e biing namih, nenge inen ken fakekel fuuh ri tel u na maleh na Kana na falifu na Galili. Tina Iesu sabin tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ri sising ta Iesu turan berberat na fafausum kia sabin isi rin la ulo e inen ae. ");
INSERT INTO bjp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aunbiing wain ari ka rop mang, tina Iesu ka tara sing i aragii, “Ka rop mang e wain.” ");
INSERT INTO bjp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu ka kiliis u aragii, “Tin ier, o ka fas iau isi sah? Sani kiak lo? Aunbiing kiak biil biitom i tapiek.” ");
INSERT INTO bjp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tina ka fas foron fafauun aiwa aragii, “Gamen tel sani ae in fas gam ini.” ");
INSERT INTO bjp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma aiwa, iwon e luunluun dan ae ri tel u ini fat. Ri to dan la lo una fakalkaluu ri namin nagogon ken fan Iudaia. Temtem tikii lo ri ifasi rin to nenge mar e lita lo. ");
INSERT INTO bjp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu ka fas foron fafauun ae aragii, “To fafuun foron pungun dan ini dan.” Ke ri ka to fabasbasa ri ini dan. ");
INSERT INTO bjp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nami ka tarah, “Arik, gam utfe ti fal mang ke gamek ta u usuf kaltu ae i parpar na inen.” Ri ka mi lo arae i use u. ");
INSERT INTO bjp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Aunbiing kaltu ae i parpar na inen ka tof u, dan ae ka sokiliis ta una wain. Biil i usum le wain ae i la tingah, isau le foron fafauun sau ae ri utfe ta dan, ri usum le wain ae tingah. Namih, ka kam pes kaltu ae i fakekel fuuh una baba ");
INSERT INTO bjp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ke ka tara sing i aragii, “Ri faumin famu foron ses la ini wain rokap, aunbiing ri ka mas mang, ke rik faumin ri mang ini wain ae biil i rokap kanaka. Isau le wo, igii sau o ka am ta u bin e wain ae i rokap kanaka.” ");
INSERT INTO bjp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Igii e fakileng famu ae Iesu i fatapiek u, i fatapiek u na Kana na falifu na Galili. I finngas memeh kia ke berberat na fafausum kia ri ka unune lo. ");
INSERT INTO bjp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Namih, Iesu, tina, foron tualik turan berberat na fafausum kia ri ka filaupu una Kapernaum. Ke ri ka melmel aiwa pes fale biing. ");
INSERT INTO bjp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aunbiing ka fatat isi Ngasa na Liuliu Kulef ken fan Iudaia, Iesu ka tatkau una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aiwa na palgan ubiif kale Felun Tunmapek, Iesu ka tafe fale fanu ri sufsufii foron bulmakau la, sipsip ke bun ma fal ri sokiliis pitkalang la na olon foron luuf. ");
INSERT INTO bjp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ke Iesu ka tel nenge bis ini finau ma ka pis fasuu fanu tikii tinaiwa na falifu kawil Felun Tunmapek turan foron sipsip ke bulmakau ma ka lin sarara foron pitkalang ken fanu ae ri sokiliis pitkalang la ke ka fabereng foron luuf kiri. ");
INSERT INTO bjp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ke ka fas fanu ae ri sufii bun la aragii, “Tel ufu foron bun ae tinaga. Gong gam ikis fel ke Tata una felun fifiil!” ");
INSERT INTO bjp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Berberat na fafausum kia ri ka wolpes sun orek na Buk na Gogoh ae i tarah, “Tara mamais kiak isi felum in tun iau arae yiif.” ");
INSERT INTO bjp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Namih, foron famfamu ken fan Iudaia, ri ka diik u aragii, “Matngan fakileng arafa on finngas u usuf kemem una fatekentu wo le, God i ta ta rakrakai usuf o una tel foron tier igii?” ");
INSERT INTO bjp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu ka kiliis ri aragii, “Rabat ufu Felun Tunmapek igii ma iak fapti fafis u na in tuul e biing.” ");
INSERT INTO bjp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ke ri ka diik u aragii, “Be, ifasi on fapti fafis Felun Tunmapek igii na ituul e biing? Ri tel ta u na ifet e sangful ini won e bet.” ");
INSERT INTO bjp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Isau le, Felun Tunmapek ae Iesu i use u, i use pununfo tom. ");
INSERT INTO bjp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nami na apaptifis kia tina minet, berberat na fafausum kia ri ka wolpes sani ae i use ta u. Ke ri ka unune na orek ae na Buk na Gogoh ma na orek sabin ae Iesu i use ta u. ");
INSERT INTO bjp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aunbiing Iesu tinawii na Ierusalem na Ngasa na Liuliu Kulef, fanu fuun ri par foron fakileng ae i fatapiek ta u ke ri ka unune na asa. ");
INSERT INTO bjp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Isau le Iesu biil i luun unune kia lo ri, wara le i usum tom lon fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Biil i to dar tikas in famalal u ini sinangun fanu, biil. Wara le, i tom i usum na liu ken nenge kaltu. ");
INSERT INTO bjp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","I mel e nenge kaltu asa e Nikodimas, i neng lon foron Farasi. Ma i nenge famfamu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I tapiek sing Iesu na wor ma ka tarah, “Rabi, keme usum le wo nenge tom fafausum ae God i wuun ufu ta uga. Wara le, biil ifasi tikas in tel foron fakileng ae o tel u, male God biil i kiis tura.” ");
INSERT INTO bjp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu ka kiliis u aragii, “Tekentu kanaka ia fas o, biil ifasi tikas in par matanfuntih ke God, male biil i pang fuu sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas ka diik aragii, “Male kaltu ka laumet tah, ke arafa sabin in pang fis arae? Biil ifasi in kau fis na bala tina isi ik pang fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ke Iesu ka kiliis u aragii, “Tekentu kanaka ia fas o, biil ifasi tikas in kau na matanfuntih ke God, male biil i pang fuu sabin ini dan ke ini Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Se i pang na pununfo i liu ini pununfo sau ma se i pang na Tanwa Kalkaluu, i liu ini tanwa. ");
INSERT INTO bjp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gong o bitit na orek ia use u le on pang fuu sabin. ");
INSERT INTO bjp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kif i kufkufe una falifu i ier le in la ulo. O ongen kine, isau le biil o usum le i la tingah ma in la wah. Ifasi sabin arae fanu tikii ae ri pang na Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ka diik aragii, “Arafa in tapiek arae?” ");
INSERT INTO bjp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ke Iesu ka kiliis u aragii, “O tom fafausum ken fan Israel ma arafah, biil o usum na foron tier igii? ");
INSERT INTO bjp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tekentu kanaka ia fas o, keme use sani keme usum lo ma keme ka famalal sani keme par ta u, isau le biil tom gam somangat pes fafamalal kimem. ");
INSERT INTO bjp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ia ka fas ta gam ini foron tier tina piklinbat ke biil gam to unune lo. Male ian fas gam ini foron tier tina kukulii, ke gamen unune lo arafah? ");
INSERT INTO bjp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Biil biitom tikas i la ta una kukulii, Kalalik ken Kaltu sau i pu ta tinbae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Arae sau Moses i sik ta sii una mawe na aunbiing ri kiis na falifu foes, ifasi sabin arae, Kalalik ken Kaltu rin sik u una mawe, ");
INSERT INTO bjp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","isi fanu tikii ae ri unune lo, rik fot u e liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Wara le, God i ier kanaka isi fanu tikii na piklinbat, pesu, ka ta ufu itikii sau e Kalalik kia, isi se ae i unune lo, biil in to fiu, biil. In fot u e liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God biil i to wuun ta ke Kalalik uga na piklinbat isi in nagogon fanu, biil. I wuun ufu isi faliu ri. ");
INSERT INTO bjp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Se i unune lo, biil in to fiu na nagogon. Isau le se ae biil i to unune lo, ka fiu ta na nagogon. Wara le biil i unune na asa itikii sau e Kalalik ke God. ");
INSERT INTO bjp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wara ae ri ka fiu na nagogon i aragii: Malal ka tapiek ta aga na piklinbat, isau le fanu biil ri ier isi malal, biil. Ri lala ier tom isi kubunor, wara le sinangu ri i laulau. ");
INSERT INTO bjp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Foron tom tel sinang laulau, ri ememse malal la ma biil ri la la una malal, wara le ri sokeh, tarama sinangu ri ka tapiek na malmalal. ");
INSERT INTO bjp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Isau le se i liu ini tekentu i la la una malal, isi ik malal le sani i tel ta u, i tel u ini rakrakai ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Namih, Iesu turan berberat na fafausum kia ri ka la una falifu na Iudaia ke Iesu ka kiis pes fale biing tura ri ke ka baptais fanu aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon sabin i famam baptais fanu na Ainon fatat isi Salim, wara le ifuun e dan lo e falifu ae ma fanu fuun ri ka la usuf i, isi ik baptais ri. ");
INSERT INTO bjp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tier igii i tapiek famu, nami Jon ka kiis na kamkabet. ");
INSERT INTO bjp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Fale berberat na fafausum ke Jon ri ka fakep ini orek turan nenge sikin Iudaia kunan sinangun fakalkaluu ri ini dan namin nagogon kiri. ");
INSERT INTO bjp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ri la usuf Jon ke ri ka fas u aragii, “Rabi, kaltu ae kamu tinawii ta na nenge bulin dan na Ioridan, ae o famalal ta fanu ini, ka baptais fanu mang. Ma fanu tikii mang ri ka famam la usuf i.” ");
INSERT INTO bjp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon ka kiliis ri aragii, “Biil tikas ifasi in kep ti tier, male God biil i ta u sing i tina kukulii. ");
INSERT INTO bjp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gam tom, gam ka ongen ta fafamalal kiak, ae ia fas ta gam ini le, ‘Ia biil e Mesaia, biil. God i wuun ta iau sau isi ian famu lo.’ ");
INSERT INTO bjp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Fifin ae in fakekel, i antu tom e kaltu ae in telpes u. Ke talan kaltu ae in fakekel, in nene ma ik wongwong isi kine. Ma aunbiing in ongen kinen kaltu ae, ik fuun ini laes. Laes ae kiak ma igii ka kuruung ta liu kiak. ");
INSERT INTO bjp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I tortores isi in laulaumet la ma iak fafabiro la. ");
INSERT INTO bjp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Se i la tina mawe, i laumet lon fanu tikii. Ma se i la tina piklinbat, i tina piklinbat tom ma i orek la tom aragii kaltu tina piklinbat. Se i la tina kukulii i laumet lon fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I famalal sani i par ta u ma ka ongen ta u, isau le biil tikas i somangat pes orek an famalal kia. ");
INSERT INTO bjp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Se i somangat pes orek an famalal kia, i fatekentu u le orek ke God i tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wara le ier ae God i wuun ufu tah, i use orek la ke God, wara le God i ta kuruur Tanwa Kalkaluu usuf i. ");
INSERT INTO bjp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tama i ier kanaka isi ke Kalalik ke ka ta tikii ta foron tier una lima. ");
INSERT INTO bjp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Se i unune lo Kalalik i fot u e liu fitliu, isau le se ae biil i somangat pes Kalalik, biil in kep liu, biil. Ngaliaf ke God i kiis tom lo.” ");
INSERT INTO bjp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Foron Farasi ri ka ongen u le, fanu fuun mang ri ka mi lo Iesu ke ka famam baptais ri ma wewes lo ri ka laumet lon berberat na fafausum ke Jon. ");
INSERT INTO bjp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tekentu lo le, Iesu biil i to baptais fanu, berberat na fafausum kia sau ri baptais fanu. ");
INSERT INTO bjp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Aunbiing Kumguui ka usum mang le foron Farasi ri ka ongen ta u le, fanu tikii ae mang nami, ka apti tina Iudaia ma ka fis una Galili. ");
INSERT INTO bjp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na ninla kia, ka soleng falifu na Samaria. ");
INSERT INTO bjp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ke ka tapiek na nenge maleh na Samaria ri foteng u ini Sikar, fatat isi sun nanal ae Jekop i ta ta u usuf Josep, kalalik kia. ");
INSERT INTO bjp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aiwa, e toh na dan ae Jekop i kef ta u. Iesu i mut e fo na dolon ninla ke ka kiis na baban toh na dan ae. Aunbiing ae, ifasi aragii sangful ini u e aunbiing na siat. ");
INSERT INTO bjp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Na aunbiing ae, nenge fafnan Samaria ka la isi ut ke Iesu ka sising u aragii, “Ifasi on ut aiak?” ");
INSERT INTO bjp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Berberat na fafausum kia ri ka la ta una maleh ae isi fiil inen. ");
INSERT INTO bjp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Fafnan Samaria ae ka kiliis u aragii, “O sikin Iudaia ma ia fafnan Samaria. O ka sising iau bin isi ti dan, arafah?” I use u arae, wara le fan Iudaia turan fan Samaria biil ri fatala la. ");
INSERT INTO bjp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu ka kiliis u aragii, “Male on usum ta na fafen ke God ma se ae i sising o isi in yin, ke ifasi ok sising ta u ma ik ta ta u e dan na liu usuf o.” ");
INSERT INTO bjp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Fifin ae ka tara sing i aragii, “Ier, biil ti utut kiam ma toh na dan igii i puh kanaka. Dan na liu ae, on kep u fiah? ");
INSERT INTO bjp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Arafah, o wol le o laumet lo Jekop, tubutamat kerer? I ta ta u e toh na dan igii sing kemem ma i tom i yin ta lo turan berberat kia ke foron bulmakau turan foron sipsip kia.” ");
INSERT INTO bjp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu ka kiliis u aragii, “Fanu tikii ae ri yin na dan igii, rin metdan sabin, ");
INSERT INTO bjp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","isau le se i yin na dan ae ia ta u sing i, biil in to metdan sabin, biil. Dan ae ia ta u sing i, in tapiek arae matan dan ae i burburak na liu kia ma i ta liu fitliu.” ");
INSERT INTO bjp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Fifin ae ka tara sing i aragii, “Ier, ta dan ae sing iau, isi biil mang ian metdan ke biil sabin ian fis uga isi ut.” ");
INSERT INTO bjp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ke Iesu ka fas u aragii, “La, kam pes antum ma kamuk fis uga.” ");
INSERT INTO bjp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka kiliis u aragii, “Biil ti antung.” Iesu ka tara sing i aragii, “O orek tekentu tom aunbiing o tara le biil ti antum. ");
INSERT INTO bjp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wara le o ka telpes ta ilim e kaltu ma kaltu mang igii o ka kiis tura, biil e antum. Sani ae o use u, i tekentu.” ");
INSERT INTO bjp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Fifin ae ka tarah, “Ier, ia par u le wo nenge profet. ");
INSERT INTO bjp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Foron tubutamat kemem ri lotu la na pungpung igii, isau le gam fan Iudaia, gam tara la le, falifu ae rin lotu lo, e Ierusalem sau.” ");
INSERT INTO bjp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu ka fas u aragii, “Tin ier, unune lo iau, nenge aunbiing in tapiek ae biil mang gamen lotu unaisa Tata aga na pungpung igii, le na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gam fan Samaria, gam lotu unaisan sani biil gam usum lo. Isau le keme lotu unaisan sani keme usum lo, wara le fafaliu ke God i la sing kemem fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Isau le, nenge aunbiing in tapiek ma igii mang ka tapiek tah, ae foron tom lotu tekentu rin lotu unaisa Tata na tanwa ke ini tekentu, wara le foron matngan tom lotu arae, Tata i im la isi. ");
INSERT INTO bjp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God i tanwa ma fanu ae ri lotu unaisa, rin lotu tom na tanwa ke ini tekentu.” ");
INSERT INTO bjp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Fifin ae ka tarah, “Ia usum le Mesaia, ae ri foteng u ini Karisito in tapiek. Aunbiing in tapiek, ke ik famalal kerer ini foron tier tikii.” ");
INSERT INTO bjp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ke Iesu ka tara sing i aragii, “Iau sau, igii ia orek turam.” ");
INSERT INTO bjp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na aunbiing sau ae, berberat na fafausum kia ri ka tapiek ke ri ka bitit, aunbiing ri tafe u i ororek la turan nenge fifin. Isau le biil tikas i diik Iesu le, “Sani o ier isi?” le, “O orek tura isi sah?” ");
INSERT INTO bjp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Fifin ae ka sok ufu pungun dan kia aiwa ma ka fis una maleh ke ka fas fanu aragii, ");
INSERT INTO bjp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Uui! Gam la ma gamek par nenge kaltu, ae i fas ta iau ini foron tier tikii ia tel ta u. I sangan e Mesaia.” ");
INSERT INTO bjp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ri ka apti tina maleh ma ri ka la isi tafe u. ");
INSERT INTO bjp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aunbiing sau fifin ae i kang koseng ri, berberat na fafausum kia ri ka tara sing i aragii, “Rabi, ien mang.” ");
INSERT INTO bjp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Isau le ka kiliis ri aragii, “I mel e inen aiak ae biil gam usum lo.” ");
INSERT INTO bjp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ke berberat na fafausum kia ri ka fadiik fis tom ini ri aragii, “Awii ngan tikas ka fen ta u ini ti inen?” ");
INSERT INTO bjp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu ka tara sing ri aragii, “Inen aiak, le ian misuut na wolwol ke ier ae i wuun ta iau uga ma iak farop foim kia. ");
INSERT INTO bjp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gam use u la le, ‘In fet biitom e funiil aiwa isi taul ilfafua.’ Isau le ia fas gam: Sapeng na matmi ma gamek par una mok! Ka matuk mang una ilfafua. ");
INSERT INTO bjp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tom lalamok ka kepkep fifiil kia la mang ma i lalamok turim una liu fitliu, isi tom lalamok ru e tom soso ruk laes turim. ");
INSERT INTO bjp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pesu, orek ae i tekentu, ‘Nenge kaltu tom i soso ke neng ka lalamok.’ ");
INSERT INTO bjp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ia wuun ta gam isi lalamok na mok ae biil gam foim ta lo. Fal tom ri tel rakrakai na foim ta lo ma gam ka kep rokap mang tina songsong kiri.” ");
INSERT INTO bjp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ifuun e fan Samaria tina maleh ae, ri ka unune lo Iesu, i wara na orek an fafamalal ken fifin ae i tara ta le, “I fas ta iau ini foron tier tikii ia tel ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ke na aunbiing fan Samaria ri ka la unaisa, ri ka rut u ke ka kiis tura ri pes iwu e biing. ");
INSERT INTO bjp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma fanu fuun biitom ri ka tapiek tom unune, i wara na orek ke Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ri ka tara sing fifin ae aragii, “Biil keme unune sau wara na orek kiam, biil. Keme unune, wara le kemem tom keme ka ongen ta u ke keme ka usum mang le kaltu sau igii, i e Tom Fafaliu ken fanu tikii na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nami na iwu e biing, Iesu ka la una Galili. ");
INSERT INTO bjp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu tom ka use famalal u le, nenge profet, biil ri bulat la lo na maleh tutus kia. ");
INSERT INTO bjp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aunbiing ka tapiek na Galili, fan Galili ri ka somangat pes u. Ri par ta foron fakileng tikii ae i fatapiek ta u na Ierusalem, wara le ri sabin ri la ta na Ngasa na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ka tapiek fis sabin na Kana, na falifu na Galili, na maleh ae i soikis ta dan una wain lo. Ma imel e nenge tom foim ken king na maleh na Kapernaum ae kalalik kia i sasem. ");
INSERT INTO bjp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Aunbiing kaltu ae i ongen u le Iesu ka la ta tina Iudaia una Galili, ka la unaisa ma ka piispiis u isi in la una Kapernaum, isi ik faliu ke kalalik ae fatat in met. ");
INSERT INTO bjp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu ka tara sing i aragii, “Male biil gam par foron fakileng ke foron tier an fabitit, biil tom gamen unune.” ");
INSERT INTO bjp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kaltu ae ka fas u aragii, “Ier, kara mang, tarama keng kalalik ka met.” ");
INSERT INTO bjp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu ka kiliis u aragii, “Fis mang. Kem kalalik in liu.” Kaltu ae ka unune na orek ke Iesu ke ka la. ");
INSERT INTO bjp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Aunbiing i toltole sal la biitom, foron fafauun kia ri ka tafe u ma ri ka fas u le ke kalalik ka liu tah. ");
INSERT INTO bjp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ka diik ri isi aunbiing sa tom, i liu rokap lo e ke kalalik. Ke ri ka fas u le, “Gogor i rop koseng u nabiing na itikii e aunbiing na efef.” ");
INSERT INTO bjp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ke taman kalalik ae ka wolpes u le, aunbiing masau ae, Iesu i fas ta u le, “Kem kalalik in liu.” Pesu, i turan fanu tikii na fel kia ri ka unune. ");
INSERT INTO bjp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Igii e fawu u e fakileng ae Iesu i fatapiek u na Galili, aunbiing i la tina Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Fale aunbiing namih, Iesu ka tatkau una Ierusalem isi nenge Ngasa ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Awii na Ierusalem, fatat isi matanfel ae ri foteng u ini Matanfel ken foron Sipsip, imel e nenge kalpong ae na orek Ibru ri foteng u ini Betesda ma awii kawil u, ilim e palpalbuang. ");
INSERT INTO bjp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ma na falifu ae, ifuun e fanu ri borong aiwa ini marmarsan sasem, fal ri kut, fal ri peo ke fal baban fo ri i met. ");
INSERT INTO bjp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nenge kaltu aiwa, i peo na ituul e sangful ini wal e bet. ");
INSERT INTO bjp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aunbiing Iesu ka par u i borong kiniis, ka usum ta le ka kiis ta arae na dolon aunbiing ke ka diik u aragii, “Arafah, o ier isi on liu?” ");
INSERT INTO bjp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Peo ae ka kiliis u aragii, “Ier, biil tikas una lupes fapu iau una kalpong aunbiing dan i burburak. Ia riris la bii le ian puh, ke fale fanu keskes ri ka famu paket.” ");
INSERT INTO bjp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu ka tara sing i aragii, “Aptih! Kep mii salam ma ok la.” ");
INSERT INTO bjp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Fanpil, kaltu ae ka liu, ka kep mii sala ke ka la. Tier igii i tapiek na nenge Biingen Mangeh, ");
INSERT INTO bjp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","pesu, foron famfamu ken fan Iudaia ri ka tara sing kaltu ae Iesu i faliu ta u aragii, “Biingen Mangeh igii! Nagogon i ti kale u le, gong o kep mii salam igii.” ");
INSERT INTO bjp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Isau le ka kiliis ri aragii, “Kaltu ae i faliu ta iau i fas iau le, ‘Kep mii salam ma ok la.’” ");
INSERT INTO bjp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ke ri ka diik u aragii, “Se na kaltu i fas o isi on kep mii salam ma ok la?” ");
INSERT INTO bjp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Isau le kaltu ae, biil i usum le se i faliu ta u, wara le Iesu ka liur ta na fatpoton gur na fanu aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Namih, Iesu ka tafe u na Felun Tunmapek ke ka tara sing i aragii, “Par u, o ka rokap fis mang. Susuaf mang na tel sinang laulau, tarama ti tier ae laulau kanaka ka tapiek lo wo.” ");
INSERT INTO bjp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kaltu ae ka la ke ka fas foron famfamu ken fan Iudaia le, kaltu ae i faliu ta u, e Iesu sau. ");
INSERT INTO bjp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pesu, foron famfamu ken fan Iudaia ri ka tipes ememse Iesu, wara le i tel foron tier igii na Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iesu ka kiliis ri aragii, “Tata i fofoim la tom papang igii ke ia sabin, ia fofoim la tom.” ");
INSERT INTO bjp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pesu, ri ka lala rakrakai mang tom le rin siimete Iesu, biil e wara sau le i lek nagogon na Biingen Mangeh, biil. I use u sabin le God i e Tama tutus ma aunbiing i use u arae, i tel u ka fafasi ini God. ");
INSERT INTO bjp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iesu ka tara sing ri aragii, “Tekentu kanaka ia fas gam, Kalalik biil ifasi in tel ti tier ini wolwol kia tom, biil. I tel tier sau ae i par Tama i tel u la, wara le sani Tama i tel u, ke Kalalik sabin i tel u la. ");
INSERT INTO bjp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Wara le Tama i ier kanaka isi ke Kalalik ma i finngas u ini foron tier tikii i tel u la. In finngas u ini foron tier laumet na fal igii isi gamek lala bitit. ");
INSERT INTO bjp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Arae sau Tama i fapti foron minet la ma ka ta liu sing ri, ke Kalalik sabin in ta liu sing fanse i ier le in ta u usuf ri. ");
INSERT INTO bjp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma Tama biil sabin i nagogon fanu la, biil. I unune ufu foron foim tikii una nagogon fanu usuf ke Kalalik, ");
INSERT INTO bjp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","isi fanu tikii rik bulat lo ke Kalalik, arae sau ri bulat lo Tama. Se biil i bulat lo ke Kalalik, biil i bulat lo Tama ae i wuun ta u. ");
INSERT INTO bjp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tekentu kanaka ia fas gam, se i ongen orek kiak ma ka unune lo ier ae i wuun ta iau, i fot u e liu fitliu ma biil in fiu na nagogon, biil. Ka oflek ta koseng minet una liu. ");
INSERT INTO bjp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tekentu kanaka ia fas gam, nenge aunbiing in tapiek ma igii mang ka tapiek tah, aunbiing foron minet rin ongen kinen Kalalik ke God ma fanse ri ongen u, rin liu. ");
INSERT INTO bjp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tama i e waran liu. Ke arae sabin lo ke Kalalik, Tama ka ta u usuf i, isi i sabin ik waran liu. ");
INSERT INTO bjp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma ka ta ta u e rakrakai una nagogon usuf i, wara le i Kalalik ken Kaltu. ");
INSERT INTO bjp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Gong gam bitit na orek igii, wara le nenge aunbiing in tapiek, ae foron minet tikii rin ongen kine ");
INSERT INTO bjp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ke rik suuh. Fanse ae ri tel ta rokap na sinang, rin apti isi kep liu ma fanse ae ri tel ta sinang laulau, rin apti isi fiu na nagogon. ");
INSERT INTO bjp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Biil ifasi ian tel ti tier namin wolwol kiak tom, biil. Ia tel nagogon sau namin sani ia ongen u. Ma nagogon kiak i tortores, wara le biil ia mi na wolwol kiak tom, biil. Ia mi sau namin wolwol ke ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Male ia tom, ia famalal fafis iau, ke fafamalal kiak biil in tatawin. ");
INSERT INTO bjp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Isau le, nenge kaltu keskes tom i fafamalal ulo iau ma ia usum le fafamalal kia ulo iau i tatawin. ");
INSERT INTO bjp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Gam wuun ta fale fanu usuf Jon ma ka famalal ta u e tekentu lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Biil ia to dar ti fafamalal ken fanu, biil. Ia use u arae isi gamek kep liu. ");
INSERT INTO bjp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon i arae lam ae i karef ma ka ta ta malal ma gam ka gesges ta isi laes na malal lo na fatuklin aunbiing. ");
INSERT INTO bjp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Isau le, imel e fafamalal ulo iau ae i tatawin kanaka na fafamalal ae Jon i use ta u. Fafamalal ae, i e foim tom ae Tata i wuun ta iau isi ian farop u ma igii ia teltel u la. Foim ae i famalal u le Tata tom i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Tata ae i wuun ta iau, ka fafamalal ta ulo iau. Biil tom gam ongen ta kine ke biil tom gam par u le i par arafah. ");
INSERT INTO bjp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ke orek kia biil i kiis na balmi, wara le biil gam unune lo ier ae i wuun ta u. ");
INSERT INTO bjp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gam tangtang fakasi foron sun orek la na Buk na Gogoh, wara gam wol le foron orek ae in ta liu fitliu sing gam. Foron orek ae ri famalal iau, ");
INSERT INTO bjp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","isau le biil gam ier isi la unaisang, isi gamek kep liu. ");
INSERT INTO bjp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Biil ia dar ti ususefages sing fanu, ");
INSERT INTO bjp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","wara ia usum lo gam. Ia usum le biil gam ier isi God na balmi. ");
INSERT INTO bjp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ia la ta uga ini asa Tata ke biil gam somangat pes iau. Isau, male tikas in la ini asa tom ke gamek somangat pes u. ");
INSERT INTO bjp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Arafa gamen unune arae lo iau, male gam ier isi kep ususefages sing gam tom ma biil gam totof isi kep ususefages sing itikii sau e God? ");
INSERT INTO bjp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Isau le, gong gam wol le ian ususe ami sing Tata. Ier ae in ususe ami, e Moses, ae gam luun unune kimi lo le in lupes gam. ");
INSERT INTO bjp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Male gam unune ta lo Moses, ke gamen unune sabin lo iau, wara le i siit ta orek an famalal ulo iau. ");
INSERT INTO bjp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Male biil gam unune na sani i siit ta u, ke arafa gamek unune arae na sani ia use u?” ");
INSERT INTO bjp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Fale aunbiing namih, Iesu ka sopaket dan kawil na Galili ae ri foteng u la sabin ini dan kawil na Taiberias. ");
INSERT INTO bjp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma gur na fanu ri ka mi lo, wara le ri ka par ta foron fakileng ae i tel ta u lon foron sasem. ");
INSERT INTO bjp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Namih, Iesu ka tatkau na nenge pungpung ke ka kiis turan berberat na fafausum kia aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aunbiing ae, ka fatat e Ngasa na Liuliu Kulef ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aunbiing Iesu i lin mata, ka par nenge tara gur na fanu ri ka la la isi ke ka diik Filip aragii, “Fia keren fiil ti beret wah an fanu igii?” ");
INSERT INTO bjp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I diik arae una tof u sau, wara le i tom ka usum ta na sani in tel u. ");
INSERT INTO bjp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip ka kiliis u aragii, “Iwu e mar e dinaria biil i to fasi una fiil beret isi temtem tikii na kaltu ik ien in tuul.” ");
INSERT INTO bjp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Neng lon berberat na fafausum kia e Enru, tualik e Saimon Pita, ka fas u aragii, ");
INSERT INTO bjp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nenge kalalik igii, imel ilim e fabiro beret ri tel u ini bali ke iwu sabin e kok ae sing i. Isau le, in fasi arafa lon fanu fuun igii?” ");
INSERT INTO bjp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ke Iesu ka fas ri aragii, “Gam fakiis fanu.” Falifu ae imel e fifih lo ma fanu ae ri ka kiis lo. Wewes lon fanu tamat ifasi aragii ilim e arip. ");
INSERT INTO bjp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu ka kep beret, ka fot rokap lo usuf God ma ka tulus fanu ae ri kiis tah. Ka tel u sabin arae na iwu e kok ma fanu tikii ri ka farop wolwol kiri na ien. ");
INSERT INTO bjp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Aunbiing ri ka mas mang, ke Iesu ka fas berberat na fafausum kia aragii, “Siing turim foron tigan inen ae ri mas tiga, tarama ka laulau foes.” ");
INSERT INTO bjp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ke ri ka siing fafuun nenge sangful ini u e kes ini foron tigan inen, tina ilim e beret ae fanu ri mas tiga. ");
INSERT INTO bjp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aunbiing fanu ri ka par ta fakileng ae Iesu i fatapiek ta u na matri, ri ka tarah, “Tekentu kanaka, igii e profet ae ri use ta u le in tapiek aga na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu ka usum ta le fanu ae ri ier isi la ma rik fangongos u isi in tapiek king, pesu ka la keskes koseng ri una nenge pungpung. ");
INSERT INTO bjp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka efef worwor mang, ke berberat na fafausum kia ri ka filaupu una dan kawil. ");
INSERT INTO bjp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ri ka wof na nenge mon ke ri ka sopaket dan una Kapernaum. Ka kubunor mang ma Iesu biil biitom i tapiek naisri. ");
INSERT INTO bjp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tara kif ka aptih ma ka panaf e dan. ");
INSERT INTO bjp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aunbiing ri ka awes ifasi aragii ilim, le iwon e kilomita, ke ri ka par Iesu ka la na olon dan isi mon ke ri ka lala sokeh. ");
INSERT INTO bjp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Isau le Iesu ka fas ri aragii, “Iau sau igii. Gong gam sokeh.” ");
INSERT INTO bjp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ke ri ka laes isi rin siing u ma fanpil ri ka tapiek na falifu ae rin la ulo. ");
INSERT INTO bjp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na biing namih, gur na fanu ae ri kiis uf ta na nenge bulin dan kawil, ri ka wol tafe u le itikii ta sau e mon tinaiwa ma Iesu biil i to wof ta turan berberat na fafausum kia. Ri keskes tom ri la tah. ");
INSERT INTO bjp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Namih, fale mon tina Taiberias ri ka masa fatat isi falifu ae ri ien ta beret ae Kumguui i fotrokap ta lo. ");
INSERT INTO bjp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma aunbiing ri ka iliim u le, Iesu turan berberat na fafausum kia ri ka mangmangal ta aiwa, ri ka wof na foron mon isi im isi Iesu na Kapernaum. ");
INSERT INTO bjp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aunbiing ri ka tafe u na nenge bulin dan kawil, ri ka diik u aragii, “Rabi, nangis o la ta uga?” ");
INSERT INTO bjp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu ka kiliis ri aragii, “Tekentu kanaka ia fas gam, gam im isi iau, biil i wara na foron fakileng ae gam par ta u, biil. I wara sau le gam ien ta beret ke gam ka mas. ");
INSERT INTO bjp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gong gam foim isi inen ae in laulau sau, gong. Gamen foim isi inen ae in kiis ma in ta liu fitliu ae Kalalik ken Kaltu in ta u usuf gam. God Tama ka luun ta fakileng lo ke Kalalik, le i somangat ini.” ");
INSERT INTO bjp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ke ri ka diik u aragii, “Sani tom kemen tel u isi kemek tel foim ae God i ier isi?” ");
INSERT INTO bjp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu ka kiliis ri aragii, “Foim ae God i ier isi, i aragii: Gamen unune lo ier ae God i wuun ufu tah.” ");
INSERT INTO bjp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pesu, ri ka diik u aragii, “Matngan fakileng arafa on fatapiek u, isi kemek par u ma kemek unune lo wo? Wo, sani on tel u? ");
INSERT INTO bjp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Foron tubutamat kemem ri ien ta mana na falifu foes, arae ri siit ta u na Buk na Gogoh le, ‘I fen ta ri ini beret tina kukulii una ien.’” ");
INSERT INTO bjp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu ka fas ri aragii, “Tekentu kanaka ia fas gam, biil e Moses ae i fen ta gam ini beret tina kukulii, biil. Tata tom ma i fen gam ini beret tekentu tina kukulii. ");
INSERT INTO bjp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wara le, beret tekentu ke God, e ier ae i pu tina kukulii ma ka ta liu sing fanu tikii na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ri ka tarah, “Ier, tipes u igii, fen kemem mang ini beret ae.” ");
INSERT INTO bjp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ke Iesu ka tara sing ri aragii, “Iau tom e beret na liu. Se i la usuf iau, biil in to fitol. Ke se i unune lo iau, biil in to met dan. ");
INSERT INTO bjp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Isau le, arae ia ka fas ta gam, gam ka par ta iau ma biil tom gam unune. ");
INSERT INTO bjp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Fanu tikii ae Tata i ta ta u usuf iau, rin la usuf iau. Ma se i la usuf iau, biil ian to tel ufu. ");
INSERT INTO bjp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wara le, ia pu ta tinbae na kukulii, biil isi ian mi na wolwol kiak tom, biil. Ia pu tinbae isi ian mi na wolwol ke ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma igii e wolwol ke ier ae i wuun ta iau uga, le: Gong ia sok ufu tikas lo ri ae ka ta ta u usuf iau, isau le ian fapti fafis ri na farfarop na biing. ");
INSERT INTO bjp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wara le, wolwol ke Tata i aragii: Se i par usuf Kalalik ma ka unune lo, in fot u e liu fitliu ma ian fapti fafis u na farfarop na biing.” ");
INSERT INTO bjp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pesu, foron famfamu ken fan Iudaia ri ka tipes belbel orek ulo, wara i tara ta le, “Iau tom e beret ae i pu ta tinbae na kukulii.” ");
INSERT INTO bjp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ri ka tarah, “Arafah, biil e kalalik ke Josep sau igii? Kere usum sau lo tama ru e tina. Ma arafa bin ka tara le, i pu tina kukulii?” ");
INSERT INTO bjp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu ka kiliis ri aragii, “Gong gam belbel orek na fatpoto gam. ");
INSERT INTO bjp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Biil tikas ifasi in la usuf iau, male Tata ae i wuun ta iau, biil i lame u usuf iau ma ian fapti fafis u na farfarop na biing. ");
INSERT INTO bjp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ri siit ta u na Buk ken foron Profet aragii, ‘God tom in fausum ri tikii.’ Ma fanu tikii ae ri ongen Tata ma ri ka kep fafausum sing i, rin la usuf iau. ");
INSERT INTO bjp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Biil tom tikas i par ta Tata, biil. Ier sau ae i la tinbae sing God, ka par ta Tata. ");
INSERT INTO bjp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tekentu kanaka ia fas gam, se i unune, i fot u e liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iau tom e beret na liu. ");
INSERT INTO bjp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Foron tubutamat gam ri ien ta mana na falifu foes, isau le ri met tom. ");
INSERT INTO bjp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Isau le, igii e beret ae i pu tinbae na kukulii ma se i ien u, biil in to met, biil. ");
INSERT INTO bjp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iau tom e beret ae i liu ae i pu tinbae na kukulii. Male tikas i ien lo e beret igii, in liu fitliu. Beret igii, i e pununfong tom ae ian ta u, isi fanu na piklinbat rik liu.” ");
INSERT INTO bjp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ke fan Iudaia ri ka tipes fakep ini orek na fatpoto ri tom aragii, “Kaltu igii, arafa in ta pununfo arae usuf kerer isi kerek ien u?” ");
INSERT INTO bjp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu ka fas ri aragii, “Tekentu kanaka ia fas gam, male biil gam ien pununfon Kalalik ken Kaltu ma biil gam umin dawu, biil in mel e liu sing gam. ");
INSERT INTO bjp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Se i ien pununfong ma ka umin daung, i fot u e liu fitliu ma ian fapti fafis u na farfarop na biing. ");
INSERT INTO bjp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wara le pununfong i e inen tu ma daung i e dan tu. ");
INSERT INTO bjp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Se i ien pununfong ma ka umin daung, i patep lo iau ma ia ka patep lo. ");
INSERT INTO bjp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata ae i liu, i wuun ta iau. Ma ia liu i wara lo Tata. Arae sabin ulo se i ien lo iau, in liu wara lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Igii e beret ae i pu tinbae na kukulii. Foron tubutamat gam ri ien ta mana ke ri ka met, isau le se i ien na beret igii, in liu fitliu.” ");
INSERT INTO bjp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Foron tier igii i use u, aunbiing i fausum fanu na felun lotu na Kapernaum. ");
INSERT INTO bjp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aunbiing ri ongen foron tier igii, ifuun e berberat na fafausum ke Iesu ri ka tarah, “Fafausum igii i ngangaten kanaka. Se ifasi in somangat pes u?” ");
INSERT INTO bjp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu ka usum ta na sani berberat na fafausum kia ri ususe u la, pesu ka tara sing ri aragii, “Foron fafausum igii i fatel gam? ");
INSERT INTO bjp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Male gamen par Kalalik ken Kaltu in tatkau fis una falifu ae i pu ta tinlo, ke gamen wol arafah? ");
INSERT INTO bjp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tanwa Kalkaluu i ta liu la. Pununfo biil i ta liu la. Foron orek ae ia ka fas ta gam ini, i tanwa, ma i liu. ");
INSERT INTO bjp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Isau le fal lo gam, biil ri to unune.” Iesu i use u arae, wara le ka usum ta tina tanwara lon fanse ae biil ri unune ke se ae in ta ufu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ke ka tara sabin aragii, “Igii e wara ke ia ka fas gam le, biil tikas ifasi in la usuf iau, male Tata biil i ta rakrakai sing i isi in la usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tipes u na aunbiing ae, ifuun e berberat na fafausum kia ri ka la koseng u ma biil mang ri mi la lo. ");
INSERT INTO bjp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu ka diik nenge sangful ini u e kalalik na fafausum kia aragii, “Gam sabin, gam ka ier isi la koseng iau, beh?” ");
INSERT INTO bjp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita ka kiliis u aragii, “Kumguui, kemen la usuf se sabin? O sau imel e orek na liu fitliu ae sing o. ");
INSERT INTO bjp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Keme unune ma keme usum le, o Kaltu Kalkaluu ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ke Iesu ka fas ri aragii, “Ia tom ia tim pes ta gam nenge sangful ini u. Isau le neng lo gam i nenge tanwa laulau.” ");
INSERT INTO bjp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I use Iudas, kalalik ke Saimon Iskariot. Taftawa le i neng lon sangful ini u e kalalik na fafausum, isau le namih, in ta ufu Iesu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nami na foron tier igii, Iesu ka la na foron maleh na falifu na Galili. Biil i ier isi in la una Iudaia, wara le foron famfamu ken fan Iudaia ri puput isi siimete u. ");
INSERT INTO bjp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Isau le aunbiing ka fatfatat la isi Ngasa na Palpalbuang ken fan Iudaia, ");
INSERT INTO bjp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","foron tualik e Iesu ri ka fas u aragii, “On kang tinaga ma ok la una Iudaia, isi berberat na fafausum kiam rik par foron fakileng on fatapiek u. ");
INSERT INTO bjp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Se i ier le rin usum tikii lo, biil in tel famumun ti tier. O fatapiek foron tier la igii, pesu, finngas o mang usuf fanu tikii na piklinbat!” ");
INSERT INTO bjp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Foron tualik tom ri use u arae, wara le ri sabin, biil ri unune lo. ");
INSERT INTO bjp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pesu, Iesu ka tara sing ri aragii, “Aunbiing tutus kiak biil biitom i tapiek. Isau le foron aunbiing tikii ifasi sau usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Fanu na piklinbat biil ifasi rin ememse gam. Isau le ri ememse iau, wara le ia famalal u le sinangu ri i laulau. ");
INSERT INTO bjp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gam la una ngasa ae. Ia tom biil ian la una ngasa ae, wara le aunbiing tutus kiak, biil biitom i tapiek.” ");
INSERT INTO bjp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ka use ta u arae, ke ka melmel tom na Galili. ");
INSERT INTO bjp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Isau le nami sau lon foron tualik ri ka la ta una ngasa ae, ka la sabin. Isau le biil i to la malal, i la mumun sau. ");
INSERT INTO bjp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Awii na ngasa ae, foron famfamu ken fan Iudaia ri ka famam parpar isi ma ri ka diik aragii, “Fiawa e kaltu ae?” ");
INSERT INTO bjp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma aiwa na fatpoton gur na fanu ae, ri ka famam ngurke Iesu. Fal ri tara le, “I rokap na kaltu.” Ma fal ri ka tarah, “I famam lame fager fanu.” Isau le ri orek fofo sau ");
INSERT INTO bjp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ma biil tikas i use ti tier ulo na matan fanu tikii, wara le ri soke foron famfamu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na nenge biing na fatpoton ngasa ae, Iesu ka tatkau una Felun Tunmapek ma ka tipes fausum fanu. ");
INSERT INTO bjp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Fan Iudaia ri ka lala bitit ma ri ka diik aragii, “Kaltu igii arafa i kep u arae e tasum igii ma biil i to fafausum tah?” ");
INSERT INTO bjp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu ka kiliis ri aragii, “Fafausum igii, biil e fafausum kiak tom, biil. I la tom sing ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Male tikas i ier isi mi na wolwol ke God, ke ifasi in iliim u le fafausum kiak ia use u ini wolwol kiak tom, le i la sing God. ");
INSERT INTO bjp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Se i orek ini wolwol kia tom, i tel u isi fanu tikii rin sik asa. Isau le, se i tel foim una sik asa ier ae i wuun ta u, i e kaltu tekentu ma biil ti famfabal lo. ");
INSERT INTO bjp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Tekentu kanaka ia fas gam, Moses i ta ta u e nagogon sing gam. Isau le biil tom tikas lo gam i misuut na nagogon. Isi sani gam ka im sal una siimete iau?” ");
INSERT INTO bjp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Gur na fanu ae ri ka kiliis u aragii, “Imel e tanwa laulau lo wo. Se i ier isi siimete wo?” ");
INSERT INTO bjp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu ka kiliis ri aragii, “Ia fatapiek ta nenge fakileng na Biingen Mangeh ma gam tikii gam ka lala bitit. ");
INSERT INTO bjp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Isau le, fale aunbiing gam kiit pununfon berberat la na Biingen Mangeh, wara Moses i ta ta u e nagogon na sinangun fakiit usuf gam. Isau le biil i la sing Moses, biil. I la tom sing foron tubutamat gam. ");
INSERT INTO bjp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ke, male ri kiit pununfo nenge kalalik na Biingen Mangeh isi gong ri lek nagogon ke Moses, ke isi sani gam ka ngaliaf ulo iau, wara le ia faliu kaltu kuruur ae na Biingen Mangeh? ");
INSERT INTO bjp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gong gam nagogon namin parpar kimi sau, gong. Gamen tel tortores na nagogon.” ");
INSERT INTO bjp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wara na foron tier ae Iesu i use ta u, fale fanu na Ierusalem ri ka tipes diik aragii, “Be, kaltu sau igii ri famam totof isi siimete u? ");
INSERT INTO bjp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Par u, ae sau i ororek la na matan fanu ma foron famfamu biil ri use ti tier ulo. Awii ri ka usum mang ngan le i e Mesaia? ");
INSERT INTO bjp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Isau le kaltu igii kere usum sau le i tingah ma aunbiing Mesaia in tapiek, biil tikas in usum le in la tingah.” ");
INSERT INTO bjp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aunbiing Iesu i fafausum fanu la biitom na palgan ubiif kale Felun Tunmapek, ka perek aragii, “Gam usum lo iau ke gam usum le ia tingah. Isau le, biil ia la uga namin wolwol kiak tom, biil. Ier ae i wuun ta iau i tekentu kanaka. Biil gam usum lo, ");
INSERT INTO bjp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","isau le ia usum lo, wara le ia la tinbae sing i ma i wuun ta iau.” ");
INSERT INTO bjp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aunbiing ka use ta u arae, ri ka ier isi luse u. Isau le biil tikas i luun lima lo, wara le aunbiing kia biil biitom i tapiek. ");
INSERT INTO bjp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Isau le ifuun tom e fanu na palgan gur ae ri unune lo. Ke ri ka tarah, “Aunbiing Mesaia in tapiek, ke in fatapiek in fuun sabin e fakileng lon kaltu igii? Awii kaltu sangan igii e Mesaia.” ");
INSERT INTO bjp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Foron Farasi ri ka ongen gur na fanu ae ri ngurngurke foron orek la igii lo Iesu. Pesu, foron famfamu ken foron pris turan foron Farasi ri ka wuun foron tom parpar kale Felun Tunmapek isi rin luse u. ");
INSERT INTO bjp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ke Iesu ka fas ri aragii, “Ian kiis tura gam na fatuklin aunbiing sau ma namih, iak la usuf ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gamen im isi iau, isau le biil gamen tafe iau. Ma falifu ae ian kiis lo, biil ifasi gamen la ulo.” ");
INSERT INTO bjp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Fan Iudaia ri ka orek fis na fatpoto ri tom aragii, “Kaltu igii i ier le in la wah, ae biil ifasi keren tafe u? Arafah, in la usuf fanu kirer ae ri kiis sarara na foron maleh tikii na Grik ma ik fausum fan Grik? ");
INSERT INTO bjp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sani e kamtinan orek kia aunbiing i tarah, ‘Gamen im isi iau, isau le biil gamen tafe iau,’ ke ‘Falifu ae ian kiis lo, biil ifasi gamen la ulo’?” ");
INSERT INTO bjp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na farfarop na ngasa ae, i tara na biing, Iesu ka sotih ma ka perek aragii, “Male se i metdan, ke ik la usuf iau isi ik yin. ");
INSERT INTO bjp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Se i unune lo iau, foron dan ae i ta dan na liu in ring suu tina liu kia, arae Buk na Gogoh i use ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Aunbiing Iesu i use u arae, i use Tanwa Kalkaluu ae fanse ri unune lo, nami rin kep u. Aunbiing ae, God biil biitom i ta ufu Tanwa Kalkaluu, wara le Iesu biil biitom i kep memeh kia. ");
INSERT INTO bjp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Aunbiing fale fanu ri ka ongen u i orek arae, ke ri ka tarah, “Tekentu kanaka, kaltu igii i e Profet ae Buk na Gogoh i fafas ta ini.” ");
INSERT INTO bjp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Fal ri tarah, “I e Mesaia.” Isau le fal ri ka tara le, “Mesaia biil in la tina Galili, biil. ");
INSERT INTO bjp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wara le Buk na Gogoh i use ta u le, Mesaia in la tina mat ke king Dewit ma in pang na Betliem, na maleh ae Dewit i laumet ta lo.” ");
INSERT INTO bjp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pesu ka mel e tampaek na fatpoton gur na fanu, wara lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Fal ri ka ier isi rin luse u, isau le biil tikas lo ri i luun lima lo. ");
INSERT INTO bjp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aunbiing foron tom parpar kale Felun Tunmapek ri ka fis, foron famfamu ken foron pris turan foron Farasi ri ka tara sing ri aragii, “Isi sani biil gam lame u uga?” ");
INSERT INTO bjp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ke foron tom parpar kale ae ri ka kiliis ri aragii, “Biil tom tikas i orek la arae kaltu igii.” ");
INSERT INTO bjp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Foron Farasi ri ka kiliis ri aragii, “Gam sabin ka lame farong ta gam? ");
INSERT INTO bjp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Arafah, tikas lon foron famfamu le foron Farasi ka unune ta lo, beh? Biil tom tikas. ");
INSERT INTO bjp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Isau le gur na fanu ae ri unune lo, biil ri usum na nagogon ke Moses, pesu ngaliaf ke God ka kiis lo ri.” ");
INSERT INTO bjp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas i e neng lon foron Farasi ae pakanini i la ta usuf Iesu. Ka tarah, ");
INSERT INTO bjp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na nagogon kirer, biil ifasi keren ta fangungut usuf tikas, male biil bii kere ongen famu orek an fafamalal kia na sani i tel ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ri ka kiliis u aragii, “O sabin tina Galili? Par foron orek ae na Buk na Gogoh ke ok tafe u le, biil ti profet in la tina Galili.” ");
INSERT INTO bjp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ke ri ka pipiek una foron maleh temtem tikii kiri. ");
INSERT INTO bjp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Isau le Iesu ka tatkau una Pungpung na Olif. ");
INSERT INTO bjp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na biingbiing saksak, ka tapiek fis sabin na palgan ubiif kale Felun Tunmapek. Ke aiwa, fanu tikii ri ka kawil u ma ka kiis isi fausum ri. ");
INSERT INTO bjp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Foron tom fafausum ini nagogon turan foron Farasi ri ka lame fakau nenge fifin ae ri tafe u i tel sinangun puur. Ke ri ka fiti u na matri ");
INSERT INTO bjp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ma ri ka diik Iesu aragii, “Tom fafausum, fifin igii ri tafe u i tel sinangun puur. ");
INSERT INTO bjp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na nagogon, Moses i fas kerer isi keren luumete matngan fifin aragii. Wo, sani on use u?” ");
INSERT INTO bjp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri ka tel matngan fagalte arae una tatakuun isi Iesu, isi ik mel e tier rin ti lo una tiu u. Isau le Iesu ka parau ma ka tipes sisiit na nanal ini katngan lima. ");
INSERT INTO bjp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aunbiing ri diikdiik u la biitom, ka sotih ma ka tara sing ri aragii, “Male tikas lo gam ae biil ti sinang laulau kia, ke ik luu famu u ini ti fat.” ");
INSERT INTO bjp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ka parau fis sabin ke ka sisiit na nanal. ");
INSERT INTO bjp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aunbiing ri ongen u i use u arae, ri ka suu temtem tikii. Tipes u lon foron tubunkak, papang na aunbiing Iesu keskes mang tinaiwa turan fifin ae i soti tah. ");
INSERT INTO bjp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu ka soti fis ma ka diik u aragii, “Tin ier, fiawa mang e fanu aga? Arafah, biil tikas i ier isi luumete wo?” ");
INSERT INTO bjp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Fifin ae ka kiliis u aragii, “Ier, biil tikas.” Ke Iesu ka tara sing i aragii, “Ia sabin, biil ia to nagogon o. La mang ma gong sabin o tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aunbiing Iesu ka orek sabin usuf fanu, ka tarah, “Iau tom e malal ken fanu tikii na piklinbat. Se i mi lo iau, biil in la na kubunor, biil. In mel e malal na liu kia.” ");
INSERT INTO bjp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ke foron Farasi ri ka tara sing i aragii, “Igii o ka famalal fafis wo tom ma orek an famalal kiam, biil i tatawin.” ");
INSERT INTO bjp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu ka kiliis ri aragii, “Taftawa le ia famalal fafis iau tom, orek an famalal kiak i tatawin, wara le ia usum le ia la tingah ma ian la uwah. Isau le gam, biil gam usum le ia la tingah ma ian la uwah. ");
INSERT INTO bjp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gam tel nagogon la sau namin wolwol ken fanu tinaga na piklinbat, isau le iau, biil ia nagogon tikas. ");
INSERT INTO bjp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Isau, male ian tel nagogon, ke nagogon kiak i tekentu, wara le biil ia keskes ia tel u, biil. Ia ti tura Tata ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na nagogon kimi tom, ri siit ta u le fafamalal ken in wu tom e kaltu i tatawin. ");
INSERT INTO bjp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ia tom ia famalal fafis iau ma nenge tom fafamalal kiak sabin e Tata, ae i wuun ta iau.” ");
INSERT INTO bjp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ke ri ka diik u aragii, “Fiawa e tamam?” Iesu ka kiliis ri aragii, “Biil gam usum lo iau ke biil gam usum lo Tata. Male gam ka usum ta lo iau, gamen usum sabin lo Tata.” ");
INSERT INTO bjp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","I use foron tier igii, aunbiing i fausum fanu na palgan ubiif kale Felun Tunmapek, fatat isi falifu ae ri luun foron fafen la wah. Isau le biil tikas i luse u, wara le aunbiing kia biil biitom i tapiek. ");
INSERT INTO bjp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu ka fas ri sabin aragii, “Ian la koseng gam ma gamen im isi iau ma gamek met ini foron sinang laulau kimi. Falifu ae ian la ulo, biil ifasi gamen la ulo.” ");
INSERT INTO bjp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pesu, foron famfamu ken fan Iudaia ri ka diik aragii, “Arafah, in siimete fafis u tom? I sangan e wara ka tara le, falifu ae in la ulo, biil ifasi keren la ulo?” ");
INSERT INTO bjp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ke Iesu ka tara sabin aragii, “Gam tina pikli ma ia tina mawe. Gam fanu na piklinbat ma ia biil tinaga na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ia ka fas ta gam le gamen met ini foron sinang laulau kimi. Male biil gam unune le iau sau e ier ae, ke gamen met tom ini foron sinang laulau kimi.” ");
INSERT INTO bjp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ri ka diik u aragii, “O seh?” Ke Iesu ka kiliis ri aragii, “Arae sau ia fas gam la ini tinpakanini papang igii. ");
INSERT INTO bjp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ifuun biitom e tier ian use u ulo gam ma una nagogon gam. Isau le, ier ae i wuun ta iau, i tekentu kanaka. Ma sani ia ongen ta u sing i, ia ka fas fanu tikii ini.” ");
INSERT INTO bjp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Biil ri to malal le i fasfas ri la sau ini Tama. ");
INSERT INTO bjp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pesu, Iesu ka tarah, “Aunbiing gam ka fafen ta Kalalik ken Kaltu, aimang gamek usum le iau sau e ier ae ke gamek usum le biil ia tel ti tier ini wolwol kiak tom, biil. Ia use sani sau ae Tata i fausum ta iau ini. ");
INSERT INTO bjp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma ier ae i wuun ta iau, igii tom na aisang. Biil i fin koseng iau la, wara le ia tel foron foim la tom ae i laes la ini.” ");
INSERT INTO bjp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aunbiing i ororek la biitom, ke fanu fuun ri ka luun unune kiri lo. ");
INSERT INTO bjp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ke Iesu ka fas fan Iudaia ae ri ka unune ta lo aragii, “Male gamen posefat na orek kiak, ke gamen tapiek berberat na fafausum tekentu kiak. ");
INSERT INTO bjp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gamen usum na tekentu ma tekentu ae ik fasengsegeng gam.” ");
INSERT INTO bjp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri ka kiliis u aragii, “Keme foron tubutamat e Abaram ma biil tom keme fafauun ta ken tikas. Arafa o ka tara le kemen sengsegeng?” ");
INSERT INTO bjp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu ka fas ri aragii, “Tekentu kanaka ia fas gam, fanu tikii ae ri tel sinang laulau la, ri tapiek fafauun ken sinang laulau. ");
INSERT INTO bjp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nenge fafauun biil i kiis fitliu la na matanfel, biil. Kalalik sau tina matanfel ae, in kiis fitliu aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ke male Kalalik i fasengsegeng gam, ke gamen sengsegeng sikit. ");
INSERT INTO bjp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ia usum le gam foron tubutamat e Abaram. Isau le gam im sal una siimete iau, wara le biil ti salan orek kiak na balmi. ");
INSERT INTO bjp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ia use foron tier ae ia par ta u sing Tata ma gam tel sani la ae gam par u sing teumi.” ");
INSERT INTO bjp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri ka kiliis u aragii, “Abaram e tama kemem.” Iesu ka fas ri le, “Male gam berberat ke Abaram, ke gamek tel ta foron tier ae Abaram i tel ta u. ");
INSERT INTO bjp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Isau le, igii gam ka im sal una siimete iau. Iau sau e kaltu ae i fas ta gam ini tekentu, ae ia ongen ta u sing God. Abaram biil i tel ta ti tier aragii, biil. ");
INSERT INTO bjp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Igii gam teltel foron tier la tom ae tama gam i tel u la.” Ke ri ka kiliis u aragii, “Biil keme pang na sal. Tama kemem e God keskes sau.” ");
INSERT INTO bjp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu ka fas ri aragii, “Male God i Tama gam, ke gamen ier isi iau, wara le ia la ta tinbae sing God ma igii, ia mang igii naismi. Biil ia la ini wolwol kiak tom uga, biil. God tom i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Isi sani biil gam malal na orek kiak? I wara le biil gam somangat pes sani ia use u. ");
INSERT INTO bjp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gam berberat ke Satan, i tama gam, ma gam ier isi mi na wolwol ke tama gam. I nenge tom sisiimete tina tanwara tom ma biil i ti la na tekentu, wara le biil imel e tekentu lo. Ma aunbiing i lem, i ien fakasi u tom, wara le i tom lemlemet ma i taman lem. ");
INSERT INTO bjp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Isau le, taftawa le ia fas gam ini tekentu, biil tom gam unune lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ifasi tikas lo gam in sir matang ini ti sinang laulau ia tel ta u? Male ia fas gam ini orek tekentu, ke isi sani biil gam unune lo iau? ");
INSERT INTO bjp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Se ke God, i ongen orek la ke God. Isau le gam, biil gam ongen pes u, wara le biil gam ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Fan Iudaia ri ka kiliis Iesu aragii, “Keme use fatus u le wo nenge sikin Samaria ma imel e tanwa laulau lo wo.” ");
INSERT INTO bjp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu ka tara sing ri aragii, “Biil ti tanwa laulau lo iau. Ia bulat lo Tata, isau le gam biil gam bulat lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Biil ia ier isi sik asang tom, biil. Neng tom i sik asang ma i e tom nagogon. ");
INSERT INTO bjp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tekentu kanaka ia fas gam, male tikas i pose papte orek kiak, ke biil in to met.” ");
INSERT INTO bjp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","I use u arae, pesu fan Iudaia ri ka tara sing i aragii, “Igii keme ka usum mang le imel tom e tanwa laulau lo wo! Abaram ka met tah ke foron profet sabin. Isau le wo, o tara le: Male tikas i pose papte orek kiam, ke biil in to met. ");
INSERT INTO bjp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","O wol le o laumet lo tama kemem Abaram? Ka met tah ke foron profet sabin ri ka met tah. O wol le o seh?” ");
INSERT INTO bjp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu ka kiliis ri aragii, “Male ia sik asang tom, ke orek kiak i tier foes. Tata, ae gam tara le i e God kimi, i e ier ae i sik asang. ");
INSERT INTO bjp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gam, biil gam usum lo, isau le ia usum lo. Male ian tara le biil ia usum lo, ke iak tapiek tom lemlemet arae gam. Isau le ia usum lo, pesu ia ka mi na orek kia. ");
INSERT INTO bjp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tama gam Abaram i laes ta isi in par biing kiak. Ma ka par ta u ke ka laes.” ");
INSERT INTO bjp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ke fan Iudaia ri ka tarah, “Biil biitom i lim e sangful e bet kiam ma o ka tara le o ka par ta Abaram!” ");
INSERT INTO bjp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu ka kiliis ri aragii, “Tekentu kanaka ia fas gam, Abaram biil biitom i pang ma ia ka kiis tah.” ");
INSERT INTO bjp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","I use u arae, pesu ri ka kep fat isi rin luumete u. Isau le Iesu ka liur na fatpoton fanu ae ma ka suu tina Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Aunbiing Iesu i toltole sal la, ka par nenge kaltu, i pang ma ka kut tah. ");
INSERT INTO bjp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ke berberat na fafausum kia ri ka diik u aragii, “Rabi, se i tel ta sinang laulau pesu kaltu igii ka pang ini kut, i tom le, tama ru e tina?” ");
INSERT INTO bjp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu ka kiliis ri aragii, “Kaltu igii i kut, biil i wara na sinang laulau kia, le na sinang laulau ke tama ru e tina, biil. I kut isi fanu tikii rik par foim ke God ik tapiek malal na liu kia. ");
INSERT INTO bjp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aunbiing i ien biitom, i rokap le keren tel foim ke ier ae i wuun ta iau. Wor apiek mang ae biil tikas ifasi in rik foim. ");
INSERT INTO bjp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aunbiing ia kiis biitom na piklinbat, iau tom e malal ken fanu tikii na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ka use ta u arae, ka ubis una nanal ke ka tel pisak ini ubis kia ma ka luun u na matan kut ae. ");
INSERT INTO bjp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ke Iesu ka fas u aragii, “La ma ok susuh na kalpong ae ri foteng u ini Siloam.” Siloam, kamtina le wuun. Kaltu ae ka la, ka susuh ma aunbiing i fis, ka par mang. ");
INSERT INTO bjp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pesu, foron tikiin maleh kia ke fanu ae ri par ta u i kiis la isi sising fanu isi tier, ri ka diik aragii, “I sangan e kaltu igii i kiis la isi sising tier sing fanu, beh?” ");
INSERT INTO bjp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Fal ri tara le, i sau. Ma fal ri ka tarah, “I biil. I par sau arae i.” Isau le i tom ka ususe u la le, “Iau sau e kaltu ae.” ");
INSERT INTO bjp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pesu, ri ka diik u aragii, “Arafa ke iun matam ka sapeng?” ");
INSERT INTO bjp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ka kiliis ri aragii, “Kaltu ae ri foteng u ini Iesu, i tel pisak ma ka luun u na iun matang. Ke ka fas iau isi ian susuh na kalpong na Siloam. Ia la, ia ka susuh ke ia ka par.” ");
INSERT INTO bjp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ri ka diik u aragii, “Fiawa mang e kaltu ae?” Ka kiliis ri aragii, “Biil ia usum.” ");
INSERT INTO bjp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ke ri ka lame kaltu ae i kut ta usuf foron Farasi. ");
INSERT INTO bjp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma biing ae Iesu i tel ta pisak ma ka sapeng na matan kaltu ae i kut tah, i nenge Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pesu, foron Farasi ri ka diik u sabin le, “Arafa i tara arae ke igii o ka par?” Ke ka fas ri aragii, “I luun pisak na matang ke ia ka susuh ma ia ka par.” ");
INSERT INTO bjp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Fale Farasi ri ka tarah, “Kaltu igii, biil i la sing God, wara le i lek nagogon na Biingen Mangeh.” Isau le fal ri ka diik aragii, “Ifasi le tikas e tom tel sinang laulau in fatapiek foron fakileng aragii?” Ke ka mel e tampaek na fatpoto ri. ");
INSERT INTO bjp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ke, ri ka diik ta u la aragii, “O wol le i matngan kaltu arafah? Wara le i sapeng ta na matam.” Kaltu ae ka tarah, “I nenge profet.” ");
INSERT INTO bjp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Foron famfamu ken fan Iudaia biil tom ri unune le kaltu ae i kut tah ma arafa i tara arae ke ka par, pesu ri ka fawuun isi tama ru e tina. ");
INSERT INTO bjp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ke ri ka diik ru aragii, “Kalalik kimuh igii, ae kamu tara le i pang ini kut? Ma arafa i tara arae ke igii ka par mang?” ");
INSERT INTO bjp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tama ru e tina ru ka kiliis ri aragii, “Kama usum le i kalalik kimah ma kama usum le i pang ini kut. ");
INSERT INTO bjp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Isau le, arafa i tara arae ke igii ka par ma se i sapeng na mata, biil kama usum. Gam diik u tom, ka kaltu mang, i tom in orek.” ");
INSERT INTO bjp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tama ru e tina ru use u arae, wara le ru soke foron famfamu ken fan Iudaia. Wara le foron famfamu ri ka use ta u le, tikas in fapos Iesu le i e Mesaia, ke rin tikale u isi gong i lotu na felun lotu. ");
INSERT INTO bjp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pesu, tama ru e tina ru ka tarah, “Gam diik u, ka kaltu mang.” ");
INSERT INTO bjp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ke, fawu e aunbiing sabin foron Farasi ri ka kam pes kaltu ae i kut tah ma ri ka tara sing i aragii, “Ta memeh usuf God ma ok falimlim. Wara keme usum le kaltu ae i faliu ta wo i nenge tom tel sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ke kaltu ae ka kiliis ri aragii, “Biil ia usum le i nenge tom tel sinang laulau, le biil. Isau le, ia usum le ia kut tah ma igii ia ka par.” ");
INSERT INTO bjp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ke ri ka diik u aragii, “Sani i tel u ini wo? Ma arafa i sapeng na matam arae?” ");
INSERT INTO bjp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ka kiliis ri aragii, “Ia ka fas ta gam ma biil tom gam ongen u. Gam ka ier isi ongen u sabin isi sanih? Arafah, gam sabin gam ier isi tapiek berberat na fafausum kia?” ");
INSERT INTO bjp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ke ri ka buar u aragii, “O kalalik na fafausum kia e ier ae. Kemem berberat na fafausum ke Moses. ");
INSERT INTO bjp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Keme usum le, God i orek ta usuf Moses. Isau le kaltu igii, biil keme usum le i la tingah.” ");
INSERT INTO bjp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kaltu ae ka kiliis ri aragii, “Tier an fabitit! Biil gam usum le i la tingah, isau le i sapeng na matang. ");
INSERT INTO bjp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kere usum le God biil i wong la sing foron tom tel sinang laulau, biil. I wong la sau sing fanu ae ri bulat la lo ma ri mi la na wolwol kia. ");
INSERT INTO bjp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka papang igii, biil biitom kere ongen ta u le, tikas ka sapeng ta na matan ti kaltu ae i pang tom ini kut. ");
INSERT INTO bjp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Male kaltu igii biil i la sing God, ke biil ifasi in tel ti tier.” ");
INSERT INTO bjp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Foron Farasi ri ka kiliis u aragii, “O pang ke o ka laumet piek na palgan sinang laulau. Arafa bin o ka ier isi fausum kemem?” Ke ri ka luu suu ini tina felun lotu. ");
INSERT INTO bjp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu ka ongen u le foron Farasi ri ka tel ufu ta kaltu ae tina felun lotu. Aunbiing ka tafe u, ka diik u aragii, “O unune lon Kalalik ken Kaltu?” ");
INSERT INTO bjp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kaltu ae ka kiliis u aragii, “Ier, i e seh? Fas iau ini, isi iak unune lo.” ");
INSERT INTO bjp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu ka fas u aragii, “O ka par ta u ma i igii i ororek la turam.” ");
INSERT INTO bjp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ke kaltu ae ka tarah, “Kumguui, ia unune.” Ka ilepul ma ka lotu unaisa. ");
INSERT INTO bjp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu ka tarah, “Ia la uga na piklinbat isi nagogon fanu, isi foron kut rik par ma fanse ae ri par rik kut.” ");
INSERT INTO bjp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fale Farasi tinaiwa naisa, ri ongen u i use u arae ke ri ka diik aragii, “Arafah, kemem kut sabin?” ");
INSERT INTO bjp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu ka kiliis ri aragii, “Male gam kut, ke biil tikas in tiu gam ini foron sinang laulau kimi. Igii, gam tara le gam par, pesu sinang laulau kimi ae tom. ");
INSERT INTO bjp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Tekentu kanaka ia fas gam, kaltu ae biil i kau na matan ubiif ken foron sipsip, isau le ka wof paket na ubiif, i nenge tom suksukuum ma i nenge tom dat foes tier ken fanu. ");
INSERT INTO bjp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma kaltu ae i kau na matan ubiif, i e tom fofonoi na foron sipsip kia tom. ");
INSERT INTO bjp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tom parpar kale matan ubiif i sapeng pes u la ke foron sipsip ri wong la na kine. I kam foron sipsip kia la tom ini asri ma ka lame fasuu ri la. ");
INSERT INTO bjp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aunbiing tom fofonoi na sipsip ka lame fasuu ta foron sipsip kia, ka famu pes ri. Ma foron sipsip kia ri mi la lo, wara le ri ongen failiim kine. ");
INSERT INTO bjp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Isau le biil tom rin mi lo nenge kaltu keskes, biil. Rin fin koseng u tom, wara le biil ri ongen failiim kinen nenge kaltu keskes la.” ");
INSERT INTO bjp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu i fas ri ini orek fatoftof igii, isau le biil ri to malal na sani i fas ri ini. ");
INSERT INTO bjp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pesu, ka fas ri sabin aragii, “Tekentu kanaka ia fas gam, iau tom e matan ubiif ken foron sipsip. ");
INSERT INTO bjp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Fanu tikii ae ri famu ta lo iau, ri foron tom suksukuum ke ri foron tom dat foes tier ken fanu. Isau le, foron sipsip biil ri wong ta sing ri. ");
INSERT INTO bjp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iau tom e matan ubiif. Se ae i kau lo iau, in liu. In kau ke ik suuh ma in tafe in fuun e fifih rokap. ");
INSERT INTO bjp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Tom suksukuum i la la sau isi suksukuum, sisiimete ke isi falaulau ri. Isau le, ia la isi rik fot u e liu, liu ae i kuruur. ");
INSERT INTO bjp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iau tom e rokap na tom fofonoi na sipsip. Rokap na tom fofonoi na sipsip i lin liu kia la isi foron sipsip kia. ");
INSERT INTO bjp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kaltu ae ri fiil u sau isi fofonoi na sipsip, biil i taman foron sipsip, biil. Aunbiing i par pes puul ngalngaliaf, in kang koseng foron sipsip sau ma ka fin. Ke puul ngalngaliaf ae in sungaf ri ma ik fes sarara ri. ");
INSERT INTO bjp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kaltu ae in fin, wara le ri fiil ta u sau isi fofonoi lon foron sipsip ma biil i mais ri. ");
INSERT INTO bjp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iau tom e rokap na tom fofonoi na sipsip. Ia usum lon foron sipsip kiak ke foron sipsip kiak ri usum lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Arae sau, Tata i usum lo iau ke ia ka usum lo Tata. Ma ia lin liu kiak tom isi foron sipsip. ");
INSERT INTO bjp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Imel e fale sipsip sabin kiak, ae biil ri kiis na palgan ubiif turan fal igii. Ian lame pes ri isi ri sabin rik ongen kineng ke ik tikii sau e uh lo ri ma ik tikii sau e tom fofonoi kiri. ");
INSERT INTO bjp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata i ier kanaka isi iau, wara le ia lin liu kiak, isi iak kep fafis u sabin. ");
INSERT INTO bjp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Biil tikas i kep ufu liu sing iau, biil. Ia lin liu kiak ini wolwol kiak tom. I mel e rakrakai kiak una lin u ke imel e rakrakai kiak una kep fafis u. Tier igii, Tata tom i fas ta iau isi ian tel u.” ");
INSERT INTO bjp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wara na orek ae, ka mel sabin e tampaek na fatpoton fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ifuun lo ri, ri tarah, “I mel e tanwa laulau lo ma i talos. Gam wong sing i isi sah?” ");
INSERT INTO bjp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Isau le fal lo ri ka tarah, “Se imel e tanwa laulau lo, biil i orek la aragii, biil. Tanwa laulau biil tom ifasi in sapeng na matan ti kut.” ");
INSERT INTO bjp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na aunbiing ae, ri tel nenge ngasa na Ierusalem una wolpes aunbiing ae ri fakalok fafis ta Felun Tunmapek lo. Ri tel u la na funiil ae falifu i mir la lo. ");
INSERT INTO bjp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu tinaiwa na palgan ubiif kale Felun Tunmapek, na palpalbuang ae ri foteng u ini Palpalbuang ke Solomon. ");
INSERT INTO bjp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Foron famfamu ken fan Iudaia ri ka kawil u ma ri ka diik u aragii, “Nangis mang ok fas kemem le wo seh? Male o Mesaia, ke ok fas fatus kemem.” ");
INSERT INTO bjp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu ka kiliis ri aragii, “Ia ka fas ta gam, isau le biil gam unune. Foron rakrakai na foim ae ia tel u ini asa Tata, i finngas gam le iau e seh. ");
INSERT INTO bjp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Isau le biil gam to unune, wara le biil gam sipsip kiak. ");
INSERT INTO bjp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Foron sipsip kiak ri ongen failiim kineng la, ia usum lo ri ma ri mi la lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ia ta liu fitliu usuf ri ma biil rin to fiu. Biil tikas ifasi in dat ufu ri tina limang. ");
INSERT INTO bjp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma Tata ae i ta ta ri usuf iau, i laumet kanaka lo ri tikii. Ma biil tikas ifasi in dat ufu ri tina lima Tata. ");
INSERT INTO bjp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kama e Tata, itikii sau lo kamah.” ");
INSERT INTO bjp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ke foron famfamu ken fan Iudaia ri ka sik fat sabin una luumete u. ");
INSERT INTO bjp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isau le, Iesu ka tara sing ri aragii, “Ia ka finngas ta gam ini foron rokap na foim sing Tata. Neng sa lo ri ae gam ier isi luumete iau kuna?” ");
INSERT INTO bjp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Foron famfamu ken fan Iudaia ri ka kiliis u aragii, “Biil keme ier isi luumete wo kunan foron rakrakai na foim ae o tel ta u, biil. Keme ier isi luumete wo kunan orek laulau ae o use ta u. Wara le wo kaltu foes sau ma o ka tara bin le wo God.” ");
INSERT INTO bjp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu ka kiliis ri aragii, “Arafah, biil ri siit ta u na Buk na Gogoh le, God i tarah, ‘Gam foron god’? ");
INSERT INTO bjp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Fanu ae God i ta ta orek kia usuf ri, i foteng ri ini foron god. Ma foron sun orek ae na Buk na Gogoh in kiis fitliu. ");
INSERT INTO bjp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Male i arae, ke arafa lo ier ae Tata ka kale ta u ma ka wuun ufu ta uga na piklinbat? Isi sa bin gam ka tiu iau le ia orek laulau, aunbiing ia tara le ia Kalalik ke God? ");
INSERT INTO bjp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Male biil ia tel foron foim la ke Tata, ke gong gam unune lo iau, gong. ");
INSERT INTO bjp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma igii ia tel foim kia. Taftawa le biil gam unune lo iau, isau le gamen unune, wara na foron foim ia tel u, isi gamek usum ma gamek malal le Tata i patep lo iau ma ia patep lo Tata.” ");
INSERT INTO bjp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ke ri ka totof sabin isi luse u, isau le ka alfe ri ke ka la. ");
INSERT INTO bjp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ke namih, ka sopaket dan na Ioridan sabin una falifu ae pakanini Jon i baptais fanu la wah ke ka melmel aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Fanu fuun ri ka la usuf i, ke ri ka tarah, “Taftawa le Jon biil i fatapiek ta ti fakileng, isau le foron tier tikii ae i use ta u lon kaltu igii, i tekentu.” ");
INSERT INTO bjp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ke fanu fuun ri ka unune lo, na falifu ae. ");
INSERT INTO bjp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nenge kaltu tina Beteni, asa e Lasarus, i sasem. I fenelik e Maria ru la kisilik e Mata. ");
INSERT INTO bjp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma Maria sau ae, i fore ta sanda na iun keke Kumguui ma ka salis fasengseng u ini olo. ");
INSERT INTO bjp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pesu, ru la kisilik, ru ka fawuun isi Iesu aragii, “Kumguui, ier ae o ier kanaka isi, i sasem.” ");
INSERT INTO bjp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Isau le aunbiing Iesu i ongen u, ka tarah, “Sasem igii, biil in farfarop na minet, biil. Sasem igii una finngas memeh ke God, isi Kalalik ke God ik kep memeh lo.” ");
INSERT INTO bjp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu i ier kanaka isi Mata ru la kisilik e Maria tura Lasarus fenelik ruh. ");
INSERT INTO bjp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Taftawa ka ongen ta u le Lasarus i sasem, isau le ka kiis biitom na maleh ae pes iwu e biing. ");
INSERT INTO bjp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nami ka fas berberat na fafausum kia aragii, “Kerek fis sabin una Iudaia.” ");
INSERT INTO bjp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ri ka tara sing i aragii, “Rabi, pakanini sau foron famfamu ken fan Iudaia ri ier ta isi luumete wo. Ma igii, o ka ier sabin isi fis unaiwa?” ");
INSERT INTO bjp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ke Iesu ka kiliis ri aragii, “I sangful ini u e kiptin aunbiing na nenge biing, bikiih? Kaltu i la na ien, biil in to tipeh, biil. Wara le i par na malal na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Isau male in la na wor, ke in tipeh, wara le biil ti malal kia.” ");
INSERT INTO bjp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Aunbiing ka use ta u arae, ka fas ri mang le, “Talrer, Lasarus, ka masun tah. Isau le, ian la ma iak famat u.” ");
INSERT INTO bjp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Berberat na fafausum kia ri ka kiliis u aragii, “Kumguui, male i masun, ke sasem kia in rop.” ");
INSERT INTO bjp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kamtinan orek ke Iesu le, Lasarus ka met tah. Isau le, berberat na fafausum kia ri ka wol le, i masun sau. ");
INSERT INTO bjp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Pesu, Iesu ka fas ri mang aragii, “Lasarus ka met tah. ");
INSERT INTO bjp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wara lo gam ke ia ka laes le biil ia tinaiwa naisa, isi gamek unune. Ma igii, kere mang unaisa.” ");
INSERT INTO bjp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ke Tomas ka fas berberat na fafausum tikii ae aragii, “Kere sabin keren la nami, isi kerek met tura.” Tomas, nenge asa sabin e Didimas, kamtina le Kasang. ");
INSERT INTO bjp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aunbiing Iesu ka tapiek, ka tafe u le ka fet ta e biing kale Lasarus awii na matanfat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Beteni i fatat isi Ierusalem, ifasi sau arae ituul e kilomita, ");
INSERT INTO bjp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","pesu ka fuun e fan Iudaia ri ka la unaisa Mata ru e Maria isi kiiskiis ubaf na olon minet ke fenelik ruh. ");
INSERT INTO bjp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aunbiing Mata ka ongen u le Iesu apiek, ka suu isi tafe u, isau le Maria tinaiwa tom na fel. ");
INSERT INTO bjp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ka fas Iesu aragii, “Kumguui, le wo ta tom aga, ke feneklik biil in to met. ");
INSERT INTO bjp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Isau le igii, ia usum tom le sani o sising God isi, in ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu ka tara sing i aragii, “Fenemlik in apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ka kiliis u aragii, “Ia usum le in apti fis sabin na biingen apaptifis na farfarop na biing.” ");
INSERT INTO bjp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu ka fas u aragii, “Iau tom e apaptifis ke liu. Se i unune lo iau, taftawa le i met, in liu tom. ");
INSERT INTO bjp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma fanse ri liu ma ri unune lo iau, biil rin to met. Arafah, o unune na sani ia use u igii?” ");
INSERT INTO bjp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata ka tarah, “Iuu, Kumguui. Ia unune le wo Mesaia, Kalalik ke God, ae ri use ta u le in la uga na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aunbiing Mata ka use ta u aragii, ka fis ma ka kam pes Maria kisilik una baba ke ka fas u aragii, “Igii mang e Tom Fafausum ma i diik isi wo.” ");
INSERT INTO bjp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Aunbiing Maria i ongen u arae, ka sangar suu isi tafe u. ");
INSERT INTO bjp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu biil biitom i tapiek na maleh ae, tinawii biitom na falifu ae Mata i tafe ta u lo. ");
INSERT INTO bjp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Fan Iudaia ae ri batme ta Maria awii na fel, ri ka par u i sangsangar na aptih ma ka suuh ke ri ka mi lo. Ri wol le in la una matanfat una luun minet isi teng. ");
INSERT INTO bjp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma aunbiing Maria ka tapiek na falifu ae Iesu tinaiwa lo, ka par u, ka luut uf na famu lo ma ka tarah, “Kumguui, male wo ta tom aga, ke feneklik biil in to met.” ");
INSERT INTO bjp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aunbiing Iesu ka par Maria i teng ke fan Iudaia ae ri la tura ri ka teng sabin, ka mamais ma ka purngis e bala. ");
INSERT INTO bjp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ke ka diik ri aragii, “Fia gam faborong u wah?” Ri ka kiliis u aragii, “Kumguui, la ma ok par u.” ");
INSERT INTO bjp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ke Iesu ka teng. ");
INSERT INTO bjp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Fan Iudaia ae ri ka tarah, “Par u, i mais kanaka u tom.” ");
INSERT INTO bjp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Isau le fal lo ri, ri ka tarah, “I sapeng ta na matan nenge kut. Isi sani biil ik lupes ta kaltu igii isi gong i met?” ");
INSERT INTO bjp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ka purngis sabin e bala Iesu ke ka la una matanfat una luun minet. Matanfat ae, ri babat kale u ini nenge tara fat. ");
INSERT INTO bjp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu ka fas ri aragii, “Tel ufu fat ae.” Mata, fenelik e kaltu ae i met, ka tarah, “Kumguui, ka fet ta e biing kale u ma igii ik mapuh tah.” ");
INSERT INTO bjp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ke Iesu ka fas u aragii, “Arafah, biil ia fas ta wo le, male on unune, ke on par memeh ke God?” ");
INSERT INTO bjp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ri ka tel ufu fat. Ke Iesu ka tar ma ka tarah, “Tata, ia fotrokap lo wo, wara le o ka ongen ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ia usum le o ongen iau la tom. Isau le, ia use u aragii una rokap ken fanu igii ri soti turang, isi rik unune le, o wuun ta iau.” ");
INSERT INTO bjp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aunbiing ka use ta u arae, ka perek aragii, “Lasarus, suuh!” ");
INSERT INTO bjp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ke kaltu ae i met tah, ka suuh. Iun lima ke iun keke ri afit ta u ini foron kaen ke nenge kaen sabin ri afit ta paklu ini. Ke Iesu ka fas ri aragii, “Gam puk ufu foron kaen ae lo, isi ik la.” ");
INSERT INTO bjp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pesu, ifuun e fan Iudaia ae ri la ta isi par Maria, ri ka par sani ae Iesu i fatapiek ta u ma ri ka luun unune kiri lo. ");
INSERT INTO bjp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Isau le fal lo ri, ri ka la usuf foron Farasi ma ri ka fas ri ini sani Iesu i tel ta u. ");
INSERT INTO bjp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ke foron laulaumet na pris turan foron Farasi, ri ka kam turim foron famfamu ken fan Iudaia ma ri ka diik ri aragii, “Sani keren tel u? Kaltu igii ka famam fatapiek ifuun mang e fakileng. ");
INSERT INTO bjp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Male keren wol fofoes lo arae, ke fanu tikii rin unune lo ke fan Rom rin la ma rik falaulau Felun Tunmapek turan fanu tikii kirer.” ");
INSERT INTO bjp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Isau le neng lo ri, asa e Kaiapas, i famfamu ken foron pris lo e bet ae, ka fas ri aragii, “Biil gam usum na ti tier! ");
INSERT INTO bjp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Biil gam iliim u le, una rokap kimi, in tikii sau e kaltu in met una kep salan fanu tikii, isi fanu tikii gong ri fiu.” ");
INSERT INTO bjp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Biil i use u aragii ini wolwol kia tom, biil. I famfamu ken foron pris na bet ae, pesu ka orek profet le Iesu in met isi fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma biil isi fan Iudaia sau, biil. In met sabin isi berberat ke God ae ri kiis sarara isi ik tel turim ri ma ik tikii mang lo ri. ");
INSERT INTO bjp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ke tipes u mang na biing ae, ri ka puput isi siimete u. ");
INSERT INTO bjp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pesu, Iesu biil mang i la malal na fatpoton fan Iudaia. Ka kang tinaiwa, una falifu fatat isi falifu foes, na nenge maleh asa e Efraim ma ka melmel aiwa turan berberat na fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aunbiing ka fatat isi Ngasa na Liuliu Kulef ken fan Iudaia, fanu fuun ri ka tatkau una Ierusalem tina foron maleh kiri. Ri la famu na Ngasa na Liuliu Kulef isi fakalkaluu ri ini dan, namin nagogon kiri. ");
INSERT INTO bjp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ke ri ka famam parpar isi Iesu aiwa. Ma aunbiing ri sotsoti la na palgan ubiif kale Felun Tunmapek, ri ka fadiik faliu ini ri tom aragii, “Arafa gam wol arae? Biil mang ngan in la uga na ngasa, beh?” ");
INSERT INTO bjp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ri diik arae, wara le foron laulaumet na pris turan foron Farasi ri ka luun ta rakrakai na orek le, male tikas i usum na falifu ae Iesu i kiis lo, ke ik fas ri isi rik luse u. ");
INSERT INTO bjp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iwon e biing famu na Ngasa na Liuliu Kulef ken fan Iudaia, Iesu ka tapiek na Beteni na maleh ke Lasarus, ier ae Iesu i fapti fafis ta u tina minet. ");
INSERT INTO bjp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na efef, ri ka tel inen una fotrokap lo Iesu. Mata ka sosok ma Lasarus tinawii na fatpoton fanu ae ri kep salri isi ien na luuf. ");
INSERT INTO bjp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ke Maria ka kep nenge sanda ae ri foteng u ini nat ma i fen kanaka e mata. Sanda ae, ifasi aragii ituul e mar e grem. Ka to u na iun keke Iesu ke ka salis u ini olo. Ma rokap na sanan sanda ae ka kuruung tikii palgan fel ae. ");
INSERT INTO bjp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Isau le, Iudas Iskariot, neng lon berberat na fafausum kia, ae nami in ta ufu Iesu una liman tuui, ka tarah, ");
INSERT INTO bjp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Isi sani biil o sufii sanda igii ini ituul e mar e dinaria, isi ok ta pitkalang lo usuf foron lauu?” ");
INSERT INTO bjp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Biil i use u aragii, wara le i wol lon foron lauu, biil. I use u arae, wara le i nenge tom sisii. I parpar la na pitkalang kiri ke ka sukuum u la. ");
INSERT INTO bjp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pesu, Iesu ka kiliis u aragii, “Sok ufu. I tel u una fageges iau una biingen ilile kiak. ");
INSERT INTO bjp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Foron lauu rin kiis fitliu naismi, isau le iau, biil ian kiis fitliu tura gam.” ");
INSERT INTO bjp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Aunbiing tara gur na fan Iudaia ri ka usum mang le Iesu tinaiwa, ri ka tapiek. Biil i wara sau lo Iesu ke ri ka tapiek aiwa, biil. Ri la isi par Lasarus sabin, ae Iesu i fapti fafis ta u tina minet. ");
INSERT INTO bjp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ma foron laulaumet na pris ri ka put orek isi siimete Lasarus sabin, ");
INSERT INTO bjp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","wara le, lo Lasarus sau ke ka fuun e fan Iudaia ri ka su koseng ri ma ri ka luun unune kiri lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na biing namih, gur na fanu ae ri la ta isi Ngasa na Liuliu Kulef, ri ka ongen u le Iesu ae mang tole sal una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ri ka kep foron aun bebeh ma ri ka la isi tafe Iesu ke ri ka tautau aragii, “Osana! Fafakalok usuf ier ae i la uga ini asa Kumguui. Fafakalok usuf king ken fan Israel.” ");
INSERT INTO bjp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu ka tafe nenge dongki ae biil biitom tikas i kiis lo ke ka kiis na olo, arae tom Buk na Gogoh i use ta u le, ");
INSERT INTO bjp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Fan Saion, gong gam sokeh. Par u! King kimi apiek mang. I kiis na nenge fabiro dongki ae biil biitom tikas i kiis lo.” ");
INSERT INTO bjp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na famu, berberat na fafausum kia biil ri malal ta na foron tier tikii igii. Isau le, na aunbiing Iesu ka kep ta memeh kia, ri ka malal mang le, Buk na Gogoh i use ta foron tier igii ulo ma foron tier igii ri ka tel ta u ulo. ");
INSERT INTO bjp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma fanu tinaiwa naisa aunbiing i kam fasuu ta Lasarus tina matanfat ma ka fapti fafis u tina minet, ri ka use sarara u. ");
INSERT INTO bjp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pesu, gur na fanu ri ka la isi tafe u, wara ri ongen ususe na fakileng ae Iesu i fatapiek ta u. ");
INSERT INTO bjp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ke foron Farasi ri ka tara sing ri tom aragii, “Par u, biil ifasi keren tel ti tier. Gam par fanu tikii ae mang na mi.” ");
INSERT INTO bjp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fale fan Grik tinaiwa na fatpoton fanu ae ri la ta isi lotu na Ngasa na Liuliu Kulef na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ri ka la usuf Filip, i tina Betsaida na falifu na Galili ma ri ka sising u aragii, “Ier, keme ier isi par Iesu.” ");
INSERT INTO bjp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip ka la isi fas Enru ke ru turim ru ka fas Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ke Iesu ka kiliis ru aragii, “Aunbiing igii mang ka tapiek tah, isi Kalalik ken Kaltu ik kep memeh. ");
INSERT INTO bjp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tekentu kanaka ia fas kamuh, male nenge kutun wit biil i mang ma ka luut una nanal, ke in tikii ta tom e kutun wit. Isau, male in mang ma ka luut una nanal, ke in kuum ma ik fatapiek in fuun e kutun wit. ");
INSERT INTO bjp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Se i ier kanaka tom isi liu kia, liu ae in mangmangal koseng u. Isau le se i ememse liu kia aga na piklinbat, in pakne u una liu fitliu. ");
INSERT INTO bjp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Se i foim la sing iau, in mi lo iau, isi falifu ae ian la ulo, i sabin in la ulo. Se i foim la sing iau, Tata in sik asa.” ");
INSERT INTO bjp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Igii balang ka tatawin ma sani ian use u? Ian tarah, ‘Tata, faliu iau koseng aunbiing igii’? Biil! Wara sau na aunbiing igii, ke ia ka la uga. ");
INSERT INTO bjp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, me asam!” Ke kinen tikas ka pu tina kukulii, aragii, “Ia ka me ta asang, ma ian me u sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ke gur na fanu ae ri ti aiwa, ri ka ongen u ma ri ka tara le i pah tah, ma fal ri ka tara le nenge angelo i orek ta usuf i. ");
INSERT INTO bjp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu ka kiliis ri aragii, “Orek ae una rokap kimi, biil kiak. ");
INSERT INTO bjp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Igii mang e aunbiing una nagogon fanu tikii na piklinbat. Ma igii mang God ik fes ufu laulaumet tinaga na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Isau le iau, aunbiing ri ka sik ta iau tina nanal, ke ian dat fanu tikii usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ka use u arae, una finngas u arafa in met arae. ");
INSERT INTO bjp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ke gur na fanu ae ri ka kiliis u aragii, “Keme ongen ta u na Nagogon ke Moses, le Mesaia in kiis fitliu. Ke arafa bin, o ka tara le, Kalalik ken Kaltu rin sik u una mawe? Se tutus e Kalalik ken Kaltu?” ");
INSERT INTO bjp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ke Iesu ka fas ri aragii, “Malal ae in kiis biitom naismi na fatuklin aunbiing. Gam la na malal aunbiing imel biitom e malal, tarama kubunor ka afit gam. Kaltu ae i la na kubunor, biil i usum na falifu i la ulo. ");
INSERT INTO bjp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Luun unune kimi na malal, aunbiing imel biitom sing gam, isi gamek tapiek berberat ken malal.” Aunbiing ka orek tikii tah, ka la ma ka mumun lo ri. ");
INSERT INTO bjp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Taftawa le Iesu ka tel ta ifuun e fakileng ta na matri, isau le biil tom ri unune lo. ");
INSERT INTO bjp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Foron tier igii i tapiek una fasuut orek, ae profet Aisaia i use ta u aragii, “Kumguui, se tom ka unune ta na orek kimem? Se tom o ka famalal ta rakrakai kiam usuf i?” ");
INSERT INTO bjp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pesu, biil ifasi rin unune, arae profet Aisaia i use ta u le, ");
INSERT INTO bjp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God ka fakut ta matri ke ka fasorokai ta balri, isi biil ifasi rin par ini matri ke biil i malal e wolwol kiri, isi rik fis usuf iau ma iak faliu ri.” ");
INSERT INTO bjp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia i use ta u arae, wara le ka par ta memeh ke Iesu ke ka ususe lo. ");
INSERT INTO bjp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Isau le, ifuun lon foron famfamu sabin ri unune lo Iesu. Ri soke foron Farasi, pesu biil ri fapos unune kiri, tarama ri ka tikale ri isi gong mang ri lotu na felun lotu. ");
INSERT INTO bjp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wara le ri ier kanaka tom isi ususefages sing fanu ma biil tinbae sing God. ");
INSERT INTO bjp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ke Iesu ka perek aragii, “Se i unune lo iau, biil i unune sau lo iau, biil. I unune sabin lo ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aunbiing i par iau, i par ier sabin ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ia la uga na piklinbat arae malal, isi fanu tikii ae ri unune lo iau biil mang rin kiis na kubunor. ");
INSERT INTO bjp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Se i ongen orek kiak ma biil i mi lo, biil ian to nagogon u. Wara le, biil ia la ta uga isi nagogon fanu na piklinbat, biil. Ia la isi faliu pes ri. ");
INSERT INTO bjp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","I mel e tom nagogon ae in nagogon fanse ae ri ire iau ke biil ri somangat pes foron orek kiak. Foron orek sau ae ia use ta u, in nagogon ri na farfarop na biing. ");
INSERT INTO bjp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wara le, biil ia orek ini wolwol kiak tom, biil. Tata tom ae i wuun ta iau, i fas ta iau ini sani ian use u ma arafa ian use u arae. ");
INSERT INTO bjp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ia usum le orek ke Tata i ta liu fitliu la. Pesu, ia use sani sau ae Tata i fas ta iau isi ian use u.” ");
INSERT INTO bjp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aunbiing Ngasa na Liuliu Kulef ken fan Iudaia ka fatat, Iesu i usum le ka fatat mang e aunbiing isi ik la koseng piklinbat usuf Tama. I ier kanaka isi fanu kia igii na piklinbat ma i mais ri papang na farfarop na liu kia. ");
INSERT INTO bjp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Aunbiing ri ienien la na efef ae, Satan ka susuef ta ulo Iudas Iskariot, kalalik ke Saimon, isi in ta ufu Iesu una liman tuui. ");
INSERT INTO bjp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu ka usum ta le, Tama ka luun ta foron tier tikii na piklin rakrakai kia ma i la tinbae sing God ke in fis sabin usuf God. ");
INSERT INTO bjp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pesu, ka apti koseng inen ae, ka tel ufu nenge kolos ae i kau ta lo na maleh ma ka fis nenge taol na lifa. ");
INSERT INTO bjp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Namih, ka to dan una nenge lus ke ka sufe keken berberat na fafausum kia ma ka salis fasengseng kekri ini taol ae i fis ta u na lifa. ");
INSERT INTO bjp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iesu ka la usuf Saimon Pita ke Pita ka tara sing i aragii, “Be, Kumguui! On sufe kekeng?” ");
INSERT INTO bjp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu ka kiliis u aragii, “Biil o usum na sani ia tel u igii, isau le namih, on usum.” ");
INSERT INTO bjp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita ka tarah, “Biil! Gong o sufe kekeng.” Ke Iesu ka kiliis u aragii, “Male biil ian sufe iun kekem, ke biil ti su kiam lo iau.” ");
INSERT INTO bjp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pita ka tarah, “Kumguui, male arae, ke gong o sufe iun kekeng sau, iun limang ke paklung sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu ka kiliis u aragii, “Kaltu ae ka susuh tah, ka fuu ta e fo. In sufe iun keke sau, wara le pununfo tikii ka fuu tah. Ma gam fuuh, isau le biil e gam tikii.” ");
INSERT INTO bjp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu ka usum ta lo se in ta ufu una liman tuui, pesu ka use u le, biil e ri tikii ri ka fuu tah. ");
INSERT INTO bjp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aunbiing ka sufe tikii ta kekri, ka kau fis na kolos kia ke ka fis una sala ma ka diik ri aragii, “Arafah, gam malal sabin na sani ia ka tel ta u lo gam? ");
INSERT INTO bjp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gam kam iau ini ‘Tom Fafausum’ ke ‘Kumguui.’ Ma orek kimi i tortores, wara le iau tom e ier ae. ");
INSERT INTO bjp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ia Kumguui ke Tom Fafausum kimi. Igii ia ka sufe ta kekmi ke gam sabin gamen sufe faliu kekmi. ");
INSERT INTO bjp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ia ka finngas ta gam ini nenge tintof, isi gam sabin gamek tel u arae ia tel ta u lo gam. ");
INSERT INTO bjp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tekentu kanaka ia fas gam, biil ti fafauun i laumet lo famfamu kia ke nenge kaltu ae i kep orek la, biil i laumet lo kaltu ae i wuun u la. ");
INSERT INTO bjp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Male gam usum na foron tier igii ke gamen kalok, male gam misuut lo. ");
INSERT INTO bjp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Biil ia use gam tikii. Ia usum lon fanse ae ia ka fule pes ta ri. Isau le, orek ae na Buk na Gogoh ik suut mang, ae i tarah, ‘Kaltu ae i ien beret turang, ka tapiek tuui kiak.’ ");
INSERT INTO bjp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ia ka fasfas gam la mang igii, aunbiing biil biitom i tapiek, isi aunbiing in tapiek, ke gamek unune le iau sau e ier ae. ");
INSERT INTO bjp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tekentu kanaka ia fas gam, se i somangat pes iau, i somangat pes ier ae i wuun ta iau.” ");
INSERT INTO bjp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aunbiing ka use ta u arae, ka purngis e bala ke ka use famalal u aragii, “Tekentu kanaka ia fas gam, neng lo gam tom in ta ufu iau una liman tuui.” ");
INSERT INTO bjp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Berberat na fafausum kia ri ka faparia fis ini ri ma ri ka wolpane le, Iesu i use se tutus lo ri. ");
INSERT INTO bjp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Neng lon berberat na fafausum, ier ae Iesu i ier kanaka isi, i kiis fatat ta Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita ka fapik kalalik na fafausum ae, aragii, “Diik u, se tutus tom?” ");
INSERT INTO bjp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ke kalalik na fafausum ae ka gigin fatat Iesu ma ka diik u aragii, “Kumguui, se tom?” ");
INSERT INTO bjp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu ka kiliis u aragii, “Ier sau ae ian falum tigan beret igii na dis ma iak ta u usuf i.” Ke, ka falum tigan beret ae, ma ka ta u usuf Iudas kalalik ke Saimon Iskariot. ");
INSERT INTO bjp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aunbiing sau Iudas ka ien ta beret, Satan ka susuef lo. Ke Iesu ka fas u aragii, “Sani ae le on tel u, tel sape u.” ");
INSERT INTO bjp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Isau le, biil tikas lo ri na inen ae, i usum le isi sa Iesu ka tara arae sing Iudas. ");
INSERT INTO bjp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iudas i parpar la na pitkalang kiri, pesu fale berberat na fafausum ri ka wol le Iesu i fas u isi in fiil ti tier ae ri dar u na inen ae, le in ta ti tier usuf foron lauu. ");
INSERT INTO bjp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aunbiing sau Iudas i ien tikii beret ae, ka suu koseng ri. Ke ka kubunor. ");
INSERT INTO bjp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Aunbiing Iudas ka la tah, Iesu ka fas ri aragii, “Igii Kalalik ken Kaltu ka kep memeh ma God i kep memeh lon Kalalik ken Kaltu. ");
INSERT INTO bjp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Male God i kep memeh lo, ke God tom in me Kalalik ken Kaltu ma God in me sape u. ");
INSERT INTO bjp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Berberat kiak, ian kiis biitom tura gam na fatuklin aunbiing sau. Gamen im isi iau ma arae sau ia ka fas ta foron famfamu ken fan Iudaia ke igii ia ka fas gam le: Falifu ae ian la ulo, biil ifasi gamen la ulo. ");
INSERT INTO bjp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Igii e nenge nagogon fuuh ia ta u usuf gam: Gamen famais faliu ini gam. Arae sau ia mais ta gam ke gam sabin gamen famais faliu ini gam. ");
INSERT INTO bjp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Male gam famais faliu ini gam ke fanu tikii rin usum le gam berberat na fafausum kiak.” ");
INSERT INTO bjp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita ka diik u aragii, “Kumguui, on la uwah?” Iesu ka kiliis u aragii, “Falifu ae ian la ulo, biil ifasi on la ulo igii, isau le namih, on mih.” ");
INSERT INTO bjp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ka diik u aragii, “Kumguui, isi sani biil ifasi ian mi lo wo igii? Ian lin liu kiak isi wo.” ");
INSERT INTO bjp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ke Iesu ka kiliis u aragii, “Arafah, on lin liu kiam isi iau, beh? Tekentu kanaka ia fas o, aunbiing to biil biitom in teng, ke fatuul ok fakawe ufu iau.” ");
INSERT INTO bjp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu ka tarah, “Gong i purngis e balmi. Unune lo God ke unune sabin lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ifuun e mua na fel ke Tata ma ian la isi fageges ti salmi. Male biil i tekentu, ke biil ian fas ta gam ini foron tier igii. ");
INSERT INTO bjp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ke, male ian la isi fageges ti salmi, ian fis sabin ke iak telpes gam unaisang, isi gam sabin, gamek kiis turang na falifu ae ia kiis la wah. ");
INSERT INTO bjp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gam usum na sal una falifu ae ian la ulo.” ");
INSERT INTO bjp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ka tarah, “Kumguui, biil keme to usum na falifu ae on la ulo. Ke arafa kemen usum arae na sal?” ");
INSERT INTO bjp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu ka kiliis u aragii, “Iau tom e sal, iau tom e tekentu ke iau tom e liu. Biil tikas in la usuf Tata na nenge sal keskes, biil. Lo iau sau. ");
INSERT INTO bjp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Male gam ka usum ta lo iau, ke gamen usum sabin lo Tata. Tipes u igii, gam ka usum ta lo ke gam ka par ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip ka tarah, “Kumguui, finngas kemem ini Tamam, i sau e tier ae keme ier isi.” ");
INSERT INTO bjp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu ka kiliis u aragii, “Filip, ia ka kiis dolo ta tura gam ma biil biitom o usum lo iau? Se i par iau, ka par ta Tata. Arafa bin, o ka tara le, ‘Finngas kemem ini Tamam’? ");
INSERT INTO bjp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Biil o unune le ia patep lo Tata ma Tata i patep lo iau? Foron orek ia fas ta gam ini, biil sing iau tom, biil. Tata tom ae i patep lo iau, i tel foim kia. ");
INSERT INTO bjp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Unune lo iau, aunbiing ia tara le, ia patep lo Tata ma Tata i patep lo iau. Male biil gam unune na orek kiak, ke gamek unune sau, wara na foron foim ia tel ta u. ");
INSERT INTO bjp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tekentu kanaka ia fas gam, se i unune lo iau, in tel foron foim ae ia tel u la. Ma in tel foron foim ae in laumet na foron foim ia tel ta u, wara le ian la usuf Tata. ");
INSERT INTO bjp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma ian tel sani gam sising u na asang, isi Kalalik ik ta memeh usuf Tama. ");
INSERT INTO bjp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sani gam sising iau isi na asang, ian tel u. ");
INSERT INTO bjp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Male gam ier kanaka isi iau, ke gamen misuut na foron nagogon kiak. ");
INSERT INTO bjp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma ian sising Tata ke ik ta nenge Tom Falupes sabin usuf gam, ae in kiis fitliu naismi. ");
INSERT INTO bjp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","I e Tanwan Tekentu. Fanu na piklinbat biil ifasi rin kep u, wara le, biil ri par u ke biil ri usum lo. Isau le gam usum lo, wara le i kiis la tura gam ma in susuef lo gam. ");
INSERT INTO bjp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Biil ian to fin koseng gam arae foron natunsih, biil. Ian fis unaismi. ");
INSERT INTO bjp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Biil in sawin, ke fanu na piklinbat biil mang rin par iau. Isau le gamen par iau. Wara ia liu, ke gam sabin gamen liu. ");
INSERT INTO bjp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na biing ae, gamen usum le ia patep lo Tata ke gam ka patep lo iau ma ia ka patep lo gam. ");
INSERT INTO bjp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Se i pose papte nagogon kiak ma ka mi lo, ier sau ae, i ier kanaka isi iau. Se i ier isi iau, Tata in ier isi ke ia sabin ian ier isi ma ian finngas iau tom usuf i.” ");
INSERT INTO bjp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Namih, Iudas (biil e Iudas Iskariot) ka tarah, “Isau le, Kumguui, isi sa o ka ier isi finngas wo sau usuf kemem ma biil usuf fanu tikii na piklinbat?” ");
INSERT INTO bjp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu ka kiliis u aragii, “Male se i ier kanaka isi iau, ke in misuut na foron fafausum kiak. Tata in ier isi ma kaman la usuf i ke kamak mel tura. ");
INSERT INTO bjp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Se ae biil i ier isi iau, biil i misuut la na foron fafausum kiak. Foron orek igii gam ongen u, biil e foron orek kiak tom, biil. Foron orek ke Tata tom, ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Foron tier igii, ia fas ta gam ini aunbiing ia kiis biitom tura gam. ");
INSERT INTO bjp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Isau le Tom Falupes, i e Tanwa Kalkaluu ae Tata in wuun ufu uga ini asang, in fausum gam ini foron tier tikii ke ik fapitil wolwol kimi ini foron tier tikii ae ia fas ta gam ini. ");
INSERT INTO bjp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Siaroh ia ta u usuf gam. Ma siaroh kiak tom ia ta u usuf gam. Biil ia ta u arae fanu na piklinbat ri ta u la, biil. Gong i purngis e balmi ke gong gam sokeh. ");
INSERT INTO bjp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Gam ongen ta u, ia tara ta le, ‘Ian la koseng gam ma namih, ian fis unaismi.’ Male gam ier kanaka isi iau, ke gamen laes le ian la usuf Tata, wara le i laumet lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ia ka fas gam mang igii, aunbiing biil biitom i tapiek, isi aunbiing foron tier ae in tapiek, ke gamek unune. ");
INSERT INTO bjp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Biil ian orek dolo tura gam, wara le laulaumet tinaga na piklinbat, apiek mang. Biil ti rakrakai kia na olong, ");
INSERT INTO bjp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","isau le, ia tel fasuut sani sau ae Tata i fas ta iau le ian tel u, isi fanu tikii na piklinbat rik usum le ia ier kanaka isi Tata. “Gam aptih ma kerek la.” ");
INSERT INTO bjp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu ka tara sabin aragii, “Iau tom e au na wain tekentu ma Tata i e tom fofonoi na mok. ");
INSERT INTO bjp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I bus ufu la e foron akan au tikii lo iau, ae biil ri fua la. Ma i sifi foron akan au tikii ae ri fua la, isi rik lala fua. ");
INSERT INTO bjp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gam ka tapiek fuu tah, wara na foron orek ae ia fas ta gam ini. ");
INSERT INTO bjp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gam patep lo iau, ma iak patep lo gam. Biil ti akan wain ifasi in fua foes kia tom, biil. In patep tom na au na wain. Ifasi sabin arae lo gam, biil ifasi gamen fua, le biil gam patep lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iau tom e au na wain ma gam foron aka. Male tikas i patep lo iau ma ia ka patep lo, ke in lala fua. Male biil gam patep lo iau, ke biil ifasi gamen tel ti tier. ");
INSERT INTO bjp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Male tikas biil i patep lo iau, ke i arae akan au sau ae ri lin ufu ma ka mang. Foron matngan akan au arae, ri sik turim ri la ke ri ka lin u la una yiif ma ka sok. ");
INSERT INTO bjp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Male gam patep lo iau ma foron orek kiak ka kiis lo gam, gamen sising isi sani gam ier isi, ke gamen kep u. ");
INSERT INTO bjp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tata in kep memeh aunbiing gam lala fua ma fua gam in finngas u le gam berberat na fafausum kiak. ");
INSERT INTO bjp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Arae sau Tata i ier kanaka ta isi iau, ke ia sabin ia ka ier kanaka isi gam. Ma gam, fitliu gamen kiis na famais kiak. ");
INSERT INTO bjp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Male gam misuut na foron nagogon kiak, ke fitliu gamen kiis na famais kiak. Arae sau, ia misuut ta na foron nagogon ke Tata ke fitliu ia kiis na famais kia. ");
INSERT INTO bjp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ia ka fas ta gam ini foron tier igii, isi laes kiak, ik kiis na balmi. Ma laes ae, ik kuruung tikii gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Igii e nagogon kiak usuf gam: Gamen famais faliu ini gam, arae sau ia mais ta gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Biil ti famais ken tikas, i laumet na famais ke ier ae i lin liu kia isi foron tala. ");
INSERT INTO bjp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gam foron talang, male gam tel sani ia use u. ");
INSERT INTO bjp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Biil mang ian foteng gam arae foron fafauun, biil. Wara le, nenge fafauun biil i usum na foron foim ken laulaumet kia. Isau le, ia ka foteng ta gam arae foron talang, wara le foron tier tikii ia ongen ta u sing Tata, ia ka famalal ta u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Biil gam tim pes ta iau, biil. Ia tom ia tim pes ta gam ke ia ka tus pes ta gam isi gamen la ma gamek fua. Ma fua gam in ti fitliu. Ke sani gam sising Tata isi na asang, in ta u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Igii e nagogon kiak: Gamen famais faliu ini gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Male fanu na piklinbat ri ememse gam, ke gamen wolpes u le, ri ememse famu ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Male gam ken piklinbat, ke in ier kanaka isi gam arae kia tutus tom. Isau le gam biil ken piklinbat, wara le ia ka tim pes ta gam koseng piklinbat. Pesu, fanu tina piklinbat ri ka ememse gam. ");
INSERT INTO bjp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gamen wolpes foron orek ae ia fas ta gam ini: Biil ti fafauun i laumet lon laulaumet kia. Male ri ta ta fangungut usuf iau, ke rin ta fangungut sabin usuf gam. Male ri misuut ta na fafausum kiak, ke rin misuut sabin na fafausum kimi. ");
INSERT INTO bjp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Isau le rin fatel gam arae, wara na asang. Wara le, biil ri usum lo ier ae i wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Male biil ia la ta uga ma ia ka fas ta ri, ke biil ifasi rin tiu ri ini sinang laulau kiri. Isau le igii ia ka fas ta ri, pesu biil ti sal kiri una fakawe ufu sinang laulau kiri. ");
INSERT INTO bjp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Se i ememse iau, i ememse Tata sabin. ");
INSERT INTO bjp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Male biil ia tel ta foron rakrakai na foim na palga ri ae biil tikas i tel ta u, ke biil ifasi rin tiu ri ini sinang laulau kiri. Ma igii, taftawa ri ka par ta foron rakrakai na foim ae ia tel ta u, isau le ri ka ememse kama turim tom e Tata. ");
INSERT INTO bjp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ri tel u arae, una fasuut orek ae na Buk na Gogoh le, ‘Ri ememse foes ta iau.’ ");
INSERT INTO bjp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ian wuun ufu Tom Falupes tinbae sing Tata. I e Tanwan Tekentu, ae in pu tinbae sing Tata. Aunbiing in tapiek, ik famalal gam ini iau. ");
INSERT INTO bjp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ke gam sabin, gamen famalal iau usuf fanu, wara le aunbiing ia tipes foim, gam kiis tom turang. ");
INSERT INTO bjp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ia ka fas ta gam ini foron tier igii, isi unune kimi gong in luut. ");
INSERT INTO bjp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Rin gogoh ufu gam tina foron felun lotu. Ke nenge aunbiing in tapiek, ae fanse ae ri siimete gam rin wol le ri tel foim ke God. ");
INSERT INTO bjp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rin tel matngan sinang arae, wara le biil ri usum lo kama e Tata. ");
INSERT INTO bjp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ia ka fas ta gam ini foron tier igii, isi aunbiing in tapiek ke gamek wolpes u le ia ka fas ta gam ini. Tinpakanini biil ia fas ta gam ini, wara le ia kiis biitom tura gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Igii, iak la mang usuf ier ae i wuun ta iau ma biil tikas lo gam i diik iau le, ‘On la uwah?’ ");
INSERT INTO bjp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mamais ka fuun na balmi, wara le ia fas gam ini foron tier ae. ");
INSERT INTO bjp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Isau le, tekentu kanaka ia fas gam, ian la koseng gam una rokap kimi. Wara le, male biil ian la, ke Tom Fafalupes biil in to la usuf gam. Isau male ian la, ke iak wuun ufu usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma aunbiing in tapiek, in famalal fanu na piklinbat ini sinang laulau kiri ke ik famalal ri ini tortores na sinang ke ini nagogon ae God in tel u. ");
INSERT INTO bjp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Sinang laulau kiri, i aragii: Biil ri to unune lo iau. ");
INSERT INTO bjp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ke tortores na sinang i aragii: Ian la usuf Tata ma biil sabin gamen par iau. ");
INSERT INTO bjp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ke nagogon ke God i aragii: God ka luun ta nagogon lon laulaumet tinaga na piklinbat isi in fiu. ");
INSERT INTO bjp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ifuun biitom e tier ian fas gam ini, isau le biil biitom ifasi gamen kep u igii. ");
INSERT INTO bjp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Isau le, aunbiing Tanwan Tekentu in tapiek, in finngas gam ini foron tier tikii ae i tekentu. Biil in orek ini wolwol kia tom, biil. In use sani sau i ongen u ma ik fas gam ini sani in tapiek namih. ");
INSERT INTO bjp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ke ik ta memeh usuf iau, wara le in kep orek kiak ma ik famalal u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Foron tier tikii ke Tata, kiak. I e wara ia ka tara le, Tanwa Kalkaluu in kep foron orek kiak ke ik famalal u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Biil in sawin ke biil mang gamen par iau. Ke namih, biil in sawin ke gamek par iau sabin.” ");
INSERT INTO bjp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Fale berberat na fafausum kia ri ka fadiik faliu ini ri aragii, “Sani e kamtinan iun orek ae i fas ta kerer ini? I tara le, ‘Biil in sawin ke biil mang gamen par iau, ke biil in sawin ke gamek par iau sabin’ ke ka tara sabin le, ‘Wara le ia la usuf Tata.’” ");
INSERT INTO bjp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ke ri ka famam fadiik biitom le, “Sani tom e kamtinan orek kia ae i tara le, ‘biil in sawin’? Biil kere malal na sani i use u.” ");
INSERT INTO bjp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu ka usum ta le ri ier isi diik u isi sani i use ta u, pesu ka tara sing ri aragii, “Arafah, gam famam fadiik faliu ini gam tom isi kamtinan orek ae ia use ta u le, ‘Biil in sawin ke biil mang gamen par iau ke biil in sawin ke gamek par iau sabin’? ");
INSERT INTO bjp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tekentu kanaka ia fas gam, gamen teng ke gamek mamais, isau le fanu na piklinbat rin laes. Gamen mamais, isau le mamais kimi ik sokiliis una laes. ");
INSERT INTO bjp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aunbiing nenge fifin i fafang, i kalsakai fangungut wara le aunbiing kia ka tapiek mang. Isau le aunbiing kalalik ka pang tah, ka ruu ufu mang e fangungut ae i kalsakai ta u. Ka laes mang, wara le nenge kalalik ka pang ta una piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ke ifasi sabin arae ini gam, igii e aunbiing kimi una mamais, isau le nami ian par gam sabin ke gamek laes ma biil tikas in tel ufu e laes ae sing gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na biing ae, biil mang gamen sising iau isi ti tier. Tekentu kanaka ia fas gam, sani gam sising Tata isi na asang, in ta u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ka papang igii, biil tom gam sising ta ti tier na asang. Gamen sising ke gamek kep u, isi laes kimi ik kuruur. ");
INSERT INTO bjp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ia fas gam ini foron tier igii, ini orek fatoftof. Isau le, nenge aunbiing in tapiek, ae biil mang ian use orek fatoftof, biil. Ian use famalal Tata mang usuf gam. ");
INSERT INTO bjp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na biing ae, gamen sising ini asang. Biil ia use u le ian sising Tata isi in lupes gam, biil. ");
INSERT INTO bjp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tata tom i ier kanaka isi gam, wara le gam ier kanaka isi iau ma gam unune le, ia la tinbae sing God. ");
INSERT INTO bjp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ia la ta tinbae sing Tata uga na piklinbat. Ma igii, iak la koseng piklinbat ma iak fis ubae usuf Tata.” ");
INSERT INTO bjp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ke berberat na fafausum kia ri ka tarah, “Igii o ka orek malal mang, biil mang o orek fatoftof. ");
INSERT INTO bjp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Keme ka usum mang le o usum na foron tier tikii ma biil o dar tikas in diik o. Pesu, keme ka unune le o la tom tinbae sing God.” ");
INSERT INTO bjp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu ka kiliis ri aragii, “Gam ka am unune mang? ");
INSERT INTO bjp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Isau le nenge aunbiing in tapiek ma igii mang ka tapiek tah, ae gamen fin sarara una foron maleh temtem tikii kimi koseng iau. Isau le biil ia keskes, biil. Tata igii tom turang. ");
INSERT INTO bjp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ia ka fas ta gam ini foron tier igii, isi aunbiing gam patep lo iau, ik mel e siaroh sing gam. Ma aga na piklinbat, gamen ngar tatawin. Isau le in rorokiis e balmi, wara le ia ka farop ta rakrakai ken piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aunbiing Iesu ka use ta u arae, ka tar una kukulii ma ka sising aragii: “Tata, aunbiing ka tapiek mang. Me kem Kalalik, isi kem Kalalik ik me o. ");
INSERT INTO bjp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wara le, o ka ta ta rakrakai usuf i na olon fanu tikii, isi ik ta liu fitliu usuf fanu tikii ae o ka ta ta u usuf i. ");
INSERT INTO bjp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Liu fitliu i aragii: Le fanu rin usum lo wo, itikii sau e God tekentu ke lo Iesu Karisito ae o wuun ta u. ");
INSERT INTO bjp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ia ka me ta wo aga na piklinbat, aunbiing ia farop foim ae o ta ta u usuf iau isi ian tel u. ");
INSERT INTO bjp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, igii on me iau awii naisam, ini memeh ae imel ta sing iau aunbiing ia kiis ta naisam, aunbiing biil biitom o fakiis ta piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ia ka famalal ta asam usuf fanu ae o ta ta ri usuf iau tina piklinbat. Ri kiam tom. O ta ta ri usuf iau ma ri ka misuut ta na orek kiam. ");
INSERT INTO bjp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Igii ri ka usum ta le, foron tier tikii ae o ta ta u usuf iau tinawii tom sing o. ");
INSERT INTO bjp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wara le foron orek ae o ta ta u usuf iau, ia ka ta ta u usuf ri ma ri ka somangat pes ta u. Ri usum tekentu tom le, ia la tinbae sing o ma ri ka unune ta le o wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ia sising isi ri ma biil isi fanu tikii na piklinbat, biil. Ia sising sau isi fanse ae o ka ta ta ri usuf iau, wara le ri kiam tom. ");
INSERT INTO bjp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Fanu tikii kiak, kiam, ma fanu tikii kiam, kiak. Ma wara lo ri, ia ka kep memeh. ");
INSERT INTO bjp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma igii, iak la mang tinaga na piklinbat, isau le rin kiis biitom na piklinbat. Tata, o kalkaluu, fofonoi lo ri ini rakrakai ae na asam, ae o foteng ta iau ini, isi ik tikii lo ri arae itikii sau lo karah. ");
INSERT INTO bjp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aunbiing ia kiis ta tura ri, ia fofonoi lo ri ini as ae o foteng ta iau ini. Ia fofonoi lo ri ma biil tikas lo ri i mangmangal, biil. Itikii sau, ier ae i mi na sal una fiu, isi orek ae na Buk na Gogoh ik suut. ");
INSERT INTO bjp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Igii iak la mang usuf o. Isau le, ia use foron tier igii, aunbiing ia kiis biitom aga na piklinbat, isi laes kiak ik kuruung tikii ri. ");
INSERT INTO bjp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ia ka ta ta orek kiam usuf ri ma fanu na piklinbat ri ka ememse ta ri. Wara le, biil mang ri ken piklinbat. Arae iau sabin biil ken piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Biil ia sising le on kep ufu ri tinaga na piklinbat, biil. Ia sising le on fofonoi lo ri koseng kaltu laulau. ");
INSERT INTO bjp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Biil ri ken piklinbat, arae iau sabin biil ken piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Fakalkaluu ri ini tekentu ma orek kiam i tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Arae o wuun ufu ta iau uga na piklinbat ke ia sabin ia ka wuun ri una piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Una rokap kiri, ia ka fakalkaluu iau tom, isi ri sabin rik kalkaluu tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Biil ia sising isi berberat na fafausum igii sau, biil. Ia sising sabin isi fanse ae rin unune lo iau, wara na fafas kiri. ");
INSERT INTO bjp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ia sising isi ik tikii sau lo ri. Tata, arae sau o patep lo iau ma ia patep lo wo, ri sabin rik patep lo karah isi fanu tikii na piklinbat rik unune le o wuun ta iau. ");
INSERT INTO bjp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Memeh ae o ta ta u usuf iau, ia ka ta ta u usuf ri, isi ik tikii sau lo ri arae itikii lo karah. ");
INSERT INTO bjp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ia patep lo ri ma wo patep lo iau, isi ik tikii tutus sau lo ri isi fanu na piklinbat rik usum le o wuun ta iau ma o ier kanaka isi ri, arae o ier kanaka isi iau. ");
INSERT INTO bjp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, ia ier isi fanu ae o ta ta ri usuf iau, rin kiis turang na falifu ae ia kiis la wah, ma rik par memeh kiak. I e memeh ae o ta ta u usuf iau, wara le o ier kanaka isi iau, aunbiing biil biitom o fakiis ta piklinbat. ");
INSERT INTO bjp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tata, o tom tortores, taftawa le fanu na piklinbat biil ri usum lo wo, isau le ia usum lo wo ma fanu igii ri usum le o wuun ta iau uga. ");
INSERT INTO bjp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ia ka famalal ta wo usuf ri ma ian famam famalal wo biitom, isi famais kiam usuf iau, ik kiis lo ri, isi iau tom iak patep lo ri.” ");
INSERT INTO bjp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aunbiing Iesu ka sising tikii tah, i turan berberat na fafausum kia ri ka apti koseng falifu ae ke ri ka sopaket palgan dan na Kidron. Na nenge baba, imel e nenge porpor olif ma Iesu turan berberat na fafausum kia ri ka la unaiwa. ");
INSERT INTO bjp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iudas, ier ae in ta ufu Iesu na liman tuui, ka usum ta na falifu ae, wara le ifuun e aunbiing Iesu turan berberat na fafausum kia ri kiis turim la aiwa. ");
INSERT INTO bjp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pesu, Iudas ka lame foron tom fapaket turan fale tom parpar kale Felun Tunmapek ae foron laulaumet na pris turan foron Farasi ri wuun ta ri ma ri ka la una falifu ae. Ri kep foron lam, foron tier una bul ke foron tier una fapaket. ");
INSERT INTO bjp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu ka usum ta na foron tier tikii ae in tapiek lo, pesu ka la ma ka diik ri aragii, “Gam im isi seh?” ");
INSERT INTO bjp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ri ka kiliis u aragii, “Iesu tina Nasaret.” Ke Iesu ka tarah, “Iau sau igii.” Iudas, ier ae in ta ufu Iesu una liman tuui, tinawii sabin i ti ta tura ri. ");
INSERT INTO bjp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aunbiing Iesu i tara le, “Iau sau igii,” ke ri ka su fis ma ri ka luut una nanal. ");
INSERT INTO bjp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu ka diik ri tala aragii, “Gam ier isi seh?” Ke ri ka kiliis u sabin aragii, “Iesu tina Nasaret.” ");
INSERT INTO bjp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu ka kiliis ri aragii, “Ia ka fas ta gam le iau sau igii. Male gam im isi iau, ke gamen sok ufu fanu igii rik la.” ");
INSERT INTO bjp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tier igii i tapiek isi foron orek ae Iesu i use ta u ik suut: “Biil tikas i mangmangal lon fanse ae o ka ta ta ri usuf iau.” ");
INSERT INTO bjp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ke Saimon Pita ae imel e popok una fapaket sing i, ka fut ufu ma ka kasim ufu nenge balbalu Malkus na mia. Malkus i nenge fafauun ken famfamu ken foron pris. ");
INSERT INTO bjp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu ka fas Pita aragii, “Siing fafis popok kiam na poko! Kol, biil mang ian yin na kap ae Tata i ta ta u usuf iau, beh?” ");
INSERT INTO bjp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Namih, foron tom fapaket turan kabisit kiri ke foron tom parpar kale Felun Tunmapek ken fan Iudaia ri ka luse Iesu ma ri ka kabet u. ");
INSERT INTO bjp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ke ri ka lame famu Iesu usuf Anas, ena Kaiapas. Kaiapas i famfamu ken foron pris na bet ae. ");
INSERT INTO bjp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas sau ae, i ta ta fafanau usuf fan Iudaia, le in rokap male in tikii sau e kaltu in met una kep salan fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ru e nenge kalalik na fafausum sabin ru mimi la lo Iesu. Famfamu ken foron pris i usum lo e kalalik na fafausum ae, pesu ka kau tura Iesu una palgan ubiif kale falifu ken pris ae. ");
INSERT INTO bjp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Isau le Pita i nene sau awii na maleh na matanfel. Kalalik na fafausum ae famfamu ken foron pris i usum lo, ka fis sabin ma ka fas tah ae i parpar na matanfel, ke ka lame fakau Pita. ");
INSERT INTO bjp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tah ae i parpar na matanfel ae ka tara sing Pita le, “O sabin o neng lon berberat na fafausum kia, bikiih?” Pita ka kiliis u aragii, “Ia biil.” ");
INSERT INTO bjp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ma foron fafauun turan foron tom parpar kale Felun Tunmapek, ri sotsoti la kawil yiif ae ri map ta u una mingmingih, wara le falifu i mir. Pita sabin i ti aiwa ma ka mingmingih tura ri. ");
INSERT INTO bjp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na aunbiing sabin ae, famfamu ken foron pris ka diikdiik faikis Iesu isi berberat na fafausum kia ke isi fafausum kia. ");
INSERT INTO bjp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu ka kiliis u aragii, “Ia ka orek malal ta usuf fanu tikii, ke ia tel fafausum la tom na foron felun lotu ke na Felun Tunmapek ae fan Iudaia ri la turim la wah. Biil ia use fakum ta ti tier. ");
INSERT INTO bjp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Isi sani o ka diik iau? Diik fanu ae ri ongen ta sani ia fas ta ri ini. Ri usum na sani ia use ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aunbiing Iesu i use u arae, nenge tom parpar kale Felun Tunmapek tinaiwa, ka pose u na posong na mata ke ka tara sing i aragii, “O kiliis orek ken famfamu ken foron pris arae isi sanih?” ");
INSERT INTO bjp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu ka kiliis u aragii, “Male sani ia use u biil i tortores, ke ok famalal u le biil i tortores. Isau male ia orek tekentu, ke isi sa o ka pose iau?” ");
INSERT INTO bjp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ke Anas ka wuun ufu ini kamkabet lo usuf Kaiapas ae i famfamu ken foron pris. ");
INSERT INTO bjp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita tinaiwa biitom i mingmingih la, ke ri ka tara sing i aragii, “O sabin o neng lon berberat na fafausum kia, bikiih?” Ka fakawe aragii, “Ia biil.” ");
INSERT INTO bjp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nenge fafauun ken famfamu ken foron pris ma i sikinting lon kaltu ae Pita i kasim ufu ta balbalu, ka tara sing i aragii, “O sangan ia par ta wo tura Iesu na porpor olif, bikiih?” ");
INSERT INTO bjp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita ka fakawe sabin. Ke fanpil nenge to ka teng. ");
INSERT INTO bjp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Namih, foron famfamu ken fan Iudaia ri ka lame Iesu tinaiwa sing Kaiapas una fel ken famfamu tina matanfuntih na Rom. Ka biingbiing mang, pesu, fan Iudaia biil ri kau una fel ke Pailat, tarama ri ka duh na mata God ma biil rin ien na Ngasa na Liuliu Kulef. ");
INSERT INTO bjp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pesu Pailat ka suu unaisri ma ka diik ri aragii, “Sani gam tiu kaltu igii ini?” ");
INSERT INTO bjp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ri ka kiliis u aragii, “Male biil i tel ta ti sinang laulau, ke biil kemen lame u usuf o.” ");
INSERT INTO bjp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ke Pailat ka tarah, “Gam tom gamek telpes u ma gamek nagogon u namin nagogon kimi tom.” Ri ka kiliis u aragii, “Isau le kemem, biil ifasi kemen siimete tikas, wara le gam fan Rom gam tikale kemem.” ");
INSERT INTO bjp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tier igii i tapiek una fasuut foron orek ae Iesu i use famu ta u, una finngas matngan minet kia. ");
INSERT INTO bjp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailat ka kau fis una fel kia, ka kam pes Iesu ke ka diik u aragii, “Be, o king ken fan Iudaia?” ");
INSERT INTO bjp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu ka kiliis u aragii, “Fagalte ae kiam tom, le ti fal awii ri fas o ini iau?” ");
INSERT INTO bjp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat ka tarah, “O wol le ia sikin Iudaia? Fanu kiam tom turan foron laulaumet na pris ri ta ufu ta wo usuf iau. Sani o tel ta u?” ");
INSERT INTO bjp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu ka kiliis u aragii, “Matanfuntih kiak biil tinaga na piklinbat, biil. Male matanfuntih kiak tinaga, ke foron tom foim kiak rin fapaket kaleh isi fan Iudaia gong ri luse iau. Isau le igii, matanfuntih kiak biil tinaga.” ");
INSERT INTO bjp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat ka tarah, “Kol, wo nenge king, beh?” Iesu ka kiliis u aragii, “Orek kiam i tortores le ia nenge king. Tekentu kanaka, wara ae ia pang ma ia ka la uga na piklinbat isi ian famalal orek tekentu. Fanu tikii ae ri mi la na tekentu, ri wong la na kineng.” ");
INSERT INTO bjp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat ka diik u aragii, “Sani e tekentu?” Nami ka suu fis sabin ma ka fas foron famfamu ken fan Iudaia aragii, “Biil ia tafe ti tier i tel fager u isi iak nagogon u kuna. ");
INSERT INTO bjp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Isau le na sinangu gam, na Ngasa na Liuliu Kulef gam ier la le ian fasuu ufu tikas tina kamkabet usuf gam. Arafah, gam ier le ian fasuu ufu King ken fan Iudaia?” ");
INSERT INTO bjp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ke ri ka perek fis aragii, “Biil! I biil! Fasuu Barabas usuf kemem.” Barabas i nenge kaltu laulau kanaka. ");
INSERT INTO bjp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Namih, Pailat ka ta ufu Iesu na liman foron tom fapaket isi rin pis u. ");
INSERT INTO bjp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Foron tom fapaket ri ka tel nenge bangbang ini finau ae imel e si ma ri ka luun u na paklu. Ri ka fakilkiliis u ini nenge dolon kaen melmelek ");
INSERT INTO bjp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ke ri ka famam la unaisa ma ri ka tara sing i aragii, “King ken fan Iudaia, mangiam!” Ke ri ka famam pose u na posong na mata. ");
INSERT INTO bjp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat ka suu fis sabin, ke ka fas fan Iudaia aragii, “Par u, ia lame fasuu u usuf gam isi gamek usum le biil ia tafe ti tier ae i tel fager u, isi iak nagogon u kuna.” ");
INSERT INTO bjp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aunbiing Iesu ka suu ini bangbang ae ri tel u ini finau imel e si turan kaen melmelek, Pailat ka tara sing ri aragii, “Par u, igii mang e kaltu ae.” ");
INSERT INTO bjp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma aunbiing foron laulaumet na pris turan foron tom parpar kale Felun Tunmapek ri par u, ri ka perek aragii, “Fakulkulik u! Fakulkulik u na aupaket!” Isau le Pailat ka kiliis ri aragii, “Gam tom gam telpes u isi gamek fakulkulik u na aupaket. Biil ia tafe ti tier i tel fager ta u, isi iak nagogon u kuna.” ");
INSERT INTO bjp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Fan Iudaia ri ka kiliis u aragii, “Imel e nenge nagogon kimem ae i use u le in met tom, wara le i tara le, i Kalalik ke God.” ");
INSERT INTO bjp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ma aunbiing Pailat i ongen u arae, ka lala sokeh mang tom. ");
INSERT INTO bjp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ka kau fis una fel ke ka diik Iesu aragii, “O tingah?” Isau le, Iesu biil i kiliis u. ");
INSERT INTO bjp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat ka tara sing i aragii, “Arafa biil o kiliis iau? Biil o usum le imel e rakrakai kiak una puk ufu o ke una fakulkulik o?” ");
INSERT INTO bjp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu ka kiliis u aragii, “Biil in mel e rakrakai kiam na olong, male God biil in ta u usuf o tinbae. Pesu, sinang laulau ke ier ae i ta ufu ta iau una limam, i laumet na sinang laulau kiam.” ");
INSERT INTO bjp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tipes u na aunbiing ae, Pailat ka totof le in puk ufu Iesu tina kamkabet, isau le fan Iudaia ri tongon perek biitom le, “Male on puk ufu kaltu ae, ke biil o tala Sisar. Se i tara le i king, i tuui ke Sisar.” ");
INSERT INTO bjp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aunbiing Pailat i ongen u arae, ka fasuu Iesu ke ka kiis na nian kiiskiis kia una nagogon na falifu ae na orek Ibru, ri foteng u ini Gabata, kamtinan orek ae le, palgan maleh ae ri tafnge fat lo. ");
INSERT INTO bjp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Biing ae, i e Biingen Geges una Ngasa na Liuliu Kulef. Ma na sangful ini u e aunbiing, Pailat ka tara sing fan Iudaia aragii, “Igii mang e king kimi.” ");
INSERT INTO bjp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Isau le ri ka perek aragii, “Lame ufu! Lame ufu! Fakulkulik u na aupaket!” Pailat ka diik ri aragii, “Arafah, ian fakulkulik king kimi na aupaket?” Foron laulaumet na pris ri ka kiliis u aragii, “Biil ti king kimem, Sisar sau i e king kimem.” ");
INSERT INTO bjp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ke Pailat ka ta ufu Iesu mang na limri, isi rik fakulkulik u na aupaket. Ke foron tom fapaket ri ka lame ufu Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu ka kusep aupaket kia tom ma ka la tinaiwa una falifu ae ri foteng u ini salan Tuan Paklun Kaltu. Na orek Ibru ri foteng u ini Golgota. ");
INSERT INTO bjp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aiwa ri ka fakulkulik Iesu turan iwu e kaltu na iun baba ma Iesu na fatpoto. ");
INSERT INTO bjp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat i siit ta nenge sun orek ma ri ka kabet u na olon aupaket. Orek ae i aragii: ");
INSERT INTO bjp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ifuun e fan Iudaia ri wes sisiit ae, wara le falifu ae ri fakulkulik Iesu lo i fatat isi Ierusalem. Ma sisiit ae, ri siit ta u ini orek Ibru, Latin ke Grik. ");
INSERT INTO bjp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Foron laulaumet na pris ken fan Iudaia ri ka tara sing Pailat aragii, “Gong o siit u le, ‘King ken fan Iudaia.’ On siit u le, ‘Kaltu igii i tara le, i king ken fan Iudaia.’” ");
INSERT INTO bjp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat ka kiliis ri aragii, “Sani ia ka siit ta u, ia ka siit ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aunbiing foron tom fapaket ri ka fakulkulik ta Iesu, ri ka kep foron kilkiliis kia ke ri ka tem u una ifet. Neng usuf temtem tikii lo ri. Ke ri ka kep kolos sabin ae i luun u la tina palga. Kolos ae biil ti tungtugus lo, i dolo sikit sau. ");
INSERT INTO bjp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ke ri ka tara sing ri tom aragii, “Gong kere sisi u, kerek fangfang laki ini isi se tom in kep u.” Tier igii i tapiek una fasuut orek na Buk na Gogoh ae i use u aragii, “Ri tem foron kilkiliis kiak na fatpoto ri ke ri ka fangfang laki ini isi se tom in kep kolos kiak.” Ma foron tom fapaket ri ka tel u tom arae. ");
INSERT INTO bjp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tina Iesu ru la kisilik ke Maria antu Klopas tura Maria Makdalin rifet soti ta awii fatat aupaket ke Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aunbiing Iesu ka par tina ru e kalalik na fafausum ae i ier kanaka la isi ru soti fatat tah, ka tara sing tina aragii, “Tin ier, kem kalalik ae.” ");
INSERT INTO bjp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ke ka tara sing kalalik na fafausum ae aragii, “Tinam ae.” Tipesu mang na aunbiing ae, kalalik na fafausum ae ka lame pes u una fel kia. ");
INSERT INTO bjp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu ka usum ta le foron foim tikii ka rop mang, ke ka tarah, “Ia metdan.” I use u arae una fasuut orek ae na Buk na Gogoh. ");
INSERT INTO bjp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nenge luunluun dan ae imel e wain mingin lo tinaiwa, pesu ri ka falum nenge tier ae i duup pes dan la ke ri ka tu u na nenge akan isop ke ri ka sik u una mawe una ngusu Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aunbiing Iesu ka yin tikii, ka tarah, “Ka rop.” Ka takulem ke ka sok ufu liu kia. ");
INSERT INTO bjp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Foron famfamu ken fan Iudaia ri ka fas Pailat isi rin bayi keke tuul ier ae ri fakulkulik ta rituul, isi rituulek met sape ma rik fapu ufu pununfo rituul tina aupaket. Ri ier isi arae, wara le, i e Biingen Geges ma biing namih, i tara na Biingen Mangeh, pesu biil ri ier isi pununfo rituul in kulkulik na aupaket una Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pesu, foron tom fapaket ri ka la ma ri ka bayi keken iun kaltu ae ri fakulkulik ta ru tura Iesu, ri bayi famu keken neng ke nami neng. ");
INSERT INTO bjp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Isau le, aunbiing ri la usuf Iesu, ri ka tafe u le Iesu ka met tah, pesu biil mang ri bayi iun keke. ");
INSERT INTO bjp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ke nenge tom fapaket ka so Iesu awii na baba ini lamruut ma fanpil dah turan dan ka ring suuh. ");
INSERT INTO bjp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Kaltu ae i par ta u, i famalal sani i par ta u ma orek an fafamalal kia i tekentu. I usum le i orek tekentu, pesu ka famalal u isi gam sabin gamek unune. ");
INSERT INTO bjp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Foron tier igii i tapiek una fasuut orek ae na Buk na Gogoh, aragii, “Biil rin bayi ti tua.” ");
INSERT INTO bjp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ke nenge orek na Buk na Gogoh sabin i tara aragii, “Rin par usuf ier ae ri so ta u.” ");
INSERT INTO bjp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Namih, Josep tina Arimatia ka sising Pailat isi pununfo Iesu. Josep i nenge kalalik na fafausum ke Iesu, isau le i mi kum la sau lo, wara le i soke foron famfamu ken fan Iudaia. Pailat ka somangat, ke Josep ka la ma ka kep ufu pununfo Iesu. ");
INSERT INTO bjp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, ae na famu i la ta usuf Iesu na nenge wor, i sabin i la tura Josep. Nikodimas i kep nenge tier ae i furung rokap e sana, ri tel u ini mir turan aloi. Ma tatawin lo, ifasi aragii, ituul e sangful e kilogrem. ");
INSERT INTO bjp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ru ka kep pununfo Iesu ma ru ka afit u ini foron rokap na kaen turan foron tier ae i sana i furung rokap namin sinang ae fan Iudaia ri mi la lo una fakilkiliis foron minet. ");
INSERT INTO bjp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na falifu ae ri fakulkulik ta Iesu lo, imel e nenge mok ma awii na mok ae, imel e nenge matanfat fuuh una luun minet ae biil biitom ri luun ta ti minet lo. ");
INSERT INTO bjp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Matanfat ae i fatat sau, pesu ru ka luun pununfo Iesu lo. Wara le biing ae, i e Biingen Geges ken fan Iudaia una tara Biingen Mangeh. ");
INSERT INTO bjp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na biingbiing saksak na biing famu na wik ae, aunbiing i kumkubunor biitom, Maria Makdalin ka la una matanfat una luun minet. Ke ka par u le fat tinawii na matanfat ae, ri ka fabulbulis ufu tah. ");
INSERT INTO bjp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ka filau usuf Saimon Pita ru e kalalik na fafausum ae Iesu i ier kanaka isi ma ka fas ru aragii, “Ri ka kep ufu ta Kumguui tina matanfat ma biil keme usum le fia mang ri ka luun u wah!” ");
INSERT INTO bjp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ke Pita ru e kalalik na fafausum ae ru ka la una matanfat. ");
INSERT INTO bjp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ru turim ru filau, isau le kalalik na fafausum ae ka liu ufu Pita ma ka tapiek famu na matanfat. ");
INSERT INTO bjp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ka parau, ka kongkilii ma ka par foron kaen ae ri afit ta Iesu ini tinaiwa tom, isau le biil i kau. ");
INSERT INTO bjp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita ae i mi sau lo, ka tapiek ma ka kau sikit una palgan fat ae. Ke ka par foron kaen tinaiwa tom ");
INSERT INTO bjp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","turan kaen sabin ae ri fis ta u na paklu Iesu. Kaen ae, ri palim ta u ma ri ka luun keskes u tom koseng fale kaen tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ke kalalik na fafausum sabin ae i tapiek famu ta na matanfat, ka kau. Ka par u ma ka unune. ");
INSERT INTO bjp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Biil biitom ri malal na orek ae na Buk na Gogoh le, Iesu in apti fis tina minet. ");
INSERT INTO bjp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Namih, iun kalalik na fafausum ru ka fis una maleh. ");
INSERT INTO bjp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Isau le, Maria Makdalin i soti awii na maleh na matanfat ma ka tengteng la. Aunbiing i tengteng la, ka parau ma ka kongkilii. ");
INSERT INTO bjp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ke ka par iwu e angelo ru kilkiliis ini foron tier ae i pos ma ru kiis ta na falifu ae ri luun ta pununfo Iesu lo, neng na koskosngoi kia ke neng na karkeke. ");
INSERT INTO bjp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ru ka diik u aragii, “Tin ier, isi sani o ka teng?” Maria ka kiliis ru aragii, “Ri ka kep ufu ta Kumguui kiak ma biil ia usum le fia mang ri ka luun u wah.” ");
INSERT INTO bjp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","I use ta u arae ke ka giliim fis ma ka par Iesu i soti ta aiwa, isau le biil i iliim u le, Iesu sau. ");
INSERT INTO bjp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu ka diik u aragii, “Tin ier, isi sani o ka teng? O im isi seh?” Maria i wol le i taman mok ae, pesu ka tara sing i aragii, “Ier, male o ka kep ufu tah ke fas iau ini falifu ae o luun u lo, isi iak kep pes u.” ");
INSERT INTO bjp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu ka tara sing i aragii, “Maria.” Maria ka par usuf i ma ka tara aragii na orek Ibru, “Raboni!” Kamtinan orek ae, le tom fafausum. ");
INSERT INTO bjp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ke Iesu ka fas u aragii, “Gong o pose lo iau, wara le biil biitom ia fis ubae usuf Tata. La usuf foron tuaklik ma ok fas ri le: ‘Ian fis ubae naisa Tata i e Tama gam, usuf God kiak, i e God kimi.’” ");
INSERT INTO bjp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Makdalin ka la unaisan berberat na fafausum ke ka fas ri aragii, “Ia ka par ta Kumguui!” Ke ka fas ri le Iesu i fas u ini foron tier ae. ");
INSERT INTO bjp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na efef worwor na tipes u e biing na wik ae, berberat na fafausum ri kiis turim ma ri ka babat rakrakai na foron matanfel, wara ri soke foron famfamu ken fan Iudaia. Iesu ka tipiek na fatpoto ri ke ka tara sing ri aragii, “Siaroh usuf gam!” ");
INSERT INTO bjp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aunbiing ka use ta u arae, ka finngas ri ini iun lima ke baba. Ke berberat na fafausum ri ka lala laes na aunbiing ri par Kumguui. ");
INSERT INTO bjp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ke Iesu ka tara sabin sing ri aragii, “Siaroh usuf gam! Arae Tata i wuun ta iau, ke ia sabin ia ka wuun gam.” ");
INSERT INTO bjp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","I use ta u arae, ke ka mangeh ulo ri ma ka tarah, “Gam kep Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Male gamen wol ufu foron sinang laulau ken tikas, ke God in pa ufu foron sinang laulau kia. Male biil gam wol ufu foron sinang laulau kia, ke God biil in pa ufu foron sinang laulau kia.” ");
INSERT INTO bjp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas, nenge asa sabin e Didimas, kamtina le Kasang. I neng lon sangful ini u e kalalik na fafausum ma aunbiing Iesu i tapiek ta sing ri, i mangmangal. ");
INSERT INTO bjp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ke fale berberat na fafausum ri ka fas u aragii, “Keme ka par ta Kumguui!” Isau le, Tomas ka tarah, “Male biil ia par salan nil na iun lima ke iak fakau katngan limang na salan nil ma iak fakau limang na baba, biil tom ian unune.” ");
INSERT INTO bjp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na fawal u e biing namih, berberat na fafausum ri ka kiis turim sabin awii na palgan fel ma Tomas sabin tinaiwa naisri. Taftawa ri babat rakrakai na foron matanfel, isau le Iesu ka tipiek na fatpoto ri ke ka tarah, “Siaroh usuf gam!” ");
INSERT INTO bjp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ke ka tara sing Tomas aragii, “Fakau katngan limam aga, par iun limang. Sawe limam ke ok fakau u na babang. Gong iwu e wolwol kiam, on unune sau.” ");
INSERT INTO bjp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ka kiliis u aragii, “Kumguui kiak ke God kiak!” ");
INSERT INTO bjp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ke Iesu ka tara sing i aragii, “O unune sau, wara le o par iau. Isau le, ri kalok e fanu ae biil ri par ta iau ma ri ka unune sau.” ");
INSERT INTO bjp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu i fatapiek ta ifuun sabin e fakileng na matan berberat na fafausum kia ae biil ia siit papte u na buk igii. ");
INSERT INTO bjp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Isau le, ia ka siit papte foron tier igii, isi gamek unune le Iesu i e Mesaia ma i e Kalalik ke God. Male gamen unune lo, ke gamen fot u e liu na asa. ");
INSERT INTO bjp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Namih, Iesu ka tapiek sabin sing berberat na fafausum kia na dan kawil na Taiberias. I tapiek aragii: ");
INSERT INTO bjp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas ae nenge asa sabin e Didimas, Nataniel tina Kana na falifu na Galili ke iun kalalik ke Sebedi turan iwu e kalalik na fafausum sabin tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita ka tara sing ri aragii, “Ian la isi ienmaket.” Ke ri ka tara sing i aragii, “Kemen la turam.” Ri ka aptih ma ri ka wof na mon. Isau le na wor ae, ri puplir. ");
INSERT INTO bjp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na biingbiing saksak, Iesu ka soti na kiin, isau le berberat na fafausum biil ri to iliim u le Iesu sau. ");
INSERT INTO bjp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ke ka tautau usuf ri aragii, “Foron talang, gam ka kep ti kok?” Ri ka kiliis u aragii, “Auuh.” ");
INSERT INTO bjp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ke Iesu ka fas ri aragii, “Gamen lin ubiin kimi na baban mon na mia gam, isi gamek kep ti fal.” Aunbiing ri tel u arae, ke biil mang ifasi rin dat fafis ubiin, wara le ifuun kanaka e kok. ");
INSERT INTO bjp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ke kalalik na fafausum ae Iesu i ier kanaka isi ka fas Saimon Pita le, “Kumguui sau ae!” Aunbiing Saimon Pita i ongen u le, Kumguui sau, ka kau fis na kaen ae i tel ufu tah ke ka wof una dan. ");
INSERT INTO bjp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Fale berberat na fafausum ri ka mi ini mon ma ri ka date ubiin ae ifuun ini kok, wara le biil ri tapak una mas, ifasi sau aragii nenge mar e mita. ");
INSERT INTO bjp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aunbiing ri masah, ri ka par nenge yiif ae kumluut lo i soksok la ma imel e kok lo ke fale beret sabin tinaiwa na baba. ");
INSERT INTO bjp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu ka tara sing ri aragii, “Kep ti fale kok ae gam am kep u sau uga.” ");
INSERT INTO bjp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ke Saimon Pita ka fen una mon ma ka dat famasa ubiin. Ifuun ini piran kok, ifasi aragii nenge mar ini lim e sangful ini tuul. Taftawa ifuun kanaka e kok, isau le ubiin biil i to tamrabat. ");
INSERT INTO bjp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu ka tara sing ri aragii, “Gam la ma gamek ien.” Berberat na fafausum tikii ae ri binbin isi diik u le, “O seh?” Wara le ri ka usum ta le i e Kumguui. ");
INSERT INTO bjp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu ka la, ka kep beret ke ka fen ri ini ma ka tel u sabin arae ini kok. ");
INSERT INTO bjp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Igii, ka fatuul u mang e aunbiing Iesu i tapiek sing berberat na fafausum kia, aunbiing i apti fis ta tina minet. ");
INSERT INTO bjp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Aunbiing ri ka ien tikii tah, Iesu ka tara sing Saimon Pita aragii, “Be, Saimon kalalik ke Jon, o ier kanaka tom isi iau lon fal igii?” Ke Pita ka kiliis u aragii, “Iuu, Kumguui, o usum le ia ier kanaka isi wo.” Iesu ka fas u aragii, “Fen foron natun sipsip kiak.” ");
INSERT INTO bjp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Fawu sabin ka tara sing i aragii, “Saimon, kalalik ke Jon, o ier kanaka tom isi iau?” Pita ka kiliis u aragii, “Iuu, Kumguui, o usum le ia ier kanaka isi wo.” Iesu ka fas u aragii, “Fofonoi na foron sipsip kiak.” ");
INSERT INTO bjp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Fatuul u e aunbiing, Iesu ka tara sing i aragii, “Saimon kalalik ke Jon, o ier kanaka tom isi iau?” Ka purngis e bala Pita, wara le Iesu fatuul mang ka diik u le, “O ier kanaka tom isi iau?” Pita ka kiliis u aragii, “Kumguui, o usum na foron tier tikii ma o usum le ia ier kanaka isi wo.” Ke Iesu ka fas u aragii, “Fen foron sipsip kiak. ");
INSERT INTO bjp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tekentu kanaka ia fas o, aunbiing o guam tah, o fakilkiliis fafis wo la tom ke o ka la la una falifu ae o ier isi on la ulo. Isau le aunbiing on tubunkak, on sawe iun limam ke tikas keskes ik fakilkiliis o ma ik tangne o una falifu ae biil o ier isi on la ulo.” ");
INSERT INTO bjp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu i use u aragii, una finngas matngan minet ke Pita isi ik ta memeh usuf God. Ke Iesu ka fas u aragii, “Mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita ka giliim fis ke ka par kalalik na fafausum ae Iesu i ier kanaka isi, i mimi la lo ruh. Ier sau ae i gigin fatat ta Iesu na aunbiing ri ien turim ma ka tarah, “Kumguui, se in ta ufu wo una liman tuui?” ");
INSERT INTO bjp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Aunbiing Pita ka par u, ka diik Iesu aragii, “Kumguui, arafa lo ier igii?” ");
INSERT INTO bjp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ke Iesu ka kiliis u aragii, “Male ia ier isi in liu papang na aunbiing ian fis, ke ti sani kiam lo? Ma wo, mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","I wara na orek igii, ke nenge orek ka sarara na fatpoton foron tom unune le kalalik na fafausum igii, biil in to met. Isau le, Iesu biil i use u le biil in met, biil. I use u sau le, “Male ia ier le in liu papang na aunbiing ian fis, ke ti sani kiam lo?” ");
INSERT INTO bjp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kalalik na fafausum sau ae, i famalal u e foron tier igii ke ka siit papte u. Kere usum le orek an fafamalal kia i tekentu. ");
INSERT INTO bjp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu i tel ta ifuun sabin e tier. Male rin siit papte ta foron tier tikii, ke ia wol le piklinbat biil in mel e mua una luun foron buk tikii. ");
INSERT INTO bjp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiofilus, Na buk famu kiak, ia siit foron tier tikii ae Iesu i tel ta u ma ka fausum ta fanu ini tina tanwaran foim kia, ");
INSERT INTO bjp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","pang na aunbiing God ka telpes u una kukulii. Famu na aunbiing God i telpes u una kukulii, i tapiek ta sing foron aposel kia ae i tim pes ta ri, ke ini rakrakai ken Tanwa Kalkaluu ka patrai ri ini sani rin tel u. ");
INSERT INTO bjp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nami na fangungut ae i kalsakai ta u na minet kia, ka tapiek sing ri ma ifuun e fakileng ka fatapiek u, una finngas u le tekentu tom i liu. I famam tapiek sing ri na ifet e sangful e biing ma ka fas ri ini matanfuntih ke God. ");
INSERT INTO bjp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nenge aunbiing ri kiis turim ma ri ka ienien la, ke Iesu ka fas ri aragii, “Gong gam la koseng Ierusalem, isau le gamen nene isi falimlim ke Tata, arae ia fas ta gam ini pakanini. ");
INSERT INTO bjp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon i tel ta bapitaiso ini dan, isau le biil in sawin, ke gamek kep bapitaiso ini Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aunbiing ri la turim, ri ka diik u aragii, “Be, Kumguui, na aunbiing mang ae on ta fafis matanfuntih usuf fan Israel?” ");
INSERT INTO bjp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ka kiliis ri aragii, “Biil e tier kimi isi gamen usum na foron aunbiing ke na foron biing ae Tata tom i luun ta u ini rakrakai kia. ");
INSERT INTO bjp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Isau le gamen kep rakrakai aunbiing Tanwa Kalkaluu in susuef ulo gam. Ke gamek famalal iau na Ierusalem, na foron falifu tikii na Iudaia, na Samaria ke na foron falifu tikii na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aunbiing Iesu ka orek tikii tah, ke God ka kep fatatkau u na matri ma nenge laukaf ka afit pes u ke biil mang ri par u. ");
INSERT INTO bjp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Aunbiing ri parpar la biitom nami ubase na bat, fanpil iwu e kaltu ae kilkiliis kiru i pos tikii, ru ka tipiek naisri. ");
INSERT INTO bjp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ke ru ka tarah, “Fan Galili, isi sani gam ka soti aga ma gam ka parpar la una bat? Iesu sau ae God i kep ufu koseng gam ubase na kukulii, in fis sabin arae sau gam par ta u i la una kukulii.” ");
INSERT INTO bjp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Namih, foron aposel ri ka fis tina pungpung ae ri foteng u ini Olif una Ierusalem. Pungpung ae i fatat Ierusalem sau ifasi aragii nenge kilomita. ");
INSERT INTO bjp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aunbiing ri ka tapiek, ri ka fen na fel ubae na mawe na falifu tom ae ri kiis la lo. Foron aposel ae ri tinaiwa e, Pita, Jon, Jems, Enru, Filip, Tomas, Batolomiu, Metiu, Jems kalalik ke Alfius ke Saimon ae i nenge Silot ke Iudas kalalik ke Jems. ");
INSERT INTO bjp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ri turan fale kelefin, Maria tina Iesu ke foron tualik e Iesu sabin, ri sising turim la ini tikii sau e wolwol. ");
INSERT INTO bjp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na aunbiing ae, Pita ka soti na fatpoton nenge mar ini wu e sangful e tom unune, ae ri kiis turim tah ma ka tarah, ");
INSERT INTO bjp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Foron tuaklik, pakanini Tanwa Kalkaluu i susuef ta ulo king Dewit ke ka use famu ta sani in tapiek lo Iudas, ae i famu pes ta fanu isi luse Iesu. Ma igii orek ae na Buk na Gogoh ka suut mang. ");
INSERT INTO bjp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iudas i neng lo kemem ma i foim ta tura kemem.” ");
INSERT INTO bjp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iudas i kep ta pitkalang ae ri suat ta u isi sinang laulau kia ke ka fiil nenge sun nanal. Nami ka luut aiwa ini posong na mata, ma bala ka tampaek ke saka ka bereng sararah. ");
INSERT INTO bjp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Fanu tikii na Ierusalem ri ka ongen u ke ri ka foteng sun nanal ae ini Akeldama. Na orek kiri kamtina le, Nanal na Dah. ");
INSERT INTO bjp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ke Pita ka tarah, “Ri siit ta u na Buk Seksek aragii, ‘Fel kia in pungu ma biil tikas una kiis lo.’ Nenge orek sabin ri siit ta u i aragii, ‘Nenge kaltu keskes in kep sala na foim kia.’ ");
INSERT INTO bjp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Pesu, in rokap le keren tim pes tikas lon fanu ae ri kiis la tura kemem na foron aunbiing tikii ae Kumguui Iesu i kiis ta tura kemem, ");
INSERT INTO bjp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tipes u na aunbiing Jon i baptais Iesu, pang na aunbiing God ka kep fatatkau u koseng kerer. I rokap le tikas lo ri ae i par ta foron tier tikii Iesu i tel ta u, in famalal apaptifis ke Iesu tura kerer.” ");
INSERT INTO bjp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ke ri ka tus iwu e kaltu, Josep ae ri foteng u la ini Barsabas, nenge asa sabin e Jastus, ru e Matias. ");
INSERT INTO bjp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Namih, ri ka sising aragii, “Kumguui, o usum na wolwol ken fanu tikii. Finngas kemem ini se lo ru ae o ka tim pes ta u ");
INSERT INTO bjp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","una kep sala Iudas arae nenge aposel, foim ae Iudas ka la koseng ta u, una falifu tom ae ifasi ulo.” ");
INSERT INTO bjp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ri ka siit asru na iwu e fat isi rik tim pes tikas lo ruh. Ma fat ae asa Matias lo, ka luut famu ke ri ka wes turim u turan sangful ini tikii e aposel. ");
INSERT INTO bjp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aunbiing biingen Pentikos ka tapiek, foron tom unune tikii ri kiis turim ta na nenge fel. ");
INSERT INTO bjp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Fanpil, nenge tier ka ninih arae kinen tara kif i pu tina kukulii ma ka kuruung tikii palgan fel ae ri kiis lo. ");
INSERT INTO bjp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ke ri ka par nenge tier arae karfian yiif ka sararah ma ka kiis lon temtem tikii lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ri tikii ri ka fuun ini Tanwa Kalkaluu ke ri ka orek ini fale orek keskes. Tanwa Kalkaluu tom i tel ri ka orek arae. ");
INSERT INTO bjp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na aunbiing ae, imel e fan Iudaia ae ri lotu la unaisa God tinaiwa na Ierusalem, ri tapiek tina foron falifu tikii na piklinbat. ");
INSERT INTO bjp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Aunbiing ri ongen tier ae i ninih, tara gur na fanu ri ka la turim. Ri ka wolpane, wara le temtem tikii lo ri, ka ongen foron tom unune ae ri orek tom ini foron orek tutus kiri. ");
INSERT INTO bjp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Fan Iudaia ri ka lala bitit ke ri ka tarah, “Gam par u, fanu igii ae ri orek, ri fan Galili sau. ");
INSERT INTO bjp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma arafa i tara arae, ke kere ka ongen ri, ri ka orek ini foron orek temtem tikii kirer? ");
INSERT INTO bjp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kere tina Partia, Midia ke Elam, tina Mesopotamia, Iudaia, Kapadosia, tina Pontus ke tina Eisia. ");
INSERT INTO bjp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Tina Frigia ke Pamfilia, tina nanal na Isip ke fale maleh na Libia fatat isi Sairini. Foron ses tina Rom, ");
INSERT INTO bjp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ae fal lo ri e fan Iudaia ke fal sabin biil ri fan Iudaia, isau le ri ka somangat pes ta matngan fafausum ken fan Iudaia. Ke fal lo kerer tina Krit ke tina Arabia. Kere ongen ri, ri fafas ini foron rakrakai na foim ke God ini foron orek temtem tikii tom kirer.” ");
INSERT INTO bjp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ri ka lala bitit ma ri ka wolpane ke ri ka tarah, “Matngan sani i tapiek aragii?” ");
INSERT INTO bjp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Isau le fal, ri ka morot ini ri aragii, “Ri umin ifuun kanaka e wain.” ");
INSERT INTO bjp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Isau le Pita ka soti turan nenge sangful ini tikii e aposel ma ka perek aragii, “Gam fan Iudaia ke gam tikii ae gam mel na Ierusalem, gamen ongen fakasi orek kiak ma iak puk u usuf gam: ");
INSERT INTO bjp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Fanu igii biil ri umin dan rakrakai, arae gam wol lo, biil. Wara le i siu biitom e aunbiing na biingbiing igii. ");
INSERT INTO bjp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Isau le tier igii, profet Joel i orek famu ta isi aragii: ");
INSERT INTO bjp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God i tarah: Na foron farfarop na biing, ian fore Tanwang lon fanu tikii. Berberat turan foron keleflik kimi rin orek profet, foron guam kimi rin par foron parpar, ke foron tubunkak kimi rin nimbiilnge foron nimnibiil. ");
INSERT INTO bjp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ke na foron biing ae, ian fore Tanwang sabin lon foron fafauun kiak, fanu tamat turan kelefin, ma rik orek profet. ");
INSERT INTO bjp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ian finngas foron tier an fabitit bae na bat ma iak fatapiek foron fakileng na piklinbat. In mel e dah, yiif ke tara na bau. ");
INSERT INTO bjp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Matan pisiih in kubunor, ma funiil ik melmelek arae dah. Foron tier ae in tapiek famu na tara biingen memeh ae Kumguui in tapiek lo. ");
INSERT INTO bjp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma fanu tikii ae ri fakam na asa Kumguui, rin liu.’ ");
INSERT INTO bjp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Fan Israel, gamen ongen foron orek igii: Iesu tina Nasaret, i e kaltu ae God tom i ta ta rakrakai usuf i una tel foron rakrakai na foim, foron tier an fabitit ke foron fakileng na fatpoto gam, arae tom gam ka usum ta lo. God i tel u arae, una fatekentu u usuf gam le i tom i wuun ta u uga. ");
INSERT INTO bjp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kaltu igii, God i ta ufu ta una liumi, ke gam turan foron tom tel sinang laulau gam ka fakulkulik ta u na aupaket ke gam ka siimete u. God i usum famu tom na sani ae gamen tel u. Ma sani ae gam ka tel ta u, gam tel u namin puput kia tom. ");
INSERT INTO bjp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Isau le God ka fapti fafis u tina minet ke ka fasengsegeng u koseng fangungut na minet, wara le minet biil ifasi in pose papte u. ");
INSERT INTO bjp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","King Dewit i use famu ta u ulo Iesu aragii, ‘Ia par Kumguui la tom na famu lo iau ke biil ifasi tikas in gule iau, wara le i igii na miang. ");
INSERT INTO bjp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pesu balang ka laes ma ia ka use fages u ini ngusung. Ke pununfong sabin in liu ini unune, ");
INSERT INTO bjp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","wara le ia usum le biil on somangat ufu tanwang una salan foron minet ke biil sabin on par ufu pununfo Kaltu Kalkaluu kiam ik mapuh. ");
INSERT INTO bjp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O ka finngas ta iau ini foron sal una liu ke ok fafuun iau ini laes ae na kiiskiis kiam.’ ");
INSERT INTO bjp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Foron tuaklik, ia fas fatus gam, tubutamat kerer sing king Dewit ka met ta ma ri ka ile ta u. Ma matanfat ae ri ile ta u lo, igii tom na aisrer, papang igii. ");
INSERT INTO bjp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Isau le Dewit i nenge profet, ka usum ta le God i falimlim usuf i le, in luun tikas tina mat kia tom, isi in kep sala arae king. ");
INSERT INTO bjp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dewit i par sani ae na famu ke ka ororek famu isi apaptifis ken Mesaia aragii, Kumguui biil in somangat ufu tanwa una salan foron minet ke biil sabin in par ufu pununfo ik mapuh. ");
INSERT INTO bjp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","God ka fapti fafis ta Iesu igii koseng minet ma kemem tikii igii, keme par fatus ta sani ae i tapiek tah ke keme ka famalal u. ");
INSERT INTO bjp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God ka sik falaumet ta Iesu ma ka fakiis u na mia. Ke Iesu ka kep Tanwa Kalkaluu ae Tama i falimlim ta ini ma ka fore ta sani igii gam par u ke gam ka ongen u. ");
INSERT INTO bjp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","King Dewit biil i tatkau ta una kukulii, isau le i tara ta aragii, ‘Kumguui God i tara sing Kumguui kiak aragii: Kiis na miang, ");
INSERT INTO bjp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","papang na aunbiing ian luun foron tuui kiam na piklin kekem.’ ");
INSERT INTO bjp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pesu, gam fan Israel tikii, gamen usum rokap le, Iesu ae gam fakulkulik ta u na aupaket, God ka luun ta u arae Kumguui ke Mesaia sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aunbiing fanu ri ka ongen u arae, ka lala purngis e balri ke ri ka tara sing Pita turan fale aposel sabin ae aragii, “Foron tualikmem, sani kemen tel u?” ");
INSERT INTO bjp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ke Pita ka kiliis ri aragii, “Temtem tikii lo gam, in sokiliis liu kia ma ik kep bapitaiso na asa Iesu Karisito, isi God ik pa ufu foron sinang laulau kia ke ik ta Tanwa Kalkaluu arae fafen usuf i. ");
INSERT INTO bjp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Falimlim igii usuf gam turan berberat kimi ke fanu tikii ae ri kiis tapak, fanse ae Kumguui God kirer in kam pes ri.” ");
INSERT INTO bjp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita i famalal ri sabin ini ifuun e orek ke ka fanau ri aragii, “Gamen fofonoi lo gam tom koseng fanu laulau na ulul igii, tarama gam ka fiu.” ");
INSERT INTO bjp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ri tikii ae ri somangat pes fafas kia, ri ka kep bapitaiso. Ma na biing ae, wewes lon fanu tikii ae ri kau tura ri, ifasi aragii ituul e arip. ");
INSERT INTO bjp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ri kiis mulmul la na piklin fafausum ken foron aposel, ri kiis turim la, ri ien turim la ke ri ka sising turim la. ");
INSERT INTO bjp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Fanu tikii ri lala bitit na ifuun e tier an fabitit ke ifuun e fakileng ae foron aposel ri fatapiek ta u. ");
INSERT INTO bjp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ke foron tom unune tikii, ri kiis turim la ma foron minmara ri, kiri tikii sau. ");
INSERT INTO bjp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ri sufii foron minmara ri la turan foron minsik kiri, ma pitkalang lo, ri ka tem u la namin sani temtem tikii i dar u. ");
INSERT INTO bjp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na foron biing tikii, ri la turim la una palgan ubiif kale Felun Tunmapek. Ri ien turim la na foron matanfel kiri ini laes ma limri i sapeng la usuf ri tikii. ");
INSERT INTO bjp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ke ri ka sik asa God la ma fanu tikii ri laes ini ri. Ma foron biing tikii, Kumguui i luluun pes la na olon wewes kiri lon fanu ae God ka faliu ta ri. ");
INSERT INTO bjp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nenge biing, Pita ru e Jon ru la una Felun Tunmapek na aunbiing una sising, na ituul e aunbiing na efef. ");
INSERT INTO bjp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ma nenge kaltu ae i peo tina kalalik lo, fale fanu ri sik u ma ri ka fakiis u la na nenge matanfel na ubiif kale Felun Tunmapek ae ri foteng u ini Rokap na Matanfel. I kiis la aiwa isi sising fanu isi pitkalang na foron biing tikii, aunbiing ri kau la una palgan ubiif kale Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Aunbiing i par Pita ru e Jon ru ka ier isi kau, ka sising ru isi pitkalang. ");
INSERT INTO bjp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Isau le ru ka par tortores una mata, ke Pita ka tarah, “Par kamah!” ");
INSERT INTO bjp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ke peo ae ka par sok lo ruh, i wol le run ta ti tier sing i. ");
INSERT INTO bjp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Isau le Pita ka tara sing i aragii, “Biil ti siliwa le goul sing iau, isau le sani igii sing iau, ian ta u usuf o. Na asa Iesu Karisito tina Nasaret, aptih ma ok la!” ");
INSERT INTO bjp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ke ka pose na mia ma ka fapti u. Fanpil, iun keke turan foron tungtugus na keke ka rakrakai. ");
INSERT INTO bjp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ka sirok, ka sotih ke ka tipes la. Ke ka kau tura ru una palgan ubiif kale Felun Tunmapek. Ma aunbiing i la, i sirsirok la ma ka ususefages God la. ");
INSERT INTO bjp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Aunbiing fanu tikii ri par u i la ma ka ususefages God la, ");
INSERT INTO bjp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ri ka iliim u le, i sau e kaltu ae i kiis ma ka sising fanu la na nenge matan Felun Tunmapek, ae ri foteng u ini Rokap na Matanfel. Ke ri ka bitit ma ri ka pangang na sani ae i tapiek ta lo. ");
INSERT INTO bjp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Peo ae i pospose la tom lo Pita ru e Jon, ke fanu tikii ri ka bitit ma ri ka filau unaisrituul na falifu ae ri foteng u ini Palpalbuang ke king Solomon. ");
INSERT INTO bjp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Aunbiing Pita i par u arae, ka tara sing ri aragii, “Fan Israel, isi sani gam ka bitit na sani i tapiek? Ke isi sa gam ka kanap kemtuul? Arafah, gam wol le kama tel kaltu igii ka la ini rakrakai kimah, le ini sinangu kama ae i tortores na mata God? Biil. ");
INSERT INTO bjp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God ke Abaram, Aisak ke Jekop ke God ken foron tama kerer ka me ta Iesu, tom foim kia. Gam ta ufu ta isi rin siimete u ma gam ka fakawe ufu na mata Pailat, taftawa le Pailat ka wol ta le in puk ufu. ");
INSERT INTO bjp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gam ka fakawe ufu Ier ae i Kalkaluu ma i Tortores ma gam ka sising le rin fasuu ufu tom sisiimete usuf gam. ");
INSERT INTO bjp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gam siimete Ier ae i e waran liu, isau le God ka fapti fafis u. Keme par fatus sani ae i tapiek tah ke keme ka famalal u. ");
INSERT INTO bjp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kaltu igii gam par u ma gam usum lo, i rakrakai wara na unune kimah na asa Iesu. Na asa Iesu sau ae kama unune lo, ke kaltu igii ka liu ma gam tikii gam ka par u. ");
INSERT INTO bjp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Foron tuaklik, ia usum le sani ae gam turan foron famfamu kimi gam ka tel ta u, biil gam usum lo. ");
INSERT INTO bjp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Isau le tier igii ka tapiek una fasuut sani ae God i use famu ta u na ngusun foron profet tikii, le Mesaia kia in kalsakai fangungut. ");
INSERT INTO bjp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pesu, gamen sokiliis liu kimi ma gamek fis usuf God, isi ik pa ufu foron sinang laulau kimi, ");
INSERT INTO bjp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma namih, Kumguui in ta rakrakai fuu usuf gam. Ke ik wuun ufu Mesaia, ae pakanini tom God i tus pes ta u le in wuun ufu usuf gam, i e Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","I tom baewa na kukulii, papang na aunbiing ae God in fatortores fafis foron tier tikii, arae tom i use ta u na ngusun foron profet kalkaluu kia. ");
INSERT INTO bjp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Wara le Moses i use ta u aragii, ‘Kumguui God kimi in fapti ti profet kimi arae iau, tina foron sikinting lo gam tom. Gamen ongen foron tier tikii ae in fas gam ini. ");
INSERT INTO bjp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ma se biil i ongen pes foron orek kia, God in tel ufu koseng fanu kia ma ik falaulau u.’ ");
INSERT INTO bjp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Foron profet tikii, tipes u lo profet Samuel, ulon fale profet sabin ae ri tapiek namih, ri tikii ri ororek famu ta isi foron biing igii. ");
INSERT INTO bjp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ma sani ae foron profet ri use ta u turan puput ae God i tel ta u turan foron tubutamat gam, kimi. Pakanini, i tara ta sing Abaram aragii, ‘Fanu tikii na piklinbat rin kalok, iwara lo tubumtamat.’ ");
INSERT INTO bjp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aunbiing God i fiti ta Tom Foim kia, i wuun famu ta u usuf gam isi ik sokiliis liu ken temtem tikii lo gam koseng foron sinang laulau ke ik fakalok gam.” ");
INSERT INTO bjp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aunbiing Pita ru e Jon ru ororek la biitom usuf fanu, ke foron pris turan kabisit ken foron tom parpar kale Felun Tunmapek turan foron Sadusi ri ka tapiek sing ruh. ");
INSERT INTO bjp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ka kut laulau e balri, wara le Pita ru e Jon ru famam fausum fanu ma ru ka tara le, foron minet rin apti fis, arae Iesu i apti fis tah. ");
INSERT INTO bjp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ke ri ka luse ruh. Iwara le ka worwor tah, pesu ri ka luun ru na kamkabet papang na biingbiing. ");
INSERT INTO bjp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Isau le fanu fuun ae ri ongen ta fafas kiruh ri ka unune. Ma wewes tikii lon fanu tamat ae ri unune, ifasi aragii ilim e arip. ");
INSERT INTO bjp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na biing namih, foron tom nagogon, foron famfamu turan foron tom fafausum ini nagogon ri ka kiis turim na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas ae i famfamu ken foron pris tura Kaiapas, Jon ke Aleksenda turan fale sikinting sabin lon famfamu ken foron pris sabin tinaiwa. ");
INSERT INTO bjp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ri ka fiti Pita ru e Jon na matri ke ri ka tipes diik ru aragii, “Kamu tel tier igii ini rakrakai tingah ma ini asa seh?” ");
INSERT INTO bjp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pita ifuun ini Tanwa Kalkaluu ke ka kiliis ri aragii, “Foron tom nagogon ke foron famfamu ken fanu, ");
INSERT INTO bjp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","gam diik kamah, iwara le kama tel ta rokap na sinang usuf kaltu ae i peo, ke gam ka diik kama sabin arafa kama faliu u arae. ");
INSERT INTO bjp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Igii, ian famalal u usuf gam turan fanu tikii tina Israel. Gam par kaltu igii i soti na matmi ini liu rokap, i liu na asa Iesu Karisito tina Nasaret, ae gam fakulkulik ta u na aupaket, isau le God ka fapti fafis u. ");
INSERT INTO bjp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","I sau i e ‘Tuh ae gam foron tom tel fel gam puris ta u, ka tapiek temin tuh mang.’ ");
INSERT INTO bjp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Biil keren kep fafaliu sing tikas sabin awii, biil. Wara le biil ti as sabin aga na piklinbat God i ta ta u usuf fanu ae ifasi in faliu kerer.” ");
INSERT INTO bjp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ri par u aragii le Pita ru e Jon biil ru orek binbin. Ri usum le ru kaltu foes sau ma biil sabin ru kep fafausum tah, pesu ri ka bitit ke ri ka iliim ru le ru la la tura Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Isau le kaltu ae ru faliu ta u, i sotsoti la tom awii na matri, pesu biil ifasi rin use ti tier. ");
INSERT INTO bjp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ke ri ka wuun fasuu ru tinaiwa ma ri ka orek fis tom ini ri aragii, ");
INSERT INTO bjp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Sani keren tel u ini uner igii? Fanu tikii na Ierusalem ri usum le, ru fatapiek ta nenge rakrakai na fakileng na matri, pesu biil ifasi keren fakawe. ");
INSERT INTO bjp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Isau le una tikale u isi gong i sararah na fatpoton fanu, keren fakiing ru isi gong ru fas tikas sabin ini asa Iesu.” ");
INSERT INTO bjp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ri ka tawi fakau ru sabin ke ri ka fakiing ru le gong sabin ru fafas, le fausum tikas ini asa Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Isau le Pita ru e Jon ru ka kiliis ri aragii, “Gam tom gamen wol tole u: I tortores na mata God le kaman wong sing gam le sing i? ");
INSERT INTO bjp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Biil ifasi kaman mange na use sani kama ka par ta u ke kama ka ongen ta u.” ");
INSERT INTO bjp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aunbiing ri ka ta ta ifuun e fafanau sing ruh, ke ri ka wuun ufu ruh. Biil ri fasi rin ta fangungut sing ruh, wara le fanu tikii ri famam usefages God isi sani ae ka tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wara le kaltu ae i liu na rakrakai na fakileng ae ru fatapiek u, bet kia ka liu ufu ta ifet e sangful. ");
INSERT INTO bjp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aunbiing ri ka sok ufu ta Pita ru e Jon, ru ka fis usuf fanu kiruh ke ru ka fas ri ini foron tier tikii ae foron laulaumet na pris turan foron famfamu ri use ta u usuf ruh. ");
INSERT INTO bjp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aunbiing foron tom unune ri ongen u, ri tikii ri ka sising turim usuf God aragii, “Rakrakai na Kumguui, o fakiis ta kukulii, piklinbat ke palgantes turan foron tier tikii ae lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","God, pakanini, o ta ta orek kiam usuf Tanwa Kalkaluu, ke ka susuef ulo tom foim kiam, Dewit tama kemem ma ka tarah, ‘Isi sani ke foron funmat tikii ri ka lala ngaliaf? Ke isi sani fanu ri ka puput isi tel foron tier laulau ae biil ti fua? ");
INSERT INTO bjp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Foron king tina piklinbat ri ka geges isi fapaket, ke foron famfamu ri ka ti turim isi rin tikale Kumguui ke Mesaia kia.’ ");
INSERT INTO bjp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Foron tier ae ka tapiek tekentu tom, aunbiing Erot ru e Pontius Pailat ru ti turan fanu ae biil ri fan Israel ke turan fan Israel aga na Ierusalem, ma ri ka ti turim isi tikale Iesu, Tom Foim kalkaluu kiam, ae o tus pes ta u. ");
INSERT INTO bjp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ri tel foron tier ae namin rakrakai kiam, ke na wolwol kiam ae pakanini tom o put ta u le in tapiek. ");
INSERT INTO bjp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma igii, Kumguui, on wol na foron orek ae ri fasoksoke kemem ini ma ok ta rakrakai sing kemem foron tom foim kiam, isi gong keme sokeh aunbiing keme fafas ini orek kiam. ");
INSERT INTO bjp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sawe limam isi ok faliu foron sasem ma ok fatapiek foron fakileng ke foron tier an fabitit ini asa Iesu, Tom Foim kalkaluu kiam.” ");
INSERT INTO bjp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Aunbiing ri ka sising tikii tah, falifu ae ri kiis turim lo ka nut. Ke ri tikii ri ka fuun ini Tanwa Kalkaluu ma ri ka fafas ini orek ke God ini balamas. ");
INSERT INTO bjp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Foron tom unune tikii, i tikii sau e balri ke i tikii sau e wolwol kiri. Biil tikas i tara le foron minmara kia tom, biil. Foron minmara ri, kiri tikii sau. ");
INSERT INTO bjp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Foron aposel ri ka famam fafas ini apaptifis ke Kumguui Iesu ini tara rakrakai, ke God ka fore fafakalok kia na olri. ");
INSERT INTO bjp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Biil tikas na fatpoto ri i bilbiling, wara le fanse ae imel e nanal kiri le fel kiri, ri sufii u la ma pitkalang lo, ri ka kep u la ");
INSERT INTO bjp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ke ri ka ta u la usuf foron aposel ma ri ka tem u la namin sani temtem tikii i dar u. ");
INSERT INTO bjp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nenge kaltu asa e Josep, foron aposel ri foteng u ini Barnabas. Kamtinan as ae le, “Kalalik an Farakrakai.” I nenge Liwai ma i tina bit na Saiprus. ");
INSERT INTO bjp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I sufii ta sun nanal kia ma pitkalang lo ka ta u usuf foron aposel. ");
INSERT INTO bjp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nenge kaltu asa e Ananias ru lamansilik e Safira, ru sabin ru sufii ta nenge sun nanal kiruh. ");
INSERT INTO bjp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ke Ananias ka pose papte baban pitkalang na nanal ae ke ka ta tiga sau usuf foron aposel. Antu sabin i usum lo. ");
INSERT INTO bjp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ke Pita ka tarah, “Isi sani o ka somangat pes Satan isi in fafuun liu kiam, ke o ka famfabal na mata Tanwa Kalkaluu ma o ka pose papte fale pitkalang na nanal kiam? ");
INSERT INTO bjp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nanal ae kiam tom aunbiing biil biitom ri fiil pes u. Ke aunbiing ri ka fiil pes ta u, pitkalang kiam tom. Isi sani ka mel e matngan wolwol laulau arae sing o? Biil o fabal fanu sau, biil. O famfabal na mata God.” ");
INSERT INTO bjp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aunbiing Ananias i ongen u arae, fanpil ka luut ke ka met. Fanu tikii ae ri ongen u, ri ka lala sokeh. ");
INSERT INTO bjp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ke foron guam ri ka aptih ke ri ka afit pununfo ini kaen ke ri ka kep u isi ile u. ");
INSERT INTO bjp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Na ituul e aunbiing namih, antu ka kau, biil i usum na sani i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ke Pita ka diik u aragii, “Fas iau, pitkalang igii, i e matan nanal tikii kimuh?” Ke ka kiliis u aragii, “Iuu, i e mata nanal tikii.” ");
INSERT INTO bjp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ka tara sing i aragii, “Isi sani kamu ka somangat turim isi tof Tanwa Kumguui? Par u, fanu ae ri ile ta antum, ri sau ae na matanfel ma rin sik fasuu wo sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Fanpil Safira ka luut una keke Pita ke ka met. Aunbiing foron guam ae ri kau, ri ka par fifin ae ka met tah. Ri ka sik fasuuh u ma ri ka ile u na baba antu. ");
INSERT INTO bjp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Foron tom unune tikii, turan fale fanu sabin ri ka lala sokeh na aunbiing ri ongen sani ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Foron aposel ri fatapiek ifuun e fakileng turan foron tier an fabitit na fatpoton fanu. Ma foron tom unune tikii ri fatafe la na Palpalbuang ke king Solomon, ae na palgan ubiif kale Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fale fanu keskes ri soke la isi kiis turim tura ri, isau le ri lala bulat la tom lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma ifuun biitom e fanu turan kelefin ri ka unune lo Kumguui ma ri ka wes fakau ri turan foron tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","I wara na sani ae foron aposel ri tel ta u, ke fanu ri ka lame foron sasem una foron bulin sal, ma ri ka faborong ri na foron luuf ke foron mii salri, isi aunbiing Pita i tole sal, ke tantanwa sau ik la ulo ri. ");
INSERT INTO bjp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gur na fanu tina foron maleh fatat Ierusalem ri ka tapiek sabin ini fanu ae ri sasem turan fal sabin ae foron tanwa laulau ri ta fangungut la usuf ri, ma ri tikii ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ke famfamu ken foron pris turan foron tala ae ri foron Sadusi, ka laulau e balri lon foron aposel. ");
INSERT INTO bjp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ke ri ka luse ri ma ri ka fakau ri na felun kamkabet ken fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Isau le na wor, nenge angelo ke Kumguui ka tapiek ke ka sapeng na foron matanfel na felun kamkabet ma ka fasuu ri. ");
INSERT INTO bjp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ka fas ri aragii, “Gam la ma gamek soti na palgan ubiif kale Felun Tunmapek ma gamek fafas ini foron orek tikii na liu fuuh igii.” ");
INSERT INTO bjp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ri ka ongen ta orek ke angelo, ke na biingbiing saksak ri ka kau una palgan ubiif kale Felun Tunmapek ke ri ka tipes fafas. Aunbiing famfamu ken foron pris turan foron tala ri tapiek, ri ka kam turim foron famfamu tikii ken fan Israel. Ke ri ka wuun ufu fale tom fapaket isi telpes foron aposel tina felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Isau le aunbiing ri tapiek na felun kamkabet, biil ri to par ri. Ke ri ka fis ma ri ka tarah, ");
INSERT INTO bjp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Aunbiing keme tapiek, foron matanfel na felun kamkabet i babat rokap ta tom. Ma fanu ae ri parpar kaleh, ri tom tinaiwa ri soti tah. Isau le aunbiing keme sapeng, biil mang keme par tikas aiwa.” ");
INSERT INTO bjp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kabisit ken foron tom parpar kale Felun Tunmapek turan foron laulaumet na pris ri ka ongen orek ae ma ri ka wolpane, biil ri usum na sani in tapiek. ");
INSERT INTO bjp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Namih, nenge kaltu ka tapiek ke ka tarah, “Par u, fanu ae gam fakau ta ri na kamkabet, ri mang ae na palgan ubiif kale Felun Tunmapek, ri ka famam fausum fanu.” ");
INSERT INTO bjp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ke kabisit ae turan fale tom parpar kale Felun Tunmapek ri ka la ma ri ka tel pes foron aposel. Isau le biil ri to fangongos ri, wara le ri sokeh, tarama fanu ri ka luumete ri. ");
INSERT INTO bjp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Aunbiing ri ka telpes ta foron aposel, ri ka fiti ri na matan foron famfamu. Famfamu ken foron pris ka fas ri aragii, ");
INSERT INTO bjp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Keme ta ta rakrakai na orek igii usuf gam, le gong sabin gam fafas ini asa Iesu. Isau le igii, Ierusalem ka fuun ta ini fafausum kimi ke gam ka ier isi tiu kemem ini dawu.” ");
INSERT INTO bjp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ke Pita turan fale aposel ri ka kiliis ri aragii, “Kemen wong sau sing God. Biil kemen wong sing fanu. ");
INSERT INTO bjp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","God ken foron tubutamat kerer i fapti fafis ta Iesu tina minet, ae gam siimete ta u, aunbiing gam fakulkulik ta u na aupaket. ");
INSERT INTO bjp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ke God ka sik u una mawe ma ka fakiis u na mia arae Famfamu ke Tom Fafaliu kirer. God i tel u arae, isi ifasi kere fan Israel kerek sokiliis liu kirer, ma ik pa ufu foron sinang laulau kirer. ");
INSERT INTO bjp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keme par fatus ta foron tier ae ke kemem tura Tanwa Kalkaluu, keme ka famalal u. Tanwa Kalkaluu i e fafen ke God usuf fanu ae ri mi na orek kia.” ");
INSERT INTO bjp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Aunbiing ri ongen u arae, ri ka lala ngaliaf ma ri ka ier isi siimete foron aposel. ");
INSERT INTO bjp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Isau le neng lon foron Farasi, asa e Gamaliel, i nenge tom fafausum ini nagogon ae fanu tikii ri bulat la lo. Ka sotih ke ka tara le rin fasuu foron aposel ta bii. ");
INSERT INTO bjp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ke ka tara sing ri aragii, “Fan Israel, gamen wol rokap bii isi sani gamen tel u ini fanu igii. ");
INSERT INTO bjp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gam usum le pakanini sau, Teudas i tel u arae nenge tara kaltu, ma fanu ae ri mi la lo, ifasi aragii ifet e mar. Isau le ri ka siimete u ke fanu ae ri mi la lo, ri ka fin sararah ma foim kia ka rop. ");
INSERT INTO bjp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ke namih, Iudas nenge sikin Galili ka tapiek na bet ae ri kep asan fanu tikii ta lo ke ka dat fanu fuun nami, isi fapaket turan matanfuntih na Rom. Ri ka siimete u sabin ke fanu tikii ae ri mi la lo, ri ka sararah. ");
INSERT INTO bjp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Pesu, ia ka fas gam le gong gam tel ti tier ini fanu igii. Taftawa rik la. Male ri tel foron tier ae namin wolwol ken kaltu sau, ke in rop paket. ");
INSERT INTO bjp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Isau male foron tier ae i la sing God, biil tom ifasi gamen tikale ri. Tarama gam ka fapaket tura God.” Ke foron famfamu ri ka somangat na orek ke Gamaliel. ");
INSERT INTO bjp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ri ka tawi fakau foron aposel ke ri ka fas foron tom parpar kale Felun Tunmapek isi pis ri. Namih, ri ka ta rakrakai na orek sing ri le, gong sabin ri fafas ini asa Iesu, ke ri ka sok ufu ri. ");
INSERT INTO bjp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aunbiing ri la koseng foron famfamu ae, ri la ini laes, wara God i par u le i rokap rin ngar matlawen, i wara na asa Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Na foron biing tikii, biil ri mange la na fausum fanu ke fafas ini Rokap na Fafas le Iesu i e Mesaia, na palgan ubiif kale Felun Tunmapek ke na foron matanfel ken fanu. ");
INSERT INTO bjp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na aunbiing ae, wewes lon berberat na fafausum ka laulaumet la. Fal lo ri, ri fan Iudaia ae ri orek Grik la, ri ka fabalkut turan fale fan Iudaia ae ri orek Ibru la. Ri belbel orek la le, ri par ufu foron makos kiri la na foron biing tikii aunbiing ri tulus la ini inen. ");
INSERT INTO bjp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ke sangful ini u e aposel ri ka tawi turim berberat na fafausum tikii ke ri ka fas ri aragii, “Biil i rokap le kemen sok ufu foim na fafas ini orek ke God, isi kemek tulus ini inen. ");
INSERT INTO bjp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pesu foron tualikmem, gamen tim pes in fit e kaltu na fatpoto gam ae gam usum le ri fuun ini Tanwa Kalkaluu ma imel e polo na wol kiri, isi kerek luun foim igii na limri. ");
INSERT INTO bjp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma kemek luun tikii aunbiing kimem na sising ke foim na fafas ini orek ke God.” ");
INSERT INTO bjp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ke ri tikii ri ka laes ini orek ken foron aposel. Ke ri ka tus pes Stiwen ae i nenge rakrakai na tom unune ma ifuun ini Tanwa Kalkaluu, tura Filip, Prokorus, Nikanor, Timon, Parmenas ke Nikolas. Nikolas i sikin Entiok, biil i sikin Iudaia, isau le ka somangat pes ta matngan fafausum ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ri ka fiti fanu ae na matan foron aposel, ke foron aposel ri ka luun limri na olri ma ri ka sising na olri. ");
INSERT INTO bjp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Orek ke God ka sararah ma wewes lon berberat na fafausum na Ierusalem ka laumet lalala, ma ifuun e pris ri ka tapiek tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stiwen i nenge kaltu ae ifuun ini rakrakai ae God i ta ta u usuf i. I tel ifuun e tier an fabitit ke ifuun e fakileng na fatpoton fanu. ");
INSERT INTO bjp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Isau le fale fanu tina nenge felun lotu ken fan Iudaia ae ri foteng u le, “Felun Lotu ken Fanu ae ri Sengsegeng,” ri ka fakep tura Stiwen. Ri la tina Sairini, Aleksendria, Silisia ke tina Eisia. ");
INSERT INTO bjp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ri fakep tura, isau le biil ifasi rin kiliis orek kia, wara le i orek ini polo na wol sing Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pesu ri ka fas fakum fale fanu isi rin tara le, “Keme ongen Stiwen i orek laulau ta ulo Moses ke ulo God sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Aunbiing ri use u arae, ri ka fakut balan fanu turan foron famfamu ke foron tom fafausum ini nagogon. Ri ka luse u ma ri ka lame u isi fiti u na matan foron famfamu. ");
INSERT INTO bjp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ke ri ka lame fakau fale fanu isi rin tiu u ini foron orek ae biil i tekentu. Ke fanu ae, ri ka tarah, “Kaltu igii, biil i mange la na orek laulau una Felun Tunmapek ke una nagogon ke Moses. ");
INSERT INTO bjp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Wara le keme ongen ta u i tara le, Iesu tina Nasaret igii, in rabat Felun Tunmapek ma ik sokiliis foron nagogon ae Moses i ta ta u usuf kerer.” ");
INSERT INTO bjp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ke fanu tikii ae ri kiis ta aiwa, ri ka kanap Stiwen, wara le ri par posong na mata i aragii posong na matan nenge angelo. ");
INSERT INTO bjp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Famfamu ken foron pris ka diik Stiwen aragii, “Orek ae ri tiu wo ini, i tekentu le biil?” ");
INSERT INTO bjp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ke ka kiliis u aragii, “Foron tuaklik ke foron tamang, gam ongen iau! God ae ifuun ini memeh, i tapiek ta sing tubutamat kerer Abaram, aunbiing imel biitom na Mesopotamia ma biil biitom i la una Aran. ");
INSERT INTO bjp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ke God ka fas u aragii, ‘On kang koseng nanal kiam turan foron sikinting lo wo ma ok la una nanal ae ian finngas o ini.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Pesu ka la koseng nanal ken fan Kaldia ma ka mel na Aran. Aunbiing tama ka met tah, ke God ka wuun u una nanal ae igii mang gam ka kiis lo. ");
INSERT INTO bjp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Biil tom ti sun nanal God i ta ta u usuf Abaram, biil. Isau le i falimlim ta usuf i, le i turan foron tubutamat rin kep nanal ae. Aunbiing ae Abaram biil biitom ti kalalik kia. ");
INSERT INTO bjp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God i fas ta u aragii, ‘Foron tubumtamat rin kiis arae foron ses na fale nanal keskes, ma fanu rin tel ri aragii foron fafauun foes ma rin ta fangungut usuf ri na in fet e mar e bet. ");
INSERT INTO bjp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Isau le, ian ta fangungut usuf funmat ae i tel foron tubumtamat arae foron fafauun foes. Ma namih, rin suu tina falifu ae ke rik lotu una aisang aga na falifu igii.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Namih, God ka fas Abaram isi kiit pununfo arae fakileng na puput kia usuf i. Abaram ka fapuar Aisak ma nami na iwal e biing ae i pang lo, ka kiit pununfo Aisak. Nami Aisak ka fapuar Jekop, ke Jekop ka fapuar sangful ini u e tubutamat kerer. ");
INSERT INTO bjp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“I wara le berberat ke Jekop i laulau e balri ini tualik ri sing Josep, ke ri ka ta u isi fanu rin fiil pes u arae nenge fafauun foes una Isip. Isau le God i kiis tura ");
INSERT INTO bjp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ke ka fasengsegeng u koseng foron tatawin tikii ae i tafe u. Parau, king tina Isip ka naim u, wara le Josep i kep polo na wol sing God. Ke Parau ka luun u isi nagogon tikii Isip turan foron tier tikii na fel kia. ");
INSERT INTO bjp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Namih, nenge tara fitol ka tapiek na falifu tikii na Isip ke na Kenan ma ka fatapiek tara na fangungut, ma foron tubutamat kerer biil ifasi rin tafe ti inen. ");
INSERT INTO bjp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Aunbiing Jekop ka ongen u le imel e inen na Isip, ka wuun foron tubutamat kerer na ninla famu kiri unaiwa. ");
INSERT INTO bjp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na fawu e ninla kiri, Josep ka fas foron tualik mang le i e seh, ke Parau ka usum mang lon foron tualik e Josep ke tama. ");
INSERT INTO bjp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Namih, Josep ka fawuun isi tama turan foron sikinting tikii lo. Wewes tikii lo ri, ifasi aragii ifit e sangful ini lim. ");
INSERT INTO bjp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Namih, Jekop ka pu una Isip ke ka met aiwa turan foron tubutamat kerer. ");
INSERT INTO bjp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ri ka kep fafis pununfo ri tom una Sekem ma ri ka luun ri na matanfat una luun minet, ae Abaram i fiil pes ta u ini fale pitkalang sing berberat ke Amor. ");
INSERT INTO bjp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ma aunbiing ka fatat mang isi God in fasuut falimlim kia usuf Abaram, wewes lon fanu kirer na Isip ka lala laumet. ");
INSERT INTO bjp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Namih, nenge king ae biil i usum lo Josep ka nagogon na Isip. ");
INSERT INTO bjp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King ae ka fabal foron tubutamat kerer ma ka ta fangungut usuf ri ke ka fangongos ri isi rin lin foron mirmiriiu kiri, isi rik met. ");
INSERT INTO bjp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Na aunbiing ae, Moses ka pang. Ma God i laes kanaka ini. Na ituul e funiil, ri fofonoi lo na fel ke tama. ");
INSERT INTO bjp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aunbiing ri ka luun ta u koseng ri, keleflik ke king Parau ka patak pes u ma ka fofonoi lo arae nenge kalalik tutus kia. ");
INSERT INTO bjp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses ka kep fafausum na matngan tasum tikii ken fan Isip, ma i rakrakai kanaka na orek kia ma na foim kia. ");
INSERT INTO bjp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Aunbiing Moses ka fet e sangful e bet kia, ka ier isi in laum foron sikinting lo. ");
INSERT INTO bjp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka par nenge sikin Isip i paket neng lo ri, pesu ka la isi tikale u. Ke ka siimete sikin Isip ae, una kiliis sinang ae i tel ta u. ");
INSERT INTO bjp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses i wol le fanu tutus kia rin iliim u le God i tus pes ta u isi in faliu ri, isau le biil ri iliim u. ");
INSERT INTO bjp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Na biing namih, Moses ka tafe iwu e sikin Israel ru fapaket, ke ka totof isi tikale ruh ma ka tarah, ‘Uner, kamu iun latualik sau. Isi sani kamu ka fapaket fis ini kamuh?’ ");
INSERT INTO bjp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Isau le kaltu ae i paket nenge tala, ka sule ufu Moses ke ka tara sing i aragii, ‘Se i luun ta wo isi on tapiek famfamu ke tom nagogon kimem? ");
INSERT INTO bjp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Arafah, o ier isi siimete iau arae o siimete ta nenge sikin Isip nabiing?’ ");
INSERT INTO bjp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aunbiing Moses ka ongen u arae, ka fin una Midian ma ka mel aiwa arae nenge ses ke ka fapuar iwu e kalalik tamat. ");
INSERT INTO bjp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nami na ifet e sangful e bet, nenge angelo ka tapiek sing i na falifu foes fatat pungpung na Sinai. I tapiek sing i na palgan karfian yiif na nenge au. ");
INSERT INTO bjp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Aunbiing i par u, ka lala bitit na sani i par ta u. Ma aunbiing i la fatat isi par fakasi, ka ongen kine Kumguui i tara aragii, ");
INSERT INTO bjp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ia God ken foron tubumtamat. Ia God ke Abaram, Aisak ke Jekop.’ Moses ka nananar ma ka lala binbin isi in par. ");
INSERT INTO bjp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ke Kumguui ka tara sing i aragii, ‘Tel ufu su kiam, wara le falifu ae o soti lo i kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ia ka par ta foron fangungut tikii ae ri ta u usuf fanu kiak na Isip. Ia ka ongen ta tineng kiri ke ia ka pu isi fasengsegeng ri. Ma igii, la mang. Ian wuun fafis o una Isip.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses ae, ri fakawe ufu tah ma ri ka tara ta sing i le, ‘Se i luun ta wo isi on tapiek famfamu ke tom nagogon?’ Moses sau ae, God i wuun fafis u usuf ri, isi in famfamu kiri ke isi ik fasengsegeng ri. I wuun ufu na aunbiing angelo i tapiek ta sing i na au ae i sok. ");
INSERT INTO bjp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ka lame fasuu ri koseng Isip ma ka fatapiek foron tier an fabitit ke foron fakileng na Isip, na palgantes ae ri foteng u ini Tes Melmelek ke na falifu foes na ifet e sangful e bet. ");
INSERT INTO bjp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moses sau ae, i fas ta fan Israel le, ‘God in wuun ti profet arae iau usuf gam tina foron sikinting lo gam tom.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses i kiis turim turan foron tubutamat kerer na falifu foes ke turan angelo ae i faorek ta u na pungpung na Sinai. Ke ka kep ta foron orek ae i liu isi in ta u usuf kerer. ");
INSERT INTO bjp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Isau le foron tubutamat kerer biil ri wong sing i. Ri ka soke ufu bin ma na wolwol kiri, ri ier tom isi fis una Isip. ");
INSERT INTO bjp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ri ka fas Aron aragii, ‘Tel ti foron god kirer ae in famu pes kerer, wara le Moses ae i lame fasuu ta kerer tina Isip, biil mang kere usum le sani mang ka tapiek lo.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Na aunbiing ae, ri ka tel nenge god famfabal arae nenge natun bulmakau. Ri ka ta foron fafen usuf i ma ri ka lala laes ini sani ri tel ta u ini limri. ");
INSERT INTO bjp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Isau le God ka ta pokta ulo ri, isi rik lotu una aisan foron tier tikii buuii na bat. Arae sabin na buk ken foron profet ri siit u aragii, ‘Fan Israel, aunbiing gam la na falifu foes na ifet e sangful e bet, biil gam tel ta ti tunmapek usuf iau ke biil gam ta ti fafen ta usuf iau. ");
INSERT INTO bjp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gam kusep ta felu Molek, god kimi. Ke nenge keltot, tantanwa Refan, i e god kimi. Iun god ae, gam tom gam tel ta u isi gamen lotu una aisruh. Pesu, ian tel ufu gam una fale maleh ae i tapak koseng Babilon.’ ");
INSERT INTO bjp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Aunbiing foron tubutamat kerer ri la na falifu foes, palpalbuang ke God, tinaiwa tom na aisri. Palpalbuang ae i fakileng u le God ae tom na aisri. Ri tel palpalbuang ae arae tom God i patrai ta Moses, namin tantanwa ae i par ta u. ");
INSERT INTO bjp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Namih, foron tubutamat kerer ri ka kep pes palpalbuang ae sing foron temri. Ri ka kusep u tura ri aunbiing Josua i famu pes ri ma ri ka kep nanal sing fale funmat ae God tom i tel ufu ta ri na famu lo ri. Ke palpalbuang ae, tinaiwa tom, papang na aunbiing ke king Dewit. ");
INSERT INTO bjp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dewit i falaes God ke ka sising usuf i le in somangat ufu isi ik tel ti rokap na felu God ke Jekop. ");
INSERT INTO bjp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Isau le king Solomon mang ka tel fel ae. ");
INSERT INTO bjp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Isau le God Buuii na Mawe, biil i kiis la na foron fel ae fanu ri tel u. Arae tom profet i use ta u le, ");
INSERT INTO bjp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Kumguui i tarah, Kukulii i e nian kiiskiis an king kiak, ma piklinbat i e salan luun kekeng. Matngan fel arafa gamen tel u salang? Ke fiawa e salan mange kiak? ");
INSERT INTO bjp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Foron tier tikii igii, ia tom ia tel ta u ini limang.’” ");
INSERT INTO bjp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ke ka tara sabin aragii, “I arae fat e balmi! Ma gam arae fanu ae biil ri usum lo God ke balbalu gam i kutkut! Gam fasi sabin arae foron tubutamat gam. Gam tikale foim la ken Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Arafah, imel e ti profet awii, ae foron tubutamat gam biil ri ta fangungut ta usuf i? Ri siimete ta fanu sabin ae ri fafas famu ta ini taptapiek ke Ier ae i Tom Tortores. Ma igii, gam ka siimete ta u, na aunbiing gam ta ufu ta una liman foron tuui. ");
INSERT INTO bjp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gam sau gam kep ta nagogon ke God ae foron angelo ri filange ta u, isau le biil tom gam misuut lo!” ");
INSERT INTO bjp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Aunbiing ri ongen orek ke Stiwen, ri ka lala ngaliaf ma ri ka ngaitpam ulo. ");
INSERT INTO bjp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Isau le Stiwen ifuun ini Tanwa Kalkaluu. Ka par una kukulii ma ka par memeh ke God ke ka par Iesu i soti na mia God. ");
INSERT INTO bjp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ke ka tarah, “Par u, ia par kukulii i sapeng ma Kalalik ken Kaltu i soti na mia God.” ");
INSERT INTO bjp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ri ongen orek ae ke ri ka piis kale foron balbalu ri ma ri ka kukuk ulo. Ri ka faruru kale u ");
INSERT INTO bjp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ke ri ka dat fasuu u tina maleh ae ma ri ka tipes luuluu u. Ke fanu ae ri tiu ta u, ri ka tel ufu foron dolon kaen kiri ke ri ka luun u fatat iun keke nenge guam, asa e Sol. ");
INSERT INTO bjp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Aunbiing ri luuluu u la biitom, Stiwen ka sising aragii, “Kumguui Iesu, pose pes tanwang.” ");
INSERT INTO bjp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Namih, ka ilepul ma ka tautau aragii, “Kumguui! Gong o kiliis fafis sinang laulau igii ri tel u!” Ka use ta u arae ke ka met. ");
INSERT INTO bjp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol tinaiwa ma i somangat sau na minet ke Stiwen. Na biing ae, fanu ri ka tipes ta tara fangungut sing foron tom unune na Ierusalem. Foron tom unune tikii ri ka sarara na falifu tikii na Iudaia ke na Samaria. Foron aposel sau tinaiwa tom na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Fale fanu ae ri mi la na wolwol ke God ri ka ile Stiwen ma ri ka lala tingis u. ");
INSERT INTO bjp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Isau le Sol ka tipes falaulau foron tom unune. I la una foron fel kiri ma ka dat ufu fanu tamat turan kelefin una felun kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Foron tom unune ae ri fin sararah tah, ri ka fafas ini Rokap na Fafas na foron falifu tikii ae ri la ulo. ");
INSERT INTO bjp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ka la una tara maleh na Samaria ke ka fafas ini Mesaia aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aunbiing gur na fanu ae ri ongen orek ke Filip ma ri ka par foron fakileng ae i fatapiek u, ri ka kiis fofo isi ongen sani i use u. ");
INSERT INTO bjp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Foron tanwa laulau ri suu ini ngangeh koseng fanu fuun, ma fanu fuun ae i met e nenge baban fo ri turan fanu fuun ae ri peo, ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ma fanu na maleh ae, ri ka lala laes. ");
INSERT INTO bjp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nenge kaltu na maleh ae, asa e Saimon, i usum na marmarsan latlat ma fan Samaria tikii ri pangang la na foron tier ae i tel u la. Ma i falaumet u la tom na matan fanu. ");
INSERT INTO bjp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma fanu tikii, pirpiran fanu turan fanu foes, ri tikii ri wong la sing i ma ri ka paeng u la aragii, “Rakrakai ke God igii sing ier igii, ae ri foteng u ini Tara Rakrakai.” ");
INSERT INTO bjp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ri mi la lo, wara le ka fatel ta wolwol kiri ini marmarsan latlat ae ka tel ta u na dolon aunbiing. ");
INSERT INTO bjp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Isau le aunbiing Filip ka fafas ini Rokap na Fafas na matanfuntih ke God ke ini asa Iesu Karisito, fanu tamat turan kelefin ri ka unune ma ri ka kep bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon sabin ka unune ke ka kep bapitaiso ma ka mi lo Filip una foron falifu tikii. Ka par foron fakileng turan foron rakrakai na foim ae Filip i fatapiek u ma ka lala bitit. ");
INSERT INTO bjp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aunbiing foron aposel na Ierusalem ri ka ongen ta u le fan Samaria ri ka somangat pes ta orek ke God, ri ka wuun ufu Pita ru e Jon usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aunbiing ru tapiek, ru ka sising usuf God isi rin kep Tanwa Kalkaluu, ");
INSERT INTO bjp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","wara le Tanwa Kalkaluu biil biitom i susuef ta ulon tikas lo ri. Ri kep bapitaiso ta sau na asa Kumguui Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ke Pita ru e Jon ru ka luun limruh na olri, ma ri ka kep Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon ka par fanu ri kep Tanwa Kalkaluu aunbiing iun aposel ae ru luun limruh lo ri. Pesu ka ier isi ta pitkalang sing ruh, ");
INSERT INTO bjp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ke ka tarah, “Kamu ta rakrakai sabin ae usuf iau, isi aunbiing ian luun limang na olon fanu, ke rik kep Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Isau le Pita ka kiliis u aragii, “Taftawa ok fiu turan pitkalang kiam, wara o wol le ifasi on fiil fafen ke God ini pitkalang. ");
INSERT INTO bjp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Biil ifasi on foim tura kemem na foim igii, wara le balam biil i tortores na mata God. ");
INSERT INTO bjp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","On kiliis liu kiam koseng wolwol laulau kiam ma ok sising usuf Kumguui. Awii ngan, in pa ufu sinang laulau ae na balam. ");
INSERT INTO bjp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Wara ia par u le o fuun ini sinangun ram ma o kiis na kamkabet na sinang laulau.” ");
INSERT INTO bjp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ke Saimon ka kiliis u aragii, “Sising usuf Kumguui isi iau, isi foron tier ae o ka use ta u, biil in tapiek lo iau.” ");
INSERT INTO bjp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aunbiing Pita ru e Jon ru ka famalal tikii ta sani Kumguui ka tel ta u, ru ka fafas ini orek kia ma namih, ru ka fis una Ierusalem. Ma na ninla kiruh, ru ka famam fafas ini Rokap na Fafas na ifuun e maleh na Samaria. ");
INSERT INTO bjp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nenge angelo ke Kumguui ka tara sing Filip aragii, “Aptih ma ok la ubaeng na sal ae na falifu foes, ae i pu tina Ierusalem una Gasa.” ");
INSERT INTO bjp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip ka la ma na ninla kia, ka tafe nenge sikin Itiopia. I nenge tara kaltu na matanfuntih ke Kandake, kuin tina Itiopia, ma i parpar la na foron pitkalang tikii ke kuin. I la ta una Ierusalem isi lotu, ");
INSERT INTO bjp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma na ninla fis kia, i kiis na kariis ma ka weswes buk la ke profet Aisaia. ");
INSERT INTO bjp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ke Tanwa Kalkaluu ka fas Filip aragii, “La fatat kariis ae ma ok la tura.” ");
INSERT INTO bjp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip ka filau fatat ma ka ongen u i weswes orek la ke profet Aisaia. Ke ka diik u aragii, “Arafah, o malal sabin na sani ae o weswes u la, le biil?” ");
INSERT INTO bjp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ka kiliis u aragii, “Arafa ian malal arae, male biil tikas i puk u usuf iau?” Ke ka sising Filip le in fen ma ik kiis tura. ");
INSERT INTO bjp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sun orek na Buk na Gogoh ae i weswes u la, i aragii, “Biil i use ti tier. I arae nenge sipsip ae ri lame u isi siimete u, ke arae natun sipsip ae ri kiit ufu olo ma biil i ngangeh. ");
INSERT INTO bjp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ri puris ta u ke biil ri tel tortores na nagogon ulo. Biil tikas ifasi in ususe sing berberat kia, wara le ri ka tel ufu ta liu kia na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kaltu ae ka tara sing Filip aragii, “Kiskam, fas iau, se ae profet i use u? I use fafis u tom le tikas keskes?” ");
INSERT INTO bjp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ke Filip ka fas u ini Rokap na Fafas lo Iesu. I tipes u ini sun orek tom na Buk na Gogoh, ae kaltu ae i weswes u la. ");
INSERT INTO bjp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Na ninla kiruh, ru ka tapiek na nenge dan, ke kaltu ae ka tarah, “Par u, nenge dan igii. Sani i tikale iau isi biil ian kep bapitaiso?” ");
INSERT INTO bjp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kaltu ae ka tara le in mangeh bii e kariis. Ke ru e Filip ru ka pu tina kariis una dan, ke Filip ka baptais u. ");
INSERT INTO bjp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Aunbiing ru apti koseng dan ae, fanpil Tanwa Kumguui ka kep ufu Filip. Kaltu ae biil mang i par u, isau le na ninla kia, ka la ini laes. ");
INSERT INTO bjp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ke Filip ka tafe u le, i mang ta ae na Asotus. Ka tipes fafas aiwa ini Rokap na Fafas na foron maleh tikii, papang na aunbiing ka tapiek na Sisaria. ");
INSERT INTO bjp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na aunbiing ae, Sol i lala ier le in ta fangungut usuf berberat na fafausum ke Kumguui ma ka ier isi siimete ri. Ka la usuf famfamu ken foron pris ");
INSERT INTO bjp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ke ka fas u isi in siit ti fale leta una foron felun lotu na Damaskas, isi aunbiing in tafe ti kaltu le fifin ae i mi na fafausum ae ri foteng u le Sal ke Kumguui, ke ik luse u isi kamkabet na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ka apti ke ka la. Aunbiing ka la fatat isi Damaskas, fanpil nenge malal tina kukulii ka popos kawil u. ");
INSERT INTO bjp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol ka luut una nanal ke ka ongen kinen tikas i tara sing i aragii, “Sol, Sol, isi sani o ka ta fangungut usuf iau?” ");
INSERT INTO bjp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ke Sol ka diik u aragii, “Kumguui, wo seh?” Ke ka kiliis u aragii, “Ia Iesu, ae o famam ta fangungut sing iau. ");
INSERT INTO bjp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","On aptih ma ok kau na Damaskas, ma aiwa nenge kaltu in fas o ini sani on tel u.” ");
INSERT INTO bjp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Fanu ae ri la tura, ri ka bitit ma biil ri use ti tier, wara le ri ongen kinen kaltu, isau le biil ri par tikas. ");
INSERT INTO bjp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ka apti tina nanal, isau le aunbiing i par, biil ifasi in par ti tier. Pesu ri ka tangne u sau una Damaskas. ");
INSERT INTO bjp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Na ituul e biing, biil ifasi in par ke biil i ien ke biil i yin. ");
INSERT INTO bjp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Imel e nenge kalalik na fafausum ke Iesu na Damaskas, asa e Ananias. Kumguui ka tapiek sing i na nenge parpar ma ka tara sing i aragii, “Ananias!” Ke ka kiliis u aragii, “Kumguui, ia igii.” ");
INSERT INTO bjp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ke Kumguui ka tara sing i aragii, “Aptih ma ok la una fel ke Iudas na sal ae ri foteng u ini Sal Tortores ma ok diik isi nenge kaltu tina Tarsus asa e Sol. Wara le i famam sising ");
INSERT INTO bjp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma na nenge parpar, ka par nenge kaltu asa e Ananias i kau ma ka luun iun lima lo isi ik par sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ke Ananias ka kiliis u aragii, “Kumguui, ia ka ongen ta ifuun e ususe lon kaltu ae ma na foron fangungut ae ka ta ta u usuf fanu kalkaluu kiam na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma i tapiek aga ini rakrakai sing foron laulaumet na pris, isi luse fanu tikii ae ri fakam la unaisam.” ");
INSERT INTO bjp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Isau le Kumguui ka tara sing Ananias aragii, “Aptih ma ok la! Kaltu ae ia ka tim pes ta u arae nenge tom foim kiak, isi in fafas ini asang usuf fanu ae biil ri fan Israel ke usuf foron king kiri ke usuf fan Israel sabin. ");
INSERT INTO bjp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ian finngas u ini foron fangungut ae in kalsakai u, wara na asang.” ");
INSERT INTO bjp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Namih, Ananias ka la ke ka kau una fel ae Sol i kiis lo. Ka luun iun lima na olo, ke ka tarah, “Sol, tuaklik, Kumguui Iesu ae i tapiek ta sing o na sal aunbiing o la ugapiek, i wuun iau isi ok par sabin ma ok fuun ini Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma fanpil foron tier arae kupan kok ka luut tina iun kolson mata, ke ka par sabin. Ka aptih ma ka kep bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Aunbiing ka ien tah, ke pununfo ka rakrakai fis. Ke Sol ka melmel turan berberat na fafausum ke Iesu na Damaskas pes fale biing sabin. ");
INSERT INTO bjp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Biil i sawin, ke Sol ka tipes fafas na foron felun lotu le Iesu i e Kalalik ke God. ");
INSERT INTO bjp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma fanu tikii ae ri ongen u, ri ka bitit ma ri ka tarah, “Ier sau igii i falaulau ta fanu na Ierusalem ae ri lotu la una asa Iesu. Ke ka la sabin uga isi luse ri usuf foron laulaumet na pris.” ");
INSERT INTO bjp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Isau le, fafas ke Sol ka lala rakrakai ma ka fatekentu u le Iesu sau i e Mesaia. Fafas kia ka fatel fan Iudaia tikii ae na Damaskas ri ka wolpane. ");
INSERT INTO bjp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na fale biing namih, fan Iudaia ri ka put orek isi siimete u. ");
INSERT INTO bjp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Isau le Sol ka usum ta na puput kiri. Na foron siat ke na foron wor ri luun matri la na foron matan ubiif kale maleh ae, isi rin siimete u. ");
INSERT INTO bjp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Isau le na nenge wor, fanu ae ri mi la lo, ri ka silung fapu u na nenge kes na nenge matanbuat na ubiif kale maleh ae. ");
INSERT INTO bjp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aunbiing Sol ka tapiek na Ierusalem, ka totof isi in kiis turim turan berberat na fafausum ke Iesu, isau le ri tikii ri ka soke u. Biil ri unune le i sabin i nenge kalalik na fafausum. ");
INSERT INTO bjp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Isau le Barnabas ka tel pes u usuf foron aposel. Barnabas ka ususe sing ri le Sol i par ta Kumguui na ninla kia ma Kumguui ka faorek u. Ka fas ri sabin le aunbiing Sol i fafas ta na Damaskas ini asa Iesu, ma biil i sokeh. ");
INSERT INTO bjp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ke Sol ka melmel tura ri ma ka sol turim tura ri na Ierusalem, ma i fafas ini asa Kumguui ini balamas. ");
INSERT INTO bjp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","I orek turan fan Iudaia ae ri orek Grik la ma ka fapit tura ri, isau le ri ka totof isi rin siimete u. ");
INSERT INTO bjp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma aunbiing foron tom unune ri ka ongen u, ri ka telpes u una Sisaria ke ri ka wuun ufu una Tarsus. ");
INSERT INTO bjp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Namih, foron tom unune na foron maleh tikii na Iudaia, Galili ke Samaria, ri ka kiis ini siaroh. Ma na falupes ken Tanwa Kalkaluu ka farakrakai ri ma wewes lo ri ka laumet lalala. Ma ri ka liu ini sinangun bulat lo Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Aunbiing Pita i la una foron maleh, i la sabin isi laum fanu kalkaluu ke God ae na Lida. ");
INSERT INTO bjp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma aiwa, ka tafe nenge kaltu asa e Aineas. I met e baban fo ma na iwal e bet, biil ifasi in apti tina mii sala. ");
INSERT INTO bjp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ka tara sing i aragii, “Aineas, Iesu Karisito i faliu wo. Aptih ma ok finris mii salam!” Fanpil, ka aptih. ");
INSERT INTO bjp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ke fanu tikii ae na Lida ke na Saron ri ka par u ma ri ka ta liu kiri sing Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Imel e nenge fifin na Jopa asa e Tabita, i nenge tom unune. Tabita na orek Grik le Dokas. I tel rokap na sinang ma i lupes foron lauu la. ");
INSERT INTO bjp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na aunbiing ae, ka sasem ke ka met. Ri ka sufe u ke ri ka faborong u na nenge dek bae na mawe na fel. ");
INSERT INTO bjp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida i fatat sau isi Jopa. Ma aunbiing foron tom unune ri ongen u le Pita ae na Lida, ri ka wuun ufu iwu e kaltu isi, ke ru ka fas u aragii, “Kiskam, on sangar una aismem.” ");
INSERT INTO bjp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita ka aptih ma ka la tura ruh. Aunbiing ka tapiek, ri ka lame u ubae na mawe. Foron makos tikii ri soti kawil ta u ma ri ka tengteng la, ke ri ka finngas u ini foron kaen ae Dokas i tel ta u, aunbiing i liu biitom. ");
INSERT INTO bjp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ka wuun fasuu ri tinaiwa, ka ilepul ke ka sising. Ka giliim usuf fifin ae i met ke ka tarah, “Tabita, aptih!” Aunbiing Tabita ka par, ka par Pita, ke ka kiis. ");
INSERT INTO bjp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ka pose na lima ke ka fapti u. Namih, ka kam foron tom unune turan foron makos ke ka ta ufu fifin ae ka liu ta usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ususe ae ka sarara na falifu tikii na Jopa, ma fanu fuun ri ka unune lo Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita ka melmel na Jopa na fale biing sabin turan nenge kaltu asa e Saimon. Saimon ae i fii foron punun muruuw la. ");
INSERT INTO bjp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na maleh na Sisaria, imel e nenge kaltu asa e Konelius, i nenge kabisit ken nenge mar e tom fapaket ae ri foteng ri le foron tom fapaket tina Itali. ");
INSERT INTO bjp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konelius turan fanu tikii ae na matanfel kia, ri foron tom lotu ma ri bulat la lo God. I fen foron lauu la ke ka sising la usuf God. ");
INSERT INTO bjp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na ituul e aunbiing na nenge efef, i par nenge parpar. I par fatus nenge angelo ke God i tapiek sing i ma ka tarah, “Konelius!” ");
INSERT INTO bjp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ke Konelius ka par sok lo ini sokeh ke ka kiliis u aragii, “Kumguui, sanih?” Angelo ae ka fas u aragii, “Foron sising kiam ke foron fafen kiam usuf foron lauu, God ka ongen ta u ma ka somangat pes ta u. ");
INSERT INTO bjp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma igii on wuun ufu ti fanu una Jopa isi rin tel pes nenge kaltu ugapiek asa e Saimon, nenge asa sabin e Pita. ");
INSERT INTO bjp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ma i melmel tura Saimon ae i fii foron punun muruuw la ma fel kia ae na baban kiin.” ");
INSERT INTO bjp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aunbiing angelo ae i faorek ta u ka la, ke Konelius ka kam pes iwu e fafauun kia turan nenge tom lotu tekentu tina palgan foron tom fapaket kia, ae i foim la tom tura. ");
INSERT INTO bjp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ke ka fas rituul ini foron tier tikii ae i tapiek tah ke ka wuun ufu rituul una Jopa. ");
INSERT INTO bjp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na fawu u e biing na ninla kirituul na sangful ini u e aunbiing na siat, rituul ka lala fatat la isi maleh na Jopa. Aunbiing sabin ae, Pita ka fen ubae na olon fel isi sising. ");
INSERT INTO bjp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ka fitol ke ka ier isi ien ti tier, ma aunbiing ri teltel inen la biitom, ka ruungruung e wolwol kia ke ka par nenge parpar. ");
INSERT INTO bjp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I par kukulii i sapeng ma ka par nenge tier arae tara na kaen ae ri pose na ifet e su ma ri ka fapfapu u la una piklinbat. ");
INSERT INTO bjp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Aiwa na palgan kaen ae, marmarsan muruuw tinaiwa, fal ifet e kekri, fal ri kakak la turan foron man. ");
INSERT INTO bjp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ke kinen tikas ka tarah, “Pita, aptih! Siimete ri ke ok ien ri.” ");
INSERT INTO bjp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Isau le Pita ka kiliis u aragii, “Kumguui, biil tom! Biil biitom ia ien ta ti tier ae biil i kalkaluu ma i duh na matam.” ");
INSERT INTO bjp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kinen tikas ae, ka fas u sabin aragii, “Sani ae God ka fafuu ta u, gong o tara le i duh.” ");
INSERT INTO bjp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Fatuul u e aunbiing i tapiek e tier igii, ke fanpil ri ka kep fafis kaen ae ubase na kukulii. ");
INSERT INTO bjp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Aunbiing Pita i wolwol la biitom isi kamtinan parpar ae i par ta u, ke tuul kaltu ae Konelius i wuun ufu ta rituul, rituul ka tafe ta fel ke Saimon ma rituul ka soti ta mang awii na matanfel kia. ");
INSERT INTO bjp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ke rituul ka fakam una palgan fel aragii, “Saimon ae nenge asa sabin e Pita, mangmangal awii?” ");
INSERT INTO bjp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aunbiing Pita i wolwol la biitom na parpar kia, ke Tanwa Kalkaluu ka fas u aragii, “Pita, ituul e kaltu rituul im isi wo. ");
INSERT INTO bjp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aptih ma ok puh, gong o lala wol. Mi lo rituul, wara le ia tom ia wuun ta rituul uga.” ");
INSERT INTO bjp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ka puh ke ka fas tuul kaltu ae aragii, “Iau sau e kaltu ae gamtuul im isi. Sani gamtuul ier isi?” ");
INSERT INTO bjp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Rituul ka fas u aragii, “Konelius, ae i kabisit ken nenge mar e tom fapaket i wuun ufu kemtuul. I nenge tom tortores ma imel e bulat kia lo God ma fan Iudaia tikii sabin ri lala bulat la lo. Nenge angelo kalkaluu i tapiek ta sing i ke ka fas u le in fawuun pes o, isi ok la una fel kia ma ik ongen sani on fas u ini.” ");
INSERT INTO bjp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ke Pita ka fakau rituul isi rituulen borong bii aiwa, lo e wor ae. Na biingbiing, Pita ka la tura rituul. Fale fanu sabin ae ri fatfat latualik na asa Iesu tina Jopa, ri ka la turim tura ri. ");
INSERT INTO bjp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na biing namih, ri ka tapiek na Sisaria. Konelius i usum le rin tapiek, pesu ka kam turim foron sikinting lo turan foron rokap na tala una fel kia. ");
INSERT INTO bjp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Aunbiing Pita ka kau na fel ke Konelius, Konelius ka ilepul na mata ke ka lotu unaisa. ");
INSERT INTO bjp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Isau le Pita ka fapti u ke ka fas u aragii, “Sotih, ia kaltu sau arae wo.” ");
INSERT INTO bjp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Aunbiing ru ororek kau la, Pita ka par almin fanu ri ka kiis turim ta aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ke ka tarah, “Gam tikii gam usum le na nagogon kimem fan Iudaia, i tikale kemem le gong keme fatala turim turan fanu ae biil ri fan Iudaia, ke gong sabin keme la isi laum ri. Isau le God ka famalal ta iau le gong ia foteng tikas le biil i kalkaluu ma i duh na mata God. ");
INSERT INTO bjp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","I e wara ia ka la uga ma biil ia ongen ufu fakam kiam. Ma igii iak diik gam le, gam fawuun isi iau isi sah?” ");
INSERT INTO bjp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelius ka kiliis u aragii, “Ka fet ta e biing kale biing ae ia sising na fel kiak na matngan aunbiing aragii ituul e aunbiing na efef. Fanpil ia ka par nenge kaltu i tapiek na matang ae kilkiliis kia i barang kanaka. ");
INSERT INTO bjp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ke ka tara sing iau aragii, ‘Konelius, God ka ongen tikii ta foron sising kiam ma ka usum ta na foron fafen tikii kiam usuf foron lauu. ");
INSERT INTO bjp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","On fawuun una Jopa isi Saimon ae nenge asa sabin e Pita. I melmel na fel ke Saimon, kaltu ae i fii foron punun muruuw la ma fel kia ae na baban kiin.’ ");
INSERT INTO bjp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pesu, ia ka fawuun sape isi wo. Ma i rokap mang, o ka tapiek aga. Kemem tikii igii, keme kiis na mata God isi kemen ongen foron orek tikii, ae Kumguui ka fas ta wo isi on fas kemem ini.” ");
INSERT INTO bjp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ke Pita ka tipes fafas aragii, “Tekentu kanaka, igii ia ka usum mang le sinangu God i fafasi usuf fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma i somangat pes fanu tina foron falifu tikii ae ri bulat lo, ma ri tel sinang ae i tortores. ");
INSERT INTO bjp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gam usum le fafas igii God i ta ufu ta usuf fan Israel, i e Rokap na Fafas na siaroh na fatpoto God turan fanu, ae lo Iesu Karisito, Kumguui ken fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gam usum na sani ae i tapiek ta na falifu tikii na Iudaia, tipes u na Galili, aunbiing Jon Tom tel Bapitaiso i fafas ta ini bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Gam usum le God i ta ta Tanwa Kalkaluu turan rakrakai usuf Iesu tina Nasaret, ke Iesu ka la na foron falifu tikii. Ka tel rokap na foim ke ka faliu fanu la ae ri kiis ta na piklin rakrakai ke Satan, wara le God i kiis tura. ");
INSERT INTO bjp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Keme use fatus foron tier tikii ae keme par Iesu i tel ta u na nanal ken fan Iudaia ke na Ierusalem. Ri siimete ta u, aunbiing ri fakulkulik u na nenge aupaket. ");
INSERT INTO bjp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Isau le na fatuul u e biing, God ka fapti fafis u sabin ke ka finngas u isi fanu rik par u. ");
INSERT INTO bjp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Biil i finngas u usuf fanu tikii, i finngas u sau usuf kemem ae God i fule pes ta kemem isi kemek fas fanu ini ususe lo. Keme ien ke keme ka yin ta tura nami na apaptifis kia. ");
INSERT INTO bjp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ke ka wuun ta kemem isi kemen fafas ke kemek famalal u le, i tom e ier ae God i tus pes ta u le in tapiek tom nagogon ken fanu ae ri liu ke ken foron minet. ");
INSERT INTO bjp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Foron profet tikii sabin ri ororek ta isi Iesu, le se i unune lo, God in pa ufu sinang laulau kia, wara na asa Iesu.” ");
INSERT INTO bjp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Aunbiing Pita i ororek la biitom, Tanwa Kalkaluu ka susuef ulon fanu tikii ae ri ongen fafas kia. ");
INSERT INTO bjp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ke foron tom unune tina Iudaia ae ri la ta tura Pita ri ka bitit wara le, God ka ta ta Tanwa Kalkaluu arae fafen usuf fanu sabin ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ma ri ka ongen fanu sabin ae ri orek ini marmarsan orek ke ri ka famam usefages God. Ke Pita ka tarah, ");
INSERT INTO bjp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Biil ifasi tikas in tikale fanu igii isi gong ri kep bapitaiso ini dan. Ri sabin ri ka kep ta Tanwa Kalkaluu arae kere kep ta u.” ");
INSERT INTO bjp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ke Pita ka fas ri isi rin kep bapitaiso na asa Iesu Karisito. Ke ri ka rut Pita isi in melmel pes fale biing bii naisri. ");
INSERT INTO bjp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Foron aposel turan foron tom unune tikii ae na Iudaia ri ka ongen ta u le, fanu sabin ae biil ri fan Iudaia ri ka somangat pes ta orek ke God. ");
INSERT INTO bjp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ke aunbiing Pita i la una Ierusalem, foron tom unune ae ri kiit pununfo ri, ri ka belbel orek lo aragii, ");
INSERT INTO bjp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Isi sani o ka kau na fel ken fanu ae biil ri fan Iudaia ke o ka ien tura ri?” ");
INSERT INTO bjp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ke Pita ka fas fakasi ri ini foron tier tikii ae i tapiek tah. ");
INSERT INTO bjp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ka fas ri aragii, “Aunbiing ia tinawii na Jopa, ia sisising la, ka ruungruung e wolwol kiak ma ia ka par nenge parpar. Ia par nenge tier arae nenge tara na kaen, ri pose na ifet e su ma ri ka fapfapu u la tinbae na kukulii usuf iau. ");
INSERT INTO bjp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ia par na palga ke ia ka par foron muruuw tina piklinbat ae ifet e kekri, fal aka ke fal ri kakak la turan foron man. ");
INSERT INTO bjp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ke ia ka ongen kinen tikas i tara aragii, ‘Pita, aptih! Siimete ri ke ok ien ri.’ ");
INSERT INTO bjp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Isau le ia ka kiliis u aragii, ‘Kumguui, biil tom! Biil biitom ia ien ta ti tier ae biil i kalkaluu ma i duh na matam.’ ");
INSERT INTO bjp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Isau le kinen tikas tina kukulii, ka tara sabin aragii, ‘Sani God ka fafuu ta u, gong o tara le i duh.’ ");
INSERT INTO bjp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fatuul u e aunbiing i tapiek e tier igii, ke namih, ri ka dat fafis kaen ae ubase na kukulii. ");
INSERT INTO bjp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Na aunbiing masau ae, tuul kaltu ae ri wuun ufu ta rituul tina Sisaria isi iau, rituul ka tapiek na fel ae ia kiis lo. ");
INSERT INTO bjp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Tanwa Kalkaluu ka fas iau isi ian mi lo rituul ma gong ia lala wol. Ke iwon e kaltu igii, ri la sabin turang, kemem tikii keme kau na fel ke Konelius. ");
INSERT INTO bjp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ke Konelius ka fas kemem le i par ta nenge angelo i tapiek na fel kia ke ka fas u aragii, ‘On fawuun una Jopa isi Saimon, nenge asa sabin e Pita. ");
INSERT INTO bjp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","In fas o ini orek ae in faliu wo turan fanu tikii ae na fel kiam.’ ");
INSERT INTO bjp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Aunbiing ia tipes orek, ke Tanwa Kalkaluu ka susuef ulo ri, arae i susuef ta ulo kerer pakanini. ");
INSERT INTO bjp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ke ia ka wolpes sani ae Kumguui i use ta u aragii, ‘Jon i tel ta bapitaiso ini dan, isau le namih, gamen kep bapitaiso ini Tanwa Kalkaluu.’ ");
INSERT INTO bjp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","God i ta itikii sau e matngan fafen usuf ri arae i ta ta u usuf kerer, aunbiing kere unune lo Kumguui Iesu Karisito. Male God i tel ta u arae, ke ia matngan kaltu arafa tom, isi iak tikale foim kia?” ");
INSERT INTO bjp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Aunbiing ri ongen u arae, biil mang ri fapue, isau le ri ka usefages God aragii, “God ka sapeng sabin na sal isi fanu ae biil ri fan Iudaia rin sokiliis liu kiri ma rik kep liu.” ");
INSERT INTO bjp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aunbiing ri ka siimete ta Stiwen, ri ka ta fangungut sabin usuf foron tom unune, ke foron tom unune ri ka sarara una foron male tapak arae Fonisia, Saiprus ke Entiok ke ri ka fafas ini Rokap na Fafas usuf fan Iudaia sau. ");
INSERT INTO bjp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Isau le fale tom unune tina Saiprus ke tina Sairini, ri ka la una Entiok ke ri ka tipes fafas usuf fan Grik sabin ini Rokap na Fafas lo Kumguui Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Rakrakai ke Kumguui i kiis lo ri ma fanu fuun ri ka unune ma ri ka ta liu kiri sing Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Aunbiing foron tom unune na Ierusalem ri ka ongen u, ri ka wuun ufu Barnabas una Entiok. ");
INSERT INTO bjp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Aunbiing i tapiek ma ka par u le imel e fuan famais ke God na liu ken fanu, ka laes ma ka farakrakai ri isi rin tifat tom lo Kumguui ini liu tikii kiri. ");
INSERT INTO bjp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas i nenge rokap na kaltu, i nenge tom unune ma ifuun ini Tanwa Kalkaluu. Ma fanu fuun ri ka ta liu kiri sing Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Namih Barnabas ka la isi im isi Sol na Tarsus. ");
INSERT INTO bjp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Aunbiing ka tafe u, ka telpes u una Entiok. Na nenge bet kuruur, Barnabas ru e Sol ru kiis turim turan foron tom unune na Entiok. Aiwa mang, ri ka tipes foteng berberat na fafausum ini fanu ke Karisito. ");
INSERT INTO bjp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na aunbiing sabin ae, fale profet tina Ierusalem ri la una Entiok. ");
INSERT INTO bjp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Neng lo ri, asa e Agabus, ka soti ke ka use nenge orek ae Tanwa Kalkaluu i fas u ini le, “Nenge tara na taul fitol in tapiek na foron maleh tikii ae ri kiis na piklin nagogon ken matanfuntih tina Rom.” (Tier igii i tapiek na aunbiing ae Klaudius i king na Rom.) ");
INSERT INTO bjp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pesu berberat na fafausum ae ri ka put orek le, temtem tikii lo ri in ta sani sau ae ifasi i ta u, una lupes foron tom unune na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ri ka tel u tom arae ma ri ta foron fafen kiri usuf foron famfamu na lotu ae na Ierusalem, sing Barnabas ru e Sol. ");
INSERT INTO bjp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na aunbiing ae, king Erot ka ta fangungut sing fale tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","I fas foron tom fapaket ke ri ka siimete Jems tualik e Jon ini popok una fapaket. ");
INSERT INTO bjp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Aunbiing i par u le fan Iudaia ri laes ini tier i tel u, ka luse Pita sabin. Tier igii i tapiek na aunbiing na Ngasa na Beret ae biil ti is lo. ");
INSERT INTO bjp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","I luse Pita ke ka fakau u na felun kamkabet ma ka luun u na liman ifet e puis na foron tom fapaket isi rin parpar kale u. Ke nami na Ngasa na Liuliu Kulef, Erot ka ier isi ik fasuuh Pita ma ik nagogon u na matan fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aunbiing Pita i kiis na felun kamkabet, foron tom unune ri sising mulmul tom usuf God isi. ");
INSERT INTO bjp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na wor mang lo isi Erot ik nagogon u, Pita i borong na fatpoton iun tom fapaket, ma ri kabet u ini iwu e sen ke fale tom fapaket sabin ri soti awii na matanfel. ");
INSERT INTO bjp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Fanpil, nenge angelo ke Kumguui ka tipiek, ke nenge malal ka popos na felun kamkabet. Ke angelo ae ka tuk Pita na baba, ka famat u ke ka fas u aragii, “Sangar! Aptih!” Ke iwun sen tina iun lima ka luut uf. ");
INSERT INTO bjp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Namih, angelo ae ka fas u aragii, “Kilkiliis ma ok kau na su kiam.” Ke Pita ka tel u tom arae. Ka fas u sabin aragii, “Kau na dolon kaen kiam ma ok mi lo iau.” ");
INSERT INTO bjp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ka suu nami tina felun kamkabet, isau le biil i usum le matngan sani i tapiek lo, i wol le i nimnibiil sau. ");
INSERT INTO bjp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ru ka liu ufu foron tom parpar kale na matanfel famu ke na fawu u e matanfel, ke ru ka la una tara matanfel ae ri tel u ini aen, ae i suu una maleh. Matanfel ae i sapeng kia tom, ke ru ka suu lo. Aunbiing ru ka tapiek na nenge pasngan sal, ke fanpil angelo ae ka mangmangal koseng u. ");
INSERT INTO bjp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ka pitil e wolwol ke Pita ke ka tarah, “Igii ia ka usum mang le i tekentu tom, Kumguui tom i wuun nenge angelo kia isi in faliu iau tina lima Erot ke koseng foron tier tikii ae fan Iudaia ri wol le rin tel u ulo iau.” ");
INSERT INTO bjp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Aunbiing ka iliim ta u, ka la tinaiwa una fel ke Maria, tina Jon ae nenge asa sabin e Mak. Fanu fuun ri tapiek turim ta aiwa ma ri ka famam sising. ");
INSERT INTO bjp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Aunbiing Pita ka pispisih na matanfel, nenge tah asa e Roda, i nenge fafauun, ka la isi in sapeng. ");
INSERT INTO bjp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Aunbiing i ongen failiim kine Pita, ka lala laes, isau le biil i sapeng pes u, ka filau fis isi fas fanu ae na palgan fel le, “Pita mang ae na matanfel.” ");
INSERT INTO bjp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Fanu ae na palgan fel ri ka tara sing i aragii, “O talos?” Ka lala rakrakai tom le Pita ae na matanfel. Ke ri ka tara sing i aragii, “Angelo kia sangan ae.” ");
INSERT INTO bjp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Isau le Pita ka famam pispisih tom, ma aunbiing ri sapeng na matanfel, ri ka par u ke ri ka lala bitit. ");
INSERT INTO bjp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita ka piispiis ri le rin kiis fofo. Nami ka fas ri arafa God i fasuu ufu arae tina felun kamkabet. Ka fas ri aragii, “Gamen fas Jems turan fale tom unune sabin ini sani ae i tapiek ta lo iau.” Ke ka la koseng ri sabin una nenge maleh keskes. ");
INSERT INTO bjp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na biingbiing, foron tom fapaket ri ka lala bitit ma ri ka wolpane na sani i tapiek lo Pita. ");
INSERT INTO bjp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erot ka fas fanu ma ri ka im rokap isi Pita, isau le biil ri tafe u. Erot ka diikdiik ikis foron tom fapaket ae, ke ka tara le rin siimete ri. Namih, Erot ka la koseng Iudaia una Sisaria ke ka melmel aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erot i balkut ta lon fan Tair ke fan Saidon, pesu ri ka la turim ma ri ka wuun fale fanu isi rin la unaisa. Ri fatala famu bii tura Blastus ae i parpar la na fel ke Erot isi in lupes ri. Namih ri ka la isi diik Erot isi in fatapiek fafis siaroh na fatpoto ri, wara le ri kep inen ari la sau tina maleh ae i kiis na piklin nagogon kia. ");
INSERT INTO bjp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na biing ae Erot i put ta u, ka kilkiliis ini ges ken king ma ka kiis na nian kiiskiis kia ke ka orek usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ke fanu ri ka perek aragii, “Orek ken nenge god igii, biil e orek ken kaltu sau.” ");
INSERT INTO bjp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Fanpil, nenge angelo ke God ka faluut u ini nenge sasem, ma foron sisii ri ka sus u ke ka met, wara le biil i ta ususefages usuf God. ");
INSERT INTO bjp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Isau le orek ke God ka kuumkuum lalala, ma ka sararah. ");
INSERT INTO bjp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aunbiing Barnabas ru e Sol ru ka tel tikii foim kiruh na Ierusalem, ru ka fis una Entiok tura Jon ae nenge asa sabin e Mak. ");
INSERT INTO bjp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na lotu na Entiok, imel e foron profet turan foron tom fafausum arae, Barnabas, Simion ae nenge asa sabin e Niger, Lusius tina Sairini, Sol ke Manaen ae i laumet turim ta tura king Erot. ");
INSERT INTO bjp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Aunbiing ri fafel ma ri ka sisising la unaisa Kumguui, Tanwa Kalkaluu ka fas ri aragii, “Gamen tus pes Barnabas ru e Sol isi run tel foim ae ia ka kam pes ta ru isi.” ");
INSERT INTO bjp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ke aunbiing ri ka fafel ke ri ka sising tikii tah, ri ka luun limri na olruh, ke ri ka wuun ufu ruh. ");
INSERT INTO bjp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tanwa Kalkaluu ka wuun ufu ruh ke ru ka la una kiin na Selusia. Ru ka wof na nenge sip ma ru ka la una bit na Saiprus. ");
INSERT INTO bjp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Aunbiing ru ka tapiek na Salamis, ru ka fafas ini orek ke God na foron felun lotu ken fan Iudaia. Jon sabin tinawii naisruh arae nenge tom falupes kiruh. ");
INSERT INTO bjp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ru la na falifu tikii na bit ae, ke nami ru ka tapiek na nenge maleh ae ri foteng u le Pafos. Aiwa, ru ka tafe nenge sikin Iudaia ae i tom latlat ma i profet famfabal, asa e Bar-Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","I kiis la turan famfamu na matanfuntih na bit ae, asa e Sergius Paulus. Sergius Paulus i nenge kaltu ae imel e rokap na wolwol kia. I fawuun isi Barnabas ru e Sol wara le i ier le in ongen orek ke God. ");
INSERT INTO bjp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Isau le Elimas (na orek Grik le tom latlat) ka totof isi tikale foim kiruh ma ka siingsiing orek na bala famfamu na matanfuntih isi gong i unune lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Isau le, Sol nenge asa sabin e Pol, ifuun ini Tanwa Kalkaluu ma ka kanap fasoksok Elimas ke ka tarah, ");
INSERT INTO bjp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“O kalalik ke Satan, liu kiam ifuun ini sinangun lem ke famfabal, o tuui ken foron tier tikii ae i tortores. Nangis mang on mangeh na falaulau foron tortores na foim ke Kumguui? ");
INSERT INTO bjp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ongen u, igii ngaliaf ke Kumguui in kiis na olom ma ok kut na ti fale aunbiing ma biil ifasi on par malal na pisiih.” Fanpil bau turan kubunor ka afit iun kolson mata, ke ka tipes tamtabam isi tikas in tangne u. ");
INSERT INTO bjp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Aunbiing famfamu na matanfuntih ae ka par sani i tapiek, ka unune, wara le i lala bitit na foron fafausum lo Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol tura uner ae ru la tura, rituul ka wof na sip tina Pafos ke rituul ka la una Perga na falifu na Pamfilia. Aiwa mang, Jon ae nenge asa sabin e Mak, ka la koseng ruh ma ka fis una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pol ru e Barnabas ru ka la tina Perga una Entiok na falifu na Pisidia. Ma na Biingen Mangeh, ru ka kau na felun lotu ken fan Iudaia ke ru ka kiis. ");
INSERT INTO bjp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Aunbiing ri ka wes tikii ta foron nagogon ke Moses turan foron orek ken foron profet, foron famfamu na felun lotu ri ka sotih ke ri ka fas ru aragii, “Iun tualikmem, male imel e orek kimu una farakrakai fanu, ke kamuk use u.” ");
INSERT INTO bjp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol ka sotih ke ka piispiis kale ri ini lima, ke ka tarah, “Fan Israel ke gam ae biil gam fan Israel ae gam lotu la unaisa God, gam ongen iau. ");
INSERT INTO bjp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God ken fan Israel i tim pes ta foron tubutamat kerer ma ka falaumet ta wewes lo ri aunbiing ri kiis ta arae foron ses na Isip, ke ini tara rakrakai kia tom ka lame fasuu ta ri tina Isip. ");
INSERT INTO bjp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Na ifet e sangful e bet aunbiing ri la na falifu foes, taftawa ri tel sinang laulau, isau le biil i to angos na fofonoi lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","I falaulau ifit e mat tina Kenan ke ka ta nanal kiri usuf fanu kia, fan Israel, isi kiri mang. ");
INSERT INTO bjp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Foron tier tikii igii i tapiek na palgan ifet e mar ini ilim e sangful e bet. Namih, God ka ta foron famfamu usuf ri papang na aunbiing ke profet Samuel. ");
INSERT INTO bjp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ke aunbiing ri ka diik isi ti king kiri, God ka ta Sol kalalik ke Kis arae king kiri tina mat ke Beniamin, ma ka kiis arae king na ifet e sangful e bet. ");
INSERT INTO bjp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Isau le God ka kiliis ufu Sol ke ka fakiis Dewit arae king ke ka tarah, ‘Ia ka im tafe ta Dewit kalalik ke Jesi, ma i e kaltu ae i kiis na eteng, in tel foron tier tikii ae ia ier le in tel u.’ ");
INSERT INTO bjp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Tubutamat e Dewit, ae God i falimlim ta usuf fan Israel le in wuun ufu, igii ka tapiek tah, i e Iesu, Tom Fafaliu. ");
INSERT INTO bjp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Aunbiing Iesu biil biitom i tipes tel foim kia, Jon Tom tel Bapitaiso ka fafas usuf fan Israel tikii le, rin sokiliis liu kiri ma rik kep bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Aunbiing Jon fatat in farop foim kia, ka diik fanu aragii, ‘Gam wol le iau e seh? Ia biil e ier ae gam nene isi, isau le ier ae in mi pes iau, biil ia tortores isi ifasi ian puk ufu su kia.’ ");
INSERT INTO bjp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Foron tuaklik, berberat ke Abaram ke gam ae biil gam fan Iudaia ma gam unune lo God, orek igii God i tule ufu ta una faliu kerer. ");
INSERT INTO bjp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Fanu na Ierusalem turan foron tom nagogon kiri biil ri iliim ta Iesu ke orek ken foron profet, ae ri wes u la na foron Biingen Mangeh tikii. Isau le ri ka fasuut u tom e orek ae, aunbiing ri somangat isi rin siimete u. ");
INSERT INTO bjp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Biil ri im tafe ti rokap na wara isi ik fiu kuna, isau le ri ka diik Pailat tom isi in siimete u. ");
INSERT INTO bjp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Aunbiing ri ka fasuut tikii ta foron orek ae foron profet ri use ta u ulo, ri ka fapu u tina aupaket ke ri ka luun u na matanfat una luun minet. ");
INSERT INTO bjp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Isau le God ka fapti fafis u, ");
INSERT INTO bjp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ma na ifuun e biing i tapiek sing fanu ae ri la ta tura tina Galili una Ierusalem, ma igii ri ka famalal u usuf fanu kirer. ");
INSERT INTO bjp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Keme fas gam ini Rokap na Fafas. Tier ae God i falimlim ta ini usuf foron tubutamat kerer, ");
INSERT INTO bjp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ka fasuut ta u usuf kerer berberat kiri, aunbiing i fapti fafis Iesu. Na fawu e seksek ae na Buk Seksek ri siit ta u aragii, ‘O keng kalalik, ma igii ia ka tapiek Tamam.’ ");
INSERT INTO bjp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God i fapti fafis ta Iesu ma biil i par ufu isi in mapuh. God i use ta u aragii, ‘Tekentu kanaka, ian ta kalkaluu na fafakalok usuf gam, ae pakanini ia falimlim ta ini usuf Dewit.’ ");
INSERT INTO bjp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ri siit u sabin na Buk na Gogoh aragii, ‘Biil on par ufu pununfo Kaltu Kalkaluu kiam ik mapuh.’ ");
INSERT INTO bjp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dewit i misuut ta na wol ke God, aunbiing i liu. Namih, ka met, ke ri ka ile u turan foron tubutamat ke pununfo ka mapuh. ");
INSERT INTO bjp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Isau le ier ae God i fapti fafis ta u, pununfo biil i to mapuh. ");
INSERT INTO bjp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Pesu, foron tuaklik, fafas kiak i aragii, ia ier isi gamen usum le, iwara sau lo Iesu, ke God ka pa ufu foron sinang laulau kimi. ");
INSERT INTO bjp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nagogon ke Moses biil ifasi in tel gam isi gamek tortores na mata God, biil. Fanu sau ae ri unune lo Iesu, God i foteng ri le ri foron tom tortores. ");
INSERT INTO bjp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gamen tumarang, tarama foron orek ken foron profet ka suut ulo gam. Ri use ta u aragii: ");
INSERT INTO bjp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ongen u, gam ae gam orek kamgas, gamen bitit ke gamek fiu, wara le na foron bet ae gamen liu lo, ian tel nenge tier. Male tikas in fas gam ini, ke biil tom ifasi gamen unune lo.’” ");
INSERT INTO bjp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aunbiing Pol ru e Barnabas ru ier isi suu tina felun lotu, fanu aiwa ri ka sising ru le run kiis fis isi ruk fafas biitom ini foron tier ae, na nenge Biingen Mangeh sabin. ");
INSERT INTO bjp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Aunbiing ri ka suu ta tina felun lotu, ifuun e fan Iudaia turan fale fanu ae ri somangat pes matngan fafausum ken fan Iudaia ri ka mi lo Pol ru e Barnabas, ke ru ka farakrakai ri isi rin tifat tom na famais ke God. ");
INSERT INTO bjp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na nenge Biingen Mangeh sabin, fatat arae fanu tikii tina maleh ae ri ka la turim isi ongen orek ke Kumguui sing Pol ru e Barnabas. ");
INSERT INTO bjp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Aunbiing fan Iudaia ri ka par tara gur na fanu ae, balri ka laulau ke ri ka tipes use falaulau foron tier tikii ae Pol i use u. ");
INSERT INTO bjp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol ru e Barnabas ru kep balamas tom ma ru ka kiliis ri aragii, “I tekentu le kaman fas famu gam ta bii ini orek ke God, isau le biil gam somangat pes u. I par aragii le biil gam ier isi kep liu fitliu, pesu, kama ka tamikis usuf fanu ae biil ri fan Iudaia ke kama ka fas ri ini orek ke God. ");
INSERT INTO bjp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Wara le Kumguui i fas kama ini nenge rakrakai na orek aragii, ‘Ia tus pes ta wo arae malal ken fanu ae biil ri fan Iudaia, isi ok finngas fanu tikii na piklinbat ini sal una kep liu.’” ");
INSERT INTO bjp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Aunbiing fanu ae biil ri fan Iudaia ri ka ongen orek igii, ri ka lala laes ke ri ka use fages Kumguui isi orek kia. Ke fal ae God ka tim pes ta ri isi rin kep liu fitliu, ri ka tapiek foron tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ke orek ke Kumguui ka sarara na falifu tikii ae. ");
INSERT INTO bjp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Isau le fan Iudaia ri ka siingsiing orek na balan kelefin na lotu ae fanu ri bulat la lo ri turan fanu tamat ae ri famfamu na maleh ae. Ri ka fatel fanu isi ta fangungut sing Pol ru e Barnabas ke ri ka fes ufu ru tina falifu kiri. ");
INSERT INTO bjp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pesu, ru ka pakte ufu piyiif tina kekruh isi ik arae fakileng usuf ri le ri kiis na palgan ngaliaf ke God, ke ru ka la una Aikonium. ");
INSERT INTO bjp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Isau le foron tom unune ri ka fuun ini laes ke ini Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na Aikonium Pol ru e Barnabas ru ka kau na felun lotu ken fan Iudaia, arae tom ru tel u la. Aiwa, ru ka fafas, ma orek kiruh ka fapti balan ifuun e fan Iudaia turan fanu ae biil ri fan Iudaia, ma ri ka unune. ");
INSERT INTO bjp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Isau le fale fan Iudaia ae biil ri unune, ri ka siingsiing orek na balan fanu ae biil ri fan Iudaia ke ri ka fatel wolwol kiri isi rik ememse foron tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pol ru e Barnabas ru kiis pes dolon aunbiing tom aiwa, ma biil ru binbin isi fafas ini famais ke Kumguui. Kumguui tom i fatekentu u, aunbiing i ta rakrakai sing ru una fatapiek foron fakileng ke foron tier an fabitit. ");
INSERT INTO bjp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Isau le fanu na maleh ae ri ka tampaek ma ka u lo ri, fal ri mi lon fan Iudaia ke fal ri ka mi lon iun aposel. ");
INSERT INTO bjp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Fanu ae biil ri fan Iudaia ke fan Iudaia turan foron laulaumet kiri, ri ka ier isi rin falaulau ruh ma rik luumete ruh. ");
INSERT INTO bjp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Isau le ru ka usum, ke ru ka fin una Listra ke Derbe na falifu na Likonia ke una foron maleh fatat. ");
INSERT INTO bjp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Aiwa na foron maleh ae, ru ka famam fafas tom ini Rokap na Fafas. ");
INSERT INTO bjp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Awii na maleh na Listra, imel e nenge kaltu i pang ma ka peo tah ma biil ifasi in la. ");
INSERT INTO bjp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Aunbiing Pol i fafas, kaltu ae i kiis tah ma ka ongen u. Pol ka par tortores usuf i ke ka iliim u le imel e unune kia le in liu. ");
INSERT INTO bjp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ke ka perek aragii, “Aptih!” Kaltu ae ka ongen u, ka sirok ma ka tipes la. ");
INSERT INTO bjp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Aunbiing gur na fanu ae ri ka par tier ae Pol i fatapiek ta u, ri ka perek ini orek kiri tom, fan Likonia aragii, “Iun god ru tapiek arae iun kaltu toh ma ru ka pu unaisrer.” ");
INSERT INTO bjp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ri foteng Barnabas ini Jus, ke Pol ini Ermes, wara le i tom ororekmet. ");
INSERT INTO bjp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Felun sising ken fanu ae ri lotu la usuf god Jus i fatat sau isi ubiif kale maleh ae. Pris tinaiwa turan gur na fanu ri ka kep foron bulmakau tamat turan foron sian au ae ri tu turim ta u arae kutkute, ke ri ka la unawii na matan ubiif na maleh ae isi rin tel tunmapek usuf Barnabas ru e Pol. ");
INSERT INTO bjp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Isau le aunbiing iun aposel ae, Barnabas ru e Pol, ru ka ongen u, ru ka rages foron kilkiliis kiruh ke ru ka filau suu na fatpoton gur na fanu ma ru ka perek aragii, ");
INSERT INTO bjp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Fanu ri, isi sani gam ka tel u arae? Kama sabin, kama kaltu sau arae gam. Kama la sau isi fas gam ini Rokap na Fafas isi gamek fin koseng foron matngan tier igii ae biil ti kamtina ma isi gamek tamikis usuf God ae i liu ma i fakiis ta kukulii, piklinbat ke palgantes turan foron tier tikii ae lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Na foron ulul pakanini, i sok ufu ta foron mat tikii isi mi na foron sinangu ri tom. ");
INSERT INTO bjp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Isau le biil i sok ufu gam foes ta sau isi biil mang gamen usum lo. I finngas foron rokap na sinang tom usuf gam aunbiing i ta us tinbae na kukulii ke foron au ri ka fua na foron taul fua kiri. I fen gam ini ifuun e inen ke ka fafuun balmi ini laes.” ");
INSERT INTO bjp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ru orek arae usuf fanu, isau le ri ngongos isi tel tunmapek usuf ruh. Pesu ru ka rakrakai tom isi tikale ri. ");
INSERT INTO bjp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Namih, fale fan Iudaia ri ka la tina Entiok ke tina Aikonium ke ri ka siingsiing orek na balan gur na fanu ae isi gong ri mi na orek ke Pol ruh. Ri ka luuluu Pol ke ri ka dat fasuu u tina maleh ae, wara ri wol le ka met tah. ");
INSERT INTO bjp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Isau le aunbiing foron tom unune ri ka ti kawil u, ka aptih ke ka fis sabin una maleh ae. Ma na biing namih, ru e Barnabas ru ka la una Derbe. ");
INSERT INTO bjp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Aunbiing Pol ru e Barnabas ru ka fafas ini Rokap na Fafas na Derbe, fanu fuun ri ka tapiek berberat na fafausum. Namih, Pol ru ka fis una Listra, Aikonium ke una Entiok. ");
INSERT INTO bjp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ma ru ka farakrakai berberat na fafausum isi rin tifat ini tekentu na unune ke ru ka tarah, “Keren kalsakai in fuun e tatawin tom isi kerek kau na matanfuntih ke God.” ");
INSERT INTO bjp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ke ru ka tim pes fale fanu isi rin tapiek foron famfamu ken foron tom unune na temtem tikii na maleh ae. Ru sising ke ru ka fafel ma ru ka ta foron famfamu ae usuf Kumguui ae ri luun unune kiri lo. ");
INSERT INTO bjp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Na ninla kiruh, ru soleng falifu na Pisidia, ke ru ka tapiek na falifu na Pamfilia. ");
INSERT INTO bjp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ke aunbiing ru ka fafas ta ini Rokap na Fafas na Perga, ru ka pu una Atalia. ");
INSERT INTO bjp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ru ka wof na sip aiwa ke ru ka fis una Entiok, na maleh ae foron tom unune ri luun ta ru na piklin famais ke God, isi tel foim ae igii mang ru ka farop u. ");
INSERT INTO bjp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Aunbiing ru tapiek aiwa, ru ka kam turim foron tom unune tikii ke ru ka fas ri ini foron tier tikii ae ru ka tel ta u na falupes ke God, ma arafa God i sapeng na sal arae isi fanu ae biil ri fan Iudaia ri ka unune. ");
INSERT INTO bjp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ru melmel pes dolon aunbiing tom aiwa turan foron tom unune na Entiok. ");
INSERT INTO bjp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Aunbiing Pol ru e Barnabas ru tinawii na Entiok, fale fanu ri ka la tina Iudaia ke ri ka famam fausum foron tom unune aragii, “Male biil gam kiit pununfo gam namin nagogon ae Moses i fafausum ta ini, ke biil tom ifasi gamen kep liu.” ");
INSERT INTO bjp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Foron orek ae, ka fatel Pol ru e Barnabas, ru ka lala fapue tura ri. Namih foron tom unune ri ka tus pes Pol ru e Barnabas turan fale tom unune sabin isi rin la una Ierusalem ma rik par foron aposel turan foron famfamu ma rik diik ri isi orek ae ri ongen ta u. ");
INSERT INTO bjp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Foron tom unune ri ka wuun ufu ri, ma aunbiing ri ka soleng falifu na Fonisia ke Samaria, ri ka fas foron tom unune ae le, fanu sabin ae biil ri fan Iudaia, ri ka kiliis liu mang kiri. Aunbiing ri ka ongen u, ri ka lala laes. ");
INSERT INTO bjp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Aunbiing ri tapiek na Ierusalem, foron tom unune turan foron aposel ke foron famfamu ri ka somangat pes ri. Ri ka fas fanu tikii ini foron tier tikii ae ru ka tel ta u na falupes ke God. ");
INSERT INTO bjp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Isau le fale tom unune tina baba ken foron Farasi, ri ka sotih ke ri ka tara aragii, “Foron tom unune ae biil ri fan Iudaia, rin kiit pununfo ri tom ma rik mi na nagogon ke Moses.” ");
INSERT INTO bjp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Foron aposel turan foron famfamu ri ka kiis turim isi ngurke orek ae. ");
INSERT INTO bjp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ri ka lala orek tah, nami Pita ka sotih ke ka tarah, “Foron tualik, gam usum le pakanini tom God i tim pes ta iau tina fatpoto gam isi fafas ini Rokap na Fafas usuf fanu ae biil ri fan Iudaia, isi rik ongen u ma rik unune. ");
INSERT INTO bjp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","God i usum na balan fanu tikii, ka finngas u le i somangat pes ri, aunbiing i ta Tanwa Kalkaluu usuf ri, arae sau i ta ta u usuf kerer. ");
INSERT INTO bjp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sinangu God usuf kerer, ifasi sau arae sinangu God usuf ri, wara le ka fafuu ta balri, aunbiing ri unune. ");
INSERT INTO bjp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ma igii, isi sani gam ka ier isi tof God? Gong gam kep au na olon berberat na fafausum. Kere tom turan foron tubutamat kerer biil ifasi keren ngar u. ");
INSERT INTO bjp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Isau le kere unune le kere tikii kere kep fafaliu na itikii sau e matngan sal, kere kep fafaliu sau na famais ke Iesu, Kumguui kirer.” ");
INSERT INTO bjp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Fanu tikii ae ri kiis turim ta biil ti tenge ri, aunbiing Barnabas ru e Pol ru fas ri ini foron fakileng ke foron tier an fabitit ae God i fatapiek ta u na limruh na fatpoton fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aunbiing ru ka use ta u arae, Jems ka sotih ke ka tarah, “Foron tuaklik, gam ongen iau. ");
INSERT INTO bjp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon ka fas ta kerer arafa God i finngas famu ta famais kia arae usuf fale fanu ae biil ri fan Iudaia, aunbiing i fule pes ta ri isi rik tapiek arae fanu tutus kia tom. ");
INSERT INTO bjp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Orek ken foron profet i somangat ini tier igii, arae tom ri siit ta u na Buk na Gogoh le: ");
INSERT INTO bjp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Namih, ian fis ke iak tel fafis fel ke Dewit ae i luut tah. Foron iri ae i laulau tah, ian fapti fafis u, ke iak tumarnge u, ");
INSERT INTO bjp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","isi fale fanu keskes, ae biil ri fan Iudaia, rik im isi Kumguui, ri ae ia ka kam pes ta ri le ri kiak. Orek igii ke Kumguui, ae pakanini tom i use ta u le foron tier igii in tapiek.’ ");
INSERT INTO bjp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Pesu, na wolwol kiak le, gong kere tel u isi ik ngangaten kanaka usuf fanu ae biil ri fan Iudaia, ae ri ka ta ta liu kiri usuf God. ");
INSERT INTO bjp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Isau le keren sisiit usuf ri ma kerek fas ri le, gong ri ien foron inen ae ri ta ta u arae fafen usuf foron god famfabal, gong ri tel sinangun tamfaes, ke gong ri ien pinsan foron muruuw ae ri bing mete u, ke gong ri ien dah na foron muruuw. ");
INSERT INTO bjp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","I wara le, tinpakanini tom, ri fafas la ini nagogon ke Moses na foron maleh tikii, ma na foron Biingen Mangeh tikii, ri ka wes u la na foron felun lotu.” ");
INSERT INTO bjp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Namih, foron aposel turan foron famfamu ke fanu tikii na lotu ri ka wol le rin tus pes ti fale fanu lo ri tom, isi rik wuun ri tura Pol ru e Barnabas una Entiok. Ri ka tus pes Iudas, nenge asa sabin e Barsabas, ke Sailas ae foron tom unune ri bulat la lo ruh. ");
INSERT INTO bjp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ma leta ae ru kep u, i aragii: Igii e leta sing foron aposel ke foron famfamu na lotu na Ierusalem, kemem foron tualik gam. Keme sisiit usuf gam ae biil gam fan Iudaia ae gam kiis na maleh na Entiok, Siria ke Silisia. Famais kimem usuf gam. ");
INSERT INTO bjp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Keme ka ongen ta u le, fale fanu ri la tinaga na aismem, isau le kemem tom biil keme wuun ta ri. Ri la ma ri ka falaulau ta unune kimi ma ri ka fapul gam ini foron fafausum kiri. ");
INSERT INTO bjp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kemem tikii, keme somangat le kemen tus iwu lo kemem isi kemek wuun ru usuf gam tura Barnabas ru e Pol. Barnabas ru e Pol ru iun rokap na talmem, ");
INSERT INTO bjp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ae ru lin liu kiru tom na tel foim igii, iwara na asa Kumguui kirer, Iesu Karisito. ");
INSERT INTO bjp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pesu, keme ka wuun ufu Iudas ru e Sailas, isi ruk fasuut u tom ini ngusruh e foron tier igii keme siit u usuf gam. ");
INSERT INTO bjp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tanwa Kalkaluu i kiis tura kemem ke keme ka somangat tikii le, gong keme ta ti fale tatawin sabin usuf gam. Igii sau e fale tier gamen mi lo: ");
INSERT INTO bjp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gong gam ien inen ae ri ta ta u arae fafen usuf foron god famfabal, gong gam ien dah na foron muruuw, gong gam ien pinsan foron muruuw ae ri bing mete u ke gong sabin gam tel sinangun tamfaes. Gong gam tel foron sinang aragii, isi kiis kimi ik rokap. Famais kimem usuf gam. ");
INSERT INTO bjp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ri ka wuun ufu ri, ke ri ka la una Entiok. Ma aiwa, ri ka tel turim foron tom unune ke ri ka ta leta usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Fanu ri ka wes leta ae, ke ri ka lala laes aunbiing ri ongen foron orek ae i farakrakai ri. ");
INSERT INTO bjp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iudas ru e Sailas, ru turim ru iun profet, pesu ru ka ta ifuun e rokap na orek una fanau ri ma una farakrakai unune ken foron tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ru ka kiis pes fale biing aiwa tura ri, ke nami foron tom unune aiwa ri ka wuun fafis ru ini siaroh, unaisan fanu ae ri wuun ta ruh. ");
INSERT INTO bjp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Isau le Pol ru e Barnabas tinaiwa biitom na Entiok. Ru turan fanu fuun ri ka fausum fanu ke ri ka fafas ini orek ke Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Fale aunbiing namih, Pol ka fas Barnabas aragii, “Karak fis bii isi karak laum foron tualikrah na foron maleh ae kara ka fafas ta ini orek ke Kumguui lo, isi karak par ri le ri rokap biitom, le biil.” ");
INSERT INTO bjp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ka somangat e Barnabas, ke ka ier sabin le in telpes Jon ae nenge asa sabin e Mak tura ruh. ");
INSERT INTO bjp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Isau le Pol biil i somangat pes u, wara le Mak i fin koseng ta ru na Pamfilia ma biil i to la ta tura ru isi tel foim. ");
INSERT INTO bjp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pol ru e Barnabas ru ka fakep ini orek ke ru ka sararah. Barnabas ka tel pes Mak, ke ru ka wof na sip una bit na Saiprus. ");
INSERT INTO bjp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Isau le Pol ka tim pes Sailas ke ru ka la. Ma aunbiing ru ka ier isi la, foron tom unune ri ka sising isi famais ke Kumguui in kiis naisruh. ");
INSERT INTO bjp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ru ka la na foron maleh tikii na falifu na Siria ke na Silisia, ma Pol ka farakrakai foron tom unune. ");
INSERT INTO bjp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ru e Sailas ru la famu una Derbe ke nami una Listra. Aiwa imel e nenge kalalik na fafausum asa e Timoti. Tina i nenge fafnan Iudaia ma i nenge tom unune sabin, isau le tama i nenge sikin Grik. ");
INSERT INTO bjp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Foron tom unune na Listra ke na Aikonium ri use u le Timoti i e nenge rokap na kaltu. ");
INSERT INTO bjp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ka ier le in telpes u tura ruh, pesu ka kiit famu pununfo Timoti, i wara lon fan Iudaia ae ri kiis na falifu ae, wara ri usum le tama i nenge sikin Grik. ");
INSERT INTO bjp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aunbiing rituul ka la na foron maleh tikii, Pol ka tata na foron leta ae foron aposel turan foron famfamu na lotu na Ierusalem ri siit ufu ta isi fanu rin mi lo. ");
INSERT INTO bjp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ke unune ken foron tom unune na foron maleh tikii ka tapiek rakrakai, ma foron biing tikii, wewes lon foron tom unune, ka laumet lalala. ");
INSERT INTO bjp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol turan iun tala rituul ka soleng falifu na Frigia ke Galatia, wara le Tanwa Kalkaluu i tikale Pol le gong i fafas ini Rokap na Fafas na falifu na Eisia. ");
INSERT INTO bjp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Aunbiing rituul ka tapiek na nanal na Misia, rituul ka totof isi rituulen kau na falifu na Bitinia, isau le Tanwa Iesu biil i somangat ufu rituul. ");
INSERT INTO bjp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pesu rituul ka liu ufu Misia ke rituul ka pu una Troas. ");
INSERT INTO bjp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Na wor, Pol ka par nenge parpar. I par nenge kaltu tina Masedonia i soti ma ka famam sising u aragii, “La uga na Masedonia ma ok lupes kemem.” ");
INSERT INTO bjp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Aunbiing Pol ka par tikii ta parpar ae, fanpil, keme ka geges ma keme ka la una Masedonia, wara keme usum le God tom i kam kemem isi kemen fafas ini Rokap na Fafas usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Keme ka wof na sip na Troas ma keme ka filau tortores una Samotres. Ma na biing namih, keme ka masah na Neapolis. ");
INSERT INTO bjp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tinaiwa, keme ka tapiek na Filipai. Filipai i nenge maleh ae fan Rom ri fuun lo ma i e nenge tara maleh na falifu na Masedonia, ma keme ka melmel aiwa na fale biing. ");
INSERT INTO bjp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na Biingen Mangeh, keme ka suuh tina palgan ubiif kale maleh ae una baban dan, wara keme wol le imel e salan la turim isi sising ken fan Iudaia aiwa. Keme ka kiis ke keme ka tipes orek usuf kelefin ae ri la turim ta aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Neng lon kelefin ae, asa e Lidia. I sufii foron kaen melmelek la pes pitkalang. Lidia i tina maleh na Taiatira ma i lotu la unaisa God. Aunbiing ka ongen kemem, Kumguui ka sapeng na bala ke ka somangat pes fafas ke Pol. ");
INSERT INTO bjp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aunbiing i turan fanu ae na fel kia ri ka kep ta bapitaiso, ka sising kemem aragii, “Male gam wol le ia unune tekentu lo Kumguui, ke gamek la isi melmel na fel kiak.” Ka ngongos tom, papang na aunbiing keme ka somangat. ");
INSERT INTO bjp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nenge biing, aunbiing keme la una falifu ae ri sising la lo, keme ka tafe nenge tah. I nenge fafauun ma imel e tanwa laulau lo ma i use famu foron tier la ae in tapiek namih. I tel ifuun la e pitkalang ken fanu ae i foim la sing ri. ");
INSERT INTO bjp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tah ae ka mimi la lo Pol tura kemem ke ka famam tautau aragii, “Fanu igii ri foron fafauun ke God ae i Buuii kanaka na Mawe ma ri ka tapiek aga isi fas gam ini sal una kep liu.” ");
INSERT INTO bjp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ifuun tom e biing, fifin ae i tara la arae, pesu Pol ka kut mang e bala. Ka giliim fis ma ka fas tanwa laulau ae aragii, “Na asa Iesu Karisito, ia fas o: Suu koseng fifin ae!” Fanpil, tanwa laulau ae, ka suuh koseng u. ");
INSERT INTO bjp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Aunbiing foron laulaumet ken tah ae ri ka usum le biil mang ifasi in fatapiek ti pitkalang, ri ka luse Pol ru e Sailas ke ri ka dat ru una salan la turim ken fanu, isi ruk ti na matan foron famfamu. ");
INSERT INTO bjp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ri ka lame ru una matan foron tom nagogon ke ri ka tarah, “Uner igii ru sikin Iudaia, ru tel maleh kirer ka rigorigo. ");
INSERT INTO bjp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ru fausum fanu ini matngan sinangu ri, ae biil i tortores le kerer fan Rom keren somangat pes u ke kerek mi lo.” ");
INSERT INTO bjp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gur na fanu ae ri ka la turim isi paket Pol ru e Sailas. Ke foron tom nagogon tina maleh ae ri ka tara le rin kasis ufu foron kilkiliis kiruh ma rik pis ruh. ");
INSERT INTO bjp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ri ka pis falaulau ta ruh ke ri ka lin fakau ru na felun kamkabet ma ri ka fas tom parpar kaleh isi in parpar rokap lo ruh, tarama ru ka fin. ");
INSERT INTO bjp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aunbiing i ongen matngan orek arae, ka fakau sikit ru una palga tutus e felun kamkabet ae, ke ka kabet foron kekruh una foron kiptin au. ");
INSERT INTO bjp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na fapot, Pol ru e Sailas ru ka famam sising ke ru ka sek foron seksek usuf God, ma fale fanu sabin ae ri kamkabet, ri ka ongen ruh. ");
INSERT INTO bjp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Fanpil, nenge tara gih ka tapiek, ma foron tuh tikii na felun kamkabet ka nut. Foron matanfel tikii na felun kamkabet ka sapeng, ke foron sen lon fanu tikii ae ri kamkabet ka tampupuk. ");
INSERT INTO bjp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tom parpar kale felun kamkabet ae ka mat ma ka par foron matanfel tikii ri sapeng. Ka fut pes popok una fapaket kia ke ka ier le in siimete fafis u tom, wara i wol le fanu tikii ae ri kamkabet ri ka fin tah. ");
INSERT INTO bjp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Isau le Pol ka perek aragii, “Gong o falaulau fafis o! Kemem tikii igii tom.” ");
INSERT INTO bjp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kaltu ae ka tautau isi ti lam, ka filau ke ka nananar ini sokeh ma ka luut uf na mata Pol ru e Sailas. ");
INSERT INTO bjp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ka lame fasuu ruh ke ka diik ru aragii, “Uner, sani ian tel u, isi God ik faliu iau?” ");
INSERT INTO bjp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ru ka kiliis u aragii, “On unune lo Kumguui Iesu, isi God ik faliu o, wo turan fanu tikii na fel kiam.” ");
INSERT INTO bjp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Namih, ru ka fafas ini orek ke Kumguui usuf i turan fanu tikii ae na matanfel kia. ");
INSERT INTO bjp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Na aunbiing tom ae na fapot, tom parpar kaleh na felun kamkabet ka tel pes ruh ke ka gorse foron lot kiruh. Ma na aunbiing tom ae, ru ka baptais u turan fanu tikii na matanfel kia. ");
INSERT INTO bjp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ka fakau ru una fel kia ke ka tel inen aruh. Liu kia ifuun ini laes, wara le i turan fanu tikii na matanfel kia ri ka unune mang lo God. ");
INSERT INTO bjp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Na biingbiing, foron tom nagogon ri ka wuun foron tom foim kiri usuf tom parpar kale felun kamkabet ini orek aragii, “Puk ufu uner ae.” ");
INSERT INTO bjp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tom parpar kale felun kamkabet ka fas Pol aragii, “Foron tom nagogon ri tara le ian puk ufu kamu e Sailas. Kamu suu mang ma kamuk la ini siaroh.” ");
INSERT INTO bjp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Isau le Pol ka fas foron tom foim ae aragii, “Kama iun sikin Rom ma ri piis ta kamah na matan fanu tikii, biil ri ongen fakasi ta foron orek kimah ma ri ka lin fakau ta kama una felun kamkabet. Biil rin wuun fakum ufu kama sau, biil. Ri tom rin la ma rik lame fasuu kama tinaga.” ");
INSERT INTO bjp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Foron tom foim ri ka fas foron tom nagogon ini orek ke Pol, ma aunbiing ri ka ongen u le Pol ru e Sailas ru iun sikin Rom, ri ka sokeh. ");
INSERT INTO bjp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Pesu ri la ke ri ka fot kiskam sing ruh. Ke ri ka lame fasuu ru tina felun kamkabet ma ri ka sising ru isi run la koseng maleh kiri. ");
INSERT INTO bjp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aunbiing Pol ru e Sailas ru ka suu ta tina felun kamkabet, ru ka la una fel ke Lidia ke ru ka fatafe turan foron tom unune ma ru ka farakrakai ri. Namih, ru ka la koseng ri. ");
INSERT INTO bjp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Aunbiing Pol ru e Sailas ru ka soleng ta maleh na Amfipolis ke Apolonia, ru ka tapiek na Tesalonika ma aiwa, imel e felun lotu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Arae tom Pol i tel u la, ka kau na felun lotu ma ituul e Biingen Mangeh, ka ngurke foron orek ae na Buk na Gogoh turan fanu. ");
INSERT INTO bjp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ka famalal ri ke ka fas ri le Buk na Gogoh i tara le Mesaia in kalsakai fangungut tom, ke ik apti fis. Ke ka fas ri sabin aragii, “Iesu ae ia fas gam ini, i e Mesaia.” ");
INSERT INTO bjp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Fale fan Iudaia ae ri ongen orek ke Pol ru e Sailas, ri ka unune ke ri ka mi lo ru turan ifuun e fan Grik ae ri lotu la unaisa God ke almin kelefin sabin ae asri i laumet. ");
INSERT INTO bjp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Isau le fale fan Iudaia ka laulau e balri lo Pol ru e Sailas, pesu, ri ka la una salan la turim ken fanu. Ri ka lame turim foron toltol na fanu ma ri ka tel maleh ae ka rigorigo. Ri ka la una fel ke Jeisen ma ri ka im isi Pol ru e Sailas, wara ri ier le rin dat fasuu ru usuf fanu. ");
INSERT INTO bjp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Isau le aunbiing biil mang ri im tafe ruh, ri ka dat pes Jeisen turan fale tom unune usuf foron famfamu na maleh ae ma ri ka perek aragii, “Uner ae ru fatapiek tatawin la na marmarsan maleh, ru mang ta igii. ");
INSERT INTO bjp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jeisen ka somangat pes ta ru una fel kia ma igii, ri tikii ri ka lek ta nagogon ke Sisar, wara ri use u la le, imel e nenge king sabin ae ri foteng u le Iesu.” ");
INSERT INTO bjp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ka rigorigo e maleh ini gur na fanu ae turan foron famfamu tina maleh ae aunbiing ri ongen orek igii. ");
INSERT INTO bjp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ke foron famfamu ri ka fas Jeisen turan fale tom unune sabin isi rin ta pitkalang una fiil ufu ri isi gong ri kamkabet, nami rik sok ufu ri. ");
INSERT INTO bjp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Na wor tom ae, foron tom unune ri ka wuun ufu Pol ru e Sailas una Berea. Aunbiing ru ka tapiek aiwa, ru ka kau na felun lotu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Fan Iudaia ae ri kiis na Berea, sinangu ri i rokap kanaka lon fan Iudaia ae na Tesalonika. Ri somangat pes fafas ke Pol, wara ri ier kanaka isi ongen u. Foron biing tikii ri wes foron orek la ae na Buk na Gogoh isi rik par u le orek ke Pol i tekentu le biil. ");
INSERT INTO bjp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ifuun e fan Iudaia ri ka unune ma ifuun sabin e kelefin tina Grik ae asri i laumet turan almin fanu tamat tina Grik ri ka unune. ");
INSERT INTO bjp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Aunbiing fan Iudaia ae na Tesalonika ri ongen u le Pol ka fafas ini orek ke God na Berea, ri ka la sabin unaiwa, ke ri ka siingsiing orek na balan fanu ma wolwol kiri ka rigorigo. ");
INSERT INTO bjp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Fanpil ke foron tom unune aiwa ri ka wuun Pol una kiin, isau le Sailas ru e Timoti ru tom tinaiwa na Berea. ");
INSERT INTO bjp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Fanu ae ri filange ta Pol una Atens, ri ka fis ini orek ke Pol usuf Sailas ru e Timoti le, run sangar sape nami. ");
INSERT INTO bjp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Aunbiing Pol i famam nene Sailas ru e Timoti na Atens, ka purngis e bala aunbiing i par ifuun e tantanwan foron god famfabal na maleh ae. ");
INSERT INTO bjp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pesu ka la una felun lotu ke ka orek turan fan Iudaia ke turan fale fan Grik sabin ae ri lotu la unaisa God. Ma na foron biing tikii, i la la una salan la turim ken fanu ke ka faorek fanse ae ri tapiek la aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Iwu e uh na foron tom tasum tinaiwa, neng ri foteng ri ini Epikurian ke neng ini Stoik, ri ka tipes fakep ini orek tura Pol. Fal lo ri, ri tara le, “Tom orek foes igii, sani i ier isi use u?” Fal ri ka tarah, “I famam fafas ini foron god tina fale maleh keskes.” Ri use u arae, wara le Pol i fafas ini Rokap na Fafas lo Iesu ke ini apaptifis. ");
INSERT INTO bjp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ri ka lame pes Pol una pungpung na Areopagus ae foron tom tasum ri kiis turim la wah ke ri ka fas u aragii, “Keme ier le on fas kemem ini foron fafausum ae o fafas la ini. ");
INSERT INTO bjp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wara le o use fale tier ae i fuuh una wongwong kimem, pesu keme ka ier isi usum na kamtinan foron orek kiam.” ");
INSERT INTO bjp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Fanu tikii na Atens turan foron ses ae ri melmel la aiwa, biil ri tel ti tier la, ri muduung la sau na ongen foron orek fuuh ma ri ka ngurke u la. ");
INSERT INTO bjp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pol ka ti na fatpoton foron tom tasum ae, ke ka tarah, “Fan Atens, ia par u le na foron tier tikii gam tel u, gam mi kanaka na sinangun lotu. ");
INSERT INTO bjp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Aunbiing ia soleng maleh kimi, ia par foron tier ae gam lotu la unaisri ma nenge salan tunmapek ia par u, imel e sisiit lo i aragii: USUF NENGE GOD AE BIIL KERE USUM LO. God ae gam lotu unaisa, ma biil gam usum lo, igii ian fas gam ini. ");
INSERT INTO bjp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“I e God ae i tel ta piklinbat turan foron tier tikii lo, i e Kumguui tina kukulii ke tina piklinbat ma biil i kiis la na ti Felun Tunmapek ae fanu ri tel u ini limri, biil. ");
INSERT INTO bjp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","God igii, i ta ta liu turan kif usuf fanu ke foron tier tikii. Biil i lauu, isi kerek tel foim ini limrer una lupes u, biil. ");
INSERT INTO bjp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Lo itikii sau e tubutamat kerer, God ka fatapiek foron mat tikii. Ka fakiis ri na foron falifu tikii ke ka luun aunbiing ae rin liu lo ke foron falifu tutus ae rin kiis lo. ");
INSERT INTO bjp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God i tel ta foron tier igii, isi fanu rik im isi, ma awii rik la usuf i, ma rik tafe u. Isau le God biil i tapak koseng temtem tikii lo kerer. ");
INSERT INTO bjp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Wara lo i sau, kere ka liu, kere ka miliu ke kere ka kep kif. Arae fale tom pit seksek kimi tom ri ka use ta u le, ‘Kere berberat kia.’ ");
INSERT INTO bjp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kere berberat ke God, pesu gong kere wol le God i tara arae goul, siliwa, fat ke arae foron tantanwan tier ae fanu ri tel u namin wolwol ke tasum kiri. ");
INSERT INTO bjp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tinpakanini, God i par ufu ta foron sinang arae, wara le fanu biil ri usum na sani ri tel u. Isau le igii, i use u le fanu tikii na marmarsan falifu rin sokiliis liu kiri. ");
INSERT INTO bjp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Wara le God ka luun ta nenge biing ae in nagogon fanu tikii na marmarsan maleh ma nagogon kia in tortores usuf fanu tikii. Ka tus pes ta nenge kaltu isi in tel nagogon ae ma ka fatekentu ta u usuf fanu aunbiing i fapti fafis u tina minet.” ");
INSERT INTO bjp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Aunbiing ri ongen Pol i use nenge kaltu i apti fis tina minet, fal ri ka morot ini, isau le fal ri ka tarah, “Keme ier isi on bele fas kemem sabin ini tier igii.” ");
INSERT INTO bjp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ri ka use ta u arae ke Pol ka suu koseng ri. ");
INSERT INTO bjp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Fal ri ka tapiek foron tom unune ke ri ka mi lo Pol. Neng lo ri asa e Dionisius, i neng lon fanu ae ri kiis turim la na Areopagus, ke nenge fifin asa e Damaris turan fal sabin. ");
INSERT INTO bjp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Namih, Pol ka la koseng Atens una Korin. ");
INSERT INTO bjp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ka tafe nenge sikin Iudaia aiwa, asa e Akuila, ae i pang ta na Pontus. Ru lamansilik e Prisila ru am kang sau tina Itali, wara le Klaudias Sisar i tel ufu fan Iudaia tikii tina Rom, ke Pol ka la isi par ruh. ");
INSERT INTO bjp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol i nenge tom tel fel ini kadiis sabin arae ruh, pesu ka melmel aiwa, ma ka foim tura ruh. ");
INSERT INTO bjp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Na foron Biingen Mangeh tikii, Pol i la la una felun lotu ken fan Iudaia ma ka orek la tura ri, ke ka totof isi in tel wolwol ken fan Iudaia turan fan Grik isi rik unune lo Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Aunbiing Sailas ru e Timoti ru ka tapiek ta tina Masedonia, Pol ka ta tikii foron aunbiing kia na fafas ini Rokap na Fafas, ka famalal fan Iudaia le Iesu i e Mesaia. ");
INSERT INTO bjp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Isau le, aunbiing fan Iudaia biil ri ier isi ongen fafausum kia ma ri ka orek kamgas ulo, Pol ka pakte ufu piyiif tina kaen kia ke ka tarah, “Male gamen fiu, ke wara lo gam tom. Ia sengsegeng. Tipes u igii, ian la mang ma iak fafas usuf fanu ae biil ri fan Iudaia.” ");
INSERT INTO bjp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ke Pol ka suu tina felun lotu ma ka la una fel ke Titius Jastus. Biil i sikin Iudaia, isau le i lotu la unaisa God ma fel kia i fatat sau isi felun lotu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, i e famfamu na felun lotu ae, i turan fanu tikii ae na fel kia ri ka unune. Ifuun e fanu na Korin sabin ae ri ongen orek ke Pol, ri ka unune ke ri ka kep bapitaiso. ");
INSERT INTO bjp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nenge wor Kumguui ka faorek Pol na nenge parpar ma ka tara sing i aragii, “Gong o sokeh, on famam orek tom, gong o babat na ngusum. ");
INSERT INTO bjp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Wara le ia igii naisam. Biil tikas ifasi in fatel o ma ik falaulau wo, wara le fanu fuun na maleh igii, ri kiak.” ");
INSERT INTO bjp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pesu Pol ka melmel tura ri pes nenge bet ma tiga ma ka famam fausum ri ini orek ke God. ");
INSERT INTO bjp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Isau le aunbiing Galio ka tapiek famfamu na matanfuntih na falifu na Akaia, fan Iudaia ri ka ti turim ke ri ka luse Pol ma ri ka lame u isi in ti na nagogon. ");
INSERT INTO bjp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ke ri ka fas famfamu ae aragii, “Kaltu igii i dat wolwol ken fanu la ma ri ka lotu unaisa God na matngan sal ae biil i tortores ini nagogon kimem.” ");
INSERT INTO bjp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Isau le aunbiing Pol ka ier isi orek, Galio ka fas fan Iudaia ae aragii, “Fan Iudaia gam ongen iau, male kaltu igii i tel fager ti tier le i tel ti tara na sinang laulau, ke in tortores le ian wong sing gam. ");
INSERT INTO bjp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Isau male gam tiu u ini foron orek, le ini foron as, le ini foron nagogon kimi tom, ke gam tom gamek nagogon u. Biil ia ier le ian nagogon tikas kunan foron tier arae.” ");
INSERT INTO bjp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ka use ta u arae, ke ka wuun fasuu ri tina felun nagogon. ");
INSERT INTO bjp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ke ri tikii ri ka pose papte Sostenes, famfamu na felun lotu kiri, ma ri ka paket u aiwa tom na felun nagogon. Isau le Galio biil i engenges le in tel ti tier ini ri. ");
INSERT INTO bjp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol ka kiis pes fale aunbiing biitom na Korin ke nami ka kang koseng foron tom unune aiwa ma ka wof na sip una Siria tura Prisila ru e Akuila. Isau le aunbiing i ier isi la, ka la famu ta bii una Senkria ke ka kukuur ufu olo, i wara na falimlim ae i tel ta u usuf God. ");
INSERT INTO bjp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ri ka tapiek na Efeses ke Pol ka la koseng Prisila ru e Akuila. I keskes ka kau una felun lotu ke ka orek turan fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aunbiing ri ka sising u isi in kiis biitom tura ri, biil i to somangat. ");
INSERT INTO bjp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Isau le, aunbiing ka ier isi la koseng ri, ka falimlim usuf ri aragii, “Male na wolwol ke God, ke ian fis sabin isi par gam.” Namih ka wof na sip koseng ri aiwa na Efeses. ");
INSERT INTO bjp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Aunbiing ka masah na Sisaria, ka tatkau una Ierusalem ke ka ta orek an famais kia usuf foron tom unune ke namih ka la una Entiok. ");
INSERT INTO bjp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ka kiis pes fale aunbiing aiwa na Entiok, ke nami ka la una temtem tikii na maleh na falifu na Galatia ke Frigia ma ka farakrakai unune ken foron tom unune tikii. ");
INSERT INTO bjp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na aunbiing sabin ae, nenge sikin Iudaia asa e Apolos tina maleh na Aleksendria i la una Efeses. I paket fakasi orek la ma i usum rokap sabin na Buk na Gogoh. ");
INSERT INTO bjp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ri fausum ta u ini Sal ke Kumguui ma i lala laes la tom aunbiing i fausum fanu ini Iesu. Ma fafausum kia i tortores, isau le i tom i usum sau na bapitaiso ke Jon. ");
INSERT INTO bjp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ma Apolos i kep balamas ta tom ma ka tipes fafas na felun lotu ken fan Iudaia. Aunbiing Prisila ru e Akuila ru ka ongen ta u, ru ka tel pes u una fel kiruh ke ru ka famalal fakasi u mang tom ini Sal ke God. ");
INSERT INTO bjp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aunbiing Apolos ka ier isi la una falifu na Akaia, foron tom unune ri ka farakrakai u ke ri ka sisiit usuf berberat na fafausum na Akaia, isi rin somangat pes u. Ma aunbiing i tapiek, ka ta tara falupes usuf fanu ae ri ka unune tah, wara na famais ke God. ");
INSERT INTO bjp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","I lala fakep ini orek turan fan Iudaia na matan fanu tikii ma ka fas ri ini foron sun orek na Buk na Gogoh ae i fatekentu u le Iesu i e Mesaia. ");
INSERT INTO bjp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aunbiing Apolos tinawii biitom na Korin, Pol ka la na sal na foron pungpung ke ka tapiek na Efeses ma ka tafe fale berberat na fafausum aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ke ka diik ri aragii, “Arafah, gam kep Tanwa Kalkaluu sabin aunbiing gam unune?” Ri ka kiliis u aragii, “Biil. Biil biitom keme ongen u le imel e Tanwa Kalkaluu.” ");
INSERT INTO bjp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ke ka diik ri sabin aragii, “Matngan bapitaiso arafa ae gam kep u?” Ri ka kiliis u le, “Bapitaiso ke Jon.” ");
INSERT INTO bjp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ke ka fas ri aragii, “Bapitaiso ke Jon i e bapitaiso una sokiliis liu. Jon i fas fanu le rin unune lo ier ae i mi pes u, i e Iesu.” ");
INSERT INTO bjp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Aunbiing ri ka ongen ta orek ke Pol, ri ka kep bapitaiso na asa Kumguui Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Aunbiing Pol i luun iun lima na olri, Tanwa Kalkaluu ka susuef ulo ri, ma ri ka orek ini marmarsan orek ke ri ka orek profet. ");
INSERT INTO bjp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Fanu tamat tikii aiwa ifasi arae nenge sangful ini u. ");
INSERT INTO bjp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol i kau una felun lotu ma i kep balamas aunbiing i orek. Ka fakep tura ri ma ka fatel wolwol kiri ini foron tier na matanfuntih ke God. I tel u arae na ituul e funiil. ");
INSERT INTO bjp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Isau le fal lo ri balri i sorokai kanaka ma biil ri ier isi unune ma ri ka use falaulau Sal ke Kumguui na matan fanu tikii. Pesu, Pol ka la koseng ri. Ka tel pes foron tom unune, ma na foron biing tikii ri ka orek turim la na felun fafausum ke Tiranus. ");
INSERT INTO bjp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","I tel u arae na iwu e bet, pesu fan Iudaia tikii turan fan Grik tikii ae ri kiis na falifu na Eisia, ri ka ongen orek ke Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God i fatapiek foron fakileng na lima Pol, ae i neng keskes lon foron fakileng i fatapiek u la tinpakanini. ");
INSERT INTO bjp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pesu ri ka kep foron anggisiip ke fale dangan kaen sabin ae ka tus ta na fo Pol, ke ri ka luun u la lon foron sasem ma ri ka liu, ke foron tanwa laulau sabin ri ka suu koseng ri. ");
INSERT INTO bjp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Fale fan Iudaia ri la la na foron maleh, ke ri ka fes ufu foron tanwa laulau. Ri totof isi rin fes ufu foron tanwa laulau ae ri susuef ulon fanu, ini asa Iesu. Ri use u la aragii, “Na asa Iesu ae Pol i fafas la ini, ia fas gam le gamen suuh!” ");
INSERT INTO bjp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ifit e kalalik tamat ke Skewa ri tel u la arae. Skewa i nenge laulaumet na pris. ");
INSERT INTO bjp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nenge biing ri tel u arae, isau le tanwa laulau ka kiliis ri aragii, “Ia usum lo Iesu ke ia usum sabin lo Pol, isau le gam fanseh?” ");
INSERT INTO bjp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ke kaltu ae tanwa laulau i susuef lo, ka sirok ulo ri ma ka paket sarara ri. Ka paket falaulau ri, ke ri ka finfin suuh tina fel ini pongong ma pununfo ri ka dahdahnen. ");
INSERT INTO bjp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Aunbiing fan Iudaia turan fan Grik ae ri kiis na Efeses ri ongen u, ri tikii ri ka lala sokeh ma ri ka sik asa Kumguui Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ifuun lon fanu ae ri unune tah, ri ka la ma ri ka fapos foron sinang laulau kiri na matan fanu. ");
INSERT INTO bjp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ke ifuun lo ri sabin ae pakanini ri latlat la, ri ka kep turim foron buk na latlat kiri ma ri ka fasok u na matan fanu tikii. Aunbiing ri wes turim matan foron buk ae, ifasi arae ilim e sangful e arip e siliwa. ");
INSERT INTO bjp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pesu orek ke Kumguui ka sararah ma ka kuum rakrakai. ");
INSERT INTO bjp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Nami na foron tier ae ka tapiek tah, Tanwa Kalkaluu ka luun orek na wolwol ke Pol le in soleng falifu na Masedonia, na Akaia ke namih, ik la una Ierusalem. Pol ka use u aragii, “Nami na kiis kiak na Ierusalem, iak la sabin una Rom.” ");
INSERT INTO bjp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ka wuun famu Timoti ru e Erastus, iun tom falupes kia, una Masedonia ma ka kiis fis pes fale aunbiing biitom na falifu na Eisia. ");
INSERT INTO bjp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Na aunbiing ae, ka apti e nenge tara fabalkut kunan Sal ke Kumguui. ");
INSERT INTO bjp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Nenge kaltu, asa e Demitrius, i tel foron tier la ini siliwa. I tel birbiron felun lotu la ke Artemis, fifin god kiri, ma i turan foron tom foim kia ri fatapiek tara pitkalang la na foim ae. ");
INSERT INTO bjp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demitrius ka kam turim foron tom foim kia turan fale fanu sabin ae foim kiri ifasih, ma ka fas ri aragii, “Fanu ri, gam usum le kere kep fakasi pitkalang la na foim igii. ");
INSERT INTO bjp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gam par u ke gam ka ongen ta u le kaltu ae asa e Pol, i dat wolwol ken fanu fuun ma ka lame fager ta ri aga na Efeses ke na falifu tikii na Eisia. Ka fas ri le foron tier igii kere tel u sau ini limrer, biil ri foron god tekentu. ");
INSERT INTO bjp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tier igii, biil in falaulau rokap na asan foim kirer sau, biil. In fapul wolwol sabin ken fanu isi biil rin bulat na felun lotu ken tara na god Artemis, ke tara na memeh kia ik tier foes, ae ri lotu la unaisa na falifu tikii na Eisia ke na piklinbat.” ");
INSERT INTO bjp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Aunbiing ri ongen u, ri ka lala ngaliaf ma ri ka tipes perek aragii, “I laumet kanaka e god Artemis ken fan Efeses!” ");
INSERT INTO bjp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ka rigorigo tikii e maleh ae ke ri ka luse Gaius ru e Aristarkus, iwun kaltu tina Masedonia ae ru la la tura Pol, ma fanu tikii ri ka fasasai kau una felun la turim tura ruh. ");
INSERT INTO bjp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ka ier isi kau sabin na palgan fanu ae, isau le foron tom unune ri ka tikale u. ");
INSERT INTO bjp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ke fale tala sabin, ri foron laulaumet na matanfuntih na falifu na Eisia, ri ka ta orek usuf i, ma ri ka sising u le gong i kau una felun la turim. ");
INSERT INTO bjp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ma ka rigorigo e wolwol ken gur na fanu ae. Fal ri ka perek ini nenge tier, ke fal ini nenge tier keskes. Ma ifuun biil ri usum na sani ri la isi. ");
INSERT INTO bjp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Fan Iudaia ri ka sule Aleksenda una famu ma ri ka fas u ini sani ae in use u. Ke Aleksenda ka piispiis kale fanu isi rin kiis fofo ma ik tel orek an fafamalal kia na matri. ");
INSERT INTO bjp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Isau le aunbiing ri ongen u le Aleksenda i nenge sikin Iudaia, ri tikii ri ka teme perek na iwu e awa aragii, “I laumet kanaka e god Artemis ken fan Efeses!” ");
INSERT INTO bjp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Tom sisiit tina maleh ae ka fas fanu isi rin kiis fofo ke ka tarah, “Fan Efeses, fanu tikii na piklinbat ri usum le maleh na Efeses ri fofonoi la na felun lotu ke fifin god Artemis ke tantanwa sabin ae i luut ta tinbae na kukulii. ");
INSERT INTO bjp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Pesu, gamen kiis fofo, wara le biil tikas ifasi in fakawe ufu. Gong gam tel tier ini gargar. ");
INSERT INTO bjp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gam ka lame ta iun kaltu igii uga, isau le biil ru suksukuum tina felun lotu ma biil ru use falaulau ta fifin god kirer. ");
INSERT INTO bjp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Male Demitrius turan foron tom foim kia ri tiu tikas ini ti tier, ke i sapeng e felun nagogon ma imel e foron tom nagogon. Ri fasih rin nagogon u aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Male imel e tier biitom ae gam ier isi orek lo, ke rin fatortores u aunbiing foron famfamu na maleh rin kiis turim. ");
INSERT INTO bjp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Pesu, tarama fan Rom ri ka luun kerer na nagogon kunan tatawin ae i tapiek igii. Ke sani keren use u una orek kale kerer? Wara le biil ti rokap na wara.” ");
INSERT INTO bjp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aunbiing tom sisiit ka use ta u arae, ka wuun sarara ri. ");
INSERT INTO bjp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Aunbiing tatawin ae ka rop tah, Pol ka fawuun isi foron tom unune ma ka farakrakai ri ke ka ta orek an mamais kia usuf ri. Namih, ka la una Masedonia. ");
INSERT INTO bjp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","I la na fatpoton foron maleh ae ma ka farakrakai fanu ini ifuun e orek, ke namih, ka tapiek na Grik. ");
INSERT INTO bjp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ka kiis pes ituul e funiil aiwa. Aunbiing ka geges isi wof na sip una Siria, ka usum ta le fale fan Iudaia ri ka puput ta le rin siimete u. Pesu, ka tole sal fis sabin una Masedonia na ninla kia una Siria. ");
INSERT INTO bjp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopater, kalalik ke Pirus tina Berea, Aristarkus ru e Sekundus tina Tesalonika, Gaius tina Derbe, Timoti sabin tura Tikikus ru e Trofimus tina Eisia, ri la tura Pol. ");
INSERT INTO bjp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Fanu ae ri famu una Troas, ma ri ka nene kemem aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nami na Ngasa na Beret ae biil ti is lo, keme ka wof na sip tina Filipai ke nami na ilim e biing, keme ka masah naisri na Troas ma keme ka kiis pes ifit e biing aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na biing famu na wik ae, aunbiing keme kiis turim isi ien, Pol ka tel dolon orek usuf ri papang na fapot, wara i ier isi la koseng ri na biing namih. ");
INSERT INTO bjp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ifuun e lam na kakah bae na mawe ae keme kiis turim wah. ");
INSERT INTO bjp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nenge guam asa e Iutikus, i kiis ta na olon matanbuat na fel ae. Na aunbiing Pol i ororek la biitom, mata ka masmasun, ka gok ma ka luut tinbae na mawe na fatuul u e dek ubuif na nanal. Ri sik pes u ma ka met tah. ");
INSERT INTO bjp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Isau le Pol ka puh ma ka luutuf na olon guam ae, ka diit u ke ka tarah, “Gong i purngis e balmi, i liu sau.” ");
INSERT INTO bjp_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Namih, Pol ka fen fis sabin ubae na mawe, ka sibik beret ke ka ien tura ri. Ka orek papang na biingbiing, ke ka la. ");
INSERT INTO bjp_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Fanu ae ri ka tel pes guam ae ka liu fis ta una fel kia ini tara laes. ");
INSERT INTO bjp_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Keme ka wof famu na sip una Asos ma keme ka nene Pol aiwa. I puput ta arae, wara le i ier isi in tole sal. ");
INSERT INTO bjp_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aunbiing keme fatafe tura na Asos, keme ka siing pes u ke keme ka la una Mitilene. ");
INSERT INTO bjp_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Keme ka apti tina Mitilene ke na biing namih, keme ka liu ufu Kios. Na biing nami sabin keme ka sopaket una Samos ke na biing nami keme ka masa na Miletus. ");
INSERT INTO bjp_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol i ier isi in liu ufu Efeses, wara le biil i ier isi kiis pes dolon aunbiing na falifu na Eisia. I ier isi sangsangar una Ierusalem isi in tapiek bae famu na biingen Pentikos. ");
INSERT INTO bjp_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Na Miletus, Pol ka ta orek isi foron famfamu na lotu na Efeses. ");
INSERT INTO bjp_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Aunbiing ri ka tapiek, ka fas ri aragii, “Gam tom gam usum na kiis kiak tura gam, tipes u na biing famu ae ia tapiek ta aga na falifu na Eisia. ");
INSERT INTO bjp_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ia fapu iau la tom ma ia ka tel foim ke Kumguui ini danun matang, taftawa le fan Iudaia ri puput ta isi falaulau iau ma sinangu ri ka arae tara fatoftof unaisang. ");
INSERT INTO bjp_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aunbiing ia fafas tah ke ia ka fausum ta gam na matan fanu ke na foron fel kimi, biil ia fun ta ti orek ae in lupes gam, biil. ");
INSERT INTO bjp_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ia ka fafas ta usuf fan Iudaia ke fan Grik sabin, isi rin sokiliis liu kiri usuf God ma rik unune lo Iesu, Kumguui kirer. ");
INSERT INTO bjp_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ma igii Tanwa Kalkaluu ka rakrakai tom isi ian la una Ierusalem ma biil ia usum le sani in tapiek lo iau bae. ");
INSERT INTO bjp_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ia usum sau le na foron maleh tikii, Tanwa Kalkaluu i fas iau le felun kamkabet ke tatawin i nene iau. ");
INSERT INTO bjp_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Isau le, ia wol le liu kiak biil i laumet, biil. Tier ae i laumet, le ian farop ninla kiak ke foim ae Kumguui Iesu i ta u usuf iau, le ian fafas ini Rokap na Fafas na famais ke God. ");
INSERT INTO bjp_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ma igii, ia usum le biil mang tikas lo gam ae ia la ta ma ia ka fafas ini matanfuntih ke God usuf i, in par matang sabin. ");
INSERT INTO bjp_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Pesu, ia ka fas gam, male tikas lo gam in fiu na nagogon ke God, ke ia sengsegeng na dawu. ");
INSERT INTO bjp_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wara le biil ia fun ta ti orek, biil. Ia ka fas ta gam ini foron wolwol tikii ke God. ");
INSERT INTO bjp_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gamen fofonoi rokap lo gam tom, ke na u na sipsip tikii ae Tanwa Kalkaluu i ta ta u usuf gam, isi gamen famu pes ri. Gamen fofonoi lon fanu ke God, ae ka fiil ta ri ini dawu tom. ");
INSERT INTO bjp_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ia usum le, aunbiing ian la koseng gam, foron puul ngalngaliaf rin la una fatpoto gam ke rik falaulau u na sipsip. ");
INSERT INTO bjp_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ke fale fanu sabin tina fatpoto gam tom, rin aptih ke rik use fale orek famfabal isi foron tom unune rik mi lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pesu, gamen tumarang! Gamen wolpes u le na ituul e bet, biil ia mange na fanau temtem tikii lo gam, na siat ke na wor sabin ini danun matang. ");
INSERT INTO bjp_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ma igii, ia ta gam na piklin fofonoi ke God ke na piklin fafas na famais kia. Orek ae ifasi in farakrakai gam ke ik fakalok gam ini foron rokap na fafen ae God i ta u la usuf fanu kalkaluu kia. ");
INSERT INTO bjp_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Biil ia ram ta isi ti siliwa le goul le kilkiliis ken tikas. ");
INSERT INTO bjp_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gam tom gam usum le ia rik foim ta tom ini iun limang isi foron tier ik fasi na kiis kiak ke una lupes fanu sabin ae ri batme iau la. ");
INSERT INTO bjp_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Na foron tier tikii ae ia ka tel ta u, iau arae rokap na tintof usuf gam isi gam sabin gamen foim rakrakai, ke gamek lupes fanu ae biil ti rakrakai kiri. Gamen wol papte foron orek ke Kumguui Iesu, ae i tom i use ta u aragii, ‘Ri kalok kanaka e fanu ae ri fafen, lon fanu ae ri kep fafen.’” ");
INSERT INTO bjp_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Aunbiing ka use ta foron orek ae, ka ilepul ke ka sising turan foron famfamu tikii ae. ");
INSERT INTO bjp_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ke ri tikii ri ka teng ke ri ka diit papte Pol ma ri ka dor u. ");
INSERT INTO bjp_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ma tier ae i lala purngis e balri lo, i fas ta ri le biil mang rin par mata sabin. Ke namih, ri ka filange u na sip. ");
INSERT INTO bjp_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Aunbiing keme ka faorek ufu ta ri, keme ka wof na sip ke keme ka filau tortores una nenge bit, asa e Kos. Ma na biing namih, keme ka filau una Rodes ke tinaiwa, keme ka tapiek na Patara. ");
INSERT INTO bjp_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ke aiwa, keme ka par nenge sip ae in la una Fonisia. Keme ka wof lo ke keme ka la. ");
INSERT INTO bjp_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Keme ka par bit na Saiprus ke keme ka alfe u na kaisa kemem. Keme ka la una falifu na Siria ma keme ka masa na Tair, isi sip ik fasfasuu na foron tier aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Aunbiing keme ka tafe foron tom unune, keme ka kiis pes ifit e biing aiwa. Ma Tanwa Kalkaluu ka fas ri isi rin fas Pol le gong i la ubae na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Isau le nami na ifit e biing, keme ka aptih ke keme ka tungtugus na ninla kimem. Foron tom unune tikii turan foron antu ri ke berberat kiri, ri ka la tura kemem tina maleh ae. Awii na kiin keme ka ilepul ma keme ka sising. ");
INSERT INTO bjp_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Aunbiing ri ka fatule tah, ri ka fis una foron fel kiri, ke keme ka wof na sip. ");
INSERT INTO bjp_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Keme ka apti tina Tair ke keme ka masa na Potolemais. Aiwa, keme ka fatafe turan foron tom unune ma keme ka kiis tura ri na nenge biing. ");
INSERT INTO bjp_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Na biing namih, keme ka apti tinaiwa ma keme ka tapiek na Sisaria. Keme ka melmel na fel ke Filip, nenge tom fafas ini Rokap na Fafas, neng lon ifit e kaltu ae foron aposel ri fule pes ta ri. ");
INSERT INTO bjp_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Kaltu igii, ifet e keleflik kia biil biitom ri fakekel ma ri orek profet la. ");
INSERT INTO bjp_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aunbiing keme ka kiis ta aiwa na ifuun e biing, nenge profet asa e Agabus ka filaupu tinbae na falifu na Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ka la usuf kemem, ka kep pus ke Pol, ke ka kabet iun lima ke iun keke tom ma ka use u aragii, “Tanwa Kalkaluu i tarah, ‘Fan Iudaia buuii na Ierusalem rin kabet kaltu ae pus kia igii, aragii ia tel u ke rik ta ufu usuf fanu ae biil ri fan Iudaia.’” ");
INSERT INTO bjp_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Aunbiing keme ongen u, kemem turan fanu tinaiwa, keme ka tikale Pol isi gong i tatkau una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ke Pol ka kiliis kemem aragii, “Isi sani gam ka famam teng ke gam ka fapurpurngis balang? Ia geges isi biil rin kabet iau sau, biil. Ia geges sabin isi rin siimete iau bae na Ierusalem, wara na asa Kumguui Iesu.” ");
INSERT INTO bjp_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Aunbiing biil ifasi kemen tikale u, keme ka mangeh sau ke keme ka tarah, “I rokap le wolwol ke Kumguui ik suut.” ");
INSERT INTO bjp_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Namih, keme ka geges ke keme ka la ubae na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Fale berberat na fafausum tina Sisaria, ri la tura kemem ke ri ka filange kemem na fel ke Manason, isi kemen kiis tura. I tina Saiprus ma pakanini tom i tapiek nenge tom unune tah. ");
INSERT INTO bjp_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Aunbiing keme tapiek bae na Ierusalem, foron tualikmem na asa Iesu ri ka somangat pes kemem ini laes. ");
INSERT INTO bjp_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Na biing namih, kemem tikii tura Pol keme ka la isi par Jems turan foron famfamu tikii na lotu. ");
INSERT INTO bjp_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pol ka ta ta orek an laes kia usuf ri ke ka fas ri ini sani God ka tel ta u na foim kia na fatpoton fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Aunbiing ri ongen u, ri ka usefages God. Ma ri ka tara sing Pol aragii, “Tualikmem, o usum le ka fis tikii ta e arip lon fan Iudaia ri ka unune tah ma ri tikii ri rakrakai tom isi mi na nagogon ke Moses. ");
INSERT INTO bjp_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ri ka ongen ta nenge orek ulo wo le, o fausum fan Iudaia tikii ae ri kiis na fatpoton fanu ae biil ri fan Iudaia le, gong ri mi na nagogon ke Moses. Ke o ka fas ri sabin le gong ri kiit pununfon berberat kiri ke gong ri mi na sinangu kemem fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Aunbiing rin ongen u le o ka tapiek tah aga, ke sani keren tel u? ");
INSERT INTO bjp_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Pesu, on tel sani kemen fas wo ini. Ifet e kaltu igii na aisrer, ri ka falimlim ta na mata God. ");
INSERT INTO bjp_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Tel pes ri ke gamek fafuu gam tom arae namin nagogon, ma ok fiil ti foron fafen kiri ae rin ta u usuf God, isi rik kukuur ufu olri. Male on tel u arae, ke fanu tikii rin usum le foron orek ae ri ka ongen ta u, biil i tekentu, ke wo sabin o misuut tom na nagogon ke Moses. ");
INSERT INTO bjp_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ke usuf foron tom unune ae biil ri fan Iudaia, kere siit ta nenge leta usuf ri le, gong ri ien foron inen ae ri ta ta u arae fafen usuf foron god famfabal, gong ri ien dah na foron muruuw, gong ri ien pinsan muruuw ae ri bing mete u ke gong ri tel sinangun tamfaes.” ");
INSERT INTO bjp_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Na biing namih, Pol ka telpes ifet e kaltu ae, ke ri tikii tura Pol ri ka fafuu ri tom. Ka kau na Felun Tunmapek ke ka put biing ae foim na fafuu ri in rop lo ke na biing sa rin ta foron fafen temtem tikii kiri lo. ");
INSERT INTO bjp_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Aunbiing ifit e biing ae fatat in rop, fale fan Iudaia tina falifu na Eisia ri ka par Pol awii na Felun Tunmapek. Ke ri ka siingsiing orek na balan gur na fanu tikii ae ma ri ka luse Pol. ");
INSERT INTO bjp_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ke ri ka tautau aragii, “Fan Israel, gam lupes kemem! Kaltu igii i fausum fanu tikii na piklinbat le rin ememse kerer turan foron nagogon ke Moses ke Felun Tunmapek. Ma igii ka lame fale fan Grik sabin una palgan Felun Tunmapek ke ka fadu fel kalkaluu igii.” ");
INSERT INTO bjp_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ri use u arae, wara le pakanini, ri par ta Trofimus sikin Efeses tura Pol na Ierusalem ke ri ka wol le Pol ka lame fakau ta u una palgan Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ma maleh tikii ae ka rigorigo. Fanu ri ka filau suuh tina foron falifu tikii, ke ri ka luse Pol ma ri ka dat fasuu u tina Felun Tunmapek. Fanpil ri ka babat tikii na foron matan Felun Tunmapek. ");
INSERT INTO bjp_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Aunbiing ri totof la biitom isi rin siimete u, fafas lo ka tapiek sing kabisit ken foron tom fapaket tina Rom, le maleh tikii na Ierusalem i rigorigo. ");
INSERT INTO bjp_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kabisit ae ka lame sape turim foron tom fapaket turan fale famfamu kiri sabin ma ri ka filaupu usuf gur na fanu ae. Aunbiing ri ka par kabisit ae turan foron tom fapaket kia, ri ka susuaf na paket Pol. ");
INSERT INTO bjp_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kabisit ae ka la usuf Pol ke ka pose lo ke ka fas ri isi kabet u ini in wu e sen. Ke ka diik ri aragii, “Kaltu sa igii? Sani i tel fager ta u?” ");
INSERT INTO bjp_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Fale fanu na gur ae ri perek ini nenge tier ke fal ini nenge tier keskes. Ma aunbiing kabisit ae biil ifasi in malal na wara e fabalkut ae, wara le falifu i rigorigo, ka fas foron tom fapaket isi rin lame Pol una falifu ken foron tom fapaket. ");
INSERT INTO bjp_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Aunbiing Pol ka la fatat leta na fel ae, foron tom fapaket ri ka kusep u, wara le gur na fanu ae ri ka lala ngaliaf mang tom. ");
INSERT INTO bjp_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ma gur na fanu ae ri mimi la lo ri, ri ka famam perek aragii, “Siimete u!” ");
INSERT INTO bjp_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Aunbiing foron tom fapaket fatat rin kep fakau Pol una palgan fel kiri, ke Pol ka sising kabisit kiri aragii, “Ifasi ian fas o ini nenge tier?” Ke kabisit ae ka diik u aragii, “O usum sabin na orek Grik? ");
INSERT INTO bjp_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ia wol le, wo sau o sikin Isip ae i tanwaran nenge fapaket ta pakanini ma ka lame ifet e arip e foron tom sisiimete una falifu foes.” ");
INSERT INTO bjp_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ke Pol ka kiliis u aragii, “Ia nenge sikin Iudaia tina Tarsus na falifu na Silisia. Ia biil tina ti maleh foes sau, biil. Kiskam, ia sising o isi on somangat ufu iau isi iak orek usuf fanu igii.” ");
INSERT INTO bjp_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Aunbiing kabisit ken foron tom fapaket ka somangat ufu tah, Pol ka ti na leta na fel ma ka piispiis kale ri ini lima. Aunbiing ri ka soti fofo tah, ka orek usuf ri ini orek Ibru. ");
INSERT INTO bjp_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ka tarah, “Foron tuaklik ke foron tamang, gam ongen orek ae igii ian orek kale iau ini.” ");
INSERT INTO bjp_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Aunbiing ri ongen u le i orek usuf ri ini orek Ibru, ri ka lala kiis fofo mang tom. Ke Pol ka fas ri aragii, ");
INSERT INTO bjp_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ia nenge sikin Iudaia. Ia pang na Tarsus na falifu na Silisia. Isau le, ia laumet aga na Ierusalem ma ia nenge kalalik na fafausum ke Gamaliel, i fausum fakasi iau ini foron nagogon ken foron tama kerer tinpakanini. Ma ia foim rakrakai ta ke God arae gam sabin igii. ");
INSERT INTO bjp_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ia ta ta fangungut usuf fanu ae ri mi la na Sal ke Kumguui, ma fal ri ka met. Ke ia luse ta fanu tamat turan kelefin ma ia ka luun ri la na kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Famfamu ken foron pris turan foron famfamu tikii ken fan Iudaia, ri usum le orek kiak i tekentu. Ia kep ta foron leta sabin sing ri usuf foron tualik ri ae na Damaskas, ke ia ka la unaiwa isi luse foron tom unune isi kamkabet aga na Ierusalem ma rik ta fangungut usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Aunbiing ia la fatat isi Damaskas na siat tuntun, fanpil nenge tara malal tina kukulii ka popos kawil iau. ");
INSERT INTO bjp_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ia ka luut una nanal ke ia ka ongen kinen tikas i tara sing iau aragii, ‘Sol! Sol! Isi sani o ka ta fangungut sing iau?’ ");
INSERT INTO bjp_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ke ia ka diik u aragii, ‘Kumguui, wo seh?’ “Ka kiliis iau aragii, ‘Ia Iesu tina Nasaret, ae o famam ta fangungut sing iau.’ ");
INSERT INTO bjp_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ma fanu ae ri la turang ri par u e malal ae, isau le biil ri ongen failiim orek ke ier ae i faorek iau. ");
INSERT INTO bjp_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ke ia ka diik u aragii, ‘Kumguui, sani ian tel u?’ “Ke Kumguui ka kiliis iau aragii, ‘Aptih ma ok kau na Damaskas. Ke aiwa rik fas o ini foron tier tikii ae ia tim pes ta wo isi on tel u.’ ");
INSERT INTO bjp_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Fanu ae ri la turang ri ka tangne iau una Damaskas, wara le rakrakai ken malal ae i fakut matang. ");
INSERT INTO bjp_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nenge kaltu asa e Ananias ka la isi par iau. I nenge tom lotu tekentu ae i mi rokap la na foron nagogon tikii. Ma fan Iudaia tikii ae ri kiis la aiwa, ri bulat la lo. ");
INSERT INTO bjp_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ka soti fatat iau ma ka tarah, ‘Sol tuaklik, par mang.’ Ke na aunbiing tom ae, ka sapeng e matang, ke ia ka par Ananias. ");
INSERT INTO bjp_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ke Ananias ka fas iau aragii, ‘God ken foron tubutamat kerer ka tus pes ta wo isi on usum na wolwol kia ke ok par Ier ae i Tom Tortores ke ok ongen foron orek ae i suu tina ngusu. ");
INSERT INTO bjp_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","On tapiek tom fafas kia usuf fanu tikii, na sani o ka par ta u ke o ka ongen ta u. ");
INSERT INTO bjp_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma igii, sani biitom o nene u? Aptih, kep bapitaiso ke ok sising una asa, isi ik pa ufu foron sinang laulau kiam.’ ");
INSERT INTO bjp_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ia ka fis uga na Ierusalem ma aunbiing ia ka sisising la na Felun Tunmapek, ka ruungruung e wolwol kiak ma ia ka par nenge parpar. ");
INSERT INTO bjp_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ia ka par Kumguui i orek turang. Ka tara sing iau aragii, ‘Apti sape ma ok la koseng Ierusalem, wara le biil rin somangat pes foron fafamalal kiam ulo iau.’ ");
INSERT INTO bjp_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ia ka kiliis u aragii, ‘Kumguui, fanu igii ri usum le pakanini ia kau la na foron felun lotu tikii, isi luun fanu ae ri unune lo wo na kamkabet ke ia ka pis ri la. ");
INSERT INTO bjp_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na aunbiing ri siimete ta Stiwen, tom fafas kiam, ia soti ta aiwa, ke ia ka somangat turim tura ri ma ia ka parpar na foron kilkiliis ken fanu ae ri siimete u.’ ");
INSERT INTO bjp_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Isau le Kumguui ka fas iau aragii, ‘La! Ian wuun o una tapak usuf fanu ae biil ri fan Iudaia.’” ");
INSERT INTO bjp_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Gur na fanu ae ri ongen foron orek ke Pol papang na sun orek ae, ke ri ka perek aragii, “Siimete u! I rokap le matngan kaltu aragii in mangmangal tinaga na piklinbat. Biil i rokap le in liu!” ");
INSERT INTO bjp_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Aunbiing ri tautautau la, ri ka tel ufu foron dolon kaen kiri ke ri ka saprai piyiif una mawe, ");
INSERT INTO bjp_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","kabisit ae ka ta orek sing foron tom fapaket isi rin fakau Pol una fel kiri ke ka fas ri isi rik pis u ma rik diik u le, isi sani fanu ri ka perek ulo. ");
INSERT INTO bjp_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ke aunbiing ri ka kabet u isi rin pis u, Pol ka tara sing nenge famfamu ken foron tom fapaket ae i soti fatat aragii, “Arafah, i tortores na nagogon le gamen pis nenge sikin Rom ae biil biitom ri tafe u le i tel fager ta ti tier?” ");
INSERT INTO bjp_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Aunbiing ka ongen u arae, ka la usuf kabisit ke ka fas u aragii, “Sani mang on tel u? Wara le kaltu igii, i sikin Rom.” ");
INSERT INTO bjp_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kabisit ae ka la usuf Pol, ke ka diik u aragii, “Fas iau, wo sikin Rom, le biil?” Ke ka kiliis u aragii, “Iuu, ia sikin Rom.” ");
INSERT INTO bjp_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ke kabisit ae ka tarah, “Ia fifiil ini tara pitkalang isi tapiek arae nenge sikin Rom.” Isau le Pol ka kiliis u aragii, “Ia sikin Rom tom aunbiing ia pang.” ");
INSERT INTO bjp_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ma fanu ae ri ier ta isi diik u, fanpil ri ka la koseng u. Ke kabisit sabin ka sokeh aunbiing ka usum mang le Pol i nenge sikin Rom, wara le ka kabet ta u ini sen. ");
INSERT INTO bjp_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Na biing namih, kabisit ae ka ier tom le in usum rokap le isi sani fan Iudaia ri ka tiu Pol. Pesu ka puk ufu sen lo ke ka fawuun isi foron laulaumet na pris turan foron famfamu tikii, ke ri ka tapiek turim. Ka lame Pol ke ka fiti u na matri. ");
INSERT INTO bjp_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol ka par tortores usuf foron famfamu ke ka fas ri aragii, “Foron tuaklik, ia ka tel fasuut ta foron foim tikii kiak usuf God ma biil ia sir kunan ti tier, papang igii.” ");
INSERT INTO bjp_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Na orek sau igii, pesu Ananias famfamu ken foron pris ka fas fanu ae ri soti fatat Pol isi rin pose ngusu. ");
INSERT INTO bjp_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ke Pol ka tara sing i aragii, “God in pose wo sabin. O arae nenge baban baloh ae ri mof ta u ma ka pos. O kiis sau aiwa isi nagogon iau namin nagogon ke Moses, isau le wo tom o ka lek ta nagogon, aunbiing o fas ri isi rin pose iau.” ");
INSERT INTO bjp_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Fanu ae ri soti fatat Pol, ri ka tarah, “Arafah, biil o usum le o ka orek laulau ta ulon famfamu ken foron pris ke God?” ");
INSERT INTO bjp_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ke Pol ka kiliis ri aragii, “Foron tuaklik, biil ia usum le i famfamu ken foron pris, wara le ri siit ta u na Buk na Gogoh le, ‘Gong gam orek laulau ulon ti famfamu kimi.’” ");
INSERT INTO bjp_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pol ka usum ta le fal lo ri, ri foron Sadusi ke fal sabin ri foron Farasi, pesu ka perek aragii, “Foron tuaklik, ia nenge Farasi ma ia kalalik ken nenge Farasi. Ia soti na nagogon, wara ia unune le foron minet rin apti fis sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Aunbiing ka use ta u arae, ka mel e fabalkut na fatpoton foron Farasi turan foron Sadusi. Ke ri ka tampaek, ka wu lo ri. ");
INSERT INTO bjp_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Wara le foron Sadusi ri unune le biil imel e apaptifis ke biil imel e angelo ke biil imel e tanwa, isau le foron Farasi ri unune na foron tier igii. ");
INSERT INTO bjp_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ke ka mel e tara fabalkut na fatpoto ri ke fale tom fafausum ini nagogon ae ri foron Farasi ri ka aptih ma ri ka ngaliaf ke ri ka tarah, “Biil keme tafe ti tier kaltu igii i tel fager ta u. Arafa male, ti tanwa le ti angelo i faorek ta u?” ");
INSERT INTO bjp_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Fabalkut ae ka laulaumet la, pesu kabisit ae ka sokeh, tarama ri ka paket falaulau Pol. Ke ka fas foron tom fapaket isi rin la ma rik dat pes u koseng ri ma rik lame fafis u una fel ken foron tom fapaket. ");
INSERT INTO bjp_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na wor ae, Kumguui ka soti fatat Pol ma ka tarah, “In rorokiis e balam! Arae tom o ka famalal ta iau aga na Ierusalem, ke on famalal iau sabin na Rom.” ");
INSERT INTO bjp_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Na biingbiing na biing namih, fale fan Iudaia ae wewes lo ri i liu ufu ifet e sangful, ri ka orek turim isi rin tel nenge falimlim le biil rin ien ke yin, papang na aunbiing rin siimete Pol. ");
INSERT INTO bjp_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ri ka la usuf foron laulaumet na pris turan foron famfamu ma ri ka tarah, “Keme ka tel ta nenge rakrakai na falimlim le biil kemen ien ti tier, papang na aunbiing kemek siimete Pol. ");
INSERT INTO bjp_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Keme ier isi gam turan foron famfamu, gamen ta orek usuf kabisit isi gamek fabal pes Pol. Gamen use u le, gam ier isi ongen ti fale orek rokap biitom na tatawin kia. Ma kemen geges isi siimete u, aunbiing biil biitom in tapiek sing gam.” ");
INSERT INTO bjp_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Isau le aunbiing kawa Pol i ongen puput igii, ka la una fel ken foron tom fapaket ma ka fas Pol ini. ");
INSERT INTO bjp_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ke Pol ka tawi pes nenge famfamu ken foron tom fapaket ke ka fas u aragii, “Telpes guam igii usuf kabisit. Imel e orek in fas u ini.” ");
INSERT INTO bjp_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ke ka telpes u usuf kabisit. Ke ka fas u aragii, “Pol, ier ae i kiis na kamkabet, i tawi pes iau ma ka sising iau le ian lame guam igii usuf o, wara le imel e orek in fas wo ini.” ");
INSERT INTO bjp_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kabisit ka pose na lima ke ka lame u una baba ma ka diik u aragii, “Sani o ier le on fas iau ini?” ");
INSERT INTO bjp_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ka kiliis u aragii, “Fan Iudaia ri ka puput turim ta isi rin fabal pes Pol sing o, le lumen on wuun ufu usuf foron famfamu, isi rik ongen ti fale orek rokap biitom na tatawin kia. ");
INSERT INTO bjp_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pesu gong o mi na orek kiri, wara le i liu ufu ifet e sangful e fanu ri mumun, nene isi rin siimete u. Ri ka falimlim ta isi biil rin ien ke yin, papang na aunbiing rin siimete u. Ma igii, ri nene sau isi on somangat.” ");
INSERT INTO bjp_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ke kabisit ka wuun ufu guam ae, ma ka fanau u aragii, “Gong o fas tikas le, o ka ususe ta sing iau.” ");
INSERT INTO bjp_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ke kabisit ka tawi pes iwu e famfamu usuf i ma ka tarah, “Kamun fageges in wu e mar e tom fapaket, in fit e sangful e tom fapaket ae ri kiis la na os turan in wu e mar e tom fapaket ae ri pose la na foron iu, isi gamek la una Sisaria na isiu e aunbiing igii na wor. ");
INSERT INTO bjp_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kamun fageges ti foron os sabin usuf Pol isi ik la lo. Gamen fofonoi rokap lo papang na aunbiing gamen tapiek sing Feliks, laulaumet na matanfuntih na Sisaria.” ");
INSERT INTO bjp_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ke ka siit nenge leta usuf i aragii: ");
INSERT INTO bjp_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ia Klaudias Lisias, ia sisiit usuf o Feliks, laulaumet na matanfuntih. Famais usuf o. ");
INSERT INTO bjp_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Kaltu igii, fan Iudaia ri luse u ma fatat rin siimete u. Isau le ia ka la turan foron tom fapaket kiak ke keme ka faliu u, wara le ia ka usum mang le i nenge sikin Rom. ");
INSERT INTO bjp_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ia ier le ian usum le matngan sani tom ri tiu u ini, pesu ia ka lame u usuf foron famfamu kiri. ");
INSERT INTO bjp_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ia ka tafe u le, foron tier ae ri tiu u ini, e foron tier na nagogon na lotu kiri. Ma biil i tel ti tier laulau ae ifasi una siimete u le luun u na kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ia ka ongen ta u le, ri ka puput ta isi rin siimete u. Pesu ia ka wuun sape ufu usuf o. Ke ia ka fas fanu sabin ae ri tiu u le, rin la usuf o ma rik fas o ini wara ae ri ka tiu u. ");
INSERT INTO bjp_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ke foron tom fapaket ri ka telpes Pol na wor una Antipatris, arae tom ri patrai ta ri. ");
INSERT INTO bjp_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Na biing namih, foron tom fapaket ae ri kiis la na foron os ri ka la tura ma ifet e mar e foron tom fapaket ri ka fis una fel ken foron tom fapaket na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Aunbiing ri tapiek na Sisaria, ri ka ta leta usuf laulaumet na matanfuntih ae ke ri ka ta ufu Pol sabin usuf i. ");
INSERT INTO bjp_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Aunbiing famfamu na matanfuntih ka wes ta leta ae, ka diik Pol aragii, “O tina falifu sah?” Aunbiing ka usum mang le i tina falifu na Silisia, ka tarah, ");
INSERT INTO bjp_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Aunbiing fanu ae ri tiu wo rin tapiek aga, ke iak ongen sani ae ri tiu wo ini.” Ke ka fas ri isi rin luun u na kamkabet na fel ke Erot, ma rik parpar kale u. ");
INSERT INTO bjp_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ilim e biing namih, Ananias, famfamu ken foron pris turan fale famfamu na lotu ke Tertulus, nenge tom tasum na nagogon, ri ka puh una Sisaria ma ri ka fas famfamu na matanfuntih ae ini sani ae ri tiu Pol ini. ");
INSERT INTO bjp_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Aunbiing ri ka tawi pes ta Pol, Tertulus ka tipes orek mang na mata Feliks aragii, “Dolon aunbiing keme liu rokap ini siaroh na piklin nagogon kiam. Wara le rokap na tasum kiam, i fatapiek foron sokiliis na falifu igii. ");
INSERT INTO bjp_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Feliks, o tara kaltu kanaka, na foron falifu tikii, ke na foron sal tikii, keme laes la ini wo ke keme ka fotrokap la usuf o. ");
INSERT INTO bjp_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Isau le biil mang ian lala orek, tarama ia ka fangos fom. Ia sising o sau isi on mais kemem ke ok ongen pes fatuklin orek kimem ulon kaltu igii. ");
INSERT INTO bjp_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Keme tafe u le kaltu igii, i nenge kaltu una fatapiek kiis laulau ma ka fatapiek ta ifuun e fabalkut na fatpoton fan Iudaia na piklinbat tikii. Ma i nenge famfamu na lotu famfabal ae ri foteng u ini lotu tina Nasaret. ");
INSERT INTO bjp_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ke i ier sabin le in fadu Felun Tunmapek na mata God, pesu keme ka luse u. ");
INSERT INTO bjp_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","O tom ok diik u ke ok usum tole u le foron tier igii keme tiu u ini, i tekentu.” ");
INSERT INTO bjp_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ke fan Iudaia sabin aiwa, ri ka somangat le foron tier ae ri tiu u ini, i tekentu. ");
INSERT INTO bjp_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Aunbiing laulaumet na matanfuntih ka famangat Pol isi in orek, Pol ka sotih ke ka tarah, “Ia usum le na ifuun e bet o kiis arae tom nagogon ken fanu tikii na falifu igii, pesu ia ka laes isi orek kale iau na matam. ");
INSERT INTO bjp_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","O tom ifasi on tafe u le i sangful ini u sau e biing pakanini, ia la ta una Ierusalem isi lotu. ");
INSERT INTO bjp_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Fanu ae ri tiu iau, biil ri tafe ta iau le ia fapue turan tikas awii na Felun Tunmapek, le ia fapti ta ti fabalkut na foron felun lotu, le na ti fatpoton maleh, biil. ");
INSERT INTO bjp_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma biil ifasi rin fatekentu foron orek ae ri tiu iau ini. ");
INSERT INTO bjp_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Isau le ian fas wo le, ia lotu la unaisa God ken foron tama kemem ke ia mi la tom na Sal ke Kumguui ae ri use u le i lotu famfabal. Ia unune na foron tier tikii ae ri siit ta u na Buk na Nagogon ke na Buk ken foron Profet. ");
INSERT INTO bjp_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ma unune kiak lo God ifasi sabin arae fanu igii, le God in fapti fafis fanu rokap turan fanu laulau tina minet. ");
INSERT INTO bjp_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Pesu, ia totof rakrakai la tom isi liu kiak in tortores na mata God ke na matan fanu sabin. ");
INSERT INTO bjp_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Na ifuun e bet, biil ia kiis na Ierusalem, pesu ia ka fis isi ta fafen usuf fanu kiak ae ri lauu ke iak ta foron fafen sabin usuf God. ");
INSERT INTO bjp_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Aunbiing ri tafe iau na Felun Tunmapek, ia ka fafuu fafis ta iau. Biil ti fanu fuun turang ke biil ia fatapiek ti fabalkut. ");
INSERT INTO bjp_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Isau le fale fan Iudaia tina falifu na Eisia ri tinaiwa. Male imel e tier rin tiu iau ini, in rokap le ri tom rin la uga ma rik tiu iau na matam. ");
INSERT INTO bjp_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Male biil, ke fanu igii rik use famalal tier laulau arafa ri tafe u lo iau, aunbiing ia ti ta na matan foron famfamu ken fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Awii ri tiu iau ngan ini nenge orek kiak, aunbiing ia ti ta na matri ma ia ka perek aragii, ‘Ia ti na nagogon na matmi igii, wara le ia unune na apaptifis.’” ");
INSERT INTO bjp_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks i usum rokap na Sal ke Kumguui, pesu ka famange ri, ke ka put kakte u. Ka fas ri aragii, “Aunbiing kabisit Lisias in tapiek, ke iak tel wolwol kiak mang.” ");
INSERT INTO bjp_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ke ka fas famfamu ken foron tom fapaket isi rin luun Pol na kamkabet, isau le gong ri ta tara tatawin usuf i, rin somangat pes foron tala tom isi rin laum u ma rik ta sani i dar u. ");
INSERT INTO bjp_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Fale biing namih, Feliks ru lamansilik e Darusila, ae i nenge fafnan Iudaia ru ka tapiek. Feliks ka fawuun isi Pol ke ka ongen orek kia na sinangun unune lo Karisito Iesu. ");
INSERT INTO bjp_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aunbiing Pol i famam orek isi sinang ae i tortores, sinangun nagogon fakasi wo tom ke nagogon ke God ae in tapiek, Feliks ka sokeh ke ka tarah, “Ifasi ta bii igii. La mang. Na ti fale biing ia sengsegeng, ke iak fawuun isi wo.” ");
INSERT INTO bjp_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","I wol sabin le Pol in ta fakum ti pitkalang sing i, isi ik fasuu u, pesu ka famam fawuun isi, ke ru ka orek turim. ");
INSERT INTO bjp_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nami na iwu e bet, Porsius Festus ka kiliis Feliks. Isau le, Feliks i ier isi falaes fan Iudaia, pesu biil tom i fasuu Pol tina kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ituul e biing nami na tapiek ke Festus na falifu ae, ka la tina Sisaria una Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Foron laulaumet na pris turan foron famfamu ken fan Iudaia, ri ka tapiek sing i ke ri ka fas u ini foron tier ae ri tiu Pol ini. ");
INSERT INTO bjp_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ke ri ka piispiis u isi in mais ri ma ik wuun ufu Pol una Ierusalem. Ri use u arae, wara le ri ka puput ta isi rin siimete u na ninla kia. ");
INSERT INTO bjp_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus ka kiliis ri aragii, “Pol in kiis na kamkabet tom na Sisaria, ma ia sabin fatat ian fis unaiwa. ");
INSERT INTO bjp_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","In rokap male ti fale famfamu kimi rin la turang, isi rik use sani ae ri tiu kaltu ae ini, male ka tel fager ta ti tier.” ");
INSERT INTO bjp_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus ka kiis pes iwal, le i sangful e biing biitom tura ri, namih, ka pu una Sisaria. Na biing namih, ka kep nian kiiskiis sala una nagogon ke ka fawuun isi Pol isi in ti na mata. ");
INSERT INTO bjp_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Aunbiing Pol ka tapiek, fan Iudaia ae ri filaupu ta tinbae na Ierusalem, ri ka ti kawil u. Ri ka tiu u ini ifuun e orek laulau, isau le biil ri use ti tier una fatatawin foron orek kiri. ");
INSERT INTO bjp_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ke Pol ka orek kale u aragii, “Biil ia tel fager ta ti tier na nagogon ken fan Iudaia, le na Felun Tunmapek, le usuf Sisar.” ");
INSERT INTO bjp_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus i ier le in falaes fan Iudaia ke ka tara sing Pol aragii, “Arafah, o ier le on fis ubae na Ierusalem isi ok ti na nagogon na matang na foron tier igii ri tiu wo ini?” ");
INSERT INTO bjp_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pol ka kiliis u aragii, “Igii ia ka ti mang na matan nagogon ke Sisar, ma i tortores le rin nagogon iau aga. Biil ia tel fager ta ti tier ulon fan Iudaia, arae wo tom o usum rokap lo. ");
INSERT INTO bjp_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Male ia tel fager ta ti tier ae ifasi ian met lo, ke biil ia soke isi ian met. Male foron tier ae fan Iudaia igii ri tiu iau ini biil i tekentu, ke biil tikas ifasi in ta ufu iau usuf ri. Ia sising le Sisar tom in ongen sani ae ri tiu iau ini.” ");
INSERT INTO bjp_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Aunbiing Festus ka faorek tikii ta foron tom nagogon kia, ka tarah, “Igii o ka sising ta le on la usuf Sisar, ke ian ta ufu wo usuf Sisar.” ");
INSERT INTO bjp_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Fale biing namih, king Agripa ru e Bernis ru ka tapiek na Sisaria isi run ta orek an laes kiruh usuf Festus. ");
INSERT INTO bjp_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Aunbiing ri ka kiis pes ta ifuun e biing aiwa, Festus ka fas king ini ususe lo Pol, aragii, “Imel e nenge kaltu igii ae Feliks i luun ta u na kamkabet. Ma igii, i kiis biitom na kamkabet. ");
INSERT INTO bjp_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aunbiing ia la ta una Ierusalem, foron laulaumet na pris turan foron famfamu ken fan Iudaia ri ka fas iau ini foron tier ae ri tiu u ini, ke ri ka sising iau le ian nagogon u isi ik met. ");
INSERT INTO bjp_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Ia ka fas ta ri le biil e sinangun fan Rom le rin nagogon foes tikas isi ik met. Famu, in ti ta bii na nagogon turan fanu ae ri tiu u, isi i sabin ik orek kale u koseng foron tier ae ri tiu u ini. ");
INSERT INTO bjp_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Aunbiing ri la turang uga, biil ia ta dolon aunbiing sing ri. Na biing nami sau, ia ka kiis na nian kiiskiis salang una nagogon ke ia ka fas ri isi lame fakau kaltu igii. ");
INSERT INTO bjp_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Isau le, aunbiing fanu ae ri tiu u ri apti isi orek, biil ri tiu u ini ti sinang laulau, ae ia wol le rin use u. ");
INSERT INTO bjp_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ri tiu u sau ini fale tier na matngan lotu kiri, ke ini nenge kaltu ae ka met tah, asa e Iesu, ae Pol i use u le ka liu fis. ");
INSERT INTO bjp_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Biil ia usum le arafa ian im tafe wara arae, pesu ia ka sising u le in somangat isi ik la una Ierusalem, isi iak nagogon u aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Isau le aunbiing ka sising ta le Sisar in nagogon u, ia ka fas ri le in kiis biitom na kamkabet, papang na biing ian wuun u usuf Sisar.” ");
INSERT INTO bjp_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ke Agripa ka tara sing Festus aragii, “Ia sabin ia ier le ian ongen kaltu igii.” Ke Festus ka kiliis u aragii, “Lumen on ongen u.” ");
INSERT INTO bjp_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Na biing namih, Agripa ru e Bernis ru ka tapiek ma ru ka ges ini foron rokap na kilkiliis. Ru ka kau na felun nagogon turan foron famfamu ken foron tom fapaket ke foron famfamu tina maleh ae. Ke Festus ka fawuun isi Pol ke ri ka lame fakau u. ");
INSERT INTO bjp_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ke Festus ka tarah, “King Agripa, ke gam tikii igii naismem, gam par kaltu igii! Fan Iudaia tikii, ri sising ta iau na Ierusalem ke aga sabin na Sisaria isi ian nagogon u. Ma ri ka perek le, biil in liu, in met ta tom. ");
INSERT INTO bjp_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ia tafe u le biil i tel fager ta ti tier ae ifasi in met lo, isau le, iwara sau ka sising ta le Sisar in nagogon u, pesu ia ka ier le ian wuun u una Rom. ");
INSERT INTO bjp_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Isau le biil ia usum le ususe arafa ian siit u usuf Sisar, lon kaltu igii. Pesu, ia ka fasoti u na matmi, ke na matam, King Agripa, isi gamek diik faikis u isi ik mel e tier ian siit papte u. ");
INSERT INTO bjp_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Wara ia wol le biil i rokap le ian wuun foes ti kaltu ae i kamkabet usuf Sisar, ma biil ti rokap na orek una famalal sani ae ri tiu u ini.” ");
INSERT INTO bjp_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ke Agripa ka tara sing Pol aragii, “Ia somangat ufu wo isi ok orek kale wo tom.” Pol ka sangal ke ka tipes orek kale u aragii, ");
INSERT INTO bjp_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, igii ia laes kanaka isi ti na matam, isi orek kale iau na sani ae fan Iudaia ri tiu iau ini. ");
INSERT INTO bjp_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Wara le o usum rokap na matngan sinangu kemem fan Iudaia ke sani ae keme fapue la kuna. Pesu ia ka sising o isi on kiis fofo ma ok ongen fakasi iau. ");
INSERT INTO bjp_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Fan Iudaia tikii ri usum rokap na liu kiak, tipes u na aunbiing ia kalalik ta na maleh tutus kiak ke bae sabin na Ierusalem. ");
INSERT INTO bjp_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ri ka usum ta lo iau na dolon aunbiing. Male ri ier isi, ke ifasi rin fas o le ia nenge Farasi, ae keme misuut rokap la na sinangun lotu kimem. ");
INSERT INTO bjp_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ma igii ia ka ti na nagogon, wara ia unune na falimlim ae pakanini God i tel ta u usuf foron tubutamat kemem. ");
INSERT INTO bjp_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nenge sangful ini u e mat kimem ri lotu la unaisa God na foron siat ke na foron wor tikii, wara le ri nene isi falimlim ae ik suut. King, iwara sau na unune igii, ke fan Iudaia ri ka tiu iau. ");
INSERT INTO bjp_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Isi sani gam ka wol le God biil ifasi in fapti fafis foron minet? ");
INSERT INTO bjp_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Iau sabin ia tof tikii ta foron sal una fapu asa Iesu tina Nasaret. ");
INSERT INTO bjp_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ke ia tel ta u sabin arae bae na Ierusalem. Foron laulaumet na pris ri ta rakrakai usuf iau, ke ia ka luun ifuun e fanu kalkaluu na kamkabet. Ma aunbiing ri siimete ri, ia sabin ia somangat. ");
INSERT INTO bjp_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ifuun e aunbiing ia kau la na foron felun lotu isi ta fangungut usuf ri, ke ia ka fangongos ri la isi rin orek laulau ulo Iesu. Ia ngaliaf la ulo ri ma ia la la sabin una fale maleh keskes isi ta fangungut usuf ri. ");
INSERT INTO bjp_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Na nenge ninla kiak sabin, foron laulaumet na pris ri ta rakrakai usuf iau ke ri ka wuun iau una Damaskas. ");
INSERT INTO bjp_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","King, na siat tuntun, aunbiing ia toltole sal la, ia ka par nenge malal tina kukulii, i barang kanaka na matan pisiih ma ka popos kawil iau turan fanu ae ri la turang. ");
INSERT INTO bjp_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kemem tikii keme ka luut una nanal, ke ia ka ongen kinen tikas i tara sing iau na orek Ibru aragii, ‘Sol, Sol, isi sani o ka ta fangungut usuf iau? O ta fangungut usuf o tom aunbiing o fapaket turang.’ ");
INSERT INTO bjp_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ke ia ka diik u aragii, ‘Kumguui, wo seh?’ Ke Kumguui ka kiliis iau aragii, ‘Ia Iesu ae o famam ta fangungut sing iau. ");
INSERT INTO bjp_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kang, ok sotih. Ia tapiek sing o, wara le ia tim pes ta wo arae nenge tom foim ke nenge tom fafamalal na sani o ka par ta u lo iau ke na sani ian finngas wo ini. ");
INSERT INTO bjp_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ian fofonoi lo wo koseng fanu kiam ke koseng fanu sabin ae biil ri fan Iudaia. Ma iak wuun o usuf ri, ");
INSERT INTO bjp_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","isi ok sapeng na matri, ke rik tamikis koseng kubunor una malal ke koseng rakrakai ke Satan usuf God, isi God ik pa ufu foron sinang laulau kiri ma isi ik mel e salri turan fanu ae ia ka fakalkaluu ta ri aunbiing ri unune lo iau.’ ");
INSERT INTO bjp_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Pesu, King Agripa, biil ia ongen fabulwar na parpar tina kukulii. ");
INSERT INTO bjp_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ia fafas famu tom usuf fan Damaskas, namih, na Ierusalem ke na falifu tikii na Iudaia ke usuf fanu sabin ae biil ri fan Iudaia. Ia fafas le rin sokiliis liu kiri, ke rik tamikis usuf God ma rik finngas u na sinangu ri le ri ka sokiliis liu tah. ");
INSERT INTO bjp_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","I sau e wara ae fan Iudaia ri ka luse iau awii na palgan ubiif kale Felun Tunmapek ke ri ka totof isi siimete iau. ");
INSERT INTO bjp_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Isau le God i lupes ta iau papang igii, ma igii ia ka ti na matam ke ia ka fafamalal usuf fanu foes ke usuf piran fanu sabin. Ia use foron tier sau ae Moses turan foron profet ri use ta u le in tapiek. ");
INSERT INTO bjp_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ri use u le Mesaia in kalsakai fangungut ke ik apti fis famu tina minet ma ik fafas ini malal usuf fanu kia tom, fan Iudaia, ke usuf fanu sabin ae biil ri fan Iudaia.” ");
INSERT INTO bjp_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Aunbiing i famam orek kale u biitom, Festus ka perek ulo aragii, “Pol o ka talos tah. Tara na tasum kiam ka fatalos wo mang.” ");
INSERT INTO bjp_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pol ka kiliis u aragii, “Festus, kiiskiis kiam i laumet, biil ia talos. Sani ia use u i tekentu ma imel e kamtina. ");
INSERT INTO bjp_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King i usum rokap na foron tier igii, pesu ifasi ian famalal u usuf i. Ia usum le ka ongen ta orek na foron tier tikii igii, wara le biil i tapiek sau na ti songno, biil. ");
INSERT INTO bjp_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agripa, arafah, o unune sabin lon foron profet? Ia usum le o unune.” ");
INSERT INTO bjp_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ke King Agripa ka tara sing Pol aragii, “Be, o wol le ifasi on fatel wolwol kiak na fatuklin aunbiing sau, isi iak unune lo Karisito?” ");
INSERT INTO bjp_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol ka kiliis u aragii, “Taftawa le na fatuklin aunbiing le na dolon aunbiing, ia sising le God biil in sokiliis wo keskes sau, biil. In sokiliis ri tikii sabin ae ri ongen iau igii, isi gamek tapiek arae iau, isau le biil rin kabet gam ini foron sen.” ");
INSERT INTO bjp_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","King ka apti turan famfamu na matanfuntih ae, Bernis ke fanu tikii ae ri kiis ta tura ri. ");
INSERT INTO bjp_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Aunbiing ri suu tina fel ae, ri ka orek usuf temtem tikii lo ri tom aragii, “Kaltu igii biil i tel fager ti tier ae ifasi in met kuna, le in kamkabet isi.” ");
INSERT INTO bjp_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa ka fas Festus aragii, “Ifasi rik fasuuh ta kaltu igii tina kamkabet, male biil in sising ta isi Sisar in nagogon u.” ");
INSERT INTO bjp_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Aunbiing ri ka use ta u le kemen wof na nenge sip una falifu na Itali, ri ka ta ufu Pol turan fale fanu sabin ae ri kamkabet una liman nenge kabisit ken foron tom fapaket, asa e Julius, i neng lon foron tom fapaket ke Sisar Augustus. ");
INSERT INTO bjp_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Keme ka wof na nenge sip tina Adramitium ae in masah na foron salan masa na foron maleh tole kiin na falifu na Eisia. Aunbiing keme ka la, nenge kaltu tina falifu na Masedonia na maleh na Tesalonika tinaiwa tura kemem, asa e Aristarkus. ");
INSERT INTO bjp_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Na biing namih, keme ka masah na Saidon. Julius ka mais Pol, ke ka somangat ufu isi in la una aisan foron tala, isi rik lupes u ini sani i dar u. ");
INSERT INTO bjp_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Keme ka wof na sip sabin tinaiwa, ke keme ka filau mumun na bit na Saiprus, wara le kif i kufkufe tina famu lo kemem. ");
INSERT INTO bjp_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Aunbiing keme ka filau ta na kasap na Silisia ke Pamfilia, keme ka masa na Mira na falifu na Lisia. ");
INSERT INTO bjp_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Aiwa kabisit ken foron tom fapaket ka tafe nenge sip tina Aleksendria ae in filau una Itali, ke ka fawof kemem lo. ");
INSERT INTO bjp_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ifuun e biing keme filau fofo sau, wara le i ngangaten kanaka isi kemen tapiek na Kinidus. Kif i kufkufe tina famu lo kemem, pesu biil ifasi kemen filau tortores. Keme ka filau mumun na bit na Krit fatat isi Salmone. ");
INSERT INTO bjp_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Keme ka rarat sau, wara le kif i rakrakai kanaka biitom, ke keme ka tapiek na nenge falifu ri foteng u ini Rokap na Matan Warngansau, fatat isi maleh na Lasea. ");
INSERT INTO bjp_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Keme ka kiis dolo ta aiwa, ma ninla kimem tole palgantes ka laulau kanaka mang tom, wara le Biingen Fafel ka rop tah. Ke Pol ka fanau ri aragii, ");
INSERT INTO bjp_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Fanu ri, ia par u le ninla kirer mang tinaga in laulau kanaka. Sip turan foron tier tikii ae na palga in laulau ke liu kirer sabin.” ");
INSERT INTO bjp_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Isau le kabisit ken foron tom fapaket biil i ongen pes sani Pol i use u. I mi tom na orek ke kiapten turan taman sip. ");
INSERT INTO bjp_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Falifu ae keme masah lo, biil e falifu rokap una masah na foron funiil ae maleh i mir la. Pesu, ifuun tom lo kemem, ri ka use u le kemen la tom una Foiniks isi kemek kiis aiwa na foron funiil ae falifu i mir la. Salan masah ae, i kiis na Krit na falifu ae pisiih i sup la lo. ");
INSERT INTO bjp_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Aunbiing rifrif na taubar ka tapiek, ri ka wol le ka rokap na aunbiing mang una filau, pesu ri ka dat foron angga ke keme ka rarat na bit na Krit. ");
INSERT INTO bjp_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Isau le biil i sawin, ke nenge tara kif ka aptih, ri foteng u ini mata lames, ma ka kufkufe tina bit ae. ");
INSERT INTO bjp_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Tara kif ae ka papam na baban sip ma ka ngangaten kanaka isi sip in filau tortores, pesu keme ka mi sau namin kif. ");
INSERT INTO bjp_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Aunbiing keme filau mumun na nenge fabiro bit ae ri foteng u ini Kauda, ka ngangaten ulo kemem isi kemen luun fakasi mon ae sip i datdat u la. ");
INSERT INTO bjp_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Aunbiing ri ka dat fatatkau ta u, ri ka lin fapu foron finau una piklin sip ke ri ka diit papte u. Ri ka binbin sabin tarama kif ka lin famasa sip una mas fatat Sartis, pesu ri ka ruf foron sel, isi sip ik bok tom namin kif. ");
INSERT INTO bjp_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Na biing namih, kif ae ka lala rakrakai mang tom, pesu ri ka lin fasuu fale tier ae sip i kep u. ");
INSERT INTO bjp_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Na fatuul u e biing, foron tom foim na sip ri ka lin fasuu fale tier tom tina sip una palgantes. ");
INSERT INTO bjp_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Aunbiing ae, pisiih turan keltot biil i popos na ifuun e biing ma tara kif ae biil i to mangeh, pesu ka pongpong e wol kimem, keme wol le biil mang kemen liu. ");
INSERT INTO bjp_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ifuun e biing biil mang ri ien, pesu Pol ka soti na famu lo ri ma ka tarah, “Fanu ri, male gamen wong ta sing iau le gong kere apti ta koseng Krit, ke biil ti tier aragii in falaulau kerer turan sip ke foron tier biil in mangmangal. ");
INSERT INTO bjp_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Isau le igii ia fas gam, gong gam sokeh, wara le biil tikas lo gam in fiu, biil. Sip sau in laulau. ");
INSERT INTO bjp_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nangen na wor, nenge angelo ke God ae i tim pes ta iau ke ia lotu la unaisa, i soti na babang ");
INSERT INTO bjp_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ma ka tarah, ‘Pol gong o sokeh. On ti tom na nagogon na mata Sisar. Ma na famais ke God, fanu tikii ae na sip rik liu, wara na sising kiam.’ ");
INSERT INTO bjp_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Pesu, fanu ri, gong gam sokeh, wara le imel e unune kiak lo God ma in tapiek tom arae i fas ta iau. ");
INSERT INTO bjp_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Isau le keren fentole lunmaket tom na ti bit.” ");
INSERT INTO bjp_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na fasangful ini fet u e wor, kif i famam kufe kemem biitom una palgantes ae ri foteng u ini Adria. Na fapot, foron tom foim na sip ri ka wol le keme ka bok fatat mas. ");
INSERT INTO bjp_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ri ka fatof maut ini nenge finau. Ke ri ka par u le ifasi arae iwu e sangful e kipti. Nami ri ka fatof pes u sabin ke ri ka tafe u le ifasi arae nenge sangful ini lim e kipti. ");
INSERT INTO bjp_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Foron tom foim na sip ri ka sokeh, tarama keme ka baunge foron fat, pesu ri ka fapu ifet e angga tinawii na min sip ma ri ka sising isi pisiih ik susupiek sape. ");
INSERT INTO bjp_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Foron tom foim na sip ri ka totof isi rin fin tina sip, pesu ri ka fapu mon tinawii na palgan sip una palgantes. Ri ka garan le rin fapu fale angga tina matan sip. ");
INSERT INTO bjp_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pol ka fas kabisit ken foron tom fapaket turan foron tom fapaket aragii, “Male fanu igii biil rin kiis aga na sip, ke biil ifasi gamen liu.” ");
INSERT INTO bjp_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ke foron tom fapaket ri ka ting ufu foron finau ae i pose papte ta mon ma ri ka suaf ufu ka luut una palgantes. ");
INSERT INTO bjp_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na biingbiing saksak, Pol ka sising ri tikii isi rin ien. Ke ka fas ri aragii, “Na nenge sangful ini fet e biing gam kiis ini sokeh ma biil gam ien ti tier. ");
INSERT INTO bjp_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Pesu, ia ka sising gam isi gamen ien. Gamen ien isi gamek liu. Biil tikas lo gam, in mangmangal e ti olo tina paklu.” ");
INSERT INTO bjp_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Aunbiing ka use ta u arae, ka kep fale beret, ka fotrokap lo usuf God na matri tikii, ka sibik u ke ka tipes ien. ");
INSERT INTO bjp_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ri tikii ri ka kep rakrakai sing Pol ke ri sabin ri ka ien. ");
INSERT INTO bjp_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wewes lo kemem tikii aiwa na sip, ifasi arae iwu e mar ini fit e sangful ini won. ");
INSERT INTO bjp_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Aunbiing ri ka ien mas tah, ke ri ka lin fasuu foron wit una palgantes, isi ik malalah e sip. ");
INSERT INTO bjp_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Na biingbiing, biil ri iliim falifu ae, isau le ri par nenge falifu i kau ma imel e rokap na kononkiin lo, pesu ri ka wol le, male ifasi, ke rik famasa sip aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ri ka ting famut foron finau na foron angga ke ri ka sok ufu una palgantes. Ri ka kiit foron finau sabin ae i pose papte fiis ae ri ikis sip la ini. Namih, ri ka fafen sel ae na famu, isi kif ik kufe sip una kiin. ");
INSERT INTO bjp_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Isau le sip ae ka baunge nenge sun kiin ae na palgantes, ke matan sip ka liil aiwa ma biil ifasi in gigin. Isau le min sip ae ka tipes tamrabat, wara na pirpiran tuun. ");
INSERT INTO bjp_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Foron tom fapaket ri ka puput isi rin siimete fanu ae ri kamkabet una tikale ri, isi gong ri kakes masah ke gong ri fin. ");
INSERT INTO bjp_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Isau le kabisit ken foron tom fapaket ka ier tom isi Pol in liu, pesu ka tikale ri isi gong mang ri tel fasuut puput kiri. Ka fas fanu ae ifasi rin kakes, isi rin wof famu una palgantes ma rik kakes masah. ");
INSERT INTO bjp_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ma fal ri ka bok ini foron dangan au ke foron dangan sip una mas. Ri tel u arae, ke ri tikii tom ri ka masa rokap na kiin. ");
INSERT INTO bjp_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Aunbiing keme ka masah rokap tah, keme ka usum mang le asan bit ae, e Malta. ");
INSERT INTO bjp_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Fanu tina bit ae ri ka finngas rokap na sinang usuf kemem. Ri ka somangat pes kemem tikii ke ri ka map nenge tara yiif, wara le us i luut ma falifu i mir. ");
INSERT INTO bjp_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol ka potek turim fale akan au, ma aunbiing ka luun u na yiif, nenge sii ka fin suuh, wara na tuntun na yiif, ke ka ngaet fafat na lima. ");
INSERT INTO bjp_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Aunbiing fanu tina bit ae ri par sii ae i kulkulik na lima, ri ka tara sing temtem tikii tom lo ri aragii, “Awii ngan kaltu igii i nenge tom sisiimete? Taftawa le biil i kong na palgantes, isau le god ae i kiliis fafis sinang laulau la, biil i somangat ufu isi in liu.” ");
INSERT INTO bjp_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Isau le Pol ka pakte ufu sii ae una palgan yiif ma biil i kalsakai ti fangungut. ");
INSERT INTO bjp_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Fanu ae, ri ka wol le fo in sut, le biil in sawin ke ik met, isau le ri ka nene pane le in met ma ri ka par pane sabin le ti tier in tapiek lo, pesu ri ka kiliis wolwol kiri ma ri ka tara le, i nenge god. ");
INSERT INTO bjp_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Awii na fatat falifu ae keme masah lo, imel e nenge sun nanal ken tara kaltu tina bit ae, asa e Publius. Ka somangat pes kemem una fel kia ma ka fofonoi rokap lo kemem na ituul e biing. ");
INSERT INTO bjp_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tama Publius i borong ini sasem, i gogor ma ka balsel. Pol ka laum u ma aunbiing i sising, ka luun iun lima na olo ma ka faliu u. ");
INSERT INTO bjp_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nami na tier ae i tapiek tah, foron sasem tikii na bit ae ri ka la usuf i ke ri tikii ri ka liu. ");
INSERT INTO bjp_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ri ka finngas tara bulat kiri usuf kemem, ma aunbiing keme ka geges isi la, ri ka fen foes kemem ini foron tier ae keme dar u. ");
INSERT INTO bjp_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Keme kiis aiwa pes ituul e funiil. Namih, keme ka wof sabin na nenge sip ae i masah ta na bit ae, na foron funiil ae falifu i mir la. Sip ae tina Aleksendria, ae imel e tantanwan iwu e god awii na famu lo, ru iwun kasang. ");
INSERT INTO bjp_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Keme ka masah na Sirakus ke keme ka kiis pes ituul e biing aiwa. ");
INSERT INTO bjp_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Keme ka aptih tinaiwa ke keme ka tapiek na Regium. Na biing namih, taubar ka aptih, ke na fatuul u e biing, keme ka tapiek na Puteoli. ");
INSERT INTO bjp_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Keme ka tafe fale tom unune aiwa, ke ri ka sising kemem isi kemen kiis tura ri na ifit e biing. Namih, keme ka tapiek na Rom. ");
INSERT INTO bjp_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Aunbiing foron tom unune na Rom ri ongen ususe lo kemem, ri ka la tina foron maleh tapak isi tafe kemem na falifu ae ri foteng u ini Salan La Turim na Apius ke na maleh ae ri foteng u ini Ituul e Felun Borong. Aunbiing Pol i par ri, ka fotrokap usuf God ma ka kep rakrakai. ");
INSERT INTO bjp_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Aunbiing keme ka tapiek na Rom, ri ka somangat ufu Pol isi in mel keskes na nenge fel, ma nenge tom fapaket ik parpar kale u. ");
INSERT INTO bjp_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ituul e biing namih, Pol ka tawi turim foron famfamu ken fan Iudaia aiwa. Aunbiing ri ka kiis turim tah, Pol ka fas ri aragii, “Foron tuaklik, taftawa le biil ia tel fager ta ti tier ini fanu kirer, le na matngan sinangun foron tubutamat kerer, isau le ri ka luse iau na Ierusalem ke ri ka ta ufu iau usuf fan Rom. ");
INSERT INTO bjp_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Fan Rom ri ka ier isi rin fasuu ufu iau, wara le biil ri tafe ti tier laulau ae ifasi rin siimete iau kuna. ");
INSERT INTO bjp_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Isau le aunbiing fan Iudaia biil ri somangat isi, ia ka sising le ian ti na nagogon na mata Sisar. Isau le biil imel e orek kiak una falaulau fafis fanu kiak. ");
INSERT INTO bjp_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","I e wara ia ka sising isi ian par gam, ke iak orek tura gam. Ia kiis na kamkabet, wara na unune kiak lo ier ae kerer fan Israel kere nene isi.” ");
INSERT INTO bjp_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ri ka kiliis u aragii, “Biil biitom keme kep ti leta tina Iudaia na ususe lo wo. Ke biil biitom tikas i la tinaiwa isi ik ususe sing kemem, le fas kemem ini ti orek laulau lo wo. ");
INSERT INTO bjp_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Isau le keme ier isi ongen ti wolwol kiam, wara keme usum le fanu na falifu tikii ri famam orek laulau na matngan lotu ae o fafas la ini.” ");
INSERT INTO bjp_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ri ka put nenge biing isi rin kiis turim tura Pol. Na biing ae, ka fuun mang tom e fan Iudaia ri ka tapiek na falifu ae Pol i kiis la lo. Tipesu na biingbiing, papang na efef, Pol i pupuk ke ka famalal ri ini Matanfuntih ke God. Ke ka totof isi sokiliis wolwol kiri, isi rik unune lo Iesu, tina nagogon ke Moses ke tina Buk ken foron profet. ");
INSERT INTO bjp_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Fal ri ka unune na sani Pol ka use ta u, isau le fal biil. ");
INSERT INTO bjp_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ri ka famam fapue fis tom ini ri ke ri ka tipes sararah, aunbiing ka use ta farfarop na orek kia le, “Tanwa Kalkaluu i orek tekentu ta usuf foron tubutamat gam, aunbiing i fas ta profet Aisaia aragii, ");
INSERT INTO bjp_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘La usuf fanu ae, ma ok fas ri aragii, Gamen ongne, ma gamek ongne, isau le biil tom gamen malal. Gamen par, ma gamek par, isau le biil tom gamen iliim ti tier. ");
INSERT INTO bjp_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Wara le balan fanu igii ka kutkut tah, biil ifasi rin wong ini balbalu ri ke matri ka kut tah. Tarama ri ka par ini matri, ke ri ka wong ini balbalu ri, ke ka malal e wolwol kiri, ke rik fis usuf iau ma iak faliu ri.’ ");
INSERT INTO bjp_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","“Pesu, ia ier isi gamen usum le fafaliu ke God ka la ta usuf fanu ae biil ri fan Iudaia, ma rin ongen u.” ");
INSERT INTO bjp_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Na iwu e bet kuruur, Pol i kiis na fel kia tom ae i fiil u la, ma i somangat pes fanu tikii ae ri la la isi par u. ");
INSERT INTO bjp_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","I kep balamas tom aunbiing i fafas ini Matanfuntih ke God ke ka fausum ri ini Kumguui Iesu Karisito, ma biil ti tier i tikale u. ");
INSERT INTO bjp_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ia Pol, ia nenge fafauun ke Karisito Iesu. I kam pes ta iau arae nenge aposel, ke ka tim pes ta iau isi fafas ini Rokap na Fafas. ");
INSERT INTO bjp_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Rokap na Fafas ae, pakanini tom i falimlim ta ini, ke foron profet kia ri ka siit papte ta u na Buk na Gogoh. ");
INSERT INTO bjp_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","I e fafas lo ke Kalalik. Na pununfo i sikinting lo king Dewit, ");
INSERT INTO bjp_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","isau le God i famalal u le Iesu Karisito, Kumguui kirer, i e Kalalik ke God, aunbiing i fapti fafis ta u tina minet ini rakrakai ken Tanwa Kalkaluu. ");
INSERT INTO bjp_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Lo Karisito sau, God ka mais kemem, ke keme ka tapiek aposel isi kemek sik asa, aunbiing kemen fafas usuf fanu tikii ae biil ri fan Iudaia, isi rik unune lo ke rik mi lo. ");
INSERT INTO bjp_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Gam sabin, gam ae na palgan fanu ae God ka kam pes ta ri arae fanu ke Iesu Karisito. ");
INSERT INTO bjp_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ia sisiit usuf gam tikii na Rom ae God i ier kanaka isi gam, ma ka kam pes ta gam isi gamen tapiek fanu kalkaluu kia. Famais ke siaroh usuf gam, sing God Tama kerer, ke sing Kumguui Iesu Karisito. ");
INSERT INTO bjp_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tier famu, lo Iesu Karisito, ia fotrokap lo God kiak isi gam tikii, wara le fanu tikii na piklinbat ri ongen ususe na unune kimi. ");
INSERT INTO bjp_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","God, ae ia foim la sing i ini balang tikii, aunbiing ia fafas la ini Rokap na Fafas ulo ke Kalalik, i usum le fitliu ia wolpes gam la ");
INSERT INTO bjp_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","na foron sising tikii kiak. Ma igii, ia ka sising usuf God le, male na wolwol kia, ke ik sapeng mang na sal salang isi iak la unaismi. ");
INSERT INTO bjp_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ia lala ier le ian par gam, isi iak ta ti fafen una farakrakai tanwa gam, ");
INSERT INTO bjp_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","isi gam, ke iau sabin, kerek farakrakai faliu kerer ini unune kirer. ");
INSERT INTO bjp_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Foron tuaklik, ia ier le gamen usum le, ifuun e biing ia puput ta le ian la unaismi, isi iak par fuan foim kiak na liu kimi, arae sau ia par fuan foim kiak sing fale fanu sabin ae biil ri fan Iudaia. Isau le ka pang igii, ia riris le ian la. ");
INSERT INTO bjp_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tara foim kiak tom una fafas usuf fan Grik, turan fale fanu sabin, ke usuf fanu ae imel e tasum kiri, turan fanu sabin ae biil ti tasum kiri. ");
INSERT INTO bjp_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","I e wara, ia ka lala ier tom isi fafas sabin ini Rokap na Fafas usuf gam fan Rom. ");
INSERT INTO bjp_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Biil ia to matlawen kunan Rokap na Fafas, wara le i e rakrakai ke God una faliu fanu tikii ae ri unune. Famu usuf fan Iudaia, ke usuf fanu sabin ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Wara le Rokap na Fafas i famalal sal ae God i foteng kerer le keren tortores lo na mata. Kere tapiek tortores na sinangun unune keskes sau. Arae ri siit ta u na Buk na Gogoh aragii, “Se sau i unune, God in foteng u le i tom tortores, ke in liu.” ");
INSERT INTO bjp_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","God i finngas ngaliaf kia tinbae na kukulii ulon fanu ae biil ri bulat lo ma ri ka tel sinang laulau, ma na foron sinang laulau kiri, ri ka tikale tekentu. ");
INSERT INTO bjp_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Wara le tier ae ifasi rin usum lo, lo God, i malal sau usuf ri. God tom i famalal ta u usuf ri. ");
INSERT INTO bjp_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Wara le, tipes u na tanwaran fakfakiis, aunbiing fanu ri par foron fakfakiis, ifasi rin usum na sinangu God, taftawa le biil ri par sinangu. Ifasi rin usum le rakrakai kia i kiis fitliu, ma rin usum le i e God. Pesu, biil ti sal ken fanu una fakawe ufu. ");
INSERT INTO bjp_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Taftawa ri usum lo God, isau le biil ri ta memeh usuf i arae i e God, ke biil sabin ri fotrokap la usuf i, biil. Ma sinangun wolwol fofoes ka kuruung ri, ma ri ka arae foron talos, ae balri ifuun ini kubunor. ");
INSERT INTO bjp_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ri tom, ri tara le imel e rokap na wolwol kiri, isau le ri tapiek arae foron talos. ");
INSERT INTO bjp_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Biil ri lotu unaisa God ae i liu fitliu, ma ifuun ini memeh, biil. Ri ka lotu bin unaisan tantanwan fanu ae rin met sau, ke unaisan tantanwan foron man, foron muruuw ke foron tier ae ri kakak la. ");
INSERT INTO bjp_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Pesu, God ka sok ufu ri, isi rik tel foron sinang ae i duh, namin sani ae ri tom ri kalkal isi, ke rik tel foron tier an famatlawen faliu na pununfo ri. ");
INSERT INTO bjp_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ri ka sokiliis fafausum tekentu lo God una lem. Ke ri ka lotu ma ri ka fapu ri na piklin foron tier sau ae God i fakiis ta ri, isau le biil bin rik lotu unaisa Tom Fakfakiis, ae fitliu ususefages in la usuf i ma biil ti farfarop lo. Amen. ");
INSERT INTO bjp_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","I e wara, God ka sok ufu ri isi rik mi na foron wolwol laulau ae ifasi rin matlawen kuna. Kelefin kiri sabin, ri ka sokiliis tortores na sinangun fakekel, ma ri ka borong fis tom ini ri. ");
INSERT INTO bjp_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Fanu tamat sabin arae, ri ka sok ufu tortores na sinangun fakekel turan kelefin, ma ka apti tom e balri isi ri tom, ke ri ka borong fis tom ini ri. Ma aunbiing ri tel matngan sinangun famatlawen arae, ri tom rin kep fafis fangungut kunan sinang laulau ae ri tel ta u. ");
INSERT INTO bjp_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nenge tier sabin, biil ri wol le i temin tier isi rin usum lo God, pesu God ka sok ufu wolwol kiri ka laulau, isi rik tel foron tier ae biil i tortores isi rin tel u. ");
INSERT INTO bjp_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Liu kiri ifuun ini foron matngan sinang tikii ae biil i tortores, sinang ae i laulau, sinangun akalemok ke sinangun ememse fal. Ri fuun ini bala laulau, sinangun sisiimete, sinangun tempaek fanu, ri ka famfabal ke ri ka fafating. Ri ka orek kumkum, ");
INSERT INTO bjp_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ke ri ka use falaulau fal. Ri ka ememse God, ri ka falaumet paklu ri, ri ka sik asri tom, ri ka orek kamgas. Ma ri ka wolpes marmarsan sal una tel sinang laulau. Ri foron tom ongen fabulwar sing foron temri ke tinri. ");
INSERT INTO bjp_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ma biil ti rokap na wolwol sing ri, biil ri tel fasuut falimlim la kiri, biil ri ier isi fal, ke biil ri mais fal. ");
INSERT INTO bjp_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ma taftawa ri usum ta na tortores na nagogon ke God le, fanse ri tel matngan sinang arae, i tortores tom le rin met, isau le ri tongon tel u tom e foron sinang ae. Ma biil i sau ae, biil. Ri somangat sabin ini fal ae ri tel u. ");
INSERT INTO bjp_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Pesu, wo ae o sir matan fal la, biil ti sal kiam una fakawe. Sani o sir matan fal ini, wo tom o sir kuna, wara le wo sabin o tel u la e foron sinang arae. ");
INSERT INTO bjp_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Kere usum le nagogon ae God in tel u ulon fanu ae ri tel matngan sinang arae, i tortores. ");
INSERT INTO bjp_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ma o kaltu sau. Aunbiing o sir matan fal isi sinang ae ri tel u, ma wo tom o tel u la, ke arafah, o wol le ifasi on alfe nagogon ke God? ");
INSERT INTO bjp_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","God i finngas ta tara rokap kia usuf o, ma biil i sangar na nagogon o isi foron sinang laulau kiam, ke biil i usum na tuktuke wo. Arafah, o puris u e rokap kia? Biil o par failiim u le i ta aunbiing usuf o isi on sokiliis liu kiam? ");
INSERT INTO bjp_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Isau le balam i sorokai kanaka, ma biil o sokiliis liu kiam, pesu, wo tom o ka pakne turim ngaliaf ke God ulo wo, una aunbiing tortores na nagogon kia in tapiek malal. ");
INSERT INTO bjp_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","God in nagogon temtem tikii, namin sani tom ae i tel ta u. ");
INSERT INTO bjp_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","God in ta liu fitliu usuf fanse ae ri tongon tel rokap na sinang, isi rik kep memeh, as laumet, ke liu ae biil ti farfarop lo. ");
INSERT INTO bjp_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Isau le fanse ae ri wol lo ri tom, ma biil ri mi na tekentu, ma ri ka mi na foron sinang laulau, ngaliaf turan balkut ke God in kiis na olri. ");
INSERT INTO bjp_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","In mel e fangungut turan tatawin in tapiek lon fanu tikii ae ri tel sinang laulau, famu usuf fan Iudaia, ke namih, usuf fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Isau le God in ta memeh, as laumet, ke siaroh usuf fanu tikii ae ri tel rokap na sinang, famu usuf fan Iudaia, ke namih, usuf fanu ae biil ri fan Iudaia. ");
INSERT INTO bjp_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Wara le sinangu God i fafasih sau usuf fanu tikii. ");
INSERT INTO bjp_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Fanu tikii ae biil ri usum na nagogon ke Moses ma ri ka tel sinang laulau, rin fiu tom. Ke fanu tikii ae ri usum na nagogon ae ma ri ka tel sinang laulau, God in nagogon ri tom namin nagogon ae. ");
INSERT INTO bjp_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Wara le biil e fanu ae ri ongen nagogon ke Moses, ri tortores na mata God, biil. Fanu sau ae ri misuut na nagogon ae, God in foteng ri le ri foron tom tortores. ");
INSERT INTO bjp_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Fanu ae biil ri fan Iudaia, biil ri usum na nagogon ke Moses, isau le aunbiing ri tel rokap na sinang arae nagogon i use u, i finngas u le nagogon i kiis na dah lo ri. ");
INSERT INTO bjp_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Matngan fanu arae, i malal le sani ae nagogon ke Moses i use u i kiis na balri. Aunbiing ri tel sinang laulau, le sinang ae i rokap, wolwol kiri tom i famalal u le ri sir le biil. ");
INSERT INTO bjp_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Na biingen nagogon, God in ta ufu foim na nagogon usuf Iesu Karisito isi ik nagogon wolwol kum ken fanu, arae tom ia use u la, aunbiing ia fafas ini Rokap na Fafas. ");
INSERT INTO bjp_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Igii, ian fas wo ae o tara la le o nenge sikin Iudaia: O wol le foron nagogon ke Moses ifasi in lupes o, ma o ka orek kamgas la le, wo ke God. ");
INSERT INTO bjp_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","O usum na sani God i ier isi, ma o iliim sani i tortores, wara le o ka kep ta fafausum na foron nagogon. ");
INSERT INTO bjp_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ma na wolwol kiam, o tara la le, o arae kaltu ae i fatangtangne foron kut, ma arae malal ken fanu ae ri kiis na kubunor. ");
INSERT INTO bjp_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ke o wol la sabin le, wo arae nenge kaltu una patrai foron talos, arae tom fafausum ken berberat puun, wara le o ka kep ta foron rokap na tasum turan orek tekentu tina foron nagogon. ");
INSERT INTO bjp_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","O ae o fausum fal la, ke isi sa biil ok fausum fafis wo tom? O ae o fafas la le, “Gong gam sisii,” arafah, biil o sisii la? ");
INSERT INTO bjp_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","O ae o tara la le, “Gong gam tel sinangun puur,” arafah, biil o tel sinangun puur la? O ae o ememse foron god famfabal la, arafah, biil o suksukuum la tina felun tunmapek ken foron god famfabal? ");
INSERT INTO bjp_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","O ae o orek kamgas la le o usum na foron nagogon, o fapuh asa God, aunbiing o lek foron nagogon kia. ");
INSERT INTO bjp_vpl VALU