﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjn_vpl;
CREATE TABLE bjn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjn_vpl WRITE;
INSERT INTO bjn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pamugaan, Allah manjadiakan langit wan bumi. ");
INSERT INTO bjn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Bumi baluman bapotongan wan puang. Bumi dibungkus banyu wan kadada tarang di mana-mana. Ruh Allah malayang-layang di atas banyu. ");
INSERT INTO bjn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Lalu Allah bapirman, “Baadalah tarang!” Lalu tarang tu ada. ");
INSERT INTO bjn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah maanggap baik wan katuju malihat tarang nang diadaakan-Nya tu. Lalu dipisahakan-Nya ai tarang tu lawan kadap. ");
INSERT INTO bjn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tarang tu dingarani-Nya “siang”, nang kadap tu dingarani-Nya “malam”. Imbah malam, lalu baisukan. Itu pang hari nang panambaian. ");
INSERT INTO bjn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Pada hari nang kadua, Allah bapirman, “Baadalah kubah hawa ditangah-tangah samunyaan banyu gasan mahalat banyu nang ada di atas lawan banyu nang ada di bawah.” ");
INSERT INTO bjn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Lalu ada ai kubah hawa tu. ");
INSERT INTO bjn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kubah hawa tu dingarani-Nya “angkasa”. ");
INSERT INTO bjn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Pada hari nang katalu, Allah bapirman, “Bakumpul, samunyaan banyu nang ada di bawah langit sakira talihat tanah nang karing”. Lalu kalihatan ai tanah nang karing tu. ");
INSERT INTO bjn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tanah nang karing tu dingarani-Nya 'daratan', sadangkan kumpulan banyunya dingarani-Nya 'lautan'. Allah maanggapnya baik wan katuju malihatnya. ");
INSERT INTO bjn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Lalu Allah bapirman, “Balacukan ja di tanah samunyaan tatumbuhan nang babigi wan papuhunan nang babuah buah nang babigi sakira papuhunan tu tatarusan ada di bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","13","Lalu balacukan ai tatumbuhan wan papuhunan di tanah tu. Allah maanggapnya baik wan katuju malihatnya. ");
INSERT INTO bjn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Pada hari nang kaampat, Allah bapirman “Baadalah matahari, bulan, wan bintang-bintang gasan mamisahakan siang lawan malam, wan manjadi tanda nang manunjukakan bamulanya wan baahirnya musim, hari, wan tahun-tahun ");
INSERT INTO bjn_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","wan jua gasan manarangi bumi.” Ada ai lalu matahari, bulan wan bintang-bintang tu. ");
INSERT INTO bjn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Nang taganal, yaitu matahari, gasan manarangi siang. Nang tahalus, yaitu bulan, gasan manarangi malam, wan diadaakan-Nya jua bintang-bintang. ");
INSERT INTO bjn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Samunyaan nang itu diandak Allah di atas langit gasan manarangi bumi, ");
INSERT INTO bjn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","19","yaitu gasan manarangi siang wan malam, wan gasan mamisahakan tarang lawan kadap. Allah maanggapnya baik wan katuju malihatnya. ");
INSERT INTO bjn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Pada hari nang kalima, Allah bapirman, “Baadalah sagala macam makhluk hidup nang bakariapan di banyu, wan sagala macam makhluk hidup nang bahalar nang batarabangan di angkasa.” ");
INSERT INTO bjn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Maka dijadiakan-Nya binatang-binatang laut nang ganal-ganal wan sagala macam makhluk hidup nang bakunyungan, nang bakariapan dalam banyu, wan sagala macam makhluk hidup nang bahalar. Allah maanggapnya baik wan katuju malihatnya. ");
INSERT INTO bjn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","23","Allah mambarkahi samunyaan nang itu wan manyuruh makhluk nang hidup di banyu supaya baranakan, batambah banyak sampai mahibaki lautan, wan manyuruh makhluk-makhluk nang bahalar supaya batambah banyak. ");
INSERT INTO bjn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Pada hari nang kaanam, Allah bapirman, “Baadalah di bumi sagala macam makhluk nang bagarak, binatang inguan, binatang nang marayap, wan sagala macam binatang liar.” Lalu ada ai samunyaan nang itu. ");
INSERT INTO bjn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Imbah manjadiakan samunyaan nang itu, Allah maanggap baik wan katuju malihat samunyaannya. ");
INSERT INTO bjn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Lalu Allah bapirman, “Nah, Kami handak manjadiakan manusia nang kaya gambaran Kami. Maka manusia pacangan bakuasa atas iwak-iwak, burung-burung, binatang-binatang inguan, wan samunyaan binatang nang bagarak di bumi, pokoknya manusia pacangan bakuasa atas saluruh bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Maka Allah manjadiakan manusia tu nangkaya gambaran-Nya, nangkaya gambaran Allah saurang, dijadiakan-Nya manusia, lalakian wan babinian. ");
INSERT INTO bjn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Allah mambarkahi bubuhannya wan bapirman ka bubuhannya: “Baanakcucu wan batambah banyak, hibaki wan kuasai bumi! Kuasai iwak-iwak wan burung-burung, wan sagala binatang nang bagarak di bumi. ");
INSERT INTO bjn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nah, gasan makanan bubuhan ikam, kubariakan samunyaan tatumbuhan nang babigi wan pupuhunan nang buahnya babigi di saluruh bumi” ujar Allah bapirman ka manusia. ");
INSERT INTO bjn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","“Tapi gasan sagala binatang nang banyawa di bumi wan sagala burung di angkasa, kubariakan sagala tatumbuhan hijau gasan makanannya” ujar Allah bapirman. Lalu jadi ai nang kaya itu. ");
INSERT INTO bjn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Imbah malihat samunyaan nang diadaakan-Nya tu, Allah katuju wan maanggapnya bujur-bujur baik banar. ");
INSERT INTO bjn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kaputingannya, pada hari nang kaanam tu, tuntungan ai langit, bumi lawan sagalaan isinya. ");
INSERT INTO bjn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Imbah manuntungakan gawian-Nya tu, baistirahat ai Allah pada hari nang kapitu. ");
INSERT INTO bjn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Karna pada hari nang kapitu Allah sudah ampih bagawi manjadiakan samunyaan nang sudah diadaakan-Nya tu, maka hari nang kapitu tu, dibarkahi wan dikudusakan Allah. ");
INSERT INTO bjn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nang kaya itu pang kisahnya langit wan bumi wayah dijadiakan-Nya. Wayah Allah Al Khalik manjadiakan bumi wan langit, ");
INSERT INTO bjn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","baluman ada lagi kakumpaian di bumi wan baluman ada jua papuhunan nang mancungulan di padang lantaran Allah Al Khalik baluman manurunakan hujan ka bumi, wan baluman ada jua urang nang manggawi tanah tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tapi wayah itu ada banyu kaluar matan tanah nang mambasahi saluruh bumi. ");
INSERT INTO bjn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Allah Al Khalik maulah manusia nang panambaian matan tanah lalu ditiup-Nya pahinakan nang mambariꞌi hidup ka dalam hidungnya, lalu hidup ai manusia tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ALLAH Al Khalik manyiapakan Taman Eden di bumi di subalah timur. Disitu pang diandak-Nya manusia nang diulah-Nya tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ALLAH Al Khalik manumbuhakan bamacam-macam papuhunan nang bagus-bagus gasan dilihat lawan nang buahnya nyaman-nyaman gasan dimakan. Di tangah-tangah taman tu, ada dua rapun puhun. Sarapun puhun nang mambari hidup. Sarapunnya puhun nang mambari pangatahuan sual napa nang baik wan napa nang jahat. ");
INSERT INTO bjn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ada sungai nang maalir matan daerah Eden nang mambariꞌi banyu gasan taman tu. Imbah kaluar matan situ, tabagi manjadi ampat sungai. ");
INSERT INTO bjn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Allah Al Khalik maulah manusia tu bagana di Taman Eden tu gasan bausaha wan maharagunya. ");
INSERT INTO bjn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","“Samunyaan pupuhunan dalam taman ini kawa haja ikam makan buahnya sakahandak hati ikam ");
INSERT INTO bjn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kacuali puhun nang mambari pangatahuan tantang napa nang baik wan napa nang jahat, jangan ikam makan buahnya, sualnya amun ikam mamakannya, ikam musti mati, hari itu jua” ujar ALLAH Al Khalik bapirman ka manusia tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","“Kada baik amun manusia tu saurangan haja. Aku handak maulahakan pasangan nang cocok gasan mangganiꞌi inya” ujar ALLAH Al Khalik bapirman. ");
INSERT INTO bjn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ALLAH Al Khalik maulah matan tanah sagala binatang hutan wan sagala burung di angkasa. Lalu samunyaan dibawa-Nya ka manusia tu, gasan malihat nangkaya apa manusia tu mangaraninya. Ngaran nang dibariakan manusia tu, itu pang nang manjadi ngaran tiap-tiap makhluk hidup tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Lalu manusia tu mangarani sagala binatang inguan, sagala burung di angkasa, wan sagala binatang hutan. Manusia tu sadar amun samunyaan binatang bapasang-pasangan, lalakian wan babinian. Tagal gasan inya saurang, baluman ada pasangannya. ");
INSERT INTO bjn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Maka ALLAH Al Khalik maulah manusia tu guring janak. Parahatan inya guring tu, dicabut ALLAH Al Khalik sabilah tulang rusuknya. Lalu ditukupi-Nya pulang lawan daging. ");
INSERT INTO bjn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Matan tulang rusuk nang dicabut ALLAH Al Khalik tu, diulah-Nya saikung babinian, lalu imbah manusia tu bangun guring, babinian tu dihadapakan Allah ka manusia tu. ");
INSERT INTO bjn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","“Nah ini pang, tulang matan tulangku, wan daging matan dagingku. Inya pacangan disambat babinian sualnya inya diambil matan lalakian” ujar manusia tu baucap. ");
INSERT INTO bjn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Lantaran itu pang, lalakian pacangan maninggalakan abahnya wan umanya lalu basatu lawan bininya, makanya kaduduanya manjadi satu. ");
INSERT INTO bjn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Manusia wan bininya tu, kaduduanya batilanjang bulat, tagal biar nangkaya itu bubuhannya kada marasa supan. ");
INSERT INTO bjn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nah, di antara samunyaan binatang di darat nang diadaakan ALLAH Al Khalik, ular adalah binatang nang paliciknya. “Bujurlah Allah manangati bubuhan ikam mamakan samunyaan bubuahan di taman ini?” ujar ular manakuni babinian tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","“Kada nang kaya itu pang! Samunyaan buah matan pupuhunan nang ada di taman ini, bulih haja kami makan ");
INSERT INTO bjn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","kacuali buah puhun nang tumbuh di tangah-tangah taman ini. Kami ditangati Allah mamakannya. Manjapainya haja gin, kada bulih! Kaina kami mati jar-Nya” ujar babinian tu manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","“Bah, bubuhan ikam tu kada pacangan mati pang! ");
INSERT INTO bjn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tapi bubuhan ikam pacangan manjadi nangkaya Allah sualnya bubuhan ikam pacangan tahu napa nang baik wan napa nang jahat. Allah gin sudah tahu jua nang itu. Makanya Inya manangati bubuhan ikam mamakan buah nang itu” ujar ular mambunguli babinian tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Babinian tu malihat amun buah puhun tu pina bagus-bagus kalihatannya, wan pina nyaman-nyaman, amun dimakan. Lawan pulang, buah puhun tu pina mambari kapingin lantaran bisa maulah urang batambah pintar. Diputiknya ai buah tu, lalu diigutnya. Diunjukinya jua ka lakinya nang ada di higanya. Lalu umpat ai jua lakinya mamakan buah tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Imbah itu, langsung supan ai bubuhannya sualnya bubuhannya hanyar haja sadar amun bubuhannya tu batilanjang bulat. Lalu bubuhannya maayam daun puhun ara gasan manukupi aurat bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Wayah hari naung, manusia wan bininya tu mandangar ALLAH, Al Khalik, datang di taman itu. Lalu basambunyian ai bubuhannya di sasala pupuhunan di taman tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","“Ui, Dam, lagi di mana ikam?” ujar ALLAH Al Khalik mangiaw lalakian nang panambaian tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“Pas mandangar Pian ada di sini, takutan ai ulun sualnya ulun batilanjang. Lantaran itu pang, ulun lalu basambunyi” ujar manusia tu manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Siapa garang nang mamadahi ikam amun ikam tu batilanjang? Bisa bisa ikam sudah mamakannyalah, buah puhun tu nang kutangati ikam mamakannya?” ujar ALLAH Al Khalik batakun. ");
INSERT INTO bjn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","“Babinian nang Pian bawaakan gasan ulun tu nah, inya nang manjulungi ulun buah nang itu, makanya ulun makan” ujar manusia tu manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","“Kanapa maka ikam sampai balaku nang kaya itu?” ujar ALLAH Al Khalik manakuni babinian tu. “Ular tu nah nang mambunguli ulun sampai ulun tamakan buah puhun tu” ujar babinian tu manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","“Lantaran ikam balaku nang kaya itu, takutuk ikam di antara samunyaan binatang inguan wan binatang hutan. Lawan parut ikam tu pang, ikam pacangan manjalar wan pacangan tamakan dabu tanah saumur hidup ikam. ");
INSERT INTO bjn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aku pacangan maulah ikam wan babinian tu bamusuhan, wan antara juriat ikam wan juriat babinian tu bamusuhan jua. Juriat babinian tu pacangan maramukakan kapala ikam, wan ikam pacangan mamatuk tumit juriatnya” ujar ALLAH Al Khalik baucap ka ular tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Lalu ujar ALLAH Al Khalik ka babinian tu, “Aku pacangan maulah ikam ngalih wayah ikam batianan wan banyak maharit sakit wayah ikam baranak. Ikam handak manguasai laki ikam, tapi malahan inya nang pacangan bakuasa atas ikam.” ");
INSERT INTO bjn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Lalu ujar ALLAH Al Khalik ka lalakian tu, “Ikam hakun maumpati pandiran bini ikam wan mamakan buah puhun nang sudah kutangati. Maka lantaran itu pang, tanah ini Ku-kutuk. Ikam pacangan ngalih wan uyuh bacari rajaki matan tanah ini saumur hidup ikam. ");
INSERT INTO bjn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Rukam wan kumpai baduri nang pacangan tumbuhan. Napa nang ikam tanam di padang pacangan manjadi makanan ikam. ");
INSERT INTO bjn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pacangan bapaluh leher ikam mancari makan sampai ikam babulik pulang manjadi tanah sualnya matan tanah tu, ikam diulah. Lantaran ikam tu matan tanah, ikam pacangan babulik pulang ka tanah” ujar ALLAH Al Khalik baucap ka lalakian tu. ");
INSERT INTO bjn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Manusia tu mangarani bininya 'Hawa' lantaran inya tu pang nang pacangan manjadi paninian samunyaan manusia. ");
INSERT INTO bjn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lalu ALLAH Al Khalik maulah baju matan kulimbit binatang gasan manusia wan bininya. Lalu dipurukakan-Nya baju tadi ka bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","“Nah, manusia tu sudah manjadi nang kaya salah satu dari Kita sualnya bubuhannya sudah tahu sual napa nang baik wan napa nang jahat. Maka wayah ini jangan sampai inya mamutik buah matan puhun nang mambari hidup tu, lalu mamakannya, lalu hidup salawasan ai kaina inya” ujar ALLAH Al Khalik bapirman. ");
INSERT INTO bjn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Maka bubuhannya disuruh bajauh ulih ALLAH Al Khalik di Taman Eden tu sakira manggawi tanah nang matan tanah tu inya diambil. ");
INSERT INTO bjn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Imbah manyuruh manusia tu bajauh matan Taman Eden tu, Allah Al Khalik manugasakan babarapa ikung malaikat manjaga di subalah timur taman tu. Diandak-Nya jua pedang nang banyala-nyala wan bapusing-pusing manyambar-nyambar ka sagala arah gasan manjaga jalan masuk ka puhun nang mambari kahidupan tu. ");
INSERT INTO bjn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Imbah itu, Adam guring lawan Hawa, bininya. Batianan ai bininya tu, lalu inya maranakakan saikung anak lalakian nang dingaraninya Kabil. “Lawan partolongan Allah ta alla, aku sudah baulihi saikung anak lalakian” ujar Hawa. ");
INSERT INTO bjn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Lalu, diranakakannya pulang Habil, adingnya Kabil. Habil bainguan kambing domba. Sadangkan Kabil bakabun. ");
INSERT INTO bjn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kada lawas, Kabil mambawa sapalih matan hasil kabunnya jadi kurban parsambahan gasan basukur wan mahurmati Allah. ");
INSERT INTO bjn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Lalu Habil mambawa korban parsambahan jua, nang dibawanya tu bahagian nang pambaiknya matan anak panambaian kambing dombanya nang disumbalihnya. Maka sanang ai Allah lawan Habil wan parsambahannya, ");
INSERT INTO bjn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","tapi kurban parsambahan Kabil kada diherani-Nya. Lalu panas ai hati Kabil wan muhanya marangut. ");
INSERT INTO bjn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Lalu Allah baucap lawan Kabil, “Kanapa maka hati ikam pina panas wan muha ikam pina marangut? ");
INSERT INTO bjn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Amun kalakuan ikam tu bujur, musti Kutarima ikam wan kurban parsambahan ikam. Tapi amun kalakuan ikam tu kada bujur, maka dosa sudah mahadang handak manguasai ikam, tapi ikam tu pang nang samustinya manguasainya.” ");
INSERT INTO bjn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","“Bil, kita ka padang kah?” ujar Kabil baucap lawan Habil, adingnya. Wayah baduaan ada di padang, bakakajutan Kabil mamangkung Habil, lalu dimatiꞌinya, adingnya tu. ");
INSERT INTO bjn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","“Bil, mana si Habil, ading ikam tu?” ujar Allah batakun lawan Kabil. “Mana ulun tahu? Ulun ni lain tukang jaganya” ujar Kabil manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","“Sudah kaliwaran kalakuan ikam ni. Darah ading ikam bakuciak matan tanah bahadu lawan Aku. ");
INSERT INTO bjn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Takutuk ikam. Lantaran itu, tanah nang muntungnya manganga manarima darah ading ikam, nang ikam matiꞌi tu, kada manarima ikam lagi. Ikam Kusuruh bajauh matan banua ini. ");
INSERT INTO bjn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bilanya ikam manggawi tanah tu, maka tanah tu pacangan kada tapi kawa lagi mambawa hasil gasan ikam. Ikam pacangan diburu-buru, makanya ikam kaina bapindah-pindah tarus di bumi” ujar Allah. ");
INSERT INTO bjn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","“Hukuman ulun ni barat banar. Ulun kada sanggup manyandangnya. ");
INSERT INTO bjn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kaya apa yo ulun ni? Wayah ini jua, Pian manyuruh ulun bajauh matan banua ini, amun kaya itu bujur-bujur tapisah ai ulun lawan Pian. Ulun ni kaina jadi urang nang diburu-buru wan bapindah-pindah tarus. Makanya siapa haja nang batamuan lawan ulun ni musti handak mamatiꞌi ulun” ujar Kabil lawan Allah. ");
INSERT INTO bjn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","“Kada pacangan nang kaya itu pang! Amun ada jua urang nang mamatiꞌi ikam, urang tu pacangan dibalas pitu kali lipat” ujar Allah lawan Kabil. Lalu Kabil dibari ciri ulih Allah sakira inya kada dimatiꞌi urang. ");
INSERT INTO bjn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Maka tulak ai Kabil maasingakan dirinya saurang matan hadirat Allah. Mulai wayah itu, inya kada kawa lagi bapandir langsung lawan Allah. Lalu inya bagana di banua nang bangaran Nod, di subalah timur Eden. ");
INSERT INTO bjn_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Lalu Kabil guring lawan bininya. Batianan ai bininya tu lalu maranakakan saikung anak lalakian nang dibari ngaran Henok. Lalu Kabil maulah sabuah kota nang dingaraninya Henok, nang kaya ngaran anaknya. ");
INSERT INTO bjn_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok tu abahnya Irad, Irad tu abahnya Mehuyael. Mehuyael tu abahnya Metusael. Metusael tu abahnya Lameh. ");
INSERT INTO bjn_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameh tu babini dua. Nang saikung bangaran Ada. Nang saikungnya lagi bangaran Zila. ");
INSERT INTO bjn_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Si Ada maranakakan Yabal. Yabal tu pang padatuan urang-urang nang bagana di tenda-tenda, nang gawiannya bainguan. ");
INSERT INTO bjn_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Adingnya Yabal tu bangaran Yubal. Yubal tu urang nang panambaian nang jadi pamain kecapi wan kuriding. ");
INSERT INTO bjn_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila maranakakan Tubal-Kain. Tubal-Kain tu urang nang panambaian jadi pandai wasi wan tambaga. Ading babiniannya bangaran Naama. ");
INSERT INTO bjn_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kadudua bini Lameh dikiaunya balalu inya baucap, “Ui, bini biniku, cuba dangarakan Abah bakisah: Ada saikung lalakian kumatiꞌi lantaran inya malukai aku. Lalakian nang anum tu kumatiꞌi lantaran inya mahantam aku sampai bangkak. ");
INSERT INTO bjn_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Amun nang mamatiꞌi Kabil harus dibalas pitu kali lipat, maka nang mamatiꞌi aku, harus dibalas pitu puluh pitu kali lipat.” ");
INSERT INTO bjn_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Lalu Adam guring pulang lawan bininya. Baranak ai pulang bininya tu. Anak lalakian tu dingarani Set ulih bini Adam sualnya inya baucap, “Ulun dibari Allah pulang anak lalakian gasan pangganti Habil nang dimatiꞌi Kabil, kakanya.” ");
INSERT INTO bjn_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Imbah itu, gasan Set diranakakan jua saikung anak lalakian lalu dingaraninya Enos. Wayah itu, hanyar urang bamula mamakai ngaran ALLAH sambil manyambah ALLAH. ");
INSERT INTO bjn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ALLAH malihat kalakuan manusia nang bakaliwaran jahatnya di bumi. Sagala kahandak hati bubuhannya bilang nang jahat-jahat haja. ");
INSERT INTO bjn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Maka manyasal ai Allah lantaran manjadiakan manusia di bumi. Inya tasinggung banar. ");
INSERT INTO bjn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Lalu Allah bapirman, “Aku handak mambinasaakan manusia nang sudah Kujadiakan, tamasuk samunyaan binatang wan burung-burung. Sualnya Aku manyasal banar sudah manjadiakan bubuhannya.” ");
INSERT INTO bjn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tagal Nuh dibariꞌi rahmat ulih Allah. ");
INSERT INTO bjn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ini nah riwayat Nuh. Sidin tupang nang bujur urangnya wan kadada calanya di antara urang-urang nang hidup di jaman itu. Sidin tu parak banar lawan Allah. ");
INSERT INTO bjn_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Sidin baisi talu ikung anak lalakian nang bangaran Sim, Ham, wan Yapet. ");
INSERT INTO bjn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Tagal di mata Allah urang-urang nang lain samunyaannya jahat-jahat; di mana-mana hati bubuhannya kajam-kajam wan katuju bakakarasan. ");
INSERT INTO bjn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Allah manjanaki bumi. Sabujurannya bumi tu sudah rusak banar lantaran samunyaan makhluk kadada nang bujur hidupnya. ");
INSERT INTO bjn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Lalu Allah bapirman lawan Nuh, “Nuh, Aku handak mambinasaakan samunyaan makhluk di bumi sualnya bilang bakakarasan haja kalakuan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ulah gasan ikam lawan kulawarga ikam sabuah parahu matan kayu gofir. Parahu tu musti ikam ulah bapitak-pitak. Dampuli sabalah luar wan sabalah dalamnya sakira kada masuk banyu. ");
INSERT INTO bjn_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nang kaya ini nah ikam musti maulah parahu tu, panjangnya 133 meter, libarnya 22 meter, wan tingginya 13 meter. ");
INSERT INTO bjn_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ulahakan parahu tu hatapnya 44 sentimitir di atas tawing-tawingnya. Ulah parahu tu talu tingkat: bawah, tangah, wan atas. Imbah itu, bariꞌi lawang di tawing higanya. ");
INSERT INTO bjn_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Sabujurannya, Aku handak mandatangakan banyu baꞌah ganal wan hujan labat sampai sabumian tinggalam supaya matian samunyaan nang hidup wan banyawa di kulung langit. Sabarataan nang hidup di bumi pacangan matian. ");
INSERT INTO bjn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Sadangkan lawan ikam, Aku handak maadaakan parjanjian. Ikam, bini ikam, anak-anak lalakian ikam, lawan minantu-minantu ikam pacangan babuatan ka dalam parahu tu. ");
INSERT INTO bjn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Bawa ka dalam parahu tu samunyaan makhluk hidup, sapasang sapasang satiap janisnya sakira bubuhanya taharagu wan tatap hidup basama-sama lawan ikam. ");
INSERT INTO bjn_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Samunyaan binatang nang bagarak pacangan datangan sapasang sapasang ka ikam sakira bubuhannya taharagu wan tatap hidup. ");
INSERT INTO bjn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ikam Nuh-ai, bawa samunyaan nang kawa dimakan; kumpulakan gasan makanan bubuhan ikam wan binatang binatang tadi” ujar Allah bapirman ka Nuh. ");
INSERT INTO bjn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Lalu digawi Nuh ai samunyaan parintah Allah tu. Napa nang diparintahakan Allah, kaya itu pang nang digawi sidin. ");
INSERT INTO bjn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Lalu Allah bapirman lawan Nuh, “Ayu babuatan ka dalam parahu, ikam, bini ikam, anak-anak wan minantu-minantu ikam. Sualnya ikam haja nang Ku-lihat bujur di antara urang-urang di jaman ini. ");
INSERT INTO bjn_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Matan samunyaan binatang nang kada haram bawa pitu pasang, laki wan bini. Sadangkan binatang nang haram bawa sapasang-sapasang haja, laki wan bini. ");
INSERT INTO bjn_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kaya itu jua, satiap janis burung bawa pitu pasang, laki wan bini sakira kada habis di saluruh bumi. ");
INSERT INTO bjn_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sualnya pitu hari lagi Aku handak manurunakan hujan labat nang kada sing ampihan salawas ampat puluh hari ampat puluh malam, wan Aku handak mabinasaakan samunyaan makhluk nang sudah Kujadiakan di bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Lalu digawi Nuh ai samunyaan nang disuruhakan Allah ka sidin. ");
INSERT INTO bjn_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wayah banyu baꞌah ganal maninggalamakan bumi, umur Nuh anam ratus tahun. ");
INSERT INTO bjn_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Lantaran handak baꞌah tu, Nuh, bini sidin, lawan anak-anak sidin lawan minantu-minantu sidin babuatan ka dalam parahu tu. ");
INSERT INTO bjn_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Lalu datangan ai sapasang-sapasang matan samunyaan janis binatang nang kada haram lawan nang haram, burung-burung lawan samunyaan binatang nang marayap di bumi, ");
INSERT INTO bjn_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","babuatan ka parahu mandapati Nuh nang kaya nang disuruhakan Allah. ");
INSERT INTO bjn_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Imbah pitu hari, datang ai banyu baꞌah ganal nang maninggalamakan bumi. ");
INSERT INTO bjn_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Pas Nuh baumur anam ratus tahun, di bulan nang kadua, hari nang kapitu walas, tabungkasan samunyaan sumber-sumber banyu nang ada di dalam tanah. Banyu-banyu nang ada di langit gin saling darasan baguguran ka bumi. ");
INSERT INTO bjn_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Turun ai hujan nang sing labatan, kada sing ampihan ampat puluh hari ampat puluh malam. ");
INSERT INTO bjn_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Damintu jua, Nuh, bini sidin, lawan anak-anak sidin nang bangaran Sim, Ham, wan Yapet, lawan minantu-minantu sidin babuatan ka dalam parahu tu. ");
INSERT INTO bjn_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Umpat jua babuatan sagala janis makhluk nang hidup, sagala binatang liar, sagala binatang inguan, sagala janis binatang nang bahalar, lawan sagala janis binatang nang marayap. ");
INSERT INTO bjn_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Samunyaan nang banyawa datangan sapasang-sapasang babuatan ka dalam parahu tu mandapati Nuh. ");
INSERT INTO bjn_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nang babuatan tu laki bini satiap janis binatang, nang kaya disuruhakan Allah lawan Nuh. Imbah itu, ditukup Allah lawang parahunya. ");
INSERT INTO bjn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ampat puluh hari ampat puluh malam hujan labat sampai maninggalamakan bumi. Banyunya batinggi tarus lalu parahu tu timbul, taangkat tinggi matan tanah. ");
INSERT INTO bjn_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Banyunya batambah banyak, batinggi tarus manguasai bumi, lalu timbul ai parahu tu di atas banyu. ");
INSERT INTO bjn_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Banyunya daras banar batambah tarus sampai tinggalaman gunung-gunung nang tinggi nang ada di saluruh bumi. ");
INSERT INTO bjn_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Banyunya batinggi tarus sampai pitu miter tingginya di atas puncak-puncak gunung. ");
INSERT INTO bjn_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Maka matian ai sabarataan makhluk hidup nang banyawa, nang bahinak, nang bagarak di bumi, burung-burung, binatang liar, binatang inguan, sagala binatang nang marayap, nang bakariapan di bumi, tamasuk manusia jua. Maka Nuh haja nang masih hidup lawan samunyaan nang ada lawan sidin dalam parahu tu. ");
INSERT INTO bjn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Banyunya manguasai bumi, kada sing surutan salawas 150 hari. ");
INSERT INTO bjn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Allah mangganang Nuh lawan sagala binatang liar, wan sagala binatang inguan nang ada lawan sidin dalam parahu tu. Maka Allah maulah angin batiup di bumi nang maulah banyu basurut. ");
INSERT INTO bjn_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Sumber-sumber banyu nang di bawah tanah wan sumber-sumber banyu nang di langit disumpali. Lalu ampih ai hujannya. ");
INSERT INTO bjn_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Banyunya sasar basurut di bumi. Imbah 150 hari banyunya kada tapi tinggi lagi. ");
INSERT INTO bjn_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Dalam bulan nang kapitu, pada hari nang kapitu walas, parahu tu tagalang di pagunungan Ararat. ");
INSERT INTO bjn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Banyunya basurut tarus sampai bulan nang kasapuluh. Pada hari nang panambaian di bulan nang kasapuluh, talihat sudah puncak-puncak gunung. ");
INSERT INTO bjn_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Imbah ampat puluh hari, Nuh mambuka lalongkang nang diulah sidin di parahu tu. ");
INSERT INTO bjn_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Lalu dilapas sidin saikung burung gagak. Burung tu tarabang bulang bulik sampai banyunya bujur-bujur surut. ");
INSERT INTO bjn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Lalu Nuh malapas saikung burung dara gasan malihati kalu ai banyu sudah surut di bumi. ");
INSERT INTO bjn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tagal burung dara tu kada mandapati wadah gasan hinggap sualnya banyunya masih manukupi bumi. Maka babulik ai inya ka parahu. Nuh manyurung tangan sidin, lalu dibawa sidin masuk burungnya. ");
INSERT INTO bjn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Dihadangi sidin pitu hari lagi, lalu dilapas sidin pulang burung dara tu matan parahu. ");
INSERT INTO bjn_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wayah kamarian, burung dara tu babulik pulang ka wadah sidin, sakalinya di hujung patuknya ada salambar pucuk zaitun nang masih sigar! Maka tahu ai Nuh amun banyu sudah surut di bumi. ");
INSERT INTO bjn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dihadangi sidin pulang pitu hari lagi. Lalu dilapas sidin pulang burung daranya. Sakalinya, burung dara tu kada babulik pulang ka wadah sidin. ");
INSERT INTO bjn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Wayah Nuh baumur 601 tahun, pada hari nang panambaian dalam bulan nang panambaian, bumi bamula karing. Nuh mambuka hatap parahu tu lalu balilihat. Sakalinya tanahnya sudah karing. ");
INSERT INTO bjn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dalam bulan nang kadua, pada hari nang kadua puluh pitu tu, bumi sudah bujur-bujur karing. ");
INSERT INTO bjn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lalu, Allah bapirman lawan Nuh: ");
INSERT INTO bjn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Turunan ja matan parahu, ikam, lawan bini ikam, anak-anak ikam, lawan minantu-minantu ikam. ");
INSERT INTO bjn_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bawa turun jua samunyaan makhluk nang banyawa nang ada lawan ikam, burung-burung, binatang, wan sagala binatang nang marayap di bumi sakira bubuhannya mahibaki bumi, baranakan, wan batambah banyak di atas bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Maka turunan ai Nuh, bini sidin, anak-anak sidin, lawan minantu-minantu sidin. ");
INSERT INTO bjn_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sagala binatang liar, sagala binatang nang marayap wan sagala burung, pokoknya samunyaan nang bagarak di bumi turunan matan parahu tu manurut janisnya. ");
INSERT INTO bjn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Lalu Nuh manyusun batu manjadi mija gasan mambanam hewan kurban gasan mahurmati Allah. Diambil sidin babarapa ikung matan satiap janis binatang wan burung nang kada haram. Lalu diparsambahakan sidin manjadi kurban banaman di atas mija batu tadi. ");
INSERT INTO bjn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Allah mancium parsambahan nang harum tu lalu bapandir dalam hati-Nya, “Aku kada pacangan lagi mangutuk bumi lantaran manusia, biar bubuhannya bakahandak jahat mulai lagi anum. Aku kada pacangan lagi mahabisi samunyaan makhluk hidup nang kaya sudah Ku-binasaakan lawan banyu baꞌah ganal. ");
INSERT INTO bjn_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Salawas bumi masih ada, pacang ada tatarusan musim batanam wan mangatam, musim dingin wan musim panas, musim kamarau wan musim hujan, siang wan malam.” ");
INSERT INTO bjn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Lalu Allah bapirman lawan Nuh wan anak-anak sidin nang ada basama-sama lawan sidin, ");
INSERT INTO bjn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Sabujurannya, Aku maadaakan parjanjian lawan ikam wan juriat ikam ");
INSERT INTO bjn_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","lawan sagala makhluk hidup nang ada basama-sama lawan ikam, burung-burung, binatang inguan, binatang liar nang kaluar baimbaian lawan ikam matan parahu, artinya sagala binatang nang ada di bumi tu pang. ");
INSERT INTO bjn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ini nah parjanjian-Ku lawan ikam: tumatan wayah ini, Aku bajanji Aku kada pacangan lagi mahabisi sagala makhluk hidup wan kada pacangan lagi maninggalamakan bumi lawan banyu baꞌah ganal. ");
INSERT INTO bjn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Aku handak maandak balahindangku atawa palangiku di langit. Itu pang nang manjadi tanda jaminan parjanjianKu nang Kuadaakan antara Aku lawan ikam, lawan sagala makhluk hidup nang ada basama-sama lawan ikam turun-tamurun gasan salawasan. ");
INSERT INTO bjn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Amun Kudatangakan awan-awan di langit lalu talihat balahindang, ");
INSERT INTO bjn_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","maka Aku pacangan mangganang parjanjian-Ku nang sudah Kuadaakan lawan ikam wan sagala makhluk nang hidup, wan sagala nang banyawa. Kada pacangan ada banyu baꞌah ganal lagi nang mahabisi sagala makhluk nang hidup. ");
INSERT INTO bjn_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Amun balahindang tu ada di langit, maka Aku pacang malihatnya lalu mangganang parjanjian-Ku nang kakal antara Aku lawan sagala makhluk nang hidup nang ada di bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Allah bapirman pulang lawan Nuh, “Nah, itu pang tanda parjanjianKu nang Kuadaakan antara Aku lawan ikam wan sagala makhluk hidup nang ada di bumi.” ");
INSERT INTO bjn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","“Tinggalakan haja banua ikam, rumah kuitan ikam wan dangsanak-dangsanak ikam. Tulak ja ka banua nang pacang Kutuduhakan lawan ikam. ");
INSERT INTO bjn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Aku pacangan maulah juriat ikam manjadi suku nang ganal, mambarkahi ikam wan jua maulah ngaran ikam dikatahui wan dihurmati urang banyak. Malalui ikam, Aku pacangan mambarkahi urang lain jua. ");
INSERT INTO bjn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aku pacangan mambarkahi urang-urang nang baik lawan ikam. Sadangkan, nang jahat lawan ikam, pacangan Kukutuk. Wan malalui ikam samunyaan suku-suku di bumi pacangan Kubarkahi” ujar Allah bapirman lawan Abram. ");
INSERT INTO bjn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram maasi lawan napa nang disuruhakan Allah. Tulak ai sidin matan kuta Haran, baampah ka banua Kanaꞌan. Dibawa sidin bininya, nang bangaran Sarai, wan kamanakannya nang bangaran Lot. Dibawa sidin jua samunyaan harta banda, binatang-binatang inguannya, wan sasuruhan-sasuruhan nang sidin kulihi wayah di kuta Haran. Lalu sampaian ai bubuhannya di banua Kanaꞌan. Wayah itu, sidin baumur pitung puluh lima tahun. ");
INSERT INTO bjn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram bajalan tarus di banua nitu sampai ka puhun ganal di wadah nang bangaran More, nang parak kampung Sikhem yaitu wadah ibadah. Wayah itu, urang-urang Kanaꞌan bagana di situ. ");
INSERT INTO bjn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Allah manampaiakan diri-Nya lawan Abram. “Banua Kanaꞌan ini pacangan Kubariakan gasan juriat ikam” ujar Allah bapirman ka Abram. Lalu Abram manyusun batu manjadi mija wadah mambanam binatang kurban gasan mahurmati Allah nang sudah manampaiakan diri-Nya lawan sidin. ");
INSERT INTO bjn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Imbah itu, Abram manarawang. Wayah sidin manarawang, sidin mandangar ucapan Allah. “Bram, jangan takutan! Aku ni pang nang malindungi wan manulungi ikam. Aku pacangan mambarkahi ikam kaina” ujar Allah. ");
INSERT INTO bjn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","“Ya ALLAH, Tuhan ulun, sabujurannya, gasan apa jua Pian mambariꞌi napa-napa gasan ulun sualnya ulun kaina pacangan kada baisi anak jua sampai ulun maninggal? Sasuruhan ulun, si Eliezer, urang Damsyik tupang, kaina nang mawarisi kasugihan ulun. ");
INSERT INTO bjn_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pian kada mambari ulun anak, maka sasuruhan ulun ai kaina, nang manjadi ahli waris ulun” ujar Abram manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","“Kada Bram ai, lain urang nang ini pang, tapi anak kandung ikam saurang nang pacangan manjadi ahli waris ikam kaina!” ujar Allah baucap pulang. ");
INSERT INTO bjn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Imbah itu, Allah mambawa Abram kaluar matan tenda. “Janaki pang ka langit! Rekeni bintang-bintang amun ikam kawa marekeninya. Saitu pang kaina banyaknya juriat ikam!” ujar Allah manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Lalu bujur-bujur parcaya ai Abram lawan napa nang dijanji'i Allah. Lantaran itu, Allah maanggap Abram tu urang nang bujur. ");
INSERT INTO bjn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Bini Abram, nang bangaran Sarai tu, kada sing anakan jua. Tagal, inya baisi saikung sasuruhan babinian urang Mesir nang bangaran Hajar. ");
INSERT INTO bjn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","“Pian tahu ai, kalo? Allah kada mambulihakan ulun baranak. Lantaran itu pang, kawini ja sasuruhan ulun tu. Kalo ai ulun kawa baulihi anak matan inya” ujar Sarai baucap lawan Abram. Abram akur haja lawan kahandak bininya tu. ");
INSERT INTO bjn_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Lalu disarahakan Sarai sasuruhannya tu lawan lakinya gasan jadi madunya. Wayah itu, sudah sapuluh tahun Abram bagana di banua Kanaꞌan. ");
INSERT INTO bjn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram guring bakumpul lawan Hajar. Lalu batianan ai Hajar. Tagal imbah Hajar tahu amun inya tu batianan, inya jadi wani lawan majikannya, Sarai. ");
INSERT INTO bjn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","“Imbah batianan, inya mahina ulun. Bujur ja ulun saurang nang manyarahakan inya ka Pian. Tapi wayahini inya wani lawan ulun, itu pang kasalahan Pian. Biar haja Allah nang mahakimi siapa nang bujur antara ulun wan Pian” ujar Sarai maniwas lakinya. ");
INSERT INTO bjn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“Inya tu sasuruhan ikam, kalo? Diapa-i ja inya sakahandak ikam napa nang ikam anggap baik” ujar Abram manyahut. Lalu bakajam ai Sarai lawan Hajar, sampai inya tajun maninggalakan majikannya. ");
INSERT INTO bjn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Lalu malaikat ALLAH manamuinya parak sumber banyu di padang pasir, yaitu di jalan nang baampah ka Syur. ");
INSERT INTO bjn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“Ui Hajar, sasuruhan Sarai, ikam matan mana wan handak ka mana?” ujar malaikat tadi. “Ulun tajun maninggalakan Sarai, majikan ulun” ujar Hajar manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","“Babulik ja ka majikan ikam. Biar ja inya balaku kajam lawan ikam, turuti ja napa nang kahandak inya. ");
INSERT INTO bjn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aku pacang manjadiakan juriat ikam banyak banar, sampai kada kawa direkeni lantaran saling banyakan” ujar malaikat Allah tadi. ");
INSERT INTO bjn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hajar manuruti suruhan malaikat wan babulik ka Sarai, lalu inya maranakakan saikung anak lalakian gasan Abram. Anak tu dingarani Ismail ulih Abram. ");
INSERT INTO bjn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Wayah itu, Abram baumur lapan puluh anam tahun. ");
INSERT INTO bjn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wayah Abram baumur sambilan puluh sambilan tahun, Allah manampaiakan diri-Nya lawan sidin. “Bram, Aku ni Allah Nang Mahakuasa, maasi ja lawan Aku wan lakuakan ja kahandakKu. ");
INSERT INTO bjn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Maka, Aku maadaakan parjanjian antara Aku lawan ikam, wan juriat ikam pacangan Kuulah jadi banyak banar” ujar Allah sambil batampai lawan Abram. ");
INSERT INTO bjn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Basujut ai Abram. ");
INSERT INTO bjn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nah, ini nah parjanjianku lawan ikam. Aku bajanji ikam pacangan manjadi padatuan banyak urang. ");
INSERT INTO bjn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Lantaran itu pang, ngaran ikam lain Abram lagi, kuganti jadi Ibrahim sualnya ikam sudah Kupilih jadi padatuan banyak urang. ");
INSERT INTO bjn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Juriat ikam pacangan Kuulah saling banyakan sampai manjadi urang-urang. Raja-raja gin pacangan baasal matan ikam jua. ");
INSERT INTO bjn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Aku maadaakan parjanjianKu lawan ikam wan juriat ikam turun-tamurun manjadi parjanjian nang kakal. Aku nang manjadi Tuhan ikam wan Tuhan juriat ikam” ujar Allah baucap pulang. ");
INSERT INTO bjn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","“Sarai bini ikam tu, jangan lagi ikam kiau Sarai. Bamula wayah ini, ngarannya jadi Sarah. ");
INSERT INTO bjn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Aku pacangan mambarkahinya. Malalui inya, ikam pacangan Kubari saikung anak lalakian. Malahan Sarah pacangan manjadi padatuan urang-urang. Raja-raja urang gin pacangan baasal matan juriat inya” ujar Allah baucap lawan Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Basujut ai Ibrahim lalu tatawa lantaran rasa kada mungkin. “Masih kawalah urang nang sudah baumur saratus tahun nang kaya aku ni baulihi anak? Lawan pulang, biniku sudah baumur sambilan puluh tahun. Mana kawa inya maranakakan anak?” ujar Ibrahim bapandir saurangan. ");
INSERT INTO bjn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","“Jakanya Ismail haja pang nang Pian barkahi jadi ahli waris ulun,” ujar Ibrahim baucap ka Allah. ");
INSERT INTO bjn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","“Sabujurannya, Sarah, bini ikam tu, pacangan maranakakan saikung anak lalakian gasan ikam. Inya pacang ikam ngarani Ishak. Aku handak maadaakan parjanjian-Ku lawan inya. Parjanjian-Ku tu pacangan kakal gasan juriatnya jua. ");
INSERT INTO bjn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Sual Ismail, sudah kudangar parmintaan ikam. Inya pacangan Kubarkahi jua. Juriatnya Kuulah manjadi banyak banar. Anak-anaknya pacangan manjadi dua walas raja. Juriatnya pacangan Ku-ulah manjadi urang nang ganal. ");
INSERT INTO bjn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tagal parjanjian-Ku pacang Kuadaakan lawan Ishak, nang pacang diranakakan Sarah gasan ikam tahun dudi pas bulan nang kaya ini” ujar Allah manyahuti Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tuntung bapandir lawan Ibrahim, Allah maninggalakan sidin. ");
INSERT INTO bjn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Suatu hari, Ibrahim rahatan duduk di muhara lawang kemahnya di parak puhun-puhun di Mamre. Lalu Allah manampaiakan diri-Nya lawan sidin. Wayah itu, harinya panas manggantang. ");
INSERT INTO bjn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Pas sidin manangadah sadikit ka jalan, sakalinya ada talu ikung musapir badiri bahadapan lawan sidin. Babaya malihat bubuhannya, sidin langsung bukah manyambut bubuhanya. Lalu sidin basujut sampai ka tanah. ");
INSERT INTO bjn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Pagustian ulun, amun pian hakun, baelang pang ka kemah ulun. Jangan balalu haja” ujar Ibrahim baucap. ");
INSERT INTO bjn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","“Biar sadikit banyu diambilakan, jadi pian pian kawa mambasuh batis, lalu dudukan ai baistrahat di bawah puhun nang ini. ");
INSERT INTO bjn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ijinakanlah ulun manyiapakan makanan sakadarnya nyaman pian pian sigar pulang. Lalu, pian pian kawa manarusakan parjalanan. Ulun marasa tahurmat lantaran pian pian sudah hakun baelang ka wadah kami” ujar Ibrahim baucap pulang. “Ayuja” sahut bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Lalu badadas ai Ibrahim mandapati Sarah di kemah. “Ding, lakasi, ambil sabantal galapung gandum nang pambaiknya, adoni, ulah manjadi ruti bulat” ujar Ibrahim ka bininya. ");
INSERT INTO bjn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Imbah itu, bukah ai Ibrahim ka wadah sapi-sapi inguannya. Lalu diambilnya saikung anak sapi nang lamak. Lalu dijulungnya lawan pambantunya. Lalu langsung dimasakakannya. ");
INSERT INTO bjn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Diambilnya keju, susu lawan daging anak sapi nang sudah dimasak tu, lalu disurungakan sidin ka bubuhan musapir tu. Parahatan bubuhannya makanan, sidin badiri haja parak bubuhannya di bawah puhun tu. ");
INSERT INTO bjn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Mana bini ikam?” ujar bubuhannya batakun. “Itu nah, urangnya ada di dalam kemah!” ujar Ibrahim manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","“Nah ingatakan ja, Him ai, tahun dudi, aku pacangan babulik pulang mandapati ikam. Wayah itu, Sarah, bini ikam tu, pacangan baisi saikung anak lalakian” ujar saikung matan bubuhan musapir tu baucap. Sarah umpat mandangarakan jua di lawang kemahnya. ");
INSERT INTO bjn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Sabujurnya Ibrahim wan Sarah tu sudah tuha banar, Sarahnya sudah ampih datang bulan. ");
INSERT INTO bjn_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Lalu tatawa ai Sarah. “Sudah tuha nang kaya ini, masih bisa guring bakumpulkah akuni lawan Abahnya? Sidin gin sudah tuha jua” ujar Sarah baucap dalam hatinya. ");
INSERT INTO bjn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","“Kanapa maka Sarah tatawa wan kada parcaya amun inya masih kawa baranak biar inya sudah tuha? ");
INSERT INTO bjn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Adalah nang mustahil gasan Allah? Tahun kaina, wayah nang sudah Aku tantuakan tadi tu, Aku pacangan babulik pulang mandapati ikam. Wayah itu pang Sarah pacangan baisi saikung anak lalakian” ujar ALLAH baucap lawan Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","“Kada, ulun kada katawa” ujar Sarah sambil bakulim lantaran takutan banar. “Iya ai, jangan bakulim! Ikam dasar katawa tadi tu!” ujar Allah manyahut. ");
INSERT INTO bjn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ALLAH mambarkahi Sarah, nang kaya nang dipirmanakan-Nya, wan ALLAH malakuakan lawan Sara nang kaya nang dijanjiakan-Nya. ");
INSERT INTO bjn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Maka batianan ai Sarah, lalu inya maranakakan saikung anak lalakian gasan Ibrahim wayah sidin sudah tuha, pas wayah nang sudah dijanjiakan Allah. ");
INSERT INTO bjn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ibrahim mangarani anaknya nang hanyar diranakakan Sarah tu, Ishak. ");
INSERT INTO bjn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Lalu Ibrahim manyunat Ishak, anaknya itu, wayah baumur delapan hari, nang kaya nang disuruhakan Allah lawan inya. ");
INSERT INTO bjn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Wayah Ishak diranakakan, Ibrahim sudah baumur saratus tahun. ");
INSERT INTO bjn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","“Allah sudah maulah aku katawa. Satiap urang nang mandangarnya pacang katawa jua nang kaya aku. ");
INSERT INTO bjn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kadada saikung ikung gin nang parcaya aku kawa baisi anak. Tagal lihati aku sudah maranakakan saikung anak lalakian gasan lakiku wayah sidin sudah tuha” ujar Sarah baucap ka Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Lawas kalawasan, anak tu tambah ganal. Wayah anak tu ampih disusui umanya, Ibrahim baaruh ganal gasan marayakan kajadian nang itu. ");
INSERT INTO bjn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Wayah itu, Sarah malihat anak Ibrahim nang diranakakan Hajar, urang Mesir tu, maajaki Ishak. ");
INSERT INTO bjn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Lantaran tu, Sarah baucap lawan lakinya, “Abahnya, suruh pang bajauh sasuruhan ulun tu lawan anaknya sualnya anak sasuruhan tu kada pacangan umpat manjadi ahli waris lawan anakku, Ishak.” ");
INSERT INTO bjn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kahandak Sarah tu maulah Ibrahim pusang sualnya Ismail tu anak lalakian sidin jua. ");
INSERT INTO bjn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","“Ikam kada usah pusang, Him ai, sual budak ikam wan anaknya tu. Umpati ja kahandak Sarah tu sualnya matan Ishak ikam pacangan baulihi juriat nang Kujanjiakan tu. ");
INSERT INTO bjn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tapi juriat anak Hajar tu nang pacangan kuulah jua manjadi satu urang sualnya inya tu anak ikam jua” ujar Allah baucap lawan Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Isuk baisukan, Ibrahim maambil makanan, sabuting kantung kulit nang baisi banyu, lalu diandaknya di bahu Hajar gasan sangu, imbah itu Hajar wan Ismail, anaknya, disuruhnya tulak bajauh. Lalu tulakan ai bubuhannya mangambara di padang gurun nang parak Kota Bersyeba. ");
INSERT INTO bjn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Imbah banyu nang di kantung kulit tu puang, dirabahakannya anak tu di bawah pupuhunan halus. ");
INSERT INTO bjn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ditinggalakannya bajauh, lalu inya duduk kira-kira anam puluh depa jauhnya matan situ. “Aku kada purun malihat anakku mati” ujar Hajar baucap dalam hati. Rahatan duduk di situ, inya manangis mahalulung. Anaknya manangis jua. ");
INSERT INTO bjn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Allah mandangar tangisan anaknya tu. “Kanapa maka ikam sadih banar? Kada usah takutan sualnya Allah sudah mandangar tangisan anak tu matan wadah inya barabah. ");
INSERT INTO bjn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Paraki anak ikam, diriakan inya, wan tuntun inya. Ikam musti maharagunya sualnya Aku pacangan maulah inya manjadi urang nang ganal” ujar malaikat Allah baucap lawan Hajar matan langit. ");
INSERT INTO bjn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Lalu Allah malihatakan lawan Hajar sabuah sumur. Hajar mandatangi sumur tu lalu kantung kulitnya diisinya lawan banyu. Imbah itu, anaknya dibariꞌinya minum. ");
INSERT INTO bjn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah manjagai anak tu sampai inya ganal. Inya bagana di padang gurun Paran lalu inya manjadi saikung pamanah nang harat. ");
INSERT INTO bjn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wayah inya bagana di padang gurun tu, inya dibiniakan ulih umanya lawan babinian matan Mesir. ");
INSERT INTO bjn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Imbah samuaan kajadian nang itu, Allah mauji kaimanan Ibrahim. “Ui, Ibrahim” ujar Allah baucap. “Pun” sahut Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Bawa Ishak, anak ikam nang saikungannya, nang ikam sayangi tu, lalu tulak ja ka banua Moria. Di situ di salah satu gunung nang pacang Kutuduhakan lawan ikam, parsambahakan inya manjadi kurban banaman gasan Aku” ujar Allah manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Isuknya, imbah bangun guring, baisukan banar, Ibrahim mambalah kayu gasan mambanam kurban. Imbah dijaratnya kayu tadi, diandaknya di lapak kaladainya, wan dikiaunya dua ikung pambantunya wan Ishak, anaknya. Lalu tulakan ai bubuhannya ka wadah nang dipadahakan Allah lawan sidin. ");
INSERT INTO bjn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Imbah talu hari bajalan, gunung nang itu sudah talihat ulih Ibrahim matan jauh. ");
INSERT INTO bjn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","“Hadangi di sini haja nah bubuhan ikam lawan kaladai tu nah. Aku wan anakku handak tulak ka sana, kami handak sambahyang, imbah itu kami babulik pulang ka sini” ujar Ibrahim baucap lawan dua ikung pambantunya. ");
INSERT INTO bjn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Diambil sidin kayu gasan mambanam kurban tu, lalu disuruh sidin Ishak manyahan kayu tu. Sadangkan sidin saurang mambawa bara api wan lading. Lalu tulakan ai kaduduannya bajalan baimbai. ");
INSERT INTO bjn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","“Bah” ujar Ishak baucap lawan abahnya. “Kanapa nak?” sahut sidin. “Bara api wan kayu sudah ada kita bawa, tagal anak domba nang cagar dibanam gasan kurban, mana inya bah?” ujar Ishak batakun. ");
INSERT INTO bjn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“Allah, nak ai, nang pacangan manyadiakan anak domba tu, nang jadi kurban banaman gasan Inya” sahut sidin. Lalu bajalan pulang kaduduannya baimbai. ");
INSERT INTO bjn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Imbah sampai ka wadah nang dipadahakan Allah tu, Ibrahim manyusun batu maulah mija gasan mambanam kurban. Disusunnya kayu gasan mambanam, dijaratnya Ishak anaknya tu, lalu diandaknya di atas kayu tu nang ada di atas mija batu tu. ");
INSERT INTO bjn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Imbah itu, sidin maambil lading. Pas handak manyumbalih anaknya, ");
INSERT INTO bjn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","bakakajutan tadangar suara malaikat Allah di langit. “Him, Him, Ibrahim!” ujar malaikat Allah mangiau. “Pun” sahut sidin. ");
INSERT INTO bjn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Jangan dimatiꞌi anak ikam tu, wan jangan diapa-apai inya, sualnya wayah ini Allah sudah tahu amun ikam tu hurmat wan maasi lawan parintah-Nya. Lawan pulang, ikam langsung hakun mamparsambahakan anak ikam nang saikungannya tu gasan Allah” ujar malaikat Allah baucap. ");
INSERT INTO bjn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibrahim manulih lalu talihat saikung domba laki di balakang sidin nang tanduknya takait di padang sabat. Diambil sidin domba tu lalu dikurbanakannya gasan mahurupi anaknya. Lalu domba tu dibanamnya. ");
INSERT INTO bjn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Lantaran itu, wadah nang itu dingarani sidin, “Allah manyadiaakan”. Lantaran itu pulang, sampai wayah ini urang-urang biasa baucap, “Di atas gunung pacang disadiaakan Allah.” ");
INSERT INTO bjn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Lalu malaikat Allah baucap pulang matan langit wan Ibrahim, ");
INSERT INTO bjn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Aku, Him ai, basumpah demi ngaranKu saurang. Lantaran ikam sudah balaku nang kaya itu, wan langsung hakun mamparsambahakan anak ikam nang saikungannya gasan Aku, ");
INSERT INTO bjn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","maka Aku pacangan bujur-bujur mambarkahi ikam. Juriat ikam pacangan Kuulah banyak banar nang kaya bintang di langit wan karangan di pantai. Juriat ikam tu pacangan manguasai kuta-kuta musuhnya. ");
INSERT INTO bjn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Malalui juriat ikam, samunyaan urang-urang di bumi pacangan Ku-barkahi lantaran ikam maasi lawan parintah-Ku” ujar malaikat tadi manyampaiakan Pirman Allah lawan Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Babulik ai Ibrahim wan anaknya mandapati kadua pambantunya lalu bubuhannya tulakan baimbai ka Kota Bersyeba. Lalu, Ibrahim salajur bagana di situ. ");
INSERT INTO bjn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Wayah itu, ada saikung lalakian nang bangaran Elimele. Inya tu bubuhan urang Efrata nang bagana di kota Betlehem di daerah Yahuda. Lantaran musibah kalaparan tu, maka inya tulakan ka banua Moab lawan Naomi, bininya, lawan Mahlon wan Kilyon, dua ikung anak lalakiannya. Lalu bubuhannya bagana di sana. Wayah bubuhannya masih di sana, ");
INSERT INTO bjn_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimeleh maninggal. Maka tatinggal Naomi, bininya tu, lawan dua ikung anaknya. ");
INSERT INTO bjn_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Kadua anaknya tu tapabini urang Moab. Ngaran bini Mahlon adalah Rut wan ngaran bini Kilyon adalah Orpa. Sapuluh tahun imbah itu, ");
INSERT INTO bjn_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","kadua anak lalakian Naomi tu maninggal jua. Jadi Naomi kahilangan lakinya lawan kadua ikung anaknya. ");
INSERT INTO bjn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Imbah itu, Naomi mandangar bahwa Allah sudah mambarkahi umat Israil mambari musim katam nang baik. Lantaran itu, Naomi lawan kadua ikung minantunya basisimpun handak maninggalakan banua Moab. ");
INSERT INTO bjn_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Lalu, bubuhannya tulakan baimbai ka banua Yahuda. ");
INSERT INTO bjn_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","“Bubuhan ikam bulik haja ka rumah kuitan ikam. Mudahan ALLAH salalu mambarkahi bubuhan ikam nang kaya bubuhan ikam baik lawan aku wan baik lawan aruah laki laki ikam. ");
INSERT INTO bjn_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Mudahan atas barakah Allah, bubuhan ikam balaki pulang sakira bubuhan ikam ada nang malindungi pulang” ujar Naomi baucap lawan kadua minantunya tu pas di tangah jalan. Imbah baucap nang kaya itu, Naomi bapamitan lawan mancium kadudua minantunya. Tagal Orpa wan Rut manangis banar. ");
INSERT INTO bjn_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","“Kada Ma-ai, kami umpat lawan pian tulakan ka banua padatuan pian” ujar Orpa wan Rut baucap sambil manangis. ");
INSERT INTO bjn_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","“Kada usah nak-ai” ujar si Naomi. “Baik bubuhan ikam babulik ka banua saurang. Gasan apa bubuhan ikam umpat lawan Aku? Aku ni kada kawa lagi maranakakan anak gasan jadi laki bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Bulik ja nak-ai. Aku sudah tuha banar amun balaki pulang. Upamanya amun ada lalakian nang hakun babini wan aku, malam ini jua manikah, lalu baanakan pulang lalakian, ");
INSERT INTO bjn_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Hakunlah bubuhan ikam manahan diri mahadangi sampai anak anak lalakianku ganalan? Asa kada mungkin, bubuhan ikam kada balaki pulang. Kada usah nang kaya itu. Allah sudah mahukum Aku. Jadi aku maras banar malihat napa nang bubuhan ikam musti alami lantaran hukuman Allah tu.” ");
INSERT INTO bjn_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Rut wan Orpa sasain nyaring manangis. Imbah itu, Orpa mancium uma mintuhanya, bapamitan, lalu inya bulik. Tagal Rut kada purun maninggalakan uma mintuhanya tu. ");
INSERT INTO bjn_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","“Rut, lihati ipar ikam sudah bulik ka banuanya saurang wan bulik jua ka dewa-dewanya. Tulak ja ikam nak-ai, turuti ja Orpa, bulik ka banua ikam saurang” ujar Naomi baucap lawan Rut. ");
INSERT INTO bjn_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","“Ma, pian jangan manyuruh ulun bulik maninggalakan pian! Ulun handak maumpati pian, ka mana haja pian tulak. Di mana haja pian bagana, ulun gin hakun haja bagana wan pian. Banua pian tu, banua ulun jua. Tuhan nang pian sambah cagar ulun sambah jua. ");
INSERT INTO bjn_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Di mana haja pian maninggal, di situ jua ulun hakun maninggal wan dikuburakan. Mudahan Allah mahukum ulun sabarat-baratnya, amun ulun maninggalakan pian, kacuali mati haja nang mamisahakan kita” ujar Rut manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi malihat bahwa Rut bakaras banar handak umpat, jadi inya kada bapandir lagi. ");
INSERT INTO bjn_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Maka batarus ai bubuhannya tulakan ka Kota Betlehem. Pas sampai di sana, tumbur sakotaan. Bubuhan babinian di sana batakun-takun, “Bujurlah inya tu si Naomi?” ");
INSERT INTO bjn_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","“Ikam jangan kiau aku Naomi! Kiau haja aku Mara sualnya Allah Nang Mahakuasa sudah mambiarakan Aku hidup marista banar! ");
INSERT INTO bjn_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Wayah aku tulak matan sini aku hidup bakacukupan, tagal wayahini Allah mambawa aku babulik pulang lawan tangan jari sapuluh haja. Lantaran itu pang, jangan lagi bubuhan ikam mangiau aku Naomi. Allah nang Maha kuasa sudah mahukum aku lawan banyak pandaritaan” ujar Naomi. ");
INSERT INTO bjn_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Damintu pang kisahnya kaya apa Naomi bulik matan banua Moab lawan Rut minantunya, urang Moab itu. Bubuhannya sampai di kota Betlehem wayah bamulanya musim katam jalay. ");
INSERT INTO bjn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ada urang sugih nang ngarannya Boas. Sidin tu kula arwah Elimeleh, lakinya Naomi. ");
INSERT INTO bjn_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Pada suatu hari Rut baucap wan Naomi, “Ma, ulun parmisi handak kapahumaan gasan maipiꞌi jalai nang batangkay nang tagugur matan tangan tukang katam. Pangrasa ulun bubuhannya cagar mambiarakan ulun malakuakan nang itu.” “Ayu ha coba ai nak ai! Tulak ja!” ujar Naomi manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Maka tulak ai Rut ka pahumaan maipiꞌi jelai mairingi bubuhan tukang katam. Kabalujuran inya tulak ka pahumaan ampun Boas. ");
INSERT INTO bjn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Kada lawas, datang Boas matan Kota Betlehem wan mambari salam lawan bubuhan tukang katam: “Mudahan bubuhan ikam bauntung batuah” ujar nya. “Amiiiiin. Mudahan Allah mambarkahi pian jua” ujar bubuhan tukang katam manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","“Siapa babinian tu?” ujar Boas batakun lawan mandurnya. ");
INSERT INTO bjn_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","“Inya urang Moab nang hanyar datang lawan Naomi tumatan banua Moab” ujar Mandur manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","“Inya minta izin lawan ulun mairingi bubuhan tukang katam maipiꞌi jalai nang tagugur. Tumatan baisukan, inya bagawi tarus, hanyar haja ampih gasan baistirahat satumat di lampau” ujar Mandur baucap pulang. ");
INSERT INTO bjn_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","“Ding, ikam maipi disini haja lawan bubuhan tukang katamku nang babinian. Kada usah ikam tulak maipi di pahumaan urang. Iringi haja bubuhan tukang katamku. Jangan jauh pada bubuhannya. Aku sudah manyuruh anak buahku nang lalakian sakira bubuhannya kada mangganggu ikam. Amun ikam haus, ambil haja banyu di tajau-tajau nang sudah diisi ulih anak buahku” ujar Boas baucap lawan Rut. ");
INSERT INTO bjn_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","“Tuan, ulun ni urang asing. Kanapa pian baik banar lawan ulun?” ujar Ruth baucap lawan Boas sambil sujut dihadapan sidin. ");
INSERT INTO bjn_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","“Aku sudah mandangar habar bahwa ikam ni bakti banar lawan uma mintuha ikam imbah laki ikam maninggal. Aku dangar ikam maninggalakan kuitan lawan banua ikam gasan bagana disini lawan urang-urang nang ikam balum bapatuhan. ");
INSERT INTO bjn_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Mudahan Allah mambalas bakti ikam. Mudahan ikam dibarkahi Allah, Tuhan nang kita sambah di Israel lantaran ikam sudah datang mancariꞌi lindungan-Nya” ujar Boas manyahuti si Rut. ");
INSERT INTO bjn_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","“Ulun himung lantaran Pian baik banar lawan ulun, biar ulun lain anak buah Pian” ujar Rut baucap. ");
INSERT INTO bjn_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","“Ayu ha ding ai, datang haja, kada usah basasupanan, makani haja, culupakan rotinya dalam cacapan nang ini” ujar Boas baucap lawan Rut wayah handak makan. Imbah itu, makan ai Rut baimbai lawan bubuhan tukang katam. Boas jua mambariꞌi jalai nang babanam. Rut makan sampai kanyang. Imbah makan, masih ada basisa. ");
INSERT INTO bjn_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Imbah makan, Rut tulak pulang maipiꞌi jalay. “Amun inya maipiꞌi jalai nang sudah bajarat, lihatakan haja. Jangan ditagur. Amun kawa, bubuhan ikam basinghaja mancabut ikit-ikit matan nang sudah dijarat-jarat itu. Gugurakan sakira ada nang diipiꞌi-nya,” ujar Boas baucap lawan bubuhan tukang katamnya imbah Rut sudah tulak. ");
INSERT INTO bjn_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut maipiꞌi jalai di pahumaan sampai sanja. Imbah itu, inya manapak-napak batang jalai itu. Sakalinya, bakulihi kira-kira satangah balik. ");
INSERT INTO bjn_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Imbah itu, Rut bulik ka wadah mintuhanya di kota Betlehem mambawa kulihannya. Lalu manampaiakan samunyaan kulihannya tu lawan uma mintuhanya. Lawan inya jua mambariꞌi lawan uma mintuhanya tu makanan nang kada kawa dihabisakannya wayah makan tadi. ");
INSERT INTO bjn_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","“Di mana ikam bakulihan samunyaan ini? Dipahumaan siapa ikam bagawi hari ini? Mudahan Allah mambarkahi urang nang babuat baik lawan ikam tu” ujar Naomi baucap manakuni Rut. Maka Rut mangisahakan lawan Naomi bahwa inya bagawi di pahumaan ampun lalakian nang ngarannya Boas. ");
INSERT INTO bjn_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","“Nak, urang tu kula parak lawan kita jua. Inya am nang mustinya maharagu kita. Mudahan Allah mambarkahi inya. Allah itu salalu manapati janjinya, baik lawan urang nang hidup atawa lawan bubuhannya nang sudah maninggal” ujar Naomi lawan Rut. ");
INSERT INTO bjn_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","“Ma, ujar urang tu lawan ulun, ulun bulih haja tatarusan maipiꞌi jalay lawan bubuhan tukang katam sidin tu sampai ampih musim katam” ujar Rut baucap pulang. ");
INSERT INTO bjn_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","“Hiꞌih nak ai. Katimbang ikam bagawi di pahumaan urang, bagusnya ikam bagawi lawan bubuhan tukang katam bibinian di pahumaan Boas haja sualnya amun ikam bagawi dipahumaan urang lain takutannya, ikam dingalihi urang” ujar Naomi lawan Rut. ");
INSERT INTO bjn_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Lantaran itu, Rut tatap haja maipiꞌi jalay di pahumaaan ampun Boas sampai tuntung musim katam. Salawas musim katam, Rut bagana lawan uma mintuhanya. ");
INSERT INTO bjn_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Lalu, Naomi mandatangi Rut wan baucap, “Aku musti bausaha sakira ikam balaki pulang, sakira ikam ada nang maharagu, wan ikam bahagia. ");
INSERT INTO bjn_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ikam bagawi lawan bubuhan bibinian di pahumaan Boas, kalu? Nah Boas itu kula kita jua. Malam ini, inya cagar tulak manampi jalai di pairikan. ");
INSERT INTO bjn_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Maka, ikam mandi, baminyak harum. Imbah itu, puruk baju ikam nang pambagusnya. Imbah itu, tulak ka wadah pairikan. Hadangi ja disitu sampai inya tuntung makan lawan nginum. Tagal jangan sampai sidin tahu ikam disana. ");
INSERT INTO bjn_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Janaki dimana sidin guring. Amun sidin sudah guring, paraki ka situ. Imbah itu, singkai ja salimput intangan batisnya. Lalu barabah ikam parak batisnya. Kaina inya cagar mamadahi lawan ikam napa nang musti ikam lakuakan.” ");
INSERT INTO bjn_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","“Inggih Ma-ai”, jawab Rut “Ulun umpati pandiran Pian.” ");
INSERT INTO bjn_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Imbah itu, tulak ai Rut ka wadah pairikan. Di sana digawinya samuaan nang disuruhakan Uma mintuhanya. ");
INSERT INTO bjn_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Imbah Boas tuntung makan lawan nginum, inya marasa puas lawan himung banar. Inya bajalan ka ujung timbunan jalai, lalu ai inya guring di situ. Bahihinipan Rut datang manyingkai salimput intangan batis Boas. Hanyar inya barabah parak batisnya ");
INSERT INTO bjn_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Tangah malam bakakajutan Boas tabangun. Pas handak babalik, takajut sidin manjanaki ada saikung bibinian guring parak batisnya. ");
INSERT INTO bjn_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“Siapa ikam?” ujar Si Boas batakun. “Ulun Rut, Tuan ai, Pian tu tamasuk kula kami nang parak nang musti maharagu kami” ujar si Rut manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","“Mudahan Allah mambarkahi ikam, ding ai. Dahulu kulihat ikam ni baik banar, kasih wan bakti banar lawan mintuha ikam. Hari ini, aku lihat ikam labih baik lagi. Sualnya ikam kawa haja bacari laki nang anum. Sugihkah, kadakah? Tagal ikam hakun haja lawan aku. ");
INSERT INTO bjn_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Lantaran itu, ding ai, kada usah takutan. Samuaan nang ikam minta tu cagar kukabulakan lantaran samuaan urang di kota ini tahu bahwa ikam bakalakuan baik. ");
INSERT INTO bjn_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Sabujurnya dasar Aku nang musti maharagu ikam lantaran aku tamasuk kula ikam nang parak. Tagal masih ada lagi urang lain nang musti batanggung jawab atas kahidupan ikam lawan inya tamasuk kula ikam nang taparak pada aku. ");
INSERT INTO bjn_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Malam ini, ikam bagana haja di sini dulu. Isuk baisukan aku cagar manakunakan apakah inya hakun malaksanaakan tanggung jawab itu lawan ikam atawa kada. Amun inya hakun, biar inya haja nang maharagu. Tagal amun inya kada hakun, maka aku bajanji demi Allah nang hidup aku nang cagar maharagu ikam. Wayah ini guring ja disini sampai baisukan” ujar Boas baucap lawan Rut. ");
INSERT INTO bjn_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Maka guring ai pulang Rut parak batis Boas. Sungsung banar, Rut sudah bangun sakira kada dilihat urang sabab ujar Boas, “Kada baik dilihat urang amun babinian datang ka wadah pairikan.” ");
INSERT INTO bjn_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","“Pacul kakamban ikam lalu hampar disini” ujar Boas lawan Rut. Maka Rut mamacul kakambannya lawan mahamparakannya. Boas maluruk kadalam kakamban itu jalai sabalik lalu diandaknya kaatas bahu Rut. Imbah itu, Boas tulak ka kuta. ");
INSERT INTO bjn_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","“Nang kaya apa jar, nak?” ujar Naomi batakun lawan Rut imbah Rut bulik ka wadah Naomi. Maka Rut mangisahakan samuaan nang dilakuakan Boas lawan inya. ");
INSERT INTO bjn_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","“Sidin manyangui ulun jalai sabalik sabab ujarnya ulun kada dibariakan bulik ka wadah mintuha amun kada disangui napa-napa” ujar Rut baucap lawan Naomi. ");
INSERT INTO bjn_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","“Kita hadangi haja, nak ai, nang kaya apa kaputingannya kaina. Sidin kada cagar badiam amun kada tuntung parkaranya hari ini jua” ujar Naomi manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Tulakai Boas ka wadah bamusawarah di garbang kota. Wayah sidin duduk disana, urang nang disambat sidin kula Elemeleh nang taparak tu lalu di situ. Boas mangiaunya, “Dangsanak ku kasini pang satumat, ayu kita dudukan disini nah.” Lalu duduk ai urang tu. ");
INSERT INTO bjn_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Imbah itu Boas mambawai sapuluh ikung bubuhan tatuha adat kuta itu. Dudukan bubuhannya barataan disitu. ");
INSERT INTO bjn_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","“Naomi sudah bulik matan Moab. Wayahini inya handak manjual tanah ampun aruah Elimeleh, kula kita. ");
INSERT INTO bjn_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Pangrasaku, aku musti mahabari ikam manganai hal itu. Amun ikam hakun manukar tanah Elimeleh tu, bapadah ja wayahini tampulu ada bubuhan tatuha adat dudukan disini. Amun kada, bapadah ja jua sabab kita badua haja nang bahak manukarinya. Ikam nang panambayan. Imbah itu, hanyar aku” ujar Boas baucap lawan dangsanaknya tu. “Ya aku nang manukarinya” ujar urang itu manyahuti Boas. ");
INSERT INTO bjn_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","“Ayu ha amun nang kaya itu. Tagal amun ikam manukari tanah itu matan Naomi maka ikam musti jua maambil bini, si Rut, urang Moab tu, balu aruah Mahlon sabab tanah itu musti tatap manjadi ampun juriat nang maninggal itu” ujar Boas baucap. ");
INSERT INTO bjn_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","“Amun kaya itu, aku kada kawa. Kulapas haja hakku sabagai urang panambaian nang musti manukar tanah itu gasan ikam. Kadada gunanya aku manukar sabab tanah itu tantu kada pacangan jadi ampun juriatku” ujar urang itu manyahut. ");
INSERT INTO bjn_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Pada jaman itu, di banua Israel, urang nang bajual atawa urang nang manukar, salah saikungnya mamacul wan manjulung sabalah sandalnya lawan pihak nang satunya gasan tanda jadi. ");
INSERT INTO bjn_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","“Ikam haja gin nang manukarinya” ujar urang tu baucap lawan Boas sambil mamacul sandalnya sabalah lalu dijulungnya lawan Boas. ");
INSERT INTO bjn_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","“Hari ini, bubuhan ikam samuaan saksinya bahwa aku nang manukari matan Naomi samunyaan ampun aruah Elimeleh lawan anak anaknya yaitu Killion lawan Mahlon. ");
INSERT INTO bjn_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Imbah itu, aku jua maambil Rut, babinian Moab, balu aruah Mahlon tu jadi biniku. Jadi tanah tu cagar tatap manjadi ampun kaluarga urang nang sudah maninggal tu. Ngaran aruah tu gin cagar tatap diingat urang diantara sanak kaluarganya lawan dikotanya. Ingatakan dangsanak-dangsanak lah, hari ini bubuhan ikam samuaan saksinya” ujar Boas baucap lawan bubuhan tatuha adat wan samuaan urang lain nang ada disitu. ");
INSERT INTO bjn_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","“Inggih, kami saksinya. Mudahan Allah manjadiakan bini ikam tu nang kaya Rahil wan Lia nang maranakakan banyak anak gasan Yakub. Mudahan ikam bauntung batuah diantara urang-urang kaum Efrata. Mudahan ikam jadi urang nang badahi jua di kuta Bethlehem. ");
INSERT INTO bjn_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Mudahan Allah mambariꞌi ikam anak-anak matan bibinian anum tu nang kaya juriat Peres nang diranakakan Tamar gasan Yahuda” ujar bubuhan tatuha adat baucap lawan urang lain nang ada disitu. ");
INSERT INTO bjn_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Maka Rut diambil Boas jadi bininya. Imbah bubuhannya bakumpul laki bini, Allah mambarkahi Rut sampai inya batianan lalu maranakakan saikung anak lalakian. ");
INSERT INTO bjn_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","“Subahanallah. Inya sudah mambariꞌi cucu lalakian pada hari ini gasan maharagu ikam. Mudahan inya tu manjadi urang nang badahi di Israel ");
INSERT INTO bjn_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Minantu ikam tu sayang banar lawan ikam. Inya labih bamanfaat daripada banyak baisi anak lalakian. Wayah ini, inya mambariꞌi jua cucu lalakian lawan ikam nang cagar manyigari jiwa ikam lawan maharagu ikam wayah ikam tuha” ujar bubuhan bibinian kampung baucap lawan Naomi. ");
INSERT INTO bjn_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi maambil anak tu. Disayangi wan diharagunya. ");
INSERT INTO bjn_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Bubuhan bibinian nang baparakan rumah lawan Naomi mangaraninya Obed. “Saikung lalakian sudah diranakakan gasan Naomi” ujar bubuhannya tadi. Obed abahnya Isai. Isai abahnya Nabi Daud. ");
INSERT INTO bjn_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Ini pang padatuan Nabi Daud bamula matan Peres. Panambaiannya, Peres abahnya Hezron, Hezron abahnya Ram, Ram abahnya Aminadab, Aminadab abahnya Nathson, Nathson abahnya Salmon, Salmon abahnya Boas, Boas abahnya Obed, Obed abahnya Isai, wan Isai abahnya Nabi Daud.");
INSERT INTO bjn_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Babahagialah urang nang kada manggawi napa nang dipadahi ulih urang jahat. Inya kada maumpati kalakuan urang nang badusa. Inya kada bakawal lawan urang nang mahahulut Allah. ");
INSERT INTO bjn_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Tagal urang nang bujur ini katuju maasi parintah Allah. Inya mambaca wan mamikirakannya jua saban hari, siang wan malam. ");
INSERT INTO bjn_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Inya bahasil tarus nang kaya puhun-puhun buah di pinggir sungai babuah wayah musimnya, daun-daunnya gin kada suah layu. ");
INSERT INTO bjn_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Tagal urang nang jahat kada nang kaya nitu! Inya kada baguna nang kaya sekam nang ditiup angin. ");
INSERT INTO bjn_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Maka urang nang jahat cagaran dihukum Allah, wan jua cagaran dijauhakan matan umat Allah. ");
INSERT INTO bjn_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Sualnya urang nang taat dibimbing wan dilindungi Allah, tagal urang nang jahat cagaran dibinasaakan ulih Allah.");
INSERT INTO bjn_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Suatu hari, ALLAH mandatangi Yunus, anak Amitai. ");
INSERT INTO bjn_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Lakasi, ikam tulak ka kuta Niniwe, kuta nang ganal tu. Padahakan lawan bubuhannya Aku cagar mahukum bubuhannya sualnya Aku sudah mangatahui dusa-dusanya nang saling banyakan” ujar ALLAH bapadah lawan Yunus. ");
INSERT INTO bjn_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Sakalinya Yunus kada hakun tulak ka kuta Niniwe, malahan inya handak tulak baampah ka arah nang balawanan, ka kuta Tarsis gasan malapasakan tugas nang dibariꞌi ALLAH tadi. Inya tulak ka palabuhan Yopa wan malihat sabuah parahu layar nang baloteng nang handak tulak ka kuta Tarsis. Imbah tambang dibayarinya, inya umpat ka kuta Tarsis. ");
INSERT INTO bjn_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Tagal, di tangah lautan, ALLAH mandatangakan angin ribut nang ganal banar. Lalu datanglah galombang laut nang ganal banar, mahantam parahu layar tu sampai parak tinggalam. ");
INSERT INTO bjn_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Bubuhan anak buah parahu layar tu katakutanan wan bahimat baduꞌa minta tulung lawan diwa diwanya saurang. Lalu isi nang ada di parahu layar tu dibuangi ulih bubuhannya ka laut gasan mahampulakan parahu layar tu sakira kada tinggalam. Padahal Yunus sudah turun ka dalam loteng parahu layar nang paling bawah wan barabah, lalu taguring janak banar. ");
INSERT INTO bjn_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Imbah itu, turun ai juragan mandapati Yunus nang lagi guring janak tu, lalu ai digaraknya. “Umailah ikam nih nyamannya, nang kaya ini kaadaannya, kawa haja ikam guring! Ayu, lajui badiri, baduꞌa lawan diwa ikam, kalu ai diwa ikam kawa manulungi gasan manyalamatakan kita barataan sakira kita kada matian” ujar juragan baucap lawan Yunus. ");
INSERT INTO bjn_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Yunus lawan juragan naikan ka loteng atas. “Nah, ayu kita bacabut undian sakira kita tahu siapa nang basalah, sampai kita kana musibah nang kaya ini” ujar bubuhan anak buah parahu layar bapandir papadaannya. Lalu, diadaakannya cabutan undian tadi. Yunus nang kana. ");
INSERT INTO bjn_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","“Padahakan ja lawan kami, lantaran siapa kita ditimpa musibah nang ini? Apa gawian ikam? Ikam orang mana, urang mana?” ujar bubuhan anak parahu layar manakuni Yunus. ");
INSERT INTO bjn_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","“Aku ni orang Ibrani. Aku manyambah ALLAH, nang di surga, nang maulah tanah lawan lautan nang ganal” ujar Yunus manyahut. ");
INSERT INTO bjn_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Bubuhannya sudah tahu bahwa inya handak manjauhi ALLAH. Itu sudah dipadahakan Yunus lawan bubuhannya. “Napa nang sudah ikam gawi nih sampai laut sasain bahamuk?” ");
INSERT INTO bjn_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","“Kami apakan ikam sakira angin ribut ini kada bahamuk lagi?” ujar bubuhannya batakun lawan Yunus sambil batambah katakutanan lantaran angin ribut sasain bahamuk. ");
INSERT INTO bjn_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","“Timbai ja aku ka laut; musti angin ribut ni baranai. Aku tahu aku ni panyababnya angin ribut ni nang manimpa bubuhan ikam” ujar Yunus manyahut. ");
INSERT INTO bjn_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tapi bubuhan anak buah parahu layar tatap haja mangayuh parahunya sakira kawa ka pinggir pantai. Tagal bubuhannya kada bahasil; angin sasain bahamuk. ");
INSERT INTO bjn_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Lantaran itu, bubuhannya baduꞌa bahimat lawan ALLAH, Tuhan nang disambah ulih Yunus. “Ya ALLAH, Tuhan kami, kami handak manimbai urang ini ka laut. Sabujurannya, urang ini kadada maulah dusa lawan kami. Lantaran itu, kami mamohon lawan Pian, janganlah mambinasaakan kami bila kami manimbai urang ini ka laut. Samunyaan nang ini sudah tajadi lantaran kahandak Pian” ujar bubuhannya sambil baduꞌa. ");
INSERT INTO bjn_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Imbah itu, bubuhannya maangkat wan manimbai Yunus ka laut. Wayah itu jua, angin ribut tu baranai. ");
INSERT INTO bjn_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Pas wayah itu, bubuhannya takutan banar lawan ALLAH. Imbah itu, bubuhannya mambariakan sasajian lawan ALLAH wan bajanji macam-macam lawan ALLAH. ");
INSERT INTO bjn_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","ALLAH mandatangakan saikung iwak nang ganal gasan managuk Yunus. Yunus baada di dalam parut iwak nang ganal tu salawas talu hari talu malam. ");
INSERT INTO bjn_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Dalam parut iwak tu, Yunus baduꞌa lawan ALLAH, Tuhannya. ");
INSERT INTO bjn_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Ujarnya, “Ya ALLAH, dalam kangalihan, ulun baduꞌa lawan Pian, lalu Pian mangabulakan duꞌa ulun. Matan kangalihan ulun, ulun minta tolong, parmintaan ulun Pian kabulakan. ");
INSERT INTO bjn_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Ka laut nang paling dalam, Pian timbai sampai ka dasar lautan. Ulun dihanyutakan banyu nang daras, galombang nang dikirim Pian mahampas ulun. ");
INSERT INTO bjn_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Di dalam hati, ulun bapikir, ‘Ulun sudah disuruh bajauh matan hadapan Pian.’ Tagal ulun cagar kawa lagi malihat Bait Allah nang suci. ");
INSERT INTO bjn_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Banyu laut naik sampai ka muntung ulun, lautan luas managuk awak ulun, kumpai laut malilit kapala ulun. ");
INSERT INTO bjn_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ulun tinggalam di banyu laut nang paling bawah di dasar gunung gunung; pangrasa ulun lawangnya takunci salawasan di balakang ulun. Lalu ulun dinaikakan Pian matan dasar laut, Ya ALLAH, ya Tuhan ulun! ");
INSERT INTO bjn_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Pas ulun lapah kauyuhan, ulun kaganangan lawan Pian, ulun minta tolong lawan Pian. Maka sampai ai parmintaan ulun lawan Pian ka dalam Bait Pian nang suci. ");
INSERT INTO bjn_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Bubuhan panyambah berhala nang sia-sia manolak rahmat Allah, nang mangasihi bubuhannya lawan setia. ");
INSERT INTO bjn_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Tagal ulun ni pang nang handak maucapakan syukur lawan Pian wan handak malaksanaꞌakan korban lawan Pian. Sagala janji ulun lawan Pian, handak ulun laksanaꞌakan. Pian jua nang manyalamatakan.” ");
INSERT INTO bjn_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Lalu ALLAH manyuruh iwak tu maluak Yunus ka darat. Lalu diluakakannya ai Yunus tu. ");
INSERT INTO bjn_vpl VALUES ("JH3_1","033_3_1","JON","3","1","2","“Lakasi ikam tulak ka kuta Niwiwe, kuta nang ganal tu. Padahakan lawan bubuhan Niwiwe pasan nang Kubariakan lawan ikam” ujar ALLAH manyuruh Yunus gasan kadua kalinya. ");
INSERT INTO bjn_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Lalu Yunus maasi parintah ALLAH, tulak ai inya ka kuta Niniwe. Niniwe tamasuk kuta nang ganal banar. Talu hari lawasnya amun bajalan batis di dalam kuta nitu. ");
INSERT INTO bjn_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Imbah masuk ka kuta nitu, lalu bajalan batis saharian, hanyar di situ inya manyampaiakan pasan Allah. “Ampat puluh hari lagi kuta ini lawan warga sakampungannya pacangan dibinasaakan,” ujar Yunus sambil bakuciak lawan urang banyak nang ada di situ. ");
INSERT INTO bjn_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Lalu saluruh rakyat nang ada di kuta Niniwe tu parcaya lawan pasan Allah tu. Bubuhannya mamutusakan gasan puasa. Bubuhannya sabarataan, baik urang nang tuha maupun urang nang anum, mamuruk baju karung nang diulah matan karung baras gasan manunjukakan bahwa bubuhannya manyasali dosa-dosanya. ");
INSERT INTO bjn_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Imbah itu, pesan nang itu tadangar ulih raja kuta Niniwe. Sidin turun matan singgasananya. Dipaculnya jubah karajaannya, dipuruknya kain karung, lalu baduduk di atas habu gasan manunjukakan bahwa sidin manyasali dosa-dosanya. ");
INSERT INTO bjn_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Raja lawan manteri-manterinya mambari pangumuman nang ini lawan rakyat Niniwe: “Samunyaan panduduk wan binatang inguan musti puasa. Jangan ada nang makan atawa nginum. ");
INSERT INTO bjn_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kain karung musti dipuruk ulih samunyaan bubuhan panduduk. Binatang binatang gin musti ditukupi lawan kain karung. Samunyaan urang musti maminta bujur-bujur lawan Allah sagan mangubah niat-Nya. Samunyaan urang musti batobat lantaran kalakuan nang jahat wan manyakiti urang lain. ");
INSERT INTO bjn_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Amun kita baubah, mudahan Allah kada sarik wan kada jadi mambinasaꞌakan kita barataan” ujar Raja dan manteri-manterinya manyuruh rakyat tadi. ");
INSERT INTO bjn_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Pas Allah malihat bahwa bubuhannya sudah batobat matan kalakuan nang jahat, maka Allah marasa maras banar wan Inya maubah niat-Nya mambinasaakan bubuhan kuta Niwiwi nang itu. ");
INSERT INTO bjn_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Wayah Yunus mangatahui hal itu, maka sidin pusang wan sarik banar. ");
INSERT INTO bjn_vpl VALUES ("JH4_2","033_4_2","JON","4","2","3","“Ya ALLAH, ulun sudah baucap sabalum tulak mulai rumah ulun bahwa Pian cagar babuat nang kaya ini! Makanya ulun tulak bajauh ka kuta Tarsis, maninggalakan Pian lantaran ulun tahu bahwa Pian maha panyayang wan maha pangasih, wan salalu siap maubah rancana hukuman Pian lantaran sifat Pian nang sabar! Wayahini, ya ALLAH ya Tuhan ulun, maraha ulun mati sabab labih bagus ulun mati katimbang ulun hidup” ujar Yunus sambil baduꞌa. ");
INSERT INTO bjn_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","“Ikam kadada alasan sarik kaya itu” ujar ALLAH manyahut. ");
INSERT INTO bjn_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Imbah itu, Yunus kaluar maninggalakan kuta Niniwe baampah ka subalah timur. Inya maulah sabuah lampau, lalu duduk banaung di dalamnya sambil mahadangi nang apa pacangan tajadi di kuta Niwiwe. ");
INSERT INTO bjn_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Lalu, ALLAH manumbuhakan tanaman nang malancar gasan mambari naungan lawan Yunus sakira inya marasa nyaman wan tahibur hatinya. Yunus katuju banar lawan tanaman itu. ");
INSERT INTO bjn_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Tagal imbah waktu subuh, Allah maulah saikung cacing mangorek tanaman itu, sampai jadi layu. ");
INSERT INTO bjn_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Imbah matahari cungul, Allah mandatangakan angin nang panas banar nang batiup matan timur. Hari panas manggantang nang maulah kapala Yunus ngalu, sampai parak siup. Inya baharap lakas mati. “Baiknya ulun mati katimbang ulun hidup” ujar Yunas sambil bamamay. ");
INSERT INTO bjn_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","“Ikam kada patut sarik manganai tanaman itu” ujar Allah manyahut. “Ulun patut sarik sampai mati” ujar Yunus batambah pulang. ");
INSERT INTO bjn_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","“Ikam marista banar lantaran kahilangan tanaman itu. Tapi ikam kada manamanmnya wan kada ikam jua nang manumbuhakannya. Tanaman ini tumbuhnya hanya samalaman haja wan isuknya sudah kadada. ");
INSERT INTO bjn_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Mustinya Aku nang labih marista mamikirakan kuta Niniwe nang ganal tu. Sualnya salain banyak banar binatang-binatangnya, panduduknya gin labih saratus dua puluh ribu orang, nang kada bisa mambedaakan mana nang baik wan mana nang jahat!” ujar Allah manjalasakan ka Yunus.");
INSERT INTO bjn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Gasan Nang Tahurmat, Tuan Teopilus, Sudah banyak urang nang manulis kajadian-kajadian di banua kami manganai Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kajadian-kajadian nang itu disampaiakan lawan kami ulih urang-urang nang suah manyaksiakannya, tamasuk jua pangikut-pangikut Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lantaran ulun sudah manyalidiki kajadian-kajadian nang itu, ulun tulis kisah ini gasan pian ");
INSERT INTO bjn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","sakira pian tahu kajadian-kajadian nang itu dasar bujur tajadi. ");
INSERT INTO bjn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Wayah jaman pamarintahan Herodes, raja Yudea, ada saikung imam nang bangaran Zakariya. Sidin tu tamasuk aliran imam Abia. Bini sidin juriat imam Harun. Ngaran bini sidin tu Elisabet. ");
INSERT INTO bjn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dua laki bini tu urang nang saleh wan takwa di hadapan Allah. Inya badua tu bujur-bujur maasi samunyaan parintah wan hukum Tuhan. ");
INSERT INTO bjn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zakariya wan bini sidin sudah tuha banar, kada sing anakan sualnya Elisabat tamanang. ");
INSERT INTO bjn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wayah aliran imam Abia kana giliran, Zakariya parahatan malakuakan tugas baimaman di Bait Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Biasanya gasan manantuakan imam nang mana nang mambanam kamanyan di dalam Ruang Suci di Bait Allah, dilakuakan undian. Pas wayah itu, sakalinya Zakariya nang kana gasan mambanam kamanyan. ");
INSERT INTO bjn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Parahatan acara mambanam kamanyan, samunyaan jamaah bakumpulan di luar wan malakuakan sambahyang. ");
INSERT INTO bjn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lalu malaikat Tuhan batampai lawan Zakariya di higa kanan mija parapen wadah mambanam kamanyan. ");
INSERT INTO bjn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pas malihat malaikat tu, sidin kabuliangan lawan katakutanan. ");
INSERT INTO bjn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","“Zakaria! ikam kada usah takutan Zakaria ai! Aku ni handak mahabarakan habar baik lawan ikam. Doa ikam sudah dikabulakan Zakaria ai! Bini ikam, Elisabet tu, cagar batianan wan maranakakan saikung anak lalakian. Ikam kaina musti mangaraninya Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ikam musti kahimungan. Malah urang nang lain gin banyak nang kahimungan wayah anak ikam diranakakan kaina. ");
INSERT INTO bjn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sualnya anak ikam tu cagar manjadi urang nang dimuliaakan Tuhan. Cirinya, inya kada bulih nginum banyu anggur atawa minuman lain nang ditangati. Lawan pulang, inya cagar dirasuki Ruh Kudus dalam parut umanya. ");
INSERT INTO bjn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Banyak juriat Nabi Ibrahim cagar diulahnya babulik manyambah Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yahya tu cagar manjadi utusan Allah nang kuat wan bakuasa nang kaya Nabi Ilyas. Inya cagar mandahului Al Masih gasan maulah hati abah-abah babulik pulang ka anak-anaknya. Lawan pulang, inya cagaran maulah hati urang-urang durhaka wan urang-urang nang kada taat babulik ka jalan nang lurus. Kaina inya malakuakan nang kaya itu tu gasan manyiapakan umat Allah sakira siap manarima kadatangan Al Masih” ujar malaikat lawan Zakariya. ");
INSERT INTO bjn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","“Nang kaya apa ulun tahu hal nang itu cagar tajadi? Ulun ni sudah tuha. Bini ulun gin tuha jua” ujar Zakariya manakuni malaikat tadi. ");
INSERT INTO bjn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Aku ni malaikat Jibril nang malayani Allah. Aku ni diutus ulih Allah mahabarakan habar baik tadi gasan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ingatakanlah! Samunyaan nang kupadahakan wan ikam cagar tajadi. Tagal lantaran ikam kada parcaya lawan pandiranku tadi, maka ikam manjadi bisu sampai kajadian itu tajadi” ujar malaikat Jibril mahimati. ");
INSERT INTO bjn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wayah itu, urang nang banyak di luar tu mahadangi Zakaria kaluar matan Ruang Kudus di Bait Allah. Bubuhannya hiran kanapa maka lawas banar inya kada sing kaluaran. ");
INSERT INTO bjn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pas Zakaria kaluar, inya bisu, kada kawa bapandir lagi lawan bubuhannya. Inya kawanya cuma mamakai bahasa isyarat lawan tangannya. Kaputingannya, bubuhannya sadar ada nang luar biasa nang dilihatnya di dalam Ruang Kudus tadi. ");
INSERT INTO bjn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Imbah tuntung giliran batugas, Zakaria langsung bulik. ");
INSERT INTO bjn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kada lawas, batiananay Elisabet, bininya. Salawas lima bulan, Elisabet bahinip haja di rumah, kada sing kaluaran. ");
INSERT INTO bjn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Himung banar Elisabet tu. Lalu, inya bapandir dalam hati, “Paampihannya Tuhan mangabulakan doaku wan mahapusakan kasupananku.” ");
INSERT INTO bjn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wayah itu, Elisabet sudah parak anam bulan batianan. Malaikat Jibril diutus mandatangi ");
INSERT INTO bjn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","saikung babinian nang bujangan di kuta Nasaret di banua Galilea. Ngarannya Siti Maryam. Siti Maryam tu sudah batunangan lawan Yusup juriat Raja Daud. ");
INSERT INTO bjn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","“Assalamu alaikum! Ikam ni bauntung banar manarima barakah matan Allah\" ujar malaikat ka siti Maryam tadi. ");
INSERT INTO bjn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Siti Maryam takajut mandangar ucapan malaikat tadi. “Apa lah artinya ucapan nang ini?” ujar siti Maryam bapandir dalam hati. ");
INSERT INTO bjn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Kada usah takutan Maryam ay! Ikam dipilih gasan manarima barakah Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ikam cagaran manianakan saikung anak lalakian. Kaina amun baranak, ngarani anak tu Isa. ");
INSERT INTO bjn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anak ikam tu cagar bakuasa nang kaya padatuan-Nya Raja Daud. Inya cagar disambat Anak Nang Di Atas. ");
INSERT INTO bjn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Imbah itu, Inya cagar bakuasa salawasan atas juriat Nabi Yakub. Karajaannya kada bakasudahan” ujar Malaikat tadi manambahi. ");
INSERT INTO bjn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Mana kawa? Ulun nih bujangan” ujar Siti Maryam manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","“Ruh Kudus cagar datang ka ikam wan kuasa Allah cagar manaungi ikam. Lantaran itu pang, anak ikam cagaran suci wan cagaran disambat Anak Nang Di Atas” ujar Malaikat tadi mahimati. ");
INSERT INTO bjn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Sabujurnya Elisabet, dangsanak ikam tu nah sudah anam bulan batianan biar inya sudah tuha wan disambat tamanang. ");
INSERT INTO bjn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sualnya amun Allah bakahandak, kadada nang mustahil” ujar malaikat pulang. ");
INSERT INTO bjn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“Ulun ni hamba Allah, tasarah haja. Ulun manarima haja napa-napa kahandak Allah\" ujar Siti Maryam manyahut. Lalu malaikat tu bajauh maninggalakannya. ");
INSERT INTO bjn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kada lawas, Maryam tu badadas tulak kasabuah kuta di banua Yudea didaerah pagunungan. ");
INSERT INTO bjn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Inya masuk ka rumah Zakariya wan mambari salam lawan Elisabet. ");
INSERT INTO bjn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pas Elisabet mandangar salam matan Maryam, anak nang di dalam parutnya bagarak-garak. Lalu Elisabet dirasuki ulih Ruh Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","“Maryam! Dingsanakku! Ikam bauntung banar lantaran ikam dibarakahi Allah diantara samunyaan bibinian nang lain wan dibarkahi jua anak nang ada di dalam parut ikam. ");
INSERT INTO bjn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Siapa garang aku ni sampai uma Junjunganku hakun maelangi? ");
INSERT INTO bjn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pas aku mandangar salam ikam, anak nang ada di dalam parutku ni batandik kasukaan. ");
INSERT INTO bjn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bahimunglah ikam, sualnya ikam parcaya amun samunyaan nang dipadahakan Tuhan cagaran tajadi\" ujar Elisabeth nyaring manyahuti. ");
INSERT INTO bjn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lalu Maryam baucap, “Hati ulun baucap Allahu akbar. ");
INSERT INTO bjn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jiwa ulun himung banar karna Allah, Juru salamat ulun. ");
INSERT INTO bjn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Inya ingat lawan ulun, hamba-Nya nang hina. Mulai wayahini sampai ka jaman kaina, samunyaan urang pacangan manyambat ulun dibarkahi ulih Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sualnya Allah nang Mahakuasa sudah malakuakan hal-hal nang luar biasa lawan ulun. Pujilah Allah, lantaran Inya suci! ");
INSERT INTO bjn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Allah mangasihi samunyaan urang tatarusan nang takutan wan mahurmati-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Lawan di zaman bahari, Allah manampakakan kuasa-Nya malalui gawian-Nya. Inya rahaiakan urang nang sumbung hatinya, lalu Inya gagalakan samunyaan rancana bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Di zaman bahari, Allah manurunakan raja-raja dari takhtanya lawan Allah maninggiakan darajatnya urang nang randah hati. ");
INSERT INTO bjn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Di zaman bahari, Allah mambari makan nang nyaman-nyaman ka urang nang lapar sampai kanyang sadangkan Allah manyuruh urang-urang nang sugih bajauh mambawa sapuluh jari haja. ");
INSERT INTO bjn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jadi, sakali lagi nang kaya zaman bahari, Allah lah nang manulungi juriat Nabi Ibrahim— yaitu umat pilihan-Nya, sakira kita bujur-bujur kawa malayani-Nya. Inya kada kalumpanan janji-Nya mangasihani kita— ");
INSERT INTO bjn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","lantaran Inya maingatakan rahmat-Nya nang sudah dijanjiakan lawan padatuan kita, mulai matan Nabi Ibrahim sampai ka kita, juriatnya sampai salawas-lawasnya.” ");
INSERT INTO bjn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryam bagana di rumah Elisabet kira-kira tiga bulan lawasnya. Imbah itu, inya bulik ka kuta Nazaret. ");
INSERT INTO bjn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kada lawas sampai-am wayahnya Elisabet baranak. Lalu diranakakannya ai saikung anak lalakian. ");
INSERT INTO bjn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Urang higa-mahiga rumah lawan dangsanak-dangsanaknya mandangar amun Tuhan mambari barakah lawan rahmat-Nya nang basar lawan Elisabet. Maka bubuhannya gin umpat himung jua lawan inya. ");
INSERT INTO bjn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wayah anak halus tu baumur dapalan hari, datangan bubuhannya gasan acara manyunat anak halus tu. Anak halus tu handak dingarani bubuhannya Zakariya nang kaya ngaran abahnya. ");
INSERT INTO bjn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","“Jangan! Jangan! Inya harus dingarani Yahya!” ujar umanya. ");
INSERT INTO bjn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Saikung-ikung gin kadada nang bangaran Yahya di antara kula-kula ikam” ujar bubuhannya manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lalu bubuhannya mambari tanda isarat lawan abahnya gasan manakuni ngaran anaknya. ");
INSERT INTO bjn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaria minta ambilakan batu tulis gasan manulis ngaran anaknya. “Ngarannya Yahya!” ditulis sidin di batu tu lantaran sidin kada kawa bapandir. Bubuhannya hiran sabarataan manganai pilihan ngaran tu. ");
INSERT INTO bjn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wayah nitu jua Zakaria ampih bisu. Inya kawa pulang bapandir. \"Sukur, Alhamdulilah. Aku kawa bapandir pulang\" ujar sidin sambil mamuji Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Samunyaan warga higa-mahiga rumah basukur. Kajadian-kajadian itu tadi dipandirakan urang di saluruh pagunungan Yudea. ");
INSERT INTO bjn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","“Manjadi apa jualah kaina anak halus nang itu? Sualnya Ruh Kudus ada lawan inya\" ujar bubuhannya bapandir dalam hati imbah mandangar hal itu. ");
INSERT INTO bjn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaria— Abahnya Yahya, dirasuki ulih Roh Kudus lalu Sidin banubuat nang kaya ini, ");
INSERT INTO bjn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tapujilah Allah, Tuhan juriat Nabi Ibrahim, nang sudah manulung kita wan sudah mambibasakan matan musuh-musuh kita. ");
INSERT INTO bjn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Allah sudah mautus saikung Tukang Kasalamatan nang baasal matan juriat hamba-Nya nang bangaran Nabi Daud. Inya bakuasa manyalamatakan kita. ");
INSERT INTO bjn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nang kaya itu tu pas banar lawan janji Allah nang disampaiakan matan nabi-nabi nang tadahulu. ");
INSERT INTO bjn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Sualnya nabi-nabi nang tadahulu tu manyampaiakan bahwa kaina Allah manyalamatakan kita matan musuh-musuh kita nang mamuari. ");
INSERT INTO bjn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gasan mambuktiakan kamurahan hati-Nya lawan padatuan kita, Allah ingat janji-Nya. Janji-Nya nang suci tu cagar ditapati-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Maka Allah sudah basumpah lawan padatuan kita nang bangaran Nabi Ibrahim ");
INSERT INTO bjn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","supaya kita dibibasakan dari kuasa musuh-musuh kita. Maka kita kada usah gair malayani Allah. ");
INSERT INTO bjn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nang kaya itu tu, kita bisa hidup suci wan bujur di hadapan-Nya saumuran. ");
INSERT INTO bjn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lalu manganai ikam — anakku nang masih halus ni, kaina ikam disambat saikung nabi Allah nang Mahatinggi lantaran ikam mandahului Tuhan. Ikam cagar manyiapakan jalan gasan kadatangan-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Artinya ikam kaina cagar mahabari umat-Nya nang kaya apa cara sakira bubuhannya kawa disalamatakan malalui pangampunan dosa-dosa bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jadi, lantaran kabaikan hati Allah, Tuhan kita, kaina Kasalamatan dari Allah, cagar manyinari kita. ");
INSERT INTO bjn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nang kaya itu tu, Allah cagar manarangi urang nang hidup dalam kakadapan. Imbah itu, Inya cagar manulungi urang nang katakutanan. Cahaya Allah itu cagar mambimbing kita baampah ka Tuhan, sakira kita hidup ruhui dalam parlindungan-Nya.” ");
INSERT INTO bjn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anak Zakaria nang itu, nang bangaran Nabi Yahya, sasain baganal wan jiwanya gin batambah kuat jua. Wayah inya ganal, inya bagana di padang pasir sampai wayahnya gasan manyataakan dirinya kalawan juriat Nabi Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","“Pangumuman! Pangumuman!” ujar anak buah Kaisar Agustus. “Kaisar Agustus maadaakan cacah jiwa di daerah Karajaan Romawi. Samunyaan urang musti mandaptarakan dirinya di kampungnya saurang” ujarnya pulang. ");
INSERT INTO bjn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nang itu tu cacah jiwa nang panambaian nang diadaakan wayah Kirenius manjadi Hupnor di banua Siria sakira barataan urang mambayar pajak. ");
INSERT INTO bjn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Lantaran itu, asing-asing urang bulikan ka kampungnya gasan mandaftarakan diri. ");
INSERT INTO bjn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nang kaya itu jua, Yusup, juriat Nabi Daud, nang bagana di kuta Nasaret di banua Galilea bulikan ka kuta Betlehem, iaitu kuta Nabi Daud. ");
INSERT INTO bjn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Inya tulakan ka sana gasan mandaptarakan dirinya lawan tunangannya, nang bangaran Maryam, nang lagi batianan. ");
INSERT INTO bjn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wayah Yusup lawan Maryam sampaian di situ, pas Maryam handak baranak. ");
INSERT INTO bjn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Diranakakannya ai saikung anak lalakian nang panambaian tu. Anaknya disalimputi lawan tapih lalu dirabahakannya di wadah makanan inguan. Sualnya di situ inya kada tadapat wadah panginapan gasan bamalam. Nang didapatnya cuma sabuah kurungan binatang inguan haja gasan bamalam. ");
INSERT INTO bjn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wayah malam, intangan kuta Betlehem, bubuhan tukang inguan parahatan manggaduh binatang inguannya di padang kumpai. ");
INSERT INTO bjn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bakakajutan ada malaikat bacungul parak bubuhannya. Lalu cahaya Allah manyinari bubuhannya tadi, lalu ai bubuhannya pina gair banar. ");
INSERT INTO bjn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Jangan takutan” ujar malaikat. “Aku mambawa habar baik gasan bubuhan ikam. Habar nang ini musti kahimungan samunyaan urang. ");
INSERT INTO bjn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hari ini di kuta Betlehem, kutanya Raja Daud, hanyar diranakakan Al Masih, Junjungan nang datang gasan manyalamatakan bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ini nah cirinya: di situ, kaina, bubuhan ikam cagaran mandapati saikung anak halus nang disalimputi lawan tapih. Anak halus tu dirabahakan di wadah makanan inguan\" ujar malaikat pulang. ");
INSERT INTO bjn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bakakajutan malaikat-malaikat nang lain batampaian jua di higa malaikat tadi. ");
INSERT INTO bjn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Biar ha samunyaan malaikat-malaikat mamuji Allah di langit. Wan biar ha manusia nang dibarakahi Allah manarima hati nang lapang bahagia di bumi” ujar malaikat-malaikat sambil mamuji Allah. ");
INSERT INTO bjn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Imbah itu, malaikat-malaikat tadi mainggalakan bubuhannya wan bulikan ka surga. “Ee! Ee! Ayu kita tulakan ka Betlehem. Nyaman kita malihat saurang paristiwa nang dihabarakan Allah tadi\" ujar bubuhan tukang inguan bapandir papadaannya. ");
INSERT INTO bjn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Badadas ai bubuhannya tulakan ka situ. Sasampainya di situ, tadapat jua bubuhannya lawan Maryam, Yusup wan anak halus tu nang dirabahakan di wadah makanan inguan. ");
INSERT INTO bjn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Imbah malihat anak halus tu, bubuhan tukang inguan mamadahakan napa nang diucapakan malaikat-malaikat tadi manganai anak halus tu. ");
INSERT INTO bjn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Urang-urang nang ada di situ tahiran-hiran mandangar habar bubuhan tukang inguan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tagal Maryam mahinipakan haja samunyaan parkara nang itu dalam hatinya sambil mamikirakannya. ");
INSERT INTO bjn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","“Syukur Al Hamdulilah. Samunyaan nang hanyar kita dangar wan kita lihat ni pas banar lawan napa nang dipadahakan ulih malaikat tadi” ujar bubuhan tukang inguan mamuji Allah sambil bulikan. ");
INSERT INTO bjn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dalapan hari imbah Isa diranakakan, Anak nang itu disunat lalu dibari ngaran Isa. Ngarannya tu sudah dipadahakan malaikat lawan Maryam sabalum inya batianan. ");
INSERT INTO bjn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ampat puluh hari imbah baranak, maka sampai ai wayahnya Maryam wan Yusup maadaakan acara akikah di Bait Allah nang kaya sudah disampaiakan Nabi Musa. Lalu, Maryam lawan Yusup mambawa Anak nitu ka Bait Allah di kuta Yarusalem gasan didoaꞌakan. ");
INSERT INTO bjn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sualnya di hukum Allah nang sudah disampaiakan Nabi Musa tu ada tatulis nang kaya ini, “Satiap anak lalakian nang panambaian harus disarahakan lawan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Allah jua mawajipakan kuitannya mamparsambahakan kurban nang sudah ditantuakan amun inya baisian anak lalakian nang panambaian. Kurbannya tu sapasang burung darakuku atawa dua ikung anak burung dara. Maka hakun ai kuitannya Isa malakuakan nang kaya itu jua. ");
INSERT INTO bjn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Wayah itu di kuta Yarusalem, ada saikung lalakian nang takwa lawan saleh. Ngarannya Simiun. Sidin lagi mahadangi kadatangan Al Masih nang dijanjiakan Allah gasan manyalamatakan Juriat Nabi Ibrahim. Sidin dibimbing ulih pitunjuk Ruh Kudus. ");
INSERT INTO bjn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lalu, sidin dipadahi Ruh Kudus bahwa sidin kada pacangan mati sabalum malihat Al Masih. ");
INSERT INTO bjn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Lantaran dibimbing ulih Ruh Kudus tadi, sidin tulak baampah ka Bait Allah. Kabalujuran wayah itu, Yusup wan Maryam mambawa Isa ka situ jua gasan mangurbanakan burung lawan manduaꞌakan Isa nang kaya diwajipakan dalam Kitab Suci Taurat. ");
INSERT INTO bjn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pas Simiun malihat Anak nang halus nang itu, dihimpunya ai sambil mamuji Allah. ");
INSERT INTO bjn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ya Allah” ujar Simiun badoa, “dasar bujur janji pian dahulu lawan ulun sudah dikabulakan. Biar ha lagi (lagi=penguatan) ulun maninggal lawan hati nang lapang bahagia, kadapapa. ");
INSERT INTO bjn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sualnya ulun sudah batamuan jua lawan utusan Pian nang cagaran manyalamatakan manusia. ");
INSERT INTO bjn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Anak nang ini ni Pian pilih gasan sabarataan urang. ");
INSERT INTO bjn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Inya ni nang kaya cahaya gasan manarangi samunyaan suku-suku. Lawan pulang, inya ni cagaran mambawa kahormatan gasan umat Pian, juriat Nabi Ibrahim.” ");
INSERT INTO bjn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Abah lawan uma Isa tahiran-hiran mandangar ucapan Simiun manganai Anaknya. ");
INSERT INTO bjn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lalu, Simiun mamohon barakah gasan Yusup lawan Maryam. “Sabujurannya lah, Anak nang ini sudah ditantuakan Allah. Kaena, sapalih juriat Nabi Ibrahim pacangan manulak Anak nang ini, lalu pacangan binasa. Sapalih lagi pacangan kawa manarima Anak nang ini lalu pacangan kahimungan banar lantaran salamat. Inya ni baisi pancirian nang pacang manampaiakan kabanaran matan Allah. Tagal banyak urang nang pacangan manolak-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lantaran itu, napa nang ada dalam hati urang pacang jadi kanyataan. Imbah itu, ikam, Maryam ai, pacang basadih nang kaya dicucuk-cucuk (BI=ditusuk) lawan lading nang landap\" ujar Simiun baucap ka Maryam. ");
INSERT INTO bjn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Di situ ada saikung nabi babinian nang sudah tuha banar. Ngarannya Hana, anak Fanuel, matan suku Asyer di banua Israil. Sidin balaki salawas tujuh tahun. ");
INSERT INTO bjn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Imbah itu, sidin manjadi balu. Wayahini umurnya sudah dalapan puluhan tahun. Sidin kada suah maninggalakan Bait Allah. Siang malam sidin ada di Bait Allah haja baibadah. Rancak jua sidin bapuasa lawan badoa. ");
INSERT INTO bjn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wayah Simiun masih bapandir lawan Yusup wan Maryam, datang ai si Hana tu mamaraki, lalu sidin langsung mamuji Allah lantaran batamuan lawan Al Masih. Imbah itu, sidin mamandirakan ai manganai Anak tu ka urang banyak nang lagi dandaman lawan kadatangan Al Masih nang pacangan mambibasakan kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Imbah Yusup wan Maryam tuntung manggawi samunyaan kawajipan dalam Hukum Tuhan, bulikan ai inya (XXX note inya and not bubuhanya) ka kuta Nasaret di banua Galilea, kutanya saurang. ");
INSERT INTO bjn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tahun ka lawan tahun, Anak nang itu sasain baganal wan bakuat, lalu sasain bijaksana, wan dibarakahi Allah. ");
INSERT INTO bjn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Satiap tahun kuitan Isa tulakan ka kuta Yarusalem gasan marayaakan Hari Raya Paskah di situ. ");
INSERT INTO bjn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pas Isa baumur dua balas tahun, Yusup wan Maryam mambawanya tulakan ka parayaan nitu nang kaya biasa. ");
INSERT INTO bjn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Imbah parayaannya tuntung, bulikan ai Yusup wan Maryam. Tagal inya (xxx note inya and not bubuhannya) kada tahu amun Isa masih batinggal di kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Dikiranya, (xxx note inya and not bubuhannya) Isa masih ada di dalam rombongan nang tulakan baimbai. Imbah saharian bajalan, inya (xxx note inya and not bubuhannya) mancariꞌi Isa di antara kulawarganya wan kakawalannya. ");
INSERT INTO bjn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lantaran kadada tadapat di situ, babulik pulang inya mancariꞌi ka kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sampai talu hari, kuitannya mancariꞌi Isa. Hanyar inya tadapat Isa di Bait Allah. Wayah itu, Isa lagi duduk di tangah-tangah guru-guru agama sambil mandangarakan wan manakuni bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Samunyaan urang nang mandangar pandiran Isa tahiran-hiran lantaran jawapan-jawapan Isa nang pintar banar. ");
INSERT INTO bjn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pas kuitan-Nya malihat, tahiran-hiran jua. Lalu umanya managur, “Nak, kanapa Ikam di sini? Kami tu kujuk-kujuk mancariꞌi (note we don't need the word 'ikam' here.) kamana-mana!” ");
INSERT INTO bjn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lalu Isa manyahut, “Baapa pian, Ma, Bah, mancariꞌi Ulun? Ulun ni musti baada di Bait Allah, rumah Abah Ulun?” ");
INSERT INTO bjn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tagal kuitannya kada paham napa nang dimaksutakan-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lantaran Isa ni patuh wan maasi apa ujar kuitan, lalu bulikan ai umpat kuitannya ka kuta Nasaret. Samunyaan kajadian nang itu dihinipakan uma-Nya dalam hati. ");
INSERT INTO bjn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Magin ganal, Isa magin batambah bijaksana, magin disayangi Allah lawan disayangi urang banyak jua. ");
INSERT INTO bjn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Wayah tahun ka lima balas pamarintahan Tiberias, Raja Romawi, pada waktu nang basamaan, Puntius Pilatus manjadi Hupnor Yudea, Herodes manjadi raja di daerah Galilea, Filipus, dangsanak Herodes mamerintah di daerah Iturea dan Trakhonitis, sadangkan Lisanias lagi mamerintah di daerah Abilene. Dan di Kota Yarusalem, Hannas wan Kayapas lagi batugas jadi imam basar. Wayah nang itu jua, Allah manyampaiakan pesan-Nya malalui Nabi Yahya— anak Zakaria, sakira bamula palayanannya. Wayah itu, sidin bagana di padang pasir nang jauh dari kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lalu ai, sidin bacaramah bakuliling di kampung-kampung di samunyaan daerah di parak Sungai Yordan. Lalu Nabi Yahya baucap, “Ei!Batubatlah dari dosa-dosa ikam sakira ikam kawa diampuni Allah. Kaena bubuhan ikam kumandi’i gasan mambuktiakan kalau ikam tu bujur-bujur handak maumpati jalan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jadi Nabi Yahya inilah nang dimaksutakan ulih Allah dalam nubuatan kitab Nabi Yesaya nang tatulis, “Kaina ada urang nang basuara lantang di padang pasir, ujarnya, ‘Basiaplah gasan kadatangan Jujungan ikam! Bujurakan ja jalan bagi-Nya!’” ");
INSERT INTO bjn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Samunyaan lambah musti diuruk wan tanah wan samunyaan bukit dirataakan, Samunyaan jalan nang baliuk-liuk dibujurakan. Samunyaan jalan nang balubak dirataakan. ");
INSERT INTO bjn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Samunyaan nang itu musti dilakuakan sakira urang kawa mangarti nang kaya apa caranya inya kawa disalamatakan ulih Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Banyak ai urang mandatangi Nabi Yahya handak minta dimandi'i gasan pang buktian batobat wan patuh lawan Allah. “Ei! Bubuhan ikam nang kaya ular nang bawisa! Bubuhan ikam jangan bapikiran kawa dilapasakan dari hukuman Allah kaina!\" ujar Nabi Yahya nang pina sarik ka urang banyak tu. ");
INSERT INTO bjn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","\"Lantaran itu, buktiakan pang parigal (perbuatan baik/buruk=Bhs Indo) ikam amun bujur-bujur maasi lawan Allah. Jangan bapikir, ‘Aku ni kaina kada pacangan dihukum Allah lantaran aku ni juriat Nabi Ibrahim.’ Sualnya, Allah tu kawa haja marubah batu-batu nang kaya ini nah manjadi juriat Nabi Ibrahim jua! ");
INSERT INTO bjn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nang kaya tukang kabun manabang puhun nang kada sing buahan lalu dibanamnya, nang kaya itu jua Allah tu sudah siap mamusnahakan urang-urang kita ni nah. Ditimbai-Nya ka dalam api!\" ujar Nabi Yahya manarusakan. ");
INSERT INTO bjn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Jadi nang apa jua nang kami gawi ni gasan mambuktiakan kalu kami ni sudah batobat?” ujar urang banyak batakun lawan Nabi Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Siapa nang baisi baju dua lambar, bariakan salambar ka urang nang kada baisi. Lawan siapa nang banyak baisi makanan, dibagi-bagiakan sapalih ka urang nang kada baisi” ujar Nabi Yahya manyahuti urang banyak tadi. ");
INSERT INTO bjn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ada jua bubuhan tukang tagih pajak mandatangi sidin handak minta mandiꞌi. “Guru, kami ini pang nang kaya apa?” ujar tukang-tukang tagih pajak batakun. ");
INSERT INTO bjn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Bubuhan ikam jangan minta balabih amun managih pajak” ujar Nabi Yahya manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Lalu ada pulang prajurit-prajurit nang mamaraki sidin. “Amun kami pang, nang kayapa?” ujarnya. “Jangan marabuti ampun urang! Jangan mampitnah urang! Imbah tu, sukuri haja gaji bubuhan ikam!” ujar Nabi Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wayah nitu banyak urang lagi maharapakan kadatangan Al Masih. “Umpat batakun lah! Piankah Al Masih nang dijanjiakan Allah tu?” ujar urang batakun lawan Nabi Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","“Aku hanya bisa mamandiꞌi bubuhan ikam. Tagal Al Masih nang cagar datang tu labih bakuasa. Mamaculakan sandal Sidin gin, aku kada pantas. Bubuhan ikam kaina cagaran dimandiꞌi Sidin lawan Ruh Kudus (footnote) wan lawan api. ");
INSERT INTO bjn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Di tangan Sidin ada nyiru gasan manampi banih. Banih nang barasih dikumpulakan di kindai, banih nang hampa dibanam-Nya ka api nang kada sing pajahan\" ujar Nabi Yahya manyahuti. ");
INSERT INTO bjn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kaya itu jua Nabi Yahya mamadahi urang-urang banyak tu lawan bamacam-macam cara sambil mahabarakan habar baik. ");
INSERT INTO bjn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nabi Yahya gin mamadahi Herodes jua, Raja di Galilea tu, lantaran banyak baulah dosa nang bamacam-macam. Bini dangsanaknya saurang gin dirabutinya jua. ");
INSERT INTO bjn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes malah manambah kajahatannya wayah inya mamanjaraakan Nabi Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Imbah samunyaan urang dimandiꞌi ulih Nabi Yahya, imbah itu, Nabi Isa gin dimandiꞌi sidin jua. Imbah tuntung dimandiꞌi, pas rahatan Nabi Isa badoa, langit tabuka ");
INSERT INTO bjn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","wan Ruh Kudus nang baujut burung dara turun lalu hinggap di bahu Sidin. Lalu tadangar suara matan langit, “Ikam Al Masih nang Kusayangi nang kaya saurang Abah manyayangi anaknya. Ikam nang maulah hati-Ku himung. ");
INSERT INTO bjn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wayah Nabi Isa bamula bacaramah, Sidin baumur kurang labih tiga puluh tahun wan manurut anggapan urang, Sidin tu anaknya Yusuf, Yusuf tu anaknya Eli, ");
INSERT INTO bjn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tu anaknya Matat, Matat tu anaknya Lewi, Lewi tu anaknya Malkhi, Malkhi tu anaknya Yanai, Yanai tu anaknya Yusuf, ");
INSERT INTO bjn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf tu anaknya Matica, Matica tu anaknya Amos, Amos tu anaknya Nahum, Nahum tu anaknya Hesli, Hesli tu anaknya Nagai, ");
INSERT INTO bjn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tu anaknya Maat, Maat tu anaknya Matica, Matica tu anaknya Simei, Simei tu anaknya Yosekh, Yosekh tu anaknya Yoda, ");
INSERT INTO bjn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda tu anaknya Yohanan, Yohanan tu anaknya Resa, Resa tu anaknya Zerubabel, Zerubabel tu anaknya Sealtiel, Sealtiel tu anaknya Neri, ");
INSERT INTO bjn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tu anaknya Malkhi, Malkhi tu anaknya Adi, Adi tu anaknya Kosam, Kosam tu anaknya Elmadam, Elmadam tu anaknya Er, ");
INSERT INTO bjn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tu anaknya Yesua, Yesua tu anaknya Eliezer, Eliezer tu anaknya Yorim, Yorim anaknya Matat, Matat tu anaknya Lewi, ");
INSERT INTO bjn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi tu anaknya Simeon, Simeon tu anaknya Yehuda, Yehuda tu anaknya Yusuf, Yusuf tu anaknya Yonam, Yonam tu anaknya Elyakim, ");
INSERT INTO bjn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim tu anaknya Melea, Melea tu anaknya Mina, Mina tu anaknya Matata, Matata tu anaknya Natan, Natan tu anaknya Nabi Daud, ");
INSERT INTO bjn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Nabi Daud tu anaknya Isai, Isai tu anaknya Obed, Obed tu anaknya Boas, Boas tu anaknya Salmon, Salmon tu anaknya Nahason, ");
INSERT INTO bjn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason tu anaknya Aminadab, Aminadab tu anaknya Admin, Admin tu anaknya Arni, Arni tu anaknya Hezron, Hezron tu anaknya Peres, Peres tu anaknya Yehuda, ");
INSERT INTO bjn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda tu anaknya Nabi Yakub, Nabi Yakub tu anaknya Nabi Ishak, Nabi Ishak tu anaknya Nabi Ibrahim, Nabi Ibrahim tu anaknya Terah, Terah tu anaknya Nahor, ");
INSERT INTO bjn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor tu anaknya Serug, Serug tu anaknya Rehu, Rehu tu anaknya Peleg, Peleg tu anaknya Eber, Eber tu anaknya Salmon, ");
INSERT INTO bjn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon tu anaknya Kenan, Kenan tu anaknya Arpakhsad, Arpakhsad tu anaknya Sem, Sem tu anaknya Nabi Nuh, Nabi Nuh tu anaknya Lamekh, ");
INSERT INTO bjn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekh tu anaknya Metusalah, Metusalah tu anaknya Henokh, Henokh tu anaknya Yared, Yared tu anaknya Mahalaleel, Mahalaleel tu anaknya Kenan, ");
INSERT INTO bjn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan tu anaknya Enos, Enos tu anaknya Set, Set tu anaknya Nabi Adam, Nabi Adam tu anaknya Allah dalam arti inya diciptakan lansung ulih Allah. ");
INSERT INTO bjn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Imbah bulik matan sungai Yordan, Nabi Isa dibimbing ulih Ruh Kudus ka padang pasir. ");
INSERT INTO bjn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Di sana, ampat puluh hari Sidin bapuasa wan dibujuk-bujuki ulih Iblis. Sidin ni lapar banar. ");
INSERT INTO bjn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lalu Iblis mamaraki Sidin wan baucap, “Amun ikam Anak Nang Di Atas tu, coba pang batu nang ini diubah jadi ruti.” ");
INSERT INTO bjn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nabi Isa manyahut, “Kada usah gin. Sualnya ada tatulis dalam Kitab Suci Taurat, ‘Urang hidup kada tagantung lawan ruti haja tapi urang hidup sudah ditantuakan lawan Pirman Allah.’” ");
INSERT INTO bjn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lalu Nabi Isa dibawainya pulang ka wadah nang paling tinggi. Tang, sakajap mata haja, ditampaiakannya samunyaan karajaan dunia. ");
INSERT INTO bjn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ujar Iblis mambujuki/MANGGUDA, “Aku kawa mambari kuasa wan kasugihan dunia ka siapa haja nang kupilih sualnya samunyaannya sudah disarahakan ka aku. ");
INSERT INTO bjn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Maka samunyaan nitu kubariakan ka ikam asal ikam manyambah aku.” ");
INSERT INTO bjn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ujar Nabi Isa manyahut pulang “Ada tatulis dalam Kitab Suci Zabur, ‘Sambahlah Allah, Tuhan nang ikam sambah. Hanya ka Allah haja baibadah.’ ” ");
INSERT INTO bjn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lalu, Nabi Isa dibawanya pulang ka kuta Yerusalem, diandaknya ka bubungan (roof) Bait Allah. “Amun ikam Anak nang di atas, coba pang Ikam batajun ka bawah ");
INSERT INTO bjn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sualnya ada tatulis dalam Kitab Suci Zabur, ‘Allah manyuruh malaikat-malaikat-Nya ");
INSERT INTO bjn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","manyambut Ikam lawan tangan-Nya sakira batis Ikam kada takana batu’” ujar Iblis mambujuki Nabi Isa pulang. ");
INSERT INTO bjn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nabi Isa manyahuti, “Ada tatulis, ‘Jangan ikam mancoba-coba Allah Tuhan nang ikam sambah.’” ");
INSERT INTO bjn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Imbah tuntung mambujuki Nabi Isa, bajauhai Iblis tu. Iblis tu mahadang-hadang waktu nang pas gasan mambujuki pulang. ");
INSERT INTO bjn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nabi Isa babulik ka banua Galilea dibimbing ulih Ruh Kudus. Habar manganai Sidin tahabar ka unjut-unjut banua nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sidin bacaramah di rumah-rumah ibadah di situ wan samunyaan urang mamuliaakan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lalu Nabi Isa sampai ka kuta Nazaret, banua Sidin diganalakan. Wayah hari Sabat, nang kaya biasanya, Sidin masuk ka rumah ibadah. Lalu Sidin badiri gasan mambacaakan Kitab Suci. ");
INSERT INTO bjn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Imbah itu, Sidin dijulungi sabuah aliran Kitab Suci, surah Nabi Yasaya. Dibuka Sidin ai, lalu tadapat bahagian nang handak dibacaakan manganai Al Masih. Di situ tatulis: ");
INSERT INTO bjn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ruh Kudus marasuki Aku sualnya Allah mamilih wan mautus Aku gasan mahabarakan ka urang-urang miskin bahawa Allah cagaran manulungi bubuhannya. Allah mautus Aku gasan mahabari bahawa urang-urang nang takurung cagaran dilapasakan, urang-urang nang picak cagaran malihat, urang-urang nang tatindas cagaran dibibasakan. ");
INSERT INTO bjn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Allah mautus Aku gasan mahabarakan bahawa Inya cagaran manyalamatakan manusia” ujar Nabi Isa mambacaakan surah tadi. ");
INSERT INTO bjn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Gulungan Kitab Suci tadi digulung Sidin pulang wan diunjuk-Nya ka patugas di situ. Imbah itu, duduk ai Nabi Isa gasan mambari caramah ka urang-urang nang ada di situ. Samunyaan urang di situ maitihi Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lalu Nabi Isa baucap, “Hari ini, napa nang bubuhan ikam dangar tadi sudah bamula tajadi.” ");
INSERT INTO bjn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mulanya samunyaan urang maucapakan hal-hal nang baik manganai Sidin. Ada nang baucap, “Umai, saban caramah Sidin tu hibat banar wan nyaman didangarakan.” Ada jua nang hiran lalu baucap, “Wah, asa kada mungkin anak Yusuf bisa bacaramah nang kaya itu?!” ");
INSERT INTO bjn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Imbah itu, Nabi Isa baucap, “Musti bubuhan ikam baucap lawan Aku napa nang rancak diucapakan urang— yaitu ‘Dokter, coba pang wagasakan diri ikam saurang.’ Lawan ucapan nang itu, bubuhan ikam maminta nang kaya ini: ‘Kami mandangar bahwa ikam malakuakan mujijat di kuta Kapernaum. Lakuakan pang mujijat di sini di kampung ikam saurang.’” ");
INSERT INTO bjn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Lalu Nabi Isa baucap, “Nah, napa nang Kupadahakan wayahini tu bujur: Kadada saikung-ikung nabi pun nang dihurmati di kampungnya saurang. ");
INSERT INTO bjn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lalu hal nang ini bujur jua: Ada banyak urang balu juriat Nabi Ibrahim pada jaman Nabi Elyas— itu tu pas musim kamarau salawas tiga tahun enam bulan, lalu ada bancana kalaparan di banua nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tagal Nabi Elyas kada disuruh manulungi urang balu di banuanya saurang, malahan disuruh manulungi urang balu di banua urang, artinya di kampung Sarfat— di parak kuta Sidon. ");
INSERT INTO bjn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Lawan pulang, pada jaman Nabi Elyasa, banyak urang bapanyakitan kusta di banuanya saurang. Tagal sidin kada disuruh mawigasakan saikung-ikung urang gin di banuanya saurang. Cuma Naaman— urang di banua Siria, nang diwigasakannya.” ");
INSERT INTO bjn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wayah bubuhan jamaah mandangarakan caramah sidin tu, bubuhannya hanyar sadar kalu Sidin kada hakun maungkay mujijat di banuanya saurang. Lalu banyak urang di rumah ibadah tu nang sangit lawan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lalu bubuhannya badirian manyuruh Sidin bajauh matan kampung tu. Lantaran kuta Nazaret dibangun di atas gunung, bubuhannya mahirit Sidin ka panggir jurang lalu handak manju'ung Sidin ka jurang tu. ");
INSERT INTO bjn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tagal Nabi Isa kawa haja bahindar. Balalu Sidin bajalan haja batarus. ");
INSERT INTO bjn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lalu Nabi Isa tulak ka Kapernaum, kuta nang ada di banua Galilea. Nang kaya biasa jua, pada hari Sabat, Sidin mambari caramah di rumah-rumah ibadah di situ. ");
INSERT INTO bjn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kagum banar urang-urang tu mandangar caramah Nabi Isa. Sualnya Sidin tu kalu bapander, bapangaruh banar. ");
INSERT INTO bjn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Di rumah ibadah tu ada saikung urang nang kasarungan roh jahat. Matanya manceleng-celeng sambil inya kuciak-kuciak. ");
INSERT INTO bjn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Eiii! Nabi Isa, urang kampung Nasaret! Tulung pang, jangan diganggu kami! Ikam handak mambinasaakan kami kah? Aku tahu ai Ikam tu utusan nang suci matan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Lalu Nabi Isa baucap, “Bahinip ja! Bajauh matan urang ini!” Lalu, ruh jahat tadi mahampas urang tu dihadapan urang banyak. Imbah itu, kaluaran ai ruh-ruh jahat tadi. Tagal urang tadi kada disakitinya pang. ");
INSERT INTO bjn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Samunyaan urang hiran lalu baucap ka nang lain, “Haratnyalah ucapan Sidin tu, bapangaruh wan bakuasa banar. Wayah Sidin manyuruh ruh-ruh jahat tu bajauh, langsung haja ruh-ruh jahat tu maasi ucapan sidin!” ");
INSERT INTO bjn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Maka kajadian nang ini tahabar jua ka samunyaan unjut di banua nitu. ");
INSERT INTO bjn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lalu Nabi Isa maninggalakan rumah ibadah tadi, lalu Sidin tulak ka rumah Simun. Mintuha Simun lagi mariap dingin. Lalu Nabi Isa diminta sakira mawigasakan mintuha Simun. ");
INSERT INTO bjn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Diparaki Sidin paguringannya. Lalu digaratak Sidin mariap dinginnya. Imbah tu, ampih ai mariap dingin. Langsung haja mintuha Simun bapuat, lalu malayani bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Imbah magrib, banyak urang nang mambawa urang-urang lain nang baisian bamacam-macam panyakit ka Nabi Isa. Lalu Sidin maandak tangan ka atas kapala bubuhannya saikung-saikung. Wigasan ai sabarataan. ");
INSERT INTO bjn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Imbah itu, ruh-ruh jahat tadi kaluaran matan urang-urang nang dirasuki tadi sambil bakuciak-kuciak. “Pian tu Anak Nang Di Atas” ujar ruh-ruh jahat tadi. Tagal Nabi Isa manangati ruh-ruh jahat tadi manarusakan pandirannya lantaran bubuhannya sudah tahu kalu Sidin tu Al Masih. ");
INSERT INTO bjn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Baisukan banar, Nabi Isa tulak ka wadah nang sunyi. Sakalinya banyak urang kujuk-kujuk mancariꞌi Sidin. Pas tadapat, bubuhannya bausaha manahani Sidin sakira kada maninggalakan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tapi Nabi Isa kada hakun ditahani. “Aku harus mahabarakan habar baik manganai Karajaan Allah. Lantaran itu pang, Aku diutus Allah. Makanya aku harus tulak ka kuta-kuta nang lain jua” ujar Nabi Isa manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lalu tulak ai Sidin ka daerah juriat Nabi Ibrahim nang lain. Lalu Sidin mahabarakan habar baik di rumah-rumah ibadah nang ada di situ. ");
INSERT INTO bjn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wayah itu, Nabi Isa lagi badiri di pinggir Danau Genesaret nang disambat jua Danau Galilea. Banyak urang bakajal-kajal manggurumbungi Sidin handak mandangarakan Pirman Allah nang disampaiakan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nabi Isa malihat dua buah parahu di pinggir danau nang tukang tangkap iwaknya sudah turunan. Bubuhannya tu lagi mambarasihi ringginya. ");
INSERT INTO bjn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sidin babuat ka parahu ampunnya Simun. Lalu Simun disuruh Sidin manunjulakan parahunya tu bakatangah sadikit. Duduk ai Sidin. Hanyar Sidin bacaramah matan parahu ka urang banyak tu. ");
INSERT INTO bjn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Imbah tuntung bacaramah, Sidin baucap ka Simun, “Kayuh pang ka wadah nang dalam, imbah itu labuhakan ringgi ikam gasan manangkap iwak!” ");
INSERT INTO bjn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Lalu Simun manyahut, “Guru, kami sudah samalaman bahimat maringgi. Tagal kadada kulihan saikung-ikung iwak. Nang ini, lantaran pian nang manyuruh, ayu ai, kami labuh pulang ringgi nang ini.” ");
INSERT INTO bjn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Imbah diangkat ringginya, sakalinya saling banyakan kulihan iwak sampai handak bungkas ringginya tu. ");
INSERT INTO bjn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lantaran itu bubuhannya mangawai kakawalannya nang ada di parahu sabuahnya sakira mangganiꞌi manangkapi iwak nang banyak tu. Datangan ai kakawalannya. Lalu baimbai maisiꞌi kadua parahu tadi sampai hibak parak tinggalam. ");
INSERT INTO bjn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Imbah manyaksiakan kajadian nang itu, lalu Simun Pitrus basujut di hadapan Sidin lalu baucap, “Junjungan, tinggalakan ulun sualnya ulun ni urang nang badusa.” ");
INSERT INTO bjn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Inya baucap nang kaya itu lantaran inya lawan kakawalan nang saparahu wan inya hiran banar manyaksiakan saling banyakan kulihan iwak nang ditangkapnya. ");
INSERT INTO bjn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nang kaya itu jua kakawalan Simun nang lain, nang kaya Yakub wan Yahya, anak-anak Zabdi. Bubuhannya gin tahiran-hiran jua. “Kada usah takutan. Dahulunya bubuhan ikam mancari iwak. Tagal mulai wayahini ikam cagaran mancariakan banyak pangikut gasan Aku\" ujar Nabi Isa wan Simun. ");
INSERT INTO bjn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Imbah manariki parahu-parahunya ka tabing, Simun wan kakawalannya maninggalakan samunyaan gawiannya lalu maumpati Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wayah itu, Nabi Isa basinggah di sabuah kuta. Di situ ada saikung lalakian nang bapanyakit kusta saawakan. Pas urang tu malihat Nabi Isa, basujut ai inya dihadapan Sidin. “Guru, amun Pian kawa mawigasakan panyakit ulun ni, wigasakan pang ulun sakira ulun kawa umpat sambahyang bajamaah pulang” ujarnya mamohon ka Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","“Ayuha. Wigas sudah ikam” ujar Nabi Isa sambil manyurung tangan lawan manjapai urang tadi. Langsung wigas ai inya! ");
INSERT INTO bjn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lalu Nabi Isa baucap, “Ingatakanlah! Kada usah bakisah ka urang lain siapa nang mawigasakan ikam! Tulak ja ikam! Tampaiakan awak ikam ka imam supaya sidin kawa mamastiakan amun ikam tu sudah bujur-bujur wigas. Julung korban ikam lawan imam tu nang sudah diwajipakan Nabi Musa dalam Kitab Suci Taurat. Kurban nang itu gasan urang nang hanyar wigas matan panyakit nang kaya ini sakira imam kawa mangorbanakannya ka Allah. Kurban nang itu tu cagar mambuktiakan amun panyakit kusta ikam sudah bujur-bujur wigas. Lalu kawa ai ikam umpat sambahyang bajamaah pulang.\" ");
INSERT INTO bjn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Biar urang tu sudah ditangati bakisah-kisah ka urang lain, habar manganai Nabi Isa magin tahabar ka mana-mana. Lantaran itu, datangan ai urang bajurut-jurut ka Nabi Isa handak mandangar caramah Sidin wan handak maminta lawan Sidin supaya mawigasakan nang bamacam-macam panyakit. ");
INSERT INTO bjn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tagal Sidin tulak manyaurangan handak badoa ka wadah nang sunyi. ");
INSERT INTO bjn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wayah itu Nabi Isa bacaramah di sabuah rumah. Di situ ada pamuka-pamuka agama matan aliran Parisi. Ada jua guru-guru agama badudukan mandangarakan Sidin. Bubuhannya tu datangan tumatan kampung-kampung di samunyaan banua Galilea wan Yudea wan kuta Yarusalim. Kuasa Allah ada wan Nabi Isa maka Sidin kawa mawagasakan urang. ");
INSERT INTO bjn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ada babarapa urang nang manandu saikung urang nang lumpuh nang barabah di atas lapik guringnya. Bubuhannya bausaha mambawanya masuk ka dalam supaya kawa diandak di hadapan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tagal lantaran saling banyakan urang nang bakakajalan, bubuhannya tadi kada kawa mambawanya masuk. Hibak banar urangnya di rumah tu. Lalu bubuhannya mambawa urang tadi naik ka atas hatap rumah. Lalu hatap rumah tu dibungkasnya. Di luang hatap tadi, urang lumpuh tu diturunakan lawan lapik guringnya ka tangah-tangah urang banyak pas di hadapan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Ui dangsanak! Dusa ikam sudah Ku-ampuni!” ujar Nabi Isa pas malihat urang-urang nang manandu tadi nang bujur-bujur baiman lawan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lalu guru-guru agama wan urang-urang Parisi tadi bapandir dalam hati, “Waninyalah urang ni bapiragah jadi Allah, kadada pang urang nang bahak maampuni salain Allah haja. Ini mahina Allah ngarannya!” ");
INSERT INTO bjn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","“Kanapa bubuhan ikam bapikiran nang kaya itu?” ujar Nabi Isa batakun lantaran Sidin sudah tahu pikiran bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Aku bakuasa di bumi ini maampuni dusa-dusa urang. Amun Aku baucap sudah, ‘Dosa ikam sudah kuampuni,’ baluman tantu jua bubuhan ikam parcaya.” ");
INSERT INTO bjn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tagal wayahini nang datang matan di surga cagar mambuktiakan kalu Inya nang bakuasa maampuni dusa urang” ujar Sidin sambil bapaling ka urang nang lumpuh tadi. \"Dangsanak bapuat ja ikam! Ikam sudah wagas! Jinting lapik guring ikam wan bulik ja!\" ujar Sidin baucap ka urang nang lumpuh tadi. ");
INSERT INTO bjn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Langsung ai urang tu badiri di hadapan urang-urang nang ada di situ. Dijintingnya lapik guringnya lalu bulik ai inya. “Allah maha basar! Syukur! Alhamdulilah! Aku sudah wagas!\" ujarnya baucap mamuji Allah. ");
INSERT INTO bjn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","“Allah maha basar! Ajaib banar paristiwa nang kita saksiakan hari ini!” ujar samunyaan urang tadi sambil tahiran-hiran wan katakutanan. ");
INSERT INTO bjn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wayah Nabi Isa kaluar, ada malihat saikung tukang tagih pajak nang bangaran Lewi. Inya parahatan duduk di wadah inya bagawi managih pajak. Lalu Nabi Isa baucap lawan inya, “Amun ikam hakun, umpati Aku, jadi pangikutKu.” ");
INSERT INTO bjn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Langsung ai Lewi badiri. Ditinggalakannya gawiannya gasan maumpati Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Imbah itu, Lewi basaruan di rumahnya gasan mahurmati Sidin. Maka banyak banar datangan tukang tagih pajak wan urang-urang nang lain makanan baimbai lawan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","“Hakunyalah bubuhan ikam makanan baimbai lawan tukang-tukang tagih pajak wan urang-urang badusa nang lainnya?” ujar babarapa pamuka agama wan guru-guru agama baucap sambil bamamai lawan pangikut-pangikut Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Lalu Nabi Isa baucap, “Lain urang sihat pang nang mamarluakan tabib, tagal nang garing haja. ");
INSERT INTO bjn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nang kaya tabib batujuan mawagasakan urang garing, Aku datang batujuan handak mambawai urang nang badusa sakira batobat. Aku kada mambawai urang nang manganggap dirinya saleh!” ");
INSERT INTO bjn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wayah itu, ada urang-urang mandatangi Nabi Isa lalu batakun lawan Sidin, “Bubuhan pangikut Nabi Yahya tabiasa bapuasa wan sambahyang. Nang kaya itu jua pamuka agama matan golongan Parisi. Tagal kanapa maka bubuhan pangikut Pian kada umpat bapuasa?” ");
INSERT INTO bjn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lalu Nabi Isa baucap, “Nah kaya ini nah. Kadada kakawalan pangantin lalakian nang disuruh bapuasa amun pangantin lalakiannya tu ada di wadah bubuhannya! Nang kaya itu jua salawas Aku ada lawan pangikut-pangikutKu, bubuhannya kada bapuasa jua\" “Coba bubuhan ikam pikirakan napa nang cagar tajadi amun pangantin lalakiannya tu ditangkap musuh-musuhnya. Kaina hal nang itu tu nang cagar tajadi lawan Aku. Imbah itu tu, pangikut-pangikutKu cagar bapuasa lantaran marista\" ujar Nabi Isa manambahi. ");
INSERT INTO bjn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nabi Isa bakisah pulang. “Nah, nang ini nah pulang. Kadada urang nang marabit baju hanyar ditambalakan ka baju nang lawas lantaran nang hanyar tu bisa maulah rabit nang lawas. Nang hanyar tu kada rasuk pang mun ditambalakan ka baju nang lawas. Nang hanyar gin rusak jua paampihannya. ");
INSERT INTO bjn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nang kaya itu jua umpamanya mawadahi banyu anggur nang diulah matan kulit binatang. Kadada urang nang mambuati banyu anggur nang hanyar ka dalam wadah kulit nang lawas. Sualnya banyu anggur nang hanyar tu baragi wan mangaluarakan gas. Lalu wadah kulit nang lawas cagaran bungkas lalu kada kawa dibuati lagi. ");
INSERT INTO bjn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Banyu anggur nang hanyar mustinya dibuati ka dalam wadah kulit nang hanyar jua. ");
INSERT INTO bjn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kadada urang nang hakun nginum banyu anggur nang hanyar imbah manginum banyu anggur nang lawas sualnya inya musti baucap, 'Banyu anggur lawas nang ini pang tanyaman pada banyu anggur nang hanyar\" ujar Nabi Isa manutup kisah. Nabi Isa bapandir nang kaya itu tadi gasan mamadahakan amun nang diajarakan Sidin kada rasuk amun dicampur lawan ajaran wan aturan bubuhan pamuka agama waktu itu. ");
INSERT INTO bjn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wayah hari Sabat , Nabi Isa lagi bajalan di ladang gandum. Bubuhan pangikutnya umpat jua. Tagal lantaran bubuhannya lapar, maka diputiknya ai bigi gandum, digusuknya lawan tangan, lalu dimakan isinya. ");
INSERT INTO bjn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sakalinya ada jua pamuka-pamuka agama matan aliran Parisi di situ. Lalu bubuhan Parisi baucap lawan pangikut-pangikut Nabi Isa, “Kanapa bubuhan ikam ni malanggar aturan-aturan hukum Nabi Musa? Kada bulih pang bagawian pada hari Sabat, nang kaya mamutik gandum ni nah, kada bulih!” ");
INSERT INTO bjn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Lalu Nabi Isa manyahut, “Mustinya bubuhan pian maingat lagi manganai napa nang dilakuakan Nabi Daud lawan kakawalannya wayah bubuhannya lagi lapar!” ");
INSERT INTO bjn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“Kemah suci Allah dimasukinya, ruti diambilnya lalu dimakannya, wan dibagi-bagaiakannya ka kakawalannya. Padahal cuma imam-imam haja nang bulih makan ruti nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aku, nang datang matan surga, nang bahak manantuakan napa nang bulih digawi wayah hari Sabat” ujar Nabi Isa manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wayah hari Sabat nang lain, Nabi Isa masuk ka rumah ibadah mambari caramah. Di situ ada saikung urang nang tangan kanannya kada kawa digarakakan. ");
INSERT INTO bjn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ada jua guru-guru agama wan pamuka-pamuka agama aliran parisi nang handak mancari-cari kasalahan Nabi Isa sakira Sidin kawa disalahakan. Maka bubuhannya mahawasi tarus kalu ai Sidin mawagasakan urang garing wayah hari Sabat. ");
INSERT INTO bjn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tagal Nabi Isa sudah tahu pikiran bubuhannya. Lalu Nabi Isa baucap ka urang nang tangannya lumpuh, “Ayu nah, badiri ka tangah sini nah ikam sakira sabarataan urang kawa malihat.” Lalu badiri ai inya. ");
INSERT INTO bjn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","“Nah, nang mana nang bulih dilakuakan wayah hari Sabat, artinya balaku baikkah atawa balaku jahatkah, manyalamatakan urangkah atawa mamatiꞌi urangkah?” ujar Sidin batakun ka guru-guru agama tadi. Guru-guru agama tadi kadada nang manyahutnya. ");
INSERT INTO bjn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Lalu Nabi Isa malihat sakulilingan ka sabarataan urang nang ada di situ. “Surung pang tangan ikam tu nah!” Sidin baucap ka urang nang tangan kanannya kada kawa digarakakan. Lalu disurungnya ai. Langsung wagas tangannya. ");
INSERT INTO bjn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Malihat nang itu mambarangat ai hati musuh-musuh Nabi Isa lantaran bubuhannya maanggap kajadian nang itu malanggar aturan hari Sabat. “Kita apai lah urang nang ini?” ujar musuh-musuh Nabi Isa barunding handak mamatiꞌi Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Imbah itu, Nabi Isa naik ka bukit gasan badoa. Di situ Sidin badoa samalaman balantak ka subuh. ");
INSERT INTO bjn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Baisukannya Sidin mangiau bubuhan pangikut-pangikut Sidin. Di antara bubuhannya, dipilih Sidin dua balas urang nang disambat Sidin rasul. Bubuhannya nang dipilih tu bangaran: ");
INSERT INTO bjn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simun, nang dingarani Sidin Pitrus, Andrias ading Simun, Yakub, Yahya, Pilipus, Bartulumius, ");
INSERT INTO bjn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tumas, Yakub bin Alpius, Simun nang suah umpat mambibasakan juriat Nabi Ibrahim matan panjajahan Romawi, ");
INSERT INTO bjn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas bin Yakub, wan Yudas Iskariut nang kaputingannya bahianat lawan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Imbah itu, Nabi Isa turun matan bukit baimbai lawan pangikut-pangikut Sidin lalu bamandak wan badiri di tanah lapang. Di situ tu sudah banyak bakumpulan pangikut-pangikut Sidin nang lain. Ada nang datangan matan saluruh banua Yudea, kuta Yarusalim; wan ada jua matan kuta Tirus dan Sidun nang ada di pinggir pantai. ");
INSERT INTO bjn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bubuhannya tadi datangan handak mandangarakan caramah Sidin wan ada jua nang handak minta diwagasakan panyakitnya. Nang kasarungan ruh-ruh jahat gin ampih kasarungan. ");
INSERT INTO bjn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Samunyaan urang handak manjapai awak Sidin sualnya di awak Sidin ada kuasa nang kaluar nang kawa mawagasakan wan mawarasakan urang. ");
INSERT INTO bjn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wayah itu, Nabi Isa manjanaki pangikut-pangikut Sidin, lalu baucap, “Bahimunglah bubuhan ikam nang miskin, lantaran bubuhan ikam sudah manjadi anggota karajaan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bahimunglah bubuhan ikam nang lapar, karna bubuhan ikam cagar dikanyangakan. Bahimunglah bubuhan ikam nang manangis lantaran bubuhan ikam cagaran tatawa. ");
INSERT INTO bjn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bahimunglah wan basuka haja bubuhan ikam nang dimuari, ditolak, dihina, wan difitnah lantaran bubuhan ikam maumpati Aku, nang datang matan surga, ");
INSERT INTO bjn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","sualnya pahalanya ganal banar gasan bubuhan ikam di surga kaina. Bubuhan nabi bahari gin diulah nang kaya itu jua. Lantaran itu, bubuhannya dapat pahala matan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Cilakalah bubuhan ikam nang sugih, sualnya ikam sudah marasaakan nyaman wayahini. Kaina tinggal mahadang cilakanya haja lagi. ");
INSERT INTO bjn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Cilakalah bubuhan ikam nang wayahini kakanyangan, kaina ikam cagar kalaparan. Cilakalah bubuhan ikam nang wayahini tatawa. Kaina ikam cagar basadih wan manangis. ");
INSERT INTO bjn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Cilakalah bubuhan ikam amun hakun diambung urang tarus. Urang-urang bahari nang bapiragah jadi nabi gin diambung jua. Imbah itu bubuhannya dihukum Allah. ");
INSERT INTO bjn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Tapi kupadahilah, sayangi samuaan urang tamasuk musuh-musuh ikam. Babuat baiklah lawan urang nang muar lawan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mintalah lawan Allah sakira urang nang manyumpahi ikam mandapat barakah. Dua'akan nang baik-baik gasan samunyaan urang tamasuk urang nang manjahati ikam. ");
INSERT INTO bjn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amun ada urang nang manapak pipi ikam gasan manyupani ikam, unjuki jua pipi nang subalahnya pulang. Amun jubah bubuhan ikam diambil urang, biarakan ha inya maambil baju ikam jua. ");
INSERT INTO bjn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bariꞌi haja urang nang maminta lawan bubuhan ikam! Jangan maminta bulikakan ampun ikam nang sudah diambil urang. ");
INSERT INTO bjn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kaya apa sakira urang-urang babuat baik lawan ikam? Nah, lakuakan jua nang kaya itu ka urang lain. ");
INSERT INTO bjn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Satiap urang ada haja nang sayang lawan inya. Ada jua nang kada sayang lawan inya. Amun bubuhan ikam cuma sayang wan urang nang sayang lawan bubuhan ikam, kada jadi bapahala! Urang-urang nang badusa gin sayang jua lawan urang-urang nang sayang lawan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amun bubuhan ikam babuat baik cuma lawan urang-urang nang babuat baik lawan ikam, kada bapahala jua. Urang nang badusa gin babuat baik jua lawan urang nang babuat baik lawan inya. ");
INSERT INTO bjn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amun bubuhan ikam mainjami cuma ka urang nang kawa mambulikakannya haja, kada bapahala jua. Urang badusa gin mainjami nang kaya itu jua. ");
INSERT INTO bjn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tapi jangan nang kaya itu lah! Sayangi musuh-musuh bubuhan ikam. Babuat baiklah lawan bubuhannya. Injami haja bubuhannya. Kada usah baharap dibulikakan. Kaina tu ganal pahala bubuhan ikam. Amun ikam balaku nang kaya itu tadi, itu pang nang mambuktiakan kalu ikam sudah balaku kaya Nang Di Atas. Sualnya Nang Di Atas tu baik jua lawan samunyaan urang tamasuk nang jahat wan nang kada manyukuri pambarian-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Abah surgawi katuju manulungi urang. Maka bubuhan ikam musti katuju jua manulungi urang nang kaya Abah nang di atas. ");
INSERT INTO bjn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jangan maniwas urang sakira bubuhan ikam kada ditiwas urang jua! Jangan mahakimi urang sakira bubuhan ikam kada dihakimi urang jua! Ampuni haja! Kaina gin ikam diampuni jua. ");
INSERT INTO bjn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bariꞌi! Kaina ikam gin dibariꞌi jua. Bariꞌi nang baik. Ikam gin cagaran dibariꞌi nang baik jua. Sabujurannya bubuhan ikam cagar baulihi pambarian nang banyak banar nang sudah ditakar bajubung gasan ikam. Sualnya takaran nang ikam pakai gasan urang cagar dipakai jua gasan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Urang picak kada kawa manuntun urang picak! Kaina kaduduanya bisa tabarusuk ka dalam luang.” ");
INSERT INTO bjn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Kadada pang murid nang tapintar pada gurunya. Tagal amun inya cangkal tuntung balajar, kawa ai sama pintarnya kaya gurunya. ");
INSERT INTO bjn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kanapa ikam malihat sahimpil kayu di mata dangsanak ikam, tagal balokan di mata ikam saurang, kada ikam lihat? ");
INSERT INTO bjn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mana kawa ikam baucap lawan dangsanak ikam, ‘Dangsanakku, maraha aku mangaluarakan sahimpil kayu tu di mata ikam’, sadangkan di mata ikam saurang ada balokan nang kada ikam lihat? Ui, urang-urang nang bapiragah alim, kaluarakan dahulu balokan nang ada di mata ikam saurang! Hanyar ikam kawa jalas malihat wan kawa mangaluarakan sahimpil kayu nang ada di mata dangsanak ikam” ujar Nabi Isa manutup caramah. ");
INSERT INTO bjn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nabi Isa bakisah pulang, “Kadada puhun nang baik nang mahasilakan buah nang kada baik. Kaya itu jua, kadada puhun nang kada baik nang mahasilakan buah nang baik. ");
INSERT INTO bjn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sualnya satiap puhun dipinandui matan buahnya. Puhun rukam kada babuah limau. Lawan pulang, kumpai baduri kada babuah tomat. ");
INSERT INTO bjn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Urang nang baik mangaluarakan hal-hal nang baik matan hatinya nang baik. Urang nang jahat mangaluarakan hal-hal nang jahat matan hatinya nang jahat. Sualnya napa nang diucapakan urang kaluar matan hatinya.” ");
INSERT INTO bjn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Kanapa maka bubuhan ikam mangiau Aku ‘Junjungan’ tagal kada maasi lawan Aku? ");
INSERT INTO bjn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Urang nang datang, mandangar wan maasi pandiranku, inya kaya urang nang ");
INSERT INTO bjn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","baulah rumah. Urang tu manabuk dalam-dalam sampai ka batu, lalu pundasi rumah diulah di atas batu sakira nahap. Bilanya banyu baꞌah ganal datang lalu mahantam rumahnya, rumah nang itu kada rabah sualnya pundasinya nahap banar. ");
INSERT INTO bjn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sadangkan, urang nang mandangar pandiranKu tagal kada maasi, inya kaya urang nang baulah rumah di atas tanah nang kada bapundasi. Bilanya banyu baꞌah ganal datang, lalu ai rumah tu tahambur barataan.” ");
INSERT INTO bjn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Imbah tuntung bacaramah, bulik ai Sidin ka kuta Kapernaum. ");
INSERT INTO bjn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Di situ ada saikung komandan Rumawi nang baisian saikung sasuruhannya nang disayanginya banar. Sasuruhannya tu garing bangat wan parak mati. ");
INSERT INTO bjn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wayah komandan tu mangatahui manganai Nabi Isa, disuruhnya babarapa tatuha juriat Nabi Ibrahim mandapati Sidin maminta supaya datang gasan mawagasakan sasuruhannya. Lalu tulakan ai bubuhannya ka wadah Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wayah batamuan wan Nabi Isa, bubuhannya mamohon banar sakira Sidin hakun manulungi. Lalu bubuhannya baucap ka Nabi Isa, \"Urang nang itu tu wajar haja pian tulungi ");
INSERT INTO bjn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sualnya sidin tu baik banar budinya. Sidin manyayangi banar lawan urang kita. Sidin tu pang nang maulahakan rumah ibadah gasan kami.\" ");
INSERT INTO bjn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lalu Nabi Isa tulakan baimbai lawan tatuha-tatuha tadi. Pas bubuhannya parak sampai rumah komandan tadi, komandan tu manyuruh kakawalannya manyampaiakan pasan ka Nabi Isa, \"Junjungan kada usah bangalih-ngalih gin. Sualnya ulun ni kada pantas Pian elangi. ");
INSERT INTO bjn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ulun gin kada pantas mandapati Pian. Pian baucap sabatik gin, maka wagasam sasuruhan ulun kaina. ");
INSERT INTO bjn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sualnya ulun ni gin saurang bawahan jua wan dibawah ulun ada lagi parajurit-parajurit nang musti maasi samunyaan parintah ulun. Amun ulun manyuruh parajurit tu tulak, musti tulak inya. Amun ulun manyuruh ka prajurit nang lain, ‘Ka sia ikam!’, musti ka sia inya. Amun ulun manyuruh ka sasuruhan ulun, ‘Gawi nang ini!’, musti manggawi inya\" ujar pasan komandan tadi ka Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Imbah mandangar ucapan komandan tadi, Nabi Isa tahiran-hiran ucapannya sambil manulih ka urang banyak nang ada di situ lalu baucap, “Umaailah! Aku kada suah lagi manamui urang nang baiman kaya ini. Baarti sidin tu bujur-bujur baiman ka aku. Takuat sidin imannya pada juriat Nabi Ibrahim! ");
INSERT INTO bjn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Imbah urang-urang suruhan komandan tu bulikan, lalu didapatinya sasuruhan komandan tu sakalinya sudah sigar (sehat) pulang. ");
INSERT INTO bjn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kada lawas limbah nitu, Nabi Isa lawan bubuhan pangikut Sidin tulakan ka kuta Nain. Banyak urang nang lain bajurut-jurut maumpati Sidin jua. ");
INSERT INTO bjn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Parak garbang kuta nang itu, ada urang kuta bajurut-jurut manandu kaluar saikung urang nang sudah mati. Urang nang mati tu anak lalakian saikungannya, umanya sudah balu. ");
INSERT INTO bjn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pas Junjungan malihat bibinian balu tu, Sidin maras banar, lalu baucap, “Pian, kada usah basadih. Kada usah manangis, Cil ai!” ");
INSERT INTO bjn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Diparaki Sidin tanduannya, lalu dijapai Sidin. Parahatan nang manandu bamandak, lalu Nabi Isa baucap “Nak, bapuat ikam nak!” ");
INSERT INTO bjn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Imbah itu, sakalinya bapuat ai anak nang sudah mati tu, baduduk inya lalu kawa bapandir pulang. \"Cil, ini nah anak Pian\" ujar Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Imbah malihat kajadian tu, samunyaan urang takajut wan takagum-kagum. “Nabi nang mulia sudah datang di tangah-tangah kita, Allah sudah datang manulungi umat-Nya” ujar bubuhannya sambil mamuji Allah. ");
INSERT INTO bjn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lalu mujijat Nabi Isa tadi tahabar ka unjut-unjut Yudea wan ka unjut-unjut banua higa-mahiganya. ");
INSERT INTO bjn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Imbah Nabi Yahya mandangar habar manganai kajadian nang itu matan pangikut-pangikutnya, lalu sidin mangiau dua ikung pangikutnya ");
INSERT INTO bjn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","wan nang badua tu disuruh mahadap Nabi Isa gasan batakun, “Piankah Al Masih nang dijanjiakan Allah tu? Atawa kami mahadang urang nang lain lagi nang diutus Allah?” Nang kaya itu pasan Nabi Yahya. ");
INSERT INTO bjn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lalu tulakan ai kaduduannya mandapati Nabi Isa. “Guru, Nabi Yahya manyuruh kami batakun, Piankah Al Masih nang dijanjiakan Allah tu? Atawa urang lain lagi nang musti kami hadangi?” ujar kaduduannya batakun. ");
INSERT INTO bjn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wayah nitu, banyak urang diwagasakan, ruh-ruh jahat disuruh bajauh, wan urang picak diwagasakan ulih Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lalu Nabi Isa baucap, “Bulikan ja bubuhan ikam, padahakan lawan Nabi Yahya napa-napa nang sudah ikam lihat wan sudah ikam dangar. Nang picak sudah kawa malihat, nang lumpuh sudah kawa bajalan, urang kusta sudah manjadi barasih lantaran wagas pulang, urang tuli sudah kawa mandangar, urang mati sudah dihidupakan pulang, lawan pulang Habar Baik sudah jua dihabarakan ka urang-urang miskin. ");
INSERT INTO bjn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Babahimunglah urang-urang nang baiman ka Aku biar Aku ni lain daripada nang diharapakan urang!” ");
INSERT INTO bjn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Imbah bubuhan pangkut Nabi Yahya bulikan, lalu Nabi Isa bamula bapandir ka urang-urang nang ada di situ manganai Nabi Yahya. “Sabalum palayanan-Ku bamula, kanapa bubuhan ikam rancak bajalan jauh kaluar masuk padang pasir handak malihat Nabi Yahya? Gasan malihat sasuatu nang biasa hajakah nang kaya puhun paring nang digoyang angin? Kada mungkin, kalo? ");
INSERT INTO bjn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Amun kada gasan malihat puhun paring, gasan malihat urang sugih nang babaju haratkah? Kadada bataha ada pang disana. Amun handak malihat nang itu, adanya cuma di istana raja haja. ");
INSERT INTO bjn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Maka bubuhan ikam handak malihat siapa garang? Saurang nabikah? Nah, bujur tu! Kupadahilah bubuhan ikam, malah sidin itu labih panting dari saurang Nabi. ");
INSERT INTO bjn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lantaran manganai sidin tu, ada tatulis dalam Kitab Suci Taurat: ‘Lihat ja, Aku mautus utusanKu badahulu pada Ikam, inya cagar mambuka jalan Ikam sabalum Aku mautus Ikam.’ ");
INSERT INTO bjn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Di antara urang nang diranakakan ulih babinian kadada darajatnya labih mulia pada Nabi Yahya. Tagal nang paling randah gin dalam Karajaan Allah, labih mulia darajatnya pada inya.” ");
INSERT INTO bjn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Samunyaan nang mandangarakan pandiran Nabi Isa, tamasuk tukang-tukang tagih pajak, maakui kabanaran Allah, lantaran bubuhannya sudah dimandiꞌi ulih Nabi Yahya sabagai ciri partobatan. ");
INSERT INTO bjn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tagal urang-urang matan aliran Parisi wan guru-guru agama mambantah kahandak Allah lantaran bubuhannya kada hakun dimandiꞌi Nabi Yahya sabagai ciri partobatan. ");
INSERT INTO bjn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nabi Isa manarusakan caramahnya, “Aku musti mancuntuhakan gasan gambaran kabanyakan urang nang hidup pada zaman wayahini. ");
INSERT INTO bjn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bubuhannya nang kaya dua kalumpok kakanakan nang bamain di halaman. Kalumpok nang satu bakiau ka kalumpok nang kadua, ‘Saban kalian kami mambawai bubuhan ikam bamain, bubuhan ikam tatap kada hakun! Amun kami maniup lagu tarian pakai suling, bubuhan ikam kada hakun baigal. Tagal wayah kami bamain nang basadih, bubuhan ikam kada hakun manangis.’ ");
INSERT INTO bjn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kakanakan tadi gambarannya urang-urang wayahini. Sualnya wayah Nabi Yahya datang, inya rancak bapuasa wan inya kada manginum banyu anggur. Tagal, bubuhan ikam baucap, ‘Inya kasarungan ruh jahat pang.’ ");
INSERT INTO bjn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Lalu, Aku, nang datang matan surga, datang jua, lalu makan wan nginum. Lalu bubuhan ikam baucap, ‘Lihati ja nang katuju mambantas, si pamabuk, wan kawal tukang-tukang tagih pajak wan urang-urang badusa lainnya. ");
INSERT INTO bjn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Biar nang kaya itu, kabijaksanaan Allah musti haja tabukti bujur malalui urang-urang nang manarimanya wan malakuakannya.” ");
INSERT INTO bjn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ada saikung pamuka agama nang bangaran Simun. Simun tu manyarui Nabi Isa gasan makanan di rumahnya saurang. Lalu datang ai Nabi Isa ka rumahnya lalu umpat makan baimbai. ");
INSERT INTO bjn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Di kuta nang itu, ada jua saikung lahung. Pas inya mandangar amun Nabi Isa ada di situ, datang ai inya mambawa sabutul pualam nang baisi minyak harum. ");
INSERT INTO bjn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Inya badiri di balakang Nabi Isa, parak batis Sidin nang duduk bahiring nang batisnya bahunjur. Lalu manangis ai inya sampai banyu matanya titikan mambasahi batis Sidin. Imbah itu, batis Sidin dilapnya lawan rambutnya. Batis Sidin diciumnya sabagai ciri hurmat, lalu dituanginya minyak harum. ");
INSERT INTO bjn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pas Simun malihat kajadian nang itu, inya bapandir dalam hati, “Amun Inya dasar saurang nabi, musti tahu Inya siapa babinian nang manjapainya tu, wan dusa-dusa nang suah diulahnya.” ");
INSERT INTO bjn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Lalu ujar Nabi Isa manyahuti pikiran-pikiran Simun, “Aku tahu ai, Simon ai, urang ni! Ada nang handak Kupadahakan lawan ikam.” “Pian sambat haja!” ujar Simun. ");
INSERT INTO bjn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ada dua urang nang bahutang lawan urang. Nang saikung bahutang sabanyak dua bulan gaji, nang saikungnya bahutang sabanyak dua tahun gajinya. ");
INSERT INTO bjn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lantaran kada kawa bayar, hutang inya badua tu dihapus. Nang mana nang labih mangasihi tukang pinjam duit tu?” ujar Nabi Isa batakun. ");
INSERT INTO bjn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Asanya urang nang paling banyak hutangnya pang” ujar Simun manyahut. “Bujur banar ikam tu!” ujar Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","“Lihati ja inya ni! Wayah Aku masuk ka rumah ikam, ikam kada mambari banyu gasan mambasuh batisku nang rigat nang kaya adat kita. Tagal, inya ni mambasuh batisku lawan banyu matanya, lalu dilapnya lawan rambutnya.” ");
INSERT INTO bjn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Ikam, Simun ai, kada mancium Aku nang kaya adat kita. Tagal inya ni manciumi tarus ka batisKu. ");
INSERT INTO bjn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ikam kada maminyaki rambutku nang kaya adat kita. Tagal inya ni maminyaki batisKu lawan minyak harum. ");
INSERT INTO bjn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Makanya kasihnya nang tulus ni wan Aku mambuktiakan amun dusanya nang banyak tu sudah diampuni. Tagal nang sadikit diampuni, sadikit jua manyayangi Tuhan” ujar Nabi Isa manjalasakan lawan Simun. ");
INSERT INTO bjn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","“Nah, dusa ikam sudah Kuampuni” ujar Nabi Isa ka lahung tadi. ");
INSERT INTO bjn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","“Bah! Inya ni kada bahak maampuni dusa-dusa urang! Allah haja nang kawa maampuni dusa urang tu! Syirik inya ni!” ujar bubuhan pamuka agama nang umpat makan di situ. ");
INSERT INTO bjn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","“Ikam disalamatakan lantaran ikam baiman ka Aku. Bulik ja ikam lawan hati nang lapang bahagia!” ujar Isa ka lahung tadi. ");
INSERT INTO bjn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kada lawas limbah nitu, Nabi Isa bakuliling ka kuta-kuta wan ka kampung-kampung gasan bacaramah wan mahabarakan habar baik manganai Karajaan Allah, iaitu nang kaya apa sakira urang kawa masuk ka dalam Karajaan Allah. Umpat jua bubuhan pangikut Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ada jua bibinian-bibinian nang sudah diwarasakan Sidin matan roh jahat. Ada Maryam, nang baasal matan kuta Magdalena. Dahulunya inya suah dirasuki ulih tujuh ruh jahat, lalu inya diwarasakan jua ulih Nabi Isa. Ada jua Yoana, bininya Khusa, nang tukang simpan duit raja Herodes. ");
INSERT INTO bjn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ada jua Susana wan ada jua babinian-babinian lain. Samunyaan babinian-babinian nang itu umpat mambari'i ungkos-ungkos gasan palayanan rombongan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wayah itu, urang-urang tatarusan badatangan matan banyak kuta handak mandatangi Nabi Isa. Pas urang-urangnya saling banyakan takumpulan, hanyar Sidin bamula bakisah. ");
INSERT INTO bjn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nah, ini nah ada satu kisah. Ada saikung patani nang mahambur banih di ladangnya. Sapalih tagugur di tanah jalanan, lalu tajajak urang, wan dipatuki burung sampai lingis. ");
INSERT INTO bjn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sapalih tagugur ka tanah nang babatu-batu. Banih nang itu tumbuh haja. Lalu layu lantaran tanahnya kadada banyunya. ");
INSERT INTO bjn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Sapalih tagugur di tanah di kumpai nang baduri. Tapi kumpainya nang manang. ");
INSERT INTO bjn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sisanya digugurakan di tanah nang subur. Nah, tumbuh subur ai lalu babuah, saratus kali lipat daripada banih nang dihamburakan” ujar Nabi Isa manutup kisah tadi. “Ingatakanlah pandiranku tadi tu nah” ujar Nabi Isa manambahi. ");
INSERT INTO bjn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","“Guru, umpat batakun, bulihlah? Apa garang maksud kisah pian tadi?” ujar sapalih pangikut Sidin nang kada tapi paham. ");
INSERT INTO bjn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","“Bubuhan ikam dibari pangatahuan manganai rahasia-rahasia karajaan Allah. Tagal gasan nang lain, dilajari lawan kisah-kisah haja. Bubuhannya mandangar haja tapi kada paham sualnya Allah bakahandak supaya napa nang ditulis ulih Nabi Yasaya tajadi. Nang ditulisnya tu babunyi nang kaya ini nah, ‘Biar bubuhannya banyak malihat mujijat-mujijat, bubuhannya kada cagaran paham napa nang tajadi. Wan biar bubuhannya tatarusan mandangarakan ajaran, bubuhannya kada cagaran paham jua’” ujar Nabi Isa manyahut tatakunan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ini nah arti kisah tadi nah” ujar Nabi Isa manjalasakan. “Banih nang dihamburakan tadi, itu Pirman Allah. ");
INSERT INTO bjn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Banih nang tagugur katanah jalanan tadi, itu urang nang mandangar Pirman Allah. Tagal lantaran Iblis nang datang marampas Pirman tadi matan hati urang tu, maka urang tadi kada parcaya wan kada disalamatakan matan hukuman dusa-dusanya. ");
INSERT INTO bjn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Banih nang tagugur di tanah nang babatu-batu tu, itu urang nang mandangar Pirman tadi wan himung banar manarimanya. Tagal nang kaya banih nang akarnya kada kawa tumbuh lagi, artinya inya parcaya satumat haja. Lantaran hidupnya sasain ngalih, lalu inya kada parcaya lagi. ");
INSERT INTO bjn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Banih nang tagugur di tanah nang bakumpai baduri tu, itu urang nang mandangar haja. Lalu nang kaya banih tu tumbuhnya kalah wan kumpai tadi, inya kalah lantaran inya mamantingakan hal-hal duniawi haja. Lalu inya kada taat lagi lawan Pirman Allah. ");
INSERT INTO bjn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nah, lain lagi banih nang tagugur di tanah subur tu, ini urang nang mandangarakan Pirman tadi lalu maingatakannya tarus sampai bujur-bujur taat. Lalu nang kaya banih nang babuah, inya urang-urang nang bujur-bujur manarima wan maamalakannya.” ");
INSERT INTO bjn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nabi Isa bakisah pulang, \"Kadada pang urang nang malikit lampu lalu ditukupinya pakai balanai atawa diandaknya kabawah ranjang. Lampu tu musti diandaknya di wadah nang tinggi nyaman urang nang masuk ka rumah kawa malihat cahayanya nang tarang. ");
INSERT INTO bjn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nang kaya itu jua, Aku bacaramah mamakai kisah. Nang wayahini artinya dirahasiaakan, tagal kaina samunyaan cagaran jalas katahuan. Nang wayahini kada jalas, kaina cagaran jalas. ");
INSERT INTO bjn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lantaran itu, dangarakan baik-baik caramahKu! Urang nang hakun manarima ajaranKu, Allah pacang manambahi kamampuan inya supaya magin bapaham. Tagal urang nang kada hakun manarima ajaranKu, biar inya baisi pikiran amun inya paham sadikit, Allah cagar maambil kamampuannya gasan mamahaminya.\" ");
INSERT INTO bjn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Imbah itu, datang ai uma lawan dangsanak Nabi Isa handak badapat lawan Sidin. Sakalinya kada kawa masuk ka rumah tu nah, lantaran banyak banar urang bakakajalan. ");
INSERT INTO bjn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tagal di situ ada saikung urang nang mamadahakan, “Junjungan, itu nah ada uma lawan dangsanak Pian di luar. Handak badapat Pian jar.” ");
INSERT INTO bjn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lalu Nabi Isa manyahut, “Samunyaan urang nang mandangar wan manaati Firman Allah, itu pang nang Kuanggap kaya kulawargaKu.” ");
INSERT INTO bjn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wayah itu, Sidin wan pangikut-pangikut Sidin babuatan ka dalam sabuah parahu. Lalu ujar Sidin, “Ayu kita manyubarangi danau.” Lalu tulakan ai bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Parahatan balayar, Sidin taguring. Bakakajutan datang angin ribut. Parahunya kamasukan banyu sampai parak tinggalam. ");
INSERT INTO bjn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bubuhan pangikut Sidin manggarak Sidin. “Guru bamatian kita ini nah(means 'hampir tajadi')!” ujar bubuhannya. Badiri ai Nabi Isa. “Angin, baranai pang ikam!” ujar Sidin manyuruh angin ribut tadi. Imbah Nabi Isa baucap nang kaya itu, baranai ai angin ribut tu. Lawan banyu kada bagalombang lagi. ");
INSERT INTO bjn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Mustinya bubuhan ikam baiman lawan Aku” ujar Sidin. “Umaailah, hibat banar Sidin ni. Sidin manyuruh angin ribut baranai. Lalu, angin ributnya maasi lawan Sidin! Langsung baranai haja!\" ujar bubuhannya batakun-takun pina katakutanan wan takajut. ");
INSERT INTO bjn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kada lawas imbah itu, sampai ai bubuhannya kasubarang danau Galilea di banua urang Gerasa. ");
INSERT INTO bjn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pas Nabi Isa turun ka tanah, Sidin didatangi saikung lalakian nang kasarungan ruh-ruh jahat. Urang tu datang matan kuta. Inya sudah lawas batilanjang. Lawan pulang inya kada hakun guring di rumah. Inya guring di guha pakuburan haja. ");
INSERT INTO bjn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Rancak sudah ruh-ruh jahat tadi maulah urang tu mahamuk. Maka gasan manjaganya sakira kada mahamuk lagi, tangan lawan batisnya dipasung lawan rantai. Tagal biar dipasung lawan rantai, rantainya gin kawa dipagatnya. Lalu inya dibawai ruh-ruh jahat ka wadah-wadah nang sunyi. Imbah mandatangi Nabi Isa, inya langsung basujut di hadapan Sidin. \"Bajauh ikam!\" ujar Nabi Isa manyuruh ruh-ruh jahat tadi bajauh. “Nabi Isa! Anak Nang di Atas, nang diutus Allah nang Mahatinggi! Handak baapa pian lawan ulun? Tolong pang jangan disiksa ulun!” ujar urang nang kasarungan tadi sambil basuara nyaring. ");
INSERT INTO bjn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Ngaran ikam siapa garang?” ujar Nabi Isa batakun. “Kami banyak!” ujar urang tu manyahut. Inya baucap nang kaya itu lantaran banyak banar ruh-ruh jahat nang sudah manyarunginya. ");
INSERT INTO bjn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","“Junjungan, tuluuuung! Kami jangan diusir ka naraka! ");
INSERT INTO bjn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ijinakan kami masuk ka babi-babi nang itu!” ujar ruh-ruh jahat tadi bakali-kali mamohon ka Nabi Isa. Kada jauh matan situ, banyak babi nang lagi makanan di pinggiran bukit. “Ayu ja. Bubuhan ikam marasuki ka awak babi-babi nang itu nah” ujar Nabi Isa mambulihakan. ");
INSERT INTO bjn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Langsung ai ruh-ruh jahat tadi kaluaran, lalu langsung ai babi-babi nang banyak tu dirasukinya. Bukahan ai babi-babi tu, lalu tajunan tumatan pinggir tabing ka dalam danau. Mati lamasan ai babi-babi tu. ");
INSERT INTO bjn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Imbah malihat kajadian tadi, bubuhan tukang jaga babi bagagas bukahan ka kuta wan ka kampung-kampung nang parak sambil mahabarakan kajadian nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Urang-urang nang hanyar mandangar kajadian nitu datangan handak malihat jua napa nang tajadi. Wayah badapat lawan Nabi Isa, bubuhannya malihat urang nang bakas kasarungan tadi tu, sudah babaju wan sudah waras. Inya lagi baduduk parak batis Nabi Isa. Maka takutan ai bubuhan nang hanyar datang tadi, sualnya bubuhannya hanyar haja tahu manganai kuasa Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Urang-urang nang manyaksiakan kajadian nang itu mangisahakan ka urang-urang lain di situ kaya apa urang tadi bisa waras. ");
INSERT INTO bjn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lalu samunyaan panduduk di banua Gerasa itu maminta banar sakira Nabi Isa bajauh matan banua nang itu sualnya bubuhannya takutan banar lawan kuasa Nabi Isa. Imbah itu, Nabi Isa handak babuat ka dalam parahu wan handak bulik ka subarang danau. ");
INSERT INTO bjn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lalu, urang nang hanyar waras tadi mandatangi Nabi Isa lalu baucap, “Ulun handak umpat lawan Pian. Kamana haja! Kawalah?” ");
INSERT INTO bjn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bulik haja gin ikam! Kisahakan samunyaan nang Allah parbuat lawan ikam!” ujar Nabi Isa manyahut. Maka tulak ai urang tadi ka saluruh kuta, lalu dikisahakannya napa nang dilakuakan Nabi Isa lawan inya. ");
INSERT INTO bjn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Imbah Nabi Isa babulik ka subarang danau Galilea, urang himung banar manyambut Sidin. Sualnya bubuhannya rahatan mahadang-hadang kadatangan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Di situ ada saikung lalakian nang bangaran Yairus nang mahadangi jua. Sidin tu kapala rumah ibadah. “Guru, tulungi pang ulun! Anak ulun garing bangat, parak mati. Tulung!” ujarnya sambil basujut di hadapan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Anak babinian nang saikungannya matan Yairus tu baumur kurang labih dua walas tahun. Rahatan Nabi Isa baampah ka wadah urang tadi, Sidin dikajali ulih urang-urang banyak. ");
INSERT INTO bjn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Di situ ada saikung babinian nang sudah dua walas tahun maarit pandarahan paranakannya tarus-manarus. Sudah habis banyak hartanya lantaran inya baubat ka mana-mana. Tagal kadada saikung-ikung tabib nang kawa mawagasakannya. ");
INSERT INTO bjn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Diparakinya Nabi Isa matan balakang. Dijapainya rumbai jubah Sidin. Langsung ampih pandarahannya. ");
INSERT INTO bjn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lalu Nabi Isa baucap, “Siapa garang nang manjapai Aku ni?” “Guru, sing banyakan urang bakajal-kajal di higa Pian. Kanapa maka sampai Pian batakun nang kaya itu?” ujar Pitrus manyahut lantaran saikung-ikung kadada nang maakuinya. ");
INSERT INTO bjn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","“Aku sudah tahu ada saikung urang nang manjapai rumbai jubahKu sualnya Aku ni marasa ada kuasa kaluar matan awakKu\" ujar Nabi Isa manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wayah babinian tu sadar amun kalakuannya sudah katahuan, diparakinya ai Nabi Isa sambil manggatar. Langsung basujut ka hadapan Sidin. Lalu bakisah ai inya ka samunyaan urang kanapa maka inya manjapai rumbai jubah Sidin. Dikisahakannya jua amun inya langsung wagas wayah itu jua. ");
INSERT INTO bjn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","“Ui anak ku, ikam wagas lantaran ikam baiman ka Aku. Tulak ja ikam lawan hati nang lapang bahagia\" ujar Nabi Isa baucap lawan babinian tadi. ");
INSERT INTO bjn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wayah Nabi Isa masih bapandir, ada urang nang datang matan rumah Jairus. “Anak ikam sudah maninggal. Ikam kada usah manga-ngalihi Guru gin!” ujar urang tadi ka Jairus. ");
INSERT INTO bjn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pandirannya tadi didangar ulih Nabi Isa. “Kada usah takutan! Baiman ja ka Aku. Anak ikam cagaran waras!” ujar Sidin ka Yairus. ");
INSERT INTO bjn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lalu, Nabi Isa baimbai ai wan Yairus ka rumahnya. Imbah sampai di rumah Yairus, Nabi Isa manangati urang umpat masuk kacuali Pitrus, Yahya, Yakub, Yairus wan uma anaknya tu haja. ");
INSERT INTO bjn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Samunyaan urang nang di luar rumah tu rahatan manangisi wan maratapi anak nitu. “Kada usah ditangisi gin. Anak nitu kada mati. Inya guring haja,\" ujar Nabi Isa baucap ka urang banyak tadi. ");
INSERT INTO bjn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sapalih urang di situ, ada nang mananawaakan Sidin sualnya urang-urang tadi tahu anak babinian tu sudah mati. ");
INSERT INTO bjn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lalu Nabi Isa masuk ka rumah lalu mamingkuti tangan anak bibinian tu. “Nak! Bapuat ikam!” ujar Nabi Isa baucap ka anak babinian tadi. ");
INSERT INTO bjn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lalu, anak bibinian tu hidup pulang. Lalu, babangun ai anak tu. Imbah itu, Nabi Isa manyuruh mambari makan. ");
INSERT INTO bjn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kuitan anak nang itu jadi tahiran-hiran. “Bahinipan haja. Kada usah dikisahakan gin ka urang-urang sual kajadian nang ini” ujar Nabi Isa manangati bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Wayah itu, Nabi Isa manyuruh kaduablas urang pangikut Sidin bakumpul lalu Sidin baucap, “Nah, dangarakan baik-baiklah, bubuhan ikam Kusuruh tulak ka kuta-kuta lain, bubuhan ikam Kutugasakan mahabarakan kadatangan karajaan Allah, wan Kubari kuasa sakira kawa manyuruh ruh-ruh jahat bajauh, wan jua Kubari kuasa sakira kawa maampihi urang-urang nang bapanyakitan. ");
INSERT INTO bjn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Amun bubuhan ikam tulakan kaina, kada usah mambawa tungkat, kada usah mambawa kadut, kada usah mambawa makanan, kada usah mambawa duit, atawa baju tilasan. Pokoknya kada usah basangu napa-napa. ");
INSERT INTO bjn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amunnya kaina di kuta tu, ada warga nang hakun manarima bubuhan ikam, bubuhan ikam bagana ja di situ sampai tuntung napa nang kutugasakan lawan bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tagal amun bubuhan ikam kada ditarima di kuta tu, lalui haja kuta nang itu. Kibasakan haja dabu nang ada di salawar bubuhan ikam. Itu cirinya Allah cagar mahukum warga kuta tu lantaran kada hakun manarima utusan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Lalu tulakan ai bubuhannya malaksanakan tugas napa-napa nang diparintahakan Nabi Isa tadi. ");
INSERT INTO bjn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wayah itu, Raja Hirudis, nang bakuasa di banua Galilea, marasa pusang banar ada baidabul masalah mujijat-mujijat nang itu. Ada nang manyambat Nabi Yahya sudah hidup pulang. ");
INSERT INTO bjn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nang lain manyambat Nabi Ilyas atawa nabi nang tadahulu hidup pulang wan maulah mujijat-mujijat di situ. ");
INSERT INTO bjn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Raja Herudis baucap pina pusang, “Maka anak buahku sudah kusuruh mamanggal kapala Nabi Yahya. Ini siapa pulang nang maulah hal-hal nang kaya itu?” Lantaran itu, Hirudis rancak bausaha handak badapat lawan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Imbah bulikan matan malakuakan tugas-tugas tadi, pangikut-pangikut Sidin mamadahakan lawan Nabi Isa napa-napa nang sudah bubuhannya lakuakan. Lalu Nabi Isa mambawai bubuhannya ka sabuah kampung nang bangaran Betsaida sakira kawa bajauh matan urang banyak. ");
INSERT INTO bjn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sakalinya katahuan urang banyak, balalu ai urang banyak tu maumpatinya. Tagal Sidin mambulihakan haja bubuhannya umpat, lalu Sidin bacaramah manganai karajaan Allah, imbah itu maampihi urang-urang nang baisi bamacam-macam panyakit. ");
INSERT INTO bjn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Parak sanja, kadua walas pangikut Sidin mandatangi Sidin lalu baucap, “Guru, suruh pang bubuhannya tu tulakan ka kampung-kampung nang parak sini sakira bubuhannya kawa manukar makanan wan mancari wadah bamalam. Sualnya di sini kadada napa-napa. Lawan pulang, bubuhannya bisa kalaparan.” ");
INSERT INTO bjn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","“Kada usah gin. Bubuhan ikam haja nang mambari makan urang nang banyak tu” ujar Nabi Isa manyahut. “Asa kada mungkin Guru ai. Kami cuma baisi lima bigi ruti wan dua ikung iwak haja. Kada kawa pang mambari makan urang sabanyak nang itu! Maka urangnya malima ribu ikung lalakiannya” ujar bubuhan pangikutnya pina pusang. “Kaya ini ja, suruh bubuhannya dudukan bakalumpuk-kalumpuk, sakalumpuknya kira-kira lima puluh urang” ujar Nabi Isa manyuruh pangikutnya. ");
INSERT INTO bjn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lalu dilaksanakannya ai napa nang disuruh ulih Nabi Isa tadi. ");
INSERT INTO bjn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Imbah itu, diambil Nabi Isa ruti nang lima bigi tu lawan iwak nang dua ikung tu. Sidin manangadah ka langit, sambil maucap syukur lawan Allah. Imbah itu, ruti tu diribit-ribit Sidin. Lalu dibagiakan Sidin ka bubuhan pangikut Sidin sakira kawa dibagiakan pulang ka urang-urang banyak tu. ");
INSERT INTO bjn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sakalinya, samunyaan urang marasa kanyang sampai makanan tu balabihan. Imbah labihannya tu dikumpulakan, sakalinya takumpul dua walas bakul labihannya. ");
INSERT INTO bjn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nabi Isa lagi badoa saurangan. Imbah itu datangan pangikut-pangikut Sidin. Lalu Nabi Isa batakun, “Ujar urang, Aku ni siapa?” ");
INSERT INTO bjn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Lalu, bubuhannya manyahut, “Ada nang manyambat Pian Nabi Yahya. Ada jua nang lain manyambat Pian Nabi Ilyas. Ada jua nang manyambat Pian salah saurang nabi, nang hidup pulang.” ");
INSERT INTO bjn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Tagal amun pandapat bubuhan ikam pang, Aku ni siapa?” ujar Nabi Isa batakun pulang lawan pangikutnya. “Pian ni Al Masih nang dijanjiakan Allah!” ujar Pitrus manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","\"Nah, amun kaya itu, bubuhan ikam kada usah bakisah-kisah ka urang lain manganai hal ini” ujar Nabi Isa manangati bubuhan pangikutnya. ");
INSERT INTO bjn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nabi Isa baucap lawan pangikut-pangikut-Nya, “Nang datang matan di surga sudah ditakdirakan Allah gasan banyak mandarita wan ditolak ulih pamuka-pamuka agama, imam-imam basar, wan guru-guru agama. Imbah itu, Inya kaina dimati'i ulih urang, tagal pada hari nang katiga Inya cagar dihidupakan pulang.” ");
INSERT INTO bjn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Imbah itu, Nabi Isa baucap wan urang banyak nang takumpul di situ, “Amun urang handak jadi pangikutKu, saban hari inya musti mambuang kahandaknya saurang, musti sanggup disambati, sanggup mandarita wan sanggup mati mun inya handak umpat Aku. ");
INSERT INTO bjn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sualnya nang kada sanggup mati lantaran umpat Aku, inya cagaran kada salamat. Tagal inya nang sanggup mati lantaran umpat Aku, inya cagaran salamat di ahirat kaina. ");
INSERT INTO bjn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cuba ja ikam bapikir amun ikam panyugihnya di dunia ni, tagal masuk naraka lantaran manolak Aku, napa untungnya gasan ikam? Kadada untungnya! ");
INSERT INTO bjn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Amun urang supan maakui Aku wan ajaranKu, nang datang matan di surga supan jua maakui inya wayah Inya datang pulang ka dunia ini lawan malaikat-malaikat Allah. Wayah itu samunyaan urang cagar malihat kuasa wan kamuliaan Inya, kuasa wan kamuliaan Abah Nang di Atas, wan kamuliaan wan tarang malaikat-malaikat-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sabujurannya di antara bubuhan ikam nang badiri di sini, ada nang kada pacangan mati sabalum malihat karajaan Allah\" ujar Nabi Isa manutup kisah. ");
INSERT INTO bjn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Imbah itu, Nabi Isa tulakan lawan Pitrus, Yahya wan Yakub naikan ka bukit handak badoa. ");
INSERT INTO bjn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Rahatan badoa, muha Sidin bacahaya wan jubah putih Sidin jadi bagilarap (Indonesia: mengeluarkan cahayah/gemerlapang). ");
INSERT INTO bjn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bakakajutan ada datang dua urang nang bapander lawan Nabi Isa. Sakalinya, urang tu Nabi Musa wan Nabi Ilyas. ");
INSERT INTO bjn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kaduduanya bacahaya jua. “Pian tu cagar mati di kuta Yarusalem gasan mamanuhi kahandak Allah” ujar kaduduanya tadi lawan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitrus wan kakawalannya taguringan. Pas tabangun, bubuhannya manjanaki cahaya Nabi Isa wan cahaya kadua nabi nang badiri parak Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wayah Nabi Musa wan Nabi Ilyas handak maninggalakan Nabi Isa, Pitrus mamaraki Nabi Isa. “Junjungan, nyaman banar kami di sini. Kami tajakakan sarobonglah? Sabuah gasan Pian. Sabuah gasan Nabi Musa, nang sabuahnya lagi gasan Nabi Ilyas\" ujar Pitrus ka Nabi Isa. Tagal Pitrus kada sadar sabujurannya pandirannya tu kada masuk akal. ");
INSERT INTO bjn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Parahatan Pitrus bapandir tadi, kada disangka-sangka ada awan nang turun manukupi bubuhannya. Lantaran itu, bubuhan pangikut Nabi Isa katakutanan. ");
INSERT INTO bjn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lalu ada tadangar suara matan dalam awan tadi. “Nabi Isa ni adalah Anak Nang Di Atas nang Kupilih wan Kuutus. Dangari (makna tasirat=tegas) Sidin bujur-bujur!” ujar suara tadi. ");
INSERT INTO bjn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wayah suara tu tadangar, Nabi Musa wan Nabi Ilyas sudah kadada lagi. Cuma tatinggal Nabi Isa saurangan haja nang kalihatan ulih bubuhan pangikut Sidin. Tagal wayah itu, Yahya, Yakub wan Pitrus bahinipan haja. Kajadian tadi kada dikisahakannya lawan urang. ");
INSERT INTO bjn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Isuknya Nabi Isa wan katiga pangikut Sidin turunan matan bukit nang itu. Wayah itu, banyak urang bajurut-jurut mamaraki Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sakalinya di antara urang banyak tadi, ada saikung nang bakuciak sambil mamaraki Nabi Isa. “Guru!” ujarnya, “Tolong pang jinguki anak ulun nang saikungannya tu nah! ");
INSERT INTO bjn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Amun inya anu tu, guru ai, disarungi ruh jahat, inya tu bakakajutan bakuciak-kuciak. Matanya manciling. Awaknya kujul-kujul, lawan jua muntungnya babuihan. Sudah lawas banar inya disiksa ulih ruh jahat tu. Sualnya ruh jahat tu kada hakun kaluar pada awaknya. ");
INSERT INTO bjn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sudah suah haja pang ulun maminta lawan anak buah Pian manyuruh ruh jahat tu sakira bajauh. Tagal ruh jahat tu kada hakun kaluar matan awak anak ulun!” ");
INSERT INTO bjn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lalu Nabi Isa baucap ka pangikut-pangikut Sidin, “Umailah bubuhan ikam ni, masih baluman parcaya lawan baluman baiman ka Aku. Padahal, sudah lawas banar kita takumpul.\" Lalu Nabi Isa bapaling ka urang nang anaknya kasarungan tadi, “Bawa ja anak ikam tu ka sia.\" ");
INSERT INTO bjn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wayah dibawa ka Nabi Isa, anak tu dihampas ulih ruh jahat tu lalu awaknya kujul-kujul. \"Ikam, ruh jahat bajauh haja!\" ujar Nabi Isa. Imbah itu, langsung wagas ai anak tu, tabibas matan ruh jahat tadi. Balalu anak tadi disarahakan ai ka abahnya. ");
INSERT INTO bjn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Samunyaan urang tahiran-hiran malihat mujijat Nabi Isa tadi. 9:43-45 Wayah urang-urang tadi masih tahiran-hiran malihat mujijat nang hanyar dilihatnya tu, Sidin baucap lawan pangikut-pangikut Sidin, ");
INSERT INTO bjn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dangari bujur-bujur nah! Nang datang matan di surga ni, kaina cagar dihianati lalu disarahakan ka musuh-musuhNya.\" ");
INSERT INTO bjn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tagal pangikut-pangikut Sidin tanganga, hinip, kada kawa baucap. Bubuhannya kada paham napa nang dipandirakan Sidin lantaran ucapan Sidin tadi ada arti nang tasambunyi. Lawan pulang, bubuhannya kada wani manakuni Sidin manganai ucapan Sidin tadi. ");
INSERT INTO bjn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lalu pangikut-pangikut Sidin bamula bahualan manganai siapa-siapa nang paling tahurmat di hadapan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tagal Nabi Isa sudah tahu pikiran bubuhannya. Lantaran itu, Sidin mangiau saikung kakanakan lalu disuruh badiri di higa-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Lalu Sidin baucap ka bubuhannya, “Nah, amun ikam maharagu kakanakan nang kaya ini nang tujuannya mamuliakan Aku, baarti ikam sudah baiman ka Aku. Lalu, amun ikam sudah baiman ka Aku, baarti ikam sudah mantaati Allah nang mautus Aku. Sualnya siapa nang randah hati, inya kaina cagar dihurmati.” ");
INSERT INTO bjn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Imbah itu, Yahya datang mamadahakan, “Guru, kami malihat ada urang nang manyuruh ruh-ruh jahat bajauh mamakai kuasa ngaran Pian. Sudah kami tangati sualnya inya tu lain bubuhan kita.” ");
INSERT INTO bjn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lalu Nabi Isa manyahuti, “Jangan ditangati! Sualnya, siapa haja nang kada mamusuhi kita, baarti urang tu kawal kita.” ");
INSERT INTO bjn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wayah Nabi Isa handak diangkat ka surga, Sidin handak banar tulak ka kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tagal amun handak tulak ka kuta Yarusalem, urang musti malalui banua Samaria. Maka disuruh Sidin pangikut-pangikut-Nya tulak badahulu ka sabuah kampung di banua Samaria gasan manyiapakan kadatangan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sakalinya sabarataan warga banua Samaria kadada nang hakunnya manarima kadatangan Sidin lantaran kalompok Sidin lagi baampah ka kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Maka, wayah Yakub wan Yahya tahu manganai kalakuan urang Samaria, kaduduanya tu mamaraki Nabi Isa. “Guru,\" ujarnya, \"kaya apa amun kami manurunakan api tumatan langit gasan mamusnahakan urang-urang Samaria tu? Bulih haja kalo?” ");
INSERT INTO bjn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","\"Haw! Kada usah gin! Kada usah ikam badua bapikiran nang kaya itu\" ujar Nabi Isa manyahuti sambil pina sarik. ");
INSERT INTO bjn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Lalu tulakan ai bubuhanya ka kampung nang lain. ");
INSERT INTO bjn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Parahatan rombongan Nabi Isa baampah ka kuta Yarusalem, ada urang mamaraki Sidin lalu baucap, “Guru, ulun handak umpat wan pian. Ka mana haja. Bulihlah?\" ");
INSERT INTO bjn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jadi Nabi Isa manyahuti, “Hadupan-hadupan nang hidup di hutan baisian liang wan burung-burung jua baisian sarang, tapi nang datang matan di surga kadada baisian rumah saurang.\" ");
INSERT INTO bjn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lalu Nabi Isa bapaling ka urang nang lainnya, lalu baucap, “Umpati ja Aku.” Lalu urang nang lain tadi baucap, “Guru, ulun bulik gin dahulu handak maharagu abah ulun sampai sidin maninggal.” ");
INSERT INTO bjn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lalu Nabi Isa manyahut, “Biarakan ja urang-urang nang kada mantaati Allah mahadang kamatian kakawalannya. Tagal ikam Kutugasakan gasan mahabarakan manganai Karajaan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lalu ada jua urang nang lainnya nang mamaraki Nabi Isa. “Guru\" ujarnya \"Ulun hakun ai umpat lawan pian. Tagal bulihlah ulun bulik dahulu bapadah lawan kulawarga?\" ");
INSERT INTO bjn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lalu Nabi Isa baucap, “Amun urang maluku di pahumaan, tagal masih manoleh ka balakang inya kada pantas malayani Allah di karajaan-Nya.” ");
INSERT INTO bjn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Imbah itu, Nabi Isa mamilih tujuh puluh dua urang pangikut Sidin. Lalu disuruh Sidin bubuhannya tulakan badua badua ka kampung-kampung nang handak didatangi Sidin keana. ");
INSERT INTO bjn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tagal sabalum bubuhannya tulak, Nabi Isa mangiaunya wan bapasan, “Samuaan ladang gandum nang ampun Tuhan tu sudah siap dikatam, tagal tukang katamnya kasadikitan urangnya. Lantaran itu, bado'a ja sakira Tuhan nang ampun ladang-ladang ini mautus tukang-tukang katam gasan mangatami samuaan gandum nang itu.” ");
INSERT INTO bjn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Maka, wayah ini, tulak ja! Tagal ingatakan dahulu! Aku manyuruh bubuhan ikam ini ka dalam kaadaan nang babahaya— nang kaya domba-domba dihirit (BI: diarahkan) ka kalompok sarigala. ");
INSERT INTO bjn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kada usah bubuhan ikam mambawa salipi, tas, atawa capal gasan baganti. Amun bubuhan ikam tadapat lawan kakawalan ikam di jalan, jangan bamandak wan jangan bapapandiran. ");
INSERT INTO bjn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amunnya bubuhan ikam mandatangi rumah urang, ucapakan salamKu dahulu, iaitu 'tarima ha hati nang lapang bahagia dalam parlindungan Tuhan!’ ");
INSERT INTO bjn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amun ada urang di rumah itu nang hakun manarima hati nang lapang bahagia, baarti inya cagar manarima bubuhan ikam. Lalu Tuhan cagar mambarakahi inya wan kulawarganya nang kaya ucapan ikam tadi. Tagal amun di situ kadada nang hakun manarima hati nang lapang bahagia, baarti ucapan barakah ikam tu cagar kada tajadi di rumah bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bagana ja lawan kulawarga nang manarima ikam tu sampai tuntung napa nang Kutugasakan lawan bubuhan ikam. Makan wan nginum haja napa nang disurungi tuan rumah nang itu. Sualnya satiap tukang katam bahak manarima upahnya. ");
INSERT INTO bjn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Amun bubuhan ikam masuk ka sabuah kuta nang panduduknya hakun manarima bubuhan ikam, makan wan nginum ja napa-napa nang disurungi bubuhannya ka ikam. ");
INSERT INTO bjn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wagasakan ja urang-urang nang bapanyakitan. Padahakan ja lawan panduduknya, ‘Kaina Allah cagar mandiriakan karajaan-Nya di dunia ini.’ ");
INSERT INTO bjn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amun bubuhan ikam masuk ka sabuah kuta nang panduduknya kada hakun manarima bubuhan ikam, tulakan ja ka jalan-jalan raya di kuta tu lalu padahakan, ");
INSERT INTO bjn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Dabu-dabu kuta nang barikit di salawar kami ini gin, kami kibahakan. Itu pang cirinya kaina Allah cagar mahukum bubuhan ikam! Tapi katahui ja: kaina itu, Allah mandiriakan karajaan-Nya di dunia ini!’ ");
INSERT INTO bjn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aku mamadahi pulang sabujurannya pada Hari Kiamat, Allah cagar mahukum warga kuta nang itu labih barat dari hukuman warga kuta Sodom nang banyak banar maulah dusa!” ujar Nabi Isa manutup suruhan Sidin tadi. ");
INSERT INTO bjn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Nabi Isa mambari papadah, “Cilakalah urang-urang warga kuta Korazim lawan warga kuta Betsaida! Kaina hukuman Allah barat banar gasan bubuhan ikam! Sualnya jakanya mujijat-mujijat nang sudah Ku-lakuakan di kuta bubuhan ikam, tajadi jua pada jaman bahari di kuta Tirus wan Sidon, samustinya bubuhan Tirus wan Sidon batobat, nang partobatannya dibuktiakan lawan cara mamakai kain karung wan maandak habu di kapalanya. Tagal bubuhannya kada malakuakan nang kaya itu. ");
INSERT INTO bjn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lantaran itu, wayah Hari Kiamat kaina, ajab gasan bubuhan ikam pacangan labih barat daripada ajab gasan warga kuta Tirus wan Sidon. ");
INSERT INTO bjn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaya itu jua bubuhan ikam di kuta Kapernaum! Bubuhan ikam bapikiran bahwa ikam cagar mandapat kahormatan nang mulia di surga. Tapi, kada! Malah bubuhan ikam pacang ditimbai ka naraka!” ");
INSERT INTO bjn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Lalu Nabi Isa bapaling ka pangikut-pangikut Sidin wan baucap, “Dalam katantuan Allah, siapa nang hakun mandangarakan bubuhan ikam, itu sama haja inya hakun mandangarakan Aku. Siapa haja nang manolak bubuhan ikam wayah ikam mahabarakan pasan-Ku, itu sama haja manolak Aku. Siapa haja nang manolak Aku, itu sama haja manolak Allah nang mautus Aku.” ");
INSERT INTO bjn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kada lawas imbah itu, katujuh-puluh dua pangikut tu bulikan. “Ya Junjungan,” ujarnya, “lantaran kuasa ngaran Pian, kami kawa maatasi ruh-ruh jahat” bubuhannya baucap sambil kahimungan. ");
INSERT INTO bjn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Ya ai. Bujur ai! Wayah bubuhan ikam manyuruh ruh-ruh jahat tu bajauh, Aku malihat Iblis gugur matan di langit nang kaya kilat” ujar Nabi Isa manyahuti. ");
INSERT INTO bjn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“Nah, dangarakan pulang lah. Bubuhan ikam ni sudah kubari kuasa maatasi ruh-ruh jahat. Amun bubuhan ikam manjajak ular nang bawisa atawa kalajengking, atawa jua manamui kakuatan-kakuatan gaip, bubuhan ikam kadada nang cilaka. ");
INSERT INTO bjn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tagal biar nang kaya itu, bubuhan ikam jangan kahimungan lantaran kawa maatasi ruh-ruh jahat. Nang parlu bubuhan ikam himungi tu adalah ngaran-ngaran bubuhan ikam tu sudah tacatat di surga.\" ");
INSERT INTO bjn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wayah itu, Nabi Isa kahimungan banar lantaran Sidin dikuasai ulih Ruh Allah. Lalu Sidin maucapakan syukur, “Ya, Abah Nang Di Atas, ulun basyukur lawan Pian, nang manguasai langit wan bumi! Pian marahasiaakan hal-hal tantang karajaan Pian matan urang-urang nang maanggap dirinya pintar. Tagal Pian manampakaiakannya ka urang-urang nang hakun manarima kabanaran Pian. Itu tu nang maulah Pian himung.” ");
INSERT INTO bjn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lalu, Sidin baucap ka pangikut-pangikut Sidin, “Samunyaan kuasa sudah disarahakan ka Aku ulih Abahku Nang Di Atas. Kadada pang saikung-ikung urang nang manganal Aku salain AbahKu Nang Di Atas. Kadada jua nang manganal-Nya salain Aku wan urang-urang nang handak Kukanalakan lawan-Nya.” ");
INSERT INTO bjn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Imbah itu, Sidin manoleh ka bubuhannya wan baucap, “Nah, bahimunglah bubuhan ikam lantaran sudah malihat napa nang kulakuakan. ");
INSERT INTO bjn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sabujurannya Kupadahakan lawan bubuhan ikam, nabi-nabi dahulu tu wan raja-raja bahari handak jua malihat mujijat-mujijat nang bubuhan ikam lihat, tapi kada kawa. Bubuhannya tu handak jua mandangar napa nang bubuhan ikam dangar, tapi kada kawa jua.” ");
INSERT INTO bjn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wayah itu, ada saikung guru agama batakun sambil badiri handak manjabak Nabi Isa lawan tatakunannya. “Guru, nang kayapa caranya sakira kawa hidup salawasan di surga?” ujar guru agama tadi batakun. ");
INSERT INTO bjn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Napa nang tatulis dalam Kitab Suci Taurat?” ujar Nabi Isa balas batakun. ");
INSERT INTO bjn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","“Kita musti manyayangi Allah lawan saganap hati, saganap jiwa, saganap kakuatan wan saganap akal budi. Lawan pulang, kita musti manyayangi papadaan nang kaya manyayangi diri kita saurang” ujar guru agama tadi manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Bujur pian ni. Umpati ja, kaina pian cagaran hidup salawasan di surga” ujar Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","“Siapa papadaan tu nang musti kusayangi?” guru agama tu mambalas kada hakun kalah pandir. ");
INSERT INTO bjn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","“Nah, ada satu kisah,” ujar Nabi Isa manyahut. “Ada saikung lalakian nang turun matan kuta Yarusalim ka kuta Yeriko. Inya tu dipukuli, ditilanjangi, wan dirampuk. Wayah inya sudah parak mati, inya ditinggalakan. ");
INSERT INTO bjn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kabulujuran, ada saikung imam nang lalu di situ. Imbah maitihi urang tadi, inya baliung wan bajalan tarus. . ");
INSERT INTO bjn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ada jua saikung urang nang bagawi di bait Allah. Inya maitihi urang tadi jua, tagal imbah tu inya baliung jua wan bajalan tarus. ");
INSERT INTO bjn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kada lawas, datang saikung urang Samaria nang lalu disitu jua. Rahatan maitihi urang tadi, inya maras banar. ");
INSERT INTO bjn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Diparakinya urang tadi, dibarasihinya luka-luka urang tadi lawan ubat tradisional. Lalu, dibabatnya luka-lukanya. Imbah itu, urang tu dinaikakannya ka atas kaladai tunggangannya, lalu dibawa ka panginapan sakira kawa dirawat. ");
INSERT INTO bjn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Isuknya, pas handak kaluar, inya manjulung duit ka ampun panginapan. ‘Rawatakanlah urang tu, kaina kugantiꞌi samunyaan ungkusnya’ ujar urang Samaria tadi. ");
INSERT INTO bjn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nah, kaya itu pang kisahnya. Jadi nang mana di antara talu urang tadi nang kalakuannya kaya papadaan ka urang nang dirampuk tadi?” ujar Nabi Isa batakun wan urang-urang nang mandangarakan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Urang nang sudah manulung tu,” ujar guru agama tadi manyahut. “Nah, tulak ja wan lakuakan nang kaya itu jua” ujar Nabi Isa manutup kisah. ");
INSERT INTO bjn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wayah lagi batulakan ka kuta Yarusalem, Nabi Isa wan pangikut-pangikut Sidin sampai di sabuah kampung. Lalu ada saikung babinian nang bangaran Marta mamaraki Nabi Isa wan mamohon sakira rombongan Sidin basinggah ka rumah. ");
INSERT INTO bjn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Adingnya, nang bangaran Maryam, baduduk di higa Sidin sambil mandangari caramah Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tagal Marta haur banar maurusi bubuhannya. Lalu inya mamaraki Sidin wan baucap, “Ya, Junjungan, padahi pang ading ulun tu nah sakira inya hakun mangganiꞌi ulun. Ulun saurangan hajalah nang maurusi gawian di rumah nang ini?” ujar Marta pina sarik lawan adingnya. ");
INSERT INTO bjn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","“Marta, Marta” ujar Sidin, “Ikam kada usah gair wan kada usah malapahi diri ikam saurang haja maurusi rumah tangga. ");
INSERT INTO bjn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ada satu hal nang panting. Maryam sudah mamilih hal nang panting tu. Itu tu barakah matan Allah nang kada cagar diambil matan inya.” ");
INSERT INTO bjn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wayah itu, Nabi Isa lagi badoa di suatu tempat. Imbah tuntung badoa, ada saikung pangikut Sidin nang baucap, “Junjungan, lajari pang kami cara badoa nang kaya Nabi Yahya malajari pangikutnya.” ");
INSERT INTO bjn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lalu Nabi Isa manyahut, “Wayah bubuhan ikam badoa, sambat ja, 'Ya Allah, Abah kami nang di atas, kami maakui Pian tu Nang Maha Suci. Bakuasalah atas kami wan samunyaan urang. ");
INSERT INTO bjn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bariꞌilah kami saban hari makanan nang samayunya. ");
INSERT INTO bjn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ampunilah dusa-dusa kami nang kaya kami mamaapakan urang nang basalah lawan kami. Jangan mambiarakan kami kalah wayah digudai Iblis.” ");
INSERT INTO bjn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Lalu Nabi Isa bakisah nang kaya apa cara badoa. “Umpamanya landung malam ikam baucap ka kawal di subalah rumah, ‘O, wal, inta baras pang. ");
INSERT INTO bjn_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kabulujuran, kawal kami nang matan jauh datang handak umpat bamalam. Tagal kami kada kawa manyurungi napa-napa lantaran kami kada baisian napa-napa gasan basasurung.’ ");
INSERT INTO bjn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaina kawal ikam tu cagaran manyahuti, ‘Mauk banar ikam ni! Malam sudah landung banar! Lawang sudah bakancingan, kakanakan gin sudah guringan. Wayahini ni aku kada kawa mambariꞌi napa-napa gasan ikam!’ ");
INSERT INTO bjn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tagal kupadahakan nah, biar kawal ikam tu pamulaannya kada hakun mambariꞌi napa napa gasan ikam, kaputingannya, inya cagaran mambariakan jua samunyaan nang ikam minta. Sualnya ikam tadi cangkal banar maminta, kada sing ampihan. Nang kaya itu jua samustinya amun bubuhan ikam badoa lawan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nah, jadi minta ja lawan Allah, ikam cagaran dibariꞌi. Cari ja, ikam musti mandapatakan. Kiau ja tarus, maka lawang cagaran dibukaakan. ");
INSERT INTO bjn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sualnya samunyaan nang mainta lawan Allah, cagaran baulihi. Wan samunyaan nang mancariꞌi, cagaran baulihi jua. Gasan samunyaan nang mangiau tarus, lawang cagaran dibukaakan. ");
INSERT INTO bjn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kadada pang abah nang mambariꞌi ular gasan anaknya amun anaknya maminta iwak! ");
INSERT INTO bjn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kadada jua abah nang mambariꞌi kalajengking gasan anaknya amun anaknya maminta intalu! ");
INSERT INTO bjn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bubuhan ikam nang jahat gin tahu mambariꞌi nang baik gasan anak-anak ikam. Maginnya ai Abah Nang Di Atas labih tahu. Ruh KudusNya gin dibariakan gasan urang nang mamintanya.” ");
INSERT INTO bjn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wayah itu, ada urang nang dirasuki ruh jahat. Urang tu langsung jadi bisu, kada kawa bapandir lagi. Imbah ruh jahat tu disuruh bajauh ulih Nabi Isa, situ saini urang tu kawa bapandir pulang. Lalu urang banyak di situ tahiran-hiran malihat kajadian nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tagal sapalih ada nang garunuman sambil baucap, “Dasar kakuatan Iblis nang digunaakan-Nya gasan mausir ruh-ruh jahat tu.” ");
INSERT INTO bjn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ada jua sapalih nang lain mancari-cari alasan gasan manyalahakan Sidin. Lalu bubuhannya manyuruh Sidin mambari tanda gasan mambuktiakan amunnya Allah nang mautus Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","18","Tagal Nabi Isa sudah tahu napa nang ada dalam hati bubuhannya. Maka Sidin baucap lawan bubuhannya, “Kada mungkin Iblis mausir ruh-ruh jahat nang sabujurannya kakawalannya jua. Amun anak buah Iblis tapacah-pacah lalu bamusuh-musuhan, artinya karajaan Iblis kainanya hancur. Sama halnya amun di satu banua. Amun warganya bamusuh-musuhan wan bakalahian, artinya banua nitu kainanya musti hancur. Sama jua, amun di satu kulawarga, tajadi basingkingan. Maka kulawarga tu cagar hancur jua. Nah, kada masuk akal amun bubuhan ikam baucap, 'Aku manyuruh ruh-ruh jahat bajauh manggunakan kakuatan Iblis.' ");
INSERT INTO bjn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tagal amun Aku mausir ruh-ruh jahat manggunaakan kakuatan Iblis, lalu bubuhan ikam manggunaakan kakuatan siapa wayah mausir ruh-ruh jahat? Musti bubuhan ikam manyalahakan wan manuduh Aku. ");
INSERT INTO bjn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tadi tu bubuhan ikam maminta tanda gasan mambuktiakan amunnya Allah nang mautus Aku. Amun Aku mausir ruh-ruh jahat tu lawan kuasa Allah, itu pang tandanya amun Allah sudah mandiriakan karajaanNya wan sagala kakuasaanNya di antara bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","“Iblis ibaratnya tuan rumah nang kuat nang tatarusan manjaga rumahnya lawan sanjata nang langkap. Inya mangandalakan sanjata-sanjatanya tadi gasan manjaga samuaan hartanya wan gasan mangalahakan musuhnya— yaitu Aku. Tagal Aku takuat pada inya! Pas Aku manyarangnya, inya kawa haja Kukalahakan. Samuaan sanjata-sanjatanya tu kawa Kuambil. Hartanya Kurampas lalu Kubagi-bagi manurut kahandak-Ku. ");
INSERT INTO bjn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Siapa haja nang kada mamihak ka Aku, baarti inya mamusuhi Aku. Siapa nang kada manggani'i maingu kakawanan dombaKu, baarti inya marahai-rahai domba-dombaKu.” ");
INSERT INTO bjn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nabi Isa bakisah pulang, “Amunnya ruh jahat sudah kaluar di awak urang, inya musti mancari urang nang lain gasan dirasukinya sakira ada wadah bagana. Tagal sampai ka padang karing gin, inya kadada baulihi urang nang kawa dirasukinya. Lantaran kada tadapat, lalu inya bapikir, ‘Baiknya kubuliki pulang urang nang kurasuki tadi.’ ");
INSERT INTO bjn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Babulik ai inya ka urang nang dirasukinya tadi. Pas dirasukinya, sakalinya barasih banar nang kaya rumah nang sudah simpun. ");
INSERT INTO bjn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Imbah itu, bakiau ai inya mambawai tujuh ruh jahat nang tajahat pada inya gasan bagabung di awak urang tu. Lalu, masukan ai bubuhannya. Balalu ai, tambah babangat urang tu pada nang dahulu.” ");
INSERT INTO bjn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wayah Nabi Isa rahatan bacaramah, ada saikung babinian nang manyalah pandir, “Dibarakahi banar ulih Allah uma nang maranakakan wan manyusui Pian.” ");
INSERT INTO bjn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","“Labih dibarakahi lagi urang nang mandangari Firman Allah lalu manaati wan malaksanaakannya” ujar Nabi Isa manyahuti babinian tadi. ");
INSERT INTO bjn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wayah urangnya sasain babanyak, Nabi Isa bacaramah pulang, “Bubuhan ikam nang hidup di jaman ini tamasuk urang-urang nang jahat! Biar bubuhan ikam sudah malihat mujijat-mujijatKu, tagal bubuhan ikam masih haja minta liatakan pulang ciri mujijat-mujijatKu nang lain sakira bubuhan ikam kada ragu-ragu lagi manganai Aku. Tagal kada pacangan kutampaiakan lagi pang. Kacuali Aku bakisah haja manganai mujijat Nabi Yunus nang ditaguk iwak. ");
INSERT INTO bjn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sualnya kajadian Nabi Yunus tamasuk ciri gasan warga kuta Niniwe. Nang kaya itu jua Aku Nang Datang Matan Di Surga, manjadi ciri gasan bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kaina pada Hari Kiamat, ratu nang datang matan salatan cagar basaksi malawan bubuhan ikam. Sualnya ratu nang itu jauh banar mandatangi Nabi Sulaiman gasan mampalajari kabijaksanaan sidin. Nah, dangarakanlah. Kadudukanku tatinggi pada Nabi Sulaiman! Tagal bubuhan ikam kada hakun mandangarakan Aku. ");
INSERT INTO bjn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Pada Hari Pambalasan, warga kuta Niniwe cagar basaksi malawan bubuhan ikam. Sualnya wayah Nabi Yunus manyampaiakan pasan Allah lawan bubuhan warga kuta Niniwe, bubuhannya batobat. Nah, kadudukanku tatinggi pada Nabi Yunus! Tagal bubuhan ikam tatap jua kada hakun batobat!” ");
INSERT INTO bjn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nabi Isa manarusakan, \"Amun ada urang nang malikit lampu, kada mungkin diandaknya dibawah barumahan atawa ditukupinya lawan tajau. Samustinya lampu tu diandaknya di wadah nang tinggi sakira urang nang masuk ka rumah tu malihat cahayanya. ");
INSERT INTO bjn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata ikam ibarat nang kaya jendela. Ada cahaya matan luar nang masuk malalui jendela tu manarangi rumahnya. Maka, nang kaya itu jua ada cahaya nang masuk malalui mata ikam, itu tu nang manarangi kahidupan ikam. Amun mata ikam baguna sabaik-baiknya, maka kahidupan ikam gin kaina ditaranginya. Tagal amun mata ikam rusak, maka kahidupan ikam manjadi kadap banar. ");
INSERT INTO bjn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Lantaran itu, dijaga ai mata ikam tu. Jangan sampai rusak sakira tarang nang ada di kahidupan ikam tu kada manjadi kadap. ");
INSERT INTO bjn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amun kahidupan ikam tu ditarangi cahaya, wan kadada nang malindungi, maka kahidupan ikam tu pacangan tarang. ");
INSERT INTO bjn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Imbah Nabi Isa tuntung bacaramah, ada saikung guru agama matan aliran Farisi mambawai makanan dirumahnya. Hakun ai Sidin. Di rumah guru agama tadi, ada jua guru-guru agama nang lain matan aliran Farisi. ");
INSERT INTO bjn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lalu tuan rumah tadi baucap dalam hati, “Bah, urang nang itu kada mambasuh tangan nang kaya adat kita, urang Farisi.” ");
INSERT INTO bjn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tagal lantaran sudah tahu pikiran urang tadi, lalu Nabi Isa baucap, “Cara urang Farisi manaati Allah bisa diibaratakan nang kaya urang mambasuh mangkuk wan piring di bagian luarnya haja, tagal kada ingat mambasuh bagian dalamnya nang rigat banar. Nang kaya hati bubuhan ikam jua nang masih rigat, macam-macam bapikiran nang sarakah wan macam-macam kahandak nang jahat! ");
INSERT INTO bjn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ui, bubuhan ikam nang kada tapi pintar! Allah nang manciptaakan manusia sabujurnya sudah tahu haja napa-napa nang ada di dalam hati bubuhan ikam! ");
INSERT INTO bjn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Maka harta nang manguasai bubuhan ikam tu, coba pang disadakahakan ka urang-urang miskin. Imbah itu, hanyar ikam cagar manjadi nang kaya mangkuk nang barasih di mata Allah— matan luarnya sampai ka dalamnya. ");
INSERT INTO bjn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Cilakalah urang-urang Parisi! Bubuhan ikam cuma manaati paraturan Hukum Taurat nang ringan haja. Tagal bubuhan ikam kada ingat manaati parintah Allah nang sabujurnya panting banar. Misalnya hasil tanaman bubuhan ikam kaya rarampahan wan sasayuran, biar dibariakan saparsapuluhnya ka Bait Allah, tagal bubuhan ikam kada ingat balaku adil lawan nang lain wan mangasihi Allah. Padahal kaadilan wan mangasihi Allah mustinya bubuhan ikam lakuakan jua, wan jangan kada ingat pambarian saparsapuluh tu gasan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Cilakalah urang-urang Parisi! Amun di rumah ibadah, bubuhan ikam katuju baduduk di wadah paling muka. Di pasar-pasar jua, bubuhan ikam handak minta dihurmati haja. ");
INSERT INTO bjn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Cilakalah bubuhan ikam nang bapiraga jadi urang alim sualnya bubuhan ikam nang kaya kuburan nang kada banisan. Amun urang bajalan di atasnya, urang tu kada sadar amunnya manjadi najis lantaran manjajak kuburan nang itu. Nang kaya itu jua lawan bubuhan ikam: Wayah urang lain maumpati ajaran bubuhan ikam, inya kada manyadari tajangkit sifat bubuhan ikam nang sabujurnya najis di hadapan Allah lantaran kamunifikan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","“Ano, Guru ai, pandiran pian tadi tu sama haja mahina kami!” ujar saikung guru agama nang ada disitu. ");
INSERT INTO bjn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","“Cilakalah jua bubuhan ikam nang jadi guru-guru agama! Sualnya bubuhan ikam maadaakan paraturan-paraturan agama nang ngalih banar diumpati. Bubuhan ikam saurang bapiragah manjadi urang alim tagal sabujurannya kada bausaha manaati lawan paraturan-paraturan agama nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Cilakalah bubuhan ikam nang maulah wan mahiasi kuburan nabi-nabi gasan maingatnya. Padahal padatuan ikam saurang nang mamatiꞌi nabi-nabi nang tu. ");
INSERT INTO bjn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lawan parbuatan ikam nang itu, itu sama haja mambuktiakan bubuhan ikam akur haja lawan parbuatan datu-datu ikam tu. ");
INSERT INTO bjn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lantaran itu, hikmat Allah sudah tatulis, 'Bakali-kali, Aku pacang mautus nabi-nabi wan rasul-rasul gasan juriat Nabi Ibrahim. Tagal sapalih ada nang dimatiꞌi, ada jua nang disiksa ulih urang-urang mu'ul nang tu.' ");
INSERT INTO bjn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Maka gasan urang-urang nang hidup wayahini hutang darah samuaan nabi nang sudah dimatiꞌi mulai dunia diciptaakan musti ditabus ");
INSERT INTO bjn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","matan darah Habil sampai ka darah Zakaria! (Zakaria dimatiꞌi di antara wadah pambakaran kurban dan Bait Allah.) Parcaya ja! Urang-urang nang hidup wayahini pacangan dihukum lantaran samunyaan parbuatan nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Cilakalah bubuhan ikam nang guru-guru agama! Sualnya bubuhan ikam sudah dibari ilmu pangatahuan ulih Allah manganai kasalamatan, yaitu ajaran nang kawa digambarakan nang kaya kunci. Tagal bubuhan ikam kadada nang hakunnya manggunakan ilmu pangatahuan nang itu. Malahan bubuhan ikam marahasiaakan wan mahalang-halangi sabarataan urang nang handak mangatahui ajaran nang itu!” ");
INSERT INTO bjn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wayah Nabi Isa handak maninggalakan rumah nang itu, guru-guru agama lawan urang-urang aliran Parisi nang dandam lawan Sidin, bamula manyarang Sidin lawan tatakunan-tatakunan. ");
INSERT INTO bjn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Bubuhannya bausaha manjabak Sidin sakira amun Sidin tasalah pandir, kawa ditangkap. ");
INSERT INTO bjn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Baribu-ribu urang bakakajalan parak Nabi Isa sampai batis bubuhannya tajajak-jajak. Lalu, Nabi Isa mambari papadah lawan pangikut-pangikut Sidin, “Bahati-hatilah. Jangan sampai bubuhan ikam taumpati kalakuan pamuka-pamuka agama aliran Parisi. Sualnya bubuhannya tu cuma bapiraga haja manjadi urang baik. Lawan pulang, kalakuan bubuhannya nang jahat tu bisa malalar ka urang-urang lain, nang kaya ragi tu nah maulah galapung manjadi kamer. ");
INSERT INTO bjn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sualnya samunyaan usaha wan rancana jahat manusia nang dirahasiaakan, musti kaina dinampakakan wan dikatahui jua. ");
INSERT INTO bjn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Napa nang dipandirakan bubuhan ikam badidiaman haja, pacangan jalas kadangaran. Lawan pulang, napa nang dibisikakan bubuhan ikam ka urang di dalam kamar nang bakantop, pacangan tahabar ka mana-mana.” ");
INSERT INTO bjn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nah, dangarakanlah, kakawalan-Ku, kada usah takutan lawan manusia. Sualnya manusia tu cuma kawa mamati'i awak ikam haja. Imbah itu, kadada hal-hal jahat nang kawa dilakuakannya lagi. ");
INSERT INTO bjn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tagal wayahini Kupadahi nah, siapa nang musti ikam takutani: Takutan haja wan hormati haja lawan Allah. Sualnya Allah haja nang kawa mancabut panyawaan ikam lalu kawa jua mamasukakan ikam ka dalam naraka. Inya tu pang nang patut dihurmati wan ditakutani.” ");
INSERT INTO bjn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nah, ingatakanlah contoh nang ini: Ada lima ikung burung pipit nang dijual, harganya murah banar. Biar nang kaya itu, kadada saikung-ikung burung tu nang dilupaakan ulih Allah. ");
INSERT INTO bjn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Malah rambut ikam gin sudah dihitung ulih Allah jumlahnya. Nah, lantaran itu, ikam kada usah gair! Bubuhan ikam tu jauh labih baharaga daripada burung pipit. ");
INSERT INTO bjn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Jadi siapa-siapa nang mangaku sabagai pangikutKu di hadapan urang, maka kaina nang datang matan di surga gin, maakui inya jua sabagai pangikutNya di hadapan Allah wan malaikat-malaikat-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaya itu jua, urang nang baucap, \"Bah, Aku lain pangikut Nabi Isa!\" Maka di hadapan Allah wan malaikat-malaikat Allah, nang datang matan di surga gin cagar baucap, \"Ya, inya tu lain pangikutKu!\" ");
INSERT INTO bjn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bilanya urang bapandir nang malawan nang datang matan di surga, inya kawa diampuni. Tagal urang nang mamfitnah Ruh Kudus kada kawa diampuni. ");
INSERT INTO bjn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wayah ikam ditangkap wan dibawa ka panguasa gasan diadili, kada usah gair manganai napa nang ikam jawab gasan mambelah diri. ");
INSERT INTO bjn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sualnya Ruh Kudus pacang malajari napa nang musti ikam jawab. ");
INSERT INTO bjn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Lalu ada saikung urang di antara urang nang banyak tu baucap, “Guru, tulung pang padahiakan dangsanak ulun tu nah sakira hakun mambagi harta warisan lawan ulun.” ");
INSERT INTO bjn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lalu Nabi Isa manyahut,“Dangsanak, aku ni kada suah pang disambat hakim atawa tukang bagi warisan ikam badua.” ");
INSERT INTO bjn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Imbah itu, Nabi Isa baucap lawan samunyaan urang nang ada di situ, “Dangarakanlah! Jangan sampai bubuhan ikam jadi sarakah. Sualnya biar urang saling banyakan baisi harta, hartanya tu kada kawa manulungi inya kaina.” ");
INSERT INTO bjn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lalu Nabi Isa bamula bakisah, “Ada satu kisah. Ada urang nang banyak banar baisian tanah pahumaan. Banih nang dihasilakan banyak banar. ");
INSERT INTO bjn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Urang sugih tu bapikiran dalam hati, ‘Waduh, kadada lagi wadah gasan manyimpan banihku. Kaya apa yo aku ni?’ ");
INSERT INTO bjn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Imbah itu, inya baucap pulang dalam hati, ‘Nah, aku ada akal, kubabak haja kindai-kindaiku tu lalu kutajak baasa nang taganal. Di situ kaina pacang kusimpan samunyaan banihku lawan barang-barangku nang lain. ");
INSERT INTO bjn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lalu aku baucap ka jiwaku saurang, ‘Oi, jiwaku, hidup ikam sudah nyaman banar! Samunyaan nang baik-baik, ikam sudah baisi. Kada bahahabisan batahun-tahun. Santai haja ikam tu! Makan, nginum wan basanang-sanang haja.’ ");
INSERT INTO bjn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tagal malam nang itu jua, Allah baucap lawan inya, ujar Nabi Isa, ‘Oi ikam nang kada pintar! Malam ini jua, ikam cagar Kucabut panyawaan ikam lalu ikam Kuhukum. Gasan siapa garang harta nang sudah ikam kumpulakan tu?’ ");
INSERT INTO bjn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nah, nang kaya itu pang jadinya lawan satiap urang nang bausaha mangumpulakan harta kasugihan gasan kasanangannya di dunia nang ini, tagal kada bausaha mangumpulakan harta gasan di surga wan kada hakun mahurmati Allah” ujar Nabi Isa manutup kisah. ");
INSERT INTO bjn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nabi Isa bapaling lalu bapapadah ka pangikut-pangikut Sidin, “Nah, dangarakanlah, bubuhan ikam jangan gair gasan kaparluan hidup sahari-hari, nang kaya kakurangan makanan atawa kakurangan pakaian. ");
INSERT INTO bjn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sualnya tujuan ikam hidup nang sabujurnya jauh labih panting daripada makanan wan pakaian ikam. ");
INSERT INTO bjn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tu nah, coba itihi cara hidup burung-burung gagak. Kada parlu inya bahuma atawa mangatam, kada parlu jua baulah kindai. Tagal Allah sudah manyadiakan umpan-umpannya. Nah, sabujurannya, di mata Allah, bubuhan ikam jauh labih baharga daripada burung-burung nang liar tu! ");
INSERT INTO bjn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kanapa maka bubuhan ikam tatarusan gair? Urang nang tatarusan gair kada kawa mamanjangakan umurnya. Sahari haja gin, kada kawa. ");
INSERT INTO bjn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jadi, amun hal-hal nang halus haja kada kawa ikam gawi, samustinya dalam hal napa haja ikam kada usah gair! ");
INSERT INTO bjn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Itihi ja kambang-kambang nang tumbuh liar. Kambang-kambang nang itu tumbuh kada parlu bagawi wan kada parlu jua pakaian. Contohnya, Nabi Sulaiman dahulu tu nah, biar panyugihnya di antara raja-raja waktu itu, sidin kada baisian baju nang bengkeng daripada kambang-kambang nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Allah maulah tumbuhan liar nang itu manjadi bagus— padahal tumbuhan nang itu hidupnya cuma satumat haja. Amunya layu, ditimbai ka api. Nah, sudah jalas banar kalo, Allah labih maharagu bubuhan ikam daripada kambang nang itu. Ikam musti baiman ka Allah sualnya Allah cagar mancukupi pakaian lawan ikam!” ");
INSERT INTO bjn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Jadi jangan haur mamikirakan gasan makan wan minum haja. Kada usah gair gin manganai hal-hal nang itu tadi. ");
INSERT INTO bjn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bubuhan ikam jangan nang kaya urang kada manganal Allah nang tatarusan gair manganai hal-hal tadi. Sualnya urang kada manganal Allah tu kada baiman wan kada yakin diharaguNya. Makanya baiman ja lawan Abah Nang Di Atas nang sudah tahu napa nang ikam parlu. ");
INSERT INTO bjn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jangan haur mancariꞌi harta duniawi haja, cariꞌi ja karajaan Allah. Allah gin cagar mambariꞌi napa nang ikam parluakan. ");
INSERT INTO bjn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ui pangikut-pangikutKu nang kada banyak, kada usah gair kakurangan hal-hal duniawi tadi. Sualnya bubuhan ikam sudah manjadi warga karajaan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Juali harta ikam, lalu sidakahakan ka urang-urang nang miskin. Amun bubuhan ikam mamantingakan kahandak Allah nang kaya itu tadi, baarti bubuhan ikam manabung harta nang kakal di surga nang kada suah rusak. Harta nang itu kada cagar hilang. Sualnya maling kada kawa manyuntannya wan rayap kada kawa marusaknya. ");
INSERT INTO bjn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Napa nang paling baharaga gasan ikam, musti rancak ikam ganang wan pikirakan, baik harta ikam di dunia atawa harta ikam nang kakal tadi di surga.” ");
INSERT INTO bjn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","“Maka basiap-siaplah bubuhan ikam nang kaya pambantu-pambantu nang mahadangi tuannya bulik matan panganten. Siang wan malam, inya musti bajaga tarus manyambutnya lawan lampu-lampu nang tatarusan banyala. Lawan cara nang kaya itu, pas tuannya tu bulik lalu bakiau di halaman rumah, inya siap mambukaakan lawang gasan tuannya. ");
INSERT INTO bjn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bujur-bujur dibarakahi pambantu-pambantu nang itu nang pas tuannya datang, inya lagi bajaga-jaga. Dangarakanlah, tuan nang itu cagar manyilahakan bubuhannya duduk. Lalu inya mamakai baju nang kaya pambantunya lalu inya mambari makan pambantu-pambantunya. ");
INSERT INTO bjn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bubuhan pambantu tu cagar labih dibarakahi lagi amun tuannya tu bulik landung malam wan masih manamui bubuhannya tatap bajaga-jaga! ");
INSERT INTO bjn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ingatakanlah: Amun tuan rumah mangatahui jam barapa maling datang, musti ai inya bajaga-jaga, sakira rumahnya kada dibungkas maling. ");
INSERT INTO bjn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nah, nang kaya itu bubuhan ikam! Musti bajaga-jaga tarus lantaran nang datang matan di surga ni cagar datang kaina nang waktunya kada disangka-sangka.” ");
INSERT INTO bjn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lalu Pitrus batakun, “Junjungan, papadah pian tadi ditujuakan gasan kami hajakah atawa gasan samunyaan urang?” ");
INSERT INTO bjn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nabi Isa manyahut, “Siapa kapala pambantu nang bijaksana tu? Inya diangkat ulih tuannya gasan maaturi pambantu-pambantu nang lain. Inya tu nang mambari makan bubuhannya wayah tuannya kadada di rumah. ");
INSERT INTO bjn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bauntung banar kapala pambantu tu nang kadapatan tuannya wayah malaksanaakan tugasnya wayah tuannya tu datang! ");
INSERT INTO bjn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nah, dangarakanlah! Sabujurannya, kapala pambantu tu cagar diangkat manjadi pangawas samunyaan ampun tuannya. ");
INSERT INTO bjn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tagal kapala pambantu tu baucap dalam hatinya, ‘Nah, tampulu tuanku kadada di rumah, baik kupukuli haja samunyaan pambantu-pambantu tu lalu aku makan sakahandakku, nginum sampai mauk.’ ");
INSERT INTO bjn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sakalinya tuannya tu datang bakakajutan. Lalu babincul-bincul ai kapala pambantu tu dihajar ulih tuannya. Imbah itu, inya pacang dijadiakan nang kaya urang-urang nang kada taat. ");
INSERT INTO bjn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pambantu nang tahu kahandak tuannya, tagal kada basiap-sadia tarus wan kada malakuakan kahandak tuannya, pacangan barat banar hukumannya. ");
INSERT INTO bjn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tagal pambantu nang kada tahu kahandak tuannya, lalu malakuakan hal nang salah sampai kena hukuman, hukumannya tu ringan haja. Sualnya pambantu nang sudah dibariꞌi banyak papadah ulih tuannya, pacang banyak jua tuntutan matan tuannya. Wan pambantu nang sudah banyak dibari tanggung jawab ulih tuannya, pacangan labih banyak lagi dituntut ulih tuannya.” ");
INSERT INTO bjn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kadatangan-Ku nang kaya api nang cagar mambanam dunia nang ini. Aku baharap amun api nang itu sudah bamula malalar ka mana-mana! ");
INSERT INTO bjn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tagal sabalum hal nang itu tu bakajadian, Aku sudah ditakdirakan mananggung pandaritaan nang barat banar. Hati-Ku marista banar sampai datang pandaritaan nang itu! ");
INSERT INTO bjn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jangan bubuhan ikam bapikir amun Aku datang ka dunia ini gasan mambawa damai. Sabujurannya, kada damai pang nang Kubawa! Tagal kadatangan-Ku mambawa banyak hual. ");
INSERT INTO bjn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sualnya mulai wayahini, cagar tajadi bahualan manganai Aku di antara kulawarga-kulawarga. Amun di kulawarga tu ada lima ikung urang, maka nang tiga ikung nang maumpati Aku mahual nang badua, atawa nang dua urang tu mahuali nang batiga, nang kaya sudah tatulis di dalam ayat Kitab Suci nang ini, ");
INSERT INTO bjn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","‘Kakanakan lalakian wan abahnya cagar bahual, kakanakan bibinian wan umanya cagar bahual, wan minantu bibinian wan uma mintuhanya cagar bahual.’” ");
INSERT INTO bjn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Di lain hari, Nabi Isa maungkai kisah ka urang banyak, “Amun bubuhan ikam malihat awan kadap di subalah barat, ikam musti baucap, ‘Umai, muru banar harinya. Bah, cagar hujan nang ini,’ lalu nang itu tu bujur-bujur hujan. ");
INSERT INTO bjn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lawan pulang, wayah angin batiup matan salatan, bubuhan ikam musti baucap, ‘Pacangan handak panas harinya ni,’ lalu hal nang itu bujur-bujur tajadi. ");
INSERT INTO bjn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ui bubuhan ikam nang bapura-pura baik! Ikam kawa mangira-ngira ari cuma wayah malihat ciri-ciri di langit, tagal ikam kada tahu samasakali manganai ciri-ciri mujijat nang lagi bakajadian wayahini! ");
INSERT INTO bjn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kanapa maka bubuhan ikam kada bujur-bujur mambuka mata wan mamilih jalan nang bujur? ");
INSERT INTO bjn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amunnya ikam handak dikaduakan (dilaporkan) ka pangadilan, mustinya ikam baakuran (berdamai) dahulu lawan musuh ikam tampulu baluman bujur-bujur dikaduakannya. Amun kada, ikam kaina disidang urang, imbah itu disarahakan ka patugas, lalu dimasukakan ka panjara. ");
INSERT INTO bjn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Parcaya ja, ikam kada cagar kaluar di panjara tu amun hutang-hutang ikam kadadipunahi. ");
INSERT INTO bjn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Wayah Sidin bacaramah, ada urang-urang nang mamadahakan amun Hupnor Pilatus mambunuh urang wayah bubuhannya malaksanaakan kurban. Lalu, darah urang nang dibunuhnya tu tacampur lawan darah hewan-hewan kurban tu. ");
INSERT INTO bjn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mandangar habar nang itu, lalu Sidin mamadahakan, “Lantaran bubuhannya dibunuh lawan cara nang kaya itu, ikam mangira dusa-dusa urang nang dibunuh tu labih banyak daripada dusa-dusa urang Galilea nang lain? ");
INSERT INTO bjn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kada!\" ujar Sidin, “Dangarakan nah! Amun bubuhan ikam tu kada batobat wan kada maumpati jalan Allah, bubuhan ikam gin, amun mati, dimasukakan ka naraka! ");
INSERT INTO bjn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nah, ada lagi sabuting kisah. Ada sabuah manara di Siloam nang runtuh wan ada dalapan balas urang mati nang tatindih. Bubuhan ikam mangira dosa-dosa bubuhannya labih banyaklah daripada dosa-dosa urang lain nang ada di kuta Yarusalem? ");
INSERT INTO bjn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kada kaya itu pang sabujurannya! Dangarakan! Amun bubuhan ikam kada batobat, lalu amun mati, dimasukakan ka naraka!” ");
INSERT INTO bjn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","“Ada satu kisah” ujar Nabi Isa, “Ada urang nang mananam puhun ara di kabunnya. Lawas banar mahadangi buahnya. Tagal kada sing buahan jua. ");
INSERT INTO bjn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lalu inya baucap ka tukang haragu kabunnya, ‘Tahulah ikam? Sudah maniga tahun aku handak maambil buah puhun nang ini tagal sabigi-bigi kada suah talihat buahnya. Tabang haja gin puhun nang itu! Kadada gunanya jua diharagu!’ ");
INSERT INTO bjn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Tuan', ujar tukang haragu ‘maraha ulun maharagunya satuhan lagi! Kaina tanahnya ulun gamburakan wan ulun bari pupuk. ");
INSERT INTO bjn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kalu ai tahun dudi babuah. Amun kada babuah jua, kaina ulun nang manabangnya.’” ujar tukang haragu manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wayah hari Sabat nang itu, Nabi Isa lagi bacaramah di sabuah rumah ibadah. ");
INSERT INTO bjn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sidin malihat ada saikung babinian nang bungkuk. Sudah lapan balas tahun lawasnya urang tu maarit bungkuknya, kada kawa mancagatakan balakang lantaran ulahan ruh jahat. ");
INSERT INTO bjn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lalu dikiau Sidin wan baucap, “Panyakit pian sudah kadada lagi!” ");
INSERT INTO bjn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Diandak Sidin tangan Sidin di atas bahu babinian nang itu. Lalu langsung wagas ai wan kawa badiri cagat. “Sukur Alhamdulilah,” ujar babinian tu, “Ulun kawa badiri cagat pulang. Lapan balas tahun ulun kada kawa badiri! Allah bujur-bujur ada lawan Pian.” ");
INSERT INTO bjn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Lalu kapala rumah ibadah baucap ka urang banyak tu, “Ada anam hari haja gasan bagawi! Datang pang di hari-hari nang itu amun handak diwagasakan. Jangan di hari Sabat!” ");
INSERT INTO bjn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","“Bubuhan ikam urang-urang nang munapik!” ujar Nabi Isa manyahuti kapala rumah ibadah. “Urang malapas sapi atawa kaladai matan kandangnya wan mambawanya ka wadah panginuman di Hari Sabat. ");
INSERT INTO bjn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tagal, wayahini ada saikung babinian juriat Nabi Ibrahim nang sudah lapan balas tahun dipasung ulih Iblis. Maulah inya kada bulih diwagasakan di hari Sabat?” ujar Nabi Isa baucap ka urang banyak nang ada di situ. ");
INSERT INTO bjn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Lantaran Nabi Isa baucap nang kaya itu, musuh-musuh Sidin tasupani banar. Tagal samunyaan urang nang lain himung banar malihat mujijat Sidin tadi. ");
INSERT INTO bjn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","“Ganalnya kuasa Allah dalam kahidupan manusia tu nang kaya apalah?” ujar Nabi Isa lawan urang-urang nang ada di situ. ");
INSERT INTO bjn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“Nang kaya ini nah. Kakuasaan Allah ka urang nang manaatiNya, kuibaratakan nang kaya bigi sawi nang halus banar, lalu dihamburakan urang di kabunnya. Bigi nang itu tumbuh manjadi puhun nang ganal. Burung-burung gin kawa maulah sarang di cikang-cikangnya. ");
INSERT INTO bjn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ada pulang Kuibaratakan kakuasaan Allah ka urang nang manaatiNya,” ujar Nabi Isa baucap pulang. ");
INSERT INTO bjn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“Nah, dangarakanlah. Kakuasaan Allah ka urang nang manaatiNya tu kuibaratakan sadikit ragi nang diambil babinian, diadunnya lawan galapung nang banyak banar sampai manjadi kamir. Biar raginya sadikit wan galapungnya nang banyak, tagal adonan galapung nang banyak tu kawa kamir sampai diulah manjadi roti.” ");
INSERT INTO bjn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nabi Isa bajalan tarus ampah ka Yarusalem malalui babarapa kuta. Sidin bacaramah di kuta-kuta nang dilaluiNya. ");
INSERT INTO bjn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wayah itu, ada saikung urang mandatangi Sidin wan baucap, “Junjungan, parmisi, ulun umpat batakunlah. Sadikit hajalah urang nang disalamatakan kaina?” ");
INSERT INTO bjn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Lalu Nabi Isa manyahut, “Bausaha ja nang cangkal sakira bubuhan ikam kawa masuk ka dalam karajaan Allah malalui lawang nang kipit. Sabujurannya banyak urang nang bausaha masuk, tagal kada kawa. ");
INSERT INTO bjn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kainanya, nang ampun rumah— yaitu Aku, cagar mangantup lawang rumah tu. Lalu kadada kasampatan lagi urang masuk karajaan Allah tu. “Samuaan urang nang badiri di muka lawang tu cagar mangiau sambil baucap, ‘Tuan, Tuan, tolongi pang buka lawang gasan kami.’ “Tagal kaina Kusahuti, ‘Aku kada patuh lawan bubuhan ikam.’ ");
INSERT INTO bjn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Lalu, ikam cagar baucap pulang, ‘Tapi kami sudah makan wan nginum basama Pian. Kami sudah mandangar caramah Pian di jalan-jalan kuta kami!’ ");
INSERT INTO bjn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Lalu Aku cagar baucap pulang lawan ikam, ‘Aku bujur-bujur kada patuh lawan bubuhan ikam. Ei bubuhan ikam lawan samuaan palaku kajahatan, bajauhan matan sini!’ ");
INSERT INTO bjn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Di luar sana, ikam cagar manangis wan mandarita banar wayah ikam malihat Nabi Ibrahim, Nabi Ishak, Nabi Yakub, wan jua samuaan nabi nang lagi manikmati hidup nang kakal di dalam karajaan Allah, sadangkan ikam saurang ditangati masuk. ");
INSERT INTO bjn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kaina, pacangan datang banyak urang juriat Nabi Ibrahim matan sagala panjuru. Lalu bubuhannya cagar masuk wan bararamian di dalam karajaan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","“Dangarakan nah, urang-urang nang bakadudukan randah wayahini, kaina mandapat kadudukan nang tinggi. Urang-urang nang bakadudukan wayahini tinggi, kaina mandapat kadudukan nang randah.” ");
INSERT INTO bjn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wayah itu, ada pamuka-pamuka agama matan aliran Parisi mandatangi Nabi Isa lalu baucap, “Ikam bajauh haja matan sini! Sualnya Raja Hirudis handak mamatiꞌi Ikam!” ");
INSERT INTO bjn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nabi Isa manyahuti, “Padahakan ja lawan hadupan hutan tu, ‘Hari ini wan isuk, Aku manyuruh ruh-ruh jahat bajauh. Aku mawagasakan urang lalu pada hari nang katiga aku manuntungakan tugasKu.’ ");
INSERT INTO bjn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Biar nang kaya itu, hari ini, isuk, wan isuknya, Aku musti manarusakan sampai ka kuta Yarusalem. Sualnya kadada saurang nabi nang dimatiꞌi di luar kuta Yarusalim. Nang kaya itu jua Aku, Aku musti tulak ka sana sakira kamatianKu di kuta Yarusalem.” ");
INSERT INTO bjn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Lalu Nabi Isa baucap pulang, “Ui warga kuta Yarusalem. Bubuhan ikam nang mamatiꞌi nabi-nabi bahari wan manawaki utusan-utusan Allah sampai mati! Aku rancak manyurung kadua tanganKu gasan malindungi ikam— nang kaya parinduan hayam malukupi anaknya lawan halarnya. Tagal ikam kada hakun. ");
INSERT INTO bjn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nah, dangarakan! Kuta nang ini cagar ditinggalakan Allah. Parcaya ja, mulai wayahini, ikam pacang kada malihat Aku lagi sampai kaina wayah ikam baucap, “Dibarakahi Raja kita nang datang mawakili Allah.’” ");
INSERT INTO bjn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pada hari Sabat, Sidin tulak ka rumah pamuka agama aliran Parisi nang manyarui Sidin. Urang-urang Parisi nang lain mahawasi Sidin gasan mancari-cari kasalahan Sidin sakira Sidin kawa dituduh malanggar paraturan Hari Sabat. ");
INSERT INTO bjn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sakalinya di situada saikung lalakian nang tangan wan batisnya babangkak-bangkak. Inya baduduk pas dihadapan Sidin! ");
INSERT INTO bjn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lalu Sidin baucap, “Manurut Hukum Taurat, kawalah urang nang ini diwagasakan wayah hari Sabat?” ");
INSERT INTO bjn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tagal pamuka-pamuka agama tu, saikung-ikung kadada nang manyahutnya. Imbah dijapai Sidin urang nang bapanyakit tu, langsung wagas ai. “Bulik ja ikam lawan hati nang lapang bahagia!” ujar Sidin ka urang nang hanyar wagas tadi. Lalu bulik ai inya. ");
INSERT INTO bjn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lalu Sidin baucap pulang, “Amun saupamannya anak ikam atawa sapi ikam tacabur ka dalam sumur pada hari Sabat, musti bubuhan ikam langsung maangkatnya, ya kalo?” ");
INSERT INTO bjn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lalu bubuhannya mandam, kadada nang manyahutnya lantaran samunyaan pandiran Sidin tu bujur. ");
INSERT INTO bjn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lantaran Nabi Isa malihat urang nang katuju duduk di pamukaan wayah saruan pangantinan, Sidin bamula bacaramah lawan maungkai kisah sindiran. ");
INSERT INTO bjn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bilanya ikam ada saruan pangantinan, jangan bausaha handak duduk di pamukaan! Burusiah ada urang nang disarui tu nang tapanting pada ikam nang pacang duduk di situ. ");
INSERT INTO bjn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Amun urang tu datang, musti tuan rumah baucap ka ikam, ‘Maapailah, wadah nang ini sudah kami sadiakan gasan tamu nang tahurmat. Pian bapindah haja duduk ka buncu!’ Hakun kada hakun ikam musti bapindah ka buncu tu. Tasupani ai ikam jadinya. ");
INSERT INTO bjn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Makanya am amun ikam disarui urang, duduk di buncu-buncu haja. Amun duduk buncu-buncu haja, siapa tahu tuan rumah tu datang ka ikam lalu baucap, ‘Pian, duduk di pamukaan haja.’ Jadinya ikam tahurmat di hadapan samunyaan tamu nang ada di situ. ");
INSERT INTO bjn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sualnya urang nang sumbung pacangan dibari supan. Lawan pulang urang nang santun pacangan dihurmati” ujar Nabi Isa manutup kisah. ");
INSERT INTO bjn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Lalu Nabi Isa manulih ka tuan rumah wan baucap, “Bilanya ikam basaruan salamatan, jangan manyarui kakawalan ikam haja. Jangan jua manyarui kulawarga ikam haja atawa urang higa-mahiga rumah nang sugih-sugih. Sualnya bubuhannya tu cagar manyarui ikam pulang. Amun kaya itu, ikam sudah manarima balasan. ");
INSERT INTO bjn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nang paling baik tu, bilanya ikam basaruan, sarui haja bubuhan urang miskin, urang cacat, urang lumpuh, wan urang picak. ");
INSERT INTO bjn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ikam cagar dibarakahi ulih Tuhan sualnya bubuhannya tadi kada baisian napa-napa gasan mambalas saruan ikam. Ikam kaina cagar baulihi balasan matan Tuhan wayah urang saleh dihidupakan pulang. ");
INSERT INTO bjn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wayah itu ada urang nang lagi makan baimbai lawan Nabi Isa. Imbah mandangar kisah Sidin tadi, balalu urang tu baucap, “Bauntung banar kaina urang nang dapat saruan di aruh ganal karajaan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lalu Nabi Isa maungkai pulang sabuting kisah. “Ada urang nang handak maadaakan aruh ganal, lalu urang-urang banyak nang disaruinya. ");
INSERT INTO bjn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Disuruhnya anak buahnya basaruan, ‘Tuan kami handak baaruh ganal. Pian disarui sakira datangan.’ ");
INSERT INTO bjn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tagal samunyaan kada hakun datang, baalasan macam-macam. Nang panambaian baucap, ‘Aku hanyar manukar tanah. Aku musti tulak mamariksanya. Maapailah. Aku kada kawa datang.’ ");
INSERT INTO bjn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nang saikungnya baucap, ‘Aku hanyar manukar lima pasang hadangan. Aku musti tulak mamariksanya. Kada kawa datang ai aku nah. Maapailah.’ ");
INSERT INTO bjn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nang lain ada jua baucap, ‘Aku hanyar ja babini. Lantaran itu aku kada kawa datang. Maapailah.’ ");
INSERT INTO bjn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Lalu bulik ai anak buahnya tu ka wadah tuannya. ‘Tuan’ ujarnya ‘saikung-ikung tuan ai kadada nang hakunnya datang ka aruh pian! Kayapa tuan?’ Lalu tuannya manyahuti, ‘Amun kaya itu, lakasi ja ikam tulak ka samunyaan jalan wan gang di kuta ni! Bawaai ka sia urang-urang nang susah wan nang cacat!’ ");
INSERT INTO bjn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Lalu tulak ai inya basaruan ka urang-urang tadi. Imbah itu, inya balapor ka tuannya,‘Tuan, samunyaan parintah pian tu sudah ulun lakuakan. Tagal masih ada wadah nang puang.’ ");
INSERT INTO bjn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lalu tuannya baucap, ‘Amun kaya itu, tulak ai lagi ikam basaruan ka jalan-jalan nang jauh wan gang-gang di luar kuta. Paksa haja urang-urang nang ada di situ datang sakira wadahku hibak. Lalu banyak ai nang datangan ka aruh ganal tadi. ");
INSERT INTO bjn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ingatakan ja, urang-urang nang panambaian nang disarui tu, saikung-saikung gin kadada nang cagar manikmati aruh ganalku ni’” ");
INSERT INTO bjn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wayah itu, banyak urang bajurut-jurut mairingi Nabi Isa wayah dalam parjalanan Sidin. Lalu Sidin manulih ka bubuhannya wan baucap, ");
INSERT INTO bjn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Amun urang handak manjadi pangikutKu, musti inya mangasihi Aku malabihi abahnya, umanya, bininya, anaknya, wan dadangsanaknya. Amun manjadi pangikutKu, urang musti mangasihi Aku malabihi dirinya saurang ");
INSERT INTO bjn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","wan sanggup mandarita lawan jua rela mati lantaran umpat Aku” ujar Nabi Isa lawan bubuhannya tadi. ");
INSERT INTO bjn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aku manggambarakannya kaya ini. Amun ikam handak maulah manara, musti ikam marikin dahulu biayanya, ya kalo? Mayukah, kadakah, duitnya, gasan manuntungakannya? ");
INSERT INTO bjn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Burusiah sampai pundasi haja, habis sudah duitnya. Ditatawaakan urang am kaina. ");
INSERT INTO bjn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Lalu ai ada urang manyambat, “Bah, urang nang ini waninya pang maulah manara. Sakalinya kada kawa manuntungakan.” ");
INSERT INTO bjn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nang kaya itu jua, saurang raja nang baisi sapuluh ribu prajurit handak baparang lawan raja nang lain nang baisi dua puluh ribu prajurit, musti dipikirakannya dahulu. Kawa manangkah, kalahkah amun inya malawan musuhnya tu? ");
INSERT INTO bjn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Amun dikira-kira kada kawa manang, wayah musuhnya tu masih jauh, dikirimnya ai utusan gasan mambawai musuhnya baakuran. ");
INSERT INTO bjn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kaya itu jua lawan bubuhan ikam. Siapa haja nang kada sanggup maninggalakan samunyaan miliknya nang disayangi, kada kawa manjadi pangikutKu. ");
INSERT INTO bjn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lalu Nabi Isa bacaramah pulang, \"Bubuhan ikam nang sudah jadi pangikutKu, itu sama nang kaya uyah. Uyah tu dipakai gasan manyamanakan makanan! Tagal amunnya kahilangan rasa masin, ");
INSERT INTO bjn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","uyah tu kada baguna lagi gasan pahumaankah gasan pupukkah. Musti dibuang haja uyah tu lantaran kada baguna lagi. Nah, siapa nang hakun mandangarakan, maka dangari baik-baik. ");
INSERT INTO bjn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wayah itu, banyak tukang tagih pajak wan urang-urang badusa nang lain datangan ka Nabi Isa handak mandangarakan caramah Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ada jua pamuka-pamuka agama wan guru-guru agama nang garunuman, “Bah! Hakunnyalah urang nang ini manarima urang-urang nang badusa, makan baimbai ha pulang lawan bubuhannya?!” ");
INSERT INTO bjn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lantaran itu, Nabi Isa maungkai sabuting kisah. ");
INSERT INTO bjn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Amun ikam ada baisi saratus ikung biri-biri, lalu hilang saikung. Napa nang pacangan ikam lakuakan? Musti ikam tinggalakan nang sambilan puluh sambilan ikung tu di padang kumpai, lalu tulak mancariꞌi nang hilang tu sampai dapat. ");
INSERT INTO bjn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Amun ikam tadapat, musti himung banar ikam, manyahannya bulik. ");
INSERT INTO bjn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Imbah sampai di rumah, ikam musti bakiau urang di higa-mahiga rumah wan kakawalan lalu ikam baucap, ‘Ayu! Ka sinian nah. Bararamian lawan aku sualnya biri-biriku nang hilang sudah tadapat pulang!’ ");
INSERT INTO bjn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nah, kaya itu jua Allah. Inya himung banar amunnya ada urang badusa nang batobat. Daripada sambilan puluh sambilan urang nang dirinya marasa alim wan kada parlu batobat” ujar Nabi Isa manutup kisah tadi. ");
INSERT INTO bjn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nabi Isa bakisah pulang, “Jaka saikung babinian nang baisi sapuluh bigi duit perak nang baharaga, lalu kahilangan sabigi, napa nang pacangan dilakuakannya? Musti inya malikit lampu, disapunya sarumahan sambil bahimat mancariꞌi sampai dapat. ");
INSERT INTO bjn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pas duit tu tadapat, lalu ai dikiauinya kakawalannya nang bibinian, ‘Ayu ka sini nah. Kita bararamian. Sualnya duitku nang hilang sudah tadapat pulang.’ ");
INSERT INTO bjn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nah, nang kaya itu jua, malaikat-malaikat Allah kahimungan amunnya ada urang badosa nang batobat.” ");
INSERT INTO bjn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Gasan manahapi maksud nang labih dalam, Nabi Isa maungkai lagi sabuting kisah. “Nah, ada saikung abah nang baisian dua ikung anak lalakian” ujar Nabi Isa bamula bakisah. ");
INSERT INTO bjn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Nang ading baucap, ‘Bah, bagiakan pang harta pian nang manjadi bagian ulun. Wayahini jua!’ Lalu dibagi abahnya ai hartanya gasan kadua anaknya. ");
INSERT INTO bjn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kada lawas, nang ading tu manjual samunyaan bagiannya. Imbah tu inya tulak madam ka banua urang. Di pamadaman tu, inya hidup gasan bararamian haja mahabisakan duitnya nang banyak tu. ");
INSERT INTO bjn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wayah duitnya parak bakarik, tajadi musibah kalaparan di banua nang itu sampai inya gin taumpat kakurangan. ");
INSERT INTO bjn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Maka umpat bagawi ai inya ka saikung saudagar banua nang itu. Inya disuruh maumpani babi-babinya salajur maharaguakan. ");
INSERT INTO bjn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wayah maumpani babi-babi nitu, parutnya lapar banar sampai inya handak mamakan umpan babi-babi nang itu lantaran saikung-ikung gin kadada urang nang mambarinya makanan. ");
INSERT INTO bjn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kaputingannya inya sadar. Lalu inya baucap dalam hati, ‘Sabarataan urang nang umpat bagawi lawan abahku kalabihan makanannya. Amun di sini, aku parak mati kalaparan. ");
INSERT INTO bjn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Bulik haja sudah aku ni. Kaina aku bapadah lawan abahku amun aku ni sudah badusa wan handak batobat. ");
INSERT INTO bjn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Aku ni kada pantas lagi disambat anak sidin. Amun kawa, aku ni umpat bagawi lawan sidin.’ ");
INSERT INTO bjn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Basiap-siap ai inya. Lalu inya bulik ka rumah abahya. Biar masih jauh matan rumahnya, abahnya sudah pinandu malihatnya. Maras banar abahnya malihatnya. Bukah ai abahnya mandapatinya. Diragapnya sambil batatangisan. Himung banar abahnya. ");
INSERT INTO bjn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lalu nang anak baucap, ‘Bah,’ ujarnya, ‘Ulun ni sudah badusa lawan Nang di Atas wan katulahan lawan pian! Kada pantas lagi ulun ni disambat anak pian.’ ");
INSERT INTO bjn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tagal abahnya mangiau anak-buahnya, ‘Lakasi ka sini! Bawaakan jubah nang pambaiknya. Purukakan ka awaknya. Pasangakan utas di jarijinya lalu pasangakan sipatu di batisnya. ");
INSERT INTO bjn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lalu sumbalihakan saikung anak sapi nang lamak. Basanang-sanang ai kita baaruh salamatan. ");
INSERT INTO bjn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sualnya anakku ni dahulu kuanggap mati nang wayahini hidup pulang. Inya dahulu tu hilang, tagal inya sudah bacungul pulang. Lalu bamula ai bubuhannya baaruhan. ");
INSERT INTO bjn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wayah itu, anak nang panuhannya masih bagawi di ladang. Wayah inya bulik, sabalum masuk rumah, inya mandangar suara orkes lawan malihat urang baigal-igal dalam rumah. ");
INSERT INTO bjn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Dikiaunya saikung sasuruhan abahnya nang ada di situ. Lalu ditakuninya. ‘Ui, lagi baapaan ni? Pina rami banar!’ ujarnya batakun. ");
INSERT INTO bjn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Ading pian sakalinya bulik! Abah pian manyuruh manyumbalih anak sapi nang palamaknya gasan bararamian. Sualnya sidin sudah badapat lagi lawan ading pian dalam kaadaan salamat’ ujar sasuruhan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Lalu sarik ai anak nang panuhannya tu sampai kada hakun masuk ka rumah. Lalu abahnya kaluar gasan mambisai anak nang panuhanya tu sakira hakun masuk. ");
INSERT INTO bjn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tagal ujar anaknya, ‘Bah, coba pikirakan! Sudah lawas ulun bahimat bagawi mangganiꞌi pian. Ulun gin maasi tarus napa ujar abah. Biar nang kaya itu, saikung anak kambing gin pian kada suah sumbalihakan gasan ulun sakira kawa bararamian lawan kakawalan ulun! ");
INSERT INTO bjn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anak abah nang itu sudah malingisakan harta abah gasan malahung. Tagal imbah inya bulik, abah manyumbalih anak sapi nang lamak gasan inya! ");
INSERT INTO bjn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Nah, kaya ini anakku,’ ujar abahnya, ‘ikam saban hari ada haja lawan aku. Samunyaan hartaku, ya ampun ikam jua.’ ");
INSERT INTO bjn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kita musti himung wan basanang-sanang. Sualnya ading ikam tu dahulu hilang, wayahini sudah tadapat pulang. Nang dahulu tu kuanggap sudah mati, tagal wayahini hidup pulang. Kaya itu pang nak ai” ujar abahnya manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nabi Isa lalu bakisah pulang ka pangikut-pangikut Sidin. “Ada saikung urang nang sugih banar. Inya baisian saikung bandahara, urang nang diparcayaakan manjalanakan usahanya. Tagal hanyar haja katahuan bandaharanya tu banyak banar mamborosakan hartanya. ");
INSERT INTO bjn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lalu ai dikiaunya bandaharanya tu, ‘Sabalum ikam kuampihi, samunyaan pambukuan masalah hartaku sarahakan lawan aku!’ ");
INSERT INTO bjn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Maka bandahara tu bapandir dalam hati, ‘Umai, amun aku jadi diampihi kaya apa lah? Amun bakabun, aku mancangkul, kada kuat lagi. Amun jadi paminta-minta gin, supan banar aku. ");
INSERT INTO bjn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nah, aku ada akal supaya urang-urang hakun manarima aku di rumah-rumahnya amun aku diampihi bagawi.’ ");
INSERT INTO bjn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Lalu dikiaunya satiap urang nang ada tahutang lawan majikannya. ‘Barapa ikam tahutang lawan majikanku’ ujarnya batakun lawan urang nang panambaian. ");
INSERT INTO bjn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“‘Aku ada bahutang saratus jerigen minyak zaitun’ ujarnya bapadah. “‘Ini nah bon hutangnya. Tulis lima puluh jerigen haja gin’ ujar bandahara tu. ");
INSERT INTO bjn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“ Lalu dikiaunya pulang, nang saikung nang bahutang. Ditakuninya, “Ikam barapa hutang lawan majikanku?’ “‘Aku ada bahutang saribu karung gandum ’ jar. “‘Ini nah bon hutangnya. Tulis ja dapalan ratus karung haja’ ujar bandahara tu. ");
INSERT INTO bjn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Maka urang nang sugih tu maakui bandaharanya nang kada jujur tu pintar banar maakali. “Nah, urang-urang nang mancintai hal-hal duniawi tapintar pang lawan papadaannya daripada urang-urang nang mantaati Allah. ");
INSERT INTO bjn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dangarakanlah! Gunaakanlah harta duniawi ikam gasan mambantu urang sakira ikam baulihi kakawalan. Kaina wayah harta duniawi ikam kadada lagi, ikam pacang ditarima Allah di kadiaman kakal lantaran ikam bijak mangunaakan harta duniawi ikam. ");
INSERT INTO bjn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Urang nang kawa diparcayai dalam hal-hal nang kacil, musti kawa jua diparcayai dalam hal-hal nang ganal. Tagal nang kada kawa diparcayai dalam hal-hal nang kacil, kada kawa jua diparcayai dalam hal-hal nang ganal. ");
INSERT INTO bjn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Amun lawan harta duniawi haja, ikam kada kawa diparcayai, kadada harapan diparcayaakan ka ikam harta nang sabujurnya di surga. ");
INSERT INTO bjn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amun ikam kada jujur lawan harta urang, kadada urang nang hakun manjulungi ikam harta nang pacang manjadi ampun ikam saurang. ");
INSERT INTO bjn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kadada nang kawa bagawi gasan dua ikung majikan. Sualnya inya musti labih sayang nang saikung pada nang saikungnya. Atawa inya pacang labih satia lawan nang saikung pada nang saikungnya. Kaya itu jua lawan bubuhan ikam. Bubuhan ikam kada kawa manjadi hamba Allah sakaligus manjadi hamba harta duniawi.” ");
INSERT INTO bjn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bubuhan aliran parisi mandangar samunyaan nang dicaramahakan Nabi Isa tadi. Lalu Sidin ditatawaakan ulih bubuhannya lantaran bubuhannya tu mata duitan. ");
INSERT INTO bjn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lalu, Nabi Isa bapaling ka bubuhannya wan baucap, “Bubuhan ikam bapiragah manjadi urang saleh wan katuju dipuji urang. Tapi Allah tahu haja napa nang ada di dalam hati ikam. Napa nang dipuji urang, dimuari ulih Allah. ");
INSERT INTO bjn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Hukum Taurat nang diturunakan lawan Nabi Musa lawan tulisan nabi-nabi bahari balaku sampai jaman Nabi Yahya. Bamula wayah itu, Habar Baik manganai Karajaan Allah dihabarakan. Lalu satiap urang bujur-bujur disilahakan masuk ka dalam Karajaan Allah tu. ");
INSERT INTO bjn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Samunyaan Pirman Allah tadi tatap balaku. Itu tu labih kakal daripada langit wan bumi. ");
INSERT INTO bjn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Contohnya, satiap urang nang basarakan lawan bininya lalu babini pulang lawan babinian lain, itu sama lawan bajinah. Lawan pulang urang nang babini lawan babinian nang sudah sarak, sama haja bajinah jua.” ");
INSERT INTO bjn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nabi Isa bakisah pulang, “Ada urang nang sugih nang katuju babaju nang larang-larang. Saban hari inya bararamian haja, banyak mahabisakan duitnya. ");
INSERT INTO bjn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ada saurang paminta-minta nang barabah di muka kandang rumahnya nang bangaran Lasarus. ");
INSERT INTO bjn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Awaknya bakorengan sampai korengnya dijilati kuyuk-kuyuk. Inya handak banar marasai makanan labihan nang tagugur matan mija urang sugih tu. ");
INSERT INTO bjn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Imbah itu mati ai urang nang miskin tu lalu panyawaannya diangkat malaikat ka wadah nang tahurmat, di pangkuan Nabi Ibrahim. Kada lawas imbah itu, mati jua urang nang sugih tu, lalu dikuburakan. ");
INSERT INTO bjn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wayah mandarita siksaan di naraka, urang sugih tu manangadah lalu dilihatnya di wadah nang jauh Lasarus nang lagi duduk di pangkuan Nabi Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lalu urang sugih tu baucap wan Nabi Ibraham, “Oh, Baginda Nabi, marasi pang ulun. Coba pang suruh Lasarus manculupakan jarigi tangannya ka banyu lalu datangi ulun basahiakan ilat ulun. Ulun sangsara banar di dalam nyala api ni!” ujarnya. ");
INSERT INTO bjn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“‘Ingatakan nak ai,’ ujar Nabi Ibrahim manyahut, ‘Salawasan ikam hidup, ikam marasai nang nyaman-nyaman haja. Amunnya Lasarus, inya tu maka am, sakit hidupnya salawas di dunia. Wayah ini pang inya dihimungi di sia, amunnya ikam, sangsara. ");
INSERT INTO bjn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lawan pulang, di antara ikam wan kami diulah jurang nang dalam banar nang kada kawa disubarangi. Maka urang di sia kada kawa ka situ wan urang di situ kada kawa ka sia. ");
INSERT INTO bjn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“‘Amun kaya itu, baginda ai,’ ujar urang sugih tu, ‘Suruh pang Lasarus mandatangiakan kulawarga ulun. ");
INSERT INTO bjn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sualnya ulun ni ada baisian dangsanak, lima ikung nang masih hidup. Bubuhannya baluman batobat jua. Suruh pang Lasarus mangisahakan nang kaya apa ajab naraka nang ini lawan bubuhannya sakira bubuhannya kada masuk ka sia.’ ");
INSERT INTO bjn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“‘Sudah ada lawan bubuhannya Kitab Suci Taurat nang sudah disampaiakan lawan Nabi Musa wan nabi-nabi lainnya. Samustinya bubuhannya mamatuhi napa nang ditulis di situ’ ujar Nabi Ibrahim manyahuti. ");
INSERT INTO bjn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“‘Itu kada cukup baginda ai. Tapi, amun ada urang mati nang hidup pulang lalu babulik pulang ka dunia gasan mamadahi bubuhannya, musti bubuhannya batobat’ ujar urang sugih tadi. ");
INSERT INTO bjn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Amun bubuhannya kada mamatuhi Kitab Suci Taurat nang disampaiakan lawan Nabi Musa wan nabi-nabi lainnya, musti bubuhannya kada hakun parcaya jua biar ada urang nang mati nang hidup pulang gasan mamadahi bubuhannya’ ujar Nabi Ibrahim manyahuti pulang. ");
INSERT INTO bjn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nabi Isa bacaramah pulang lawan pangikut-pangikutnya, “Gudaan nang maulah urang badusa tu salalu ada. Tagal cilaka lagi urang nang maulah urang lain badusa. ");
INSERT INTO bjn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amun ada urang nang mambawai pangikut-pangikut-Ku nang kada kuat imannya maulah dusa, itu hukumannya barat banar. Baiknya batu ganal dijaratakan ka puhun gulu urang itu, lalu inya dicaburakan ka laut daripada inya maulah urang lain badusa. ");
INSERT INTO bjn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Maka mun kawa, bajaga-jaga ai diri ikam ni. Jangan sampai disasatakan urang apalagi manyasatakan urang. Amun dangsanak ikam maulah dusa, tagur! Amun inya batobat, ampuni inya. ");
INSERT INTO bjn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Biar inya rancak maulah dusa lawan ikam, tagal tiap kali imbah itu inya baucap, ‘Minta maaplah, ampunilah aku,’ ikam musti mamaafakannya wan maampuninya.” ");
INSERT INTO bjn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Lalu pangikut-pangikut Nabi Isa baucap ka Sidin, “Tulungi pang kami ini biar kami bujur-bujur baiman ka Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lalu Sidin manyahuti, “Amun ikam hanya baisian iman nang halus nang kaya bigi sawi, bilanya ikam manyuruh puhun nang itu baalih ka laut, maka baalih ai inya. Baarti inya tu taat lawan parintah ikam.” ");
INSERT INTO bjn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lalu Nabi Isa baucap pulang, “Coba ikam bayangakan, amun ikam baisi anak buah nang manjaga inguan ikam atawa mahumai tanah ikam. Amun inya tuntung bagawian di luar, inya naik ka rumah ikam. Ikam kada bataha baucap, ‘Ayu lakasi makanan, makanan sudah siap.’ ");
INSERT INTO bjn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sabaliknya ikam sabagai majikan cagaran baucap lawan anak buah ikam, ‘Puruk tu nah baju nang disadiakan gasan bagawian di rumah. Siapakan makanan gasan aku. Lalu layani aku di mija makan. Hanyar ikam bulih makan imbah aku tuntung makan!” ");
INSERT INTO bjn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ikam kada bataha maucapakan batarima-kasih lawan anak buah ikam habis inya tuntung manggawian. ");
INSERT INTO bjn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nang kaya itu jua lawan ikam. Imbah ikam manggawi samunyaaan nang Allah suruh, bapadah ja, ‘Ulun nih hamba biasa haja, ulun nih hanya manunaikan kawajiban ulun haja.’” ");
INSERT INTO bjn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wayah itu, Nabi Isa baampah ka kuta Yarusalem malalui banua Samaria nang basubalahan wan banua Galilea. ");
INSERT INTO bjn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pas masuk sabuah kampung, Sidin didatangi sapuluh ikung urang nang bapanyakit kulit nang manular. Bubuhannya tu badiri jauh-jauh, ");
INSERT INTO bjn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sambil bakuciak. “Guru! Marasi pang kami! Tatambaiakan pang panyakit kami ini!” ujarnya. ");
INSERT INTO bjn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pas Sidin maliat bubuhanya, Sidin baucap, “Datangi ja ka imam bubuhan ikam! Kaina tampaiakan ja awak bubuhan ikam tu lawan imam tu. ");
INSERT INTO bjn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Balum sampai mandatangi imam, sakalinya panyakit bubuhannya sudah waras. Tagal cuma saikung urang haja dari sapulu urang tadi nang hakun babulik ka wadah Nabi Isa. “Alhamdulilah! Panyakit ulun sudah waras!” ujarnya sambil mamuji Allah lawan suara nyaring. ");
INSERT INTO bjn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lalu inya langsung basujut di hadapan Nabi Isa sambil baucap, “Guru, tarima kasih banar.” Urang nang hakun baucap tarima kasih tadi sakalinya urang Samaria. ");
INSERT INTO bjn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","“Maka sapuluh ikung urang tadi nang hanyar waras tu. Kanapa maka nang sambilan ikung urang tadi nang diwarasakan kada babulik gasan basyukur lawan batarima kasih? ");
INSERT INTO bjn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kanapa maka hanya urang luar haja nang babulik basyukur ka Allah, lain urang nang juriatnya Nabi Ibrahim?!” ujar Sidin marasa tahiran-hiran sambil baucap ka urang nang banyak tu. ");
INSERT INTO bjn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","“Badiri ja ikam wan tulak ja ikam. Ikam sudah waras wan ikam disalamatakan lantaran ikam baiman ka Aku” ujar Nabi Isa ka urang nang hanyar waras tadi. ");
INSERT INTO bjn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wayah itu, Nabi Isa didatangi babarapa pamuka agama aliran Farisi. Lalu bubuhannya batakun, “Guru, pabila karajaan Allah cagar didiriakan?” ");
INSERT INTO bjn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lalu Nabi Isa manyahuti, “Urang-urang cagaran kada kawa manangguh di mana posisi kadatangan karajaan Allah tu. Sualnya karajaan Allah sudah ada sacara gaib di tangah-tangah antara kita.” ");
INSERT INTO bjn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sidin baucap pulang lawan pangikut-pangikut Sidin, “Kaina, bubuhan ikam cagar marasa kaganangan banar lawan Aku, lalu baucap nang kaya ini, ‘Oh, baik banar jakanya Nang Datang Matan Di Surga babulik pulang hari ini lalu mamarintah di sini nang kaya Sidin mamarintah di surga!’ Tapi ikam pacangan kada kawa malihatnya. ");
INSERT INTO bjn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Urang cagar baucap lawan ikam, ‘Lihati, Nabi Isa ada di sini!’ atawa ‘Sidin ada di sana!’ Tapi janganlah bubuhan ikam tulakan mandatangi ka wadah nang dipadahi tadi.” ");
INSERT INTO bjn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sualnya nang kaya kilat manarangi di langit dari hujung ka hujung, nang kaya itu jua samunyaan urang cagar malihat kadatangan-Ku kaina. ");
INSERT INTO bjn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tapi sabalumnya Aku musti banyak mandarita wan Aku musti ditolak ulih urang-urang nang hidup di jaman ini. ");
INSERT INTO bjn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nang kaya kajadian hidupnya urang-urang nang hidup pada jaman Nabi Nuh, nang kaya itu jua nang cagar tajadi waktu kadatangan-Ku kaina. ");
INSERT INTO bjn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bubuhannya kada bapikir cagar ada bancana nang manimpa bubuhannya. Bubuhannya haur makan wan nginum, lalakian babini, babinian balaki. Artinya urusannya duniawi haja. Bubuhannya hidup nang kaya biasa biasa haja sampai waktunya kulawarga Nabi Nuh masuk ka dalam parahu nang ganal tu, lalu datang ai bancana banyu baah nang ganal tu lalu matian bubuhannya samunyaan. Tapi Nabi Nuh wan kulawarganya tatap salamat. ");
INSERT INTO bjn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Kadatangan-Ku kaina sama nang kaya bancana nang tajadi waktu di jaman Nabi Lot. Bubuhan warga kuta Sodom hidup nang kaya biasa biasa haja. Ada nang haur makan wan nginum, wan ada nang haur badagang. Ada nang haur bahuma, ada jua nang haur baulah rumah. ");
INSERT INTO bjn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tapi bakakajutan pas waktu Nabi Lot kaluar di kuta nang itu, hujan api dan belerang turun di langit lalu mambinaasakan bubuhannya sabarataan. ");
INSERT INTO bjn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nang kaya itu jua, bakakajutan Nang Datang Matan Di Surga cagar datang gasan mamarintah. ");
INSERT INTO bjn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Pada hari nang itu, urang nang baada di teras rumah janganlah masuk pulang ka dalam rumah gasan maambil sasuatu dari harta bandanya. Nang kaya itu jua, urang nang lagi di pahumaan, janganlah handak bulik ka rumah lagi. ");
INSERT INTO bjn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ingatakan ja napa nang tajadi lawan bini Nabi Lot! ");
INSERT INTO bjn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Samunyaan urang nang bajuang mampartahanakan panyawaannya di dunia ini cagar tatap kahilangan panyawaannya. Tapi samunyaan urang nang siap mangurbanakan panyawaannya lantaran maumpati Aku, inya tu pang nang cagar mandapatakan kahidupan nang kakal. ");
INSERT INTO bjn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Dangarakan: Pada waktu kadatangan-Ku kaina, hal-hal nang kaya ini nang cagar tajadi. Pada malam itu, ada dua urang nang lagi guring di paguringannya. Nang saikung cagar dibawa malaikat, lalu nang saikungnya lagi cagar ditinggalakan. ");
INSERT INTO bjn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Di wadah lain, dua ikung babinian lagi manggiling gandum pakai batu gilingan. Nang saikung cagar dibawa malaikat, nang saikungnya lagi cagar ditinggalakan.” ");
INSERT INTO bjn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lalu pangikut-pangikut Sidin batakun, “Junjungan, di mana hal nang itu tu bakal tajadi?” Lalu Nabi Isa manyahut, “KadatanganKu kaina diibaratakan nang kaya rancak diucapakan, ‘Di mana ada bangkai, di situ jua burung-burung pamakan bangkai salalu bakumpulan.’” ");
INSERT INTO bjn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nabi Isa maungkai pulang xxxsabuting/sabuah kisah gasan pangikut-pangikut Sidin sakira jangan muyak badoa wan jangan baputus asa. ");
INSERT INTO bjn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Di sabuah kuta ada saikung hakim. Hakim nang tu kada takutan lawan Allah wan kada parduli lawan urang lain. ");
INSERT INTO bjn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Di kuta nitu ada jua saikung balu/babinian balu nang tatarusan mandatangi hakim tu. ‘Tulungi pang ulun! Lawanakan xxx GASAN ulun {??malawan musuh ulun nang handak marugiakan ulun’ ujar babinian balu tu. ");
INSERT INTO bjn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Asalnya hakim nang itu kada hakun/HANDAK manulungiakan si babinian balu tu/babinian balu nang itu. Tapi kaputingannya, inya bapikir dalam hati, “Aku kada takutan lawan Allah wan kada parduli/paduli lawan urang lain, ");
INSERT INTO bjn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tapi lantaran nang balu/nang si balu ni tatarusan manangsai aku, baik kulawanakan/kulanjurakan haja sudah pakaranya. Amun kada, diharunginya tarus aku kaina. ");
INSERT INTO bjn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","“Nah,” ujar Nabi Isa manutup kisah tadi, “Ingatakan ja napa nang dipandirakan hakim nang culas tu! ");
INSERT INTO bjn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kaputingannya si hakim gin hakun jua malawanakan. Maginnya ai Allah! Inya gin musti hakun manulungi umat-Nya nang mangiau-Nya tarus saban hari. MAGINNYA AI ALLAH HAKUN JUA MANULUNGI UMATNYA NANG SABAN HARI MANGIAU INYA TARUS Inya lakas haja manulungi umat-Nya. ");
INSERT INTO bjn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nah, coba dangarakan! Situ saini Allah pacang mambariꞌi kaadilan lawan umat-Nya! Biar nang kaya itu, wayah Nang Datang Matan Di Surga babulik pulang ka dunia ini, balum tantu Inya manamui urang-urang nang delete:masih parcaya lawan Inya.” ");
INSERT INTO bjn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nabi Isa bakisah pulang sabuting kisah lawan urang-urang nang maanggap dirinya panyalehnya/si panyalehnya wan katuju marandahakan urang lain. ");
INSERT INTO bjn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ada satu kisah,” ujar Nabi Isa, “Dua ikung lalakian handak tulak/tulakan ka Bait Allah handak badoa. Nang saikung pamuka agama, nang saikungnya lagi tukang tagih pajak nang rancak/rajin mambunguli urang. ");
INSERT INTO bjn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Imbah itu, nang pamuka agama badiri manyaurangan. Lalu inya badoa, ‘Ya Allah, aku nang saleh ini nah, aku basukur, aku kada kaya urang lain, nang jahat, {manipu atawa bajinah/aku kada manipu wan aku kada bajinah} wan aku kada kaya tukang tagih pajak nang itu tu nah’ ujarnya mamuji dirinya saurang. ");
INSERT INTO bjn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","‘Aku bapuasa dua kali saminggu. Aku basadakah sapuluh parsen matan samunyaan pakulihanku.’ ");
INSERT INTO bjn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tapi si tukang tagih pajak tu badoa jua tapi inya badiri jauh, kada wani manangadah lawan Allah/Nang Di Atas xxxx nang kaya kabiasaan juriat Nabi Ibrahim. ‘Ya Allah, marasi haja ulun, nang badusa ini’ ujarnya sambil manitikakan banyu mata.” ");
INSERT INTO bjn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nah, tanggui pang! Siapa nang diampuni dosanya?” ujar Nabi Isa batakun. “Tukang tagih pajak tu nang diampuni dusanya wan dihargai Allah, lain pamuka agama tadi! Sualnya urang nang sumbung cagar dibari supan. Tapi urang nang marandahakan diri, itu tu nang dihargai Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wayah itu, ada babarapa urang nang mambawa kakanakan mandatangi Nabi Isa handak minta kakanakan tu dijapaiakan wan dibarakahi ulih Sidin. “Ui, jangan mahauri Guru!” ujar pangikut-pangikut Sidin sambil manangati lawan kuitan kakanakan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Biar nang kaya itu, Nabi Isa tatap mambulihakan kakanakan tu mandatangi sidin. Lalu Sidin baucap, “Biarakan haja kakanakan ni mandatangi Aku. Jangan ditangati. Sualnya Allah katuju maharagu urang nang manarima kuasa-Nya nang kaya kakanakan ni manarima kuasa kuitannya. ");
INSERT INTO bjn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nah, dangarakan nih nah! Sabujurannya, nang hakun mandangarakan wan manaati Pirman Allah lawan hati nang tulus nang kaya kakanakan nih nah, inya cagaran masuk karajaan Allah. Nang kada hakun, inya kada kawa masuk. ");
INSERT INTO bjn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ada saikung pamuka agama mandatangi Nabi Isa lalu batakun, “Guru nang baik,” ujarnya, “umpat batakunlah, napa nang musti kulakuakan gasan baulihi hidup nang kakal?” ");
INSERT INTO bjn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Kanapa jadi ikam mamadahakan Aku urang nang baik? Nang baik tu hanya Allah haja” ujar Nabi Isa balas batakun. ");
INSERT INTO bjn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Ikam sudah tahu parintah Kitab Suci Taurat nang ini: ‘Jangan bajina, jangan mambunuh, jangan mancuntan, jangan basaksi palsu, wan hormatilah kuitan ikam.’” ");
INSERT INTO bjn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Inggih, guru ay, samuaan parintah nang itu sudah ulun taati tumatan anum sampai wayahini” ujar pamuka agama tadi manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","“Tapi, ada sabuting lagi nang musti ikam lakuakan. Juali samuaan harta ikam tu nah, imbah tu bagiakan duitnya ka urang-urang miskin. Kaina ikam baulihi harta di surga. Lalu umpati Aku. ");
INSERT INTO bjn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","“Umai ngalih banar pang lah saratnya. Aku nih urang nang sugih! Musti manjuali samuaan hartaku? Habisam hartaku amun dibagiakan ka urang nang miskin!\" ujarnya bapandir dalam hati. ");
INSERT INTO bjn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","“Ngalihnyalah urang nang sugih masuk ka karajaan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tanyaman saikung unta masuk malalui luang jarum katimbang urang sugih masuk ka dalam karajaan Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","“Wah! Amun kaya itu, siapa garang nang bakal disalamatakan wan masuk ka dalam karajaan Allah?” ujar urang nang hadir di situ sambil batakun. ");
INSERT INTO bjn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","“Napa nang kada kawa dilakuakan manusia, kawa haja dilakuakan ulih Allah” ujar Sidin manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","“Anu, Guru ai” ujar Pitrus baucap ka Nabi Isa, “Kami ini sudah maninggalakan kasamuaan gawian lantaran maumpati Pian!” ");
INSERT INTO bjn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Parcaya ja!” ujar Nabi Isa, “Urang nang maanggap karajaan Allah labih panting daripada harta wan kaluarganya, ");
INSERT INTO bjn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","inya cagaran baulihi ganjaran balipat-lipat ulih Allah di dunia ini wan kaina inya cagaran baulihi hidup kakal di surga.” ");
INSERT INTO bjn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Lalu Nabi Isa manyuruh kaduabalas pangikut-Nya baparak lalu Sidin baucap, “Nah, dangarakanlah! Pada jaman dahulu, bubuhan nabi sudah manulis bahwa Nang Datang Matan Di Surga sudah ditakdirakan maalami hal-hal nang manyakitakan di kuta Yarusalem. Satumat lagi, kita gin handak tulakan ka sana. Imbah itu, hal-hal nang itu bakalan tajadi wan Aku. ");
INSERT INTO bjn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aku kaina ditangkap wan disarahakan ka urang Roma gasan diadili. Aku kaina dihuhuluti, dibari supan, diludahi, dicambuki wan paampihannya Aku dimatiꞌi. ");
INSERT INTO bjn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tapi talu hari imbah itu, Aku dihidupakan pulang.” ");
INSERT INTO bjn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tapi bubuhan pangikut Sidin kada paham hal-hal nitu tadi lantaran inya masih kada parcaya bahawa Nabi Isa tu kawa disiksa, dimatiꞌi wan dihidupakan pulang. Arti pandiran Nabi Isa tadi tasambunyi. ");
INSERT INTO bjn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wayah Nabi Isa sudah parak sampai kuta Yeriko, ada saikung paminta-minta nang picak duduk di pinggir jalan. ");
INSERT INTO bjn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","“Ada apa garang nih? Pina rami banar urang lalu lalang di sini?” ujarnya batakun. ");
INSERT INTO bjn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Itu nah, Nabi Isa matan kuta Nasaret parahatan lalu di sini” ujar urang mamadahinya. ");
INSERT INTO bjn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","“Nabi Isa! Juriat Nabi Daud marasi pang ulun!” ujar urang picak tadi bakuciak. ");
INSERT INTO bjn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inya disariki urang-urang nang balalu-lalang di hadapannya. Bubuhannya manangatinya bakuciak-kuciak. “Juriat Nabi Daud, marasi pang ulun!” ujar urang picak tambah nyaring bakuciak pulang. ");
INSERT INTO bjn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bamandak ai Nabi Isa. Lalu disuruh Sidin urang mambawa urang picak tadi. ");
INSERT INTO bjn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Baapa garang, ikam bakiaw?” ujar Nabi Isa batakun. “Junjungan, ulun handak supaya kawa malihat,” ujarnya manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Ayuai amun kaya itu, malihat ja! Ikam sudah waras wan salamat lantaran ikam baiman ka Aku,” ujar Nabi Isa baucap. ");
INSERT INTO bjn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Langsung kawa malihat ay urang tu. Lalu ai inya maumpati Nabi Isa sambil mamuji Allah. “Syukur al hamdulilah. Ulun kawa malihat. Ulun kawa malihat,” ujarnya bakuciak. Urang lain gin umpat jua mamuji Allah lantaran mujizat Nabi Isa tadi. ");
INSERT INTO bjn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nabi Isa wan pangikut-pangikut Sidin mamasuki kuta Yariko wan manarusakan parjalanan bubuhannya malalui kuta nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Di situ ada saikung komandan/kapala tukang tagih pajak nang sugih, ngarannya Zakeus. ");
INSERT INTO bjn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Inya handak banar malihat siapa Nabi Isa tu, tapi kada kawa lantaran awaknya endek/hendep/handap banar wan urang banyak bakarumun di parak Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jadi, inya buka mandahului urang-urang, lalu banaik ka atas puhun sakira kawa malihat Nabi Isa nang satumat lagi handak lalu di situ. ");
INSERT INTO bjn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pas Nabi Isa sampai di bawah pohon tu, Sidin malihat ka atas balalu baucap, “Oh, Zakeus, lakasi, turun ikam! Aku handak baelang ka wadah ikam hari ini.” ");
INSERT INTO bjn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lalu ay Zakeus turun badadas/balakas lantaran kahimungan. Lalu inya mamparsilahakan Sidin baelang ka rumahnya. ");
INSERT INTO bjn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sabarataan urang nang malihat hal nang itu manggarunum sambil baucap, ”Cih! Guru nih hakunnya lah maelangi urang nang banyak badusa!” ");
INSERT INTO bjn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lalu Zakius badiri. “Nah, kaya ini nah Junjungan,” ujarnya, “Satangah hartaku kubariakan lawan urang-urang miskin. Lawan urang nang suah kutipu/kudustai, pajaknya, kubulikakan duitnya ampat kali lipat.” ");
INSERT INTO bjn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Imbah itu, Nabi Isa baucap, “Hari ini, sarumahan nih salamat lantaran Zakius umpat maimani napa nang diimani ulih Nabi Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sualnya Nang Datang Matan Di Surga datang gasan mancariꞌi wan manyalamatakan urang-urang nang sasat.” ");
INSERT INTO bjn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nabi Isa sudah parak masuk ka kuta Yarusalem. Urang banyak manyangka bahwa amun Sidin masuk kuta Yarusalem, Sidin handak langsung mandiriakan karajaan Allah dan jua juriat Nabi Ibrahim cagar bibas dari panjajahan Roma. Maka lantaran itu, Sidin maungkaiakan sabuting kisah supaya urang tahu bahwa Karajaan Allah tu kada langsung jadi. Ini nah kisahnya. ");
INSERT INTO bjn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Ada saikung urang nang tulak ka banua nang jauh handak diangkat manjadi raja. Imbah itu, hanyar inya handak bulik gasan mamarintah di banuanya saurang. ");
INSERT INTO bjn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pas balum tukak, sidin mangiau sapuluh urang anak buahnya. Dijulunginya saikung-ikung sakilo uang perak. Lalu inya baucap, ‘Nah, ini nah, kujulungi buhan ikam sakilo uang perak gasan bausaha. Modelakan duit ni nah gasan badagang sampai aku babulik ka banua pulang.’ ");
INSERT INTO bjn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tagal urang-urang nang sabangsa lawan inya muar lawan inya. Maka imbah inya tulak, diutus bubuhannya utusan manyusulnya. ‘Kami kada hakun urang nang ini jadi raja di wadah kami’ ujar bubuhannya lawan utusan tu. ");
INSERT INTO bjn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Imbah diangkat manjadi raja, inya babulik pulang ka banua. Lalu dikiaunya/inya mangiau anak-anak buahnya tunggal ikungan nang sudah dimodelinya. Raja tu handak tahu barapa hujungan nang didapat bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nang panambaian datang wan bapadah, ‘Ampun baginda ay, duit nang pian julung tu ka ulun sudah mahasilakan sapuluh kali lipat!’ ");
INSERT INTO bjn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Umai lah. Bagus banar’ ujar raja tu. ‘Ikam ni anak buah nang baik. Dalam hal-hal nang halus ja, ikam sudah tabukti kawa diparcayai. Lantaran itu, ikam kuangkat manjadi panguasa sapuluh kuta.’ ");
INSERT INTO bjn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Lalu anak buah nang kadua datang wan bapadah, ‘Ampun baginda ay, duit nang pian julung ka ulun sudah mahasilakan lima kali lipat.’ ");
INSERT INTO bjn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Nah, bagus jua ikam ni!’ ujar raja tadi, ‘Ikam kuangkat manjadi panguasa lima kuta!’ ");
INSERT INTO bjn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Lalu datang anak buah nang saikungnya lagi lalu baucap, ‘Ampun baginda ay, ini nah duit nang pian julung ka ulun. Ulun simpanakan dalam kain sakira aman. ");
INSERT INTO bjn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sualnya ulun takutan lawan pian lantaran pian tu urang nang kajam banar. Pian haur maambil napa nang ampun urang. Wan pian haur mamutik buah biar pian kada suah mananam/nang kada suah pian tanam. ");
INSERT INTO bjn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Jahat banar ikam tu!’ ujar raja tu manyariki anak buahnya. ‘Kajam jua aku ni lah? Ayuai lantaran ikam maanggap aku kajam, maka aku bakajam lawan ikam. Ikam kuhukum. Amun ikam tahu aku tu urang nang kajam nang haur maambil napa nang lain ampunku wan mamutik buah nang kada suah kutanam, ");
INSERT INTO bjn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","lalu kanapa duit nang kujulung samalam tu kada ikam bungaakan haja supaya wayah aku bulik ka banua, duitku tu kawa kutagih lawan bunganya?’ ");
INSERT INTO bjn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Lalu raja tu manyuruh urang-urang nang badiri di parak inya, ‘Ambil duit nang ada lawan urang tu. Imbah itu, julung lawan urang nang mahasilakan sapuluh kilo tadi!’ ");
INSERT INTO bjn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lalu urang-urang nang disuruh ulih Raja tadi baucap, ‘Wah! Jangan nang kaya itu Baginda ay. Inya sudah baisian sapuluh kilo!’ ");
INSERT INTO bjn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Bujur ai’ ujar raja tu. ‘Nah, kupadahilah, siapa nang bahasil mausahaakan napa nang Allah bariakan lawan inya, pacangan dibariꞌi labih banyak. Tagal siapa nang kada bahasil mausahaakan napa nang Allah bariakan lawan inya, maka nang ada lawan inya pacangan diambil. ");
INSERT INTO bjn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nah, bawa ka sini musuh-musuhku nang kada katuju aku manjadi raja. Matiꞌi bubuhannya di hadapanku” ujar Nabi Isa manutup kisah tadi. ");
INSERT INTO bjn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Imbah tuntung bakisah, Nabi Isa mambawa pangikut Sidin baampah ka kuta Yarusalim. ");
INSERT INTO bjn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wayah handak masuk kuta Betpage wan kuta Betania di Bukit Zaitun, Sidin manyuruh dua ikung pangikut Sidin gasan masuk badahulu. ");
INSERT INTO bjn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Masuki ja kampung nang di muka tu” ujar Nabi Isa. “Imbah masuk ka sana, bubuhan ikam cagar malihat saikung kaladai nang masih anum nang bajarat. Kaledai tu kada biasa ditunggangi urang. Pacul ja tali kaladai tu, imbah itu bawa ka mari” ujar Nabi Isa pulang. ");
INSERT INTO bjn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Amun ada urang nang batakun, ‘Kanapa bubuhan ikam lapas kaladai tu?’, sahuti ja/sambat ja ‘Junjungan nang manyuruh malapas lantaran Junjungan nang mamarluakannya’ ” ujar Nabi Isa manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lalu tulakan ai bubuhannya badua. Sakalinya napa nang dapati bubuhannya pas banar lawan napa-napa nang dipadahakan Nabi Isa tadi. ");
INSERT INTO bjn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Rahatan malapas kaladai tu, ampunnya datang manakuni “Kanapa bubuhan ikam malapas kaladai tu?” ujarnya. ");
INSERT INTO bjn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Junjungan nang manyuruh malapas karna/lantaran Junjungan nang mamarluakannya” ujar bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lalu ai, kaladai tu dibawa bubuhannya ka Nabi Isa. Imbah tu, kaladai tu dilapiki ulih bubuhannya pakai baju-baju bubuhannya hanyar manulungi Nabi Isa/Nabi Isa ditulungi manunggangi kaladai tu. ");
INSERT INTO bjn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Parahatan Sidin manunggangi kaladai nang itu, urang-urang maampar baju-baju delete?:bubuhannya di jalanan sabagai ciri/bantuk mahurmati Nabi Isa sabagai Raja. ");
INSERT INTO bjn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Rahatan Nabi Isa parak sampai kuta Yarusalim, di jalan nang manurun di Bukit Zaitun, sagalumukan urang-urang tamasuk pangikut Sidin sing nyaringan mamuji Allah lantaran kahimungan manyaksiakan samuaan mujizat Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Dibarakatilah, Raja kita nang mawakili Allah! Mudahan ada damai sajahtera antara Allah wan manusia! Allahu akbar!” ujar bubuhannya sing nyaringan. ");
INSERT INTO bjn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","“Guru, suruh badiam pang pangikut-pangikut pian tu” ujar babarapa anggota aliran Parisi nang kada katuju amun Nabi Isa dipuji. ");
INSERT INTO bjn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Nah, dangarakanlah. Jaka bubuhannya bahinip, maka batu-batu nang ini pang nang cagar mamuji Aku,” ujar Nabi Isa manyahuti. ");
INSERT INTO bjn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pas Nabi Isa parak sampai kuta Yarusalem, Sidin mamandangi wan maratapi kuta nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Hai warga kuta Yarusalem, Aku basadih! Baiknya amun hari ini bubuhan ikam tahu caranya baulihi kadamaian dari Allah, tagal wayahini kada mungkin bubuhan ikam paham! ");
INSERT INTO bjn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sualnya kaina musuh bubuhan ikam mangalilingi kuta nang ini. Tanah parak tembok ditinggiakan ulih musuh ikam tu. Lalu ay kawa disubalahi tembok kuta bubuhan ikam tu. Lalu bubuhan ikam disarang matan sagala arah. ");
INSERT INTO bjn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sabarataan panduduk kuta ikam cagar dibunuh wan samuaan tembok kuta bubuhan ikam tu dirabahakan sampai rata wan tanah. Hal itu tu cagar tajadi lantaran bubuhan ikam kada manyadari bahwa Aku tu datang sabagai wakil Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lalu Nabi Isa masuk ka halaman Bait Allah di Yarusalem. Lalu sabarataan urang nang bajualan di situ disuruh Sidin bajauh. ");
INSERT INTO bjn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sidin baucap, “Di dalam Kitab Suci ada tatulis, ‘Bait Allah tu dihususakan gasan badoa, lain gasan bajualan. Tapi diulah bubuhan ikam manjadi sarang parampok.’” ");
INSERT INTO bjn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Saban hari Sidin bacaramah di Bait Allah. Tapi imam-imam kapala, guru-guru agama wan pamuka-pamuka agama lainnya basakongkol handak mamatiꞌi Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tagal bubuhannya kada tahu nang kaya apa caranya. Sualnya sabarataan urang sudah katujua mandangarakan camarah Sidin tarus. ");
INSERT INTO bjn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wayah Nabi Isa bacaramah di Bait Allah manganai karajaan Allah, lalu ai datangan imam-imam kapala, guru-guru agama lawan tatuha-tatuha agama. ");
INSERT INTO bjn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Padahakan pang! Siapa nang manyuruh ikam bacaramah di sini wan maulah hal-hal nitu di Bait Allah?” ujar bubuhannya batakun. ");
INSERT INTO bjn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nabi Isa mambalas, “Sabalum ulun manjawab napa nang ditakunakan bubuhan pian, Ulun handak batakun dulu.” ");
INSERT INTO bjn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Siapa nang manyuruh Nabi Yahya mamandi'i urang? Manusiakah atawa Allahkah? ?” ");
INSERT INTO bjn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lalu barundingan ai bubuhannya tadi. “Apa lah jawaban kita?” jar. “Amun kita jawab dari Allah, inya musti batakun, ‘kanapa maka bubuhan ikam kada mamparcayainya?'” ");
INSERT INTO bjn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Tagal amun kita padahakan ‘dari manusia’, kita bisa ditawaki urang lawan batu sampai mati. Sualnya bubuhannya tu yakin amun Yahya tu nabi.” ");
INSERT INTO bjn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaputingannya bubuhannya baucap, “Kami kada tahu siapa nang manyuruh Nabi Yahya tu.” ");
INSERT INTO bjn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“Nah, bubuhan pian ja kada tahu siapa nang manyuruh Nabi Yahya mamandi'i urang. Amun nang kaya itu, kaya apa ulun handak mambari tahu pian siapa nang manyuruh ulun bacaramah di sini” ujar Nabi Isa manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Lalu, Nabi Isa maungkai pulang sabuting kisah gasan imam-imam kapala wan guru-guru agama tadi. “Ada satu kisah,” ujarnya, “urang nang mananam anggur di kabun nang luas. Imbah ditanami, dikarunakan/disewa sidin ka urang. Imbah itu sidin tulak balawas. ");
INSERT INTO bjn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wayah musim mamutik buahnya/Pas musimnya, ampun kabun tu manyuruh anak buah sidin tulak managih hasil supaya bisa maambil bagian sidin matan tukang-tukang kabun tadi. Sakalinya, jangankan dapat bagian, malah dihajarnya lalu disuruh bajauh. ");
INSERT INTO bjn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Imbah tu disuruh sidin anak buah sidin nang lain lagi. Inya gin dihajar wan dibari supan jua. Bulik ai inya, kada mambawa napa-napa. ");
INSERT INTO bjn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dikirim pulang anak buah sidin nang katiga. Tatap ai dihajarnya jua, wan ditimbai kaluar kabun. ");
INSERT INTO bjn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Maka ujar ampun kabun tadi, ‘Kaya apa lagilah aku ni? Wayah ini, anak tunggal-Ku nang kusayangi, nang cagar kukirim lawan nang tukang-tukang karun/kabun tu nah. Pasti bubuhannya mahurmatinya, lalu manjulung bagianku.’ ");
INSERT INTO bjn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tapi pas bubuhannya malihat anak sidin saurang nang datang, bubuhannya barundingan lalu baucap, ‘Nah, nang ini pang pawarisnya. Baik kita matiꞌi ja. Jadi kita nang maambil warisannya keana.’ ");
INSERT INTO bjn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lalu ai, anak sidin tadi ditimbai bubuhannya kaluar kabun, lalu dimatiꞌi bubuhannya. Itu pang kisahnya! Nah, kikira napa yu nang pacangan dilakuakan ampun kabun tadi? ");
INSERT INTO bjn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bubuhan tukang karun/kabun musti langsung didatangi sidin, lalu dimatiꞌi sidin. Imbah itu disuruh sidin urang nang lain lagi maharagunya. Pas mandangar kisah Nabi Isa tadi, urang-urang nang ada di situ baucap, “Astagfirullah! Jangan sampai kajadian nang kaya itu!” ");
INSERT INTO bjn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lalu Nabi Isa manjanaki bubuhannya wan baucap, “Nah, amun kaya itu, kikira napa artinya ayat nang ini dari Kitab Suci Zabur, ‘Batu nang dibuang ulih tukang-tukang bangunan, sudah manjadi batu nang panting banar. ");
INSERT INTO bjn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Urang nang tagugur ka atas batu tu pacangan hancur. Lalu siapa haja nang ditindih batu nang itu, pacangan ramuk.’ ” ");
INSERT INTO bjn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Imbah mandangar kisah Nabi Isa tadi, guru-guru agama wan imam-imam kapala sabujurnya handak manangkap langsung Nabi Isa. Sualnya bubuhanya tahu amun kisah Nabi Isa tadi ditujuakan ka bubuhannya. Biar nang kaya itu, bubuhannya kada wani langsung manangkap Sidin sualnya bubuhannya takutan lawan reaksi urang banyak. ");
INSERT INTO bjn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pamuka-pamuka agama tadi mahawasi Nabi Isa tarus lalu manyuruh anak buahnya bapiraga jadi urang baik supaya kawa manjabak Sidin malalui tatakunannya. Jakanya Sidin tasalah pandir nang malawan pamarintah Roma, Sidin kawa ditangkap wan disarahakan ka pamarintah Roma nang bakuasa. ");
INSERT INTO bjn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","“Anu guru ai,” ujar anak buahnya tadi batakun lawan Nabi Isa, “bujur haja isi caramah Pian tu. Kami tahu ai Pian tu kada bapilih lawan urang. Lawan Pian jujur haja maajarakan jalan Allah. ");
INSERT INTO bjn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Umpat batakunlah! Manurut hukum agama kita, wajiblah kita mambayar pajak lawan pamarintah Roma atawa kada?” ");
INSERT INTO bjn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tagal Nabi Isa tu manyadari bubuhannya tu handak manjabak Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Injami pang ulun duit sakaping! Gambar lawan ngaran siapa garang nang ada di duit nang ini?” ujar Nabi Isa batakun. “Kaisar!” ujar urang banyak tu manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lalu Nabi Isa manjalasakan, “Amun nang kaya itu, sarahakan/bulikakan ka Kaisar napa nang ampun Kaisar, wan sarahakan/bulikakan ka Allah napa nang ampun Allah.” ");
INSERT INTO bjn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kada bahasil ai bubuhannya manjabak Sidin lawan tatakunannya tadi. Malah bubuhannya mandam/tanganga lantaran kagum banar mandangar sahutan Sidin tadi. ");
INSERT INTO bjn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ada babarapa pamuka agama nang dari aliran Saduki nang kada parcaya urang nang mati kawa dihidupakan pulang. Maka bubuhannya batakun lawan Nabi Isa, ");
INSERT INTO bjn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru” jar “Nabi Musa mamadahakan dalam Taurat bahawa jakanya saikung lalakian maninggal wan kada baisian anak, maka ading lalakiannya tadi wajib maambil bini kakanya tadi sakira kawa mambari juriat aruah kakanya. ");
INSERT INTO bjn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nah, ada satu kisah. Ada tujuh lalakian badangsanak. Nang panuhannya tu babini lalu maninggal, tapi kada baisian/baisi anak. ");
INSERT INTO bjn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lalu balunya/bininya tadi dikawini ulih ading nang panambaian lalu sakalinya mati jua. ");
INSERT INTO bjn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kaya itu jua dangsanak nang katiga sampai nang katujuh. Sama kajadiannya, imbah mangawininya kaputingannya mati/matian barataan jua, wan tatap kada sing anakan/kadada nang baanakan. ");
INSERT INTO bjn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kaputingannya babinian tu maninggal jua. ");
INSERT INTO bjn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Amun bujuran urang mati tu nah kawa dihidupakan pulang, Jawab pang! Wayah urang-urang dihidupakan pulang, babinian tu jadi bini siapa yu? Sualnya katujuh-tujuhnya suah manjadi lakinya. ");
INSERT INTO bjn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nabi Isa mambalas, “Urang nang hidup wayah ini, kawin wan dikawinakan. ");
INSERT INTO bjn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tapi kaina wayah urang dihidupakan pulang, kadada nang kawin atawa dikawinakan lagi. ");
INSERT INTO bjn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sualnya kaina bubuhannya kada kawa mati lagi lantaran bubuhannya sama nang kaya malaikat. Lantaran dihidupakan pulang ulih Allah, bubuhannya tu disambat anak-anak nang disayangi Allah. ");
INSERT INTO bjn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Malah Nabi Musa mamadahakan bahawa urang mati cagar dihidupakan pulang. Sualnya sidin mangiau Allah, Tuhan nang disambah ulih Nabi Ibrahim, Nabi Ishak, wan Nabi Yakub. ");
INSERT INTO bjn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Allah tu lain Tuhan nang disambah ulih urang nang sudah mati. Inya tu Tuhan nang disambah ulih urang nang masih hidup. Sualnya gasan Allah sabarataan urang masih hidup.” ");
INSERT INTO bjn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","“Uuu Guru, pas banar jar Pian tu nah!” ujar babarapa guru agama sambil mamuji Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lantaran itu, bubuhannya kada wani lagi manakuni Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Lalu Nabi Isa baucap, “Tangguhi nah, nang kaya apa Al Masih tu bisa disambat juriat Nabi Daud?” ");
INSERT INTO bjn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Sualnya dalam Kitab Zabur nang disampaiakan ulih Nabi Daud ada tasurat, ‘Tuhan bapirman lawan Junjunganku: Duduk ja di subalah kanan-Ku batatai wan Aku, ");
INSERT INTO bjn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampai Kuulah musuh-musuh Ikam manjadi takluk wan Ikam.’ ");
INSERT INTO bjn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Maka amun Nabi Daud mangiau Al Masih tu ‘Junjungan,’ nang kaya apa Al Masih tu bisa disambat juriatnya jua?” ");
INSERT INTO bjn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wayah sabarataan urang masih mandangarakan pandiran Nabi Isa, Sidin baucap ka pangikut-pangikut Sidin, ");
INSERT INTO bjn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Baapik-apiklah. Jangan diumpati lah gaya hidup guru-guru agama nih. Bubuhannya ni katuju baagak-agak wayah mamakai jubah nang larang, katuju dihurmati di pasar-pasar, katuju duduk di wadah-wadah nang tahurmat baik di rumah-rumah ibadah atawa di saruan-saruan. ");
INSERT INTO bjn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bubuhannya mambunguli balu-balu supaya dapat hartanya. Bubuhannya basinghaja badoa panjang-panjang sakira dianggap urang alim. Hukuman bubuhannya tu kaina musti labih barat daripada hukuman nang biasa !” ");
INSERT INTO bjn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wayah Nabi Isa badiri di teras/palatar Bait Allah, Sidin manjanaki/maitihi urang-urang nang sugih mambuati uang parsambahan ka dalam kutak parsambahan/wadah amal. ");
INSERT INTO bjn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Imbah itu, Sidin malihat jua saikung/saurang balu nang kada baisi napa-napa. Inya mambuati dua kaping/buting uang logam nang nilainya paling randah. ");
INSERT INTO bjn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lalu Nabi Isa baucap, “Dangarakan lah barataan, Ini nah, urang nang balu nang ini nah labih banyak mambari'i ka Allah pada nang lain. ");
INSERT INTO bjn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sualnya urang sugih tadi kada saapa mambari'i daripada nang balu tadi. Sualnya urang nang sugih tadi baisi harta nang banyak. Sadangkan nang balu nang ini manyarahakan samunyaan hartanya nang inya miliki. ");
INSERT INTO bjn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wayah itu, ada urang bapapandiran manganai Bait Allah. Bubuhannya kagum banar malihat batu-batu bangunan nang ganal wan bagus, wan barang-barang parsambahan nang mahiasi bangunan nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Lalu Nabi Isa baucap wan bubuhannya, “Kaina bubuhan ikam malihat bangunan nang ini dihancurakan— sampai kadada basisa lagi sabuting-buting batu nang basusun.” ");
INSERT INTO bjn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Guru, pabila hal nang itu tajadi? Adalah ciri-ciri/tanda-tandanya?” ujar urang-urang tadi batakun. ");
INSERT INTO bjn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Imbah itu, Nabi Isa mamadahi pangikut-pangikut Sidin, “Baingat-ingatlah! Jangan sampai dibunguli manganai napa nang pacangan tajadi. Sualnya kaina banyak urang nang mangaku sabagai Isa Al Masih bahwa Hari Kiamat sudah parak. Tapi janganlah parcaya lawan bubuhan pangaramput nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lawan pulang, bubuhan ikam kada usah gair amun mandangar habar tantang paparangan wan karusuhan. Sualnya hal-hal nang kaya itu tu musti tajadi, tapi wayah itu hari kiamat masih lawas, hanyar tajadi. ");
INSERT INTO bjn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Suku-suku urang gin pacangan baperang. ");
INSERT INTO bjn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gampa bumi, bahaya kalaparan, wan wabah panyakit pacangan ada di mana-mana. Hal-hal nang manakutanakan cagaran bacungulan di langit.” ");
INSERT INTO bjn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tapi sabalum samunyaan nang itu tajadi/bajadian, urang-urang cagar manangkap wan manganiaya bubuhan ikam. Gara-gara ikam tamasuk pangikutKu, sapalih bubuhan ikam cagar diadili di rumah ibadah. Sapalihnya lagi cagar dipanjaraakan. Bubuhan ikam cagar dihirit dan dihadapakan lawan raja-raja wan panguasa-panguasa. ");
INSERT INTO bjn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lantaran kajadian-kajadian nang itu, ikam sawat basaksi tantang Aku lawan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Maka, sabalum hal itu tajadi/bajadian nang itu, buhan ikam jangan sampai gair sambil baucap, ‘Napa nang musti kusambat gasan mambela diri?’ ");
INSERT INTO bjn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sualnya Aku saurang nang maulah ikam supaya kawa bapandir lawan kata-kata nang bijak, sampai musuh-musuh ikam kada kawa malawan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bahkan kuitan ikam, dangsanak ikam, wan kakawalan ikam cagar mahianati ikam. Banyak bubuhan ikam cagar dimati'i ulih musuh-musuh bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sabarataan urang mamuari ikam lantaran ikam tamasuk pangikutKu. ");
INSERT INTO bjn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Biar nang kaya itu, jangan sampai gair. ");
INSERT INTO bjn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Amun ikam tatap batahan dalam kasusahan nang itu, maka ikam cagaran baulihi hidup nang kakal.” ");
INSERT INTO bjn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Wayah bubuhan ikam malihat kuta Yarusalem dikapung ulih tantara-tantara musuh, katahuilah bahwa sudah wayahnya kuta nang itu cagar dihancurakan. ");
INSERT INTO bjn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pas wayah nitu, urang nang masih ada di propinsi Yudea musti bajauh tulak ka pagunungan. Lalu nang ada di dalam kuta Yarusalem musti lakas bajauhan pada kuta nang itu. Lalu nang ada di luar kuta, janganlah babulik lagi ka kuta. ");
INSERT INTO bjn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lantaran itulah Allah cagar mahukum kajahatan urang nang ini, supaya samunyaan tulisan nabi-nabi tadahulu manganai hukuman nang itu dilaksanaakan. ");
INSERT INTO bjn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Wayah bancana nang itu tajadi, kasihan banar acil-acil nang lagi batianan dan nang lagi manyusui anak! Bubuhannya cagaran mandarita banar lantaran ngalih malariakan diri. Hukuman Allah kaina barat banar gasan sabarataan panduduk nargi nang ini. ");
INSERT INTO bjn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Banyak nang cagar dibunuh pakai pedang. Banyak jua nang ditawan lalu dibawa ka banua-banua nang lain. Lalu urang-urang nang itu kaina manguasai kuta Yarusalem sampai waktu nang sudah ditakdirakan ulih Tuhan.” ");
INSERT INTO bjn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kaina di matahari, wan bulan wan bintang-bintang, kalihatan ciri-cirinya. Manusia barataan nang ada di bumi katakutanan wan kabingungan mahadapi hamukan laut. ");
INSERT INTO bjn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Manusia cagaran abut/panik wan siupan mahadapi napa-napa nang tajadi di dunia nang ini, sabab banda-banda nang ada di langit baguncangan. ");
INSERT INTO bjn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Rahatan nitu am, Aku, Nang Datang Matan Di Surga, turun di awan nang liwar tarangnya. Lalu Aku bakuasa atas sabarataan urang. ");
INSERT INTO bjn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wayah hal nang itu tajadi, buhan ikam himunglah wan parcaya ja. Sualnya satumat lagi bubuhan ikam Kusalamatakan barataan.” ");
INSERT INTO bjn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Lalu Nabi Isa maungkai pulang kisah nang ini, “Itihi ja puhun ara atawa pohon apa haja. ");
INSERT INTO bjn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amun malihat puhun tu bamula bakambang, kada lawas lagi pacangan babuah. ");
INSERT INTO bjn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kaya itu jua, amun ikam malihat ciri-ciri tu ada, kada lawas lagi tu Allah mandiriakan karajaan-Nya di bumi. ");
INSERT INTO bjn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nah, dangarakanlah barataan. Wayah samunyaan ciri nang itu tajadi, manusia di jaman nang ini masih hidup. ");
INSERT INTO bjn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit wan bumi cagaran hilang. Tapi samunyaan nang sudah Kupadahakan kada baubah.” ");
INSERT INTO bjn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Baingat-ingatlah bubuhan ikam ni! Jangan sampai talalu asyik bararamian wan mabuk-mabukan, wan jangan sampai gair tarus masalah kahidupan sahari-hari. Jangan sampai baluman batobat wan baluman siap gasan Hari Kiamat! ");
INSERT INTO bjn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sualnya hari nang paampihan nang itu datangnya bakakajutan manimpa sabarataan manusia nang di bumi nang ini. ");
INSERT INTO bjn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Maka, baingat-ingatlah bubuhan ikam ni! Badoa ja saban hari sakira ikam kawa batahan wan tabebas dari samuaan hal tadi nang cagar tajadi. Ikam musti basiap-siap gasan kadatangan-Ku supaya Aku himung lawan ikam dan supaya ikam kada supan awan diaku wayah Aku datang pulang ka dunia nang ini. ");
INSERT INTO bjn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Saban hari pada minggu nang itu, Nabi Isa tulak bacaramah di Bait Allah, dan malam harinya Sidin tulak gasan guring di Bukit Zaitun. ");
INSERT INTO bjn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Imbah itu, baisukan banar urang-urang datang ka Bait Allah handak mandangarakan caramah Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wayah itu, parayaan hari raya Ruti Kada Baragi nang disambat Paskah sudah parak wayahnya. ");
INSERT INTO bjn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Imam-imam kapala wan guru-guru agama parahatan barundingan mancari akal kaya apa caranya handak mamatiꞌi Nabi Isa. Sualnya bubuhannya takutan kalu pina tajadi karusuhan wayah rakyat malihat Nabi Isa ditangkap ulih bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yudas Iskariot tamasuk saikung/saurang dari dua balas pangikut Nabi Isa. Yudas dirasuki/dimasuki Iblis wan inya bahianat wan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Imbah itu, Yudas mandatangi imam-imam kapala wan kapala-kapala panjaga kaamanan Bait Allah gasan marundingakan/barunding kaya apa caranya pamuka-pamuka/tokoh-tokoh agama kawa manangkap Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bubuhannya himung banar Yudas hakun bahianat. Lalu bubuhannya bajanji maunjuki/mambari duit lawan Yudas sabagai imbalannya. ");
INSERT INTO bjn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Inya akur haja lawan mancari waktu nang baik gasan maunjuk Nabi Isa pada tokoh-tokoh agama sakira kada katahuan urang banyak. ");
INSERT INTO bjn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lalu sampai ai harinya Parayaan Hari Raya Ruti Kada Baragi nang wayah itu hewan korban wajib disumbalih gasan dimakan. Lalu Nabi Isa mandatangi Pitrus wan Yahya wan baucap, ");
INSERT INTO bjn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","“Pitrus ikam badua lawan Yahya tulakan ja basasadi makanan gasan Aku wan sabarataan pangikutKu gasan marayaakan Paska.” ");
INSERT INTO bjn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Di mana garang Pian handak kami manyiapakannya kaina?” ujar nang badua tu batakun. ");
INSERT INTO bjn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nabi Isa baucap, “Wayah ikam masuk ka kuta kaina ikam badua malihat ada saurang/saikung lalakian nang mambawa sabuah kandi nang baisi banyu. Umpati ja urang tu masuk ka rumahnya. ");
INSERT INTO bjn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lalu ucapakan ka ampun rumah, ‘Guru manyuruh kami batakun. Di mana yu tempatnya nang cagar dipakai Sidin wan pangikut-pangikut Sidin gasan makan makanan Paska? Kawalah kami umpat malihat?’ ");
INSERT INTO bjn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Maka si ampun rumah/nang ampun rumah manampaiakan tempat nang legar di loteng nang sudah langkap parabotannya. Siapakan ja samunyaan makanan di situ.” ");
INSERT INTO bjn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Lalu tulakan ai buhannya badudua. Samunyaan nang didapati bubuhannya pas banar lawan napa nang dipadahakan/disambat Nabi Isa tadi. Lalu disiapakan bubuhannya ai samunyaan nang diparluakan. ");
INSERT INTO bjn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lalu, wayah Hari Raya Paskah, Nabi Isa lawan pangikut-pangikut Sidin makanan basama-basama di atas loteng tadi. ");
INSERT INTO bjn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","“Aku handak banar makan makanan Paskah ini basama-basama wan bubuhan ikam sabalum Aku mandarita. ");
INSERT INTO bjn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Parcaya ja! Aku kada makan nang kaya ini lagi sampai arti parayaan Paska ini manjadi nyata wan dirayaakan dalam Karajaan Allah” ujar Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Imbah itu Sidin maambil cawan, maucap sukur lalu baucap, “Ambil nah, lalu kinum ja banyu anggur ni bagantian. ");
INSERT INTO bjn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Parcaya ja! Aku kada manginum/tanginum lagi pang banyu anggur lagi sampai Karajaan Allah datang. ");
INSERT INTO bjn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Imbah itu, Sidin maambil sabuting ruti, maucap sukur, disibit-sibit Sidin lalu dibagiakan ka bubuhannya. “Ruti nang ini malambangakan/sabagai lambangawak-Ku nang Kusarahakan gasan bubuhan ikam. Jadiakan kabiasaan nang ini gasan mangganang wapatnya Aku!” ");
INSERT INTO bjn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nang kaya itu jua, imbah makanan, diambil Sidin sabuting cawan nang baisi banyu anggur lalu baucap, “Banyu anggur nang ini malambangakan/sabagai lambang parjanjian nang hanyar matan Allah gasan manusia. Parjanjian itu disahakan lawan darahku nang pacang dicucurakan gasan bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tapi buhan ikam tahulah, nang cagaran mahianati aku, urangnya ada lawan kita di sini. ");
INSERT INTO bjn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sabujurnya Nang Datang Matan Di Surga, cagaran mati kaya nang ditakdirakan Allah. Tapi cilaka tu pang nang mahianati Inya,” ujar Nabi Isa manutup panjalasan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","“Siapa yulah urangnya nang wani mahianati Sidin?” ujar bubuhan pangikut Sidin batakun-takun lawan papadaannya saurang. xxxxxxxxx ");
INSERT INTO bjn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Imbah itu, bubuhannya bamula bahualan manganai siapa nang dianggap paling tahurmat/cagaran dituhaakan. ");
INSERT INTO bjn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lalu Nabi Isa baucap, “Raja-raja urang-urang manyiksa rakyaknya. Tapi rakyaknya tu disuruhnya bapadah panguasanya tu ‘pambela rakyat.’/panguasannya tu malindungi ” ");
INSERT INTO bjn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","“Tapi jangan bakalakuan nang kaya itu. Amun handak dihurmati urang musti bakalakuan nang kaya urang anum sualnya urang nang anum tu bakawajiban malayani nang tuha-tuha. Nang handak manjadi tuan samustinya malayani nang kaya palayan. ");
INSERT INTO bjn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Siapa nang labih tahurmat? Nang dilayanikah atawa nang malayani? Nyata ay nang dilayani! Tapi wayah ini, Aku nang malayani bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bubuhan ikam ni pang nang tatap satia wan Aku wayah Aku maalami kasusahan/Aku tapiasat. ");
INSERT INTO bjn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nang kaya AbahKu Nang Di Atas mambari kuasa lawan Aku gasan mamarintah dalam karajaan-Ku, nang kaya itu jua Aku mambari kuasa lawan bubuhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Bubuhan ikam kaina kawa makan wan nginum samija lawan Aku di dalam karajaanKu. Bubuhan ikam cagaran duduk di atas takhta gasan mamarintah lawan Aku kadua balas suku juriat Nabi Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nabi Isa baucap lawan Simun Pitrus, “Simon! Simon! Tahulah ikam Iblis cagaran mauji bubuhan ikam? Iblis handak mangguda bubuhan ikam supaya bubuhan ikam kada baiman lagi wan Aku. ");
INSERT INTO bjn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tapi Aku sudah mandoaakan ikam/badoa gasan ikam supaya jangan murtad. Imbah ikam batobat, kuatakan/ingatakan dangsanak-dangsanak ikam nang saiman.” ");
INSERT INTO bjn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","“Junjungan, ulun siap dipanjaraakan wan ulun siap mati gasan Pian!” ujar Pitrus manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Tiga kali ikam cagar bakulim manjadi pangikutKu sampai hayam bakungku'uk/batangku'uk” ujar Nabi Isa bahimat. ");
INSERT INTO bjn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","“Wayah bubuhan ikam disuruh tulakan bacaramah, kada disangui napa-napa, kakurangan lah?” ujar Nabi Isa manakuni bubuhan pangikut Sidin. “Kada! Asanya kada pang!” ujar bubuhannya manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Tapi wayah ini, amun bubuhan ikam baisian ipok atawa kadut, dibawa haja. Amun bubuhan ikam kada baisian pedang, baju dijuali gasan manukarnya. ");
INSERT INTO bjn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sualnya samunyaan musti tajadi nang kaya ditulisakan bubuhan nabi dahulu, tamasuk tulisan nang ini: ‘Inya pacang dianggap nang kaya panjahat.’ Nang tatulis tantang Aku tadi pacang jadi nyata,” ujar Nabi Isa manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Anu Junjungan ai! Ini nah dua bilah padang!” “Sudah gin” ujar Nabi Isa manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nabi Isa wan pangikut-Nya tulakan matan kuta Yarusalem ampah ka Bukit Zaitun nang kaya rajin. ");
INSERT INTO bjn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pas sampai di sana, Sidin baucap, “Bubuhan ikam, badoa taruslah supaya jangan baulah dusa wayah digudai Iblis.” ");
INSERT INTO bjn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Imbah itu, Nabi Isa bajauh kira-kira sajauh tawakan batu. Imbah itu, Sidin balutut lalu badoa. ");
INSERT INTO bjn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Abah, amun Pian hakun, jauhakan siksaan nang pacang ulun tanggung. Tapi jangan kahandak ulun nang jadi. Tapi kahandak Pian haja nang jadi,” ujar Nabi Isa badoa ka Allah. ");
INSERT INTO bjn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Parahatan Sidin badoa, datang malaikat matan surga manguatakan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sidin bujuran mandarita sacara batin sampai Sidin badoa magin husu. Paluh Sidin bacampur darah lalu batitikan ka batu. ");
INSERT INTO bjn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Imbah tuntung badoa, Nabi Isa babulik ka pangikut Sidin. Sakalinya bubuhannya taguringan, kauyuhan lantaran sadih. ");
INSERT INTO bjn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nabi Isa baucap, “Jangan guringan! Bangunan barataan! Badoa tarus supaya ikam jangan baulah dusa wayah digudai ulih Iblis.”. ");
INSERT INTO bjn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wayah itu sudah landung malam. Sagalumukan urang mandatangi Nabi Isa di Bukit Zaitun. Wayah itu, Sidin bapandiran lawan pangikut Sidin. Bubuhannya tadi dipimpin ulih Yudas nang dahulunya pangikut Sidin. Nabi Isa diparakinya, lalu diciumnya. ");
INSERT INTO bjn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nabi Isa baucap, “Yudas, ikam purun banar mahianati Nang Datang Matan Di Surga, apalagi lawan ciuman bakakawalan.” ");
INSERT INTO bjn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pas malihat kajadian nang itu, bubuhan pangikut Sidin hanyar paham bahawa Nabi Isa satumat lagi handak ditangkap. “Guru, biar kami haja nang malawaninya!” ujar bubuhan pangikut Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lalu saikung pangikut Sidin langsung mahantam kapada/saikung hamba katua imam-imam. Talinga kanan urang tu ditataknya. ");
INSERT INTO bjn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","“Ampih ja ikam mahantam!” ujar Nabi Isa managur pangikut Sidin tadi. Lalu dijapai Sidin talinga urang tadi. Langsung waras. ");
INSERT INTO bjn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nang dibawa Yudas ka sana adalah imam-imam, panjaga-panjaga kaamanan Bait Allah, wan tatuha-tatuha agama. Bubuhannya datangan gasan manangkap Nabi Isa. Nabi Isa baucap wan bubuhannya, “Aku ni lain panjahat. Kada usah mambawa parang wan pamangkung! ");
INSERT INTO bjn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Saban hari, Aku ada lawan bubuhan ikam di Bait Allah. Tapi bubuhan ikam, kadada nang handak manangkap Aku. Tapi hanyar am ini, wayah landung malam, bubuhan ikam manangkap Aku sakakahandak hati ikam haja, sualnya Iblis sudah manguasai ikam barataan.” ");
INSERT INTO bjn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lalu Nabi Isa ditangkap urang, lalu dibawa masuk ka rumah imam basar. Sanunuhan Pitrus maumpati, inya maumpati matan jauh haja. ");
INSERT INTO bjn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Di patangahan halaman rumah imam basar, ada api nang ganal nang sudah dilikitakan. Bubuhannya dudukan mahangatakan awak di sakulilingnya. Sakalinya Pitrus umpat jua lawan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Saikung hamba babinian malihat Pitrus nang hanyar duduk parak api nang ganal tadi. Inya maminandui Pitrus lalu baucap, “Asanya urang nang ini pangikut Sidin.” ");
INSERT INTO bjn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","“Lain aku Bu ay! Aku kada patuh wan Sidin” ujar Pitrus bakulim. ");
INSERT INTO bjn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kada lawas imbah itu, ada pulang nang pinandu lawan Pitrus, lalu baucap, “Ikam gin pangikutnya.” “Bah! Lain Aku Pa ay!” ujar Pitrus bakulim pulang. ");
INSERT INTO bjn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kira-kira sajam limbah nitu, ada pulang nang mamaraki Pitrus. “Dasar bujur urang nang ini pangikut Sidin sualnya inguhnya kaya urang Galilea” ujarnya banyaring. ");
INSERT INTO bjn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Kada, ikam tu dasar salah!” ujar Pitrus bakulim pulang. Tapi pas wayah Pitrus lagi bapandir tadi, saikung hayam bakungkuꞌuk. ");
INSERT INTO bjn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Imbah tu, Nabi Isa manulih lawan Pitrus. Hanyar Pitrus kaingatan napa-napa nang diucapakan Nabi Isa samalam, “Talu kali ikam cagar bakulim jadi pangikutku. Hanyar, hayam cagar bakungkuꞌuk” ");
INSERT INTO bjn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Imbah itu kaluar ai Pitrus lalu manangis lantaran basadih banar. ");
INSERT INTO bjn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Imbah itu, urang-urang nang manahan/manangkap Nabi Isa bamula mahulut-hulut Sidin lawan mamukuli/mamupuhi Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mata Sidin ditukupinya. Lalu bubuhanya minta tangguh, “Tangguhi pang! Siapa garang nang mamukuli/mamupuhi ikam?” ");
INSERT INTO bjn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lalu Sidin dihina/diwada tarus ulih bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wayah parak subuh, imam-imam, guru-guru agama, wan tatuha-tatuha agama bakumpulan. Nabi Isa dihirit ka hadapan Mahkamah Agama. ");
INSERT INTO bjn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Bujurlah ikam ni Al Masih?” ujar bubuhan hakim batakun. Nabi Isa manyahut, “Amun Ulun bapadah Ulun ni Al Masih, pian gin kada parcaya jua/kada parcaya jua pian. ");
INSERT INTO bjn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Amun Ulun batakun wan pian, ‘Kanapa maka pian kada parcaya?’, musti pian badiam/baranai haja. ");
INSERT INTO bjn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tapi kaina Nang Datang Matan Di Surga duduk batatai di subalah kanan Allah nang bakuasa.” ");
INSERT INTO bjn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lalu bubuhannya batakun pulang, “Amun kaya itu, ikam ni bujuran kah Anak Nang Di Atas?” “Inggih. Bujur tu nang pian sambat tadi” ujar Nabi Isa manyahut/manyahuti pulang. ");
INSERT INTO bjn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Nah! Amun kaya itu, kita samunyaan sudah mandangarnya. Kita kada parlu saksi lagi gasan mambuktiakan Inya tu basalah. Inya maakuinya/maakui saurang. Sadang sudah! Inya ni dimatiꞌi haja lantaran mahujat Allah!” ujar bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lalu badirianay bubuhan hakim Mahkamah Agama nitu. Lalu Nabi Isa dihadapakan ka Hupnor Pilatus. ");
INSERT INTO bjn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bubuhannya baucap ka Hupnor Pilatus, “Kami mandapati urang ini manyasatakan ka? rakyat. Inya manangati urang-urang mambayar/mambayari pajak lawan karajaan Roma. Inya mangaku dirinya/bahwa inya ni Al Masih, nang baarti Raja juriat Nabi Ibrahim!” ");
INSERT INTO bjn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","“Raja? Bujurankah Ikam ni raja juriat Nabi Ibrahim?” ujar Hupnor Pilatus manakuni Nabi Isa. “Inggih. Bujuray, tuanay” ujar Nabi Isa manyahut. ");
INSERT INTO bjn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","“Kadada alasan Aku mahukum Inya” ujar Hupnor Pilatus lawan imam-imam kapala wan urang banyak nang sudah bakumpul di situ. ");
INSERT INTO bjn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","“Inya ni pang nang maulah tumbur di saluruh daerah Yudea, mulai di Galilea sampai ka sini” ujar bubuhannya bakarasan. ");
INSERT INTO bjn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Galilea? Inya ni urang Galilea? ");
INSERT INTO bjn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Amun kaya itu, anjurakan ja inya ka Hirudis sualnya Galilea tu dibawah kakuasaan Hirudis. Lawan pulang wayah ini Hirudis masih di Yarusalem jua” ujar Hupnor manyahuti musuh-musuh Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hirudis sudah rancak banar mandangar tantang Nabi Isa lawan mujijat-mujijat Sidin. Maka wayah/waktu maliat Nabi Isa, Hirudis himung banar lantaran sidin sudah lawas handak malihat langsung mujijat Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nabi Isa ditakuni tarus ulih Hirudis, tapi Sidin bahinip haja. ");
INSERT INTO bjn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wayah itu, imam-imam kapala lawan guru-guru agama baparak lalu manuduhi Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Imbah Hirudis wan tantaranya tuntung mahina/mawada wan mahuluti Nabi Isa, Hirudis manyuruh anak buahnya mamurukakan jubah nang bagus ka bahu Nabi Isa. Jadi masih mamakai jubah tu, Sidin dihadapakan pulang ka Hupnor Pilatus. ");
INSERT INTO bjn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hari nang itu jua, Hirudis wan Pilatus jadi bakawal padahal sabalumannya nang badua tu bamusuhan/bamusuh. ");
INSERT INTO bjn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Imbah itu, Hupnor Pilatus mangumpulakan imam-imam kapala, hakim-hakim Mahkama Agama, wan rakyat lalu sidin bacaramah. ");
INSERT INTO bjn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Bubuhan ikam mambawa urang ini ka hadapan aku wan manuduh inya manyasatakan urang. Tadi, sudah kupariksa dihadapan bubuhan ikam. Tagal kadada alasan Aku mahukum Inya. ");
INSERT INTO bjn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nang kaya itu jua/pulang pandapat Hirudis sualnya Inya dihadapakannya pulang ka aku. Ingatakan ja, urang ini kada pantas amun dihukum mati. ");
INSERT INTO bjn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jadi, Inya ni kucambuki haja. Lalu, kulapas” ujar Pilatus manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Saban tahun, wayah hari raya Paskah, Hupnor Pilatus biasanya mambibasakan saikung/saurang tahanan gasan bubuhan juriat Nabi Ibrahim. ");
INSERT INTO bjn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Urang banyak tu sudah bakumpulan di situ. Lalu bubuhannya baucap, “Matiꞌi ja Inya. Lapasakan si Barabas gasan kami!” ");
INSERT INTO bjn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas sudah dipanjaraakan lantaran mambunuh urang lawan maulah tumbur di kuta. ");
INSERT INTO bjn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","“Urang nang ini kada basalah,” ujar Pilatus baucap sakira kawa malapasakan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","“Matiꞌi ja Inya di kayu bapalang! Matiꞌi ja Inya di kayu bapalang!” ujar bubuhannya kuciakan. ");
INSERT INTO bjn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","“Napa garang kasalahan Inya?” ujar Pilatus batakun, “Urang nang ini kada pantas amun dihukum mati. Jadi, Inya kucambuki haja. Lalu, kulapas.” ");
INSERT INTO bjn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tagal bubuhannya kuciakan pulang sing nyaringan mamaksa Pilatus sakira mahukum mati Nabi Isa. Kaputingannya kahandak bubuhannya nang manang. ");
INSERT INTO bjn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jadi Pilatus mamutusakan gasan manulusakan kahandak bubuhannya tadi, gasan mahukum mati Nabi Isa wan ");
INSERT INTO bjn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","mambibasakan si Barabas tadi. Imbah itu, Nabi Isa disarahakan/diunjuk ka anak buah Pilatus gasan dimatiꞌi. ");
INSERT INTO bjn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Imbah Nabi Isa dicambuki, Sidin dibawa handak dimatiꞌi. Prajurit-prajurit malihat Simun, urang Kirene, nang hanyar handak masuk kuta. Simun tu ditahan lalu disuruh manyahan kayu bapalang tu mairingi Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Banyak banar urang nang umpat mairingi Nabi Isa tamasuk babarapa ikung babinian. Babinian-babinian nang itu manangisi wan maratapi Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lalu, Nabi Isa manulih ka bubuhannya wan baucap, “Babinian Yarusalem. Aku kada usah ditangisi. Tangisi haja diri ikam saurang wan anak-anak buhan ikam. ");
INSERT INTO bjn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sualnya kaena Allah mahukum kuta nang ini. Lalu, wayah itu, urang cagar baucap, ‘Bauntunglah babinian-babinian nang kada suah batianan, wan nang kada suah baranak wan jua nang kada suah manyusui anak!’ ");
INSERT INTO bjn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bila tajadi bancana/bala kasusahan nang barat banar nang itu, panduduk daerah ini cagaran baucap, ‘Hai gunung-gunung wan bukit-bukit, runtuhlah wan timbuni ja kami!’ ");
INSERT INTO bjn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sualnya amun urang nang saleh gin marasai hukuman Allah, maginnya ai/apalagi urang nang badusa/jaba.” ");
INSERT INTO bjn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ada dua ikung urang lain nang dibawa baimbai lawan Nabi Isa nang handak dimatiꞌi jua. Kaduduanya tu panjahat. ");
INSERT INTO bjn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pas sampai di bukit Tangkurak, tangan wan batis Sidin dipakui di kayu bapalang. Kaya itu/Damintu jua kadua ikung panjahat tu. Saikung diandak subalah kanan. Nang saikungnya diandak disubalah kiwa Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nabi Isa badoa, “Abah, ampuniakan urang-urang nang mamatiꞌi Ulun ni. Sualnya bubuhannya tu sabujurannya kada tahu napa nang digawinya tu.” Lalu prajurit-prajurit nang itu mambagiakan baju-Nya lawan cara baundi. ");
INSERT INTO bjn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Urang banyak tu badiri wan manyaksiakan samunyaan kajadiannya. Sadangkan pamuka-pamuka agama mahuhuluti/mahulut-huluti Sidin sambil baucap, “Urang lain Inya kawa salamatakan. Amun inya bujur-bujur Al Masih nang dipilih wan diutus Allah, biar haja inya manyalamatakan dirinya saurang.” ");
INSERT INTO bjn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Prajurit-prajurit gin umpat mahuhuluti/mahulut-hulut jua. Banyu anggur nang masam ditawari lawan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Prajurit-prajurit tadi baucap, “Amun ikam Raja juriat Nabi Ibrahim salamatakan pang diri ikam saurang!” ");
INSERT INTO bjn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Di bahagian atas/Paatasan tihang kayu bapalang nang itu— yaitu di atas kapala Sidin, diandak tulisan nang ini: “Inilah Raja juriat Nabi Ibrahim.” ");
INSERT INTO bjn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","“Amun ikam tu Al Masih, salamatakan pang diri ikam saurang wan kami,” ujar panjahat nang di subalah Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tapi panjahat nang saikungnya managur. “Ikam tu dihukum mati,” ujarnya. “Ikam kada takutankah lawan Allah? ");
INSERT INTO bjn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Amun nang kaya kita ni, pantas/wajar haja amun dihukum mati lantaran kita ni bujur-bujur basalah. Tapi Sidin ini kada basalah. Sabujurannya Sidin ni kada dihukum mati nang kaya kita ni” ujarnya manjalasakan ka pajahat nang saikungnya. ");
INSERT INTO bjn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lalu panjahat nang itu baucap ka Sidin, “Nabi Isa, ganang ulun lah, wayah Pian mamarintah kaina sabagai Raja di dalam Karajaan Allah!” ");
INSERT INTO bjn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nabi Isa manyahuti, “Sabujurannya hari ini jua, ikam cagar baada di surga Firdaus basama-sama lawan Aku.” ");
INSERT INTO bjn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wayah itu, kira-kira pukul dua balas siang, harinya bakakajutan kadap hari di saluruh banua tu sampai pukul tiga kamarian. ");
INSERT INTO bjn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sualnya matahari kada timbul cahayanya. Lalu kain pahalat Bait Allah tabalah dua. ");
INSERT INTO bjn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lalu Nabi Isa badoa lawan suara nyaring, “Abah, lawan Pian, Ulun sarahakan panyawaan Ulun.” Imbah itu, Sidin langsung wapat. ");
INSERT INTO bjn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wayah malihat kajadian nang itu tadi, kapala prajurit nang ada di situ mamuji Allah sambil baucap, “Dasar bujur urang nang ini urang nang saleh.” ");
INSERT INTO bjn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Imbah malihat wapatnya Nabi Isa, urang banyak bulikan wan basadih banar. ");
INSERT INTO bjn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tapi sabarataan kakawalan Nabi Isa, tamasuk babinian-babinian nang maumpati Sidin matan banua Galilea, manyaksiakan dari jauh samunyaan kajadian-kajadian nang itu. xxxxxxxxx ");
INSERT INTO bjn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ada saikung urang matan kuta Arimitia di banua Yudea nang bangaran Yusup. Yusup tu, urangnya saleh wan takwa. ");
INSERT INTO bjn_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Sidin lagi mahadangi kadatangan karajaan Allah. Biar sidin angguta Makamah Agama, sidin kada akur lawan kaputusan Makamah tu gasan mambunuh Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jadi sidin mainta ijin lawan Hupnor Pilatus gasan manguburakan/mamatak mayat Nabi Isa. Lalu, diijinakan ai ulih Hupnor Pilatus. ");
INSERT INTO bjn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mayat Nabi Isa diturunakan di kayu bapalang. Lalu, dikafaninya nang kaya adat juriat Nabi Ibrahim, lalu dirabahakan ka/di dalam guha batu ulahan nang ditabuk gasan kuburan. Urang lain kada suah dikuburakan/dipatak di situ. ");
INSERT INTO bjn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Samunyaan nang ini dilakuakan pada hari Jumahat kamarian, artinya hari parsiapan. Sualnya hari Sabat sudah parak. ");
INSERT INTO bjn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Babinian-babinian nang datang di banua Galilea, umpat jua lawan Yusup, lalu malihat kuburan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Imbah itu bubuhanya bulikan lalu manyiapakan rarampahan wan banyu wangi/minyak harum gasan maminyaki/mamaliti mayat Nabi Isa. Pas tuntung basiap-siap gasan hari Sabat, bubuhannya baistirahat lantaran manaati hukum agama. ");
INSERT INTO bjn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Talu hari imbah hari wapatnya Nabi Isa, yaitu hari Ahad, baisukan banar, bubuhan babinian tulakan mambawa rarampahan handak manjiarahi kuburan Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tapi, pas sampai di sana, dilihat/dilihati bubuhannya batu panutup kuburan sudah taguling. ");
INSERT INTO bjn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lalu masuk ka dalamay bubuhannya. Dilihatinya/Dilihati bubuhannya, sakalinya mayat Nabi Isa sudah kadada lagi di situ/sana. ");
INSERT INTO bjn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Asa bingung ai bubuhannya pas taungut kahilangan mayat Nabi Isa. Sakalinya, bakakajutan badiri dua ikung lalakian di parak bubuhannya. Baju kaduduanya mancarunung barasih banar/liwar barasihnya. ");
INSERT INTO bjn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lantaran katakutanan, bubuhan babinian tadi basujut lawan kadua urang tu/Imbah itu, bubuhannya katakutanan lalu basujut lawan kadua urang tu. “Kanapa/Nang apa bubuhan ikam mancari urang nang hidup di wadah/tempat urang mati?” ujar dua ikung lalakian tadi batakun. ");
INSERT INTO bjn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“Sidin kadada lagi disini. Sidin sudah hidup pulang. Kada ingat kah pandiran/pamandiranSidin dahulu, wayah takumpul wan bubuhan ikam di banua Galilea: ");
INSERT INTO bjn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Nang Datang Matan Di Surga cagaran diunjuk/disarahakan ka urang Roma, lalu dimatiꞌi di kayu bapalang. Tagal imbah talu hari, Sidin cagaran hidup pulang,’” ujar lalakian tadi. ");
INSERT INTO bjn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lalu taingat ai bubuhan babinian/Lalu bibinian-bibinian taingat/kaganangan wan pandiran/pamandiran Nabi Isa nang dahulu tu. ");
INSERT INTO bjn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lalu babulik bubuhannya/bubuhannya babulik ka kuta Yarusalem handak mangisahakan samunyaan kajadian tadi lawan kasawalas pangikut Nabi Isa lawan dangsanak saiman nang lain nang sudah takumpulan di situ. ");
INSERT INTO bjn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Babinian tadi nang mangisahakan habar tadi adalah Maryam dari Magdalena, Yuhana, Maryam nang umanya Yakub wan babinian lain nang umpat jua. ");
INSERT INTO bjn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tapi bubuhan pangikut Sidin nang mandangar kisah tadi kada parcaya. Kisah bubuhan bibinian tu dianggapnya kisah karamput haja. ");
INSERT INTO bjn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Biar nang kaya itu, Pitrus badadas bangun lalu tulak bukah ka kuburan. Imbah babungkuk, inya bajinguk ka dalam. Tapi kain kafanNya haja nang talihat di situ. Hiran banar Pitrus lalu bulik batakun dalam hati napa nang tajadi. ");
INSERT INTO bjn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ada dua ikung pangikut Nabi Isa lagi bajalan/tulakan baampah ka kampung Emaus/ka sabuah kampung nang bangaran Emaus, sabalas pal jauhnya matan kuta Yarusalem. ");
INSERT INTO bjn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wayah di jalan, kaduduanya tu bapapandiran/bapandiran/mamandirakan manganai/tentang wapatnya Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lalu bakakajutan Nabi Isa umpat baimbai bajalan wan kadua urang tu. ");
INSERT INTO bjn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bubuhannya maliatay lawan Sidin. Tagal asa ada sasuatu nang mahalangi panglihatan bubuhannya sampai bubuhannya tu kada pinandu wan Sidin. ");
INSERT INTO bjn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","“Nang apa/apang nang bubuhan ikam pandirakan tadi?” ujar Sidin batakun. Lalu bubuhannya bamandak. Muha bubuhannya kalihatan sadih. ");
INSERT INTO bjn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","“Bujurlah/bujuranlah ikam kada tahu-manahu/kada tahu sama hama napa-napa nang sudah tajadi di kuta Yarusalem manganai Nabi Isa?” ujar Kleopas saikung pada bubuhannya batakun ka Nabi Isa. ");
INSERT INTO bjn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Paristiwa/Kajadian napa/napang garang nang sudah tajadi?” ujar Nabi Isa balas batakun. “Paristiwa-paristiwa/Kajadian/kajadian tantang Nabi Isa matan kuta Nasaret” bubuhannya manjawab. “Sidin saurang Nabi. Sidin bapandir bawibawa. Lawan Sidin rancak manampaiakan/manunjukakan mujijat. ");
INSERT INTO bjn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tapi Sidin sudah ditangkap ulih imam-imam kapala wan pamimpin-pamimpin/pamimpin kami. Lalu Sidin disarahakan/diunjuk ka panguasa Roma gasan dihukum mati. Imbah itu Sidin dimatiꞌi. ");
INSERT INTO bjn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sabalum wapatnya, kami maharapakan Sidin kawa mambibasakan kami yaitu juriat Nabi Ibrahim matan musuh-musuh kami. Lawan pulang, sudah talu hari kajadian nang itu. ");
INSERT INTO bjn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kami gin takajut banar/jua lantaran ada babarapa ikung babininan di kulumpuk kami nang umpat manjiarahi ka kuburan Sidin baisukan tadi. ");
INSERT INTO bjn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tapi mayat sidin sudah kadada lagi. Bubuhannya babulik lalu mamadahi kami ada malaikat-malaikat di situ nang baucap bahwa Nabi Isa sudah hidup pulang. ");
INSERT INTO bjn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lalu babarapa kakawalan kami nang umpat jua manjiarahi mambuktiakan kabujurannya. Sakalinya pandiran babinian tu bujur barataan. Kuburan Sidin puang. Mayat Nabi Isa kadada lagi!” ");
INSERT INTO bjn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","“Wah! kanapa/nang apang bubuhan ikam ngalih banar mamaham nang sudah tatulis/ditulisakan nabi-nabi nang tadahulu?! ");
INSERT INTO bjn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Allah sudah mambuktiakan apa-apa nang ditulis bubuhan nabi nang tadahulu bahwa Al Masih musti maalami samunyaan pandaritaan nang itu, hanyar dimuliaakan” ujar Sidin pina sadih. ");
INSERT INTO bjn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Maka bamula lawan Kitab Suci Taurat sampai tulisan nabi-nabi nang tadahulu, Sidin manjalasakan isi samunyaan Pirman Allah manganai diri Sidin saurang. ");
INSERT INTO bjn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sampai di kampung tujuannya, Nabi Isa handak tarus haja bajalan. ");
INSERT INTO bjn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tapi bubuhannya manahan/manahani Sidin. “Bamalam/Guring di rumah kami haja gin! Parak magrib sudah!” ujar bubuhannya ka Sidin. Maka Nabi Isa hakunay basinggah bamalam/guring di situ lawan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pas wayah makanan lawan bubuhannya, Sidin maambil ruti wan baucap sukur/basukur atasnya. Ruti tu disibit-sibit Sidin lalu dijulung ka bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wayah nitu am bubuhannya hanyar pinandu Sidin tu bujur-bujur Nabi Isa. Tapi pas wayah nitu jua, Nabi Isa kada talihat lagi baada di situ/bahilang. ");
INSERT INTO bjn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bubuhannya bapandir papadaan, “Hati kita basamangat banar di jalan tadi wayah Sidin manarangakan Kitab Suci lawan kita!” ");
INSERT INTO bjn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Walaupun sudah malam, bubuhannya badadas tulakan ka kuta Yarusalem mandapati nang kasawalas pangikut Sidin lawan dangsanak saiman nang lagi bakumpulan. ");
INSERT INTO bjn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“Junjungan kita nang ilahi sudah hidup pulang! Sakalinya, Sidin sudah manampaiakan diri Sidin lawan Simon!” ujar bubuhannya nang di Yarusalem baucap ka dua ikung urang tadi nang hanyar datang. ");
INSERT INTO bjn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lalu kaduanya nang hanyar datang itu bakisah jua samunyaan nang hanyar tajadi di jalan lawan nang kaya apa bubuhannya hanyar pinandu lawan Nabi Isa wayah Sidin manyibit-nyibit ruti tadi. ");
INSERT INTO bjn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wayah bubuhan pangikut Sidin lagi bapapandiran, Nabi Isa bakakajutan manampakakan diri/badiri di tangah-tangah bubuhannya. “Assalamu alaikum” ujar Sidin manyapa bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bubuhannya kabuliangan banar sualnya dikira hantu nang bapandir tadi. ");
INSERT INTO bjn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","“Kanapa/Nang apa bubuhan ikam ni gair? Kanapa/Nang apa jua maka bubuhan ikam masih ragu-ragu bahawa aku sudah hidup pulang?” ujar Nabi Isa batakun. ");
INSERT INTO bjn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Ini nah Aku! Itihi nah bakas luka paku/luka bakas paku di tanganKu wan di batisKu. Japai ja nyaman bubuhan ikam parcaya/yakin. Amun hantu, badaging wan kada batulang/kada harapan baisi daging atawa tulang nang kaya Aku ni!” ujar Sidin majalasakan pulang. ");
INSERT INTO bjn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wayah bapandir, Sidin manampaiakan tangan wan batis Sidin supaya kawa dilihati. ");
INSERT INTO bjn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bubuhannya tu masih manga lantaran kahimungan wan kahiranan. “Adalah baisian makanan di sini?” ujar Nabi Isa batakun. ");
INSERT INTO bjn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lalu dijulungiay sahiris iwak basanga. ");
INSERT INTO bjn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Lalu dimakan Sidin di hadapan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","“Sabaluman Aku dimatiꞌi, sudah kupadahakan lawan bubuhan ikam kajadian-kajadian nang sudah tatulis tantang Aku dalam Taurat, Zabur, wan kisah nabi-nabi. Nah, samunyaan paristiwa nang itu musti tajadi,” ujar Nabi Isa manjalasakan. ");
INSERT INTO bjn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lalu isi kitab-kitab nang itu dijalasakan Sidin pulang sakira bujur-bujur paham artinya/Lalu Sidin manjalasakan isi kitab-kitab nang itu sakira bujur-bujur paham artinya. ");
INSERT INTO bjn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Lalu Nabi Isa baucap, “Ini nah nang sudah tatulis di dalam Kitab Suci manganai Aku, 'Sasuai lawan kahandak Allah, Al Masih tu musti dimati'i. Tagal, talu hari imbah itu, dihidupakan pulang.' ");
INSERT INTO bjn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Habar nang ini musti ikam habarakan ka samuaan suku-suku: Amun urang batobat, baiman lawan Aku, samuaan dusanya diampuni, lalu inya dibibasakan dari hukuman dusanya. ");
INSERT INTO bjn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bubuhan ikam sudah manyaksiakan Aku disiksa wan dimatiꞌi tagal Aku/wan sudah hidup pulang. Makanya bubuhan ikam kusuruh mahabarakan nang ini. ");
INSERT INTO bjn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kaina Kuutus Ruh Kudus gasan bubuhan ikam. Maka bubuhan ikam tatap badiam haja di kuta Yarusalem sampai dilangkapi lawan kuasa Ruh Kudus tu gasan tugas ikam” ujar Nabi Isa manambahi. ");
INSERT INTO bjn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lalu Sidin mambawa bubuhannya matan kuta Yarusalem ka banua parak kuta Betani. Di situ, Sidin maangkat kadua tanganNya mambarakahi bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wayah Sidin mambarakahi bubuhannya, Sidin diangkat ka surga lalu ai tapisah wan bubuhannya. ");
INSERT INTO bjn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Imbah itu, bubuhannya basujut manyambah Sidin, lalu bulikan ka kuta Yarusalem lawan parasaan himung. ");
INSERT INTO bjn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lalu bubuhannya saban hari di Bait Allah mamuji Allah.");
ALTER TABLE bjn_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
