﻿USE sofia;
DROP TABLE IF EXISTS sofia.bjk_vpl;
CREATE TABLE bjk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bjk_vpl WRITE;
INSERT INTO bjk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ina na abo ese xöbo untubune Jisas nang a barok tubuno e Dewit, me Dewit ine a barok tubuno e Abaram. ");
INSERT INTO bjk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram ine a tamana e Aisak, me Aisak ine a tamana e Jekop, me Jekop ine a tamana e Juda arixe mabo tönö. ");
INSERT INTO bjk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda ine a tamana e Peres me Sira, nago re idu iang e Tamar, me Peres ine a tamana e Esron, me Esron ine a tamana e Ram. ");
INSERT INTO bjk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ine a tamana e Aminadab, me Aminadab ine a tamana e Nason, me Nason ine a tamana e Salom. ");
INSERT INTO bjk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salom ine a tamana e Boas ma a nago re ine iang e Rap. Boas ine ixo a tamana e Obet, ma nago re ine iang e Rut, me Obet ine a tamana e Jesi. ");
INSERT INTO bjk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ine a tamana e King Dewit. Me Dewit ine a tamana e Solomon, me nago re Solomon ixo une bang ke Uria. ");
INSERT INTO bjk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ine a tamana e Reobam, me Reobam ine a tamana e Abiya, me Abiya ine a tamana e Asa. ");
INSERT INTO bjk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ine a tamana e Josapat, me Josapat ine a tamana e Jeoram, me Jeoram ine a tamana e Usia. ");
INSERT INTO bjk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ine a tamana e Jotam, me Jotam ine a tamana e Aas, me Aas ine a tamana e Esekia. ");
INSERT INTO bjk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia ine a tamana e Manase, me Manase ine a tamana e Amon, me Amon ine a tamana e Josaia. ");
INSERT INTO bjk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Me Josaia a tamana e Jekonia mabo tönö xö ina axana bung nang toxo lamus inabo Israel uruo Babilon bara idi tabo kis singan xarnang abo osee. ");
INSERT INTO bjk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Melamu idi toxoro kis xarnang abo osee ro Babilon, Jekonia ine ixo tamana e Salatiel, me Salatiel ine a tamana e Serubabel. ");
INSERT INTO bjk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ine a tamana e Abiud, me Abiud ine a tamana e Eliakim, me Eliakim ine a tamana e Asor. ");
INSERT INTO bjk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ine a tamana e Sadok, me Sadok ine a tamana e Akim, me Akim ine a tamana e Eluid. ");
INSERT INTO bjk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eluid ine a tamana e Eleasor, me Eleasor ine a tamana e Matan, me Matan ine a tamana e Jekop. ");
INSERT INTO bjk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ine a tamana e Josep, a tödi re Maria nang ixo kip e Jisas, nang toxobo rengrengen ine me Krais. ");
INSERT INTO bjk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Io, a sangaun ma nit ne mexubu meringan te Abaram urungan te Dewit, ma a sangaun ma nit meringan te Dewit urungan kö bung toxo lamus a bung Israel urungan Babilon ma toxo kis ee xarnang abo osee. Ma sangaun ma nit bölök meringan urungan kö bung nang toxo kip a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A pii möxö bung nang toxo kip e Jisas Krais ixo urulo bira: A nago re ine e Maria toxoro tengen pi sik ine bara irabo ot tue Josep, ma lamun nang kaim bang idu ra kinis arixe, toxo pere bere ine ma tienen nang a Töxödös ne Tanono ixo isik ot e Jisas Krais kö balana e Maria. ");
INSERT INTO bjk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma a tödi re ine e Josep, ine a tödi töxödös ma i koxobo maa bara irabo ömenge ine xö wawara xö marakörö bara irabo wan kalik ine. Io, ixo mamaa bara irabo pet ödödöin mon. ");
INSERT INTO bjk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma nang e Josep ixo dödödöm lamun ina laa na, a önga angelo ixo ot te ine xö wöpönöbö ma ixo tengen, “Josep, a barok ke Dewit, u bele buut ta lamus lo im e Maria xarnang a usuom, möxösa, a barok niang i kip sik, ine i ot meriso xö Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ine irabo kip a bak suxuruno, ma örobo tengen a esene me Jisas, möxösa, irabo öro a nangadi re ine xalik a magingin saban te idi.” ");
INSERT INTO bjk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inabo laa xirip na ixo ot tua wewet eörin a lasanene nang a Orong ixoro tengen sik kö propet bira: ");
INSERT INTO bjk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“A une nang kaim bang ine ra minaru arixe mere tödi irabo tienen ma irabo kip a önga barok ma tabo tengen ine me Imanuel.” A unine möxö ina tinenge niang bira, “God irabo kis arixe me ire.” ");
INSERT INTO bjk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Io, nang e Josep ixo laran ixo pet eörin iat xarnang a angelo xö Orong ixo töngösen ine bie, ma ixo lamus lo im e Maria. ");
INSERT INTO bjk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma lamun kaim idu ra minaru arixe ot nang e Maria ixo kip a bak suxuruno. Ma ixo tengen a esene me Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nang toxoro kip e Jisas suso Betliem kö xönö raxin Judeia xöbo bung ke king Erot, abo duöng nanase mero xö tunamat toxo wanot urungan Jerusalem ");
INSERT INTO bjk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma toxo ose, “Ina barok maxat nang toxoro kip ine bara irabo king köbo Judeia, ine ule? Mem moxo pere a tii rine ro xö tunamat me mem me ot tua lotu wösöt ine.” ");
INSERT INTO bjk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma nang e King Erot mabo marakörö xirip mee Jerusalem toxo ölangen ina na, idi toxo kölö. ");
INSERT INTO bjk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Io, Erot ixo kuwe etok lo xirip abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, ma ixo ose idi bara xö xönö sa iang tabo kip a Mesaia e. ");
INSERT INTO bjk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Me idi toxo balu ine bira, “Ro Betliem kölöme Judeia, xarnang a propet ixo geet sik bie: ");
INSERT INTO bjk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mum abo Betliem, kö xönö pu mee Judeia, mum kobo lik köba sik köbo lagunon niang ma ese raxin tiso Judeia, möxö meringan te mum a önga sisila irabo wanot nang irabo silien abo Israel, a marakörö re e.’” ");
INSERT INTO bjk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Io, Erot ixo kuwe suxume lo inabo duöng nanase mero xö tunamat ma ixo ösöxö lo meringan te idiet a axana bung niang a tii ixo ot. ");
INSERT INTO bjk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Io, ixo tile idiet urso Betliem ma ixo tengen, “Mum moro wan ma moro wawara deek lamun ina bak niang. Nang bara mum mo pere ine, mum morobo töngösen e min, io, e bölök arabo wan ma arabo lotu wösöt ine.” ");
INSERT INTO bjk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nang idiet toxoro ölangen e king, idiet toxo urulo a nuan te idiet ma ina tii niang idiet toxo pere ro xö tunamat, ine ixo silien idiet ot niang ixo ot kina xönö nang a barok ixo kisisik ee. ");
INSERT INTO bjk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Idiet toxo axanan köba nang idiet toxo pere a tii. ");
INSERT INTO bjk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ma nang idiet toxo laxa xö gunon, idiet toxo pere ina bak lik arixe ma nago re ine, e Maria. Me idiet toxo subun kexe xö pu ma toxo lotu wösöt ine. Ma melamu idiet toxo sawang abo bubulus se idiet ma toxo isik abo arabaa urungan te ine, a gol ma sada ma paura nang a lak sixine deek. ");
INSERT INTO bjk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Me God ixo ötumarang idiet kö wöpönöbö bere idiet tebele baling urungan te Erot. Me idiet toxo muu a ngas kabise urungan baling kö kantri re idiet. ");
INSERT INTO bjk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma melamu mon, niang idiet toxoro wan, a angelo xö Orong ixo ot pösöt e Josep kö wöpönöbö ma ixo tengen, “Örö taru ma örö kip lo a barok lik arixe ma nago re ine ma örö ulo rup me idu uruo Isip. Me muot morobo kis singan ot nang e rabo tile tinenge re muot, möxösa, e Erot irabo wawara siwin ina barok lik kua sesexomet ine.” ");
INSERT INTO bjk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Io, Josep ixo taru ma ixo lamus a barok lik arixe ma nago re ine xö dömön ma toxo wan lo uruo Isip. ");
INSERT INTO bjk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Idiet toxo xisixis e ot kö minet te Erot. Ina na ixo ot tua eörin a lasanene niang a Orong ixo tengen kö propet: “Me e xo kuwe ösu lo a barok ke e mero Isip.” ");
INSERT INTO bjk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma nang e Erot ixo ösöxö lo bara abo tödi nanase mero xö tunamat toxo ömamang ine, ixo bala kadik köba ma ixo uguran abo umri rua sesexomet abo barok suxurno xirip mee Betliem ma abo lagunon lörörö xönan nang ma nine awat ma xö pu, mumuu a bung niang abo tödi nanase mero xö tunamat toxo tengen bara a tii ixo wanot wösö. ");
INSERT INTO bjk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ma abo laa niang e propet Jeremaia ixo tengen ixo ot turunon: ");
INSERT INTO bjk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A ginee raxin toxo ölangen kö lagunon Rama, a ginee ma kinis ne tapunuk taxin. Abo nago mee Israel te gegee lamun a bung baroxorok ke idi me idi tokobo mamaa bara tabo ömanan idi möxösa, a bung baroxorok ke idi tere met.” ");
INSERT INTO bjk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Melamu nang e Erot ixo met, a angelo xö Orong ixo ot te Josep kö wöpönöbö ro Isip ");
INSERT INTO bjk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ixo tengen, “Örö taru, moro lamus lo a barok lik arixe ma nago re ine, me muot moro wan urso Israel, möxösa, idi niang toxo eka sesexomet ina barok lik tere met.” ");
INSERT INTO bjk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Io, Josep ixo taru ma ixo lamus lo a bak lik arixe ma nago re ine, me idiet toxo wan baling urungan Israel. ");
INSERT INTO bjk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma lamun nang ixo ölangen bara Akeleas ixoro kulas a tamana e Erot, ixo buut ta nuan uxe. I koxobo wan im uxe, möxösa, God ixoro ögele sik ine xö wöpönöbö, io, ixo baling urungan kö distrik Galili. ");
INSERT INTO bjk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ma ixo wan ma ixo xisixis kö lagunon Nasaret. Io, ixo eörin abo lasanene niang abo propet toxoro tengen sik, “Ma tabo rengrengen ine ma tee mee Nasaret.” ");
INSERT INTO bjk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xö inabo bung niang Jon a tene baptais ixo ot ma ixo palas tinenge xö xönö tataun mee Judeia ");
INSERT INTO bjk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ma ixo tengen, “Mum moro dödöm puxus, möxösa a kingdom möxö watmaep iri lörörö.” ");
INSERT INTO bjk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ina tödi na nang e propet Aisaia ixo etöngösen ulamun ine bira, “A inöno öng i xukup kö xönö tataun, ‘Tagure a nuan möxö Orong, ötöxödös a ngas sö ine.’” ");
INSERT INTO bjk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A man te Jon, toxo pet ma bebene kamel, ma ixo kie ine ma lewene bulmakau. A nien te ine a kö ma musien. ");
INSERT INTO bjk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A nangadi mee Jerusalem me idi nang möxö xönö xirip mee Judeia ma möxö boxönö xirip me Ari Jordan, idi toxo wan lo urungan te Jon. ");
INSERT INTO bjk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Idi toxo tengen ösu bara idi abo duöng saban, ma ixo baptais idi xö Ari Jordan. ");
INSERT INTO bjk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma lamun nang ixo pere a oleleng ne Parasi ma Sadiusi toxo orot kö xönö nang ine xö baptais ee, ixo tengen te idi, “Mum abo tene röxröxö! Ewe ixo panak e mum pa ulo rup kalik ina kinadik nang God i lörörö ra isik? ");
INSERT INTO bjk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mum morobo mana pet abo lalaa nang irabo osen bara mum moxoro dödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Me mum iat mum bele döxömen bara mum morobo rengrengen kaluluonin e mum bie: ‘Ire te eöt tua ulo rewe xalik a ömokorot te God, möxösa, e Abaram a tubuno ire.’ E tengen te mum bara God i öt sik ka öraru abo tubuno e Abaram meringan kinabo wat. ");
INSERT INTO bjk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A matau tuar iang kö unine iaa, mabo iaa xirip nang tekara o abo pasuno deek, tabo tee ösu ma tabo tewe urungan kö könönö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“E baptais e mum ma ari ra osen bara mum muru dödöm puxus. Ma lamun önga tödi irabo wanot melamu re e, i taxin köba re e. E kobo töxödös eöt tua xikip a nine sandel te ine. Ine irabo baptais e mum ma Töxödös ne Tanono ma ia sösöt bölök. ");
INSERT INTO bjk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me ine i tön sik a sawol te ine ra tewe öxaa abo irine wit kö xiki nang irabo paxat tewe abo lewene xalik abo irine. Lamun abo kölömene irine wit deek nang ixo tiip ma i subu, ine irabo iiögun arixin tingan kö öra ne nien. Me ine irabo tewe rewe abo lewene irine wit urungan kölöme xö ia sösöt nang idi tekebeöt ta pus ömet.” ");
INSERT INTO bjk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Io, Jisas ixo wanot meruso Galili uri xö Ari Jordan tua kip a baptais xalik e Jon. ");
INSERT INTO bjk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma lamun Jon ixo eka tenge wi ine, ma ixo tengen, “I töxödös bara nöngön örö baptais e. Ruasa u wanot ura rö e?” ");
INSERT INTO bjk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas ixo balu, “Örö ömaraxen mon bang ina na. I deek bara ire tabo pet eörin abo lalaa nang e God ixoro bulus bara i töxödös.” Io, Jon ixo ömaraxen lo. ");
INSERT INTO bjk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma nang e Jon ixo baptais e Jisas, Jisas ixo wan kaa xalik a ari. Saxit mon niang a balana kubu ixo tamasawang ma ixo pere a Tanono God ixo wan su xarnang a buno ma ixo kis lömö rine. ");
INSERT INTO bjk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Io, a inöno öng meruso xö balana kubu ixo tenge bira, “Ine ano Barok ke e. E mamaa lamun ine me e axanan köba re ine.” ");
INSERT INTO bjk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Io, a Tanono ixo lamus lo e Jisas urungan kö xönö tataun bere e Satan irabo könönöin ine. ");
INSERT INTO bjk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nang e Jisas ixoro ölölö xö nit ne sangaun ne bung ma xö nit ne sangaun ne dömön, ixo irilöng. ");
INSERT INTO bjk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A tene ölelewen ixo wanot pösöt ine ma ixo tengen, “Nang bara nöngön ano Barok ke God, örö tengen köbo warawat ta tawuxus urungan kö beret.” ");
INSERT INTO bjk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisas ixo tengen, “Abo tinenge re God toxoro geet i tengen bira: ‘A nangadi tekobo to xalik mon kö beret, ma lamun köbo tinenge xirip nang i ot meringan kö ngalna e God.’” ");
INSERT INTO bjk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Melamu, Satan ixo lamus lo ine urungan Jerusalem, a lagunon madakdak taxin ma ixo uru e Jisas lömö saxit kö öxöno ngusuno möxö gunon lotu raxin. ");
INSERT INTO bjk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ixo tengen, “Nang bara ano Barok kö God nöngön, örobo kos su, möxösa, abo tinenge re God toxo geet i tengen bira, ‘Irabo isik a tinenge lölös urungan köbo angelo re ine ulamun nöngön, me idi tabo tön uru nöngön mabo limine idi, bara ökorobo segen parange abo sisixine xexem köbo warawat.’” ");
INSERT INTO bjk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas ixo tengen te ine, “Abo tinenge re God toxoro geet i tengen bölök bira, ‘Ganim bara mum mo könönöin a Orong, a God te mum.’” ");
INSERT INTO bjk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Io, Satan ixo lamus lo öbaling ine urso lömö saxit kö maii raxin ma ixo osen ine mabo kantri kirip möxö öxöno lagunon arixe mabo mariris se idi. ");
INSERT INTO bjk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma ixo tengen, “Nang bara örobo subun kexe ma örobo lotu wösöt e, e rabo tabaa nöngön mabo lalaa xirip na.” ");
INSERT INTO bjk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisas ixo tengen te ine, “Satan, örö wan lie e! Möxö abo tinenge re God toxoro geet i tengen bira, ‘Mum moro lotu xö Orong, a God te mum, me ine xalik mon mum morobo ii ölik e mum pe ine.’” ");
INSERT INTO bjk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Io, Satan ixo wan lie ine, ma abo angelo toxo wanot ma toxo top ine. ");
INSERT INTO bjk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nang e Jisas ixo ölangen bara toxoro öxös lo e Jon ma toxo ölaxa ine xö gunon ne aömokorot, ine ixo wan baling uruso Galili. ");
INSERT INTO bjk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jisas kaim kö kinis Nasaret. Ine ixo wan uruso xö lagunon Kaprenaum, nang ixo lörörö xö tu Galili xö xönö möxöbo Sebulon ma Naptali, ");
INSERT INTO bjk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","rua öturunon abo tinenge re God nang e propet Asaia ixo tengen bie, ");
INSERT INTO bjk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Mum möxö xönö pu me Sebulon ma Naptali, mum meringan kö ngas susu urungan kö tu raxin, xö lawana Ari Jordan, mum mee Galili ewe nang kaim bara abo Judeia e mum, ");
INSERT INTO bjk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mum a nangadi nang mum bo kisisik kö ködö, mum muru pere a bibio raxin. Me mum nang mum bo örörö ra minet xarnang a xödxödö ne minet i kait pi e mum, a bibio iri ömaras e mum.” ");
INSERT INTO bjk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Xö ina bung niang Jisas ixo urulo ra palas tinenge ma ixo tengen bira, “Moro dödöm puxus, möxösa, a kingdom möxö watmaep iri lörörö.” ");
INSERT INTO bjk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nang e Jisas ixo önan kö gegene tu Galili, ixo pere a nine narön, Saimon, tobo rengrengen bölök ine me Pita, ma tönö rine e Endru. Idu toxo retewe eben kö ari, möxösa, idu a nine tene kip inan. ");
INSERT INTO bjk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Me Jisas ixo tengen tidu, “Mu moro miang ma moro muu e, e rabo usu e mu ma ngas möxö xikip a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Io, saxit mon, idu toxo wan lie abo eben te idu ma toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nang idiet toxo wan lo meringan, ine ixo pere a nine narön kabise, e Jems a barok ke Sebedi, arixe ma tönö e Jon. Idu toxo kisisik kölöme xö mön arixe me Sebedi a tamadu, idiet toxo marangas bulus abo eben. Jisas ixo kuwe bölök idu ra mumuu ine, ");
INSERT INTO bjk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ma saxit mon idu toxo wan lie ina mön arixe ma tamadu, me idu toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ixo wan kö boxönö xirip kina xönö Galili, ma ixobo usu a nangadi xöbo gunon ne sineseng ke idi, ixobo palas tinenge ma tinenge deek kö kingdom kö God, ma ixobo ölanglanga a nangadi ma mangana miniset kirip. ");
INSERT INTO bjk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A tinenge ixo wan kirip kö inabo lagunon Siria lamun e Jisas, ma a nangadi toxo kip ot abo mangana miniset kirip urungan te ine. Dauleng a kinadik taxin ibo uban idi, dauleng abo tano saban toxoro tup pe idi, dauleng abo gögöng, ma dauleng abo pengpeng, me ine ixo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Marakörö raxin mee Galili, Dekapolis, Jerusalem, Judeia, ma xina xönö lawana Ari Jordan, toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Io, nang ixo pere a marakörö, ixo wan kaa urso xö lawana maii ma ixo kis kö pu. Abo bak ne ausu rine toxo wanot pösöt ine, ");
INSERT INTO bjk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma ixo urulo ra usu idi, ma ixo tengen bira, ");
INSERT INTO bjk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Irabo deek kö idi ewe midi nang idi te sasaxan köba xöbo lalaa xirip merso re God, möxö idi tabo laxa xö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Irabo deek kö idi ewe nang te gee ne tapunuk, möxö God irabo öbala idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Irabo deek köbo tödi ödödö, möxö God irabo tabaa idi arixe mabo lalaa deek nang ixoro tagur sik ke idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Irabo deek kö idi niang te irilöng ma te minauu xöba lamun a tatalien töxödös, möxö God irabo eörin abo mamaa re idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Irabo deek kö idi ewe nang te marase a nangadi xabise, möxö God irabo marase idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Irabo deek kö idi ewe nang te madakdak kö kat te idi, möxö idi tabo pere e God. ");
INSERT INTO bjk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Irabo deek kö idi ewe nang te isik a malum, möxö God irabo tengen bara idi abo barok ke ine. ");
INSERT INTO bjk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Irabo deek kö idi nang bara a nangadi te eler tö idi möxö idi te pet abo tatalien töxödös, möxösa, idi tabo laxa xö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Irabo deek kö mum nang bara a nangadi te tengen ögarin e mum ma nang bara te eler e mum ma nang bara te töxö ögarin e mum arixe mabo mangana lalaa saban lamun mon a eseke. ");
INSERT INTO bjk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Me mum morobo mana axanan, möxösa, a xinuxun taxin te mum nangen nuso xö watmaep, möxö toxoro eler sik bira mabo propet nang toxo sila re mum. ");
INSERT INTO bjk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mum mo xarnang a sol möxö nangadi mera xö öxöno lagunon. Ma nang bara a nanamien möxönan iri kawam, a nanamien möxönan irabo ot baling bule? Ina sol i karabo deek ma irabo laa tataun, i eöt bara tabo tewe rewe ma tabo wawas kaa xönan. ");
INSERT INTO bjk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mum a bibio möxö nangadi xö öxöno lagunon. Kaim pe lagunon lömö xö maii irabo mun. ");
INSERT INTO bjk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaim pe öng ibo usumot a laam ma ibo bulus kö ene bile. Kawaim, idi tobo uxis lömö xö xönö iat möxönan, ma ibo isik a maras kö nangadi xirip kö gunon. ");
INSERT INTO bjk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Xarnang mon, a bibio re mum irabo mararang kö wawara xö nangadi bara idi tabo pere abo tatalien deek ke mum me idi tabo ölet a Tamana e mum nuso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ganim a döxömen bara e wanot ta xikip tewe abo warkurai te Moses bara abo inausu möxöbo propet. E kobo ot tua xikip tewe idi, lamun tua öturunon idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Turunon saxit, nang bara a watmaep ma öxöno lagunon idu te malaa sik iat, kaim pe ulik ne xönö möxöbo warkurai te Moses nang i lik köba irabo kawam ot abo lalaa xirip irabo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ewe niang i lexe re ulik möxöbo warkurai ma i usu a nangadi xabise rua lexlexe bölök, tabo tengen ine bara i lik köba xö kingdom möxö watmaep. Inexalik ewe niang i muu inabo warkurai na ma i usu a nangadi xabise min, tabo tengen ine bara i taxin kö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mum mo döxömen bara abo tene ausu möxöbo warkurai te Moses mabo Parasi, idi te töxödös. Ma lamun e tengen te mum bara mum korobo eöt ta nilaxa xö kingdom möxö watmaep nang bara abo tatalien töxödös se mum i kobo deek köba xöbo tatalien töxödös se idi. ");
INSERT INTO bjk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mum moxoro ölangen bara ina warkurai te Moses ixoro tengen kö nangadi mesila, ‘Ganim a sexomet tödi. Ewenene niang i eresexomet tataun, ine irabo tuu xö warkurai.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma lamun e iat, e tengen te mum bara ewenene niang i laie arixe ma tönö, idi tabo bulus ine xö warkurai ne komiti. Me ine irabo tuu xö warkurai. Ma nang bara ewenene i tengen ögat a tönö bara, ‘Ine a baulang!’, irabo deek bara tabo isik ine mesila xö warkurai ne kansel. Nang bara ewenene i tengen bara, ‘Nöngön u baulang köba’, irabo eöt bara ine irabo wan urungan kö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Möxö ina na, niang bara u eka isik a arabaa re nöngön te God kö xönö möxö bulus arabaa, ma u döxömen lo a bala saban kö töm niang ixo pet te nöngön, ");
INSERT INTO bjk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","örö ganim sik bang a arabaa re nöngön mesila xö xönö möxö bulus arabaa. Me mu morobo ötöxödös bang e mu. Io, melamu örobo isik a arabaa re nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nang bara a öng i lamus nöngön kö warkurai, nöngön örobo ötöxödös pasaxirin arixe mine nang bara mu mo önan kö ngas, xalik ibo isik nöngön kö tene warkurai, ma tene warkurai irabo isik nöngön kö duöng möxö balaure nangadi nang tobo kubus pi idi kölöme xö gunon ne aömokorot, ma irabo bulus nöngön könan. ");
INSERT INTO bjk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Turunon saxit, nöngön ökorobo wan su ot nang örobo isik abo xinuxun kirip pe nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mum moxoro ölangen bölök bara ina warkurai te Moses ixo tengen bira, ‘Ganim pe öng nang i elolo ra minaru arixe ma öng nang kaim bara re ine.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma lamun e iat, e tengen te mum bara ewe nang i neek a une, ine iri pet a saban, möxösa, ine iri maru arixe ma önga une xabise kölöme xö to rine. ");
INSERT INTO bjk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ma nang bara a lawana maram i engin nöngön ta pet magingin saban, örö luok tewe ma örö tewe rewe. I deek ke nöngön bara tabo tee rewe re uk möxö lewene aim, xalik a lewene aim kirip tabo tewe urungan kö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nang bara a lime tuun i engin nöngön ta pet magingin saban, örobo tee xöröp ma örobo tewe rewe ine. I deek kö nöngön bara tabo irewese önga lawana aim, xalik a aim kirip irabo wan laxa xö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ma ina warkurai te Moses ixo tengen bira, ‘Ewe re öng niang i köröp alolo ma une re ine, irabo mana geet te tinenge maras möxö köröp alolo ma irabo mana isik ina ginigeet urungan kö une re ine.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma lamun e iat, e tengen te mum bara ewe re öng niang i köröp alolo ma une re ine nang i kala ilawa, io, ina tödi i engin ine rua minaru arixe ma öng kabise ra pet sasaban. Ma ewe re öng i elolo ina une nang ina tödi iri köröp a alolo re idu, i pet a tatalien saban, möxösa, ine i maru ma une kaim bara re ine. ");
INSERT INTO bjk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mum moxoro ölangen bölök bara ina warkurai te Moses ixo tengen köbo tubu mum bira, ‘Ganim bara u pörök a usugurno. Inexalik bara örobo tön sik a usugurno re nöngön u xoro pet urungan kö Orong.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma lamun e iat, e tengen te mum, ganim bara mum mo sugurno ra ölölös a tinenge re mum. Ganim a sugurno urso lömö, möxö e God ibo wewet warkurai tingan lömö. ");
INSERT INTO bjk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma ganim a sugurno ma öxöno lagunon, möxösa, e God ibo bulbulus a xexene xönan. Ma ganim a sugurno urungan Jerusalem, möxö ina xönö ine a lagunon kö King Taxin. ");
INSERT INTO bjk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma ganim a sugurno ma öxöm iat, möxö u kebeöt tua wewet arixin te bebene öxöno öng irabo pidien bara irabo kong. ");
INSERT INTO bjk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Inexalik i öt bara örobo tengen mon bara u maraxa bara u mölök. Lamun nang bara u tengen te mangana lalaa rua wewet ölölös a tinenge re nöngön, örobo ösöxö bara i ot meringan kalik ina tene sasaban. ");
INSERT INTO bjk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mum moxoro ölangen bölök ina warkurai te Moses ixo tengen bira, ‘Nang bara u luok tewe a kalait marna öng, idi bölök tabo luok tewe re önga kalait maram. Ma nang bara u pit tewe a ngisine öng, idi bölök tabo pit tewe re önga ngisem.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma lamun e iat, e tengen te mum, ganim a babalu a sasaban urungan kö tödi saban. Nang bara re öng i wasa nöngön kö lawana wales tuun, isik bölök a lawa kes urungan te ine. ");
INSERT INTO bjk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma nang bara re öng i mamaa ra isik nöngön kö warkurai rua xikip lo a man te nöngön, ömaraxa lo ine rua ilo bölök a siot te nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nang bara re öng i ölölös nöngön ta xikip abo lalaa re ine urungan lörörö mon, ma ngas a lak ömat bang, io, örobo kip öxase a ulik bölök inabo lalaa re ine. ");
INSERT INTO bjk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma nang bara re öng i seng nöngön mere laa, örobo mana tabaa ine. Ma nang bara re öng i ka seseng lo bang ke lalaa re nöngön, tabaa bang ine min. ");
INSERT INTO bjk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mum moxoro ölangen bölök ina warkurai te Moses ixo tengen bira, ‘Mum morobo mana bala malum kö öng kabise ma morobo melentexin abo iuo re mum.’ ");
INSERT INTO bjk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma lamun e iat, e tengen te mum, mum morobo mana mamaa lamun abo iuo re mum ma morobo seseng ke ewenene me idi nang te ögarin e mum, ");
INSERT INTO bjk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bara mum morobo abo bak kö Tama mum niso lömö xö watmaep. Ma ibo tile a xaken tine rue idi nang abo tene sasaban me idi nang a lak deek. Ma ibo tile a baraa urungan te idi ewe te töxödös me idi ewe nang tekobo töxödös. ");
INSERT INTO bjk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lamun nang bara mum mo mamaa lamun ewe midi niang te mamaa lamun e mum, God i karabo balu öbaling e mum mere lalaa deek. Me idi bölök abo tene kip takis tobo wewet ina na. ");
INSERT INTO bjk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma nang bara mum mo wöwörö xalik mabo töm mum ewe mum bo mamaa ulamun idi, io, a lasanene i deek bölök mum mo wewet köbo duöng kabise? Inexalik ewe idi nang tekobo nunu re God, idi bölök tobo wewet ina na. ");
INSERT INTO bjk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Io, mum morobo mana töxödös köba saxit bie xarnang a Tama mum niso lömö i töxödös köba sik. ");
INSERT INTO bjk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tumarang e mum ma ganim bara mum mo pet tebo tatalien deek kö wawara xö nangadi rue idi tabo pere e mum. Nang bara mum mo pet bie, mum mo korobo kip lo a xinuxun meriso xö Tama mum niso lömö xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Io, nang bara u tabaa re tödi sasaxan, ganim bara u osen kö wawara xö nangadi. Idi nang tobo röxröxö bara idi a nangadi deek, tobo wewet bie kölöme xöbo gunon ne sineseng ma xöbo ngas bölök. Idi tobo wewet bie rua nangadi tabo ii öraxin idi. Turunon saxit, idi toxoro kip lo xirip abo xinuxun te idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lamun nang bara u isik a arabaa urungan kö tödi sasaxan, ganim bara lime kes i ösöxö a mangana lasa a lime tuun i wewet. ");
INSERT INTO bjk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Lamun ina arabaa re nöngön irabo mana kis suxume sik iat. Io, a Tamana e nöngön nang ibo werwere abo lalaa deek te pet suxume, ine irabo isik a inone xinuxun te nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nang bara mum mo seseseng, ganim bara mum mo xarnang idi nang tobo röxröxö mon bara idi a lak deek, möxö idi tobo mamaa mon tua tinuu ma sineseng kölöme xöbo gunon ne sineseng ma xö boxönö nang a nangadi tobo oretok ee rua duöng ka werwere idi tobo seseseng. Turunon saxit, idi toxoro kip lo abo xinuxun kirip pe idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lamun nang u seseseng, örobo mana wan laxa xö gunon, baxut a marame ma örobo seseng urungan kö Tamana e nöngön, ewe nang ke öng i kebeöt ta werwere ine. Io, a Tamana e nöngön, ewe ibo werwere a lasa toxobo wewet suxume, ine irabo isik a xinuxun te nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ma nang u seseseng, ganim bara u pet ömarin a sineseng ke nöngön, möxö kaim pe unine möxönan xarnang idi ewe tekobo nunu xö God. Io, idi tobo döxömen bara God irabo ölangen mon idi xöbo oleleng ne boxönö tinenge xö ina sineseng ke idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Inexalik bara ganim e mum pa xarnang idi, möxö a Tamana e nöngön iri ösöxö tuar a lasa u mamaa ulamun, nang bang u kala seng ine. ");
INSERT INTO bjk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Io, mum morobo mana seseng bira: ‘A Tama mem niso lömö xö watmaep, mem me mamaa bere mem marabo bulus kabisein a esem pua osen bere nöngön u madakdak saxit, ");
INSERT INTO bjk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","me mem me mamaa bara a kingdom pe nöngön irabo wanot, ma bara tabo pet eörin a mamaa re nöngön ta xö öxöno lagunon xarnang tobo wewet tiso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tabaa e mem nixinen ma nien te mem nang i eöt ma önga bung. ");
INSERT INTO bjk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma örö döxömen taun tewe abo magingin saban te mem, xarnang bölök e mem marabo döxömen taun tewe abo magingin saban toxoro pet tö mem. ");
INSERT INTO bjk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Me mem me mamaa bölök bara örobo balaure wi e mem kalik abo ölelewen, ma örö kip puxus e mem kalik a tene saban. Möxö re nöngön iat a kingdom, ma a lölös, me mem marabo ölet nöngön ulorexe. Amen.’ ");
INSERT INTO bjk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Io, nang bara mum mo döxömen taun a magingin saban köbo duöng nang te pet tö mum, a Tama mum niso xö watmaep, ine bölök irabo döxömen taun abo magingin saban te mum. ");
INSERT INTO bjk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma lamun nang bara mum mo köbo döxömen taun a magingin saban kere öng kabise i pet tö mum, a Tama mum bölök i karabo döxömen taun a magingin saban te mum. ");
INSERT INTO bjk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ma nang bara mum mo ölölö urungan te God, ganim e mum pa winara meles xarnang idi tobo wewet nang tobo röxröxö mon bara idi a lak deek, möxösa, idi tobo osen a mamaran te idi xö nangadi bara idi te ölölö. Turunon saxit, idi tere kip lo abo xinixun kirip pe idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Lamun nang bara u ölölö urungan te God, örobo magan tua nangadi tekebeöt tua werwere xulen nöngön bara u ölölö, inexalik irabo maras urungan kalik mon kö Tamam ewe nang tekara pere ine. Ma a Tamam ewe nang ibo werwere a laa u bo wewet suxume, ine irabo isik a xinixun urungan te nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ganim e mum pa bulbulus ögun abo tabarikik ke mum pa xö öxöno lagunon nang a iwis irabo perögat ma irabo maut tewe. Ma ganim e mum pa bulbulus inabo lalaa na xö boxönö nang a duöng pililo tobo wörwörök a gunon ma tabo pulo. ");
INSERT INTO bjk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lamun bara mum morobo bulus ögun a tabarikik ke mum puso xö watmaep, nang abo iwis tekebeöt ta wewet ögat ma i karabo kawam, ma a nangadi pililo tekebeöt ta nilaxa xönan ma tabo pulo. ");
INSERT INTO bjk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Möxö a tabarikik ke nöngön i kis singan ee, ma a to xirip pe nöngön i kis singan bölök. ");
INSERT INTO bjk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“A nini kalait maram, idu te xarnang a bibio re nöngön. Nang bara a nine kalait maram a lak deek, io, a aim kirip irabo maras. ");
INSERT INTO bjk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lamun nang bara a nine kalait maram i kobo deek, io, a to xirip pe nöngön irabo wöwö ma xödxödö. Inexalik bara ina maras nang i kis kölöme re nöngön iri ködö, ina xödxödö irabo taxin köba! ");
INSERT INTO bjk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kaim pe öng i öt tua ölangen a nini orong. Möxö ine irabo kasen a öng ma irabo mamaa ulamun a öng kabise, ma bara irabo araröt sik kö öng ma irabo melentexin a öng kabise. Io, mum kebeöt tua ölangen e God ma a tuluwok bölök. ");
INSERT INTO bjk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Möxö ina na, e tengen te mum, ganim a dinödöm oleleng lamun a to re mum bara a lasa morobo en ma a lasa morobo inim, ma a lasa morobo sige xö aimum. A to re mum i laa raxin köba xö nien, ma a aimum i taxin köba xö man. ");
INSERT INTO bjk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mum moro pere a bung pun merso lömö. Idi tekara susulo. Ma tekara kin öxaa nien. Ma tekara iiögun ödeek kö gunon mataxen. Ma lamun a Tamana e mum niso xö watmaep ibo tabaa idi ma nien. Mum morobo maras bara xö mamaa re God, mum mo taxin sik ke idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Me ewenene mere mum i dödöm oleleng ulamun abo tiip pe ine, i eöt tua öxase a to re ine ulik baling? Kaim turunon. ");
INSERT INTO bjk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma rösanene mum mo tapunuk lamun a man? Mum moro pere abo pasuno iaa te das bule. Idi tekara ösöxö ra tinörön me idi tekara ösöxö ra söxsöxö a man. ");
INSERT INTO bjk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Inexalik e tengen te mum bere e Solomon kaim ine xo sisige rebo man deek xarnang a öng mere idi. ");
INSERT INTO bjk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Io, God i balaure a pirixö nang i to nixinen, ma maxalik tabo tewe öxaa xö ia sösöt. Nang bere God i pet bie xö pirixö, turunon saxit ine irabo tawi nöngön bölök ma man te nöngön. Maris, a nunu re mum i wuruwut köba. ");
INSERT INTO bjk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mum ganim a tapunuk, ma morobo tengen bara, ‘Ire tabo en a sa?’ ma, ‘Ire tabo inim a sa?’ bara, ‘A lasa tabo sige?’ ");
INSERT INTO bjk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ewe midi nang tekobo nunu re God, idi tobo wawara siwin inabo lalaa na, ma Tata re mum nuso xö watmaep i ösöxö bara mum mo sasaxan. ");
INSERT INTO bjk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mesila xöbo lalaa xirip, mum morobo parasiwin a tatalien töxödös se God ma abo lalaa i eöt ma kingdom pe ine. Me ine irabo tabaa e mum minabo lalaa xirip bölök. ");
INSERT INTO bjk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Inexalik, ganim a tapunuk lamun abo lalaa möxö maxalik. Abo tiip möxö maxalik, mum moro gan sik kua maxalik. Ire mabo tiip iat köbo öngöng a bung. ");
INSERT INTO bjk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nöngön u bele kure öng kabise bara i pet a saban, xalik e God irabo kure nöngön bölök bira. ");
INSERT INTO bjk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","God irabo kure nöngön xarnang mon u kure a nangadi xabise. Ma abo mangana warkurai nang u pet kö nangadi xabise, God irabo pet bölök kö nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ruasa nöngön u pere abo perne iaa kölöme xö marana e töm, ma u kobo döxömen lo im ina pönö iaa kölöme xö marana e nöngön iat? ");
INSERT INTO bjk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nöngön u bele tengen urungan kö töm bara, ‘E rabo kip tewe a perne iaa xö maram.’ Nöngön ökorobo pet bie, möxösa, nöngön iat angen ma pönö iaa xö maram. ");
INSERT INTO bjk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nöngön nang u bo röxröxö mon bara nöngön a lak deek, örö luok tewe bang ina pönö iaa xö maram iat, melamu nöngön örobo wawara deek kua xikip tewe abo perne iaa xö marana e töm. ");
INSERT INTO bjk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma ganim a tewe örup abo lalaa nang a lak deek urungan köbo wuluwun ma urungan köbo bo, xalik idi tabo pas mabo xexene idi me idi tabo baling me idi tabo kat didis nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nöngön örobo seseng ma örobo kip lo a laa. Nang bara u wawara siwin, örobo pere wösöt lo. Ma nang bara u wiwidin kö marame, God irabo sawang lo nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Möxö ewe i seseseng, irabo kip lo a lasa ine i ose lamun. Ewe i wawara siwin, irabo pere wösöt lo a laa niang ine i wawara siwin. Me ewe niang i wiwidin, God irabo sawang lo ine. ");
INSERT INTO bjk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ewe re mum ibo tabaa a barok ke ine ma warawat niang bara i seng ine ma nien? ");
INSERT INTO bjk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma nang bara i seng a inan, irabo tabaa ine ma si? ");
INSERT INTO bjk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nang bara mum abo tene sasaban, mum mo ösöxö ra tabaa abo barok ke mum ma abo lalaa deek, io, i osen bara a Tata re mum nuso xö watmaep i ösöxö ra isik abo lalaa deek kö idi ewe niang te seng ine. ");
INSERT INTO bjk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Io, mum morobo pet kö nangadi xabise xarnang e mum mo mamaa lamun idi tabo pet te mum. Ina tinenge na, ine a unine möxöbo warkurai te Moses mabo inausu möxöbo propet. ");
INSERT INTO bjk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mum morobo mana laxa xö marame lik, möxösa, a marame ma a ngas a lak taweweng i silien a nangadi urungan kö minet, ma oleleng ne nangadi te laxa xönan. ");
INSERT INTO bjk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lamun a marame lik ma a ngas lik ibo silien a nangadi urungan kö to, ma dauleng mon tobo pere wösöt lo. ");
INSERT INTO bjk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mum morobo tumarang köbo propet töxö. Idi tabo ömamang e mum bara idi abo sipsip. Lamun idi te xarnang abo wuluwun axe tobo ekat. ");
INSERT INTO bjk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mum morobo perexulen idi xöbo tatalien te idi, xarnang mon mum bo perexulen abo uno iaa xö inone idi. Mum kara ösöxö ra dik gamat kö pirixö gargaras. Me mum kara ösöxö rua kip pöxö xalik a pirixö tataun. ");
INSERT INTO bjk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Xarnang mon ina niang, a iaa deek ibo oo a pasuno iaa deek, lamun a iaa saban ibo oo a pasuno iaa saban. ");
INSERT INTO bjk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A iaa deek i kebeöt ta o a pasuno iaa saban, ma iaa saban i kebeöt ta o a pasuno iaa deek. ");
INSERT INTO bjk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Abo uno iaa xirip nang tekara ösöxö ra o a pasuno iaa deek, idi tabo tee ösu ma tabo tewe urungan kölöme xö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Io, mum morobo perexulen idi xöbo inone idi. ");
INSERT INTO bjk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kaim bara nangadi xirip tobo rengrengen e, ‘Orong, Orong,’ tabo laxa xö kingdom möxö watmaep, lamun idi xalik mon idi tobo wewet eörin a mamaa re Tata re e nuso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A oleleng tabo tengen te e xina bung, ‘Orong, Orong! Bule im pe mem? Mem moxo rengrenge propet kö lölös se nöngön. Me mem moxo irewe abo tano saban kö lölös se nöngön. Ma arixe ma lölös se nöngön mem moxo pet a oleleng ne lalaa lölös ne auwuwus.’ ");
INSERT INTO bjk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Io, e rabo tengen te idi bara, ‘E kobo ösöxö runon e mum. Moro wan kalik e, mum abo tödi saban!’ ");
INSERT INTO bjk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Io, ewe nang i ölangen ina tinenge re e ma i pet muu xö to rine, i xarnang a tödi nanase ewe nang ixo sulo ösu a gunon te ine uri lawu xö xönö warawat. ");
INSERT INTO bjk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A baraa ixo su, ma a ari ixo lölös, ma xiki ixo taru ma ixo paxat ina gunon. Inexalik ina gunon kaim kö sinubu, möxösa, ine ixoro uru ösu abo xösöng uri lawu xö xönö warawat. ");
INSERT INTO bjk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Lamun ewenene nang i kobo ölangen inabo tinenge re e, ma i kobo pet muu, ine i xarnang a tödi baulang ewe niang ixo uru a gunon te ine xö önö. ");
INSERT INTO bjk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A baraa ixo su, ma ari ixo lölös, ma a xiki ixo taru ma ixo paxat ina gunon, ma gunon ixo tawörök ma ixo tamaöbeng saban.” ");
INSERT INTO bjk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nang e Jisas ixo öxawam a tinenge xinabo lalaa, a nangadi toxo wuwus kö ausu re ine, ");
INSERT INTO bjk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","möxö ixo usu idi xarnang a tödi iri kip lo a lölös sua inausu, ma kaim xarnang abo tene ausu möxöbo warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nang ine ixo wanot meruso xö lawana maii, a marakörö raxin toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A tödi ma miniset lepra ixo ot ma ixo subun kexe mesila re ine ma ixo tengen, “Orong, nang bara u mamaa, nöngön u eöt ta öxawam a miniset lepra xalik e bara e ra madakdak.” ");
INSERT INTO bjk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Me Jisas ixo sasanga ma limine ma ixo tön ine. Ma ixo tengen te ine, “E mamaa. Örö deek.” Ma saxit iat mon ina miniset lepra ixo kawam kalik ine. ");
INSERT INTO bjk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Io, Jisas ixo tengen te ine, “Ganim bara u tengen osen kere öng. Inexalik örö wan ma örö osen nöngön kö pris ma örö isik a arabaa ne söngsöngöt eöt ma warkurai te Moses. Ma irabo xarnang a atöngösen maras sö idi bara a turunon bere u xoro langlanga.” ");
INSERT INTO bjk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Io, nang e Jisas ixo wan laxa tuar kö xönö Kaprenaum, a umri raxin möxöbo duöng inarse ixo wanot pösöt ine, ma ixo ose lamun a rorop. ");
INSERT INTO bjk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ma ixo tengen, “Orong, a tene tinörön te e i maru sik kö gunon te e. Ma i örasen a kinadik taxin, ma i kebeöt ta ömagi a aine.” ");
INSERT INTO bjk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas ixo tengen te ine, “E rabo wan me e rabo ölanglanga ine.” ");
INSERT INTO bjk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ina umri raxin ixo tengen, “Orong, e kobo tödi deek köba bara örobo wan laxa xö gunon te e. Inexalik bara örö tengen mon a tinenge re nöngön, ma ina tene tinörön te e irabo langlanga. ");
INSERT INTO bjk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","E tengen bira, möxösa, e bölök e kisisik kö ene warkurai, mabo umri bölök te kisisik kö ene e. Me e bo tengen kö öng, ‘Wan’, io, ibo wan. Me e bo tengen kö öng niang, ‘Miang’, ma ibo wanot. Me e bo tengen kö tene tinörön te e, ‘Örö pet a na’, ma ibo pet bie.” ");
INSERT INTO bjk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas ixo wuwus saban nang ixo ölangen ina na, ma ixo tengen te idi nang toxo mumuu ine, “Turunon saxit, e kala parasiwin te öng ka Israel ma mangana nunu raxin bira. ");
INSERT INTO bjk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","E tengen tö mum, a oleleng tabo wanot mero xö tunamat ma meriso xö labur, ma tabo kis kö pet nien te Abaram, Aisak me Jekop kö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Inexalik ewe idi nang sila e God ixo pere kos idi rua kinis kö kingdom, tabo tewe ösu idi urungan kö ködö lamin, nang kingan idi tabo gegee ma tabo engiren abo ngisine idi.” ");
INSERT INTO bjk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Io, Jisas ixo tengen kö ina umri raxin, “Örö wan! Ma irabo ot xarnang u nunu sik bie.” Ma a tene tinörön te ine ixo langlanga baling kö ina axana bung iat mon. ");
INSERT INTO bjk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma nang e Jisas ixo wan laxa xö gunon te Pita, ixo pere a taön te Pita ixo maru sik ma malao xö öra. ");
INSERT INTO bjk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ine ixo tön a limine ina une ma a malao ixo kawam kalik ine me ine ixo taru kaa ma ixo urulo ra tabaa ine ma nien. ");
INSERT INTO bjk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Io, nang ixoro aien im, toxo kip ot a oleleng nang abo tano saban toxoro tup pe idi urungan te Jisas, ma ixo irewese abo tano saban ma a tinenge, ma ixo ölanglanga abo duöng miniset kirip. ");
INSERT INTO bjk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Abo laa na ixo ot tua öturunon abo tinenge re propet Aisaia bira, “Ine iat ixo kip lo inabo miniset te ire ma ixo sölök lo inabo kinadik ke ire.” ");
INSERT INTO bjk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nang e Jisas ixo pere ina marakörö xirip köbo lawana ine, ixo isik a tinenge lölös sö idi abo bak ne ausu ra lilies köröp urungan kö lawa xabise möxö tu. ");
INSERT INTO bjk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Io, önga tene ausu möxöbo warkurai te Moses ixo wanot pösöt ine ma ixo tengen, “Tene Ausu, e rabo muu nöngön köbo nuan kirip pe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas ixo balu, “A bung puluwun axe idi ma mara, ma bung pun möxö maop idi ma wöwösö, nexalik a Barok kö Tödi kaim ine mere xönö rua ömarin a öxöno.” ");
INSERT INTO bjk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Önga bak ne ausu xabise ixo tengen te ine, “Orong, örö öbala bang e ma ara wan ara pömös e tata re e.” ");
INSERT INTO bjk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma lamun Jisas ixo tengen te ine, “Örö muu e, ma ganim abo minet tabo pömös abo minet te idi.” ");
INSERT INTO bjk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Io, ine ixo kakaa xö mön ma abo bak ne ausu re ine toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma a dalun taxin ixo taru lölös kö tu. A dalun ixo tawit laxa xö mön. Inexalik Jisas ixo paluso sik. ");
INSERT INTO bjk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abo bak ne ausu toxo wan, ma toxo ölaran ine ma toxo tengen, “Orong, örobo öro ire! Ire te eka köngö!” ");
INSERT INTO bjk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Io, ixo tengen, “A nunu re mum i lik köba. Mum mo bubuut köba ruasa?” Io, ine ixo taru kaa ma ixo tenge köö a xiki ma dalun, ma ina tu raxin ixo malile esexere. ");
INSERT INTO bjk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Abo duöng toxo wuwus saban ma toxo ose bara, “A mangana tödi sanene ia? Nang a xiki ma dalun iat te tame ine!” ");
INSERT INTO bjk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nang ine ixo ot kö lawa xabise möxö ina xönö pu Gadara, a nine tödi ma tano saban, toxo wan su xalik abo lieng kö nangadi minet ma toxo esuo me Jisas. Kawaim arixe re öng ibo önan saxit kina ngas, möxösa, idu toxoro axe xöba. ");
INSERT INTO bjk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Idu toxo kup bira, “A Barok kö God, u mamaa lamun a lasanene xalik e maa? Nöngön u wanot ta ra öxadik köbanin e maa, ma axana bung nang e God irabo isik a kinadik ke maa i kala ot bang?” ");
INSERT INTO bjk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kaim a palaa ulik kalik idiet, a oleleng ne bung bo toxo aan. ");
INSERT INTO bjk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Abo tano saban toxo seng e Jisas, “Nang bara u irewese e mem, tile e mem urungan kö bung bo.” ");
INSERT INTO bjk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas ixo tengen te idi, “Mum moro wan su!” Io, idi toxo wan su ma toxo laxa rup kö bung bo, ma ina bung bo xirip toxo ewasak su xö gegene maii urungan kölöme xö ari ma toxo met kö könönö ari. ");
INSERT INTO bjk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Io, a nangadi möxö balaure a bung bo, toxo ulo rup, ma toxo wan laxa xö lagunon taxin ma toxo tengen osen inabo laa xirip, arixe ma a lasa nang ixo ot kö nine tödi nang a tano saban ixo laxa rup pe idu. ");
INSERT INTO bjk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Io, a nangadi xirip möxö ina lagunon taxin idi toxo wan su rua asuo me Jisas. Ma nang idi toxo pere ine, toxo tenge marmaris se ine ra nuan pes xalik ina xönö re idi. ");
INSERT INTO bjk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas ixo kakaa laxa xö mön, ma ixo lies köröp kö ari ma ixo wanot urungan kö lagunon te ine iat. ");
INSERT INTO bjk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dauleng ne duöng toxo kip ot a pengpeng kö ben urungan te Jisas. Ma nang e Jisas ixo pere a nunu re idi, ixo tengen kö pengpeng, “Barok, örö balawapat. Na iat mon a magingin saban te nöngön iri kawam.” ");
INSERT INTO bjk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma nang a dauleng ne tene ausu möxöbo warkurai te Moses toxo ölangen ina na, idi toxo etöngösen kaluluonin idi iat bara, “Ina tödi na i tengen ögarin e God!” ");
INSERT INTO bjk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas ixo ösöxö sik abo dinödöm pe idi ma ixo tengen, “Rösa mum mo döxömen lo abo dinödöm saban kö kat te mum? ");
INSERT INTO bjk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nangang sa re idu i malus sa rengrengen? I malus se e ra tengen bira, ‘A magingin saban te nöngön iri kawam’? Bara i malus se e ra tengen, ‘Tuu lömö, ma örö wan’? ");
INSERT INTO bjk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma lamun eka osen e mum bara a Barok kö Tödi ine ma lölös kö öxöno lagunon tua irewese a magingin saban.” Io, ixo tengen kö pengpeng, “Tuu lömö ma örö kip lo a ben te nöngön ma örö wan urungan kö ngasiem.” ");
INSERT INTO bjk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma ina tödi ixo taru kaa ma ixo wan urungan kö gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ma nang a marakörö toxo pere bira, idi toxo ii e God ma binuut. Me idi toxo ölet e God, ewe ixoro isik a mangana lölös bira urungan kö nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma nang e Jisas ixo wan lo meringan, ine ixo pere a tödi, a esene e Matiu, ixo kisisik kö xönö möxö kip takis. Me Jisas ixo tengen te ine, “Muu e!” Me Matiu ixo taru ma ixo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Melamu, nang e Jisas mabo bak ne ausu re ine toxo an kö gunon te Matiu, a oleleng ne tene kip takis mabo ‘duöng saban’ toxo wanot ma toxo an arixe mine mabo bak ne ausu re ine. ");
INSERT INTO bjk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma nang abo Parasi toxo pere bira, idi toxo ose abo bak ne ausu re ine bira, “Ruasa ina tene ausu re mum i aan arixe mabo tene kip takis mabo ‘duöng saban’?” ");
INSERT INTO bjk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas ixo ölengen abo Parasi, io, ixo tengen te idi bira, “A nangadi nang kaim a miniset, idi tekara sasaxan ulamun a tene aule, nexalik idi xalik mon nang a lak miniset. ");
INSERT INTO bjk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Inexalik mum moro wan ma moro parasiwin ina unine tinenge re God nang i tengen bira, ‘I mamaa bere mum morobo marase a nangadi, me e kobo mamaa lamun abo arabaa nang mum bo wewet.’ Me e kobo ot ta xukuwe abo tene töxödös. Kawaim. E ot lamun a nangadi saban”. ");
INSERT INTO bjk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Io, abo bak ne ausu re Jon toxo wanot ma toxo ose ine bere, “Ruasa mem mabo Parasi bo ölölö, ma lamun abo bak ne ausu re nöngön tekara ölölö?” ");
INSERT INTO bjk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas ixo balu idi, “Bule bara a bung osee möxö tödi alolo maxat, idi tabo mana tapunuk nang bara ine angen arixe me idi? Kaim. A axana bung irabo wanot nang tabo kip lo ina alolo maxat kalik idi. Kö ina axana bung na, idi tabo ölölö im. ");
INSERT INTO bjk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kaim pe öng ibo sösöxö a xönö sewene man maxat lömö xö man maut, möxösa, a xönö sewene man maxat irabo tamaliling lo xalik ina man, ma irabo pet ötamadidi ma irabo saban arixe. ");
INSERT INTO bjk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kaim pebo duöng tobo linglinge a wain maxat nang i kobola ebobot bang kölöme xö önga laa mo kuluwo ari nang toxo pet ma lewene meme maut i lelet sik. Nang bara idi te pet, a lewene meme irabo tamadidi, a wain irabo su xirip ma lewene meme irabo saban. Kawaim bie, tobo riri sik a wain maxat kö lewene meme maxat, me idu tabo malaa deek sik.” ");
INSERT INTO bjk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nang ine ixo rengrengen ina na, a tene warkurai ixo wanot ma ixo subun kexe mesila re ine ma ixo tengen, “A balik ke e iri met na mon. Ma lamun örö miang ma örö bulus a limem lömö re ine me ine irabo to baling.” ");
INSERT INTO bjk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisas ixo tuu kaa ma ixo wan arixe me ine, ma abo bak ne ausu re ine bölök. ");
INSERT INTO bjk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Io, i kobo ömat mon ma önga une nang a dee ixobo önan kalik ine xö sangaun ma ninöng ne awat, ine ixo wan melamu re Jisas ma ixo sigi a ngusuno man te ine. ");
INSERT INTO bjk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma ixo tengen tö ine iat, “Nang bara e sigi a man te ine mon, e rabo deek.” ");
INSERT INTO bjk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas ixo tawuxus ma ixo pere ine, ma ixo tengen, “A balik ke e, örö balawapat. A nunu re nöngön iri öro nöngön.” Ma ina une ixo deek baling kö ina axana bung mon niang. ");
INSERT INTO bjk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nang e Jisas ixo wan laxa xö gunon kö ina tene warkurai ma ixo pere a nangadi toxo sese a koo ma marakörö toxo ees nana, ");
INSERT INTO bjk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ma ixo tengen, “Moro wan pes. A balik i kobo met. Inexalik i paliso mon.” Me idi toxo isis belek ine. ");
INSERT INTO bjk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Malamu nang a marakörö toxoro wan su im, ixo wan laxa ma ixo tön a limine, ma a balik ixo tuu kaa. ");
INSERT INTO bjk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A tinenge möxö ina na ixo wan kirip kö ina xönö lagunon. ");
INSERT INTO bjk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nang e Jisas ixo wan lo im meringan, a nini tödi marapulo toxo muu ine, ma toxo xukup, “Barok kö marapun te Dewit, örö marase e maa!” ");
INSERT INTO bjk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma nang e Jisas ixo wan laxa xö ina gunon, a nini tödi marapulo toxo wanot pösöt ine ma ixo ose idu, “E mu mo nunu bara e rabo eöt ta wewet a na?” Idu toxo balu ine, “Orong, maa me nunu.” ");
INSERT INTO bjk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Io, ine ixo sigi abo marna idu ma ixo tengen, “Xarnang iat mon mu mo nunu bie, irabo wanot te mu.” ");
INSERT INTO bjk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma abo kalait marana idu ixo tamasawang. Jisas ixo isik a tinenge lölös sö idu bira, “Ganim e muu ra rengrengen osen a na xere öng.” ");
INSERT INTO bjk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Inexalik bara idu toxo wan elixilik ma toxo isik esexerein a pii re ine xöbo lagunon kirip pe idi. ");
INSERT INTO bjk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nang idu toxo önan su, a tödi ewe nang ine ma tano saban ma a ngalaböt ine, toxo kiwot ine urungan te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma nang e Jisas ixo xikip tewe ina tano saban, ina tödi ewe i kara tenge, ixo tenge wök. A marakörö toxo wuwus saban ma toxo tengen, “Kawaim pe laa bira toxoro pere ra kölöme Israel.” ");
INSERT INTO bjk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Inexalik abo Parasi toxo tengen, “Ina sisila möxöbo tano saban ibo tabaa ine ma lölös sa xikip tewe abo tano saban.” ");
INSERT INTO bjk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas ixo wan laxa xirip köbo lagunon taxin mabo lagunon, ixobo eusu xöbo gunon ne sineseng ke idi, ixobo palas tinenge ma tinenge deek möxö kingdom ma ixobo ölanglanga abo mangana miniset kirip. ");
INSERT INTO bjk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nang ine ixo pere a marakörö, ixo marase idi, möxösa, idi toxoro meles ma kawaim pe öng ka rorop idi, xarnang a bung sipsip te tup ma kaim idi ma tene walbalaurai. ");
INSERT INTO bjk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Io, ixo tengen köbo bak ne ausu re ine, “A nien iri maruxo xirip ma iri oleleng, nexalik a nausen mon idi abo tene tinörön. ");
INSERT INTO bjk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Io, mum morobo seng a Tamana ina nien maruxo bara irabo tile rebo tene tinörön urungan kö komo re ine.” ");
INSERT INTO bjk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas ixo kuwe ot abo sangaun ma ninöng ne bak ne ausu rine urungan te ine ma ixo tabaa idi ma lölös sua tile ösu abo tano saban ma rua ölanglanga abo mangana miniset kirip. ");
INSERT INTO bjk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Abo esene idi a sangaun ma ninöng ne aposol i bira: a sisila, e Saimon (nang tobo tengen ine me Pita) ma tönö re ine e Endru, e Jems a bak ke Sebedi ma tönö ine e Jon, ");
INSERT INTO bjk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","e Pilip me Batolomiu, e Tomas me Matiu a tene kip takis, Jems a barok ke Alpius, me Tadius, ");
INSERT INTO bjk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon nang toxo tengen bara ine ina Silot, me Judas Iskariot, a tödi nang ixo isik tewe e Jisas kö limine nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Inabo sangaun ma ninöng na, Jisas ixo tile rewe idi arixe mabo tinenge bira: “Ganim a nuan urungan te idi nang kaim bara abo Judeia, ma ganim e mum pa nilaxa xere lagunon te idi abo Samaria. ");
INSERT INTO bjk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Inexalik, moro wan urungan köbo sipsip mee Israel niang toxo tup. ");
INSERT INTO bjk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nang mum mo wan, morobo tenge mina tinenge na: ‘A kingdom möxö watmaep iri lörörö.’ ");
INSERT INTO bjk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mum morobo ölanglanga abo miniset, mum morobo öraru abo minet, mum morobo ömadakdak ewe idi ma lepra, me mum morobo tile ösu abo tano saban. Mum mere kip tataunin ina lölös na xalik e. Me mum kobo kun. Io, mum morobo mana erabaa tataun bölök min. Ma takarabo kun e mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ganim e mum pa xikip pe tuluwok arixe me mum kö kie re mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ganim a xikip pe rat, ma önga man kabise, ma sandel, ma buxo xö nuan te mum, möxösa, ewe i rörön, idi tabo tabaa ine ma lasa nang i sasaxan ulamun. ");
INSERT INTO bjk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nang bara mum mo wan laxa xö önga lagunon bara önga lagunon taxin, mum morobo wawara xö önga tödi deek. Ma morobo kis arixe mine ot nang mum morobo wan lo baling. ");
INSERT INTO bjk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nang bara mum mo wan laxa xö gunon kina tödi, mum morobo seng e God bara a malum irabo kis arixe ma ina tödi. ");
INSERT INTO bjk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ma bara a lagunon i balaure ödeek e mum, a malum pe mum irabo mana kis deek ee. Ma nang bara tokobo balaure ödeek e mum, mum morobo kip lo öbaling a malum pe mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nang bara re öng i kobo öga e mum bara i kobo ölangen abo tinenge re mum, ma nang bara mum ka nuan kalik ina lagunon bara lagunon taxin niang, mum morobo se rewe a kabus kalik abo xexe mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","God irabo ömokorot köba e Sodom me Gomora xö axana bung möxö warkurai. Inexalik a ömokorot möxö ina lagunon nang kaim kö öga lo e mum, irabo taxin köba xö ömokorot te idu. ");
INSERT INTO bjk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","E tile rewe e mum xarnang a bung sipsip urungan kaluluon köbo wuluwun axe. Möxö ina na, mum morobo mana nanase deek bara morobo önan bule, xarnang a si ibo önan. Ma xarnang a buno i kebeöt tua ögarin te laa, mum morobo mana talien bie bölök. ");
INSERT INTO bjk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Mum morobo balaure ödeek e mum. Idi tabo isik e mum köbo limedi abo tene warkurai, tabo se e mum kölöme xöbo gunon ne sineseng. ");
INSERT INTO bjk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Idi tabo lamus e mum pa tinuu mesila xö warkurai xöbo duöng sisila mabo king kua gene e. Me mum morobo tenge maras se idi, arixe ma a nangadi nang kaim bara abo Judeia, lamun a tinenge deek. ");
INSERT INTO bjk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nang bara idi tabo öxös e mum, ganim bere mum mo dödöm ne binuut bara mum morobo pet te tinenge sa, bara mum morobo tengen bule, möxösa, xö ina bung tabo tabaa e mum ma lasa nang mum morobo tengen. ");
INSERT INTO bjk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Möxö ina na, i kaim im bara mum mo wöwörö, inexalik bara a Töxödös ne Tanono xö Tamana e mum irabo wöwörö kölöme re mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“A nangadi tabo isik abo tönö idi xö minet, ma a tata irabo pet bölök bie xö barok kine. A bung barok tabo baba urungan köbo tamadi mabo nenedi ma tabo tengen ta sesexomet idi. ");
INSERT INTO bjk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A nangadi xirip tabo melentexin e mum, möxösa, xö eseke. Lamun ewe i tuu lölös sik urungan kö xakawöm, God irabo öro ine. ");
INSERT INTO bjk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nang bara te ögarin e mum kö önga xönö, mum morobo ulo urungan kere xönö xabise. Turunon saxit, mum korobo kawam kalik a nilaxa xö boxönö kölöme Israel ma a Barok kö Tödi irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Re bak ne ausu i kobo lömö sik kö tene ausu re ine. Ma kaim pe tene auguran i lömö sik kö orong ke ine. ");
INSERT INTO bjk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Na iri eöt tua abo bak ne ausu rua xarnang a tene ausu re idi, ma a tultul tabo xarnang a orong ke idi. Nang bara a tödi raxin möxö marapun ma tobo tengen ine me Belsebul, ina tano saban, io, tabo tenge ögarin köbanin abo subun te ine! ");
INSERT INTO bjk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Io, ganim e mum pa buburin idi. Möxö a lasa nang te kait pi, irabo tamasawang. Ma a lasa nang i mun sik, irabo ot kö malmalan. ");
INSERT INTO bjk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","A lasa e tengen te mum kö ködö, mum morobo tengen osen kö maras. A lasa te ngunungun min kö talinge mum, mum morobo kup wösö min meriso xö öxöno gunon. ");
INSERT INTO bjk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ganim e mum pa buburin ewe idi nang tabo sexomet a tödi mon, ma lamun tekebeöt tua sexomet abo tanono mum. Inexalik mum morobo mana buburin e nangang nang i eöt tua sexomet a tanono ma tödi bölök kö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma a ulik ne tuluwok mon i eöt ta xukun te nine sigie? Inexalik bara kaim pe öng mere idi irabo subu xö pu xalik abo mamaa xö Tamana e mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Turunon saxit, ma ixoro kos kirip bölök abo bebene öxöno e mum. ");
INSERT INTO bjk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Io, ganim e mum pa binuut, möxösa, a to re mum i taxin sik köbo sigie. ");
INSERT INTO bjk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ewenene niang i tenge maras kö wawara xö nangadi lamun e, e rabo ömaras bölök ine xö wawara xö Tata niso lömö. ");
INSERT INTO bjk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lamun ewe niang i öös tewe e xö wawara xö nangadi, e rabo öös tewe bölök ine xö wawara xö Tata niso lömö. ");
INSERT INTO bjk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mum bele nunu bere e ot ta uxis a malum kö öxöno lagunon. Kaim. E kobo ot ta uxis a malum. Inexalik e ot tua isik a use möxö inarse. ");
INSERT INTO bjk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","E ot bara “‘a barok irabo tuu talu a tata, a balik kalik a nene, ma bara a nine une tamasik tabo tuu talu idu iat. ");
INSERT INTO bjk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ma abo iuo xö önga tödi, idi möxö ina barama re ine iat.’ ");
INSERT INTO bjk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ewenene re öng niang i mamaa xöba lamun a tata ma nago re ine, i kebeöt ta mumuu e. Ewenene re öng niang i mamaa xöba lamun a barok ma balik ke ine, i kebeöt ta mumuu e. ");
INSERT INTO bjk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me ewenene re öng niang i kobo sölök a sölöxöröp pe ine ma i kobo mumuu e, ine i kebeöt ta ais se e. ");
INSERT INTO bjk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ewe nang i parasiwin a to rine, irabo ömalim tewe, ma ewe nang i ömalim tewe a to re ine rua gene e, irabo pere wösöt lo a to runon. ");
INSERT INTO bjk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Me ewe niang i ömaraxen lo e mum, i ömaraxen lo e, me ine ewe niang i ömaraxen lo e, i ömaraxen lo a öng niang ixo tile e. ");
INSERT INTO bjk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ewenene niang i ömaraxen lo a propet, möxö ine a propet, irabo ömaraxen lo a xinixun möxö propet. Me ewenene niang i ömaraxen lo a tödi töxödös, möxösa, ine a tödi töxödös, ma irabo ömaraxen lo a xinixun möxö tödi töxödös. ");
INSERT INTO bjk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma niang bere re öng i isik ke ari sisii urungan kere önga maris na, möxösa, ine a tene tinörön te e, turunon saxit, irabo kip a xinixun möxönan.” ");
INSERT INTO bjk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Melamu Jisas ixo öxawam abo tinenge urungan köbo sangaun ma ninöng ne bak ne ausu rine, ine ixo wan lo meringan tua usu ma palas tinenge xöbo lagunon mee Galili. ");
INSERT INTO bjk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Io, niang Jon a tene baptais ixo ölangen kö gunon ne aömokorot a lasa niang e Krais ixo wewet, ixo tile abo bak ne ausu rine ");
INSERT INTO bjk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","rua ose ine bira: “E nöngön mon ina tödi nang mem me xixiset bara irabo wanot, bere mem marabo kis xiset te öng kabise?” ");
INSERT INTO bjk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas ixo balu, “Mum moro baling, ma moro ömaras e Jon ma lasanene nang mum mo ölangen ma mo pere, ");
INSERT INTO bjk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","baraabo pulo tere wawara, ma abo pengpeng tere önan, idi nang ma lepra idi tere deek, idi nang abo talinge baa tere ölöngö, ma abo minet tere taru baling, ma a tinenge deek iri maras sö idi nang a lak maris. ");
INSERT INTO bjk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","A tödi a nunu re ine i kobo tawes xalik e, irabo deek kö ine.” ");
INSERT INTO bjk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nang abo bak ne ausu re Jon toxo önan, io, Jisas ixo urulo ra tinenge xö marakörö lamun e Jon bira, “Mum moxo wan su urso xö xönö tataun tua werwere a lasa? I xarniang a puru niang a xiki ibo wawaxat elin nanin ine? ");
INSERT INTO bjk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nang bara kawaim, ma lasa mum moxo wan su rua werwere? A tödi niang ixo sige sik a man mamaran? Kawaim. Idi nang ewe tobo sige sik abo man mamaran, idi tobo xisixis kö gunon ne orong. ");
INSERT INTO bjk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma a lasa mum moxo wan su rua werwere? A propet? Turunon saxit, me ine i taxin sik köbo propet. ");
INSERT INTO bjk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ine mon ina öng niang toxoro geet ulamun: ‘E rabo tile re tene kip tinenge re e mesila re nöngön, ewe nang irabo tagure a ngas se nöngön mesila re nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Turunon saxit, kaluluonin idi nang abo nene idi te kip idi, kaim pe öng iri wanot nang i taxin köba re Jon. Inexalik ewe a öng i lik köba kölöme xö kingdom möxö watmaep, ine i taxin köba re Jon. ");
INSERT INTO bjk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Meringan köbo bung ke Jon a tene baptais, ot nixinen, a kingdom möxö watmaep ixo wanot ma lölös taxin, mabo tene ngangaran idi tabo uruoxe lo ine. ");
INSERT INTO bjk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Möxö abo propet kirip mabo warkurai te Moses toxo rengrengen osen lamun ina kingdom ot kö ina axana bung ke Jon. ");
INSERT INTO bjk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma nang bara mum mo mamaa rua ömaraxen lo ine, ine e Elaija niang toxo tengen bara irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ewe nang ine ma talingine, ine irabo ölangen. ");
INSERT INTO bjk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ma a lasanene nang arabo öt ma marakörö mee nixinen? Idi te xarnang abo barok lixilik niang te kisisik kölöme xö xönö möxö misik ma te xukuwe abo ais se idi: ");
INSERT INTO bjk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Mem me maas a koo rö mum, ma lamun mum kobo ririe. Mem me sö ma sinö marmaris, ma lamun mum kobo gegee.’ ");
INSERT INTO bjk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Möxö Jon ixo ot ma ixo ölölö ma kaim ine ra ininim pe wain, me idi toxo tengen bara, ‘A tano saban iri tup pe ine.’ ");
INSERT INTO bjk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A Barok kö Tödi ixo ot ma ixo an ma ixo inim, me idi toxo tengen bira, ‘Ina tödi na a an sasaxa ma a tene ininim, me ine ibo ais arixe mabo tene kip takis ma “nangadi saban.” ’ Idi tobo rengrengen bira, ma lamun a inone nanase re God i öturunon bara i töxödös ina nanase na.” ");
INSERT INTO bjk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Io, Jisas ixo urulo ra lalaie xöbo lagunon taxin niang ixoro pet a oleleng ne lalaa lölös ne auwuwus könan, möxösa, kaim idi xo dinödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“A maris se mum mee Korasin! A maris se mum mee Betsaida! Niang bara abo lalaa lölös ne auwuwus nang e xo pet tö mum, texere pet bölök ki Tair ma Saidon, idi texere sige abo xönö man biling ma texere urup idi ma xako rua osen bere idi tere dödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ma lamun e tengen te mum, God irabo pet a warkurai taxin kö nangadi mee Tair me Saidon kö axana bung möxö warkurai. Ma lamun irabo pet a warkurai nang i taxin köba re mum abo Betsaida mabo Korasin. ");
INSERT INTO bjk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Me mum mee Kaprenaum, mum bele döxömen bara tabo ii öxaa e mum urso lömö. Kaim, mum morobo wan su arixe uri xö pu xö xönö möxö minet. Nang bara abo lalaa lölös ne auwuwus niang e xo pet te mum, texere pet bölök ki Sodom, io, a nangadi mee Sodom texere xisixis iat ot kö ina bung. ");
INSERT INTO bjk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma lamun e tengen te mum, God irabo pet a warkurai taxin kö nangadi mee Sodom kö axana bung möxö warkurai. Ma lamun irabo pet a warkurai nang i taxin saxit tö mum.” ");
INSERT INTO bjk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Xö ina axana bung niang Jisas ixo tengen, “E ölet nöngön, Mama, a Orong möxö balana kubu ma öxöno lagunon, möxösa, nöngön u xo umungen abo lalaa na xalik a nangadi nanase ma u xo osen öwösö re idi nang kaim idi ma nanase. ");
INSERT INTO bjk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mee, Mama. U xo pet bie, möxö i mumuu a mamaa re nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“A Tamake ixo tabaa e mabo lalaa xirip. Kaim pe öng i ösöxö a Barok, ma lamun a Tamake xalik mon, ma kaim pe öng i ösöxö a Tamake, ma lamun a Barok kalik mon arixe me idi ewe nang a Barok ixo pere kos lo rua öwösö e Tamana urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mum kirip niang a xinixip i uban e mum, mum moro ot pösöt e, me e rabo ömamas e mum. ");
INSERT INTO bjk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mum moro sösölök lo xö anaxip pe e, me mum moro kip eusu mere e, möxösa, a balake a lak malum me e bo ii ösu e iat bölök, me mum moro kip mamas kö to re mum, ");
INSERT INTO bjk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","möxösa, a anaxip pe e i malus ma a xinixip pe e i wawaxan.” ");
INSERT INTO bjk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kö ina axana bung nang, Jisas arixe mabo bak ne ausu rine toxo wan kaluluonin a komo wit kö bung Sabat. Abo bak ne ausu rine toxo irilöng ma toxo pit köröp lo a xurxurno wit ma toxo en. ");
INSERT INTO bjk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nang abo Parasi toxo pere biringan, toxo tengen te ine, “Pere bang! Abo bak ne ausu re nöngön, idi te pet bira, idi tokobo mumuu a warkurai möxö bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Io, Jisas ixo balu, “Mum moxoro kos abo laa mesila nang e Dewit ixo pet nang ine ixo irilöng arixe mabo duöng nang toxo wan arixe mine. ");
INSERT INTO bjk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","E Dewit ixo wan laxa xö gunon te God, me ine ma nangadi re ine idi toxo en a beret nang tobo tabaa e God min. Mabo warkurai te Moses i tengen bara i kobo töxödös sö idi ra wewet, abo pris kalik mon. ");
INSERT INTO bjk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Me mum moxoro kos kölöme xö warkurai te Moses bara xö Sabat abo pris tobo rörörön kölöme xö gunon lotu raxin me idi tobo lexe a bung Sabat me idi te langlanga sik kalik abo warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na e tengen te mum, a öng nang i taxin saxit kalik a gunon lotu raxin ine na. ");
INSERT INTO bjk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A tinenge re God i tengen bira, ‘E mamaa bara mum morobo marse a nangadi, me e kobo mamaa lamun abo arabaa nang mum bo wewet.’ Nang bere mum moxoro ösöxö sik a unine ina tinenge na, mum korobo ömaso idi ewe nang kaim idi xo wewet te magingin saban. ");
INSERT INTO bjk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Möxö a Barok kö Tödi i kure sik a bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas ixo wan lo xalik ina xönö, ma ixo wan laxa kölöme xö gunon ne sineseng ke idi, ");
INSERT INTO bjk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","a önga tödi ma lime met nangen nang. Ma toxo wawara siwin te unine laa ra wupuk e Jisas, idi toxo ose ine, “I töxödös bara tabo ölanglanga a tödi miniset kö Sabat bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ixo tengen te idi, “Nang bara nöngön mere önga sipsip ma i subu su xö mara xö Sabat, a turunon bara örobo tön öxaa ine xalik a mara. ");
INSERT INTO bjk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mum mo maras kö dinödöm pe God, bara mum mo taxin sik kö sipsip! Io, i töxödös bara ire tabo pet a tinörön deek kö Sabat.” ");
INSERT INTO bjk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Io, ixo tengen kö tödi, “Sasanga kaa ma limem.” Io, ine ixo sasanga kaa ma limine, ma a limine ixo deek baling xarnang a limene xabise. ");
INSERT INTO bjk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Lamun abo Parasi toxo wan lo ma toxo wingwingit tua wewet te ngas sa sesexomet e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas ixo ösöxö xöröp ina na, ixo tawes möxö ina xönö. Ma oleleng toxo muu ine, me ine ixo ölanglanga a nangadi miniset kirip pe idi. ");
INSERT INTO bjk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ixo tenge wanak idi rua ganim a rengrengen osen bara ewenene ine. ");
INSERT INTO bjk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ina na rua öturunon a lasa God ixo tenge min kö propet Aisaia bira: ");
INSERT INTO bjk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ine na a tultul te e, ewe nang e xoro pere kos lo ine, a öng e mamaa lamun, ma irabo öaxanan e. E rabo uxis a Tanoke re ine, me ine irabo osen a ngas töxödös se e urungan kö nangadi möxö öxöno lagunon kirip. ");
INSERT INTO bjk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ine i karabo tenge samuk mere öng ma i karabo eöt tua kinup. Kaim pe öng irabo ölangen a inöno kölöme xöbo ngas lixilik. ");
INSERT INTO bjk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I karabo dulok ke xurxuruno iaa i tamado sik, ma i karabo mas ömet a laam i xeka minet, ot nang irabo silien a warkurai töxödös sua wawas ösu a sasaban. ");
INSERT INTO bjk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abo marapun kirip kö öxöno lagunon tabo bulus a dinödöm pe idi xö esene, bara irabo tabaa idi ma kinis deek.” ");
INSERT INTO bjk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Io, idi toxo isik ot a tödi, ine ma tano saban ma ixo marapulo ma a ngalaböt ine, me Jisas ixo ölanglanga ine, ma ixo eöt tine rua tinenge ma rua winawara baling. ");
INSERT INTO bjk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A nangadi xirip toxo wuwus saban ma toxo tengen, “Xalik ine gut a Barok kö marapun te Dewit?” ");
INSERT INTO bjk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma lamun nang abo Parasi toxo ölangen bira, toxo tengen, “Ine e Belsebul, a sisila möxöbo tano saban mon, ewe nang ibo tabaa ina tödi na ma lölös sa xikip tewe abo tano saban.” ");
INSERT INTO bjk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas ixo ösöxö abo dinödöm pe idi ma ixo tengen te idi, “Nang bara re kantri i kobo tuu arixe me idi iat, a dauleng mere idi tabo pet ögarin kirip ina kantri. Ma nang bara a lagunon, bara a barama, tekobo tuu arixe, idi kebeöt ta kinis deek. ");
INSERT INTO bjk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nang bara a nangadi re Satan te kip tewe öbaling idi iat, tabo subu. Idi tekebeöt tua tinuu lölös. ");
INSERT INTO bjk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mum iat mo köbo döxömen bara a nangadi re mum tobo xikip tewe abo tano saban kö lölös se Belsebul. Möxö ina na, mum mo köbo eöt tua tengen bere e bo xikip tewe abo tano saban kö lölös se Belsebul. Io, a nangadi iat te mum, tabo osen bere abo tinenge re mum i kobo turunon. ");
INSERT INTO bjk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kaim. Ma lamun e bo xikip tewe abo tano saban ma lölös möxö Tanono e God. Ma ina na i öturunon bara a kingdom kö God ixoro wan pösöt e mum. ");
INSERT INTO bjk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ma bara, irabo ot bule nang ke önga tödi i eöt ta wörwörök ölaxa re gunon kere önga tödi lölös ma irabo pulo rewe abo lalaa re ine nang bara i kala kut dik bang ina tödi lölös? Ma melamu irabo wuwulo xö ina gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Me ewe nang i kobo ais me e, i mölök kalik e. Ma ewe nang i kobo rörön arixe me e ra lalamus etok a nangadi, ine ibo waswasak a nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Möxö ina na, e tengen tö mum, God irabo kip tewe abo magingin saban möxö nangadi, ma nang bara te töxö ögarin önga tödi, irabo döxömen taun ine bölök, ma lamun ewe nang i tengen ögarin a Töxödös ne Tanono, God i karabo döxömen taun ine. ");
INSERT INTO bjk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ewe a öng i tengen ögarin a Barok kö Tödi, God irabo döxömen taun a magingin tine, ma lamun ewe a öng nang i tengen ögarin a Töxödös ne Tanono, God i karabo döxömen taun a magingin tine xö ina to na ma melamu bölök. ");
INSERT INTO bjk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nang bara a uno iaa i deek, a pasuno irabo deek. Ma bara a uno iaa i saban, a pasuno irabo saban, möxösa, tabo perexulen a uno iaa xö inone. ");
INSERT INTO bjk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mum mo xarnang abo si saban. Mum abo tene saban, morobo eöt ta tengen tebo lalaa deek bara bule? Mum kebeöt, möxösa, a tödi ibo tengen ösu abo lalaa i wöwö sik kö balana. ");
INSERT INTO bjk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A tödi deek ibo isik ot a lalaa deek nang i wöwö sik kö to rine. Ma a tödi saban ibo isik ot a lalaa saban nang i wöwö sik kö to re ine. ");
INSERT INTO bjk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lamun e tengen te mum bara xö bung möxö warkurai, a nangadi tabo mana tengen osen abo tinenge saban idi toxoro tengen. ");
INSERT INTO bjk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Io, God irabo kure nöngön köbo tinenge xirip pe nöngön, ma irabo tengen te nöngön bara örobo langlanga bara örobo kip a kinadik ke nöngön kö warkurai.” ");
INSERT INTO bjk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Io, dauleng ne Parasi arixe mabo tene ausu möxöbo warkurai te Moses toxo tengen te ine, “Tene Ausu, mem me mamaa rua werwere a mangana auxileng meringan te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ine ixo balu idi, “Xöbo bung nixinen a marakörö te mamaa bara e rabo pet te uxileng lölös, möxösa, idi tobo ruruu rewe xalik e God ma tobo saban esexere! Ma lamun e rabo isik a auxileng kö propet Jona xalik mon urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Möxö Jona ixo kis kö narun ne bung ma narun ne dömön kö balana en taxin, ma xarnang mon bölök, a Barok kö Tödi irabo kis narun ne bung ma narun ne dömön bölök kölöme xö balana öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma xö bung möxö warkurai, a nangadi mee Niniwe idi tabo puk e mum, möxösa, idi toxo dödöm puxus nang e Jona ixo palas tinenge urungan te idi. Ma na, a öng nang i taxin sik kidu me Jona i nangen na. ");
INSERT INTO bjk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma xina bung möxö warkurai, a kwin mee Siba, irabo puk e mum, möxösa, ixo wanot mero xö ngusuno öxöno lagunon tua ölangen a nanase re Solomon. Ma na, a öng nang i taxin sik ke idu me Solomon i nangen na. ");
INSERT INTO bjk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nang bara re tano saban i wan su xalik a tödi, ibo önan eli xirip kö boxönö masa, bara rua mamas, nexalik bara i kara parasiwin te xönö. ");
INSERT INTO bjk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Io, ibo tengen bira, ‘E rabo tawuxus baling urungan kö ngasiene e niang e xo wan lie.’ Ma nang i wanot uxe, irabo pere bara kaim pe öng könan, ma toxoro soso ma toxoro tagur bulus sik. ");
INSERT INTO bjk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ma irabo wan lo ma irabo lamus öbaling a pitnö ma ninöng ne tano saban kabise arixe mine, me idi te saban köba re ine. Me idi tabo wan laxa ma tabo kis im ee. Ma to xina tödi irabo saban köba xö nang sila. Ma irabo xarnang bie xö marakörö saban möxö axana bung nixinen.” ");
INSERT INTO bjk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nang e Jisas angen ixo wöwörö urungan kö marakörö, a nago mabo tönö rine toxoro tuu sik kö araman, ma toxo mamaa rua tinenge rö ine. ");
INSERT INTO bjk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Io, önga tödi ixo tengen te ine, “A nago re nöngön mabo töm te tuu sik ni xö araman, te mamaa rua tinenge me nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas ixo balu ine, “E rabo tengen ösu bara ewe a nago re e, ma ewe abo töke.” ");
INSERT INTO bjk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ixo susulut urungan köbo bak ne ausu rine, ma ixo tengen, “Idi na abo nago mabo töke. ");
INSERT INTO bjk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Möxö ewenene i mumuu abo lasanene nang a Tamake niso xö watmaep i mamaa bara irabo pet, ine a töke, a saxake ma a nago re e.” ");
INSERT INTO bjk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Xö ina bung iat niang e Jisas ixo wan kalik a gunon ma ixo kis kö gegene tu Galili. ");
INSERT INTO bjk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A marakörö raxin toxo ot etok elulurwein ine, io, ine ixo kakaa laxa xö mön nang kö tu, ma marakörö toxo tuu lömö xö marna bisbise. ");
INSERT INTO bjk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Me ine ixo töngösen idi ma oleleng ne lalaa xö tinenge öwuo. Ixo tengen bara, “A önga tödi ixo wan tua retewe abo irine wit kö komo. ");
INSERT INTO bjk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma nang ine ixo retewe nanin abo irine wit, a dauleng toxo subu melamu xö ngas, ma bung pun toxo wanot ma toxo en idi. ");
INSERT INTO bjk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma dauleng ne irine wit toxo subu xö öxöno wat nang kaim pe pu oleleng könan. A irine wit ixo das kaa pasaxit mon, möxösa, a pu ixo wöwöt. ");
INSERT INTO bjk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma xaken ixo tuu, ixo dek abo wit ma ixo mölös ma ixo met, möxösa, abo buon kaim kö sinu xöba uri xö pu. ");
INSERT INTO bjk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dauleng ne irine wit toxo subu kaluluonin abo gargaras. Ma abo gargaras toxo pari abo wit nang i dadas kaa. ");
INSERT INTO bjk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lamun a uleng ne irine wit toxo subu xö pu deek. Dauleng toxo taxin ma toxo o eöt ma önga mar ne irine, dauleng toxo pitnö ma öng ne sangaun, ma dauleng toxo eöt ma narun ne sangaun ne irine wit. ");
INSERT INTO bjk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ewe nang ine ma talingine, ine irabo mana ölangen.” ");
INSERT INTO bjk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abo bak ne ausu toxo wanot pösöt ine ma toxo ose ine, “Ruasa u bo rengrenge rö idi xö tinenge öwuo?” ");
INSERT INTO bjk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ixo balu, “God ixoro tabaa e mum ma nanase möxöbo pidik möxö kingdom möxö watmaep, ma kaim bere re idi. ");
INSERT INTO bjk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ewenene midi nang idi ma lalaa, God irabo tabaa idi ma oleleng, me idi tabo kip a oleleng bölök. Me ewenene midi nang kawaim idi mere lalaa, God irabo kip tewe bölök kirip abo lalaa xalik idi. ");
INSERT INTO bjk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","E bo rengrenge rö idi xö tinenge öwuo, möxösa, ‘Idi tabo wawara, lamun idi tekebeöt ta werwere xulen te laa, me idi tabo ölöngö, ma lamun idi tekebeöt ta ölangen kulen. ");
INSERT INTO bjk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Idi te öturunon a tinenge re propet Aisaia ixo tengen bira: “Mum morobo ölangen ma ölangen, ma lamun mum korobo ölangen kulen te laa, me mum morobo wawara ma wawara, lamun mum korobo perexulen te laa, ");
INSERT INTO bjk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","möxösa, ina nangadi na te ölölös a baladi. Me idi te mölök ka ölöngö ma talingine idi, me idi te baxut abo maradi, xalik idi texere perexulen mabo maradi, ma texere ölangen kulen mabo talingedi, ma texere ösöxö xulen kölöme xö baladi, ma texere dödöm puxus, me e xere öro idi.” ’ ");
INSERT INTO bjk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma lamun irabo deek kö mum, möxösa, abo mara mum tobo wawara xulen me mum bo ölangen kulen ma talingine mum. ");
INSERT INTO bjk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Möxö i turunon saxit, oleleng ne propet ma nangadi töxödös toxo mamaa rua werwere a lasa mum mo werwere, ma lamun idi kaim kö werwere. Me idi toxo mamaa rua ölangen a lasa mum mo ölangen, ma lamun kaim idi xo ölangen. ");
INSERT INTO bjk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ölöngö deek, kö lasa a tinenge öwuo möxö tene susulo i tengen bie: ");
INSERT INTO bjk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bara ewe nang i ölangen a tinenge lamun a kingdom ma i kobo nanase xönan, a tene sasaban ibo ot ma ibo irewe a nang toxoro sulo kölöme xö balana ine. Ma na ina irine iaa nang te retewe nanin kö ngas. ");
INSERT INTO bjk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma öng ewe nang i kip lo a irine iaa nang ixo subu lömö xö pu warawat, ine ina tödi nang i ölangen a tinenge ma pasaxit mon i axanan tua xikip lo. ");
INSERT INTO bjk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma lamun ixo tuu ulik mon, möxösa, kaim ine ma buon. Nang bara tiip bara sasaban i ot möxö ine i kip sik ina tinenge, ma saxit mon irabo wan tewe. ");
INSERT INTO bjk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma ewe nang i kip lo a irine wit i subu kaluluon köbo gargaras, ine a tödi ewe i ölengen a tinenge, ma lamun i döxömen köbanin abo lalaa möxö öxöno lagunon, ma i mamaa lamun a kinis ne orong nang ibo röxröxö rewe ine. Inabo lalaa ibo wewet pi a tinenge re God, ma i kobo eöt ta o re pasuno iaa. ");
INSERT INTO bjk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lamun ewe a öng nang i kip lo a irine wit i subu xö pu deek, ine a tödi ewe i ölengen a tinenge ma i xikip a nanase xönan. I o a pasuno. Dauleng tabo o a önga mar ne irine wit, dauleng ma pitnö ma öng ne sangaun ne irine wit, ma dauleng ma narun ne sangaun ne irine wit.” ");
INSERT INTO bjk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ixo töngösen idi ma önga tinenge öwuo xabise: “A kingdom möxö watmaep i xarnang a tödi nang ixo sulo a irine iaa deek kö komo re ine. ");
INSERT INTO bjk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma lamun nang idi xirip toxo paliso, a iuo re ine ixo ot ma ixo sulo a pirixö lixilik kaluluonin abo irine iaa deek, ma ixo wan. ");
INSERT INTO bjk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nang abo irine iaa deek ixo das ma ixo o a irine, a pirixö bölök ixo das. ");
INSERT INTO bjk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Abo tene tinörön möxö tamana komo toxo wanot urungan te ine ma toxo ose ine, ‘Asuono orong, nöngön u xo sulo a irine iaa deek kö komo re nöngön. Mabo pirixö na te wanot mole?’ ");
INSERT INTO bjk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ixo balu, ‘A iuo i pet a na.’ “Abo tene tinörön toxo ose ine, ‘Ma u mamaa bara mem mara wan ma mara xaxat tewe?’ ");
INSERT INTO bjk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ine ixo balu, ‘Kaim, möxösa, xalik e mum bo xaxat arixe ma irine iaa deek. ");
INSERT INTO bjk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ganim idu tabo das arixe mon ot nang a iaa deek irabo maruxo. Io, xö ina axana bung niang, arabo tengen kö tene kip nien bara idi tabo arun tua ii lo abo pirixö ma tabo kubus köbo wöxön tua söngsöngöt. Ma nang a irine iaa deek tabo iiögun kirip ma tabo bulus idi uri xö gunon mataxen te e.’” ");
INSERT INTO bjk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Io, ixo töngösen idi ma önga tinenge öwuo xabise: “A kingdom möxö watmaep i xarnang a irine iaa nang a tödi i kip lo ma ixo sulo xö komo re ine. ");
INSERT INTO bjk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Turunon, i lik köba xöbo irine iaa xirip pe mum, nexalik nang ibo das kaa, ibo taxin köba ma ibo saxit kirip abo iaa kölöme xö komo, io, abo pun meriso lömö xö mango te ot ma te pet abo wöwösö re idi xöbo axana.” ");
INSERT INTO bjk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ixo töngösen idi ma önga tinenge öwuo xabise bölök: “A kingdom möxö watmaep i xarnang a is nang önga une ixo kip lo ma ixo bulus arixin ma plawa oleleng ot nang irabo ebobot.” ");
INSERT INTO bjk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas ixo tenge mabo lalaa xirip urungan kö marakörö xö tinenge öwuo. Ine ixobo wöwörö xö marakörö mabo tinenge öwuo xalik mon. ");
INSERT INTO bjk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Io, a na rua öturunon a lasa abo propet toxo etöngösen min: “E rabo sawang a ngalake xöbo tinenge öwuo, me e rabo tengen ösu abo lalaa nang ixo mun sik meringan kö urulo möxö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Io, Jisas ixo wan lie a marakörö ma ixo wan laxa xö gunon. Abo bak ne ausu rine toxo ot urungan tine ma toxo tengen, “Örö palas ina tinenge öwuo möxö pirixö kölöme xö komo ura re mem.” ");
INSERT INTO bjk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ixo balu idi, “Ewe nang i sulo a irine iaa deek, ine a Barok kö Tödi. ");
INSERT INTO bjk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A komo, ine a öxöno lagunon. Ma irine iaa deek, i eöt mabo baroxorok möxö kingdom. Ma pirixö, idi abo baroxorok möxö tene sasaban. ");
INSERT INTO bjk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma iuo ridi, ewe niang ixo sulo idi, e Satan. A bung möxö xaxaxat, ine a axana bung möxö xakawöm. Ma nangadi nang tabo xaxat, abo angelo. ");
INSERT INTO bjk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“A axana bung möxö xakawöm, irabo xarnang nang tabo xaxat inabo pirixö ma tabo söngöt kö ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","A Barok kö Tödi irabo tile abo angelo rine, me idi tabo xaxat tewe abo tene sasaban arixe mabo lalaa xirip möxö kingdom niang a nangadi tobo susubu xönan. ");
INSERT INTO bjk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Idi tabo tewe idi urungan kö ia sösöt niang i lelewi, ma ringan ee idi tabo gegee ma tabo engiren abo ngisine idi. ");
INSERT INTO bjk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Io, xina axana bung abo tene töxödös tabo bio xarnang a xaken tiso xö kingdom kö Tamana idi. Me ewe ine ma talingine, ine irabo mana ölangen. ");
INSERT INTO bjk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A kingdom möxö watmaep i xarnang a önga laa deek niang toxo umingen kö önga komo. Ma nang a önga tödi ixo pere wösöt lo, ine ixo umingen öbaling, ma xö axanan tine ixo wan ma ixo misik tewe mabo lalaa rine ma ixo kun ina xönö komo. ");
INSERT INTO bjk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Io, a kingdom möxö watmaep i eöt ma önga tödi, a tene xinixun, i wawara siwin abo karalo ne kalang niang a lak deek. ");
INSERT INTO bjk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Io, nang bara ine i pere lo re öng niang i deek köba, ine ibo wan lo ma ibo misik tewe mabo lalaa xirip pine ma ibo kun lo ina karalo ne kalang. ");
INSERT INTO bjk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ma a kingdom möxö watmaep i eöt ma eben niang toxo öriri ösu uri xö könönö rasi ma abo mangana inan kirip tobo tamake xönan. ");
INSERT INTO bjk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Io, niang bara i wöwö, abo tene öxönöm tobo sat öxaa urungan kö löxön. Io, idi tobo kis kö pu ma tobo ilo xirip niang abo inan deek urungan köbo rat, nexalik niang a lak saban tabo tewe rewe. ");
INSERT INTO bjk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ma irabo xarna na bölök kö axana bung möxö xakawöm. Abo angelo tabo wanot ma tabo palang tewe abo tene sasaban kalik abo tene töxödös. ");
INSERT INTO bjk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma tabo tewe idi urungan kö könönö ia sösöt. Ma ringan ee idi tabo gegee ma tabo engiren abo ngisine idi.” ");
INSERT INTO bjk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Me Jisas ixo ose idi, “Mum mo maras ulamun abo lalaa xirip na?” Me idi toxo balu ine, “Mee.” ");
INSERT INTO bjk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Io, ine ixo tengen tö idi, “Io, abo tene ausu xirip möxöbo warkurai te Moses ewe idi toxoro eusu ulamun a kingdom möxö watmaep i eöt ma a tamana gunon ewe ibo ikip ösu abo lalaa deek meringan kö bubulus se ine, niang a lak maxat ma niang a lak maut bölök.” ");
INSERT INTO bjk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Io, niang bere Jisas ixoro öxöwöm inabo tinenge öwuo, ine ixo wan kalik ina xönö. ");
INSERT INTO bjk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ine ixo wanot urungan kö lagunon tine, ma ixo urulo ra usu a nangadi kölöme xö gunon ne sineseng ke idi, me idi toxo wuwus saban. Me idi toxo ose bira, “Ina tödi na i kip lo ina nanase ma lölös na mole? ");
INSERT INTO bjk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ine mon ina bak kö tene pet gunon. Ma a nago rine a esene e Maria, ma abo tönö rine e Jems, Josep, Saimon me Judas. ");
INSERT INTO bjk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mabo saxana ine nangen na me ire. Io, ine i kip lo inabo lalaa xirip mole?” ");
INSERT INTO bjk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Me idi toxo mölök kalik ine. Ma lamun e Jisas ixo tengen tö idi, “Xöbo lagunon kabise a nangadi tobo ii öraxin a propet. Inexalik kö lagunon iat tine ma kölöme xö gunon tine ina propet niang tokobo ii ine.” ");
INSERT INTO bjk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Me ine kaim a wewet te oleleng ne lalaa lölös ne auwuwus singan, möxösa, kaim idi xo nunu. ");
INSERT INTO bjk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Xö ina axana bung e Erot a tödi raxin mee Galili ixo ölangen abo lalaa ulamun e Jisas, ");
INSERT INTO bjk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","me ine ixo tengen köbo tene tinörön te ine bara, “E Jon a tene baptais ine mon e Jisas. Ine ma lölös taxin tua wewet abo lalaa ne winiwus lölös, möxösa, ine iri taru baling kalik a minet.” ");
INSERT INTO bjk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Io, Erot ixoro tile tuar a dauleng ne nangadi ra öxös lo e Jon bara tabo bulus ine xö gunon ne aömokorot tua gene e Erodias a une re tönö ine, nang e Pilip, ");
INSERT INTO bjk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","möxösa, Jon ixobo rengrengen te Erot bara, “I kobo töxödös bara örobo elolo lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Io, Erot ixo mamaa ra sesexomet e Jon, ma lamun ine ixo buburin a nangadi, möxösa, idi toxo pere ine bara a propet. ");
INSERT INTO bjk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Xö ina bung ka uxileng a bung nang a nago re Erot ixo kip ine, a balik ke Erodias ixo tie re idi ma ixo öaxanan köbanin e Erot, ");
INSERT INTO bjk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","io, ixo eusugurno bara irabo tabaa ine mabo lalaa xirip niang i ose ulamun. ");
INSERT INTO bjk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Io, Erodias, a nago xö ina balik, ixo tengen kö balik bara irabo seng ke lasanene xalik e Erot. Io, a balik ixo tengen bara, “Örö tabaa e ma öxöno e Jon a tene baptais kö bile.” ");
INSERT INTO bjk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Me Erot ixo tapunuk, ma lamun ine ixo tengen bara tabo pet eörin, möxösa, ixoro usugurno sila xö ölöngö xöbo osee. ");
INSERT INTO bjk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma toxo tee xöröp lo a öxöno e Jon kölöme xö gunon ne aömokorot. ");
INSERT INTO bjk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A öxöno toxo kip ölaxa xö bile ma toxo isik urungan kö balik, me ine ixo kip urungan kö nago re ine. ");
INSERT INTO bjk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Abo bak ne ausu re Jon idi toxo wanot, ma toxo kip lo a lewene aine e Jon ma toxo bulus kö maöt. Io, idi toxo wan ma toxo tengen te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ma nang e Jisas ixo ölangen bere Jon ixoro met, ine ixo wan lo meringan kö mön arixe mabo bak ne ausu re ine me idi xalik mon toxo wan urungan kö xönö tataun. Nang a nangadi toxo ölangen a na, a marakörö raxin toxo muu ine möxöbo lagunon taxin. ");
INSERT INTO bjk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma nang e Jisas ixo ösö, ixo pere a marakörö raxin, ma ixo marase idi ma ixo ölanglanga abo miniset te idi. ");
INSERT INTO bjk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma nang ixoro aien, abo bak ne ausu toxo wanot pösöt ine ma toxo tengen, “Ina xönö na a xönö tataun ma iri aien sumara xoxo. Örö tile rewe a marakörö na. Me idi ta wan urungan köbo lagunon, ma ta kun nien te idi.” ");
INSERT INTO bjk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisas ixo tengen, “Idi takarabo wan. Mum iat, mum moro tabaa idi merebo lalaa rua enen.” ");
INSERT INTO bjk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Idi toxo tengen, “Mem angen ma pitnö ne beret ma nini inan.” ");
INSERT INTO bjk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Io, ine ixo tengen, “Mum moro kip ura re e.” ");
INSERT INTO bjk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma ixo tengen kö nangadi rua kinis su xö pasle. Io, Jisas ixo tön lo ina pitnö ne beret ma nini inan ma ixo wawara kaa xö balana kubu, ma ixo tengen deek ke God ma ixo pidik a beret. Ma ixo tabaa abo bak ne ausu min ma abo bak ne ausu toxo tabaa ina marakörö min. ");
INSERT INTO bjk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Me idi xirip toxo an ma toxo masii. Io, abo bak ne ausu toxo tuxo a sangaun ma ninöng ne kölöt mabo subana nien nang idi toxo en paling. ");
INSERT INTO bjk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mabo duöng nang toxo an, ixo eöt ma pitnö ne arip. Ma kaim im kö xokos lo abo une ma bung barok lixilik. ");
INSERT INTO bjk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma saxit mon, Jisas ixo tile öxaa abo bak ne ausu xö mön, bara idi tabo sila re ine uruo xö lawa xabise, me ine bang, irabo tile ebasin a marakörö. ");
INSERT INTO bjk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma nang ine ixo uguran tewe xirip idi, ine xalik mon ixo wan kaa rewe uruso xö maii rua sineseng. Ma nang ixoro sumaraxoxo, ine ixo xisixis ine xalik kingan ee, ");
INSERT INTO bjk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ma lamun ina mön ixoro böxö rewe xö palaa xalik a mesmese, ma rasi ixo raru, möxösa, idi toxo esuo ma xiki. ");
INSERT INTO bjk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Xö lörörö xö pitnö ne axana bung kö puxu bubung, e Jisas ixo önan lömö xö rasi urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nang abo bak ne ausu toxo pere ine ixo önan lömö xö rasi, idi toxo buut saban. Me idi toxo tengen, “A tano ine.” Me idi toxo kup wösö ma binuut. ");
INSERT INTO bjk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma lamun saxit iat mon, e Jisas ixo tengen, “Mum moro balamasa. E mon. Ganim a binuut.” ");
INSERT INTO bjk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita ixo tengen, “Orong, nang bara i turunon bere nöngön mon, örö tengen te e ara wan urungan te nöngön lömö xö ari.” ");
INSERT INTO bjk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas ixo tengen, “Örö miang.” Io, Pita ixo tuu su xalik a mön, ma ixo wan lömö xö ari urungan te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma lamun nang ixo pere a xiki, ixo buut, ma ixo eka riririi, ma ixo kup, “Orong, örobo öro e!” ");
INSERT INTO bjk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma saxit mon, Jisas ixo sanga ot ma limine ma ixo tön lo ine. Ixo tengen, “A nunu re nöngön i lik köba. U bele nine dinödöm.” ");
INSERT INTO bjk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma nang idu toxo kaa xö mön, a xiki ixo kawam. ");
INSERT INTO bjk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Io, idi nang toxo xisixis kölöme xö mön toxo lotu wösöt ine, ma toxo tengen, “Turunon saxit, nöngön a Barok kö God.” ");
INSERT INTO bjk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nang idi toxo köröp kö tu, toxo ösö Genesaret. ");
INSERT INTO bjk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma nang a duöng möxö ina xönö toxo perexulen e Jisas, idi toxo tile tinenge xöbo lagunon kirip löröröin idi. A nangadi toxo ot mabo miniset kirip pe idi urungan te ine, ");
INSERT INTO bjk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","me idi toxo tenge marmaris se ine re idi ra rörön mon a ngusuno man te ine, me ewenene idi nang toxo sigi ine toxo langlanga. ");
INSERT INTO bjk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Io, dauleng ne Parasi mabo tene ausu möxöbo warkurai te Moses toxo wanot meriso Jerusalem urungan te Jisas ma toxo ose ine, ");
INSERT INTO bjk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ruasa abo bak ne ausu re nöngön tokobo muu a ausu möxöbo tubuno ire? Idi tekara gilime sila xö nien!” ");
INSERT INTO bjk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas ixo balu, “Ma ruasa mum bo wörwörök a warkurai te God, muu a inausu xöbo tubu mum iat? ");
INSERT INTO bjk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Na e tengen, i eöt iat ma lasa nang e God ixo tengen bira, ‘Nöngön örobo ii a tata ma nago re nöngön,’ me, ‘Ewenene nang i tenge saban kö tamana bere nene, mum morobo sexomet ine.’ ");
INSERT INTO bjk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma lamun mum bölök bo rengrengen bira: Ewe nang ma önga laa rua rorop e tamana bere nene, io, i öt bölök bara ine irabo tengen, ‘E xoro tagur sik kua tabaa e God min. E kebeöt ta tabaa nöngön min tua rorop nöngön.’ Ma nang bara mum mo döxömen bira, ");
INSERT INTO bjk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","io, ine i kebeöt ta ‘ii a tata re ine’ arixe min. Möxö ina na, mum bo döxömen taun a tinenge re God möxö gene inabo inausu re mum nang mum bo xikip kalik abo untubu mum. ");
INSERT INTO bjk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mum a nangadi röxröxö! E propet Aisaia i tengen a turunon lamun e mum, me God ixo tengen bira, ");
INSERT INTO bjk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ina nangadi na, tobo ii öxaa e mabo ngaladi, ma lamun abo kat tidi i kis kö palaa xalik e. ");
INSERT INTO bjk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Idi tobo lolotu tataun te e, möxösa, abo ausu ridi i ot mon möxö nangadi.’” ");
INSERT INTO bjk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Io, e Jisas ixo kuwe a marakörö urungan tine ma ixo tengen, “Mum kirip moro ölangen e, me e mamaa bara mum moro maras. ");
INSERT INTO bjk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaim bara lalaa nang ibo önan laxa xö ngalana tödi ibo ösaban ine, nexalik a lasa nang ibo önan su xalik a ngalana ine, ibo ösaban a tödi.” ");
INSERT INTO bjk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Io, abo bak ne ausu toxo wanot pösöt ine ma toxo ose ine, “Nöngön u ösöxö bara abo Parasi te bala saban niang idi te ölangen ina na u tengen?” ");
INSERT INTO bjk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me Jisas ixo balu idi bira, “Idi te eöt mabo iaa nang a Tamake meriso xö watmaep i kara sulo, ma irabo xaxat öxaa idi ma buon tidi. ");
INSERT INTO bjk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ganim idi! Idi te eöt ma pulo ewe i ka osen a ngas kö dauleng ne pulo xabise. Niang bara önga tödi pulo i silien a tödi pulo, idu xirip tabo subu laxa xö mara.” ");
INSERT INTO bjk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita ixo tengen, “Örö tengen palas ina tinenge öwuo na urö mem.” ");
INSERT INTO bjk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Io, Jisas ixo tengen te idi, “Mum kobola maras bang, a?” ");
INSERT INTO bjk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mum kobo maras kö lasa nang ibo önan laxa xö ngalana tödi ma ibo önan laxa xö balana ire, ma ibo önan su baling? ");
INSERT INTO bjk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Inexalik, abo lalaa nang ibo önan su xalik abo ngalana ire ibo önan su xalik a kat, ma ibo ösaban a tödi. ");
INSERT INTO bjk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","I turunon, möxösa, meringan kölöme xö könönö tödi ibo önan su abo dinödöm saban, a tatalien möxö inarsexomet, a tatalien ne ilawa ma önga tödi alolo, a tatalien pinilo, ma a tatalien ne rengrengen ösu a tinenge röxröxö lamun önga tödi i tuu xö warkurai, ma a tinenge ra ögarin önga tödi. ");
INSERT INTO bjk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inabo lalaa na ibo wewet ösaban a tödi, nexalik bara nang u an ma limem ma u kobo gilime, i kebeöt ta wewet ösaban nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ma nang e Jisas ixo wan lo xalik ina xönö, ine ixo wan lo urungan kö xönö mee Tair ma Saidon. ");
INSERT INTO bjk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Önga une meringan kö bung marapun te Kena ixo wanot pösöt ine, ma ixo kup bira, “Orong, a Barok kö bung marapun te Dewit, örö marase e! A balik lik ke e i esek saban arixe, möxö a tano saban i kis kölöme rine.” ");
INSERT INTO bjk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jisas kawaim a babalu re tinenge. Io, abo bak ne ausu rine toxo wanot pösöt ine ma toxo ose öbaling ine, “Örö uguran tewe ine, möxö ine angen i xukup muu nanin ire.” ");
INSERT INTO bjk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ixo tengen, “E karabo top nöngön. E Mama ixo uguran e urungan kalik mon köbo sipsip mee Israel niang te tup.” ");
INSERT INTO bjk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma ina une ixo wanot, ma ixo subun kexe mesila re Jisas ma ixo tengen, “Orong, örö top e!” ");
INSERT INTO bjk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas ixo tengen, “I kobo töxödös bara ire tabo kip lo a nien kö bung barok ma tabo tewe rabaa a bung puluwun min.” ");
INSERT INTO bjk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma ina une ixo tengen, “A turunon saxit, Orong, ma lamun a bung wuluwun idi tobo enen abo perene nien köbo tamadi nang ibo susubu su xö ene öra.” ");
INSERT INTO bjk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Io, Jisas ixo tengen, “Balik, nöngön ma nunu raxin saxit! E re ömaraxen lo a sineseng ke nöngön.” Ma a balik kine ixo langlanga baling kina axana bung iat mon. ");
INSERT INTO bjk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ixo wan lie a xönö niang ma ixo wan kö gegene tu Galili. Io, ine ixo wan kaa xö önga lawana maii ma ixo kis su ee. ");
INSERT INTO bjk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A marakörö raxin toxo wanot pösöt ine, me idi toxo orot arixe mabo marapulo mabo lime met mabo pengpeng mabo ngalaböt ma oleleng kabise, ma toxo ömarin idi xö xexene ine, ma ixo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma nangadi toxo wuwus saban, möxösa, idi toxo pere abo ngalaböt toxo tenge, mabo lime met toxo deek, mabo pengpeng toxo önan, mabo marapulo toxo wawara. Me idi toxo tenge ölet e God möxöbo Israel. ");
INSERT INTO bjk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas ixo kuwe abo bak ne ausu re ine urungan te ine ma ixo tengen, “E marase a nangadi na idi te kis arixe me e xö narun ne bung tuar ma kaim idi ma nien. E kobo maa ra uguran tewe idi ma te irilöng, xalik idi tobo met saxit kö ngas.” ");
INSERT INTO bjk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mabo bak ne ausu rine toxo tengen te ine, “Ire tekebeöt tua parasiwin tebo beret tua tabaa ina marakörö raxin min, a xönö na a xönö tataun.” ");
INSERT INTO bjk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas ixo tengen, “A nausen ne xönö beret nangen me mum?” Me idi toxo balu ine bira, “Pitnö ma ninöng, ma ulek ne inan lixilik.” ");
INSERT INTO bjk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ine ixo tengen kö marakörö ra kinis kö pu. ");
INSERT INTO bjk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Io, ixo kip lo a pitnö ma ninöng ne beret mabo inan. Ma nang ixo tengen deek kö God ulamun, ixo pidik ma ixo isik köbo bak ne ausu, me idi toxo tabaa a nangadi min. ");
INSERT INTO bjk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Idi xirip toxo an ma toxo masii. Melamu im abo bak ne ausu toxo kip lo a pitnö ma ninöng ne kölöt subana nien nang ixo kis. ");
INSERT INTO bjk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A nangadi niang toxo an i eöt ma nit ne arip, kaim a xokos abo une mabo barok lixilik. ");
INSERT INTO bjk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisas ixoro uguran tewe a marakörö ma ixo kakaa xö mön ma ixo lies urungan kö xönö möxö Magadan. ");
INSERT INTO bjk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Abo Parasi mabo Sadiusi toxo ot pösöt e Jisas ma toxo könönöin ine bira. Toxo ose bara irabo pet te önga mangana auxileng lölös sua osen bara abo tinörön te ine meriso re God. ");
INSERT INTO bjk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ixo tengen, “Niang bara aien ibo ot, mum bo tengen bara, ‘Irabo axana bung deek maxalik, möxö a balana kubu i wawara deek,’ ");
INSERT INTO bjk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ma xö puxu mum bo tengen bara, ‘Irabo baraa, möxösa, a balana kubu i ködö.’ Mum bo ösöxö rua werwere xulen a xuxulas möxö balana kubu, lamun mum kobo eöt tua werwere xulen abo uxileng möxöbo lalaa e wewet nang i orot köbo axana bung nixinen. ");
INSERT INTO bjk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xöbo bung nixinen a marakörö te wawara lamun a uxileng lölös, möxösa, idi tobo ruruu rewe xalik e God ma tobo sasaban esexere, ma lamun e rabo isik a auxileng ke Jona xalik mon urungan te idi.” Io, Jisas ixo wan kalik idi. ");
INSERT INTO bjk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Niang idi toxo wan lies ina tu, abo bak ne ausu toxo döxömen taun tua kip beret. ");
INSERT INTO bjk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas ixo tengen te idi, “Tumarang e mum, lamun a is köbo Parasi mabo Sadiusi.” ");
INSERT INTO bjk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Idi toxo rengrenge nana min kaluluon iat tidi ma toxo tengen, “Ine i tengen bira, möxösa, ire tokobo kip pe dauleng ne beret.” ");
INSERT INTO bjk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ixoro ösöxö ina tinenge ridi, ma ixo ose idi, “A nunu re mum i wuruwut. Ruasa mum mo wöwörö kaluluon iat te mum bara kaim pebo beret? ");
INSERT INTO bjk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mum kala maras bang? Me mum kobo dödöxömen lo a pitnö ne xönö beret nang a pitnö ne arip toxo en, ma nausen ne kölöt ixo wöwö ma subana nien niang e mum moxo iiögun?” ");
INSERT INTO bjk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ma bara a pitnö ma ninöng ne beret lamun a nit ne arip, a nausen ne kölöt wöwö ma subana nien nang mum moxo kip etok? ");
INSERT INTO bjk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bara bule mum kala maras? E kaim kö rengrengen te mum lamun a beret. Inexalik, mum moro tumarang lamun a is köbo Parasi mabo Sadiusi.” ");
INSERT INTO bjk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Io, idi toxo maras bara i kobo ötumarang idi lamun a is möxö bulbulus kö beret, nexalik lamun a inausu möxöbo Parasi mabo Sadiusi. ");
INSERT INTO bjk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nang e Jisas ixo wanot kö xönö möxö Kaisaria Pilipai, ine ixo ose abo bak ne ausu rine, “A nangadi tobo rengrengen a Barok kö Tödi me we?” ");
INSERT INTO bjk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Io, idi toxo balu ine, “Dauleng te tengen bere nöngön e Jon a tene baptais, dauleng te tengen bere nöngön e Elaija, ma lamun dauleng te tengen bere nöngön e Jeremaia bara nöngön a öng möxöbo propet.” ");
INSERT INTO bjk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Me ine ixo ose, “Me mum, mum bo rengrengen e me we?” ");
INSERT INTO bjk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Io, Saimon Pita ixo balu ine ma ixo tengen, “Nöngön a Mesaia, a Barok kö God niang a lak to.” ");
INSERT INTO bjk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas ixo balu, “Saimon, barok ke Jona, irabo deek kö nöngön, möxösa, kaim pe tödi mon i osen sik a na re nöngön, ma lamun a Tamake niso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Me e tengen te nöngön bara nöngön e Pita, ma lömö xö wat na e rabo uru xönan a lotu re e, ma minet i kebeöt ta kawönö ine. ");
INSERT INTO bjk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","E rabo isik ke nöngön abo ki möxö kingdom möxö watmaep. Abo lasa u baxut kö öxöno lagunon, God irabo baxut bölök kiso xö watmaep, ma abo lasa u palas ösu ra xö öxöno lagunon, God irabo palas ösu bölök kiso xö watmaep.” ");
INSERT INTO bjk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Io, ixo panak abo bak ne ausu rine bere idi tebele tengen osen kere öng bara a Mesaia ine. ");
INSERT INTO bjk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Xinabo axana bung im Jisas ixo urulo ra rengrengen köbo bak ne ausu rine bara ine irabo mana wan uruso Jerusalem ma irabo kip a tiip möxö oleleng ne lalaa xöbo limine abo sisila mabo pris tataxin mabo tene ausu möxöbo warkurai te Moses, ma bara a nangadi tabo mana sexomet ine ma xö narun ne bung melamu, irabo taru baling. ");
INSERT INTO bjk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita ixo lamus pes lo ine xalik idi ma ixo urulo ra xöxöö ine lamun a tinenge nang ixo tengen ma ixo tengen, “Kaim, Orong! Ina na i bele ot tö nöngön!” ");
INSERT INTO bjk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisas ixo talingen ma ixo tengen te Pita, “Satan, wan pes kalik e! U eka wewet pi a ngas se e. A dinödöm pe nöngön i kobo muu sik abo dinödöm pe God, ma lamun nöngön u mumuu a dinödöm kö nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Io, Jisas ixo tengen köbo bak ne ausu rine, “Nang bara re tödi i mamaa ra mumuu e, ine irabo mana döxömen taun ine iat ma irabo sölök a sölöxöröp pe ine ma irabo muu e. ");
INSERT INTO bjk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Möxö ewe nang i mamaa rua töndik sik iat a to re ine irabo ömalim tewe, ma lamun ewe niang i ömalim tewe a to re ine rua gene e, irabo pere wösöt lo a to runon. ");
INSERT INTO bjk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nang bara tödi i kip lo xirip abo lalaa möxö öxöno lagunon, ma i ömalim tewe a to runon te ine, io, a lasa i deek möxö inabo lalaa irabo top ine? Kawaim. Ma a tödi irabo isik a xunuxun sa rua xukun puxus lo a to re ine? ");
INSERT INTO bjk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Möxö a Barok kö Tödi irabo wanot ma lölös kö Tamana arixe mabo angelo re ine, ma irabo isik kö öngöng eöt ma lasa ine ixoro pet eörin. ");
INSERT INTO bjk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Turunon saxit, dauleng nang te tuu sik na takarabo met ot nang idi tabo pere a Barok kö Tödi irabo ot ma a kingdom pe ine.” ");
INSERT INTO bjk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Melamu xö pitnö ma öng ne bung ixo saxit, Jisas ixo lamus lo e Pita, Jems me Jon arixe mine urso lömö xö maii raxin, idiet kalik mon. ");
INSERT INTO bjk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Me Jisas ixo xuxulas kö mamaran tidi. A wawara re ine ixo mararang xarnang a xaken ma abo man te ine ixo ot pidien xarnang a bibio. ");
INSERT INTO bjk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Io, e Elaija me Moses toxo wösö ridi ma toxo wöwörö me Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Io, Pita ixo tengen te Jisas, “Orong, i deek bara e met mara xisixis sa. Nang bara u mamaa, e rabo uru re narun ne walpali, öng ke nöngön, öng ke Moses ma öng ke Elaija.” ");
INSERT INTO bjk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nang ine ixo wöwörö xudun, a kubu pidien ixo wösö ot ma ixo tawi idi, ma inöno öng kö kubu ixo tengen, “Ine ano Barok ke e. E mamaa lamun ine ma ibo isik a axanan taxin te e. Muot morobo ölangen ine!” ");
INSERT INTO bjk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nang abo bak ne ausu toxo ölangen bira, toxo subu ma wawara re idiet kö pu ma toxo buut köba. ");
INSERT INTO bjk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma lamun e Jisas ixo wanot ma ixo sigi idiet. Ixo tengen, “Muot moro tuu lömö. Ganim a binuut.” ");
INSERT INTO bjk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nang idiet toxo wawara kaa, toxo pere xalik mon e Jisas, ma kaim im idiet ta werwere re öng. ");
INSERT INTO bjk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma nang idi toxo önan su baling kalik a öxöno maii, Jisas ixo isik a tinenge lölös bere, “Muot bele tengen osen kere öng a lasa nang muot muru pere sik ot kö axana bung a Barok kö Tödi irabo taru baling kalik a minet.” ");
INSERT INTO bjk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ma abo bak ne ausu toxo ose ine, “Ruasa abo tene ausu möxöbo warkurai te Moses tobo rengrengen bere Elaija irabo wanot sila?” ");
INSERT INTO bjk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas ixo balu, “I turunon bara Elaija irabo wanot ma irabo bulus ödeek öbaling abo lalaa. ");
INSERT INTO bjk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","E tengen te muot, Elaija ixoro ot, me idi kawaim pa werwere xulen ine, lamun idi toxoro pet eörin abo lalaa urungan tine nang idi toxo mamaa lamun. Xarna bölök, idi tabo isik a kinadik kö Barok kö Tödi.” ");
INSERT INTO bjk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Io, abo bak ne ausu toxo maras bere ixo rengrengen tö idi lamun e Jon a tene baptais. ");
INSERT INTO bjk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ma nang idi toxo ot pösöt a marakörö, önga tödi ixo wanot pösöt e Jisas ma ixo subun kexe mesilain ine. ");
INSERT INTO bjk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ma ixo tengen, “Orong, örö marase a barok ke e. Ine ibo memet saxit ma ibo esek köba arixe. Ine ibo susubu laxa xö ia sösöt ma xö ari. ");
INSERT INTO bjk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E xoro kiwot ine urungan köbo bak ne ausu re nöngön, ma lamun idi kaim pa eöt ta ölanglanga ine.” ");
INSERT INTO bjk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas ixo balu, “Mum a marakörö mee nixinen nang mum kara nunu me mum bo tawuxus kalik abo tatalien töxödös, e kebeöt ta kinis arixe me mum kö axana bung ömat. Ma nausen ne bung e rabo kip abo tiip pe mum? Kip ot a barok ura re e.” ");
INSERT INTO bjk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas ixo tenge köö ina tano saban, ma ixo wan su xalik a barok, ma ixo deek baling saxit iat mon. ");
INSERT INTO bjk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Io, abo bak ne ausu toxo ose suxume ine, “Ruasa me mem kobo eöt ta irewe ina tano saban?” ");
INSERT INTO bjk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ixo balu idi, “Möxösa a nunu re mum i lik köba. Turunon saxit, nang bara a nunu re mum i lik köba xarnang a irine sie, mum mo eöt ta tengen kö puot na bira, ‘Örö taxase mera’, ma ina puot irabo taxase mera. Kaim pe laa nang mum mo kebeöt tua wewet.” ");
INSERT INTO bjk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","A sineseng kalik mon ma ölölö i eöt bara irabo irewese abo mangana tano saban biringan. ");
INSERT INTO bjk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nang idi toxo wanot arixe uruo Galili, ixo tengen te idi, “Tabo bulus a Barok kö Tödi xö limine a nangadi, me idi tabo sexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ma xö narun ne bung irabo taru baling kalik a minet.” Ma abo bak ne ausu toxo tapunuk köba. ");
INSERT INTO bjk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nang e Jisas mabo bak ne ausu rine toxoro wanot Kaprenaum, abo tene kip tuluwok möxö gunon lotu raxin, toxo wanot pösöt e Pita ma toxo ose ine, “A tene ausu re mum ibo tewe takis kö gunon lotu raxin?” ");
INSERT INTO bjk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Io, ixo balu idi, “Turunon, ine ibo wewet.” Nang e Pita ixo wan laxa xö gunon, Jisas ixo arun ta winörö. Ixo ose ine, “Saimon, u döxömen bara bule? A king möxö öxöno lagunon niang ibo xikip takis kalik ewe midi? Xalik abo baroxorok iat tine, bara a nangadi xabise?” ");
INSERT INTO bjk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita ixo balu ine, “Xalik a nangadi xabise.” Jisas ixo tengen te ine, “Möxö ina na, abo baroxorok iat te ine tabo langlanga xalik a tewe takis. ");
INSERT INTO bjk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma xalik iraa tobo engin idi me idi tobo laie. Örö wan urungan kö tu ma örö tewe ösu a öxönöm. Kip lo a sinila ne en u öxönöm. Sawang a ngalana ma örobo pere lo a tuluwok. Kip lo ma örö tabaa idi min tö e me nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kö ina axana bung, abo bak ne ausu toxo wanot pösöt e Jisas ma toxo ose ine, “Ewe i taxin tiso xö kingdom möxö watmaep?” ");
INSERT INTO bjk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Io, ixo kuwe a bak lik ma ixo uru ine kaluluonin idi. ");
INSERT INTO bjk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ixo tengen, “Turunon saxit, niang bere mum korobo xuxulas ma xarnang a bung bak lixilik, mum korobo laxa xö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Inexalik, ewe niang i ii ölik ine iat xarnang a barok lik, ine i taxin saxit kö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Me ewe niang irabo öga a barok lik bira xö esene e, ine i öga e. ");
INSERT INTO bjk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nang bara ewenene i pet a öng mere inabo barok lixilik na ewe idi te nunu re e rua pet magingin saban, irabo kip a warkurai taxin melamu. Io, ixere deek kö ine bara texere kut te xönö wat taxin kö inöno ma texere öriri ösu ine xö lamin möxö rasi, xalik ibo engin lo re öng kua pet magingin saban. ");
INSERT INTO bjk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Io, maris kö öxöno lagunon, möxösa, lamun abo lalaa niang ibo engin a nangadi rua wewet abo sasaban. A turunon saxit bara abo sasaban na irabo wanot, inexalik ina tödi nang i engin idi rua wewet a sasaban, irabo tuu xö warkurai taxin! ");
INSERT INTO bjk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nang bara a limem bara xexem i engin nöngön tua pet magingin saban, örobo tee xöröp tewe ine ma örö tewe rewe. I deek ke nöngön ta nilaxa xö to runon ma lime mut ma xexe mut, xalik tabo tewe nöngön arixe ma nine limem ma nine xexem urungan kö ia sösöt taxin kaim pe öxawam. ");
INSERT INTO bjk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma nang bara a maram i engin nöngön ta pet magingin saban, örobo luok tewe ma örö tewe rewe. I deek ke nöngön ta nilaxa xö to runon arixe ma önga kalait maram, xalik tabo tewe nöngön arixe ma nine kalait maram urungan kö ia sösöt taxin. ");
INSERT INTO bjk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tumarang, ganim e mum pa pere ölik ke öng mere inabo barok lixilik. E tengen te mum, abo angelo re idi niso xö watmaep tobo werwere a mamaran kö Tata re e. ");
INSERT INTO bjk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mum mo döxömen bule? Nang bara a tödi ine ma önga mar ne sipsip, ma öng ixo tup, ine irabo wan lie a pitnö ma nit ne sangaun ma pitnö ma nit lömö xö maii ma irabo wan ta winara xö öng kalik nang ixo tup. ");
INSERT INTO bjk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ma nang bara ine i pere wösöt lo ine, turunon saxit, ine irabo axanan köba lamun a önga sipsip kö ina pitnö ma nit ne sangaun ma pitnö ma nit nang idi kaim a tinup. ");
INSERT INTO bjk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ma i xarnang mon, a Tama mum niso xö watmaep i kara mamaa arixe bara re öng kidi abo barok lixilik irabo mana tup. ");
INSERT INTO bjk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nang bara a töm i pet te sasaban urö nöngön, wan ma örö osen ine ma sinibu rine, kaluluonin e mu iat. Ma nang bara i ölangen nöngön, nöngön uru lamus puxus a töm. ");
INSERT INTO bjk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma lamun niang bara ine i kobo ölangen, io, örobo lamus lo re öng bara ninöng kabise rua werwere ine xarnang a tinenge re God i tengen, bara ‘re ninöng bara re narun ne tödi idi tabo etöngösen maras sua öturunon önga laa.’ ");
INSERT INTO bjk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma bara ine i kobo mamaa rua ölangen e mum, io, mum morobo mana töngösen a marakörö möxö lotu min. Ma nang bara ine i kobo mamaa rua ölangen a tinenge ridi bölök, mum morobo perexulen ine urungan tö mum xarnang bere ine a tödi saban bara a tödi kaim ine ma nunu xö God. ");
INSERT INTO bjk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“E tengen a turunon te mum, abo lasa nang e mum mo baxut kö öxöno lagunon, e God irabo baxut bölök kiso xö watmaep, ma abo lasa nang mum mo palas sa xö öxöno lagunon, ine irabo palas bölök kiso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“E tengen öbaling ke mum, nang bara re ninöng mere mum pa xö pu i aut lamun te lalaa nang mum mo seng, io, e Tata re e niso lömö xö watmaep irabo tabaa e mum min. ");
INSERT INTO bjk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Möxösa, nang bara re ninöng bara re narun te wanot etok kölöme xö eseke, io, e rabo kis kaluluonin idi.” ");
INSERT INTO bjk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Io, Pita ixo ot pösöt e Jisas ma ixo ose, “Orong, a nausen ne axan nang arabo döxömen taun a töke nang i pet abo sasaban tö e? I eöt ma pitnö ma ninöng ne axan?” ");
INSERT INTO bjk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Me Jisas ixo balu, “E tengen te nöngön, kaim bara pitnö ma ninöng ne axan, ma lamun irabo pitnö ma ninöng ne sangaun ma pitnö ma ninöng. ");
INSERT INTO bjk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Möxö ina na, a kingdom möxö watmaep i xarnang a king nang ixo mamaa bara abo tultul te ine tabo ot tua balu dinau arixe mine. ");
INSERT INTO bjk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Io, ine ixo urulo ra ötöxödös abo dinau, ma toxo lamus ot a önga tödi mere idi urungan te ine, möxösa, ina tödi ixo dinau eöt ma sangaun ne arip ne tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma lamun ina tödi kaim ine xo eöt tua babalu öbaling ina tuluwok. Io, a king ixo tengen, ‘Mum morobo mana misik mina tödi arixe ma baninen te ine bara idi tabo xarnang abo tultul tataun. Ma abo lalaa xirip pe ine mum morobo misik min tua babalu öbaling abo tuluwok.’ ");
INSERT INTO bjk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma a tultul ixo subu su xö nini busuno xexene mesila re ine, ma ixo seseng ömarmaris ine bara, ‘E mamaa bara örö balawapat mon bang kö e. E rabo balu wuxus kirip abo tuluwok ke nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Io, a orong ixo marase ine, ma ixo döxömen taun abo dinau pe ine, ma ixo öbala rewe ine. ");
INSERT INTO bjk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ma nang ina tultul ixo wan lo ma ixo pere wösöt a önga ais se ine nang ixo kip lo a mar ne tuluwok ke ine. Ine ixo töndik ine ma ixo urulo rua wupus dik ine. Ma ixo tengen tö ine, ‘Örö balu wuxus a lasa nang u xo kip lo xalik e!’ ");
INSERT INTO bjk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“A ais se ine ixo subu su xö nini busuno xexene ma ixo seng ömarmaris ine bara, ‘E mamaa bara örö balawapat mon bang kö e. E rabo balu wuxus inabo tuluwok ke nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Inexalik bara, ine ixo mölök, ma ixo wan ma ixo tewe ölaxa ina tödi xö gunon ne aömokorot ot nang ine irabo balu wuxus kirip abo dinau pe ine. ");
INSERT INTO bjk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma nang a dauleng ne tultul kabise toxo pere a lasa ixo wanot, idi toxo bala kadik ma toxo wan ta rengrengen kö orong ke idi ulamun a lasa xirip nang ixo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Io, a orong ixo kuwe ölaxa ina tultul. Ma ixo tengen tö ine, ‘Nöngön a tultul saban! E xo döxömen taun abo dinau xirip pe nöngön, möxösa, nöngön u xo seng ömarmaris e ulamun. ");
INSERT INTO bjk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","I kobo eöt mon bara örobo marase a ais se nöngön xarnang mon e xo pet tö nöngön?’ ");
INSERT INTO bjk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma a orong ixo laie xöba re ine, ma ixo isik ine urungan te idi nang tobo isik kinadik kingan kö gunon ne aömokorot, ot nang ine irabo balu xirip abo dinau pe ine. ");
INSERT INTO bjk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ma bie bölök mon, a Tamake niso lömö xö watmaep irabo pet tö mum öngöng, nang bara mum koxobo döxömen taun tewe xirip a sasaban nang abo tönö mum idi te pet tö mum.” ");
INSERT INTO bjk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nang e Jisas ixo kawam pa rengrengen inabo lalaa na, ixo wan lie e Galili ma ixo wan laxa xö xönö pu mee Judeia urungan kö lawa xabise möxö Ari Jordan. ");
INSERT INTO bjk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A marakörö raxin toxo muu ine ma ixo ölanglanga idi ringan ee. ");
INSERT INTO bjk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma dauleng ne Parasi toxo wanot pösöt ine rua walwalar ine. Idi toxo ose ine bira, “I töxödös sik kö warkurai te ire bara a tödi irabo palas alolo xö une re ine eöt ma a lasanene nang ine i mamaa lamun?” ");
INSERT INTO bjk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas ixo balu idi, “Me mum moxoro kos bara xö urulo möxö uxixis möxö öxöno lagunon a Tene Uxis ‘ixo pet idu a körö ma une,’ ");
INSERT INTO bjk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ma ixo tengen, ‘Möxö ina na, a tödi irabo wan lie a tata ma nago rine ma irabo kis arixe ma une re ine. Me idu tabo öng.’ ");
INSERT INTO bjk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Io, idu tekarabo ninöng im, ma lamun idu tabo öng. Nang bara ixoro bie, ganim pe tödi ra walwalas a lasa nang e God ixoro bulus arixin sik.” ");
INSERT INTO bjk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Io, idi toxo ose ine, “Ruasa belek bere Moses ixo tenge lölös bara a tödi irabo geet te tinenge maras sua palas alolo ma irabo isik ina ginigeet tua tile rewe ina une?” ");
INSERT INTO bjk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas ixo balu, “Moses ixo ömaraxen e mum pa palas alolo ma une re mum, möxösa, abo bala mum ixo lölös köba. Ma lamun kaim bara ixo ot biringan xarnang mee mesila xö urulo. ");
INSERT INTO bjk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E tengen te mum, nang ewe re öng nang i köröp alolo ma une re ine nang i kala ilawa, ma i elolo a une xabise, ine i pet a tatalien saban, möxösa, ine i maru ma une kaim bara re ine.” ");
INSERT INTO bjk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Abo bak ne ausu toxo tengen te ine, “Nang bara ina mangana kinis na kaluluonin a tödi ma une i bira, i deek ka ganim a alolo.” ");
INSERT INTO bjk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisas ixo balu, “Kaim bara nangadi xirip tabo ömaraxen lo ina tinenge na, nexalik ke idi mon ewe God ixoro isik kö idi. ");
INSERT INTO bjk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Abo unine niang a tödi i kara elolo. Dauleng tekara elolo, möxösa, toxo kip iat idi bie. Ma uleng toxo kuru idi bara idi tekebeöt tua elolo. Ma uleng niang tekara elolo, möxö tobo dödödöm oleleng lamun a kingdom möxö watmaep. Ewe nang i eöt tua ömaraxen lo ina inausu, i deek bara irabo ömaraxen lo ine.” ");
INSERT INTO bjk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Io, toxo xikip ot abo barok lixilik ura re Jisas sö ine rua bulbulus a limine lömö ridi ma rua sineseng kö idi. Inexalik abo bak ne ausu toxo töö rewe idi ewe toxo xikip ot idi. ");
INSERT INTO bjk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisas ixo tengen, “Moro ganim a bung bak lixilik ta ot ura re e, ma ganim a wanwanak idi, möxösa, a kingdom möxö watmaep, ine möxö inabo mangana bak lixilik bira.” ");
INSERT INTO bjk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ma nang ine ixoro bulus a nine limine lömö re idi, ine ixo wan lo meringan. ");
INSERT INTO bjk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Io, önga tödi ixo wanot pösöt e Jisas ma ixo ose, “Tene Ausu, a laa deek sa niang e rabo mana pet tua xikip ina to ulorexe saxit?” ");
INSERT INTO bjk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisas ixo balu, “Ruasa u ose e lamun a lasa niang i deek? A Öng kalik mon nang i deek. Nang bara u mamaa rua nuan laxa xö to runon, örö muu abo warkurai te God.” ");
INSERT INTO bjk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ina tödi ixo ose, “Nangang sa?” Jisas ixo balu, “‘Ganim a arsexomet tataun, ganim a pet a tatalien ne ilawa ma önga tödi alolo, ganim a wuwulo, ganim a tengen töxö lamun a önga tödi, ");
INSERT INTO bjk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","örö ii ölik nöngön te tata me nago,’ ma ‘Örobo mamaa lamun a öng kabise xarnang u mamaa lamun nöngön iat.’” ");
INSERT INTO bjk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ina tödi maxat ixo tengen te Jisas, “E xobo mumuu inabo warkurai. A lasa bang e kela pet?” ");
INSERT INTO bjk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas ixo balu ine, “Nang bara u mamaa bara örobo töxödös kirip, örö wan, ma örö misik mabo laa xirip nang nöngön min ma örö tabaa a nangadi maris, io nang, nöngön örobo kip abo arabaa deek saxit tiso xö watmaep. Ma örö miang ma örö muu e.” ");
INSERT INTO bjk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nang ina tödi maxat ixo ölangen bira, ixo wan lo ma tawunuk, möxösa, ine a tödi orong. ");
INSERT INTO bjk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Io, Jisas ixo tengen köbo bak ne ausu rine bira, “Turunon saxit, i lölös kö önga tödi orong kua nilaxa xö kingdom möxö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E maa ra ölölös öbaling e mum, nang bara önga kamel i ka nuan laxa xö mara möxö nil möxö sinöxö, i kobo lölös köba xarnang a tödi orong i ka nilaxa xö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nang abo bak ne ausu toxo ölangen bira, toxo wuwus köba im ma toxo tengen, “Nang bara bie, ewe im pe öng irabo eöt ta xikip a to ulorexe?” ");
INSERT INTO bjk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas ixo pere idi ma ixo tengen, “Xö nangadi mon, idi tekebeöt. Ma lamun e God i öt ta wewet eörin kirip abo lalaa.” ");
INSERT INTO bjk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Io, e Pita ixo tengen te ine, “Mem mere wan lie xirip abo lalaa re mem rua mumuu e nöngön! A lasa im nang e mem marabo kip lo?” ");
INSERT INTO bjk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Io, Jisas ixo tengen tö idi, “Turunon saxit, xö axana bung nang abo lalaa tabo ot maxat baling, a Barok kö Tödi irabo kis kö kinis taxin ne mariris. Me ewe mum nang moro muu e, mum morobo kis bölök kö ina sangaun ma ninöng ne kinis taxin, ma morobo kure a sangaun ma ninöng ne marapun mee Israel. ");
INSERT INTO bjk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Me ewe nang iri wan lie a gunon tine, abo tönö, abo saxana, a tata, a nago, a bung baroxorok, bara abo komo rine rua gene e, ine irabo kip a oleleng saxit möxö inabo mangana lalaa nang ixo wan lie, ma irabo kip a to ulorexe saxit bölök. ");
INSERT INTO bjk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma lamun a oleleng ewe nang te sila, tabo muu, ma oleleng ewe nang te muu, tabo sila.” ");
INSERT INTO bjk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“A kingdom möxö watmaep i xarnang a tödi ine ma önga komo. Ma xö puxu bubung ine ixo wan ta lalamus sebo duöng kua tinörön kö komo wain te ine. ");
INSERT INTO bjk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma ixo tengen köbo duöng tinörön bara irabo kun idi mon ma önga tuluwok kö önga bung kudun. Io, ine ixo tile rewe idi urungan kö komo wain. ");
INSERT INTO bjk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma bara ixo pitnö ma nit ne axana bung ine ixo wan lo ma ixo pere a dauleng toxobo tuu tataun sik kölöme xö xönö möxö misik mabo lalaa. ");
INSERT INTO bjk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me ine ixo tengen tö idi, ‘Mum bölök moro wan ma moro rörön kö komo wain te e, me e rabo kun ötöxödös e mum.’ ");
INSERT INTO bjk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Io, idi toxo wan. “Me ine ixo baling kö luono xaken. Ma lörörö xö narun ne axana bung ixo baling ma ixo pet bie bölök. ");
INSERT INTO bjk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma bara ixo lörörö xö pitnö ne axana bung kö aien, ine ixo wan ma ixo pere a dauleng bölök angen toxo ruruu nana. Ine ixo ose idi bara, ‘Ruasa me mum mo ruruu nana ra me mum koxobo wewet te lalaa?’ ");
INSERT INTO bjk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Idi toxo balu ine, ‘Ma, möxösa, kaim pe tödi i tabaa e mem mere tinörön.’ “Io, ine ixo tengen tö idi, ‘Mum bölök moro rörön kö komo wain te e.’ ");
INSERT INTO bjk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nang ixoro dömön, a tamana komo wain ixo tengen kö tödi nang ibo werwere muu a komo wain bira, ‘Kuwe abo duöng tinörön ma örö kun idi. Urulo xöbo duöng nang toxo ot melamu, ma öxawam pe ewe midi nang toxo sila.’ ");
INSERT INTO bjk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Io, abo tene tinörön nang toxo lamus ot idi xö pitnö ne axana bung kö aien, idi toxo wanot. Me idi toxo kip lo önga tuluwok ke idi öngöng. ");
INSERT INTO bjk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma bara abo duöng tinörön nang toxo arun ta lamus idi toxo wanot, idi toxo döxömen bara idi tabo kip a xinuxun taxin. Ma lamun idi öngöng bölök toxo kip a önga tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nang idi toxo kip lo, idi toxo wöwörö oleleng kö tödi nang ixobo unan sik a komo wain. ");
INSERT INTO bjk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Me idi toxo tengen bara, ‘Abo duöng nang u xo lamus idi melamu, idi te rörön önga axana bung mon, me nöngön u xo kun eörin kirip e mem. Mem moxo örasen a kinadik möxö ina tinörön me mem moxo malawang bölök kö xaken.’ ");
INSERT INTO bjk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Inexalik ixo balu öng ke idi, ma ixo tengen, ‘Töke, e kobo saban te nöngön. U ösöxö bara iraa toxo aut bara tabo kip a önga tuluwok mon. ");
INSERT INTO bjk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Örö kip lo a xinuxun te nöngön ma örö wan. E mamaa rua ukun abo duöng nang e xo lamus idi melamu xarnang mon nöngön. ");
INSERT INTO bjk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","E iat e kure sik a tuluwok ke e bara arabo pet bule. Nöngön u dödöm saban sik ke idi ewe nang toxo muu, möxösa, e a tödi möxö inerabaa?’” ");
INSERT INTO bjk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Io, Jisas ixo tengen bira, “Ewe midi nang te muu, idi tabo sila, ma ewe midi nang te sila, idi tabo muu.” ");
INSERT INTO bjk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ma niang e Jisas ixo önan uruso Jerusalem, ixo lamus öbaling a sangaun ma ninöng ne bak ne ausu urungan kö lawana ma ixo tengen te idi, ");
INSERT INTO bjk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ire tabo wan kaa uruso Jerusalem, ma Barok kö Tödi, tabo isik ine xö limine abo pris tataxin mabo tene ausu möxöbo warkurai te Moses. Idi tabo bulus warkurai ra sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma tabo isik ine xö limine a nangadi kaim bara abo Judeia rö idi rua eösaxit saban me ine ma tabo dangat ine ma tabo tut ine xö sölöxöröp. Narun ne bung irabo saxit, ine irabo taru baling kalik a minet!” ");
INSERT INTO bjk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Io, a nago xö nine barok ke Sebedi ixo wan urungan te Jisas arixe ma nine barok ke ine, ma ixo subun kexe mesila re Jisas ma ixo seng e Jisas lamun önga laa. ");
INSERT INTO bjk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Io, Jisas ixo ose ine, “U mamaa lamun a lasa?” Ma ixo tengen, “Örobo ömaraxen lo a nine barok ke e, bara idu tabo kis arixe me nöngön kölöme xö kingdom pe nöngön. Öng irabo kis kö lime tuun ma öng kö lime kes se nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Me Jisas ixo tengen te idiet, “Muot mo köbo ösöxö a lasa niang muot mo eka ose ulamun. I eöt bere mu morobo inim kö tubon möxö kinadik niang e rabo inim könan?” Idu toxo balu ine bira, “Maa me eöt.” ");
INSERT INTO bjk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisas ixo tengen te idu, “I turunon, mu morobo kip a kinadik nang e rabo kip, ma lamun tua kinis kö lime tuun bara xö lime kes, kaim bara laa re e ra inerabaa min. Ina laa na a laa re Tata re e. Ine iat irabo isik inabo kinis kö nangadi niang ixoro tagur sik inabo kinis se idi.” ");
INSERT INTO bjk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Io, nang a sangaun ne bak ne ausu xabise toxo ölangen bira, idi toxo bala kadik kö idu narön. ");
INSERT INTO bjk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Io, Jisas ixo kuwe arixin idi ma ixo tengen te idi, “Mum mo ösöxö sik bara ewe me idi niang kaim bara abo Judeia, abo sisila re idi tobo ii öraxin idi iat ma tobo pere ösu a nangadi xabise. Mabo orong ke idi tobo kure xöbanin idi. ");
INSERT INTO bjk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ina mangana magingin na i bele kis kaluluonin e mum, ma lamun ewe niang i mamaa ra ii öraxin ine iat kaluluonin e mum, ine irabo tultul te mum. ");
INSERT INTO bjk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Me ewe niang i mamaa rua tinuu sila, ine irabo tödi tinörön tataun mon te mum, ");
INSERT INTO bjk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","xarnang a Barok kö Tödi bölök ine i kobo wanot bara a nangadi tabo tultul te ine. Kaim. Ine ixo wanot tua tultul te idi, ma bara irabo isik a to re ine ra xukun puxus a oleleng ne nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nang e Jisas mabo bak ne ausu re ine toxo wan lie e Jeriko, a marakörö raxin toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A nine tödi marapulo toxo kisisik kö lawana ngas, ma niang idu toxo ölangen bere Jisas ixo önan saxit, idu toxo kup, “Orong, Barok kö marapun te Dewit, örö marase e maa!” ");
INSERT INTO bjk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A marakörö niang toxo tenge laie re idu ma toxo tengen te idu rua ödödö, nexalik bere idu toxo kup taxin belexim, “Orong, Barok kö marapun te Dewit, örö marase e maa!” ");
INSERT INTO bjk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Io, e Jisas ixo tuu ma ixo kuwe idu. Jisas ixo ose idu, “Mu mo mamaa bara e ra pet te lasa re mu?” ");
INSERT INTO bjk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Idu toxo balu ine, “Orong, maa me mamaa ra winawara baling.” ");
INSERT INTO bjk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas ixo marase idu ma ixo tön a nine marana idu. Saxit mon, idu toxo öt ta winara me idu toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nang e Jisas mabo bak ne ausu re ine toxo wanot lörörö Jerusalem, idi toxo ot to Betepage me Betani xö Maii Olip. Io, Jisas ixo tile a nine bak ne ausu, ");
INSERT INTO bjk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma ixo tengen tidu bara, “Mu moro wan urungan kö lagunon mesila re mu, ma saxit mon mu morobo pere a önga dongki te kubus sik ine e, arixe ma barok ke ine. Mu morobo palas tewe idu ma morobo lamus ot idu ura re e. ");
INSERT INTO bjk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Niang bara önga tödi i ose ulamunon, mu morobo tengen te ine bara, ‘A Orong i mamaa ulamun idu.’ Io, saxit mon irabo isik tewe idu.” ");
INSERT INTO bjk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Io, a na ixo ot tua öturunon abo tinenge xö propet: ");
INSERT INTO bjk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Tengen kö balik ke Saion, ‘Pere, a king ke mum i önan pösöt e mum, a tödi ödödö i xisxisin nanin önga dongki. I kisisik kö dongki lik, a barok kö önga dongki.’” ");
INSERT INTO bjk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Me idu toxo wan lo ma toxo pet xarnang e Jisas ixoro tengen te idu. ");
INSERT INTO bjk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Io, idu toxo lamus ot ina dongki arixe ma dongki lik, me idu toxo parawe abo man ömat te idu lömö xönan, me Jisas ixo kis kaa xönan. ");
INSERT INTO bjk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A marakörö raxin saxit toxo kip tewe abo xinaxain te idi ma toxo parawe xö ngas, ma dauleng toxo tee abo axana iaa xöbo uno iaa ma toxo parawe nanin kö ngas. ");
INSERT INTO bjk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Abo marakörö nang toxo wan sila re ine ma ewe midi nang toxo muu toxo xukup bira, “Axabe a Barok kö marapun te Dewit!” “God irabo wadöane a öng nang i wanot tua wewet eörin a mamaa xö Orong!” “Axabe e God uruso lömö saxit!” ");
INSERT INTO bjk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nang e Jisas ixo laxa Jerusalem, a marakörö xirip kina xönö lagunon taxin toxo kup ma toxo ose, “Ewe ine?” ");
INSERT INTO bjk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Abo marakörö toxo balu, “Ine e Jisas, a propet mee Nasaret kölöme Galili.” ");
INSERT INTO bjk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas ixo laxa xö xönö möxö gunon lotu raxin ma ixo bat ösu xirip ewe midi nang toxo xuxuxun ma toxo mismisik kölöme. Ine ixo puxus lubeng abo öra xö nangadi nang tobo kulas tuluwok mabo öra möxö kinis se nangadi nang tobo mismisik ma buno. ");
INSERT INTO bjk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ixo tengen te idi, “A tinenge re God nang toxo geet i tengen bira, ‘A gunon te e tabo tengen ine ma gunon ne sineseng.’ Inexalik bara mum iat mum mo pet ine xarnang ‘a gunon ne minun möxö nangadi pinilo.’” ");
INSERT INTO bjk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Abo marapulo ma abo xexe saban toxo wanot urungan kö gunon lotu raxin, ma ixo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma lamun abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, toxo bala kadik sik kine nang toxo pere abo lalaa deek arixe ine ixo pet, ma a bung baroxorok toxo xukup kö ina xönö möxö gunon lotu raxin, “Axabe a Barok kö marapun te Dewit.” ");
INSERT INTO bjk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Idi toxo ose ine, “Nöngön u ölangen a lasa nang a bung baroxorok te rengrengen?” Jisas ixo balu idi, “Maa. Bule, mum kobola kos ina tinenge re God? I tengen bira, ‘U tagur sik a bung baroxorok lixilik me idi ewe angen te rutus, bara idi tabo ii öraxin nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma ixo wan lie idi ma ixo wan tewe xalik a lagunon taxin uri Betani, nang ke ine ra pinaluso. ");
INSERT INTO bjk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Xö puxu bubung, nang ixo önan baling uruso xö lagunon taxin, ixo irilöng. ");
INSERT INTO bjk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nang ixo pere a uno löwö xö lawana ngas, ixo wanot lörörö xina uno iaa me ine ixo parasiwin bara kaim a pasuno, a labana xalik mon. Io, ixo tengen te ine, “Me nöngön ökorobo o baling ke pasuno iaa!” Saxit mon, ina uno iaa ixo manga. ");
INSERT INTO bjk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nang abo bak ne ausu toxo pere bira, toxo wuwus saban. Idi toxo ose, “Bule a uno iaa na i manga saxit mon?” ");
INSERT INTO bjk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas ixo balu idi, “Turunon saxit, nang bara mum ma nunu ma mo köbo nini dinödöm, mum morobo pet a lasa te pet kö ina uno iaa, lamun mum morobo eöt bölök ka rengrengen kö puot na bira, ‘Örö taru mera ma örö wan su uruo xö rasi,’ io, God irabo tabaa e mum min. ");
INSERT INTO bjk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nang bara mum morobo nunu, mum morobo kip lo a lasanene mum mo seseng ulamun.” ");
INSERT INTO bjk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Io, Jisas ixo wan laxa xö xönö möxö gunon lotu raxin. Nang abo pris tataxin mabo sisila toxo ot pösöt ine, idi toxo ose ine bira, “U kip lo ina ese raxin na mole nang nöngön u döxömen bere i töxödös se nöngön ta wewet inabo lalaa na? Me ewe i tabaa nöngön mina lölös na?” ");
INSERT INTO bjk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas ixo balu idi ma ixo tengen, “E rabo ose e mum ma önga ineose bölök. Nang bara mum morobo balu e, io, e rabo tengen te mum a lölös sa nang e wewet inabo lalaa na min. ");
INSERT INTO bjk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A baptais se Jon, ine i wanot mole? Meriso lömö re God, bara mera xö nangadi mon?” Idi toxo wöwörö min kaluluonin idi iat ma toxo tengen, “Nang bara ire te tengen bara, ‘Meriso re God,’ me ine irabo ose ire bara, ‘Ma ruasa me mum koxobo nunu re ine?’ ");
INSERT INTO bjk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me ire takarabo tengen, ‘Möxö nangadi mon’. Ire te burin a nangadi, möxösa, idi te nunu bere Jon a propet.” ");
INSERT INTO bjk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Io, idi toxo balu e Jisas, “Mem kobo ösöxö.” Jisas ixo tengen te idi bara, “E bölök e karabo tengen te mum ewe i isik ina lölös na re e ra wewet inabo lalaa na.” ");
INSERT INTO bjk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mum mo döxömen bule? A önga tödi ewe ine ma nine barok. Ine ixo wan urungan kö sisila ma ixo tengen, ‘Barok ke e, wan ma örö rörörön nixinen kö komo wain.’ ");
INSERT INTO bjk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“A barok ixo tengen, ‘E mölök.’ Lamun melamu ine ixo puxus a dinödöm pine ma ixo wan. ");
INSERT INTO bjk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Io, a tamadu ixo wan urungan kö önga barok kabise rine ma ixo tengen bölök kine. Ine ixo tengen, ‘E rabo rörön,’ lamun ine kaim kö nuan. ");
INSERT INTO bjk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ewe ridu i pet eörin a lasa a tamadu i tengen?” Idi toxo balu, “A sisila ne barok.” Jisas ixo tengen te idi, “Turunon saxit, abo tene kip takis mabo ilawa te önan laxa sila xö kingdom kö God kalik e mum. ");
INSERT INTO bjk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Möxö, e Jon a tene baptais ixo wanot tua osen e mum ma ngas ne kinis töxödös, ma kaim e mum pa nunu re ine, ma lamun abo tene kip takis mabo ilawa toxo nunu. Ma turunon bara mum moxo pere bölök idi, ma kaim iat e mum pua dinödöm puxus ma nunu re ine.” ");
INSERT INTO bjk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas ixo tengen tö idi bira, “Mum moro ölangen a önga tinenge öwuo bölök. A önga tödi ine a tamana pu ewe ixo sulo a komo wain, ine ixo kut pi ma tabörö. Ma ixo kin a mara möxö wawas ömeme a pasuno wain, ma ixo timet öxaa a warawat ma ixo pet a walpali rua werwere muu a komo wain. Io, ine ixo isik ina komo wain urungan köbo duöng kua tinörön könan ma ixo wan lo bang kö nuan ömat saxit. ");
INSERT INTO bjk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma nang a axana bung möxö dixidik a pasuno wain ixo wanot, ine ixo tile abo tene tinörön tine urso xöbo tene werwere muu wain ta xikip lo rebo pasuno wain tine. ");
INSERT INTO bjk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Abo tene werwere muu möxö komo wain toxo töndik abo tene tinörön te ine, me idi toxo dangat a öng, ma toxo sexomet a öng kabise, ma toxo teng a öng nang ixo narun mine. ");
INSERT INTO bjk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Melamu, ine ixo tile öbaling a öngabo tene tinörön kabise urso ridi, a oleleng belek ke idi nang toxo sila. Ma abo tene werwere muu a komo wain toxo pet biringanin idi bölök. ");
INSERT INTO bjk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma melamu re idi xirip im, ine ixo tile a barok kine urungan tidi. Ine ixo tengen bira, ‘Idi tabo ii a barok ke e.’ ");
INSERT INTO bjk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Lamun nang abo tene werwere muu a komo wain toxo pere a barok, idi toxo tengen kö öngöng kaluluonin idi iat bara, ‘Ina tödi niang i öt ta unan lo ina komo wain te tamana umelamu. Go, ire ta sexomet ine, ma ta kip lo abo lalaa re tamana.’ ");
INSERT INTO bjk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Io, idi toxo lamus lo ine ma toxo tewe ösu ine xalik a komo wain, ma toxo sexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Io, niang a tamana komo irabo wanot, ine irabo pet a lasa urungan köbo tene balbalaure möxö komo wain?” ");
INSERT INTO bjk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Idi toxo tengen, “Ine irabo se ögarin inabo duöng saban na, me ine irabo isik a komo wain köbo tene balbalaure xabise rua werwere muu, ma bara a axana bung möxö dixidik a pasuno wain irabo wanot, idi tabo isik öbaling kebo pasuno wain maruxo urungan tine.” ");
INSERT INTO bjk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas ixo tengen te idi, “I deek bara mum morobo döxömen abo tinenge re God niang toxo geet bara, ‘A wat nang abo tene pet gunon toxo kumamaa lamun, möxösa, idi toxo döxömen bara a laa tataun, i wawara bara ine belek im a lölös möxö unine gunon kirip. A Orong iat i pet ot ina laa na, me ire te pere ma lak deek saxit kö winara re ire.’ ");
INSERT INTO bjk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Io, na e tengen te mum bara a kingdom kö God irabo wan pes xalik e mum ma irabo isik kö nangadi ewe idi tobo rörörön eöt ma mamaa re God. ");
INSERT INTO bjk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Me ewe nang i subu xö ina wat irabo tawörök lixilik, nexalik ine irabo pörök ke öng nang bara i subu lömö rine.” ");
INSERT INTO bjk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nang abo pris tataxin mabo Parasi toxo ölangen ina tinenge öwuo re Jisas, idi toxo ösöxö sik bara ixo wöwörö lamun idi. ");
INSERT INTO bjk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Idi toxo wawara siwin te ngas sua rörön dik e Jisas, ma lamun idi toxo burin a marakörö, möxösa, a nangadi toxo nunu sik bara ine a propet. ");
INSERT INTO bjk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas ixo tengen öbaling kidi xö tinenge öwuo, ma ixo tengen bara, ");
INSERT INTO bjk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A kingdom möxö watmaep i xarnang a önga king nang ixo tagur sik a nien taxin ne alolo lamun a barok ke ine. ");
INSERT INTO bjk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ixo tile abo tene tinörön te ine urungan tidi ewe ixoro pixe sik ka inot kö nien taxin ta rengrengen tidi ra nuanot, lamun idi kaim a nuanot. ");
INSERT INTO bjk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Melamu, ixo tile a dauleng ne tene tinörön ma ixo tengen, ‘Tengen te idi nang ewe e xoro seng idi ra nuanot bara e xoro tagure a nien te e. E re sewe abo bulmakau ebobot nang e xo tabaa öraxin idi, ma abo laa xirip iri tagur sik. Mum moro miang ura xö nien taxin ne alolo.’ ");
INSERT INTO bjk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Lamun idi toxo kaes tewe ma toxo wan elixilik. A önga tödi ixo wan urungan kö komo re ine, ma öng kabise ixo wan urungan köbo tinörön te ine. ");
INSERT INTO bjk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Me idi a uleng kabise toxo tödik abo tene tinörön te ine, ma toxo eler idi ma toxo sexomet idi. ");
INSERT INTO bjk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ina king ixo laie. Ma ixo uguran abo umri re ine ma toxo sexomet tewe idi abo tene inarsexomet ma toxo söngöt a lagunon taxin te idi. ");
INSERT INTO bjk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Io, ixo tengen köbo tene tinörön te ine, ‘A nien taxin ne alolo i tagur sik, nexalik ewe midi e xo seng idi tekobo mamaa ra nuanot. ");
INSERT INTO bjk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Moro wan urungan köbo ngusuno ngas lixilik ma moro seng idi abo subana nangadi me ewe midi bölök mo esuo midi.’ ");
INSERT INTO bjk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Io, abo tene tinörön toxo wan su xöbo ngas ma toxo lamus etok a nangadi nang toxo pere lo idi xö ngas, idi abo a lak deek ma abo a lak saban bölök, ma ina gunon möxö alolo ixo wöwö xöbo osee. ");
INSERT INTO bjk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ma lamun nang ina king ixo wan laxa rua werwere abo osee, ine ixo pere a önga tödi kölöme ewe ixo kaim a sisige a man möxö alolo. ");
INSERT INTO bjk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Io, ixo ose ine, ‘Töke, u laxa bule ra, ma u kobo sige re man möxö alolo?’ A tödi kaim kö babalu ine. ");
INSERT INTO bjk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Io, ina king ixo tengen köbo tene tinörön te ine, ‘Kut dik abo limine mabo xexene ine, ma moro tewe ine uri xö araman kö xödxödö. Ma ringan idi tabo gegee ma tabo engiren abo ngisine idi.’ ");
INSERT INTO bjk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Möxö a oleleng e God ixo seng idi, lamun a dauleng mon irabo pere kos lo idi.” ");
INSERT INTO bjk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Io, abo Parasi toxo wan tewe ma toxo wöwörö arixe ra uxun ine xöbo tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Idi toxo tile abo bak ne ausu re idi arixe mabo nangadi nang toxobo mumuu e Erot urungan te Jisas. Idi toxo tengen, “Tene Ausu, mem me ösöxö sik nöngön a tödi möxö rengrengen a turunon me nöngön u bo usu a nangadi ma turunon ulamun a ngas nang e God i mamaa bara ire tabo muu. Me nöngön u kobo ösöxö ra tinuu arixe mere önga tödi xalik mon, möxösa, nöngön u kobo dödöm köba lamun abo mangana duöng sa idi. ");
INSERT INTO bjk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Töngösen e mem ma dinödöm pe nöngön. I töxödös se ire bara tabo kun takis kö king taxin mee Rom bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma lamun e Jisas ixo ösöxö sik abo dinödöm saban te idi ma ixo tengen, “Mum nang mum bo röxröxö mon bara mum a lak deek, ruasa mum mu mamaa ra uxun e? ");
INSERT INTO bjk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mum moro osen a tuluwok niang mum bo ukun takis min.” Me idi toxo kip ot ina önga tuluwok urungan te ine, ");
INSERT INTO bjk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","me ine ixo ose idi, “Re we ina wawara na ma ese na?” ");
INSERT INTO bjk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Me idi toxo balu bere, “Re king taxin mee Rom.” Io, ixo tengen te idi, “Mum morobo isik ke king taxin a lasa nang ke king taxin. Ma a lasa nang ke God, mum morobo isik ke God iat.” ");
INSERT INTO bjk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Niang idi toxo ölangen bira, idi toxo wuwus saban. Io, idi toxo wan kalik ine ma toxo wan lo. ");
INSERT INTO bjk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Xina bung iat nang a dauleng ne Sadiusi niang tobo nunu bara kaim pe tinaru baling kalik a minet, toxo ot pösöt e Jisas ma toxo ose ine bara, ");
INSERT INTO bjk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tene Ausu, Moses ixo tengen te ire bira, nang bara önga tödi i met, me ine kaim ine mere barok, io, a tönö ina tödi irabo ot lamun ina möxösö ma irabo kip barok kö tönö. ");
INSERT INTO bjk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Io, a pitnö ma ninöng ne barön kaluluonin e mem na. A sisila ixo elolo ma ixo met, ma, möxösa, kaim ine ma barok, ixo gan sik a une re ine xö tönö. ");
INSERT INTO bjk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma xarnang bölök urungan kö tönö mumuu lo ine ma bie uri ot kö barok pitnö ma ninöng ke idi barön. ");
INSERT INTO bjk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma melamu im, a une bölök ixo met. ");
INSERT INTO bjk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Io, xö axana bung nang bara abo minet tabo taru baling, ine irabo une re we xö ina pitnö ma ninöng? Möxö idi xirip toxo ot lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisas ixo tengen te idi bara, “A dinödöm pe mum i kobo töxödös, möxösa, mum kobo ösöxö sik abo tinenge re God niang toxo geet ösu, me mum kobo ösöxö sik bölök a lölös se God. ");
INSERT INTO bjk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Xö axana bung möxö tinaru baling möxö minet, a nangadi tekarabo eöt ta inalolo. Idi tabo xarnang abo angelo meriso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na e rabo wöwörö lamun abo minet, nang bara idi tabo taru baling, bara kaim. I deek bara mum morobo döxömen lo a lasa niang e God ixo tengen te mum bie, ");
INSERT INTO bjk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘E a God te Abaram, a God te Aisak ma bara a God te Jekop.’ Ine kaim bara a God möxö nangadi minet. Kaim! Inexalik ine a God möxö nangadi to.” ");
INSERT INTO bjk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Niang a marakörö toxo ölangen bira, idi toxo wuwus saban kö ina inausu re ine. ");
INSERT INTO bjk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Abo Parasi toxo ot etok niang toxo ölangen bara e Jisas ixo baxut abo ngalana abo Sadiusi. ");
INSERT INTO bjk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Öng mere idi ixobo ösöxö ödeek sik abo warkurai te Moses, ixo könönöin ine ma ina ineose na: ");
INSERT INTO bjk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tene Ausu, a warkurai sa i lömö sik köbo warkurai te God?” ");
INSERT INTO bjk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisas ixo balu ine, “‘Örobo mamaa ulamun a Orong, a God te nöngön, kö kat kirip pe nöngön, ma xö tanono e nöngön, ma xö dinödöm pe nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ina warkurai na i taxin sik ma i sila xöbo warkurai kirip. ");
INSERT INTO bjk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma sese öninöng i xarna na: ‘Örobo mamaa lamun a öng kabise xarnang u mamaa lamun nöngön iat.’ ");
INSERT INTO bjk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Me idu a nine unine abo warkurai kirip mabo tinenge möxöbo propet.” ");
INSERT INTO bjk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Niang abo Parasi toxo ot etok arixe, Jisas ixo ose idi, ");
INSERT INTO bjk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mum mo dödöm bule lamun ina Mesaia? Ma a barok kewe ine?” Idi toxo balu ine, “A barok tubuno e Dewit.” ");
INSERT INTO bjk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma ixo tengen te idi, “Bara bule im bere Dewit ixo kip lo abo tinenge möxö Töxödös ne Tanono ma ixo tengen ina Mesaia bara ‘Orong’? Möxö ixo tengen bira, ");
INSERT INTO bjk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God a Orong ixo tengen kö Orong ke e bara: “Nöngön örö kis kö lawa tuun te e ot nang e rabo bulus abo iuo re nöngön kö ene xexem.” ’ ");
INSERT INTO bjk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Io, nang bara i tengen ine me ‘Orong,’ bule nang bara ine a Mesaia ma irabo tubuno e Dewit bölök?” ");
INSERT INTO bjk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kaim pe öng ka eöt tua tengen te tinenge ne babalu. Ma urulo xina bung na, abo tödi xabise toxo buut tua ose öbaling ine merebo ineose bölök. ");
INSERT INTO bjk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Io, Jisas ixo tengen kö marakörö mabo bak ne ausu rine: ");
INSERT INTO bjk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abo tene ausu möxöbo warkurai te Moses mabo Parasi, idi iat tobo palas ömaras abo warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Io, mum morobo mana tame idi me mum morobo mumuu abo lalaa xirip nang idi tobo rengrengen te mum. Lamun, mum bele pet te laa niang idi te pet, möxösa, idi tekobo wewet eörin a lasa idi te etöngösen min. ");
INSERT INTO bjk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Io, idi te kubus öxaa abo lalaa tiip ma te bulbulus idi xö inöno nangadi, lamun idi iat tekebeöt ta mamaa rua ii öxaa re önga sixsixine limine idi rua sölsölök inabo tiip. ");
INSERT INTO bjk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Abo lalaa xirip idi te pet, idi te mamaa bara ire a nangadi tabo pere bara tabo ii idi. Mum mo maras köbo tatalien te ire xöbo xinaxait lixilik. Ire tobo bulbulus a dauleng ne warkurai te God kölöme xönan. Me ire tobo xuxut dik inabo xinaxait köbo piniene ire. Ma lamun abo xinaxait te idi i taxin köba. Me ire tobo bulbulus bölök abo uno kililöng köbo man te ire rua ödöxömen ire rua mumuu inabo warkurai. Ma lamun abo kililöng ke idi iat i ömat köba. ");
INSERT INTO bjk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Idi tobo mamaa rua xikip lo a kinis deek kö axana bung möxö nien tataxin ma tobo werwere kos lo abo kinis deek kölöme xö gunon ne siniseng. ");
INSERT INTO bjk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tobo mamaa bara tabo xukuwange idi xö boxönö möxö mismisik, ma bara nangadi tabo kuwe idi ‘Tene ausu.’ ");
INSERT INTO bjk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Inexalik bara i kobo deek ka rengrengen e mum bara a ‘Tene ausu’, möxösa, öng mon a Tene Ausu re mum, me mum kirip abo barön. ");
INSERT INTO bjk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Me mum bele tengen ‘Mama’ xere öng kö öxöno lagunon, möxösa, ine xalik mon a Mama re mum, me ine i xisixis siso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma i kobo deek ka rengrengen te öng ke mum bara a ‘Tene sisila’, möxösa, öng mon a Sisila re mum, a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A tödi raxin kaluluonin e mum, ine irabo tultul kö pu re mum. ");
INSERT INTO bjk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ewenene niang i ii öraxin ine iat, God irabo ii ösu ine. Me ewenene niang i ii ösu ine iat, God irabo ii öraxin ine. ");
INSERT INTO bjk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek, irabo saban te mum! Mum bo babaxut pi a nangadi niang idi te mamaa rua nilaxa xö kingdom möxö watmaep. Me mum iat, mum kala laxa, ma lamun niang bara a nangadi te eka nilaxa, mum bo wewet pi a ngas se idi. ");
INSERT INTO bjk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek! Mum bo ilo abo lalaa möxöbo möxösö me mum bo osesen mabo sineseng ömat te mum. Möxö ina na, God irabo ömokorot xöba e mum. ");
INSERT INTO bjk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek! Mum bo önan eli xö rasi ma xö boxönö xirip pua xikip lo a öng kalik mon bara irabo muu a inausu re mum. Me mum mo eöt tua nilaxa xö ia sösöt. Ma lamun nang bara ine a bak ne ausu re mum im, irabo eöt tunon tua nilaxa xönan, möxösa, ibo mumuu e mum. ");
INSERT INTO bjk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“A maris se mum, mum abo marapulo! Mum bo rengrengen bara, ‘Niang bere re öng i ösugurno xö gunon lotu raxin, ina niang i laa tataun mon. Ma lamun niang bara re öng i ösugurno xö gol möxö gunon lotu raxin, ina niang ine irabo mana pet a lasa ixoro sugurno min.’ ");
INSERT INTO bjk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mum abo marapulo wawao! Nangang sa i taxin sik, a gol bara a gunon lotu raxin mon niang i pet a gol i madakdak urungan kö God? ");
INSERT INTO bjk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mum mo tengen bölök bira, ‘Niang bere ewenene re öng i ösugurno xö alta, ina niang i laa tataun mon, ma lamun bere ewenene re öng niang i ösugurno ma arabaa xönan, ine irabo pet eörin kirip abo ösugurno re ine.’ ");
INSERT INTO bjk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mum abo duöng pulo! Nangang sa i taxin sik, a arabaa bara a alta niang ibo wewet a arabaa i madakdak urungan kö God? ");
INSERT INTO bjk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Inexalik, ewe niang i ösugurno xö alta, i ösugurno bölök köbo lalaa xirip lömö xönan. ");
INSERT INTO bjk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Me ewenene niang i ösugurno xö gunon lotu raxin, i ösugurno bölök könan ma xö ewe a öng niang i kisisik könan. ");
INSERT INTO bjk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me ewenene niang i ösugurno xö watmaep, i ösugurno urso xö kinis se God ma xö öng niang i kisisik könan. ");
INSERT INTO bjk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Maris, irabo saban te mum abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek! Mum bo susulo abo lalaa möxö pet önamien a nien, xarniang a lobo, laie ma a kari. Ma xarniang a warkurai te Moses i tengen, mum bo erimine xö sangaun ne xönö me mum bo isik a öng urungan te God. Ma lamun mum kobo muu abo warkurai nang a lak taxin. Mum kobo muu a tatalien töxödös kö nangadi, ma kaim e mum ma a abalamu, ma kaim pe turunon kö to re mum. Io, irabo töxödös niang bara mum moxoro isik abo lalaa urso re God, me mum kobo lön bölök kua mumuu a tatalien deek. ");
INSERT INTO bjk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mum abo tene sisila, abo marapulo e mum! Mum bo dödöm köba lamun abo warkurai lixilik me mum bo talu abo warkurai taxin. Mum mo xarniang a önga tödi i kuluwo rua ininim. I döxömen im bara a nölnöl ma i kip tewe xalik a ari. Ma lamun i könöm kas baling im a önga bulmakau! ");
INSERT INTO bjk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek! Mum morobo gis ömaras a araman möxö kap ma dis, ma lamun a könönö idi i wöwö ma tatalien ne mamaa lamun a oleleng ne lalaa ma a mamaa möxö aneek. ");
INSERT INTO bjk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mum abo Parasi abo marapulo! Sila morobo ömaras a könönö kap ma dis, ma melamu a araman bölök irabo maras. ");
INSERT INTO bjk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek, irabo saban te mum! Mum mo xarniang a lieng möxöbo minet niang te tos öpidien niang i wawara mariris kö araman ma lamun kö könönö i wöwö ma siine nangadi minet mabo lalaa xirip a lak biling. ");
INSERT INTO bjk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xarna na mon te mum, mum mo osen bara mum mo töxödös kö wawara xö nangadi. Inexalik bara kölöme re mum i wöwö ma tatalien möxö atöxö ma tabuno tame warkurai. ");
INSERT INTO bjk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“A maris se mum, abo tene ausu möxöbo warkurai te Moses mabo Parasi, mum nang mum bo röxröxö mon bara mum a lak deek, irabo saban te mum! Mum bo ömar ödeek abo midi möxöbo propet ma mobo ögigilien inabo maöt möxöbo tene töxödös. ");
INSERT INTO bjk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Me mum bo rengrengen bara, ‘Nang bere ire toxoro to xöbo axana bung möxöbo untubuno ire, io, ire tekebeöt tua top pa sesexomet abo propet.’ ");
INSERT INTO bjk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Io, mum mo tengen ömaras baling im pe mum bara mum abo tubuno idi ewe niang idi toxo sexomet abo propet. ");
INSERT INTO bjk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Io, i wawara sik bara turunon bara mum morobo öxawam abo sasaban nang abo untubuno mum toxo ösubanain sik! ");
INSERT INTO bjk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mum abo tene atöxö! Mabo untubuno e mum bölök bie! Mum kebeöt turunon iat bara mum morobo pas ina ömokorot taxin niang kölöme xina ia sösöt. ");
INSERT INTO bjk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Inexalik, e rabo tile rebo propet, dauleng abo tene nanase, ma dauleng abo tene ausu. Ma dauleng mere idi, mum morobo sexomet lömö xö öxöno sölöxöröp, ma dauleng mum morobo dangat idi kölöme xöbo gunon ne sineseng. Me mum morobo mumuu nanin idi rua wewet ökinadik idi xöbo lagunon öngöng. ");
INSERT INTO bjk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Io, niang mum morobo sexomet idi xirip nang abo tene töxödös möxö ina öxöno lagunon, a aömokorot irabo kip e mum. Me mum moxo sexomet abo tene töxödös, urulo re Abel urungan te Sekaraia, a barok ke Berekia, ewe niang mum moxo sexomet ine kaluluon kö gunon lotu raxin ma xö alta. ");
INSERT INTO bjk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Turunon saxit, a xunuxun möxöbo tatalien saban kirip na irabo wanot pösöt ina marakörö mee nixinen. ");
INSERT INTO bjk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas ixo tengen, “Mum mee Jerusalem, maris se mum! Mum bo sesexomet abo propet me mum bo reteng idi nang e God ibo tile idi ura re mum. A oleleng ne axana bung e bo mamaa bara e rabo töndik lo e mum xarnang a nene xixök ibo böböng pi a bung barok kine ma nine wawono. Inexalik mum kobo mamaa bie. ");
INSERT INTO bjk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pere bang! Ina lagunon te mum irabo saban ma irabo malaa tataun, ma morobo pet bule? ");
INSERT INTO bjk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Io, e tengen te mum, mum mo kebeöt ta pere öbaling e ot kö axana bung niang mum morobo tengen bara, ‘God irabo pet ödeek ina tödi niang ewe irabo wanot ta wewet eörin a mamaa xö Orong.’” ");
INSERT INTO bjk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ixo önan kalik a gunon lotu raxin ma abo bak ne ausu rine toxo wan pösöt ine ma toxo mamaa ra osen ine ma mangana winara möxöbo gunon. ");
INSERT INTO bjk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ixo ose, “Mum moro pere xirip abo lalaa na? Turunon saxit, kaim pe önga wat ta irabo kis lömö xö önga wat kabise. Idi tabo öbeng ösu xirip.” ");
INSERT INTO bjk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ma nang bere Jisas ixo kisisik kiso xö Maii Olip, abo bak ne ausu xalik mon toxo ot pösöt ine. Idi toxo tengen tö ine, “Örö tengen te mem bara lause inabo lalaa na tabo ot kö inabo gunon, ma sa irabo ot ta uxileng e mem kö nuanot baling ke nöngön ma xö axana bung möxö xakawöm?” ");
INSERT INTO bjk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Me Jisas ixo balu idi bira, “Mum morobo balaure e mum, kalik ke öng ibo töxö lo e mum. ");
INSERT INTO bjk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Möxö a oleleng tabo wanot ma tabo tengen bara idi te wanot kö esene e, ma bere, ‘E mon ina Mesaia.’ Me idi tabo töxö lo a oleleng. ");
INSERT INTO bjk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mum morobo ölangen ulamun abo inarse rataxin ma ulamun abo tinenge lamun abo inarse rataxin, nexalik mum bele buut. Abo mangana lalaa na irabo ot, lamun a xakawöm angen i kala ot bang. ");
INSERT INTO bjk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Abo kantri tabo erese ma abo kantri. Mabo kingdom tabo erese mabo kingdom. Ma xöbo dauleng ne boxönö, a irilöng taxin irabo ot, mabo gie bölök. ");
INSERT INTO bjk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Inabo lalaa xirip na abo urulo möxö kinadik kö une ibo eka kip barok. ");
INSERT INTO bjk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Io, idi tabo isik e mum kö limedi rua eler e mum ma ra sesexomet e mum, ma abo kantri xirip tabo samuk e mum, möxösa, xö eseke. ");
INSERT INTO bjk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Xinabo axana bung a oleleng tabo tawuxus tewe xalik a nunu ma tabo bulus idi xöbo limine abo iuo ma tabo esamuk kaluluonin idi iat. ");
INSERT INTO bjk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma oleleng ne propet röxröxö tabo wösö ot ma tabo töxö lo a oleleng. ");
INSERT INTO bjk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma a mamaa xöbo oleleng ne nangadi saxit irabo kaim, möxösa, a tatalien saban irabo wan kaa. ");
INSERT INTO bjk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lamun ewe nang i tuu lölös sik urungan kö xakawöm, God irabo öro ine. ");
INSERT INTO bjk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma tabo tengen osen a tinenge deek möxö kingdom kö boxönö lagunon kirip pua ömaras abo kantri xirip. Bara abo laa xirip irabo kawam, melamu a xakawöm kö ina to na irabo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mum morobo pere ine nang i saban köba, nang ibo ögat lagunon, i tuu sik kö xönö madakdak. Ina na nang e propet Daniel ixoro wöwörö sik min. (Me ewe i kos ina ginigeet na, irabo maras kö unine möxö ina na.) ");
INSERT INTO bjk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","I deek bara a nangadi nang te xisixis Judeia xina bung, tabo ulo urso xöbo maii. ");
INSERT INTO bjk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ewe a öng nang i kisisik lömö xö öxöno gunon te ine, ganim bara i kaa su ra xikip ösu rewe rebo mangana lalaa xalik a gunon. ");
INSERT INTO bjk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Me ewenene nang i xisixis siso xö komo, ganim bara i su uri xö gunon ta xikip lo re xönö man te ine. ");
INSERT INTO bjk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Irabo laa ne maris köbo une nang te tienen, me idi nang te urus barok kö inabo bung na. ");
INSERT INTO bjk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mum morobo seseng bara a nuan te mum i bele ot kö axana bung möxö labur bara xö bung Sabat. ");
INSERT INTO bjk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Möxösa, niang im irabo önga purpuruan taxin, i karabo eöt ma nang möxö urulo möxö öxöno lagunon ot na. Ma melamu, kaim pe tiip bira irabo wanot baling. ");
INSERT INTO bjk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma nang bara Orong i kobo se öwuruwut inabo bung niang, kawaim pe öng irabo to. Ma lamun ine irabo se öwuruwut abo bung kua rorop idi nang ixo pere kos lo. ");
INSERT INTO bjk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kö ina bung niang, nang bara öng i tengen te mum, ‘Moro pere, a Mesaia ine na,’ bara, ‘A Mesaia ine niang,’ ganim e mum pa nunu xönan. ");
INSERT INTO bjk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Möxö idi abo mesaia röxröxö mabo propet röxröxö, idi tabo wanot. Ma tabo pet ot abo uxileng tataxin mabo mangana lalaa lölös ne auwuwus sua röxröxö lo a nangadi niang God ixoro pere kos lo, nang bara idi te eöt tua röxröxö lo idi bira. ");
INSERT INTO bjk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pere bang, e xoro tengen ösila sik ke mum köbo lasanene nang irabo ot te mum. ");
INSERT INTO bjk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Io, nang bara re öng i tengen te mum, ‘Ine niang iri ot no xö xönö tataun,’ me mum bele wan uxe. Ma nang bara re öng i tengen te mum, ‘Ine iang kölöme xö könönö gunon,’ ganim e mum pa nunu xönan. ");
INSERT INTO bjk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ma xarnang a siek nang i ot merso lömö ma urungan bölök kö xaken ibo susu e, a Barok kö Tödi irabo wanot bölök bira. ");
INSERT INTO bjk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Xöbo xönö sa nang abo minet könan, abo tago tabo oretok ee. ");
INSERT INTO bjk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kebeöt ta ömat mon melamu xinabo bung ne purpuruan, ‘a xaken irabo ködö, ma texe i kebeöt ta bibio, ma abo tii tabo subu meriso xö balana kubu, ma abo lalaa lölös meriso xö mango irabo mamagi.’ ");
INSERT INTO bjk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kö ina axana bung niang im, a uxileng kö Barok kö Tödi irabo wösö ruso xö balana kubu, ma abo kantri möxö öxöno lagunon tabo gee. Idi tabo pere a Barok kö Tödi irabo wanot kö kubu möxö mango, arixe ma lölös ma a mariris taxin. ");
INSERT INTO bjk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma irabo tile abo angelo arixe ma tauu raxin ta kinup, me idi tabo lamus etok a nangadi rine nang ixo pere kos lo. Abo angelo tabo lamus etok idi möxö nit ne marana xiki, möxö önga ngusuno xönö merso xö balana kubu urungan kö öng kabise. ");
INSERT INTO bjk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Io na, mum morobo kip inausu xalik a uno fik. Nang bara abo labana te subun kaa ma i tawalas, mum morobo ösöxö bara a axana bung möxö xaken iri lörörö rua inot. ");
INSERT INTO bjk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Xarnang iat mon, nang e mum mo pere inabo lalaa na te orot, mum morobo ösöxö bara ina axana bung iri lörörö rua inot, nang mon kö marame möxö nuan laxa. ");
INSERT INTO bjk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Turunon saxit, ina nangadi nang tabo pere inabo lalaa na, tekebeöt ta minet bang, ot nang abo lalaa na xirip irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A balana kubu ma öxöno lagunon irabo wan tup, nexalik bara a tinenge re e, i kebeöt ta xakawöm. ");
INSERT INTO bjk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ma kawaim pe öng i ösöxö sik ina bung, bara a axana bung tunon, nang abo lalaa irabo wanot. Abo angelo niso xö watmaep tokobo ösöxö, ma a Barok iat bölök, i kobo ösöxö. Lamun e Mama xalik mon i ösöxö. ");
INSERT INTO bjk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","A nuanot kö Barok kö Tödi irabo xarnang abo bung ke Noa. ");
INSERT INTO bjk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Xöbo bung nang kaim bang kö tait taxin, a nangadi toxobo aan, toxobo ininim, ma toxobo laxlaxa xöbo alolo ot kö bung nang e Noa ixo wan laxa xö mön taxin. ");
INSERT INTO bjk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Me idi kaim a ösöxö lamun te lalaa bara irabo wanot ot kö tait taxin ixo ot ma ixo kip tewe idi xirip. Irabo bie bölök nang a Barok kö Tödi irabo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A nini tödi idu tabo rörörön kölöme xö komo. Tabo kip lo a öng ma tabo gan sik a öng. ");
INSERT INTO bjk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A nini une idu tabo xuxu abo irine wit. Tabo kip lo a öng ma tabo gan sik a öng uxe. ");
INSERT INTO bjk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Io, mum morobo mana tagur sik, möxösa, mum kobo ösöxö xö bung sa a Orong ke mum irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma lamun e mum moro döxömen ödeek a na. Nang bara tamana gunon ixere ösöxö bara xö axana bung sa xö dömön a tödi pinilo irabo wanot, io, ine irabo mana werwere muu sik a gunon te ine ma i kebeöt ta ömaraxen a gunon te ine bara tabo pörök ölaxa. ");
INSERT INTO bjk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Io, mum morobo mana tumarang, möxösa, a Barok kö Tödi irabo wanot kö axana bung nang mum kobo döxömen bara irabo wanot könan. ");
INSERT INTO bjk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Me ewe iat im ina öng nang a tene nanase ma a tultul turunon ine? Ine nang a orong ixoro bulus ine bara irabo balaure abo tene tinörön kabise kölöme xö gunon tine rua tabaa ödeek idi ma nien. ");
INSERT INTO bjk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Irabo deek kö ina tultul ewe nang a orong ke ine i wanot ma i pere bara i wewet bira. ");
INSERT INTO bjk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Turunon saxit, ine irabo bulus ine rua balbalaure xirip abo lalaa re ine. ");
INSERT INTO bjk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma lamun nang bara ina tultul a lak lön, irabo tengen öbaling ke ine iat, ‘A orong ke e irabo kis tewe xö axana bung ömat,’ ");
INSERT INTO bjk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","io, irabo urulo ra sese abo tene tinörön kabise ma irabo aan ma ininim arixe mabo tene ininim. ");
INSERT INTO bjk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Io, a orong ke ine irabo wanot kö bung nang ine i kobo döxömen sik bara irabo ot könan ma xö axana bung nang i kobo ösöxö bara irabo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ina orong ke ine irabo tee ölixilik ine ma irabo tewe ine urungan kö xönö möxö kinadik arixe mabo tene röxröxö, nang kingan idi tabo gegee ma tabo engiren abo ngisine idi.” ");
INSERT INTO bjk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Io, xina bung na a kingdom möxö watmaep irabo xarnang a pii möxö sangaun ne une ewe nang toxo kip lo abo bibio ridi ma toxo wan ta susuo ma tödi inalolo maxat. ");
INSERT INTO bjk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A pitnö ridi a lak baulang, ma pitnö a lak nanase. ");
INSERT INTO bjk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Idi nang a lak baulang, idi toxo kip abo bibio ma lamun kaim idi ra xikip pebo wel arixe midi. ");
INSERT INTO bjk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Me idi nang a lak nanase, idi toxo kip abo bibio ridi arixe bölök iat ma wel. ");
INSERT INTO bjk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A tödi inalolo maxat kaim kö nuanot pasaxit, me idi toxo mara pinaluso, io, idi toxo paluso. ");
INSERT INTO bjk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Xö luono dömön a kinup ixo ot bira, ‘A tödi inalolo maxat ine na! Moro miang, moro esuo mine!’ ");
INSERT INTO bjk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Io, abo une xirip toxo laran ma toxo tagure bulus abo bibio ridi. ");
INSERT INTO bjk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A pitnö ne une baulang toxo tengen köbo une nanase, ‘Moro tabaa e mem merebo wel te mum. Abo bibio re mem i eka minet.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Inexalik abo une nanase toxo balu ma toxo tengen, ‘Kaim! A na i kebeöt te ire xirip. Mum moro wan lamun idi nang te misik ma wel ma moro kun te dauleng ke mum iat.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ma nang idi toxo wan lo ra kun wel, a tödi inalolo maxat ixo wanot. A pitnö ne une nang toxo tagur bulus, toxo wan laxa arixe mine urungan kö nien taxin möxö kubus alolo. Ma marame ixo tamabaxut. ");
INSERT INTO bjk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Inabo une xabise toxo ot belek melamu ma toxo tengen, ‘Orong! Orong! Örö sawang a marame rö mem.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ma lamun ixo tengen, ‘Turunon saxit, e kobo ösöxö e mum.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ma na im, mum morobo mana tagur sik, möxösa, mum mo köbo ösöxö a axana bung niang.” ");
INSERT INTO bjk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisas ixo tengen öbaling, “Irabo xarnang a tödi i xeka nuan kö ngas ömat, nang ine ixo kuwe abo tultul te ine ma ixo isik tewe abo lalaa rine urungan tidi rua balaure. ");
INSERT INTO bjk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ixo tabaa a öng ma pitnö ne arip ne tuluwok, ixo tabaa a öng kabise ma nini arip ne tuluwok, ma ixo tabaa a öng kabise ma önga arip ne tuluwok. Ixo erimine idi eöt ma lölös sidi. Io, ixo wan lo xö nuan te ine. ");
INSERT INTO bjk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A tödi nang ixo kip lo abo pitnö ne arip ne tuluwok, saxit mon ixo wan ma ixo rörön ma pitnö ne arip ma ixo kip a önga pitnö ne arip baling. ");
INSERT INTO bjk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Io, nangang bölök ma nini arip ne tuluwok, ixo kip a nini arip ne tuluwok baling. ");
INSERT INTO bjk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma lamun a tödi nang ixo kip lo a önga arip ne tuluwok, ixo wan lo ma ixo kin a mara xö pu ma ixo pömös ina tuluwok kö orong kine. ");
INSERT INTO bjk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Melamu xö axana bung ömat a orong möxö inabo tultul ixo wanot baling, ma ixo ötöxödös me idiet lamun abo tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ina tödi nang ixo kip lo a pitnö ne arip ne tuluwok, ixo kiwot bölök a önga pitnö xabise. Ixo tengen, ‘Orong ke e, nöngön u xo isik a pitnö ne arip ne tuluwok ke e. Örö pere. E kip lo önga pitnö ne arip baling lömö xönan.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“A orong ke ine ixo tengen, ‘A tinörön deek u pet. Tödi deek ma a tultul turunon nöngön! Nöngön u xobo rörön deek ma turunon köbo dauleng ne lalaa mon. E rabo bulus nöngön tua werwere muu a oleleng ne lalaa. Miang, ma örö axanan arixe ma orong ke nöngön!’ ");
INSERT INTO bjk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ina tödi nang ixo kip lo a nini arip ne tuluwok, ixo wanot bölök. Ixo tengen, ‘Orong ke e, nöngön u xo isik a nini arip ne tuluwok ke e. Örö pere. E kip lo önga nini arip baling lömö xönan.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“A orong ke ine ixo tengen, ‘A tinörön deek u pet. Tödi deek ma a tultul turunon nöngön! Nöngön u xobo rörön deek ma turunon köbo dauleng ne lalaa mon. E rabo bulus nöngön tua werwere muu a oleleng ne lalaa. Miang, ma örö axanan arixe ma orong ke nöngön!’ ");
INSERT INTO bjk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Io, ina tödi nang ixo kip lo a önga arip ne tuluwok, ixo wanot. Ixo tengen, ‘Orong ke e, e xo ösöxö bara nöngön kaim bara a tödi malus. E ösöxö bara e nöngön u bo xikip kö xönö nöngön u kara sulo ma u bo dixidik ögun kö xönö u kara retewe a irine iaa. ");
INSERT INTO bjk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Io, e xo buut me e xo wan tewe me e xo pömös kö pu a tuluwok ke nöngön. Örö pere. A na ina lasa nang ke nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“A orong ke ine ixo tengen, ‘Nöngön a tödi saban, a tödi lön! Me nöngön u ösöxö sik bara e bo xikip kö xönö e kara sulo me e bo dik ögun kö xönö e kara retewe a irine iaa? ");
INSERT INTO bjk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Xarnang bie, nöngön u xere mana bulus a tuluwok ke e xö gunon ne bulus tuluwok, io, nang bara arabo baling ot, e xere kip lo arixe ma nang bölök lömö.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Io, ixo tengen te idi bira, ‘Mum moro mana kip tewe ina tuluwok kalik ine ma morobo isik ine xö tultul nang i kip lo a sangaun ne tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Möxö, ewenene midi nang idi ma lalaa, God irabo tabaa idi ma oleleng, ma irabo kip lo a oleleng. Me ewenene midi nang kawaim idi mere lalaa, God irabo kip tewe bölök kirip abo lalaa xalik idi. ");
INSERT INTO bjk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Me mum morobo mana tewe ösu ina tultul lön niang kö araman urungan kö ködö lamin, nang kingan idi tabo gegee ma tabo engiren abo ngisine idi.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Me Jisas ixo tengen öbaling bira, “Nang bara a Barok kö Tödi irabo wanot ma mariris se ine arixe mabo angelo xirip pe ine, irabo kis kö kinis ne warkurai taxin te ine. ");
INSERT INTO bjk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","A nangadi möxöbo kantri xirip tabo ot etok kö wawara re ine ma irabo palang ebasin idi xarnang a tene walbalaurai möxöbo sipsip nang ibo palang ebasin abo sipsip kalik abo me. ");
INSERT INTO bjk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ine irabo bulus abo sipsip kö lime tuun te ine, mabo me xö lime kes sine. ");
INSERT INTO bjk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Io, a king irabo tengen kö marakörö niang toxo kis kö lime tuun te ine bira, ‘Mum moro miang, mum niang a Tata re e ixoro wadöane sik e mum. Mum morobo kip lo a kingdom nang ixoro tagur sik kua gene mum meringan kö nang ixo uxis a öxöno lagunon, ");
INSERT INTO bjk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","möxö mesila e xo irilöng me mum moxo tabaa e ma nien, e xo minauu me mum moxo tabaa e ma ari, e a osee me mum moxo lamus ölaxa lo e xö gunon, ");
INSERT INTO bjk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","e xo sasaxan lamun a man me mum moxo ölaulawa e, e xo meset me mum moxo balaure e, e xo kis kölöme xö gunon ne aömokorot me mum moxo wanot ta uxileng e.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Io, abo tene töxödös tabo balu ine bira, ‘Orong, lause mem moxo pere nöngön, u xo irilöng ma moxo tabaa nöngön ma nien, ma bara u xo minauu, ma moxo tabaa nöngön ma ari? ");
INSERT INTO bjk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma lause nöngön u xo wanot xarnang a osee me mem moxo ömaraxen ölaxa lo nöngön, ma bara kaim nöngön ma man ta sisige me mem moxo ölaulawa nöngön? ");
INSERT INTO bjk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma lause mem moxo pere nöngön u xo meset, ma bara nöngön u xo kis kölöme xö gunon ne aömokorot me mem moxo uxileng nöngön?’ ");
INSERT INTO bjk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma a king ixo balu, ‘E tengen tunin te mum, a lasanene nang mum moxo pet ulamun önga tödi tanaa meringan köbo töke, i xarnang mum moxo pet tö e.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Melamu ine irabo tengen te idi xö lime kes bira, ‘Mum nang mo kis kö ene ömokorot te God, moro tuwes xalik e, ma moro wan urungan kö ia sösöt nang i kara met ma i tagur sik ke Satan mabo angelo re ine. ");
INSERT INTO bjk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Möxö nang e xo irilöng, mum kaim kö tabaa e mere nien tua enen. Me e xo minauu me mum kaim kö tabaa e ma ari ra ininim. ");
INSERT INTO bjk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","E xo önga osee me mum kaim kö ömaraxen lo e. Me e xo sasaxan lamun tebo man ma kaim e mum kö ölaulawa e. Me e xo meset me e xo kis kö gunon ne aömokorot, me mum kaim kö balaure e.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Me idi bölök tabo balu bara, ‘Orong, lause mem moxo pere nöngön u xo irilöng bara u xo minauu, u xo meset ma u xo önga osee, bara u xo sasaxan lamun a man ma bara u xo kis kö gunon ne aömokorot, ma kaim e mem pa rorop nöngön?’ ");
INSERT INTO bjk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Me ine irabo balu idi bira, ‘E tengen tunin te mum, a lasanene mum kaim kö wewet kö önga tödi tanaa meringan köbo töke, i xarnang mum kaim kö wewet tö e.’ ");
INSERT INTO bjk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Me idi niang tabo wan urungan kö xönö möxö kinadik nang i kis ulorexe saxit. Ma lamun abo tene töxödös tabo wan urungan kö to ulorexe saxit.” ");
INSERT INTO bjk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Niang bara e Jisas ixoro öxawam a tinenge xöbo lalaa na, ixo tengen köbo bak ne ausu rine, ");
INSERT INTO bjk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mum mo ösöxö sik bara a Luxa ne Nuan Lexe, a nine bung kalik mon könan. Ma tabo isik tewe a Barok kö Tödi xö limine nangadi ma tabo tut ine xö sölöxöröp.” ");
INSERT INTO bjk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Io, abo pris tataxin mabo sisila möxö nangadi toxo ot etok kölöme xö gunon taxin kö sisila raxin möxöbo pris, a esene e Kaiapas, ");
INSERT INTO bjk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","me idi toxo wöwörö lamun te ngas sua öxös suxume e Jisas sua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma lamun idi toxo tengen, “Ire takarabo pet biringan kö bung ne Luxa, xalik a nangadi tabo eöngat ma tabo öpurpuruan ire.” ");
INSERT INTO bjk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Io, nang e Jisas ixo xisixis siso Betani xö gunon te Saimon, nang mesila ine ma miniset lepra, ");
INSERT INTO bjk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","me Jisas ixo kisisik ma ixo aan, io, önga une ixo wanot arixe ma botol deek ne sada nang a xinixun möxönan a lak taxin, me ine ixo linge xö öxöno e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nang abo bak ne ausu toxo pere bira, toxo bala saban me idi toxo ose öbaling idi iat, “Ruasa ine i ösek tataunin ina sada na? ");
INSERT INTO bjk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ina sada na, toxoro eöt ta xikip pe xinuxun taxin möxönan, ma toxoro eöt tua isik abo tuluwok kö nangadi maris.” ");
INSERT INTO bjk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisas ixo ösöxö sik bira ma ixo tengen te idi, “Moro ganim ine! Ruasa bara mum mo ögat köbanin ina une na? I kobo laa re mum! Ine iri pet a tatalien deek kö e. ");
INSERT INTO bjk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A nangadi maris angen tobo xisixis arixe me mum köbo bungbung kirip. Ma lamun e karabo kis ömat arixe me mum kö bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nang ine i linge a sada nang lak sixine deek kö aike, rua tagur sik e ra minet. ");
INSERT INTO bjk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Turunon saxit, kö boxönö xirip kö öxöno lagunon nang tabo etöngösen ma tinenge deek, a lasanene niang a une na ixo pet, tabo etöngösen min, ma a nangadi tabo döxömen bölök ine.” ");
INSERT INTO bjk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Io, a öng möxö ina sangaun ma ninöng, a esene e Judas Iskariot, ixo wan pösöt abo pris tataxin. ");
INSERT INTO bjk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ixo ose, “A lasa runon mum morobo tabaa e nang bara e rabo isik e Jisas kö limine mum?” Io, idi toxo kos sik kö ine a narun ne sangaun ne tuluwok ne siliwa. ");
INSERT INTO bjk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Urulo im kö inabo bung, Judas ixo wawara siwin te mangana ngas mamaran tua isik e Jisas kö limedi. ");
INSERT INTO bjk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Xö sila ne bung möxö Luxa möxö Beret Kaim a Is Könan, abo bak ne ausu toxo wanot pösöt e Jisas ma toxo ose ine, “Ule ina xönö nang nöngön u mamaa bara e mem pa tagure a nien ne Nuan Lexe re nöngön tua enen?” ");
INSERT INTO bjk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ixo balu idi, “Mu niang, mu moro wan laxa xö lagunon taxin urungan kö önga tödi me mu moro tengen te ine, ‘A Tene Ausu i tengen bara, “A axana bung ke e iri wanot. E arixe mabo bak ne ausu re e, mem marabo en ina nien ne Nuan Lexe ruso xö gunon te nöngön.” ’” ");
INSERT INTO bjk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Io, a nine bak ne ausu toxo pet inabo lalaa xarnang Jisas ixoro tengen sik kidu bie, me idu toxo tagure a nien möxö Luxa ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ixoro aien, Jisas ixo kisisik kiso xö öra arixe mabo sangaun ma ninöng ne bak ne ausu. ");
INSERT INTO bjk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma nang idi toxo an, Jisas ixo tengen te idi, “Turunon saxit, öng mere mum irabo isik e xö limine nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Idi toxo tapunuk saban, me idi öngöng toxo ose ine bara, “Turunon saxit, Orong, kaim bere e, goo?” ");
INSERT INTO bjk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Io, Jisas ixo balu idi, “Ine a öng nang i öwösö a beret kölöme xö bile arixe me e, ine irabo isik e xö limine nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A Barok kö Tödi irabo wan urungan kö minet xarnang abo propet toxoro geet lamun ine. Ma maris belek kö tödi nang irabo isik a Barok kö Tödi xö limine a nangadi. Ixoro deek köba rö ine nang bara kaim e nago xö xikip ine.” ");
INSERT INTO bjk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Io, Judas, ine nang irabo isik e Jisas kö limine nangadi, ixo tengen, “Turunon saxit, Tene Ausu, kaim bere e, goo?” Jisas ixo balu ine, “Nöngön iat mon.” ");
INSERT INTO bjk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma nang idi angen toxo aan, Jisas ixo kip lo a beret ma ixo tengen deek kö God, io, ixo pidik, ma ixo tabaa nanin abo bak ne ausu re ine min, ma ixo tengen te idi, “Mum moro kip lo ma moro en. Ina na a aike.” ");
INSERT INTO bjk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Io, ixo kip lo a kap wain, ma ixo tengen deek kö God ma ixo örarabaa idi min, ma ixo tengen, “Mum kirip moro inim könan. ");
INSERT INTO bjk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ina na a dee re e rua öturunonin a kunubus meriso re God, nang e rabo linge rua xikip tewe a magingin saban köbo oleleng ne marakörö. ");
INSERT INTO bjk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","E tengen te mum, e karabo inim ina wain mee nixinen na ot kö bung niang arabo inim öbaling ine xarnang a wain maxat arixe me mum puso xö kingdom pe Tata re e.” ");
INSERT INTO bjk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Io, idi toxo ii önga sinö me idi toxo wan lo urso xö Maii Olip. ");
INSERT INTO bjk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Io, Jisas ixo tengen te idi, “Xö ina dömön bölök, nang e mum morobo pere a lasa tabo pet tö e, mum kirip morobo buut ma morobo ulo lie e, möxö abo tinenge re God toxoro geet i tengen bira, ‘E rabo sexomet a tene werwere muu sipsip, ma a bung sipsip tabo ulo rup elixilik.’ ");
INSERT INTO bjk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma lamun melamu e rabo taru kaa baling kalik a minet ma arabo sila re mum urso Galili.” ");
INSERT INTO bjk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita ixo tengen te ine, “Niang bara a nangadi xirip te wan lie nöngön nang bara idi te pere a lasa te pet te nöngön, lamun e iat, kaim.” ");
INSERT INTO bjk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Me Jisas ixo tengen te ine bara, “Turunon saxit, nixinen kö dömön iat, mesila xö xixök irabo tenge, nöngön örobo öös kelen e xö narun ne axan.” ");
INSERT INTO bjk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lamun e Pita ixo tengen, “Nang bara e rabo met bölök arixe me nöngön, e karabo öös kelen nöngön.” Me idi xirip abo bak ne ausu toxo tengen bölök bie. ");
INSERT INTO bjk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Io, Jisas ixo wan arixe ma abo bak ne ausu rine urso xö önga xönö tobo rengrengen me Getsemani, ma ixo tengen te idi bara, “Mum moro xisixis sa me e ra wan uruo mara seseng.” ");
INSERT INTO bjk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ine ixo lamus e Pita ma a nini barok ke Sebedi arixe mine. Ma ixo tapunuk ma balana ixo örasen ögat ine. ");
INSERT INTO bjk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Io, ine ixo tengen te idi bara, “Balake iri tiip köba me e örasen bara lörörö e rabo met. Mum moro kis sa ma moro wawara deek arixe me e.” ");
INSERT INTO bjk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Me ine ixo wan ulik ma ixo subu ma wawara rine uri xö pu ma ixo seseng bara, “Mama re e, nang bara i öt, e mamaa bara örobo irewe ina tiip na xalik e, ma lamun u bele muu a mamaa re e. Kaim. Örobo muu eörin a mamaa re nöngön iat.” ");
INSERT INTO bjk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Io, Jisas ixo wan pösöt öbaling idiet narun ne bak ne ausu re ine ma ixo pere wösöt lo idiet toxo paliso sik. Me ine ixo ose e Pita bara, “Muot mo kebeöt tua kinis ma winara arixe me e xere önga awa? ");
INSERT INTO bjk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Muot morobo mana wawara ma sineseng kalik a laa ne aöwalam irabo ot pösöt e muot, me muot bo subu xö magingin saban. A turunon, a bala muot i mamaa ra wewet abo tatalien deek, ma lamun a aimuot i kobo lölös.” ");
INSERT INTO bjk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Io, Jisas ixo wan tewe xö nini axana baling ma ixo seseng bara, “Mama re e, nang bara ina tiip na i karabo wan tewe ot iat bara e rabo laxa xönan, io, e rabo muu öt ina mamaa re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma nang ixo baling, ixo pere abo bak ne ausu toxo paliso, möxösa, a maradi ixo tiip köba ra pinaliso. ");
INSERT INTO bjk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Io, ixo wan lie idi ma ixo wan tewe baling ma ixo seseng kö narun ne axan baling, ma ixo pet önga sineseng xarnang ine ixoro pet sik. ");
INSERT INTO bjk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Io, ixo tawuxus baling köbo bak ne ausu ma ixo tengen te idiet, “Muot angen mo wapaliso ma mo mamas? Pere bang, ina axana bung iri ot. Na tabo isik a Barok kö Tödi xö limine abo duöng saban. ");
INSERT INTO bjk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Taru me ire ta wan! Iri lörörö a tödi nang irabo isik tewe e!” ");
INSERT INTO bjk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma nang e Jisas angen ixo rengrenge, e Judas, öng möxö ina sangaun ma ninöng, ixo ot. A marakörö raxin toxo ot arixe mine mabo sele mabo amu. Abo pris tataxin mabo sisila möxö nangadi toxoro tile idi. ");
INSERT INTO bjk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ma ina tödi nang ixo mamaa ra isik e Jisas kö limine nangadi, ine ixoro tagure önga mangana uxileng bira, “A öng nang e rabo muum, ine mon ina tödi. Mum morobo tödik ine.” ");
INSERT INTO bjk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Saxit mon, e Judas ixo wan pösöt e Jisas ma ixo tengen, “Dömön, Tene Ausu!” Ma ixo muum ine. ");
INSERT INTO bjk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisas ixo balu, “Eis, pet a laa niang nöngön u ot lamun.” Io, idi toxo wanot pösöt e Jisas ma toxo tödik ine. ");
INSERT INTO bjk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Io, öng ke idi nang toxo tuu sik arixe me Jisas, ixo sat lo ina sele ömat te ine, ma ixo se a tödi tene tinörön möxö sisila raxin möxöbo pris, ma use ixo tee xöröp a talingine. ");
INSERT INTO bjk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Io, Jisas ixo tengen te ine, “Bulus öbaling a use re nöngön kö xönö möxönan, möxö ewe me idi niang te tön a use tabo met kö use re idi xabise. ");
INSERT INTO bjk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mum kobo ösöxö bara e öt bara e ra seng e Tata re e, ma saxit mon irabo tile ösu a oleleng ne angelo saxit tua rorop e? ");
INSERT INTO bjk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma lamun nang bara e xebe seseng bira, io, abo tinenge re God toxo geet takarabo ot eöt, möxösa, abo tinenge na i tengen bara abo lalaa na irabo mana ot bira rö e.” ");
INSERT INTO bjk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kö ina axana bung na, Jisas ixo tengen kö marakörö, “Mum mo wanot mabo sele mabo amu rua rörödik e, xarnang arixe bere e a tödi baba? Ma xöbo bungbung kirip e xobo xisixis kölöme xö xönö möxö gunon ne lotu raxin me e xobo eusu, me mum kara töndik e. ");
INSERT INTO bjk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma lamun abo lalaa na i ot bara abo tinenge möxöbo propet irabo ot eöt.” Io, abo bak ne ausu xirip toxo wan lie e Jisas ma toxo ulo rup. ");
INSERT INTO bjk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Idi nang toxo öxös lo e Jisas, toxo lamus lo ine urungan te Kaiapas, a sisila raxin möxöbo pris, ma ringan abo tene ausu möxöbo warkurai te Moses mabo sisila toxoro wan etok. ");
INSERT INTO bjk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma lamun Pita ixo mumuu e Jisas kö nuan a lak palaa ulik ot nang ine ixo wanot kö ina xönö xö lawana ngasiene a sisila raxin möxöbo pris. Ixo wan laxa ma ixo kis arixe mabo tene walbalaurai ra werwere bara tabo pet a lasa re Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Abo pris tataxin mabo kansel kirip toxo wawara siwin te mangana unine tinenge röxröxö ra wupuk e Jisas min tua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","A oleleng toxo wanot tua rengrengen ösu toxo lamun ine, ma lamun kaim idi xo werwere wösöt lo re mangana ngas sua wupuk ine. Melamu ulik, a nine tödi toxo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ma toxo tengen, “Ina tödi na ixo tengen bere, ‘E öt tua öbeng ina gunon lotu raxin te God, me e öt ta uru öbaling ine xö narun ne bung.’” ");
INSERT INTO bjk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ma a sisila raxin möxöbo pris ixo tuu kaa ma ixo tengen te Jisas bara, “Nöngön ökorobo balu re tinenge? A lasa ina tinenge na nang abo duöng na te wupuk nöngön min?” ");
INSERT INTO bjk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma lamun e Jisas ixo kis ödödö sik mon. A sisila raxin möxöbo pris ixo tengen te ine, “E usugurno nöngön me God nang i to, bara örö tengen te mem nang bara nöngön a Mesaia, a Barok kö God, bara kaim.” ");
INSERT INTO bjk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Me Jisas ixo tengen, “Maa, i xarnang u tengen. Ma lamun e tengen te mum kirip, melamu im mum morobo pere a Barok kö Tödi irabo kisisik kö kinis taxin kö lime tuun te God nang a lak lölös ine, ma irabo ot kö kubu ne watmaep.” ");
INSERT INTO bjk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Io, a sisila raxin möxöbo pris ixo laie ma ixo didii a man te ine, ma ixo tengen bara, “Iri tengen ögarin e God! Tinenge re ine eöt. Ire tebele ose öbaling kebo duöng kua rengrengen ot tebo tinenge bölök kö ina tödi. Pere na, mum moxoro ölangen bere ine i tengen ögarin e God. ");
INSERT INTO bjk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mum mo döxömen bara tabo pet bulungin ine?” Me idi xirip toxo balu ine bara, “I töxödös bere e Jisas irabo mana met.” ");
INSERT INTO bjk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Io, idi toxo gisip ine xö wawara rine ma toxo tut ine mabo limedi. Idi xabise toxo wasa ine ");
INSERT INTO bjk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma toxo tengen te ine bara, “Mesaia, örö tengen te tinenge propet im na re mem. Ewe i tut nöngön?” ");
INSERT INTO bjk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Io, e Pita ixo kisisik kingan kö xönö lawana gunon, ma önga une tultul ixo wanot pösöt ine. Ixo tengen, “Nöngön mon nang u xo arixe me Jisas meri Galili.” ");
INSERT INTO bjk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma lamun e Pita ixo öös kö mamaran tidi xirip bara, “Kaim. E kobo ösöxö lamun ina tinenge na nang u rengrengen.” ");
INSERT INTO bjk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Io, ixo wan urungan kö marame möxö nilaxa. Ma önga balik kabise ixo pere ine ringan ma ixo tengen kö nangadi niang, “Ina tödi na ibo önan arixe me Jisas mee Nasaret.” ");
INSERT INTO bjk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Me ine ixo öös baling ma ixo tengen, “Sugurno bang mon e tengen a turunon, e kobo ösöxö ina tödi!” ");
INSERT INTO bjk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A ulik mon melamu, a nangadi niang toxo ruruu ringan toxo wanot pösöt e Pita ma toxo tengen, “Turunon bara nöngön mon a öng mere idi, möxö mem me ölangen kulen kö tinenge re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Me Pita ixo tengen ölölös bara, “Sugurno bang mon e tengen a turunon te mum, e kobo ösöxö ina tödi! Nang bara e töxö, io, e mamaa bara God irabo ömokorot köbanin e.” Ma saxit mon a xixök ixo tenge. ");
INSERT INTO bjk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Io, Pita ixo döxömen lo a tinenge niang e Jisas ixo tengen bara, “Nang a xixök i kobola tenge bang, nöngön örobo öös kelen e xö narun ne axan.” Me Pita ixo wan su ma ixo gee saban arixe. ");
INSERT INTO bjk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Xö puxu bubung arixe, abo pris tataxin kirip mabo sisila möxö nangadi toxo etöngösen ma toxo ot kö önga dinödöm bara tabo sexomet e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Idi toxo kubus a nini limine ma toxo lamus ine urungan te Pailat, a tene warkurai taxin mee Rom. ");
INSERT INTO bjk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nang e Judas ewe niang ixo isik tewe e Jisas, ixo pere bara toxo kure ösaban e Jisas, ine ixo dödöm puxus ma ixo isik puxus ina narun ne sangaun ne tuluwok ne siliwa urungan köbo pris tataxin mabo sisila möxö nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma ixo tengen, “E re pet a magingin saban, möxösa, e re isik kas a tödi nang i kobo pet te sasaban urungan kö minet.” Idi toxo tengen, “Mem marabo moro belek? Nöngön iat im.” ");
INSERT INTO bjk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Io, Judas ixo tewe abo tuluwok urungan kölöme xö gunon lotu raxin ma ixo wan lo. Io, ixo wan tewe ma ixo kut öxuxut ine iat. ");
INSERT INTO bjk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abo pris tataxin toxo kip lo abo tuluwok ma toxo tengen, “I kobo eöt köbo warkurai te Moses sa bulbulus inabo tuluwok kölöme xö xönö möxö bulbulus arabaa xö gunon lotu raxin, möxösa, a xinuxun möxö minet.” ");
INSERT INTO bjk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Io, idi toxo muu önga dinödöm pa xukun lo ina xönö möxö tene pet sosopen min, bara tabo pömös nangadi osee ringan. ");
INSERT INTO bjk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ma toxo isik a ese xina lagunon bara Xönö möxö Dee i ot nixinen. ");
INSERT INTO bjk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Io, abo tinenge re propet Jeremaia ixo ot eörin bira, “Idi toxo kip lo inabo narun ne sangaun ne tuluwok ne siliwa, ina marana xinixun niang a nangadi mee Israel toxo isiksik ke ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Me idi toxo kip lo ina tuluwok ma toxo kun a xönö möxö tene pet sosopen min, xarnang a Orong ixoro tengen sik ke e bie.” ");
INSERT INTO bjk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Io, Jisas ixo tuu xö mamaran möxö sisila raxin mee Rom, ma ina sisila raxin ixo ose ine, “Nöngön a king möxöbo Judeia?” Jisas ixo balu ine bara, “Ine mon xarnang u tengen.” ");
INSERT INTO bjk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nang abo pris tataxin mabo sisila toxo wupuk ine, Jisas kaim kö balu re tinenge. ");
INSERT INTO bjk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Io, Pailat ixo ose ine, “U kobo ölangen gut abo tinenge niang te wupuk nöngön min?” ");
INSERT INTO bjk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Inexalik Jisas kaim kö babalu re tinenge ulamun abo tinenge toxo wupuk ine min. Io, ina sisila raxin ixo wuwus saban. ");
INSERT INTO bjk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Io, xö Luxa ne Nuan Lexe, Pailat ixobo walwalas ösu a önga tödi xalik a gunon ne aömokorot, a tödi nang ina marakörö toxo pere kos ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kö ina axana bung na, önga tödi a esene e Barabas nang idi toxo bulus ine xö gunon ne aömokorot. A nangadi toxo ösöxö ödeek sik ine möxöbo tatalien te ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Io, nang ina marakörö toxo ot etok, Pailat ixo ose idi, “Ewenene re idu niang mum mo mamaa bara ara ii ösu urungan te mum: Barabas bere Jisas nang tobo rengrengen ine me Krais?” ");
INSERT INTO bjk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ixo tengen bira, möxö ine ixo ösöxö bara inabo pris tataxin mabo sisila toxo bala saban te Jisas, io, idi toxo isik ot e Jisas urungan te ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nang e Pailat ixo kisisik kö kinis ne warkurai te ine, a une re ine ixo tile ina tinenge na urungan te ine bira, “Ganim pa pet te laa xina tödi na, möxö kaim ine mere sasaban, möxösa, e xoro örasen a tiip taxin arixe nixinen kö wöpönöbö lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma lamun abo pris tataxin mabo sisila toxo öraru a balna marakörö rua ose bara Barabas irabo langlanga ma bara Jisas irabo met. ");
INSERT INTO bjk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A sisila raxin ixo ose idi, “Ewenene re idu niang mum mo mamaa bara ara ii ösu urungan te mum?” Io, idi toxo balu ine, “Barabas.” ");
INSERT INTO bjk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E Pailat ixo ose idi bara, “A lasa nang e rabo pet kö Jisas nang mum bo ukuwe ine a Mesaia?” Me idi xirip toxo balu ine bara, “Tut ine xö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Me Pailat ixo ose idi, “Ruasa? A mangana sasaban sa ine ixo pet?” Ma lamun idi toxo xukup nöngösö lömö iat bara, “Tut ine xö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nang e Pailat ixo pere bara tinenge re ine ixo laa tataun, ma a purpuruan ixo urulo ra nuanot, ine ixo kip lo a ari ma ixo tos a limine mesila xö marakörö xirip. Ma ixo tengen, “E langlanga sik kalik a dee xina tödi na. A laa im pe mum iang!” ");
INSERT INTO bjk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A nangadi toxo tengen te ine, “Ganim sik a dee re ine lömö re mem ma lömö xö bung baroxorok ke mem!” ");
INSERT INTO bjk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Io, e Pailat ixo ii ösu e Barabas urungan te idi ma ixo tengen köbo umri ma toxo dangat e Jisas ma buso, ma melamu e Pailat ixo isik ine urungan te idi ra rutut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Io, abo tene inarse möxö sisila raxin mee Rom, toxo lamus ölaxa e Jisas urungan kö gunon taxin te Pailat ma toxo kuwe etoxin kirip a nangadi arse. ");
INSERT INTO bjk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Idi toxo luwes abo man te ine ma toxo ölaulawa e Jisas ma man dadan xarnang a king ibo sisige, ");
INSERT INTO bjk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","io, idi toxo kip lo a uno gargaras ma toxo pet xarnang a bubuan, ma toxo usige xö öxöno e Jisas. Idi toxo bulus a buxo xö lime tuun tine ma toxo subun kexe mesila rine ma toxo eösaxit saban tine bira, “Mem me ölet nöngön, king köbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Idi toxo gisgisip ine ma toxo ilo ina buxo ma toxo dangdangat a öxöno. ");
INSERT INTO bjk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Melamu idi toxoro eösaxit mine, idi toxo irewe ina man dadan kalik ine ma toxo ölaulawa öbaling ine ma man iat te ine. Io, idi toxo lamus ösu ine ra taba ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nang idi toxo önan lo, toxo esuo ma önga tödi mee Sairin, a esene e Saimon, me idi toxo ölölös lo ine rua xikip a sölöxöröp pe Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Idi toxo ot tiso xö xönö tobo rengrengen me Golgota. (Unine ese na bara Xönö möxö Siine Öxöno Tödi). ");
INSERT INTO bjk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma nang idi toxo isik a wain toxo arixin ma laa melmele bara re Jisas sa ininim. Inexalik ixo dem kulen, ma ixo mölök ka ininim. ");
INSERT INTO bjk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nang idi a nangadi arase toxoro taba ine xö sölöxöröp, toxo egulös satu rua erimine abo man te ine re idi iat. ");
INSERT INTO bjk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Idi toxo kisisik ma toxo balaure ödeek ine ringan. ");
INSERT INTO bjk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma lömö xö öxöno, idi toxo bulus a xönö ginigeet nang toxo puk ine min bira, “Ine e Jisas, a king möxöbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Idi toxo örabaa bölök a nine tödi pinilo arixe me ine, a öng kö lime tuun ma öng kö lime kes. ");
INSERT INTO bjk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma a nangadi nang toxo önan saxit, toxo tenge uli ine. Idi toxo urie abo öxöno idi ");
INSERT INTO bjk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ma toxo tengen te ine bara, “Nöngön mon iang örobo pörök ösu a gunon lotu raxin ma örobo uru öbaling mon kö narun ne bung, örö top öbaling iat nöngön! Nang bara nöngön a Barok kö God, na im örö wan su meringan kö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Xö ina ngas iat nang, abo pris tataxin arixe mabo tene ausu möxöbo warkurai te Moses mabo duöng taxin idi bölök toxo tenge uli ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Me idi toxo tengen öbaling bara, “Ine i rorop a nangadi xabise, ma bara bule i kebeöt ta rorop ine iat? Bere ine a King mee Israel, irabo wan su na mon kalik a sölöxöröp, ma ire tabo nunu. ");
INSERT INTO bjk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ine ixobo isik iat a nunu rine urungan kö God. Ganim e God irabo top im ine na nang bara i mamaa rö ine, möxö ixobo rengrengen, ‘E a Barok kö God.’” ");
INSERT INTO bjk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Xö ina mangana ngas a nine tödi wuwulo nang toxo örabaa idu xö nine sölöxöröp arixe mine, idu bölök toxo tenge uli ine. ");
INSERT INTO bjk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xö luono xaken a ködö ixo wanot ma ixo tawi xirip ina öxöno lagunon ot kö narun ne axana bung kö aien. ");
INSERT INTO bjk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma xö narun ne axana bung, Jisas ixo gee wösö ma ixo tengen, “Eloi, Eloi, lama Sabakatani?” A unine möxönan i tengen bira, “God te e, God te e, ruasa u wan kalik e?” ");
INSERT INTO bjk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma dauleng niang toxo tuu örörö sik toxo ölangen ina na, ma toxo tengen, “Ine i xukuwe e Elaija.” ");
INSERT INTO bjk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Saxit mon önga tödi mere idi ixo ulo ma ixo kip lo a spans. Ixo bulus ölaxa xö wain manun, ma nang a wain ixo wöwö xönan ixo kut parange xö önga iaa ma ixo sanga kaa min urungan te Jisas sa ininim. ");
INSERT INTO bjk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma a nangadi xabise toxo tengen, “Tuu bang! Ire ta pere bere Elaija irabo ot ma irabo top ine bara kaim.” ");
INSERT INTO bjk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma nang e Jisas ixoro gee wösö baling, me ine ixo isik tewe a to re ine ma ixo met. ");
INSERT INTO bjk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma saxit mon a xönö man taxin nang ibo bölö wi sik a gunon lotu raxin ixo tamadidi nine xönö meriso lömö uri arixe xö pu. A gie ixo ot mabo warawat ixo tawörök. ");
INSERT INTO bjk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Abo maöt toxo tawalang mabo töngön köbo töxödös ne minet toxo taru kaa ma toxo to. ");
INSERT INTO bjk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Idi toxo wan su xalik abo lieng möxöbo minet, ma melamu xö tinaru baling ke Jisas, idi toxo wan laxa Jerusalem a lagunon madakdak ma toxo wösö xö oleleng ne nangadi. ");
INSERT INTO bjk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nang a umri raxin me ewe midi niang toxo balaure e Jisas, toxo pere a gie ma abo lalaa niang ixo wanot, toxo buut saban ma toxo tengen, “Turunon saxit, a tödi na a Barok kö God!” ");
INSERT INTO bjk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oleleng ne balixilik bölök angen toxo tuu sik kö palaa ma toxo ngökngök köbo lasa niang ixo orot. Idi toxobo mumuu e Jisas mee Galili me idi toxo balaure ine xöbo lasa niang ibo mamaa lamun. ");
INSERT INTO bjk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kaluluon tidi, e Maria mee Makdala, me Maria nago re Jems me Josep, ma nago xö nine barok ke Sebedi. ");
INSERT INTO bjk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Niang ixoro lörörö ra aien, a orong mee Arimatia ixo wanot, a esene e Josep. Ine iat ixo önga bak ne ausu re Jisas. ");
INSERT INTO bjk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ixo wanot pösöt e Pailat ma ixo ose ine lamun a minet te Jisas. Me Pailat ixo isik a tinenge lölös bere idi tabo isik ina minet urungan te Josep. ");
INSERT INTO bjk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep ixo kip lo ina minet, ma ixo kait pi ma man maxat pidien, ");
INSERT INTO bjk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma ixo bulus ölaxa ine xö lieng maxat te ine iat niang ine ixo luok tewe xalik a wat. Io, ixo ubun pi a marana lieng ma önga wat taxin ma ixo wan. ");
INSERT INTO bjk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria mee Makdala, me Maria xabise, idu toxo kisisik kö lörörö xö lieng. ");
INSERT INTO bjk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A bung möxö tagure abo lalaa möxö bung Sabat iri kawam, ma xö bung melamu, abo pris tataxin mabo Parasi toxo wan pösöt e Pailat. ");
INSERT INTO bjk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Idi toxo tengen, “Asuono orong, mem me döxömen lo a tinenge ina tene röxröxö ixo tengen niang ixo to sik bara, ‘E rabo taru baling melamu xö narun ne bung.’ ");
INSERT INTO bjk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Io, mem me mamaa ra isik a tinenge lölös bara idi tabo balaure ödeek ina marana lieng ot kö narun ne bung irabo kawöm. Ma xalik abo bak ne ausu rine tabo wanot ma tabo pulo ina töngön ma tabo tengen kö nangadi bara iri taru baling kalik a minet. Ma ina mangana tinenge töxö na irabo saban köba xö niang i araun.” ");
INSERT INTO bjk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat ixo tengen, “Mum moro wan, moro lamus lo a dauleng ne umri rua balbalaure ödeek ina marana lieng xarnang mum mo eöt tua wewet pi.” ");
INSERT INTO bjk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Io, idi toxo wan lo ma toxo balaure ödeek ina lieng biringan. Idi toxo isewi a wat nang ixo pet pi sik a marna lieng, ma toxo wan lie sik abo umri rua balbalaure ödeek ine. ");
INSERT INTO bjk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Melamu xö Sabat, xö puxu bubung kö Sade, Maria mee Makdala, me Maria xabise, idu toxo wan lo rua werwere ina lieng ne minet. ");
INSERT INTO bjk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","A gie raxin ixo ot, möxösa, önga angelo xö Orong ixo wan su meruso xö balana kubu. Ixo wan pösöt ina lieng ma ixo ubun tewe ina wat ma ixo kis kaa sik könan. ");
INSERT INTO bjk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A winara re ine ixo bio xarnang a siek, ma ina man tine ixo pidien köba saxit. ");
INSERT INTO bjk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Abo umri nang toxo balaure sik ina lieng ne minet, toxo buut köba, io, toxo dede xirip ma binuut ma toxo xarnang abo tödi minet. ");
INSERT INTO bjk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A angelo ixo tengen kö nini une, “Ganim e mu ra binuut. E ösöxö bere mu mo wawara siwin e Jisas, ewe niang toxo taba ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kaim ine ra, me ine iri taru baling kalik a minet, xarnang ine ixoro tengen sik. Mu moro miang ma moro pere ina xönö niang toxo ömarin ine e. ");
INSERT INTO bjk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma na iat mon, mu moro wan saxit ma moro tengen köbo bak ne ausu re ine, ‘Ine iri taru baling kalik a minet me iri sila re mum uri Galili. Ma ri, mum morobo pere ine.’ Io, mu moro döxömen lo ina lasa e re tengen sik ke mu.” ");
INSERT INTO bjk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Io, a nine une toxo wan saxit mon kalik ina lieng, idu toxo buut ma lamun toxo wöwö ma axanan, ma toxo ulo rua rengrengen osen abo bak ne ausu rine. ");
INSERT INTO bjk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Saxit mon, Jisas ixo esuo me idu. Me ine ixo tengen, “Puxu.” Idu toxo wanot pösöt ine, me idu toxo töndik a xexene ma toxo lotu rine. ");
INSERT INTO bjk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Io, Jisas ixo tengen te idu, “Ganim e mu ra binuut. Mu moro wan ma moro tengen köbo tönö re e bara idi tabo wan uruso Galili. Me idi tabo pere e ringan.” ");
INSERT INTO bjk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Io, nang a nine une toxo önan kö ngas, a dauleng ne umri nang toxo balaure ina lieng ne minet, toxo wan laxa xö lagunon taxin ma toxo tengen osen köbo pris tataxin lamun abo lalaa xirip nang ixo wanot. ");
INSERT INTO bjk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma nang abo pris tataxin toxo wanot etok arixe mabo sisila, toxo ot kö önga dinödöm, me idi toxo tabaa abo umri ma oleleng ne tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Me idi toxo rengrengen te idi, “Mum morobo tengen bara, ‘Abo bak ne ausu rine toxo wanot kö dömön ma toxo pulo rewe ine nang mem moxo paliso.’ ");
INSERT INTO bjk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nang bara ina sisila raxin mee Rom i ölangen bira, mem marabo ötöxödös arixe mine, re mum pa malaa wes xalik ina tiip.” ");
INSERT INTO bjk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Io, abo umri toxo kip lo abo tuluwok ma toxo pet xarnang toxoro tengen te idi. Ma ina pii ixoro wan elixilik kaluluonin abo Judeia ot kö ina axana bung na. ");
INSERT INTO bjk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Io, a sangaun ma öng ne bak ne ausu toxo wan uruso Galili, xö maii niang Jisas ixo tengen te idi ra nuan uxe. ");
INSERT INTO bjk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nang idi toxo pere ine, idi toxo lotu wösöt ine, ma lamun dauleng toxo nine dinödöm sik. ");
INSERT INTO bjk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Io, Jisas ixo wanot pösöt idi ma ixo tengen, “Abo lölös kirip nuso xö watmaep ma xö öxöno lagunon, a Tata re e ixoro tabaa e min. ");
INSERT INTO bjk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Io, mum moro wan ma moro pet abo bak ne ausu möxöbo kantri xirip, me mum morobo baptais idi xö esene e Mama ma ina Barok ma ina Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Me mum moro usu idi ra tame abo lalaa xirip e xoro tenge lölös se mum pua wewet. Ma i maras pi sik, e bo arixe me mum köbo bung kirip ot kö axana bung möxö xakawöm.” ");
INSERT INTO bjk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","A urulo möxö ina na lamun a tinenge deek ke Jisas Krais, a Barok kö God. ");
INSERT INTO bjk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God ixo tengen kölöme xö ginigeet te propet Aisaia bira: “E rabo tile re tene kip tinenge re e mesila re nöngön, ewe nang irabo tagure a ngas se nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“A inöno öng i xukup kö xönö tataun, ‘Tagure a nuan möxö Orong, ötöxödös a ngas sö ine.’” ");
INSERT INTO bjk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Io, Jon a tene baptais ixo wanot kö xönö tataun, ixo baptais ma ixo etöngösen bara, “Mum moro kip lo a baptais sa osen bara mum muru dödöm puxus. Me God irabo döxömen taun abo magingin saban te mum.” ");
INSERT INTO bjk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma nangadi oleleng mee Judeia arixe mabo nangadi mee Jerusalem, toxo wan lo urungan te Jon. Idi toxo tengen ösu bara idi abo duöng saban, ma ixo baptais idi xö Ari Jordan. ");
INSERT INTO bjk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ixo sige a man nang toxo pet ma bebene kamel ma ixo kie ine ma lewene bulmakau, ma ixobo enen a kö ma musien. ");
INSERT INTO bjk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma tinenge rine bira, “Önga tödi irabo wanot melamu re e, i taxin köba re e. E kobo töxödös eöt ta tinunsu ra walwalas a kililöng kalik a nine sandel te ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","E baptais e mum ma ari, lamun ine xalik irabo baptais e mum ma Töxödös ne Tanono.” ");
INSERT INTO bjk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Xina bung nang e Jisas ixo wanot meruso Nasaret kölöme Galili, ma ixo kip lo a baptais xalik e Jon kö Ari Jordan. ");
INSERT INTO bjk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma nang e Jisas ixo wan kaa xalik a ari ixo pere a balana kubu ixoro tamasawang ma Tanono ixo wan su lömö rine xarnang a buno. ");
INSERT INTO bjk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Io, a inöno öng ixo ot meruso xö balana kubu ma ixo tenge bira, “Nöngön ano Barok ke e. E mamaa lamun me e axanan köba re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Saxit mon, a Tanono ixo tile ine urungan kö xönö tataun, ");
INSERT INTO bjk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","me ine ixo kis kö xönö tataun kö nit ne sangaun ne bung. E Satan ixo könönöin ine ma ixo kis arixe mabo gineme axe, nexalik abo angelo toxo top ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Io, nang toxoro öxös lo e Jon ma toxo ölaxa ine xö gunon ne aömokorot, Jisas ixo wan laxa urso Galili ma ixo etöngösen nana ma tinenge deek ke God. ");
INSERT INTO bjk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Me Jisas ixo tengen, “A axana bung ire kis eöt. A kingdom kö God iri lörörö. Moro dödöm puxus ma moro nunu xö tinenge deek.” ");
INSERT INTO bjk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Bara e Jisas ixo önan kö gegene tu Galili, ixo pere e Saimon, ma tönö rine, e Endru. Idu toxo retewe eben kö ari, möxösa, idu a nine tene kip inan. ");
INSERT INTO bjk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Me Jisas ixo tengen tidu, “Mu moro miang ma moro muu e, e rabo usu e mu ma ngas möxö xikip a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Io, saxit mon, idu toxo wan lie abo eben te idu ma toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma nang e Jisas ixo wan ulik mon, ixo pere e Jems a barok ke Sebedi, arixe ma tönö e Jon kö mön, idu toxo marangas bulus abo eben. ");
INSERT INTO bjk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma saxit mon, ixo kuwe idu me idu toxo wan lie e tamadu xö mön arixe mabo nangadi tinörön ma toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Me Jisas mabo bak ne ausu toxo wan uruso Kaprenaum. A bung Sabat ixo ot, me Jisas ixo wan laxa xö gunon ne sineseng köbo Judeia ma ixo usu a nangadi. ");
INSERT INTO bjk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nangadi toxo wuwus kö ausu rine, möxösa, ixo usu idi xarnang a tödi iri kip lo a lölös sua inausu, kaim xarnang abo tene ausu möxöbo warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Io, önga tödi kölöme xö gunon ne sineseng ke idi nang a tano saban ixo kis sine, ixo gee wösö bira, ");
INSERT INTO bjk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas mee Nasaret, u mamaa ruasa xalik e mem? U wanot ta ögarin esexerein e mem? E ösöxö sik nöngön, bere nöngön Öng Ewe Nang a lak Madakdak meriso re God!” ");
INSERT INTO bjk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Me Jisas ixo köö ina tano saban, ma ixo tengen, “Örö ödödö, ma wan su xalik ine.” ");
INSERT INTO bjk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A tano saban ixo ögögöng ina tödi, io, ixo wan su xalik ine ma kinup taxin. ");
INSERT INTO bjk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A nangadi toxo wuwus saban arixe, ma toxo ose öbaling iat idi bira, “A lasa ia? A ausu maxat ma lölös! Ine bo isik tinenge lölös urungan köbo tano saban me idi tobo tame ine.” ");
INSERT INTO bjk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Io, a atöngösen tue Jisas ixo wan pasaxit kö boxönö xirip mee Galili. ");
INSERT INTO bjk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Io, Jisas mabo bak ne ausu rine toxo wan su xalik a gunon ne sineseng. Ma saxit mon, idi toxo arixe me Jems me Jon urungan kö gunon te Saimon me Endru. ");
INSERT INTO bjk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A taön te Saimon ixo maru sik ma malao xö öra, me idi toxo töngösen e Jisas me ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Io, Jisas ixo wan urungan te ine, ixo tön lo a limine ma ixo tön öraru ine. A malao ixo kawam kalik ine ma ixo urulo ra tabaa nienin idi. ");
INSERT INTO bjk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Xina aien, nang a xaken ixoro kis döröng, a nangadi toxo kip ot abo duöng miniset me idi nang abo tano saban toxoro tup pe idi urungan te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A nangadi oleleng köba möxö ina lagunon taxin idi toxo ot etok kö marame. ");
INSERT INTO bjk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Me Jisas ixo ölanglanga a oleleng ne nangadi ma mangana miniset. Ma ixo irewese a oleleng ne tano saban, nexalik mon kaim ine ra ömaraxen abo tano saban ta tinenge, möxösa, idi toxoro ösöxö ewe iang ine. ");
INSERT INTO bjk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Xö puxu bubung, nang ixo ködö xudun, Jisas ixo laran ma ixo wan lie a gunon, ma ixo wan lo urungan kö xönö tataun, ma ixo seseseng. ");
INSERT INTO bjk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E Saimon mabo nangadi mere ine toxo wan ta winara re Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma nang idi toxo pere wösöt ine, idi toxo tengen bira, “Nangadi xirip te wawara siwin nöngön!” ");
INSERT INTO bjk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisas ixo balu, “Ire ta wan urungan köbo lagunon lörörö, io nang, e öt ta palas tinenge bölök kidi e, möxösa, e ot ulamun.” ");
INSERT INTO bjk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Io, ixo wan kö boxönö xirip mee Galili, ixo palas tinenge xöbo gunon ne sineseng kidi ma ixo irewese abo tano saban. ");
INSERT INTO bjk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A tödi ma miniset lepra ixo ot pösöt e Jisas ma ixo subun kexe mesila rine ma ixo seng ine, “Nang bara u mamaa, nöngön u eöt ta öxawam a miniset lepra xalik e bara e ra madakdak.” ");
INSERT INTO bjk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Me Jisas ixo sasanga ma limine ma ixo tön ine möxö ixo balamu ine. Ine ixo tengen te ine, “E mamaa. Örö deek.” ");
INSERT INTO bjk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saxit iat mon a miniset lepra ixo wan kalik ine ma ixo langlanga. ");
INSERT INTO bjk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisas ixo uguran tewe ine arixe ma tinenge lölös bira, ");
INSERT INTO bjk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ganim bara u tengen osen kere öng. Inexalik örö wan ma örö osen nöngön kö pris ma örö isik abo arabaa ne söngsöngöt eöt ma warkurai te Moses bara örobo deek baling. Ma irabo xarnang a atöngösen maras sö idi bara a turunon bere u xoro langlanga.” ");
INSERT INTO bjk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lamun ine ixo wan ma ixo etöngösen maras nana ma tinenge. Unine möxönan, Jisas kaim a nilaxa xö lagunon taxin kö mamaran kö nangadi, ma lamun ixo xisixis kö boxönö nang kaim pe nangadi xönan. Inexalik a nangadi angen toxo orot pösöt ine möxö boxönö xirip. ");
INSERT INTO bjk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nang ne bung melamu, Jisas ixo wan laxa baling kö Kaprenaum. Io, a nangadi toxo ölangen bara ixoro wanot kö lagunon. ");
INSERT INTO bjk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Io, a oleleng ne nangadi toxo ot etok ma kölöme xö gunon ixo wöwö xöba, ma araman kö marame bölök kawaim pe xönö ixo langlanga. Me Jisas ixo palas tinenge ma tinenge re God urungan tidi. ");
INSERT INTO bjk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dauleng ne duöng toxo ot ma pengpeng. Ma nit ne tödi toxo kip ine. ");
INSERT INTO bjk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nang idi kaim a eöt ta kip ot ine urungan te Jisas, möxösa, a marakörö toxo oleleng, io, idi toxo pök a öxöno gunon lömö re Jisas, me idi toxo ösölöng ösu a ben arixe ma pengpeng könan. ");
INSERT INTO bjk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas ixo pere a nunu ridi, ixo tengen kö pengpeng, “Barok, na iat mon a magingin saban te nöngön iri kawam.” ");
INSERT INTO bjk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dauleng abo tene ausu möxöbo warkurai te Moses toxo kisisik ma toxo döxömen suxume re idi iat bira, ");
INSERT INTO bjk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ruasa ina tödi na i tenge bira? Ine i tengen ögarin e God. Kaim pe öng i öt ta kip tewe a magingin saban, nexalik bara e God kalik mon.” ");
INSERT INTO bjk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Saxit mon, Jisas ixo ösöxö xulen abo dinödöm kö kat tidi. Jisas ixo tengen te idi, “Rösa mum mo dödöxömen inabo lalaa na? ");
INSERT INTO bjk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nangang sa ridu i malus sa rengrengen? I malus se e ra tengen kö pengpeng bira, ‘A magingin saban te nöngön iri kawam’? Bara i malus se e ra tengen, ‘Tuu lömö, kip lo a ben te nöngön ma örö wan’? ");
INSERT INTO bjk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Ma lamun eka osen e mum bara a Barok kö Tödi ine ma lölös kö öxöno lagunon tua irewese a magingin saban.” Ma ixo tengen kö pengpeng, “E tengen te nöngön, tuu lömö ma örö kip lo a ben te nöngön ma örö wan urungan kö ngasiem.” ");
INSERT INTO bjk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Io, ina tödi na ixo taru ma ixo kip lo a ben te ine ma ixo wan kö mamaran kö nangadi xirip. Me idi xirip idi toxo wuwus me idi toxo ölet e God, “Ire tekala pere re laa bira.” ");
INSERT INTO bjk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Io, Jisas ixo wan baling melamu xö gegene tu Galili. A marakörö raxin toxo ot pösöt ine, me Jisas ixo usu idi. ");
INSERT INTO bjk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma nang ine ixo wan saxit, ixo pere e Lewi, a barok ke Alipaio, ixo kisisik kö xönö möxö kip takis. Me Jisas ixo tengen te ine, “Örö muu e!” Me Lewi ixo tuu lömö ma ixo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Melamu, nang e Jisas mabo bak ne ausu rine toxo aan kö gunon te Lewi, a oleleng ne tene kip takis mabo ‘duöng saban’ toxo aan arixe mine mabo bak ne ausu rine, möxösa, oleleng ke idi tobo mumuu ine. ");
INSERT INTO bjk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nang abo tene ausu möxöbo warkurai te Moses, nang idi abo Parasi, toxo pere bere e Jisas ixo aan arixe mabo ‘duöng saban’ mabo nangadi möxö kip takis, idi toxo ose abo bak ne ausu rine bira, “Ruasa i aan arixe mabo tene kip takis mabo ‘duöng saban’?” ");
INSERT INTO bjk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas ixo ölengen abo Parasi, io, ixo tengen te idi bira, “A nangadi nang kaim a miniset, idi tekara sasaxan ulamun a tene aule, nexalik idi xalik nang a lak miniset. E kobo ot ta xukuwe abo tene töxödös. Kawaim, e ot lamun a nangadi saban.” ");
INSERT INTO bjk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Io, abo bak ne ausu re Jon ma abo Parasi toxo ölölö. Ma toxo ot pösöt e Jisas ma toxo ose ine, “Ruasa abo bak ne ausu re Jon ma abo bak ne ausu möxö Parasi bölök toxo ölölö, lamun abo bak ne ausu re nöngön kalik, kaim?” ");
INSERT INTO bjk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas ixo balu idi, “Bule bara a bung osee möxö tödi alolo maxat, tabo ölölö nang bara ine angen arixe midi? Kaim. Idi tokobo eöt kö bung nang a tödi alolo maxat i nangen arixe midi, möxösa, idi tabo axanan iat. ");
INSERT INTO bjk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ine xalik, a axana bung irabo wanot nang tabo kip lo ina alolo maxat kalik idi. Ma xina bung nang, idi tabo ölölö im. ");
INSERT INTO bjk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Kaim pe öng ibo sösöxö a xönö sewene man maxat lömö xö man maut. Nang bara i pet bie, a xönö sewene man maxat irabo tamaliling lo xalik ina xönö man maut, ma irabo pet ötamadidi ma irabo saban arixe. ");
INSERT INTO bjk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma kaim pe öng ibo linglinge a wain maxat nang i kobola ebobot bang kölöme xö önga laa mo kuluwo ari nang toxo pet ma lewene meme maut i lelet sik. Nang bara i pet, a wain irabo ebobot kaa ma irabo pörök ina lewene meme. Ma wain ma lewene meme idu xirip tabo saban. Kawaim bie, ibo riri a wain maxat kö lewene meme maxat.” ");
INSERT INTO bjk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Io, xö önga Sabat, Jisas arixe mabo bak ne ausu rine toxo wan kaluluonin a komo wit, mabo bak ne ausu rine toxo pit köröp lo a uleng ne xurxurno wit. ");
INSERT INTO bjk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mabo Parasi toxo tengen te ine, “Pere bang! Ruasa abo bak ne ausu re nöngön, idi te pet biringan? Idi tokobo mumuu a warkurai möxö bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Io, Jisas ixo balu, “Mum moxoro kos abo laa mesila nang e Dewit ixo pet nang ine ixo irilöng ma sasaxan tua nien arixe mabo duöng nang toxo wan arixe mine. ");
INSERT INTO bjk_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","E Dewit ixo wan laxa xö gunon te God köbo bung ke Abiata, a sisila raxin möxöbo pris, ma ixo en a beret nang tobo tabaa e God min. Mabo warkurai te Moses i tengen bara abo pris kalik tobo enen ina beret na. Ma ixo tabaa bölök abo duöng nang toxo wan arixe mine.” ");
INSERT INTO bjk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Me ine ixo tengen tö idi, “God ixo pet a bung Sabat tua rorop a tödi, ma i koxobo pet a tödi ulamun a bung Sabat. ");
INSERT INTO bjk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Möxö ina na, a Barok kö Tödi i kure bölök a bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Önga bung kabise, Jisas ixo wan laxa kölöme xö gunon ne sineseng möxöbo Judeia, ma önga tödi ma lime met nangen nang. ");
INSERT INTO bjk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dauleng ke idi nang toxo kisisik kingan, toxo werwere ine nang bara irabo ölanglanga ine xö Sabat bara kaim, io, niang ke idi ra wupuk ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Io, Jisas ixo tengen kö tödi niang a lime met, “Örö tuu lömö mesila xö nangadi xirip.” ");
INSERT INTO bjk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Me Jisas ixo ose idi, “Mum moro dödöm deek, a sa xö warkurai te Moses i tengen bara i töxödös bara tabo pet kö bung Sabat? I deek sik ka rorop bara rua ögarin, ma rua öro re öng bara rua sexomet te öng?” Lamun idi toxo ödödö. ");
INSERT INTO bjk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas ixo wawara nana ma ixo laie. Ma ixo tapunuk köba, möxösa, abo balana idi ixo lölös. Io, ixo tengen kö tödi, “Sasanga kaa ma limem.” Io, ine ixo sasanga kaa ma limine, ma a limine ixo deek baling. ");
INSERT INTO bjk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Io, abo Parasi toxo wan lo ma toxo pingit arixe mabo tene mumuu re Erot tua wewet te ngas sua sesexomet e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas arixe mabo bak ne ausu re ine toxo wan lo ma toxo ot kö tu Galili. A marakörö raxin mee Galili toxo muu idi. ");
INSERT INTO bjk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nang idi toxo ölangen inabo lalaa Jisas ixo wewet, oleleng ne nangadi toxo ot pösöt ine mee Galili, Judeia, Jerusalem, Idumaia ma ina xönö lawana Ari Jordan ma boxönö lörörö Tair ma Saidon. ");
INSERT INTO bjk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nang ixo rataxin a marakörö, Jisas ixo tengen köbo bak ne ausu rine bara idi tabo tagure sik ke mon, io, nang idi takarabo emorop pönö ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jisas ixo tengen ina na, möxö ixoro ölanglanga a oleleng, io, a nangadi miniset toxo exöxöp silain idi ra sisigi ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nang a nangadi ma tano saban tobo pere e Jisas, idi tobo subu mesila rine ma tobo tengen bira, “Nöngön a Barok kö God.” ");
INSERT INTO bjk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Lamun ine ixo isik abo tinenge lölös se idi ra ganim a rengrengen osen bara ewenene ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas ixo wan kaa urso xö lawana maii ma ixo kuwe a nangadi ine ixo mamaa lamun, me idi toxo ot pösöt ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Io, ixo pere kos lo a sangaun ma ninöng ma ixo isik a ese ‘aposol’ te idi. Io, ixo pere kos idi bara idi tabo kis arixe mine ma bara irabo tile elixilixin idi rua palas tinenge ma rua kip lölös sua xikip tewe abo tano saban. ");
INSERT INTO bjk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Abo sangaun ma ninöng ne tödi nang ixo pere kos lo idi, e Saimon nang e Jisas ixo isik a ese ‘Pita’, ");
INSERT INTO bjk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Jems a bak ke Sebedi ma tönö ine Jon (ixo tabaa idu ma ese Boaneges, a unine möxönan bara, ‘A Nangadi Xarnang a Barawagas’), ");
INSERT INTO bjk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batolomiu, Matiu, Tomas, Jems a barok ke Alpius, Tadius, Saimon nang toxo tengen bara ine ina Silot, ");
INSERT INTO bjk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","me Judas Iskariot, a tödi nang ixo isik tewe e Jisas kö limine nangadi. ");
INSERT INTO bjk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Io, Jisas ixo laxa xö önga gunon, ma marakörö toxo ot etok baling. Möxö ina na Jisas mabo bak ne ausu re ine kaim kö eöt iat ta nien. ");
INSERT INTO bjk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nang a nago mabo tönö e Jisas toxo ölangen bira, idi toxo wan ta werwere ine, möxö a nangadi toxo rengrengen bara, “Ine iri baulang.” ");
INSERT INTO bjk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma abo tene ausu möxöbo warkurai te Moses niang toxo wan su meriso Jerusalem, idi toxo tengen, “Ine ma tano saban nang tobo rengrengen ma Belsebul! Ine a sisila möxöbo tano saban ibo tabaa ine ma lölös sa xikip tewe abo tano saban.” ");
INSERT INTO bjk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Io, Jisas ixo kuwe lo idi urungan tine ma ixo tenge wuo ridi, “Bara bule e Satan, i eöt ta kip tewe Satan? Kaim. ");
INSERT INTO bjk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nang bara bung marapun tekobo tuu arixe, ina bung marapun nang tekebeöt ta kinis deek. ");
INSERT INTO bjk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma nang bara kinis sine barama i tawörök, ina barama nang tekebeöt ta kinis deek. ");
INSERT INTO bjk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma nang bara a nangadi re Satan te öbulubun idi iat ma te subu, io, tekebeöt ta tinuu lölös, lamun Satan iri kawam sik mon. ");
INSERT INTO bjk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kaim pe önga tödi i eöt ta wörwörök ölaxa re gunon kere önga tödi lölös ma irabo pulo rewe abo lalaa re ine nang bara i kala kut dik bang ina tödi lölös, ma melamu irabo wuwulo xö ina gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Turunon saxit, God irabo kip tewe abo mangana magingin saban kirip möxö nangadi, ma nang bara te tengen ögarin önga tödi, irabo döxömen taun ine bölök. ");
INSERT INTO bjk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma lamun ewe nang i tengen ögarin a Töxödös ne Tanono, God i karabo döxömen taun ine. Ina magingin saban na, irabo kis ulorexe ma kaim pe öxöwöm.” ");
INSERT INTO bjk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas ixo tengen bira, möxösa, idi toxo tengen, “Ine ma tano saban.” ");
INSERT INTO bjk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Io, a nago mabo tönö e Jisas toxo wanot, idi toxo tuu sik kö araman ma toxo tile önga tödi ra lalamus lo ine. ");
INSERT INTO bjk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A marakörö toxo kis elulurwe ine, me idi toxo tengen te ine, “A nago re nöngön mabo töm, idi ia xö araman te wawara re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ine ixo ose, “E rabo tengen ösu bara ewe a nago re e, ma ewe abo töke.” ");
INSERT INTO bjk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Io, ine ixo pere idi nang toxo kis elulurwein sik ine ma ixo tengen, “Idi na abo nago mabo töke. ");
INSERT INTO bjk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ewe nang i mumuu abo lasanene nang e God i mamaa bara irabo pet, ine a töke, a saxake ma a nago re e.” ");
INSERT INTO bjk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Melamu, Jisas ixo urulo öbaling a inausu xö gegene tu Galili. Mabo marakörö nang toxo ot etok elulurwein ine ixo taxin köba, io, ine ixo kis laxa xö mön nang kö tu, ma marakörö toxo kis muu a gegene tu. ");
INSERT INTO bjk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ine ixo usu idi ma oleleng ne lalaa xö tinenge öwuo, ma kölöme xö ausu rine ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ölengen! A önga tödi ixo wan tua retewe abo irine wit kö komo. ");
INSERT INTO bjk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma nang ine ixo retewe nanin abo irine wit, a dauleng toxo subu melamu xö ngas, ma bung pun toxo wanot ma toxo en idi. ");
INSERT INTO bjk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma dauleng ne irine wit toxo subu xö öxöno wat nang kaim pe pu oleleng könan. A irine wit ixo das kaa pasaxit mon, möxösa, a pu ixo wöwöt. ");
INSERT INTO bjk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma xaken ixo tuu, ixo dek abo wit ma ixo mölös ma ixo met, möxösa, abo buon kaim kö sinu xöba uri xö pu. ");
INSERT INTO bjk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Dauleng ne irine wit toxo subu kaluluonin abo gargaras. Ma abo gargaras toxo pari abo wit nang i dadas kaa, io, abo irine wit kaim kö ino. ");
INSERT INTO bjk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lamun a uleng ne irine wit toxo subu xö pu deek. Idi toxo das kaa ma toxo oleleng, ma toxo o. Dauleng ixo o eöt ma narun ne sangaun ne irine, dauleng toxo pitnö ma öng ne sangaun, ma dauleng toxo eöt ma önga mar ne irine wit.” ");
INSERT INTO bjk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Io, Jisas ixo tengen, “Ewe nang ine ma talingine ra ölöngö, ine irabo ölangen.” ");
INSERT INTO bjk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Xö axana bung nang ine xalik, a sangaun ma ninöng ne bak ne ausu mabo duöng nang toxo elulure ine, toxo ose ine lamun abo tinenge öwuo. ");
INSERT INTO bjk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ine ixo tengen te idi, “God ixoro tabaa e mum ma nanase möxö kingdom kö God. Lamun kö nangadi nang kö araman möxö kingdom, abo laa xirip idi tabo ölangen kö tinenge öwuo. ");
INSERT INTO bjk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Io, nang, ‘idi tabo wawara ma wawara, lamun idi tekebeöt ta werwere xulen te laa, me idi tabo ölöngö ma ölöngö, ma lamun idi tekebeöt ta ölangen kulen, xalik idi tabo dödöm puxus me God irabo döxömen taun abo magingin saban te idi.’” ");
INSERT INTO bjk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Io, Jisas ixo tengen köbo bak ne ausu, “Bule, mum kobo laa maras lamun ina tinenge öwuo na? Nang bara kaim, mum korobo öt ta ösöxö rebo tinenge öwuo. ");
INSERT INTO bjk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A tamana komo i susulo a tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dauleng ne nangadi te eöt ma wit i subu xö ngas nang te sulo a tinenge, i xarnang a nangadi tere ölengen a tinenge ma saxit mon Satan ibo ot ma ibo xikip tewe abo tinenge nang toboro sulo kölöme re idi. ");
INSERT INTO bjk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma dauleng te eöt ma irine wit i subu xö pu warawat. Idi te ölangen a tinenge, ma pasaxit mon te axanan tua xikip lo. ");
INSERT INTO bjk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma lamun idi tobo tuu ulik mon, möxösa, kaim idi ma buon. Nang bara tiip ma sasaban i ot möxö idi te kip a tinenge, ma saxit mon idi toboro wan tewe. ");
INSERT INTO bjk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma nangen a dauleng ne nangadi, idi te eöt ma irine wit i subu kaluluon köbo gargaras. Idi te ölengen a tinenge. ");
INSERT INTO bjk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Me idi te döxömen köbanin abo lalaa möxö öxöno lagunon ma ulamun a kinis ne orong nang ibo röxröxö rewe idi, me idi tobo mamaa xöba lamun a mangana lalaa xabise. Inabo lalaa ibo önan laxa ma ibo wewet pi a tinenge re God, ma i kobo eöt ta o re pasuno. ");
INSERT INTO bjk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dauleng ne nangadi te eöt ma irine wit i subu xö pu deek. Idi te ölengen a tinenge, me idi te kip lo, me idi te o a pasuno. Dauleng tabo o narun ne sangaun ne irine wit, ma dauleng ma pitnö ma öng ne sangaun ne irine wit ma dauleng ma önga mar ne irine wit.” ");
INSERT INTO bjk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Me ine ixo tengen te idi, “Mum bo xikip ölaxa a laam rua uxis kö ene bile bara xö ene öra? Kawaim, a laam morobo uxis lömö xö xönö iat möxönan. ");
INSERT INTO bjk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Abo laa sanene niang i mun sik, i xarna na niang irabo wanot kö maras. Mabo laa sanene niang i kait pi sik, i xarna na niang irabo wanot kö malmalan. ");
INSERT INTO bjk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nang bere ewenene re öng ma talingine ra ölöngö, ine irabo mana tam.” ");
INSERT INTO bjk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Me ine ixo tengen bölök kö idi bira, “Mum morobo mana balaure ödeek a lasa mum mo ölengen. God irabo isik puxus urungan te mum xarnang iat mum mu ölangen kulen. Ma irabo öwöwö öbaling urungan te mum. ");
INSERT INTO bjk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ewenene midi nang idi ma lalaa, God irabo tabaa idi ma oleleng. Me ewenene midi nang kawaim idi mere lalaa, God irabo kip tewe bölök kirip abo lalaa xalik idi.” ");
INSERT INTO bjk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Me Jisas ixo tengen bölök bira. “A kingdom kö God i xarnang a tödi i tewe nanin a irine wit kö pu. ");
INSERT INTO bjk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ma xöbo dömön ma xöbo xaken, niang ibo paluso bara ibo lalaran, abo irine wit iboro xuxubu ma iboro dadas taxin. Ma lamun ine iat i kala ösöxö bara ibo dadas bule. ");
INSERT INTO bjk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A pu iat ibo öxubu a irine wit, sila ibo das kaa, io, ibo oo a kölömene, ma malamu irabo maruxo. ");
INSERT INTO bjk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nang bara iri maruxo, ina tödi ibo reree lo a pasuno, möxösa, a axana bung möxö kip nien iri ot.” ");
INSERT INTO bjk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Me Jisas ixo tengen bölök bira, “Ire tabo tengen bira a kingdom kö God i xarnang a lasa? Bara xö mangana tinenge öwuo sa nang ire tabo pet tua palas ödeek ina tinenge na? ");
INSERT INTO bjk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I xarnang a irine iaa nang a lak lik köba xöbo irine iaa xabise nang u bo susulo xö pu. ");
INSERT INTO bjk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma nang bara tere sulo, ibo das kaa ma ibo taxin köba ma ibo saxit kirip abo iaa kölöme xö komo. Ma ibo masanga raxin, io, abo pun meriso lömö tobo ot ma tobo wewet abo wöwösö re idi xö sinisii möxönan.” ");
INSERT INTO bjk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Me Jisas ixobo walwalas tinenge ma ixobo wewet abo oleleng ne mangana tinenge öwuo bira, nang irabo eöt te idi rua ölengen kulen. ");
INSERT INTO bjk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ine ixobo wöwörö xö marakörö mabo tinenge öwuo xalik mon. Ma lamun nang ine arixe mabo bak ne ausu re ine xalik mon, ine ixobo tengen osen ömaras abo tinenge öwuo re idi. ");
INSERT INTO bjk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Xö ina bung kö aien sumara xoxo, Jisas ixo tengen köbo bak ne ausu rine bara, “Ire ta wan köröp uruo xö lawa xabise möxö tu.” ");
INSERT INTO bjk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Io, Jisas mabo bak ne ausu re ine toxo wan lo xalik a marakörö ma toxo kaa xö mön nang e Jisas ixoro kisisik könan. Ma dauleng ne mön bölök toxo wan arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A xiki raxin ixo wawaxat ma dalun ixo tawit laxa xö mön ma ari ixoro lörörö ra öwöwö a mön. ");
INSERT INTO bjk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ixo paluso sik malamu xö mön ma ixo lulungon kaa sik kö lulungo re ine. Ma abo bak ne ausu toxo ölaran ine ma toxo tengen te ine, “Tene Ausu, nöngön u kobo balamu ire, xalik tabo köngö?” ");
INSERT INTO bjk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Io, ine ixo taru ma ixo köö a xiki, ma ixo tengen kö dalun, “Örö ödödö! Ma örö malile!” Io, a xiki ixo kawam ma dalun ixo malile esexere. ");
INSERT INTO bjk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Io, Jisas ixo tengen köbo bak ne ausu re ine, “Mum, mo bubuut köba ruasa? Kaim iat bang e mum ma nunu?” ");
INSERT INTO bjk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Idi toxo buut köba ma toxo ose nanin öbaling idi iat bira, “A mangana tödi sa ia? Nang a xiki ma dalun te tame ine!” ");
INSERT INTO bjk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Io, Jisas mabo bak ne ausu rine toxo wan lies uri xö lawana tu Galili, xö xönö pu mee Gerasen. ");
INSERT INTO bjk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nang e Jisas ixo kaa su xalik a mön, a tödi ma tano saban ixo wan su xalik abo lieng kö nangadi minet ta inasuo mine. ");
INSERT INTO bjk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ina tödi na ixobo xisixis kölöme xöbo lieng möxöbo tödi minet, ma kaim pe tödi i öt ta kubus pi öbaling ine arixe mere mangana uno bara sen bölök. ");
INSERT INTO bjk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ina tödi na, toxobo xuxut abo limine ma xexene, nexalik bara ixobo xörxöröp ina sen ma ixobo wörwörök abo aen kö xexene. Kaim pe öng i lölös sik ka rorop ine. ");
INSERT INTO bjk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Xöbo dömön ma xaken, kaluluon köbo lieng möxöbo minet ma kölöme xöbo maii ixobo kalasii, ma ixobo xurxuru öbaling a aine ma warawat. ");
INSERT INTO bjk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ma nang ixo pere e Jisas kö palaa, ixo ulo ma ixo subun kexe mesilain ine. ");
INSERT INTO bjk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ixo kup nöngösö lömö, “Jisas, a Barok kö God lömö saxit, u mamaa lamun a lasanene xalik e? E seng nöngön kö esene God u bele ögarin e!” ");
INSERT INTO bjk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ixo tengen bira, möxösa, Jisas ixoro tengen tö ine, “Nöngön a tano saban, wan su xalik a tödi na!” ");
INSERT INTO bjk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Io, Jisas ixo ose ine, “Ewe a esem?” Ixo balu ine bira, “A esene e ‘Arip ne Arip,’ möxö mem a oleleng.” ");
INSERT INTO bjk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ixo tenge marmaris se Jisas sa ganim a ritile rewe idi möxö ina xönö. ");
INSERT INTO bjk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Oleleng ne bung bo toxo aan nana xö gegene maii. ");
INSERT INTO bjk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Abo tano saban toxo seng e Jisas, “Örö tile e mem urungan kaluluonin a bung bo. Örö ömaraxen e mem pa nilaxa rup pidi.” ");
INSERT INTO bjk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Io, ixo ömaraxen idi, mabo tano saban toxo wan su ma toxo laxa rup kö bung bo. Ina bung bo xirip, toxo öt ma nini arip ne bo, ma toxo ewasak su xö gegene maii urungan kölöme xö ari ma toxo köngö met. ");
INSERT INTO bjk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Io, a nangadi möxö balaure a bung bo, toxo ulo lo ra atöngösen min kö lagunon taxin ma xö boxönö lörörö. Mabo nangadi toxo wanot ta werwere a lasa nang ixo ot. ");
INSERT INTO bjk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nang a nangadi toxo wanot pösöt e Jisas, idi toxo pere ina tödi nang abo tano saban toxoro tup kalik ine. Ixo laulawa sik ma ixo kisisik ma dinödöm pe ine ixoro maras. Mabo nangadi toxo buut. ");
INSERT INTO bjk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Io, a nangadi nang toxo pere ina laa, idi toxo tengen kö nangadi a lasa nang ixo ot kina tödi nang abo tano saban toxoro kis sine, ma toxo paraa bölök lamun a bung bo. ");
INSERT INTO bjk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Io, a nangadi toxo urulo ra tinenge marmaris se Jisas sa nuan pes xalik ina xönö re idi. ");
INSERT INTO bjk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Io, nang e Jisas ixo kakaa xö mön ma ixo mamaa ra nuan, a tödi nang abo tano saban toxoro tup kalik ine, ixo seng e Jisas sa nuan arixe mine. ");
INSERT INTO bjk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Me Jisas kaim kö ömaraxen lo ine, lamun ixo tengen te ine, “Örö wan baling kö lagunon te nöngön urungan kö nangadi re nöngön ma örö tengen tö idi a lasanene nang a Orong ire pet te nöngön ma a abalamu raxin te ine urungan te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Io, ina tödi ixo wan pes ma ixo urulo ra atöngösen kölöme xö xönö raxin Dekapolis, mabo lasanene nang e Jisas ixo pet te ine. Mabo nangadi toxo wuwus saban arixe. ");
INSERT INTO bjk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nang e Jisas ixo lies köröp baling kö mön uruo xö lawana tu Galili, a marakörö raxin toxo ot emorop pönö ine nang ine ixo kisisik kö gegene ari. ");
INSERT INTO bjk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Io, önga tödi a esene e Jairus, a tödi sila xö gunon ne sineseng ke idi abo Judeia, ma ixo ot bölök, ixo pere e Jisas ma ixo subun kexe xö nine xexene Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma ixo tenge marmaris se Jisas, “A balik lik ke e, i ka minet. E seng nöngön, örö miang ma örö bulus a limem lömö rine, bara ine irabo deek ma irabo to.” ");
INSERT INTO bjk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Io, Jisas ixo wan arixe mine. A marakörö raxin toxo muu ine ma toxo parap sik iat tine. ");
INSERT INTO bjk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma önga une nangen niang, nang a dee ixobo önan kalik ine, ma ixo öt xarnang a sangaun ma ninöng ne awat. ");
INSERT INTO bjk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ine ixo kip a tiip taxin kalik abo dokta ma ixo ösek abo lasa nang ine min, rö ine ra dedeek. Ma kaim. Nangen a dee ixo önan köba mon kalik ine. ");
INSERT INTO bjk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nang ine ixo ölangen a tinenge ure Jisas, ine ixo wan melamu rine kaluluonin a marakörö ma ixo sigi a man te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ixo pet ina na, möxösa, ine ixo döxömen, “Nang bara e sigi a man te ine mon, e rabo deek.” ");
INSERT INTO bjk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Saxit mon a dee ixo masa xalik ine ma ixo örasen kö aine bara iri deek kalik ina tiip pe ine. ");
INSERT INTO bjk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Io, saxit mon, Jisas ixo örasen bara ina lölös ixoro wan su xalik ine ma ixo tawuxus kaluluon kö marakörö ma ixo eose, “Ewe i sigi a man te e?” ");
INSERT INTO bjk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abo bak ne ausu rine toxo balu ine, “Örö pere a nangadi nang te emorop pönö nöngön, ma u ose bölök bule, ewe i sigi nöngön?” ");
INSERT INTO bjk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Me Jisas ixo wawara nana iat tua werwere bere ewe iat ixo pet ina na. ");
INSERT INTO bjk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Io, a une ixo wanot ma ixo subun kexe xö nine xexene Jisas, möxösa, ixo ösöxö arixin a lasa ixo ot tine. Ixo buut ma ixo dedede ma ixo tengen ösu xirip a turunon. ");
INSERT INTO bjk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas ixo tengen tö ine, “Balik, a nunu re nöngön iri öro nöngön. Örö wan ma malum ma örö langlanga xalik ina miniset te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nang e Jisas nangen bang ixo wöwörö xö une, a dauleng ne duöng möxö gunon te Jairus, a tödi raxin möxö gunon ne sineseng, idi toxo tengen te Jairus, “A balik ke nöngön iri met. Nöngön u bele isik a tiip kö tene ausu.” ");
INSERT INTO bjk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas kaim a mumuu a lasa idi toxo rengrengen, ma ixo tengen te Jairus bira, “U bele buut. Örö mana nunu mon.” ");
INSERT INTO bjk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas kaim kö ömaraxen tebo duöng bölök kua mumuu ine, nexalik mon e Pita, Jems, me Jon a tönö re Jems. ");
INSERT INTO bjk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nang idi toxo ot kö gunon te Jairus, Jisas ixo pere arixin a marakörö toxo ees köba ma toxo gegee nöngösö lömö. ");
INSERT INTO bjk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ixo wan laxa ma ixo tengen tö idi, “Mum bele ees ma ginee. A balik i kobo met. Inexalik i paliso mon.” ");
INSERT INTO bjk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Me idi toxo isis belek ine. Ma nang ixoro tile ösu a nangadi xirip, ixo lamus lo a tata ma nago xö balik arixe mabo bak ne ausu nang toxo wan arixe mine, ma toxo wan laxa urungan kö xönö nang a balik ee. ");
INSERT INTO bjk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Io, Jisas ixo tön a limine ma ixo tengen te ine, “Talita kum!” (A unine bara, “Balik lik, e tengen te nöngön, taru kaa!”). ");
INSERT INTO bjk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Saxit mon, a balik ixo tuu kaa ma ixo önan nana. (Ine ma sangaun ma ninöng ne awat). Ma nang idi toxo pere ina na, toxo wuwus saban köba arixe. ");
INSERT INTO bjk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ine ixo isik a tinenge lölös bere idi tebele tengen osen ina na xere öng, ma ixo tengen te idu ra tabaa ine mere laa ra enen. ");
INSERT INTO bjk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas ixo wan kalik ina xönö nang ma ixo wan urungan kö lagunon tine. Ma abo bak ne ausu rine toxo arixe mine. ");
INSERT INTO bjk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nang a bung Sabat ixo ot, Jisas ixo urulo a ausu xö gunon ne sineseng. Ma oleleng idi nang toxo ölengen ine toxo wuwus saban. Idi toxo ose bira, “Ina tödi na i kip lo inabo mangana lalaa na mole? A lasa ina nanase na nang toxoro tabaa ine min, nang ine ibo wewet abo lalaa lölös ne auwuwus! ");
INSERT INTO bjk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ine mon a tene pet gunon, nang a barok ke Maria ma abo tönö rine e Jems, Jon, Judas me Saimon. Mabo saxana nangen na me ire.” Me idi toxo mölök kalik ine. ");
INSERT INTO bjk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisas ixo tengen tö idi, “Xöbo lagunon kabise a nangadi tobo ii öraxin a propet. Inexalik kö lagunon iat tine ma kaluluon kö bung marapun ma nang bölök kö gunon tine, tekarabo ii ine.” ");
INSERT INTO bjk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Io, Jisas i koxobo eöt ta wewet te laa lölös ne auwuwus singan. Inexalik ixo bulus a nine limine lömö xö dauleng ne miniset ma ixo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Me Jisas ixo wuwus saban, möxösa, kaim idi xo nunu. Io, Jisas ixo wan nana xöbo lagunon ma ixo usu nanin a nangadi. ");
INSERT INTO bjk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ixo kuwe etok lo a sangaun ma ninöng ne bak ne ausu rine ma ixo tile rewe idi ninöng ninöng ma ixo tabaa idi ma lölös sua tile ösu abo tano saban. ");
INSERT INTO bjk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ixo tengen ömaras idi bira, “Mum korobo kip pe laa xö nuan te mum, ma lamun morobo tön kalik a buxo. Mum korobo kip pe nien, a rat, ma re tuluwok kölöme xö kie. ");
INSERT INTO bjk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mum morobo sige abo sandel, ma lamun mum korobo kip bölök ke önga man kabise.” ");
INSERT INTO bjk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jisas ixo tengen bölök kidi bira, “Nang bara mum morobo laxa xö önga gunon, morobo xisixis iat tingan ot nang mum morobo wan lo baling kalik a lagunon niang. ");
INSERT INTO bjk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma nang bara önga lagunon i kobo öga e mum, bara i kobo tame e mum, io, nang bara mum ka nuan, mum morobo se rewe a kabus kalik abo xexe mum rua uxileng kö idi lamun a magingin saban te idi nang toxo pet te mum.” ");
INSERT INTO bjk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Io, abo bak ne ausu toxo wan ebasin ma toxo tenge lölös bara a nangadi tabo mana dödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Idi toxo irewe a oleleng ne tano saban ma toxo salap a wel kö oleleng ne nangadi miniset ma toxo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Io, king Erot ixo ölangen bira lamun abo lalaa nang idi toxo pet, möxösa, a esene e Jisas ixo taxin köba xö ölöngö rine. Dauleng toxo rengrengen bere Jisas ine ma lölös taxin tua wewet abo lalaa ne winiwus lölös, möxösa, idi toxo döxömen bere Jisas ine iat e Jon a tene baptais nang ixoro taru baling kalik a minet. ");
INSERT INTO bjk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Inexalik a dauleng toxo tengen bere ine e Elaija. Ma dauleng iat toxo tengen bere ine a propet möxöbo propet mee mesila saxit. ");
INSERT INTO bjk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nang e Erot ixo ölangen bira, ixo tengen, “E Jon, a tödi nang e xo tee xöröp a inöno, iri taru baling kalik a minet!” ");
INSERT INTO bjk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erot ixoro tengen bira, möxösa, ine iat ixo isik a tinenge rua öxös lo e Jon tua bulbulus ine xö gunon ne aömokorot. Erot ixo pet bira, möxösa, e Erodias a une re tönö ine, niang e Pilip, ma lamun Erot ixo elolo belek e Erodias. ");
INSERT INTO bjk_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jon ixobo rengrengen te Erot, “I kobo töxödös bara örobo elolo a une xö tönö nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Io, Erodias ixo bala saban te Jon ma ixo mamaa ra sesexomet ine. Ma lamun ine i kobo eöt ");
INSERT INTO bjk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","möxösa, e Erot ixo buburin e Jon ma ixo balaure ödeek ine xalik ibo met, möxösa, ine ixo ösöxö bara a tene töxödös ma a tödi madakdak ine. Nang e Erot ixo ölangen e Jon, ixo dödöm oleleng köbo winörö rine, ma lamun ixobo mamaa ra ölangen a tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Önga axana bung deek ixo ot tue Erodias bara irabo pet eörin im a dinödöm pe ine. Erot ixo pet a nien taxin ta uxileng a bung nang toxo kip ine xönan. Io, ixo pet ina nien ulamun a duöng taxin nang tobo rorop ine xö tinörön ne gapman mabo umri mabo duöng sisila mee Galili. ");
INSERT INTO bjk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Io, nang a balik ke Erodias ixo laxa ma ixo tie, ine ixo öaxanan e Erot mabo osee rine. Io, king Erot ixo tengen kö balik, “Nang bara u mamaa lamun a mangana lasanene, örö tengen, me e rabo tabaa nöngön min.” ");
INSERT INTO bjk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Me ine ixo usugurno ine bira, “Turunon saxit, a mangana lasanene nang u ose lamun, e rabo tabaa nöngön min, ma nang bara u ose e xö subana kingdom pe e, io, e rabo tabaa iat nöngön min.” ");
INSERT INTO bjk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Io, a balik ixo wan su ma ixo ose a nago re ine, “A lasa nang e rabo ose lamun?” E nene ixo balu ma ixo tengen, “Örobo ose ulamun a öxöno e Jon a tene baptais.” ");
INSERT INTO bjk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma saxit mon, a balik ixo baling urungan kö king ma ixo tengen, “Na iat, e maa bara örö tabaa e ma öxöno e Jon a tene baptais kö bile.” ");
INSERT INTO bjk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me Erot ixo tapunuk köba, ma kawaim ine ra öngasin a sineseng kine möxö ixoro tenge ösugurno sila xö ölöngö xöbo osee. ");
INSERT INTO bjk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma saxit mon, e Erot ixo tile önga umri rua xikip lo a öxöno e Jon ura. Io, ina umri ixo wan laxa xö gunon ne aömokorot ma ixo tee xöröp lo a öxöno e Jon, ");
INSERT INTO bjk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ixo kip ot öbaling a öxöno Jon kö bile. Io, a umri ixo isik kö balik, ma balik ixo tabaa e nene min. ");
INSERT INTO bjk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma abo bak ne ausu re Jon idi toxo ölangen bira, io, idi toxo wanot ma toxo kip lo a lewene aine e Jon ma toxo bulus kö maöt. ");
INSERT INTO bjk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Abo aposol toxo kis etok arixe me Jisas ma toxo töngösen ine mabo lalaa nang idi toxoro pet ma toxoro eusu min. ");
INSERT INTO bjk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Möxö kaim a eöt a axana bung kö idi ra nien, möxösa, a oleleng ne nangadi toxo önan eli, io, Jisas ixo tengen köbo bak ne ausu rine, “Moro miang, ire xalik ta wan urungan kö xönö madödö me ire ta mamas.” ");
INSERT INTO bjk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Io, idi iat kalik toxo wan lo xö mön urungan kö xönö tataun. ");
INSERT INTO bjk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma oleleng ne nangadi nang toxo perexulen e Jisas mabo bak ne ausu rine nang toxo önan, toxo ulo möxöbo lagunon taxin kirip ma toxo ot sila ridi. ");
INSERT INTO bjk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma nang e Jisas ixo ösö, ixo pere a marakörö raxin, ma ixo marase idi, möxösa, idi toxo xarnang a bung sipsip te tup ma kaim idi ma tene walbalaurai. Io, ixo urulo ra usu idi mabo mangana lalaa. ");
INSERT INTO bjk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A xaken ixoro su mabo bak ne ausu toxo ot pösöt ine ma toxo tengen te ine, “Ina xönö na a xönö tataun ma iri aien sumara xoxo. ");
INSERT INTO bjk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Örö tile rewe a nangadi na. Me idi ta wan urungan köbo lagunon örörö, ma tabo kun nien tö idi ra enen.” ");
INSERT INTO bjk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Me Jisas ixo tengen tö idi, “Mum iat, mum moro tabaa idi merebo lalaa rua enen.” Mabo bak ne ausu rine toxo balu öbaling ine bira, “U maa bara mem mara wan, mara ösek tewe sik a nini mar ne tuluwok na ra kun a beret tua ratabaa idi min tua enen?” ");
INSERT INTO bjk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Io, Jisas ixo ose idi, “Ma ausen ne xönö beret niang e mum min? Mum moro wan me mum morobo pere.” Nang idi toxo ösöxö lo, idi toxo tengen bara, “Pitnö ne beret ma nini en.” ");
INSERT INTO bjk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Io, Jisas ixo tengen köbo bak ne ausu rine bara, “Mum moro erimine idi xö kinis arixe xö maduduan ne pasle.” ");
INSERT INTO bjk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Io, idi toxo kis erimine idi, uleng a mar ma uleng a pitnö ne sangaun. ");
INSERT INTO bjk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Io, e Jisas ixo tön lo ina pitnö ne beret ma nini en ma ixo wawara kaa xö balana kubu, ma ixo tengen deek ke God ma ixo pidik a beret. Ma ixo tabaa abo bak ne ausu re ine min, me idi toxo erimine nanin kö nangadi. Ma ixo erimine bölök idi ma nini en kaluluonin idi. ");
INSERT INTO bjk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Me idi xirip toxo an ma toxo masii. ");
INSERT INTO bjk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Io, abo bak ne ausu toxo tuxo a sangaun ma ninöng ne kölöt ma subana inan ma beret nang idi toxo en paling. ");
INSERT INTO bjk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mabo duöng nang toxo an, ixo eöt ma pitnö ne arip. ");
INSERT INTO bjk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma saxit mon, Jisas ixo tile öxaa abo bak ne ausu rine xö mön, bara idi tabo sila rine uruo Betsaida, me ine bang, irabo tile elixilik a marakörö. ");
INSERT INTO bjk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Melamu ixo wan lo xalik a marakörö ma ixo wan kaa wes kalik idi uruso xö maii rua sineseng. ");
INSERT INTO bjk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma nang ixoro aien, idi toxo uluso kaluluon kö tu raxin, me ine xalik mon ixo xisixis kö maii. ");
INSERT INTO bjk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jisas ixo pere abo bak ne ausu rine toxo uuluso esuo ma xiki. Xö lörörö xö pitnö ne axana bung kö puxu bubung, e Jisas ixo önan lömö xö rasi urungan tidi. Ine ixo maa ra nuan saxit idi, ");
INSERT INTO bjk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ma lamun nang idi toxo pere ine ixo önan lömö xö rasi, idi toxo nunuxas bara e Jisas a tano. Io, idi toxo kup wösö ");
INSERT INTO bjk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","möxösa, idi xirip toxo pere ine me idi toxo buut saban arixe. Saxit iat mon, e Jisas ixo tengen tö idi, “Mum moro balamasa. E mon. Ganim a binuut.” ");
INSERT INTO bjk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Io, ixo kaa xö mön arixe midi ma a xiki ixo kawam. Me idi toxo wuwus kirip arixe, ");
INSERT INTO bjk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","möxö kaim idi xo marmaras ulamun a unine arabaa möxö beret nang e Jisas ixo tabaa a pitnö ne arip ne marakörö min, möxö abo baladi ixo lölös. ");
INSERT INTO bjk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ma nang idi toxo köröp kö tu ma toxo ösö Genesaret, me idi toxo kut oxe a mön. ");
INSERT INTO bjk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Idi toxo kaa su xalik a mön, ma saxit mon a nangadi toxo perexulen e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Me idi toxo ulo elixilik köbo lagunon, me idi toxo kip ot abo miniset lömö xöbo ben urungan kö boxönö nang toxo ölangen bere ine nangen ne. ");
INSERT INTO bjk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma nang kö boxönö xirip ma xöbo lagunon kirip nang e Jisas ixobo önan könan, a nangadi toxobo bulbulus abo miniset kölöme xö boxönö möxö misik. Me idi toxobo seng ine bara irabo ömaraxen idi rua rörön a ngusuno man te ine mon, me ewe idi nang toxo tön, toxobo langlanga. ");
INSERT INTO bjk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Abo Parasi ma dauleng ne tene ausu möxöbo warkurai te Moses, nang toxo wanot meriso Jerusalem, toxo kis etok arixe me Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Me idi toxo pere a dauleng möxöbo bak ne ausu rine toxo enen a nien. Ma toxo döxömen bara e God i pere sik a sasaban köbo limine idi abo bak ne ausu, möxösa, idi kaim kö gisgis abo limine idi xarnang toxo döxömen bara abo warkurai te Moses i tengen bie. ");
INSERT INTO bjk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Abo Parasi mabo Judeia xirip te mumuu abo ausu nang toxo kip kalik abo tubudi. Ina ausu bira nang bara idi tokobo muu ödeek a warkurai möxö gis lime xö axana bung möxö gilime, io, idi tokobo eöt ta nien. ");
INSERT INTO bjk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Io, nang bere idi tobo wan baling meri xö misik, idi tabo gis abo limedi. Io, melamu, idi tabo an. Me idi tobo mumuu a oleleng ne warkurai nang abo tubudi toxo tengen te idi bie. Idi tabo gis ödeek abo kap, abo sosopen mabo dis.) ");
INSERT INTO bjk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Io, abo Parasi mabo tene ausu möxöbo warkurai te Moses toxo ose Jisas, “Ruasa abo bak ne ausu re nöngön tokobo muu eörin a ausu möxöbo tubuno ire? Ruasa bölök idi te enen a nien mabo limine idi nang a lak saban?” ");
INSERT INTO bjk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Me ine ixo balu idi, “E Aisaia i tengen a turunon lamun e mum. Mum bo röxröxö mon bara mum a lak deek, xarnang ixo geet abo tinenge re God bira, ‘Inabo nangadi na, tobo ii öxaa e mabo ngaladi, ma lamun abo kat tidi i kis kö palaa xalik e. ");
INSERT INTO bjk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Idi tobo lolotu tataun te e, möxösa, abo ausu ridi i ot mon möxö nangadi.’ ");
INSERT INTO bjk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mum moxoro ömalim tewe abo warkurai te God. Me mum mo tön sik bölök abo ausu möxö nangadi mon.” ");
INSERT INTO bjk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Me Jisas ixo tengen öbaling ke idi, “Mum ma nanase deek kua bulbulus tewe abo warkurai te God, muu a inausu xöbo tubu mum iat. ");
INSERT INTO bjk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na e tenge ma lasa nang e Moses ixo tengen: ‘Nöngön örobo ii a tata ma nago re nöngön,’ me, ‘Ewenene nang i tenge saban kö tamana bere nene, mum morobo sexomet ine.’ ");
INSERT INTO bjk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma lamun mum bölök bo rengrengen bira: Ewe nang ma önga laa rua rorop e tamana bere nene, io, i öt bölök bara ine irabo tengen, ‘E xoro tagur sik kua tabaa e God min. E kebeöt ta tabaa nöngön min tua rorop nöngön.’ Ma nang bara mum mo döxömen bira, ");
INSERT INTO bjk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","io, mum bele ömaraxen ine ra wewet tebo lalaa lamun e tata me nago rine. ");
INSERT INTO bjk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Möxö ina na, mum bo döxömen taun a tinenge re God, möxösa, mum bo isik abo ausu nang mum bo kip kalik abo untubu mum. Me mum bo wewet a oleleng ne mangana lalaa xarnang.” ");
INSERT INTO bjk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Io, Jisas ixo kuwe öbaling a marakörö urungan tine ma ixo tengen, “Mum kirip moro ölangen e, ma moro maras könan. ");
INSERT INTO bjk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","A laa nang i kis kö araman ma i wan laxa xö tödi i kebeöt ta ösaban ine. Inexalik bara a lasa nang i kis kölöme xö tödi ma i wan su xö araman, ibo ösaban a tödi.” ");
INSERT INTO bjk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Melamu nang ine ixo wan lie a marakörö ma ixo wan laxa xö gunon, abo bak ne ausu rine toxo ose ine lamun ina tinenge öwuo. ");
INSERT INTO bjk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisas ixo tengen tö idi, “Mum kobo maras, aa? Mum kobo maras kö lasa nang ibo önan laxa xö tödi, i kebeöt ta ösaban ine? ");
INSERT INTO bjk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","I kebeöt, möxösa, i kara laxa urungan kö kat, nexalik ibo laxa xö balna, io, ibo wan su baling kalik a aine.” (Io, nang e Jisas ixo tengen bira, ixo tengen osen bara abo nien kirip i deek kua enen.) ");
INSERT INTO bjk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me ine ixo tengen öbaling, “A lasa nang i wan su möxö könönö tödi, i ösaban ine. ");
INSERT INTO bjk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ma meringan kölöme xö könönö tödi ibo wan su abo dinödöm saban, a tatalien ne ilawa, a tatalien pinilo, a tatalien möxö inarsexomet, a tatalien ne ilawa ma önga tödi alolo, ");
INSERT INTO bjk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a gumut, abo mangana sasaban, atöxö, a tatalien ne xekeme, a tatalien ne aneek, tuxo tinenge ra ögarin önga tödi, a ii öxaa a esem, ma tatalien ne kinis ne baulang. ");
INSERT INTO bjk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Inabo lalaa saban na ibo wan su möxö kölöme ma ibo wewet ösaban a tödi.” ");
INSERT INTO bjk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas ixo wan lo meringan kina xönö ma ixo wan urungan kö xönö mee Tair. Ixo wan laxa xö gunon ma i ixo mun. Ma kaim kö mamaa bara re öng irabo ösöxö bara ine nangen nang. Lamun ine i koxobeöt ta minun. ");
INSERT INTO bjk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Io, önga une, nang a tano saban ixo kis kö balik lik kine, ixo ölangen bere Jisas angen. Ine ixo wanot pösöt e Jisas ma ixo subun kexe mesilain e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ina une na, ine a Grik (kawaim bara ine a Judeia). Toxo kip ine ri Ponisia i kis kö xönö raxin Siria. Ixo tenge maris urungan te Jisas sua irewe a tano saban kalik balik lik kine. ");
INSERT INTO bjk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Me Jisas ixo tengen te ine, “Ire tabo arun ta tabaa a bung barok ma nien tö idi ra minasi, möxö i kobo töxödös bara ire tabo kip lo a nien kö bung barok ma tabo tewe rabaa a bung puluwun min.” ");
INSERT INTO bjk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Me ina une ixo balu ine ma ixo tengen, “A turunon saxit, Orong, ma lamun abo wuluwun kö ene öra, idi tobo enen abo perene nien kö bung barok lixilik.” ");
INSERT INTO bjk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Io, Jisas ixo tengen tö ine, “Möxösa u balu ödeek e, örö wan, a tano saban iri wan tewe xalik a balik lik ke nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Io, ina une ixo baling urungan kö gunon tine ma ixo pere a balik lik ke ine ixo maru sik kö öra, ma tano saban ixoro wan kalik ine. ");
INSERT INTO bjk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Io, Jisas ixo wan lie ina xönö Tair ma ixo wan köröp kö lagunon taxin Saidon ma ixo wan su urungan kö tu Galili ma kölöme xö xönö Dekapolis. ");
INSERT INTO bjk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Io, a dauleng ne nangadi toxo kip ot a önga tödi urungan tine. A talinge baa ma ngala bot ine. Me idi toxo seng e Jisas sua bulbulus a limine xö tödi. ");
INSERT INTO bjk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Io, Jisas ixo lamus lo ine xalik a marakörö, ma ixo bulus a nine kasine limine xö nine talingine ina tödi, ma melamu ixo gisip a limine, io, ixo sigi a kamene. ");
INSERT INTO bjk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jisas ixo wawara kaa uruso lömö xö balana kubu ma bala maris ma ixo tengen tö ine, “Epapata!” (A unine bira, “Örö tamasawang!”). ");
INSERT INTO bjk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Saxit mon, ma nine talingine ina tödi ixo tamasawang, ma kamene ixo wawaxan ma ixo urulo rua tinenge. ");
INSERT INTO bjk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Io, Jisas ixo isik a tinenge lölös bere idi tebele tengen kere öng. Ma lamun abo lalaa oleleng nang ine ixo wewet, nangen bölök idi toxo etöngösen nana min. ");
INSERT INTO bjk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Idi toxo wuwus saban, me idi toxo tengen, “Ine ibo wewet ödeek abo lalaa xirip. Me ine ibo wewet abo talinge baa rua ölöngö ma ngala bot tua tinenge.” ");
INSERT INTO bjk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Xinabo bung niang a marakörö xabise toxo ot etok. Ma nang kaim idi ma nien tua enen, me Jisas ixo kuwe abo bak ne ausu re ine urungan te ine ma ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“E marase a nangadi na idi te kis arixe me e xö narun ne bung tar ma kaim idi ma nien. ");
INSERT INTO bjk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nang bara e rabo tile idi xöbo lagunon te idi ma irilöng, idi tabo met saxit kö ngas, möxösa, a dauleng ke idi toxo wanot möxö ngas ömat.” ");
INSERT INTO bjk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mabo bak ne ausu rine toxo tengen te ine, “Ma ule re xönö tataun ta nang ke tödi i öt ta xikip eörin tebo beret tua tabaa idi?” ");
INSERT INTO bjk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas ixo ose, “A nausen ne xönö beret nangen me mum?” Me idi toxo balu ine bira, “Pitnö ma ninöng.” ");
INSERT INTO bjk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Io, ine ixo tengen kö marakörö ra kinis kö pu. Ma nang ixo kip lo a pitnö ma ninöng ne beret ma ixo tengen deek kö God ulamun. Ixo pidik ma ixo isik köbo bak ne ausu ra erimine nanin kö nangadi mabo bak ne ausu toxo pet eörin. ");
INSERT INTO bjk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Me idi angen bölök ma dauleng ne inan lixilik, ma nang ixo tengen deek ke God, ixo tengen köbo bak ne ausu rua erimine nanin te idi. ");
INSERT INTO bjk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Abo marakörö toxo an ma toxo masii. Melamu im abo bak ne ausu toxo kip lo a pitnö ma ninöng ne kölöt subana nien nang ixo kis. ");
INSERT INTO bjk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A marakörö nang toxo kis ixo eöt ma nit ne arip. Ma ixo tile rewe idi xöbo lagunon te idi, ");
INSERT INTO bjk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","me ine xö kakaa xö mön arixe mabo bak ne ausu re ine ma toxo wan urungan kö xönö möxö Dalmanuta. ");
INSERT INTO bjk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Abo Parasi toxo wanot pösöt e Jisas ma toxo urulo ra agot arixe me ine. Idi toxo ose bara irabo pet te önga mangana auxileng lölös sua osen bara abo tinörön te ine meriso re God, möxö toxo mamaa ra könönöin ine. ");
INSERT INTO bjk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisas ixo örasen a tiip kö to re ine ma ixo tengen, “Ruasa inabo marakörö mee nixinen te ose lamun a uxileng lölös? E tengen a turunon te mum, kaim pe uxileng merso lömö irabo ot te mum.” ");
INSERT INTO bjk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Io, ixo wan lie idi, ma ixo kakaa laxa xö mön ma ixo uluso lies urungan kö lawa xabise. ");
INSERT INTO bjk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abo bak ne ausu toxo döxömen taun ta kip beret, nexalik önga beret nangen kö mön arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas ixo tenge lölös se idi, “Tumarang e mum, lamun a is köbo Parasi ma nang bölök ke Erot.” ");
INSERT INTO bjk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Idi toxo rengrenge nana min kaluluonin idi ma toxo tengen, “Ine i tengen bira, möxösa, kaim ire ma beret.” ");
INSERT INTO bjk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas ixoro ösöxö ina tinenge ridi, ma ixo ose idi, “Ruasa mum mo wöwörö oleleng kö kinis se mum bara kaim pebo beret? Mum kala pere ömaras bang? Abo bala mum a lak lölös? ");
INSERT INTO bjk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mum ma mara mum, ma lamun mum mo köbo pere. Me mum ma talinge mum, ma lamun mum kobo ölöngö? Me mum kobo dödöxömen lo? ");
INSERT INTO bjk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nang e xo pidik ina pitnö ne xönö beret lamun a pitnö ne arip, a nausen ne kölöt wöwö ne subana nien nang mum moxo tuxo?” Idi toxo tengen, “Sangaun ma ninöng ne kölöt”. ");
INSERT INTO bjk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma nang e xo pidik a pitnö ma ninöng ne beret lamun a nit ne arip, a nausen ne kölöt wöwö ma subana nien nang mum moxo kip lo?” Idi toxo tengen, “Pitnö ma ninöng.” ");
INSERT INTO bjk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Io, Jisas ixo tengen te idi, “Mum kala maras iat bang?” ");
INSERT INTO bjk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Idi toxo wanot to Betsaida, ma dauleng ne nangadi toxo lamus ot a tödi marapulo ma ixo seng e Jisas sua sisigi ine. ");
INSERT INTO bjk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas ixo tön lo ina marapulo xö limine ma ixo lamus ösu ine xalik a lagunon. Nang ine ixo ibis a nine marana tödi ma ixo bulus a nine limine lömö rine, ma ixo ose, “U pere bölök ke laa?” ");
INSERT INTO bjk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ina tödi ixo tadang kaa ma ixo tengen, “E pere a nangadi. Idi te wawara xarnang abo uno iaa te önan nana.” ");
INSERT INTO bjk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Io, Jisas ixo bulus öbaling a nine limine lömö xöbo marana ina tödi. Ma a nine marana ixo tamasawang, ma nine marana ixo deek ma ixo pere ödeek kirip abo lalaa. ");
INSERT INTO bjk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas ixo tile rewe ine urungan kö gunon te ine ma ixo tengen, “U bele wan laxa xö lagunon Betsaida.” ");
INSERT INTO bjk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas mabo bak ne ausu re ine toxo wan urungan köbo lagunon kö araman Kaisaria Pilipai. Xö nuan te idi xö ngas, Jisas ixo ose, “A nangadi tobo rengrengen e me we?” ");
INSERT INTO bjk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Io, idi toxo balu ine, “Dauleng te tengen bere nöngön e Jon a tene baptais, dauleng te tengen bere nöngön e Elaija, ma lamun dauleng te tengen bara nöngön a öng möxöbo propet.” ");
INSERT INTO bjk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Me ine ixo ose, “Me mum, mum bo rengrengen e me we?” Io, Pita ixo balu ine ma ixo tengen, “Nöngön a Mesaia.” ");
INSERT INTO bjk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Me Jisas ixo panak idi bere idi tebele tengen osen kere öng bere ine ewe. ");
INSERT INTO bjk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Io, Jisas ixo urulo ra usu idi bira, “A Barok kö Tödi irabo kip lo a tiip möxö oleleng ne lalaa. Abo sisila, mabo pris tataxin mabo tene ausu möxöbo warkurai te Moses idi tabo öbulubun ine. Ma a nangadi tabo sexomet ine ma melamu xö narun ne bung irabo taru baling.” ");
INSERT INTO bjk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Me ine ixo tengen ömaras idi lamun a minet te ine. Io, Pita ixo lamus pes lo ine xalik idi ma ixo urulo ra xöxöö ine lamun a tinenge nang ixo tengen. ");
INSERT INTO bjk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma lamun, nang e Jisas ixo talingen ma ixo pere abo bak ne ausu re ine, ixo köö e Pita. Ma ixo tengen bira, “Satan, wan pes kalik e! Pita, a dinödöm pe nöngön i kobo muu sik abo dinödöm pe God, lamun nöngön u mumuu a dinödöm kö nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Io, Jisas ixo kuwe a marakörö ura re ine arixe mabo bak ne ausu re ine ma ixo tengen: “Nang bara re tödi i mamaa ra mumuu e, ine irabo mana döxömen taun ine iat ma irabo sölök a sölöxöröp pe ine ma irabo muu e. ");
INSERT INTO bjk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Möxö ewe nang i mamaa rua töndik sik iat a to re ine, irabo ömalim tewe, ma lamun ewe niang i ömalim tewe a to re ine rua gene e ma rua gene a tinenge deek, irabo töndik sik. ");
INSERT INTO bjk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nang bara tödi i kip lo xirip abo lalaa möxö öxöno lagunon, ma i ömalim tewe a to runon te ine, io, a lasa i deek möxö inabo lalaa irabo top ine? Kawaim. ");
INSERT INTO bjk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ma a tödi irabo isik a xunuxun sa rua xukun puxus lo a to re ine? ");
INSERT INTO bjk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A marakörö mee nixinen tobo tuu tawuxus xalik e God me idi tobo wewet abo magingin saban. Nang bara öng mere mum i mengmenge re e mabo tinenge re e, io, a Barok kö Tödi irabo mengein ine nang ine irabo wanot kö mariris kö Tata re ine arixe mabo angelo madakdak.” ");
INSERT INTO bjk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Me Jisas ixo tengen öbaling ke idi, “Turunon saxit, dauleng nang te tuu sik na takarabo met ot nang idi tabo pere a kingdom kö God irabo ot ma lölös.” ");
INSERT INTO bjk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Melamu xö pitnö ma öng ne bung ixo saxit, Jisas ixo lamus lo e Pita, Jems me Jon arixe mine urso lömö xö maii raxin, nang idi xalik mon. Me Jisas ixo xuxulas kö mamaran tidi. ");
INSERT INTO bjk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Abo man te ine ixo wipidien ma ixo pidien köba saxit nang kaim pe öng kö öxöno lagunon i eöt ta gisgis öpidien ina man. ");
INSERT INTO bjk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Me Elaija me Moses toxo wösö ridi ma toxo wöwörö me Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Io, Pita ixo tengen te Jisas, “Tene Ausu, i deek bara met mara xisixis sa. Met mara uru re narun ne walpali, öng ke nöngön, öng ke Moses ma öng ke Elaija.” ");
INSERT INTO bjk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Ine i kobo ösöxö re laa ra rengrengen, idiet toxo buut saban arixe.) ");
INSERT INTO bjk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Io, a kubu ixo wösö ot ma ixo tawi idi, ma inöno öng ixo ot möxö kubu, ixo tengen, “Ine ano Barok ke e. E mamaa lamun ine. Muot morobo ölangen ine!” ");
INSERT INTO bjk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Saxit mon, idiet toxo wawara eli nana, ma kaim idiet ta werwere re öng, e Jisas xalik mon. ");
INSERT INTO bjk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma nang idi toxo önan su baling kalik a öxöno maii, Jisas ixo isik a tinenge lölös bara idiet tebele tengen osen kere öng a lasa nang idiet te pere ot nang a Barok kö Tödi irabo taru baling kalik a minet. ");
INSERT INTO bjk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Me idiet toxo pidik ma tinenge re idiet iat, ma toxo wöwörö min iat te idiet bara a lasa a unine möxö tinenge nang, “Taru baling kalik a minet!” ");
INSERT INTO bjk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Me idiet toxo ose ine, “Ruasa abo tene ausu möxöbo warkurai te Moses tobo rengrengen bere Elaija irabo wanot sila?” ");
INSERT INTO bjk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas ixo balu, “I turunon bara Elaija irabo wanot sila, ma irabo bulus ödeek öbaling abo lalaa. Ma ruasa nang tere geet bara a Barok kö Tödi irabo kip a kinadik ma tabo kasen tewe ine? ");
INSERT INTO bjk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","E tengen te muot, Elaija iri ot, me idi toxoro pet eörin abo lalaa urungan tine nang idi toxo mamaa lamun, xarnang toxo geet lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma nang idi toxo ot pösöt abo bak ne ausu xabise, idi toxo pere a marakörö toxo elulurwe idi, mabo tene ausu möxöbo warkurai te Moses toxo egot arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma nang a nangadi xirip toxo pere e Jisas, idi toxo wuwus saban me idi toxo ulo urungan te ine rua öga lo ine. ");
INSERT INTO bjk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas ixo ose abo bak ne ausu re ine, “A lasa mum mo egot me idi lamun?” ");
INSERT INTO bjk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Önga tödi kaluluonin a marakörö ixo balu ine, “Tene Ausu, e lamus ot a barok ke e ura re nöngön, möxö a tano saban i tup pe ine me ine kebeöt ta tinenge. ");
INSERT INTO bjk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nang bara tano i tup pe ine, ibo tewe ine urungan kö pu ma bise ibo wöwö xö ngalana ma ibo engiren abo ngisine ma aine ibo södön kirip. E xo seng abo bak ne ausu re nöngön tua irewe ina tano, nexalik kaim idi ra eöt.” ");
INSERT INTO bjk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas ixo balu, “Mum a marakörö mee nixinen nang mum kobo nunu, e kebeöt ta kinis arixe me mum kö axana bung ömat. Ma nausen ne bung e rabo kip abo tiip pe mum? Kip ot a barok ura re e.” ");
INSERT INTO bjk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Io, idi toxo kip ot ina barok. Ma saxit mon nang a tano ixo pere e Jisas, ixo ögögöng a barok. Ine xö subu su xö pu, ma ixo dedede nana ma bise pidien ixoro wöwö xö ngalana. ");
INSERT INTO bjk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas ixo ose a tamana barok, “Ma lause ine ixo to bira?” Ma tamana ixo tengen, “Möxö bak lik iat. ");
INSERT INTO bjk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oleleng ne bung a tano saban ibo retewe ine urungan kö ia sösöt, bara xö ari ra sesexomet ine. Lamun nang bara u öt ta wewet te laa, örö marase e mem ma örö top e mem.” ");
INSERT INTO bjk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisas ixo tengen, “Ruasa u tenge, ‘Nang bara u öt?’ Abo lalaa xirip i öt sik ke ewe nang i nunu.” ");
INSERT INTO bjk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Saxit mon a tamana barok ixo kup wösö ma ixo tengen, “E nunu. Lamun a nunu re e i lik. Örö top e bara a nunu re e irabo taxin!” ");
INSERT INTO bjk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Io, nang e Jisas ixo pere bara marakörö toxo ululo ot pösöt ine, ixo tenge köö ina tano saban bira, “Nöngön a talinge baa ma ngalaböt, e tengen te nöngön, örö wan su xalik ine ma u bele laxa baling kine.” ");
INSERT INTO bjk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ina tano ixo kup saban ma ixo ögögöng ina barok ma ixo wan su. A oleleng toxo tengen bara, “Iri met,”, möxösa, a barok ixo wawara sik xarnang a tödi minet. ");
INSERT INTO bjk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma lamun Jisas ixo tön ine xö limine ma ixo rarik öxaa ine ma ixo tuu lömö. ");
INSERT INTO bjk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Melamu nang e Jisas ixo wan laxa xö gunon, mabo bak ne ausu rine toxo ose suxume ine, “Ruasa me mem kobo eöt ta irewe ina tano saban?” ");
INSERT INTO bjk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisas ixo balu idi, “A sineseng kalik mon i öt ta irewe inabo mangana tano bira.” ");
INSERT INTO bjk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Io, idi toxo wan lie ina xönö ma toxo wan köröp Galili. Jisas kaim a mamaa re öng ka ösöxö a xönö nang idi e, ");
INSERT INTO bjk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","möxösa, ine xö usu nanin abo bak ne ausu rine. Ixo tengen te idi, “Tabo bulus a Barok kö Tödi xö limine a nangadi, me idi tabo sexomet ine, ma melamu xö narun ne bung, ine irabo taru baling.” ");
INSERT INTO bjk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma lamun idi kaim a xikip a lasa ine ixo rengrengen, me idi toxo bubuut tua ose ine ulamunon. ");
INSERT INTO bjk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Io, idi toxo wanot Kaprenaum. Nang idi toxo laxa xö gunon, Jisas ixo ose idi, “A lasa iang mum mo egot nana min kö ngas?” ");
INSERT INTO bjk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lamun idi toxo kis malus, möxösa, xö ngas idi toxoro egot lamun ewe ine nang i taxin sik. ");
INSERT INTO bjk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisas ixo kisisik kö pu, ma ixo kuwe ina sangaun ma ninöng ma ixo tengen, “Nang bara ewe nang i mamaa rua taxin, ine irabo ii ölik ine iat, ma irabo tultul kö marakörö xirip.” ");
INSERT INTO bjk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jisas ixo lamus lo a bak lik ma ixo uru ine kaluluonin idi. Ixo pama ine ma ixo tengen tö idi, ");
INSERT INTO bjk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ewe nang irabo öga öng möxö ina abo barok lixilik na xö esene e, ine i öga e, ma lamun ewe nang i öga e, ine i kobo öga e, nexalik ine i öga a öng nang ixo tile e.” ");
INSERT INTO bjk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ixo tengen, “Tene Ausu, mem moxo pere a tödi ixo xikip tewe abo tano saban kö esem, me mem moxo tengen te ine ra ganim a wewet, möxösa, ine köbo öng mere ire.” ");
INSERT INTO bjk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas ixo tengen, “Ganim e mum kö wanwanak ine. Kaim pe öng nang i wewet a laa lölös ne auwuwus kö esene e, ma melamu ulik baling irabo tengen te laa saban tö e, ");
INSERT INTO bjk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","möxö ewe nang i kobo öbulubun ire, ine mere ire. ");
INSERT INTO bjk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Turunon saxit, ewenene nang i tabaa e mum ma kap ari, möxösa, mum mo kip sik a esene nang mum mere Krais, me ine irabo kip a xinixun möxönan.” ");
INSERT INTO bjk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Me Jisas ixo tengen öbaling, “Nang bara ewenene i pet a öng mere inabo barok lixilik na ewe idi te nunu re e rua pet magingin saban, irabo kip a warkurai taxin melamu. Io, ixere deek kö ine bara texere kut te xönö wat taxin kö inöno ma texere öriri ösu ine xö rasi, xalik ibo engin lo re öng kua pet magingin saban. ");
INSERT INTO bjk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Nang bara a limem i engin nöngön tua pet magingin saban, örobo tee xöröp tewe ine. I deek ke nöngön ta nilaxa xö to runon ma lime mut nöngön, xalik tabo tewe nöngön arixe ma nine limem urungan kö ia sösöt taxin nang i kara met. ");
INSERT INTO bjk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma nang bara a xexem i engin nöngön ta pet magingin saban, örobo tee xöröp tewe ine. I deek ke nöngön ta nilaxa xö to runon ma xexe mut nöngön, xalik tabo tewe nöngön arixe ma nine xexem urungan kö ia sösöt taxin. ");
INSERT INTO bjk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma nang bara a maram i engin nöngön ta pet magingin saban, örobo luok tewe ine. I deek ke nöngön ta nilaxa xö kingdom kö God arixe ma önga kalait maram, xalik tabo tewe nöngön arixe ma nine maram urungan kö ia sösöt, ");
INSERT INTO bjk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nang kö ia, ‘abo sisi ibo enen idi ma i karabo met, ma ia, tekebeöt ta pus ömet.’ ");
INSERT INTO bjk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tobo bulbulus a sol kö nien xarnang a ia irabo söngöt a nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“A sol ibo rorop ma nang bara a nanamien möxönan iri kawam, a nanamien möxönan irabo ot baling bule? I kebeöt. Me mum bölök, mum morobo top e mum iat, xarnang a sol ibo rorop. Me mum morobo kis ma malum arixe me mum iat.” ");
INSERT INTO bjk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Io, Jisas ixo wan kalik a xönö niang ma ixo wan laxa xö xönö pu mee Judeia ma ixo lies köröp kö Ari Jordan. Ma marakörö toxo wanot pösöt öbaling ine, ma ixo usu idi, xarnang ibo wewet. ");
INSERT INTO bjk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma dauleng ne Parasi toxo wanot pösöt ine ma toxo könönöin ine arixe ma önga aose bira, “I töxödös sik kö warkurai te ire bara a tödi irabo palas alolo xö une re ine?” ");
INSERT INTO bjk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Io, Jisas ixo balu, “A warkurai sa nang e Moses ixo isik ke mum?” ");
INSERT INTO bjk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Io, idi toxo tengen, “E Moses ixo ömaraxen a tödi ra gegeet te tinenge maras sua palas alolo ma rua ritile rewe ina une.” ");
INSERT INTO bjk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas ixo balu idi bira, “Moses ixo geet a warkurai na, möxösa, abo bala mum ixo lölös köba. ");
INSERT INTO bjk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma lamun kö urulo möxö uxixis möxö öxöno lagunon te God, ‘ixo pet idu a körö ma une.’ ");
INSERT INTO bjk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Möxö ina na, a tödi irabo wan lie a tata ma nago rine ma irabo kis arixe ma une re ine. ");
INSERT INTO bjk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Me idu tabo öng.’ Io, idu tekarabo ninöng im, ma lamun idu tabo öng. ");
INSERT INTO bjk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nang bara ixoro bie, ganim pe tödi ra walwalas a lasa nang e God ixoro bulus arixin sik.” ");
INSERT INTO bjk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Io, nang idi toxo laxa baling kölöme xö gunon, abo bak ne ausu toxo ose e Jisas lamun ina laa. ");
INSERT INTO bjk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ine ixo tengen, “Ewe re öng nang i köröp alolo ma une re ine ma i elolo xö une xabise, ine i pet a tatalien saban kö une re ine, möxösa, ine i maru ma une kaim bara re ine. ");
INSERT INTO bjk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nang bara une i köröp alolo ma tödi re ine ma i elolo xö tödi xabise, ine i pet a tatalien saban, möxösa, i maru ma tödi kaim bara re ine.” ");
INSERT INTO bjk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A nangadi toxo kip ot abo barok lixilik urungan te Jisas sö ine ra sisigi idi, nexalik abo bak ne ausu toxo töö rewe idi. ");
INSERT INTO bjk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Io, nang e Jisas ixo pere bira, ine xö bala kadik sik ke idi ma ixo tengen, “Moro ganim a bung bak lixilik ta wan ura re e, ma ganim a wanwanak idi, möxö a kingdom kö God, ine möxö inabo mangana bak lixilik bira. ");
INSERT INTO bjk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Turunon saxit, nang bara öng i kobo kip lo ina kingdom kö God xarnang a bak lik ine, i kebeöt ta nilaxa xönan.” ");
INSERT INTO bjk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Me Jisas ixo pama ot abo barok lixilik, ma ixo bulus a nine limine lömö re idi ma ixo seng e God ta wadöane idi. ");
INSERT INTO bjk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nang e Jisas ixo urulo a nuan te ine, a tödi ixo ulo kaa urungan te ine ma ixo subusu xö pu ma nine busuno xexene mesila re ine ma ixo ose, “Tene Ausu deek, a lasa nang arabo mana pet tua xikip ina to ulorexe saxit?” ");
INSERT INTO bjk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Io, Jisas ixo balu ma ixo tengen, “Ruasa u tengen e ma tödi deek? Kaim pe öng i deek, nexalik e God kalik mon. ");
INSERT INTO bjk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U ösöxö abo warkurai te Moses i tengen bira, ‘Ganim a arsexomet tataun, ganim a pet a tatalien ne ilawa ma önga tödi alolo, ganim a wuwulo, ganim a tengen töxö lamun a önga tödi, ganim a röxröxö lo a laa xö önga tödi xabise, ma örö ii ölik nöngön te tata me nago.’” ");
INSERT INTO bjk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ina tödi ixo tengen te Jisas, “Tene Ausu, nang e xo bak lik sik, e xobo mumuu inabo warkurai ot na.” ");
INSERT INTO bjk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas ixo pere ine ma ixo mamaa lamun ine. Ma ixo tengen, “Önga laa xalik u kobo pet eörin, örö wan, ma örö misik mabo laa xirip nang nöngön min ma örö tabaa a nangadi maris, io nang, nöngön örobo kip abo arabaa deek saxit tiso xö watmaep. Ma örö miang ma örö muu e.” ");
INSERT INTO bjk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nang a tödi ixo ölangen bira, a winara re ine ixo wawara marmaris, ma ixo wan lo ma tawunuk, möxösa, ine a tödi orong. ");
INSERT INTO bjk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas ixo wawara eli xöbo bak ne ausu re ine ma ixo tengen tö idi, “I lölös köba xö önga tödi orong kua nilaxa xö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Abo bak ne ausu toxo wuwus arixe xöbo tinenge re ine. Ma lamun Jisas ixo tengen öbaling ke idi, “Bung barok, i lölös köba ra nilaxa xö kingdom kö God! ");
INSERT INTO bjk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nang bara önga kamel i ka nuan laxa xö mara möxö nil möxö sinöxö, i kobo lölös köba xarnang a tödi orong i ka nilaxa xö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Abo bak ne ausu toxo wuwus köba arixe ma toxo tengen öbaling urungan tö idi iat, “Nang bara bie, ewe im pe öng irabo eöt ta xikip a to ulorexe?” ");
INSERT INTO bjk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas ixo pere idi ma ixo tengen, “Xö nangadi mon, idi tekebeöt. Ma lamun kö God, abo lalaa xirip i eöt, möxösa, e God i öt ta wewet eörin kirip abo lalaa.” ");
INSERT INTO bjk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Io, e Pita ixo tengen te ine, “Mem mere wan lie xirip abo lalaa re mem rua mumuu e nöngön!” ");
INSERT INTO bjk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisas ixo balu ma ixo tengen, “Turunon saxit, ewe nang iri wan lie a gunon tine, abo tönö, abo saxana, a nago, a tata, a bung baroxorok, bara abo komo rine rua gene e ma tinenge deek, ");
INSERT INTO bjk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ine irabo kip lo öbaling lömö xö önga mar ne gunon mabo tönö mabo saxana mabo nago mabo barok mabo komo, me idi tabo tabaa ine bölök ma kinadik taxin nang bara i mumuu e. Ma xö axana bung nang irabo ot melamu, ine irabo kip a to ulorexe saxit. ");
INSERT INTO bjk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma lamun a oleleng ewe nang te sila, tabo muu, ma nang te muu, tabo sila.” ");
INSERT INTO bjk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas mabo bak ne ausu toxo önan kö ngas uruso Jerusalem, me Jisas ixo silien a ngas, mabo bak ne ausu toxo dödöm oleleng, ma nangadi nang toxo muu idi toxo buut. Io, ixo lamus öbaling ina sangaun ma ninöng urungan kö lawa ma ixo tengen te idi lamun a lasa nang irabo ot te ine. ");
INSERT INTO bjk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ine ixo tengen, “Ire tabo wan kaa uruso Jerusalem, ma Barok kö Tödi, tabo isik ine xöbo limine abo pris tataxin mabo tene ausu möxöbo warkurai te Moses. Idi tabo bulus warkurai ra sesexomet ine ma tabo isik ine xö limine a nangadi kaim bara abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma ewe me idi nang tabo eösaxit saban arixe me ine ma tabo gisip ine, tabo dangat ine ma tabo sexomet ine. Narun ne bung melamu ine irabo taru baling.” ");
INSERT INTO bjk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Io, Jems me Jon, a nine barok ke Sebedi, toxo wanot pösöt e Jisas me idu toxo tengen te ine, “Tene Ausu, maa me mamaa bara örobo pet te laa rö maa nang bere maa me seng nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Io, ine ixo ose idu bira, “Mu mo mamaa bara a lasa e rabo pet te mu?” ");
INSERT INTO bjk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Idu toxo tengen te ine, “Örobo ömaraxen bere öng mere maa irabo kis kö lime tuun ma öng kö lime kes se nöngön nang örobo kip lo a kinis ne warkurai taxin te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Inexalik Jisas ixo tengen te idu, “Mu kobo ösöxö a lasa nang e mu mo eose ulamun. I eöt bere mu morobo inim kö tubon möxö kinadik niang e rabo inim könan, ma i eöt bere mu morobo kip lo a baptais ne tiip nang e rabo kip?” ");
INSERT INTO bjk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Idu toxo balu ine bira, “Maa me eöt.” Jisas ixo tengen tö idu, “Mu morobo inim kö tubon nang e rabo inim ma morobo kip lo a mangana baptais nang e rabo kip. ");
INSERT INTO bjk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma lamun tua kinis kö lime tuun bara xö lime kes, kaim bara laa re e ra inerabaa min. God iat irabo isik inabo kinis kö nangadi niang ixoro tagur sik inabo kinis se idi.” ");
INSERT INTO bjk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Io, nang a sangaun ne bak ne ausu xabise toxo ölangen bira, idi toxo bala kadik ke Jems me Jon. ");
INSERT INTO bjk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Io, Jisas ixo kuwe arixin idi ma ixo tengen te idi, “Mum mo ösöxö sik bara ewe me idi niang kaim bara abo Judeia. Ewe midi nang tabo perexulen bere idi a sisila re idi, io, inabo sisila tobo öraxin idi iat ma tobo pere ösu a nangadi xabise. Mabo orong ke idi tobo kure xöbanin idi. ");
INSERT INTO bjk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ina mangana magingin na i bele kis kaluluonin e mum, ma lamun ewe niang i mamaa ra ii öraxin ine iat kaluluonin e mum, ine irabo tultul te mum. ");
INSERT INTO bjk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Me ewe niang i mamaa rua tinuu sila, ine irabo tödi tinörön tataun mon te nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Rösa nene, nang a Barok kö Tödi bölök ine i kobo wanot bara a nangadi tabo tultul te ine. Kaim. Ine ixo wanot tua tultul te idi, ma bara irabo isik a to re ine ra xukun puxus a oleleng ne nangadi.” ");
INSERT INTO bjk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Io, idi toxo wanot to Jeriko. Nang e Jisas mabo bak ne ausu re ine, arixe ma a marakörö raxin, toxo önan lie ina lagunon taxin, önga tödi marapulo, a esene iang e Batimaus, a barok ke Timaus, ixo kisisik kö gegene ngas ma ixobo seseng lalaa xalik a nangadi. ");
INSERT INTO bjk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nang ine ixo ölengen bara e Jisas mee Nasaret, ine ixo urulo a kinup, “Jisas, a Barok kö marapun te Dewit, örö marase e!” ");
INSERT INTO bjk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oleleng toxo töö rewe ine ma toxo tengen te ine rua ödödö, nexalik bere ine ixo kup taxin belexim, “Barok köbo untubuno e Dewit, örö marase e!” ");
INSERT INTO bjk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Io, Jisas ixo tuu ma ixo tengen, “Moro kuwe ine ura.” Io, idi toxo kup urungan kina tödi marapulo, “Örö taru arixe ma axanan! Ine i xukuwe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma nang ixoro tewe rewe a xönö xinaxain te ine ma ixo kos kaa ma nine xexene ma ixo wanot pösöt e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisas ixo ose ine, “U mamaa bara arabo pet a lasanene re nöngön?” A tödi marapulo ixo tengen bira, “Tene Ausu, e mamaa bara arabo wawara.” ");
INSERT INTO bjk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas ixo tengen te ine, “Örö wan, a nunu re nöngön iri öro nöngön.” Saxit mon iang, a marna ixo öt ta winara ma ixo muu e Jisas kö ngas. ");
INSERT INTO bjk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E Jisas arixe mabo bak ne ausu re ine toxo wanot lörörö Jerusalem, idi toxo ot kö lagunon Betepage me Betani xö Maii Olip, io, Jisas ixo tile a nine bak ne ausu re ine, ");
INSERT INTO bjk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma ixo tengen tidu bara, “Mu moro wan urungan kö lagunon mesila re mu, ma saxit mon nang bara mu mo laxa xönan, mu morobo pere a önga dongki maxat te kubus sik ine e, ma kaim bang ke öng i kala xisin ine. Mu morobo palas tewe ine ma morobo lamus ot ine ura. ");
INSERT INTO bjk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma nang bara önga tödi i ose e mu bara, ‘Ruasa mu mo walwalas ina dongki na?’, io, mu morobo tengen te ine bira, ‘A Orong i mamaa ulamun ma irabo isik puxus öbaling na mon.’” ");
INSERT INTO bjk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Io, idu toxo wan lo ma toxo pere önga dongki maxat kö ngas, nang toxo kut sik ine xö marame lalaxa xö gunon. Nang idu toxo walwalas lo ine, ");
INSERT INTO bjk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","dauleng ne nangadi nang toxo tuu sik, toxo eose bara, “Mu mo palas a dongki na rua wewet a sa?” ");
INSERT INTO bjk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Idu toxo balu xarnang e Jisas ixo tengen sik ke idu, ma nangadi nang toxo öbala rewe idu. ");
INSERT INTO bjk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Io, idu toxo lamus ot ina dongki maxat urso re Jisas me idu toxo bulus abo man ömat te idu lömö xina dongki, me Jisas ixo kis kaa xönan. ");
INSERT INTO bjk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma nangadi oleleng toxo kip tewe abo xinaxain te idi ma toxo parawe xö ngas, ma dauleng toxo parawe abo axana iaa nang idi toxo tee möxöbo komo. ");
INSERT INTO bjk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ewe idi nang toxo wan sila ma ewe idi nang toxo muu toxo xukup bira, “Axabe e God! God irabo wadöane a öng nang i wanot tua wewet eörin a mamaa xö Orong!” ");
INSERT INTO bjk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“God irabo wadöane ewe i ot ta xikip a kingdom kö untubuno ire e Dewit.” “Axabe e God uruso lömö saxit!” ");
INSERT INTO bjk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Me Jisas ixo laxa Jerusalem, ma ixo wan laxa xö gunon lotu raxin. Ine ixo wawara nana xöbo lalaa xirip, ma lamun ixo wan lo urso Betani arixe ma ina sangaun ma ninöng, möxö ixoro aien im. ");
INSERT INTO bjk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Xö bung melamu nang idi toxo wan lie Betani, e Jisas ixo irilöng. ");
INSERT INTO bjk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ine ixo wawara möxö palaa ma ixo pere a uno löwö ixo tuu sik ma labana. Ine ixo wan lo ra werwere bara ine mere pasuno bara kaim. Io, nang ine ixo ot könan, ine ixo parasiwin bara kaim a pasuno, a labana xalik mon, möxösa, kaim bara axana bung möxö löwö ra ino. ");
INSERT INTO bjk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Io, Jisas ixo tengen kö ina uno iaa, “Ökorobo o baling ma kaim pe öng irabo en te pasuno mere nöngön.” Ma abo bak ne ausu re ine toxo ölangen ina nang ine ixo tengen. ");
INSERT INTO bjk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Io, nang idi toxo ot tiso Jerusalem, Jisas ixo laxa xö xönö möxö gunon lotu raxin ma ixo urulo ra batbat ösu ewe me idi nang toxo xuxuxun ma toxo mismisik kölöme. Ine ixo puxus lubeng abo öra xö nangadi nang tobo kulas tuluwok mabo öra möxö kinis se nangadi nang tobo mismisik ma buno. ");
INSERT INTO bjk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Me Jisas i kaim kö ömaraxen lo öbaling ke öng kua xikip ölaxa abo lalaa möxö misik urungan kö xönö möxö gunon lotu. ");
INSERT INTO bjk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Io, ine ixo usu idi ma ixo tengen, “Mum muru ösöxö sik a tinenge re God nang toxo geet i tengen bira: ‘A gunon te e tabo tengen ine ma gunon ne sineseng möxö öxöno lagunon kirip.’ Inexalik bara mum iat mum mo pet ine xarnang ‘a gunon ne minun möxö nangadi pinilo.’” ");
INSERT INTO bjk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Abo pris tataxin arixe mabo tene ausu möxöbo warkurai te Moses toxo ölangen bira ma toxo wawara siwin te ngas sa sesexomet ine, möxösa, idi toxo burin ine. Ma toxo burin ine, möxösa, a marakörö xirip tobo wuwuwus saban köbo ausu re ine. ");
INSERT INTO bjk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aien ixoro orot me Jisas arixe mabo bak ne ausu rine toxo wan lie e Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Xö bung kabise, Jisas arixe mabo bak ne ausu re ine toxo önan kö ngas, me idi toxo pere ina uno löwö ixoro manga xirip. ");
INSERT INTO bjk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Io, Pita ixo döxömen lo a tinenge re Jisas nang ixo tengen kö ina uno iaa. Ma ixo tengen, “Tene Ausu, pere bang! A uno löwö nang nöngön u köö, iri manga.” ");
INSERT INTO bjk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Io, Jisas ixo balu idi ma ixo tengen, “Örobo nunu re God. ");
INSERT INTO bjk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Turunon saxit, nang bara öng i tengen kö puot na bara, ‘Örö taru mera ma örö wan su uruo xö rasi,’ ma kaim ine mere nine dinödöm kö kat te ine ma lamun i nunu xö lasa ine i tengen irabo wanot, io, God irabo tabaa ine min. ");
INSERT INTO bjk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","E tengen te mum, lasanene mum mo seseng ulamun, mum morobo nunu bara mum morobo kip lo, ma a lasa niang mum mo seng, irabo re mum. ");
INSERT INTO bjk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ma nang bara u tuu sik ma u seseseng, ma nang bara u bala kinadik sik kere öng, örö döxömen taun a lasa ine i pet te nöngön, ma Tamam nuso lömö xö watmaep irabo döxömen taun a magingin saban te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Io, idi toxo ot baling kuso Jerusalem. Nang e Jisas ixo önan kölöme xö xönö möxö gunon lotu raxin, abo pris tataxin, mabo tene ausu möxöbo warkurai te Moses, mabo sisila toxo ot pösöt ine. ");
INSERT INTO bjk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Me idi toxo ose ine bira, “U kip lo ina ese raxin na mole nang nöngön u döxömen bere i töxödös se nöngön ta wewet inabo lalaa na? Me ewe i tabaa nöngön mina lölös na ra wewet inabo lalaa na?” ");
INSERT INTO bjk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas ixo balu idi ma ixo tengen, “E rabo ose e mum ma önga ineose bölök. Nang bara mum morobo balu e, io, e rabo tengen te mum a lölös sa nang e wewet inabo lalaa na min. ");
INSERT INTO bjk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A baptais se Jon, ine meriso lömö re God, bara mera xö nangadi mon? Moro tengen te e.” ");
INSERT INTO bjk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Idi toxo wöwörö min kaluluonin idi iat ma toxo tengen, “Nang bara ire te tengen bara, ‘Meriso re God,’ me ine irabo ose ire bara, ‘Ma ruasa me mum koxobo nunu re ine?’ ");
INSERT INTO bjk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Me ire takarabo tengen, ‘Möxö nangadi mon.’” (Idi toxo burin a nangadi, möxösa, idi toxo ösöxö sik bere Jon a propet.) ");
INSERT INTO bjk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Io, idi toxo balu e Jisas, “Mem kobo ösöxö.” Jisas ixo tengen te idi bara, “E bölök, e karabo tengen te mum ewe i isik ina lölös na re e ra wewet inabo lalaa na.” ");
INSERT INTO bjk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas ixo urulo a tinenge öwuo re idi, “A tödi ixo sulo a komo wain, ine ixo kut pi ma tabörö. Ma ixo kin a mara möxö wawas ömeme a pasuno wain ma ixo timet öxaa a warawat ma ixo pet a walpali rua werwere muu a komo wain. Io, ixo isik ina komo wain urungan köbo duöng kua tinörön könan ma ixo wan lo bang kö nuan ömat saxit. ");
INSERT INTO bjk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma xö axana bung möxö dixidik a pasuno wain ine ixo tile a önga tene tinörön urso xöbo tene werwere muu wain ta xikip lo xalik idi rebo pasuno wain möxö komo. ");
INSERT INTO bjk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma lamun ina nangadi nang toxo rörörön tingan toxo tödik ine ma toxo se ine ma toxo uguran tewe öbaling ine ma kaim a xikip pe pasuno wain. ");
INSERT INTO bjk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Io, ine ixo tile öbaling önga tene tinörön urso re idi me idi toxo paxat a öxöno ma toxo ömenge ine. ");
INSERT INTO bjk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Io, ine ixo tile öbaling önga tene tinörön, me idi toxo sexomet ine. Me ine ixo tile öbaling a oleleng bölök. Dauleng mere idi toxo se, ma dauleng toxo sexomet. ");
INSERT INTO bjk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Io, ine ma öng kalik im pa uguran, a bak söxöt iat te ine nang ibo mamaa xöba lamun. Ine ixo tile a bak ke ine melamu arixe re idi xirip, ma ixo tengen bara, ‘Idi tabo ii a barok ke e.’ ");
INSERT INTO bjk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Lamun abo tene werwere muu a komo wain toxo tengen kö öngöng kaluluonin idi iat bara, ‘Ina tödi niang i öt ta unan lo ina komo wain te tamana umelamu. Go, ire ta sexomet ine me ire tabo unan lo abo lalaa re tamana.’ ");
INSERT INTO bjk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Io, idi toxo lamus lo ine ma toxo sexomet ine, ma toxo tewe ösu ine xalik a komo wain. ");
INSERT INTO bjk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Io, a tamana komo irabo perim a lasa? Ine irabo wanot ma irabo sexomet inabo tene werwere muu a komo wain ma irabo isik ina komo wain urungan kö nangadi xabise. ");
INSERT INTO bjk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","I deek bara mum morobo döxömen ina tinenge re God nang toxo geet bara, ‘A wat nang abo tene pet gunon toxo kumamaa lamun, möxösa, idi toxo döxömen bara a laa tataun, i wawara bara ine bölök a lölös möxö unine gunon kirip. ");
INSERT INTO bjk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A Orong iat i pet ot ina laa na, me ire te pere ma lak deek saxit kö winara re ire.’” ");
INSERT INTO bjk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Io, a duöng tataxin mee Judeia toxo wawara siwin te ngas sua rörön dik e Jisas, möxösa, idi toxoro ösöxö bere Jisas ixo wöwörö eöt me idi ma tinenge öwuo na. Ma lamun idi toxo burin a marakörö, idi toxo wan lo xalik ine. ");
INSERT INTO bjk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Io, melamu idi toxo uguran a dauleng ne Parasi ma dauleng nang tobo mumuu e Erot urso re Jisas. Idi toxo mamaa ra sasaxi e Jisas möxöbo tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Idi toxo ot pösöt ine ma toxo tengen, “Tene Ausu, mem me ösöxö sik nöngön a tödi möxö rengrengen a turunon. Me nöngön u kobo ösöxö ra tinuu arixe mere önga tödi xalik mon, möxösa, nöngön u kobo dödöm köba lamun abo mangana duöng bule idi. Ma lamun nöngön u bo usu a nangadi ma turunon ulamun a ngas nang e God i mamaa bara ire tabo muu. I töxödös se ire bara tabo kun takis kö king taxin mee Rom bara kaim? ");
INSERT INTO bjk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ire tabo kun bara ganim?” Ma lamun e Jisas ixo ösöxö sik abo röxröxö re idi me ine ixo ose idi bara, “Ruasa mum mu mamaa ra uxun e? Mum moro kip lo re tuluwok ura ma ara pere.” ");
INSERT INTO bjk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Idi toxo kip ot ina önga tuluwok me ine ixo ose idi, “Re we ina wawara na ma ese na?” Me idi toxo balu bere, “Re king taxin mee Rom.” ");
INSERT INTO bjk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Io, Jisas ixo tengen te idi, “Mum morobo isik ke king taxin a lasa nang ke king taxin. Ma a lasa nang ke God, mum morobo isik ke God iat.” Io, idi toxo wuwus saban arixe re Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Io, dauleng ne Sadiusi niang tobo nunu bara kaim pe tinaru baling kalik a minet, toxo ot pösöt e Jisas ma toxo ose ine bara, ");
INSERT INTO bjk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tene ausu, Moses ixo geet tö ire bira, nang bara önga tödi, kaim ine mere barok ma i met kalik a une re ine, io, a tönö ina tödi irabo ot lamun ina möxösö ma irabo kip barok kö ina tönö. ");
INSERT INTO bjk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Io, a pitnö ma ninöng ne barön. A sisila ixo elolo ma ixo met, ma kaim ine mere barok. ");
INSERT INTO bjk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma a mumuu lo ine ixo ot lamun a möxösö, lamun ine bölök ixo met, ma kaim ine mere barok. Ma ixo bie bölök mon kö barok sese önarunin. ");
INSERT INTO bjk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Io, kaim im pe öng möxö ina pitnö ma ninöng ixo met lie re barok. Xakawöm möxönan, a une ixo met bölök. ");
INSERT INTO bjk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kö axana bung nang bara abo minet tabo taru baling, ine irabo une re ewe runon? Möxö ina pitnö ma ninöng toxo ot lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas ixo tengen te idi bara, “A dinödöm pe mum i kobo töxödös, möxösa, mum kobo ösöxö sik abo tinenge re God niang toxo geet ösu, me mum kobo ösöxö sik bölök a lölös se God. ");
INSERT INTO bjk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nang abo minet tabo taru kaa baling, idi tokobo eöt ta inalolo. Idi tabo xarnang abo angelo meriso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na e rabo wöwörö lamun abo minet, nang bara idi tabo taru baling, bara kaim. I deek bara mum morobo döxömen lo a ginigeet te Moses nang a uno iaa lik ixo söt, ma xina pii na, e God ixo tengen te Moses bie, ‘E a God te Abaram, a God te Aisak ma bara a God te Jekop.’ ");
INSERT INTO bjk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ine kaim bara a God möxö nangadi minet. Kaim! Inexalik ine a God möxö nangadi to. A dödöxömen te mum i kobo töxödös.” ");
INSERT INTO bjk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Önga tene ausu möxöbo warkurai te Moses ixo wanot ma ixo ölangen abo Sadiusi arixe me Jisas toxo egot ma tinenge. Ine ixo ölangen bere e Jisas ixo balu ödeek idi me ine ixo ose Jisas bira, “Ma xöbo warkurai kirip pe God, nangang sa i taxin ma i sisila?” ");
INSERT INTO bjk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisas ixo balu ine ma ixo tengen, “A sisila ne warkurai taxin ine bira, ‘A bung Israel, moro ölangen, a Orong, a God te ire, a Orong ine xalik mon. ");
INSERT INTO bjk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mum morobo mamaa ulamun a Orong, a God te mum, kö kat te mum ma xö tano mum ma xö dinödöm pe mum ma xö lölös se mum.’ ");
INSERT INTO bjk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Sese ninöngin ine bira, ‘Örobo mamaa lamun a öng kabise xarnang u mamaa lamun nöngön iat.’ Kaim pe warkurai i taxin köba re idu na.” ");
INSERT INTO bjk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Io, ina tene ausu möxö warkurai ixo tengen te Jisas, “Tene Ausu, a tinenge re nöngön i turunon saxit. A Orong ine xalik mon, ma kaim bölök ke önga god. ");
INSERT INTO bjk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma nang bara nöngön u mamaa lamun ine xö kat te nöngön, xö dinödöm pe nöngön, ma xö lölös se nöngön, ma u mamaa lamun a öng kabise xarnang u mamaa lamun öbaling nöngön iat, io, i taxin kirip sik köbo mangana arabaa ire te isik uruso re God.” ");
INSERT INTO bjk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nang e Jisas ixo ölangen bara ine ixo balu ödeek ine xarnang a tödi ma nanase deek, me ine ixo tengen te ine bira, “Nöngön u kobo kis kö palaa sik kalik a kingdom kö God.” Ma meringan urso abo tödi xabise toxo buut tua ose öbaling ine merebo inausu bölök. ");
INSERT INTO bjk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bere Jisas ixo eusu ruso kölöme xö gunon lotu raxin, ine ixo tengen bira, “Bara bule abo tene ausu möxöbo warkurai te Moses tobo rengrengen bara ine a Mesaia a barok tubuno e Dewit? ");
INSERT INTO bjk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dewit kalik mon ixo kip lo abo tinenge möxö Töxödös ne Tanono ma ixo tengen bira, ‘God a Orong ixo tengen kö Orong ke e bara: “Nöngön örö kis kö lawa tuun te e ot nang e rabo bulus abo iuo re nöngön kö ene xexem.” ’ ");
INSERT INTO bjk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dewit kalik mon i tengen ine me ‘Orong.’ Io, bule nang bara ine a Mesaia ma irabo a tubuno Dewit bölök?” Ma marakörö raxin toxo axanan ta ölangen a tinenge re Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma nang e Jisas ixo usu idi ine ixo tengen bira, “Mum morobo balaure e mum lamun abo tene ausu möxöbo warkurai te Moses. Idi tobo mamaa rua önan nana ma boxönö man ömat ma tobo mamaa bara tabo xukuwange idi kölöme xö boxönö möxö mismisik. ");
INSERT INTO bjk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma tobo werwere kos lo abo kinis deek kölöme xö gunon ne siniseng, ma tobo mamaa rua xikip lo a kinis deek kö axana bung möxö nien tataxin. ");
INSERT INTO bjk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Idi tobo kip lo abo lalaa möxöbo möxösö ma tobo osesen mabo sineseng ömat te idi. E God irabo ömokorot köbanin inabo mangana nangadi na.” ");
INSERT INTO bjk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas ixo kisisik kölöme xö gunon lotu raxin lörörö xö xönö möxö bubulus. Ma ixo werwere a marakörö toxo bubulus abo tuluwok ke idi kölöme xö xönö möxö bulbulus. Oleleng ne nangadi orong toxo bulus ölaxa oleleng ne tuluwok. ");
INSERT INTO bjk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ma lamun önga maris ne une möxösö ixo wanot ma ixo bulus ölaxa a nine peni re ine nang a marna i su xö pu. ");
INSERT INTO bjk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas ixo kuwe abo bak ne ausu re ine ma ixo tengen te idi bira, “Turunon saxit, ina maris ne une möxösö na, iri bulus ölaxa a oleleng köba re idi xirip kabise. ");
INSERT INTO bjk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Idi xirip toxo isik abo tuluwok meringan kalik abo kinis ne orong ke idi, ma lamun ina une maris i bulus ölaxa xirip abo lasanene nang i öt kö kinis kirip pe ine.” ");
INSERT INTO bjk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bere Jisas ixo önan lie a gunon ne lotu raxin, önga bak ne ausu re ine ixo tengen te ine bara, “Tene Ausu, pere bang abo xönö xö ina gunon lotu toxo pet mabo wat tataxin deek!” ");
INSERT INTO bjk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Io, Jisas ixo balu ine, “Nöngön u pere inabo gunon tataxin na. Idi tabo tamaöbeng su xirip. Kaim pe önga wat ta irabo kis lömö xö önga wat kabise.” ");
INSERT INTO bjk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma nang bere Jisas ixo kisisik kiso xö Maii Olip nang kö lawa xabise möxö marasaa nang a gunon lotu raxin ee, io, Pita, Jems, Jon me e Endru toxo wanot ma toxo ose ösuxume ine bara, ");
INSERT INTO bjk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Örö tengen te mem bara lause inabo lalaa na tabo ot kö inabo gunon, ma sa irabo ot ta uxileng bara inabo lalaa na iri lörörö ra inot?” ");
INSERT INTO bjk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Me Jisas ixo balu idi bira, “Mum morobo balaure e mum, kalik ke öng ibo töxö lo e mum. ");
INSERT INTO bjk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Oleleng tabo wanot ma tabo tengen bara idi te wanot kö esene e, ma bere, ‘E mon ina Mesaia.’ Me idi tabo töxö lo a oleleng. ");
INSERT INTO bjk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma nang bara mum morobo ölangen ulamun abo inarse rataxin ma ulamun abo tinenge lamun abo inarse rataxin, io, mum bele buut. Abo mangana lalaa na irabo ot, lamun a xakawöm angen i kala ot bang. ");
INSERT INTO bjk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Abo kantri tabo erese ma abo kantri. Mabo kingdom tabo erese mabo kingdom. Ma xöbo dauleng ne boxönö, a gie irabo ot, ma a irilöng taxin bölök. Inabo lalaa i xarnang a urulo möxö kinadik kö une ibo eka kip barok. ");
INSERT INTO bjk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mum morobo mana balaure ödeek e mum. Idi tabo isik e mum kö limedi abo tene warkurai, tabo se e mum kölöme xöbo gunon ne sineseng. Me mum morobo tuu xö warkurai xö wawara xöbo duöng sisila mabo orong lamun mon e. Me mum morobo tenge maras se idi lamun a tinenge deek. ");
INSERT INTO bjk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma mesila xö axana bung möxö xakawöm, tabo mana palas tinenge ma atöngösen deek urungan kö boxönö xirip. ");
INSERT INTO bjk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma nang bara te tödik e mum ma te uru e mum kö warkurai, ganim bere mum mo dödöm ne binuut bara mum morobo pet te tinenge sa. Mum morobo tengen mon abo lasa nang i ot urungan te mum kina axana bung, möxösa, kaim bere mum mo wöwörö. Kaim. Töxödös ne Tanono ine iat i wöwörö. ");
INSERT INTO bjk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Abo duöng tabo isik abo tönö idi xö minet, ma abo tata tabo pet bölök bie xö bung barok ke idi. A bung barok tabo baba urungan köbo tamadi mabo nenedi ma tabo tengen ta sesexomet idi. ");
INSERT INTO bjk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","A nangadi xirip tabo melentexin e mum, möxösa, xö eseke. Lamun ewe nang i tuu lölös sik urungan kö xakawöm, God irabo öro ine. ");
INSERT INTO bjk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Mum morobo pere ine nang i manga saban köba, nang ibo ögat lagunon, i tuu sik kö xönö nang i kobo töxödös bara ine mee. (Ewe i kos ina ginigeet na, irabo maras kö unine möxönan.) I deek bara a nangadi nang te xisixis Judeia xina bung, tabo ulo urso xöbo maii. ");
INSERT INTO bjk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ewe a öng nang i kisisik lömö xö öxöno gunon te ine, ganim bara i kaa su ma i wan laxa xö gunon ta xikip ösu rewe rebo mangana lalaa. ");
INSERT INTO bjk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Me ewenene nang i xisixis siso xö komo, ganim bara i su uri xö gunon ta xikip lo re xönö man te ine. ");
INSERT INTO bjk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Irabo laa ne maris köbo une nang te tienen, me idi nang te urus barok kö inabo bung na. ");
INSERT INTO bjk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mum morobo seseng bara inabo lalaa na i karabo ot kö axana bung möxö labur. ");
INSERT INTO bjk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Möxösa, a tiip taxin köbo bung niang, i karabo eöt ma nang möxö urulo, nang e God ixo uxis a öxöno lagunon ot na. Ma melamu, kaim pe tiip bira irabo wanot baling. ");
INSERT INTO bjk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma nang bara Orong i kobo se öwuruwut inabo bung niang, kawaim pe öng irabo to. Ma lamun ine irabo se öwuruwut abo bung kua rorop idi a nangadi re ine, nang ixo pere kos lo. ");
INSERT INTO bjk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kö ina bung niang, nang bara öng i tengen te mum, ‘Moro pere, a Mesaia ine na,’ bara, ‘Moro pere, a Mesaia ine niang,’ ganim e mum pa nunu xönan. ");
INSERT INTO bjk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Möxösa idi abo mesaia röxröxö mabo propet röxröxö, idi tabo wanot. Ma tabo pet ot abo uxileng mabo mangana lalaa lölös ne auwuwus sua röxröxö lo a nangadi niang God ixoro pere kos, nang bara idi te eöt tua röxröxö lo idi bira. ");
INSERT INTO bjk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Io, mum morobo mana tumarang e mum. E xoro tengen ösila sik ke mum köbo lasanene nang irabo ot te mum. ");
INSERT INTO bjk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma xöbo bung melamu xinabo tiip, ‘a xaken irabo ködö, ma texe i kebeöt ta bibio, ");
INSERT INTO bjk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ma abo tii tabo subu meriso xö balana kubu, ma abo lalaa lölös meriso xö mango irabo mamagi.’ ");
INSERT INTO bjk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kö ina axana bung niang im, a nangadi tabo pere a Barok kö Tödi irabo wanot kö kubu arixe ma lölös taxin ma a mariris. ");
INSERT INTO bjk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma irabo tile abo angelo ra lalamus etok a nangadi rine nang ixo pere kos lo. Abo angelo tabo lamus etok idi möxö nit ne marana xiki ma meringan bölök köbo ngusuno öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Io na, mum morobo kip inausu xalik a uno fik. Nang bara abo labana te subun kaa ma i tawalas, mum morobo ösöxö bara a axana bung möxö xaken iri lörörö rua inot. ");
INSERT INTO bjk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Xarnang iat mon, nang e mum mo pere inabo lalaa na te orot, mum morobo ösöxö bara ina axana bung iri lörörö rua inot, nang mon kö marame möxö nuan laxa. ");
INSERT INTO bjk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Turunon saxit, ina nangadi nang tabo pere inabo lalaa na, tekebeöt ta minet bang, ot nang abo lalaa na xirip irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A balana kubu ma öxöno lagunon irabo wan tup, nexalik bara a tinenge re e, i kebeöt ta xakawöm. ");
INSERT INTO bjk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma kawaim pe öng i ösöxö sik ina bung, bara a axana bung tunon, nang abo lalaa irabo wanot. Abo angelo niso xö watmaep tokobo ösöxö, ma a Barok iat bölök, i kobo ösöxö. Lamun e Mamaa xalik mon i ösöxö. ");
INSERT INTO bjk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Moro tumarang e mum! Me mum moro tagur sik! Möxö mum kobo ösöxö lause ina axana bung na irabo ot. ");
INSERT INTO bjk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I xarnang a tödi nang i önan tewe. Ine ibo wan lie a gunon te ine ma ibo tibe idi abo tultul te ine xöbo tinörön öngöng kua wewet, ma ibo tengen kö öng ibo ruruu wi a marame bara ira tagur sik. ");
INSERT INTO bjk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Io, mum morobo mana tagur sik, möxösa, mum kobo ösöxö a axana bung nang a tamana gunon irabo wanot baling, nang bara irabo wanot kö aien, bara xö luono dömön, bara nang a xixök i rengrenge, bara xö puxu bubung. ");
INSERT INTO bjk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Io, nang bara ine i wanot kölö e mum, xalik ine ibo pere lo e mum mo paliso sik. ");
INSERT INTO bjk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lasa nang e tengen te mum, e tengen te nangadi xirip: ‘Mum morobo mana tagur sik!’” ");
INSERT INTO bjk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Io, melamu xö nine bung urungan kö Luxa ne Nuan Lexe ma xöbo bung taxin möxö Enen a Beret Kaim a Is Könan, abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, idi toxo wawara siwin te ngas sua öxös suxume e Jisas sua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma lamun idi toxo tengen, “Ire takarabo pet biringan kö bung ne Luxa, xalik a nangadi tabo eöngat ma tabo ögat ire.” ");
INSERT INTO bjk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma nang e Jisas ixo xisixis siso Betani xö gunon te Saimon, nang mesila ine ma miniset lepra, me Jisas ixo kisisik ma ixo aan, io, önga une ixo wanot arixe ma botol deek ne sada, ma a xinixun möxönan a lak taxin. Ine ixo pörök ina botol sada ma ixo linge xö öxöno e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma uleng ne nangadi nang toxo kisisik kingan, toxo bala saban ma toxo etöngösen kaluluon te idi iat baling bara, “Ruasa ine i ösek tataunin ina sada na? ");
INSERT INTO bjk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ina sada na, ixoro eöt tua misik min kö narun ne mar ne siliwa, ma toxoro eöt tua isik abo tuluwok kö nangadi maris.” Me idi toxo tenge köö ögarin ina une. ");
INSERT INTO bjk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Me Jisas ixo tengen, “Moro ganim ine! Ruasa bara mum mo ögat köbanin ina une na? Ine iri pet a tatalien deek kö e. ");
INSERT INTO bjk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A nangadi maris angen tobo xisixis arixe me mum köbo bungbung kirip, me mum mo öt tua rorop idi xöbo mangana bung nang mum mo mamaa ulamun. Inexalik e karabo kis ömat arixe me mum kö bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A une na, iri pet eörin a lasa nang i öt ta wewet. Ine i linge a sada nang lak sixine deek kö aike, rua tagur sik e ra minet te e melamu. ");
INSERT INTO bjk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Turunon saxit, kö boxönö xirip kö öxöno lagunon nang tabo etöngösen ma tinenge deek, a lasanene niang a une na ixo pet, tabo etöngösen min, ma a nangadi tabo döxömen bölök ine.” ");
INSERT INTO bjk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Me Judas Iskariot, öng möxö ina sangaun ma ninöng, ixo wan pösöt abo pris tataxin tua isik tewe e Jisas kö limedi. ");
INSERT INTO bjk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma nang idi toxo ölangen ina na, idi toxo axanan köba. Ma toxo kubus tinenge rua ratabaa ine ma tuluwok. Io, ine ixo urulo ra winara siwin te mangana ngas mamaran tua isik e Jisas kö limedi. ");
INSERT INTO bjk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xö sila ne bung möxö Luxa möxö Beret Kaim a Is Könan, abo Judeia toxobo sesexomet abo sipsip ma ra enen tua dödöxömen lo a Luxa ne Nuan Lexe. Xö ina bung nang, abo bak ne ausu re Jisas toxo ose ine, “Ule ina xönö nang nöngön u mamaa bara e mem pa tagure a nien ne Nuan Lexe rue nöngön tua enen?” ");
INSERT INTO bjk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Io, ine ixo tile a ninöng möxö xinabo bak ne ausu re ine, ma ixo tengen te idu bara, “Mu moro wan laxa xö lagunon, ma tödi i kip nanin a bile ari irabo esuo me mu ringan. Mu morobo muu ine. ");
INSERT INTO bjk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma nang irabo wan laxa xere önga gunon, mu morobo tengen kö tamana gunon, ‘Tene Ausu i ose bara, “Ule a ngasieke nang e mabo bak ne ausu re e, mem marabo en ina nien ne Nuan Lexe xönan?” ’ ");
INSERT INTO bjk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Me ine irabo osen e mu ma önga xönö raxin niso lömö möxö önga gunon nang tere tagure sik. Mu morobo tagure a nien te ire xönan.” ");
INSERT INTO bjk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Io, a nine bak ne ausu toxo wan lo, ma toxo wan laxa xö lagunon, me idu toxo pere xirip lo inabo lalaa nang e Jisas ixo tengen te idu. Io, idu toxo tagure a nien möxö Luxa ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ixoro aien, Jisas ixo wanot ma sangaun ma ninöng ne bak ne ausu. ");
INSERT INTO bjk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma nang idi toxo kisisik ma toxo aan, Jisas ixo tengen te idi, “Turunon saxit, öng mere mum irabo isik e xö limine nangadi, ewe a öng nang i aan arixe me e na.” ");
INSERT INTO bjk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Io, a bung bak ne ausu toxo tapunuk, me idi öngöng toxo ose e Jisas bara, “Kaim bere e, goo?” ");
INSERT INTO bjk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Io, Jisas ixo balu idi, “Ine a öng kaluluon iat mon te mum a sangaun ma ninöng nang irabo öwösö a beret kölöme xö bile arixe me e. ");
INSERT INTO bjk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A Barok kö Tödi irabo wan urungan kö minet xarnang abo propet toxoro geet lamun ine. Ma maris belek kö tödi nang irabo isik a Barok kö Tödi xö limine a nangadi. Ixoro deek köba rö ine nang bara kaim e nago xö xikip ine.” ");
INSERT INTO bjk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma nang idi angen toxo aan, Jisas ixo kip lo a beret ma ixo tengen deek kö God, io, ixo pidik, ma ixo tabaa nanin abo bak ne ausu re ine min, ma ixo tengen te idi, “Mum moro kip lo. Ina na a aike.” ");
INSERT INTO bjk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Io, ixo kip lo a kap wain, ma ixo tengen deek kö God ma ixo örarabaa idi min, me idi xirip toxo inim könan. ");
INSERT INTO bjk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Me Jisas ixo tengen te idi bara, “Ine na a dee re e, nang e rabo linge lamun a oleleng kua öturunonin a kunubus meriso re God. ");
INSERT INTO bjk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Turunon saxit, e karabo inim öbaling ina wain na ot kö bung arabo inim öbaling ine xarnang a wain maxat tiso xö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Io, idi toxo ii önga sinö me idi toxo wan lo urso xö Maii Olip. ");
INSERT INTO bjk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas ixo tengen te idi, “Mum kirip morobo buut ma morobo buut ma morobo ulo lie e, möxö abo tinenge re God toxoro geet i tengen bira, ‘E rabo sexomet a tene werwere muu sipsip, ma abo sipsip tabo ulo rup elixilik.’ ");
INSERT INTO bjk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma lamun melamu e rabo taru baling kalik a minet ma arabo sila re mum urso Galili.” ");
INSERT INTO bjk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Inexalik Pita ixo tengen te ine, “Nang bere idi xirip tabo wan lie nöngön, lamun e iat, kaim.” ");
INSERT INTO bjk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Me Jisas ixo tengen te ine bara, “Turunon saxit, na xö dömön, nang a xixök i kobola tenge bang kö ninöng ne axan, nöngön örobo öös kelen e xö narun ne axan.” ");
INSERT INTO bjk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma lamun e Pita ixo tengen ölölös bara, “Nang bara e rabo met bölök arixe me nöngön, e karabo öös kelen nöngön.” Me idi xirip toxo tengen bölök bie. ");
INSERT INTO bjk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas arixe ma abo bak ne ausu re ine toxo wan urso xö önga xönö tobo rengrengen me Getsemani, ma ixo tengen köbo bak ne ausu re ine bara, “Mum moro xisixis sa me e ra wan ara seseng.” ");
INSERT INTO bjk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ine ixo lamus e Pita, Jems, me Jon arixe mine ma ixo xölxölö ma dinödöm oleleng. ");
INSERT INTO bjk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma ixo tengen te idi bara, “A balake iri tiip köba me e örasen bara örörö e rabo met. Mum moro kis ma moro wawara deek.” ");
INSERT INTO bjk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Me ine ixo wan ulik ma ixo subun kexe xö pu ma ixo seseseng bara ina axana bung möxö aöxadik irabo wan lie ine nang bara i öt. ");
INSERT INTO bjk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ine ixo seseng bira, “Mama, Mama re e, nöngön u öt ta wewet abo mangana laa xirip. E mamaa bara örobo irewe ina tiip na xalik e, ma lamun u bele muu eörin a mamaa re e. Kaim. Örobo muu a mamaa re nöngön iat.” ");
INSERT INTO bjk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Io, Jisas ixo wan pösöt öbaling idiet narun ne bak ne ausu re ine ma ixo pere wösöt lo idiet toxo paliso sik. Me ine ixo ose e Pita bara, “Saimon, nöngön u paliso? I kobo eöt bara örobo wawara arixe me e xere önga awa? ");
INSERT INTO bjk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Muot morobo mana wawara ma sineseng kalik a laa ne aöwalam irabo ot pösöt e muot, me muot bo subu xö magingin saban. A turunon, a bala muot i mamaa ra wewet abo tatalien deek, ma lamun a aimuot i kobo lölös.” ");
INSERT INTO bjk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Io, Jisas ixo wan tewe baling ma ixo seseng baling xarnang ixoro seseng bie. ");
INSERT INTO bjk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ma nang ixo baling, ixo pere abo bak ne ausu toxo paliso, möxösa, a maradi ixo tiip köba ra pinaliso. Ma kaim idi xo ösöxö bara idi tabo tengen bule rö ine. ");
INSERT INTO bjk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sese önarun ne nuan baling ke Jisas wösöt idiet ixo tengen bira, “Muot angen mo wapaliso ma mo mamas? Iri öt. Iri orim ina axana bung. Moro pere. Na tabo isik a Barok kö Tödi xö limine abo duöng saban. ");
INSERT INTO bjk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Moro taru me iret ta önan. Moro pere. A tödi nang irabo isik e xö limine idi, ine niang i önan ot.” ");
INSERT INTO bjk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ma nang e Jisas angen ixo rengrenge, e Judas, öng möxö ina sangaun ma ninöng, ixo wanot. A marakörö raxin toxo ot arixe mine mabo sele mabo amu. Abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, mabo sisila toxoro tile idi. ");
INSERT INTO bjk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma ina tödi nang ixo mamaa ra isik e Jisas kö limine nangadi, ine ixoro tagure önga mangana uxileng bira, “A öng nang e rabo muum, ine mon ina tödi. Mum morobo tödik ine ma morobo lamus tewe ine arixe mabo umri.” ");
INSERT INTO bjk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Saxit mon, e Judas ixo wan pösöt e Jisas ma ixo tengen, “Tene Ausu!” Ma ixo muum ine. ");
INSERT INTO bjk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A nangadi toxo tödik e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma a öng mere idi nang toxo tuu sik örörö ixo sat lo a sele ömat te ine ma ixo se a tödi tene tinörön möxö sisila raxin möxöbo pris, ma use ixo tee xöröp a talingine. ");
INSERT INTO bjk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Io, Jisas ixo tengen te idi, “Mum mo ot mabo sele mabo amu rua rörödik e, xarnang arixe bere e a tödi baba? ");
INSERT INTO bjk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ma xöbo bungbung kirip e xobo xisixis arixe me mum kölöme xö xönö möxö gunon ne lotu raxin me e xobo eusu, me mum kara töndik e. Ma lamun inabo lalaa na i ot ta wewet eörin abo tinenge re God.” ");
INSERT INTO bjk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Me idi xirip toxo wan lie e Jisas ma toxo ulo rup. ");
INSERT INTO bjk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma önga tödi maxat ixo mumuu nanin e Jisas, ixo laulawa sik mon ma xönö man. Ma nang idi toxo tön ine, ");
INSERT INTO bjk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ixo pules idi ma xö ulo lie a xönö man ma belbele. ");
INSERT INTO bjk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Idi toxo lamus lo e Jisas urungan kö sisila raxin möxöbo pris. Mabo pris tataxin kirip, abo sisila arixe mabo tene ausu möxö warkurai toxo wanot etok. ");
INSERT INTO bjk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ixo mumuu e Jisas kö nuan a lak palaa ulik ot nang ine ixo laxa xö xönö xö lawana ngasiene a sisila raxin möxöbo pris. Ringan, e Pita ixo kis arixe mabo tene walbalaurai me ine ixo dededek kö lawana ia. ");
INSERT INTO bjk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Abo pris tataxin mabo kansel kirip toxo wawara siwin te mangana unine tinenge rua wupuk e Jisas min tua sesexomet ine, ma lamun kaim idi xo werwere wösöt lo re mangana ngas. ");
INSERT INTO bjk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A oleleng toxo tengen ot a tinenge röxröxö rö ine, nexalik abo tinenge re idi kaim kö ululo eöt. ");
INSERT INTO bjk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma dauleng toxo tuu lömö ma toxo tengen ot a tinenge töxö rabaa ine bara, ");
INSERT INTO bjk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mem me ölangen ine i tengen bira, ‘E rabo öbeng ina gunon lotu raxin na nang a duöng toxo pet ma limedi. Ma xö sese önarun ne bung arabo uru a öng kabise nang a tödi i karabo pet ma limine.’” ");
INSERT INTO bjk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma lamun ina tinenge ridi kaim kö ululo eöt. ");
INSERT INTO bjk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma a sisila raxin möxöbo pris ixo tuu kaa xö wawara re idi ma ixo ose e Jisas bara, “Nöngön ökorobo balu re tinenge? A lasa ina tinenge na nang abo duöng na te wupuk nöngön min?” ");
INSERT INTO bjk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma lamun e Jisas ixo kis ödödö sik mon ma kaim kö babalu. Ma a sisila raxin möxöbo pris ixo ose öbaling ine, “Nöngön a Mesaia, a Barok kö God, bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Me Jisas ixo tengen, “E iat mon, me mum morobo pere a Barok kö Tödi irabo kisisik kö kinis taxin tingan kö lime tuun te God nang a lak lölös ine, ma irabo ot kö kubu ne watmaep.” ");
INSERT INTO bjk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ma sisila raxin möxöbo pris ixo laie ma ixo didii a man te ine, ma ixo tengen bara, “Ire tebele ose öbaling kebo duöng kua rengrengen ot tebo tinenge bölök kö ina tödi. ");
INSERT INTO bjk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mum moxoro ölangen bere ine ixoro tengen ögarin e God. Mum mo döxömen bara tabo pet bulungin ine?” Me idi xirip toxo tengen bara i töxödös bere e Jisas irabo mana met. ");
INSERT INTO bjk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Io, a dauleng toxo urulo ra gisgisip ine, me idi toxo kubus pi a marana, ma toxo tut ine mabo limedi ma toxo tengen te ine bara, “Örö tengen te tinenge propet im na.” Mabo tene walbalaurai toxo kip lo ine ma toxo se ine. ");
INSERT INTO bjk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nang e Pita ixo kisisik lawu kölöme xö xönö lawana gunon ma önga une tultul kö sisila raxin möxöbo pris ixo wanot. ");
INSERT INTO bjk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nang ina une ixo pere e Pita ixo dededek kö lawana ia, ma ixo pere dik e Pita ma ixo tengen, “Nöngön mon nang u xo arixe me Jisas meri Nasaret.” ");
INSERT INTO bjk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma lamun e Pita ixo öös, “Kaim. E kobo ösöxö me e kobo maras tunon lamun ina tinenge na nang u rengrengen.” Ma ixo wan urungan kö marame möxö nilaxa. ");
INSERT INTO bjk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma nang a une tinörön ixo pere ine ringan, ixo tengen öbaling kö nangadi nang toxo ruruu nana bara, “Ina tödi na ine bölök a öng mere idi.” ");
INSERT INTO bjk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Me ine ixo öös baling. A ulik mon melamu, a nangadi niang toxo ruruu lörörö nana toxo tengen te Pita bara, “Turunon bara nöngön mon a öng mere idi. Nöngön a tödi mee Galili.” ");
INSERT INTO bjk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Me Pita ixo tengen ölölös bara, “Sugurno bang mon e tengen a turunon te mum, e kobo ösöxö ina tödi nang mum mo rengrengen ine. Nang bara e töxö, io, e mamaa bara God irabo ömokorot köbanin e.” ");
INSERT INTO bjk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma saxit mon a xixök ixo tenge sese öninöng. Pita ixo döxömen lo a tinenge niang e Jisas ixo tengen te ine: “Nang a xixök i kobola tenge sese öninöng, nöngön örobo öös kelen e xö narun ne axan.” Me Pita ixo gee saban arixe. ");
INSERT INTO bjk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Xö puxu bubung arixe, abo pris tataxin, abo sisila mabo tene ausu möxöbo warkurai te Moses arixe mabo kansel kirip möxö lotu, toxo etöngösen ma toxo ot kö önga dinödöm. Idi toxo kubus a nini limine e Jisas ma toxo lamus ine urungan te Pailat. ");
INSERT INTO bjk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Me Pailat ixo ose ine, “Nöngön a king möxöbo Judeia?” Jisas ixo balu ine bara, “Ine mon xarnang u tengen.” ");
INSERT INTO bjk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Abo pris tataxin toxo puk ine mabo tinenge oleleng. ");
INSERT INTO bjk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Io, Pailat ixo ose öbaling ine, “Kaim nöngön mere tinenge ra babalu idi? Örö pere bara a oleleng ne lalaa te wupuk nöngön min.” ");
INSERT INTO bjk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Inexalik e Jisas kaim ine ra babalu bang ke tinenge, io, e Pailat ixo wuwus ma ixo dödöm oleleng. ");
INSERT INTO bjk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Io, xö Luxa ne Nuan Lexe, Pailat ixobo walwalas ösu a önga tödi xalik a gunon ne aömokorot, a tödi nang a nangadi tobo ose lamun ine. ");
INSERT INTO bjk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A tödi a esene e Barabas, toxo bulus ölaxa ine xö gunon ne aömokorot arixe mabo duöng nang idi toxo erese ömet arixe midi nang tobo kure abo Judeia xö axana bung kö arse raxin. ");
INSERT INTO bjk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A marakörö raxin toxo wanot ma toxo ose e Pailat tua wewet önga laa ra öaxanan idi xarnang ixobo wewet kö ina luxa. ");
INSERT INTO bjk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Me Pailat ixo balu idi ma ixo tengen, “Mum mo mamaa bara ara ii ösu ina king köbo Judeia urungan te mum?” ");
INSERT INTO bjk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ixo tengen bira, möxö ine ixo ösöxö bara abo pris tataxin toxo bala saban te Jisas, io, idi toxo isik ot e Jisas urungan te ine. ");
INSERT INTO bjk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Inexalik abo pris tataxin toxo silien a marakörö ma tinenge lölös sa kinup pe Pailat bara irabo ii ösu e Barabas xalik mon ma ganim e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","E Pailat ixo ose idi bara, “A lasa nang e rabo pet kö ina tödi nang mum bo xukuwe ine, a king möxöbo Judeia?” ");
INSERT INTO bjk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Me idi toxo kup urungan te ine bara, “Tut ine xö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Me Pailat ixo ose idi, “Ruasa? A mangana sasaban sa ine ixo pet?” Ma lamun idi toxo xukup nöngösö lömö iat bara, “Tut ine xö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E Pailat ixo mamaa ra wewet öaxanan a marakörö, io, ixo ii ösu e Barabas urungan te idi ma ixo tengen köbo umri ma toxo dangat e Jisas ma buso, ma melamu e Pailat ixo isik ine urungan te idi ra rutut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abo tene inarse toxo lamus ölaxa e Jisas urungan kö gunon taxin te Pailat, ma toxo kuwe etoxin kirip a nangadi arse. ");
INSERT INTO bjk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Idi toxo ölaulawa e Jisas ma man dadan xarnang a king ibo sisige, io, idi toxo kubus arixin abo uno gargaras ma toxo pet xarnang a bubuan, ma toxo usige xö öxöno e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Me idi toxo urulo ra kinup urungan bara, “Mem me ölet nöngön, king köbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Idi toxo dangdangat a öxöno ma buso ma toxo gisgisip ine. Idi toxo subun kexe me idi toxo tenge ölolot ine. ");
INSERT INTO bjk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma nang idi toxoro eösaxit mine, idi toxo irewe ina man dadan kalik ine ma toxo ölaulawa öbaling ine ma man iat te ine. Me idi toxo lamus ösu ine ra rutut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Önga tödi mee Sairin, a esene iang e Saimon, a tata re Aleksenda me Rupas, ixo önan kö nuan te ine ma ixo wan saxit kö ina lagunon. Me idi toxo ölölös lo ine rua xikip a sölöxöröp pe Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Idi toxo lamus e Jisas urso xö xönö tobo rengrengen me Golgota. (Unine ese na bara Xönö möxö Siine Öxöno Tödi). ");
INSERT INTO bjk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Io, idi toxo tabaa e Jisas ma wain nang toxo pet arixin ma abo mangana laa a lak sixine deek. Lamun kaim ine xo ininim. ");
INSERT INTO bjk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Io, a nangadi arse toxo tut ine xö sölöxöröp, ma toxo erimine abo man te ine re idi iat baling. Me idi toxo egulös satu ra werwere bere ewenene iat te idi irabo kip lo re lasanene sa. ");
INSERT INTO bjk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Xö pitnö ma nit ne axana bung kö puxu idi toxo tut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma toxo geet abo tinenge nang toxo puk ine min bira, “A king möxöbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Idi toxo tut bölök a nine tödi pinilo arixe me ine, a öng kö lime tuun ma öng kö lime kes. ");
INSERT INTO bjk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mabo nangadi nang toxo önan saxit, toxo tenge uli ine. Idi toxo urie abo öxöno idi ma toxo tengen te ine bara, “Aa! Nöngön mon iang örobo pörök ösu a gunon lotu raxin ma örobo uru öbaling mon kö narun ne bung. ");
INSERT INTO bjk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na im örö wan su meringan kö sölöxöröp ma örö top öbaling nöngön iat!” ");
INSERT INTO bjk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Xö ina ngas iat nang, abo pris tataxin arixe mabo tene ausu möxöbo warkurai te Moses idi bölök toxo tenge uli ine kaluluon iat te idi, me idi toxo tengen öbaling bara, “Ine i rorop a nangadi xabise, ma bara bule i kebeöt ta rorop ine iat? ");
INSERT INTO bjk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nang bere ine a Mesaia, a King mee Israel, irabo wan su na mon kalik a sölöxöröp me ire tabo pere ma tabo nunu.” Nine tödi idi toxo tut idu xö nine sölöxöröp arixe mine, idu bölök toxo tenge uli ine. ");
INSERT INTO bjk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Xö luono xaken a ködö ixo wanot ma ixo tawi xirip ina öxöno lagunon ot kö narun ne axana bung kö aien. ");
INSERT INTO bjk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma xö narun ne axana bung, Jisas ixo gee wösö ma ixo tengen, “Eloi, Eloi, lama Sabakatani?” A unine möxönan i tengen bira, “God te e, God te e, ruasa u wan kalik e?” ");
INSERT INTO bjk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma dauleng niang toxo tuu örörö sik toxo ölangen ina na, ma toxo tengen, “Moro ölöngö, ine i xukuwe e Elaija.” ");
INSERT INTO bjk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma önga tödi mere idi ixo ulo ma ixo bulus ölaxa a spans kö wain manun, ma nang a wain ixo wöwö xönan ixo kut parange xö iaa ma ixo sanga kaa min urungan te Jisas sa ininim. Ma ixo tengen, “Tuu bang! Ire ta pere bere Elaija irabo ot ma irabo palas ösu ine bara kaim.” ");
INSERT INTO bjk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Me Jisas ixo kup taxin ma ixo tewe mamas. ");
INSERT INTO bjk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma xönö man taxin nang ibo bölö wi sik a gunon lotu raxin ixo tamadidi nine xönö merso lömö uri arixe xö pu. ");
INSERT INTO bjk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma a umri raxin möxöbo duöng arse ixo tuu mesila sik ke Jisas. Nang ine ixo ölangen e Jisas bara ixo kup taxin ma ixo pere bölök nang e Jisas ixo met bule, ixo tengen, “Turunon saxit, a tödi na a Barok kö God!” ");
INSERT INTO bjk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma dauleng ne balixilik toxo tuu sik kö palaa ma toxo ngökngök mon. Kaluluon te idi, e Maria mee Makdala, me Maria nago re Josep me Jems nang a barok melamu, arixe me Salomi. ");
INSERT INTO bjk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Idiet toxobo mumuu e Jisas nang ine ixo xisixis Galili ma toxobo balaure ine xöbo sasaxan te ine. Ma oleleng ne balixilik bölök ewe nang toxo wanot arixe me ine uruso Jerusalem, idi bölök angen. ");
INSERT INTO bjk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Xö aien kö bung pitnö abo Judeia tobo tagur möxö ina Sabat, xö bung malamu. ");
INSERT INTO bjk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Io, Josep me Arimatia, ine a öng möxö duöng taxin möxöbo kansel. Me ine iat bölök ibo xixiset lamun a kingdom kö God. Ine ixo wan pösöt e Pailat ma kaim ine xo binuut ma ixo ose ine lamun a minet te Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat ixo wuwus nang ixo ölangen bere Jisas ixoro met. Ine ixo kuwe lo a umri raxin möxöbo duöng ne arse ma ixo ose ine bere Jisas ixoro met bara kaim. ");
INSERT INTO bjk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma nang ixo ölangen a tinenge möxö ina umri bere Jisas ixoro met, ixo ömaraxen a minet te Jisas urungan te Josep. ");
INSERT INTO bjk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Io, Josep ixo kun abo man pidien ma ixo tön ösu ina aine. Ixo kait pi ine ma man pidien, ma ixo bulus ölaxa ine xö lieng niang ixoro luok tewe xalik a wat. Ma ixo ubun pi a marana lieng ma önga wat taxin. ");
INSERT INTO bjk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria mee Makdala me Maria nago re Joses toxo pere a xönö nang toxo ömarin sik ine xönan. ");
INSERT INTO bjk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nang a Sabat ixoro saxit, Maria mee Makdala, me Maria nago re Jems, arixe me Salomi toxo kun a wel ma abo lalaa nang a lak sixine deek, rö idiet ta nuan ta salap kö aine e Jisas. ");
INSERT INTO bjk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Xö Sade xö puxu bubung nang a xaken ixo tawök ka arun, idiet toxo wan urungan kö lieng ne minet. ");
INSERT INTO bjk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Me idiet toxo ose öbaling iat idiet bara, “Ewe irabo ubun tewe ina wat kalik a marana lieng?” ");
INSERT INTO bjk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma lamun nang idiet toxo wawara kaa, idiet toxo pere bara toxoro ubun tewe ina wat nang a lak taxin. ");
INSERT INTO bjk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nang idiet toxo laxa urso kölöme xö lieng, idiet toxo pere önga tödi maxat ixo kisisik kö lawa tuun ma ixo sige sik a man pidien. Me idiet toxo wuwus köba ma toxo buut. ");
INSERT INTO bjk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma ina tödi ixo tengen tö idiet bara, “Ganim e muot ta binuut. E ösöxö bere muot mo wawara siwin e Jisas meri Nasaret, ewe nang toxo taba ine xö sölöxöröp. Kaim ine ra. Ine iri taru baling kalik a minet. Me muot moro pere ina xönö niang toxo ömarin ine xönan. ");
INSERT INTO bjk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lamun na, muot moro wan ma moro tengen köbo bak ne ausu re ine arixe me Pita bere, ‘Jisas ire sila re mum uri Galili. Ma ri, mum morobo pere ine xarnang ine ixoro tengen sik ke mum.’” ");
INSERT INTO bjk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Io, idiet toxo wan su xalik ina lieng ma toxo ulo rup, möxösa, idiet toxo buut ma toxo dedede. Me idiet kaim kö rengrengen kere öng, möxösa, idiet toxo buut köba. ");
INSERT INTO bjk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ma nang e Jisas ixo taru baling kalik a minet kö Sade xö puxu, ine ixo wösö arun te Maria mee Makdala nang ine ixo irewe a pitnö ma ninöng ne tano saban kalik ine. ");
INSERT INTO bjk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ine ixo wan ma ixo tengen nanin te idi nang toxobo önan nana arixe me ine, me idi nang toxo gegee ma tapunuk. ");
INSERT INTO bjk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nang idi toxo ölangen bere Jisas ixoro to baling ma bere Maria mee Makdala ixo pere sik ine, kaim idi ra nunu xönan. ");
INSERT INTO bjk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Melamu xönan, Jisas ixo ot pösöt a nine tödi xö ngas ma önga mangana winara xabise niang idu toxo önan köbo lagunon taxin. ");
INSERT INTO bjk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Me idu toxo wanot baling ma toxo tengen osen köbo bak ne ausu xabise xirip, lamun kaim idi xo nunu re idu. ");
INSERT INTO bjk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Melamu arixe im, e Jisas ixo ot pösöt ina sangaun ma öng nang toxo aan. Ine ixo köö idi, möxösa, kaim idi xo nunu ma abo baladi ixo tabönöt köba rua nunu re nangadi nang toxo pere bere ine i taru baling. ");
INSERT INTO bjk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Me Jisas ixo tengen te idi, “Mum moro wan urungan kö öxöno lagunon kirip ma moro palas tinenge ma tinenge deek. ");
INSERT INTO bjk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ewenene nang i nunu ma i kip a baptais, irabo kip a to ulorexe, ma lamun ewenene nang i kobo nunu irabo tuu xö warkurai. ");
INSERT INTO bjk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Me ewe idi nang te nunu re e, e rabo tabaa idi ma lölös sua wewet abo auxileng kölöme xö eseke rua tile rewe abo tano saban, me idi tabo wöwörö xöbo mangana tinenge xabise kaim idi ra ausu ulamun. ");
INSERT INTO bjk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Idi tabo tön öxaa a si xö limedi, ma nang bara idi te inim a mele möxö sesexomet a nangadi, i karabo perögat idi. Kaim. Idi tabo bulus abo limine idi lömö xö nangadi miniset, ma tabo deek baling.” ");
INSERT INTO bjk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Malamu nang e Jisas a Orong ixo wöwörö re idi, God ixo kip lo ine uruso lömö xö watmaep, ma ixo kis kö lawa tuun te God. ");
INSERT INTO bjk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Io, abo bak ne ausu toxo wan lo ma toxo palas tinenge xö boxönö xirip, me Orong ixo rörön arixe me idi ma ixobo isik abo uxileng kua osen bara abo tinenge re idi a lak turunon. ");
INSERT INTO bjk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","23Orong Tiopilas, a oleleng idi toxo döxömen bara idi tabo geet muu abo lalaa iri wanot kaluluonin e mem. ");
INSERT INTO bjk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Io, idi toxo muu abo atöngösen te idi abo tene atöngösen ma tinenge deek. Me idi abo tene atöngösen, idi iat niang idi toxo pere runin inabo lalaa mero xö urulo. ");
INSERT INTO bjk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Möxö ina na, e döxömen bara i deek bara arabo geet muu inabo lalaa na, möxösa, e iat e xo ose muu ödeek ulamun inabo lalaa mero xö urulo. ");
INSERT INTO bjk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Me e döxömen bara arabo pet bie bara örobo ösöxö a turunon ulamun abo lalaa nang u xoro kip abo inausu möxönan. ");
INSERT INTO bjk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Xö axana bung nang e Erot ixo king mee Judeia, önga pris a esene iang e Sekaraia. Ine a marapun te Abisa, ma a une re ine e Elisabet. Me ine bölök a marapun te Aron. ");
INSERT INTO bjk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Me idu xirip a nine tene töxödös kö wawara xö God. Me idu xirip toxobo mumuu a warkurai xö Orong. Ma i kebeöt te öng bara irabo puk idu mere tatalien saban. ");
INSERT INTO bjk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Inexalik bara, kaim idu mere barok, möxösa, e Elisabet ixo une tuu me idu xirip toxo ötaxin saban. ");
INSERT INTO bjk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Önga bung e Sekaraia ixo wewet a tinörön köbo pris kö mamaran kö God, möxösa, a axana bung bara abo pris nang idi mere Sekaraia idi toxo rörörön. ");
INSERT INTO bjk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Io, idi toxo egulös ma satu rua pere kos bere ewenene irabo laxa xö gunon lotu xö Orong kua söngsöngöt a arabaa nang a lak sixine deek. ");
INSERT INTO bjk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma nang a axana bung möxö söngsöngöt a arabaa nang a lak sixine deek ixo ot, a nangadi nang toxo ot etok kö araman kö gunon kö God, idi toxo seseseng. ");
INSERT INTO bjk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Io, a önga angelo ixo ot pösöt e Sekaraia. Ma a angelo ixo tuu sik kö lawa tuun kö öra möxö söngsöngöt a arabaa nang a lak sixine deek. ");
INSERT INTO bjk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ma nang e Sekaraia ixo pere ine, ixo wuwus ma ixo buut köba. ");
INSERT INTO bjk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Inexalik bara a angelo ixo tengen te ine, “Sekaraia, ganim a binuut. A Orong iri ölangen a sineseng ke nöngön. Elisabet, a une re nöngön, irabo kip a bak suxurno rö nöngön, ma örobo isik a esene bere e Jon. ");
INSERT INTO bjk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ine irabo öaxanan nöngön ma oleleng tabo axanan nang tabo kip ine, ");
INSERT INTO bjk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","möxösa, ine irabo tödi raxin kö wawara xö Orong. Me ine i bele inim pe wain bara re ari lölös. Ma irabo wöwö ma Töxödös ne Tanono urulo iat mero xö balana nago. ");
INSERT INTO bjk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Me ine irabo lamus puxus a marakörö oleleng mee Israel urungan kö Orong, a God te idi. ");
INSERT INTO bjk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Me ine irabo kip a tatalien ma lölös se Elaija ma irabo sila xö Orong kua bulbulus a malum kaluluonin a tata ma bung barok ke idi. Ma irabo ötöxödös a dödöxömen köbo tabuno ölangen tinenge, me idi tabo kip a dinödöm deek xarnang a nangadi töxödös. Ine irabo tagur sik a nangadi bara idi tabo xixiset ulamun a Orong nang irabo wanot.” ");
INSERT INTO bjk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia ixo ose a angelo, “E rabo ösöxö bulengin ina na? E re ötaxin ma une re e bölök iri une raxin.” ");
INSERT INTO bjk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A angelo ixo balu, “E, e Gabriel. E bo ruruu xö wawara xö God, me ine iat i tile e rua rengrengen te nöngön ma rua töngösen nöngön ma ina atöngösen deek na. ");
INSERT INTO bjk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma nixinen nöngön örobo tabuno tinenge ma örobo ödödö ot kö bung nang ina laa irabo wanot, möxösa, nöngön u kobo nunu xöbo tinenge re e nang irabo ot turunon kö bung iat möxönan.” ");
INSERT INTO bjk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Inexalik bara, a marakörö toxo xixiset me Sekaraia, ma toxo ngangao ruasanene ine ixo kis lis köba ruso kölöme xö gunon ne lotu raxin. ");
INSERT INTO bjk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nang ine ixo wan su, kaim ine ra eöt tua tinenge rö idi. Me idi toxo ösöxö xulen lo bara ine ixo pere önga winawara xö gunon ne lotu raxin, möxö ixo ööt mon ma limine urungan te idi inexalik bara i kexebe eöt tua tinenge. ");
INSERT INTO bjk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nang a axana bung ke ine möxö tinörön ixo kawam, ixo tawuxus baling u lagunon. ");
INSERT INTO bjk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Melamu xö ina na, e Elisabet, a une re ine, ixo tienen, ma ixo kis mun sik kö ngasiene ot kö pitnö ne texe. ");
INSERT INTO bjk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Me ine ixo tengen, “A Orong i pet bira rö e. Ma xö ina axana bung na, ine iri osen a inemarse ma iri kip tewe a minenge re e xalik a marana a marakörö.” ");
INSERT INTO bjk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ma nang e Elisabet ixoro tienen kö pitnö ma öng ne texe, God ixo tile e angelo Gabriel u Nasaret, a lagunon kölöme Galili. ");
INSERT INTO bjk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ma ixo tile ine urungan kö önga une maxat nang kaim bang ine xö minaru arixe mere tödi ma toxo isik pi sik ine bara irabo elolo xö önga tödi a esene e Josep, a marapun te Dewit. Ma a esene ina une maxat e Maria. ");
INSERT INTO bjk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma a angelo ixo wan urungan te ine ma ixo tengen, “A Orong iri kis arixe me nöngön ma iri wadöane nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria ixo ngangao xöbo tinenge re ine ma ixo dödödöm bara a mangana tinenge sa ina na. ");
INSERT INTO bjk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Inexalik bara, a angelo ixo tengen te ine bira, “U bele bubuut, Maria. God i axanan te nöngön ma i tagur sik bara irabo wadöane nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nöngön örobo tienen ma örobo kip önga barok suxurno, me nöngön örobo pes a esene e Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ine irabo tödi raxin ma tabo tengen ine ma Barok kö God lömö saxit. God, a Orong, irabo tabaa ine ma kinis ne king nang ke untubuno e Dewit. ");
INSERT INTO bjk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Me ine irabo kure ulorexe a bung marapun te Jekop. Ma kinis ne warkurai te ine i karabo kawam.” ");
INSERT INTO bjk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria ixo ose a angelo, “Ina laa na irabo ot turunon bara bule? E kobola ösöxö bang ke tödi.” ");
INSERT INTO bjk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma a angelo ixo balu ine bira, “A Töxödös ne Tanono irabo ot pösöt nöngön ma lölös kö God lömö saxit irabo kawönö nöngön. Io, ina tee Madakdak nang örobo kip tabo tengen ine bara a Barok kö God. ");
INSERT INTO bjk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Örö ölangen! E Elisabet nang a unaun te nöngön, ine iri tienen, ma a une raxin ine. Ma toxo tengen bara ine a une tuu, inexalik bara ine iri tienen eöt ma pitnö ma öng ne texe. ");
INSERT INTO bjk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kaim pe laa i lölös se God.” ");
INSERT INTO bjk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Me Maria ixo balu, “E a tultul kö pu xö God. I öt bara irabo bie ura rö e xarnang nöngön uru tengen.” Io, a angelo ixo wan lie ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Io, xö ina axana bung nang Maria ixo tagur lo ma ixo wan pasaxit urungan kö önga lagunon tuso xöbo maii mee Judeia. ");
INSERT INTO bjk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ma ixo laxa xö gunon te Sekaraia ma ixo öga e Elisabet. ");
INSERT INTO bjk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma nang e Elisabet ixo ölangen bere e Maria ixo öga ine, a barok nang kö balana ixo mamagi xöba, me e Elisabet ixo wöwö ma Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Io, ixo tenge lömö saxit, “Irabo deek kö nöngön köbo balixilik kirip, ma ina barok bölök nang örobo kip. ");
INSERT INTO bjk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Inexalik bara, e ewe, bara a nago xö Orong ke e irabo wanot ura rö e? ");
INSERT INTO bjk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nang iat mon a nine talingine e i ölangen nang u öga lo e, a barok na kölöme re e i mamagi ma axanan. ");
INSERT INTO bjk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Irabo deek kö nöngön nang uru nunu bara a lasanene a Orong iri tengen te nöngön, ine irabo ot turunon.” ");
INSERT INTO bjk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Me Maria ixo tengen, “Mera kölöme re e, e ii öraxin a Orong. ");
INSERT INTO bjk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma a tanoke i axanan te God a Tene Aöro re e, ");
INSERT INTO bjk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","möxö ixo döxömen e xö kinis ne maris se e, a tultul te ine. Io, urulo im na a marakörö nixinen me idi nang melamu idi tabo tengen bara irabo deek kö e, ");
INSERT INTO bjk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","möxösa, a God nang a lak lölös saxit iri pet abo lalaa rataxin tö e. A esene ine i madakdak. ");
INSERT INTO bjk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ma a inemarse re ine i önan urungan te idi nang tobo buburin ine möxö önga mexubu urungan kö önga mexubu. ");
INSERT INTO bjk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iri pet abo lalaa lölös ma limine. Iri tile ebasin idi nang idi te döxömen öraxin öbaling idi. ");
INSERT INTO bjk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iri bulus ösu abo sisila raxin meringan köbo kinis möxö pet warkurai te idi. Inexalik bara ine iri ii öraru abo maris. ");
INSERT INTO bjk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ine iri öwöwö idi nang te irilöng ulamun abo lalaa deek. Inexalik bara ine iri tile rewe tataunin abo asuono orong. ");
INSERT INTO bjk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ine iri top e Israel, a tultul kö pu re ine. Ma i döxömen sik iat bara irabo isik ulorexe saxit a abalamu re ine ");
INSERT INTO bjk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","rue Abaram mabo untubuno melamu, xarnang bölök ixo tengen urungan köbo untubuno ire.” ");
INSERT INTO bjk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Me Maria ixo kis arixe me Elisabet ot kö narun ne texe ma ixo tawuxus baling im urungan lagunon. ");
INSERT INTO bjk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nang a axana bung ke Elisabet ta xikip a barok, ixo kip a barok suxurno. ");
INSERT INTO bjk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Idi nang idi tobo kis lörörö sik ke ine ma bung unaun te ine, idi toxo ölangen bara a Orong ixo osen a inemarse re ine, me idi toxo axanan arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ma xö pitnö ma narun ne bung idi toxo wanot tua xurxuru a lewene aine barok, me idi toxo eka isik a esene tamana e Sekaraia re ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Inexalik bara a nago re ine ixo tengen bara, “Kawaim! Tabo tengen ine bere e Jon.” ");
INSERT INTO bjk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Me idi toxo tengen te ine, “Kaim pe öng kaluluonin abo unaun te nöngön ewe ma ina ese niang.” ");
INSERT INTO bjk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Io, idi toxo ööt urungan kö tata re ine rua ösöxö lo bara ese sa ine i mamaa bara tabo isik kö barok. ");
INSERT INTO bjk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ixo seseng ulamun te laa rua ginigeet könan, ma ixo geet bira, “A esene e Jon.” Me idi xirip toxo wuwus saban. ");
INSERT INTO bjk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma nang iat mon a ngalana ixo tamasawang ma a kamene ixo tawalas, ma ixo urulo rua tinenge ma ixo ölet e God. ");
INSERT INTO bjk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Me idi nang lörörö toxo wöwö ma binuut. Ma a nangadi ringan kö boxönö xirip köbo maii mee Judeia, toxobo wöwörö ulamun inabo lalaa na. ");
INSERT INTO bjk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Me idi xirip nang toxo ölangen ina na, toxo dödöm oleleng ulamun, ma toxo eose, “Ina barok na, irabo mangana tödi bule?” Möxö a lölös kö Orong ixo kis arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A tamana ine e Sekaraia ixo wöwö ma Töxödös ne Tanono ma ixo tenge ne propet bira, ");
INSERT INTO bjk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“A aölelet urungan kö Orong, a God mee Israel, möxösa, ine iri wanot ma iri ölanglanga a nangadi re ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ine iri öraru a önga tödi lölös meringan kö bung marapun te Dewit, nang a tultul kö pu re ine, bara rua öro ire. ");
INSERT INTO bjk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","I xarnang ixo tengen mesila saxit meringan köbo madakdak ne propet te ine. ");
INSERT INTO bjk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Irabo öro ire xalik abo iuo re ire ma meringan kö limine idi xirip nang tobo melentexin ire. ");
INSERT INTO bjk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ixo pet bira rua osen a inemarse urungan köbo untubuno ire, ma rua dödöxömen lo a kunubus madakdak ke ine ");
INSERT INTO bjk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","nang ixo usugurno xö untubuno ire e Abaram ");
INSERT INTO bjk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","rua ölanglanga ire xalik a limine abo iuo re ire, bara ire tabo eöt tua tinörön tö ine ma kaim a binuut ");
INSERT INTO bjk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","arixe ma tatalien madakdak ma tatalien töxödös xö mamaran te ine xöbo bungbung kirip pe ire. ");
INSERT INTO bjk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Me nöngön a barok ke e, tabo tengen nöngön bara a propet nang ke God lömö saxit, möxö nöngön örobo sila xö Orong kua tagure a ngas sö ine ");
INSERT INTO bjk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","rua tabaa a nangadi ma nanase rua xikip a ineöro nang e God irabo döxömen taun abo magingin saban te idi, ");
INSERT INTO bjk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","möxösa, xö inemarse deek kö God te ire. Ma arixe ma a inemarse re ine irabo tile a maras möxö xaken meruso xö watmaep ura re ire, ");
INSERT INTO bjk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","rua mararang lömö re idi nang te xisixis kö ködö ma xö ene lölös möxö minet, ma rua silien ire ra nuan kö ngas ne malum.” ");
INSERT INTO bjk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma a barok ixo taxin kaa ma ixo lölös kölöme xö tanono, ma ixobo xisixis kö xönö tataun ot nang ixo wanot wösö xöbo Israel. ");
INSERT INTO bjk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma xö ina axana bung Augastus, a king taxin mee Rom, ixo isik önga warkurai bara tabo kos a marakörö xirip nang e Rom ixo balaure sik. ");
INSERT INTO bjk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ina na a sinila ne kip ese nang ixo ot kö axana bung nang e Kuirinius ixo warkurai sik kingan Siria. ");
INSERT INTO bjk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma a marakörö toxo wanot kirip baling urungan köbo lagunon te idi rua rengrengen osen abo esedi bara tabo geet oxe. ");
INSERT INTO bjk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Me Josep ine a marapun te Dewit. Ma ixo wan tewe bölök kalik ina lagunon Nasaret nang Galili, ma ixo wan urungan Judeia xö lagunon te Dewit nang tobo rengrengen me Betliem. ");
INSERT INTO bjk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ma ixo wan urungan ee rua gegeet a esene idu me Maria ewe nang toxoro tengen bara irabo elolo re ine ma ixoro tienen. ");
INSERT INTO bjk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma nang idu toxo xisixis singan a axana bung ixo ot bara e Maria irabo kip a barok. ");
INSERT INTO bjk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma ixo kip a sisila ne barok, a barok suxurno. Me Maria ixo kain ine ma man ma ixo ömarin ine xö önga laa möxö nien köbo bulmakau, möxösa, kaim pe xönö gölö ringan kö gunon ne ose. ");
INSERT INTO bjk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma abo tene balaure sipsip idi tobo werwere muu abo sipsip pe idi xöbo dömön lörörö xö ina xönö. ");
INSERT INTO bjk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Io, önga angelo xö Orong ixo wösö re idi. Ma a mariris kö Orong ixo sili ömalan idi, me idi toxo buut. ");
INSERT INTO bjk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma lamun a angelo ixo tengen te idi, “Ganim e mum kö binuut. E ot ma atöngösen deek nang irabo öaxanan a marakörö xirip. ");
INSERT INTO bjk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma nixinen te kip ot a Tene Aöro ruso xö lagunon te Dewit, me ine a Mesaia, a Orong. ");
INSERT INTO bjk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Me mum morobo pere a uxileng nang tabo öturunon ina tinenge na. Mum morobo pere lo a barok te kain pi sik ine ma i maru sik kö önga laa möxö nien köbo bulmakau.” ");
INSERT INTO bjk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ma nang iat mon, a oleleng ne angelo meruso xö balana kubu idi toxo wösö arixe ma ina angelo, ma toxo ölet e God bira, ");
INSERT INTO bjk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ii öraxin a esene e God nang ibo xisixis tiso lömö. Ma xö öxöno lagunon, a bala malum irabo wan urungan kö nangadi nang God iri bala deek ke idi.” ");
INSERT INTO bjk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ma nang abo angelo toxo wan kalik idi uruso xö balana kubu, io, abo tene balaure sipsip toxo etöngösen baling ke idi, “Ire ta wan uruso Betliem ma ta pere ina laa nang i ot nang a Orong iri töngösen ire min.” ");
INSERT INTO bjk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Io, idi toxo wan pasaxit lo me idi toxo pere wösöt e Maria me Josep arixe ma barok ewe nang ixo maru sik kö laa möxö nien. ");
INSERT INTO bjk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma nang idi toxo pere ine, idi toxo eselein ina tinenge ulamun a lasa nang abo angelo toxo töngösen idi min ulamun a barok. ");
INSERT INTO bjk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Me idi xirip nang toxo ölangen, idi toxo wuwus kö lasa nang abo tene balaure sipsip toxo töngösen idi min. ");
INSERT INTO bjk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma lamun e Maria ixobo döxömen oxe sik inabo laa xirip, ixobo dödödöm köba ulamun kö balana. ");
INSERT INTO bjk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mabo tene balaure sipsip idi toxo tawuxus, me idi toxo ölet e God ulamun inabo laa xirip nang idi toxo ölangen me idi toxo pere. Ma inabo lalaa i xarnang mon nang abo angelo toxo tengen te idi. ");
INSERT INTO bjk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma xö pitnö ma narun ne bung, idi toxo kuru a lewene aine a barok. Ma toxo tengen ine me Jisas. Ma ina ese nang a angelo ixo araun ta rengrengen ine min nang bang e Maria kaim kö ösaxit texe me ine. ");
INSERT INTO bjk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Io, nang a axana bung ixoro wanot bara tabo pet eörin abo warkurai te Moses bere idu tabo madakdak baling kö wawara xö inabo warkurai, Josep me Maria idu toxo wan me Jisas uruso Jerusalem rua isik ine xö Orong. ");
INSERT INTO bjk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Me idu toxo mamaa rua mumuu xarnang toxo geet kö warkurai xö Orong i bira: “Abo marna barok kirip tabo isik tewe idi urungan kö Orong.” ");
INSERT INTO bjk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Me idu toxo mamaa rua isik a arabaa re idu eöt ma warkurai xö Orong i tengen bira, “Mum morobo erabaa ma nine buno bara nine balus lik.” ");
INSERT INTO bjk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma önga tödi ixobo xisixis singan Jerusalem, a esene e Simion. Ine a önga tene töxödös ma ibo lolotu wösöt a Orong. Me ixobo xixiset ma ina tödi nang e God irabo isik kua ömamanaa abo Israel. Ma Töxödös ne Tanono ixo kis se ine. ");
INSERT INTO bjk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Töxödös ne Tanono ixo osen ine bara irabo arun ta werwere bang a Mesaia xö Orong, ma melamu irabo met. ");
INSERT INTO bjk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Io, a Töxödös ne Tanono ixo silien ine urungan kö gunon ne lotu raxin. Ma a tamana barok ma nago idu toxo kip ölaxa a barok kua wewet sik a magingin urungan te ine eöt ma warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Io, Simion ixo kip lo a barok ma ixo ölet e God arixe ma ina tinenge na: ");
INSERT INTO bjk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“A Orong ke e, na e re örasen a malum. Örö ömaraxen lo e, a tultul te nöngön, ara wan kalik ina to na, ");
INSERT INTO bjk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","möxösa, nine marake iri pere im a lasa nang nöngön u xo pet tua öro e mem. ");
INSERT INTO bjk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nöngön u xo tagur sik ina ineöro na xö wawara xö nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Me ina ineöro a bibio möxö ömaras ewe idi nang kaim bara abo Judeia, me ine irabo isik a mariris köbo Israel, a nangadi re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma tata ma nago re Jisas idu toxo ölangen ina tinenge nang e Simion ixo pet te ine, idu toxo dödödöm oleleng. ");
INSERT INTO bjk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Io, Simion ixo wadöane idiet ma ixo tengen te Maria, a nago xö barok, bira, “Ina barok na, God ixo pere kos ine ulamun abo sunubu mabo tinaru möxö a oleleng ne nangadi mee Israel, ma irabo önga uxileng nang a nangadi tabo pere wuxus, ");
INSERT INTO bjk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","bara a dinödöm möxö oleleng nang i mun sik irabo ot kö malmalan. Ma tapunuk irabo öriip nöngön xarnang a sele ibo kara a kat te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Io, önga propet une, esene e Ana, a balik ke Panuel, me Panuel a marapun te Aser. Ine ixoro une raxin saban, ma ixobo xisixis arixe ma usuono eöt ma pitnö ma ninöng ne awat. ");
INSERT INTO bjk_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma melamu a tödi re ine ixo met, me ine ixo xisixis tataun eöt ma pitnö ma narun ne sangaun ma nit ne awat. Ana i kara wan lie a gunon ne lotu raxin. Ma lamun ixobo ölölö ma ixobo seseseng köbo xaken ma dömön. ");
INSERT INTO bjk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma xö ina bung nang ine bölök ixo wanot lörörö xö barok ma ixo tengen deek kö God. Ma ixo tengen osen ina tinenge ulamun a barok urungan kö nangadi xirip nang te xixiset me God irabo ölanglanga abo nangadi mee Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ma nang e Josep me Maria idu toxo pet kirip abo laa nang a warkurai xö Orong i tengen, idu toxo baling im u Nasaret, a lagunon te idu, niso Galili. ");
INSERT INTO bjk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ma barok ixo taxin kaa ma aine ixo lölös, ma ixo wöwö ma nanase, ma a abalamu xö God ixo kis se ine. ");
INSERT INTO bjk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ma xöbo awat kirip a tata ma nago re ine, idu tobo önan uruso Jerusalem ulamun a Luxa ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma nang e Jisas ixo sangaun ma ninöng ne awat idiet barama toxo wan uruso Jerusalem lamun ina luxa xarnang idi toxobo wewet bie. ");
INSERT INTO bjk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Melamu xö ina nien, a tata ma nago re ine, idu toxo urulo rua binaling urungan kö lagunon, me Jisas ixo kis baling kingan Jerusalem, ma lamun idu kaim kö ösöxö bara ixo kis baling. ");
INSERT INTO bjk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Me idu toxo döxömen bara ine ixo önan arixe ma marakörö, idu toxo wan kö önga bung kudun. Ma melamu idu toxo urulo rua winara siwin ine kaluluonin abo ais mabo marapun te idu. ");
INSERT INTO bjk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma nang kaim idu xö werwere wösöt ine, idu toxo wan baling uruso Jerusalem rua winara rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma melamu xö narun ne bung idu toxo pere lo ine kölöme xö gunon ne lotu raxin, ma ixo kisisik kaluluonin abo tene ausu ma ixo ölangen idi ma ixo ose idi. ");
INSERT INTO bjk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma nangadi xirip nang toxo ölangen ine, idi toxo wuwus kö nanase re ine ma xöbo babalu re ine. ");
INSERT INTO bjk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma nang a tata ma nago re ine toxo pere ine, idu toxo wuwus. Ma nago re ine ixo tengen te ine bira: “Barok ke e, ruasa nöngön u pet e maa bira? A balana e maa me tata i tiip köba me maa me wawara siwin nanin nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Io, ine ixo balu idu bira, “Ruasa mu mo wawara rö e? Mu kobo ösöxö bere e rabo mana xisixis kö gunon kö Tamake?” ");
INSERT INTO bjk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Inexalik kaim idu xö ösöxö xulen a lasa nang ine ixo wöwörö min urungan te idu. ");
INSERT INTO bjk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Io, ine ixo wan arixe me idu urungan baling Nasaret, ma xöbo bung kirip ine ixobo ölangen a tinenge re idu. Ma nago re ine ixobo döxömen dik sik iat inabo lalaa xirip. ");
INSERT INTO bjk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Me Jisas ixo taxin kaa, ma nanase re ine ixo rataxin bölök. Me God arixe ma nangadi toxobo axanan köba rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Xö sangaun ma pitnö ne awat kö kinis ne warkurai re Tiberius, a king taxin mee Rom, nang e Pontias Pailat ixo sisila me Judeia, Erot ixobo kure sik e Galili me tönö re ine e Pilip ixobo kure sik e Iturea me Trakonitis, me Lisanias ixobo kure e Abilene. ");
INSERT INTO bjk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Me Anas me Kaiapas idu toxo taxin ma toxobo sila sik köbo pris kabise. Ma a tinenge re God ixo ot pösöt e Jon, a barok ke Sekaraia, xö xönö tataun. ");
INSERT INTO bjk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ine ixo wan kö boxönö xirip lörörö xö Ari Jordan ma ixo etöngösen bara, “Mum moro kip lo a baptais sa osen bere mum moro dödöm puxus. Me God irabo döxömen taun abo magingin saban te mum.” ");
INSERT INTO bjk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ina na nang toxoro geet kölöme xö ginigeet köbo tinenge re propet Aisaia bira: “A inöno öng i xukup kö xönö tataun, ‘Tagure a nuan möxö Orong, ötöxödös a ngas sö ine. ");
INSERT INTO bjk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Abo marasaa xirip tabo pömös, ma abo puot ma kalala tabo pet eörin. Abo ngas gege irabo töxödös, mabo ngas gargaras irabo madalaan. ");
INSERT INTO bjk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma a nangadi xirip tabo pere a ineöro mere God.’” ");
INSERT INTO bjk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon ixo tengen kö marakörö nang toxo ot bara rö ine ra baptais idi, “Mum abo tene röxröxö! Ewe ixo panak e mum pa ulo rup kalik ina kinadik nang e God i lörörö ra isik? ");
INSERT INTO bjk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mum morobo mana pet abo lalaa nang irabo osen bara mum moxoro dödöm puxus. Me mum iat mum bele urulo rua döxömen bie: ‘Ire te ösöxö bara e Abaram i xarnang a tubuno ire.’ E tengen te mum bara God i öt sik ka öraru abo tubuno e Abaram meringan kinabo wat. ");
INSERT INTO bjk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A matau tuar iang kö unine iaa, mabo iaa xirip nang tekara o abo pasuno deek, tabo tee ösu ma tabo tewe urungan kö könönö ia sösöt.” ");
INSERT INTO bjk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Io, a marakörö toxo ose bara, “Mem marabo pet a sa?” ");
INSERT INTO bjk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon ixo balu idi bira, “A tödi ma nine siot irabo erimine me we nang kawaim, ma ewe nang ma nien irabo pet bölök bie.” ");
INSERT INTO bjk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abo tene kip takis bölök toxo ot tua kip baptais me idi toxo eose, “Tene ausu, mem marabo pet a sa?” ");
INSERT INTO bjk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma ixo tengen te idi, “I deek bara mum morobo kip eöt mon nang te kure bie, ma ganim a lexlexe inabo warkurai.” ");
INSERT INTO bjk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Io, a dauleng ne umri toxo ose ine, “Ma a laa sanene nang mem marabo pet?” Jon ixo balu idi bira, “Ganim a öparara lo a tuluwok kö nangadi ma ganim e mum pua wupuk a nangadi ma tinenge töxö, me mum morobo axanan lamun a xinixun te mum.” ");
INSERT INTO bjk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ma nangadi toxo xixiset lamun a inot kö Mesaia, ma toxo döxömen kö kat te idi bara e Jon gut ine ina Mesaia. ");
INSERT INTO bjk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon ixo balu idi xirip, “E baptais e mum ma ari. Ma lamun önga tödi irabo wanot i taxin köba re e. E kobo töxödös eöt ta walwalas a kililöng kalik a nine sandel te ine. Ine irabo baptais e mum ma Töxödös ne Tanono ma ia sösöt bölök. ");
INSERT INTO bjk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Me ine i tön sik a sawol te ine ra tewe öxaa abo irine wit kö xiki nang irabo paxat tewe abo lewene xalik abo irine. Lamun abo irine wit deek kölömene nang ixo tiip ma i subu, ine irabo iiögun arixin tingan kö öra ne nien te ine. Ma lamun ine irabo tewe rewe abo lewene irine wit urungan kölöme xö ia sösöt nang idi tekebeöt ta pus ömet.” ");
INSERT INTO bjk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma arixe ma oleleng ne tinenge xabise, Jon ixo öxaxat a nangadi ma ixo palas tinenge ma tinenge deek urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Me Jon ixo köö e Erot a tödi raxin mee Galili ulamun e Erodias a une re tönö ine mabo lalaa saban kirip nang ine ixo pet. ");
INSERT INTO bjk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma nang e Jon ixo pet bira, Erot ixo pet a laa saban tunon. Ixo baxut e Jon kö gunon ne aömokorot. ");
INSERT INTO bjk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nang Jon ixo baptais abo nangadi, Jisas ixo kip lo bölök a baptais. Ma nang ixo seseseng, a balana kubu ixo tamasawang ");
INSERT INTO bjk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma a Töxödös ne Tanono ixo wan su lömö re ine, ma ixo wawara bara ixo kip lo a aine xarnang a buno. Io, a inöno öng ixo ot meruso xö balana kubu ma ixo tenge bira, “Nöngön ano Barok ke e. E mamaa lamun me e axanan köba re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Me Jisas ine ixo öt ma narun ne sangaun ne awat nang ine ixo urulo a tinörön te ine. A dödöxömen kö marakörö bara ine a barok ke Josep, a barok ke Eli, ");
INSERT INTO bjk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a barok ke Matat, a barok ke Lewi, a barok ke Melki, a barok ke Janai, a barok ke Josep, ");
INSERT INTO bjk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","a barok ke Matatias, a barok ke Amos, a barok ke Nahum, a barok ke Esli, a barok ke Nagai, ");
INSERT INTO bjk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a barok ke Maat, a barok ke Matatias, a barok ke Semein, a barok ke Josek, a barok ke Joda, ");
INSERT INTO bjk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a barok ke Joanan, a barok ke Resa, a barok ke Serubabel, a barok ke Sealtiel, a barok ke Neri, ");
INSERT INTO bjk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","a barok ke Melki, a barok ke Adi, a barok ke Kosam, a barok ke Elmadam, a barok ke Er, ");
INSERT INTO bjk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","a barok ke Josua, a barok ke Elieser, a barok ke Jorim, a barok ke Matat, a barok ke Lewi, ");
INSERT INTO bjk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a barok ke Simion, a barok ke Juda, a barok ke Josep, a barok ke Jonam, a barok ke Eliakim, ");
INSERT INTO bjk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a barok ke Melea, a barok ke Mena, a barok ke Matata, a barok ke Natan, a barok ke Dewit, ");
INSERT INTO bjk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a barok ke Jesi, a barok ke Obet, a barok ke Boas, a barok ke Salmon, a barok ke Nason, ");
INSERT INTO bjk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a barok ke Aminadab, a barok ke Ram, a barok ke Esron, a barok ke Peres, a barok ke Juda, ");
INSERT INTO bjk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a barok ke Jekop, a barok ke Aisak, a barok ke Abaram, a barok ke Tera, a barok ke Naor, ");
INSERT INTO bjk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a barok ke Seruk, a barok ke Reu, a barok ke Pelek, a barok ke Eber, a barok ke Sela, ");
INSERT INTO bjk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a barok ke Kainan, a barok ke Arpaxat, a barok ke Sem, a barok ke Noa, a barok ke Lamex, ");
INSERT INTO bjk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a barok ke Metusela, a barok ke Enox, a barok ke Jaret, a barok ke Maxalalel, a barok ke Kenan, ");
INSERT INTO bjk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a barok ke Enos, a barok ke Set, a barok ke Adam, a barok ke God. ");
INSERT INTO bjk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas ixo wöwö sik ma Töxödös ne Tanono ma ixo wan baling meringan kö Ari Jordan ma Tanono ixo lamus lo ine urungan kö xönö tataun. ");
INSERT INTO bjk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Me Satan ixo könönöin ine ringan kö nit ne sangaun ne bung. Kaim ine xo enen te laa xö inabo bung niang, ma melamu ine ixo irilöng. ");
INSERT INTO bjk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Io, Satan ixo tengen te ine, “Nang bara nöngön ano Barok ke God, örö tengen kö ina wat na rua tawuxus urungan kö beret.” ");
INSERT INTO bjk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas ixo tengen, “Abo tinenge re God toxoro geet i tengen bira: ‘A nangadi tokobo to xalik mon kö beret’” ");
INSERT INTO bjk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Io, Satan ixo lamus öxaa ine xö puot ma nang iat mon ixo osen ine mabo kantri kirip möxö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma ixo tengen te ine, “E rabo tabaa nöngön ma inabo kinis ne warkurai arixe mabo mariris se idi, möxösa, idi re e, me e eöt tua isik kere öng nang bara e mamaa. ");
INSERT INTO bjk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Io, nang bara örobo lotu wösöt e, ina na xirip irabo re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas ixo tengen, “Abo tinenge re God toxoro geet i tengen bira, ‘Mum moro lotu xö Orong, a God te mum, me ine xalik mon mum morobo ii ölik e mum pe ine.’” ");
INSERT INTO bjk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Io, Satan ixo lamus lo ine urungan Jerusalem, ma ixo uru e Jisas lömö saxit kö öxöno ngusuno möxö gunon lotu raxin. Ma ixo tengen, “Nang bara ano Barok kö God nöngön, örobo kos su mera, ");
INSERT INTO bjk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","möxösa, abo tinenge re God toxo geet i tengen bira: ‘Irabo isik a tinenge lölös urungan köbo angelo re ine ulamun nöngön rua balaure ödeek nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Idi tabo tön uru nöngön mabo limine idi, bara ökorobo segen parange abo sisixine xexem köbo warawat.’” ");
INSERT INTO bjk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas ixo tengen, “Abo tinenge re God toxoro geet i tengen bira, ‘Ganim bara mum mo könönöin a Orong, a God te mum.’” ");
INSERT INTO bjk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nang e Satan ixo kawam kirip pua könönöin e Jisas, ixo wan talu bang e Jisas ot kö önga axana bung kabise. ");
INSERT INTO bjk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisas ixo wan baling u Galili ma lölös kö Tanono, ma a tinenge ulamun ine ixo wan esexere xöbo lagunon. ");
INSERT INTO bjk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ixo usu a nangadi kölöme xöbo gunon ne sineseng ke idi, me idi xirip toxo ölet ine. ");
INSERT INTO bjk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ixo wan u Nasaret, lagunon nang ine ixo taxin kaa e, ma xö Sabat ine ixo laxa xö gunon ne sineseng xarnang ine ixobo wewet bie. Ma ixo tuu kaa rua xinoxos. ");
INSERT INTO bjk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Io, toxo tabaa ine ma axana ginigeet te propet Aisaia. Ixo palase ine ma ixo pere lo a xönö nang a ginigeet i tengen bira: ");
INSERT INTO bjk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A Tanono möxö Orong i kis kölöme re e, möxösa, ine iri pere kos lo e rua atöngösen ma tinenge deek urungan kö duöng maris. Ine iri uguran e rua atöngösen maras sö idi nang tobo kut dik sik idi, bara tabo langlanga, me idi nang a pulo, tabo wawara baling. Me ine iri uguran e rua ölanglanga rewese idi nang te kis kö ene abo tiip, ");
INSERT INTO bjk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ma rua atöngösen maras bara a axana bung ne rorop kö Orong iri wanot.” ");
INSERT INTO bjk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Io, ine ixo pulin öbaling ina axana ginigeet, ixo isik öbaling urungan kö tene balbalaure möxö ina axana ginigeet. Io, ixo kis. A marana nangadi xirip kölöme xö ina gunon ne sineseng toxo wawara xalik ke ine. ");
INSERT INTO bjk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Me ine ixo urulo ma tinenge rö idi bira, “Nixinen ina ginigeet meruso re God iri wanot turunon kö ölöngö re mum.” ");
INSERT INTO bjk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Idi xirip toxo tengen bara ine a tödi deek me idi toxo wuwus köbo tinenge deek nang ixo wan su möxö ngusuno. Idi toxo eose, “Ire tokobo maras bere ine mon a barok suxurno re Josep.” ");
INSERT INTO bjk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Me Jisas ixo tengen te idi, “E ösöxö sik bara mum morobo tengen abo tinenge ne rorop ura rö e: ‘Tene aule, ölanglanga öbaling nöngön. Pet baling ke laa ra xö lagunon turunon te nöngön nang mem moxo ölangen bara u xo pet tö Kaprenaum.’” ");
INSERT INTO bjk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma ixo tengen, “Turunon saxit, kaim pe propet te ömaraxen lo ine iat kölöme xö lagunon iat te ine. ");
INSERT INTO bjk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E ömaras e mum bara oleleng ne möxösö ra Israel kö axana bung ke Elaija, nang a balana kubu ixo tamabaxut kö narun ne awat ma subana ma kaim arixe a nien kö ina xönö xirip Israel. ");
INSERT INTO bjk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Inexalik God kaim kö uguran e Elaija urungan kö öng mere idi abo möxösö, inexalik ixo uguran ine urungan kö önga une möxösö kölöme Sarepat kölöme xö xönö Saidon. ");
INSERT INTO bjk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma xö axana bung kö propet Elisa a oleleng ma lepra kölöme Israel. Inexalik kaim kö ölanglanga re öng mere idi. Naaman kalik mon, a Siria.” ");
INSERT INTO bjk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nangadi xirip kölöme xö gunon ne sineseng toxo laie nang idi toxo ölangen ina na. ");
INSERT INTO bjk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Idi toxo taru ma toxo uguran tewe ine xalik ina lagunon ma toxo lamus lo ine urungan kö öxöno maii nang toxo pet ina lagunon, bara rua tewe ösu ine xö kalala. ");
INSERT INTO bjk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lamun ine ixo wan kaluluonin a marakörö ma ixo wan. ");
INSERT INTO bjk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Io, ixo wan su Kaprenaum, a lagunon kölöme Galili. Ma xö Sabat ixo urulo a usu a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Idi toxo wuwus kö ausu rine, möxösa, a tinenge re ine a lak lölös. ");
INSERT INTO bjk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kölöme xö gunon ne sineseng, önga tödi a tano saban ixo kis se ine. Ma ixo kup lömö saxit, ");
INSERT INTO bjk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nang! Jisas mee Nasaret, u mamaa ruasa xalik e mem? U wanot ta ögarin esexerein e mem? E ösöxö sik nöngön, bere nöngön a Öng Ewe Nang a lak Madakdak meriso re God!” ");
INSERT INTO bjk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Me Jisas ixo köö ina tano saban, ma ixo tengen, “Örö ödödö, ma wan su xalik ine.” A tano saban ixo tewe ösu ina tödi xö pu mesila re idi xirip ma ixo wan su xalik ine, inexalik kaim kö ögarin ine. ");
INSERT INTO bjk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A nangadi toxo wuwus saban, ma toxo tengen öbaling iat te idi bira, “A mangana ausu sanene ia? Ine ibo isik warkurai ma tinenge lölös urungan köbo tano saban me idi tobo önan su!” ");
INSERT INTO bjk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma a atöngösen ulamun e Jisas ixo wan esexere xöbo lagunon kirip kö ina xönö. ");
INSERT INTO bjk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas ixo wan kalik a gunon ne sineseng ma ixo wan urungan kö gunon te Saimon. Io, a taön te Saimon ixo sam malao lölös, me idi toxo seng e Jisas sua rorop ine. ");
INSERT INTO bjk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Io, ixo tun lexe ine ma ixo köö a malao, ma a lelewi ixo kawam kalik ine. Ma saxit mon ixo taru kaa ma ixo urulo rua tabaa idi ma nien. ");
INSERT INTO bjk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nang a xaken ixo dödöröng, a nangadi toxo kip ot urungan te Jisas abo duöng nang mabo mangana miniset ma ixo bulbulus a limine lömö xö öngöng ma ixo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma nang abo tano saban toxo wan su xalik a nangadi toxo xukup bira, “Nöngön a Barok kö God!” Inexalik, ine ixo köö idi, ma kaim kö ömaraxen idi rua tinenge, möxösa, idi toxoro ösöxö sik bara ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Xö puxu bubung Jisas ixo wan lo urungan kö xönö tataun. Ma nangadi toxo wawara rö ine ma nang idi toxo ot kö xönö nang ine e, idi toxo mamaa bara ine i bele önan lie idi. ");
INSERT INTO bjk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma lamun ixo tengen, “E rabo mana palas tinenge ma tinenge deek kö kingdom kö God urungan köbo lagunon kabise, möxösa, Tata ixo tile e ura ulamun ina na.” ");
INSERT INTO bjk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma ixo walwalas tinenge kölöme xöbo gunon ne sineseng kingan kö xönö mee Judeia. ");
INSERT INTO bjk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A önga bung e Jisas ixo tuu sik kö lawana tu Genesaret mabo nangadi toxo tuu wi sik ine ma toxo ölangen a tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma nang e Jisas ixo wawara ixo pere a nine mön ixo malaa sik kuso löxön, a mön kö nangadi möxö kip inan. Ma lamun idi toxoro wan kalik inabo mön, me idi toxo gisgis abo eben te idi. ");
INSERT INTO bjk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Io, Jisas ixo kaa xö önga mön, a mön te Saimon. Ma ixo tengen te Saimon bara ira sumen ulik kalik a löxön. Io, ixo kis kaa xö mön ma ixo usu a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma nang ixo wöwörö xirip, ixo tengen te Saimon, “Örö kaulusen ulik urungan kö dödöngö. Ma örö tewe ösu a eben ma örö kip inan.” ");
INSERT INTO bjk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Me Saimon ixo balu, “Tödi raxin, mem me rörön köba xö ina dömön na. Me mem kobola öxönöm pe laa. Ma lamun e rabo bulus ösu a eben, möxösa, nöngön u tengen bira.” ");
INSERT INTO bjk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma nang idi toxo pet bie, idi toxo kip a oleleng ne inan. Mabo eben te idi ixo urulo ra tamadidi. ");
INSERT INTO bjk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Io, idi toxo kuwe abo ais se idi nang kö önga mön kabise ra nuanot ta rorop idi. Me idi toxo wanot ma toxo utuxo a nine mön. Ma toxo wöwö ma toxo urulo rua riririi. ");
INSERT INTO bjk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma nang e Saimon Pita ixo pere ina na, ixo subu xö xexene Jisas ma ixo tengen, “Wan kalik e, Orong. E a tödi saban!” ");
INSERT INTO bjk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ixo tengen bira, möxösa, ine ma abo ais se ine toxo wuwus kö ina inan nang idi toxo kip. ");
INSERT INTO bjk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma nine ais se Saimon, e Jems me Jon, a nine barok ke Sebedi, idu toxo wuwus bölök. Io, Jisas ixo tengen te Saimon, “U bele buut. Urulo nixinen nöngön örobo kip a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Io, idi toxo ösö löxön, ma toxo ganim sik abo lalaa xirip ma toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma nang e Jisas ixo wan urungan kö önga lagunon, a önga tödi ixo wanot ewe nang a miniset lepra ixo kawönö ine. Ma nang ixo pere e Jisas ixo subu ma marana xö pu ma ixo seng ine, “Orong, nang bara u mamaa, nöngön u eöt ta öxawam a miniset lepra xalik e bara e ra madakdak.” ");
INSERT INTO bjk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Me Jisas ixo sasanga ma limine ma ixo tön ine. Ma ixo tengen te ine, “E mamaa. Örö deek.” Ma saxit iat mon, ina miniset lepra ixo wan kalik ine. ");
INSERT INTO bjk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Io, Jisas ixo panak ine, “Ganim bara u tengen osen kere öng. Inexalik örö wan ma örö osen nöngön kö pris ma örö isik abo arabaa ne söngsöngöt eöt ma warkurai te Moses bara örobo deek baling. Ma irabo xarnang a atöngösen maras sö idi bara a turunon bere u xoro langlanga.” ");
INSERT INTO bjk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Inexalik a atöngösen ulamun e Jisas ixo wan esexere xö boxönö xirip, io, a marakörö toxo wanot tua ölangen ine ma bara irabo ölanglanga abo miniset te idi. ");
INSERT INTO bjk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Inexalik uleng ne bung Jisas ixobo önan kalik a marakörö ma ixobo önan urungan kö boxönö nang kaim a nangadi ma ixobo seseseng. ");
INSERT INTO bjk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma önga bung nang e Jisas ixo usu abo Parasi ma abo tene ausu möxöbo warkurai te Moses, ewe me idi nang toxo wanot möxöbo lagunon kirip Galili ma meringan Judeia ma Jerusalem, ma toxo xisixis singan ee. Ma a lölös kö Orong ixo kawönö ine ma ixo ölanglanga abo miniset. ");
INSERT INTO bjk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","A uleng ne duöng toxo ot ma toxo xikip nanin a pengpeng kö ben ma toxo kip ölaxa ine xö gunon tua ömarin ine mesila re Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma nang idi toxo wawara siwin te ngas sua nuan laxa, möxösa, a marakörö toxo oleleng, idi toxo kaa uruso lömö, toxo pök a öxöno gunon, ma toxo ösölöng ösu ina pengpeng arixe ma minaru re ine kaluluonin a marakörö urungan te Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nang e Jisas ixo pere a nunu ridi, ixo tengen, “Töke, na iat mon a magingin saban te nöngön iri kawam.” ");
INSERT INTO bjk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abo Parasi mabo tene ausu möxöbo warkurai te Moses toxo döxömen suxume re idi iat bira, “Ewe ina tödi na i tengen ögarin e God? Kaim pe öng i öt ta kip tewe a magingin saban, nexalik bara e God kalik mon.” ");
INSERT INTO bjk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma lamun e Jisas ixo ösöxö xulen a lasa nang idi toxo dödöxömen, ma ixo eose, “Rösa mum mo dödöxömen inabo lalaa na xö kat te mum? ");
INSERT INTO bjk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nangang sa re idu i malus sa rengrengen? I malus se e ra tengen bira, ‘A magingin saban te nöngön iri kawam’? Bara i malus se e ra tengen, ‘Tuu lömö, ma örö wan’? ");
INSERT INTO bjk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma lamun eka osen e mum bara a Barok kö Tödi ine ma lölös kö öxöno lagunon tua irewese a magingin saban.” Ma ixo tengen kö pengpeng, “E tengen te nöngön, tuu lömö ma örö kip lo a ben te nöngön ma örö wan urungan kö ngasiem.” ");
INSERT INTO bjk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma saxit mon ixo taru xö wawara re idi ma ixo rarik lo a minaru re ine ma ixo ölet God nang ixo önan urungan kö gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Io, a nangadi xirip toxo wuwus ma toxo ölet e God. Idi toxo ii e God ma binuut ma toxo tengen, “Nixinen ire tere pere a lalaa deek ne auwuwus.” ");
INSERT INTO bjk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Melamu xö ina na, Jisas ixo wan su ma ixo pere a tene kip takis, a esene e Lewi, ixo kisisik kö xönö re ine möxö kip takis. Me Jisas ixo tengen te ine, “Muu e!” ");
INSERT INTO bjk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Me Lewi ixo tuu lömö, ma ixo wan lie abo lalaa xirip ma ixo muu ine. ");
INSERT INTO bjk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Io, Lewi ixo pet a nien taxin ulamun e Jisas kö gunon tine, ma a oleleng saxit ne tene kip takis ma dauleng kabise toxo aan arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ma lamun abo Parasi ma abo tene ausu möxöbo warkurai te Moses ewe nang a Parasi bölök idi, toxo wöwörö oleleng urungan köbo bak ne ausu re ine, “Ruasa mum mo aan ma mo ininim arixe mabo tene kip takis mabo ‘duöng saban’?” ");
INSERT INTO bjk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas ixo balu idi, “A nangadi nang kaim a miniset, idi tekara sasaxan ulamun a tene aule, nexalik idi xalik nang a lak miniset. ");
INSERT INTO bjk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","E kobo ot ta xukuwe abo tene töxödös. Kawaim, e ot ta xukuwe a nangadi saban tua dödöm puxus.” ");
INSERT INTO bjk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Idi toxo tengen te ine, “Abo bak ne ausu re Jon idi tobo ölölö ma tobo seseseng. Ma abo bak ne ausu möxöbo Parasi idi bölök tobo wewet bie. Ma lamun abo bak ne ausu re nöngön idi te aan ma te ininim.” ");
INSERT INTO bjk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas ixo balu, “I eöt bara örö pet abo osee möxö tödi alolo maxat, tabo ölölö nang bara ine angen arixe midi? Kaim. ");
INSERT INTO bjk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma lamun a axana bung irabo wanot nang tabo kip lo ina alolo maxat kalik idi. Ma xinabo bung nang, idi tabo ölölö im.” ");
INSERT INTO bjk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma ixo töngösen idi ma ina tinenge öwuo: “Kaim pe öng ibo dididii rewe re xönö man maxat ma ibo söxsöxö xö man maut. Nang bara i pet biringan, ine irabo ögarin ina xönö man maxat, ma xönö man i karabo eöt ma ina xönö man maut. ");
INSERT INTO bjk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma kaim pe öng ibo linglinge a wain maxat nang i kobola ebobot bang kölöme xö önga laa möxö kuluwo ari nang toxo pet ma lewene meme maut i lelet sik. Nang bara i pet, a wain maxat irabo ebobot kaa ma irabo pörök a lewene meme. A wain irabo su xirip ma ina lewene meme irabo saban. ");
INSERT INTO bjk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kaim. A wain maxat tabo mana tii urungan kö lewene meme maxat. ");
INSERT INTO bjk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma kaim pe öng nang iri inim a wain maut ibo mamaa lamun a wain maxat, möxösa, ine ibo tengen, ‘A wain maut a lak deek.’” ");
INSERT INTO bjk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Io, xö önga Sabat, Jisas ixo wan kaluluonin a komo wit, mabo bak ne ausu rine toxo pit köröp lo a uleng ne xurxurno wit, ma toxo gigise mabo limine idi ma toxo en. ");
INSERT INTO bjk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma dauleng möxöbo Parasi toxo eose bira, “Ruasa mum mo pet bira? Mum kobo mumuu a warkurai möxö bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Io, Jisas ixo balu idi, “Mum moxoro kos abo laa mesila nang e Dewit ixo pet nang ine ixo irilöng arixe ma abo duöng nang toxo wan arixe mine. ");
INSERT INTO bjk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","E Dewit ixo wan laxa xö gunon te God, ma ixo kip lo ina beret nang tobo tabaa e God min, ixo en ine. Mabo warkurai te Moses i tengen bara abo pris kalik tobo enen ina beret na. Ma ixo tabaa bölök abo duöng nang toxo wan arixe me ine.” ");
INSERT INTO bjk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Io, Jisas ixo tengen te idi, “A Barok kö Tödi i kure bölök a bung Sabat.” ");
INSERT INTO bjk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Xö önga Sabat kabise Jisas ixo wan laxa kölöme xö gunon ne sineseng möxöbo Judeia ma ixo usu a nangadi, ma önga tödi ixo xisixis singan a lime tuun te ine ixo met. ");
INSERT INTO bjk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abo Parasi mabo tene ausu möxöbo warkurai te Moses toxo werwere ine nang bara irabo ölanglanga a tödi miniset kö Sabat bara kaim, io, niang ke idi ra wupuk ine. ");
INSERT INTO bjk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma lamun Jisas ixo ösöxö xulen abo dinödöm pe idi ma ixo tengen kö tödi niang a lime met, “Taru kaa ma örö tuu lömö mesila xö nangadi xirip.” Io, ixo taru kaa ma ixo tuu sik. ");
INSERT INTO bjk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Io, Jisas ixo tengen te idi, “E ose e mum, a sa xö warkurai te Moses i tengen bara i töxödös bara tabo pet kö bung Sabat? I deek sik ka rorop bara rua wewet a tinörön saban, ma rua öro re öng bara rua ögarin esexerein ine?” ");
INSERT INTO bjk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas ixo wawara nana re idi xirip, ma ixo tengen kö tödi, “Sasanga kaa ma limem.” Ine ixo pet bie, ma a limine ixo deek baling. ");
INSERT INTO bjk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inexalik idi toxo laie ma toxo wöwörö nana iat te idi bara tabo pet bule re Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Io, xö ina axana bung nang e Jisas ixo wan lo ma ixo kaa uruso lömö xö maii rua sineseng, ma xö ina dömön ixo seseseng uruso re God. ");
INSERT INTO bjk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ma nang ixo puxu, ine ixo kuwe lo abo bak ne ausu re ine urungan te ine ma ixo pere kos lo a sangaun ma ninöng mere idi, ma ixo tengen idi mabo ‘aposol’: ");
INSERT INTO bjk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon, ewe nang e Jisas ixo tengen ine me Pita, a tönö rine e Endru, Jems, Jon, Pilip, Batolomiu, ");
INSERT INTO bjk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Jems a barok ke Alpius, Saimon nang toxo tengen bara ine ina Silot, ");
INSERT INTO bjk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas a barok ke Jems, me e Judas Iskariot, a tödi nang ixo isik tewe e Jisas kö limine nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisas ixo su arixe me idi ma ixo tuu ringan kö xönö malabuo. A oleleng ne bak ne ausu re ine arixe ma marakörö raxin saxit idi toxo ot meruso xöbo lagunon Judeia, meringan Jerusalem, ma meringan Tair me Saidon kö gegene rasi. ");
INSERT INTO bjk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Idi ewe nang toxo ot tua ölangen ine ma bara irabo ölanglanga idi xalik abo miniset. Idi nang a tano saban ibo uban idi, toxo deek baling. ");
INSERT INTO bjk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma a marakörö toxo mamaa bara idi xirip tabo sigi ine, möxösa, a lölös ixo önan kalik ine ma ixo ölanglanga idi xirip. ");
INSERT INTO bjk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ma ixo pere abo bak ne ausu re ine ma ixo tengen: “Irabo deek kö mum ewe e mum nang mo maris, möxösa, mum morobo laxa xö kingdom kö God. ");
INSERT INTO bjk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Irabo deek kö mum ewe nang mum mo irilöng nixinen, möxösa, mum morobo masii. Irabo deek kö mum ewe nang mum mo gee nixinen, möxösa, mum morobo nöngnöngön. ");
INSERT INTO bjk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Irabo deek kö mum nang bara nangadi te melentexin e mum, bara te öngus kalik e mum ma te tengen ögarin e mum bara idi te tengen ösu a esene mum bara mum abo tene sasaban, möxösa, mum bo mumuu a Barok kö Tödi. ");
INSERT INTO bjk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ma xö ina axana bung morobo axanan ma morobo kos ma axanan, möxösa, a xinuxun taxin te mum nangen nuso xö watmaep, möxösa, abo tubuno idi toxobo wewet ögarin abo propet bie. ");
INSERT INTO bjk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Inexalik, maris se mum abo orong, möxösa, mum moxoro uruoxe abo lalaa nang i öaxanan e mum. ");
INSERT INTO bjk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Maris se mum nang mo masii sik nixinen, möxösa, mum morobo irilöng. Maris se mum nang mo nöngnöngön nixinen, möxösa, mum morobo tawunuk me mum morobo gee. ");
INSERT INTO bjk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Maris se mum nang bara nangadi xirip te ii öraxin e mum, möxösa, abo tubudi toxobo wewet bie xöbo propet. ");
INSERT INTO bjk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma lamun e tengen te mum ewe nang i ölangen e: Mum morobo mana mamaa lamun abo iuo re mum, ma morobo pet a tatalien deek ke ewe me idi nang te melentexin e mum, ");
INSERT INTO bjk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mum morobo mana seseng ke God irabo wadöane idi nang te seng e God bara irabo ögarin e mum, me mum morobo seseng kewe midi nang te pet a sasaban te mum. ");
INSERT INTO bjk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Niang bara re öng i wasa nöngön kö wales se nöngön, tawuxus tabaa ine ma önga lawa xabise bölök. Nang bara re öng i kip lo a man te nöngön, u bele panak ine rua xikip lo a siot te nöngön bölök. ");
INSERT INTO bjk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma nang bara re öng i seng nöngön mere laa, örobo mana tabaa ine. Nang bara re öng i kip lo re lasanene re nöngön, u bele seseng puxus. ");
INSERT INTO bjk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mum morobo pet kö nangadi xabise xarnang e mum mo mamaa lamun idi tabo pet te mum. ");
INSERT INTO bjk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nang bara mum mo mamaa lamun ewe midi niang te mamaa lamun e mum, kaim pe öng irabo tengen bara e mum mo pet a dedeek. Inexalik abo tene saban bölök idi tabo mamaa lamun a nangadi nang tobo mamaa lamun idi. ");
INSERT INTO bjk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma nang bara mum mo pet a tatalien deek kö nangadi nang te pet a tatalien deek ke mum, kaim pe öng irabo tengen bere mum mo pet te laa deek. Turunon saxit, abo tene saban idi bölök tobo wewet bie. ");
INSERT INTO bjk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nang bara mum mo öbala sik abo lalaa nang a öng i seng e mum, möxösa, e mum mo döxömen bara irabo balu wuxus, io, takarabo tengen bara mum moro pet a dedeek. Turunon saxit, abo tene saban idi bölök tobo öbala sik abo laa xöbo tene saban kabise lamun idi tabo kip puxus eöt ma nang toxo öbala sik. ");
INSERT INTO bjk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Inexalik mum morobo mana mamaa lamun abo iuo re mum, me mum morobo pet a tatalien deek urungan te idi. Mum morobo tabaa idi, me mum korobo mamaa rö idi ra babalu öbaling. Nang bara mum morobo pet bie, a xinixun te mum irabo taxin me mum abo barok ke God lömö saxit, möxösa, ine iat i pet a tatalien deek kö nangadi saban niang idi te pere öbulubun a rorop pe ine. ");
INSERT INTO bjk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mum morobo marase a nangadi xarnang e Tata re mum ibo marase idi. ");
INSERT INTO bjk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ganim e mum pa kure abo mangana magingin kö öng, ma ganim e mum pa kure a öng bara i pet a saban, xalik e God irabo kure e mum bölök bira. Mum morobo mana döxömen taun abo tatalien saban nang te pet te mum, me God irabo döxömen taun a magingin saban te mum. ");
INSERT INTO bjk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mum morobo mana erabaa, me God irabo tabaa e mum. Ma arabaa re mum i karabo ot köt ma irabo saxit a mamaa re mum, ma irabo öwöwö e mum. God irabo pet bölök ke mum xarnang mum mo pet kö nangadi xabise.” ");
INSERT INTO bjk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas ixo töngösen idi bölök ma ina tinenge öwuo na: “Önga pulo i eöt tua silien a önga pulo xabise? Kaim. Idu xirip tabo subu laxa xö mara. ");
INSERT INTO bjk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Re bak ne ausu i kobo lömö sik kö tene ausu re ine, nexalik bara ewe nang i eusu deek irabo xarnang a tene ausu re ine. ");
INSERT INTO bjk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ruasa nöngön u pere abo perne iaa kölöme xö marana e töm ma u kobo döxömen lo im ina pönö iaa kölöme xö marana e nöngön iat? ");
INSERT INTO bjk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nöngön u bele tengen urungan kö töm bara, ‘Tönö, e rabo kip tewe a perne iaa xö maram.’ Nöngön ökorobo pet bie, möxösa, nöngön iat u kobo pere a pönö iaa xö maram. Nöngön nang u bo röxröxö mon bara nöngön a lak deek, örö luok tewe bang ina pönö iaa xö maram iat, melamu nöngön örobo wawara deek kua xikip tewe abo perne iaa xö marana e töm. ");
INSERT INTO bjk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kaim pe iaa deek ibo oo a pasuno saban, ma önga iaa saban i kebeöt tua o a pasuno iaa deek. ");
INSERT INTO bjk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tabo perexulen abo uno iaa öngöng kö inone idi. Mum kara ösöxö rua kip pöxö xö pirixö gargaras. Me mum kara ösöxö ra dik gamat kalik a iaa gargaras. ");
INSERT INTO bjk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A tödi deek ibo isik ot a lalaa deek nang i wöwö sik kö balana ine, ma a tödi saban ibo isik ot a lalaa saban nang i wöwö sik kö balana ine, möxösa, a tödi ibo tengen ösu abo lalaa i wöwö sik kö balana. ");
INSERT INTO bjk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ruasa mum mo tengen e me, ‘Orong, Orong,’ me mum kobo pet a lasa nang e tengen? ");
INSERT INTO bjk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","E rabo osen e mum ma tatalien te ine ewe nang i wanot ura re e ma i ölangen a tinenge re e ma i pet muu xö to rine. ");
INSERT INTO bjk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I xarnang önga tödi i uru a gunon, ewe nang i kin abo mara ma i pömös ösu abo xösöng kö warawat. Ma nang bara i ari lölös, irabo sumen ina gunon ma lamun i kebeöt ta ömagi ine, möxösa, toxo uru ödeek. ");
INSERT INTO bjk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma lamun ewenene a öng nang i ölangen a tinenge re e ma i kara pet muu, i öt ma tödi nang ixo pömös ögölgölö mon a gunon. Ma nang bara a ari lölös i sumen ina gunon irabo subu ma irabo saban esexere.” ");
INSERT INTO bjk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nang e Jisas ixo kawam kö rengrengen ina niang urungan kö ölöngö xö nangadi, ixo laxa Kaprenaum. ");
INSERT INTO bjk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ringan ee a tene tinörön kö önga umri raxin möxöbo duöng inarse. Ma ina tene tinörön ewe nang a tödi raxin te ine ibo döxömen öraxin, ixo meset ma ixo lörörö rua minet. ");
INSERT INTO bjk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A umri raxin ixo ölangen ulamun e Jisas ma ixo tile a uleng ne sisila möxöbo Judeia urungan te ine rua seseng ine rua nuan ta ölanglanga a tene tinörön te ine. ");
INSERT INTO bjk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nang idi toxo ot pösöt e Jisas, idi toxo seng marmarisin ine, “Ma i eöt bara örö top ina tödi na, ");
INSERT INTO bjk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","möxösa, ine ibo mamaa lamun ire abo Judeia ma iri pet a gunon ne sineseng ke mem.” ");
INSERT INTO bjk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Io, e Jisas ixo wan arixe me idi. Kaim ine xo palaa xalik a gunon, nang ina umri raxin ixo uguran abo ais sua rengrengen a tinenge re ine bira, “Orong, u bele öxadik nöngön, möxösa, e kobo tödi deek köba bara örobo wan laxa xö gunon te e. ");
INSERT INTO bjk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Möxösa lamun ina na, e kobo döxömen bara i töxödös bara arabo wan urungan te nöngön. Inexalik bara örö tengen a tinenge re nöngön, ma ina tene tinörön te e irabo langlanga. ");
INSERT INTO bjk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","E tengen bira, möxösa, e bölök e kisisik kö ene warkurai, ma abo umri bölök te kisisik kö ene e. Me e bo tengen kö öng, ‘Wan’, io, ibo wan. Me e bo tengen kö öng niang, ‘Miang’, ma ibo wanot. Me e bo tengen kö tene tinörön te e, ‘Örö pet a na’, ma ibo pet bie.” ");
INSERT INTO bjk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas ixo wuwus saban te ine nang ixo ölangen ina na, ma ixo tawuxus urungan kö marakörö nang toxo mumuu ine ma ixo tengen, “E tengen te mum, e kala parasiwin te nangadi mee Israel iat ma mangana nunu raxin bira.” ");
INSERT INTO bjk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Io, abo duöng ewe nang toxo tile idi, toxo tawuxus baling urungan kö gunon ma toxo pere wösöt a tene tinörön ixoro deek. ");
INSERT INTO bjk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Melamu mon, Jisas ixo wan urungan kö önga lagunon tobo rengrengen mee Nain, mabo bak ne ausu re ine ma a marakörö raxin toxo wan arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nang ixo lörörö xö maranangas möxö lagunon, dauleng toxo xikip ösu a minet. Ma ina minet ine a barok kas kö nago re ine, me ine a möxösö. Ma a marakörö raxin möxö ina lagunon toxo arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nang a Orong ixo pere ina une ixo balamu ine kölöme xö kat te ine ma ixo tengen, “U bele gegee.” ");
INSERT INTO bjk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Io, ixo wan pösöt ina sesebe nang a tödi minet ixo maru sik könan ma ixo sigi. Me idi nang toxo xikip ine toxo tuu ödödö. Ine ixo tengen, “Tödi maxat, e tengen te nöngön, örö taru kaa!” ");
INSERT INTO bjk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma tödi minet ixo kis kaa ma ixo urulo rua tinenge, me Jisas ixo isik öbaling ine urungan kö nago re ine. ");
INSERT INTO bjk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Idi toxo buut ma toxo dödöm oleleng ma toxo ölet e God. Idi toxo rengrengen bira, “A propet taxin iri ot wösö kaluluonin ire. God iri wanot tua rorop a nangadi re ine.” ");
INSERT INTO bjk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma ina tinenge maras ulamun e Jisas ixo wan esexere kölöme Judeia ma abo xönö lörörö. ");
INSERT INTO bjk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Abo bak ne ausu re Jon toxo töngösen ine ulamun inabo lalaa na. Ma ixo kuwe lo a ninöng mere idi. ");
INSERT INTO bjk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma ixo tile idu urungan kö Orong bara idu tabo eose bira, “E nöngön mon ina tödi nang mem me xixiset bara irabo wanot, bere mem marabo kis xiset sik bang ke öng kabise?” ");
INSERT INTO bjk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nang ina nine tödi toxo ot pösöt e Jisas, idu toxo tengen bira, “Jon a tene baptais i tile e maa rua ose nöngön bara, ‘Nöngön mon ina öng nang mem me xixiset bara irabo wanot, bere mem marabo kis xiset te öng kabise?’” ");
INSERT INTO bjk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma xina axana bung mon e Jisas ixo ölanglanga a oleleng nang ma abo miniset ma tano saban, ma ixo ölanglanga idi nang toxo pulo ma toxo wawara baling. ");
INSERT INTO bjk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Io, ixo balu abo tene kip tinenge re Jon bira, “Mu moro baling, ma moro ömaras e Jon ma lasanene nang mu muru pere me mu muru ölangen, bara abo pulo tere wawara, ma abo pengpeng tere önan, idi nang ma lepra idi tere deek, idi nang abo talinge baa tere ölöngö, ma abo minet tere taru baling, ma a tinenge deek iri maras sö idi nang a lak maris. ");
INSERT INTO bjk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A tödi a nunu re ine i kobo tawes xalik e, irabo deek kö ine.” ");
INSERT INTO bjk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Melamu nang abo tene kip tinenge re Jon toxoro wan, Jisas ixo urulo ra tinenge urungan kö marakörö ulamun e Jon bira, “Mum moxo wan su urso xö xönö tataun ta werwere a lasa? I xarniang a puru niang a xiki ibo wawaxat elin nanin ine? ");
INSERT INTO bjk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nang bara kawaim, ma lasa mum moxo wan su ra werwere? A tödi niang ixo sige sik a man mamaran? Kawaim. Idi ewe nang tobo sisige a mangana man niang a marana a lak kaa ma tobo kis ne orong, idi tobo xisixis köbo gunon ne orong. ");
INSERT INTO bjk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Inexalik, a lasa mum moxo wan su ra werwere? A propet? Turunon saxit, me ine i taxin sik köbo propet. ");
INSERT INTO bjk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ine mon ina öng niang toxoro geet ulamun: ‘E rabo tile re tene kip tinenge re e mesila re nöngön, ewe nang irabo tagure a ngas se nöngön mesila re nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","E tengen te mum, kaluluonin idi nang abo nene idi te kip idi, kaim pe öng i taxin köba re Jon. Inexalik ewe a öng i lik köba kölöme xö kingdom pe God, ine i taxin köba re Jon.” ");
INSERT INTO bjk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nangadi xirip me idi nang tobo kip takis, nang idi toxo ölangen abo tinenge re Jisas, idi toxo aut bara ina ngas se God i töxödös, möxösa, e Jon ixoro baptais idi. ");
INSERT INTO bjk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Inexalik abo Parasi ma abo duöng nanase xelen abo warkurai te Moses toxo mölök kalik a lasanene e God ixo pingit sik bara re idi, möxösa, kaim e Jon kö baptais idi. ");
INSERT INTO bjk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Me Jisas ixo tengen öbaling, “Io, a lasanene nang arabo öt ma marakörö mee nixinen? Idi te xarnang abo sa? ");
INSERT INTO bjk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Idi te öt ma bung barok lixilik niang te kisisik kölöme xö xönö möxö misik ma te xukup urungan tö idi iat: ‘Mem me maas a koo rö mum, ma lamun mum kobo ririe. Mem me sö ma sinö marmaris, ma lamun mum kobo gegee.’ ");
INSERT INTO bjk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Möxö, nang e Jon a tene baptais ixo wanot ma ixo ölölö ma kaim ine ra ininim pe wain, me mum moxo tengen bara, ‘A tano saban iri tup pe ine.’ ");
INSERT INTO bjk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A Barok kö Tödi ixo ot ma ixo aan ma ixo inim, me mum moxo tengen bira, ‘Ina tödi na a an sasaxa ma a tene ininim, me ine ibo ais arixe mabo tene kip takis ma “nangadi saban.” ’ ");
INSERT INTO bjk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Idi tobo rengrengen ina na, ma lamun a nangadi nang te kip a nanase xalik e God, idi te osen bara ina nanase nang, ine a laa runon.” ");
INSERT INTO bjk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Io, önga Parasi, a esene e Saimon, ixo seng e Jisas sua nien arixe me ine, io, ixo wan urungan kö gunon möxö Parasi ma ixo kis sede xö öra möxö nien. ");
INSERT INTO bjk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma önga une ewe nang ixo kis kö mangana to saban kö ina lagunon, ixo ösöxö lo bara e Jisas ixo aan kö gunon möxö Parasi, ixo kip ot a botol deek ne sada. ");
INSERT INTO bjk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma nang ixo tuu sik melamu re Jisas kö nine xexene ixo gegee, me ine ixo urulo a öburun a nine xexene e Jisas ma line marana, ma ixo salap ma bebene, ixo muum, ma ixo linge a wel könan. ");
INSERT INTO bjk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma nang ina Parasi ewe nang ixo seng ine ma ixo pere ina na ixo tengen iat tö ine, “Nang bara ina tödi na i xebe önga propet, ine i eöt tua ösöxö ewe i sisigi ine ma a mangana une sa ine, bara ine a tene saban.” ");
INSERT INTO bjk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas ixo balu ine, “Saimon, e ma laa rua röngröngösen nöngön.” Ine ixo balu, “Tene ausu, tengen te e.” ");
INSERT INTO bjk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Nine tödi toxo seng tuluwok kalik a önga tödi. Öng ixo kip lo a pitnö ne mar ma öng kabise a pitnö ne sangaun. ");
INSERT INTO bjk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kaim pe öng mere idu ixo eöt tua balu wuxus urungan te ine, ine ixo döxömen taun idu bara rua saksak öbaling a tuluwok. Io, na ewe mere idu irabo mamaa xöba lamun ine?” ");
INSERT INTO bjk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ixo balu, “E döxömen bara ewe nang ine ma oleleng ne tuluwok nang ixo döxömen taun.” Jisas ixo tengen, “Dödöxömen te nöngön i töxödös.” ");
INSERT INTO bjk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Io, ixo talingen urungan kö une ma ixo tengen te Saimon, “U pere ina une na? E laxa ura xö gunon te nöngön, me nöngön u kobo tabaa e ma ari rua gisgis a xexeke, nexalik ine i öburun abo xexeke ma line marana ma i salap abo xexeke ma bebene öxöno. ");
INSERT INTO bjk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nöngön u kobo muum e, nexalik ina une na, xö axana bung nang e laxa, ine i kobola mamas kö mumuum abo xexeke. ");
INSERT INTO bjk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nöngön u kobo bulus a wel kö öxöke, inexalik ine iri linge xöbo xexeke ma sada. ");
INSERT INTO bjk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Io niang, e tengen te nöngön, inabo magingin saban te ine, iri kawam, möxösa, i mamaa xöba lamun e. Inexalik ewe nang ma ulik ne magingin saban me God i döxömen taun ina tödi, irabo mamaa ulik mon lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Io, Jisas ixo tengen kö une, “Abo magingin saban te nöngön iri kawam.” ");
INSERT INTO bjk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma inabo osee toxo urulo rua tinenge kaluluonin idi, “Ewe ina tödi na nang ibo döxömen taun abo magingin saban?” ");
INSERT INTO bjk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas ixo tengen kö une, “A nunu re nöngön iri öro nöngön. Örö wan ma malum.” ");
INSERT INTO bjk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Melamu xö ina na, Jisas ixo wan nana xöbo lagunon, ma ixo etöngösen ma tinenge deek möxö kingdom kö God. Ma a sangaun ma ninöng toxo arixe me ine, ");
INSERT INTO bjk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma dauleng ne balixilik bölök ewe nang e Jisas ixoro kip tewe abo tano saban kalik idi ma ixoro ölanglanga idi xalik abo miniset. Ma öng kaluluonin idi, e Maria (ewe nang tobo tengen me Makdala), ewe nang a pitnö ma ninöng ne tano saban toxo wan su xalik ine, ");
INSERT INTO bjk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","me Joana, a une re Kusa ewe nang ixobo sila sik kö warkurai xöbo lalaa xö gunon te Erot, me Susana ma oleleng kabise bölök. Inabo balixilik na idi toxo top e Jisas ma abo bak ne ausu re ine mabo lalaa iat te idi. ");
INSERT INTO bjk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ma nang a marakörö raxin toxo orot etok ma toxo önan ot pösöt e Jisas meringan köbo lagunon öngöng, ine ixo tengen ina tinenge öwuo na: ");
INSERT INTO bjk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A önga tödi ixo wan tua retewe abo irine wit kö komo. Ma nang ine ixo retewe nanin abo irine wit, a dauleng toxo subu muu a ngas. Ma toxo wawas kaa lömö xönan, ma bung pun meriso lömö toxo en idi. ");
INSERT INTO bjk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ma dauleng ne irine wit toxo subu xö öxöno warawat, ma nang ixo das kaa, ixo mölös ma ixo met, möxösa, kaim a ari. ");
INSERT INTO bjk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dauleng ne irine wit toxo subu kaluluonin abo gargaras. Ma abo gargaras toxo das kaa arixe ma irine wit ma toxo pari abo wit nang i dadas kaa. ");
INSERT INTO bjk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lamun a uleng ne irine wit toxo subu xö pu deek. Idi toxo das kaa ma toxo o, öngöng ixo eöt ma önga mar ne irine wit.” Ma nang ine ixo tengen bira, ine ixo tengen lömö bira, “Ewe nang ine ma talingine, ine irabo ölangen.” ");
INSERT INTO bjk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abo bak ne ausu re ine toxo ose ine bara a unine a lasa ina tinenge öwuo na. ");
INSERT INTO bjk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ine ixo tengen, “God ixoro tabaa e mum ma nanase möxöbo pidik möxö kingdom kö God, nexalik kö idi nang kabise e bo rengrengen abo tinenge öwuo bere, ‘idi tabo wawara, lamun idi tekebeöt ta werwere xulen te laa, me idi tabo ölöngö, ma lamun idi tekebeöt ta ölangen kulen.’ ");
INSERT INTO bjk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ine na a unine tinenge öwuo: ina irine iaa ine a tinenge xö God. ");
INSERT INTO bjk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A irine wit nang toxo subu muu a ngas, idi te eöt me idi nang te ölangen, me e Satan ibo ot ma ibo xikip tewe abo tinenge möxö kat te idi, bara idi takarabo nunu ma takarabo kip a ineöro. ");
INSERT INTO bjk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A irine wit nang idi toxo subu lömö xö warawat, idi te eöt me idi nang te axanan tua xikip lo a tinenge nang bara idi te ölangen ine, ma lamun kaim idi ma buon. Idi te nunu aulik mon, ma lamun kö axana bung möxö ölelewen idi tobo subu rewe. ");
INSERT INTO bjk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A irine wit i subu kaluluon köbo gargaras i eöt me idi nang te ölangen, nexalik nang idi te önan kö nuan te idi, idi te döxömen köbanin abo lalaa möxö öxöno lagunon ma ulamun a kinis ne orong ma axanan mera xö öxöno lagunon. Ma inabo mangana tatalien na tobo wewet pi idi me idi tokobo maruxo. ");
INSERT INTO bjk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lamun a irine wit kö pu deek i eöt me idi ma bala deek nang toxo ölangen a tinenge, toxo töndik, ma tobo tuu lölös ot nang tobo oo. ");
INSERT INTO bjk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kaim pe öng ibo usumot a laam ma ibo umungen kölöme xö bile bara ibo bulbulus kö ene öra. Kaim. Inexalik ibo uxis lömö xö xönö iat möxönan, io nang, ewe idi te önan laxa tabo eöt tua werwere a maras. ");
INSERT INTO bjk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Io, abo lalaa i malaa mun sik irabo ot kö malmalan, ma abo lalaa te tawi sik irabo ot kö malmalan ma tabo ösöxö. ");
INSERT INTO bjk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Io niang, mum moro dödöm mamaran kö ölöngö re mum. Ewenene midi nang idi ma lalaa, God irabo tabaa idi ma oleleng. Me ewenene me idi nang kawaim idi mere lalaa, God irabo kip tewe bölök kirip abo lalaa nang idi te döxömen bara te uruoxe.” ");
INSERT INTO bjk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Io, a nago mabo tönö e Jisas toxo wanot tua werwere ine, nexalik kaim idi xo eöt tua inot lörörö re ine, möxösa, xö marakörö. ");
INSERT INTO bjk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Io, önga tödi ixo tengen te ine, “A nago re nöngön mabo töm te tuu sik ni xö araman, te mamaa rua werwere nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisas ixo balu, “A nago re e mabo töke idi ewe nang te ölangen a tinenge xö God ma te muu eörin.” ");
INSERT INTO bjk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Önga bung Jisas ixo tengen köbo bak ne ausu re ine bara, “Ire ta wan köröp uruo xö lawa xabise möxö tu.” Io, idi toxo kaa laxa xö önga mön ma toxo wan. ");
INSERT INTO bjk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma nang idi toxo ululo, Jisas ixo paluso. Ma a xiki raxin ixo wan su lömö xö tu ma ari ixo wan laxa xö mön me idi toxo lörörö rua iuiuo. ");
INSERT INTO bjk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Abo bak ne ausu toxo wan, ma toxo ölaran ine ma toxo tengen, “Tödi raxin! Tödi raxin! Ire te eka köngö!” Io, ine ixo taru ma ixo köö a xiki ma dalun. Ma xiki ixo kawam ma ina tu raxin ixo malile esexere. ");
INSERT INTO bjk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Me ine ixo ose abo bak ne ausu re ine, “A nunu re mum ule?” Idi toxo wuwus ma binuut, toxo ose öngöng mere idi, “A mangana tödi sa ia? Ine ibo isik a tinenge lölös kö xiki ma dalun, ma te tame ine.” ");
INSERT INTO bjk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Io, idi toxo uluso uruso xö xönö pu mee Gerasen, ibo malaa sik kö lawana tu Galili. ");
INSERT INTO bjk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ma nang e Jisas ixo ösö, ixo esuo ma önga tödi meringan kö lagunon, a tano saban ixo kis se ine. Bang im iat ina tödi kaim kö sisige re man bara ixobo xisixis kere gunon, nexalik ixobo xisixis kölöme xöbo lieng kö nangadi minet. ");
INSERT INTO bjk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ma nang ixo pere e Jisas, ixo kalasii ma ixo subu su xö nine xexene e Jisas, ma ixo kup nöngösö lömö, “Jisas, a Barok kö God lömö saxit, u mamaa lamun a lasanene xalik e? E seng nöngön u bele öxadik köbanin e!” ");
INSERT INTO bjk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ixo tengen bira, möxösa, e Jisas ixoro isik a tinenge lölös kö ina tano saban tua nuan su xalik ina tödi. Tobo kut sik a nine limine ma nine xexene ma tobo bulus mara sik ke ine, ma lamun oleleng ne axana bung a tano saban ibo rörödik ina tödi ma ixoro köröp abo sen te ine ma tano saban ibo sasat nanin ine xö boxönö nang kaim a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas ixo ose ine, “Ewe a esem?” Ixo balu ine bira, “Arip ne Arip,”, möxösa, oleleng ne tano saban toxoro wan laxa re ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Me idi toxo rengrenge marmaris se ine bara ganim ine ra tinenge lölös sik ke idi rua nilaxa xö mara lamin kaim pe xakawam möxönan. ");
INSERT INTO bjk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Oleleng ne bung bo toxo aan nana xö gegene maii. Abo tano saban toxo seng e Jisas sua ömaraxen idi ra nilaxa rup pe idi, ma ixo ömaraxen idi. ");
INSERT INTO bjk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bara nang abo tano saban toxo wan su xalik ina tödi, toxo laxa rup kö bung bo, ma ina bung bo toxo ewasak su xö gegene maii urungan kölöme xö ari ma toxo köngö met. ");
INSERT INTO bjk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma nang a nangadi möxö balaure a bung bo toxo pere ina lasa nang ixo ot, toxo ulo lo rua atöngösen min kö lagunon taxin ma xö boxönö lörörö. ");
INSERT INTO bjk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ma nangadi toxo wan su rua werwere a lasa ixo ot. Ma nang idi toxo wanot pösöt e Jisas, idi toxo pere wösöt ina tödi ewe nang abo tano saban toxoro wan su xalik ine, ixo kisisik kö nine xexene e Jisas. Ixo laulawa sik ma ixo kisisik ma dinödöm pe ine ixoro maras. Ma a nangadi toxo buut. ");
INSERT INTO bjk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Io, idi nang toxo pere ina laa, idi toxo töngösen a nangadi ma a ngas sa nang e Jisas ixo ölanglanga ina tödi nang abo tano saban toxoro kis se ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Io, a nangadi xirip möxö xönö Gerasen toxo seng e Jisas sua nuan pes xalik idi, möxösa, a binuut ixo kawönö idi. Io, ixo kakaa xö mön ma ixo wan. ");
INSERT INTO bjk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ina tödi nang abo tano saban toxo wan su xalik ine, ixo seng e Jisas bara irabo ömaraxen lo ine rua nuan arixe me ine, nexalik e Jisas ixo tile rewe ine, ma ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Örö wan baling kö lagunon te nöngön ma örö tengen a lasanene nang e God iri pet te nöngön.” Io, ina tödi ixo wan pes ma ixo etöngösen esexere xö lagunon mabo lasanene nang e Jisas ixo pet te ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ma nang e Jisas ixo baling, a marakörö toxo öga ine, möxö idi xirip toxo xixiset me ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Io, önga tödi a esene e Jairus, a tödi sila xö gunon ne sineseng ke idi abo Judeia, ixo ot ma ixo subun kexe xö nine xexene Jisas. Ma ixo tenge marmaris se Jisas sa nuan uruso xö gunon te ine, ");
INSERT INTO bjk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","möxösa, önga balik kalik mon te ine, a balik ixoro lörörö a sangaun ma ninöng, ma ixo eka minet. Ma nang e Jisas ixo önan, a marakörö toxo emorop pönö ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma önga une nangen niang, nang a dee ixobo önan kalik ine, ma ixo öt xarnang a sangaun ma ninöng ne awat, nexalik kaim pe öng ixo öt ta ölanglanga ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ina une ixo wan melamu re ine ma ixo sigi a ngusuno man te Jisas, ma saxit mon a ililo ne dee ixo kawam. ");
INSERT INTO bjk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisas ixo ose, “Ewe i sigi e?” Ma nang idi xirip toxo öösin, Pita ixo tengen, “Tödi raxin, a nangadi te orot etok ma te sisii rewe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma lamun e Jisas ixo tengen, “A öng i sigi e. E ösöxö bara lölös iri wan su xalik e.” ");
INSERT INTO bjk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Io, a une ixo wanot arixe ma dedede ma ixo subun kexe xö nine xexene Jisas, möxösa, ixo pere bara i kebeöt ta minun. Ma xö wawara xö nangadi ine ixo tengen ruasa ixo sigi e Jisas ma nang e Jisas ixo ölanglanga uwasaxit ine. ");
INSERT INTO bjk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Io, Jisas ixo tengen tö ine, “Balik, a nunu re nöngön iri öro nöngön. Örö wan ma malum.” ");
INSERT INTO bjk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nang e Jisas nangen bang ixo wöwörö xö une, önga tödi ixo ot meringan kö gunon te Jairus, a tödi raxin möxö gunon ne sineseng. Ma ixo tengen te Jairus, “A balik ke nöngön iri met. Nöngön u bele isik a tiip kö tene ausu.” ");
INSERT INTO bjk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas ixo ölangen ina na ma ixo tengen te Jairus bira, “U bele buut. Örö mana nunu mon, me ine irabo langlanga xalik ina miniset.” ");
INSERT INTO bjk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nang ine ixo ot kö gunon te Jairus, Jisas kaim kö ömaraxen tebo duöng bölök kua nilaxa arixe me ine, nexalik mon e Pita, Jon me Jems, ma tata ma nago xö balik. ");
INSERT INTO bjk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma nang a nangadi xirip toxo xukup ma ginee rö ine, Jisas ixo tengen, “Mum bele gegee. Ine i kobo met. Inexalik i paliso mon.” ");
INSERT INTO bjk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Idi toxo isis belek ine, möxösa, idi toxo ösöxö sik bara ine ixoro met. ");
INSERT INTO bjk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma lamun e Jisas ixo tön a limine ma ixo tengen, “Balik lik ke e, taru kaa!” ");
INSERT INTO bjk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A tanono ixo ot baling, ma nang iat mon ine ixo taru kaa. Io, Jisas ixo tengen te idu ra tabaa ine mere laa ra enen. ");
INSERT INTO bjk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana me nene toxo wuwus, nexalik ine ixo tengen te idu bara ganim a rengrengen kere öng ma lasa ixo ot. ");
INSERT INTO bjk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas ixo kuwe etok lo a sangaun ma ninöng ne bak ne ausu rine ma ixo tabaa idi ma lölös sua tile ösu abo tano saban ma rua ölanglanga abo mangana miniset. ");
INSERT INTO bjk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ma ixo tile rewe idi rua palas tinenge ma kingdom kö God ma rua ölanglanga a nangadi miniset. ");
INSERT INTO bjk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Io, ine ixo tengen te idi, “Mum korobo kip pe laa xö nuan te mum. Mum korobo kip pe buxo, a rat, a nien, re tuluwok, ma re man bölök. ");
INSERT INTO bjk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A mangana gunon sa mum mo laxa xönan, morobo xisixis iat tingan ot nang mum morobo wan lo baling kalik a lagunon niang. ");
INSERT INTO bjk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nang bara nangadi tekobo öga e mum, io, nang bara mum mo eka nuan kalik a lagunon te idi, mum morobo se rewe a kabus kalik abo xexe mum rua uxileng kö idi lamun a magingin saban te idi nang toxo pet te mum.” ");
INSERT INTO bjk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Io, idi toxo wan nana xöbo lagunon ma toxo etöngösen ma tinenge deek ma toxo ölanglanga a nangadi xö boxönö xirip. ");
INSERT INTO bjk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Io, e Erot a tödi raxin mee Galili ixo ölangen ulamun abo lalaa nang ixo orot. Me ine ixo ngangao, möxösa, dauleng toxo rengrengen bara e Jon a tene baptais ixo taru baling kalik a minet. ");
INSERT INTO bjk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dauleng toxo rengrengen bara e Elaija ixoro ot wösö, ma nexalik dauleng kabise bara ine öng möxöbo propet mee mesila saxit ixoro to baling. ");
INSERT INTO bjk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma lamun e Erot ixo tengen, “E xo tee xöröp a inöno e Jon. Ewe belek iang e ölangen inabo lalaa ulamun?” Me ine ixobo könönöin tua werwere ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nang abo aposol toxo tawuxus baling, idi toxo töngösen e Jisas mabo lalaa nang idi toxoro pet. Io, Jisas ixo lamus lo idi arixe mine ma toxo wan idi xalik iat urungan kö önga lagunon tobo rengrengen me Betsaida. ");
INSERT INTO bjk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma nang a marakörö toxo ösöxö lo ulamun ina nuan ma toxo muu ine. Ine ixo öga lo idi ma ixo wöwörö urungan te idi ulamun a kingdom kö God ma ixo ölanglanga idi nang toxo sasaxan lamun a öng irabo ölanglanga idi. ");
INSERT INTO bjk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma xö aien a sangaun ma ninöng toxo ot pösöt ine ma toxo tengen te ine, “Örö tile rewe a marakörö na. Me idi ta wan urungan köbo lagunon örörö rua winara lamun a nien ma lamun a xönö möxö minaru, möxösa, na ire ia xö xönö tataun.” ");
INSERT INTO bjk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jisas ixo tengen, “Mum iat, mum moro tabaa idi merebo lalaa rua enen.” Idi toxo tengen, “Mem angen ma pitnö ne xönö beret ma nini en. Nöngön u mamaa bara mem marabo wan ta kun nien lamun ina marakörö na?” ");
INSERT INTO bjk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ixo lörörö a pitnö ne arip ne tödi toxo kis singan ee.) Ma lamun ixo tengen köbo bak ne ausu re ine, “Morobo uxis idi eöt kö pitnö ne sangaun ne nangadi xö öngöng a muxu.” ");
INSERT INTO bjk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Mabo bak ne ausu toxo pet bie, me idi xirip toxo kis kö pu. ");
INSERT INTO bjk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Io, Jisas ixo tön lo ina pitnö ne beret ma nini en ma ixo wawara kaa xö balana kubu, ma ixo tengen deek ke God ma ixo pidik. Ma ixo tabaa abo bak ne ausu min tua tabaa a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Me idi xirip toxo an ma toxo masii. Io, abo bak ne ausu toxo tuxo a sangaun ma ninöng ne kölöt mabo subana nang idi toxo en paling. ");
INSERT INTO bjk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Önga bung nang e Jisas ixo seseseng suxume, mabo bak ne ausu re ine toxo arixe me ine, ixo ose idi, “Abo marakörö tobo rengrengen e me we?” ");
INSERT INTO bjk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Idi toxo balu, “Dauleng te tengen bere nöngön e Jon a tene baptais, dauleng te tengen bere nöngön e Elaija, ma lamun dauleng te tengen iat bara öng möxöbo propet mesila saxit i to baling.” ");
INSERT INTO bjk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Me ine ixo ose, “Me mum, mum bo rengrengen e me we?” Io, Pita ixo balu ine ma ixo tengen, “A Mesaia re God.” ");
INSERT INTO bjk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisas ixo panak ölölös idi bere idi tebele tengen osen ina na xere öng. ");
INSERT INTO bjk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma ixo tengen, “A Barok kö Tödi irabo mana kip lo a tiip oleleng. Abo sisila, mabo pris tataxin mabo tene ausu möxöbo warkurai te Moses idi tabo öbulubun ine. Ma nangadi tabo sexomet ine, ma xö narun ne bung melamu, irabo taru baling.” ");
INSERT INTO bjk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Io, ixo tengen te idi xirip: “Nang bara re tödi i mamaa ra mumuu e, ine irabo mana döxömen taun ine iat ma xöbo bungbung kirip irabo sölök a sölöxöröp pe ine ma irabo muu e. ");
INSERT INTO bjk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Möxö ewe nang i mamaa rua töndik sik iat a to re ine, irabo ömalim tewe, ma lamun ewe niang i ömalim tewe a to re ine rua gene e, irabo töndik sik. ");
INSERT INTO bjk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nang bara tödi i kip lo xirip abo lalaa möxö öxöno lagunon, ma i ömalim tewe bara i pet örup a to runon te ine, io, a lasa i deek möxö inabo lalaa irabo top ine? Kawaim. ");
INSERT INTO bjk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nang bara öng i mengmenge re e mabo tinenge re e, io, a Barok kö Tödi irabo mengein ine nang ine irabo wanot kö mariris se ine ma xö mariris kö Tata mabo angelo madakdak. ");
INSERT INTO bjk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Turunon saxit, dauleng nang te tuu sik na takarabo met ot nang idi tabo pere a kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ixo lörörö a pitnö ma narun ne bung melamu nang e Jisas ixo tengen ina na, ixo lamus lo e Pita, Jon me Jems arixe me ine me idiet toxo wan kaa xö maii raxin tua sineseng. ");
INSERT INTO bjk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma nang ine ixo seseseng a winara möxö wawara re ine ixo xuxulas, mabo man te ine ixo sisiek. ");
INSERT INTO bjk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nine tödi, Moses me Elaija, ");
INSERT INTO bjk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","toxo ot wösö xö dedeek ne mariris, me idu toxo wöwörö me Jisas. Idu toxo wöwörö ulamun a nuan te ine xalik ina öxöno lagunon nang ine ixoro lörörö ra wewet tingan Jerusalem eöt ma mamaa xö God. ");
INSERT INTO bjk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita mabo ais se ine toxo paluso, nexalik nang idiet toxo laran, idiet toxo pere a mariris se ine ma nine tödi toxo tuu arixe sik me ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma nang a nine tödi toxo önan lie e Jisas, Pita ixo tengen te ine, “Tödi raxin, i deek bara met mara xisixis sa. Met mara uru re narun ne walpali, öng ke nöngön, öng ke Moses ma öng ke Elaija.” (Kaim ine xo ösöxö a lasa niang ine ixo rengrengen.) ");
INSERT INTO bjk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma nang ine ixo wöwörö xudun, a kubu ixo wösö ot ma ixo tawi idi, me idiet toxo buut nang idiet toxo laxa xö kubu. ");
INSERT INTO bjk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","A inöno a öng ixo ot meringan kö kubu, ixo tengen, “Ine ano Barok ke e. E re pere kos lo ine. Muot morobo ölangen ine!” ");
INSERT INTO bjk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma nang a inöno öng ixoro wöwörö, idiet toxo pere wösöt e Jisas kalik mon. Mabo bak ne ausu kaim kö rengrengen kere öng kö ina axana bung ulamun a lasanene idiet toxoro pere. ");
INSERT INTO bjk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Xö bung melamu, nang idiet toxo wan su meruso xö maii, a marakörö toxo esuo me ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Önga tödi kölöme xö marakörö ixo kup, “Tene ausu, e seng nöngön tua werwere a barok ke e möxö ine a önga barok xexese. ");
INSERT INTO bjk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A tano ibo rörödik ine me ine ibo xukup. Ibo retewe ösu ine xö pu ma ibo dedede, io, a bise ibo orot kö ngalna. I kebeöt ta nuan kalik ine, ma i ögarin ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","E xo seng abo bak ne ausu re nöngön tua irewe ine, ma lamun kaim idi rua wewet eörin.” ");
INSERT INTO bjk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas ixo balu, “Mum a marakörö mee nixinen nang mum kara nunu me mum bo tawuxus kalik abo tatalien töxödös, e kebeöt ta kinis arixe me mum kö axana bung ömat. Ma nausen ne bung e rabo kip abo tiip pe mum? Kip ot a barok ke nöngön ura.” ");
INSERT INTO bjk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma nang a barok ixo önan ot, a tano saban ixo tewe ösu ine xö pu ma ixo dedede. Inexalik e Jisas ixo tenge köö ina tano saban ma ixo ölanglanga ina barok ma ixo isik öbaling ine urungan kö tata re ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Me idi xirip toxo wuwus kö lölös taxin kö God. Ma nang idi xirip toxo wuwus ma dinödöm oleleng lamun a lasa xirip nang e Jisas ixo pet, ixo tengen köbo bak ne ausu re ine, ");
INSERT INTO bjk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ölöngö deek kö lasa e eka rengrengen te mum: Tabo bulus a Barok kö Tödi xö limine a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma lamun idi kaim a xikip a lasa ine ixo rengrengen. Ixo malaa mun sik kalik idi, io, idi tekexebeöt ta ösöxö ina laa, me idi toxo bubuut tua ose ine ulamunon. ");
INSERT INTO bjk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A agot ixo taru kaluluonin abo bak ne ausu nang bara ewe mere idi irabo taxin sik. ");
INSERT INTO bjk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas ixo ösöxö a dödöxömen te idi, ixo lamus lo a bak lik ma ixo uru ine xö lawana ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma ixo tengen te idi, “Ewe nang irabo öga ina barok lik na xö esene e, ine i öga e, ma lamun ewe nang i öga e, ine i öga a öng nang ixo tile e. Möxö ewe nang i lik köba kaluluon te mum kirip, ine i taxin saxit.” ");
INSERT INTO bjk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon ixo tengen, “Tödi raxin, mem moxo pere a tödi ixo xikip tewe abo tano saban kö esem, me mem moxo eka wanwanak ine, möxösa, ine köbo öng mere ire.” ");
INSERT INTO bjk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas ixo tengen, “Ganim e mum kö wanwanak ine, möxö ewe nang i kobo öbulubun e mum, ine re mum.” ");
INSERT INTO bjk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nang a axana bung ixo orot bara God irabo kip öxaa ine uruso xö watmaep, Jisas ixo döxömen ölölös sua nuan u Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Me ine ixo tile ösila abo tene kip tinenge, ewe nang toxo wan laxa xö önga lagunon mee Samaria rua tagure abo lalaa rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lamun a nangadi ringan ee kaim kö öga ine, möxösa, ine ixo önan iat u Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nang e Jems me Jon, a nine bak ne ausu, idu toxo pere ina na, idu toxo eose, “Orong, u mamaa re maa rua xukuwe ösu a ia sösöt meruso xö watmaep pua ögarin esexerein idi?” ");
INSERT INTO bjk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lamun e Jisas ixo köö idu. ");
INSERT INTO bjk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Io, idi toxo wan urungan kö önga lagunon kabise. ");
INSERT INTO bjk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nang idi toxo önan kö ngas, önga tödi ixo tengen te ine, “E rabo muu nöngön köbo nuan kirip pe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas ixo balu, “A bung puluwun axe idi ma mara, ma bung pun meriso lömö idi ma wöwösö, nexalik a Barok kö Tödi kaim ine mere xönö rua ömarin a öxöno.” ");
INSERT INTO bjk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ine ixo tengen kö önga tödi xabise, “Muu e.” Lamun a tödi ixo balu, “Orong, örö öbala bang e ma ara wan ara pömös e tata re e.” ");
INSERT INTO bjk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas ixo tengen te ine, “Ganim abo minet tabo pömös abo minet te idi, nexalik nöngön örö wan ma örö etöngösen ma kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inexalik önga tödi xabise ixo tengen, “Orong, e rabo muu nöngön, nexalik örö öbala öbaling bang e ma ara pere a baninen te e, ma melamu e rabo wan kalik idi.” ");
INSERT INTO bjk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas ixo balu, “Kaim pe öng ewe nang ibo bulbulus a limine ra xikin a pu ma ibo wawara baling bara i eöt tua kinis kö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma melamu xö nang a Orong ixo pere kos a pitnö ma ninöng ne sangaun ma ninöng ne nangadi xabise ma ixo tile idi ninöng ninöng sila re ine xöbo lagunon kirip nang ixo eka nuan uwe. ");
INSERT INTO bjk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ixo tengen te idi, “A nien iri maruxo xirip ma iri oleleng, nexalik a nausen mon idi abo tene tinörön. Io, mum morobo seng a Tamana ina nien maruxo bara irabo tile rebo tene tinörön urungan kö komo re ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mum moro wan. E tile rewe e mum xarnang a bung barok kö sipsip urungan kaluluon köbo wuluwun axe. ");
INSERT INTO bjk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ganim e mum pua xikip pe tuluwok bara re rat. Me mum bele kip pe sandel tua xuxulas. Me mum korobo öga lo re öng kö ngas. ");
INSERT INTO bjk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ma nang bara mu morobo laxa xere gunon, sinila ne laa, mu morobo tengen, ‘A malum irabo kis kö ina gunon na.’ ");
INSERT INTO bjk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma nang bara re tödi möxö malum nangen nang ee, a malum pe mu irabo kis lömö re ine. Nang bara kaim, mu morobo kip puxus a tinenge re mu bara a malum i karabo kis kö ina tödi na. ");
INSERT INTO bjk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Me mu morobo kis kö ina gunon, ma a lasanene nang te tabaa e mu min, mu morobo en ma morobo inim, möxösa, i töxödös bara a tene tinörön irabo kip a xinixun te ine. Me mu bele wan nana urungan köbo gunon kabise. ");
INSERT INTO bjk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma nang bara mu morobo laxa xö önga lagunon ma te öga e mu, mu morobo en a lasanene nang te tagur sik ke mu. ");
INSERT INTO bjk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mu morobo ölanglanga abo miniset nang te kis singan, ma morobo töngösen idi bara, ‘A kingdom kö God iri lörörö re mum.’ ");
INSERT INTO bjk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma nang bara mu mo laxa xö önga lagunon ma tokobo öga e mu, io, mu morobo wan urungan köbo ngas möxö ina lagunon na ma morobo tengen, ");
INSERT INTO bjk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A kabus iat möxö ina lagunon te mum nang ibo parap kö xexe maa, maa me us tewe xalik e maa rua öwösö ulamun a tatalien saban mum moxo pet te maa. Inexalik morobo maras kö ina laa na, bara a kingdom kö God iri lörörö.’ ");
INSERT INTO bjk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","E tengen te mum, God irabo ömokorot köba e Sodom kö axana bung möxö warkurai. Inexalik a ömokorot möxö ina lagunon nang kaim kö öga lo e mu, irabo taxin köba xö ömokorot te ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“A maris se mum mee Korasin! A maris se mum mee Betsaida! Möxösa niang bara abo lalaa lölös ne auwuwus nang e xo pet tö mum, texere pet bölök ki Tair ma Saidon, idi texere sige abo xönö man biling ma texere urup idi ma xako rua osen bere idi tere dödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","God irabo pet a warkurai taxin kö nangadi mee Tair me Saidon kö axana bung möxö warkurai. Ma lamun irabo pet a warkurai nang i taxin köba re mum abo Betsaida mabo Korasin. ");
INSERT INTO bjk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Me mum mee Kaprenaum, mum bele döxömen bara tabo ii öxaa e mum urso lömö. Kaim, mum morobo wan su arixe uri xö pu xö xönö möxö minet. ");
INSERT INTO bjk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ewenene nang i ölangen a tinenge re mum, ine bölök i ölangen a tinenge re e. Me ewenene nang i wan talu e mum, ine bölök i wan talu e. Me ewenene nang i wan talu e, ine bölök i wan talu a öng niang ixo tile e ura.” ");
INSERT INTO bjk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma pitnö ma ninöng ne sangaun ma ninöng toxo wanot baling ma axanan ma toxo tengen, “Orong, mem me rengrengen a esem, mabo tano saban iat te tame e mem.” ");
INSERT INTO bjk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ine ixo balu, “E xo pere e Satan ixo subu xarnang a siek meriso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","E re tabaa e mum ma lölös sua wawas abo si mabo kalamasang ma ra wawas ösu a lölös kirip kö iuo re ire, ma kaim pe laa irabo ögarin e mum. ");
INSERT INTO bjk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inexalik, ganim e mum pa axanan bara abo tano saban te tame e mum. Ma lamun mum morobo mana axanan bara abo ese mum e God iri geet tuso xö watmaep.” ");
INSERT INTO bjk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Xö ina axana bung Jisas ixo wöwö ma axanan meringan kö Töxödös ne Tanono ma ixo tengen, “E ölet nöngön, Mama, a Orong möxö balana kubu ma öxöno lagunon, möxösa, nöngön u xo umungen abo lalaa na xalik a nangadi nanase ma u xo osen öwösö re idi nang kaim idi ma nanase. Mee, Mama. U xo pet bie, möxösa, i mumuu a mamaa re nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“A Tamake ixo tabaa e ma abo lalaa xirip. Kaim pe öng i ösöxö bara ewe ina Barok, ma lamun a Tamana xalik mon, ma kaim pe öng i ösöxö ewe ina Tamana, ma lamun a Barok kalik mon arixe me idi ewe nang a Barok ixo pere kos lo rua öwösö e Tamana urungan te idi.” ");
INSERT INTO bjk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Io, ine ixo tawuxus urungan köbo bak ne ausu re ine ma ixo tengen suxume re idi, “Irabo deek kö idi nang te pere a lasa mum mo werwere. ");
INSERT INTO bjk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Möxö e tengen te mum bara a oleleng ne propet ma abo king toxo mamaa rua werwere a lasa mum mo werwere, ma lamun idi kaim kö werwere. Me idi toxo mamaa rua ölangen a lasa mum mo ölangen, ma lamun kaim idi xo ölangen.” ");
INSERT INTO bjk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma xö önga bung melamu, önga tödi ixobo ösöxö ödeek sik abo warkurai te Moses, ixo taru kaa rua könönöin e Jisas. Ma ixo tengen, “Tene ausu, a lasanene nang arabo pet tua xikip a to ulorexe?” ");
INSERT INTO bjk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas ixo balu, “A lasanene toxo geet köbo warkurai te Moses? Ma nang u kos, u kip bara bule?” ");
INSERT INTO bjk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ine ixo balu, “‘Örobo mamaa ulamun a Orong, a God te nöngön, kö kat kirip pe nöngön, ma xö tanono e nöngön, ma xö lölös se nöngön, ma xö dinödöm pe nöngön,’ ma, ‘Örobo mamaa lamun a öng kabise xarnang u mamaa lamun nöngön iat.’” ");
INSERT INTO bjk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas ixo balu, “Nöngön u balu ödeek. Örö pet bie me nöngön örobo to.” ");
INSERT INTO bjk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ma lamun ine ixo mamaa rua ösöxö ödeek bara ine i töxödös, io, ixo ose e Jisas, “Ewenene a töke?” ");
INSERT INTO bjk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas ixo balu ine bira, “A önga tödi ixo önan su meringan Jerusalem urungan Jeriko nang abo duöng pililo toxo se ine ma toxo didii rewe abo man kalik ine me idi toxo paxat ine ma toxo wan kalik ine bara irabo met. ");
INSERT INTO bjk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","A pris ixo muu ösu ina ngas, ma nang ixo pere ina tödi, ixo wan lelebes ma ixo saxit ine xö lawa xabise. ");
INSERT INTO bjk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Io, önga tene tinörön möxö marapun te Lewi, nang ixo wanot kö ina xönö ma ixo pere ine, ixo wan lelebes bölök ma ixo saxit ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma lamun önga Samaria nang ine ixo önan, ixo ot kö ina xönö nang a tödi ee, ma nang ixo pere ine, a balana ixo muu ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma ixo wan urungan te ine ma ixo linge a wel ma wain köbo ruxuruk kine ma ixo kubus pi. Io, ixo bulus öxaa ina tödi xö dongki re ine ma ixo kip lo ine urungan kö gunon ne osee ma ixo balaure ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma xö bung kabise ixo kip lo a nine tuluwok ma ixo isik kö tamana ina gunon osee ma ixo tengen, ‘Örö balaure ine, ma nang bara arabo baling, e rabo balu wuxus a tuluwok ke nöngön nang u xo top ine min.’ ");
INSERT INTO bjk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ewenene mere idiet narun u döxömen bere ine a tönö ina tödi ewe nang abo duöng pililo toxo se ine?” ");
INSERT INTO bjk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma tödi nanase xöbo warkurai te Moses ixo balu, “A öng nang ixo marse ine.” Me Jisas ixo tengen te ine, “Örö wan ma örö pet bie.” ");
INSERT INTO bjk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ma nang e Jisas mabo bak ne ausu re ine toxo önan kö inuan te idi, ine ixo ot kö önga lagunon. Ma önga une a esene iang e Mata ixo öga lo ine urungan kö gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Me ine ma önga tönö ine, a esene iang e Maria, ewe nang ixo kis lörörö xö xexene a Orong ma ixo ölangen a lasa nang e Jisas ixo rengrengen. ");
INSERT INTO bjk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma lamun e Mata ixo madung sik mabo tinörön nang ixo wewet. Me ine ixo ot pösöt e Jisas ma ixo ose ine, “Orong, nöngön u kobo döxömen bara a tönö e i wan kalik e mabo tinörön. Örö tengen te ine bara ira top e.” ");
INSERT INTO bjk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Orong ixo balu, “Mata, Mata, u dödöm köba lamun abo lalaa oleleng ma i öriip a balam. ");
INSERT INTO bjk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ma lamun önga laa xalik mon u sasaxan ulamun. E Maria iri pere tus lo a lasa i deek, ma takarabo kip tewe xalik ine.” ");
INSERT INTO bjk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Önga bung e Jisas ixo seseseng kö önga xönö ma nang i ixo kawam, öng möxöbo bak ne ausu re ine ixo tengen te ine, “Orong, örö usu e mem pua sineseng, xarnang e Jon ixo usu abo bak ne ausu re ine.” ");
INSERT INTO bjk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ine ixo tengen te idi, “Nang bara mum mo seseseng, mum morobo tengen bira: “‘Mama, mem me mamaa bere mem marabo bulus kabisein a esem pua osen bere nöngön u madakdak saxit, me mem me mamaa bara a kingdom pe nöngön irabo wanot. ");
INSERT INTO bjk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tabaa e mem ma nien kö öngöng a bung nang i eöt kö ina bung. ");
INSERT INTO bjk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma örö döxömen taun tewe abo magingin saban te mem, möxö mem bölök marabo döxömen taun tewe abo magingin saban nang idi te pet tö mem. Me mem me mamaa bölök bara örobo balaure wi e mem kalik abo ölelewen.’” ");
INSERT INTO bjk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Io, ixo tengen te idi, “Öng ke mum ma ais, ma i wan urungan te ine xö luono dömön ma i tengen, ‘Eis, e mamaa bara örö tabaa e ma narun ne beret, ");
INSERT INTO bjk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","möxösa, a ais se e i wan kö ngas ömat ma i ot pösöt e ma kaim e mere laa ra tabaa ine min.’ ");
INSERT INTO bjk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Io, a öng nang kölöme irabo balu, ‘U bele öxadik e. A marame iri tamabaxut ma bung barok arixe me e, mem mere paluso. E kebeöt tua tinaru ra tabaa nöngön mere laa.’ ");
INSERT INTO bjk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Io, e tengen te mum, turunon ine a ais se ine, nexalik ine i karabo taru rua tabaa ine mere laa. Ma lamun irabo taru kaa ma irabo tabaa ine eöt ma sasaxan te ine, möxösa, ine i karabo mamanaa xö sineseng. ");
INSERT INTO bjk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Io, e tengen te mum, nöngön örobo seseng, ma örobo kip lo a laa. Niang bara u wawara siwin, örobo pere wösöt lo. Ma niang bara u wiwidin kö marame, God irabo sawang lo nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Möxö ewe i seseseng, irabo kip lo a lasa ine i ose lamun. Ewe i wawara siwin, irabo pere wösöt lo a laa niang ine i wawara siwin. Me ewe niang i wiwidin, God irabo sawang lo ine. ");
INSERT INTO bjk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ewe re mum abo tata i eöt ta tabaa belek a barok kine ma si, nang bara i seng a inan? ");
INSERT INTO bjk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma nang bara i seng a karalo, irabo tabaa belek ine ma kalamasang? ");
INSERT INTO bjk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nang bere mum abo tene sasaban, mum mo ösöxö ra tabaa abo barok ke mum ma abo lalaa deek, io, i osen bara a Tata re mum nuso xö watmaep i ösöxö ra isik a Töxödös ne Tanono rö idi ewe niang te seng ine ulamunon.” ");
INSERT INTO bjk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisas ixo kip tewe a tano saban nang ibo xisixis kö önga tödi, a ngalaböt ine. Ma nang a tano saban ixo wan kalik ine, ina tödi ewe nang i kara tenge, ixo tenge wök, ma marakörö toxo wuwus saban. ");
INSERT INTO bjk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma lamun a dauleng ke idi toxo tengen bira, “Ine e Belsebul, a sisila möxöbo tano saban, ewe nang ibo isik a lölös se ine rua xikip tewe abo tano saban.” ");
INSERT INTO bjk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dauleng kabise toxo könönöin ine bira. Toxo ose bara irabo pet te önga mangana auxileng lölös sua osen bara abo tinörön te ine meriso re God. ");
INSERT INTO bjk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisas ixo ösöxö abo dinödöm pe idi ma ixo tengen te idi, “Nang bara re kantri i kobo tuu arixe me idi iat, a dauleng mere idi tabo pet ögarin kirip ina kantri. Ma nang bara a barama tekobo tuu arixe, idi tabo kis elixilik. ");
INSERT INTO bjk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nang bara a nangadi re Satan te tawes lo, idi tekebeöt tua tinuu lölös. E tengen bira, möxösa, mum mo tengen bere e bo xikip tewe abo tano saban kö lölös se Belsebul. ");
INSERT INTO bjk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mum iat mo köbo döxömen bara a nangadi re mum tobo xikip tewe abo tano saban kö lölös se Belsebul. Möxö ina na, mum mo köbo eöt tua tengen bere e bo xikip tewe abo tano saban kö lölös se Belsebul. Io, a nangadi iat te mum, tabo osen bere abo tinenge re mum i kobo turunon. ");
INSERT INTO bjk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kaim. Ma lamun e bo xikip tewe abo tano saban ma lölös se God. Ma ina na i öturunon bara a kingdom kö God ixoro wan pösöt e mum. ");
INSERT INTO bjk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nang bara re önga tödi lölös i tön sik a use ma iie ma i tuu wi sik a gunon te ine, io, abo lalaa re ine irabo malaa deek sik. ");
INSERT INTO bjk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma nang bara önga tödi ma lölös taxin i erese ma ina tödi ma i se ine, io, irabo kip lo abo iie ma use xina tödi nang ixo bulus nunu sik könan. Ma lamun ina tödi lölös irabo palang inabo lalaa nang ixo pulo. ");
INSERT INTO bjk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Me ewe nang i kobo ais me e, i mölök kalik e. Ma ewe nang i kobo rörön arixe me e ra lalamus etok a nangadi, ine ibo waswasak a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nang bara re tano saban i wan su xalik a tödi, ibo önan eli xirip kö boxönö masa, bara rua mamas, nexalik bara i kara parasiwin te xönö. Io, ibo tengen bira, ‘E rabo tawuxus baling urungan kö ngasiene e niang e xo wan lie.’ ");
INSERT INTO bjk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ma nang bara i wanot uxe, irabo pere bara toxoro soso ma toxoro tagur bulus sik. ");
INSERT INTO bjk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma irabo wan lo ma irabo lamus öbaling a pitnö ma ninöng ne tano saban kabise, me idi te saban köba re ine. Me idi tabo wan laxa ma tabo kis im ee. Ma to xö ina tödi irabo saban köba xö nang sila.” ");
INSERT INTO bjk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ma nang e Jisas ixo rengrengen inabo lalaa, a une kaluluonin a marakörö ixo kup wösö bira, “God ire wadöane a une nang ixo kip nöngön ma ixo urus nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ine ixo balu, “God ire wadöane ewe me idi nang te ölangen a tinenge re God ma te muu eörin.” ");
INSERT INTO bjk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma nang a xinixos möxö marakörö ixo rataxin, Jisas ixo tengen, “A marakörö me nixinen a lak saban. Idi te mamaa bere e rabo pet te auxileng lölös, ma lamun e rabo isik a auxileng ke Jona xalik mon urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ma xarnang e Jona ixo auxileng urungan köbo nangadi mee Niniwe, io, irabo xarnang bölök a Barok kö Tödi ma irabo bie xö marakörö mee nixinen. ");
INSERT INTO bjk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma xö ina bung möxö warkurai, a kwin mee Siba, irabo puk e mum, möxösa, ixo wanot mero xö ngusuno öxöno lagunon tua ölangen a nanase re Solomon. Ma na, a öng nang i taxin sik ke idu me Solomon i nangen na. ");
INSERT INTO bjk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma xö bung möxö warkurai, a nangadi mee Niniwe idi tabo ömaso e mum, möxösa, idi toxo dödöm puxus nang e Jona ixo palas tinenge urungan te idi. Ma na, a öng nang i taxin sik ke idu me Jona i nangen na. ");
INSERT INTO bjk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kaim pe öng ibo usumot a laam ma ibo bulbulus kö xönö nang a lak mun, ma bara xö ene bile. Kaim. Inexalik ibo uxis lömö xö xönö iat möxönan, io nang, ewe idi te önan laxa tabo eöt tua werwere a maras. ");
INSERT INTO bjk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A nini kalait maram, idu te xarnang a bibio re nöngön. Nang bara a nine kalait maram a lak deek, io, a aim kirip irabo maras bölök. Ma nang bere idu te saban, a aim kirip irabo wöwö ma ködö. ");
INSERT INTO bjk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Io, örö tumarang, xalik ina bibio nang kölöme re nöngön ibo ködö. ");
INSERT INTO bjk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Möxö ina na, nang bara a aim kirip i wöwö ma maras, ma kaim pe xönö möxönan i ködö, io, irabo maras kirip esexere xarnang a bibio möxö laam nang ibo maras urungan te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nang e Jisas ixo wöwörö xirip, önga Parasi ixo seng ine rua nien arixe me ine. Io, ixo laxa ma ixo kis kö öra möxö nien. ");
INSERT INTO bjk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Inexalik ina Parasi ixo wuwus, möxösa, ine ixo pere bere e Jisas kaim bang kö gilime sila re ine ra nien. ");
INSERT INTO bjk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Io, a Orong ixo tengen te ine, “Io, mum abo Parasi mum moro gis ömaxat a araman möxö kap ma dis. Inexalik kö könönö e mum i wöwö ma tatalien saban ma tatalien ne mamaa lamun a oleleng ne lalaa. ");
INSERT INTO bjk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mum a duöng baulang! Bule, e God ixo pet a araman möxöbo lalaa ma kaim ine xo wewet a könönö bölök? ");
INSERT INTO bjk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Io, mum morobo mana tabaa abo maris ma arabaa meringan kölöme re mum, ma abo lalaa xirip irabo maxat te mum, ma tekarabo eöt tua öbiling e mum kö wawara re God. ");
INSERT INTO bjk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Maris se mum, abo Parasi, irabo saban te mum, möxösa, mum mo tabaa e God ma arabaa möxöbo lobo ma paluo mabo lalaa meringan kö komo bira. Mum bo erimine xö sangaun ne xönö me mum bo isik a öng urungan te God. Ma lamun mum kobo muu a tatalien töxödös kö nangadi me mum kobo mamaa lamun e God. Io, irabo töxödös niang bara mum moxoro isik abo lalaa urso re God, me mum kobo lön bölök kua mumuu a tatalien deek. ");
INSERT INTO bjk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Maris se mum, abo Parasi, irabo saban te mum, möxösa, mum mo mamaa bere mum morobo kis kö kinis deek kölöme xö gunon ne siniseng, me mum bo mamaa bara tabo kuwange e mum kö boxönö möxö mimiisik. ");
INSERT INTO bjk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Maris se mum, irabo saban te mum, möxösa, mum mo xarnang a maöt i maxus nang a nangadi tobo önan lömö xönan ma takara ösöxö.” ");
INSERT INTO bjk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A önga tene nanase xöbo warkurai te Moses ixo balu ine, “Tene ausu, nang bere nöngön u pet ina mangana tinenge na xöbo Parasi, nöngön u tengen ögarin e mem bölök.” ");
INSERT INTO bjk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisas ixo balu, “Mum abo tene nanase möxöbo warkurai te Moses, maris se mum, irabo saban te mum, möxösa, mum mo öxadik a nangadi mabo tiip nang idi tekebeöt ta xikip, me mum iat mo korobo ii öxaa re önga sisixine lime mum pua rorop idi. ");
INSERT INTO bjk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“A maris se mum, irabo saban te mum, möxösa, abo untubu mum toxo sexomet abo propet, me mum bo ömar ödeek abo midi re idi. ");
INSERT INTO bjk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Io, mum mo tengen osen bere mum mo sixaut kö lasa nang abo untubu mum toxo pet. Idi toxo sexomet abo propet, me mum mobo ömar ödeek abo midi re idi. ");
INSERT INTO bjk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Lamun ina na, xö nanase re God ine ixo tengen, ‘Arabo tile abo propet mabo aposol urungan te idi. Ma dauleng ke idi tabo eler, ma dauleng tabo sexomet.’ ");
INSERT INTO bjk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Möxö ina na, a marakörö mee nixinen tabo kip a tiip möxö dee ridi abo propet kirip nang ixo sen kö urulo möxö öxöno lagunon, ");
INSERT INTO bjk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","meringan kö dee re Abel urungan kö dee re Sekaraia ewe nang toxo sexomet kaluluonin a alta ma xö gunon ne lotu raxin. Turunon, e tengen te mum, a marakörö mee nixinen idi tabo kip a kinadik taxin ulamun idi xirip. ");
INSERT INTO bjk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Maris se mum, mum abo tene nanase möxöbo warkurai te Moses, irabo saban te mum, möxösa, mum moxo tuu wi a nangadi rua kip lo a nanase. Mum iat mo köbo lalaxa, me mum iat moxo pet pi idi nang toxo önan laxa.” ");
INSERT INTO bjk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma nang e Jisas ixo wan lie ina lagunon, abo Parasi mabo tene ausu möxöbo warkurai te Moses toxo urulo ra tewe tinenge saban urungan te ine ma toxo ose ine ma oleleng ne ineose. ");
INSERT INTO bjk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma toxo xixiset bara irabo tengen te tinenge ma tabo uxun ine. ");
INSERT INTO bjk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma xö ina axana bung a marakörö möxö oleleng ne arip toxo ot etok, io, idi toxo wawas nanin idi iat. E Jisas ixo urulo bang kua tinenge xöbo bak ne ausu re ine ma ixo tengen, “Tumarang e mum lamun a is köbo Parasi, möxösa, idi tobo eönunu bara idi a lak töxödös saxit. ");
INSERT INTO bjk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A lasa nang te kait pi, irabo tamasawang. Ma a lasa nang i mun sik, irabo ot kö malmalan. ");
INSERT INTO bjk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A lasa mum moxo tengen kö ködö, tabo ölangen kö maras, ma a lasa mum moxo ngunungun min kö talinge mum kölöme xö gunon, tabo kup wösö min meriso xö öxöno gunon. ");
INSERT INTO bjk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Abo ais se e, e tengen te mum, ganim e mum pa buburin ewe idi nang tabo sexomet a tödi mon ma melamu idi tekebeöt ta pet öbaling ke laa. ");
INSERT INTO bjk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma lamun e rabo osen e mum me ewe nang mum morobo buburin. Mum morobo buburin ine ewe nang melamu nang irabo sexomet a tödi, ine ma lölös sua tewe ösu e mum kö ia sösöt. Turunon, e tengen te mum, mum morobo buburin ine. ");
INSERT INTO bjk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ma a ulik ne tuluwok mon i eöt ta xukun te pitnö ne sigie. Inexalik bara kaim pe öng mere idi God irabo döxömen taun. ");
INSERT INTO bjk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Turunon saxit, ma ixoro kos kirip bölök abo bebene öxöno e mum. Ganim e mum pa binuut, möxösa, a to re mum i taxin sik köbo sigie. ");
INSERT INTO bjk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“E tengen te mum, ewenene niang i tenge maras kö wawara xö nangadi lamun e, a Barok kö Tödi irabo pet bölök bie rö ine xö wawara xöbo angelo re God. ");
INSERT INTO bjk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lamun ewe niang i öös tewe e xö wawara xö nangadi, e rabo öös tewe bölök ine xö wawara xöbo angelo re God. ");
INSERT INTO bjk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Me idi xirip nang te tengen ögarin a Barok kö Tödi, God irabo döxömen taun a magingin te idi, ma lamun ewe a öng nang i tengen ögarin a Töxödös ne Tanono, God i karabo döxömen taun a magingin tine. ");
INSERT INTO bjk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nang bere mum mo tuu mesila xöbo gunon ne sineseng, bara mesila xöbo tene pet warkurai arixe me idi nang ma ese raxin, ganim bere mum mo dödöm ne binuut bara morobo tuu wi e mum bule, ma bara a lasanene mum morobo tengen kö ina axana bung niang, ");
INSERT INTO bjk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","möxösa, a Töxödös ne Tanono irabo osen e mum ma a lasanene nang mum morobo tengen.” ");
INSERT INTO bjk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Önga tödi kölöme xö marakörö ixo tengen te ine, “Tene ausu, tengen kö töke bara irabo palang erimine e maa mabo lalaa re tata nang ixo met lie.” ");
INSERT INTO bjk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Me Jisas ixo balu bira, “Ewe ixo pere kos e bara arabo kure e muu? Me ewe i bulus e bara arabo palang erimine inabo lalaa niang ke muu?” ");
INSERT INTO bjk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Io, ixo tengen te idi, “Tumarang! Mum morobo balaure ödeek e mum, kalik abo mangana tatalien möxö ginumut. A to xö tödi i kobo eöt ta dedeek köbo mangana lalaa oleleng ke ine.” ");
INSERT INTO bjk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ma ixo tengen ina tinenge öwuo na: “A komo xö önga asuono orong ixo kip ot a oleleng ne nien. ");
INSERT INTO bjk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ine ixo döxömen iat te ine bara, ‘E rabo pet bule im? Kaim e mere xönö rua bulbulus abo nien te e.’ ");
INSERT INTO bjk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Io, ixo tengen, ‘Na arabo pet bira. Arabo öbeng ösu abo gunon mataxen te e ma arabo pet abo gunon mataxen rataxin, ma arabo bulus abo nien mabo lalaa re e ringan ee. ");
INSERT INTO bjk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Me e rabo tengen iat te e, “E ma oleleng ne lalaa deek e bulus öxaa lamun a oleleng ne awat. A to re e irabo malus, arabo an, arabo inim ma arabo axanan.” ’ ");
INSERT INTO bjk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Inexalik e God ixo tengen te ine, ‘Nöngön a baulang! Nixinen iat kö dömön örobo met. Io, ewe irabo kip lo abo lalaa nang u rö tagur sik kö nöngön?’ ");
INSERT INTO bjk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ina na irabo eöt me ewe nang ibo bulbulus ögun abo oleleng ne lalaa rö ine iat, nexalik kaim pe oleleng ne tatalien deek ke ine xö winara xö God.” ");
INSERT INTO bjk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Io, Jisas ixo tengen köbo bak ne ausu re ine: “Möxö ina na, e tengen te mum, ganim a dinödöm oleleng lamun a to re mum bara a lasa morobo en ma a lasa morobo inim, ma a lasa morobo sige xö aimum. ");
INSERT INTO bjk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A to re mum i taxin köba xö nien, ma a aimum i taxin köba xö man. ");
INSERT INTO bjk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mum moro döxömen lo a bung xöxö. Idi tekara susulo. Ma tekara kin öxaa nien. Idi kaim a gunon mataxen, ma lamun e God ibo tabaa idi ma nien. Ma xö mamaa re God, mum mo taxin sik kö bung pun! ");
INSERT INTO bjk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Me ewenene mere mum i dödöm oleleng ulamun abo tiip pe ine, i eöt tua öxase a to re ine ulik baling? Kaim turunon. ");
INSERT INTO bjk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma nang bara mum kebeöt tua wewet ina laa lixilik na, ruasa mum bo dödöm oleleng ulamun abo lalaa xabise? ");
INSERT INTO bjk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Mum moro dödöm deek köbo pasuno iaa te das bule. Idi tekara ösöxö ra tinörön me idi tekara ösöxö ra söxsöxö man. Inexalik e tengen te mum bere e Solomon kaim ine xo sisige rebo man deek xarnang a öng mere idi. ");
INSERT INTO bjk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Io, God i balaure a pirixö niang i to nixinen, ma maxalik tabo tewe öxaa xö ia sösöt. Nang bere God i pet bie xö pirixö, turunon saxit ine irabo tawi nöngön bölök arixe ma man te nöngön. Maris, a nunu re mum i wuruwut köba. ");
INSERT INTO bjk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Me mum bele dödöm kö to re mum kö lasanene mum morobo en bara morobo inim. Mum bele tapunuk ulamun. ");
INSERT INTO bjk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ewe me idi nang möxö öxöno lagunon nang tekobo nunu re God, idi tobo wawara siwin inabo mangana lalaa na, ma Tata re mum i ösöxö bara mum mo sasaxan. ");
INSERT INTO bjk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ma lamun mum morobo mana parasiwin abo lalaa i eöt ma kingdom pe ine. Me ine irabo tabaa e mum minabo lalaa xirip bölök. ");
INSERT INTO bjk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Turunon bara a nausen mon e mum, ma lamun ganim e mum pa binuut, möxö a Tata re mum i axanan tua tabaa e mum ma kingdom. ");
INSERT INTO bjk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Misik mabo mangana lalaa re mum ma moro tabaa a duöng maris. Mum morobo tagure e mum iat kö mangana tuluwok nang i karabo saban, a tabarikik kuso xö watmaep nang i karabo kawam, nang kaim pe tene pililo irabo pulo, ma kaim pe iwis irabo ögarin. ");
INSERT INTO bjk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Möxö a bubulus se mum i kis singan ee, ma a to xirip pe mum i kis singan bölök. ");
INSERT INTO bjk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mum morobo laulawa dik kua tagure e mum pa tinörön, mabo laam pe mum irabo mana bibio sik, ");
INSERT INTO bjk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","xarnang a duöng te xixiset ma orong ke idi nang irabo baling möxö luxa ne alolo, io, nang bara ine irabo wanot ma irabo wiwidin, saxit mon idi te eöt tua sasawang a marame rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Irabo deek kö idi abo tultul ewe nang a orong ke idi i pere wösöt idi ma te wawara sik nang ine irabo wanot. Turunon saxit, ine irabo ölaulawa ine iat tua tinörön, ma ina orong iat irabo tengen tö idi rua kinis kö öra möxö nien, me ine iat irabo ot ma irabo tabaa idi ma nien. ");
INSERT INTO bjk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Irabo deek kö idi abo tultul ewe nang a orong ke idi i pere wösöt idi te tagur sik nang bara i ot kö luono dömön bara xö puxu bubung. ");
INSERT INTO bjk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ma lamun e mum moro döxömen ödeek a na. Nang bara tamana gunon ixere ösöxö a axana bung sa nang bara a tödi pinilo irabo wanot, ine i karabo eöt ta ömaraxen a gunon te ine bara tabo pörök ölaxa. ");
INSERT INTO bjk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mum morobo mana tumarang, möxösa, a Barok kö Tödi irabo wanot kö axana bung nang mum kobo döxömen bara irabo wanot könan.” ");
INSERT INTO bjk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita ixo ose, “Orong, nöngön u rengrengen ina tinenge öwuo na ura re mem bara rua nangadi xirip?” ");
INSERT INTO bjk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma Orong ixo balu, “Me ewe iat im ina öng nang a tene nanase ma a tultul turunon ine? Ine nang a orong i bulus ine bara irabo balaure abo tene tinörön kabise ma irabo tabaa ödeek idi ma nien. ");
INSERT INTO bjk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Irabo deek kö ina tultul ewe nang a orong ke ine i wanot ma i pere bara i wewet bira. ");
INSERT INTO bjk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Turunon saxit, ine irabo bulus ine rua balbalaure xirip abo lalaa re ine. ");
INSERT INTO bjk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma lamun nang bara ina tultul i tengen öbaling ke ine iat, ‘A orong ke e i karabo ot baling pasaxit,’ io, irabo urulo ra sese abo tene tinörön, a körö ma balixilik, ma irabo aan ma ininim ma irabo inim saban arixe. ");
INSERT INTO bjk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Io, a orong ke ine irabo wanot kö bung nang ine i kobo döxömen sik bara irabo ot könan ma xö axana bung nang i kobo ösöxö bara irabo wanot. Ina orong ke ine irabo tee ölixilik ine ma irabo tewe ine urungan kö xönö möxö kinadik arixe mabo tabuno ölöngö. ");
INSERT INTO bjk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ina tultul ewe nang i ösöxö sik a mamaa xö orong ke ine, ma i kobo tagur sik bara i kobo pet a lasa nang a orong ke ine i mamaa lamun, tabo paxat olengin ine. ");
INSERT INTO bjk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma lamun a öng ewe nang i kobo ösöxö a lasa nang a orong ke ine i mamaa ulamun, ma ibo wewet abo lalaa nang i seseng lo a ömokorot, tabo paxat ine a ulik mon. Me idi nang toxo tabaa idi ma oleleng ne lalaa, idi tabo balu öbaling ma oleleng ne lalaa. Ma nang bara te bulus a oleleng ne lalaa xö limine a öng, idi te seng ine bara irabo balu ma oleleng ne lalaa. ");
INSERT INTO bjk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“E xo wanot tua öxat a öxöno lagunon, me e mamaa xöba bara ina ia sösöt na e xoro usumot. ");
INSERT INTO bjk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ma lamun e rabo kip lo bang a tiip taxin. Ma balake i tiip köba ot kö nang ina tiip irabo kawam. ");
INSERT INTO bjk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mum mo döxömen bara e xo wanot tua uxis a malum kö öxöno lagunon? Kaim. Inexalik e tengen te mum, e xo wanot tua uxis elixilixin a marakörö. ");
INSERT INTO bjk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ma urulo nixinen ma uruo melamu, nang bara a barama a pitnö idiet, tabo uxis elixilixin idi iat, io, a narun tabo tuu elixilik a ninöng, ma ninöng tabo tuu elixilik a narun. ");
INSERT INTO bjk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Idi tabo tuu elixilik, a tata irabo tuu talu a barok ma a barok irabo tuu talu a tata, a nago irabo tuu talu a balik ma a balik kalik a nene, ma bara a une tamasik irabo tuu talu a une tamasik ke ine.” ");
INSERT INTO bjk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ine ixo tengen kö marakörö, “Nang bara mum bo pere a kubu i önan kaa ruso xö labur, saxit mon mum bo tengen, ‘Irabo bara,’ ma ibo bie. ");
INSERT INTO bjk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma nang bara a xiki ibo wawaxat mero xö marana en, mum bo tengen, ‘Irabo lelewi,’ ma ibo bie. ");
INSERT INTO bjk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mum abo tene röxröxö! Mum bo ösöxö rua werwere xulen a winara möxö öxöno lagunon ma watmaep. Ma bara bule nang mum kobo eöt tua ösöxö xulen inabo mangana lalaa nang i orot nixinen? ");
INSERT INTO bjk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ruasa mum kobo perexulen öbaling ke mum iat a lasa nang i töxödös? ");
INSERT INTO bjk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nang bara u bo önan arixe ma öng i lamus nöngön kö tene pet warkurai, örobo lölös bara örobo ötöxödös arixe me ine, nang bang mu mo önan arixe xö ngas, xalik ine ibo sat lo nöngön ma irabo isik nöngön kö tene pet warkurai, ma a tene pet warkurai ibo isik nöngön kö duöng möxö balaure a nangadi nang tobo kubus pi idi kölöme xö gunon ne aömokorot, ma ina tödi irabo bulus nöngön könan. ");
INSERT INTO bjk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","E tengen te nöngön, ökorobo wan su ot nang örobo isik abo xinuxun kirip pe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Io, ringan ee xö ina axana bung nang a dauleng toxo töngösen e Jisas ulamun abo tee me Galili nang e Pailat ixo sexomet idi nang idi toxo isik a arabaa söngsöngöt te idi. ");
INSERT INTO bjk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas ixo balu, “Mum mo döxömen bara inabo tee Galili nang idi toxo iuo biringan, idi abo tene sasaban tunon köbo tee Galili xabise xirip? ");
INSERT INTO bjk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","E tengen te mum, kaim! Inexalik nang bara mum kobo dödöm puxus, mum kirip bölök morobo iuo. ");
INSERT INTO bjk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma ina sangaun ma pitnö ma narun nang toxo met nang a gunon ömat mee Siloam ixo subu kaa re idi, mum mo döxömen bara idi abo tene sasaban tunon te idi xirip nang toxo xisixis kölöme Jerusalem? ");
INSERT INTO bjk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","E tengen te mum, kaim! Inexalik nang bara mum kobo dödöm puxus, mum kirip bölök morobo iuo.” ");
INSERT INTO bjk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Io, ine ixo tengen ina tinenge öwuo na: “Önga tödi ixo sulo a uno löwö xö komo wain te ine, me ine ixo wan tua winara siwin tebo pasuno xönan. Inexalik kaim ine xo werwere lo re öng. ");
INSERT INTO bjk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Io, ixo tengen kö tödi nang ibo balaure sik ina komo wain, ‘Iri eöt ma narun ne awat im nang e bo önan tua winara lamun tebo pasuno xö ina uno löwö na, me e kobola pere wösöt te öng. Örö tee ösu! Ruasanene i ösek a pu deek?’ ");
INSERT INTO bjk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ina tödi ixo balu, “‘Asuono orong, ganim bang ine xö önga awat baling, me e rabo kin elulurwein me e rabo bulus sebo lalaa deek ka wewet ödeek a pu. ");
INSERT INTO bjk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma nang bara irabo o a pasuno xö awat melamu, i deek. Nang bara kaim, io, tee ösu.’” ");
INSERT INTO bjk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Xö önga Sabat, Jisas ixo eusu xö öng möxöbo gunon ne sineseng. ");
INSERT INTO bjk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma a une nangen nang ee ewe nang a tano saban ixo ögarin ine xö sangaun ma pitnö ma narun ne awat. Ma a siine sabono ixo gege ma i kara eöt tua tinuu töxödös. ");
INSERT INTO bjk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nang e Jisas ixo pere ine, ixo kuwe ot ine ma ixo tengen, “Uru langlanga xalik a miniset te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Io, ixo bulus öxaa a limine lömö xö ina une, ma saxit mon ixo tuu töxödös ma ixo ölet e God. ");
INSERT INTO bjk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Io, a sisila möxö gunon ne sineseng ixo laie re Jisas, möxösa, ixo ölanglanga ina une xö Sabat, ma ixo tengen kö nangadi, “A pitnö ma öng ne bung möxö tinörön angen, io, mum morobo wanot kö inabo bung kua seseng önga tödi rua ölanglanga e mum, ma kaim bara xö Sabat.” ");
INSERT INTO bjk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Orong ixo balu ine, “Mum a nangadi möxö röxröxö! Xö bung Sabat öngöng mere mum ibo walwalas a bulmakau bara dongki re ine möxö löng ma ibo lalamus ösu rua ratabaa ine ma ari. ");
INSERT INTO bjk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Io, ina une na, a untubuno e Abaram ewe nang e Satan ixo kubus pi sik ine xö sangaun ma pitnö ma narun ne awat. I deek bölök bara xö bung Sabat tabo palas tewe ina laa nang ixo kubus pi sik ine.” ");
INSERT INTO bjk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ma nang ine ixo tengen ina na, abo iuo re ine toxo menge, nexalik a nangadi toxo axanan ulamun abo lalaa deek nang ine ixo wewet. ");
INSERT INTO bjk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Io, Jisas ixo eose, “A kingdom kö God i xarnang a lasanene? E rabo öt ine ma lasa? ");
INSERT INTO bjk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I xarnang a irine iaa nang a lak lik köba nang a tödi i kip lo ma i sulo xö komo re ine. Ixo das kaa ma ixo öt ma iaa, mabo pun meriso lömö tobo wewet abo wöwösö re idi xöbo axan möxönan.” ");
INSERT INTO bjk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ine ixo eose baling, “E rabo öt a kingdom kö God ma lasanene? ");
INSERT INTO bjk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I xarnang a is nang önga une ixo kip lo ma ixo bulus arixin ma plawa oleleng ot nang irabo ebobot.” ");
INSERT INTO bjk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Io, Jisas ixo wan kaluluonin abo lagunon, ma ixo usu a nangadi nang ixo önan u Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Io, a önga tödi ixo ose ine, “Orong, i bule nang a usen ne nangadi xalik mon nang God irabo öro?” Ine ixo tengen te idi, ");
INSERT INTO bjk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mum morobo mana lölös sua nilaxa xö marame lik, möxösa, e tengen te mum, a oleleng tabo mamaa rua nilaxa ma takarabo eöt. ");
INSERT INTO bjk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma nang bara tamana gunon irabo taru ma irabo baxut a marame, mum morobo tuu sik kö araman, morobo wiwidin ma morobo eose marmaris bira, ‘Orong, örö sawang a marame rö mem.’ “Inexalik ine irabo balu, ‘E kobo ösöxö e mum, me e kobo ösöxö bara mum mole.’ ");
INSERT INTO bjk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Io, mum morobo tengen, ‘Mem moxo an ma moxo inim arixe me nöngön, me nöngön u xo usu e mem köbo ngas urungan köbo gunon te mem.’ ");
INSERT INTO bjk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Inexalik ine irabo balu, ‘E kobo ösöxö e mum, me e kobo ösöxö bara mum mole. Moro wan kalik e, mum kirip abo tene pet laa saban!’ ");
INSERT INTO bjk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma nang mum morobo pere Abaram, Aisak me Jekop mabo propet kirip kölöme xö kingdom kö God, ringan ee mum morobo gegee ma morobo engiren abo ngisine mum, nexalik e mum iat tabo tewe ösu e mum. ");
INSERT INTO bjk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A nangadi tabo wanot meringan kö nit ne marana xiki, ma tabo kis kö pet nien kö kingdom kö God. ");
INSERT INTO bjk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ma i turunon saxit bara idi ewe nang te sila, tabo muu, ma nang te muu, tabo sila.” ");
INSERT INTO bjk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Xö ina axana bung iat a dauleng ne Parasi toxo ot pösöt e Jisas ma toxo tengen te ine, “Örö wan kalik ina xönö na ma örö wan kere xönö xabise. Erot i mamaa rua sesexomet nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ine ixo balu, “Moro wan ma moro tengen kö ina iuo re e bara, ‘Arabo tile ösu abo tano saban ma arabo ölanglanga a nangadi nixinen ma maxalik, ma xö sese önarun ne bung e rabo öxawam abo tinörön te e.’ ");
INSERT INTO bjk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ma lamun e rabo mana önan iat nixinen ma maxalik, ma xö bung melamu, möxösa, turunon saxit, kaim pe propet irabo met kö xönö xabise ma kölöme iat Jerusalem! ");
INSERT INTO bjk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Mum mee Jerusalem, maris se mum! Mum bo sesexomet abo propet me mum bo reteng idi nang e God ibo tile idi ura re mum. A oleleng ne axana bung e bo mamaa bara e rabo töndik lo e mum xarnang a nene xixök ibo böböng pi a bung barok kine ma nine wawono. Ma lamun mum koxobo mamaa bira. ");
INSERT INTO bjk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pere bang! Ina lagunon te mum irabo saban ma irabo malaa tataun, ma morobo pet bule? E tengen te mum, mum kebeöt ta pere öbaling e ot kö axana bung niang mum morobo tengen bara, ‘God irabo pet ödeek ina tödi niang ewe irabo wanot ta wewet eörin a mamaa xö Orong.’” ");
INSERT INTO bjk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Önga bung Sabat, nang e Jisas ixo wan tua nien kö gunon kö önga sisila ne Parasi, a marakörö toxo werwere dik ine bara irabo pet a lasanene. ");
INSERT INTO bjk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma önga tödi a aine ixo u-ung ixo ot pösöt e Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Me Jisas ixo ose abo Parasi mabo duöng nanase möxöbo warkurai te Moses, “I deek bara ire tabo ölanglanga abo miniset kö bung Sabat bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma lamun kawaim idi xö tinenge. Io, ixo tön a tödi ma ixo ölanglanga ine ma ixo tile rewe ine. ");
INSERT INTO bjk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Io, ixo ose idi, “Nang bara öng mere mum ma önga barok bara önga bulmakau i subu su xö mara ari xö Sabat, a turunon bara örobo sat öxaa öbaling ine. Goo?” ");
INSERT INTO bjk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma kaim idi xo rengrengen te laa. ");
INSERT INTO bjk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma nang ine ixo pere abo osee toxo pilak lo abo xönö deek kö öra möxö nien, io, ixo töngösen idi ma ina tinenge öwuo: ");
INSERT INTO bjk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nang bara öng i pixe nöngön urungan kö luxa ne alolo, ganim bara u kis kö kinis kö tödi raxin, xalik ewe nang i taxin sik ke nöngön ibo wanot, möxösa, toxo pixe bölök ine. ");
INSERT INTO bjk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nang bara i biringan, ina tödi nang i pet ina nien irabo wanot, ine mon niang ixo pixe e mu. Ma irabo tengen te nöngön, ‘Örö taru wes a kinis se nanga.’ Io, örobo menge möxö i tile rewe nöngön urungan kö kinis ne tanaa. ");
INSERT INTO bjk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ma lamun nang bara te pixe nöngön, i deek bara örobo kis kö kinis ne tanaa nang bara ine nang i pixe nöngön irabo wanot ma irabo tengen te nöngön, ‘Töke, örobo kip önga kinis nang i taxin saxit.’ Io, ina marakörö meringan ee idi tabo ii nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Io, ewe nang i ii öraxin iat ine, God irabo ii ösu ine, me ewe nang i ii ösu ine, God irabo ii öraxin ine.” ");
INSERT INTO bjk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Me Jisas ixo tengen kö ina tödi nang ixo pixe ine ra nien, “Nang bara u epixe ra nien, ganim bara u pixe abo ais se nöngön, mabo töm bara abo unsaxam, mabo nangadi orong nang te kis lörörö. Ganim bara u pet bie, xalik idi tabo pixe öbaling nöngön tua babalu öbaling. ");
INSERT INTO bjk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma nang bara u epixe urungan kö luxa re nöngön, örobo pixe abo maris, abo pengpeng, abo lime mut ma xexe mut, mabo pulo. ");
INSERT INTO bjk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Me God irabo wadöane nöngön nang bara idi tokobo balu öbaling urungan te nöngön, möxösa, God irabo balu sik ke nöngön kö axana bung möxö tinaru baling möxöbo tene töxödös.” ");
INSERT INTO bjk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nang a öng mere idi nang toxo kis arixe me Jisas kö öra, ixo ölangen ina na, ma ixo tengen, “Ina tödi ewe nang irabo an kö ina nien kö kingdom kö God, e God irabo wadöane ine.” ");
INSERT INTO bjk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisas ixo balu, “A önga tödi ixo tagure a nien taxin ma i pixe a oleleng ne osee. ");
INSERT INTO bjk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma xö ina axana bung möxö pet nien, ixo tile a tene tinörön te ine rua rengrengen te ewenene me idi nang ixoro pixe sik bara, ‘Moro miang. Möxö abo lalaa xirip tere tagur sik.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ma lamun idi xirip belek toxo urulo rua rengrenge wi idi iat. Öng ixo arun ta rengrengen, ‘E mana kun a xönö pu, me e rabo mana wan tua werwere. Maris, e karabo wanot.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ma öng kabise ixo tengen, ‘E mana kun a sangaun ne bulmakau möxö tinörön. Me e önan tua könönöin idi. Maris, e karabo wanot.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ma öng kabise bölök ixo tengen, ‘E mana elolo. E karabo wanot.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Io, ina tene tinörön ixo baling ma ixo tengen osen ina na urungan kö orong ke ine. Io, a tamana gunon ixo laie ma ixo isik a tinenge xöbo tene tinörön te ine bira: ‘Moro wan pasaxit urungan köbo ngas lixilik kirip möxö ina lagunon ma moro lamus abo maris, mabo pengpeng, mabo pulo mabo xexe mut ma lime mut.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“A tene tinörön ixo tengen, ‘Orong, e re pet eörin a lasanene nang u tengen, ma lamun a gunon i kobola wöwö.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Io, a orong ixo tengen köbo tene tinörön te ine, ‘Moro wan su urungan köbo ngas taxin mabo ngas lixilik bölök, ma morobo ölölös lo idi rua nilaxa bara a gunon te e irabo wöwö. ");
INSERT INTO bjk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","E tengen te mum, ma kaim pe öng mere idi abo duöng nang e xo pixe, irabo nanamienin ina nien te e.’” ");
INSERT INTO bjk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Io, a marakörö raxin toxo önan arixe me Jisas, ma ixo tawuxus urungan te idi ma ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nang bara re öng i wan ura re e ma i kobo melentexin a tata ma nago ma une re ine ma bung barok mabo tönö mabo saxana ma lamun ine iat bölök, ine i kebeöt tua mumuu e. ");
INSERT INTO bjk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Me ewenene re öng niang i kobo sölök a sölöxöröp pe ine ma i kobo mumuu e, ine i kebeöt tua mumuu e. ");
INSERT INTO bjk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nang bara re öng i mamaa ra uru a gunon, sinila ne laa irabo kis bang ma irabo döxömen muu a xinixun möxö ina gunon tua ösöxö bara a tuluwok ke ine irabo eöt sik ka öxawam a gunon bara kaim. ");
INSERT INTO bjk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma nang bara ine i uru a gunon ma i kobo öxawam, ewe idi nang te pere tabo ösaxit ine. ");
INSERT INTO bjk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Io, idi tabo tengen, ‘Ina tödi na ixo urulo ra wewet a gunon ma lamun kaim ine ra eöt tua öxawam.’ ");
INSERT INTO bjk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Nang bara a king i mamaa ra nuan ta inarse ma önga king kabise, io, irabo kis bang ma irabo dödöm deek bara a sangaun ne arip ne umri re ine i eöt tua inarse ma nine sangaun ne arip ne umri möxö king kabise. ");
INSERT INTO bjk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma nang bara ine i kebeöt, io, irabo tile re uleng ne tultul te ine rua seseng a malum kalik ina king kabise nang bang i nangen kö palaa. ");
INSERT INTO bjk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","I xarnang mon, nang bara ewe re öng mere mum nang i kara kip tewe abo lalaa xirip pe ine, io, i kobo eöt tua mumuu e. ");
INSERT INTO bjk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A sol ibo rorop ma nang bara a nanamien möxönan iri kawam, a nanamien möxönan irabo ot baling bule? I kebeöt. ");
INSERT INTO bjk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I kobo deek bara irabo top a pu xö könönö komo ma i kebeöt ta bulbulus arixin ma texene bulmakau ra rorop a komo. Tabo tewe rewe. “Ewe nang ine ma talingine, ine irabo mana ölangen.” ");
INSERT INTO bjk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Önga bung abo tene kip takis ma nangadi xabise nang tobo rengrengen idi bara abo tene saban, toxo kis elulurwein e Jisas sua ölangen ine. ");
INSERT INTO bjk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ma lamun abo Parasi mabo tene ausu möxöbo warkurai te Moses toxo tengen, “Ina tödi ibo öga abo tene saban ma ibo aan arixe me idi.” ");
INSERT INTO bjk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Io, Jisas ixo töngösen idi ma ina tinenge öwuo na: ");
INSERT INTO bjk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nang bara re öng mere mum ine ma önga mar ne sipsip ma nang bara re öng i tup, io, irabo ganim sik ina pitnö ma nit ne sangaun ma pitnö ma nit tabo aan kö önga xönö, ma irabo wan tua winara siwin ina önga sipsip ot nang irabo pere wösöt ine. ");
INSERT INTO bjk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma nang bara ine irabo pere wösöt lo ine, irabo bulus ine xö xalxalam pe ine ");
INSERT INTO bjk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma irabo wan urungan lagunon. Ma irabo kuwe abo ais se ine mabo duöng lörörö ma irabo tengen, ‘Moro axanan arixe me e. E re parasiwin lo a sipsip pe e nang ixo tup.’ ");
INSERT INTO bjk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","E tengen te mum, irabo bie bölök kuso xö watmaep. Nang bara önga tene saban i dödöm puxus, a axanan taxin irabo ot tuso lömö. Ina axanan i taxin köba xö axanan tuso lömö nang bara a pitnö ma nit ne sangaun ma pitnö ma nit abo tene töxödös idi tokobo sasaxan tua dinödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ma bara önga une ma sangaun ne tuluwok ma i pet örup a öng, turunon saxit, ine irabo usumot a laam, ma irabo so a gunon ma irabo wawara siwin ödeek ot nang ine irabo pere wösöt lo ine. ");
INSERT INTO bjk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma nang ine irabo pere wösöt lo ine, irabo kuwe abo ais se ine me idi nang tobo xisixis lörörö re ine ma irabo tengen, ‘Moro axanan arixe me e. E re pere wösöt lo a tuluwok ke e nang ixo tup.’ ");
INSERT INTO bjk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","E tengen te mum, irabo bie bölök kuso lömö. A axanan taxin kaluluonin abo angelo re God lamun önga tene saban nang i dödöm puxus.” ");
INSERT INTO bjk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Io, Jisas ixo tengen öbaling, “Önga tödi ine ma nine barok suxurno. ");
INSERT INTO bjk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma nang a lik ke idu ixo tengen kö tamana, ‘Tata, örö erimine e maa narön mabo kinis se nöngön, ma örobo tabaa wes e ma lawa nang ke e.’ Io, ixo erimine abo lalaa re ine kaluluonin idu. ");
INSERT INTO bjk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Xö uleng ne bung melamu, ina lik ixo pok lo xirip abo lalaa re ine ma ixo wan lo xö önga lagunon kö palaa. Ma ringan ee ixo götö nana ma ixo ösek kirip abo tuluwok ke ine. ");
INSERT INTO bjk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Melamu nang ixoro öxawam kirip abo tuluwok, a irilöng taxin ixo ot kö ina kantri xirip, ma ixo urulo im pa sasaxan. ");
INSERT INTO bjk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Io, ixo wan ma ixo ose tinörön kö önga tödi meringan iat kö ina kantri, ewe nang ixo tile ine urungan kö xönö möxö bung bo bara irabo ratabaa. ");
INSERT INTO bjk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma ixo mamaa xöba rua öwöwö a balana ma lewene nien niang a bung bo toxo enen paling, ma lamun kaim pe öng ka tabaa ine mere laa. ");
INSERT INTO bjk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ma nang a dinödöm deek ixo ot te ine, ixo tengen, ‘A usen ne tene tinörön te tata re e idi ma nien nang ibo kis baling, ma na e belek im a, e re memet ma irilöng! ");
INSERT INTO bjk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","E rabo baling urungan te tata ma arabo tengen te ine, “Tata, e xo pet a magingin saban urungan te God ma ura re nöngön bölök. ");
INSERT INTO bjk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","I kobo töxödös sik bara örobo tengen bara e a barok ke nöngön. Inexalik örobo pet e xarnang a öng möxöbo tene tinörön te nöngön.” ’ ");
INSERT INTO bjk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Io, ixo taru lo ma ixo wan urungan kö tata re ine. “Ma lamun nangen bang ixo önan kudun kö palaa, a tamana ixo pere ine ma ixo marse xöbanin ine. Ma ixo ulo urungan te ine, ma ixo gön lo ine ma ixo muum ine. ");
INSERT INTO bjk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ma a barok ixo tengen kö tamana, ‘Tata, e xo pet a magingin saban urungan te God ma ura re nöngön. I kobo töxödös sik bara örobo tengen bara e a barok ke nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ma lamun a tata ixo tengen köbo tene tinörön te ine, ‘Moro saxit! Moro kip lo a man nang a lak deek ma moro usige ine min. Ma moro bulus a mörölö xö limine ma moro usige ine ma nine sandel. ");
INSERT INTO bjk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ma moro kip lo a barok kö bulmakau nang a lak ebobot ma moro sexomet, me ire tabo pet a luxa raxin. ");
INSERT INTO bjk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Möxö a barok ke e ixoro met ma iri to baling. Ixo tup me ire tere pere wösöt lo ine.’ Io, idi toxo urulo a luxa. ");
INSERT INTO bjk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma a taxin te idu ixo xisixis uso xö komo. Ma nang ixo wanot lörörö xö gunon, ixo ölangen a inöno sinö ma tinie. ");
INSERT INTO bjk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Io, ixo kuwe a öng möxöbo tene tinörön ma ixo ose ine bara te wewet a lasanene. ");
INSERT INTO bjk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A tene tinörön ixo balu ine, ‘A tönö re nöngön iri wanot baling. Me tata re nöngön i tile tinenge bere mem mara döxö ömet te bak kö bulmakau nang i ebobot deek, möxösa, ine i pere a töm bara i to deek.’ ");
INSERT INTO bjk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A sinila ne barok ixo laie ma ixo kasen tua nuan laxa. Io, a tamana ixo wan su ma ixo tenge marmaris se ine ra nuan laxa. ");
INSERT INTO bjk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Inexalik ixo balu e tata re ine bira: ‘Pere bang! Xö inabo awat na e xobo rörörön te nöngön me e xobo rarame nöngön. Ma kaim arixe bara u xo tabaa e mere bak kö me bere e rabo pet a luxa min arixe mabo ais se e. ");
INSERT INTO bjk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Inexalik bara ina barok ke nöngön na ixo susur ma inabo lalaa re nöngön kö balixilik ilawa. Ma nang ine i wanot baling, nöngön u döxö ömet a bak kö bulmakau nang i ebobot tö ine.’ ");
INSERT INTO bjk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“A tata ixo tengen, ‘Barok ke e, nöngön u bo xisixis arixe me e, mabo lalaa xirip pe e re nöngön. ");
INSERT INTO bjk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Inexalik ire tabo mana axanan ma tabo bala deek, möxösa, ina töm ixo met ma na iri to baling. Ixo tup ma tere pere lo ine.’” ");
INSERT INTO bjk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas ixo tengen köbo bak ne ausu re ine: “Önga asuono orong ine ma önga tödi ewe nang ibo balaure abo lalaa re ine. Ma tinenge ixo ot pösöt a asuono orong bara ina tene balaure laa ixo ösek tataunin abo tuluwok ke ine. ");
INSERT INTO bjk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Io, ixo kuwe ölaxa lo ina tene balaure lalaa ma ixo ose ine, ‘A sa inabo lalaa na nang e ölangen ulamun nöngön? Örö isik kebo tinenge maras ura lamun abo lalaa re e nang nöngön u xo balaure, möxösa, nöngön ökorobo a tene balaure lalaa baling im pe e.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ma a tene balaure lalaa ixo tengen öbaling iat tö ine, ‘Arabo pet a lasa im? A tödi raxin te e irabo kip tewe a tinörön kalik e. Me e kobo eöt lölös sua xikin, me e menge belek bara arabo seng tuluwok xarnang önga maris. ");
INSERT INTO bjk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","E ösöxö a lasa nang e rabo pet, io nang bara tabo kip tewe e xalik a tinörön te e ra, a nangadi tabo öga lo e xöbo gunon te idi.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Io, ine ixo kuwe ölaxa a öngöng mere idi nang toxo kip lo abo lalaa nang toxo seng lo xalik a asuono orong ke ine. Ixo ose a sisila ne tödi, ‘A nausen ne lalaa xö asuono orong ke e nang nöngön u xo kip lo?’ ");
INSERT INTO bjk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ma ixo balu, ‘A önga mar ne daram ne wel.’ “Ma tene balaure lalaa ixo tengen te ine, ‘Örö kis, ma saxit mon örö geet bara örobo balu wuxus a pitnö ne sangaun mon tua öxawam a dinau pe nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Io, ixo ose a sese öninöng ne tödi, ‘Ma nausen iang u xo kip lo?’ “Me ine ixo balu, ‘A önga arip ne bek wit.’ “Ma ixo tengen te ine, ‘Örö geet bara örobo balu wuxus a pitnö ma narun ne mar mon.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ma asuono orong ixo ölet ina tene balaure lalaa nang ixoro töxö ine, möxösa, ixo wewet inabo lalaa xarnang a tene nanase. Io, a nangadi nang tobo mumuu a mangana tatalien mera xö öxöno lagunon idi tobo nanase sik köbo mangana ngas sua wewet abo tinörön te idi. Xö ina tinörön na, idi tobo nanase xöba xö nangadi nang tobo mumuu a mangana tatalien möxö maras. ");
INSERT INTO bjk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Me e tengen te mum, mum morobo rörörön mabo tuluwok saban bara mum morobo kip lo rebo ais se mum, ma nang bara inabo tuluwok irabo kawam, tabo öga lo e mum kö kinis nang i karabo kawam. ");
INSERT INTO bjk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ewe nang tobo nunu sik ke ine bara ine i eöt tua balaure abo lalaa lixilik, tabo nunu sik bölök ke ine bara ine i eöt tua balaure abo lalaa rataxin. Me ewenene nang i kobo muu a tatalien töxödös kö lalaa lixilik, i karabo töxödös bölök köbo lalaa rataxin. ");
INSERT INTO bjk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Io, nang bere i kebeöt bara tabo nunu sik ke mum pua balaure abo tuluwok mera xö öxöno lagunon, io, ewenene irabo nunu sik im pe mum pua balaure abo bubulus turunon? ");
INSERT INTO bjk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma nang bere i kebeöt bara tabo nunu sik baling ke mum pua balaure abo lalaa xö öng kabise, kaim pe öng irabo tabaa e mum merebo lalaa ure mum iat. ");
INSERT INTO bjk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kaim pe önga tultul i öt tua ölangen a nini orong. Möxö ine irabo kasen a öng ma irabo mamaa ulamun a öng kabise, ma bara irabo araröt sik kö öng ma irabo melentexin a öng kabise. Io, mum kebeöt tua ölangen e God ma a tuluwok bölök.” ");
INSERT INTO bjk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Abo Parasi ewe nang tobo mamaa xöba lamun a tuluwok, toxo ölangen ina na ma toxo kaes e Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma ixo tengen te idi, “Mum iat mum bo ötöxödös öbaling e mum kö winara xö nangadi, nexalik e God i ösöxö sik abo bala mum. A lasanene a nangadi te döxömen öraxin kö dinödöm pe idi, i laa tataun kö wawara re God. ");
INSERT INTO bjk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Abo warkurai te Moses arixe mabo ginigeet köbo propet idi toxo warkurai ot kö axana bung ke Jon a tene baptais. Urulo xö ina axana bung na, tobo etöngösen ma a atöngösen deek möxö kingdom kö God, ma a nangadi xirip tobo lölölös sua nuan laxa xönan. ");
INSERT INTO bjk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nang bara i lölös kö watmaep ma öxöno lagunon ta xakawöm, io, i lölös köba bara re ulik ne xönö möxöbo warkurai te Moses irabo tup. ");
INSERT INTO bjk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ewe re öng nang i köröp alolo ma une re ine ma i elolo xö une xabise, ine i pet a tatalien saban kö une re ine, möxösa, ine i maru ma une kaim bara re ine. Ma önga tödi ewe nang i elolo a önga une nang a tödi i palas alolo re idu, i pet a tatalien saban, möxösa, ine i maru ma une kaim bara re ine. ");
INSERT INTO bjk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Önga asuono orong ewe nang ixobo sisige abo man mamaran nang a marna a lak kaa, ixobo xisixis kö kinis a lak deek kö bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma toxobo bulbulus a önga tödi maris kö marame laxlaxa re ine, a esene e Lasarus, ma a aine ixo wöwö ma ruxuruk. ");
INSERT INTO bjk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma ixobo mamaa xöba rua enen a lasanene nang ixobo susubu su xalik a öra ne nien möxö asuono orong, ma bung puluwun toxobo önan ot ma toxobo demdem abo ruxuruk ke ine. ");
INSERT INTO bjk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ma axana bung ixo ot nang ina tödi maris ixo met ma a bung angelo toxo kip lo ine uruso xö lawana e Abaram. Ma asuono orong bölök ixo met ma toxo pömös ine. ");
INSERT INTO bjk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kölöme xö xönö möxöbo minet ixo örasen a kinadik taxin. Ine ixo wawara kaa ma ixo pere e Abaram kö palaa arixe me Lasarus kö lawana. ");
INSERT INTO bjk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Io, ixo kup urungan te ine bara, ‘Tata Abaram, örö marase e ma örö tile e Lasarus, ira öwösö a sixsixine limine xö ari ma ira ösisii a kamene e, möxösa, e örasen a kinadik taxin kö ina ia sösöt na.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Inexalik e Abaram ixo balu, ‘Barok ke e, örö döxömen bara xöbo bungbung ne to re nöngön, u xo kip lo abo lalaa deek kö nöngön me Lasarus ixo kip lo abo lalaa saban. Ma na im ine i örasen a to deek, me nöngön iang kö kinadik. ");
INSERT INTO bjk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma önga laa bölök, kaluluonin e maa me nöngön, e God ixo bulus a marasaa raxin, io, ewe me idi nang te eka nuan mera urungan te nöngön, idi tekebeöt, ma kaim pe öng irabo köröp me ringan ura re maa.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ine ixo balu, ‘Möxö ina na, tata, e seng nöngön bara örö tile e Lasarus uri xö gunon te tata re e, ");
INSERT INTO bjk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","möxö e ma pitnö ne töke. Örö öbala ine bara ira ötumarang idi bere idi takarabo wan bölök ura xö ina xönö möxö kinadik.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abaram ixo balu, ‘Abo warkurai te Moses mabo ginigeet möxöbo propet nangen idi min. Ganim inabo töm tabo tame inabo tinenge.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ine ixo tengen, ‘Tata Abaram, kawaim, nexalik nang bara re öng meringan kö minet irabo wan urungan te idi, idi tabo dödöm puxus.’ ");
INSERT INTO bjk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Me Abaram ixo tengen tö ine, ‘Nang bere idi tokobo ölangen abo warkurai te Moses mabo ginigeet möxöbo propet, ma nang bara a öng i taru baling kalik a minet, i kebeöt tua öxaxat idi rua dödöm puxus.’” ");
INSERT INTO bjk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ixo tengen köbo bak ne ausu re ine: “Abo lalaa nang ibo usubu a nangadi xö magingin saban irabo wanot, nexalik, maris belek ke ine nang irabo ösubu a marakörö bira. ");
INSERT INTO bjk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nang bara ewenene i pet a öng mere inabo barok lixilik na ewe idi te nunu re e rua pet magingin saban, irabo kip a warkurai taxin melamu. Io, ixere deek kö ine bara texere kut te xönö wat taxin kö inöno ma texere öriri ösu ine xö rasi, xalik ibo engin lo re öng kua pet magingin saban. ");
INSERT INTO bjk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Io, mum morobo balaure öbaling e mum iat. “Nang bara a töm i pet magingin saban, örobo köö ine. Ma nang bara i dödöm puxus, örobo döxömen taun a magingin saban te ine. ");
INSERT INTO bjk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma nang bara i pet magingin saban urungan te nöngön kö pitnö ma ninöng ne axan kö önga bung, ma pitnö ma ninöng ne axan ine i ot baling ma i tengen te nöngön, ‘E re dödöm puxus,’ örobo döxömen taun ine.” ");
INSERT INTO bjk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Mabo aposol toxo tengen kö Orong, “Örö öraxin a nunu re mem!” ");
INSERT INTO bjk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma Orong ixo tengen te idi, “Nang bara a nunu re mum i lik köba xarnang a irine sie, mum mo eöt ta tengen kö ina uno iaa na, ‘Örö tamaxaxat ma örö tuu baling kö rasi!’ Ma irabo ölangen e mum. ");
INSERT INTO bjk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Rösa? Nang bara öng mere mum ma a tene tinörön i rörörön komo, bara i werwere muu abo sipsip, ma i baling ot meriso xö komo, ma saxit mon a orong ke ine irabo tengen te ine, ‘Örö miang im, örö kis ma örö an’? ");
INSERT INTO bjk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kaim. Irabo tengen belek bira, ‘Örö tagure a nien te e, ma örö kulas man ma örö tabaa e. Ma nang bere e re an ma bere e re inim, melamu xö nang, nöngön örobo an ma örobo inim.’ ");
INSERT INTO bjk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mum mo döxömen bara a orong irabo tengen deek kö tene tinörön, möxösa, ixo pet eörin abo lalaa nang ine ixo tengen te ine rua wewet? Kaim. ");
INSERT INTO bjk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Io, mum bölök, nang bere mum moro pet kirip abo lalaa nang a Orong ke mum ixo tengen te mum pua wewet, io, mum morobo mana tengen bira, ‘Mem abo tene tinörön tataun mon. Mem me wewet mon abo lalaa nang i deek bere mem marabo pet.’” ");
INSERT INTO bjk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Io, xö nuan te ine u Jerusalem, Jisas ixo wan muu a wapang kaluluonin e Samaria me Galili. ");
INSERT INTO bjk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nang ine ixo önan urungan kö önga lagunon, a sangaun ne tödi toxo eka asuo me ine, ma lamun toxo tuu sik kö palaa ulik, möxösa, idi ma lepra. ");
INSERT INTO bjk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Io, idi toxo kup lömö saxit, “Jisas, tödi raxin, örö marse e mem!” ");
INSERT INTO bjk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nang ixo pere idi, ixo tengen, “Moro wan, moro osen e mum iat köbo pris.” Io, nang idi toxo önan, a miniset te idi ixo kawam kö ngas. ");
INSERT INTO bjk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Öng mere idi, nang ixo pere bara ixoro deek, ixo baling, ma ixo ölet e God ma ixo xukup lömö saxit. ");
INSERT INTO bjk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ixo tewe ösu ine xö pu xö nine xexene e Jisas, ma ixo tengen deek ke ine. Me ine a önga Samaria. ");
INSERT INTO bjk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisas ixo eose, “A sangaun idi xirip nang idi te langlanga. Ma a pitnö ma nit ule? ");
INSERT INTO bjk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rösa ina osee na xalik mon i tawuxus baling kua ölelet e God?” ");
INSERT INTO bjk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Io, ixo tengen te ine, “Taru ma örö wan. A nunu re nöngön iri ölanglanga nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Önga bung, abo Parasi toxo ose e Jisas, “A axana bung sa a kingdom kö God irabo wanot?” Me Jisas ixo balu, “A kingdom kö God i karabo ot xarnang önga auxileng nang a marakörö tabo pere ma marana idi. ");
INSERT INTO bjk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Me idi takarabo tengen bara, ‘Ine na,’ ma bara ‘Ine niang,’, möxö a kingdom kö God ine iang me mum.” ");
INSERT INTO bjk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Io, ixo tengen köbo bak ne ausu re ine, “A axana bung irabo ot nang mum morobo mamaa xöba rua werwere a öng möxöbo bung kö Barok kö Tödi, nexalik bara mum korobo pere. ");
INSERT INTO bjk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma nangadi tabo tengen te mum, ‘ine niang!’ ma bara ‘Ine na!’ Mum bele ululo rup muu idi. ");
INSERT INTO bjk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Xö bung iat te ine, a Barok kö Tödi irabo xarnang a siek nang irabo siek, ma irabo mararang lömö xö balana kubu möxö önga ngusuno urungan kö önga ngusuno xabise. ");
INSERT INTO bjk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Inexalik mon, a sisila ne laa, ine irabo kip a kinadik lamun abo lalaa oleleng, ma marakörö mee nixinen tabo kasen ine. ");
INSERT INTO bjk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Xö axana bung kö Barok kö Tödi, a nangadi tabo talien xarnang a nangadi xöbo bung ke Noa. ");
INSERT INTO bjk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A nangadi toxobo aan, toxobo ininim, ma toxobo laxlaxa xöbo alolo ot kö bung nang e Noa ixo wan laxa xö mön taxin. Io, a gus ixo wanot ma ixo ögarin esexerein kirip idi. ");
INSERT INTO bjk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ma ixo eöt ma abo bung ke Lot. A nangadi toxo aan ma toxo ininim, toxo xuxuxun ma toxo mimiisik, toxo susulo ma toxo wewet gunon. ");
INSERT INTO bjk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma lamun a bung nang e Lot ixo wan lie e Sodom, a ia sösöt ma solam ixo subu su meriso xö watmaep ma ixo ögarin esexerein idi xirip. ");
INSERT INTO bjk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Irabo xarnang ina niang kö bung nang a Barok kö Tödi irabo wanot wösö. ");
INSERT INTO bjk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ma xö ina bung, ewe a öng nang i kisisik lömö xö öxöno gunon te ine, mabo lalaa deek ke ine kölöme xina gunon, ganim bara i kaa su ra xikip lo. Ma irabo bie bölök ke ewenene nang i xisixis siso xö komo, ganim bara i su uri xö gunon ta xikip lo re laa. ");
INSERT INTO bjk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mum morobo döxömen a usuono e Lot! ");
INSERT INTO bjk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ewenene nang i mamaa ra rörödik a to re ine, irabo ömalim tewe, me ewe niang i ömalim tewe a to re ine, ine irabo töndik sik. ");
INSERT INTO bjk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","E tengen te mum bara a ninöng idu tabo maru xö önga öra xö ina bung dömön, tabo kip lo a öng ma tabo gan sik a öng. ");
INSERT INTO bjk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A nini une idu tabo xuxu abo irine wit arixe. Tabo kip lo a öng ma tabo gan sik a öng uxe.” ");
INSERT INTO bjk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Idi toxo eose, “Orong, ule?” Jisas ixo balu idi, “Xöbo xönö sa nang abo minet könan, abo tago tabo oretok ee.” ");
INSERT INTO bjk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Io, Jisas ixo töngösen abo bak ne ausu re ine ma tinenge öwuo rua osen idi bere idi tabo mana seseseng sösöxö ma ganim a lönlön. ");
INSERT INTO bjk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ine ixo tengen, “Kölöme önga lagunon i nangen a önga tene pet warkurai ewe nang i kara ösöxö a buburin e God ma i kara niniang muu a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kölöme xina lagunon a önga möxösö ewe nang ixobo önan ot sösöxö wösöt ine arixe ma siniseng bara, ‘A iuo re e i mamaa rua ögarin e, ma örö kure ötöxödös e maa.’ ");
INSERT INTO bjk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Xö uleng ne axana bung sila ixobo mölmölök kua rorop ine. Ma lamun ine ixo döxömen, ‘A turunon e kara ösöxö a buburin e God me e kara niniang muu a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Inexalik ina möxösö na ibo tabaa e ma tiip. Möxö ina na, e rabo kure ötöxödös abo lalaa rua rorop ine, bara xalik ine ibo ölön e ma nuanot sösöxö!’” ");
INSERT INTO bjk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Orong ixo tengen, “Mum moro ölangen a lasa nang a tene pet warkurai saban ixo tengen. ");
INSERT INTO bjk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ma irabo bie lamun a nangadi re God nang ine ixo pere kos, ewe nang tobo seseseng urungan te ine xö xaken ma dömön. Turunon saxit, irabo kure ötöxödös abo lalaa rua rorop idi. Mum mo döxömen bara ine irabo alilis sua rorop idi? Kaim. ");
INSERT INTO bjk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","E tengen te mum, ine irabo kure ötöxödös pasaxit abo lalaa rua gene idi. Ma lamun nang bara a Barok kö Tödi irabo wanot, ine irabo parasiwin a nunu xö öxöno lagunon bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Me Jisas ixo tengen a tinenge öwuo na urungan kö dauleng ewe nang toxo döxömen bere idi te töxödös sik iat ma te pere öbulubun a nangadi xabise: ");
INSERT INTO bjk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nine tödi toxo wan kaa uruso xö gunon lotu raxin tua siniseng, önga Parasi ma önga tene kip takis. ");
INSERT INTO bjk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Parasi ixo tuu kaa ma ixo seseng lamun ine iat bira, ‘God, e tengen deek ke nöngön bere e kobo xarnang a dauleng ne nangadi xabise nang abo tene pinilo, abo tene atöxö, ma abo tene minaru arixe mabo une nang kaim bere re idi. E tengen deek bere e kobo xarnang ina tene kip takis bölök. ");
INSERT INTO bjk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","E bo ölölö a nine bung kölöme xö pitnö ma ninöng ne bung, me e bo isik a nang i sangaun min möxöbo laa xirip nang e bo xikip.’ ");
INSERT INTO bjk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma lamun a tene kip takis ixo tuu xö palaa. Ine ixo kaim kö winara kaa uruso xö watmaep, ma ixo sese a böngböngöno ma ixo tengen, ‘God, marse e, e a tene saban.’ ");
INSERT INTO bjk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“E tengen te mum bara ina tödi na ixo baling urungan kö gunon te ine, ine ixo töxödös kö wawara xö God ma öng kabise, kaim. Io, ewenene nang i ii öraxin ine, God irabo bulus ösu ine, me ewenene nang i ii ölik ine, God irabo ii öxaa ine.” ");
INSERT INTO bjk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nangadi toxo xikip ot bölök a bung barok lixilik urungan te Jisas sö ine ra sisigi idi. Nang abo bak ne ausu toxo pere bira, idi toxo töö rewe idi. ");
INSERT INTO bjk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma lamun e Jisas ixo kuwe a bung bak lixilik urungan te ine ma ixo tengen, “Moro ganim a bung bak lixilik ta wan ura re e, ma ganim a wanwanak idi, möxösa, a kingdom kö God, ine möxö inabo mangana bak lixilik bira. ");
INSERT INTO bjk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Turunon saxit, nang bara öng i kobo kip lo ina kingdom kö God xarnang a bak lik, ine i kebeöt ta nilaxa xönan.” ");
INSERT INTO bjk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma önga sisila ixo ose ine, “Tene ausu deek, a lasa nang arabo mana pet tua xikip ina to ulorexe saxit?” ");
INSERT INTO bjk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Io, Jisas ixo balu ma ixo tengen, “Ruasa u tengen e ma tödi deek? Kaim pe öng i deek, nexalik e God kalik mon. ");
INSERT INTO bjk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U ösöxö abo warkurai te Moses i tengen bira, ‘Ganim a pet a tatalien ne ilawa ma önga tödi alolo, ganim a arsexomet tataun, ganim a wuwulo, ganim a tengen töxö lamun a önga tödi, ma örö ii ölik nöngön te tata me nago.’” ");
INSERT INTO bjk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ina tödi ixo tengen te Jisas, “Nang e xo bak lik sik, e xobo mumuu inabo warkurai i ot na.”. ");
INSERT INTO bjk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma nang e Jisas ixo ölangen ina na, ixo tengen te ine, “Önga laa xalik mon u koxobola pet eörin bang. Örö misik mabo laa xirip nang nöngön min ma örö tabaa a nangadi maris, io nang, nöngön örobo kip abo arabaa deek saxit tiso xö watmaep. Ma örö miang ma örö muu e.” ");
INSERT INTO bjk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nang ine ixo ölangen bira, ixo tawunuk köba, möxösa, ine a tödi orong. ");
INSERT INTO bjk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Me Jisas ixo pere ine ma ixo tengen, “I lölös köba xö önga tödi orong kua nilaxa xö kingdom kö God! ");
INSERT INTO bjk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nang bara önga kamel i ka nuan laxa xö mara möxö nil möxö sinöxö, i kobo lölös köba xarnang a tödi orong i ka nilaxa xö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ewe midi nang toxo ölangen ina na, toxo tengen, “Nang bara bie, ewe im pe öng irabo eöt ta xikip a to ulorexe?” ");
INSERT INTO bjk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas ixo tengen, “A lasa nang a nangadi tekebeöt ta wewet, God i eöt ta wewet.” ");
INSERT INTO bjk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Me Pita ixo tengen te ine, “Mem mere wan lie xirip abo lalaa re mem rua mumuu e nöngön!” ");
INSERT INTO bjk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisas ixo tengen, “Turunon saxit, ewe nang iri wan lie a gunon tine, bara a une, bara a tata ma nago, bara abo tönö ma a bung baroxorok kua gene a kingdom kö God, ");
INSERT INTO bjk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","irabo kip lo a oleleng baling kö ina axana bung na. Ma xö axana bung nang irabo ot melamu, ine irabo kip a to ulorexe saxit.” ");
INSERT INTO bjk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas ixo lamus ina sangaun ma ninöng urungan kö lawa ma ixo tengen te idi, “Ire tabo wan kaa uruso Jerusalem, mabo lalaa xirip nang abo propet toxo geet ulamun a Barok kö Tödi irabo wanot turunon. ");
INSERT INTO bjk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ma tabo isik ine xö limine a nangadi nang kaim bara abo Judeia. Tabo eösaxit saban arixe me ine, ma tabo tengen ögarin ine, tabo gisip ine, tabo dangat ine ma tabo sexomet ine. ");
INSERT INTO bjk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Narun ne bung irabo saxit, ine irabo taru baling.” ");
INSERT INTO bjk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Abo bak ne ausu kaim kö marmaras ulamun te laa niang ine ixo wöwörö min, möxösa, a unine toxo umingen kalik idi, me idi tokoxobo ösöxö a lasa nang ine ixo rengrenge ulamunon. ");
INSERT INTO bjk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ma nang e Jisas ixo önan ot Jeriko, önga tödi marapulo ixo kisisik kö gegene ngas ma ixobo seseng lalaa xalik a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma nang ine ixo ölangen a marakörö toxo önan saxit, ine ixo eose bara, “A lasa iang?” ");
INSERT INTO bjk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Idi toxo tengen te ine, “E Jisas mee Nasaret ine ia i önan saxit.” ");
INSERT INTO bjk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Me ine ixo kup bara, “Jisas, a Barok kö marapun te Dewit, örö marase e!” ");
INSERT INTO bjk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Me idi nang toxo silien a nuan, toxo töö rewe ine ma toxo tengen te ine rua ödödö, nexalik bere ine xö kup taxin belexim, “Barok kö marapun te Dewit, örö marase e!” ");
INSERT INTO bjk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisas ixo tuu ma ixo euguran ulamun ina tödi bara ta lamus ot ine ura re ine. Ma nang ine ixo ot lörörö, Jisas ixo ose ine, ");
INSERT INTO bjk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“U mamaa bara arabo pet a lasanene re nöngön?” Ine ixo tengen bira, “Orong, e mamaa bara arabo wawara.” ");
INSERT INTO bjk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisas ixo tengen te ine, “Örö wawara! A nunu re nöngön iri öro nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Saxit mon iang, a marna ixo öt ta winara ma ixo muu e Jisas, ma ixo ölet nanin e God. Ma nang a nangadi xirip toxo pere ina na, idi bölök toxo ölet e God. ");
INSERT INTO bjk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas ixo wan laxa Jeriko ma ixo önan saxit tingan. ");
INSERT INTO bjk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma önga tödi ringan, a esene e Sakias. Ine a önga tödi raxin te idi abo tene kip takis ma a orong bölök ine. ");
INSERT INTO bjk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ine ixo mamaa ra werwere e Jisas bere ewe ine, nexalik ine ixo wuruwut ma ixo kebeöt, möxösa, a marakörö raxin köba. ");
INSERT INTO bjk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Io, ine ixo ulo sila ma ixo kakaa xö önga uno sikamo rua werwere e Jisas, möxö ine ixo önan kina ngas. ");
INSERT INTO bjk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ma nang e Jisas ixo ot kina xönö, ine ixo wawara kaa ma ixo tengen tö ine, “Sakias, örö wan su saxit mon, möxösa, nixinen e rabo mana kis kö gunon te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Io, saxit mon ine ixo kakaa su ma ixo öga lo ine ma axanan. ");
INSERT INTO bjk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A nangadi xirip toxo pere ina na ma toxo urulo ra ngunungun. Idi toxo tengen bira, “Ina tödi na iri wan tua nien arixe ma a tene saban.” ");
INSERT INTO bjk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Me Sakias ixo tuu kaa ma ixo tengen kö Orong bira, “Orong! Örö pere! Na arabo palang kaluluon abo lalaa re e ma arabo isik ke subana xö nangadi maris. Ma nang bere e xoro töxö re öng me e xoro pulo re önga laa, io, e rabo balu wuxus ma nit ne laa baling.” ");
INSERT INTO bjk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas ixo tengen tö ine, “Nixinen a to maxat iri wanot kö ina gunon na, möxösa, ina tödi na ine bölök a barok ke Abaram. ");
INSERT INTO bjk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ma möxö a Barok kö Tödi iri wanot tua wawara siwin ma rua öro idi nang te tup.” ");
INSERT INTO bjk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma nang a nangadi angen toxo ölangen tinenge, Jisas ixo tengen a önga tinenge öwuo urungan tö idi, möxösa, ine ixo lörörö Jerusalem ma a nangadi toxo döxömen bara a kinis ne kingdom kö God iri lörörö rua nuanot. ");
INSERT INTO bjk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ma ixo tengen, “A önga tödi raxin i mamaa rua nuan urungan kö önga lagunon kö palaa bara tabo tabaa ine ma a kinis ne warkurai te ine ma melamu ine irabo tawuxus baling. ");
INSERT INTO bjk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Io, ixo kuwe a sangaun möxöbo tultul te ine ma ixo tabaa idi öngöng ma önga tuluwok. Ma ixo tengen tö idi bira, ‘Mum moro rörön arixe mina tuluwok na ot nang arabo wanot baling.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ma a nangadi möxö ina lagunon te ine toxo melentexin ine. Idi toxo tile a dauleng ne nangadi ra mumuu ine ma tinenge rua rengrengen bere idi tokoxobo mamaa bara ina tödi irabo kure idi. ");
INSERT INTO bjk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Inexalik, toxo isik ina kinis ne warkurai te ine ma ixo tawuxus baling urungan lagunon. Io, ine ixo euguran lamun abo tultul ewe idi nang ine ixo tabaa idi ma tuluwok kua rengrengen ömaras ine ma tinörön ma tuluwok.” ");
INSERT INTO bjk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Io, a öng ixo sila ot ma ixo tengen tö ine, ‘Orong, a tuluwok ke nöngön i wan kaa xö sangaun.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“A orong ke ine ixo tengen tö ine, ‘Deek saxit, nöngön a tultul deek! Nöngön u xo pet a tinörön deek kö laa a lak lik köba, io niang, e rabo tabaa nöngön ma sangaun ne lagunon tua balbalaure.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ma a sese öninöng ixo wanot ma ixo tengen, ‘Orong, a tuluwok ke nöngön i wan kaa xö pitnö.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ma a orong ke ine ixo tengen tö ine, ‘Örö balaure a pitnö ne lagunon.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Io, önga tultul bölök ixo wanot ma ixo tengen, ‘Orong, a tuluwok ke nöngön na. E xo bulus umingen tewe kölöme xö xönö subana man. ");
INSERT INTO bjk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","E xo burin nöngön, möxösa, nöngön a tödi möxö tenge oleleng. Nöngön u bo kip lo a lasa nang u koxobo sulo. Ma u bo xikip lo a inone malawang köbo dauleng kabise.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“A orong ke ine ixo tengen, ‘Nöngön a tultul saban! E rabo kure nöngön mabo tinenge re nöngön iat. Nöngön u tengen bara u xo ösöxö bere e a önga tödi möxö tenge oleleng. Ma u tengen bölök bere e bo xikip lo a lasa nang e koxobo sulo, me e bo xikip lo a inone malawang köbo dauleng kabise. ");
INSERT INTO bjk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ruasa nang nöngön u koxobo bulus a tuluwok ke e xö gunon ne bulus tuluwok, io, nang arabo wanot baling, e xebe kip lo ma dauleng bölök lömö?’ ");
INSERT INTO bjk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Io, ine ixo tengen te idi nang toxo tuu sik, ‘Mum moro mana kip tewe ina tuluwok kalik ine me mum moro isik ine xö tultul nang i kip lo a sangaun ne tuluwok.’ ");
INSERT INTO bjk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Idi toxo tengen te ine, ‘Orong! Ine ma sangaun tuar!’ ");
INSERT INTO bjk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ine ixo balu, ‘E tengen te mum bara ewenene midi nang idi ma lalaa, God irabo tabaa idi ma oleleng. Ma lamun ewenene midi nang kaim a lalaa, God irabo kip tewe bölök kirip abo lalaa. ");
INSERT INTO bjk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Inexalik abo iuo re e ewe idi nang tokoxobo mamaa bere e rabo king ke idi, moro lamus ot idi ura ma moro sexomet idi xö wawara re e.’” ");
INSERT INTO bjk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Melamu nang e Jisas ixo tengen ina tinenge na, ine ixo wan sila uruso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma nang ine ixo wanot lörörö Betepage me Betani xö maii tobo rengrengen ma Maii Olip, ixo tile a nine bak ne ausu re ine, ma ixo tengen tidu bara, ");
INSERT INTO bjk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mu moro wan urungan kö lagunon mesila re mu, ma nang bere mu mo laxa xönan, mu morobo pere a önga dongki maxat te kubus sik ine ee, ma kaim bang ke öng i kala xisin ine. Mu morobo palas tewe ine ma morobo lamus ot ine ura. ");
INSERT INTO bjk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma nang bara önga tödi i ose e mu bara, ‘Ruasa mu mo walwalas ina dongki na?’, io, mu morobo tengen te ine bira, ‘A Orong i mamaa ulamun.’” ");
INSERT INTO bjk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Io, ewe idu nang ixo tile, idu toxo wan lo ma toxo pere a lasa ixo ot xarnang e Jisas ixo tengen tö idu. ");
INSERT INTO bjk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma nang idu toxo walwalas lo ina dongki, a tamana dongki ixo ose idu, “Mu mo walwalas lo a dongki ruasa?” ");
INSERT INTO bjk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Me idu toxo balu bara, “A Orong i mamaa ulamun.” ");
INSERT INTO bjk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Io, idu toxo lamus ot ina dongki urungan te Jisas me idu toxo bulus abo man ömat te idu lömö xina dongki maxat tue Jisas sua kinis kaa. ");
INSERT INTO bjk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma nang ine ixo önan nana, a nangadi toxo kip tewe abo xinaxain te idi ma toxo parawe xö ngas. ");
INSERT INTO bjk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma nang ine ixo wanot lörörö xö lagunon nang a ngas i wan su uri xö Maii Olip, a marakörö ne bak ne ausu xirip toxo urulo ra axanan tua ölelet e God ma kinup taxin ulamun abo lalaa lölös ne auwuwus kirip nang idi toxo pere. Me idi toxo kup uruso bira, ");
INSERT INTO bjk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“God irabo wadöane ina king nang i wanot tua wewet eörin a mamaa xö Orong!” “A malum uso lömö xö watmaep ma a mariris meriso lömö saxit!” ");
INSERT INTO bjk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Dauleng möxöbo Parasi kaluluonin kö marakörö toxo tengen te Jisas, “Tene ausu, örö köö abo bak ne ausu re nöngön!” ");
INSERT INTO bjk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ine ixo balu, “E tengen te mum, nang bere idi tabo kis malus, abo warawat tabo kup wösö.” ");
INSERT INTO bjk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ma nang ine ixo ot lörörö Jerusalem, ine ixo pere ina lagunon me ine ixo gee ulamunon. ");
INSERT INTO bjk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ixo tengen, “Mum mee Jerusalem, e mamaa xöba bara nixinen mum iat morobo ösöxö a lasa irabo isik ot a malum pe mum. Ma lamun na iri mun tewe xalik abo marana e mum. ");
INSERT INTO bjk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Abo bung irabo ot pösöt e mum nang abo iuo re mum tabo bulus ögun a warawat ma pu rua kinös köröp abo bölö möxö lagunon te mum, ma tabo tuu elulurwein e mum, ma tabo tuu wi abo xönö xirip kalik mum bo ulo rup. ");
INSERT INTO bjk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Idi tabo tewe ösu e mum uri xö pu, mum arixe ma bung baroxorok ke mum kölöme xö lagunon te mum. Idi tekebeöt ta gan sik ke wat lömö xere öng kabise, möxösa, mum koxobo perexulen a axana bung nang e God ixo ot tua rorop e mum.” ");
INSERT INTO bjk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Io, Jisas ixo laxa xö xönö möxö gunon lotu raxin ma ixo urulo ra batbat ösu ewe me idi nang toxo mimiisik kölöme. ");
INSERT INTO bjk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ixo tengen te idi, “A tinenge re God nang toxo geet i tengen bira, ‘A gunon te e, ine irabo a gunon ne sineseng.’ Inexalik bere mum iat mum mo pet ine xarnang ‘a gunon ne minun möxö nangadi pinilo.’” ");
INSERT INTO bjk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma xöbo bungbung kirip ine ixobo eusu xö gunon ne lotu raxin. Inexalik abo pris tataxin, abo tene ausu möxöbo warkurai te Moses mabo tene sisila kaluluonin a nangadi toxo mamaa ra sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma lamun idi tekebeöt tua wewet te önga laa re ine, möxösa, a nangadi xirip toxo mamaa rua ölangen kirip abo tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Önga bung nang e Jisas ixo usu a nangadi kölöme xö xönö raxin möxö gunon ne lotu raxin ma ixo etöngösen ma tinenge deek, abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, arixe mabo sisila, toxo ot pösöt ine. ");
INSERT INTO bjk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Me idi toxo tengen te ine bira, “Örö tengen te mem, nöngön u kip lo ina ese raxin na mole nang nöngön u döxömen bere i töxödös se nöngön ta wewet inabo lalaa na? Me ewe i tabaa nöngön mina lölös na?” ");
INSERT INTO bjk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Me ine ixo balu ma ixo tengen, “E rabo ose e mum ma önga ineose bölök. Ma moro tengen te e, ");
INSERT INTO bjk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a baptais se Jon, ine meriso lömö re God, bara mera xö nangadi mon?” ");
INSERT INTO bjk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Idi toxo wöwörö min kaluluonin idi iat ma toxo tengen, “Nang bere ire te tengen bara, ‘Meriso re God,’ ine irabo ose ire bara, ‘Ma ruasa me mum koxobo nunu re ine?’ ");
INSERT INTO bjk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma lamun nang bara ire te tengen bara, ‘Möxö nangadi mon,’ a nangadi xirip tabo teng ire ma warawat, möxösa, idi te nunu lölös bere Jon a önga propet.” ");
INSERT INTO bjk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Io, idi toxo balu, “Mem kobo ösöxö ina lölös na i wanot mole.” ");
INSERT INTO bjk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Me Jisas ixo tengen tö idi, “E bölök, e karabo tengen te mum ewe i isik ina lölös na re e ra wewet inabo lalaa na.” ");
INSERT INTO bjk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Me ine ixo urulo ra rengrengen ina tinenge öwuo na xö nangadi: “A tödi ixo sulo a komo wain, ma ixo isik ina komo wain urungan köbo duöng kua tinörön könan ma ixo wan lo bang kalik ma ixo kis ömat kö ina lagunon. ");
INSERT INTO bjk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ma xö axana bung möxö dixidik a pasuno wain ine ixo tile a önga tene tinörön urso xöbo tene werwere muu wain bara tabo tabaa ine ma rebo pasuno wain möxö komo. Ma lamun abo tene werwere muu wain toxo tödik ine ma toxo se ine ma toxo uguran tewe öbaling ine ma kaim a xikip pe pasuno wain. ");
INSERT INTO bjk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ine ixo tile öbaling önga tene tinörön, ma lamun toxo se bölök ine, ma toxo ömenge ine ma toxo uguran puxus öbaling ine ma kaim a xikip pe pasuno wain. ");
INSERT INTO bjk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Io, ine ixo tile öbaling a öng sese önarun min, me idi toxo se ögarin ine ma toxo tewe ösu ine. ");
INSERT INTO bjk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Io, a tamana komo wain ixo tengen, ‘A lasa e rabo pet? E rabo tile a bak ke e nang e bo mamaa xöba lamun. Nagut idi tabo ii ine.’ ");
INSERT INTO bjk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Inexalik nang abo tene werwere muu a komo wain toxo pere ine, idi toxo wöwörö re idi iat. Me idi toxo tengen bara, ‘Ina tödi niang i öt ta unan lo ina komo wain te tamana umelamu. Ire ta sexomet ine me ire tabo unan lo abo lalaa re tamana.’ ");
INSERT INTO bjk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Io, idi toxo tewe ösu ine xalik a komo wain, ma toxo sexomet ine. “Io, a tamana komo irabo perim a lasa urungan tö idi? ");
INSERT INTO bjk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ine irabo wanot ma irabo sexomet inabo tene werwere muu a komo wain ma irabo isik ina komo wain urungan kö nangadi xabise.” Ma nang a nangadi toxo ölangen bira, idi toxo tengen, “Kaim tunon sik iat!” ");
INSERT INTO bjk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas ixo pere dik idi ma ixo ose, “Nang bara mum mo döxömen bira, mum moro mana dödöm ulamun a unine ina tinenge möxö God toxo geet, i tengen bira: “‘A wat nang abo tene pet gunon toxo kumamaa lamun, möxösa, idi toxo döxömen bara a laa tataun, i wawara bara ine bölök a lölös möxö unine gunon kirip.’ ");
INSERT INTO bjk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Me ewe nang i subu xö ina wat na irabo tawörök lixilik, nexalik ine irabo pörök ke öng nang bara i subu lömö rine.” ");
INSERT INTO bjk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma saxit mon abo tene ausu möxöbo warkurai te Moses mabo pris tataxin toxo wawara siwin te ngas sua rörön dik e Jisas, möxösa, idi toxoro ösöxö bere Jisas ixo wöwörö eöt me idi ma ina tinenge öwuo na. Ma lamun idi toxo burin a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Io, idi abo sisila toxo werwere muu e Jisas. Me idi toxo tile a dauleng ne tene winara suxume. Me idi toxo töxö bere idi a dauleng ne tene töxödös, rue idi ra uxun ine xöbo tinenge re ine ma bara tabo isik ine xö limine a sisila raxin mee Rom. ");
INSERT INTO bjk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Me idi abo tene winara suxume toxo ose ine bara, “Tene ausu, mem me ösöxö bara nöngön u bo wöwörö ma u bo eusu ma lalaa a lak töxödös, ma bara nöngön u kara ösöxö ra tinuu arixe mere önga tödi xalik mon. Ma lamun nöngön u bo usu a nangadi ma turunon ulamun a ngas nang e God i mamaa bara ire tabo muu. ");
INSERT INTO bjk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","I töxödös se ire bara tabo kun takis kö king taxin mee Rom bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Inexalik e Jisas ixoro ösöxö xulen a tinenge atöxö re idi ma ixo tengen tö idi, ");
INSERT INTO bjk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mum moro osen e ma re tuluwok. Ma re we ina wawara na ma ese sa xönan?” ");
INSERT INTO bjk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Me idi toxo balu bere, “Re king taxin mee Rom.” Ma ixo tengen te idi, “Io, mum morobo isik ke king taxin a lasa nang ke king taxin. Ma a lasa nang ke God, mum morobo isik ke God iat.” ");
INSERT INTO bjk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Me idi toxo kaim kö eöt ta uxun ine kölöme xö lasa nang ine ixo rengrengen kö wawara xö marakörö. Idi toxo kis malus, möxösa, idi toxo wuwus kö babalu re ine. ");
INSERT INTO bjk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Dauleng ne Sadiusi niang tobo nunu bara kaim pe tinaru baling kalik a minet, toxo ot pösöt e Jisas ma toxo ose ine bara, ");
INSERT INTO bjk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tene ausu, Moses ixo geet tö ire bira, nang bara önga tödi, kaim ine mere barok ma i met kalik a une re ine, io, a tönö ina tödi irabo ot lamun ina möxösö ma irabo kip barok kö ina tönö. ");
INSERT INTO bjk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Io, a pitnö ma ninöng ne barön. A sisila ixo elolo a une ma ixo met ma kaim a barok. ");
INSERT INTO bjk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ma a tönö mumuu lo ine ");
INSERT INTO bjk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ma sese önarun toxo ot lamun ina une, ma xö ina mangana ngas idi xirip a pitnö ma ninöng toxo met, ma kaim idi mere bung barok. ");
INSERT INTO bjk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma melamu im, a une bölök ixo met. ");
INSERT INTO bjk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Io, xö axana bung nang bara abo minet tabo taru baling, ine irabo a une re ewe runon? Möxö idi xirip ina pitnö ma ninöng toxo ot lamun ine.” ");
INSERT INTO bjk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas ixo balu idi, “A nangadi nang te to nixinen idi te elolo. ");
INSERT INTO bjk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Inexalik i karabo bie bira rö idi nang God ixoro pere kos lo idi bara tabo eöt ta nilaxa xö axana bung melamu ma xö tinaru baling kalik a minet. Idi tekarabo eöt ta inalolo. ");
INSERT INTO bjk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma takarabo met baling, möxö idi te xarnang abo angelo. Idi a bung baroxorok ke God, möxösa, idi te taru kaa baling kalik a minet. ");
INSERT INTO bjk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma lamun e Moses iat i osen bara abo minet tabo taru kaa baling. I kis kölöme xö pii möxö iaa, nang ine ibo rengrengen bere a Orong bara ‘a God te Abaram, a God te Aisak ma bara a God te Jekop.’ ");
INSERT INTO bjk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ine kaim bara a God möxö nangadi minet. Kaim! Inexalik ine a God möxö nangadi to, möxösa, xö winara re God idi xirip te to.” ");
INSERT INTO bjk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A dauleng ne tene ausu möxöbo warkurai te Moses toxo tengen te ine, “Tene ausu, a babalu deek ke nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma abo tödi xabise toxo buut tua ose öbaling ine merebo inausu bölök. ");
INSERT INTO bjk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Me Jisas ixo tengen tö idi, “Bara bule tobo rengrengen bara ine a Mesaia a barok tubuno e Dewit? ");
INSERT INTO bjk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","E Dewit iat i tengen ömaras kölöme xö Buk ne Sinö bara, “‘God a Orong ixo tengen kö Orong ke e bara: “Nöngön örö kis kö lawa tuun te e ");
INSERT INTO bjk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ot nang e rabo bulus ösu abo iuo re nöngön kö pu, xarnang a laa möxö bulus xexe.” ’ ");
INSERT INTO bjk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit i tengen ine me ‘Orong.’ Io, bule nang bara ine a Mesaia ma irabo a tubuno Dewit bölök?” ");
INSERT INTO bjk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ma nang a nangadi xirip toxo ölöngö, Jisas ixo tengen köbo bak ne ausu re ine, ");
INSERT INTO bjk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tumarang e mum kalik abo tene ausu möxöbo warkurai te Moses. Idi tobo mamaa rua önan nana ma boxönö man ömat ma tobo mamaa bara tabo xukuwange idi kölöme xö boxönö möxö mismisik, ma tobo werwere kos lo abo kinis deek kölöme xö gunon ne siniseng, ma tobo mamaa rua xikip lo a kinis deek kö axana bung möxö nien tataxin. ");
INSERT INTO bjk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Idi tobo kip lo abo lalaa möxöbo möxösö ma tobo osesen mabo sineseng ömat te idi. E God irabo ömokorot köbanin inabo mangana nangadi na.” ");
INSERT INTO bjk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ma nang e Jisas ixo wawara, ixo pere abo duöng orong toxo bubulus abo tuluwok ke idi kölöme xö xönö möxö bubulus kö gunon lotu raxin. ");
INSERT INTO bjk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ine ixo pere bölök önga maris ne une möxösö ixo bulus ölaxa a nine peni re ine. ");
INSERT INTO bjk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas ixo tengen, “Turunon saxit, ina maris ne une möxösö na, iri bulus ölaxa a oleleng köba re idi xirip kabise. ");
INSERT INTO bjk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ina nangadi xirip na te isik abo arabaa re idi meringan kalik abo kinis ne orong ke idi, ma lamun ina une maris i bulus ölaxa xirip abo lasanene nang i öt kö kinis kirip pe ine.” ");
INSERT INTO bjk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A dauleng ne bak ne ausu re ine toxo wöwörö ulamun a gunon ne lotu raxin. Idi toxo tengen bara a mariris se ine ixo deek, möxösa, toxo ömar ma mangana wat deek ma abo arabaa idi toxo isik ke God. Inexalik Jisas ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Xarnang a lasa mum moro pere ra, a axana bung irabo wanot nang kaim pe önga wat irabo kis lömö xö önga wat kabise. Idi tabo öbeng ösu xirip.” ");
INSERT INTO bjk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Me idi toxo ose ine, “Tene ausu, lause inabo lalaa na tabo ot, ma sa irabo ot ta uxileng bara inabo lalaa na iri lörörö ra inot?” ");
INSERT INTO bjk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisas ixo balu idi bira, “Mum morobo balaure e mum kalik ke öng ibo töxö lo e mum. Möxö a oleleng tabo wanot ma tabo tengen bara idi te wanot kö esene e, ma bere, ‘E mon ina Mesaia,’ ma, ‘A axana bung iri lörörö.’ Ganim e mum pa mumuu idi. ");
INSERT INTO bjk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma nang bara mum morobo ölangen ulamun abo mangana inarse rataxin, io, mum bele bubuut. Abo lalaa na irabo araun ta nuanot. Ma lamun a xakawöm i karabo ot pasaxit mon.” ");
INSERT INTO bjk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Me ine ixo tengen tö idi, “Abo kantri tabo erese ma abo kantri. Mabo kingdom tabo erese mabo kingdom. ");
INSERT INTO bjk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma xöbo dauleng ne boxönö, abo gie raxin ma irilöng taxin mabo miniset tataxin tabo wanot pösöt idi. Mabo mangana auxileng tataxin irabo wan su meriso xö watmaep pua ubuut a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Inexalik bara mesila xö inabo lalaa xirip na, idi tabo töndik e mum ma tabo pet ögarin e mum. Idi tabo isik e mum pa tinuu xö warkurai xöbo gunon ne sineseng köbo Judeia ma tabo tile e mum köbo gunon ne aömokorot. Ma tabo lamus e mum pua tinuu mesilain abo king mabo duöng sisila rua gene e. ");
INSERT INTO bjk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lamun ina na, mum morobo tenge maras se idi lamun a tinenge deek. ");
INSERT INTO bjk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma lamun mum moro dödöm deek bang bere mum mo korobo dödöm ne binuut bara mum morobo tuu wi bulengin abo aupuk ke idi, ");
INSERT INTO bjk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","möxösa, e rabo tabaa e mum ma tinenge deek ma dinödöm nanase, ma kaim pe öng ke idi nang irabo puk e mum irabo eöt tua irewese bara ra puxus tewe ina tinenge e isik ke mum. ");
INSERT INTO bjk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mabo tata ma nago, abo tönö e mum, abo marapun te mum, mabo ais se mum idi tabo isik e mum urungan kö limine idi nang te mamaa rua pet ögarin e mum. A dauleng ke mum, idi tabo sexomet. ");
INSERT INTO bjk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A nangadi xirip tabo melentexin e mum, möxösa, xö eseke. ");
INSERT INTO bjk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Inexalik kaim pe önga axana bebene öxöm mum irabo tup. ");
INSERT INTO bjk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma nang bara mum morobo tuu lölös, mum morobo uruoxe a to. ");
INSERT INTO bjk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nang bere mum morobo pere a oleleng ne umri te elulure e Jerusalem, mum morobo ösöxö bara a axana bung möxö wewet ögarin ina lagunon iri lörörö. ");
INSERT INTO bjk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Io, i deek bara a nangadi nang te xisixis Judeia xina axana bung, tabo ulo uruso xöbo maii. Me idi nang te kis kölöme Jerusalem tabo wan su. Me idi nang te xisixis kö boxönö lörörö, idi tebele laxa xina lagunon taxin. ");
INSERT INTO bjk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ina axana bung na ine a axana bung nang God irabo balu ma ömokorot tua öturunon abo tinenge re ine nang toxoro geet. ");
INSERT INTO bjk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Irabo laa ne maris köbo une nang te tienen, me idi nang te urus barok kö inabo bung na! A tiip taxin arixe irabo wanot kö ina öxöno lagunon ma a laie re ine irabo bulus öxaa xö ina nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ma tabo buso idi ma sele, ma tabo kip lo a dauleng kabise xarnang abo karabus urungan köbo kantri xirip. Ma nangadi nang kaim bara abo Judeia idi tabo pas ösu e Jerusalem ot kö axana bung nang e God iri pilak irabo kis eöt. ");
INSERT INTO bjk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ma abo auxileng irabo ot kö xaken, a texe mabo tii. Ma ra xö pu xö öxöno lagunon, a nangadi tabo dödöm oleleng, ma tabo burin a börbörön ma tinawit möxö rasi. ");
INSERT INTO bjk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A nangadi tabo memet saxit ma binuut ulamun a lasa i orot pösöt idi ra xö öxöno lagunon. Ruasa, möxösa, abo lalaa lölös meriso xö mango irabo mamagi. ");
INSERT INTO bjk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kö ina axana bung niang, idi tabo pere a Barok kö Tödi irabo wanot kö kubu arixe ma lölös ma a mariris taxin. ");
INSERT INTO bjk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma nang abo lalaa na irabo urulo ra inot, mum morobo tuu lömö ma morobo wawara kaa, möxösa, a ineöro re mum iri lörörö rua nuanot.” ");
INSERT INTO bjk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma ixo tengen ina tinenge öwuo na re idi. Ma ixo tengen bira, “Mum moro pere ina uno fik mabo mangana uno iaa xirip. ");
INSERT INTO bjk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ma nang mum mo pere abo labana te tawalas, mum morobo ösöxö bara a axana bung möxö xaken iri lörörö rua inot. ");
INSERT INTO bjk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Xarnang iat mon, nang e mum mo pere inabo lalaa na te orot, mum morobo ösöxö bara a kingdom kö God iri lörörö rua inot. ");
INSERT INTO bjk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Turunon saxit, ina nangadi nang tabo pere inabo lalaa na, idi tekebeöt ta minet bang, ot nang abo lalaa na xirip irabo ot. ");
INSERT INTO bjk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A balana kubu ma öxöno lagunon irabo wan tup, nexalik bara a tinenge re e, i kebeöt ta xakawöm. ");
INSERT INTO bjk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mum moro tumarang, xalik a magingin ne ininim baba ma a dinödöm köba ulamun abo mangana axanan möxö to irabo öriip e mum. Nang bere mum mo wewet bira, ina bung na irabo uxun öwuwus e mum, ");
INSERT INTO bjk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","möxösa, irabo wanot pösöt idi xirip ewe nang tobo xisixis sa xö öxöno lagunon kirip. ");
INSERT INTO bjk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mum morobo tumarang ma morobo seseseng sösöxö bara a lölös se mum irabo eöt tua rorop e mum pua ulo wes kirip abo lalaa nang irabo ot pösöt e mum. Ma morobo seseseng sösöxö bölök bara mum morobo eöt ta balamasa xö wawara xö Barok kö Tödi.” ");
INSERT INTO bjk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ma xöbo bungbung kirip Jisas ixobo eusu ringan kö gunon ne lotu raxin. Ma xöbo aien kirip, ine ixobo önan tua minaru ringan kö maii tobo rengrengen ine me Maii Olip. ");
INSERT INTO bjk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma xöbo puxu xirip a marakörö oleleng toxobo önan ot urungan kö gunon ne lotu raxin tua ölangen ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Io, a bung taxin möxö Enen a Beret Kaim a Is Könan, tobo rengrengen ine ma Luxa ne Nuan Lexe, ixo lörörö ra nuanot. ");
INSERT INTO bjk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mabo pris tataxin mabo tene ausu möxöbo warkurai te Moses, idi toxo wawara siwin te ngas sua sesexomet e Jisas, möxösa, idi toxo buburin a nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Io, Satan ixo tup pe Judas nang tobo tengen ine me Iskariot, me ine a öng möxö ina sangaun ma ninöng. ");
INSERT INTO bjk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Me Judas ixo wan pösöt abo pris tataxin mabo sisila möxöbo köbat möxö gunon ne lotu raxin. Me idi toxo etöngösen arixe bere Judas irabo isik tewe e Jisas bara bule. ");
INSERT INTO bjk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Idi toxo axanan köba ma toxo sixaut tua ratabaa ine ma tuluwok. ");
INSERT INTO bjk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Io, Judas ixo sixaut bölök ma ixo urulo ra winara siwin te mangana ngas mamaran tua isik e Jisas kö limine idi nang kaim pe marakörö ra ösöxö. ");
INSERT INTO bjk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Io, a bung möxö Luxa möxö Beret Kaim a Is Könan ixo wanot. Ma ina bung abo Judeia toxobo sesexomet bölök abo bak kö sipsip rue idi ra enen tua dödöxömen lo a bung möxö Luxa ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas ixo tile e Pita me Jon ma ixo tengen, “Moro wan ma moro tagure a nien ne Nuan Lexe rue ire rua enen.” ");
INSERT INTO bjk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Me idu toxo ose ine, “U mamaa bere maa marabo tagure ine ule?” ");
INSERT INTO bjk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ine ixo balu, “Ma nang bere mu me laxa xö lagunon taxin, a tödi i xikip nanin a bile ari irabo esuo me mu ringan. Mu morobo muu ölaxa ine xö gunon nang bara i laxa xönan. ");
INSERT INTO bjk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Me mu morobo tengen kö tamana gunon, ‘Tene ausu i ose bara, “Ule a ngasieke nang e mabo bak ne ausu re e, mem marabo en ina nien ne Nuan Lexe xönan?” ’ ");
INSERT INTO bjk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Me ine irabo osen e mu ma önga xönö raxin niso lömö xö gunon nang toxoro tagure bulus. Mu morobo tagure a nien könan.” ");
INSERT INTO bjk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Io, idu toxo wan lo me idu toxo pere xirip lo inabo lalaa nang e Jisas ixo tengen te idu. Me idu toxo tagure a nien möxö Luxa ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ma nang a axana bung möxö nien ixo wanot, Jisas mabo aposol idi toxo kis arixe xö öra. ");
INSERT INTO bjk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Me Jisas ixo tengen te idi, “E mamaa bere e rabo en ina nien möxö Nuan Lexe arixe me mum melamu nang e rabo kip a kinadik. ");
INSERT INTO bjk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Io, e tengen te mum, e karabo en öbaling ina nien na ot nang a unine ina nien irabo wanot turunon kö kingdom kö God.” ");
INSERT INTO bjk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Io, Jisas ixo kip lo a kap wain ma ixo tengen deek kö God ulamunon, ma ixo tengen, “Mum moro kip lo ina na ma morobo erimine elin e mum min. ");
INSERT INTO bjk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Möxö e tengen te mum, e karabo inim öbaling ina wain na ot nang a kingdom kö God irabo wanot.” ");
INSERT INTO bjk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma ixo kip lo a beret ma ixo tengen deek kö God, io, ixo pidik, ma ixo tabaa nanin idi min ma ixo tengen, “Ina na a aike nang e isik kua gene mum. Mum moro en tua dödöxömen e.” ");
INSERT INTO bjk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Xina mangana ngas mon, melamu xö nien ine ixo kip lo a kap wain ma ixo tengen, “Ina kap wain na ine a xuxubus maxat kö dee re e nang irabo su rua gene mum. ");
INSERT INTO bjk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ma lamun mum moro pere, a limine ina öng nang irabo isik tewe e, ine ia xö öra möxö nien arixe me e. ");
INSERT INTO bjk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A Barok kö Tödi irabo wan urungan kö minet xarnang kö kunubus se God. Ma lamun, maris belek kö tödi nang irabo isik ine xö limine a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mabo bak ne ausu re ine toxo urulo ra aose baling iat kaluluonin idi bara ewenene iat im pe idi irabo pet bira. ");
INSERT INTO bjk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Io, a inangat ixo taru kaluluonin idi bara ewenene re idi i taxin. ");
INSERT INTO bjk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisas ixo tengen tö idi, “Ewe me idi niang kaim bara abo Judeia, abo king ke idi tobo ii öraxin idi iat ma tobo pere ösu abo nangadi xabise. Ma ewe me idi nang tobo kure xöbanin idi, tobo rengrengen öbaling idi bara abo tene rorop kö nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Inexalik mum bele wewet biringan. I deek bara ewe a öng i taxin saxit sik ke mum, irabo eöt ma öng nang i xö pu, ma bara öng nang i kure e mum, irabo eöt ma öng nang i tultul. ");
INSERT INTO bjk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Me ewe re idu i taxin? A öng nang i kis kö öra möxö nien bara a öng nang i tultul? Turunon saxit, nangang i kisisik kö öra. Inexalik e ia kaluluonin e mum, e xarnang a önga tultul te mum. ");
INSERT INTO bjk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mum iat moxo tuu arixe me e, me mum moxo kaim kö nuan lie e nang abo tiip ixo wanot pösöt e. ");
INSERT INTO bjk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ma xarnang mon a Tata re e ixoro isik a kinis ne kingdom pe e, e bölök e rabo isik a kinis ne kingdom pe mum. ");
INSERT INTO bjk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Io, mum morobo an me mum morobo inim arixe me e xö öra möxö nien kö kingdom pe e. Me mum morobo kis köbo kinis taxin tua kure a sangaun ma ninöng ne marapun mee Israel. ");
INSERT INTO bjk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, God iri öbala e Satan bara irabo könönöin e mum, tua palang elixilixin abo dedeek mabo sasaban xarnang a öng irabo same a wit tua xikip tewe abo lewene xalik a irine. ");
INSERT INTO bjk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma lamun e re seseng lamun nöngön, bara a nunu re nöngön i karabo subu. Ma nang bara u dödöm puxus, örobo mana ölölös abo töm.” ");
INSERT INTO bjk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Inexalik e Pita ixo tengen, “Orong, e re tagur bara arabo wan arixe me nöngön urungan kö ömokorot ma a minet.” ");
INSERT INTO bjk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas ixo tengen, “E tengen te nöngön, Pita, nixinen nang a xixök i koxobola tenge bang, örobo narun ne öös bara u koxobo ösöxö e.” ");
INSERT INTO bjk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Me Jisas ixo ose idi, “Nang e xo tile e mum kö inuan te mum ma kaim a rat, bara re tuluwok ma bara re sandel, mum moxo sasaxan lamun te laa?” Idi toxo balu, “Kawaim.” ");
INSERT INTO bjk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ine ixo tengen tö idi, “Ma lamun na, nang bere mum ma tuluwok, moro kip, ma moro kip abo rat te mum. Ma nang bara kaim e mum ma sele möxö inarese, io, mum moro misik mabo saket te mum ma morobo kun te öng. ");
INSERT INTO bjk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","E tengen biringanin te mum, möxö abo tinenge re God toxo geet ulamun e, i tengen bira, ‘Me idi toxo kos arixin ine mabo duöng saban.’ Me ina tinenge na irabo wanot turunon, möxösa, abo lalaa toxo geet ulamun e iri önan ot turunon.” ");
INSERT INTO bjk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mabo bak ne ausu toxo tengen, “Orong, örö pere, a nine sele möxö inarese ia.” Me Jisas ixo balu idi ma ixo tengen, “Iri eöt.” ");
INSERT INTO bjk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Io, Jisas ixo wan su ma ixo wan urungan kö Maii Olip, xarnang ine ixobo wewet bie, mabo bak ne ausu re ine toxo muu ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma nang idi toxo ot kina xönö, ine ixo tengen te idi bara, “Mum morobo seseng bara mum korobo subu nang bara a ölelewen irabo ot pösöt e mum.” ");
INSERT INTO bjk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Io, ine ixo wan talu idi a ömat aulik, eöt ma tinarang möxö wat a önga tödi i pet. Ixo subun kexe ma ixo seseng bira, ");
INSERT INTO bjk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mama, nang bara u mamaa, e mamaa bara örobo irewe ina tiip na xalik e, ma lamun u bele muu a mamaa re e. Kaim. Örobo muu eörin a mamaa re nöngön iat.” ");
INSERT INTO bjk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma önga angelo meriso lömö xö watmaep ixo ot pösöt ine ma ixo ölölös ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Me Jisas ixo örasen a tiip taxin, ma ixo seseng lölös ma malawang ke ine ixo tibin xarnang a dee i susubu su xö pu. ");
INSERT INTO bjk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nang ine ixo taru xalik a siniseng ma ixo wan baling urungan köbo bak ne ausu re ine, ixo parasiwin idi ma toxo paliso, möxösa, idi toxo tapunuk. ");
INSERT INTO bjk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ine ixo ose idi, “Mum mo wapaliso rösa? Mum moro taru ma moro seseng lamun mum mo korobo subu nang bara re ölelewen i ot pösöt e mum.” ");
INSERT INTO bjk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ma nang e Jisas angen ixo rengrenge, a marakörö toxo ot, ma tödi ewe nang tobo rengrengen ine me Judas, a öng möxö ina sangaun ma ninöng ne bak ne ausu, ixo silien idi. Ine ixo wan pösöt e Jisas sua mumuum ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma lamun Jisas ixo ose ine, “Judas, nöngön u isik a Barok kö Tödi xö limine abo iuo arixe mina mumuum na?” ");
INSERT INTO bjk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nang abo bak ne ausu re Jisas toxo pere a lasa ixo eka inot, idi toxo tengen, “Orong, i öt bere mem marabo erese mabo sele re mem?” ");
INSERT INTO bjk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma a öng mere idi ixo tee xöröp tewe a talinge tuun möxö tene tinörön kö pris taxin. ");
INSERT INTO bjk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma lamun Jisas ixo tengen, “Iri eöt ina na!” Ma ixo sigi a talingine ina tödi ma ixo ölanglanga ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Io, Jisas ixo tengen köbo pris tataxin, mabo umri möxöbo köbat möxö gunon ne lotu raxin, mabo sisila nang toxo ot tua rörödik ine bara, “Mum mo ot mabo sele mabo amu rua önawan e, xarnang arixe bere e a tödi baba? ");
INSERT INTO bjk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ma xöbo bungbung kirip e xobo xisixis arixe me mum kölöme xö xönö möxö gunon ne lotu raxin, me mum kaim kö mamaa rua rörön dik e. Ma lamun ina na a axana bung bara God iri öbala a lölös möxö ködö rua sisilien e mum rua wewet a tinörön te mum.” ");
INSERT INTO bjk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Io, idi toxo töndik ine, me idi toxo silien tewe ine ma toxo kip lo ine urungan kölöme xö gunon möxö pris taxin. Me Pita ixo mumuu nana, ma lamun ixo ömat aulik kalik idi. ");
INSERT INTO bjk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma nang idi toxoro usumot a ia sösöt kölöme xö xönö möxö gunon ma toxo kis kö pu arixe, Pita ixo kis kö pu arixe midi. ");
INSERT INTO bjk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A önga une tultul ixo pere ine xö bibio ne ia sösöt ixo kisisik. Ixo pere dik ine ma ixo tengen, “Ina tödi na ixo arixe me Jisas.” ");
INSERT INTO bjk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma lamun e Pita ixo öös ma ixo tengen, “Une, e koxobo ösöxö ine.” ");
INSERT INTO bjk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A aulik melamu a öng kabise belek ixo pere ine ma ixo tengen, “Nöngön bölök a öng mere idi.” Me Pita ixo balu, “Tödi, e kaim!” ");
INSERT INTO bjk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Io, a axana bung melamu a öng kabise belek ixo wöwörö lölös, “Turunon saxit, ina tödi na ixo arixe me Jisas, möxösa, ine mee Galili.” ");
INSERT INTO bjk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita ixo balu, “Tödi, e kobo ösöxö a lasa nöngön u wöwörö ulamun!” Ma nang mon ine ixo wöwörö, a xixök ixo tenge. ");
INSERT INTO bjk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Orong ixo tawuxus ma ixo pere dik e Pita. Io, Pita ixo döxömen lo a tinenge niang a Orong ixo tengen te ine bara, “Nixinen nang a xixök i kobola tenge bang, nöngön örobo öös tewe e xö narun ne axan.” ");
INSERT INTO bjk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Me Pita ixo wan su ma ixo gee saban arixe. ");
INSERT INTO bjk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A nangadi ewe nang toxo werwere muu e Jisas, toxo urulo a aösaxit saban ma toxo dangdangat ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Idi toxo kut pi a marna ma toxo ose ine, “Örö tengen te tinenge propet im na. Ewe i tut nöngön?” ");
INSERT INTO bjk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Me idi toxo tengen a oleleng ne tinenge saban kabise rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Xö puxu bubung a kansel möxöbo sisila möxö nangadi, mabo pris tataxin arixe mabo tene ausu möxöbo warkurai te Moses, toxo kis arixe. Ma toxo silien e Jisas urungan kö wawara re idi. ");
INSERT INTO bjk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Me idi toxo tengen, “Örö tengen te mem nang bara nöngön a Mesaia bara kaim.” Me Jisas ixo tengen tö idi, “Nang bara e tengen te mum, mum mo korobo nunu re e, ");
INSERT INTO bjk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma nang bere e ose e mum, mum mo korobo balu e. ");
INSERT INTO bjk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma lamun urulo nixinen ma melamu, a Barok kö Tödi irabo kis kö kinis taxin tingan kö lime tuun te God nang a lak lölös ine.” ");
INSERT INTO bjk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Idi xirip toxo ose, “Me nöngön a Barok kö God?” Me ine ixo balu, “Mum mo töxödös nang mum mo tengen biringan tö e.” ");
INSERT INTO bjk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Io, idi toxo tengen, “Ire tebele ose öbaling kebo tinenge maras lamun ina tödi na. Ire tere ölangen ina tinenge xalik a ngalana ine iat.” ");
INSERT INTO bjk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Io, idi xirip abo sisila nang toxo kis etok toxo taru kaa ma toxo silien tewe e Jisas urungan mesila re Pailat. ");
INSERT INTO bjk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Me idi toxo urulo ra wupuk ine ma toxo rengrengen, “Mem mere parasiwin ina tödi nang ibo sisilien ölelebes a nangadi re mem abo Judeia. Me ibo wanwanak e mem bere mem bele kun takis urungan kö king mee Rom, ma ibo rengrengen bara ine iat a Mesaia, a king.” ");
INSERT INTO bjk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Io, Pailat ixo ose e Jisas, “Nöngön a king möxöbo Judeia?” Jisas ixo balu ine bara, “Ine mon xarnang u tengen.” ");
INSERT INTO bjk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Io, Pailat ixo tengen köbo pris tataxin ma xö marakörö, “E kobo parasiwin te unine saban ulamun ina tödi na.” ");
INSERT INTO bjk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma lamun idi toxo wöwörö lölös iat, “Ine ibo öraru a balana nangadi mee Judeia ma inausu re ine, urulo ro Galili ma ixo wan esexere ura.” ");
INSERT INTO bjk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma nang e Pailat ixo ölangen ina na, ixo ose bara ine mee Galili bara kaim. ");
INSERT INTO bjk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma nang e Pailat ixo ösöxö bere Jisas ine möxö xönö nang e Erot ibo kure sik, ine ixo tile e Jisas urungan te Erot, möxösa, e Erot bölök nangen nang Jerusalem kö ina bung. ");
INSERT INTO bjk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E Erot ixo axanan saban arixe nang ixo pere e Jisas, möxösa, ixoro ölangen abo winörö ulamun ine ma ixo baa xixiset bang iat tua werwere ine. Ma ixo mamaa rua werwere abo lalaa lölös ne auwuwus nang irabo pet. ");
INSERT INTO bjk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ine ixo ose e Jisas ma oleleng ne ineose, nexalik Jisas kaim kö babalu ine. ");
INSERT INTO bjk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Abo pris tataxin mabo tene ausu möxöbo warkurai te Moses, toxo tuu sik kingan ma toxo wewet abo tinenge lölös sua wupuk e Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Io, Erot mabo duöng möxö inarse re ine, toxo uli ine ma toxo eösaxit saban te ine. Ma toxo ölaulawa ine ma man deek xarnang möxö king, ma toxo tile wuxus ine urungan te Pailat. ");
INSERT INTO bjk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mesila Erot me Pailat toxobo eöngat, ma xö ina bung idu toxo ais im. ");
INSERT INTO bjk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat ixo kuwe etok abo pris tataxin, abo tene sisila ma a nangadi, ");
INSERT INTO bjk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ma ixo tengen tö idi, “Mum moxo lamus ot ina tödi na ura rö e, xarnang a öng bara i silien ögarin a nangadi. E xo ose ine xö wawara re mum ma kaim a parasiwin te unine sasaban kö ina tödi nang mum mo puk ine. ");
INSERT INTO bjk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Me Erot bölök kaim a parasiwin te unine sasaban lamun ine ma ixo tile öbaling ine ura re ire. Xarnang mum mo öt ta werwere, ine i koxobo pet te laa nang irabo met kelen. ");
INSERT INTO bjk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Io niang, e rabo ömokorot ine ma arabo palas tewe ine.” ");
INSERT INTO bjk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A marakörö toxo kup taxin bara, “Sexomet ine! Ma moro palas sik e Barabas ura re mem!” ");
INSERT INTO bjk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Me Barabas, toxo bulus ölaxa ine xö gunon ne aömokorot, möxö ine ixo öraru a inarese arixe ma gapman ma ixo erese ömet bölök.) ");
INSERT INTO bjk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat ixo mamaa rua uguran tewe e Jisas, io, ixo tengen öbaling kö marakörö. ");
INSERT INTO bjk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma lamun idi toxo xukup iat bara, “Tut ine xö sölöxöröp! Tut ine xö sölöxöröp!” ");
INSERT INTO bjk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sese önarun min, ine ixo tengen tö idi, “Ruasa? A mangana sasaban sa ina tödi na ixo pet? E parasiwin kölöme re ine kaim pe laa i saban eöt bara irabo met kelen. Io niang, e rabo ömokorot ine ma melamu arabo palas tewe ine.” ");
INSERT INTO bjk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Inexalik idi toxo xukup lölös bara tabo mana tut e Jisas kö sölöxöröp, io, abo kinup pe idi ixo örarik e Pailat bara irabo sixaut. ");
INSERT INTO bjk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Io, Pailat ixo kure e Jisas xarnang idi toxo mamaa. ");
INSERT INTO bjk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ine ixo palas tewe a tödi ewe nang toxo tewe ölaxa xö gunon ne aömokorot, ine nang ixo öraru a inarese raxin ma inarese ömet kö gapman, a öng nang idi toxo seng lo ine. Me Pailat ixo isik e Jisas urungan köbo duöng inarese xarnang kö mamaa xö nangadi. ");
INSERT INTO bjk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Io, nang idi toxo silien tewe e Jisas, idi toxo töndik e Saimon mee Sairin, ewe nang ixo önan kö nuan te ine, ma toxo bulus a sölöxöröp lömö rine ma toxo ölölös lo ine rua xikip ma ra muumuu e Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A marakörö raxin toxo muu ine, kaluluonin idi a dauleng ne balixilik ewe toxo tapunuk ma toxo gegee nana rö ine. ");
INSERT INTO bjk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas ixo tawuxus ma ixo tengen tö idi, “Balixilik mee Jerusalem, mum bele gegee rö e. Mum moro gegee rö mum iat ma bung baroxorok ke mum, ");
INSERT INTO bjk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","möxösa, axana bung möxö kinadik irabo ot pösöt e mum nang mum morobo tengen, ‘A bung une tuu ewe nang tekara kip barok ma tekara eurus, irabo deek kö idi.’ ");
INSERT INTO bjk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Io, “‘idi tabo tengen köbo maii, “Moro subu kaa re mem!” ma tabo tengen köbo kalala, “Moro kait pi e mem!” ’ ");
INSERT INTO bjk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma nang bara idi te pet ina mangana tatalien na xö iaa i to sik, io, idi tabo pet a lasa nang a iaa iri manga?” ");
INSERT INTO bjk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A nine tödi xabise bölök, idu a nine tödi saban, idu bölök toxo silien ösu idu ra minet arixe me Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma nang idi toxo wanot kö xönö tobo rengrengen me Siine Öxöno Tödi, ringan idi toxo tut ine xö sölöxöröp arixe ma nine tödi saban, a öng kö lime tuun ma öng kö lime kes. ");
INSERT INTO bjk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Me Jisas ixo tengen, “Mama, döxömen taun a magingin saban te idi, möxö idi tokoxobo ösöxö a lasa nang idi te wewet.” Me idi toxo egulös satu rua erimine abo man te ine re idi iat. ");
INSERT INTO bjk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","A nangadi toxo tuu ngökngök sik, mabo tene pet warkurai toxo eösaxit tine. Idi toxo tengen, “Ine i rorop a nangadi xabise. Ma nang bara ine a Mesaia re God nang God ixoro pere kos, ganim ine irabo öro öbaling ine iat.” ");
INSERT INTO bjk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abo duöng inarese bölök toxo wanot ma toxo eösaxit me ine. Idi toxo tabaa ine ma wain manun. ");
INSERT INTO bjk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma toxo tengen, “Nang bara nöngön a king möxöbo Judeia, na im örö top öbaling nöngön iat.” ");
INSERT INTO bjk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma toxo geet a xönö tinenge ma toxo bulus lömö xö sölöxöröp. Ma i tengen bira, “Ina tödi na ine a king möxöbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Öng möxö ina nine tödi saban ewe nang ixo tabaleleng sik kingan, ixo eösaxit te Jisas bira, “Nöngön a Mesaia, goo? Göm, örobo öro nöngön iat arixe me maa!” ");
INSERT INTO bjk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma lamun a öng kabise ixo tenge köö ine bira, “Nöngön u kobo buburin e God? Nöngön bölök u kip sik ina mangana ömokorot nang ine i kip sik. ");
INSERT INTO bjk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Idi te se iraa eöt mabo lasa nang iraa tobo wewet, nexalik ina tödi na i koxobo pet te laa nang i saban.” ");
INSERT INTO bjk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Io, ine ixo tengen, “Jisas, örobo döxömen lo e xö axana bung nang örobo wan laxa xö kinis ne kingdom pe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Me Jisas ixo balu ine, “Turunon saxit, nixinen nöngön örobo kis arixe me e ruso xö xönö i deek saxit.” ");
INSERT INTO bjk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma ixo lörörö ra luono xaken, ma a ködö ixo wanot ma ixo tawi xirip ina öxöno lagunon ot kö narun ne axana bung kö aien, ");
INSERT INTO bjk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","möxösa, a xaken ixo mun. Ma a xönö man taxin meringan kölöme xö gunon ne lotu raxin ixo tamadidi ninöng ne xönö. ");
INSERT INTO bjk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisas ixo kup wösö raxin bira, “Mama, e isik a tanono e xö tabalana limem.” Ma nang ine ixo tengen sik bira, ixo met. ");
INSERT INTO bjk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A umri raxin möxöbo duöng inarese ixo pere a lasa ixo wanot, ma ixo ölet e God ma ixo tengen, “Turunon saxit, ina tödi na a tene töxödös.” ");
INSERT INTO bjk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A nangadi xirip ewe nang toxo ot etok ka werwere ina laa, idi toxo pere a lasa ixo ot ma toxo tapunuk ma toxo wasa abo böngböngöno idi ma toxo wan tewe. ");
INSERT INTO bjk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma lamun ewe idi xirip nang toxo ösöxö ine, idi toxo tuu sik kö palaa ma toxo werwere inabo lalaa na. Ma kaluluonin idi a balixilik nang toxo muu lo ine mee Galili. ");
INSERT INTO bjk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A önga tödi a esene e Josep, ine a öng möxöbo kansel, me ine mee Arimatia xö xönö Judeia. Ine a tödi deek ma a tene töxödös, ewe nang kaim ine xo sixaut kö dinödöm ma tatalien te idi. Me ine ixo xixiset ma kingdom kö God. ");
INSERT INTO bjk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ine ixo wan pösöt e Pailat, ma ixo seng lo a minet te Jisas. ");
INSERT INTO bjk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Io, ine ixo kip ösu, ma ixo kait pi ma man pidien, ma ixo bulus ölaxa ine xö lieng niang toxoro tee, a öng nang kaim bang ka ömarin te tödi xönan. ");
INSERT INTO bjk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma ina bung, a bung möxö tagur bulus sua Sabat. Ma a bung Sabat ixoro lörörö ra inot. ");
INSERT INTO bjk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A balixilik nang toxo muu e Jisas mee Galili, idi toxo wan arixe me Josep ma toxo pere a lieng ne minet. Ma toxo pere bölök nang toxo ömarin bulengin e Jisas kölöme xönan. ");
INSERT INTO bjk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Io, idi toxo wan baling urungan lagunon ma toxo tagure bulus abo mangana aururup nang a lak sixine deek. Inexalik idi toxo mamas kö bung Sabat xarnang a warkurai i tengen. ");
INSERT INTO bjk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Xö Sade xö puxu bubung, abo une toxo kip abo mangana aururup deek nang idiet toxoro tagure, me idiet toxo wan urungan kö lieng möxöbo minet. ");
INSERT INTO bjk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Me idiet toxo parasiwin bara toxoro ubun tewe a wat kalik a marana lieng, ");
INSERT INTO bjk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ma lamun nang idiet toxo wan laxa, idiet kaim kö werwere a aine e Jisas, a Orong. ");
INSERT INTO bjk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma nang idiet toxo dödödöm ulamun ina na, saxit iat mon a nine tödi toxo tuu xö lawana idiet mabo man te idu ixo sisiek xarnang a siek. ");
INSERT INTO bjk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Inabo une toxo buut ma toxo ii ötun a wawara re idiet uri xö pu, ma lamun a nine tödi toxo tengen tö idiet, “Rösa muot mo wawara siwin kaluluonin abo minet lamun a tödi nang i to sik? ");
INSERT INTO bjk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Kaim ine ra. Ine iri taru baling kalik a minet! Muot moro döxömen lo a tinenge ine ixo tengen te mum nang ine ixo kis arixe bang me mum pingan Galili bira, ");
INSERT INTO bjk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘A Barok kö Tödi, tabo mana isik ine xöbo limine a nangadi saban, ma tabo tut ine xö sölöxöröp ma xö bung sese önarun min ine irabo taru kaa baling.’” ");
INSERT INTO bjk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Io, idiet toxo döxömen lo abo tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma nang idiet toxo tawuxus baling meringan kalik ina lieng, idiet toxo tengen abo lalaa xirip urungan kö sangaun ma öng ne bak ne ausu ma urungan bölök köbo dauleng kabise xirip. ");
INSERT INTO bjk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","E Maria Makdala, Joana, me Maria a nago re Jems ma dauleng ne balixilik kabise bölök ewe nang toxo töngösen abo aposol minabo tinenge na. ");
INSERT INTO bjk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Inexalik kaim idi xo nunu xöbo balixilik, möxösa, abo tinenge re idiet ixo xarnang a laa tataun tö idi. ");
INSERT INTO bjk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma lamun e Pita ixo sile taru ma ixo ulo urungan kö lieng. Ine ixo tunsu, ma ixo pere abo xönö man kalik mon tingan kö pu. Io, ine ixo wan lo ma ixo dödödöm iat te ine ulamun a lasa ixo ot. ");
INSERT INTO bjk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Xö ina bung mon, a ninöng mere idi, idu toxo önan lamun a lagunon tobo rengrengen ine me Emaus, i eöt ma sangaun ma öng ne kilomita meringan Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Me idu toxo etöngösen nana re idu ulamun abo lalaa xirip nang ixoro wanot. ");
INSERT INTO bjk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma nang idu toxo etöngösen nana re idu minabo lalaa na, Jisas iat ixo wanot pösöt idu ma ixo wan arixe me idu. ");
INSERT INTO bjk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inexalik God ixo eng pi abo marana idu ra werwere xulen ine. ");
INSERT INTO bjk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Me ine ixo ose idu, “Mu mo etöngösen ma a lasa nang mu mo önan nana?” Io, idu toxo tuu ödödö, mabo mamaran te idu ixo wawara maris. ");
INSERT INTO bjk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A öng mere idu, e Kiliopas, ixo ose ine bira, “Nöngön mon a önga ose ringan Jerusalem nang u koxobo ösöxö abo lasa nang iri ot tingan kö inabo bung na?” ");
INSERT INTO bjk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Me ine ixo ose bara, “Mabo lasa?” Io, idu toxo balu bara, “Abo lalaa ulamun e Jisas mee Nasaret. Ina tödi na a propet ine. Abo tinenge re ine mabo tinörön te ine a lak lölös kö wawara xö God ma xö nangadi xirip bölök. ");
INSERT INTO bjk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Abo pris tataxin mabo tene pet warkurai te ire toxo isik tewe e Jisas bara irabo tuu xö warkurai ma bara irabo met. Me idi toxo tut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma lamun mem moxo nunu sik bara ine a öng ewe nang irabo ölanglanga e Israel. Ma önga laa bölök, a narun ne bung iri saxit nang toxo tut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A dauleng ne balixilik bölök mere mem te öwuwus e mem. Idi te wan urungan kö lieng möxöbo minet kö puxu bubung. ");
INSERT INTO bjk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Inexalik idi tokobo pere a aine. Me idi te wanot ma te tengen te mem bara idi te pere a nine angelo, me idu te tengen bara ine iri to baling. ");
INSERT INTO bjk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Io, a dauleng ne ais se mem toxo wan urungan kö lieng ma toxo pere xarnang mon abo balixilik toxoro tengen, ma lamun ine, kaim idi xo werwere ine.” ");
INSERT INTO bjk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Me Jisas ixo tengen tö idu, “Bara bule me mu koxobo maras me mum mo alilis sua nunu xöbo tinenge propet nang toxoro tengen? ");
INSERT INTO bjk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Turunon saxit, a Mesaia irabo mana kip iat ina kinadik, ma melamu irabo laxa xö mariris se ine.” ");
INSERT INTO bjk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Me Jisas ixo tengen ömaras se idu ulamun abo lalaa nang i kis kölöme xöbo ginigeet kirip pe God lamun ine iat, urulo re Moses arixe mabo tinenge xöbo propet kirip. ");
INSERT INTO bjk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma nang idiet toxo orot lörörö xö lagunon nang idu toxo mamaa rua nuan uxe, Jisas i pet ine xarnang bara ixo mamaa rua nuan esexere. ");
INSERT INTO bjk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma lamun idu toxo seng ölölös ine, me idu toxo tengen, “Örö kis arixe me maa, möxö iri aien im ma a ködö iri lörörö ra inot.” Io, ine ixo wan laxa rua kinis arixe me idu. ");
INSERT INTO bjk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ma nang ixo kisisik kö öra möxö nien arixe me idu, ixo kip lo a beret ma ixo tengen deek ulamun ma ixo pidik ma ixo tabaa idu min. ");
INSERT INTO bjk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Io, abo dinödöm pe idu ixo wanot maras me idu toxo perexulen ine. Me Jisas ixo kawöm tataun mon kalik idu. ");
INSERT INTO bjk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Me idu toxo wöwörö iat te idu bara, “Turunon saxit, a balana iraa i kos nang ine i etöngösen nana me iraa xö ngas ma nang i palas abo unine tinenge möxöbo ginigeet te God te iraa.” ");
INSERT INTO bjk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Saxit iat mon, idu toxo taru ma toxo baling iat mon urungan Jerusalem. Idu toxo ot pösöt a sangaun ma öng ne bak ne ausu ma dauleng kabise bölök arixe me idi. Me idi toxo kis etok arixe. ");
INSERT INTO bjk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma toxo rengrengen, “Turunon saxit. A Orong iri taru kaa baling ma iri wösö re Saimon.” ");
INSERT INTO bjk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Io, idu toxo etöngösen ma lasa nang ixo wanot kö ngas, ma bara bule nang idu toxo perexulen e Jisas nang ine ixo pidik a beret. ");
INSERT INTO bjk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ma nang idi angen toxo etöngösen mina na, e Jisas iat ixo tuu kaluluonin idi ma ixo tengen tö idi, “A malum irabo kis arixe me mum.” ");
INSERT INTO bjk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Me idi toxo wuwus ma toxo buut. Idi toxo dödödöm bere idi te pere a tano. ");
INSERT INTO bjk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Me ine ixo tengen tö idi, “Mum mo wuwus sö sa me mum mo dödöm ninöng kö sa? ");
INSERT INTO bjk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Moro pere abo limine e arixe mabo xexene e. E, e iat mon! Moro sigi e ma moro pere, a tano kaim ine ma lewene aine ma sii xarnang na mum mo pere e min.” ");
INSERT INTO bjk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ma nang ine ixoro tengen ina na, ixo osen idi mabo limine mabo xexene. ");
INSERT INTO bjk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma kaim iat idi xö nunu xönan, möxösa, idi toxo wöwö ma axanan ma toxo dödöm köba. Io, Jisas ixo ose idi, “Mum mere laa ringan tua enen?” ");
INSERT INTO bjk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Me idi toxo tabaa ine ma xönö subana en toxoro söngöt. ");
INSERT INTO bjk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma ixo kip lo ma ixo en kö wawara re idi. ");
INSERT INTO bjk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Me ine ixo tengen tö idi, “Inabo lalaa na e xo töngösen e mum min nang e xo xisixis bang me mum, bara abo lalaa xirip tabo mana pet eöt ma nang toxo geet ulamun e kölöme xöbo warkurai te Moses mabo tinenge xöbo propet ma xö buk ne Sinö.” ");
INSERT INTO bjk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Io, ixo palas abo dödöxömen te idi bere idi tabo maras ulamun inabo ginigeet te God. ");
INSERT INTO bjk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma ixo tengen tö idi bira, “Toxoro geet ina na, bara a Mesaia irabo örasen a kinadik ma xö bung sese önarun min irabo taru kaa xalik a minet. ");
INSERT INTO bjk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma tabo etöngösen ma esene xö nangadi xirip pa xö öxöno lagunon, urulo ra Jerusalem, bara a nangadi xirip tabo dödöm puxus me God irabo döxömen taun tewe abo magingin saban te idi. ");
INSERT INTO bjk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mum moxo pere inabo lalaa na me mum morobo etöngösen min. ");
INSERT INTO bjk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Me e rabo tile ösu re mum a lasa nang a Tamake ixo xuxubus ulamunon. Inexalik mum morobo kis xiset ulamun ine ra xö ina lagunon ot nang bara a lölös meriso lömö irabo kain e mum.” ");
INSERT INTO bjk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma nang ine ixo lamus ösu idi urungan Betani, ixo rarik a limine ma ixo wadöane idi. ");
INSERT INTO bjk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma bara nang ine ixo wawadöane idi, ixo wan lie idi me God ixo kip lo ine uruso lömö xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Io, idi toxo lotu wösöt ine, ma toxo tawuxus baling arixe ma axanan taxin urungan Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Me idi toxobo önan ot sösöxö urungan kö gunon ne lotu raxin me idi toxobo ölelet e God tingan. ");
INSERT INTO bjk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mesila xö urulo möxöbo lalaa xirip, a Tinenge ixoro kis. Ma ina Tinenge ixo kis arixe me God, ma ina Tinenge e God iat. ");
INSERT INTO bjk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ma ina Tinenge ixo kis arixe me God mesila xö urulo möxöbo lalaa xirip. ");
INSERT INTO bjk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Me God ixo uxis abo lalaa xirip arixe ma ina Tinenge na. Ma kaim pe laa ixo wanot tataun. Kaim. God i ixo pet abo lalaa xirip arixe ma ina Tinenge. ");
INSERT INTO bjk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me ine iat mon a unine to runon. Ma ina to, ine a bibio nang irabo ömaras a nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","A bibio i sili ömaras a ködö, ma lamun a ködö i kobo eöt tua tinuu wi ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Önga tödi ixo ot nang e God ixo tile ine, a esene e Jon. ");
INSERT INTO bjk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Me ine ixo ot tua rengrengen ösu lamun ina bibio, bara a nangadi xirip nang tabo ölangen, idi tabo nunu xö ina bibio. ");
INSERT INTO bjk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Me ine iat kaim bara ine ina bibio, inexalik, ixo ot tua rengrengen ösu lamun ina bibio. ");
INSERT INTO bjk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma ina bibio runon i nangen, ma iri wanot ura xö öxöno lagunon ma ibo ömaras a nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A Tinenge ixo kis sa xö öxöno lagunon. Ma i turunon bere God ixo uxis a öxöno lagunon min, ma lamun a nangadi belek möxö ina öxöno lagunon idi kaim kö werwere xulen ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ine ixo ot kö xönö re ine iat, ma lamun a nangadi re ine kaim kö ömaraxen lo ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Lamun ewe me idi nang toxo ömaraxen lo ine, ixo ömaraxa lo idi bara idi tabo bung baroxorok ke God, idi iat nang ewe toxo nunu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma tokoxobo xikip idi xarnang a tatalien möxö nangadi mon, bara xö mamaa xö tödi. Lamun kaim. God iat ine a Tamana idi. ");
INSERT INTO bjk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma ina Tinenge ixo ot xarnang a tödi, ma ixo to kaluluonin ire. Me ire tere pere a mariris se ine, a mariris möxö ina önga Barok söxöt mon meringan te Tamana. Ma ixo wöwö ma a abalamu mabo turunon te God. ");
INSERT INTO bjk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon ixo etöngösen maras lamun ine, ma ixo wöwörö lölös bira, “Ine a öng nang e xo wöwörö ulamun ine nang e xo tengen bira, ‘Irabo ot melamu re e, ma lamun ine i taxin sik ke e, möxösa, ine ixoro kis nang bang kaim kö xikip e.’” ");
INSERT INTO bjk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma i wöwö sik arixe ma abalamu ma ibo ratabaa sösöxöin ire xirip min. ");
INSERT INTO bjk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses ixo isik abo warkurai ura re ire nang God ixo tabaa ine min. Ma lamun meringan te Jisas Krais a abalamu ma turunon ixo ot. ");
INSERT INTO bjk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kaim bang ke öng ixoro pere e God. Ma lamun God ine ma önga Barok kalik mon me ine iat e God, ma ibo xisixis kö lawana e Tamana. Me ine iat ixoro wöwörö maras sö ire ulamun ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nang abo tödi raxin mee Judeia ringan Jerusalem toxo tile a uleng ne pris ma Liwai urso re Jon tua ose ine, bara a mangana tödi bule ine, io, Jon ixo tengen ömaras. ");
INSERT INTO bjk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ine kaim kö öös sua babalu idi, ma lamun ixo ömaras mon idi, ma ixo tengen bara, “Kaim bere e ina Mesaia.” ");
INSERT INTO bjk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Me idi toxo ose öbaling ine, “Me ewe iat im nöngön? E Elaija nöngön?” Me Jon ixo balu idi, “Kaim, kaim bere e Elaija.” Me idi toxo ose öbaling ine, “Nöngön ina Propet nang ire te xixiset ulamun?” Ine ixo balu öbaling idi, “Kawaim.” ");
INSERT INTO bjk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Io, idi toxo tengen te ine, “Go, örö tengen im pe mem bere ewenene runon iat nöngön, rue mem pa töngösen idi nang toxo tile e mem ura. Örobo tengen bule im pe nöngön?” ");
INSERT INTO bjk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon ixo balu idi mabo tinenge propet te Aisaia bira: “E a inöno öng i xukup kö xönö tataun bara, ‘Mum morobo ötöxödös a ngas kö Orong.’” ");
INSERT INTO bjk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Io, dauleng ne Parasi nang toxo tile, ");
INSERT INTO bjk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","idi toxo ose e Jon bira, “Ma nang bara kaim bere nöngön iang a Mesaia, bere e Elaija, bara ina Propet, ma ruasa nöngön u baptais a nangadi?” ");
INSERT INTO bjk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Me Jon ixo balu idi bira, “E bo baptais idi arixe ma ari. Ma lamun öng kaluluonin e mum, mum kobo ösöxö ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ine mon a öng nang irabo ot melamu re e, me e kobo töxödös eöt tua walwalas a kililöng kalik a nine sandel te ine.” ");
INSERT INTO bjk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inabo lalaa xirip ixo ot to Betani, kö lawana Ari Jordan, nang e Jon ixo baptais a nangadi xönan. ");
INSERT INTO bjk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Önga bung kabise im, Jon ixo pere e Jisas ixo önan pösöt ine ma ixo tengen, “Mum moro pere bang, ina na a bak kö sipsip nang e God ixo tile ura rua xikip tewe abo magingin saban kö nangadi möxö öxöno lagunon! ");
INSERT INTO bjk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ine mon a tödi nang e xo töngösen ulamunon bara, ‘A tödi irabo ot melamu re e, ma lamun ine i taxin sik ke e, möxösa, ine ixoro kis nang kaim bang kö xikip e.’ ");
INSERT INTO bjk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me e iat kaim kö ösöxö ine, ma lamun e wanot tua baptais e mum ma ari rua osen ömaras abo Israel ulamun ine.” ");
INSERT INTO bjk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Io, Jon ixo isik a tinenge maras bira, “E xo pere a Tanono ixo wan su meriso xö watmaep xarnang a buno ma ixo kis lömö re ine. ");
INSERT INTO bjk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","E iat kaim kö ösöxö xulen bara ine iat mon nang irabo ot. Ma lamun ewe nang ixo tile e rua baptais a nangadi arixe ma ari ixo tengen bara, ‘A tödi nang örobo pere a Tanono irabo wan su ma irabo kis lömö xö ina tödi, ine iat mon niang irabo baptais arixe ma Töxödös ne Tanono.’” ");
INSERT INTO bjk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Me Jon ixo tengen, “E xoro pere ine me e xo tengen ösu bara ine iat mon a Barok kö God.” ");
INSERT INTO bjk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Io, xö bung melamu e Jon arixe ma nine bak ne ausu re ine, idiet toxo tuu sik baling kingan. ");
INSERT INTO bjk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ma nang ixo pere e Jisas ixo önan saxit, ixo tengen te idu, “Mu moro pere, ina na a bak kö sipsip nang e God ixo tile.” ");
INSERT INTO bjk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma nang ina nine bak ne ausu toxo ölangen biringan, idu toxo muu e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas ixo talingen baling ma ixo pere idu toxo mumuu re ine. Ma ixo ose idu, “Mu mo mamaa lamun a sa?” Idu toxo balu ine ma toxo tengen, “Rabai, nöngön u xisixis ule?” (Ma a unine ina tinenge ‘Rabai’ bara ‘Tene Ausu’). ");
INSERT INTO bjk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Me Jisas ixo balu, “Mu moro miang me mu morobo pere.” Io, idu toxo muu ine ma toxo pere a xönö ixo xisixis e, ma ixoro lörörö im kö nit ne axana bung kö aien. Io, idu toxo kis arixe me ine xö ina bung kö aien. ");
INSERT INTO bjk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Io, Endru a tönö e Saimon Pita, ine a öng ke idu nang toxo ölangen a lasa e Jon ixo tengen, io, idu toxo muu lo e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A laa nang e Endru ixo arun ta wewet ixo parasiwin a tönö nang e Saimon, ma ixo tengen te ine, “Maa mere pere lo a Mesaia.” (Ma tabo puxus ina tinenge na bara ine mon a ‘Krais’). ");
INSERT INTO bjk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma ixo lamus e Saimon urungan te Jisas. Jisas ixo pere ine ma ixo tengen, “Nöngön e Saimon, a barok ke Jon. Tabo rengrengen nöngön me Kepas” (niang, toxo puxus bere, e Pita). ");
INSERT INTO bjk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Io, xö bung melamu, Jisas ixo mamaa ra nuan uruso Galili. Ixo pere lo e Pilip ma ixo tengen tö ine, “Muu e.” ");
INSERT INTO bjk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ine meri Betsaida xö lagunon nang e Endru me Pita tobo xisixis bölök ee. ");
INSERT INTO bjk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip ixo ot pösöt e Natanael ma ixo tengen te ine, “Mem mere pere lo a öng nang e Moses ixo gegeet ulamunon kölöme xö Buk möxö Warkurai ma nang bölök abo propet toxo gegeet ulamun ine. E Jisas meriso Nasaret, a barok ke Josep.” ");
INSERT INTO bjk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Me Natanael ixo ose, “Kaim pe lalaa deek i eöt tua nuanot meriso Nasaret!” Io, Pilip ixo tengen, “Örö miang ma örö pere.” ");
INSERT INTO bjk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ma nang e Jisas ixo pere e Natanael ixo önan pösöt ine, ixo tenge ulamun ine bara, “Turunon saxit, ina tödi a Israel tunon, ma i koxobo ösöxö ra röxröxö.” ");
INSERT INTO bjk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Me Natanael ixo ose ine, “U ösöxö e bule?” Jisas ixo balu ine ma ixo tengen, “E xo arun ta werwere nöngön kö pu xö uno löwö, melamu re Pilip pa xukuwe nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Io, Natanael ixo tengen, “Rabai, nöngön a Barok ke God. Me nöngön a King köbo Israel.” ");
INSERT INTO bjk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Me Jisas ixo balu ma ixo tengen, “U nunu, möxösa, e tengen te nöngön bara e xo pere nöngön kö pu xö uno löwö. Inexalik nöngön örobo pere rebo lalaa nang i taxin saxit te nanga.” ");
INSERT INTO bjk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Io, ine ixo tengen öbaling, “E tengen a turunon te nöngön, mum morobo pere a watmaep irabo tamasawang, mabo angelo re God tabo önan kaa ma tabo önan su xö Barok kö Tödi.” ");
INSERT INTO bjk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Io, melamu xö nine bung ixoro saxit, a nien taxin ne alolo ixo wanot kö lagunon Kena ro Galili. A nago re Jisas bölök ixo ot. ");
INSERT INTO bjk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Me idi toxo seng bölök e Jisas ma bung bak ne ausu re ine rua kinis kö ina nien ne alolo. ");
INSERT INTO bjk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma nang a wain ixo kawam, a nago re Jisas ixo tengen te ine bara, “Kawaim im idi ma wain.” ");
INSERT INTO bjk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Me Jisas ixo balu ine bira, “Nago, ruasa u rengrengen tö e? Kaim bara a laa re e. A axana bung ke e i kela wanot bang.” ");
INSERT INTO bjk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A nago re Jisas ixo tengen köbo tene tinörön, “Mum morobo pet abo lasanene nang ine i tengen te mum.” ");
INSERT INTO bjk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma lörörö ringan a pitnö ma öng ne bile raxin toxo pet ma wat. Inabo mangana bile ne ari nang abo Judeia toxobo gilime min eöt mabo warkurai te idi. A öngöng ke idi abo bile ixobo rörön a nine sangaun bara a narun ne sangaun ne buluxom ne kö ari. ");
INSERT INTO bjk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas ixo tengen köbo tene tinörön, “Mum moro tii abo bile ma ari.” Io, idi toxo tii öwöwö urungan köbo marana idi. ");
INSERT INTO bjk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Io, ixo tengen te idi bira, “Na mum moro kuluwe re uleng ma moro isik kö tödi sisila möxö nien taxin.” Me idi toxo pet eörin. ");
INSERT INTO bjk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ma a tödi sisila möxö nien taxin ixo nanamienin a ari nang e Jisas ixoro puxus sa wain. Kaim ine xo marmaras bara ina wain ixo ot mole, inexalik abo tene tinörön nang toxo ölele a ari, idi toxo ösöxö sik. Io, ixo kuwe lo a tödi nang ixo eka inalolo. ");
INSERT INTO bjk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma ixo tengen te ine, “A nangadi xirip tobo araun ta erabaa ma wain deek. Ma melamu nang a nangadi osee tere inim a oleleng, idi tobo isik belek a wain nang kaim a nanamien möxönan. Ma lamun nöngön u xo bulus tewe sik iat ina wain deek ot na.” ");
INSERT INTO bjk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Io, ina na a sisila ne auxileng lölös e Jisas ixo pet kö lagunon Kena ro Galili. Me ine ixo osen a mariris se ine, mabo bak ne ausu re ine toxo nunu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Melamu xönan Jisas ixo wan su uruo Kaprenaum arixe me nene mabo tönö, mabo bak ne ausu re ine. Ma ringan ee, idi toxo kis a dauleng ne bung. ");
INSERT INTO bjk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ma nang ixoro lörörö ra axana bung taxin möxö nien ne Nuan Lexe xöbo Judeia, Jisas ixo wan uruso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Me ine ixo pere lo a nangadi kölöme xö xönö mesila xö gunon lotu raxin, idi toxo mismisik mabo bulmakau, abo sipsip mabo buno, ma dauleng toxo kisisik köbo öra ma toxo exuxulas ma tuluwok. ");
INSERT INTO bjk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Io, Jisas ixo ipelee a wip ma uno, ma ixo wasak tewe idi xalik a xönö mesila xö gunon lotu raxin, arixe mabo sipsip ma bulmakau. Ine ixo sesele nanin abo tuluwok ke idi nang toxo exuxulas nana min ma ixo puxus lubeng abo öra re idi. ");
INSERT INTO bjk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Me Jisas ixo tengen te idi nang toxo misik mabo pun bara, “Mum moro kip tewe abo lalaa na mera! Ma ganim e mum kö wewet a gunon kö Tamake xarnang a gunon ne mismisik.” ");
INSERT INTO bjk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma abo bak ne ausu re ine toxo döxömen lo a tinenge re God nang toxoro geet, i tengen bira, “God, a balake i raru xöba rua werwere muu a gunon te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Io, abo Judeia toxo ose ine bara, “A mangana auxileng lölös sa nang örobo osen te mem pua öturunon bere i töxödös sik kö nöngön tua wewet bie?” ");
INSERT INTO bjk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Me Jisas ixo balu idi ma ixo tengen, “Mum moro öbeng ösu ina gunon ne lotu raxin, me e rabo öraru öbaling ine xö narun ne bung.” ");
INSERT INTO bjk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma abo Judeia toxo balu öbaling ine, “Idi toxo rörön kö ina gunon ne lotu raxin na xö nit ne sangaun ma pitnö ma öng ne awat. Me nöngön örobo öraru öbaling ine xö narun ne bung mon?” ");
INSERT INTO bjk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma lamun a gunon ne lotu raxin nang e Jisas ixo wöwörö ulamunon, ine na mon a aine. ");
INSERT INTO bjk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Melamu xö tinaru baling ke ine xalik a minet, abo bak ne ausu re ine toxo döxömen lo a lasa nang ine ixo tengen. Io, idi toxo nunu xina tinenge xö buk ke God arixe ma tinenge bölök niang e Jisas ixoro tengen. ");
INSERT INTO bjk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma nang e Jisas ixo xisixis suso Jerusalem kö Luxa ne Nuan Lexe, a oleleng ne nangadi toxo nunu xö esene, möxösa, idi toxo pere ine ixo pet abo auxileng lölös. ");
INSERT INTO bjk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ma lamun e Jisas kaim kö nunu re idi bara tabo pet ödeek ine, möxösa, ixo ösöxö sik abo tatalien kö nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kaim pe unine bara re öng irabo mana töngösen e Jisas mere nangadi, möxö ine ixo ösöxö sik a dödöxömen kö nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Io, önga tödi raxin möxöbo Judeia, a esene e Nikodimas, me ine bölök a öng mere idi abo Parasi. ");
INSERT INTO bjk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ixo ot pösöt e Jisas kö dömön ma ixo tengen, “Rabai, mem me ösöxö bere nöngön a tene ausu, me God ixo tile nöngön, möxösa, kaim pe öng i eöt tua wewet abo auxileng nang u wewet nang e God i kobo kis arixe me ine.” ");
INSERT INTO bjk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas ixo balu ine ma ixo tengen, “Turunon saxit, kawaim pe öng i öt ta nilaxa xö kingdom kö God nang bara tekobo kip öbaling ine.” ");
INSERT INTO bjk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas ixo ose ine, “Tabo kip öbaling a tödi bara bule nang bara ine iri ötaxin? Turunon saxit, i kebeöt ta nilaxa baling kö balana nago re ine rua xikip öbaling ine!” ");
INSERT INTO bjk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas ixo balu ine, “Turunon saxit, kawaim pe öng i öt ta nilaxa xö kingdom kö God nang bara tekobo kip ine xö ari ma xö Tanono. ");
INSERT INTO bjk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ewenene nang tobo kip ine xö lewene aine, ine a tödi ne lewene aine iat. A nangadi tobo kip a nangadi iat, nexalik a Tanono ibo kip a tanono iat. ");
INSERT INTO bjk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ganim nöngön kö wuwuwus nang bara e tengen te nöngön bara, ‘Tabo mana kip öbaling e mum.’ ");
INSERT INTO bjk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A xiki ibo wawaxat muu a mamaa re ine. Mum bo ölangen a börbörön möxönan, ma lamun mum kobo ösöxö bara i wanot mole, me mum kobo ösöxö a xönö nang i önan uwe. I xarnang a nangadi xirip ewe nang a Tanono i kip idi.” ");
INSERT INTO bjk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ixo ose, “Ma ina na irabo ot bule?” ");
INSERT INTO bjk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Me Jisas ixo tengen, “Nöngön a tene ausu raxin mee Israel. Bule u kobo öt ta marmaras kö ina laa na? ");
INSERT INTO bjk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Turunon saxit, mem me rengrenge xö laa mem me ösöxö sik, me mem me tengen ösu a lasa mem mere pere. Inexalik mum angen mo köbo ömaraxen abo tinenge re mem. ");
INSERT INTO bjk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","E re töngösen e mum lamun abo lalaa mera xö öxöno lagunon me mum kobo nunu. Io, irabo bara bule nang bara mum morobo nunu nang arabo rengrengen a lalaa möxö watmaep?” ");
INSERT INTO bjk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Io, kaim pe öng iri wan urso xö watmaep, lamun ine xalik mon a Barok kö Tödi nang ixo wan su meriso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Xarniang e Moses ixo ii öxaa a petpuo möxö si xö xönö tataun ma iaa, io, a Barok kö Tödi, tabo mana ii öxaa ine, ");
INSERT INTO bjk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","bara idi xirip niang te nunu re ine tabo kip a to ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Io, God ine ma önga Barok kalik mon. Me God ixo mamaa xöba lamun a öxöno lagunon, io, ixo isik ösu ina Barok ke ine, bere ewenene niang i nunu re ine i karabo met, ma lamun irabo kip a to ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Me God kaim kö tile ösu a Barok ke ine ura xö öxöno lagunon bara irabo ömokorot a öxöno lagunon, ma lamun ixo tile ösu ine bara irabo öro ire. ");
INSERT INTO bjk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Io, ewe niang i nunu re ine, i karabo tuu xö warkurai. Ma lamun ewe niang i kobo nunu re ine, a warkurai irabo ömokorot ine, möxösa, ine i kobo nunu xö esene önga Barok kalik mon te God. ");
INSERT INTO bjk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ma unine bara God ixoro kure sik a öxöno lagunon bira. A Maras ixoro ot ta xö öxöno lagunon, ma lamun a nangadi toxo mamaa xöba lamun a xödxödö, ma maras kawaim, möxösa, abo magingin te idi a lak saban. ");
INSERT INTO bjk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Me ewenene niang ibo wewet a sasaban i kara maa xöba ulamun a maras. Ma i karabo ot urungan kö maras, xalik abo magingin te ine irabo wösö. ");
INSERT INTO bjk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma lamun ewenene niang ibo xisixis muu a turunon te God, ine irabo ot urungan kö maras, io nang bere irabo maras bara abo lasanene niang ixo wewet, ixo pet kö lölös se God.” ");
INSERT INTO bjk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Io, melamu xö ina na, Jisas arixe mabo bak ne ausu toxo wan lo uruso xö xönö raxin Judeia. Ma ixo kis bang me idi xö uleng ne bung, ma ixo baptais a dauleng ne nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Me Jon ixo pet baptais singan kö lagunon Ainon lörörö Salim, möxösa, ringan nangen a ari raxin. Ma a nangadi toxobo önan uxe bara irabo baptais idi. ");
INSERT INTO bjk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ma ina laa na ixo ot melamu niang kaim bang kö bulbulus e Jon kö gunon ne aömokorot.) ");
INSERT INTO bjk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma dauleng ne bak ne ausu re Jon toxo egot arixe ma önga Judeia. A warkurai te idi bara idi tabo mana gilime bara God i karabo pere re sasaban kölöme re idi. Me idi toxo egot lamun ina tatalien. ");
INSERT INTO bjk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Io, idi toxo wan uruso re Jon ma toxo tengen, “Tene Ausu, mem me eka töngösen nöngön lamun a tödi ewe niang ixo tuu sik me nöngön ti lawu xö gegene Ari Jordan. Ine mon niang u xo etöngösen me ine. Io, na nangen i wewet a baptais ma oleleng te orot pösöt ine.” ");
INSERT INTO bjk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Io, Jon ixo tengen te idi, “Kaim pe öng irabo pet te tinörön nang bere God i kobo isik sik ke ine. ");
INSERT INTO bjk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mum iat morobo eöt tua öturunon xarniang e xo tengen bie: ‘Kaim bere e a Mesaia. Ma lamun God ixo tile ösila e re ine.’ ");
INSERT INTO bjk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ma na i bira. A tödi niang i maa ra alolo, re ine iat ina taluso niang i mamaa rua elolo. Lamun a ais kö ina tödi ibo ruruu ma ibo ölöngö. Ma i axanan tua ölangen a tinenge xö ina tödi alolo. Ma na a balake iri wöwö ma axanan. ");
INSERT INTO bjk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A esene iat irabo mana taxin sik ma eseke irabo xö pu. ");
INSERT INTO bjk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“A öng niang i wan su meriso lömö i taxin köba xöbo lalaa xirip. Me ewe niang mera xö pu, ine iat mera xö pu, ma ibo wöwörö mabo lalaa mera iat kö pu. Ma lamun i turunon, ewe niang i wan su meriso xö watmaep i taxin köba xöbo mangana lalaa xabise xirip. ");
INSERT INTO bjk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ine i rengrenge ulamun inabo lasanene niang ixoro pere ma ixoro ölangen, ma lamun kaim pe öng ibo ömaraxen lo a tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Me ewe niang i ömaraxen lo a tinenge re ine, i öturunon bara abo tinenge re God i turunon. ");
INSERT INTO bjk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I turunon bira, möxösa, ewe niang e God ixo tile ösu, i wöwörö mabo tinenge re God, möxösa, God ixo tabaa xirip ine ma Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata i maa xöba lamun a Barok ke ine, io, ixo bulus ine bara irabo kure xirip abo lalaa. ");
INSERT INTO bjk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ewenene niang i nunu xö Barok ke ine, ine iri kip a to ulorexe. Ma lamun niang bara ewenene i mölök kalik a Barok ke ine i karabo pere ina to, nexalik a laie re God i kisisik lömö re ine.” ");
INSERT INTO bjk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Io, abo Parasi toxo ölangen bere Jisas ixo silien a oleleng ma ixo baptais a oleleng ne bak ne ausu ma niang e Jon kawaim. ");
INSERT INTO bjk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ma lamun i kobo turunon bara e Jisas ixo baptais a dauleng. Lamun abo bak ne ausu re ine mon toxobo baptais idi.) ");
INSERT INTO bjk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nang e Jisas ixo ösöxö lo a sanene niang toxo rengrengen, ixo wan kalik a xönö raxin Judeia, ma ixo baling urso Galili. ");
INSERT INTO bjk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma ngas niang ine irabo mana muu i wan köröp kö xönö raxin Samaria. ");
INSERT INTO bjk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Io, ixo wanot urungan kö önga lagunon tobo rengrengen me Saikar, i kis kölöme xö xönö mee Samaria. Ma ina lagunon i lörörö xö xönö pu re Jekop niang ixo isik ke Josep, a barok ke ine. ");
INSERT INTO bjk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma marna ari niang e Jekop ixo kin i nangen niang, ma nang ixo lörörö ra luono xaken Jisas ixo wanot ma ixo kisisik kingan kö gegene möxö ina marna ari, möxösa, a nuan ixo uban ine. ");
INSERT INTO bjk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ma önga une mee Samaria ixo ot tua kuluwe ari. Me Jisas ixo tengen te ine bara, “E mamaa bara örö tabaa e ma ari.” ");
INSERT INTO bjk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ma abo bak ne ausu re ine toxoro wan lo rua kun nien kö lagunon.) ");
INSERT INTO bjk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A une mee Samaria ixo tenge balu ine, “Nöngön a Judeia, me e a une Samaria. Ma ruasa u seseng e ma ari?” (Ine ixo tengen bira, möxösa, abo Judeia tekara ais deek arixe mabo Samaria.) ");
INSERT INTO bjk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Io, Jisas ixo balu ine ma ixo tengen, “Nang bere nöngön u xoro ösöxö a arabaa xö God, ma u ösöxö bölök bere e ewenene nang e seng nöngön ma ari, io, nöngön u xebe seng e ma ari, me e xebe tabaa nöngön ma ari möxö to.” ");
INSERT INTO bjk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A une ixo tengen te ine bira, “Tödi raxin, kaim pe lalaa niang örobo kuluwe min, möxö a marna ari i dödöngö xöba. Nöngön örobo kip ina ari möxö to mera? ");
INSERT INTO bjk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nöngön u döxömen gut bara u taxin sik kö untubuno mem e Jekop? Ine iat ixo tabaa e mem mina marna ari, me ine iat ixo inim e, ma bung barok ke ine, ma bung bulmakau ma bung sipsip bölök arixe min.” ");
INSERT INTO bjk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Me Jisas ixo balu ine, “Idi xirip ewe niang te inim kö ina ari, idi tabo minauu baling. ");
INSERT INTO bjk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma lamun ewe niang i inim kö ina ari niang e tabaa ine min, i karabo minauu baling. A ari niang e rabo tabaa ine min, irabo xarniang a ari i wuwut kaa kölöme re ine rua isik a to ulorexe re ine.” ");
INSERT INTO bjk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","A une ixo tengen te ine bira, “Tödi raxin, e mamaa bara örö tabaa e ma ina ari na, nexalik bara e kebeöt ta minauu baling me e kebeöt ta nuan ura ra kululuo.” ");
INSERT INTO bjk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Io, Jisas ixo tengen te ine, “Örö wan, ma örö kuwe a usuom, ma örobo baling ura.” ");
INSERT INTO bjk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","A une ixo tengen te ine, “Kaim e mere tödi.” Me Jisas ixo balu ine, “I turunon niang u tengen bara kaim nöngön mere tödi, ");
INSERT INTO bjk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","möxösa, nöngön u xoro elolo sik kö pitnö ne tödi, ma ina tödi na niang u kis arixe sik me ine, kaim bara ine a usuom. U tengen a turunon.” ");
INSERT INTO bjk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Io, a une ixo tengen te ine, “Tödi raxin, e pere bere nöngön a propet. ");
INSERT INTO bjk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Io, na iat e mamaa ra ose nöngön ma önga laa. Abo untubuno mem toxobo lolotu wösöt e God kö ina maii na. Lamun e mum abo Judeia, mum bo rengrengen bara ire tabo mana lotu wösöt e God tuso Jerusalem kalik mon. Me nöngön, u döxömen bule?” ");
INSERT INTO bjk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Me Jisas ixo tengen te ine, “Nang, örö mana nunu xö tinenge re e. A axana bung i ka nuanot niang a nangadi tekarabo lotu wösöt e Mama xö ina maii ma kaim bölök kingan Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mum abo Samaria mum kobo ösöxö a lasa niang mum mo lotu xönan. Lamun e mem abo Judeia, mem me ösöxö sik ewe niang mem me lolotu wösöt ine, möxösa, a tinörön te God tua öro nangadi irabo wanot meringan köbo Judeia. ");
INSERT INTO bjk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A axana bung i ka nuanot, ma na iri orim, bara ewe me idi niang tabo lotu wösöt e God ma turunon, idi tabo lotu bira. Idi tabo lotu wösöt e Mama meringan kölöme xö tanono idi arixe ma turunon. Ma ina mangana lotu na e Mama i mamaa bara ta lotu wösöt ine bie. ");
INSERT INTO bjk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God, ine a tanono, me ewe me idi niang te lotu wösöt ine, idi tabo mana lotu wösöt ine meringan kölöme xö tanono idi arixe ma turunon.” ");
INSERT INTO bjk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma ina une ixo tengen te ine, “E ösöxö sik bara ina Mesaia nang tobo rengrengen ine me Krais, irabo wanot. Ma nang bara irabo wanot, irabo ömaras kirip abo lalaa rö ire.” ");
INSERT INTO bjk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Io, Jisas ixo balu ine, “E iat mon ine.” ");
INSERT INTO bjk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Saxit mon, a bung bak ne ausu rine toxo baling, me idi toxo wuwus bere Jisas ixo wöwörö arixe mina une. Ma lamun kaim pe öng ixo ose ine bara, “Rösa u wöwörö arixe mine?” ma bara, “A lasa iang mu mo rengrengen?” ");
INSERT INTO bjk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Io, a une ixo gan sik a bile rine, ma ixo tawuxus baling urungan kö lagunon tine ma ixo tengen kö nangadi bara, ");
INSERT INTO bjk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Moro miang, moro pere a önga tödi ewe niang i töngösen e mabo lalaa xirip nang e xo pet. Ine gut mon ina Mesaia?” ");
INSERT INTO bjk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Io, idi toxo wan kalik a lagunon te idi ma toxo wan pösöt ine. ");
INSERT INTO bjk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nang a nangadi nangen bang kö ngas, abo bak ne ausu toxo tengen te ine, “Tene Ausu, mem me mamaa bara örobo an.” ");
INSERT INTO bjk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma lamun ine ixo tengen te idi, “E ma nien ta enen niang mum kobo ösöxö runon ulamun.” ");
INSERT INTO bjk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Io, abo bak ne ausu toxo wöwörö nana kaluluonin idi iat, “Re öng gut i kip pebo nien tö ine?” ");
INSERT INTO bjk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Io, Jisas ixo tengen te idi, “A nien te e, bara arabo mana pet eörin a mamaa re ine niang ixo tile e, ma rua öxawam bölök a tinörön te ine. ");
INSERT INTO bjk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nang mum bo susulo abo komo re mum, mum bo rengrengen bara nangen bang a nit ne texe rua xikin. Lamun e tengen te mum, mum moro pere ödeek bang abo komo. Idi te maruxo xirip im pua xikin. ");
INSERT INTO bjk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma nixinen mon, ewenene niang i xixixin, i oxe lo a inone malawang ke ine ma i bulbulus etoxin abo nien möxö to ulorexe. Io, ina öng niang i susulo ma öng niang i xikin, idu tabo axanan arixe. ");
INSERT INTO bjk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Io, ina tinenge na i turunon bira, ‘A öng i susulo ma öng kabise i xikin.’ ");
INSERT INTO bjk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","E xo tile e mum bara mum morobo xixixin kö nang kaim e mum pa sulo. Idi xabise toxo pet a tinörön lölös me mum moro kip lo belek im a inone malawang ke idi.” ");
INSERT INTO bjk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A oleleng ne tee mee Samaria möxö ina lagunon toxo nunu re Jisas mumuu a atöngösen möxö ina une bira, “Ine ixo töngösen e mabo lalaa xirip niang e xobo wewet.” ");
INSERT INTO bjk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Io, niang abo tee mee Samaria toxo wan urungan te Jisas, toxo seng ine bara irabo kis bang midi ringan, ma ixo kis arixe me idi xö nine bung. ");
INSERT INTO bjk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma niang idi toxo ölangen a tinenge re ine, a oleleng ke idi bölök toxo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Idi toxo tengen kö ina une bira, “Mesila mem moxo nunu, möxösa, mem moxo ölangen a tinenge re nöngön. Inexalik na, kawaim. Mem me nunu, möxö mem iat mere ölangen ine, ma i maras pi sik ke mem bara ina tödi na, ine a Tene Aöro möxö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nine bung ixo saxit, io, Jisas ixo baling urso Galili. ");
INSERT INTO bjk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Io, Jisas iat ixoro tengen osen bara a propet, tekara ii ine xö xönö runon iat te ine.) ");
INSERT INTO bjk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma nang ixo ot tiso Galili, a marakörö meringan ee toxo axanan suo ine, möxösa, idi bölök toxoro wan urso xö nien ne Nuan Lexe ringan Jerusalem ma toxoro pere abo lalaa ine ixo pet tingan. ");
INSERT INTO bjk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Meringan ee ixo wan baling urso Kena, a lagunon taxin kö xönö mee Galili, ina lagunon niang ine ixo puxus a ari urungan kö wain. Ma önga tödi raxin nang ixobo rörön kö king, a barok ke ine ixo meset to Kaprenaum. ");
INSERT INTO bjk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Io, niang ixo ölangen bere Jisas ixoro ot tingan Galili meriso Judeia, ixo wan urungan tine, ma ixo seng ine bara irabo wan ma irabo ölanglanga a barok ke ine, ewe niang ixo lörörö rua minet. ");
INSERT INTO bjk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Me Jisas belek ixo tengen te ine, “Nang bere mum mo kala pere abo auxileng lölös mabo tatalien ne auwuwus, mum kebeöt iat ta nunu.” ");
INSERT INTO bjk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Io, a tödi raxin möxö warkurai ixo tengen te Jisas, “Orong, örö miang! Iraa ta wan su wasaxit uri, xalik a barok ke e ibo met.” ");
INSERT INTO bjk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisas ixo balu ine, “Örö wan baling im. A barok ke nöngön irabo to.” Ina tödi ixo nunu xö tinenge re Jisas ma ixo wan lo. ");
INSERT INTO bjk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Niang ine angen bang kö ngas ixo önan, ixo esuo mabo tultul te ine, me idi toxo tengen bara a barok ke ine iri langlanga im. ");
INSERT INTO bjk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma ixo ose idi bara xö axana bung sa a barok ke ine ixo langlanga. Io, idi toxo balu ine, “Laa, xö önga axana bung kö aien a lelewi ixo kawam kalik ine.” ");
INSERT INTO bjk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma a tata re ine ixo ösöxö xulen bara ina axana bung turunon iat niang e Jisas ixoro tengen bara a barok ke ine irabo langlanga. Io, ine me ewenene me idi niang toxo xisixis arixe me ine toxo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma sese öninöngin a auxileng lölös niang e Jisas ixo pet tuso Galili nang ixo wan mee Judeia. ");
INSERT INTO bjk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Melamu xö ina na, Jisas ixo wan kaa urso Jerusalem kö önga luxa raxin te idi abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma ringan Jerusalem lörörö xö marame laxlaxa nang tobo rengrengen me Marame Laxlaxa möxöbo Sipsip, ixo malaa sik a xönö ari, ma pitnö ne walpali toxo tuu wi sik. Ma xö tinenge me Ibru tobo rengrengen ina xönö niang ma Betesda. ");
INSERT INTO bjk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ma oleleng ne miniset idi toxobo mamaru ee. Ma kaluluonin idi abo marapulo, mabo mangana pengpeng. ");
INSERT INTO bjk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma önga tödi kaluluonin idi ixoro meset eöt ma narun ne sangaun ma pitnö ma narun ne awat. ");
INSERT INTO bjk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma nang e Jisas ixo pere ine ixo maru sik, ixo ösöxö bara nangang ixoro meset lo im, io, ixo ose ine, “U maa bara örobo langlanga?” ");
INSERT INTO bjk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma ina tödi miniset ixo balu ine, “Nang orong, kaim pe öng nang mere e nang irabo top ölaxa e xö ina marna ari niang te ömamagi. Ma nang e bang angen e kala wan su, ma öng kabise iboro sila su im kalik e.” ");
INSERT INTO bjk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Io, Jisas ixo tengen te ine, “Taru kaa, tön öxaa a minaru re nöngön ma örö önan.” ");
INSERT INTO bjk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Saxit mon a tödi niang ixo langlanga. Io, ixo kip lo a minaru re ine ma ixo wan lo. Ma ina laa niang ixo ot te ine xö Sabat. ");
INSERT INTO bjk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Io, abo Judeia toxo tengen kö ina tödi niang ixo langlanga bira, “Nixinen a Sabat ma i kobo töxödös kö warkurai te ire bara nöngön örobo kip nanin a minaru re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma lamun ixo balu idi, “A tödi nang i ölanglanga e, i tengen te e bira, ‘Kip lo a minaru re nöngön ma örö önan.’” ");
INSERT INTO bjk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Me idi toxo ose ine, “Ewe ina tödi na i tengen te nöngön ta kip lo a minaru re nöngön ma örö önan?” ");
INSERT INTO bjk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma lamun a tödi nang ixo langlanga, kaim ine ra ösöxö bere ewe ine, möxösa, e Jisas ixo wan sixem kaluluonin a marakörö raxin tingan kö ina xönö. ");
INSERT INTO bjk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Io, melamu belek im, Jisas ixo pere wösöt lo ine kölöme xö gunon lotu raxin ma ixo tengen te ine, “Örö pere bang! Nöngön uru langlanga im. Ma na im, u bele pet öbaling ke sasaban, kalik u bo oxe lo re laa niang irabo ögarin köbanin nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ma ina tödi ixo wan lo ma ixo tengen köbo Judeia bere Jisas mon niang ixo ölanglanga ine. ");
INSERT INTO bjk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Io, abo Judeia toxo rengrengen öbulubun e Jisas, möxösa, ixo ölanglanga a nangadi xö Sabat. ");
INSERT INTO bjk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Me Jisas ixo tengen te idi, “A Tamake ixobo rörörön ot kö ina bung na, me e bölök e bo rörörön.” ");
INSERT INTO bjk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Möxö ina na, abo Judeia ewe niang toxo maa bara tabo sexomet ine, a baladi ixo lelewi xöba bara tabo sexomet ine, möxösa, idi toxo döxömen bara ixo lexe abo warkurai möxö Sabat. Ma kaim bara ina niang kalik mon. Ixo tengen bölök bara a Tamana runon e God. Ma xö ina ngas iat mon, ixo pet ine iat bara irabo eöt arixe me God. ");
INSERT INTO bjk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Io, Jisas ixo balu idi bira: “E tengen a turunon te mum, a Barok i kebeöt ta wewet te laa xö dinödöm iat te ine. Kaim. I eöt mon te ine ra wewet abo mangana lasanene niang i pere muu lo xalik a Tamana ibo wewet, möxö a lasanene niang a Tamana i pet, a Barok bölök irabo pet. ");
INSERT INTO bjk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Me Tata i maa xöba lamun a Barok ke ine ma ibo osen ine mabo lalaa xirip niang ibo wewet. Ma irabo osen ine mabo lalaa nang i taxin köba re nangana. Me mum morobo wuwus saban. ");
INSERT INTO bjk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A Tamana i öraru abo minet ma i öro idi. Io, i xarnang iat mon kö Barok ke ine. Nang bara i mamaa ra tabaa ewenene ma to, irabo öro ine. ");
INSERT INTO bjk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ma a Tamana i kara kure re öng, ma lamun ixoro isik tewe a lölös urungan kö Barok kine rua kure a nangadi xirip bara idi xirip tabo mana ii a Barok kine xarnang iat mon idi tobo ii e Tamana. Io, ewe nang i kobo ii a Barok ke ine, i kobo ii bölök a Tamana niang ixo tile ine ura. ");
INSERT INTO bjk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Turunon saxit, ewe niang i ölangen abo tinenge re e ma i nunu re ine niang ixo tile e ura, io, ine iri kip a to ulorexe, ma i kebeöt ta tinuu xö warkurai. Ma lamun iri saxit a minet urungan kö to. ");
INSERT INTO bjk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Turunon saxit, a axana bung i ka inot, ma na im iri ot, niang abo minet tabo ölangen a inöno a Barok ke God, me idi ewe niang te ölangen, tabo kip a to. ");
INSERT INTO bjk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","A Tamana a unine to. Xarnang iat mon iri isik a lölös kö Barok ke ine bara ine bölök a unine to. ");
INSERT INTO bjk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma a Tamana ixoro isik a lölös urungan te ine rua pet warkurai, möxösa, ine a Barok kö Tödi. ");
INSERT INTO bjk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Ganim e mum pa wuwuwus kö ina na. A axana bung i ka inot niang a nangadi minet kirip tabo ölangen a inöno, ");
INSERT INTO bjk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma tabo taru xalik abo maöt te idi. Idi niang toxobo wewet abo tatalien deek, tabo taru baling, ma tabo kip a to. Me idi niang toxobo wewet abo tatalien saban, tabo taru baling, ma tabo tuu xö warkurai. ");
INSERT INTO bjk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E kebeöt bara arabo pet te laa xö dinödöm iat te e. Kaim. E bo pet warkurai xarnang mon niang e ölangen kalik a Tamake. Ma a tatalien te e rua pet warkurai i töxödös, möxösa, e kaim kö mumuu a mamaa iat te e. Ma lamun e bo mumuu iat a mamaa re ine niang ixo tile e ura. ");
INSERT INTO bjk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nang bara e xalik mon e tengen ösu ulamun e iat, a tinenge re e i karabo tuu lölös. ");
INSERT INTO bjk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Re öng kabise iat tingan i rengrenge ulamun e, me e ösöxö bara a tinenge rine ulamun e i tuu lölös sik. ");
INSERT INTO bjk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Me mum iat, mum moxo uguran a nangadi urungan te Jon a tene baptais bara morobo kip lo a tinenge re ine, me Jon ixo wöwörö maras ma turunon lamun e. ");
INSERT INTO bjk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","E kobo ömaraxen lo a tinenge möxö tödi mon ulamun e. Ma lamun e tengen bira, bara mum morobo mana kip a to runon. ");
INSERT INTO bjk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ixo xarnang a bibio niang ixo bibio maras. Ma xö subana bung mon mum moxo axanan lamun a tinenge ne ömaras se ine. ");
INSERT INTO bjk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Lamun e xo kip a tinenge runon lamun e iat, niang i taxin sik kö tinenge re Jon. Ma i bira. A Tata re e ixo tabaa e ma tinörön tö e rua öxöwam. Ma ina tinörön niang e wewet, i tengen osen a turunon lamun e bara a Tamake ixo tile e ura. ");
INSERT INTO bjk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Tata iat te e niang ixo tile e ura, ixoro töngösen a turunon lamun e. Mum kala ölangen bang a inöno, me mum kala pere bang ine bara ine i xarniang a lasanene. ");
INSERT INTO bjk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma tinenge re ine i kala kis se mum, möxösa, mum kobo nunu re e, me ine ewe niang ixo tile ösu e ura. ");
INSERT INTO bjk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Me mum bo eusu mabo tinenge re God niang toxo geet, möxösa, mum mo döxömen bara inabo ginigeet irabo tabaa e mum ma to ulorexe. Inabo ginigeet na mon nang tobo töngösen a turunon lamun e. ");
INSERT INTO bjk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ma lamun e mum mo mölök ka nuan ura re e bara mum morobo kip a to. ");
INSERT INTO bjk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“E kara ömaraxen bara a nangadi ta ölolot e, ");
INSERT INTO bjk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ma lamun e ösöxö sik e mum. E ösöxö sik bara a mamaa urungan te God i kobo kisisik kölöme re mum. ");
INSERT INTO bjk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","E xo wanot, möxösa, a Tamake ixo tile e ura. Me mum kobo ömaraxen lo e. Niang bara re öng kabise i wanot tataun mon, mum morobo öbala lo ine. ");
INSERT INTO bjk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mum kebeöt bara mum morobo nunu re e, möxösa, mum mo axanan bara öngöng kaluluonin e mum iat irabo ölet e mum, ma lamun mum kobo döxömen bara a laa raxin bara Öng nang ine xalik mon e God irabo ölet e mum. ");
INSERT INTO bjk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mum bele döxömen bere e mon iang, e rabo puk e mum merebo tatalien saban tingan kö wawara re Tamake. Kaim. E Moses mon niang irabo puk e mum, ine nang mum mo döxömen bara irabo top e mum. ");
INSERT INTO bjk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma nang bara mum moxoro nunu re Moses, mum mexebe mana nunu bölök ke e, möxösa, ixo gegeet ulamun e. ");
INSERT INTO bjk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma lamun mum kebeöt ta nunu xö lasanene nang e tengen, möxö mum kobo nunu xö lasa nang ixo geet.” ");
INSERT INTO bjk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Io, melamu xina niang, Jisas ixo wan köröp kö tu Galili, niang toxobo rengrengen bölök ine me tu Taiberias. ");
INSERT INTO bjk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma a marakörö raxin saxit toxo muu ine, möxösa, idi toxoro pere a lölös ne auxileng niang ixo wewet tua ölanglanga abo miniset. ");
INSERT INTO bjk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Io, Jisas ixo wan kaa urso xö gegene maii, ma ixo kis arixe mabo bak ne ausu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma a axana bung möxö Nien ne Luxa ne Nuan Lexe möxöbo Judeia ixoro lörörö. ");
INSERT INTO bjk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ma niang e Jisas ixo wawara kaa ma ixo pere a marakörö raxin toxo önan pösöt ine, ixo tengen te Pilip, “Ire tabo kun beret ule xö ina marakörö na ra enen?” ");
INSERT INTO bjk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ixo ose bira ra könönöin e Pilip, möxösa, ixoro ösöxö sik a lasanene niang irabo pet. ");
INSERT INTO bjk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip ixo balu ine, “A nini mar ne tuluwok i kebeöt niang bere ire tabo kun beret min, bara idi xirip öngöng tabo en a uk mon!” ");
INSERT INTO bjk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma önga bak ne ausu xabise, e Endru, a töne e Saimon Pita, ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Önga barok ka, i kip nanin a pitnö ne beret te pet ma bali, ma nine en lik, ma lamun irabo top kirip ina marakörö na bule?” ");
INSERT INTO bjk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisas ixo tengen, “Tengen kö marakörö bara ta kis kö pu.” A pasle deek iang kina xönö niang kua kinis, ma a nangadi toxo kis kö pu. Ma a xinixos sidi abo duöng mon ixo eöt ma pitnö ne arip. ");
INSERT INTO bjk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Io, Jisas ixo tön lo a beret, ixo tengen deek ke God, ma ixo erimine nanin kö marakörö niang toxo kisisik kua wewet eörin a mamaa re idi. Ma ixo pet bienin kö nini en. ");
INSERT INTO bjk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma niang idi toxo an masii im, Jisas ixo tengen köbo bak ne ausu re ine, “Mum moro ii ot kirip abo subana nien. Ganim e mum pa ögarin tebo subana nien.” ");
INSERT INTO bjk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Io, idi toxo ii ot kirip abo subana nien ma toxo tuxo öwöwö a sangaun ma ninöng ne kölöt arixe mabo subana pitnö ne beret nang ewe midi toxo en paling. ");
INSERT INTO bjk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma nang a marakörö toxo pere ina auxileng lölös niang e Jisas ixo pet, idi toxo tengen, “Turunon saxit, ina tödi na, ine ina propet niang irabo ot ta xö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Me Jisas ixo ösöxö xulen bara idi tere örörö rua nuanot tua ölölös ine bara irabo king. Io, ine xalik ixo wan lo xalik idi urso xö önga maii raxin. ");
INSERT INTO bjk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma niang ixoro aien su maraxoxo im, abo bak ne ausu rine toxo wan su uruo xö tu Galili. ");
INSERT INTO bjk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Idi toxo kaa laxa xö önga mön, ma toxo lilies köröp kö tu uruo Kaprenaum. Ma ixoro ködö im, me Jisas kaim bang kö inot pösöt idi. ");
INSERT INTO bjk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","A xiki lölös ixo wawaxat ma rasi ixo raru. ");
INSERT INTO bjk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma niang idi toxoro ulusen ot kö pitnö ma öng bara xö pitnö ma ninöng ne kilomita, idi toxo pere e Jisas ixo önan lömö xö ari urungan lörörö xö mön, me idi toxo buut saban arixe. ");
INSERT INTO bjk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Inexalik, e Jisas ixo tengen tö idi, “E mon. Ganim a binuut.” ");
INSERT INTO bjk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Io, idi toxo maa bara irabo kakaa xö mön. Ma saxit mon, a mön ixo ösö xö xönö niang idi toxo önan uxe. ");
INSERT INTO bjk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Io, xö bung melamu, a marakörö raxin niang toxo kisisik bang kö lawana tu, toxo döxömen bara ina önga mön kalik mon niang ixo xisixis singan. Me idi toxo ösöxö bara abo bak ne ausu re ine toxoro wan lo, me Jisas kaim kö arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mabo mön kabise meri xö lagunon Taiberias toxo ösö lörörö xina lagunon niang a marakörö toxo en a beret niang e Jisas ixo tengen deek ulamun. ");
INSERT INTO bjk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma nang a nangadi toxo ösöxö lo bere Jisas mabo bak ne ausu rine kawaim, idi toxo kaa xöbo mön ma toxo muu uruo Kaprenaum rua winara rö ine. ");
INSERT INTO bjk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma niang idi toxo pere wösöt lo e Jisas kö gegene tu, idi toxo tengen te ine, “Tene Ausu, u wan ura lause?” ");
INSERT INTO bjk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Io, Jisas ixo balu idi, “Turunon saxit, mum mo wawara siwin e, möxösa, mum moxoro en a beret me mum moxoro masii xönan. Ma lamun mum kobo wawara rö e, möxösa, mum muru perexulen abo auxileng niang e xo pet. ");
INSERT INTO bjk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ganim e mum pa tinörön lamun a nien niang irabo saban. Ma lamun mum morobo rörön lamun a nien niang irabo kisisik iat ma irabo isik a to ulorexe. A Barok kö Tödi irabo tabaa e mum ma ina nien na, möxösa, e God a Tamana ixoro osen bara i maraxa sik kö niang ine i wewet.” ");
INSERT INTO bjk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Io, idi toxo ose e Jisas, “Mem marabo mana pet a sa rua wewet abo tinörön niang e God i mamaa ulamun?” ");
INSERT INTO bjk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Me Jisas ixo balu bira, “A tinörön niang e God i maa bara mum morobo pet i bira. Mum morobo nunu xö öng niang e God ixoro tile ine ura.” ");
INSERT INTO bjk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Io, idi toxo ose ine, “A mangana auxileng lölös sa iang örobo pet niang mem marabo pere, me mem marabo nunu re nöngön? Örobo pet a sa? ");
INSERT INTO bjk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Abo untubuno ire toxo en a manna ruso xö xönö tataun. Ma tinenge re God niang toxo geet i tengen bira: ‘Ixo tabaa idi ma beret meriso xö watmaep pua enen.’” ");
INSERT INTO bjk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Io, Jisas ixo tengen te idi, “Turunon saxit, kawaim bere Moses iang ixo tabaa e mum ma beret meriso xö watmaep, ma lamun a Tamake iang i tabaa e mum ma beret tunon meriso xö watmaep. ");
INSERT INTO bjk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Möxö a beret meriso re God, ine mon a öng niang ixo wan su meriso xö watmaep ma i isik a to xö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Io, idi toxo tengen te ine, “Orong, mem me maa bara örobo tabaa sösöxöin e mem ma ina beret.” ");
INSERT INTO bjk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Me Jisas ixo wöwörö re idi bira, “E mon a beret möxö to. Ewenene niang i wan pösöt e i kebeöt ta irilöng, me ewenene niang i nunu re e i kebeöt ta minauu. ");
INSERT INTO bjk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ma xarniang e xoro tengen te mum, mum moxoro pere e, lamun mum kobo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Me idi xirip niang e Tata i tile idi ura re e, idi tabo wan ura re e. Me ewe a öng niang i ot pösöt e, e kebeöt ta tile rewe ine, ");
INSERT INTO bjk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","möxösa, e xoro wan su meriso xö watmaep pua wewet eörin a mamaa xö öng niang ixo tile e ura. Me e kara muu a mamaa iat te e. ");
INSERT INTO bjk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma a mamaa rewe niang ixo tile e ura i bira. I maa bara e bele ömalim tewe re öng mere idi xirip ewe niang ixoro tabaa e min. Lamun e rabo öraru öbaling idi xö axana bung möxö xakawöm, ");
INSERT INTO bjk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","möxösa, a Tamake ibo maa bara idi xirip ewe niang te perexulen a Barok ke ine ma te nunu bölök ke ine, idi tabo kip a to ulorexe. Me e rabo öraru öbaling idi xö axana bung möxö xakawöm.” ");
INSERT INTO bjk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma marakörö toxo bala kadik ma toxo urulo ra tinenge oleleng lamun ine, möxösa, ixo tengen bara, “E mon a beret niang ixo wan su meriso lömö xö watmaep.” ");
INSERT INTO bjk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Me idi toxo tengen, “Ine mon e Jisas a bak ke Josep, me ire te ösöxö sik a tamana ma nene. Ma bara bule belek i tengen bara ixo wan su meriso xö watmaep?” ");
INSERT INTO bjk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Io, Jisas ixo tengen tö idi, “Ganim e mum pa tinenge oleleng kaluluonin e mum iat. ");
INSERT INTO bjk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kaim pe öng i kebeöt tua nuanot ura re e niang bara a Tamake i kobo silien ine, ma arabo öraru öbaling ine xö axana bung möxö xakawöm. ");
INSERT INTO bjk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Abo propet toxoro geet bira: ‘God irabo usu idi xirip.’ Me idi xirip ewe niang te ölangen e Tata ma te kip a ausu xalik ine, irabo wanot ura re e. ");
INSERT INTO bjk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Niang e rengrengen bira, i kobo turunon bara re öng ixoro pere a Tamake. Kawaim. Öng kalik mon niang ixo wanot meriso re God, ine xalik mon iri pere e Tata. ");
INSERT INTO bjk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Turunon saxit, ewenene niang i nunu re e irabo kip lo a to ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","E mon, a beret möxö to. ");
INSERT INTO bjk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Abo untubuno mum toxo en a manna xö xönö tataun, ma lamun idi toxo met. ");
INSERT INTO bjk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lamun a na a beret niang i wan su meriso xö watmaep, me ewe i en i karabo met. ");
INSERT INTO bjk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","E mon a beret möxö to niang ixo wan su meriso xö watmaep. Nang bara ewenene niang i en ina beret, irabo to ulorexe saxit. Ma a beret niang e rabo tabaa idi min, ine a aike niang e rabo isik tewe, bara a nangadi tabo kip a to.” ");
INSERT INTO bjk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nang ine ixo tengen sik bira, abo Judeia toxo egot kaluluonin idi iat ma toxo tengen, “Ina tödi na irabo isik a aine bule rö ire ra enen?” ");
INSERT INTO bjk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Me Jisas ixo tengen te idi bira: “Turunon saxit, nang bere mum kobo en a aine a Barok kö Tödi, ma mo köbo inim a dee rine, kaim pe to i karabo kis se mum. ");
INSERT INTO bjk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Lamun ewenene niang i en a aike ma i inim a dee re e, a to ulorexe saxit i kis se ine, ma arabo öraru öbaling ine xö axana bung möxö xakawöm, ");
INSERT INTO bjk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","möxösa, a aike, ine a nien tunon, ma dee re e, ine a ininim tunon. ");
INSERT INTO bjk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ewenene niang i en a aike ma i inim a dee re e, ine i kis arixe me e, me e kis arixe mine. ");
INSERT INTO bjk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A Tamake niang ixo tile e ura, ine ma to, me e to sik, möxösa, ine i to. Io, ewe nang i en e, irabo to, möxö e to sik. ");
INSERT INTO bjk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ina beret mon na niang ixo wan su meriso xö watmaep. Ma i kobo xarnang a manna niang abo untubuno ire toxo en ma toxo met. Ma lamun ewe niang i en ina beret irabo to ulorexe.” ");
INSERT INTO bjk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Io, Jisas ixo tengen im ina na niang ixo usu idi kölöme xö gunon ne sineseng ki Kaprenaum. ");
INSERT INTO bjk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma nang a oleleng ne bak ne ausu toxo ölangen ina na toxo tengen, “A ausu na a lak lölös köba. Ewenene runon im i eöt tua ömaraxen lo?” ");
INSERT INTO bjk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Me Jisas ixo ösöxö sik bara abo bak ne ausu toxo tenge oleleng lamun ina na. Io, Jisas ixo tengen tö idi, “A tinenge na i öriip gut abo bala mum? ");
INSERT INTO bjk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nang bara mum mo örasen bira, mum morobo döxömen bule niang bara mum mo pere a Barok kö Tödi niang irabo wan kaa baling urso xö xönö niang ixo ot mee! ");
INSERT INTO bjk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Tanono ibo isik a to. A lölös kö nangadi ibo lalaa tataun. Ma lamun abo tinenge niang e xo töngösen e mum min, tobo wanot meringan kö Tanono ma tobo isik a to. ");
INSERT INTO bjk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lamun a dauleng iat te mum tokobo nunu.” Jisas ixo tengen bira, möxösa, me lorexe saxit ine ixoro ösöxö ewe ridi niang kaim kö nunu ma ewe niang irabo isik ine xö limine nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Me Jisas ixo tengen öbaling, “Ma ina na a unine e xoro tengen lorexe re mum bara kaim pe öng irabo eöt ta nuan ura re e niang bara Tamake i kobo öbala ine rua nuan bira.” ");
INSERT INTO bjk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma oleleng ne bak ne ausu re Jisas toxo wan kalik ine, me idi kaim kö eöt ta nuan arixe im mine, möxösa, ine ixo tengen bira. ");
INSERT INTO bjk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Io, Jisas ixo ose a sangaun ma ninöng ne bak ne ausu re ine bira: “Mum kobo mamaa bara mum bölök morobo wan?” ");
INSERT INTO bjk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Me Saimon Pita ixo balu ine bira, “Orong, mem marabo wan lo im pa ule? Abo tinenge re nöngön ibo isik a to ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mem me ösöxö sik ma me nunu bölök bara nöngön a Öng Nang a lak Madakdak meriso re God.” ");
INSERT INTO bjk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Io, Jisas ixo tengen te idi, “E iat e xo pere kos lo e mum a sangaun ma ninöng. Inexalik a öng ke mum a lak saban ine. I wawara bara i eöt ma önga tano saban.” ");
INSERT INTO bjk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ma ixo rengrengen mon e Judas, a barok ke Saimon Iskariot. Ma i turunon e Judas ine a öng möxö ina sangaun ma ninöng, lamun ine nang irabo isik e Jisas kö limine nangadi.) ");
INSERT INTO bjk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Io, melamu xina na, Jisas ixo wan kö boxönö xirip kölöme Galili. Ine ixo xisixis tewe xalik a xönö Judeia, möxösa, abo Judeia meringan idi toxo wawara siwin ine rua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Inexalik nang a Luxa möxöbo Gunon ne Walpali xöbo Judeia ixoro lörörö, abo tönö e Jisas idi toxo tengen tö ine, “Nöngön örobo mana wan tewe mera ma örö wan u Judeia rua nang abo bak ne ausu re nöngön idi tabo pere abo tinörön niang u bo wewet. ");
INSERT INTO bjk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nang bara re öng i maa bara tabo ösöxö ine, i kobo umingen a lasa nang ine ibo wewet. Kaim. Nang bara u bo wewet inabo lalaa na, örobo mana osen nöngön kö nangadi xirip.” ");
INSERT INTO bjk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Abo tönö ine toxo tengen bira, möxösa, idi bölök kaim kö nunu rine. ");
INSERT INTO bjk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Io, Jisas ixo tengen tö idi, “A axana bung ke e i kela wanot iat bang. Inexalik abo axana bung kirip ibo eöt te mum. ");
INSERT INTO bjk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A öxöno lagunon i kebeöt ta mölmölök kalik e mum, ma lamun idi te mölök kalik e, möxösa, e bo etöngösen ma turunon mere idi bara abo tatalien tidi a lak saban. ");
INSERT INTO bjk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Göm. Mum moro wan urungan kö luxa. Me e karabo wan urungan, möxö a axana bung ke e i kela wanot iat bang.” ");
INSERT INTO bjk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ma bara ine ixo tengen bira re idi, me ine ixo xisixis iat bang kingan Galili. ");
INSERT INTO bjk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma nang abo tönö ine, idi toxoro wan urungan kö luxa, Jisas ixo muu bölök. Ma kaim bara ixo wan kö malmalan. Ine ixo wan sixem lo mon. ");
INSERT INTO bjk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Io, ringan kö luxa, abo sisila ne Judeia toxo wawara siwin ine ma toxo ose bara, “Ule im ina tödi?” ");
INSERT INTO bjk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma a marakörö raxin idi toxo wöwörö lixilik nana lamun ine. Ma dauleng toxo tengen bara, “Ine a tödi deek.” Ma a dauleng kabise toxo tengen bara, “Kaim. Ine a öng nang ibo röxröxö lo a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Inexalik bara kaim pe öng ka tengen te laa ulamun ine xö wawara xö nangadi, möxösa, idi toxo buburin abo sisila ne Judeia. ");
INSERT INTO bjk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma nang a luxa ixoro önan aluo, Jisas ixo wan laxa urungan kö gunon ne lotu raxin ma ixo urulo ra eusu. ");
INSERT INTO bjk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma abo Judeia toxo wuwus me idi toxo ose bara, “Bule runon ma ina tödi na i ösöxö a oleleng ne lalaa ma kawaim ine ra inausu?” ");
INSERT INTO bjk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma nang e Jisas ixo ölangen bira, ixo tengen, “Abo inausu e eusu min, kaim bere re e iat. Ma lamun te ine ewe nang ixo tile e ura. ");
INSERT INTO bjk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nang bara ewenene i mamaa bara irabo muu abo mamaa xö God, ine iat irabo ösöxö lo abo inausu re e, bara meringan kalik e God, bara e wöwörö tataun mon kö dinödöm pe e. ");
INSERT INTO bjk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Me ewenene nang ibo wöwörö iat ma lölös sine, ine ibo ii öxaa öbaling iat ine. Ma lamun ewe a öng i maa bara irabo ii öxaa a öng ewe nang ixo tile ine, ine a tödi runon, ma kaim pe töxö xö to rine. ");
INSERT INTO bjk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mum moxo ösöxö bara Moses ixo isik abo warkurai te God urungan te mum. Inexalik kaim pe öng ke mum ibo mumuu inabo warkurai. Ma ruasa mum mo mamaa rua sesexomet e?” ");
INSERT INTO bjk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Io, a marakörö xirip toxo tengen tö ine, “A tano saban iri laxa re nöngön! Me ewenene i maa rua sesexomet nöngön?” ");
INSERT INTO bjk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas ixo balu a tinenge re idi bira, “E xo pet a önga laa mon me mum kirip moxo wuwus könan. ");
INSERT INTO bjk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Inexalik mum bo xurxuru a barok lik kö bung möxö Sabat, möxösa, Moses ixo isik ina warkurai re mum. (Ma lamun kaim bara ixo ot meringan te Moses. Abo tubu mum iat mee mesila toxo urulo.) ");
INSERT INTO bjk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nang bara te kuru a önga barok lik kö bung möxö Sabat, xalik e mum bo lexe a warkurai te Moses, ruasa me mum mo laie re e, möxösa, e xo ölanglanga xirip a miniset kö tödi xö bung möxö Sabat? ");
INSERT INTO bjk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ganim e mum pa werwere wuxus ma werwere ödeek abo lalaa xarnang köbo winawara re mum iat. Inexalik mum morobo pere runin abo lalaa.” ");
INSERT INTO bjk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Io, dauleng ne nangadi meringan Jerusalem, idi toxo rengrengen bira, “Ina tödi mon na nang idi te maa rua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Moro pere! Ine iat i wöwörö xö wawara xö nangadi xirip. Inexalik idi kawaim kö rengrengen te tinenge re ine. Ma abo sisila te ösöxö gut bara turunon ine a Mesaia? ");
INSERT INTO bjk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Inexalik bara ire tere ösöxö bara ina tödi ine mole. Ma nang bara a Mesaia irabo wanot, kaim pe öng irabo ösöxö bara ine i wanot mole.” ");
INSERT INTO bjk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ma nang e Jisas nangen ixo eusu kölöme xö xönö möxö gunon ne lotu raxin köbo Judeia, ine ixo tengen bira, “Mum mo döxömen bara mum mo ösöxö e me mum mo ösöxö bölök bere e mole. E kobo wanot kö mamaa re e iat. Inexalik a öng nang i tile e ura, ine ibo wewet abo turunon. Me mum kobo ösöxö ine. ");
INSERT INTO bjk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inexalik e ösöxö ine, möxö e mere ine me ine ixo tile e ura.” ");
INSERT INTO bjk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ma bara ine ixo tengen bira, idi toxo mamaa rua rörödik ine. Ma lamun kaim pe öng ka sisigi ine, möxö a axana bung kine i kobola wanot bang. ");
INSERT INTO bjk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Inexalik dauleng ke idi kölöme xina marakörö, idi toxo nunu rine. Idi toxo tengen, “Nang bara Mesaia irabo wanot, i eöt bara ine irabo pet ot tebo oleleng ne auxileng kö ina tödi na ixo pet?” ");
INSERT INTO bjk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Abo Parasi toxo ölangen a marakörö toxo wöwörö lixilik mabo mangana lalaa ulamun ine. Io, abo pris tataxin ma abo Parasi toxo tile rewe a dauleng ne umri ewe idi tobo ruruu wi a gunon ne lotu raxin bara idi tabo töndik e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas ixo tengen, “E kebeöt ta kinis ömat me mum. Kaim. Ma ulik melamu e rabo wan urungan kö öng ewe nang ixo tile e ura. ");
INSERT INTO bjk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mum morobo wawara nana rö e, nexalik mum korobo eöt ta werwere lo e. Ma xönö nang e rabo xisixis könan, mum korobo eöt bara mum morobo wan uwe.” ");
INSERT INTO bjk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma abo Judeia toxo wöwörö nana iat tidi bara, “Ina tödi na i maa rua nuan taule, io nang ire tekebeöt ta werwere lo ine? Bule, nagut ine irabo wan kalik ina xönö ma irabo kis arixe mabo nangadi re ire ewe nang te xisixis nana xöbo xönö möxöbo Grik ma irabo usu inabo Grik? ");
INSERT INTO bjk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Me ine ixo tengen bara ire tabo wawara nana rö ine, nexalik ire takarabo eöt ta werwere lo ine, ma nang bara ine i kis kö xönö sa, ire bölök tekebeöt bara ire tabo wan uwe. Bule runon ma i tengen bira?” ");
INSERT INTO bjk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Io, a bung möxö öxöwöm a luxa, ma ixo önga bung taxin. Ma xina bung, Jisas ixo taru kaa ma ixo wöwörö raxin bira, “Nang bara ewe re öng i minauu, irabo wan pösöt e ma irabo inim. ");
INSERT INTO bjk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ewenene i nunu re e, abo ari möxö to irabo sen meringan kölöme rine xarnang abo tinenge xö God idi toxo geet i tengen bie.” ");
INSERT INTO bjk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisas ixo tengen ina na ulamun a Töxödös ne Tanono, nang abo tene nunu re ine tabo kip lo, möxö God i kela isik a Tanono, möxösa, a mariris se Jisas i kela wanot maras bang. ");
INSERT INTO bjk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ma nang a dauleng ne nangadi toxo ölangen abo tinenge ine ixo tengen, io, idi toxo tengen bara, “Turunon saxit, ina tödi na ine iat mon a propet ewe nang toxo xuxubus ulamun ine.” ");
INSERT INTO bjk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma dauleng kabise toxo tengen bara, “Ine a Mesaia.” Inexalik a dauleng iat baling toxo ose bara, “A Mesaia irabo ot bule mee Galili? ");
INSERT INTO bjk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","I kobo eöt bira, möxösa, abo ginigeet te God i tengen bara a Mesaia irabo wanot meringan kö untubuno e Dewit, ma i wanot mee Betliem, a lagunon nang e Dewit ibo xisixis ee.” ");
INSERT INTO bjk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Io nang, a nangadi toxo tawalang kua gene Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","A dauleng kidi toxo mamaa rua rörön dik ine, ma lamun kaim pe öng ka sisigi ine. ");
INSERT INTO bjk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Io, abo umri ewe nang tobo ruruu wi a gunon ne lotu raxin, idi toxo tawuxus baling urungan köbo pris tataxin ma abo Parasi. Mabo sisila toxo tengen tö idi, “Ruasa me mum kobo lamus ine ura?” ");
INSERT INTO bjk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma abo umri toxo balu idi bira, “Kaim turunon iat bara re öng ibo wöwörö xarnang ina tödi na.” ");
INSERT INTO bjk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma abo Parasi toxo tengen öbaling kidi, “Ine iri ömamang bölök e mum, goo? ");
INSERT INTO bjk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Bule, rebo dauleng ne sisila ma bara rebo Parasi, idi te nunu bölök ke ine, goo? ");
INSERT INTO bjk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kaim! Inexalik ina marakörö raxin mon na nang idi tere pet bira. Lamun idi kaim pa ösöxö abo warkurai te God. Io nang, God irabo uguran sik idi xö minet.” ");
INSERT INTO bjk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Io, Nikodimas a öng bölök mere idi abo Parasi. Ine mon nang ixo ot pösöt bang e Jisas mesila, ma ixo tengen tö idi, ");
INSERT INTO bjk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Abo warkurai te ire i tengen bara ire tabo ölangen a tödi rua marmaras ulamun a lasa ine i pet mesila bara ire te eöt tua kure ine.” ");
INSERT INTO bjk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Io, idi toxo balu ine, “Go! Nöngön gut bölök meringan Galili? Örobo kos ödeek abo tinenge re God ma örobo pere lo bara önga propet i karabo wanot mee Galili.” ");
INSERT INTO bjk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Io, idi toxo wan urungan köbo lagunon tidi öngöng. ");
INSERT INTO bjk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisas ixo wan kaa uruso lömö xö Maii Olip. ");
INSERT INTO bjk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma xö puxu bubung ine ixo wanot baling kuso kölöme xö gunon lotu raxin niang a marakörö toxo ot luluruein ine. Io, ine ixo kis ma ixo urulo ra usu idi. ");
INSERT INTO bjk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abo tene ausu möxöbo warkurai te Moses mabo Parasi idi toxo lamus ölaxa önga une nang toxo pere lo ine ixo maru arixe ma önga tödi xabise nang kaim bara re ine. Me idi toxo uru ine xö wawara xö nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Me idi toxo tengen te Jisas, “Tene Ausu, a une na toxo pere lo ine ixo wewet a magingin saban arixe ma önga tödi. ");
INSERT INTO bjk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kölöme xö warkurai te Moses i tengen bara ire tabo teng ömet önga mangana une bira ma warawat. Me nöngön, örobo tengen bule?” ");
INSERT INTO bjk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Idi toxo tengen bira rua uxun ine bara idi tabo eöt ta tengen bara ine iri pet a sasaban. Ma lamun e Jisas ixo tunsu ma ixo urulo ra ginigeet kö pu arixe ma kasine limine. ");
INSERT INTO bjk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Niang idi toxo ose xöbanin ine, ine ixo taru kaa ma ixo tengen te idi, “Nang bara öng ke mum kaim ine ma magingin saban, ine irabo arun ta tewe a warawat urungan tine.” ");
INSERT INTO bjk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Me ine ixo tunsu baling ma ixo gegeet kö pu. ");
INSERT INTO bjk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Niang idi toxo ölangen ina na, idi toxo urulo ra nuan öngöng. Abo duöng tataxin toxo arun ta silien idi ot nang e Jisas kalik mon ma une nang nangen ixo tuu sik. ");
INSERT INTO bjk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas ixo taru kaa ma ixo ose ine, “Naang! Idi ule im? Kaim pe öng i kure bara örobo kip a ömokorot?” ");
INSERT INTO bjk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ina une ixo balu, “Kaim pe öng.” Io, Jisas ixo tengen, “E bölök e kobo kure bara örobo kip a ömokorot. Go, örö wan, ma lamun u bele wewet öbaling ke sasaban.” ");
INSERT INTO bjk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nang e Jisas ixo wöwörö baling kö nangadi, ine ixo tengen, “E a bibio möxö öxöno lagunon. Nang bara ewenene i muu e i kobo eöt tine ra nuan kö ködö, lamun irabo tön sik a bibio möxö to.” ");
INSERT INTO bjk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abo Parasi toxo tengen te ine, “A tinenge re nöngön i kobo lölös, möxösa, nöngön iat mon, u tengen ösu ina mangana lalaa na ulamun nöngön iat.” ");
INSERT INTO bjk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Io, Jisas ixo balu idi bira, “Kaim. Nang bara e tengen ösu lamun e iat, a tinenge re e i turunon sik, möxösa, e ösöxö a xönö nang e xo wanot mee ma xönö nang arabo wan uwe. Inexalik mum kobo ösöxö a xönö nang e xo wanot mee ma xönö nang arabo wan uwe. ");
INSERT INTO bjk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mum bo kure a nangadi arixe ma dinödöm pe mum iat mera xö öxöno lagunon. Ma lamun e kara ösöxö ra kure re öng. ");
INSERT INTO bjk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma lamun nang bara e kure re öng, a tinenge re e i turunon, möxösa, kaim bara e xalik mon. E arixe me Mama ewe nang ixo tile e ura. ");
INSERT INTO bjk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kölöme xö warkurai te mum iat, e Moses ixo geet bira: Nang bara ninöng te aut ulamun önga tinenge, io, ina tinenge i turunon. ");
INSERT INTO bjk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","E a öng nang i rengrengen ösu ulamun e, me Mama nang ixo tile e ura, ine bölök ibo rengrengen ösu ulamun e.” ");
INSERT INTO bjk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Io, idi toxo ose e Jisas, “A Tata re nöngön ule?” Jisas ixo balu idi, “Mum kobo ösöxö e, me mum kobo ösöxö bölök a Tata re e. Nang bara mum moxoro ösöxö e, mum morobo ösöxö bölök a Tata re e.” ");
INSERT INTO bjk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ine ixo wöwörö minabo tinenge na nang ine ixo usu a nangadi xö xönö möxö gunon lotu raxin lörörö xö xönö möxö bulbulus tuluwok. Kaim pe öng ixo tön ine, möxösa, a axana bung kine e kala wanot bang. ");
INSERT INTO bjk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ixo tengen öbaling ke idi, “E rabo wan kalik e mum, me mum morobo wawara siwin e, me mum morobo met kelen abo magingin saban te mum. A xönö nang arabo wan uwe, mum kobo eöt ta nuanot könan.” ");
INSERT INTO bjk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ina tinenge na ixo engin abo Judeia toxo eose, “Bule, irabo sexomet ine iat? Ina unine gut i tengen bira, ‘A xönö nang e rabo wan uwe, mum kobo eöt ta inot könan’?” ");
INSERT INTO bjk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Me ine ixo tengen bölök bira, “Mum mera xö pu. E meriso lömö. Mum mera xö öxöno lagunon. E kaim bara e mera xö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","E tengen te mum bara mum morobo met kelen abo magingin saban te mum. Nang bara mum kobo nunu bara e ewenene nang e bo rengrengen bere e ine, mum morobo met kelen iat abo magingin saban te mum.” ");
INSERT INTO bjk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Idi toxo ose, “Ewe nöngön?” Jisas ixo balu idi, “A lasanene iang e xo wöwörö min kö urulo. ");
INSERT INTO bjk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E ma oleleng ne tinenge rua rengrengen ma rua kure e mum min. Ma lamun öng nang ixo tile e ura, ine i turunon, ma a lasa nang e xo ölangen meringan te ine, e bo rengrengen kö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Idi kaim kö ösöxö bara ixo rerenge re idi ulamun a Tamana. ");
INSERT INTO bjk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Io, Jisas ixo tengen, “Nang bara mum mo ii öxaa a Barok kö Tödi, io, mum morobo ösöxö bara e ewenene nang e bo rengrengen bere e ine, me e kara ösöxö ra wewet te laa xö dinödöm pe e iat. Lamun e bo wöwörö ma lasa mon e Mama ibo usu e min. ");
INSERT INTO bjk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ewe nang i tile e, i kis arixe me e. Ine i kara wan pes e, möxösa, e bo wewet eörin a lasa ibo öaxanan ine.” ");
INSERT INTO bjk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma nang ine ixo wöwörö bira, a oleleng toxo nunu rine. ");
INSERT INTO bjk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisas ixo tengen urungan köbo Judeia nang toxo nunu rine bira: “Nang bara mum mo töndik abo inausu re e, mum abo bak ne ausu runon te e. ");
INSERT INTO bjk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Io, mum morobo ösöxö a turunon, ma a turunon irabo ömamanaa e mum kalik abo kunubus se mum.” ");
INSERT INTO bjk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Idi toxo balu ine, “Mem abo untubuno e Abaram ma kaim pe öng ixo kut dik e mem bara mem marabo rörön lawu rine. Ma bule u tengen bara örobo ömamanaa e mem kalik abo kunubus?” ");
INSERT INTO bjk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisas ixo balu bira: “Turunon saxit, ewe nang ibo wewet abo magingin saban, abo magingin saban te ine ibo xuxut dik ine. ");
INSERT INTO bjk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A tultul nang ibo wewet abo tinörön lölös kö önga barama i kobo eöt ta kinis ulorexe xina barama. Lamun a Barok ke Mama möxö ina barama irabo kis ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nang bara a Barok kö God irabo palas tewe e mum, io, mum morobo langlanga xalik abo kunubus kirip pe mum. ");
INSERT INTO bjk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E ösöxö bara mum abo untubuno e Abaram. Ma lamun mum ka sesexomet e, möxösa, a tinenge re e i kobo kis kölöme re mum. ");
INSERT INTO bjk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","E rengrengen a lasa nang e xoro pere lo xalik a Tata, me mum mo wewet a lasa nang mum moxoro ölangen kalik a tata re mum.” ");
INSERT INTO bjk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Io, idi toxo tengen, “Abaram a tata re mem.” Jisas ixo balu idi bira, “Nang bara mum mexebe a bung baroxorok ke Abaram, mum morobo mana pet abo lalaa nang Abaram ixo pet. ");
INSERT INTO bjk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma lamun nangen iat mum ka sesexomet e, me e ina tödi ewe nang ixo tengen abo turunon nang e xo ölangen meriso re God. Inabo mangana lalaa na Abaram kaim kö wewet. ");
INSERT INTO bjk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mum bo wewet abo lalaa nang a tamana e mum iat ibo wewet.” Io, idi toxo tengen te ine, “Mem kaim bara a bung baroxorok möxö ngas. E God kalik mon a Tata re mem.” ");
INSERT INTO bjk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas ixo tengen te idi, “Nang bere God a Tata re mum, mum moxoro mamaa re e, möxösa, e xo wan su meriso re God ma na e ia. E kobo wan su xö mamaa re e iat, lamun ine iat ixo uguran e ura. ");
INSERT INTO bjk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ruasa mum kobo maras kö tinenge re e? Möxö mum kobo ölangen kulen a sa e rengrengen. ");
INSERT INTO bjk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mum abo baroxorok kö tata re mum, e Satan, me mum ka mumuu eöt a mamaa re tata re mum. Mesila ine a tödi möxö sexomet nangadi ma i kobo ösöxö a turunon ulamun e God möxö kaim a turunon kölöme rine. Ma nang bara ibo etöxö, ibo rengrengen meringan iat tine, möxösa, ine a önga tene atöxö, ma tamana röxröxö. ");
INSERT INTO bjk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Me e belek, e bo rengrengen a turunon ulamun e God, ma ina unine bara mum kobo nunu xöbo tinenge re e. ");
INSERT INTO bjk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ewe re mum i eöt bara irabo tengen te e bara e xoro pet te sasaban? Ma nang bara e tengen a turunon, ruasa mum kobo nunu re e? ");
INSERT INTO bjk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ewe nang mere God ine ibo ölangen abo tinenge re God nang ibo rengrengen. Nang bara mum kobo ölangen abo tinenge re ine, a unine bara mum kaim bara mere God.” ");
INSERT INTO bjk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Abo Judeia toxo balu ine, “Mem bo rengrengen bara nöngön a Samaria ma bara a tano saban ixoro tup pe nöngön. I turunon, goo?” ");
INSERT INTO bjk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas ixo balu idi bira, “Kaim pe tano saban ixo tup pe e. Lamun e bo ii öraxin a Tamake, me mum bo öbulubun e. ");
INSERT INTO bjk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","E kobo ii öraxin öbaling a eseke, ma lamun nangen a öng nang i mamaa bara irabo ii öraxin a eseke, me ine a tene warkurai. ");
INSERT INTO bjk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Turunon saxit, ewe nang i töndik sik a tinenge re e, i kobo eöt ta minet.” ");
INSERT INTO bjk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma nang abo Judeia toxo ölangen ina na, toxo tengen bira, “Na mem me ösöxö bara a tano saban i tup pe nöngön. Abaram ixo met, ma abo propet bölök. Inexalik u tengen bara ewe nang i muu eörin a tinenge re nöngön ine i kobo eöt ta minet. ");
INSERT INTO bjk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nöngön u kobo taxin kö untubuno e mem, Abaram. Ine ixo met mabo propet bölök. U döxömen bara ewe nöngön nang u tengen bira?” ");
INSERT INTO bjk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Io, Jisas ixo balu bira, “Nang bara e ii öraxin a eseke iat, a laa tataun mon ine. A Tamake ewe nang mum bo rengrengen bara ine a God te mum, ine ewe nang ibo ii öraxin a eseke. ");
INSERT INTO bjk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Me mum kobo ösöxö ine, nexalik e ösöxö sik ine. Nang bara e xoro tengen bara e kobo ösöxö ine, e a tödi toxo xarnang e mum. Ma lamun e ösöxö ine me e muu eörin abo tinenge rine. ");
INSERT INTO bjk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","A tamana e mum nang e Abaram ixo axanan, möxösa, ine ixo ösöxö bara irabo pere a axana bung ke e. Ine ixo pere ma ixo axanan.” ");
INSERT INTO bjk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma abo Judeia toxo tengen te ine, “Nöngön u kala pitnö ne sangaun ne awat, ma bara bule u tengen bara uru pere e Abaram?” ");
INSERT INTO bjk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Me Jisas ixo balu idi, “Turunon saxit, kaim bang a xikip e Abaram, me e iat mon nangen.” ");
INSERT INTO bjk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma nang idi toxo ölangen ina na, idi toxo ii a warawat ta reteng ine, lamun e Jisas ixo mun kalik idi ma ixo wan kalik ina xönö möxö gunon ne lotu raxin. ");
INSERT INTO bjk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ma niang e Jisas ixo önan, ixo pere a önga tödi toxo kip ine ma lak pulo. ");
INSERT INTO bjk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mabo bak ne ausu rine toxo ose ine, “Tene Ausu, ewenene ixo pet a magingin saban ma niang toxo kip ine ixo pulo? Ina tödi bara a tamana arixe me nene?” ");
INSERT INTO bjk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisas ixo tengen, “Kaim pe öng mere idiet ixo pet te sasaban. Ma lamun ina na ixo ot bira rua osen a tinörön te God kölöme xina tödi. ");
INSERT INTO bjk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nang bang i xaken sik, ire tabo mana pet a tinörön te ine ewe niang ixo tile e. A ködö irabo ot, ma i kebeöt im bere re öng irabo rörön. ");
INSERT INTO bjk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nang e ia xö öxöno lagunon, e a bibio möxö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nang ixoro tengen sik biringan ixo gigisip kö pu, ma ixo pet arixe ma pixak ma ixo bulus kö nine marna. ");
INSERT INTO bjk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Me Jisas ixo tengen kö ina tödi, “Örö wan ma örö etos kö ina Marna Ari Siloam.” (A unine a esene Siloam bara ‘Uguran’.) Io, ina tödi ixo wan ma ixo etos. Ma ixo wan baling urungan kö lagunon ma nine marna ixoro tamasawang. ");
INSERT INTO bjk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Abo duöng nang toxo ösöxö sik ine me idi ewe nang toxobo werwere ine nang ixobo seseseng marmaris ulamun a tuluwok, idi toxo wöwörö nana bara, “Ine mon ina tödi nang ixobo kisisik kingan ma ixobo seseseng marmaris ulamun a tuluwok. Goo?” ");
INSERT INTO bjk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dauleng toxo aut bere ine iat mon. Ma dauleng kabise toxo tengen bara, “Kaim. I wawara mon xarnang ine.” Melamu ine iat ixo tengen osen bara, “E mon ina tödi.” ");
INSERT INTO bjk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Io, idi toxo ose ine, “Bara bule ma nini maram i tamasawang?” ");
INSERT INTO bjk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Me ine ixo tengen, “A tödi nang tobo rengrengen ine me Jisas ixo pet a dauleng ne pixak, ma ixo bulus lömö xö nine marake. Ma ixo tile e bara arabo wan urungan kö Marna Ari Siloam, ma arabo etos, ma arabo eöt ta winawara.” ");
INSERT INTO bjk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Me idi toxo ose ine, “A tödi nang ule?” Ma ixo balu idi bara, “E kobo ösöxö.” ");
INSERT INTO bjk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Io, idi toxo lamus ot ina tödi ewe nang ixo pulo mesila urungan köbo Parasi. ");
INSERT INTO bjk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma xö bung nang e Jisas ixo pet a pixak ma ixo sawang a nine marna ina tödi, a bung Sabat ine. ");
INSERT INTO bjk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Io, abo Parasi toxo ose bölök ine bara bule ma ixo wawara. Ina tödi ixo tengen, “Ixo bulus a pixak kö nine marake, me e xo etos ma na im e re wawara.” ");
INSERT INTO bjk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","A dauleng ne Parasi toxo tengen, “Ina tödi na kaim bere ine meringan te God, möxö i kara muu eörin a warkurai möxö bung Sabat.” Inexalik a dauleng kabise toxo tengen, “I kebeöt iat te önga tene saban irabo pet te mangana uxileng lölös bira.” Io, idi toxo tawalang nine axan. ");
INSERT INTO bjk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Io, idi toxo ose öbaling ina tödi ewe nang ixo pulo sila bira, “Ina tödi ixo sawang a maram. Örobo tengen bule rö ine?” A tödi nang ixo balu bara, “Ine a propet.” ");
INSERT INTO bjk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma lamun abo Judeia kaim iat idi xö nunu bara ixo pulo ma bara ixoro wawara baling, ot toxo erile iat lamun a tamana ma nene ina tödi. ");
INSERT INTO bjk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Me idi toxo ose idu, “Ina barok ke mu im, a? Ina barok mon niang mu moxo tengen bara u xo kip ine ma lak pulo? Ma bara bule ma na iri wawara im?” ");
INSERT INTO bjk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A tamana ma nene toxo balu, “Maa me ösöxö bara ine a barok ke maa. Me maa me ösöxö bölök bara toxo kip ine ma lak pulo iat. ");
INSERT INTO bjk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma lamun maa me köbo ösöxö bara bule niang i wawara im, ma bere ewe ixo sawang a nine marna. Mum moro ose ine. Kaim bara barok lik bang ine. Irabo wöwörö maras sö ine iat.” ");
INSERT INTO bjk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma tamana ma nene toxo tengen biringan, möxösa, idu toxo buburin abo Judeia. Ma unine bira. Abo Judeia toxoro kubus tinenge sik bere ewenene a öng nang i tengen osen bara i nunu bere Jisas ine a Mesaia, idi tabo kip tewe ine bara i bele lotu. ");
INSERT INTO bjk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xö ina na mon niang a tamana ma nene toxo tengen bara, “Kaim bara barok lik bang ine. Moro ose ine.” ");
INSERT INTO bjk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Önga axana bung baling idi toxo erile xö ina tödi ewe nang ixo pulo sila, ma toxo tengen te ine, “Örö ösugurno urso re God bara örobo tengen a turunon na. Mem me ösöxö bara a tene sasaban ina tödi na.” ");
INSERT INTO bjk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma ixo balu, “Nang bara ine a tene saban bara kaim, e kobo ösöxö. A önga laa xalik e ösöxö ine na. E xo pulo mesila, lamun na im e re wawara.” ");
INSERT INTO bjk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Io, idi toxo ose ine, “A lasa ine ixo pet te nöngön? Ixo sawang a maram bara bule?” ");
INSERT INTO bjk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma ixo balu, “E xoro tengen te mum lamun mum kaim kö ölangen kulen. Ma ruasa mum mo maa baling kua ölangen? E örasen bara mum mo mamaa gut bara mum morobo bung bak ne ausu re ine bölök?” ");
INSERT INTO bjk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Me idi toxo ösaxit ine ma toxo tengen, “Nöngön gut mon a önga bak ne ausu möxö ina tödi! Ma lamun e mem abo bak ne ausu re Moses! ");
INSERT INTO bjk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mem me ösöxö sik bere God ixo wöwörö urungan te Moses. Ma lamun ina tödi na, mem kobo ösöxö bara i wanot mole.” ");
INSERT INTO bjk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma ina tödi ixo balu bira, “Önga mangana laa iat! Mum kobo ösöxö i wanot mole. Inexalik bara ine ixo sawang a nine marake. ");
INSERT INTO bjk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ire te ösöxö bara God i kara tame abo siniseng köbo tene sasaban. Ma lamun ibo tame idi ewe nang tobo ii ine ma tobo wewet eörin a mamaa re ine. ");
INSERT INTO bjk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xö urulo möxö uxixis möxö öxöno lagunon ot na, kaim pe öng ixoro ölangen bara toxo sawang a marna önga tödi nang toxo kip ine ma marna a lak pulo. ");
INSERT INTO bjk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nang bara ina tödi na kaim kö nuanot meriso re God, ine i karabo eöt tua wewet te laa.” ");
INSERT INTO bjk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Io, idi toxo balu ine bira, “Toxo kip nöngön kölöme xö magingin saban kalik mon, ma u ka usu e mem?” Me idi toxo irewese ine xalik a gunon ne siniseng. ");
INSERT INTO bjk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ma nang e Jisas ixo ösöxö lo bara toxoro irewese ine, Jisas ixo wan ma ixo parasiwin ine. Ma nang ixo pere lo ine, ixo tengen, “Nöngön u nunu xö Barok kö Tödi?” ");
INSERT INTO bjk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma ina tödi ixo ose ine bira, “Orong, ewenene ine? Örö töngösen e lamun e rabo nunu re ine.” ");
INSERT INTO bjk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Me Jisas ixo tengen, “Uru pere ine, me ine mon niang i etöngösen arixe me nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Io, ina tödi ixo tengen, “Orong, e re nunu.” Ma ixo lotu wösöt e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Me Jisas ixo tengen, “E wanot ura xö öxöno lagunon tua pet warkurai. Lamun ina na, abo duöng marapulo tabo wawara, mabo duöng nang tobo wawara tabo pulo.” ");
INSERT INTO bjk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma uleng ne Parasi ewe nang toxo arixe me ine toxo ölangen a lasa nang ixo tengen ma toxo ose ine, “A sa? E mem bölök abo marapulo?” ");
INSERT INTO bjk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas ixo tengen, “Nang bara abo mara mum a lak pulo, io, kaim pe magingin saban irabo kis se mum. Ma lamun na mum mo rengrengen bara mum mo wawara sik. Möxö ina na, abo magingin saban te mum irabo malaa sik iat bie.” ");
INSERT INTO bjk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Turunon saxit, a tödi nang i kobo laxa kölöme xö marame möxö tabörö möxöbo sipsip, ma lamun ine ibo laxlaxa xöröp mon, ine a önga tödi pinilo. ");
INSERT INTO bjk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Io, a tödi nang i laxa xö marame laxlaxa, ine a tene walbalaurai möxöbo sipsip. ");
INSERT INTO bjk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A tene walbalaurai möxö marame ibo sasawang a marame ulamun ine. Ma abo sipsip tobo ölangen kulen a inöno. Ma ibo xukuwe abo sipsip pe ine mabo esene idi, ma ibo silien ösu idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nang ine iri silien ösu idi, ine ibo wan mesila re idi. Io, abo sipsip tobo mumuu ine, möxösa, idi tobo ölangen kulen a inöno. ");
INSERT INTO bjk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma lamun idi tekebeöt tua mumuu re öng kabise. Kaim arixe. Idi tabo ulo rup tewe xalik ine, möxösa, idi tokobo ölangen kulen a inöno öng kabise.” ");
INSERT INTO bjk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Io, Jisas ixo isik a tinenge öwuo urungan te idi. Ma lamun kaim idi rua marmaras ulamun ina unine tinenge nang ine ixo rengrengen te idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lamun ina na, Jisas ixo tengen öbaling urungan te idi, “Turunon saxit, e iat a marame laxlaxa möxöbo sipsip. ");
INSERT INTO bjk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Idi xirip ewe nang tere wanot sila re e, idi abo tödi pinilo mabo tödi nang idi tobo önan sixem. Inexalik abo sipsip tekara tame idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","E iat, e a marame nilaxa. Ma bara ewe re öng i sölöng ke e, ine irabo kip a to. Ine irabo önan laxa ma irabo önan su, ma irabo pere wösöt lo a nien deek. ");
INSERT INTO bjk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A tödi pinilo ibo orot mon tua wuwulo ma rua arsexomet ma rua ögarin abo sipsip. Me e xo wanot bara idi tabo kip a to, ma to nang irabo wöwö re idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","E iat, e a tene walbalaurai deek möxöbo sipsip. Ma a tene walbalaurai deek ibo isik tewe a to re ine xelen idi abo sipsip. ");
INSERT INTO bjk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Inexalik a öng nang toxo kun mon ine, kaim bara ine ina tene walbalaurai nang ibo unan sik abo sipsip. Io, nang bara i pere re wuluwun axe i önan ot, irabo wan lie abo sipsip ma irabo ulo rup. Io, ina wuluwun axe irabo kat abo sipsip ma irabo wasak elixilixin idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ina tödi irabo ulo rup, möxösa, toxo kun mon ine ma i kara niniang muu abo sipsip. ");
INSERT INTO bjk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“E iat, e a tene walbalaurai deek möxöbo sipsip. Me e ösöxö sik abo sipsip pe e, me idi te ösöxö sik e. ");
INSERT INTO bjk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","I xarnang mon a Tamake i ösöxö sik e, me e ösöxö sik bölök ine. Me e isik tewe a to re e xelen idi abo sipsip. ");
INSERT INTO bjk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Io, e ma dauleng nebo sipsip kabise nang kaim bara idi mera xö löng möxöbo sipsip. E rabo mana lamus bölök idi. Idi bölök tabo ölangen a inöno e, me idi xirip tabo önga muxu ne sipsip ma irabo önga tene walbalaurai mon te idi. ");
INSERT INTO bjk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","A unine bara e Tata i mamaa xöba ulamun e bira:, möxösa, e rabo isik tewe a to re e, ma arabo xikip lo öbaling. ");
INSERT INTO bjk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma lamun kaim pe öng i eöt ta xikip lo a to re e xalik e. Inexalik kö dinödöm iat te e, e isik tewe, möxösa, e iat e lölös sua isik tewe a to re e me e lölös bölök kua xikip lo öbaling. Me Mama re e ixo tengen tö e bara arabo pet bie.” ");
INSERT INTO bjk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nang abo Judeia toxo ölangen bira, idi toxo tawörök kö nine mangana dinödöm. ");
INSERT INTO bjk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ma oleleng ke idi toxo rengrengen bara, “A tano saban iri tup pe ine ma iri baulang. Rösa mum mo ölangen ine?” ");
INSERT INTO bjk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma dauleng toxo rengrengen bara, “A tinenge xö ina tödi na i kobo xarnang bara tano saban iri tup pe ine. Ma i eöt bara tano saban irabo sawang a maradi abo marapulo?” ");
INSERT INTO bjk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Io, ruso Jerusalem idi toxo pet a luxa bara idi toxo döxömen lo a axana bung nang idi toxo pet ödeek öbaling ina gunon lotu raxin. Ma ixo axana bung sisii. ");
INSERT INTO bjk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Me Jisas ixo önan kölöme xö gunon lotu raxin kö pu xö walpali re Solomon. ");
INSERT INTO bjk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Io, abo Judeia toxo erop pönö e Jisas ma toxo ose ine bara, “Lause im örobo tengen ömaras e mem lamun nöngön? Nang bara nöngön a Mesaia, io, örö tengen ömaras e mem.” ");
INSERT INTO bjk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Io, Jisas ixo balu idi, “E xoro tengen sik ke mum, ma lamun mum kobo nunu. Ma abo tinörön nang e wewet kö esene a Tamake, idi te etöngösen ulamun e. ");
INSERT INTO bjk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma lamun mum kobo nunu, möxösa, mum kaim bara abo sipsip pe e. ");
INSERT INTO bjk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Abo sipsip pe e, idi tobo ölangen kulen a inöno e me e ösöxö sik idi me idi tobo mumuu e. ");
INSERT INTO bjk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me e tabaa idi ma a to ulorexe, me idi tekebeöt ta iuiuo. Ma kaim pe öng irabo sat tewe idi xalik a limeke. ");
INSERT INTO bjk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A Tamake ewe nang ixoro isik idi ura re e, i taxin köba xöbo lalaa xirip. Ma kaim pe öng i kebeöt tua sasat tewe idi xalik a limine e Mama. ");
INSERT INTO bjk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Maa me Mama, maa me öng mon.” ");
INSERT INTO bjk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Io, abo Judeia toxo ii wat baling kua reteng ine. ");
INSERT INTO bjk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lamun e Jisas ixo tengen te idi, “E xoro osen te mum a oleleng ne tinörön deek meriso lömö re Mama. Me mum mo eka reteng e lamun a önga sa runon möxö inabo tinörön?” ");
INSERT INTO bjk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma abo Judeia toxo tengen, “Mem kobo mamaa ra reteng nöngön lamun abo tinörön deek ke nöngön. Kaim. Mem marabo teng nöngön lamun abo tinenge saban ulamun e God, möxösa, nöngön a tödi tataun mon ma u rengrengen bere nöngön e God.” ");
INSERT INTO bjk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Me Jisas ixo balu idi, “Xö warkurai te mum i nangen a önga tinenge re God nang toxo geet bara God ixo tengen bara, ‘Mum abo god.’ ");
INSERT INTO bjk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God ixo tengen idi a nangadi bara idi abo god. Ine ixo tengen idi ewe nang abo tinenge re ine ixo wanot pösöt idi. Me ire te ösöxö bara abo tinenge re God nang toxoro geet irabo kisisik ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Me Mama ixo bulus kabisenin e bara e rö ine iat, ma ixo tile ösu e ura xö öxöno lagunon. Io, rösa runon bara mum mo tengen bara e xo tengen ögarin e God nang e xo tengen bara, ‘E a Barok kö God’? ");
INSERT INTO bjk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ganim e mum pa nunu re e nang bara e kobo pet abo tinörön niang e Mama ibo wewet. ");
INSERT INTO bjk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma lamun nang bere e wewet inabo tinörön me mum kobo nunu xöbo tinenge re e, io, mum morobo mana nunu xöbo tinörön e wewet bara mum morobo ösöxö xulen bara Mama i kis kölöme re e me e kis kölöme re Mama.” ");
INSERT INTO bjk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Me idi toxo könönöin baling bara idi tabo töndik e Jisas, nexalik kaim idi xo eöt tua rörödik ine. ");
INSERT INTO bjk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Io, Jisas ixo wan lies baling kö Ari Jordan uruso xö xönö nang e Jon a tene baptais ixobo baptais a nangadi ee sila. Me Jisas ixo kis singan. ");
INSERT INTO bjk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma oleleng ne nangadi toxo wanot pösöt ine. Me idi toxo tengen, “I turunon bara Jon kaim kö wewet tebo auxileng lölös, ma lamun i turunon kirip abo tinenge nang e Jon ixo tengen ulamun ina tödi.” ");
INSERT INTO bjk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma oleleng toxo nunu re Jisas kölöme xina lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Io, önga tödi a esene e Lasarus ixo meset. Ine mee Betani a lagunon kö narön, e Maria me Mata. ");
INSERT INTO bjk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ine Maria mon na, ewe nang ixo linge a sada xö xexene Orong ma ixo us ömasa ma bebene öxöno. Ine mon a saxane Lasarus ewe nang ixo maru ma miniset. ");
INSERT INTO bjk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Io, idu narön toxo tile tinenge urungan te Jisas bira, “Orong, a tödi nang u mamaa xöba re ine i meset.” ");
INSERT INTO bjk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma nang e Jisas ixo ölangen ina na, ixo tengen, “Ina miniset i kebeöt ta sexomet ine. Kaim. Ma lamun ixoro ot biringan bara a nangadi tabo ölet a esene God tua a mariris ma lölös kö Barok kö God bölök irabo ot maras.” ");
INSERT INTO bjk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Me Jisas ixobo mamaa xöba re Mata arixe ma tönö ine e Maria, me Lasarus. ");
INSERT INTO bjk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Inexalik nang ixoro kip a tinenge bere Lasarus ixo meset, ixo kis baling kö nine bung. ");
INSERT INTO bjk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Io, melamu ixo tengen köbo bak ne ausu re ine, “Ire tabo wan baling uruso Judeia.” ");
INSERT INTO bjk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma lamun abo bak ne ausu toxo tengen, “Tene Ausu, la mon abo Judeia te maa ra reteng nöngön. Ma ruasa nöngön u maa ra nuanot baling urungan?” ");
INSERT INTO bjk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Io, Jisas ixo balu idi bira, “Ire te ösöxö bara önga sangaun ma ninöng ne axana bung i kis kölöme xö xaken. Ewe nang i önan kö xaken i kebeöt ta sinubu, möxösa, ibo wawara xö bibio möxö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lamun ewe a öng nang ibo önan kö ködö irabo subu, möxö kaim ine ma bibio.” ");
INSERT INTO bjk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Melamu nang ixoro tengen sik bira, Jisas ixo töngösen idi, “A ais se ire e Lasarus i paliso, ma lamun e önan ta ölaran ine.” ");
INSERT INTO bjk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Abo bak ne ausu toxo balu, “Orong, nang bara i paluso irabo langlanga baling.” ");
INSERT INTO bjk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Me Jisas ixoro wöwörö lamun a minet te Lasarus. Inexalik abo bak ne ausu toxo döxömen bara ixo rengrengen bere e Lasarus i paluso sik mon. ");
INSERT INTO bjk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Io, Jisas ixo ömaras idi bara, “Lasarus iri met. ");
INSERT INTO bjk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Me e axanan bara kaim e ra kinis arixe me ine, möxösa, a minet te ine irabo top e mum pua nunu. Inexalik na ire ta wan urungan te ine.” ");
INSERT INTO bjk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Io, Tomas (ewe nang toxobo rengrengen ine ma Xasang) ixo tengen köbo bak ne ausu xabise, “Ire bölök tabo wan ma tabo met arixe me ine.” ");
INSERT INTO bjk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nang e Jisas ixo wanot, ixo see lo bara idi toxoro bulus e Lasarus kölöme xö lieng möxöbo minet ma iri nit ne bung tuar te ine. ");
INSERT INTO bjk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Me Betani i kobo ömat meringan Jerusalem. I eöt ma narun ne kilomita. ");
INSERT INTO bjk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Möxö ina na, a oleleng ne Judeia idi toxo ot tua ömamanaa e Mata idu narön me Maria ulamun a minet te saxana idu. ");
INSERT INTO bjk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma nang e Mata ixo ölangen bara e Jisas ixo önan ot, ixo wan lo rua susuo me ine. Ma lamun e Maria ixo xisixis iat tingan kö gunon. ");
INSERT INTO bjk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Me Mata ixo tengen te Jisas, “Orong, nang bara u xoro arun iat bang ka, a saxake i kebeöt ta minet. ");
INSERT INTO bjk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Inexalik, e ösöxö tuar bara nang u seng e God ulamun a sa na, na mon e God irabo isik ke nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Me Jisas ixo tengen tö ine, “A saxam irabo taru baling kalik a minet.” ");
INSERT INTO bjk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ixo tengen tö ine, “E ösöxö bara ine irabo taru kaa baling kö bung möxö tinaru baling möxö minet kö axana bung möxö xakawöm.” ");
INSERT INTO bjk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Me Jisas ixo tengen tö ine, “E iat a tinaru baling me e iat ina to. Ewe nang i met, ma lamun i nunu re e, irabo to. ");
INSERT INTO bjk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Me ewenene nang i to ma i nunu re e i karabo eöt tua minet. U nunu lamun ina na, bara kaim?” ");
INSERT INTO bjk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Me Mata ixo aut ma ixo tengen te Jisas, “Orong, e xoro nunu bara nöngön a Mesaia, a Barok kö God niang toxo tengen bara irabo wan su ura xö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma melamu nang ixo tengen kirip ina na, ixo wan baling ma ixo kuwe lo e Maria a tönö urungan kö lawa, ma ixo tengen, “A Tene Ausu tuar a, ma i ose lamun nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nang e Maria ixo ölangen bira, ixo taru kaa pasaxit mon ma ixo wan su urungan te Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma kewene bang ine ra inot tingan kö lagunon. Ine angen bang kö xönö nang e Mata ixo esuo me ine ee. ");
INSERT INTO bjk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Abo Judeia ewe nang toxo xisixis me Maria rua öaxanan ine kölöme xö gunon, toxo pere bara ixo tuu pasaxit mon ma ixo wan su, io, idi toxo muu re ine. Idi toxo döxömen bara ine i önan uri xö lieng möxöbo minet tua ginee. ");
INSERT INTO bjk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma nang e Maria ixo ot kö xönö nang e Jisas ee, ixo pere e Jisas ma ixo subun kexe mesila re ine ma ixo tengen bira, “Orong, nang bara u xoro arun iat bang ka, a saxake i kebeöt ta minet.” ");
INSERT INTO bjk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nang e Jisas ixo pere e Maria bara ixo gegee arixe mabo Judeia nang toxo wanot arixe me ine, a balna ixo muu idi ma ixo tapunuk. ");
INSERT INTO bjk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jisas ixo ose idi, “Mum moxo ömarin ine ule?” Idi toxo balu ine, “Orong, örö miang ma örö pere!” ");
INSERT INTO bjk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","A line marna Jisas ixo sen. ");
INSERT INTO bjk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Io, abo Judeia toxo tengen nanin te idi iat bara, “Pere! I mamaa xöba lamun e Lasarus.” ");
INSERT INTO bjk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Inexalik a dauleng toxo tengen bara, “Ina tödi mon na nang ixo sawang a nine marna a marapulo. Ma ruasa i koxobo maa ra öro e Lasarus nang ixo eka minet?” ");
INSERT INTO bjk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ma a balna e Jisas ixo tiip köba ma ixo wan urungan kö lieng. Ma ina marna lieng toxo uxis pi ma önga wat. ");
INSERT INTO bjk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Me Jisas ixo tengen, “Mum moro irewe ina wat.” Ma lamun e Mata nang a saxana tödi nang ixoro met ixo tengen te Jisas bira, “Orong, a aine iri maxus, möxö na iri nit ne bung im pe ine.” ");
INSERT INTO bjk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Io, Jisas ixo tengen te ine, “Bule, e koxobo tengen te nöngön bara örobo pere a lölös se God nang bara örobo nunu?” ");
INSERT INTO bjk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Io, idi toxo irewe a wat me Jisas ixo wawara kaa ma ixo tengen, “Mama, e tengen deek ke nöngön, möxösa, u xo ölangen e. ");
INSERT INTO bjk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E ösöxö sik bara nöngön u bo ölangen e xöbo bung kirip, ma lamun e tengen ina na ulamun a nangadi na, bara idi tabo nunu bara u xo tile e.” ");
INSERT INTO bjk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Io, nang ine ixo tengen ina na, Jisas ixo kup lömö bira, “Lasarus, wan su!” ");
INSERT INTO bjk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A tödi minet ixo wan su, ma toxoro bun pi abo limine mabo xexene ma boxönö sewene man ömat, ma toxoro kait pi a mamaran te ine. Jisas ixo tengen te idi, “Moro kip tewe abo xönö man möxö minet ma moro gan sik ine ma ira wan.” ");
INSERT INTO bjk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma lamun ina na, a oleleng ne Judeia ewe nang idi toxo önan urungan tua uxileng e Maria, ma toxo werwere a lasa niang e Jisas ixo wewet, idi toxo nunu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Inexalik a uleng ke idi, toxo wan lo urungan köbo Parasi, ma toxo töngösen idi ma lasa e Jisas ixoro pet. ");
INSERT INTO bjk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Io, abo Parasi mabo pris tataxin toxo kis kö önga nuan etok ma toxo tengen, “Ire tabo pet a laa sanene? Ina tödi na i wewet a oleleng ne uxileng lölös. ");
INSERT INTO bjk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma nang bara ire te gan sik ine iat mon bira, a nangadi xirip tabo nunu re ine. Mabo Rom idi tabo wanot ma tabo pet ögat a gunon ne lotu re ire ma kantri re ire.” ");
INSERT INTO bjk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Io, önga tödi mere idi abo Parasi, a esene e Kaiapas, ewe nang ixo sila sik köbo pris kina awat niang ixo tengen, “Mum kobo ösöxö re laa! ");
INSERT INTO bjk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mum kobo maras bara i deek kö mum bara önga tödi mon irabo met ulamun a nangadi ma ganim bara ina kantri xirip tabo iuo.” ");
INSERT INTO bjk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ine kaim kö rengrengen ina na xöbo dödöxömen te ine iat. Kaim. Inexalik ine a sisila raxin möxöbo pris möxö ina awat. Lamun ina na, God ixo kure a tinenge re ine bara irabo tengen te tinenge propet ulamun e Jisas bara irabo met kelen a marapun ne Israel. ");
INSERT INTO bjk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma kaim bara xöbo marapun ne Israel kalik mon, ma lamun bara irabo met bölök ulamun idi abo barok ke God nang te kis elixilik nana rua lalamus etok idi bere idi tabo öng mon. ");
INSERT INTO bjk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Io, urulo im kö ina bung idi toxo epingit arixe rua sesexomet e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lamun ina niang, Jisas kaim kö sinasai nana xö wawara xöbo Judeia, nexalik ixo wan lo uruo xö xönö lörörö xö xönö tataun, kö lagunon a esene e Epraem. Ma ixo kis arixe mabo bak ne ausu ringan. ");
INSERT INTO bjk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma nang ixoro lörörö a axana bung möxö Luxa ne Nuan Lexe, a oleleng ne nangadi toxo wanot meringan köbo lagunon kö palaa uruso Jerusalem rua wewet eörin a warkurai te Moses bara idi tabo madakdak kö wawara xö ina warkurai. ");
INSERT INTO bjk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Me idi toxo wawara nana iat ulamun e Jisas. Ma nang idi toxo tuu xö xönö möxö gunon ne lotu raxin, idi toxo eose nana re idi bara, “Mum mo döxömen bule? I wawara bara i karabo wanot iat im ura xö Luxa, goo?” ");
INSERT INTO bjk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma abo pris tataxin mabo Parasi idi toxoro isik a tinenge lölös bara nang ewe re öng i see lo bara Jisas ule im, irabo tengen tö idi ra öxös lo ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma nang a pitnö ma öng ne bung kalik im mesila xö Luxa ne Nuan Lexe, Jisas ixo wan urungan Betani xö lagunon te Lasarus, ewe ine nang e Jisas ixo öro ine xalik a minet. ");
INSERT INTO bjk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Me idi toxo pet a nien taxin te Jisas singan ee. E Mata ixo söxö nien, me Lasarus a öng mere idi nang ixo kis arixe me Jisas kö nien. ");
INSERT INTO bjk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Io, Maria ixo kip lo a sada möxö sasalap tobo rengrengen ma ‘nart’, ma i eöt ma subana kilo. Ma xinuxun möxönan a lak taxin. Maria ixo kip lo ina sada ma ixo linge ösu xö nine xexene e Jisas, ma ixo salap mabo bebene öxöno. Ma a sixine möxö ina sada ixo wöwö xirip kö gunon. ");
INSERT INTO bjk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma lamun a önga bak ne ausu re ine, Judas Iskariot (ewe nang irabo isik tewe e Jisas), ixo tengen bira, ");
INSERT INTO bjk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rösanene bara ire tekobo misik ma ina sada rua xikip pebo tuluwok ma rua isik köbo maris? Ma i eöt ma xinuxun kö öng ibo xikip kö tinörön te ine xö önga awat.” ");
INSERT INTO bjk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas kaim kö rengrengen bira, möxösa, bara ine ixo marase abo maris. Inexalik ixo tengen bira, möxösa, ine a tene pinilo. Ma ixobo balbalaure a bubulus möxöbo tuluwok ke idi, ma ixobo xikip suxumenin a tuluwok meringan ee. ");
INSERT INTO bjk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma lamun e Jisas ixo tengen, “Ganim sik mon ina une uxe. I deek bara irabo tön sik ina sada niang ot kö bung möxö wöpömös ee. ");
INSERT INTO bjk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A nangadi maris idi tobo xisixis arixe me mum köbo bungbung kirip, ma lamun e karabo kis arixe me mum köbo bungbung kirip.” ");
INSERT INTO bjk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ma a marakörö raxin toxo see lo bara Jisas nangen niang Betani, io, idi toxo wanot uxe. Ma lamun kaim bara ra werwere xalik e Jisas, idi toxo wanot bölök kua werwere e Lasarus nang e Jisas ixo öraru ine xalik a minet. ");
INSERT INTO bjk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Io, abo pris tataxin toxo pingit tua sesexomet bölök e Lasarus, ");
INSERT INTO bjk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","möxösa, e Lasarus ine a unine ina na nang a oleleng ne Judeia toxobo ruruu rewe xalik idi abo pris tataxin, ma toxobo nunu re Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Xö önga bung kabise a marakörö raxin nang toxo wanot kina Luxa raxin toxo ölangen see lo bere Jisas iang i önan ot urungan Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Idi toxo kip abo labana beebee ma toxo wan su rua susuo me Jisas me idi toxo xukup nana bira, “Axabe e God! God irabo wadöane a öng nang i wanot tua wewet eörin a mamaa xö Orong! God irabo wadöane ina King köbo Israel!” ");
INSERT INTO bjk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Io, Jisas ixo pere lo a önga dongki maxat ma ixo xisin, xarnang toxoro geet ulamun ine i tengen, ");
INSERT INTO bjk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“A marakörö mee Jerusalem, mum bele bubuut. Pere bang! A king ke mum, ine na i önan ot ma i kisisik lömö xö önga dongki maxat.” ");
INSERT INTO bjk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma abo bak ne ausu re ine kaim idi xo marmaras sila ulamun abo lalaa xirip. Ma melamu belexim nang a mariris se Jisas ixo wanot maras, idi toxo döxömen lo bara toxoro pet inabo lalaa na urungan tö ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Io, a marakörö ewe nang toxo arixe me Jisas nang ine ixo kuwe ösu e Lasarus xalik a lieng möxöbo minet, ma ixo öro ine xalik a minet, idi toxo tengen esexerein a tinenge lamun e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A nangadi oleleng toxo wan su rua inesuo me ine, möxösa, toxoro ölangen bara ine ixo pet ina auxileng lölös. ");
INSERT INTO bjk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Io, abo Parasi toxo tengen nanin te idi iat bara, “Pere bang im! Ire tekexebe eörin im pua wewet te lalaa! Pere! A öxöno lagunon kirip im iri mumuu re ine!” ");
INSERT INTO bjk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma dauleng ne Grik bölök nangen nang kaluluonin idi ewe nang idi toxo wan kaa uruso Jerusalem rua lotu xö ina bung möxö Luxa raxin. ");
INSERT INTO bjk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Idi toxo wan pösöt e Pilip ewe nang ine mee Betsaida, kölöme Galili, ma toxo tengen tö ine, “Maris, mem me mamaa rua werwere e Jisas.” ");
INSERT INTO bjk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip ixo wan ma ixo tengen te Endru. Io, idu toxo wan ma toxo tengen te Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Me Jisas ixo balu idu bira, “A axana bung iri wanot bara a mariris möxö Barok kö Tödi irabo wanot maras. ");
INSERT INTO bjk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Turunon saxit, nang bara önga irine iaa i kobola subu kaa xö pu ma i kobola met, ina irine iaa irabo kisisik iat mon bara a irine iaa xalik mon. Inexalik nang bara i met, irabo o a oleleng ne pasuno iaa. ");
INSERT INTO bjk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ewenene re öng i mamaa xöba ulamun a to re ine iat, ine irabo ömalim tewe. Me ewenene re öng i mölök kalik a to re ine iat mera xö öxöno lagunon, irabo töndik sik iat a to ulamun a to ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Me ewenene re öng i mamaa rua tultul te e, ine irabo mana muu e. Ma nang bara e wan taule, a tultul te e bölök irabo wan uxe. Me ewenene nang i tultul tö e, e Mama irabo ii ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ma na a balake i tiip köba me e rabo tengen a sa? I deek gut te e rua rengrengen, ‘Mama örö kip tewe e xalik ina axana bung möxö kinadik’? Ma lamun kaim. Ina na a unine inot te e. E xo wanot bara e rabo laxa xina kinadik. ");
INSERT INTO bjk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mama, örö pet öraxin a esem!” Io, a inöno öng ixo tenge su meriso lömö xö watmaep bira: “E xoro pet öraxin sik ma na e rabo pet öraxin öbaling.” ");
INSERT INTO bjk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Io, a marakörö nang toxo tuu sik kingan ee, toxo ölangen ma toxo tengen bara a barawagas. Inexalik a dauleng toxo tengen bara önga angelo ixo wöwörö me ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisas ixo tengen, “Ina na i kobo wanot ulamun e, ma lamun i wanot ta xelen e mum. ");
INSERT INTO bjk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma na a axana bung möxö pet warkurai xö öxöno lagunon. Ma na God irabo bat tewe ina tene sisila saban möxö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Me e, nang bara tabo rarik e mera xö pu urso lömö, e rabo lamus lo a nangadi xirip ura rö e.” ");
INSERT INTO bjk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Me ine ixo tengen bira rua osen a mangana minet nang ine irabo met könan. ");
INSERT INTO bjk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma nangadi toxo balu ine bara, “Mem moxo ölangen bara a warkurai te Moses ixo tengen bara a Mesaia irabo kis ulorexe saxit. Ma bule belek nang u tengen bara tabo rarik a Barok kö Tödi urso lömö? Me ewe runon ina Barok kö Tödi?” ");
INSERT INTO bjk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Me Jisas ixo rengrengen bara, “A bibio irabo kis me mum kö ulik ne axana bung mon bang. Möxö ina na, mum moro wan nang ine nangen bang i bibio xudun, xalik a xödxödö irabo kawönö e mum. Ma a tödi nang i önan kölöme xö ködö i kobo ösöxö bara i önan taule. ");
INSERT INTO bjk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mum morobo mana nunu xina bibio na nang ina bibio i kisisik bang me mum, rue mum pa inot a nangadi möxö bibio.” Ma nang e Jisas ixo tengen sik bira, ixo wan lo ma ixo mun kalik idi. ");
INSERT INTO bjk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","A turunon bara ixo pet a oleleng nebo auxileng lölös kö wawara re idi. Inexalik idi toxo kaim kö nunu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ixo ot xarna na rua öturunon abo tinenge re propet Aisaia nang ixo tengen bira: “Orong, kaim pe öng iri nunu xö ina tinenge re mem, ma kaim pe öng iri kip pe dinödöm maras ulamun a lölös se nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma ina unine nang kaim idi xo nunu, möxösa, e Aisaia ixo tengen bölök bira: ");
INSERT INTO bjk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God ixo öwulo abo maradi ma ixo ölölös abo baladi, xalik idi tobo perexulen mabo maradi, ma xalik idi tobo ösöxö xulen kölöme xö baladi, me idi tobo dödöm puxus bara arabo öro idi.” ");
INSERT INTO bjk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia ixo tengen ina na, möxösa, ine ixo pere a mariris se Jisas ma ixo etöngösen ulamun ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma lamun i turunon kalik bara a oleleng kaluluonin abo sisila me Judeia toxo nunu re ine. Inexalik idi kaim kö rengrengen ösu a nunu re idi, möxösa, idi toxo buburin abo Parasi, bara xalik tobo pet pi idi xalik a gunon ne sineseng. ");
INSERT INTO bjk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Idi tobo mamaa bara a nangadi mon tabo ölet idi ma lamun tekobo mamaa bara God irabo ölet idi. ");
INSERT INTO bjk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Io, Jisas ixo tenge raxin bira: “Nang bara a tödi i nunu re e, ine i kobo nunu xalik mon te e, ma lamun kö öng ewe nang ixo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Me ewe nang i pere e, ine i pere bölök a öng nang ixo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","E xo wanot ura xö öxöno lagunon xarnang a bibio, nang bara a nangadi xirip nang te nunu re e, idi tekarabo kis im kö ködö. ");
INSERT INTO bjk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ma ewenene nang i ölangen abo tinenge re e ma i kobo tame, e iat, e karabo kure ine, möxösa, e kobo wanot tua kure a öxöno lagunon, nexalik kua öro ine. ");
INSERT INTO bjk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Inexalik bara ewe nang i öngus kalik e ma i kobo ömaraxen lo abo tinenge re e, ine angen kö warkurai. Ma ina tinenge nang e xo tengen irabo kure ine xö axana bung möxö xakawöm, ");
INSERT INTO bjk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","möxösa, e kara tenge xö dödöxömen te e iat. Kaim. Inexalik bara a Tata nang ixo tile e, ine iat ixo isik a tinenge lölös se e xö a lasanene arabo tengen ma arabo tengen bulungin. ");
INSERT INTO bjk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Me e ösöxö bara ina tinenge lölös sine nang ixo isik ke e, ibo isik a to ulorexe saxit. Ma a lasanene im nang e tengen, ine mon a lasa nang e Mama ixoro tengen te e bara arabo etöngösen min.” ");
INSERT INTO bjk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A Luxa ne Nuan Lexe ixoro lörörö im me Jisas ixo ösöxö bara a axana bung ke ine iri ot bara irabo wan kalik ina öxöno lagunon urso re Tata. Ine ixo mamaa xöba iat lamun a nangadi re ine na xö öxöno lagunon, ma ixo mamaa iat tö idi ot kö öxöwam möxö to re ine. ");
INSERT INTO bjk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Me Jisas mabo bak ne ausu toxo aan arixe xö ina dömön im möxö ina bung. Me Satan ixoro bulus dinödöm sik kö balne Judas Iskariot, a barok ke Saimon, bara rö ine rua isik tewe e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Me Jisas ixo ösöxö sik bara a Tamana ixoro isik kirip sik abo lölös se ine. Ma ixo ösöxö sik bölök bara ixo wanot meriso xö God ma lörörö bara irabo baling urso xö God. ");
INSERT INTO bjk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lamun ina na, Jisas ixo taru xalik a nien, ma ixo kip tewe a xönö man xinaxain te ine möxö araman, ma ixo kip lo a xönö man sasalap ma ixo laplawa min. ");
INSERT INTO bjk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Melamu xönan, ixo linge a ari xö bile, ma ixo urulo rua gisgis abo xexene idi abo bak ne ausu, ma ixo u-us ömasa arixin ma xönö man ixo laplawa sik min. ");
INSERT INTO bjk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Io, ixo wan urungan te Saimon Pita, me Pita ixo ose ine, “Orong, nöngön u mamaa rua roros a xexeke?” ");
INSERT INTO bjk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Me Jisas ixo balu ine bira, “A lasa nang e wewet na nöngön ökorobo maras könan, ma lamun melamu im örobo maras.” ");
INSERT INTO bjk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Io, Pita ixo tengen bira, “Kaim. Nöngön ökorobo tos a xexeke.” Me Jisas ixo balu bira, “Nang bere e kobo tos nöngön, io, nöngön ökorobo kis arixe me e.” ");
INSERT INTO bjk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita ixo tengen te ine bira, “Orong, nang bara bie, io, u bele tos kalik a xexeke, örobo tos bölök abo limeke ma öxöke.” ");
INSERT INTO bjk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas ixo balu ine bira, “Ewe nang iri etos sik irabo tos lo manin a nine xexene, möxösa, a aine xirip iri madakdak. Me mum moro madakdak sik, lamun kaim bere mum kirip.” ");
INSERT INTO bjk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Möxö ine ixo ösöxö sik ewenene niang irabo isik tewe ine, ma ulamun ina na, ine ixo tengen bara kaim bere idi xirip toxo madakdak. ");
INSERT INTO bjk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nang ixo tos kirip abo xexene idi, ixo sige lo abo man te ine ma ixo baling urungan kö xönö re ine ma ixo ose idi bara, “Mum muru maras lamun a lasanene nang e re pet sik ke mum? ");
INSERT INTO bjk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mum bo rengrengen e me ‘Tene Ausu’ ma ‘Orong’. Ma i turunon, möxösa, e mon niang. ");
INSERT INTO bjk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nang bere e a Tene Ausu re mum ma Orong ke mum me e xo tos abo xexene mum, io, mum bölök morobo mana tos ebasinin abo xexene mum. ");
INSERT INTO bjk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Io, e xo wewet biringan bere rue mum bölök, morobo pet bie xarnang e xoro pet tö mum. ");
INSERT INTO bjk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Turunon saxit, a tultul i kobo taxin sik kö orong ke ine. Ma kaim pe tene tinam i taxin kö öng nang ixo tile ine. ");
INSERT INTO bjk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I maras bara mum moro ösöxö inabo lalaa na. Io, irabo deek kö mum nang bara mum morobo pet bie. ");
INSERT INTO bjk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Io, e kobo wöwörö ulamun e mum kirip. E ösöxö sik ewe me idi nang e xoro pere kos lo. Inexalik ina na i ot tua öturunon a tinenge re God nang toxoro geet: ‘A tödi nang i en a beret arixe me e, i mamaa bara irabo ögarin e.’ ");
INSERT INTO bjk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","A laa nang e töngösen ösila e mum min i kala ot, nexalik nang bara i ot turunon, mum morobo nunu bere e ewenene ine. ");
INSERT INTO bjk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Turunon saxit, ewenene nang i öbala lo ewenene me idi nang e xo tile, i öbala e. Me ewe nang i öbala e, i öbala lo ewe a öng nang ixo tile e.” ");
INSERT INTO bjk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nang e Jisas ixoro tengen ina na, a balna ixo tiip ma ixo tengen osen te idi bira, “Turunon saxit, a öng ke mum irabo isik e xö limine nangadi.” ");
INSERT INTO bjk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Abo bak ne ausu re ine toxo epere dik nana baling ke idi iat, ma toxo ngangao esexere bere ewenene runon ee nanga i rengrengen ine. ");
INSERT INTO bjk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma öng ke idi, ina bak ne ausu ewe nang e Jisas ibo mamaa xöba lamun ine, ixo kis lörörö sik ke Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Io, Saimon Pita ixo urie a öxöno xö ina bak ne ausu ma ixo tengen te ine, “Örö ose ine bara i rengrengen ewe.” ");
INSERT INTO bjk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Io, ina bak ne ausu ixo maru sede ma ixo ose ine bara, “Orong, ewenene ine?” ");
INSERT INTO bjk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas ixo balu bira, “Ine ewe nang e rabo tabaa ine ma xönö beret niang e xoro öwösö xö bile.” Io, nang ixoro öwösö a beret, ixo tabaa e Judas Iskariot, a barok ke Saimon. ");
INSERT INTO bjk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Niang mon e Judas ixo tön lo a beret, Satan ixo laxa re ine. Io, Jisas ixo tengen te ine, “A laa niang u ka wewet te e, örö pet pasaxirin.” ");
INSERT INTO bjk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma lamun kaim pe öng kingan kö ina nien ixo maras bara ruasa me Jisas ixo tengen bira rö ine. ");
INSERT INTO bjk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","A unine bara Judas ixobo balaure abo tuluwok. Io, idi toxo nunu bara Jisas ixo rengrengen tö ine bara irabo mana kun tebo lalaa idi toxo mamaa ulamun möxö ina Luxa ne Nuan Lexe, bara irabo tabaa abo tanaa merebo lalaa. ");
INSERT INTO bjk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ma nang e Judas ixoro tön lo a beret, ixo wan su. Ma ixoro ködö. ");
INSERT INTO bjk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma nang e Judas ixoro wan, e Jisas ixo tengen, “Na a mariris kö Barok kö Tödi i ka nuanot maras, ma a Barok kö Tödi i eka urulo rua osen ömaras a mariris se God bölök. ");
INSERT INTO bjk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma nang bara a Barok kö Tödi irabo osen a mariris se God, io, God irabo osen kölöme re ine iat a mariris se Barok ke ine, ma irabo osen a mariris se ine pasaxit mon. ");
INSERT INTO bjk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","A bung barok ke e, e karabo kis ömat arixe me mum. Mum morobo parasiwin e. Ma xarnang e xoro tengen sik köbo Judeia, io, na im e tengen te mum: A xönö nang e önan uxe, mum kebeöt ta nuan uwe. ");
INSERT INTO bjk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","A warkurai maxat na, e tabaa e mum min ine bira: Mum morobo mana ebalamu kaluluonin e mum iat. Xarnang e xo balamu e mum bie, io, mum morobo mana balamu e mum iat. ");
INSERT INTO bjk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nang bara mum morobo ebalamu kaluluonin e mum iat, io, a nangadi tabo ösöxö bara mum abo bak ne ausu re e.” ");
INSERT INTO bjk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita ixo ose ine, “Orong, u önan taule?” Jisas ixo balu ine, “A xönö niang eka nuan uwe, nöngön u kebeöt tua mumuu e uxe xö ina axana bung na, ma lamun örobo muu im melamu.” ");
INSERT INTO bjk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita ixo ose ine, “Orong, e kebeöt tua mumuu nöngön na ruasa? E tagur sik kua isik a to re e lamun nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Io, Jisas ixo balu ine bira: “I turunon bara u tagur sik kua isik a to re nöngön lamun e? Turunon saxit, nang a xixök i kobola tenge bang, nöngön örobo öös lamun e xö narun ne axan. ");
INSERT INTO bjk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ganim a öriip a bala mum. Nunu xö God, ma nunu bölök ke e. ");
INSERT INTO bjk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A oleleng ne xönö kölöme xö gunon te Tata re e. Nang bara i kobo turunon, e xoro tengen te mum. Arabo wan urso ra tagure a lagunon te mum. ");
INSERT INTO bjk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma nang bara arabo wan ma arabo tagure a lagunon te mum, e rabo wanot baling ma arabo kip lo e mum pa kinis arixe me e, lamun e mum morobo kis kö xönö nang e bo xisixis ee. ");
INSERT INTO bjk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mum mo ösöxö sik a ngas urungan kö lagunon nang e önan uwe.” ");
INSERT INTO bjk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ixo tengen tö ine, “Orong, mem kobo ösöxö a xönö nang u önan uwe, io, mem marabo ösöxö muu a ngas bara bule?” ");
INSERT INTO bjk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas ixo balu ine, “E mon a ngas, a turunon, ma a to. Kaim pe öng irabo wan urso re Tata xö ngas kabise. E mon a ngas uruso re Mama. ");
INSERT INTO bjk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nang bara mum moxoro ösöxö e, mum moxoro ösöxö bölök a Tata re e. Urulo nixinen ma na uruso, mum muru ösöxö sik ine, me mum muru pere ine.” ");
INSERT INTO bjk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip ixo tengen te ine, “Orong, osen e mem me Tata, ma irabo pet eörin abo mamaa re mem.” ");
INSERT INTO bjk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas ixo tengen te ine, “E xoro kis arixe me mum kö axana bung ömat, Pilip. Nangen u kala ösöxö e? Ewenene nang iri pere e, iri pere e Tata. Ma bara bule u tengen, ‘Osen e mem me Tata’? ");
INSERT INTO bjk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","U kobo nunu bere e angen kö Tata me Tata angen na kölöme re e? Abo tinenge nang e tengen te mum, idi kaim bara mera iat te e. Ma lamun e Tata ewe nang ibo xisixis kölöme re e ibo wewet inabo tinörön. ");
INSERT INTO bjk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mum moro mana nunu re e nang e tengen bere e angen kö Tata me Tata angen na kölöme re e. Lamun nang bere mum kobo nunu, io, nunu re e xöbo tinörön iat nang e bo wewet. ");
INSERT INTO bjk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Turunon saxit, ewe a öng nang i nunu re e, ine irabo pet abo tinörön nang e bo wewet. Ma irabo pet abo tinörön tataxin lömö xinabo tinörön na, möxösa, e önan uruso xö Tata. ");
INSERT INTO bjk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Me e rabo pet eörin a lasa nang mum mo seng kö esene e, bara a Barok ke ine irabo eöt tua olelet e Tata. ");
INSERT INTO bjk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mum mo öt sik ka seseng e mere lasanene kölöme xö eseke, me e rabo pet eörin. ");
INSERT INTO bjk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nang bara mum mo mamaa lamun e, mum morobo pet eörin abo tinenge lölös se e. ");
INSERT INTO bjk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Me e rabo ose e Mama, me ine irabo tabaa e mum ma önga Tene Rorop kabise rua kinis arixe me mum ulorexe. ");
INSERT INTO bjk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ine a Tanono nang ibo osen abo turunon te God. A öxöno lagunon i kebeöt ta ömaraxen lo ine, möxösa, a öxöno lagunon i kebeöt ta werwere ine bara ösöxö ine. Lamun mum moxoro ösöxö sik ine, möxö ine i xisixis arixe me mum ma irabo kis kölöme re mum. ");
INSERT INTO bjk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","E karabo wan lie e mum xarnang a barok kaim a tamana. E rabo ot pösöt e mum. ");
INSERT INTO bjk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Lörörö mon, a öxöno lagunon i kebeöt ta werwere im e, lamun mum morobo pere e. Me e rabo to. Möxö ina na, mum bölök morobo to. ");
INSERT INTO bjk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Xö ina bung nang mum morobo ösöxö xulen im bara e iang kölöme xö Mama me mum iang kölöme re e, me e iang kölöme re mum. ");
INSERT INTO bjk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ewenene nang i ölangen abo tinenge lölös se e ma i muumuu, ine mon ina öng ewe nang i maa rö e. Ine ewe nang i maa rö e, e Tata re e irabo maa lamun ine, me e rabo maa lamun ine me e rabo osen e re ine.” ");
INSERT INTO bjk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Io, Judas (kaim bere Judas Iskariot) ixo tengen, “Orong, bara bule nöngön u maa ra osen nöngön te mem ma kaim bara xö öxöno lagunon kirip?” ");
INSERT INTO bjk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas ixo balu, “Nang bere ewenene i mamaa rö e, irabo muu abo ausu re e. A Tata re e irabo mamaa lamun ine, me maa marabo wanot pösöt ine, me maa marabo kis arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ine ewe nang i kobo maa lamun e, i kebeöt ta mumuu a ausu re e. Inabo tinenge na nang mum mo ölengen, kaim bara re e iat. Inabo tinenge na re Tata ewe nang ixo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Abo tinenge xirip nang e xo wöwörö min nang e xo xisixis arixe me mum. ");
INSERT INTO bjk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma lamun a Tene Rorop, a Töxödös ne Tanono, ewenene nang e Mama irabo tile xö eseke, irabo usu e mum mabo lalaa xirip ma irabo ödöxömen e mum köbo lalaa xirip nang e xoro tengen. ");
INSERT INTO bjk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","E gan sik a malum arixe me mum. A malum pe e, e isik ke mum. E kobo isik ine re mum xarnang a öxöno lagunon ibo isik. Ganim bara a tapunuk i öriip abo bala mum ma ganim a binuut lo mon. ");
INSERT INTO bjk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mum moxoro ölangen nang e xo tengen, ‘E rabo wan kalik e mum me e rabo ot baling.’ Nang bere mum mo maa re e, mum morobo axanan bere e rabo wan uruso re Mama, möxö e Mama ine a tödi raxin te e. ");
INSERT INTO bjk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","E xoro tengen te mum na ulamun ina na, ma melamu irabo ot. Io, nang irabo ot turunon, mum morobo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","E karabo tenge me mum kö axana bung ömat, möxösa, a tene sisila möxö öxöno lagunon irabo ot. Kaim ine mere lölös sua wewet te laa ura re e. ");
INSERT INTO bjk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Lamun a öxöno lagunon irabo mana ösöxö bara e maa xöba lamun e Mama me e bo wewet eörin abo mangana lasa nang e Mama ixoro tengen te e bara e rabo pet. “Miang im, ire ta önan. ");
INSERT INTO bjk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“E iat a uno iaa wain turunon, me Tata re e, ine a tamana komo. ");
INSERT INTO bjk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ine ibo reree rewe abo axana iaa xalik e nang i kala ösöxö ra ino. Ma abo axan nang ibo oo, ibo reree subun, lamun irabo wawara deek ma irabo o oleleng. ");
INSERT INTO bjk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mum moxoro deek lamun abo tinenge nang e xoro usu e mum min. ");
INSERT INTO bjk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Parap arixe me e, me e rabo parap arixe me mum. Kaim pe axana wain irabo o rine iat. Irabo mana parap sik kö uno iaa wain. Xarna nang, mum mo korobo o nang bara mum kobo parap sik ke e. ");
INSERT INTO bjk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“E iat a uno iaa wain, me mum abo axana. Nang bara ewenene i parap pe e me e parap pe ine, ine irabo o a oleleng ne pasuno. Nang bere mum kobo parap pe e, mum mo kebeöt tua wewet te laa. ");
INSERT INTO bjk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nang bara ewenene i kobo parap pe e, ine irabo xarnang a axana wain nang tobo tewe rewe ma irabo manga. Tabo iiögun inabo axana wain, ma tabo tewe xö iaa ra söngsöngöt. ");
INSERT INTO bjk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nang bara mum morobo parap pe e, ma tinenge re e irabo kis arixe me mum, mum morobo seng a mangana lasa nang mum mo mamaa lamun, mum morobo kip lo. ");
INSERT INTO bjk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nang bara mum mo o a oleleng ne pasuno, ina tatalien na irabo osen a mariris se Tata re e, me mum morobo osen bara mum abo bak ne ausu re e. ");
INSERT INTO bjk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“E maa rö mum xarnang e Tata ibo mamaa lamun e. Mum morobo mana kisisik kö mamaa re e. ");
INSERT INTO bjk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nang bere mum mo töndik abo tinenge lölös se e, mum morobo kisisik kö mamaa re e, xarnang mon e töndik sik abo tinenge lölös se Mama me e bo kisisik kölöme xö mamaa re ine. ");
INSERT INTO bjk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","E xoro töngösen e mum min bara a axanan te e irabo kisisik ke mum ma bara a axanan te mum irabo wöwö. ");
INSERT INTO bjk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A tinenge lölös se e bira: Mum morobo mana ebalamu kaluluonin e mum xarnang e re balamu e mum. ");
INSERT INTO bjk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kaim pe öng nang ine ma abalamu raxin xarnang a öng ewe nang i isik ösu a to re ine ulamun abo ais se ine. ");
INSERT INTO bjk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mum morobo ais se e nang bara mum mo pet a lasanene nang e tenge lölös. ");
INSERT INTO bjk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","E karabo tengen im e mum bara abo tultul, möxösa, a tultul i kara ösöxö a lasanene a tödi raxin te ine ibo wewet. Ma lamun, e tengen te mum bara mum abo ais se e, möxö abo laa nang e xo usu meringan kö Tata re e, e xoro pet eörin ulamun e mum pa ösöxö xulen. ");
INSERT INTO bjk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mum koxobo pere kos lo e, lamun e xo pere kos lo e mum, me e xo tile e mum pa nuan ma rua ino, ma bara abo pasuno e mum irabo kis ulorexe. Möxö ina na, Mama irabo isik a lasanene nang mum mo seseng ulamun kö eseke. ");
INSERT INTO bjk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","A tinenge lölös se e bira: Mum morobo mana ebalamu kaluluonin e mum. ");
INSERT INTO bjk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nang bara a öxöno lagunon i melentexin e mum, mum morobo mana döxömen bara toxo arun ta melentexin e. ");
INSERT INTO bjk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nang bara mum mera xö öxöno lagunon, a öxöno lagunon i xebe mamaa ulamun e mum xarnang bara re ine iat. Inexalik kaim bara mum mera xö öxöno lagunon, lamun e xoro pere kos lo e mum kalik a öxöno lagunon. Möxö ina na, a öxöno lagunon i melentexin e mum. ");
INSERT INTO bjk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Me mum morobo döxömen lo abo tinenge nang e xo töngösen e mum bira, ‘Kaim pe tultul i taxin sik kö tödi raxin te ine. Kaim.’ Nang bara idi te elerin e, idi tabo elerin bölök e mum. Nang bara idi te muu a ausu re e, idi tabo muu bölök ke mum. ");
INSERT INTO bjk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Idi tabo bienin e mum biringan ulamun a eseke, möxö idi tokobo ösöxö ewe a öng nang ixo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na im idi ma magingin saban me idi te waparuo bira, möxösa, e re wanot me e re etöngösen me idi. ");
INSERT INTO bjk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ine ewe nang i melentexin e, i melentexin bölök a Tata re e. ");
INSERT INTO bjk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nang bara e koxobo pet kaluluonin idi re laa nang kaim im pe öng bölök ixo pet, kaim idi mere magingin saban. Ma lamun na im idi tere pere inabo uxileng lölös nang e xo pet, ma nangen iat idi te melentexin e, maa me Tata re e bölök. ");
INSERT INTO bjk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma lamun a na ra wewet eörin a lasanene nang toxoro geet ösu xö buk möxö warkurai te idi bira: ‘Kaim pe unine me idi toxo melentexin e.’ ");
INSERT INTO bjk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“A Tene Rorop irabo ot, ewenene nang e rabo tile urungan te mum meriso re Tata. Ine a Tanono nang ibo osen abo turunon te God, ma ibo önan su xalik e Tata. Nang irabo wanot, ine irabo wöwörö maras lamun e. ");
INSERT INTO bjk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma lamun mum bölök morobo mana wöwörö maras ulamun e, möxö mum moxoro kis arixe me e meringan kö urulo. ");
INSERT INTO bjk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Abo tinenge xirip nang e re tengen te mum bara mum korobo subu xö tinuu lölös se mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Idi tabo bulus ösu e mum kalik abo gunon ne sineseng ke idi. Ma i turunon bara a axana bung irabo ot nang ewenene nang i sexomet e mum irabo döxömen bara i isik a arabaa xö God. ");
INSERT INTO bjk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Idi tabo pet abo mangana lalaa, möxösa, idi tekala ösöxö e Tata bere e. ");
INSERT INTO bjk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","E re tengen a na re mum, io, bara nang ina axana bung na irabo ot, mum morobo döxömen lo bara e xoro panak e mum. E kaim kö araun ta rengrengen te mum, möxösa, e xo kis arixe me mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Na e rabo wan uruso re ine ewe nang ixo tile e, lamun kaim pe öng ke mum i ose e bara, ‘U önan taule?’ ");
INSERT INTO bjk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mum mo wöwö sik ma tapunuk, möxösa, e re tengen abo lalaa na. ");
INSERT INTO bjk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lamun e tengen a turunon te mum, nang bere e wan kalik e mum ina laa na irabo top e mum, möxösa, nang bara e kobo wan, a Tene Rorop i karabo ot te mum. Lamun nang bara e wan kalik e mum, io, e rabo tile ine ura re mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nang bara ine irabo ot, ine irabo osen a nangadi möxö öxöno lagunon bara idi ma magingin saban. Ma irabo osen idi ulamun a magingin töxödös ma a pet warkurai re God. ");
INSERT INTO bjk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Irabo osen bara idi ma magingin saban, möxösa, a nangadi möxö öxöno lagunon tekobo nunu re e. ");
INSERT INTO bjk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Irabo osen bara a sasaxan te idi ulamun a magingin töxödös, möxösa, e rabo wan uruso re Tata, me mum korobo pere öbaling im e. ");
INSERT INTO bjk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Irabo osen idi ulamun a pet warkurai re God, möxösa, God iri ömaso a tene sisila möxö ina öxöno lagunon na. ");
INSERT INTO bjk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“E ma oleleng ne lalaa ra rengrengen tö mum, ma nexalik mum kebeöt ta ölangen nixinen. ");
INSERT INTO bjk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Lamun nang bara a Tanono irabo ot, ine nang irabo osen abo turunon te God, ine irabo silien e mum pua ösöxö xulen abo turunon. Ine i karabo wöwörö meringan kö dinödöm pe ine iat. Ine irabo wöwörö mon lamun a sanene ine ixo ölangen, ma irabo tengen te mum lamun a sanene nang nangen iat tua inot. ");
INSERT INTO bjk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ine irabo osen a mariris se e bira: irabo kip lo abo lasanene re e ma irabo palas ömaras sö mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Abo lalaa xirip nang ke Tata, abo lalaa re e. Möxö ina na, e tengen bara a Tanono irabo ilo abo lasanene re e ma irabo palas ömaras sö mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“I karabo ömat me mum korobo pere öbaling im e, ma melamu i kobo ömat me mum morobo pere öbaling e.” ");
INSERT INTO bjk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dauleng ne bak ne ausu re ine toxo tengen kö öngöng iat te idi, “A lasanene a unine möxö ina tinenge re ine na? I rengrengen bara, ‘I karabo ömat me mum korobo pere öbaling im e, ma melamu i karabo ömat me mum morobo pere öbaling e’. Ma i rengrengen bölök bara, ‘Möxösa e rabo wan uruso re Tata.’” ");
INSERT INTO bjk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Idi nangen toxo mamaa ma ose, “A mangana tinenge bule a ‘I karabo ömat’? Ire tokobo ösöxö xulen a sanene ine i rengrengen.” ");
INSERT INTO bjk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas ixoro ösöxö bara idi toxo maa ra ose ulamun ina na, io, ixo tengen te idi bira: “E xo tengen, ‘I karabo ömat me mum korobo pere öbaling im e, ma melamu i karabo ömat me mum morobo pere öbaling e.’ Mum mo ose nanin öbaling e mum ulamun ina tinenge na re e? ");
INSERT INTO bjk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Turunon saxit, mum morobo sisiöt ma ginee, ma lamun a öxöno lagunon irabo axanan. Mum morobo tapunuk, lamun a tapunuk ke mum irabo tawuxus urungan kö axanan. ");
INSERT INTO bjk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A une nang i kip barok, ine ma kinadik, möxö a bung ke ine iri ot. Ma lamun nang ine iri kip a barok, ine irabo döxömen taun abo tiip pe ine, möxösa, xö axanan te ine nang a barok iri ot ura xö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Io, i bie bölök ke mum. Na im a axana bung ke mum moxo tapunuk. Ma lamun e rabo pere öbaling e mum me mum morobo axanan, ma kaim pe öng irabo kip tewe a axanan te mum. ");
INSERT INTO bjk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Xina bung nang, mum korobo seng im e mere lasanene. Turunon saxit, Tata re e irabo isik abo lasanene mum mo seng ine kölöme xö esene e. ");
INSERT INTO bjk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ot nixinen, mum koxobo seng ke lasanene kölöme xö eseke. Mum morobo mana seng, me mum morobo kip lo, ma axanan te mum irabo wöwö xöba. ");
INSERT INTO bjk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“E xo rengrenge ma tinenge öwuo, ma lamun a bung i eka inot nang e karabo tenge mabo tinenge öwuwuo im, lamun e rabo tengen öwalas se mum lamun a Tata re e. ");
INSERT INTO bjk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nang bara bung nang irabo ot, mum morobo seng ine kölöme xö eseke. Me e kobo tengen bara arabo ose ine xelen e mum, ");
INSERT INTO bjk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","möxösa, a Tata ine iat i maa re mum. Ine i maa lamun e mum, möxösa, mum mo maa lamun e me mum mo nunu bere e xo wanot meriso re God. ");
INSERT INTO bjk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","E xo ot meriso re Tata me e xo laxa ura xö öxöno lagunon. Ma na eka nuan lie im a öxöno lagunon me eka nuan baling uruso re Tata.” ");
INSERT INTO bjk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Io, abo bak ne ausu re Jisas toxo tengen, “Na im nöngön u wöwörö maras ma kaim arixe re tinenge öwuwuo. ");
INSERT INTO bjk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na mem mere pere bara nöngön u ösöxö xirip abo lalaa ma bara kaim nöngön mere sasaxan bara re öng irabo ose nöngön ulamun te laa. Xina na i pet e mem me nunu bara nöngön u xo ot meriso re God.” ");
INSERT INTO bjk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas ixo balu, “Mum moro nunu im, goo? ");
INSERT INTO bjk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lamun a axana bung i ka inot, ma iri lörörö tuar, nang mum morobo ulo rup elixilik, öngöng iat kö gunon iat te ine. Mum kirip morobo wan kalik e. Ma lamun kaim bara e xalik iang, möxö a Tata re e nangen na arixe me e. ");
INSERT INTO bjk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“E xoro töngösen e mum minabo lalaa, bara mum morobo uruoxe a malum, möxösa, mum mo kis kölöme re e. Xina öxöno lagunon a kinadik irabo kis me mum. Lamun ganim a binuut. E xoro wan lexe a lölös möxö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nang e Jisas ixo tengen sik ina na, ixo wawara kaa urso lömö ma ixo seseng bira, “Mama, a axana bung iri wanot. Osen ösu a mariris ulamun a Barok ke nöngön bara rua Barok ke nöngön irabo eöt ta osen ösu a mariris ulamun nöngön, ");
INSERT INTO bjk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","xarnang u xo isik a lölös se ine bara a nangadi xirip tabo kis kö pu re ine bara irabo isik a to ulorexe rö idi xirip ewe nang u xo isik idi re ine. ");
INSERT INTO bjk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma a to ulorexe i bira: bara idi tabo ösöxö nöngön, bara nöngön kalik mon a God turunon, ma bara idi tabo ösöxö bölök e Jisas Krais ewe nang u xo tile ine ura. ");
INSERT INTO bjk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","E xo osen a mariris ulamun nöngön ta xö öxöno lagunon nang e xo öxöwam abo tinörön nang u xo isik ke e ra wewet. ");
INSERT INTO bjk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Io, Tata, na nang e kis arixe me nöngön, nöngön iat örobo mana osen a mariris ulamun e, ina mariris e xo kip nang e xo kis arixe me nöngön mesila nang kaim bang a öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“E re osen sik nöngön te idi ewe nang u xo isik idi re e meringan kö öxöno lagunon. Mesila idi mere nöngön, ma u xo isik idi re e. Me idi tere muu a tinenge re nöngön. ");
INSERT INTO bjk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma na idi tere ösöxö sik im bara abo laa xirip nang u tabaa e min i wanot meriso re nöngön, ");
INSERT INTO bjk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","möxösa, e xoro tabaa idi ma abo tinenge nang u xo tabaa e min me idi toxo öbala lo inabo tinenge. Me idi toxoro ösöxö im bere e xo wan su meriso re nöngön me idi te nunu im bara nöngön u xo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Me e, e seseng kö idi. E kobo seseng ulamun a öxöno lagunon. Ma lamun e seseng ke ewe me idi nang u xo tabaa e, möxö idi re nöngön. ");
INSERT INTO bjk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A nangadi xirip pe e, idi re nöngön, mabo nangadi xirip pe nöngön, idi re e. Me idi tere osen ösu a mariris ulamun e. ");
INSERT INTO bjk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","E re eka nuan kalik im ina öxöno lagunon urso re nöngön. Ma lamun idi iat angen bang kö öxöno lagunon. Madakdak ne Tata, örö balaure idi ma lölös möxö esem, a ese nang u xo tabaa e min, bere idi tabo öng mon xarnang mon iraa te öng mon. ");
INSERT INTO bjk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nang e xo kis arixe me idi, e xo balaure idi ma lölös möxö ese nang u xo tabaa e min. E xo balaure sik idi ma kaim pe öng mere idi ixo wan tup. Lamun a öng kalik mon ewe nang ixo mumuu a ngas möxö iuiuo, ine xalik ixo wan tup, nexalik bara a tinenge re nöngön nang toxo geet irabo ot turunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Na im arabo ot pösöt nöngön, ma lamun e tengen inabo laa na nang e angen bang a xö öxöno lagunon. Me e tengen ina na rue idi bara tabo wöwö ma axanan te e kölöme xö to re idi xarnang bölök e wöwö ma ina axanan. ");
INSERT INTO bjk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","E xo isik a tinenge re nöngön urungan te idi ma a öxöno lagunon ixo mölök kalik idi, möxösa, kaim bere idi mera xö öxöno lagunon, ma xarnang bölök bere e kaim bara mera xö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","E kobo seng nöngön bara örobo kip tewe idi xalik a öxöno lagunon. Kaim. E seng nöngön bara örobo tuu wi idi xalik a tene sasaban. ");
INSERT INTO bjk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kaim bara idi mera xö öxöno lagunon xarnang mon e kaim bara e mera. ");
INSERT INTO bjk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Örö ömaras a turunon te nöngön urungan te idi rua bulbulus kabisenin idi bara tabo nangadi re nöngön. Abo tinenge re nöngön i turunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","E re tile idi urungan kö öxöno lagunon xarnang mon u xo tile e urungan kö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","E bulus kabisenin e iat urungan kö tinörön te nöngön tua rorop idi, bara idi tabo nangadi turunon te nöngön. ");
INSERT INTO bjk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ma lamun e kobo seseng ulamun idi xalik mon. Kaim. E seseng bölök ulamun idi ewe nang tabo ölangen a tinenge xö ina nangadi me idi tabo nunu re e. ");
INSERT INTO bjk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","E seseng bara idi xirip tabo öng kalik mon. Tata, e seseng bara idi tabo kis kölöme re iraa xarnang nöngön u kis kölöme re e, me e, e kis kölöme re nöngön, bara rua a öxöno lagunon tabo nunu bara u xo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A mariris nang u xo tabaa e min, e xo isik bölök ke idi bara idi tabo öng kalik mon xarnang iraa te öng. ");
INSERT INTO bjk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nöngön u kis kölöme re e me e rabo kis kölöme re idi, bara idi tabo öng turunon mon, rua öxöno lagunon irabo ösöxö bara u xo tile e ma bara u xo maa rö idi xarnang u xo maa rö e bie. ");
INSERT INTO bjk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, e maa lamun idi ewe nang u xoro isik idi ura re e bere idi tabo kis arixe me e xö ina xönö nang arabo kis ee, ma bara tabo pere a mariris se e, a mariris nang u xo tabaa e min, möxösa, nöngön u xo maa lamun e mesila xö uxixis möxö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Töxödös ne Tata, a öxöno lagunon i kobo ösöxö nöngön, ma lamun e ösöxö nöngön, me idi te ösöxö bere nöngön u xo tile e. ");
INSERT INTO bjk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","E re osen sik nöngön urungan te idi. Me e rabo osen sösöxöin nöngön urungan te idi bara a mamaa re nöngön te e irabo eöt tua kinis kölöme re idi, ma bara e bölök arabo kis kölöme re idi.” ");
INSERT INTO bjk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Niang e Jisas ixo seseng kirip sik, ine arixe mabo bak ne ausu rine toxo lies köröp kö marasaa Kidron. Önga komo olip angen kö lawana marasaa xabise, me Jisas arixe mabo bak ne ausu rine toxo wan laxa xönan. ");
INSERT INTO bjk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Io, Judas, ewe niang ixo isik e Jisas kö limine nangadi, ixo ösöxö sik ina xönö, möxösa, e Jisas mabo bak ne ausu rine toxobo xisixis etok ee xöbo uleng ne bung. ");
INSERT INTO bjk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Io, Judas ixo wan urungan kö komo ma ixo silien a uleng ne umri mee Rom ma uleng ne köbat niang abo pris tataxin mabo Parasi toxo tile. Me idi toxo tön abo laam mabo dexe mabo lalaa möxö inarse. ");
INSERT INTO bjk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Io, Jisas ixoro ösöxö xirip sik a lasa niang irabo ot tine, ma ixo tuu ot ma ixo ose idi bira, “Mum mo wawara siwin ewenene?” ");
INSERT INTO bjk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Idi toxo balu, “Jisas mee Nasaret.” Jisas ixo tengen, “E mon ine.” (Me Judas ewe niang irabo isik e Jisas kö limine idi ixo tuu sik arixe midi.) ");
INSERT INTO bjk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ma nang e Jisas ixo tengen bara, “E mon ine,” idi toxo suxo baling ma toxo subu su xö pu. ");
INSERT INTO bjk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Io, Jisas ixo ose öbaling idi, “Mum mo wawara siwin ewenene?” Me idi toxo tengen, “Jisas mee Nasaret.” ");
INSERT INTO bjk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Io, Jisas ixo balu idi bira, “E re tengen sik ke mum bara e mon ine. Ma nang bara mum mo wawara siwin e, io, mum moro uguran tewe a nangadi na.” ");
INSERT INTO bjk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ina na ixo ot tua öturunon abo tinenge rine niang ixoro tengen sik ke God bira: “Ma ina nangadi nang u xo tabaa e min, kaim e ra wewet örup pe öng.” ");
INSERT INTO bjk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Io, Saimon Pita, niang ixo xikip nanin a sele ömat, ixo sat lo ma ixo tee xöröp a talinge tuun möxö a tene tinörön möxö sisila raxin möxöbo pris. (A esene tene tinörön niang e Malkas.) ");
INSERT INTO bjk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas ixo tengen te Pita, “Bulus tewe a sele re nöngön kö xönö möxönan! Nöngön u döxömen bara e rabo öngasin a ininim kö ina kap möxö kinadik nang e Mama ixo tabaa e min? Kaim.” ");
INSERT INTO bjk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Io, abo umri mee Rom arixe ma sisila ridi mabo köbat möxöbo Judeia, toxo töndik e Jisas ma toxo öxös lo ine. ");
INSERT INTO bjk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma toxo lamus ine urungan te Anas, a tamasik ke Kaiapas, möxö Kaiapas ixo sisila raxin möxöbo pris kina awat. ");
INSERT INTO bjk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Me Kaiapas mon niang ixo töngösen abo Judeia bara irabo deek nang bara re öng i met kelen a nangadi. ");
INSERT INTO bjk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ma önga bak ne ausu xabise idu toxo mumuu e Jisas. Ma ina öng kabise ixo laxa arixe me Jisas uruso kölöme xö xönö möxö sisila raxin möxöbo pris, möxösa, a sisila raxin möxöbo pris ixo ösöxö sik ina bak ne ausu na. ");
INSERT INTO bjk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma lamun e Pita ixo xixiset kö araman kö marame. A bak ne ausu niang a sisila raxin möxöbo pris ixo ösöxö sik ine ixo tawuxus baling ma ixo tengen kö une niang ixo balaure sik a marame bara irabo lamus ölaxa e Pita. ");
INSERT INTO bjk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ina balik ixo ose e Pita, “Nöngön gut a bak ne ausu re nanga, goo?” Me Pita ixo balu, “E kawaim.” ");
INSERT INTO bjk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A lagunon ixo madot, mabo tene tinörön mabo sisila möxöbo umri toxo tuu elulurwein a ia sösöt niang idi toxo usumot tua dinedek. Me Pita bölök ixo tuu arixe midi, ma ixo dededek. ");
INSERT INTO bjk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kaim pa ömat, a sisila raxin möxöbo pris ixo ose mumuu e Jisas ulamun abo bak ne ausu rine mabo inausu rine. ");
INSERT INTO bjk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas ixo balu bira, “E xoro wöwörö maras kö wawara xö oleleng ne nangadi. Me e bo eusu kölöme xö gunon sineseng ma xö gunon lotu raxin, xö xönö a oleleng möxöbo Judeia tobo ot arixe xönan. Me e kara tengen ömun te lalaa. ");
INSERT INTO bjk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ruasa u ose mumuu e? Örö ose idi ewe toxobo ölangen a tinenge re e. Idi te ösöxö sik a lasa e xobo rengrengen.” ");
INSERT INTO bjk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nang e Jisas ixo tengen bira, önga köbat kö lawana ixo wasa ine, ma ixo tengen, “Bara bule u balu a sisila raxin möxöbo pris biringan?” ");
INSERT INTO bjk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas ixo balu bira, “Nang bara e xoro tengen te tinenge saban, io, tengen ösu ina sasaban niang. Ma lamun nang bara e rengrenge ma turunon, ruasa u wasa e?” ");
INSERT INTO bjk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Io, Anas ixo tile ine, ma kunubus angen kö limine, urungan te Kaiapas a sisila raxin möxöbo pris. ");
INSERT INTO bjk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Niang e Saimon Pita ixo tuu sik ma ixo dededek, idi toxo ose ine bere, “Nöngön gut a bak ne ausu re nanga, goo?” Me ine ixo öös, ma ixo tengen, “E kawaim.” ");
INSERT INTO bjk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Önga tene tinörön möxö sisila raxin möxöbo pris, ine a öng mere ina tödi niang e Pita ixo tee xöröp a talingine, ixo tenge wösö, “Xalik nöngön mon e xo pere nöngön arixe me ine kölöme xö komo olip?” ");
INSERT INTO bjk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Xina axana bung niang e Pita ixo öös tewe baling, a xixök ixo tenge. ");
INSERT INTO bjk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kö warwara puxu idi toxo lamus lo e Jisas kalik e Kaiapas me idi toxo wan mine urso xö gunon möxö tödi raxin mee Rom. Ma kaim idi ra nilaxa, möxösa, idi tokoxobo maa bara tabo biling kö wawara re God tua nien kö Nien ne Nuan Lexe. ");
INSERT INTO bjk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Io, Pailat ixo wan su ma ixo ose idi, “A mangana sasaban sa mum mo puk ina tödi na min?” ");
INSERT INTO bjk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Idi toxo balu e Pailat bira, “Niang bara kaim ine mere sasaban, mem kexebe lamus ine ura re nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat ixo tengen, “Mum iat moro lamus ine ma morobo kure ine muu abo warkurai iat te mum.” Ma abo Judeia toxo balu, “Kaim, mem kebeöt. Mum abo Rom, mum kobo isik a lölös urungan te mem pua sexomet te öng nang mem moxoro kure ine.” ");
INSERT INTO bjk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ina na ixo ot tua öturunon abo tinenge re Jisas niang ixoro wöwörö min lamun a mangana minet niang irabo ot tine bie. ");
INSERT INTO bjk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Io, Pailat ixo wan laxa baling kö gunon möxö tödi raxin mee Rom, ma ixo kuwe ölaxa e Jisas ma ixo ose ine, “Nöngön mon a king möxöbo Judeia?” ");
INSERT INTO bjk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Me Jisas ixo ose öbaling ine bira, “Xö dinödöm pe nöngön iat nang u pet ina tinenge na, bara nangadi te töngösen nöngön lamun e?” ");
INSERT INTO bjk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Me Pailat ixo balu ine, “E kaim bara a Judeia. A nangadi re nöngön iat arixe mabo pris tataxin idi toxo isik nöngön ura re e. Ma u xo pet a lasa?” ");
INSERT INTO bjk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas ixo tengen, “A kingdom pe e kaim bara mera xö öxöno lagunon. Nang bara ine mera, io, abo tene tinörön te e tabo erse wi e xalik abo Judeia. Lamun a kingdom pe e kaim bara mera xö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat ixo tengen, “Io, a turunon im bara nöngön önga king, goo?” Me Jisas ixo balu, “Nöngön iat u tengen bere e önga king. Me e xo bak ot ta xö öxöno lagunon lamun ina unine na rua tinenge lamun a turunon. Me ewenene midi niang te muu a turunon, tobo ölangen e.” ");
INSERT INTO bjk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Me Pailat ixo ose, “A turunon iang a lasa?” Io, Pailat ixo wan su baling urungan köbo Judeia ma ixo tengen, “E kobo pere lo re unine aupuk ke mum urungan tine. ");
INSERT INTO bjk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ma lamun a tatalien te mum bara e rabo walwalas ösu re öng meriso xö gunon ne aömokorot urungan te mum kö axana bung möxö Nien ne Nuan Lexe. Mum mo maa bara e rabo palas ösu a king möxöbo Judeia?” ");
INSERT INTO bjk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Idi toxo kup baling, “Kaim. Kaim bere ine! Örö isik e Barabas ura re mem!” Io, me Barabas ine a tödi lölös möxö arse ma tene pinilo bölök ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Io, Pailat ixo lamus lo e Jisas urungan te idi bara idi tabo dangat ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abo umri toxo kubus arixin abo uno gargaras ma toxo pet xarnang a bubuan, ma toxo usige xö öxöno. Me idi toxo ölaulawa ine ma man dadan xarnang a king ibo sisige. ");
INSERT INTO bjk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Me idi toxobo önan pösöt ine ma toxobo rengrengen, “Mem me ölet nöngön, king köbo Judeia!” Ma toxo wasa ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Io, Pailat ixo wan su baling ma ixo tengen köbo Judeia, “Moro pere, na e rabo isik ösu ine urungan te mum bara mum moro ösöxö bara e kobo pere lo re unine aupuk ke mum urungan tine.” ");
INSERT INTO bjk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Niang e Jisas ixo wan su ma uno gargaras toxo bun kö öxöno arixe ma man dadan, Pailat ixo tengen te idi, “Ine na im ina tödi!” ");
INSERT INTO bjk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nang iat mon niang abo pris tataxin mabo sisila möxöbo umri toxo pere ine, idi toxo xukup ma toxo tengen, “Tut ine xö sölöxöröp!” Ma lamun Pailat ixo balu idi, “Mum moro lamus lo ine ma moro tut ine lömö xö sölöxöröp. Ma lamun e iat, e kobo pere lo re unine aupuk ke mum urungan tine.” ");
INSERT INTO bjk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma abo Judeia toxo balu öbaling, “Mem ma önga warkurai, ma xina warkurai mon ine irabo mana met, möxösa, ine ixobo rengrengen bara ine a Barok ke God.” ");
INSERT INTO bjk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Io, niang e Pailat ixo ölangen ina na, ixo buut köba mon, ");
INSERT INTO bjk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ma ixo wan laxa baling kö gunon möxö tödi raxin mee Rom. Ine ixo ose e Jisas, “Nöngön möxö xönö sa?” Ma lamun e Jisas kaim pa balu ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat ixo tengen, “Ma bara bule nöngön u kobo maa rua balu abo tinenge re e? U kobola maras bang bere e ma lölös sua ölanglanga nöngön bara rua rutut nöngön kö sölöxöröp?” ");
INSERT INTO bjk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas ixo balu, “Nöngön ma lölös mon tua kure e, möxösa, iri wanot te nöngön meriso lömö. Möxö ina na, a öng niang i isik sik e urungan kö limem, ine i pet a magingin saban i taxin kö saban te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Meringan im, e Pailat ixo maa bara irabo ölanglanga e Jisas, ma lamun abo Judeia toxo xukuwe kalarain mon ine, “Niang bara u ölanglanga ina tödi na, ökorobo ais im me Kaisar a king taxin mee Rom. Ewenene a öng niang ibo rengrengen öbaling iat ine bara a king ine, ine a iuo möxö king mee Rom.” ");
INSERT INTO bjk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Niang e Pailat ixo ölangen ina na, ixo lamus ösu e Jisas ma ixo kis kö kinis möxö pet warkurai. Ma tobo rengrengen ina xönö na me ‘Luono Araman ne Wat.’ (Xö tinenge me Ibru tobo rengrengen me ‘Gabata’.) ");
INSERT INTO bjk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma ixoro lörörö im kö luono xaken möxö tagur rua Luxa ne Nuan Lexe. Io, Pailat ixo tengen köbo Judeia, “Ne na im a king ke mum.” ");
INSERT INTO bjk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma lamun idi toxo kup, “Kip tewe ine! Kip tewe ine! Tut ine xö sölöxöröp!” Io, Pailat ixo ose, “Mum mo mamaa bara ara tut a king ke mum kö sölöxöröp?” Mabo pris tataxin toxo balu, “Kaim e mem mere king, e Kaisar kalik mon.” ");
INSERT INTO bjk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Io, Pailat ixo isik e Jisas urungan im kö limine idi bara tabo tut ine xö sölöxöröp. Io, abo umri toxo kip lo e Jisas ma toxo lamus tewe ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas ixo sölök lo a sölöxöröp pe ine iat ma ixo wan su urungan kö xönö möxö Siine Öxöno Tödi (niang kö tinenge me Ibru tobo rengrengen me Golgota.) ");
INSERT INTO bjk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Me idi toxo tut e Jisas kö sölöxöröp pingan ee, arixe ma nine tödi xabise. Idu xö nine lawa, me Jisas kaluluon. ");
INSERT INTO bjk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat ixoro geet sik a xönö tinenge ma ixo uguran idi ra xuxut parange xö öxöno sölöxöröp. Mina tinenge i tengen bira: “Jisas mee Nasaret, a king möxöbo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ma oleleng ne Judeia toxo kos ina tinenge na, möxö ina xönö niang toxo tut e Jisas könan ixo lörörö sik kö lagunon taxin Jerusalem. Ma ina xönö tinenge toxo geet köbo tinenge me Ibru, Rom me Grik. ");
INSERT INTO bjk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mabo pris tataxin toxo tengen te Pailat, “Ganim a gegeet bara: ‘A king möxöbo Judeia’, ma lamun örö geet bara, ‘Ina tödi na ixo rengrengen lo mon bere ine a king möxöbo Judeia.’” ");
INSERT INTO bjk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Me Pailat ixo balu, “A lasa niang e xoro geet, irabo malaa sik bie.” ");
INSERT INTO bjk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nang abo umri toxo tut e Jisas kö sölöxöröp, idi toxo kip lo abo man tine ma toxo tibe nanin eöt ma nit ne tiniba. Ma öngöng iat ma önga tiniba. Me idi toxo kip lo bölök a man ömat te ine niang toxo pet ma önga xönö man mon ma kaim pe sinöxö xönan. ");
INSERT INTO bjk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Idi toxo tengen nanin tidi iat bara, “Ire tebele didii. Inexalik bara ire tabo egulös satu lamun tua werwere bere ewenene iat irabo kip lo.” Ina na ixo ot tua öturunon abo tinenge re God niang toxoro geet sik bira, “Idi toxo tibe nanin abo man te e kaluluonin idi ma toxo egulös satu lamun a man te e.” Mabo umri toxo pet eörin iat. ");
INSERT INTO bjk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma lörörö xö sölöxöröp pe Jisas inabo une na toxo tuu sik kingan: a nago re ine, ma tönö nago rine, me Maria a usuono Klopas, me Maria mee Makdala. ");
INSERT INTO bjk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nang e Jisas ixo pere e nago rine arixe ma bak ne ausu niang ixobo mamaa xöba lamun, idu toxo tuu sik kingan, io, ixo tengen kö nago rine bira, “E nangang im, a barok ke nöngön.” ");
INSERT INTO bjk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ma ixo tengen kö bak ne ausu rine bira, “A une na irabo nago re nöngön im.” Urulo xina axana bung, ina bak ne ausu rine ixo lamus e Maria urungan kö gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Melamu, Jisas ixo tengen bira, “E minauu,” rua öturunon abo tinenge re God niang toxoro geet sik, möxö ixoro ösöxö bara abo tinörön kirip pe ine ixoro kawöm. ");
INSERT INTO bjk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma ringan ee nangen a önga tubon wain manun, io, idi toxo ilo önga spans ma toxo bulus ölaxa xina tubon wain i ot nang ixo wöwö xönan. Idi toxo söxö lo xö axana iaa isop ma toxo sasanga kaa urso xö ngalana e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Io, nang ixoro inim ina wain, ixo tengen bira, “Abo tinörön te e iri kawöm.” Ma ixo ii ötun a öxöno ma ixo isik tewe im a to re ine ma ixo met. ");
INSERT INTO bjk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A Bung Pitnö, a bung möxö tagur rua bung Sabat. Ma ina bung Sabat ine a bung taxin. Io, abo Judeia toxo ose e Pailat bara irabo tile tinenge rua köbön abo xexene idiet ma bara tabo kip ösu abo aine idiet, möxösa, abo Judeia kaim a mamaa bara abo töngön tabo taba sik lömö xöbo sölöxöröp kö bung Sabat. ");
INSERT INTO bjk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Io, abo umri toxo wan ma toxo köbön abo xexe idu niang toxo taba sik me Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma niang idi toxo wan urungan te Jisas, idi toxo pere Jisas ixoro met. Io, kaim idi ra köbön abo xexene. ");
INSERT INTO bjk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma lamun önga umri ixo buso a lawana e Jisas ma iie, ma saxit mon a dee ma ari ixo su. ");
INSERT INTO bjk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma ina tödi niang ixo pere ina na, iri etöngösen mina laa niang ixo pere. Ma ina tinenge niang i palas osen, i turunon. I ösöxö sik bara i turunon, ma i etöngösen min bara mum bölök morobo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Inabo lalaa xirip na i ot tua öturunon a tinenge re God: “Kaim pe sii mere ine bara irabo tawit,” ");
INSERT INTO bjk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ma xarniang a xönö tinenge xabise bölök i tengen bere, “Idi tabo werwere a öng niang idi toxo buso ine.” ");
INSERT INTO bjk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Io, melamu xina na, e Josep mee Arimatia ixo wanot, me ine bölök önga bak ne ausu re Jisas. Ma lamun ine ixobo xisixis suxume biringan, möxö ixobo buburin abo Judeia. Ine ixo seng e Pailat lamun a minet te Jisas, me Pailat ixo ömaraxen lo ine. Io, ine ixo wan ma ixo kip lo a minet te Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Me ine ixo arixe me Nikodimas, a tödi niang ixo dawösöt bang e Jisas kö dömön. Me Nikodimas ixo kip lo a sada nang a lak sixine deek niang toxo pet ma bulbulut möxö nine mangana iaa, ma tiip möxönan ixo eöt ma narun ne sangaun ne kilo. ");
INSERT INTO bjk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Idu toxo kip lo a aine Jisas ma toxo bulus ina sada, ma toxo bun mabo subana man maxat. I xarnang mon abo Judeia tobo wewet kö aine nangadi minet. ");
INSERT INTO bjk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma xina lagunon niang toxo tut e Jisas könan, nangen a önga komo, ma xina komo nangen a önga lieng maxat niang kaim bang kö ömarin te öng könan. ");
INSERT INTO bjk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma xö ina bung niang, a bung möxö tagur ulamun a bung Sabat köbo Judeia, me idi toxo ömarin ine xönan, möxösa, a lieng ixo lörörö sik. ");
INSERT INTO bjk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Xö puxu bubung kö Sade nang ixo ködö xudun sik, e Maria mee Makdala ixo wan urungan kö lieng ne minet ma ixo pere bara toxoro ubun tewe a wat kalik a marame. ");
INSERT INTO bjk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Io, ixo ulo wösöt e Saimon Pita ma a bak ne ausu xabise, a öng niang e Jisas ixobo mamaa xöba ulamun ma ixo tengen, “Idi tere kip lo a Orong kalik a lieng, me meet me köbo ösöxö im bara te bulus ine ule!” ");
INSERT INTO bjk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Io, Pita ma bak ne ausu xabise, idu toxo wan urungan kö lieng ne minet. ");
INSERT INTO bjk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Idu toxo ulo arixe, ma lamun a bak ne ausu xabise ixo ulo silien e Pita, ma ixo sila xö lieng. ");
INSERT INTO bjk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ixo tunsu ma ixo wawara laxa ma ixo pere abo xönö man angen niang toxo bun a aine Jisas min, nexalik kaim ine ra nilaxa. ");
INSERT INTO bjk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Io, melamu re ine, e Saimon ixo wanot ma ixo wan laxa. Ixo pere abo xönö man toxo malaa sik kingan, ");
INSERT INTO bjk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ma xönö man niang toxo bun a öxöno Jisas min nang toxoro luxun ma ixo malaa xabise sik iat. ");
INSERT INTO bjk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Io, a bak ne ausu xabise niang ixo arun ot kö lieng ixo wan laxa bölök. Ixo pere ma ixo nunu. ");
INSERT INTO bjk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Idi kaim bang ka marmaras bara abo tinenge re God toxoro geet sik i tengen bere e Jisas irabo mana taru baling kalik a minet.) ");
INSERT INTO bjk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Io, nine bak ne ausu toxo wan baling urungan köbo ngasiene idu. ");
INSERT INTO bjk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma lamun e Maria ixo tuu sik kö marame xina lieng ne minet ma ixo gegee. Nang ine angen ixo gegee, ixo tunsu ma ixo wawara laxa xö lieng. ");
INSERT INTO bjk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma ixo pere a nine angelo toxo sige sik abo man pidien. Idu toxo kisisik kö xönö niang a aine Jisas toxo ömarin sik ee. Öng ixo kis kö xönö niang ixo lulungon uxe, ma öng kö xönö niang ixo xöxödos uxe. ");
INSERT INTO bjk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Me idu toxo ose e Maria bira, “Nang, u gegee rösanene?” Me ine ixo balu bira, “Idi tere kip lo a Orong ke e, me e kobo ösöxö im bara te bulus ine ule.” ");
INSERT INTO bjk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nang ixo tengen bira, ixo tawuxus ma ixo pere e Jisas ixo tuu sik kingan, ma lamun kaim ine ra werwere xulen bere Jisas mon iang. ");
INSERT INTO bjk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Me Jisas ixo tengen, “Nang, u gegee rösanene? U wawara lamun e ewe?” Maria ixo döxömen bara ine a tene walbalaurai möxö ina komo, ma ixo tengen bira, “Maris, nang bara u kip lo ine, örö tengen te e bara u bulus ine ule, me e rabo kip lo ine.” ");
INSERT INTO bjk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas ixo tengen te ine, “Maria.” Me Maria ixo talingen urungan tine ma ixo tenge xö tinenge me Ibru bira: “Rabonai!” (A unine bara ‘Tene Ausu’). ");
INSERT INTO bjk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Me Jisas ixo tengen, “Ganim bara u tön e, möxösa, e kala baling bang urso re Tata. Ma lamun örobo mana wan urungan köbo töke, ma örobo tengen te idi bara, ‘E rabo wan im urso re Tata re e ma Tata re mum, urso xö God te e ma God te mum.’” ");
INSERT INTO bjk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Io, Maria mee Makdala ixo ot pösöt abo bak ne ausu ma ixo etöngösen mina na. Ma ixo tengen, “E re pere a Orong.” Ma ixo töngösen idi ma lasa niang a Orong ixo töngösen ine min. ");
INSERT INTO bjk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Xö ina Sade xö aien sumaraxoxo abo bak ne ausu toxo ot etok sik kölöme xö gunon, me idi toxo baxut ölölös a marame, möxösa, toxo buburin abo Judeia. Me Jisas ixo wanot ma ixo tuu kaluluonin idi ma ixo tengen, “A malum irabo kis kö bala mum!” ");
INSERT INTO bjk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ixo tengen sik ina na ma ixo osen abo tabalana limine ma lawana tarasine urungan tidi. Ma abo bak ne ausu toxo axanan köba nang idi toxo pere a Orong. ");
INSERT INTO bjk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Io, Jisas ixo tengen öbaling kidi, “A malum irabo kis kö bala mum! E rabo tile e mum xarnang mon niang e Tata ixo tile e.” ");
INSERT INTO bjk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Io, melamu, ixo mas a mamas sine urungan tidi ma ixo tengen, “Mum moro mana kip lo a Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nang bere mum mo döxömen taun abo magingin saban te ewenene re öng, io, God irabo döxömen taun abo magingin saban te ine. Ma nang bere mum kobo döxömen taun abo magingin saban te ewenene re öng, io, God i karabo döxömen taun abo magingin saban te ine.” ");
INSERT INTO bjk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Io, nang e Jisas ixo ot pösöt abo bak ne ausu, Tomas, a öng mere idi a sangaun ma ninöng, nang tobo rengrengen ine bara a Xasang, kaim ine ra kinis arixe midi. ");
INSERT INTO bjk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Io, abo bak ne ausu toxo töngösen ine bara, “Mem mere pere a Orong!” Ma lamun ine ixo tengen te idi bira, “Nang bara kaim e ra werwere a mara möxö nil kö tabalana limine ma bara kaim e ra bulus a sisixine limeke xönan, ma bara kaim e ra bulbulus ölaxa a limeke xö lawana tarasine, e karabo nunu iat.” ");
INSERT INTO bjk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma xö pitnö ma narun ne bung melamu, abo bak ne ausu toxo kis baling kölöme xö gunon, me Tomas bölök arixe midi. Me idi toxo baxut ölölös kirip abo marame, ma lamun e Jisas ixo wan laxa ma ixo tuu kaluluonin idi ma ixo tengen bira, “A malum irabo kis kö bala mum!” ");
INSERT INTO bjk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Io, ixo tengen te Tomas bira, “Bulus a sisixine limem pa. Pere abo tabalana limeke. Sanga ma limem ma örö bulus ölaxa xö lawana tarasine e. Ganim a dinödöm araruo ma lamun örö nunu.” ");
INSERT INTO bjk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Me Tomas ixo tengen te ine, “Nöngön a Orong ke e ma God te e!” ");
INSERT INTO bjk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Io, Jisas ixo tengen te ine bira, “U nunu, möxösa, uru pere e. Me idi ewe niang tekala pere e ma lamun te nunu, irabo deek kö idi.” ");
INSERT INTO bjk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Me Jisas ixo pet a oleleng ne auxileng lölös kabise bölök kö wawara xöbo bak ne ausu re ine, niang kaim a gegeet ölaxa ina ginigeet kö ina buk na. ");
INSERT INTO bjk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Inexalik bara ina na e xoro geet bere mum morobo mana nunu im bere Jisas ine a Mesaia, a Barok kö God, ma bere mum morobo kip a to runon kölöme xö esene ine nang bere mum mo nunu re ine. ");
INSERT INTO bjk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Melamu baling, Jisas ixo wösö xöbo bak ne ausu rine xö lawana tu Taiberias. Ma ixo osen iat ine xina ngas na. ");
INSERT INTO bjk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, me Tomas nang tobo rengrengen ine ma Xasang, me Natanael mee Kena niang Galili, ma nine barok ke Sebedi arixe ma ninöng ne bak ne ausu xabise bölök kine toxo kis arixe. ");
INSERT INTO bjk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita ixo tengen tö idi bira, “E önan ta tewe eben.” Me idi toxo tengen, “Mem mara wan arixe me nöngön.” Io, idi toxo wan su ma toxo kakaa xö mön, nexalik kaim idi ra xikip pebo inan kina dömön. ");
INSERT INTO bjk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Xö warwara puxu, Jisas ixo tuu sik kiso löxön, nexalik abo bak ne ausu kaim idi rua werwere xulen bere ine e Jisas. ");
INSERT INTO bjk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisas ixo kup urungan tidi, “Bung barok ke e, kaim e mum merebo inan?” Me idi toxo balu ine bara, “Kawaim.” ");
INSERT INTO bjk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ine ixo tengen, “Mum moro tewe a eben te mum kö lawa tuun möxö mön me mum morobo kip pe dauleng.” Io nang, idi toxo tewe ösu, idi toxo kaim kö eöt tua sasat ölaxa a eben, möxö a inan ixo oleleng köba. ");
INSERT INTO bjk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Io, a bak ne ausu nang e Jisas ixobo mamaa xöba ulamun, ixo tengen te Pita, “A Orong iang!” Ma saxit iat mon e Saimon Pita ixo ölangen ine ixo tengen bara ine e Jisas, ixo usige ine ma saket (möxö ine ixo luwes tewe) ma ixo kos su uri xö ari. ");
INSERT INTO bjk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma öngabo bak ne ausu toxo muu xö mön. Me idi toxo sasat nanin a eben nang ixo wöwö sik ma inan, möxösa, kaim bere idi toxo ömat sik kalik a löxön, ixo xarnang a önga mar ne mita. ");
INSERT INTO bjk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma nang idi toxo ösö, idi toxo pere a ia ixoro söt malas. Ma a en lömö xönan, ma dauleng ne beret. ");
INSERT INTO bjk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Me Jisas ixo tengen tö idi, “A inan nang na mon mum mo kip, moro isik ke dauleng ura.” ");
INSERT INTO bjk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Io, e Saimon Pita ixo kakaa laxa xö mön ma ixo sat a eben urungan löxön. Ma ixo wöwö sik ma inan tataxin, ixo eöt ma önga mar ma pitnö ne sangaun ma narun kirip. I turunon bara ixo oleleng köba ma lamun a eben kaim kö tamadidi. ");
INSERT INTO bjk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Me Jisas ixo tengen tö idi, “Moro miang ma moro an.” Ma kaim pe bak ne ausu ixo döxömen tua ose ine bara, “Ewe nöngön?” Idi toxo ösöxö sik bere ine a Orong. ");
INSERT INTO bjk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas ixo wanot ma ixo kip a beret ma ixo tabaa nanin idi min, ma ixo pet bölök bie xö inan. ");
INSERT INTO bjk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na im, a sese önarun min nang e Jisas ixo ot pösöt abo bak ne ausu rine melamu xö tinaru baling kine xalik a minet. ");
INSERT INTO bjk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma nang idi toxoro an kirip, Jisas ixo tengen tue Saimon Pita bira, “Saimon barok ke Jon, bule, a mamaa re nöngön tö e i taxin köba re idi na?” Saimon Pita ixo tengen, “Turunon saxit, Orong, nöngön u ösöxö bara e mamaa xöba ulamun nöngön.” Me Jisas ixo tengen tö ine bara, “Örobo tabaa nienin abo baroxorok sipsip pe e.” ");
INSERT INTO bjk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Io, e Jisas ixo ose baling, “Saimon a barok ke Jon, u mamaa xöba ulamun e?” Me ine ixo tengen, “Turunon saxit, Orong, nöngön u ösöxö bara e mamaa xöba ulamun nöngön.” Me Jisas ixo tengen öbaling kö ine, “Örobo balaure abo sipsip pe e.” ");
INSERT INTO bjk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Io, sese önarunin Jisas ixo tengen te ine baling bara, “Saimon a barok ke Jon, u maa xöba ulamun e?” Pita ixo bala kadik im, möxösa, ixo narun ne aose im Jisas ixo pet tö ine bara, “Nöngön u maa xöba ulamun e?” Ine ixo tengen bira, “Orong, nöngön u ösöxö xirip abo lalaa. U ösöxö bara e maa xöba re nöngön.” Jisas ixo tengen, “Örobo tabaa nienin abo sipsip pe e. ");
INSERT INTO bjk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Turunon saxit, nang u xo barok maxat sik, u xobo xuxut dik nöngön iat ma man ma u xobo önan kö mamaa re nöngön. Inexalik bara nang u ötaxin, örobo ötöxödös a nine limem ma önga tödi xabise irabo usige nöngön ma irabo silien nöngön urungan nang u kobo maa rua nuan uwe.” ");
INSERT INTO bjk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas ixo tengen bira rua osen ina mangana minet sa nang rue Pita ra ölelet e God. Io, ixo tengen te ine, “Örobo muu e!” ");
INSERT INTO bjk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita ixo talingen ma ixo pere bara a bak ne ausu nang e Jisas ixobo maa xöba ulamun ixo mumuu idu. (Nangang nang ixo maru sede dik kö lawana e Jisas kö axana bung idi toxo aan ma ixo tengen, “Orong, ewenene irabo isik nöngön kö limine nangadi?”) ");
INSERT INTO bjk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ma nang e Pita ixo pere ine, ixo ose bara, “Orong, bara bule lamun ine?” ");
INSERT INTO bjk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas ixo tengen, “Nang bere e maa ulamun ine rua tino iat ot nang e rabo wanot baling, ruasa u dödödöm köba ulamun? Nöngön örobo mana muu e.” ");
INSERT INTO bjk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","A tinenge ixo wan esexere kaluluon köbo tönö bara ina bak ne ausu na i karabo met. Ma lamun e Jisas kaim kö rengrengen bara ine i karabo met. Ine ixo tengen mon bara, “Nang bere e maa ulamun ine rua tino iat ot nang e rabo wanot baling, ruasa u dödödöm köba ulamun?” ");
INSERT INTO bjk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ina bak ne ausu mon na ewe ine ibo rengrengen osen inabo lalaa na ma ixo geet ösu inabo tinenge. Me ire te ösöxö bara a lak turunon. ");
INSERT INTO bjk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas ixo pet a oleleng ne lalaa xabise bölök. Ma nang bara tabo geet ösu xirip idi öngöng, kaim pe boxönö xö öxöno lagunon iat tua bulbulus inabo buk nang bara texere geet. ");
INSERT INTO bjk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilas, kölöme xö sisila ne buk e xo geet, e xo geet lamun abo lalaa nang e Jisas ixo urulo xö tinörön ma a ausu re ine, ");
INSERT INTO bjk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ot kö axana bung nang e God ixo kip lo ine uruso xö watmaep. Melamu ixo kip lo e Jisas uruso lömö, Jisas ixo isik a tinenge möxö lölös möxö Töxödös ne Tanono urungan köbo aposol nang ine ixo pere kos lo. ");
INSERT INTO bjk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Melamu xö kinadik ma tiip pe ine, ixo osen ine xinabo duöng ma ixo isik a oleleng ne auxileng kua werwerexulen bara turunon saxit ine ixo to sik. Xö nit ne sangaun ne bung, e Jisas ixo orot pösöt idi ma ixo rerenge re idi lamun a kingdom kö God. ");
INSERT INTO bjk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jisas ixo isik a tinenge lölös se idi nang idi toxo ot arixe: “Gan a nuan lie e Jerusalem, lamun mum morobo kis xiset lo a arabaa nang e Tata ixo kubus, nang e mum moxo ölangen bara e xo wöwörö lamun. ");
INSERT INTO bjk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon ixo baptais ma ari, lamun köbo bung na uruso mon mum morobo kip baptais arixe ma Töxödös ne Tanono.” ");
INSERT INTO bjk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Io, nang abo aposol toxo ot etok arixe me Jisas ma toxo ose ine, “Orong, xina bung na örobo isik a kingdom kö God baling köbo Israel?” ");
INSERT INTO bjk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisas ixo tengen tö idi, “I kobo laa re mum pa ösöxö a bung mabo axana bung nang e Tata ixoro bulus kö lölös se ine iat. ");
INSERT INTO bjk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lamun morobo ilo a lölös kö bung nang a Töxödös ne Tanono irabo ot te mum, me mum morobo tengen a turunon tö e ruso Jerusalem, ma kölöme xirip Judeia me Samaria ma xö öxöwam möxö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Malamu xö tinenge nang ixo tengen, ine ixo wan kaa ma a kubu ixo kait pi lo ine xö wawara re idi. ");
INSERT INTO bjk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Idi toxo werwere dik e Jisas ixo önan kaa uruso lömö, ma saxit mon, a nine tödi idu toxo sige sik ana man pidien, toxo tuu sik kö lawana idi. ");
INSERT INTO bjk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Me idu toxo tengen, “Duöng meriso Galili, ruasa mum mo ruruu ringan ma mo wawara uruso lömö xö watmaep? Ina Jisas nang God i kip lo uruso lömö xö watmaep, ine mon nang irabo wan su baling kina ngas iat nang mum mo pere ine i wan kaa bie uruso xö watmaep.” ");
INSERT INTO bjk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Io, idi toxo wan lie a maii tobo tengen me Olip, ma toxo wan uruso Jerusalem. Ma Jerusalem i öt ma önga kilomita xalik a Maii Olip. ");
INSERT INTO bjk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nang idi toxo ot, idi toxo wan kaa xö xönö ruso lömö xö gunon nang idi tobo xisixis könan. Nangadi nang toxo ot e Pita, Jon, Jems me Endru, Pilip me Tomas, Batolomiu me Matiu, Jems a barok ke Alpius me Saimon a Silot me Judas a barok ke Jems. ");
INSERT INTO bjk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Idi xirip tobo orot etok ma toxobo seseseng sösöxö arixe mabo une, me Maria a nago re Jisas mabo tönö re ine. ");
INSERT INTO bjk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Xina bung niang Pita ixo tuu kaluluonin abo tene nunu. A marakörö toxo öt ma a mar ma nine sangaun arixe. ");
INSERT INTO bjk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Me Pita ixo tengen, “Abo töke, a tinenge re God toxo geet i eörin nang a Töxödös ne Tanono ixo tengen mesila saxit kö ngusuno Dewit lamun e Judas, nang ixo rörön xarnang a sisila, nang ixo sila re nangadi nang toxo tödik lo e Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ine a öng mere ire me ine ixo tön sik a subana tinörön kölöme xönan.” ");
INSERT INTO bjk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Arixe ma xinixun nang ixo kip lo möxö magingin saban te ine, Judas ixo kun a xönö pu, ma ringan könan ixo subu sila ma öxöno, ma aine ixo tawalang, ma balana ixo tamaluok su. ");
INSERT INTO bjk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma nangadi xirip niso Jerusalem toxo ölengen lo, ma xö tinenge re idi, idi toxo tengen ina xönö pu nang ma ese ‘Akeldama,’ a unine bara a ‘Öxöno Pu möxö Dee.’) ");
INSERT INTO bjk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Me Pita ixo tengen öbaling bira, “Na ixo ot, möxö toxoro geet ösu xö Buk ne Sinö bira, ‘E mamaa bara a gunon te ine irabo mene, ma kaim pe öng irabo kis könan.’ Ma ixo tengen baling bira, ‘Re öng kabise irabo kip lo a ngasiene xina tinörön ne tene sisila.’ ");
INSERT INTO bjk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Io, tabo mana pere kos lo re öng mere idi ewe nang toxoro kis arixe me ire xöbo bungbung kirip nang e Jisas, a Orong, ixo önan eli kaluluonin ire, ma urulo xö baptais se Jon urungan kö bung nang God ixo kip lo e Jisas uruso lömö xalik ire. Io, öng mere idi irabo mana arixe me ire ra tinenge maras lamun a tinaru baling ke Jisas nang a lak turunon.” ");
INSERT INTO bjk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Io, idi toxo maraxa ra pere kos a nine tödi, Josep nang tobo rengrengen ine me Barsabas (esene bölök e Jastus), me Matias. ");
INSERT INTO bjk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Idi toxo seseseng, “Orong, u ösöxö sik a dinödöm kö nangadi xirip. Orong, e seng nöngön örö osen e mem me nangang sa re idu nang uru pere kos lo rua xuxulas e Judas kina tinörön möxöbo aposol. Judas ixo wan lie ina tinörön ma ixo baling lamun kö xönö nang a kinis se ine iat.” ");
INSERT INTO bjk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Io, idi toxo tewe a nine wat tua pere kos lo ewenene re Josep me Matias irabo kip kulas ina tinörön te Judas, ma wat ixo subu ma ixo osen bere Matias. Io, toxo kos ölaxa ine xö önga sangaun ma öng ne aposol. ");
INSERT INTO bjk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nang a bung möxö Pentikos ixo ot, idi xirip toxoro ot etok arixe xö önga xönö. ");
INSERT INTO bjk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma saxit mon, a ginee xarnang a winawaxat möxö xiki lölös ixo wan su meriso lömö, ma ixo öwöwö xirip ina könönö gunon nang idi toxo kisisik e. ");
INSERT INTO bjk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Idi toxo pere a laa xarnang a kamene ia ixo wan elixilik ma ixo kis kö öxödi a öngöng. ");
INSERT INTO bjk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Idi xirip toxo wöwö arixe ma Töxödös ne Tanono ma toxo urulo ra tinenge mabo tinenge xabise nang a Tanono ixo ölölös idi rua tinenge min. ");
INSERT INTO bjk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Io, a oleleng ne tene lotu möxöbo tee mee Judeia nang möxö boxönö xirip kö öxöno lagunon kö pu, toxo xisixis Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nang toxo ölangen ina ginee, a marakörö toxo ot etok ma toxo ngangao, möxösa, öngöng mere idi ixo ölangen a tinenge re ine iat nang idi toxo wöwörö min. ");
INSERT INTO bjk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Abo Judeia toxo wuwus köba ma toxo ose, “Ina nangadi na te wöwörö, idi mee Galili? Goo? ");
INSERT INTO bjk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Io, bule bara ire öngöng te ölangen idi te wöwörö ma tinenge runon te ire öngöng iat? ");
INSERT INTO bjk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ire mee Patia, Midia ma Ilam, me ire mee Mesopotemia, Judeia ma Kapadosia, Pontus ma Esia, ");
INSERT INTO bjk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirigia, Pampilia, Isip ma boxönö möxö Libia lörörö Sairin, mabo osee meriso Rom ");
INSERT INTO bjk_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(idi xirip abo Judeia arixe mabo osee nang toxo laxa xö lotu ridi abo Judeia), ma dauleng ke ire mee Krit ma Arebia. Ire te ölangen kulen idi te wöwörö mabo tinörön lölös kö God köbo tinenge iat te ire.” ");
INSERT INTO bjk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Idi toxo wuwus ma toxo ngangao ma toxo eose nana iat te idi, “A lasa ina unine möxö ina winawara na?” ");
INSERT INTO bjk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Inexalik, a dauleng toxo eösaxit me idi ma toxo tengen bira, “Idi te inim ösaxit a ari lölös.” ");
INSERT INTO bjk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Io, Pita ixo tuu kaa arixe ma sangaun ma öng ne aposol, ma ixo tenge raxin ma ixo tenge maras kö marakörö: “Mum abo Judeia me mum kirip nang mum mo xisixis kölöme Jerusalem, moro ölangen ödeek a tinenge na arabo palas se mum. ");
INSERT INTO bjk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Abo duöng na tekobo inim, nang mum mo döxömen bie. Kaim. A pitnö ma nit ne axana bung kö puxu mon bang a! ");
INSERT INTO bjk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ina tinenge na e propet Joel ixo etöngösen min. ");
INSERT INTO bjk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God ixo tengen, xöbo axana bung möxö xakawöm, e rabo tile ösu a Tanono e lömö xö nangadi xirip. Abo baroxorok ma balixilik ke mum tabo palas tinenge xarnang abo propet, abo guama re mum tabo pere a winawara, ma abo duöng maruxo tabo pönöbe a wöpönöbö. ");
INSERT INTO bjk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ma xinabo bung e rabo tile ösu a Tanono e xöbo tultul te e, a körö ma balixilik arixe min, me idi tabo palas tinenge xarnang abo propet. ");
INSERT INTO bjk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","E rabo pet abo mangana lalaa ne awuwus suso lömö xö watmaep mabo uxileng kö öxöno lagunon kö pu. Irabo bira, dee ma ia sösöt ma tabaa raxin irabo ot. ");
INSERT INTO bjk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A xaken irabo tawuxus urungan kö ködö lilimen ma texe irabo dadan xarnang a dee. Malamu, a mariris ne bung taxin kö Orong irabo ot. ");
INSERT INTO bjk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma nangadi xirip ewe idi nang tabo seng a Orong bara irabo top idi, tabo kip a to.’ ");
INSERT INTO bjk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Mum a nangadi mee Israel, moro ölangen inabo tinenge na: Jisas mee Nasaret a tödi nang e God ixo osen te mum bere Jisas ine ewe. Me God ixo pet abo mangana lalaa ne auwuwus mabo auxileng lölös kaluluonin e mum, ma ixo pet abo lalaa na xö limine Jisas xarnang mon mum iat mo ösöxö sik. ");
INSERT INTO bjk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Toxo isik e Jisas urungan te mum, möxösa, God, kö mamaa ma nanase re ine iat, ixoro pingit bara tabo pet bie. Me mum iat mabo nangadi saban moxo tut ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lamun e God ixo öraru öbaling ine xalik a minet, ma ixo ölanglanga ine xalik a kinadik möxö minet, möxösa, a minet i koxobo eöt ta rörödik ine. ");
INSERT INTO bjk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dewit ixo tenge lamun ine: ‘E bo werwere a Orong mesila re e xöbo bungbung kirip. Abo tiip i karabo ot tua ögigie e möxösa, ine i lörörö re e. ");
INSERT INTO bjk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Io nang, a balake i deek me e tenge axanan. A aike bölök irabo xixiset ma nunu ulamun abo lalaa deek, ");
INSERT INTO bjk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","möxösa, nöngön ökorobo ganim tewe e urungan kö lagunon ne minet, ma ökorobo ömaraxen lo re Öng ke nöngön Nang i Madakdak bara irabo maxus. ");
INSERT INTO bjk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nöngön u xoro ömaras e xö ngas möxö to, ma örobo öwöwö e ma axanan, möxösa, nöngön u kis arixe me e.’ ");
INSERT INTO bjk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Abo töke, e maras kirip sik ke Dewit, me e öt sik ka tengen osen e mum bara ixo met ma toxo pömös ine, ma a maöt te ine i nangen i kis nixinen. ");
INSERT INTO bjk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ine a propet ma ixo ösöxö bere God ixoro sugurno sik bere ine irabo uxis a untubuno xö kinis ne warkurai te ine. ");
INSERT INTO bjk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dewit ixoro maras lamun abo mangana lalaa nang irabo ot melamu, ma ixo etöngösen ma tinaru baling möxö Mesaia. Ixo tengen bara God i karabo ganim tewe ine urungan kö lagunon ne minet bara a lewene aine irabo maxus. ");
INSERT INTO bjk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ine Jisas mon na, God ixo öraru öbaling ine me mem kirip moxo pere ina lalaa na, me mem moxo etöngösen min bara i turunon. ");
INSERT INTO bjk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Me God ixo öraxin ine ma ixo uxis ine xö lime tuun tine iat, me Jisas ixo kip lo a Töxödös ne Tanono i eöt ma kunubus se God. Ma na, mum mo werwere ine, me mum moro ölangen ina arabaa nang ine ixo tile urungan tö idi. ");
INSERT INTO bjk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ma i maras bara Dewit kaim ine ra nuan uruso xö balana kubu, ma lamun ine iat ixo tengen bara, ‘A Orong i tengen kö Orong ke e bara: “Nöngön u kisisik kö lawa tuun te e ");
INSERT INTO bjk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ot nang arabo bulus abo iuo re nöngön kö ene xexem.” ’ ");
INSERT INTO bjk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Möxö ina na, i deek bara abo Israel kirip tabo ösöxö bere God ixoro uxis ina tödi na e Jisas, ine ewe nang mum moxo tut kö sölöxöröp, bere ine a Orong ma Mesaia bölök.” ");
INSERT INTO bjk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma nang a nangadi toxo ölangen ina tinenge na, ixo kara abo baladi me idi toxo tapunuk ma toxo tengen te Pita ma önga bo aposol, “Abo tönö e mem, a lasa mem marabo pet?” ");
INSERT INTO bjk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita ixo balu idi bira, “Mum kirip a öngöng moro dödöm puxus ma moro kip baptais kö esene Jisas Krais nang e God irabo döxömen taun abo magingin saban te mum. Me mum morobo kip lo a arabaa xö Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A kunubus na rua gene mum ma a bung baroxorok ke mum bölök, ma re we midi nang te kis kö palaa. Ina kunubus na rua gene idi xirip na nang a Orong, a God te ire, irabo kuwe idi.” ");
INSERT INTO bjk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ixo tengen ögele idi ma oleleng ne mangana tinenge, ma ixo tengen bira, “Balaure ödeek e mum iat, xalik e mum bo iuo arixe ma inabo nangadi saban na.” ");
INSERT INTO bjk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ewenene midi nang toxo ömaraxen lo a tinenge re ine, toxo kip baptais. Ma xina bung na ixo eöt ma narun ne arip ne nangadi toxo laxa ra öraxin a xinoxos möxöbo tene nunu re Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Idi toxo isik idi iat ta ölangen abo inausu xöbo aposol, ma ra inot etok arixe rua rorop idi öngöng, ma rua widwidik a beret, ma ra sineseng. ");
INSERT INTO bjk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mabo aposol toxo pet a oleleng ne laa ne auwuwus mabo uxileng lölös, ma nangadi xirip toxo ii e God ma binuut. ");
INSERT INTO bjk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abo tene nunu xirip toxo kis etok arixe, ma toxo bulus etoxin abo lalaa re idi ma toxo erimine kaluluonin idi iat. ");
INSERT INTO bjk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Idi toxobo mimiisik mabo lalaa nang idi te unan ma toxobo erimine xö nangadi ewe idi nang te sasaxan. ");
INSERT INTO bjk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Xö bungbung kirip idi toxobo orot etok arixe kölöme xö gunon lotu raxin. Idi toxobo aan arixe xöbo gunon te idi a öngöng, ma toxobo aan arixe ma bala malum ma axanan kö to re idi. ");
INSERT INTO bjk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Idi toxobo ölelet e God, ma a nangadi xirip toxobo axanan me idi. Ma ewe midi nang a Orong ixobo öro idi, ixo bulus ölaxa idi xö xinoxos se idi abo tene nunu xöbo bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Xö önga bung, Pita me Jon toxo wan uruso xö gunon lotu raxin kö narun ne axana bung kö aien nang a axana bung ke idi möxö sineseng. ");
INSERT INTO bjk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Io, önga tödi, a nene ixo kiwine ma lak pengpeng, toxo kip lo ine ma toxo bulus ine ringan kö marame laxlaxa möxö xönö mesila xö gunon lotu raxin, nang tobo rengrengen ma Mariris. Bungbung kirip tobo uxis sik ine xina marame rua seng tuluwok kalik a nangadi nang tobo laxlaxa xina xönö xö gunon lotu. ");
INSERT INTO bjk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nang ixo pere e Pita me Jon toxo eka nuan laxa, ine ixo seng tuluwok kalik idu. ");
INSERT INTO bjk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita me Jon toxo pere dik ine, io, Pita ixo tengen, “Örö pere e maa!” ");
INSERT INTO bjk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Io, a tödi nang ixo pere dik idu ixo döxömen bara irabo kip lo rebo lalaa xalik idu. ");
INSERT INTO bjk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Io, Pita ixo tengen, “Siliwa bara gol kaim e min, ma lamun a lasa nang e min, e rabo tabaa nöngön min. Kölöme xö esene Jisas Krais mee Nasaret, örö taru örö wan.” ");
INSERT INTO bjk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita ixo tön lo ine xö lime tuun, ma ixo top ine ra tinuu, ma saxit iat mon, abo xexene ina tödi arixe ma abo busuno xexene ixo deek. ");
INSERT INTO bjk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ixo kos kaa ma ixo tuu, io, ixo urulo a nuan. Ixo wan laxa arixe me idu urungan kö xönö mesila xö gunon lotu, ixo önan ma ixo xoxos, ma ixo ölet nanin e God. ");
INSERT INTO bjk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A nangadi xirip toxo pere ine ixo önan ma ixo ölet nanin a esene God. ");
INSERT INTO bjk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Idi toxo perexulen ine bara ina tödi mon nang ixobo kisisik ma ixobo seseng tuluwok kö mariris ne marame laxlaxa möxö gunon lotu raxin. Idi toxo wuwus ma toxo dödöm oleleng kö mangana laa nang ixo ot te ine. ");
INSERT INTO bjk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ma nang ina tödi pengpeng ixo tödik e Pita me Jon, a nangadi xirip toxo wuwus ma toxo ulo urungan te idiet kö xönö tobo rengrengen ma Walpali re Solomon. ");
INSERT INTO bjk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Io, nang e Pita ixo pere birina, ixo tengen tö idi, “Duöng mee Israel, ruasa a laa birina i öwuwus e mum? Ma ruasa mum mo ngökngök ke maa, i xarnang bara a lölös iat te maa, ma bara xö tatalien deek ke maa xö wawara re God, maa me ölanglanga ina tödi ma i wan? Kaim. ");
INSERT INTO bjk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A God te Abaram, te Aisak me Jekop, ma God köbo untubuno ire, i öraxin a tödi tinörön te ine, e Jisas. Mum moxo isik ot ine rua minet, me mum moxo kasen tewe ine mesila re Pailat, io, nang ixo mamaa ra öbala rewe ine. ");
INSERT INTO bjk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mum moxo mölök lamun ina öng nang a tene Madakdak ma a tene Töxödös ine, me mum moxo ose e Pailat lamun a tödi möxö inarse ömet, bere Pailat irabo öbala ösu ine urungan te mum. ");
INSERT INTO bjk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mum moxo sexomet a tödi nang ine a unine to, ma lamun e God ixo öraru öbaling ine xalik a minet. Mem a nangadi nang moxo pere ine, mem me etöngösen bara i turunon. ");
INSERT INTO bjk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Xö nunu xö esene Jisas, ina tödi ewe niang mum mo pere ma mo ösöxö ine ixo kip lölös. A lölös möxö esene Jisas ma a nunu nang i wanot meringan tine nang ixo ölanglanga ine xarnang mum moro pere. ");
INSERT INTO bjk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Io, abo töke, e ösöxö bara a lasa nang mum moxo wewet te Jisas mum kobo maras bara mum mo wewet a sa, mum arixe mabo tene sisila re mum. ");
INSERT INTO bjk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Inexalik bara God ixo pet eörin a lasanene xarnang ine ixoro tengen köbo propet, bara Mesaia rine irabo kip a kinadik. ");
INSERT INTO bjk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Moro dödöm puxus, ma moro tawuxus urungan te God, io, God irabo döxömen taun abo magingin saban te mum mabo bung irabo ot nang a Orong irabo ösidö e mum, ");
INSERT INTO bjk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","me God irabo tile e Jisas, a Mesaia ewe nang ine ixo pere kos lo ine rö mum. ");
INSERT INTO bjk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ine irabo xisixis iat tuso lömö xö watmaep ot kö bung nang irabo ot te God ta ömaxat abo lalaa xirip kö öxöno lagunon, nang ixoro tengen lorexe saxit köbo madakdak ne propet te ine. ");
INSERT INTO bjk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses ixo tengen, ‘A Orong, a God te mum, irabo uru re önga propet xarnang e ringan kaluluonin e mum iat. Me mum morobo mana ölangen kirip abo tinenge nang irabo tengen te mum. ");
INSERT INTO bjk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nang bere ewenene i kobo ölangen ine, io, tabo irewe ine xalik a nangadi re ine iat, io, irabo mana met.’ ");
INSERT INTO bjk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Abo propet kirip iat urulo re Samuel me idi nang melamu rine, idi toxo wöwörö mabo lalaa nang irabo wanot kinabo bung na. ");
INSERT INTO bjk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mum morobo kip lo a inone tinenge xalik abo propet, me mum ina kunubus nang e God ixo pet arixe mabo tubu mum. Me ine ixo tengen te Abaram bira, ‘Meringan kölöme xöbo tubu mum e rabo wadöane a nangadi xirip möxö öxöno lagunon.’ ");
INSERT INTO bjk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nang e God ixo öraru öxaa a tultul te ine, e Jisas, ixo tile araun ine urungan te mum pa wadöane e mum bira: irabo lamus puxus a öngöng mere mum kalik abo magingin saban te mum.” ");
INSERT INTO bjk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Abo pris mabo Sadiusi ma a umri raxin möxöbo köbat möxö gunon lotu raxin, toxo wanot pösöt e Pita me Jon kina axana bung nang idu toxo wöwörö xö nangadi. ");
INSERT INTO bjk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Idi toxo bala kinadik köbo aposol, möxösa, idu toxo palas tinenge ma toxo usu a nangadi bere Jisas ine ina unine möxö tinaru baling möxö minet. ");
INSERT INTO bjk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Idi toxo tödik e Pita me Jon, me idi toxo bulus idu kölöme xö gunon ne aömokorot ot kö bung kabise, möxö ixoro aien. ");
INSERT INTO bjk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma lamun a oleleng ewe idi nang toxo ölangen a tinenge, toxo nunu. Ma xinixos se idi ixo wan kaa xö pitnö ne arip. ");
INSERT INTO bjk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xö bung melamu, abo sisila xöbo Judeia, abo duöng tataxin, mabo tene ausu möxöbo warkurai te Moses, toxo wan etok kuso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas nang a sisila raxin möxöbo pris i nangen iang arixe me Kaiapas, Jon, Aleksenda ma abo duöng kabise möxö baninen kö sisila raxin möxöbo pris idi bölök nangen. ");
INSERT INTO bjk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Idi toxo uru e Pita me Jon mesila xö wawara re idi ma toxo ose puk idu, “Xö lölös sa ma xö ese sa mu mo pet inabo lalaa na?” ");
INSERT INTO bjk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Io, Pita ixo wöwö ma Töxödös ne Tanono ma ixo tengen te idi bira, “Abo tene sisila mabo duöng tataxin kö nangadi, mum moro ölangen! ");
INSERT INTO bjk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nang bara mum mo ose ömuu e maa nixinen lamun a tatalien deek nang maa moxo osen kö pengpeng me mum mo ose bule ine ixo langlanga, ");
INSERT INTO bjk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","io, mum ma nangadi xirip mee Israel, moro ösöxö a na, bara tödi na i tuu sik kö mamaran te mum, i langlanga xö lölös möxö esene Jisas Krais mee Nasaret, ewe mum moxo tut ine xö sölöxöröp, me God ixo öraru ine xalik a minet. ");
INSERT INTO bjk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ine ‘a wat nang e mum abo tene pet gunon mum koxobo mamaa ulamun, nang ine bölök im a lölös möxö unine gunon kirip.’ ");
INSERT INTO bjk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kaim pe tödi xabise bölök i eöt tua öro ire, möxö kaim pe ese xabise lawu xö öxöno lagunon God ixo isik kö nangadi i eöt turunon ta öro ire.” ");
INSERT INTO bjk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nang idi toxo pere bere Pita me Jon idu kaim kö binuut ma toxo perexulen bara idu kaim kö ausu ma nine tödi tataun mon, idi abo tödi sisila toxo wuwus me idi toxo ösöxö bara idu toxoro kis arixe me Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Inexalik, kawaim idi mere tinenge rua rengrengen, möxösa, idi toxo pere ina tödi ewe ixoro langlanga ixo tuu sik arixe me idu. ");
INSERT INTO bjk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Io, idi abo duöng tataxin toxo tengen te idiet ta nuan kalik ina kansel, io, idi toxo wöwörö kaluluonin idi. ");
INSERT INTO bjk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Idi toxo ose, “A lasanene ire tabo pet lamun a nine tödi na? Nangadi xirip nang tobo xisixis Jerusalem tere ösöxö bara idu toxoro pet a mangana laa lölös ne auwuwus, me ire tekobo eöt ta rengrengen bara i kobo turunon ina laa. ");
INSERT INTO bjk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lamun ire te mamaa bara i bele wan esexere. Io, ire tabo mana ögele a nine tödi na ra ganim idu ra atöngösen mere tödi baling kö ese na.” ");
INSERT INTO bjk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Io, idi toxo kuwe lo öbaling idu ma toxo tenge lölös se idu bara ganim idu ra winörö ma ra inausu bölök im ma esene Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lamun e Pita me Jon toxo balu idi bira, “Mum iat moro kure bara i töxödös sik kö wawara re God bere maa marabo ölangen e mum ma ganim e God. ");
INSERT INTO bjk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Möxö maa me kebeöt ta xakawam pa tinenge xalik a sa nang e maa moxoro pere ma moxoro ölangen.” ");
INSERT INTO bjk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Melamu im köbo tinenge lölös nang toxo isik ke idu toxo öbala ösu idu ra nuan. Idi toxo pere bara i kebeöt ta ömaso idu, möxö a nangadi xirip toxo ölet e God lamun a lasa nang ixoro ot, ");
INSERT INTO bjk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","möxösa, a tödi ewe nang ixo langlanga xö lölös möxö pet laa ne auwuwus, a awat tine ixo saxit a nit ne sangaun. ");
INSERT INTO bjk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nang toxo irewe idu, Pita me Jon toxo wan baling urungan kö nangadi re idu ma toxo tengen ösu xirip abo tinenge nang abo pris tataxin mabo sisila xö nangadi toxo tengen te idu. ");
INSERT INTO bjk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nang idi toxo ölangen inabo tinenge na, idi toxo urulo ra sineseng arixe ma önga dinödöm mon uruso re God, idi toxo tengen, “Orong taxin, nöngön u xo pet a balana kubu ma öxöno lagunon ma rasi, mabo lalaa xirip kölöme xönan. ");
INSERT INTO bjk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","U xo wöwörö ma Töxödös ne Tanono meringan kö ngusuno a tene tinörön te nöngön, untubuno ire e Dewit: ‘Ruasa bara a nangadi nang kaim bara abo Judeia idi te bala kadik? Ruasa bara a nangadi te kubus tinenge me idi tekebeöt ta wewet eörin? ");
INSERT INTO bjk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Abo king mera xö öxöno lagunon toxo tagure idi iat mabo sisila toxo tuu arixe ra bulbulus ösu a Orong ma ra bulbulus ösu e Mesaia re ine.’ ");
INSERT INTO bjk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Turunon saxit, e Erot me Pontias Pailat toxo tuu arixe mabo nangadi nang kaim bara abo Judeia ma a nangadi mee Israel kölöme xö ina lagunon taxin na rua wewet abo ngas saban lamun a madakdak ne tene tinörön te nöngön, e Jisas ewe nang u xo uxis ine bara ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Idi toxo pet abo lalaa xirip nang a lölös ma mamaa re nöngön ixo pingit ösila bara irabo ot. ");
INSERT INTO bjk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Orong, örö döxömen abo tinenge re idi nang idi te tengen bara tabo ögarin e mem, ma örö top e mem abo tultul te nöngön ta atöngösen ma tinenge re nöngön ma balamasa. ");
INSERT INTO bjk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sasanga ma limem pa ölanglanga a nangadi miniset ma ra wewet abo auxileng lölös ma lalaa ne auwuwus kölöme xö esene Jisas, a madakdak ne tene tinörön te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Melamu xö sineseng, a xönö nang idi toxo kis etok könan ixo gigie. Me idi xirip toxo wöwö ma Töxödös ne Tanono ma toxo urulo ra atöngösen ma tinenge re God ma nunu ma balamasa. ");
INSERT INTO bjk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A nangadi xirip nang toxo nunu, toxo tuu arixe xö önga dinödöm ma önga baladi, ma kaim pe öng ixo tengen bara abo lalaa rine xalik mon, ma lamun idi toxo erabaa kaluluonin idi öngöng mabo laa re idi iat. ");
INSERT INTO bjk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abo aposol toxo palas tinenge ma lölös taxin kö tinaru baling ke Jisas, a Orong, ma a abalamu raxin saxit ixo kis lömö re idi xirip. ");
INSERT INTO bjk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kaim pe öng kaluluonin idi ixo sasaxan. Ma xöbo bung nang, a dauleng ne nangadi toxo mimiisik ma pu bara gunon, toxo kiwot a tuluwok nang toxo kip möxö misik ");
INSERT INTO bjk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ma toxo bulus mesilanin abo aposol, me idi im toxo erimine xö nangadi nang toxo sasaxan. ");
INSERT INTO bjk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josep meri Saipras, ine möxö bung marapun nang a Liwai, ewe niang abo aposol tobo rengrengen ine me Banabas (ma a unine bira a Tene Aöxaxat), ");
INSERT INTO bjk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ixo misik ma xönö pu rine ma ixo kiwot a tuluwok ma ixo bulus mesilanin abo aposol. ");
INSERT INTO bjk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Io, a tödi, a esene Ananias, arixe me usuono Sapaira, idu toxo misik ma öxöno pu nang idu toxo unan sik. ");
INSERT INTO bjk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A uleng möxö ina tuluwok, Ananias kaim ine xo osen, ma uleng nang ixo kip, ixo bulus mesilanin abo aposol. Ma usuono ixo ösöxö sik ina na. ");
INSERT INTO bjk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Io, Pita ixo tengen, “Ananias, bara bule arixe nang e Satan i öwöwö xöbanin a balam nang u rö töxö a Töxödös ne Tanono ma u rö tödik a subana tuluwok kö nöngön iat, nang toxo isik ke nöngön lamun a xönö pu? ");
INSERT INTO bjk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nang bang kaim nöngön ta misik mina öxöno pu, ixo re nöngön iat. Ma nang u xo misik tar min, ina tuluwok ke nöngön bölök. A sa ixo pet nöngön nang u dödöm pa wewet ina mangana tatalien? U kobo röxröxö a nangadi. U röxröxö e God.” ");
INSERT INTO bjk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nang e Ananias ixo ölangen ina na, ine ixo subusu ma ixo met. Ma binuut taxin saxit ixo kip ewe idi nang toxo ölangen a lasa nang ixo ot. ");
INSERT INTO bjk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Io, a bung guama toxo wanot, toxo kait lo ine, ma toxo kip ösu ine ma toxo pömös ine. ");
INSERT INTO bjk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Melamu xö narun ne awa, a usuono ixo wan laxa, kaim a ösöxö bara a sa ixoro ot. ");
INSERT INTO bjk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita ixo ose ine, “Örö tengen te e, ine mon ina xunuxun nang nöngön me Ananias mu moxo kip lo möxö pu?” Ma usuono ixo aut ma ixo tengen, “Ine iat mon ina xunuxun.” ");
INSERT INTO bjk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ixo tengen te ine, “Bara bule mu moro maraxa lo mon ta ölewen a Töxödös ne Tanono? Pere bang! Abo xexene nangadi nang te pömös e usuom, idi iang kö marame, me idi tabo kip ösu bölök nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Saxit iat mon ina une ixo subusu xö xexene Pita ma ixo met. Io, abo guama toxo wan laxa, ma toxo pere ine ma ixoro met, toxo kip ösu ine ma toxo pömös ine xö lawana usuono. ");
INSERT INTO bjk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A binuut taxin ixo kip abo tene lotu xirip, me idi xirip bölök nang toxo ölangen ina laa nang ixo ot. ");
INSERT INTO bjk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abo aposol toxo pet a oleleng ne lalaa ne auxileng lölös ma lalaa ne auwuwus kaluluonin a nangadi. Ma abo tene nunu xirip toxobo orot etok arixe ma önga dinödöm kö gunon ne walpali re Solomon. ");
INSERT INTO bjk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","I turunon bara a nangadi xabise toxo ii öraxin abo tene nunu, ma lamun idi toxo bubuut ta kinis arixe ma abo tene nunu. ");
INSERT INTO bjk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","A oleleng saxit, a körö ma balixilik, idi toxo nunu xö Orong me idi mon niang toxo pet a xinixos möxöbo tene nunu ixo wan kaa. ");
INSERT INTO bjk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Möxö ina na, a nangadi toxo lamus ot a nangadi miniset urungan kö ngas ma toxo ömarin idi lömö xö öra ma ben bara a tanono e Pita irabo tawi a dauleng ke idi nang bara ine i sasaxit. ");
INSERT INTO bjk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Marakörö toxo orot etok bölök möxöbo lagunon lörörö Jerusalem, ma toxo lamus a nangadi miniset te idi ma ewe bölök nang a tano saban ixo sige idi, me idi xirip toxo deek baling. ");
INSERT INTO bjk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Io, a sisila raxin möxöbo pris mabo Sadiusi nang tobo rörörön arixe mine, idi toxo wöwö ma bala kadik. ");
INSERT INTO bjk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Idi toxo öxös abo aposol ma toxo ölaxa idi xö gunon ne aömokorot möxö nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma lamun kö dömön a angelo xö Orong ixo sawang abo marame möxö gunon ne aömokorot, ma ixo lamus ösu idi. ");
INSERT INTO bjk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ma ixo tengen te idi, “Mum moro wan ma moro tuu ruso kölöme xö xönö mesila xö gunon lotu raxin ma moro tengen kirip abo tinenge möxö ina to maxat na xö nangadi.” ");
INSERT INTO bjk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nang a körörö ixo tawalang idi toxo wan laxa xö gunon lotu raxin, xarnang ixo tengen te idi bie, ma toxo urulo ra usu a nangadi. Io, nang a sisila raxin möxöbo pris mabo duöng ke ine toxo ot, idi toxo kuwe etoxin abo sisila ne kansel kirip mee Israel, ma toxo tile tinenge urungan kö gunon ne aömokorot lamun abo aposol. ");
INSERT INTO bjk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma lamun kö inot te idi xö gunon ne aömokorot, abo tultul kaim a werwere abo aposol kölöme. Io, idi toxo wan baling ma toxo töngösen abo sisila bara, ");
INSERT INTO bjk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Mem me pere a gunon ne aömokorot i tamabaxut, mabo köbat te tuu sik kö marame, ma lamun nang e mem me sawang abo marame, mem me parasiwin bara kaim pe öng kölöme.” ");
INSERT INTO bjk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Xö ölöngö möxö ina atöngösen, a sisila möxöbo köbat mabo pris tataxin toxo dödöm oleleng, ma toxo dödödöm bara a lasa irabo wanot möxö ina laa na. ");
INSERT INTO bjk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Io, önga tödi ixo ot ma ixo tengen, “Mum moro pere bang! A nangadi nang mum moxo bulus ölaxa idi xö gunon ne aömokorot te tuu sik niso xö xönö mesila xö gunon lotu raxin ma te uusu a nangadi.” ");
INSERT INTO bjk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nang idi toxo ölangen ina na, a sisila möxöbo köbat ixo wan arixe mabo tödi raxin te ine ma toxo lamus lo abo aposol. Kaim idi ra öraran abo aposol, möxösa, idi toxo burin a nangadi xalik idi tobo teng idi ma warawat. ");
INSERT INTO bjk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nang idi toxo lamus ot abo aposol urungan kö kansel, idi toxo uru idi mesila xö kansel tua ina sisila raxin möxöbo pris ta ose muu idi. ");
INSERT INTO bjk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ine ixo tengen, “Mem moxo isik a tinenge lölös se mum bara ganim e mum pa ausu baling mina ese nang. Ma lamun e mum mo öwöwö e Jerusalem arixe ma ausu re mum me e mum moxo puk e mem mina minet kina tödi na.” ");
INSERT INTO bjk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita mabo aposol toxo balu, “Mem marabo mana tame e God, ma kaim bara duöng. ");
INSERT INTO bjk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A Orong köbo tubuno ire ixo öraru e Jisas kalik a minet, ewe nang mum moxo sexomet nang moxo taba ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God ixo ii öxaa ine uruso xö lime tuun te ine iat xarnang a Sisila Raxin ma Tene Aöro nang ine irabo sawang a ngas bara abo Israel tabo dödöm puxus ma ra döxömen taun abo magingin saban te idi. ");
INSERT INTO bjk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mem moxo pere ma moxo tengen ösu a turunon möxö xinabo lalaa na, ma a Töxödös ne Tanono bölök, ewe nang God iri isik ke ewe midi nang te tame ine.” ");
INSERT INTO bjk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nang idi toxo ölangen bira, idi toxo bala kadik köba ma toxo mamaa ra sesexomet idi. ");
INSERT INTO bjk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lamun a Parasi esene iang e Gamaliel, a tene ausu möxöbo warkurai te Moses, ewe nang a nangadi toxobo ii öraxin ine, ixo tuu kaa kölöme xö kansel ma ixo isik a tinenge lölös köbo köbat bara idi ta lamus ösu abo aposol uri xö araman. ");
INSERT INTO bjk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Io, ixo tengen te idi, “Mum a nangadi mee Israel, morobo balaure ödeek e mum kö mangana lasa nang mum morobo döxömen tua wewet kö nangadi na. ");
INSERT INTO bjk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mum mo döxömen bölök nang e Tiudas ixo ot dauleng ne awat mesila. Ixo tengen bere ine a önga mangana sisila. Ma ixo eöt ma nit ne mar ne tödi toxo muu ine. Ma lamun a dauleng toxo sexomet ine, ma a nangadi nang toxobo mumuu ine, toxo wan elixilik, ma a tinörön te ine ixo laa tataun. ");
INSERT INTO bjk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Io, melamu rine, Judas mee Galili ixo tuu wösö xö bung möxö kos nangadi ma ixo silien a dauleng ne nangadi ra mumuu ine ra iwes abo Rom nang tobo kure sik ire. A dauleng toxo sexomet bölök ine, mabo nangadi xirip nang toxobo mumuu ine, toxo wan elixilik. ");
INSERT INTO bjk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Xina tiip na, e tengen te mum bara ganim pa wewet te laa re idi! Moro ganim idi. Io, nang bara ina tinörön na i taru xö dinödöm kö nangadi mon, irabo kawam. ");
INSERT INTO bjk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma lamun nang bara i ot meriso re God, mum kebeöt ta wanwanak idi, me mum morobo ösöxö bere mum mo erese me God.” ");
INSERT INTO bjk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Io, idi toxo muu a tinenge re Gamaliel. Idi toxo kuwe lo abo aposol uruso kölöme ma toxo dangat idi. Io, toxo tengen te idi bara ganim a rengrengen a esene Jisas, ma toxo öbala rewe idi ra nuan. ");
INSERT INTO bjk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abo aposol toxo wan kalik abo kansel ma axanan, möxösa, God ixoro perexulen bara idi tere eöt sik ka xikip a minenge xö esene Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma xöbo bungbung kirip, kölöme xö gunon lotu raxin ma xöbo gunon kirip, idi tekara mut ta inausu ma palas tinenge lamun a tinenge maxat, bara Jisas ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kölöme xinabo bung nang a xinoxos möxöbo tene tinam pe Jisas ixo önan kaa, a nangadi ne lotu toxobo erabaa ma nien urungan köbo möxösö xöbo bungbung kirip. Ma abo Judeia kaluluonin idi nang tobo wöwörö me Grik, idi toxo tenge oleleng sik kidi abo Judeia re idi nang tobo wöwörö me Ibru. Ma abo Judeia nang tobo wöwörö me Grik toxo tengen bara abo möxösö re idi tekara kip nien xarnang abo möxösö re idi abo Judeia nang tobo wöwörö me Ibru. ");
INSERT INTO bjk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Io, ina sangaun ma ninöng ne aposol toxo kuwe etoxin abo tene tinam ma toxo tengen, “I karabo töxödös sö ire ra arabaa, nang bara ire tekobo pet eörin a tinörön möxö tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Io, abo töm mem, moro pere kos lo re pitnö ma ninöng ne tödi kaluluonin e mum ewe midi nang mum mo ösöxö bara idi te wöwö ma Töxödös ne Tanono arixe ma nanase. Me mem marabo bulus idi ra balaure ina tinörön na. ");
INSERT INTO bjk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Inexalik, mem iat marabo balbalan ma sineseng ma atöngösen ma tinenge re God.” ");
INSERT INTO bjk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A lasa nang idi toxo tengen ixo öaxananin a marakörö ne lotu, me idi toxo pere kos e Stiwen, a tödi i wöwö ma nunu ma Töxödös ne Tanono, arixe bölök me Pilip, Prokoras, Nikonor, Timon, Pamenas, me Nikolas meriso Entiok ewe nang kaim bara a Judeia ine, ma lamun mesila bang ixo laxa xö lotu möxöbo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Idi toxo isik ot ina pitnö ma ninöng ne duöng urungan köbo aposol, ewe nang toxo seseng ma toxo bulus abo limedi lömö ridi. ");
INSERT INTO bjk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Io, a tinenge xö God ixo wan elixilik. A xinixos möxöbo tene tinam puso Jerusalem ixo wan kaa saxit mon, ma a oleleng ne pris mee Judeia toxo ömaraxen lo abo lalaa nang abo tene tinam toxo nunu xönan. ");
INSERT INTO bjk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Io, Stiwen, a tödi niang i wöwö ma abalamu ma lölös se God, ixo pet abo lalaa deek ne auwuwus tataxin mabo auxileng lölös kaluluonin a nangadi. ");
INSERT INTO bjk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma lamun a dauleng ne tödi toxo tuu rewe xalik e Stiwen. Me idi ewe nang möxö ina gunon ne sineseng niang toxo bulus a ese bara a ‘Gunon ne sineseng möxöbo duöng niang toxoro ölanglanga idi.’ Idi abo Judeia mee Sairin ma Aleksendria ma dauleng mee Silisia ma Esia. Idi xirip toxo tuu kaa ma toxo egot me Stiwen. ");
INSERT INTO bjk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma lamun idi kaim a eöt ta babalu abo tinenge re ine, möxö a Töxödös ne Tanono ixo tabaa ine ma nanase. ");
INSERT INTO bjk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Io, idi toxo kun suxume a dauleng ne tödi rua rengrengen bere, “Mem moxoro ölangen e Stiwen ixo tengen ögarin e Moses me God.” ");
INSERT INTO bjk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Io, inabo mangana tinenge ixo öraru a balna nangadi mabo tene sisila mabo tene ausu möxöbo warkurai te Moses. Idi toxo tödik lo e Stiwen ma toxo lamus ot ine urungan kö kansel. ");
INSERT INTO bjk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Io, idi toxo lamus ölaxa a dauleng ne tödi rua töxö tinenge sik lamun ine bara, “Ina tödi na i kara mut ta rengrengen ögarin ina madakdak ne gunon lotu raxin mabo warkurai te Moses. ");
INSERT INTO bjk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mem moxo ölangen ine ixo tengen bara ina Jisas mee Nasaret irabo pet ögarin ina gunon lotu raxin ma irabo puxus inabo tatalien nang Moses ixo isik ösu re ire.” ");
INSERT INTO bjk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma nangadi xirip ewe nang toxo kisisik kölöme xö kansel toxo pere dik sik e Stiwen, me idi toxo pere bara mamaran tine ixo xarnang a mamaran kö angelo. ");
INSERT INTO bjk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Io, a sisila raxin möxöbo pris ixo ose e Stiwen, “A lak turunon abo tinenge na?” ");
INSERT INTO bjk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiwen ixo balu bira, “Abo töke mabo tamake, moro ölangen e! A mariris se God ixo ot pösöt a tamana ire, e Abaram, niang ixo xisixis bang ni Mesopotemia ma mesila ixo xisixis suso Aran. ");
INSERT INTO bjk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Me God ixo tengen te ine, ‘Örö wan pes kalik a lagunon te nöngön ma a nangadi re nöngön, ma örö wan urungan kö xönö pu nang e rabo osen te nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Io, ine ixo wan lie a xönö pu möxöbo Kaldian ma ixo kis Aran. Melamu xö minet te tamana, God ixo tile ine urungan kina xönö pu nang nixinen mum mo xisixis im könan. ");
INSERT INTO bjk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God i kobo tabaa runin e Abaram mere xönö bara rö ine iat, kaim tunon te xönö pu iat te ine. Kalik mon bara kaim e Abaram mere barok ke ine iat kina axana bung niang, e God ixo kubus bara ine arixe mabo tubuno melamu re ine, idi tabo unan sik im ina pu niang. ");
INSERT INTO bjk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God ixo tengen tö ine bira, ‘Abo tubum tabo kis osee xö lagunon nang kaim bara re idi iat, ma nangadi meringan tabo tile nanin idi xöbo tinörön ma tabo pet ögat idi xö nit ne mar ne awat.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Me God ixo tengen, ‘Ma lamun e rabo ömokorot idi xina öxöno lagunon nang abo tubum tabo rörön tataun könan. Melamu xönan idi tabo wan su xalik a lagunon niang ma tabo lotu wösöt e xö xönö na.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Io, God ixo isik a kunubus se Abaram arixe ma tatalien möxö kuru lewene aine idi, a bung barok suxurno rua uxileng idi kölöme xina kunubus. Me Abaram ixo tata re Aisak ma ixo kuru a lewene aine Aisak kö pitnö ma narun ne bung melamu xö bung nang toxo kip ine xönan. Melamu, e Aisak ixo tata re Jekop, me Jekop ixo tata möxö sangaun ma ninöng ne sisila ne untubuno ire. ");
INSERT INTO bjk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Abo sisila ne untubuno ire, idi toxo misik ma tönö idi e Josep bere ine irabo rörön tataun to Isip, möxösa, idi toxo bala kadik sik kö ine. Ma lamun e God ixo kis arixe mine ");
INSERT INTO bjk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma ixo balaure ine xalik abo tiip kirip pe ine. God ixo tabaa e Josep ma nanase deek me God ixo eörin e Josep pua öaxanan a king mee Isip. Io, a king ixo bulus ine rua tene sisila xö ina marakörö xirip mee Isip ma bara irabo balaure xirip a könönö gunon taxin te ine bölök. ");
INSERT INTO bjk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Io, a irilöng taxin ixo ot ma ixo wan kö boxönö xirip Isip me Kenan, ma sasaxan taxin arixe ixo ot, mabo untubuno ire idi tokoxobo eöt ta susuxun te nien. ");
INSERT INTO bjk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Io, Jekop ixo ölangen bira, bara nangen a nien to Isip, ine ixo tile abo untubuno ire nang abo barok ke ine xö sisila ne nuan te idi urungan Isip. ");
INSERT INTO bjk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ma sese öninöng ne unan baling, Josep ixo tengen köbo tönö bere ine e Josep. Ma a king mee Isip ixo ösöxö xulen im a bunbunarama re Josep. ");
INSERT INTO bjk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Melamu xönan, Josep ixo tile tinenge ure tamana, nang e Jekop, ma a bung marapun kirip pe ine, idi xirip a pitnö ma ninöng ne sangaun ma pitnö. ");
INSERT INTO bjk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Io, Jekop mabo untubuno ire toxo wan su uruo Isip. Melamu im, idi toxo met ee. ");
INSERT INTO bjk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Abo töngön te idi, toxo kip öbaling uruso Sekem ma toxo bulus kölöme xina maöt niang e Abaram ixo kun kalik a bung baroxorok ke Amor tuso Sekem ma oleleng ne tuluwok saxit. ");
INSERT INTO bjk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Io, a axana bung ke God ixoro lörörö rua wewet eörin a kunubus sine rue Abaram, ma a xinixos kö nangadi re ire ringan Isip ixo wan kaa pasaxit mon. ");
INSERT INTO bjk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Io, önga king kabise, ewe niang i koxobo ösöxö runon te laa lamun e Josep, ixo ot xarnang a tene sisila ro Isip. ");
INSERT INTO bjk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ine ixo ömamang abo untubuno ire ma ixo wewet ögat idi, ma ixo ölölös idi bara tabo tewe rewe a bung barok madak nang toxo mana kip idi bara idi tabo met. ");
INSERT INTO bjk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Xina awat nang toxo kip e Moses, a barok mamaran kö wawara re God. Xö narun ne texe toxo werwere muu ine xö könönö gunon te tamana. ");
INSERT INTO bjk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Io, melamu nang toxo kip ösu ine xalik a gunon, a balik ke king mee Isip ixo pere wösöt lo ine ma ixo kip lo ine ma ixo ölön ine xarnang a barok söxöt iat te ine. ");
INSERT INTO bjk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses ixo eusu mabo nanase xirip mee Isip, me ine a tödi raxin kölöme xöbo tinenge ma xö tatalien te ine. ");
INSERT INTO bjk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nang e Moses ixo nit ne sangaun ne awat tine, ixo dödöm pa uxileng a nangadi re ine iat a bung Israel. ");
INSERT INTO bjk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ine ixo pere önga tödi mee Isip ixo wewet ögat a öng mere idi abo Israel, io, ine ixo tuu arixe mina Israel ma ixo sexomet ina Isip pua babalu ine lamun a lalaa nang ixo pet tö ina Israel. ");
INSERT INTO bjk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses ixo nunu bara a nangadi iat te ine tabo perexulen bara God ixo önan arixe mine ra öro idi, ma lamun kaim idi ra werwere xulen ina na. ");
INSERT INTO bjk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Xö bung malamu Moses ixo ot pösöt a nine Israel idu toxo erese. Ma ixo mamaa ra bulbulus a malum kaluluonin idu, io, ixo tengen, ‘Nibarok, a narön mon e mu, ruasa mu mo erse baling ke mu?’ ");
INSERT INTO bjk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ma lamun önga tödi niang ixo sese ögarin a öng kabise ixo sumen tewe e Moses ma ixo tengen, ‘Kaim pe öng ixo bulus nöngön bara örobo kure e maa! ");
INSERT INTO bjk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nöngön u mamaa ra sesexomet e xarnang u sexomet a tödi me Isip, goo?’ ");
INSERT INTO bjk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nang e Moses ixo ölangen bira, ixo ulo rup uruso Midian, ma ixo kis ee xarnang a osee, ma ixo elolo, me ine ma nine barok suxuruno ringan ee. ");
INSERT INTO bjk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Melamu xö nit ne sangaun ne awat ixoro saxit, a angelo ixo ot pösöt e Moses kö kamene ia sösöt ixo bibio kölöme xö uno iaa lik kö xönö tataun lörörö xö puot Sinai. ");
INSERT INTO bjk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ixo wuwus kina laa nang ixo pere. Ma nang ixo wan lörörö rua werwere, ixo ölangen a inöno a Orong: ");
INSERT INTO bjk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘E mon a God köbo untubum, a God te Abaram, Aisak me Jekop.’ Moses ixo dede ma binuut ma ixo kebeöt ta winara. ");
INSERT INTO bjk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Io, a Orong ixo tengen te ine, ‘Kip tewe a sandel kalik a xexem, möxö a xönö pu nang u tuu sik könan, a lak madakdak saxit. ");
INSERT INTO bjk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Turunon saxit, e xoro pere abo kinadik kö nangadi re e nang te örasen to Isip. E xoro ölangen abo ginee ridi me e re wan su ra ölanglanga idi. Miang im, e rabo tile nöngön baling uruo Isip.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ina Moses mon na ewe idi toxo kasen tewe ine arixe mina tinenge bira, ‘Kaim pe öng ixo bulus nöngön bara örobo warkurai.’ Inexalik, God iat mon ixo tile ine bara irabo warkurai, ma irabo ölanglanga idi meringan. Ma ina angelo nang ixo wösö rine xö uno iaa lik, ixo top ine. ");
INSERT INTO bjk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses ixo silien ösu idi mero Isip ma ixo pet abo auxileng lölös mabo lalaa ne auwuwus so Isip, xö Rasi Dadan, ma xö xönö tataun kö nit ne sangaun ne awat. ");
INSERT INTO bjk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ine Moses mon ewe nang ixo tengen köbo nangadi mee Israel bara, ‘God irabo tile ösu urungan te mum a önga propet xarnang e meringan kö nangadi iat te mum.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses mon a öng nang ixo kis arixe ma nangadi xirip mee Israel kö xönö tataun, ma ixo kis arixe mabo untubuno ire, ma angelo ixo tabaa ine ma tinenge ruso xö puot Sinai. Ma ixo kip lo ina tinenge nang a to i kis könan tua isik öbaling urungan tö ire. ");
INSERT INTO bjk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Xalik mon abo untubuno ire, idi toxo kaim a mamaa ra ölangen a tinenge re Moses. Kawaim arixe. Idi toxo kasen ine ma xö baladi toxo mamaa bara idi tabo baling uruo Isip. ");
INSERT INTO bjk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Idi toxo tengen te Aron, ‘Örö pet tebo perewuo re mem nang irabo silien ire, möxö ina tödi na e Moses nang ixo silien ösu ire mero Isip, mem kobo ösöxö a lasanene i ot tine!’ ");
INSERT INTO bjk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xina axana bung niang idi toxo pet a önga perewuo xarnang a bak kö bulmakau. Idi toxo erabaa urungan tine ma arabaa ridi ma toxo pet a luxa ma axanan lamun ina tinörön ne limedi. ");
INSERT INTO bjk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ma lamun God ixo tuu talu idi ma ixo ganim idi bara idi tabo lotu wösöt abo tii, a texe, ma xaken meriso lömö xö balana kubu, xarnang toxo geet ösu xö buk kö bung propet: ‘Marakörö mee Israel! Mum korobo pet tö e nang mum moxobo sesexomet abo bulmakau mabo sipsip pö mum pa wewet a arabaa urö e xö nit ne sangaun ne awat nang mum moxo kis singan kö xönö tataun. ");
INSERT INTO bjk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mum moxobo kip öxaa a walpali nang toxo pet ma man kö perewuo Molek. Me mum moxobo kip öxaa a tii perewuo xö god te mum, e Repan, idu a nine perewuo nang mum moxo pet tua lolotu wösöt. Io, arabo tile rewe e mum uruo xö lagunon melamu re Babilon.’ ");
INSERT INTO bjk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Abo untubuno ire toxo kis arixe ma walpali ne man kö xönö tataun. Ma ina walpali na ixo osen bara God ixo kis arixe me idi. Toxo pet xarnang e God ixoro pet osen te Moses, ma i eöt ma winawara nang Moses ixo pere bie. ");
INSERT INTO bjk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Io melamu, abo untubuno ire toxo kip lo ina gunon ne man meriso xöbo tamadi. Me idi toxo kip arixin me idi nang toxo arixe me Josua. Idi toxo wan ta xikip lo ina pu möxöbo duöng kabise nang God ixo tile rewe xalik idi. Ma ixo kis singan ot kö axana bung ke Dewit. ");
INSERT INTO bjk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Me Dewit ixo örasen a abalamu re God ma ixo ose e God bara irabo ömaraxen ine rua wewet te gunon ure God te Jekop. ");
INSERT INTO bjk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma lamun e Solomon im iang ixo uru a gunon kö God. ");
INSERT INTO bjk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ma lamun, a Orong lömö saxit i kara kis kö gunon nang a tödi mon i pet. Xarnang a propet i tengen: ");
INSERT INTO bjk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Orong ixo tengen, “Watmaep, ine a kinis ne king ke e, ma öxöno lagunon, ine a xönö tinuu möxö xexeke. A mangana gunon sa mum morobo uru urö e? Ma a xönö sa irabo eöt bara e rabo mamas könan? ");
INSERT INTO bjk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","E iat e xo pet abo lalaa na ma limeke.” ’” ");
INSERT INTO bjk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Me Stiwen ixo tengen bölök bira, “Mum abo onwat! Abo bala mum i wöwö ma xödxödö! Mabo talinge mum a lak baa ma i kebeöt ta ölangen a tinenge re God! Mum mo xarnang mon abo untubuno mum. Mum bo kara ölengen a Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ewe rebo propet mesila nang abo untubuno mum idi kaim a ögarin? Kaim! Idi toxo sexomet abo tödi mesila nang toxo rengrengen ösila a inot kö Tene Töxödös. Ma na mum moxoro isik ine xö limine a nangadi saban ma toxo sexomet ine. ");
INSERT INTO bjk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mum nang moxo ömaraxen lo a warkurai te God kalik abo angelo, inexalik mum kobo muu xönan.” ");
INSERT INTO bjk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Io, nang abo kansel toxo ölangen bira, idi toxo laie saban ma toxo engingirenin abo ngisedi. ");
INSERT INTO bjk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma inexalik bere Stiwen ixo wöwö sik ma Töxödös ne Tanono ma ixo wawara kaa uruso lömö xö balana kubu ma ixo pere a mariris se God, ma ixo pere e Jisas ixo tuu sik kö lime tuun te God. ");
INSERT INTO bjk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Me Stiwen ixo tengen, “Mum moro pere! E pere a balana kubu i tamasawang ma a Barok kö Tödi i tuu sik kö lime tuun te God.” ");
INSERT INTO bjk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Io, idi toxo kup taxin uruso lömö ma toxo sing pi abo talingedi me idi xirip toxo ulo ot sik ine, ");
INSERT INTO bjk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ma toxo sat ösu ine xalik a lagunon taxin ma toxo urulo ra reteng ine ma warawat. Me idi nang toxo wupuk ine, idi toxo bulus abo man te idi xö xexene ina guama a esene e Sol. ");
INSERT INTO bjk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nang idi toxo reteng ine, Stiwen ixo seseng uruso re God bira, “Jisas, a Orong, örö kip lo a tanoke!” ");
INSERT INTO bjk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Io, ixo subun kexe ma ixo gee wösö raxin arixe, “Orong, u bele döxömen lo abo magingin saban te idi. Ganim, örö döxömen taun!” Io, nang ine ixo tengen bira, ixo met. ");
INSERT INTO bjk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Io, e Sol ixo aut arixe midi nang toxo teng ömet e Stiwen. Xina bung nang toxo sexomet e Stiwen, idi toxo urulo ra wewet ögarin a marakörö möxö lotu ro Jerusalem. Ma a nangadi möxö lotu toxo ulo elixilik kö boxönö xirip mee Judeia me Samaria. Abo aposol kalik mon toxo xisixis siso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mabo nangadi nang toxo ii e God, idi toxo pömös e Stiwen ma toxo gee rö ine. ");
INSERT INTO bjk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma lamun e Sol ixo urulo ra wewet ögarin a lotu. Ine ixo su ma laxa xöbo oleleng ne gunon te idi, ma ixo sasat ösu lo a körö ma balixilik ma ixo ölaxa idi xö gunon ne aömokorot. ");
INSERT INTO bjk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Io, ewe midi nang toxo ulo elixilik nana, idi toxo palas tinenge xö boxönö xirip nang idi toxo önan nana xönan. ");
INSERT INTO bjk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip ixo wan su xö önga lagunon taxin kölöme Samaria ma ixo tengen osen a Mesaia rö idi. ");
INSERT INTO bjk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ma nang a marakörö raxin toxo ölangen e Pilip ma toxo pere abo auxileng ne auwuwus nang ine ixo pet, idi xirip toxo ölöngö sik kalik lamun a tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Arixe ma ginee lölös, abo tano saban toxo wan su xalik a oleleng, ma oleleng ne pengpeng mabo xexe met, idi toxo deek baling. ");
INSERT INTO bjk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Io, a axanan taxin ixo ot pösöt ina marakörö möxö ina lagunon taxin niang. ");
INSERT INTO bjk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Io, xina lagunon niang a önga tödi, a esene e Saimon, a sewuk ine. Ma ixobo öngangao idi a nangadi mee Samaria mabo pet laa ne auwuwus nang ixobo wewet. Ma ixobo wewet öraxin ine, ");
INSERT INTO bjk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ma nangadi xirip, a bung orong ma bung maris, idi xirip toxo lölös sik ka ölangen ine me idi toxo tengen, “Ina tödi na, ine ma lölös meriso re God nang a nangadi te rengrengen bara a lölös taxin.” ");
INSERT INTO bjk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Idi toxo mumuu ine, möxösa, ine ixo öngangao idi mabo mangana pet laa ne auwuwus ixo wewet bang iat tö idi me idi toxo axanan ulamun. ");
INSERT INTO bjk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma lamun kö bung nang e Pilip ixo palas tinenge ma tinenge deek lamun a kingdom kö God ma esene Jisas Krais, idi toxo nunu, ma a körö ma balixilik idi toxo kip baptais. ");
INSERT INTO bjk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon iat bölök ixo nunu ma ixo kip baptais. Ma ixo mumuu e Pilip kö boxönö xirip, ma ixo wuwus saban köbo mangana auxileng lölös ne auwuwus nang ine ixo pere. ");
INSERT INTO bjk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nang abo aposol mee Jerusalem toxo ölangen bara abo Samaria toxo ömaraxen lo a tinenge xö God, idi toxo tile e Pita me Jon urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nang idu toxo ot, idu toxo seseng ke idi bara idi tabo oxe lo a Töxödös ne Tanono, ");
INSERT INTO bjk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","möxösa, a Töxödös ne Tanono kaim bang ka nuan su xö dauleng ke idi, inexalik mon idi toxo kip baptais kö esene Jisas, a Orong. ");
INSERT INTO bjk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Io, Pita me Jon toxo bulus abo limedu lömö re idi, me idi toxo oxe lo a Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nang e Saimon ixo pere bara a Tanono ixoro wanot te idi nang a nine aposol toxo bulus abo limedu lömö re idi, io, ine ixo mamaa rua tabaa idu ma tuluwok, ");
INSERT INTO bjk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ma ixo tengen, “Muu moro tabaa bölök e mina lölös niang lamun nang bara ewe nang arabo bulus lime lömö re idi, tabo oxe lo a Töxödös ne Tanono.” ");
INSERT INTO bjk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Io, Pita ixo balu ine bira, “I deek bara örobo iuo arixe ma tuluwok ke nöngön, möxösa, u xo döxömen bara örobo kun a arabaa re God ma tuluwok! ");
INSERT INTO bjk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kaim nöngön mere xönö xina tinörön na, möxö a balam i kobo töxödös sik kö wawara re God. ");
INSERT INTO bjk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Io, örö dödöm puxus köbo magingin saban na ma örö seseng uruso xö Orong. Ine irabo döxömen tewe gut abo mangana dinödöm nang i orot kö to re nöngön. ");
INSERT INTO bjk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","E tengen bira, möxö e pere bara u wöwö ma bala kinadik ma magingin saban i kubus pi nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Io, Saimon ixo balu bira, “E mu moro seseng urungan kö Orong urö e, ma lamun kaim pe laa nang mu moro tengen irabo ot pösöt e.” ");
INSERT INTO bjk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Io, nang Pita me Jon toxoro tenge ma tinenge xö Orong ma toxoro tengen osen ina turunon te ine, idu toxo baling uruso Jerusalem, me idu toxo palas tinenge ma atöngösen deek köbo oleleng ne lagunon mee Samaria. ");
INSERT INTO bjk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Io, önga angelo xö Orong ixo tengen te Pilip, “Taru ma örö muu a ngas kaluluon kö xönö tataun nang i wan su meriso Jerusalem uri Gasa.” ");
INSERT INTO bjk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Io, e Pilip ixo wan lo, ma xö nuan te ine ixo esuo ma önga tödi mee Itiopia, me ine a tödi raxin möxö werwere muu abo tuluwok möxö Kadasi, a une sisila möxö nangadi mee Itiopia. Ina tödi na, mesila ixo wan uruso Jerusalem pa lotu xö lotu xöbo Judeia, ");
INSERT INTO bjk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ma na xö nuan te ine uri baling lagunon ixo kis kölöme sik kö karis ma ixo xokos nanin a buk ke propet Aisaia. ");
INSERT INTO bjk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Tanono ixo tengen te Pilip, “Wan urungan kö karis ma örö wan lörörö xönan.” ");
INSERT INTO bjk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Io, e Pilip ixo ulo kaa urungan kö karis ma ixo ölangen a tödi nang ixo xokos a buk ke propet Aisaia. Me Pilip ixo ose ine bira, “Nöngön u ösöxö sik a lasa nang u xokos?” ");
INSERT INTO bjk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","A tödi nang ixo balu ine bira, “Me e rabo ösöxö bule nang mon bara re öng irabo ömaras sik kö e?” Io, ine ixo seng e Pilip pa kinaa ma ra kinis arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ina xönö tinenge nang ixo xokos i bira, “Toxo lamus ine xarnang a sipsip nang tobo lamus sua sesexomet. Ma xarnang a bak kö sipsip nang ibo tuu ödödö ra xörxöröp a bebene, io, ine kaim kö rengrengen te xönö tinenge. ");
INSERT INTO bjk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Idi toxo ömenge ine ma kaim kö wewet ötöxödös se warkurai rö ine. I kebeöt te öng ka warwara abo lalaa lamun abo bung baroxorok malamu, möxösa, toxoro kip tewe a to re ine mera xö öxöno lagunon.” ");
INSERT INTO bjk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Io, ina orong ixo ose e Pilip, “Tengen te e, ewenene ina propet niang i etöngösen min, ine iat bara re öng kabise?” ");
INSERT INTO bjk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Io, e Pilip ixo urulo arixin mina tinenge niang ma ixo töngösen ine ma tinenge deek lamun e Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Nang idu toxo önan kö ngas, idu toxo wanot kö xönö ari ma ina orong ixo tengen, “Pere bang! A ari ia. A sanene i tuu wi e me e karabo kip baptais?” ");
INSERT INTO bjk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ma ina orong ixo tengen kö tödi nang ibo waswasak a karis bara ira tuu bang. Io, idu xirip toxo wan su urungan kö könönö ari me Pilip ixo baptais ine. ");
INSERT INTO bjk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Io, nang idu toxo wan kaa xalik a ari, a Tanono Orong ixo kip lo e Pilip, ma ina tödi kaim kö werwere öbaling ine. Ma lamun ine ixo urulo öbaling lo a nuan te ine ma axanan. ");
INSERT INTO bjk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Me Pilip bölök ixo ot wösö Asdot, ma nang ixo wan nana ixo palas tinenge ma atöngösen deek kö boxönö xirip ot nang ixo wanot ti Kaisaria. ");
INSERT INTO bjk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Xina axana bung e Sol angen ixo rengrenge lölös bara ra sesexomet abo tene tinam kö Orong. Me ine ixo wan urungan kö sisila raxin möxöbo pris ");
INSERT INTO bjk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ixo ose ine bara ira geet te pas uruo xöbo gunon ne sineseng köbo Judeia ro Damaskas. Io, kölöme xinabo pas i tenge maras sue Sol bira, nang bere Sol i esuo mere öng ke idi, re körö bara re balixilik, niang ibo laxa xö lotu niang tobo tengen ine ma ‘Ngas kö Orong’, io, irabo öt tua öxös idi ma ra lalamus idi uruso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nang e Sol ixo önan ot lörörö Damaskas, a önga bibio meriso lömö ixo siek elulurein ine. ");
INSERT INTO bjk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ine ixo subu su xö pu ma ixo ölangen a inöno önga tödi ixo tengen tö ine, “Sol! Sol! Ruasa nöngön u ögarin e?” ");
INSERT INTO bjk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol ixo ose, “Ewe nöngön, Orong?” Me ine ixo balu, “E Jisas, ewe nang nöngön u ögarin.” ");
INSERT INTO bjk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Örö taru kaa ma örö wan laxa xö lagunon taxin, ma tabo töngösen nöngön ma lasa nang örobo pet.” ");
INSERT INTO bjk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A duöng nang toxo wan arixe me Sol toxo tuu ödödö ma kaim pe tinenge. Idi toxo ölangen a ingana tinenge inexalik kaim kö werwere re tödi. ");
INSERT INTO bjk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ixo taru kaa meringan kö pu, ma lamun nang ixo öwalas a marana, kaim ine xo werwere re laa. Io, idi toxo tön a limine ma toxo silien ine uri Damaskas. ");
INSERT INTO bjk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Xö narun ne bung ine ixo pulo, ma kaim ine xo nien ma ininim. ");
INSERT INTO bjk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ruso Damaskas nangen a önga tene tinam pe Jisas a esene e Ananias. A Orong ixo kuwe ine xö wöpönöbö, “Ananias!” Ine ixo balu, “Orong, e ia!” ");
INSERT INTO bjk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Io, a Orong ixo tengen te ine, “Wan uruso xö gunon te Judas nuso xö ngas tobo rengrengen ma Ngas Töxödös ma örö ose lamun a tödi mee Tasas, a esene e Sol, ma i nangen i seseseng. ");
INSERT INTO bjk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kölöme xö wöpönöbö ine ixoro pere bara önga tödi, a esene e Ananias, i ot ma i bulus a limine ine lömö rine bara irabo wawara baling.” ");
INSERT INTO bjk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias ixo balu, “Orong, e xoro ölangen a oleleng ne tinenge lamun ina tödi na ma bara ixo wewet ögat a nangadi re nöngön iat tuso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Me ine ixoro kip lo a lölös meriso xöbo pris tataxin tua öxös kirip ewe midi nang tobo lolotu wösöt nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lamun a Orong ixo tengen te Ananias, “Örö wan, möxösa, e xoro pere kos ine xarnang a tene tinörön nang irabo wöwörö ma eseke urungan kö nangadi nang kaim bara abo Judeia, ma urungan köbo sisila raxin ma xö nangadi mee Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","E rabo osen ine mabo mangana kinadik ma tiip nang ine irabo mana örasen kö eseke.” ");
INSERT INTO bjk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Io, Ananias ixo wan ma ixo laxa xö gunon. Ixo bulus a nine limine lömö re Sol ma ixo tengen, “Tönö Sol, a Orong ixo tile e. Me ine mon e Jisas nang ixo ot pösöt nöngön kö ngas nang u xo önan ura. Ma i tile e bara örobo wawara baling ma örobo wöwö ma Töxödös ne Tanono.” ");
INSERT INTO bjk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Saxit mon, önga laa xarnang a ölangine en ixo subu xalik a marana e Sol me ine ixo wawara baling. Io, ine ixo taru ma ixo kip a baptais, ");
INSERT INTO bjk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ma melamu nang ixoro an, ma ixo kip öbaling a lölös se ine. Sol ixo kis arixe mabo tene tinam pe Jisas suso Damaskas kö dauleng ne bung. ");
INSERT INTO bjk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Io, saxit iat mon, ixo palas tinenge kölöme xöbo gunon ne sineseng möxöbo Judeia bara Jisas a Barok kö God. ");
INSERT INTO bjk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Me idi xirip nang toxo ölangen ine, toxo wuwus ma toxo eose, “Ire te ösöxö bara ruso Jerusalem, ine mon a tödi nang ibo ögarin idi nang tobo lolotu wösöt e Jisas. Bule ine i ot ta rua rörön dik a nangadi bara öxös idi ma lamus idi wösöt abo pris tataxin?” ");
INSERT INTO bjk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Inexalik a atöngösen maras se Sol ixo ot lölös. Ma abo Judeia ruso Damaskas idi kaim kö eöt ta babalu ine, möxösa, ine ixo öturunon te idi bara Jisas ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Io, melamu xö oleleng ne bung ixoro saxit, abo Judeia toxo ot arixe ma toxo pingit tua sesexomet e Sol. ");
INSERT INTO bjk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lamun e Sol ixoro ösöxö a pingit te idi. Xö xaken ma dömön idi tobo öman abo marna ngas möxö tabörö möxö ina lagunon tua sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lamun abo bak ne ausu re Sol, toxo kip lo ine xö dömön, ma toxo ösölöng ösu ine xö kölöt kö mara xö bölö uri lawu. ");
INSERT INTO bjk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nang ine ixo ot tuso Jerusalem, ine ixo mamaa bara rua kinis arixe mabo tene tinam pe Jisas, inexalik kaim idi ra nunu runon te ine bara ine a tene tinam pe Jisas, me idi toxo buburin ine. ");
INSERT INTO bjk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma lamun e Banabas ixo lamus ot ine urungan köbo aposol. Ine ixo töngösen ömaras idi xö nuan te Sol bere ine ixoro pere a Orong kö ngas ma bara a Orong ixoro etöngösen me ine, ma nang ine ixo kis Damaskas ine ixo palas tinenge ma esene Jisas, ma kaim ine xo binuut. ");
INSERT INTO bjk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Io, Sol ixo kis arixe me idi ma ixo wan nana xö boxönö xirip kölöme Jerusalem, ma ixo palas tinenge xö esene Jisas ma kaim ine ra binuut. ");
INSERT INTO bjk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ine ixo tenge ma ixo egot arixe mabo Judeia nang tobo rengrenge me Grik. Ma lamun idi toxo mamaa bara ra sesexomet ine. ");
INSERT INTO bjk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nang abo Kristien toxo ösöxö lo ina na, idi toxo lamus ösu e Sol uri Kaisaria ma toxo tile rewe ine uruso Tasas. ");
INSERT INTO bjk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Io, abo tene lotu xirip kölöme Judeia, Galili me Samaria toxo axanan ma toxo kis ma malum. Me idi toxo kip lo a rorop möxö Töxödös ne Tanono ma ixo ölölös idi, ma a xinixos möxö nangadi kölöme xö lotu ixo wan kaa, möxösa, idi toxobo ii öraxin a Orong. ");
INSERT INTO bjk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nang e Pita ixo wan nana xö boxönö xirip, ine ixo wan ta uxileng a nangadi re God nang toxo xisixis kölöme Lidda. ");
INSERT INTO bjk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ruso ixo ot pösöt a tödi a esene e Enias, a pengpeng ewe nang ixoro maru xö pitnö ma narun ne awat kö öra. ");
INSERT INTO bjk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita ixo tengen te ine, “Enias, Jisas Krais i öro nöngön. Taru ma örö luxun ödeek lo a minaru re nöngön.” Saxit mon Enias ixo taru kaa. ");
INSERT INTO bjk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A nangadi xirip ewenene nang toxo xisixis kölöme Lidda me Seron, toxo pere ine ma toxo tawuxus urungan kö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kölöme Jopa nangen a önga tene tinam pe Jisas, a esene e Tabita (nang a ese me Grik e Dokas), nang ixobo wewet abo tinörön deek ma ixobo rorop a nangadi tanaa. ");
INSERT INTO bjk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Xina bung niang, ine ixo meset ma ixo met, ma toxo tos a aine ma toxo bulus ine kölöme xö xönö ruso lömö xö gunon. ");
INSERT INTO bjk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda ixo lörörö sik Jopa. Io, nang abo tene tinam toxo ölangen bere Pita nangen nang Lidda, idi toxo tile a nine tödi urungan te ine ma tinenge, “Maris, miang pasaxit mon ura re mem!” ");
INSERT INTO bjk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita ixo wan arixe me idu, ma nang idiet toxo ot, ine ixo wan kaa uruso lömö xö ina xönö. Abo möxösö toxo tuu wi ine, toxo gegee ma toxo osen ine mabo mangana man nang e Dokas ixobo söxsöxö nang bang ixo to sik. ");
INSERT INTO bjk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita ixo tile ösu xirip idi, io, ixo subun kexe ma ixo seseng. Ine ixo tawuxus urungan kö une minet, ma ixo tengen, “Tabita, taru kaa.” Ine ixo öwalas a nine marana ma ixo pere e Pita, me ine ixo kis kaa. ");
INSERT INTO bjk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ixo tön öraru ine ma limine ma ixo top ine ra tinuu. Io, ine ixo kuwe a nangadi re God ma abo möxösö ma ixo isik osen ine re idi bara ine iri to. ");
INSERT INTO bjk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A winörö möxö ina na ixo ot pösöt kirip a boxönö mee Jopa ma oleleng ne nangadi toxo nunu kölöme xö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Io, Pita ixo kis Jopa xö dauleng ne bung arixe ma tene wewet lalaa ma lewene bulmakau, a esene iang e Saimon. ");
INSERT INTO bjk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nangen a önga tödi ixobo xisixis si Kaisaria, a esene e Konilias, ine a sisila ne umri möxö önga muxu ne umri nang tobo rengrengen ine bara mee Itali. ");
INSERT INTO bjk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ine arixe ma baninen te ine toxobo mumuu e God ma toxobo ii öraxin e God, me ine ixobo rorop a nangadi sasaxan ma ixobo seseseng uruso xö God köbo bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Xö önga bung kö narun ne axana bung kö aien, Konilias ixo pere a önga winawara. Ine ixo pere a angelo re God, ixo ot pösöt ine ma ixo tengen, “Konilias.” ");
INSERT INTO bjk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias ixo pere dik sik a angelo ma binuut ma ixo eose, “Lasanene, Orong?” A angelo ixo balu ine, “Abo sineseng mabo arabaa re nöngön urungan kö nangadi maris iri xarnang a arabaa uruso re God. ");
INSERT INTO bjk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na örö uguran te dauleng ne tödi uruo Jopa rua lalamus ot a önga tödi, tobo rengrengen ine me Saimon, önga esene bölök e Pita. ");
INSERT INTO bjk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ine ixobo xisixis kö gunon te Saimon, a tene wewet lalaa ma lewene bulmakau, ewe nang ixobo xisixis lörörö xö rasi.” ");
INSERT INTO bjk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nang a angelo ixoro wöwörö sik kö ine ixo wan lie ine, Konilias ixo kuwe a nine tödi tinörön te ine ma önga umri deek nang ibo mumuu e God, me ine a öng mere idi ewe nang toxobo rorop e Konilias. ");
INSERT INTO bjk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ine ixo tengen kirip abo lalaa nang ixoro ot te ine ma ixo tile idiet uruo Jopa. ");
INSERT INTO bjk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Xö bung melamu nang idiet toxoro lörörö Jopa, Pita ixo wan kaa uruso lömö xö öxöno gunon kö luono xaken ta sineseng. ");
INSERT INTO bjk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ine ixo irilöng ma ixo mamaa bara ira en te nien. Ma nang idi angen toxo tagure a nien, Pita ixo pere a winawara. ");
INSERT INTO bjk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ine ixo pere a balana kubu ixo tamasawang, ma önga laa ixo wan su, ixo wawara xarnang a xönö man taxin, toxo tön ösu xö nit ne ngusuno ura xö öxöno lagunon. ");
INSERT INTO bjk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kölöme xönan, abo mangana wawaguai nang idi ma nit ne xexedi, mabo si mabo mangana wawaguai nang tobo xaxabo, mabo pun axe. ");
INSERT INTO bjk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Io, a inöno önga tödi ixo tengen te ine bira, “Pita, taru kaa. Örö sexomet ma örö en.” ");
INSERT INTO bjk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma lamun e Pita ixo balu, “Kaim tunon arixe, Orong! E kala ösöxö bara ara en te laa nang abo warkurai te nöngön ixo panak e mem pua enen.” ");
INSERT INTO bjk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A inöno ina tödi ixo tengen öbaling kö ine, “Ganim a wanwanak ke laa nang e God ixoro ömaraxen.” ");
INSERT INTO bjk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ina laa na ixo wösö xö narun ne axan, ma saxit mon toxo sat öxaa ina xönö man baling uruso xö balana kubu. ");
INSERT INTO bjk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nang e Pita ixo dödödöm lamun a unine ina winawara, narun ne tödi nang e Konilias ixo tile idiet, idiet toxo pere wösöt a xönö nang a gunon te Saimon ee ma toxo tuu dik kö marame laxlaxa. ");
INSERT INTO bjk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Idiet toxo kup ma toxo eose bere Saimon ewe nang tobo rengrengen ine me Pita ixobo xisixis sa bara kaim. ");
INSERT INTO bjk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nang e Pita angen ixo dödödöm lamun ina winawara, a Töxödös ne Tanono ixo tengen te ine bira, “Saimon, a narun ne tödi te wawara siwin nöngön. ");
INSERT INTO bjk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Göm, örö taru ma örö wan su. Ganim a dinödöm oleleng ka nuan arixe me idiet, möxö e xo tile idiet.” ");
INSERT INTO bjk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita ixo wan su ma ixo tengen te idiet, “E mon ina tödi na nang muot mo wawara siwin. Muot mo wanot tö sa?” ");
INSERT INTO bjk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Idiet toxo balu, “A umri raxin e Konilias i tile e meet. Ine a tödi töxödös ma ibo buburin e God. Ma nangadi xirip mee Judeia tobo ii ine. A madakdak ne angelo ixo tengen te ine bara irabo lamus ot nöngön uri xö gunon te ine, io nang ine irabo ölangen a lasanene nang u ka rengrengen.” ");
INSERT INTO bjk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Io, Pita ixo lamus ölaxa idiet uruso xö gunon te ine xarnang abo osee. Xö bung kabise, Pita ixo wan arixe me idiet, ma dauleng ne Kristien meri Jopa toxo wan bölök arixe me idi. ");
INSERT INTO bjk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Xö bung melamu ine ixo ot ti Kaisaria. Konilias ixo xixiset me idi ma ixoro kuwe lo etoxin bölök a bung marapun te ine mabo ais tunon te ine. ");
INSERT INTO bjk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nang e Pita ixo laxa xö gunon, Konilias ixo wan suo ine ma ixo tunsu mesila ne ine, ma ixo ii ine. ");
INSERT INTO bjk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma lamun e Pita ixo tön öraru ine ma ixo tengen te ine, “Tuu kaa. E bölök mon a tödi xarnang nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ixo rengrenge me Konilias ma ixo önan laxa, ma ixo pere bara a nangadi oleleng toxoro ot etok. ");
INSERT INTO bjk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Io, ine ixo tengen te idi, “Mum mo ösöxö ödeek sik bara xö warkurai xöbo Judeia, i kebeöt bara re öng mere mem irabo uxileng bara rua kinis arixe mabo nangadi xarna na nang kaim bara abo Judeia. Ma lamun e God ixoro osen e bara ganim e rua wanwanak ke tödi rua kinis etok arixe me mem abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Io niang, nang mum moxo erile rö e, kaim e ra mölmölök ka nuanot. Io, eka ose mum bara ruasa runon iat mum mo erile rö e?” ");
INSERT INTO bjk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias ixo balu ine bira, “Nit ne bung ixoro saxit, e xo seseseng kölöme xö gunon te e xö narun ne axana bung kö aien xanana. Saxit mon önga tödi ixo sige sik a man sisiek ma ixo tuu mesilain e, ");
INSERT INTO bjk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ixo tengen, ‘Konilias, God ixoro ölangen abo sineseng ke nöngön ma i döxömen lo abo arabaa re nöngön urungan köbo maris. ");
INSERT INTO bjk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Io, erile uruo Jopa rue Saimon nang tobo rengrengen ine me Pita. Ine ixobo xisixis kö gunon te Saimon a tene wewet laa ma lewene bulmakau, nang ixobo xisixis lörörö xö rasi.’ ");
INSERT INTO bjk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Io, saxit iat mon e xo erile rö nöngön bara örö tam pe e, ma u pet a tatalien deek bara u wanot. Ma na mem kirip kö wawara re God me xixiset tua ölangen abo tinenge xirip nang a Orong i tengen te nöngön bara örobo töngösen e mem min.” ");
INSERT INTO bjk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Io, Pita ixo urulo ra tinenge, “Na e re perexulen bara i turunon bere God i kara top kalik önga lawa ma ganim önga dauleng kabise. ");
INSERT INTO bjk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma lamun ibo öbala lo a nangadi möxö boxönö xirip nang tobo ii ine ma tobo wewet a lasa nang i töxödös. ");
INSERT INTO bjk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mum mo ösöxö bara God ixo tile a tinenge rua nangadi mee Israel, a tinenge deek möxö malum kölöme re Jisas Krais, ewe a Orong kö nangadi xirip. ");
INSERT INTO bjk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mum mo ösöxö a lasa ixo ot kö boxönö xirip mee Judeia, urulo Galili melamu xö baptais nang e Jon ixo etöngösen maras min. ");
INSERT INTO bjk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Me mum mo maras lamun e Jisas mee Nasaret nang e God ixo tulus lo ine, ma ixo tabaa ine ma Töxödös ne Tanono ma lölös ma nang ine ixo wan nana xö boxönö xirip, ixo wewet a tinörön deek ma ixo ölanglanga idi nang toxo kis kölöme xö lölös se Satan, möxösa, e God ixo kis arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Mem moxo pere abo mangana lalaa xirip nang ine ixo pet kölöme xö lagunon möxöbo Judeia ma kölöme Jerusalem. Io, mem me tengen ösu bara inabo lalaa i turunon. Idi toxo sexomet ine nang toxo taba ine xö sölöxöröp. ");
INSERT INTO bjk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma lamun e God ixo öraru ine xalik a minet kö narun ne bung ma ixo ömaraxen lo a nangadi ra werwere ine. ");
INSERT INTO bjk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ma kaim bara nangadi xirip toxo pere ine, ma lamun mem mon nang e God ixoro pere kos lo e mem bara mem marabo tengen ömaras a turunon lamun ine. Ma melamu xö tinaru baling ke ine xalik a minet, mem moxo an ma moxo inim arixe me ine. ");
INSERT INTO bjk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Me ine ixo isik a tinenge lölös se mem rua töngösen ömaras a nangadi ma ra rengrengen bere ine ina tödi ewe nang God ixo bulus ine bara irabo pet warkurai te idi nang te to ma nang te met. ");
INSERT INTO bjk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abo propet toxo etöngösen maras lamun ine bara kölöme xö esene, God irabo döxömen taun abo magingin saban te idi nang te nunu re ine.” ");
INSERT INTO bjk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nang bang e Pita angen ixo wöwörö mina tinenge na, a Töxödös ne Tanono ixo wan su urungan te idi xirip nang toxo ölangen ina tinenge. ");
INSERT INTO bjk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Mabo tene nunu mee Judeia ewe nang toxo wanot mee Jopa arixe me Pita, toxo wuwus lamun a arabaa möxö Töxödös ne Tanono nang e God ixo tile ösu urungan bölök ke idi a nangadi nang kaim bara abo Judeia, möxösa, idi toxo ölangen idi toxo wöwörö mabo mangana tinenge xabise ma toxo ölet e God. Io, Pita ixo tengen, ");
INSERT INTO bjk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“I kebeöt bara re tödi irabo panak idi rua kip baptais ma ari möxö idi tere kip a Töxödös ne Tanono xarnang mon ire.” ");
INSERT INTO bjk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Io, ine ixo tengen te idi, “Mum moro kip baptais iat kö esene Jisas Krais.” Io, idi toxo seng e Pita ra kinis bang me idi xö uleng ne bung. ");
INSERT INTO bjk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abo aposol mabo Kristien nang toxo xisixis nana xö boxönö xirip mee Judeia toxoro ölangen bara a nangadi nang kaim bara abo Judeia bölök tere kip lo a tinenge xö God ma nunu. ");
INSERT INTO bjk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Io, nang e Pita ixo wan kaa uruso Jerusalem, abo tene nunu mee Judeia toxo tewe tinenge saban tö ine, ");
INSERT INTO bjk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ma toxo tengen bira, “Nöngön u wan laxa xö gunon möxö nangadi nang kaim bara abo Judeia ma u xo an arixe me idi.” ");
INSERT INTO bjk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Io, Pita ixo urulo a winörö re ine ma ixo tengen ömaras idi mabo laa xirip nang ixo ot te ine. ");
INSERT INTO bjk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ma ixo tengen bira, “E xo xisixis si xö lagunon taxin Jopa ma kölöme xö önga wöpönöbö e xo pere önga winawara. E xo pere a önga laa xarnang a xönö man ma lak taxin toxo ömalus ösu meriso xö balana kubu xöbo nit ne ngusuno, ma ixo wan su ura re e. ");
INSERT INTO bjk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","E xo wawara laxa me e xo pere abo mangana wawaguai ma nit ne xexedi angen nang tobo ölasan, arixe mabo wawaguai axe, ma si, mabo wawaguai tobo xaxabo, mabo pun axe. ");
INSERT INTO bjk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Io, e xo ölangen a inöno önga tödi ixo tengen te e bira, ‘Taru kaa, Pita. Örö sexomet ma örö en.’ ");
INSERT INTO bjk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“E xo balu bira, ‘Kaim tunon arixe, Orong! E kala ösöxö bara ara en te laa nang abo warkurai te nöngön ixo panak e mem pua enen.’ ");
INSERT INTO bjk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“A inöno önga tödi ixo wöwörö baling ke e meriso xö balana kubu, ‘Ganim pa wanwanak ke laa nang e God ixoro ömaraxen.’ ");
INSERT INTO bjk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ma ina laa na ixo wösö xö narun ne axan, ma saxit mon toxo sat öxaa öbaling ine uruso xö balana kubu. ");
INSERT INTO bjk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Xö ina axana bung iat mon ina narun ne tödi nang toxo tile ura re e meri Kaisaria toxo ot kö gunon nang e xobo xisixis könan. ");
INSERT INTO bjk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A Tanono ixo tengen te e bira, ‘Nöngön u bele dödödöm oleleng ma örö wan arixe me idi.’ Ina pitnö ma öng ne tönö e na toxo wan arixe bölök me e, me mem moxo laxa xö gunon te Konilias. ");
INSERT INTO bjk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Me ine ixo tengen te mem bara ixoro pere önga angelo ixo ot pösöt ine kölöme xö gunon te ine ma ixo tengen, ‘Erile u Jopa rue Saimon nang tobo rengrengen ine me Pita. ");
INSERT INTO bjk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Me ine irabo tengen abo tinenge re nöngön nang nöngön arixe mabo nangadi xirip kö gunon te nöngön, mum morobo uruoxe a to turunon.’ ");
INSERT INTO bjk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Nang e xo urulo ra tinenge, a Töxödös ne Tanono ixo wan su sik ke idi xarnang ixo wan su sik ke ire xö urulo. ");
INSERT INTO bjk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Io, e xo döxömen lo a lasa nang a Orong ixo tengen, ‘Jon ixo baptais ma ari, ma lamun mum morobo kip baptais ma Töxödös ne Tanono.’ ");
INSERT INTO bjk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Io, nang bere God ixo tabaa idi ma arabaa xarnang ixo tabaa ire nang toxo nunu re Jisas Krais, a Orong, io, ewenene runon e rua tinuu wi e God?” ");
INSERT INTO bjk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nang idi toxo ölangen bira, idi toxo ödödö ma toxo ölet e God, ma toxo rengrengen, “Io, i turunon sik bere God i tabaa bölök a nangadi nang kaim bara abo Judeia rua dinödöm puxus ma rua xikip a to runon.” ");
INSERT INTO bjk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Io, a nangadi lotu niang toxoro ulo elixilik nang a inarse ixo ot pösöt idi xina axana bung bara toxo teng e Stiwen, idi toxo ulo rup kö palaa u Ponisia, Saipras ma Entiok. Me idi toxo etöngösen ma tinenge deek urungan köbo Judeia xalik mon. ");
INSERT INTO bjk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Inexalik bara dauleng ke idi a nangadi mee Saipras ma Sairin, toxo wan uruso Entiok ma toxo urulo ra rengrengen ömaras a tinenge deek lamun e Jisas, a Orong, urungan köbo Grik bölök. ");
INSERT INTO bjk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A lölös kö Orong ixo kis arixe me idi ma a oleleng saxit toxo nunu ma toxo tawuxus urungan kö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","A nangadi lotu me ruso Jerusalem toxo ölangen ina tinenge na ma toxo tile e Banabas uruso Entiok. ");
INSERT INTO bjk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nang ine ixo ot ma ixo pere a inone abalamu re God, ixo axanan ma ixo öxaxat idi xirip bara tabo mana tuu lölös turunon arixe ma Orong. ");
INSERT INTO bjk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas ine a tödi deek ma i wöwö ma Töxödös ne Tanono ma nunu. Me idi toxo lamus a oleleng ne nangadi urungan kö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Melamu Banabas ixo wan uruso Tasas sua winawara siwin e Sol. ");
INSERT INTO bjk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ma ixo pere wösöt lo ine ma ixo lamus ine uruso Entiok. Ma ixo öt ma önga awat kudun, e Banabas me Sol toxo kis arixe ma nangadi lotu ma toxo usu a marakörö raxin. A nangadi toxo arun ta rengrengen abo tene tinam pe Jisas mabo ‘Kristien’ ruso Entiok. ");
INSERT INTO bjk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Io, xina axana bung na a dauleng ne propet toxo wan su meriso Jerusalem uruo Entiok. ");
INSERT INTO bjk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ma öng mere idi, esene e Agabus, ixo tuu ma ixo wöwörö ma lölös möxö Tanono bara a irilöng taxin irabo ot ma irabo wan elixilik kö boxönö xirip nang e Rom ibo kure sik. (Ina na ixo ot nang e Kolodias ixo king.) ");
INSERT INTO bjk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ma abo tene tinam pe Jisas idi toxo döxömen bara tabo tile a tuluwok xarnang öngöng ke idi irabo eöt, ta rorop idi abo Kristien nuso Judeia min. ");
INSERT INTO bjk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Io, idi toxo pet biringanin ma toxo tile e Banabas me Sol arixe ma arabaa re idi, uruso xöbo sisila ne lotu. ");
INSERT INTO bjk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Xö ina axana bung nang e Erot a king, ixo öxös a dauleng ne duöng möxö lotu rua ögarin idi. ");
INSERT INTO bjk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ine ixo uguran abo umri rua sesexomet e Jems, a tönö e Jon, arixe ma use. ");
INSERT INTO bjk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nang e Erot ixo pere bara abo Judeia toxo maa lamun a lasa nang ixo pet, io, ixo uguran öbaling idi rua öxös lo bölök e Pita. Ina na ixo wanot kö bung ne Nien möxö Beret nang Kaim a Is. ");
INSERT INTO bjk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Melamu nang toxo öxös e Pita, toxo bulus ölaxa ine xö gunon ne aömokorot. Erot ixo isik ine urungan köbo limine a nit ne muxu ne köbat, ma nit ne tödi xö öngöng ne muxu ne köbat. Erot ixo pingit bara a bung möxö Luxa ne Nuan Lexe irabo kawam, irabo lamus ot e Pita ma irabo tuu xö warkurai xö wawara xö marakörö. ");
INSERT INTO bjk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Io, Pita ixo xisixis kölöme xö gunon ne aömokorot, ma lamun a nangadi lotu toxo seseseng lölös urungan te God tö ine. ");
INSERT INTO bjk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Xö dömön, xina bung mesila nang e Erot irabo lamus ösu e Pita rua tinuu xö warkurai, e Pita ixo paliso kaluluonin a nine köbat, toxo kut ine ma nine uno lölös, ma dauleng ne köbat toxo tuu xö marame laxlaxa. ");
INSERT INTO bjk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Saxit mon, a angelo xö Orong ixo wanot ma a maras ixo wan esexere kölöme xö ina xönö möxö gunon ne aömokorot. Ine ixo ömagi a lawana e Pita ma ixo ölaran ine. Me ine ixo tengen, “Tuu kaa pasaxit!” Ma inabo uno lölös toxo tawalas xalik a limine. ");
INSERT INTO bjk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Io, a angelo ixo tengen te ine, “Örö laulawa ma örö sige a nine sandel.” Me Pita ixo pet eörin. A angelo ixo tengen te ine, “Kain pi nöngön ma xönö man taxin te nöngön ma örö muu e.” ");
INSERT INTO bjk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita ixo muu ösu ine xalik a gunon ne aömokorot, ma lamun kaim ine ra ösöxö a lasa nang a angelo ixo wewet, ixo ot turunon. Ine ixo nunu bere ixo werwere re winawara. ");
INSERT INTO bjk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Idu toxo wan saxit a nine köbat me idu toxo wanot kö marame lölös nang ibo laxlaxa su urungan kö lagunon taxin. Ina marame ixo tamasawang tataun mon tö idu, me idu toxo wan su. Nang idu toxo önan kö ngas, saxit mon ma angelo ixo wan kalik ine. ");
INSERT INTO bjk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Io, Pita ixo döxömen ödeek lo im a lasa ixo ot te ine, ma ixo tengen, “Na e re ösöxö bara turunon a Orong ixo tile a angelo re ine rua ölanglanga e xalik a limine Erot ma xalik abo lalaa xirip nang a nangadi mee Judeia toxo mamaa bara irabo ot.” ");
INSERT INTO bjk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ma nang ine ixo ösöxö xulen ina na, ixo wan uruso xö gunon te Maria, a nago re Jon, önga esene bölök e Mak, ma a nangadi oleleng toxo wan etok ma toxo seseseng könan. ");
INSERT INTO bjk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ixo wiwidin kö marame laxlaxa xö araman, ma önga tene tinörön esene e Roda, ixo wan ta werwere. ");
INSERT INTO bjk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nang ixo ölangen kulen a inöno e Pita, a axanan taxin ixo kip ine ma ixo ulo baling uruso kölöme ma kaim kö sasawang a marame, ma ixo tengen nanin bere Pita i tuu sik ni xö maranangas. ");
INSERT INTO bjk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Idi toxo tengen te ine, “Nöngön u baulang!” Me ine ixo lölös sik mon bara i turunon. Io, idi toxo tengen, “A angelo gut te ine.” ");
INSERT INTO bjk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma lamun e Pita nangen mon ixo wiwidin kö marame, ma nang idi toxo sawang a marame ma toxo pere ine, idi toxo wuwus saban. ");
INSERT INTO bjk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita ixo ööt tö idi ma limine rö idi rua kinis malus, me ine ixo töngösen idi ma nang a Orong ixo ölanglanga ine xalik a gunon ne aömokorot. Ma ixo tengen, “Morobo tengen te Jems ma abo töke re Krais lamun ina na.” Io, ixo wan lie im idi urungan kö xönö xabise. ");
INSERT INTO bjk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Xö puxu xö önga bung kabise, idi toxo wawao siwin e Pita me idi toxo eose baling ke idi iat abo umri, bere Pita ule. ");
INSERT INTO bjk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Io, Erot ixo tile idi ra winawara siwin e Pita, ma lamun kaim idi xo werwere ine. Io, ine ixo ose muu abo umri nang tobo werwere muu e Pita, ma ixo tengen ta sesexomet idi. Io, Erot ixo wan lie e Judeia uri Kaisaria ma ixo xisixis bang e. ");
INSERT INTO bjk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erot ixo laie saban sik kö nangadi mee Tair ma Saidon. Io, idi toxo ot etok kua werwere ine, idi toxo nunu re Balastas bara ine a sisila ne tene tinörön te Erot, ma bara irabo top idi. Io, idi toxo wan urungan te Erot ma toxo ose ine lamun a malum bara irabo kis kaluluonin idi me ine, möxösa, a lagunon te idi irabo kip nien möxö xönö raxin a king ibo wewet warkurai xönan. ");
INSERT INTO bjk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Io, xö bung nang e Erot ixo kubus sua kinis arixe me idi, ine ixo sige a man köbo king, ine ixo kis kö kinis ne warkurai xö king ma ixo pet a tinenge urungan kö marakörö. ");
INSERT INTO bjk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ma a nangadi toxo xukup bara, “A inöno i eöt ma önga god, kaim bara a inöno tödi.” ");
INSERT INTO bjk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Saxit mon kina axana bung, a angelo xö Orong ixo se ine, möxösa, kaim ine ra ölelet e God, mabo sisi toxo en aine, ma ixo met. ");
INSERT INTO bjk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma lamun a tinenge re God ixo ot lölös ma ixo wan elixilik nana. ");
INSERT INTO bjk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Io, nang e Banabas me Sol toxo öxawam a tinörön te idu, idu toxo tawuxus baling meriso Jerusalem, ma toxo lamus e Jon, nang tobo rengrengen ine me Mak, arixe me idu. ");
INSERT INTO bjk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kölöme xö lotu niso Entiok nangen a dauleng ne propet ma tene ausu. Abo esene idi e Banabas, e Simion, tobo rengrengen ine ma Kong, e Lusias meriso Sairini, e Manaen ewe nang ixo taxin arixe me Erot nang a tödi raxin, me Sol. ");
INSERT INTO bjk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nang idi toxo lolotu wösöt a Orong ma toxo ölölö, a Töxödös ne Tanono ixo tengen, “Mum morobo mana pere kos e Banabas me Sol ta wewet a tinörön nang e xo kuwe idu ra wewet.” ");
INSERT INTO bjk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Io, melamu nang idi toxoro ölölö ma toxoro seseng, idi toxo bulus abo limine idi lömö ridu ma toxo tile rewe idu. ");
INSERT INTO bjk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A Töxödös ne Tanono ixo tile idu, me idu toxo wan su xö lagunon taxin e Selusia ma toxo kakaa xö mön, ma ixo kip idu uruo Saipras. ");
INSERT INTO bjk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nang idu toxo ot tiso Salamis, idu toxo etöngösen ma tinenge re God kölöme xö gunon ne sineseng möxöbo Judeia. Me idu toxo lamus e Jon, a ese xabise e Mak, arixe me idu ra rorop kölöme xö tinörön. ");
INSERT INTO bjk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Idiet toxo wan kirip kö muxulamin Saipras me idiet toxo ot kö lagunon Papos. Ringan ee idiet toxo esuo ma sewuk meriso Judeia ma a propet töxö, a esene e Baa-Iesu. ");
INSERT INTO bjk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ine ewe nang a tene tinörön kö sisila meriso Rom, e Sergias Paulias. Ma ina sisila na, a tödi nanase, ixo tile tinenge ra lalamus e Banabas me Sol, möxösa, ine ixo mamaa ra ölangen a tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ma önga tödi a esene e Elimas, a sewuk ine, ma a esene, a unine bara, ‘a sewuk’. Ma ixo tuu wi idiet ma ixo mamaa ra wuxwuxus a dinödöm kö ina sisila bere ine i bele nunu. ");
INSERT INTO bjk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Io, e Sol, niang tobo rengrengen bölök ine me Pol, ixo wöwö sik ma Töxödös ne Tanono ma ixo pere dik e Elimas ma ixo tengen, “U xarnang arixe e Satan! Nöngön a iuiuo möxöbo lalaa xirip nang a lak töxödös. Ma u wöwö sik mabo mangana atöxö ma abo ineösaxit saban kirip. U bo eka xuxulas a turunon kö Orong urungan baling kö röxröxö. Nagut u kebeöt ta iwes ina tatalien na? ");
INSERT INTO bjk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nixinen a Orong irabo ömaso e nöngön. Nöngön örobo pulo ma ökorobo eöt bölök bara örobo pere a maras möxö xaken.” Io, saxit mon niang a xödxödö ixo kait pi ine ma ixo sasae nana lamun te öng bara irabo tön a limine rua sisilien ine. ");
INSERT INTO bjk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Io, nang a tödi raxin möxö gapman ixo pere bira, ixo nunu, möxösa, ixo wuwus köbo inausu xö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Io, Pol ma nine ais se ine, idiet toxo kakaa lo xö mön meringan Papos uruso Perga ro xö provins Pampilia. Me Jon ixo wan kalik idu ringan ma ixo baling uruso Jerusalem. ");
INSERT INTO bjk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Io, idu toxo wan lo meringan Perga uruso Entiok kuso xö distrik Pisidia. Ma xö Sabat idu toxo wan laxa ruso xö gunon ne sineseng möxöbo Judeia me idu toxo kis. ");
INSERT INTO bjk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Melamu, niang toxoro öxawam a xinixos möxöbo ginigeet möxöbo warkurai te Moses ma dauleng ne ginigeet möxöbo propet, abo sisila ne lotu toxo tile tinenge rö idu ma toxo tengen, “Abo tönö e mem, niang bere mu angen merebo tinenge aöxaxat möxö nangadi na, i deek bara mu morobo tengen.” ");
INSERT INTO bjk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pol ixo tuu kaa ma ixo ööt te idi ma limine bara idi ta kis ödödö. Io, ixo tengen, “Nangadi mee Israel, me mum ewe niang kaim bara abo Judeia niang mum bo lolotu wösöt e God, mum moro ölangen ee! ");
INSERT INTO bjk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A God möxö nangadi mee Israel ixo pere kos lo abo untubuno ire ma ixo öraxin idi niang toxo kis xarniang abo osee ri Isip. Ma ixo silien ösu idi meringan kina xönö arixe ma a lölös taxin. ");
INSERT INTO bjk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ma i turunon bara kaim idi ra rarame ine, lamun kaim ine xo tinuu rewe xalik idi xö nit ne sangaun ne awat tuso xö xönö tataun. ");
INSERT INTO bjk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ixo ögarin a pitnö ma ninöng ne bung marapun to Kenan ma ixo isik tewe a pu re idi urungan kö nangadi re ine bara re idi im. ");
INSERT INTO bjk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Inabo lalaa na ixo ot eöt ma nit ne mar ma pitnö ne sangaun ne awat. “Melamu xina na, God ixo isik abo tene warkurai te idi ot kö bung ke propet Samuel. ");
INSERT INTO bjk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Io, a nangadi toxo ose lamun te king me God ixo isik e Sol a barok ke Kis, meringan kö bung marapun te Beniamin. Me Sol ixo kure idi eöt ma nit ne sangaun ne awat. ");
INSERT INTO bjk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Io, melamu, God ixo kip tewe e Sol ma ixo bulus e Dewit bara irabo king ke idi. Me God ixo töngösen idi lamun e Dewit ma ixo tengen bira, ‘E xoro pere wösöt lo e Dewit a barok ke Jesi bere ine ina mangana tödi nang i eöt xarniang kö mamaa re e. Me ine irabo pet kirip abo lalaa niang e mamaa bara irabo pet.’ ");
INSERT INTO bjk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Io, meringan köbo tubuno e Dewit, God ixo isik ot a Tene Aöro, e Jisas, urungan köbo tee Israel, xarnang ixoro kubus sik. ");
INSERT INTO bjk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mesila nang bang kaim e Jisas sa urulo a tinörön te ine, Jon ixo palas tinenge lölös sik kidi abo Israel bara idi tabo dödöm puxus ma tabo kip baptais. ");
INSERT INTO bjk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Niang e Jon ixo pet eörin kirip abo tinörön te ine ixo tengen, ‘Mum mo döxömen bere e iang ewe? Kaim bara e a Mesaia. Ma lamun öng melamu re e ine irabo wanot me e kobo töxödös eöt ta walwalas a kililöng kalik a tabalane xexene.’ ");
INSERT INTO bjk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Abo töke, mum abo untubuno e Abaram, me mum niang kaim bara abo Judeia niang mum bo lolotu wösöt e God, moro ölangen. God ixo tile ina tinenge ne aöro ura re ire iat. ");
INSERT INTO bjk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","A nangadi mee Jerusalem mabo sisila re idi kaim kö ösöxö xulen e Jisas bere ine runon ewe. Me idi tekarabo ölangen kulen bölök abo tinenge möxöbo propet niang idi toxo ölangen nang idi xabise tobo xokos kölöme xöbo Sabat kirip. Ma lamun niang idi toxo kure ine bara irabo mana kip a aömokorot, idi toxo öturunon abo tinenge möxöbo propet. ");
INSERT INTO bjk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kaim idi ra ruruxun pösöt te laa nang i eöt bara idi tabo sexomet ine lamun. Ma lamun idi toxo seng lo e Pailat bara tabo sexomet ine. ");
INSERT INTO bjk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nang idi toxo pet kirip sik abo lalaa niang abo propet toxo geet bara tabo mana pet tö ine, idi toxo kip ösu ine meringan kö sölöxöröp ma toxo bulus ine xö önga maöt. ");
INSERT INTO bjk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma lamun e God ixo öraru ine xalik a minet, ");
INSERT INTO bjk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ma xöbo oleleng ne bung idi nang toxobo arixe mine meringan Galili urungan Jerusalem, idi toxobo werwere ine. Ma nixinen idi tobo rengrengen ine xö nangadi re ire. ");
INSERT INTO bjk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Me maa me tengen a tinenge deek ke mum. Ma i bira. God ixoro kubus sik köbo untubuno ire. ");
INSERT INTO bjk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ma ixoro pet eörin inabo kunubus sö ire, a bung barok umelamu bira: ixoro öraru e Jisas kalik a minet. Ma ixo ot eöt xarnang toxo geet kölöme xö Sinö seöninöng kö Buk Sinö. I tengen bira, ‘Nöngön a barok ke e, Ma nixinen e re tamana nöngön.’ ");
INSERT INTO bjk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ma ina tinenge na i tengen a turunon bara God ixo öraru ine xalik a minet ma i kebeöt ta mamaxus. Inabo tinenge i bira: ‘E rabo isik a madakdak ne arabaa urungan te mum niang e xoro kubus sik me Dewit lamun. Ma inabo xuxubus i karabo kawaim.’ ");
INSERT INTO bjk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Io, toxo tengen bölök kö xönö xabise bara, ‘Nöngön ökorobo ömaraxen lo re Öng ke nöngön Nang i Madakdak bara irabo maxus.’ ");
INSERT INTO bjk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“I maras bara abo tinenge iri ot turunon, möxösa, Dewit ixo pet eörin a lasa niang e God ixo pingit bara irabo pet köbo bung niang ixo to sik, ma melamu, ixo met. Me idi toxo pömös ine arixe mabo untubuno, ma a aine ixo maxus. ");
INSERT INTO bjk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ma lamun ine ewe nang God ixo öraru öbaling kalik a minet, kaim a mamaxus. ");
INSERT INTO bjk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Io, abo töke, e mamaa bara mum morobo mana ösöxö bara Jisas niang i sawang a ngas bere God irabo döxömen taun tewe abo magingin saban. Ma na maa marabo tengen te mum lamun ina niang. ");
INSERT INTO bjk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Me idi xirip niang toxo nunu re Jisas, God irabo tengen te idi bara idi te töxödös ma bara tere langlanga xalik abo magingin saban niang abo warkurai te Moses i kebeöt ta ölanglanga idi xalik. ");
INSERT INTO bjk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mum moro balaure e mum möxö abo lasa niang abo propet toxo tengen, i karabo ot turunon te mum. Inabo tinenge i bira: ");
INSERT INTO bjk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mum morobo mana ölangen, mum abo tabuno ölöngö. Mum morobo wuwus ma morobo iuo saban, möxösa, e rabo pet te laa kölöme xöbo axana bung nang mum mo roro xönan, ma lamun niang bere idi tabo tengen te mum lamun ine, mum korobo eöt ta nunu.’” ");
INSERT INTO bjk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Io, niang e Pol me Banabas idu toxo önan su xalik a gunon ne sineseng möxöbo Judeia, a nangadi toxo seng idu rua tinenge baling lamun inabo lalaa xö Sabat melamu. ");
INSERT INTO bjk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nang a nangadi niang toxo kis arixe midi toxoro wan elixilik, oleleng ne Judeia me idi xabise ewe niang toxo kip ausu xö lotu möxöbo Judeia, idi toxo muu e Pol me Banabas. Me idu toxo öxaxat bara idi tabo kisisik iat kölöme xö abalamu re God. ");
INSERT INTO bjk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Io, xö Sabat melamu, a nangadi oleleng arixe möxöbo lagunon taxin toxo wanot arixe ra ölangen a tinenge xö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Niang abo Judeia toxo pere a nangadi oleleng idi toxo bala kadik ma toxo uli ma toxo tengen ögarin abo tinenge re Pol nang ixo rengrengen. ");
INSERT INTO bjk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Io, e Pol me Banabas toxo balu idi ma balamasa bira, “God ixo pingit bara mum iat morobo mana araun ta ölangen a tinenge re ine. Ma lamun e mum moxoro kasen ine me mum kebeöt ta örasen bara e mum mo eöt tua kip a to ulorexe. Io, nixinen maa marabo tawuxus kalik e mum urungan te idi niang kaim bara abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Me maa me pet bira, möxösa, abo tinenge niang e God ixo tengen ölölös se maa ulamun i bira: ‘E xoro bulus nöngön xarnang a bibio re idi ewe nang kaim bara abo Judeia, bara meringan kö tinörön te nöngön, God irabo öro rebo nangadi xö öxöno lagunon kirip.’” ");
INSERT INTO bjk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ma nang idi niang kaim bara abo Judeia toxo ölangen ina na, idi toxo axanan ma toxo tengen bara abo tinenge xö Orong a lak mamaran. Me idi ewe niang God ixoro tulus lo idi rua xikip a to ulorexe, idi toxo nunu. ");
INSERT INTO bjk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Io, a tinenge re God ixo wan elixilik kö boxönö xirip kina xönö. ");
INSERT INTO bjk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lamun abo Judeia toxo öraru abo baladi abo une raxin niang idi toxo ii e God, mabo duöng orong bölök möxö ina lagunon. Me idi toxo isik ot a agot te Pol me Banabas ma toxo bat tewe idu meringan kalik a xönö re idi. ");
INSERT INTO bjk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Io, idu toxo talis tewe abo teles möxöbo xexene idu rua osen bara idi toxoro pet a magingin saban tö idu. Me idu toxo wan u Aikoniam. ");
INSERT INTO bjk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma abo tene tinam pe Jisas meringan Entiok, idi toxo wöwö arixe ma axanan ma Töxödös ne Tanono. ");
INSERT INTO bjk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ruso Aikoniam e Pol me Banabas toxo wan laxa uruso kölöme xö gunon ne sineseng möxöbo Judeia xarniang iat idu toxobo wewet. Idu toxo wöwörö önga mangana iat, nang a oleleng ne Judeia me ewenene midi nang kaim bara abo Judeia, idi toxo nunu. ");
INSERT INTO bjk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lamun abo Judeia niang toxo öngus sa nunu, idi toxo öraru abo bala kadik kö idi nang kaim bara abo Judeia nang kaim idi ra nunu. Me idi abo Judeia toxo öngat bölök a balna idi nang kaim bara abo Judeia bara tabo mana wan tewe meringan kalik abo Kristien. ");
INSERT INTO bjk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Io, Pol me Banabas toxo xisixis singan me idu toxo rengrenge ma balamasa lamun a Orong. Ma Orong ixo öturunon abo tinenge re idu lamun a abalamu re ine bira. Ixo tabaa idu ma lölös sua wewet abo auxileng lölös ma lalaa ne auwuwus. ");
INSERT INTO bjk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A nangadi möxö ina xönö lagunon toxo palang idi, dauleng kö lawa möxöbo Judeia ma dauleng kö lawana idu a nine aposol. ");
INSERT INTO bjk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Dauleng ne Judeia ma dauleng niang kaim bara abo Judeia arixe mabo tene sisila re idi toxo pingit bara tabo pet ögat idu ma tabo teng ömet idu. ");
INSERT INTO bjk_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ma lamun nang idu toxo ösöxö lo ina na, idu toxo ulo rup u Listra me Derbe xö xönö Likonia, ma toxo su xö boxönö lörörö xö nine lagunon taxin. ");
INSERT INTO bjk_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Me idu toxo balan kö palas tinenge möxö tinenge deek kingan ee. ");
INSERT INTO bjk_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ro Listra önga tödi ixobo kisisik. Toxo kip ine ma a pengpeng ma i kara ösöxö a nuan. ");
INSERT INTO bjk_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Ixo ölangen abo tinenge re Pol. Io, Pol ixo pere dik sik ine ma ixo pere bara ine ma nunu rua langlanga. Io, Pol ixo kuwe ine ma ixo tengen, “Örö taru ma örö tuu!” Saxit mon ina tödi na ixo kos kaa ma ixo urulo ra nuan nana. ");
INSERT INTO bjk_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nang a marakörö toxo pere a lasa niang e Pol ixo pet, idi toxo xukup ma tinenge me Likonia bara, “A nine god tere wan su ura re ire xarniang a tödi runon!” ");
INSERT INTO bjk_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Io, idi toxo tut e Banabas ma ese Sius me Pol me Ermis, möxösa, ine ibo sila sik ke idu ra tinenge. ");
INSERT INTO bjk_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A gunon lotu re Sius ixo tuu sik uri xö araman kö lagunon taxin. Ma a pris se Sius ixo kip ot a bulmakau suxurno arixe ma löm uruso lömö xö marame laxlaxa möxö ina lagunon taxin. Ixo pet bira, möxösa, ine arixe ma marakörö toxo mamaa rua söngsöngöt abo arabaa re idi rua lotu wösöt idu. ");
INSERT INTO bjk_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Ma lamun niang ina nine aposol, e Pol me Banabas, idu toxo ölangen bere idi te xeka wewet bira rö idu, idu toxo didii a man te idu rua osen bara idu tekobo maa bara idi tabo pet bira rö idu. Idu toxo ulo su lörörö xö marakörö me idu toxo tenge raxin bira, “Ai! Ganim e mum pa wewet abo mangana lalaa biringan! Maa a nine tödi mon xarnang e mum ma kawaim bara a nine god e maa. Maa me isik ot a tinenge deek kö mum. Maa me rengrengen tö mum bara mum morobo mana tawuxus meringan köbo laa tataun, ma morobo tawuxus urungan te God nang a lak to, ine nang ixo pet a mango, a xönö lagunon ma a rasi, mabo mangana lalaa xirip lömö kaluluonin idi. ");
INSERT INTO bjk_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Mesila, ixo gan sik a nangadi möxöbo kantri bara tabo mumuu abo mangana tatalien te idi iat. ");
INSERT INTO bjk_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma lamun ine ibo osen ömaras kö nangadi bere ewe ine. Ma ixo pet ina na bira. Ine i osen a abalamu re ine niang ixobo isik a baraa meriso xö mango ma niang ixobo ratabaa e mum arixe mabo nien te mum kinabo texe möxö kip nien. Ma nang ine i pet bira, i tabaa e mum ma nien ma i öwöwö e mum ma axanan.” ");
INSERT INTO bjk_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","A turunon bara idu toxo tengen inabo tinenge, ma lamun kaim kö mamalus sö idu rua tinuu wi idi bara ganim idi ra söngöt arabaa rö idu. ");
INSERT INTO bjk_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Io, melamu, a dauleng ne Judeia toxo wanot mee Aikoniam ma Entiok meringan Pisidia, me idi toxo sat lo a dinödöm kö marakörö. Idi toxo teng e Pol arixe ma warawat ma toxo ösat ösu ine uri xö araman möxö lagunon taxin, möxösa, idi toxo döxömen bara ine ixoro met. ");
INSERT INTO bjk_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ma lamun, melamu niang abo tene tinam pe Jisas toxo kis etok arixe me ine, ixo taru kaa ma ixo wan baling uruso xö lagunon taxin. Ma xö bung kabise idu me Banabas toxo wan u Derbe. ");
INSERT INTO bjk_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Idu toxo palas tinenge ma tinenge deek kö kölöme xina lagunon Derbe me idu toxo uxis a oleleng ne tene tinam pe Jisas. Io, idu toxo tawuxus baling uri Listra, Aikoniam, ma uri Entiok mee Pisidia. ");
INSERT INTO bjk_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Idu toxo ölölösin inabo tene tinam pe Jisas me idu toxo öxaxat idi bara idi tabo mana tuu lölös sik kö nunu kölöme re Jisas. Idu toxo tengen, “Ire tabo mana örasen iat a oleleng ne kinadik kua nilaxa xö kingdom pe God.” ");
INSERT INTO bjk_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","E Pol me Banabas toxo pere kos lo idi a dauleng ne sisila xöbo gunon ne lotu öngöng. Me idu toxo isik idi uruso xö limine Orong ewe niang idi toxoro nunu re ine. Idu toxo pet bira arixe ma sineseng ma ölölö. ");
INSERT INTO bjk_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Melamu niang idu toxo wan saxit kölöme xö distrik Pisidia, idu toxo ot kölöme xö provins Pampilia. ");
INSERT INTO bjk_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ma niang idu toxoro etöngösen ma tinenge re God kö lagunon Perga, idu toxo wan su uruo Atelia. ");
INSERT INTO bjk_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Io, idu toxo kakaa xö mön meringan Atelia me idu toxo baling u Entiok, a lagunon niang abo tene tinam pe Jisas toxoro isik idu ringan uruso xö abalamu xö God bere idu tabo pet ina tinörön na niang idu toxoro öxawam. ");
INSERT INTO bjk_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Xö inot tidu ringan Entiok idu toxo lamus etok a marakörö ne lotu ma toxo tengen kirip abo lalaa niang e God ixoro pet kölöme xö tinörön te idu. Me idu toxo tengen bölök bara God ixo sawang a ngas bara idi niang kaim bara abo Judeia idi tabo nunu. ");
INSERT INTO bjk_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Io, idu toxo kis ömat tingan arixe ma abo tene tinam pe Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A dauleng ne duöng mee Judeia toxo wanot su uruo Entiok ma toxo usu abo Kristien bira, “Ma nang bara mum kobo muu a warkurai te Moses möxö xurxuru abo lewene aine mum, e God i kobo eöt ta öro e mum.” ");
INSERT INTO bjk_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ina na ixo pet e Pol me Banabas sa inegot ma tinenge lölös arixe midi. Io, toxo tibe e Pol me Banabas arixe ma dauleng ne tene nunu, rua nuan kaa uruso Jerusalem pa werwere abo aposol mabo duöng sisila ne lotu rua atöngösen lamun ina ineose. ");
INSERT INTO bjk_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Io, a marakörö ne lotu toxo tile idi ra nuan. Ma nang idi toxo wan köröp Ponisia mee Samaria, idu toxo tengen ömaras idi bara i bule a nangadi nang kaim bara abo Judeia, idi toxo dödöm puxus urungan te God. Ma ina tinenge ixo isik a axanan taxin urungan köbo Kristien. ");
INSERT INTO bjk_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ma nang idi toxo ot Jerusalem, a marakörö ne lotu mabo aposol arixe mabo duöng sisila ne lotu toxo öga idi. Me Pol me Banabas toxo tengen ömaras abo lasa nang e God ixo pet kö limine idu. ");
INSERT INTO bjk_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Io, a dauleng ne tene lotu ewe idi nang möxöbo Parasi toxo tuu lömö ma toxo tengen, “A nangadi nang kaim bara abo Judeia tabo mana kuru a lewene aine idi ma tabo mana muu abo warkurai te Moses.” ");
INSERT INTO bjk_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abo aposol mabo duöng sisila ne lotu toxo ot arixe ra werwere muu ina ineose. ");
INSERT INTO bjk_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Melamu xöbo tinenge oleleng, Pita ixo taru kaa ma ixo tengen ömaras idi bira, “Abo töke, mum mo ösöxö bara nang köbo bung mesila saxit, God ixo pere kos lo e kaluluonin e mum, bara a nangadi nang kaim bara abo Judeia tabo ölangen a tinenge deek möxö ngalake ma tabo nunu. ");
INSERT INTO bjk_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Me God, ine ewe i ösöxö a könönö ire xirip öngöng, ixo isik a Töxödös ne Tanono urungan tö idi xarnang mon ixo isik ke ire ra osen bara ibo öga idi bölök. ");
INSERT INTO bjk_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Me ine kaim kö wewet te tatalien kabise kaluluon te ire me idi. Kawaim. Ine ixo ömadakdak abo balana idi ma nunu. ");
INSERT INTO bjk_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Io, ma ruasa mum mo mamaa ra könönöin e God, rua bulbulus a tiip kö inöno abo tene tinam pe Jisas niang abo untubuno ire me ire bölök tokobo eöt ta sösölök? ");
INSERT INTO bjk_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ire te nunu bara a Orong e Jisas i tabaa tataunin mon ire ma ina to runon xarnang mon i pet tö idi.” ");
INSERT INTO bjk_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Io, a marakörö nang toxo kis etok toxo kis ödödö ma toxo ölangen e Banabas me Pol. Idu toxo rerenge lamun abo auxileng lölös ma laa ne auwuwus nang e God ixo pet te idu kaluluonin a nangadi nang kaim bara abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ma nang idu toxo kawam kö winörö, Jems ixo tengen bira, “Abo töke, moro ölangen e. ");
INSERT INTO bjk_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon iri tengen ömaras se ire, nang bara bule e God ixo osen a abalamu re ine rua xikip lo a nangadi re ine iat meringan kölöme xö nangadi nang kaim bara abo Judeia idi. ");
INSERT INTO bjk_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ina na i eöt ma tinenge möxöbo propet nang toxo geet bira, ");
INSERT INTO bjk_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Melamu xönan, e rabo ot baling me e rabo uru öbaling a gunon lotu re Dewit nang ixoro subu. E rabo uru öbaling abo xönö nang i tamauwuk su, ma arabo pet ödeek ine. ");
INSERT INTO bjk_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Io nang, a nangadi xabise tabo wawara siwin a Orong, idi a nangadi xirip nang kaim bara abo Judeia nang e xo kip lo idi bara rö e.’ ");
INSERT INTO bjk_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ina niang abo tinenge xö Orong, nang ixo ömaras ire min ma abo lalaa me lorexe saxit.” ");
INSERT INTO bjk_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jems ixo tengen, “A winara iat te e bara ganim ire ra öriip idi nang kaim bara abo Judeia nang ewe te ratawuxus pösöt e God. ");
INSERT INTO bjk_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Inexalik bara ire tabo gegeet urungan tidi rua rengrengen ögele idi bara, ganim idi ra enen a nien nang a dauleng te döxömen bara i koxobo töxödös bara tabo en, möxösa, a nangadi te erabaa min urungan kö perewuo, ma ganim idi ra wewet a magingin saban möxö minaru arixe, ma ganim idi ra enen a gineme nang tobo kut ömet, bara nien nang ma dee. ");
INSERT INTO bjk_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ire tabo tengen bira, möxösa, mesila saxit ot nixinen tobo walwalas tinenge mabo warkurai te Moses kö boxönö lagunon taxin ma tobo xokos inabo warkurai xö gunon ne sineseng köbo bung Sabat kirip.” ");
INSERT INTO bjk_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Io, abo aposol mabo tene sisila mabo nangadi xirip möxö lotu toxo kubus tinenge rua pere kos lo rebo tödi mere idi iat ta tile idi uruso Entiok arixe me Pol me Banabas. Idi toxo pere kos lo e Judas (a esene bölök e Barsabas) me Sailas, idu a nine tene sisila möxöbo Kristien. ");
INSERT INTO bjk_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Idi toxo tile arixin idi ma axana ginigeet i tengen bira, “Mem abo aposol mabo tene sisila, abo tönö e mum kö esene e Krais, mem me tile a axanan te mum kö nangadi nang mum kaim bara abo Judeia, mum abo tene nunu meringan Entiok, Siria me Silisia. ");
INSERT INTO bjk_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mem me ölangen bara uleng mere mem te ot pösöt e mum ma te öwuwus e mum mabo tinenge re idi. Me idi te ögarin a dinödöm pe mum. Ma lamun mem kobo tengen te idi rua wewet biringan. ");
INSERT INTO bjk_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Io, na mem mere ot kö önga dinödöm bara marabo pere kos lo rebo duöng. Mem marabo uguran idi urungan te mum arixe ma nine tönö e mem, e Banabas me Pol. ");
INSERT INTO bjk_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","A nangadi toxo mamaa rua sesexomet idu, ma lamun idu toxo isiksik iat a to ridu rua atöngösen ma esene Jisas Krais. ");
INSERT INTO bjk_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Io, mem me uguran e Judas me Sailas urungan te mum rua töngösen e mum ma rua öturunon a tinenge nang mem moxo geet. ");
INSERT INTO bjk_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I deek kö winawara xö Töxödös ne Tanono, me mem bölök, marabo ganim a urip e mum mere xinixip. A uleng ne warkurai i deek mon bara morobo muu. ");
INSERT INTO bjk_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ganim e mum pa enen a nien ne arabaa nang te erabaa min urungan kö perewuo, ma ganim e mum pa enen a nien nang ma dee, bara a gineme nang tobo kut ömet, ma ganim e mum pa wewet a magingin saban möxö minaru arixe. I deek bara mum morobo wan pes minabo mangana lalaa na. Io, ine mon.” ");
INSERT INTO bjk_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Io, a marakörö ne lotu toxo tile rewe idi ma toxo wan su uri Entiok. Idi toxo kuwe arixin a marakörö ne lotu meringan, ma toxo isik a axana ginigeet te idi. ");
INSERT INTO bjk_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ma nang a marakörö ne lotu toxo kos, idi toxo axanan lamun ina tinenge ne aöxaxat. ");
INSERT INTO bjk_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","E Judas me Sailas, idu iat a nine propet. Me idu toxo tengen a oleleng ne tinenge ne aöxaxat möxö ölölös idi abo Kristien. ");
INSERT INTO bjk_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Melamu xöbo bung ixo saxit idu ringan, abo Kristien toxo tile rewe öbaling idu ma malum rua binaling urungan te ewe midi nang toxo uguran idu. ");
INSERT INTO bjk_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ine xalik bere Pol me Banabas toxo kis baling kingan Entiok. Me idu arixe ma oleleng ne duöng kabise toxo eusu ma toxo tengen ömaras a tinenge xö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Io, xöbo bung melamu Pol ixo tengen te Banabas, “Iraa ta wan baling ma ta uxileng abo Kristien köbo lagunon tataxin kirip nang iraa toxoro tengen ömaras a tinenge xö Orong könan. Ma ta pere bara idi te bubule im.” ");
INSERT INTO bjk_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas ixo mamaa ra lalamus lo e Jon Mak arixe me idu. ");
INSERT INTO bjk_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Inexalik e Pol ixo döxömen bara i kobo deek ka lalamus lo ine, möxösa, ine ixo wan talu idu ruso Pampilia ma kaim a nuan arixe me idu rua wewet a tinörön. ");
INSERT INTO bjk_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A agot taxin ixo ot kaluluonin idu, io, idu toxo wan ewalas. Banabas ixo lamus lo e Jon Mak, idu toxo kaa lo xö mön uruso Saipras. ");
INSERT INTO bjk_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Inexalik e Pol ixo pere kos lo e Sailas. Nang idu toxo mamaa ra nuan, abo Kristien toxo tengen te idu bira, “A abalamu xö Orong irabo kis arixe me mu.” ");
INSERT INTO bjk_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol ixo wan kaluluonin e Siria me Silisia ma ixo ölölös abo marakörö möxöbo lotu. ");
INSERT INTO bjk_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Io, Pol ixo wanot Derbe ma meringan ixo wan Listra, ma önga bak ne ausu a esene e Timoti ixobo xisixis singan. A nago re ine a Judeia ma a tene nunu, ma lamun a tata re ine a Grik. ");
INSERT INTO bjk_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abo Kristien kirip kölöme Listra me Aikoniam toxo etöngösen bara e Timoti ine a tödi mamaran. ");
INSERT INTO bjk_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pol ixo mamaa rua lalamus e Timoti ra nuan. Io, ine ixo kuru a lewene aine, möxösa, abo Judeia ewe nang tobo xisixis singan, idi xirip toxo ösöxö bara tata rine a Grik. ");
INSERT INTO bjk_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Io, nang idiet toxobo önan kölöme xöbo lagunon taxin, idiet toxobo isik urungan köbo tene nunu abo warkurai niang abo aposol mabo sisila ne lotu ringan Jerusalem toxo bulus bara rua nangadi ra mumuu. ");
INSERT INTO bjk_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Io, a nunu xö marakörö ne lotu ixo tuu lölös ma a xinoxos ixo önan kaa xöbo bungbung kirip. ");
INSERT INTO bjk_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Idiet toxo wan kölöme xirip kö distrik Pirigia ma provins Galesia, nang a Töxödös ne Tanono kaim kö mamaa re idiet ta atöngösen ma tinenge deek kö provins Esia. ");
INSERT INTO bjk_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ma nang idiet toxo ot lörörö distrik Misia, idiet toxo mamaa ra nuan laxa xö provins Bitinia, inexalik a Tanono e Jisas kaim kö öbala idiet. ");
INSERT INTO bjk_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Io, idiet toxo wan saxit Misia ma toxo wan su urungan Toroas. ");
INSERT INTO bjk_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Xina bung kö dömön, Pol ixo pere a winawara möxö önga tödi mee Masedonia, ixo tuu sik ma ixo seseseng bira, “Örö miang ura Masedonia ma örö top e mem.” ");
INSERT INTO bjk_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Melamu mon kö winawara re Pol, meet moxo tagur iat mon ta nuan uruso Masedonia, möxösa, e meet moxo ösöxö bere God ixo kuwe e meet tua atöngösen ma tinenge deek kingan tidi. ");
INSERT INTO bjk_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Meet moxo kakaa xö mön mee Toroas ma moxo wan töxödös u Samotares. Ma xö bung melamu meet moxo wan Niapolis. ");
INSERT INTO bjk_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Io, meringan Niapolis meet moxo wan urungan Pilipai, a xönö lagunon taxin mee distrik Masedonia. Abo Rom toxo pet e Pilipai xarnang a lagunon te idi me meet moxo kis singan kö uleng ne bung. ");
INSERT INTO bjk_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Xö bung Sabat meet moxo wan su xö marame möxö lagunon taxin urungan kö ari, nang meet me döxömen bere meet marabo wawara siwin te xönö rua sineseng. Meet moxo kis su ma moxo urulo ra tinenge ma balixilik ewe nang toxoro ot etok kingan. ");
INSERT INTO bjk_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Öng mere idi ewe nang ixo ölangen e meet, e Lidia, a öng nang ixobo lolotu wösöt e God. Ine mee Taiataira ma ixobo rörörön kö man dadan leklek. A Orong ixo sawang a balana ine rua xikip lo a tinenge re Pol nang ixo rengrengen. ");
INSERT INTO bjk_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Io, melamu, ine arixe mabo nangadi möxö gunon tine, idi toxo kip baptais, ma ixo seng ölölös e meet tua nuan urungan kö gunon tine. Ine ixo tengen, “Nang bara muot mo döxömen bere e a tene nunu xö Orong, muot moro miang ma moro kis so xö gunon te e.” Me ine ixo ölölös e meet ta nuan. ");
INSERT INTO bjk_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Önga bung meet moxo önan uruso xö xönö möxö sineseng, meet moxo esuo ma önga balik tultul, niang a tano saban ixo kis sine. Io, nang a tano saban ixobo tabaa ine ma lölös sua atöngösen lamun abo lalaa irabo wanot melamu. Ine ibo rörön ot a tuluwok taxin te idi nang tobo unan sik ine. ");
INSERT INTO bjk_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ina balik ixo muu e meet kirip arixe me Pol, ma ixo xukup bira, “Inabo nangadi na, idiet abo tultul kö pu xö God niso lömö saxit, ewe idiet te rengrengen a ngas sua nang e God irabo öro mum könan.” ");
INSERT INTO bjk_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ine ixo wewet bira xö oleleng ne bung, ot nang e Pol ixo laie me ine ixo tawuxus ma ixo tengen kö tano saban, “Xö esene Jisas Krais, e tengen bara örö wan su xalik ine.” Ma saxit mon a tano saban ixo wan lie ine. ");
INSERT INTO bjk_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ma bere idi nang toxo unan sik ina balik, toxo ösöxö xulen bara ngas se idi möxö wewet ot a tuluwok ixoro wan, toxo tödik e Pol me Sailas ma toxo ösat idu uruso xö xönö möxö misik kua tinuu mesila ridi nang tobo sila sik ma lölös. ");
INSERT INTO bjk_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Idi toxo lamus ot idu uruso mesila xöbo tene warkurai mee Rom ma toxo tengen, “Nine tödi na, idu a nine Judeia, me idu toxo öraru a kinis saban kö lagunon te ire. ");
INSERT INTO bjk_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Me idu te sasat ot a marakörö rua mumuu a mangana tatalien. Ma lamun, nang bara ire tabo ömaraxen lo bara tabo wewet muu inabo tatalien na, ire tabo lexe abo warkurai te ire a nangadi mee Rom.” ");
INSERT INTO bjk_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","A marakörö toxo tuu arixe ma toxo egot midu. Io, abo tene warkurai, idi toxo erile bara tabo didii ana man te idu ma bara tabo dangat idu. ");
INSERT INTO bjk_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Io, nang toxo dangat oleng idu, toxo bulus ölaxa idu xö gunon ne aömokorot, ma toxo tengen ölölös kö tödi ixobo balaure ina gunon tua winawara wi ödeek idu. ");
INSERT INTO bjk_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Melamu xöbo tinenge lölös kirip, a tödi möxö winawara wi a gunon ne aömokorot ixo bulus ölaxa idu uruso kölöme saxit kö gunon ne aömokorot ma ixo kubus ölölös abo xexedu urungan kö xönö iaa. ");
INSERT INTO bjk_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Xö luono dömön, Pol me Sailas toxo seseseng ma toxo sösö mabo sinö urungan te God, mabo nangadi xabise nang toxo kut dik idi, toxo ölangen idu. ");
INSERT INTO bjk_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ma saxit mon a gie raxin ixo ot ma ixo ögigie ina gunon ne aömokorot. Mabo marame xirip toxo tamasawang mabo xinubus lölös se idi xirip toxo tawalas. ");
INSERT INTO bjk_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","A tödi möxö winawara wi a gunon ne aömokorot ixo laran ma ixo pere abo marame möxö gunon ne aömokorot ixoro tamasawang, ma ixo döxömen bara abo tödi kölöme tere ulo rup. Io, ixo sat ösu a sele ma ulik bara irabo se öbaling ine. ");
INSERT INTO bjk_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Inexalik, Pol ixo kup, “U bele sese öbaling nöngön! Mem kirip angen na!” ");
INSERT INTO bjk_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A tödi möxö winawara wi a gunon ne aömokorot ixo kup ulamun te bibio. Ine ixo ulo laxa ma ixo subu ma dinedee mesila re Pol me Sailas. ");
INSERT INTO bjk_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Io, ine ixo lamus ösu idu ma ixo ose idu, “Nine tödi raxin, a lasa arabo mana pet ta xikip a to runon?” ");
INSERT INTO bjk_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Idu toxo balu bira, “Örobo nunu xö Orong e Jisas, nang e God irabo öro nöngön, nöngön arixe me idi niang kö gunon te nöngön.” ");
INSERT INTO bjk_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Io, idu toxo tengen a tinenge xö Orong urungan te ine ma urungan te idi xirip bölök nang kö gunon te ine. ");
INSERT INTO bjk_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Xina axana bung iat kö dömön, a tödi möxö winawara wi a gunon ne aömokorot ixo lamus lo idu ma ixo tos abo ruxuruk ke idu. Me idi barama xirip kö gunon tine, toxo kip baptais. ");
INSERT INTO bjk_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A tödi möxö winawara wi a gunon ne aömokorot ixo lamus ölaxa idu xö gunon te ine ma ixo tabaa idu ma nien. Ine ixo wöwö ma axanan, möxösa, idiet barama toxoro nunu re God. ");
INSERT INTO bjk_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xö puxu abo tene warkurai toxo uguran abo duöng tinörön te idi uruso xö tödi möxö winawara wi a gunon ne aömokorot ma a tinenge bira, “Ölanglanga ösu ina nine tödi niang.” ");
INSERT INTO bjk_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A tödi möxö winawara wi a gunon ne aömokorot ixo tengen te Pol, “Abo duöng möxö tene warkurai te tile a tinenge bara e ra ölanglanga ösu e mu. Na mu mo eöt ta nuan. Mu moro wan ma bala malum.” ");
INSERT INTO bjk_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Inexalik, e Pol ixo tengen köbo duöng tinörön, “Idi toxo dangdangat e maa xö wawara xö nangadi ma kaim kö ölangen ödeek bang a tinenge re maa. Idi toxo tewe ölaxa e maa xö gunon ne aömokorot. Inexalik maa me kip ese bara a nine Rom e maa. Ma na idi te eka irewe ömalus e maa? I kebeöt iat! Idi iat tabo mana wanot ma tabo lamus ösu e maa.” ");
INSERT INTO bjk_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abo duöng tinörön toxo tengen ina tinenge xöbo tene warkurai, ma nang idi toxo ölangen bara e Pol me Sailas idu mee Rom, idi toxo buut. ");
INSERT INTO bjk_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Idi toxo wanot ma toxo wöwörö ma malum urungan te idu, ma toxo wan su arixe midu xalik a gunon ne aömokorot. Ma toxo seng idu ra nuan kalik a lagunon taxin niang. ");
INSERT INTO bjk_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ma nang e Pol me Sailas toxo wan su xalik a gunon ne aömokorot, idu toxo wan laxa uruso xö gunon te Lidia. Me idu toxo xisixis singan bang ma toxo esuo mabo Kristien ma toxo öxaxat idi. Io, idu toxo wan lo im. ");
INSERT INTO bjk_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Io, nang idu toxo wan saxit kaluluonin Ampipolis me Apolonia idu toxo wanot Tesalonika. Ma a gunon ne sineseng ke idi abo Judeia nangen niang. ");
INSERT INTO bjk_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol ixo laxa xö gunon ne sineseng xarnang ine ibo bibie. Ma kölöme xö narun ne bung Sabat ine ixo rengrengen ödöxömen idi ma tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ine ixo palas ömaras a unine tinenge re God i tengen bira, ina Mesaia irabo uruoxe a kinadik ma irabo taru baling kalik a minet. Ixo tengen, “Ina tödi na, e Jisas, e rengrengen te mum, ine a Mesaia.” ");
INSERT INTO bjk_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Dauleng mere idi abo Judeia, idi toxo dödöm köba xö tinenge re Pol ma toxo nunu bara i turunon, io, toxo muu idu me Sailas. Ma oleleng ne balixilik tataxin arixe mabo Grik, nang idi toxobo lolotu re God, toxo pet bölök bira. ");
INSERT INTO bjk_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Inexalik, bara abo Judeia toxo bala kadik sik ke Pol me Sailas, io, toxo lamus lo abo duöng saban möxö xönö möxö misik. Idi toxo lamus etok idi ma toxo pet ot a angat taxin kina lagunon taxin. Idi toxo ulo laxa xö gunon te Jeson ta winara rue Pol me Sailas sua lalamus ösu idu urungan kö limine a marakörö. ");
INSERT INTO bjk_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Inexalik, bara kaim idi xo werwere lo idu, toxo ösat lo e Jeson mabo Kristien kabise uruso xöbo sisila möxö lagunon taxin, me idi toxo xukup bira, “Inabo duöng na nang toxobo wewet a sasaban ta xö öxöno lagunon kirip, idi ia tere wanot. ");
INSERT INTO bjk_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Me Jeson ixo öga ölaxa idi urungan kö gunon te ine. Idi takara muu eörin a warkurai te Kaisar, a king taxin mee Rom. Idi tobo rengrengen bara önga king kabise angen, a esene e Jisas.” ");
INSERT INTO bjk_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ma nang idi abo sisila möxö lagunon taxin ma marakörö toxo ölangen ina tinenge bira, idi toxo bala kadik köba. ");
INSERT INTO bjk_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Io, idi toxo tengen te Jeson ma önga uleng ka wewet te kunubus bara kaim pe bala kadik bira irabo ot baling. Io, idi toxo ölanglanga rewe idi. ");
INSERT INTO bjk_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nang iat mon ixo dömön, abo Kristien toxo uguran tewe e Pol me Sailas uruso Beria. Xö inot tuso, idu toxo wan uruso xö gunon ne sineseng köbo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abo Beria idi a lak deek xöba idi xöbo Tesalonika xö dinödöm pe idi. Idi toxo kip a tinenge re God ma mamaa raxin ma axanan, ma toxobo werwere abo tinenge re God köbo bungbung kirip pua werwere bere Pol i rengrengen a turunon. ");
INSERT INTO bjk_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ma oleleng köbo Judeia toxo nunu. Ma bie bölök kö oleleng ne körö ma balixilik tataxin mee Grik, toxo ölangen ma toxo nunu. ");
INSERT INTO bjk_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Io, abo Judeia nuso Tesalonika toxo ölangen bere Pol ixo etöngösen ma tinenge re God tuso Beria, idi toxo wan bölök urungan ma toxo ögarin a dinödöm kö marakörö ma toxo öraru a tiip kö balana idi. ");
INSERT INTO bjk_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Io, abo Kristien toxo tile wasaxirin e Pol uri xö löxön, inexalik bere Sailas me Timoti toxo xisixis baling Beria. ");
INSERT INTO bjk_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Abo duöng nang toxo wan arixe me Pol, me idi toxo wan arixe me ine uruso Aten. Idi toxo tawuxus baling ma tinenge rua rengrengen te Sailas me Timoti bara idu tabo pasaxit ot urungan tine. ");
INSERT INTO bjk_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Io, nang e Pol ixo xixiset lamun idu ruso Aten, ine ixo tapunuk köba nang ixo pere bara a lagunon taxin ixo wöwö mabo perewuo. ");
INSERT INTO bjk_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Io, ma nang kölöme xö gunon ne sineseng köbo Judeia ine ixo tengen ödöxömen abo Judeia arixe mabo Grik nang tobo lolotu re God. Ma xöbo bungbung kirip kö xönö möxö misik, ma ixobo rengrenge rö idi nang toxobo önan ot ma toxobo xisixis singan ee. ");
INSERT INTO bjk_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","A uleng ne tene ausu ewe nang tobo mumuu a dödöxömen möxö Epikurian me idi nang kö Stoik, toxo urulo a agot ma tinenge arixe me ine. Uleng ke idi toxo eose bira, “Ina baulang na i rengrengen a sa?” Ma uleng kabise toxo tengen, “I wawara bara ine i rengrengen ot abo god möxö boxönö xabise.” Idi toxo tengen bira, möxösa, e Pol ixo rengrengen ot a tinenge maras lamun e Jisas ma ina tinaru baling kalik a minet. ");
INSERT INTO bjk_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Io, toxo lamus ine lamun a kinis etok köbo kansel, tobo rengrengen ma Ariopagas. Ma toxo ose ine bira, “I eöt bara mem marabo ösöxö a lasanene ina ausu maxat na u wewet? ");
INSERT INTO bjk_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nöngön u isik ot önga bo lalaa maxat nang i xabise xö ölöngö re mem, io, mem me mamaa ra ösöxö a unine.” ");
INSERT INTO bjk_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Nangadi xirip mee Aten ma duöng möxöbo lagunon kabise nang toxobo xisixis singan, tokoxobo wewet tebo lalaa. Inexalik idi te balan ma tinenge nana ma ra ölangen nanin abo mangana inausu maxat.) ");
INSERT INTO bjk_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Io, Pol ixo tuu lömö xö kinis etok möxöbo Ariopagas ma ixo tengen, “Nangadi mee Aten! E pere bara xöbo ngas kirip mum mo muu eörin abo tatalien ne lotu re mum. ");
INSERT INTO bjk_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","E tengen bira, möxösa, nang e xo önan nana, e xo pere muu ödeek abo lalaa möxö lotu. E xo pere wösöt a alta ma öxöno tinenge toxo geet bira, ‘Urungan kö önga god nang ire tekobo ösöxö ine.’ Io, ina laa na nang mum kobo ösöxö ine me mum mo lolotu tataun wösöt ine, na im e rabo tengen te mum. ");
INSERT INTO bjk_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“A God nang ixo pet a öxöno lagunon mabo lalaa xirip könan, ine a Orong möxö balana kubu ma öxöno lagunon. Me ine i kara kis kö gunon lotu nang a tödi mon i pet. ");
INSERT INTO bjk_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ine i kara sasaxan bara irabo to xö limine a nangadi lamun te laa, möxösa, ine iat ibo tabaa a nangadi xirip ma to ma xiki ra xikip mamas mabo lalaa xirip. ");
INSERT INTO bjk_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kö önga tödi xalik mon, God ixo pet ot a bung marapun kirip kö öxöno lagunon. Ma ixo uxis idi xö boxönö xirip möxö öxöno lagunon. Me ine iat ixo pingit sik a axana bung ke idi ra kinis ma xönö idi tabo kis könan. ");
INSERT INTO bjk_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God ixo pet bira, bara a nangadi tabo wawara siwin ine ma nagut tabo sasanga rö ine ma tabo pere wösöt gut ine, ma lamun ine i kobo kis kö palaa sik kalik a öngöng ke ire. ");
INSERT INTO bjk_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","I xarnang a öng i tengen, ‘Kölöme re ine, ire te kip a to, ma te mamagi nana me ire te kis.’ I xarnang bölök a uleng ke mum iat a nangadi nanase toxo geet ma toxo tengen, ‘Ire abo baroxorok ke ine.’ ");
INSERT INTO bjk_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Io nang, ire abo baroxorok ke God ire takarabo döxömen bara God ine i eöt ma perewuo ma gol bara siliwa bara a warawat, nang a nangadi te tön ma nanase re idi. ");
INSERT INTO bjk_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mesila God ixo pere tataunin inabo tatalien ne baulang, inexalik bara na ine i tengen kö nangadi xö boxönö xirip pua dinödöm puxus. ");
INSERT INTO bjk_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ine ixo tengen bira, möxösa, ine iri kubus a bung nang ine irabo kure a öxöno lagunon ma tatalien töxödös, ma irabo isik a tinörön na xö tödi ine iat ixo pere kos lo bara irabo pet. Me God ixo öturunon urungan kö marakörö bara irabo pet bira, nang ixo öraru ina tödi xalik a minet.” ");
INSERT INTO bjk_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ma nang idi toxo ölangen a tinenge lamun a tinaru xalik a minet, dauleng ke idi toxo eösaxit, ma lamun a uleng toxo tengen, “Mem me mamaa rua ölangen öbaling a tinenge re nöngön kö inabo lalaa niang.” ");
INSERT INTO bjk_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Io, Pol ixo wan lo meringan kalik idi. ");
INSERT INTO bjk_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Inexalik a uleng ne duöng toxo muu e Pol toxo kip a tinenge ma toxo nunu. Kaluluonin idi e Daionisias, a öng möxöbo Ariopagas kansel, ma kölöme ridi bölök a önga une esene e Damaris ma önga bo nangadi bölök. ");
INSERT INTO bjk_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Melamu im, Pol ixo wan lo xalik e Aten ma ixo wan uruso Korin. ");
INSERT INTO bjk_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ma rö, ixo esuo ma önga tödi Judeia, a esene e Akuila. Me ine mee Pontus. Ma ixo mana wanot mon mee Itali arixe ma usuono e Pirisila, möxösa, e Kolodias, a king taxin mee Rom, ixo tile rewe xirip abo Judeia nang tobo xisixis Rom. Me Pol ixo wan ta werwere idu. ");
INSERT INTO bjk_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ma ixo xisixis arixe midu, möxösa, ine möxö ina mangana tinörön xarnang idu. Me idiet toxo rörörön arixe rua pet gunon walpali ne lewene bulmakau. ");
INSERT INTO bjk_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Xöbo Sabat kirip, ine ixobo rengrengen ödöxömen idi kölöme xö gunon ne sineseng köbo Judeia, ma ixobo ösat a dinödöm pe idi abo Grik mabo Judeia rua nunu xö tinenge re ine. ");
INSERT INTO bjk_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Io, nang e Sailas me Timoti toxo wanot mee Masedonia, Pol ixo balan sik ma palas tinenge xalik mon. Me ine ixo tengen palas ömaras idi abo Judeia bere Jisas ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Inexalik bara abo Judeia toxo mölök ka ölangen a tinenge re ine ma toxo tengen ögarin ine. Io, ine ixo se rewe a kabus xalik a man te ine ra osen bara i kobo ösöxö idi ma ixo tengen, “Nang bere God irabo ömaso e mum, a unine tinenge iat te mum! E iat e langlanga sik kalik e mum. Urulo na, e rabo wan urungan te idi nang kaim bara abo Judeia.” ");
INSERT INTO bjk_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Io, Pol ixo wan lie a gunon ne sineseng köbo Judeia ma ixo wan urungan kö gunon kö tödi a esene e Titius Jastus, a tene lotu re God. Ma gunon te ine i lörörö sik kö gunon ne sineseng. ");
INSERT INTO bjk_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, a tene sisila möxö gunon ne sineseng ke idi abo Judeia, ine mabo barama re ine toxo nunu xö Orong. Ma oleleng ne nangadi mee Korin ewe nang toxo ölangen ina tinenge na, toxo nunu ma toxo kip baptais. ");
INSERT INTO bjk_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Önga dömön, e Pol ixo pere a winawara nang a Orong ixo wöwörö rine ma ixo tengen, “U bele bubuut. Örobo mana wöwörö iat ma u bele xisixis ödödö. ");
INSERT INTO bjk_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Möxö e xisixis arixe me nöngön. Kawaim pe tödi irabo se ma ögarin nöngön, möxösa, e ma oleleng ne nangadi nang tobo nunu re e ra xina lagunon taxin na.” ");
INSERT INTO bjk_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Io, Pol ixo kis bang kingan kö önga awat ma subana, ma ixo usu idi ma tinenge re God. ");
INSERT INTO bjk_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nang e Galio ixo tödi raxin mee Akaia, abo Judeia toxo tuu etok ma toxo ögarin e Pol, ma toxo lamus ölaxa ine urungan kö xönö möxö pet warkurai. ");
INSERT INTO bjk_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Io, idi toxo tengen, “Ina tödi na i ödöxömen a nangadi rua lotu wösöt e God kö mangana ngas nang i kobo muu a warkurai mee Rom.” ");
INSERT INTO bjk_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Io, bere e Pol ixo eka winöwörö, Galio ixo tengen köbo Judeia bira, “Nang bara ina tödi na i lexe a warkurai bara i pet te mangana magingin saban arixe, io, irabo deek ke e ra ölangen e mum abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Inexalik bara abo aose lamun abo tinenge mabo ese mabo warkurai te mum iat. Io, mum iat moro ötöxödös ina tiip na. E kobo mamaa bara arabo pet warkurai lamun a mangana laa bira.” ");
INSERT INTO bjk_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Io, ine ixo bat tewe idi xalik a xönö möxö pet warkurai. ");
INSERT INTO bjk_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Io, idi toxo tödik lo e Sostenis, a tene sisila möxö gunon ne sineseng möxöbo Judeia ma toxo dangat ine mesila xö xönö möxö pet warkurai. Ma lamun e Galio kaim kö niniang muu inabo lalaa nang idi toxo wewet. ");
INSERT INTO bjk_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Io, Pol ixo xisixis bang kingan Korin kö dauleng ne bung. Melamu ixo wan lie abo Kristien ma ixo kakaa xö mön u Siria arixe me Pirisila me Akuila. Nang mesila rine ra kinaa xö mön, toxo köröp a bebene öxöno ringan Senkiria, möxösa, lamun a kunubus ine ixo pet arixin me God ");
INSERT INTO bjk_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Idi toxo wanot Epeses me Pol ixo wan lie e Pirisila me Akuila ringan. Me ine ixo wan laxa xö gunon ne sineseng ma ixo tengen ödöxömen idi abo Judeia. ");
INSERT INTO bjk_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ma nang idi toxo ose ine rua kinis bang arixe me idi, inexalik ine ixo mölök. ");
INSERT INTO bjk_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ma lamun nang ine ixo önan lie idi, ixo tengen te idi bira, “E rabo tawuxus baling nang bara xö mamaa re God iat.” Io, ine ixo kakaa xö mön ma ixo wan lie e Epeses. ");
INSERT INTO bjk_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ma nang ixo wanot Kaisaria, ine ixo wan kaa uruso Jerusalem ma ixo pere lo bang a marakörö ne lotu ma melamu ixo wan su u Entiok. ");
INSERT INTO bjk_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Melamu xö kinis se ine ringan Entiok, Pol ixo wan lo meringan ma ixo wan laxa nana xö boxönö xirip kölöme re provins Galesia ma distrik Pirigia, ma ixo ölölös nanin abo tene tinam kirip pe Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Önga Judeia a esene e Apolos, me ine mee Aleksendria ixo wanot Epeses. Ine a tene nanase ma ixo maras kirip sik kö tinenge re God nang tere geet. ");
INSERT INTO bjk_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ine ixo kip ausu xö ngas kö Orong, me ine ixo palas tinenge ma lölös ma ixo eusu ma tinenge turunon te Jisas. Inexalik bara i ösöxö sik kalik a tinörön ne baptais se Jon. ");
INSERT INTO bjk_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ine ixo urulo ra tinenge ma kawaim pa binuut kö gunon ne sineseng köbo Judeia. Nang e Pirisila me Akuila toxo ölangen ine, idu toxo lamus ine urungan kö gunon te idu, me idu toxo palas ödeek tabaa ine ma ngas se God. ");
INSERT INTO bjk_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Io, nang e Apolos ixo mamaa rua nuan urungan Akaia, abo Kristien nang Epeses toxo öxaxat ine. Idi toxo gegeet urungan köbo tene tinam pingan Akaia ra ömaraxen lo ine. Xö nuanot tine, ine ixo top ewe midi nang e God ixo tabaa tataunin idi ma abalamu rua nunu. ");
INSERT INTO bjk_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ma ixo top idi bira: ixo kawönö inabo tinenge möxöbo Judeia ma a lölös ne tinenge ne eöngat kö wawara xö nangadi. Meruso kölöme xöbo tinenge re God nang toxo geet, Apolos ixo öturunon bara Jisas ine a Mesaia. ");
INSERT INTO bjk_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nang e Apolos ixo xisixis Korin, Pol ixo muu a ngas i wan köröp kö öxöno raxin ma ixo wanot Epeses. Ma ringan ixo wanot pösöt abo tene tinam pe Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Ma ixo ose idi, “Mum moxo kip a Töxödös ne Tanono nang mum moxo nunu?” Idi toxo balu, “Kawaim, mem kaim kö ölangen bang bara re Töxödös ne Tanono i nangen.” ");
INSERT INTO bjk_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Io, Pol ixo ose bara, “Nang bara i biringan, a baptais sa iang mum moxo kip?” Idi toxo balu, “A baptais nang ke Jon.” ");
INSERT INTO bjk_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Me Pol ixo tengen, “A baptais nang ke Jon a baptais möxö dinödöm puxus mon. Ma ixo tengen te idi ra nunu xö öng nang irabo wanot melamu re ine, ine e Jisas.” ");
INSERT INTO bjk_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bere idi toxo ölangen ina na, idi toxo kip baptais kö esene a Orong e Jisas. ");
INSERT INTO bjk_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ma nang e Pol ixo bulus a limine lömö ridi, a Töxödös ne Tanono ixo wan su urungan tidi, me idi toxo rengrenge mabo tinenge xabise me idi toxo palas tinenge xarnang abo propet. ");
INSERT INTO bjk_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ma ixo eöt ma sangaun ma ninöng ne duöng suxurno xirip. ");
INSERT INTO bjk_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol ibo önan laxa xö gunon ne sineseng köbo Judeia ma ibo rengrenge ringan ma kaim pe binuut eöt ma narun ne texe. Ma ixo egot ma ixo sat abo dinödöm pidi ulamun a kingdom kö God. ");
INSERT INTO bjk_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Inexalik bara dauleng ke idi toxo ölölös a baladi ma toxo mölök bara tabo nunu. Me idi toxo tengen ögarin a Ngas nang kö Orong kö wawara xö marakörö. Io, Pol ixo wan lie idi ma ixo lamus lo abo tene tinam pe Jisas, me idi tobo wöwörö xöbo bungbung kirip kölöme xö gunon ausu re Tiranus. ");
INSERT INTO bjk_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Idi toxo wewet bira i eöt ma nine awat, io, abo Judeia mabo Grik kirip ewe nang toxo xisixis kö provins Esia toxo ölangen a tinenge xö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God ixo pet abo mangana lalaa lölös ne auwuwus saxit kölöme xö tinörön te Pol. ");
INSERT INTO bjk_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Io, ma boxönö subana man nang e Pol ibo sisige, idi tobo xikip lo urungan köbo miniset, me idi tobo sigii ma tobo langlanga, mabo tano saban tobo önan su xalik idi. ");
INSERT INTO bjk_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A dauleng ne Judeia, ewe idi toxo önan nana ma toxo iiwes nanin abo tano saban, idi tobo mamaa rua rengrengen a esene Jisas a Orong kua iiwes abo tano saban nang ibo rutup pidi. Idi tobo rengrengen bira, “Xö esene Jisas nang e Pol ibo rengrengen, e tengen te nöngön bara örö wan su.” ");
INSERT INTO bjk_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","A pitnö ma ninöng ne barok ke Sewa, a pris taxin mee Judeia, idi tobo wewet ina na. ");
INSERT INTO bjk_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Önga bung, önga tano saban ixo ose idi bira, “E ösöxö ewe e Jisas me e re maras lamun e Pol, nexalik bara ewenene e mum?” ");
INSERT INTO bjk_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Io, a tödi ewe nang a tano saban ixo tup pine ixo kos kaa lömö ridi ma ixo se ögarin idi. Idi toxo ulo rup kalik a gunon tine ma belbele ma ruxuruk kö aine idi. ");
INSERT INTO bjk_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nang abo Judeia mabo Grik meringan Epeses toxo see lo ina tinenge, a binuut taxin ixo kip idi me idi toxo ii öraxin a esene Jisas a Orong. ");
INSERT INTO bjk_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ma oleleng ke idi nang ewe idi toxo nunu, toxo wanot ma toxo tengen ösu abo magingin saban te idi xö wawara re idi a nangadi. ");
INSERT INTO bjk_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Io, ma oleleng ewe idi nang tobo wewet sewuk, toxo kip etok abo ginigeet möxöbo tinenge re idi ma toxo söngöt kö ia xö wawara xö nangadi nang toxo ot. Ma nang toxo kos arixin a xinixun möxö nang, ixo eöt ma pitnö ne sangaun ne arip ne tuluwok ne siliwa. ");
INSERT INTO bjk_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Io, xö ina ngas na, a tinenge xö Orong ixo wan esexere xirip ma ixo ot arixe ma lölös. ");
INSERT INTO bjk_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Melamu xinabo lalaa nang ixo wanot, a Töxödös ne Tanono ixo silien e Pol kö dinödöm rua nuan urungan Jerusalem. Me ine ixo wan kaluluonin e Masedonia me Akaia. Me Pol ixo tengen, “Melamu xö inot te e ringan, e rabo mana uxileng e Rom bölök.” ");
INSERT INTO bjk_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ine ixo tile a nine tene rorop pine, e Timoti me Erastus urungan Masedonia. Me ine ixo xisixis bang im pingan kö provins Esia. ");
INSERT INTO bjk_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Xö ina axana bung a tiip taxin ixo wanot lamun a Ngas kö Orong. ");
INSERT INTO bjk_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ma önga tene pet laa ma siliwa, a esene e Demitirius. Ine ibo rörörön ma siliwa rua wewet puo abo perewuo lixilik xarnang a gunon lotu re god une e Atemas. Ma tinörön te ine ibo wewet abo tene tinörön tobo xikip a tuluwok taxin. ");
INSERT INTO bjk_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Me ine ixo kuwe etok abo tene tinörön te ine xirip arixe ma önga uleng nang a tinörön te idi i xarnang ke ine ma ixo tengen bira, “A nangadi, mum mo ösöxö tuar bere ire te rörön lo a tuluwok taxin möxö inabo tinörön na. ");
INSERT INTO bjk_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Me mum moxoro pere ma moxoro ölangen a lasa ina tödi na e Pol, ixo wewet. Ine i rengrengen bara inabo perewuo ewe nang a tödi i pet, i kobo god tunon arixe. Me ine iri lamus tewe a oleleng ne nangadi, ma kaim bara mera xalik Epeses, inexalik kö boxönö xirip mee provins Esia. ");
INSERT INTO bjk_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kaim bara xö tinörön te ire xalik irabo kip a ese saban, inexalik bölök bara a gunon lotu re god une e Atemas, ine nang i taxin saxit, irabo xarnang a laa tataun kö wawara xö nangadi. Ma ewe nang a nangadi xirip mee provins Esia ma öxöno lagunon tobo lolotu rine, ma na tabo ii ölik ine.” ");
INSERT INTO bjk_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Io, nang idi toxo ölangen ina tinenge, idi toxo laie xöba ma toxo urulo ra kinup bara, “Atemas mera Epeses, a lak taxin saxit ine!” ");
INSERT INTO bjk_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ma kaim kö ömat mon ma kinup taxin ixo wan esexere xirip kö lagunon taxin. A nangadi toxo töndik lo e Gaius me Aristarkus, a nine tödi Masedonia, ewe tobo önan arixe me Pol. Me idi toxo ewasak laxa arixe urungan kö xönö möxö aluon. ");
INSERT INTO bjk_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","E Pol ixo mamaa rua tinuu mesila xö marakörö, inexalik bara abo tene tinam möxö lotu kaim kö ömaraxen ine. ");
INSERT INTO bjk_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","A dauleng ne tödi raxin möxö ina provins, ewe abo ais se Pol, toxo tile tinenge rine ma toxo seng ine bara ganim ine ra nilaxa urungan kölöme xö xönö möxö nuan etok. ");
INSERT INTO bjk_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A marakörö niang toxo ot, idi toxo ngangao esexere. A uleng toxo xukup lamun önga lalaa, ma uleng lamun a önga laa xabise. Ma oleleng ke idi kaim iat ta ösöxö rösa bere idi toxo ot etok kingan. ");
INSERT INTO bjk_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Abo Judeia toxo sumen e Aleksenda urungan mesila xö marakörö, ma dauleng toxo döxömen bere ine iat mon. Io, ine ixo sasanga kaa ma limine rö idi rua ödödö, möxö ixo mamaa rua tinenge maras urungan te idi. ");
INSERT INTO bjk_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Inexalik nang idi toxo perexulen bere ine a Judeia, idi toxo kup arixe ma önga mangana kinup kalik mon bara, “Atemas nang mera Epeses, a lak taxin saxit ine!” Me idi toxo kup ömat a ulik bie. ");
INSERT INTO bjk_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Io, a kansel möxö lagunon taxin ixo tenge lölös sik kö marakörö me idi toxo kis ödödö. Ma ixo tengen, “Duöng mera Epeses, abo marakörö xirip mera xö öxöno lagunon te ösöxö bara lagunon taxin Epeses ibo werwere muu a gunon lotu re god une Atemas, ine nang i taxin saxit, ma a malalar te ine nang ixo subu su meriso xö balana kubu! ");
INSERT INTO bjk_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kawaim pe öng irabo töxö xö ina turunon, io, mum morobo mana kis ödödö ma ganim e mum pa öraran tua wewet tebo lalaa. ");
INSERT INTO bjk_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mum moxo lamus ot inabo tödi na ura, inexalik bara kawaim idu ra wulwulo rebo gunon lotu ma kaim idu ra wewet tebo tinenge saban lamun a god une re ire. ");
INSERT INTO bjk_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Io, nang bere Demitirius mabo tene tinörön te ine te bala kadik lamun te öng, abo gunon ne warkurai i tamasawang sik kua pet warkurai ma a tene pet warkurai nangen. Ma i eöt bara idi tabo osen ot kö malmalan abo lalaa nang idi te epuk nana min. ");
INSERT INTO bjk_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ma nang bara re laa angen bang mum mo mamaa rua tinenge min, io, morobo ötöxödös kö kinis etok i eöt mabo warkurai te ire. ");
INSERT INTO bjk_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","E tengen bira re mum, möxösa, ire te eöt ta xixip pe sasaban taxin lamun a tiip nang i wanot nixinen, möxösa, kaim pe unine möxönan. Ma nang tabo ose ire bara a lasa a unine tinuu arixe re ire ma kinup taxin nana, ire tekebeöt ta babalu re tinenge.” ");
INSERT INTO bjk_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Io, nang ine ixo tengen sik bira, ixo tile elixilixin ina marakörö nang toxo kis etok. ");
INSERT INTO bjk_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nang ina tiip möxö kinup taxin ixo kawöm, Pol ixo erile lamun abo tene tinam pe Jisas. Ma nang ine ixo öxaxat idi ixo tön lime arixe me idi ma ixo taru lo ra nuan u Masedonia. ");
INSERT INTO bjk_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ine ixo önan nana kölöme xinabo xönö, ma ixo öxaxat nanin a nangadi, ot nang ixo wanot Gris. ");
INSERT INTO bjk_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ma ixo xisixis singan kö narun ne texe. Mabo Judeia toxo epingit tua sese ine xö axana bung ixo mamaa rua kinaa xö mön u Siria, io, ixo döxömen bara irabo tawuxus baling kaluluonin a provins Masedonia. ");
INSERT INTO bjk_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ma inabo duöng na nang toxo wan arixe me ine, e Sopate a barok ke Pirus mee Beria, e Aristarkus me Sekundus idu mee Tesalonika, e Gaius me Timoti idu mee Derbe, me Tikikus me Toropimus meruso xö provins Esia. ");
INSERT INTO bjk_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Inabo duöng na toxo wan sila ma toxo kis xiset e maa ro Toroas. ");
INSERT INTO bjk_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Inexalik, maa moxo kakaa xö mön mee Pilipai, melamu xö Nien möxö Beret nang Kaim Is Könan. Ma malamu xö pitnö ne bung maa moxo wanot pösöt idi ro Toroas. Me mem moxo kis kö pitnö ma ninöng ne bung kingan. ");
INSERT INTO bjk_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kö sisila ne bung kö wik, mem moxo wanot etok kua pidik a beret. Me Pol ixo wöwörö xö nangadi ot kö luono dömön, möxösa, ine ixo eka nuan kö bung malamu. ");
INSERT INTO bjk_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Me mem moxo kis etok kö xönö nuso lömö xö gunon. Ma oleleng ne bibio ringan ee. ");
INSERT INTO bjk_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Önga guama, a esene e Jutikus, ixo kis masap sik kö önga marakalanga ma ixo paluso xisixis singan nang e Pol angen ixo wöwörö. Nang ixo paliso metmerim, ixo subu su meriso lömö saxit uri xö pu xina xönö ma toxo rarik lo ine ma ixoro met. ");
INSERT INTO bjk_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Io, Pol ixo wan su ma ixo maru lömö xö ina guama ma ixo pama ine. Io, ixo tengen, “Ganim e mum pa binuut. Iri to!” ");
INSERT INTO bjk_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Io, Pol ixo wan kaa baling uruso lömö xö gunon ma ixo pidik a beret ma ixo en arixe mabo tene nunu. Ine ixo wöwörö ömat tö idi ot nang a xaken ixo wan kaa, io, ixo wan lo im. ");
INSERT INTO bjk_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","A nangadi toxo lamus lo ina guama nang ixo to baling urungan kö gunon te ine, ma ina laa na ixo öxaxat idi. ");
INSERT INTO bjk_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Io, mem moxo wan sila xö mön me mem moxo ösö Asos, rua xikip basin lo e Pol meringan. Ine ixo tengen te mem pa wewet bira, möxösa, ine ixo önan kö pu. ");
INSERT INTO bjk_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ma nang ine ixo esuo me mem po Asos, mem moxo kip basin lo ine ma moxo wan u Mitilini. ");
INSERT INTO bjk_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ma xö bung kabise mem moxo wan lo meringan Mitilini ma moxo ot Kios, ma xö bung melamu mem moxo lies u Samos. Io, xö bung melamu xönan moxo ösö Miletus. ");
INSERT INTO bjk_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ixoro kubus a dinödöm bara irabo wan saxit Epeses, möxösa, i koxobo mamaa rua kinis ösaxit tebo bung kingan Esia, möxö ine ixo öraran uruso Jerusalem. Ma nang bara i eöt, ine i mamaa bara irabo wanot tingan kö bung möxö Pentikos. ");
INSERT INTO bjk_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Io, Pol ixo erile mee Miletus urungan lamun abo duöng sisila möxö lotu Epeses. ");
INSERT INTO bjk_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ma nang idi toxo wanot ixo tengen tö idi, “Mum iat mo ösöxö sik a turunon möxö axana bung e xo xisixis me mum, urulo xö sisila ne bung e xo wanot kö provins Esia. ");
